#!/usr/bin/env bash
echo -e "Exporting environment variables"
export ANSIBLE_SSH_ARGS="-o UserKnownHostsFile=/dev/null -o StrictHostKeyChecking=no -o ControlMaster=auto -o ControlPersist=30m -o ServerAliveInterval=64 -o ServerAliveCountMax=1024 -o Compression=no -o TCPKeepAlive=yes -o VerifyHostKeyDNS=no -o ForwardX11=no -o ForwardAgent=yes -o PreferredAuthentications=publickey -T"
export ANSIBLE_DISPLAY_FAILED_STDERR="True"
export ANSIBLE_FORKS="32"
export ANSIBLE_TIMEOUT="30"
export ANSIBLE_GATHER_TIMEOUT="45"
export ANSIBLE_SSH_RETRIES="3"
export ANSIBLE_PIPELINING="True"
export ANSIBLE_SCP_IF_SSH="True"
export ANSIBLE_REMOTE_USER="root"
export ANSIBLE_STDOUT_CALLBACK="tripleo_dense"
export ANSIBLE_COLLECTIONS_PATHS="/usr/share/ansible/collections"
export ANSIBLE_LIBRARY="/usr/share/ansible/tripleo-plugins/modules:/usr/share/ansible/plugins/modules:/usr/share/ceph-ansible/library:/usr/share/ansible-modules:/usr/share/ansible/library"
export ANSIBLE_LOOKUP_PLUGINS="/usr/share/ansible/tripleo-plugins/lookup:/usr/share/ansible/plugins/lookup:/usr/share/ceph-ansible/plugins/lookup:/usr/share/ansible/lookup_plugins"
export ANSIBLE_CALLBACK_PLUGINS="/usr/share/ansible/tripleo-plugins/callback:/usr/share/ansible/plugins/callback:/usr/share/ceph-ansible/plugins/callback:/usr/share/ansible/callback_plugins"
export ANSIBLE_ACTION_PLUGINS="/usr/share/ansible/tripleo-plugins/action:/usr/share/ansible/plugins/action:/usr/share/ceph-ansible/plugins/actions:/usr/share/ansible/action_plugins"
export ANSIBLE_FILTER_PLUGINS="/usr/share/ansible/tripleo-plugins/filter:/usr/share/ansible/plugins/filter:/usr/share/ceph-ansible/plugins/filter:/usr/share/ansible/filter_plugins"
export ANSIBLE_ROLES_PATH="/usr/share/ansible/tripleo-roles:/usr/share/ansible/roles:/usr/share/ceph-ansible/roles:/etc/ansible/roles:/usr/share/ansible/roles"
export ANSIBLE_CALLBACK_WHITELIST="tripleo_dense,tripleo_profile_tasks,tripleo_states"
export ANSIBLE_RETRY_FILES_ENABLED="False"
export ANSIBLE_HOST_KEY_CHECKING="False"
export ANSIBLE_TRANSPORT="smart"
export ANSIBLE_CACHE_PLUGIN_TIMEOUT="7200"
export ANSIBLE_INJECT_FACT_VARS="False"
export ANSIBLE_VARS_PLUGIN_STAGE="all"
export ANSIBLE_GATHER_SUBSET="!all,min"
export ANSIBLE_GATHERING="smart"
export TRIPLEO_PLAN_NAME="overcloud"
export ANSIBLE_LOG_PATH="/home/zuul/ansible.log"
export SHELL="/bin/bash"
export CLOUDPROMPT_ENABLED="1"
export OS_CLOUD="overcloud"
export MANILA_ENABLED="true"
export EDPM_COMPUTE_CELLS="3"
export INTERFACE_MTU="1450"
export PWD="/home/zuul"
export LOGNAME="zuul"
export XDG_SESSION_TYPE="tty"
export CLOUD_DOMAIN="ooo.test"
export MOTD_SHOWN="pam"
export HOME="/home/zuul"
export LANG="C.UTF-8"
export RH_REGISTRY_USER=""
export DESIGNATE_ENABLED="false"
export HOST_PRIMARY_RESOLV_CONF_ENTRY="192.168.122.10"
export SSH_CONNECTION="192.168.122.11 57876 192.168.122.100 22"
export IP="192.168.122.100"
export XDG_SESSION_CLASS="user"
export EDPM_CONFIGURE_HUGEPAGES="false"
export SELINUX_ROLE_REQUESTED=""
export GATEWAY="192.168.122.10"
export TRIPLEO_NETWORKING="false"
export LESSOPEN="||/usr/bin/lesspipe.sh %s"
export USER="zuul"
export OCTAVIA_ENABLED="false"
export EDPM_COMPUTE_CEPH_ENABLED="False"
export TELEMETRY_ENABLED="false"
export TRIPLEO_CONFIGURE_DEFAULT_ROUTE="false"
export TLSE_ENABLED="false"
export SELINUX_USE_CURRENT_RANGE=""
export SHLVL="2"
export NTP_SERVER="pool.ntp.org"
export XDG_SESSION_ID="38"
export EDPM_COMPUTE_CEPH_NOVA="False"
export XDG_RUNTIME_DIR="/run/user/1000"
export PS1="${OS_CLOUD:+($OS_CLOUD)} "
export SSH_CLIENT="192.168.122.11 57876 22"
export CEPH_ARGS="-e /home/zuul/deployed_ceph.yaml -e /usr/share/openstack-tripleo-heat-templates/environments/cephadm/cephadm-rbd-only.yaml"
export which_declare="declare -f"
export TRIPLEO_ATTACH_EXTNET="false"
export RH_REGISTRY_PWD=""
export PATH="/home/zuul/.local/bin:/home/zuul/bin:/usr/local/bin:/usr/bin:/usr/local/sbin:/usr/sbin"
export SELINUX_LEVEL_REQUESTED=""
export ROLES_FILE="/home/zuul/overcloud_roles.yaml"
export DBUS_SESSION_BUS_ADDRESS="unix:path=/run/user/1000/bus"
export OLDPWD="/home/zuul"
export BASH_FUNC_which%%="() {  ( alias;
 eval ${which_declare} ) | /usr/bin/which --tty-only --read-alias --read-functions --show-tilde --show-dot $@
}"
export _="/usr/bin/openstack"
export OS_HEAT_TYPE="ephemeral"
export OS_HEAT_HOST="127.0.0.1"
export OS_HEAT_PORT="8006"
export ANSIBLE_CONFIG="/home/zuul/overcloud-deploy/cell1/cli-grant-local-access/ansible.cfg"
echo -e "Running Ansible command"
ansible-playbook -i /home/zuul/overcloud-deploy/cell1/cli-grant-local-access/hosts.yaml -e '{"access_path":"/home/zuul/overcloud-deploy/cell1/config-download","execution_user":"zuul"}' /usr/share/ansible/tripleo-playbooks/cli-grant-local-access.yaml "$@"
