/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `aodh`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `aodh` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `aodh`;

--
-- Table structure for table `alarm`
--

DROP TABLE IF EXISTS `alarm`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alarm` (
  `alarm_id` varchar(128) NOT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `name` text DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `severity` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `timestamp` datetime(6) DEFAULT NULL,
  `user_id` varchar(128) DEFAULT NULL,
  `project_id` varchar(128) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `state_reason` text DEFAULT NULL,
  `state_timestamp` datetime(6) DEFAULT NULL,
  `ok_actions` text DEFAULT NULL,
  `alarm_actions` text DEFAULT NULL,
  `insufficient_data_actions` text DEFAULT NULL,
  `repeat_actions` tinyint(1) DEFAULT NULL,
  `rule` text DEFAULT NULL,
  `time_constraints` text DEFAULT NULL,
  `evaluate_timestamp` datetime DEFAULT NULL,
  PRIMARY KEY (`alarm_id`),
  KEY `ix_alarm_type` (`type`),
  KEY `ix_alarm_user_id` (`user_id`),
  KEY `ix_alarm_project_id` (`project_id`),
  KEY `ix_alarm_enabled` (`enabled`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alarm`
--

LOCK TABLES `alarm` WRITE;
/*!40000 ALTER TABLE `alarm` DISABLE KEYS */;
/*!40000 ALTER TABLE `alarm` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alarm_history`
--

DROP TABLE IF EXISTS `alarm_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alarm_history` (
  `event_id` varchar(128) NOT NULL,
  `alarm_id` varchar(128) DEFAULT NULL,
  `on_behalf_of` varchar(128) DEFAULT NULL,
  `project_id` varchar(128) DEFAULT NULL,
  `user_id` varchar(128) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `detail` text DEFAULT NULL,
  `timestamp` datetime(6) DEFAULT NULL,
  `severity` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`event_id`),
  KEY `ix_alarm_history_alarm_id` (`alarm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alarm_history`
--

LOCK TABLES `alarm_history` WRITE;
/*!40000 ALTER TABLE `alarm_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `alarm_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('007');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota`
--

DROP TABLE IF EXISTS `quota`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(128) DEFAULT NULL,
  `resource` varchar(50) DEFAULT NULL,
  `limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`),
  KEY `ix_quota_project_id_resource` (`project_id`,`resource`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota`
--

LOCK TABLES `quota` WRITE;
/*!40000 ALTER TABLE `quota` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `barbican`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `barbican` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `barbican`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('8c74e2d7f1ff');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authorities`
--

DROP TABLE IF EXISTS `certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `plugin_ca_id` text NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cas_project_fk` (`project_id`),
  CONSTRAINT `cas_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authorities`
--

LOCK TABLES `certificate_authorities` WRITE;
/*!40000 ALTER TABLE `certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authority_metadata`
--

DROP TABLE IF EXISTS `certificate_authority_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authority_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_certificate_authority_metadatum_uc` (`ca_id`,`key`),
  KEY `ix_certificate_authority_metadata_ca_id` (`ca_id`),
  KEY `ix_certificate_authority_metadata_key` (`key`),
  CONSTRAINT `certificate_authority_metadata_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authority_metadata`
--

LOCK TABLES `certificate_authority_metadata` WRITE;
/*!40000 ALTER TABLE `certificate_authority_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authority_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acl_users`
--

DROP TABLE IF EXISTS `container_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_container_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `container_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `container_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acl_users`
--

LOCK TABLES `container_acl_users` WRITE;
/*!40000 ALTER TABLE `container_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acls`
--

DROP TABLE IF EXISTS `container_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_operation_uc` (`container_id`,`operation`),
  KEY `ix_container_acls_container_id` (`container_id`),
  CONSTRAINT `container_acls_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acls`
--

LOCK TABLES `container_acls` WRITE;
/*!40000 ALTER TABLE `container_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_consumer_metadata`
--

DROP TABLE IF EXISTS `container_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `name` varchar(36) DEFAULT NULL,
  `URL` varchar(255) DEFAULT NULL,
  `data_hash` char(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_consumer_hashed_container_name_url_uc` (`data_hash`),
  KEY `ix_container_consumer_metadata_container_id` (`container_id`),
  KEY `ix_container_consumer_metadata_project_id` (`project_id`),
  KEY `values_index` (`container_id`,`name`,`URL`),
  CONSTRAINT `container_consumer_metadata_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_consumer_metadata_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_consumer_metadata`
--

LOCK TABLES `container_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `container_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_secret`
--

DROP TABLE IF EXISTS `container_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_secret` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `container_id` varchar(36) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_secret_name_uc` (`container_id`,`secret_id`,`name`),
  KEY `ix_container_secret_container_id` (`container_id`),
  KEY `ix_container_secret_secret_id` (`secret_id`),
  CONSTRAINT `container_secret_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_secret_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_secret`
--

LOCK TABLES `container_secret` WRITE;
/*!40000 ALTER TABLE `container_secret` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `containers`
--

DROP TABLE IF EXISTS `containers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `containers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('generic','rsa','dsa','certificate') DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_containers_project_id` (`project_id`),
  CONSTRAINT `containers_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `containers`
--

LOCK TABLES `containers` WRITE;
/*!40000 ALTER TABLE `containers` DISABLE KEYS */;
/*!40000 ALTER TABLE `containers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encrypted_data`
--

DROP TABLE IF EXISTS `encrypted_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encrypted_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `secret_id` varchar(36) NOT NULL,
  `kek_id` varchar(36) NOT NULL,
  `cypher_text` text DEFAULT NULL,
  `kek_meta_extended` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_encrypted_data_kek_id` (`kek_id`),
  KEY `ix_encrypted_data_secret_id` (`secret_id`),
  CONSTRAINT `encrypted_data_ibfk_1` FOREIGN KEY (`kek_id`) REFERENCES `kek_data` (`id`),
  CONSTRAINT `encrypted_data_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encrypted_data`
--

LOCK TABLES `encrypted_data` WRITE;
/*!40000 ALTER TABLE `encrypted_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `encrypted_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kek_data`
--

DROP TABLE IF EXISTS `kek_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kek_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `kek_label` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `bind_completed` tinyint(1) NOT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `plugin_meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_kek_data_project_id` (`project_id`),
  CONSTRAINT `kek_data_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kek_data`
--

LOCK TABLES `kek_data` WRITE;
/*!40000 ALTER TABLE `kek_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `kek_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_barbican_metadata`
--

DROP TABLE IF EXISTS `order_barbican_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_barbican_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_barbican_metadata_order_id` (`order_id`),
  CONSTRAINT `order_barbican_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_barbican_metadata`
--

LOCK TABLES `order_barbican_metadata` WRITE;
/*!40000 ALTER TABLE `order_barbican_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_barbican_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_plugin_metadata`
--

DROP TABLE IF EXISTS `order_plugin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_plugin_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_plugin_metadata_order_id` (`order_id`),
  CONSTRAINT `order_plugin_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_plugin_metadata`
--

LOCK TABLES `order_plugin_metadata` WRITE;
/*!40000 ALTER TABLE `order_plugin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_plugin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_retry_tasks`
--

DROP TABLE IF EXISTS `order_retry_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_retry_tasks` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `id` varchar(36) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `retry_task` text NOT NULL,
  `retry_at` datetime NOT NULL,
  `retry_args` text NOT NULL,
  `retry_kwargs` text NOT NULL,
  `retry_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_retry_tasks_order_id` (`order_id`),
  CONSTRAINT `order_retry_tasks_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_retry_tasks`
--

LOCK TABLES `order_retry_tasks` WRITE;
/*!40000 ALTER TABLE `order_retry_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_retry_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `error_status_code` varchar(16) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  `secret_id` varchar(36) DEFAULT NULL,
  `container_id` varchar(36) DEFAULT NULL,
  `sub_status` varchar(36) DEFAULT NULL,
  `sub_status_message` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_orders_container_id` (`container_id`),
  KEY `ix_orders_project_id` (`project_id`),
  KEY `ix_orders_secret_id` (`secret_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`),
  CONSTRAINT `orders_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preferred_certificate_authorities`
--

DROP TABLE IF EXISTS `preferred_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `preferred_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_preferred_certificate_authorities_project_id` (`project_id`),
  KEY `ix_preferred_certificate_authorities_ca_id` (`ca_id`),
  CONSTRAINT `preferred_certificate_authorities_fk` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `preferred_certificate_authorities_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preferred_certificate_authorities`
--

LOCK TABLES `preferred_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `preferred_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `preferred_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_certificate_authorities`
--

DROP TABLE IF EXISTS `project_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_certificate_authority_uc` (`project_id`,`ca_id`),
  KEY `ix_project_certificate_authorities_ca_id` (`ca_id`),
  KEY `ix_project_certificate_authorities_project_id` (`project_id`),
  CONSTRAINT `project_certificate_authorities_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `project_certificate_authorities_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_certificate_authorities`
--

LOCK TABLES `project_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `project_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_quotas`
--

DROP TABLE IF EXISTS `project_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_quotas` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `secrets` int(11) DEFAULT NULL,
  `orders` int(11) DEFAULT NULL,
  `containers` int(11) DEFAULT NULL,
  `consumers` int(11) DEFAULT NULL,
  `cas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_project_quotas_project_id` (`project_id`),
  CONSTRAINT `project_quotas_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_quotas`
--

LOCK TABLES `project_quotas` WRITE;
/*!40000 ALTER TABLE `project_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_secret_store`
--

DROP TABLE IF EXISTS `project_secret_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_secret_store` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_store_id` varchar(36) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_secret_store_project_uc` (`project_id`),
  KEY `ix_project_secret_store_project_id` (`project_id`),
  KEY `ix_project_secret_store_secret_store_id` (`secret_store_id`),
  CONSTRAINT `project_secret_store_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `project_secret_store_ibfk_2` FOREIGN KEY (`secret_store_id`) REFERENCES `secret_stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_secret_store`
--

LOCK TABLES `project_secret_store` WRITE;
/*!40000 ALTER TABLE `project_secret_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_secret_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `external_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acl_users`
--

DROP TABLE IF EXISTS `secret_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_secret_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `secret_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `secret_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acl_users`
--

LOCK TABLES `secret_acl_users` WRITE;
/*!40000 ALTER TABLE `secret_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acls`
--

DROP TABLE IF EXISTS `secret_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_operation_uc` (`secret_id`,`operation`),
  KEY `ix_secret_acls_secret_id` (`secret_id`),
  CONSTRAINT `secret_acls_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acls`
--

LOCK TABLES `secret_acls` WRITE;
/*!40000 ALTER TABLE `secret_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_consumer_metadata`
--

DROP TABLE IF EXISTS `secret_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `service` varchar(255) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_consumer_resource_uc` (`secret_id`,`service`,`resource_type`,`resource_id`),
  KEY `ix_secret_consumer_metadata_secret_id` (`secret_id`),
  KEY `ix_secret_consumer_metadata_resource_id` (`resource_id`),
  KEY `ix_secret_consumer_metadata_project_id` (`project_id`),
  CONSTRAINT `fk_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `secret_consumer_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_consumer_metadata`
--

LOCK TABLES `secret_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `secret_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_store_metadata`
--

DROP TABLE IF EXISTS `secret_store_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_store_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secret_store_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_store_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_store_metadata`
--

LOCK TABLES `secret_store_metadata` WRITE;
/*!40000 ALTER TABLE `secret_store_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_store_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_stores`
--

DROP TABLE IF EXISTS `secret_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_stores` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `store_plugin` varchar(255) NOT NULL,
  `crypto_plugin` varchar(255) DEFAULT NULL,
  `global_default` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_stores_name_uc` (`name`),
  UNIQUE KEY `_secret_stores_plugin_names_uc` (`store_plugin`,`crypto_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_stores`
--

LOCK TABLES `secret_stores` WRITE;
/*!40000 ALTER TABLE `secret_stores` DISABLE KEYS */;
INSERT INTO `secret_stores` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `store_plugin`, `crypto_plugin`, `global_default`, `name`) VALUES ('746fec1f-04bb-415d-af05-b97c301b6e22','2025-12-02 08:50:25','2025-12-02 08:50:25',NULL,0,'ACTIVE','store_crypto','simple_crypto',1,'Software Only Crypto');
/*!40000 ALTER TABLE `secret_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_user_metadata`
--

DROP TABLE IF EXISTS `secret_user_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_user_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_key_uc` (`secret_id`,`key`),
  KEY `ix_secret_user_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_user_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_user_metadata`
--

LOCK TABLES `secret_user_metadata` WRITE;
/*!40000 ALTER TABLE `secret_user_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_user_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secrets`
--

DROP TABLE IF EXISTS `secrets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secrets` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `secret_type` varchar(255) DEFAULT 'opaque',
  `expiration` datetime DEFAULT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secrets_project_id` (`project_id`),
  CONSTRAINT `secrets_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secrets`
--

LOCK TABLES `secrets` WRITE;
/*!40000 ALTER TABLE `secrets` DISABLE KEYS */;
/*!40000 ALTER TABLE `secrets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_keys`
--

DROP TABLE IF EXISTS `transport_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transport_keys` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `transport_key` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_keys`
--

LOCK TABLES `transport_keys` WRITE;
/*!40000 ALTER TABLE `transport_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `cinder`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `cinder` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `cinder`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('daa98075b90d');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment_specs`
--

DROP TABLE IF EXISTS `attachment_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_attachment_specs_attachment_id` (`attachment_id`),
  CONSTRAINT `attachment_specs_ibfk_1` FOREIGN KEY (`attachment_id`) REFERENCES `volume_attachment` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment_specs`
--

LOCK TABLES `attachment_specs` WRITE;
/*!40000 ALTER TABLE `attachment_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_metadata`
--

DROP TABLE IF EXISTS `backup_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_backup_metadata_backup_id` (`backup_id`),
  CONSTRAINT `backup_metadata_ibfk_1` FOREIGN KEY (`backup_id`) REFERENCES `backups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_metadata`
--

LOCK TABLES `backup_metadata` WRITE;
/*!40000 ALTER TABLE `backup_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `container` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fail_reason` varchar(255) DEFAULT NULL,
  `service_metadata` varchar(255) DEFAULT NULL,
  `service` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `object_count` int(11) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `temp_volume_id` varchar(36) DEFAULT NULL,
  `temp_snapshot_id` varchar(36) DEFAULT NULL,
  `num_dependent_backups` int(11) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `data_timestamp` datetime DEFAULT NULL,
  `restore_volume_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
INSERT INTO `backups` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `host`, `availability_zone`, `display_name`, `display_description`, `container`, `status`, `fail_reason`, `service_metadata`, `service`, `size`, `object_count`, `parent_id`, `temp_volume_id`, `temp_snapshot_id`, `num_dependent_backups`, `snapshot_id`, `data_timestamp`, `restore_volume_id`, `encryption_key_id`) VALUES ('2025-12-02 10:12:04','2025-12-02 10:12:08','2025-12-02 10:12:09',1,'1dfac898-5a4d-4748-bb9d-7632eaebceac','76722819-84a1-4dfa-a319-cf730a5648ab','f9daf1690e014a9d9bcc6e1662fa5439','10644498f24744ec828624bc952bff43','cinder-backup-0',NULL,'tempest-VolumesBackupsAdminTest-Backup-585214611',NULL,'backups','deleted',NULL,'{\"base\": \"volume-76722819-84a1-4dfa-a319-cf730a5648ab.backup.1dfac898-5a4d-4748-bb9d-7632eaebceac\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:12:04',NULL,NULL),('2025-12-02 10:15:42','2025-12-02 10:15:46','2025-12-02 10:15:47',1,'4cf692f7-1037-48a0-9666-8952e028fdb3','eb88c64a-7c29-421c-91ad-190ba7bbf450','0e5c738ba752455b908099b234a743a2','d858413a9b01463f96545916d2abe5ab','cinder-backup-0',NULL,NULL,NULL,'backups','deleted',NULL,'{\"base\": \"volume-eb88c64a-7c29-421c-91ad-190ba7bbf450.backup.dbe24aeb-ecb6-4934-932c-2604f6c5f0c6\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,'dbe24aeb-ecb6-4934-932c-2604f6c5f0c6',NULL,NULL,NULL,NULL,'2025-12-02 10:15:42',NULL,NULL),('2025-12-02 10:11:05','2025-12-02 10:11:14','2025-12-02 10:11:15',1,'5c9946f5-a221-4611-87c2-9116741008bb','63282360-dcd1-46ed-a05a-0d9a8b40b619','1aa9c42ce52647ac840d8264bfaa8bc0','3cb8897eac514c8791f32dc7c7f97664','cinder-backup-0',NULL,'tempest-VolumesBackupsV39Test-Backup-2080732110','tempest-volume-backup-description-510212455','backups','deleted',NULL,'{\"base\": \"volume-63282360-dcd1-46ed-a05a-0d9a8b40b619.backup.5c9946f5-a221-4611-87c2-9116741008bb\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:11:05',NULL,NULL),('2025-12-02 10:15:47','2025-12-02 10:15:50','2025-12-02 10:15:51',1,'a7910443-a28c-4a77-8918-f0ba3214ee67','eb88c64a-7c29-421c-91ad-190ba7bbf450','0e5c738ba752455b908099b234a743a2','d858413a9b01463f96545916d2abe5ab','cinder-backup-0',NULL,'tempest-VolumesBackupsTest-Backup-1974913274',NULL,'backups','deleted',NULL,'{\"base\": \"volume-eb88c64a-7c29-421c-91ad-190ba7bbf450.backup.dbe24aeb-ecb6-4934-932c-2604f6c5f0c6\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,'dbe24aeb-ecb6-4934-932c-2604f6c5f0c6',NULL,NULL,NULL,NULL,'2025-12-02 10:15:47',NULL,NULL),('2025-12-02 10:11:42','2025-12-02 10:11:58','2025-12-02 10:12:00',1,'a97915d7-8bec-441a-a834-34a6472a4134','6e49a843-0dfa-4a15-99de-f6c990ac2aed','f9daf1690e014a9d9bcc6e1662fa5439','10644498f24744ec828624bc952bff43','cinder-backup-0',NULL,'tempest-VolumesBackupsAdminTest-Backup-174935530',NULL,'backups','deleted',NULL,'{\"base\": \"volume-6e49a843-0dfa-4a15-99de-f6c990ac2aed.backup.a97915d7-8bec-441a-a834-34a6472a4134\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:11:42','b28a7a85-dd39-4bd4-8551-fe72ab7b54c1',NULL),('2025-12-02 10:11:42','2025-12-02 10:11:57','2025-12-02 10:11:57',1,'beb06818-844c-49d4-87a0-42d37681b174','6e49a843-0dfa-4a15-99de-f6c990ac2aed','185667f603a24eeda7f01ad1347aed97','1e90b030c2b247a7a33033ba004a83a5','cinder-backup-0','nova','tempest-VolumesBackupsAdminTest-Backup-174935530',NULL,'backups','deleted',NULL,'{\"base\": \"volume-6e49a843-0dfa-4a15-99de-f6c990ac2aed.backup.a97915d7-8bec-441a-a834-34a6472a4134\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,0,NULL,NULL,NULL,0,NULL,'2025-12-02 10:11:42',NULL,NULL),('2025-12-02 10:12:38','2025-12-02 10:12:54','2025-12-02 10:12:54',1,'c6d5502e-f7e9-4265-9f85-319900c7bf4e','e7b291f0-5337-403a-93d2-d7ade4ecb725','fb6c45ae0e4b4c359e6ea41cecfc33c8','b374ce45b6dc4bc5b2eac77a9216133f','cinder-backup-0',NULL,'tempest-VolumesSnapshotTestJSON-Backup-1373989551',NULL,'backups','deleted',NULL,NULL,'cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,'9db0dee4-3e58-4b54-b9df-699849460495','2025-12-02 10:12:37',NULL,NULL),('2025-12-02 10:15:38','2025-12-02 10:15:51','2025-12-02 10:15:53',1,'dbe24aeb-ecb6-4934-932c-2604f6c5f0c6','eb88c64a-7c29-421c-91ad-190ba7bbf450','0e5c738ba752455b908099b234a743a2','d858413a9b01463f96545916d2abe5ab','cinder-backup-0',NULL,'tempest-VolumesBackupsTest-Backup-1532564895',NULL,'backups','deleted',NULL,'{\"base\": \"volume-eb88c64a-7c29-421c-91ad-190ba7bbf450.backup.dbe24aeb-ecb6-4934-932c-2604f6c5f0c6\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,0,NULL,'2025-12-02 10:15:38',NULL,NULL),('2025-12-02 10:14:52','2025-12-02 10:15:02','2025-12-02 10:15:04',1,'dd303304-b521-40c8-84ea-b15913b3f063','985ad36b-4413-4129-a7fb-6c33ca008a44','0e5c738ba752455b908099b234a743a2','d858413a9b01463f96545916d2abe5ab','cinder-backup-0',NULL,'tempest-VolumesBackupsTest-Backup-1184356029',NULL,'backups','deleted',NULL,'{\"base\": \"volume-985ad36b-4413-4129-a7fb-6c33ca008a44.backup.dd303304-b521-40c8-84ea-b15913b3f063\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:52','fb26f3c4-7b9f-4e89-9327-d625b9a7aae0',NULL);
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cgsnapshots`
--

DROP TABLE IF EXISTS `cgsnapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cgsnapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `consistencygroup_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_cgsnapshots_consistencygroup_id` (`consistencygroup_id`),
  CONSTRAINT `cgsnapshots_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cgsnapshots`
--

LOCK TABLES `cgsnapshots` WRITE;
/*!40000 ALTER TABLE `cgsnapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `cgsnapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clusters`
--

DROP TABLE IF EXISTS `clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clusters` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`binary`,`race_preventer`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`disabled` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`frozen` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clusters`
--

LOCK TABLES `clusters` WRITE;
/*!40000 ALTER TABLE `clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consistencygroups`
--

DROP TABLE IF EXISTS `consistencygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consistencygroups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `volume_type_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `source_cgid` varchar(36) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consistencygroups`
--

LOCK TABLES `consistencygroups` WRITE;
/*!40000 ALTER TABLE `consistencygroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `consistencygroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_volume_types`
--

DROP TABLE IF EXISTS `default_volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `default_volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  KEY `ix_default_volume_types_volume_type_id` (`volume_type_id`),
  CONSTRAINT `default_volume_types_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_volume_types`
--

LOCK TABLES `default_volume_types` WRITE;
/*!40000 ALTER TABLE `default_volume_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver_initiator_data`
--

DROP TABLE IF EXISTS `driver_initiator_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `driver_initiator_data` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `initiator` (`initiator`,`namespace`,`key`),
  KEY `ix_driver_initiator_data_initiator` (`initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver_initiator_data`
--

LOCK TABLES `driver_initiator_data` WRITE;
/*!40000 ALTER TABLE `driver_initiator_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `driver_initiator_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encryption`
--

DROP TABLE IF EXISTS `encryption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encryption` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `cipher` varchar(255) DEFAULT NULL,
  `control_location` varchar(255) NOT NULL,
  `key_size` int(11) DEFAULT NULL,
  `provider` varchar(255) NOT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `encryption_id` varchar(36) NOT NULL,
  PRIMARY KEY (`encryption_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encryption`
--

LOCK TABLES `encryption` WRITE;
/*!40000 ALTER TABLE `encryption` DISABLE KEYS */;
INSERT INTO `encryption` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `cipher`, `control_location`, `key_size`, `provider`, `volume_type_id`, `encryption_id`) VALUES ('2025-12-02 10:07:45','2025-12-02 10:07:45','2025-12-02 10:07:45',1,'aes-xts-plain64','back-end',128,'SomeProvider','ffb6f438-e694-4844-a4b7-7e9861f89d90','cb83c961-5f68-4d7e-8818-a8d0040d3343');
/*!40000 ALTER TABLE `encryption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_snapshots`
--

DROP TABLE IF EXISTS `group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_snapshots_group_id` (`group_id`),
  KEY `group_snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `group_snapshots_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_snapshots`
--

LOCK TABLES `group_snapshots` WRITE;
/*!40000 ALTER TABLE `group_snapshots` DISABLE KEYS */;
INSERT INTO `group_snapshots` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `group_id`, `user_id`, `project_id`, `name`, `description`, `status`, `group_type_id`) VALUES ('2025-12-02 10:12:29','2025-12-02 10:12:31','2025-12-02 10:12:32',1,'28e88a83-8a08-406f-8a84-b50710050e8b','d798bb6d-134c-4110-b7cc-dc1cd7394229','655d9191fb2f408c917a6a9ed2235d2d','6b4f1f3dd8704e9992f1bc11c793a60e','tempest-GroupSnapshotsV319Test-Group_Snapshot-1341650730',NULL,'deleted','a6f721f1-6f7a-41c4-bdb8-359978e705fd'),('2025-12-02 10:08:20','2025-12-02 10:08:23','2025-12-02 10:08:26',1,'66e037b9-52ee-470e-b595-01d75219f6ea','71217c40-d3cb-4caf-8759-f7ca9bcf0b91','e106d79b62e54215bcadae87f431c1b2','6963976a36c6408c9336062feaef5d1f','tempest-GroupSnapshotsTest-Group_Snapshot-61574974',NULL,'deleted','da17fd7d-0e12-47a7-a441-c9b2bdc4e4c9'),('2025-12-02 10:08:02','2025-12-02 10:08:07','2025-12-02 10:08:08',1,'691970ab-9dc7-425a-9d55-766ba3aebd7a','dbc50bd7-a1d5-488b-9b8b-3c0d0cf3ad62','e106d79b62e54215bcadae87f431c1b2','6963976a36c6408c9336062feaef5d1f','tempest-group_snapshot-1384762168',NULL,'deleted','120e3a2b-2239-41ca-a6e0-f2fba625c0f0'),('2025-12-02 10:08:30','2025-12-02 10:08:32','2025-12-02 10:08:33',1,'db3be1b8-5c21-4f21-9265-75f9205b869b','78a46d4c-4b80-46bd-808a-6cd58c34caeb','e106d79b62e54215bcadae87f431c1b2','6963976a36c6408c9336062feaef5d1f','tempest-group_snapshot-1294064754',NULL,'deleted','c36b3454-41be-4b5c-90b0-6d120071d0ee');
/*!40000 ALTER TABLE `group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_projects`
--

DROP TABLE IF EXISTS `group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_type_id` (`group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `group_type_projects_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_projects`
--

LOCK TABLES `group_type_projects` WRITE;
/*!40000 ALTER TABLE `group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_specs`
--

DROP TABLE IF EXISTS `group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_type_specs_group_type_id` (`group_type_id`),
  CONSTRAINT `group_type_specs_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_specs`
--

LOCK TABLES `group_type_specs` WRITE;
/*!40000 ALTER TABLE `group_type_specs` DISABLE KEYS */;
INSERT INTO `group_type_specs` (`id`, `key`, `value`, `group_type_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (2,'consistent_group_snapshot_enabled','<is> True','345e6a6f-65bb-404a-b10b-4f58406bbf55','2025-12-02 08:13:24','2025-12-02 08:13:24',NULL,0),(5,'consistent_group_snapshot_enabled','<is> False','a54796b6-e86d-4ecb-8abb-334e4928d5b7','2025-12-02 10:08:44',NULL,'2025-12-02 10:08:44',1),(6,'key1','value1','48a8bf36-1b07-42fe-b12c-f4323f7f46f1','2025-12-02 10:13:07',NULL,'2025-12-02 10:13:07',1),(7,'key2','value2-updated','48a8bf36-1b07-42fe-b12c-f4323f7f46f1','2025-12-02 10:13:07','2025-12-02 10:13:07','2025-12-02 10:13:07',1),(8,'key3','value3-updated','48a8bf36-1b07-42fe-b12c-f4323f7f46f1','2025-12-02 10:13:07','2025-12-02 10:13:07','2025-12-02 10:13:07',1);
/*!40000 ALTER TABLE `group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_types`
--

DROP TABLE IF EXISTS `group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_types` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`is_public` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_types`
--

LOCK TABLES `group_types` WRITE;
/*!40000 ALTER TABLE `group_types` DISABLE KEYS */;
INSERT INTO `group_types` (`id`, `name`, `description`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `is_public`) VALUES ('120e3a2b-2239-41ca-a6e0-f2fba625c0f0','tempest-GroupSnapshotsTest-group-type-215677203',NULL,'2025-12-02 10:07:59',NULL,'2025-12-02 10:08:11',1,1),('2784f4f1-2a81-48c7-a68f-b1ee23df8a56','tempest-GroupsV314Test-group-type-904828459',NULL,'2025-12-02 10:13:47',NULL,'2025-12-02 10:13:55',1,1),('345e6a6f-65bb-404a-b10b-4f58406bbf55','default_cgsnapshot_type','Default group type for migrating cgsnapshot','2025-12-02 08:13:24','2025-12-02 08:13:24',NULL,0,1),('48a8bf36-1b07-42fe-b12c-f4323f7f46f1','tempest-GroupTypeSpecsTest-group-type-678077682',NULL,'2025-12-02 10:13:07',NULL,'2025-12-02 10:13:07',1,1),('49193350-0716-45ce-8d82-241a9fdff44d','tempest-GroupsTest-group-type-1937780866',NULL,'2025-12-02 10:13:19',NULL,'2025-12-02 10:13:28',1,1),('70f4007c-4956-441d-9a34-bc093b67ead4','tempest-GroupsTest-group-type-69487921',NULL,'2025-12-02 10:13:12',NULL,'2025-12-02 10:13:19',1,1),('a54796b6-e86d-4ecb-8abb-334e4928d5b7','tempest-GroupTypesTest-updated-group-type-1084370637','updated-group-type-desc','2025-12-02 10:08:44','2025-12-02 10:08:44','2025-12-02 10:08:44',1,1),('a6f721f1-6f7a-41c4-bdb8-359978e705fd','tempest-GroupSnapshotsV319Test-group-type-877430881',NULL,'2025-12-02 10:12:26',NULL,'2025-12-02 10:12:34',1,1),('c36b3454-41be-4b5c-90b0-6d120071d0ee','tempest-GroupSnapshotsTest-group-type-798498099',NULL,'2025-12-02 10:08:27',NULL,'2025-12-02 10:08:35',1,1),('ccd28747-4658-48e8-971e-3a822394129e','tempest-GroupsV320Test-group-type-783269959',NULL,'2025-12-02 10:06:30',NULL,'2025-12-02 10:06:33',1,1),('cffc6409-ab10-45ca-9136-955052f7a0b1','a_tempest-group-type-2081499680',NULL,'2025-12-02 10:08:44',NULL,'2025-12-02 10:08:45',1,1),('da17fd7d-0e12-47a7-a441-c9b2bdc4e4c9','tempest-GroupSnapshotsTest-group-type-1097385470',NULL,'2025-12-02 10:08:11',NULL,'2025-12-02 10:08:27',1,1),('f2aa4da2-362c-417e-ad3a-10cab1b57a4e','b_tempest-group-type-68007855',NULL,'2025-12-02 10:08:45',NULL,'2025-12-02 10:08:45',1,0);
/*!40000 ALTER TABLE `group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_volume_type_mapping`
--

DROP TABLE IF EXISTS `group_volume_type_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_volume_type_mapping` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_volume_type_mapping_volume_type_id` (`volume_type_id`),
  KEY `ix_group_volume_type_mapping_group_id` (`group_id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_volume_type_mapping`
--

LOCK TABLES `group_volume_type_mapping` WRITE;
/*!40000 ALTER TABLE `group_volume_type_mapping` DISABLE KEYS */;
INSERT INTO `group_volume_type_mapping` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_type_id`, `group_id`) VALUES ('2025-12-02 10:06:30',NULL,'2025-12-02 10:06:32',1,1,'2389989d-8f92-4f2b-8a8e-e38ad828dcbf','06958850-dab3-42e6-8e40-cdefee383242'),('2025-12-02 10:07:59',NULL,'2025-12-02 10:08:10',1,2,'76e7ac3c-8039-466a-8011-24ff10e9b99d','dbc50bd7-a1d5-488b-9b8b-3c0d0cf3ad62'),('2025-12-02 10:08:04',NULL,'2025-12-02 10:08:07',1,3,'76e7ac3c-8039-466a-8011-24ff10e9b99d','e9f33063-a47e-4398-aaa1-d1b5234cebfd'),('2025-12-02 10:08:11',NULL,'2025-12-02 10:08:27',1,4,'f0e8cfb1-538e-44db-a3d8-153ab63f83a0','71217c40-d3cb-4caf-8759-f7ca9bcf0b91'),('2025-12-02 10:08:28',NULL,'2025-12-02 10:08:35',1,5,'94d93296-ae39-48e1-95cb-44617d586e86','78a46d4c-4b80-46bd-808a-6cd58c34caeb'),('2025-12-02 10:12:26',NULL,'2025-12-02 10:12:34',1,6,'5264be6d-39ee-4356-a8c7-079164c1a2db','d798bb6d-134c-4110-b7cc-dc1cd7394229'),('2025-12-02 10:13:12',NULL,'2025-12-02 10:13:17',1,7,'a51d7016-0f53-441a-b5af-2dfdca536ce3','b705c94d-940f-49af-946e-57ca1cb9df09'),('2025-12-02 10:13:13',NULL,'2025-12-02 10:13:18',1,8,'a51d7016-0f53-441a-b5af-2dfdca536ce3','7f087bd3-e7b1-419f-8ca5-f5d018f72373'),('2025-12-02 10:13:19',NULL,'2025-12-02 10:13:27',1,9,'7dab706f-5f14-4388-bc71-6f51f27eb060','f7c8bb8c-d0c7-4709-b217-676e7c0faf1a'),('2025-12-02 10:13:47',NULL,'2025-12-02 10:13:54',1,10,'4d121018-c823-4af0-88b4-28bf24456334','9b9ca4f1-c8a7-41e6-80ed-5593b47ed878'),('2025-12-02 10:13:50',NULL,'2025-12-02 10:13:53',1,11,'4d121018-c823-4af0-88b4-28bf24456334','fb51ae5e-f2d5-427f-8578-3a4bb7add157');
/*!40000 ALTER TABLE `group_volume_type_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `groups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `source_group_id` varchar(36) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
INSERT INTO `groups` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `cluster_name`, `host`, `availability_zone`, `name`, `description`, `group_type_id`, `status`, `group_snapshot_id`, `source_group_id`, `replication_status`) VALUES ('2025-12-02 10:06:30','2025-12-02 10:06:32','2025-12-02 10:06:32',1,'06958850-dab3-42e6-8e40-cdefee383242','7c1f85a48a0842408bf0c15d176bbe24','39d049b7ae3640b1bc36845add7b4021',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupsV320Test-Group-189400747',NULL,'ccd28747-4658-48e8-971e-3a822394129e','deleted',NULL,NULL,'disabled'),('2025-12-02 10:08:11','2025-12-02 10:08:27','2025-12-02 10:08:27',1,'71217c40-d3cb-4caf-8759-f7ca9bcf0b91','e106d79b62e54215bcadae87f431c1b2','6963976a36c6408c9336062feaef5d1f',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupSnapshotsTest-Group-588559954',NULL,'da17fd7d-0e12-47a7-a441-c9b2bdc4e4c9','deleted',NULL,NULL,'disabled'),('2025-12-02 10:08:28','2025-12-02 10:08:35','2025-12-02 10:08:35',1,'78a46d4c-4b80-46bd-808a-6cd58c34caeb','e106d79b62e54215bcadae87f431c1b2','6963976a36c6408c9336062feaef5d1f',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupSnapshotsTest-Group-1982278932',NULL,'c36b3454-41be-4b5c-90b0-6d120071d0ee','deleted',NULL,NULL,'disabled'),('2025-12-02 10:13:13','2025-12-02 10:13:18','2025-12-02 10:13:18',1,'7f087bd3-e7b1-419f-8ca5-f5d018f72373','e49255efa5ee433ebbe2d2dcf29d2667','8ff22a276ec5464e8a97c8b3b0e8806c',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-Group2-934029251',NULL,'70f4007c-4956-441d-9a34-bc093b67ead4','deleted',NULL,NULL,'disabled'),('2025-12-02 10:13:47','2025-12-02 10:13:54','2025-12-02 10:13:54',1,'9b9ca4f1-c8a7-41e6-80ed-5593b47ed878','1ea4e58d0f6b4f2a841e8a5da7272bdd','69ac27088e5c47cabe1441ecc9b19c84',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupsV314Test-Group-1369054646',NULL,'2784f4f1-2a81-48c7-a68f-b1ee23df8a56','deleted',NULL,NULL,'disabled'),('2025-12-02 10:13:12','2025-12-02 10:13:17','2025-12-02 10:13:17',1,'b705c94d-940f-49af-946e-57ca1cb9df09','e49255efa5ee433ebbe2d2dcf29d2667','8ff22a276ec5464e8a97c8b3b0e8806c',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-Group1-1439664942',NULL,'70f4007c-4956-441d-9a34-bc093b67ead4','deleted',NULL,NULL,'disabled'),('2025-12-02 10:12:27','2025-12-02 10:12:34','2025-12-02 10:12:34',1,'d798bb6d-134c-4110-b7cc-dc1cd7394229','655d9191fb2f408c917a6a9ed2235d2d','6b4f1f3dd8704e9992f1bc11c793a60e',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupSnapshotsV319Test-Group-366505408',NULL,'a6f721f1-6f7a-41c4-bdb8-359978e705fd','deleted',NULL,NULL,'disabled'),('2025-12-02 10:07:59','2025-12-02 10:08:10','2025-12-02 10:08:10',1,'dbc50bd7-a1d5-488b-9b8b-3c0d0cf3ad62','e106d79b62e54215bcadae87f431c1b2','6963976a36c6408c9336062feaef5d1f',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupSnapshotsTest-Group-1290858655',NULL,'120e3a2b-2239-41ca-a6e0-f2fba625c0f0','deleted',NULL,NULL,'disabled'),('2025-12-02 10:08:05','2025-12-02 10:08:07','2025-12-02 10:08:07',1,'e9f33063-a47e-4398-aaa1-d1b5234cebfd','e106d79b62e54215bcadae87f431c1b2','6963976a36c6408c9336062feaef5d1f',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-Group_from_snap-1642786125',NULL,'120e3a2b-2239-41ca-a6e0-f2fba625c0f0','deleted','691970ab-9dc7-425a-9d55-766ba3aebd7a',NULL,'disabled'),('2025-12-02 10:13:19','2025-12-02 10:13:27','2025-12-02 10:13:27',1,'f7c8bb8c-d0c7-4709-b217-676e7c0faf1a','e49255efa5ee433ebbe2d2dcf29d2667','8ff22a276ec5464e8a97c8b3b0e8806c',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','new_group','This is a new group','49193350-0716-45ce-8d82-241a9fdff44d','deleted',NULL,NULL,'disabled'),('2025-12-02 10:13:51','2025-12-02 10:13:53','2025-12-02 10:13:53',1,'fb51ae5e-f2d5-427f-8578-3a4bb7add157','1ea4e58d0f6b4f2a841e8a5da7272bdd','69ac27088e5c47cabe1441ecc9b19c84',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-Group_from_grp-1224808148',NULL,'2784f4f1-2a81-48c7-a68f-b1ee23df8a56','deleted',NULL,'9b9ca4f1-c8a7-41e6-80ed-5593b47ed878','disabled');
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_volume_cache_entries`
--

DROP TABLE IF EXISTS `image_volume_cache_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_volume_cache_entries` (
  `image_updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `image_id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `size` int(11) NOT NULL,
  `last_used` datetime NOT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_volume_cache_entries_image_id` (`image_id`),
  KEY `ix_image_volume_cache_entries_host` (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_volume_cache_entries`
--

LOCK TABLES `image_volume_cache_entries` WRITE;
/*!40000 ALTER TABLE `image_volume_cache_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_volume_cache_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(36) DEFAULT NULL,
  `resource_uuid` varchar(255) DEFAULT NULL,
  `event_id` varchar(255) NOT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `action_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_messages_expires_at` (`expires_at`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
INSERT INTO `messages` (`id`, `project_id`, `request_id`, `resource_type`, `resource_uuid`, `event_id`, `message_level`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `expires_at`, `detail_id`, `action_id`) VALUES ('171d29bb-4741-4482-8f0b-3d25396b8c78','88ada1dc04884eb0b3013bc2d2c4917c','req-8c7b3e07-6be7-4a1e-9243-16856b319611','VOLUME','4cf4d3c1-86b4-4955-84e0-f2ca476b3a7f','VOLUME_VOLUME_001_003','ERROR','2025-12-02 10:08:58',NULL,'2025-12-02 10:08:59',1,'2026-01-01 10:08:58','003','001'),('9e341a5a-2eed-417f-a88d-f443c0ed65db','88ada1dc04884eb0b3013bc2d2c4917c','req-d315b71c-17ac-414f-9e5f-8f1f1fc235b9','VOLUME','908a0b16-c7ec-4039-a8f1-12c722afd577','VOLUME_VOLUME_001_003','ERROR','2025-12-02 10:08:56',NULL,'2025-12-02 10:08:57',1,'2026-01-01 10:08:56','003','001');
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrate_version`
--

DROP TABLE IF EXISTS `migrate_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrate_version` (
  `repository_id` varchar(250) NOT NULL,
  `repository_path` text DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`repository_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrate_version`
--

LOCK TABLES `migrate_version` WRITE;
/*!40000 ALTER TABLE `migrate_version` DISABLE KEYS */;
INSERT INTO `migrate_version` (`repository_id`, `repository_path`, `version`) VALUES ('cinder','/usr/lib/python3.9/site-packages/cinder/db/sqlalchemy/migrate_repo',145);
/*!40000 ALTER TABLE `migrate_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quality_of_service_specs`
--

DROP TABLE IF EXISTS `quality_of_service_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quality_of_service_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `specs_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quality_of_service_specs_specs_id` (`specs_id`),
  CONSTRAINT `quality_of_service_specs_ibfk_1` FOREIGN KEY (`specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quality_of_service_specs`
--

LOCK TABLES `quality_of_service_specs` WRITE;
/*!40000 ALTER TABLE `quality_of_service_specs` DISABLE KEYS */;
INSERT INTO `quality_of_service_specs` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `specs_id`, `key`, `value`) VALUES ('2025-12-02 10:14:00',NULL,'2025-12-02 10:14:00',1,'15827d38-05a6-4b67-beb7-d51a3559ef40','21f52cf6-6106-4b7c-8560-30278a4e8ab3','consumer','both'),('2025-12-02 10:14:00',NULL,'2025-12-02 10:14:00',1,'21f52cf6-6106-4b7c-8560-30278a4e8ab3',NULL,'QoS_Specs_Name','tempest-QosSpecsTestJSON-qos-1876590714'),('2025-12-02 10:14:00',NULL,'2025-12-02 10:14:01',1,'32af29c0-9980-47b1-9b63-df9a73fe3b53','8ad8444c-ef6b-458c-99ab-58224df53d1d','consumer','front-end'),('2025-12-02 10:14:00',NULL,'2025-12-02 10:14:01',1,'3460e6d4-fc44-4387-8462-e7d5d5fda565',NULL,'QoS_Specs_Name','tempest-QosSpecsTestJSON-QoS-849850079'),('2025-12-02 10:14:00',NULL,'2025-12-02 10:14:00',1,'57d5492c-3d85-4a9d-a651-56db04cd0dd8','a77d82bb-9879-4e56-b19e-cdf5dc68e668','consumer','back-end'),('2025-12-02 10:14:01',NULL,'2025-12-02 10:14:01',1,'6e89e936-e56e-4c5a-87d4-336d562408c1','3460e6d4-fc44-4387-8462-e7d5d5fda565','iops_bytes','500'),('2025-12-02 10:14:00',NULL,'2025-12-02 10:14:01',1,'8ad8444c-ef6b-458c-99ab-58224df53d1d',NULL,'QoS_Specs_Name','tempest-QosSpecsTestJSON-qos-521787732'),('2025-12-02 10:14:00',NULL,'2025-12-02 10:14:01',1,'91bac941-15dd-4f5e-a5e8-21b9f0ba2a35','3460e6d4-fc44-4387-8462-e7d5d5fda565','consumer','front-end'),('2025-12-02 10:14:00',NULL,'2025-12-02 10:14:01',1,'a021044f-f2e2-4025-8f75-7a943b44535c','3460e6d4-fc44-4387-8462-e7d5d5fda565','read_iops_sec','2000'),('2025-12-02 10:14:00',NULL,'2025-12-02 10:14:00',1,'a77d82bb-9879-4e56-b19e-cdf5dc68e668',NULL,'QoS_Specs_Name','tempest-QosSpecsTestJSON-qos-302104738');
/*!40000 ALTER TABLE `quality_of_service_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
INSERT INTO `quota_classes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `class_name`, `resource`, `hard_limit`) VALUES ('2025-12-02 08:13:19','2025-12-02 10:07:00',NULL,0,2,'default','volumes',10),('2025-12-02 08:13:19','2025-12-02 10:07:00',NULL,0,5,'default','snapshots',10),('2025-12-02 08:13:19','2025-12-02 10:07:01',NULL,0,8,'default','gigabytes',1000),('2025-12-02 08:13:19',NULL,NULL,0,11,'default','consistencygroups',10),('2025-12-02 08:13:19',NULL,NULL,0,14,'default','per_volume_gigabytes',-1),('2025-12-02 08:13:19',NULL,NULL,0,17,'default','groups',10),('2025-12-02 10:06:58','2025-12-02 10:07:02',NULL,0,20,'default','backups',10),('2025-12-02 10:06:58','2025-12-02 10:07:02',NULL,0,21,'default','backup_gigabytes',1000),('2025-12-02 10:06:58',NULL,NULL,0,22,'default','volumes_tempest-VolumeQuotaClassesTest-volume-type-1529597337',3),('2025-12-02 10:06:58',NULL,NULL,0,23,'default','snapshots_tempest-VolumeQuotaClassesTest-volume-type-1529597337',5),('2025-12-02 10:06:58',NULL,NULL,0,24,'default','gigabytes_tempest-VolumeQuotaClassesTest-volume-type-1529597337',7);
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(300) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `race_preventer` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `quota_usages_project_id_key` (`project_id`,`resource`,`race_preventer`),
  KEY `quota_usage_project_resource_idx` (`project_id`,`resource`),
  KEY `ix_quota_usages_project_id` (`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=224 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
INSERT INTO `quota_usages` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `project_id`, `resource`, `in_use`, `reserved`, `until_refresh`, `race_preventer`) VALUES ('2025-12-02 10:06:30','2025-12-02 10:06:32',NULL,0,1,'39d049b7ae3640b1bc36845add7b4021','groups',0,0,NULL,1),('2025-12-02 10:06:42','2025-12-02 10:07:07',NULL,0,2,'1e139fe20a514d12b866b3c8974dcebd','volumes',0,0,NULL,1),('2025-12-02 10:06:42','2025-12-02 10:07:07',NULL,0,3,'1e139fe20a514d12b866b3c8974dcebd','gigabytes',0,0,NULL,1),('2025-12-02 10:06:42','2025-12-02 10:07:07',NULL,0,4,'1e139fe20a514d12b866b3c8974dcebd','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:06:42','2025-12-02 10:07:07',NULL,0,5,'1e139fe20a514d12b866b3c8974dcebd','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:06:46','2025-12-02 10:07:05',NULL,0,6,'1e139fe20a514d12b866b3c8974dcebd','snapshots',0,0,NULL,1),('2025-12-02 10:06:46','2025-12-02 10:07:05',NULL,0,7,'1e139fe20a514d12b866b3c8974dcebd','snapshots_tripleo',0,0,NULL,1),('2025-12-02 10:07:17','2025-12-02 10:07:21',NULL,0,8,'ef69e828801540619536106b3b481b20','volumes',0,0,NULL,1),('2025-12-02 10:07:17','2025-12-02 10:07:21',NULL,0,9,'ef69e828801540619536106b3b481b20','gigabytes',0,0,NULL,1),('2025-12-02 10:07:17','2025-12-02 10:07:19',NULL,0,10,'ef69e828801540619536106b3b481b20','volumes_volume-type-1',0,0,NULL,1),('2025-12-02 10:07:17','2025-12-02 10:07:19',NULL,0,11,'ef69e828801540619536106b3b481b20','gigabytes_volume-type-1',0,0,NULL,1),('2025-12-02 10:07:19','2025-12-02 10:07:21',NULL,0,12,'ef69e828801540619536106b3b481b20','volumes_volume-type-2',0,0,NULL,1),('2025-12-02 10:07:19','2025-12-02 10:07:21',NULL,0,13,'ef69e828801540619536106b3b481b20','gigabytes_volume-type-2',0,0,NULL,1),('2025-12-02 10:07:20','2025-12-02 10:07:28',NULL,0,14,'0b96bacd92de4f1aa310d96b02e2ba1b','volumes',0,0,NULL,1),('2025-12-02 10:07:20','2025-12-02 10:07:28',NULL,0,15,'0b96bacd92de4f1aa310d96b02e2ba1b','gigabytes',0,0,NULL,1),('2025-12-02 10:07:20','2025-12-02 10:07:28',NULL,0,16,'0b96bacd92de4f1aa310d96b02e2ba1b','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:07:20','2025-12-02 10:07:28',NULL,0,17,'0b96bacd92de4f1aa310d96b02e2ba1b','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:07:22','2025-12-02 10:07:25',NULL,0,18,'00428a58903e487bb33ddf74c19e4f17','volumes',0,0,NULL,1),('2025-12-02 10:07:22','2025-12-02 10:07:25',NULL,0,19,'00428a58903e487bb33ddf74c19e4f17','gigabytes',0,0,NULL,1),('2025-12-02 10:07:22','2025-12-02 10:07:25',NULL,0,20,'00428a58903e487bb33ddf74c19e4f17','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:07:22','2025-12-02 10:07:25',NULL,0,21,'00428a58903e487bb33ddf74c19e4f17','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:07:22',NULL,NULL,0,22,'00428a58903e487bb33ddf74c19e4f17','snapshots',0,0,NULL,1),('2025-12-02 10:07:22',NULL,NULL,0,23,'00428a58903e487bb33ddf74c19e4f17','snapshots_tripleo',0,0,NULL,1),('2025-12-02 10:07:22',NULL,NULL,0,24,'0b96bacd92de4f1aa310d96b02e2ba1b','snapshots',0,0,NULL,1),('2025-12-02 10:07:22',NULL,NULL,0,25,'0b96bacd92de4f1aa310d96b02e2ba1b','snapshots_tripleo',0,0,NULL,1),('2025-12-02 10:07:33','2025-12-02 10:07:35',NULL,0,26,'42538761f9f84e7684580411ccae9cb6','volumes',0,0,NULL,1),('2025-12-02 10:07:33','2025-12-02 10:07:35',NULL,0,27,'42538761f9f84e7684580411ccae9cb6','gigabytes',0,0,NULL,1),('2025-12-02 10:07:33','2025-12-02 10:07:35',NULL,0,28,'42538761f9f84e7684580411ccae9cb6','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:07:33','2025-12-02 10:07:35',NULL,0,29,'42538761f9f84e7684580411ccae9cb6','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:07:59','2025-12-02 10:08:35',NULL,0,30,'6963976a36c6408c9336062feaef5d1f','groups',0,0,NULL,1),('2025-12-02 10:08:00','2025-12-02 10:08:35',NULL,0,31,'6963976a36c6408c9336062feaef5d1f','volumes',0,0,NULL,1),('2025-12-02 10:08:00','2025-12-02 10:08:35',NULL,0,32,'6963976a36c6408c9336062feaef5d1f','gigabytes',0,0,NULL,1),('2025-12-02 10:08:00','2025-12-02 10:08:10',NULL,0,33,'6963976a36c6408c9336062feaef5d1f','volumes_tempest-GroupSnapshotsTest-volume-type-735882371',0,0,NULL,1),('2025-12-02 10:08:00','2025-12-02 10:08:08',NULL,0,34,'6963976a36c6408c9336062feaef5d1f','gigabytes_tempest-GroupSnapshotsTest-volume-type-735882371',0,0,NULL,1),('2025-12-02 10:08:02','2025-12-02 10:08:33',NULL,0,35,'6963976a36c6408c9336062feaef5d1f','snapshots',0,0,NULL,1),('2025-12-02 10:08:02','2025-12-02 10:08:08',NULL,0,36,'6963976a36c6408c9336062feaef5d1f','snapshots_tempest-GroupSnapshotsTest-volume-type-735882371',0,0,NULL,1),('2025-12-02 10:08:12','2025-12-02 10:08:27',NULL,0,37,'6963976a36c6408c9336062feaef5d1f','volumes_tempest-GroupSnapshotsTest-volume-type-679191759',0,0,NULL,1),('2025-12-02 10:08:12','2025-12-02 10:08:27',NULL,0,38,'6963976a36c6408c9336062feaef5d1f','gigabytes_tempest-GroupSnapshotsTest-volume-type-679191759',0,0,NULL,1),('2025-12-02 10:08:20','2025-12-02 10:08:26',NULL,0,39,'6963976a36c6408c9336062feaef5d1f','snapshots_tempest-GroupSnapshotsTest-volume-type-679191759',0,0,NULL,1),('2025-12-02 10:08:29','2025-12-02 10:08:35',NULL,0,40,'6963976a36c6408c9336062feaef5d1f','volumes_tempest-GroupSnapshotsTest-volume-type-400389718',0,0,NULL,1),('2025-12-02 10:08:29','2025-12-02 10:08:35',NULL,0,41,'6963976a36c6408c9336062feaef5d1f','gigabytes_tempest-GroupSnapshotsTest-volume-type-400389718',0,0,NULL,1),('2025-12-02 10:08:30','2025-12-02 10:08:33',NULL,0,42,'6963976a36c6408c9336062feaef5d1f','snapshots_tempest-GroupSnapshotsTest-volume-type-400389718',0,0,NULL,1),('2025-12-02 10:08:56','2025-12-02 10:09:00',NULL,0,43,'88ada1dc04884eb0b3013bc2d2c4917c','volumes',0,0,NULL,1),('2025-12-02 10:08:56','2025-12-02 10:09:00',NULL,0,44,'88ada1dc04884eb0b3013bc2d2c4917c','gigabytes',0,0,NULL,1),('2025-12-02 10:08:56','2025-12-02 10:08:58',NULL,0,45,'88ada1dc04884eb0b3013bc2d2c4917c','volumes_tempest-UserMessagesTest-volume-type-526789726',0,0,NULL,1),('2025-12-02 10:08:56','2025-12-02 10:08:58',NULL,0,46,'88ada1dc04884eb0b3013bc2d2c4917c','gigabytes_tempest-UserMessagesTest-volume-type-526789726',0,0,NULL,1),('2025-12-02 10:08:58','2025-12-02 10:09:00',NULL,0,47,'88ada1dc04884eb0b3013bc2d2c4917c','volumes_tempest-UserMessagesTest-volume-type-1867302679',0,0,NULL,1),('2025-12-02 10:08:58','2025-12-02 10:09:00',NULL,0,48,'88ada1dc04884eb0b3013bc2d2c4917c','gigabytes_tempest-UserMessagesTest-volume-type-1867302679',0,0,NULL,1),('2025-12-02 10:09:10','2025-12-02 10:09:21',NULL,0,49,'d077375432eb4d5983dfbe6a6927c321','volumes',0,0,NULL,1),('2025-12-02 10:09:10','2025-12-02 10:09:21',NULL,0,50,'d077375432eb4d5983dfbe6a6927c321','gigabytes',0,0,NULL,1),('2025-12-02 10:09:10','2025-12-02 10:09:21',NULL,0,51,'d077375432eb4d5983dfbe6a6927c321','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:09:10','2025-12-02 10:09:21',NULL,0,52,'d077375432eb4d5983dfbe6a6927c321','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:09:14','2025-12-02 10:09:18',NULL,0,53,'99d88ed9db6a44ad8671401d30ce29a3','volumes',0,0,NULL,1),('2025-12-02 10:09:14','2025-12-02 10:09:18',NULL,0,54,'99d88ed9db6a44ad8671401d30ce29a3','gigabytes',0,0,NULL,1),('2025-12-02 10:09:14','2025-12-02 10:09:18',NULL,0,55,'99d88ed9db6a44ad8671401d30ce29a3','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:09:14','2025-12-02 10:09:18',NULL,0,56,'99d88ed9db6a44ad8671401d30ce29a3','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:09:32','2025-12-02 10:09:42',NULL,0,57,'6c1597b25b33405db70f223b571f21b7','volumes',0,0,NULL,1),('2025-12-02 10:09:32','2025-12-02 10:09:42',NULL,0,58,'6c1597b25b33405db70f223b571f21b7','gigabytes',0,0,NULL,1),('2025-12-02 10:09:32','2025-12-02 10:09:42',NULL,0,59,'6c1597b25b33405db70f223b571f21b7','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:09:32','2025-12-02 10:09:42',NULL,0,60,'6c1597b25b33405db70f223b571f21b7','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:10:03','2025-12-02 10:10:52',NULL,0,61,'5bad680c763640dba71a7865b355817c','volumes',0,0,NULL,1),('2025-12-02 10:10:03','2025-12-02 10:10:52',NULL,0,62,'5bad680c763640dba71a7865b355817c','gigabytes',0,0,NULL,1),('2025-12-02 10:10:03','2025-12-02 10:10:52',NULL,0,63,'5bad680c763640dba71a7865b355817c','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:10:03','2025-12-02 10:10:52',NULL,0,64,'5bad680c763640dba71a7865b355817c','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:10:52','2025-12-02 10:11:06',NULL,0,65,'f7326c3837b4427191aafcff504110ac','volumes',0,0,NULL,1),('2025-12-02 10:10:52','2025-12-02 10:11:06',NULL,0,66,'f7326c3837b4427191aafcff504110ac','gigabytes',0,0,NULL,1),('2025-12-02 10:10:52','2025-12-02 10:11:06',NULL,0,67,'f7326c3837b4427191aafcff504110ac','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:10:52','2025-12-02 10:11:06',NULL,0,68,'f7326c3837b4427191aafcff504110ac','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:11:04','2025-12-02 10:11:18',NULL,0,69,'3cb8897eac514c8791f32dc7c7f97664','volumes',0,0,NULL,1),('2025-12-02 10:11:04','2025-12-02 10:11:18',NULL,0,70,'3cb8897eac514c8791f32dc7c7f97664','gigabytes',0,0,NULL,1),('2025-12-02 10:11:04','2025-12-02 10:11:18',NULL,0,71,'3cb8897eac514c8791f32dc7c7f97664','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:11:04','2025-12-02 10:11:18',NULL,0,72,'3cb8897eac514c8791f32dc7c7f97664','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:11:05','2025-12-02 10:11:16',NULL,0,73,'3cb8897eac514c8791f32dc7c7f97664','backups',0,0,NULL,1),('2025-12-02 10:11:05','2025-12-02 10:11:16',NULL,0,74,'3cb8897eac514c8791f32dc7c7f97664','backup_gigabytes',0,0,NULL,1),('2025-12-02 10:11:08','2025-12-02 10:11:14',NULL,0,75,'fef053541b4b4785ab9899f41b37c328','volumes',0,0,NULL,1),('2025-12-02 10:11:08','2025-12-02 10:11:14',NULL,0,76,'fef053541b4b4785ab9899f41b37c328','gigabytes',0,0,NULL,1),('2025-12-02 10:11:08','2025-12-02 10:11:14',NULL,0,77,'fef053541b4b4785ab9899f41b37c328','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:11:08','2025-12-02 10:11:14',NULL,0,78,'fef053541b4b4785ab9899f41b37c328','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:11:13','2025-12-02 10:11:15',NULL,0,79,'efbd1cf12d1441269b72130fc6cf60d9','volumes',0,0,NULL,1),('2025-12-02 10:11:13','2025-12-02 10:11:15',NULL,0,80,'efbd1cf12d1441269b72130fc6cf60d9','gigabytes',0,0,NULL,1),('2025-12-02 10:11:13','2025-12-02 10:11:15',NULL,0,81,'efbd1cf12d1441269b72130fc6cf60d9','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:11:13','2025-12-02 10:11:15',NULL,0,82,'efbd1cf12d1441269b72130fc6cf60d9','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:11:14',NULL,NULL,0,83,'efbd1cf12d1441269b72130fc6cf60d9','snapshots',0,0,NULL,1),('2025-12-02 10:11:14',NULL,NULL,0,84,'efbd1cf12d1441269b72130fc6cf60d9','snapshots_tripleo',0,0,NULL,1),('2025-12-02 10:11:14',NULL,NULL,0,85,'fef053541b4b4785ab9899f41b37c328','snapshots',0,0,NULL,1),('2025-12-02 10:11:14',NULL,NULL,0,86,'fef053541b4b4785ab9899f41b37c328','snapshots_tripleo',0,0,NULL,1),('2025-12-02 10:11:31','2025-12-02 10:11:53',NULL,0,87,'8e9db6bb24074518b94709252c97dff0','volumes',0,0,NULL,1),('2025-12-02 10:11:31','2025-12-02 10:11:53',NULL,0,88,'8e9db6bb24074518b94709252c97dff0','gigabytes',0,0,NULL,1),('2025-12-02 10:11:31','2025-12-02 10:11:53',NULL,0,89,'8e9db6bb24074518b94709252c97dff0','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:11:31','2025-12-02 10:11:53',NULL,0,90,'8e9db6bb24074518b94709252c97dff0','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:11:38','2025-12-02 10:12:12',NULL,0,91,'10644498f24744ec828624bc952bff43','volumes',0,0,NULL,1),('2025-12-02 10:11:38','2025-12-02 10:12:12',NULL,0,92,'10644498f24744ec828624bc952bff43','gigabytes',0,0,NULL,1),('2025-12-02 10:11:38','2025-12-02 10:12:12',NULL,0,93,'10644498f24744ec828624bc952bff43','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:11:38','2025-12-02 10:12:12',NULL,0,94,'10644498f24744ec828624bc952bff43','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:11:42','2025-12-02 10:12:09',NULL,0,95,'10644498f24744ec828624bc952bff43','backups',0,0,NULL,1),('2025-12-02 10:11:42','2025-12-02 10:12:09',NULL,0,96,'10644498f24744ec828624bc952bff43','backup_gigabytes',0,0,NULL,1),('2025-12-02 10:11:48','2025-12-02 10:11:57',NULL,0,97,'1e90b030c2b247a7a33033ba004a83a5','backups',0,0,NULL,1),('2025-12-02 10:11:48','2025-12-02 10:11:57',NULL,0,98,'1e90b030c2b247a7a33033ba004a83a5','backup_gigabytes',0,0,NULL,1),('2025-12-02 10:11:54','2025-12-02 10:12:01',NULL,0,99,'ab84e521dda9432ca7d62c5185f1eaab','volumes',0,0,NULL,1),('2025-12-02 10:11:54','2025-12-02 10:12:01',NULL,0,100,'ab84e521dda9432ca7d62c5185f1eaab','gigabytes',0,0,NULL,1),('2025-12-02 10:11:54','2025-12-02 10:12:01',NULL,0,101,'ab84e521dda9432ca7d62c5185f1eaab','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:11:54','2025-12-02 10:12:01',NULL,0,102,'ab84e521dda9432ca7d62c5185f1eaab','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:11:57','2025-12-02 10:11:58',NULL,0,103,'2267b5d8ec1242618341cd359607d279','volumes',0,0,NULL,1),('2025-12-02 10:11:57','2025-12-02 10:11:58',NULL,0,104,'2267b5d8ec1242618341cd359607d279','gigabytes',0,0,NULL,1),('2025-12-02 10:11:57','2025-12-02 10:11:58',NULL,0,105,'2267b5d8ec1242618341cd359607d279','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:11:57','2025-12-02 10:11:58',NULL,0,106,'2267b5d8ec1242618341cd359607d279','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:11:57',NULL,NULL,0,107,'2267b5d8ec1242618341cd359607d279','snapshots',0,0,NULL,1),('2025-12-02 10:11:57',NULL,NULL,0,108,'2267b5d8ec1242618341cd359607d279','snapshots_tripleo',0,0,NULL,1),('2025-12-02 10:11:57',NULL,NULL,0,109,'ab84e521dda9432ca7d62c5185f1eaab','snapshots',0,0,NULL,1),('2025-12-02 10:11:57',NULL,NULL,0,110,'ab84e521dda9432ca7d62c5185f1eaab','snapshots_tripleo',0,0,NULL,1),('2025-12-02 10:12:02','2025-12-02 10:12:18',NULL,0,111,'f5466a94421d4e84977ee830576dd8b7','volumes',0,0,NULL,1),('2025-12-02 10:12:02','2025-12-02 10:12:18',NULL,0,112,'f5466a94421d4e84977ee830576dd8b7','gigabytes',0,0,NULL,1),('2025-12-02 10:12:02','2025-12-02 10:12:18',NULL,0,113,'f5466a94421d4e84977ee830576dd8b7','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:12:02','2025-12-02 10:12:18',NULL,0,114,'f5466a94421d4e84977ee830576dd8b7','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:12:08','2025-12-02 10:12:09',NULL,0,115,'da38242c0e8d4da7a906db10517a9171','volumes',0,0,NULL,1),('2025-12-02 10:12:08','2025-12-02 10:12:09',NULL,0,116,'da38242c0e8d4da7a906db10517a9171','gigabytes',0,0,NULL,1),('2025-12-02 10:12:08','2025-12-02 10:12:09',NULL,0,117,'da38242c0e8d4da7a906db10517a9171','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:12:08','2025-12-02 10:12:09',NULL,0,118,'da38242c0e8d4da7a906db10517a9171','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:12:12','2025-12-02 10:12:16',NULL,0,119,'f5466a94421d4e84977ee830576dd8b7','snapshots',0,0,NULL,1),('2025-12-02 10:12:12','2025-12-02 10:12:16',NULL,0,120,'f5466a94421d4e84977ee830576dd8b7','snapshots_tripleo',0,0,NULL,1),('2025-12-02 10:12:22','2025-12-02 10:12:31',NULL,0,121,'9983d967265d4691806eb9b9a49900de','volumes',0,0,NULL,1),('2025-12-02 10:12:22','2025-12-02 10:12:31',NULL,0,122,'9983d967265d4691806eb9b9a49900de','gigabytes',0,0,NULL,1),('2025-12-02 10:12:22','2025-12-02 10:12:31',NULL,0,123,'9983d967265d4691806eb9b9a49900de','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:12:22','2025-12-02 10:12:31',NULL,0,124,'9983d967265d4691806eb9b9a49900de','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:12:26','2025-12-02 10:12:34',NULL,0,125,'6b4f1f3dd8704e9992f1bc11c793a60e','groups',0,0,NULL,1),('2025-12-02 10:12:28','2025-12-02 10:12:34',NULL,0,126,'6b4f1f3dd8704e9992f1bc11c793a60e','volumes',0,0,NULL,1),('2025-12-02 10:12:28','2025-12-02 10:12:34',NULL,0,127,'6b4f1f3dd8704e9992f1bc11c793a60e','gigabytes',0,0,NULL,1),('2025-12-02 10:12:28','2025-12-02 10:12:34',NULL,0,128,'6b4f1f3dd8704e9992f1bc11c793a60e','volumes_tempest-GroupSnapshotsV319Test-volume-type-1502590696',0,0,NULL,1),('2025-12-02 10:12:28','2025-12-02 10:12:34',NULL,0,129,'6b4f1f3dd8704e9992f1bc11c793a60e','gigabytes_tempest-GroupSnapshotsV319Test-volume-type-1502590696',0,0,NULL,1),('2025-12-02 10:12:29','2025-12-02 10:12:32',NULL,0,130,'6b4f1f3dd8704e9992f1bc11c793a60e','snapshots',0,0,NULL,1),('2025-12-02 10:12:29','2025-12-02 10:12:32',NULL,0,131,'6b4f1f3dd8704e9992f1bc11c793a60e','snapshots_tempest-GroupSnapshotsV319Test-volume-type-1502590696',0,0,NULL,1),('2025-12-02 10:12:36','2025-12-02 10:13:16',NULL,0,132,'b374ce45b6dc4bc5b2eac77a9216133f','volumes',0,0,NULL,1),('2025-12-02 10:12:36','2025-12-02 10:13:16',NULL,0,133,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes',0,0,NULL,1),('2025-12-02 10:12:36','2025-12-02 10:13:16',NULL,0,134,'b374ce45b6dc4bc5b2eac77a9216133f','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:12:36','2025-12-02 10:13:16',NULL,0,135,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:12:37','2025-12-02 10:13:13',NULL,0,136,'b374ce45b6dc4bc5b2eac77a9216133f','snapshots',0,0,NULL,1),('2025-12-02 10:12:37','2025-12-02 10:13:13',NULL,0,137,'b374ce45b6dc4bc5b2eac77a9216133f','snapshots_tripleo',0,0,NULL,1),('2025-12-02 10:12:38','2025-12-02 10:12:55',NULL,0,138,'b374ce45b6dc4bc5b2eac77a9216133f','backups',0,0,NULL,1),('2025-12-02 10:12:38','2025-12-02 10:12:55',NULL,0,139,'b374ce45b6dc4bc5b2eac77a9216133f','backup_gigabytes',0,0,NULL,1),('2025-12-02 10:12:47','2025-12-02 10:12:51',NULL,0,140,'bb3c511d46dd4d3ead65c06b6e7b5c12','volumes',0,0,NULL,1),('2025-12-02 10:12:47','2025-12-02 10:12:51',NULL,0,141,'bb3c511d46dd4d3ead65c06b6e7b5c12','gigabytes',0,0,NULL,1),('2025-12-02 10:12:47','2025-12-02 10:12:51',NULL,0,142,'bb3c511d46dd4d3ead65c06b6e7b5c12','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:12:47','2025-12-02 10:12:51',NULL,0,143,'bb3c511d46dd4d3ead65c06b6e7b5c12','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:12:59','2025-12-02 10:13:04',NULL,0,144,'8943858eee964ad7920643441a49ca76','volumes',0,0,NULL,1),('2025-12-02 10:12:59','2025-12-02 10:13:04',NULL,0,145,'8943858eee964ad7920643441a49ca76','gigabytes',0,0,NULL,1),('2025-12-02 10:12:59','2025-12-02 10:13:04',NULL,0,146,'8943858eee964ad7920643441a49ca76','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:12:59','2025-12-02 10:13:04',NULL,0,147,'8943858eee964ad7920643441a49ca76','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:13:00','2025-12-02 10:13:03',NULL,0,148,'8943858eee964ad7920643441a49ca76','snapshots',0,0,NULL,1),('2025-12-02 10:13:00','2025-12-02 10:13:03',NULL,0,149,'8943858eee964ad7920643441a49ca76','snapshots_tripleo',0,0,NULL,1),('2025-12-02 10:13:12','2025-12-02 10:13:14',NULL,0,150,'e40b394d064942f593402333dc8c9581','volumes',0,0,NULL,1),('2025-12-02 10:13:12','2025-12-02 10:13:14',NULL,0,151,'e40b394d064942f593402333dc8c9581','gigabytes',0,0,NULL,1),('2025-12-02 10:13:12','2025-12-02 10:13:14',NULL,0,152,'e40b394d064942f593402333dc8c9581','volumes_tempest-VolumeTypesAccessTest-volume-type-1654729354',0,0,NULL,1),('2025-12-02 10:13:12','2025-12-02 10:13:14',NULL,0,153,'e40b394d064942f593402333dc8c9581','gigabytes_tempest-VolumeTypesAccessTest-volume-type-1654729354',0,0,NULL,1),('2025-12-02 10:13:12','2025-12-02 10:13:27',NULL,0,154,'8ff22a276ec5464e8a97c8b3b0e8806c','groups',0,0,NULL,1),('2025-12-02 10:13:15','2025-12-02 10:13:27',NULL,0,155,'8ff22a276ec5464e8a97c8b3b0e8806c','volumes',0,0,NULL,1),('2025-12-02 10:13:15','2025-12-02 10:13:27',NULL,0,156,'8ff22a276ec5464e8a97c8b3b0e8806c','gigabytes',0,0,NULL,1),('2025-12-02 10:13:15','2025-12-02 10:13:17',NULL,0,157,'8ff22a276ec5464e8a97c8b3b0e8806c','volumes_tempest-GroupsTest-volume-type-1153924094',0,0,NULL,1),('2025-12-02 10:13:15','2025-12-02 10:13:17',NULL,0,158,'8ff22a276ec5464e8a97c8b3b0e8806c','gigabytes_tempest-GroupsTest-volume-type-1153924094',0,0,NULL,1),('2025-12-02 10:13:20','2025-12-02 10:13:27',NULL,0,159,'8ff22a276ec5464e8a97c8b3b0e8806c','volumes_tempest-GroupsTest-volume-type-1060610990',0,0,NULL,1),('2025-12-02 10:13:20','2025-12-02 10:13:27',NULL,0,160,'8ff22a276ec5464e8a97c8b3b0e8806c','gigabytes_tempest-GroupsTest-volume-type-1060610990',0,0,NULL,1),('2025-12-02 10:13:36','2025-12-02 10:13:38',NULL,0,161,'f01f26d352434e1898ddc5651f0257ce','volumes',0,0,NULL,1),('2025-12-02 10:13:36','2025-12-02 10:13:38',NULL,0,162,'f01f26d352434e1898ddc5651f0257ce','gigabytes',0,0,NULL,1),('2025-12-02 10:13:36','2025-12-02 10:13:38',NULL,0,163,'f01f26d352434e1898ddc5651f0257ce','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:13:36','2025-12-02 10:13:38',NULL,0,164,'f01f26d352434e1898ddc5651f0257ce','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:13:45','2025-12-02 10:13:51',NULL,0,165,'08ec4508e51e4b46972baa016cc404c1','volumes',0,0,NULL,1),('2025-12-02 10:13:45','2025-12-02 10:13:51',NULL,0,166,'08ec4508e51e4b46972baa016cc404c1','gigabytes',0,0,NULL,1),('2025-12-02 10:13:45','2025-12-02 10:13:51',NULL,0,167,'08ec4508e51e4b46972baa016cc404c1','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:13:45','2025-12-02 10:13:51',NULL,0,168,'08ec4508e51e4b46972baa016cc404c1','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:13:46','2025-12-02 10:13:47',NULL,0,169,'1259cb721f554d769bcd146b925c03fd','volumes',0,0,NULL,1),('2025-12-02 10:13:46','2025-12-02 10:13:47',NULL,0,170,'1259cb721f554d769bcd146b925c03fd','gigabytes',0,0,NULL,1),('2025-12-02 10:13:46','2025-12-02 10:13:47',NULL,0,171,'1259cb721f554d769bcd146b925c03fd','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:13:46','2025-12-02 10:13:47',NULL,0,172,'1259cb721f554d769bcd146b925c03fd','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:13:46',NULL,NULL,0,173,'1259cb721f554d769bcd146b925c03fd','snapshots',0,0,NULL,1),('2025-12-02 10:13:46',NULL,NULL,0,174,'1259cb721f554d769bcd146b925c03fd','snapshots_tripleo',0,0,NULL,1),('2025-12-02 10:13:46',NULL,NULL,0,175,'08ec4508e51e4b46972baa016cc404c1','snapshots',0,0,NULL,1),('2025-12-02 10:13:46',NULL,NULL,0,176,'08ec4508e51e4b46972baa016cc404c1','snapshots_tripleo',0,0,NULL,1),('2025-12-02 10:13:47','2025-12-02 10:13:54',NULL,0,177,'69ac27088e5c47cabe1441ecc9b19c84','groups',0,0,NULL,1),('2025-12-02 10:13:47','2025-12-02 10:13:50',NULL,0,178,'58b8f029a1134a12a75f33bc584b83dd','volumes',0,0,NULL,1),('2025-12-02 10:13:47','2025-12-02 10:13:50',NULL,0,179,'58b8f029a1134a12a75f33bc584b83dd','gigabytes',0,0,NULL,1),('2025-12-02 10:13:47','2025-12-02 10:13:50',NULL,0,180,'58b8f029a1134a12a75f33bc584b83dd','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:13:47','2025-12-02 10:13:50',NULL,0,181,'58b8f029a1134a12a75f33bc584b83dd','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:13:48','2025-12-02 10:13:54',NULL,0,182,'69ac27088e5c47cabe1441ecc9b19c84','volumes',0,0,NULL,1),('2025-12-02 10:13:48','2025-12-02 10:13:54',NULL,0,183,'69ac27088e5c47cabe1441ecc9b19c84','gigabytes',0,0,NULL,1),('2025-12-02 10:13:48','2025-12-02 10:13:54',NULL,0,184,'69ac27088e5c47cabe1441ecc9b19c84','volumes_tempest-GroupsV314Test-volume-type-197107638',0,0,NULL,1),('2025-12-02 10:13:48','2025-12-02 10:13:54',NULL,0,185,'69ac27088e5c47cabe1441ecc9b19c84','gigabytes_tempest-GroupsV314Test-volume-type-197107638',0,0,NULL,1),('2025-12-02 10:13:54','2025-12-02 10:14:03',NULL,0,186,'59618d0a71be4bd7b90941ee9db2762c','volumes',0,0,NULL,1),('2025-12-02 10:13:54','2025-12-02 10:14:03',NULL,0,187,'59618d0a71be4bd7b90941ee9db2762c','gigabytes',0,0,NULL,1),('2025-12-02 10:13:54','2025-12-02 10:14:03',NULL,0,188,'59618d0a71be4bd7b90941ee9db2762c','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:13:54','2025-12-02 10:14:03',NULL,0,189,'59618d0a71be4bd7b90941ee9db2762c','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:13:56','2025-12-02 10:14:20',NULL,0,190,'82445c1a56474ba497d07340322dbade','volumes',0,0,NULL,1),('2025-12-02 10:13:56','2025-12-02 10:14:20',NULL,0,191,'82445c1a56474ba497d07340322dbade','gigabytes',0,0,NULL,1),('2025-12-02 10:13:56','2025-12-02 10:14:20',NULL,0,192,'82445c1a56474ba497d07340322dbade','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:13:56','2025-12-02 10:14:20',NULL,0,193,'82445c1a56474ba497d07340322dbade','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:14:05','2025-12-02 10:14:11',NULL,0,194,'8f287097241a4419b0923dfc81ea1206','volumes',0,0,NULL,1),('2025-12-02 10:14:05','2025-12-02 10:14:11',NULL,0,195,'8f287097241a4419b0923dfc81ea1206','gigabytes',0,0,NULL,1),('2025-12-02 10:14:05','2025-12-02 10:14:11',NULL,0,196,'8f287097241a4419b0923dfc81ea1206','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:14:05','2025-12-02 10:14:11',NULL,0,197,'8f287097241a4419b0923dfc81ea1206','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:14:06','2025-12-02 10:14:10',NULL,0,198,'8f287097241a4419b0923dfc81ea1206','snapshots',0,0,NULL,1),('2025-12-02 10:14:06','2025-12-02 10:14:10',NULL,0,199,'8f287097241a4419b0923dfc81ea1206','snapshots_tripleo',0,0,NULL,1),('2025-12-02 10:14:15','2025-12-02 10:14:34',NULL,0,200,'d3daa40d2d6446d8b0b46a9f7d1b779c','volumes',0,0,NULL,1),('2025-12-02 10:14:15','2025-12-02 10:14:34',NULL,0,201,'d3daa40d2d6446d8b0b46a9f7d1b779c','gigabytes',0,0,NULL,1),('2025-12-02 10:14:15','2025-12-02 10:14:34',NULL,0,202,'d3daa40d2d6446d8b0b46a9f7d1b779c','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:14:15','2025-12-02 10:14:34',NULL,0,203,'d3daa40d2d6446d8b0b46a9f7d1b779c','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:14:16','2025-12-02 10:14:32',NULL,0,204,'d3daa40d2d6446d8b0b46a9f7d1b779c','snapshots',0,0,NULL,1),('2025-12-02 10:14:16','2025-12-02 10:14:32',NULL,0,205,'d3daa40d2d6446d8b0b46a9f7d1b779c','snapshots_tripleo',0,0,NULL,1),('2025-12-02 10:14:23','2025-12-02 10:14:37',NULL,0,206,'ab2f308df5874752ab8cc95304b7b442','volumes',0,0,NULL,1),('2025-12-02 10:14:23','2025-12-02 10:14:37',NULL,0,207,'ab2f308df5874752ab8cc95304b7b442','gigabytes',0,0,NULL,1),('2025-12-02 10:14:23','2025-12-02 10:14:37',NULL,0,208,'ab2f308df5874752ab8cc95304b7b442','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:14:23','2025-12-02 10:14:37',NULL,0,209,'ab2f308df5874752ab8cc95304b7b442','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:14:24','2025-12-02 10:14:36',NULL,0,210,'ab2f308df5874752ab8cc95304b7b442','snapshots',0,0,NULL,1),('2025-12-02 10:14:24','2025-12-02 10:14:36',NULL,0,211,'ab2f308df5874752ab8cc95304b7b442','snapshots_tripleo',0,0,NULL,1),('2025-12-02 10:14:46','2025-12-02 10:16:04',NULL,0,212,'d858413a9b01463f96545916d2abe5ab','volumes',0,0,NULL,1),('2025-12-02 10:14:46','2025-12-02 10:16:04',NULL,0,213,'d858413a9b01463f96545916d2abe5ab','gigabytes',0,0,NULL,1),('2025-12-02 10:14:46','2025-12-02 10:16:04',NULL,0,214,'d858413a9b01463f96545916d2abe5ab','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:14:46','2025-12-02 10:16:04',NULL,0,215,'d858413a9b01463f96545916d2abe5ab','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:14:52','2025-12-02 10:15:53',NULL,0,216,'d858413a9b01463f96545916d2abe5ab','backups',0,0,NULL,1),('2025-12-02 10:14:52','2025-12-02 10:15:53',NULL,0,217,'d858413a9b01463f96545916d2abe5ab','backup_gigabytes',0,0,NULL,1),('2025-12-02 10:16:11','2025-12-02 10:16:17',NULL,0,218,'9357d59432e04f9791424e201b9754ce','volumes',0,0,NULL,1),('2025-12-02 10:16:11','2025-12-02 10:16:17',NULL,0,219,'9357d59432e04f9791424e201b9754ce','gigabytes',0,0,NULL,1),('2025-12-02 10:16:11','2025-12-02 10:16:17',NULL,0,220,'9357d59432e04f9791424e201b9754ce','volumes_tripleo',0,0,NULL,1),('2025-12-02 10:16:11','2025-12-02 10:16:17',NULL,0,221,'9357d59432e04f9791424e201b9754ce','gigabytes_tripleo',0,0,NULL,1),('2025-12-02 10:16:12','2025-12-02 10:16:15',NULL,0,222,'9357d59432e04f9791424e201b9754ce','snapshots',0,0,NULL,1),('2025-12-02 10:16:12','2025-12-02 10:16:15',NULL,0,223,'9357d59432e04f9791424e201b9754ce','snapshots_tripleo',0,0,NULL,1);
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `allocated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
INSERT INTO `quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `project_id`, `resource`, `hard_limit`, `allocated`) VALUES (1,'2025-12-02 10:11:07','2025-12-02 10:11:07','2025-12-02 10:11:07',1,'fef053541b4b4785ab9899f41b37c328','volumes',15,0),(2,'2025-12-02 10:11:07','2025-12-02 10:11:17',NULL,0,'fef053541b4b4785ab9899f41b37c328','volumes',10,0),(3,'2025-12-02 10:11:07','2025-12-02 10:11:17',NULL,0,'fef053541b4b4785ab9899f41b37c328','per_volume_gigabytes',-1,0),(4,'2025-12-02 10:11:07','2025-12-02 10:11:17',NULL,0,'fef053541b4b4785ab9899f41b37c328','snapshots',10,0),(5,'2025-12-02 10:11:07','2025-12-02 10:11:17',NULL,0,'fef053541b4b4785ab9899f41b37c328','gigabytes',1000,0),(6,'2025-12-02 10:11:07','2025-12-02 10:11:17',NULL,0,'fef053541b4b4785ab9899f41b37c328','backups',10,0),(7,'2025-12-02 10:11:07','2025-12-02 10:11:17',NULL,0,'fef053541b4b4785ab9899f41b37c328','backup_gigabytes',1000,0),(8,'2025-12-02 10:12:48','2025-12-02 10:12:52',NULL,0,'bb3c511d46dd4d3ead65c06b6e7b5c12','gigabytes',1000,0),(9,'2025-12-02 10:12:48','2025-12-02 10:12:52',NULL,0,'bb3c511d46dd4d3ead65c06b6e7b5c12','volumes',10,0),(10,'2025-12-02 10:12:52',NULL,NULL,0,'bb3c511d46dd4d3ead65c06b6e7b5c12','per_volume_gigabytes',-1,0),(11,'2025-12-02 10:12:52',NULL,NULL,0,'bb3c511d46dd4d3ead65c06b6e7b5c12','snapshots',10,0),(12,'2025-12-02 10:12:52',NULL,NULL,0,'bb3c511d46dd4d3ead65c06b6e7b5c12','backups',10,0),(13,'2025-12-02 10:12:52',NULL,NULL,0,'bb3c511d46dd4d3ead65c06b6e7b5c12','backup_gigabytes',1000,0),(14,'2025-12-02 10:12:58','2025-12-02 10:13:05',NULL,0,'8943858eee964ad7920643441a49ca76','gigabytes',1000,0),(15,'2025-12-02 10:12:58','2025-12-02 10:13:04',NULL,0,'8943858eee964ad7920643441a49ca76','volumes',10,0),(16,'2025-12-02 10:12:58','2025-12-02 10:13:05',NULL,0,'8943858eee964ad7920643441a49ca76','snapshots',10,0),(17,'2025-12-02 10:13:05',NULL,NULL,0,'8943858eee964ad7920643441a49ca76','per_volume_gigabytes',-1,0),(18,'2025-12-02 10:13:05',NULL,NULL,0,'8943858eee964ad7920643441a49ca76','backups',10,0),(19,'2025-12-02 10:13:05',NULL,NULL,0,'8943858eee964ad7920643441a49ca76','backup_gigabytes',1000,0);
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `allocated_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  KEY `ix_reservations_usage_id` (`usage_id`),
  KEY `reservations_deleted_uuid_idx` (`deleted`,`uuid`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `ix_reservations_allocated_id` (`allocated_id`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`),
  CONSTRAINT `reservations_ibfk_2` FOREIGN KEY (`allocated_id`) REFERENCES `quotas` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=925 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
INSERT INTO `reservations` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `uuid`, `usage_id`, `project_id`, `resource`, `delta`, `expire`, `allocated_id`) VALUES ('2025-12-02 10:06:30','2025-12-02 10:06:30','2025-12-02 10:06:30',1,1,'f4b56c3a-f27a-4ea0-a57a-26f7c289eeb6',1,'39d049b7ae3640b1bc36845add7b4021','groups',1,'2025-12-03 10:06:30',NULL),('2025-12-02 10:06:32','2025-12-02 10:06:32','2025-12-02 10:06:32',1,2,'69bf12ae-8c8c-4e5d-bcd9-4f243a1dd29d',1,'39d049b7ae3640b1bc36845add7b4021','groups',-1,'2025-12-03 10:06:32',NULL),('2025-12-02 10:06:42','2025-12-02 10:06:42','2025-12-02 10:06:42',1,3,'f825b2c9-2bad-4167-b392-2c07c769e780',2,'1e139fe20a514d12b866b3c8974dcebd','volumes',1,'2025-12-03 10:06:42',NULL),('2025-12-02 10:06:42','2025-12-02 10:06:42','2025-12-02 10:06:42',1,4,'a23f71ec-2be0-45fe-9b90-a02928b8dd01',3,'1e139fe20a514d12b866b3c8974dcebd','gigabytes',1,'2025-12-03 10:06:42',NULL),('2025-12-02 10:06:42','2025-12-02 10:06:42','2025-12-02 10:06:42',1,5,'fab35024-ced3-48a5-9f99-25864a0c4921',4,'1e139fe20a514d12b866b3c8974dcebd','volumes_tripleo',1,'2025-12-03 10:06:42',NULL),('2025-12-02 10:06:42','2025-12-02 10:06:42','2025-12-02 10:06:42',1,6,'2d874f68-fef8-4717-9a07-39d07a91981f',5,'1e139fe20a514d12b866b3c8974dcebd','gigabytes_tripleo',1,'2025-12-03 10:06:42',NULL),('2025-12-02 10:06:46','2025-12-02 10:06:46','2025-12-02 10:06:46',1,7,'e71bcd6b-9fea-421e-9753-01138d189456',6,'1e139fe20a514d12b866b3c8974dcebd','snapshots',1,'2025-12-03 10:06:46',NULL),('2025-12-02 10:06:46','2025-12-02 10:06:46','2025-12-02 10:06:46',1,8,'0c202017-52be-4976-9076-9e33b494b611',3,'1e139fe20a514d12b866b3c8974dcebd','gigabytes',1,'2025-12-03 10:06:46',NULL),('2025-12-02 10:06:46','2025-12-02 10:06:46','2025-12-02 10:06:46',1,9,'d1de2903-5c67-400c-a89e-9c44c4cb8b30',5,'1e139fe20a514d12b866b3c8974dcebd','gigabytes_tripleo',1,'2025-12-03 10:06:46',NULL),('2025-12-02 10:06:46','2025-12-02 10:06:46','2025-12-02 10:06:46',1,10,'b4baf69e-6376-4ef0-a12d-48f5ed3659a4',7,'1e139fe20a514d12b866b3c8974dcebd','snapshots_tripleo',1,'2025-12-03 10:06:46',NULL),('2025-12-02 10:06:48','2025-12-02 10:06:48','2025-12-02 10:06:48',1,11,'d1d5d0a8-4f26-4555-a28c-945bc148d3e3',6,'1e139fe20a514d12b866b3c8974dcebd','snapshots',1,'2025-12-03 10:06:48',NULL),('2025-12-02 10:06:48','2025-12-02 10:06:48','2025-12-02 10:06:48',1,12,'8bf17a3e-d2cb-4d77-973d-79753bcc89e4',3,'1e139fe20a514d12b866b3c8974dcebd','gigabytes',1,'2025-12-03 10:06:48',NULL),('2025-12-02 10:06:48','2025-12-02 10:06:48','2025-12-02 10:06:48',1,13,'86e18152-2d97-4780-89a8-ec9497cab8e0',5,'1e139fe20a514d12b866b3c8974dcebd','gigabytes_tripleo',1,'2025-12-03 10:06:48',NULL),('2025-12-02 10:06:48','2025-12-02 10:06:48','2025-12-02 10:06:48',1,14,'65a477e5-5765-4362-8c8d-8fbfed39d534',7,'1e139fe20a514d12b866b3c8974dcebd','snapshots_tripleo',1,'2025-12-03 10:06:48',NULL),('2025-12-02 10:06:50','2025-12-02 10:06:50','2025-12-02 10:06:50',1,15,'06a8044a-5b21-41b4-abdd-b9f3643bf5d4',6,'1e139fe20a514d12b866b3c8974dcebd','snapshots',-1,'2025-12-03 10:06:50',NULL),('2025-12-02 10:06:50','2025-12-02 10:06:50','2025-12-02 10:06:50',1,16,'66d8fbe2-9c97-4e91-a667-df0be70a41b5',3,'1e139fe20a514d12b866b3c8974dcebd','gigabytes',-1,'2025-12-03 10:06:50',NULL),('2025-12-02 10:06:50','2025-12-02 10:06:50','2025-12-02 10:06:50',1,17,'5be1f566-066c-44da-90c6-99ee3d2c16c7',5,'1e139fe20a514d12b866b3c8974dcebd','gigabytes_tripleo',-1,'2025-12-03 10:06:50',NULL),('2025-12-02 10:06:50','2025-12-02 10:06:50','2025-12-02 10:06:50',1,18,'fdbd7962-d7e6-4213-bf13-a2ff81b95c33',7,'1e139fe20a514d12b866b3c8974dcebd','snapshots_tripleo',-1,'2025-12-03 10:06:50',NULL),('2025-12-02 10:06:51','2025-12-02 10:06:51','2025-12-02 10:06:51',1,19,'02230b3c-e060-4789-a77d-758ddecf97ca',6,'1e139fe20a514d12b866b3c8974dcebd','snapshots',1,'2025-12-03 10:06:51',NULL),('2025-12-02 10:06:51','2025-12-02 10:06:51','2025-12-02 10:06:51',1,20,'a91ad12e-7ef4-45a3-9255-e2f22a63226d',3,'1e139fe20a514d12b866b3c8974dcebd','gigabytes',1,'2025-12-03 10:06:51',NULL),('2025-12-02 10:06:51','2025-12-02 10:06:51','2025-12-02 10:06:51',1,21,'d73dd528-ef73-42a3-9c77-9babe14cf50c',5,'1e139fe20a514d12b866b3c8974dcebd','gigabytes_tripleo',1,'2025-12-03 10:06:51',NULL),('2025-12-02 10:06:51','2025-12-02 10:06:51','2025-12-02 10:06:51',1,22,'cc594a69-5ee3-45e3-a8c1-14554ba46b9f',7,'1e139fe20a514d12b866b3c8974dcebd','snapshots_tripleo',1,'2025-12-03 10:06:51',NULL),('2025-12-02 10:06:54','2025-12-02 10:06:54','2025-12-02 10:06:54',1,23,'021927cd-4c6c-4cdf-b4ed-5b5c269801ee',6,'1e139fe20a514d12b866b3c8974dcebd','snapshots',-1,'2025-12-03 10:06:54',NULL),('2025-12-02 10:06:54','2025-12-02 10:06:54','2025-12-02 10:06:54',1,24,'a0a09e57-255f-4f35-b26f-f0de617328c8',3,'1e139fe20a514d12b866b3c8974dcebd','gigabytes',-1,'2025-12-03 10:06:54',NULL),('2025-12-02 10:06:54','2025-12-02 10:06:54','2025-12-02 10:06:54',1,25,'b3b0f0c0-099e-48f8-a98d-194aa42efd84',5,'1e139fe20a514d12b866b3c8974dcebd','gigabytes_tripleo',-1,'2025-12-03 10:06:54',NULL),('2025-12-02 10:06:54','2025-12-02 10:06:54','2025-12-02 10:06:54',1,26,'8b7b9d75-e11d-4dfe-a02f-c0c31a1e7e55',7,'1e139fe20a514d12b866b3c8974dcebd','snapshots_tripleo',-1,'2025-12-03 10:06:54',NULL),('2025-12-02 10:06:55','2025-12-02 10:06:55','2025-12-02 10:06:55',1,27,'fb0b4b9b-f8d2-4838-9204-655ce5a06579',6,'1e139fe20a514d12b866b3c8974dcebd','snapshots',1,'2025-12-03 10:06:55',NULL),('2025-12-02 10:06:55','2025-12-02 10:06:55','2025-12-02 10:06:55',1,28,'5bdbdd77-c1a2-4fe0-a19d-0c5dc7342dda',3,'1e139fe20a514d12b866b3c8974dcebd','gigabytes',1,'2025-12-03 10:06:55',NULL),('2025-12-02 10:06:55','2025-12-02 10:06:55','2025-12-02 10:06:55',1,29,'120a2f35-f850-4d5e-aa9f-a947bbdc5883',5,'1e139fe20a514d12b866b3c8974dcebd','gigabytes_tripleo',1,'2025-12-03 10:06:55',NULL),('2025-12-02 10:06:55','2025-12-02 10:06:55','2025-12-02 10:06:55',1,30,'ca2ed2ad-dc52-4522-9e41-f753f59217c1',7,'1e139fe20a514d12b866b3c8974dcebd','snapshots_tripleo',1,'2025-12-03 10:06:55',NULL),('2025-12-02 10:06:57','2025-12-02 10:06:57','2025-12-02 10:06:57',1,31,'faad1e7c-839a-4b40-9fc5-fe0d6e1898f3',6,'1e139fe20a514d12b866b3c8974dcebd','snapshots',-1,'2025-12-03 10:06:57',NULL),('2025-12-02 10:06:57','2025-12-02 10:06:57','2025-12-02 10:06:57',1,32,'70f83128-1965-4d08-9530-83da6ac4a8a2',3,'1e139fe20a514d12b866b3c8974dcebd','gigabytes',-1,'2025-12-03 10:06:57',NULL),('2025-12-02 10:06:57','2025-12-02 10:06:57','2025-12-02 10:06:57',1,33,'ac25eb1f-24f6-41ba-90ff-add6da7c4811',5,'1e139fe20a514d12b866b3c8974dcebd','gigabytes_tripleo',-1,'2025-12-03 10:06:57',NULL),('2025-12-02 10:06:57','2025-12-02 10:06:57','2025-12-02 10:06:57',1,34,'26404f7c-7c19-4f60-9d2a-6643d49590e0',7,'1e139fe20a514d12b866b3c8974dcebd','snapshots_tripleo',-1,'2025-12-03 10:06:57',NULL),('2025-12-02 10:06:58','2025-12-02 10:06:58','2025-12-02 10:06:58',1,35,'e3d6382f-c40f-46ab-ab85-8583c8af0fab',6,'1e139fe20a514d12b866b3c8974dcebd','snapshots',1,'2025-12-03 10:06:58',NULL),('2025-12-02 10:06:58','2025-12-02 10:06:58','2025-12-02 10:06:58',1,36,'da383389-2942-4617-8975-e204527fdd46',3,'1e139fe20a514d12b866b3c8974dcebd','gigabytes',1,'2025-12-03 10:06:58',NULL),('2025-12-02 10:06:58','2025-12-02 10:06:58','2025-12-02 10:06:58',1,37,'93e640ba-49a7-46e0-b2ed-2fc4a009b723',5,'1e139fe20a514d12b866b3c8974dcebd','gigabytes_tripleo',1,'2025-12-03 10:06:58',NULL),('2025-12-02 10:06:58','2025-12-02 10:06:58','2025-12-02 10:06:58',1,38,'a2c210fa-a75a-4b98-a3f1-c1a1988ceb86',7,'1e139fe20a514d12b866b3c8974dcebd','snapshots_tripleo',1,'2025-12-03 10:06:58',NULL),('2025-12-02 10:07:03','2025-12-02 10:07:03','2025-12-02 10:07:03',1,39,'aa539877-4c64-49b2-b0f3-8b1067759f20',6,'1e139fe20a514d12b866b3c8974dcebd','snapshots',-1,'2025-12-03 10:07:03',NULL),('2025-12-02 10:07:03','2025-12-02 10:07:03','2025-12-02 10:07:03',1,40,'5c121d76-b858-48d1-9adb-cf0255cc2282',3,'1e139fe20a514d12b866b3c8974dcebd','gigabytes',-1,'2025-12-03 10:07:03',NULL),('2025-12-02 10:07:03','2025-12-02 10:07:03','2025-12-02 10:07:03',1,41,'652bc313-97da-4761-86ee-23e22e22c223',5,'1e139fe20a514d12b866b3c8974dcebd','gigabytes_tripleo',-1,'2025-12-03 10:07:03',NULL),('2025-12-02 10:07:03','2025-12-02 10:07:03','2025-12-02 10:07:03',1,42,'c171f5e0-d370-4585-9faf-a0abe1232f05',7,'1e139fe20a514d12b866b3c8974dcebd','snapshots_tripleo',-1,'2025-12-03 10:07:03',NULL),('2025-12-02 10:07:05','2025-12-02 10:07:05','2025-12-02 10:07:05',1,43,'eaf3e83a-2080-44b3-bb0e-792c530f163b',6,'1e139fe20a514d12b866b3c8974dcebd','snapshots',-1,'2025-12-03 10:07:05',NULL),('2025-12-02 10:07:05','2025-12-02 10:07:05','2025-12-02 10:07:05',1,44,'859cab3b-313a-4342-9d36-7927c0e158b0',3,'1e139fe20a514d12b866b3c8974dcebd','gigabytes',-1,'2025-12-03 10:07:05',NULL),('2025-12-02 10:07:05','2025-12-02 10:07:05','2025-12-02 10:07:05',1,45,'47c3c7fd-daf7-4e4a-a04b-7726fa8df4f1',5,'1e139fe20a514d12b866b3c8974dcebd','gigabytes_tripleo',-1,'2025-12-03 10:07:05',NULL),('2025-12-02 10:07:05','2025-12-02 10:07:05','2025-12-02 10:07:05',1,46,'1d098870-bb39-4866-9d6d-3b0799eeb4a7',7,'1e139fe20a514d12b866b3c8974dcebd','snapshots_tripleo',-1,'2025-12-03 10:07:05',NULL),('2025-12-02 10:07:07','2025-12-02 10:07:07','2025-12-02 10:07:07',1,47,'fa333b40-ab8d-4f21-a4a6-550d2f922bb7',2,'1e139fe20a514d12b866b3c8974dcebd','volumes',-1,'2025-12-03 10:07:07',NULL),('2025-12-02 10:07:07','2025-12-02 10:07:07','2025-12-02 10:07:07',1,48,'a39714de-5563-4df5-a814-273bc8be5bf3',3,'1e139fe20a514d12b866b3c8974dcebd','gigabytes',-1,'2025-12-03 10:07:07',NULL),('2025-12-02 10:07:07','2025-12-02 10:07:07','2025-12-02 10:07:07',1,49,'a0799db3-e355-44c9-bc6b-bf45dd45d183',4,'1e139fe20a514d12b866b3c8974dcebd','volumes_tripleo',-1,'2025-12-03 10:07:07',NULL),('2025-12-02 10:07:07','2025-12-02 10:07:07','2025-12-02 10:07:07',1,50,'d8efb805-fa94-4cd3-9174-8eaa65a1b05d',5,'1e139fe20a514d12b866b3c8974dcebd','gigabytes_tripleo',-1,'2025-12-03 10:07:07',NULL),('2025-12-02 10:07:17','2025-12-02 10:07:17','2025-12-02 10:07:17',1,51,'1500ea2f-d96e-47bb-9a3f-29329e782829',8,'ef69e828801540619536106b3b481b20','volumes',1,'2025-12-03 10:07:17',NULL),('2025-12-02 10:07:17','2025-12-02 10:07:17','2025-12-02 10:07:17',1,52,'050b4458-4d6a-40af-ad06-8f7a4197a4bb',9,'ef69e828801540619536106b3b481b20','gigabytes',1,'2025-12-03 10:07:17',NULL),('2025-12-02 10:07:17','2025-12-02 10:07:17','2025-12-02 10:07:17',1,53,'cfa1f62b-77af-400d-a898-d315f4ff4387',10,'ef69e828801540619536106b3b481b20','volumes_volume-type-1',1,'2025-12-03 10:07:17',NULL),('2025-12-02 10:07:17','2025-12-02 10:07:17','2025-12-02 10:07:17',1,54,'b833101b-2545-4eab-9417-895a769d7fdc',11,'ef69e828801540619536106b3b481b20','gigabytes_volume-type-1',1,'2025-12-03 10:07:17',NULL),('2025-12-02 10:07:19','2025-12-02 10:07:19','2025-12-02 10:07:19',1,55,'fc94d5a5-431a-4384-87a8-c02521b5f401',12,'ef69e828801540619536106b3b481b20','volumes_volume-type-2',1,'2025-12-03 10:07:19',NULL),('2025-12-02 10:07:19','2025-12-02 10:07:19','2025-12-02 10:07:19',1,56,'2e825058-3465-4339-bd64-39b77559c500',13,'ef69e828801540619536106b3b481b20','gigabytes_volume-type-2',1,'2025-12-03 10:07:19',NULL),('2025-12-02 10:07:19','2025-12-02 10:07:19','2025-12-02 10:07:19',1,57,'94da6ac2-3411-44a7-897c-5c7dfba83db8',10,'ef69e828801540619536106b3b481b20','volumes_volume-type-1',-1,'2025-12-03 10:07:19',NULL),('2025-12-02 10:07:19','2025-12-02 10:07:19','2025-12-02 10:07:19',1,58,'a8d7cb82-5de5-4757-b8bb-4fecacd1dbef',11,'ef69e828801540619536106b3b481b20','gigabytes_volume-type-1',-1,'2025-12-03 10:07:19',NULL),('2025-12-02 10:07:20','2025-12-02 10:07:20','2025-12-02 10:07:20',1,59,'0725cc39-cac2-4c5b-a7f5-59be1795f13a',14,'0b96bacd92de4f1aa310d96b02e2ba1b','volumes',1,'2025-12-03 10:07:20',NULL),('2025-12-02 10:07:20','2025-12-02 10:07:20','2025-12-02 10:07:20',1,60,'d0f7aae8-3720-4d2e-af39-0ec69bd0a10c',15,'0b96bacd92de4f1aa310d96b02e2ba1b','gigabytes',1,'2025-12-03 10:07:20',NULL),('2025-12-02 10:07:20','2025-12-02 10:07:20','2025-12-02 10:07:20',1,61,'c2de4500-1f46-498b-a56e-9a515cbe811f',16,'0b96bacd92de4f1aa310d96b02e2ba1b','volumes_tripleo',1,'2025-12-03 10:07:20',NULL),('2025-12-02 10:07:20','2025-12-02 10:07:20','2025-12-02 10:07:20',1,62,'778bc130-0890-4cbc-a056-379d618309a9',17,'0b96bacd92de4f1aa310d96b02e2ba1b','gigabytes_tripleo',1,'2025-12-03 10:07:20',NULL),('2025-12-02 10:07:21','2025-12-02 10:07:21','2025-12-02 10:07:21',1,63,'48518007-e401-4b6a-9d4a-334fdac3859d',8,'ef69e828801540619536106b3b481b20','volumes',-1,'2025-12-03 10:07:21',NULL),('2025-12-02 10:07:21','2025-12-02 10:07:21','2025-12-02 10:07:21',1,64,'20f7cdcb-452c-4f3d-a67f-916ba49fc4f5',9,'ef69e828801540619536106b3b481b20','gigabytes',-1,'2025-12-03 10:07:21',NULL),('2025-12-02 10:07:21','2025-12-02 10:07:21','2025-12-02 10:07:21',1,65,'21621906-b8bd-4648-968f-bdb7276544dc',12,'ef69e828801540619536106b3b481b20','volumes_volume-type-2',-1,'2025-12-03 10:07:21',NULL),('2025-12-02 10:07:21','2025-12-02 10:07:21','2025-12-02 10:07:21',1,66,'2c47b8eb-865c-4ad1-bd6b-63bcc72ab85f',13,'ef69e828801540619536106b3b481b20','gigabytes_volume-type-2',-1,'2025-12-03 10:07:21',NULL),('2025-12-02 10:07:22','2025-12-02 10:07:23','2025-12-02 10:07:23',1,67,'2e65d89b-20f0-40ee-8971-48aef4a60c5b',18,'00428a58903e487bb33ddf74c19e4f17','volumes',1,'2025-12-03 10:07:22',NULL),('2025-12-02 10:07:22','2025-12-02 10:07:23','2025-12-02 10:07:23',1,68,'e276166c-d012-4ff6-b230-3c6f4d828d1e',19,'00428a58903e487bb33ddf74c19e4f17','gigabytes',1,'2025-12-03 10:07:22',NULL),('2025-12-02 10:07:22','2025-12-02 10:07:23','2025-12-02 10:07:23',1,69,'30a2ae60-2fd6-4884-8ed0-8d8ee973d2e5',20,'00428a58903e487bb33ddf74c19e4f17','volumes_tripleo',1,'2025-12-03 10:07:22',NULL),('2025-12-02 10:07:22','2025-12-02 10:07:23','2025-12-02 10:07:23',1,70,'5c14b3d5-63d4-4fe7-b33a-b3580c81031a',21,'00428a58903e487bb33ddf74c19e4f17','gigabytes_tripleo',1,'2025-12-03 10:07:22',NULL),('2025-12-02 10:07:22','2025-12-02 10:07:23','2025-12-02 10:07:23',1,71,'aee5b038-dd61-4c43-9709-da66fad981bf',14,'0b96bacd92de4f1aa310d96b02e2ba1b','volumes',-1,'2025-12-03 10:07:22',NULL),('2025-12-02 10:07:22','2025-12-02 10:07:23','2025-12-02 10:07:23',1,72,'79ed0c7c-136d-4b12-bf43-3b258f2828ed',15,'0b96bacd92de4f1aa310d96b02e2ba1b','gigabytes',-1,'2025-12-03 10:07:22',NULL),('2025-12-02 10:07:22','2025-12-02 10:07:23','2025-12-02 10:07:23',1,73,'902af7d9-e24a-4385-9a43-76e0445c2eb8',16,'0b96bacd92de4f1aa310d96b02e2ba1b','volumes_tripleo',-1,'2025-12-03 10:07:22',NULL),('2025-12-02 10:07:22','2025-12-02 10:07:23','2025-12-02 10:07:23',1,74,'1ce0ebfb-6b8c-4bc1-8a52-4065315e2641',17,'0b96bacd92de4f1aa310d96b02e2ba1b','gigabytes_tripleo',-1,'2025-12-03 10:07:22',NULL),('2025-12-02 10:07:22','2025-12-02 10:07:23','2025-12-02 10:07:23',1,75,'c8b93682-6094-468c-b99e-0ec9316cf5b6',22,'00428a58903e487bb33ddf74c19e4f17','snapshots',0,'2025-12-03 10:07:22',NULL),('2025-12-02 10:07:22','2025-12-02 10:07:23','2025-12-02 10:07:23',1,76,'b7b54c1b-c5ac-4c87-a2cf-bb770fac08d5',19,'00428a58903e487bb33ddf74c19e4f17','gigabytes',0,'2025-12-03 10:07:22',NULL),('2025-12-02 10:07:22','2025-12-02 10:07:23','2025-12-02 10:07:23',1,77,'96d0feef-3b8d-44cd-a607-d0f40a1f86eb',21,'00428a58903e487bb33ddf74c19e4f17','gigabytes_tripleo',0,'2025-12-03 10:07:22',NULL),('2025-12-02 10:07:22','2025-12-02 10:07:23','2025-12-02 10:07:23',1,78,'b7cc4b9c-b8e8-4be3-96b5-cc172c43cb6b',23,'00428a58903e487bb33ddf74c19e4f17','snapshots_tripleo',0,'2025-12-03 10:07:22',NULL),('2025-12-02 10:07:23','2025-12-02 10:07:23','2025-12-02 10:07:23',1,79,'8c0a7738-f148-4b75-9e7b-ee942bae27ca',24,'0b96bacd92de4f1aa310d96b02e2ba1b','snapshots',0,'2025-12-03 10:07:22',NULL),('2025-12-02 10:07:23','2025-12-02 10:07:23','2025-12-02 10:07:23',1,80,'0483a59d-4e4a-4ce5-9046-fd2c0d66ae71',15,'0b96bacd92de4f1aa310d96b02e2ba1b','gigabytes',0,'2025-12-03 10:07:22',NULL),('2025-12-02 10:07:23','2025-12-02 10:07:23','2025-12-02 10:07:23',1,81,'2cc456be-a3a9-485a-ab1e-8c515c8c069c',17,'0b96bacd92de4f1aa310d96b02e2ba1b','gigabytes_tripleo',0,'2025-12-03 10:07:22',NULL),('2025-12-02 10:07:23','2025-12-02 10:07:23','2025-12-02 10:07:23',1,82,'4b91acf2-d58a-43cb-a0e2-49f3b6c01ebb',25,'0b96bacd92de4f1aa310d96b02e2ba1b','snapshots_tripleo',0,'2025-12-03 10:07:22',NULL),('2025-12-02 10:07:24','2025-12-02 10:07:25','2025-12-02 10:07:25',1,83,'b3577af9-d4e8-4245-8ef6-01dade55185d',18,'00428a58903e487bb33ddf74c19e4f17','volumes',-1,'2025-12-03 10:07:23',NULL),('2025-12-02 10:07:24','2025-12-02 10:07:25','2025-12-02 10:07:25',1,84,'d7ea2ee5-032c-4893-b895-d44951e6a338',19,'00428a58903e487bb33ddf74c19e4f17','gigabytes',-1,'2025-12-03 10:07:23',NULL),('2025-12-02 10:07:24','2025-12-02 10:07:25','2025-12-02 10:07:25',1,85,'50bb2d39-5c55-4faa-ad5c-8cd25320d8f1',20,'00428a58903e487bb33ddf74c19e4f17','volumes_tripleo',-1,'2025-12-03 10:07:23',NULL),('2025-12-02 10:07:24','2025-12-02 10:07:25','2025-12-02 10:07:25',1,86,'94dbec72-d2a5-485d-bc7c-36da754c8810',21,'00428a58903e487bb33ddf74c19e4f17','gigabytes_tripleo',-1,'2025-12-03 10:07:23',NULL),('2025-12-02 10:07:26','2025-12-02 10:07:26','2025-12-02 10:07:26',1,87,'a95d566b-b704-4469-8fb4-e63286f86b90',14,'0b96bacd92de4f1aa310d96b02e2ba1b','volumes',1,'2025-12-03 10:07:26',NULL),('2025-12-02 10:07:26','2025-12-02 10:07:26','2025-12-02 10:07:26',1,88,'db964691-4557-4a0a-8784-315ba2261e61',15,'0b96bacd92de4f1aa310d96b02e2ba1b','gigabytes',1,'2025-12-03 10:07:26',NULL),('2025-12-02 10:07:26','2025-12-02 10:07:26','2025-12-02 10:07:26',1,89,'c54d22e6-f5e4-49c4-bc4f-d63f3fb76be4',16,'0b96bacd92de4f1aa310d96b02e2ba1b','volumes_tripleo',1,'2025-12-03 10:07:26',NULL),('2025-12-02 10:07:26','2025-12-02 10:07:26','2025-12-02 10:07:26',1,90,'557492e8-99b1-4c8f-8cdb-36e082e897d3',17,'0b96bacd92de4f1aa310d96b02e2ba1b','gigabytes_tripleo',1,'2025-12-03 10:07:26',NULL),('2025-12-02 10:07:28','2025-12-02 10:07:28','2025-12-02 10:07:28',1,91,'47812d75-2280-430a-9adb-09effd309ad4',14,'0b96bacd92de4f1aa310d96b02e2ba1b','volumes',-1,'2025-12-03 10:07:28',NULL),('2025-12-02 10:07:28','2025-12-02 10:07:28','2025-12-02 10:07:28',1,92,'b67d2892-8d8a-4a74-a274-e6fbfffc85d7',15,'0b96bacd92de4f1aa310d96b02e2ba1b','gigabytes',-1,'2025-12-03 10:07:28',NULL),('2025-12-02 10:07:28','2025-12-02 10:07:28','2025-12-02 10:07:28',1,93,'e79156c4-8d74-46f9-b263-d699b5931d7a',16,'0b96bacd92de4f1aa310d96b02e2ba1b','volumes_tripleo',-1,'2025-12-03 10:07:28',NULL),('2025-12-02 10:07:28','2025-12-02 10:07:28','2025-12-02 10:07:28',1,94,'fd6a9569-bb23-4c9c-82ab-fb156ba25134',17,'0b96bacd92de4f1aa310d96b02e2ba1b','gigabytes_tripleo',-1,'2025-12-03 10:07:28',NULL),('2025-12-02 10:07:33','2025-12-02 10:07:33','2025-12-02 10:07:33',1,95,'8e4d7fc5-2f5a-4e4d-9f8a-51ee2989338c',26,'42538761f9f84e7684580411ccae9cb6','volumes',1,'2025-12-03 10:07:33',NULL),('2025-12-02 10:07:33','2025-12-02 10:07:33','2025-12-02 10:07:33',1,96,'07836c22-6414-4dc2-9185-1c1ec86eb4a9',27,'42538761f9f84e7684580411ccae9cb6','gigabytes',1,'2025-12-03 10:07:33',NULL),('2025-12-02 10:07:33','2025-12-02 10:07:33','2025-12-02 10:07:33',1,97,'c1e38b57-a8f6-4090-93c4-0913a1bf71ea',28,'42538761f9f84e7684580411ccae9cb6','volumes_tripleo',1,'2025-12-03 10:07:33',NULL),('2025-12-02 10:07:33','2025-12-02 10:07:33','2025-12-02 10:07:33',1,98,'bdec18eb-9ff6-4658-96a9-097c9177ca97',29,'42538761f9f84e7684580411ccae9cb6','gigabytes_tripleo',1,'2025-12-03 10:07:33',NULL),('2025-12-02 10:07:35','2025-12-02 10:07:35','2025-12-02 10:07:35',1,99,'4fef7386-67be-405e-b605-64433e01ecf1',26,'42538761f9f84e7684580411ccae9cb6','volumes',-1,'2025-12-03 10:07:35',NULL),('2025-12-02 10:07:35','2025-12-02 10:07:35','2025-12-02 10:07:35',1,100,'3921535b-b1aa-46b2-9257-05426420079c',27,'42538761f9f84e7684580411ccae9cb6','gigabytes',-1,'2025-12-03 10:07:35',NULL),('2025-12-02 10:07:35','2025-12-02 10:07:35','2025-12-02 10:07:35',1,101,'fa42ff77-e7a2-4b81-a81b-3c724ad41dfa',28,'42538761f9f84e7684580411ccae9cb6','volumes_tripleo',-1,'2025-12-03 10:07:35',NULL),('2025-12-02 10:07:35','2025-12-02 10:07:35','2025-12-02 10:07:35',1,102,'c5d0dcbb-3a35-4cb6-af99-a82b2bb0b591',29,'42538761f9f84e7684580411ccae9cb6','gigabytes_tripleo',-1,'2025-12-03 10:07:35',NULL),('2025-12-02 10:07:59','2025-12-02 10:07:59','2025-12-02 10:07:59',1,103,'bd4ebef3-cfee-4c0b-8b4d-4137047f919d',30,'6963976a36c6408c9336062feaef5d1f','groups',1,'2025-12-03 10:07:59',NULL),('2025-12-02 10:08:00','2025-12-02 10:08:00','2025-12-02 10:08:00',1,104,'52d0c0f2-0482-4402-850a-3babd261f6a6',31,'6963976a36c6408c9336062feaef5d1f','volumes',1,'2025-12-03 10:08:00',NULL),('2025-12-02 10:08:00','2025-12-02 10:08:00','2025-12-02 10:08:00',1,105,'ac596049-6910-470f-a28a-262049d1ffeb',32,'6963976a36c6408c9336062feaef5d1f','gigabytes',1,'2025-12-03 10:08:00',NULL),('2025-12-02 10:08:00','2025-12-02 10:08:00','2025-12-02 10:08:00',1,106,'5d26c758-514c-497e-a9f5-45a9bbfd0c31',33,'6963976a36c6408c9336062feaef5d1f','volumes_tempest-GroupSnapshotsTest-volume-type-735882371',1,'2025-12-03 10:08:00',NULL),('2025-12-02 10:08:00','2025-12-02 10:08:00','2025-12-02 10:08:00',1,107,'71fdcdaa-550f-4ef4-97fa-a173c4ed6e8c',34,'6963976a36c6408c9336062feaef5d1f','gigabytes_tempest-GroupSnapshotsTest-volume-type-735882371',1,'2025-12-03 10:08:00',NULL),('2025-12-02 10:08:02','2025-12-02 10:08:02','2025-12-02 10:08:02',1,108,'9b665993-e5a0-4c4a-af5f-583a0c3a6268',35,'6963976a36c6408c9336062feaef5d1f','snapshots',1,'2025-12-03 10:08:02',NULL),('2025-12-02 10:08:02','2025-12-02 10:08:02','2025-12-02 10:08:02',1,109,'a9ff0f66-f806-4ab5-b18d-2ef224a2842f',32,'6963976a36c6408c9336062feaef5d1f','gigabytes',1,'2025-12-03 10:08:02',NULL),('2025-12-02 10:08:02','2025-12-02 10:08:02','2025-12-02 10:08:02',1,110,'8ac41eaf-d060-44ac-a019-685a5cb35c93',34,'6963976a36c6408c9336062feaef5d1f','gigabytes_tempest-GroupSnapshotsTest-volume-type-735882371',1,'2025-12-03 10:08:02',NULL),('2025-12-02 10:08:02','2025-12-02 10:08:02','2025-12-02 10:08:02',1,111,'e5a5840a-5713-49ab-a80e-3c2f78b313b7',36,'6963976a36c6408c9336062feaef5d1f','snapshots_tempest-GroupSnapshotsTest-volume-type-735882371',1,'2025-12-03 10:08:02',NULL),('2025-12-02 10:08:04','2025-12-02 10:08:04','2025-12-02 10:08:04',1,112,'7431a0d4-ee39-4b86-bc35-c620d12c0137',30,'6963976a36c6408c9336062feaef5d1f','groups',1,'2025-12-03 10:08:04',NULL),('2025-12-02 10:08:04','2025-12-02 10:08:04','2025-12-02 10:08:04',1,113,'abc2fe83-fc9b-45ac-8a44-c5d5236994b0',31,'6963976a36c6408c9336062feaef5d1f','volumes',1,'2025-12-03 10:08:04',NULL),('2025-12-02 10:08:04','2025-12-02 10:08:04','2025-12-02 10:08:04',1,114,'61c95edb-c91a-4316-bf71-989227884ff5',33,'6963976a36c6408c9336062feaef5d1f','volumes_tempest-GroupSnapshotsTest-volume-type-735882371',1,'2025-12-03 10:08:04',NULL),('2025-12-02 10:08:07','2025-12-02 10:08:07','2025-12-02 10:08:07',1,115,'2ce3d5f1-2905-4121-aaa1-bb2b56005fc9',30,'6963976a36c6408c9336062feaef5d1f','groups',-1,'2025-12-03 10:08:07',NULL),('2025-12-02 10:08:07','2025-12-02 10:08:07','2025-12-02 10:08:07',1,116,'85dac39b-4112-42d8-8957-25b6967f57e3',31,'6963976a36c6408c9336062feaef5d1f','volumes',-1,'2025-12-03 10:08:07',NULL),('2025-12-02 10:08:07','2025-12-02 10:08:07','2025-12-02 10:08:07',1,117,'fd379755-972b-4b1b-9274-652038e369ec',32,'6963976a36c6408c9336062feaef5d1f','gigabytes',-1,'2025-12-03 10:08:07',NULL),('2025-12-02 10:08:07','2025-12-02 10:08:07','2025-12-02 10:08:07',1,118,'7876b8f2-0f0a-473f-88cf-ce81bcac4a2a',33,'6963976a36c6408c9336062feaef5d1f','volumes_tempest-GroupSnapshotsTest-volume-type-735882371',-1,'2025-12-03 10:08:07',NULL),('2025-12-02 10:08:07','2025-12-02 10:08:07','2025-12-02 10:08:07',1,119,'73a82143-93f9-47bc-9d9c-1f48625aaaf2',34,'6963976a36c6408c9336062feaef5d1f','gigabytes_tempest-GroupSnapshotsTest-volume-type-735882371',-1,'2025-12-03 10:08:07',NULL),('2025-12-02 10:08:08','2025-12-02 10:08:08','2025-12-02 10:08:08',1,120,'aac106bd-78e2-4995-a867-c0f2bf7f594c',35,'6963976a36c6408c9336062feaef5d1f','snapshots',-1,'2025-12-03 10:08:08',NULL),('2025-12-02 10:08:08','2025-12-02 10:08:08','2025-12-02 10:08:08',1,121,'84ea5e53-1092-4bdf-b3ab-e638c286519f',32,'6963976a36c6408c9336062feaef5d1f','gigabytes',-1,'2025-12-03 10:08:08',NULL),('2025-12-02 10:08:08','2025-12-02 10:08:08','2025-12-02 10:08:08',1,122,'1234f8f9-8f5e-4298-b1f4-a9d5e94760cb',34,'6963976a36c6408c9336062feaef5d1f','gigabytes_tempest-GroupSnapshotsTest-volume-type-735882371',-1,'2025-12-03 10:08:08',NULL),('2025-12-02 10:08:08','2025-12-02 10:08:08','2025-12-02 10:08:08',1,123,'9a344abb-f601-46ac-9ee6-05c776fda7f3',36,'6963976a36c6408c9336062feaef5d1f','snapshots_tempest-GroupSnapshotsTest-volume-type-735882371',-1,'2025-12-03 10:08:08',NULL),('2025-12-02 10:08:10','2025-12-02 10:08:10','2025-12-02 10:08:10',1,124,'281740eb-fe4f-4b16-8da2-665d7030825e',30,'6963976a36c6408c9336062feaef5d1f','groups',-1,'2025-12-03 10:08:10',NULL),('2025-12-02 10:08:10','2025-12-02 10:08:10','2025-12-02 10:08:10',1,125,'d74b7abb-cd91-4b62-b634-0a41b9b49ae2',31,'6963976a36c6408c9336062feaef5d1f','volumes',-1,'2025-12-03 10:08:10',NULL),('2025-12-02 10:08:10','2025-12-02 10:08:10','2025-12-02 10:08:10',1,126,'7839baec-fb9a-4594-9cb4-5d26f4f8183c',32,'6963976a36c6408c9336062feaef5d1f','gigabytes',-1,'2025-12-03 10:08:10',NULL),('2025-12-02 10:08:10','2025-12-02 10:08:10','2025-12-02 10:08:10',1,127,'d701233b-ee21-47a8-b11e-445450e172eb',33,'6963976a36c6408c9336062feaef5d1f','volumes_tempest-GroupSnapshotsTest-volume-type-735882371',-1,'2025-12-03 10:08:10',NULL),('2025-12-02 10:08:10','2025-12-02 10:08:10','2025-12-02 10:08:10',1,128,'4b6567c4-cb4b-4954-9cb4-4d5d70e3c7d4',34,'6963976a36c6408c9336062feaef5d1f','gigabytes_tempest-GroupSnapshotsTest-volume-type-735882371',-1,'2025-12-03 10:08:10',NULL),('2025-12-02 10:08:11','2025-12-02 10:08:11','2025-12-02 10:08:11',1,129,'73c2abfe-4c3e-4127-a0be-fd2a9f15983a',30,'6963976a36c6408c9336062feaef5d1f','groups',1,'2025-12-03 10:08:11',NULL),('2025-12-02 10:08:12','2025-12-02 10:08:13','2025-12-02 10:08:13',1,130,'46ab2bcc-7a36-4485-9871-0a27b52b2666',31,'6963976a36c6408c9336062feaef5d1f','volumes',1,'2025-12-03 10:08:12',NULL),('2025-12-02 10:08:12','2025-12-02 10:08:13','2025-12-02 10:08:13',1,131,'50eb4ed5-4f37-4d1b-8927-e7aeedd7dbd0',32,'6963976a36c6408c9336062feaef5d1f','gigabytes',1,'2025-12-03 10:08:12',NULL),('2025-12-02 10:08:12','2025-12-02 10:08:13','2025-12-02 10:08:13',1,132,'7eb5e272-f2c5-4644-8efd-d37d211a2e20',37,'6963976a36c6408c9336062feaef5d1f','volumes_tempest-GroupSnapshotsTest-volume-type-679191759',1,'2025-12-03 10:08:12',NULL),('2025-12-02 10:08:12','2025-12-02 10:08:13','2025-12-02 10:08:13',1,133,'cd28bbe1-8f81-4200-8cac-3185263dcdc7',38,'6963976a36c6408c9336062feaef5d1f','gigabytes_tempest-GroupSnapshotsTest-volume-type-679191759',1,'2025-12-03 10:08:12',NULL),('2025-12-02 10:08:14','2025-12-02 10:08:14','2025-12-02 10:08:14',1,134,'68bc21e6-2877-4c59-9352-7bd9d269bb71',31,'6963976a36c6408c9336062feaef5d1f','volumes',1,'2025-12-03 10:08:14',NULL),('2025-12-02 10:08:14','2025-12-02 10:08:14','2025-12-02 10:08:14',1,135,'9ae0ace2-3c4b-4683-9b08-cbaba804eb7a',32,'6963976a36c6408c9336062feaef5d1f','gigabytes',1,'2025-12-03 10:08:14',NULL),('2025-12-02 10:08:14','2025-12-02 10:08:14','2025-12-02 10:08:14',1,136,'cc339a2b-0bc3-463f-b897-b0f2abf93498',37,'6963976a36c6408c9336062feaef5d1f','volumes_tempest-GroupSnapshotsTest-volume-type-679191759',1,'2025-12-03 10:08:14',NULL),('2025-12-02 10:08:14','2025-12-02 10:08:14','2025-12-02 10:08:14',1,137,'3fe184fb-60e4-48ec-b542-565a67c630c7',38,'6963976a36c6408c9336062feaef5d1f','gigabytes_tempest-GroupSnapshotsTest-volume-type-679191759',1,'2025-12-03 10:08:14',NULL),('2025-12-02 10:08:20','2025-12-02 10:08:20','2025-12-02 10:08:20',1,138,'8647cbe8-45bf-455f-9602-28cd75e19da9',35,'6963976a36c6408c9336062feaef5d1f','snapshots',2,'2025-12-03 10:08:20',NULL),('2025-12-02 10:08:20','2025-12-02 10:08:20','2025-12-02 10:08:20',1,139,'8d17b52a-3378-4998-8feb-8c8da930c8e3',32,'6963976a36c6408c9336062feaef5d1f','gigabytes',2,'2025-12-03 10:08:20',NULL),('2025-12-02 10:08:20','2025-12-02 10:08:20','2025-12-02 10:08:20',1,140,'ebb842f1-0ff6-4dbe-b9b3-084eac7a60b9',38,'6963976a36c6408c9336062feaef5d1f','gigabytes_tempest-GroupSnapshotsTest-volume-type-679191759',2,'2025-12-03 10:08:20',NULL),('2025-12-02 10:08:20','2025-12-02 10:08:20','2025-12-02 10:08:20',1,141,'d05cf8a6-be8c-4636-861a-f347d49d39a7',39,'6963976a36c6408c9336062feaef5d1f','snapshots_tempest-GroupSnapshotsTest-volume-type-679191759',2,'2025-12-03 10:08:20',NULL),('2025-12-02 10:08:25','2025-12-02 10:08:25','2025-12-02 10:08:25',1,142,'542ba01f-dbe6-4e97-9555-da3f23a68f5e',35,'6963976a36c6408c9336062feaef5d1f','snapshots',-1,'2025-12-03 10:08:25',NULL),('2025-12-02 10:08:25','2025-12-02 10:08:25','2025-12-02 10:08:25',1,143,'ca94af51-8eae-4bbd-b37e-76a436c506bd',32,'6963976a36c6408c9336062feaef5d1f','gigabytes',-1,'2025-12-03 10:08:25',NULL),('2025-12-02 10:08:25','2025-12-02 10:08:25','2025-12-02 10:08:25',1,144,'dec09da2-d2b5-4b94-8c42-253f2d16961e',38,'6963976a36c6408c9336062feaef5d1f','gigabytes_tempest-GroupSnapshotsTest-volume-type-679191759',-1,'2025-12-03 10:08:25',NULL),('2025-12-02 10:08:25','2025-12-02 10:08:25','2025-12-02 10:08:25',1,145,'181047cd-3cd8-4f72-9083-874b31346931',39,'6963976a36c6408c9336062feaef5d1f','snapshots_tempest-GroupSnapshotsTest-volume-type-679191759',-1,'2025-12-03 10:08:25',NULL),('2025-12-02 10:08:25','2025-12-02 10:08:26','2025-12-02 10:08:26',1,146,'252988f7-3643-4df2-b0f9-c1639c056686',35,'6963976a36c6408c9336062feaef5d1f','snapshots',-1,'2025-12-03 10:08:25',NULL),('2025-12-02 10:08:25','2025-12-02 10:08:26','2025-12-02 10:08:26',1,147,'4dfef9f9-4535-4683-8822-1d736cb5ab58',32,'6963976a36c6408c9336062feaef5d1f','gigabytes',-1,'2025-12-03 10:08:25',NULL),('2025-12-02 10:08:25','2025-12-02 10:08:26','2025-12-02 10:08:26',1,148,'f4e2aafe-b66a-4eda-a2cd-a09e194e1c0d',38,'6963976a36c6408c9336062feaef5d1f','gigabytes_tempest-GroupSnapshotsTest-volume-type-679191759',-1,'2025-12-03 10:08:25',NULL),('2025-12-02 10:08:25','2025-12-02 10:08:26','2025-12-02 10:08:26',1,149,'27511679-4fea-4580-89bd-85f34d6f4004',39,'6963976a36c6408c9336062feaef5d1f','snapshots_tempest-GroupSnapshotsTest-volume-type-679191759',-1,'2025-12-03 10:08:25',NULL),('2025-12-02 10:08:27','2025-12-02 10:08:27','2025-12-02 10:08:27',1,150,'871adc9f-5b1f-4dcd-a5d4-1baa38cb5d28',30,'6963976a36c6408c9336062feaef5d1f','groups',-1,'2025-12-03 10:08:27',NULL),('2025-12-02 10:08:27','2025-12-02 10:08:27','2025-12-02 10:08:27',1,151,'f90b47bb-01d6-452d-8276-5f6c45042a24',31,'6963976a36c6408c9336062feaef5d1f','volumes',-1,'2025-12-03 10:08:27',NULL),('2025-12-02 10:08:27','2025-12-02 10:08:27','2025-12-02 10:08:27',1,152,'dbab3209-99e9-42be-aae4-4220ef880518',32,'6963976a36c6408c9336062feaef5d1f','gigabytes',-1,'2025-12-03 10:08:27',NULL),('2025-12-02 10:08:27','2025-12-02 10:08:27','2025-12-02 10:08:27',1,153,'b0688cae-a6fc-45de-9cb1-2d7e3d7541f1',37,'6963976a36c6408c9336062feaef5d1f','volumes_tempest-GroupSnapshotsTest-volume-type-679191759',-1,'2025-12-03 10:08:27',NULL),('2025-12-02 10:08:27','2025-12-02 10:08:27','2025-12-02 10:08:27',1,154,'a43dcc69-5998-4d67-9849-2de0569b85a5',38,'6963976a36c6408c9336062feaef5d1f','gigabytes_tempest-GroupSnapshotsTest-volume-type-679191759',-1,'2025-12-03 10:08:27',NULL),('2025-12-02 10:08:27','2025-12-02 10:08:27','2025-12-02 10:08:27',1,155,'4ef84e3a-0a33-4cb6-9c0b-4e31cb36dbd7',31,'6963976a36c6408c9336062feaef5d1f','volumes',-1,'2025-12-03 10:08:27',NULL),('2025-12-02 10:08:27','2025-12-02 10:08:27','2025-12-02 10:08:27',1,156,'63fab95c-7689-43c0-8bc1-083e9cf6205c',32,'6963976a36c6408c9336062feaef5d1f','gigabytes',-1,'2025-12-03 10:08:27',NULL),('2025-12-02 10:08:27','2025-12-02 10:08:27','2025-12-02 10:08:27',1,157,'1e86c1ab-2f96-45fb-b118-264e126a3984',37,'6963976a36c6408c9336062feaef5d1f','volumes_tempest-GroupSnapshotsTest-volume-type-679191759',-1,'2025-12-03 10:08:27',NULL),('2025-12-02 10:08:27','2025-12-02 10:08:27','2025-12-02 10:08:27',1,158,'a9f00660-72de-4ad2-b640-a7bc982bdd92',38,'6963976a36c6408c9336062feaef5d1f','gigabytes_tempest-GroupSnapshotsTest-volume-type-679191759',-1,'2025-12-03 10:08:27',NULL),('2025-12-02 10:08:28','2025-12-02 10:08:28','2025-12-02 10:08:28',1,159,'88231b5e-5236-4dfb-bea9-86a61579c95e',30,'6963976a36c6408c9336062feaef5d1f','groups',1,'2025-12-03 10:08:28',NULL),('2025-12-02 10:08:29','2025-12-02 10:08:29','2025-12-02 10:08:29',1,160,'54b66599-30f5-4dd4-bfa3-9d27175b3bbd',31,'6963976a36c6408c9336062feaef5d1f','volumes',1,'2025-12-03 10:08:29',NULL),('2025-12-02 10:08:29','2025-12-02 10:08:29','2025-12-02 10:08:29',1,161,'fa902b3a-f140-4cfc-a156-171df496cdfd',32,'6963976a36c6408c9336062feaef5d1f','gigabytes',1,'2025-12-03 10:08:29',NULL),('2025-12-02 10:08:29','2025-12-02 10:08:29','2025-12-02 10:08:29',1,162,'ce48a400-adbd-4eba-8c27-41fa4e54294f',40,'6963976a36c6408c9336062feaef5d1f','volumes_tempest-GroupSnapshotsTest-volume-type-400389718',1,'2025-12-03 10:08:29',NULL),('2025-12-02 10:08:29','2025-12-02 10:08:29','2025-12-02 10:08:29',1,163,'f5a2b429-eddc-47c9-99c8-cd42f904d46c',41,'6963976a36c6408c9336062feaef5d1f','gigabytes_tempest-GroupSnapshotsTest-volume-type-400389718',1,'2025-12-03 10:08:29',NULL),('2025-12-02 10:08:30','2025-12-02 10:08:30','2025-12-02 10:08:30',1,164,'460c06a3-b4c0-421b-85c4-9d70e0e1d4c7',35,'6963976a36c6408c9336062feaef5d1f','snapshots',1,'2025-12-03 10:08:30',NULL),('2025-12-02 10:08:30','2025-12-02 10:08:30','2025-12-02 10:08:30',1,165,'311babbd-304c-4e03-b181-947a3c7c1557',32,'6963976a36c6408c9336062feaef5d1f','gigabytes',1,'2025-12-03 10:08:30',NULL),('2025-12-02 10:08:30','2025-12-02 10:08:30','2025-12-02 10:08:30',1,166,'b758fc37-9db3-4f2f-b105-a9256aa09de7',41,'6963976a36c6408c9336062feaef5d1f','gigabytes_tempest-GroupSnapshotsTest-volume-type-400389718',1,'2025-12-03 10:08:30',NULL),('2025-12-02 10:08:30','2025-12-02 10:08:30','2025-12-02 10:08:30',1,167,'0f5e4812-7932-49b5-87db-2d649019be3c',42,'6963976a36c6408c9336062feaef5d1f','snapshots_tempest-GroupSnapshotsTest-volume-type-400389718',1,'2025-12-03 10:08:30',NULL),('2025-12-02 10:08:33','2025-12-02 10:08:33','2025-12-02 10:08:33',1,168,'6316ae19-e651-439f-9745-941fa50258c7',35,'6963976a36c6408c9336062feaef5d1f','snapshots',-1,'2025-12-03 10:08:33',NULL),('2025-12-02 10:08:33','2025-12-02 10:08:33','2025-12-02 10:08:33',1,169,'a4207510-bd51-4205-a3bb-54a6184c795d',32,'6963976a36c6408c9336062feaef5d1f','gigabytes',-1,'2025-12-03 10:08:33',NULL),('2025-12-02 10:08:33','2025-12-02 10:08:33','2025-12-02 10:08:33',1,170,'0ec7deb9-a23d-42fc-ac7c-06c90128e08d',41,'6963976a36c6408c9336062feaef5d1f','gigabytes_tempest-GroupSnapshotsTest-volume-type-400389718',-1,'2025-12-03 10:08:33',NULL),('2025-12-02 10:08:33','2025-12-02 10:08:33','2025-12-02 10:08:33',1,171,'b5266dcb-6a9f-4cce-b69f-7e349bd63830',42,'6963976a36c6408c9336062feaef5d1f','snapshots_tempest-GroupSnapshotsTest-volume-type-400389718',-1,'2025-12-03 10:08:33',NULL),('2025-12-02 10:08:35','2025-12-02 10:08:35','2025-12-02 10:08:35',1,172,'f8e2170b-18c2-48c4-8b09-dc0ea64952be',30,'6963976a36c6408c9336062feaef5d1f','groups',-1,'2025-12-03 10:08:35',NULL),('2025-12-02 10:08:35','2025-12-02 10:08:35','2025-12-02 10:08:35',1,173,'03cb6d32-408c-4640-bf66-198d182c10bd',31,'6963976a36c6408c9336062feaef5d1f','volumes',-1,'2025-12-03 10:08:35',NULL),('2025-12-02 10:08:35','2025-12-02 10:08:35','2025-12-02 10:08:35',1,174,'3b78ba83-353c-4252-8c3f-ebc789a3f179',32,'6963976a36c6408c9336062feaef5d1f','gigabytes',-1,'2025-12-03 10:08:35',NULL),('2025-12-02 10:08:35','2025-12-02 10:08:35','2025-12-02 10:08:35',1,175,'34b4dcfc-e310-441e-9d93-ec93c0ebb6b9',40,'6963976a36c6408c9336062feaef5d1f','volumes_tempest-GroupSnapshotsTest-volume-type-400389718',-1,'2025-12-03 10:08:35',NULL),('2025-12-02 10:08:35','2025-12-02 10:08:35','2025-12-02 10:08:35',1,176,'8ec99d26-5bf1-4537-a8a3-c3e74badf835',41,'6963976a36c6408c9336062feaef5d1f','gigabytes_tempest-GroupSnapshotsTest-volume-type-400389718',-1,'2025-12-03 10:08:35',NULL),('2025-12-02 10:08:56','2025-12-02 10:08:56','2025-12-02 10:08:56',1,177,'67ebea12-e32a-456c-aa55-9b76d6a79f86',43,'88ada1dc04884eb0b3013bc2d2c4917c','volumes',1,'2025-12-03 10:08:56',NULL),('2025-12-02 10:08:56','2025-12-02 10:08:56','2025-12-02 10:08:56',1,178,'2e243a2a-54b0-4750-83eb-20adaee42be3',44,'88ada1dc04884eb0b3013bc2d2c4917c','gigabytes',1,'2025-12-03 10:08:56',NULL),('2025-12-02 10:08:56','2025-12-02 10:08:56','2025-12-02 10:08:56',1,179,'5ebd9f66-2fcd-46da-a3d3-849aab973996',45,'88ada1dc04884eb0b3013bc2d2c4917c','volumes_tempest-UserMessagesTest-volume-type-526789726',1,'2025-12-03 10:08:56',NULL),('2025-12-02 10:08:56','2025-12-02 10:08:56','2025-12-02 10:08:56',1,180,'fc1b4c76-8b3a-4121-9a16-5adbe4c11a8e',46,'88ada1dc04884eb0b3013bc2d2c4917c','gigabytes_tempest-UserMessagesTest-volume-type-526789726',1,'2025-12-03 10:08:56',NULL),('2025-12-02 10:08:57','2025-12-02 10:08:58','2025-12-02 10:08:58',1,181,'9776a70f-5f79-46bf-ae90-9dcabced89e3',43,'88ada1dc04884eb0b3013bc2d2c4917c','volumes',-1,'2025-12-03 10:08:57',NULL),('2025-12-02 10:08:57','2025-12-02 10:08:58','2025-12-02 10:08:58',1,182,'d0c5380b-5b72-4d12-82c8-c5bd0429b342',44,'88ada1dc04884eb0b3013bc2d2c4917c','gigabytes',-1,'2025-12-03 10:08:57',NULL),('2025-12-02 10:08:57','2025-12-02 10:08:58','2025-12-02 10:08:58',1,183,'d381b747-6ebc-49ba-9123-c934ca21e593',45,'88ada1dc04884eb0b3013bc2d2c4917c','volumes_tempest-UserMessagesTest-volume-type-526789726',-1,'2025-12-03 10:08:57',NULL),('2025-12-02 10:08:57','2025-12-02 10:08:58','2025-12-02 10:08:58',1,184,'6d2f0d9d-58a7-4bf6-a95e-6382e6f626cc',46,'88ada1dc04884eb0b3013bc2d2c4917c','gigabytes_tempest-UserMessagesTest-volume-type-526789726',-1,'2025-12-03 10:08:57',NULL),('2025-12-02 10:08:58','2025-12-02 10:08:58','2025-12-02 10:08:58',1,185,'d8fe4671-3ca2-4a13-a8c8-c11b04f9f74c',43,'88ada1dc04884eb0b3013bc2d2c4917c','volumes',1,'2025-12-03 10:08:58',NULL),('2025-12-02 10:08:58','2025-12-02 10:08:58','2025-12-02 10:08:58',1,186,'5a83dca6-2520-4331-a6f1-a820e45ffe15',44,'88ada1dc04884eb0b3013bc2d2c4917c','gigabytes',1,'2025-12-03 10:08:58',NULL),('2025-12-02 10:08:58','2025-12-02 10:08:58','2025-12-02 10:08:58',1,187,'2d4c812d-9982-42cc-a888-d4c35cf83ec8',47,'88ada1dc04884eb0b3013bc2d2c4917c','volumes_tempest-UserMessagesTest-volume-type-1867302679',1,'2025-12-03 10:08:58',NULL),('2025-12-02 10:08:58','2025-12-02 10:08:58','2025-12-02 10:08:58',1,188,'5c0dc68b-e339-4fe2-a26a-7757a54def34',48,'88ada1dc04884eb0b3013bc2d2c4917c','gigabytes_tempest-UserMessagesTest-volume-type-1867302679',1,'2025-12-03 10:08:58',NULL),('2025-12-02 10:08:59','2025-12-02 10:09:00','2025-12-02 10:09:00',1,189,'fb62d998-873b-4185-9b7f-8c0c67236070',43,'88ada1dc04884eb0b3013bc2d2c4917c','volumes',-1,'2025-12-03 10:08:59',NULL),('2025-12-02 10:08:59','2025-12-02 10:09:00','2025-12-02 10:09:00',1,190,'e3f5282c-ce55-4c0c-95af-7f15452cbae0',44,'88ada1dc04884eb0b3013bc2d2c4917c','gigabytes',-1,'2025-12-03 10:08:59',NULL),('2025-12-02 10:08:59','2025-12-02 10:09:00','2025-12-02 10:09:00',1,191,'c450fd4b-02da-4428-8a01-c2d4154a09e9',47,'88ada1dc04884eb0b3013bc2d2c4917c','volumes_tempest-UserMessagesTest-volume-type-1867302679',-1,'2025-12-03 10:08:59',NULL),('2025-12-02 10:08:59','2025-12-02 10:09:00','2025-12-02 10:09:00',1,192,'b7fba4e0-6a48-4c0f-9c7b-4c78cef526fc',48,'88ada1dc04884eb0b3013bc2d2c4917c','gigabytes_tempest-UserMessagesTest-volume-type-1867302679',-1,'2025-12-03 10:08:59',NULL),('2025-12-02 10:09:10','2025-12-02 10:09:10','2025-12-02 10:09:10',1,193,'3eb51a46-e62f-4c38-a447-ecab3d4b7759',49,'d077375432eb4d5983dfbe6a6927c321','volumes',1,'2025-12-03 10:09:10',NULL),('2025-12-02 10:09:10','2025-12-02 10:09:10','2025-12-02 10:09:10',1,194,'f6e0f91d-d6ee-480b-a7e5-42545fcaf05a',50,'d077375432eb4d5983dfbe6a6927c321','gigabytes',1,'2025-12-03 10:09:10',NULL),('2025-12-02 10:09:10','2025-12-02 10:09:10','2025-12-02 10:09:10',1,195,'08d438bc-c602-40c6-97c7-3959ede67bc5',51,'d077375432eb4d5983dfbe6a6927c321','volumes_tripleo',1,'2025-12-03 10:09:10',NULL),('2025-12-02 10:09:10','2025-12-02 10:09:10','2025-12-02 10:09:10',1,196,'ffb2d682-0a60-4a5e-b556-4321aec7bcb2',52,'d077375432eb4d5983dfbe6a6927c321','gigabytes_tripleo',1,'2025-12-03 10:09:10',NULL),('2025-12-02 10:09:11','2025-12-02 10:09:11','2025-12-02 10:09:11',1,197,'16598625-3458-4af4-b85e-0b8af0b9089c',49,'d077375432eb4d5983dfbe6a6927c321','volumes',1,'2025-12-03 10:09:11',NULL),('2025-12-02 10:09:11','2025-12-02 10:09:11','2025-12-02 10:09:11',1,198,'9ecde1fd-6d9a-47fd-803e-48cfcd758c0b',50,'d077375432eb4d5983dfbe6a6927c321','gigabytes',1,'2025-12-03 10:09:11',NULL),('2025-12-02 10:09:11','2025-12-02 10:09:11','2025-12-02 10:09:11',1,199,'4ad52f91-c402-4188-a27c-6a71f1dd44b8',51,'d077375432eb4d5983dfbe6a6927c321','volumes_tripleo',1,'2025-12-03 10:09:11',NULL),('2025-12-02 10:09:11','2025-12-02 10:09:11','2025-12-02 10:09:11',1,200,'d5ed8685-25cf-4677-b482-cc6896b41302',52,'d077375432eb4d5983dfbe6a6927c321','gigabytes_tripleo',1,'2025-12-03 10:09:11',NULL),('2025-12-02 10:09:13','2025-12-02 10:09:13','2025-12-02 10:09:13',1,201,'119ba049-b3b3-4aa6-a521-2e7e5431d39e',49,'d077375432eb4d5983dfbe6a6927c321','volumes',1,'2025-12-03 10:09:13',NULL),('2025-12-02 10:09:13','2025-12-02 10:09:13','2025-12-02 10:09:13',1,202,'470fa586-1159-452e-bae2-95bfd4540eaa',50,'d077375432eb4d5983dfbe6a6927c321','gigabytes',1,'2025-12-03 10:09:13',NULL),('2025-12-02 10:09:13','2025-12-02 10:09:13','2025-12-02 10:09:13',1,203,'878ab10e-2d4e-4d88-a9a8-a1d3ab19483a',51,'d077375432eb4d5983dfbe6a6927c321','volumes_tripleo',1,'2025-12-03 10:09:13',NULL),('2025-12-02 10:09:13','2025-12-02 10:09:13','2025-12-02 10:09:13',1,204,'30839133-ca32-48aa-97b1-bc2224a1be78',52,'d077375432eb4d5983dfbe6a6927c321','gigabytes_tripleo',1,'2025-12-03 10:09:13',NULL),('2025-12-02 10:09:14','2025-12-02 10:09:14','2025-12-02 10:09:14',1,205,'9c93b91a-24b6-477c-a61c-6b0288f94751',53,'99d88ed9db6a44ad8671401d30ce29a3','volumes',1,'2025-12-03 10:09:14',NULL),('2025-12-02 10:09:14','2025-12-02 10:09:14','2025-12-02 10:09:14',1,206,'fdb398fb-3d49-42a1-81fa-127989f072d4',54,'99d88ed9db6a44ad8671401d30ce29a3','gigabytes',1,'2025-12-03 10:09:14',NULL),('2025-12-02 10:09:14','2025-12-02 10:09:14','2025-12-02 10:09:14',1,207,'8dab91bd-087d-4dd4-a3ec-32a810ea3876',55,'99d88ed9db6a44ad8671401d30ce29a3','volumes_tripleo',1,'2025-12-03 10:09:14',NULL),('2025-12-02 10:09:14','2025-12-02 10:09:14','2025-12-02 10:09:14',1,208,'1a8c64ba-d420-4d81-a8e6-2ffc8b6a5dfd',56,'99d88ed9db6a44ad8671401d30ce29a3','gigabytes_tripleo',1,'2025-12-03 10:09:14',NULL),('2025-12-02 10:09:17','2025-12-02 10:09:18','2025-12-02 10:09:18',1,209,'d150aa15-2887-4d85-9b55-d5d1c300f2b0',53,'99d88ed9db6a44ad8671401d30ce29a3','volumes',-1,'2025-12-03 10:09:16',NULL),('2025-12-02 10:09:17','2025-12-02 10:09:18','2025-12-02 10:09:18',1,210,'8da19df4-f43d-4b4f-bb43-bdef56656dea',54,'99d88ed9db6a44ad8671401d30ce29a3','gigabytes',-1,'2025-12-03 10:09:16',NULL),('2025-12-02 10:09:17','2025-12-02 10:09:18','2025-12-02 10:09:18',1,211,'0fb39c0a-fa66-4ddb-b849-ff99553bc768',55,'99d88ed9db6a44ad8671401d30ce29a3','volumes_tripleo',-1,'2025-12-03 10:09:16',NULL),('2025-12-02 10:09:17','2025-12-02 10:09:18','2025-12-02 10:09:18',1,212,'481e56b6-6ccc-40c0-993e-6316a0b2ad98',56,'99d88ed9db6a44ad8671401d30ce29a3','gigabytes_tripleo',-1,'2025-12-03 10:09:16',NULL),('2025-12-02 10:09:17','2025-12-02 10:09:19','2025-12-02 10:09:19',1,213,'634aaaa5-98f8-414d-869c-c7f6623c3b31',49,'d077375432eb4d5983dfbe6a6927c321','volumes',-1,'2025-12-03 10:09:17',NULL),('2025-12-02 10:09:17','2025-12-02 10:09:19','2025-12-02 10:09:19',1,214,'160c800f-3d13-4f60-bf96-dc330a15fccd',50,'d077375432eb4d5983dfbe6a6927c321','gigabytes',-1,'2025-12-03 10:09:17',NULL),('2025-12-02 10:09:17','2025-12-02 10:09:19','2025-12-02 10:09:19',1,215,'4569830c-7cd3-4da9-8696-abf4dd9d9290',51,'d077375432eb4d5983dfbe6a6927c321','volumes_tripleo',-1,'2025-12-03 10:09:17',NULL),('2025-12-02 10:09:17','2025-12-02 10:09:19','2025-12-02 10:09:19',1,216,'a3f6242e-e532-41cd-8392-d15cde4381d4',52,'d077375432eb4d5983dfbe6a6927c321','gigabytes_tripleo',-1,'2025-12-03 10:09:17',NULL),('2025-12-02 10:09:20','2025-12-02 10:09:20','2025-12-02 10:09:20',1,217,'6c216483-1bda-4315-a9d0-95ce4cc20ff0',49,'d077375432eb4d5983dfbe6a6927c321','volumes',-1,'2025-12-03 10:09:20',NULL),('2025-12-02 10:09:20','2025-12-02 10:09:20','2025-12-02 10:09:20',1,218,'48eea1df-fadb-468a-a6c1-2ad4f55e784a',50,'d077375432eb4d5983dfbe6a6927c321','gigabytes',-1,'2025-12-03 10:09:20',NULL),('2025-12-02 10:09:20','2025-12-02 10:09:20','2025-12-02 10:09:20',1,219,'f4b426cd-9e16-4da6-94bf-096a785fc619',51,'d077375432eb4d5983dfbe6a6927c321','volumes_tripleo',-1,'2025-12-03 10:09:20',NULL),('2025-12-02 10:09:20','2025-12-02 10:09:20','2025-12-02 10:09:20',1,220,'4cd5a238-7609-4e5f-8699-67588dfb1ac2',52,'d077375432eb4d5983dfbe6a6927c321','gigabytes_tripleo',-1,'2025-12-03 10:09:20',NULL),('2025-12-02 10:09:21','2025-12-02 10:09:21','2025-12-02 10:09:21',1,221,'1274eb41-36d0-4ba0-a434-f6e7b1a6d2c1',49,'d077375432eb4d5983dfbe6a6927c321','volumes',-1,'2025-12-03 10:09:21',NULL),('2025-12-02 10:09:21','2025-12-02 10:09:21','2025-12-02 10:09:21',1,222,'4d5fb287-101c-436b-9dca-ba461bd41624',50,'d077375432eb4d5983dfbe6a6927c321','gigabytes',-1,'2025-12-03 10:09:21',NULL),('2025-12-02 10:09:21','2025-12-02 10:09:21','2025-12-02 10:09:21',1,223,'ddad86b0-c6d7-4e3c-ad4c-559ca4120f5b',51,'d077375432eb4d5983dfbe6a6927c321','volumes_tripleo',-1,'2025-12-03 10:09:21',NULL),('2025-12-02 10:09:21','2025-12-02 10:09:21','2025-12-02 10:09:21',1,224,'db2074ca-a752-44d3-9b4a-7c1b7190a3af',52,'d077375432eb4d5983dfbe6a6927c321','gigabytes_tripleo',-1,'2025-12-03 10:09:21',NULL),('2025-12-02 10:09:32','2025-12-02 10:09:32','2025-12-02 10:09:32',1,225,'3433f42e-bd3a-403c-903f-af3d55e4a517',57,'6c1597b25b33405db70f223b571f21b7','volumes',1,'2025-12-03 10:09:32',NULL),('2025-12-02 10:09:32','2025-12-02 10:09:32','2025-12-02 10:09:32',1,226,'096fa712-9ee6-44d2-83a5-973223c756a5',58,'6c1597b25b33405db70f223b571f21b7','gigabytes',1,'2025-12-03 10:09:32',NULL),('2025-12-02 10:09:32','2025-12-02 10:09:32','2025-12-02 10:09:32',1,227,'96796258-89fb-44bf-b420-1e5056a0ad46',59,'6c1597b25b33405db70f223b571f21b7','volumes_tripleo',1,'2025-12-03 10:09:32',NULL),('2025-12-02 10:09:32','2025-12-02 10:09:32','2025-12-02 10:09:32',1,228,'9adfb82d-4899-4bc7-8481-37b5eb07f6c9',60,'6c1597b25b33405db70f223b571f21b7','gigabytes_tripleo',1,'2025-12-03 10:09:32',NULL),('2025-12-02 10:09:42','2025-12-02 10:09:42','2025-12-02 10:09:42',1,229,'9dacd039-ecca-4ce8-8f83-67071f65d0a2',57,'6c1597b25b33405db70f223b571f21b7','volumes',-1,'2025-12-03 10:09:42',NULL),('2025-12-02 10:09:42','2025-12-02 10:09:42','2025-12-02 10:09:42',1,230,'84b193e4-59df-42f5-9879-4420b277dcc1',58,'6c1597b25b33405db70f223b571f21b7','gigabytes',-1,'2025-12-03 10:09:42',NULL),('2025-12-02 10:09:42','2025-12-02 10:09:42','2025-12-02 10:09:42',1,231,'e91113e5-6313-4473-ad45-5e949961ff22',59,'6c1597b25b33405db70f223b571f21b7','volumes_tripleo',-1,'2025-12-03 10:09:42',NULL),('2025-12-02 10:09:42','2025-12-02 10:09:42','2025-12-02 10:09:42',1,232,'82cf86e1-2a26-4868-b523-e73c9e5fda99',60,'6c1597b25b33405db70f223b571f21b7','gigabytes_tripleo',-1,'2025-12-03 10:09:42',NULL),('2025-12-02 10:10:03','2025-12-02 10:10:03','2025-12-02 10:10:03',1,233,'aac05750-3297-4071-89ae-e606eec6f10d',61,'5bad680c763640dba71a7865b355817c','volumes',1,'2025-12-03 10:10:03',NULL),('2025-12-02 10:10:03','2025-12-02 10:10:03','2025-12-02 10:10:03',1,234,'60cd0318-1e09-497b-84a3-cc076f559a98',62,'5bad680c763640dba71a7865b355817c','gigabytes',1,'2025-12-03 10:10:03',NULL),('2025-12-02 10:10:03','2025-12-02 10:10:03','2025-12-02 10:10:03',1,235,'cd07835f-12a0-4437-8ffa-2e672d3a59c3',63,'5bad680c763640dba71a7865b355817c','volumes_tripleo',1,'2025-12-03 10:10:03',NULL),('2025-12-02 10:10:03','2025-12-02 10:10:03','2025-12-02 10:10:03',1,236,'e628d970-b95e-4420-a896-2e5fc576f05d',64,'5bad680c763640dba71a7865b355817c','gigabytes_tripleo',1,'2025-12-03 10:10:03',NULL),('2025-12-02 10:10:52','2025-12-02 10:10:52','2025-12-02 10:10:52',1,237,'7d2b6234-17a1-4fa1-bb53-14bea2581d6f',61,'5bad680c763640dba71a7865b355817c','volumes',-1,'2025-12-03 10:10:52',NULL),('2025-12-02 10:10:52','2025-12-02 10:10:52','2025-12-02 10:10:52',1,238,'b74a3fa7-7ed4-4c77-b35a-9637ec61b4bd',62,'5bad680c763640dba71a7865b355817c','gigabytes',-1,'2025-12-03 10:10:52',NULL),('2025-12-02 10:10:52','2025-12-02 10:10:52','2025-12-02 10:10:52',1,239,'a98332b0-87c3-42f3-9eb2-7b5fd007cab2',63,'5bad680c763640dba71a7865b355817c','volumes_tripleo',-1,'2025-12-03 10:10:52',NULL),('2025-12-02 10:10:52','2025-12-02 10:10:52','2025-12-02 10:10:52',1,240,'82f4e06f-fc6b-4e4b-ada3-ad7f7aeeef97',64,'5bad680c763640dba71a7865b355817c','gigabytes_tripleo',-1,'2025-12-03 10:10:52',NULL),('2025-12-02 10:10:52','2025-12-02 10:10:52','2025-12-02 10:10:52',1,241,'f5ceca7b-4872-4e7a-a3a8-5e5eaf7f4ec8',65,'f7326c3837b4427191aafcff504110ac','volumes',1,'2025-12-03 10:10:52',NULL),('2025-12-02 10:10:52','2025-12-02 10:10:52','2025-12-02 10:10:52',1,242,'e5f4df9f-848c-407a-aede-b1fa408da01d',66,'f7326c3837b4427191aafcff504110ac','gigabytes',1,'2025-12-03 10:10:52',NULL),('2025-12-02 10:10:52','2025-12-02 10:10:52','2025-12-02 10:10:52',1,243,'3ffea651-f605-48ed-a728-a41f168421c7',67,'f7326c3837b4427191aafcff504110ac','volumes_tripleo',1,'2025-12-03 10:10:52',NULL),('2025-12-02 10:10:52','2025-12-02 10:10:52','2025-12-02 10:10:52',1,244,'15fe6ab0-d4d8-4d39-a37d-b0eb7970bc9d',68,'f7326c3837b4427191aafcff504110ac','gigabytes_tripleo',1,'2025-12-03 10:10:52',NULL),('2025-12-02 10:10:54','2025-12-02 10:10:54','2025-12-02 10:10:54',1,245,'1eb9335a-2dc2-45f2-8878-2c2643119f8d',65,'f7326c3837b4427191aafcff504110ac','volumes',-1,'2025-12-03 10:10:54',NULL),('2025-12-02 10:10:54','2025-12-02 10:10:54','2025-12-02 10:10:54',1,246,'b64c2bbc-7437-4ffd-b90a-c64543f906f4',66,'f7326c3837b4427191aafcff504110ac','gigabytes',-1,'2025-12-03 10:10:54',NULL),('2025-12-02 10:10:54','2025-12-02 10:10:54','2025-12-02 10:10:54',1,247,'601eded3-b6f4-4708-839c-585b48a69d9b',67,'f7326c3837b4427191aafcff504110ac','volumes_tripleo',-1,'2025-12-03 10:10:54',NULL),('2025-12-02 10:10:54','2025-12-02 10:10:54','2025-12-02 10:10:54',1,248,'97ebd0f7-4ae6-4164-b344-5a8ba14ce747',68,'f7326c3837b4427191aafcff504110ac','gigabytes_tripleo',-1,'2025-12-03 10:10:54',NULL),('2025-12-02 10:10:55','2025-12-02 10:10:55','2025-12-02 10:10:55',1,249,'c6a444fa-9273-4c1a-b9f9-10ace6e81b6e',65,'f7326c3837b4427191aafcff504110ac','volumes',1,'2025-12-03 10:10:55',NULL),('2025-12-02 10:10:55','2025-12-02 10:10:55','2025-12-02 10:10:55',1,250,'f171c34f-6c8f-4cc0-90ec-f856bc43ed3c',66,'f7326c3837b4427191aafcff504110ac','gigabytes',1,'2025-12-03 10:10:55',NULL),('2025-12-02 10:10:55','2025-12-02 10:10:55','2025-12-02 10:10:55',1,251,'47349ea2-3d1b-4127-90d2-ac014b0e8458',67,'f7326c3837b4427191aafcff504110ac','volumes_tripleo',1,'2025-12-03 10:10:55',NULL),('2025-12-02 10:10:55','2025-12-02 10:10:55','2025-12-02 10:10:55',1,252,'bfef6534-2c63-4bfa-af30-a526583703e6',68,'f7326c3837b4427191aafcff504110ac','gigabytes_tripleo',1,'2025-12-03 10:10:55',NULL),('2025-12-02 10:10:57','2025-12-02 10:10:57','2025-12-02 10:10:57',1,253,'904f6635-807b-43d0-ab3e-49240f9d1d98',65,'f7326c3837b4427191aafcff504110ac','volumes',-1,'2025-12-03 10:10:57',NULL),('2025-12-02 10:10:57','2025-12-02 10:10:57','2025-12-02 10:10:57',1,254,'bb099625-6e29-467c-ab0b-8bef42990792',66,'f7326c3837b4427191aafcff504110ac','gigabytes',-1,'2025-12-03 10:10:57',NULL),('2025-12-02 10:10:57','2025-12-02 10:10:57','2025-12-02 10:10:57',1,255,'9c045759-81b5-4437-a895-b08f03e3e69c',67,'f7326c3837b4427191aafcff504110ac','volumes_tripleo',-1,'2025-12-03 10:10:57',NULL),('2025-12-02 10:10:57','2025-12-02 10:10:57','2025-12-02 10:10:57',1,256,'e689db56-82eb-409a-9e12-671e6d3e280a',68,'f7326c3837b4427191aafcff504110ac','gigabytes_tripleo',-1,'2025-12-03 10:10:57',NULL),('2025-12-02 10:10:58','2025-12-02 10:10:58','2025-12-02 10:10:58',1,257,'8e0f1964-4156-4dae-b728-ea653ce07b8d',65,'f7326c3837b4427191aafcff504110ac','volumes',1,'2025-12-03 10:10:58',NULL),('2025-12-02 10:10:58','2025-12-02 10:10:58','2025-12-02 10:10:58',1,258,'77e65d4f-b744-4aa4-9a89-63518b15c6ef',66,'f7326c3837b4427191aafcff504110ac','gigabytes',1,'2025-12-03 10:10:58',NULL),('2025-12-02 10:10:58','2025-12-02 10:10:58','2025-12-02 10:10:58',1,259,'a13b60c7-82a7-43ce-ac2e-720af1ccf081',67,'f7326c3837b4427191aafcff504110ac','volumes_tripleo',1,'2025-12-03 10:10:58',NULL),('2025-12-02 10:10:58','2025-12-02 10:10:58','2025-12-02 10:10:58',1,260,'21aba6d6-f6d2-434b-867f-8ae5644fe165',68,'f7326c3837b4427191aafcff504110ac','gigabytes_tripleo',1,'2025-12-03 10:10:58',NULL),('2025-12-02 10:10:59','2025-12-02 10:10:59','2025-12-02 10:10:59',1,261,'95ed0c2e-5cac-4b11-a686-9aa5d721017d',65,'f7326c3837b4427191aafcff504110ac','volumes',-1,'2025-12-03 10:10:59',NULL),('2025-12-02 10:10:59','2025-12-02 10:10:59','2025-12-02 10:10:59',1,262,'8266b5cf-46c0-4930-828e-67364a7c6802',66,'f7326c3837b4427191aafcff504110ac','gigabytes',-1,'2025-12-03 10:10:59',NULL),('2025-12-02 10:10:59','2025-12-02 10:10:59','2025-12-02 10:10:59',1,263,'b384f81f-1bfb-4400-a9d7-2ca3d6c777f9',67,'f7326c3837b4427191aafcff504110ac','volumes_tripleo',-1,'2025-12-03 10:10:59',NULL),('2025-12-02 10:10:59','2025-12-02 10:10:59','2025-12-02 10:10:59',1,264,'1814039f-4554-49ec-b5c0-1ea9e8245ec2',68,'f7326c3837b4427191aafcff504110ac','gigabytes_tripleo',-1,'2025-12-03 10:10:59',NULL),('2025-12-02 10:11:00','2025-12-02 10:11:00','2025-12-02 10:11:00',1,265,'aa2c68ac-aeb5-4277-bd0d-c5463bcc3445',65,'f7326c3837b4427191aafcff504110ac','volumes',1,'2025-12-03 10:11:00',NULL),('2025-12-02 10:11:00','2025-12-02 10:11:00','2025-12-02 10:11:00',1,266,'011544e7-3e7f-4a63-adf3-3f881cede24d',66,'f7326c3837b4427191aafcff504110ac','gigabytes',1,'2025-12-03 10:11:00',NULL),('2025-12-02 10:11:00','2025-12-02 10:11:00','2025-12-02 10:11:00',1,267,'d5f62c97-8c48-46e2-86eb-1ff4c84630bb',67,'f7326c3837b4427191aafcff504110ac','volumes_tripleo',1,'2025-12-03 10:11:00',NULL),('2025-12-02 10:11:00','2025-12-02 10:11:00','2025-12-02 10:11:00',1,268,'cd1f0b19-8f2f-48e7-9ce4-19705092b252',68,'f7326c3837b4427191aafcff504110ac','gigabytes_tripleo',1,'2025-12-03 10:11:00',NULL),('2025-12-02 10:11:02','2025-12-02 10:11:02','2025-12-02 10:11:02',1,269,'f4706d90-0751-4a07-a59c-ec29004d5f94',65,'f7326c3837b4427191aafcff504110ac','volumes',-1,'2025-12-03 10:11:02',NULL),('2025-12-02 10:11:02','2025-12-02 10:11:02','2025-12-02 10:11:02',1,270,'46f910ef-a55f-4623-81ce-1e5b9e955c19',66,'f7326c3837b4427191aafcff504110ac','gigabytes',-1,'2025-12-03 10:11:02',NULL),('2025-12-02 10:11:02','2025-12-02 10:11:02','2025-12-02 10:11:02',1,271,'97ee0857-e5ec-44af-9c0a-aa6ccff99901',67,'f7326c3837b4427191aafcff504110ac','volumes_tripleo',-1,'2025-12-03 10:11:02',NULL),('2025-12-02 10:11:02','2025-12-02 10:11:02','2025-12-02 10:11:02',1,272,'07644af2-9225-4118-9b75-ca036bb82617',68,'f7326c3837b4427191aafcff504110ac','gigabytes_tripleo',-1,'2025-12-03 10:11:02',NULL),('2025-12-02 10:11:03','2025-12-02 10:11:03','2025-12-02 10:11:03',1,273,'fce471b4-1cba-4f66-8929-25cf49319487',65,'f7326c3837b4427191aafcff504110ac','volumes',1,'2025-12-03 10:11:03',NULL),('2025-12-02 10:11:03','2025-12-02 10:11:03','2025-12-02 10:11:03',1,274,'cc489c97-5471-4cbb-a287-1ecbf3db8a86',66,'f7326c3837b4427191aafcff504110ac','gigabytes',1,'2025-12-03 10:11:03',NULL),('2025-12-02 10:11:03','2025-12-02 10:11:03','2025-12-02 10:11:03',1,275,'77bdbca3-d11f-4a84-8089-13a80baa8bc0',67,'f7326c3837b4427191aafcff504110ac','volumes_tripleo',1,'2025-12-03 10:11:03',NULL),('2025-12-02 10:11:03','2025-12-02 10:11:03','2025-12-02 10:11:03',1,276,'a915055b-25e0-4285-80b8-35e43c78274f',68,'f7326c3837b4427191aafcff504110ac','gigabytes_tripleo',1,'2025-12-03 10:11:03',NULL),('2025-12-02 10:11:04','2025-12-02 10:11:04','2025-12-02 10:11:04',1,277,'c48748a0-936b-47e9-83a9-b7564049043b',69,'3cb8897eac514c8791f32dc7c7f97664','volumes',1,'2025-12-03 10:11:04',NULL),('2025-12-02 10:11:04','2025-12-02 10:11:04','2025-12-02 10:11:04',1,278,'01f7f746-a6e1-450e-adc9-0d9110bf87b2',70,'3cb8897eac514c8791f32dc7c7f97664','gigabytes',1,'2025-12-03 10:11:04',NULL),('2025-12-02 10:11:04','2025-12-02 10:11:04','2025-12-02 10:11:04',1,279,'5f111e79-c063-466e-bdc2-b22df4ceba0f',71,'3cb8897eac514c8791f32dc7c7f97664','volumes_tripleo',1,'2025-12-03 10:11:04',NULL),('2025-12-02 10:11:04','2025-12-02 10:11:04','2025-12-02 10:11:04',1,280,'f0c528a4-713d-4bd6-81a6-5d75a068eb6f',72,'3cb8897eac514c8791f32dc7c7f97664','gigabytes_tripleo',1,'2025-12-03 10:11:04',NULL),('2025-12-02 10:11:05','2025-12-02 10:11:05','2025-12-02 10:11:05',1,281,'0e1aadcb-f4b7-4fef-81af-0ed17a98c232',73,'3cb8897eac514c8791f32dc7c7f97664','backups',1,'2025-12-03 10:11:05',NULL),('2025-12-02 10:11:05','2025-12-02 10:11:05','2025-12-02 10:11:05',1,282,'c762a331-9a16-4ea8-9f89-3b454f291ae6',74,'3cb8897eac514c8791f32dc7c7f97664','backup_gigabytes',1,'2025-12-03 10:11:05',NULL),('2025-12-02 10:11:06','2025-12-02 10:11:06','2025-12-02 10:11:06',1,283,'b15c5e9d-7f10-491b-9ecc-0dc5011d05d3',65,'f7326c3837b4427191aafcff504110ac','volumes',-1,'2025-12-03 10:11:06',NULL),('2025-12-02 10:11:06','2025-12-02 10:11:06','2025-12-02 10:11:06',1,284,'24e37d8c-b474-4f77-8302-bf5f7e8de00e',66,'f7326c3837b4427191aafcff504110ac','gigabytes',-1,'2025-12-03 10:11:06',NULL),('2025-12-02 10:11:06','2025-12-02 10:11:06','2025-12-02 10:11:06',1,285,'77a4afb0-bea3-448d-8990-5685615a41a1',67,'f7326c3837b4427191aafcff504110ac','volumes_tripleo',-1,'2025-12-03 10:11:06',NULL),('2025-12-02 10:11:06','2025-12-02 10:11:06','2025-12-02 10:11:06',1,286,'b9d68cbb-9f9a-4510-8749-fb4fd0c9de36',68,'f7326c3837b4427191aafcff504110ac','gigabytes_tripleo',-1,'2025-12-03 10:11:06',NULL),('2025-12-02 10:11:08','2025-12-02 10:11:08','2025-12-02 10:11:08',1,287,'08c167a5-20d5-4006-9edb-3c6b893b92be',75,'fef053541b4b4785ab9899f41b37c328','volumes',1,'2025-12-03 10:11:08',NULL),('2025-12-02 10:11:08','2025-12-02 10:11:08','2025-12-02 10:11:08',1,288,'f2329640-671e-4054-83c2-275d515891a0',76,'fef053541b4b4785ab9899f41b37c328','gigabytes',1,'2025-12-03 10:11:08',NULL),('2025-12-02 10:11:08','2025-12-02 10:11:08','2025-12-02 10:11:08',1,289,'e8fd0afa-d289-4e3a-978a-69b41eb70070',77,'fef053541b4b4785ab9899f41b37c328','volumes_tripleo',1,'2025-12-03 10:11:08',NULL),('2025-12-02 10:11:08','2025-12-02 10:11:08','2025-12-02 10:11:08',1,290,'5fbf637a-5fa6-406f-9819-6ad43b59330e',78,'fef053541b4b4785ab9899f41b37c328','gigabytes_tripleo',1,'2025-12-03 10:11:08',NULL),('2025-12-02 10:11:10','2025-12-02 10:11:11','2025-12-02 10:11:11',1,291,'35dc62e3-dcb0-4805-b385-50c74c12d014',75,'fef053541b4b4785ab9899f41b37c328','volumes',-1,'2025-12-03 10:11:10',NULL),('2025-12-02 10:11:10','2025-12-02 10:11:11','2025-12-02 10:11:11',1,292,'2c5512e1-4821-4ae8-a74c-1dfb37b941d0',76,'fef053541b4b4785ab9899f41b37c328','gigabytes',-1,'2025-12-03 10:11:10',NULL),('2025-12-02 10:11:10','2025-12-02 10:11:11','2025-12-02 10:11:11',1,293,'a6aadc9c-9b70-4aee-a302-e376f35e1705',77,'fef053541b4b4785ab9899f41b37c328','volumes_tripleo',-1,'2025-12-03 10:11:10',NULL),('2025-12-02 10:11:10','2025-12-02 10:11:11','2025-12-02 10:11:11',1,294,'ac55f853-62de-49a7-a1c6-66dec73d6edd',78,'fef053541b4b4785ab9899f41b37c328','gigabytes_tripleo',-1,'2025-12-03 10:11:10',NULL),('2025-12-02 10:11:11','2025-12-02 10:11:11','2025-12-02 10:11:11',1,295,'eb9b3f80-79cd-4679-b406-c38ed3e05bca',75,'fef053541b4b4785ab9899f41b37c328','volumes',1,'2025-12-03 10:11:11',NULL),('2025-12-02 10:11:11','2025-12-02 10:11:11','2025-12-02 10:11:11',1,296,'c6d4a1ce-db43-44be-a232-dec91329de3a',76,'fef053541b4b4785ab9899f41b37c328','gigabytes',1,'2025-12-03 10:11:11',NULL),('2025-12-02 10:11:11','2025-12-02 10:11:11','2025-12-02 10:11:11',1,297,'6e5d9664-8f23-4ce9-a4bc-982c0fa79c04',77,'fef053541b4b4785ab9899f41b37c328','volumes_tripleo',1,'2025-12-03 10:11:11',NULL),('2025-12-02 10:11:11','2025-12-02 10:11:11','2025-12-02 10:11:11',1,298,'3e0d0973-e04e-469b-872a-779bec7c84f9',78,'fef053541b4b4785ab9899f41b37c328','gigabytes_tripleo',1,'2025-12-03 10:11:11',NULL),('2025-12-02 10:11:13','2025-12-02 10:11:14','2025-12-02 10:11:14',1,299,'2b1bc253-0e9c-4b9d-b015-7fd56963c06b',79,'efbd1cf12d1441269b72130fc6cf60d9','volumes',1,'2025-12-03 10:11:13',NULL),('2025-12-02 10:11:13','2025-12-02 10:11:14','2025-12-02 10:11:14',1,300,'d0a7b5f1-07c7-4ee8-8d9e-f55b4cb8421b',80,'efbd1cf12d1441269b72130fc6cf60d9','gigabytes',1,'2025-12-03 10:11:13',NULL),('2025-12-02 10:11:13','2025-12-02 10:11:14','2025-12-02 10:11:14',1,301,'5e628f53-cfa9-4ab8-8921-88bb6e9772fa',81,'efbd1cf12d1441269b72130fc6cf60d9','volumes_tripleo',1,'2025-12-03 10:11:13',NULL),('2025-12-02 10:11:13','2025-12-02 10:11:14','2025-12-02 10:11:14',1,302,'6e904458-f9e9-4963-a060-051f28e64243',82,'efbd1cf12d1441269b72130fc6cf60d9','gigabytes_tripleo',1,'2025-12-03 10:11:13',NULL),('2025-12-02 10:11:14','2025-12-02 10:11:14','2025-12-02 10:11:14',1,303,'81ce8916-402b-46ee-a546-ac8fa3158ab9',75,'fef053541b4b4785ab9899f41b37c328','volumes',-1,'2025-12-03 10:11:13',NULL),('2025-12-02 10:11:14','2025-12-02 10:11:14','2025-12-02 10:11:14',1,304,'8045c368-844e-4503-8dad-56b5ae45d177',76,'fef053541b4b4785ab9899f41b37c328','gigabytes',-1,'2025-12-03 10:11:13',NULL),('2025-12-02 10:11:14','2025-12-02 10:11:14','2025-12-02 10:11:14',1,305,'b14dc02e-21ae-42b8-abf2-73c0c3431184',77,'fef053541b4b4785ab9899f41b37c328','volumes_tripleo',-1,'2025-12-03 10:11:13',NULL),('2025-12-02 10:11:14','2025-12-02 10:11:14','2025-12-02 10:11:14',1,306,'6863a632-48ad-434b-9695-fbc9e84beec4',78,'fef053541b4b4785ab9899f41b37c328','gigabytes_tripleo',-1,'2025-12-03 10:11:13',NULL),('2025-12-02 10:11:14','2025-12-02 10:11:14','2025-12-02 10:11:14',1,307,'e2c7b03e-1411-45b4-9948-17298413530a',83,'efbd1cf12d1441269b72130fc6cf60d9','snapshots',0,'2025-12-03 10:11:14',NULL),('2025-12-02 10:11:14','2025-12-02 10:11:14','2025-12-02 10:11:14',1,308,'9b3c06a7-117c-45fc-a2fc-8888b266b32c',80,'efbd1cf12d1441269b72130fc6cf60d9','gigabytes',0,'2025-12-03 10:11:14',NULL),('2025-12-02 10:11:14','2025-12-02 10:11:14','2025-12-02 10:11:14',1,309,'8e5cf8ae-0935-4183-9566-c65078fa1f4b',82,'efbd1cf12d1441269b72130fc6cf60d9','gigabytes_tripleo',0,'2025-12-03 10:11:14',NULL),('2025-12-02 10:11:14','2025-12-02 10:11:14','2025-12-02 10:11:14',1,310,'fb5e02c5-5ed2-4f3e-997f-1845c858a5b3',84,'efbd1cf12d1441269b72130fc6cf60d9','snapshots_tripleo',0,'2025-12-03 10:11:14',NULL),('2025-12-02 10:11:14','2025-12-02 10:11:14','2025-12-02 10:11:14',1,311,'1a7b855e-4bdf-4376-97ea-bc38dcd0b996',85,'fef053541b4b4785ab9899f41b37c328','snapshots',0,'2025-12-03 10:11:14',NULL),('2025-12-02 10:11:14','2025-12-02 10:11:14','2025-12-02 10:11:14',1,312,'3083156f-de73-4a92-bec2-f6be7dcdbeee',76,'fef053541b4b4785ab9899f41b37c328','gigabytes',0,'2025-12-03 10:11:14',NULL),('2025-12-02 10:11:14','2025-12-02 10:11:14','2025-12-02 10:11:14',1,313,'0eb0a80a-2c50-4a05-9850-78c5094c0f86',78,'fef053541b4b4785ab9899f41b37c328','gigabytes_tripleo',0,'2025-12-03 10:11:14',NULL),('2025-12-02 10:11:14','2025-12-02 10:11:14','2025-12-02 10:11:14',1,314,'d9e4af90-cb16-467c-91f8-7420e06e842a',86,'fef053541b4b4785ab9899f41b37c328','snapshots_tripleo',0,'2025-12-03 10:11:14',NULL),('2025-12-02 10:11:15','2025-12-02 10:11:15','2025-12-02 10:11:15',1,315,'277ab138-6594-43ea-adf6-93abfc8d9c18',79,'efbd1cf12d1441269b72130fc6cf60d9','volumes',-1,'2025-12-03 10:11:15',NULL),('2025-12-02 10:11:15','2025-12-02 10:11:15','2025-12-02 10:11:15',1,316,'c6149112-bbb6-4ad3-a293-5f24404b69af',80,'efbd1cf12d1441269b72130fc6cf60d9','gigabytes',-1,'2025-12-03 10:11:15',NULL),('2025-12-02 10:11:15','2025-12-02 10:11:15','2025-12-02 10:11:15',1,317,'9f0811cb-7031-4f60-a88f-916fd7f2b9cf',81,'efbd1cf12d1441269b72130fc6cf60d9','volumes_tripleo',-1,'2025-12-03 10:11:15',NULL),('2025-12-02 10:11:15','2025-12-02 10:11:15','2025-12-02 10:11:15',1,318,'d6b21937-910c-41b3-8805-16ad8967c8c6',82,'efbd1cf12d1441269b72130fc6cf60d9','gigabytes_tripleo',-1,'2025-12-03 10:11:15',NULL),('2025-12-02 10:11:15','2025-12-02 10:11:16','2025-12-02 10:11:16',1,319,'fe822606-2e77-453e-9d7f-2638911a808b',73,'3cb8897eac514c8791f32dc7c7f97664','backups',-1,'2025-12-03 10:11:15',NULL),('2025-12-02 10:11:15','2025-12-02 10:11:16','2025-12-02 10:11:16',1,320,'4ce1a1ae-7eed-417c-99dd-132f87e53e10',74,'3cb8897eac514c8791f32dc7c7f97664','backup_gigabytes',-1,'2025-12-03 10:11:15',NULL),('2025-12-02 10:11:18','2025-12-02 10:11:18','2025-12-02 10:11:18',1,321,'8e4f7dee-79f8-4221-88e6-8c8bcfc71484',69,'3cb8897eac514c8791f32dc7c7f97664','volumes',-1,'2025-12-03 10:11:18',NULL),('2025-12-02 10:11:18','2025-12-02 10:11:18','2025-12-02 10:11:18',1,322,'54d6ae21-a424-4542-a6df-1a466ccd141a',70,'3cb8897eac514c8791f32dc7c7f97664','gigabytes',-1,'2025-12-03 10:11:18',NULL),('2025-12-02 10:11:18','2025-12-02 10:11:18','2025-12-02 10:11:18',1,323,'8bdcd267-9a3e-47f5-b895-1af5b87a2ec2',71,'3cb8897eac514c8791f32dc7c7f97664','volumes_tripleo',-1,'2025-12-03 10:11:18',NULL),('2025-12-02 10:11:18','2025-12-02 10:11:18','2025-12-02 10:11:18',1,324,'6b2d2ee6-3647-42a2-b985-055aa19b68d9',72,'3cb8897eac514c8791f32dc7c7f97664','gigabytes_tripleo',-1,'2025-12-03 10:11:18',NULL),('2025-12-02 10:11:31','2025-12-02 10:11:32','2025-12-02 10:11:32',1,325,'8b125fc3-433c-48a0-9c79-d0181c3182ab',87,'8e9db6bb24074518b94709252c97dff0','volumes',1,'2025-12-03 10:11:31',NULL),('2025-12-02 10:11:31','2025-12-02 10:11:32','2025-12-02 10:11:32',1,326,'885d8637-f8cf-408c-a3c1-d1dcb45a4b2d',88,'8e9db6bb24074518b94709252c97dff0','gigabytes',1,'2025-12-03 10:11:31',NULL),('2025-12-02 10:11:31','2025-12-02 10:11:32','2025-12-02 10:11:32',1,327,'8d5c9b5c-f2e3-4958-b7ff-f42e1c1b5e76',89,'8e9db6bb24074518b94709252c97dff0','volumes_tripleo',1,'2025-12-03 10:11:31',NULL),('2025-12-02 10:11:31','2025-12-02 10:11:32','2025-12-02 10:11:32',1,328,'28d7bff2-d607-4ef5-bf1e-b3da60cc32a0',90,'8e9db6bb24074518b94709252c97dff0','gigabytes_tripleo',1,'2025-12-03 10:11:31',NULL),('2025-12-02 10:11:39','2025-12-02 10:11:40','2025-12-02 10:11:40',1,329,'d6dcc6d0-a808-4ebe-87b1-0e231a52750e',91,'10644498f24744ec828624bc952bff43','volumes',1,'2025-12-03 10:11:38',NULL),('2025-12-02 10:11:39','2025-12-02 10:11:40','2025-12-02 10:11:40',1,330,'a1396f66-13e8-4bd7-8b86-efdff8ad3995',92,'10644498f24744ec828624bc952bff43','gigabytes',1,'2025-12-03 10:11:38',NULL),('2025-12-02 10:11:39','2025-12-02 10:11:40','2025-12-02 10:11:40',1,331,'cb40ae7f-e001-4ce0-91d1-2989ec1b0311',93,'10644498f24744ec828624bc952bff43','volumes_tripleo',1,'2025-12-03 10:11:38',NULL),('2025-12-02 10:11:39','2025-12-02 10:11:40','2025-12-02 10:11:40',1,332,'3502326c-868d-429d-aa72-2b778b2fd9da',94,'10644498f24744ec828624bc952bff43','gigabytes_tripleo',1,'2025-12-03 10:11:38',NULL),('2025-12-02 10:11:39','2025-12-02 10:11:40','2025-12-02 10:11:40',1,333,'38f782ec-a27d-485d-aaf3-42b1336b1a60',87,'8e9db6bb24074518b94709252c97dff0','volumes',1,'2025-12-03 10:11:39',NULL),('2025-12-02 10:11:40','2025-12-02 10:11:40','2025-12-02 10:11:40',1,334,'a58c2a06-e942-4c7c-bd41-1634c8505d47',88,'8e9db6bb24074518b94709252c97dff0','gigabytes',1,'2025-12-03 10:11:39',NULL),('2025-12-02 10:11:40','2025-12-02 10:11:40','2025-12-02 10:11:40',1,335,'568f9594-ebf7-480d-80a2-7a2f7cdcbcd8',89,'8e9db6bb24074518b94709252c97dff0','volumes_tripleo',1,'2025-12-03 10:11:39',NULL),('2025-12-02 10:11:40','2025-12-02 10:11:40','2025-12-02 10:11:40',1,336,'b979705d-a5f0-403d-b6f4-9f655135599d',90,'8e9db6bb24074518b94709252c97dff0','gigabytes_tripleo',1,'2025-12-03 10:11:39',NULL),('2025-12-02 10:11:42','2025-12-02 10:11:42','2025-12-02 10:11:42',1,337,'749954cf-9a6b-4e28-a3cc-8fa921f569a0',95,'10644498f24744ec828624bc952bff43','backups',1,'2025-12-03 10:11:42',NULL),('2025-12-02 10:11:42','2025-12-02 10:11:42','2025-12-02 10:11:42',1,338,'1108fa9a-0b18-4e5c-8ce1-20af3ff815c1',96,'10644498f24744ec828624bc952bff43','backup_gigabytes',1,'2025-12-03 10:11:42',NULL),('2025-12-02 10:11:43','2025-12-02 10:11:44','2025-12-02 10:11:44',1,339,'cf5e41bd-3e98-4b2d-a5b6-6efb4e5fb399',87,'8e9db6bb24074518b94709252c97dff0','volumes',-1,'2025-12-03 10:11:43',NULL),('2025-12-02 10:11:43','2025-12-02 10:11:44','2025-12-02 10:11:44',1,340,'03d7ef4b-8dc1-44b5-b131-8d9c3ac3cfad',88,'8e9db6bb24074518b94709252c97dff0','gigabytes',-1,'2025-12-03 10:11:43',NULL),('2025-12-02 10:11:43','2025-12-02 10:11:44','2025-12-02 10:11:44',1,341,'e1df0970-b2cd-443e-9fdd-955bc87e0d1d',89,'8e9db6bb24074518b94709252c97dff0','volumes_tripleo',-1,'2025-12-03 10:11:43',NULL),('2025-12-02 10:11:43','2025-12-02 10:11:44','2025-12-02 10:11:44',1,342,'8eb049e2-e713-4fc9-b186-39cec639f668',90,'8e9db6bb24074518b94709252c97dff0','gigabytes_tripleo',-1,'2025-12-03 10:11:43',NULL),('2025-12-02 10:11:45','2025-12-02 10:11:45','2025-12-02 10:11:45',1,343,'f15accaf-3378-4fbf-a8e3-618cd1b67ae6',87,'8e9db6bb24074518b94709252c97dff0','volumes',-1,'2025-12-03 10:11:45',NULL),('2025-12-02 10:11:45','2025-12-02 10:11:45','2025-12-02 10:11:45',1,344,'76b1e1e1-2d4c-4618-bc56-ae23aaaa82a6',88,'8e9db6bb24074518b94709252c97dff0','gigabytes',-1,'2025-12-03 10:11:45',NULL),('2025-12-02 10:11:45','2025-12-02 10:11:45','2025-12-02 10:11:45',1,345,'e65f13fc-0096-4762-aa5b-63604124fbd9',89,'8e9db6bb24074518b94709252c97dff0','volumes_tripleo',-1,'2025-12-03 10:11:45',NULL),('2025-12-02 10:11:45','2025-12-02 10:11:45','2025-12-02 10:11:45',1,346,'66e3eb64-1547-4684-9c95-5dcd58ac9ff2',90,'8e9db6bb24074518b94709252c97dff0','gigabytes_tripleo',-1,'2025-12-03 10:11:45',NULL),('2025-12-02 10:11:46','2025-12-02 10:11:46','2025-12-02 10:11:46',1,347,'738fddcd-8ff2-4283-82ca-b87052e40ccf',87,'8e9db6bb24074518b94709252c97dff0','volumes',1,'2025-12-03 10:11:46',NULL),('2025-12-02 10:11:46','2025-12-02 10:11:46','2025-12-02 10:11:46',1,348,'8f0bf424-e947-470c-8b61-53789f3190b7',88,'8e9db6bb24074518b94709252c97dff0','gigabytes',1,'2025-12-03 10:11:46',NULL),('2025-12-02 10:11:46','2025-12-02 10:11:46','2025-12-02 10:11:46',1,349,'24733378-a508-4280-b9c1-2a7e89fad582',89,'8e9db6bb24074518b94709252c97dff0','volumes_tripleo',1,'2025-12-03 10:11:46',NULL),('2025-12-02 10:11:46','2025-12-02 10:11:46','2025-12-02 10:11:46',1,350,'eeeaa5e1-d650-4085-8d18-d7338ece49c6',90,'8e9db6bb24074518b94709252c97dff0','gigabytes_tripleo',1,'2025-12-03 10:11:46',NULL),('2025-12-02 10:11:48','2025-12-02 10:11:48','2025-12-02 10:11:48',1,351,'e9cba68a-33f2-4913-97f3-3dce861d08f0',87,'8e9db6bb24074518b94709252c97dff0','volumes',1,'2025-12-03 10:11:48',NULL),('2025-12-02 10:11:48','2025-12-02 10:11:48','2025-12-02 10:11:48',1,352,'24a28f12-a55f-4922-a53e-e076120becb0',88,'8e9db6bb24074518b94709252c97dff0','gigabytes',2,'2025-12-03 10:11:48',NULL),('2025-12-02 10:11:48','2025-12-02 10:11:48','2025-12-02 10:11:48',1,353,'f574e327-1846-47a2-9dd5-8ad852cdebab',89,'8e9db6bb24074518b94709252c97dff0','volumes_tripleo',1,'2025-12-03 10:11:48',NULL),('2025-12-02 10:11:48','2025-12-02 10:11:48','2025-12-02 10:11:48',1,354,'4cd30ef2-b93b-461d-9916-03cb0e441b70',90,'8e9db6bb24074518b94709252c97dff0','gigabytes_tripleo',2,'2025-12-03 10:11:48',NULL),('2025-12-02 10:11:48','2025-12-02 10:11:48','2025-12-02 10:11:48',1,355,'e8f26f94-4704-4f81-9583-f369303b6030',97,'1e90b030c2b247a7a33033ba004a83a5','backups',1,'2025-12-03 10:11:48',NULL),('2025-12-02 10:11:48','2025-12-02 10:11:48','2025-12-02 10:11:48',1,356,'2d1fa95a-ecc8-4934-b374-556819e793dc',98,'1e90b030c2b247a7a33033ba004a83a5','backup_gigabytes',1,'2025-12-03 10:11:48',NULL),('2025-12-02 10:11:50','2025-12-02 10:11:50','2025-12-02 10:11:50',1,357,'0d83b28c-ef49-4676-af31-25a9d600b659',91,'10644498f24744ec828624bc952bff43','volumes',1,'2025-12-03 10:11:50',NULL),('2025-12-02 10:11:50','2025-12-02 10:11:50','2025-12-02 10:11:50',1,358,'9c774f4f-562f-4b74-a92b-c2c97102841d',92,'10644498f24744ec828624bc952bff43','gigabytes',1,'2025-12-03 10:11:50',NULL),('2025-12-02 10:11:50','2025-12-02 10:11:50','2025-12-02 10:11:50',1,359,'52759eee-4537-4376-9067-f3c71af9f69f',93,'10644498f24744ec828624bc952bff43','volumes_tripleo',1,'2025-12-03 10:11:50',NULL),('2025-12-02 10:11:50','2025-12-02 10:11:50','2025-12-02 10:11:50',1,360,'d2577dd7-76dc-44dc-9d0c-0187d296e0c2',94,'10644498f24744ec828624bc952bff43','gigabytes_tripleo',1,'2025-12-03 10:11:50',NULL),('2025-12-02 10:11:51','2025-12-02 10:11:52','2025-12-02 10:11:52',1,361,'c894fdd9-8716-4fca-af30-883f6bcd6ca2',87,'8e9db6bb24074518b94709252c97dff0','volumes',-1,'2025-12-03 10:11:51',NULL),('2025-12-02 10:11:51','2025-12-02 10:11:52','2025-12-02 10:11:52',1,362,'8bd9fb9c-4733-406d-8b18-3c4d764881f7',88,'8e9db6bb24074518b94709252c97dff0','gigabytes',-2,'2025-12-03 10:11:51',NULL),('2025-12-02 10:11:51','2025-12-02 10:11:52','2025-12-02 10:11:52',1,363,'3e3333a2-cfcd-48c7-b6cc-2dbabf0a5262',89,'8e9db6bb24074518b94709252c97dff0','volumes_tripleo',-1,'2025-12-03 10:11:51',NULL),('2025-12-02 10:11:51','2025-12-02 10:11:52','2025-12-02 10:11:52',1,364,'873b684c-2cdb-4eeb-a07d-7f853e01ad5d',90,'8e9db6bb24074518b94709252c97dff0','gigabytes_tripleo',-2,'2025-12-03 10:11:51',NULL),('2025-12-02 10:11:53','2025-12-02 10:11:53','2025-12-02 10:11:53',1,365,'07497c24-aade-479a-b95d-a435f04a8fab',87,'8e9db6bb24074518b94709252c97dff0','volumes',-1,'2025-12-03 10:11:53',NULL),('2025-12-02 10:11:53','2025-12-02 10:11:53','2025-12-02 10:11:53',1,366,'7c8b0e98-a067-41a3-acf6-d7690734bc31',88,'8e9db6bb24074518b94709252c97dff0','gigabytes',-1,'2025-12-03 10:11:53',NULL),('2025-12-02 10:11:53','2025-12-02 10:11:53','2025-12-02 10:11:53',1,367,'a97437a3-49fd-47f0-9185-fba5b33a8a46',89,'8e9db6bb24074518b94709252c97dff0','volumes_tripleo',-1,'2025-12-03 10:11:53',NULL),('2025-12-02 10:11:53','2025-12-02 10:11:53','2025-12-02 10:11:53',1,368,'c6add854-7298-4e22-b728-21457af26f3b',90,'8e9db6bb24074518b94709252c97dff0','gigabytes_tripleo',-1,'2025-12-03 10:11:53',NULL),('2025-12-02 10:11:54','2025-12-02 10:11:54','2025-12-02 10:11:54',1,369,'6152296b-ca12-4f05-8b52-7895c93bad21',99,'ab84e521dda9432ca7d62c5185f1eaab','volumes',1,'2025-12-03 10:11:54',NULL),('2025-12-02 10:11:54','2025-12-02 10:11:54','2025-12-02 10:11:54',1,370,'d4fb58ec-e215-4407-b02c-8c7c9d415a21',100,'ab84e521dda9432ca7d62c5185f1eaab','gigabytes',1,'2025-12-03 10:11:54',NULL),('2025-12-02 10:11:54','2025-12-02 10:11:54','2025-12-02 10:11:54',1,371,'74d68fac-bb7d-4ee2-aef4-5ad9fb26d7da',101,'ab84e521dda9432ca7d62c5185f1eaab','volumes_tripleo',1,'2025-12-03 10:11:54',NULL),('2025-12-02 10:11:54','2025-12-02 10:11:54','2025-12-02 10:11:54',1,372,'e939b3e6-eec3-4527-a32d-682ac1e4b85c',102,'ab84e521dda9432ca7d62c5185f1eaab','gigabytes_tripleo',1,'2025-12-03 10:11:54',NULL),('2025-12-02 10:11:57','2025-12-02 10:11:57','2025-12-02 10:11:57',1,373,'185ace88-9c7f-46b8-9f05-d06439f1ca63',103,'2267b5d8ec1242618341cd359607d279','volumes',1,'2025-12-03 10:11:57',NULL),('2025-12-02 10:11:57','2025-12-02 10:11:57','2025-12-02 10:11:57',1,374,'f936915b-04e8-4ef4-9d83-ce21e6d236db',104,'2267b5d8ec1242618341cd359607d279','gigabytes',1,'2025-12-03 10:11:57',NULL),('2025-12-02 10:11:57','2025-12-02 10:11:57','2025-12-02 10:11:57',1,375,'54af5259-29ca-4746-a659-d7d4ea435f3f',105,'2267b5d8ec1242618341cd359607d279','volumes_tripleo',1,'2025-12-03 10:11:57',NULL),('2025-12-02 10:11:57','2025-12-02 10:11:57','2025-12-02 10:11:57',1,376,'026ad578-af33-4572-819a-825914443be5',106,'2267b5d8ec1242618341cd359607d279','gigabytes_tripleo',1,'2025-12-03 10:11:57',NULL),('2025-12-02 10:11:57','2025-12-02 10:11:57','2025-12-02 10:11:57',1,377,'d345f0e0-1db1-4650-b8b5-2f4969a1bffb',99,'ab84e521dda9432ca7d62c5185f1eaab','volumes',-1,'2025-12-03 10:11:57',NULL),('2025-12-02 10:11:57','2025-12-02 10:11:57','2025-12-02 10:11:57',1,378,'1a7e98a4-2185-4d1a-a4b2-4712bc14369e',100,'ab84e521dda9432ca7d62c5185f1eaab','gigabytes',-1,'2025-12-03 10:11:57',NULL),('2025-12-02 10:11:57','2025-12-02 10:11:57','2025-12-02 10:11:57',1,379,'53446720-7ca6-4702-a5e9-90512eb1ad63',101,'ab84e521dda9432ca7d62c5185f1eaab','volumes_tripleo',-1,'2025-12-03 10:11:57',NULL),('2025-12-02 10:11:57','2025-12-02 10:11:57','2025-12-02 10:11:57',1,380,'a93bd04e-2de3-406b-89f5-45e1bbed8b9c',102,'ab84e521dda9432ca7d62c5185f1eaab','gigabytes_tripleo',-1,'2025-12-03 10:11:57',NULL),('2025-12-02 10:11:57','2025-12-02 10:11:57','2025-12-02 10:11:57',1,381,'f634d5f3-2fbc-4c4e-9d71-177aa8836c6e',107,'2267b5d8ec1242618341cd359607d279','snapshots',0,'2025-12-03 10:11:57',NULL),('2025-12-02 10:11:57','2025-12-02 10:11:57','2025-12-02 10:11:57',1,382,'a545e656-e183-49f2-ac09-c29ebbc6b2e9',104,'2267b5d8ec1242618341cd359607d279','gigabytes',0,'2025-12-03 10:11:57',NULL),('2025-12-02 10:11:57','2025-12-02 10:11:57','2025-12-02 10:11:57',1,383,'6ca07131-145a-4578-8dd0-c139885281a3',106,'2267b5d8ec1242618341cd359607d279','gigabytes_tripleo',0,'2025-12-03 10:11:57',NULL),('2025-12-02 10:11:57','2025-12-02 10:11:57','2025-12-02 10:11:57',1,384,'75bd8572-cf05-4552-990d-b6a824e6d13f',108,'2267b5d8ec1242618341cd359607d279','snapshots_tripleo',0,'2025-12-03 10:11:57',NULL),('2025-12-02 10:11:57','2025-12-02 10:11:57','2025-12-02 10:11:57',1,385,'27a63c6a-c289-4264-b09c-bbd59e5f7fd7',97,'1e90b030c2b247a7a33033ba004a83a5','backups',-1,'2025-12-03 10:11:57',NULL),('2025-12-02 10:11:57','2025-12-02 10:11:57','2025-12-02 10:11:57',1,386,'09ef0968-22fd-45ed-9047-bce7e76c9178',98,'1e90b030c2b247a7a33033ba004a83a5','backup_gigabytes',-1,'2025-12-03 10:11:57',NULL),('2025-12-02 10:11:57','2025-12-02 10:11:58','2025-12-02 10:11:58',1,387,'4692352e-9659-4bb1-befd-496964eb0f57',109,'ab84e521dda9432ca7d62c5185f1eaab','snapshots',0,'2025-12-03 10:11:57',NULL),('2025-12-02 10:11:57','2025-12-02 10:11:58','2025-12-02 10:11:58',1,388,'eef39d21-dec2-41d0-aff2-0d3883ec7a65',100,'ab84e521dda9432ca7d62c5185f1eaab','gigabytes',0,'2025-12-03 10:11:57',NULL),('2025-12-02 10:11:57','2025-12-02 10:11:58','2025-12-02 10:11:58',1,389,'10e07014-bfd0-4cd5-971a-6d5f0ac31338',102,'ab84e521dda9432ca7d62c5185f1eaab','gigabytes_tripleo',0,'2025-12-03 10:11:57',NULL),('2025-12-02 10:11:57','2025-12-02 10:11:58','2025-12-02 10:11:58',1,390,'3e459f97-9a50-4648-89ae-00185f6620be',110,'ab84e521dda9432ca7d62c5185f1eaab','snapshots_tripleo',0,'2025-12-03 10:11:57',NULL),('2025-12-02 10:11:58','2025-12-02 10:11:58','2025-12-02 10:11:58',1,391,'08d3514a-989d-4fd4-89e6-1f0d4b0b259e',103,'2267b5d8ec1242618341cd359607d279','volumes',-1,'2025-12-03 10:11:58',NULL),('2025-12-02 10:11:58','2025-12-02 10:11:58','2025-12-02 10:11:58',1,392,'2cf4c2bb-946a-4c77-9e7d-ab9b97878943',104,'2267b5d8ec1242618341cd359607d279','gigabytes',-1,'2025-12-03 10:11:58',NULL),('2025-12-02 10:11:58','2025-12-02 10:11:58','2025-12-02 10:11:58',1,393,'18fcd1a7-5683-4279-9fa5-ebc62bba37bf',105,'2267b5d8ec1242618341cd359607d279','volumes_tripleo',-1,'2025-12-03 10:11:58',NULL),('2025-12-02 10:11:58','2025-12-02 10:11:58','2025-12-02 10:11:58',1,394,'c5d38828-4bc8-49b6-974c-58e89746841d',106,'2267b5d8ec1242618341cd359607d279','gigabytes_tripleo',-1,'2025-12-03 10:11:58',NULL),('2025-12-02 10:11:59','2025-12-02 10:11:59','2025-12-02 10:11:59',1,395,'8ae04103-23b2-400d-97f4-28ad6a2d9dca',91,'10644498f24744ec828624bc952bff43','volumes',-1,'2025-12-03 10:11:59',NULL),('2025-12-02 10:11:59','2025-12-02 10:11:59','2025-12-02 10:11:59',1,396,'96ad7165-cb16-4f76-a3a6-71af70ef9d58',92,'10644498f24744ec828624bc952bff43','gigabytes',-1,'2025-12-03 10:11:59',NULL),('2025-12-02 10:11:59','2025-12-02 10:11:59','2025-12-02 10:11:59',1,397,'07b9b248-6f1a-4580-bcf5-afed8617c740',93,'10644498f24744ec828624bc952bff43','volumes_tripleo',-1,'2025-12-03 10:11:59',NULL),('2025-12-02 10:11:59','2025-12-02 10:11:59','2025-12-02 10:11:59',1,398,'c9ee7fa5-ada8-4e8e-a363-71799cfd81de',94,'10644498f24744ec828624bc952bff43','gigabytes_tripleo',-1,'2025-12-03 10:11:59',NULL),('2025-12-02 10:11:59','2025-12-02 10:11:59','2025-12-02 10:11:59',1,399,'fb8d6047-5983-4f6e-8376-a3f32452ce81',99,'ab84e521dda9432ca7d62c5185f1eaab','volumes',1,'2025-12-03 10:11:59',NULL),('2025-12-02 10:11:59','2025-12-02 10:11:59','2025-12-02 10:11:59',1,400,'3698e441-3365-4ee7-9f08-0f4ba5fdd175',100,'ab84e521dda9432ca7d62c5185f1eaab','gigabytes',1,'2025-12-03 10:11:59',NULL),('2025-12-02 10:11:59','2025-12-02 10:11:59','2025-12-02 10:11:59',1,401,'e814af8c-ae42-410e-aafe-2b6cb2da7891',101,'ab84e521dda9432ca7d62c5185f1eaab','volumes_tripleo',1,'2025-12-03 10:11:59',NULL),('2025-12-02 10:11:59','2025-12-02 10:11:59','2025-12-02 10:11:59',1,402,'55f07f6c-0831-4ab7-8984-0ed880c11ad6',102,'ab84e521dda9432ca7d62c5185f1eaab','gigabytes_tripleo',1,'2025-12-03 10:11:59',NULL),('2025-12-02 10:12:00','2025-12-02 10:12:00','2025-12-02 10:12:00',1,403,'9287cda1-4e25-4074-ab5f-af9aeb4df9a5',95,'10644498f24744ec828624bc952bff43','backups',-1,'2025-12-03 10:12:00',NULL),('2025-12-02 10:12:00','2025-12-02 10:12:00','2025-12-02 10:12:00',1,404,'9b02417e-5510-411f-bcfd-a24999bc1bde',96,'10644498f24744ec828624bc952bff43','backup_gigabytes',-1,'2025-12-03 10:12:00',NULL),('2025-12-02 10:12:01','2025-12-02 10:12:01','2025-12-02 10:12:01',1,405,'f0f31eef-f94b-4428-82d5-4e130ec9f2eb',99,'ab84e521dda9432ca7d62c5185f1eaab','volumes',-1,'2025-12-03 10:12:01',NULL),('2025-12-02 10:12:01','2025-12-02 10:12:01','2025-12-02 10:12:01',1,406,'f128dbba-a543-4f26-9316-4c4bf515b44a',100,'ab84e521dda9432ca7d62c5185f1eaab','gigabytes',-1,'2025-12-03 10:12:01',NULL),('2025-12-02 10:12:01','2025-12-02 10:12:01','2025-12-02 10:12:01',1,407,'b2516859-4855-4b5c-9f27-6d28c8cc83f1',101,'ab84e521dda9432ca7d62c5185f1eaab','volumes_tripleo',-1,'2025-12-03 10:12:01',NULL),('2025-12-02 10:12:01','2025-12-02 10:12:01','2025-12-02 10:12:01',1,408,'039c7c17-b1b2-4aff-8ad1-2b9f6648ecda',102,'ab84e521dda9432ca7d62c5185f1eaab','gigabytes_tripleo',-1,'2025-12-03 10:12:01',NULL),('2025-12-02 10:12:02','2025-12-02 10:12:02','2025-12-02 10:12:02',1,409,'fd255fba-198d-4600-89c7-0c671cd360f7',111,'f5466a94421d4e84977ee830576dd8b7','volumes',1,'2025-12-03 10:12:02',NULL),('2025-12-02 10:12:02','2025-12-02 10:12:02','2025-12-02 10:12:02',1,410,'6315091a-98f7-42ff-bc49-8fbea905786e',112,'f5466a94421d4e84977ee830576dd8b7','gigabytes',1,'2025-12-03 10:12:02',NULL),('2025-12-02 10:12:02','2025-12-02 10:12:02','2025-12-02 10:12:02',1,411,'2188296f-382b-4c82-b4d6-af8870e62f7d',113,'f5466a94421d4e84977ee830576dd8b7','volumes_tripleo',1,'2025-12-03 10:12:02',NULL),('2025-12-02 10:12:02','2025-12-02 10:12:02','2025-12-02 10:12:02',1,412,'2fe9985a-ef87-40c4-b148-ed5735d2dd5a',114,'f5466a94421d4e84977ee830576dd8b7','gigabytes_tripleo',1,'2025-12-03 10:12:02',NULL),('2025-12-02 10:12:02','2025-12-02 10:12:02','2025-12-02 10:12:02',1,413,'d708f006-e764-4e1e-bc0c-d59a4084fc5f',91,'10644498f24744ec828624bc952bff43','volumes',-1,'2025-12-03 10:12:02',NULL),('2025-12-02 10:12:02','2025-12-02 10:12:02','2025-12-02 10:12:02',1,414,'3991f06c-54cf-490e-977c-4f70e4433338',92,'10644498f24744ec828624bc952bff43','gigabytes',-1,'2025-12-03 10:12:02',NULL),('2025-12-02 10:12:02','2025-12-02 10:12:02','2025-12-02 10:12:02',1,415,'7c561fa2-659d-4159-b124-5b219ebf1b18',93,'10644498f24744ec828624bc952bff43','volumes_tripleo',-1,'2025-12-03 10:12:02',NULL),('2025-12-02 10:12:02','2025-12-02 10:12:02','2025-12-02 10:12:02',1,416,'1b46318e-69be-4e8a-b6b6-07c3d4ae0096',94,'10644498f24744ec828624bc952bff43','gigabytes_tripleo',-1,'2025-12-03 10:12:02',NULL),('2025-12-02 10:12:03','2025-12-02 10:12:03','2025-12-02 10:12:03',1,417,'04ccfed6-7c76-4c1e-8073-733351baa9b8',91,'10644498f24744ec828624bc952bff43','volumes',1,'2025-12-03 10:12:03',NULL),('2025-12-02 10:12:03','2025-12-02 10:12:03','2025-12-02 10:12:03',1,418,'a5d43a0d-0651-4e2f-a3a9-9a22923e4f92',92,'10644498f24744ec828624bc952bff43','gigabytes',1,'2025-12-03 10:12:03',NULL),('2025-12-02 10:12:03','2025-12-02 10:12:03','2025-12-02 10:12:03',1,419,'daba0003-5ca9-46f0-8262-29a4cabc285c',93,'10644498f24744ec828624bc952bff43','volumes_tripleo',1,'2025-12-03 10:12:03',NULL),('2025-12-02 10:12:03','2025-12-02 10:12:03','2025-12-02 10:12:03',1,420,'29057cd6-0e81-45f0-9702-cc06f0b71406',94,'10644498f24744ec828624bc952bff43','gigabytes_tripleo',1,'2025-12-03 10:12:03',NULL),('2025-12-02 10:12:04','2025-12-02 10:12:04','2025-12-02 10:12:04',1,421,'67559493-865e-4d87-9c6d-3fb03673e00b',95,'10644498f24744ec828624bc952bff43','backups',1,'2025-12-03 10:12:04',NULL),('2025-12-02 10:12:04','2025-12-02 10:12:04','2025-12-02 10:12:04',1,422,'c90adab1-d3fc-4a80-af80-29f1465814de',96,'10644498f24744ec828624bc952bff43','backup_gigabytes',1,'2025-12-03 10:12:04',NULL),('2025-12-02 10:12:08','2025-12-02 10:12:08','2025-12-02 10:12:08',1,423,'ab0271df-402f-4ca2-b57d-0711d49349aa',115,'da38242c0e8d4da7a906db10517a9171','volumes',1,'2025-12-03 10:12:08',NULL),('2025-12-02 10:12:08','2025-12-02 10:12:08','2025-12-02 10:12:08',1,424,'c6fd0be9-81fa-418b-bff6-610efd0984f2',116,'da38242c0e8d4da7a906db10517a9171','gigabytes',2,'2025-12-03 10:12:08',NULL),('2025-12-02 10:12:08','2025-12-02 10:12:08','2025-12-02 10:12:08',1,425,'046bcc52-e903-4670-b379-922a4450dfe1',117,'da38242c0e8d4da7a906db10517a9171','volumes_tripleo',1,'2025-12-03 10:12:08',NULL),('2025-12-02 10:12:08','2025-12-02 10:12:08','2025-12-02 10:12:08',1,426,'123f4c2b-37df-4f72-8bdc-d9ce97d93050',118,'da38242c0e8d4da7a906db10517a9171','gigabytes_tripleo',2,'2025-12-03 10:12:08',NULL),('2025-12-02 10:12:09','2025-12-02 10:12:09','2025-12-02 10:12:09',1,427,'ce85f625-871f-43f1-8c4f-c758d52a14b7',112,'f5466a94421d4e84977ee830576dd8b7','gigabytes',1,'2025-12-03 10:12:09',NULL),('2025-12-02 10:12:09','2025-12-02 10:12:09','2025-12-02 10:12:09',1,428,'9515c8ad-7df9-4387-b91f-85336fda1dcf',114,'f5466a94421d4e84977ee830576dd8b7','gigabytes_tripleo',1,'2025-12-03 10:12:09',NULL),('2025-12-02 10:12:09','2025-12-02 10:12:09','2025-12-02 10:12:09',1,429,'fb9a4062-fac2-4b4c-aca0-c70ad75e963d',115,'da38242c0e8d4da7a906db10517a9171','volumes',-1,'2025-12-03 10:12:09',NULL),('2025-12-02 10:12:09','2025-12-02 10:12:09','2025-12-02 10:12:09',1,430,'5cac4e6a-e1ee-4ff1-a15b-0cb946ad924a',116,'da38242c0e8d4da7a906db10517a9171','gigabytes',-2,'2025-12-03 10:12:09',NULL),('2025-12-02 10:12:09','2025-12-02 10:12:09','2025-12-02 10:12:09',1,431,'f0be763c-7947-4f1a-b811-38b42a635187',117,'da38242c0e8d4da7a906db10517a9171','volumes_tripleo',-1,'2025-12-03 10:12:09',NULL),('2025-12-02 10:12:09','2025-12-02 10:12:09','2025-12-02 10:12:09',1,432,'c9538681-90f9-48fc-9c6b-c735ace4d353',118,'da38242c0e8d4da7a906db10517a9171','gigabytes_tripleo',-2,'2025-12-03 10:12:09',NULL),('2025-12-02 10:12:09','2025-12-02 10:12:09','2025-12-02 10:12:09',1,433,'d3288d7e-efd7-4538-89d4-0181e78a99e5',95,'10644498f24744ec828624bc952bff43','backups',-1,'2025-12-03 10:12:09',NULL),('2025-12-02 10:12:09','2025-12-02 10:12:09','2025-12-02 10:12:09',1,434,'e3ca8cb1-f243-4d2a-869a-0cec667f1f9b',96,'10644498f24744ec828624bc952bff43','backup_gigabytes',-1,'2025-12-03 10:12:09',NULL),('2025-12-02 10:12:10','2025-12-02 10:12:10','2025-12-02 10:12:10',1,435,'74fd4d2f-6162-439f-9d22-061c2ca5eb64',111,'f5466a94421d4e84977ee830576dd8b7','volumes',-1,'2025-12-03 10:12:10',NULL),('2025-12-02 10:12:10','2025-12-02 10:12:10','2025-12-02 10:12:10',1,436,'2c57472f-ffab-456b-ab59-5d7f21edb3d6',112,'f5466a94421d4e84977ee830576dd8b7','gigabytes',-2,'2025-12-03 10:12:10',NULL),('2025-12-02 10:12:10','2025-12-02 10:12:10','2025-12-02 10:12:10',1,437,'cd5e6ad2-9230-4399-a573-c1e436634490',113,'f5466a94421d4e84977ee830576dd8b7','volumes_tripleo',-1,'2025-12-03 10:12:10',NULL),('2025-12-02 10:12:10','2025-12-02 10:12:10','2025-12-02 10:12:10',1,438,'5843dc47-748d-408c-9b4d-2ae9b2e27baa',114,'f5466a94421d4e84977ee830576dd8b7','gigabytes_tripleo',-2,'2025-12-03 10:12:10',NULL),('2025-12-02 10:12:11','2025-12-02 10:12:11','2025-12-02 10:12:11',1,439,'9a5fd346-4c20-43f0-b39f-5d1ec4b99d42',111,'f5466a94421d4e84977ee830576dd8b7','volumes',1,'2025-12-03 10:12:11',NULL),('2025-12-02 10:12:11','2025-12-02 10:12:11','2025-12-02 10:12:11',1,440,'20b9f939-e8e6-4308-bedc-f206b7d12744',112,'f5466a94421d4e84977ee830576dd8b7','gigabytes',1,'2025-12-03 10:12:11',NULL),('2025-12-02 10:12:11','2025-12-02 10:12:11','2025-12-02 10:12:11',1,441,'10da74c3-0651-4ad2-a0d7-7873da51aac1',113,'f5466a94421d4e84977ee830576dd8b7','volumes_tripleo',1,'2025-12-03 10:12:11',NULL),('2025-12-02 10:12:11','2025-12-02 10:12:11','2025-12-02 10:12:11',1,442,'d67cf2d3-f8c9-451d-82d4-93636972bd95',114,'f5466a94421d4e84977ee830576dd8b7','gigabytes_tripleo',1,'2025-12-03 10:12:11',NULL),('2025-12-02 10:12:12','2025-12-02 10:12:12','2025-12-02 10:12:12',1,443,'1129b275-1a23-4b2a-9853-668cfeddf0e4',91,'10644498f24744ec828624bc952bff43','volumes',-1,'2025-12-03 10:12:12',NULL),('2025-12-02 10:12:12','2025-12-02 10:12:12','2025-12-02 10:12:12',1,444,'1b0e1de9-7955-402d-909e-9ef4f839e046',92,'10644498f24744ec828624bc952bff43','gigabytes',-1,'2025-12-03 10:12:12',NULL),('2025-12-02 10:12:12','2025-12-02 10:12:12','2025-12-02 10:12:12',1,445,'0350dc21-6ce0-4370-a1d5-2731fee88b6e',93,'10644498f24744ec828624bc952bff43','volumes_tripleo',-1,'2025-12-03 10:12:12',NULL),('2025-12-02 10:12:12','2025-12-02 10:12:12','2025-12-02 10:12:12',1,446,'26b96111-7df2-4d9e-93fb-ca6d3fe1d691',94,'10644498f24744ec828624bc952bff43','gigabytes_tripleo',-1,'2025-12-03 10:12:12',NULL),('2025-12-02 10:12:12','2025-12-02 10:12:12','2025-12-02 10:12:12',1,447,'71513cf9-28fc-4bb7-a944-6da4872a163d',119,'f5466a94421d4e84977ee830576dd8b7','snapshots',1,'2025-12-03 10:12:12',NULL),('2025-12-02 10:12:12','2025-12-02 10:12:12','2025-12-02 10:12:12',1,448,'108b57e8-066d-428e-a2c1-28b4f77bd7a7',112,'f5466a94421d4e84977ee830576dd8b7','gigabytes',1,'2025-12-03 10:12:12',NULL),('2025-12-02 10:12:12','2025-12-02 10:12:12','2025-12-02 10:12:12',1,449,'3744d117-d61f-4b38-abbe-c84176aec48a',114,'f5466a94421d4e84977ee830576dd8b7','gigabytes_tripleo',1,'2025-12-03 10:12:12',NULL),('2025-12-02 10:12:12','2025-12-02 10:12:12','2025-12-02 10:12:12',1,450,'e02cb876-34f6-4167-824a-6fc2c8d63be2',120,'f5466a94421d4e84977ee830576dd8b7','snapshots_tripleo',1,'2025-12-03 10:12:12',NULL),('2025-12-02 10:12:14','2025-12-02 10:12:15','2025-12-02 10:12:15',1,451,'8f5ee3c5-8cd7-41c9-8cfd-103cda311809',112,'f5466a94421d4e84977ee830576dd8b7','gigabytes',1,'2025-12-03 10:12:14',NULL),('2025-12-02 10:12:14','2025-12-02 10:12:15','2025-12-02 10:12:15',1,452,'7d11aabf-591c-47e4-90a9-4e8d3019ec60',114,'f5466a94421d4e84977ee830576dd8b7','gigabytes_tripleo',1,'2025-12-03 10:12:14',NULL),('2025-12-02 10:12:16','2025-12-02 10:12:16','2025-12-02 10:12:16',1,453,'7b65a109-edb4-4d37-bda8-53843bc24835',119,'f5466a94421d4e84977ee830576dd8b7','snapshots',-1,'2025-12-03 10:12:16',NULL),('2025-12-02 10:12:16','2025-12-02 10:12:16','2025-12-02 10:12:16',1,454,'49d8a9e8-0d31-4f5b-aa8a-7149522a7987',112,'f5466a94421d4e84977ee830576dd8b7','gigabytes',-1,'2025-12-03 10:12:16',NULL),('2025-12-02 10:12:16','2025-12-02 10:12:16','2025-12-02 10:12:16',1,455,'baad23d1-14cf-459c-8b17-9e5721aa8fb4',114,'f5466a94421d4e84977ee830576dd8b7','gigabytes_tripleo',-1,'2025-12-03 10:12:16',NULL),('2025-12-02 10:12:16','2025-12-02 10:12:16','2025-12-02 10:12:16',1,456,'001a0a41-fbb6-412c-8f65-c1f225a17cd6',120,'f5466a94421d4e84977ee830576dd8b7','snapshots_tripleo',-1,'2025-12-03 10:12:16',NULL),('2025-12-02 10:12:17','2025-12-02 10:12:18','2025-12-02 10:12:18',1,457,'958abf81-3dcb-4b8a-be9a-42bf3bdf4a3c',111,'f5466a94421d4e84977ee830576dd8b7','volumes',-1,'2025-12-03 10:12:17',NULL),('2025-12-02 10:12:17','2025-12-02 10:12:18','2025-12-02 10:12:18',1,458,'9be99d7e-332b-4b32-b52c-acbd8ce73285',112,'f5466a94421d4e84977ee830576dd8b7','gigabytes',-2,'2025-12-03 10:12:17',NULL),('2025-12-02 10:12:17','2025-12-02 10:12:18','2025-12-02 10:12:18',1,459,'b3ea2633-362e-42ba-a8f3-60e19583acdb',113,'f5466a94421d4e84977ee830576dd8b7','volumes_tripleo',-1,'2025-12-03 10:12:17',NULL),('2025-12-02 10:12:17','2025-12-02 10:12:18','2025-12-02 10:12:18',1,460,'76f06407-446a-4e90-bf75-f3ce49622361',114,'f5466a94421d4e84977ee830576dd8b7','gigabytes_tripleo',-2,'2025-12-03 10:12:17',NULL),('2025-12-02 10:12:22','2025-12-02 10:12:22','2025-12-02 10:12:22',1,461,'b8a76d61-2e9c-4a1f-967a-90d050133027',121,'9983d967265d4691806eb9b9a49900de','volumes',1,'2025-12-03 10:12:22',NULL),('2025-12-02 10:12:22','2025-12-02 10:12:22','2025-12-02 10:12:22',1,462,'b5ab4ea0-e726-4250-b028-79d8d6a4ed3f',122,'9983d967265d4691806eb9b9a49900de','gigabytes',1,'2025-12-03 10:12:22',NULL),('2025-12-02 10:12:22','2025-12-02 10:12:22','2025-12-02 10:12:22',1,463,'34b05b96-8e02-407e-8fea-b2b650bcb073',123,'9983d967265d4691806eb9b9a49900de','volumes_tripleo',1,'2025-12-03 10:12:22',NULL),('2025-12-02 10:12:22','2025-12-02 10:12:22','2025-12-02 10:12:22',1,464,'7909e0bc-896c-4f7b-af76-e82790106c0d',124,'9983d967265d4691806eb9b9a49900de','gigabytes_tripleo',1,'2025-12-03 10:12:22',NULL),('2025-12-02 10:12:26','2025-12-02 10:12:26','2025-12-02 10:12:26',1,465,'6e4f5a9c-8b1b-440d-be40-341704824a13',125,'6b4f1f3dd8704e9992f1bc11c793a60e','groups',1,'2025-12-03 10:12:26',NULL),('2025-12-02 10:12:28','2025-12-02 10:12:28','2025-12-02 10:12:28',1,466,'b1f22707-a070-43a0-828a-728dac546c21',126,'6b4f1f3dd8704e9992f1bc11c793a60e','volumes',1,'2025-12-03 10:12:28',NULL),('2025-12-02 10:12:28','2025-12-02 10:12:28','2025-12-02 10:12:28',1,467,'49404cfe-642c-4e79-848e-8e40543aa967',127,'6b4f1f3dd8704e9992f1bc11c793a60e','gigabytes',1,'2025-12-03 10:12:28',NULL),('2025-12-02 10:12:28','2025-12-02 10:12:28','2025-12-02 10:12:28',1,468,'f7e1bed0-a25d-48a3-a877-b92c323fa81b',128,'6b4f1f3dd8704e9992f1bc11c793a60e','volumes_tempest-GroupSnapshotsV319Test-volume-type-1502590696',1,'2025-12-03 10:12:28',NULL),('2025-12-02 10:12:28','2025-12-02 10:12:28','2025-12-02 10:12:28',1,469,'2f4f5749-4a7b-4f64-b2d0-d589cc8e10cf',129,'6b4f1f3dd8704e9992f1bc11c793a60e','gigabytes_tempest-GroupSnapshotsV319Test-volume-type-1502590696',1,'2025-12-03 10:12:28',NULL),('2025-12-02 10:12:29','2025-12-02 10:12:29','2025-12-02 10:12:29',1,470,'dd480859-9c70-4cac-9d08-efba91cccae5',130,'6b4f1f3dd8704e9992f1bc11c793a60e','snapshots',1,'2025-12-03 10:12:29',NULL),('2025-12-02 10:12:29','2025-12-02 10:12:29','2025-12-02 10:12:29',1,471,'51a58385-13ee-4bfc-a792-eb362ede669b',127,'6b4f1f3dd8704e9992f1bc11c793a60e','gigabytes',1,'2025-12-03 10:12:29',NULL),('2025-12-02 10:12:29','2025-12-02 10:12:29','2025-12-02 10:12:29',1,472,'bc43d66f-d999-4adb-9832-8d91b66865d0',129,'6b4f1f3dd8704e9992f1bc11c793a60e','gigabytes_tempest-GroupSnapshotsV319Test-volume-type-1502590696',1,'2025-12-03 10:12:29',NULL),('2025-12-02 10:12:29','2025-12-02 10:12:29','2025-12-02 10:12:29',1,473,'c9de7122-0524-49ee-98d7-8f9fd4d444cd',131,'6b4f1f3dd8704e9992f1bc11c793a60e','snapshots_tempest-GroupSnapshotsV319Test-volume-type-1502590696',1,'2025-12-03 10:12:29',NULL),('2025-12-02 10:12:31','2025-12-02 10:12:31','2025-12-02 10:12:31',1,474,'6d9037f1-820c-45eb-8f29-84ef30218f78',121,'9983d967265d4691806eb9b9a49900de','volumes',-1,'2025-12-03 10:12:31',NULL),('2025-12-02 10:12:31','2025-12-02 10:12:31','2025-12-02 10:12:31',1,475,'0fa6c76b-9951-4b22-a5c0-c3910f21e70f',122,'9983d967265d4691806eb9b9a49900de','gigabytes',-1,'2025-12-03 10:12:31',NULL),('2025-12-02 10:12:31','2025-12-02 10:12:31','2025-12-02 10:12:31',1,476,'7c312e04-14ec-4961-bf6f-0e1d1666d7ea',123,'9983d967265d4691806eb9b9a49900de','volumes_tripleo',-1,'2025-12-03 10:12:31',NULL),('2025-12-02 10:12:31','2025-12-02 10:12:31','2025-12-02 10:12:31',1,477,'88208f4b-637f-4575-bdaa-4245ed3d33e6',124,'9983d967265d4691806eb9b9a49900de','gigabytes_tripleo',-1,'2025-12-03 10:12:31',NULL),('2025-12-02 10:12:32','2025-12-02 10:12:32','2025-12-02 10:12:32',1,478,'814db2a4-3264-4303-81e3-63f4adc7222b',130,'6b4f1f3dd8704e9992f1bc11c793a60e','snapshots',-1,'2025-12-03 10:12:32',NULL),('2025-12-02 10:12:32','2025-12-02 10:12:32','2025-12-02 10:12:32',1,479,'4a56cc46-11b8-4071-bd77-2b7d5c57b3d5',127,'6b4f1f3dd8704e9992f1bc11c793a60e','gigabytes',-1,'2025-12-03 10:12:32',NULL),('2025-12-02 10:12:32','2025-12-02 10:12:32','2025-12-02 10:12:32',1,480,'7b205f99-3194-4e12-8fd3-6f4427431323',129,'6b4f1f3dd8704e9992f1bc11c793a60e','gigabytes_tempest-GroupSnapshotsV319Test-volume-type-1502590696',-1,'2025-12-03 10:12:32',NULL),('2025-12-02 10:12:32','2025-12-02 10:12:32','2025-12-02 10:12:32',1,481,'d9883e90-2e0d-46aa-8d75-d96e4deb7973',131,'6b4f1f3dd8704e9992f1bc11c793a60e','snapshots_tempest-GroupSnapshotsV319Test-volume-type-1502590696',-1,'2025-12-03 10:12:32',NULL),('2025-12-02 10:12:34','2025-12-02 10:12:34','2025-12-02 10:12:34',1,482,'4b3496a2-7786-4b3c-b538-10916c3e4d3a',125,'6b4f1f3dd8704e9992f1bc11c793a60e','groups',-1,'2025-12-03 10:12:34',NULL),('2025-12-02 10:12:34','2025-12-02 10:12:34','2025-12-02 10:12:34',1,483,'af9bba4c-a36d-4ed1-a649-9e7d32f5fe59',126,'6b4f1f3dd8704e9992f1bc11c793a60e','volumes',-1,'2025-12-03 10:12:34',NULL),('2025-12-02 10:12:34','2025-12-02 10:12:34','2025-12-02 10:12:34',1,484,'e4ad5abf-9b03-4a4d-b461-b20d374fad27',127,'6b4f1f3dd8704e9992f1bc11c793a60e','gigabytes',-1,'2025-12-03 10:12:34',NULL),('2025-12-02 10:12:34','2025-12-02 10:12:34','2025-12-02 10:12:34',1,485,'bb51c442-40f0-40f7-839f-787248f48baf',128,'6b4f1f3dd8704e9992f1bc11c793a60e','volumes_tempest-GroupSnapshotsV319Test-volume-type-1502590696',-1,'2025-12-03 10:12:34',NULL),('2025-12-02 10:12:34','2025-12-02 10:12:34','2025-12-02 10:12:34',1,486,'352cd7c7-b045-47f9-8b90-a8720a7d33c0',129,'6b4f1f3dd8704e9992f1bc11c793a60e','gigabytes_tempest-GroupSnapshotsV319Test-volume-type-1502590696',-1,'2025-12-03 10:12:34',NULL),('2025-12-02 10:12:36','2025-12-02 10:12:36','2025-12-02 10:12:36',1,487,'5ca3c33e-9310-458c-8cb8-c55f38bd3786',132,'b374ce45b6dc4bc5b2eac77a9216133f','volumes',1,'2025-12-03 10:12:36',NULL),('2025-12-02 10:12:36','2025-12-02 10:12:36','2025-12-02 10:12:36',1,488,'d3b54711-868f-4547-8126-687f4d8acffa',133,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes',1,'2025-12-03 10:12:36',NULL),('2025-12-02 10:12:36','2025-12-02 10:12:36','2025-12-02 10:12:36',1,489,'02e0233f-fbf6-40de-8103-41d13c7be31f',134,'b374ce45b6dc4bc5b2eac77a9216133f','volumes_tripleo',1,'2025-12-03 10:12:36',NULL),('2025-12-02 10:12:36','2025-12-02 10:12:36','2025-12-02 10:12:36',1,490,'9073cf7f-39a0-4ea0-a7c8-c81ea8b60bbe',135,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes_tripleo',1,'2025-12-03 10:12:36',NULL),('2025-12-02 10:12:37','2025-12-02 10:12:37','2025-12-02 10:12:37',1,491,'8912ae26-7448-4c79-b595-97b153477d74',136,'b374ce45b6dc4bc5b2eac77a9216133f','snapshots',1,'2025-12-03 10:12:37',NULL),('2025-12-02 10:12:37','2025-12-02 10:12:37','2025-12-02 10:12:37',1,492,'2e8233ef-96b4-449b-93de-da1273c46320',133,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes',1,'2025-12-03 10:12:37',NULL),('2025-12-02 10:12:37','2025-12-02 10:12:37','2025-12-02 10:12:37',1,493,'72ed3606-f77f-481b-847e-901ae10d4aab',135,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes_tripleo',1,'2025-12-03 10:12:37',NULL),('2025-12-02 10:12:37','2025-12-02 10:12:37','2025-12-02 10:12:37',1,494,'98f1bd29-ac01-44a8-9cd1-9193b64dad67',137,'b374ce45b6dc4bc5b2eac77a9216133f','snapshots_tripleo',1,'2025-12-03 10:12:37',NULL),('2025-12-02 10:12:38','2025-12-02 10:12:38','2025-12-02 10:12:38',1,495,'d28e5333-e1e9-43d4-b9c6-a022975ed0ca',138,'b374ce45b6dc4bc5b2eac77a9216133f','backups',1,'2025-12-03 10:12:38',NULL),('2025-12-02 10:12:38','2025-12-02 10:12:38','2025-12-02 10:12:38',1,496,'75c3ca35-a430-4abc-9290-d83b687b236e',139,'b374ce45b6dc4bc5b2eac77a9216133f','backup_gigabytes',1,'2025-12-03 10:12:38',NULL),('2025-12-02 10:12:47','2025-12-02 10:12:47','2025-12-02 10:12:47',1,497,'068793e4-0218-4a41-840f-2606d803d42d',140,'bb3c511d46dd4d3ead65c06b6e7b5c12','volumes',1,'2025-12-03 10:12:47',NULL),('2025-12-02 10:12:47','2025-12-02 10:12:47','2025-12-02 10:12:47',1,498,'71f3e44a-319f-44b2-9793-5cf6f1706650',141,'bb3c511d46dd4d3ead65c06b6e7b5c12','gigabytes',1,'2025-12-03 10:12:47',NULL),('2025-12-02 10:12:47','2025-12-02 10:12:47','2025-12-02 10:12:47',1,499,'bb58f454-e985-44cc-8643-bec17b4fecb8',142,'bb3c511d46dd4d3ead65c06b6e7b5c12','volumes_tripleo',1,'2025-12-03 10:12:47',NULL),('2025-12-02 10:12:47','2025-12-02 10:12:47','2025-12-02 10:12:47',1,500,'a395a338-6fe4-4688-bdce-59d7901d70d9',143,'bb3c511d46dd4d3ead65c06b6e7b5c12','gigabytes_tripleo',1,'2025-12-03 10:12:47',NULL),('2025-12-02 10:12:51','2025-12-02 10:12:51','2025-12-02 10:12:51',1,501,'2e71bfac-00cc-4d94-b70e-b63c1ac4636d',140,'bb3c511d46dd4d3ead65c06b6e7b5c12','volumes',-1,'2025-12-03 10:12:51',NULL),('2025-12-02 10:12:51','2025-12-02 10:12:51','2025-12-02 10:12:51',1,502,'0fa0179b-c2c6-49c9-bb66-7ce2d82816d3',141,'bb3c511d46dd4d3ead65c06b6e7b5c12','gigabytes',-1,'2025-12-03 10:12:51',NULL),('2025-12-02 10:12:51','2025-12-02 10:12:51','2025-12-02 10:12:51',1,503,'650b58cd-02ba-47ea-91ff-1332fa09729f',142,'bb3c511d46dd4d3ead65c06b6e7b5c12','volumes_tripleo',-1,'2025-12-03 10:12:51',NULL),('2025-12-02 10:12:51','2025-12-02 10:12:51','2025-12-02 10:12:51',1,504,'ed603710-ec43-4264-9ec3-b6f011964213',143,'bb3c511d46dd4d3ead65c06b6e7b5c12','gigabytes_tripleo',-1,'2025-12-03 10:12:51',NULL),('2025-12-02 10:12:54','2025-12-02 10:12:55','2025-12-02 10:12:55',1,505,'ed58c0a4-1056-49c0-abf1-09e3e279f33c',138,'b374ce45b6dc4bc5b2eac77a9216133f','backups',-1,'2025-12-03 10:12:54',NULL),('2025-12-02 10:12:54','2025-12-02 10:12:55','2025-12-02 10:12:55',1,506,'b4009d96-1897-44b2-beb5-c1262b59f3ce',139,'b374ce45b6dc4bc5b2eac77a9216133f','backup_gigabytes',-1,'2025-12-03 10:12:54',NULL),('2025-12-02 10:12:55','2025-12-02 10:12:55','2025-12-02 10:12:55',1,507,'34ce6d54-0bf4-4e27-abf2-5adc67c88502',136,'b374ce45b6dc4bc5b2eac77a9216133f','snapshots',-1,'2025-12-03 10:12:55',NULL),('2025-12-02 10:12:55','2025-12-02 10:12:55','2025-12-02 10:12:55',1,508,'03040319-707c-4cf2-89f4-109f1e08de7b',133,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes',-1,'2025-12-03 10:12:55',NULL),('2025-12-02 10:12:55','2025-12-02 10:12:55','2025-12-02 10:12:55',1,509,'96ec9146-684e-43f9-8b45-1f9ded53e099',135,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes_tripleo',-1,'2025-12-03 10:12:55',NULL),('2025-12-02 10:12:55','2025-12-02 10:12:55','2025-12-02 10:12:55',1,510,'963e5f1a-740e-44aa-b15d-f8753c5161c8',137,'b374ce45b6dc4bc5b2eac77a9216133f','snapshots_tripleo',-1,'2025-12-03 10:12:55',NULL),('2025-12-02 10:12:56','2025-12-02 10:12:56','2025-12-02 10:12:56',1,511,'49d7c818-7c10-4c72-8656-d009497469ee',136,'b374ce45b6dc4bc5b2eac77a9216133f','snapshots',1,'2025-12-03 10:12:56',NULL),('2025-12-02 10:12:56','2025-12-02 10:12:56','2025-12-02 10:12:56',1,512,'97824323-ffb7-44c3-86ea-e41963065f40',133,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes',1,'2025-12-03 10:12:56',NULL),('2025-12-02 10:12:56','2025-12-02 10:12:56','2025-12-02 10:12:56',1,513,'c51783be-7132-4433-bbab-a821bc3b8e66',135,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes_tripleo',1,'2025-12-03 10:12:56',NULL),('2025-12-02 10:12:56','2025-12-02 10:12:56','2025-12-02 10:12:56',1,514,'d7e12008-f6fb-4e57-97eb-79b65a24230b',137,'b374ce45b6dc4bc5b2eac77a9216133f','snapshots_tripleo',1,'2025-12-03 10:12:56',NULL),('2025-12-02 10:12:58','2025-12-02 10:12:58','2025-12-02 10:12:58',1,515,'e0ddb3fa-7dad-4a58-96d0-afc54e89960e',136,'b374ce45b6dc4bc5b2eac77a9216133f','snapshots',-1,'2025-12-03 10:12:58',NULL),('2025-12-02 10:12:58','2025-12-02 10:12:58','2025-12-02 10:12:58',1,516,'8f6ba55f-aad6-4126-a444-e997710ffdf9',133,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes',-1,'2025-12-03 10:12:58',NULL),('2025-12-02 10:12:58','2025-12-02 10:12:58','2025-12-02 10:12:58',1,517,'b4c45db9-5263-48d2-8144-f6c3f5984a89',135,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes_tripleo',-1,'2025-12-03 10:12:58',NULL),('2025-12-02 10:12:58','2025-12-02 10:12:58','2025-12-02 10:12:58',1,518,'5de770d4-7ab6-42b2-b3c1-76833fa23ed2',137,'b374ce45b6dc4bc5b2eac77a9216133f','snapshots_tripleo',-1,'2025-12-03 10:12:58',NULL),('2025-12-02 10:12:59','2025-12-02 10:12:59','2025-12-02 10:12:59',1,519,'048a31ca-3e5f-4fa6-8f77-b38ee29c6ed4',144,'8943858eee964ad7920643441a49ca76','volumes',1,'2025-12-03 10:12:59',NULL),('2025-12-02 10:12:59','2025-12-02 10:12:59','2025-12-02 10:12:59',1,520,'dcda1c36-c220-4bda-ac55-3f0ee9c4f5f4',145,'8943858eee964ad7920643441a49ca76','gigabytes',1,'2025-12-03 10:12:59',NULL),('2025-12-02 10:12:59','2025-12-02 10:12:59','2025-12-02 10:12:59',1,521,'05231676-89a7-4e4c-8ba7-6a3dbc69e4db',146,'8943858eee964ad7920643441a49ca76','volumes_tripleo',1,'2025-12-03 10:12:59',NULL),('2025-12-02 10:12:59','2025-12-02 10:12:59','2025-12-02 10:12:59',1,522,'21fbfc44-1986-427a-abd1-1ad9db3dba23',147,'8943858eee964ad7920643441a49ca76','gigabytes_tripleo',1,'2025-12-03 10:12:59',NULL),('2025-12-02 10:12:59','2025-12-02 10:12:59','2025-12-02 10:12:59',1,523,'3d9cc1b2-4d71-4a0a-83e5-4ee18a8a4d92',132,'b374ce45b6dc4bc5b2eac77a9216133f','volumes',1,'2025-12-03 10:12:59',NULL),('2025-12-02 10:12:59','2025-12-02 10:12:59','2025-12-02 10:12:59',1,524,'c984a21f-7c28-4c33-b8d1-19783b9e477e',133,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes',1,'2025-12-03 10:12:59',NULL),('2025-12-02 10:12:59','2025-12-02 10:12:59','2025-12-02 10:12:59',1,525,'0015481a-6371-4c63-a5c5-ebea490a9ab2',134,'b374ce45b6dc4bc5b2eac77a9216133f','volumes_tripleo',1,'2025-12-03 10:12:59',NULL),('2025-12-02 10:12:59','2025-12-02 10:12:59','2025-12-02 10:12:59',1,526,'5ebaee75-7bf5-40f8-844e-f32dfc8bd6d6',135,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes_tripleo',1,'2025-12-03 10:12:59',NULL),('2025-12-02 10:13:00','2025-12-02 10:13:00','2025-12-02 10:13:00',1,527,'645540d6-22dd-4652-aaba-d052c1906860',148,'8943858eee964ad7920643441a49ca76','snapshots',1,'2025-12-03 10:13:00',NULL),('2025-12-02 10:13:00','2025-12-02 10:13:00','2025-12-02 10:13:00',1,528,'db1d5a39-96cd-4bc6-925b-cad09b7e2683',145,'8943858eee964ad7920643441a49ca76','gigabytes',1,'2025-12-03 10:13:00',NULL),('2025-12-02 10:13:00','2025-12-02 10:13:00','2025-12-02 10:13:00',1,529,'dd5ce162-7dd7-473f-87a7-2690980b2e2d',147,'8943858eee964ad7920643441a49ca76','gigabytes_tripleo',1,'2025-12-03 10:13:00',NULL),('2025-12-02 10:13:00','2025-12-02 10:13:00','2025-12-02 10:13:00',1,530,'6af931f8-0157-402e-8ce9-a875973fef1c',149,'8943858eee964ad7920643441a49ca76','snapshots_tripleo',1,'2025-12-03 10:13:00',NULL),('2025-12-02 10:13:01','2025-12-02 10:13:01','2025-12-02 10:13:01',1,531,'38cbbcc7-77e6-4270-8475-d94a345e2353',136,'b374ce45b6dc4bc5b2eac77a9216133f','snapshots',1,'2025-12-03 10:13:01',NULL),('2025-12-02 10:13:01','2025-12-02 10:13:01','2025-12-02 10:13:01',1,532,'51a27a95-853d-49e5-beae-7a38a44f7df1',133,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes',1,'2025-12-03 10:13:01',NULL),('2025-12-02 10:13:01','2025-12-02 10:13:01','2025-12-02 10:13:01',1,533,'a52c305e-66ee-4017-8124-f2421e2eb78f',135,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes_tripleo',1,'2025-12-03 10:13:01',NULL),('2025-12-02 10:13:01','2025-12-02 10:13:01','2025-12-02 10:13:01',1,534,'e74d41a5-f8c8-4970-9183-45ea6f70da56',137,'b374ce45b6dc4bc5b2eac77a9216133f','snapshots_tripleo',1,'2025-12-03 10:13:01',NULL),('2025-12-02 10:13:02','2025-12-02 10:13:02','2025-12-02 10:13:02',1,535,'603c7807-86a9-4fde-8a2b-ac9c0bc845be',132,'b374ce45b6dc4bc5b2eac77a9216133f','volumes',1,'2025-12-03 10:13:02',NULL),('2025-12-02 10:13:02','2025-12-02 10:13:02','2025-12-02 10:13:02',1,536,'4df4ecea-2435-43c1-846d-eeaec0d60c8d',133,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes',2,'2025-12-03 10:13:02',NULL),('2025-12-02 10:13:02','2025-12-02 10:13:02','2025-12-02 10:13:02',1,537,'8da2a21e-e6aa-4418-ab69-b93a88bfc429',134,'b374ce45b6dc4bc5b2eac77a9216133f','volumes_tripleo',1,'2025-12-03 10:13:02',NULL),('2025-12-02 10:13:02','2025-12-02 10:13:02','2025-12-02 10:13:02',1,538,'1ea9ee61-5855-493d-a0d4-c6a30d32fb00',135,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes_tripleo',2,'2025-12-03 10:13:02',NULL),('2025-12-02 10:13:03','2025-12-02 10:13:03','2025-12-02 10:13:03',1,539,'9b399c00-9dde-4abc-b47e-c88707a3ae14',148,'8943858eee964ad7920643441a49ca76','snapshots',-1,'2025-12-03 10:13:03',NULL),('2025-12-02 10:13:03','2025-12-02 10:13:03','2025-12-02 10:13:03',1,540,'deb1d2e4-3f50-4a93-bd42-55023fa1049d',145,'8943858eee964ad7920643441a49ca76','gigabytes',-1,'2025-12-03 10:13:03',NULL),('2025-12-02 10:13:03','2025-12-02 10:13:03','2025-12-02 10:13:03',1,541,'82f096fd-56d2-46fb-80ee-2ce6564c11ca',147,'8943858eee964ad7920643441a49ca76','gigabytes_tripleo',-1,'2025-12-03 10:13:03',NULL),('2025-12-02 10:13:03','2025-12-02 10:13:03','2025-12-02 10:13:03',1,542,'cff1faf2-d6d5-4536-8260-e507f4d7ca23',149,'8943858eee964ad7920643441a49ca76','snapshots_tripleo',-1,'2025-12-03 10:13:03',NULL),('2025-12-02 10:13:04','2025-12-02 10:13:04','2025-12-02 10:13:04',1,543,'76dfed15-8c09-4588-9827-717e166d45c2',132,'b374ce45b6dc4bc5b2eac77a9216133f','volumes',-1,'2025-12-03 10:13:04',NULL),('2025-12-02 10:13:04','2025-12-02 10:13:04','2025-12-02 10:13:04',1,544,'9f44c84b-b5cc-47aa-9c94-8b9866125c2f',133,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes',-2,'2025-12-03 10:13:04',NULL),('2025-12-02 10:13:04','2025-12-02 10:13:04','2025-12-02 10:13:04',1,545,'4818eca6-021d-4a28-8298-494c918eaf6d',134,'b374ce45b6dc4bc5b2eac77a9216133f','volumes_tripleo',-1,'2025-12-03 10:13:04',NULL),('2025-12-02 10:13:04','2025-12-02 10:13:04','2025-12-02 10:13:04',1,546,'ab01df3a-ec08-4eb3-b4cb-d23d8e671131',135,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes_tripleo',-2,'2025-12-03 10:13:04',NULL),('2025-12-02 10:13:04','2025-12-02 10:13:04','2025-12-02 10:13:04',1,547,'5ee5df47-ddec-40d4-873e-123b187698cc',144,'8943858eee964ad7920643441a49ca76','volumes',-1,'2025-12-03 10:13:04',NULL),('2025-12-02 10:13:04','2025-12-02 10:13:04','2025-12-02 10:13:04',1,548,'f231ecbe-1a37-4d87-aecf-2bd279385e6d',145,'8943858eee964ad7920643441a49ca76','gigabytes',-1,'2025-12-03 10:13:04',NULL),('2025-12-02 10:13:04','2025-12-02 10:13:04','2025-12-02 10:13:04',1,549,'c34b8026-d8ae-4adf-8fff-1bda324f863f',146,'8943858eee964ad7920643441a49ca76','volumes_tripleo',-1,'2025-12-03 10:13:04',NULL),('2025-12-02 10:13:04','2025-12-02 10:13:04','2025-12-02 10:13:04',1,550,'74feb623-cf10-4367-98fe-46ee7413fc42',147,'8943858eee964ad7920643441a49ca76','gigabytes_tripleo',-1,'2025-12-03 10:13:04',NULL),('2025-12-02 10:13:05','2025-12-02 10:13:05','2025-12-02 10:13:05',1,551,'0195748c-c00c-4e77-a25c-363855dbdf60',136,'b374ce45b6dc4bc5b2eac77a9216133f','snapshots',-1,'2025-12-03 10:13:05',NULL),('2025-12-02 10:13:05','2025-12-02 10:13:05','2025-12-02 10:13:05',1,552,'33235dcc-ad01-465b-a287-0788dc96dd77',133,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes',-1,'2025-12-03 10:13:05',NULL),('2025-12-02 10:13:05','2025-12-02 10:13:05','2025-12-02 10:13:05',1,553,'6a60db55-34b3-4bfb-bf1a-6437b0d532f9',135,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes_tripleo',-1,'2025-12-03 10:13:05',NULL),('2025-12-02 10:13:05','2025-12-02 10:13:05','2025-12-02 10:13:05',1,554,'66896fc6-8ba6-4a65-b791-65a9102b976d',137,'b374ce45b6dc4bc5b2eac77a9216133f','snapshots_tripleo',-1,'2025-12-03 10:13:05',NULL),('2025-12-02 10:13:06','2025-12-02 10:13:06','2025-12-02 10:13:06',1,555,'95c8cc8b-1de7-4785-8cb6-fa59b66e4325',132,'b374ce45b6dc4bc5b2eac77a9216133f','volumes',-1,'2025-12-03 10:13:06',NULL),('2025-12-02 10:13:06','2025-12-02 10:13:06','2025-12-02 10:13:06',1,556,'80bbd490-31cb-47b5-afca-02e3accb0877',133,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes',-1,'2025-12-03 10:13:06',NULL),('2025-12-02 10:13:06','2025-12-02 10:13:06','2025-12-02 10:13:06',1,557,'97b90d5c-7553-4f85-8f71-24257e81b464',134,'b374ce45b6dc4bc5b2eac77a9216133f','volumes_tripleo',-1,'2025-12-03 10:13:06',NULL),('2025-12-02 10:13:06','2025-12-02 10:13:06','2025-12-02 10:13:06',1,558,'860c4e4f-b0a8-4d26-a8a1-06ef4a1779c0',135,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes_tripleo',-1,'2025-12-03 10:13:06',NULL),('2025-12-02 10:13:07','2025-12-02 10:13:07','2025-12-02 10:13:07',1,559,'f5856e26-74a2-46f9-a8e5-7f1d366e1de7',132,'b374ce45b6dc4bc5b2eac77a9216133f','volumes',1,'2025-12-03 10:13:07',NULL),('2025-12-02 10:13:07','2025-12-02 10:13:07','2025-12-02 10:13:07',1,560,'bf7afe8e-3c47-4771-9472-43a712b2199f',133,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes',1,'2025-12-03 10:13:07',NULL),('2025-12-02 10:13:07','2025-12-02 10:13:07','2025-12-02 10:13:07',1,561,'40734804-f404-49da-be39-26e8bf0d5794',134,'b374ce45b6dc4bc5b2eac77a9216133f','volumes_tripleo',1,'2025-12-03 10:13:07',NULL),('2025-12-02 10:13:07','2025-12-02 10:13:07','2025-12-02 10:13:07',1,562,'2b0a676f-34ee-4c6c-a123-5610256da9a2',135,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes_tripleo',1,'2025-12-03 10:13:07',NULL),('2025-12-02 10:13:08','2025-12-02 10:13:08','2025-12-02 10:13:08',1,563,'37e1d53b-f209-4bb3-a9af-12d9c95288e3',136,'b374ce45b6dc4bc5b2eac77a9216133f','snapshots',1,'2025-12-03 10:13:08',NULL),('2025-12-02 10:13:08','2025-12-02 10:13:08','2025-12-02 10:13:08',1,564,'273f28d0-99b9-4882-b34f-2670b6ea6b45',133,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes',1,'2025-12-03 10:13:08',NULL),('2025-12-02 10:13:08','2025-12-02 10:13:08','2025-12-02 10:13:08',1,565,'8cbb4dfa-af25-4209-af17-50c66bd0e38f',135,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes_tripleo',1,'2025-12-03 10:13:08',NULL),('2025-12-02 10:13:08','2025-12-02 10:13:08','2025-12-02 10:13:08',1,566,'4636dc4c-988f-4802-b710-bbaf6542ca2f',137,'b374ce45b6dc4bc5b2eac77a9216133f','snapshots_tripleo',1,'2025-12-03 10:13:08',NULL),('2025-12-02 10:13:09','2025-12-02 10:13:09','2025-12-02 10:13:09',1,567,'061f2798-f642-49e4-a833-62a3b68c5d3f',132,'b374ce45b6dc4bc5b2eac77a9216133f','volumes',1,'2025-12-03 10:13:09',NULL),('2025-12-02 10:13:09','2025-12-02 10:13:09','2025-12-02 10:13:09',1,568,'7c839955-b0a6-4e88-a06a-17b508169923',133,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes',1,'2025-12-03 10:13:09',NULL),('2025-12-02 10:13:09','2025-12-02 10:13:09','2025-12-02 10:13:09',1,569,'0afc694a-e91c-4d78-8d9a-00f6a9e6a4a6',134,'b374ce45b6dc4bc5b2eac77a9216133f','volumes_tripleo',1,'2025-12-03 10:13:09',NULL),('2025-12-02 10:13:09','2025-12-02 10:13:09','2025-12-02 10:13:09',1,570,'e5d4b03b-417a-4776-b0f0-fb0e32693169',135,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes_tripleo',1,'2025-12-03 10:13:09',NULL),('2025-12-02 10:13:11','2025-12-02 10:13:11','2025-12-02 10:13:11',1,571,'8a845bb1-7c0d-4c06-9bab-0ce4796faf55',132,'b374ce45b6dc4bc5b2eac77a9216133f','volumes',-1,'2025-12-03 10:13:11',NULL),('2025-12-02 10:13:11','2025-12-02 10:13:11','2025-12-02 10:13:11',1,572,'9e931b29-5852-43c0-8716-f2edc2213a7e',133,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes',-1,'2025-12-03 10:13:11',NULL),('2025-12-02 10:13:11','2025-12-02 10:13:11','2025-12-02 10:13:11',1,573,'4e222981-a586-4375-9ed6-50a85ea171e0',134,'b374ce45b6dc4bc5b2eac77a9216133f','volumes_tripleo',-1,'2025-12-03 10:13:11',NULL),('2025-12-02 10:13:11','2025-12-02 10:13:11','2025-12-02 10:13:11',1,574,'3bff5ece-a875-4113-909a-864710b4cb4e',135,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes_tripleo',-1,'2025-12-03 10:13:11',NULL),('2025-12-02 10:13:12','2025-12-02 10:13:12','2025-12-02 10:13:12',1,575,'1a60e520-a508-4e51-b397-47dd8297fb9e',150,'e40b394d064942f593402333dc8c9581','volumes',1,'2025-12-03 10:13:12',NULL),('2025-12-02 10:13:12','2025-12-02 10:13:12','2025-12-02 10:13:12',1,576,'120deb5f-cd83-48cc-baec-577bd4726233',151,'e40b394d064942f593402333dc8c9581','gigabytes',1,'2025-12-03 10:13:12',NULL),('2025-12-02 10:13:12','2025-12-02 10:13:12','2025-12-02 10:13:12',1,577,'16643353-9293-4e4b-a512-98928f5b34cb',152,'e40b394d064942f593402333dc8c9581','volumes_tempest-VolumeTypesAccessTest-volume-type-1654729354',1,'2025-12-03 10:13:12',NULL),('2025-12-02 10:13:12','2025-12-02 10:13:12','2025-12-02 10:13:12',1,578,'93a46696-cb64-4919-afad-8c7791863171',153,'e40b394d064942f593402333dc8c9581','gigabytes_tempest-VolumeTypesAccessTest-volume-type-1654729354',1,'2025-12-03 10:13:12',NULL),('2025-12-02 10:13:12','2025-12-02 10:13:12','2025-12-02 10:13:12',1,579,'cda53af4-9958-4685-8c46-ac7bd9f89a95',154,'8ff22a276ec5464e8a97c8b3b0e8806c','groups',1,'2025-12-03 10:13:12',NULL),('2025-12-02 10:13:13','2025-12-02 10:13:13','2025-12-02 10:13:13',1,580,'5d86f769-2779-4804-83b2-dd12aa5f29e0',136,'b374ce45b6dc4bc5b2eac77a9216133f','snapshots',-1,'2025-12-03 10:13:13',NULL),('2025-12-02 10:13:13','2025-12-02 10:13:13','2025-12-02 10:13:13',1,581,'8e2367ae-64e3-48b2-b3e3-7f902c48e2f0',133,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes',-1,'2025-12-03 10:13:13',NULL),('2025-12-02 10:13:13','2025-12-02 10:13:13','2025-12-02 10:13:13',1,582,'9f8c24da-93df-4e4d-9a11-e5444155817d',135,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes_tripleo',-1,'2025-12-03 10:13:13',NULL),('2025-12-02 10:13:13','2025-12-02 10:13:13','2025-12-02 10:13:13',1,583,'1d4017a6-fddb-48e3-a517-74bd46d449e7',137,'b374ce45b6dc4bc5b2eac77a9216133f','snapshots_tripleo',-1,'2025-12-03 10:13:13',NULL),('2025-12-02 10:13:13','2025-12-02 10:13:13','2025-12-02 10:13:13',1,584,'b983b147-7170-49fa-8ef3-db1d0b3caacd',154,'8ff22a276ec5464e8a97c8b3b0e8806c','groups',1,'2025-12-03 10:13:13',NULL),('2025-12-02 10:13:14','2025-12-02 10:13:14','2025-12-02 10:13:14',1,585,'cad3bacc-c324-404f-b628-05b34bbba96f',150,'e40b394d064942f593402333dc8c9581','volumes',-1,'2025-12-03 10:13:14',NULL),('2025-12-02 10:13:14','2025-12-02 10:13:14','2025-12-02 10:13:14',1,586,'e5e2257d-907d-4546-ae0b-8a1057016af0',151,'e40b394d064942f593402333dc8c9581','gigabytes',-1,'2025-12-03 10:13:14',NULL),('2025-12-02 10:13:14','2025-12-02 10:13:14','2025-12-02 10:13:14',1,587,'8325afe4-23e7-491a-9a86-a20314cfaa89',152,'e40b394d064942f593402333dc8c9581','volumes_tempest-VolumeTypesAccessTest-volume-type-1654729354',-1,'2025-12-03 10:13:14',NULL),('2025-12-02 10:13:14','2025-12-02 10:13:14','2025-12-02 10:13:14',1,588,'74c6fa4e-f68c-4077-836a-c05515660e69',153,'e40b394d064942f593402333dc8c9581','gigabytes_tempest-VolumeTypesAccessTest-volume-type-1654729354',-1,'2025-12-03 10:13:14',NULL),('2025-12-02 10:13:14','2025-12-02 10:13:14','2025-12-02 10:13:14',1,589,'b682c8cf-3cb6-4017-96e4-f99f9c9ac866',132,'b374ce45b6dc4bc5b2eac77a9216133f','volumes',-1,'2025-12-03 10:13:14',NULL),('2025-12-02 10:13:14','2025-12-02 10:13:14','2025-12-02 10:13:14',1,590,'fd59002c-7137-473d-adbd-9b957f1ccebb',133,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes',-1,'2025-12-03 10:13:14',NULL),('2025-12-02 10:13:14','2025-12-02 10:13:14','2025-12-02 10:13:14',1,591,'b5daff63-db42-4797-920a-b1f5927750b5',134,'b374ce45b6dc4bc5b2eac77a9216133f','volumes_tripleo',-1,'2025-12-03 10:13:14',NULL),('2025-12-02 10:13:14','2025-12-02 10:13:14','2025-12-02 10:13:14',1,592,'f7057cc4-fa83-4b22-8bf6-7ee434438ca6',135,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes_tripleo',-1,'2025-12-03 10:13:14',NULL),('2025-12-02 10:13:15','2025-12-02 10:13:15','2025-12-02 10:13:15',1,593,'a51c8d49-4070-4e88-826e-1295be0d6a6c',155,'8ff22a276ec5464e8a97c8b3b0e8806c','volumes',1,'2025-12-03 10:13:15',NULL),('2025-12-02 10:13:15','2025-12-02 10:13:15','2025-12-02 10:13:15',1,594,'8b59e640-e8f3-41d1-abae-1efe078f1fff',156,'8ff22a276ec5464e8a97c8b3b0e8806c','gigabytes',1,'2025-12-03 10:13:15',NULL),('2025-12-02 10:13:15','2025-12-02 10:13:15','2025-12-02 10:13:15',1,595,'49afb48f-df89-4776-aa2f-3d385d3f622e',157,'8ff22a276ec5464e8a97c8b3b0e8806c','volumes_tempest-GroupsTest-volume-type-1153924094',1,'2025-12-03 10:13:15',NULL),('2025-12-02 10:13:15','2025-12-02 10:13:15','2025-12-02 10:13:15',1,596,'8c8b53df-d3ba-420f-adde-c20e59ef60d3',158,'8ff22a276ec5464e8a97c8b3b0e8806c','gigabytes_tempest-GroupsTest-volume-type-1153924094',1,'2025-12-03 10:13:15',NULL),('2025-12-02 10:13:15','2025-12-02 10:13:16','2025-12-02 10:13:16',1,597,'177f5acb-5fbe-410c-b903-ad0f555c8f1c',132,'b374ce45b6dc4bc5b2eac77a9216133f','volumes',-1,'2025-12-03 10:13:15',NULL),('2025-12-02 10:13:15','2025-12-02 10:13:16','2025-12-02 10:13:16',1,598,'fb23ed04-3f60-4e74-a466-99232564047a',133,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes',-1,'2025-12-03 10:13:15',NULL),('2025-12-02 10:13:15','2025-12-02 10:13:16','2025-12-02 10:13:16',1,599,'bc395c70-b866-4c78-b120-35abd7feb63d',134,'b374ce45b6dc4bc5b2eac77a9216133f','volumes_tripleo',-1,'2025-12-03 10:13:15',NULL),('2025-12-02 10:13:15','2025-12-02 10:13:16','2025-12-02 10:13:16',1,600,'691471bf-4a1a-44ed-a90c-f89db7eeb73c',135,'b374ce45b6dc4bc5b2eac77a9216133f','gigabytes_tripleo',-1,'2025-12-03 10:13:15',NULL),('2025-12-02 10:13:17','2025-12-02 10:13:17','2025-12-02 10:13:17',1,601,'63fad510-b426-4bb8-8f5e-c3b64a56f7bb',154,'8ff22a276ec5464e8a97c8b3b0e8806c','groups',-1,'2025-12-03 10:13:17',NULL),('2025-12-02 10:13:17','2025-12-02 10:13:17','2025-12-02 10:13:17',1,602,'5ceb8740-06e7-4530-a5c0-c7b897405065',155,'8ff22a276ec5464e8a97c8b3b0e8806c','volumes',-1,'2025-12-03 10:13:17',NULL),('2025-12-02 10:13:17','2025-12-02 10:13:17','2025-12-02 10:13:17',1,603,'0508cc07-5c5c-4aff-a061-a99a405d7ccc',156,'8ff22a276ec5464e8a97c8b3b0e8806c','gigabytes',-1,'2025-12-03 10:13:17',NULL),('2025-12-02 10:13:17','2025-12-02 10:13:17','2025-12-02 10:13:17',1,604,'f367a100-e25e-4455-a4ec-d03764291383',157,'8ff22a276ec5464e8a97c8b3b0e8806c','volumes_tempest-GroupsTest-volume-type-1153924094',-1,'2025-12-03 10:13:17',NULL),('2025-12-02 10:13:17','2025-12-02 10:13:17','2025-12-02 10:13:17',1,605,'be13f454-262e-4a98-89e7-5eaaa1928fab',158,'8ff22a276ec5464e8a97c8b3b0e8806c','gigabytes_tempest-GroupsTest-volume-type-1153924094',-1,'2025-12-03 10:13:17',NULL),('2025-12-02 10:13:18','2025-12-02 10:13:18','2025-12-02 10:13:18',1,606,'ff407acb-daa9-46b3-8b10-8a0fdc41a9c9',154,'8ff22a276ec5464e8a97c8b3b0e8806c','groups',-1,'2025-12-03 10:13:18',NULL),('2025-12-02 10:13:19','2025-12-02 10:13:19','2025-12-02 10:13:19',1,607,'a349b308-2a69-46d0-8662-c8c277386366',154,'8ff22a276ec5464e8a97c8b3b0e8806c','groups',1,'2025-12-03 10:13:19',NULL),('2025-12-02 10:13:20','2025-12-02 10:13:20','2025-12-02 10:13:20',1,608,'a3a1b641-a859-466a-a31b-9202bbab9e86',155,'8ff22a276ec5464e8a97c8b3b0e8806c','volumes',1,'2025-12-03 10:13:20',NULL),('2025-12-02 10:13:20','2025-12-02 10:13:20','2025-12-02 10:13:20',1,609,'daecaa6d-601f-41a4-b14b-2da40916ca18',156,'8ff22a276ec5464e8a97c8b3b0e8806c','gigabytes',1,'2025-12-03 10:13:20',NULL),('2025-12-02 10:13:20','2025-12-02 10:13:20','2025-12-02 10:13:20',1,610,'de4b5027-d35f-43c2-adc8-d25c0deffa18',159,'8ff22a276ec5464e8a97c8b3b0e8806c','volumes_tempest-GroupsTest-volume-type-1060610990',1,'2025-12-03 10:13:20',NULL),('2025-12-02 10:13:20','2025-12-02 10:13:20','2025-12-02 10:13:20',1,611,'c52b92e8-9930-4ab5-b691-b14fe54677de',160,'8ff22a276ec5464e8a97c8b3b0e8806c','gigabytes_tempest-GroupsTest-volume-type-1060610990',1,'2025-12-03 10:13:20',NULL),('2025-12-02 10:13:22','2025-12-02 10:13:22','2025-12-02 10:13:22',1,612,'48e1d5bb-1699-4521-84c3-88bf8c8b8a4f',155,'8ff22a276ec5464e8a97c8b3b0e8806c','volumes',1,'2025-12-03 10:13:22',NULL),('2025-12-02 10:13:22','2025-12-02 10:13:22','2025-12-02 10:13:22',1,613,'e18c9e3f-448b-4279-8503-acbade9d632f',156,'8ff22a276ec5464e8a97c8b3b0e8806c','gigabytes',1,'2025-12-03 10:13:22',NULL),('2025-12-02 10:13:22','2025-12-02 10:13:22','2025-12-02 10:13:22',1,614,'723ba480-59b6-4662-a7f6-1f130b11dbaa',159,'8ff22a276ec5464e8a97c8b3b0e8806c','volumes_tempest-GroupsTest-volume-type-1060610990',1,'2025-12-03 10:13:22',NULL),('2025-12-02 10:13:22','2025-12-02 10:13:22','2025-12-02 10:13:22',1,615,'8c136deb-245b-4eab-bd28-f600276026e0',160,'8ff22a276ec5464e8a97c8b3b0e8806c','gigabytes_tempest-GroupsTest-volume-type-1060610990',1,'2025-12-03 10:13:22',NULL),('2025-12-02 10:13:27','2025-12-02 10:13:27','2025-12-02 10:13:27',1,616,'5a209a30-1f27-48f8-ae2a-d7a291179388',154,'8ff22a276ec5464e8a97c8b3b0e8806c','groups',-1,'2025-12-03 10:13:27',NULL),('2025-12-02 10:13:27','2025-12-02 10:13:27','2025-12-02 10:13:27',1,617,'998150da-5378-4d5b-ac25-73af70dc7be9',155,'8ff22a276ec5464e8a97c8b3b0e8806c','volumes',-1,'2025-12-03 10:13:27',NULL),('2025-12-02 10:13:27','2025-12-02 10:13:27','2025-12-02 10:13:27',1,618,'8d1383ca-f99f-42db-b05f-b4d3afab9e29',156,'8ff22a276ec5464e8a97c8b3b0e8806c','gigabytes',-1,'2025-12-03 10:13:27',NULL),('2025-12-02 10:13:27','2025-12-02 10:13:27','2025-12-02 10:13:27',1,619,'f7cc11ad-21a9-4b25-9d26-c36ff0a60e54',159,'8ff22a276ec5464e8a97c8b3b0e8806c','volumes_tempest-GroupsTest-volume-type-1060610990',-1,'2025-12-03 10:13:27',NULL),('2025-12-02 10:13:27','2025-12-02 10:13:27','2025-12-02 10:13:27',1,620,'a8e1c006-a781-42a3-9a29-11a975c543b2',160,'8ff22a276ec5464e8a97c8b3b0e8806c','gigabytes_tempest-GroupsTest-volume-type-1060610990',-1,'2025-12-03 10:13:27',NULL),('2025-12-02 10:13:27','2025-12-02 10:13:27','2025-12-02 10:13:27',1,621,'c2e25d0e-95f4-4492-9143-1e4250cef4c2',155,'8ff22a276ec5464e8a97c8b3b0e8806c','volumes',-1,'2025-12-03 10:13:27',NULL),('2025-12-02 10:13:27','2025-12-02 10:13:27','2025-12-02 10:13:27',1,622,'e65d5f1b-4a2d-46b3-a97a-db0431e12cca',156,'8ff22a276ec5464e8a97c8b3b0e8806c','gigabytes',-1,'2025-12-03 10:13:27',NULL),('2025-12-02 10:13:27','2025-12-02 10:13:27','2025-12-02 10:13:27',1,623,'9246318a-6459-4a86-8b93-b9190fd04cad',159,'8ff22a276ec5464e8a97c8b3b0e8806c','volumes_tempest-GroupsTest-volume-type-1060610990',-1,'2025-12-03 10:13:27',NULL),('2025-12-02 10:13:27','2025-12-02 10:13:27','2025-12-02 10:13:27',1,624,'a23df079-8e41-4169-b1ab-c01ae291c6c6',160,'8ff22a276ec5464e8a97c8b3b0e8806c','gigabytes_tempest-GroupsTest-volume-type-1060610990',-1,'2025-12-03 10:13:27',NULL),('2025-12-02 10:13:36','2025-12-02 10:13:36','2025-12-02 10:13:36',1,625,'242afe8f-c954-452b-908e-74c649e729c2',161,'f01f26d352434e1898ddc5651f0257ce','volumes',1,'2025-12-03 10:13:36',NULL),('2025-12-02 10:13:36','2025-12-02 10:13:36','2025-12-02 10:13:36',1,626,'a5b2f944-81fb-4714-8341-361274b4c296',162,'f01f26d352434e1898ddc5651f0257ce','gigabytes',1,'2025-12-03 10:13:36',NULL),('2025-12-02 10:13:36','2025-12-02 10:13:36','2025-12-02 10:13:36',1,627,'51148577-2788-4b43-a36a-348f9432b5dd',163,'f01f26d352434e1898ddc5651f0257ce','volumes_tripleo',1,'2025-12-03 10:13:36',NULL),('2025-12-02 10:13:36','2025-12-02 10:13:36','2025-12-02 10:13:36',1,628,'b80d309e-d8fd-4629-830d-1b16c73244fd',164,'f01f26d352434e1898ddc5651f0257ce','gigabytes_tripleo',1,'2025-12-03 10:13:36',NULL),('2025-12-02 10:13:38','2025-12-02 10:13:38','2025-12-02 10:13:38',1,629,'9d1fb7a1-b97c-4ea1-8aec-0b72229d673a',161,'f01f26d352434e1898ddc5651f0257ce','volumes',-1,'2025-12-03 10:13:38',NULL),('2025-12-02 10:13:38','2025-12-02 10:13:38','2025-12-02 10:13:38',1,630,'cc92fb6f-abcb-49dc-9964-60e32a82b20d',162,'f01f26d352434e1898ddc5651f0257ce','gigabytes',-1,'2025-12-03 10:13:38',NULL),('2025-12-02 10:13:38','2025-12-02 10:13:38','2025-12-02 10:13:38',1,631,'3fbd670b-cd09-4792-8ca8-41bdd07e94a7',163,'f01f26d352434e1898ddc5651f0257ce','volumes_tripleo',-1,'2025-12-03 10:13:38',NULL),('2025-12-02 10:13:38','2025-12-02 10:13:38','2025-12-02 10:13:38',1,632,'65d713cd-8f41-4fb6-af09-d927f5da47d7',164,'f01f26d352434e1898ddc5651f0257ce','gigabytes_tripleo',-1,'2025-12-03 10:13:38',NULL),('2025-12-02 10:13:45','2025-12-02 10:13:45','2025-12-02 10:13:45',1,633,'2bdc786a-9987-4b49-ad28-d232045041a3',165,'08ec4508e51e4b46972baa016cc404c1','volumes',1,'2025-12-03 10:13:45',NULL),('2025-12-02 10:13:45','2025-12-02 10:13:45','2025-12-02 10:13:45',1,634,'8ad227ae-555b-44a4-a67d-da4a9eb3ad23',166,'08ec4508e51e4b46972baa016cc404c1','gigabytes',1,'2025-12-03 10:13:45',NULL),('2025-12-02 10:13:45','2025-12-02 10:13:45','2025-12-02 10:13:45',1,635,'e9949a3f-7452-4b63-a768-5767315c2e88',167,'08ec4508e51e4b46972baa016cc404c1','volumes_tripleo',1,'2025-12-03 10:13:45',NULL),('2025-12-02 10:13:45','2025-12-02 10:13:45','2025-12-02 10:13:45',1,636,'ee0e7811-7eb8-47c1-8df8-0f60b449db98',168,'08ec4508e51e4b46972baa016cc404c1','gigabytes_tripleo',1,'2025-12-03 10:13:45',NULL),('2025-12-02 10:13:46','2025-12-02 10:13:46','2025-12-02 10:13:46',1,637,'a5a05ae7-5a08-4e8f-affd-d69febb8d992',169,'1259cb721f554d769bcd146b925c03fd','volumes',1,'2025-12-03 10:13:46',NULL),('2025-12-02 10:13:46','2025-12-02 10:13:46','2025-12-02 10:13:46',1,638,'29629a68-58b4-4359-9e3a-88c393be93b3',170,'1259cb721f554d769bcd146b925c03fd','gigabytes',1,'2025-12-03 10:13:46',NULL),('2025-12-02 10:13:46','2025-12-02 10:13:46','2025-12-02 10:13:46',1,639,'13520179-c54a-4fd8-846e-8a31bf8b2ce3',171,'1259cb721f554d769bcd146b925c03fd','volumes_tripleo',1,'2025-12-03 10:13:46',NULL),('2025-12-02 10:13:46','2025-12-02 10:13:46','2025-12-02 10:13:46',1,640,'8f762b1e-6189-45a2-b3ea-0b432c27d947',172,'1259cb721f554d769bcd146b925c03fd','gigabytes_tripleo',1,'2025-12-03 10:13:46',NULL),('2025-12-02 10:13:46','2025-12-02 10:13:46','2025-12-02 10:13:46',1,641,'1e0c0136-0321-402b-8930-a2b8cd1c40e1',165,'08ec4508e51e4b46972baa016cc404c1','volumes',-1,'2025-12-03 10:13:46',NULL),('2025-12-02 10:13:46','2025-12-02 10:13:46','2025-12-02 10:13:46',1,642,'d0074651-2ef6-4380-a3cc-955b5e6815d4',166,'08ec4508e51e4b46972baa016cc404c1','gigabytes',-1,'2025-12-03 10:13:46',NULL),('2025-12-02 10:13:46','2025-12-02 10:13:46','2025-12-02 10:13:46',1,643,'65c41fd9-9372-404c-ad2f-96855b2b170a',167,'08ec4508e51e4b46972baa016cc404c1','volumes_tripleo',-1,'2025-12-03 10:13:46',NULL),('2025-12-02 10:13:46','2025-12-02 10:13:46','2025-12-02 10:13:46',1,644,'08076bf8-704d-4da0-8d53-82fd7b79cba1',168,'08ec4508e51e4b46972baa016cc404c1','gigabytes_tripleo',-1,'2025-12-03 10:13:46',NULL),('2025-12-02 10:13:46','2025-12-02 10:13:46','2025-12-02 10:13:46',1,645,'0438e2f5-fbff-4eb5-a2e2-6b6be97a538d',173,'1259cb721f554d769bcd146b925c03fd','snapshots',0,'2025-12-03 10:13:46',NULL),('2025-12-02 10:13:46','2025-12-02 10:13:46','2025-12-02 10:13:46',1,646,'e71de9a2-596e-41e8-a59a-1f4e1006bb76',170,'1259cb721f554d769bcd146b925c03fd','gigabytes',0,'2025-12-03 10:13:46',NULL),('2025-12-02 10:13:46','2025-12-02 10:13:46','2025-12-02 10:13:46',1,647,'1650dc77-4bc0-48ef-a705-812d2e3e2b2a',172,'1259cb721f554d769bcd146b925c03fd','gigabytes_tripleo',0,'2025-12-03 10:13:46',NULL),('2025-12-02 10:13:46','2025-12-02 10:13:46','2025-12-02 10:13:46',1,648,'1a882c12-d573-4dee-b35c-858ea1ba45e2',174,'1259cb721f554d769bcd146b925c03fd','snapshots_tripleo',0,'2025-12-03 10:13:46',NULL),('2025-12-02 10:13:46','2025-12-02 10:13:46','2025-12-02 10:13:46',1,649,'e792752a-293c-429c-81b7-3a90537dddf6',175,'08ec4508e51e4b46972baa016cc404c1','snapshots',0,'2025-12-03 10:13:46',NULL),('2025-12-02 10:13:46','2025-12-02 10:13:46','2025-12-02 10:13:46',1,650,'9226bba4-0417-4e7a-bda1-b32150997357',166,'08ec4508e51e4b46972baa016cc404c1','gigabytes',0,'2025-12-03 10:13:46',NULL),('2025-12-02 10:13:46','2025-12-02 10:13:46','2025-12-02 10:13:46',1,651,'0731fd3c-4b6f-42f5-86c2-bd9456041ffc',168,'08ec4508e51e4b46972baa016cc404c1','gigabytes_tripleo',0,'2025-12-03 10:13:46',NULL),('2025-12-02 10:13:46','2025-12-02 10:13:46','2025-12-02 10:13:46',1,652,'86fcd29f-0249-4da8-bd14-9ae0a2efed96',176,'08ec4508e51e4b46972baa016cc404c1','snapshots_tripleo',0,'2025-12-03 10:13:46',NULL),('2025-12-02 10:13:47','2025-12-02 10:13:47','2025-12-02 10:13:47',1,653,'997ba4c5-6db5-42db-9526-5d85fc9c52d1',177,'69ac27088e5c47cabe1441ecc9b19c84','groups',1,'2025-12-03 10:13:47',NULL),('2025-12-02 10:13:47','2025-12-02 10:13:47','2025-12-02 10:13:47',1,654,'f826eb6d-eb6b-4ae4-8a48-db4518e1745b',178,'58b8f029a1134a12a75f33bc584b83dd','volumes',1,'2025-12-03 10:13:47',NULL),('2025-12-02 10:13:47','2025-12-02 10:13:47','2025-12-02 10:13:47',1,655,'9088beeb-3372-44d2-a466-e4573331c98b',179,'58b8f029a1134a12a75f33bc584b83dd','gigabytes',1,'2025-12-03 10:13:47',NULL),('2025-12-02 10:13:47','2025-12-02 10:13:47','2025-12-02 10:13:47',1,656,'31c43c33-ac26-4841-9806-a510d6bbbe59',180,'58b8f029a1134a12a75f33bc584b83dd','volumes_tripleo',1,'2025-12-03 10:13:47',NULL),('2025-12-02 10:13:47','2025-12-02 10:13:47','2025-12-02 10:13:47',1,657,'fab76bcd-f5f1-4ae3-800d-6f456e50ea31',181,'58b8f029a1134a12a75f33bc584b83dd','gigabytes_tripleo',1,'2025-12-03 10:13:47',NULL),('2025-12-02 10:13:47','2025-12-02 10:13:47','2025-12-02 10:13:47',1,658,'e9db794e-4e50-4e2c-8dbc-fd21abc09e3f',169,'1259cb721f554d769bcd146b925c03fd','volumes',-1,'2025-12-03 10:13:47',NULL),('2025-12-02 10:13:47','2025-12-02 10:13:47','2025-12-02 10:13:47',1,659,'cb5f264a-6781-4bb8-9816-e22a875b5484',170,'1259cb721f554d769bcd146b925c03fd','gigabytes',-1,'2025-12-03 10:13:47',NULL),('2025-12-02 10:13:47','2025-12-02 10:13:47','2025-12-02 10:13:47',1,660,'37fe473c-e8b5-4e41-821d-edc2388ab3cd',171,'1259cb721f554d769bcd146b925c03fd','volumes_tripleo',-1,'2025-12-03 10:13:47',NULL),('2025-12-02 10:13:47','2025-12-02 10:13:47','2025-12-02 10:13:47',1,661,'79044c35-e7a7-459a-bf4c-df6f1b0e67b5',172,'1259cb721f554d769bcd146b925c03fd','gigabytes_tripleo',-1,'2025-12-03 10:13:47',NULL),('2025-12-02 10:13:48','2025-12-02 10:13:48','2025-12-02 10:13:48',1,662,'34380bd2-4205-4e1a-8823-b4ab74a522e3',165,'08ec4508e51e4b46972baa016cc404c1','volumes',1,'2025-12-03 10:13:48',NULL),('2025-12-02 10:13:48','2025-12-02 10:13:48','2025-12-02 10:13:48',1,663,'0a0a90f0-06a2-4607-9135-729a5ff7ce50',166,'08ec4508e51e4b46972baa016cc404c1','gigabytes',1,'2025-12-03 10:13:48',NULL),('2025-12-02 10:13:48','2025-12-02 10:13:48','2025-12-02 10:13:48',1,664,'2ec8db0d-baa2-4781-a9aa-b355f596c24d',167,'08ec4508e51e4b46972baa016cc404c1','volumes_tripleo',1,'2025-12-03 10:13:48',NULL),('2025-12-02 10:13:48','2025-12-02 10:13:48','2025-12-02 10:13:48',1,665,'461a344e-3e96-4d32-989b-ffc0266fc369',168,'08ec4508e51e4b46972baa016cc404c1','gigabytes_tripleo',1,'2025-12-03 10:13:48',NULL),('2025-12-02 10:13:48','2025-12-02 10:13:48','2025-12-02 10:13:48',1,666,'c788afd5-a09f-40b8-b055-bd706dc1ff08',182,'69ac27088e5c47cabe1441ecc9b19c84','volumes',1,'2025-12-03 10:13:48',NULL),('2025-12-02 10:13:48','2025-12-02 10:13:48','2025-12-02 10:13:48',1,667,'f8a23d70-0e4f-4134-b0bc-793fa306987a',183,'69ac27088e5c47cabe1441ecc9b19c84','gigabytes',1,'2025-12-03 10:13:48',NULL),('2025-12-02 10:13:48','2025-12-02 10:13:48','2025-12-02 10:13:48',1,668,'501f09e7-49a8-43d9-ab7b-032c69b9e7ad',184,'69ac27088e5c47cabe1441ecc9b19c84','volumes_tempest-GroupsV314Test-volume-type-197107638',1,'2025-12-03 10:13:48',NULL),('2025-12-02 10:13:48','2025-12-02 10:13:48','2025-12-02 10:13:48',1,669,'1a5883c1-6a83-4f98-be19-925dff777ba6',185,'69ac27088e5c47cabe1441ecc9b19c84','gigabytes_tempest-GroupsV314Test-volume-type-197107638',1,'2025-12-03 10:13:48',NULL),('2025-12-02 10:13:49','2025-12-02 10:13:50','2025-12-02 10:13:50',1,670,'1e7c1262-47c2-4a39-8145-8e54617d19c0',177,'69ac27088e5c47cabe1441ecc9b19c84','groups',1,'2025-12-03 10:13:49',NULL),('2025-12-02 10:13:50','2025-12-02 10:13:50','2025-12-02 10:13:50',1,671,'33bfcfbe-80f2-4577-9f65-f9c2829894a4',178,'58b8f029a1134a12a75f33bc584b83dd','volumes',-1,'2025-12-03 10:13:50',NULL),('2025-12-02 10:13:50','2025-12-02 10:13:50','2025-12-02 10:13:50',1,672,'3653acbc-a30f-4866-9b89-b88285843d1e',179,'58b8f029a1134a12a75f33bc584b83dd','gigabytes',-1,'2025-12-03 10:13:50',NULL),('2025-12-02 10:13:50','2025-12-02 10:13:50','2025-12-02 10:13:50',1,673,'4f82d9d6-ce62-484b-b156-cc57d6f6de54',180,'58b8f029a1134a12a75f33bc584b83dd','volumes_tripleo',-1,'2025-12-03 10:13:50',NULL),('2025-12-02 10:13:50','2025-12-02 10:13:50','2025-12-02 10:13:50',1,674,'c8f6ddf5-ea68-41b6-9099-42f5c07f3594',181,'58b8f029a1134a12a75f33bc584b83dd','gigabytes_tripleo',-1,'2025-12-03 10:13:50',NULL),('2025-12-02 10:13:51','2025-12-02 10:13:51','2025-12-02 10:13:51',1,675,'f6310400-3f1e-475f-8abc-b83b9c2eb269',182,'69ac27088e5c47cabe1441ecc9b19c84','volumes',1,'2025-12-03 10:13:51',NULL),('2025-12-02 10:13:51','2025-12-02 10:13:51','2025-12-02 10:13:51',1,676,'935859bc-3d29-49e0-ab9d-0100e8fafb4b',183,'69ac27088e5c47cabe1441ecc9b19c84','gigabytes',1,'2025-12-03 10:13:51',NULL),('2025-12-02 10:13:51','2025-12-02 10:13:51','2025-12-02 10:13:51',1,677,'51f3065b-842c-467a-ad04-3688f67b2b2c',184,'69ac27088e5c47cabe1441ecc9b19c84','volumes_tempest-GroupsV314Test-volume-type-197107638',1,'2025-12-03 10:13:51',NULL),('2025-12-02 10:13:51','2025-12-02 10:13:51','2025-12-02 10:13:51',1,678,'9b930892-a203-4430-b721-d6e5860a94dd',185,'69ac27088e5c47cabe1441ecc9b19c84','gigabytes_tempest-GroupsV314Test-volume-type-197107638',1,'2025-12-03 10:13:51',NULL),('2025-12-02 10:13:51','2025-12-02 10:13:51','2025-12-02 10:13:51',1,679,'b42cdf9b-add3-4039-8a35-e224bed1254b',165,'08ec4508e51e4b46972baa016cc404c1','volumes',-1,'2025-12-03 10:13:51',NULL),('2025-12-02 10:13:51','2025-12-02 10:13:51','2025-12-02 10:13:51',1,680,'6242b926-c2a9-49d9-b7c0-dc3e56c7450a',166,'08ec4508e51e4b46972baa016cc404c1','gigabytes',-1,'2025-12-03 10:13:51',NULL),('2025-12-02 10:13:51','2025-12-02 10:13:51','2025-12-02 10:13:51',1,681,'c1b3b9d3-31f2-4582-b605-f9bb3bc47c94',167,'08ec4508e51e4b46972baa016cc404c1','volumes_tripleo',-1,'2025-12-03 10:13:51',NULL),('2025-12-02 10:13:51','2025-12-02 10:13:51','2025-12-02 10:13:51',1,682,'372839a4-eb13-42c2-8279-9470f2ca277a',168,'08ec4508e51e4b46972baa016cc404c1','gigabytes_tripleo',-1,'2025-12-03 10:13:51',NULL),('2025-12-02 10:13:53','2025-12-02 10:13:53','2025-12-02 10:13:53',1,683,'5d34f67b-6abe-4415-9479-84aaabc4608c',177,'69ac27088e5c47cabe1441ecc9b19c84','groups',-1,'2025-12-03 10:13:53',NULL),('2025-12-02 10:13:53','2025-12-02 10:13:53','2025-12-02 10:13:53',1,684,'37c75ffd-3c90-464a-b801-ffb1a0bd5410',182,'69ac27088e5c47cabe1441ecc9b19c84','volumes',-1,'2025-12-03 10:13:53',NULL),('2025-12-02 10:13:53','2025-12-02 10:13:53','2025-12-02 10:13:53',1,685,'5194e614-00ee-4be3-b974-008ca27332d2',183,'69ac27088e5c47cabe1441ecc9b19c84','gigabytes',-1,'2025-12-03 10:13:53',NULL),('2025-12-02 10:13:53','2025-12-02 10:13:53','2025-12-02 10:13:53',1,686,'adca5788-d832-4e91-be96-0de7bfccfbd3',184,'69ac27088e5c47cabe1441ecc9b19c84','volumes_tempest-GroupsV314Test-volume-type-197107638',-1,'2025-12-03 10:13:53',NULL),('2025-12-02 10:13:53','2025-12-02 10:13:53','2025-12-02 10:13:53',1,687,'d388ddbb-7a5c-440a-86a0-590175312339',185,'69ac27088e5c47cabe1441ecc9b19c84','gigabytes_tempest-GroupsV314Test-volume-type-197107638',-1,'2025-12-03 10:13:53',NULL),('2025-12-02 10:13:54','2025-12-02 10:13:54','2025-12-02 10:13:54',1,688,'393f631d-48ee-4324-84d3-5d37eee11024',177,'69ac27088e5c47cabe1441ecc9b19c84','groups',-1,'2025-12-03 10:13:54',NULL),('2025-12-02 10:13:54','2025-12-02 10:13:54','2025-12-02 10:13:54',1,689,'06a82a04-51a8-44a4-9381-bd0671ddc29d',182,'69ac27088e5c47cabe1441ecc9b19c84','volumes',-1,'2025-12-03 10:13:54',NULL),('2025-12-02 10:13:54','2025-12-02 10:13:54','2025-12-02 10:13:54',1,690,'40276dbe-3100-4254-abf1-5e74bf6e8ac2',183,'69ac27088e5c47cabe1441ecc9b19c84','gigabytes',-1,'2025-12-03 10:13:54',NULL),('2025-12-02 10:13:54','2025-12-02 10:13:54','2025-12-02 10:13:54',1,691,'6f11a973-747a-4a13-b9e2-89676ec2afb6',184,'69ac27088e5c47cabe1441ecc9b19c84','volumes_tempest-GroupsV314Test-volume-type-197107638',-1,'2025-12-03 10:13:54',NULL),('2025-12-02 10:13:54','2025-12-02 10:13:54','2025-12-02 10:13:54',1,692,'a4f073be-df06-4733-9721-c789a8ff41f5',185,'69ac27088e5c47cabe1441ecc9b19c84','gigabytes_tempest-GroupsV314Test-volume-type-197107638',-1,'2025-12-03 10:13:54',NULL),('2025-12-02 10:13:54','2025-12-02 10:13:54','2025-12-02 10:13:54',1,693,'0be383b6-74c6-40dd-88a4-5bf5835818e8',186,'59618d0a71be4bd7b90941ee9db2762c','volumes',1,'2025-12-03 10:13:54',NULL),('2025-12-02 10:13:54','2025-12-02 10:13:54','2025-12-02 10:13:54',1,694,'3c0202b8-1e56-446a-a4cc-3336844760bd',187,'59618d0a71be4bd7b90941ee9db2762c','gigabytes',1,'2025-12-03 10:13:54',NULL),('2025-12-02 10:13:54','2025-12-02 10:13:54','2025-12-02 10:13:54',1,695,'769d5e95-99c7-47f7-9425-73aca7b20d52',188,'59618d0a71be4bd7b90941ee9db2762c','volumes_tripleo',1,'2025-12-03 10:13:54',NULL),('2025-12-02 10:13:54','2025-12-02 10:13:54','2025-12-02 10:13:54',1,696,'492f7bf2-38b0-420b-a711-f80ed9670a5a',189,'59618d0a71be4bd7b90941ee9db2762c','gigabytes_tripleo',1,'2025-12-03 10:13:54',NULL),('2025-12-02 10:13:55','2025-12-02 10:13:55','2025-12-02 10:13:55',1,697,'c0d21d06-a407-417e-bdac-4ab845418de3',186,'59618d0a71be4bd7b90941ee9db2762c','volumes',1,'2025-12-03 10:13:55',NULL),('2025-12-02 10:13:55','2025-12-02 10:13:55','2025-12-02 10:13:55',1,698,'f9881e39-ea75-47c3-a974-01c693f11359',187,'59618d0a71be4bd7b90941ee9db2762c','gigabytes',1,'2025-12-03 10:13:55',NULL),('2025-12-02 10:13:55','2025-12-02 10:13:55','2025-12-02 10:13:55',1,699,'42075a72-a5db-44f7-b3fb-6bd7af4e1742',188,'59618d0a71be4bd7b90941ee9db2762c','volumes_tripleo',1,'2025-12-03 10:13:55',NULL),('2025-12-02 10:13:55','2025-12-02 10:13:55','2025-12-02 10:13:55',1,700,'ca77c76e-5e25-47d7-aeca-312002693f6c',189,'59618d0a71be4bd7b90941ee9db2762c','gigabytes_tripleo',1,'2025-12-03 10:13:55',NULL),('2025-12-02 10:13:56','2025-12-02 10:13:56','2025-12-02 10:13:56',1,701,'2be423e4-3e99-4d25-b4c5-4e051e42488f',190,'82445c1a56474ba497d07340322dbade','volumes',1,'2025-12-03 10:13:56',NULL),('2025-12-02 10:13:56','2025-12-02 10:13:56','2025-12-02 10:13:56',1,702,'44eacb83-d88b-42fa-96f6-c3261888082a',191,'82445c1a56474ba497d07340322dbade','gigabytes',1,'2025-12-03 10:13:56',NULL),('2025-12-02 10:13:56','2025-12-02 10:13:56','2025-12-02 10:13:56',1,703,'337f1b23-f739-49bd-b485-0683877ca139',192,'82445c1a56474ba497d07340322dbade','volumes_tripleo',1,'2025-12-03 10:13:56',NULL),('2025-12-02 10:13:56','2025-12-02 10:13:56','2025-12-02 10:13:56',1,704,'8d3da71a-8530-45a5-9793-e29c43aae699',193,'82445c1a56474ba497d07340322dbade','gigabytes_tripleo',1,'2025-12-03 10:13:56',NULL),('2025-12-02 10:13:57','2025-12-02 10:13:57','2025-12-02 10:13:57',1,705,'54974fda-6c3b-45dc-9b81-4dc0a0bfcc75',186,'59618d0a71be4bd7b90941ee9db2762c','volumes',1,'2025-12-03 10:13:57',NULL),('2025-12-02 10:13:57','2025-12-02 10:13:57','2025-12-02 10:13:57',1,706,'a71c3bf2-f0c3-46d1-a8df-1df55f0d162a',187,'59618d0a71be4bd7b90941ee9db2762c','gigabytes',1,'2025-12-03 10:13:57',NULL),('2025-12-02 10:13:57','2025-12-02 10:13:57','2025-12-02 10:13:57',1,707,'537a5372-5d26-44e0-a58b-bb229e71d50d',188,'59618d0a71be4bd7b90941ee9db2762c','volumes_tripleo',1,'2025-12-03 10:13:57',NULL),('2025-12-02 10:13:57','2025-12-02 10:13:57','2025-12-02 10:13:57',1,708,'5ed020ba-af78-4af9-9704-a16c0d63eb35',189,'59618d0a71be4bd7b90941ee9db2762c','gigabytes_tripleo',1,'2025-12-03 10:13:57',NULL),('2025-12-02 10:13:58','2025-12-02 10:13:58','2025-12-02 10:13:58',1,709,'cd9b5393-4f7f-4332-9691-2f1e37d3fe20',190,'82445c1a56474ba497d07340322dbade','volumes',1,'2025-12-03 10:13:58',NULL),('2025-12-02 10:13:58','2025-12-02 10:13:58','2025-12-02 10:13:58',1,710,'beeccf2e-c805-453c-8877-4704b7fab83c',191,'82445c1a56474ba497d07340322dbade','gigabytes',1,'2025-12-03 10:13:58',NULL),('2025-12-02 10:13:58','2025-12-02 10:13:58','2025-12-02 10:13:58',1,711,'2714179d-3846-4d3e-a7e9-7e15a2b08cad',192,'82445c1a56474ba497d07340322dbade','volumes_tripleo',1,'2025-12-03 10:13:58',NULL),('2025-12-02 10:13:58','2025-12-02 10:13:58','2025-12-02 10:13:58',1,712,'efd8157e-53e7-4bf5-9164-998510c0bce9',193,'82445c1a56474ba497d07340322dbade','gigabytes_tripleo',1,'2025-12-03 10:13:58',NULL),('2025-12-02 10:14:00','2025-12-02 10:14:00','2025-12-02 10:14:00',1,713,'d0772b09-f1d8-4635-b0b9-3de443d7b0b1',190,'82445c1a56474ba497d07340322dbade','volumes',-1,'2025-12-03 10:14:00',NULL),('2025-12-02 10:14:00','2025-12-02 10:14:00','2025-12-02 10:14:00',1,714,'99e5296e-62c9-4666-8be3-202e6e21b0aa',191,'82445c1a56474ba497d07340322dbade','gigabytes',-1,'2025-12-03 10:14:00',NULL),('2025-12-02 10:14:00','2025-12-02 10:14:00','2025-12-02 10:14:00',1,715,'dae74cfe-27bf-451b-81e4-362b262569ef',192,'82445c1a56474ba497d07340322dbade','volumes_tripleo',-1,'2025-12-03 10:14:00',NULL),('2025-12-02 10:14:00','2025-12-02 10:14:00','2025-12-02 10:14:00',1,716,'4aca63c3-fc2f-48f3-9535-00c3c7c5c5bc',193,'82445c1a56474ba497d07340322dbade','gigabytes_tripleo',-1,'2025-12-03 10:14:00',NULL),('2025-12-02 10:14:00','2025-12-02 10:14:00','2025-12-02 10:14:00',1,717,'3a47fb94-eed0-41b2-8798-a0bfaf45df5a',186,'59618d0a71be4bd7b90941ee9db2762c','volumes',-1,'2025-12-03 10:14:00',NULL),('2025-12-02 10:14:00','2025-12-02 10:14:00','2025-12-02 10:14:00',1,718,'c74ea7e1-5eb9-42a3-9e3b-4af15b20f553',187,'59618d0a71be4bd7b90941ee9db2762c','gigabytes',-1,'2025-12-03 10:14:00',NULL),('2025-12-02 10:14:00','2025-12-02 10:14:00','2025-12-02 10:14:00',1,719,'b0c348aa-7d6d-49d0-af4d-8e9e1f6d5e05',188,'59618d0a71be4bd7b90941ee9db2762c','volumes_tripleo',-1,'2025-12-03 10:14:00',NULL),('2025-12-02 10:14:00','2025-12-02 10:14:00','2025-12-02 10:14:00',1,720,'d973b3b3-7b21-48ad-bc85-bd0e9c78a206',189,'59618d0a71be4bd7b90941ee9db2762c','gigabytes_tripleo',-1,'2025-12-03 10:14:00',NULL),('2025-12-02 10:14:01','2025-12-02 10:14:01','2025-12-02 10:14:01',1,721,'f33362da-8902-4227-913b-ca2edef3617c',190,'82445c1a56474ba497d07340322dbade','volumes',-1,'2025-12-03 10:14:01',NULL),('2025-12-02 10:14:01','2025-12-02 10:14:01','2025-12-02 10:14:01',1,722,'1b7d596c-942c-449a-ac6e-5fd104fbb960',191,'82445c1a56474ba497d07340322dbade','gigabytes',-1,'2025-12-03 10:14:01',NULL),('2025-12-02 10:14:01','2025-12-02 10:14:01','2025-12-02 10:14:01',1,723,'c6a3cf61-36b0-4ec8-9abe-f148fa7b67cb',192,'82445c1a56474ba497d07340322dbade','volumes_tripleo',-1,'2025-12-03 10:14:01',NULL),('2025-12-02 10:14:01','2025-12-02 10:14:01','2025-12-02 10:14:01',1,724,'79bd0dbc-5f7a-46a2-90b0-33103e8f9856',193,'82445c1a56474ba497d07340322dbade','gigabytes_tripleo',-1,'2025-12-03 10:14:01',NULL),('2025-12-02 10:14:01','2025-12-02 10:14:01','2025-12-02 10:14:01',1,725,'5ded1134-ce62-4601-9904-8fe901cff23b',190,'82445c1a56474ba497d07340322dbade','volumes',1,'2025-12-03 10:14:01',NULL),('2025-12-02 10:14:01','2025-12-02 10:14:01','2025-12-02 10:14:01',1,726,'9831a7ff-1017-46c9-acb9-7c02ca933729',191,'82445c1a56474ba497d07340322dbade','gigabytes',1,'2025-12-03 10:14:01',NULL),('2025-12-02 10:14:01','2025-12-02 10:14:01','2025-12-02 10:14:01',1,727,'00b074e8-2818-40fd-8e30-708961b08bcc',192,'82445c1a56474ba497d07340322dbade','volumes_tripleo',1,'2025-12-03 10:14:01',NULL),('2025-12-02 10:14:01','2025-12-02 10:14:01','2025-12-02 10:14:01',1,728,'67c22df7-1c18-4da7-862b-ea812ad3cf89',193,'82445c1a56474ba497d07340322dbade','gigabytes_tripleo',1,'2025-12-03 10:14:01',NULL),('2025-12-02 10:14:01','2025-12-02 10:14:01','2025-12-02 10:14:01',1,729,'f932c710-58f9-4ad0-95f6-c31f983d62d7',186,'59618d0a71be4bd7b90941ee9db2762c','volumes',-1,'2025-12-03 10:14:01',NULL),('2025-12-02 10:14:01','2025-12-02 10:14:01','2025-12-02 10:14:01',1,730,'de015971-4b0e-4571-a17e-80d094622144',187,'59618d0a71be4bd7b90941ee9db2762c','gigabytes',-1,'2025-12-03 10:14:01',NULL),('2025-12-02 10:14:01','2025-12-02 10:14:01','2025-12-02 10:14:01',1,731,'fce0195f-8155-4bfd-a8b5-f58ecb4ce499',188,'59618d0a71be4bd7b90941ee9db2762c','volumes_tripleo',-1,'2025-12-03 10:14:01',NULL),('2025-12-02 10:14:01','2025-12-02 10:14:01','2025-12-02 10:14:01',1,732,'75e3cdaa-2468-4bb6-85ca-6073d80be13d',189,'59618d0a71be4bd7b90941ee9db2762c','gigabytes_tripleo',-1,'2025-12-03 10:14:01',NULL),('2025-12-02 10:14:02','2025-12-02 10:14:02','2025-12-02 10:14:02',1,733,'b75590dd-23d8-49d7-8253-e6b3c4c17818',190,'82445c1a56474ba497d07340322dbade','volumes',1,'2025-12-03 10:14:02',NULL),('2025-12-02 10:14:02','2025-12-02 10:14:02','2025-12-02 10:14:02',1,734,'e170a81b-163b-48a1-895e-602d5cbf4c7d',191,'82445c1a56474ba497d07340322dbade','gigabytes',1,'2025-12-03 10:14:02',NULL),('2025-12-02 10:14:02','2025-12-02 10:14:02','2025-12-02 10:14:02',1,735,'db8a2911-e07e-4680-9e48-969b864bc4a0',192,'82445c1a56474ba497d07340322dbade','volumes_tripleo',1,'2025-12-03 10:14:02',NULL),('2025-12-02 10:14:02','2025-12-02 10:14:02','2025-12-02 10:14:02',1,736,'6baa10d3-5b6e-4866-9b4d-4a174dd5ebf4',193,'82445c1a56474ba497d07340322dbade','gigabytes_tripleo',1,'2025-12-03 10:14:02',NULL),('2025-12-02 10:14:03','2025-12-02 10:14:03','2025-12-02 10:14:03',1,737,'1948c1fa-eb06-4875-9dfb-5f13a605d33e',186,'59618d0a71be4bd7b90941ee9db2762c','volumes',-1,'2025-12-03 10:14:03',NULL),('2025-12-02 10:14:03','2025-12-02 10:14:03','2025-12-02 10:14:03',1,738,'75cbefe2-4e86-41fd-a41c-e758ee09fba5',187,'59618d0a71be4bd7b90941ee9db2762c','gigabytes',-1,'2025-12-03 10:14:03',NULL),('2025-12-02 10:14:03','2025-12-02 10:14:03','2025-12-02 10:14:03',1,739,'756a3e69-20a1-4160-8118-857b067760a4',188,'59618d0a71be4bd7b90941ee9db2762c','volumes_tripleo',-1,'2025-12-03 10:14:03',NULL),('2025-12-02 10:14:03','2025-12-02 10:14:03','2025-12-02 10:14:03',1,740,'cc308f19-44c1-4c3a-99e7-0e80d9fb2090',189,'59618d0a71be4bd7b90941ee9db2762c','gigabytes_tripleo',-1,'2025-12-03 10:14:03',NULL),('2025-12-02 10:14:05','2025-12-02 10:14:05','2025-12-02 10:14:05',1,741,'0299f9cd-6fec-4da3-b504-914c8e98dee9',194,'8f287097241a4419b0923dfc81ea1206','volumes',1,'2025-12-03 10:14:05',NULL),('2025-12-02 10:14:05','2025-12-02 10:14:05','2025-12-02 10:14:05',1,742,'8683b16f-a35d-48cb-9117-e9fa6584c72b',195,'8f287097241a4419b0923dfc81ea1206','gigabytes',1,'2025-12-03 10:14:05',NULL),('2025-12-02 10:14:05','2025-12-02 10:14:05','2025-12-02 10:14:05',1,743,'4f560323-8376-40f7-baea-38bee8a6f7bd',196,'8f287097241a4419b0923dfc81ea1206','volumes_tripleo',1,'2025-12-03 10:14:05',NULL),('2025-12-02 10:14:05','2025-12-02 10:14:05','2025-12-02 10:14:05',1,744,'3f761068-c200-4bb1-8f55-e65001f48863',197,'8f287097241a4419b0923dfc81ea1206','gigabytes_tripleo',1,'2025-12-03 10:14:05',NULL),('2025-12-02 10:14:05','2025-12-02 10:14:05','2025-12-02 10:14:05',1,745,'2232f996-f240-4969-8b8d-90c44ac7595f',190,'82445c1a56474ba497d07340322dbade','volumes',1,'2025-12-03 10:14:05',NULL),('2025-12-02 10:14:05','2025-12-02 10:14:05','2025-12-02 10:14:05',1,746,'a2056f2d-5802-4e5b-ac86-370f9886f304',191,'82445c1a56474ba497d07340322dbade','gigabytes',1,'2025-12-03 10:14:05',NULL),('2025-12-02 10:14:05','2025-12-02 10:14:05','2025-12-02 10:14:05',1,747,'09b90010-cdb1-4711-94c3-b33e26cdef64',192,'82445c1a56474ba497d07340322dbade','volumes_tripleo',1,'2025-12-03 10:14:05',NULL),('2025-12-02 10:14:05','2025-12-02 10:14:05','2025-12-02 10:14:05',1,748,'a6c9e12e-1705-4292-adf7-6ce8afd12526',193,'82445c1a56474ba497d07340322dbade','gigabytes_tripleo',1,'2025-12-03 10:14:05',NULL),('2025-12-02 10:14:06','2025-12-02 10:14:06','2025-12-02 10:14:06',1,749,'1c487f54-bbeb-4b2a-8098-d680cd14598c',198,'8f287097241a4419b0923dfc81ea1206','snapshots',1,'2025-12-03 10:14:06',NULL),('2025-12-02 10:14:06','2025-12-02 10:14:06','2025-12-02 10:14:06',1,750,'d2fba95d-1fb6-46e1-bbfe-a00b816bcc80',195,'8f287097241a4419b0923dfc81ea1206','gigabytes',1,'2025-12-03 10:14:06',NULL),('2025-12-02 10:14:06','2025-12-02 10:14:06','2025-12-02 10:14:06',1,751,'b70eba84-e430-4823-8bbf-044b0bc3607a',197,'8f287097241a4419b0923dfc81ea1206','gigabytes_tripleo',1,'2025-12-03 10:14:06',NULL),('2025-12-02 10:14:06','2025-12-02 10:14:06','2025-12-02 10:14:06',1,752,'50effd81-ea2a-4025-b208-418625cdeec7',199,'8f287097241a4419b0923dfc81ea1206','snapshots_tripleo',1,'2025-12-03 10:14:06',NULL),('2025-12-02 10:14:07','2025-12-02 10:14:07','2025-12-02 10:14:07',1,753,'9800029b-45b0-40ea-9a3e-7cbe609fab36',190,'82445c1a56474ba497d07340322dbade','volumes',-1,'2025-12-03 10:14:07',NULL),('2025-12-02 10:14:07','2025-12-02 10:14:07','2025-12-02 10:14:07',1,754,'1fbaafe8-fb59-4523-8096-d116293a3a86',191,'82445c1a56474ba497d07340322dbade','gigabytes',-1,'2025-12-03 10:14:07',NULL),('2025-12-02 10:14:07','2025-12-02 10:14:07','2025-12-02 10:14:07',1,755,'2043436e-4fa6-4ce1-8b3e-fc4a15a88cd3',192,'82445c1a56474ba497d07340322dbade','volumes_tripleo',-1,'2025-12-03 10:14:07',NULL),('2025-12-02 10:14:07','2025-12-02 10:14:07','2025-12-02 10:14:07',1,756,'b8038aef-2fd9-4600-ad0d-93ebbcb9b65c',193,'82445c1a56474ba497d07340322dbade','gigabytes_tripleo',-1,'2025-12-03 10:14:07',NULL),('2025-12-02 10:14:08','2025-12-02 10:14:08','2025-12-02 10:14:08',1,757,'e5c2b386-ba04-4e54-a0b5-bda7399de2f9',190,'82445c1a56474ba497d07340322dbade','volumes',-1,'2025-12-03 10:14:08',NULL),('2025-12-02 10:14:08','2025-12-02 10:14:08','2025-12-02 10:14:08',1,758,'1235bee6-5bdd-4ed2-9fad-19d3ffea1f39',191,'82445c1a56474ba497d07340322dbade','gigabytes',-1,'2025-12-03 10:14:08',NULL),('2025-12-02 10:14:08','2025-12-02 10:14:08','2025-12-02 10:14:08',1,759,'6ebd3f5a-2684-4073-95a1-97b52e64c654',192,'82445c1a56474ba497d07340322dbade','volumes_tripleo',-1,'2025-12-03 10:14:08',NULL),('2025-12-02 10:14:08','2025-12-02 10:14:08','2025-12-02 10:14:08',1,760,'58820d4b-a574-4922-909d-3fee78d0ec68',193,'82445c1a56474ba497d07340322dbade','gigabytes_tripleo',-1,'2025-12-03 10:14:08',NULL),('2025-12-02 10:14:09','2025-12-02 10:14:09','2025-12-02 10:14:09',1,761,'844f4df7-a3fc-47cd-a7c9-7dc13deba484',190,'82445c1a56474ba497d07340322dbade','volumes',-1,'2025-12-03 10:14:09',NULL),('2025-12-02 10:14:09','2025-12-02 10:14:09','2025-12-02 10:14:09',1,762,'23dc281a-bd00-467e-8bd9-7bbb45594ba0',191,'82445c1a56474ba497d07340322dbade','gigabytes',-1,'2025-12-03 10:14:09',NULL),('2025-12-02 10:14:09','2025-12-02 10:14:09','2025-12-02 10:14:09',1,763,'c56fbaf6-056a-4448-b083-57e745237e86',192,'82445c1a56474ba497d07340322dbade','volumes_tripleo',-1,'2025-12-03 10:14:09',NULL),('2025-12-02 10:14:09','2025-12-02 10:14:09','2025-12-02 10:14:09',1,764,'bace205b-0da0-4f12-8164-cfaa1478ae3a',193,'82445c1a56474ba497d07340322dbade','gigabytes_tripleo',-1,'2025-12-03 10:14:09',NULL),('2025-12-02 10:14:10','2025-12-02 10:14:10','2025-12-02 10:14:10',1,765,'5d1c761d-8d60-47a8-8f28-f5560929fa88',198,'8f287097241a4419b0923dfc81ea1206','snapshots',-1,'2025-12-03 10:14:10',NULL),('2025-12-02 10:14:10','2025-12-02 10:14:10','2025-12-02 10:14:10',1,766,'dc6cd39e-ba68-40d7-993f-daaac8bfd2fd',195,'8f287097241a4419b0923dfc81ea1206','gigabytes',-1,'2025-12-03 10:14:10',NULL),('2025-12-02 10:14:10','2025-12-02 10:14:10','2025-12-02 10:14:10',1,767,'c979241c-80e2-41ef-8945-ce40abfef1d2',197,'8f287097241a4419b0923dfc81ea1206','gigabytes_tripleo',-1,'2025-12-03 10:14:10',NULL),('2025-12-02 10:14:10','2025-12-02 10:14:10','2025-12-02 10:14:10',1,768,'d683741c-fcff-4af0-9bf7-eff13e2ea4a8',199,'8f287097241a4419b0923dfc81ea1206','snapshots_tripleo',-1,'2025-12-03 10:14:10',NULL),('2025-12-02 10:14:10','2025-12-02 10:14:10','2025-12-02 10:14:10',1,769,'95ac9a6e-620a-4e6e-ba71-19756f743b38',190,'82445c1a56474ba497d07340322dbade','volumes',1,'2025-12-03 10:14:10',NULL),('2025-12-02 10:14:10','2025-12-02 10:14:10','2025-12-02 10:14:10',1,770,'2152b940-fda3-404d-a1b3-d1bb454ad8f4',191,'82445c1a56474ba497d07340322dbade','gigabytes',1,'2025-12-03 10:14:10',NULL),('2025-12-02 10:14:10','2025-12-02 10:14:10','2025-12-02 10:14:10',1,771,'a502ad70-c83a-43ce-83ae-6e67543f69b1',192,'82445c1a56474ba497d07340322dbade','volumes_tripleo',1,'2025-12-03 10:14:10',NULL),('2025-12-02 10:14:10','2025-12-02 10:14:10','2025-12-02 10:14:10',1,772,'23f380e1-42e1-4b0c-a5d9-5d493aba5d46',193,'82445c1a56474ba497d07340322dbade','gigabytes_tripleo',1,'2025-12-03 10:14:10',NULL),('2025-12-02 10:14:11','2025-12-02 10:14:11','2025-12-02 10:14:11',1,773,'ad39d61f-b34b-47bb-959a-f19660d267c7',194,'8f287097241a4419b0923dfc81ea1206','volumes',-1,'2025-12-03 10:14:11',NULL),('2025-12-02 10:14:11','2025-12-02 10:14:11','2025-12-02 10:14:11',1,774,'686bd9c8-99af-4171-b9cd-1344a224375e',195,'8f287097241a4419b0923dfc81ea1206','gigabytes',-1,'2025-12-03 10:14:11',NULL),('2025-12-02 10:14:11','2025-12-02 10:14:11','2025-12-02 10:14:11',1,775,'0df042db-98a5-46ee-a752-6f4f633e5000',196,'8f287097241a4419b0923dfc81ea1206','volumes_tripleo',-1,'2025-12-03 10:14:11',NULL),('2025-12-02 10:14:11','2025-12-02 10:14:11','2025-12-02 10:14:11',1,776,'ae49f024-9f31-4945-9fd1-9a0649a6cfab',197,'8f287097241a4419b0923dfc81ea1206','gigabytes_tripleo',-1,'2025-12-03 10:14:11',NULL),('2025-12-02 10:14:15','2025-12-02 10:14:15','2025-12-02 10:14:15',1,777,'3310f5b3-20e9-478b-b166-edb7bd9b6695',200,'d3daa40d2d6446d8b0b46a9f7d1b779c','volumes',1,'2025-12-03 10:14:15',NULL),('2025-12-02 10:14:15','2025-12-02 10:14:15','2025-12-02 10:14:15',1,778,'13ec1bb4-e34a-453a-a0d2-03bc9b9068e0',201,'d3daa40d2d6446d8b0b46a9f7d1b779c','gigabytes',1,'2025-12-03 10:14:15',NULL),('2025-12-02 10:14:15','2025-12-02 10:14:15','2025-12-02 10:14:15',1,779,'25f6e59f-bd36-428a-a8cd-45910d571ae2',202,'d3daa40d2d6446d8b0b46a9f7d1b779c','volumes_tripleo',1,'2025-12-03 10:14:15',NULL),('2025-12-02 10:14:15','2025-12-02 10:14:15','2025-12-02 10:14:15',1,780,'7790b0e8-5330-4db1-88a1-6035c34b34e3',203,'d3daa40d2d6446d8b0b46a9f7d1b779c','gigabytes_tripleo',1,'2025-12-03 10:14:15',NULL),('2025-12-02 10:14:16','2025-12-02 10:14:16','2025-12-02 10:14:16',1,781,'a352bc6f-7599-4545-bde5-bfcc0992efc6',204,'d3daa40d2d6446d8b0b46a9f7d1b779c','snapshots',1,'2025-12-03 10:14:16',NULL),('2025-12-02 10:14:16','2025-12-02 10:14:16','2025-12-02 10:14:16',1,782,'1440837c-df29-4a45-856b-46b96ca46276',201,'d3daa40d2d6446d8b0b46a9f7d1b779c','gigabytes',1,'2025-12-03 10:14:16',NULL),('2025-12-02 10:14:16','2025-12-02 10:14:16','2025-12-02 10:14:16',1,783,'21e60c42-2e01-40eb-b034-3183699be27e',203,'d3daa40d2d6446d8b0b46a9f7d1b779c','gigabytes_tripleo',1,'2025-12-03 10:14:16',NULL),('2025-12-02 10:14:16','2025-12-02 10:14:16','2025-12-02 10:14:16',1,784,'a6302dde-c394-460b-96b5-39b0f4a76940',205,'d3daa40d2d6446d8b0b46a9f7d1b779c','snapshots_tripleo',1,'2025-12-03 10:14:16',NULL),('2025-12-02 10:14:17','2025-12-02 10:14:17','2025-12-02 10:14:17',1,785,'e0ef0970-24bd-4bc6-9512-fdfa9b0d2d28',190,'82445c1a56474ba497d07340322dbade','volumes',1,'2025-12-03 10:14:17',NULL),('2025-12-02 10:14:17','2025-12-02 10:14:17','2025-12-02 10:14:17',1,786,'46b5382d-5b49-4303-a5f5-3a06fad8ed96',191,'82445c1a56474ba497d07340322dbade','gigabytes',1,'2025-12-03 10:14:17',NULL),('2025-12-02 10:14:17','2025-12-02 10:14:17','2025-12-02 10:14:17',1,787,'f4ced450-4834-41aa-a7a2-11feedc6bd6d',192,'82445c1a56474ba497d07340322dbade','volumes_tripleo',1,'2025-12-03 10:14:17',NULL),('2025-12-02 10:14:17','2025-12-02 10:14:17','2025-12-02 10:14:17',1,788,'1b76cca2-a587-4cb6-86ef-93d5e5ce46ff',193,'82445c1a56474ba497d07340322dbade','gigabytes_tripleo',1,'2025-12-03 10:14:17',NULL),('2025-12-02 10:14:17','2025-12-02 10:14:17','2025-12-02 10:14:17',1,789,'f9cfa7e5-f7b6-45d3-9d90-c25f58e309c4',204,'d3daa40d2d6446d8b0b46a9f7d1b779c','snapshots',1,'2025-12-03 10:14:17',NULL),('2025-12-02 10:14:17','2025-12-02 10:14:17','2025-12-02 10:14:17',1,790,'83494214-bf68-4dbd-b598-fb540d02f336',201,'d3daa40d2d6446d8b0b46a9f7d1b779c','gigabytes',1,'2025-12-03 10:14:17',NULL),('2025-12-02 10:14:17','2025-12-02 10:14:17','2025-12-02 10:14:17',1,791,'c21b7c84-289b-4c85-8fb5-62811290d111',203,'d3daa40d2d6446d8b0b46a9f7d1b779c','gigabytes_tripleo',1,'2025-12-03 10:14:17',NULL),('2025-12-02 10:14:17','2025-12-02 10:14:17','2025-12-02 10:14:17',1,792,'04ea44e4-38a8-4f0c-9e9f-0c3560d8323e',205,'d3daa40d2d6446d8b0b46a9f7d1b779c','snapshots_tripleo',1,'2025-12-03 10:14:17',NULL),('2025-12-02 10:14:18','2025-12-02 10:14:19','2025-12-02 10:14:19',1,793,'817d96e5-ff1f-42c0-b932-14d9de0b9bc6',190,'82445c1a56474ba497d07340322dbade','volumes',-1,'2025-12-03 10:14:18',NULL),('2025-12-02 10:14:19','2025-12-02 10:14:19','2025-12-02 10:14:19',1,794,'06ce92ee-b175-48d2-bced-0be5acb12e71',191,'82445c1a56474ba497d07340322dbade','gigabytes',-1,'2025-12-03 10:14:18',NULL),('2025-12-02 10:14:19','2025-12-02 10:14:19','2025-12-02 10:14:19',1,795,'00a05bf0-a757-4c62-8159-e76fa7116e6e',192,'82445c1a56474ba497d07340322dbade','volumes_tripleo',-1,'2025-12-03 10:14:18',NULL),('2025-12-02 10:14:19','2025-12-02 10:14:19','2025-12-02 10:14:19',1,796,'2973f92f-4bec-4f46-8b28-d8934a103f83',193,'82445c1a56474ba497d07340322dbade','gigabytes_tripleo',-1,'2025-12-03 10:14:18',NULL),('2025-12-02 10:14:19','2025-12-02 10:14:19','2025-12-02 10:14:19',1,797,'3653ccf2-5b68-45ee-a264-0dfc4fa3e76d',204,'d3daa40d2d6446d8b0b46a9f7d1b779c','snapshots',-1,'2025-12-03 10:14:19',NULL),('2025-12-02 10:14:19','2025-12-02 10:14:19','2025-12-02 10:14:19',1,798,'8fb2e994-18e1-473a-a047-9a23f0e13eb1',201,'d3daa40d2d6446d8b0b46a9f7d1b779c','gigabytes',-1,'2025-12-03 10:14:19',NULL),('2025-12-02 10:14:19','2025-12-02 10:14:19','2025-12-02 10:14:19',1,799,'24565e6e-8873-477f-aea1-350a1510bfea',203,'d3daa40d2d6446d8b0b46a9f7d1b779c','gigabytes_tripleo',-1,'2025-12-03 10:14:19',NULL),('2025-12-02 10:14:19','2025-12-02 10:14:19','2025-12-02 10:14:19',1,800,'0c855dd9-201e-4e0f-8477-42736663c642',205,'d3daa40d2d6446d8b0b46a9f7d1b779c','snapshots_tripleo',-1,'2025-12-03 10:14:19',NULL),('2025-12-02 10:14:20','2025-12-02 10:14:20','2025-12-02 10:14:20',1,801,'8b0804e5-b35c-42b6-9ad4-f586302596f4',190,'82445c1a56474ba497d07340322dbade','volumes',-1,'2025-12-03 10:14:20',NULL),('2025-12-02 10:14:20','2025-12-02 10:14:20','2025-12-02 10:14:20',1,802,'8d38c445-ef3e-41b6-9d50-6975a24d80f8',191,'82445c1a56474ba497d07340322dbade','gigabytes',-1,'2025-12-03 10:14:20',NULL),('2025-12-02 10:14:20','2025-12-02 10:14:20','2025-12-02 10:14:20',1,803,'43ab4638-c4f2-4d3b-b9f2-477e2ee6664f',192,'82445c1a56474ba497d07340322dbade','volumes_tripleo',-1,'2025-12-03 10:14:20',NULL),('2025-12-02 10:14:20','2025-12-02 10:14:20','2025-12-02 10:14:20',1,804,'7f015b40-470e-497e-b5ad-ea414af59464',193,'82445c1a56474ba497d07340322dbade','gigabytes_tripleo',-1,'2025-12-03 10:14:20',NULL),('2025-12-02 10:14:20','2025-12-02 10:14:20','2025-12-02 10:14:20',1,805,'2c4f5fc3-092c-4ad0-b7d2-73fd0ffd70e8',204,'d3daa40d2d6446d8b0b46a9f7d1b779c','snapshots',-1,'2025-12-03 10:14:20',NULL),('2025-12-02 10:14:20','2025-12-02 10:14:20','2025-12-02 10:14:20',1,806,'d2eb9e3b-de3d-4a09-ae1c-bf5646dced17',201,'d3daa40d2d6446d8b0b46a9f7d1b779c','gigabytes',-1,'2025-12-03 10:14:20',NULL),('2025-12-02 10:14:20','2025-12-02 10:14:20','2025-12-02 10:14:20',1,807,'3308474c-20df-47b9-b05e-049243c5024d',203,'d3daa40d2d6446d8b0b46a9f7d1b779c','gigabytes_tripleo',-1,'2025-12-03 10:14:20',NULL),('2025-12-02 10:14:20','2025-12-02 10:14:20','2025-12-02 10:14:20',1,808,'06584710-9576-4b61-adf4-74f86c74a1a1',205,'d3daa40d2d6446d8b0b46a9f7d1b779c','snapshots_tripleo',-1,'2025-12-03 10:14:20',NULL),('2025-12-02 10:14:20','2025-12-02 10:14:20','2025-12-02 10:14:20',1,809,'4fbdccb3-c26e-4e2e-b59f-6eb5d9ca65ae',200,'d3daa40d2d6446d8b0b46a9f7d1b779c','volumes',-1,'2025-12-03 10:14:20',NULL),('2025-12-02 10:14:20','2025-12-02 10:14:20','2025-12-02 10:14:20',1,810,'6950b3d0-606a-4996-9512-bfa1f8e2ebfd',201,'d3daa40d2d6446d8b0b46a9f7d1b779c','gigabytes',-1,'2025-12-03 10:14:20',NULL),('2025-12-02 10:14:20','2025-12-02 10:14:20','2025-12-02 10:14:20',1,811,'20c692ce-3a98-469b-af09-d95ab7ec4158',202,'d3daa40d2d6446d8b0b46a9f7d1b779c','volumes_tripleo',-1,'2025-12-03 10:14:20',NULL),('2025-12-02 10:14:20','2025-12-02 10:14:20','2025-12-02 10:14:20',1,812,'a07d6cab-b5c2-4254-979f-21bcd958fb57',203,'d3daa40d2d6446d8b0b46a9f7d1b779c','gigabytes_tripleo',-1,'2025-12-03 10:14:20',NULL),('2025-12-02 10:14:22','2025-12-02 10:14:22','2025-12-02 10:14:22',1,813,'41c3e255-5d79-4319-9ebc-7cc1a41ba33b',200,'d3daa40d2d6446d8b0b46a9f7d1b779c','volumes',1,'2025-12-03 10:14:22',NULL),('2025-12-02 10:14:22','2025-12-02 10:14:22','2025-12-02 10:14:22',1,814,'7f782e80-801e-47b1-bae9-23c5f31f1d03',201,'d3daa40d2d6446d8b0b46a9f7d1b779c','gigabytes',1,'2025-12-03 10:14:22',NULL),('2025-12-02 10:14:22','2025-12-02 10:14:22','2025-12-02 10:14:22',1,815,'d0d75f55-fc23-4a15-8c13-1d37b87dfafb',202,'d3daa40d2d6446d8b0b46a9f7d1b779c','volumes_tripleo',1,'2025-12-03 10:14:22',NULL),('2025-12-02 10:14:22','2025-12-02 10:14:22','2025-12-02 10:14:22',1,816,'2c9c07f3-675e-49d0-8418-f28a895c923e',203,'d3daa40d2d6446d8b0b46a9f7d1b779c','gigabytes_tripleo',1,'2025-12-03 10:14:22',NULL),('2025-12-02 10:14:23','2025-12-02 10:14:23','2025-12-02 10:14:23',1,817,'5ed5fd4e-4cb0-45b0-86f7-a52d665802a0',204,'d3daa40d2d6446d8b0b46a9f7d1b779c','snapshots',1,'2025-12-03 10:14:23',NULL),('2025-12-02 10:14:23','2025-12-02 10:14:23','2025-12-02 10:14:23',1,818,'312d3ff1-5be6-48da-8237-599486cefcfe',201,'d3daa40d2d6446d8b0b46a9f7d1b779c','gigabytes',1,'2025-12-03 10:14:23',NULL),('2025-12-02 10:14:23','2025-12-02 10:14:23','2025-12-02 10:14:23',1,819,'41a31fbb-e4be-45d3-9eef-de12f928123f',203,'d3daa40d2d6446d8b0b46a9f7d1b779c','gigabytes_tripleo',1,'2025-12-03 10:14:23',NULL),('2025-12-02 10:14:23','2025-12-02 10:14:23','2025-12-02 10:14:23',1,820,'f805b61a-48d6-4ae1-91b8-484511b31191',205,'d3daa40d2d6446d8b0b46a9f7d1b779c','snapshots_tripleo',1,'2025-12-03 10:14:23',NULL),('2025-12-02 10:14:23','2025-12-02 10:14:23','2025-12-02 10:14:23',1,821,'a5225c1e-c6b7-428b-a393-d616651e4809',206,'ab2f308df5874752ab8cc95304b7b442','volumes',1,'2025-12-03 10:14:23',NULL),('2025-12-02 10:14:23','2025-12-02 10:14:23','2025-12-02 10:14:23',1,822,'f07a8e9f-391e-4a5d-ad7e-0d0b19082087',207,'ab2f308df5874752ab8cc95304b7b442','gigabytes',1,'2025-12-03 10:14:23',NULL),('2025-12-02 10:14:23','2025-12-02 10:14:23','2025-12-02 10:14:23',1,823,'f381728b-5be4-444e-b3a0-34a6b1bdc421',208,'ab2f308df5874752ab8cc95304b7b442','volumes_tripleo',1,'2025-12-03 10:14:23',NULL),('2025-12-02 10:14:23','2025-12-02 10:14:23','2025-12-02 10:14:23',1,824,'2c4f7511-a5c9-4cd9-9c05-1b24393dca69',209,'ab2f308df5874752ab8cc95304b7b442','gigabytes_tripleo',1,'2025-12-03 10:14:23',NULL),('2025-12-02 10:14:24','2025-12-02 10:14:24','2025-12-02 10:14:24',1,825,'f407db78-51b6-4731-b05c-ac19b9de709e',200,'d3daa40d2d6446d8b0b46a9f7d1b779c','volumes',1,'2025-12-03 10:14:24',NULL),('2025-12-02 10:14:24','2025-12-02 10:14:24','2025-12-02 10:14:24',1,826,'280ed25d-5497-4ffc-99ba-e977d598a84f',201,'d3daa40d2d6446d8b0b46a9f7d1b779c','gigabytes',1,'2025-12-03 10:14:24',NULL),('2025-12-02 10:14:24','2025-12-02 10:14:24','2025-12-02 10:14:24',1,827,'228121ac-e122-46ba-95a7-9bd1ce99a183',202,'d3daa40d2d6446d8b0b46a9f7d1b779c','volumes_tripleo',1,'2025-12-03 10:14:24',NULL),('2025-12-02 10:14:24','2025-12-02 10:14:24','2025-12-02 10:14:24',1,828,'40299dfd-6f12-4e91-b41a-91e33e767acd',203,'d3daa40d2d6446d8b0b46a9f7d1b779c','gigabytes_tripleo',1,'2025-12-03 10:14:24',NULL),('2025-12-02 10:14:24','2025-12-02 10:14:24','2025-12-02 10:14:24',1,829,'720ff66d-3d82-4475-8f04-012dae091dd8',210,'ab2f308df5874752ab8cc95304b7b442','snapshots',1,'2025-12-03 10:14:24',NULL),('2025-12-02 10:14:24','2025-12-02 10:14:24','2025-12-02 10:14:24',1,830,'78c4394a-7ba2-46b0-8e06-9879a8f3f6ee',207,'ab2f308df5874752ab8cc95304b7b442','gigabytes',1,'2025-12-03 10:14:24',NULL),('2025-12-02 10:14:24','2025-12-02 10:14:24','2025-12-02 10:14:24',1,831,'b961b4ea-961c-4f08-8944-76d8d68a91d6',209,'ab2f308df5874752ab8cc95304b7b442','gigabytes_tripleo',1,'2025-12-03 10:14:24',NULL),('2025-12-02 10:14:24','2025-12-02 10:14:24','2025-12-02 10:14:24',1,832,'a65d6549-39bc-436b-a7f8-2738fd76738a',211,'ab2f308df5874752ab8cc95304b7b442','snapshots_tripleo',1,'2025-12-03 10:14:24',NULL),('2025-12-02 10:14:26','2025-12-02 10:14:26','2025-12-02 10:14:26',1,833,'d1f49b5a-c478-4529-984a-2bb7f5b39ab3',210,'ab2f308df5874752ab8cc95304b7b442','snapshots',1,'2025-12-03 10:14:26',NULL),('2025-12-02 10:14:26','2025-12-02 10:14:26','2025-12-02 10:14:26',1,834,'f16231fa-5766-4372-b99c-f4e51d004e6b',207,'ab2f308df5874752ab8cc95304b7b442','gigabytes',1,'2025-12-03 10:14:26',NULL),('2025-12-02 10:14:26','2025-12-02 10:14:26','2025-12-02 10:14:26',1,835,'43dc3bb6-489f-497a-b018-c1b8b8fb0b06',209,'ab2f308df5874752ab8cc95304b7b442','gigabytes_tripleo',1,'2025-12-03 10:14:26',NULL),('2025-12-02 10:14:26','2025-12-02 10:14:26','2025-12-02 10:14:26',1,836,'b2d63967-04ab-41cc-a289-705c90bc3f1c',211,'ab2f308df5874752ab8cc95304b7b442','snapshots_tripleo',1,'2025-12-03 10:14:26',NULL),('2025-12-02 10:14:29','2025-12-02 10:14:29','2025-12-02 10:14:29',1,837,'8e68d26b-4744-4718-b009-da109ef9e99b',210,'ab2f308df5874752ab8cc95304b7b442','snapshots',1,'2025-12-03 10:14:29',NULL),('2025-12-02 10:14:29','2025-12-02 10:14:29','2025-12-02 10:14:29',1,838,'7c52d68e-022f-4f56-89ad-6019c5282826',207,'ab2f308df5874752ab8cc95304b7b442','gigabytes',1,'2025-12-03 10:14:29',NULL),('2025-12-02 10:14:29','2025-12-02 10:14:29','2025-12-02 10:14:29',1,839,'6c56b0b3-8cd3-4e52-8373-c1404f78c7c9',209,'ab2f308df5874752ab8cc95304b7b442','gigabytes_tripleo',1,'2025-12-03 10:14:29',NULL),('2025-12-02 10:14:29','2025-12-02 10:14:29','2025-12-02 10:14:29',1,840,'10c5a167-8dbd-4dcf-a044-a4cf9420eb37',211,'ab2f308df5874752ab8cc95304b7b442','snapshots_tripleo',1,'2025-12-03 10:14:29',NULL),('2025-12-02 10:14:32','2025-12-02 10:14:32','2025-12-02 10:14:32',1,841,'c8443a3f-4545-460f-bc43-7f8be9abbc1f',204,'d3daa40d2d6446d8b0b46a9f7d1b779c','snapshots',-1,'2025-12-03 10:14:32',NULL),('2025-12-02 10:14:32','2025-12-02 10:14:32','2025-12-02 10:14:32',1,842,'a460c746-92ee-49c4-b7ec-88409bc1fa2b',201,'d3daa40d2d6446d8b0b46a9f7d1b779c','gigabytes',-1,'2025-12-03 10:14:32',NULL),('2025-12-02 10:14:32','2025-12-02 10:14:32','2025-12-02 10:14:32',1,843,'9402eeb3-cf0f-4ed3-ae57-63476a3b8164',203,'d3daa40d2d6446d8b0b46a9f7d1b779c','gigabytes_tripleo',-1,'2025-12-03 10:14:32',NULL),('2025-12-02 10:14:32','2025-12-02 10:14:32','2025-12-02 10:14:32',1,844,'457f633e-3411-481a-8dd8-76cccc1b8446',205,'d3daa40d2d6446d8b0b46a9f7d1b779c','snapshots_tripleo',-1,'2025-12-03 10:14:32',NULL),('2025-12-02 10:14:32','2025-12-02 10:14:32','2025-12-02 10:14:32',1,845,'f36502be-a41a-412f-933b-474aeeaa58d5',210,'ab2f308df5874752ab8cc95304b7b442','snapshots',-1,'2025-12-03 10:14:32',NULL),('2025-12-02 10:14:32','2025-12-02 10:14:32','2025-12-02 10:14:32',1,846,'8fc2b62a-26c3-41d5-b5d7-f8a8771c9390',207,'ab2f308df5874752ab8cc95304b7b442','gigabytes',-1,'2025-12-03 10:14:32',NULL),('2025-12-02 10:14:32','2025-12-02 10:14:32','2025-12-02 10:14:32',1,847,'4428ba08-4213-4023-a3ee-b3a6b5569241',209,'ab2f308df5874752ab8cc95304b7b442','gigabytes_tripleo',-1,'2025-12-03 10:14:32',NULL),('2025-12-02 10:14:32','2025-12-02 10:14:32','2025-12-02 10:14:32',1,848,'f1e2bb6a-e038-49c4-9ef0-ffce01cabdf3',211,'ab2f308df5874752ab8cc95304b7b442','snapshots_tripleo',-1,'2025-12-03 10:14:32',NULL),('2025-12-02 10:14:32','2025-12-02 10:14:32','2025-12-02 10:14:32',1,849,'c8e840c4-18fb-4cc1-8618-419a67472825',200,'d3daa40d2d6446d8b0b46a9f7d1b779c','volumes',-1,'2025-12-03 10:14:32',NULL),('2025-12-02 10:14:32','2025-12-02 10:14:32','2025-12-02 10:14:32',1,850,'fb13a6c9-acf9-45c5-8dd3-1dc1e321b483',201,'d3daa40d2d6446d8b0b46a9f7d1b779c','gigabytes',-1,'2025-12-03 10:14:32',NULL),('2025-12-02 10:14:32','2025-12-02 10:14:32','2025-12-02 10:14:32',1,851,'ba0e3dd3-3fbf-4c9e-9cf8-b32b7369e3f5',202,'d3daa40d2d6446d8b0b46a9f7d1b779c','volumes_tripleo',-1,'2025-12-03 10:14:32',NULL),('2025-12-02 10:14:32','2025-12-02 10:14:32','2025-12-02 10:14:32',1,852,'15fff2e3-76f9-4e1a-b80b-18339d8326fd',203,'d3daa40d2d6446d8b0b46a9f7d1b779c','gigabytes_tripleo',-1,'2025-12-03 10:14:32',NULL),('2025-12-02 10:14:34','2025-12-02 10:14:34','2025-12-02 10:14:34',1,853,'70909279-47cd-4fc5-98ca-bc3511ebed62',200,'d3daa40d2d6446d8b0b46a9f7d1b779c','volumes',-1,'2025-12-03 10:14:33',NULL),('2025-12-02 10:14:34','2025-12-02 10:14:34','2025-12-02 10:14:34',1,854,'64d02bd6-7859-4437-a7cc-54a82bf30f53',201,'d3daa40d2d6446d8b0b46a9f7d1b779c','gigabytes',-1,'2025-12-03 10:14:33',NULL),('2025-12-02 10:14:34','2025-12-02 10:14:34','2025-12-02 10:14:34',1,855,'4b451a23-b41a-4877-b877-dfa321368875',202,'d3daa40d2d6446d8b0b46a9f7d1b779c','volumes_tripleo',-1,'2025-12-03 10:14:33',NULL),('2025-12-02 10:14:34','2025-12-02 10:14:34','2025-12-02 10:14:34',1,856,'f107f6ef-82f3-4318-bd34-15b51ea40128',203,'d3daa40d2d6446d8b0b46a9f7d1b779c','gigabytes_tripleo',-1,'2025-12-03 10:14:33',NULL),('2025-12-02 10:14:34','2025-12-02 10:14:34','2025-12-02 10:14:34',1,857,'18e9dd6b-e2ec-41ee-8722-6b184927825b',210,'ab2f308df5874752ab8cc95304b7b442','snapshots',-1,'2025-12-03 10:14:34',NULL),('2025-12-02 10:14:34','2025-12-02 10:14:34','2025-12-02 10:14:34',1,858,'c8f32070-06d3-4f41-ae71-da77069b1fe0',207,'ab2f308df5874752ab8cc95304b7b442','gigabytes',-1,'2025-12-03 10:14:34',NULL),('2025-12-02 10:14:34','2025-12-02 10:14:34','2025-12-02 10:14:34',1,859,'333433b8-1837-48a5-a4e2-620079fd5dcf',209,'ab2f308df5874752ab8cc95304b7b442','gigabytes_tripleo',-1,'2025-12-03 10:14:34',NULL),('2025-12-02 10:14:34','2025-12-02 10:14:34','2025-12-02 10:14:34',1,860,'5c68ae18-d30b-42e7-963e-a7cec1ed5124',211,'ab2f308df5874752ab8cc95304b7b442','snapshots_tripleo',-1,'2025-12-03 10:14:34',NULL),('2025-12-02 10:14:36','2025-12-02 10:14:36','2025-12-02 10:14:36',1,861,'dac0c00e-d69d-4eac-b49b-15aa25dc1be5',210,'ab2f308df5874752ab8cc95304b7b442','snapshots',-1,'2025-12-03 10:14:36',NULL),('2025-12-02 10:14:36','2025-12-02 10:14:36','2025-12-02 10:14:36',1,862,'ae6257fe-e83c-47e1-bdab-92ba604be111',207,'ab2f308df5874752ab8cc95304b7b442','gigabytes',-1,'2025-12-03 10:14:36',NULL),('2025-12-02 10:14:36','2025-12-02 10:14:36','2025-12-02 10:14:36',1,863,'8135fdd0-ef3e-4480-8430-b9220d3c74b9',209,'ab2f308df5874752ab8cc95304b7b442','gigabytes_tripleo',-1,'2025-12-03 10:14:36',NULL),('2025-12-02 10:14:36','2025-12-02 10:14:36','2025-12-02 10:14:36',1,864,'0f67cc41-b88c-41ca-8882-3612a82ac4ed',211,'ab2f308df5874752ab8cc95304b7b442','snapshots_tripleo',-1,'2025-12-03 10:14:36',NULL),('2025-12-02 10:14:37','2025-12-02 10:14:37','2025-12-02 10:14:37',1,865,'576b3933-478f-4dec-b116-dd8ca261f414',206,'ab2f308df5874752ab8cc95304b7b442','volumes',-1,'2025-12-03 10:14:37',NULL),('2025-12-02 10:14:37','2025-12-02 10:14:37','2025-12-02 10:14:37',1,866,'41f6c84f-0d50-4e1f-ad17-76af4231f191',207,'ab2f308df5874752ab8cc95304b7b442','gigabytes',-1,'2025-12-03 10:14:37',NULL),('2025-12-02 10:14:37','2025-12-02 10:14:37','2025-12-02 10:14:37',1,867,'94fec581-5476-4a32-9322-04ae5dcf1ef2',208,'ab2f308df5874752ab8cc95304b7b442','volumes_tripleo',-1,'2025-12-03 10:14:37',NULL),('2025-12-02 10:14:37','2025-12-02 10:14:37','2025-12-02 10:14:37',1,868,'b3ab752d-de5c-4baf-a1f3-8519ad9a032f',209,'ab2f308df5874752ab8cc95304b7b442','gigabytes_tripleo',-1,'2025-12-03 10:14:37',NULL),('2025-12-02 10:14:46','2025-12-02 10:14:46','2025-12-02 10:14:46',1,869,'e91a9d6b-4804-4833-9466-8e8bdb2d3878',212,'d858413a9b01463f96545916d2abe5ab','volumes',1,'2025-12-03 10:14:46',NULL),('2025-12-02 10:14:46','2025-12-02 10:14:46','2025-12-02 10:14:46',1,870,'047218b8-6df7-4b5f-9372-5eefebdb7b59',213,'d858413a9b01463f96545916d2abe5ab','gigabytes',1,'2025-12-03 10:14:46',NULL),('2025-12-02 10:14:46','2025-12-02 10:14:46','2025-12-02 10:14:46',1,871,'a6062a5c-61bf-4041-9ce8-723ac819c16d',214,'d858413a9b01463f96545916d2abe5ab','volumes_tripleo',1,'2025-12-03 10:14:46',NULL),('2025-12-02 10:14:46','2025-12-02 10:14:46','2025-12-02 10:14:46',1,872,'c28399c5-6f5c-4416-b86c-df73ca581b90',215,'d858413a9b01463f96545916d2abe5ab','gigabytes_tripleo',1,'2025-12-03 10:14:46',NULL),('2025-12-02 10:14:52','2025-12-02 10:14:52','2025-12-02 10:14:52',1,873,'76972ca1-067c-48d0-a3ac-e8c3663d0650',216,'d858413a9b01463f96545916d2abe5ab','backups',1,'2025-12-03 10:14:52',NULL),('2025-12-02 10:14:52','2025-12-02 10:14:52','2025-12-02 10:14:52',1,874,'a85dfffa-6481-47fc-ae73-962111d8d5e8',217,'d858413a9b01463f96545916d2abe5ab','backup_gigabytes',1,'2025-12-03 10:14:52',NULL),('2025-12-02 10:14:56','2025-12-02 10:14:56','2025-12-02 10:14:56',1,875,'f7c922d3-dfe9-456e-bad8-37b5d18aa2c2',212,'d858413a9b01463f96545916d2abe5ab','volumes',1,'2025-12-03 10:14:56',NULL),('2025-12-02 10:14:56','2025-12-02 10:14:56','2025-12-02 10:14:56',1,876,'0f7c146c-988d-472b-89d5-f301b6360ef6',213,'d858413a9b01463f96545916d2abe5ab','gigabytes',1,'2025-12-03 10:14:56',NULL),('2025-12-02 10:14:56','2025-12-02 10:14:56','2025-12-02 10:14:56',1,877,'999a6943-fc6c-41eb-9789-5ef0253aa7c9',214,'d858413a9b01463f96545916d2abe5ab','volumes_tripleo',1,'2025-12-03 10:14:56',NULL),('2025-12-02 10:14:56','2025-12-02 10:14:56','2025-12-02 10:14:56',1,878,'00ca8d50-b981-43ba-80fd-8695a6123570',215,'d858413a9b01463f96545916d2abe5ab','gigabytes_tripleo',1,'2025-12-03 10:14:56',NULL),('2025-12-02 10:15:01','2025-12-02 10:15:01','2025-12-02 10:15:01',1,879,'b930507d-c7f3-4679-b54b-54edad743b44',212,'d858413a9b01463f96545916d2abe5ab','volumes',-1,'2025-12-03 10:15:01',NULL),('2025-12-02 10:15:01','2025-12-02 10:15:01','2025-12-02 10:15:01',1,880,'6ecd30e2-0051-43c8-827d-fae21a98a018',213,'d858413a9b01463f96545916d2abe5ab','gigabytes',-1,'2025-12-03 10:15:01',NULL),('2025-12-02 10:15:01','2025-12-02 10:15:01','2025-12-02 10:15:01',1,881,'f533986f-eb0b-490a-960f-f92e7a81e8c0',214,'d858413a9b01463f96545916d2abe5ab','volumes_tripleo',-1,'2025-12-03 10:15:01',NULL),('2025-12-02 10:15:01','2025-12-02 10:15:01','2025-12-02 10:15:01',1,882,'2e2460fe-5b78-4949-8604-71de8b3c3e8c',215,'d858413a9b01463f96545916d2abe5ab','gigabytes_tripleo',-1,'2025-12-03 10:15:01',NULL),('2025-12-02 10:15:04','2025-12-02 10:15:04','2025-12-02 10:15:04',1,883,'29b42066-4953-47bc-905f-d7a1deb278a9',216,'d858413a9b01463f96545916d2abe5ab','backups',-1,'2025-12-03 10:15:04',NULL),('2025-12-02 10:15:04','2025-12-02 10:15:04','2025-12-02 10:15:04',1,884,'d2ea31e0-5076-4cb5-986b-894973e8cbcb',217,'d858413a9b01463f96545916d2abe5ab','backup_gigabytes',-1,'2025-12-03 10:15:04',NULL),('2025-12-02 10:15:06','2025-12-02 10:15:06','2025-12-02 10:15:06',1,885,'335264ac-d31d-44da-846d-5bc0cc054457',212,'d858413a9b01463f96545916d2abe5ab','volumes',-1,'2025-12-03 10:15:06',NULL),('2025-12-02 10:15:06','2025-12-02 10:15:06','2025-12-02 10:15:06',1,886,'be65b530-217d-42df-807d-9cd95ccba354',213,'d858413a9b01463f96545916d2abe5ab','gigabytes',-1,'2025-12-03 10:15:06',NULL),('2025-12-02 10:15:06','2025-12-02 10:15:06','2025-12-02 10:15:06',1,887,'6a1ebacd-b14f-4039-adb1-534d11dff3bd',214,'d858413a9b01463f96545916d2abe5ab','volumes_tripleo',-1,'2025-12-03 10:15:06',NULL),('2025-12-02 10:15:06','2025-12-02 10:15:06','2025-12-02 10:15:06',1,888,'2ca0e544-6a69-4279-8108-c5c2bebb943e',215,'d858413a9b01463f96545916d2abe5ab','gigabytes_tripleo',-1,'2025-12-03 10:15:06',NULL),('2025-12-02 10:15:07','2025-12-02 10:15:07','2025-12-02 10:15:07',1,889,'4e9bb05a-3ed7-42fb-9112-ee05290a6f01',212,'d858413a9b01463f96545916d2abe5ab','volumes',1,'2025-12-03 10:15:07',NULL),('2025-12-02 10:15:07','2025-12-02 10:15:07','2025-12-02 10:15:07',1,890,'1421afa3-3d90-4f16-bf53-8750b8c0dfc3',213,'d858413a9b01463f96545916d2abe5ab','gigabytes',1,'2025-12-03 10:15:07',NULL),('2025-12-02 10:15:07','2025-12-02 10:15:07','2025-12-02 10:15:07',1,891,'18447084-922e-407f-92fe-7a13676b6c4f',214,'d858413a9b01463f96545916d2abe5ab','volumes_tripleo',1,'2025-12-03 10:15:07',NULL),('2025-12-02 10:15:07','2025-12-02 10:15:07','2025-12-02 10:15:07',1,892,'c16742a4-6f11-448d-8df0-1b4c4653aaa4',215,'d858413a9b01463f96545916d2abe5ab','gigabytes_tripleo',1,'2025-12-03 10:15:07',NULL),('2025-12-02 10:15:38','2025-12-02 10:15:38','2025-12-02 10:15:38',1,893,'808ab443-925c-4ffe-8b30-aee399a15fab',216,'d858413a9b01463f96545916d2abe5ab','backups',1,'2025-12-03 10:15:38',NULL),('2025-12-02 10:15:38','2025-12-02 10:15:38','2025-12-02 10:15:38',1,894,'b23ba8ed-fde7-4625-99ce-eefdcd89a1b9',217,'d858413a9b01463f96545916d2abe5ab','backup_gigabytes',1,'2025-12-03 10:15:38',NULL),('2025-12-02 10:15:42','2025-12-02 10:15:42','2025-12-02 10:15:42',1,895,'04bf27a1-351c-4028-826e-00dd2869a1f6',216,'d858413a9b01463f96545916d2abe5ab','backups',1,'2025-12-03 10:15:42',NULL),('2025-12-02 10:15:42','2025-12-02 10:15:42','2025-12-02 10:15:42',1,896,'0c846b05-077c-4b9f-9862-308734ab5ee6',217,'d858413a9b01463f96545916d2abe5ab','backup_gigabytes',1,'2025-12-03 10:15:42',NULL),('2025-12-02 10:15:47','2025-12-02 10:15:47','2025-12-02 10:15:47',1,897,'1941c5e4-4e12-46ab-a875-afdcae7de8d6',216,'d858413a9b01463f96545916d2abe5ab','backups',-1,'2025-12-03 10:15:47',NULL),('2025-12-02 10:15:47','2025-12-02 10:15:47','2025-12-02 10:15:47',1,898,'1a7d392e-29d6-4396-be49-c27595f36c6e',217,'d858413a9b01463f96545916d2abe5ab','backup_gigabytes',-1,'2025-12-03 10:15:47',NULL),('2025-12-02 10:15:47','2025-12-02 10:15:47','2025-12-02 10:15:47',1,899,'05f7db24-3d77-4d24-8bc6-d885a9174ef8',216,'d858413a9b01463f96545916d2abe5ab','backups',1,'2025-12-03 10:15:47',NULL),('2025-12-02 10:15:47','2025-12-02 10:15:47','2025-12-02 10:15:47',1,900,'0d354d9c-ca68-4b4a-b8f6-9890bb8c4cb4',217,'d858413a9b01463f96545916d2abe5ab','backup_gigabytes',1,'2025-12-03 10:15:47',NULL),('2025-12-02 10:15:51','2025-12-02 10:15:51','2025-12-02 10:15:51',1,901,'b045bbe7-a9cf-47a4-8258-7f2e60698333',216,'d858413a9b01463f96545916d2abe5ab','backups',-1,'2025-12-03 10:15:51',NULL),('2025-12-02 10:15:51','2025-12-02 10:15:51','2025-12-02 10:15:51',1,902,'d7eab6e3-f3ba-4e5f-b71e-1ce343c814ff',217,'d858413a9b01463f96545916d2abe5ab','backup_gigabytes',-1,'2025-12-03 10:15:51',NULL),('2025-12-02 10:15:53','2025-12-02 10:15:53','2025-12-02 10:15:53',1,903,'e32f93a6-8012-4381-9f86-2b9f720129e4',216,'d858413a9b01463f96545916d2abe5ab','backups',-1,'2025-12-03 10:15:53',NULL),('2025-12-02 10:15:53','2025-12-02 10:15:53','2025-12-02 10:15:53',1,904,'a1508568-f283-4562-a46c-9e1f83805441',217,'d858413a9b01463f96545916d2abe5ab','backup_gigabytes',-1,'2025-12-03 10:15:53',NULL),('2025-12-02 10:16:04','2025-12-02 10:16:04','2025-12-02 10:16:04',1,905,'592283d4-ef12-41ca-abac-b42eda60b80e',212,'d858413a9b01463f96545916d2abe5ab','volumes',-1,'2025-12-03 10:16:04',NULL),('2025-12-02 10:16:04','2025-12-02 10:16:04','2025-12-02 10:16:04',1,906,'5a6d2403-648f-4e39-80fe-58a2fe95cc4a',213,'d858413a9b01463f96545916d2abe5ab','gigabytes',-1,'2025-12-03 10:16:04',NULL),('2025-12-02 10:16:04','2025-12-02 10:16:04','2025-12-02 10:16:04',1,907,'fc5c336e-9e39-4d16-9610-68469c91fbec',214,'d858413a9b01463f96545916d2abe5ab','volumes_tripleo',-1,'2025-12-03 10:16:04',NULL),('2025-12-02 10:16:04','2025-12-02 10:16:04','2025-12-02 10:16:04',1,908,'912a0143-516e-4e08-bc75-cffafd8258b8',215,'d858413a9b01463f96545916d2abe5ab','gigabytes_tripleo',-1,'2025-12-03 10:16:04',NULL),('2025-12-02 10:16:11','2025-12-02 10:16:11','2025-12-02 10:16:11',1,909,'eb509920-6877-4eb2-9dbd-c2cc0b901ad5',218,'9357d59432e04f9791424e201b9754ce','volumes',1,'2025-12-03 10:16:11',NULL),('2025-12-02 10:16:11','2025-12-02 10:16:11','2025-12-02 10:16:11',1,910,'aac4f457-e186-407c-b9fe-fbad232abd51',219,'9357d59432e04f9791424e201b9754ce','gigabytes',2,'2025-12-03 10:16:11',NULL),('2025-12-02 10:16:11','2025-12-02 10:16:11','2025-12-02 10:16:11',1,911,'1175ecf0-7d83-41e9-99c5-b56c5d4b318d',220,'9357d59432e04f9791424e201b9754ce','volumes_tripleo',1,'2025-12-03 10:16:11',NULL),('2025-12-02 10:16:11','2025-12-02 10:16:11','2025-12-02 10:16:11',1,912,'9fd2a53f-7de4-4f79-b1d9-23df4394b08c',221,'9357d59432e04f9791424e201b9754ce','gigabytes_tripleo',2,'2025-12-03 10:16:11',NULL),('2025-12-02 10:16:12','2025-12-02 10:16:12','2025-12-02 10:16:12',1,913,'d3579f92-ef1b-4c9d-8087-5181c6593e52',222,'9357d59432e04f9791424e201b9754ce','snapshots',1,'2025-12-03 10:16:12',NULL),('2025-12-02 10:16:12','2025-12-02 10:16:12','2025-12-02 10:16:12',1,914,'40a1452b-706a-43fe-b21e-8aa9c24fb105',219,'9357d59432e04f9791424e201b9754ce','gigabytes',2,'2025-12-03 10:16:12',NULL),('2025-12-02 10:16:12','2025-12-02 10:16:12','2025-12-02 10:16:12',1,915,'7076934e-dc0a-4894-a372-70199d363118',221,'9357d59432e04f9791424e201b9754ce','gigabytes_tripleo',2,'2025-12-03 10:16:12',NULL),('2025-12-02 10:16:12','2025-12-02 10:16:12','2025-12-02 10:16:12',1,916,'ff3991c9-942a-46e5-9e0f-54a95e74f5e5',223,'9357d59432e04f9791424e201b9754ce','snapshots_tripleo',1,'2025-12-03 10:16:12',NULL),('2025-12-02 10:16:15','2025-12-02 10:16:15','2025-12-02 10:16:15',1,917,'7886d8aa-8a49-411c-8ab0-06a6d2627a25',222,'9357d59432e04f9791424e201b9754ce','snapshots',-1,'2025-12-03 10:16:15',NULL),('2025-12-02 10:16:15','2025-12-02 10:16:15','2025-12-02 10:16:15',1,918,'08018877-0790-42c2-8003-8a1451487972',219,'9357d59432e04f9791424e201b9754ce','gigabytes',-2,'2025-12-03 10:16:15',NULL),('2025-12-02 10:16:15','2025-12-02 10:16:15','2025-12-02 10:16:15',1,919,'2d2fee59-46e7-4338-be02-d7c5d0f501fd',221,'9357d59432e04f9791424e201b9754ce','gigabytes_tripleo',-2,'2025-12-03 10:16:15',NULL),('2025-12-02 10:16:15','2025-12-02 10:16:15','2025-12-02 10:16:15',1,920,'8031543a-5608-4863-9ab6-d0dae0eeab91',223,'9357d59432e04f9791424e201b9754ce','snapshots_tripleo',-1,'2025-12-03 10:16:15',NULL),('2025-12-02 10:16:17','2025-12-02 10:16:17','2025-12-02 10:16:17',1,921,'572f6808-98e3-4f27-b9be-6547892e1c10',218,'9357d59432e04f9791424e201b9754ce','volumes',-1,'2025-12-03 10:16:17',NULL),('2025-12-02 10:16:17','2025-12-02 10:16:17','2025-12-02 10:16:17',1,922,'1d5313ac-cb9c-4028-8e23-d0093097fc00',219,'9357d59432e04f9791424e201b9754ce','gigabytes',-2,'2025-12-03 10:16:17',NULL),('2025-12-02 10:16:17','2025-12-02 10:16:17','2025-12-02 10:16:17',1,923,'d2801168-8077-43ff-8cf6-da8b141aee50',220,'9357d59432e04f9791424e201b9754ce','volumes_tripleo',-1,'2025-12-03 10:16:17',NULL),('2025-12-02 10:16:17','2025-12-02 10:16:17','2025-12-02 10:16:17',1,924,'d3444ef5-a2d5-4aad-82f8-3390bf4d5dc8',221,'9357d59432e04f9791424e201b9754ce','gigabytes_tripleo',-2,'2025-12-03 10:16:17',NULL);
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `rpc_current_version` varchar(36) DEFAULT NULL,
  `object_current_version` varchar(36) DEFAULT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `frozen` tinyint(1) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `services_uuid_idx` (`uuid`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`disabled` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`frozen` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone`, `disabled_reason`, `modified_at`, `rpc_current_version`, `object_current_version`, `replication_status`, `frozen`, `active_backend_id`, `cluster_name`, `uuid`) VALUES ('2025-12-02 08:18:13','2025-12-02 08:56:44','2025-12-02 08:56:44',1,2,'np0005541909.localdomain','cinder-scheduler','cinder-scheduler',123,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'78511df4-d837-4b72-b7fa-4be4c3e92b9f'),('2025-12-02 08:18:29','2025-12-02 08:56:48','2025-12-02 08:56:48',1,5,'np0005541910.localdomain','cinder-scheduler','cinder-scheduler',122,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'62bf9a3f-d646-4455-9582-254646335787'),('2025-12-02 08:18:31','2025-12-02 08:56:50','2025-12-02 08:56:50',1,8,'np0005541911.localdomain','cinder-scheduler','cinder-scheduler',122,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'c401697f-3f2a-4d0f-8b8d-2826f8364f85'),('2025-12-02 08:21:52','2025-12-02 08:56:39','2025-12-02 08:56:39',1,11,'np0005541909.localdomain','cinder-backup','cinder-backup',145,0,'nova',NULL,NULL,'2.4','1.39','not-capable',0,NULL,NULL,'e807f8fc-2635-46e9-9a40-061b181de786'),('2025-12-02 08:22:28','2025-12-02 10:28:00',NULL,0,14,'hostgroup@tripleo_ceph','cinder-volume','cinder-volume',688,0,'nova',NULL,NULL,'3.18','1.39','disabled',0,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef'),('2025-12-02 08:56:55','2025-12-02 10:28:00',NULL,0,17,'cinder-scheduler-0','cinder-scheduler','cinder-scheduler',545,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'9ae4fc5e-ddb6-490b-b003-aab63eb6179a'),('2025-12-02 08:56:59','2025-12-02 10:28:00',NULL,0,18,'cinder-backup-0','cinder-backup','cinder-backup',546,0,'nova',NULL,NULL,'2.4','1.39','not-capable',0,NULL,NULL,'bc0c6413-caf8-4beb-afb7-bbbec5ca1de2');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot_metadata`
--

DROP TABLE IF EXISTS `snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshot_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `snapshot_metadata_ibfk_1` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot_metadata`
--

LOCK TABLES `snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `snapshot_metadata` DISABLE KEYS */;
INSERT INTO `snapshot_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `snapshot_id`, `key`, `value`) VALUES ('2025-12-02 10:12:56',NULL,'2025-12-02 10:12:58',1,1,'7799f8b4-274c-4b60-ae16-7411d622a925','snap-meta1','value1'),('2025-12-02 10:12:56',NULL,'2025-12-02 10:12:58',1,2,'7799f8b4-274c-4b60-ae16-7411d622a925','snap-meta2','value2'),('2025-12-02 10:12:56',NULL,'2025-12-02 10:12:58',1,3,'7799f8b4-274c-4b60-ae16-7411d622a925','snap-meta3','value3'),('2025-12-02 10:14:08','2025-12-02 10:14:08','2025-12-02 10:14:08',1,4,'5663a600-98cd-40f1-aceb-0c2e0343e036','key1','value1'),('2025-12-02 10:14:08','2025-12-02 10:14:08','2025-12-02 10:14:08',1,5,'5663a600-98cd-40f1-aceb-0c2e0343e036','key2','value2'),('2025-12-02 10:14:08','2025-12-02 10:14:08','2025-12-02 10:14:08',1,6,'5663a600-98cd-40f1-aceb-0c2e0343e036','key3','value3_update'),('2025-12-02 10:14:08','2025-12-02 10:14:09','2025-12-02 10:14:09',1,7,'5663a600-98cd-40f1-aceb-0c2e0343e036','key4','value4'),('2025-12-02 10:14:09','2025-12-02 10:14:09','2025-12-02 10:14:09',1,8,'5663a600-98cd-40f1-aceb-0c2e0343e036','key1','value1'),('2025-12-02 10:14:09','2025-12-02 10:14:09','2025-12-02 10:14:09',1,9,'5663a600-98cd-40f1-aceb-0c2e0343e036','key2','value2'),('2025-12-02 10:14:09','2025-12-02 10:14:09','2025-12-02 10:14:09',1,10,'5663a600-98cd-40f1-aceb-0c2e0343e036','key3','value3_update');
/*!40000 ALTER TABLE `snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshots`
--

DROP TABLE IF EXISTS `snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `volume_size` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `provider_auth` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshots_cgsnapshot_id` (`cgsnapshot_id`),
  KEY `ix_snapshots_group_snapshot_id` (`group_snapshot_id`),
  KEY `ix_snapshots_volume_id` (`volume_id`),
  KEY `snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `snapshots_ibfk_1` FOREIGN KEY (`cgsnapshot_id`) REFERENCES `cgsnapshots` (`id`),
  CONSTRAINT `snapshots_ibfk_2` FOREIGN KEY (`group_snapshot_id`) REFERENCES `group_snapshots` (`id`),
  CONSTRAINT `snapshots_volume_id_fkey` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshots`
--

LOCK TABLES `snapshots` WRITE;
/*!40000 ALTER TABLE `snapshots` DISABLE KEYS */;
INSERT INTO `snapshots` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `status`, `progress`, `volume_size`, `scheduled_at`, `display_name`, `display_description`, `provider_location`, `encryption_key_id`, `volume_type_id`, `cgsnapshot_id`, `provider_id`, `provider_auth`, `group_snapshot_id`, `use_quota`) VALUES ('2025-12-02 10:14:26','2025-12-02 10:14:33','2025-12-02 10:14:34',1,'0657ec2c-ff19-4168-b880-80c452fe8176','73f0b320-6d2a-4bf6-924d-581f9898933f','cfa340769a434813a589cf5cb369e58c','ab2f308df5874752ab8cc95304b7b442','deleted','100%',1,NULL,'tempest-VolumesSnapshotListTestJSON-Snapshot-2133767507',NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,NULL,NULL,NULL,1),('2025-12-02 10:08:30','2025-12-02 10:08:33','2025-12-02 10:08:33',1,'197c154b-fa91-4781-955a-54f44cb6ed1f','a50f5eae-b4d3-48b9-a205-07c366acbf05','e106d79b62e54215bcadae87f431c1b2','6963976a36c6408c9336062feaef5d1f','deleted','100%',1,NULL,'tempest-group_snapshot-1294064754',NULL,NULL,NULL,'94d93296-ae39-48e1-95cb-44617d586e86',NULL,NULL,NULL,'db3be1b8-5c21-4f21-9265-75f9205b869b',1),('2025-12-02 10:06:55','2025-12-02 10:06:57','2025-12-02 10:06:57',1,'2c650ece-a1d3-48ca-9da3-c0590b0b4d8e','79e6dc38-5092-4b61-b2e2-81d3777f5f9e','39ac23db08db4b5b981bf56813fe3813','1e139fe20a514d12b866b3c8974dcebd','deleted','100%',1,NULL,'tempest-SnapshotsActionsTest-Snapshot-1965558890',NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,NULL,NULL,NULL,1),('2025-12-02 10:13:00','2025-12-02 10:13:01','2025-12-02 10:13:03',1,'3186b2fe-f00d-41a6-b6c8-d9110022b87b','3fbaf516-b660-4e9b-aadb-3977193df132','b99fb9e02616408da5b39544cad2c70f','8943858eee964ad7920643441a49ca76','deleted','100%',1,NULL,'tempest-VolumeSnapshotQuotasNegativeTestJSON-Snapshot-1481540743',NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,NULL,NULL,NULL,1),('2025-12-02 10:06:51','2025-12-02 10:06:53','2025-12-02 10:06:54',1,'3262dc6a-9947-471d-9c9b-869f040aa775','79e6dc38-5092-4b61-b2e2-81d3777f5f9e','39ac23db08db4b5b981bf56813fe3813','1e139fe20a514d12b866b3c8974dcebd','deleted','100%',1,NULL,'tempest-SnapshotsActionsTest-Snapshot-1860169360',NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,NULL,NULL,NULL,1),('2025-12-02 10:06:58','2025-12-02 10:07:01','2025-12-02 10:07:03',1,'3678f59b-33c1-49b8-a055-7ce08056eb05','79e6dc38-5092-4b61-b2e2-81d3777f5f9e','39ac23db08db4b5b981bf56813fe3813','1e139fe20a514d12b866b3c8974dcebd','deleted','100%',1,NULL,'tempest-SnapshotsActionsTest-Snapshot-1122080477',NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,NULL,NULL,NULL,1),('2025-12-02 10:16:12','2025-12-02 10:16:14','2025-12-02 10:16:15',1,'3cb72d02-86e0-4936-9248-b4ac03ec41b8','691d4665-8c31-40ca-becb-5153dcec98c3','4cf4e412f7aa4b38937a59c19a460b6a','9357d59432e04f9791424e201b9754ce','deleted','100%',2,NULL,'tempest-VolumesSnapshotNegativeTestJSON-Snapshot-1611976629',NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,NULL,NULL,NULL,1),('2025-12-02 10:13:01','2025-12-02 10:13:04','2025-12-02 10:13:05',1,'4af51a3f-f41a-42cf-956c-674f8bdb8b65','ead6103e-9744-4b5e-802a-67aac454ec1c','fb6c45ae0e4b4c359e6ea41cecfc33c8','b374ce45b6dc4bc5b2eac77a9216133f','deleted','100%',1,NULL,'tempest-VolumesSnapshotTestJSON-Snapshot-1668655355',NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,NULL,NULL,NULL,1),('2025-12-02 10:08:20','2025-12-02 10:08:25','2025-12-02 10:08:25',1,'4d24d926-e53c-40ed-98b0-e92260c9a339','662c48bb-d1e2-4dac-ac96-0a25b2ea4fc4','e106d79b62e54215bcadae87f431c1b2','6963976a36c6408c9336062feaef5d1f','deleted','100%',1,NULL,'tempest-GroupSnapshotsTest-Group_Snapshot-61574974',NULL,NULL,NULL,'f0e8cfb1-538e-44db-a3d8-153ab63f83a0',NULL,NULL,NULL,'66e037b9-52ee-470e-b595-01d75219f6ea',1),('2025-12-02 10:14:06','2025-12-02 10:14:09','2025-12-02 10:14:10',1,'5663a600-98cd-40f1-aceb-0c2e0343e036','a9ee74e1-e820-4856-9017-a6bfc85192ec','0e8b63c8d4794f7d8443e7392bf8e840','8f287097241a4419b0923dfc81ea1206','deleted','100%',1,NULL,'tempest-SnapshotMetadataTestJSON-Snapshot-1454253014',NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,NULL,NULL,NULL,1),('2025-12-02 10:13:08','2025-12-02 10:13:11','2025-12-02 10:13:13',1,'5aff86be-8231-496d-9a73-0903eeb7284c','2e7b260c-1271-44f7-912c-ae60e176ac11','fb6c45ae0e4b4c359e6ea41cecfc33c8','b374ce45b6dc4bc5b2eac77a9216133f','deleted','100%',1,NULL,'tempest-VolumesSnapshotTestJSON-Snapshot-625456913',NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,NULL,NULL,NULL,1),('2025-12-02 10:08:02','2025-12-02 10:08:08','2025-12-02 10:08:08',1,'6db489ca-cff2-4ddf-b855-b643f7ed7876','38cddbb0-587f-411a-9140-287fb30bb126','e106d79b62e54215bcadae87f431c1b2','6963976a36c6408c9336062feaef5d1f','deleted','100%',1,NULL,'tempest-group_snapshot-1384762168',NULL,NULL,NULL,'76e7ac3c-8039-466a-8011-24ff10e9b99d',NULL,NULL,NULL,'691970ab-9dc7-425a-9d55-766ba3aebd7a',1),('2025-12-02 10:14:23','2025-12-02 10:14:25','2025-12-02 10:14:32',1,'7714b687-1061-4397-8fc8-722ed9748e46','86339aa1-2726-467a-a1cd-44db4f65aaf5','7c253b4d05e4467b847ce7c505213640','d3daa40d2d6446d8b0b46a9f7d1b779c','deleted','100%',1,NULL,'tempest-VolumesDeleteCascade-Snapshot-56775255',NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,NULL,NULL,NULL,1),('2025-12-02 10:12:56','2025-12-02 10:12:57','2025-12-02 10:12:58',1,'7799f8b4-274c-4b60-ae16-7411d622a925','e7b291f0-5337-403a-93d2-d7ade4ecb725','fb6c45ae0e4b4c359e6ea41cecfc33c8','b374ce45b6dc4bc5b2eac77a9216133f','deleted','100%',1,NULL,'tempest-VolumesSnapshotTestJSON-new-snap-1530429975','This is the new description of snapshot.',NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,NULL,NULL,NULL,1),('2025-12-02 10:12:12','2025-12-02 10:12:16','2025-12-02 10:12:16',1,'85703cc9-a1fb-4b84-80b1-f3ee273c7231','ed240847-57fd-4620-b037-cb19f8ca301b','7ecf77dbd2574788a6586386d97ee38c','f5466a94421d4e84977ee830576dd8b7','deleted','100%',1,NULL,'tempest-VolumesExtendTest-Snapshot-1949634349',NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,NULL,NULL,NULL,1),('2025-12-02 10:12:37','2025-12-02 10:12:55','2025-12-02 10:12:55',1,'9db0dee4-3e58-4b54-b9df-699849460495','e7b291f0-5337-403a-93d2-d7ade4ecb725','fb6c45ae0e4b4c359e6ea41cecfc33c8','b374ce45b6dc4bc5b2eac77a9216133f','deleted','100%',1,NULL,'tempest-VolumesSnapshotTestJSON-Snapshot-716196986',NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,NULL,NULL,NULL,1),('2025-12-02 10:14:16','2025-12-02 10:14:18','2025-12-02 10:14:19',1,'9f6f1ee0-0104-4de5-add0-553f18060e59','b7e7d911-0a2c-4b80-a974-a47f4c66d00d','7c253b4d05e4467b847ce7c505213640','d3daa40d2d6446d8b0b46a9f7d1b779c','deleted','100%',1,NULL,'tempest-VolumesDeleteCascade-Snapshot-1165317888',NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,NULL,NULL,NULL,1),('2025-12-02 10:06:46','2025-12-02 10:07:04','2025-12-02 10:07:05',1,'a806d3c3-b819-4233-9c13-c21b857f6979','79e6dc38-5092-4b61-b2e2-81d3777f5f9e','39ac23db08db4b5b981bf56813fe3813','1e139fe20a514d12b866b3c8974dcebd','deleted','80%',1,NULL,'tempest-SnapshotsActionsTest-Snapshot-1419398816',NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,NULL,NULL,NULL,1),('2025-12-02 10:12:29','2025-12-02 10:12:32','2025-12-02 10:12:32',1,'af90de80-56fb-4bcd-8a20-828372efac9c','6e329b91-ab8f-450c-8632-855f11c6f5b5','655d9191fb2f408c917a6a9ed2235d2d','6b4f1f3dd8704e9992f1bc11c793a60e','deleted','100%',1,NULL,'tempest-GroupSnapshotsV319Test-Group_Snapshot-1341650730',NULL,NULL,NULL,'5264be6d-39ee-4356-a8c7-079164c1a2db',NULL,NULL,NULL,'28e88a83-8a08-406f-8a84-b50710050e8b',1),('2025-12-02 10:14:24','2025-12-02 10:14:35','2025-12-02 10:14:36',1,'ba229d61-0613-4caa-812f-704ae57a296d','73f0b320-6d2a-4bf6-924d-581f9898933f','cfa340769a434813a589cf5cb369e58c','ab2f308df5874752ab8cc95304b7b442','deleted','100%',1,NULL,'tempest-VolumesSnapshotListTestJSON-Snapshot-1362439571',NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,NULL,NULL,NULL,1),('2025-12-02 10:14:17','2025-12-02 10:14:18','2025-12-02 10:14:20',1,'c304ede1-0da4-452a-997d-cc3656911c71','b7e7d911-0a2c-4b80-a974-a47f4c66d00d','7c253b4d05e4467b847ce7c505213640','d3daa40d2d6446d8b0b46a9f7d1b779c','deleted','100%',1,NULL,'tempest-VolumesDeleteCascade-Snapshot-1107930985',NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,NULL,NULL,NULL,1),('2025-12-02 10:08:20','2025-12-02 10:08:25','2025-12-02 10:08:25',1,'d6edfc01-2286-4325-b994-9eca23901229','bf0dd85f-186a-4a0f-94ee-666321d9e0fb','e106d79b62e54215bcadae87f431c1b2','6963976a36c6408c9336062feaef5d1f','deleted','100%',1,NULL,'tempest-GroupSnapshotsTest-Group_Snapshot-61574974',NULL,NULL,NULL,'f0e8cfb1-538e-44db-a3d8-153ab63f83a0',NULL,NULL,NULL,'66e037b9-52ee-470e-b595-01d75219f6ea',1),('2025-12-02 10:14:29','2025-12-02 10:14:31','2025-12-02 10:14:32',1,'e8bfff6e-2f81-4bd2-a11a-8a5cf7dacf97','73f0b320-6d2a-4bf6-924d-581f9898933f','cfa340769a434813a589cf5cb369e58c','ab2f308df5874752ab8cc95304b7b442','deleted','100%',1,NULL,'tempest-VolumesSnapshotListTestJSON-Snapshot-23393407',NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,NULL,NULL,NULL,1),('2025-12-02 10:06:48','2025-12-02 10:06:49','2025-12-02 10:06:50',1,'f16e7217-bcd2-4caf-89f4-7dea9d29b75e','79e6dc38-5092-4b61-b2e2-81d3777f5f9e','39ac23db08db4b5b981bf56813fe3813','1e139fe20a514d12b866b3c8974dcebd','deleted','100%',1,NULL,'tempest-SnapshotsActionsTest-Snapshot-235409260',NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,NULL,NULL,NULL,1);
/*!40000 ALTER TABLE `snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `no_snapshots` tinyint(1) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_transfers_volume_id` (`volume_id`),
  CONSTRAINT `transfers_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`no_snapshots` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
INSERT INTO `transfers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `display_name`, `salt`, `crypt_hash`, `expires_at`, `no_snapshots`, `source_project_id`, `destination_project_id`, `accepted`) VALUES ('2025-12-02 10:07:22',NULL,'2025-12-02 10:07:23',1,'1098b0de-bf4c-4dea-b468-cb6d6e739cf9','dc1592d7-3d76-4279-b9b3-ab3b5f9b73f5',NULL,'65a0a01e','2fa915bcd407c15ab4d1340d0849190ed2782f5a',NULL,0,'0b96bacd92de4f1aa310d96b02e2ba1b','00428a58903e487bb33ddf74c19e4f17',1),('2025-12-02 10:13:46',NULL,'2025-12-02 10:13:46',1,'13a2b092-ddb0-4c7c-b827-6219bbe9d461','b590ebd4-a5d6-44b2-9682-148d22e4a757',NULL,'860ecc3b','12a946034ee7e6b93c4b059fec65d36953d2d264',NULL,0,'08ec4508e51e4b46972baa016cc404c1','1259cb721f554d769bcd146b925c03fd',1),('2025-12-02 10:11:12',NULL,'2025-12-02 10:11:14',1,'3bec7e10-8469-4d56-98a2-c8b1279b6e3d','ed487828-83c9-4bbe-893f-a4ca97b0f22b',NULL,'c2607933','8d22ecc413a80a9f864d297f8d911ce1c7d78541',NULL,0,'fef053541b4b4785ab9899f41b37c328','efbd1cf12d1441269b72130fc6cf60d9',1),('2025-12-02 10:11:57',NULL,'2025-12-02 10:11:57',1,'6da4d5f6-33b9-499d-b865-0d65efee4cd6','e26a8c85-beb7-4c28-b53b-e10f72b9d310',NULL,'9baf5ff1','29c2f33cf29b2c4335a7ade7888e69f0d2a91b83',NULL,0,'ab84e521dda9432ca7d62c5185f1eaab','2267b5d8ec1242618341cd359607d279',1),('2025-12-02 10:07:27',NULL,'2025-12-02 10:07:27',1,'b54d5c2b-d552-4ab8-b077-fbc3eca5595b','fabffb7b-cc3e-4c4e-8176-72d336e8a67b',NULL,'5ff4eef0','e2285b810537af95b18633d2e6cf5bbdc555ce0a',NULL,0,'0b96bacd92de4f1aa310d96b02e2ba1b',NULL,0),('2025-12-02 10:13:49',NULL,'2025-12-02 10:13:49',1,'da67a039-37ee-404f-a0d0-fa0fdf7f57ab','35fad08b-b752-4c38-8266-9e02097f6d0d',NULL,'3c9875f5','2facad19cae3ad43a1db59be625cb535d583473d',NULL,0,'08ec4508e51e4b46972baa016cc404c1',NULL,0),('2025-12-02 10:12:00',NULL,'2025-12-02 10:12:00',1,'f5f1e56e-7180-436a-97ba-33446c3f65f9','03d46358-cfaa-4e7e-ae84-b6eaebac0d00',NULL,'3c0874c2','a8961dab4e5215ca4650f04a9019639c340d5244',NULL,0,'ab84e521dda9432ca7d62c5185f1eaab',NULL,0);
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_admin_metadata`
--

DROP TABLE IF EXISTS `volume_admin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_admin_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_admin_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_admin_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_admin_metadata`
--

LOCK TABLES `volume_admin_metadata` WRITE;
/*!40000 ALTER TABLE `volume_admin_metadata` DISABLE KEYS */;
INSERT INTO `volume_admin_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `key`, `value`) VALUES ('2025-12-02 10:10:05','2025-12-02 10:10:05','2025-12-02 10:10:52',1,1,'acc6c364-50bc-441b-bb2f-7b57cca0f5b6','readonly','False'),('2025-12-02 10:12:38',NULL,'2025-12-02 10:12:53',1,2,'dd1dfc0e-0d5c-47a6-a4b3-34e6664b2242','temporary','True');
/*!40000 ALTER TABLE `volume_admin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_attachment`
--

DROP TABLE IF EXISTS `volume_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_attachment` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `attached_host` varchar(255) DEFAULT NULL,
  `instance_uuid` varchar(36) DEFAULT NULL,
  `mountpoint` varchar(255) DEFAULT NULL,
  `attach_time` datetime DEFAULT NULL,
  `detach_time` datetime DEFAULT NULL,
  `attach_mode` varchar(36) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `connection_info` text DEFAULT NULL,
  `connector` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_attachment_volume_id` (`volume_id`),
  CONSTRAINT `volume_attachment_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_attachment`
--

LOCK TABLES `volume_attachment` WRITE;
/*!40000 ALTER TABLE `volume_attachment` DISABLE KEYS */;
INSERT INTO `volume_attachment` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `attached_host`, `instance_uuid`, `mountpoint`, `attach_time`, `detach_time`, `attach_mode`, `attach_status`, `connection_info`, `connector`) VALUES ('2025-12-02 10:15:36','2025-12-02 10:15:54','2025-12-02 10:15:54',1,'df45d2d8-6af6-424c-887e-0dc643e47ee7','eb88c64a-7c29-421c-91ad-190ba7bbf450','np0005541914.localdomain','e4135ac9-548a-4e8d-99d6-cde8dedb2c77','/dev/vdb','2025-12-02 10:15:38','2025-12-02 10:15:54','rw','detached','{\"name\": \"volumes/volume-eb88c64a-7c29-421c-91ad-190ba7bbf450\", \"hosts\": [\"172.18.0.103\", \"172.18.0.104\", \"172.18.0.105\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"c7c8e171-a193-56fb-95fa-8879fcfa7074\", \"volume_id\": \"eb88c64a-7c29-421c-91ad-190ba7bbf450\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"df45d2d8-6af6-424c-887e-0dc643e47ee7\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.108\", \"host\": \"np0005541914.localdomain\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:cd5f4359d661\", \"do_local_attach\": false, \"nvme_hostid\": \"64aa5208-7bf7-490c-857b-3c1a3cae8bb3\", \"system uuid\": \"64aa5208-7bf7-490c-857b-3c1a3cae8bb3\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:64aa5208-7bf7-490c-857b-3c1a3cae8bb3\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}');
/*!40000 ALTER TABLE `volume_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_glance_metadata`
--

DROP TABLE IF EXISTS `volume_glance_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_glance_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_glance_metadata_snapshot_id` (`snapshot_id`),
  KEY `ix_volume_glance_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_glance_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `volume_glance_metadata_ibfk_2` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_glance_metadata`
--

LOCK TABLES `volume_glance_metadata` WRITE;
/*!40000 ALTER TABLE `volume_glance_metadata` DISABLE KEYS */;
INSERT INTO `volume_glance_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `snapshot_id`, `key`, `value`) VALUES ('2025-12-02 10:09:37',NULL,'2025-12-02 10:09:42',1,1,'52cac4dd-69ca-4e69-adbd-f821188d6658',NULL,'signature_verified','False'),('2025-12-02 10:09:41',NULL,'2025-12-02 10:09:42',1,2,'52cac4dd-69ca-4e69-adbd-f821188d6658',NULL,'hw_rng_model','virtio'),('2025-12-02 10:09:41','2025-12-02 10:09:41','2025-12-02 10:09:42',1,3,'52cac4dd-69ca-4e69-adbd-f821188d6658',NULL,'image_id','5137a025-3c5f-43c1-bc64-5f41270040a5'),('2025-12-02 10:09:41','2025-12-02 10:09:41','2025-12-02 10:09:42',1,4,'52cac4dd-69ca-4e69-adbd-f821188d6658',NULL,'image_name','image'),('2025-12-02 10:09:41',NULL,'2025-12-02 10:09:42',1,5,'52cac4dd-69ca-4e69-adbd-f821188d6658',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-02 10:09:41',NULL,'2025-12-02 10:09:42',1,6,'52cac4dd-69ca-4e69-adbd-f821188d6658',NULL,'container_format','bare'),('2025-12-02 10:09:41',NULL,'2025-12-02 10:09:42',1,7,'52cac4dd-69ca-4e69-adbd-f821188d6658',NULL,'disk_format','qcow2'),('2025-12-02 10:09:41',NULL,'2025-12-02 10:09:42',1,8,'52cac4dd-69ca-4e69-adbd-f821188d6658',NULL,'min_disk','0'),('2025-12-02 10:09:41',NULL,'2025-12-02 10:09:42',1,9,'52cac4dd-69ca-4e69-adbd-f821188d6658',NULL,'min_ram','0'),('2025-12-02 10:09:41',NULL,'2025-12-02 10:09:42',1,10,'52cac4dd-69ca-4e69-adbd-f821188d6658',NULL,'size','21430272'),('2025-12-02 10:09:41',NULL,'2025-12-02 10:09:42',1,11,'52cac4dd-69ca-4e69-adbd-f821188d6658',NULL,'kernel_id','6ff710d2-942b-4d6b-9168-8c9cc2404ab1'),('2025-12-02 10:09:41',NULL,'2025-12-02 10:09:42',1,12,'52cac4dd-69ca-4e69-adbd-f821188d6658',NULL,'ramdisk_id','somedisk'),('2025-12-02 10:11:34',NULL,'2025-12-02 10:11:45',1,13,'ef2d1fbc-983a-4189-ad23-d6a0105071a9',NULL,'signature_verified','False'),('2025-12-02 10:11:38',NULL,'2025-12-02 10:11:45',1,14,'ef2d1fbc-983a-4189-ad23-d6a0105071a9',NULL,'hw_rng_model','virtio'),('2025-12-02 10:11:38',NULL,'2025-12-02 10:11:45',1,15,'ef2d1fbc-983a-4189-ad23-d6a0105071a9',NULL,'image_id','d85e840d-fa56-497b-b5bd-b49584d3e97a'),('2025-12-02 10:11:38',NULL,'2025-12-02 10:11:45',1,16,'ef2d1fbc-983a-4189-ad23-d6a0105071a9',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-02 10:11:38',NULL,'2025-12-02 10:11:45',1,17,'ef2d1fbc-983a-4189-ad23-d6a0105071a9',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-02 10:11:38',NULL,'2025-12-02 10:11:45',1,18,'ef2d1fbc-983a-4189-ad23-d6a0105071a9',NULL,'container_format','bare'),('2025-12-02 10:11:38',NULL,'2025-12-02 10:11:45',1,19,'ef2d1fbc-983a-4189-ad23-d6a0105071a9',NULL,'disk_format','qcow2'),('2025-12-02 10:11:38',NULL,'2025-12-02 10:11:45',1,20,'ef2d1fbc-983a-4189-ad23-d6a0105071a9',NULL,'min_disk','0'),('2025-12-02 10:11:38',NULL,'2025-12-02 10:11:45',1,21,'ef2d1fbc-983a-4189-ad23-d6a0105071a9',NULL,'min_ram','0'),('2025-12-02 10:11:38',NULL,'2025-12-02 10:11:45',1,22,'ef2d1fbc-983a-4189-ad23-d6a0105071a9',NULL,'size','21430272'),('2025-12-02 10:11:42',NULL,'2025-12-02 10:11:43',1,23,'8a641c39-7b20-4636-93b9-614bcab0245c',NULL,'signature_verified','False'),('2025-12-02 10:11:42',NULL,'2025-12-02 10:11:43',1,24,'8a641c39-7b20-4636-93b9-614bcab0245c',NULL,'hw_rng_model','virtio'),('2025-12-02 10:11:42',NULL,'2025-12-02 10:11:43',1,25,'8a641c39-7b20-4636-93b9-614bcab0245c',NULL,'image_id','d85e840d-fa56-497b-b5bd-b49584d3e97a'),('2025-12-02 10:11:42',NULL,'2025-12-02 10:11:43',1,26,'8a641c39-7b20-4636-93b9-614bcab0245c',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-02 10:11:42',NULL,'2025-12-02 10:11:43',1,27,'8a641c39-7b20-4636-93b9-614bcab0245c',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-02 10:11:42',NULL,'2025-12-02 10:11:43',1,28,'8a641c39-7b20-4636-93b9-614bcab0245c',NULL,'container_format','bare'),('2025-12-02 10:11:42',NULL,'2025-12-02 10:11:43',1,29,'8a641c39-7b20-4636-93b9-614bcab0245c',NULL,'disk_format','qcow2'),('2025-12-02 10:11:42',NULL,'2025-12-02 10:11:43',1,30,'8a641c39-7b20-4636-93b9-614bcab0245c',NULL,'min_disk','0'),('2025-12-02 10:11:42',NULL,'2025-12-02 10:11:43',1,31,'8a641c39-7b20-4636-93b9-614bcab0245c',NULL,'min_ram','0'),('2025-12-02 10:11:42',NULL,'2025-12-02 10:11:43',1,32,'8a641c39-7b20-4636-93b9-614bcab0245c',NULL,'size','21430272'),('2025-12-02 10:12:04',NULL,'2025-12-02 10:12:10',1,33,'13e5239b-d7cc-40f3-9a5b-427c7d2b3d77',NULL,'signature_verified','False'),('2025-12-02 10:12:08',NULL,'2025-12-02 10:12:10',1,34,'13e5239b-d7cc-40f3-9a5b-427c7d2b3d77',NULL,'hw_rng_model','virtio'),('2025-12-02 10:12:08',NULL,'2025-12-02 10:12:10',1,35,'13e5239b-d7cc-40f3-9a5b-427c7d2b3d77',NULL,'image_id','d85e840d-fa56-497b-b5bd-b49584d3e97a'),('2025-12-02 10:12:08',NULL,'2025-12-02 10:12:10',1,36,'13e5239b-d7cc-40f3-9a5b-427c7d2b3d77',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-02 10:12:08',NULL,'2025-12-02 10:12:10',1,37,'13e5239b-d7cc-40f3-9a5b-427c7d2b3d77',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-02 10:12:08',NULL,'2025-12-02 10:12:10',1,38,'13e5239b-d7cc-40f3-9a5b-427c7d2b3d77',NULL,'container_format','bare'),('2025-12-02 10:12:08',NULL,'2025-12-02 10:12:10',1,39,'13e5239b-d7cc-40f3-9a5b-427c7d2b3d77',NULL,'disk_format','qcow2'),('2025-12-02 10:12:08',NULL,'2025-12-02 10:12:10',1,40,'13e5239b-d7cc-40f3-9a5b-427c7d2b3d77',NULL,'min_disk','0'),('2025-12-02 10:12:08',NULL,'2025-12-02 10:12:10',1,41,'13e5239b-d7cc-40f3-9a5b-427c7d2b3d77',NULL,'min_ram','0'),('2025-12-02 10:12:08',NULL,'2025-12-02 10:12:10',1,42,'13e5239b-d7cc-40f3-9a5b-427c7d2b3d77',NULL,'size','21430272'),('2025-12-02 10:14:12',NULL,'2025-12-02 10:14:20',1,43,'a20df562-08c1-49f9-aa90-dd9d8debbf47',NULL,'signature_verified','False'),('2025-12-02 10:14:16',NULL,'2025-12-02 10:14:20',1,44,'a20df562-08c1-49f9-aa90-dd9d8debbf47',NULL,'hw_rng_model','virtio'),('2025-12-02 10:14:16',NULL,'2025-12-02 10:14:20',1,45,'a20df562-08c1-49f9-aa90-dd9d8debbf47',NULL,'image_id','d85e840d-fa56-497b-b5bd-b49584d3e97a'),('2025-12-02 10:14:16',NULL,'2025-12-02 10:14:20',1,46,'a20df562-08c1-49f9-aa90-dd9d8debbf47',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-02 10:14:16',NULL,'2025-12-02 10:14:20',1,47,'a20df562-08c1-49f9-aa90-dd9d8debbf47',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-02 10:14:16',NULL,'2025-12-02 10:14:20',1,48,'a20df562-08c1-49f9-aa90-dd9d8debbf47',NULL,'container_format','bare'),('2025-12-02 10:14:16',NULL,'2025-12-02 10:14:20',1,49,'a20df562-08c1-49f9-aa90-dd9d8debbf47',NULL,'disk_format','qcow2'),('2025-12-02 10:14:16',NULL,'2025-12-02 10:14:20',1,50,'a20df562-08c1-49f9-aa90-dd9d8debbf47',NULL,'min_disk','0'),('2025-12-02 10:14:16',NULL,'2025-12-02 10:14:20',1,51,'a20df562-08c1-49f9-aa90-dd9d8debbf47',NULL,'min_ram','0'),('2025-12-02 10:14:16',NULL,'2025-12-02 10:14:20',1,52,'a20df562-08c1-49f9-aa90-dd9d8debbf47',NULL,'size','21430272'),('2025-12-02 10:14:48',NULL,'2025-12-02 10:15:06',1,53,'985ad36b-4413-4129-a7fb-6c33ca008a44',NULL,'signature_verified','False'),('2025-12-02 10:14:51',NULL,'2025-12-02 10:15:06',1,54,'985ad36b-4413-4129-a7fb-6c33ca008a44',NULL,'hw_rng_model','virtio'),('2025-12-02 10:14:51',NULL,'2025-12-02 10:15:06',1,55,'985ad36b-4413-4129-a7fb-6c33ca008a44',NULL,'image_id','d85e840d-fa56-497b-b5bd-b49584d3e97a'),('2025-12-02 10:14:51',NULL,'2025-12-02 10:15:06',1,56,'985ad36b-4413-4129-a7fb-6c33ca008a44',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-02 10:14:51',NULL,'2025-12-02 10:15:06',1,57,'985ad36b-4413-4129-a7fb-6c33ca008a44',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-02 10:14:51',NULL,'2025-12-02 10:15:06',1,58,'985ad36b-4413-4129-a7fb-6c33ca008a44',NULL,'container_format','bare'),('2025-12-02 10:14:51',NULL,'2025-12-02 10:15:06',1,59,'985ad36b-4413-4129-a7fb-6c33ca008a44',NULL,'disk_format','qcow2'),('2025-12-02 10:14:51',NULL,'2025-12-02 10:15:06',1,60,'985ad36b-4413-4129-a7fb-6c33ca008a44',NULL,'min_disk','0'),('2025-12-02 10:14:51',NULL,'2025-12-02 10:15:06',1,61,'985ad36b-4413-4129-a7fb-6c33ca008a44',NULL,'min_ram','0'),('2025-12-02 10:14:51',NULL,'2025-12-02 10:15:06',1,62,'985ad36b-4413-4129-a7fb-6c33ca008a44',NULL,'size','21430272'),('2025-12-02 10:14:59',NULL,'2025-12-02 10:15:01',1,63,'fb26f3c4-7b9f-4e89-9327-d625b9a7aae0',NULL,'signature_verified','False'),('2025-12-02 10:14:59',NULL,'2025-12-02 10:15:01',1,64,'fb26f3c4-7b9f-4e89-9327-d625b9a7aae0',NULL,'hw_rng_model','virtio'),('2025-12-02 10:14:59',NULL,'2025-12-02 10:15:01',1,65,'fb26f3c4-7b9f-4e89-9327-d625b9a7aae0',NULL,'image_id','d85e840d-fa56-497b-b5bd-b49584d3e97a'),('2025-12-02 10:14:59',NULL,'2025-12-02 10:15:01',1,66,'fb26f3c4-7b9f-4e89-9327-d625b9a7aae0',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-02 10:14:59',NULL,'2025-12-02 10:15:01',1,67,'fb26f3c4-7b9f-4e89-9327-d625b9a7aae0',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-02 10:14:59',NULL,'2025-12-02 10:15:01',1,68,'fb26f3c4-7b9f-4e89-9327-d625b9a7aae0',NULL,'container_format','bare'),('2025-12-02 10:14:59',NULL,'2025-12-02 10:15:01',1,69,'fb26f3c4-7b9f-4e89-9327-d625b9a7aae0',NULL,'disk_format','qcow2'),('2025-12-02 10:14:59',NULL,'2025-12-02 10:15:01',1,70,'fb26f3c4-7b9f-4e89-9327-d625b9a7aae0',NULL,'min_disk','0'),('2025-12-02 10:14:59',NULL,'2025-12-02 10:15:01',1,71,'fb26f3c4-7b9f-4e89-9327-d625b9a7aae0',NULL,'min_ram','0'),('2025-12-02 10:14:59',NULL,'2025-12-02 10:15:01',1,72,'fb26f3c4-7b9f-4e89-9327-d625b9a7aae0',NULL,'size','21430272');
/*!40000 ALTER TABLE `volume_glance_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_metadata`
--

DROP TABLE IF EXISTS `volume_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_metadata`
--

LOCK TABLES `volume_metadata` WRITE;
/*!40000 ALTER TABLE `volume_metadata` DISABLE KEYS */;
INSERT INTO `volume_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `key`, `value`) VALUES ('2025-12-02 10:11:56',NULL,'2025-12-02 10:11:59',1,1,'b28a7a85-dd39-4bd4-8551-fe72ab7b54c1','src_backup_id','a97915d7-8bec-441a-a834-34a6472a4134'),('2025-12-02 10:13:48','2025-12-02 10:13:48','2025-12-02 10:13:48',1,2,'1a5d6076-215e-4d88-b28a-6d3d5ed8ba93','key1','value1_update'),('2025-12-02 10:13:48','2025-12-02 10:13:48','2025-12-02 10:13:48',1,3,'1a5d6076-215e-4d88-b28a-6d3d5ed8ba93','key2','value2'),('2025-12-02 10:13:48','2025-12-02 10:13:48','2025-12-02 10:13:48',1,4,'1a5d6076-215e-4d88-b28a-6d3d5ed8ba93','key3','value3'),('2025-12-02 10:13:48','2025-12-02 10:13:48','2025-12-02 10:13:48',1,5,'1a5d6076-215e-4d88-b28a-6d3d5ed8ba93','key4','value4'),('2025-12-02 10:13:49','2025-12-02 10:13:49','2025-12-02 10:13:49',1,6,'1a5d6076-215e-4d88-b28a-6d3d5ed8ba93','key1','value1'),('2025-12-02 10:13:49','2025-12-02 10:13:49','2025-12-02 10:13:49',1,7,'1a5d6076-215e-4d88-b28a-6d3d5ed8ba93','key2','value2'),('2025-12-02 10:13:49','2025-12-02 10:13:49','2025-12-02 10:13:49',1,8,'1a5d6076-215e-4d88-b28a-6d3d5ed8ba93','key3','value3_update'),('2025-12-02 10:13:54',NULL,'2025-12-02 10:14:03',1,9,'48b592b4-9ef5-482d-b8f5-32963474ee28','Type','work'),('2025-12-02 10:13:55',NULL,'2025-12-02 10:14:01',1,10,'a0b70e5b-292c-4b65-80c3-686346bc8731','Type','work'),('2025-12-02 10:13:56',NULL,'2025-12-02 10:14:01',1,11,'c11c88c5-b22e-4001-a074-faef3f45ed65','Type','Test'),('2025-12-02 10:13:57',NULL,'2025-12-02 10:14:00',1,12,'40861eac-935f-43db-a174-64a3b8d432ff','Type','work'),('2025-12-02 10:14:02',NULL,'2025-12-02 10:14:08',1,13,'7a9c72af-aea7-454a-8917-378d8f870527','Type','Test'),('2025-12-02 10:14:10',NULL,'2025-12-02 10:14:20',1,14,'a20df562-08c1-49f9-aa90-dd9d8debbf47','Type','Test'),('2025-12-02 10:14:59',NULL,'2025-12-02 10:15:01',1,15,'fb26f3c4-7b9f-4e89-9327-d625b9a7aae0','src_backup_id','dd303304-b521-40c8-84ea-b15913b3f063');
/*!40000 ALTER TABLE `volume_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_extra_specs`
--

DROP TABLE IF EXISTS `volume_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_extra_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_type_extra_specs_volume_type_id` (`volume_type_id`),
  CONSTRAINT `volume_type_extra_specs_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_extra_specs`
--

LOCK TABLES `volume_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `volume_type_extra_specs` DISABLE KEYS */;
INSERT INTO `volume_type_extra_specs` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_type_id`, `key`, `value`) VALUES ('2025-12-02 10:07:45',NULL,'2025-12-02 10:07:45',1,1,'2f6a840c-ec28-4ba8-9076-6d5ce4cfd347','storage_protocol','iSCSI'),('2025-12-02 10:07:45',NULL,'2025-12-02 10:07:45',1,2,'2f6a840c-ec28-4ba8-9076-6d5ce4cfd347','vendor_name','Open Source'),('2025-12-02 10:08:56',NULL,'2025-12-02 10:08:58',1,3,'7aec2ec3-0f52-4014-9542-889120b6c0b7','storage_protocol','tempest-storage_protocol-48566015'),('2025-12-02 10:08:56',NULL,'2025-12-02 10:08:58',1,4,'7aec2ec3-0f52-4014-9542-889120b6c0b7','vendor_name','tempest-vendor_name-1450730068'),('2025-12-02 10:08:58',NULL,'2025-12-02 10:09:00',1,5,'b78562fc-514d-41c9-811e-8b473c928808','storage_protocol','tempest-storage_protocol-902725276'),('2025-12-02 10:08:58',NULL,'2025-12-02 10:09:00',1,6,'b78562fc-514d-41c9-811e-8b473c928808','vendor_name','tempest-vendor_name-1508801296'),('2025-12-02 10:13:22',NULL,'2025-12-02 10:13:22',1,7,'4d914409-ef4c-4d01-b028-04f85d7c9a35','spec3','val1'),('2025-12-02 10:13:22',NULL,'2025-12-02 10:13:22',1,8,'4d914409-ef4c-4d01-b028-04f85d7c9a35','spec1','val1'),('2025-12-02 10:13:22','2025-12-02 10:13:22','2025-12-02 10:13:22',1,9,'4d914409-ef4c-4d01-b028-04f85d7c9a35','spec2','val3'),('2025-12-02 10:13:22',NULL,'2025-12-02 10:13:22',1,10,'4d914409-ef4c-4d01-b028-04f85d7c9a35','spec4','val4'),('2025-12-02 10:13:40',NULL,'2025-12-02 10:13:40',1,11,'805802b7-a2e2-4ec6-a906-f1ac760d611e','spec1','val1');
/*!40000 ALTER TABLE `volume_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_projects`
--

DROP TABLE IF EXISTS `volume_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `volume_type_id` (`volume_type_id`,`project_id`,`deleted`),
  CONSTRAINT `volume_type_projects_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_projects`
--

LOCK TABLES `volume_type_projects` WRITE;
/*!40000 ALTER TABLE `volume_type_projects` DISABLE KEYS */;
INSERT INTO `volume_type_projects` (`id`, `created_at`, `updated_at`, `deleted_at`, `volume_type_id`, `project_id`, `deleted`) VALUES (1,'2025-12-02 10:13:12',NULL,'2025-12-02 10:13:14','70c2b608-d3a6-48ca-aa86-5e9464ff58b0','e40b394d064942f593402333dc8c9581',1),(2,'2025-12-02 10:13:15',NULL,'2025-12-02 10:13:15','91c8bdf8-ca62-40cd-968a-15982d8c8299','e40b394d064942f593402333dc8c9581',2),(3,'2025-12-02 10:13:15',NULL,'2025-12-02 10:13:15','91c8bdf8-ca62-40cd-968a-15982d8c8299','9933838df9304fc8bbb9de94c910f2fc',3);
/*!40000 ALTER TABLE `volume_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_types`
--

DROP TABLE IF EXISTS `volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `qos_specs_id` varchar(36) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_types_qos_specs_id` (`qos_specs_id`),
  CONSTRAINT `volume_types_ibfk_1` FOREIGN KEY (`qos_specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`is_public` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_types`
--

LOCK TABLES `volume_types` WRITE;
/*!40000 ALTER TABLE `volume_types` DISABLE KEYS */;
INSERT INTO `volume_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `qos_specs_id`, `is_public`, `description`) VALUES ('2025-12-02 10:13:27',NULL,'2025-12-02 10:13:27',1,'174992a3-8717-4d85-a42d-deee59040fd8','tempest-VolumeTypesNegativeTest-volume-type-1067333333',NULL,1,NULL),('2025-12-02 10:14:00','2025-12-02 10:14:00','2025-12-02 10:14:00',1,'1e761bf6-a50b-4026-8430-7d0d421bdd9f','tempest-QosSpecsTestJSON-volume-type-919120773',NULL,1,NULL),('2025-12-02 10:06:30',NULL,'2025-12-02 10:06:33',1,'2389989d-8f92-4f2b-8a8e-e38ad828dcbf','tempest-GroupsV320Test-volume-type-18547381',NULL,1,NULL),('2025-12-02 10:07:16',NULL,'2025-12-02 10:07:21',1,'246462fb-2afd-4b98-bd79-3779fcd53ea0','volume-type-2',NULL,1,NULL),('2025-12-02 10:07:45',NULL,'2025-12-02 10:07:45',1,'2f6a840c-ec28-4ba8-9076-6d5ce4cfd347','tempest-VolumeTypesTest-volume-type-361194066',NULL,1,'tempest-volume-type-description-1875208892'),('2025-12-02 10:14:00','2025-12-02 10:14:00','2025-12-02 10:14:00',1,'3be29052-50eb-4b63-8ba2-718b111da29e','tempest-QosSpecsTestJSON-volume-type-1553040676',NULL,1,NULL),('2025-12-02 10:13:47',NULL,'2025-12-02 10:13:55',1,'4d121018-c823-4af0-88b4-28bf24456334','tempest-GroupsV314Test-volume-type-197107638',NULL,1,NULL),('2025-12-02 10:13:22',NULL,'2025-12-02 10:13:22',1,'4d914409-ef4c-4d01-b028-04f85d7c9a35','tempest-VolumeTypesExtraSpecsTest-volume-type-1741907169',NULL,1,NULL),('2025-12-02 10:12:26',NULL,'2025-12-02 10:12:34',1,'5264be6d-39ee-4356-a8c7-079164c1a2db','tempest-GroupSnapshotsV319Test-volume-type-1502590696',NULL,1,NULL),('2025-12-02 10:13:27',NULL,'2025-12-02 10:13:27',1,'574d3821-036f-48ce-b4f6-54c00432db5b','tempest-VolumeTypesNegativeTest-volume-type-640452494',NULL,0,NULL),('2025-12-02 10:14:00','2025-12-02 10:14:00','2025-12-02 10:14:00',1,'6d8b77a3-5d4b-4d18-9242-c7882590fe44','tempest-QosSpecsTestJSON-volume-type-384423397',NULL,1,NULL),('2025-12-02 10:13:12',NULL,'2025-12-02 10:13:14',1,'70c2b608-d3a6-48ca-aa86-5e9464ff58b0','tempest-VolumeTypesAccessTest-volume-type-1654729354',NULL,0,NULL),('2025-12-02 10:07:59',NULL,'2025-12-02 10:08:11',1,'76e7ac3c-8039-466a-8011-24ff10e9b99d','tempest-GroupSnapshotsTest-volume-type-735882371',NULL,1,NULL),('2025-12-02 10:08:56',NULL,'2025-12-02 10:08:58',1,'7aec2ec3-0f52-4014-9542-889120b6c0b7','tempest-UserMessagesTest-volume-type-526789726',NULL,1,NULL),('2025-12-02 10:13:19',NULL,'2025-12-02 10:13:28',1,'7dab706f-5f14-4388-bc71-6f51f27eb060','tempest-GroupsTest-volume-type-1060610990',NULL,1,NULL),('2025-12-02 10:13:40',NULL,'2025-12-02 10:13:40',1,'805802b7-a2e2-4ec6-a906-f1ac760d611e','tempest-ExtraSpecsNegativeTest-volume-type-696737549',NULL,1,NULL),('2025-12-02 10:13:14',NULL,'2025-12-02 10:13:15',1,'91c8bdf8-ca62-40cd-968a-15982d8c8299','tempest-VolumeTypesAccessTest-volume-type-1364476340',NULL,0,NULL),('2025-12-02 10:08:27',NULL,'2025-12-02 10:08:35',1,'94d93296-ae39-48e1-95cb-44617d586e86','tempest-GroupSnapshotsTest-volume-type-400389718',NULL,1,NULL),('2025-12-02 10:07:16',NULL,'2025-12-02 10:07:21',1,'9b7aea74-a492-48fe-8ca1-deab1ac950d7','volume-type-1',NULL,1,NULL),('2025-12-02 10:13:12',NULL,'2025-12-02 10:13:19',1,'a51d7016-0f53-441a-b5af-2dfdca536ce3','tempest-GroupsTest-volume-type-1153924094',NULL,1,NULL),('2025-12-02 10:08:58',NULL,'2025-12-02 10:09:00',1,'b78562fc-514d-41c9-811e-8b473c928808','tempest-UserMessagesTest-volume-type-1867302679',NULL,1,NULL),('2025-12-02 10:07:46','2025-12-02 10:07:46','2025-12-02 10:07:46',1,'c08a1421-b155-4696-876e-01cba0da9d88','tempest-volume-type-651922026',NULL,0,'tempest-volume-type-description-702478825'),('2025-12-02 10:06:58',NULL,'2025-12-02 10:07:00',1,'c17496d2-2d80-4fed-b83c-f7d8fa12c258','tempest-VolumeQuotaClassesTest-volume-type-1529597337',NULL,1,NULL),('2025-12-02 08:13:25','2025-12-02 08:13:25','2025-12-02 08:21:14',1,'efcaa533-98e8-4fff-9860-0f7f1b52885c','__DEFAULT__',NULL,1,'Default Volume Type'),('2025-12-02 08:21:09',NULL,NULL,0,'f0c92821-26ae-4fe6-bcdd-51d814df82ac','tripleo',NULL,1,NULL),('2025-12-02 10:08:11',NULL,'2025-12-02 10:08:27',1,'f0e8cfb1-538e-44db-a3d8-153ab63f83a0','tempest-GroupSnapshotsTest-volume-type-679191759',NULL,1,NULL),('2025-12-02 10:07:45',NULL,'2025-12-02 10:07:45',1,'ffb6f438-e694-4844-a4b7-7e9861f89d90','tempest-VolumeTypesTest-volume-type-1360250974',NULL,1,NULL);
/*!40000 ALTER TABLE `volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ec2_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(256) DEFAULT NULL,
  `provider_auth` varchar(256) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `source_volid` varchar(36) DEFAULT NULL,
  `bootable` tinyint(1) DEFAULT NULL,
  `provider_geometry` varchar(255) DEFAULT NULL,
  `_name_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `migration_status` varchar(255) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  `replication_extended_status` varchar(255) DEFAULT NULL,
  `replication_driver_data` varchar(255) DEFAULT NULL,
  `consistencygroup_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `multiattach` tinyint(1) DEFAULT NULL,
  `previous_status` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `group_id` varchar(36) DEFAULT NULL,
  `service_uuid` varchar(36) DEFAULT NULL,
  `shared_targets` tinyint(1) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volumes_group_id` (`group_id`),
  KEY `ix_volumes_consistencygroup_id` (`consistencygroup_id`),
  KEY `volumes_service_uuid_idx` (`service_uuid`,`deleted`),
  KEY `volumes_deleted_project_id_idx` (`deleted`,`project_id`),
  KEY `volumes_deleted_host_idx` (`deleted`,`host`),
  CONSTRAINT `volumes_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `volumes_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `volumes_ibfk_3` FOREIGN KEY (`service_uuid`) REFERENCES `services` (`uuid`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`bootable` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`multiattach` in (0,1)),
  CONSTRAINT `CONSTRAINT_4` CHECK (`shared_targets` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
INSERT INTO `volumes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `ec2_id`, `user_id`, `project_id`, `host`, `size`, `availability_zone`, `status`, `attach_status`, `scheduled_at`, `launched_at`, `terminated_at`, `display_name`, `display_description`, `provider_location`, `provider_auth`, `snapshot_id`, `volume_type_id`, `source_volid`, `bootable`, `provider_geometry`, `_name_id`, `encryption_key_id`, `migration_status`, `replication_status`, `replication_extended_status`, `replication_driver_data`, `consistencygroup_id`, `provider_id`, `multiattach`, `previous_status`, `cluster_name`, `group_id`, `service_uuid`, `shared_targets`, `use_quota`) VALUES ('2025-12-02 10:11:59','2025-12-02 10:12:00','2025-12-02 10:12:01',1,'03d46358-cfaa-4e7e-ae84-b6eaebac0d00',NULL,'50b89c4c8cc74474b5fe83dd24cf9df5','ab84e521dda9432ca7d62c5185f1eaab','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:11:59','2025-12-02 10:11:59','2025-12-02 10:12:00','tempest-VolumesTransfersV357Test-Volume-1961473139',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:10:55','2025-12-02 10:10:56','2025-12-02 10:10:57',1,'06f06cfe-d11d-46ed-a630-e834bba182b9',NULL,'9f4eafbab2cf452da851229adb1672cf','f7326c3837b4427191aafcff504110ac','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:10:55','2025-12-02 10:10:55','2025-12-02 10:10:56','tempest-VolumesActionsTest-Volume-1358083890',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:12:02','2025-12-02 10:12:10','2025-12-02 10:12:10',1,'13e5239b-d7cc-40f3-9a5b-427c7d2b3d77',NULL,'7ecf77dbd2574788a6586386d97ee38c','f5466a94421d4e84977ee830576dd8b7','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2025-12-02 10:12:02','2025-12-02 10:12:08','2025-12-02 10:12:10','tempest-VolumesExtendTest-Volume-714943943',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'available',NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:13:47','2025-12-02 10:13:49','2025-12-02 10:13:50',1,'1a5d6076-215e-4d88-b28a-6d3d5ed8ba93',NULL,'13d3d919b23248d1a5835a3d1c8ecedb','58b8f029a1134a12a75f33bc584b83dd','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:13:47','2025-12-02 10:13:48','2025-12-02 10:13:49','tempest-VolumesMetadataTest-Volume-616741908',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:10:52','2025-12-02 10:10:53','2025-12-02 10:10:54',1,'21d8fa99-0e9c-43e3-a410-57d87321a032',NULL,'9f4eafbab2cf452da851229adb1672cf','f7326c3837b4427191aafcff504110ac','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:10:52','2025-12-02 10:10:52','2025-12-02 10:10:53','tempest-VolumesActionsTest-Volume-1538963868',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:11:00','2025-12-02 10:11:02','2025-12-02 10:11:02',1,'22c68f67-3079-4561-8e96-f4434111f2d0',NULL,'9f4eafbab2cf452da851229adb1672cf','f7326c3837b4427191aafcff504110ac','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:11:00','2025-12-02 10:11:01','2025-12-02 10:11:02','tempest-VolumesActionsTest-Volume-394653982',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:09:13','2025-12-02 10:09:16','2025-12-02 10:09:18',1,'257608c5-16eb-4fc3-812e-89bbc37f51df',NULL,'5b936fa204fb4eccbb40310a7cab306d','d077375432eb4d5983dfbe6a6927c321','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:09:13','2025-12-02 10:09:13','2025-12-02 10:09:16','tempest-VolumesListAdminTestJSON-Volume-1039243913',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:13:22','2025-12-02 10:13:27','2025-12-02 10:13:27',1,'278898ba-c520-4647-bb08-63a3ffea80c4',NULL,'e49255efa5ee433ebbe2d2dcf29d2667','8ff22a276ec5464e8a97c8b3b0e8806c','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:13:22','2025-12-02 10:13:22',NULL,'tempest-volume-587199794',NULL,NULL,NULL,NULL,'7dab706f-5f14-4388-bc71-6f51f27eb060',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'f7c8bb8c-d0c7-4709-b217-676e7c0faf1a','f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:13:07','2025-12-02 10:13:14','2025-12-02 10:13:14',1,'2e7b260c-1271-44f7-912c-ae60e176ac11',NULL,'fb6c45ae0e4b4c359e6ea41cecfc33c8','b374ce45b6dc4bc5b2eac77a9216133f','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:13:07','2025-12-02 10:13:07','2025-12-02 10:13:14','tempest-VolumesSnapshotTestJSON-Volume-1335677285',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:14:01','2025-12-02 10:14:09','2025-12-02 10:14:09',1,'3001b045-6922-41f5-8ecc-77f19c0e9e13',NULL,'ac0529c7eae744189ab8cd005b855f04','82445c1a56474ba497d07340322dbade','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:14:01','2025-12-02 10:14:02','2025-12-02 10:14:09','tempest-VolumesGetTest-Volume-993842683',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:13:48','2025-12-02 10:13:50','2025-12-02 10:13:51',1,'35fad08b-b752-4c38-8266-9e02097f6d0d',NULL,'7325e92a44d04ebd915170008755021d','08ec4508e51e4b46972baa016cc404c1','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:13:48','2025-12-02 10:13:48','2025-12-02 10:13:50','tempest-VolumesTransfersTest-Volume-1904388303',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:13:15','2025-12-02 10:13:17','2025-12-02 10:13:17',1,'362bd6d9-0784-4eed-b563-3ba12a1910bf',NULL,'e49255efa5ee433ebbe2d2dcf29d2667','8ff22a276ec5464e8a97c8b3b0e8806c','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:13:15','2025-12-02 10:13:15',NULL,'tempest-volume-1693870900',NULL,NULL,NULL,NULL,'a51d7016-0f53-441a-b5af-2dfdca536ce3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'b705c94d-940f-49af-946e-57ca1cb9df09','f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:08:00','2025-12-02 10:08:09','2025-12-02 10:08:10',1,'38cddbb0-587f-411a-9140-287fb30bb126',NULL,'e106d79b62e54215bcadae87f431c1b2','6963976a36c6408c9336062feaef5d1f','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:08:00','2025-12-02 10:08:01',NULL,'tempest-volume-1788724058',NULL,NULL,NULL,NULL,'76e7ac3c-8039-466a-8011-24ff10e9b99d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'dbc50bd7-a1d5-488b-9b8b-3c0d0cf3ad62','f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:13:09','2025-12-02 10:13:10','2025-12-02 10:13:11',1,'3e2594d8-3241-49b9-9659-3225543f9919',NULL,'fb6c45ae0e4b4c359e6ea41cecfc33c8','b374ce45b6dc4bc5b2eac77a9216133f','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:13:09','2025-12-02 10:13:10','2025-12-02 10:13:10','tempest-VolumesSnapshotTestJSON-Volume-617746620',NULL,NULL,NULL,'5aff86be-8231-496d-9a73-0903eeb7284c','f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:12:59','2025-12-02 10:13:03','2025-12-02 10:13:04',1,'3fbaf516-b660-4e9b-aadb-3977193df132',NULL,'b99fb9e02616408da5b39544cad2c70f','8943858eee964ad7920643441a49ca76','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:12:59','2025-12-02 10:12:59','2025-12-02 10:13:03','tempest-VolumeSnapshotQuotasNegativeTestJSON-Volume-18372059',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:13:57','2025-12-02 10:14:00','2025-12-02 10:14:00',1,'40861eac-935f-43db-a174-64a3b8d432ff',NULL,'820479883d9c44bb9bf3753c3d295af3','59618d0a71be4bd7b90941ee9db2762c','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:13:57','2025-12-02 10:13:57','2025-12-02 10:14:00','tempest-VolumesListTestJSON-Volume-144998652',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:14:17','2025-12-02 10:14:18','2025-12-02 10:14:19',1,'4121aaa3-f116-4cb1-a36d-f1cb5f56fbb9',NULL,'ac0529c7eae744189ab8cd005b855f04','82445c1a56474ba497d07340322dbade','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:14:17','2025-12-02 10:14:17','2025-12-02 10:14:18','tempest-VolumesGetTest-Volume-180380008',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:13:54','2025-12-02 10:14:02','2025-12-02 10:14:03',1,'48b592b4-9ef5-482d-b8f5-32963474ee28',NULL,'820479883d9c44bb9bf3753c3d295af3','59618d0a71be4bd7b90941ee9db2762c','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:13:54','2025-12-02 10:13:54','2025-12-02 10:14:02','tempest-VolumesListTestJSON-Volume-1004796079',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:12:47','2025-12-02 10:12:49','2025-12-02 10:12:51',1,'4b69200b-9cc6-48ae-829a-30514f93063f',NULL,'2f2bcd1dc5d14df2950bd42feb213c73','bb3c511d46dd4d3ead65c06b6e7b5c12','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:12:47','2025-12-02 10:12:47','2025-12-02 10:12:49','tempest-VolumeQuotasNegativeTestJSON-Volume-1774548104',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'available',NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:08:58','2025-12-02 10:08:58','2025-12-02 10:09:00',1,'4cf4d3c1-86b4-4955-84e0-f2ca476b3a7f',NULL,'52dcb62d5f874a40b3953f71999005ee','88ada1dc04884eb0b3013bc2d2c4917c',NULL,1,'nova','deleted','detached',NULL,NULL,NULL,'tempest-UserMessagesTest-Volume-804386208',NULL,NULL,NULL,NULL,'b78562fc-514d-41c9-811e-8b473c928808',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,1,1),('2025-12-02 10:10:58','2025-12-02 10:10:59','2025-12-02 10:10:59',1,'4de2aa64-b3f9-4b57-b061-8ff1b725777b',NULL,'9f4eafbab2cf452da851229adb1672cf','f7326c3837b4427191aafcff504110ac','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:10:58','2025-12-02 10:10:58','2025-12-02 10:10:59','tempest-VolumesActionsTest-Volume-1207410942',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:09:32','2025-12-02 10:09:42','2025-12-02 10:09:42',1,'52cac4dd-69ca-4e69-adbd-f821188d6658',NULL,'7fdff55a0d554fb28c067104c4b223a4','6c1597b25b33405db70f223b571f21b7','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:09:32','2025-12-02 10:09:41','2025-12-02 10:09:42','tempest-VolumesImageMetadata-Volume-1763684918',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:14:05','2025-12-02 10:14:06','2025-12-02 10:14:07',1,'5f946168-2846-4d1c-815e-d41d32b6e443',NULL,'ac0529c7eae744189ab8cd005b855f04','82445c1a56474ba497d07340322dbade','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:14:05','2025-12-02 10:14:05','2025-12-02 10:14:06','tempest-VolumesGetTest-Volume-2103165946',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:09:11','2025-12-02 10:09:20','2025-12-02 10:09:20',1,'6110cb3f-4bf7-4795-8fe4-56d64134b87f',NULL,'5b936fa204fb4eccbb40310a7cab306d','d077375432eb4d5983dfbe6a6927c321','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:09:11','2025-12-02 10:09:12','2025-12-02 10:09:20','tempest-VolumesListAdminTestJSON-Volume-1543245962',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:11:04','2025-12-02 10:11:16','2025-12-02 10:11:18',1,'63282360-dcd1-46ed-a05a-0d9a8b40b619',NULL,'1aa9c42ce52647ac840d8264bfaa8bc0','3cb8897eac514c8791f32dc7c7f97664','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:11:04','2025-12-02 10:11:04','2025-12-02 10:11:16','tempest-VolumesBackupsV39Test-Volume-1860556478',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:08:13','2025-12-02 10:08:27','2025-12-02 10:08:27',1,'662c48bb-d1e2-4dac-ac96-0a25b2ea4fc4',NULL,'e106d79b62e54215bcadae87f431c1b2','6963976a36c6408c9336062feaef5d1f','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:08:13','2025-12-02 10:08:13',NULL,'tempest-volume-1187386904',NULL,NULL,NULL,NULL,'f0e8cfb1-538e-44db-a3d8-153ab63f83a0',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'71217c40-d3cb-4caf-8759-f7ca9bcf0b91','f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:16:11','2025-12-02 10:16:16','2025-12-02 10:16:17',1,'691d4665-8c31-40ca-becb-5153dcec98c3',NULL,'4cf4e412f7aa4b38937a59c19a460b6a','9357d59432e04f9791424e201b9754ce','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2025-12-02 10:16:11','2025-12-02 10:16:12','2025-12-02 10:16:16','tempest-VolumesSnapshotNegativeTestJSON-Volume-1161074662',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:14:24','2025-12-02 10:14:33','2025-12-02 10:14:34',1,'6c0537c2-0916-4bed-86ab-98f4189ef8cd',NULL,'7c253b4d05e4467b847ce7c505213640','d3daa40d2d6446d8b0b46a9f7d1b779c','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:14:24','2025-12-02 10:14:24','2025-12-02 10:14:33','tempest-VolumesDeleteCascade-Volume-1211543245',NULL,NULL,NULL,'7714b687-1061-4397-8fc8-722ed9748e46','f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:12:28','2025-12-02 10:12:34','2025-12-02 10:12:34',1,'6e329b91-ab8f-450c-8632-855f11c6f5b5',NULL,'655d9191fb2f408c917a6a9ed2235d2d','6b4f1f3dd8704e9992f1bc11c793a60e','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:12:28','2025-12-02 10:12:29',NULL,'tempest-volume-882211597',NULL,NULL,NULL,NULL,'5264be6d-39ee-4356-a8c7-079164c1a2db',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'d798bb6d-134c-4110-b7cc-dc1cd7394229','f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:11:40','2025-12-02 10:12:00','2025-12-02 10:12:02',1,'6e49a843-0dfa-4a15-99de-f6c990ac2aed',NULL,'f9daf1690e014a9d9bcc6e1662fa5439','10644498f24744ec828624bc952bff43','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:11:40','2025-12-02 10:11:40','2025-12-02 10:12:00','tempest-VolumesBackupsAdminTest-Volume-556689703',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:14:23','2025-12-02 10:14:36','2025-12-02 10:14:37',1,'73f0b320-6d2a-4bf6-924d-581f9898933f',NULL,'cfa340769a434813a589cf5cb369e58c','ab2f308df5874752ab8cc95304b7b442','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:14:23','2025-12-02 10:14:23','2025-12-02 10:14:36','tempest-VolumesSnapshotListTestJSON-Volume-190113005',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:07:33','2025-12-02 10:07:34','2025-12-02 10:07:35',1,'759bf2bd-afe6-4dfb-84c7-db657fffd358',NULL,'56b703c31a1746c8858d667410f53189','42538761f9f84e7684580411ccae9cb6','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:07:33','2025-12-02 10:07:33','2025-12-02 10:07:34','tempest-VolumesServicesTestJSON-Volume-2102552669',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:12:03','2025-12-02 10:12:10','2025-12-02 10:12:12',1,'76722819-84a1-4dfa-a319-cf730a5648ab',NULL,'f9daf1690e014a9d9bcc6e1662fa5439','10644498f24744ec828624bc952bff43','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:12:03','2025-12-02 10:12:03','2025-12-02 10:12:10','tempest-VolumesBackupsAdminTest-Volume-1798687617',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:06:42','2025-12-02 10:07:05','2025-12-02 10:07:07',1,'79e6dc38-5092-4b61-b2e2-81d3777f5f9e',NULL,'39ac23db08db4b5b981bf56813fe3813','1e139fe20a514d12b866b3c8974dcebd','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:06:43','2025-12-02 10:06:45','2025-12-02 10:07:05','tempest-SnapshotsActionsTest-Volume-594420864',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:07:17','2025-12-02 10:07:20','2025-12-02 10:07:21',1,'7a7769a9-626b-4a4c-b1de-3a382a409fd0',NULL,'4eb03c2af7a8403298d36f5a32c0c024','ef69e828801540619536106b3b481b20','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:07:17','2025-12-02 10:07:18','2025-12-02 10:07:20','tempest-VolumeRetypeWithoutMigrationTest-Volume-1529566023',NULL,NULL,NULL,NULL,'246462fb-2afd-4b98-bd79-3779fcd53ea0',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'available',NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:14:02','2025-12-02 10:14:07','2025-12-02 10:14:08',1,'7a9c72af-aea7-454a-8917-378d8f870527',NULL,'ac0529c7eae744189ab8cd005b855f04','82445c1a56474ba497d07340322dbade','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:14:03','2025-12-02 10:14:04','2025-12-02 10:14:07','tempest-VolumesGetTest-new-Volume-92193734','This is the new description of volume',NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac','3001b045-6922-41f5-8ecc-77f19c0e9e13',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:13:58','2025-12-02 10:13:59','2025-12-02 10:14:00',1,'7ccd6b23-274c-433e-8349-9ec6843bd856',NULL,'ac0529c7eae744189ab8cd005b855f04','82445c1a56474ba497d07340322dbade','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:13:58','2025-12-02 10:13:58','2025-12-02 10:13:59','tempest-VolumesGetTest-Volume-1319917047',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:14:22','2025-12-02 10:14:25','2025-12-02 10:14:32',1,'86339aa1-2726-467a-a1cd-44db4f65aaf5',NULL,'7c253b4d05e4467b847ce7c505213640','d3daa40d2d6446d8b0b46a9f7d1b779c','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:14:22','2025-12-02 10:14:22','2025-12-02 10:14:25','tempest-VolumesDeleteCascade-Volume-1704911310',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:11:40','2025-12-02 10:11:42','2025-12-02 10:11:43',1,'8a641c39-7b20-4636-93b9-614bcab0245c',NULL,'c9ccc778ea32434ba318659fdb08eb10','8e9db6bb24074518b94709252c97dff0','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:11:40','2025-12-02 10:11:42','2025-12-02 10:11:42','tempest-VolumesCloneTest-Volume-773310257',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac','ef2d1fbc-983a-4189-ad23-d6a0105071a9',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:09:10','2025-12-02 10:09:21','2025-12-02 10:09:21',1,'8cc11b1f-3c0b-4a4d-aef2-0558b769e83e',NULL,'5b936fa204fb4eccbb40310a7cab306d','d077375432eb4d5983dfbe6a6927c321','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:09:10','2025-12-02 10:09:10','2025-12-02 10:09:21','tempest-VolumesListAdminTestJSON-Volume-783831904',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:08:56','2025-12-02 10:08:56','2025-12-02 10:08:57',1,'908a0b16-c7ec-4039-a8f1-12c722afd577',NULL,'52dcb62d5f874a40b3953f71999005ee','88ada1dc04884eb0b3013bc2d2c4917c',NULL,1,'nova','deleted','detached',NULL,NULL,NULL,'tempest-UserMessagesTest-Volume-478028048',NULL,NULL,NULL,NULL,'7aec2ec3-0f52-4014-9542-889120b6c0b7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,1,1),('2025-12-02 10:13:48','2025-12-02 10:13:54','2025-12-02 10:13:54',1,'9649a9c6-9cd5-4828-aac8-9d4f3f73262d',NULL,'1ea4e58d0f6b4f2a841e8a5da7272bdd','69ac27088e5c47cabe1441ecc9b19c84','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:13:48','2025-12-02 10:13:48',NULL,'tempest-volume-1413684836',NULL,NULL,NULL,NULL,'4d121018-c823-4af0-88b4-28bf24456334',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'9b9ca4f1-c8a7-41e6-80ed-5593b47ed878','f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:14:46','2025-12-02 10:15:04','2025-12-02 10:15:06',1,'985ad36b-4413-4129-a7fb-6c33ca008a44',NULL,'0e5c738ba752455b908099b234a743a2','d858413a9b01463f96545916d2abe5ab','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:14:46','2025-12-02 10:14:51','2025-12-02 10:15:04','tempest-VolumesBackupsTest-Volume-1999471447',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:11:08','2025-12-02 10:11:10','2025-12-02 10:11:11',1,'9d13dd66-5303-4ffe-9d84-fcb77fa285a9',NULL,'5af8cd170e49421ba1b9eede8eb1a146','fef053541b4b4785ab9899f41b37c328','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:11:09','2025-12-02 10:11:09','2025-12-02 10:11:10','tempest-VolumeQuotasAdminTestJSON-Volume-213009390',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:12:08','2025-12-02 10:12:09','2025-12-02 10:12:09',1,'9e379b55-80d8-45b9-9156-b343da614f92',NULL,'a77bb2b931e445c4ad336313b54bf1f6','da38242c0e8d4da7a906db10517a9171','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2025-12-02 10:12:08','2025-12-02 10:12:08','2025-12-02 10:12:09','tempest-VolumesCloneNegativeTest-Volume-1357798852',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:13:55','2025-12-02 10:14:01','2025-12-02 10:14:01',1,'a0b70e5b-292c-4b65-80c3-686346bc8731',NULL,'820479883d9c44bb9bf3753c3d295af3','59618d0a71be4bd7b90941ee9db2762c','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:13:56','2025-12-02 10:13:56','2025-12-02 10:14:01','tempest-VolumesListTestJSON-Volume-1850759698',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:14:10','2025-12-02 10:14:19','2025-12-02 10:14:20',1,'a20df562-08c1-49f9-aa90-dd9d8debbf47',NULL,'ac0529c7eae744189ab8cd005b855f04','82445c1a56474ba497d07340322dbade','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:14:10','2025-12-02 10:14:16','2025-12-02 10:14:19','tempest-VolumesGetTest-new-Volume-1971848964','This is the new description of volume',NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:08:29','2025-12-02 10:08:35','2025-12-02 10:08:35',1,'a50f5eae-b4d3-48b9-a205-07c366acbf05',NULL,'e106d79b62e54215bcadae87f431c1b2','6963976a36c6408c9336062feaef5d1f','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:08:29','2025-12-02 10:08:29',NULL,'tempest-volume-464734001',NULL,NULL,NULL,NULL,'94d93296-ae39-48e1-95cb-44617d586e86',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'78a46d4c-4b80-46bd-808a-6cd58c34caeb','f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:14:05','2025-12-02 10:14:10','2025-12-02 10:14:11',1,'a9ee74e1-e820-4856-9017-a6bfc85192ec',NULL,'0e8b63c8d4794f7d8443e7392bf8e840','8f287097241a4419b0923dfc81ea1206','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:14:05','2025-12-02 10:14:05','2025-12-02 10:14:10','tempest-SnapshotMetadataTestJSON-Volume-887435211',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:10:03','2025-12-02 10:10:51','2025-12-02 10:10:52',1,'acc6c364-50bc-441b-bb2f-7b57cca0f5b6',NULL,'bae9ddb3c01645b49b8983ad446d9968','5bad680c763640dba71a7865b355817c','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:10:03','2025-12-02 10:10:03','2025-12-02 10:10:51','tempest-VolumesActionsTest-Volume-214042325',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'available',NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:11:50','2025-12-02 10:11:57','2025-12-02 10:11:59',1,'b28a7a85-dd39-4bd4-8551-fe72ab7b54c1',NULL,'f9daf1690e014a9d9bcc6e1662fa5439','10644498f24744ec828624bc952bff43','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:11:50','2025-12-02 10:11:51','2025-12-02 10:11:57','tempest-VolumesBackupsAdminTest-Volume-556689703',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:13:02','2025-12-02 10:13:03','2025-12-02 10:13:04',1,'b32bad3a-1084-458b-9df3-2cecaf3a6f8b',NULL,'fb6c45ae0e4b4c359e6ea41cecfc33c8','b374ce45b6dc4bc5b2eac77a9216133f','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2025-12-02 10:13:02','2025-12-02 10:13:02','2025-12-02 10:13:03','tempest-VolumesSnapshotTestJSON-Volume-1041116512',NULL,NULL,NULL,'4af51a3f-f41a-42cf-956c-674f8bdb8b65','f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:13:45','2025-12-02 10:13:47','2025-12-02 10:13:47',1,'b590ebd4-a5d6-44b2-9682-148d22e4a757',NULL,'f638f91dab21477d9fee9c349a4cf472','1259cb721f554d769bcd146b925c03fd','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:13:45','2025-12-02 10:13:45','2025-12-02 10:13:47','tempest-VolumesTransfersTest-Volume-416459261',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:14:15','2025-12-02 10:14:18','2025-12-02 10:14:20',1,'b7e7d911-0a2c-4b80-a974-a47f4c66d00d',NULL,'7c253b4d05e4467b847ce7c505213640','d3daa40d2d6446d8b0b46a9f7d1b779c','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:14:15','2025-12-02 10:14:15','2025-12-02 10:14:18','tempest-VolumesDeleteCascade-Volume-798241665',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:13:20','2025-12-02 10:13:27','2025-12-02 10:13:27',1,'b9ca5476-3a25-4012-baed-afd87a980347',NULL,'e49255efa5ee433ebbe2d2dcf29d2667','8ff22a276ec5464e8a97c8b3b0e8806c','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:13:21','2025-12-02 10:13:21',NULL,'tempest-volume-540741395',NULL,NULL,NULL,NULL,'7dab706f-5f14-4388-bc71-6f51f27eb060',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'f7c8bb8c-d0c7-4709-b217-676e7c0faf1a','f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:13:51','2025-12-02 10:13:53','2025-12-02 10:13:53',1,'bcbb857c-751b-4173-a9ad-b9842535ce9b',NULL,'1ea4e58d0f6b4f2a841e8a5da7272bdd','69ac27088e5c47cabe1441ecc9b19c84','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4d121018-c823-4af0-88b4-28bf24456334','9649a9c6-9cd5-4828-aac8-9d4f3f73262d',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'fb51ae5e-f2d5-427f-8578-3a4bb7add157',NULL,1,1),('2025-12-02 10:08:14','2025-12-02 10:08:27','2025-12-02 10:08:27',1,'bf0dd85f-186a-4a0f-94ee-666321d9e0fb',NULL,'e106d79b62e54215bcadae87f431c1b2','6963976a36c6408c9336062feaef5d1f','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:08:14','2025-12-02 10:08:14',NULL,'tempest-volume-327289987',NULL,NULL,NULL,NULL,'f0e8cfb1-538e-44db-a3d8-153ab63f83a0',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'71217c40-d3cb-4caf-8759-f7ca9bcf0b91','f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:13:56','2025-12-02 10:14:00','2025-12-02 10:14:01',1,'c11c88c5-b22e-4001-a074-faef3f45ed65',NULL,'ac0529c7eae744189ab8cd005b855f04','82445c1a56474ba497d07340322dbade','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:13:56','2025-12-02 10:13:57','2025-12-02 10:14:00','tempest-VolumesGetTest-new-Volume-1083947743','This is the new description of volume',NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:12:22','2025-12-02 10:12:30','2025-12-02 10:12:31',1,'c7913509-e790-4ab3-8fb6-4f819e45f323',NULL,'33f0d1c6e7e943ecbe99fa2948601f31','9983d967265d4691806eb9b9a49900de','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:12:22','2025-12-02 10:12:23','2025-12-02 10:12:30','tempest-VolumesNegativeTest-Volume-1480972974',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:13:36','2025-12-02 10:13:37','2025-12-02 10:13:38',1,'c7e489fd-d02e-4698-92b5-df3803271839',NULL,'55623fafab784a79af00338030920cfd','f01f26d352434e1898ddc5651f0257ce','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:13:36','2025-12-02 10:13:36','2025-12-02 10:13:37','tempest-AbsoluteLimitsTests-Volume-1202790612',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:09:14','2025-12-02 10:09:16','2025-12-02 10:09:17',1,'ca6b3650-fc65-47f7-823f-7f3a2f27a16e',NULL,'bc89d97fbbfb41b6a0a96d2f2eb800a5','99d88ed9db6a44ad8671401d30ce29a3','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:09:15','2025-12-02 10:09:15','2025-12-02 10:09:16',NULL,NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:11:03','2025-12-02 10:11:05','2025-12-02 10:11:06',1,'d322670a-2654-4fd1-a9af-f2a59ea2b399',NULL,'9f4eafbab2cf452da851229adb1672cf','f7326c3837b4427191aafcff504110ac','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:11:03','2025-12-02 10:11:04','2025-12-02 10:11:05','tempest-VolumesActionsTest-Volume-1761927841',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:11:48','2025-12-02 10:11:50','2025-12-02 10:11:51',1,'d4c3c05c-c8af-4c44-9f42-ca1a0d597a1b',NULL,'c9ccc778ea32434ba318659fdb08eb10','8e9db6bb24074518b94709252c97dff0','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2025-12-02 10:11:48','2025-12-02 10:11:49','2025-12-02 10:11:50','tempest-VolumesCloneTest-Volume-1977781484',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac','d61fcc91-4db4-4f24-bbbe-c9d2c58d4cfa',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:11:46','2025-12-02 10:11:52','2025-12-02 10:11:53',1,'d61fcc91-4db4-4f24-bbbe-c9d2c58d4cfa',NULL,'c9ccc778ea32434ba318659fdb08eb10','8e9db6bb24074518b94709252c97dff0','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:11:47','2025-12-02 10:11:47','2025-12-02 10:11:52','tempest-VolumesCloneTest-Volume-425339305',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:13:12','2025-12-02 10:13:13','2025-12-02 10:13:14',1,'d78f710c-c8d7-459d-b088-48ea785c50e4',NULL,'c505f014e69a4dabaf635c519323f680','e40b394d064942f593402333dc8c9581','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:13:12','2025-12-02 10:13:12','2025-12-02 10:13:13','tempest-VolumeTypesAccessTest-Volume-137860586',NULL,NULL,NULL,NULL,'70c2b608-d3a6-48ca-aa86-5e9464ff58b0',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:07:20','2025-12-02 10:07:23','2025-12-02 10:07:25',1,'dc1592d7-3d76-4279-b9b3-ab3b5f9b73f5',NULL,'b32b6dd18e034edfa3777a6f7a1be8bf','00428a58903e487bb33ddf74c19e4f17','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:07:21','2025-12-02 10:07:21','2025-12-02 10:07:23','tempest-VolumesTransfersV355Test-Volume-1466649317',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:12:38','2025-12-02 10:12:39','2025-12-02 10:12:53',1,'dd1dfc0e-0d5c-47a6-a4b3-34e6664b2242',NULL,'fb6c45ae0e4b4c359e6ea41cecfc33c8','b374ce45b6dc4bc5b2eac77a9216133f','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached',NULL,NULL,NULL,'backup-vol-e7b291f0-5337-403a-93d2-d7ade4ecb725',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,1,0),('2025-12-02 10:08:05','2025-12-02 10:08:07','2025-12-02 10:08:07',1,'e159711c-fd02-4113-8a47-a5fb4f8aee46',NULL,'e106d79b62e54215bcadae87f431c1b2','6963976a36c6408c9336062feaef5d1f','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'6db489ca-cff2-4ddf-b855-b643f7ed7876','76e7ac3c-8039-466a-8011-24ff10e9b99d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'e9f33063-a47e-4398-aaa1-d1b5234cebfd',NULL,1,1),('2025-12-02 10:11:54','2025-12-02 10:11:58','2025-12-02 10:11:58',1,'e26a8c85-beb7-4c28-b53b-e10f72b9d310',NULL,'52e2d5d3d218480cb5f124619e132f59','2267b5d8ec1242618341cd359607d279','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:11:56','2025-12-02 10:11:56','2025-12-02 10:11:58','tempest-VolumesTransfersV357Test-Volume-810354684',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:12:36','2025-12-02 10:13:15','2025-12-02 10:13:16',1,'e7b291f0-5337-403a-93d2-d7ade4ecb725',NULL,'fb6c45ae0e4b4c359e6ea41cecfc33c8','b374ce45b6dc4bc5b2eac77a9216133f','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:12:36','2025-12-02 10:12:36','2025-12-02 10:13:15','tempest-VolumesSnapshotTestJSON-Volume-1502876083',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:12:59','2025-12-02 10:13:05','2025-12-02 10:13:06',1,'ead6103e-9744-4b5e-802a-67aac454ec1c',NULL,'fb6c45ae0e4b4c359e6ea41cecfc33c8','b374ce45b6dc4bc5b2eac77a9216133f','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:13:00','2025-12-02 10:13:00','2025-12-02 10:13:05','tempest-VolumesSnapshotTestJSON-Volume-2019144606',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:15:07','2025-12-02 10:16:01','2025-12-02 10:16:04',1,'eb88c64a-7c29-421c-91ad-190ba7bbf450',NULL,'0e5c738ba752455b908099b234a743a2','d858413a9b01463f96545916d2abe5ab','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:15:07','2025-12-02 10:15:07','2025-12-02 10:16:01','tempest-VolumesBackupsTest-Volume-1269852524',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:12:11','2025-12-02 10:12:17','2025-12-02 10:12:17',1,'ed240847-57fd-4620-b037-cb19f8ca301b',NULL,'7ecf77dbd2574788a6586386d97ee38c','f5466a94421d4e84977ee830576dd8b7','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2025-12-02 10:12:11','2025-12-02 10:12:11','2025-12-02 10:12:17','tempest-VolumesExtendTest-Volume-791378735',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'available',NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:11:11','2025-12-02 10:11:14','2025-12-02 10:11:15',1,'ed487828-83c9-4bbe-893f-a4ca97b0f22b',NULL,'a2f31e38121849b1a94c7d92da5618f7','efbd1cf12d1441269b72130fc6cf60d9','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:11:11','2025-12-02 10:11:12','2025-12-02 10:11:14','tempest-VolumeQuotasAdminTestJSON-Volume-1679783034',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:11:31','2025-12-02 10:11:45','2025-12-02 10:11:45',1,'ef2d1fbc-983a-4189-ad23-d6a0105071a9',NULL,'c9ccc778ea32434ba318659fdb08eb10','8e9db6bb24074518b94709252c97dff0','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:11:32','2025-12-02 10:11:38','2025-12-02 10:11:45','tempest-VolumesCloneTest-Volume-1251719763',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:07:26','2025-12-02 10:07:27','2025-12-02 10:07:28',1,'fabffb7b-cc3e-4c4e-8176-72d336e8a67b',NULL,'2c367119f5ca43d19076cdd859090a86','0b96bacd92de4f1aa310d96b02e2ba1b','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:07:26','2025-12-02 10:07:26','2025-12-02 10:07:27','tempest-VolumesTransfersV355Test-Volume-905867226',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1),('2025-12-02 10:14:56','2025-12-02 10:15:00','2025-12-02 10:15:01',1,'fb26f3c4-7b9f-4e89-9327-d625b9a7aae0',NULL,'0e5c738ba752455b908099b234a743a2','d858413a9b01463f96545916d2abe5ab','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-02 10:14:56','2025-12-02 10:14:56','2025-12-02 10:15:00','tempest-VolumesBackupsTest-Volume-1999471447',NULL,NULL,NULL,NULL,'f0c92821-26ae-4fe6-bcdd-51d814df82ac',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'f63c94d8-0bfb-4238-a8f8-9f70e749e5ef',0,1);
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workers`
--

DROP TABLE IF EXISTS `workers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `workers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(40) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  `status` varchar(255) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_type` (`resource_type`,`resource_id`),
  KEY `ix_workers_service_id` (`service_id`),
  CONSTRAINT `workers_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=161 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workers`
--

LOCK TABLES `workers` WRITE;
/*!40000 ALTER TABLE `workers` DISABLE KEYS */;
INSERT INTO `workers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `resource_type`, `resource_id`, `status`, `service_id`, `race_preventer`) VALUES ('2025-12-02 08:13:24','2025-12-02 08:13:24.000123',NULL,0,2,'SENTINEL','SUB-SECOND','OK',NULL,0);
/*!40000 ALTER TABLE `workers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `glance`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `glance` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `glance`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('2023_1_contract01');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_locations`
--

DROP TABLE IF EXISTS `image_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `meta_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `ix_image_locations_deleted` (`deleted`),
  KEY `ix_image_locations_image_id` (`image_id`),
  CONSTRAINT `image_locations_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_locations`
--

LOCK TABLES `image_locations` WRITE;
/*!40000 ALTER TABLE `image_locations` DISABLE KEYS */;
INSERT INTO `image_locations` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `meta_data`, `status`) VALUES (2,'6dbbc069-a02f-4753-b6a8-9fb02d7e0aaa','rbd://c7c8e171-a193-56fb-95fa-8879fcfa7074/images/6dbbc069-a02f-4753-b6a8-9fb02d7e0aaa/snap','2025-12-02 08:30:43','2025-12-02 08:30:43',NULL,0,'{\"store\": \"default_backend\"}','active'),(5,'d85e840d-fa56-497b-b5bd-b49584d3e97a','rbd://c7c8e171-a193-56fb-95fa-8879fcfa7074/images/d85e840d-fa56-497b-b5bd-b49584d3e97a/snap','2025-12-02 10:01:56','2025-12-02 10:01:56',NULL,0,'{\"store\": \"default_backend\"}','active'),(6,'9eb802b4-b54a-4025-8303-71322813986d','rbd://c7c8e171-a193-56fb-95fa-8879fcfa7074/images/9eb802b4-b54a-4025-8303-71322813986d/snap','2025-12-02 10:01:57','2025-12-02 10:01:57',NULL,0,'{\"store\": \"default_backend\"}','active'),(7,'8ac3e643-6e48-4b4f-9488-fe99e04b1f5c','rbd://c7c8e171-a193-56fb-95fa-8879fcfa7074/images/8ac3e643-6e48-4b4f-9488-fe99e04b1f5c/snap','2025-12-02 10:02:57','2025-12-02 10:03:00','2025-12-02 10:03:00',1,'{\"store\": \"default_backend\"}','deleted'),(8,'c6f7f1b0-6018-4e6f-a628-8d5a24dbbfd0','rbd://c7c8e171-a193-56fb-95fa-8879fcfa7074/images/c6f7f1b0-6018-4e6f-a628-8d5a24dbbfd0/snap','2025-12-02 10:03:32','2025-12-02 10:03:45','2025-12-02 10:03:45',1,'{\"store\": \"default_backend\"}','deleted'),(9,'0e87d55f-56a4-4da8-9198-c633785685ee','rbd://c7c8e171-a193-56fb-95fa-8879fcfa7074/images/0e87d55f-56a4-4da8-9198-c633785685ee/snap','2025-12-02 10:04:04','2025-12-02 10:04:14','2025-12-02 10:04:14',1,'{\"store\": \"default_backend\"}','deleted'),(10,'86a5c305-d455-41ae-9be8-4fd53295ea9e','rbd://c7c8e171-a193-56fb-95fa-8879fcfa7074/images/86a5c305-d455-41ae-9be8-4fd53295ea9e/snap','2025-12-02 10:05:02','2025-12-02 10:05:07','2025-12-02 10:05:07',1,'{\"store\": \"default_backend\"}','deleted'),(11,'db00bb04-d8a7-4b40-ad3e-6c8fc16262fc','rbd://c7c8e171-a193-56fb-95fa-8879fcfa7074/images/db00bb04-d8a7-4b40-ad3e-6c8fc16262fc/snap','2025-12-02 10:05:48','2025-12-02 10:05:50','2025-12-02 10:05:50',1,'{\"store\": \"default_backend\"}','deleted'),(12,'9ac90228-fc59-4e6a-b4cb-c08636b183e8','rbd://c7c8e171-a193-56fb-95fa-8879fcfa7074/images/9ac90228-fc59-4e6a-b4cb-c08636b183e8/snap','2025-12-02 10:06:37','2025-12-02 10:06:48','2025-12-02 10:06:48',1,'{\"store\": \"default_backend\"}','deleted'),(13,'d6b3dfef-8217-4d04-8b7f-234fe4dff326','rbd://c7c8e171-a193-56fb-95fa-8879fcfa7074/images/d6b3dfef-8217-4d04-8b7f-234fe4dff326/snap','2025-12-02 10:06:39','2025-12-02 10:06:45','2025-12-02 10:06:45',1,'{\"store\": \"default_backend\"}','deleted'),(14,'1b37b16b-8c27-4fa1-acbf-ba071f793034','rbd://c7c8e171-a193-56fb-95fa-8879fcfa7074/images/1b37b16b-8c27-4fa1-acbf-ba071f793034/snap','2025-12-02 10:06:42','2025-12-02 10:06:44','2025-12-02 10:06:44',1,'{\"store\": \"default_backend\"}','deleted'),(15,'a0ba66b9-185e-4137-961a-a4f10b3f6136','rbd://c7c8e171-a193-56fb-95fa-8879fcfa7074/images/a0ba66b9-185e-4137-961a-a4f10b3f6136/snap','2025-12-02 10:06:45','2025-12-02 10:06:47','2025-12-02 10:06:47',1,'{\"store\": \"default_backend\"}','deleted'),(16,'b0da1701-1cdc-4fec-9cf6-624ef93e38f7','rbd://c7c8e171-a193-56fb-95fa-8879fcfa7074/images/b0da1701-1cdc-4fec-9cf6-624ef93e38f7/snap','2025-12-02 10:08:02','2025-12-02 10:08:17','2025-12-02 10:08:17',1,'{\"store\": \"default_backend\"}','deleted'),(17,'8bcb180a-c1b9-4bf2-aef4-4e8f48518c53','rbd://c7c8e171-a193-56fb-95fa-8879fcfa7074/images/8bcb180a-c1b9-4bf2-aef4-4e8f48518c53/snap','2025-12-02 10:08:03','2025-12-02 10:08:16','2025-12-02 10:08:16',1,'{\"store\": \"default_backend\"}','deleted'),(18,'61f052d7-8449-475c-9b50-9097544e4d6c','rbd://c7c8e171-a193-56fb-95fa-8879fcfa7074/images/61f052d7-8449-475c-9b50-9097544e4d6c/snap','2025-12-02 10:08:04','2025-12-02 10:08:15','2025-12-02 10:08:15',1,'{\"store\": \"default_backend\"}','deleted'),(19,'f6e597b6-3bd0-4caa-984d-ee6ab1bd9d2c','rbd://c7c8e171-a193-56fb-95fa-8879fcfa7074/images/f6e597b6-3bd0-4caa-984d-ee6ab1bd9d2c/snap','2025-12-02 10:08:06','2025-12-02 10:08:14','2025-12-02 10:08:14',1,'{\"store\": \"default_backend\"}','deleted'),(20,'bd735000-c450-42a2-a1c6-94dc063a95df','rbd://c7c8e171-a193-56fb-95fa-8879fcfa7074/images/bd735000-c450-42a2-a1c6-94dc063a95df/snap','2025-12-02 10:08:08','2025-12-02 10:08:13','2025-12-02 10:08:13',1,'{\"store\": \"default_backend\"}','deleted'),(21,'b8d8d360-3c16-4056-ab8e-4260eeed7b5b','rbd://c7c8e171-a193-56fb-95fa-8879fcfa7074/images/b8d8d360-3c16-4056-ab8e-4260eeed7b5b/snap','2025-12-02 10:08:09','2025-12-02 10:08:11','2025-12-02 10:08:11',1,'{\"store\": \"default_backend\"}','deleted'),(22,'a8c7e4df-e32e-4adc-b852-475e42429fbf','rbd://c7c8e171-a193-56fb-95fa-8879fcfa7074/images/a8c7e4df-e32e-4adc-b852-475e42429fbf/snap','2025-12-02 10:10:48','2025-12-02 10:10:51','2025-12-02 10:10:51',1,'{\"store\": \"default_backend\"}','deleted'),(23,'dbb3cbac-f7b6-4733-bbe8-15adff32a83c','rbd://c7c8e171-a193-56fb-95fa-8879fcfa7074/images/dbb3cbac-f7b6-4733-bbe8-15adff32a83c/snap','2025-12-02 10:12:24','2025-12-02 10:12:27','2025-12-02 10:12:27',1,'{\"store\": \"default_backend\"}','deleted'),(24,'d212fccf-dfa0-4bfc-b6db-23e3712c592b','rbd://c7c8e171-a193-56fb-95fa-8879fcfa7074/images/d212fccf-dfa0-4bfc-b6db-23e3712c592b/snap','2025-12-02 10:12:27','2025-12-02 10:12:29','2025-12-02 10:12:29',1,'{\"store\": \"default_backend\"}','deleted'),(25,'f311438c-58d3-4fa5-978e-290e2aa21944','rbd://c7c8e171-a193-56fb-95fa-8879fcfa7074/images/f311438c-58d3-4fa5-978e-290e2aa21944/snap','2025-12-02 10:12:52','2025-12-02 10:12:54','2025-12-02 10:12:54',1,'{\"store\": \"default_backend\"}','deleted');
/*!40000 ALTER TABLE `image_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_members`
--

DROP TABLE IF EXISTS `image_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `member` varchar(255) NOT NULL,
  `can_share` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image_members_image_id_member_deleted_at_key` (`image_id`,`member`,`deleted_at`),
  KEY `ix_image_members_deleted` (`deleted`),
  KEY `ix_image_members_image_id` (`image_id`),
  KEY `ix_image_members_image_id_member` (`image_id`,`member`),
  CONSTRAINT `image_members_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`can_share` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_members`
--

LOCK TABLES `image_members` WRITE;
/*!40000 ALTER TABLE `image_members` DISABLE KEYS */;
INSERT INTO `image_members` (`id`, `image_id`, `member`, `can_share`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`) VALUES (1,'db00bb04-d8a7-4b40-ad3e-6c8fc16262fc','a837ee4fb9974541906c7fc2eec9ba40',0,'2025-12-02 10:05:48','2025-12-02 10:05:50','2025-12-02 10:05:50',1,'pending'),(2,'b1457ce7-184d-4a7f-9a7e-c58da8689aa4','7f13679661b54e1ebd2c8fc275ed2ee3',0,'2025-12-02 10:06:55','2025-12-02 10:06:55','2025-12-02 10:06:55',1,'accepted'),(3,'0bafce23-b1e8-4271-a316-3a558a49091d','7f13679661b54e1ebd2c8fc275ed2ee3',0,'2025-12-02 10:06:55','2025-12-02 10:06:55','2025-12-02 10:06:55',1,'accepted'),(4,'f78126b0-cfde-4fb9-b244-f8979c4cce65','7f13679661b54e1ebd2c8fc275ed2ee3',0,'2025-12-02 10:06:55','2025-12-02 10:06:56','2025-12-02 10:06:56',1,'rejected'),(5,'3bf087c7-e32f-4be9-9285-868ecac05fbf','7f13679661b54e1ebd2c8fc275ed2ee3',0,'2025-12-02 10:06:56','2025-12-02 10:06:56','2025-12-02 10:06:56',1,'accepted'),(6,'85387984-6c74-4c6e-8c9c-661114836f6e','4df4e32493bd40288350093e04e297a9',0,'2025-12-02 10:06:58','2025-12-02 10:06:58','2025-12-02 10:06:58',1,'pending'),(7,'18c91b6f-7d8e-4332-a799-ec52034d62e6','4df4e32493bd40288350093e04e297a9',0,'2025-12-02 10:06:58','2025-12-02 10:06:59','2025-12-02 10:06:59',1,'pending');
/*!40000 ALTER TABLE `image_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_properties`
--

DROP TABLE IF EXISTS `image_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_image_properties_image_id_name` (`image_id`,`name`),
  KEY `ix_image_properties_deleted` (`deleted`),
  KEY `ix_image_properties_image_id` (`image_id`),
  CONSTRAINT `image_properties_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_properties`
--

LOCK TABLES `image_properties` WRITE;
/*!40000 ALTER TABLE `image_properties` DISABLE KEYS */;
INSERT INTO `image_properties` (`id`, `image_id`, `name`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (2,'6dbbc069-a02f-4753-b6a8-9fb02d7e0aaa','owner_specified.openstack.md5','','2025-12-02 08:30:39','2025-12-02 08:30:39',NULL,0),(5,'6dbbc069-a02f-4753-b6a8-9fb02d7e0aaa','owner_specified.openstack.sha256','','2025-12-02 08:30:39','2025-12-02 08:30:39',NULL,0),(8,'6dbbc069-a02f-4753-b6a8-9fb02d7e0aaa','owner_specified.openstack.object','images/cirros','2025-12-02 08:30:39','2025-12-02 08:30:39',NULL,0),(11,'d85e840d-fa56-497b-b5bd-b49584d3e97a','hw_rng_model','virtio','2025-12-02 10:01:53','2025-12-02 10:01:53',NULL,0),(12,'9eb802b4-b54a-4025-8303-71322813986d','hw_rng_model','virtio','2025-12-02 10:01:56','2025-12-02 10:01:56',NULL,0),(13,'c6f7f1b0-6018-4e6f-a628-8d5a24dbbfd0','hw_rng_model','virtio','2025-12-02 10:02:58','2025-12-02 10:03:45','2025-12-02 10:03:45',1),(14,'c6f7f1b0-6018-4e6f-a628-8d5a24dbbfd0','base_image_ref','d85e840d-fa56-497b-b5bd-b49584d3e97a','2025-12-02 10:02:58','2025-12-02 10:03:45','2025-12-02 10:03:45',1),(15,'c6f7f1b0-6018-4e6f-a628-8d5a24dbbfd0','owner_user_name','tempest-UnshelveToHostMultiNodesTest-557689334-project-member','2025-12-02 10:02:58','2025-12-02 10:03:45','2025-12-02 10:03:45',1),(16,'c6f7f1b0-6018-4e6f-a628-8d5a24dbbfd0','owner_project_name','tempest-UnshelveToHostMultiNodesTest-557689334','2025-12-02 10:02:58','2025-12-02 10:03:45','2025-12-02 10:03:45',1),(17,'c6f7f1b0-6018-4e6f-a628-8d5a24dbbfd0','boot_roles','reader,member','2025-12-02 10:02:58','2025-12-02 10:03:45','2025-12-02 10:03:45',1),(18,'c6f7f1b0-6018-4e6f-a628-8d5a24dbbfd0','hw_machine_type','q35','2025-12-02 10:02:58','2025-12-02 10:03:45','2025-12-02 10:03:45',1),(19,'c6f7f1b0-6018-4e6f-a628-8d5a24dbbfd0','hw_cdrom_bus','sata','2025-12-02 10:02:58','2025-12-02 10:03:45','2025-12-02 10:03:45',1),(20,'c6f7f1b0-6018-4e6f-a628-8d5a24dbbfd0','hw_disk_bus','virtio','2025-12-02 10:02:58','2025-12-02 10:03:45','2025-12-02 10:03:45',1),(21,'c6f7f1b0-6018-4e6f-a628-8d5a24dbbfd0','hw_input_bus','usb','2025-12-02 10:02:58','2025-12-02 10:03:45','2025-12-02 10:03:45',1),(22,'c6f7f1b0-6018-4e6f-a628-8d5a24dbbfd0','hw_pointer_model','usbtablet','2025-12-02 10:02:58','2025-12-02 10:03:45','2025-12-02 10:03:45',1),(23,'c6f7f1b0-6018-4e6f-a628-8d5a24dbbfd0','hw_video_model','virtio','2025-12-02 10:02:58','2025-12-02 10:03:45','2025-12-02 10:03:45',1),(24,'c6f7f1b0-6018-4e6f-a628-8d5a24dbbfd0','hw_vif_model','virtio','2025-12-02 10:02:58','2025-12-02 10:03:45','2025-12-02 10:03:45',1),(25,'c6f7f1b0-6018-4e6f-a628-8d5a24dbbfd0','instance_uuid','268e09a3-7abe-4037-a14a-068e7b8a78fb','2025-12-02 10:02:58','2025-12-02 10:03:45','2025-12-02 10:03:45',1),(26,'c6f7f1b0-6018-4e6f-a628-8d5a24dbbfd0','user_id','96d084f3c3184bf4ac7b9635139dd4aa','2025-12-02 10:02:58','2025-12-02 10:03:45','2025-12-02 10:03:45',1),(27,'c6f7f1b0-6018-4e6f-a628-8d5a24dbbfd0','image_type','snapshot','2025-12-02 10:02:58','2025-12-02 10:03:45','2025-12-02 10:03:45',1),(28,'c6f7f1b0-6018-4e6f-a628-8d5a24dbbfd0','image_location','snapshot','2025-12-02 10:03:27','2025-12-02 10:03:45','2025-12-02 10:03:45',1),(29,'c6f7f1b0-6018-4e6f-a628-8d5a24dbbfd0','owner_id','09cae3217c5e430b8dbe17828669a978','2025-12-02 10:03:27','2025-12-02 10:03:45','2025-12-02 10:03:45',1),(30,'c6f7f1b0-6018-4e6f-a628-8d5a24dbbfd0','image_state','available','2025-12-02 10:03:27','2025-12-02 10:03:45','2025-12-02 10:03:45',1),(31,'0e87d55f-56a4-4da8-9198-c633785685ee','hw_rng_model','virtio','2025-12-02 10:03:46','2025-12-02 10:04:14','2025-12-02 10:04:14',1),(32,'0e87d55f-56a4-4da8-9198-c633785685ee','base_image_ref','d85e840d-fa56-497b-b5bd-b49584d3e97a','2025-12-02 10:03:46','2025-12-02 10:04:14','2025-12-02 10:04:14',1),(33,'0e87d55f-56a4-4da8-9198-c633785685ee','owner_user_name','tempest-UnshelveToHostMultiNodesTest-557689334-project-member','2025-12-02 10:03:46','2025-12-02 10:04:14','2025-12-02 10:04:14',1),(34,'0e87d55f-56a4-4da8-9198-c633785685ee','owner_project_name','tempest-UnshelveToHostMultiNodesTest-557689334','2025-12-02 10:03:46','2025-12-02 10:04:14','2025-12-02 10:04:14',1),(35,'0e87d55f-56a4-4da8-9198-c633785685ee','boot_roles','reader,member','2025-12-02 10:03:46','2025-12-02 10:04:14','2025-12-02 10:04:14',1),(36,'0e87d55f-56a4-4da8-9198-c633785685ee','hw_machine_type','q35','2025-12-02 10:03:46','2025-12-02 10:04:14','2025-12-02 10:04:14',1),(37,'0e87d55f-56a4-4da8-9198-c633785685ee','hw_cdrom_bus','sata','2025-12-02 10:03:46','2025-12-02 10:04:14','2025-12-02 10:04:14',1),(38,'0e87d55f-56a4-4da8-9198-c633785685ee','hw_disk_bus','virtio','2025-12-02 10:03:46','2025-12-02 10:04:14','2025-12-02 10:04:14',1),(39,'0e87d55f-56a4-4da8-9198-c633785685ee','hw_input_bus','usb','2025-12-02 10:03:46','2025-12-02 10:04:14','2025-12-02 10:04:14',1),(40,'0e87d55f-56a4-4da8-9198-c633785685ee','hw_pointer_model','usbtablet','2025-12-02 10:03:46','2025-12-02 10:04:14','2025-12-02 10:04:14',1),(41,'0e87d55f-56a4-4da8-9198-c633785685ee','hw_video_model','virtio','2025-12-02 10:03:46','2025-12-02 10:04:14','2025-12-02 10:04:14',1),(42,'0e87d55f-56a4-4da8-9198-c633785685ee','hw_vif_model','virtio','2025-12-02 10:03:46','2025-12-02 10:04:14','2025-12-02 10:04:14',1),(43,'0e87d55f-56a4-4da8-9198-c633785685ee','clean_attempts','1','2025-12-02 10:03:46','2025-12-02 10:04:14','2025-12-02 10:04:14',1),(44,'0e87d55f-56a4-4da8-9198-c633785685ee','instance_uuid','268e09a3-7abe-4037-a14a-068e7b8a78fb','2025-12-02 10:03:46','2025-12-02 10:04:14','2025-12-02 10:04:14',1),(45,'0e87d55f-56a4-4da8-9198-c633785685ee','user_id','96d084f3c3184bf4ac7b9635139dd4aa','2025-12-02 10:03:46','2025-12-02 10:04:14','2025-12-02 10:04:14',1),(46,'0e87d55f-56a4-4da8-9198-c633785685ee','image_type','snapshot','2025-12-02 10:03:46','2025-12-02 10:04:14','2025-12-02 10:04:14',1),(47,'0e87d55f-56a4-4da8-9198-c633785685ee','image_location','snapshot','2025-12-02 10:04:03','2025-12-02 10:04:14','2025-12-02 10:04:14',1),(48,'0e87d55f-56a4-4da8-9198-c633785685ee','owner_id','09cae3217c5e430b8dbe17828669a978','2025-12-02 10:04:03','2025-12-02 10:04:14','2025-12-02 10:04:14',1),(49,'0e87d55f-56a4-4da8-9198-c633785685ee','image_state','available','2025-12-02 10:04:03','2025-12-02 10:04:14','2025-12-02 10:04:14',1),(50,'86a5c305-d455-41ae-9be8-4fd53295ea9e','os_version','alt1','2025-12-02 10:05:02','2025-12-02 10:05:07','2025-12-02 10:05:07',1),(51,'86a5c305-d455-41ae-9be8-4fd53295ea9e','os_distro','value2','2025-12-02 10:05:02','2025-12-02 10:05:07','2025-12-02 10:05:07',1),(52,'86a5c305-d455-41ae-9be8-4fd53295ea9e','architecture','value3','2025-12-02 10:05:04','2025-12-02 10:05:07','2025-12-02 10:05:07',1),(53,'9ac90228-fc59-4e6a-b4cb-c08636b183e8','ramdisk_id','00000000-1111-2222-3333-444455556666','2025-12-02 10:06:35','2025-12-02 10:06:48','2025-12-02 10:06:48',1),(54,'9ac90228-fc59-4e6a-b4cb-c08636b183e8','os_glance_stage_host','http://glance-default-external-api-0.glance-default-external-api.openstack.svc:9292','2025-12-02 10:06:36','2025-12-02 10:06:48','2025-12-02 10:06:48',1),(56,'9ac90228-fc59-4e6a-b4cb-c08636b183e8','os_glance_importing_to_stores','','2025-12-02 10:06:36','2025-12-02 10:06:48','2025-12-02 10:06:48',1),(57,'9ac90228-fc59-4e6a-b4cb-c08636b183e8','os_glance_failed_import','','2025-12-02 10:06:36','2025-12-02 10:06:48','2025-12-02 10:06:48',1),(58,'a0ba66b9-185e-4137-961a-a4f10b3f6136','ramdisk_id','00000000-1111-2222-3333-444455556666','2025-12-02 10:06:38','2025-12-02 10:06:47','2025-12-02 10:06:47',1),(60,'a0ba66b9-185e-4137-961a-a4f10b3f6136','os_glance_importing_to_stores','','2025-12-02 10:06:38','2025-12-02 10:06:47','2025-12-02 10:06:47',1),(61,'a0ba66b9-185e-4137-961a-a4f10b3f6136','os_glance_failed_import','','2025-12-02 10:06:38','2025-12-02 10:06:47','2025-12-02 10:06:47',1),(62,'1b37b16b-8c27-4fa1-acbf-ba071f793034','ramdisk_id','00000000-1111-2222-3333-444455556666','2025-12-02 10:06:40','2025-12-02 10:06:44','2025-12-02 10:06:44',1),(64,'daf6ec8e-aba0-46a1-9183-9a20928550a2','os_glance_importing_to_stores','','2025-12-02 10:06:57','2025-12-02 10:06:57',NULL,0),(65,'daf6ec8e-aba0-46a1-9183-9a20928550a2','os_glance_failed_import','default_backend','2025-12-02 10:06:57','2025-12-02 10:06:57',NULL,0);
/*!40000 ALTER TABLE `image_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_tags`
--

DROP TABLE IF EXISTS `image_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_tags_image_id` (`image_id`),
  KEY `ix_image_tags_image_id_tag_value` (`image_id`,`value`),
  CONSTRAINT `image_tags_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_tags`
--

LOCK TABLES `image_tags` WRITE;
/*!40000 ALTER TABLE `image_tags` DISABLE KEYS */;
INSERT INTO `image_tags` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'36a0f089-dec1-40ba-ad0a-8dbba95294d9','tempest-tag-578302896','2025-12-02 10:06:04','2025-12-02 10:06:04','2025-12-02 10:06:04',1),(2,'b0da1701-1cdc-4fec-9cf6-624ef93e38f7','tempest-tag-1574119201','2025-12-02 10:08:00','2025-12-02 10:08:17','2025-12-02 10:08:17',1),(3,'b0da1701-1cdc-4fec-9cf6-624ef93e38f7','tempest-tag-1043974367','2025-12-02 10:08:00','2025-12-02 10:08:17','2025-12-02 10:08:17',1),(4,'8bcb180a-c1b9-4bf2-aef4-4e8f48518c53','tempest-tag-955043737','2025-12-02 10:08:02','2025-12-02 10:08:16','2025-12-02 10:08:16',1),(5,'8bcb180a-c1b9-4bf2-aef4-4e8f48518c53','tempest-tag-401970299','2025-12-02 10:08:02','2025-12-02 10:08:16','2025-12-02 10:08:16',1),(6,'61f052d7-8449-475c-9b50-9097544e4d6c','tempest-tag-659051141','2025-12-02 10:08:03','2025-12-02 10:08:15','2025-12-02 10:08:15',1),(7,'61f052d7-8449-475c-9b50-9097544e4d6c','tempest-tag-356047422','2025-12-02 10:08:03','2025-12-02 10:08:15','2025-12-02 10:08:15',1),(8,'f6e597b6-3bd0-4caa-984d-ee6ab1bd9d2c','tempest-tag-1542704607','2025-12-02 10:08:04','2025-12-02 10:08:14','2025-12-02 10:08:14',1),(9,'f6e597b6-3bd0-4caa-984d-ee6ab1bd9d2c','tempest-tag-70657284','2025-12-02 10:08:05','2025-12-02 10:08:14','2025-12-02 10:08:14',1),(10,'bd735000-c450-42a2-a1c6-94dc063a95df','tempest-tag-1596936886','2025-12-02 10:08:07','2025-12-02 10:08:13','2025-12-02 10:08:13',1),(11,'bd735000-c450-42a2-a1c6-94dc063a95df','tempest-tag-1029996771','2025-12-02 10:08:07','2025-12-02 10:08:13','2025-12-02 10:08:13',1),(12,'b8d8d360-3c16-4056-ab8e-4260eeed7b5b','tempest-tag-513359071','2025-12-02 10:08:08','2025-12-02 10:08:11','2025-12-02 10:08:11',1),(13,'b8d8d360-3c16-4056-ab8e-4260eeed7b5b','tempest-tag-102147681','2025-12-02 10:08:08','2025-12-02 10:08:11','2025-12-02 10:08:11',1);
/*!40000 ALTER TABLE `image_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `disk_format` varchar(20) DEFAULT NULL,
  `container_format` varchar(20) DEFAULT NULL,
  `checksum` varchar(32) DEFAULT NULL,
  `owner` varchar(255) DEFAULT NULL,
  `min_disk` int(11) NOT NULL,
  `min_ram` int(11) NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT 0,
  `virtual_size` bigint(20) DEFAULT NULL,
  `visibility` enum('private','public','shared','community') NOT NULL DEFAULT 'shared',
  `os_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `os_hash_algo` varchar(64) DEFAULT NULL,
  `os_hash_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checksum_image_idx` (`checksum`),
  KEY `ix_images_deleted` (`deleted`),
  KEY `owner_image_idx` (`owner`),
  KEY `created_at_image_idx` (`created_at`),
  KEY `updated_at_image_idx` (`updated_at`),
  KEY `visibility_image_idx` (`visibility`),
  KEY `os_hidden_image_idx` (`os_hidden`),
  KEY `os_hash_value_image_idx` (`os_hash_value`),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`protected` in (0,1)),
  CONSTRAINT `CONSTRAINT_4` CHECK (`os_hidden` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` (`id`, `name`, `size`, `status`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `disk_format`, `container_format`, `checksum`, `owner`, `min_disk`, `min_ram`, `protected`, `virtual_size`, `visibility`, `os_hidden`, `os_hash_algo`, `os_hash_value`) VALUES ('0bafce23-b1e8-4271-a316-3a558a49091d','tempest-ImagesMemberTest-image-1578189581',NULL,'deleted','2025-12-02 10:06:55','2025-12-02 10:06:55','2025-12-02 10:06:55',1,'raw','bare',NULL,'0be88e0bacc74023a71c648b2ffd76df',0,0,0,NULL,'shared',0,NULL,NULL),('0e87d55f-56a4-4da8-9198-c633785685ee','tempest-UnshelveToHostMultiNodesTest-server-2084001492-shelved',1073741824,'deleted','2025-12-02 10:03:46','2025-12-02 10:04:15','2025-12-02 10:04:15',1,'raw','bare',NULL,'09cae3217c5e430b8dbe17828669a978',1,0,0,NULL,'private',0,NULL,NULL),('119942e2-28df-44fe-8bed-c0ec84063da6','tempest-new-image-1576960696',NULL,'deleted','2025-12-02 10:06:42','2025-12-02 10:06:43','2025-12-02 10:06:43',1,'qcow2','bare',NULL,'0fb0fe5f66424978838a88f4b369a1f3',0,0,0,NULL,'private',0,NULL,NULL),('1663bbd7-fe34-4472-a61f-9258fdf935f6',NULL,NULL,'deleted','2025-12-02 10:06:27','2025-12-02 10:06:27','2025-12-02 10:06:27',1,'raw','bare',NULL,'e24bb976c4d2482485a629ffdafbe926',0,0,0,NULL,'shared',0,NULL,NULL),('16da75f7-81f8-4fc8-bc2b-0aec643d126c','tempest-ImagesTagsNegativeTest-image-2008950399',NULL,'deleted','2025-12-02 10:07:07','2025-12-02 10:07:07','2025-12-02 10:07:07',1,'raw','bare',NULL,'6f146e0fa2b9426199946be10fb7d352',0,0,0,NULL,'private',0,NULL,NULL),('18c91b6f-7d8e-4332-a799-ec52034d62e6','tempest-ImagesMemberNegativeTest-image-457059942',NULL,'deleted','2025-12-02 10:06:58','2025-12-02 10:06:59','2025-12-02 10:06:59',1,'raw','bare',NULL,'56875671962b4d1fb0ab6265ba45bca5',0,0,0,NULL,'shared',0,NULL,NULL),('1b37b16b-8c27-4fa1-acbf-ba071f793034','tempest-image-748894479',1024,'deleted','2025-12-02 10:06:40','2025-12-02 10:06:44','2025-12-02 10:06:44',1,'qcow2','bare','45261b2ed76071a0cf12175802c66921','0fb0fe5f66424978838a88f4b369a1f3',0,0,0,NULL,'private',0,'sha512','f32a232c7b52f5f725d31123e2db308a695e20bee5648e07c3a93180c443dfb8f8680142aa71e40ada57e3aab97e76209949e11061defa9373fe7d05d75790c5'),('1b788c52-7ca4-446f-8ffe-8562171f8744','tempest-test-418579120',NULL,'deleted','2025-12-02 10:07:03','2025-12-02 10:07:04','2025-12-02 10:07:04',1,'raw','bare',NULL,'eba5bcf78917466897ed8b0e11688a76',0,0,0,NULL,'shared',0,NULL,NULL),('1fecd906-b201-43b4-9d64-d13a5259e247','tempest-ListUserImagesTest-image-1038974175',NULL,'deleted','2025-12-02 10:08:10','2025-12-02 10:08:10','2025-12-02 10:08:10',1,NULL,NULL,NULL,'aaee8fe9c74942a5b83cec69b3422767',0,0,0,NULL,'shared',1,NULL,NULL),('21e0a1ae-a4d2-4438-9eda-7637ae4943fd','tempest-test-1037774038',NULL,'deleted','2025-12-02 10:07:04','2025-12-02 10:07:04','2025-12-02 10:07:04',1,'raw','bare',NULL,'eba5bcf78917466897ed8b0e11688a76',0,0,0,NULL,'shared',0,NULL,NULL),('36a0f089-dec1-40ba-ad0a-8dbba95294d9','tempest-ImagesTagsTest-image-1534668652',NULL,'deleted','2025-12-02 10:06:04','2025-12-02 10:06:04','2025-12-02 10:06:04',1,'raw','bare',NULL,'cd75a7517bed456ebadfb4e9059bf843',0,0,0,NULL,'private',0,NULL,NULL),('3bf087c7-e32f-4be9-9285-868ecac05fbf','tempest-ImagesMemberTest-image-948418619',NULL,'deleted','2025-12-02 10:06:56','2025-12-02 10:06:56','2025-12-02 10:06:56',1,'raw','bare',NULL,'0be88e0bacc74023a71c648b2ffd76df',0,0,0,NULL,'shared',0,NULL,NULL),('61519cba-c12a-4801-9657-36d6a30cad3a','tempest-image-2040535602',NULL,'deleted','2025-12-02 10:06:40','2025-12-02 10:06:40','2025-12-02 10:06:40',1,'qcow2','bare',NULL,'0fb0fe5f66424978838a88f4b369a1f3',0,0,0,NULL,'private',0,NULL,NULL),('61f052d7-8449-475c-9b50-9097544e4d6c','tempest-ListUserImagesTest-image-1345705883',1795,'deleted','2025-12-02 10:08:03','2025-12-02 10:08:15','2025-12-02 10:08:15',1,'ami','bare','d9a69caa5df9868cd9300bbdb409938a','aaee8fe9c74942a5b83cec69b3422767',0,0,0,NULL,'private',0,'sha512','8426001a42b8590b6eff149f1d20c822d8a80c292bd907ce3f59560792810cadcdc822e733ba5964f693b2f6d8a08649aa9736c5d7e0b722d8956a9cbd1b53bb'),('68efb09a-e4dc-4b36-9ba9-73b83b4311dd','tempest-BasicOperationsImagesAdminTest-Image-1613263177',NULL,'deleted','2025-12-02 10:06:27','2025-12-02 10:06:28','2025-12-02 10:06:28',1,'raw','bare',NULL,'36336a565214410ca32205584d7a6cfe',0,0,0,NULL,'public',0,NULL,NULL),('6dbbc069-a02f-4753-b6a8-9fb02d7e0aaa','cirros',21692416,'active','2025-12-02 08:30:39','2025-12-02 08:30:43',NULL,0,'qcow2','bare','87617e24a5e30cb3b87fda8c0764838f','e2d97696ab6749899bb8ba5ce29a3de2',0,0,0,117440512,'shared',0,'sha512','9a9bce0083a00939ec17c11febbfc767aa211aaa54f51e75c5a8b271a9b5637c77205a518b7a2007cb391d23cceb01e0e4e8d64832317151bc85b734b92a7be0'),('85387984-6c74-4c6e-8c9c-661114836f6e','tempest-ImagesMemberNegativeTest-image-244805272',NULL,'deleted','2025-12-02 10:06:58','2025-12-02 10:06:58','2025-12-02 10:06:58',1,'raw','bare',NULL,'56875671962b4d1fb0ab6265ba45bca5',0,0,0,NULL,'shared',0,NULL,NULL),('86a5c305-d455-41ae-9be8-4fd53295ea9e','tempest-image-1277543242',1024,'deleted','2025-12-02 10:05:01','2025-12-02 10:05:07','2025-12-02 10:05:07',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','2c4fc4d93982419f8c27f4099ef74206',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('8ac3e643-6e48-4b4f-9488-fe99e04b1f5c','tempest-image-1492439327',2179,'deleted','2025-12-02 10:02:56','2025-12-02 10:03:00','2025-12-02 10:03:00',1,'qcow2','bare','0fb4c56c6f45172c2dda481320bc0abe','40b3586c2f7b47f79dfa6f883ac66798',0,129,0,NULL,'private',0,'sha512','2fa618e02b6d450d6fb38d2ca41c047c3891c04821212128a2aab35d55874b0cc0b927194a2cba51721b40b7c0dc8ad870971c911ba795731d30e56e8e4e60cd'),('8bcb180a-c1b9-4bf2-aef4-4e8f48518c53','tempest-ListUserImagesTest-image-1792530468',3751,'deleted','2025-12-02 10:08:02','2025-12-02 10:08:16','2025-12-02 10:08:16',1,'raw','bare','8ea2df96c434b9b52c323453c134a181','aaee8fe9c74942a5b83cec69b3422767',0,0,0,3751,'private',0,'sha512','aa401bacab3cec98d731825b4e04240259f3b59efa037578eeff61e61cee4cd31982707c4e90780da7db413a82d1ad16c82bd6d4ba49e3869ec4753cd4d05cdc'),('9ac90228-fc59-4e6a-b4cb-c08636b183e8','tempest-image-1987505805',1024,'deleted','2025-12-02 10:06:35','2025-12-02 10:06:48','2025-12-02 10:06:48',1,'raw','bare','c6ed6b3c39e1b2750fa4334c5f72d163','4375c13984ab45c28b6c5c0320c0ae6c',0,0,0,1024,'private',0,'sha512','f29f4cbef0c1e1fb9675e90b471fd0199976d05828ecf28eaa698648c5d4ed4eead969243052d89f2e736522731ecb0ffe5d96f9a79ae8f161848ef5f5e0df72'),('9eb802b4-b54a-4025-8303-71322813986d','cirros-0.6.2-x86_64-disk.img_alt',21430272,'active','2025-12-02 10:01:56','2025-12-02 10:01:57',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','e2d97696ab6749899bb8ba5ce29a3de2',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('a0ba66b9-185e-4137-961a-a4f10b3f6136','tempest-image-1652699619',117440512,'deleted','2025-12-02 10:06:38','2025-12-02 10:06:47','2025-12-02 10:06:47',1,'raw','bare','4245576e3df99ea1211871b8b9514d3b','4375c13984ab45c28b6c5c0320c0ae6c',0,0,0,117440512,'private',0,'sha512','dbb480bdc4f13ead7e00b62766df2815ddc8d4775af8a82ec40f8afd433d4cb95a109a58fbe7e0a661be86e0a06321c00362bc881f58c61c40bd2d1486954594'),('a8c7e4df-e32e-4adc-b852-475e42429fbf','tempest-VolumesActionsTest-Image-1096127377',1073741824,'deleted','2025-12-02 10:10:05','2025-12-02 10:10:51','2025-12-02 10:10:51',1,'raw','bare','cd573cfaace07e7949bc0c46028904ff','5bad680c763640dba71a7865b355817c',0,0,0,1073741824,'shared',0,'sha512','c5041ae163cf0f65600acfe7f6a63f212101687d41a57a4e18ffd2a07a452cd8175b8f5a4868dd2330bfe5ae123f18216bdbc9e0f80d131e64b94913a7b40bb5'),('b0da1701-1cdc-4fec-9cf6-624ef93e38f7','tempest-ListUserImagesTest-image-1592947294',2805,'deleted','2025-12-02 10:08:00','2025-12-02 10:08:17','2025-12-02 10:08:17',1,'qcow2','bare','dbe8192c23cc9831d41fe5229d8433a4','aaee8fe9c74942a5b83cec69b3422767',0,0,0,NULL,'private',0,'sha512','8bb8e9f9bb975901404fd36727d7edd1ef55e7b71a833fee30bc07b24bb83f7158301cc3a07a27371d5e59c0c288b72e883006d7041a6e3dd7f841dd193105c4'),('b1457ce7-184d-4a7f-9a7e-c58da8689aa4','tempest-ImagesMemberTest-image-1104473703',NULL,'deleted','2025-12-02 10:06:55','2025-12-02 10:06:55','2025-12-02 10:06:55',1,'raw','bare',NULL,'0be88e0bacc74023a71c648b2ffd76df',0,0,0,NULL,'shared',0,NULL,NULL),('b8d8d360-3c16-4056-ab8e-4260eeed7b5b','tempest-ListUserImagesTest-image-416995192',1867,'deleted','2025-12-02 10:08:08','2025-12-02 10:08:11','2025-12-02 10:08:11',1,'vhd','bare','0245a8742cac18f8cac3965ee9b660a6','aaee8fe9c74942a5b83cec69b3422767',0,0,0,NULL,'private',0,'sha512','29f616463a67f24cf55fa7cad19e44a8a1757a81f9bfed6ede9117478e46e0007649d183a3ef6bfbf14d8f2aba77ff374487083e9d0fcdd8d83424061a5898fc'),('bd735000-c450-42a2-a1c6-94dc063a95df','tempest-ListUserImagesTest-image-1961002372',1877,'deleted','2025-12-02 10:08:07','2025-12-02 10:08:13','2025-12-02 10:08:13',1,'aki','bare','58e91655b9d6dfe64c7c0c539e88f4bb','aaee8fe9c74942a5b83cec69b3422767',0,0,0,NULL,'private',0,'sha512','5cfdc8cfe57bfcb83ad5c54040c2954945ac71361701d154602ef57333da329dc40b0d1bcc32fac2518858417cd15b58b242e32a3154b9c001ee3cc548225bfb'),('bfb8d952-707b-49fc-9fb5-e15ee93499bd','tempest-task_image-958765876',NULL,'deleted','2025-12-02 10:05:54','2025-12-02 10:05:54','2025-12-02 10:05:54',1,'qcow2','bare',NULL,NULL,0,0,0,NULL,'public',0,NULL,NULL),('c6f7f1b0-6018-4e6f-a628-8d5a24dbbfd0','tempest-UnshelveToHostMultiNodesTest-server-2084001492-shelved',1073741824,'deleted','2025-12-02 10:02:58','2025-12-02 10:03:45','2025-12-02 10:03:45',1,'raw','bare',NULL,'09cae3217c5e430b8dbe17828669a978',1,0,0,NULL,'private',0,NULL,NULL),('ca16720c-af3e-4ee9-8b06-dc516622dede',NULL,NULL,'deleted','2025-12-02 10:08:09','2025-12-02 10:08:09','2025-12-02 10:08:09',1,NULL,NULL,NULL,'aaee8fe9c74942a5b83cec69b3422767',0,0,0,NULL,'shared',1,NULL,NULL),('d212fccf-dfa0-4bfc-b6db-23e3712c592b','tempest-VolumesNegativeTest-image-796058532',1024,'deleted','2025-12-02 10:12:27','2025-12-02 10:12:29','2025-12-02 10:12:29',1,'qcow2','bare','9aef7beec4ac592cc4e74c32fce4b8b0','9983d967265d4691806eb9b9a49900de',2,0,0,NULL,'private',0,'sha512','8cdde5e925d27eb495debbc961922cad2a54d4585451d53fa37078825d32fecb19af03942e3666a2334ec32471d10ac4dc232a7efd470e212cd8c77843e41e20'),('d6b3dfef-8217-4d04-8b7f-234fe4dff326','tempest-image-1293696800',1024,'deleted','2025-12-02 10:06:38','2025-12-02 10:06:45','2025-12-02 10:06:45',1,'raw','bare','a8844cb90fb1139a840eb2de90d8f866','0fb0fe5f66424978838a88f4b369a1f3',0,0,0,1024,'private',0,'sha512','c0110c72be6ac7e62ea8e202049a3debb4acfd68e9d07948b10f4dccefd4e28cfeaf960cc367fd2cd99b1202536ad534d7df8f7fa2af5d62b46e0274b0ee2975'),('d85e840d-fa56-497b-b5bd-b49584d3e97a','cirros-0.6.2-x86_64-disk.img',21430272,'active','2025-12-02 10:01:53','2025-12-02 10:01:55',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','e2d97696ab6749899bb8ba5ce29a3de2',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('daf6ec8e-aba0-46a1-9183-9a20928550a2','tempest-test-755243479',NULL,'queued','2025-12-02 10:06:57','2025-12-02 10:06:57',NULL,0,'raw','bare',NULL,'68963b5bdacc408aa9adc69ff150d3f8',0,0,0,NULL,'shared',0,NULL,NULL),('db00bb04-d8a7-4b40-ad3e-6c8fc16262fc','tempest-ListSharedImagesTest-image-548163172',2048,'deleted','2025-12-02 10:05:47','2025-12-02 10:05:50','2025-12-02 10:05:50',1,'qcow2','bare','b8dc2538a020251a2bccc90e8cee59c4','3f58dd78a8cd471aab71f49f2af8bf09',0,0,0,NULL,'shared',0,'sha512','a2309d1dc6e62e0c716d6fa366159988203c827d129d475bc0acb9c6fb74d2bcc428195545a1728a1f1d84c04846928f361c39c27cc3195f1bc60cd95bd89e81'),('dbb3cbac-f7b6-4733-bbe8-15adff32a83c','tempest-VolumesNegativeTest-image-1171029943',1024,'deleted','2025-12-02 10:12:23','2025-12-02 10:12:27','2025-12-02 10:12:27',1,'qcow2','bare','0599e2c2808925d53a76c62352f2b742','9983d967265d4691806eb9b9a49900de',2,0,0,NULL,'private',0,'sha512','0e03b9ce73e516837b03f822365a27e9674566ab85e30217734a491c8e0f510f5799862c534c5f517fc106b33ac6b9a9a5917d8605d86fd169819f3353508d30'),('e4f8c833-9dae-4dc1-b3e5-7da1dbcfbdc4','tempest-test-1958536352',NULL,'deleted','2025-12-02 10:07:03','2025-12-02 10:07:04','2025-12-02 10:07:04',1,NULL,NULL,NULL,'eba5bcf78917466897ed8b0e11688a76',0,0,0,NULL,'shared',0,NULL,NULL),('f2fe0849-3ff3-4bf1-90e7-d1b45619167e',NULL,NULL,'deleted','2025-12-02 10:06:28','2025-12-02 10:06:28','2025-12-02 10:06:28',1,'raw','bare',NULL,'7ee186d1aa924d0798be050a392a6ccb',0,0,0,NULL,'shared',0,NULL,NULL),('f311438c-58d3-4fa5-978e-290e2aa21944','tempest-scenario-img--2060281800',21430272,'deleted','2025-12-02 10:12:49','2025-12-02 10:12:54','2025-12-02 10:12:54',1,'qcow2','bare','c8fc807773e5354afe61636071771906','b02ac233ae12415688cf9d451b55b171',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('f6e597b6-3bd0-4caa-984d-ee6ab1bd9d2c','tempest-ListUserImagesTest-image-1815182131',2424,'deleted','2025-12-02 10:08:04','2025-12-02 10:08:14','2025-12-02 10:08:14',1,'ari','bare','586d15c413e0cc9070154fa448230347','aaee8fe9c74942a5b83cec69b3422767',0,0,0,NULL,'private',0,'sha512','71a4e7330887de5852be4bd78c5c09141dd60a13996f48836e8079e7c5c4c70905129fbbac6e622226e7d42183baa87f00a1483c92c8d4985b5e269a984d53bd'),('f78126b0-cfde-4fb9-b244-f8979c4cce65','tempest-ImagesMemberTest-image-344144387',NULL,'deleted','2025-12-02 10:06:55','2025-12-02 10:06:56','2025-12-02 10:06:56',1,'raw','bare',NULL,'0be88e0bacc74023a71c648b2ffd76df',0,0,0,NULL,'shared',0,NULL,NULL);
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespace_resource_types`
--

DROP TABLE IF EXISTS `metadef_namespace_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespace_resource_types` (
  `resource_type_id` int(11) NOT NULL,
  `namespace_id` int(11) NOT NULL,
  `properties_target` varchar(80) DEFAULT NULL,
  `prefix` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`resource_type_id`,`namespace_id`),
  KEY `ix_metadef_ns_res_types_namespace_id` (`namespace_id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_2` FOREIGN KEY (`resource_type_id`) REFERENCES `metadef_resource_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespace_resource_types`
--

LOCK TABLES `metadef_namespace_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_namespace_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_namespace_resource_types` (`resource_type_id`, `namespace_id`, `properties_target`, `prefix`, `created_at`, `updated_at`) VALUES (2,2,'image','CIM_PASD_','2025-12-02 08:13:27',NULL),(2,5,'image','CIM_RASD_','2025-12-02 08:13:28',NULL),(2,8,NULL,'CIM_SASD_','2025-12-02 08:13:28',NULL),(2,23,'image','hw_','2025-12-02 08:13:30',NULL),(2,26,'image','hw_','2025-12-02 08:13:30',NULL),(2,38,'image',NULL,'2025-12-02 08:13:32',NULL),(2,53,'image','hw_','2025-12-02 08:13:34',NULL),(2,65,'image','hw_','2025-12-02 08:13:35',NULL),(2,77,'image',NULL,'2025-12-02 08:13:36',NULL),(2,80,'image',NULL,'2025-12-02 08:13:36',NULL),(2,83,'image',NULL,'2025-12-02 08:13:37',NULL),(2,86,'image',NULL,'2025-12-02 08:13:38',NULL),(5,2,NULL,'CIM_PASD_','2025-12-02 08:13:27',NULL),(5,23,NULL,'hw_','2025-12-02 08:13:30',NULL),(5,26,NULL,'hw_','2025-12-02 08:13:30',NULL),(5,29,NULL,NULL,'2025-12-02 08:13:31',NULL),(5,35,NULL,NULL,'2025-12-02 08:13:31',NULL),(5,38,NULL,NULL,'2025-12-02 08:13:32',NULL),(5,41,NULL,NULL,'2025-12-02 08:13:32',NULL),(5,44,NULL,'hw_','2025-12-02 08:13:33',NULL),(5,53,NULL,'hw_','2025-12-02 08:13:34',NULL),(5,62,NULL,NULL,'2025-12-02 08:13:35',NULL),(5,65,NULL,'hw_','2025-12-02 08:13:35',NULL),(5,68,NULL,NULL,'2025-12-02 08:13:35',NULL),(5,74,NULL,NULL,'2025-12-02 08:13:35',NULL),(5,77,NULL,NULL,'2025-12-02 08:13:36',NULL),(5,80,NULL,NULL,'2025-12-02 08:13:36',NULL),(5,83,NULL,NULL,'2025-12-02 08:13:37',NULL),(5,86,NULL,NULL,'2025-12-02 08:13:38',NULL),(5,89,NULL,'cinder_','2025-12-02 08:13:38',NULL),(5,92,NULL,'hw_','2025-12-02 08:52:15',NULL),(5,93,NULL,'hw_','2025-12-02 08:52:15',NULL),(5,94,NULL,'traits:','2025-12-02 08:52:15',NULL),(8,2,NULL,'CIM_PASD_','2025-12-02 08:13:27',NULL),(8,5,NULL,'CIM_RASD_','2025-12-02 08:13:28',NULL),(8,8,NULL,'CIM_SASD_','2025-12-02 08:13:28',NULL),(8,11,NULL,'CIM_VSSD_','2025-12-02 08:13:29',NULL),(8,14,NULL,NULL,'2025-12-02 08:13:29',NULL),(8,17,NULL,NULL,'2025-12-02 08:13:30',NULL),(8,20,NULL,NULL,'2025-12-02 08:13:30',NULL),(8,32,NULL,'aggregate_instance_extra_specs:','2025-12-02 08:13:31',NULL),(11,2,NULL,'CIM_PASD_','2025-12-02 08:13:27',NULL),(11,5,NULL,'CIM_RASD_','2025-12-02 08:13:28',NULL),(11,8,NULL,'CIM_SASD_','2025-12-02 08:13:28',NULL),(11,11,NULL,'CIM_VSSD_','2025-12-02 08:13:29',NULL),(11,23,NULL,'hw:','2025-12-02 08:13:30',NULL),(11,26,NULL,'hw:','2025-12-02 08:13:30',NULL),(11,32,NULL,'capabilities:','2025-12-02 08:13:31',NULL),(11,44,NULL,'hw:','2025-12-02 08:13:33',NULL),(11,47,NULL,NULL,'2025-12-02 08:13:34',NULL),(11,50,NULL,NULL,'2025-12-02 08:13:34',NULL),(11,53,NULL,'hw:','2025-12-02 08:13:34',NULL),(11,56,NULL,NULL,'2025-12-02 08:13:34',NULL),(11,59,NULL,NULL,'2025-12-02 08:13:34',NULL),(11,65,NULL,'hw:','2025-12-02 08:13:35',NULL),(11,92,NULL,'hw:','2025-12-02 08:52:15',NULL),(11,93,NULL,'hw:','2025-12-02 08:52:15',NULL),(11,94,NULL,'traits:','2025-12-02 08:52:15',NULL),(14,2,'scheduler_hints',NULL,'2025-12-02 08:13:27',NULL),(14,80,'metadata',NULL,'2025-12-02 08:13:36',NULL),(14,83,'metadata',NULL,'2025-12-02 08:13:37',NULL),(14,86,'metadata',NULL,'2025-12-02 08:13:38',NULL),(17,80,NULL,NULL,'2025-12-02 08:13:36',NULL);
/*!40000 ALTER TABLE `metadef_namespace_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespaces`
--

DROP TABLE IF EXISTS `metadef_namespaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespaces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace` varchar(80) NOT NULL,
  `display_name` varchar(80) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `visibility` varchar(32) DEFAULT NULL,
  `protected` tinyint(1) DEFAULT NULL,
  `owner` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_namespaces_namespace` (`namespace`),
  KEY `ix_metadef_namespaces_owner` (`owner`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=103 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespaces`
--

LOCK TABLES `metadef_namespaces` WRITE;
/*!40000 ALTER TABLE `metadef_namespaces` DISABLE KEYS */;
INSERT INTO `metadef_namespaces` (`id`, `namespace`, `display_name`, `description`, `visibility`, `protected`, `owner`, `created_at`, `updated_at`) VALUES (2,'CIM::ProcessorAllocationSettingData','CIM Processor Allocation Setting','Properties related to the resource allocation settings of a processor (CPU) from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These are properties that identify processor setting data and may be specified to volume, image, host aggregate, flavor and Nova server as scheduler hint. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ProcessorAllocationSettingData.html.','public',1,'admin','2025-12-02 08:13:27',NULL),(5,'CIM::ResourceAllocationSettingData','CIM Resource Allocation Setting Data','Properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim) that represent settings specifically related to an allocated resource that are outside the scope of the CIM class typically used to represent the resource itself. These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ResourceAllocationSettingData.html.','public',1,'admin','2025-12-02 08:13:28',NULL),(8,'CIM::StorageAllocationSettingData','CIM Storage Allocation Setting Data','Properties related to the allocation of virtual storage from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_StorageAllocationSettingData.html.','public',1,'admin','2025-12-02 08:13:28',NULL),(11,'CIM::VirtualSystemSettingData','CIM Virtual System Setting Data','A set of virtualization specific properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim), which define the virtual aspects of a virtual system. These properties may be specified to host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_VirtualSystemSettingData.html.','public',1,'admin','2025-12-02 08:13:29',NULL),(14,'OS::Compute::AggregateDiskFilter','Disk Allocation per Host','Properties related to the Nova scheduler filter AggregateDiskFilter. Filters aggregate hosts based on the available disk space compared to the requested disk space. Hosts in the aggregate with not enough usable disk will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-12-02 08:13:29',NULL),(17,'OS::Compute::AggregateIoOpsFilter','IO Ops per Host','Properties related to the Nova scheduler filter AggregateIoOpsFilter. Filters aggregate hosts based on the number of instances currently changing state. Hosts in the aggregate with too many instances changing state will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-12-02 08:13:29',NULL),(20,'OS::Compute::AggregateNumInstancesFilter','Instances per Host','Properties related to the Nova scheduler filter AggregateNumInstancesFilter. Filters aggregate hosts by the number of running instances on it. Hosts in the aggregate with too many instances will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',0,'admin','2025-12-02 08:13:30',NULL),(23,'OS::Compute::CPUPinning','CPU Pinning','This provides the preferred CPU pinning and CPU thread pinning policy to be used when pinning vCPU of the guest to pCPU of the host. See http://docs.openstack.org/admin-guide/compute-numa-cpu-pinning.html','public',1,'admin','2025-12-02 08:13:30',NULL),(26,'OS::Compute::GuestMemoryBacking','Guest Memory Backing','This provides the preferred backing option for guest RAM. Guest\'s memory can be backed by hugepages to limit TLB lookups. See also: https://wiki.openstack.org/wiki/VirtDriverGuestCPUMemoryPlacement','public',1,'admin','2025-12-02 08:13:30',NULL),(29,'OS::Compute::GuestShutdownBehavior','Shutdown Behavior','These properties allow modifying the shutdown behavior for stop, rescue, resize, and shelve operations.','public',1,'admin','2025-12-02 08:13:31',NULL),(32,'OS::Compute::HostCapabilities','Compute Host Capabilities','Hardware capabilities provided by the compute host. This provides the ability to fine tune the hardware specification required when an instance is requested. The ComputeCapabilitiesFilter should be enabled in the Nova scheduler to use these properties. When enabled, this filter checks that the capabilities provided by the compute host satisfy any extra specifications requested. Only hosts that can provide the requested capabilities will be eligible for hosting the instance.','public',1,'admin','2025-12-02 08:13:31',NULL),(35,'OS::Compute::Hypervisor','Hypervisor Selection','OpenStack Compute supports many hypervisors, although most installations use only one hypervisor. For installations with multiple supported hypervisors, you can schedule different hypervisors using the ImagePropertiesFilter. This filters compute nodes that satisfy any architecture, hypervisor type, or virtual machine mode properties specified on the instance\'s image properties.','public',1,'admin','2025-12-02 08:13:31',NULL),(38,'OS::Compute::InstanceData','Instance Config Data','Instances can perform self-configuration based on data made available to the running instance. These properties affect instance configuration.','public',1,'admin','2025-12-02 08:13:32',NULL),(41,'OS::Compute::LibvirtImage','libvirt Driver Options for Images','The libvirt Compute Driver Options for Glance Images.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-02 08:13:32',NULL),(44,'OS::Compute::Libvirt','libvirt Driver Options','The libvirt compute driver options.  \n\nThese are properties that affect the libvirt compute driver and may be specified on flavors and images.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-02 08:13:33',NULL),(47,'OS::Compute::Quota','Flavor Quota','Compute drivers may enable quotas on CPUs available to a VM, disk tuning, bandwidth I/O, and instance VIF traffic control.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-02 08:13:33',NULL),(50,'OS::Compute::RandomNumberGenerator','Random Number Generator','If a random-number generator device has been added to the instance through its image properties, the device can be enabled and configured.','public',1,'admin','2025-12-02 08:13:34',NULL),(53,'OS::Compute::VirtCPUTopology','Virtual CPU Topology','This provides the preferred socket/core/thread counts for the virtual CPU instance exposed to guests. This enables the ability to avoid hitting limitations on vCPU topologies that OS vendors place on their products. See also: https://opendev.org/openstack/nova-specs/src/branch/master/specs/juno/implemented/virt-driver-vcpu-topology.rst','public',1,'admin','2025-12-02 08:13:34',NULL),(56,'OS::Compute::VMwareFlavor','VMware Driver Options for Flavors','VMware Driver Options for Flavors may be used to customize and manage Nova Flavors. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-02 08:13:34',NULL),(59,'OS::Compute::VMwareQuotaFlavor','VMware Quota for Flavors','The VMware compute driver allows various compute quotas to be specified on flavors. When specified, the VMWare driver will ensure that the quota is enforced. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. For a list of hypervisors, see: https://wiki.openstack.org/wiki/HypervisorSupportMatrix. For flavor customization, see: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-02 08:13:34',NULL),(62,'OS::Compute::VMware','VMware Driver Options','The VMware compute driver options.  \n\nThese are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-02 08:13:35',NULL),(65,'OS::Compute::Watchdog','Watchdog Behavior','Compute drivers may enable watchdog behavior over instances.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-02 08:13:35',NULL),(68,'OS::Compute::XenAPI','XenAPI Driver Options','The XenAPI compute driver options.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-02 08:13:35',NULL),(71,'OS::Glance::CommonImageProperties','Common Image Properties','When adding an image to Glance, you may specify some common image properties that may prove useful to consumers of your image.',NULL,1,'admin','2025-12-02 08:13:35',NULL),(74,'OS::Glance::Signatures','Image Signature Verification','Image signature verification allows the user to verify that an image has not been modified prior to booting the image.','public',0,'admin','2025-12-02 08:13:35',NULL),(77,'OS::OperatingSystem','Common Operating System Properties','Details of the operating system contained within this image as well as common operating system properties that can be set on a VM instance created from this image.',NULL,1,'admin','2025-12-02 08:13:36',NULL),(80,'OS::Software::DBMS','Database Software','A database is an organized collection of data. The data is typically organized to model aspects of reality in a way that supports processes requiring information. Database management systems are computer software applications that interact with the user, other applications, and the database itself to capture and analyze data. (http://en.wikipedia.org/wiki/Database)','public',1,'admin','2025-12-02 08:13:36',NULL),(83,'OS::Software::Runtimes','Runtime Environment','Software is written in a specific programming language and the language must execute within a runtime environment. The runtime environment provides an abstraction to utilizing a computer\'s processor, memory (RAM), and other system resources.','public',1,'admin','2025-12-02 08:13:37',NULL),(86,'OS::Software::WebServers','Web Servers','A web server is a computer system that processes requests via HTTP, the basic network protocol used to distribute information on the World Wide Web. The most common use of web servers is to host websites, but there are other uses such as gaming, data storage, running enterprise applications, handling email, FTP, or other web uses. (http://en.wikipedia.org/wiki/Web_server)','public',1,'admin','2025-12-02 08:13:38',NULL),(89,'OS::Cinder::Volumetype','Cinder Volume Type','The Cinder volume type configuration option. Volume type assignment provides a mechanism not only to provide scheduling to a specific storage back-end, but also can be used to specify specific information for a back-end storage device to act upon.','public',1,'admin','2025-12-02 08:13:38',NULL),(92,'OS::Compute::CPUMode','CPU Mode','This provides the preferred CPU Model to be used when booting up a guest VM.','public',NULL,'admin','2025-12-02 08:52:15',NULL),(93,'OS::Compute::TPM','TPM Options','Configuration options for TPM','public',1,'admin','2025-12-02 08:52:15',NULL),(94,'OS::Compute::VTPM','Emulated Virtual TPM','Configuration options for Emulated Virtual TPM','public',1,'admin','2025-12-02 08:52:15',NULL);
/*!40000 ALTER TABLE `metadef_namespaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_objects`
--

DROP TABLE IF EXISTS `metadef_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `description` text DEFAULT NULL,
  `required` text DEFAULT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_objects_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_objects_name` (`name`),
  CONSTRAINT `metadef_objects_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_objects`
--

LOCK TABLES `metadef_objects` WRITE;
/*!40000 ALTER TABLE `metadef_objects` DISABLE KEYS */;
INSERT INTO `metadef_objects` (`id`, `namespace_id`, `name`, `description`, `required`, `json_schema`, `created_at`, `updated_at`) VALUES (2,47,'CPU Limits','You can configure the CPU limits with control parameters.',NULL,'{\"quota:cpu_shares\": {\"title\": \"Quota: CPU Shares\", \"description\": \"Specifies the proportional weighted share for the domain. If this element is omitted, the service defaults to the OS provided defaults. There is no unit for the value; it is a relative measure based on the setting of other VMs. For example, a VM configured with value 2048 gets twice as much CPU time as a VM configured with value 1024.\", \"type\": \"integer\"}, \"quota:cpu_period\": {\"title\": \"Quota: CPU Period\", \"description\": \"Specifies the enforcement interval (unit: microseconds) for QEMU and LXC hypervisors. Within a period, each VCPU of the domain is not allowed to consume more than the quota worth of runtime. The value should be in range [1000, 1000000]. A period with value 0 means no value.\", \"type\": \"integer\", \"minimum\": 1000, \"maximum\": 1000000}, \"quota:cpu_quota\": {\"title\": \"Quota: CPU Quota\", \"description\": \"Specifies the maximum allowed bandwidth (unit: microseconds). A domain with a negative-value quota indicates that the domain has infinite bandwidth, which means that it is not bandwidth controlled. The value should be in range [1000, 18446744073709551] or less than 0. A quota with value 0 means no value. You can use this feature to ensure that all vCPUs run at the same speed.\", \"type\": \"integer\"}}','2025-12-02 08:13:34',NULL),(5,47,'Disk QoS','Using disk I/O quotas, you can set maximum disk write to 10 MB per second for a VM user.',NULL,'{\"quota:disk_read_bytes_sec\": {\"title\": \"Quota: Disk read bytes / sec\", \"description\": \"Sets disk I/O quota for disk read bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_read_iops_sec\": {\"title\": \"Quota: Disk read IOPS / sec\", \"description\": \"Sets disk I/O quota for disk read IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_write_bytes_sec\": {\"title\": \"Quota: Disk Write Bytes / sec\", \"description\": \"Sets disk I/O quota for disk write bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_write_iops_sec\": {\"title\": \"Quota: Disk Write IOPS / sec\", \"description\": \"Sets disk I/O quota for disk write IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_total_bytes_sec\": {\"title\": \"Quota: Disk Total Bytes / sec\", \"description\": \"Sets disk I/O quota for total disk bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_total_iops_sec\": {\"title\": \"Quota: Disk Total IOPS / sec\", \"description\": \"Sets disk I/O quota for disk total IOPS / sec.\", \"type\": \"integer\"}}','2025-12-02 08:13:34',NULL),(8,47,'Virtual Interface QoS','Bandwidth QoS tuning for instance virtual interfaces (VIFs) may be specified with these properties. Incoming and outgoing traffic can be shaped independently. If not specified, no quality of service (QoS) is applied on that traffic direction. So, if you want to shape only the network\'s incoming traffic, use inbound only (and vice versa). The OpenStack Networking service abstracts the physical implementation of the network, allowing plugins to configure and manage physical resources. Virtual Interfaces (VIF) in the logical model are analogous to physical network interface cards (NICs). VIFs are typically owned a managed by an external service; for instance when OpenStack Networking is used for building OpenStack networks, VIFs would be created, owned, and managed in Nova. VIFs are connected to OpenStack Networking networks via ports. A port is analogous to a port on a network switch, and it has an administrative state. When a VIF is attached to a port the OpenStack Networking API creates an attachment object, which specifies the fact that a VIF with a given identifier is plugged into the port.',NULL,'{\"quota:vif_inbound_average\": {\"title\": \"Quota: VIF Inbound Average\", \"description\": \"Network Virtual Interface (VIF) inbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_inbound_burst\": {\"title\": \"Quota: VIF Inbound Burst\", \"description\": \"Network Virtual Interface (VIF) inbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_inbound_peak\": {\"title\": \"Quota: VIF Inbound Peak\", \"description\": \"Network Virtual Interface (VIF) inbound peak in kilobytes per second. Specifies maximum rate at which an interface can receive data.\", \"type\": \"integer\"}, \"quota:vif_outbound_average\": {\"title\": \"Quota: VIF Outbound Average\", \"description\": \"Network Virtual Interface (VIF) outbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_outbound_burst\": {\"title\": \"Quota: VIF Outbound Burst\", \"description\": \"Network Virtual Interface (VIF) outbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_outbound_peak\": {\"title\": \"Quota: VIF Outbound Peak\", \"description\": \"Network Virtual Interface (VIF) outbound peak in kilobytes per second. Specifies maximum rate at which an interface can send data.\", \"type\": \"integer\"}}','2025-12-02 08:13:34',NULL),(11,80,'MySQL','MySQL is an object-relational database management system (ORDBMS). The MySQL development project has made its source code available under the terms of the GNU General Public License, as well as under a variety of proprietary agreements. MySQL was owned and sponsored by a single for-profit firm, the Swedish company MySQL AB, now owned by Oracle Corporation. MySQL is a popular choice of database for use in web applications, and is a central component of the widely used LAMP open source web application software stack (and other \'AMP\' stacks). (http://en.wikipedia.org/wiki/MySQL)',NULL,'{\"sw_database_mysql_version\": {\"title\": \"Version\", \"description\": \"The specific version of MySQL.\", \"type\": \"string\"}, \"sw_database_mysql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"The configured TCP/IP port which MySQL listens for incoming connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 3606}, \"sw_database_mysql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"root\"}}','2025-12-02 08:13:36',NULL),(14,80,'PostgreSQL','PostgreSQL, often simply \'Postgres\', is an object-relational database management system (ORDBMS) with an emphasis on extensibility and standards-compliance. PostgreSQL is cross-platform and runs on many operating systems. (http://en.wikipedia.org/wiki/PostgreSQL)',NULL,'{\"sw_database_postgresql_version\": {\"title\": \"Version\", \"description\": \"The specific version of PostgreSQL.\", \"type\": \"string\"}, \"sw_database_postgresql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which PostgreSQL is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_postgresql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"postgres\"}}','2025-12-02 08:13:36',NULL),(17,80,'SQL Server','Microsoft SQL Server is a relational database management system developed by Microsoft. There are at least a dozen different editions of Microsoft SQL Server aimed at different audiences and for workloads ranging from small single-machine applications to large Internet-facing applications with many concurrent users. Its primary query languages are T-SQL and ANSI SQL. (http://en.wikipedia.org/wiki/Microsoft_SQL_Server)',NULL,'{\"sw_database_sqlserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Microsoft SQL Server.\", \"type\": \"string\"}, \"sw_database_sqlserver_edition\": {\"title\": \"Edition\", \"description\": \"SQL Server is available in multiple editions, with different feature sets and targeting different users.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Datacenter\", \"Enterprise\", \"Standard\", \"Web\", \"Business Intelligence\", \"Workgroup\", \"Express\", \"Compact (SQL CE)\", \"Developer\", \"Embedded (SSEE)\", \"Express\", \"Fast Track\", \"LocalDB\", \"Parallel Data Warehouse (PDW)\", \"Business Intelligence\", \"Datawarehouse Appliance Edition\"]}, \"sw_database_sqlserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which SQL Server is to listen for connections from client applications. The default SQL Server port is 1433, and client ports are assigned a random value between 1024 and 5000.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1433}, \"sw_database_postsqlserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"sa\"}}','2025-12-02 08:13:36',NULL),(20,80,'Oracle','Oracle Database (commonly referred to as Oracle RDBMS or simply as Oracle) is an object-relational database management system produced and marketed by Oracle Corporation. (http://en.wikipedia.org/wiki/Oracle_Database)',NULL,'{\"sw_database_oracle_version\": {\"title\": \"Version\", \"description\": \"The specific version of Oracle.\", \"type\": \"string\"}, \"sw_database_oracle_edition\": {\"title\": \"Edition\", \"description\": \"Over and above the different versions of the Oracle database management software developed over time, Oracle Corporation subdivides its product into varying editions.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Enterprise\", \"Standard\", \"Standard Edition One\", \"Express (XE)\", \"Workgroup\", \"Lite\"]}, \"sw_database_oracle_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Oracle is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1521}}','2025-12-02 08:13:36',NULL),(23,80,'DB2','IBM DB2 is a family of database server products developed by IBM. These products all support the relational model, but in recent years some products have been extended to support object-relational features and non-relational structures, in particular XML. (http://en.wikipedia.org/wiki/IBM_DB2)',NULL,'{\"sw_database_db2_version\": {\"title\": \"Version\", \"description\": \"The specific version of DB2.\", \"type\": \"string\"}, \"sw_database_db2_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which DB2 is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_db2_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-12-02 08:13:37',NULL),(26,80,'MongoDB','MongoDB is a cross-platform document-oriented database. Classified as a NoSQL database, MongoDB uses JSON-like documents with dynamic schemas (MongoDB calls the format BSON), making the integration of data in certain types of applications easier and faster. Released under a combination of the GNU Affero General Public License and the Apache License, MongoDB is free and open-source software. (http://en.wikipedia.org/wiki/MongoDB)',NULL,'{\"sw_database_mongodb_version\": {\"title\": \"Version\", \"description\": \"The specific version of MongoDB.\", \"type\": \"string\"}, \"sw_database_mongodb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which MongoDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 27017}, \"sw_database_mongodb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-12-02 08:13:37',NULL),(29,80,'Couchbase Server','Couchbase Server, originally known as Membase, is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications. These applications must serve many concurrent users by creating, storing, retrieving, aggregating, manipulating and presenting data. In support of these kinds of application needs, Couchbase is designed to provide easy-to-scale key-value or document access with low latency and high sustained throughput. (http://en.wikipedia.org/wiki/Couchbase_Server)',NULL,'{\"sw_database_couchbaseserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Couchbase Server.\", \"type\": \"string\"}, \"sw_database_couchbaseserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Couchbase is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 11211}, \"sw_database_couchbaseserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-12-02 08:13:37',NULL),(32,80,'Redis','Redis is a data structure server (NoSQL). It is open-source, networked, in-memory, and stores keys with optional durability. The development of Redis has been sponsored by Pivotal Software since May 2013; before that, it was sponsored by VMware. The name Redis means REmote DIctionary Server. (http://en.wikipedia.org/wiki/Redis)',NULL,'{\"sw_database_redis_version\": {\"title\": \"Version\", \"description\": \"The specific version of Redis.\", \"type\": \"string\"}, \"sw_database_redis_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Redis is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 6379}, \"sw_database_redis_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-12-02 08:13:37',NULL),(35,80,'CouchDB','Apache CouchDB, commonly referred to as CouchDB, is an open source NoSQL database. It is a NoSQL database that uses JSON to store data, JavaScript as its query language using MapReduce, and HTTP for an API. One of its distinguishing features is multi-master replication. CouchDB was first released in 2005 and later became an Apache project in 2008. (http://en.wikipedia.org/wiki/CouchDB)',NULL,'{\"sw_database_couchdb_version\": {\"title\": \"Version\", \"description\": \"The specific version of CouchDB.\", \"type\": \"string\"}, \"sw_database_couchdb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which CouchDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5984}, \"sw_database_couchdb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-12-02 08:13:37',NULL),(38,80,'Apache Cassandra','Apache Cassandra is an open source distributed NoSQL database management system designed to handle large amounts of data across many commodity servers, providing high availability with no single point of failure. (http://en.wikipedia.org/wiki/Apache_Cassandra)',NULL,'{\"sw_database_cassandra_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache Cassandra.\", \"type\": \"string\"}, \"sw_database_cassandra_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Cassandra is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 9160}, \"sw_database_cassandra_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"cassandra\"}}','2025-12-02 08:13:37',NULL),(41,80,'HBase','HBase is an open source, non-relational (NoSQL), distributed database modeled after Google\'s BigTable and written in Java. It is developed as part of Apache Software Foundation\'s Apache Hadoop project and runs on top of HDFS (Hadoop Distributed Filesystem), providing BigTable-like capabilities for Hadoop. (http://en.wikipedia.org/wiki/Apache_HBase)',NULL,'{\"sw_database_hbase_version\": {\"title\": \"Version\", \"description\": \"The specific version of HBase.\", \"type\": \"string\"}}','2025-12-02 08:13:37',NULL),(44,80,'Hazlecast','In computing, Hazelcast is an in-memory open source software data grid based on Java. By having multiple nodes form a cluster, data is evenly distributed among the nodes. This allows for horizontal scaling both in terms of available storage space and processing power. Backups are also distributed in a similar fashion to other nodes, based on configuration, thereby protecting against single node failure. (http://en.wikipedia.org/wiki/Hazelcast)',NULL,'{\"sw_database_hazlecast_version\": {\"title\": \"Version\", \"description\": \"The specific version of Hazlecast.\", \"type\": \"string\"}, \"sw_database_hazlecast_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Hazlecast is to listen for connections between members.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5701}}','2025-12-02 08:13:37',NULL),(47,83,'PHP','PHP is a server-side scripting language designed for web development but also used as a general-purpose programming language. PHP code can be simply mixed with HTML code, or it can be used in combination with various templating engines and web frameworks. PHP code is usually processed by a PHP interpreter, which is usually implemented as a web server\'s native module or a Common Gateway Interface (CGI) executable. After the PHP code is interpreted and executed, the web server sends resulting output to its client, usually in form of a part of the generated web page – for example, PHP code can generate a web page\'s HTML code, an image, or some other data. PHP has also evolved to include a command-line interface (CLI) capability and can be used in standalone graphical applications. (http://en.wikipedia.org/wiki/PHP)',NULL,'{\"sw_runtime_php_version\": {\"title\": \"Version\", \"description\": \"The specific version of PHP.\", \"type\": \"string\"}}','2025-12-02 08:13:37',NULL),(50,83,'Python','Python is a widely used general-purpose, high-level programming language. Its design philosophy emphasizes code readability, and its syntax allows programmers to express concepts in fewer lines of code than would be possible in languages such as C++ or Java. The language provides constructs intended to enable clear programs on both a small and large scale. Python supports multiple programming paradigms, including object-oriented, imperative and functional programming or procedural styles. It features a dynamic type system and automatic memory management and has a large and comprehensive standard library. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_python_version\": {\"title\": \"Version\", \"description\": \"The specific version of python.\", \"type\": \"string\"}}','2025-12-02 08:13:37',NULL),(53,83,'Java','Java is a functional computer programming language that is concurrent, class-based, object-oriented, and specifically designed to have as few implementation dependencies as possible. It is intended to let application developers write once, run anywhere (WORA), meaning that code that runs on one platform does not need to be recompiled to run on another. Java applications are typically compiled to bytecode that can run on any Java virtual machine (JVM) regardless of computer architecture. (http://en.wikipedia.org/wiki/Java_(programming_language))',NULL,'{\"sw_runtime_java_version\": {\"title\": \"Version\", \"description\": \"The specific version of Java.\", \"type\": \"string\"}}','2025-12-02 08:13:37',NULL),(56,83,'Ruby','Ruby is a dynamic, reflective, object-oriented, general-purpose programming language. It was designed and developed in the mid-1990s by Yukihiro Matsumoto in Japan. According to its authors, Ruby was influenced by Perl, Smalltalk, Eiffel, Ada, and Lisp. It supports multiple programming paradigms, including functional, object-oriented, and imperative. It also has a dynamic type system and automatic memory management. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_ruby_version\": {\"title\": \"Version\", \"description\": \"The specific version of Ruby.\", \"type\": \"string\"}}','2025-12-02 08:13:37',NULL),(59,83,'Perl','Perl is a family of high-level, general-purpose, interpreted, dynamic programming languages. The languages in this family include Perl 5 and Perl 6. Though Perl is not officially an acronym, there are various backronyms in use, the most well-known being Practical Extraction and Reporting Language (http://en.wikipedia.org/wiki/Perl)',NULL,'{\"sw_runtime_perl_version\": {\"title\": \"Version\", \"description\": \"The specific version of Perl.\", \"type\": \"string\"}}','2025-12-02 08:13:37',NULL),(62,86,'Apache HTTP Server','The Apache HTTP Server, colloquially called Apache, is a Web server application notable for playing a key role in the initial growth of the World Wide Web. Apache is developed and maintained by an open community of developers under the auspices of the Apache Software Foundation. Most commonly used on a Unix-like system, the software is available for a wide variety of operating systems, including Unix, FreeBSD, Linux, Solaris, Novell NetWare, OS X, Microsoft Windows, OS/2, TPF, OpenVMS and eComStation. Released under the Apache License, Apache is open-source software. (http://en.wikipedia.org/wiki/Apache_HTTP_Server)',NULL,'{\"sw_webserver_apache_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache.\", \"type\": \"string\"}, \"sw_webserver_apache_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_apache_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-12-02 08:13:38',NULL),(65,86,'Nginx','Nginx (pronounced \'engine-x\') is an open source reverse proxy server for HTTP, HTTPS, SMTP, POP3, and IMAP protocols, as well as a load balancer, HTTP cache, and a web server (origin server). The nginx project started with a strong focus on high concurrency, high performance and low memory usage. It is licensed under the 2-clause BSD-like license and it runs on Linux, BSD variants, Mac OS X, Solaris, AIX, HP-UX, as well as on other *nix flavors. It also has a proof of concept port for Microsoft Windows. (http://en.wikipedia.org/wiki/Nginx)',NULL,'{\"sw_webserver_nginx_version\": {\"title\": \"Version\", \"description\": \"The specific version of Nginx.\", \"type\": \"string\"}, \"sw_webserver_nginx_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_nginx_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-12-02 08:13:38',NULL),(68,86,'IIS','Internet Information Services (IIS, formerly Internet Information Server) is an extensible web server created by Microsoft. IIS supports HTTP, HTTPS, FTP, FTPS, SMTP and NNTP. IIS is not turned on by default when Windows is installed. The IIS Manager is accessed through the Microsoft Management Console or Administrative Tools in the Control Panel. (http://en.wikipedia.org/wiki/Internet_Information_Services)',NULL,'{\"sw_webserver_iis_version\": {\"title\": \"Version\", \"description\": \"The specific version of IIS.\", \"type\": \"string\"}, \"sw_webserver_iis_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_iis_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-12-02 08:13:38',NULL);
/*!40000 ALTER TABLE `metadef_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_properties`
--

DROP TABLE IF EXISTS `metadef_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_properties_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_properties_name` (`name`),
  CONSTRAINT `metadef_properties_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=388 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_properties`
--

LOCK TABLES `metadef_properties` WRITE;
/*!40000 ALTER TABLE `metadef_properties` DISABLE KEYS */;
INSERT INTO `metadef_properties` (`id`, `namespace_id`, `name`, `json_schema`, `created_at`, `updated_at`) VALUES (2,2,'InstructionSet','{\"title\": \"Instruction Set\", \"description\": \"Identifies the instruction set of the processor within a processor architecture.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86:i386\", \"x86:i486\", \"x86:i586\", \"x86:i686\", \"x86:64\", \"IA-64:IA-64\", \"AS/400:TIMI\", \"Power:Power_2.03\", \"Power:Power_2.04\", \"Power:Power_2.05\", \"Power:Power_2.06\", \"S/390:ESA/390\", \"S/390:z/Architecture\", \"S/390:z/Architecture_2\", \"PA-RISC:PA-RISC_1.0\", \"PA-RISC:PA-RISC_2.0\", \"ARM:A32\", \"ARM:A64\", \"MIPS:MIPS_I\", \"MIPS:MIPS_II\", \"MIPS:MIPS_III\", \"MIPS:MIPS_IV\", \"MIPS:MIPS_V\", \"MIPS:MIPS32\", \"MIPS64:MIPS64\", \"Alpha:Alpha\", \"SPARC:SPARC_V7\", \"SPARC:SPARC_V8\", \"SPARC:SPARC_V9\", \"SPARC:SPARC_JPS1\", \"SPARC:UltraSPARC2005\", \"SPARC:UltraSPARC2007\", \"68k:68000\", \"68k:68010\", \"68k:68020\", \"68k:68030\", \"68k:68040\", \"68k:68060\"]}','2025-12-02 08:13:27',NULL),(5,2,'ProcessorArchitecture','{\"title\": \"Processor Architecture\", \"description\": \"Identifies the processor architecture of the processor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"IA-64\", \"AS/400\", \"Power\", \"S/390\", \"PA-RISC\", \"ARM\", \"MIPS\", \"Alpha\", \"SPARC\", \"68k\"]}','2025-12-02 08:13:27',NULL),(8,2,'InstructionSetExtensionName','{\"title\": \"Instruction Set Extension\", \"description\": \"Identifies the instruction set extensions of the processor within a processor architecture.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"x86:3DNow\", \"x86:3DNowExt\", \"x86:ABM\", \"x86:AES\", \"x86:AVX\", \"x86:AVX2\", \"x86:BMI\", \"x86:CX16\", \"x86:F16C\", \"x86:FSGSBASE\", \"x86:LWP\", \"x86:MMX\", \"x86:PCLMUL\", \"x86:RDRND\", \"x86:SSE2\", \"x86:SSE3\", \"x86:SSSE3\", \"x86:SSE4A\", \"x86:SSE41\", \"x86:SSE42\", \"x86:FMA3\", \"x86:FMA4\", \"x86:XOP\", \"x86:TBM\", \"x86:VT-d\", \"x86:VT-x\", \"x86:EPT\", \"x86:SVM\", \"PA-RISC:MAX\", \"PA-RISC:MAX2\", \"ARM:DSP\", \"ARM:Jazelle-DBX\", \"ARM:Thumb\", \"ARM:Thumb-2\", \"ARM:ThumbEE)\", \"ARM:VFP\", \"ARM:NEON\", \"ARM:TrustZone\", \"MIPS:MDMX\", \"MIPS:MIPS-3D\", \"Alpha:BWX\", \"Alpha:FIX\", \"Alpha:CIX\", \"Alpha:MVI\"]}}','2025-12-02 08:13:28',NULL),(11,5,'Address','{\"title\": \"Address\", \"description\": \"The address of the resource.\", \"type\": \"string\"}','2025-12-02 08:13:28',NULL),(14,5,'AddressOnParent','{\"title\": \"Address On Parent\", \"description\": \"Describes the address of this resource in the context of the Parent.\", \"type\": \"string\"}','2025-12-02 08:13:28',NULL),(17,5,'AllocationUnits','{\"title\": \"Allocation Units\", \"description\": \"This property specifies the units of allocation used by the Reservation and Limit properties.\", \"type\": \"string\"}','2025-12-02 08:13:28',NULL),(20,5,'AutomaticAllocation','{\"title\": \"Automatic Allocation\", \"description\": \"This property specifies if the resource will be automatically allocated.\", \"type\": \"boolean\"}','2025-12-02 08:13:28',NULL),(23,5,'AutomaticDeallocation','{\"title\": \"Automatic Deallocation\", \"description\": \"This property specifies if the resource will be automatically de-allocated.\", \"type\": \"boolean\"}','2025-12-02 08:13:28',NULL),(26,5,'ConsumerVisibility','{\"title\": \"Consumer Visibility\", \"description\": \"Describes the consumers visibility to the allocated resource.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Passed-Through\", \"Virtualized\", \"Not represented\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-12-02 08:13:28',NULL),(29,5,'Limit','{\"title\": \"Limit\", \"description\": \"This property specifies the upper bound, or maximum amount of resource that will be granted for this allocation.\", \"type\": \"string\"}','2025-12-02 08:13:28',NULL),(32,5,'MappingBehavior','{\"title\": \"Mapping Behavior\", \"description\": \"Specifies how this resource maps to underlying resources. If the HostResource array contains any entries, this property reflects how the resource maps to those specific resources.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Not Supported\", \"Dedicated\", \"Soft Affinity\", \"Hard Affinity\", \"DMTF Reserved\", \"Vendor Reserved\"]}','2025-12-02 08:13:28',NULL),(35,5,'OtherResourceType','{\"title\": \"Other Resource Type\", \"description\": \"A string that describes the resource type when a well defined value is not available and ResourceType has the value \'Other\'.\", \"type\": \"string\"}','2025-12-02 08:13:28',NULL),(38,5,'Parent','{\"title\": \"Parent\", \"description\": \"The Parent of the resource.\", \"type\": \"string\"}','2025-12-02 08:13:28',NULL),(41,5,'PoolID','{\"title\": \"Pool ID\", \"description\": \"This property specifies which ResourcePool the resource is currently allocated from, or which ResourcePool the resource will be allocated from when the allocation occurs.\", \"type\": \"string\"}','2025-12-02 08:13:28',NULL),(44,5,'Reservation','{\"title\": \"Reservation\", \"description\": \"This property specifies the amount of resource guaranteed to be available for this allocation.\", \"type\": \"string\"}','2025-12-02 08:13:28',NULL),(47,5,'ResourceSubType','{\"title\": \"Resource Sub Type\", \"description\": \"A string describing an implementation specific sub-type for this resource.\", \"type\": \"string\"}','2025-12-02 08:13:28',NULL),(50,5,'ResourceType','{\"title\": \"Resource Type\", \"description\": \"The type of resource this allocation setting represents.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Other\", \"Computer System\", \"Processor\", \"Memory\", \"IDE Controller\", \"Parallel SCSI HBA\", \"FC HBA\", \"iSCSI HBA\", \"IB HCA\", \"Ethernet Adapter\", \"Other Network Adapter\", \"I/O Slot\", \"I/O Device\", \"Floppy Drive\", \"CD Drive\", \"DVD drive\", \"Disk Drive\", \"Tape Drive\", \"Storage Extent\", \"Other storage device\", \"Serial port\", \"Parallel port\", \"USB Controller\", \"Graphics controller\", \"IEEE 1394 Controller\", \"Partitionable Unit\", \"Base Partitionable Unit\", \"Power\", \"Cooling Capacity\", \"Ethernet Switch Port\", \"Logical Disk\", \"Storage Volume\", \"Ethernet Connection\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-12-02 08:13:28',NULL),(53,5,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"This property specifies the quantity of resources presented to the consumer.\", \"type\": \"string\"}','2025-12-02 08:13:28',NULL),(56,5,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-12-02 08:13:28',NULL),(59,5,'Weight','{\"title\": \"Weight\", \"description\": \"This property specifies a relative priority for this allocation in relation to other allocations from the same ResourcePool.\", \"type\": \"string\"}','2025-12-02 08:13:28',NULL),(62,5,'Connection','{\"title\": \"Connection\", \"description\": \"The thing to which this resource is connected.\", \"type\": \"string\"}','2025-12-02 08:13:28',NULL),(65,5,'HostResource','{\"title\": \"Host Resource\", \"description\": \"This property exposes specific assignment of resources.\", \"type\": \"string\"}','2025-12-02 08:13:28',NULL),(68,8,'Access','{\"title\": \"Access\", \"description\": \"Access describes whether the allocated storage extent is 1 (readable), 2 (writeable), or 3 (both).\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Readable\", \"Writeable\", \"Read/Write Supported\", \"DMTF Reserved\"]}','2025-12-02 08:13:28',NULL),(71,8,'HostExtentName','{\"title\": \"Host Extent Name\", \"description\": \"A unique identifier for the host extent.\", \"type\": \"string\"}','2025-12-02 08:13:28',NULL),(74,8,'HostExtentNameFormat','{\"title\": \"Host Extent Name Format\", \"description\": \"The HostExtentNameFormat property identifies the format that is used for the value of the HostExtentName property.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"SNVM\", \"NAA\", \"EUI64\", \"T10VID\", \"OS Device Name\", \"DMTF Reserved\"]}','2025-12-02 08:13:28',NULL),(77,8,'HostExtentNameNamespace','{\"title\": \"Host Extent Name Namespace\", \"description\": \"If the host extent is a SCSI volume, then the preferred source for SCSI volume names is SCSI VPD Page 83 responses.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"VPD83Type3\", \"VPD83Type2\", \"VPD83Type1\", \"VPD80\", \"NodeWWN\", \"SNVM\", \"OS Device Namespace\", \"DMTF Reserved\"]}','2025-12-02 08:13:28',NULL),(80,8,'HostExtentStartingAddress','{\"title\": \"Host Extent Starting Address\", \"description\": \"The HostExtentStartingAddress property identifies the starting address on the host storage extent identified by the value of the HostExtentName property that is used for the allocation of the virtual storage extent.\", \"type\": \"string\"}','2025-12-02 08:13:28',NULL),(83,8,'HostResourceBlockSize','{\"title\": \"Host Resource Block Size\", \"description\": \"Size in bytes of the blocks that are allocated at the host as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-12-02 08:13:28',NULL),(86,8,'Limit','{\"title\": \"Limit\", \"description\": \"The maximum amount of blocks that will be granted for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-12-02 08:13:28',NULL),(89,8,'OtherHostExtentNameFormat','{\"title\": \"Other Host Extent Name Format\", \"description\": \"A string describing the format of the HostExtentName property if the value of the HostExtentNameFormat property is 1 (Other).\", \"type\": \"string\"}','2025-12-02 08:13:28',NULL),(92,8,'OtherHostExtentNameNamespace','{\"title\": \"Other Host Extent Name Namespace\", \"description\": \"A string describing the namespace of the HostExtentName property if the value of the HostExtentNameNamespace matches 1 (Other).\", \"type\": \"string\"}','2025-12-02 08:13:28',NULL),(95,8,'Reservation','{\"title\": \"Reservation\", \"description\": \"The amount of blocks that are guaranteed to be available for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-12-02 08:13:28',NULL),(98,8,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"Number of blocks that are presented to the consumer.\", \"type\": \"string\"}','2025-12-02 08:13:29',NULL),(101,8,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-12-02 08:13:29',NULL),(104,8,'VirtualResourceBlockSize','{\"title\": \"Virtual Resource Block Size\", \"description\": \"Size in bytes of the blocks that are presented to the consumer as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-12-02 08:13:29',NULL),(107,11,'AutomaticRecoveryAction','{\"title\": \"Automatic Recovery Action\", \"description\": \"Action to take for the virtual system when the software executed by the virtual system fails.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart\", \"Revert to snapshot\", \"DMTF Reserved\"]}','2025-12-02 08:13:29',NULL),(110,11,'AutomaticShutdownAction','{\"title\": \"Automatic Shutdown Action\", \"description\": \"Action to take for the virtual system when the host is shut down.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Turn Off\", \"Save state\", \"Shutdown\", \"DMTF Reserved\"]}','2025-12-02 08:13:29',NULL),(113,11,'AutomaticStartupAction','{\"title\": \"Automatic Startup Action\", \"description\": \"Action to take for the virtual system when the host is started.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart if previously active\", \"Always startup\", \"DMTF Reserved\"]}','2025-12-02 08:13:29',NULL),(116,11,'AutomaticStartupActionDelay','{\"title\": \"Automatic Startup Action Delay\", \"description\": \"Delay applicable to startup action.\", \"type\": \"string\"}','2025-12-02 08:13:29',NULL),(119,11,'AutomaticStartupActionSequenceNumber','{\"title\": \"Automatic Startup Action Sequence Number\", \"description\": \"Number indicating the relative sequence of virtual system activation when the host system is started.\", \"type\": \"string\"}','2025-12-02 08:13:29',NULL),(122,11,'ConfigurationDataRoot','{\"title\": \"Configuration Data Root\", \"description\": \"Filepath of a directory where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-12-02 08:13:29',NULL),(125,11,'ConfigurationFile','{\"title\": \"Configuration File\", \"description\": \"Filepath of a file where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-12-02 08:13:29',NULL),(128,11,'ConfigurationID','{\"title\": \"Configuration ID\", \"description\": \"Unique id of the virtual system configuration.\", \"type\": \"string\"}','2025-12-02 08:13:29',NULL),(131,11,'CreationTime','{\"title\": \"Creation Time\", \"description\": \"Time when the virtual system configuration was created.\", \"type\": \"string\"}','2025-12-02 08:13:29',NULL),(134,11,'LogDataRoot','{\"title\": \"Log Data Root\", \"description\": \"Filepath of a directory where log information about the virtual system is stored.\", \"type\": \"string\"}','2025-12-02 08:13:29',NULL),(137,11,'RecoveryFile','{\"title\": \"Recovery File\", \"description\": \"Filepath of a file where recovery relateded information of the virtual system is stored.\", \"type\": \"string\"}','2025-12-02 08:13:29',NULL),(140,11,'SnapshotDataRoot','{\"title\": \"Snapshot Data Root\", \"description\": \"Filepath of a directory where information about virtual system snapshots is stored.\", \"type\": \"string\"}','2025-12-02 08:13:29',NULL),(143,11,'SuspendDataRoot','{\"title\": \"Suspend Data Root\", \"description\": \"Filepath of a directory where suspend related information about the virtual system is stored.\", \"type\": \"string\"}','2025-12-02 08:13:29',NULL),(146,11,'SwapFileDataRoot','{\"title\": \"Swap File Data Root\", \"description\": \"Filepath of a directory where swapfiles of the virtual system are stored.\", \"type\": \"string\"}','2025-12-02 08:13:29',NULL),(149,11,'VirtualSystemIdentifier','{\"title\": \"Virtual System Identifier\", \"description\": \"VirtualSystemIdentifier shall reflect a unique name for the system as it is used within the virtualization platform.\", \"type\": \"string\"}','2025-12-02 08:13:29',NULL),(152,11,'VirtualSystemType','{\"title\": \"Virtual System Type\", \"description\": \"VirtualSystemType shall reflect a particular type of virtual system.\", \"type\": \"string\"}','2025-12-02 08:13:29',NULL),(155,11,'Notes','{\"title\": \"Notes\", \"description\": \"End-user supplied notes that are related to the virtual system.\", \"type\": \"string\"}','2025-12-02 08:13:29',NULL),(158,14,'disk_allocation_ratio','{\"title\": \"Disk Subscription Ratio\", \"description\": \"Allows the host to be under and over subscribed for the amount of disk space requested for an instance. A ratio greater than 1.0 allows for over subscription (hosts may have less usable disk space than requested). A ratio less than 1.0 allows for under subscription.\", \"type\": \"number\", \"readonly\": false}','2025-12-02 08:13:29',NULL),(161,17,'max_io_ops_per_host','{\"title\": \"Maximum IO Operations per Host\", \"description\": \"Prevents hosts in the aggregate that have this many or more instances currently in build, resize, snapshot, migrate, rescue or unshelve to be scheduled for new instances.\", \"type\": \"integer\", \"readonly\": false, \"default\": 8, \"minimum\": 1}','2025-12-02 08:13:30',NULL),(164,20,'max_instances_per_host','{\"title\": \"Max Instances Per Host\", \"description\": \"Maximum number of instances allowed to run on a host in the aggregate.\", \"type\": \"integer\", \"readonly\": false, \"minimum\": 0}','2025-12-02 08:13:30',NULL),(167,23,'cpu_policy','{\"title\": \"CPU Pinning policy\", \"description\": \"Type of CPU pinning policy.\", \"type\": \"string\", \"enum\": [\"shared\", \"dedicated\"]}','2025-12-02 08:13:30',NULL),(170,23,'cpu_thread_policy','{\"title\": \"CPU Thread Pinning Policy.\", \"description\": \"Type of CPU thread pinning policy.\", \"type\": \"string\", \"enum\": [\"isolate\", \"prefer\", \"require\"]}','2025-12-02 08:13:30',NULL),(173,26,'mem_page_size','{\"title\": \"Size of memory page\", \"description\": \"Page size to be used for Guest memory backing. Value can be specified as <number><unit> (i.e.: 2MB, 1GB) or \'any\', \'small\', \'large\'. If this property is set in Image metadata then only \'any\' and \'large\' values are accepted in Flavor metadata by Nova API.\", \"type\": \"string\"}','2025-12-02 08:13:30',NULL),(176,29,'os_shutdown_timeout','{\"title\": \"Shutdown timeout\", \"description\": \"By default, guests will be given 60 seconds to perform a graceful shutdown. After that, the VM is powered off.  This property allows overriding the amount of time (unit: seconds) to allow a guest OS to cleanly shut down before power off. A value of 0 (zero) means the guest will be powered off immediately with no opportunity for guest OS clean-up.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-02 08:13:31',NULL),(179,32,'cpu_info:vendor','{\"title\": \"Vendor\", \"description\": \"Specifies the CPU manufacturer.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Intel\", \"AMD\"]}','2025-12-02 08:13:31',NULL),(182,32,'cpu_info:model','{\"title\": \"Model\", \"description\": \"Specifies the CPU model. Use this property to ensure that your vm runs on a specific cpu model.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Conroe\", \"Core2Duo\", \"Penryn\", \"Nehalem\", \"Westmere\", \"SandyBridge\", \"IvyBridge\", \"Haswell\", \"Broadwell\", \"Delhi\", \"Seoul\", \"Abu Dhabi\", \"Interlagos\", \"Kabini\", \"Valencia\", \"Zurich\", \"Budapest\", \"Barcelona\", \"Suzuka\", \"Shanghai\", \"Istanbul\", \"Lisbon\", \"Magny-Cours\", \"Valencia\", \"Cortex-A57\", \"Cortex-A53\", \"Cortex-A12\", \"Cortex-A17\", \"Cortex-A15\", \"Coretx-A7\", \"X-Gene\"]}','2025-12-02 08:13:31',NULL),(185,32,'cpu_info:arch','{\"title\": \"Architecture\", \"description\": \"Specifies the CPU architecture. Use this property to specify the architecture supported by the hypervisor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"x86_64\", \"i686\", \"ia64\", \"ARMv8-A\", \"ARMv7-A\"]}','2025-12-02 08:13:31',NULL),(188,32,'cpu_info:topology:cores','{\"title\": \"cores\", \"description\": \"Number of cores.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-12-02 08:13:31',NULL),(191,32,'cpu_info:topology:threads','{\"title\": \"threads\", \"description\": \"Number of threads.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-12-02 08:13:31',NULL),(194,32,'cpu_info:topology:sockets','{\"title\": \"sockets\", \"description\": \"Number of sockets.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-12-02 08:13:31',NULL),(197,32,'cpu_info:features','{\"title\": \"Features\", \"description\": \"Specifies CPU flags/features. Using this property you can specify the required set of instructions supported by a vm.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"fpu\", \"vme\", \"de\", \"pse\", \"tsc\", \"msr\", \"pae\", \"mce\", \"cx8\", \"apic\", \"sep\", \"mtrr\", \"pge\", \"mca\", \"cmov\", \"pat\", \"pse36\", \"pn\", \"clflush\", \"dts\", \"acpi\", \"mmx\", \"fxsr\", \"sse\", \"sse2\", \"ss\", \"ht\", \"tm\", \"ia64\", \"pbe\", \"syscall\", \"mp\", \"nx\", \"mmxext\", \"fxsr_opt\", \"pdpe1gb\", \"rdtscp\", \"lm\", \"3dnowext\", \"3dnow\", \"arch_perfmon\", \"pebs\", \"bts\", \"rep_good\", \"nopl\", \"xtopology\", \"tsc_reliable\", \"nonstop_tsc\", \"extd_apicid\", \"amd_dcm\", \"aperfmperf\", \"eagerfpu\", \"nonstop_tsc_s3\", \"pni\", \"pclmulqdq\", \"dtes64\", \"monitor\", \"ds_cpl\", \"vmx\", \"smx\", \"est\", \"tm2\", \"ssse3\", \"cid\", \"fma\", \"cx16\", \"xtpr\", \"pdcm\", \"pcid\", \"dca\", \"sse4_1\", \"sse4_2\", \"x2apic\", \"movbe\", \"popcnt\", \"tsc_deadline_timer\", \"aes\", \"xsave\", \"avx\", \"f16c\", \"rdrand\", \"hypervisor\", \"rng\", \"rng_en\", \"ace\", \"ace_en\", \"ace2\", \"ace2_en\", \"phe\", \"phe_en\", \"pmm\", \"pmm_en\", \"lahf_lm\", \"cmp_legacy\", \"svm\", \"extapic\", \"cr8_legacy\", \"abm\", \"sse4a\", \"misalignsse\", \"3dnowprefetch\", \"osvw\", \"ibs\", \"xop\", \"skinit\", \"wdt\", \"lwp\", \"fma4\", \"tce\", \"nodeid_msr\", \"tbm\", \"topoext\", \"perfctr_core\", \"perfctr_nb\", \"bpext\", \"perfctr_l2\", \"mwaitx\", \"ida\", \"arat\", \"cpb\", \"epb\", \"pln\", \"pts\", \"dtherm\", \"hw_pstate\", \"proc_feedback\", \"hwp\", \"hwp_notify\", \"hwp_act_window\", \"hwp_epp\", \"hwp_pkg_req\", \"intel_pt\", \"tpr_shadow\", \"vnmi\", \"flexpriority\", \"ept\", \"vpid\", \"npt\", \"lbrv\", \"svm_lock\", \"nrip_save\", \"tsc_scale\", \"vmcb_clean\", \"flushbyasid\", \"decodeassists\", \"pausefilter\", \"pfthreshold\", \"vmmcall\", \"fsgsbase\", \"tsc_adjust\", \"bmi1\", \"hle\", \"avx2\", \"smep\", \"bmi2\", \"erms\", \"invpcid\", \"rtm\", \"cqm\", \"mpx\", \"avx512f\", \"rdseed\", \"adx\", \"smap\", \"pcommit\", \"clflushopt\", \"clwb\", \"avx512pf\", \"avx512er\", \"avx512cd\", \"sha_ni\", \"xsaveopt\", \"xsavec\", \"xgetbv1\", \"xsaves\", \"cqm_llc\", \"cqm_occup_llc\", \"clzero\"]}}','2025-12-02 08:13:31',NULL),(200,35,'hypervisor_type','{\"title\": \"Hypervisor Type\", \"description\": \"Hypervisor type required by the image. Used with the ImagePropertiesFilter. \\n\\n Baremetal - physical provisioning. hyperv - Microsoft\\u00ae hyperv. KVM - Kernel-based Virtual Machine. LXC - Linux Containers (through libvirt). powervm - IBM\\u00ae PowerVM\\u00ae. QEMU - Quick EMUlator. UML - User Mode Linux. vmware - VMware\\u00ae vsphere. VZ - Virtuozzo OS Containers and Virtual Machines (through libvirt). For more information, see: https://docs.openstack.org/nova/latest/admin/configuration/hypervisors.html\", \"type\": \"string\", \"enum\": [\"baremetal\", \"hyperv\", \"kvm\", \"lxc\", \"powervm\", \"qemu\", \"uml\", \"vmware\", \"vz\", \"xen\"]}','2025-12-02 08:13:31',NULL),(203,35,'vm_mode','{\"title\": \"VM Mode\", \"description\": \"The virtual machine mode. This represents the host/guest ABI (application binary interface) used for the virtual machine. Used with the ImagePropertiesFilter. \\n\\n hvm \\u2014 Fully virtualized - This is the virtual machine mode (vm_mode) used by QEMU and KVM. \\n\\n xen - Xen 3.0 paravirtualized. \\n\\n uml \\u2014 User Mode Linux paravirtualized. \\n\\n exe \\u2014 Executables in containers. This is the mode used by LXC.\", \"type\": \"string\", \"enum\": [\"hvm\", \"xen\", \"uml\", \"exe\"]}','2025-12-02 08:13:31',NULL),(206,38,'img_config_drive','{\"title\": \"Config Drive\", \"description\": \"This property specifies whether or not Nova should use a config drive when booting the image. Mandatory means that Nova will always use a config drive when booting the image. OpenStack can be configured to write metadata to a special configuration drive that will be attached to the instance when it boots. The instance can retrieve any information from the config drive. One use case for the config drive is to pass network configuration information to the instance. See also: http://docs.openstack.org/user-guide/cli_config_drive.html\", \"type\": \"string\", \"enum\": [\"optional\", \"mandatory\"]}','2025-12-02 08:13:32',NULL),(209,38,'os_require_quiesce','{\"title\": \"Require Quiescent File system\", \"description\": \"This property specifies whether or not the filesystem must be quiesced during snapshot processing. For volume backed and image backed snapshots, yes means that snapshotting is aborted when quiescing fails, whereas, no means quiescing will be skipped and snapshot processing will continue after the quiesce failure.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-12-02 08:13:32',NULL),(212,41,'hw_cdrom_bus','{\"title\": \"CD-ROM Bus\", \"description\": \"Specifies the type of disk controller to attach CD-ROM devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-12-02 08:13:32',NULL),(215,41,'hw_disk_bus','{\"title\": \"Disk Bus\", \"description\": \"Specifies the type of disk controller to attach disk devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-12-02 08:13:32',NULL),(218,41,'hw_firmware_type','{\"title\": \"Firmware Type\", \"description\": \"Specifies whether the image should be booted with a legacy BIOS or with UEFI.\", \"type\": \"string\", \"enum\": [\"bios\", \"uefi\"]}','2025-12-02 08:13:32',NULL),(221,41,'hw_rng_model','{\"title\": \"Random Number Generator Device\", \"description\": \"Adds a random-number generator device to the image\'s instances. The cloud administrator can enable and control device behavior by configuring the instance\'s flavor. By default: The generator device is disabled. /dev/random is used as the default entropy source. To specify a physical HW RNG device, use the following option in the nova.conf file: rng_dev_path=/dev/hwrng\", \"type\": \"string\", \"default\": \"virtio\"}','2025-12-02 08:13:32',NULL),(224,41,'hw_machine_type','{\"title\": \"Machine Type\", \"description\": \"Enables booting an ARM system using the specified machine type. By default, if an ARM image is used and its type is not specified, Compute uses vexpress-a15 (for ARMv7) or virt (for AArch64) machine types. Valid types can be viewed by using the virsh capabilities command (machine types are displayed in the machine tag).\", \"type\": \"string\"}','2025-12-02 08:13:32',NULL),(227,41,'hw_scsi_model','{\"title\": \"SCSI Model\", \"description\": \"Enables the use of VirtIO SCSI (virtio-scsi) to provide block device access for compute instances; by default, instances use VirtIO Block (virtio-blk). VirtIO SCSI is a para-virtualized SCSI controller device that provides improved scalability and performance, and supports advanced SCSI hardware.\", \"type\": \"string\", \"default\": \"virtio-scsi\"}','2025-12-02 08:13:33',NULL),(230,41,'hw_video_model','{\"title\": \"Video Model\", \"description\": \"The graphic device model presented to the guest. hw_video_model=none disables the graphics device in the guest and should generally be used when using gpu passthrough.\", \"type\": \"string\", \"enum\": [\"vga\", \"cirrus\", \"vmvga\", \"xen\", \"qxl\", \"virtio\", \"gop\", \"none\"]}','2025-12-02 08:13:33',NULL),(233,41,'hw_video_ram','{\"title\": \"Max Video Ram\", \"description\": \"Maximum RAM (unit: MB) for the video image. Used only if a hw_video:ram_max_mb value has been set in the flavor\'s extra_specs and that value is higher than the value set in hw_video_ram.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-02 08:13:33',NULL),(236,41,'os_command_line','{\"title\": \"Kernel Command Line\", \"description\": \"The kernel command line to be used by the libvirt driver, instead of the default. For linux containers (LXC), the value is used as arguments for initialization. This key is valid only for Amazon kernel, ramdisk, or machine images (aki, ari, or ami).\", \"type\": \"string\"}','2025-12-02 08:13:33',NULL),(239,41,'os_type','{\"title\": \"OS Type\", \"description\": \"The operating system installed on the image. The libvirt driver contains logic that takes different actions depending on the value of the os_type parameter of the image. For example, for os_type=windows images, it creates a FAT32-based swap partition instead of a Linux swap partition, and it limits the injected host name to less than 16 characters.\", \"type\": \"string\", \"enum\": [\"linux\", \"windows\"]}','2025-12-02 08:13:33',NULL),(242,41,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor configuration. libvirt driver options: KVM and QEMU: e1000, ne2k_pci, pcnet, rtl8139, spapr-vlan, and virtio. Xen: e1000, netfront, ne2k_pci, pcnet, and rtl8139.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"ne2k_pci\", \"netfront\", \"pcnet\", \"rtl8139\", \"spapr-vlan\", \"virtio\"]}','2025-12-02 08:13:33',NULL),(245,41,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-02 08:13:33',NULL),(248,41,'hw_pmu','{\"title\": \"Virtual Performance Monitoring Unit\", \"description\": \"Controls emulation of a vPMU in the guest. To reduce latency in realtime workloads disable the vPMU by setting hw_pmu=false\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-02 08:13:33',NULL),(251,41,'hw_qemu_guest_agent','{\"title\": \"QEMU Guest Agent\", \"description\": \"This is a background process which helps management applications execute guest OS level commands. For example, freezing and thawing filesystems, entering suspend. However, guest agent (GA) is not bullet proof, and hostile guest OS can send spurious replies.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-12-02 08:13:33',NULL),(254,41,'hw_pointer_model','{\"title\": \"Pointer Model\", \"description\": \"Input devices allow interaction with a graphical framebuffer. For example to provide a graphic tablet for absolute cursor movement. Currently only supported by the KVM/QEMU hypervisor configuration and VNC or SPICE consoles must be enabled.\", \"type\": \"string\", \"enum\": [\"usbtablet\"]}','2025-12-02 08:13:33',NULL),(257,41,'img_hide_hypervisor_id','{\"title\": \"Hide hypervisor id\", \"description\": \"Enables hiding the host hypervisor signature in the guest OS.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-12-02 08:13:33',NULL),(260,44,'serial_port_count','{\"title\": \"Serial Port Count\", \"description\": \"Specifies the count of serial ports that should be provided. If hw:serial_port_count is not set in the flavor\'s extra_specs, then any count is permitted. If hw:serial_port_count is set, then this provides the default serial port count. It is permitted to override the default serial port count, but only with a lower value.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-02 08:13:33',NULL),(263,44,'boot_menu','{\"title\": \"Boot Menu\", \"description\": \"If true, enables the BIOS bootmenu. In cases where both the image metadata and Extra Spec are set, the Extra Spec setting is used. This allows for flexibility in setting/overriding the default behavior as needed.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-02 08:13:33',NULL),(266,44,'mem_encryption','{\"title\": \"Hardware Memory Encryption\", \"description\": \"Enables encryption of guest memory at the hardware level, if there are compute hosts available which support this. See https://docs.openstack.org/nova/latest/admin/configuration/hypervisor-kvm.html#amd-sev-secure-encrypted-virtualization for details.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-02 08:13:33',NULL),(269,50,'hw_rng:allowed','{\"title\": \"Random Number Generator Allowed\", \"description\": \"\", \"type\": \"boolean\"}','2025-12-02 08:13:34',NULL),(272,50,'hw_rng:rate_bytes','{\"title\": \"Random number generator limits.\", \"description\": \"Allowed amount of bytes that the guest can read from the host\'s entropy per period.\", \"type\": \"integer\"}','2025-12-02 08:13:34',NULL),(275,50,'hw_rng:rate_period','{\"title\": \"Random number generator read period.\", \"description\": \"Duration of the read period in milliseconds.\", \"type\": \"integer\"}','2025-12-02 08:13:34',NULL),(278,53,'cpu_sockets','{\"title\": \"vCPU Sockets\", \"description\": \"Preferred number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-12-02 08:13:34',NULL),(281,53,'cpu_cores','{\"title\": \"vCPU Cores\", \"description\": \"Preferred number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-12-02 08:13:34',NULL),(284,53,'cpu_threads','{\"title\": \" vCPU Threads\", \"description\": \"Preferred number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-12-02 08:13:34',NULL),(287,53,'cpu_max_sockets','{\"title\": \"Max vCPU Sockets\", \"description\": \"Maximum number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-12-02 08:13:34',NULL),(290,53,'cpu_max_cores','{\"title\": \"Max vCPU Cores\", \"description\": \"Maximum number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-12-02 08:13:34',NULL),(293,53,'cpu_max_threads','{\"title\": \"Max vCPU Threads\", \"description\": \"Maximum number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-12-02 08:13:34',NULL),(296,56,'vmware:hw_version','{\"title\": \"VMware Hardware Version\", \"description\": \"Specifies the hardware version VMware uses to create images. If the hardware version needs to be compatible with a cluster version, for backward compatibility or other circumstances, the vmware:hw_version key specifies a virtual machine hardware version. In the event that a cluster has mixed host version types, the key will enable the vCenter to place the cluster on the correct host.\", \"type\": \"string\", \"enum\": [\"vmx-13\", \"vmx-11\", \"vmx-10\", \"vmx-09\", \"vmx-08\", \"vmx-07\", \"vmx-04\", \"vmx-03\"]}','2025-12-02 08:13:34',NULL),(299,56,'vmware:storage_policy','{\"title\": \"VMware Storage Policy\", \"description\": \"Specifies the storage policy to be applied for newly created instance. If not provided, the default storage policy specified in config file will be used. If Storage Policy Based Management (SPBM) is not enabled in config file, this value won\'t be used.\", \"type\": \"string\"}','2025-12-02 08:13:34',NULL),(302,59,'quota:cpu_limit','{\"title\": \"Quota: CPU Limit\", \"description\": \"Specifies the upper limit for CPU allocation in MHz. This parameter ensures that a machine never uses more than the defined amount of CPU time. It can be used to enforce a limit on the machine\'s CPU performance. The value should be a numerical value in MHz. If zero is supplied then the cpu_limit is unlimited.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-02 08:13:34',NULL),(305,59,'quota:cpu_reservation','{\"title\": \"Quota: CPU Reservation Limit\", \"description\": \"Specifies the guaranteed minimum CPU reservation in MHz. This means that if needed, the machine will definitely get allocated the reserved amount of CPU cycles. The value should be a numerical value in MHz.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-02 08:13:35',NULL),(308,62,'img_linked_clone','{\"title\": \"Linked Clone\", \"description\": \"By default, the VMware compute driver creates linked clones when possible (though this can be turned off by the operator). You can use this image property on a per-image basis to control whether virtual machines booted from the image are treated as full clones (value: false) or linked clones (value: true). Please refer to VMware documentation for information about full vs. linked clones.\", \"type\": \"boolean\"}','2025-12-02 08:13:35',NULL),(311,62,'vmware_adaptertype','{\"title\": \"Disk Adapter Type\", \"description\": \"The virtual SCSI or IDE controller used by the hypervisor.\", \"type\": \"string\", \"enum\": [\"lsiLogic\", \"lsiLogicsas\", \"paraVirtual\", \"busLogic\", \"ide\"], \"default\": \"lsiLogic\"}','2025-12-02 08:13:35',NULL),(314,62,'vmware_disktype','{\"title\": \"Disk Provisioning Type\", \"description\": \"When performing operations such as creating a virtual disk, cloning, or migrating, the disk provisioning type may be specified. Please refer to VMware documentation for more.\", \"type\": \"string\", \"enum\": [\"streamOptimized\", \"sparse\", \"preallocated\"], \"default\": \"preallocated\"}','2025-12-02 08:13:35',NULL),(317,62,'vmware_ostype','{\"title\": \"OS Type\", \"description\": \"A VMware GuestID which describes the operating system installed in the image. This value is passed to the hypervisor when creating a virtual machine. If not specified, the key defaults to otherGuest. See thinkvirt.com.\", \"type\": \"string\", \"enum\": [\"asianux3_64Guest\", \"asianux3Guest\", \"asianux4_64Guest\", \"asianux4Guest\", \"asianux5_64Guest\", \"asianux7_64Guest\", \"centos64Guest\", \"centosGuest\", \"centos6Guest\", \"centos6_64Guest\", \"centos7_64Guest\", \"coreos64Guest\", \"darwin10_64Guest\", \"darwin10Guest\", \"darwin11_64Guest\", \"darwin11Guest\", \"darwin12_64Guest\", \"darwin13_64Guest\", \"darwin14_64Guest\", \"darwin15_64Guest\", \"darwin16_64Guest\", \"darwin64Guest\", \"darwinGuest\", \"debian4_64Guest\", \"debian4Guest\", \"debian5_64Guest\", \"debian5Guest\", \"debian6_64Guest\", \"debian6Guest\", \"debian7_64Guest\", \"debian7Guest\", \"debian8_64Guest\", \"debian8Guest\", \"debian9_64Guest\", \"debian9Guest\", \"debian10_64Guest\", \"debian10Guest\", \"dosGuest\", \"eComStation2Guest\", \"eComStationGuest\", \"fedora64Guest\", \"fedoraGuest\", \"freebsd64Guest\", \"freebsdGuest\", \"genericLinuxGuest\", \"mandrakeGuest\", \"mandriva64Guest\", \"mandrivaGuest\", \"netware4Guest\", \"netware5Guest\", \"netware6Guest\", \"nld9Guest\", \"oesGuest\", \"openServer5Guest\", \"openServer6Guest\", \"opensuse64Guest\", \"opensuseGuest\", \"oracleLinux64Guest\", \"oracleLinuxGuest\", \"oracleLinux6Guest\", \"oracleLinux6_64Guest\", \"oracleLinux7_64Guest\", \"os2Guest\", \"other24xLinux64Guest\", \"other24xLinuxGuest\", \"other26xLinux64Guest\", \"other26xLinuxGuest\", \"other3xLinux64Guest\", \"other3xLinuxGuest\", \"otherGuest\", \"otherGuest64\", \"otherLinux64Guest\", \"otherLinuxGuest\", \"redhatGuest\", \"rhel2Guest\", \"rhel3_64Guest\", \"rhel3Guest\", \"rhel4_64Guest\", \"rhel4Guest\", \"rhel5_64Guest\", \"rhel5Guest\", \"rhel6_64Guest\", \"rhel6Guest\", \"rhel7_64Guest\", \"rhel7Guest\", \"sjdsGuest\", \"sles10_64Guest\", \"sles10Guest\", \"sles11_64Guest\", \"sles11Guest\", \"sles12_64Guest\", \"sles12Guest\", \"sles64Guest\", \"slesGuest\", \"solaris10_64Guest\", \"solaris10Guest\", \"solaris11_64Guest\", \"solaris6Guest\", \"solaris7Guest\", \"solaris8Guest\", \"solaris9Guest\", \"turboLinux64Guest\", \"turboLinuxGuest\", \"ubuntu64Guest\", \"ubuntuGuest\", \"unixWare7Guest\", \"vmkernel5Guest\", \"vmkernel6Guest\", \"vmkernel65Guest\", \"vmkernelGuest\", \"vmwarePhoton64Guest\", \"win2000AdvServGuest\", \"win2000ProGuest\", \"win2000ServGuest\", \"win31Guest\", \"win95Guest\", \"win98Guest\", \"windows7_64Guest\", \"windows7Guest\", \"windows7Server64Guest\", \"windows8_64Guest\", \"windows8Guest\", \"windows8Server64Guest\", \"windows9_64Guest\", \"windows9Guest\", \"windows9Server64Guest\", \"windowsHyperVGuest\", \"winLonghorn64Guest\", \"winLonghornGuest\", \"winMeGuest\", \"winNetBusinessGuest\", \"winNetDatacenter64Guest\", \"winNetDatacenterGuest\", \"winNetEnterprise64Guest\", \"winNetEnterpriseGuest\", \"winNetStandard64Guest\", \"winNetStandardGuest\", \"winNetWebGuest\", \"winNTGuest\", \"winVista64Guest\", \"winVistaGuest\", \"winXPHomeGuest\", \"winXPPro64Guest\", \"winXPProGuest\"], \"default\": \"otherGuest\"}','2025-12-02 08:13:35',NULL),(320,62,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor. VMware driver supported options: e1000, e1000e, VirtualE1000, VirtualE1000e, VirtualPCNet32, VirtualSriovEthernetCard, and VirtualVmxnet.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"VirtualE1000\", \"VirtualE1000e\", \"VirtualPCNet32\", \"VirtualSriovEthernetCard\", \"VirtualVmxnet\", \"VirtualVmxnet3\"], \"default\": \"e1000\"}','2025-12-02 08:13:35',NULL),(323,62,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-02 08:13:35',NULL),(326,65,'watchdog_action','{\"title\": \"Watchdog Action\", \"description\": \"For the libvirt driver, you can enable and set the behavior of a virtual hardware watchdog device for each flavor. Watchdog devices keep an eye on the guest server, and carry out the configured action, if the server hangs. The watchdog uses the i6300esb device (emulating a PCI Intel 6300ESB). If hw_watchdog_action is not specified, the watchdog is disabled. Watchdog behavior set using a specific image\'s properties will override behavior set using flavors.\", \"type\": \"string\", \"enum\": [\"disabled\", \"reset\", \"poweroff\", \"pause\", \"none\"]}','2025-12-02 08:13:35',NULL),(329,68,'auto_disk_config','{\"title\": \"Disk Adapter Type\", \"description\": \"If true, the root partition on the disk is automatically resized before the instance boots. This value is only taken into account by the Compute service when using a Xen-based hypervisor with the XenAPI driver. The Compute service will only attempt to resize if there is a single partition on the image, and only if the partition is in ext3 or ext4 format.\", \"type\": \"boolean\"}','2025-12-02 08:13:35',NULL),(332,71,'kernel_id','{\"title\": \"Kernel ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the kernel when booting an AMI-style image.\"}','2025-12-02 08:13:35',NULL),(335,71,'ramdisk_id','{\"title\": \"Ramdisk ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the ramdisk when booting an AMI-style image.\"}','2025-12-02 08:13:35',NULL),(338,71,'instance_uuid','{\"title\": \"Instance ID\", \"type\": \"string\", \"description\": \"Metadata which can be used to record which instance this image is associated with. (Informational only, does not create an instance snapshot.)\"}','2025-12-02 08:13:35',NULL),(341,71,'architecture','{\"title\": \"CPU Architecture\", \"description\": \"The CPU architecture that must be supported by the hypervisor. For example, x86_64, arm, or ppc64. Run uname -m to get the architecture of a machine. We strongly recommend using the architecture data vocabulary defined by the libosinfo project for this purpose.\", \"type\": \"string\"}','2025-12-02 08:13:35',NULL),(344,71,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-12-02 08:13:35',NULL),(347,71,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-12-02 08:13:35',NULL),(350,71,'description','{\"title\": \"Image description\", \"description\": \"A human-readable string describing this image.\", \"type\": \"string\"}','2025-12-02 08:13:35',NULL),(353,71,'cinder_encryption_key_id','{\"title\": \"Cinder Encryption Key ID\", \"description\": \"Identifier in the OpenStack Key Management Service for the encryption key for the Block Storage Service to use when mounting a volume created from this image\", \"type\": \"string\"}','2025-12-02 08:13:35',NULL),(356,71,'cinder_encryption_key_deletion_policy','{\"title\": \"Cinder Encryption Key Deletion Policy\", \"description\": \"States the condition under which the Image Service will delete the object associated with the \'cinder_encryption_key_id\' image property.  If this property is missing, the Image Service will take no action\", \"type\": \"string\", \"enum\": [\"on_image_deletion\", \"do_not_delete\"]}','2025-12-02 08:13:35',NULL),(359,74,'img_signature','{\"title\": \"Image Signature\", \"description\": \"The signature of the image data encoded in base64 format.\", \"type\": \"string\"}','2025-12-02 08:13:35',NULL),(362,74,'img_signature_certificate_uuid','{\"title\": \"Image Signature Certificate UUID\", \"description\": \"The UUID used to retrieve the certificate from the key manager.\", \"type\": \"string\"}','2025-12-02 08:13:35',NULL),(365,74,'img_signature_hash_method','{\"title\": \"Image Signature Hash Method\", \"description\": \"The hash method used in creating the signature.\", \"type\": \"string\", \"enum\": [\"SHA-224\", \"SHA-256\", \"SHA-384\", \"SHA-512\"]}','2025-12-02 08:13:35',NULL),(368,74,'img_signature_key_type','{\"title\": \"Image Signature Key Type\", \"description\": \"The key type used in creating the signature.\", \"type\": \"string\", \"enum\": [\"RSA-PSS\", \"DSA\", \"ECC_SECT571K1\", \"ECC_SECT409K1\", \"ECC_SECT571R1\", \"ECC_SECT409R1\", \"ECC_SECP521R1\", \"ECC_SECP384R1\"]}','2025-12-02 08:13:36',NULL),(371,77,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-12-02 08:13:36',NULL),(374,77,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-12-02 08:13:36',NULL),(377,77,'os_admin_user','{\"title\": \"OS Admin User\", \"description\": \"The name of the user with admin privileges.\", \"type\": \"string\"}','2025-12-02 08:13:36',NULL),(380,89,'img_volume_type','{\"title\": \"Image Volume Type\", \"description\": \"Specifies the volume type that should be applied during new volume creation with a image. This value is passed to Cinder when creating a new volume. Priority of volume type related parameters are 1.volume_type(via API or CLI), 2.cinder_img_volume_type, 3.default_volume_type(via cinder.conf). If not specified, volume_type or default_volume_type will be referred based on their priority.\", \"type\": \"string\"}','2025-12-02 08:13:38',NULL),(383,92,'cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"Type of CPU Mode.\", \"type\": \"string\", \"enum\": [\"none\", \"host-model\", \"host-passthrough\", \"custom\"]}','2025-12-02 08:52:15',NULL),(384,93,'tpm_model','{\"title\": \"TPM model\", \"description\": \"TPM model to use. Option CRB is only valid for TPM version 2.0. Defaults to TIS.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"TIS\", \"CRB\"], \"default\": \"TIS\"}','2025-12-02 08:52:15',NULL),(385,94,'COMPUTE_SECURITY_TPM_1_2','{\"title\": \"Virtual TPM Version 1.2 Support\", \"description\": \"Enables virtual TPM version 1.2.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-12-02 08:52:15',NULL),(386,94,'COMPUTE_SECURITY_TPM_2_0','{\"title\": \"Virtual TPM Version 2.0 Support\", \"description\": \"Enables virtual TPM version 2.0.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-12-02 08:52:15',NULL);
/*!40000 ALTER TABLE `metadef_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_resource_types`
--

DROP TABLE IF EXISTS `metadef_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_resource_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `protected` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_resource_types_name` (`name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_resource_types`
--

LOCK TABLES `metadef_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_resource_types` (`id`, `name`, `protected`, `created_at`, `updated_at`) VALUES (2,'OS::Cinder::Volume',1,'2025-12-02 08:13:27',NULL),(5,'OS::Glance::Image',1,'2025-12-02 08:13:27',NULL),(8,'OS::Nova::Aggregate',1,'2025-12-02 08:13:27',NULL),(11,'OS::Nova::Flavor',1,'2025-12-02 08:13:27',NULL),(14,'OS::Nova::Server',1,'2025-12-02 08:13:27',NULL),(17,'OS::Trove::Instance',1,'2025-12-02 08:13:36',NULL);
/*!40000 ALTER TABLE `metadef_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_tags`
--

DROP TABLE IF EXISTS `metadef_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_tags_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_tags_name` (`name`),
  CONSTRAINT `metadef_tags_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_tags`
--

LOCK TABLES `metadef_tags` WRITE;
/*!40000 ALTER TABLE `metadef_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadef_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrate_version`
--

DROP TABLE IF EXISTS `migrate_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrate_version` (
  `repository_id` varchar(250) NOT NULL,
  `repository_path` text DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`repository_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrate_version`
--

LOCK TABLES `migrate_version` WRITE;
/*!40000 ALTER TABLE `migrate_version` DISABLE KEYS */;
INSERT INTO `migrate_version` (`repository_id`, `repository_path`, `version`) VALUES ('Glance Migrations','/usr/lib/python3.9/site-packages/glance/db/sqlalchemy/migrate_repo',0);
/*!40000 ALTER TABLE `migrate_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_info`
--

DROP TABLE IF EXISTS `task_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_info` (
  `task_id` varchar(36) NOT NULL,
  `input` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  CONSTRAINT `task_info_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_info`
--

LOCK TABLES `task_info` WRITE;
/*!40000 ALTER TABLE `task_info` DISABLE KEYS */;
INSERT INTO `task_info` (`task_id`, `input`, `result`, `message`) VALUES ('35ffa5cb-fb03-4cd4-9623-7a13ad66c825','{\"image_properties\": {\"container_format\": \"bare\", \"disk_format\": \"qcow2\", \"visibility\": \"public\", \"name\": \"tempest-task_image-958765876\"}, \"import_from_format\": \"qcow2\", \"import_from\": \"http://tempest-dummy-img-file-1874034008.qcow2\"}',NULL,'Task failed due to Internal Error'),('b35da86b-4b1f-48de-90f5-6dab9ada13bc','{\"image_id\": \"9ac90228-fc59-4e6a-b4cb-c08636b183e8\", \"import_req\": {\"method\": {\"name\": \"glance-direct\"}, \"all_stores\": true}, \"backend\": [\"default_backend\"]}','{\"image_id\": \"9ac90228-fc59-4e6a-b4cb-c08636b183e8\"}','Copied 0 MiB'),('dab17964-1cb3-498b-9395-3e60e92ec16f','{\"image_id\": \"a0ba66b9-185e-4137-961a-a4f10b3f6136\", \"import_req\": {\"method\": {\"name\": \"web-download\", \"uri\": \"https://download.cirros-cloud.net/0.6.2/cirros-0.6.2-x86_64-disk.img\"}, \"all_stores\": true}, \"backend\": [\"default_backend\"]}','{\"image_id\": \"a0ba66b9-185e-4137-961a-a4f10b3f6136\"}','Copied 112 MiB'),('f3a1786e-7fe6-4857-9edc-21137f527d0f','{\"image_id\": \"daf6ec8e-aba0-46a1-9183-9a20928550a2\", \"import_req\": {\"method\": {\"name\": \"web-download\", \"uri\": \"http://does-not.exist/no/possible/way\"}, \"stores\": [\"default_backend\"]}, \"backend\": [\"default_backend\"]}',NULL,'Task failed due to Internal Error');
/*!40000 ALTER TABLE `task_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` varchar(36) NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `image_id` varchar(36) DEFAULT NULL,
  `request_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_tasks_deleted` (`deleted`),
  KEY `ix_tasks_owner` (`owner`),
  KEY `ix_tasks_status` (`status`),
  KEY `ix_tasks_type` (`type`),
  KEY `ix_tasks_updated_at` (`updated_at`),
  KEY `ix_tasks_image_id` (`image_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
INSERT INTO `tasks` (`id`, `type`, `status`, `owner`, `expires_at`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `image_id`, `request_id`, `user_id`) VALUES ('35ffa5cb-fb03-4cd4-9623-7a13ad66c825','import','failure','5eccd962391a4bdb917f641809bae417','2025-12-04 10:05:54','2025-12-02 10:05:53','2025-12-02 10:05:54',NULL,0,NULL,'req-6e58c7f2-31c0-44dc-a88c-ab162637e4c7','b0a10b2f6397488ba6aeb28dbeb54bae'),('b35da86b-4b1f-48de-90f5-6dab9ada13bc','api_image_import','success','4375c13984ab45c28b6c5c0320c0ae6c','2025-12-04 10:06:37','2025-12-02 10:06:36','2025-12-02 10:06:37',NULL,0,'9ac90228-fc59-4e6a-b4cb-c08636b183e8','req-4347b479-0422-47a9-8320-6de1d738b34d','61a6a019470b49f9bff7fd6ca6c8d330'),('dab17964-1cb3-498b-9395-3e60e92ec16f','api_image_import','success','4375c13984ab45c28b6c5c0320c0ae6c','2025-12-04 10:06:45','2025-12-02 10:06:38','2025-12-02 10:06:45',NULL,0,'a0ba66b9-185e-4137-961a-a4f10b3f6136','req-2fb52a98-33bf-4fd1-992b-0bb6a1076225','61a6a019470b49f9bff7fd6ca6c8d330'),('f3a1786e-7fe6-4857-9edc-21137f527d0f','api_image_import','failure','68963b5bdacc408aa9adc69ff150d3f8','2025-12-04 10:06:57','2025-12-02 10:06:57','2025-12-02 10:06:57',NULL,0,'daf6ec8e-aba0-46a1-9183-9a20928550a2','req-bcadbfb8-b574-404d-8a8e-c2be246ec313','696ad8233f2e4505ac3c6917b18737ba');
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `heat`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `heat` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `heat`;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `resource_action` varchar(255) DEFAULT NULL,
  `resource_status` varchar(255) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `physical_resource_id` varchar(255) DEFAULT NULL,
  `resource_status_reason` varchar(255) DEFAULT NULL,
  `resource_type` varchar(255) DEFAULT NULL,
  `resource_properties` blob DEFAULT NULL,
  `rsrc_prop_data_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `stack_id` (`stack_id`),
  KEY `ev_rsrc_prop_data_ref` (`rsrc_prop_data_id`),
  CONSTRAINT `ev_rsrc_prop_data_ref` FOREIGN KEY (`rsrc_prop_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `event_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `event`
--

LOCK TABLES `event` WRITE;
/*!40000 ALTER TABLE `event` DISABLE KEYS */;
/*!40000 ALTER TABLE `event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrate_version`
--

DROP TABLE IF EXISTS `migrate_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrate_version` (
  `repository_id` varchar(250) NOT NULL,
  `repository_path` text DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`repository_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrate_version`
--

LOCK TABLES `migrate_version` WRITE;
/*!40000 ALTER TABLE `migrate_version` DISABLE KEYS */;
INSERT INTO `migrate_version` (`repository_id`, `repository_path`, `version`) VALUES ('heat','/usr/lib/python3.9/site-packages/heat/db/sqlalchemy/migrate_repo',86);
/*!40000 ALTER TABLE `migrate_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raw_template`
--

DROP TABLE IF EXISTS `raw_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `raw_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `template` longtext DEFAULT NULL,
  `files` longtext DEFAULT NULL,
  `environment` longtext DEFAULT NULL,
  `files_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `raw_tmpl_files_fkey_ref` (`files_id`),
  CONSTRAINT `raw_tmpl_files_fkey_ref` FOREIGN KEY (`files_id`) REFERENCES `raw_template_files` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raw_template`
--

LOCK TABLES `raw_template` WRITE;
/*!40000 ALTER TABLE `raw_template` DISABLE KEYS */;
/*!40000 ALTER TABLE `raw_template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raw_template_files`
--

DROP TABLE IF EXISTS `raw_template_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `raw_template_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `files` longtext DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raw_template_files`
--

LOCK TABLES `raw_template_files` WRITE;
/*!40000 ALTER TABLE `raw_template_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `raw_template_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource`
--

DROP TABLE IF EXISTS `resource`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) DEFAULT NULL,
  `nova_instance` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  `rsrc_metadata` longtext DEFAULT NULL,
  `properties_data` longtext DEFAULT NULL,
  `engine_id` varchar(36) DEFAULT NULL,
  `atomic_key` int(11) DEFAULT NULL,
  `needed_by` longtext DEFAULT NULL,
  `requires` longtext DEFAULT NULL,
  `replaces` int(11) DEFAULT NULL,
  `replaced_by` int(11) DEFAULT NULL,
  `current_template_id` int(11) DEFAULT NULL,
  `properties_data_encrypted` tinyint(1) DEFAULT NULL,
  `root_stack_id` varchar(36) DEFAULT NULL,
  `rsrc_prop_data_id` int(11) DEFAULT NULL,
  `attr_data_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `stack_id` (`stack_id`),
  KEY `current_template_id` (`current_template_id`),
  KEY `ix_resource_root_stack_id` (`root_stack_id`),
  KEY `rsrc_rsrc_prop_data_ref` (`rsrc_prop_data_id`),
  KEY `rsrc_attr_data_ref` (`attr_data_id`),
  CONSTRAINT `resource_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`),
  CONSTRAINT `resource_ibfk_2` FOREIGN KEY (`current_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `rsrc_attr_data_ref` FOREIGN KEY (`attr_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `rsrc_rsrc_prop_data_ref` FOREIGN KEY (`rsrc_prop_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`properties_data_encrypted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource`
--

LOCK TABLES `resource` WRITE;
/*!40000 ALTER TABLE `resource` DISABLE KEYS */;
/*!40000 ALTER TABLE `resource` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_data`
--

DROP TABLE IF EXISTS `resource_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  `redact` tinyint(1) DEFAULT NULL,
  `decrypt_method` varchar(64) DEFAULT NULL,
  `resource_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_resource_id` (`resource_id`),
  CONSTRAINT `fk_resource_id` FOREIGN KEY (`resource_id`) REFERENCES `resource` (`id`) ON DELETE CASCADE,
  CONSTRAINT `CONSTRAINT_1` CHECK (`redact` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource_data`
--

LOCK TABLES `resource_data` WRITE;
/*!40000 ALTER TABLE `resource_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `resource_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_properties_data`
--

DROP TABLE IF EXISTS `resource_properties_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource_properties_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `data` longtext DEFAULT NULL,
  `encrypted` tinyint(1) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`encrypted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource_properties_data`
--

LOCK TABLES `resource_properties_data` WRITE;
/*!40000 ALTER TABLE `resource_properties_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `resource_properties_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(36) NOT NULL,
  `engine_id` varchar(36) NOT NULL,
  `host` varchar(255) NOT NULL,
  `hostname` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `topic` varchar(255) NOT NULL,
  `report_interval` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `engine_id`, `host`, `hostname`, `binary`, `topic`, `report_interval`, `created_at`, `updated_at`, `deleted_at`) VALUES ('00055b09-9f16-4b7d-94a1-2b712e277ef6','902dbe01-cf38-4d5d-9494-507cb02e5303','heat-engine-86f4b66794-2cxpt','heat-engine-86f4b66794-2cxpt','heat-engine','engine',60,'2025-12-02 09:00:32','2025-12-02 10:27:32',NULL),('0e6fb995-b25e-430c-b5df-0ec4ae2de77d','04f0800e-beff-4e92-ba37-5422e3ccffe0','heat-engine-86f4b66794-2cxpt','heat-engine-86f4b66794-2cxpt','heat-engine','engine',60,'2025-12-02 09:00:32','2025-12-02 10:27:33',NULL),('75a11d46-dece-43a7-ad3f-6b9408dcb974','816bea78-389c-4f9b-a6d4-f6f61094c835','heat-engine-86f4b66794-2cxpt','heat-engine-86f4b66794-2cxpt','heat-engine','engine',60,'2025-12-02 09:00:32','2025-12-02 10:27:33',NULL),('97595db4-e11f-4f2f-8646-4d4e420910e0','3e287c01-149d-4693-b21b-87e5b608a5f4','np0005541911.localdomain','np0005541911.localdomain','heat-engine','engine',60,'2025-12-02 08:18:32','2025-12-02 08:45:32',NULL),('9d26f36e-db78-4827-be12-2070afd3167a','a9a21d72-5e4f-4159-857a-fe83bec7e462','heat-engine-86f4b66794-2cxpt','heat-engine-86f4b66794-2cxpt','heat-engine','engine',60,'2025-12-02 09:00:32','2025-12-02 10:27:32',NULL),('a67a12a4-193c-4e25-80e1-fb9f691a8d74','f3b5b050-ed8e-456c-93e8-2328d504e79e','np0005541909.localdomain','np0005541909.localdomain','heat-engine','engine',60,'2025-12-02 08:18:16','2025-12-02 08:45:16',NULL),('f10f125a-ebf7-4d3c-a3b4-41bb4d14ca54','572d4b4b-6292-4a9d-9df6-112e077ec697','np0005541910.localdomain','np0005541910.localdomain','heat-engine','engine',60,'2025-12-02 08:18:31','2025-12-02 08:45:31',NULL);
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot`
--

DROP TABLE IF EXISTS `snapshot`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot` (
  `id` varchar(36) NOT NULL,
  `stack_id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` varchar(255) DEFAULT NULL,
  `data` longtext DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `stack_id` (`stack_id`),
  KEY `ix_snapshot_tenant` (`tenant`),
  CONSTRAINT `snapshot_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot`
--

LOCK TABLES `snapshot` WRITE;
/*!40000 ALTER TABLE `snapshot` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `software_config`
--

DROP TABLE IF EXISTS `software_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `software_config` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `group` varchar(255) DEFAULT NULL,
  `config` longtext DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_software_config_tenant` (`tenant`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `software_config`
--

LOCK TABLES `software_config` WRITE;
/*!40000 ALTER TABLE `software_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `software_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `software_deployment`
--

DROP TABLE IF EXISTS `software_deployment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `software_deployment` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `server_id` varchar(36) NOT NULL,
  `config_id` varchar(36) NOT NULL,
  `input_values` longtext DEFAULT NULL,
  `output_values` longtext DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  `stack_user_project_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `config_id` (`config_id`),
  KEY `ix_software_deployment_server_id` (`server_id`),
  KEY `ix_software_deployment_tenant` (`tenant`),
  KEY `ix_software_deployment_created_at` (`created_at`),
  CONSTRAINT `software_deployment_ibfk_1` FOREIGN KEY (`config_id`) REFERENCES `software_config` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `software_deployment`
--

LOCK TABLES `software_deployment` WRITE;
/*!40000 ALTER TABLE `software_deployment` DISABLE KEYS */;
/*!40000 ALTER TABLE `software_deployment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack`
--

DROP TABLE IF EXISTS `stack`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `raw_template_id` int(11) NOT NULL,
  `prev_raw_template_id` int(11) DEFAULT NULL,
  `user_creds_id` int(11) DEFAULT NULL,
  `username` varchar(256) DEFAULT NULL,
  `owner_id` varchar(36) DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `timeout` int(11) DEFAULT NULL,
  `tenant` varchar(256) DEFAULT NULL,
  `disable_rollback` tinyint(1) NOT NULL,
  `stack_user_project_id` varchar(64) DEFAULT NULL,
  `backup` tinyint(1) DEFAULT NULL,
  `nested_depth` int(11) DEFAULT NULL,
  `convergence` tinyint(1) DEFAULT NULL,
  `current_traversal` varchar(36) DEFAULT NULL,
  `current_deps` longtext DEFAULT NULL,
  `parent_resource_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `raw_template_id` (`raw_template_id`),
  KEY `prev_raw_template_id` (`prev_raw_template_id`),
  KEY `user_creds_id` (`user_creds_id`),
  KEY `ix_stack_owner_id` (`owner_id`),
  KEY `ix_stack_tenant` (`tenant`(255)),
  KEY `ix_stack_name` (`name`),
  CONSTRAINT `stack_ibfk_1` FOREIGN KEY (`raw_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `stack_ibfk_2` FOREIGN KEY (`prev_raw_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `stack_ibfk_3` FOREIGN KEY (`user_creds_id`) REFERENCES `user_creds` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`disable_rollback` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`backup` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`convergence` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack`
--

LOCK TABLES `stack` WRITE;
/*!40000 ALTER TABLE `stack` DISABLE KEYS */;
/*!40000 ALTER TABLE `stack` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack_lock`
--

DROP TABLE IF EXISTS `stack_lock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack_lock` (
  `stack_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `engine_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`stack_id`),
  CONSTRAINT `stack_lock_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack_lock`
--

LOCK TABLES `stack_lock` WRITE;
/*!40000 ALTER TABLE `stack_lock` DISABLE KEYS */;
/*!40000 ALTER TABLE `stack_lock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack_tag`
--

DROP TABLE IF EXISTS `stack_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `tag` varchar(80) DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `stack_id` (`stack_id`),
  CONSTRAINT `stack_tag_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack_tag`
--

LOCK TABLES `stack_tag` WRITE;
/*!40000 ALTER TABLE `stack_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `stack_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_point`
--

DROP TABLE IF EXISTS `sync_point`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sync_point` (
  `entity_id` varchar(36) NOT NULL,
  `traversal_id` varchar(36) NOT NULL,
  `is_update` tinyint(1) NOT NULL,
  `atomic_key` int(11) NOT NULL,
  `stack_id` varchar(36) NOT NULL,
  `input_data` longtext DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`traversal_id`,`is_update`),
  KEY `fk_stack_id` (`stack_id`),
  CONSTRAINT `fk_stack_id` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`is_update` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_point`
--

LOCK TABLES `sync_point` WRITE;
/*!40000 ALTER TABLE `sync_point` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_point` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_creds`
--

DROP TABLE IF EXISTS `user_creds`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_creds` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `username` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `region_name` varchar(255) DEFAULT NULL,
  `decrypt_method` varchar(64) DEFAULT NULL,
  `tenant` varchar(1024) DEFAULT NULL,
  `auth_url` text DEFAULT NULL,
  `tenant_id` varchar(256) DEFAULT NULL,
  `trust_id` varchar(255) DEFAULT NULL,
  `trustor_user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_creds`
--

LOCK TABLES `user_creds` WRITE;
/*!40000 ALTER TABLE `user_creds` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_creds` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `keystone`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `keystone` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `keystone`;

--
-- Table structure for table `access_rule`
--

DROP TABLE IF EXISTS `access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(64) DEFAULT NULL,
  `path` varchar(128) DEFAULT NULL,
  `method` varchar(16) DEFAULT NULL,
  `external_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_rule_external_id_key` (`external_id`),
  UNIQUE KEY `duplicate_access_rule_for_user_constraint` (`user_id`,`service`,`path`,`method`),
  KEY `external_id` (`external_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_rule`
--

LOCK TABLES `access_rule` WRITE;
/*!40000 ALTER TABLE `access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_token`
--

DROP TABLE IF EXISTS `access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_token` (
  `id` varchar(64) NOT NULL,
  `access_secret` varchar(64) NOT NULL,
  `authorizing_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  `role_ids` text NOT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_access_token_consumer_id` (`consumer_id`),
  KEY `ix_access_token_authorizing_user_id` (`authorizing_user_id`),
  CONSTRAINT `access_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_token`
--

LOCK TABLES `access_token` WRITE;
/*!40000 ALTER TABLE `access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('29e87d24a316'),('e25ffa003242');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential`
--

DROP TABLE IF EXISTS `application_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential` (
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `secret_hash` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `system` varchar(64) DEFAULT NULL,
  `unrestricted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `duplicate_app_cred_constraint` (`user_id`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential`
--

LOCK TABLES `application_credential` WRITE;
/*!40000 ALTER TABLE `application_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_access_rule`
--

DROP TABLE IF EXISTS `application_credential_access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_access_rule` (
  `application_credential_id` int(11) NOT NULL,
  `access_rule_id` int(11) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`access_rule_id`),
  KEY `access_rule_id` (`access_rule_id`),
  CONSTRAINT `application_credential_access_rule_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE,
  CONSTRAINT `application_credential_access_rule_ibfk_2` FOREIGN KEY (`access_rule_id`) REFERENCES `access_rule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_access_rule`
--

LOCK TABLES `application_credential_access_rule` WRITE;
/*!40000 ALTER TABLE `application_credential_access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_role`
--

DROP TABLE IF EXISTS `application_credential_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_role` (
  `application_credential_id` int(11) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`role_id`),
  CONSTRAINT `application_credential_role_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_role`
--

LOCK TABLES `application_credential_role` WRITE;
/*!40000 ALTER TABLE `application_credential_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assignment` (
  `type` enum('UserProject','GroupProject','UserDomain','GroupDomain') NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  KEY `ix_actor_id` (`actor_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`inherited` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserProject','0c7e47fd78d9490b9063dc6e94e0b3ad','497073c2347a4b2dbbf501873318fbd3','21802b184be54c9a9f9f99fd6277c69c',0),('UserProject','0c7e47fd78d9490b9063dc6e94e0b3ad','497073c2347a4b2dbbf501873318fbd3','25554cd3e4d449bea321b13ec9c0e128',0),('UserProject','3b01723fbb5d493280e0b20f52b38994','497073c2347a4b2dbbf501873318fbd3','21802b184be54c9a9f9f99fd6277c69c',0),('UserProject','3b01723fbb5d493280e0b20f52b38994','497073c2347a4b2dbbf501873318fbd3','25554cd3e4d449bea321b13ec9c0e128',0),('UserProject','3e7e7bf92d8d44f5b194085fa0ed465d','497073c2347a4b2dbbf501873318fbd3','21802b184be54c9a9f9f99fd6277c69c',0),('UserProject','3e7e7bf92d8d44f5b194085fa0ed465d','497073c2347a4b2dbbf501873318fbd3','25554cd3e4d449bea321b13ec9c0e128',0),('UserProject','47c723b6543f422184d6e02fd43d595d','497073c2347a4b2dbbf501873318fbd3','21802b184be54c9a9f9f99fd6277c69c',0),('UserProject','4ea94a3d730c499a8a661131692645ce','497073c2347a4b2dbbf501873318fbd3','21802b184be54c9a9f9f99fd6277c69c',0),('UserProject','4ea94a3d730c499a8a661131692645ce','497073c2347a4b2dbbf501873318fbd3','25554cd3e4d449bea321b13ec9c0e128',0),('UserProject','527a05e992df408faf9cf78a79f4353e','497073c2347a4b2dbbf501873318fbd3','21802b184be54c9a9f9f99fd6277c69c',0),('UserProject','527a05e992df408faf9cf78a79f4353e','497073c2347a4b2dbbf501873318fbd3','25554cd3e4d449bea321b13ec9c0e128',0),('UserProject','5bf218f626394b16a73e0bfb58411cf4','497073c2347a4b2dbbf501873318fbd3','21802b184be54c9a9f9f99fd6277c69c',0),('UserProject','5bf218f626394b16a73e0bfb58411cf4','497073c2347a4b2dbbf501873318fbd3','25554cd3e4d449bea321b13ec9c0e128',0),('UserProject','65805390643046bea131789824b0946f','497073c2347a4b2dbbf501873318fbd3','21802b184be54c9a9f9f99fd6277c69c',0),('UserProject','ab4364fdcce542378ae19fff3c3d9abe','497073c2347a4b2dbbf501873318fbd3','21802b184be54c9a9f9f99fd6277c69c',0),('UserProject','ab4364fdcce542378ae19fff3c3d9abe','497073c2347a4b2dbbf501873318fbd3','25554cd3e4d449bea321b13ec9c0e128',0),('UserProject','c12ddf970225448a9b860e3594003403','497073c2347a4b2dbbf501873318fbd3','211e85ebe8f041b2a8959251afc134f9',0),('UserProject','c12ddf970225448a9b860e3594003403','497073c2347a4b2dbbf501873318fbd3','21802b184be54c9a9f9f99fd6277c69c',0),('UserProject','c12ddf970225448a9b860e3594003403','497073c2347a4b2dbbf501873318fbd3','25554cd3e4d449bea321b13ec9c0e128',0),('UserProject','c4ddb205feda4fdf81a814060fee159d','497073c2347a4b2dbbf501873318fbd3','21802b184be54c9a9f9f99fd6277c69c',0),('UserProject','c4ddb205feda4fdf81a814060fee159d','497073c2347a4b2dbbf501873318fbd3','25554cd3e4d449bea321b13ec9c0e128',0),('UserProject','cb8b7d2a63b642aa999db12e17eeb9e4','39df5a456b5041ca879477e5908b399c','21802b184be54c9a9f9f99fd6277c69c',0),('UserProject','cb8b7d2a63b642aa999db12e17eeb9e4','e2d97696ab6749899bb8ba5ce29a3de2','21802b184be54c9a9f9f99fd6277c69c',0),('UserProject','d6136e6033d24eec850fd5d7af7a2c0c','497073c2347a4b2dbbf501873318fbd3','21802b184be54c9a9f9f99fd6277c69c',0),('UserProject','d6136e6033d24eec850fd5d7af7a2c0c','497073c2347a4b2dbbf501873318fbd3','25554cd3e4d449bea321b13ec9c0e128',0),('UserProject','dafd7fe1ebe54740b64cc9f8b3667fc9','497073c2347a4b2dbbf501873318fbd3','21802b184be54c9a9f9f99fd6277c69c',0),('UserProject','dafd7fe1ebe54740b64cc9f8b3667fc9','497073c2347a4b2dbbf501873318fbd3','25554cd3e4d449bea321b13ec9c0e128',0),('UserProject','db9b94bd57064aab94b78d0dc1c6caa4','497073c2347a4b2dbbf501873318fbd3','21802b184be54c9a9f9f99fd6277c69c',0),('UserProject','e4e9bbcee76b4fc39eff3a6aa56115e5','497073c2347a4b2dbbf501873318fbd3','21802b184be54c9a9f9f99fd6277c69c',0),('UserProject','e551833ffbae4dfe80ac88ba9039e469','39df5a456b5041ca879477e5908b399c','0e37716a088f42bb8866dfec3ae16965',0),('UserDomain','82e3b112753647778aca5ac3da9fa267','29a0224d96a4466cb378e99892ef6e05','21802b184be54c9a9f9f99fd6277c69c',0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_register`
--

DROP TABLE IF EXISTS `config_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_register` (
  `type` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_register`
--

LOCK TABLES `config_register` WRITE;
/*!40000 ALTER TABLE `config_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `config_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumer`
--

DROP TABLE IF EXISTS `consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumer` (
  `id` varchar(64) NOT NULL,
  `description` varchar(64) DEFAULT NULL,
  `secret` varchar(64) NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumer`
--

LOCK TABLES `consumer` WRITE;
/*!40000 ALTER TABLE `consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credential` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `key_hash` varchar(64) NOT NULL,
  `encrypted_blob` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
INSERT INTO `credential` (`id`, `user_id`, `project_id`, `type`, `extra`, `key_hash`, `encrypted_blob`) VALUES ('ea9c7060b3d647f1be7da25929a59236','cb8b7d2a63b642aa999db12e17eeb9e4',NULL,'cert','{}','461f97081972e2c5134a7286438eb2e6d4adc86a','gAAAAABpLqQXfjdoyVQJ9pKVoI9txyY59nDQ-BfuFZg2qhRU1jEe4t1mPa_yna1mx3mKqbCHr4bNLxG5uOHU7YADw8MjpfEuYA==');
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint` (
  `id` varchar(64) NOT NULL,
  `legacy_endpoint_id` varchar(64) DEFAULT NULL,
  `interface` varchar(8) NOT NULL,
  `service_id` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `region_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `service_id` (`service_id`),
  KEY `fk_endpoint_region_id` (`region_id`),
  CONSTRAINT `endpoint_service_id_fkey` FOREIGN KEY (`service_id`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_endpoint_region_id` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
INSERT INTO `endpoint` (`id`, `legacy_endpoint_id`, `interface`, `service_id`, `url`, `extra`, `enabled`, `region_id`) VALUES ('05cb9c3f7c31410faa72385bd99145af',NULL,'public','8387d5fdc5a540c9b05a8a7668e63352','http://placement-public-openstack.apps-crc.testing','{\"name\": \"placement\"}',1,'regionOne'),('06085a9905ab4c3c8221162043c556d7',NULL,'public','2109c32e7fd74b4398e960a0ffa08de4','http://aodh-public-openstack.apps-crc.testing','{\"name\": \"aodh\"}',1,'regionOne'),('0910e90a37c34674bc9c231afb03be0a',NULL,'public','0fb9bf86e9c34dcb964e42b649c4b49b','http://barbican-public-openstack.apps-crc.testing','{\"name\": \"barbican\"}',1,'regionOne'),('158e1f4e103041ba8072069cacfb2497',NULL,'internal','c09179ce9c044c19b50ad6c1cfd1ed1b','http://nova-internal.openstack.svc:8774/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('1a939b4446c943258ca439374904856d',NULL,'public','81a1066a71534338afc03f529cd50e61','http://neutron-public-openstack.apps-crc.testing','{\"name\": \"neutron\"}',1,'regionOne'),('27b570d1a9ee4be4b5be614ddb5f9f76',NULL,'internal','a2d98165bf0c4ca3aafe9061c0b84e1a','http://manila-internal.openstack.svc:8786/v1/%(project_id)s','{\"name\": \"manila\"}',1,'regionOne'),('2eb7f13e684b46b5ab5a9e231dfabdde',NULL,'public','f5cb4a629bce46ccade1020da103df42','http://cinder-public-openstack.apps-crc.testing/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('34b0b57a00be4a6bb135e6a8817e64b8',NULL,'public','8dfbb6571b4a443a86b6a3de666c955d','http://glance-default-public-openstack.apps-crc.testing','{\"name\": \"glance\"}',1,'regionOne'),('5e73ea72dca04a249d11f127483768a6',NULL,'internal','dd5d344d70064694bae0fe4f21c3cf0e','http://keystone-internal.openstack.svc:5000','{}',1,'regionOne'),('692ee332498543e7820a05464e56a2cd',NULL,'public','a2d98165bf0c4ca3aafe9061c0b84e1a','http://manila-public-openstack.apps-crc.testing/v1/%(project_id)s','{\"name\": \"manila\"}',1,'regionOne'),('697e59396884404399f830acf9793b13',NULL,'internal','73542ed1d69a4c98be6a83894afae975','http://heat-cfnapi-internal.openstack.svc:8000/v1','{\"name\": \"heat-cfn\"}',1,'regionOne'),('6d3d835f0abe413499ef7fe2837d0517',NULL,'internal','701644becdf14b8988317a75abccc664','http://manila-internal.openstack.svc:8786/v2','{\"name\": \"manilav2\"}',1,'regionOne'),('6f1b1699bb704eda918593086173b0ef',NULL,'internal','8dfbb6571b4a443a86b6a3de666c955d','http://glance-default-internal.openstack.svc:9292','{\"name\": \"glance\"}',1,'regionOne'),('785b8190fc684a4e85a24a57c9c65090',NULL,'public','701644becdf14b8988317a75abccc664','http://manila-public-openstack.apps-crc.testing/v2','{\"name\": \"manilav2\"}',1,'regionOne'),('9543922d2ddb432d9df5651362e52f00',NULL,'public','73542ed1d69a4c98be6a83894afae975','http://heat-cfnapi-public-openstack.apps-crc.testing/v1','{\"name\": \"heat-cfn\"}',1,'regionOne'),('9a8675e4e8484092bbe0ab3a6353f298',NULL,'internal','81a1066a71534338afc03f529cd50e61','http://neutron-internal.openstack.svc:9696','{\"name\": \"neutron\"}',1,'regionOne'),('a8b0e8de8b744f61b31cbc005d71d926',NULL,'public','dd5d344d70064694bae0fe4f21c3cf0e','http://keystone-public-openstack.apps-crc.testing','{}',1,'regionOne'),('b3e93ef3b16947bc959f948dacc36e7a',NULL,'public','c09179ce9c044c19b50ad6c1cfd1ed1b','http://nova-public-openstack.apps-crc.testing/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('b5c8f20f4f76415fbe54ef791594931e',NULL,'internal','0fb9bf86e9c34dcb964e42b649c4b49b','http://barbican-internal.openstack.svc:9311','{\"name\": \"barbican\"}',1,'regionOne'),('b78a3153a36740bb8bd5f6e2a0aab378',NULL,'internal','1efafc7ea64545c2ab6594bc7a36503d','http://heat-api-internal.openstack.svc:8004/v1/%(tenant_id)s','{\"name\": \"heat\"}',1,'regionOne'),('bfde1240e4b64c45bb7d6a998bb6eac3',NULL,'public','1efafc7ea64545c2ab6594bc7a36503d','http://heat-api-public-openstack.apps-crc.testing/v1/%(tenant_id)s','{\"name\": \"heat\"}',1,'regionOne'),('d9d5935da3f44a6eaa5a4136536020b4',NULL,'internal','2109c32e7fd74b4398e960a0ffa08de4','http://aodh-internal.openstack.svc:8042','{\"name\": \"aodh\"}',1,'regionOne'),('f224fb6ace4a4cacb10da545ca6095ba',NULL,'internal','f5cb4a629bce46ccade1020da103df42','http://cinder-internal.openstack.svc:8776/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('f7265d688cd34e7aa77bf2d8174e6421',NULL,'internal','8387d5fdc5a540c9b05a8a7668e63352','http://placement-internal.openstack.svc:8778','{\"name\": \"placement\"}',1,'regionOne');
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint_group`
--

DROP TABLE IF EXISTS `endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint_group` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `filters` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint_group`
--

LOCK TABLES `endpoint_group` WRITE;
/*!40000 ALTER TABLE `endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expiring_user_group_membership`
--

DROP TABLE IF EXISTS `expiring_user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expiring_user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `last_verified` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`,`idp_id`),
  KEY `group_id` (`group_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_3` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expiring_user_group_membership`
--

LOCK TABLES `expiring_user_group_membership` WRITE;
/*!40000 ALTER TABLE `expiring_user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `expiring_user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federated_user`
--

DROP TABLE IF EXISTS `federated_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federated_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `protocol_id` varchar(64) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idp_id` (`idp_id`,`protocol_id`,`unique_id`),
  KEY `user_id` (`user_id`),
  KEY `federated_user_protocol_id_fkey` (`protocol_id`,`idp_id`),
  CONSTRAINT `federated_user_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_ibfk_2` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_protocol_id_fkey` FOREIGN KEY (`protocol_id`, `idp_id`) REFERENCES `federation_protocol` (`id`, `idp_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federated_user`
--

LOCK TABLES `federated_user` WRITE;
/*!40000 ALTER TABLE `federated_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `federated_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federation_protocol`
--

DROP TABLE IF EXISTS `federation_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federation_protocol` (
  `id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `mapping_id` varchar(64) NOT NULL,
  `remote_id_attribute` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`,`idp_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `federation_protocol_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federation_protocol`
--

LOCK TABLES `federation_protocol` WRITE;
/*!40000 ALTER TABLE `federation_protocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `federation_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group`
--

DROP TABLE IF EXISTS `group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group` (
  `id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_group_name_domain_id` (`domain_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group`
--

LOCK TABLES `group` WRITE;
/*!40000 ALTER TABLE `group` DISABLE KEYS */;
/*!40000 ALTER TABLE `group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `id_mapping`
--

DROP TABLE IF EXISTS `id_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `id_mapping` (
  `public_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `local_id` varchar(255) NOT NULL,
  `entity_type` enum('user','group') NOT NULL,
  PRIMARY KEY (`public_id`),
  UNIQUE KEY `domain_id` (`domain_id`,`local_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `id_mapping`
--

LOCK TABLES `id_mapping` WRITE;
/*!40000 ALTER TABLE `id_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `id_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `identity_provider`
--

DROP TABLE IF EXISTS `identity_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `identity_provider` (
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `authorization_ttl` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_id` (`domain_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `identity_provider`
--

LOCK TABLES `identity_provider` WRITE;
/*!40000 ALTER TABLE `identity_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `identity_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `idp_remote_ids`
--

DROP TABLE IF EXISTS `idp_remote_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `idp_remote_ids` (
  `idp_id` varchar(64) DEFAULT NULL,
  `remote_id` varchar(255) NOT NULL,
  PRIMARY KEY (`remote_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `idp_remote_ids_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `idp_remote_ids`
--

LOCK TABLES `idp_remote_ids` WRITE;
/*!40000 ALTER TABLE `idp_remote_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `idp_remote_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `implied_role`
--

DROP TABLE IF EXISTS `implied_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `implied_role` (
  `prior_role_id` varchar(64) NOT NULL,
  `implied_role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`prior_role_id`,`implied_role_id`),
  KEY `implied_role_implied_role_id_fkey` (`implied_role_id`),
  CONSTRAINT `implied_role_implied_role_id_fkey` FOREIGN KEY (`implied_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE,
  CONSTRAINT `implied_role_prior_role_id_fkey` FOREIGN KEY (`prior_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `implied_role`
--

LOCK TABLES `implied_role` WRITE;
/*!40000 ALTER TABLE `implied_role` DISABLE KEYS */;
INSERT INTO `implied_role` (`prior_role_id`, `implied_role_id`) VALUES ('0e37716a088f42bb8866dfec3ae16965','1ddc63e1c4d745ae864e01e6b09bcd55'),('21802b184be54c9a9f9f99fd6277c69c','0e37716a088f42bb8866dfec3ae16965');
/*!40000 ALTER TABLE `implied_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `limit`
--

DROP TABLE IF EXISTS `limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `limit` (
  `id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `resource_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `registered_limit_id` varchar(64) DEFAULT NULL,
  `domain_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `limit_id_key` (`id`),
  KEY `registered_limit_id` (`registered_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `limit`
--

LOCK TABLES `limit` WRITE;
/*!40000 ALTER TABLE `limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_user`
--

DROP TABLE IF EXISTS `local_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `local_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `failed_auth_count` int(11) DEFAULT NULL,
  `failed_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_id` (`domain_id`,`name`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `local_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `local_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=644 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `local_user`
--

LOCK TABLES `local_user` WRITE;
/*!40000 ALTER TABLE `local_user` DISABLE KEYS */;
INSERT INTO `local_user` (`id`, `user_id`, `domain_id`, `name`, `failed_auth_count`, `failed_auth_at`) VALUES (2,'cb8b7d2a63b642aa999db12e17eeb9e4','default','admin',0,NULL),(5,'c4ddb205feda4fdf81a814060fee159d','default','aodh',0,NULL),(8,'c12ddf970225448a9b860e3594003403','default','ceilometer',0,NULL),(11,'0c7e47fd78d9490b9063dc6e94e0b3ad','default','cinder',0,NULL),(14,'5bf218f626394b16a73e0bfb58411cf4','default','cinderv3',0,NULL),(17,'527a05e992df408faf9cf78a79f4353e','default','glance',0,NULL),(20,'47c723b6543f422184d6e02fd43d595d','default','gnocchi',0,NULL),(23,'3e7e7bf92d8d44f5b194085fa0ed465d','default','heat',0,NULL),(26,'82e3b112753647778aca5ac3da9fa267','29a0224d96a4466cb378e99892ef6e05','heat_stack_domain_admin',0,NULL),(29,'db9b94bd57064aab94b78d0dc1c6caa4','default','heat-cfn',0,NULL),(32,'d6136e6033d24eec850fd5d7af7a2c0c','default','manila',0,NULL),(35,'e4e9bbcee76b4fc39eff3a6aa56115e5','default','manilav2',0,NULL),(38,'dafd7fe1ebe54740b64cc9f8b3667fc9','default','neutron',0,NULL),(41,'4ea94a3d730c499a8a661131692645ce','default','nova',0,NULL),(44,'3b01723fbb5d493280e0b20f52b38994','default','placement',0,NULL),(47,'65805390643046bea131789824b0946f','default','swift',0,NULL),(50,'ab4364fdcce542378ae19fff3c3d9abe','default','barbican',0,NULL),(51,'e551833ffbae4dfe80ac88ba9039e469','default','demo_tempestconf',0,NULL),(52,'d7cb1a3913b14d69acc11f5da29858a7','default','alt_demo_tempestconf',0,NULL);
/*!40000 ALTER TABLE `local_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mapping`
--

DROP TABLE IF EXISTS `mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mapping` (
  `id` varchar(64) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mapping`
--

LOCK TABLES `mapping` WRITE;
/*!40000 ALTER TABLE `mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrate_version`
--

DROP TABLE IF EXISTS `migrate_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrate_version` (
  `repository_id` varchar(250) NOT NULL,
  `repository_path` text DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`repository_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrate_version`
--

LOCK TABLES `migrate_version` WRITE;
/*!40000 ALTER TABLE `migrate_version` DISABLE KEYS */;
INSERT INTO `migrate_version` (`repository_id`, `repository_path`, `version`) VALUES ('keystone','/usr/lib/python3.9/site-packages/keystone/common/sql/migrate_repo',109),('keystone_contract','/usr/lib/python3.9/site-packages/keystone/common/sql/contract_repo',79),('keystone_data_migrate','/usr/lib/python3.9/site-packages/keystone/common/sql/data_migration_repo',79),('keystone_expand','/usr/lib/python3.9/site-packages/keystone/common/sql/expand_repo',79);
/*!40000 ALTER TABLE `migrate_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nonlocal_user`
--

DROP TABLE IF EXISTS `nonlocal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nonlocal_user` (
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  PRIMARY KEY (`domain_id`,`name`),
  UNIQUE KEY `ixu_nonlocal_user_user_id` (`user_id`),
  KEY `nonlocal_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `nonlocal_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nonlocal_user`
--

LOCK TABLES `nonlocal_user` WRITE;
/*!40000 ALTER TABLE `nonlocal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `nonlocal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password`
--

DROP TABLE IF EXISTS `password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_user_id` int(11) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `self_service` tinyint(1) NOT NULL DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `created_at_int` bigint(20) NOT NULL DEFAULT 0,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `local_user_id` (`local_user_id`),
  CONSTRAINT `password_ibfk_1` FOREIGN KEY (`local_user_id`) REFERENCES `local_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=646 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password`
--

LOCK TABLES `password` WRITE;
/*!40000 ALTER TABLE `password` DISABLE KEYS */;
INSERT INTO `password` (`id`, `local_user_id`, `expires_at`, `self_service`, `password_hash`, `created_at_int`, `expires_at_int`, `created_at`) VALUES (2,2,'2025-12-02 08:47:40',0,'$2b$12$hWMdgCa5U/hpqdZtawOsz.X36WziHBKaFb72sx99TCsRGvHH3BU5.',1764663240050409,1764665260427434,'2025-12-02 08:14:00'),(5,5,NULL,0,'$2b$12$dVVjffkBT0GRG9.E.kXTiO0fzJQJ6TstX6eAxRfUZYbzyv.axBEOu',1764663390159548,NULL,'2025-12-02 08:16:30'),(8,8,NULL,0,'$2b$12$3aMhZSJNOSjyI2FcQD.86O996fhRBWVWXhTdHpryt67NvAVHTkNdW',1764663390726980,NULL,'2025-12-02 08:16:30'),(11,11,NULL,0,'$2b$12$kKUYzncakZGAPMFupV1i4.SeIVN2O5XYLnwlqOUDgaLY7pT5CUUvC',1764663391028907,NULL,'2025-12-02 08:16:31'),(14,14,NULL,0,'$2b$12$GdkoqeDQ8L7ykBWLy2zX..ECHuvzy4yK8.J2nc5gVK6KAelUOOzQO',1764663391472431,NULL,'2025-12-02 08:16:31'),(17,17,NULL,0,'$2b$12$gZOHY4lsBHIf875KwxkuV.nvclGeOlCk5oGul/Ty09ktlDVVuIZSu',1764663391884088,NULL,'2025-12-02 08:16:31'),(20,20,NULL,0,'$2b$12$GBnDL3vgf6RakXwg3gP9pOSAv9feYaKIFvOZvXi.cniW4NTwH7o.O',1764663392537335,NULL,'2025-12-02 08:16:32'),(23,23,NULL,0,'$2b$12$m5SKfuFZ1cIkrJeZn5ZntuyRANaX1w3Y51cbsaaZDwqDp2W4LvUFC',1764663392662211,NULL,'2025-12-02 08:16:32'),(26,26,NULL,0,'$2b$12$PNOY67QheiCJLMTJ7HeWu.YImxR4Bbn7UWlAGEGQGDIm8e3/7E55G',1764663393427226,NULL,'2025-12-02 08:16:33'),(29,29,NULL,0,'$2b$12$R37/9vV8x/4prDGQjymQmOYE6Vz81bcH2XCQjasz465s2vGJeYoWq',1764663393474549,NULL,'2025-12-02 08:16:33'),(32,32,NULL,0,'$2b$12$owMNpRrpdpi.m6kYKHOhY.xdSk6GhrWEZNXyrgCLZ9.KgFS53zaKa',1764663394162848,NULL,'2025-12-02 08:16:34'),(35,35,NULL,0,'$2b$12$wYv/DD8nluEOkOWHeprFHeFjqBsXXYopkz4HqQKHKxrFvnltjH0e.',1764663402926477,NULL,'2025-12-02 08:16:42'),(38,38,NULL,0,'$2b$12$.QoeLrBKoypgA1oGALdqD.QmzsalDQ59aB5Z2uPOYyGzm9gly50Ya',1764663403196511,NULL,'2025-12-02 08:16:43'),(41,41,NULL,0,'$2b$12$Kc8LLCw42XtK/iuODJel9uecHlsUGvMM64bPZkQ18Y9CkH/PPvLUi',1764663403557151,NULL,'2025-12-02 08:16:43'),(44,44,NULL,0,'$2b$12$3xEodIEinM/ThStk6YP8NulwFfRbhMmb2DQ0Mr84v/cFHPWcgFtAC',1764663403882884,NULL,'2025-12-02 08:16:43'),(47,47,NULL,0,'$2b$12$iGMUPJVcEqlznPrkAkIJvu4aoduStQZzMPmqUvDBWByWZnS9mbAwu',1764663404278331,NULL,'2025-12-02 08:16:44'),(50,2,NULL,0,'$2b$12$o31tkS53GeZRjH0zm.FxbOZSJELX1BcxTa6oshWlkA8txMwqGOydm',1764665260427434,NULL,'2025-12-02 08:47:40'),(51,50,NULL,0,'$2b$12$2yh3KzLZCLF/RGhbYu/P7.oQjVWTGSnle/SGDHfhnZEeibic7N.Zy',1764665408271912,NULL,'2025-12-02 08:50:08'),(52,51,NULL,0,'$2b$12$MYm0MJcLkIjxHCoAyTrrIOWocCXBMgnouMZL1tkB.PQ79A.2C.Ala',1764669683715842,NULL,'2025-12-02 10:01:23'),(53,52,NULL,0,'$2b$12$OIQaT/47zGrMdtprknkT5.qtKuPiIKd0LlHcdY8HtQk2x9Gsm8DuS',1764669684105534,NULL,'2025-12-02 10:01:24');
/*!40000 ALTER TABLE `password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `blob` text NOT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_association`
--

DROP TABLE IF EXISTS `policy_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy_association` (
  `id` varchar(64) NOT NULL,
  `policy_id` varchar(64) NOT NULL,
  `endpoint_id` varchar(64) DEFAULT NULL,
  `service_id` varchar(64) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `endpoint_id` (`endpoint_id`,`service_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_association`
--

LOCK TABLES `policy_association` WRITE;
/*!40000 ALTER TABLE `policy_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project` (
  `id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL,
  `is_domain` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_project_name_domain_id` (`domain_id`,`name`),
  KEY `project_parent_id_fkey` (`parent_id`),
  CONSTRAINT `project_domain_id_fkey` FOREIGN KEY (`domain_id`) REFERENCES `project` (`id`),
  CONSTRAINT `project_parent_id_fkey` FOREIGN KEY (`parent_id`) REFERENCES `project` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
INSERT INTO `project` (`id`, `name`, `extra`, `description`, `enabled`, `domain_id`, `parent_id`, `is_domain`) VALUES ('29a0224d96a4466cb378e99892ef6e05','heat_stack','{}','',1,'<<keystone.domain.root>>',NULL,1),('39df5a456b5041ca879477e5908b399c','demo','{}','Project for Tempest demo_tempestconf user',1,'default','default',0),('497073c2347a4b2dbbf501873318fbd3','service','{}',NULL,1,'default','default',0),('7c710fa8ef34435a90faf381a656355c','alt_demo','{}','Project for Tempest alt_demo_tempestconf user',1,'default','default',0),('<<keystone.domain.root>>','<<keystone.domain.root>>','{}','',0,'<<keystone.domain.root>>',NULL,1),('default','Default','{}','The default domain',1,'<<keystone.domain.root>>',NULL,1),('e2d97696ab6749899bb8ba5ce29a3de2','admin','{}','Bootstrap project for initializing the cloud.',1,'default','default',0);
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint`
--

DROP TABLE IF EXISTS `project_endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint` (
  `endpoint_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint`
--

LOCK TABLES `project_endpoint` WRITE;
/*!40000 ALTER TABLE `project_endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint_group`
--

DROP TABLE IF EXISTS `project_endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint_group` (
  `endpoint_group_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_group_id`,`project_id`),
  CONSTRAINT `project_endpoint_group_ibfk_1` FOREIGN KEY (`endpoint_group_id`) REFERENCES `endpoint_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint_group`
--

LOCK TABLES `project_endpoint_group` WRITE;
/*!40000 ALTER TABLE `project_endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_option`
--

DROP TABLE IF EXISTS `project_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_option` (
  `project_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`project_id`,`option_id`),
  CONSTRAINT `project_option_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_option`
--

LOCK TABLES `project_option` WRITE;
/*!40000 ALTER TABLE `project_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_tag`
--

DROP TABLE IF EXISTS `project_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_tag` (
  `project_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`project_id`,`name`),
  UNIQUE KEY `project_id` (`project_id`,`name`),
  CONSTRAINT `project_tag_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_tag`
--

LOCK TABLES `project_tag` WRITE;
/*!40000 ALTER TABLE `project_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `parent_region_id` varchar(255) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` (`id`, `description`, `parent_region_id`, `extra`) VALUES ('regionOne','',NULL,'{}');
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registered_limit`
--

DROP TABLE IF EXISTS `registered_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `registered_limit` (
  `id` varchar(64) NOT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `default_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `registered_limit_id_key` (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `registered_limit`
--

LOCK TABLES `registered_limit` WRITE;
/*!40000 ALTER TABLE `registered_limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `registered_limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_token`
--

DROP TABLE IF EXISTS `request_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_token` (
  `id` varchar(64) NOT NULL,
  `request_secret` varchar(64) NOT NULL,
  `verifier` varchar(64) DEFAULT NULL,
  `authorizing_user_id` varchar(64) DEFAULT NULL,
  `requested_project_id` varchar(64) NOT NULL,
  `role_ids` text DEFAULT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_request_token_consumer_id` (`consumer_id`),
  CONSTRAINT `request_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_token`
--

LOCK TABLES `request_token` WRITE;
/*!40000 ALTER TABLE `request_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revocation_event`
--

DROP TABLE IF EXISTS `revocation_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revocation_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` varchar(64) DEFAULT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  `role_id` varchar(64) DEFAULT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `consumer_id` varchar(64) DEFAULT NULL,
  `access_token_id` varchar(64) DEFAULT NULL,
  `issued_before` datetime NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `revoked_at` datetime NOT NULL,
  `audit_id` varchar(32) DEFAULT NULL,
  `audit_chain_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_revocation_event_new_revoked_at` (`revoked_at`),
  KEY `ix_revocation_event_issued_before` (`issued_before`),
  KEY `ix_revocation_event_project_id_issued_before` (`project_id`,`issued_before`),
  KEY `ix_revocation_event_user_id_issued_before` (`user_id`,`issued_before`),
  KEY `ix_revocation_event_audit_id_issued_before` (`audit_id`,`issued_before`)
) ENGINE=InnoDB AUTO_INCREMENT=1201 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revocation_event`
--

LOCK TABLES `revocation_event` WRITE;
/*!40000 ALTER TABLE `revocation_event` DISABLE KEYS */;
INSERT INTO `revocation_event` (`id`, `domain_id`, `project_id`, `user_id`, `role_id`, `trust_id`, `consumer_id`, `access_token_id`, `issued_before`, `expires_at`, `revoked_at`, `audit_id`, `audit_chain_id`) VALUES (1,NULL,NULL,'cb8b7d2a63b642aa999db12e17eeb9e4',NULL,NULL,NULL,NULL,'2025-12-02 08:47:40',NULL,'2025-12-02 08:47:40',NULL,NULL),(2,NULL,NULL,'431ab014ee944575a6b6c02a6d4c08f7',NULL,NULL,NULL,NULL,'2025-12-02 10:02:24',NULL,'2025-12-02 10:02:24',NULL,NULL),(3,NULL,'45d082069d5949fa8cb2fe3cc7569039',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:02:27',NULL,'2025-12-02 10:02:27',NULL,NULL),(4,NULL,NULL,'1e9bde6491324bcba295a24023559aab',NULL,NULL,NULL,NULL,'2025-12-02 10:02:28',NULL,'2025-12-02 10:02:28',NULL,NULL),(5,NULL,NULL,'03b3c4b6ac9e49f0a179d2df83502c2d',NULL,NULL,NULL,NULL,'2025-12-02 10:02:28',NULL,'2025-12-02 10:02:28',NULL,NULL),(6,NULL,NULL,'0058413bcec3423081a6394b2098b646',NULL,NULL,NULL,NULL,'2025-12-02 10:02:28',NULL,'2025-12-02 10:02:28',NULL,NULL),(7,NULL,NULL,'ffe0691d527f47ef8b55be5f334aba09',NULL,NULL,NULL,NULL,'2025-12-02 10:02:28',NULL,'2025-12-02 10:02:28',NULL,NULL),(8,NULL,NULL,'ea8582c108f147098c544cf8ab9d0a03',NULL,NULL,NULL,NULL,'2025-12-02 10:02:29',NULL,'2025-12-02 10:02:29',NULL,NULL),(9,NULL,NULL,'ea0fbc188d954ae78e8bb4971330c158',NULL,NULL,NULL,NULL,'2025-12-02 10:02:29',NULL,'2025-12-02 10:02:29',NULL,NULL),(10,NULL,NULL,'26519b0a79914e6eba7eaed90e7d7003',NULL,NULL,NULL,NULL,'2025-12-02 10:02:29',NULL,'2025-12-02 10:02:29',NULL,NULL),(11,NULL,NULL,'a61e36d3a8ec4e5abb065f4dc9d19030',NULL,NULL,NULL,NULL,'2025-12-02 10:02:29',NULL,'2025-12-02 10:02:29',NULL,NULL),(12,NULL,'bb8aa71d59f540ddbff97f3d015e6f19',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:02:29',NULL,'2025-12-02 10:02:29',NULL,NULL),(13,NULL,NULL,'22688db5bc7e46e2a8d9e99c28906377',NULL,NULL,NULL,NULL,'2025-12-02 10:02:29',NULL,'2025-12-02 10:02:29',NULL,NULL),(14,NULL,NULL,'0dc3fe25e8654dbfa9d34f7719e327fe',NULL,NULL,NULL,NULL,'2025-12-02 10:02:30',NULL,'2025-12-02 10:02:30',NULL,NULL),(15,NULL,NULL,'a117d570546d4005ac4ab3a69a2b0a7b',NULL,NULL,NULL,NULL,'2025-12-02 10:02:30',NULL,'2025-12-02 10:02:30',NULL,NULL),(16,NULL,NULL,'7e320e27a2724531ab064ca5d5f8d33d',NULL,NULL,NULL,NULL,'2025-12-02 10:02:30',NULL,'2025-12-02 10:02:30',NULL,NULL),(17,NULL,NULL,'5bd3487a46954df0a78bbee24a18a5a6',NULL,NULL,NULL,NULL,'2025-12-02 10:02:31',NULL,'2025-12-02 10:02:31',NULL,NULL),(18,NULL,NULL,'f6b7f39c3fd64b1a84bb7868f062f27f',NULL,NULL,NULL,NULL,'2025-12-02 10:02:31',NULL,'2025-12-02 10:02:31',NULL,NULL),(19,NULL,'e8c8e90520be47019f4e88bc3654fc2e',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:02:32',NULL,'2025-12-02 10:02:32',NULL,NULL),(20,NULL,'28d2fa10ba5445bc97499bc527d4ea98',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:02:32',NULL,'2025-12-02 10:02:32',NULL,NULL),(21,NULL,'8dc0857c54ed41fa813d33ceafdea98a',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:02:33',NULL,'2025-12-02 10:02:33',NULL,NULL),(22,NULL,'d2dd0fef3a7b4311a87040aa6dfb0fd9',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:02:33',NULL,'2025-12-02 10:02:33',NULL,NULL),(23,NULL,'bacffdfceba742b2a0f3443d4df622d9',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:02:33',NULL,'2025-12-02 10:02:33',NULL,NULL),(24,NULL,'586cf95ddf0949f48de75ab0cbceff18',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:02:33',NULL,'2025-12-02 10:02:33',NULL,NULL),(25,NULL,'d0e78e8987324c7887a651e3ea9ebaf3',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:02:33',NULL,'2025-12-02 10:02:33',NULL,NULL),(26,NULL,'7c0e3fa66c914dbda579aa909afa6db9',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:02:33',NULL,'2025-12-02 10:02:33',NULL,NULL),(27,NULL,'d26005a0c5304f3b9aed2fee8f504bf7',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:02:34',NULL,'2025-12-02 10:02:34',NULL,NULL),(28,NULL,'5e21fbbac07f4b4ab014c6053845ecc7',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:02:34',NULL,'2025-12-02 10:02:34',NULL,NULL),(29,NULL,'c27d870ed1354870b120c19fe259bde3',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:02:34',NULL,'2025-12-02 10:02:34',NULL,NULL),(30,NULL,'2bd97126018642b8b7757207fef10d82',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:02:34',NULL,'2025-12-02 10:02:34',NULL,NULL),(31,NULL,'21d17735c2da46129588636b79b76dca',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:02:35',NULL,'2025-12-02 10:02:35',NULL,NULL),(32,NULL,NULL,'f7fff76c43cc42039f17f02e7ce8643e',NULL,NULL,NULL,NULL,'2025-12-02 10:02:40',NULL,'2025-12-02 10:02:40',NULL,NULL),(33,NULL,NULL,'3a282f7144d8481e9923ca3f6df322bb',NULL,NULL,NULL,NULL,'2025-12-02 10:02:40',NULL,'2025-12-02 10:02:40',NULL,NULL),(34,NULL,NULL,'a44dd59ed97843bf91fa6840e43e6795',NULL,NULL,NULL,NULL,'2025-12-02 10:02:41',NULL,'2025-12-02 10:02:41',NULL,NULL),(35,NULL,NULL,'4f89781208ac4fafb6d85977efb56360',NULL,NULL,NULL,NULL,'2025-12-02 10:02:41',NULL,'2025-12-02 10:02:41',NULL,NULL),(36,NULL,NULL,'bfd2d7c7c86f4a1785d0899010774646',NULL,NULL,NULL,NULL,'2025-12-02 10:02:41',NULL,'2025-12-02 10:02:41',NULL,NULL),(37,NULL,NULL,'9ac9402cbff542c4a6777f5f16237d04',NULL,NULL,NULL,NULL,'2025-12-02 10:02:42',NULL,'2025-12-02 10:02:42',NULL,NULL),(38,NULL,NULL,'c27a9b309be840ec8353222b6219904d',NULL,NULL,NULL,NULL,'2025-12-02 10:02:42',NULL,'2025-12-02 10:02:42',NULL,NULL),(39,NULL,NULL,'ee2ab95bc19f43c3b7d9c9ef71d23800',NULL,NULL,NULL,NULL,'2025-12-02 10:02:42',NULL,'2025-12-02 10:02:42',NULL,NULL),(40,NULL,NULL,'028573316a9a4949839927517f6a61d6',NULL,NULL,NULL,NULL,'2025-12-02 10:02:42',NULL,'2025-12-02 10:02:42',NULL,NULL),(41,NULL,NULL,'606282382e9347bbbeda9aaed51b0646',NULL,NULL,NULL,NULL,'2025-12-02 10:02:44',NULL,'2025-12-02 10:02:44',NULL,NULL),(42,NULL,NULL,'9aed4b89806147f7be0e8b7444660ed1',NULL,NULL,NULL,NULL,'2025-12-02 10:02:44',NULL,'2025-12-02 10:02:44',NULL,NULL),(43,NULL,'23806945515041c29910915fff9655d4',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:02:45',NULL,'2025-12-02 10:02:45',NULL,NULL),(44,NULL,'7f0aa37937aa4e9bb45afe1e8d371c7d',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:02:45',NULL,'2025-12-02 10:02:45',NULL,NULL),(45,NULL,'25d9bb0272ad4fc38cdde19ddca3583c',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:02:45',NULL,'2025-12-02 10:02:45',NULL,NULL),(46,NULL,'23652296b2424d309944c31fa2f9f5e9',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:02:45',NULL,'2025-12-02 10:02:45',NULL,NULL),(47,NULL,'a5839cd12adc4c66b4850c637b92d810',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:02:46',NULL,'2025-12-02 10:02:46',NULL,NULL),(48,NULL,NULL,'e55f68eb52b44913aae52ac9f057e8b3',NULL,NULL,NULL,NULL,'2025-12-02 10:02:46',NULL,'2025-12-02 10:02:46',NULL,NULL),(49,NULL,'b8d4cc3ca4a04670967f17b7e76d964b',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:02:46',NULL,'2025-12-02 10:02:46',NULL,NULL),(50,NULL,'3fdd3baf3ad34ceba44fb313c735a4d8',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:02:46',NULL,'2025-12-02 10:02:46',NULL,NULL),(51,NULL,NULL,'ae520eabd3a44aedbce4ef28089c369c',NULL,NULL,NULL,NULL,'2025-12-02 10:02:47',NULL,'2025-12-02 10:02:47',NULL,NULL),(52,NULL,'d84ccfeee76a48969893ce15c46a95c4',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:02:47',NULL,'2025-12-02 10:02:47',NULL,NULL),(53,NULL,'67bece5beff4452f824e2374b531a728',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:02:48',NULL,'2025-12-02 10:02:48',NULL,NULL),(54,NULL,'24708eb4f0234069bd367d96e944f046',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:02:50',NULL,'2025-12-02 10:02:50',NULL,NULL),(55,NULL,'3e776a6fe1ca4903ad97535a9f030e2a',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:02:51',NULL,'2025-12-02 10:02:51',NULL,NULL),(56,NULL,'e0e2a755f7b74df7b233d04c7876c8e8',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:02:54',NULL,'2025-12-02 10:02:54',NULL,NULL),(57,NULL,NULL,'fe99ca4c51fc4e1d8f64c59d6331b1b8',NULL,NULL,NULL,NULL,'2025-12-02 10:02:55',NULL,'2025-12-02 10:02:55',NULL,NULL),(58,NULL,NULL,'5aabc1cfbda046a2b25ac37b9c617ab3',NULL,NULL,NULL,NULL,'2025-12-02 10:02:56',NULL,'2025-12-02 10:02:56',NULL,NULL),(59,NULL,'4e7c9aa66b0448b1b5cc767afd97477c',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:02:56',NULL,'2025-12-02 10:02:56',NULL,NULL),(60,NULL,NULL,'0ea0c65024924dab8d5d83bb856a4481',NULL,NULL,NULL,NULL,'2025-12-02 10:02:56',NULL,'2025-12-02 10:02:56',NULL,NULL),(61,NULL,NULL,'7385ed9ca7a648ac8810e1a5c9e5782c',NULL,NULL,NULL,NULL,'2025-12-02 10:02:57',NULL,'2025-12-02 10:02:57',NULL,NULL),(62,NULL,NULL,'ad2d384ed9c2417695d9879be8c46773',NULL,NULL,NULL,NULL,'2025-12-02 10:02:57',NULL,'2025-12-02 10:02:57',NULL,NULL),(63,NULL,NULL,'6aba879373414cf6836bceac321f8219',NULL,NULL,NULL,NULL,'2025-12-02 10:02:57',NULL,'2025-12-02 10:02:57',NULL,NULL),(64,NULL,'e94669c22c5c4e2eb4777c7e83d471c1',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:02:58',NULL,'2025-12-02 10:02:58',NULL,NULL),(65,NULL,NULL,'9ec290d5b0c849c19c3b1d8cb111ec1c',NULL,NULL,NULL,NULL,'2025-12-02 10:02:59',NULL,'2025-12-02 10:02:59',NULL,NULL),(66,NULL,NULL,'220cb28f062e440da4404a0b992ef1c8',NULL,NULL,NULL,NULL,'2025-12-02 10:02:59',NULL,'2025-12-02 10:02:59',NULL,NULL),(67,NULL,'3dadee443b3b4f9da79f86ea8add0bcd',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:02:59',NULL,'2025-12-02 10:02:59',NULL,NULL),(68,NULL,'5efee02615ae42ac878ad7a57797cbce',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:00',NULL,'2025-12-02 10:03:00',NULL,NULL),(69,NULL,'be8786c47c4c4db49d3015f8e6d22ef9',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:00',NULL,'2025-12-02 10:03:00',NULL,NULL),(70,NULL,NULL,'d540466e9b2d4be9a643ca1ea3e6897f',NULL,NULL,NULL,NULL,'2025-12-02 10:03:00',NULL,'2025-12-02 10:03:00',NULL,NULL),(71,NULL,NULL,'011a983831d5465ca4933e2501f75b0a',NULL,NULL,NULL,NULL,'2025-12-02 10:03:01',NULL,'2025-12-02 10:03:01',NULL,NULL),(72,NULL,NULL,'a224ef2cea9f4937b0e4c7e0cd67d8d3',NULL,NULL,NULL,NULL,'2025-12-02 10:03:01',NULL,'2025-12-02 10:03:01',NULL,NULL),(73,NULL,'51b060f7b41f4392bcad072c92c31c50',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:01',NULL,'2025-12-02 10:03:01',NULL,NULL),(74,NULL,'40b3586c2f7b47f79dfa6f883ac66798',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:01',NULL,'2025-12-02 10:03:01',NULL,NULL),(75,NULL,'5980af37637f4e10b2971f11da934f9d',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:01',NULL,'2025-12-02 10:03:01',NULL,NULL),(76,NULL,'42053105dd6842b1a83f60a96b4e067e',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:02',NULL,'2025-12-02 10:03:02',NULL,NULL),(77,NULL,'f4cd7f25c7454149802f4858ede4c0d5',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:02',NULL,'2025-12-02 10:03:02',NULL,NULL),(78,NULL,'bfe2e816e9d24b599e207439b8ac1b4d',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:03',NULL,'2025-12-02 10:03:03',NULL,NULL),(79,NULL,'4f743ab3c0534f4cacdb76571e812282',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:04',NULL,'2025-12-02 10:03:04',NULL,NULL),(80,NULL,NULL,'a9514f0b6a524eaebc588953fb1062b2',NULL,NULL,NULL,NULL,'2025-12-02 10:03:07',NULL,'2025-12-02 10:03:07',NULL,NULL),(81,NULL,'d0e96e04b4e649dbb0f2571af8cd6a32',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:07',NULL,'2025-12-02 10:03:07',NULL,NULL),(82,NULL,NULL,'e582e53f69474b00ae6dc7ff3cb92de6',NULL,NULL,NULL,NULL,'2025-12-02 10:03:07',NULL,'2025-12-02 10:03:07',NULL,NULL),(83,NULL,NULL,'5be4898b8c7a4cc187e0feae39cf20c8',NULL,NULL,NULL,NULL,'2025-12-02 10:03:07',NULL,'2025-12-02 10:03:07',NULL,NULL),(84,NULL,NULL,'70a23c9d0f8f4db1a50d50212f7afb3c',NULL,NULL,NULL,NULL,'2025-12-02 10:03:07',NULL,'2025-12-02 10:03:07',NULL,NULL),(85,NULL,NULL,'bf715b2e98fe4592acd0d8cc8d37cfd0',NULL,NULL,NULL,NULL,'2025-12-02 10:03:07',NULL,'2025-12-02 10:03:07',NULL,NULL),(86,NULL,NULL,'77b160cb2c65452aa531b4c46e90bff1',NULL,NULL,NULL,NULL,'2025-12-02 10:03:07',NULL,'2025-12-02 10:03:07',NULL,NULL),(87,NULL,'f705d0f2f62e462c8ac3abb2a4e1ea59',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:09',NULL,'2025-12-02 10:03:09',NULL,NULL),(88,NULL,'aa649e20a2554089881369d9e89448ce',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:09',NULL,'2025-12-02 10:03:09',NULL,NULL),(89,NULL,'16eca6d9cc57401b90ada6c5751d8571',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:09',NULL,'2025-12-02 10:03:09',NULL,NULL),(90,NULL,'50c1e279666f4fba94ba26128884bea9',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:10',NULL,'2025-12-02 10:03:10',NULL,NULL),(91,NULL,'49d13f626dee449c9e7b27f468c42496',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:12',NULL,'2025-12-02 10:03:12',NULL,NULL),(92,NULL,NULL,'3215851e67a14c3d9bdf427abdd73555',NULL,NULL,NULL,NULL,'2025-12-02 10:03:13',NULL,'2025-12-02 10:03:13',NULL,NULL),(93,NULL,'1002b4fe30164adc9ca0e37030897ee5',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:14',NULL,'2025-12-02 10:03:14',NULL,NULL),(94,NULL,NULL,'89616bb752fa46e2b6940722a68b938f',NULL,NULL,NULL,NULL,'2025-12-02 10:03:16',NULL,'2025-12-02 10:03:16',NULL,NULL),(95,NULL,NULL,'dffe315c17fb45ca9b27fc069ad7452a',NULL,NULL,NULL,NULL,'2025-12-02 10:03:16',NULL,'2025-12-02 10:03:16',NULL,NULL),(96,NULL,NULL,'2e7475da2a7b4a7e84c5a4881c2c27fe',NULL,NULL,NULL,NULL,'2025-12-02 10:03:21',NULL,'2025-12-02 10:03:21',NULL,NULL),(97,NULL,NULL,'07c4b5212d31425fb59c06220a5086d4',NULL,NULL,NULL,NULL,'2025-12-02 10:03:21',NULL,'2025-12-02 10:03:21',NULL,NULL),(98,NULL,'c118f56af2cc4bacb5763537da535796',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:21',NULL,'2025-12-02 10:03:21',NULL,NULL),(99,NULL,'c132f877209b42f380af8f038d9ee826',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:23',NULL,'2025-12-02 10:03:23',NULL,NULL),(100,NULL,'3f69e4c804ba4d279e7fbce918d18a6f',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:24',NULL,'2025-12-02 10:03:24',NULL,NULL),(101,NULL,'bd886ac2e01a45f19bd6be238f611661',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:24',NULL,'2025-12-02 10:03:24',NULL,NULL),(102,NULL,NULL,'4f95426a71bd498e81ba00b62ec71ac7',NULL,NULL,NULL,NULL,'2025-12-02 10:03:36',NULL,'2025-12-02 10:03:36',NULL,NULL),(103,NULL,NULL,'4bdde02ba4d145a4a611acd5b424f2ca',NULL,NULL,NULL,NULL,'2025-12-02 10:03:37',NULL,'2025-12-02 10:03:37',NULL,NULL),(104,NULL,NULL,'d53a8642996c461381da16ac84742672',NULL,NULL,NULL,NULL,'2025-12-02 10:03:37',NULL,'2025-12-02 10:03:37',NULL,NULL),(105,NULL,'d7ee13f7906e4f3b8ab3c315eef68492',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:37',NULL,'2025-12-02 10:03:37',NULL,NULL),(106,NULL,NULL,'18f1b3f4107241c3b06dfbb9ccdb6a38',NULL,NULL,NULL,NULL,'2025-12-02 10:03:38',NULL,'2025-12-02 10:03:38',NULL,NULL),(107,NULL,NULL,'34f5f06b1e4c45caae5ed940723669d9',NULL,NULL,NULL,NULL,'2025-12-02 10:03:39',NULL,'2025-12-02 10:03:39',NULL,NULL),(108,NULL,'6a60d34e3aa34737a113cbc01b8e2714',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:40',NULL,'2025-12-02 10:03:40',NULL,NULL),(109,NULL,NULL,'ae3e09df11014ea5a2ef3268f80a493b',NULL,NULL,NULL,NULL,'2025-12-02 10:03:41',NULL,'2025-12-02 10:03:41',NULL,NULL),(110,NULL,'192674dd1ac445238bce884ce1100f96',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:41',NULL,'2025-12-02 10:03:41',NULL,NULL),(111,NULL,'0fb734b55e344834905ce578952de7bd',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:42',NULL,'2025-12-02 10:03:42',NULL,NULL),(112,NULL,'7e1db71f5d3440bf86f7eada66e854cf',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:42',NULL,'2025-12-02 10:03:42',NULL,NULL),(113,NULL,'0b6be8905184413b9dc603381a98a1f5',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:42',NULL,'2025-12-02 10:03:42',NULL,NULL),(114,NULL,NULL,'6befe4c4ed13431cad99c632203bfe6e',NULL,NULL,NULL,NULL,'2025-12-02 10:03:44',NULL,'2025-12-02 10:03:44',NULL,NULL),(115,NULL,'c3cf2111a5fb46399d2549acbab6b7ac',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:46',NULL,'2025-12-02 10:03:46',NULL,NULL),(116,NULL,NULL,'cbe7802858cf4ddebc244cca9d17e509',NULL,NULL,NULL,NULL,'2025-12-02 10:03:46',NULL,'2025-12-02 10:03:46',NULL,NULL),(117,NULL,NULL,'cf73414c0d7947049d9d63720a0e454e',NULL,NULL,NULL,NULL,'2025-12-02 10:03:46',NULL,'2025-12-02 10:03:46',NULL,NULL),(118,NULL,'eba8f52e72f443d1bc669b2829636116',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:48',NULL,'2025-12-02 10:03:48',NULL,NULL),(119,NULL,NULL,'037b1bebb0d14e7a9d30f98884231ebd',NULL,NULL,NULL,NULL,'2025-12-02 10:03:48',NULL,'2025-12-02 10:03:48',NULL,NULL),(120,NULL,'5362ca50d7bb472b977a6fde332849de',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:50',NULL,'2025-12-02 10:03:50',NULL,NULL),(121,NULL,NULL,'b3cb4815171848538f508689e22f005c',NULL,NULL,NULL,NULL,'2025-12-02 10:03:50',NULL,'2025-12-02 10:03:50',NULL,NULL),(122,NULL,NULL,'d3d823df936e4f64a7208c87d6de87c7',NULL,NULL,NULL,NULL,'2025-12-02 10:03:51',NULL,'2025-12-02 10:03:51',NULL,NULL),(123,NULL,'52133e25f25745b18df698643068a83a',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:51',NULL,'2025-12-02 10:03:51',NULL,NULL),(124,NULL,NULL,'8d7e139ce81945f78fc6545c995b310f',NULL,NULL,NULL,NULL,'2025-12-02 10:03:53',NULL,'2025-12-02 10:03:53',NULL,NULL),(125,NULL,NULL,'f497538879354a8198deeb77a6f72138',NULL,NULL,NULL,NULL,'2025-12-02 10:03:53',NULL,'2025-12-02 10:03:53',NULL,NULL),(126,NULL,'7a7a3bc6872441a6ba6e52b2c274b87a',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:53',NULL,'2025-12-02 10:03:53',NULL,NULL),(127,NULL,'edfb5cc295894fc9a8dc307891edb831',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:53',NULL,'2025-12-02 10:03:53',NULL,NULL),(128,NULL,'29c8d8f295c1440d862fa4464ec34ad9',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:54',NULL,'2025-12-02 10:03:54',NULL,NULL),(129,NULL,'e7dfbac4bdfe4b65b2f058efb710c6b1',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:03:55',NULL,'2025-12-02 10:03:55',NULL,NULL),(130,NULL,NULL,'b0906382271143748df8d71e59cd03ae',NULL,NULL,NULL,NULL,'2025-12-02 10:03:57',NULL,'2025-12-02 10:03:57',NULL,NULL),(131,NULL,NULL,'4aaa75606f96456b883705275e391c26',NULL,NULL,NULL,NULL,'2025-12-02 10:04:01',NULL,'2025-12-02 10:04:01',NULL,NULL),(132,NULL,'0156f1d9f3f946a89278fba7f17c0c08',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:03',NULL,'2025-12-02 10:04:03',NULL,NULL),(133,NULL,'f8ddcf0392094bf89fe14c3ac5d874e8',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:03',NULL,'2025-12-02 10:04:03',NULL,NULL),(134,NULL,NULL,'09df4dd8e8ee474cadd549c5e6cbca2d',NULL,NULL,NULL,NULL,'2025-12-02 10:04:04',NULL,'2025-12-02 10:04:04',NULL,NULL),(135,NULL,'9fad32eadef04ecb91d43903b5be38d4',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:05',NULL,'2025-12-02 10:04:05',NULL,NULL),(136,NULL,NULL,'15b4607712994006bb9a7f31572a1c9c',NULL,NULL,NULL,NULL,'2025-12-02 10:04:05',NULL,'2025-12-02 10:04:05',NULL,NULL),(137,NULL,'c4440d402d08499eb61ba440a6698060',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:08',NULL,'2025-12-02 10:04:08',NULL,NULL),(138,NULL,NULL,'79527b3465e0440f937c8669f86e826c',NULL,NULL,NULL,NULL,'2025-12-02 10:04:12',NULL,'2025-12-02 10:04:12',NULL,NULL),(139,NULL,'1918fd9941fb43428eb6e1c29ea069be',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:12',NULL,'2025-12-02 10:04:12',NULL,NULL),(140,NULL,'a3b47c1431ef4bd1ab8c568c9cfd1dae',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:13',NULL,'2025-12-02 10:04:13',NULL,NULL),(141,NULL,NULL,'5fcfaa2182ff47f4b6d04e405c22025b',NULL,NULL,NULL,NULL,'2025-12-02 10:04:13',NULL,'2025-12-02 10:04:13',NULL,NULL),(142,NULL,NULL,'254ceb358c154ea09d6a901e1995022c',NULL,NULL,NULL,NULL,'2025-12-02 10:04:13',NULL,'2025-12-02 10:04:13',NULL,NULL),(143,NULL,'c5ee99f9ec994136b8d14b3a6f0df96a',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:17',NULL,'2025-12-02 10:04:17',NULL,NULL),(144,NULL,'8e12adc1143e4e5fb0abc18879e14803',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:18',NULL,'2025-12-02 10:04:18',NULL,NULL),(145,NULL,NULL,'96d084f3c3184bf4ac7b9635139dd4aa',NULL,NULL,NULL,NULL,'2025-12-02 10:04:20',NULL,'2025-12-02 10:04:20',NULL,NULL),(146,NULL,NULL,'1cb5f3cd655948d69eadad12de0d4055',NULL,NULL,NULL,NULL,'2025-12-02 10:04:20',NULL,'2025-12-02 10:04:20',NULL,NULL),(147,NULL,'ddc79ca131d4403e88e3330889af3b9a',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:24',NULL,'2025-12-02 10:04:24',NULL,NULL),(148,NULL,'2d58bf4832b74708b28917a57e00803f',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:24',NULL,'2025-12-02 10:04:24',NULL,NULL),(149,NULL,'4c2ca77e87e744e783e47ee8e03d8c71',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:26',NULL,'2025-12-02 10:04:26',NULL,NULL),(150,NULL,NULL,'5b22ebf579bf4d449206a94452a1e29e',NULL,NULL,NULL,NULL,'2025-12-02 10:04:26',NULL,'2025-12-02 10:04:26',NULL,NULL),(151,NULL,'2de23c4dde424b1c8e57915814be3fa6',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:27',NULL,'2025-12-02 10:04:27',NULL,NULL),(152,NULL,'f37509021b5b43edb7d3966bc4807029',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:28',NULL,'2025-12-02 10:04:28',NULL,NULL),(153,NULL,NULL,'db34df4c333644bbbf21c292b4f9ed93',NULL,NULL,NULL,NULL,'2025-12-02 10:04:28',NULL,'2025-12-02 10:04:28',NULL,NULL),(154,NULL,NULL,'2e9b017d0a87424591087f36e61bc902',NULL,NULL,NULL,NULL,'2025-12-02 10:04:28',NULL,'2025-12-02 10:04:28',NULL,NULL),(155,NULL,'09cae3217c5e430b8dbe17828669a978',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:29',NULL,'2025-12-02 10:04:29',NULL,NULL),(156,NULL,NULL,'81e94f700509461c865354eb6cea59b2',NULL,NULL,NULL,NULL,'2025-12-02 10:04:29',NULL,'2025-12-02 10:04:29',NULL,NULL),(157,NULL,NULL,'797adc259ae649149bcb2a17969b31a0',NULL,NULL,NULL,NULL,'2025-12-02 10:04:31',NULL,'2025-12-02 10:04:31',NULL,NULL),(158,NULL,'baad1eeb6d1840e08814d66ca5571cc4',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:32',NULL,'2025-12-02 10:04:32',NULL,NULL),(159,NULL,'1be9808b71a446f1a0e988702b8c7882',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:32',NULL,'2025-12-02 10:04:32',NULL,NULL),(160,NULL,'171fd688fd5d42a8aef73a557f499994',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:33',NULL,'2025-12-02 10:04:33',NULL,NULL),(161,NULL,NULL,'5d2a1dd73fee440789897d09ac4f0afc',NULL,NULL,NULL,NULL,'2025-12-02 10:04:33',NULL,'2025-12-02 10:04:33',NULL,NULL),(162,NULL,'275721b7a50b41fb81d957477cc2cfd7',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:36',NULL,'2025-12-02 10:04:36',NULL,NULL),(163,NULL,'b1db4f455ea047e3b37458f6d2c5e699',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:36',NULL,'2025-12-02 10:04:36',NULL,NULL),(164,NULL,NULL,'60f523e6d03743daa3ff6f5bc7122d00',NULL,NULL,NULL,NULL,'2025-12-02 10:04:37',NULL,'2025-12-02 10:04:37',NULL,NULL),(165,NULL,NULL,'0f34e0319cfd4e2680d0e40bb8d8500f',NULL,NULL,NULL,NULL,'2025-12-02 10:04:37',NULL,'2025-12-02 10:04:37',NULL,NULL),(166,NULL,'dfb2b4e8d0aa49b0b34376cadc0ea911',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:38',NULL,'2025-12-02 10:04:38',NULL,NULL),(167,NULL,NULL,NULL,NULL,NULL,'c7e6dbe991da4d60bda13cc0ebb6e158',NULL,'2025-12-02 10:04:40',NULL,'2025-12-02 10:04:40',NULL,NULL),(168,NULL,'cccbafb2e3c343b2aab51714734bddce',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:40',NULL,'2025-12-02 10:04:40',NULL,NULL),(169,NULL,NULL,NULL,NULL,NULL,'9b61064d63f342438df429dcd45dbf09',NULL,'2025-12-02 10:04:40',NULL,'2025-12-02 10:04:40',NULL,NULL),(170,NULL,NULL,NULL,NULL,NULL,'83ab7d1cdd804d74828ab6e970e2fd2f',NULL,'2025-12-02 10:04:40',NULL,'2025-12-02 10:04:40',NULL,NULL),(171,NULL,NULL,NULL,NULL,NULL,'00f6a6cb7b9c49559f80672a594dcc9a',NULL,'2025-12-02 10:04:40',NULL,'2025-12-02 10:04:40',NULL,NULL),(172,NULL,NULL,NULL,NULL,NULL,'694260794a8849baa1b1c79aaa76a3b2',NULL,'2025-12-02 10:04:41',NULL,'2025-12-02 10:04:41',NULL,NULL),(173,NULL,NULL,'38c95349b96d4a30949f5b728f776360',NULL,NULL,NULL,NULL,'2025-12-02 10:04:41',NULL,'2025-12-02 10:04:41',NULL,NULL),(174,NULL,NULL,'443999835a3943e19a20d74f0afc0251',NULL,NULL,NULL,NULL,'2025-12-02 10:04:41',NULL,'2025-12-02 10:04:41',NULL,NULL),(175,NULL,'94da22ccd9274d0c99295b95b2d13954',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:43',NULL,'2025-12-02 10:04:43',NULL,NULL),(176,NULL,NULL,'8cfb6f1ee95c4fdda1bfea0872361cb5',NULL,NULL,NULL,NULL,'2025-12-02 10:04:43',NULL,'2025-12-02 10:04:43',NULL,NULL),(177,NULL,NULL,'1e889eace02449e0876c8219d1f78fdf',NULL,NULL,NULL,NULL,'2025-12-02 10:04:43',NULL,'2025-12-02 10:04:43',NULL,NULL),(178,NULL,'133a74d1de3040539a0eeca2cca41807',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:48',NULL,'2025-12-02 10:04:48',NULL,NULL),(179,NULL,'6f91f5ceded641458fdfc13efa91d74e',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:48',NULL,'2025-12-02 10:04:48',NULL,NULL),(180,NULL,'d99c022844d44d318cef38d62149a229',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:51',NULL,'2025-12-02 10:04:51',NULL,NULL),(181,NULL,'6f2674c0c08144ce85afadcc077196e7',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:51',NULL,'2025-12-02 10:04:51',NULL,NULL),(182,NULL,NULL,'fec3742159614f7481a2ab18cf2b92cc',NULL,NULL,NULL,NULL,'2025-12-02 10:04:51',NULL,'2025-12-02 10:04:51',NULL,NULL),(183,NULL,NULL,'1e3dc9766eec4e289d72b894cb2cace7',NULL,NULL,NULL,NULL,'2025-12-02 10:04:51',NULL,'2025-12-02 10:04:51',NULL,NULL),(184,NULL,'1b82bd421b3942118210d9e9660261c9',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:53',NULL,'2025-12-02 10:04:53',NULL,NULL),(185,NULL,NULL,'0761c55d142d4b6baead1cd11cdaf64f',NULL,NULL,NULL,NULL,'2025-12-02 10:04:54',NULL,'2025-12-02 10:04:54',NULL,NULL),(186,NULL,NULL,'5fccf4bef804401189c1dfb49b06f8ce',NULL,NULL,NULL,NULL,'2025-12-02 10:04:54',NULL,'2025-12-02 10:04:54',NULL,NULL),(187,NULL,'232fbdf0953c47359e5cd328a38e86b4',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:55',NULL,'2025-12-02 10:04:55',NULL,NULL),(188,NULL,NULL,'6af3931891a7400386eb260706dfca83',NULL,NULL,NULL,NULL,'2025-12-02 10:04:55',NULL,'2025-12-02 10:04:55',NULL,NULL),(189,NULL,'126085aa179443369d716d3ae2e4e6e4',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:55',NULL,'2025-12-02 10:04:55',NULL,NULL),(190,NULL,NULL,'1583e961fefc48749f39fdf4f81945c8',NULL,NULL,NULL,NULL,'2025-12-02 10:04:57',NULL,'2025-12-02 10:04:57',NULL,NULL),(191,NULL,'4ca4febcc29b48ada91ec33a5e2f9d60',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:57',NULL,'2025-12-02 10:04:57',NULL,NULL),(192,NULL,NULL,'4a08a63e19a447f8ac830b2fe090a1b8',NULL,NULL,NULL,NULL,'2025-12-02 10:04:58',NULL,'2025-12-02 10:04:58',NULL,NULL),(193,NULL,'e5b72ede5a6e4dd392916e7e1668854b',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:58',NULL,'2025-12-02 10:04:58',NULL,NULL),(194,NULL,'56ce1793589b4f65b8a9c8707f016c4c',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:58',NULL,'2025-12-02 10:04:58',NULL,NULL),(195,NULL,'a0475908295e475d873fdbfd8cc82cea',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:04:58',NULL,'2025-12-02 10:04:58',NULL,NULL),(196,NULL,'96f08ae38eb542b3bc9c3ead8b40a985',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:00',NULL,'2025-12-02 10:05:00',NULL,NULL),(197,NULL,'19214cbc9205478f8adb6c9c61327122',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:00',NULL,'2025-12-02 10:05:00',NULL,NULL),(198,NULL,NULL,'2668f475c1004c48ae93289d06c5595d',NULL,NULL,NULL,NULL,'2025-12-02 10:05:00',NULL,'2025-12-02 10:05:00',NULL,NULL),(199,NULL,NULL,'985eb7334be045a185abda86b040c126',NULL,NULL,NULL,NULL,'2025-12-02 10:05:01',NULL,'2025-12-02 10:05:01',NULL,NULL),(200,NULL,'99817d9cdcd44573a472711ad7608e1b',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:01',NULL,'2025-12-02 10:05:01',NULL,NULL),(201,NULL,'e9e3da8770844ad5b5552298a24dcbd2',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:01',NULL,'2025-12-02 10:05:01',NULL,NULL),(202,NULL,NULL,'efab9c28fdc14f26b7e3a2d272ca310f',NULL,NULL,NULL,NULL,'2025-12-02 10:05:01',NULL,'2025-12-02 10:05:01',NULL,NULL),(203,NULL,NULL,'70c26de8e7cf486a94fd9991afd057a6',NULL,NULL,NULL,NULL,'2025-12-02 10:05:02',NULL,'2025-12-02 10:05:02',NULL,NULL),(204,NULL,NULL,'93d4f715b13e4aa3a8bda86ee22b83ae',NULL,NULL,NULL,NULL,'2025-12-02 10:05:02',NULL,'2025-12-02 10:05:02',NULL,NULL),(205,NULL,NULL,'93d4f715b13e4aa3a8bda86ee22b83ae',NULL,NULL,NULL,NULL,'2025-12-02 10:05:04',NULL,'2025-12-02 10:05:04',NULL,NULL),(206,NULL,'9179e5f7db894681a40c0a359c1cb759',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:05',NULL,'2025-12-02 10:05:05',NULL,NULL),(207,NULL,NULL,'a7723e05abc14a308c9557ab00a896e8',NULL,NULL,NULL,NULL,'2025-12-02 10:05:05',NULL,'2025-12-02 10:05:05',NULL,NULL),(208,NULL,NULL,'97a3f5b178ab45ca8f8c0da440705823',NULL,NULL,NULL,NULL,'2025-12-02 10:05:05',NULL,'2025-12-02 10:05:05',NULL,NULL),(209,NULL,'6e29e347a2e646498edae22fb8f8b52f',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:05',NULL,'2025-12-02 10:05:05',NULL,NULL),(210,NULL,'472d583560f449509b1c255b3e9d28a8',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:05',NULL,'2025-12-02 10:05:05',NULL,NULL),(211,NULL,NULL,'11c80654f70e45c7970c4f70a711cae9',NULL,NULL,NULL,NULL,'2025-12-02 10:05:05',NULL,'2025-12-02 10:05:05',NULL,NULL),(212,NULL,NULL,'aac3f15bb3a94aef95437def9843bfac',NULL,NULL,NULL,NULL,'2025-12-02 10:05:05',NULL,'2025-12-02 10:05:05',NULL,NULL),(213,NULL,NULL,'18108490f0f4457d9d8804f6ccaa2ea4',NULL,NULL,NULL,NULL,'2025-12-02 10:05:06',NULL,'2025-12-02 10:05:06',NULL,NULL),(214,NULL,NULL,'74be079f659e4a2ca823d67a9cd96dfd',NULL,NULL,NULL,NULL,'2025-12-02 10:05:06',NULL,'2025-12-02 10:05:06',NULL,NULL),(215,NULL,NULL,'ce3d2dd46af74bdd83d1ae18f124aa89',NULL,NULL,NULL,NULL,'2025-12-02 10:05:09',NULL,'2025-12-02 10:05:09',NULL,NULL),(216,NULL,'b5617f8be9814a69ab9b2827bc847f8e',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:09',NULL,'2025-12-02 10:05:09',NULL,NULL),(217,NULL,'6b34b5039d7f4be78a3b7ce6fbceed7b',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:11',NULL,'2025-12-02 10:05:11',NULL,NULL),(218,NULL,'a969fe67b1e8473589ebe85d927a1a78',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:12',NULL,'2025-12-02 10:05:12',NULL,NULL),(219,NULL,NULL,'df6f797636884f349034f3b6227e5ef8',NULL,NULL,NULL,NULL,'2025-12-02 10:05:13',NULL,'2025-12-02 10:05:13',NULL,NULL),(220,NULL,NULL,'278e82fdae734a2d82f4858e24177ab3',NULL,NULL,NULL,NULL,'2025-12-02 10:05:13',NULL,'2025-12-02 10:05:13',NULL,NULL),(221,NULL,'2c4fc4d93982419f8c27f4099ef74206',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:13',NULL,'2025-12-02 10:05:13',NULL,NULL),(222,NULL,NULL,'acbc05fb049e4a2d93dd18c386b3d845',NULL,NULL,NULL,NULL,'2025-12-02 10:05:13',NULL,'2025-12-02 10:05:13',NULL,NULL),(223,NULL,NULL,'acbc05fb049e4a2d93dd18c386b3d845',NULL,NULL,NULL,NULL,'2025-12-02 10:05:13',NULL,'2025-12-02 10:05:13',NULL,NULL),(224,NULL,NULL,'278e82fdae734a2d82f4858e24177ab3',NULL,NULL,NULL,NULL,'2025-12-02 10:05:15',NULL,'2025-12-02 10:05:15',NULL,NULL),(225,NULL,NULL,'df6f797636884f349034f3b6227e5ef8',NULL,NULL,NULL,NULL,'2025-12-02 10:05:15',NULL,'2025-12-02 10:05:15',NULL,NULL),(226,NULL,'19ee5860b0e44e26878546d512fb7111',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:16',NULL,'2025-12-02 10:05:16',NULL,NULL),(227,NULL,NULL,'ea2138124b734d3d8181ea19e244e820',NULL,NULL,NULL,NULL,'2025-12-02 10:05:16',NULL,'2025-12-02 10:05:16',NULL,NULL),(228,NULL,NULL,'2ccf0d38076948d6847d2e4e3ad51487',NULL,NULL,NULL,NULL,'2025-12-02 10:05:17',NULL,'2025-12-02 10:05:17',NULL,NULL),(229,NULL,NULL,'8ea7e4987cc0442590b8b74b8b87805c',NULL,NULL,NULL,NULL,'2025-12-02 10:05:17',NULL,'2025-12-02 10:05:17',NULL,NULL),(230,NULL,NULL,'c78e21fa9bbd455d8cd97f59c84ea99e',NULL,NULL,NULL,NULL,'2025-12-02 10:05:17',NULL,'2025-12-02 10:05:17',NULL,NULL),(231,NULL,'996b62380d1e42b6bbf416b0db3ad3b2',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:17',NULL,'2025-12-02 10:05:17',NULL,NULL),(232,NULL,NULL,'343fb242cb584e24b9b433c21261d8bf',NULL,NULL,NULL,NULL,'2025-12-02 10:05:18',NULL,'2025-12-02 10:05:18',NULL,NULL),(233,NULL,NULL,'e07e15a764624fa4837835a881dbaf94',NULL,NULL,NULL,NULL,'2025-12-02 10:05:18',NULL,'2025-12-02 10:05:18',NULL,NULL),(234,NULL,NULL,'1c2a676670ea4394bf88f12848e907f5',NULL,NULL,NULL,NULL,'2025-12-02 10:05:18',NULL,'2025-12-02 10:05:18',NULL,NULL),(235,NULL,'c209cd49ace1472e83c0b91e553126a2',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:19',NULL,'2025-12-02 10:05:19',NULL,NULL),(236,NULL,'3226e7627afa4d8c87743a9d59f89c69',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:19',NULL,'2025-12-02 10:05:19',NULL,NULL),(237,NULL,NULL,'62fa1b7e9d38472cae79eb226dae1a10',NULL,NULL,NULL,NULL,'2025-12-02 10:05:19',NULL,'2025-12-02 10:05:19',NULL,NULL),(238,NULL,'b7f304b998a44d26bf1a5544a4c0a405',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:20',NULL,'2025-12-02 10:05:20',NULL,NULL),(239,NULL,'fc9ff62a3bf74c909890fbb3bc19560b',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:20',NULL,'2025-12-02 10:05:20',NULL,NULL),(240,NULL,'d24ce4672f0d4347bc9ef901daad1d5a',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:20',NULL,'2025-12-02 10:05:20',NULL,NULL),(241,NULL,NULL,'ea1452c8fb4a41c18de8b64a71bdfd83',NULL,NULL,NULL,NULL,'2025-12-02 10:05:21',NULL,'2025-12-02 10:05:21',NULL,NULL),(242,NULL,'2f4b437a14484f17b23a8fcf9db937ae',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:21',NULL,'2025-12-02 10:05:21',NULL,NULL),(243,NULL,NULL,'ec20a6cceee246d6b46878df263d30a4',NULL,NULL,NULL,NULL,'2025-12-02 10:05:22',NULL,'2025-12-02 10:05:22',NULL,NULL),(244,NULL,NULL,'6adecc0bca61445d8663c81ce3838d73',NULL,NULL,NULL,NULL,'2025-12-02 10:05:22',NULL,'2025-12-02 10:05:22',NULL,NULL),(245,NULL,NULL,'128dc0e572734d9083e5bf6378255d58',NULL,NULL,NULL,NULL,'2025-12-02 10:05:22',NULL,'2025-12-02 10:05:22',NULL,NULL),(246,NULL,'dc1edab5ae5d43f08b967b5bf594f8b5',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:23',NULL,'2025-12-02 10:05:23',NULL,NULL),(247,NULL,'eed3c16cdbc84a5bb16ebc91ba19db2b',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:23',NULL,'2025-12-02 10:05:23',NULL,NULL),(248,NULL,'f3aa043ff0ae414691c2dec46367fba5',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:23',NULL,'2025-12-02 10:05:23',NULL,NULL),(249,NULL,'d048f19ff5fc47dc88162ef5f9cebe8b',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:24',NULL,'2025-12-02 10:05:24',NULL,NULL),(250,NULL,NULL,'f31093ca397b488aa1b99544796072ee',NULL,NULL,NULL,NULL,'2025-12-02 10:05:25',NULL,'2025-12-02 10:05:25',NULL,NULL),(251,NULL,'6bf7a70456784d58b83d53ec619fc771',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:25',NULL,'2025-12-02 10:05:25',NULL,NULL),(252,NULL,'712fc48feab745ddb28335a4a884d63a',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:26',NULL,'2025-12-02 10:05:26',NULL,NULL),(253,NULL,'00d763971fff4b85b0430712c047b8bc',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:27',NULL,'2025-12-02 10:05:27',NULL,NULL),(254,NULL,'84e9cac48cb94c01be3300f31dd486e5',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:28',NULL,'2025-12-02 10:05:28',NULL,NULL),(255,NULL,NULL,'b8ece32b91f8470d8d05a6b986b4b3c8',NULL,NULL,NULL,NULL,'2025-12-02 10:05:28',NULL,'2025-12-02 10:05:28',NULL,NULL),(256,NULL,NULL,'fdea70ca935f40e2b6bfc37b27105ffc',NULL,NULL,NULL,NULL,'2025-12-02 10:05:28',NULL,'2025-12-02 10:05:28',NULL,NULL),(257,NULL,NULL,'7987b89389a84de9a8f7fc7c953b92ca',NULL,NULL,NULL,NULL,'2025-12-02 10:05:29',NULL,'2025-12-02 10:05:29',NULL,NULL),(258,NULL,'bd07292b3e7f4660812a93220d7a87df',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:29',NULL,'2025-12-02 10:05:29',NULL,NULL),(259,NULL,NULL,'fff8685a08cc44e4a44229fcd8cc54ea',NULL,NULL,NULL,NULL,'2025-12-02 10:05:29',NULL,'2025-12-02 10:05:29',NULL,NULL),(260,NULL,'29134a5a6b554e34bc1729ff0e939209',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:29',NULL,'2025-12-02 10:05:29',NULL,NULL),(261,NULL,NULL,'188caad4974d4108878b64e8722681cc',NULL,NULL,NULL,NULL,'2025-12-02 10:05:29',NULL,'2025-12-02 10:05:29',NULL,NULL),(262,NULL,NULL,'76fd96054e8d42a1abc36cb3f9d88730',NULL,NULL,NULL,NULL,'2025-12-02 10:05:30',NULL,'2025-12-02 10:05:30',NULL,NULL),(263,NULL,NULL,'25cd1ef9bd004df39530a8a30fd213dd',NULL,NULL,NULL,NULL,'2025-12-02 10:05:30',NULL,'2025-12-02 10:05:30',NULL,NULL),(264,NULL,'5e8a64aacc7d4b868ec2bc89d4e3782a',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:30',NULL,'2025-12-02 10:05:30',NULL,NULL),(265,NULL,NULL,'348efaf1f59b44308de50ed45e9e618e',NULL,NULL,NULL,NULL,'2025-12-02 10:05:30',NULL,'2025-12-02 10:05:30',NULL,NULL),(266,NULL,NULL,'435f24344a274947a0f7e7c34d8b9ff3',NULL,NULL,NULL,NULL,'2025-12-02 10:05:30',NULL,'2025-12-02 10:05:30',NULL,NULL),(267,NULL,NULL,'97f5d6c224ee465fb753a5fe1ce28dfc',NULL,NULL,NULL,NULL,'2025-12-02 10:05:30',NULL,'2025-12-02 10:05:30',NULL,NULL),(268,NULL,'ed54b604839d45ebadde77ca510eb2c8',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:31',NULL,'2025-12-02 10:05:31',NULL,NULL),(269,NULL,NULL,'992622b4a8f54c0296cb67322602823a',NULL,NULL,NULL,NULL,'2025-12-02 10:05:31',NULL,'2025-12-02 10:05:31',NULL,NULL),(270,NULL,NULL,'5aa1fc59e1a64008b7f0d8c004ecdf73',NULL,NULL,NULL,NULL,'2025-12-02 10:05:31',NULL,'2025-12-02 10:05:31',NULL,NULL),(271,NULL,'9fb3dcb984cd4b8eb4563ce1238d38d4',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:31',NULL,'2025-12-02 10:05:31',NULL,NULL),(272,NULL,'b0fb953936d842cdb2d272c853f8cfa6',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:32',NULL,'2025-12-02 10:05:32',NULL,NULL),(273,NULL,'718a288f1f0c4730a861a59d152412e7',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:32',NULL,'2025-12-02 10:05:32',NULL,NULL),(274,NULL,'0b5ef0f3ff6b4c919f597aa24998f2ac',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:32',NULL,'2025-12-02 10:05:32',NULL,NULL),(275,NULL,'3d61cc534c4b4489b11fb424c8954eec',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:32',NULL,'2025-12-02 10:05:32',NULL,NULL),(276,NULL,'b6736dfa9a1a44e9831e7cb138ecc82f',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:32',NULL,'2025-12-02 10:05:32',NULL,NULL),(277,NULL,'03d180cd08f64d2a8b2fd7678d49c994',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:32',NULL,'2025-12-02 10:05:32',NULL,NULL),(278,NULL,NULL,'8f1b46dabd674d97962b51bfd417aa81',NULL,NULL,NULL,NULL,'2025-12-02 10:05:33',NULL,'2025-12-02 10:05:33',NULL,NULL),(279,NULL,NULL,'bff47f2983504502b9217a661b57209a',NULL,NULL,NULL,NULL,'2025-12-02 10:05:33',NULL,'2025-12-02 10:05:33',NULL,NULL),(280,NULL,NULL,'54b7b43a8ded4fd08e87a78db6a814d1',NULL,NULL,NULL,NULL,'2025-12-02 10:05:33',NULL,'2025-12-02 10:05:33',NULL,NULL),(281,NULL,'7056083eca4546bc899cf6d15429549a',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:33',NULL,'2025-12-02 10:05:33',NULL,NULL),(282,NULL,'230902a6d8df4b1a8ebc3439bcf8a292',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:33',NULL,'2025-12-02 10:05:33',NULL,NULL),(283,NULL,'0985c7ddefc94715b3d6a9d68e7d02c0',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:33',NULL,'2025-12-02 10:05:33',NULL,NULL),(284,NULL,'c9b052e3b85d48788450421a23be9fa4',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:34',NULL,'2025-12-02 10:05:34',NULL,NULL),(285,NULL,'ec7ddbe42a7c4876bbf3e8dabe382f4e',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:34',NULL,'2025-12-02 10:05:34',NULL,NULL),(286,NULL,'a327efa3d0c9412b82cd9cabf836a7bb',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:35',NULL,'2025-12-02 10:05:35',NULL,NULL),(287,NULL,'3cb213dedc894d62a38023017e98b962',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:36',NULL,'2025-12-02 10:05:36',NULL,NULL),(288,NULL,NULL,'91ca5ad004e746c0a90f9da1d89dde79',NULL,NULL,NULL,NULL,'2025-12-02 10:05:38',NULL,'2025-12-02 10:05:38',NULL,NULL),(289,NULL,NULL,'e3049c9de24547cc84dc9d644ef86523',NULL,NULL,NULL,NULL,'2025-12-02 10:05:38',NULL,'2025-12-02 10:05:38',NULL,NULL),(290,NULL,NULL,'f88abfaa7a864689956a2b7cf47be8cf',NULL,NULL,NULL,NULL,'2025-12-02 10:05:39',NULL,'2025-12-02 10:05:39',NULL,NULL),(291,NULL,NULL,'955214da09cd44dba70e1a06eabc9023',NULL,NULL,NULL,NULL,'2025-12-02 10:05:40',NULL,'2025-12-02 10:05:40',NULL,NULL),(292,NULL,'b6e4704d98e843cf808269380c7594be',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:41',NULL,'2025-12-02 10:05:41',NULL,NULL),(293,NULL,'b0dc76ca13b3467ab62675e9c4479681',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:41',NULL,'2025-12-02 10:05:41',NULL,NULL),(294,NULL,'50df25ee29424615807a458690cdf8d7',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:41',NULL,'2025-12-02 10:05:41',NULL,NULL),(295,NULL,NULL,'b7854872dce942698713cd7a679a14ea',NULL,NULL,NULL,NULL,'2025-12-02 10:05:41',NULL,'2025-12-02 10:05:41',NULL,NULL),(296,NULL,'5ae8a8a673e24538a8fbcbe814b99017',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:41',NULL,'2025-12-02 10:05:41',NULL,NULL),(297,NULL,NULL,'ea83c49f7da541f3aa2b55bcbf8d72e9',NULL,NULL,NULL,NULL,'2025-12-02 10:05:42',NULL,'2025-12-02 10:05:42',NULL,NULL),(298,NULL,NULL,'af6250400bd1427ba4771544e34b37e4',NULL,NULL,NULL,NULL,'2025-12-02 10:05:42',NULL,'2025-12-02 10:05:42',NULL,NULL),(299,NULL,'e28e6cd5d4b74f05b34e7a9048aa6a42',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:42',NULL,'2025-12-02 10:05:42',NULL,NULL),(300,NULL,'8634952d55394f4eb536571fcf2fd31e',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:42',NULL,'2025-12-02 10:05:42',NULL,NULL),(301,NULL,NULL,'ce6f6ae8548f4c8f9676283386eb4bdf',NULL,NULL,NULL,NULL,'2025-12-02 10:05:42',NULL,'2025-12-02 10:05:42',NULL,NULL),(302,NULL,'841c2bde56ee4c8fa182b0d8d44d599b',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:44',NULL,'2025-12-02 10:05:44',NULL,NULL),(303,NULL,'a0040b51e35448ff8610e3dbd3a230dd',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:44',NULL,'2025-12-02 10:05:44',NULL,NULL),(304,NULL,'98b18a8f2f674fedbf055b80da3ec570',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:45',NULL,'2025-12-02 10:05:45',NULL,NULL),(305,NULL,'55f1b554978a4bdd88787a5fb7a36439',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:45',NULL,'2025-12-02 10:05:45',NULL,NULL),(306,NULL,'7f25271103034965adeb8c7e513d623c',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:45',NULL,'2025-12-02 10:05:45',NULL,NULL),(307,NULL,NULL,'baa7ca855e414daebab132abb0e66b0a',NULL,NULL,NULL,NULL,'2025-12-02 10:05:45',NULL,'2025-12-02 10:05:45',NULL,NULL),(308,NULL,NULL,'d6991deabc7b4c2b8302cd1cd68e1f05',NULL,NULL,NULL,NULL,'2025-12-02 10:05:46',NULL,'2025-12-02 10:05:46',NULL,NULL),(309,NULL,NULL,'e57581b2e057497e9f7cafa2f0852442',NULL,NULL,NULL,NULL,'2025-12-02 10:05:46',NULL,'2025-12-02 10:05:46',NULL,NULL),(310,NULL,NULL,'880b0b9b7cff46b99e195069f63ec435',NULL,NULL,NULL,NULL,'2025-12-02 10:05:47',NULL,'2025-12-02 10:05:47',NULL,NULL),(311,NULL,'75a86c726bb74cf3bec4dd49237e386d',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:47',NULL,'2025-12-02 10:05:47',NULL,NULL),(312,NULL,'3e25f53c973045c5ab4d624c64b77d68',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:47',NULL,'2025-12-02 10:05:47',NULL,NULL),(313,NULL,'7f46a460ebaf414ea539321e0f598d00',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:47',NULL,'2025-12-02 10:05:47',NULL,NULL),(314,NULL,'7b9dcb72aa8941df9106303dbabecb14',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:48',NULL,'2025-12-02 10:05:48',NULL,NULL),(315,NULL,NULL,'4a8fa20e99d24586b6c72ca7db086c50',NULL,NULL,NULL,NULL,'2025-12-02 10:05:48',NULL,'2025-12-02 10:05:48',NULL,NULL),(316,NULL,'cb21565c866945f6a035d6379fab41af',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:49',NULL,'2025-12-02 10:05:49',NULL,NULL),(317,NULL,NULL,'0527544f6d424616b0738ccf61162ba6',NULL,NULL,NULL,NULL,'2025-12-02 10:05:49',NULL,'2025-12-02 10:05:49',NULL,NULL),(318,NULL,NULL,'d428bbd0dc684d59b2bb13b5095f3b4f',NULL,NULL,NULL,NULL,'2025-12-02 10:05:50',NULL,'2025-12-02 10:05:50',NULL,NULL),(319,NULL,'778386e603e242ee80663f979fe8d4f6',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:51',NULL,'2025-12-02 10:05:51',NULL,NULL),(320,NULL,NULL,'f51113506ad24398a559341a07f3c082',NULL,NULL,NULL,NULL,'2025-12-02 10:05:51',NULL,'2025-12-02 10:05:51',NULL,NULL),(321,NULL,'92b34244848141b9a625ec819cc712c5',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:52',NULL,'2025-12-02 10:05:52',NULL,NULL),(322,NULL,'3f58dd78a8cd471aab71f49f2af8bf09',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:53',NULL,'2025-12-02 10:05:53',NULL,NULL),(323,NULL,'b5df191d29dc456b802b3558bc31eb12',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:53',NULL,'2025-12-02 10:05:53',NULL,NULL),(324,NULL,NULL,NULL,NULL,'6b1ea3323df54a2aa435f45ceea2e3eb',NULL,NULL,'2025-12-02 10:05:53',NULL,'2025-12-02 10:05:53',NULL,NULL),(325,NULL,NULL,'3480a07e80ee4cf5a76d130c342eb5c8',NULL,NULL,NULL,NULL,'2025-12-02 10:05:54',NULL,'2025-12-02 10:05:54',NULL,NULL),(326,NULL,'a837ee4fb9974541906c7fc2eec9ba40',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:54',NULL,'2025-12-02 10:05:54',NULL,NULL),(327,NULL,'7ba7fb0d49f54f008a215a61f562c43c',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:54',NULL,'2025-12-02 10:05:54',NULL,NULL),(328,NULL,NULL,'b0a10b2f6397488ba6aeb28dbeb54bae',NULL,NULL,NULL,NULL,'2025-12-02 10:05:55',NULL,'2025-12-02 10:05:55',NULL,NULL),(329,NULL,'310fa42f6eff4430872ddcc8b180b4de',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:55',NULL,'2025-12-02 10:05:55',NULL,NULL),(330,NULL,NULL,'e00f1fccb64f4363af02bd96c37ebc4e',NULL,NULL,NULL,NULL,'2025-12-02 10:05:55',NULL,'2025-12-02 10:05:55',NULL,NULL),(331,NULL,NULL,'e618fff2afbc46b1826338180a4aa9ff',NULL,NULL,NULL,NULL,'2025-12-02 10:05:57',NULL,'2025-12-02 10:05:57',NULL,NULL),(332,NULL,'5eccd962391a4bdb917f641809bae417',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:58',NULL,'2025-12-02 10:05:58',NULL,NULL),(333,NULL,NULL,'54969195394a44f6ba361ebae021f55f',NULL,NULL,NULL,NULL,'2025-12-02 10:05:58',NULL,'2025-12-02 10:05:58',NULL,NULL),(334,NULL,'2fc3a1247aec436fb80ef6db103c7c0d',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:58',NULL,'2025-12-02 10:05:58',NULL,NULL),(335,NULL,NULL,NULL,NULL,'c3c91107edd4417c96ac3c1336122ff3',NULL,NULL,'2025-12-02 10:05:58',NULL,'2025-12-02 10:05:58',NULL,NULL),(336,NULL,NULL,'7e05ed768f6346ecbdd5ca8352b579a9',NULL,NULL,NULL,NULL,'2025-12-02 10:05:58',NULL,'2025-12-02 10:05:58',NULL,NULL),(337,NULL,NULL,'10a5b394fb4d4865a7ba292b825f86a2',NULL,NULL,NULL,NULL,'2025-12-02 10:05:59',NULL,'2025-12-02 10:05:59',NULL,NULL),(338,NULL,NULL,'da5fd6e4e03d4fdd903976650753087f',NULL,NULL,NULL,NULL,'2025-12-02 10:05:59',NULL,'2025-12-02 10:05:59',NULL,NULL),(339,NULL,'bc99a7e88c1b433398e606bdc818c1d5',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:59',NULL,'2025-12-02 10:05:59',NULL,NULL),(340,NULL,'2f4aae76e04e4b33a8d2464a0ac94c54',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:05:59',NULL,'2025-12-02 10:05:59',NULL,NULL),(341,NULL,NULL,'845f1a0ca8a44641bf5754c8bc1e4020',NULL,NULL,NULL,NULL,'2025-12-02 10:06:00',NULL,'2025-12-02 10:06:00',NULL,NULL),(342,NULL,'53cbc156c6334cc48454465eaf3563fd',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:00',NULL,'2025-12-02 10:06:00',NULL,NULL),(343,NULL,NULL,'4e12004a0b0f43e5a9852f711e496ef7',NULL,NULL,NULL,NULL,'2025-12-02 10:06:00',NULL,'2025-12-02 10:06:00',NULL,NULL),(344,NULL,'33bdd4de6fef4b8bbd3e0c33abdb4514',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:00',NULL,'2025-12-02 10:06:00',NULL,NULL),(345,NULL,'91b4824d03bd43c4aca137037a18bd3d',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:01',NULL,'2025-12-02 10:06:01',NULL,NULL),(346,NULL,'8b161ec12f7b4d82977c40bee353d021',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:01',NULL,'2025-12-02 10:06:01',NULL,NULL),(347,NULL,NULL,'491f563f34d340e0bf27296cb80fbefb',NULL,NULL,NULL,NULL,'2025-12-02 10:06:02',NULL,'2025-12-02 10:06:02',NULL,NULL),(348,NULL,'7b3ee169d6f44a07af597c9695de9199',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:02',NULL,'2025-12-02 10:06:02',NULL,NULL),(349,NULL,'37e4f8f0e4cd48f5b7b2d1cb4c67377c',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:02',NULL,'2025-12-02 10:06:02',NULL,NULL),(350,NULL,'0b5cb1053ef048269bcff436f932ab7e',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:03',NULL,'2025-12-02 10:06:03',NULL,NULL),(351,NULL,NULL,'4e6c317f662d45be8264760dd68d767a',NULL,NULL,NULL,NULL,'2025-12-02 10:06:05',NULL,'2025-12-02 10:06:05',NULL,NULL),(352,NULL,NULL,NULL,NULL,'a5fa8280ff2045b9813b4ac0383c1953',NULL,NULL,'2025-12-02 10:06:05',NULL,'2025-12-02 10:06:05',NULL,NULL),(353,NULL,NULL,'74b1bcec2f9b496b913131daf9da8ee1',NULL,NULL,NULL,NULL,'2025-12-02 10:06:05',NULL,'2025-12-02 10:06:05',NULL,NULL),(354,NULL,NULL,'c571eda169104184971907103e064651',NULL,NULL,NULL,NULL,'2025-12-02 10:06:05',NULL,'2025-12-02 10:06:05',NULL,NULL),(355,NULL,NULL,'65e10b1e679a482a97bbbd777c830d0b',NULL,NULL,NULL,NULL,'2025-12-02 10:06:06',NULL,'2025-12-02 10:06:06',NULL,NULL),(356,NULL,NULL,'3726531ad9ff4b6fa721b329d26d6d95',NULL,NULL,NULL,NULL,'2025-12-02 10:06:06',NULL,'2025-12-02 10:06:06',NULL,NULL),(357,NULL,'76dc7354ef2d439d97965a0dce75d18a',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:06',NULL,'2025-12-02 10:06:06',NULL,NULL),(358,NULL,'cd75a7517bed456ebadfb4e9059bf843',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:06',NULL,'2025-12-02 10:06:06',NULL,NULL),(359,NULL,'cbd67585020c48a3baec0fbe57bff581',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:07',NULL,'2025-12-02 10:06:07',NULL,NULL),(360,NULL,'5dda68071bac446d88637054d0028a39',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:07',NULL,'2025-12-02 10:06:07',NULL,NULL),(361,NULL,'a81211008b8f44d89a14e18be47839d8',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:08',NULL,'2025-12-02 10:06:08',NULL,NULL),(362,NULL,NULL,'baa45857c5eb4dddb74e4bea36044d76',NULL,NULL,NULL,NULL,'2025-12-02 10:06:08',NULL,'2025-12-02 10:06:08',NULL,NULL),(363,NULL,'436aea2599b94fb9bfa9520e13d66be2',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:09',NULL,'2025-12-02 10:06:09',NULL,NULL),(364,NULL,NULL,'c1b1932b90454953843931dd2ffa67d3',NULL,NULL,NULL,NULL,'2025-12-02 10:06:09',NULL,'2025-12-02 10:06:09',NULL,NULL),(365,NULL,NULL,'48046ae0921140eebe8d906be24b33e6',NULL,NULL,NULL,NULL,'2025-12-02 10:06:09',NULL,'2025-12-02 10:06:09',NULL,NULL),(366,NULL,NULL,'76e1f7ecc1294ec8ab48a1ac62eee72f',NULL,NULL,NULL,NULL,'2025-12-02 10:06:10',NULL,'2025-12-02 10:06:10',NULL,NULL),(367,NULL,'e67f66bf0f2a41a6a6bd55b81b8defe7',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:10',NULL,'2025-12-02 10:06:10',NULL,NULL),(368,NULL,'4e798a5df78944059a643a8afa8f92bb',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:10',NULL,'2025-12-02 10:06:10',NULL,NULL),(369,NULL,NULL,'d7aad17b7c2a42d9b27fea2e4f9bb331',NULL,NULL,NULL,NULL,'2025-12-02 10:06:10',NULL,'2025-12-02 10:06:10',NULL,NULL),(370,NULL,'cdd6a678868c4436a6b27275f33f6776',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:11',NULL,'2025-12-02 10:06:11',NULL,NULL),(371,NULL,'2e2da4f5220e4c5887cba01bd1ab2159',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:11',NULL,'2025-12-02 10:06:11',NULL,NULL),(372,NULL,'24d8c0210439476bb02b83caf049f8b7',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:11',NULL,'2025-12-02 10:06:11',NULL,NULL),(373,NULL,'9683bb129ff94d8a95cad6b147d5d97f',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:12',NULL,'2025-12-02 10:06:12',NULL,NULL),(374,NULL,'4fcd13427aef47a1b88eedd30e9d0cbf',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:12',NULL,'2025-12-02 10:06:12',NULL,NULL),(375,NULL,'647d8d2b7e78449aa3bfff5013751a10',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:12',NULL,'2025-12-02 10:06:12',NULL,NULL),(376,NULL,'578f50d3973843b8b67a1eb65c71964c',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:13',NULL,'2025-12-02 10:06:13',NULL,NULL),(377,NULL,'a2ed95f7641e405b84704f1d598e8ff3',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:13',NULL,'2025-12-02 10:06:13',NULL,NULL),(378,NULL,NULL,'aee23123024a4618862320bc5cacab57',NULL,NULL,NULL,NULL,'2025-12-02 10:06:14',NULL,'2025-12-02 10:06:14',NULL,NULL),(379,NULL,'1823b50d379f46fea4182df5ee06a567',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:14',NULL,'2025-12-02 10:06:14',NULL,NULL),(380,NULL,NULL,'c0d8ceb99dc445c2b3c00336cb34ea83',NULL,NULL,NULL,NULL,'2025-12-02 10:06:14',NULL,'2025-12-02 10:06:14',NULL,NULL),(381,NULL,'c9387e662a0c4ba1be808791a3675bb6',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:14',NULL,'2025-12-02 10:06:14',NULL,NULL),(382,NULL,NULL,NULL,NULL,'8824c8057bcd44d49d3be39938b3ebb1',NULL,NULL,'2025-12-02 10:06:14',NULL,'2025-12-02 10:06:14',NULL,NULL),(383,NULL,'0d65e1a5b19e48a4afe30edfdc158090',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:14',NULL,'2025-12-02 10:06:14',NULL,NULL),(384,NULL,NULL,'1739ecfdbeb34658a3be8ba7c66cb871',NULL,NULL,NULL,NULL,'2025-12-02 10:06:15',NULL,'2025-12-02 10:06:15',NULL,NULL),(385,NULL,'7d6fa7fc9e824615970965797f5b8390',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:15',NULL,'2025-12-02 10:06:15',NULL,NULL),(386,NULL,'a6582eb419984c62a423f3cf78b4efb0',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:15',NULL,'2025-12-02 10:06:15',NULL,NULL),(387,NULL,'375e86122c624b539d56d9f09b497984',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:15',NULL,'2025-12-02 10:06:15',NULL,NULL),(388,NULL,'f763eb756fcf4c76931e1fddab24d684',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:16',NULL,'2025-12-02 10:06:16',NULL,NULL),(389,NULL,'f97ced8adcba42659b6a36433329935e',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:16',NULL,'2025-12-02 10:06:16',NULL,NULL),(390,NULL,'1b681f706c504891a55502dbdb3ed4f2',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:16',NULL,'2025-12-02 10:06:16',NULL,NULL),(391,NULL,NULL,'de46e90d11d84c2a8785f80750f90a5e',NULL,NULL,NULL,NULL,'2025-12-02 10:06:17',NULL,'2025-12-02 10:06:17',NULL,NULL),(392,NULL,NULL,'71f8f333ed5e4d6799505c989af1efca',NULL,NULL,NULL,NULL,'2025-12-02 10:06:17',NULL,'2025-12-02 10:06:17',NULL,NULL),(393,NULL,'47dfddef6d73452d90f508730c530679',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:17',NULL,'2025-12-02 10:06:17',NULL,NULL),(394,NULL,NULL,NULL,NULL,'ccf463f97396408e8f588d32aa4e9bd9',NULL,NULL,'2025-12-02 10:06:17',NULL,'2025-12-02 10:06:17',NULL,NULL),(395,NULL,'3ad9653165ca4bf1b707435a51ba4dbc',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:17',NULL,'2025-12-02 10:06:17',NULL,NULL),(396,NULL,'c57502deacf243ccb0b73f3a85edd4ca',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:17',NULL,'2025-12-02 10:06:17',NULL,NULL),(397,NULL,NULL,'0af649d4b9614dd5a2bddd1235fa362b',NULL,NULL,NULL,NULL,'2025-12-02 10:06:17',NULL,'2025-12-02 10:06:17',NULL,NULL),(398,NULL,NULL,'07e8b8b380b44de1bc08a311f30e4dd1',NULL,NULL,NULL,NULL,'2025-12-02 10:06:17',NULL,'2025-12-02 10:06:17',NULL,NULL),(399,NULL,'35343b61d351454187ca1c8e2f0edc6e',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:18',NULL,'2025-12-02 10:06:18',NULL,NULL),(400,NULL,NULL,'786ec5d2ee3242558a25ac770e8eed9a',NULL,NULL,NULL,NULL,'2025-12-02 10:06:18',NULL,'2025-12-02 10:06:18',NULL,NULL),(401,NULL,NULL,'b1f2d7e7e285484f892a60f5242b6406',NULL,NULL,NULL,NULL,'2025-12-02 10:06:18',NULL,'2025-12-02 10:06:18',NULL,NULL),(402,NULL,'b672e251df5c4bc5ad999ba227f39fb5',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:18',NULL,'2025-12-02 10:06:18',NULL,NULL),(403,NULL,NULL,'89171c6dba8f4024988071a7a35aae24',NULL,NULL,NULL,NULL,'2025-12-02 10:06:18',NULL,'2025-12-02 10:06:18',NULL,NULL),(404,NULL,NULL,'d2574781b58f48e4bc65f4ddda1efc23',NULL,NULL,NULL,NULL,'2025-12-02 10:06:18',NULL,'2025-12-02 10:06:18',NULL,NULL),(405,NULL,'4ae019f3db6248368641f9ff9e7acce4',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:18',NULL,'2025-12-02 10:06:18',NULL,NULL),(406,NULL,'64d695fed94a4729bd4a715858ba9402',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:19',NULL,'2025-12-02 10:06:19',NULL,NULL),(407,NULL,'66a3711d61a94fad96643819eb16538a',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:19',NULL,'2025-12-02 10:06:19',NULL,NULL),(408,NULL,NULL,'e6f97ef89976422db171867e1c0c59f0',NULL,NULL,NULL,NULL,'2025-12-02 10:06:20',NULL,'2025-12-02 10:06:20',NULL,NULL),(409,NULL,NULL,'5993215748194a3587d2c6102e29e1e3',NULL,NULL,NULL,NULL,'2025-12-02 10:06:20',NULL,'2025-12-02 10:06:20',NULL,NULL),(410,NULL,'f5c5c7bba1c14695ae96dadd0fe5bbce',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:20',NULL,'2025-12-02 10:06:20',NULL,NULL),(411,NULL,NULL,'d5ece33927c74ce2b274bfeb6b6847e6',NULL,NULL,NULL,NULL,'2025-12-02 10:06:20',NULL,'2025-12-02 10:06:20',NULL,NULL),(412,NULL,'adcdf997ff504dac98e72f2fcb4a00b6',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:21',NULL,'2025-12-02 10:06:21',NULL,NULL),(413,NULL,'b1dd069609ce442781de6ad31f711b9b',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:21',NULL,'2025-12-02 10:06:21',NULL,NULL),(414,NULL,'b1273a829a21431083b7acd4fe017c0f',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:21',NULL,'2025-12-02 10:06:21',NULL,NULL),(415,NULL,'3f0966ca3eec4301b9d84b4543ff9fdf',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:21',NULL,'2025-12-02 10:06:21',NULL,NULL),(416,NULL,'0eefc3aad988475baad7638a7de97891',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:22',NULL,'2025-12-02 10:06:22',NULL,NULL),(417,NULL,NULL,'54492d277e644a15ba167f011d09a2f2',NULL,NULL,NULL,NULL,'2025-12-02 10:06:22',NULL,'2025-12-02 10:06:22',NULL,NULL),(418,NULL,NULL,'8350791dd6284c1ab82c1a9488832104',NULL,NULL,NULL,NULL,'2025-12-02 10:06:22',NULL,'2025-12-02 10:06:22',NULL,NULL),(419,NULL,NULL,'25c00855bbd545e0b7339df657c29f1a',NULL,NULL,NULL,NULL,'2025-12-02 10:06:24',NULL,'2025-12-02 10:06:24',NULL,NULL),(420,NULL,'d75473d7d5724122b4ed56838ba465a7',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:24',NULL,'2025-12-02 10:06:24',NULL,NULL),(421,NULL,NULL,'750197368d4c499ca5b512afcd3343cf',NULL,NULL,NULL,NULL,'2025-12-02 10:06:24',NULL,'2025-12-02 10:06:24',NULL,NULL),(422,NULL,'82bf528242db4720802bd0c9e0015a9a',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:25',NULL,'2025-12-02 10:06:25',NULL,NULL),(423,NULL,'55fdd41a916540739bb5973a9bdafc86',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:26',NULL,'2025-12-02 10:06:26',NULL,NULL),(424,NULL,'60a54b4c6030425bb298d1310a5695c7',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:27',NULL,'2025-12-02 10:06:27',NULL,NULL),(425,NULL,NULL,'e634ac4734ed4327890b1cf24dcd42b4',NULL,NULL,NULL,NULL,'2025-12-02 10:06:27',NULL,'2025-12-02 10:06:27',NULL,NULL),(426,NULL,NULL,'fb0e0ae61359414b9e736fe7fdae5531',NULL,NULL,NULL,NULL,'2025-12-02 10:06:27',NULL,'2025-12-02 10:06:27',NULL,NULL),(427,NULL,NULL,'7425560dd7f84f3d95e164669b57683e',NULL,NULL,NULL,NULL,'2025-12-02 10:06:27',NULL,'2025-12-02 10:06:27',NULL,NULL),(428,NULL,'e75829739bf74742845a5320cf803807',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:27',NULL,'2025-12-02 10:06:27',NULL,NULL),(429,NULL,NULL,'7425560dd7f84f3d95e164669b57683e',NULL,NULL,NULL,NULL,'2025-12-02 10:06:28',NULL,'2025-12-02 10:06:28',NULL,NULL),(430,NULL,'984d43aa02144fca961d1629ce3c4f8f',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:28',NULL,'2025-12-02 10:06:28',NULL,NULL),(431,NULL,NULL,'78860ad6cf384db8a99eb7e3c1f27fe5',NULL,NULL,NULL,NULL,'2025-12-02 10:06:28',NULL,'2025-12-02 10:06:28',NULL,NULL),(432,NULL,NULL,'9389f66b74f94fb8a4ecdf1101f1be23',NULL,NULL,NULL,NULL,'2025-12-02 10:06:28',NULL,'2025-12-02 10:06:28',NULL,NULL),(433,NULL,NULL,'34d014634d0d42a297384613f84194b5',NULL,NULL,NULL,NULL,'2025-12-02 10:06:28',NULL,'2025-12-02 10:06:28',NULL,NULL),(434,NULL,NULL,'60855f88902c4b9292ead9f7fdd43283',NULL,NULL,NULL,NULL,'2025-12-02 10:06:28',NULL,'2025-12-02 10:06:28',NULL,NULL),(435,NULL,'1118d2f731444abcb9e19d907a801b3e',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:28',NULL,'2025-12-02 10:06:28',NULL,NULL),(436,NULL,'1ebcd19bdfca48b3927990f465f87666',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:29',NULL,'2025-12-02 10:06:29',NULL,NULL),(437,NULL,'07b7dc39d3334cc69f843f8612fac064',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:29',NULL,'2025-12-02 10:06:29',NULL,NULL),(438,NULL,NULL,'af5f14f8090049738703c9a9d3b4e588',NULL,NULL,NULL,NULL,'2025-12-02 10:06:29',NULL,'2025-12-02 10:06:29',NULL,NULL),(439,NULL,NULL,'268a135f99bb4f2aa38f9b9aa8245be1',NULL,NULL,NULL,NULL,'2025-12-02 10:06:29',NULL,'2025-12-02 10:06:29',NULL,NULL),(440,NULL,'0d5d488ed21145b59edbd4f5f26de49b',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:30',NULL,'2025-12-02 10:06:30',NULL,NULL),(441,NULL,'bf06abbe7cc2424cb3e1e9893ff53ce6',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:30',NULL,'2025-12-02 10:06:30',NULL,NULL),(442,NULL,'f7f68bf81c684b16899acbb258e0af86',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:30',NULL,'2025-12-02 10:06:30',NULL,NULL),(443,NULL,NULL,'86307657f1534c1cb4f57fffa86c4dbe',NULL,NULL,NULL,NULL,'2025-12-02 10:06:31',NULL,'2025-12-02 10:06:31',NULL,NULL),(444,NULL,NULL,'f7f6d7cda3b742bead5c2c113e6711ea',NULL,NULL,NULL,NULL,'2025-12-02 10:06:32',NULL,'2025-12-02 10:06:32',NULL,NULL),(445,NULL,'3f0c5ab398744c2eae497445c508b51e',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:32',NULL,'2025-12-02 10:06:32',NULL,NULL),(446,NULL,'775ece2ed8e54a19872ee9d10e113048',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:32',NULL,'2025-12-02 10:06:32',NULL,NULL),(447,NULL,'36336a565214410ca32205584d7a6cfe',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:32',NULL,'2025-12-02 10:06:32',NULL,NULL),(448,NULL,NULL,'7c1f85a48a0842408bf0c15d176bbe24',NULL,NULL,NULL,NULL,'2025-12-02 10:06:33',NULL,'2025-12-02 10:06:33',NULL,NULL),(449,NULL,NULL,'73c9cce316d345399e0b4dcc489eefc4',NULL,NULL,NULL,NULL,'2025-12-02 10:06:33',NULL,'2025-12-02 10:06:33',NULL,NULL),(450,NULL,'d3133698889b4002be3cfb1a01c27aae',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:34',NULL,'2025-12-02 10:06:34',NULL,NULL),(451,NULL,'47979087e58c446d850c66c672327f74',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:34',NULL,'2025-12-02 10:06:34',NULL,NULL),(452,NULL,'6687b65ec9c84d27a2a68b98c0a2eacd',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:36',NULL,'2025-12-02 10:06:36',NULL,NULL),(453,NULL,'39d049b7ae3640b1bc36845add7b4021',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:36',NULL,'2025-12-02 10:06:36',NULL,NULL),(454,NULL,'66f8f0f1f2f64f47a261600d6a743ec7',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:37',NULL,'2025-12-02 10:06:37',NULL,NULL),(455,NULL,NULL,'74c67ece3aa243fe8a135e79f0f8613d',NULL,NULL,NULL,NULL,'2025-12-02 10:06:38',NULL,'2025-12-02 10:06:38',NULL,NULL),(456,NULL,NULL,'1200e53531b6436ca79d4f7b2de7b3ec',NULL,NULL,NULL,NULL,'2025-12-02 10:06:39',NULL,'2025-12-02 10:06:39',NULL,NULL),(457,NULL,NULL,'e521419454fa4d24936013df868bb29f',NULL,NULL,NULL,NULL,'2025-12-02 10:06:41',NULL,'2025-12-02 10:06:41',NULL,NULL),(458,NULL,NULL,'ed3b4dffeb0d4a4f93cbf0470d2fba06',NULL,NULL,NULL,NULL,'2025-12-02 10:06:42',NULL,'2025-12-02 10:06:42',NULL,NULL),(459,NULL,'fab2ccc5b62e4e66b55124adac956d33',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:42',NULL,'2025-12-02 10:06:42',NULL,NULL),(460,NULL,NULL,'fafe846606fc4d3ba2ada06df433670c',NULL,NULL,NULL,NULL,'2025-12-02 10:06:42',NULL,'2025-12-02 10:06:42',NULL,NULL),(461,NULL,NULL,'5a1f014fc0bd41aaa78f27d1a224f0cf',NULL,NULL,NULL,NULL,'2025-12-02 10:06:43',NULL,'2025-12-02 10:06:43',NULL,NULL),(462,NULL,'1512807ff8de4caaab2cbe4666784e7d',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:45',NULL,'2025-12-02 10:06:45',NULL,NULL),(463,NULL,'e8385b8ef82842ef927f445619493680',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:45',NULL,'2025-12-02 10:06:45',NULL,NULL),(464,NULL,'b873dc0ce4024487b9df7c0d8074414e',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:45',NULL,'2025-12-02 10:06:45',NULL,NULL),(465,NULL,'d964802e5e1b4ba787417a4a6e090239',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:45',NULL,'2025-12-02 10:06:45',NULL,NULL),(466,NULL,NULL,'b233d900091a48d49286f8d8690e8851',NULL,NULL,NULL,NULL,'2025-12-02 10:06:46',NULL,'2025-12-02 10:06:46',NULL,NULL),(467,NULL,'7bb198eabf0949f892dcfc783af2319e',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:47',NULL,'2025-12-02 10:06:47',NULL,NULL),(468,NULL,'0fb0fe5f66424978838a88f4b369a1f3',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:48',NULL,'2025-12-02 10:06:48',NULL,NULL),(469,NULL,NULL,'61a6a019470b49f9bff7fd6ca6c8d330',NULL,NULL,NULL,NULL,'2025-12-02 10:06:49',NULL,'2025-12-02 10:06:49',NULL,NULL),(470,NULL,'4375c13984ab45c28b6c5c0320c0ae6c',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:50',NULL,'2025-12-02 10:06:50',NULL,NULL),(471,NULL,NULL,'12c4e293dc8244c28311446815a815b1',NULL,NULL,NULL,NULL,'2025-12-02 10:06:50',NULL,'2025-12-02 10:06:50',NULL,NULL),(472,NULL,NULL,'d3b64a4f7fca4b9ca4b92342a3bb5c85',NULL,NULL,NULL,NULL,'2025-12-02 10:06:51',NULL,'2025-12-02 10:06:51',NULL,NULL),(473,NULL,NULL,'343abc7e919f4b8f9b214e2fe67ddea5',NULL,NULL,NULL,NULL,'2025-12-02 10:06:51',NULL,'2025-12-02 10:06:51',NULL,NULL),(474,NULL,NULL,'30a055b1f45445d08ce1ab479d10430e',NULL,NULL,NULL,NULL,'2025-12-02 10:06:51',NULL,'2025-12-02 10:06:51',NULL,NULL),(475,NULL,NULL,'b082f2b1871c437480a45c1b593644ff',NULL,NULL,NULL,NULL,'2025-12-02 10:06:51',NULL,'2025-12-02 10:06:51',NULL,NULL),(476,NULL,'82b8cc3ef9444b8b8dca5b3be421b9c9',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:53',NULL,'2025-12-02 10:06:53',NULL,NULL),(477,NULL,NULL,'96abea023ff54501a41120f0a8d62aee',NULL,NULL,NULL,NULL,'2025-12-02 10:06:53',NULL,'2025-12-02 10:06:53',NULL,NULL),(478,NULL,'524cb9f784ac426797cf4ed656766fc6',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:53',NULL,'2025-12-02 10:06:53',NULL,NULL),(479,NULL,NULL,'8e6a54957b83431680d67f523601f8f8',NULL,NULL,NULL,NULL,'2025-12-02 10:06:53',NULL,'2025-12-02 10:06:53',NULL,NULL),(480,NULL,'7415a5c93cb44689a5f059192fab2a00',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:53',NULL,'2025-12-02 10:06:53',NULL,NULL),(481,NULL,'f6ba561268dc4438b22d55a395cc908b',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:54',NULL,'2025-12-02 10:06:54',NULL,NULL),(482,NULL,'c2475b61ca784afebd61f3486813ae95',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:54',NULL,'2025-12-02 10:06:54',NULL,NULL),(483,NULL,'30cc29aeac104686ac82e384ab72bb31',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:54',NULL,'2025-12-02 10:06:54',NULL,NULL),(484,NULL,'86547b506914419294bf5089a17c1821',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:55',NULL,'2025-12-02 10:06:55',NULL,NULL),(485,NULL,NULL,'0a2a081ae1c6464ea55762a207e66145',NULL,NULL,NULL,NULL,'2025-12-02 10:06:56',NULL,'2025-12-02 10:06:56',NULL,NULL),(486,NULL,NULL,'5c00d809667e415b992eaa2edca9e658',NULL,NULL,NULL,NULL,'2025-12-02 10:06:56',NULL,'2025-12-02 10:06:56',NULL,NULL),(487,NULL,NULL,'65cf01c8d0e746e9974cfbf208c6ca7e',NULL,NULL,NULL,NULL,'2025-12-02 10:06:58',NULL,'2025-12-02 10:06:58',NULL,NULL),(488,NULL,'0be88e0bacc74023a71c648b2ffd76df',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:58',NULL,'2025-12-02 10:06:58',NULL,NULL),(489,NULL,NULL,'696ad8233f2e4505ac3c6917b18737ba',NULL,NULL,NULL,NULL,'2025-12-02 10:06:58',NULL,'2025-12-02 10:06:58',NULL,NULL),(490,NULL,NULL,'c00411d6591242d083be44a1b69d78bb',NULL,NULL,NULL,NULL,'2025-12-02 10:06:59',NULL,'2025-12-02 10:06:59',NULL,NULL),(491,NULL,'7f13679661b54e1ebd2c8fc275ed2ee3',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:06:59',NULL,'2025-12-02 10:06:59',NULL,NULL),(492,NULL,NULL,'d293a7b559124e18a75a4e5a54e93f00',NULL,NULL,NULL,NULL,'2025-12-02 10:06:59',NULL,'2025-12-02 10:06:59',NULL,NULL),(493,NULL,'27d646d13f114e61802b309b16ac455a',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:00',NULL,'2025-12-02 10:07:00',NULL,NULL),(494,NULL,NULL,'e1b87afe280745b19ba08ce3d10d41d2',NULL,NULL,NULL,NULL,'2025-12-02 10:07:02',NULL,'2025-12-02 10:07:02',NULL,NULL),(495,NULL,'68963b5bdacc408aa9adc69ff150d3f8',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:02',NULL,'2025-12-02 10:07:02',NULL,NULL),(496,NULL,NULL,'c83ee4a6eea74904a2af264675b72fb5',NULL,NULL,NULL,NULL,'2025-12-02 10:07:02',NULL,'2025-12-02 10:07:02',NULL,NULL),(497,NULL,NULL,'a2a168afc6c045d091d78eec6e003e32',NULL,NULL,NULL,NULL,'2025-12-02 10:07:02',NULL,'2025-12-02 10:07:02',NULL,NULL),(498,NULL,'4df4e32493bd40288350093e04e297a9',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:02',NULL,'2025-12-02 10:07:02',NULL,NULL),(499,NULL,NULL,'ea017f400a9442898776908874aaedd1',NULL,NULL,NULL,NULL,'2025-12-02 10:07:03',NULL,'2025-12-02 10:07:03',NULL,NULL),(500,NULL,'56875671962b4d1fb0ab6265ba45bca5',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:03',NULL,'2025-12-02 10:07:03',NULL,NULL),(501,NULL,NULL,'09b8a8c63ee9419dbe822d3c92a21379',NULL,NULL,NULL,NULL,'2025-12-02 10:07:04',NULL,'2025-12-02 10:07:04',NULL,NULL),(502,NULL,'263690435289469b82aeaa9a00c182dd',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:05',NULL,'2025-12-02 10:07:05',NULL,NULL),(503,NULL,'02e4c239e403410d92ff8793a3f16b98',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:05',NULL,'2025-12-02 10:07:05',NULL,NULL),(504,NULL,'bee8db4093d246cc8bc2391bf827d4ac',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:06',NULL,'2025-12-02 10:07:06',NULL,NULL),(505,NULL,'93cbc84f3b374d8592d29eca784ad573',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:07',NULL,'2025-12-02 10:07:07',NULL,NULL),(506,NULL,NULL,'935aa55c78044f4f87039951dc87cd62',NULL,NULL,NULL,NULL,'2025-12-02 10:07:07',NULL,'2025-12-02 10:07:07',NULL,NULL),(507,NULL,NULL,'39ac23db08db4b5b981bf56813fe3813',NULL,NULL,NULL,NULL,'2025-12-02 10:07:07',NULL,'2025-12-02 10:07:07',NULL,NULL),(508,NULL,NULL,'3b07001f25e14f5baf3dddd0f3637fed',NULL,NULL,NULL,NULL,'2025-12-02 10:07:08',NULL,'2025-12-02 10:07:08',NULL,NULL),(509,NULL,'eba5bcf78917466897ed8b0e11688a76',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:08',NULL,'2025-12-02 10:07:08',NULL,NULL),(510,NULL,'7267e922f3cc4920b975a280c5fd1c50',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:08',NULL,'2025-12-02 10:07:08',NULL,NULL),(511,NULL,'6f146e0fa2b9426199946be10fb7d352',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:10',NULL,'2025-12-02 10:07:10',NULL,NULL),(512,NULL,'8f5d6551522f4bc3bd8acbb1a46a7b2e',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:10',NULL,'2025-12-02 10:07:10',NULL,NULL),(513,NULL,NULL,'1896529336bd4bc3a6d36c782b0e76f5',NULL,NULL,NULL,NULL,'2025-12-02 10:07:11',NULL,'2025-12-02 10:07:11',NULL,NULL),(514,NULL,'1e139fe20a514d12b866b3c8974dcebd',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:11',NULL,'2025-12-02 10:07:11',NULL,NULL),(515,NULL,NULL,'2aab319179554101a7fadb56852e91bf',NULL,NULL,NULL,NULL,'2025-12-02 10:07:11',NULL,'2025-12-02 10:07:11',NULL,NULL),(516,NULL,NULL,'f3434aa161cb43d0ae9b4cfefe7e4006',NULL,NULL,NULL,NULL,'2025-12-02 10:07:12',NULL,'2025-12-02 10:07:12',NULL,NULL),(517,NULL,'6e25d7b06e3a4d9485eff63d2a8d7bad',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:13',NULL,'2025-12-02 10:07:13',NULL,NULL),(518,NULL,'210ea29170374549a19f9dd9e8d8b7c2',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:13',NULL,'2025-12-02 10:07:13',NULL,NULL),(519,NULL,'21d4d3b48096450197194eed29ad68df',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:14',NULL,'2025-12-02 10:07:14',NULL,NULL),(520,NULL,NULL,'d9bb9ad734364538b8fcf151aecf9130',NULL,NULL,NULL,NULL,'2025-12-02 10:07:14',NULL,'2025-12-02 10:07:14',NULL,NULL),(521,NULL,NULL,'8de269e77e284c979f45fb2c8875fbb6',NULL,NULL,NULL,NULL,'2025-12-02 10:07:14',NULL,'2025-12-02 10:07:14',NULL,NULL),(522,NULL,NULL,'65cf01c8d0e746e9974cfbf208c6ca7e',NULL,NULL,NULL,NULL,'2025-12-02 10:07:15',NULL,'2025-12-02 10:07:15',NULL,NULL),(523,NULL,'035dbdef08594e538c792b4947246a9a',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:16',NULL,'2025-12-02 10:07:16',NULL,NULL),(524,NULL,'e193d10bc5b546e7879f886379f90257',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:16',NULL,'2025-12-02 10:07:16',NULL,NULL),(525,NULL,'a6b5611dfaf74bd6acb74409fbb93c8f',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:16',NULL,'2025-12-02 10:07:16',NULL,NULL),(526,NULL,'e1bfe489dc11446ea2d7f935e7dd831a',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:17',NULL,'2025-12-02 10:07:17',NULL,NULL),(527,NULL,'8d1fd67e3cbd42f89f4f5888349c6d79',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:17',NULL,'2025-12-02 10:07:17',NULL,NULL),(528,NULL,NULL,'e13e4ca6825449b7864f390eb3c8aefc',NULL,NULL,NULL,NULL,'2025-12-02 10:07:18',NULL,'2025-12-02 10:07:18',NULL,NULL),(529,NULL,NULL,'c8984c8ad730454ba8118fb7f7b876e3',NULL,NULL,NULL,NULL,'2025-12-02 10:07:18',NULL,'2025-12-02 10:07:18',NULL,NULL),(530,NULL,NULL,'4133138d1b314affbd6cc45306862ae6',NULL,NULL,NULL,NULL,'2025-12-02 10:07:18',NULL,'2025-12-02 10:07:18',NULL,NULL),(531,NULL,'d31b29e0d09d4e0aa3ca09f0b1338ab3',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:20',NULL,'2025-12-02 10:07:20',NULL,NULL),(532,NULL,'de63e19e37074b9b84b7bff8031d8a91',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:20',NULL,'2025-12-02 10:07:20',NULL,NULL),(533,NULL,NULL,'4eb03c2af7a8403298d36f5a32c0c024',NULL,NULL,NULL,NULL,'2025-12-02 10:07:21',NULL,'2025-12-02 10:07:21',NULL,NULL),(534,NULL,NULL,'1d587ba030de470181b54639ded7e79a',NULL,NULL,NULL,NULL,'2025-12-02 10:07:21',NULL,'2025-12-02 10:07:21',NULL,NULL),(535,NULL,NULL,'9e5a83d262e241f38da1297f56ccca42',NULL,NULL,NULL,NULL,'2025-12-02 10:07:22',NULL,'2025-12-02 10:07:22',NULL,NULL),(536,NULL,'a54cbc606e7e41d38dbd48293224dc15',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:22',NULL,'2025-12-02 10:07:22',NULL,NULL),(537,NULL,NULL,'f6abbbfcc7d54e81b5693b2401a25e09',NULL,NULL,NULL,NULL,'2025-12-02 10:07:22',NULL,'2025-12-02 10:07:22',NULL,NULL),(538,NULL,'ab909474aeca4797becf1a641e09278f',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:25',NULL,'2025-12-02 10:07:25',NULL,NULL),(539,NULL,NULL,'a3aa352191934425bd3be9630b0be7e6',NULL,NULL,NULL,NULL,'2025-12-02 10:07:25',NULL,'2025-12-02 10:07:25',NULL,NULL),(540,NULL,'ef69e828801540619536106b3b481b20',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:26',NULL,'2025-12-02 10:07:26',NULL,NULL),(541,NULL,'5ea39db037534e2087a54e8a052ad24e',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:26',NULL,'2025-12-02 10:07:26',NULL,NULL),(542,NULL,'ce9444d57e5841cea19bb94bba07e46e',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:28',NULL,'2025-12-02 10:07:28',NULL,NULL),(543,NULL,'04f9e5ec692641d383e547f9c5ca0a2b',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:28',NULL,'2025-12-02 10:07:28',NULL,NULL),(544,NULL,NULL,'2c367119f5ca43d19076cdd859090a86',NULL,NULL,NULL,NULL,'2025-12-02 10:07:29',NULL,'2025-12-02 10:07:29',NULL,NULL),(545,NULL,NULL,'b32b6dd18e034edfa3777a6f7a1be8bf',NULL,NULL,NULL,NULL,'2025-12-02 10:07:29',NULL,'2025-12-02 10:07:29',NULL,NULL),(546,NULL,NULL,'7efc75a1ebac4e04a81df2c38c67b445',NULL,NULL,NULL,NULL,'2025-12-02 10:07:29',NULL,'2025-12-02 10:07:29',NULL,NULL),(547,NULL,NULL,'4e1c404696ac4edfb12df185b2a69c85',NULL,NULL,NULL,NULL,'2025-12-02 10:07:29',NULL,'2025-12-02 10:07:29',NULL,NULL),(548,NULL,'2706a6a47b93479cac8cccaa7c67de99',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:31',NULL,'2025-12-02 10:07:31',NULL,NULL),(549,NULL,'03e73d1c3449434faf70217c7f546eee',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:32',NULL,'2025-12-02 10:07:32',NULL,NULL),(550,NULL,NULL,'4e1c404696ac4edfb12df185b2a69c85',NULL,NULL,NULL,NULL,'2025-12-02 10:07:32',NULL,'2025-12-02 10:07:32',NULL,NULL),(551,NULL,'0b653a646646443fb63c182185aa7dfe',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:33',NULL,'2025-12-02 10:07:33',NULL,NULL),(552,NULL,'0b96bacd92de4f1aa310d96b02e2ba1b',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:33',NULL,'2025-12-02 10:07:33',NULL,NULL),(553,NULL,'d55d513978894568a17b06c7cc2801a8',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:34',NULL,'2025-12-02 10:07:34',NULL,NULL),(554,NULL,NULL,'56b703c31a1746c8858d667410f53189',NULL,NULL,NULL,NULL,'2025-12-02 10:07:36',NULL,'2025-12-02 10:07:36',NULL,NULL),(555,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:36',NULL,'2025-12-02 10:07:36','ESwUkwLPSqmN4q3VqvDrzg',NULL),(556,NULL,NULL,'bd8a75b2aca14881b7ab27bb4a5a89b6',NULL,NULL,NULL,NULL,'2025-12-02 10:07:36',NULL,'2025-12-02 10:07:36',NULL,NULL),(557,NULL,'00428a58903e487bb33ddf74c19e4f17',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:36',NULL,'2025-12-02 10:07:36',NULL,NULL),(558,NULL,'b09178575a2a45fcbe0612227a81a79f',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:36',NULL,'2025-12-02 10:07:36',NULL,NULL),(559,NULL,'6a242f41e2844024a9eb8e3248bed732',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:36',NULL,'2025-12-02 10:07:36',NULL,NULL),(560,NULL,NULL,'cd0390b9c70c4d328fd7ff0ace51a08e',NULL,NULL,NULL,NULL,'2025-12-02 10:07:37',NULL,'2025-12-02 10:07:37',NULL,NULL),(561,NULL,NULL,'b71be23591304f0189ef1be8636c18e8',NULL,NULL,NULL,NULL,'2025-12-02 10:07:37',NULL,'2025-12-02 10:07:37',NULL,NULL),(562,NULL,NULL,'76c216de70c042adb7fe906ffeb8a95c',NULL,NULL,NULL,NULL,'2025-12-02 10:07:37',NULL,'2025-12-02 10:07:37',NULL,NULL),(563,NULL,NULL,'4e1c404696ac4edfb12df185b2a69c85',NULL,NULL,NULL,NULL,'2025-12-02 10:07:38',NULL,'2025-12-02 10:07:38',NULL,NULL),(564,NULL,'59f91ce2d7d24af392ce4f7fd4bb32ba',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:38',NULL,'2025-12-02 10:07:38',NULL,NULL),(565,NULL,'7e31c84f344b4a809058d88fb72e8750',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:39',NULL,'2025-12-02 10:07:39',NULL,NULL),(566,NULL,'317db846d61a436aa7715f183fc4cbec',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:40',NULL,'2025-12-02 10:07:40',NULL,NULL),(567,NULL,'42538761f9f84e7684580411ccae9cb6',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:41',NULL,'2025-12-02 10:07:41',NULL,NULL),(568,NULL,'9df1e0e63e4d4bcfba7f065db2a8425b',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:42',NULL,'2025-12-02 10:07:42',NULL,NULL),(569,NULL,'bd7b118dde244dca8cf2c4d3c99e18d4',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:45',NULL,'2025-12-02 10:07:45',NULL,NULL),(570,NULL,NULL,'fff2f3f935e6413692b8e1ef74579266',NULL,NULL,NULL,NULL,'2025-12-02 10:07:45',NULL,'2025-12-02 10:07:45',NULL,NULL),(571,NULL,NULL,'ec83e408f7d7414e92c6b3bfc05d28f5',NULL,NULL,NULL,NULL,'2025-12-02 10:07:45',NULL,'2025-12-02 10:07:45',NULL,NULL),(572,NULL,NULL,'ff0714e14b14401180407084be1a3e51',NULL,NULL,NULL,NULL,'2025-12-02 10:07:46',NULL,'2025-12-02 10:07:46',NULL,NULL),(573,NULL,NULL,'accd862ff56c43ef80d1eb8498e37e76',NULL,NULL,NULL,NULL,'2025-12-02 10:07:46',NULL,'2025-12-02 10:07:46',NULL,NULL),(574,NULL,'83fc6838bd4043e4967bae0d4d81de4b',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:47',NULL,'2025-12-02 10:07:47',NULL,NULL),(575,NULL,NULL,'67bcddbff949487da825af635bf93024',NULL,NULL,NULL,NULL,'2025-12-02 10:07:47',NULL,'2025-12-02 10:07:47',NULL,NULL),(576,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:48',NULL,'2025-12-02 10:07:48','H3oS8vvxSfWQB8H-Nj2uNQ',NULL),(577,NULL,'6650751b85fe48f08b5f9c57acae161f',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:48',NULL,'2025-12-02 10:07:48',NULL,NULL),(578,NULL,'013aba22c9624366b68dbe5b619bf819',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:48',NULL,'2025-12-02 10:07:48',NULL,NULL),(579,NULL,NULL,'71c1ab73f6584cdc8a5ac07abc1165b6',NULL,NULL,NULL,NULL,'2025-12-02 10:07:48',NULL,'2025-12-02 10:07:48',NULL,NULL),(580,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:49',NULL,'2025-12-02 10:07:49','ITkjbpxFRDO1mpMAy_lImg',NULL),(581,NULL,NULL,'8533a64ac88a40e0874be8a3d678319b',NULL,NULL,NULL,NULL,'2025-12-02 10:07:49',NULL,'2025-12-02 10:07:49',NULL,NULL),(582,NULL,NULL,'c695c8d7887d4f5d99397fbd9a108bd7',NULL,NULL,NULL,NULL,'2025-12-02 10:07:49',NULL,'2025-12-02 10:07:49',NULL,NULL),(583,NULL,NULL,'30a5265b3a5f46c689427f6da47cb137',NULL,NULL,NULL,NULL,'2025-12-02 10:07:49',NULL,'2025-12-02 10:07:49',NULL,NULL),(584,NULL,NULL,'316a5f0a953349b9bb6e63152340066c',NULL,NULL,NULL,NULL,'2025-12-02 10:07:50',NULL,'2025-12-02 10:07:50',NULL,NULL),(585,NULL,'5fd47c7fe5874495abd3529145c2bdc4',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:50',NULL,'2025-12-02 10:07:50',NULL,NULL),(586,NULL,'3842ba57d6c7415d8d60b9dca46e58be',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:50',NULL,'2025-12-02 10:07:50',NULL,NULL),(587,NULL,'c83c01183aba40c080a7dde4126b2e3b',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:50',NULL,'2025-12-02 10:07:50',NULL,NULL),(588,NULL,'5cde5e3a264d4c56b0cff7d558abd895',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:51',NULL,'2025-12-02 10:07:51',NULL,NULL),(589,NULL,NULL,'ca4eb1820a6e4368b64df2104a4c0626',NULL,NULL,NULL,NULL,'2025-12-02 10:07:52',NULL,'2025-12-02 10:07:52',NULL,NULL),(590,NULL,NULL,'be4d585f454a45a2be959c13483d1baa',NULL,NULL,NULL,NULL,'2025-12-02 10:07:52',NULL,'2025-12-02 10:07:52',NULL,NULL),(591,NULL,'e0b136ba38404c3d8e76c1e639cf950f',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:52',NULL,'2025-12-02 10:07:52',NULL,NULL),(592,NULL,NULL,'7e0d7dcc532b479a95d6170210f7f957',NULL,NULL,NULL,NULL,'2025-12-02 10:07:53',NULL,'2025-12-02 10:07:53',NULL,NULL),(593,NULL,'27cf39916c5c4bc1833487052acaa22a',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:53',NULL,'2025-12-02 10:07:53',NULL,NULL),(594,NULL,NULL,'e4638f9fc4c541229615d33d45093931',NULL,NULL,NULL,NULL,'2025-12-02 10:07:54',NULL,'2025-12-02 10:07:54',NULL,NULL),(595,NULL,'588b0103ba37415590f6dbb05c047716',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:54',NULL,'2025-12-02 10:07:54',NULL,NULL),(596,NULL,NULL,'0976627c70444c338553000896e41656',NULL,NULL,NULL,NULL,'2025-12-02 10:07:55',NULL,'2025-12-02 10:07:55',NULL,NULL),(597,NULL,NULL,'2c01263ed838487686f5f04f9cc3699f',NULL,NULL,NULL,NULL,'2025-12-02 10:07:55',NULL,'2025-12-02 10:07:55',NULL,NULL),(598,NULL,NULL,'6aaa476a52e74d9bb577705929c64a2e',NULL,NULL,NULL,NULL,'2025-12-02 10:07:55',NULL,'2025-12-02 10:07:55',NULL,NULL),(599,NULL,'e8bffc1406804af0b62e583da310e742',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:55',NULL,'2025-12-02 10:07:55',NULL,NULL),(600,NULL,NULL,'5875473fd02842a894bc214e16bafa85',NULL,NULL,NULL,NULL,'2025-12-02 10:07:55',NULL,'2025-12-02 10:07:55',NULL,NULL),(601,NULL,'91d10c5ca25446f6a019e13492b59d1a',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:56',NULL,'2025-12-02 10:07:56',NULL,NULL),(602,NULL,'07d9b6d4842f4b18a3f54f0d2ae3e931',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:57',NULL,'2025-12-02 10:07:57',NULL,NULL),(603,NULL,'db1cb42439b64cfdaebd0b04758d50b0',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:57',NULL,'2025-12-02 10:07:57',NULL,NULL),(604,NULL,NULL,'e78609bf52a04260a6a564179bc32100',NULL,NULL,NULL,NULL,'2025-12-02 10:07:57',NULL,'2025-12-02 10:07:57',NULL,NULL),(605,NULL,NULL,'9dae5a04adc543cf9440daf89a0a16a1',NULL,NULL,NULL,NULL,'2025-12-02 10:07:57',NULL,'2025-12-02 10:07:57',NULL,NULL),(606,NULL,NULL,'3aba24afed5c48cdb8c342620ee20350',NULL,NULL,NULL,NULL,'2025-12-02 10:07:57',NULL,'2025-12-02 10:07:57',NULL,NULL),(607,NULL,NULL,'2b602ac0174a45c58f402ae44200249d',NULL,NULL,NULL,NULL,'2025-12-02 10:07:58',NULL,'2025-12-02 10:07:58',NULL,NULL),(608,NULL,'2646b644389748c08b158b82c4385c98',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:58',NULL,'2025-12-02 10:07:58',NULL,NULL),(609,NULL,'1485aa2bc66b417d8c79c90c0db6fa98',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:58',NULL,'2025-12-02 10:07:58',NULL,NULL),(610,NULL,'2f0c47b46b6241a69850573d87b33ee2',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:58',NULL,'2025-12-02 10:07:58',NULL,NULL),(611,NULL,'97a75f8ec78845faa02bb333f057c1e9',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:07:59',NULL,'2025-12-02 10:07:59',NULL,NULL),(612,NULL,'b3f90b287f6b4fd68de1b7576a224ec1',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:08:01',NULL,'2025-12-02 10:08:01',NULL,NULL),(613,NULL,NULL,'27f022e4e3c444cab81805dae6377933',NULL,NULL,NULL,NULL,'2025-12-02 10:08:01',NULL,'2025-12-02 10:08:01',NULL,NULL),(614,NULL,'668f404f639a46c9bd79465eedb0cb39',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:08:03',NULL,'2025-12-02 10:08:03',NULL,NULL),(615,NULL,'81db19f672ea4efba6e05f4f07c20d43',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:08:03',NULL,'2025-12-02 10:08:03',NULL,NULL),(616,NULL,NULL,'03a1933ebd064612a2c8e0000cf609f9',NULL,NULL,NULL,NULL,'2025-12-02 10:08:04',NULL,'2025-12-02 10:08:04',NULL,NULL),(617,NULL,NULL,'c04b0c1b682647b3a235292b9ca1b605',NULL,NULL,NULL,NULL,'2025-12-02 10:08:05',NULL,'2025-12-02 10:08:05',NULL,NULL),(618,NULL,'2b57b1fad39449b49cbbffbb5c62906d',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:08:07',NULL,'2025-12-02 10:08:07',NULL,NULL),(619,NULL,'e77ef8bbeb30443aa61687b6cde622e9',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:08:08',NULL,'2025-12-02 10:08:08',NULL,NULL),(620,NULL,NULL,'5a4e0628164f4e5095308dad1351f01c',NULL,NULL,NULL,NULL,'2025-12-02 10:08:08',NULL,'2025-12-02 10:08:08',NULL,NULL),(621,NULL,'23138a0801244854b8d3af70b53ef524',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:08:11',NULL,'2025-12-02 10:08:11',NULL,NULL),(622,NULL,'0eebb67de0744af8b32684acfd2bbda4',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:08:13',NULL,'2025-12-02 10:08:13',NULL,NULL),(623,NULL,NULL,'51c3967505874e1489a744736ea78b3a',NULL,NULL,NULL,NULL,'2025-12-02 10:08:18',NULL,'2025-12-02 10:08:18',NULL,NULL),(624,NULL,NULL,'b9ddb86c56c34db6a4f04ef49c73b98e',NULL,NULL,NULL,NULL,'2025-12-02 10:08:18',NULL,'2025-12-02 10:08:18',NULL,NULL),(625,NULL,NULL,'7fb66f8708c940baa1507e3b4224201f',NULL,NULL,NULL,NULL,'2025-12-02 10:08:19',NULL,'2025-12-02 10:08:19',NULL,NULL),(626,NULL,NULL,'92d4a1686fd14d0eaed351075a66cefb',NULL,NULL,NULL,NULL,'2025-12-02 10:08:19',NULL,'2025-12-02 10:08:19',NULL,NULL),(627,NULL,'aaee8fe9c74942a5b83cec69b3422767',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:08:19',NULL,'2025-12-02 10:08:19',NULL,NULL),(628,NULL,NULL,'c8e82785d5ee45489b1c570821a68ab0',NULL,NULL,NULL,NULL,'2025-12-02 10:08:19',NULL,'2025-12-02 10:08:19',NULL,NULL),(629,NULL,'a386152d4f9548a19401ff2807ede1ac',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:08:21',NULL,'2025-12-02 10:08:21',NULL,NULL),(630,NULL,NULL,'51b1bddb6c1e46a2a6ddd99bc7bc174a',NULL,NULL,NULL,NULL,'2025-12-02 10:08:21',NULL,'2025-12-02 10:08:21',NULL,NULL),(631,NULL,'fd68c5c8c916430aa961fb5f9731582e',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:08:22',NULL,'2025-12-02 10:08:22',NULL,NULL),(632,NULL,'f6d49a88cf364492821d2e43c6397e47',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:08:23',NULL,'2025-12-02 10:08:23',NULL,NULL),(633,NULL,'03ffd9a810e746109c27c05f57123e54',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:08:24',NULL,'2025-12-02 10:08:24',NULL,NULL),(634,NULL,NULL,'ea5606dce10d441096782736929aa132',NULL,NULL,NULL,NULL,'2025-12-02 10:08:29',NULL,'2025-12-02 10:08:29',NULL,NULL),(635,NULL,NULL,'378bbf1156ab482eae3359fa477651da',NULL,NULL,NULL,NULL,'2025-12-02 10:08:29',NULL,'2025-12-02 10:08:29',NULL,NULL),(636,NULL,NULL,'e2639de4f9f14f00b54ca602fdebfdab',NULL,NULL,NULL,NULL,'2025-12-02 10:08:31',NULL,'2025-12-02 10:08:31',NULL,NULL),(637,NULL,'13c70d8f74354389b175376619620536',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:08:31',NULL,'2025-12-02 10:08:31',NULL,NULL),(638,NULL,NULL,'11daa5bc8801433f99b71663879a8016',NULL,NULL,NULL,NULL,'2025-12-02 10:08:32',NULL,'2025-12-02 10:08:32',NULL,NULL),(639,NULL,'833b3cd28f26443489b45a181193c60b',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:08:32',NULL,'2025-12-02 10:08:32',NULL,NULL),(640,NULL,'12447334a8d247008c5f1d1eb28a0ff5',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:08:34',NULL,'2025-12-02 10:08:34',NULL,NULL),(641,NULL,'62771fbe049e4d57aae1b3554ed3a36c',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:08:34',NULL,'2025-12-02 10:08:34',NULL,NULL),(642,NULL,NULL,'e106d79b62e54215bcadae87f431c1b2',NULL,NULL,NULL,NULL,'2025-12-02 10:08:35',NULL,'2025-12-02 10:08:35',NULL,NULL),(643,NULL,NULL,'a102033e91ed43148530099c848ac76f',NULL,NULL,NULL,NULL,'2025-12-02 10:08:36',NULL,'2025-12-02 10:08:36',NULL,NULL),(644,NULL,'4e73ba019dac41d08c58b2d27a75d430',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:08:39',NULL,'2025-12-02 10:08:39',NULL,NULL),(645,NULL,'6963976a36c6408c9336062feaef5d1f',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:08:40',NULL,'2025-12-02 10:08:40',NULL,NULL),(646,NULL,NULL,'a3c52ee96f7342359efb8efa2c6a9d7a',NULL,NULL,NULL,NULL,'2025-12-02 10:08:43',NULL,'2025-12-02 10:08:43',NULL,NULL),(647,NULL,NULL,'5c948e393e814e0aa5127e2b8ad03a38',NULL,NULL,NULL,NULL,'2025-12-02 10:08:45',NULL,'2025-12-02 10:08:45',NULL,NULL),(648,NULL,NULL,'8d9ee604f35c4eecbb451906bc7c8c50',NULL,NULL,NULL,NULL,'2025-12-02 10:08:45',NULL,'2025-12-02 10:08:45',NULL,NULL),(649,NULL,'8ecf0fcaf7384c7d9e2eb9c5a5e8ac26',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:08:47',NULL,'2025-12-02 10:08:47',NULL,NULL),(650,NULL,'6ca87ccef29347a0952750d14f6d2c84',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:08:49',NULL,'2025-12-02 10:08:49',NULL,NULL),(651,NULL,'009883909bb24195a689c4969c5c0fbd',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:08:53',NULL,'2025-12-02 10:08:53',NULL,NULL),(652,NULL,NULL,'7dae7e6a603247388ae4d12e9f2ed763',NULL,NULL,NULL,NULL,'2025-12-02 10:08:54',NULL,'2025-12-02 10:08:54',NULL,NULL),(653,NULL,NULL,'362fbb6a3a3644fcbec2ebd0644f5791',NULL,NULL,NULL,NULL,'2025-12-02 10:08:55',NULL,'2025-12-02 10:08:55',NULL,NULL),(654,NULL,NULL,'a7bb6d80634243a38774fa458a699233',NULL,NULL,NULL,NULL,'2025-12-02 10:08:55',NULL,'2025-12-02 10:08:55',NULL,NULL),(655,NULL,NULL,'4a840f3a9306488997351bbe0ced7615',NULL,NULL,NULL,NULL,'2025-12-02 10:08:55',NULL,'2025-12-02 10:08:55',NULL,NULL),(656,NULL,'da8f469965c2428bb09fb52ea0da374c',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:08:58',NULL,'2025-12-02 10:08:58',NULL,NULL),(657,NULL,NULL,'52dcb62d5f874a40b3953f71999005ee',NULL,NULL,NULL,NULL,'2025-12-02 10:09:00',NULL,'2025-12-02 10:09:00',NULL,NULL),(658,NULL,NULL,'b0829a790bb443b4897ed5e733cd2321',NULL,NULL,NULL,NULL,'2025-12-02 10:09:00',NULL,'2025-12-02 10:09:00',NULL,NULL),(659,NULL,'b56f565cca894a56b9aea60a840607f7',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:09:00',NULL,'2025-12-02 10:09:00',NULL,NULL),(660,NULL,'4021ccbfb34b44ba81a2e1baeba352f8',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:09:03',NULL,'2025-12-02 10:09:03',NULL,NULL),(661,NULL,'88ada1dc04884eb0b3013bc2d2c4917c',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:09:03',NULL,'2025-12-02 10:09:03',NULL,NULL),(662,NULL,'39e61a5b386d4da6b473d4d53493af05',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:09:05',NULL,'2025-12-02 10:09:05',NULL,NULL),(663,NULL,NULL,'b9e225876304492f94240d3fc4e727ed',NULL,NULL,NULL,NULL,'2025-12-02 10:09:06',NULL,'2025-12-02 10:09:06',NULL,NULL),(664,NULL,NULL,'ea09fd599b014976b4b6d101bd660615',NULL,NULL,NULL,NULL,'2025-12-02 10:09:06',NULL,'2025-12-02 10:09:06',NULL,NULL),(665,NULL,NULL,'74c5eb8a019a4e62a5eaf3b3d37efc2b',NULL,NULL,NULL,NULL,'2025-12-02 10:09:07',NULL,'2025-12-02 10:09:07',NULL,NULL),(666,NULL,NULL,'5c18a0166b5c4cda88d91d874afcea96',NULL,NULL,NULL,NULL,'2025-12-02 10:09:07',NULL,'2025-12-02 10:09:07',NULL,NULL),(667,NULL,'64d30b95640d4bc4991756da49cb0163',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:09:08',NULL,'2025-12-02 10:09:08',NULL,NULL),(668,NULL,NULL,'8b414a8dfc3b4700986262843521d539',NULL,NULL,NULL,NULL,'2025-12-02 10:09:08',NULL,'2025-12-02 10:09:08',NULL,NULL),(669,NULL,NULL,'8a23473987174a91810d5e45b43538ac',NULL,NULL,NULL,NULL,'2025-12-02 10:09:09',NULL,'2025-12-02 10:09:09',NULL,NULL),(670,NULL,'013c3f934ab54b1a83f18d3dcf154dd0',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:09:09',NULL,'2025-12-02 10:09:09',NULL,NULL),(671,NULL,NULL,'cf0b3644a3204858974ae979d5b7ec5a',NULL,NULL,NULL,NULL,'2025-12-02 10:09:09',NULL,'2025-12-02 10:09:09',NULL,NULL),(672,NULL,NULL,'d75c1e01fa03492090b1989d264a5268',NULL,NULL,NULL,NULL,'2025-12-02 10:09:10',NULL,'2025-12-02 10:09:10',NULL,NULL),(673,NULL,'55a1704ffc364befaa4191926083a215',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:09:10',NULL,'2025-12-02 10:09:10',NULL,NULL),(674,NULL,'d7c3ca3eec6f4e43b7d189dbc6fd6921',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:09:10',NULL,'2025-12-02 10:09:10',NULL,NULL),(675,NULL,'c7c95e91029943989de584adeb3a41e5',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:09:11',NULL,'2025-12-02 10:09:11',NULL,NULL),(676,NULL,'98392ceb1d614e91b0d7225f690f2783',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:09:13',NULL,'2025-12-02 10:09:13',NULL,NULL),(677,NULL,NULL,'c979d4ba11394b9fb99e37b038824867',NULL,NULL,NULL,NULL,'2025-12-02 10:09:13',NULL,'2025-12-02 10:09:13',NULL,NULL),(678,NULL,'a7c7dfa0a07e48c3bdf53de987cec565',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:09:15',NULL,'2025-12-02 10:09:15',NULL,NULL),(679,NULL,'8f73e704478d406088dff2f137f98725',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:09:16',NULL,'2025-12-02 10:09:16',NULL,NULL),(680,NULL,NULL,'90c44bc5f02140e8a949d41b94589d5e',NULL,NULL,NULL,NULL,'2025-12-02 10:09:19',NULL,'2025-12-02 10:09:19',NULL,NULL),(681,NULL,NULL,'80998e2d919848be8d0f2304953f530c',NULL,NULL,NULL,NULL,'2025-12-02 10:09:20',NULL,'2025-12-02 10:09:20',NULL,NULL),(682,NULL,'94e8b36d29864bf28eafeaf1e9d939a4',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:09:21',NULL,'2025-12-02 10:09:21',NULL,NULL),(683,NULL,NULL,'5b936fa204fb4eccbb40310a7cab306d',NULL,NULL,NULL,NULL,'2025-12-02 10:09:22',NULL,'2025-12-02 10:09:22',NULL,NULL),(684,NULL,NULL,'bc89d97fbbfb41b6a0a96d2f2eb800a5',NULL,NULL,NULL,NULL,'2025-12-02 10:09:22',NULL,'2025-12-02 10:09:22',NULL,NULL),(685,NULL,'52f549761e6542cc8caa7d3d89d5ea39',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:09:23',NULL,'2025-12-02 10:09:23',NULL,NULL),(686,NULL,NULL,'b9c801fe16fd46b78d8c4d5c23cd99c7',NULL,NULL,NULL,NULL,'2025-12-02 10:09:24',NULL,'2025-12-02 10:09:24',NULL,NULL),(687,NULL,NULL,'3a4e84b01ab84715be19388f65bcdd82',NULL,NULL,NULL,NULL,'2025-12-02 10:09:25',NULL,'2025-12-02 10:09:25',NULL,NULL),(688,NULL,'d077375432eb4d5983dfbe6a6927c321',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:09:25',NULL,'2025-12-02 10:09:25',NULL,NULL),(689,NULL,'50b20ebe68c9494a933fabe997d62528',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:09:26',NULL,'2025-12-02 10:09:26',NULL,NULL),(690,NULL,'65581967be0142fd9ffa61ddefaab705',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:09:27',NULL,'2025-12-02 10:09:27',NULL,NULL),(691,NULL,'99d88ed9db6a44ad8671401d30ce29a3',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:09:27',NULL,'2025-12-02 10:09:27',NULL,NULL),(692,NULL,NULL,'b2d2a688edfb4813adc394e0e3d10292',NULL,NULL,NULL,NULL,'2025-12-02 10:09:30',NULL,'2025-12-02 10:09:30',NULL,NULL),(693,NULL,'fd6defed964a46deb60f72b58285d1e2',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:09:31',NULL,'2025-12-02 10:09:31',NULL,NULL),(694,NULL,NULL,'89818a690cd647d88ab909441f679654',NULL,NULL,NULL,NULL,'2025-12-02 10:09:36',NULL,'2025-12-02 10:09:36',NULL,NULL),(695,NULL,NULL,'378fade023744650a7add577f4ab818c',NULL,NULL,NULL,NULL,'2025-12-02 10:09:36',NULL,'2025-12-02 10:09:36',NULL,NULL),(696,NULL,NULL,'5f62f3b57dfb4f4b9c128c68ec04e7cc',NULL,NULL,NULL,NULL,'2025-12-02 10:09:36',NULL,'2025-12-02 10:09:36',NULL,NULL),(697,NULL,NULL,'3a7787b83ecb493db2faaeb806e27c5c',NULL,NULL,NULL,NULL,'2025-12-02 10:09:37',NULL,'2025-12-02 10:09:37',NULL,NULL),(698,NULL,'0bf14c90f0f64552a5caf3dcaa81d485',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:09:39',NULL,'2025-12-02 10:09:39',NULL,NULL),(699,NULL,NULL,'49e91c7702d54b1ab47e5f6dec5e0208',NULL,NULL,NULL,NULL,'2025-12-02 10:09:39',NULL,'2025-12-02 10:09:39',NULL,NULL),(700,NULL,'204a1137a20e40c995bb9cd512e75a5c',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:09:41',NULL,'2025-12-02 10:09:41',NULL,NULL),(701,NULL,NULL,'f91ea2f3e6064338bfd751b12b56ae7b',NULL,NULL,NULL,NULL,'2025-12-02 10:09:41',NULL,'2025-12-02 10:09:41',NULL,NULL),(702,NULL,'2273367c2c194e68abd26b78c2548317',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:09:42',NULL,'2025-12-02 10:09:42',NULL,NULL),(703,NULL,'22f6dcddc8be4228bccee702e0c992e7',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:09:42',NULL,'2025-12-02 10:09:42',NULL,NULL),(704,NULL,'873db74a4a7a4aad823d1b7e8b2d6c26',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:09:42',NULL,'2025-12-02 10:09:42',NULL,NULL),(705,NULL,NULL,'7fdff55a0d554fb28c067104c4b223a4',NULL,NULL,NULL,NULL,'2025-12-02 10:09:43',NULL,'2025-12-02 10:09:43',NULL,NULL),(706,NULL,'6c1597b25b33405db70f223b571f21b7',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:09:45',NULL,'2025-12-02 10:09:45',NULL,NULL),(707,NULL,NULL,'49dfe28b1cd04aec9e8b88dfb9069db3',NULL,NULL,NULL,NULL,'2025-12-02 10:09:45',NULL,'2025-12-02 10:09:45',NULL,NULL),(708,NULL,NULL,'2212bd30f27740669cc0c293d8c069f6',NULL,NULL,NULL,NULL,'2025-12-02 10:09:46',NULL,'2025-12-02 10:09:46',NULL,NULL),(709,NULL,'3850e35bf27745abb519e95c1bc93ec0',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:09:48',NULL,'2025-12-02 10:09:48',NULL,NULL),(710,NULL,'d9100eb96d2547829431564309631d69',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:09:49',NULL,'2025-12-02 10:09:49',NULL,NULL),(711,NULL,NULL,'6a4701e292e04a82a827d127f0ef5b65',NULL,NULL,NULL,NULL,'2025-12-02 10:09:59',NULL,'2025-12-02 10:09:59',NULL,NULL),(712,NULL,'0b7e671d1f944c979f6feba0246d3141',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:10:00',NULL,'2025-12-02 10:10:00',NULL,NULL),(713,NULL,NULL,'0479d80e747a465faee880dae08f660d',NULL,NULL,NULL,NULL,'2025-12-02 10:10:06',NULL,'2025-12-02 10:10:06',NULL,NULL),(714,NULL,NULL,'51a2a486b9484c3d96bff111b1f22b7e',NULL,NULL,NULL,NULL,'2025-12-02 10:10:07',NULL,'2025-12-02 10:10:07',NULL,NULL),(715,NULL,NULL,'b612e57aaeba4fb8915e8aa972bf8099',NULL,NULL,NULL,NULL,'2025-12-02 10:10:07',NULL,'2025-12-02 10:10:07',NULL,NULL),(716,NULL,NULL,'d217eade00cd4cc399fae288cec2dc40',NULL,NULL,NULL,NULL,'2025-12-02 10:10:07',NULL,'2025-12-02 10:10:07',NULL,NULL),(717,NULL,'77d48f7a127b4bacb09f9e82a4c1f799',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:10:11',NULL,'2025-12-02 10:10:11',NULL,NULL),(718,NULL,NULL,'7602b6bff04a41118e902187d8f95daa',NULL,NULL,NULL,NULL,'2025-12-02 10:10:11',NULL,'2025-12-02 10:10:11',NULL,NULL),(719,NULL,'b537228b863c4207890127e098ae0f04',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:10:12',NULL,'2025-12-02 10:10:12',NULL,NULL),(720,NULL,'39113116e26e4da3a6194d2f44d952a8',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:10:13',NULL,'2025-12-02 10:10:13',NULL,NULL),(721,NULL,NULL,'2903ef7b8c704dc09be34f96aeda2cff',NULL,NULL,NULL,NULL,'2025-12-02 10:10:14',NULL,'2025-12-02 10:10:14',NULL,NULL),(722,NULL,'2b4d8291509341869e7d25873b7306da',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:10:14',NULL,'2025-12-02 10:10:14',NULL,NULL),(723,NULL,'6d11f96a2f644a22a82a6af9a2a1e5d2',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:10:15',NULL,'2025-12-02 10:10:15',NULL,NULL),(724,NULL,NULL,'2fac4226c56f4a23955f4091540dbe99',NULL,NULL,NULL,NULL,'2025-12-02 10:10:15',NULL,'2025-12-02 10:10:15',NULL,NULL),(725,NULL,'a54184e9f0664671909bfb9f9d3379c6',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:10:16',NULL,'2025-12-02 10:10:16',NULL,NULL),(726,NULL,NULL,'8d2b383649fa45f2821f6e290127374a',NULL,NULL,NULL,NULL,'2025-12-02 10:10:32',NULL,'2025-12-02 10:10:32',NULL,NULL),(727,NULL,'84fd536b8b4d489f944ed3e4bbfaeb5b',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:10:34',NULL,'2025-12-02 10:10:34',NULL,NULL),(728,NULL,NULL,'ffc28dac62f4495c9452fce17050d09a',NULL,NULL,NULL,NULL,'2025-12-02 10:10:59',NULL,'2025-12-02 10:10:59',NULL,NULL),(729,NULL,NULL,'bae9ddb3c01645b49b8983ad446d9968',NULL,NULL,NULL,NULL,'2025-12-02 10:10:59',NULL,'2025-12-02 10:10:59',NULL,NULL),(730,NULL,NULL,'57832728fce14260b03b0f06122d5897',NULL,NULL,NULL,NULL,'2025-12-02 10:11:00',NULL,'2025-12-02 10:11:00',NULL,NULL),(731,NULL,'5bad680c763640dba71a7865b355817c',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:11:01',NULL,'2025-12-02 10:11:01',NULL,NULL),(732,NULL,'aae5e2dae10d49c38d5d63835c7677e3',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:11:01',NULL,'2025-12-02 10:11:01',NULL,NULL),(733,NULL,'16ae7f5f159c4b10a1539c2d9b52fce5',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:11:02',NULL,'2025-12-02 10:11:02',NULL,NULL),(734,NULL,NULL,'96d6ed36fd4c42f493d8249cb89d6ea0',NULL,NULL,NULL,NULL,'2025-12-02 10:11:08',NULL,'2025-12-02 10:11:08',NULL,NULL),(735,NULL,NULL,'d177d8dee4c74ba69f8b1b2e77f73018',NULL,NULL,NULL,NULL,'2025-12-02 10:11:17',NULL,'2025-12-02 10:11:17',NULL,NULL),(736,NULL,NULL,'5af8cd170e49421ba1b9eede8eb1a146',NULL,NULL,NULL,NULL,'2025-12-02 10:11:17',NULL,'2025-12-02 10:11:17',NULL,NULL),(737,NULL,NULL,'aada0c17c5324d90860561678fada17b',NULL,NULL,NULL,NULL,'2025-12-02 10:11:17',NULL,'2025-12-02 10:11:17',NULL,NULL),(738,NULL,NULL,'a2f31e38121849b1a94c7d92da5618f7',NULL,NULL,NULL,NULL,'2025-12-02 10:11:17',NULL,'2025-12-02 10:11:17',NULL,NULL),(739,NULL,NULL,'230813dd4b61407eb58217af84ee2d48',NULL,NULL,NULL,NULL,'2025-12-02 10:11:18',NULL,'2025-12-02 10:11:18',NULL,NULL),(740,NULL,NULL,'aa6c1c15e36044848521230751fd46bc',NULL,NULL,NULL,NULL,'2025-12-02 10:11:18',NULL,'2025-12-02 10:11:18',NULL,NULL),(741,NULL,NULL,'1aa9c42ce52647ac840d8264bfaa8bc0',NULL,NULL,NULL,NULL,'2025-12-02 10:11:19',NULL,'2025-12-02 10:11:19',NULL,NULL),(742,NULL,'fef053541b4b4785ab9899f41b37c328',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:11:25',NULL,'2025-12-02 10:11:25',NULL,NULL),(743,NULL,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:11:25',NULL,'2025-12-02 10:11:25',NULL,NULL),(744,NULL,'3cb8897eac514c8791f32dc7c7f97664',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:11:25',NULL,'2025-12-02 10:11:25',NULL,NULL),(745,NULL,NULL,'8b49e5c866794aad866d55bb5f154d67',NULL,NULL,NULL,NULL,'2025-12-02 10:11:28',NULL,'2025-12-02 10:11:28',NULL,NULL),(746,NULL,'efbd1cf12d1441269b72130fc6cf60d9',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:11:34',NULL,'2025-12-02 10:11:34',NULL,NULL),(747,NULL,'acbcc8f841e04113aacfccf53b0b7906',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:11:35',NULL,'2025-12-02 10:11:35',NULL,NULL),(748,NULL,'7dffef2e74844a7ebb6ee68826fb7e57',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:11:35',NULL,'2025-12-02 10:11:35',NULL,NULL),(749,NULL,'a71ebafb6dc34242bda77c138244fe46',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:11:35',NULL,'2025-12-02 10:11:35',NULL,NULL),(750,NULL,'c73f438ad081403daee0d912b28f2aaf',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:11:35',NULL,'2025-12-02 10:11:35',NULL,NULL),(751,NULL,NULL,'9f4eafbab2cf452da851229adb1672cf',NULL,NULL,NULL,NULL,'2025-12-02 10:11:41',NULL,'2025-12-02 10:11:41',NULL,NULL),(752,NULL,NULL,'d78d896fe8e142e29fdd4083370c40c1',NULL,NULL,NULL,NULL,'2025-12-02 10:11:41',NULL,'2025-12-02 10:11:41',NULL,NULL),(753,NULL,'f39b5ca1adf344dd9239d3d0131792d4',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:11:44',NULL,'2025-12-02 10:11:44',NULL,NULL),(754,NULL,'f7326c3837b4427191aafcff504110ac',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:11:47',NULL,'2025-12-02 10:11:47',NULL,NULL),(755,NULL,NULL,'c9ccc778ea32434ba318659fdb08eb10',NULL,NULL,NULL,NULL,'2025-12-02 10:11:56',NULL,'2025-12-02 10:11:56',NULL,NULL),(756,NULL,'8e9db6bb24074518b94709252c97dff0',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:12:00',NULL,'2025-12-02 10:12:00',NULL,NULL),(757,NULL,NULL,'50b89c4c8cc74474b5fe83dd24cf9df5',NULL,NULL,NULL,NULL,'2025-12-02 10:12:02',NULL,'2025-12-02 10:12:02',NULL,NULL),(758,NULL,NULL,'52e2d5d3d218480cb5f124619e132f59',NULL,NULL,NULL,NULL,'2025-12-02 10:12:02',NULL,'2025-12-02 10:12:02',NULL,NULL),(759,NULL,NULL,'672c8413bfe64526934516e0eb19a954',NULL,NULL,NULL,NULL,'2025-12-02 10:12:02',NULL,'2025-12-02 10:12:02',NULL,NULL),(760,NULL,NULL,'249ebdc08ba04107bacf31d1c3286667',NULL,NULL,NULL,NULL,'2025-12-02 10:12:02',NULL,'2025-12-02 10:12:02',NULL,NULL),(761,NULL,'28f4ef6ddb6546fbb800184721e43e93',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:12:03',NULL,'2025-12-02 10:12:03',NULL,NULL),(762,NULL,'ab84e521dda9432ca7d62c5185f1eaab',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:12:03',NULL,'2025-12-02 10:12:03',NULL,NULL),(763,NULL,'2267b5d8ec1242618341cd359607d279',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:12:05',NULL,'2025-12-02 10:12:05',NULL,NULL),(764,NULL,'4fbeda4ffdba4907850a5b3964b5b1eb',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:12:06',NULL,'2025-12-02 10:12:06',NULL,NULL),(765,NULL,NULL,'a77bb2b931e445c4ad336313b54bf1f6',NULL,NULL,NULL,NULL,'2025-12-02 10:12:10',NULL,'2025-12-02 10:12:10',NULL,NULL),(766,NULL,'da38242c0e8d4da7a906db10517a9171',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:12:11',NULL,'2025-12-02 10:12:11',NULL,NULL),(767,NULL,NULL,'f9daf1690e014a9d9bcc6e1662fa5439',NULL,NULL,NULL,NULL,'2025-12-02 10:12:13',NULL,'2025-12-02 10:12:13',NULL,NULL),(768,NULL,NULL,'185667f603a24eeda7f01ad1347aed97',NULL,NULL,NULL,NULL,'2025-12-02 10:12:13',NULL,'2025-12-02 10:12:13',NULL,NULL),(769,NULL,'1e90b030c2b247a7a33033ba004a83a5',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:12:15',NULL,'2025-12-02 10:12:15',NULL,NULL),(770,NULL,'10644498f24744ec828624bc952bff43',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:12:16',NULL,'2025-12-02 10:12:16',NULL,NULL),(771,NULL,NULL,'f83feebaa97a4b69a6ad79c1445ea1c0',NULL,NULL,NULL,NULL,'2025-12-02 10:12:18',NULL,'2025-12-02 10:12:18',NULL,NULL),(772,NULL,NULL,'7ecf77dbd2574788a6586386d97ee38c',NULL,NULL,NULL,NULL,'2025-12-02 10:12:18',NULL,'2025-12-02 10:12:18',NULL,NULL),(773,NULL,NULL,'d9d048c05fb54f2f975007f0a2a0ce7c',NULL,NULL,NULL,NULL,'2025-12-02 10:12:19',NULL,'2025-12-02 10:12:19',NULL,NULL),(774,NULL,'9996731e72864b5eaf18faba3921da1f',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:12:19',NULL,'2025-12-02 10:12:19',NULL,NULL),(775,NULL,'f5466a94421d4e84977ee830576dd8b7',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:12:20',NULL,'2025-12-02 10:12:20',NULL,NULL),(776,NULL,'5e0d3be420324e4eb448c1eec973eded',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:12:20',NULL,'2025-12-02 10:12:20',NULL,NULL),(777,NULL,NULL,'69fc2c808dd14b98a9c24ab6a695a373',NULL,NULL,NULL,NULL,'2025-12-02 10:12:22',NULL,'2025-12-02 10:12:22',NULL,NULL),(778,NULL,NULL,'ac92351e436c40118f10d414b4eb5908',NULL,NULL,NULL,NULL,'2025-12-02 10:12:22',NULL,'2025-12-02 10:12:22',NULL,NULL),(779,NULL,'043cc6f66b444d00959c7dcdb078fbe8',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:12:23',NULL,'2025-12-02 10:12:23',NULL,NULL),(780,NULL,NULL,'64dd679998434da29fe4e7e431847344',NULL,NULL,NULL,NULL,'2025-12-02 10:12:29',NULL,'2025-12-02 10:12:29',NULL,NULL),(781,NULL,NULL,'0302bd3e8e3f4d5fb73c2c5956a6a400',NULL,NULL,NULL,NULL,'2025-12-02 10:12:29',NULL,'2025-12-02 10:12:29',NULL,NULL),(782,NULL,NULL,'eec1dbb4ab40488a83c5c6e8ef9e7c00',NULL,NULL,NULL,NULL,'2025-12-02 10:12:29',NULL,'2025-12-02 10:12:29',NULL,NULL),(783,NULL,'c5a0b975296e4a20bf212a0a4c86e69d',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:12:31',NULL,'2025-12-02 10:12:31',NULL,NULL),(784,NULL,NULL,'33f0d1c6e7e943ecbe99fa2948601f31',NULL,NULL,NULL,NULL,'2025-12-02 10:12:31',NULL,'2025-12-02 10:12:31',NULL,NULL),(785,NULL,'d815670f1c384b388291e0d22b14446c',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:12:34',NULL,'2025-12-02 10:12:34',NULL,NULL),(786,NULL,'9983d967265d4691806eb9b9a49900de',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:12:34',NULL,'2025-12-02 10:12:34',NULL,NULL),(787,NULL,NULL,'655d9191fb2f408c917a6a9ed2235d2d',NULL,NULL,NULL,NULL,'2025-12-02 10:12:35',NULL,'2025-12-02 10:12:35',NULL,NULL),(788,NULL,'e2aae710ad6e4ecbafd15881a70326ff',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:12:35',NULL,'2025-12-02 10:12:35',NULL,NULL),(789,NULL,NULL,'6e1c2700dcdf4fb284453ea65a90ca64',NULL,NULL,NULL,NULL,'2025-12-02 10:12:35',NULL,'2025-12-02 10:12:35',NULL,NULL),(790,NULL,'493ba0ae14a44c0bb6616ac2382930a4',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:12:36',NULL,'2025-12-02 10:12:36',NULL,NULL),(791,NULL,NULL,'c87e17f3b1644be3b9ed7f697d83e65e',NULL,NULL,NULL,NULL,'2025-12-02 10:12:37',NULL,'2025-12-02 10:12:37',NULL,NULL),(792,NULL,'6b4f1f3dd8704e9992f1bc11c793a60e',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:12:38',NULL,'2025-12-02 10:12:38',NULL,NULL),(793,NULL,'0501b6534c8947338f563b6a9c7e4f36',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:12:39',NULL,'2025-12-02 10:12:39',NULL,NULL),(794,NULL,NULL,'27e8ee5045c2430583000f8d62f6e4f1',NULL,NULL,NULL,NULL,'2025-12-02 10:12:39',NULL,'2025-12-02 10:12:39',NULL,NULL),(795,NULL,NULL,'3642c2b461de472ab3233bd60fb17b07',NULL,NULL,NULL,NULL,'2025-12-02 10:12:40',NULL,'2025-12-02 10:12:40',NULL,NULL),(796,NULL,NULL,'a24970ee657641b29b0cf7283964b674',NULL,NULL,NULL,NULL,'2025-12-02 10:12:41',NULL,'2025-12-02 10:12:41',NULL,NULL),(797,NULL,'096ffa0a51b143039159efc232ec547a',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:12:41',NULL,'2025-12-02 10:12:41',NULL,NULL),(798,NULL,NULL,'d9f7ab4e1969497eb4fe16f526113dd0',NULL,NULL,NULL,NULL,'2025-12-02 10:12:41',NULL,'2025-12-02 10:12:41',NULL,NULL),(799,NULL,NULL,'dca05ac69267472d9cf71b1fe3d4db3e',NULL,NULL,NULL,NULL,'2025-12-02 10:12:41',NULL,'2025-12-02 10:12:41',NULL,NULL),(800,NULL,'cca5ee1e77f949a1929fb823febb4e43',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:12:43',NULL,'2025-12-02 10:12:43',NULL,NULL),(801,NULL,'768f28ca94b84a24b1593434f7919fa0',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:12:44',NULL,'2025-12-02 10:12:44',NULL,NULL),(802,NULL,NULL,'26d732e2823c41e7bcdba03bb8a5b208',NULL,NULL,NULL,NULL,'2025-12-02 10:12:47',NULL,'2025-12-02 10:12:47',NULL,NULL),(803,NULL,NULL,'239e57982ef14a5f9ea3badc0174b521',NULL,NULL,NULL,NULL,'2025-12-02 10:12:47',NULL,'2025-12-02 10:12:47',NULL,NULL),(804,NULL,NULL,'3f50235acd2940e3b0904573698e60f7',NULL,NULL,NULL,NULL,'2025-12-02 10:12:47',NULL,'2025-12-02 10:12:47',NULL,NULL),(805,NULL,'480c6883b399458f8d360dbcea8dd815',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:12:50',NULL,'2025-12-02 10:12:50',NULL,NULL),(806,NULL,'a241a07e4161486091e8de3f95a1d6c6',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:12:51',NULL,'2025-12-02 10:12:51',NULL,NULL),(807,NULL,'622b6219331b42d289a0ebd0573907db',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:12:52',NULL,'2025-12-02 10:12:52',NULL,NULL),(808,NULL,NULL,'2f2bcd1dc5d14df2950bd42feb213c73',NULL,NULL,NULL,NULL,'2025-12-02 10:12:52',NULL,'2025-12-02 10:12:52',NULL,NULL),(809,NULL,NULL,'3f22e2aff5c14853badb6a6158c591ea',NULL,NULL,NULL,NULL,'2025-12-02 10:12:52',NULL,'2025-12-02 10:12:52',NULL,NULL),(810,NULL,'ebea8f99af7348e09c175366ffcf30b9',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:12:54',NULL,'2025-12-02 10:12:54',NULL,NULL),(811,NULL,'bb3c511d46dd4d3ead65c06b6e7b5c12',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:12:55',NULL,'2025-12-02 10:12:55',NULL,NULL),(812,NULL,NULL,'d7ddbe8785f548938e2ad6e167c407b0',NULL,NULL,NULL,NULL,'2025-12-02 10:12:56',NULL,'2025-12-02 10:12:56',NULL,NULL),(813,NULL,NULL,'1e00a477ab074c198bca0dccdf336ac9',NULL,NULL,NULL,NULL,'2025-12-02 10:12:56',NULL,'2025-12-02 10:12:56',NULL,NULL),(814,NULL,NULL,'b6017fb543b74f82bd55435570f95fad',NULL,NULL,NULL,NULL,'2025-12-02 10:12:56',NULL,'2025-12-02 10:12:56',NULL,NULL),(815,NULL,NULL,'a891d05cd8f548df91da5aca183ac306',NULL,NULL,NULL,NULL,'2025-12-02 10:12:56',NULL,'2025-12-02 10:12:56',NULL,NULL),(816,NULL,'3b6f491d6ce94f0880c6bb05715d2ed6',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:12:59',NULL,'2025-12-02 10:12:59',NULL,NULL),(817,NULL,'d505a25243b44659b472db2e4ab452e4',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:00',NULL,'2025-12-02 10:13:00',NULL,NULL),(818,NULL,NULL,'3d96130ac04f48a1ae7da918768692a0',NULL,NULL,NULL,NULL,'2025-12-02 10:13:01',NULL,'2025-12-02 10:13:01',NULL,NULL),(819,NULL,'dd2b7449046b43b2859bc0c1d65aef30',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:02',NULL,'2025-12-02 10:13:02',NULL,NULL),(820,NULL,'27248882cb8c42ec8f5581a6057904ce',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:02',NULL,'2025-12-02 10:13:02',NULL,NULL),(821,NULL,NULL,'defcf0debbf84a5c9ec6342ae3d02928',NULL,NULL,NULL,NULL,'2025-12-02 10:13:02',NULL,'2025-12-02 10:13:02',NULL,NULL),(822,NULL,'8eea084241c14c5d9a6cc0d912041a21',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:03',NULL,'2025-12-02 10:13:03',NULL,NULL),(823,NULL,NULL,'9d05040e5bb843e586bc55f9fed52b4b',NULL,NULL,NULL,NULL,'2025-12-02 10:13:04',NULL,'2025-12-02 10:13:04',NULL,NULL),(824,NULL,NULL,'b99fb9e02616408da5b39544cad2c70f',NULL,NULL,NULL,NULL,'2025-12-02 10:13:05',NULL,'2025-12-02 10:13:05',NULL,NULL),(825,NULL,NULL,'23ef612be4ec4ffd840ad5af83940922',NULL,NULL,NULL,NULL,'2025-12-02 10:13:05',NULL,'2025-12-02 10:13:05',NULL,NULL),(826,NULL,'01f990ccc08c4af59b081481d93980ae',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:06',NULL,'2025-12-02 10:13:06',NULL,NULL),(827,NULL,'8943858eee964ad7920643441a49ca76',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:07',NULL,'2025-12-02 10:13:07',NULL,NULL),(828,NULL,NULL,'50d7628020cb45a19d801d6534aa80ab',NULL,NULL,NULL,NULL,'2025-12-02 10:13:07',NULL,'2025-12-02 10:13:07',NULL,NULL),(829,NULL,NULL,'3b3c8f545ef64e1bb4dc093c17958986',NULL,NULL,NULL,NULL,'2025-12-02 10:13:07',NULL,'2025-12-02 10:13:07',NULL,NULL),(830,NULL,NULL,'37b8d1b39fe14c8d8b2a574880966ac4',NULL,NULL,NULL,NULL,'2025-12-02 10:13:08',NULL,'2025-12-02 10:13:08',NULL,NULL),(831,NULL,NULL,'6cb8407a90374945997c2012ab94bded',NULL,NULL,NULL,NULL,'2025-12-02 10:13:08',NULL,'2025-12-02 10:13:08',NULL,NULL),(832,NULL,'35eeb0abae1d4834a6cdba7142586966',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:08',NULL,'2025-12-02 10:13:08',NULL,NULL),(833,NULL,'a1854cb9cd7e49c4a6a223acc8d74075',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:08',NULL,'2025-12-02 10:13:08',NULL,NULL),(834,NULL,'b02ac233ae12415688cf9d451b55b171',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:09',NULL,'2025-12-02 10:13:09',NULL,NULL),(835,NULL,'c8c45d2f9d0e4d8dbf0acdb02159fa81',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:09',NULL,'2025-12-02 10:13:09',NULL,NULL),(836,NULL,NULL,'9589fe7bcd86443cb59c8eabe6353abf',NULL,NULL,NULL,NULL,'2025-12-02 10:13:09',NULL,'2025-12-02 10:13:09',NULL,NULL),(837,NULL,'5246e66c8815419f86ee0ab12d2b020a',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:09',NULL,'2025-12-02 10:13:09',NULL,NULL),(838,NULL,'b49a81aec3ba47f98ba171f12cd88b8a',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:10',NULL,'2025-12-02 10:13:10',NULL,NULL),(839,NULL,NULL,'6a311b31ecc34c5b93fe5ef51da17fe6',NULL,NULL,NULL,NULL,'2025-12-02 10:13:14',NULL,'2025-12-02 10:13:14',NULL,NULL),(840,NULL,NULL,'c505f014e69a4dabaf635c519323f680',NULL,NULL,NULL,NULL,'2025-12-02 10:13:15',NULL,'2025-12-02 10:13:15',NULL,NULL),(841,NULL,NULL,'007e8cbab0da4751b95812faf1ada295',NULL,NULL,NULL,NULL,'2025-12-02 10:13:15',NULL,'2025-12-02 10:13:15',NULL,NULL),(842,NULL,NULL,'b8aea6d12d784727907fad5ae880b441',NULL,NULL,NULL,NULL,'2025-12-02 10:13:15',NULL,'2025-12-02 10:13:15',NULL,NULL),(843,NULL,NULL,'d3dc5ddf85da478e96ea6b1050e9c02c',NULL,NULL,NULL,NULL,'2025-12-02 10:13:16',NULL,'2025-12-02 10:13:16',NULL,NULL),(844,NULL,NULL,'23732263b715449aa42be14967766489',NULL,NULL,NULL,NULL,'2025-12-02 10:13:16',NULL,'2025-12-02 10:13:16',NULL,NULL),(845,NULL,NULL,'35d5f045cd1e401ea7fac0f345f581f9',NULL,NULL,NULL,NULL,'2025-12-02 10:13:16',NULL,'2025-12-02 10:13:16',NULL,NULL),(846,NULL,NULL,'a3e996bd7b1b4a63bc9eb1519bed432a',NULL,NULL,NULL,NULL,'2025-12-02 10:13:16',NULL,'2025-12-02 10:13:16',NULL,NULL),(847,NULL,'e40b394d064942f593402333dc8c9581',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:17',NULL,'2025-12-02 10:13:17',NULL,NULL),(848,NULL,'9933838df9304fc8bbb9de94c910f2fc',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:18',NULL,'2025-12-02 10:13:18',NULL,NULL),(849,NULL,'e3ed2fd5caa246e28e24d993f3abdcd9',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:18',NULL,'2025-12-02 10:13:18',NULL,NULL),(850,NULL,'5dc48fcf1910469fb5fd4ca012e89438',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:19',NULL,'2025-12-02 10:13:19',NULL,NULL),(851,NULL,'a869185ee556492cb07313d539a5bbd5',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:19',NULL,'2025-12-02 10:13:19',NULL,NULL),(852,NULL,'92dcf60d90cb4405aa27200b97b2ff68',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:20',NULL,'2025-12-02 10:13:20',NULL,NULL),(853,NULL,NULL,'6cf3a64833cd4f439e3f01b13e4f235a',NULL,NULL,NULL,NULL,'2025-12-02 10:13:20',NULL,'2025-12-02 10:13:20',NULL,NULL),(854,NULL,NULL,'454e086f8fd14e7aaafbdbf8a93e4e58',NULL,NULL,NULL,NULL,'2025-12-02 10:13:20',NULL,'2025-12-02 10:13:20',NULL,NULL),(855,NULL,NULL,'fb6c45ae0e4b4c359e6ea41cecfc33c8',NULL,NULL,NULL,NULL,'2025-12-02 10:13:21',NULL,'2025-12-02 10:13:21',NULL,NULL),(856,NULL,NULL,'da7030dac3434a548760dd16ab870b94',NULL,NULL,NULL,NULL,'2025-12-02 10:13:21',NULL,'2025-12-02 10:13:21',NULL,NULL),(857,NULL,'b374ce45b6dc4bc5b2eac77a9216133f',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:21',NULL,'2025-12-02 10:13:21',NULL,NULL),(858,NULL,'3771b01f38d64dc8a93575e1196a090b',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:22',NULL,'2025-12-02 10:13:22',NULL,NULL),(859,NULL,NULL,'598e4e63290f4f79b9f44acef0a47955',NULL,NULL,NULL,NULL,'2025-12-02 10:13:23',NULL,'2025-12-02 10:13:23',NULL,NULL),(860,NULL,NULL,'324d06581654458a909023fe396c5fb9',NULL,NULL,NULL,NULL,'2025-12-02 10:13:23',NULL,'2025-12-02 10:13:23',NULL,NULL),(861,NULL,'a1e9341f44d842eebc66ae567e788c12',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:23',NULL,'2025-12-02 10:13:23',NULL,NULL),(862,NULL,NULL,'62325eee7c3447ffa2e5693cdbbfca10',NULL,NULL,NULL,NULL,'2025-12-02 10:13:23',NULL,'2025-12-02 10:13:23',NULL,NULL),(863,NULL,'0b576e76e8b7413ab7fb3bdd4adc0c0f',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:23',NULL,'2025-12-02 10:13:23',NULL,NULL),(864,NULL,'ead0658ec01944b2aae459c9c503a5fd',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:24',NULL,'2025-12-02 10:13:24',NULL,NULL),(865,NULL,'305af43764a942f3a90937bcebb7ba30',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:24',NULL,'2025-12-02 10:13:24',NULL,NULL),(866,NULL,'28da57ba9a214225ac9d449177166492',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:24',NULL,'2025-12-02 10:13:24',NULL,NULL),(867,NULL,NULL,'238c271d667b42a088f25238f876bb52',NULL,NULL,NULL,NULL,'2025-12-02 10:13:28',NULL,'2025-12-02 10:13:28',NULL,NULL),(868,NULL,NULL,'3435edf868e643beadab33f0d4abc9cb',NULL,NULL,NULL,NULL,'2025-12-02 10:13:28',NULL,'2025-12-02 10:13:28',NULL,NULL),(869,NULL,NULL,'e49255efa5ee433ebbe2d2dcf29d2667',NULL,NULL,NULL,NULL,'2025-12-02 10:13:28',NULL,'2025-12-02 10:13:28',NULL,NULL),(870,NULL,NULL,'39e11b4673e7483f8608ef23dc5fcd20',NULL,NULL,NULL,NULL,'2025-12-02 10:13:28',NULL,'2025-12-02 10:13:28',NULL,NULL),(871,NULL,NULL,'4f580b7292f344d7ae4303495eea4dc8',NULL,NULL,NULL,NULL,'2025-12-02 10:13:29',NULL,'2025-12-02 10:13:29',NULL,NULL),(872,NULL,NULL,'266902bf6842451db90f7876766ab62e',NULL,NULL,NULL,NULL,'2025-12-02 10:13:29',NULL,'2025-12-02 10:13:29',NULL,NULL),(873,NULL,'e2831d8feabb4564adab21de3f3fb99d',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:29',NULL,'2025-12-02 10:13:29',NULL,NULL),(874,NULL,NULL,'3ed0ae85a76d4ba289cbcace375f7f01',NULL,NULL,NULL,NULL,'2025-12-02 10:13:29',NULL,'2025-12-02 10:13:29',NULL,NULL),(875,NULL,NULL,'a1dc995164c143bd88134c597d43b9fd',NULL,NULL,NULL,NULL,'2025-12-02 10:13:29',NULL,'2025-12-02 10:13:29',NULL,NULL),(876,NULL,'feafb30848d44481ad2ec71abe700977',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:29',NULL,'2025-12-02 10:13:29',NULL,NULL),(877,NULL,'781edf24481d4fb7bc2e763f30613fc5',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:30',NULL,'2025-12-02 10:13:30',NULL,NULL),(878,NULL,'5bff174f213b47d6a382ce78ddaee28c',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:31',NULL,'2025-12-02 10:13:31',NULL,NULL),(879,NULL,'8ff22a276ec5464e8a97c8b3b0e8806c',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:31',NULL,'2025-12-02 10:13:31',NULL,NULL),(880,NULL,NULL,'dfe97465a2ae40738dd3719ac7e1d1ee',NULL,NULL,NULL,NULL,'2025-12-02 10:13:31',NULL,'2025-12-02 10:13:31',NULL,NULL),(881,NULL,'47a1d4c7ded84226b90db69b960affbd',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:32',NULL,'2025-12-02 10:13:32',NULL,NULL),(882,NULL,'87c6760774b94f1aa0f904bce5c0dbaa',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:33',NULL,'2025-12-02 10:13:33',NULL,NULL),(883,NULL,'4cf1bfdba62d4d0ca6bb6ecc2a250e5f',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:33',NULL,'2025-12-02 10:13:33',NULL,NULL),(884,NULL,NULL,'86937ce30d3d45b5945d6e347ef7c387',NULL,NULL,NULL,NULL,'2025-12-02 10:13:35',NULL,'2025-12-02 10:13:35',NULL,NULL),(885,NULL,NULL,'02b14129ff5d498d91e7e314b0e16c36',NULL,NULL,NULL,NULL,'2025-12-02 10:13:35',NULL,'2025-12-02 10:13:35',NULL,NULL),(886,NULL,NULL,'ee01aafea2514a9ea75308b565e11a48',NULL,NULL,NULL,NULL,'2025-12-02 10:13:35',NULL,'2025-12-02 10:13:35',NULL,NULL),(887,NULL,'5c626e80a854443da5093d561c8fdfd0',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:36',NULL,'2025-12-02 10:13:36',NULL,NULL),(888,NULL,'3d3f92369dfd45ccbc393c6493d5c2dc',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:37',NULL,'2025-12-02 10:13:37',NULL,NULL),(889,NULL,'57579d3eafe34f9cbb745f071b096fd1',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:37',NULL,'2025-12-02 10:13:37',NULL,NULL),(890,NULL,NULL,'55623fafab784a79af00338030920cfd',NULL,NULL,NULL,NULL,'2025-12-02 10:13:38',NULL,'2025-12-02 10:13:38',NULL,NULL),(891,NULL,NULL,'31ba3d1822544475bafdaa7175a4283b',NULL,NULL,NULL,NULL,'2025-12-02 10:13:38',NULL,'2025-12-02 10:13:38',NULL,NULL),(892,NULL,NULL,'43265c6a3a9d4dd3b97af32c32ce683e',NULL,NULL,NULL,NULL,'2025-12-02 10:13:39',NULL,'2025-12-02 10:13:39',NULL,NULL),(893,NULL,'a504541b7d87404c81c6a03298a409e2',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:40',NULL,'2025-12-02 10:13:40',NULL,NULL),(894,NULL,'a6a467ab9e7d4110b202951f4a2f76ea',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:40',NULL,'2025-12-02 10:13:40',NULL,NULL),(895,NULL,NULL,'5f6c741753344ec2aee778ce2302ea12',NULL,NULL,NULL,NULL,'2025-12-02 10:13:40',NULL,'2025-12-02 10:13:40',NULL,NULL),(896,NULL,'f01f26d352434e1898ddc5651f0257ce',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:40',NULL,'2025-12-02 10:13:40',NULL,NULL),(897,NULL,NULL,'50df96974d174fd3b0b7f3c080fd9374',NULL,NULL,NULL,NULL,'2025-12-02 10:13:40',NULL,'2025-12-02 10:13:40',NULL,NULL),(898,NULL,'7d1a3ada95ac4459b92b68a94bbdb1ea',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:41',NULL,'2025-12-02 10:13:41',NULL,NULL),(899,NULL,'9fa1fe5652674231b71ff7d942283137',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:42',NULL,'2025-12-02 10:13:42',NULL,NULL),(900,NULL,NULL,'8a48cd892c354d1695f4e180869e6d08',NULL,NULL,NULL,NULL,'2025-12-02 10:13:43',NULL,'2025-12-02 10:13:43',NULL,NULL),(901,NULL,'4ac3f69b39e24601806d0f601335ff31',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:43',NULL,'2025-12-02 10:13:43',NULL,NULL),(902,NULL,NULL,'3fb071ecc9f145d296f1e492cbb78dfd',NULL,NULL,NULL,NULL,'2025-12-02 10:13:44',NULL,'2025-12-02 10:13:44',NULL,NULL),(903,NULL,'39d4e8517ab743919bea01b6548564c2',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:45',NULL,'2025-12-02 10:13:45',NULL,NULL),(904,NULL,NULL,'13d3d919b23248d1a5835a3d1c8ecedb',NULL,NULL,NULL,NULL,'2025-12-02 10:13:51',NULL,'2025-12-02 10:13:51',NULL,NULL),(905,NULL,NULL,'7325e92a44d04ebd915170008755021d',NULL,NULL,NULL,NULL,'2025-12-02 10:13:52',NULL,'2025-12-02 10:13:52',NULL,NULL),(906,NULL,NULL,'f638f91dab21477d9fee9c349a4cf472',NULL,NULL,NULL,NULL,'2025-12-02 10:13:52',NULL,'2025-12-02 10:13:52',NULL,NULL),(907,NULL,NULL,'13db408ebc474b199e7a36b97782c50d',NULL,NULL,NULL,NULL,'2025-12-02 10:13:52',NULL,'2025-12-02 10:13:52',NULL,NULL),(908,NULL,'58b8f029a1134a12a75f33bc584b83dd',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:52',NULL,'2025-12-02 10:13:52',NULL,NULL),(909,NULL,'08ec4508e51e4b46972baa016cc404c1',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:53',NULL,'2025-12-02 10:13:53',NULL,NULL),(910,NULL,'e22b764b5ae94a9e9ee51d1ad2a8015d',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:53',NULL,'2025-12-02 10:13:53',NULL,NULL),(911,NULL,'1259cb721f554d769bcd146b925c03fd',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:54',NULL,'2025-12-02 10:13:54',NULL,NULL),(912,NULL,NULL,'1ea4e58d0f6b4f2a841e8a5da7272bdd',NULL,NULL,NULL,NULL,'2025-12-02 10:13:55',NULL,'2025-12-02 10:13:55',NULL,NULL),(913,NULL,NULL,'6599f549d6314314a2c5fcbe9e7d2679',NULL,NULL,NULL,NULL,'2025-12-02 10:13:55',NULL,'2025-12-02 10:13:55',NULL,NULL),(914,NULL,'69ac27088e5c47cabe1441ecc9b19c84',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:56',NULL,'2025-12-02 10:13:56',NULL,NULL),(915,NULL,'fd5e813e01924964aeaaaad80bfd60c0',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:13:57',NULL,'2025-12-02 10:13:57',NULL,NULL),(916,NULL,NULL,'e6083d93e35641799d5c5fac36ec5423',NULL,NULL,NULL,NULL,'2025-12-02 10:14:00',NULL,'2025-12-02 10:14:00',NULL,NULL),(917,NULL,NULL,'254db7c362e741e39ec7e26668cd4221',NULL,NULL,NULL,NULL,'2025-12-02 10:14:01',NULL,'2025-12-02 10:14:01',NULL,NULL),(918,NULL,NULL,'efcb577c5f75481eb71ffc29cbcd4a51',NULL,NULL,NULL,NULL,'2025-12-02 10:14:01',NULL,'2025-12-02 10:14:01',NULL,NULL),(919,NULL,'19840b2bb2f1448facc06ad6c92f7648',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:01',NULL,'2025-12-02 10:14:01',NULL,NULL),(920,NULL,'cde8aebdb4314bd393aabda884d10f04',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:02',NULL,'2025-12-02 10:14:02',NULL,NULL),(921,NULL,NULL,'b27f974843b944ad89618a9e837b7d08',NULL,NULL,NULL,NULL,'2025-12-02 10:14:02',NULL,'2025-12-02 10:14:02',NULL,NULL),(922,NULL,'2769bfe1e6304cc6a274457798d9813c',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:03',NULL,'2025-12-02 10:14:03',NULL,NULL),(923,NULL,NULL,'b2b52c71f95c4c7f9f4947cc8bfb0f4a',NULL,NULL,NULL,NULL,'2025-12-02 10:14:03',NULL,'2025-12-02 10:14:03',NULL,NULL),(924,NULL,NULL,'83f67449f93f48229d097f77f7ce07f7',NULL,NULL,NULL,NULL,'2025-12-02 10:14:03',NULL,'2025-12-02 10:14:03',NULL,NULL),(925,NULL,NULL,'1b4a891633ec4d619106657cfbf2d339',NULL,NULL,NULL,NULL,'2025-12-02 10:14:03',NULL,'2025-12-02 10:14:03',NULL,NULL),(926,NULL,NULL,'31987c502d834e248349282d068a1f7f',NULL,NULL,NULL,NULL,'2025-12-02 10:14:04',NULL,'2025-12-02 10:14:04',NULL,NULL),(927,NULL,'1d8a048450454feda5d5f8e5791593b2',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:04',NULL,'2025-12-02 10:14:04',NULL,NULL),(928,NULL,NULL,'596dce1ab82c415c8311bbce35461bec',NULL,NULL,NULL,NULL,'2025-12-02 10:14:04',NULL,'2025-12-02 10:14:04',NULL,NULL),(929,NULL,NULL,'820479883d9c44bb9bf3753c3d295af3',NULL,NULL,NULL,NULL,'2025-12-02 10:14:04',NULL,'2025-12-02 10:14:04',NULL,NULL),(930,NULL,'a09c6764dd264e5b95b20903df8c032a',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:05',NULL,'2025-12-02 10:14:05',NULL,NULL),(931,NULL,'e8295af6a4df4c97a379f21f43a2e9aa',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:05',NULL,'2025-12-02 10:14:05',NULL,NULL),(932,NULL,'59618d0a71be4bd7b90941ee9db2762c',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:06',NULL,'2025-12-02 10:14:06',NULL,NULL),(933,NULL,'f31ec8a71ed2440893e2d3342aa9dfb6',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:06',NULL,'2025-12-02 10:14:06',NULL,NULL),(934,NULL,NULL,'6ac423acbe57498aaf3586482c5992b8',NULL,NULL,NULL,NULL,'2025-12-02 10:14:06',NULL,'2025-12-02 10:14:06',NULL,NULL),(935,NULL,'581d96acda8243f084e60850d5857c40',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:07',NULL,'2025-12-02 10:14:07',NULL,NULL),(936,NULL,NULL,'e44467f4ce75469b9c64b22980d430e6',NULL,NULL,NULL,NULL,'2025-12-02 10:14:07',NULL,'2025-12-02 10:14:07',NULL,NULL),(937,NULL,'869f22f9178141beb0f1e951458596ec',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:07',NULL,'2025-12-02 10:14:07',NULL,NULL),(938,NULL,NULL,'d016c15d3d974e96a92aba8f92faa8f0',NULL,NULL,NULL,NULL,'2025-12-02 10:14:08',NULL,'2025-12-02 10:14:08',NULL,NULL),(939,NULL,'63c7f2791a944586a7e72be151acab0a',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:08',NULL,'2025-12-02 10:14:08',NULL,NULL),(940,NULL,'71e8ee73bd0b49dca2e2d3171d5ca254',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:09',NULL,'2025-12-02 10:14:09',NULL,NULL),(941,NULL,NULL,'e4243dacfd0e453ba39e4eae136cb7cc',NULL,NULL,NULL,NULL,'2025-12-02 10:14:10',NULL,'2025-12-02 10:14:10',NULL,NULL),(942,NULL,NULL,'0e8b63c8d4794f7d8443e7392bf8e840',NULL,NULL,NULL,NULL,'2025-12-02 10:14:11',NULL,'2025-12-02 10:14:11',NULL,NULL),(943,NULL,'ffd5a1cba9ce49db91a108c84efa0d69',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:12',NULL,'2025-12-02 10:14:12',NULL,NULL),(944,NULL,'8f287097241a4419b0923dfc81ea1206',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:13',NULL,'2025-12-02 10:14:13',NULL,NULL),(945,NULL,NULL,'39db0e866d3844119f05692e3a798757',NULL,NULL,NULL,NULL,'2025-12-02 10:14:13',NULL,'2025-12-02 10:14:13',NULL,NULL),(946,NULL,NULL,'0349a1249d9e4834a6dda16f73f5ab9b',NULL,NULL,NULL,NULL,'2025-12-02 10:14:14',NULL,'2025-12-02 10:14:14',NULL,NULL),(947,NULL,'b4df09e6b9f146938d0dca54a22ade8b',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:14',NULL,'2025-12-02 10:14:14',NULL,NULL),(948,NULL,'01d8a78b062e4c02b49d2512dd6659ad',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:15',NULL,'2025-12-02 10:14:15',NULL,NULL),(949,NULL,NULL,'bf1f731b6e2443d9ba66d731e2993461',NULL,NULL,NULL,NULL,'2025-12-02 10:14:16',NULL,'2025-12-02 10:14:16',NULL,NULL),(950,NULL,NULL,'b41cd952137948d4a6b62e2472df33b7',NULL,NULL,NULL,NULL,'2025-12-02 10:14:17',NULL,'2025-12-02 10:14:17',NULL,NULL),(951,NULL,'c3e4b2ef1e4d459f877d94ef0f0aa310',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:18',NULL,'2025-12-02 10:14:18',NULL,NULL),(952,NULL,NULL,'dbaeaeed65b44f5f85d2e43c20bd916e',NULL,NULL,NULL,NULL,'2025-12-02 10:14:20',NULL,'2025-12-02 10:14:20',NULL,NULL),(953,NULL,NULL,'776a40b1dcfc4d628af781d4fd5c60f8',NULL,NULL,NULL,NULL,'2025-12-02 10:14:20',NULL,'2025-12-02 10:14:20',NULL,NULL),(954,NULL,NULL,'8bb4640171e447f59f5305a2417086e0',NULL,NULL,NULL,NULL,'2025-12-02 10:14:20',NULL,'2025-12-02 10:14:20',NULL,NULL),(955,NULL,NULL,'ac0529c7eae744189ab8cd005b855f04',NULL,NULL,NULL,NULL,'2025-12-02 10:14:20',NULL,'2025-12-02 10:14:20',NULL,NULL),(956,NULL,'5974c1b38c02486098e277d58b491dac',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:21',NULL,'2025-12-02 10:14:21',NULL,NULL),(957,NULL,'82445c1a56474ba497d07340322dbade',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:21',NULL,'2025-12-02 10:14:21',NULL,NULL),(958,NULL,'d355916a0622452bb288d2caa410af4b',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:21',NULL,'2025-12-02 10:14:21',NULL,NULL),(959,NULL,'2879e0f72e1e4ba89d311a8e5004e099',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:22',NULL,'2025-12-02 10:14:22',NULL,NULL),(960,NULL,NULL,'bfdfe61a0fad446995f4c33aa546c141',NULL,NULL,NULL,NULL,'2025-12-02 10:14:22',NULL,'2025-12-02 10:14:22',NULL,NULL),(961,NULL,NULL,'a916aafc495a42939a525ab8cc5f168b',NULL,NULL,NULL,NULL,'2025-12-02 10:14:23',NULL,'2025-12-02 10:14:23',NULL,NULL),(962,NULL,NULL,'a96ce978df8f4d5e872bc49cae580ab0',NULL,NULL,NULL,NULL,'2025-12-02 10:14:23',NULL,'2025-12-02 10:14:23',NULL,NULL),(963,NULL,NULL,'709762ea072142d9a0ab9d655be2fd0c',NULL,NULL,NULL,NULL,'2025-12-02 10:14:23',NULL,'2025-12-02 10:14:23',NULL,NULL),(964,NULL,'5a1f678938fb4170b044848d92d84806',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:24',NULL,'2025-12-02 10:14:24',NULL,NULL),(965,NULL,'c3301394eb684d2c891be33b41e1985c',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:25',NULL,'2025-12-02 10:14:25',NULL,NULL),(966,NULL,'c1454db2087142aea674fd292a3fffd7',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:26',NULL,'2025-12-02 10:14:26',NULL,NULL),(967,NULL,NULL,'2427e1aacd81409a8737b719b7ca0cc4',NULL,NULL,NULL,NULL,'2025-12-02 10:14:29',NULL,'2025-12-02 10:14:29',NULL,NULL),(968,NULL,'7802c5d475c340108c03692a915d91ab',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:30',NULL,'2025-12-02 10:14:30',NULL,NULL),(969,NULL,NULL,'6430907286844e3f97d51bddf609b2c3',NULL,NULL,NULL,NULL,'2025-12-02 10:14:30',NULL,'2025-12-02 10:14:30',NULL,NULL),(970,NULL,NULL,'3919095c434c4192b232ee00fa400d62',NULL,NULL,NULL,NULL,'2025-12-02 10:14:30',NULL,'2025-12-02 10:14:30',NULL,NULL),(971,NULL,NULL,'d29598da103845beb45eceeffe4a48e9',NULL,NULL,NULL,NULL,'2025-12-02 10:14:31',NULL,'2025-12-02 10:14:31',NULL,NULL),(972,NULL,NULL,'667bf85110b842619270e6d859cce20e',NULL,NULL,NULL,NULL,'2025-12-02 10:14:31',NULL,'2025-12-02 10:14:31',NULL,NULL),(973,NULL,'600b0ae9c20446cfb651f6fd6b60ebf7',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:32',NULL,'2025-12-02 10:14:32',NULL,NULL),(974,NULL,'2d0a5b05524044da96198b77129c550f',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:33',NULL,'2025-12-02 10:14:33',NULL,NULL),(975,NULL,NULL,'f09433683fb24c2ebdf9bc49eb20f9fe',NULL,NULL,NULL,NULL,'2025-12-02 10:14:33',NULL,'2025-12-02 10:14:33',NULL,NULL),(976,NULL,NULL,'f2cff7ece9574fa997525a5363ecba58',NULL,NULL,NULL,NULL,'2025-12-02 10:14:33',NULL,'2025-12-02 10:14:33',NULL,NULL),(977,NULL,'f93ec9c5eebe4f50ad8af9b225d7c97d',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:33',NULL,'2025-12-02 10:14:33',NULL,NULL),(978,NULL,NULL,'98e8c0f3c9314727af16568dd6a79b23',NULL,NULL,NULL,NULL,'2025-12-02 10:14:33',NULL,'2025-12-02 10:14:33',NULL,NULL),(979,NULL,NULL,'2bab38cd1afa4f1cb56ae5e3471916e7',NULL,NULL,NULL,NULL,'2025-12-02 10:14:34',NULL,'2025-12-02 10:14:34',NULL,NULL),(980,NULL,NULL,'7c253b4d05e4467b847ce7c505213640',NULL,NULL,NULL,NULL,'2025-12-02 10:14:34',NULL,'2025-12-02 10:14:34',NULL,NULL),(981,NULL,'87cdd4c8f591435eb43e3200734202e3',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:35',NULL,'2025-12-02 10:14:35',NULL,NULL),(982,NULL,'d3daa40d2d6446d8b0b46a9f7d1b779c',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:35',NULL,'2025-12-02 10:14:35',NULL,NULL),(983,NULL,'df9ee7b103694e4098779bd8372f8290',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:36',NULL,'2025-12-02 10:14:36',NULL,NULL),(984,NULL,'914633b51dfe4f69869861586a905b4f',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:36',NULL,'2025-12-02 10:14:36',NULL,NULL),(985,NULL,NULL,'cfa340769a434813a589cf5cb369e58c',NULL,NULL,NULL,NULL,'2025-12-02 10:14:37',NULL,'2025-12-02 10:14:37',NULL,NULL),(986,NULL,NULL,'5f42fec11e6847ea8673190cff026776',NULL,NULL,NULL,NULL,'2025-12-02 10:14:38',NULL,'2025-12-02 10:14:38',NULL,NULL),(987,NULL,'ab2f308df5874752ab8cc95304b7b442',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:38',NULL,'2025-12-02 10:14:38',NULL,NULL),(988,NULL,NULL,'e3ca56c7989448c2b6be391e31145f68',NULL,NULL,NULL,NULL,'2025-12-02 10:14:38',NULL,'2025-12-02 10:14:38',NULL,NULL),(989,NULL,'680813e2a2a84d78b0da5d342341d9de',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:40',NULL,'2025-12-02 10:14:40',NULL,NULL),(990,NULL,'e48c710a07d44ccaacd6a0000552431f',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:40',NULL,'2025-12-02 10:14:40',NULL,NULL),(991,NULL,NULL,'a78b3231fca24b318b03dc4279d5d8cb',NULL,NULL,NULL,NULL,'2025-12-02 10:14:40',NULL,'2025-12-02 10:14:40',NULL,NULL),(992,NULL,NULL,'b41f54a62e314c89b6dc61da524ce6a0',NULL,NULL,NULL,NULL,'2025-12-02 10:14:40',NULL,'2025-12-02 10:14:40',NULL,NULL),(993,NULL,NULL,'bd7f2d7611734550bbffc82296b63298',NULL,NULL,NULL,NULL,'2025-12-02 10:14:41',NULL,'2025-12-02 10:14:41',NULL,NULL),(994,NULL,NULL,'53feb72501b148b989e22738c35c219a',NULL,NULL,NULL,NULL,'2025-12-02 10:14:41',NULL,'2025-12-02 10:14:41',NULL,NULL),(995,NULL,NULL,'70e2b1dfbabb46d7b1c3bacd5d041441',NULL,NULL,NULL,NULL,'2025-12-02 10:14:41',NULL,'2025-12-02 10:14:41',NULL,NULL),(996,NULL,'1f4c09d4ce264431bace503138c2a3d8',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:42',NULL,'2025-12-02 10:14:42',NULL,NULL),(997,NULL,'24ac1781155f4fea88a6f164416db6ad',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:42',NULL,'2025-12-02 10:14:42',NULL,NULL),(998,NULL,'5cb28086132244a49c983f6a1ef1a2c7',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:43',NULL,'2025-12-02 10:14:43',NULL,NULL),(999,NULL,NULL,'80055057d3334d79b4ec399b6ec47eb2',NULL,NULL,NULL,NULL,'2025-12-02 10:14:44',NULL,'2025-12-02 10:14:44',NULL,NULL),(1000,NULL,'2f5b0cb9136e40b1a7b70e89b03f2784',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:44',NULL,'2025-12-02 10:14:44',NULL,NULL),(1001,NULL,'c6aa517591c04b06b5e1e3687ce880ca',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:46',NULL,'2025-12-02 10:14:46',NULL,NULL),(1002,NULL,NULL,'9dc44de9c1694d0880c9c400df70c347',NULL,NULL,NULL,NULL,'2025-12-02 10:14:46',NULL,'2025-12-02 10:14:46',NULL,NULL),(1003,NULL,NULL,'35386000a13e4e739e336bacc446a9fe',NULL,NULL,NULL,NULL,'2025-12-02 10:14:47',NULL,'2025-12-02 10:14:47',NULL,NULL),(1004,NULL,NULL,'9064c1cecce64c50977343601c86109a',NULL,NULL,NULL,NULL,'2025-12-02 10:14:47',NULL,'2025-12-02 10:14:47',NULL,NULL),(1005,NULL,NULL,'423830aa66594acbb6b95080a6ae0f31',NULL,NULL,NULL,NULL,'2025-12-02 10:14:47',NULL,'2025-12-02 10:14:47',NULL,NULL),(1006,NULL,'bd0fe1f05c454e94a3b40a85f9b8db6b',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:48',NULL,'2025-12-02 10:14:48',NULL,NULL),(1007,NULL,'0f06f36cde094385854095cf905ed5a1',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:49',NULL,'2025-12-02 10:14:49',NULL,NULL),(1008,NULL,'bc3250c33dc7401d971286565e9e1d7f',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:50',NULL,'2025-12-02 10:14:50',NULL,NULL),(1009,NULL,NULL,'e5f9efc25c2f429b88d457b8d00284c5',NULL,NULL,NULL,NULL,'2025-12-02 10:14:52',NULL,'2025-12-02 10:14:52',NULL,NULL),(1010,NULL,'4f17a1ad0b084f0d84e3bb7ba9e4c0a5',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:53',NULL,'2025-12-02 10:14:53',NULL,NULL),(1011,NULL,NULL,'404a2149cc4c442e8f29fae023953b63',NULL,NULL,NULL,NULL,'2025-12-02 10:14:55',NULL,'2025-12-02 10:14:55',NULL,NULL),(1012,NULL,'6b9f3a4e12754a9ab7a5077a3e0bb303',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:56',NULL,'2025-12-02 10:14:56',NULL,NULL),(1013,NULL,NULL,'f8ea5a6cf48a46f8ad51b1bbd35d9acb',NULL,NULL,NULL,NULL,'2025-12-02 10:14:56',NULL,'2025-12-02 10:14:56',NULL,NULL),(1014,NULL,NULL,'0f1b5741e06849589fa2d1a488d49912',NULL,NULL,NULL,NULL,'2025-12-02 10:14:58',NULL,'2025-12-02 10:14:58',NULL,NULL),(1015,NULL,'606f7f1fe6cf46588bbaad520d704fc7',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:14:59',NULL,'2025-12-02 10:14:59',NULL,NULL),(1016,NULL,NULL,'1d8207a154d44ecb9d5c590855f388a3',NULL,NULL,NULL,NULL,'2025-12-02 10:14:59',NULL,'2025-12-02 10:14:59',NULL,NULL),(1017,NULL,NULL,'fbf6b461791a43fab13e6d1ef1e44841',NULL,NULL,NULL,NULL,'2025-12-02 10:14:59',NULL,'2025-12-02 10:14:59',NULL,NULL),(1018,NULL,NULL,'b3e7613022db4a16af3c27054f7cba19',NULL,NULL,NULL,NULL,'2025-12-02 10:14:59',NULL,'2025-12-02 10:14:59',NULL,NULL),(1019,NULL,NULL,'ee2b07f2384243d2949ba9281391b15d',NULL,NULL,NULL,NULL,'2025-12-02 10:15:00',NULL,'2025-12-02 10:15:00',NULL,NULL),(1020,NULL,NULL,'1a03624069ce41fcb02f5e929815f66c',NULL,NULL,NULL,NULL,'2025-12-02 10:15:00',NULL,'2025-12-02 10:15:00',NULL,NULL),(1021,NULL,NULL,'5a4ffd82c4c24c2587d854131df4eab6',NULL,NULL,NULL,NULL,'2025-12-02 10:15:00',NULL,'2025-12-02 10:15:00',NULL,NULL),(1022,NULL,NULL,'030cb4ebf1fe41009762faaa2f4489d9',NULL,NULL,NULL,NULL,'2025-12-02 10:15:00',NULL,'2025-12-02 10:15:00',NULL,NULL),(1023,NULL,'568259592f9d4af3ac66f6b377518d3f',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:15:01',NULL,'2025-12-02 10:15:01',NULL,NULL),(1024,NULL,'81a3652958594804ada31072f54e92d3',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:15:02',NULL,'2025-12-02 10:15:02',NULL,NULL),(1025,NULL,'f82ed8e61a03432eb2f0b90214f9a596',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:15:02',NULL,'2025-12-02 10:15:02',NULL,NULL),(1026,NULL,'5cdb1413e33f45cd8056ae0098190bd6',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:15:03',NULL,'2025-12-02 10:15:03',NULL,NULL),(1027,NULL,'8f75117f8554499b9fbaa9c9062eeeef',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:15:03',NULL,'2025-12-02 10:15:03',NULL,NULL),(1028,NULL,'9a8b0c4aff074ed58f35626438cb8bb8',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:15:04',NULL,'2025-12-02 10:15:04',NULL,NULL),(1029,NULL,NULL,'9c08c72fcacd48ad998af0d5c8512e6f',NULL,NULL,NULL,NULL,'2025-12-02 10:15:08',NULL,'2025-12-02 10:15:08',NULL,NULL),(1030,NULL,NULL,'4cbbe0eaef1b41a7b95d0ed3e086fd6f',NULL,NULL,NULL,NULL,'2025-12-02 10:15:09',NULL,'2025-12-02 10:15:09',NULL,NULL),(1031,NULL,NULL,'3dc54e36744249d9bd25316517e80c9a',NULL,NULL,NULL,NULL,'2025-12-02 10:15:09',NULL,'2025-12-02 10:15:09',NULL,NULL),(1032,NULL,NULL,'7dcaaa136bb044f4a0a1ba2c2176a104',NULL,NULL,NULL,NULL,'2025-12-02 10:15:09',NULL,'2025-12-02 10:15:09',NULL,NULL),(1033,NULL,'803e3141d7b54aab8883a4031dcf0b91',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:15:10',NULL,'2025-12-02 10:15:10',NULL,NULL),(1034,NULL,'8b10b6f7b13b42babfc0501291b9e119',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:15:11',NULL,'2025-12-02 10:15:11',NULL,NULL),(1035,NULL,'4b9edecbe0aa46d7adb640f9e9f8a338',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:15:11',NULL,'2025-12-02 10:15:11',NULL,NULL),(1036,NULL,NULL,'c2758d3045d64bb885f7e1073cae24d2',NULL,NULL,NULL,NULL,'2025-12-02 10:15:17',NULL,'2025-12-02 10:15:17',NULL,NULL),(1037,NULL,NULL,'98ea0090b3f5415e9d68555dc2519917',NULL,NULL,NULL,NULL,'2025-12-02 10:15:18',NULL,'2025-12-02 10:15:18',NULL,NULL),(1038,NULL,NULL,'4795c0f055da447cacc9c68ea680e058',NULL,NULL,NULL,NULL,'2025-12-02 10:15:18',NULL,'2025-12-02 10:15:18',NULL,NULL),(1039,NULL,NULL,'99484e7a77b4432499314f84043c307f',NULL,NULL,NULL,NULL,'2025-12-02 10:15:18',NULL,'2025-12-02 10:15:18',NULL,NULL),(1040,NULL,'0bfe1d44b4fe440d8a4111e258193bdb',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:15:20',NULL,'2025-12-02 10:15:20',NULL,NULL),(1041,NULL,'8d1840b874c34e9bbd960123e78a81f8',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:15:21',NULL,'2025-12-02 10:15:21',NULL,NULL),(1042,NULL,'2663dddab79d4a678692e6a4e964573c',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:15:22',NULL,'2025-12-02 10:15:22',NULL,NULL),(1043,NULL,NULL,'d2df4099922942d7b322927451f656cd',NULL,NULL,NULL,NULL,'2025-12-02 10:15:26',NULL,'2025-12-02 10:15:26',NULL,NULL),(1044,NULL,NULL,'d86d21d12c60422388c88b89a5f5a72b',NULL,NULL,NULL,NULL,'2025-12-02 10:15:31',NULL,'2025-12-02 10:15:31',NULL,NULL),(1045,NULL,NULL,'fb7fbe93d5b34afb91f154a1f8487fed',NULL,NULL,NULL,NULL,'2025-12-02 10:15:31',NULL,'2025-12-02 10:15:31',NULL,NULL),(1046,NULL,NULL,'df304ac4dbbf4ce79e2d8162bc111ca2',NULL,NULL,NULL,NULL,'2025-12-02 10:15:31',NULL,'2025-12-02 10:15:31',NULL,NULL),(1047,NULL,NULL,'54261257af1d4bfa8ae041d98eccc39b',NULL,NULL,NULL,NULL,'2025-12-02 10:15:31',NULL,'2025-12-02 10:15:31',NULL,NULL),(1048,NULL,'e2b01d84c7534692a4ed64d63b22bb4e',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:15:32',NULL,'2025-12-02 10:15:32',NULL,NULL),(1049,NULL,NULL,'8186b016983446bb95a4c7821dfa53bb',NULL,NULL,NULL,NULL,'2025-12-02 10:15:33',NULL,'2025-12-02 10:15:33',NULL,NULL),(1050,NULL,'0b32cd87dd524969aa3834556f94f2e3',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:15:33',NULL,'2025-12-02 10:15:33',NULL,NULL),(1051,NULL,NULL,'51dd5dbcf1cf40b8952a94fcac55d7e8',NULL,NULL,NULL,NULL,'2025-12-02 10:15:33',NULL,'2025-12-02 10:15:33',NULL,NULL),(1052,NULL,NULL,'fd07778a056740c2b22663cf3fd8248a',NULL,NULL,NULL,NULL,'2025-12-02 10:15:33',NULL,'2025-12-02 10:15:33',NULL,NULL),(1053,NULL,NULL,'9e01505ccbbc4530a563b8dd9af0f2cb',NULL,NULL,NULL,NULL,'2025-12-02 10:15:33',NULL,'2025-12-02 10:15:33',NULL,NULL),(1054,NULL,'7e6f29bbe0f44b04ada8cc16426d3961',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:15:34',NULL,'2025-12-02 10:15:34',NULL,NULL),(1055,NULL,'dfe29c261aed4241b904ae18b37ba3d3',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:15:34',NULL,'2025-12-02 10:15:34',NULL,NULL),(1056,NULL,'45a0b194050e4cec9500b394e4961f2f',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:15:35',NULL,'2025-12-02 10:15:35',NULL,NULL),(1057,NULL,'18e2a69daf6849dead0b925033d0fbad',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:15:35',NULL,'2025-12-02 10:15:35',NULL,NULL),(1058,NULL,NULL,'3eaa9b620f82446a9e8acc7923ef592a',NULL,NULL,NULL,NULL,'2025-12-02 10:15:39',NULL,'2025-12-02 10:15:39',NULL,NULL),(1059,NULL,NULL,'d7bdcaad138e4282bbb43146b5297bb4',NULL,NULL,NULL,NULL,'2025-12-02 10:15:39',NULL,'2025-12-02 10:15:39',NULL,NULL),(1060,NULL,NULL,'0605a3c7f15b406ca4d0221ca479b008',NULL,NULL,NULL,NULL,'2025-12-02 10:15:39',NULL,'2025-12-02 10:15:39',NULL,NULL),(1061,NULL,NULL,'1ac2010f7391468ab6553cc1ddb4cdf3',NULL,NULL,NULL,NULL,'2025-12-02 10:15:39',NULL,'2025-12-02 10:15:39',NULL,NULL),(1062,NULL,NULL,'495e92f347994b92b115e46dbd6cbb52',NULL,NULL,NULL,NULL,'2025-12-02 10:15:40',NULL,'2025-12-02 10:15:40',NULL,NULL),(1063,NULL,NULL,'9be272c30c344868a142dc076644158e',NULL,NULL,NULL,NULL,'2025-12-02 10:15:40',NULL,'2025-12-02 10:15:40',NULL,NULL),(1064,NULL,NULL,'6e327741dea24689b14f78023e492cc6',NULL,NULL,NULL,NULL,'2025-12-02 10:15:40',NULL,'2025-12-02 10:15:40',NULL,NULL),(1065,NULL,'935e69f44b8e4b6d88fd34e9a0c64d2c',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:15:40',NULL,'2025-12-02 10:15:40',NULL,NULL),(1066,NULL,NULL,'9c3b5613133641aca048bb6a5e377268',NULL,NULL,NULL,NULL,'2025-12-02 10:15:41',NULL,'2025-12-02 10:15:41',NULL,NULL),(1067,NULL,'a3df1af7899b4210b0232da11198a30c',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:15:41',NULL,'2025-12-02 10:15:41',NULL,NULL),(1068,NULL,'6d64c616013346489db0e3bda92b8d14',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:15:41',NULL,'2025-12-02 10:15:41',NULL,NULL),(1069,NULL,NULL,'d125d0d7e300497e8f7f2f98147d0938',NULL,NULL,NULL,NULL,'2025-12-02 10:15:41',NULL,'2025-12-02 10:15:41',NULL,NULL),(1070,NULL,NULL,'7cac3db2b4784cb1b87873b393b6cb22',NULL,NULL,NULL,NULL,'2025-12-02 10:15:41',NULL,'2025-12-02 10:15:41',NULL,NULL),(1071,NULL,NULL,'a6fa8d3ceafd4a128332e072de1fb397',NULL,NULL,NULL,NULL,'2025-12-02 10:15:41',NULL,'2025-12-02 10:15:41',NULL,NULL),(1072,NULL,'b20460cff946456dbc73e23ed6e1f068',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:15:41',NULL,'2025-12-02 10:15:41',NULL,NULL),(1073,NULL,'3f0c5b098b98475bba2519f5207076fc',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:15:42',NULL,'2025-12-02 10:15:42',NULL,NULL),(1074,NULL,'32417f6553fc428dbe10f4ed2e459ca9',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:15:42',NULL,'2025-12-02 10:15:42',NULL,NULL),(1075,NULL,'7eed616d73ab4e4787ac3b5f13befa7f',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:15:43',NULL,'2025-12-02 10:15:43',NULL,NULL),(1076,NULL,'7cdbc8c45bd44d0ebae198b85a169b0b',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:15:43',NULL,'2025-12-02 10:15:43',NULL,NULL),(1077,NULL,'74df0286254640de953a133459651af5',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:15:44',NULL,'2025-12-02 10:15:44',NULL,NULL),(1078,NULL,NULL,'e0cc3a782294460f81e6ba5c63b7ff7d',NULL,NULL,NULL,NULL,'2025-12-02 10:15:59',NULL,'2025-12-02 10:15:59',NULL,NULL),(1079,NULL,NULL,'24c47aecbdff44308c373aa236884c2c',NULL,NULL,NULL,NULL,'2025-12-02 10:16:01',NULL,'2025-12-02 10:16:01',NULL,NULL),(1080,NULL,'a48911a05afc41f69da64e742cd44999',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:16:02',NULL,'2025-12-02 10:16:02',NULL,NULL),(1081,NULL,NULL,'91e7ff366abc418e82457ff80b8138e8',NULL,NULL,NULL,NULL,'2025-12-02 10:16:04',NULL,'2025-12-02 10:16:04',NULL,NULL),(1082,NULL,NULL,'4a0f0068dfbf4aeda3ed84f95d1f1226',NULL,NULL,NULL,NULL,'2025-12-02 10:16:04',NULL,'2025-12-02 10:16:04',NULL,NULL),(1083,NULL,NULL,'bb93ce39d4d54c7380f75f22f5ffc493',NULL,NULL,NULL,NULL,'2025-12-02 10:16:08',NULL,'2025-12-02 10:16:08',NULL,NULL),(1084,NULL,NULL,'7572e847e8624bc8ae7c09e5a1658105',NULL,NULL,NULL,NULL,'2025-12-02 10:16:08',NULL,'2025-12-02 10:16:08',NULL,NULL),(1085,NULL,NULL,'0e5c738ba752455b908099b234a743a2',NULL,NULL,NULL,NULL,'2025-12-02 10:16:08',NULL,'2025-12-02 10:16:08',NULL,NULL),(1086,NULL,NULL,'681ae5f7e8684992aa179528ddc6b32d',NULL,NULL,NULL,NULL,'2025-12-02 10:16:09',NULL,'2025-12-02 10:16:09',NULL,NULL),(1087,NULL,'d858413a9b01463f96545916d2abe5ab',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:16:09',NULL,'2025-12-02 10:16:09',NULL,NULL),(1088,NULL,'d0cb14adcb1d40be835374d4f73a3980',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:16:11',NULL,'2025-12-02 10:16:11',NULL,NULL),(1089,NULL,'82d5a09e66904b8ca3c7a7850f1e5c52',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:16:12',NULL,'2025-12-02 10:16:12',NULL,NULL),(1090,NULL,NULL,'7c87e5c44dfa4bd3835e77bc991eb253',NULL,NULL,NULL,NULL,'2025-12-02 10:16:12',NULL,'2025-12-02 10:16:12',NULL,NULL),(1091,NULL,NULL,'19c2bca62a264b93add0d8ce170a4fe5',NULL,NULL,NULL,NULL,'2025-12-02 10:16:12',NULL,'2025-12-02 10:16:12',NULL,NULL),(1092,NULL,NULL,'c208c9ff94e54685a5828b7351252d2c',NULL,NULL,NULL,NULL,'2025-12-02 10:16:12',NULL,'2025-12-02 10:16:12',NULL,NULL),(1093,NULL,'574b5a3979ed4e2693c937d0bb9f52e6',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:16:13',NULL,'2025-12-02 10:16:13',NULL,NULL),(1094,NULL,'6a1e4b81631b44ebb17a2df8b26c2dff',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:16:13',NULL,'2025-12-02 10:16:13',NULL,NULL),(1095,NULL,'0fe90f11d3f64e12b3591732792a929e',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:16:14',NULL,'2025-12-02 10:16:14',NULL,NULL),(1096,NULL,'3212fac1e026474b9022ee93e4d925a9',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:16:16',NULL,'2025-12-02 10:16:16',NULL,NULL),(1097,NULL,NULL,'4cf4e412f7aa4b38937a59c19a460b6a',NULL,NULL,NULL,NULL,'2025-12-02 10:16:17',NULL,'2025-12-02 10:16:17',NULL,NULL),(1098,NULL,'9357d59432e04f9791424e201b9754ce',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:16:18',NULL,'2025-12-02 10:16:18',NULL,NULL),(1099,NULL,NULL,'cfa3920d766b4ec1973d109461e2ec48',NULL,NULL,NULL,NULL,'2025-12-02 10:16:25',NULL,'2025-12-02 10:16:25',NULL,NULL),(1100,NULL,NULL,'49675d955284452588b26b0e42d86f89',NULL,NULL,NULL,NULL,'2025-12-02 10:16:27',NULL,'2025-12-02 10:16:27',NULL,NULL),(1101,NULL,NULL,'8aa465fecdf848ae8229ba851f88189e',NULL,NULL,NULL,NULL,'2025-12-02 10:16:30',NULL,'2025-12-02 10:16:30',NULL,NULL),(1102,NULL,NULL,'7bf2ec0c4888436e9a8405e0af53b9e7',NULL,NULL,NULL,NULL,'2025-12-02 10:16:30',NULL,'2025-12-02 10:16:30',NULL,NULL),(1103,NULL,NULL,'c911a75716f5426cb9cea74e1d267692',NULL,NULL,NULL,NULL,'2025-12-02 10:16:31',NULL,'2025-12-02 10:16:31',NULL,NULL),(1104,NULL,'8f15fa0d04d94578bf27407ff42606e9',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:16:32',NULL,'2025-12-02 10:16:32',NULL,NULL),(1105,NULL,NULL,'3981613749ea480688db1adf3b6b82ce',NULL,NULL,NULL,NULL,'2025-12-02 10:16:32',NULL,'2025-12-02 10:16:32',NULL,NULL),(1106,NULL,NULL,'f098da89326b48b98839e4ec312c7db1',NULL,NULL,NULL,NULL,'2025-12-02 10:16:32',NULL,'2025-12-02 10:16:32',NULL,NULL),(1107,NULL,NULL,'c7407d9263dc40cb93e4964410aac4dc',NULL,NULL,NULL,NULL,'2025-12-02 10:16:32',NULL,'2025-12-02 10:16:32',NULL,NULL),(1108,NULL,'bfcbbd8f1eff4222a4150395f94d1be1',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:16:32',NULL,'2025-12-02 10:16:32',NULL,NULL),(1109,NULL,'018c12fa80d7414db7ba8c84312e099f',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:16:33',NULL,'2025-12-02 10:16:33',NULL,NULL),(1110,NULL,'b31e3e8e51f444a39bb4d004b43f444e',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:16:33',NULL,'2025-12-02 10:16:33',NULL,NULL),(1111,NULL,'a4ee0a8d50e749c6a682c72b02a206ee',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:16:34',NULL,'2025-12-02 10:16:34',NULL,NULL),(1112,NULL,'42ab83296c4741bfa1dbb24e1dcf2c90',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:16:34',NULL,'2025-12-02 10:16:34',NULL,NULL),(1113,NULL,NULL,'d919e3e87bf64fddab742e47713bbb00',NULL,NULL,NULL,NULL,'2025-12-02 10:16:35',NULL,'2025-12-02 10:16:35',NULL,NULL),(1114,NULL,NULL,'f7fbed0a9496494283740854e0b2c37d',NULL,NULL,NULL,NULL,'2025-12-02 10:16:36',NULL,'2025-12-02 10:16:36',NULL,NULL),(1115,NULL,'e0812c1e05a343cc88d13d7d927fd7ea',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:16:36',NULL,'2025-12-02 10:16:36',NULL,NULL),(1116,NULL,NULL,'e4bf2ca10bb9417c9ba9982c06517f09',NULL,NULL,NULL,NULL,'2025-12-02 10:16:39',NULL,'2025-12-02 10:16:39',NULL,NULL),(1117,NULL,NULL,'f12d2846ae474441b6b6565e5d0757eb',NULL,NULL,NULL,NULL,'2025-12-02 10:16:39',NULL,'2025-12-02 10:16:39',NULL,NULL),(1118,NULL,NULL,'8bd1479046b84ab0b8e361b1ea12eb81',NULL,NULL,NULL,NULL,'2025-12-02 10:16:39',NULL,'2025-12-02 10:16:39',NULL,NULL),(1119,NULL,NULL,'6bba3ba802e142fb8ec6a2e97f6dabc9',NULL,NULL,NULL,NULL,'2025-12-02 10:16:39',NULL,'2025-12-02 10:16:39',NULL,NULL),(1120,NULL,'b1852a1cb6dd4adc85be18f4d6e09935',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:16:40',NULL,'2025-12-02 10:16:40',NULL,NULL),(1121,NULL,'b72f1b2b14cb4f8291dce31622825bf5',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:16:42',NULL,'2025-12-02 10:16:42',NULL,NULL),(1122,NULL,'96312b4177b2422e884d173f0042e8d8',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:16:42',NULL,'2025-12-02 10:16:42',NULL,NULL),(1123,NULL,NULL,'f28923a090f94475a23176e7fcf5a2e1',NULL,NULL,NULL,NULL,'2025-12-02 10:16:45',NULL,'2025-12-02 10:16:45',NULL,NULL),(1124,NULL,'50f32cd20e77432aa8155c09efe362d9',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:16:46',NULL,'2025-12-02 10:16:46',NULL,NULL),(1125,NULL,NULL,'1f11b2a06678478d89a0b30338f3215d',NULL,NULL,NULL,NULL,'2025-12-02 10:16:48',NULL,'2025-12-02 10:16:48',NULL,NULL),(1126,NULL,NULL,'bdac673e7e5c4cfaae7d942c9db671c4',NULL,NULL,NULL,NULL,'2025-12-02 10:16:49',NULL,'2025-12-02 10:16:49',NULL,NULL),(1127,NULL,NULL,'ca23f9ef830342108b0876de8028eecf',NULL,NULL,NULL,NULL,'2025-12-02 10:16:49',NULL,'2025-12-02 10:16:49',NULL,NULL),(1128,NULL,NULL,'38fc37a8433b4872a68fe3ec61727eba',NULL,NULL,NULL,NULL,'2025-12-02 10:16:49',NULL,'2025-12-02 10:16:49',NULL,NULL),(1129,NULL,'d92cdfaa0852404fb2f275710f8302c1',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:16:49',NULL,'2025-12-02 10:16:49',NULL,NULL),(1130,NULL,'5b81ca02bbcb470597d21e5b9567c00e',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:16:50',NULL,'2025-12-02 10:16:50',NULL,NULL),(1131,NULL,'e120e249c8ea4bf2a569810c4d87fe00',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:16:51',NULL,'2025-12-02 10:16:51',NULL,NULL),(1132,NULL,'adec20b00e8e486e94dfc7c1d5363351',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:16:51',NULL,'2025-12-02 10:16:51',NULL,NULL),(1133,NULL,NULL,'e0e6c8b508cf48e2beeb2d009dfbcbce',NULL,NULL,NULL,NULL,'2025-12-02 10:16:51',NULL,'2025-12-02 10:16:51',NULL,NULL),(1134,NULL,'4b105ffe2c294bd68adcb56919eaa6ed',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:16:52',NULL,'2025-12-02 10:16:52',NULL,NULL),(1135,NULL,NULL,'781b3afe9a2049508d4554a340939dda',NULL,NULL,NULL,NULL,'2025-12-02 10:16:54',NULL,'2025-12-02 10:16:54',NULL,NULL),(1136,NULL,'b7c0d42f4552498ba58ba81010b9d1eb',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:16:55',NULL,'2025-12-02 10:16:55',NULL,NULL),(1137,NULL,NULL,'08b53442fdc64279991dff10561321f3',NULL,NULL,NULL,NULL,'2025-12-02 10:17:03',NULL,'2025-12-02 10:17:03',NULL,NULL),(1138,NULL,NULL,'94497d8ddfcd4635afc8344cac93faeb',NULL,NULL,NULL,NULL,'2025-12-02 10:17:04',NULL,'2025-12-02 10:17:04',NULL,NULL),(1139,NULL,NULL,'c5e0f4b0bc7040dea6de3e969159b496',NULL,NULL,NULL,NULL,'2025-12-02 10:17:04',NULL,'2025-12-02 10:17:04',NULL,NULL),(1140,NULL,NULL,'b1a74f1f369c46bf86289b02fca408b3',NULL,NULL,NULL,NULL,'2025-12-02 10:17:04',NULL,'2025-12-02 10:17:04',NULL,NULL),(1141,NULL,'e5b9281b44db4ae9a4ea3491729cac38',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:17:06',NULL,'2025-12-02 10:17:06',NULL,NULL),(1142,NULL,'62ec998068cd4a658938f4bc21a46d8c',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:17:07',NULL,'2025-12-02 10:17:07',NULL,NULL),(1143,NULL,'92b716e08bd541ad8783c4e17d6125eb',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:17:09',NULL,'2025-12-02 10:17:09',NULL,NULL),(1144,NULL,NULL,'5959ef738ad04f059c5a1b644182ddbc',NULL,NULL,NULL,NULL,'2025-12-02 10:17:17',NULL,'2025-12-02 10:17:17',NULL,NULL),(1145,NULL,NULL,'c73fc59be3bc4b7191a70df7b7c286c6',NULL,NULL,NULL,NULL,'2025-12-02 10:17:22',NULL,'2025-12-02 10:17:22',NULL,NULL),(1146,NULL,NULL,'b774140ceb894be08d683a79b22edb33',NULL,NULL,NULL,NULL,'2025-12-02 10:17:24',NULL,'2025-12-02 10:17:24',NULL,NULL),(1147,NULL,NULL,'09cd91803bca4170af22ed072eb90ca1',NULL,NULL,NULL,NULL,'2025-12-02 10:17:24',NULL,'2025-12-02 10:17:24',NULL,NULL),(1148,NULL,NULL,'4ee8b7c5902041f388229b6b908263ec',NULL,NULL,NULL,NULL,'2025-12-02 10:17:24',NULL,'2025-12-02 10:17:24',NULL,NULL),(1149,NULL,'79ddfd071a5e4cc08a108f0183273281',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:17:26',NULL,'2025-12-02 10:17:26',NULL,NULL),(1150,NULL,'1f3aacc82ecc4f83be7fc6675418e749',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:17:27',NULL,'2025-12-02 10:17:27',NULL,NULL),(1151,NULL,'ff98bb837e094a23a282a2f8cce131ec',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:17:29',NULL,'2025-12-02 10:17:29',NULL,NULL),(1152,NULL,NULL,'0c098ae00cb94d67bd45a524f4cab612',NULL,NULL,NULL,NULL,'2025-12-02 10:17:29',NULL,'2025-12-02 10:17:29',NULL,NULL),(1153,NULL,NULL,'8debd5b333f84a3aaa6060fc8d014cf1',NULL,NULL,NULL,NULL,'2025-12-02 10:17:29',NULL,'2025-12-02 10:17:29',NULL,NULL),(1154,NULL,NULL,'e120f272bd6a4c4b9671424a41914b30',NULL,NULL,NULL,NULL,'2025-12-02 10:17:29',NULL,'2025-12-02 10:17:29',NULL,NULL),(1155,NULL,'5be280ec48044774aaae7fa194a6ac14',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:17:30',NULL,'2025-12-02 10:17:30',NULL,NULL),(1156,NULL,'a7dc52ea00264b2383416f2c2734805a',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:17:32',NULL,'2025-12-02 10:17:32',NULL,NULL),(1157,NULL,'aa1a0f1e2d22465ab913b1c3cdbb441a',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:17:33',NULL,'2025-12-02 10:17:33',NULL,NULL),(1158,NULL,NULL,'feb0be4f83ef411db612721c24d9659f',NULL,NULL,NULL,NULL,'2025-12-02 10:17:46',NULL,'2025-12-02 10:17:46',NULL,NULL),(1159,NULL,NULL,'f09491acad8f439a900c28da382ca6e2',NULL,NULL,NULL,NULL,'2025-12-02 10:17:50',NULL,'2025-12-02 10:17:50',NULL,NULL),(1160,NULL,NULL,'c49c58b1664e43e5a2afdef181dd55c8',NULL,NULL,NULL,NULL,'2025-12-02 10:17:50',NULL,'2025-12-02 10:17:50',NULL,NULL),(1161,NULL,NULL,'7688651dbe8842cc9a8956528b28a11c',NULL,NULL,NULL,NULL,'2025-12-02 10:17:50',NULL,'2025-12-02 10:17:50',NULL,NULL),(1162,NULL,'0dff8d6056f54b068fe39ee120775d89',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:17:51',NULL,'2025-12-02 10:17:51',NULL,NULL),(1163,NULL,'cdaa059771c7466abb92ea3e1cebce7e',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:17:52',NULL,'2025-12-02 10:17:52',NULL,NULL),(1164,NULL,'081611baf0f94a6aa648c9b2d92505e6',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:17:53',NULL,'2025-12-02 10:17:53',NULL,NULL),(1165,NULL,NULL,'f50c9ee5038340ee9925b9cad57432ba',NULL,NULL,NULL,NULL,'2025-12-02 10:18:01',NULL,'2025-12-02 10:18:01',NULL,NULL),(1166,NULL,NULL,'f3629981fc0b479098d9c5e563520055',NULL,NULL,NULL,NULL,'2025-12-02 10:18:05',NULL,'2025-12-02 10:18:05',NULL,NULL),(1167,NULL,NULL,'ae22793361bc4c979a37340b13aae57c',NULL,NULL,NULL,NULL,'2025-12-02 10:18:05',NULL,'2025-12-02 10:18:05',NULL,NULL),(1168,NULL,NULL,'3cb1fe9d600e490787983fa0839d0b28',NULL,NULL,NULL,NULL,'2025-12-02 10:18:05',NULL,'2025-12-02 10:18:05',NULL,NULL),(1169,NULL,'edebec77bbdf4cd1af5cf334108b7c16',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:18:06',NULL,'2025-12-02 10:18:06',NULL,NULL),(1170,NULL,'dad46467971d4ec69445c333d5c21b19',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:18:07',NULL,'2025-12-02 10:18:07',NULL,NULL),(1171,NULL,'00512ee218d94137811a7a2be38b6ad6',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:18:08',NULL,'2025-12-02 10:18:08',NULL,NULL),(1172,NULL,NULL,'bc51da2b800843debe1b985e4a420907',NULL,NULL,NULL,NULL,'2025-12-02 10:18:10',NULL,'2025-12-02 10:18:10',NULL,NULL),(1173,NULL,'5aa47903b78a4871afeafe588d852d76',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:18:12',NULL,'2025-12-02 10:18:12',NULL,NULL),(1174,NULL,NULL,'a64f446c416d402fab0f1d3f944150c3',NULL,NULL,NULL,NULL,'2025-12-02 10:18:20',NULL,'2025-12-02 10:18:20',NULL,NULL),(1175,NULL,NULL,'1629291dc1ca4e0cb12fe10818d1af4c',NULL,NULL,NULL,NULL,'2025-12-02 10:18:20',NULL,'2025-12-02 10:18:20',NULL,NULL),(1176,NULL,NULL,'fe70f56e2325429ca80efc7f242a7423',NULL,NULL,NULL,NULL,'2025-12-02 10:18:27',NULL,'2025-12-02 10:18:27',NULL,NULL),(1177,NULL,NULL,'de7191e18ee2461a89a8c03b2cd63b53',NULL,NULL,NULL,NULL,'2025-12-02 10:18:27',NULL,'2025-12-02 10:18:27',NULL,NULL),(1178,NULL,NULL,'fcc5d4a07431422ba3821f11642e7581',NULL,NULL,NULL,NULL,'2025-12-02 10:18:27',NULL,'2025-12-02 10:18:27',NULL,NULL),(1179,NULL,'189338932ea6405a81287e64e5b6f698',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:18:28',NULL,'2025-12-02 10:18:28',NULL,NULL),(1180,NULL,'10333b3b16244eb69d5c07915faedc40',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:18:29',NULL,'2025-12-02 10:18:29',NULL,NULL),(1181,NULL,'bb71f7641c1d4d6caa78bff2db07fa2a',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:18:30',NULL,'2025-12-02 10:18:30',NULL,NULL),(1182,NULL,NULL,'810b7ac944654493811fa059cf02f8ca',NULL,NULL,NULL,NULL,'2025-12-02 10:18:35',NULL,'2025-12-02 10:18:35',NULL,NULL),(1183,NULL,NULL,'6273e093121d443e9c542b0e0ad7a041',NULL,NULL,NULL,NULL,'2025-12-02 10:18:36',NULL,'2025-12-02 10:18:36',NULL,NULL),(1184,NULL,NULL,'2b66987e91884484971a2f1a8ce2e2a0',NULL,NULL,NULL,NULL,'2025-12-02 10:18:36',NULL,'2025-12-02 10:18:36',NULL,NULL),(1185,NULL,NULL,'caa1cf815aae48319628923d9fdd7a5e',NULL,NULL,NULL,NULL,'2025-12-02 10:18:36',NULL,'2025-12-02 10:18:36',NULL,NULL),(1186,NULL,NULL,'93d13ca7e2a24175bba901a25766e537',NULL,NULL,NULL,NULL,'2025-12-02 10:18:36',NULL,'2025-12-02 10:18:36',NULL,NULL),(1187,NULL,NULL,'b0208b16c0b84ea39f37b5d14d8efb9c',NULL,NULL,NULL,NULL,'2025-12-02 10:18:36',NULL,'2025-12-02 10:18:36',NULL,NULL),(1188,NULL,NULL,'0c200984c91c4bb887376ad87b47b60b',NULL,NULL,NULL,NULL,'2025-12-02 10:18:36',NULL,'2025-12-02 10:18:36',NULL,NULL),(1189,NULL,'d003804957214aa4ae099152acdb9d37',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:18:37',NULL,'2025-12-02 10:18:37',NULL,NULL),(1190,NULL,'98be8484c5ba419b8d3744355d381f71',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:18:37',NULL,'2025-12-02 10:18:37',NULL,NULL),(1191,NULL,'9794e2a98adc45eabff524f0418d258f',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:18:37',NULL,'2025-12-02 10:18:37',NULL,NULL),(1192,NULL,'827086144959480f86443c8d0752a562',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:18:38',NULL,'2025-12-02 10:18:38',NULL,NULL),(1193,NULL,'211eae1028e14770a7771256868ba26b',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:18:38',NULL,'2025-12-02 10:18:38',NULL,NULL),(1194,NULL,'e3aee011ab2a4799adbceba7fac8998a',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:18:39',NULL,'2025-12-02 10:18:39',NULL,NULL),(1195,NULL,NULL,'8b16e888065a4592b2e6cff39353c9e4',NULL,NULL,NULL,NULL,'2025-12-02 10:18:59',NULL,'2025-12-02 10:18:59',NULL,NULL),(1196,NULL,'a000e83a94074072b621c04cc7bee002',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:19:00',NULL,'2025-12-02 10:19:00',NULL,NULL),(1197,NULL,NULL,'47fe069eea2349b1a0dd04f69fca095b',NULL,NULL,NULL,NULL,'2025-12-02 10:19:07',NULL,'2025-12-02 10:19:07',NULL,NULL),(1198,NULL,NULL,'380da46d455b48bd94881f1dff30b44b',NULL,NULL,NULL,NULL,'2025-12-02 10:19:07',NULL,'2025-12-02 10:19:07',NULL,NULL),(1199,NULL,'6279c547e4d448d29e2a37d1c9d24474',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:19:08',NULL,'2025-12-02 10:19:08',NULL,NULL),(1200,NULL,'4851cba82e304f60b99cf343fa7fcf33',NULL,NULL,NULL,NULL,NULL,'2025-12-02 10:19:08',NULL,'2025-12-02 10:19:08',NULL,NULL);
/*!40000 ALTER TABLE `revocation_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL DEFAULT '<<null>>',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_role_name_domain_id` (`name`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` (`id`, `name`, `extra`, `domain_id`, `description`) VALUES ('0e37716a088f42bb8866dfec3ae16965','member','{}','<<null>>',NULL),('0e6437a22d37486495baa8a2090db115','swiftoperator','{}','<<null>>',NULL),('1ddc63e1c4d745ae864e01e6b09bcd55','reader','{}','<<null>>',NULL),('211e85ebe8f041b2a8959251afc134f9','ResellerAdmin','{}','<<null>>',NULL),('21802b184be54c9a9f9f99fd6277c69c','admin','{}','<<null>>',NULL),('25554cd3e4d449bea321b13ec9c0e128','service','{}','<<null>>',NULL),('aa5bdbd002914c45b2618bf1db2bde4b','heat_stack_user','{}','<<null>>',NULL);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_option`
--

DROP TABLE IF EXISTS `role_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_option` (
  `role_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`role_id`,`option_id`),
  CONSTRAINT `role_option_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_option`
--

LOCK TABLES `role_option` WRITE;
/*!40000 ALTER TABLE `role_option` DISABLE KEYS */;
INSERT INTO `role_option` (`role_id`, `option_id`, `option_value`) VALUES ('0e37716a088f42bb8866dfec3ae16965','IMMU','true'),('1ddc63e1c4d745ae864e01e6b09bcd55','IMMU','true'),('21802b184be54c9a9f9f99fd6277c69c','IMMU','true');
/*!40000 ALTER TABLE `role_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sensitive_config`
--

DROP TABLE IF EXISTS `sensitive_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sensitive_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sensitive_config`
--

LOCK TABLES `sensitive_config` WRITE;
/*!40000 ALTER TABLE `sensitive_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sensitive_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `type`, `enabled`, `extra`) VALUES ('0fb9bf86e9c34dcb964e42b649c4b49b','key-manager',1,'{\"description\": \"Barbican Service\", \"name\": \"barbican\"}'),('1efafc7ea64545c2ab6594bc7a36503d','orchestration',1,'{\"description\": \"Heat API service\", \"name\": \"heat\"}'),('2109c32e7fd74b4398e960a0ffa08de4','alarming',1,'{\"description\": \"Aodh for autoscaling Service\", \"name\": \"aodh\"}'),('701644becdf14b8988317a75abccc664','sharev2',1,'{\"description\": \"Manila V2 Service\", \"name\": \"manilav2\"}'),('73542ed1d69a4c98be6a83894afae975','cloudformation',1,'{\"description\": \"Heat Cloudformation API service\", \"name\": \"heat-cfn\"}'),('81a1066a71534338afc03f529cd50e61','network',1,'{\"description\": \"Openstack Networking\", \"name\": \"neutron\"}'),('8387d5fdc5a540c9b05a8a7668e63352','placement',1,'{\"description\": \"Placement Service\", \"name\": \"placement\"}'),('8dfbb6571b4a443a86b6a3de666c955d','image',1,'{\"description\": \"Glance Service\", \"name\": \"glance\"}'),('a2d98165bf0c4ca3aafe9061c0b84e1a','share',1,'{\"description\": \"Manila V1 Service\", \"name\": \"manila\"}'),('c09179ce9c044c19b50ad6c1cfd1ed1b','compute',1,'{\"description\": \"Nova Compute Service\", \"name\": \"nova\"}'),('c7f8ce109cb54361aa7575cb5558d7ed','Ceilometer',1,'{\"description\": \"Ceilometer Service\", \"name\": \"ceilometer\"}'),('dd5d344d70064694bae0fe4f21c3cf0e','identity',1,'{\"name\": \"keystone\"}'),('f5cb4a629bce46ccade1020da103df42','volumev3',1,'{\"description\": \"Cinder V3 Service\", \"name\": \"cinderv3\"}');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_provider`
--

DROP TABLE IF EXISTS `service_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_provider` (
  `auth_url` varchar(256) NOT NULL,
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `sp_url` varchar(256) NOT NULL,
  `relay_state_prefix` varchar(256) NOT NULL DEFAULT 'ss:mem:',
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_provider`
--

LOCK TABLES `service_provider` WRITE;
/*!40000 ALTER TABLE `service_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `service_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_assignment`
--

DROP TABLE IF EXISTS `system_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_assignment` (
  `type` varchar(64) NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`inherited` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_assignment`
--

LOCK TABLES `system_assignment` WRITE;
/*!40000 ALTER TABLE `system_assignment` DISABLE KEYS */;
INSERT INTO `system_assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserSystem','cb8b7d2a63b642aa999db12e17eeb9e4','system','21802b184be54c9a9f9f99fd6277c69c',0);
/*!40000 ALTER TABLE `system_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `token`
--

DROP TABLE IF EXISTS `token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `token` (
  `id` varchar(64) NOT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_token_expires` (`expires`),
  KEY `ix_token_expires_valid` (`expires`,`valid`),
  KEY `ix_token_user_id` (`user_id`),
  KEY `ix_token_trust_id` (`trust_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`valid` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `token`
--

LOCK TABLES `token` WRITE;
/*!40000 ALTER TABLE `token` DISABLE KEYS */;
/*!40000 ALTER TABLE `token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust`
--

DROP TABLE IF EXISTS `trust`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust` (
  `id` varchar(64) NOT NULL,
  `trustor_user_id` varchar(64) NOT NULL,
  `trustee_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `impersonation` tinyint(1) NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `remaining_uses` int(11) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `redelegated_trust_id` varchar(64) DEFAULT NULL,
  `redelegation_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `duplicate_trust_constraint_expanded` (`trustor_user_id`,`trustee_user_id`,`project_id`,`impersonation`,`expires_at`,`expires_at_int`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`impersonation` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust`
--

LOCK TABLES `trust` WRITE;
/*!40000 ALTER TABLE `trust` DISABLE KEYS */;
INSERT INTO `trust` (`id`, `trustor_user_id`, `trustee_user_id`, `project_id`, `impersonation`, `deleted_at`, `expires_at`, `remaining_uses`, `extra`, `expires_at_int`, `redelegated_trust_id`, `redelegation_count`) VALUES ('6b1ea3323df54a2aa435f45ceea2e3eb','3480a07e80ee4cf5a76d130c342eb5c8','89171c6dba8f4024988071a7a35aae24','7ba7fb0d49f54f008a215a61f562c43c',1,'2025-12-02 10:05:54',NULL,NULL,'{\"roles\": [{\"id\": \"ccf6c49773164fc5a3c75370cd9cc992\"}]}',NULL,NULL,0),('8824c8057bcd44d49d3be39938b3ebb1','1739ecfdbeb34658a3be8ba7c66cb871','89171c6dba8f4024988071a7a35aae24','a6582eb419984c62a423f3cf78b4efb0',1,'2025-12-02 10:06:15',NULL,NULL,'{\"roles\": [{\"id\": \"ec07ff782fd04486a43da538c998f585\"}]}',NULL,NULL,0),('a5fa8280ff2045b9813b4ac0383c1953','3726531ad9ff4b6fa721b329d26d6d95','89171c6dba8f4024988071a7a35aae24','76dc7354ef2d439d97965a0dce75d18a',1,'2025-12-02 10:06:06','2025-12-02 11:06:02',NULL,'{\"roles\": [{\"id\": \"f7b439564992428285c07e0cea345b66\"}]}',1764673562000000,NULL,0),('c3c91107edd4417c96ac3c1336122ff3','10a5b394fb4d4865a7ba292b825f86a2','89171c6dba8f4024988071a7a35aae24','bc99a7e88c1b433398e606bdc818c1d5',1,'2025-12-02 10:05:59',NULL,NULL,'{\"roles\": [{\"id\": \"ab1abecf729d48e4a6ef198793651926\"}]}',NULL,NULL,0),('ccf463f97396408e8f588d32aa4e9bd9','b1f2d7e7e285484f892a60f5242b6406','89171c6dba8f4024988071a7a35aae24','b672e251df5c4bc5ad999ba227f39fb5',0,'2025-12-02 10:06:18',NULL,NULL,'{\"roles\": [{\"id\": \"b77a4fc0c03e42feac988d0bfa26e94f\"}]}',NULL,NULL,0);
/*!40000 ALTER TABLE `trust` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust_role`
--

DROP TABLE IF EXISTS `trust_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust_role` (
  `trust_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`trust_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust_role`
--

LOCK TABLES `trust_role` WRITE;
/*!40000 ALTER TABLE `trust_role` DISABLE KEYS */;
INSERT INTO `trust_role` (`trust_id`, `role_id`) VALUES ('6b1ea3323df54a2aa435f45ceea2e3eb','ccf6c49773164fc5a3c75370cd9cc992'),('8824c8057bcd44d49d3be39938b3ebb1','ec07ff782fd04486a43da538c998f585'),('a5fa8280ff2045b9813b4ac0383c1953','f7b439564992428285c07e0cea345b66'),('c3c91107edd4417c96ac3c1336122ff3','ab1abecf729d48e4a6ef198793651926'),('ccf463f97396408e8f588d32aa4e9bd9','b77a4fc0c03e42feac988d0bfa26e94f');
/*!40000 ALTER TABLE `trust_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `default_project_id` varchar(64) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_active_at` date DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_user_id_domain_id` (`id`,`domain_id`),
  KEY `domain_id` (`domain_id`),
  KEY `ix_default_project_id` (`default_project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `extra`, `enabled`, `default_project_id`, `created_at`, `last_active_at`, `domain_id`) VALUES ('0c7e47fd78d9490b9063dc6e94e0b3ad','{\"email\": \"cinder@localhost\", \"description\": null}',1,NULL,'2025-12-02 08:16:31','2025-12-02','default'),('3b01723fbb5d493280e0b20f52b38994','{\"email\": \"placement@localhost\", \"description\": null}',1,NULL,'2025-12-02 08:16:44','2025-12-02','default'),('3e7e7bf92d8d44f5b194085fa0ed465d','{\"email\": \"heat@localhost\", \"description\": null}',1,NULL,'2025-12-02 08:16:32','2025-12-02','default'),('47c723b6543f422184d6e02fd43d595d','{\"email\": \"gnocchi@localhost\", \"description\": null}',1,NULL,'2025-12-02 08:16:32','2025-12-02','default'),('4ea94a3d730c499a8a661131692645ce','{\"email\": \"nova@localhost\", \"description\": null}',1,NULL,'2025-12-02 08:16:43','2025-12-02','default'),('527a05e992df408faf9cf78a79f4353e','{\"email\": \"glance@localhost\", \"description\": null}',1,NULL,'2025-12-02 08:16:32','2025-12-02','default'),('5bf218f626394b16a73e0bfb58411cf4','{\"email\": \"cinderv3@localhost\", \"description\": null}',1,NULL,'2025-12-02 08:16:31',NULL,'default'),('65805390643046bea131789824b0946f','{\"email\": \"swift@localhost\", \"description\": null}',1,NULL,'2025-12-02 08:16:44','2025-12-02','default'),('82e3b112753647778aca5ac3da9fa267','{\"email\": \"heat_stack_domain_admin@localhost\", \"description\": null}',1,NULL,'2025-12-02 08:16:33',NULL,'29a0224d96a4466cb378e99892ef6e05'),('ab4364fdcce542378ae19fff3c3d9abe','{}',1,'497073c2347a4b2dbbf501873318fbd3','2025-12-02 08:50:08','2025-12-02','default'),('c12ddf970225448a9b860e3594003403','{\"email\": \"ceilometer@localhost\", \"description\": null}',1,NULL,'2025-12-02 08:16:30','2025-12-02','default'),('c4ddb205feda4fdf81a814060fee159d','{\"email\": \"aodh@localhost\", \"description\": null}',1,NULL,'2025-12-02 08:16:30','2025-12-02','default'),('cb8b7d2a63b642aa999db12e17eeb9e4','{\"email\": \"admin@localhost\"}',1,NULL,'2025-12-02 08:14:00','2025-12-02','default'),('d6136e6033d24eec850fd5d7af7a2c0c','{\"email\": \"manila@localhost\", \"description\": null}',1,NULL,'2025-12-02 08:16:34','2025-12-02','default'),('d7cb1a3913b14d69acc11f5da29858a7','{\"tenantId\": \"7c710fa8ef34435a90faf381a656355c\", \"email\": \"alt_demo_tempestconf@test.com\"}',1,NULL,'2025-12-02 10:01:24',NULL,'default'),('dafd7fe1ebe54740b64cc9f8b3667fc9','{\"email\": \"neutron@localhost\", \"description\": null}',1,NULL,'2025-12-02 08:16:43','2025-12-02','default'),('db9b94bd57064aab94b78d0dc1c6caa4','{\"email\": \"heat-cfn@localhost\", \"description\": null}',1,NULL,'2025-12-02 08:16:33',NULL,'default'),('e4e9bbcee76b4fc39eff3a6aa56115e5','{\"email\": \"manilav2@localhost\", \"description\": null}',1,NULL,'2025-12-02 08:16:43',NULL,'default'),('e551833ffbae4dfe80ac88ba9039e469','{\"tenantId\": \"39df5a456b5041ca879477e5908b399c\", \"email\": \"demo_tempestconf@test.com\"}',1,NULL,'2025-12-02 10:01:23','2025-12-02','default');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_group_membership`
--

DROP TABLE IF EXISTS `user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `fk_user_group_membership_group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `fk_user_group_membership_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_group_membership`
--

LOCK TABLES `user_group_membership` WRITE;
/*!40000 ALTER TABLE `user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_option`
--

DROP TABLE IF EXISTS `user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_option` (
  `user_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`user_id`,`option_id`),
  CONSTRAINT `user_option_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_option`
--

LOCK TABLES `user_option` WRITE;
/*!40000 ALTER TABLE `user_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whitelisted_config`
--

DROP TABLE IF EXISTS `whitelisted_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whitelisted_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whitelisted_config`
--

LOCK TABLES `whitelisted_config` WRITE;
/*!40000 ALTER TABLE `whitelisted_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `whitelisted_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `manila`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `manila` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `manila`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('aebe2a413e13');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `async_operation_data`
--

DROP TABLE IF EXISTS `async_operation_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `async_operation_data` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `entity_uuid` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`entity_uuid`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `async_operation_data`
--

LOCK TABLES `async_operation_data` WRITE;
/*!40000 ALTER TABLE `async_operation_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `async_operation_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `availability_zones`
--

DROP TABLE IF EXISTS `availability_zones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `availability_zones` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `az_name_uc` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `availability_zones`
--

LOCK TABLES `availability_zones` WRITE;
/*!40000 ALTER TABLE `availability_zones` DISABLE KEYS */;
INSERT INTO `availability_zones` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`) VALUES ('2025-12-02 08:18:16.010943',NULL,NULL,'False','89238340-05bc-4685-9d1b-a83ebfa5312f','nova');
/*!40000 ALTER TABLE `availability_zones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backend_info`
--

DROP TABLE IF EXISTS `backend_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backend_info` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `host` varchar(255) NOT NULL,
  `info_hash` varchar(255) NOT NULL,
  PRIMARY KEY (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backend_info`
--

LOCK TABLES `backend_info` WRITE;
/*!40000 ALTER TABLE `backend_info` DISABLE KEYS */;
INSERT INTO `backend_info` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `host`, `info_hash`) VALUES ('2025-12-02 09:03:22.433175',NULL,NULL,0,'hostgroup@cephfs','e66c0dfc0d422efa26af62f5a81dd60603e2d39a');
/*!40000 ALTER TABLE `backend_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `drivers_private_data`
--

DROP TABLE IF EXISTS `drivers_private_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `drivers_private_data` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `entity_uuid` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`entity_uuid`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `drivers_private_data`
--

LOCK TABLES `drivers_private_data` WRITE;
/*!40000 ALTER TABLE `drivers_private_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `drivers_private_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(255) DEFAULT NULL,
  `resource_id` varchar(36) DEFAULT NULL,
  `action_id` varchar(10) NOT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
INSERT INTO `messages` (`id`, `project_id`, `request_id`, `resource_type`, `resource_id`, `action_id`, `detail_id`, `message_level`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `expires_at`) VALUES ('00251c54-f707-4a8c-9c9c-a94d935c1ef7','e8295af6a4df4c97a379f21f43a2e9aa','req-c499bd41-439c-4ba7-933b-b280643f07fe','SHARE','a5a594b9-d41c-40bc-bd3c-ab922ba18a96','001','008','ERROR','2025-12-02 10:13:56.306390',NULL,NULL,'False','2026-01-01 10:13:56'),('219f6da0-1d86-482d-a21e-01e25c218c09','0fe90f11d3f64e12b3591732792a929e','req-bb8b259d-1092-49f1-9411-6d5fa90710f7','SHARE','b0f50540-3271-4237-a8b9-9551bf8df603','010','020','ERROR','2025-12-02 10:15:39.486814',NULL,NULL,'False','2026-01-01 10:15:39'),('3801fbc6-f50a-458f-bd77-7b34fb25857f','1d8a048450454feda5d5f8e5791593b2','req-fd171ad1-b46a-4bec-80d9-126aa010c9ec','SHARE','b2ab2817-2826-48a1-9fb7-5565a164af18','001','008','ERROR','2025-12-02 10:13:29.521856',NULL,NULL,'False','2026-01-01 10:13:29'),('5c91d085-9c77-4614-858e-cd998711d07f','1d8a048450454feda5d5f8e5791593b2','req-d8707c48-0be1-43ac-8910-6eac4dc9b232','SHARE','6e8cbe12-bd4d-4cf7-ab5c-f8b707ad8715','001','008','ERROR','2025-12-02 10:13:43.444002',NULL,NULL,'False','2026-01-01 10:13:43'),('660dd1c8-e1de-4524-9704-5a6d01e8adab','1d8a048450454feda5d5f8e5791593b2','req-2914dcb5-7bdc-49ea-b413-20b5785846fb','SHARE','a4d6dc99-b312-411c-9324-b0f79b66ca64','001','008','ERROR','2025-12-02 10:13:54.947649',NULL,NULL,'False','2026-01-01 10:13:54'),('8507f625-5af3-4549-8664-3047db5f50c8','1d8a048450454feda5d5f8e5791593b2','req-0872d13a-0899-40e5-bfa8-40de126473a0','SHARE','83a9195d-889a-4f9d-b260-5fffb12cd086','001','008','ERROR','2025-12-02 10:13:58.698432',NULL,'2025-12-02 10:14:01.779399','8507f625-5af3-4549-8664-3047db5f50c8','2026-01-01 10:13:58'),('8c826613-ed4c-4c05-a357-f16decd9f04c','e8295af6a4df4c97a379f21f43a2e9aa','req-1608a408-ee57-4ebb-a643-4d8ea745b8de','SHARE','db924d57-101a-43cc-9672-793225a02519','001','008','ERROR','2025-12-02 10:13:52.567311',NULL,NULL,'False','2026-01-01 10:13:52'),('94d7ada1-dfdb-4759-927e-73da6737f1b9','1d8a048450454feda5d5f8e5791593b2','req-a659c642-da32-4a54-b050-ee781d97e18d','SHARE','21cbdad8-e0fd-4e04-bb7e-5f6f95650c31','001','008','ERROR','2025-12-02 10:13:46.739804',NULL,NULL,'False','2026-01-01 10:13:46'),('9d64dcd8-dd2f-44f3-9295-278eb6847092','1d8a048450454feda5d5f8e5791593b2','req-490f38fc-23ea-4321-ae55-b97238ba6bc1','SHARE','a9b9abf4-65c5-4dac-b7df-94bcb11a6343','001','008','ERROR','2025-12-02 10:13:40.160500',NULL,NULL,'False','2026-01-01 10:13:40'),('9e985905-5a72-44da-a758-9e8e9adc728c','1d8a048450454feda5d5f8e5791593b2','req-49fa54be-6ba7-4554-af49-a1d14cf98292','SHARE','01a011db-eb64-413a-ae1c-8263b2ee223e','001','008','ERROR','2025-12-02 10:13:51.671475',NULL,NULL,'False','2026-01-01 10:13:51'),('c26f922f-e400-4433-a15d-cb573dce68f9','e8295af6a4df4c97a379f21f43a2e9aa','req-953a37d7-99a9-4dd9-802e-2485d144a27c','SHARE','420f8ee8-9bda-4b15-ae94-209abc146460','001','008','ERROR','2025-12-02 10:13:49.100935',NULL,NULL,'False','2026-01-01 10:13:49'),('c9e0b88e-60cd-4fcd-8bde-232ef695a5c7','1d8a048450454feda5d5f8e5791593b2','req-1ab0c99b-b26a-4cb4-97d1-362cce884a65','SHARE','fe8bfc91-c569-400d-82dd-bdcd7f441e21','001','008','ERROR','2025-12-02 10:13:36.441466',NULL,NULL,'False','2026-01-01 10:13:36'),('cf0162f6-1009-4dff-a339-f698ac0f9754','e8295af6a4df4c97a379f21f43a2e9aa','req-9a2e8672-3dd5-4936-9ba5-0be226ac4f37','SHARE','ed5c25d5-1654-48bf-ad81-21d589a95050','001','008','ERROR','2025-12-02 10:13:59.998928',NULL,NULL,'False','2026-01-01 10:13:59'),('dbafc205-b1e0-4ed4-ba18-ad007ae1f938','1d8a048450454feda5d5f8e5791593b2','req-291acb25-f631-42fe-b097-3a1ead8ddf17','SHARE','31df7ef6-0cf4-4f6d-9da3-7a548108ef95','001','008','ERROR','2025-12-02 10:13:25.811129',NULL,'2025-12-02 10:13:28.886839','dbafc205-b1e0-4ed4-ba18-ad007ae1f938','2026-01-01 10:13:25'),('ec731a0e-ea34-40f8-990f-94267f2c159b','e8295af6a4df4c97a379f21f43a2e9aa','req-35df9f50-b027-49d8-8c3a-acc68a3a5af5','SHARE','84d69801-6f95-4c59-a22e-bb1ed50e0c88','001','008','ERROR','2025-12-02 10:13:45.480184',NULL,NULL,'False','2026-01-01 10:13:45'),('ef7036c1-2cfb-4604-a782-739bcf6808b0','1d8a048450454feda5d5f8e5791593b2','req-7fe9ce73-93bd-4322-b54c-ff149c56c1fb','SHARE','ecf12243-4257-4919-8672-ffc4703640f1','001','008','ERROR','2025-12-02 10:13:33.130126',NULL,NULL,'False','2026-01-01 10:13:33');
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `network_allocations`
--

DROP TABLE IF EXISTS `network_allocations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `network_allocations` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ip_address` varchar(64) DEFAULT NULL,
  `mac_address` varchar(32) DEFAULT NULL,
  `share_server_id` varchar(36) NOT NULL,
  `label` varchar(255) DEFAULT 'user',
  `network_type` varchar(32) DEFAULT NULL,
  `segmentation_id` int(11) DEFAULT NULL,
  `ip_version` int(11) DEFAULT NULL,
  `cidr` varchar(64) DEFAULT NULL,
  `gateway` varchar(64) DEFAULT NULL,
  `mtu` int(11) DEFAULT NULL,
  `share_network_subnet_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `share_server_id` (`share_server_id`),
  KEY `fk_network_allocation_subnet_id_share_network_subnets` (`share_network_subnet_id`),
  CONSTRAINT `fk_network_allocation_subnet_id_share_network_subnets` FOREIGN KEY (`share_network_subnet_id`) REFERENCES `share_network_subnets` (`id`),
  CONSTRAINT `network_allocations_ibfk_1` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `network_allocations`
--

LOCK TABLES `network_allocations` WRITE;
/*!40000 ALTER TABLE `network_allocations` DISABLE KEYS */;
/*!40000 ALTER TABLE `network_allocations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_share_type_quotas`
--

DROP TABLE IF EXISTS `project_share_type_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_share_type_quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `share_type_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uc_quotas_per_share_types` (`share_type_id`,`resource`,`deleted`,`project_id`),
  CONSTRAINT `share_type_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_share_type_quotas`
--

LOCK TABLES `project_share_type_quotas` WRITE;
/*!40000 ALTER TABLE `project_share_type_quotas` DISABLE KEYS */;
INSERT INTO `project_share_type_quotas` (`id`, `project_id`, `resource`, `hard_limit`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `share_type_id`) VALUES (1,'680813e2a2a84d78b0da5d342341d9de','shares',2,'2025-12-02 10:14:17.451932',NULL,'2025-12-02 10:14:38.646894',1,'c5eabd7f-49df-4d97-ac80-6482db3b660b'),(2,'680813e2a2a84d78b0da5d342341d9de','gigabytes',4,'2025-12-02 10:14:17.457030',NULL,'2025-12-02 10:14:38.646894',2,'c5eabd7f-49df-4d97-ac80-6482db3b660b'),(3,'680813e2a2a84d78b0da5d342341d9de','shares',2,'2025-12-02 10:14:17.513241',NULL,'2025-12-02 10:14:38.570778',3,'49fe7987-9e54-4fce-a1b2-017c50dd85f9'),(4,'680813e2a2a84d78b0da5d342341d9de','gigabytes',4,'2025-12-02 10:14:17.517211',NULL,'2025-12-02 10:14:38.570778',4,'49fe7987-9e54-4fce-a1b2-017c50dd85f9'),(5,'680813e2a2a84d78b0da5d342341d9de','shares',53,'2025-12-02 10:14:31.276406',NULL,'2025-12-02 10:14:31.321357',5,'c4bcc953-145f-4a3d-a583-f92fa27b06a4'),(6,'680813e2a2a84d78b0da5d342341d9de','snapshots',53,'2025-12-02 10:14:31.281078',NULL,'2025-12-02 10:14:31.321357',6,'c4bcc953-145f-4a3d-a583-f92fa27b06a4'),(7,'680813e2a2a84d78b0da5d342341d9de','gigabytes',1003,'2025-12-02 10:14:31.285452',NULL,'2025-12-02 10:14:31.321357',7,'c4bcc953-145f-4a3d-a583-f92fa27b06a4'),(8,'680813e2a2a84d78b0da5d342341d9de','snapshot_gigabytes',1003,'2025-12-02 10:14:31.288983',NULL,'2025-12-02 10:14:31.321357',8,'c4bcc953-145f-4a3d-a583-f92fa27b06a4'),(9,'680813e2a2a84d78b0da5d342341d9de','share_replicas',103,'2025-12-02 10:14:31.291993',NULL,'2025-12-02 10:14:31.321357',9,'c4bcc953-145f-4a3d-a583-f92fa27b06a4'),(10,'680813e2a2a84d78b0da5d342341d9de','replica_gigabytes',1003,'2025-12-02 10:14:31.294699',NULL,'2025-12-02 10:14:31.321357',10,'c4bcc953-145f-4a3d-a583-f92fa27b06a4'),(11,'680813e2a2a84d78b0da5d342341d9de','shares',53,'2025-12-02 10:14:31.637719',NULL,'2025-12-02 10:14:31.708466',11,'00130209-7927-4c8d-9501-95f11f97a781'),(12,'680813e2a2a84d78b0da5d342341d9de','snapshots',53,'2025-12-02 10:14:31.644004',NULL,'2025-12-02 10:14:31.708466',12,'00130209-7927-4c8d-9501-95f11f97a781'),(13,'680813e2a2a84d78b0da5d342341d9de','gigabytes',1003,'2025-12-02 10:14:31.649222',NULL,'2025-12-02 10:14:31.708466',13,'00130209-7927-4c8d-9501-95f11f97a781'),(14,'680813e2a2a84d78b0da5d342341d9de','snapshot_gigabytes',1003,'2025-12-02 10:14:31.654024',NULL,'2025-12-02 10:14:31.708466',14,'00130209-7927-4c8d-9501-95f11f97a781'),(15,'680813e2a2a84d78b0da5d342341d9de','share_replicas',103,'2025-12-02 10:14:31.658119',NULL,'2025-12-02 10:14:31.708466',15,'00130209-7927-4c8d-9501-95f11f97a781'),(16,'680813e2a2a84d78b0da5d342341d9de','replica_gigabytes',1003,'2025-12-02 10:14:31.663197',NULL,'2025-12-02 10:14:31.708466',16,'00130209-7927-4c8d-9501-95f11f97a781'),(17,'680813e2a2a84d78b0da5d342341d9de','shares',12,'2025-12-02 10:14:32.227007',NULL,'2025-12-02 10:14:38.402526',17,'ff9da486-ce3d-45a7-a86a-3a9009e14520'),(18,'680813e2a2a84d78b0da5d342341d9de','shares',49,'2025-12-02 10:14:34.318535',NULL,'2025-12-02 10:14:38.348412',18,'dc00ebcc-700a-4c2b-83a9-cfe91e431bc0'),(19,'680813e2a2a84d78b0da5d342341d9de','gigabytes',999,'2025-12-02 10:14:34.400039',NULL,'2025-12-02 10:14:38.348412',19,'dc00ebcc-700a-4c2b-83a9-cfe91e431bc0'),(20,'680813e2a2a84d78b0da5d342341d9de','snapshots',49,'2025-12-02 10:14:34.481138',NULL,'2025-12-02 10:14:38.348412',20,'dc00ebcc-700a-4c2b-83a9-cfe91e431bc0'),(21,'680813e2a2a84d78b0da5d342341d9de','snapshot_gigabytes',999,'2025-12-02 10:14:34.573994',NULL,'2025-12-02 10:14:38.348412',21,'dc00ebcc-700a-4c2b-83a9-cfe91e431bc0'),(22,'680813e2a2a84d78b0da5d342341d9de','share_replicas',99,'2025-12-02 10:14:34.634144',NULL,'2025-12-02 10:14:38.348412',22,'dc00ebcc-700a-4c2b-83a9-cfe91e431bc0'),(23,'680813e2a2a84d78b0da5d342341d9de','replica_gigabytes',999,'2025-12-02 10:14:34.782510',NULL,'2025-12-02 10:14:38.348412',23,'dc00ebcc-700a-4c2b-83a9-cfe91e431bc0'),(24,'680813e2a2a84d78b0da5d342341d9de','shares',49,'2025-12-02 10:14:34.955057',NULL,'2025-12-02 10:14:38.289428',24,'e491bca8-3425-41e4-bbc9-94e03ecafcff'),(25,'680813e2a2a84d78b0da5d342341d9de','gigabytes',999,'2025-12-02 10:14:35.041575',NULL,'2025-12-02 10:14:38.289428',25,'e491bca8-3425-41e4-bbc9-94e03ecafcff'),(26,'680813e2a2a84d78b0da5d342341d9de','snapshots',49,'2025-12-02 10:14:35.097036',NULL,'2025-12-02 10:14:38.289428',26,'e491bca8-3425-41e4-bbc9-94e03ecafcff'),(27,'680813e2a2a84d78b0da5d342341d9de','snapshot_gigabytes',999,'2025-12-02 10:14:35.161916',NULL,'2025-12-02 10:14:38.289428',27,'e491bca8-3425-41e4-bbc9-94e03ecafcff'),(28,'680813e2a2a84d78b0da5d342341d9de','share_replicas',99,'2025-12-02 10:14:35.246567',NULL,'2025-12-02 10:14:38.289428',28,'e491bca8-3425-41e4-bbc9-94e03ecafcff'),(29,'680813e2a2a84d78b0da5d342341d9de','replica_gigabytes',999,'2025-12-02 10:14:35.331055',NULL,'2025-12-02 10:14:38.289428',29,'e491bca8-3425-41e4-bbc9-94e03ecafcff'),(30,'680813e2a2a84d78b0da5d342341d9de','shares',11,'2025-12-02 10:14:35.529909',NULL,'2025-12-02 10:14:38.231588',30,'f3282d25-f5f8-44d1-903e-e8285cbffc70'),(31,'680813e2a2a84d78b0da5d342341d9de','shares',-1,'2025-12-02 10:14:35.745677',NULL,'2025-12-02 10:14:38.174558',31,'9b6316f9-7016-46aa-b535-75923d3fa479');
/*!40000 ALTER TABLE `project_share_type_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_user_quotas`
--

DROP TABLE IF EXISTS `project_user_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_user_quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `user_id` varchar(255) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `resource` varchar(25) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_user_quotas`
--

LOCK TABLES `project_user_quotas` WRITE;
/*!40000 ALTER TABLE `project_user_quotas` DISABLE KEYS */;
INSERT INTO `project_user_quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `user_id`, `project_id`, `resource`, `hard_limit`) VALUES (1,'2025-12-02 10:14:17.372461',NULL,'2025-12-02 10:14:30.955927',1,'e3ca56c7989448c2b6be391e31145f68','680813e2a2a84d78b0da5d342341d9de','shares',2),(2,'2025-12-02 10:14:17.378022',NULL,'2025-12-02 10:14:30.955927',2,'e3ca56c7989448c2b6be391e31145f68','680813e2a2a84d78b0da5d342341d9de','gigabytes',7),(3,'2025-12-02 10:14:32.146010',NULL,'2025-12-02 10:14:32.250829',3,'e3ca56c7989448c2b6be391e31145f68','680813e2a2a84d78b0da5d342341d9de','shares',11),(4,'2025-12-02 10:14:32.994562',NULL,'2025-12-02 10:14:33.044369',4,'e3ca56c7989448c2b6be391e31145f68','680813e2a2a84d78b0da5d342341d9de','gigabytes',-1),(5,'2025-12-02 10:14:33.096285',NULL,'2025-12-02 10:14:33.148120',5,'e3ca56c7989448c2b6be391e31145f68','680813e2a2a84d78b0da5d342341d9de','share_replicas',-1),(6,'2025-12-02 10:14:33.208038',NULL,'2025-12-02 10:14:33.335107',6,'e3ca56c7989448c2b6be391e31145f68','680813e2a2a84d78b0da5d342341d9de','replica_gigabytes',-1),(7,'2025-12-02 10:14:33.423212',NULL,'2025-12-02 10:14:33.496872',7,'e3ca56c7989448c2b6be391e31145f68','680813e2a2a84d78b0da5d342341d9de','share_networks',-1),(8,'2025-12-02 10:14:33.614482',NULL,'2025-12-02 10:14:33.662132',8,'e3ca56c7989448c2b6be391e31145f68','680813e2a2a84d78b0da5d342341d9de','shares',-1),(9,'2025-12-02 10:14:33.740807',NULL,'2025-12-02 10:14:33.797819',9,'e3ca56c7989448c2b6be391e31145f68','680813e2a2a84d78b0da5d342341d9de','snapshot_gigabytes',-1),(10,'2025-12-02 10:14:33.859620',NULL,'2025-12-02 10:14:33.905666',10,'e3ca56c7989448c2b6be391e31145f68','680813e2a2a84d78b0da5d342341d9de','snapshots',-1),(11,'2025-12-02 10:14:36.475075',NULL,'2025-12-02 10:14:36.506324',11,'e3ca56c7989448c2b6be391e31145f68','680813e2a2a84d78b0da5d342341d9de','gigabytes',999),(12,'2025-12-02 10:14:36.705549',NULL,'2025-12-02 10:14:36.727969',12,'e3ca56c7989448c2b6be391e31145f68','680813e2a2a84d78b0da5d342341d9de','share_replicas',99),(13,'2025-12-02 10:14:37.186100',NULL,'2025-12-02 10:14:37.221616',13,'e3ca56c7989448c2b6be391e31145f68','680813e2a2a84d78b0da5d342341d9de','replica_gigabytes',999),(14,'2025-12-02 10:14:37.326456',NULL,'2025-12-02 10:14:37.347277',14,'e3ca56c7989448c2b6be391e31145f68','680813e2a2a84d78b0da5d342341d9de','share_networks',9),(15,'2025-12-02 10:14:37.437412',NULL,'2025-12-02 10:14:37.458837',15,'e3ca56c7989448c2b6be391e31145f68','680813e2a2a84d78b0da5d342341d9de','shares',49),(16,'2025-12-02 10:14:37.581425',NULL,'2025-12-02 10:14:37.620470',16,'e3ca56c7989448c2b6be391e31145f68','680813e2a2a84d78b0da5d342341d9de','snapshot_gigabytes',999),(17,'2025-12-02 10:14:37.724424',NULL,'2025-12-02 10:14:37.753011',17,'e3ca56c7989448c2b6be391e31145f68','680813e2a2a84d78b0da5d342341d9de','snapshots',49),(18,'2025-12-02 10:14:37.919264',NULL,'2025-12-02 10:14:37.943225',18,'e3ca56c7989448c2b6be391e31145f68','680813e2a2a84d78b0da5d342341d9de','shares',11),(19,'2025-12-02 10:14:38.083941',NULL,'2025-12-02 10:14:38.108716',19,'e3ca56c7989448c2b6be391e31145f68','680813e2a2a84d78b0da5d342341d9de','shares',-1);
/*!40000 ALTER TABLE `project_user_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_usages_project_id` (`project_id`)
) ENGINE=InnoDB AUTO_INCREMENT=270 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
INSERT INTO `quota_usages` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `resource`, `in_use`, `reserved`, `until_refresh`, `share_type_id`) VALUES ('2025-12-02 10:07:44.365126','2025-12-02 10:07:49.449698',NULL,0,1,'7e0d7dcc532b479a95d6170210f7f957','91d10c5ca25446f6a019e13492b59d1a','shares',0,0,NULL,NULL),('2025-12-02 10:07:44.372149','2025-12-02 10:07:49.449703',NULL,0,2,'7e0d7dcc532b479a95d6170210f7f957','91d10c5ca25446f6a019e13492b59d1a','gigabytes',0,0,NULL,NULL),('2025-12-02 10:07:44.388189','2025-12-02 10:07:49.449705','2025-12-02 10:07:52.240242',3,3,NULL,'91d10c5ca25446f6a019e13492b59d1a','shares',0,0,NULL,'c7843cd1-5a42-404c-8aaa-eded3337b556'),('2025-12-02 10:07:44.391810','2025-12-02 10:07:49.449707','2025-12-02 10:07:52.240242',4,4,NULL,'91d10c5ca25446f6a019e13492b59d1a','gigabytes',0,0,NULL,'c7843cd1-5a42-404c-8aaa-eded3337b556'),('2025-12-02 10:08:06.848594','2025-12-02 10:08:06.930550','2025-12-02 10:08:10.717450',5,5,'e2639de4f9f14f00b54ca602fdebfdab','12447334a8d247008c5f1d1eb28a0ff5','shares',1,0,NULL,NULL),('2025-12-02 10:08:06.851603','2025-12-02 10:08:06.930553','2025-12-02 10:08:10.717450',6,6,'e2639de4f9f14f00b54ca602fdebfdab','12447334a8d247008c5f1d1eb28a0ff5','gigabytes',1,0,NULL,NULL),('2025-12-02 10:08:06.869487','2025-12-02 10:08:06.930555','2025-12-02 10:08:10.717450',7,7,NULL,'12447334a8d247008c5f1d1eb28a0ff5','shares',1,0,NULL,'55ab5b1c-221b-4091-823f-7147eaeb86f8'),('2025-12-02 10:08:06.880456','2025-12-02 10:08:06.930557','2025-12-02 10:08:10.717450',8,8,NULL,'12447334a8d247008c5f1d1eb28a0ff5','gigabytes',1,0,NULL,'55ab5b1c-221b-4091-823f-7147eaeb86f8'),('2025-12-02 10:08:10.827746','2025-12-02 10:08:11.009762','2025-12-02 10:08:17.714256',9,9,'e2639de4f9f14f00b54ca602fdebfdab','12447334a8d247008c5f1d1eb28a0ff5','gigabytes',2,0,NULL,NULL),('2025-12-02 10:08:10.835654','2025-12-02 10:08:11.009766','2025-12-02 10:08:17.714256',10,10,'e2639de4f9f14f00b54ca602fdebfdab','12447334a8d247008c5f1d1eb28a0ff5','shares',2,0,NULL,NULL),('2025-12-02 10:08:10.962953','2025-12-02 10:08:11.009768','2025-12-02 10:08:17.714256',11,11,NULL,'12447334a8d247008c5f1d1eb28a0ff5','shares',1,0,NULL,'4e474489-1f47-45c4-b195-c18be3225ad7'),('2025-12-02 10:08:10.967365','2025-12-02 10:08:11.009769','2025-12-02 10:08:17.714256',12,12,NULL,'12447334a8d247008c5f1d1eb28a0ff5','gigabytes',1,0,NULL,'4e474489-1f47-45c4-b195-c18be3225ad7'),('2025-12-02 10:08:14.327516','2025-12-02 10:08:14.448299','2025-12-02 10:08:17.714256',13,13,'e2639de4f9f14f00b54ca602fdebfdab','12447334a8d247008c5f1d1eb28a0ff5','snapshots',1,0,NULL,NULL),('2025-12-02 10:08:14.332283','2025-12-02 10:08:14.448302','2025-12-02 10:08:17.714256',14,14,'e2639de4f9f14f00b54ca602fdebfdab','12447334a8d247008c5f1d1eb28a0ff5','snapshot_gigabytes',1,0,NULL,NULL),('2025-12-02 10:08:14.344663','2025-12-02 10:08:14.448303','2025-12-02 10:08:17.714256',15,15,NULL,'12447334a8d247008c5f1d1eb28a0ff5','snapshots',1,0,NULL,'4e474489-1f47-45c4-b195-c18be3225ad7'),('2025-12-02 10:08:14.348182','2025-12-02 10:08:14.448304','2025-12-02 10:08:17.714256',16,16,NULL,'12447334a8d247008c5f1d1eb28a0ff5','snapshot_gigabytes',1,0,NULL,'4e474489-1f47-45c4-b195-c18be3225ad7'),('2025-12-02 10:08:21.219441','2025-12-02 10:08:21.258609',NULL,0,17,'e2639de4f9f14f00b54ca602fdebfdab','12447334a8d247008c5f1d1eb28a0ff5','snapshot_gigabytes',-1,0,NULL,NULL),('2025-12-02 10:08:21.226034','2025-12-02 10:08:21.258612',NULL,0,18,'e2639de4f9f14f00b54ca602fdebfdab','12447334a8d247008c5f1d1eb28a0ff5','snapshots',-1,0,NULL,NULL),('2025-12-02 10:08:21.243610','2025-12-02 10:08:21.258613','2025-12-02 10:08:27.350714',19,19,NULL,'12447334a8d247008c5f1d1eb28a0ff5','snapshot_gigabytes',-1,0,NULL,'4e474489-1f47-45c4-b195-c18be3225ad7'),('2025-12-02 10:08:21.247165','2025-12-02 10:08:21.258614','2025-12-02 10:08:27.350714',20,20,NULL,'12447334a8d247008c5f1d1eb28a0ff5','snapshots',-1,0,NULL,'4e474489-1f47-45c4-b195-c18be3225ad7'),('2025-12-02 10:08:24.626207','2025-12-02 10:08:28.407885',NULL,0,21,'e2639de4f9f14f00b54ca602fdebfdab','12447334a8d247008c5f1d1eb28a0ff5','shares',0,0,NULL,NULL),('2025-12-02 10:08:24.637584','2025-12-02 10:08:28.407887',NULL,0,22,'e2639de4f9f14f00b54ca602fdebfdab','12447334a8d247008c5f1d1eb28a0ff5','gigabytes',0,0,NULL,NULL),('2025-12-02 10:08:24.647652','2025-12-02 10:08:24.663630','2025-12-02 10:08:27.350714',23,23,NULL,'12447334a8d247008c5f1d1eb28a0ff5','shares',0,0,NULL,'4e474489-1f47-45c4-b195-c18be3225ad7'),('2025-12-02 10:08:24.652603','2025-12-02 10:08:24.663632','2025-12-02 10:08:27.350714',24,24,NULL,'12447334a8d247008c5f1d1eb28a0ff5','gigabytes',0,0,NULL,'4e474489-1f47-45c4-b195-c18be3225ad7'),('2025-12-02 10:08:26.735676','2025-12-02 10:09:04.388532',NULL,0,25,'5c18a0166b5c4cda88d91d874afcea96','d7c3ca3eec6f4e43b7d189dbc6fd6921','shares',0,0,NULL,NULL),('2025-12-02 10:08:26.738680','2025-12-02 10:09:04.388535',NULL,0,26,'5c18a0166b5c4cda88d91d874afcea96','d7c3ca3eec6f4e43b7d189dbc6fd6921','gigabytes',0,0,NULL,NULL),('2025-12-02 10:08:26.752904','2025-12-02 10:09:04.388538','2025-12-02 10:09:07.177475',27,27,NULL,'d7c3ca3eec6f4e43b7d189dbc6fd6921','shares',0,0,NULL,'d63c996f-1244-4406-9149-4ad6fd449135'),('2025-12-02 10:08:26.756089','2025-12-02 10:09:04.388540','2025-12-02 10:09:07.177475',28,28,NULL,'d7c3ca3eec6f4e43b7d189dbc6fd6921','gigabytes',0,0,NULL,'d63c996f-1244-4406-9149-4ad6fd449135'),('2025-12-02 10:08:28.393612','2025-12-02 10:08:28.407889','2025-12-02 10:08:31.264699',29,29,NULL,'12447334a8d247008c5f1d1eb28a0ff5','shares',0,0,NULL,'55ab5b1c-221b-4091-823f-7147eaeb86f8'),('2025-12-02 10:08:28.396287','2025-12-02 10:08:28.407890','2025-12-02 10:08:31.264699',30,30,NULL,'12447334a8d247008c5f1d1eb28a0ff5','gigabytes',0,0,NULL,'55ab5b1c-221b-4091-823f-7147eaeb86f8'),('2025-12-02 10:08:30.024860','2025-12-02 10:09:01.069266',NULL,0,31,'5c18a0166b5c4cda88d91d874afcea96','d7c3ca3eec6f4e43b7d189dbc6fd6921','snapshots',0,0,NULL,NULL),('2025-12-02 10:08:30.027336','2025-12-02 10:09:01.069269',NULL,0,32,'5c18a0166b5c4cda88d91d874afcea96','d7c3ca3eec6f4e43b7d189dbc6fd6921','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-02 10:08:30.044877','2025-12-02 10:09:01.069271','2025-12-02 10:09:07.177475',33,33,NULL,'d7c3ca3eec6f4e43b7d189dbc6fd6921','snapshots',0,0,NULL,'d63c996f-1244-4406-9149-4ad6fd449135'),('2025-12-02 10:08:30.047662','2025-12-02 10:09:01.069272','2025-12-02 10:09:07.177475',34,34,NULL,'d7c3ca3eec6f4e43b7d189dbc6fd6921','snapshot_gigabytes',0,0,NULL,'d63c996f-1244-4406-9149-4ad6fd449135'),('2025-12-02 10:08:36.618919','2025-12-02 10:08:40.922884',NULL,0,35,'a3c52ee96f7342359efb8efa2c6a9d7a','8ecf0fcaf7384c7d9e2eb9c5a5e8ac26','gigabytes',0,0,NULL,NULL),('2025-12-02 10:08:36.622314','2025-12-02 10:08:40.922887',NULL,0,36,'a3c52ee96f7342359efb8efa2c6a9d7a','8ecf0fcaf7384c7d9e2eb9c5a5e8ac26','shares',0,0,NULL,NULL),('2025-12-02 10:08:36.641368','2025-12-02 10:08:40.922889','2025-12-02 10:08:43.808668',37,37,NULL,'8ecf0fcaf7384c7d9e2eb9c5a5e8ac26','gigabytes',0,0,NULL,'bd56dc3a-3508-4ec1-a3b6-c632a8233cd9'),('2025-12-02 10:08:36.645081','2025-12-02 10:08:40.922891','2025-12-02 10:08:43.808668',38,38,NULL,'8ecf0fcaf7384c7d9e2eb9c5a5e8ac26','shares',0,0,NULL,'bd56dc3a-3508-4ec1-a3b6-c632a8233cd9'),('2025-12-02 10:08:53.645486','2025-12-02 10:08:55.026689',NULL,0,39,'362fbb6a3a3644fcbec2ebd0644f5791','4021ccbfb34b44ba81a2e1baeba352f8','share_networks',0,0,NULL,NULL),('2025-12-02 10:08:54.014549','2025-12-02 10:08:54.082511',NULL,0,40,'a7bb6d80634243a38774fa458a699233','b56f565cca894a56b9aea60a840607f7','share_networks',1,0,NULL,NULL),('2025-12-02 10:09:25.904064','2025-12-02 10:12:44.905752',NULL,0,41,'26d732e2823c41e7bcdba03bb8a5b208','a241a07e4161486091e8de3f95a1d6c6','shares',0,0,NULL,NULL),('2025-12-02 10:09:25.905820','2025-12-02 10:12:44.905756',NULL,0,42,'26d732e2823c41e7bcdba03bb8a5b208','a241a07e4161486091e8de3f95a1d6c6','gigabytes',0,0,NULL,NULL),('2025-12-02 10:09:25.914916','2025-12-02 10:12:44.905758','2025-12-02 10:12:47.578644',43,43,NULL,'a241a07e4161486091e8de3f95a1d6c6','shares',0,0,NULL,'d83cee99-d595-4caa-b747-37511b270d66'),('2025-12-02 10:09:25.916899','2025-12-02 10:12:44.905760','2025-12-02 10:12:47.578644',44,44,NULL,'a241a07e4161486091e8de3f95a1d6c6','gigabytes',0,0,NULL,'d83cee99-d595-4caa-b747-37511b270d66'),('2025-12-02 10:09:52.549779','2025-12-02 10:10:03.369031',NULL,0,45,'51a2a486b9484c3d96bff111b1f22b7e','77d48f7a127b4bacb09f9e82a4c1f799','shares',1,0,NULL,NULL),('2025-12-02 10:09:52.551823','2025-12-02 10:10:03.369062',NULL,0,46,'51a2a486b9484c3d96bff111b1f22b7e','77d48f7a127b4bacb09f9e82a4c1f799','gigabytes',1,0,NULL,NULL),('2025-12-02 10:09:52.565064','2025-12-02 10:10:03.369064','2025-12-02 10:10:06.810606',47,47,NULL,'77d48f7a127b4bacb09f9e82a4c1f799','shares',1,0,NULL,'24024a73-a2c4-4572-9cd6-91a0a843f5a3'),('2025-12-02 10:09:52.567746','2025-12-02 10:10:03.369065','2025-12-02 10:10:06.810606',48,48,NULL,'77d48f7a127b4bacb09f9e82a4c1f799','gigabytes',1,0,NULL,'24024a73-a2c4-4572-9cd6-91a0a843f5a3'),('2025-12-02 10:09:55.985903','2025-12-02 10:09:56.683029',NULL,0,49,'b612e57aaeba4fb8915e8aa972bf8099','b537228b863c4207890127e098ae0f04','shares',0,0,NULL,NULL),('2025-12-02 10:09:55.987602','2025-12-02 10:09:56.683032',NULL,0,50,'b612e57aaeba4fb8915e8aa972bf8099','b537228b863c4207890127e098ae0f04','gigabytes',0,0,NULL,NULL),('2025-12-02 10:09:56.008760','2025-12-02 10:09:56.199852',NULL,0,51,'b612e57aaeba4fb8915e8aa972bf8099','77d48f7a127b4bacb09f9e82a4c1f799','shares',-1,0,NULL,NULL),('2025-12-02 10:09:56.010852','2025-12-02 10:09:56.199855',NULL,0,52,'b612e57aaeba4fb8915e8aa972bf8099','77d48f7a127b4bacb09f9e82a4c1f799','gigabytes',-1,0,NULL,NULL),('2025-12-02 10:09:56.666377','2025-12-02 10:09:56.683034','2025-12-02 10:10:06.810606',53,53,NULL,'b537228b863c4207890127e098ae0f04','shares',0,0,NULL,'24024a73-a2c4-4572-9cd6-91a0a843f5a3'),('2025-12-02 10:09:56.669240','2025-12-02 10:09:56.683035','2025-12-02 10:10:06.810606',54,54,NULL,'b537228b863c4207890127e098ae0f04','gigabytes',0,0,NULL,'24024a73-a2c4-4572-9cd6-91a0a843f5a3'),('2025-12-02 10:10:18.719671','2025-12-02 10:11:13.987140',NULL,0,55,'d177d8dee4c74ba69f8b1b2e77f73018','6a6bc1c7bc5149dfa3594ad9c3b2f7d1','shares',0,0,NULL,NULL),('2025-12-02 10:10:18.722405','2025-12-02 10:11:13.987144',NULL,0,56,'d177d8dee4c74ba69f8b1b2e77f73018','6a6bc1c7bc5149dfa3594ad9c3b2f7d1','gigabytes',0,0,NULL,NULL),('2025-12-02 10:10:18.734964','2025-12-02 10:11:13.987146','2025-12-02 10:11:16.917033',57,57,NULL,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','shares',0,0,NULL,'e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:10:18.737491','2025-12-02 10:11:13.987147','2025-12-02 10:11:16.917033',58,58,NULL,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','gigabytes',0,0,NULL,'e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:10:21.965966','2025-12-02 10:11:09.575618',NULL,0,59,'d177d8dee4c74ba69f8b1b2e77f73018','6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-02 10:10:21.969248','2025-12-02 10:11:09.575621',NULL,0,60,'d177d8dee4c74ba69f8b1b2e77f73018','6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshots',0,0,NULL,NULL),('2025-12-02 10:10:21.981761','2025-12-02 10:11:09.575623','2025-12-02 10:11:16.917033',61,61,NULL,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshot_gigabytes',0,0,NULL,'e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:10:21.984870','2025-12-02 10:11:09.575624','2025-12-02 10:11:16.917033',62,62,NULL,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshots',0,0,NULL,'e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:12:15.625386','2025-12-02 10:12:26.335637',NULL,0,63,'eec1dbb4ab40488a83c5c6e8ef9e7c00','e2aae710ad6e4ecbafd15881a70326ff','shares',0,0,NULL,NULL),('2025-12-02 10:12:15.628686','2025-12-02 10:12:26.335640',NULL,0,64,'eec1dbb4ab40488a83c5c6e8ef9e7c00','e2aae710ad6e4ecbafd15881a70326ff','gigabytes',0,0,NULL,NULL),('2025-12-02 10:12:15.642371','2025-12-02 10:12:26.335641','2025-12-02 10:12:29.204586',65,65,NULL,'e2aae710ad6e4ecbafd15881a70326ff','shares',0,0,NULL,'bca19079-5f34-42ac-949b-ea604b44b1ec'),('2025-12-02 10:12:15.644538','2025-12-02 10:12:26.335643','2025-12-02 10:12:29.204586',66,66,NULL,'e2aae710ad6e4ecbafd15881a70326ff','gigabytes',0,0,NULL,'bca19079-5f34-42ac-949b-ea604b44b1ec'),('2025-12-02 10:12:18.912701','2025-12-02 10:12:23.153258',NULL,0,67,'eec1dbb4ab40488a83c5c6e8ef9e7c00','e2aae710ad6e4ecbafd15881a70326ff','snapshots',0,0,NULL,NULL),('2025-12-02 10:12:18.915681','2025-12-02 10:12:23.153262',NULL,0,68,'eec1dbb4ab40488a83c5c6e8ef9e7c00','e2aae710ad6e4ecbafd15881a70326ff','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-02 10:12:18.927308','2025-12-02 10:12:23.153264','2025-12-02 10:12:29.204586',69,69,NULL,'e2aae710ad6e4ecbafd15881a70326ff','snapshots',0,0,NULL,'bca19079-5f34-42ac-949b-ea604b44b1ec'),('2025-12-02 10:12:18.931286','2025-12-02 10:12:23.153265','2025-12-02 10:12:29.204586',70,70,NULL,'e2aae710ad6e4ecbafd15881a70326ff','snapshot_gigabytes',0,0,NULL,'bca19079-5f34-42ac-949b-ea604b44b1ec'),('2025-12-02 10:12:27.661850','2025-12-02 10:12:41.716068',NULL,0,71,'a24970ee657641b29b0cf7283964b674','a241a07e4161486091e8de3f95a1d6c6','gigabytes',0,0,NULL,NULL),('2025-12-02 10:12:27.663629','2025-12-02 10:12:41.716070',NULL,0,72,'a24970ee657641b29b0cf7283964b674','a241a07e4161486091e8de3f95a1d6c6','shares',0,0,NULL,NULL),('2025-12-02 10:12:36.908004','2025-12-02 10:13:57.743216',NULL,0,73,'e6083d93e35641799d5c5fac36ec5423','19840b2bb2f1448facc06ad6c92f7648','gigabytes',0,0,NULL,NULL),('2025-12-02 10:12:36.910666','2025-12-02 10:13:57.743219',NULL,0,74,'e6083d93e35641799d5c5fac36ec5423','19840b2bb2f1448facc06ad6c92f7648','shares',0,0,NULL,NULL),('2025-12-02 10:12:36.926819','2025-12-02 10:13:57.743221','2025-12-02 10:14:00.554041',75,75,NULL,'19840b2bb2f1448facc06ad6c92f7648','gigabytes',0,0,NULL,'7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:12:36.930449','2025-12-02 10:13:57.743222','2025-12-02 10:14:00.554041',76,76,NULL,'19840b2bb2f1448facc06ad6c92f7648','shares',0,0,NULL,'7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:12:41.240449','2025-12-02 10:12:58.352503',NULL,0,77,'3d96130ac04f48a1ae7da918768692a0','dd2b7449046b43b2859bc0c1d65aef30','shares',0,0,NULL,NULL),('2025-12-02 10:12:41.243189','2025-12-02 10:12:58.352506',NULL,0,78,'3d96130ac04f48a1ae7da918768692a0','dd2b7449046b43b2859bc0c1d65aef30','gigabytes',0,0,NULL,NULL),('2025-12-02 10:12:41.262400','2025-12-02 10:12:58.352507','2025-12-02 10:13:01.243217',79,79,NULL,'dd2b7449046b43b2859bc0c1d65aef30','shares',0,0,NULL,'0c5d5f2e-df1d-4dc8-89ba-79d736a4ac1e'),('2025-12-02 10:12:41.265838','2025-12-02 10:12:58.352508','2025-12-02 10:13:01.243217',80,80,NULL,'dd2b7449046b43b2859bc0c1d65aef30','gigabytes',0,0,NULL,'0c5d5f2e-df1d-4dc8-89ba-79d736a4ac1e'),('2025-12-02 10:12:44.504543','2025-12-02 10:12:55.225717',NULL,0,81,'3d96130ac04f48a1ae7da918768692a0','dd2b7449046b43b2859bc0c1d65aef30','snapshots',0,0,NULL,NULL),('2025-12-02 10:12:44.506320','2025-12-02 10:12:55.225721',NULL,0,82,'3d96130ac04f48a1ae7da918768692a0','dd2b7449046b43b2859bc0c1d65aef30','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-02 10:12:44.515084','2025-12-02 10:12:55.225723','2025-12-02 10:13:01.243217',83,83,NULL,'dd2b7449046b43b2859bc0c1d65aef30','snapshots',0,0,NULL,'0c5d5f2e-df1d-4dc8-89ba-79d736a4ac1e'),('2025-12-02 10:12:44.517317','2025-12-02 10:12:55.225724','2025-12-02 10:13:01.243217',84,84,NULL,'dd2b7449046b43b2859bc0c1d65aef30','snapshot_gigabytes',0,0,NULL,'0c5d5f2e-df1d-4dc8-89ba-79d736a4ac1e'),('2025-12-02 10:13:07.093128','2025-12-02 10:13:17.721841',NULL,0,85,'da7030dac3434a548760dd16ab870b94','a1e9341f44d842eebc66ae567e788c12','shares',0,0,NULL,NULL),('2025-12-02 10:13:07.095612','2025-12-02 10:13:17.721844',NULL,0,86,'da7030dac3434a548760dd16ab870b94','a1e9341f44d842eebc66ae567e788c12','gigabytes',0,0,NULL,NULL),('2025-12-02 10:13:07.104704','2025-12-02 10:13:17.721846','2025-12-02 10:13:20.593184',87,87,NULL,'a1e9341f44d842eebc66ae567e788c12','shares',0,0,NULL,'d9b33f45-8607-4704-83ed-bb8ffbbe3d7a'),('2025-12-02 10:13:07.107513','2025-12-02 10:13:17.721848','2025-12-02 10:13:20.593184',88,88,NULL,'a1e9341f44d842eebc66ae567e788c12','gigabytes',0,0,NULL,'d9b33f45-8607-4704-83ed-bb8ffbbe3d7a'),('2025-12-02 10:13:08.099043','2025-12-02 10:13:09.437526',NULL,0,89,'9589fe7bcd86443cb59c8eabe6353abf','b49a81aec3ba47f98ba171f12cd88b8a','share_networks',0,0,NULL,NULL),('2025-12-02 10:13:10.444476','2025-12-02 10:13:14.583367',NULL,0,90,'da7030dac3434a548760dd16ab870b94','a1e9341f44d842eebc66ae567e788c12','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-02 10:13:10.446949','2025-12-02 10:13:14.583370',NULL,0,91,'da7030dac3434a548760dd16ab870b94','a1e9341f44d842eebc66ae567e788c12','snapshots',0,0,NULL,NULL),('2025-12-02 10:13:10.463239','2025-12-02 10:13:14.583371','2025-12-02 10:13:20.593184',92,92,NULL,'a1e9341f44d842eebc66ae567e788c12','snapshot_gigabytes',0,0,NULL,'d9b33f45-8607-4704-83ed-bb8ffbbe3d7a'),('2025-12-02 10:13:10.465410','2025-12-02 10:13:14.583372','2025-12-02 10:13:20.593184',93,93,NULL,'a1e9341f44d842eebc66ae567e788c12','snapshots',0,0,NULL,'d9b33f45-8607-4704-83ed-bb8ffbbe3d7a'),('2025-12-02 10:13:12.969351','2025-12-02 10:13:54.388876',NULL,0,94,'e6083d93e35641799d5c5fac36ec5423','19840b2bb2f1448facc06ad6c92f7648','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-02 10:13:12.971449','2025-12-02 10:13:54.388879',NULL,0,95,'e6083d93e35641799d5c5fac36ec5423','19840b2bb2f1448facc06ad6c92f7648','snapshots',0,0,NULL,NULL),('2025-12-02 10:13:12.983043','2025-12-02 10:13:54.388880','2025-12-02 10:14:00.554041',96,96,NULL,'19840b2bb2f1448facc06ad6c92f7648','snapshot_gigabytes',0,0,NULL,'7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:12.985322','2025-12-02 10:13:54.388881','2025-12-02 10:14:00.554041',97,97,NULL,'19840b2bb2f1448facc06ad6c92f7648','snapshots',0,0,NULL,'7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:25.683931','2025-12-02 10:14:02.028120',NULL,0,98,'b27f974843b944ad89618a9e837b7d08','1d8a048450454feda5d5f8e5791593b2','shares',0,0,NULL,NULL),('2025-12-02 10:13:25.686535','2025-12-02 10:14:02.028123',NULL,0,99,'b27f974843b944ad89618a9e837b7d08','1d8a048450454feda5d5f8e5791593b2','gigabytes',0,0,NULL,NULL),('2025-12-02 10:13:25.702560','2025-12-02 10:13:29.209217','2025-12-02 10:14:02.685538',100,100,NULL,'1d8a048450454feda5d5f8e5791593b2','shares',0,0,NULL,'711e4bca-5889-4f1b-89b1-9c764a24ece6'),('2025-12-02 10:13:25.706089','2025-12-02 10:13:29.209218','2025-12-02 10:14:02.685538',101,101,NULL,'1d8a048450454feda5d5f8e5791593b2','gigabytes',0,0,NULL,'711e4bca-5889-4f1b-89b1-9c764a24ece6'),('2025-12-02 10:13:29.396374','2025-12-02 10:13:32.856960','2025-12-02 10:14:02.584642',102,102,NULL,'1d8a048450454feda5d5f8e5791593b2','shares',0,0,NULL,'db8cf28f-b745-44d5-994c-083b9e44d810'),('2025-12-02 10:13:29.398469','2025-12-02 10:13:32.856962','2025-12-02 10:14:02.584642',103,103,NULL,'1d8a048450454feda5d5f8e5791593b2','gigabytes',0,0,NULL,'db8cf28f-b745-44d5-994c-083b9e44d810'),('2025-12-02 10:13:32.983856','2025-12-02 10:13:39.904031','2025-12-02 10:14:02.518302',104,104,NULL,'1d8a048450454feda5d5f8e5791593b2','gigabytes',0,0,NULL,'0eebaea2-ff0c-4c78-a7aa-627703af02da'),('2025-12-02 10:13:32.985942','2025-12-02 10:13:39.904032','2025-12-02 10:14:02.518302',105,105,NULL,'1d8a048450454feda5d5f8e5791593b2','shares',0,0,NULL,'0eebaea2-ff0c-4c78-a7aa-627703af02da'),('2025-12-02 10:13:36.319828','2025-12-02 10:13:39.678971','2025-12-02 10:14:02.471523',106,106,NULL,'1d8a048450454feda5d5f8e5791593b2','gigabytes',0,0,NULL,'d25d2ab8-3188-40e8-af40-2b39819c2e82'),('2025-12-02 10:13:36.321911','2025-12-02 10:13:39.678972','2025-12-02 10:14:02.471523',107,107,NULL,'1d8a048450454feda5d5f8e5791593b2','shares',0,0,NULL,'d25d2ab8-3188-40e8-af40-2b39819c2e82'),('2025-12-02 10:13:40.020262','2025-12-02 10:13:51.466123','2025-12-02 10:14:02.419167',108,108,NULL,'1d8a048450454feda5d5f8e5791593b2','shares',0,0,NULL,'169f89af-92d9-45d8-a6ff-2b057292ec5d'),('2025-12-02 10:13:40.025439','2025-12-02 10:13:51.466125','2025-12-02 10:14:02.419167',109,109,NULL,'1d8a048450454feda5d5f8e5791593b2','gigabytes',0,0,NULL,'169f89af-92d9-45d8-a6ff-2b057292ec5d'),('2025-12-02 10:13:43.313822','2025-12-02 10:13:51.198201','2025-12-02 10:14:02.312348',110,110,NULL,'1d8a048450454feda5d5f8e5791593b2','shares',0,0,NULL,'5c9821fc-8249-4669-8076-47f553817f41'),('2025-12-02 10:13:43.318264','2025-12-02 10:13:51.198203','2025-12-02 10:14:02.312348',111,111,NULL,'1d8a048450454feda5d5f8e5791593b2','gigabytes',0,0,NULL,'5c9821fc-8249-4669-8076-47f553817f41'),('2025-12-02 10:13:45.267009','2025-12-02 10:14:03.327089',NULL,0,112,'1b4a891633ec4d619106657cfbf2d339','e8295af6a4df4c97a379f21f43a2e9aa','shares',0,0,NULL,NULL),('2025-12-02 10:13:45.269978','2025-12-02 10:14:03.327091',NULL,0,113,'1b4a891633ec4d619106657cfbf2d339','e8295af6a4df4c97a379f21f43a2e9aa','gigabytes',0,0,NULL,NULL),('2025-12-02 10:13:45.313951','2025-12-02 10:13:48.888806','2025-12-02 10:14:03.824333',114,114,NULL,'e8295af6a4df4c97a379f21f43a2e9aa','shares',0,0,NULL,'a807fa7c-8899-4290-bdc5-ce3fd1558599'),('2025-12-02 10:13:45.319332','2025-12-02 10:13:48.888808','2025-12-02 10:14:03.824333',115,115,NULL,'e8295af6a4df4c97a379f21f43a2e9aa','gigabytes',0,0,NULL,'a807fa7c-8899-4290-bdc5-ce3fd1558599'),('2025-12-02 10:13:46.611696','2025-12-02 10:13:50.901305','2025-12-02 10:14:02.247771',116,116,NULL,'1d8a048450454feda5d5f8e5791593b2','gigabytes',0,0,NULL,'62285f73-1306-4f80-ada0-224e9e052cb7'),('2025-12-02 10:13:46.614443','2025-12-02 10:13:50.901307','2025-12-02 10:14:02.247771',117,117,NULL,'1d8a048450454feda5d5f8e5791593b2','shares',0,0,NULL,'62285f73-1306-4f80-ada0-224e9e052cb7'),('2025-12-02 10:13:48.983280','2025-12-02 10:13:52.376549','2025-12-02 10:14:03.761783',118,118,NULL,'e8295af6a4df4c97a379f21f43a2e9aa','shares',0,0,NULL,'ed0e827f-6d45-45e1-93e3-29b4b6d5f037'),('2025-12-02 10:13:48.986843','2025-12-02 10:13:52.376550','2025-12-02 10:14:03.761783',119,119,NULL,'e8295af6a4df4c97a379f21f43a2e9aa','gigabytes',0,0,NULL,'ed0e827f-6d45-45e1-93e3-29b4b6d5f037'),('2025-12-02 10:13:51.577110','2025-12-02 10:13:58.458208','2025-12-02 10:14:02.186026',120,120,NULL,'1d8a048450454feda5d5f8e5791593b2','shares',0,0,NULL,'7e7b46db-703f-4d92-9566-94b272d383d2'),('2025-12-02 10:13:51.579118','2025-12-02 10:13:58.458209','2025-12-02 10:14:02.186026',121,121,NULL,'1d8a048450454feda5d5f8e5791593b2','gigabytes',0,0,NULL,'7e7b46db-703f-4d92-9566-94b272d383d2'),('2025-12-02 10:13:52.461366','2025-12-02 10:13:56.100084','2025-12-02 10:14:03.703304',122,122,NULL,'e8295af6a4df4c97a379f21f43a2e9aa','shares',0,0,NULL,'2b32e3ab-93e6-44c0-a768-7050b468c86b'),('2025-12-02 10:13:52.464217','2025-12-02 10:13:56.100087','2025-12-02 10:14:03.703304',123,123,NULL,'e8295af6a4df4c97a379f21f43a2e9aa','gigabytes',0,0,NULL,'2b32e3ab-93e6-44c0-a768-7050b468c86b'),('2025-12-02 10:13:54.805535','2025-12-02 10:13:58.263618','2025-12-02 10:14:02.136784',124,124,NULL,'1d8a048450454feda5d5f8e5791593b2','shares',0,0,NULL,'017e711d-ae02-4b81-8c99-e58638a5043c'),('2025-12-02 10:13:54.807330','2025-12-02 10:13:58.263619','2025-12-02 10:14:02.136784',125,125,NULL,'1d8a048450454feda5d5f8e5791593b2','gigabytes',0,0,NULL,'017e711d-ae02-4b81-8c99-e58638a5043c'),('2025-12-02 10:13:56.207447','2025-12-02 10:13:59.549419','2025-12-02 10:14:03.635778',126,126,NULL,'e8295af6a4df4c97a379f21f43a2e9aa','shares',0,0,NULL,'1d7eca00-9971-4868-a843-784802455931'),('2025-12-02 10:13:56.210183','2025-12-02 10:13:59.549421','2025-12-02 10:14:03.635778',127,127,NULL,'e8295af6a4df4c97a379f21f43a2e9aa','gigabytes',0,0,NULL,'1d7eca00-9971-4868-a843-784802455931'),('2025-12-02 10:13:58.589698','2025-12-02 10:14:02.028124','2025-12-02 10:14:02.076690',128,128,NULL,'1d8a048450454feda5d5f8e5791593b2','shares',0,0,NULL,'18e71d95-b3f1-4c37-b1dc-da71dd921cde'),('2025-12-02 10:13:58.591812','2025-12-02 10:14:02.028125','2025-12-02 10:14:02.076690',129,129,NULL,'1d8a048450454feda5d5f8e5791593b2','gigabytes',0,0,NULL,'18e71d95-b3f1-4c37-b1dc-da71dd921cde'),('2025-12-02 10:13:59.641109','2025-12-02 10:14:03.327092','2025-12-02 10:14:03.578396',130,130,NULL,'e8295af6a4df4c97a379f21f43a2e9aa','shares',0,0,NULL,'ad48deb0-4c66-465e-aa4f-dd43e27fecc0'),('2025-12-02 10:13:59.642987','2025-12-02 10:14:03.327094','2025-12-02 10:14:03.578396',131,131,NULL,'e8295af6a4df4c97a379f21f43a2e9aa','gigabytes',0,0,NULL,'ad48deb0-4c66-465e-aa4f-dd43e27fecc0'),('2025-12-02 10:14:12.858848','2025-12-02 10:14:17.558590',NULL,0,132,'dbaeaeed65b44f5f85d2e43c20bd916e','5974c1b38c02486098e277d58b491dac','shares',0,0,NULL,NULL),('2025-12-02 10:14:12.861546','2025-12-02 10:14:17.558593',NULL,0,133,'dbaeaeed65b44f5f85d2e43c20bd916e','5974c1b38c02486098e277d58b491dac','gigabytes',0,0,NULL,NULL),('2025-12-02 10:14:12.874941','2025-12-02 10:14:17.558594','2025-12-02 10:14:19.904618',134,134,NULL,'5974c1b38c02486098e277d58b491dac','shares',0,0,NULL,'ffbcd882-a642-42d8-a748-2f0d2086d753'),('2025-12-02 10:14:12.877221','2025-12-02 10:14:17.558596','2025-12-02 10:14:19.904618',135,135,NULL,'5974c1b38c02486098e277d58b491dac','gigabytes',0,0,NULL,'ffbcd882-a642-42d8-a748-2f0d2086d753'),('2025-12-02 10:14:13.109366','2025-12-02 10:14:23.635951',NULL,0,136,'2bab38cd1afa4f1cb56ae5e3471916e7','914633b51dfe4f69869861586a905b4f','shares',0,0,NULL,NULL),('2025-12-02 10:14:13.111855','2025-12-02 10:14:23.635954',NULL,0,137,'2bab38cd1afa4f1cb56ae5e3471916e7','914633b51dfe4f69869861586a905b4f','gigabytes',0,0,NULL,NULL),('2025-12-02 10:14:13.126990','2025-12-02 10:14:23.635955','2025-12-02 10:14:33.640809',138,138,NULL,'914633b51dfe4f69869861586a905b4f','shares',0,0,NULL,'40450f64-4e41-484c-9658-544335bdf9c8'),('2025-12-02 10:14:13.131909','2025-12-02 10:14:23.635956','2025-12-02 10:14:33.640809',139,139,NULL,'914633b51dfe4f69869861586a905b4f','gigabytes',0,0,NULL,'40450f64-4e41-484c-9658-544335bdf9c8'),('2025-12-02 10:14:16.660849','2025-12-02 10:14:30.375344',NULL,0,140,'f2cff7ece9574fa997525a5363ecba58','87cdd4c8f591435eb43e3200734202e3','shares',0,0,NULL,NULL),('2025-12-02 10:14:16.662892','2025-12-02 10:14:30.375347',NULL,0,141,'f2cff7ece9574fa997525a5363ecba58','87cdd4c8f591435eb43e3200734202e3','gigabytes',0,0,NULL,NULL),('2025-12-02 10:14:16.672097','2025-12-02 10:14:30.375348','2025-12-02 10:14:33.640809',142,142,NULL,'87cdd4c8f591435eb43e3200734202e3','shares',0,0,NULL,'40450f64-4e41-484c-9658-544335bdf9c8'),('2025-12-02 10:14:16.674299','2025-12-02 10:14:30.375349','2025-12-02 10:14:33.640809',143,143,NULL,'87cdd4c8f591435eb43e3200734202e3','gigabytes',0,0,NULL,'40450f64-4e41-484c-9658-544335bdf9c8'),('2025-12-02 10:14:17.561544','2025-12-02 10:14:28.104889','2025-12-02 10:14:30.961870',144,144,'e3ca56c7989448c2b6be391e31145f68','680813e2a2a84d78b0da5d342341d9de','shares',0,0,NULL,NULL),('2025-12-02 10:14:17.563493','2025-12-02 10:14:28.104893','2025-12-02 10:14:30.961870',145,145,'e3ca56c7989448c2b6be391e31145f68','680813e2a2a84d78b0da5d342341d9de','gigabytes',0,0,NULL,NULL),('2025-12-02 10:14:17.575692','2025-12-02 10:14:24.628438','2025-12-02 10:14:30.998152',146,146,NULL,'680813e2a2a84d78b0da5d342341d9de','shares',0,0,NULL,'c5eabd7f-49df-4d97-ac80-6482db3b660b'),('2025-12-02 10:14:17.578965','2025-12-02 10:14:24.628439','2025-12-02 10:14:30.998152',147,147,NULL,'680813e2a2a84d78b0da5d342341d9de','gigabytes',0,0,NULL,'c5eabd7f-49df-4d97-ac80-6482db3b660b'),('2025-12-02 10:14:20.948881','2025-12-02 10:14:28.104895','2025-12-02 10:14:30.998152',148,148,NULL,'680813e2a2a84d78b0da5d342341d9de','shares',0,0,NULL,'49fe7987-9e54-4fce-a1b2-017c50dd85f9'),('2025-12-02 10:14:20.951478','2025-12-02 10:14:28.104896','2025-12-02 10:14:30.998152',149,149,NULL,'680813e2a2a84d78b0da5d342341d9de','gigabytes',0,0,NULL,'49fe7987-9e54-4fce-a1b2-017c50dd85f9'),('2025-12-02 10:14:36.093853','2025-12-02 10:14:58.019412',NULL,0,150,'1a03624069ce41fcb02f5e929815f66c','8f75117f8554499b9fbaa9c9062eeeef','shares',0,0,NULL,NULL),('2025-12-02 10:14:36.096538','2025-12-02 10:14:58.019415',NULL,0,151,'1a03624069ce41fcb02f5e929815f66c','8f75117f8554499b9fbaa9c9062eeeef','gigabytes',0,0,NULL,NULL),('2025-12-02 10:14:36.114627','2025-12-02 10:14:58.019418','2025-12-02 10:15:00.366865',152,152,NULL,'8f75117f8554499b9fbaa9c9062eeeef','shares',0,0,NULL,'36dcded1-31d3-40d9-bb47-df8b0de68b92'),('2025-12-02 10:14:36.117325','2025-12-02 10:14:58.019419','2025-12-02 10:15:00.366865',153,153,NULL,'8f75117f8554499b9fbaa9c9062eeeef','gigabytes',0,0,NULL,'36dcded1-31d3-40d9-bb47-df8b0de68b92'),('2025-12-02 10:14:38.876805','2025-12-02 10:14:40.282562',NULL,0,154,'bd7f2d7611734550bbffc82296b63298','2f5b0cb9136e40b1a7b70e89b03f2784','share_networks',0,0,NULL,NULL),('2025-12-02 10:14:45.988821','2025-12-02 10:15:30.346207',NULL,0,155,'8186b016983446bb95a4c7821dfa53bb','18e2a69daf6849dead0b925033d0fbad','gigabytes',0,0,NULL,NULL),('2025-12-02 10:14:45.991141','2025-12-02 10:15:30.346209',NULL,0,156,'8186b016983446bb95a4c7821dfa53bb','18e2a69daf6849dead0b925033d0fbad','shares',0,0,NULL,NULL),('2025-12-02 10:14:46.001680','2025-12-02 10:15:30.346211','2025-12-02 10:15:33.201078',157,157,NULL,'18e2a69daf6849dead0b925033d0fbad','gigabytes',0,0,NULL,'9bfec2f4-a1c2-4bb7-b734-09f9d3fd4aa4'),('2025-12-02 10:14:46.004435','2025-12-02 10:15:30.346212','2025-12-02 10:15:33.201078',158,158,NULL,'18e2a69daf6849dead0b925033d0fbad','shares',0,0,NULL,'9bfec2f4-a1c2-4bb7-b734-09f9d3fd4aa4'),('2025-12-02 10:14:48.108037','2025-12-02 10:14:52.396406',NULL,0,159,'404a2149cc4c442e8f29fae023953b63','6b9f3a4e12754a9ab7a5077a3e0bb303','shares',0,0,NULL,NULL),('2025-12-02 10:14:48.110447','2025-12-02 10:14:52.396410',NULL,0,160,'404a2149cc4c442e8f29fae023953b63','6b9f3a4e12754a9ab7a5077a3e0bb303','gigabytes',0,0,NULL,NULL),('2025-12-02 10:14:48.120580','2025-12-02 10:14:52.396412','2025-12-02 10:14:55.021417',161,161,NULL,'6b9f3a4e12754a9ab7a5077a3e0bb303','shares',0,0,NULL,'009a0375-1724-45ed-a672-bbd9ee8c52a1'),('2025-12-02 10:14:48.122839','2025-12-02 10:14:52.396414','2025-12-02 10:14:55.021417',162,162,NULL,'6b9f3a4e12754a9ab7a5077a3e0bb303','gigabytes',0,0,NULL,'009a0375-1724-45ed-a672-bbd9ee8c52a1'),('2025-12-02 10:14:49.257388','2025-12-02 10:15:27.191872',NULL,0,163,'8186b016983446bb95a4c7821dfa53bb','18e2a69daf6849dead0b925033d0fbad','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-02 10:14:49.265766','2025-12-02 10:15:27.191875',NULL,0,164,'8186b016983446bb95a4c7821dfa53bb','18e2a69daf6849dead0b925033d0fbad','snapshots',0,0,NULL,NULL),('2025-12-02 10:14:49.281837','2025-12-02 10:15:27.191877','2025-12-02 10:15:33.201078',165,165,NULL,'18e2a69daf6849dead0b925033d0fbad','snapshot_gigabytes',0,0,NULL,'9bfec2f4-a1c2-4bb7-b734-09f9d3fd4aa4'),('2025-12-02 10:14:49.284787','2025-12-02 10:15:27.191879','2025-12-02 10:15:33.201078',166,166,NULL,'18e2a69daf6849dead0b925033d0fbad','snapshots',0,0,NULL,'9bfec2f4-a1c2-4bb7-b734-09f9d3fd4aa4'),('2025-12-02 10:14:51.826651','2025-12-02 10:15:28.095139',NULL,0,167,'fb7fbe93d5b34afb91f154a1f8487fed','7e6f29bbe0f44b04ada8cc16426d3961','gigabytes',0,0,NULL,NULL),('2025-12-02 10:14:51.829058','2025-12-02 10:15:28.095142',NULL,0,168,'fb7fbe93d5b34afb91f154a1f8487fed','7e6f29bbe0f44b04ada8cc16426d3961','shares',0,0,NULL,NULL),('2025-12-02 10:14:51.840822','2025-12-02 10:15:28.095143','2025-12-02 10:15:31.357080',169,169,NULL,'7e6f29bbe0f44b04ada8cc16426d3961','gigabytes',0,0,NULL,'b9770666-8e95-4332-8979-dfdeb115eaf8'),('2025-12-02 10:14:51.843874','2025-12-02 10:15:28.095144','2025-12-02 10:15:31.357080',170,170,NULL,'7e6f29bbe0f44b04ada8cc16426d3961','shares',0,0,NULL,'b9770666-8e95-4332-8979-dfdeb115eaf8'),('2025-12-02 10:14:57.825545','2025-12-02 10:14:59.651328',NULL,0,171,'fbf6b461791a43fab13e6d1ef1e44841','5cdb1413e33f45cd8056ae0098190bd6','share_networks',0,0,NULL,NULL),('2025-12-02 10:15:04.410749','2025-12-02 10:16:05.363599',NULL,0,172,'bb93ce39d4d54c7380f75f22f5ffc493','82d5a09e66904b8ca3c7a7850f1e5c52','shares',0,0,NULL,NULL),('2025-12-02 10:15:04.413378','2025-12-02 10:16:05.363602',NULL,0,173,'bb93ce39d4d54c7380f75f22f5ffc493','82d5a09e66904b8ca3c7a7850f1e5c52','gigabytes',0,0,NULL,NULL),('2025-12-02 10:15:04.427324','2025-12-02 10:16:05.363603','2025-12-02 10:16:08.238285',174,174,NULL,'82d5a09e66904b8ca3c7a7850f1e5c52','shares',0,0,NULL,'61627d65-42d5-4d24-81b9-703b092c0068'),('2025-12-02 10:15:04.430290','2025-12-02 10:16:05.363605','2025-12-02 10:16:08.238285',175,175,NULL,'82d5a09e66904b8ca3c7a7850f1e5c52','gigabytes',0,0,NULL,'61627d65-42d5-4d24-81b9-703b092c0068'),('2025-12-02 10:15:04.961606','2025-12-02 10:15:14.695415',NULL,0,176,'fb7fbe93d5b34afb91f154a1f8487fed','7e6f29bbe0f44b04ada8cc16426d3961','share_groups',0,0,NULL,NULL),('2025-12-02 10:15:09.605259','2025-12-02 10:16:09.879565',NULL,0,177,'7c87e5c44dfa4bd3835e77bc991eb253','0fe90f11d3f64e12b3591732792a929e','shares',0,0,NULL,NULL),('2025-12-02 10:15:09.609027','2025-12-02 10:16:09.879568',NULL,0,178,'7c87e5c44dfa4bd3835e77bc991eb253','0fe90f11d3f64e12b3591732792a929e','gigabytes',0,0,NULL,NULL),('2025-12-02 10:15:09.619274','2025-12-02 10:16:09.879569','2025-12-02 10:16:12.252127',179,179,NULL,'0fe90f11d3f64e12b3591732792a929e','shares',0,0,NULL,'2cf6aa27-89aa-44f3-a131-dee193f9f9f9'),('2025-12-02 10:15:09.621253','2025-12-02 10:16:09.879570','2025-12-02 10:16:12.252127',180,180,NULL,'0fe90f11d3f64e12b3591732792a929e','gigabytes',0,0,NULL,'2cf6aa27-89aa-44f3-a131-dee193f9f9f9'),('2025-12-02 10:15:13.004875','2025-12-02 10:16:06.351566',NULL,0,181,NULL,'0fe90f11d3f64e12b3591732792a929e','gigabytes',0,0,NULL,'0a22f71a-1e77-4d73-a77a-d76be02b5792'),('2025-12-02 10:15:13.006932','2025-12-02 10:16:06.351568',NULL,0,182,NULL,'0fe90f11d3f64e12b3591732792a929e','shares',0,0,NULL,'0a22f71a-1e77-4d73-a77a-d76be02b5792'),('2025-12-02 10:15:16.117274','2025-12-02 10:15:18.189855',NULL,0,183,'98ea0090b3f5415e9d68555dc2519917','2663dddab79d4a678692e6a4e964573c','share_networks',0,0,NULL,NULL),('2025-12-02 10:15:19.596190','2025-12-02 10:16:02.893685',NULL,0,184,'19c2bca62a264b93add0d8ce170a4fe5','3212fac1e026474b9022ee93e4d925a9','shares',0,0,NULL,NULL),('2025-12-02 10:15:19.597963','2025-12-02 10:16:02.893688',NULL,0,185,'19c2bca62a264b93add0d8ce170a4fe5','3212fac1e026474b9022ee93e4d925a9','gigabytes',0,0,NULL,NULL),('2025-12-02 10:15:19.608686','2025-12-02 10:16:02.893689',NULL,0,186,NULL,'3212fac1e026474b9022ee93e4d925a9','shares',0,0,NULL,'0a22f71a-1e77-4d73-a77a-d76be02b5792'),('2025-12-02 10:15:19.610926','2025-12-02 10:16:02.893690',NULL,0,187,NULL,'3212fac1e026474b9022ee93e4d925a9','gigabytes',0,0,NULL,'0a22f71a-1e77-4d73-a77a-d76be02b5792'),('2025-12-02 10:15:26.442502','2025-12-02 10:15:37.216495',NULL,0,188,'495e92f347994b92b115e46dbd6cbb52','7eed616d73ab4e4787ac3b5f13befa7f','shares',0,0,NULL,NULL),('2025-12-02 10:15:26.445438','2025-12-02 10:15:37.216498',NULL,0,189,'495e92f347994b92b115e46dbd6cbb52','7eed616d73ab4e4787ac3b5f13befa7f','gigabytes',0,0,NULL,NULL),('2025-12-02 10:15:26.464027','2025-12-02 10:15:37.216500','2025-12-02 10:15:40.031434',190,190,NULL,'7eed616d73ab4e4787ac3b5f13befa7f','shares',0,0,NULL,'cf925afd-ec83-41f6-ae4f-7d36193ae5b9'),('2025-12-02 10:15:26.466382','2025-12-02 10:15:37.216501','2025-12-02 10:15:40.031434',191,191,NULL,'7eed616d73ab4e4787ac3b5f13befa7f','gigabytes',0,0,NULL,'cf925afd-ec83-41f6-ae4f-7d36193ae5b9'),('2025-12-02 10:15:29.695149','2025-12-02 10:15:33.997092',NULL,0,192,'495e92f347994b92b115e46dbd6cbb52','7eed616d73ab4e4787ac3b5f13befa7f','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-02 10:15:29.697420','2025-12-02 10:15:33.997095',NULL,0,193,'495e92f347994b92b115e46dbd6cbb52','7eed616d73ab4e4787ac3b5f13befa7f','snapshots',0,0,NULL,NULL),('2025-12-02 10:15:29.707285','2025-12-02 10:15:33.997096','2025-12-02 10:15:40.031434',194,194,NULL,'7eed616d73ab4e4787ac3b5f13befa7f','snapshot_gigabytes',0,0,NULL,'cf925afd-ec83-41f6-ae4f-7d36193ae5b9'),('2025-12-02 10:15:29.709639','2025-12-02 10:15:33.997097','2025-12-02 10:15:40.031434',195,195,NULL,'7eed616d73ab4e4787ac3b5f13befa7f','snapshots',0,0,NULL,'cf925afd-ec83-41f6-ae4f-7d36193ae5b9'),('2025-12-02 10:15:45.863891','2025-12-02 10:15:59.549495','2025-12-02 10:16:12.252127',196,196,NULL,'3212fac1e026474b9022ee93e4d925a9','shares',0,0,NULL,'2cf6aa27-89aa-44f3-a131-dee193f9f9f9'),('2025-12-02 10:15:45.866548','2025-12-02 10:15:59.549496','2025-12-02 10:16:12.252127',197,197,NULL,'3212fac1e026474b9022ee93e4d925a9','gigabytes',0,0,NULL,'2cf6aa27-89aa-44f3-a131-dee193f9f9f9'),('2025-12-02 10:15:46.741952','2025-12-02 10:17:00.679958',NULL,0,198,'94497d8ddfcd4635afc8344cac93faeb','e5b9281b44db4ae9a4ea3491729cac38','shares',0,0,NULL,NULL),('2025-12-02 10:15:46.743982','2025-12-02 10:17:00.679962',NULL,0,199,'94497d8ddfcd4635afc8344cac93faeb','e5b9281b44db4ae9a4ea3491729cac38','gigabytes',0,0,NULL,NULL),('2025-12-02 10:15:46.756986','2025-12-02 10:15:57.534189','2025-12-02 10:15:59.965224',200,200,NULL,'e5b9281b44db4ae9a4ea3491729cac38','shares',0,0,NULL,'f12b899b-f337-4dc8-80ef-d46fe8195820'),('2025-12-02 10:15:46.759681','2025-12-02 10:15:57.534190','2025-12-02 10:15:59.965224',201,201,NULL,'e5b9281b44db4ae9a4ea3491729cac38','gigabytes',0,0,NULL,'f12b899b-f337-4dc8-80ef-d46fe8195820'),('2025-12-02 10:15:50.054347','2025-12-02 10:16:57.517854',NULL,0,202,'94497d8ddfcd4635afc8344cac93faeb','e5b9281b44db4ae9a4ea3491729cac38','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-02 10:15:50.057353','2025-12-02 10:16:57.517858',NULL,0,203,'94497d8ddfcd4635afc8344cac93faeb','e5b9281b44db4ae9a4ea3491729cac38','snapshots',0,0,NULL,NULL),('2025-12-02 10:15:50.109945','2025-12-02 10:15:54.020640','2025-12-02 10:15:59.965224',204,204,NULL,'e5b9281b44db4ae9a4ea3491729cac38','snapshot_gigabytes',0,0,NULL,'f12b899b-f337-4dc8-80ef-d46fe8195820'),('2025-12-02 10:15:50.112228','2025-12-02 10:15:54.020641','2025-12-02 10:15:59.965224',205,205,NULL,'e5b9281b44db4ae9a4ea3491729cac38','snapshots',0,0,NULL,'f12b899b-f337-4dc8-80ef-d46fe8195820'),('2025-12-02 10:16:00.038344','2025-12-02 10:16:04.182789','2025-12-02 10:17:04.210362',206,206,NULL,'e5b9281b44db4ae9a4ea3491729cac38','gigabytes',0,0,NULL,'5e3e7606-09e7-4fd6-b5da-cad820a5282f'),('2025-12-02 10:16:00.040543','2025-12-02 10:16:04.182791','2025-12-02 10:17:04.210362',207,207,NULL,'e5b9281b44db4ae9a4ea3491729cac38','shares',0,0,NULL,'5e3e7606-09e7-4fd6-b5da-cad820a5282f'),('2025-12-02 10:16:06.655496','2025-12-02 10:17:00.679963','2025-12-02 10:17:03.578863',208,208,NULL,'e5b9281b44db4ae9a4ea3491729cac38','shares',0,0,NULL,'74240a28-7ae2-4dd1-899e-66aa4d85a55a'),('2025-12-02 10:16:06.663906','2025-12-02 10:17:00.679965','2025-12-02 10:17:03.578863',209,209,NULL,'e5b9281b44db4ae9a4ea3491729cac38','gigabytes',0,0,NULL,'74240a28-7ae2-4dd1-899e-66aa4d85a55a'),('2025-12-02 10:16:10.101944','2025-12-02 10:16:57.517860','2025-12-02 10:17:03.578863',210,210,NULL,'e5b9281b44db4ae9a4ea3491729cac38','snapshots',0,0,NULL,'74240a28-7ae2-4dd1-899e-66aa4d85a55a'),('2025-12-02 10:16:10.106627','2025-12-02 10:16:57.517863','2025-12-02 10:17:03.578863',211,211,NULL,'e5b9281b44db4ae9a4ea3491729cac38','snapshot_gigabytes',0,0,NULL,'74240a28-7ae2-4dd1-899e-66aa4d85a55a'),('2025-12-02 10:16:18.716292','2025-12-02 10:16:29.533835',NULL,0,212,'3981613749ea480688db1adf3b6b82ce','42ab83296c4741bfa1dbb24e1dcf2c90','shares',0,0,NULL,NULL),('2025-12-02 10:16:18.718591','2025-12-02 10:16:29.533838',NULL,0,213,'3981613749ea480688db1adf3b6b82ce','42ab83296c4741bfa1dbb24e1dcf2c90','gigabytes',0,0,NULL,NULL),('2025-12-02 10:16:18.760274','2025-12-02 10:16:29.533840','2025-12-02 10:16:32.410281',214,214,NULL,'42ab83296c4741bfa1dbb24e1dcf2c90','shares',0,0,NULL,'ff8f71f1-fb64-4b62-84e9-b60238891f66'),('2025-12-02 10:16:18.762826','2025-12-02 10:16:29.533841','2025-12-02 10:16:32.410281',215,215,NULL,'42ab83296c4741bfa1dbb24e1dcf2c90','gigabytes',0,0,NULL,'ff8f71f1-fb64-4b62-84e9-b60238891f66'),('2025-12-02 10:16:21.477615','2025-12-02 10:16:46.444705',NULL,0,216,'bdac673e7e5c4cfaae7d942c9db671c4','5b81ca02bbcb470597d21e5b9567c00e','shares',0,0,NULL,NULL),('2025-12-02 10:16:21.479687','2025-12-02 10:16:46.444708',NULL,0,217,'bdac673e7e5c4cfaae7d942c9db671c4','5b81ca02bbcb470597d21e5b9567c00e','gigabytes',0,0,NULL,NULL),('2025-12-02 10:16:21.492049','2025-12-02 10:16:46.444710','2025-12-02 10:16:49.275088',218,218,NULL,'5b81ca02bbcb470597d21e5b9567c00e','shares',0,0,NULL,'b343753f-dbd8-437e-a54c-67781c91ba72'),('2025-12-02 10:16:21.497070','2025-12-02 10:16:46.444712','2025-12-02 10:16:49.275088',219,219,NULL,'5b81ca02bbcb470597d21e5b9567c00e','gigabytes',0,0,NULL,'b343753f-dbd8-437e-a54c-67781c91ba72'),('2025-12-02 10:16:22.063885','2025-12-02 10:16:26.365946',NULL,0,220,'3981613749ea480688db1adf3b6b82ce','42ab83296c4741bfa1dbb24e1dcf2c90','snapshots',0,0,NULL,NULL),('2025-12-02 10:16:22.066052','2025-12-02 10:16:26.365949',NULL,0,221,'3981613749ea480688db1adf3b6b82ce','42ab83296c4741bfa1dbb24e1dcf2c90','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-02 10:16:22.077061','2025-12-02 10:16:26.365951','2025-12-02 10:16:32.410281',222,222,NULL,'42ab83296c4741bfa1dbb24e1dcf2c90','snapshots',0,0,NULL,'ff8f71f1-fb64-4b62-84e9-b60238891f66'),('2025-12-02 10:16:22.079452','2025-12-02 10:16:26.365952','2025-12-02 10:16:32.410281',223,223,NULL,'42ab83296c4741bfa1dbb24e1dcf2c90','snapshot_gigabytes',0,0,NULL,'ff8f71f1-fb64-4b62-84e9-b60238891f66'),('2025-12-02 10:16:22.949488','2025-12-02 10:16:27.661300',NULL,0,224,'c911a75716f5426cb9cea74e1d267692','8f15fa0d04d94578bf27407ff42606e9','shares',0,0,NULL,NULL),('2025-12-02 10:16:22.951657','2025-12-02 10:16:27.661303',NULL,0,225,'c911a75716f5426cb9cea74e1d267692','8f15fa0d04d94578bf27407ff42606e9','gigabytes',0,0,NULL,NULL),('2025-12-02 10:16:22.960623','2025-12-02 10:16:27.661305','2025-12-02 10:16:30.538265',226,226,NULL,'8f15fa0d04d94578bf27407ff42606e9','shares',0,0,NULL,'6d23fec7-04b0-4800-830e-02698b02d95f'),('2025-12-02 10:16:22.962645','2025-12-02 10:16:27.661306','2025-12-02 10:16:30.538265',227,227,NULL,'8f15fa0d04d94578bf27407ff42606e9','gigabytes',0,0,NULL,'6d23fec7-04b0-4800-830e-02698b02d95f'),('2025-12-02 10:16:38.564649','2025-12-02 10:16:45.722835',NULL,0,228,'1f11b2a06678478d89a0b30338f3215d','d92cdfaa0852404fb2f275710f8302c1','gigabytes',0,0,NULL,NULL),('2025-12-02 10:16:38.566820','2025-12-02 10:16:45.722838',NULL,0,229,'1f11b2a06678478d89a0b30338f3215d','d92cdfaa0852404fb2f275710f8302c1','shares',0,0,NULL,NULL),('2025-12-02 10:16:38.575963','2025-12-02 10:16:45.722839','2025-12-02 10:16:48.607914',230,230,NULL,'d92cdfaa0852404fb2f275710f8302c1','gigabytes',0,0,NULL,'54666b5f-689b-4f90-8ce4-2e72d8cae955'),('2025-12-02 10:16:38.578920','2025-12-02 10:16:45.722840','2025-12-02 10:16:48.607914',231,231,NULL,'d92cdfaa0852404fb2f275710f8302c1','shares',0,0,NULL,'54666b5f-689b-4f90-8ce4-2e72d8cae955'),('2025-12-02 10:16:44.602525','2025-12-02 10:16:44.660135',NULL,0,232,'f28923a090f94475a23176e7fcf5a2e1','50f32cd20e77432aa8155c09efe362d9','share_networks',1,0,NULL,NULL),('2025-12-02 10:16:51.036678','2025-12-02 10:17:21.346818',NULL,0,233,'b774140ceb894be08d683a79b22edb33','79ddfd071a5e4cc08a108f0183273281','shares',0,0,NULL,NULL),('2025-12-02 10:16:51.038586','2025-12-02 10:17:21.346821',NULL,0,234,'b774140ceb894be08d683a79b22edb33','79ddfd071a5e4cc08a108f0183273281','gigabytes',0,0,NULL,NULL),('2025-12-02 10:16:51.049892','2025-12-02 10:17:21.346822','2025-12-02 10:17:24.147612',235,235,NULL,'79ddfd071a5e4cc08a108f0183273281','shares',0,0,NULL,'950a39c5-4e79-4f1a-9c4b-3ff6dfdc5035'),('2025-12-02 10:16:51.052487','2025-12-02 10:17:21.346823','2025-12-02 10:17:24.147612',236,236,NULL,'79ddfd071a5e4cc08a108f0183273281','gigabytes',0,0,NULL,'950a39c5-4e79-4f1a-9c4b-3ff6dfdc5035'),('2025-12-02 10:16:54.351171','2025-12-02 10:17:18.589477',NULL,0,237,'b774140ceb894be08d683a79b22edb33','79ddfd071a5e4cc08a108f0183273281','snapshots',0,0,NULL,NULL),('2025-12-02 10:16:54.354566','2025-12-02 10:17:18.589480',NULL,0,238,'b774140ceb894be08d683a79b22edb33','79ddfd071a5e4cc08a108f0183273281','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-02 10:16:54.373898','2025-12-02 10:17:18.589481','2025-12-02 10:17:24.147612',239,239,NULL,'79ddfd071a5e4cc08a108f0183273281','snapshots',0,0,NULL,'950a39c5-4e79-4f1a-9c4b-3ff6dfdc5035'),('2025-12-02 10:16:54.376560','2025-12-02 10:17:18.589482','2025-12-02 10:17:24.147612',240,240,NULL,'79ddfd071a5e4cc08a108f0183273281','snapshot_gigabytes',0,0,NULL,'950a39c5-4e79-4f1a-9c4b-3ff6dfdc5035'),('2025-12-02 10:16:56.091175','2025-12-02 10:18:33.589934',NULL,0,241,'93d13ca7e2a24175bba901a25766e537','211eae1028e14770a7771256868ba26b','shares',0,0,NULL,NULL),('2025-12-02 10:16:56.093411','2025-12-02 10:18:33.589937',NULL,0,242,'93d13ca7e2a24175bba901a25766e537','211eae1028e14770a7771256868ba26b','gigabytes',0,0,NULL,NULL),('2025-12-02 10:16:56.180703','2025-12-02 10:18:33.589939','2025-12-02 10:18:36.417463',243,243,NULL,'211eae1028e14770a7771256868ba26b','shares',0,0,NULL,'4a626c17-ad21-43c8-9b09-dbad49162031'),('2025-12-02 10:16:56.184776','2025-12-02 10:18:33.589941','2025-12-02 10:18:36.417463',244,244,NULL,'211eae1028e14770a7771256868ba26b','gigabytes',0,0,NULL,'4a626c17-ad21-43c8-9b09-dbad49162031'),('2025-12-02 10:16:59.521895','2025-12-02 10:18:30.432686',NULL,0,245,'93d13ca7e2a24175bba901a25766e537','211eae1028e14770a7771256868ba26b','snapshots',0,0,NULL,NULL),('2025-12-02 10:16:59.524673','2025-12-02 10:18:30.432689',NULL,0,246,'93d13ca7e2a24175bba901a25766e537','211eae1028e14770a7771256868ba26b','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-02 10:16:59.552493','2025-12-02 10:18:30.432690','2025-12-02 10:18:36.417463',247,247,NULL,'211eae1028e14770a7771256868ba26b','snapshots',0,0,NULL,'4a626c17-ad21-43c8-9b09-dbad49162031'),('2025-12-02 10:16:59.555764','2025-12-02 10:18:30.432691','2025-12-02 10:18:36.417463',248,248,NULL,'211eae1028e14770a7771256868ba26b','snapshot_gigabytes',0,0,NULL,'4a626c17-ad21-43c8-9b09-dbad49162031'),('2025-12-02 10:16:59.614080','2025-12-02 10:17:47.079267',NULL,0,249,'f09491acad8f439a900c28da382ca6e2','cdaa059771c7466abb92ea3e1cebce7e','shares',0,0,NULL,NULL),('2025-12-02 10:16:59.617252','2025-12-02 10:17:47.079270',NULL,0,250,'f09491acad8f439a900c28da382ca6e2','cdaa059771c7466abb92ea3e1cebce7e','gigabytes',0,0,NULL,NULL),('2025-12-02 10:16:59.629125','2025-12-02 10:17:47.079271','2025-12-02 10:17:50.201911',251,251,NULL,'cdaa059771c7466abb92ea3e1cebce7e','shares',0,0,NULL,'300eea5b-2ddf-4e31-9720-01bb47b12376'),('2025-12-02 10:16:59.632148','2025-12-02 10:17:47.079273','2025-12-02 10:17:50.201911',252,252,NULL,'cdaa059771c7466abb92ea3e1cebce7e','gigabytes',0,0,NULL,'300eea5b-2ddf-4e31-9720-01bb47b12376'),('2025-12-02 10:17:14.484996','2025-12-02 10:17:26.327168',NULL,0,253,'0c098ae00cb94d67bd45a524f4cab612','a7dc52ea00264b2383416f2c2734805a','shares',0,0,NULL,NULL),('2025-12-02 10:17:14.488383','2025-12-02 10:17:26.327172',NULL,0,254,'0c098ae00cb94d67bd45a524f4cab612','a7dc52ea00264b2383416f2c2734805a','gigabytes',0,0,NULL,NULL),('2025-12-02 10:17:14.500977','2025-12-02 10:17:26.327174','2025-12-02 10:17:29.115951',255,255,NULL,'a7dc52ea00264b2383416f2c2734805a','shares',0,0,NULL,'5896c098-f607-4674-ae2d-9837202249d8'),('2025-12-02 10:17:14.503067','2025-12-02 10:17:26.327176','2025-12-02 10:17:29.115951',256,256,NULL,'a7dc52ea00264b2383416f2c2734805a','gigabytes',0,0,NULL,'5896c098-f607-4674-ae2d-9837202249d8'),('2025-12-02 10:17:17.918554','2025-12-02 10:17:23.047960',NULL,0,257,'0c098ae00cb94d67bd45a524f4cab612','a7dc52ea00264b2383416f2c2734805a','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-02 10:17:17.920369','2025-12-02 10:17:23.047963',NULL,0,258,'0c098ae00cb94d67bd45a524f4cab612','a7dc52ea00264b2383416f2c2734805a','snapshots',0,0,NULL,NULL),('2025-12-02 10:17:17.943936','2025-12-02 10:17:23.047965','2025-12-02 10:17:29.115951',259,259,NULL,'a7dc52ea00264b2383416f2c2734805a','snapshot_gigabytes',0,0,NULL,'5896c098-f607-4674-ae2d-9837202249d8'),('2025-12-02 10:17:17.946385','2025-12-02 10:17:23.047967','2025-12-02 10:17:29.115951',260,260,NULL,'a7dc52ea00264b2383416f2c2734805a','snapshots',0,0,NULL,'5896c098-f607-4674-ae2d-9837202249d8'),('2025-12-02 10:17:57.670301','2025-12-02 10:18:02.228682',NULL,0,261,'f3629981fc0b479098d9c5e563520055','dad46467971d4ec69445c333d5c21b19','shares',0,0,NULL,NULL),('2025-12-02 10:17:57.673294','2025-12-02 10:18:02.228685',NULL,0,262,'f3629981fc0b479098d9c5e563520055','dad46467971d4ec69445c333d5c21b19','gigabytes',0,0,NULL,NULL),('2025-12-02 10:17:57.689836','2025-12-02 10:18:02.228687','2025-12-02 10:18:04.985791',263,263,NULL,'dad46467971d4ec69445c333d5c21b19','shares',0,0,NULL,'08e56280-8e2e-44d2-aeb7-67792f0c7b88'),('2025-12-02 10:17:57.697598','2025-12-02 10:18:02.228688','2025-12-02 10:18:04.985791',264,264,NULL,'dad46467971d4ec69445c333d5c21b19','gigabytes',0,0,NULL,'08e56280-8e2e-44d2-aeb7-67792f0c7b88'),('2025-12-02 10:18:16.590888','2025-12-02 10:18:20.930443',NULL,0,265,'fcc5d4a07431422ba3821f11642e7581','bb71f7641c1d4d6caa78bff2db07fa2a','shares',0,0,NULL,NULL),('2025-12-02 10:18:16.593003','2025-12-02 10:18:20.930445',NULL,0,266,'fcc5d4a07431422ba3821f11642e7581','bb71f7641c1d4d6caa78bff2db07fa2a','gigabytes',0,0,NULL,NULL),('2025-12-02 10:18:16.608242','2025-12-02 10:18:20.930447','2025-12-02 10:18:25.809573',267,267,NULL,'bb71f7641c1d4d6caa78bff2db07fa2a','shares',0,0,NULL,'f4ee9fd0-b89f-4b56-9a1c-4061b5a2fdf3'),('2025-12-02 10:18:16.610683','2025-12-02 10:18:20.930448','2025-12-02 10:18:25.809573',268,268,NULL,'bb71f7641c1d4d6caa78bff2db07fa2a','gigabytes',0,0,NULL,'f4ee9fd0-b89f-4b56-9a1c-4061b5a2fdf3'),('2025-12-02 10:18:35.151092','2025-12-02 10:18:35.656666',NULL,0,269,'6273e093121d443e9c542b0e0ad7a041','98be8484c5ba419b8d3744355d381f71','share_networks',0,0,NULL,NULL);
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
INSERT INTO `quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `project_id`, `resource`, `hard_limit`) VALUES (1,'2025-12-02 10:08:10.248027',NULL,'2025-12-02 10:08:10.709091',1,'12447334a8d247008c5f1d1eb28a0ff5','shares',1),(2,'2025-12-02 10:08:14.264032',NULL,'2025-12-02 10:08:17.709816',2,'12447334a8d247008c5f1d1eb28a0ff5','snapshots',1),(3,'2025-12-02 10:08:19.772296',NULL,'2025-12-02 10:08:19.943087',3,'12447334a8d247008c5f1d1eb28a0ff5','shares',10),(4,'2025-12-02 10:08:20.010776',NULL,'2025-12-02 10:08:20.088938',4,'12447334a8d247008c5f1d1eb28a0ff5','shares',10),(5,'2025-12-02 10:14:17.322194',NULL,'2025-12-02 10:14:30.992543',5,'680813e2a2a84d78b0da5d342341d9de','shares',3),(6,'2025-12-02 10:14:17.326211',NULL,'2025-12-02 10:14:30.992543',6,'680813e2a2a84d78b0da5d342341d9de','gigabytes',10),(7,'2025-12-02 10:14:31.115386',NULL,'2025-12-02 10:14:31.409013',7,'680813e2a2a84d78b0da5d342341d9de','shares',55),(8,'2025-12-02 10:14:31.122355',NULL,'2025-12-02 10:14:31.409013',8,'680813e2a2a84d78b0da5d342341d9de','snapshots',55),(9,'2025-12-02 10:14:31.134082',NULL,'2025-12-02 10:14:31.409013',9,'680813e2a2a84d78b0da5d342341d9de','gigabytes',1005),(10,'2025-12-02 10:14:31.145722',NULL,'2025-12-02 10:14:31.409013',10,'680813e2a2a84d78b0da5d342341d9de','snapshot_gigabytes',1005),(11,'2025-12-02 10:14:31.153525',NULL,'2025-12-02 10:14:31.409013',11,'680813e2a2a84d78b0da5d342341d9de','share_replicas',105),(12,'2025-12-02 10:14:31.168783',NULL,'2025-12-02 10:14:31.409013',12,'680813e2a2a84d78b0da5d342341d9de','replica_gigabytes',1005),(13,'2025-12-02 10:14:31.540973',NULL,'2025-12-02 10:14:31.780512',13,'680813e2a2a84d78b0da5d342341d9de','shares',55),(14,'2025-12-02 10:14:31.545160',NULL,'2025-12-02 10:14:31.780512',14,'680813e2a2a84d78b0da5d342341d9de','snapshots',55),(15,'2025-12-02 10:14:31.550541',NULL,'2025-12-02 10:14:31.780512',15,'680813e2a2a84d78b0da5d342341d9de','gigabytes',1005),(16,'2025-12-02 10:14:31.554090',NULL,'2025-12-02 10:14:31.780512',16,'680813e2a2a84d78b0da5d342341d9de','snapshot_gigabytes',1005),(17,'2025-12-02 10:14:31.558117',NULL,'2025-12-02 10:14:31.780512',17,'680813e2a2a84d78b0da5d342341d9de','share_replicas',105),(18,'2025-12-02 10:14:31.567791',NULL,'2025-12-02 10:14:31.780512',18,'680813e2a2a84d78b0da5d342341d9de','replica_gigabytes',1005),(19,'2025-12-02 10:14:31.886877',NULL,'2025-12-02 10:14:31.955230',19,'680813e2a2a84d78b0da5d342341d9de','shares',52),(20,'2025-12-02 10:14:31.900611',NULL,'2025-12-02 10:14:31.955230',20,'680813e2a2a84d78b0da5d342341d9de','snapshots',52),(21,'2025-12-02 10:14:31.906068',NULL,'2025-12-02 10:14:31.955230',21,'680813e2a2a84d78b0da5d342341d9de','gigabytes',1002),(22,'2025-12-02 10:14:31.913539',NULL,'2025-12-02 10:14:31.955230',22,'680813e2a2a84d78b0da5d342341d9de','snapshot_gigabytes',1002),(23,'2025-12-02 10:14:31.919606',NULL,'2025-12-02 10:14:31.955230',23,'680813e2a2a84d78b0da5d342341d9de','share_networks',12),(24,'2025-12-02 10:14:31.924376',NULL,'2025-12-02 10:14:31.955230',24,'680813e2a2a84d78b0da5d342341d9de','share_replicas',102),(25,'2025-12-02 10:14:31.929134',NULL,'2025-12-02 10:14:31.955230',25,'680813e2a2a84d78b0da5d342341d9de','replica_gigabytes',1002),(26,'2025-12-02 10:14:32.076847',NULL,'2025-12-02 10:14:32.271465',26,'680813e2a2a84d78b0da5d342341d9de','shares',13),(27,'2025-12-02 10:14:32.320993',NULL,'2025-12-02 10:14:32.378937',27,'680813e2a2a84d78b0da5d342341d9de','gigabytes',-1),(28,'2025-12-02 10:14:32.424177',NULL,'2025-12-02 10:14:32.485419',28,'680813e2a2a84d78b0da5d342341d9de','share_replicas',-1),(29,'2025-12-02 10:14:32.529462',NULL,'2025-12-02 10:14:32.568164',29,'680813e2a2a84d78b0da5d342341d9de','replica_gigabytes',-1),(30,'2025-12-02 10:14:32.609045',NULL,'2025-12-02 10:14:32.660237',30,'680813e2a2a84d78b0da5d342341d9de','share_networks',-1),(31,'2025-12-02 10:14:32.709793',NULL,'2025-12-02 10:14:32.750904',31,'680813e2a2a84d78b0da5d342341d9de','shares',-1),(32,'2025-12-02 10:14:32.793115',NULL,'2025-12-02 10:14:32.852596',32,'680813e2a2a84d78b0da5d342341d9de','snapshot_gigabytes',-1),(33,'2025-12-02 10:14:32.901484',NULL,'2025-12-02 10:14:32.942496',33,'680813e2a2a84d78b0da5d342341d9de','snapshots',-1),(34,'2025-12-02 10:14:35.451486',NULL,'2025-12-02 10:14:35.564176',34,'680813e2a2a84d78b0da5d342341d9de','shares',10),(35,'2025-12-02 10:14:35.691875',NULL,'2025-12-02 10:14:35.774590',35,'680813e2a2a84d78b0da5d342341d9de','shares',10),(36,'2025-12-02 10:14:35.852242',NULL,'2025-12-02 10:14:35.880550',36,'680813e2a2a84d78b0da5d342341d9de','gigabytes',1002),(37,'2025-12-02 10:14:35.954842',NULL,'2025-12-02 10:14:35.983784',37,'680813e2a2a84d78b0da5d342341d9de','share_networks',12),(38,'2025-12-02 10:14:36.037817',NULL,'2025-12-02 10:14:36.064071',38,'680813e2a2a84d78b0da5d342341d9de','shares',52),(39,'2025-12-02 10:14:36.209905',NULL,'2025-12-02 10:14:36.250439',39,'680813e2a2a84d78b0da5d342341d9de','snapshot_gigabytes',1002),(40,'2025-12-02 10:14:36.328240',NULL,'2025-12-02 10:14:36.361865',40,'680813e2a2a84d78b0da5d342341d9de','snapshots',52),(41,'2025-12-02 10:14:36.595271',NULL,'2025-12-02 10:14:36.616306',41,'680813e2a2a84d78b0da5d342341d9de','share_replicas',99),(42,'2025-12-02 10:14:37.026438',NULL,'2025-12-02 10:14:37.056110',42,'680813e2a2a84d78b0da5d342341d9de','replica_gigabytes',999),(43,'2025-12-02 10:14:37.819990',NULL,'2025-12-02 10:14:37.970975',43,'680813e2a2a84d78b0da5d342341d9de','shares',10),(44,'2025-12-02 10:14:38.019412',NULL,'2025-12-02 10:14:38.131713',44,'680813e2a2a84d78b0da5d342341d9de','shares',10);
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) NOT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `usage_id` (`usage_id`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=979 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
INSERT INTO `reservations` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `uuid`, `usage_id`, `project_id`, `resource`, `delta`, `expire`, `share_type_id`) VALUES ('2025-12-02 10:07:44.376046',NULL,'2025-12-02 10:07:44.436584',1,1,'7e0d7dcc532b479a95d6170210f7f957','c564a50b-d74a-428b-8fc1-6f97887da950',1,'91d10c5ca25446f6a019e13492b59d1a','shares',1,'2025-12-03 10:07:44',NULL),('2025-12-02 10:07:44.379430',NULL,'2025-12-02 10:07:44.436584',2,2,'7e0d7dcc532b479a95d6170210f7f957','2318f597-cc83-4590-8e62-fcd5094c6e78',2,'91d10c5ca25446f6a019e13492b59d1a','gigabytes',1,'2025-12-03 10:07:44',NULL),('2025-12-02 10:07:44.395477',NULL,'2025-12-02 10:07:44.436584',3,3,NULL,'5cfed027-5c11-416f-abd2-7b2969bd9944',3,'91d10c5ca25446f6a019e13492b59d1a','shares',1,'2025-12-03 10:07:44','c7843cd1-5a42-404c-8aaa-eded3337b556'),('2025-12-02 10:07:44.396776',NULL,'2025-12-02 10:07:44.436584',4,4,NULL,'646087ba-2125-48a2-89ce-cd60650e1c37',4,'91d10c5ca25446f6a019e13492b59d1a','gigabytes',1,'2025-12-03 10:07:44','c7843cd1-5a42-404c-8aaa-eded3337b556'),('2025-12-02 10:07:49.418205',NULL,'2025-12-02 10:07:49.447900',5,5,'7e0d7dcc532b479a95d6170210f7f957','29b12e0d-7e03-41e3-90e4-b86ace2cb3a6',1,'91d10c5ca25446f6a019e13492b59d1a','shares',-1,'2025-12-03 10:07:49',NULL),('2025-12-02 10:07:49.419906',NULL,'2025-12-02 10:07:49.447900',6,6,'7e0d7dcc532b479a95d6170210f7f957','969e0202-c925-44af-866b-2cf8d7141b1c',2,'91d10c5ca25446f6a019e13492b59d1a','gigabytes',-1,'2025-12-03 10:07:49',NULL),('2025-12-02 10:07:49.426850',NULL,'2025-12-02 10:07:49.447900',7,7,NULL,'bffb5702-fd8e-4f93-a7bf-2f3c288e4137',3,'91d10c5ca25446f6a019e13492b59d1a','shares',-1,'2025-12-03 10:07:49','c7843cd1-5a42-404c-8aaa-eded3337b556'),('2025-12-02 10:07:49.427538',NULL,'2025-12-02 10:07:49.447900',8,8,NULL,'98a7712f-349e-4332-9b93-d75c4cda3881',4,'91d10c5ca25446f6a019e13492b59d1a','gigabytes',-1,'2025-12-03 10:07:49','c7843cd1-5a42-404c-8aaa-eded3337b556'),('2025-12-02 10:08:06.857207',NULL,'2025-12-02 10:08:06.929613',9,9,'e2639de4f9f14f00b54ca602fdebfdab','0baef028-b1d5-4707-8c87-81cab34b01a8',5,'12447334a8d247008c5f1d1eb28a0ff5','shares',1,'2025-12-03 10:08:06',NULL),('2025-12-02 10:08:06.861232',NULL,'2025-12-02 10:08:06.929613',10,10,'e2639de4f9f14f00b54ca602fdebfdab','f793a41a-2f41-4e9f-8555-5eefbf460038',6,'12447334a8d247008c5f1d1eb28a0ff5','gigabytes',1,'2025-12-03 10:08:06',NULL),('2025-12-02 10:08:06.884395',NULL,'2025-12-02 10:08:06.929613',11,11,NULL,'9574b5b7-d636-43d5-b103-1fa7bb738f2d',7,'12447334a8d247008c5f1d1eb28a0ff5','shares',1,'2025-12-03 10:08:06','55ab5b1c-221b-4091-823f-7147eaeb86f8'),('2025-12-02 10:08:06.887614',NULL,'2025-12-02 10:08:06.929613',12,12,NULL,'1c1609fa-ca8f-4a83-b9c1-40312c257228',8,'12447334a8d247008c5f1d1eb28a0ff5','gigabytes',1,'2025-12-03 10:08:06','55ab5b1c-221b-4091-823f-7147eaeb86f8'),('2025-12-02 10:08:10.949348',NULL,'2025-12-02 10:08:11.008851',13,13,'e2639de4f9f14f00b54ca602fdebfdab','a64b337c-7a2f-4663-a28f-02c9660d8e1b',10,'12447334a8d247008c5f1d1eb28a0ff5','shares',1,'2025-12-03 10:08:10',NULL),('2025-12-02 10:08:10.954148',NULL,'2025-12-02 10:08:11.008851',14,14,'e2639de4f9f14f00b54ca602fdebfdab','180974be-2243-457e-8b10-0350699387f7',9,'12447334a8d247008c5f1d1eb28a0ff5','gigabytes',1,'2025-12-03 10:08:10',NULL),('2025-12-02 10:08:10.970019',NULL,'2025-12-02 10:08:11.008851',15,15,NULL,'853560e8-8133-4d76-8d2e-f3cc2427196d',11,'12447334a8d247008c5f1d1eb28a0ff5','shares',1,'2025-12-03 10:08:10','4e474489-1f47-45c4-b195-c18be3225ad7'),('2025-12-02 10:08:10.971385',NULL,'2025-12-02 10:08:11.008851',16,16,NULL,'4181adf3-912d-4198-9897-1b0bb00c0fa0',12,'12447334a8d247008c5f1d1eb28a0ff5','gigabytes',1,'2025-12-03 10:08:10','4e474489-1f47-45c4-b195-c18be3225ad7'),('2025-12-02 10:08:14.335663',NULL,'2025-12-02 10:08:14.447829',17,17,'e2639de4f9f14f00b54ca602fdebfdab','65078b03-ed3f-4c14-b274-c358569e552e',13,'12447334a8d247008c5f1d1eb28a0ff5','snapshots',1,'2025-12-03 10:08:14',NULL),('2025-12-02 10:08:14.337827',NULL,'2025-12-02 10:08:14.447829',18,18,'e2639de4f9f14f00b54ca602fdebfdab','e4fa74e7-4848-4f2a-922e-b923636e7b3b',14,'12447334a8d247008c5f1d1eb28a0ff5','snapshot_gigabytes',1,'2025-12-03 10:08:14',NULL),('2025-12-02 10:08:14.350117',NULL,'2025-12-02 10:08:14.447829',19,19,NULL,'aff6a183-fa51-4411-8954-abef41cdbf6e',15,'12447334a8d247008c5f1d1eb28a0ff5','snapshots',1,'2025-12-03 10:08:14','4e474489-1f47-45c4-b195-c18be3225ad7'),('2025-12-02 10:08:14.351703',NULL,'2025-12-02 10:08:14.447829',20,20,NULL,'1b668752-31f1-4aad-ac0c-c89a75aa6724',16,'12447334a8d247008c5f1d1eb28a0ff5','snapshot_gigabytes',1,'2025-12-03 10:08:14','4e474489-1f47-45c4-b195-c18be3225ad7'),('2025-12-02 10:08:21.229929',NULL,'2025-12-02 10:08:21.258179',21,21,'e2639de4f9f14f00b54ca602fdebfdab','1556e5ff-792c-4b15-803e-c70ce75f2a8f',18,'12447334a8d247008c5f1d1eb28a0ff5','snapshots',-1,'2025-12-03 10:08:21',NULL),('2025-12-02 10:08:21.230969',NULL,'2025-12-02 10:08:21.258179',22,22,'e2639de4f9f14f00b54ca602fdebfdab','70af4011-782c-4b5a-bf14-eabbb2fef9c9',17,'12447334a8d247008c5f1d1eb28a0ff5','snapshot_gigabytes',-1,'2025-12-03 10:08:21',NULL),('2025-12-02 10:08:21.249429',NULL,'2025-12-02 10:08:21.258179',23,23,NULL,'6ad1460e-0057-45f6-af7b-4f68c4764e13',20,'12447334a8d247008c5f1d1eb28a0ff5','snapshots',-1,'2025-12-03 10:08:21','4e474489-1f47-45c4-b195-c18be3225ad7'),('2025-12-02 10:08:21.250306',NULL,'2025-12-02 10:08:21.258179',24,24,NULL,'bffd24a7-afed-44dc-9c3b-9ff1ec570d4f',19,'12447334a8d247008c5f1d1eb28a0ff5','snapshot_gigabytes',-1,'2025-12-03 10:08:21','4e474489-1f47-45c4-b195-c18be3225ad7'),('2025-12-02 10:08:24.641135',NULL,'2025-12-02 10:08:24.663182',25,25,'e2639de4f9f14f00b54ca602fdebfdab','c0e11f0b-1e54-46f5-b577-8d53721d901b',21,'12447334a8d247008c5f1d1eb28a0ff5','shares',-1,'2025-12-03 10:08:24',NULL),('2025-12-02 10:08:24.641972',NULL,'2025-12-02 10:08:24.663182',26,26,'e2639de4f9f14f00b54ca602fdebfdab','b1624bff-d75a-4eb6-9cf2-0618656db465',22,'12447334a8d247008c5f1d1eb28a0ff5','gigabytes',-1,'2025-12-03 10:08:24',NULL),('2025-12-02 10:08:24.655307',NULL,'2025-12-02 10:08:24.663182',27,27,NULL,'2b37a1df-c4c7-4be3-8671-33b8965d1e41',23,'12447334a8d247008c5f1d1eb28a0ff5','shares',-1,'2025-12-03 10:08:24','4e474489-1f47-45c4-b195-c18be3225ad7'),('2025-12-02 10:08:24.656134',NULL,'2025-12-02 10:08:24.663182',28,28,NULL,'f8172c70-d2f1-48e4-aa8d-b87759383ed3',24,'12447334a8d247008c5f1d1eb28a0ff5','gigabytes',-1,'2025-12-03 10:08:24','4e474489-1f47-45c4-b195-c18be3225ad7'),('2025-12-02 10:08:26.741399',NULL,'2025-12-02 10:08:26.787797',29,29,'5c18a0166b5c4cda88d91d874afcea96','fcce205c-35ab-4aac-8392-22620eaa370a',25,'d7c3ca3eec6f4e43b7d189dbc6fd6921','shares',1,'2025-12-03 10:08:26',NULL),('2025-12-02 10:08:26.742716',NULL,'2025-12-02 10:08:26.787797',30,30,'5c18a0166b5c4cda88d91d874afcea96','4364dfb5-cbfa-4b15-93c3-10accd6e9767',26,'d7c3ca3eec6f4e43b7d189dbc6fd6921','gigabytes',1,'2025-12-03 10:08:26',NULL),('2025-12-02 10:08:26.758296',NULL,'2025-12-02 10:08:26.787797',31,31,NULL,'0c38486f-cb40-44d6-a6f2-8885a0a04e4a',27,'d7c3ca3eec6f4e43b7d189dbc6fd6921','shares',1,'2025-12-03 10:08:26','d63c996f-1244-4406-9149-4ad6fd449135'),('2025-12-02 10:08:26.759695',NULL,'2025-12-02 10:08:26.787797',32,32,NULL,'a52c346a-bb5e-4541-ac5b-db8aff86b7fe',28,'d7c3ca3eec6f4e43b7d189dbc6fd6921','gigabytes',1,'2025-12-03 10:08:26','d63c996f-1244-4406-9149-4ad6fd449135'),('2025-12-02 10:08:28.383265',NULL,'2025-12-02 10:08:28.407347',33,33,'e2639de4f9f14f00b54ca602fdebfdab','75f24d2c-e297-4cce-bdc2-464781b0ea6d',21,'12447334a8d247008c5f1d1eb28a0ff5','shares',-1,'2025-12-03 10:08:28',NULL),('2025-12-02 10:08:28.384059',NULL,'2025-12-02 10:08:28.407347',34,34,'e2639de4f9f14f00b54ca602fdebfdab','b0047215-7f15-4d81-a228-87f8e79a7107',22,'12447334a8d247008c5f1d1eb28a0ff5','gigabytes',-1,'2025-12-03 10:08:28',NULL),('2025-12-02 10:08:28.398720',NULL,'2025-12-02 10:08:28.407347',35,35,NULL,'4d5ca920-ae77-49a0-b3a7-58f14a3f0aa3',29,'12447334a8d247008c5f1d1eb28a0ff5','shares',-1,'2025-12-03 10:08:28','55ab5b1c-221b-4091-823f-7147eaeb86f8'),('2025-12-02 10:08:28.399467',NULL,'2025-12-02 10:08:28.407347',36,36,NULL,'258fa660-3db9-4657-827b-df39c28174b9',30,'12447334a8d247008c5f1d1eb28a0ff5','gigabytes',-1,'2025-12-03 10:08:28','55ab5b1c-221b-4091-823f-7147eaeb86f8'),('2025-12-02 10:08:30.029176',NULL,'2025-12-02 10:08:30.119954',37,37,'5c18a0166b5c4cda88d91d874afcea96','fabae8e0-5ba2-42e7-90d8-9f1807307a09',31,'d7c3ca3eec6f4e43b7d189dbc6fd6921','snapshots',1,'2025-12-03 10:08:29',NULL),('2025-12-02 10:08:30.030371',NULL,'2025-12-02 10:08:30.119954',38,38,'5c18a0166b5c4cda88d91d874afcea96','398c832e-04ae-4612-9249-6b0211314d11',32,'d7c3ca3eec6f4e43b7d189dbc6fd6921','snapshot_gigabytes',1,'2025-12-03 10:08:29',NULL),('2025-12-02 10:08:30.056639',NULL,'2025-12-02 10:08:30.119954',39,39,NULL,'f3afaf63-5cce-4419-86c8-62313165db3e',33,'d7c3ca3eec6f4e43b7d189dbc6fd6921','snapshots',1,'2025-12-03 10:08:29','d63c996f-1244-4406-9149-4ad6fd449135'),('2025-12-02 10:08:30.059621',NULL,'2025-12-02 10:08:30.119954',40,40,NULL,'76c5ece4-b012-4fc5-976c-f4f4013864d6',34,'d7c3ca3eec6f4e43b7d189dbc6fd6921','snapshot_gigabytes',1,'2025-12-03 10:08:29','d63c996f-1244-4406-9149-4ad6fd449135'),('2025-12-02 10:08:33.431870',NULL,'2025-12-02 10:08:33.612362',41,41,'5c18a0166b5c4cda88d91d874afcea96','101d85b1-a3e4-45b8-beaf-233f1a1795dc',25,'d7c3ca3eec6f4e43b7d189dbc6fd6921','shares',1,'2025-12-03 10:08:33',NULL),('2025-12-02 10:08:33.433048',NULL,'2025-12-02 10:08:33.612362',42,42,'5c18a0166b5c4cda88d91d874afcea96','927edbf4-930b-444b-9874-20b3c50017c1',26,'d7c3ca3eec6f4e43b7d189dbc6fd6921','gigabytes',1,'2025-12-03 10:08:33',NULL),('2025-12-02 10:08:33.565679',NULL,'2025-12-02 10:08:33.612362',43,43,NULL,'561832b8-eb64-4f65-930f-07d9ff849a35',27,'d7c3ca3eec6f4e43b7d189dbc6fd6921','shares',1,'2025-12-03 10:08:33','d63c996f-1244-4406-9149-4ad6fd449135'),('2025-12-02 10:08:33.567826',NULL,'2025-12-02 10:08:33.612362',44,44,NULL,'c98e1dff-8a7d-48c8-a885-f73a80d7fd95',28,'d7c3ca3eec6f4e43b7d189dbc6fd6921','gigabytes',1,'2025-12-03 10:08:33','d63c996f-1244-4406-9149-4ad6fd449135'),('2025-12-02 10:08:36.626749',NULL,'2025-12-02 10:08:36.673461',45,45,'a3c52ee96f7342359efb8efa2c6a9d7a','957f8416-ed0a-4f43-adbd-0fdf6e95660a',36,'8ecf0fcaf7384c7d9e2eb9c5a5e8ac26','shares',1,'2025-12-03 10:08:36',NULL),('2025-12-02 10:08:36.630124',NULL,'2025-12-02 10:08:36.673461',46,46,'a3c52ee96f7342359efb8efa2c6a9d7a','080a97ca-749e-4e4d-a748-8b7e234c77d6',35,'8ecf0fcaf7384c7d9e2eb9c5a5e8ac26','gigabytes',1,'2025-12-03 10:08:36',NULL),('2025-12-02 10:08:36.647427',NULL,'2025-12-02 10:08:36.673461',47,47,NULL,'06687cdc-8fea-4171-b529-2f15f20bf45a',38,'8ecf0fcaf7384c7d9e2eb9c5a5e8ac26','shares',1,'2025-12-03 10:08:36','bd56dc3a-3508-4ec1-a3b6-c632a8233cd9'),('2025-12-02 10:08:36.649026',NULL,'2025-12-02 10:08:36.673461',48,48,NULL,'96484382-014a-45ff-bfc6-de6abd7b58d2',37,'8ecf0fcaf7384c7d9e2eb9c5a5e8ac26','gigabytes',1,'2025-12-03 10:08:36','bd56dc3a-3508-4ec1-a3b6-c632a8233cd9'),('2025-12-02 10:08:40.905642',NULL,'2025-12-02 10:08:40.922403',49,49,'a3c52ee96f7342359efb8efa2c6a9d7a','629fe90a-5ea0-42b3-811b-d589eea6b2b5',36,'8ecf0fcaf7384c7d9e2eb9c5a5e8ac26','shares',-1,'2025-12-03 10:08:40',NULL),('2025-12-02 10:08:40.906587',NULL,'2025-12-02 10:08:40.922403',50,50,'a3c52ee96f7342359efb8efa2c6a9d7a','38c3bfdc-8ccc-48e1-9fb9-e962bc9a9700',35,'8ecf0fcaf7384c7d9e2eb9c5a5e8ac26','gigabytes',-1,'2025-12-03 10:08:40',NULL),('2025-12-02 10:08:40.911899',NULL,'2025-12-02 10:08:40.922403',51,51,NULL,'558a669a-faea-4e14-8bfd-ad7fa6a6de34',38,'8ecf0fcaf7384c7d9e2eb9c5a5e8ac26','shares',-1,'2025-12-03 10:08:40','bd56dc3a-3508-4ec1-a3b6-c632a8233cd9'),('2025-12-02 10:08:40.912751',NULL,'2025-12-02 10:08:40.922403',52,52,NULL,'0106096a-7609-47a6-b27a-ee6294a1a06b',37,'8ecf0fcaf7384c7d9e2eb9c5a5e8ac26','gigabytes',-1,'2025-12-03 10:08:40','bd56dc3a-3508-4ec1-a3b6-c632a8233cd9'),('2025-12-02 10:08:53.648957',NULL,'2025-12-02 10:08:53.742976',53,53,'362fbb6a3a3644fcbec2ebd0644f5791','e0322214-d0c5-4233-9b17-1adcc264af1c',39,'4021ccbfb34b44ba81a2e1baeba352f8','share_networks',1,'2025-12-03 10:08:53',NULL),('2025-12-02 10:08:54.018319',NULL,'2025-12-02 10:08:54.081601',54,54,'a7bb6d80634243a38774fa458a699233','bceec051-c654-4b7c-9256-b8970fe7f698',40,'b56f565cca894a56b9aea60a840607f7','share_networks',1,'2025-12-03 10:08:53',NULL),('2025-12-02 10:08:55.014834',NULL,'2025-12-02 10:08:55.026141',55,55,'362fbb6a3a3644fcbec2ebd0644f5791','ea451ec4-3feb-4e08-aedc-a9fa2a1df5f9',39,'4021ccbfb34b44ba81a2e1baeba352f8','share_networks',-1,'2025-12-03 10:08:54',NULL),('2025-12-02 10:08:57.734927',NULL,'2025-12-02 10:08:57.759295',56,56,'5c18a0166b5c4cda88d91d874afcea96','4b2c3464-a5a3-4a05-a926-1fc4112c607b',25,'d7c3ca3eec6f4e43b7d189dbc6fd6921','shares',-1,'2025-12-03 10:08:57',NULL),('2025-12-02 10:08:57.736178',NULL,'2025-12-02 10:08:57.759295',57,57,'5c18a0166b5c4cda88d91d874afcea96','851e6f72-c0b9-44b9-b905-516644a6e9e8',26,'d7c3ca3eec6f4e43b7d189dbc6fd6921','gigabytes',-1,'2025-12-03 10:08:57',NULL),('2025-12-02 10:08:57.748450',NULL,'2025-12-02 10:08:57.759295',58,58,NULL,'f75dad69-59e9-4f88-92f4-17eee3b36135',27,'d7c3ca3eec6f4e43b7d189dbc6fd6921','shares',-1,'2025-12-03 10:08:57','d63c996f-1244-4406-9149-4ad6fd449135'),('2025-12-02 10:08:57.749373',NULL,'2025-12-02 10:08:57.759295',59,59,NULL,'128bad98-9d69-4834-ad6a-5eb9848e193b',28,'d7c3ca3eec6f4e43b7d189dbc6fd6921','gigabytes',-1,'2025-12-03 10:08:57','d63c996f-1244-4406-9149-4ad6fd449135'),('2025-12-02 10:09:01.048167',NULL,'2025-12-02 10:09:01.068538',60,60,'5c18a0166b5c4cda88d91d874afcea96','b491b080-b1c3-4318-9dcd-ef918fd17d6e',31,'d7c3ca3eec6f4e43b7d189dbc6fd6921','snapshots',-1,'2025-12-03 10:09:01',NULL),('2025-12-02 10:09:01.048911',NULL,'2025-12-02 10:09:01.068538',61,61,'5c18a0166b5c4cda88d91d874afcea96','6af03f67-4af1-4e05-ac5f-b8e3cad82166',32,'d7c3ca3eec6f4e43b7d189dbc6fd6921','snapshot_gigabytes',-1,'2025-12-03 10:09:01',NULL),('2025-12-02 10:09:01.053517',NULL,'2025-12-02 10:09:01.068538',62,62,NULL,'fea05b16-c518-4089-af3b-8e5ccb9338e3',33,'d7c3ca3eec6f4e43b7d189dbc6fd6921','snapshots',-1,'2025-12-03 10:09:01','d63c996f-1244-4406-9149-4ad6fd449135'),('2025-12-02 10:09:01.054065',NULL,'2025-12-02 10:09:01.068538',63,63,NULL,'20f30dee-491f-4a72-9e5c-6601783655ca',34,'d7c3ca3eec6f4e43b7d189dbc6fd6921','snapshot_gigabytes',-1,'2025-12-03 10:09:01','d63c996f-1244-4406-9149-4ad6fd449135'),('2025-12-02 10:09:04.359275',NULL,'2025-12-02 10:09:04.387995',64,64,'5c18a0166b5c4cda88d91d874afcea96','76d2d095-21c6-4899-8b92-e789971d6d54',25,'d7c3ca3eec6f4e43b7d189dbc6fd6921','shares',-1,'2025-12-03 10:09:04',NULL),('2025-12-02 10:09:04.362906',NULL,'2025-12-02 10:09:04.387995',65,65,'5c18a0166b5c4cda88d91d874afcea96','ac9b4910-699c-4ef6-850f-4f626f549b5c',26,'d7c3ca3eec6f4e43b7d189dbc6fd6921','gigabytes',-1,'2025-12-03 10:09:04',NULL),('2025-12-02 10:09:04.373915',NULL,'2025-12-02 10:09:04.387995',66,66,NULL,'82436b8d-83ca-482e-ac12-343088659153',27,'d7c3ca3eec6f4e43b7d189dbc6fd6921','shares',-1,'2025-12-03 10:09:04','d63c996f-1244-4406-9149-4ad6fd449135'),('2025-12-02 10:09:04.375899',NULL,'2025-12-02 10:09:04.387995',67,67,NULL,'4e9ca571-0a4f-4195-9295-19d6e9549a95',28,'d7c3ca3eec6f4e43b7d189dbc6fd6921','gigabytes',-1,'2025-12-03 10:09:04','d63c996f-1244-4406-9149-4ad6fd449135'),('2025-12-02 10:09:25.907267',NULL,'2025-12-02 10:09:25.938169',68,68,'26d732e2823c41e7bcdba03bb8a5b208','0615c59c-94cb-4293-8c64-578766369ba8',41,'a241a07e4161486091e8de3f95a1d6c6','shares',1,'2025-12-03 10:09:25',NULL),('2025-12-02 10:09:25.908438',NULL,'2025-12-02 10:09:25.938169',69,69,'26d732e2823c41e7bcdba03bb8a5b208','eadef713-5f71-4fdb-af0e-a1d65c5a80f4',42,'a241a07e4161486091e8de3f95a1d6c6','gigabytes',1,'2025-12-03 10:09:25',NULL),('2025-12-02 10:09:25.918476',NULL,'2025-12-02 10:09:25.938169',70,70,NULL,'95eb26e3-0786-4a15-8d84-5ad817f7a62a',43,'a241a07e4161486091e8de3f95a1d6c6','shares',1,'2025-12-03 10:09:25','d83cee99-d595-4caa-b747-37511b270d66'),('2025-12-02 10:09:25.919598',NULL,'2025-12-02 10:09:25.938169',71,71,NULL,'d4d5c677-3342-457d-bddf-3a087de8d2f1',44,'a241a07e4161486091e8de3f95a1d6c6','gigabytes',1,'2025-12-03 10:09:25','d83cee99-d595-4caa-b747-37511b270d66'),('2025-12-02 10:09:52.555323',NULL,'2025-12-02 10:09:52.597590',72,72,'51a2a486b9484c3d96bff111b1f22b7e','023f9a23-ccca-4849-a3a6-cc6a73e32e08',45,'77d48f7a127b4bacb09f9e82a4c1f799','shares',1,'2025-12-03 10:09:52',NULL),('2025-12-02 10:09:52.556899',NULL,'2025-12-02 10:09:52.597590',73,73,'51a2a486b9484c3d96bff111b1f22b7e','0fec8fef-36c5-452a-9cb4-b596beef4215',46,'77d48f7a127b4bacb09f9e82a4c1f799','gigabytes',1,'2025-12-03 10:09:52',NULL),('2025-12-02 10:09:52.569735',NULL,'2025-12-02 10:09:52.597590',74,74,NULL,'a945c312-ea38-462d-be80-14a4aa9c5169',47,'77d48f7a127b4bacb09f9e82a4c1f799','shares',1,'2025-12-03 10:09:52','24024a73-a2c4-4572-9cd6-91a0a843f5a3'),('2025-12-02 10:09:52.570942',NULL,'2025-12-02 10:09:52.597590',75,75,NULL,'f3d53079-6348-448c-b467-4246c29e0628',48,'77d48f7a127b4bacb09f9e82a4c1f799','gigabytes',1,'2025-12-03 10:09:52','24024a73-a2c4-4572-9cd6-91a0a843f5a3'),('2025-12-02 10:09:55.989259',NULL,'2025-12-02 10:09:56.150653',76,76,'b612e57aaeba4fb8915e8aa972bf8099','948c9eb3-4dfa-49aa-902d-2f4db14cf78d',49,'b537228b863c4207890127e098ae0f04','shares',1,'2025-12-03 10:09:55',NULL),('2025-12-02 10:09:55.990448',NULL,'2025-12-02 10:09:56.150653',77,77,'b612e57aaeba4fb8915e8aa972bf8099','fb30db97-9995-4355-9898-38f8160bf569',50,'b537228b863c4207890127e098ae0f04','gigabytes',1,'2025-12-03 10:09:55',NULL),('2025-12-02 10:09:56.012639',NULL,'2025-12-02 10:09:56.199158',78,78,'b612e57aaeba4fb8915e8aa972bf8099','599c6c5c-63ec-4ccf-8a5a-7e732e3931e2',51,'77d48f7a127b4bacb09f9e82a4c1f799','shares',-1,'2025-12-03 10:09:55',NULL),('2025-12-02 10:09:56.013188',NULL,'2025-12-02 10:09:56.199158',79,79,'b612e57aaeba4fb8915e8aa972bf8099','d23c0cf4-6f10-4faa-a526-1e449705c5e8',52,'77d48f7a127b4bacb09f9e82a4c1f799','gigabytes',-1,'2025-12-03 10:09:55',NULL),('2025-12-02 10:09:56.659025',NULL,'2025-12-02 10:09:56.682623',80,80,'b612e57aaeba4fb8915e8aa972bf8099','1357318d-1eb6-4122-9336-416b56e061c1',49,'b537228b863c4207890127e098ae0f04','shares',-1,'2025-12-03 10:09:56',NULL),('2025-12-02 10:09:56.660099',NULL,'2025-12-02 10:09:56.682623',81,81,'b612e57aaeba4fb8915e8aa972bf8099','9016dd8e-72cc-4982-bff7-eb7a0d55e892',50,'b537228b863c4207890127e098ae0f04','gigabytes',-1,'2025-12-03 10:09:56',NULL),('2025-12-02 10:09:56.674888',NULL,'2025-12-02 10:09:56.682623',82,82,NULL,'98317c5e-39d2-468f-ace6-0a56a0ee341b',53,'b537228b863c4207890127e098ae0f04','shares',-1,'2025-12-03 10:09:56','24024a73-a2c4-4572-9cd6-91a0a843f5a3'),('2025-12-02 10:09:56.675623',NULL,'2025-12-02 10:09:56.682623',83,83,NULL,'5123cd3b-4b45-4321-a449-442025df5032',54,'b537228b863c4207890127e098ae0f04','gigabytes',-1,'2025-12-03 10:09:56','24024a73-a2c4-4572-9cd6-91a0a843f5a3'),('2025-12-02 10:09:59.536778',NULL,'2025-12-02 10:09:59.576291',84,84,'51a2a486b9484c3d96bff111b1f22b7e','9692cb6f-5556-4226-9e11-03970d527130',45,'77d48f7a127b4bacb09f9e82a4c1f799','shares',1,'2025-12-03 10:09:59',NULL),('2025-12-02 10:09:59.538295',NULL,'2025-12-02 10:09:59.576291',85,85,'51a2a486b9484c3d96bff111b1f22b7e','47b5af03-eb53-424e-9093-633bafc133e1',46,'77d48f7a127b4bacb09f9e82a4c1f799','gigabytes',1,'2025-12-03 10:09:59',NULL),('2025-12-02 10:09:59.547016',NULL,'2025-12-02 10:09:59.576291',86,86,NULL,'4a0feb21-b7ba-4e79-9026-12741665cbf2',47,'77d48f7a127b4bacb09f9e82a4c1f799','shares',1,'2025-12-03 10:09:59','24024a73-a2c4-4572-9cd6-91a0a843f5a3'),('2025-12-02 10:09:59.548656',NULL,'2025-12-02 10:09:59.576291',87,87,NULL,'61be0be7-7cc6-4d32-bd6c-3d1f4c6cea47',48,'77d48f7a127b4bacb09f9e82a4c1f799','gigabytes',1,'2025-12-03 10:09:59','24024a73-a2c4-4572-9cd6-91a0a843f5a3'),('2025-12-02 10:10:03.344459',NULL,'2025-12-02 10:10:03.367691',88,88,'51a2a486b9484c3d96bff111b1f22b7e','2fcc687b-8a12-4c53-941d-63efeca7649c',45,'77d48f7a127b4bacb09f9e82a4c1f799','shares',-1,'2025-12-03 10:10:03',NULL),('2025-12-02 10:10:03.345200',NULL,'2025-12-02 10:10:03.367691',89,89,'51a2a486b9484c3d96bff111b1f22b7e','d8b9aa8c-3b17-4d29-84ee-e2359dfa37f9',46,'77d48f7a127b4bacb09f9e82a4c1f799','gigabytes',-1,'2025-12-03 10:10:03',NULL),('2025-12-02 10:10:03.355341',NULL,'2025-12-02 10:10:03.367691',90,90,NULL,'2db739b7-5023-47ed-a8a1-da9a5356475b',47,'77d48f7a127b4bacb09f9e82a4c1f799','shares',-1,'2025-12-03 10:10:03','24024a73-a2c4-4572-9cd6-91a0a843f5a3'),('2025-12-02 10:10:03.356076',NULL,'2025-12-02 10:10:03.367691',91,91,NULL,'44856c03-3a21-4f88-ba14-2dfbe2fd4866',48,'77d48f7a127b4bacb09f9e82a4c1f799','gigabytes',-1,'2025-12-03 10:10:03','24024a73-a2c4-4572-9cd6-91a0a843f5a3'),('2025-12-02 10:10:18.724574',NULL,'2025-12-02 10:10:18.762207',92,92,'d177d8dee4c74ba69f8b1b2e77f73018','6d19f957-651f-42b6-9547-b38e59a4db20',55,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','shares',1,'2025-12-03 10:10:18',NULL),('2025-12-02 10:10:18.727263',NULL,'2025-12-02 10:10:18.762207',93,93,'d177d8dee4c74ba69f8b1b2e77f73018','2db74b30-6f4e-4110-9b26-a7554f9186e5',56,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','gigabytes',1,'2025-12-03 10:10:18',NULL),('2025-12-02 10:10:18.739522',NULL,'2025-12-02 10:10:18.762207',94,94,NULL,'5bc74cf6-ff68-4748-a890-e303e7bb3a52',57,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','shares',1,'2025-12-03 10:10:18','e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:10:18.741440',NULL,'2025-12-02 10:10:18.762207',95,95,NULL,'104feaf1-6937-479a-8739-1d3c94ad8033',58,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','gigabytes',1,'2025-12-03 10:10:18','e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:10:21.971673',NULL,'2025-12-02 10:10:22.141439',96,96,'d177d8dee4c74ba69f8b1b2e77f73018','41b6258e-483c-4c7c-a570-ce685c958156',60,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshots',1,'2025-12-03 10:10:21',NULL),('2025-12-02 10:10:21.973572',NULL,'2025-12-02 10:10:22.141439',97,97,'d177d8dee4c74ba69f8b1b2e77f73018','db056201-7184-4e85-8cf1-6f26f8e3233f',59,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshot_gigabytes',1,'2025-12-03 10:10:21',NULL),('2025-12-02 10:10:21.986620',NULL,'2025-12-02 10:10:22.141439',98,98,NULL,'a37d4021-ff16-4a47-9805-90e7e3db5436',62,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshots',1,'2025-12-03 10:10:21','e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:10:21.987800',NULL,'2025-12-02 10:10:22.141439',99,99,NULL,'eb88871c-2253-48e3-b0c8-0daa5fb0c278',61,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshot_gigabytes',1,'2025-12-03 10:10:21','e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:10:25.506159',NULL,'2025-12-02 10:10:25.640773',100,100,'d177d8dee4c74ba69f8b1b2e77f73018','966c81e1-fcaa-4ffd-9ab0-af979f727082',60,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshots',1,'2025-12-03 10:10:25',NULL),('2025-12-02 10:10:25.507430',NULL,'2025-12-02 10:10:25.640773',101,101,'d177d8dee4c74ba69f8b1b2e77f73018','cde2955e-8f44-4fb6-ad8b-20aa632d5d58',59,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshot_gigabytes',1,'2025-12-03 10:10:25',NULL),('2025-12-02 10:10:25.526576',NULL,'2025-12-02 10:10:25.640773',102,102,NULL,'339e2890-9a9d-4e92-9764-6668a1277b44',62,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshots',1,'2025-12-03 10:10:25','e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:10:25.528947',NULL,'2025-12-02 10:10:25.640773',103,103,NULL,'e1aec80e-fd02-46af-bbe4-c99fe25fc43c',61,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshot_gigabytes',1,'2025-12-03 10:10:25','e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:10:30.350708',NULL,'2025-12-02 10:10:30.388699',104,104,'d177d8dee4c74ba69f8b1b2e77f73018','8726dd71-4f0c-413f-8c8c-f6a65fa2a5b3',60,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshots',-1,'2025-12-03 10:10:30',NULL),('2025-12-02 10:10:30.354081',NULL,'2025-12-02 10:10:30.388699',105,105,'d177d8dee4c74ba69f8b1b2e77f73018','8e1ca59e-e16f-4743-b76b-1636d64e6fae',59,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshot_gigabytes',-1,'2025-12-03 10:10:30',NULL),('2025-12-02 10:10:30.364793',NULL,'2025-12-02 10:10:30.388699',106,106,NULL,'ed421465-95b2-4900-be87-8d89d881c430',62,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshots',-1,'2025-12-03 10:10:30','e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:10:30.365838',NULL,'2025-12-02 10:10:30.388699',107,107,NULL,'c27daf1e-3388-43ef-815b-08503e473762',61,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshot_gigabytes',-1,'2025-12-03 10:10:30','e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:10:33.092289',NULL,'2025-12-02 10:10:33.215350',108,108,'d177d8dee4c74ba69f8b1b2e77f73018','77c00589-502b-41bf-a0e6-cc88847bc8c4',60,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshots',1,'2025-12-03 10:10:33',NULL),('2025-12-02 10:10:33.093520',NULL,'2025-12-02 10:10:33.215350',109,109,'d177d8dee4c74ba69f8b1b2e77f73018','5b5ca9e2-1bdc-4b56-86d6-c1f0d7b1302a',59,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshot_gigabytes',1,'2025-12-03 10:10:33',NULL),('2025-12-02 10:10:33.099525',NULL,'2025-12-02 10:10:33.215350',110,110,NULL,'2cc8b019-9351-43e6-8caf-b6a6c92b7ec2',62,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshots',1,'2025-12-03 10:10:33','e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:10:33.101008',NULL,'2025-12-02 10:10:33.215350',111,111,NULL,'9c3e43fd-a605-477b-8663-15b7d46088a9',61,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshot_gigabytes',1,'2025-12-03 10:10:33','e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:10:37.906596',NULL,'2025-12-02 10:10:38.080084',112,112,'d177d8dee4c74ba69f8b1b2e77f73018','f5b25010-f9ff-4f8f-b692-90e8c561eabe',60,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshots',-1,'2025-12-03 10:10:37',NULL),('2025-12-02 10:10:37.907408',NULL,'2025-12-02 10:10:38.080084',113,113,'d177d8dee4c74ba69f8b1b2e77f73018','6047b2b1-cf2e-4779-adc0-4a20bd277f8f',59,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshot_gigabytes',-1,'2025-12-03 10:10:37',NULL),('2025-12-02 10:10:38.044969',NULL,'2025-12-02 10:10:38.080084',114,114,NULL,'5ada324f-d7fa-47fc-90ee-43d2bae7f597',62,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshots',-1,'2025-12-03 10:10:37','e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:10:38.045661',NULL,'2025-12-02 10:10:38.080084',115,115,NULL,'5a3b7d1e-6059-4fa2-9d61-4f262607611d',61,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshot_gigabytes',-1,'2025-12-03 10:10:37','e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:10:40.583887',NULL,'2025-12-02 10:10:40.879615',116,116,'d177d8dee4c74ba69f8b1b2e77f73018','b5bafd70-4bbe-4b08-8eb7-a28ac1fff1de',60,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshots',1,'2025-12-03 10:10:40',NULL),('2025-12-02 10:10:40.585245',NULL,'2025-12-02 10:10:40.879615',117,117,'d177d8dee4c74ba69f8b1b2e77f73018','7b56815f-1caf-4e2f-9ae8-0f6c0b898bb1',59,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshot_gigabytes',1,'2025-12-03 10:10:40',NULL),('2025-12-02 10:10:40.750471',NULL,'2025-12-02 10:10:40.879615',118,118,NULL,'6948229e-7343-456c-b28c-db5fdc7249d7',62,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshots',1,'2025-12-03 10:10:40','e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:10:40.751933',NULL,'2025-12-02 10:10:40.879615',119,119,NULL,'9ef26e20-e615-4326-8d59-1802613b20fd',61,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshot_gigabytes',1,'2025-12-03 10:10:40','e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:10:46.709980',NULL,'2025-12-02 10:10:46.967352',120,120,'d177d8dee4c74ba69f8b1b2e77f73018','2e30a076-164a-44a0-a0a5-d6a4ff2116b8',60,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshots',-1,'2025-12-03 10:10:46',NULL),('2025-12-02 10:10:46.710617',NULL,'2025-12-02 10:10:46.967352',121,121,'d177d8dee4c74ba69f8b1b2e77f73018','75e8d6da-914b-4920-b94c-f4cf9ea11210',59,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshot_gigabytes',-1,'2025-12-03 10:10:46',NULL),('2025-12-02 10:10:46.838961',NULL,'2025-12-02 10:10:46.967352',122,122,NULL,'893fc225-c876-4928-86c4-4cb7b8567037',62,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshots',-1,'2025-12-03 10:10:46','e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:10:46.841828',NULL,'2025-12-02 10:10:46.967352',123,123,NULL,'22cdbad0-6219-4d5f-8420-3b869304a015',61,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshot_gigabytes',-1,'2025-12-03 10:10:46','e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:10:49.046327',NULL,'2025-12-02 10:10:49.143194',124,124,'d177d8dee4c74ba69f8b1b2e77f73018','f237f589-5a10-4dd4-a949-d1a11259c51f',60,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshots',1,'2025-12-03 10:10:49',NULL),('2025-12-02 10:10:49.047519',NULL,'2025-12-02 10:10:49.143194',125,125,'d177d8dee4c74ba69f8b1b2e77f73018','2379f5ce-dbb1-4a53-bb49-56060da3d4fc',59,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshot_gigabytes',1,'2025-12-03 10:10:49',NULL),('2025-12-02 10:10:49.061106',NULL,'2025-12-02 10:10:49.143194',126,126,NULL,'3663f736-4317-482b-bf01-2ecdf866637e',62,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshots',1,'2025-12-03 10:10:49','e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:10:49.062945',NULL,'2025-12-02 10:10:49.143194',127,127,NULL,'28c109fc-a866-401e-89d7-a64c3e3fe85a',61,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshot_gigabytes',1,'2025-12-03 10:10:49','e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:10:54.193898',NULL,'2025-12-02 10:10:54.224069',128,128,'d177d8dee4c74ba69f8b1b2e77f73018','3db951e2-1036-434f-9324-4234f9efaea4',60,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshots',-1,'2025-12-03 10:10:54',NULL),('2025-12-02 10:10:54.194817',NULL,'2025-12-02 10:10:54.224069',129,129,'d177d8dee4c74ba69f8b1b2e77f73018','efa71295-b0c6-42a2-abdf-2140b882d02d',59,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshot_gigabytes',-1,'2025-12-03 10:10:54',NULL),('2025-12-02 10:10:54.208983',NULL,'2025-12-02 10:10:54.224069',130,130,NULL,'6f7509f0-61e3-4a82-aa52-1af58af09d9b',62,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshots',-1,'2025-12-03 10:10:54','e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:10:54.209715',NULL,'2025-12-02 10:10:54.224069',131,131,NULL,'662203d3-0488-4d7b-ad3c-ed4a3a65cce2',61,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshot_gigabytes',-1,'2025-12-03 10:10:54','e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:10:57.913664',NULL,'2025-12-02 10:10:58.030545',132,132,'d177d8dee4c74ba69f8b1b2e77f73018','9aedd65f-ab37-4696-8100-309a5a7643ae',60,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshots',1,'2025-12-03 10:10:57',NULL),('2025-12-02 10:10:57.915140',NULL,'2025-12-02 10:10:58.030545',133,133,'d177d8dee4c74ba69f8b1b2e77f73018','a05bba27-fa3d-4511-ba16-3e5e081ced23',59,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshot_gigabytes',1,'2025-12-03 10:10:57',NULL),('2025-12-02 10:10:57.943925',NULL,'2025-12-02 10:10:58.030545',134,134,NULL,'eba2d459-4344-4961-9105-e0e7d7c54032',62,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshots',1,'2025-12-03 10:10:57','e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:10:57.945915',NULL,'2025-12-02 10:10:58.030545',135,135,NULL,'3c23c533-2696-4112-ac62-f8c65e4ca2cb',61,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshot_gigabytes',1,'2025-12-03 10:10:57','e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:11:02.946817',NULL,'2025-12-02 10:11:02.968160',136,136,'d177d8dee4c74ba69f8b1b2e77f73018','557aa770-9e41-4cb3-b7c4-de2b2b9ab1ac',60,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshots',-1,'2025-12-03 10:11:02',NULL),('2025-12-02 10:11:02.947827',NULL,'2025-12-02 10:11:02.968160',137,137,'d177d8dee4c74ba69f8b1b2e77f73018','25778345-b550-4aec-bb20-d8ec45ebbf9e',59,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshot_gigabytes',-1,'2025-12-03 10:11:02',NULL),('2025-12-02 10:11:02.956980',NULL,'2025-12-02 10:11:02.968160',138,138,NULL,'5db1d4c7-e242-4c34-bdda-f4a1e9329352',62,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshots',-1,'2025-12-03 10:11:02','e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:11:02.958315',NULL,'2025-12-02 10:11:02.968160',139,139,NULL,'6e4c8573-9363-4d3a-a011-91facf66369b',61,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshot_gigabytes',-1,'2025-12-03 10:11:02','e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:11:09.473322',NULL,'2025-12-02 10:11:09.575100',140,140,'d177d8dee4c74ba69f8b1b2e77f73018','fd942532-2040-4543-93b6-7bfa845ad048',60,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshots',-1,'2025-12-03 10:11:09',NULL),('2025-12-02 10:11:09.474142',NULL,'2025-12-02 10:11:09.575100',141,141,'d177d8dee4c74ba69f8b1b2e77f73018','e0231a73-c4d0-4bdc-a4fe-4d2da41f8cdd',59,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshot_gigabytes',-1,'2025-12-03 10:11:09',NULL),('2025-12-02 10:11:09.557223',NULL,'2025-12-02 10:11:09.575100',142,142,NULL,'2a843fd0-37d1-4077-a3d1-6839c29f64b9',62,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshots',-1,'2025-12-03 10:11:09','e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:11:09.559004',NULL,'2025-12-02 10:11:09.575100',143,143,NULL,'232f61cc-126e-458f-9697-62e0b3db6c5c',61,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','snapshot_gigabytes',-1,'2025-12-03 10:11:09','e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:11:13.602387',NULL,'2025-12-02 10:11:13.983748',144,144,'d177d8dee4c74ba69f8b1b2e77f73018','90d7f0a0-32dd-4c0b-83b6-21deabe74b75',55,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','shares',-1,'2025-12-03 10:11:13',NULL),('2025-12-02 10:11:13.603216',NULL,'2025-12-02 10:11:13.983748',145,145,'d177d8dee4c74ba69f8b1b2e77f73018','e1e91e47-60ec-4483-a4ce-97330e4fba4e',56,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','gigabytes',-1,'2025-12-03 10:11:13',NULL),('2025-12-02 10:11:13.849558',NULL,'2025-12-02 10:11:13.983748',146,146,NULL,'f9a896d8-ab95-4ffc-8f34-3b6be36314a1',57,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','shares',-1,'2025-12-03 10:11:13','e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:11:13.855214',NULL,'2025-12-02 10:11:13.983748',147,147,NULL,'0b81f867-f9d7-42db-b488-c2635660c4c0',58,'6a6bc1c7bc5149dfa3594ad9c3b2f7d1','gigabytes',-1,'2025-12-03 10:11:13','e9cbe7a0-505c-44a8-beb0-a97f8329c712'),('2025-12-02 10:12:15.632167',NULL,'2025-12-02 10:12:15.666519',148,148,'eec1dbb4ab40488a83c5c6e8ef9e7c00','34f02480-d6f6-498b-b372-739bbb588d1b',63,'e2aae710ad6e4ecbafd15881a70326ff','shares',1,'2025-12-03 10:12:15',NULL),('2025-12-02 10:12:15.634596',NULL,'2025-12-02 10:12:15.666519',149,149,'eec1dbb4ab40488a83c5c6e8ef9e7c00','c3a8d398-e2f8-40bf-be51-397d720822b6',64,'e2aae710ad6e4ecbafd15881a70326ff','gigabytes',1,'2025-12-03 10:12:15',NULL),('2025-12-02 10:12:15.646214',NULL,'2025-12-02 10:12:15.666519',150,150,NULL,'4f71b357-2466-4c08-98df-1fa8ab89e529',65,'e2aae710ad6e4ecbafd15881a70326ff','shares',1,'2025-12-03 10:12:15','bca19079-5f34-42ac-949b-ea604b44b1ec'),('2025-12-02 10:12:15.647381',NULL,'2025-12-02 10:12:15.666519',151,151,NULL,'10078eec-dfee-4a6e-adbc-115434067bed',66,'e2aae710ad6e4ecbafd15881a70326ff','gigabytes',1,'2025-12-03 10:12:15','bca19079-5f34-42ac-949b-ea604b44b1ec'),('2025-12-02 10:12:18.918697',NULL,'2025-12-02 10:12:19.016255',152,152,'eec1dbb4ab40488a83c5c6e8ef9e7c00','0da7253c-0854-44ab-a602-9ff150153afc',67,'e2aae710ad6e4ecbafd15881a70326ff','snapshots',1,'2025-12-03 10:12:18',NULL),('2025-12-02 10:12:18.919938',NULL,'2025-12-02 10:12:19.016255',153,153,'eec1dbb4ab40488a83c5c6e8ef9e7c00','e6ae0c9d-67fc-4f9e-a232-638d5a827aed',68,'e2aae710ad6e4ecbafd15881a70326ff','snapshot_gigabytes',1,'2025-12-03 10:12:18',NULL),('2025-12-02 10:12:18.935187',NULL,'2025-12-02 10:12:19.016255',154,154,NULL,'f779ee74-e61a-439e-9018-e2a242b48390',69,'e2aae710ad6e4ecbafd15881a70326ff','snapshots',1,'2025-12-03 10:12:18','bca19079-5f34-42ac-949b-ea604b44b1ec'),('2025-12-02 10:12:18.936915',NULL,'2025-12-02 10:12:19.016255',155,155,NULL,'2fd60cf5-7d0c-4c06-bb74-020e36d4cfb7',70,'e2aae710ad6e4ecbafd15881a70326ff','snapshot_gigabytes',1,'2025-12-03 10:12:18','bca19079-5f34-42ac-949b-ea604b44b1ec'),('2025-12-02 10:12:23.136202',NULL,'2025-12-02 10:12:23.152789',156,156,'eec1dbb4ab40488a83c5c6e8ef9e7c00','73cece5c-2281-4860-91eb-c6c83a9d6b31',67,'e2aae710ad6e4ecbafd15881a70326ff','snapshots',-1,'2025-12-03 10:12:23',NULL),('2025-12-02 10:12:23.136948',NULL,'2025-12-02 10:12:23.152789',157,157,'eec1dbb4ab40488a83c5c6e8ef9e7c00','f2ce5755-946c-4a4f-a966-ae55c4c5dd85',68,'e2aae710ad6e4ecbafd15881a70326ff','snapshot_gigabytes',-1,'2025-12-03 10:12:23',NULL),('2025-12-02 10:12:23.143794',NULL,'2025-12-02 10:12:23.152789',158,158,NULL,'14b058cd-f50b-4389-936f-4848009411a2',69,'e2aae710ad6e4ecbafd15881a70326ff','snapshots',-1,'2025-12-03 10:12:23','bca19079-5f34-42ac-949b-ea604b44b1ec'),('2025-12-02 10:12:23.144562',NULL,'2025-12-02 10:12:23.152789',159,159,NULL,'c065c5a5-8de8-4559-8c29-4439f5b3f056',70,'e2aae710ad6e4ecbafd15881a70326ff','snapshot_gigabytes',-1,'2025-12-03 10:12:23','bca19079-5f34-42ac-949b-ea604b44b1ec'),('2025-12-02 10:12:26.321384',NULL,'2025-12-02 10:12:26.335220',160,160,'eec1dbb4ab40488a83c5c6e8ef9e7c00','21c4eec1-2272-4389-bb59-5f8fda265872',63,'e2aae710ad6e4ecbafd15881a70326ff','shares',-1,'2025-12-03 10:12:26',NULL),('2025-12-02 10:12:26.322184',NULL,'2025-12-02 10:12:26.335220',161,161,'eec1dbb4ab40488a83c5c6e8ef9e7c00','f32d43ae-3eb1-4e05-bcbd-9f990607a76b',64,'e2aae710ad6e4ecbafd15881a70326ff','gigabytes',-1,'2025-12-03 10:12:26',NULL),('2025-12-02 10:12:26.327160',NULL,'2025-12-02 10:12:26.335220',162,162,NULL,'2d867385-339f-40c9-b1ac-44b3c0f5c81d',65,'e2aae710ad6e4ecbafd15881a70326ff','shares',-1,'2025-12-03 10:12:26','bca19079-5f34-42ac-949b-ea604b44b1ec'),('2025-12-02 10:12:26.327863',NULL,'2025-12-02 10:12:26.335220',163,163,NULL,'202c4906-079d-4faf-b970-685e690e9583',66,'e2aae710ad6e4ecbafd15881a70326ff','gigabytes',-1,'2025-12-03 10:12:26','bca19079-5f34-42ac-949b-ea604b44b1ec'),('2025-12-02 10:12:27.665171',NULL,'2025-12-02 10:12:27.695005',164,164,'a24970ee657641b29b0cf7283964b674','1d2da1e3-b63d-4536-bcae-c853b2fd91c3',72,'a241a07e4161486091e8de3f95a1d6c6','shares',1,'2025-12-03 10:12:27',NULL),('2025-12-02 10:12:27.666233',NULL,'2025-12-02 10:12:27.695005',165,165,'a24970ee657641b29b0cf7283964b674','ea214065-ecc5-45d8-b82b-0497ddb4a860',71,'a241a07e4161486091e8de3f95a1d6c6','gigabytes',1,'2025-12-03 10:12:27',NULL),('2025-12-02 10:12:27.673143',NULL,'2025-12-02 10:12:27.695005',166,166,NULL,'0550cc8d-371b-4361-9cb4-9e49ee7da74e',43,'a241a07e4161486091e8de3f95a1d6c6','shares',1,'2025-12-03 10:12:27','d83cee99-d595-4caa-b747-37511b270d66'),('2025-12-02 10:12:27.674573',NULL,'2025-12-02 10:12:27.695005',167,167,NULL,'8018e8ff-7d7d-4313-940d-d5102ac1bd51',44,'a241a07e4161486091e8de3f95a1d6c6','gigabytes',1,'2025-12-03 10:12:27','d83cee99-d595-4caa-b747-37511b270d66'),('2025-12-02 10:12:36.912725',NULL,'2025-12-02 10:12:36.968872',168,168,'e6083d93e35641799d5c5fac36ec5423','59c4f8db-89e5-4709-88af-0689638cac10',74,'19840b2bb2f1448facc06ad6c92f7648','shares',1,'2025-12-03 10:12:36',NULL),('2025-12-02 10:12:36.914083',NULL,'2025-12-02 10:12:36.968872',169,169,'e6083d93e35641799d5c5fac36ec5423','b7a62705-22a1-46d6-a476-d8685470b83f',73,'19840b2bb2f1448facc06ad6c92f7648','gigabytes',1,'2025-12-03 10:12:36',NULL),('2025-12-02 10:12:36.935041',NULL,'2025-12-02 10:12:36.968872',170,170,NULL,'2b39a2e1-b8f2-4266-8a9a-f8c0c7b5c443',76,'19840b2bb2f1448facc06ad6c92f7648','shares',1,'2025-12-03 10:12:36','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:12:36.937374',NULL,'2025-12-02 10:12:36.968872',171,171,NULL,'1d291424-3da1-4fee-bfd8-a2fe6833a7f5',75,'19840b2bb2f1448facc06ad6c92f7648','gigabytes',1,'2025-12-03 10:12:36','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:12:40.210303',NULL,'2025-12-02 10:12:40.241724',172,172,'e6083d93e35641799d5c5fac36ec5423','3c8ec7ab-4ad2-4b18-bbb1-26f137815f75',74,'19840b2bb2f1448facc06ad6c92f7648','shares',1,'2025-12-03 10:12:40',NULL),('2025-12-02 10:12:40.212019',NULL,'2025-12-02 10:12:40.241724',173,173,'e6083d93e35641799d5c5fac36ec5423','54b1277f-4b5b-4eef-9584-c447b66beaf8',73,'19840b2bb2f1448facc06ad6c92f7648','gigabytes',1,'2025-12-03 10:12:40',NULL),('2025-12-02 10:12:40.219111',NULL,'2025-12-02 10:12:40.241724',174,174,NULL,'0aa441b1-7f94-401d-a1da-53462a5f9a7e',76,'19840b2bb2f1448facc06ad6c92f7648','shares',1,'2025-12-03 10:12:40','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:12:40.220813',NULL,'2025-12-02 10:12:40.241724',175,175,NULL,'9df2baba-f182-4cfa-8db7-5baacd637a2d',75,'19840b2bb2f1448facc06ad6c92f7648','gigabytes',1,'2025-12-03 10:12:40','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:12:41.245075',NULL,'2025-12-02 10:12:41.291956',176,176,'3d96130ac04f48a1ae7da918768692a0','353b6278-f2c9-4213-9ce9-813f629da3d2',77,'dd2b7449046b43b2859bc0c1d65aef30','shares',1,'2025-12-03 10:12:41',NULL),('2025-12-02 10:12:41.246411',NULL,'2025-12-02 10:12:41.291956',177,177,'3d96130ac04f48a1ae7da918768692a0','3aa31771-8ceb-4541-8bae-e3cb683130c7',78,'dd2b7449046b43b2859bc0c1d65aef30','gigabytes',1,'2025-12-03 10:12:41',NULL),('2025-12-02 10:12:41.267980',NULL,'2025-12-02 10:12:41.291956',178,178,NULL,'15db093f-a387-4807-a38b-d44e777cde78',79,'dd2b7449046b43b2859bc0c1d65aef30','shares',1,'2025-12-03 10:12:41','0c5d5f2e-df1d-4dc8-89ba-79d736a4ac1e'),('2025-12-02 10:12:41.269319',NULL,'2025-12-02 10:12:41.291956',179,179,NULL,'db579156-ac8e-4037-a75a-b30f7decfe09',80,'dd2b7449046b43b2859bc0c1d65aef30','gigabytes',1,'2025-12-03 10:12:41','0c5d5f2e-df1d-4dc8-89ba-79d736a4ac1e'),('2025-12-02 10:12:41.698106',NULL,'2025-12-02 10:12:41.715647',180,180,'a24970ee657641b29b0cf7283964b674','f21155de-50f9-4dae-8b6f-89b286e6b28e',72,'a241a07e4161486091e8de3f95a1d6c6','shares',-1,'2025-12-03 10:12:41',NULL),('2025-12-02 10:12:41.698997',NULL,'2025-12-02 10:12:41.715647',181,181,'a24970ee657641b29b0cf7283964b674','7b1b98a3-4bb7-4a6f-96ab-a43f738f27bc',71,'a241a07e4161486091e8de3f95a1d6c6','gigabytes',-1,'2025-12-03 10:12:41',NULL),('2025-12-02 10:12:41.708589',NULL,'2025-12-02 10:12:41.715647',182,182,NULL,'18e359ca-d731-4189-9aeb-1c9a99837375',43,'a241a07e4161486091e8de3f95a1d6c6','shares',-1,'2025-12-03 10:12:41','d83cee99-d595-4caa-b747-37511b270d66'),('2025-12-02 10:12:41.709295',NULL,'2025-12-02 10:12:41.715647',183,183,NULL,'d8acda3d-79a5-4e40-9fa8-cc1b5b93ba07',44,'a241a07e4161486091e8de3f95a1d6c6','gigabytes',-1,'2025-12-03 10:12:41','d83cee99-d595-4caa-b747-37511b270d66'),('2025-12-02 10:12:43.474221',NULL,'2025-12-02 10:12:43.698535',184,184,'e6083d93e35641799d5c5fac36ec5423','dd95e06f-6d72-4b4b-854b-190c9bff5191',73,'19840b2bb2f1448facc06ad6c92f7648','gigabytes',1,'2025-12-03 10:12:43',NULL),('2025-12-02 10:12:43.492339',NULL,'2025-12-02 10:12:43.698535',185,185,NULL,'9991ce46-8d9c-4b5b-b762-63d9c1e84cd3',75,'19840b2bb2f1448facc06ad6c92f7648','gigabytes',1,'2025-12-03 10:12:43','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:12:44.507852',NULL,'2025-12-02 10:12:44.584564',186,186,'3d96130ac04f48a1ae7da918768692a0','a10633ec-59cc-429c-be74-93371d7f0288',81,'dd2b7449046b43b2859bc0c1d65aef30','snapshots',1,'2025-12-03 10:12:44',NULL),('2025-12-02 10:12:44.508848',NULL,'2025-12-02 10:12:44.584564',187,187,'3d96130ac04f48a1ae7da918768692a0','c7d75ae8-43c7-4e02-a25c-febf4fb69e34',82,'dd2b7449046b43b2859bc0c1d65aef30','snapshot_gigabytes',1,'2025-12-03 10:12:44',NULL),('2025-12-02 10:12:44.519123',NULL,'2025-12-02 10:12:44.584564',188,188,NULL,'a313b291-29eb-4345-804b-92e0e7c37efe',83,'dd2b7449046b43b2859bc0c1d65aef30','snapshots',1,'2025-12-03 10:12:44','0c5d5f2e-df1d-4dc8-89ba-79d736a4ac1e'),('2025-12-02 10:12:44.520251',NULL,'2025-12-02 10:12:44.584564',189,189,NULL,'45f006d4-01b3-460c-b7f0-4139ee8ef257',84,'dd2b7449046b43b2859bc0c1d65aef30','snapshot_gigabytes',1,'2025-12-03 10:12:44','0c5d5f2e-df1d-4dc8-89ba-79d736a4ac1e'),('2025-12-02 10:12:44.880335',NULL,'2025-12-02 10:12:44.905126',190,190,'26d732e2823c41e7bcdba03bb8a5b208','12937f93-98b3-491d-bcac-e39887fd7718',41,'a241a07e4161486091e8de3f95a1d6c6','shares',-1,'2025-12-03 10:12:44',NULL),('2025-12-02 10:12:44.881242',NULL,'2025-12-02 10:12:44.905126',191,191,'26d732e2823c41e7bcdba03bb8a5b208','e7aeac77-95a6-46d7-9f3c-fdaa50dc3165',42,'a241a07e4161486091e8de3f95a1d6c6','gigabytes',-1,'2025-12-03 10:12:44',NULL),('2025-12-02 10:12:44.894383',NULL,'2025-12-02 10:12:44.905126',192,192,NULL,'30b6276c-06b5-47dc-a27a-5a54c464829a',43,'a241a07e4161486091e8de3f95a1d6c6','shares',-1,'2025-12-03 10:12:44','d83cee99-d595-4caa-b747-37511b270d66'),('2025-12-02 10:12:44.895598',NULL,'2025-12-02 10:12:44.905126',193,193,NULL,'6f450a20-fe19-4e5e-8acd-2c5d4a3c6afd',44,'a241a07e4161486091e8de3f95a1d6c6','gigabytes',-1,'2025-12-03 10:12:44','d83cee99-d595-4caa-b747-37511b270d66'),('2025-12-02 10:12:47.092577',NULL,'2025-12-02 10:12:47.110157',194,194,'e6083d93e35641799d5c5fac36ec5423','857fa70e-4500-4ac8-8f88-fc966d0f7eaa',74,'19840b2bb2f1448facc06ad6c92f7648','shares',-1,'2025-12-03 10:12:47',NULL),('2025-12-02 10:12:47.093202',NULL,'2025-12-02 10:12:47.110157',195,195,'e6083d93e35641799d5c5fac36ec5423','8a99a2e3-2f2f-46cf-a75a-7fec725c87e1',73,'19840b2bb2f1448facc06ad6c92f7648','gigabytes',-2,'2025-12-03 10:12:47',NULL),('2025-12-02 10:12:47.100106',NULL,'2025-12-02 10:12:47.110157',196,196,NULL,'81b18f0f-9bbd-441c-b756-fc3708fcf02a',76,'19840b2bb2f1448facc06ad6c92f7648','shares',-1,'2025-12-03 10:12:47','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:12:47.101114',NULL,'2025-12-02 10:12:47.110157',197,197,NULL,'8da5fef8-9226-409f-86ca-6ed898aed49d',75,'19840b2bb2f1448facc06ad6c92f7648','gigabytes',-2,'2025-12-03 10:12:47','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:12:48.080887',NULL,'2025-12-02 10:12:48.139470',198,198,'3d96130ac04f48a1ae7da918768692a0','ec89525f-a4f3-4913-bb46-e940343e5234',81,'dd2b7449046b43b2859bc0c1d65aef30','snapshots',1,'2025-12-03 10:12:48',NULL),('2025-12-02 10:12:48.082232',NULL,'2025-12-02 10:12:48.139470',199,199,'3d96130ac04f48a1ae7da918768692a0','297fc8a0-7bfb-4233-86be-e4f43692c0e3',82,'dd2b7449046b43b2859bc0c1d65aef30','snapshot_gigabytes',1,'2025-12-03 10:12:48',NULL),('2025-12-02 10:12:48.088545',NULL,'2025-12-02 10:12:48.139470',200,200,NULL,'3a1976c3-3a61-43c5-b220-cc234b5855d9',83,'dd2b7449046b43b2859bc0c1d65aef30','snapshots',1,'2025-12-03 10:12:48','0c5d5f2e-df1d-4dc8-89ba-79d736a4ac1e'),('2025-12-02 10:12:48.089664',NULL,'2025-12-02 10:12:48.139470',201,201,NULL,'48028e27-45d6-477a-963a-63a0eef6f7ff',84,'dd2b7449046b43b2859bc0c1d65aef30','snapshot_gigabytes',1,'2025-12-03 10:12:48','0c5d5f2e-df1d-4dc8-89ba-79d736a4ac1e'),('2025-12-02 10:12:49.905406',NULL,'2025-12-02 10:12:49.931257',202,202,'e6083d93e35641799d5c5fac36ec5423','524bf779-b12c-4add-9002-b1dd35ba35a1',74,'19840b2bb2f1448facc06ad6c92f7648','shares',1,'2025-12-03 10:12:49',NULL),('2025-12-02 10:12:49.906872',NULL,'2025-12-02 10:12:49.931257',203,203,'e6083d93e35641799d5c5fac36ec5423','74929ed9-c335-41b3-a4e6-24c60b2fd9e7',73,'19840b2bb2f1448facc06ad6c92f7648','gigabytes',1,'2025-12-03 10:12:49',NULL),('2025-12-02 10:12:49.912641',NULL,'2025-12-02 10:12:49.931257',204,204,NULL,'beb5bb6f-7240-4dc1-8ab6-7ba565de7859',76,'19840b2bb2f1448facc06ad6c92f7648','shares',1,'2025-12-03 10:12:49','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:12:49.913899',NULL,'2025-12-02 10:12:49.931257',205,205,NULL,'5d930e70-42c8-454e-af6d-cf1d9de0ed68',75,'19840b2bb2f1448facc06ad6c92f7648','gigabytes',1,'2025-12-03 10:12:49','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:12:52.315941',NULL,'2025-12-02 10:12:52.332307',206,206,'3d96130ac04f48a1ae7da918768692a0','ee55a518-efa8-442a-88c7-a370a473c168',81,'dd2b7449046b43b2859bc0c1d65aef30','snapshots',-1,'2025-12-03 10:12:52',NULL),('2025-12-02 10:12:52.316680',NULL,'2025-12-02 10:12:52.332307',207,207,'3d96130ac04f48a1ae7da918768692a0','85eadf23-3780-48b2-b03f-ac06ba4dbe63',82,'dd2b7449046b43b2859bc0c1d65aef30','snapshot_gigabytes',-1,'2025-12-03 10:12:52',NULL),('2025-12-02 10:12:52.322233',NULL,'2025-12-02 10:12:52.332307',208,208,NULL,'d49b9abf-4199-4b4d-9a5c-8762e5d4e6bd',83,'dd2b7449046b43b2859bc0c1d65aef30','snapshots',-1,'2025-12-03 10:12:52','0c5d5f2e-df1d-4dc8-89ba-79d736a4ac1e'),('2025-12-02 10:12:52.323048',NULL,'2025-12-02 10:12:52.332307',209,209,NULL,'53904870-b68e-403b-8d2a-91567049d2fc',84,'dd2b7449046b43b2859bc0c1d65aef30','snapshot_gigabytes',-1,'2025-12-03 10:12:52','0c5d5f2e-df1d-4dc8-89ba-79d736a4ac1e'),('2025-12-02 10:12:53.132773',NULL,'2025-12-02 10:12:53.346317',210,210,'e6083d93e35641799d5c5fac36ec5423','8a68ffcb-4b7e-4fb5-a173-54f96ffa6cb7',73,'19840b2bb2f1448facc06ad6c92f7648','gigabytes',1,'2025-12-03 10:12:53',NULL),('2025-12-02 10:12:53.139446',NULL,'2025-12-02 10:12:53.346317',211,211,NULL,'9c5a4f56-d8f7-4d37-ab3b-5c232cd618df',75,'19840b2bb2f1448facc06ad6c92f7648','gigabytes',1,'2025-12-03 10:12:53','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:12:55.200558',NULL,'2025-12-02 10:12:55.225236',212,212,'3d96130ac04f48a1ae7da918768692a0','32a999a6-c37b-4e0b-aaec-545873953464',81,'dd2b7449046b43b2859bc0c1d65aef30','snapshots',-1,'2025-12-03 10:12:55',NULL),('2025-12-02 10:12:55.202764',NULL,'2025-12-02 10:12:55.225236',213,213,'3d96130ac04f48a1ae7da918768692a0','a39f624e-f1ac-48bc-9879-0d98bcb5954c',82,'dd2b7449046b43b2859bc0c1d65aef30','snapshot_gigabytes',-1,'2025-12-03 10:12:55',NULL),('2025-12-02 10:12:55.213032',NULL,'2025-12-02 10:12:55.225236',214,214,NULL,'febd657b-40ba-42b2-abcc-730d06804e3e',83,'dd2b7449046b43b2859bc0c1d65aef30','snapshots',-1,'2025-12-03 10:12:55','0c5d5f2e-df1d-4dc8-89ba-79d736a4ac1e'),('2025-12-02 10:12:55.214179',NULL,'2025-12-02 10:12:55.225236',215,215,NULL,'50e10d49-46e2-48dc-9c6e-a03b9316a8e4',84,'dd2b7449046b43b2859bc0c1d65aef30','snapshot_gigabytes',-1,'2025-12-03 10:12:55','0c5d5f2e-df1d-4dc8-89ba-79d736a4ac1e'),('2025-12-02 10:12:56.747056',NULL,'2025-12-02 10:12:56.764113',216,216,'e6083d93e35641799d5c5fac36ec5423','f0143c4e-0de9-411c-ba2b-e5a2a2189648',74,'19840b2bb2f1448facc06ad6c92f7648','shares',-1,'2025-12-03 10:12:56',NULL),('2025-12-02 10:12:56.747913',NULL,'2025-12-02 10:12:56.764113',217,217,'e6083d93e35641799d5c5fac36ec5423','efe2c067-c650-4823-88c0-d8084fe15fff',73,'19840b2bb2f1448facc06ad6c92f7648','gigabytes',-2,'2025-12-03 10:12:56',NULL),('2025-12-02 10:12:56.756533',NULL,'2025-12-02 10:12:56.764113',218,218,NULL,'31a6bbc8-000e-4ce2-b6f6-d87e3d76d699',76,'19840b2bb2f1448facc06ad6c92f7648','shares',-1,'2025-12-03 10:12:56','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:12:56.757349',NULL,'2025-12-02 10:12:56.764113',219,219,NULL,'da71b87c-075a-472c-adeb-44f0ba2443bd',75,'19840b2bb2f1448facc06ad6c92f7648','gigabytes',-2,'2025-12-03 10:12:56','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:12:58.335598',NULL,'2025-12-02 10:12:58.352146',220,220,'3d96130ac04f48a1ae7da918768692a0','c4c4f9dc-9d00-4857-888e-4436a19b9bd4',77,'dd2b7449046b43b2859bc0c1d65aef30','shares',-1,'2025-12-03 10:12:58',NULL),('2025-12-02 10:12:58.336368',NULL,'2025-12-02 10:12:58.352146',221,221,'3d96130ac04f48a1ae7da918768692a0','53745cfc-a8dd-4ec2-97d9-4b8896b81360',78,'dd2b7449046b43b2859bc0c1d65aef30','gigabytes',-1,'2025-12-03 10:12:58',NULL),('2025-12-02 10:12:58.343972',NULL,'2025-12-02 10:12:58.352146',222,222,NULL,'540e7e4b-ad39-4770-a29d-db7439644708',79,'dd2b7449046b43b2859bc0c1d65aef30','shares',-1,'2025-12-03 10:12:58','0c5d5f2e-df1d-4dc8-89ba-79d736a4ac1e'),('2025-12-02 10:12:58.344997',NULL,'2025-12-02 10:12:58.352146',223,223,NULL,'1a118bb9-24bd-470b-a89a-9eca94100cc5',80,'dd2b7449046b43b2859bc0c1d65aef30','gigabytes',-1,'2025-12-03 10:12:58','0c5d5f2e-df1d-4dc8-89ba-79d736a4ac1e'),('2025-12-02 10:12:59.719209',NULL,'2025-12-02 10:12:59.774066',224,224,'e6083d93e35641799d5c5fac36ec5423','4376c2ea-c840-43b4-9af5-851b1ae79e41',74,'19840b2bb2f1448facc06ad6c92f7648','shares',1,'2025-12-03 10:12:59',NULL),('2025-12-02 10:12:59.721946',NULL,'2025-12-02 10:12:59.774066',225,225,'e6083d93e35641799d5c5fac36ec5423','6379530e-eb7b-439a-9500-180bf32f3272',73,'19840b2bb2f1448facc06ad6c92f7648','gigabytes',1,'2025-12-03 10:12:59',NULL),('2025-12-02 10:12:59.739872',NULL,'2025-12-02 10:12:59.774066',226,226,NULL,'b06ac89b-de66-42ad-8b76-0d67eab4e902',76,'19840b2bb2f1448facc06ad6c92f7648','shares',1,'2025-12-03 10:12:59','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:12:59.742972',NULL,'2025-12-02 10:12:59.774066',227,227,NULL,'e7c72c09-f9e6-4130-96d7-4a4af81c4760',75,'19840b2bb2f1448facc06ad6c92f7648','gigabytes',1,'2025-12-03 10:12:59','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:03.501404',NULL,'2025-12-02 10:13:03.516956',228,228,'e6083d93e35641799d5c5fac36ec5423','29c409f9-dd5a-4ec4-8f15-7d747eab3d4b',74,'19840b2bb2f1448facc06ad6c92f7648','shares',-1,'2025-12-03 10:13:03',NULL),('2025-12-02 10:13:03.502049',NULL,'2025-12-02 10:13:03.516956',229,229,'e6083d93e35641799d5c5fac36ec5423','cc6140f9-7c1c-4236-ae5c-cdaf5068cf7c',73,'19840b2bb2f1448facc06ad6c92f7648','gigabytes',-1,'2025-12-03 10:13:03',NULL),('2025-12-02 10:13:03.507468',NULL,'2025-12-02 10:13:03.516956',230,230,NULL,'e7195a62-ca8d-413d-aaae-894e8ec48576',76,'19840b2bb2f1448facc06ad6c92f7648','shares',-1,'2025-12-03 10:13:03','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:03.508184',NULL,'2025-12-02 10:13:03.516956',231,231,NULL,'a2df4b51-26bf-4d32-8755-b104cb593ab3',75,'19840b2bb2f1448facc06ad6c92f7648','gigabytes',-1,'2025-12-03 10:13:03','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:06.359804',NULL,'2025-12-02 10:13:06.394681',232,232,'e6083d93e35641799d5c5fac36ec5423','d57d5424-5318-429f-a2c0-ad4a24b1651c',74,'19840b2bb2f1448facc06ad6c92f7648','shares',1,'2025-12-03 10:13:06',NULL),('2025-12-02 10:13:06.361057',NULL,'2025-12-02 10:13:06.394681',233,233,'e6083d93e35641799d5c5fac36ec5423','7d2d2665-ca7b-41eb-9c49-364ad5d22f81',73,'19840b2bb2f1448facc06ad6c92f7648','gigabytes',1,'2025-12-03 10:13:06',NULL),('2025-12-02 10:13:06.367130',NULL,'2025-12-02 10:13:06.394681',234,234,NULL,'6c18b0a1-e8c8-4bd2-a44a-a5e4bf8afa3e',76,'19840b2bb2f1448facc06ad6c92f7648','shares',1,'2025-12-03 10:13:06','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:06.368398',NULL,'2025-12-02 10:13:06.394681',235,235,NULL,'7720fe97-863f-4a97-aa94-a142d4298df5',75,'19840b2bb2f1448facc06ad6c92f7648','gigabytes',1,'2025-12-03 10:13:06','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:07.097258',NULL,'2025-12-02 10:13:07.138001',236,236,'da7030dac3434a548760dd16ab870b94','6967610d-ba63-400e-a1d6-1afc1304bbc7',85,'a1e9341f44d842eebc66ae567e788c12','shares',1,'2025-12-03 10:13:07',NULL),('2025-12-02 10:13:07.098339',NULL,'2025-12-02 10:13:07.138001',237,237,'da7030dac3434a548760dd16ab870b94','47396cab-6883-41b0-b87c-994edb3ce940',86,'a1e9341f44d842eebc66ae567e788c12','gigabytes',1,'2025-12-03 10:13:07',NULL),('2025-12-02 10:13:07.110937',NULL,'2025-12-02 10:13:07.138001',238,238,NULL,'9871ccba-303f-457f-8319-0c8f67a8dc78',87,'a1e9341f44d842eebc66ae567e788c12','shares',1,'2025-12-03 10:13:07','d9b33f45-8607-4704-83ed-bb8ffbbe3d7a'),('2025-12-02 10:13:07.112182',NULL,'2025-12-02 10:13:07.138001',239,239,NULL,'589f8cc7-1b99-4e59-a70c-321ce4e99286',88,'a1e9341f44d842eebc66ae567e788c12','gigabytes',1,'2025-12-03 10:13:07','d9b33f45-8607-4704-83ed-bb8ffbbe3d7a'),('2025-12-02 10:13:08.101606',NULL,'2025-12-02 10:13:08.153957',240,240,'9589fe7bcd86443cb59c8eabe6353abf','ecc25449-7af9-4ea6-b59c-ea3c6225f021',89,'b49a81aec3ba47f98ba171f12cd88b8a','share_networks',1,'2025-12-03 10:13:08',NULL),('2025-12-02 10:13:08.493066',NULL,'2025-12-02 10:13:08.498996',241,241,'9589fe7bcd86443cb59c8eabe6353abf','6f0eea1a-70b1-4c9e-a01a-5bfb6a3cf6c0',89,'b49a81aec3ba47f98ba171f12cd88b8a','share_networks',-1,'2025-12-03 10:13:08',NULL),('2025-12-02 10:13:08.559078',NULL,'2025-12-02 10:13:08.594044',242,242,'9589fe7bcd86443cb59c8eabe6353abf','67ef744e-9f0f-467d-8458-3982a4acae60',89,'b49a81aec3ba47f98ba171f12cd88b8a','share_networks',1,'2025-12-03 10:13:08',NULL),('2025-12-02 10:13:08.878135',NULL,'2025-12-02 10:13:08.885573',243,243,'9589fe7bcd86443cb59c8eabe6353abf','5080458e-a48d-498c-8063-6b1ebdac0286',89,'b49a81aec3ba47f98ba171f12cd88b8a','share_networks',-1,'2025-12-03 10:13:08',NULL),('2025-12-02 10:13:08.959923',NULL,'2025-12-02 10:13:09.021500',244,244,'9589fe7bcd86443cb59c8eabe6353abf','3e1c4aed-4cd6-4861-bcab-d9b834a0fad6',89,'b49a81aec3ba47f98ba171f12cd88b8a','share_networks',1,'2025-12-03 10:13:08',NULL),('2025-12-02 10:13:09.430845',NULL,'2025-12-02 10:13:09.437162',245,245,'9589fe7bcd86443cb59c8eabe6353abf','7f9520b8-7d84-49c2-a27c-27519754bdf9',89,'b49a81aec3ba47f98ba171f12cd88b8a','share_networks',-1,'2025-12-03 10:13:09',NULL),('2025-12-02 10:13:10.179756',NULL,'2025-12-02 10:13:10.220891',246,246,'e6083d93e35641799d5c5fac36ec5423','c800c014-7770-4781-9b20-18492703f98a',74,'19840b2bb2f1448facc06ad6c92f7648','shares',-1,'2025-12-03 10:13:10',NULL),('2025-12-02 10:13:10.182112',NULL,'2025-12-02 10:13:10.220891',247,247,'e6083d93e35641799d5c5fac36ec5423','1553eb50-2705-40ec-92ca-2f7195a57a2b',73,'19840b2bb2f1448facc06ad6c92f7648','gigabytes',-1,'2025-12-03 10:13:10',NULL),('2025-12-02 10:13:10.202392',NULL,'2025-12-02 10:13:10.220891',248,248,NULL,'6d7fa4b2-3511-44d3-b8d1-9b1542f8b666',76,'19840b2bb2f1448facc06ad6c92f7648','shares',-1,'2025-12-03 10:13:10','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:10.204921',NULL,'2025-12-02 10:13:10.220891',249,249,NULL,'06840a47-639b-4118-a15c-db48f32df2ed',75,'19840b2bb2f1448facc06ad6c92f7648','gigabytes',-1,'2025-12-03 10:13:10','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:10.455518',NULL,'2025-12-02 10:13:10.542395',250,250,'da7030dac3434a548760dd16ab870b94','7a9c1f51-4545-43de-9161-5f32d5c43253',91,'a1e9341f44d842eebc66ae567e788c12','snapshots',1,'2025-12-03 10:13:10',NULL),('2025-12-02 10:13:10.457613',NULL,'2025-12-02 10:13:10.542395',251,251,'da7030dac3434a548760dd16ab870b94','dee6ca51-3206-498b-84de-ef8215e7516c',90,'a1e9341f44d842eebc66ae567e788c12','snapshot_gigabytes',1,'2025-12-03 10:13:10',NULL),('2025-12-02 10:13:10.467401',NULL,'2025-12-02 10:13:10.542395',252,252,NULL,'7b0c5e9e-6389-47e9-b67c-5d713734539b',93,'a1e9341f44d842eebc66ae567e788c12','snapshots',1,'2025-12-03 10:13:10','d9b33f45-8607-4704-83ed-bb8ffbbe3d7a'),('2025-12-02 10:13:10.468555',NULL,'2025-12-02 10:13:10.542395',253,253,NULL,'e4e86c2f-4e3f-4313-be77-54afc14c5479',92,'a1e9341f44d842eebc66ae567e788c12','snapshot_gigabytes',1,'2025-12-03 10:13:10','d9b33f45-8607-4704-83ed-bb8ffbbe3d7a'),('2025-12-02 10:13:12.973679',NULL,'2025-12-02 10:13:13.051552',254,254,'e6083d93e35641799d5c5fac36ec5423','e3d99a27-8ab2-4ea8-8310-0dad8d5f2d58',95,'19840b2bb2f1448facc06ad6c92f7648','snapshots',1,'2025-12-03 10:13:12',NULL),('2025-12-02 10:13:12.975042',NULL,'2025-12-02 10:13:13.051552',255,255,'e6083d93e35641799d5c5fac36ec5423','f8f215d3-571b-4cb3-b30b-09e088b8cd60',94,'19840b2bb2f1448facc06ad6c92f7648','snapshot_gigabytes',1,'2025-12-03 10:13:12',NULL),('2025-12-02 10:13:12.987277',NULL,'2025-12-02 10:13:13.051552',256,256,NULL,'d1e54c5e-c42f-4020-b1c0-19e91d7710e1',97,'19840b2bb2f1448facc06ad6c92f7648','snapshots',1,'2025-12-03 10:13:12','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:12.988658',NULL,'2025-12-02 10:13:13.051552',257,257,NULL,'733d2ae1-ca6f-4ae0-b1ce-efb9b1ea92a8',96,'19840b2bb2f1448facc06ad6c92f7648','snapshot_gigabytes',1,'2025-12-03 10:13:12','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:14.568075',NULL,'2025-12-02 10:13:14.582908',258,258,'da7030dac3434a548760dd16ab870b94','d67b2628-47df-4e37-a18e-508f7fbc36e8',91,'a1e9341f44d842eebc66ae567e788c12','snapshots',-1,'2025-12-03 10:13:14',NULL),('2025-12-02 10:13:14.568919',NULL,'2025-12-02 10:13:14.582908',259,259,'da7030dac3434a548760dd16ab870b94','6927ada0-34b6-47f7-9786-02ced10e86e2',90,'a1e9341f44d842eebc66ae567e788c12','snapshot_gigabytes',-1,'2025-12-03 10:13:14',NULL),('2025-12-02 10:13:14.574360',NULL,'2025-12-02 10:13:14.582908',260,260,NULL,'5e3f6bc9-db3f-4ef7-b23f-52042f8123be',93,'a1e9341f44d842eebc66ae567e788c12','snapshots',-1,'2025-12-03 10:13:14','d9b33f45-8607-4704-83ed-bb8ffbbe3d7a'),('2025-12-02 10:13:14.575091',NULL,'2025-12-02 10:13:14.582908',261,261,NULL,'666c346c-0583-4dfa-b176-96ae27a170ee',92,'a1e9341f44d842eebc66ae567e788c12','snapshot_gigabytes',-1,'2025-12-03 10:13:14','d9b33f45-8607-4704-83ed-bb8ffbbe3d7a'),('2025-12-02 10:13:16.728678',NULL,'2025-12-02 10:13:16.752807',262,262,'e6083d93e35641799d5c5fac36ec5423','b36ce8b8-2a9a-418a-a6b4-15e45963e1ee',95,'19840b2bb2f1448facc06ad6c92f7648','snapshots',-1,'2025-12-03 10:13:16',NULL),('2025-12-02 10:13:16.731424',NULL,'2025-12-02 10:13:16.752807',263,263,'e6083d93e35641799d5c5fac36ec5423','3915c9a8-f815-41e3-ab8d-e9522a7c794e',94,'19840b2bb2f1448facc06ad6c92f7648','snapshot_gigabytes',-1,'2025-12-03 10:13:16',NULL),('2025-12-02 10:13:16.741929',NULL,'2025-12-02 10:13:16.752807',264,264,NULL,'f814dd97-6456-4035-8b68-7fc0d770ef88',97,'19840b2bb2f1448facc06ad6c92f7648','snapshots',-1,'2025-12-03 10:13:16','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:16.742898',NULL,'2025-12-02 10:13:16.752807',265,265,NULL,'5e0f0f3a-4f46-4212-8c04-97ba56705c99',96,'19840b2bb2f1448facc06ad6c92f7648','snapshot_gigabytes',-1,'2025-12-03 10:13:16','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:17.705234',NULL,'2025-12-02 10:13:17.721310',266,266,'da7030dac3434a548760dd16ab870b94','23ebeb95-a897-4c48-80f2-e4825b4da0a3',85,'a1e9341f44d842eebc66ae567e788c12','shares',-1,'2025-12-03 10:13:17',NULL),('2025-12-02 10:13:17.705971',NULL,'2025-12-02 10:13:17.721310',267,267,'da7030dac3434a548760dd16ab870b94','5ed7432e-5d7c-4eab-abc0-a6cbbd32a777',86,'a1e9341f44d842eebc66ae567e788c12','gigabytes',-1,'2025-12-03 10:13:17',NULL),('2025-12-02 10:13:17.711081',NULL,'2025-12-02 10:13:17.721310',268,268,NULL,'71ade88f-6b8d-495a-b9b4-df24c9ef99a1',87,'a1e9341f44d842eebc66ae567e788c12','shares',-1,'2025-12-03 10:13:17','d9b33f45-8607-4704-83ed-bb8ffbbe3d7a'),('2025-12-02 10:13:17.711825',NULL,'2025-12-02 10:13:17.721310',269,269,NULL,'f8148654-f771-4255-be19-cf2b49ac3a18',88,'a1e9341f44d842eebc66ae567e788c12','gigabytes',-1,'2025-12-03 10:13:17','d9b33f45-8607-4704-83ed-bb8ffbbe3d7a'),('2025-12-02 10:13:21.878984',NULL,'2025-12-02 10:13:21.937598',270,270,'e6083d93e35641799d5c5fac36ec5423','33395f99-1823-4451-bb83-c65e2a320fd0',95,'19840b2bb2f1448facc06ad6c92f7648','snapshots',1,'2025-12-03 10:13:21',NULL),('2025-12-02 10:13:21.880159',NULL,'2025-12-02 10:13:21.937598',271,271,'e6083d93e35641799d5c5fac36ec5423','6843de35-d069-40f1-9f66-e7942ca7de8e',94,'19840b2bb2f1448facc06ad6c92f7648','snapshot_gigabytes',1,'2025-12-03 10:13:21',NULL),('2025-12-02 10:13:21.887021',NULL,'2025-12-02 10:13:21.937598',272,272,NULL,'940cd385-b1ba-4432-ab5a-598177376385',97,'19840b2bb2f1448facc06ad6c92f7648','snapshots',1,'2025-12-03 10:13:21','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:21.887943',NULL,'2025-12-02 10:13:21.937598',273,273,NULL,'1e97a945-77f1-4ba6-a731-b4c401876a0d',96,'19840b2bb2f1448facc06ad6c92f7648','snapshot_gigabytes',1,'2025-12-03 10:13:21','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:25.413512',NULL,'2025-12-02 10:13:25.489169',274,274,'e6083d93e35641799d5c5fac36ec5423','e0a43751-b854-4119-9226-8f5a3c9a1a48',95,'19840b2bb2f1448facc06ad6c92f7648','snapshots',1,'2025-12-03 10:13:25',NULL),('2025-12-02 10:13:25.416130',NULL,'2025-12-02 10:13:25.489169',275,275,'e6083d93e35641799d5c5fac36ec5423','c582fb41-3dd7-47e9-9886-afd34461e0ca',94,'19840b2bb2f1448facc06ad6c92f7648','snapshot_gigabytes',1,'2025-12-03 10:13:25',NULL),('2025-12-02 10:13:25.425162',NULL,'2025-12-02 10:13:25.489169',276,276,NULL,'ec0a96ff-517b-47c6-ad9f-73d066a5f8de',97,'19840b2bb2f1448facc06ad6c92f7648','snapshots',1,'2025-12-03 10:13:25','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:25.426630',NULL,'2025-12-02 10:13:25.489169',277,277,NULL,'f52b99f2-2b7a-45bb-95fe-f484024a57ce',96,'19840b2bb2f1448facc06ad6c92f7648','snapshot_gigabytes',1,'2025-12-03 10:13:25','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:25.688327',NULL,'2025-12-02 10:13:25.731531',278,278,'b27f974843b944ad89618a9e837b7d08','b5977dae-15c4-49d6-b2b3-a5ca934f6e13',98,'1d8a048450454feda5d5f8e5791593b2','shares',1,'2025-12-03 10:13:25',NULL),('2025-12-02 10:13:25.689679',NULL,'2025-12-02 10:13:25.731531',279,279,'b27f974843b944ad89618a9e837b7d08','14b5f5aa-e02f-4f7e-bf16-82af2a2c1186',99,'1d8a048450454feda5d5f8e5791593b2','gigabytes',1,'2025-12-03 10:13:25',NULL),('2025-12-02 10:13:25.708274',NULL,'2025-12-02 10:13:25.731531',280,280,NULL,'3940d271-ade3-4893-aad6-52174bfe3bcd',100,'1d8a048450454feda5d5f8e5791593b2','shares',1,'2025-12-03 10:13:25','711e4bca-5889-4f1b-89b1-9c764a24ece6'),('2025-12-02 10:13:25.709624',NULL,'2025-12-02 10:13:25.731531',281,281,NULL,'95d2dadf-0b0a-4704-aefc-16ec39e5e947',101,'1d8a048450454feda5d5f8e5791593b2','gigabytes',1,'2025-12-03 10:13:25','711e4bca-5889-4f1b-89b1-9c764a24ece6'),('2025-12-02 10:13:28.947146',NULL,'2025-12-02 10:13:29.043797',282,282,'e6083d93e35641799d5c5fac36ec5423','124c8c41-c102-417c-b327-75e292cf4629',95,'19840b2bb2f1448facc06ad6c92f7648','snapshots',1,'2025-12-03 10:13:28',NULL),('2025-12-02 10:13:28.948481',NULL,'2025-12-02 10:13:29.043797',283,283,'e6083d93e35641799d5c5fac36ec5423','22a07dc6-9925-4e18-82eb-c1fc9a809cac',94,'19840b2bb2f1448facc06ad6c92f7648','snapshot_gigabytes',1,'2025-12-03 10:13:28',NULL),('2025-12-02 10:13:28.954709',NULL,'2025-12-02 10:13:29.043797',284,284,NULL,'2d8d0259-e7a8-469a-9bcc-2b61bb35dd87',97,'19840b2bb2f1448facc06ad6c92f7648','snapshots',1,'2025-12-03 10:13:28','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:28.955894',NULL,'2025-12-02 10:13:29.043797',285,285,NULL,'a134e1d9-a6cc-4a82-9267-62108fc43524',96,'19840b2bb2f1448facc06ad6c92f7648','snapshot_gigabytes',1,'2025-12-03 10:13:28','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:29.171108',NULL,'2025-12-02 10:13:29.208325',286,286,'b27f974843b944ad89618a9e837b7d08','8d23bc18-884f-4a85-9ef1-8ca9e99b74b5',98,'1d8a048450454feda5d5f8e5791593b2','shares',-1,'2025-12-03 10:13:29',NULL),('2025-12-02 10:13:29.172032',NULL,'2025-12-02 10:13:29.208325',287,287,'b27f974843b944ad89618a9e837b7d08','16267e48-8a2d-4ca4-be1b-b72f0210d5d2',99,'1d8a048450454feda5d5f8e5791593b2','gigabytes',-1,'2025-12-03 10:13:29',NULL),('2025-12-02 10:13:29.184359',NULL,'2025-12-02 10:13:29.208325',288,288,NULL,'a776cee8-03f5-43bd-a424-4ccf873300cf',100,'1d8a048450454feda5d5f8e5791593b2','shares',-1,'2025-12-03 10:13:29','711e4bca-5889-4f1b-89b1-9c764a24ece6'),('2025-12-02 10:13:29.185487',NULL,'2025-12-02 10:13:29.208325',289,289,NULL,'b28ee327-6412-436c-b9f7-ec3605415bbe',101,'1d8a048450454feda5d5f8e5791593b2','gigabytes',-1,'2025-12-03 10:13:29','711e4bca-5889-4f1b-89b1-9c764a24ece6'),('2025-12-02 10:13:29.375990',NULL,'2025-12-02 10:13:29.424212',290,290,'b27f974843b944ad89618a9e837b7d08','4d08e4dd-44b4-41a9-bb86-6d81c8937879',98,'1d8a048450454feda5d5f8e5791593b2','shares',1,'2025-12-03 10:13:29',NULL),('2025-12-02 10:13:29.379432',NULL,'2025-12-02 10:13:29.424212',291,291,'b27f974843b944ad89618a9e837b7d08','38b6b619-0031-445b-8853-89a70fc1de0e',99,'1d8a048450454feda5d5f8e5791593b2','gigabytes',1,'2025-12-03 10:13:29',NULL),('2025-12-02 10:13:29.399936',NULL,'2025-12-02 10:13:29.424212',292,292,NULL,'b2b9b963-3091-47d8-a882-13b0547c434e',102,'1d8a048450454feda5d5f8e5791593b2','shares',1,'2025-12-03 10:13:29','db8cf28f-b745-44d5-994c-083b9e44d810'),('2025-12-02 10:13:29.401155',NULL,'2025-12-02 10:13:29.424212',293,293,NULL,'e509a17a-a9f4-48f6-b546-7c73ac8284ad',103,'1d8a048450454feda5d5f8e5791593b2','gigabytes',1,'2025-12-03 10:13:29','db8cf28f-b745-44d5-994c-083b9e44d810'),('2025-12-02 10:13:32.686697',NULL,'2025-12-02 10:13:32.760333',294,294,'e6083d93e35641799d5c5fac36ec5423','b3e9bcde-eabc-4873-a1b1-38147c282b0d',95,'19840b2bb2f1448facc06ad6c92f7648','snapshots',1,'2025-12-03 10:13:32',NULL),('2025-12-02 10:13:32.688608',NULL,'2025-12-02 10:13:32.760333',295,295,'e6083d93e35641799d5c5fac36ec5423','76aabe4e-9b96-4406-9495-a94881ed6743',94,'19840b2bb2f1448facc06ad6c92f7648','snapshot_gigabytes',1,'2025-12-03 10:13:32',NULL),('2025-12-02 10:13:32.695560',NULL,'2025-12-02 10:13:32.760333',296,296,NULL,'02934795-8158-4381-947b-5cbb7b096431',97,'19840b2bb2f1448facc06ad6c92f7648','snapshots',1,'2025-12-03 10:13:32','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:32.696886',NULL,'2025-12-02 10:13:32.760333',297,297,NULL,'86e4fa95-61d9-4b74-b5b6-ee620990c9e2',96,'19840b2bb2f1448facc06ad6c92f7648','snapshot_gigabytes',1,'2025-12-03 10:13:32','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:32.822829',NULL,'2025-12-02 10:13:32.855965',298,298,'b27f974843b944ad89618a9e837b7d08','a95376ec-4c00-4a9f-9609-e0984d4e8259',98,'1d8a048450454feda5d5f8e5791593b2','shares',-1,'2025-12-03 10:13:32',NULL),('2025-12-02 10:13:32.823605',NULL,'2025-12-02 10:13:32.855965',299,299,'b27f974843b944ad89618a9e837b7d08','6b2e9a39-6fc9-4ae3-a63b-10a443b43d01',99,'1d8a048450454feda5d5f8e5791593b2','gigabytes',-1,'2025-12-03 10:13:32',NULL),('2025-12-02 10:13:32.846044',NULL,'2025-12-02 10:13:32.855965',300,300,NULL,'06037953-0250-49ab-8447-345a4f77497d',102,'1d8a048450454feda5d5f8e5791593b2','shares',-1,'2025-12-03 10:13:32','db8cf28f-b745-44d5-994c-083b9e44d810'),('2025-12-02 10:13:32.847079',NULL,'2025-12-02 10:13:32.855965',301,301,NULL,'b7d7f157-36f2-4903-87d6-23843d393283',103,'1d8a048450454feda5d5f8e5791593b2','gigabytes',-1,'2025-12-03 10:13:32','db8cf28f-b745-44d5-994c-083b9e44d810'),('2025-12-02 10:13:32.975488',NULL,'2025-12-02 10:13:33.034319',302,302,'b27f974843b944ad89618a9e837b7d08','dc7fae43-d3cc-4447-a05e-12e16dae3080',98,'1d8a048450454feda5d5f8e5791593b2','shares',1,'2025-12-03 10:13:32',NULL),('2025-12-02 10:13:32.977135',NULL,'2025-12-02 10:13:33.034319',303,303,'b27f974843b944ad89618a9e837b7d08','700cbd11-3a5a-4cf0-98a3-632697412c22',99,'1d8a048450454feda5d5f8e5791593b2','gigabytes',1,'2025-12-03 10:13:32',NULL),('2025-12-02 10:13:32.987930',NULL,'2025-12-02 10:13:33.034319',304,304,NULL,'294c6117-cd88-4bec-b778-2ca813d893ba',105,'1d8a048450454feda5d5f8e5791593b2','shares',1,'2025-12-03 10:13:32','0eebaea2-ff0c-4c78-a7aa-627703af02da'),('2025-12-02 10:13:32.991060',NULL,'2025-12-02 10:13:33.034319',305,305,NULL,'5404d752-b1ef-467e-a47f-4302ae881442',104,'1d8a048450454feda5d5f8e5791593b2','gigabytes',1,'2025-12-03 10:13:32','0eebaea2-ff0c-4c78-a7aa-627703af02da'),('2025-12-02 10:13:36.312910',NULL,'2025-12-02 10:13:36.347305',306,306,'b27f974843b944ad89618a9e837b7d08','442bfc40-8874-4c3d-9b19-5fe1a4ffb802',98,'1d8a048450454feda5d5f8e5791593b2','shares',1,'2025-12-03 10:13:36',NULL),('2025-12-02 10:13:36.314163',NULL,'2025-12-02 10:13:36.347305',307,307,'b27f974843b944ad89618a9e837b7d08','dba8c558-722b-4e29-9629-39a970d6c4ea',99,'1d8a048450454feda5d5f8e5791593b2','gigabytes',1,'2025-12-03 10:13:36',NULL),('2025-12-02 10:13:36.323591',NULL,'2025-12-02 10:13:36.347305',308,308,NULL,'1aaea0b9-7096-4fb9-908b-bf5dc2472b49',107,'1d8a048450454feda5d5f8e5791593b2','shares',1,'2025-12-03 10:13:36','d25d2ab8-3188-40e8-af40-2b39819c2e82'),('2025-12-02 10:13:36.324672',NULL,'2025-12-02 10:13:36.347305',309,309,NULL,'9d780c17-222c-431d-a7f6-f6ced19a1bbb',106,'1d8a048450454feda5d5f8e5791593b2','gigabytes',1,'2025-12-03 10:13:36','d25d2ab8-3188-40e8-af40-2b39819c2e82'),('2025-12-02 10:13:36.592249',NULL,'2025-12-02 10:13:36.655942',310,310,'e6083d93e35641799d5c5fac36ec5423','efc7a21e-836c-41b7-880e-c4bd86a11d49',95,'19840b2bb2f1448facc06ad6c92f7648','snapshots',1,'2025-12-03 10:13:36',NULL),('2025-12-02 10:13:36.593303',NULL,'2025-12-02 10:13:36.655942',311,311,'e6083d93e35641799d5c5fac36ec5423','560b83ce-22bc-4a9a-98b0-6aad9e68704f',94,'19840b2bb2f1448facc06ad6c92f7648','snapshot_gigabytes',1,'2025-12-03 10:13:36',NULL),('2025-12-02 10:13:36.598088',NULL,'2025-12-02 10:13:36.655942',312,312,NULL,'a630b525-e262-4d3e-9302-d846d2bc57b8',97,'19840b2bb2f1448facc06ad6c92f7648','snapshots',1,'2025-12-03 10:13:36','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:36.599294',NULL,'2025-12-02 10:13:36.655942',313,313,NULL,'fd09115c-f957-4b9d-bdce-00fd13e1bbf2',96,'19840b2bb2f1448facc06ad6c92f7648','snapshot_gigabytes',1,'2025-12-03 10:13:36','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:39.666110',NULL,'2025-12-02 10:13:39.678564',314,314,'b27f974843b944ad89618a9e837b7d08','2dbecff6-1ff1-4630-9177-c3a3d08af44b',98,'1d8a048450454feda5d5f8e5791593b2','shares',-1,'2025-12-03 10:13:39',NULL),('2025-12-02 10:13:39.666718',NULL,'2025-12-02 10:13:39.678564',315,315,'b27f974843b944ad89618a9e837b7d08','ddf09e4a-7976-4ebe-88aa-eae29b8f334b',99,'1d8a048450454feda5d5f8e5791593b2','gigabytes',-1,'2025-12-03 10:13:39',NULL),('2025-12-02 10:13:39.672104',NULL,'2025-12-02 10:13:39.678564',316,316,NULL,'ecc34f1d-8951-48cb-9bfa-4dc8a13d8160',107,'1d8a048450454feda5d5f8e5791593b2','shares',-1,'2025-12-03 10:13:39','d25d2ab8-3188-40e8-af40-2b39819c2e82'),('2025-12-02 10:13:39.672752',NULL,'2025-12-02 10:13:39.678564',317,317,NULL,'067ca440-51b2-4562-b025-4d80fc28084a',106,'1d8a048450454feda5d5f8e5791593b2','gigabytes',-1,'2025-12-03 10:13:39','d25d2ab8-3188-40e8-af40-2b39819c2e82'),('2025-12-02 10:13:39.882184',NULL,'2025-12-02 10:13:39.902997',318,318,'b27f974843b944ad89618a9e837b7d08','cf39e351-72ca-45af-a3c5-c9387b837e2c',98,'1d8a048450454feda5d5f8e5791593b2','shares',-1,'2025-12-03 10:13:39',NULL),('2025-12-02 10:13:39.883113',NULL,'2025-12-02 10:13:39.902997',319,319,'b27f974843b944ad89618a9e837b7d08','97ba2c93-dd38-4d4e-9855-c367117b3f7d',99,'1d8a048450454feda5d5f8e5791593b2','gigabytes',-1,'2025-12-03 10:13:39',NULL),('2025-12-02 10:13:39.888932',NULL,'2025-12-02 10:13:39.902997',320,320,NULL,'5d94f99b-4beb-4a3b-af45-596a6caa1703',105,'1d8a048450454feda5d5f8e5791593b2','shares',-1,'2025-12-03 10:13:39','0eebaea2-ff0c-4c78-a7aa-627703af02da'),('2025-12-02 10:13:39.889863',NULL,'2025-12-02 10:13:39.902997',321,321,NULL,'7a14dc0a-9c83-4baf-8ac8-01feee4c8a0c',104,'1d8a048450454feda5d5f8e5791593b2','gigabytes',-1,'2025-12-03 10:13:39','0eebaea2-ff0c-4c78-a7aa-627703af02da'),('2025-12-02 10:13:40.011427',NULL,'2025-12-02 10:13:40.062581',322,322,'b27f974843b944ad89618a9e837b7d08','e90c1d85-3926-484f-8368-98e0bfd5f592',98,'1d8a048450454feda5d5f8e5791593b2','shares',1,'2025-12-03 10:13:39',NULL),('2025-12-02 10:13:40.013211',NULL,'2025-12-02 10:13:40.062581',323,323,'b27f974843b944ad89618a9e837b7d08','dc69292c-df04-4b2a-9c67-cc6510975dd1',99,'1d8a048450454feda5d5f8e5791593b2','gigabytes',1,'2025-12-03 10:13:39',NULL),('2025-12-02 10:13:40.027574',NULL,'2025-12-02 10:13:40.062581',324,324,NULL,'5a19168c-0b33-4c6f-a113-4a98e5c88a0d',108,'1d8a048450454feda5d5f8e5791593b2','shares',1,'2025-12-03 10:13:39','169f89af-92d9-45d8-a6ff-2b057292ec5d'),('2025-12-02 10:13:40.029011',NULL,'2025-12-02 10:13:40.062581',325,325,NULL,'94200044-df98-4331-8dbc-0557b5338ed7',109,'1d8a048450454feda5d5f8e5791593b2','gigabytes',1,'2025-12-03 10:13:39','169f89af-92d9-45d8-a6ff-2b057292ec5d'),('2025-12-02 10:13:40.495519',NULL,'2025-12-02 10:13:40.519618',326,326,'e6083d93e35641799d5c5fac36ec5423','78b94242-b840-4e09-8ecc-94cbab971f61',95,'19840b2bb2f1448facc06ad6c92f7648','snapshots',-1,'2025-12-03 10:13:40',NULL),('2025-12-02 10:13:40.496471',NULL,'2025-12-02 10:13:40.519618',327,327,'e6083d93e35641799d5c5fac36ec5423','739a50d6-b716-4c1b-9476-ca2801784e5d',94,'19840b2bb2f1448facc06ad6c92f7648','snapshot_gigabytes',-1,'2025-12-03 10:13:40',NULL),('2025-12-02 10:13:40.510296',NULL,'2025-12-02 10:13:40.519618',328,328,NULL,'614f5b45-19b2-49f6-91de-978c4eaa826e',97,'19840b2bb2f1448facc06ad6c92f7648','snapshots',-1,'2025-12-03 10:13:40','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:40.511049',NULL,'2025-12-02 10:13:40.519618',329,329,NULL,'f3d10ed1-e4dc-441e-8dbb-9161287736ad',96,'19840b2bb2f1448facc06ad6c92f7648','snapshot_gigabytes',-1,'2025-12-03 10:13:40','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:43.301994',NULL,'2025-12-02 10:13:43.353015',330,330,'b27f974843b944ad89618a9e837b7d08','11a7fa4e-67b8-40bb-9219-435a3fd1e1a3',98,'1d8a048450454feda5d5f8e5791593b2','shares',1,'2025-12-03 10:13:43',NULL),('2025-12-02 10:13:43.303255',NULL,'2025-12-02 10:13:43.353015',331,331,'b27f974843b944ad89618a9e837b7d08','43471073-c8b7-47f2-9fde-e62a53abc25b',99,'1d8a048450454feda5d5f8e5791593b2','gigabytes',1,'2025-12-03 10:13:43',NULL),('2025-12-02 10:13:43.324095',NULL,'2025-12-02 10:13:43.353015',332,332,NULL,'f5171215-7cf4-4741-a01f-f2e372fef4de',110,'1d8a048450454feda5d5f8e5791593b2','shares',1,'2025-12-03 10:13:43','5c9821fc-8249-4669-8076-47f553817f41'),('2025-12-02 10:13:43.325688',NULL,'2025-12-02 10:13:43.353015',333,333,NULL,'cd9be656-4ceb-40c0-861e-10c03252a9e6',111,'1d8a048450454feda5d5f8e5791593b2','gigabytes',1,'2025-12-03 10:13:43','5c9821fc-8249-4669-8076-47f553817f41'),('2025-12-02 10:13:43.685461',NULL,'2025-12-02 10:13:43.709972',334,334,'e6083d93e35641799d5c5fac36ec5423','801ae637-040a-4276-a57a-8b9542b5c02b',95,'19840b2bb2f1448facc06ad6c92f7648','snapshots',-1,'2025-12-03 10:13:43',NULL),('2025-12-02 10:13:43.686485',NULL,'2025-12-02 10:13:43.709972',335,335,'e6083d93e35641799d5c5fac36ec5423','60141dd6-6f9a-49bb-ae4a-c0654d04461e',94,'19840b2bb2f1448facc06ad6c92f7648','snapshot_gigabytes',-1,'2025-12-03 10:13:43',NULL),('2025-12-02 10:13:43.701169',NULL,'2025-12-02 10:13:43.709972',336,336,NULL,'ceb6624f-2d69-4e54-afa4-102ec1eb0f78',97,'19840b2bb2f1448facc06ad6c92f7648','snapshots',-1,'2025-12-03 10:13:43','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:43.702111',NULL,'2025-12-02 10:13:43.709972',337,337,NULL,'05a8a068-14ba-4b63-bca5-f5a97eeea53a',96,'19840b2bb2f1448facc06ad6c92f7648','snapshot_gigabytes',-1,'2025-12-03 10:13:43','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:45.275315',NULL,'2025-12-02 10:13:45.363688',338,338,'1b4a891633ec4d619106657cfbf2d339','a4ea0690-2c85-4bc7-b2c4-dbef060794f2',112,'e8295af6a4df4c97a379f21f43a2e9aa','shares',1,'2025-12-03 10:13:45',NULL),('2025-12-02 10:13:45.278007',NULL,'2025-12-02 10:13:45.363688',339,339,'1b4a891633ec4d619106657cfbf2d339','b4c6366a-2ae9-45a5-a63d-aa0df29583ef',113,'e8295af6a4df4c97a379f21f43a2e9aa','gigabytes',1,'2025-12-03 10:13:45',NULL),('2025-12-02 10:13:45.324278',NULL,'2025-12-02 10:13:45.363688',340,340,NULL,'0f4ed2c5-ac23-4250-a0dc-56060e8fb1e2',114,'e8295af6a4df4c97a379f21f43a2e9aa','shares',1,'2025-12-03 10:13:45','a807fa7c-8899-4290-bdc5-ce3fd1558599'),('2025-12-02 10:13:45.327631',NULL,'2025-12-02 10:13:45.363688',341,341,NULL,'e986cd81-8861-4bd2-b424-c1def7587fba',115,'e8295af6a4df4c97a379f21f43a2e9aa','gigabytes',1,'2025-12-03 10:13:45','a807fa7c-8899-4290-bdc5-ce3fd1558599'),('2025-12-02 10:13:46.602691',NULL,'2025-12-02 10:13:46.654027',342,342,'b27f974843b944ad89618a9e837b7d08','436a8f51-b7fb-4b4a-ac4b-5d17ee75bd2f',98,'1d8a048450454feda5d5f8e5791593b2','shares',1,'2025-12-03 10:13:46',NULL),('2025-12-02 10:13:46.604059',NULL,'2025-12-02 10:13:46.654027',343,343,'b27f974843b944ad89618a9e837b7d08','b86ecf86-eb5e-480f-949f-df1636830716',99,'1d8a048450454feda5d5f8e5791593b2','gigabytes',1,'2025-12-03 10:13:46',NULL),('2025-12-02 10:13:46.616617',NULL,'2025-12-02 10:13:46.654027',344,344,NULL,'148d6fb5-ebf6-4bac-97d2-c6445ad4af38',117,'1d8a048450454feda5d5f8e5791593b2','shares',1,'2025-12-03 10:13:46','62285f73-1306-4f80-ada0-224e9e052cb7'),('2025-12-02 10:13:46.617765',NULL,'2025-12-02 10:13:46.654027',345,345,NULL,'89d1a9fd-3d49-4f7a-8fde-bd38051be693',116,'1d8a048450454feda5d5f8e5791593b2','gigabytes',1,'2025-12-03 10:13:46','62285f73-1306-4f80-ada0-224e9e052cb7'),('2025-12-02 10:13:46.920925',NULL,'2025-12-02 10:13:46.940923',346,346,'e6083d93e35641799d5c5fac36ec5423','ea12f2b0-6a74-497e-8d18-f9febce72490',95,'19840b2bb2f1448facc06ad6c92f7648','snapshots',-1,'2025-12-03 10:13:46',NULL),('2025-12-02 10:13:46.921951',NULL,'2025-12-02 10:13:46.940923',347,347,'e6083d93e35641799d5c5fac36ec5423','fb47a74f-f765-4bf1-8084-ab69cca7d431',94,'19840b2bb2f1448facc06ad6c92f7648','snapshot_gigabytes',-1,'2025-12-03 10:13:46',NULL),('2025-12-02 10:13:46.929671',NULL,'2025-12-02 10:13:46.940923',348,348,NULL,'f832de97-1e1c-406f-90f3-89be678690e5',97,'19840b2bb2f1448facc06ad6c92f7648','snapshots',-1,'2025-12-03 10:13:46','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:46.930747',NULL,'2025-12-02 10:13:46.940923',349,349,NULL,'272f1814-c5ff-4f4a-a435-7492eeff6828',96,'19840b2bb2f1448facc06ad6c92f7648','snapshot_gigabytes',-1,'2025-12-03 10:13:46','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:48.866907',NULL,'2025-12-02 10:13:48.888109',350,350,'1b4a891633ec4d619106657cfbf2d339','da4ccea7-caeb-4065-9335-ebf69f1a2191',112,'e8295af6a4df4c97a379f21f43a2e9aa','shares',-1,'2025-12-03 10:13:48',NULL),('2025-12-02 10:13:48.867608',NULL,'2025-12-02 10:13:48.888109',351,351,'1b4a891633ec4d619106657cfbf2d339','9ce8d95d-94d7-4c77-893a-63975ffc5b39',113,'e8295af6a4df4c97a379f21f43a2e9aa','gigabytes',-1,'2025-12-03 10:13:48',NULL),('2025-12-02 10:13:48.873722',NULL,'2025-12-02 10:13:48.888109',352,352,NULL,'4afbf474-c9f5-4334-8463-125a5d0a190a',114,'e8295af6a4df4c97a379f21f43a2e9aa','shares',-1,'2025-12-03 10:13:48','a807fa7c-8899-4290-bdc5-ce3fd1558599'),('2025-12-02 10:13:48.874780',NULL,'2025-12-02 10:13:48.888109',353,353,NULL,'ac15e2f1-7c33-4374-86e6-e3cf1b8f3228',115,'e8295af6a4df4c97a379f21f43a2e9aa','gigabytes',-1,'2025-12-03 10:13:48','a807fa7c-8899-4290-bdc5-ce3fd1558599'),('2025-12-02 10:13:48.971938',NULL,'2025-12-02 10:13:49.011031',354,354,'1b4a891633ec4d619106657cfbf2d339','25631105-cfe4-48eb-9d06-e36c4b49e9bb',112,'e8295af6a4df4c97a379f21f43a2e9aa','shares',1,'2025-12-03 10:13:48',NULL),('2025-12-02 10:13:48.973465',NULL,'2025-12-02 10:13:49.011031',355,355,'1b4a891633ec4d619106657cfbf2d339','69e38aac-f7b2-4ae9-a292-762f646c5760',113,'e8295af6a4df4c97a379f21f43a2e9aa','gigabytes',1,'2025-12-03 10:13:48',NULL),('2025-12-02 10:13:48.989288',NULL,'2025-12-02 10:13:49.011031',356,356,NULL,'a51b8aef-b22f-485a-a111-606e69be5fbd',118,'e8295af6a4df4c97a379f21f43a2e9aa','shares',1,'2025-12-03 10:13:48','ed0e827f-6d45-45e1-93e3-29b4b6d5f037'),('2025-12-02 10:13:48.990510',NULL,'2025-12-02 10:13:49.011031',357,357,NULL,'b9e9fa2c-8980-4445-83d6-bfaaa77e5245',119,'e8295af6a4df4c97a379f21f43a2e9aa','gigabytes',1,'2025-12-03 10:13:48','ed0e827f-6d45-45e1-93e3-29b4b6d5f037'),('2025-12-02 10:13:50.028891',NULL,'2025-12-02 10:13:50.900549',358,358,'b27f974843b944ad89618a9e837b7d08','1e859381-e76b-423e-a2e6-6f6f4c2104fd',98,'1d8a048450454feda5d5f8e5791593b2','shares',-1,'2025-12-03 10:13:50',NULL),('2025-12-02 10:13:50.029646',NULL,'2025-12-02 10:13:50.900549',359,359,'b27f974843b944ad89618a9e837b7d08','22858815-2653-4d1d-8e01-4c59dcd726ca',99,'1d8a048450454feda5d5f8e5791593b2','gigabytes',-1,'2025-12-03 10:13:50',NULL),('2025-12-02 10:13:50.871916',NULL,'2025-12-02 10:13:50.900549',360,360,NULL,'e3b1380b-168d-429c-a738-bebe73eefa12',117,'1d8a048450454feda5d5f8e5791593b2','shares',-1,'2025-12-03 10:13:50','62285f73-1306-4f80-ada0-224e9e052cb7'),('2025-12-02 10:13:50.873571',NULL,'2025-12-02 10:13:50.900549',361,361,NULL,'e5e235f9-e9f5-4ff1-b2ac-eeee6be1ea21',116,'1d8a048450454feda5d5f8e5791593b2','gigabytes',-1,'2025-12-03 10:13:50','62285f73-1306-4f80-ada0-224e9e052cb7'),('2025-12-02 10:13:51.130151',NULL,'2025-12-02 10:13:51.197767',362,362,'b27f974843b944ad89618a9e837b7d08','d70dab2d-485c-4a46-9777-b6f0e12ff40b',98,'1d8a048450454feda5d5f8e5791593b2','shares',-1,'2025-12-03 10:13:51',NULL),('2025-12-02 10:13:51.132280',NULL,'2025-12-02 10:13:51.197767',363,363,'b27f974843b944ad89618a9e837b7d08','450168bc-e0f3-4577-ab65-acff116a5eff',99,'1d8a048450454feda5d5f8e5791593b2','gigabytes',-1,'2025-12-03 10:13:51',NULL),('2025-12-02 10:13:51.157283',NULL,'2025-12-02 10:13:51.197767',364,364,NULL,'bf3edcc6-8472-4182-a90d-dd6773189f1c',110,'1d8a048450454feda5d5f8e5791593b2','shares',-1,'2025-12-03 10:13:51','5c9821fc-8249-4669-8076-47f553817f41'),('2025-12-02 10:13:51.158490',NULL,'2025-12-02 10:13:51.197767',365,365,NULL,'498fbee6-8702-419c-a3fb-45db7fb6a37d',111,'1d8a048450454feda5d5f8e5791593b2','gigabytes',-1,'2025-12-03 10:13:51','5c9821fc-8249-4669-8076-47f553817f41'),('2025-12-02 10:13:51.234712',NULL,'2025-12-02 10:13:51.271686',366,366,'e6083d93e35641799d5c5fac36ec5423','fb4a2d7c-6e25-48eb-a2cd-1322c530d02f',95,'19840b2bb2f1448facc06ad6c92f7648','snapshots',-1,'2025-12-03 10:13:51',NULL),('2025-12-02 10:13:51.237620',NULL,'2025-12-02 10:13:51.271686',367,367,'e6083d93e35641799d5c5fac36ec5423','ba498ec2-c43e-4eb2-9944-d51cd5490fa5',94,'19840b2bb2f1448facc06ad6c92f7648','snapshot_gigabytes',-1,'2025-12-03 10:13:51',NULL),('2025-12-02 10:13:51.252291',NULL,'2025-12-02 10:13:51.271686',368,368,NULL,'36583dc6-3ba6-43da-b775-869cfe82cf06',97,'19840b2bb2f1448facc06ad6c92f7648','snapshots',-1,'2025-12-03 10:13:51','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:51.253165',NULL,'2025-12-02 10:13:51.271686',369,369,NULL,'477ac9ab-2d8b-4c0b-9644-4785fbffccc5',96,'19840b2bb2f1448facc06ad6c92f7648','snapshot_gigabytes',-1,'2025-12-03 10:13:51','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:51.440637',NULL,'2025-12-02 10:13:51.465576',370,370,'b27f974843b944ad89618a9e837b7d08','2e70acfc-aa7e-4455-b293-4f5fff21c89c',98,'1d8a048450454feda5d5f8e5791593b2','shares',-1,'2025-12-03 10:13:51',NULL),('2025-12-02 10:13:51.441474',NULL,'2025-12-02 10:13:51.465576',371,371,'b27f974843b944ad89618a9e837b7d08','3834d91e-2656-4f3e-8685-0f4fef818c91',99,'1d8a048450454feda5d5f8e5791593b2','gigabytes',-1,'2025-12-03 10:13:51',NULL),('2025-12-02 10:13:51.453187',NULL,'2025-12-02 10:13:51.465576',372,372,NULL,'9bd78047-442c-40cd-868c-53f69acf2481',108,'1d8a048450454feda5d5f8e5791593b2','shares',-1,'2025-12-03 10:13:51','169f89af-92d9-45d8-a6ff-2b057292ec5d'),('2025-12-02 10:13:51.454008',NULL,'2025-12-02 10:13:51.465576',373,373,NULL,'ce3e9862-269e-48ab-a444-f62f609cb4c3',109,'1d8a048450454feda5d5f8e5791593b2','gigabytes',-1,'2025-12-03 10:13:51','169f89af-92d9-45d8-a6ff-2b057292ec5d'),('2025-12-02 10:13:51.567571',NULL,'2025-12-02 10:13:51.602577',374,374,'b27f974843b944ad89618a9e837b7d08','44be5fc1-01f3-47f8-b37b-9a766380e096',98,'1d8a048450454feda5d5f8e5791593b2','shares',1,'2025-12-03 10:13:51',NULL),('2025-12-02 10:13:51.569714',NULL,'2025-12-02 10:13:51.602577',375,375,'b27f974843b944ad89618a9e837b7d08','3ac68e56-ad7d-44a7-985c-d73bbda94fd2',99,'1d8a048450454feda5d5f8e5791593b2','gigabytes',1,'2025-12-03 10:13:51',NULL),('2025-12-02 10:13:51.580751',NULL,'2025-12-02 10:13:51.602577',376,376,NULL,'7790d283-01a1-4bd0-998d-7b7cdbbd3724',120,'1d8a048450454feda5d5f8e5791593b2','shares',1,'2025-12-03 10:13:51','7e7b46db-703f-4d92-9566-94b272d383d2'),('2025-12-02 10:13:51.582778',NULL,'2025-12-02 10:13:51.602577',377,377,NULL,'b8186ee4-41f9-42e3-9535-f9e9e85c57cc',121,'1d8a048450454feda5d5f8e5791593b2','gigabytes',1,'2025-12-03 10:13:51','7e7b46db-703f-4d92-9566-94b272d383d2'),('2025-12-02 10:13:52.359870',NULL,'2025-12-02 10:13:52.376032',378,378,'1b4a891633ec4d619106657cfbf2d339','50514e10-999d-4fc3-b818-f9f010536143',112,'e8295af6a4df4c97a379f21f43a2e9aa','shares',-1,'2025-12-03 10:13:52',NULL),('2025-12-02 10:13:52.360529',NULL,'2025-12-02 10:13:52.376032',379,379,'1b4a891633ec4d619106657cfbf2d339','7d93e539-1438-4ca1-8925-f830805aad31',113,'e8295af6a4df4c97a379f21f43a2e9aa','gigabytes',-1,'2025-12-03 10:13:52',NULL),('2025-12-02 10:13:52.366622',NULL,'2025-12-02 10:13:52.376032',380,380,NULL,'8cef7267-16ff-410b-80db-3fe1b31c30bf',118,'e8295af6a4df4c97a379f21f43a2e9aa','shares',-1,'2025-12-03 10:13:52','ed0e827f-6d45-45e1-93e3-29b4b6d5f037'),('2025-12-02 10:13:52.367318',NULL,'2025-12-02 10:13:52.376032',381,381,NULL,'cce65340-cf44-4128-97bc-9588978193da',119,'e8295af6a4df4c97a379f21f43a2e9aa','gigabytes',-1,'2025-12-03 10:13:52','ed0e827f-6d45-45e1-93e3-29b4b6d5f037'),('2025-12-02 10:13:52.452876',NULL,'2025-12-02 10:13:52.489595',382,382,'1b4a891633ec4d619106657cfbf2d339','58cc94a3-c575-4bb3-80bd-c9f75644398c',112,'e8295af6a4df4c97a379f21f43a2e9aa','shares',1,'2025-12-03 10:13:52',NULL),('2025-12-02 10:13:52.454004',NULL,'2025-12-02 10:13:52.489595',383,383,'1b4a891633ec4d619106657cfbf2d339','da383b8e-1fc3-4bc4-a2c3-4445646c1d34',113,'e8295af6a4df4c97a379f21f43a2e9aa','gigabytes',1,'2025-12-03 10:13:52',NULL),('2025-12-02 10:13:52.466979',NULL,'2025-12-02 10:13:52.489595',384,384,NULL,'6b86ba35-e940-47f0-a90e-3b37519aabaf',122,'e8295af6a4df4c97a379f21f43a2e9aa','shares',1,'2025-12-03 10:13:52','2b32e3ab-93e6-44c0-a768-7050b468c86b'),('2025-12-02 10:13:52.468656',NULL,'2025-12-02 10:13:52.489595',385,385,NULL,'169f849a-2dd4-4ba8-9bc4-e9a557d49b49',123,'e8295af6a4df4c97a379f21f43a2e9aa','gigabytes',1,'2025-12-03 10:13:52','2b32e3ab-93e6-44c0-a768-7050b468c86b'),('2025-12-02 10:13:54.366115',NULL,'2025-12-02 10:13:54.388402',386,386,'e6083d93e35641799d5c5fac36ec5423','af1ce7a3-0662-4e55-81bf-8f05774632e9',95,'19840b2bb2f1448facc06ad6c92f7648','snapshots',-1,'2025-12-03 10:13:54',NULL),('2025-12-02 10:13:54.367051',NULL,'2025-12-02 10:13:54.388402',387,387,'e6083d93e35641799d5c5fac36ec5423','285dff5a-7974-482a-b276-5f84c6b709ae',94,'19840b2bb2f1448facc06ad6c92f7648','snapshot_gigabytes',-1,'2025-12-03 10:13:54',NULL),('2025-12-02 10:13:54.375484',NULL,'2025-12-02 10:13:54.388402',388,388,NULL,'7b26f1e0-7864-409e-a94d-ef7413b9418c',97,'19840b2bb2f1448facc06ad6c92f7648','snapshots',-1,'2025-12-03 10:13:54','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:54.376482',NULL,'2025-12-02 10:13:54.388402',389,389,NULL,'bf780398-17d4-40cf-8da6-ada8ebf3b2c5',96,'19840b2bb2f1448facc06ad6c92f7648','snapshot_gigabytes',-1,'2025-12-03 10:13:54','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:54.798908',NULL,'2025-12-02 10:13:54.842016',390,390,'b27f974843b944ad89618a9e837b7d08','9f33437b-e76d-4285-8a32-3016931a077e',98,'1d8a048450454feda5d5f8e5791593b2','shares',1,'2025-12-03 10:13:54',NULL),('2025-12-02 10:13:54.800081',NULL,'2025-12-02 10:13:54.842016',391,391,'b27f974843b944ad89618a9e837b7d08','c1cab84d-e434-4a41-90f4-6981afdfeb68',99,'1d8a048450454feda5d5f8e5791593b2','gigabytes',1,'2025-12-03 10:13:54',NULL),('2025-12-02 10:13:54.810294',NULL,'2025-12-02 10:13:54.842016',392,392,NULL,'b56673c0-b33e-43d0-87ef-ad0236e91a33',124,'1d8a048450454feda5d5f8e5791593b2','shares',1,'2025-12-03 10:13:54','017e711d-ae02-4b81-8c99-e58638a5043c'),('2025-12-02 10:13:54.812462',NULL,'2025-12-02 10:13:54.842016',393,393,NULL,'88a339d4-7db8-4dbe-bb50-495e5b7225fc',125,'1d8a048450454feda5d5f8e5791593b2','gigabytes',1,'2025-12-03 10:13:54','017e711d-ae02-4b81-8c99-e58638a5043c'),('2025-12-02 10:13:55.817785',NULL,'2025-12-02 10:13:56.099394',394,394,'1b4a891633ec4d619106657cfbf2d339','486c92e3-52a5-477f-b145-a3d26a98c347',112,'e8295af6a4df4c97a379f21f43a2e9aa','shares',-1,'2025-12-03 10:13:55',NULL),('2025-12-02 10:13:55.820352',NULL,'2025-12-02 10:13:56.099394',395,395,'1b4a891633ec4d619106657cfbf2d339','8aed4450-f642-4fd6-b74b-0a9c7017e25c',113,'e8295af6a4df4c97a379f21f43a2e9aa','gigabytes',-1,'2025-12-03 10:13:55',NULL),('2025-12-02 10:13:55.883508',NULL,'2025-12-02 10:13:56.099394',396,396,NULL,'47a97581-b6bf-4442-9b15-834dff1533a3',122,'e8295af6a4df4c97a379f21f43a2e9aa','shares',-1,'2025-12-03 10:13:55','2b32e3ab-93e6-44c0-a768-7050b468c86b'),('2025-12-02 10:13:55.884219',NULL,'2025-12-02 10:13:56.099394',397,397,NULL,'734849b0-d309-4ec6-a325-52e286c707fa',123,'e8295af6a4df4c97a379f21f43a2e9aa','gigabytes',-1,'2025-12-03 10:13:55','2b32e3ab-93e6-44c0-a768-7050b468c86b'),('2025-12-02 10:13:56.196317',NULL,'2025-12-02 10:13:56.232601',398,398,'1b4a891633ec4d619106657cfbf2d339','4c21483a-87c8-4ae5-94f7-98ef60df02bb',112,'e8295af6a4df4c97a379f21f43a2e9aa','shares',1,'2025-12-03 10:13:56',NULL),('2025-12-02 10:13:56.197566',NULL,'2025-12-02 10:13:56.232601',399,399,'1b4a891633ec4d619106657cfbf2d339','7fa2322c-163b-4840-83f9-e969da72068c',113,'e8295af6a4df4c97a379f21f43a2e9aa','gigabytes',1,'2025-12-03 10:13:56',NULL),('2025-12-02 10:13:56.214107',NULL,'2025-12-02 10:13:56.232601',400,400,NULL,'d18d396b-2fd8-4b31-a9bd-63713491be69',126,'e8295af6a4df4c97a379f21f43a2e9aa','shares',1,'2025-12-03 10:13:56','1d7eca00-9971-4868-a843-784802455931'),('2025-12-02 10:13:56.215971',NULL,'2025-12-02 10:13:56.232601',401,401,NULL,'adebd413-784b-4da3-af18-f68f38f78e38',127,'e8295af6a4df4c97a379f21f43a2e9aa','gigabytes',1,'2025-12-03 10:13:56','1d7eca00-9971-4868-a843-784802455931'),('2025-12-02 10:13:57.722849',NULL,'2025-12-02 10:13:57.742693',402,402,'e6083d93e35641799d5c5fac36ec5423','3f765780-c4e6-42e0-a354-71541f5ba96a',74,'19840b2bb2f1448facc06ad6c92f7648','shares',-1,'2025-12-03 10:13:57',NULL),('2025-12-02 10:13:57.723817',NULL,'2025-12-02 10:13:57.742693',403,403,'e6083d93e35641799d5c5fac36ec5423','527290e8-44da-467b-90e6-0d2680f80cd9',73,'19840b2bb2f1448facc06ad6c92f7648','gigabytes',-1,'2025-12-03 10:13:57',NULL),('2025-12-02 10:13:57.730530',NULL,'2025-12-02 10:13:57.742693',404,404,NULL,'95139ae1-4188-4f5d-bf6f-c145745d7dbe',76,'19840b2bb2f1448facc06ad6c92f7648','shares',-1,'2025-12-03 10:13:57','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:57.731524',NULL,'2025-12-02 10:13:57.742693',405,405,NULL,'3ae1089d-353d-440d-a747-bfc92973aa3a',75,'19840b2bb2f1448facc06ad6c92f7648','gigabytes',-1,'2025-12-03 10:13:57','7235b573-cb61-4bc9-93f4-7a44b90d0e5b'),('2025-12-02 10:13:58.241120',NULL,'2025-12-02 10:13:58.263047',406,406,'b27f974843b944ad89618a9e837b7d08','452d8959-0e49-430c-8cc3-98d84b3e21fe',98,'1d8a048450454feda5d5f8e5791593b2','shares',-1,'2025-12-03 10:13:58',NULL),('2025-12-02 10:13:58.241882',NULL,'2025-12-02 10:13:58.263047',407,407,'b27f974843b944ad89618a9e837b7d08','945274c7-32ab-43a4-9fe6-7e82b2cc808b',99,'1d8a048450454feda5d5f8e5791593b2','gigabytes',-1,'2025-12-03 10:13:58',NULL),('2025-12-02 10:13:58.251568',NULL,'2025-12-02 10:13:58.263047',408,408,NULL,'5d9e07a8-0dd8-45f4-907c-c4760451b15f',124,'1d8a048450454feda5d5f8e5791593b2','shares',-1,'2025-12-03 10:13:58','017e711d-ae02-4b81-8c99-e58638a5043c'),('2025-12-02 10:13:58.252489',NULL,'2025-12-02 10:13:58.263047',409,409,NULL,'0670d2cf-7a50-4bf5-bd88-5fab0c999874',125,'1d8a048450454feda5d5f8e5791593b2','gigabytes',-1,'2025-12-03 10:13:58','017e711d-ae02-4b81-8c99-e58638a5043c'),('2025-12-02 10:13:58.442468',NULL,'2025-12-02 10:13:58.457753',410,410,'b27f974843b944ad89618a9e837b7d08','220b021e-272c-4b5e-bf3f-cb3ea2a66612',98,'1d8a048450454feda5d5f8e5791593b2','shares',-1,'2025-12-03 10:13:58',NULL),('2025-12-02 10:13:58.443195',NULL,'2025-12-02 10:13:58.457753',411,411,'b27f974843b944ad89618a9e837b7d08','755343fe-540b-489f-971a-c8fa07f7d036',99,'1d8a048450454feda5d5f8e5791593b2','gigabytes',-1,'2025-12-03 10:13:58',NULL),('2025-12-02 10:13:58.447531',NULL,'2025-12-02 10:13:58.457753',412,412,NULL,'de89141a-2713-4264-891e-e94f8d395532',120,'1d8a048450454feda5d5f8e5791593b2','shares',-1,'2025-12-03 10:13:58','7e7b46db-703f-4d92-9566-94b272d383d2'),('2025-12-02 10:13:58.448471',NULL,'2025-12-02 10:13:58.457753',413,413,NULL,'eb909587-7a38-4e2d-ba98-6ab92079afca',121,'1d8a048450454feda5d5f8e5791593b2','gigabytes',-1,'2025-12-03 10:13:58','7e7b46db-703f-4d92-9566-94b272d383d2'),('2025-12-02 10:13:58.569532',NULL,'2025-12-02 10:13:58.620638',414,414,'b27f974843b944ad89618a9e837b7d08','be893e6c-7a70-4935-8610-0ca1efdc065a',98,'1d8a048450454feda5d5f8e5791593b2','shares',1,'2025-12-03 10:13:58',NULL),('2025-12-02 10:13:58.571925',NULL,'2025-12-02 10:13:58.620638',415,415,'b27f974843b944ad89618a9e837b7d08','61c2732b-39ce-47a8-b4d4-a9a7a09e2dd2',99,'1d8a048450454feda5d5f8e5791593b2','gigabytes',1,'2025-12-03 10:13:58',NULL),('2025-12-02 10:13:58.594155',NULL,'2025-12-02 10:13:58.620638',416,416,NULL,'1f97f2ab-8a86-4917-a1e9-a31598ffc4f7',128,'1d8a048450454feda5d5f8e5791593b2','shares',1,'2025-12-03 10:13:58','18e71d95-b3f1-4c37-b1dc-da71dd921cde'),('2025-12-02 10:13:58.595633',NULL,'2025-12-02 10:13:58.620638',417,417,NULL,'39e4aebb-b0dd-4d8f-9298-7f71ef78c3df',129,'1d8a048450454feda5d5f8e5791593b2','gigabytes',1,'2025-12-03 10:13:58','18e71d95-b3f1-4c37-b1dc-da71dd921cde'),('2025-12-02 10:13:59.536113',NULL,'2025-12-02 10:13:59.549026',418,418,'1b4a891633ec4d619106657cfbf2d339','67dadc2d-1e67-40c1-aa25-845f1910fb70',112,'e8295af6a4df4c97a379f21f43a2e9aa','shares',-1,'2025-12-03 10:13:59',NULL),('2025-12-02 10:13:59.536908',NULL,'2025-12-02 10:13:59.549026',419,419,'1b4a891633ec4d619106657cfbf2d339','bec97a83-fa9b-4492-abe1-ec12d42c33cc',113,'e8295af6a4df4c97a379f21f43a2e9aa','gigabytes',-1,'2025-12-03 10:13:59',NULL),('2025-12-02 10:13:59.542207',NULL,'2025-12-02 10:13:59.549026',420,420,NULL,'a3597963-177b-417f-bcd4-8a5a4f2d7cc8',126,'e8295af6a4df4c97a379f21f43a2e9aa','shares',-1,'2025-12-03 10:13:59','1d7eca00-9971-4868-a843-784802455931'),('2025-12-02 10:13:59.542943',NULL,'2025-12-02 10:13:59.549026',421,421,NULL,'a7955fa1-883e-4b6b-b38e-fe2c9d5eee05',127,'e8295af6a4df4c97a379f21f43a2e9aa','gigabytes',-1,'2025-12-03 10:13:59','1d7eca00-9971-4868-a843-784802455931'),('2025-12-02 10:13:59.634440',NULL,'2025-12-02 10:13:59.667495',422,422,'1b4a891633ec4d619106657cfbf2d339','b69f60b5-2e95-488b-9afe-da4220e98f23',112,'e8295af6a4df4c97a379f21f43a2e9aa','shares',1,'2025-12-03 10:13:59',NULL),('2025-12-02 10:13:59.635630',NULL,'2025-12-02 10:13:59.667495',423,423,'1b4a891633ec4d619106657cfbf2d339','bc86a587-4d3f-4173-a1c3-d1082c1c5068',113,'e8295af6a4df4c97a379f21f43a2e9aa','gigabytes',1,'2025-12-03 10:13:59',NULL),('2025-12-02 10:13:59.644793',NULL,'2025-12-02 10:13:59.667495',424,424,NULL,'f447dede-2804-4581-8234-bb74570a091b',130,'e8295af6a4df4c97a379f21f43a2e9aa','shares',1,'2025-12-03 10:13:59','ad48deb0-4c66-465e-aa4f-dd43e27fecc0'),('2025-12-02 10:13:59.645938',NULL,'2025-12-02 10:13:59.667495',425,425,NULL,'5bdd989c-2da8-45f1-b36e-01accf7cdab3',131,'e8295af6a4df4c97a379f21f43a2e9aa','gigabytes',1,'2025-12-03 10:13:59','ad48deb0-4c66-465e-aa4f-dd43e27fecc0'),('2025-12-02 10:14:01.998577',NULL,'2025-12-02 10:14:02.027640',426,426,'b27f974843b944ad89618a9e837b7d08','6e49cb5b-d64e-4739-91a3-5ffb92c8f2b9',98,'1d8a048450454feda5d5f8e5791593b2','shares',-1,'2025-12-03 10:14:01',NULL),('2025-12-02 10:14:02.000164',NULL,'2025-12-02 10:14:02.027640',427,427,'b27f974843b944ad89618a9e837b7d08','176ef924-fbd9-4e24-a58e-2347b231989e',99,'1d8a048450454feda5d5f8e5791593b2','gigabytes',-1,'2025-12-03 10:14:01',NULL),('2025-12-02 10:14:02.015432',NULL,'2025-12-02 10:14:02.027640',428,428,NULL,'97b785f5-3da1-4b02-9034-b74013b0a1e9',128,'1d8a048450454feda5d5f8e5791593b2','shares',-1,'2025-12-03 10:14:01','18e71d95-b3f1-4c37-b1dc-da71dd921cde'),('2025-12-02 10:14:02.017099',NULL,'2025-12-02 10:14:02.027640',429,429,NULL,'186eb3c0-ba7d-4f7a-a36a-feeb63fafb51',129,'1d8a048450454feda5d5f8e5791593b2','gigabytes',-1,'2025-12-03 10:14:01','18e71d95-b3f1-4c37-b1dc-da71dd921cde'),('2025-12-02 10:14:03.306777',NULL,'2025-12-02 10:14:03.326569',430,430,'1b4a891633ec4d619106657cfbf2d339','cf09c3e7-a394-4dab-952a-ac18bcb8e53f',112,'e8295af6a4df4c97a379f21f43a2e9aa','shares',-1,'2025-12-03 10:14:03',NULL),('2025-12-02 10:14:03.307608',NULL,'2025-12-02 10:14:03.326569',431,431,'1b4a891633ec4d619106657cfbf2d339','e7699749-9a53-4373-b094-2416ff9931e0',113,'e8295af6a4df4c97a379f21f43a2e9aa','gigabytes',-1,'2025-12-03 10:14:03',NULL),('2025-12-02 10:14:03.315642',NULL,'2025-12-02 10:14:03.326569',432,432,NULL,'c140478e-659b-49fc-b4a0-eaddcd0425d4',130,'e8295af6a4df4c97a379f21f43a2e9aa','shares',-1,'2025-12-03 10:14:03','ad48deb0-4c66-465e-aa4f-dd43e27fecc0'),('2025-12-02 10:14:03.317615',NULL,'2025-12-02 10:14:03.326569',433,433,NULL,'a7198d19-1716-4c5b-8ba1-70c685e06cc9',131,'e8295af6a4df4c97a379f21f43a2e9aa','gigabytes',-1,'2025-12-03 10:14:03','ad48deb0-4c66-465e-aa4f-dd43e27fecc0'),('2025-12-02 10:14:12.863561',NULL,'2025-12-02 10:14:12.913113',434,434,'dbaeaeed65b44f5f85d2e43c20bd916e','584e9143-daad-4a91-9e91-a6ea836482ce',132,'5974c1b38c02486098e277d58b491dac','shares',1,'2025-12-03 10:14:12',NULL),('2025-12-02 10:14:12.864698',NULL,'2025-12-02 10:14:12.913113',435,435,'dbaeaeed65b44f5f85d2e43c20bd916e','fe83ab98-3e07-4367-8857-df61d23a7585',133,'5974c1b38c02486098e277d58b491dac','gigabytes',1,'2025-12-03 10:14:12',NULL),('2025-12-02 10:14:12.879337',NULL,'2025-12-02 10:14:12.913113',436,436,NULL,'654bad90-b6a3-4de4-aec0-b53f4622e3d4',134,'5974c1b38c02486098e277d58b491dac','shares',1,'2025-12-03 10:14:12','ffbcd882-a642-42d8-a748-2f0d2086d753'),('2025-12-02 10:14:12.880993',NULL,'2025-12-02 10:14:12.913113',437,437,NULL,'1299ac00-8f01-443c-8b45-7048a49578ff',135,'5974c1b38c02486098e277d58b491dac','gigabytes',1,'2025-12-03 10:14:12','ffbcd882-a642-42d8-a748-2f0d2086d753'),('2025-12-02 10:14:13.113879',NULL,'2025-12-02 10:14:13.179267',438,438,'2bab38cd1afa4f1cb56ae5e3471916e7','629234f1-17b5-4fab-a04e-ffada16a5302',136,'914633b51dfe4f69869861586a905b4f','shares',1,'2025-12-03 10:14:13',NULL),('2025-12-02 10:14:13.115312',NULL,'2025-12-02 10:14:13.179267',439,439,'2bab38cd1afa4f1cb56ae5e3471916e7','3aff402e-e480-4030-96bf-3ca21228ebbd',137,'914633b51dfe4f69869861586a905b4f','gigabytes',1,'2025-12-03 10:14:13',NULL),('2025-12-02 10:14:13.137009',NULL,'2025-12-02 10:14:13.179267',440,440,NULL,'9ebd3304-5a14-4613-b4b5-13b4b8b0228c',138,'914633b51dfe4f69869861586a905b4f','shares',1,'2025-12-03 10:14:13','40450f64-4e41-484c-9658-544335bdf9c8'),('2025-12-02 10:14:13.139835',NULL,'2025-12-02 10:14:13.179267',441,441,NULL,'90490590-6dd1-4c25-a61c-cb6b4b3c2815',139,'914633b51dfe4f69869861586a905b4f','gigabytes',1,'2025-12-03 10:14:13','40450f64-4e41-484c-9658-544335bdf9c8'),('2025-12-02 10:14:16.664478',NULL,'2025-12-02 10:14:16.696923',442,442,'f2cff7ece9574fa997525a5363ecba58','2b4d5765-eb00-46fd-8096-de0af004e4f6',140,'87cdd4c8f591435eb43e3200734202e3','shares',1,'2025-12-03 10:14:16',NULL),('2025-12-02 10:14:16.665875',NULL,'2025-12-02 10:14:16.696923',443,443,'f2cff7ece9574fa997525a5363ecba58','745f4e2e-cad1-4c01-b5cf-c783e3b11a04',141,'87cdd4c8f591435eb43e3200734202e3','gigabytes',1,'2025-12-03 10:14:16',NULL),('2025-12-02 10:14:16.675955',NULL,'2025-12-02 10:14:16.696923',444,444,NULL,'11bda339-5904-4ab0-89c3-f427c5b0afb0',142,'87cdd4c8f591435eb43e3200734202e3','shares',1,'2025-12-03 10:14:16','40450f64-4e41-484c-9658-544335bdf9c8'),('2025-12-02 10:14:16.677124',NULL,'2025-12-02 10:14:16.696923',445,445,NULL,'2a71ffb0-ed0b-40f3-9261-715c2b075939',143,'87cdd4c8f591435eb43e3200734202e3','gigabytes',1,'2025-12-03 10:14:16','40450f64-4e41-484c-9658-544335bdf9c8'),('2025-12-02 10:14:17.544376',NULL,'2025-12-02 10:14:17.558163',446,446,'dbaeaeed65b44f5f85d2e43c20bd916e','9112897e-e528-421d-8715-22e9a6550238',132,'5974c1b38c02486098e277d58b491dac','shares',-1,'2025-12-03 10:14:17',NULL),('2025-12-02 10:14:17.545073',NULL,'2025-12-02 10:14:17.558163',447,447,'dbaeaeed65b44f5f85d2e43c20bd916e','bd7a19fb-633d-410a-98b4-a189cd9a9777',133,'5974c1b38c02486098e277d58b491dac','gigabytes',-1,'2025-12-03 10:14:17',NULL),('2025-12-02 10:14:17.550364',NULL,'2025-12-02 10:14:17.558163',448,448,NULL,'7ba8c4b0-0f48-4358-a834-e63fd11146a2',134,'5974c1b38c02486098e277d58b491dac','shares',-1,'2025-12-03 10:14:17','ffbcd882-a642-42d8-a748-2f0d2086d753'),('2025-12-02 10:14:17.550990',NULL,'2025-12-02 10:14:17.558163',449,449,NULL,'90ef9c41-403d-4a5f-a925-8224c84bdc7e',135,'5974c1b38c02486098e277d58b491dac','gigabytes',-1,'2025-12-03 10:14:17','ffbcd882-a642-42d8-a748-2f0d2086d753'),('2025-12-02 10:14:17.565359',NULL,'2025-12-02 10:14:17.603843',450,450,'e3ca56c7989448c2b6be391e31145f68','b3fb5e1a-769a-4d9b-91bd-c202b621c218',144,'680813e2a2a84d78b0da5d342341d9de','shares',1,'2025-12-03 10:14:17',NULL),('2025-12-02 10:14:17.566568',NULL,'2025-12-02 10:14:17.603843',451,451,'e3ca56c7989448c2b6be391e31145f68','bac35e5e-d8fa-4afc-b5bb-f99a3865780c',145,'680813e2a2a84d78b0da5d342341d9de','gigabytes',4,'2025-12-03 10:14:17',NULL),('2025-12-02 10:14:17.581265',NULL,'2025-12-02 10:14:17.603843',452,452,NULL,'3dd34eca-a3ec-4676-aee2-51c226960334',146,'680813e2a2a84d78b0da5d342341d9de','shares',1,'2025-12-03 10:14:17','c5eabd7f-49df-4d97-ac80-6482db3b660b'),('2025-12-02 10:14:17.583295',NULL,'2025-12-02 10:14:17.603843',453,453,NULL,'c09f6597-a5d1-43a5-ab05-7557587f93ea',147,'680813e2a2a84d78b0da5d342341d9de','gigabytes',4,'2025-12-03 10:14:17','c5eabd7f-49df-4d97-ac80-6482db3b660b'),('2025-12-02 10:14:20.355972',NULL,'2025-12-02 10:14:20.376167',454,454,'f2cff7ece9574fa997525a5363ecba58','ed5550fc-ddb6-4e6b-a0e1-c4080394076b',140,'87cdd4c8f591435eb43e3200734202e3','shares',-1,'2025-12-03 10:14:20',NULL),('2025-12-02 10:14:20.358365',NULL,'2025-12-02 10:14:20.376167',455,455,'f2cff7ece9574fa997525a5363ecba58','9818aaf4-a120-4ecf-99de-81314b78f94a',141,'87cdd4c8f591435eb43e3200734202e3','gigabytes',-1,'2025-12-03 10:14:20',NULL),('2025-12-02 10:14:20.366299',NULL,'2025-12-02 10:14:20.376167',456,456,NULL,'1d5ad3f3-2672-4c97-aa37-48e820f02551',142,'87cdd4c8f591435eb43e3200734202e3','shares',-1,'2025-12-03 10:14:20','40450f64-4e41-484c-9658-544335bdf9c8'),('2025-12-02 10:14:20.367188',NULL,'2025-12-02 10:14:20.376167',457,457,NULL,'29b12e95-a43e-4860-9d14-69424c8cae6e',143,'87cdd4c8f591435eb43e3200734202e3','gigabytes',-1,'2025-12-03 10:14:20','40450f64-4e41-484c-9658-544335bdf9c8'),('2025-12-02 10:14:20.811005',NULL,'2025-12-02 10:14:20.824442',458,458,'e3ca56c7989448c2b6be391e31145f68','999a0b0c-2765-4760-90db-7e15b9ceb1fc',144,'680813e2a2a84d78b0da5d342341d9de','shares',1,'2025-12-03 10:14:20',NULL),('2025-12-02 10:14:20.812184',NULL,'2025-12-02 10:14:20.824442',459,459,'e3ca56c7989448c2b6be391e31145f68','4bd773cb-5466-4f14-98b9-0e48fd5cd526',145,'680813e2a2a84d78b0da5d342341d9de','gigabytes',3,'2025-12-03 10:14:20',NULL),('2025-12-02 10:14:20.941365',NULL,'2025-12-02 10:14:20.979678',460,460,'e3ca56c7989448c2b6be391e31145f68','2d60770c-8c93-4719-90cb-77233aa05f92',144,'680813e2a2a84d78b0da5d342341d9de','shares',1,'2025-12-03 10:14:20',NULL),('2025-12-02 10:14:20.942602',NULL,'2025-12-02 10:14:20.979678',461,461,'e3ca56c7989448c2b6be391e31145f68','8dfe6f0d-31ee-4f08-b127-f9b449e40396',145,'680813e2a2a84d78b0da5d342341d9de','gigabytes',3,'2025-12-03 10:14:20',NULL),('2025-12-02 10:14:20.953454',NULL,'2025-12-02 10:14:20.979678',462,462,NULL,'1751ac30-1c5e-4053-99a8-f4783fc79c30',148,'680813e2a2a84d78b0da5d342341d9de','shares',1,'2025-12-03 10:14:20','49fe7987-9e54-4fce-a1b2-017c50dd85f9'),('2025-12-02 10:14:20.955517',NULL,'2025-12-02 10:14:20.979678',463,463,NULL,'484f037c-27bd-4eec-949e-45833b69fead',149,'680813e2a2a84d78b0da5d342341d9de','gigabytes',3,'2025-12-03 10:14:20','49fe7987-9e54-4fce-a1b2-017c50dd85f9'),('2025-12-02 10:14:23.620255',NULL,'2025-12-02 10:14:23.635587',464,464,'2bab38cd1afa4f1cb56ae5e3471916e7','b80e3b67-8582-436d-94df-6c4e0afa0daf',136,'914633b51dfe4f69869861586a905b4f','shares',-1,'2025-12-03 10:14:23',NULL),('2025-12-02 10:14:23.620911',NULL,'2025-12-02 10:14:23.635587',465,465,'2bab38cd1afa4f1cb56ae5e3471916e7','2addba86-7a44-49e3-a222-51ea0fcfcdeb',137,'914633b51dfe4f69869861586a905b4f','gigabytes',-1,'2025-12-03 10:14:23',NULL),('2025-12-02 10:14:23.628933',NULL,'2025-12-02 10:14:23.635587',466,466,NULL,'6e199e5d-1bd7-4b12-a22a-2b7a85537f17',138,'914633b51dfe4f69869861586a905b4f','shares',-1,'2025-12-03 10:14:23','40450f64-4e41-484c-9658-544335bdf9c8'),('2025-12-02 10:14:23.629789',NULL,'2025-12-02 10:14:23.635587',467,467,NULL,'71534337-389f-4ea1-84c4-a10b49e25fd6',139,'914633b51dfe4f69869861586a905b4f','gigabytes',-1,'2025-12-03 10:14:23','40450f64-4e41-484c-9658-544335bdf9c8'),('2025-12-02 10:14:24.611578',NULL,'2025-12-02 10:14:24.628025',468,468,'e3ca56c7989448c2b6be391e31145f68','9aa89b6b-ee56-4ba1-aeab-4ee82d1f3438',144,'680813e2a2a84d78b0da5d342341d9de','shares',-1,'2025-12-03 10:14:24',NULL),('2025-12-02 10:14:24.612279',NULL,'2025-12-02 10:14:24.628025',469,469,'e3ca56c7989448c2b6be391e31145f68','e31a98be-958f-460c-a977-e99524f9646b',145,'680813e2a2a84d78b0da5d342341d9de','gigabytes',-4,'2025-12-03 10:14:24',NULL),('2025-12-02 10:14:24.617786',NULL,'2025-12-02 10:14:24.628025',470,470,NULL,'185ee9c1-2a4f-4286-bdd7-7e7a1158b394',146,'680813e2a2a84d78b0da5d342341d9de','shares',-1,'2025-12-03 10:14:24','c5eabd7f-49df-4d97-ac80-6482db3b660b'),('2025-12-02 10:14:24.618520',NULL,'2025-12-02 10:14:24.628025',471,471,NULL,'263ab1cd-cad7-467b-819a-9e3053b0dd04',147,'680813e2a2a84d78b0da5d342341d9de','gigabytes',-4,'2025-12-03 10:14:24','c5eabd7f-49df-4d97-ac80-6482db3b660b'),('2025-12-02 10:14:26.492476',NULL,'2025-12-02 10:14:26.581506',472,472,'f2cff7ece9574fa997525a5363ecba58','33bb4051-1441-4cdb-ba2a-40b9769845e6',140,'87cdd4c8f591435eb43e3200734202e3','shares',1,'2025-12-03 10:14:26',NULL),('2025-12-02 10:14:26.493839',NULL,'2025-12-02 10:14:26.581506',473,473,'f2cff7ece9574fa997525a5363ecba58','68d00fe5-3670-4ee0-845e-3366ec4da673',141,'87cdd4c8f591435eb43e3200734202e3','gigabytes',1,'2025-12-03 10:14:26',NULL),('2025-12-02 10:14:26.503109',NULL,'2025-12-02 10:14:26.581506',474,474,NULL,'4d604e98-61a2-4fb3-98d6-db9f730c9daf',142,'87cdd4c8f591435eb43e3200734202e3','shares',1,'2025-12-03 10:14:26','40450f64-4e41-484c-9658-544335bdf9c8'),('2025-12-02 10:14:26.504523',NULL,'2025-12-02 10:14:26.581506',475,475,NULL,'e61313e6-97f9-4123-bb9b-b06b690a1148',143,'87cdd4c8f591435eb43e3200734202e3','gigabytes',1,'2025-12-03 10:14:26','40450f64-4e41-484c-9658-544335bdf9c8'),('2025-12-02 10:14:28.082151',NULL,'2025-12-02 10:14:28.104377',476,476,'e3ca56c7989448c2b6be391e31145f68','59c16195-60f8-4c4c-8241-8fa219fa1657',144,'680813e2a2a84d78b0da5d342341d9de','shares',-1,'2025-12-03 10:14:28',NULL),('2025-12-02 10:14:28.084308',NULL,'2025-12-02 10:14:28.104377',477,477,'e3ca56c7989448c2b6be391e31145f68','6b502e87-6bd7-4e08-8263-c1bde2862a98',145,'680813e2a2a84d78b0da5d342341d9de','gigabytes',-3,'2025-12-03 10:14:28',NULL),('2025-12-02 10:14:28.093819',NULL,'2025-12-02 10:14:28.104377',478,478,NULL,'9a2a386b-7a36-4773-97f5-c882786ed5e0',148,'680813e2a2a84d78b0da5d342341d9de','shares',-1,'2025-12-03 10:14:28','49fe7987-9e54-4fce-a1b2-017c50dd85f9'),('2025-12-02 10:14:28.094605',NULL,'2025-12-02 10:14:28.104377',479,479,NULL,'de9192a2-69d7-4139-8927-d5c62679e376',149,'680813e2a2a84d78b0da5d342341d9de','gigabytes',-3,'2025-12-03 10:14:28','49fe7987-9e54-4fce-a1b2-017c50dd85f9'),('2025-12-02 10:14:30.358259',NULL,'2025-12-02 10:14:30.374613',480,480,'f2cff7ece9574fa997525a5363ecba58','f3147d34-3229-4e8c-9457-f05f8dbe97e7',140,'87cdd4c8f591435eb43e3200734202e3','shares',-1,'2025-12-03 10:14:30',NULL),('2025-12-02 10:14:30.359196',NULL,'2025-12-02 10:14:30.374613',481,481,'f2cff7ece9574fa997525a5363ecba58','90bd6095-2699-43ec-922a-6078ceac3af9',141,'87cdd4c8f591435eb43e3200734202e3','gigabytes',-1,'2025-12-03 10:14:30',NULL),('2025-12-02 10:14:30.365881',NULL,'2025-12-02 10:14:30.374613',482,482,NULL,'4d2ed7eb-4f5f-43f5-9b2b-210e3b0e9cd8',142,'87cdd4c8f591435eb43e3200734202e3','shares',-1,'2025-12-03 10:14:30','40450f64-4e41-484c-9658-544335bdf9c8'),('2025-12-02 10:14:30.366613',NULL,'2025-12-02 10:14:30.374613',483,483,NULL,'fabe21ef-64d4-4799-9828-545a432c6f16',143,'87cdd4c8f591435eb43e3200734202e3','gigabytes',-1,'2025-12-03 10:14:30','40450f64-4e41-484c-9658-544335bdf9c8'),('2025-12-02 10:14:36.100393',NULL,'2025-12-02 10:14:36.148685',484,484,'1a03624069ce41fcb02f5e929815f66c','28a678da-779e-46b9-80b5-68ddb0552f20',150,'8f75117f8554499b9fbaa9c9062eeeef','shares',1,'2025-12-03 10:14:36',NULL),('2025-12-02 10:14:36.102126',NULL,'2025-12-02 10:14:36.148685',485,485,'1a03624069ce41fcb02f5e929815f66c','8728e81e-a9aa-417c-bf6f-23b1fa8dc62f',151,'8f75117f8554499b9fbaa9c9062eeeef','gigabytes',1,'2025-12-03 10:14:36',NULL),('2025-12-02 10:14:36.119749',NULL,'2025-12-02 10:14:36.148685',486,486,NULL,'fef223a6-a519-4832-8c0c-91305ec644a8',152,'8f75117f8554499b9fbaa9c9062eeeef','shares',1,'2025-12-03 10:14:36','36dcded1-31d3-40d9-bb47-df8b0de68b92'),('2025-12-02 10:14:36.121145',NULL,'2025-12-02 10:14:36.148685',487,487,NULL,'0c16500f-f79e-444d-839f-c527defe3e96',153,'8f75117f8554499b9fbaa9c9062eeeef','gigabytes',1,'2025-12-03 10:14:36','36dcded1-31d3-40d9-bb47-df8b0de68b92'),('2025-12-02 10:14:38.879331',NULL,'2025-12-02 10:14:38.921793',488,488,'bd7f2d7611734550bbffc82296b63298','5d5d53c5-9ada-4449-89ae-c38c81269751',154,'2f5b0cb9136e40b1a7b70e89b03f2784','share_networks',1,'2025-12-03 10:14:38',NULL),('2025-12-02 10:14:39.051943',NULL,'2025-12-02 10:14:39.056873',489,489,'bd7f2d7611734550bbffc82296b63298','ee99d786-faf6-4928-8944-e45c32bb5e68',154,'2f5b0cb9136e40b1a7b70e89b03f2784','share_networks',-1,'2025-12-03 10:14:39',NULL),('2025-12-02 10:14:39.210771',NULL,'2025-12-02 10:14:39.275586',490,490,'bd7f2d7611734550bbffc82296b63298','3851bc4c-e37c-4937-99eb-86676d9bdc3f',154,'2f5b0cb9136e40b1a7b70e89b03f2784','share_networks',1,'2025-12-03 10:14:39',NULL),('2025-12-02 10:14:39.728742',NULL,'2025-12-02 10:14:39.745215',491,491,'bd7f2d7611734550bbffc82296b63298','def2dc8e-5084-49fd-bc6e-4ed3ba4aef60',154,'2f5b0cb9136e40b1a7b70e89b03f2784','share_networks',-1,'2025-12-03 10:14:39',NULL),('2025-12-02 10:14:39.857983',NULL,'2025-12-02 10:14:40.136427',492,492,'bd7f2d7611734550bbffc82296b63298','6de1be75-8901-4260-a326-14855d727923',154,'2f5b0cb9136e40b1a7b70e89b03f2784','share_networks',1,'2025-12-03 10:14:39',NULL),('2025-12-02 10:14:40.272967',NULL,'2025-12-02 10:14:40.282048',493,493,'bd7f2d7611734550bbffc82296b63298','1e8cac84-6139-4a19-90a0-3bad184b4f28',154,'2f5b0cb9136e40b1a7b70e89b03f2784','share_networks',-1,'2025-12-03 10:14:40',NULL),('2025-12-02 10:14:45.993236',NULL,'2025-12-02 10:14:46.030109',494,494,'8186b016983446bb95a4c7821dfa53bb','7c76058a-eb65-4078-9622-f9e395afc359',156,'18e2a69daf6849dead0b925033d0fbad','shares',1,'2025-12-03 10:14:45',NULL),('2025-12-02 10:14:45.994585',NULL,'2025-12-02 10:14:46.030109',495,495,'8186b016983446bb95a4c7821dfa53bb','932c4efb-0d2a-4e9e-a215-506277a3a075',155,'18e2a69daf6849dead0b925033d0fbad','gigabytes',1,'2025-12-03 10:14:45',NULL),('2025-12-02 10:14:46.007130',NULL,'2025-12-02 10:14:46.030109',496,496,NULL,'d2a509a6-df1a-424c-9fa4-1ca1c6c67335',158,'18e2a69daf6849dead0b925033d0fbad','shares',1,'2025-12-03 10:14:45','9bfec2f4-a1c2-4bb7-b734-09f9d3fd4aa4'),('2025-12-02 10:14:46.008505',NULL,'2025-12-02 10:14:46.030109',497,497,NULL,'1049f0d1-18ff-4535-b49e-cdfae85cb165',157,'18e2a69daf6849dead0b925033d0fbad','gigabytes',1,'2025-12-03 10:14:45','9bfec2f4-a1c2-4bb7-b734-09f9d3fd4aa4'),('2025-12-02 10:14:48.112310',NULL,'2025-12-02 10:14:48.164914',498,498,'404a2149cc4c442e8f29fae023953b63','396f8a16-7a41-4ef8-86f1-815786b46859',159,'6b9f3a4e12754a9ab7a5077a3e0bb303','shares',1,'2025-12-03 10:14:48',NULL),('2025-12-02 10:14:48.114124',NULL,'2025-12-02 10:14:48.164914',499,499,'404a2149cc4c442e8f29fae023953b63','f9d76277-3cc2-45a6-89b2-3584b8e73b2e',160,'6b9f3a4e12754a9ab7a5077a3e0bb303','gigabytes',1,'2025-12-03 10:14:48',NULL),('2025-12-02 10:14:48.125126',NULL,'2025-12-02 10:14:48.164914',500,500,NULL,'72541673-fd06-45c0-817e-04e6117fe719',161,'6b9f3a4e12754a9ab7a5077a3e0bb303','shares',1,'2025-12-03 10:14:48','009a0375-1724-45ed-a672-bbd9ee8c52a1'),('2025-12-02 10:14:48.126328',NULL,'2025-12-02 10:14:48.164914',501,501,NULL,'7870ca27-8754-4a87-98c5-4951e0df822c',162,'6b9f3a4e12754a9ab7a5077a3e0bb303','gigabytes',1,'2025-12-03 10:14:48','009a0375-1724-45ed-a672-bbd9ee8c52a1'),('2025-12-02 10:14:49.271594',NULL,'2025-12-02 10:14:49.367321',502,502,'8186b016983446bb95a4c7821dfa53bb','678e43d7-ffae-4862-bd2f-18aa60e72018',164,'18e2a69daf6849dead0b925033d0fbad','snapshots',1,'2025-12-03 10:14:49',NULL),('2025-12-02 10:14:49.273702',NULL,'2025-12-02 10:14:49.367321',503,503,'8186b016983446bb95a4c7821dfa53bb','eec2badd-2d61-4872-bea3-e626d085796e',163,'18e2a69daf6849dead0b925033d0fbad','snapshot_gigabytes',1,'2025-12-03 10:14:49',NULL),('2025-12-02 10:14:49.287131',NULL,'2025-12-02 10:14:49.367321',504,504,NULL,'c99aa893-3689-4623-ad43-df4e9fd7a697',166,'18e2a69daf6849dead0b925033d0fbad','snapshots',1,'2025-12-03 10:14:49','9bfec2f4-a1c2-4bb7-b734-09f9d3fd4aa4'),('2025-12-02 10:14:49.288518',NULL,'2025-12-02 10:14:49.367321',505,505,NULL,'06475fd8-ed6f-4c2c-bd7f-a48287b572de',165,'18e2a69daf6849dead0b925033d0fbad','snapshot_gigabytes',1,'2025-12-03 10:14:49','9bfec2f4-a1c2-4bb7-b734-09f9d3fd4aa4'),('2025-12-02 10:14:51.830567',NULL,'2025-12-02 10:14:51.885439',506,506,'fb7fbe93d5b34afb91f154a1f8487fed','5cc9f0a2-26cd-4bd4-82df-82acc3ac1137',168,'7e6f29bbe0f44b04ada8cc16426d3961','shares',1,'2025-12-03 10:14:51',NULL),('2025-12-02 10:14:51.831670',NULL,'2025-12-02 10:14:51.885439',507,507,'fb7fbe93d5b34afb91f154a1f8487fed','26b98133-6263-4945-aec9-892382ac832c',167,'7e6f29bbe0f44b04ada8cc16426d3961','gigabytes',1,'2025-12-03 10:14:51',NULL),('2025-12-02 10:14:51.845508',NULL,'2025-12-02 10:14:51.885439',508,508,NULL,'3a01df44-701d-48f6-b196-8bc8e335ead8',170,'7e6f29bbe0f44b04ada8cc16426d3961','shares',1,'2025-12-03 10:14:51','b9770666-8e95-4332-8979-dfdeb115eaf8'),('2025-12-02 10:14:51.847858',NULL,'2025-12-02 10:14:51.885439',509,509,NULL,'c7bbc697-ef47-4579-9626-152350cef788',169,'7e6f29bbe0f44b04ada8cc16426d3961','gigabytes',1,'2025-12-03 10:14:51','b9770666-8e95-4332-8979-dfdeb115eaf8'),('2025-12-02 10:14:52.382309',NULL,'2025-12-02 10:14:52.395960',510,510,'404a2149cc4c442e8f29fae023953b63','465b6489-d0c9-4c39-bb15-aaa2ffd1cea3',159,'6b9f3a4e12754a9ab7a5077a3e0bb303','shares',-1,'2025-12-03 10:14:52',NULL),('2025-12-02 10:14:52.383308',NULL,'2025-12-02 10:14:52.395960',511,511,'404a2149cc4c442e8f29fae023953b63','b1e8ebf3-f361-4051-8d16-acde0508f401',160,'6b9f3a4e12754a9ab7a5077a3e0bb303','gigabytes',-1,'2025-12-03 10:14:52',NULL),('2025-12-02 10:14:52.388658',NULL,'2025-12-02 10:14:52.395960',512,512,NULL,'aa414c71-67e7-4580-8897-ec8c175c51ea',161,'6b9f3a4e12754a9ab7a5077a3e0bb303','shares',-1,'2025-12-03 10:14:52','009a0375-1724-45ed-a672-bbd9ee8c52a1'),('2025-12-02 10:14:52.389364',NULL,'2025-12-02 10:14:52.395960',513,513,NULL,'8e9319c3-167f-498b-afa5-04ca2034a10f',162,'6b9f3a4e12754a9ab7a5077a3e0bb303','gigabytes',-1,'2025-12-03 10:14:52','009a0375-1724-45ed-a672-bbd9ee8c52a1'),('2025-12-02 10:14:53.159807',NULL,'2025-12-02 10:14:53.199794',514,514,'8186b016983446bb95a4c7821dfa53bb','1ab3b13a-28cb-42ef-9a83-781737aca6ba',156,'18e2a69daf6849dead0b925033d0fbad','shares',1,'2025-12-03 10:14:53',NULL),('2025-12-02 10:14:53.160995',NULL,'2025-12-02 10:14:53.199794',515,515,'8186b016983446bb95a4c7821dfa53bb','08ad013b-58e7-4c80-8b34-49fc853ae9ee',155,'18e2a69daf6849dead0b925033d0fbad','gigabytes',1,'2025-12-03 10:14:53',NULL),('2025-12-02 10:14:53.170871',NULL,'2025-12-02 10:14:53.199794',516,516,NULL,'3bc75a2c-1449-4a45-b472-58a0694aaee7',158,'18e2a69daf6849dead0b925033d0fbad','shares',1,'2025-12-03 10:14:53','9bfec2f4-a1c2-4bb7-b734-09f9d3fd4aa4'),('2025-12-02 10:14:53.172105',NULL,'2025-12-02 10:14:53.199794',517,517,NULL,'d6f466f6-563d-48fb-9d2f-12e3cacc92de',157,'18e2a69daf6849dead0b925033d0fbad','gigabytes',1,'2025-12-03 10:14:53','9bfec2f4-a1c2-4bb7-b734-09f9d3fd4aa4'),('2025-12-02 10:14:55.184410',NULL,'2025-12-02 10:14:55.217612',518,518,'fb7fbe93d5b34afb91f154a1f8487fed','ec73d4f5-0086-46f4-9934-d399f2d12907',168,'7e6f29bbe0f44b04ada8cc16426d3961','shares',1,'2025-12-03 10:14:55',NULL),('2025-12-02 10:14:55.186279',NULL,'2025-12-02 10:14:55.217612',519,519,'fb7fbe93d5b34afb91f154a1f8487fed','559a6710-9f12-4361-abf0-72dd64e12b44',167,'7e6f29bbe0f44b04ada8cc16426d3961','gigabytes',1,'2025-12-03 10:14:55',NULL),('2025-12-02 10:14:55.194895',NULL,'2025-12-02 10:14:55.217612',520,520,NULL,'48163d09-943d-4c8a-a930-e23e8a7e57cd',170,'7e6f29bbe0f44b04ada8cc16426d3961','shares',1,'2025-12-03 10:14:55','b9770666-8e95-4332-8979-dfdeb115eaf8'),('2025-12-02 10:14:55.196027',NULL,'2025-12-02 10:14:55.217612',521,521,NULL,'57140f68-2bee-41c3-9fb4-3028c7194309',169,'7e6f29bbe0f44b04ada8cc16426d3961','gigabytes',1,'2025-12-03 10:14:55','b9770666-8e95-4332-8979-dfdeb115eaf8'),('2025-12-02 10:14:56.960198',NULL,'2025-12-02 10:14:56.985545',522,522,'8186b016983446bb95a4c7821dfa53bb','ff4d3fea-2dbb-45e3-9527-b7d2a97d7c6d',156,'18e2a69daf6849dead0b925033d0fbad','shares',-1,'2025-12-03 10:14:56',NULL),('2025-12-02 10:14:56.961034',NULL,'2025-12-02 10:14:56.985545',523,523,'8186b016983446bb95a4c7821dfa53bb','dd9079cc-712c-40a7-a351-6a1506c37d94',155,'18e2a69daf6849dead0b925033d0fbad','gigabytes',-1,'2025-12-03 10:14:56',NULL),('2025-12-02 10:14:56.972340',NULL,'2025-12-02 10:14:56.985545',524,524,NULL,'094fb508-267e-4a9c-a5b9-263246b762e0',158,'18e2a69daf6849dead0b925033d0fbad','shares',-1,'2025-12-03 10:14:56','9bfec2f4-a1c2-4bb7-b734-09f9d3fd4aa4'),('2025-12-02 10:14:56.973522',NULL,'2025-12-02 10:14:56.985545',525,525,NULL,'ac54badf-0863-424d-a2ed-275ceac334a8',157,'18e2a69daf6849dead0b925033d0fbad','gigabytes',-1,'2025-12-03 10:14:56','9bfec2f4-a1c2-4bb7-b734-09f9d3fd4aa4'),('2025-12-02 10:14:57.830579',NULL,'2025-12-02 10:14:57.887269',526,526,'fbf6b461791a43fab13e6d1ef1e44841','cefe0fa6-db55-4b6b-97b6-b465b768649a',171,'5cdb1413e33f45cd8056ae0098190bd6','share_networks',1,'2025-12-03 10:14:57',NULL),('2025-12-02 10:14:57.996906',NULL,'2025-12-02 10:14:58.018777',527,527,'1a03624069ce41fcb02f5e929815f66c','d4dbd56f-c928-4ce3-bb80-6367eb8658f1',150,'8f75117f8554499b9fbaa9c9062eeeef','shares',-1,'2025-12-03 10:14:57',NULL),('2025-12-02 10:14:57.999000',NULL,'2025-12-02 10:14:58.018777',528,528,'1a03624069ce41fcb02f5e929815f66c','4b049106-7554-4c51-99d3-96a2376ef48f',151,'8f75117f8554499b9fbaa9c9062eeeef','gigabytes',-1,'2025-12-03 10:14:57',NULL),('2025-12-02 10:14:58.006787',NULL,'2025-12-02 10:14:58.018777',529,529,NULL,'a3f9916b-cffe-45e1-adde-c7cdcdea1568',152,'8f75117f8554499b9fbaa9c9062eeeef','shares',-1,'2025-12-03 10:14:57','36dcded1-31d3-40d9-bb47-df8b0de68b92'),('2025-12-02 10:14:58.007630',NULL,'2025-12-02 10:14:58.018777',530,530,NULL,'5872015a-c32b-45e2-86e1-c8a4d2aa35ba',153,'8f75117f8554499b9fbaa9c9062eeeef','gigabytes',-1,'2025-12-03 10:14:57','36dcded1-31d3-40d9-bb47-df8b0de68b92'),('2025-12-02 10:14:58.423773',NULL,'2025-12-02 10:14:58.453759',531,531,'fbf6b461791a43fab13e6d1ef1e44841','120aeee9-61dd-415d-9b3a-451ae17aa133',171,'5cdb1413e33f45cd8056ae0098190bd6','share_networks',1,'2025-12-03 10:14:58',NULL),('2025-12-02 10:14:58.765686',NULL,'2025-12-02 10:14:58.773550',532,532,'fbf6b461791a43fab13e6d1ef1e44841','830b0b13-db32-458d-aeb3-ac608cc6f22d',171,'5cdb1413e33f45cd8056ae0098190bd6','share_networks',-1,'2025-12-03 10:14:58',NULL),('2025-12-02 10:14:58.826021',NULL,'2025-12-02 10:14:58.853096',533,533,'fb7fbe93d5b34afb91f154a1f8487fed','7e45d0a2-acaf-48bf-8467-86a39691181a',168,'7e6f29bbe0f44b04ada8cc16426d3961','shares',-1,'2025-12-03 10:14:58',NULL),('2025-12-02 10:14:58.826872',NULL,'2025-12-02 10:14:58.853096',534,534,'fb7fbe93d5b34afb91f154a1f8487fed','f0de90a6-fee9-49fc-a097-0963648d98ed',167,'7e6f29bbe0f44b04ada8cc16426d3961','gigabytes',-1,'2025-12-03 10:14:58',NULL),('2025-12-02 10:14:58.828662',NULL,'2025-12-02 10:14:58.877101',535,535,'fbf6b461791a43fab13e6d1ef1e44841','d821ec75-e376-4bfd-b58c-f866f27477bb',171,'5cdb1413e33f45cd8056ae0098190bd6','share_networks',1,'2025-12-03 10:14:58',NULL),('2025-12-02 10:14:58.837885',NULL,'2025-12-02 10:14:58.853096',536,536,NULL,'63aec6c0-5471-48d9-ae60-619464a97fe2',170,'7e6f29bbe0f44b04ada8cc16426d3961','shares',-1,'2025-12-03 10:14:58','b9770666-8e95-4332-8979-dfdeb115eaf8'),('2025-12-02 10:14:58.838583',NULL,'2025-12-02 10:14:58.853096',537,537,NULL,'f523c74e-ff6d-44f7-8e07-96bb8e914519',169,'7e6f29bbe0f44b04ada8cc16426d3961','gigabytes',-1,'2025-12-03 10:14:58','b9770666-8e95-4332-8979-dfdeb115eaf8'),('2025-12-02 10:14:59.231070',NULL,'2025-12-02 10:14:59.236210',538,538,'fbf6b461791a43fab13e6d1ef1e44841','3ad160e4-b2c2-4408-b7c1-a7085e7d01bc',171,'5cdb1413e33f45cd8056ae0098190bd6','share_networks',-1,'2025-12-03 10:14:59',NULL),('2025-12-02 10:14:59.644447',NULL,'2025-12-02 10:14:59.650517',539,539,'fbf6b461791a43fab13e6d1ef1e44841','e2137365-6b43-46e0-abf8-22ec142f428a',171,'5cdb1413e33f45cd8056ae0098190bd6','share_networks',-1,'2025-12-03 10:14:59',NULL),('2025-12-02 10:14:59.924105',NULL,'2025-12-02 10:14:59.959810',540,540,'8186b016983446bb95a4c7821dfa53bb','3bf8b50b-882d-47b8-80ab-ed67f96bf007',156,'18e2a69daf6849dead0b925033d0fbad','shares',1,'2025-12-03 10:14:59',NULL),('2025-12-02 10:14:59.925841',NULL,'2025-12-02 10:14:59.959810',541,541,'8186b016983446bb95a4c7821dfa53bb','3a806213-53ab-4b5e-ae38-15588c6da805',155,'18e2a69daf6849dead0b925033d0fbad','gigabytes',2,'2025-12-03 10:14:59',NULL),('2025-12-02 10:14:59.932489',NULL,'2025-12-02 10:14:59.959810',542,542,NULL,'05433025-04a3-42ce-8787-cc855b7314be',158,'18e2a69daf6849dead0b925033d0fbad','shares',1,'2025-12-03 10:14:59','9bfec2f4-a1c2-4bb7-b734-09f9d3fd4aa4'),('2025-12-02 10:14:59.934003',NULL,'2025-12-02 10:14:59.959810',543,543,NULL,'7a6f2d75-f594-48d3-ace0-090514fcd494',157,'18e2a69daf6849dead0b925033d0fbad','gigabytes',2,'2025-12-03 10:14:59','9bfec2f4-a1c2-4bb7-b734-09f9d3fd4aa4'),('2025-12-02 10:15:01.955686',NULL,'2025-12-02 10:15:01.973291',544,544,'fb7fbe93d5b34afb91f154a1f8487fed','05e0a717-a4b6-4117-8b64-48c247c88786',168,'7e6f29bbe0f44b04ada8cc16426d3961','shares',-1,'2025-12-03 10:15:01',NULL),('2025-12-02 10:15:01.957824',NULL,'2025-12-02 10:15:01.973291',545,545,'fb7fbe93d5b34afb91f154a1f8487fed','1c228deb-7013-46f0-aa23-765d91a53cde',167,'7e6f29bbe0f44b04ada8cc16426d3961','gigabytes',-1,'2025-12-03 10:15:01',NULL),('2025-12-02 10:15:01.965547',NULL,'2025-12-02 10:15:01.973291',546,546,NULL,'da5f3376-ebd7-456d-a63f-b2e7cca707dd',170,'7e6f29bbe0f44b04ada8cc16426d3961','shares',-1,'2025-12-03 10:15:01','b9770666-8e95-4332-8979-dfdeb115eaf8'),('2025-12-02 10:15:01.966312',NULL,'2025-12-02 10:15:01.973291',547,547,NULL,'c5c4f9d9-ddce-4de0-8ccf-238d6e1782fd',169,'7e6f29bbe0f44b04ada8cc16426d3961','gigabytes',-1,'2025-12-03 10:15:01','b9770666-8e95-4332-8979-dfdeb115eaf8'),('2025-12-02 10:15:03.964360',NULL,'2025-12-02 10:15:03.994600',548,548,'8186b016983446bb95a4c7821dfa53bb','a7d3bb3c-0c08-41a1-b97c-e1cb89cffba0',156,'18e2a69daf6849dead0b925033d0fbad','shares',-1,'2025-12-03 10:15:03',NULL),('2025-12-02 10:15:03.966630',NULL,'2025-12-02 10:15:03.994600',549,549,'8186b016983446bb95a4c7821dfa53bb','9c0d0cf1-21cd-4690-819c-b83e437508a8',155,'18e2a69daf6849dead0b925033d0fbad','gigabytes',-2,'2025-12-03 10:15:03',NULL),('2025-12-02 10:15:03.974899',NULL,'2025-12-02 10:15:03.994600',550,550,NULL,'61ec6ab2-e7e9-4c28-a55c-f35457b2f74f',158,'18e2a69daf6849dead0b925033d0fbad','shares',-1,'2025-12-03 10:15:03','9bfec2f4-a1c2-4bb7-b734-09f9d3fd4aa4'),('2025-12-02 10:15:03.975805',NULL,'2025-12-02 10:15:03.994600',551,551,NULL,'f2268809-4814-4a75-9242-8457ea4afe53',157,'18e2a69daf6849dead0b925033d0fbad','gigabytes',-2,'2025-12-03 10:15:03','9bfec2f4-a1c2-4bb7-b734-09f9d3fd4aa4'),('2025-12-02 10:15:04.416179',NULL,'2025-12-02 10:15:04.465141',552,552,'bb93ce39d4d54c7380f75f22f5ffc493','e9b874c6-411e-4515-ad91-fd90c8f47425',172,'82d5a09e66904b8ca3c7a7850f1e5c52','shares',1,'2025-12-03 10:15:04',NULL),('2025-12-02 10:15:04.417847',NULL,'2025-12-02 10:15:04.465141',553,553,'bb93ce39d4d54c7380f75f22f5ffc493','fbeda808-be75-462e-bb44-74be4055d669',173,'82d5a09e66904b8ca3c7a7850f1e5c52','gigabytes',1,'2025-12-03 10:15:04',NULL),('2025-12-02 10:15:04.433943',NULL,'2025-12-02 10:15:04.465141',554,554,NULL,'a4417619-6ecd-4580-840f-fb1d7851b92c',174,'82d5a09e66904b8ca3c7a7850f1e5c52','shares',1,'2025-12-03 10:15:04','61627d65-42d5-4d24-81b9-703b092c0068'),('2025-12-02 10:15:04.435184',NULL,'2025-12-02 10:15:04.465141',555,555,NULL,'43189bac-9510-4b0c-9357-f9190b15b4ca',175,'82d5a09e66904b8ca3c7a7850f1e5c52','gigabytes',1,'2025-12-03 10:15:04','61627d65-42d5-4d24-81b9-703b092c0068'),('2025-12-02 10:15:04.965648',NULL,'2025-12-02 10:15:04.999396',556,556,'fb7fbe93d5b34afb91f154a1f8487fed','44933836-55eb-48b8-85ba-ed9cafe0fbfd',176,'7e6f29bbe0f44b04ada8cc16426d3961','share_groups',1,'2025-12-03 10:15:04',NULL),('2025-12-02 10:15:06.872956',NULL,'2025-12-02 10:15:06.909190',557,557,'8186b016983446bb95a4c7821dfa53bb','b37b3d6b-cc1d-4c6d-84c5-a73553f84a6e',156,'18e2a69daf6849dead0b925033d0fbad','shares',1,'2025-12-03 10:15:06',NULL),('2025-12-02 10:15:06.874675',NULL,'2025-12-02 10:15:06.909190',558,558,'8186b016983446bb95a4c7821dfa53bb','e0990e44-eb65-47bc-976a-1ecc3d2470e6',155,'18e2a69daf6849dead0b925033d0fbad','gigabytes',1,'2025-12-03 10:15:06',NULL),('2025-12-02 10:15:06.883204',NULL,'2025-12-02 10:15:06.909190',559,559,NULL,'53a405a6-8717-4172-8713-2c4a87f548fe',158,'18e2a69daf6849dead0b925033d0fbad','shares',1,'2025-12-03 10:15:06','9bfec2f4-a1c2-4bb7-b734-09f9d3fd4aa4'),('2025-12-02 10:15:06.884898',NULL,'2025-12-02 10:15:06.909190',560,560,NULL,'4bbc9a87-0279-4a6b-b6d7-7b5f54717792',157,'18e2a69daf6849dead0b925033d0fbad','gigabytes',1,'2025-12-03 10:15:06','9bfec2f4-a1c2-4bb7-b734-09f9d3fd4aa4'),('2025-12-02 10:15:08.182681',NULL,'2025-12-02 10:15:08.193536',561,561,'fb7fbe93d5b34afb91f154a1f8487fed','f49aa229-06ad-4baa-acd5-d5d7d65b6252',176,'7e6f29bbe0f44b04ada8cc16426d3961','share_groups',-1,'2025-12-03 10:15:08',NULL),('2025-12-02 10:15:08.200280',NULL,'2025-12-02 10:15:08.231145',562,562,'bb93ce39d4d54c7380f75f22f5ffc493','f9b28058-3cec-4dc9-8ee6-4cb66770c224',172,'82d5a09e66904b8ca3c7a7850f1e5c52','shares',1,'2025-12-03 10:15:08',NULL),('2025-12-02 10:15:08.202489',NULL,'2025-12-02 10:15:08.231145',563,563,'bb93ce39d4d54c7380f75f22f5ffc493','be81249d-795a-4284-8f69-2abe20547a33',173,'82d5a09e66904b8ca3c7a7850f1e5c52','gigabytes',1,'2025-12-03 10:15:08',NULL),('2025-12-02 10:15:08.209681',NULL,'2025-12-02 10:15:08.231145',564,564,NULL,'5028b2e5-74b9-433d-be63-8539f706088a',174,'82d5a09e66904b8ca3c7a7850f1e5c52','shares',1,'2025-12-03 10:15:08','61627d65-42d5-4d24-81b9-703b092c0068'),('2025-12-02 10:15:08.211100',NULL,'2025-12-02 10:15:08.231145',565,565,NULL,'0162ca64-32f1-4525-89e8-2e28d8fd67ad',175,'82d5a09e66904b8ca3c7a7850f1e5c52','gigabytes',1,'2025-12-03 10:15:08','61627d65-42d5-4d24-81b9-703b092c0068'),('2025-12-02 10:15:09.611385',NULL,'2025-12-02 10:15:09.643595',566,566,'7c87e5c44dfa4bd3835e77bc991eb253','979b326d-3579-4472-9310-1142dc63bd34',177,'0fe90f11d3f64e12b3591732792a929e','shares',1,'2025-12-03 10:15:09',NULL),('2025-12-02 10:15:09.613232',NULL,'2025-12-02 10:15:09.643595',567,567,'7c87e5c44dfa4bd3835e77bc991eb253','12bf88b2-7b86-4f85-b2f4-1e2fad00f9ef',178,'0fe90f11d3f64e12b3591732792a929e','gigabytes',1,'2025-12-03 10:15:09',NULL),('2025-12-02 10:15:09.622764',NULL,'2025-12-02 10:15:09.643595',568,568,NULL,'79a30f90-4841-40b6-81d2-1f9feaf1b80d',179,'0fe90f11d3f64e12b3591732792a929e','shares',1,'2025-12-03 10:15:09','2cf6aa27-89aa-44f3-a131-dee193f9f9f9'),('2025-12-02 10:15:09.623845',NULL,'2025-12-02 10:15:09.643595',569,569,NULL,'aee0e1fd-8149-4714-ad46-e8c7236fb61d',180,'0fe90f11d3f64e12b3591732792a929e','gigabytes',1,'2025-12-03 10:15:09','2cf6aa27-89aa-44f3-a131-dee193f9f9f9'),('2025-12-02 10:15:10.486242',NULL,'2025-12-02 10:15:10.502634',570,570,'8186b016983446bb95a4c7821dfa53bb','85df2a84-f673-491d-9895-9b1bf08b5413',156,'18e2a69daf6849dead0b925033d0fbad','shares',-1,'2025-12-03 10:15:10',NULL),('2025-12-02 10:15:10.487593',NULL,'2025-12-02 10:15:10.502634',571,571,'8186b016983446bb95a4c7821dfa53bb','dde3ac7f-f9e0-4e9a-9d9e-335102ee2ca8',155,'18e2a69daf6849dead0b925033d0fbad','gigabytes',-1,'2025-12-03 10:15:10',NULL),('2025-12-02 10:15:10.494114',NULL,'2025-12-02 10:15:10.502634',572,572,NULL,'f5c5a4b3-e579-4c87-af78-e2b4d0953822',158,'18e2a69daf6849dead0b925033d0fbad','shares',-1,'2025-12-03 10:15:10','9bfec2f4-a1c2-4bb7-b734-09f9d3fd4aa4'),('2025-12-02 10:15:10.494959',NULL,'2025-12-02 10:15:10.502634',573,573,NULL,'ab2cc8a0-2423-4fb3-a6d5-705ba25b4c4f',157,'18e2a69daf6849dead0b925033d0fbad','gigabytes',-1,'2025-12-03 10:15:10','9bfec2f4-a1c2-4bb7-b734-09f9d3fd4aa4'),('2025-12-02 10:15:11.356263',NULL,'2025-12-02 10:15:11.376474',574,574,'fb7fbe93d5b34afb91f154a1f8487fed','c130994e-b10e-407c-9050-2d1a8624ed9d',176,'7e6f29bbe0f44b04ada8cc16426d3961','share_groups',1,'2025-12-03 10:15:11',NULL),('2025-12-02 10:15:12.995828',NULL,'2025-12-02 10:15:13.031457',575,575,'7c87e5c44dfa4bd3835e77bc991eb253','dc829d33-3858-4699-8896-715d3f7a663b',177,'0fe90f11d3f64e12b3591732792a929e','shares',1,'2025-12-03 10:15:12',NULL),('2025-12-02 10:15:12.997097',NULL,'2025-12-02 10:15:13.031457',576,576,'7c87e5c44dfa4bd3835e77bc991eb253','7515bd98-fe02-4fd1-b861-b28723322b3d',178,'0fe90f11d3f64e12b3591732792a929e','gigabytes',1,'2025-12-03 10:15:12',NULL),('2025-12-02 10:15:13.008499',NULL,'2025-12-02 10:15:13.031457',577,577,NULL,'788e60b7-37df-4647-84dd-1473145a4ac7',182,'0fe90f11d3f64e12b3591732792a929e','shares',1,'2025-12-03 10:15:12','0a22f71a-1e77-4d73-a77a-d76be02b5792'),('2025-12-02 10:15:13.009701',NULL,'2025-12-02 10:15:13.031457',578,578,NULL,'66d307a8-917d-4232-b949-d910d05bb4dd',181,'0fe90f11d3f64e12b3591732792a929e','gigabytes',1,'2025-12-03 10:15:12','0a22f71a-1e77-4d73-a77a-d76be02b5792'),('2025-12-02 10:15:13.354476',NULL,'2025-12-02 10:15:13.382485',579,579,'8186b016983446bb95a4c7821dfa53bb','fa32b552-91d2-4fb3-ae81-d60df21628e9',156,'18e2a69daf6849dead0b925033d0fbad','shares',1,'2025-12-03 10:15:13',NULL),('2025-12-02 10:15:13.355641',NULL,'2025-12-02 10:15:13.382485',580,580,'8186b016983446bb95a4c7821dfa53bb','de0e9081-4e46-445c-868e-8615660c383b',155,'18e2a69daf6849dead0b925033d0fbad','gigabytes',1,'2025-12-03 10:15:13',NULL),('2025-12-02 10:15:13.361257',NULL,'2025-12-02 10:15:13.382485',581,581,NULL,'8aef4f59-76b3-4ba4-8104-94dd22d26d77',158,'18e2a69daf6849dead0b925033d0fbad','shares',1,'2025-12-03 10:15:13','9bfec2f4-a1c2-4bb7-b734-09f9d3fd4aa4'),('2025-12-02 10:15:13.362826',NULL,'2025-12-02 10:15:13.382485',582,582,NULL,'5848d406-f619-49a2-ba9f-dbbb075dc377',157,'18e2a69daf6849dead0b925033d0fbad','gigabytes',1,'2025-12-03 10:15:13','9bfec2f4-a1c2-4bb7-b734-09f9d3fd4aa4'),('2025-12-02 10:15:14.686069',NULL,'2025-12-02 10:15:14.695049',583,583,'fb7fbe93d5b34afb91f154a1f8487fed','06d5217f-636e-466d-8a1f-5ed85e29cb51',176,'7e6f29bbe0f44b04ada8cc16426d3961','share_groups',-1,'2025-12-03 10:15:14',NULL),('2025-12-02 10:15:15.690061',NULL,'2025-12-02 10:15:15.707465',584,584,'bb93ce39d4d54c7380f75f22f5ffc493','78810045-568a-4f02-a335-4ba252d794bf',172,'82d5a09e66904b8ca3c7a7850f1e5c52','shares',-1,'2025-12-03 10:15:15',NULL),('2025-12-02 10:15:15.690711',NULL,'2025-12-02 10:15:15.707465',585,585,'bb93ce39d4d54c7380f75f22f5ffc493','229c3b38-081e-48f4-9fef-5d1022ea12ff',173,'82d5a09e66904b8ca3c7a7850f1e5c52','gigabytes',-1,'2025-12-03 10:15:15',NULL),('2025-12-02 10:15:15.696669',NULL,'2025-12-02 10:15:15.707465',586,586,NULL,'5a21ce57-5f9e-4c9c-ac3e-94c6e1ae2be3',174,'82d5a09e66904b8ca3c7a7850f1e5c52','shares',-1,'2025-12-03 10:15:15','61627d65-42d5-4d24-81b9-703b092c0068'),('2025-12-02 10:15:15.697379',NULL,'2025-12-02 10:15:15.707465',587,587,NULL,'1696d01e-34f5-494a-9c76-5cae59270691',175,'82d5a09e66904b8ca3c7a7850f1e5c52','gigabytes',-1,'2025-12-03 10:15:15','61627d65-42d5-4d24-81b9-703b092c0068'),('2025-12-02 10:15:16.119926',NULL,'2025-12-02 10:15:16.167749',588,588,'98ea0090b3f5415e9d68555dc2519917','6b58c32d-ec07-480e-ac63-933720722f1e',183,'2663dddab79d4a678692e6a4e964573c','share_networks',1,'2025-12-03 10:15:16',NULL),('2025-12-02 10:15:16.280146',NULL,'2025-12-02 10:15:16.320195',589,589,'98ea0090b3f5415e9d68555dc2519917','05578e69-4ee3-4910-a2bd-0a15e4d1cc0a',183,'2663dddab79d4a678692e6a4e964573c','share_networks',1,'2025-12-03 10:15:16',NULL),('2025-12-02 10:15:16.430706',NULL,'2025-12-02 10:15:16.454594',590,590,'98ea0090b3f5415e9d68555dc2519917','1b59b8e7-1702-4832-afe1-40fc12aeb7f9',183,'2663dddab79d4a678692e6a4e964573c','share_networks',1,'2025-12-03 10:15:16',NULL),('2025-12-02 10:15:16.566103',NULL,'2025-12-02 10:15:16.638752',591,591,'98ea0090b3f5415e9d68555dc2519917','4a7c3ae6-5b15-44e4-b47f-e0a48c7a6a90',183,'2663dddab79d4a678692e6a4e964573c','share_networks',-1,'2025-12-03 10:15:16',NULL),('2025-12-02 10:15:16.711110',NULL,'2025-12-02 10:15:16.743198',592,592,'98ea0090b3f5415e9d68555dc2519917','7db0cfbc-b661-4c66-864a-9bdf056dcbb0',183,'2663dddab79d4a678692e6a4e964573c','share_networks',1,'2025-12-03 10:15:16',NULL),('2025-12-02 10:15:16.796047',NULL,'2025-12-02 10:15:16.834074',593,593,'98ea0090b3f5415e9d68555dc2519917','f9842fae-1101-48dd-856e-9e3fc3c9c18a',183,'2663dddab79d4a678692e6a4e964573c','share_networks',1,'2025-12-03 10:15:16',NULL),('2025-12-02 10:15:16.917347',NULL,'2025-12-02 10:15:16.923964',594,594,'98ea0090b3f5415e9d68555dc2519917','ae3d1583-0ef8-4fe2-adb0-214eec81bc52',183,'2663dddab79d4a678692e6a4e964573c','share_networks',-1,'2025-12-03 10:15:16',NULL),('2025-12-02 10:15:17.017490',NULL,'2025-12-02 10:15:17.022195',595,595,'98ea0090b3f5415e9d68555dc2519917','c043b916-c4b8-41ce-a874-a708a6af24fd',183,'2663dddab79d4a678692e6a4e964573c','share_networks',-1,'2025-12-03 10:15:17',NULL),('2025-12-02 10:15:17.050538',NULL,'2025-12-02 10:15:17.074949',596,596,'8186b016983446bb95a4c7821dfa53bb','1b1b5da9-08a8-493b-bd52-33c76746b649',156,'18e2a69daf6849dead0b925033d0fbad','shares',-1,'2025-12-03 10:15:17',NULL),('2025-12-02 10:15:17.051544',NULL,'2025-12-02 10:15:17.074949',597,597,'8186b016983446bb95a4c7821dfa53bb','0fe151e5-bbb1-48a8-9cf4-5142c83c523f',155,'18e2a69daf6849dead0b925033d0fbad','gigabytes',-1,'2025-12-03 10:15:17',NULL),('2025-12-02 10:15:17.065812',NULL,'2025-12-02 10:15:17.074949',598,598,NULL,'504a3d84-f517-44ef-bed1-b3bcd9d9534a',158,'18e2a69daf6849dead0b925033d0fbad','shares',-1,'2025-12-03 10:15:17','9bfec2f4-a1c2-4bb7-b734-09f9d3fd4aa4'),('2025-12-02 10:15:17.067326',NULL,'2025-12-02 10:15:17.074949',599,599,NULL,'7718664e-25da-4db7-9521-a0c67bdecafd',157,'18e2a69daf6849dead0b925033d0fbad','gigabytes',-1,'2025-12-03 10:15:17','9bfec2f4-a1c2-4bb7-b734-09f9d3fd4aa4'),('2025-12-02 10:15:17.368483',NULL,'2025-12-02 10:15:17.393396',600,600,'98ea0090b3f5415e9d68555dc2519917','b3a29bb1-4593-4032-8cc3-7a8ac2a072fe',183,'2663dddab79d4a678692e6a4e964573c','share_networks',1,'2025-12-03 10:15:17',NULL),('2025-12-02 10:15:17.495884',NULL,'2025-12-02 10:15:17.501169',601,601,'98ea0090b3f5415e9d68555dc2519917','5f8e2aba-a6dc-43dc-b2a2-218c751596b5',183,'2663dddab79d4a678692e6a4e964573c','share_networks',-1,'2025-12-03 10:15:17',NULL),('2025-12-02 10:15:17.527200',NULL,'2025-12-02 10:15:17.563206',602,602,'98ea0090b3f5415e9d68555dc2519917','bae6d6c8-7961-47d7-83ae-16db43422296',183,'2663dddab79d4a678692e6a4e964573c','share_networks',1,'2025-12-03 10:15:17',NULL),('2025-12-02 10:15:17.655969',NULL,'2025-12-02 10:15:17.661385',603,603,'98ea0090b3f5415e9d68555dc2519917','ee442cf7-6340-40ca-b197-51687c77128b',183,'2663dddab79d4a678692e6a4e964573c','share_networks',-1,'2025-12-03 10:15:17',NULL),('2025-12-02 10:15:17.799996',NULL,'2025-12-02 10:15:17.828391',604,604,'fb7fbe93d5b34afb91f154a1f8487fed','910c0b88-60f8-41d9-bda0-62fd772d64fc',168,'7e6f29bbe0f44b04ada8cc16426d3961','shares',1,'2025-12-03 10:15:17',NULL),('2025-12-02 10:15:17.801395',NULL,'2025-12-02 10:15:17.828391',605,605,'fb7fbe93d5b34afb91f154a1f8487fed','28e1fe42-626f-40f6-84c3-f69b4ec9178c',167,'7e6f29bbe0f44b04ada8cc16426d3961','gigabytes',1,'2025-12-03 10:15:17',NULL),('2025-12-02 10:15:17.808198',NULL,'2025-12-02 10:15:17.828391',606,606,NULL,'ac6fc487-cc09-4952-8319-bdb8500fe741',170,'7e6f29bbe0f44b04ada8cc16426d3961','shares',1,'2025-12-03 10:15:17','b9770666-8e95-4332-8979-dfdeb115eaf8'),('2025-12-02 10:15:17.809482',NULL,'2025-12-02 10:15:17.828391',607,607,NULL,'7329fb44-4ce1-4be9-8079-983d2b4af69c',169,'7e6f29bbe0f44b04ada8cc16426d3961','gigabytes',1,'2025-12-03 10:15:17','b9770666-8e95-4332-8979-dfdeb115eaf8'),('2025-12-02 10:15:17.945546',NULL,'2025-12-02 10:15:17.973220',608,608,'bb93ce39d4d54c7380f75f22f5ffc493','d6a405a4-c37e-44a7-889a-6065cbc97a32',172,'82d5a09e66904b8ca3c7a7850f1e5c52','shares',1,'2025-12-03 10:15:17',NULL),('2025-12-02 10:15:17.947199',NULL,'2025-12-02 10:15:17.973220',609,609,'bb93ce39d4d54c7380f75f22f5ffc493','2be7c0e9-5dda-401a-b032-4f86b1b92b3a',173,'82d5a09e66904b8ca3c7a7850f1e5c52','gigabytes',1,'2025-12-03 10:15:17',NULL),('2025-12-02 10:15:17.954796',NULL,'2025-12-02 10:15:17.973220',610,610,NULL,'ef6080c8-f87c-4073-82f8-2d8592cb7e6c',174,'82d5a09e66904b8ca3c7a7850f1e5c52','shares',1,'2025-12-03 10:15:17','61627d65-42d5-4d24-81b9-703b092c0068'),('2025-12-02 10:15:17.956351',NULL,'2025-12-02 10:15:17.973220',611,611,NULL,'30bbac63-75b3-4e7b-a7a2-e583ae63cafa',175,'82d5a09e66904b8ca3c7a7850f1e5c52','gigabytes',1,'2025-12-03 10:15:17','61627d65-42d5-4d24-81b9-703b092c0068'),('2025-12-02 10:15:18.064473',NULL,'2025-12-02 10:15:18.072871',612,612,'98ea0090b3f5415e9d68555dc2519917','02bfe8c4-a8df-420c-958e-68e4d003bc11',183,'2663dddab79d4a678692e6a4e964573c','share_networks',-1,'2025-12-03 10:15:18',NULL),('2025-12-02 10:15:18.181267',NULL,'2025-12-02 10:15:18.189262',613,613,'98ea0090b3f5415e9d68555dc2519917','337121dc-d5ee-4a50-a719-ceade3a6215a',183,'2663dddab79d4a678692e6a4e964573c','share_networks',-1,'2025-12-03 10:15:18',NULL),('2025-12-02 10:15:19.601480',NULL,'2025-12-02 10:15:19.710545',614,614,'19c2bca62a264b93add0d8ce170a4fe5','cc268f4f-8acc-483c-b13a-a2d759e36f8e',184,'3212fac1e026474b9022ee93e4d925a9','shares',1,'2025-12-03 10:15:19',NULL),('2025-12-02 10:15:19.602777',NULL,'2025-12-02 10:15:19.7105