/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `barbican`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `barbican` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `barbican`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('8c74e2d7f1ff');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authorities`
--

DROP TABLE IF EXISTS `certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `plugin_ca_id` text NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cas_project_fk` (`project_id`),
  CONSTRAINT `cas_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authorities`
--

LOCK TABLES `certificate_authorities` WRITE;
/*!40000 ALTER TABLE `certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authority_metadata`
--

DROP TABLE IF EXISTS `certificate_authority_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authority_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_certificate_authority_metadatum_uc` (`ca_id`,`key`),
  KEY `ix_certificate_authority_metadata_ca_id` (`ca_id`),
  KEY `ix_certificate_authority_metadata_key` (`key`),
  CONSTRAINT `certificate_authority_metadata_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authority_metadata`
--

LOCK TABLES `certificate_authority_metadata` WRITE;
/*!40000 ALTER TABLE `certificate_authority_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authority_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acl_users`
--

DROP TABLE IF EXISTS `container_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_container_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `container_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `container_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acl_users`
--

LOCK TABLES `container_acl_users` WRITE;
/*!40000 ALTER TABLE `container_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acls`
--

DROP TABLE IF EXISTS `container_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_operation_uc` (`container_id`,`operation`),
  KEY `ix_container_acls_container_id` (`container_id`),
  CONSTRAINT `container_acls_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acls`
--

LOCK TABLES `container_acls` WRITE;
/*!40000 ALTER TABLE `container_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_consumer_metadata`
--

DROP TABLE IF EXISTS `container_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `name` varchar(36) DEFAULT NULL,
  `URL` varchar(255) DEFAULT NULL,
  `data_hash` char(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_consumer_hashed_container_name_url_uc` (`data_hash`),
  KEY `ix_container_consumer_metadata_container_id` (`container_id`),
  KEY `ix_container_consumer_metadata_project_id` (`project_id`),
  KEY `values_index` (`container_id`,`name`,`URL`),
  CONSTRAINT `container_consumer_metadata_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_consumer_metadata_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_consumer_metadata`
--

LOCK TABLES `container_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `container_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_secret`
--

DROP TABLE IF EXISTS `container_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_secret` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `container_id` varchar(36) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_secret_name_uc` (`container_id`,`secret_id`,`name`),
  KEY `ix_container_secret_container_id` (`container_id`),
  KEY `ix_container_secret_secret_id` (`secret_id`),
  CONSTRAINT `container_secret_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_secret_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_secret`
--

LOCK TABLES `container_secret` WRITE;
/*!40000 ALTER TABLE `container_secret` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `containers`
--

DROP TABLE IF EXISTS `containers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `containers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('generic','rsa','dsa','certificate') DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_containers_project_id` (`project_id`),
  CONSTRAINT `containers_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `containers`
--

LOCK TABLES `containers` WRITE;
/*!40000 ALTER TABLE `containers` DISABLE KEYS */;
/*!40000 ALTER TABLE `containers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encrypted_data`
--

DROP TABLE IF EXISTS `encrypted_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encrypted_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `secret_id` varchar(36) NOT NULL,
  `kek_id` varchar(36) NOT NULL,
  `cypher_text` text DEFAULT NULL,
  `kek_meta_extended` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_encrypted_data_kek_id` (`kek_id`),
  KEY `ix_encrypted_data_secret_id` (`secret_id`),
  CONSTRAINT `encrypted_data_ibfk_1` FOREIGN KEY (`kek_id`) REFERENCES `kek_data` (`id`),
  CONSTRAINT `encrypted_data_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encrypted_data`
--

LOCK TABLES `encrypted_data` WRITE;
/*!40000 ALTER TABLE `encrypted_data` DISABLE KEYS */;
INSERT INTO `encrypted_data` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `content_type`, `secret_id`, `kek_id`, `cypher_text`, `kek_meta_extended`) VALUES ('8050a45e-806d-4700-b8c2-9cfeda610fa0','2026-01-31 08:34:17','2026-01-31 08:36:24','2026-01-31 08:36:24',1,'ACTIVE','application/octet-stream','2ca6a990-a9f2-407b-95b2-5887f411722b','5ea08d64-b021-40b2-be39-a5356c32fc10','Z0FBQUFBQnBmYjZKMFdYX0t0ZTZHamlCeVRPb2tBOVF1TzcxbG14R0VFeFdyWDRkUmF1T2ZyWDBmYUZKeWpBR0ViNkdveWNIT1JwV2wwcmUwaFFTYkx3TTNVd0Q4RXhtakFLeGU1cWRmUmZfcC01NFlRV3JfQ0EtV0xHMFNFOUI3Ul9LS1hWcUNuRXo=',NULL),('a12f6e08-d742-4e7b-8be8-4f4c28a826bb','2026-01-31 09:11:11','2026-01-31 09:12:06','2026-01-31 09:12:06',1,'ACTIVE','application/octet-stream','ec92ef3b-edd6-40a0-a6ad-12d162206d8b','b4378645-adfe-4c32-ba6c-0930327817d6','Z0FBQUFBQnBmY2N2bHFhTGFCWHdaS3VHQktKakVqUVZqRVpSMG9FTU1wM1ZxNXhQNWc0ekFROHJORU5hYXdjUHU3UFJIbEJLTWJIekJrRW1IenNRMVhnS3I4d2FhWm5VaXY2RzFJVDY5UmxHZFJxbHNRZndxc2x2YjEtUU1laUNyTHd1LTVCV2tPbXk=',NULL);
/*!40000 ALTER TABLE `encrypted_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kek_data`
--

DROP TABLE IF EXISTS `kek_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kek_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `kek_label` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `bind_completed` tinyint(1) NOT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `plugin_meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_kek_data_project_id` (`project_id`),
  CONSTRAINT `kek_data_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kek_data`
--

LOCK TABLES `kek_data` WRITE;
/*!40000 ALTER TABLE `kek_data` DISABLE KEYS */;
INSERT INTO `kek_data` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `plugin_name`, `kek_label`, `project_id`, `active`, `bind_completed`, `algorithm`, `bit_length`, `mode`, `plugin_meta`) VALUES ('5ea08d64-b021-40b2-be39-a5356c32fc10','2026-01-31 08:34:16','2026-01-31 08:37:16','2026-01-31 08:37:16',1,'ACTIVE','barbican.plugin.crypto.simple_crypto.SimpleCryptoPlugin','project-149ccba7b87e4284a3a6462e3a1dace1-key-ca8ed0ad-d130-405d-8079-bacdefa648ab','82024efd-560e-4e43-ad18-d503154bf031',1,1,'aes',128,'cbc','gAAAAABpfb6Ik2y5oug70Acg08iLPrLdZqkhV4kp4wIsTd4ujkx3CqBSIpSC3bgLzoEjW1EWS2CvwosJFv54By9HzRWAsWL3wjR2AHD4Jx7x-HSNUJ18zM6IcGlwIzA-Abu0sR_FF198'),('b4378645-adfe-4c32-ba6c-0930327817d6','2026-01-31 09:11:11','2026-01-31 09:19:34','2026-01-31 09:19:34',1,'ACTIVE','barbican.plugin.crypto.simple_crypto.SimpleCryptoPlugin','project-98d10c0290e340a08e9d1726bf0066bf-key-878d1d6b-83dc-48c6-af7d-12e3e3f3f6e8','50856cb5-d773-4e0a-88a2-edfc3b3d51b2',1,1,'aes',128,'cbc','gAAAAABpfccvcFRffb15xClqY4CeT5j6AtBldf1mZ93qL5og5BXr4QLXrk4vgPfPCfoag2YOk-PLVf4wgCw_Mlwh_KRnUnVP70jP4GHLqhmoKMWqZIyvrTQEyb61rpB_Uulne0ArE4wA');
/*!40000 ALTER TABLE `kek_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_barbican_metadata`
--

DROP TABLE IF EXISTS `order_barbican_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_barbican_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_barbican_metadata_order_id` (`order_id`),
  CONSTRAINT `order_barbican_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_barbican_metadata`
--

LOCK TABLES `order_barbican_metadata` WRITE;
/*!40000 ALTER TABLE `order_barbican_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_barbican_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_plugin_metadata`
--

DROP TABLE IF EXISTS `order_plugin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_plugin_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_plugin_metadata_order_id` (`order_id`),
  CONSTRAINT `order_plugin_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_plugin_metadata`
--

LOCK TABLES `order_plugin_metadata` WRITE;
/*!40000 ALTER TABLE `order_plugin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_plugin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_retry_tasks`
--

DROP TABLE IF EXISTS `order_retry_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_retry_tasks` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `id` varchar(36) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `retry_task` text NOT NULL,
  `retry_at` datetime NOT NULL,
  `retry_args` text NOT NULL,
  `retry_kwargs` text NOT NULL,
  `retry_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_retry_tasks_order_id` (`order_id`),
  CONSTRAINT `order_retry_tasks_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_retry_tasks`
--

LOCK TABLES `order_retry_tasks` WRITE;
/*!40000 ALTER TABLE `order_retry_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_retry_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `error_status_code` varchar(16) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  `secret_id` varchar(36) DEFAULT NULL,
  `container_id` varchar(36) DEFAULT NULL,
  `sub_status` varchar(36) DEFAULT NULL,
  `sub_status_message` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_orders_container_id` (`container_id`),
  KEY `ix_orders_project_id` (`project_id`),
  KEY `ix_orders_secret_id` (`secret_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`),
  CONSTRAINT `orders_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
INSERT INTO `orders` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `type`, `project_id`, `error_status_code`, `error_reason`, `meta`, `secret_id`, `container_id`, `sub_status`, `sub_status_message`, `creator_id`) VALUES ('3afad999-ea78-42c4-b0cf-8e75520022f2','2026-01-31 08:34:15','2026-01-31 08:34:17',NULL,0,'ACTIVE','key','82024efd-560e-4e43-ad18-d503154bf031',NULL,NULL,'{\"algorithm\": \"aes\", \"bit_length\": 256, \"name\": null, \"expiration\": null}','2ca6a990-a9f2-407b-95b2-5887f411722b',NULL,'Unknown','Unknown','eb8e3d6cd4094a62b23e39cec9023f18'),('760d3467-f810-42dd-920d-4147da1d1a98','2026-01-31 09:11:11','2026-01-31 09:11:11',NULL,0,'ACTIVE','key','50856cb5-d773-4e0a-88a2-edfc3b3d51b2',NULL,NULL,'{\"algorithm\": \"aes\", \"bit_length\": 256, \"name\": null, \"expiration\": null}','ec92ef3b-edd6-40a0-a6ad-12d162206d8b',NULL,'Unknown','Unknown','ecd39871d7fd438f88b36601f25d6eb6');
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preferred_certificate_authorities`
--

DROP TABLE IF EXISTS `preferred_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `preferred_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_preferred_certificate_authorities_project_id` (`project_id`),
  KEY `ix_preferred_certificate_authorities_ca_id` (`ca_id`),
  CONSTRAINT `preferred_certificate_authorities_fk` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `preferred_certificate_authorities_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preferred_certificate_authorities`
--

LOCK TABLES `preferred_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `preferred_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `preferred_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_certificate_authorities`
--

DROP TABLE IF EXISTS `project_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_certificate_authority_uc` (`project_id`,`ca_id`),
  KEY `ix_project_certificate_authorities_ca_id` (`ca_id`),
  KEY `ix_project_certificate_authorities_project_id` (`project_id`),
  CONSTRAINT `project_certificate_authorities_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `project_certificate_authorities_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_certificate_authorities`
--

LOCK TABLES `project_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `project_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_quotas`
--

DROP TABLE IF EXISTS `project_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_quotas` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `secrets` int(11) DEFAULT NULL,
  `orders` int(11) DEFAULT NULL,
  `containers` int(11) DEFAULT NULL,
  `consumers` int(11) DEFAULT NULL,
  `cas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_project_quotas_project_id` (`project_id`),
  CONSTRAINT `project_quotas_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_quotas`
--

LOCK TABLES `project_quotas` WRITE;
/*!40000 ALTER TABLE `project_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_secret_store`
--

DROP TABLE IF EXISTS `project_secret_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_secret_store` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_store_id` varchar(36) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_secret_store_project_uc` (`project_id`),
  KEY `ix_project_secret_store_project_id` (`project_id`),
  KEY `ix_project_secret_store_secret_store_id` (`secret_store_id`),
  CONSTRAINT `project_secret_store_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `project_secret_store_ibfk_2` FOREIGN KEY (`secret_store_id`) REFERENCES `secret_stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_secret_store`
--

LOCK TABLES `project_secret_store` WRITE;
/*!40000 ALTER TABLE `project_secret_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_secret_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `external_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
INSERT INTO `projects` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `external_id`) VALUES ('50856cb5-d773-4e0a-88a2-edfc3b3d51b2','2026-01-31 09:11:11','2026-01-31 09:19:34','2026-01-31 09:19:34',1,'ACTIVE','98d10c0290e340a08e9d1726bf0066bf'),('82024efd-560e-4e43-ad18-d503154bf031','2026-01-31 08:34:15','2026-01-31 08:37:16','2026-01-31 08:37:16',1,'ACTIVE','149ccba7b87e4284a3a6462e3a1dace1');
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acl_users`
--

DROP TABLE IF EXISTS `secret_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_secret_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `secret_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `secret_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acl_users`
--

LOCK TABLES `secret_acl_users` WRITE;
/*!40000 ALTER TABLE `secret_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acls`
--

DROP TABLE IF EXISTS `secret_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_operation_uc` (`secret_id`,`operation`),
  KEY `ix_secret_acls_secret_id` (`secret_id`),
  CONSTRAINT `secret_acls_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acls`
--

LOCK TABLES `secret_acls` WRITE;
/*!40000 ALTER TABLE `secret_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_consumer_metadata`
--

DROP TABLE IF EXISTS `secret_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `service` varchar(255) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_consumer_resource_uc` (`secret_id`,`service`,`resource_type`,`resource_id`),
  KEY `ix_secret_consumer_metadata_secret_id` (`secret_id`),
  KEY `ix_secret_consumer_metadata_resource_id` (`resource_id`),
  KEY `ix_secret_consumer_metadata_project_id` (`project_id`),
  CONSTRAINT `fk_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `secret_consumer_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_consumer_metadata`
--

LOCK TABLES `secret_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `secret_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_store_metadata`
--

DROP TABLE IF EXISTS `secret_store_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_store_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secret_store_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_store_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_store_metadata`
--

LOCK TABLES `secret_store_metadata` WRITE;
/*!40000 ALTER TABLE `secret_store_metadata` DISABLE KEYS */;
INSERT INTO `secret_store_metadata` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `key`, `value`, `secret_id`) VALUES ('21aac29e-c365-4879-adc0-1ae932e41be7','2026-01-31 09:11:11','2026-01-31 09:12:06','2026-01-31 09:12:06',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','ec92ef3b-edd6-40a0-a6ad-12d162206d8b'),('602747f5-3a42-48db-b8fb-23456690f73c','2026-01-31 09:11:11','2026-01-31 09:12:06','2026-01-31 09:12:06',1,'PENDING','content_type','application/octet-stream','ec92ef3b-edd6-40a0-a6ad-12d162206d8b'),('6c055c80-5470-46f3-98b6-2caf5075be8d','2026-01-31 08:34:17','2026-01-31 08:36:24','2026-01-31 08:36:24',1,'PENDING','content_type','application/octet-stream','2ca6a990-a9f2-407b-95b2-5887f411722b'),('f4f44f71-8785-410d-b3f6-2a35fd130861','2026-01-31 08:34:17','2026-01-31 08:36:24','2026-01-31 08:36:24',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','2ca6a990-a9f2-407b-95b2-5887f411722b');
/*!40000 ALTER TABLE `secret_store_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_stores`
--

DROP TABLE IF EXISTS `secret_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_stores` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `store_plugin` varchar(255) NOT NULL,
  `crypto_plugin` varchar(255) DEFAULT NULL,
  `global_default` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_stores_name_uc` (`name`),
  UNIQUE KEY `_secret_stores_plugin_names_uc` (`store_plugin`,`crypto_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_stores`
--

LOCK TABLES `secret_stores` WRITE;
/*!40000 ALTER TABLE `secret_stores` DISABLE KEYS */;
INSERT INTO `secret_stores` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `store_plugin`, `crypto_plugin`, `global_default`, `name`) VALUES ('57d47ec7-37c5-47c8-900f-fecc0e376f81','2026-01-31 06:51:28','2026-01-31 06:51:28',NULL,0,'ACTIVE','store_crypto','simple_crypto',1,'Software Only Crypto');
/*!40000 ALTER TABLE `secret_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_user_metadata`
--

DROP TABLE IF EXISTS `secret_user_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_user_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_key_uc` (`secret_id`,`key`),
  KEY `ix_secret_user_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_user_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_user_metadata`
--

LOCK TABLES `secret_user_metadata` WRITE;
/*!40000 ALTER TABLE `secret_user_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_user_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secrets`
--

DROP TABLE IF EXISTS `secrets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secrets` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `secret_type` varchar(255) DEFAULT 'opaque',
  `expiration` datetime DEFAULT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secrets_project_id` (`project_id`),
  CONSTRAINT `secrets_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secrets`
--

LOCK TABLES `secrets` WRITE;
/*!40000 ALTER TABLE `secrets` DISABLE KEYS */;
INSERT INTO `secrets` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `name`, `secret_type`, `expiration`, `algorithm`, `bit_length`, `mode`, `creator_id`, `project_id`) VALUES ('2ca6a990-a9f2-407b-95b2-5887f411722b','2026-01-31 08:34:17','2026-01-31 08:36:24','2026-01-31 08:36:24',1,'ACTIVE',NULL,'symmetric',NULL,'aes',256,NULL,'eb8e3d6cd4094a62b23e39cec9023f18','82024efd-560e-4e43-ad18-d503154bf031'),('ec92ef3b-edd6-40a0-a6ad-12d162206d8b','2026-01-31 09:11:11','2026-01-31 09:12:06','2026-01-31 09:12:06',1,'ACTIVE',NULL,'symmetric',NULL,'aes',256,NULL,'ecd39871d7fd438f88b36601f25d6eb6','50856cb5-d773-4e0a-88a2-edfc3b3d51b2');
/*!40000 ALTER TABLE `secrets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_keys`
--

DROP TABLE IF EXISTS `transport_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transport_keys` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `transport_key` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_keys`
--

LOCK TABLES `transport_keys` WRITE;
/*!40000 ALTER TABLE `transport_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `cinder`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `cinder` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `cinder`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('daa98075b90d');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment_specs`
--

DROP TABLE IF EXISTS `attachment_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_attachment_specs_attachment_id` (`attachment_id`),
  CONSTRAINT `attachment_specs_ibfk_1` FOREIGN KEY (`attachment_id`) REFERENCES `volume_attachment` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment_specs`
--

LOCK TABLES `attachment_specs` WRITE;
/*!40000 ALTER TABLE `attachment_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_metadata`
--

DROP TABLE IF EXISTS `backup_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_backup_metadata_backup_id` (`backup_id`),
  CONSTRAINT `backup_metadata_ibfk_1` FOREIGN KEY (`backup_id`) REFERENCES `backups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_metadata`
--

LOCK TABLES `backup_metadata` WRITE;
/*!40000 ALTER TABLE `backup_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `container` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fail_reason` varchar(255) DEFAULT NULL,
  `service_metadata` varchar(255) DEFAULT NULL,
  `service` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `object_count` int(11) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `temp_volume_id` varchar(36) DEFAULT NULL,
  `temp_snapshot_id` varchar(36) DEFAULT NULL,
  `num_dependent_backups` int(11) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `data_timestamp` datetime DEFAULT NULL,
  `restore_volume_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
INSERT INTO `backups` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `host`, `availability_zone`, `display_name`, `display_description`, `container`, `status`, `fail_reason`, `service_metadata`, `service`, `size`, `object_count`, `parent_id`, `temp_volume_id`, `temp_snapshot_id`, `num_dependent_backups`, `snapshot_id`, `data_timestamp`, `restore_volume_id`, `encryption_key_id`) VALUES ('2026-01-31 08:58:15','2026-01-31 08:59:24','2026-01-31 08:59:27',1,'69a82e51-75e6-4706-8ee3-fb74b30544df','f0449ef7-c417-44d1-9add-b0929b3d95af','fe599a5134944b9fbf952e83fdf41c55','e458566e0de24b2fb797037d94d9014c','cinder-backup-0',NULL,'tempest-TestVolumeBackupRestore-backup-317369075',NULL,'backups','deleted',NULL,'{\"base\": \"volume-f0449ef7-c417-44d1-9add-b0929b3d95af.backup.69a82e51-75e6-4706-8ee3-fb74b30544df\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:58:15','4fa6de41-50fa-4a7f-9f53-f34c852aad03',NULL);
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cgsnapshots`
--

DROP TABLE IF EXISTS `cgsnapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cgsnapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `consistencygroup_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_cgsnapshots_consistencygroup_id` (`consistencygroup_id`),
  CONSTRAINT `cgsnapshots_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cgsnapshots`
--

LOCK TABLES `cgsnapshots` WRITE;
/*!40000 ALTER TABLE `cgsnapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `cgsnapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clusters`
--

DROP TABLE IF EXISTS `clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clusters` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`binary`,`race_preventer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clusters`
--

LOCK TABLES `clusters` WRITE;
/*!40000 ALTER TABLE `clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consistencygroups`
--

DROP TABLE IF EXISTS `consistencygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consistencygroups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `volume_type_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `source_cgid` varchar(36) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consistencygroups`
--

LOCK TABLES `consistencygroups` WRITE;
/*!40000 ALTER TABLE `consistencygroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `consistencygroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_volume_types`
--

DROP TABLE IF EXISTS `default_volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `default_volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  KEY `ix_default_volume_types_volume_type_id` (`volume_type_id`),
  CONSTRAINT `default_volume_types_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_volume_types`
--

LOCK TABLES `default_volume_types` WRITE;
/*!40000 ALTER TABLE `default_volume_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver_initiator_data`
--

DROP TABLE IF EXISTS `driver_initiator_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `driver_initiator_data` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `initiator` (`initiator`,`namespace`,`key`),
  KEY `ix_driver_initiator_data_initiator` (`initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver_initiator_data`
--

LOCK TABLES `driver_initiator_data` WRITE;
/*!40000 ALTER TABLE `driver_initiator_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `driver_initiator_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encryption`
--

DROP TABLE IF EXISTS `encryption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encryption` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `cipher` varchar(255) DEFAULT NULL,
  `control_location` varchar(255) NOT NULL,
  `key_size` int(11) DEFAULT NULL,
  `provider` varchar(255) NOT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `encryption_id` varchar(36) NOT NULL,
  PRIMARY KEY (`encryption_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encryption`
--

LOCK TABLES `encryption` WRITE;
/*!40000 ALTER TABLE `encryption` DISABLE KEYS */;
INSERT INTO `encryption` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `cipher`, `control_location`, `key_size`, `provider`, `volume_type_id`, `encryption_id`) VALUES ('2026-01-31 09:11:10',NULL,'2026-01-31 09:12:10',1,'aes-xts-plain64','front-end',256,'luks','137055c9-e6a8-42c2-a995-573f153330b6','52dd8122-e09d-4391-a074-8f80956b4497'),('2026-01-31 08:34:13',NULL,'2026-01-31 08:36:29',1,'aes-xts-plain64','front-end',256,'luks','baf04557-9b93-4186-9309-b086e77b17c8','bed45827-fedf-4f40-8c0b-e25e2729a96b');
/*!40000 ALTER TABLE `encryption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_snapshots`
--

DROP TABLE IF EXISTS `group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_snapshots_group_id` (`group_id`),
  KEY `group_snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `group_snapshots_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_snapshots`
--

LOCK TABLES `group_snapshots` WRITE;
/*!40000 ALTER TABLE `group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_projects`
--

DROP TABLE IF EXISTS `group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_type_id` (`group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `group_type_projects_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_projects`
--

LOCK TABLES `group_type_projects` WRITE;
/*!40000 ALTER TABLE `group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_specs`
--

DROP TABLE IF EXISTS `group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_type_specs_group_type_id` (`group_type_id`),
  CONSTRAINT `group_type_specs_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_specs`
--

LOCK TABLES `group_type_specs` WRITE;
/*!40000 ALTER TABLE `group_type_specs` DISABLE KEYS */;
INSERT INTO `group_type_specs` (`id`, `key`, `value`, `group_type_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'consistent_group_snapshot_enabled','<is> True','edb1757e-e3d5-4cfc-98c9-5b5a40555dc7','2026-01-31 06:51:25','2026-01-31 06:51:25',NULL,0);
/*!40000 ALTER TABLE `group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_types`
--

DROP TABLE IF EXISTS `group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_types` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_types`
--

LOCK TABLES `group_types` WRITE;
/*!40000 ALTER TABLE `group_types` DISABLE KEYS */;
INSERT INTO `group_types` (`id`, `name`, `description`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `is_public`) VALUES ('edb1757e-e3d5-4cfc-98c9-5b5a40555dc7','default_cgsnapshot_type','Default group type for migrating cgsnapshot','2026-01-31 06:51:25','2026-01-31 06:51:25',NULL,0,1);
/*!40000 ALTER TABLE `group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_volume_type_mapping`
--

DROP TABLE IF EXISTS `group_volume_type_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_volume_type_mapping` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_volume_type_mapping_group_id` (`group_id`),
  KEY `ix_group_volume_type_mapping_volume_type_id` (`volume_type_id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_volume_type_mapping`
--

LOCK TABLES `group_volume_type_mapping` WRITE;
/*!40000 ALTER TABLE `group_volume_type_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_volume_type_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `groups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `source_group_id` varchar(36) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groups_deleted_project_id_idx` (`deleted`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_volume_cache_entries`
--

DROP TABLE IF EXISTS `image_volume_cache_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_volume_cache_entries` (
  `image_updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `image_id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `size` int(11) NOT NULL,
  `last_used` datetime NOT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_volume_cache_entries_image_id` (`image_id`),
  KEY `ix_image_volume_cache_entries_host` (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_volume_cache_entries`
--

LOCK TABLES `image_volume_cache_entries` WRITE;
/*!40000 ALTER TABLE `image_volume_cache_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_volume_cache_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(36) DEFAULT NULL,
  `resource_uuid` varchar(255) DEFAULT NULL,
  `event_id` varchar(255) NOT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `action_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_messages_expires_at` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quality_of_service_specs`
--

DROP TABLE IF EXISTS `quality_of_service_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quality_of_service_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `specs_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quality_of_service_specs_specs_id` (`specs_id`),
  CONSTRAINT `quality_of_service_specs_ibfk_1` FOREIGN KEY (`specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quality_of_service_specs`
--

LOCK TABLES `quality_of_service_specs` WRITE;
/*!40000 ALTER TABLE `quality_of_service_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `quality_of_service_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
INSERT INTO `quota_classes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `class_name`, `resource`, `hard_limit`) VALUES ('2026-01-31 06:50:12',NULL,NULL,0,1,'default','volumes',10),('2026-01-31 06:50:12',NULL,NULL,0,2,'default','snapshots',10),('2026-01-31 06:50:12',NULL,NULL,0,3,'default','gigabytes',1000),('2026-01-31 06:50:12',NULL,NULL,0,4,'default','consistencygroups',10),('2026-01-31 06:50:12',NULL,NULL,0,5,'default','per_volume_gigabytes',-1),('2026-01-31 06:50:12',NULL,NULL,0,6,'default','groups',10);
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(300) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `race_preventer` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`,`race_preventer`),
  KEY `quota_usage_project_resource_idx` (`project_id`,`resource`),
  KEY `ix_quota_usages_project_id` (`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=147 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
INSERT INTO `quota_usages` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `project_id`, `resource`, `in_use`, `reserved`, `until_refresh`, `race_preventer`) VALUES ('2026-01-31 07:30:46','2026-01-31 07:32:16',NULL,0,1,'c8eab1fe01c14c5aa74f8b1c00292fee','volumes',0,0,NULL,1),('2026-01-31 07:30:46','2026-01-31 07:32:16',NULL,0,2,'c8eab1fe01c14c5aa74f8b1c00292fee','gigabytes',0,0,NULL,1),('2026-01-31 07:30:46','2026-01-31 07:32:16',NULL,0,3,'c8eab1fe01c14c5aa74f8b1c00292fee','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 07:30:46','2026-01-31 07:32:16',NULL,0,4,'c8eab1fe01c14c5aa74f8b1c00292fee','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 07:32:48','2026-01-31 07:34:09',NULL,0,5,'dfb4d4079ac944b288d5e285ce1de95a','volumes',0,0,NULL,1),('2026-01-31 07:32:48','2026-01-31 07:34:09',NULL,0,6,'dfb4d4079ac944b288d5e285ce1de95a','gigabytes',0,0,NULL,1),('2026-01-31 07:32:49','2026-01-31 07:34:09',NULL,0,7,'dfb4d4079ac944b288d5e285ce1de95a','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 07:32:49','2026-01-31 07:34:09',NULL,0,8,'dfb4d4079ac944b288d5e285ce1de95a','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 07:36:02','2026-01-31 07:37:12',NULL,0,9,'29d136be5e384689a95acd607131dfd0','volumes',0,0,NULL,1),('2026-01-31 07:36:02','2026-01-31 07:37:12',NULL,0,10,'29d136be5e384689a95acd607131dfd0','gigabytes',0,0,NULL,1),('2026-01-31 07:36:02','2026-01-31 07:37:12',NULL,0,11,'29d136be5e384689a95acd607131dfd0','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 07:36:02','2026-01-31 07:37:12',NULL,0,12,'29d136be5e384689a95acd607131dfd0','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 07:39:50','2026-01-31 07:40:10',NULL,0,13,'72635784cc4840bba682e8305945e795','volumes',0,0,NULL,1),('2026-01-31 07:39:50','2026-01-31 07:40:10',NULL,0,14,'72635784cc4840bba682e8305945e795','gigabytes',0,0,NULL,1),('2026-01-31 07:39:50','2026-01-31 07:40:10',NULL,0,15,'72635784cc4840bba682e8305945e795','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 07:39:50','2026-01-31 07:40:10',NULL,0,16,'72635784cc4840bba682e8305945e795','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 07:41:41','2026-01-31 07:42:43',NULL,0,17,'016f45da455049d7aad578f0a534a0f2','volumes',0,0,NULL,1),('2026-01-31 07:41:41','2026-01-31 07:42:43',NULL,0,18,'016f45da455049d7aad578f0a534a0f2','gigabytes',0,0,NULL,1),('2026-01-31 07:41:41','2026-01-31 07:42:43',NULL,0,19,'016f45da455049d7aad578f0a534a0f2','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 07:41:41','2026-01-31 07:42:43',NULL,0,20,'016f45da455049d7aad578f0a534a0f2','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 07:43:46','2026-01-31 07:46:36',NULL,0,21,'9ddf930129cf4e0395f8c5e70fd9eda8','volumes',0,0,NULL,1),('2026-01-31 07:43:46','2026-01-31 07:46:36',NULL,0,22,'9ddf930129cf4e0395f8c5e70fd9eda8','gigabytes',0,0,NULL,1),('2026-01-31 07:43:46','2026-01-31 07:46:36',NULL,0,23,'9ddf930129cf4e0395f8c5e70fd9eda8','volumes_multiattach',0,0,NULL,1),('2026-01-31 07:43:46','2026-01-31 07:46:36',NULL,0,24,'9ddf930129cf4e0395f8c5e70fd9eda8','gigabytes_multiattach',0,0,NULL,1),('2026-01-31 07:45:03','2026-01-31 07:49:54',NULL,0,25,'f299640bb1f64e5fa12b23955e5a2127','volumes',0,0,NULL,1),('2026-01-31 07:45:03','2026-01-31 07:49:54',NULL,0,26,'f299640bb1f64e5fa12b23955e5a2127','gigabytes',0,0,NULL,1),('2026-01-31 07:45:03','2026-01-31 07:49:54',NULL,0,27,'f299640bb1f64e5fa12b23955e5a2127','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 07:45:03','2026-01-31 07:49:54',NULL,0,28,'f299640bb1f64e5fa12b23955e5a2127','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 07:50:32','2026-01-31 07:53:22',NULL,0,29,'3264618ebdfa4478919141d5d3c4d3b3','volumes',0,0,NULL,1),('2026-01-31 07:50:32','2026-01-31 07:53:22',NULL,0,30,'3264618ebdfa4478919141d5d3c4d3b3','gigabytes',0,0,NULL,1),('2026-01-31 07:50:32','2026-01-31 07:53:22',NULL,0,31,'3264618ebdfa4478919141d5d3c4d3b3','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 07:50:32','2026-01-31 07:53:22',NULL,0,32,'3264618ebdfa4478919141d5d3c4d3b3','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 07:52:07','2026-01-31 07:53:19',NULL,0,33,'4a9ee1af66824e368ddad5ea68a3201b','volumes',0,0,NULL,1),('2026-01-31 07:52:07','2026-01-31 07:53:19',NULL,0,34,'4a9ee1af66824e368ddad5ea68a3201b','gigabytes',0,0,NULL,1),('2026-01-31 07:52:07','2026-01-31 07:53:19',NULL,0,35,'4a9ee1af66824e368ddad5ea68a3201b','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 07:52:07','2026-01-31 07:53:19',NULL,0,36,'4a9ee1af66824e368ddad5ea68a3201b','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:00:27','2026-01-31 08:02:25',NULL,0,37,'2ab30fd72657435fb442fc59a53da644','volumes',0,0,NULL,1),('2026-01-31 08:00:27','2026-01-31 08:02:25',NULL,0,38,'2ab30fd72657435fb442fc59a53da644','gigabytes',0,0,NULL,1),('2026-01-31 08:00:27','2026-01-31 08:02:25',NULL,0,39,'2ab30fd72657435fb442fc59a53da644','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:00:27','2026-01-31 08:02:25',NULL,0,40,'2ab30fd72657435fb442fc59a53da644','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:03:14','2026-01-31 08:07:16',NULL,0,41,'d352316ff6534075952e2d0c28061b09','volumes',0,0,NULL,1),('2026-01-31 08:03:14','2026-01-31 08:07:16',NULL,0,42,'d352316ff6534075952e2d0c28061b09','gigabytes',0,0,NULL,1),('2026-01-31 08:03:14','2026-01-31 08:07:16',NULL,0,43,'d352316ff6534075952e2d0c28061b09','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:03:14','2026-01-31 08:07:16',NULL,0,44,'d352316ff6534075952e2d0c28061b09','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:03:22','2026-01-31 08:06:09',NULL,0,45,'2327b93dd7d648efad6d2b303f9e462e','volumes',0,0,NULL,1),('2026-01-31 08:03:22','2026-01-31 08:06:09',NULL,0,46,'2327b93dd7d648efad6d2b303f9e462e','gigabytes',0,0,NULL,1),('2026-01-31 08:03:22','2026-01-31 08:06:09',NULL,0,47,'2327b93dd7d648efad6d2b303f9e462e','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:03:22','2026-01-31 08:06:09',NULL,0,48,'2327b93dd7d648efad6d2b303f9e462e','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:11:11','2026-01-31 08:15:46',NULL,0,49,'c3ddadeb950a490db5c99da98a32c9ec','volumes',0,0,NULL,1),('2026-01-31 08:11:11','2026-01-31 08:15:46',NULL,0,50,'c3ddadeb950a490db5c99da98a32c9ec','gigabytes',0,0,NULL,1),('2026-01-31 08:11:11','2026-01-31 08:15:46',NULL,0,51,'c3ddadeb950a490db5c99da98a32c9ec','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:11:11','2026-01-31 08:15:46',NULL,0,52,'c3ddadeb950a490db5c99da98a32c9ec','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:15:17','2026-01-31 08:18:16',NULL,0,53,'1633c84ea1bf46b080aaafd30bbcf25f','volumes',0,0,NULL,1),('2026-01-31 08:15:17','2026-01-31 08:18:16',NULL,0,54,'1633c84ea1bf46b080aaafd30bbcf25f','gigabytes',0,0,NULL,1),('2026-01-31 08:15:17','2026-01-31 08:18:16',NULL,0,55,'1633c84ea1bf46b080aaafd30bbcf25f','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:15:17','2026-01-31 08:18:16',NULL,0,56,'1633c84ea1bf46b080aaafd30bbcf25f','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:16:27','2026-01-31 08:19:02',NULL,0,57,'bda3ebf6541d46309fc9b2ce089dd857','volumes',0,0,NULL,1),('2026-01-31 08:16:28','2026-01-31 08:19:02',NULL,0,58,'bda3ebf6541d46309fc9b2ce089dd857','gigabytes',0,0,NULL,1),('2026-01-31 08:16:28','2026-01-31 08:19:02',NULL,0,59,'bda3ebf6541d46309fc9b2ce089dd857','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:16:28','2026-01-31 08:19:02',NULL,0,60,'bda3ebf6541d46309fc9b2ce089dd857','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:17:11','2026-01-31 08:20:50',NULL,0,61,'3b06982960ad4453b8e542cb6330835d','volumes',0,0,NULL,1),('2026-01-31 08:17:11','2026-01-31 08:20:50',NULL,0,62,'3b06982960ad4453b8e542cb6330835d','gigabytes',0,0,NULL,1),('2026-01-31 08:17:11','2026-01-31 08:20:50',NULL,0,63,'3b06982960ad4453b8e542cb6330835d','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:17:11','2026-01-31 08:20:50',NULL,0,64,'3b06982960ad4453b8e542cb6330835d','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:18:09','2026-01-31 08:18:20',NULL,0,65,'b2f8be0146584893ac5b769dff931958','volumes',0,0,NULL,1),('2026-01-31 08:18:09','2026-01-31 08:18:20',NULL,0,66,'b2f8be0146584893ac5b769dff931958','gigabytes',0,0,NULL,1),('2026-01-31 08:18:09','2026-01-31 08:18:20',NULL,0,67,'b2f8be0146584893ac5b769dff931958','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:18:09','2026-01-31 08:18:20',NULL,0,68,'b2f8be0146584893ac5b769dff931958','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:18:12','2026-01-31 08:18:18',NULL,0,69,'b2f8be0146584893ac5b769dff931958','snapshots',0,0,NULL,1),('2026-01-31 08:18:12','2026-01-31 08:18:18',NULL,0,70,'b2f8be0146584893ac5b769dff931958','snapshots___DEFAULT__',0,0,NULL,1),('2026-01-31 08:19:28','2026-01-31 08:22:42',NULL,0,71,'134c066ac92844ff853b216870fa8eed','volumes',0,0,NULL,1),('2026-01-31 08:19:28','2026-01-31 08:22:42',NULL,0,72,'134c066ac92844ff853b216870fa8eed','gigabytes',0,0,NULL,1),('2026-01-31 08:19:28','2026-01-31 08:22:42',NULL,0,73,'134c066ac92844ff853b216870fa8eed','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:19:28','2026-01-31 08:22:42',NULL,0,74,'134c066ac92844ff853b216870fa8eed','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:19:34','2026-01-31 08:20:05',NULL,0,75,'134c066ac92844ff853b216870fa8eed','snapshots',0,0,NULL,1),('2026-01-31 08:19:34','2026-01-31 08:20:05',NULL,0,76,'134c066ac92844ff853b216870fa8eed','snapshots___DEFAULT__',0,0,NULL,1),('2026-01-31 08:20:31','2026-01-31 08:22:55',NULL,0,77,'4849ff916e1b4e2aa162faaf2c0717a2','volumes',0,0,NULL,1),('2026-01-31 08:20:31','2026-01-31 08:22:55',NULL,0,78,'4849ff916e1b4e2aa162faaf2c0717a2','gigabytes',0,0,NULL,1),('2026-01-31 08:20:31','2026-01-31 08:22:55',NULL,0,79,'4849ff916e1b4e2aa162faaf2c0717a2','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:20:31','2026-01-31 08:22:55',NULL,0,80,'4849ff916e1b4e2aa162faaf2c0717a2','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:21:25','2026-01-31 08:23:45',NULL,0,81,'c90ea7f1be5f484bb873548236fadc00','volumes',2,0,NULL,1),('2026-01-31 08:21:25','2026-01-31 08:23:45',NULL,0,82,'c90ea7f1be5f484bb873548236fadc00','gigabytes',2,0,NULL,1),('2026-01-31 08:21:25','2026-01-31 08:23:45',NULL,0,83,'c90ea7f1be5f484bb873548236fadc00','volumes___DEFAULT__',2,0,NULL,1),('2026-01-31 08:21:25','2026-01-31 08:23:45',NULL,0,84,'c90ea7f1be5f484bb873548236fadc00','gigabytes___DEFAULT__',2,0,NULL,1),('2026-01-31 08:22:12','2026-01-31 08:25:07',NULL,0,85,'fdf18f1faf4846e2a6e2eab4ac2aec02','volumes',0,0,NULL,1),('2026-01-31 08:22:12','2026-01-31 08:25:07',NULL,0,86,'fdf18f1faf4846e2a6e2eab4ac2aec02','gigabytes',0,0,NULL,1),('2026-01-31 08:22:12','2026-01-31 08:25:07',NULL,0,87,'fdf18f1faf4846e2a6e2eab4ac2aec02','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:22:12','2026-01-31 08:25:07',NULL,0,88,'fdf18f1faf4846e2a6e2eab4ac2aec02','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:24:31','2026-01-31 08:32:17',NULL,0,89,'48bbdbdee526499e90da7e971ede68d3','volumes',0,0,NULL,1),('2026-01-31 08:24:31','2026-01-31 08:32:17',NULL,0,90,'48bbdbdee526499e90da7e971ede68d3','gigabytes',0,0,NULL,1),('2026-01-31 08:24:31','2026-01-31 08:32:17',NULL,0,91,'48bbdbdee526499e90da7e971ede68d3','volumes_multiattach',0,0,NULL,1),('2026-01-31 08:24:31','2026-01-31 08:32:17',NULL,0,92,'48bbdbdee526499e90da7e971ede68d3','gigabytes_multiattach',0,0,NULL,1),('2026-01-31 08:27:07','2026-01-31 08:32:05',NULL,0,93,'418d5319c640455ab23850c0b0f24f92','volumes',0,0,NULL,1),('2026-01-31 08:27:07','2026-01-31 08:32:05',NULL,0,94,'418d5319c640455ab23850c0b0f24f92','gigabytes',0,0,NULL,1),('2026-01-31 08:27:07','2026-01-31 08:32:05',NULL,0,95,'418d5319c640455ab23850c0b0f24f92','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:27:07','2026-01-31 08:32:05',NULL,0,96,'418d5319c640455ab23850c0b0f24f92','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:29:04','2026-01-31 08:33:17',NULL,0,97,'722ab2e9dd674709953be812d4c88493','volumes',0,0,NULL,1),('2026-01-31 08:29:04','2026-01-31 08:33:17',NULL,0,98,'722ab2e9dd674709953be812d4c88493','gigabytes',0,0,NULL,1),('2026-01-31 08:29:04','2026-01-31 08:33:17',NULL,0,99,'722ab2e9dd674709953be812d4c88493','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:29:04','2026-01-31 08:33:17',NULL,0,100,'722ab2e9dd674709953be812d4c88493','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:30:29','2026-01-31 08:30:48',NULL,0,101,'48bbdbdee526499e90da7e971ede68d3','snapshots',0,0,NULL,1),('2026-01-31 08:30:29','2026-01-31 08:30:48',NULL,0,102,'48bbdbdee526499e90da7e971ede68d3','snapshots_multiattach',0,0,NULL,1),('2026-01-31 08:32:33','2026-01-31 08:32:38',NULL,0,103,'b71e7a1d6f714f7680acaa04670308f6','volumes',0,0,NULL,1),('2026-01-31 08:32:33','2026-01-31 08:32:38',NULL,0,104,'b71e7a1d6f714f7680acaa04670308f6','gigabytes',0,0,NULL,1),('2026-01-31 08:32:33','2026-01-31 08:32:38',NULL,0,105,'b71e7a1d6f714f7680acaa04670308f6','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:32:33','2026-01-31 08:32:38',NULL,0,106,'b71e7a1d6f714f7680acaa04670308f6','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:32:51','2026-01-31 08:33:25',NULL,0,107,'92845e9c9ab24edbb2412cff577a0903','volumes',0,0,NULL,1),('2026-01-31 08:32:51','2026-01-31 08:33:25',NULL,0,108,'92845e9c9ab24edbb2412cff577a0903','gigabytes',0,0,NULL,1),('2026-01-31 08:32:51','2026-01-31 08:33:25',NULL,0,109,'92845e9c9ab24edbb2412cff577a0903','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:32:51','2026-01-31 08:33:25',NULL,0,110,'92845e9c9ab24edbb2412cff577a0903','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:34:19','2026-01-31 08:36:28',NULL,0,111,'149ccba7b87e4284a3a6462e3a1dace1','volumes',0,0,NULL,1),('2026-01-31 08:34:20','2026-01-31 08:36:28',NULL,0,112,'149ccba7b87e4284a3a6462e3a1dace1','gigabytes',0,0,NULL,1),('2026-01-31 08:34:20','2026-01-31 08:36:28',NULL,0,113,'149ccba7b87e4284a3a6462e3a1dace1','volumes_tempest-scenario-type-luks-1109613392',0,0,NULL,1),('2026-01-31 08:34:20','2026-01-31 08:36:28',NULL,0,114,'149ccba7b87e4284a3a6462e3a1dace1','gigabytes_tempest-scenario-type-luks-1109613392',0,0,NULL,1),('2026-01-31 08:38:10','2026-01-31 08:43:49',NULL,0,115,'4b38141686534a0fb9b947a7886cd4b6','volumes',0,0,NULL,1),('2026-01-31 08:38:10','2026-01-31 08:43:49',NULL,0,116,'4b38141686534a0fb9b947a7886cd4b6','gigabytes',0,0,NULL,1),('2026-01-31 08:38:10','2026-01-31 08:42:10',NULL,0,117,'4b38141686534a0fb9b947a7886cd4b6','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-580248439-755666519',0,0,NULL,1),('2026-01-31 08:38:10','2026-01-31 08:42:10',NULL,0,118,'4b38141686534a0fb9b947a7886cd4b6','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-580248439-755666519',0,0,NULL,1),('2026-01-31 08:38:10','2026-01-31 08:42:18',NULL,0,119,'4b38141686534a0fb9b947a7886cd4b6','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-350934863-1039133705',0,0,NULL,1),('2026-01-31 08:38:10','2026-01-31 08:42:18',NULL,0,120,'4b38141686534a0fb9b947a7886cd4b6','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-350934863-1039133705',0,0,NULL,1),('2026-01-31 08:38:13','2026-01-31 08:43:49',NULL,0,121,'4b38141686534a0fb9b947a7886cd4b6','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-519012021-1114870271',0,0,NULL,1),('2026-01-31 08:38:13','2026-01-31 08:43:49',NULL,0,122,'4b38141686534a0fb9b947a7886cd4b6','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-519012021-1114870271',0,0,NULL,1),('2026-01-31 08:53:57','2026-01-31 08:56:43',NULL,0,123,'e6e96de7b2784be1adce763bc9c9adc5','volumes',0,0,NULL,1),('2026-01-31 08:53:57','2026-01-31 08:56:43',NULL,0,124,'e6e96de7b2784be1adce763bc9c9adc5','gigabytes',0,0,NULL,1),('2026-01-31 08:53:57','2026-01-31 08:56:43',NULL,0,125,'e6e96de7b2784be1adce763bc9c9adc5','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:53:57','2026-01-31 08:56:43',NULL,0,126,'e6e96de7b2784be1adce763bc9c9adc5','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:54:49','2026-01-31 08:56:26',NULL,0,127,'e6e96de7b2784be1adce763bc9c9adc5','snapshots',0,0,NULL,1),('2026-01-31 08:54:49','2026-01-31 08:56:26',NULL,0,128,'e6e96de7b2784be1adce763bc9c9adc5','snapshots___DEFAULT__',0,0,NULL,1),('2026-01-31 08:58:04','2026-01-31 08:59:28',NULL,0,129,'e458566e0de24b2fb797037d94d9014c','volumes',0,0,NULL,1),('2026-01-31 08:58:04','2026-01-31 08:59:28',NULL,0,130,'e458566e0de24b2fb797037d94d9014c','gigabytes',0,0,NULL,1),('2026-01-31 08:58:04','2026-01-31 08:59:28',NULL,0,131,'e458566e0de24b2fb797037d94d9014c','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:58:04','2026-01-31 08:59:28',NULL,0,132,'e458566e0de24b2fb797037d94d9014c','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:58:15','2026-01-31 08:59:28',NULL,0,133,'e458566e0de24b2fb797037d94d9014c','backups',0,0,NULL,1),('2026-01-31 08:58:15','2026-01-31 08:59:28',NULL,0,134,'e458566e0de24b2fb797037d94d9014c','backup_gigabytes',0,0,NULL,1),('2026-01-31 09:08:09','2026-01-31 09:09:54',NULL,0,135,'496e06c7521f45c994e6426c4313acea','volumes',0,0,NULL,1),('2026-01-31 09:08:09','2026-01-31 09:09:54',NULL,0,136,'496e06c7521f45c994e6426c4313acea','gigabytes',0,0,NULL,1),('2026-01-31 09:08:09','2026-01-31 09:09:54',NULL,0,137,'496e06c7521f45c994e6426c4313acea','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 09:08:09','2026-01-31 09:09:54',NULL,0,138,'496e06c7521f45c994e6426c4313acea','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 09:11:11','2026-01-31 09:19:17',NULL,0,139,'98d10c0290e340a08e9d1726bf0066bf','volumes',0,0,NULL,1),('2026-01-31 09:11:11','2026-01-31 09:19:17',NULL,0,140,'98d10c0290e340a08e9d1726bf0066bf','gigabytes',0,0,NULL,1),('2026-01-31 09:11:11','2026-01-31 09:12:09',NULL,0,141,'98d10c0290e340a08e9d1726bf0066bf','volumes_tempest-scenario-type-luks-1946719417',0,0,NULL,1),('2026-01-31 09:11:11','2026-01-31 09:12:09',NULL,0,142,'98d10c0290e340a08e9d1726bf0066bf','gigabytes_tempest-scenario-type-luks-1946719417',0,0,NULL,1),('2026-01-31 09:12:12','2026-01-31 09:19:17',NULL,0,143,'98d10c0290e340a08e9d1726bf0066bf','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 09:12:12','2026-01-31 09:19:17',NULL,0,144,'98d10c0290e340a08e9d1726bf0066bf','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 09:12:28','2026-01-31 09:19:03',NULL,0,145,'98d10c0290e340a08e9d1726bf0066bf','snapshots',0,0,NULL,1),('2026-01-31 09:12:28','2026-01-31 09:19:03',NULL,0,146,'98d10c0290e340a08e9d1726bf0066bf','snapshots___DEFAULT__',0,0,NULL,1);
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `allocated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `allocated_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `ix_reservations_allocated_id` (`allocated_id`),
  KEY `reservations_deleted_uuid_idx` (`deleted`,`uuid`),
  KEY `ix_reservations_usage_id` (`usage_id`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`),
  CONSTRAINT `reservations_ibfk_2` FOREIGN KEY (`allocated_id`) REFERENCES `quotas` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=605 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
INSERT INTO `reservations` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `uuid`, `usage_id`, `project_id`, `resource`, `delta`, `expire`, `allocated_id`) VALUES ('2026-01-31 07:30:46','2026-01-31 07:30:46','2026-01-31 07:30:46',1,1,'45c73ea0-a27b-445d-8746-f3066d7ca92a',1,'c8eab1fe01c14c5aa74f8b1c00292fee','volumes',1,'2026-02-01 07:30:46',NULL),('2026-01-31 07:30:46','2026-01-31 07:30:46','2026-01-31 07:30:46',1,2,'2125e38c-e116-450d-9c06-d3976774018b',2,'c8eab1fe01c14c5aa74f8b1c00292fee','gigabytes',1,'2026-02-01 07:30:46',NULL),('2026-01-31 07:30:46','2026-01-31 07:30:46','2026-01-31 07:30:46',1,3,'1619c716-941f-43d6-9e8a-876805ed5c6c',3,'c8eab1fe01c14c5aa74f8b1c00292fee','volumes___DEFAULT__',1,'2026-02-01 07:30:46',NULL),('2026-01-31 07:30:46','2026-01-31 07:30:46','2026-01-31 07:30:46',1,4,'905b7cab-f62e-4d49-8662-79f6d15d089f',4,'c8eab1fe01c14c5aa74f8b1c00292fee','gigabytes___DEFAULT__',1,'2026-02-01 07:30:46',NULL),('2026-01-31 07:32:14','2026-01-31 07:32:16','2026-01-31 07:32:16',1,5,'f4658e4b-b478-450a-98f2-9d55b6fe4e63',1,'c8eab1fe01c14c5aa74f8b1c00292fee','volumes',-1,'2026-02-01 07:32:14',NULL),('2026-01-31 07:32:14','2026-01-31 07:32:16','2026-01-31 07:32:16',1,6,'0103d5cf-9e1a-41ba-b0ac-26e726ef400b',2,'c8eab1fe01c14c5aa74f8b1c00292fee','gigabytes',-1,'2026-02-01 07:32:14',NULL),('2026-01-31 07:32:14','2026-01-31 07:32:16','2026-01-31 07:32:16',1,7,'b4047b23-3f06-4663-a862-358f92f66b8f',3,'c8eab1fe01c14c5aa74f8b1c00292fee','volumes___DEFAULT__',-1,'2026-02-01 07:32:14',NULL),('2026-01-31 07:32:14','2026-01-31 07:32:16','2026-01-31 07:32:16',1,8,'c2da31a6-0e36-406a-a087-06addd13da20',4,'c8eab1fe01c14c5aa74f8b1c00292fee','gigabytes___DEFAULT__',-1,'2026-02-01 07:32:14',NULL),('2026-01-31 07:32:49','2026-01-31 07:32:49','2026-01-31 07:32:49',1,9,'b3f20839-8c24-409b-96d7-bbb647866702',5,'dfb4d4079ac944b288d5e285ce1de95a','volumes',1,'2026-02-01 07:32:48',NULL),('2026-01-31 07:32:49','2026-01-31 07:32:49','2026-01-31 07:32:49',1,10,'22a9b126-bc90-4d5b-b983-22ba543c5361',6,'dfb4d4079ac944b288d5e285ce1de95a','gigabytes',1,'2026-02-01 07:32:48',NULL),('2026-01-31 07:32:49','2026-01-31 07:32:49','2026-01-31 07:32:49',1,11,'2c564361-26f9-4e15-9945-3cc153ac8d8b',7,'dfb4d4079ac944b288d5e285ce1de95a','volumes___DEFAULT__',1,'2026-02-01 07:32:48',NULL),('2026-01-31 07:32:49','2026-01-31 07:32:49','2026-01-31 07:32:49',1,12,'4996d82f-9658-413b-9bac-46d5f34c829f',8,'dfb4d4079ac944b288d5e285ce1de95a','gigabytes___DEFAULT__',1,'2026-02-01 07:32:48',NULL),('2026-01-31 07:34:09','2026-01-31 07:34:09','2026-01-31 07:34:09',1,13,'63c3bda4-fad4-4a66-a123-30422c61930b',5,'dfb4d4079ac944b288d5e285ce1de95a','volumes',-1,'2026-02-01 07:34:09',NULL),('2026-01-31 07:34:09','2026-01-31 07:34:09','2026-01-31 07:34:09',1,14,'08b94be5-f265-4918-9e4f-b9132da761ff',6,'dfb4d4079ac944b288d5e285ce1de95a','gigabytes',-1,'2026-02-01 07:34:09',NULL),('2026-01-31 07:34:09','2026-01-31 07:34:09','2026-01-31 07:34:09',1,15,'ff7ae603-a890-4c1e-a415-24bfb910593a',7,'dfb4d4079ac944b288d5e285ce1de95a','volumes___DEFAULT__',-1,'2026-02-01 07:34:09',NULL),('2026-01-31 07:34:09','2026-01-31 07:34:09','2026-01-31 07:34:09',1,16,'bedba02b-8f4b-493c-8eef-8fe225ebe290',8,'dfb4d4079ac944b288d5e285ce1de95a','gigabytes___DEFAULT__',-1,'2026-02-01 07:34:09',NULL),('2026-01-31 07:36:02','2026-01-31 07:36:03','2026-01-31 07:36:03',1,17,'fdef8d42-bf51-422a-96a4-37e4650446a5',9,'29d136be5e384689a95acd607131dfd0','volumes',1,'2026-02-01 07:36:02',NULL),('2026-01-31 07:36:02','2026-01-31 07:36:03','2026-01-31 07:36:03',1,18,'bd3c6734-ba38-4df7-984f-fb6f00920f8f',10,'29d136be5e384689a95acd607131dfd0','gigabytes',1,'2026-02-01 07:36:02',NULL),('2026-01-31 07:36:02','2026-01-31 07:36:03','2026-01-31 07:36:03',1,19,'3d828ea1-8ecb-478b-a035-7b3cbf1e7897',11,'29d136be5e384689a95acd607131dfd0','volumes___DEFAULT__',1,'2026-02-01 07:36:02',NULL),('2026-01-31 07:36:02','2026-01-31 07:36:03','2026-01-31 07:36:03',1,20,'42e2d586-48a0-490b-93ab-ef6fcaec8905',12,'29d136be5e384689a95acd607131dfd0','gigabytes___DEFAULT__',1,'2026-02-01 07:36:02',NULL),('2026-01-31 07:37:12','2026-01-31 07:37:12','2026-01-31 07:37:12',1,21,'769b1429-45ec-4f06-ab24-04de429595ea',9,'29d136be5e384689a95acd607131dfd0','volumes',-1,'2026-02-01 07:37:12',NULL),('2026-01-31 07:37:12','2026-01-31 07:37:12','2026-01-31 07:37:12',1,22,'da2aa770-d282-4504-a7c3-aa3c5489e632',10,'29d136be5e384689a95acd607131dfd0','gigabytes',-1,'2026-02-01 07:37:12',NULL),('2026-01-31 07:37:12','2026-01-31 07:37:12','2026-01-31 07:37:12',1,23,'4070fefd-1933-4747-a184-d73b148e5cc5',11,'29d136be5e384689a95acd607131dfd0','volumes___DEFAULT__',-1,'2026-02-01 07:37:12',NULL),('2026-01-31 07:37:12','2026-01-31 07:37:12','2026-01-31 07:37:12',1,24,'b7a75747-ad1e-4bd8-83b9-f7166598a22a',12,'29d136be5e384689a95acd607131dfd0','gigabytes___DEFAULT__',-1,'2026-02-01 07:37:12',NULL),('2026-01-31 07:39:50','2026-01-31 07:39:50','2026-01-31 07:39:50',1,25,'e274282f-f777-4aad-ae8a-4a162c13ef00',13,'72635784cc4840bba682e8305945e795','volumes',1,'2026-02-01 07:39:50',NULL),('2026-01-31 07:39:50','2026-01-31 07:39:50','2026-01-31 07:39:50',1,26,'680d70c9-51f5-4229-b536-cbf58b07ad79',14,'72635784cc4840bba682e8305945e795','gigabytes',1,'2026-02-01 07:39:50',NULL),('2026-01-31 07:39:50','2026-01-31 07:39:50','2026-01-31 07:39:50',1,27,'0579ada1-0c57-47ea-a0f3-ba39ff2b809c',15,'72635784cc4840bba682e8305945e795','volumes___DEFAULT__',1,'2026-02-01 07:39:50',NULL),('2026-01-31 07:39:50','2026-01-31 07:39:50','2026-01-31 07:39:50',1,28,'648929aa-ab83-4111-a9c2-c0db239f73ca',16,'72635784cc4840bba682e8305945e795','gigabytes___DEFAULT__',1,'2026-02-01 07:39:50',NULL),('2026-01-31 07:40:10','2026-01-31 07:40:10','2026-01-31 07:40:10',1,29,'695041f5-a4bf-4e68-8027-40e056493645',13,'72635784cc4840bba682e8305945e795','volumes',-1,'2026-02-01 07:40:10',NULL),('2026-01-31 07:40:10','2026-01-31 07:40:10','2026-01-31 07:40:10',1,30,'37e24492-2d52-4fdf-ad4c-c7a6e23d9335',14,'72635784cc4840bba682e8305945e795','gigabytes',-1,'2026-02-01 07:40:10',NULL),('2026-01-31 07:40:10','2026-01-31 07:40:10','2026-01-31 07:40:10',1,31,'ef8d87d1-6454-46d6-ae74-e7d04bf022aa',15,'72635784cc4840bba682e8305945e795','volumes___DEFAULT__',-1,'2026-02-01 07:40:10',NULL),('2026-01-31 07:40:10','2026-01-31 07:40:10','2026-01-31 07:40:10',1,32,'c772676f-3f59-4e52-80b1-b0da547939e6',16,'72635784cc4840bba682e8305945e795','gigabytes___DEFAULT__',-1,'2026-02-01 07:40:10',NULL),('2026-01-31 07:41:41','2026-01-31 07:41:42','2026-01-31 07:41:42',1,33,'146d34e4-849a-4d3f-8d77-7b5656834f03',17,'016f45da455049d7aad578f0a534a0f2','volumes',1,'2026-02-01 07:41:41',NULL),('2026-01-31 07:41:41','2026-01-31 07:41:42','2026-01-31 07:41:42',1,34,'59b98192-371c-4f46-8ef6-5eba1f298026',18,'016f45da455049d7aad578f0a534a0f2','gigabytes',1,'2026-02-01 07:41:41',NULL),('2026-01-31 07:41:41','2026-01-31 07:41:42','2026-01-31 07:41:42',1,35,'2deb2b9b-41b7-483e-991c-a8aa74fe3eac',19,'016f45da455049d7aad578f0a534a0f2','volumes___DEFAULT__',1,'2026-02-01 07:41:41',NULL),('2026-01-31 07:41:41','2026-01-31 07:41:42','2026-01-31 07:41:42',1,36,'9947f6ad-c806-4eb0-b2e4-ead1bacf736d',20,'016f45da455049d7aad578f0a534a0f2','gigabytes___DEFAULT__',1,'2026-02-01 07:41:41',NULL),('2026-01-31 07:42:26','2026-01-31 07:42:26','2026-01-31 07:42:26',1,37,'6bb15337-3dd5-47c1-9242-280c8590445f',17,'016f45da455049d7aad578f0a534a0f2','volumes',1,'2026-02-01 07:42:26',NULL),('2026-01-31 07:42:26','2026-01-31 07:42:26','2026-01-31 07:42:26',1,38,'62ec4790-70a7-4050-b1cf-73dbb6dbc40d',18,'016f45da455049d7aad578f0a534a0f2','gigabytes',1,'2026-02-01 07:42:26',NULL),('2026-01-31 07:42:26','2026-01-31 07:42:26','2026-01-31 07:42:26',1,39,'305bb268-1f4b-4189-9460-36b544d3ef29',19,'016f45da455049d7aad578f0a534a0f2','volumes___DEFAULT__',1,'2026-02-01 07:42:26',NULL),('2026-01-31 07:42:26','2026-01-31 07:42:26','2026-01-31 07:42:26',1,40,'bc045d2a-3718-48f6-a1b4-36215e7bd3b9',20,'016f45da455049d7aad578f0a534a0f2','gigabytes___DEFAULT__',1,'2026-02-01 07:42:26',NULL),('2026-01-31 07:42:29','2026-01-31 07:42:29','2026-01-31 07:42:29',1,41,'181835d6-06af-40ed-82ba-973e259a54cb',17,'016f45da455049d7aad578f0a534a0f2','volumes',-1,'2026-02-01 07:42:29',NULL),('2026-01-31 07:42:29','2026-01-31 07:42:29','2026-01-31 07:42:29',1,42,'e32b1629-cbf1-4be6-9796-2869cea40b61',18,'016f45da455049d7aad578f0a534a0f2','gigabytes',-1,'2026-02-01 07:42:29',NULL),('2026-01-31 07:42:29','2026-01-31 07:42:29','2026-01-31 07:42:29',1,43,'bb12fb9c-0a34-4144-a9ae-70a12ef6b34b',19,'016f45da455049d7aad578f0a534a0f2','volumes___DEFAULT__',-1,'2026-02-01 07:42:29',NULL),('2026-01-31 07:42:29','2026-01-31 07:42:29','2026-01-31 07:42:29',1,44,'e82c8446-5bd8-43c0-85b2-35ba091f121a',20,'016f45da455049d7aad578f0a534a0f2','gigabytes___DEFAULT__',-1,'2026-02-01 07:42:29',NULL),('2026-01-31 07:42:43','2026-01-31 07:42:43','2026-01-31 07:42:43',1,45,'20d8e909-d605-45da-b43c-4f50e07ecd7c',17,'016f45da455049d7aad578f0a534a0f2','volumes',-1,'2026-02-01 07:42:43',NULL),('2026-01-31 07:42:43','2026-01-31 07:42:43','2026-01-31 07:42:43',1,46,'ea0a2721-67a1-4dcd-8c74-6d369d13e6a9',18,'016f45da455049d7aad578f0a534a0f2','gigabytes',-1,'2026-02-01 07:42:43',NULL),('2026-01-31 07:42:43','2026-01-31 07:42:43','2026-01-31 07:42:43',1,47,'62b7652b-e7a3-444b-80a7-ac20d5a45dea',19,'016f45da455049d7aad578f0a534a0f2','volumes___DEFAULT__',-1,'2026-02-01 07:42:43',NULL),('2026-01-31 07:42:43','2026-01-31 07:42:43','2026-01-31 07:42:43',1,48,'36178496-25db-443d-ac88-c300ff61f8b3',20,'016f45da455049d7aad578f0a534a0f2','gigabytes___DEFAULT__',-1,'2026-02-01 07:42:43',NULL),('2026-01-31 07:43:47','2026-01-31 07:43:47','2026-01-31 07:43:47',1,49,'283c6019-6caf-43dc-95c7-cceffa39b369',21,'9ddf930129cf4e0395f8c5e70fd9eda8','volumes',1,'2026-02-01 07:43:46',NULL),('2026-01-31 07:43:47','2026-01-31 07:43:47','2026-01-31 07:43:47',1,50,'89b1b59a-52aa-4b21-b181-827fe7f9c83f',22,'9ddf930129cf4e0395f8c5e70fd9eda8','gigabytes',1,'2026-02-01 07:43:46',NULL),('2026-01-31 07:43:47','2026-01-31 07:43:47','2026-01-31 07:43:47',1,51,'9744d880-c9c5-45ac-9997-2e48645c61b5',23,'9ddf930129cf4e0395f8c5e70fd9eda8','volumes_multiattach',1,'2026-02-01 07:43:46',NULL),('2026-01-31 07:43:47','2026-01-31 07:43:47','2026-01-31 07:43:47',1,52,'5451b276-6c26-48bb-ab20-deaa98dcec6d',24,'9ddf930129cf4e0395f8c5e70fd9eda8','gigabytes_multiattach',1,'2026-02-01 07:43:46',NULL),('2026-01-31 07:43:52','2026-01-31 07:43:52','2026-01-31 07:43:52',1,53,'5e69602e-3246-4491-b291-56aae780f77f',21,'9ddf930129cf4e0395f8c5e70fd9eda8','volumes',1,'2026-02-01 07:43:52',NULL),('2026-01-31 07:43:52','2026-01-31 07:43:52','2026-01-31 07:43:52',1,54,'73512563-3ef2-4bf9-b18c-8f2cf2c01ae7',22,'9ddf930129cf4e0395f8c5e70fd9eda8','gigabytes',1,'2026-02-01 07:43:52',NULL),('2026-01-31 07:43:52','2026-01-31 07:43:52','2026-01-31 07:43:52',1,55,'4e81ca38-4472-4190-8417-5aab4cf68d2a',23,'9ddf930129cf4e0395f8c5e70fd9eda8','volumes_multiattach',1,'2026-02-01 07:43:52',NULL),('2026-01-31 07:43:52','2026-01-31 07:43:52','2026-01-31 07:43:52',1,56,'e46a71aa-f2ce-4e7e-84e5-5d86e6d3c794',24,'9ddf930129cf4e0395f8c5e70fd9eda8','gigabytes_multiattach',1,'2026-02-01 07:43:52',NULL),('2026-01-31 07:45:03','2026-01-31 07:45:03','2026-01-31 07:45:03',1,57,'0b1c41af-c6f6-4b85-962f-8beaeaac7fde',25,'f299640bb1f64e5fa12b23955e5a2127','volumes',1,'2026-02-01 07:45:03',NULL),('2026-01-31 07:45:03','2026-01-31 07:45:03','2026-01-31 07:45:03',1,58,'b5822392-271e-453b-82ec-aa66794b3ab7',26,'f299640bb1f64e5fa12b23955e5a2127','gigabytes',1,'2026-02-01 07:45:03',NULL),('2026-01-31 07:45:03','2026-01-31 07:45:03','2026-01-31 07:45:03',1,59,'3eb0edc0-ebc3-4387-889b-1a3e18a401f9',27,'f299640bb1f64e5fa12b23955e5a2127','volumes___DEFAULT__',1,'2026-02-01 07:45:03',NULL),('2026-01-31 07:45:03','2026-01-31 07:45:03','2026-01-31 07:45:03',1,60,'05a5f6eb-dd8b-40cc-8903-437e5ae44975',28,'f299640bb1f64e5fa12b23955e5a2127','gigabytes___DEFAULT__',1,'2026-02-01 07:45:03',NULL),('2026-01-31 07:46:30','2026-01-31 07:46:30','2026-01-31 07:46:30',1,61,'bf5f596c-8d80-43e6-bad1-a15bcf657789',21,'9ddf930129cf4e0395f8c5e70fd9eda8','volumes',-1,'2026-02-01 07:46:30',NULL),('2026-01-31 07:46:30','2026-01-31 07:46:30','2026-01-31 07:46:30',1,62,'684eacdf-044b-4b40-a17b-fb752dbfd07e',22,'9ddf930129cf4e0395f8c5e70fd9eda8','gigabytes',-1,'2026-02-01 07:46:30',NULL),('2026-01-31 07:46:30','2026-01-31 07:46:30','2026-01-31 07:46:30',1,63,'f70c4f82-ab74-4d12-af88-f73da38d384b',23,'9ddf930129cf4e0395f8c5e70fd9eda8','volumes_multiattach',-1,'2026-02-01 07:46:30',NULL),('2026-01-31 07:46:30','2026-01-31 07:46:30','2026-01-31 07:46:30',1,64,'a7d790e4-3292-4383-bd9b-fdc4bd206654',24,'9ddf930129cf4e0395f8c5e70fd9eda8','gigabytes_multiattach',-1,'2026-02-01 07:46:30',NULL),('2026-01-31 07:46:36','2026-01-31 07:46:36','2026-01-31 07:46:36',1,65,'63e6a021-3a0d-4d24-adab-051f9f76774a',21,'9ddf930129cf4e0395f8c5e70fd9eda8','volumes',-1,'2026-02-01 07:46:36',NULL),('2026-01-31 07:46:36','2026-01-31 07:46:36','2026-01-31 07:46:36',1,66,'f114d1b7-82b5-431b-bfb3-ffdc7fbb3bb0',22,'9ddf930129cf4e0395f8c5e70fd9eda8','gigabytes',-1,'2026-02-01 07:46:36',NULL),('2026-01-31 07:46:36','2026-01-31 07:46:36','2026-01-31 07:46:36',1,67,'e9510974-6942-431a-880f-f4e40e5d87d7',23,'9ddf930129cf4e0395f8c5e70fd9eda8','volumes_multiattach',-1,'2026-02-01 07:46:36',NULL),('2026-01-31 07:46:36','2026-01-31 07:46:36','2026-01-31 07:46:36',1,68,'57d075ab-0c3c-4901-8401-38a120f7d627',24,'9ddf930129cf4e0395f8c5e70fd9eda8','gigabytes_multiattach',-1,'2026-02-01 07:46:36',NULL),('2026-01-31 07:49:54','2026-01-31 07:49:54','2026-01-31 07:49:54',1,69,'7cb2e582-a010-4cd9-a16f-98677981442c',25,'f299640bb1f64e5fa12b23955e5a2127','volumes',-1,'2026-02-01 07:49:54',NULL),('2026-01-31 07:49:54','2026-01-31 07:49:54','2026-01-31 07:49:54',1,70,'6b1c06eb-cf8c-418a-90e0-dd7967e3be98',26,'f299640bb1f64e5fa12b23955e5a2127','gigabytes',-1,'2026-02-01 07:49:54',NULL),('2026-01-31 07:49:54','2026-01-31 07:49:54','2026-01-31 07:49:54',1,71,'2c86ecb3-9819-49c1-94f2-fccc3ec08f53',27,'f299640bb1f64e5fa12b23955e5a2127','volumes___DEFAULT__',-1,'2026-02-01 07:49:54',NULL),('2026-01-31 07:49:54','2026-01-31 07:49:54','2026-01-31 07:49:54',1,72,'149b4f73-491e-4e96-ad58-2317d5430b9b',28,'f299640bb1f64e5fa12b23955e5a2127','gigabytes___DEFAULT__',-1,'2026-02-01 07:49:54',NULL),('2026-01-31 07:50:32','2026-01-31 07:50:32','2026-01-31 07:50:32',1,73,'e7999e8b-10bf-428e-a10e-bc034ab6e412',29,'3264618ebdfa4478919141d5d3c4d3b3','volumes',1,'2026-02-01 07:50:32',NULL),('2026-01-31 07:50:32','2026-01-31 07:50:32','2026-01-31 07:50:32',1,74,'04247248-7503-4eee-9fd2-fced176bad0c',30,'3264618ebdfa4478919141d5d3c4d3b3','gigabytes',1,'2026-02-01 07:50:32',NULL),('2026-01-31 07:50:32','2026-01-31 07:50:32','2026-01-31 07:50:32',1,75,'31026ca2-c8ba-4a00-88e8-022cf71f0032',31,'3264618ebdfa4478919141d5d3c4d3b3','volumes___DEFAULT__',1,'2026-02-01 07:50:32',NULL),('2026-01-31 07:50:32','2026-01-31 07:50:32','2026-01-31 07:50:32',1,76,'a44be33b-9a56-42cc-bbf4-e5268c4e33fc',32,'3264618ebdfa4478919141d5d3c4d3b3','gigabytes___DEFAULT__',1,'2026-02-01 07:50:32',NULL),('2026-01-31 07:50:41','2026-01-31 07:50:41','2026-01-31 07:50:41',1,77,'585c8fb0-f6e6-47d3-a26a-bd679fb9f085',29,'3264618ebdfa4478919141d5d3c4d3b3','volumes',1,'2026-02-01 07:50:41',NULL),('2026-01-31 07:50:41','2026-01-31 07:50:41','2026-01-31 07:50:41',1,78,'6fd68020-7ba6-42e8-a7fe-982eb22531df',30,'3264618ebdfa4478919141d5d3c4d3b3','gigabytes',1,'2026-02-01 07:50:41',NULL),('2026-01-31 07:50:41','2026-01-31 07:50:41','2026-01-31 07:50:41',1,79,'d84220bf-b6f7-4724-9a4c-1062b06b1b2d',31,'3264618ebdfa4478919141d5d3c4d3b3','volumes___DEFAULT__',1,'2026-02-01 07:50:41',NULL),('2026-01-31 07:50:41','2026-01-31 07:50:41','2026-01-31 07:50:41',1,80,'3b4ae506-8cd3-4e40-a9d9-e057bbe1b0ee',32,'3264618ebdfa4478919141d5d3c4d3b3','gigabytes___DEFAULT__',1,'2026-02-01 07:50:41',NULL),('2026-01-31 07:50:43','2026-01-31 07:50:43','2026-01-31 07:50:43',1,81,'bbbbf355-83ec-42f5-a00a-609978c7bb33',29,'3264618ebdfa4478919141d5d3c4d3b3','volumes',1,'2026-02-01 07:50:43',NULL),('2026-01-31 07:50:43','2026-01-31 07:50:43','2026-01-31 07:50:43',1,82,'41d0809e-4c6e-49a2-b03c-c333587364b7',30,'3264618ebdfa4478919141d5d3c4d3b3','gigabytes',1,'2026-02-01 07:50:43',NULL),('2026-01-31 07:50:43','2026-01-31 07:50:43','2026-01-31 07:50:43',1,83,'115c24d1-6c19-4fc6-9f90-143d00b84c8f',31,'3264618ebdfa4478919141d5d3c4d3b3','volumes___DEFAULT__',1,'2026-02-01 07:50:43',NULL),('2026-01-31 07:50:43','2026-01-31 07:50:43','2026-01-31 07:50:43',1,84,'2f197e27-06ba-4440-be64-8e441fea7db4',32,'3264618ebdfa4478919141d5d3c4d3b3','gigabytes___DEFAULT__',1,'2026-02-01 07:50:43',NULL),('2026-01-31 07:52:07','2026-01-31 07:52:11','2026-01-31 07:52:11',1,85,'38adac44-eef0-4210-921a-2b7e69cb2a11',33,'4a9ee1af66824e368ddad5ea68a3201b','volumes',1,'2026-02-01 07:52:07',NULL),('2026-01-31 07:52:07','2026-01-31 07:52:11','2026-01-31 07:52:11',1,86,'4698530e-8f25-457f-b6b2-6dc7f7ab5166',34,'4a9ee1af66824e368ddad5ea68a3201b','gigabytes',1,'2026-02-01 07:52:07',NULL),('2026-01-31 07:52:07','2026-01-31 07:52:11','2026-01-31 07:52:10',1,87,'1b449061-0b82-4ef4-8756-08a4e19299fd',35,'4a9ee1af66824e368ddad5ea68a3201b','volumes___DEFAULT__',1,'2026-02-01 07:52:07',NULL),('2026-01-31 07:52:07','2026-01-31 07:52:11','2026-01-31 07:52:11',1,88,'608d3aa2-cfd3-4f99-976a-69696b603ea2',36,'4a9ee1af66824e368ddad5ea68a3201b','gigabytes___DEFAULT__',1,'2026-02-01 07:52:07',NULL),('2026-01-31 07:53:18','2026-01-31 07:53:18','2026-01-31 07:53:18',1,89,'e9355239-e2ce-4ccf-9ca8-a1d77e9c9f06',29,'3264618ebdfa4478919141d5d3c4d3b3','volumes',-1,'2026-02-01 07:53:18',NULL),('2026-01-31 07:53:18','2026-01-31 07:53:18','2026-01-31 07:53:18',1,90,'aa5d41f0-2f62-443b-8208-1dd342450cbe',30,'3264618ebdfa4478919141d5d3c4d3b3','gigabytes',-1,'2026-02-01 07:53:18',NULL),('2026-01-31 07:53:18','2026-01-31 07:53:18','2026-01-31 07:53:18',1,91,'dd60306a-36a4-47ad-a6f1-ab9184a46b52',31,'3264618ebdfa4478919141d5d3c4d3b3','volumes___DEFAULT__',-1,'2026-02-01 07:53:18',NULL),('2026-01-31 07:53:18','2026-01-31 07:53:18','2026-01-31 07:53:18',1,92,'ca05102f-4723-456d-a7ee-d50452015d37',32,'3264618ebdfa4478919141d5d3c4d3b3','gigabytes___DEFAULT__',-1,'2026-02-01 07:53:18',NULL),('2026-01-31 07:53:19','2026-01-31 07:53:19','2026-01-31 07:53:19',1,93,'2b20d539-45fe-4c0a-9882-253986d11052',33,'4a9ee1af66824e368ddad5ea68a3201b','volumes',-1,'2026-02-01 07:53:19',NULL),('2026-01-31 07:53:19','2026-01-31 07:53:19','2026-01-31 07:53:19',1,94,'bd4d701a-3b2f-46f6-86bd-0da328e62155',34,'4a9ee1af66824e368ddad5ea68a3201b','gigabytes',-1,'2026-02-01 07:53:19',NULL),('2026-01-31 07:53:19','2026-01-31 07:53:19','2026-01-31 07:53:19',1,95,'49e577c6-fcbf-42aa-a304-98e9ed95ac4f',35,'4a9ee1af66824e368ddad5ea68a3201b','volumes___DEFAULT__',-1,'2026-02-01 07:53:19',NULL),('2026-01-31 07:53:19','2026-01-31 07:53:19','2026-01-31 07:53:19',1,96,'83e79847-b16b-435c-bc88-a82ec2cf702a',36,'4a9ee1af66824e368ddad5ea68a3201b','gigabytes___DEFAULT__',-1,'2026-02-01 07:53:19',NULL),('2026-01-31 07:53:21','2026-01-31 07:53:21','2026-01-31 07:53:21',1,97,'c9b37163-8a13-4442-b62c-53f1a7cfd0de',29,'3264618ebdfa4478919141d5d3c4d3b3','volumes',-1,'2026-02-01 07:53:21',NULL),('2026-01-31 07:53:21','2026-01-31 07:53:21','2026-01-31 07:53:21',1,98,'17d47471-35ea-42f8-92c2-4d98d3d0a27b',30,'3264618ebdfa4478919141d5d3c4d3b3','gigabytes',-1,'2026-02-01 07:53:21',NULL),('2026-01-31 07:53:21','2026-01-31 07:53:21','2026-01-31 07:53:21',1,99,'cd944d90-2b7a-4461-ad53-771fe848c302',31,'3264618ebdfa4478919141d5d3c4d3b3','volumes___DEFAULT__',-1,'2026-02-01 07:53:21',NULL),('2026-01-31 07:53:21','2026-01-31 07:53:21','2026-01-31 07:53:21',1,100,'e6ad5254-98c0-4768-8bb3-6ef31bf9f2f0',32,'3264618ebdfa4478919141d5d3c4d3b3','gigabytes___DEFAULT__',-1,'2026-02-01 07:53:21',NULL),('2026-01-31 07:53:22','2026-01-31 07:53:22','2026-01-31 07:53:22',1,101,'ffa66623-9d48-4f4d-a440-144c69cb0103',29,'3264618ebdfa4478919141d5d3c4d3b3','volumes',-1,'2026-02-01 07:53:22',NULL),('2026-01-31 07:53:22','2026-01-31 07:53:22','2026-01-31 07:53:22',1,102,'1f18ffd2-7a76-4f4a-a734-b3c97f5c17c5',30,'3264618ebdfa4478919141d5d3c4d3b3','gigabytes',-1,'2026-02-01 07:53:22',NULL),('2026-01-31 07:53:22','2026-01-31 07:53:22','2026-01-31 07:53:22',1,103,'a6bdf4b9-2478-487e-88b7-b0a3b9684e54',31,'3264618ebdfa4478919141d5d3c4d3b3','volumes___DEFAULT__',-1,'2026-02-01 07:53:22',NULL),('2026-01-31 07:53:22','2026-01-31 07:53:22','2026-01-31 07:53:22',1,104,'a9c52aaa-63e2-4126-8ba2-f2bb803920d4',32,'3264618ebdfa4478919141d5d3c4d3b3','gigabytes___DEFAULT__',-1,'2026-02-01 07:53:22',NULL),('2026-01-31 08:00:27','2026-01-31 08:00:27','2026-01-31 08:00:27',1,105,'b53d1138-241e-47c7-bd3d-83575feae2f7',37,'2ab30fd72657435fb442fc59a53da644','volumes',1,'2026-02-01 08:00:27',NULL),('2026-01-31 08:00:27','2026-01-31 08:00:27','2026-01-31 08:00:27',1,106,'c575d13b-2625-4e81-8385-ecf3286e4b23',38,'2ab30fd72657435fb442fc59a53da644','gigabytes',1,'2026-02-01 08:00:27',NULL),('2026-01-31 08:00:27','2026-01-31 08:00:27','2026-01-31 08:00:27',1,107,'84c3b41c-b19f-4597-a487-f29e0ae150c1',39,'2ab30fd72657435fb442fc59a53da644','volumes___DEFAULT__',1,'2026-02-01 08:00:27',NULL),('2026-01-31 08:00:27','2026-01-31 08:00:27','2026-01-31 08:00:27',1,108,'0f99987f-1660-4a67-ae2f-6d8bd5e5ad14',40,'2ab30fd72657435fb442fc59a53da644','gigabytes___DEFAULT__',1,'2026-02-01 08:00:27',NULL),('2026-01-31 08:02:25','2026-01-31 08:02:25','2026-01-31 08:02:25',1,109,'e6165957-3064-484a-b9a7-e05fd8cc278d',37,'2ab30fd72657435fb442fc59a53da644','volumes',-1,'2026-02-01 08:02:25',NULL),('2026-01-31 08:02:25','2026-01-31 08:02:25','2026-01-31 08:02:25',1,110,'824db344-f8a9-4669-86f7-b81eec34111f',38,'2ab30fd72657435fb442fc59a53da644','gigabytes',-1,'2026-02-01 08:02:25',NULL),('2026-01-31 08:02:25','2026-01-31 08:02:25','2026-01-31 08:02:25',1,111,'f7c07fbf-4cc2-4f6d-aee3-b1a2d39ed7f6',39,'2ab30fd72657435fb442fc59a53da644','volumes___DEFAULT__',-1,'2026-02-01 08:02:25',NULL),('2026-01-31 08:02:25','2026-01-31 08:02:25','2026-01-31 08:02:25',1,112,'8c08492b-0f03-42f3-b6f9-22720398e945',40,'2ab30fd72657435fb442fc59a53da644','gigabytes___DEFAULT__',-1,'2026-02-01 08:02:25',NULL),('2026-01-31 08:03:14','2026-01-31 08:03:14','2026-01-31 08:03:14',1,113,'fc6b7d23-20c7-4e03-8a74-1b5cde8415dd',41,'d352316ff6534075952e2d0c28061b09','volumes',1,'2026-02-01 08:03:14',NULL),('2026-01-31 08:03:14','2026-01-31 08:03:14','2026-01-31 08:03:14',1,114,'2de1cf40-c26e-4b47-9970-303ed6e5fa3d',42,'d352316ff6534075952e2d0c28061b09','gigabytes',1,'2026-02-01 08:03:14',NULL),('2026-01-31 08:03:14','2026-01-31 08:03:14','2026-01-31 08:03:14',1,115,'50b35097-fc7c-4a4f-80d2-c62bd803fb6b',43,'d352316ff6534075952e2d0c28061b09','volumes___DEFAULT__',1,'2026-02-01 08:03:14',NULL),('2026-01-31 08:03:14','2026-01-31 08:03:14','2026-01-31 08:03:14',1,116,'e951c50b-53f6-47aa-97df-bb17333ac40b',44,'d352316ff6534075952e2d0c28061b09','gigabytes___DEFAULT__',1,'2026-02-01 08:03:14',NULL),('2026-01-31 08:03:22','2026-01-31 08:03:22','2026-01-31 08:03:22',1,117,'1be33c51-46b0-4589-bce6-afc1bf402d26',45,'2327b93dd7d648efad6d2b303f9e462e','volumes',1,'2026-02-01 08:03:22',NULL),('2026-01-31 08:03:22','2026-01-31 08:03:22','2026-01-31 08:03:22',1,118,'738a6787-87ab-4705-a686-f97825c7b911',46,'2327b93dd7d648efad6d2b303f9e462e','gigabytes',1,'2026-02-01 08:03:22',NULL),('2026-01-31 08:03:22','2026-01-31 08:03:22','2026-01-31 08:03:22',1,119,'a3b98402-9927-40c5-b385-8a6a1f415794',47,'2327b93dd7d648efad6d2b303f9e462e','volumes___DEFAULT__',1,'2026-02-01 08:03:22',NULL),('2026-01-31 08:03:22','2026-01-31 08:03:22','2026-01-31 08:03:22',1,120,'7260c1cd-a97e-4c95-8eea-2c155ea21750',48,'2327b93dd7d648efad6d2b303f9e462e','gigabytes___DEFAULT__',1,'2026-02-01 08:03:22',NULL),('2026-01-31 08:03:32','2026-01-31 08:03:32','2026-01-31 08:03:32',1,121,'7e670c8e-e5c8-4276-be3c-abb497c47bc2',45,'2327b93dd7d648efad6d2b303f9e462e','volumes',1,'2026-02-01 08:03:32',NULL),('2026-01-31 08:03:32','2026-01-31 08:03:32','2026-01-31 08:03:32',1,122,'d145045c-7cef-4508-884f-a69bcd863692',46,'2327b93dd7d648efad6d2b303f9e462e','gigabytes',1,'2026-02-01 08:03:32',NULL),('2026-01-31 08:03:32','2026-01-31 08:03:32','2026-01-31 08:03:32',1,123,'90d8ce58-338e-4ab9-b865-2b593be43e8a',47,'2327b93dd7d648efad6d2b303f9e462e','volumes___DEFAULT__',1,'2026-02-01 08:03:32',NULL),('2026-01-31 08:03:32','2026-01-31 08:03:32','2026-01-31 08:03:32',1,124,'5e676ced-d56d-46dc-a8cc-4c7ea38ffeae',48,'2327b93dd7d648efad6d2b303f9e462e','gigabytes___DEFAULT__',1,'2026-02-01 08:03:32',NULL),('2026-01-31 08:03:34','2026-01-31 08:03:34','2026-01-31 08:03:34',1,125,'8dada186-6fce-4085-bf2e-f21eaf996508',45,'2327b93dd7d648efad6d2b303f9e462e','volumes',1,'2026-02-01 08:03:34',NULL),('2026-01-31 08:03:34','2026-01-31 08:03:34','2026-01-31 08:03:34',1,126,'b23d24a8-369e-43a5-8836-057b8e602f4f',46,'2327b93dd7d648efad6d2b303f9e462e','gigabytes',1,'2026-02-01 08:03:34',NULL),('2026-01-31 08:03:34','2026-01-31 08:03:34','2026-01-31 08:03:34',1,127,'2761e13f-decf-4552-b3b2-b3be7773affe',47,'2327b93dd7d648efad6d2b303f9e462e','volumes___DEFAULT__',1,'2026-02-01 08:03:34',NULL),('2026-01-31 08:03:34','2026-01-31 08:03:34','2026-01-31 08:03:34',1,128,'de428c32-f630-479b-bbe4-cbd24cdfb2c3',48,'2327b93dd7d648efad6d2b303f9e462e','gigabytes___DEFAULT__',1,'2026-02-01 08:03:34',NULL),('2026-01-31 08:05:14','2026-01-31 08:05:14','2026-01-31 08:05:14',1,129,'a5d7d026-a97a-4620-8691-ee12f3df8b1e',41,'d352316ff6534075952e2d0c28061b09','volumes',1,'2026-02-01 08:05:14',NULL),('2026-01-31 08:05:14','2026-01-31 08:05:14','2026-01-31 08:05:14',1,130,'da23f843-54e8-4ee6-b7a0-6a5dd11e5357',42,'d352316ff6534075952e2d0c28061b09','gigabytes',1,'2026-02-01 08:05:14',NULL),('2026-01-31 08:05:14','2026-01-31 08:05:14','2026-01-31 08:05:14',1,131,'b7777acf-694b-416c-85a9-d08bd7168de6',43,'d352316ff6534075952e2d0c28061b09','volumes___DEFAULT__',1,'2026-02-01 08:05:14',NULL),('2026-01-31 08:05:14','2026-01-31 08:05:14','2026-01-31 08:05:14',1,132,'64d01bee-6021-4c91-8433-8ee2e024fccf',44,'d352316ff6534075952e2d0c28061b09','gigabytes___DEFAULT__',1,'2026-02-01 08:05:14',NULL),('2026-01-31 08:06:06','2026-01-31 08:06:06','2026-01-31 08:06:06',1,133,'4365d604-7bbb-4db4-a6f8-fbf1fecd06a0',45,'2327b93dd7d648efad6d2b303f9e462e','volumes',-1,'2026-02-01 08:06:06',NULL),('2026-01-31 08:06:06','2026-01-31 08:06:06','2026-01-31 08:06:06',1,134,'3debf4fb-d91e-436b-867b-08b5acf73979',46,'2327b93dd7d648efad6d2b303f9e462e','gigabytes',-1,'2026-02-01 08:06:06',NULL),('2026-01-31 08:06:06','2026-01-31 08:06:06','2026-01-31 08:06:06',1,135,'de234927-786f-44b6-8823-59fcf9e77f59',47,'2327b93dd7d648efad6d2b303f9e462e','volumes___DEFAULT__',-1,'2026-02-01 08:06:06',NULL),('2026-01-31 08:06:06','2026-01-31 08:06:06','2026-01-31 08:06:06',1,136,'fbbaecbf-ee90-40cb-9d2d-21e67db3ed98',48,'2327b93dd7d648efad6d2b303f9e462e','gigabytes___DEFAULT__',-1,'2026-02-01 08:06:06',NULL),('2026-01-31 08:06:08','2026-01-31 08:06:08','2026-01-31 08:06:08',1,137,'f5fe65fa-4596-4c39-8b54-9d70748ed999',45,'2327b93dd7d648efad6d2b303f9e462e','volumes',-1,'2026-02-01 08:06:08',NULL),('2026-01-31 08:06:08','2026-01-31 08:06:08','2026-01-31 08:06:08',1,138,'27ed4e11-ea2f-4271-875f-6f4f6e889685',46,'2327b93dd7d648efad6d2b303f9e462e','gigabytes',-1,'2026-02-01 08:06:08',NULL),('2026-01-31 08:06:08','2026-01-31 08:06:08','2026-01-31 08:06:08',1,139,'d2e79cd7-bb2f-4e33-aa28-b7a061014f98',47,'2327b93dd7d648efad6d2b303f9e462e','volumes___DEFAULT__',-1,'2026-02-01 08:06:08',NULL),('2026-01-31 08:06:08','2026-01-31 08:06:08','2026-01-31 08:06:08',1,140,'9a7f1c87-973a-4a62-b551-50d6977bf75a',48,'2327b93dd7d648efad6d2b303f9e462e','gigabytes___DEFAULT__',-1,'2026-02-01 08:06:08',NULL),('2026-01-31 08:06:09','2026-01-31 08:06:09','2026-01-31 08:06:09',1,141,'57cf9990-1556-410d-b8a8-5558c2e3dd43',45,'2327b93dd7d648efad6d2b303f9e462e','volumes',-1,'2026-02-01 08:06:09',NULL),('2026-01-31 08:06:09','2026-01-31 08:06:09','2026-01-31 08:06:09',1,142,'63b2df59-9a60-42de-94a8-cd81991dea63',46,'2327b93dd7d648efad6d2b303f9e462e','gigabytes',-1,'2026-02-01 08:06:09',NULL),('2026-01-31 08:06:09','2026-01-31 08:06:09','2026-01-31 08:06:09',1,143,'b9966565-2870-4e38-88fa-e229449087a8',47,'2327b93dd7d648efad6d2b303f9e462e','volumes___DEFAULT__',-1,'2026-02-01 08:06:09',NULL),('2026-01-31 08:06:09','2026-01-31 08:06:09','2026-01-31 08:06:09',1,144,'211f3dfc-9464-4d88-9265-771f9eff69f5',48,'2327b93dd7d648efad6d2b303f9e462e','gigabytes___DEFAULT__',-1,'2026-02-01 08:06:09',NULL),('2026-01-31 08:07:02','2026-01-31 08:07:03','2026-01-31 08:07:03',1,145,'d1b7fd2b-961c-460a-81c6-adb5276ec767',41,'d352316ff6534075952e2d0c28061b09','volumes',-1,'2026-02-01 08:07:02',NULL),('2026-01-31 08:07:02','2026-01-31 08:07:03','2026-01-31 08:07:03',1,146,'e740a2f8-b120-4489-bba5-a74c921adeba',42,'d352316ff6534075952e2d0c28061b09','gigabytes',-1,'2026-02-01 08:07:02',NULL),('2026-01-31 08:07:03','2026-01-31 08:07:03','2026-01-31 08:07:03',1,147,'dfdf0c97-0326-4353-b7ad-c25af1a4ec11',43,'d352316ff6534075952e2d0c28061b09','volumes___DEFAULT__',-1,'2026-02-01 08:07:02',NULL),('2026-01-31 08:07:03','2026-01-31 08:07:03','2026-01-31 08:07:03',1,148,'d49485a5-25fa-48ef-8db8-4a76ea78a7af',44,'d352316ff6534075952e2d0c28061b09','gigabytes___DEFAULT__',-1,'2026-02-01 08:07:02',NULL),('2026-01-31 08:07:15','2026-01-31 08:07:16','2026-01-31 08:07:16',1,149,'e21cc619-9342-4a95-b66d-5fe3add3ffb2',41,'d352316ff6534075952e2d0c28061b09','volumes',-1,'2026-02-01 08:07:15',NULL),('2026-01-31 08:07:15','2026-01-31 08:07:16','2026-01-31 08:07:16',1,150,'e7aeeb79-0008-4060-ad64-0556b09d7637',42,'d352316ff6534075952e2d0c28061b09','gigabytes',-1,'2026-02-01 08:07:15',NULL),('2026-01-31 08:07:15','2026-01-31 08:07:16','2026-01-31 08:07:16',1,151,'ea3dd61b-f369-40a6-bf20-01c8b35c96ef',43,'d352316ff6534075952e2d0c28061b09','volumes___DEFAULT__',-1,'2026-02-01 08:07:15',NULL),('2026-01-31 08:07:15','2026-01-31 08:07:16','2026-01-31 08:07:16',1,152,'ed44ddcc-4d23-4c46-9e5d-1204eef61944',44,'d352316ff6534075952e2d0c28061b09','gigabytes___DEFAULT__',-1,'2026-02-01 08:07:15',NULL),('2026-01-31 08:11:11','2026-01-31 08:11:12','2026-01-31 08:11:12',1,153,'6cab7698-ccfe-4216-80cd-df4927010af3',49,'c3ddadeb950a490db5c99da98a32c9ec','volumes',1,'2026-02-01 08:11:11',NULL),('2026-01-31 08:11:11','2026-01-31 08:11:12','2026-01-31 08:11:12',1,154,'b3e05321-290e-4167-aa95-7ced2dfeefc3',50,'c3ddadeb950a490db5c99da98a32c9ec','gigabytes',1,'2026-02-01 08:11:11',NULL),('2026-01-31 08:11:11','2026-01-31 08:11:12','2026-01-31 08:11:12',1,155,'06827c89-6b4b-4475-a289-91464d4aac63',51,'c3ddadeb950a490db5c99da98a32c9ec','volumes___DEFAULT__',1,'2026-02-01 08:11:11',NULL),('2026-01-31 08:11:11','2026-01-31 08:11:12','2026-01-31 08:11:12',1,156,'4e7eab36-2f28-4a1d-aa10-37c9b2947b5a',52,'c3ddadeb950a490db5c99da98a32c9ec','gigabytes___DEFAULT__',1,'2026-02-01 08:11:11',NULL),('2026-01-31 08:15:17','2026-01-31 08:15:17','2026-01-31 08:15:17',1,157,'2960aa4f-6e4d-4eb7-ac2c-54659df7373c',53,'1633c84ea1bf46b080aaafd30bbcf25f','volumes',1,'2026-02-01 08:15:17',NULL),('2026-01-31 08:15:17','2026-01-31 08:15:17','2026-01-31 08:15:17',1,158,'bfdb9b58-3f16-4827-9f6a-12900588597b',54,'1633c84ea1bf46b080aaafd30bbcf25f','gigabytes',1,'2026-02-01 08:15:17',NULL),('2026-01-31 08:15:17','2026-01-31 08:15:17','2026-01-31 08:15:17',1,159,'f8c52ff7-dcd9-4690-a2f4-c953aeeb7fbb',55,'1633c84ea1bf46b080aaafd30bbcf25f','volumes___DEFAULT__',1,'2026-02-01 08:15:17',NULL),('2026-01-31 08:15:17','2026-01-31 08:15:17','2026-01-31 08:15:17',1,160,'544e6776-4a63-4331-9227-9ee8852b72bd',56,'1633c84ea1bf46b080aaafd30bbcf25f','gigabytes___DEFAULT__',1,'2026-02-01 08:15:17',NULL),('2026-01-31 08:15:46','2026-01-31 08:15:46','2026-01-31 08:15:46',1,161,'aa18a2db-0ec0-413b-9b0b-8a2fec4cbdb3',49,'c3ddadeb950a490db5c99da98a32c9ec','volumes',-1,'2026-02-01 08:15:46',NULL),('2026-01-31 08:15:46','2026-01-31 08:15:46','2026-01-31 08:15:46',1,162,'4c55978b-4ce1-4ad8-be9a-696d9570e7d2',50,'c3ddadeb950a490db5c99da98a32c9ec','gigabytes',-1,'2026-02-01 08:15:46',NULL),('2026-01-31 08:15:46','2026-01-31 08:15:46','2026-01-31 08:15:46',1,163,'e291f65c-0269-4557-897f-a7d725e50c9c',51,'c3ddadeb950a490db5c99da98a32c9ec','volumes___DEFAULT__',-1,'2026-02-01 08:15:46',NULL),('2026-01-31 08:15:46','2026-01-31 08:15:46','2026-01-31 08:15:46',1,164,'786e1753-66d6-4369-99dd-c8717afff95c',52,'c3ddadeb950a490db5c99da98a32c9ec','gigabytes___DEFAULT__',-1,'2026-02-01 08:15:46',NULL),('2026-01-31 08:16:28','2026-01-31 08:16:28','2026-01-31 08:16:28',1,165,'fbafd3a5-1fd5-4aaf-aa6a-bb16eb19ed25',57,'bda3ebf6541d46309fc9b2ce089dd857','volumes',1,'2026-02-01 08:16:27',NULL),('2026-01-31 08:16:28','2026-01-31 08:16:28','2026-01-31 08:16:28',1,166,'15f7225e-2ebe-4ad9-9fa7-132d4581db1a',58,'bda3ebf6541d46309fc9b2ce089dd857','gigabytes',1,'2026-02-01 08:16:27',NULL),('2026-01-31 08:16:28','2026-01-31 08:16:28','2026-01-31 08:16:28',1,167,'e658deee-f6ed-41d7-a57a-fecf908a3539',59,'bda3ebf6541d46309fc9b2ce089dd857','volumes___DEFAULT__',1,'2026-02-01 08:16:27',NULL),('2026-01-31 08:16:28','2026-01-31 08:16:28','2026-01-31 08:16:28',1,168,'7c8b401e-bf43-4d5d-a767-52e5a554aa39',60,'bda3ebf6541d46309fc9b2ce089dd857','gigabytes___DEFAULT__',1,'2026-02-01 08:16:27',NULL),('2026-01-31 08:17:11','2026-01-31 08:17:11','2026-01-31 08:17:11',1,169,'ba6a2853-ae3b-4ae2-b7f3-647271b3c1bd',61,'3b06982960ad4453b8e542cb6330835d','volumes',1,'2026-02-01 08:17:11',NULL),('2026-01-31 08:17:11','2026-01-31 08:17:11','2026-01-31 08:17:11',1,170,'4e4f776f-e397-4c97-9850-5123ebc1ffc7',62,'3b06982960ad4453b8e542cb6330835d','gigabytes',1,'2026-02-01 08:17:11',NULL),('2026-01-31 08:17:11','2026-01-31 08:17:11','2026-01-31 08:17:11',1,171,'17c09110-bcf0-4d56-b8a3-5105efe3db14',63,'3b06982960ad4453b8e542cb6330835d','volumes___DEFAULT__',1,'2026-02-01 08:17:11',NULL),('2026-01-31 08:17:11','2026-01-31 08:17:11','2026-01-31 08:17:11',1,172,'bb314c37-e423-4a02-ace3-7bddb5b8ec3a',64,'3b06982960ad4453b8e542cb6330835d','gigabytes___DEFAULT__',1,'2026-02-01 08:17:11',NULL),('2026-01-31 08:18:09','2026-01-31 08:18:09','2026-01-31 08:18:09',1,173,'f34f1a36-a344-447e-a98d-f91fb4c57e18',65,'b2f8be0146584893ac5b769dff931958','volumes',1,'2026-02-01 08:18:09',NULL),('2026-01-31 08:18:09','2026-01-31 08:18:09','2026-01-31 08:18:09',1,174,'596e7558-cb57-48ef-9b58-b5087cfe49b7',66,'b2f8be0146584893ac5b769dff931958','gigabytes',1,'2026-02-01 08:18:09',NULL),('2026-01-31 08:18:09','2026-01-31 08:18:09','2026-01-31 08:18:09',1,175,'8f0e9d35-a32b-4bc4-960e-f2a0e6b51268',67,'b2f8be0146584893ac5b769dff931958','volumes___DEFAULT__',1,'2026-02-01 08:18:09',NULL),('2026-01-31 08:18:09','2026-01-31 08:18:09','2026-01-31 08:18:09',1,176,'9bd38f98-0f5e-4d7f-a1f4-de2ae5e9dca4',68,'b2f8be0146584893ac5b769dff931958','gigabytes___DEFAULT__',1,'2026-02-01 08:18:09',NULL),('2026-01-31 08:18:12','2026-01-31 08:18:12','2026-01-31 08:18:12',1,177,'f2ea5266-a55d-45db-b37c-130c29b2d2a7',69,'b2f8be0146584893ac5b769dff931958','snapshots',1,'2026-02-01 08:18:12',NULL),('2026-01-31 08:18:12','2026-01-31 08:18:12','2026-01-31 08:18:12',1,178,'ed9579d8-ca04-491a-b6d6-234ca2521ada',66,'b2f8be0146584893ac5b769dff931958','gigabytes',1,'2026-02-01 08:18:12',NULL),('2026-01-31 08:18:12','2026-01-31 08:18:12','2026-01-31 08:18:12',1,179,'f5eafbe8-6192-4af1-95b5-17f3f26d2578',68,'b2f8be0146584893ac5b769dff931958','gigabytes___DEFAULT__',1,'2026-02-01 08:18:12',NULL),('2026-01-31 08:18:12','2026-01-31 08:18:12','2026-01-31 08:18:12',1,180,'610379a8-7567-48ba-a859-76ae0f15ec67',70,'b2f8be0146584893ac5b769dff931958','snapshots___DEFAULT__',1,'2026-02-01 08:18:12',NULL),('2026-01-31 08:18:16','2026-01-31 08:18:16','2026-01-31 08:18:16',1,181,'07132eb2-4cf2-4835-9cda-7d71063a2ccf',53,'1633c84ea1bf46b080aaafd30bbcf25f','volumes',-1,'2026-02-01 08:18:16',NULL),('2026-01-31 08:18:16','2026-01-31 08:18:16','2026-01-31 08:18:16',1,182,'55204dd5-9e6c-4543-8123-d5771ee5d2a0',54,'1633c84ea1bf46b080aaafd30bbcf25f','gigabytes',-1,'2026-02-01 08:18:16',NULL),('2026-01-31 08:18:16','2026-01-31 08:18:16','2026-01-31 08:18:16',1,183,'36dd4b5e-5370-43d1-b9f1-6ffa0e25c2a5',55,'1633c84ea1bf46b080aaafd30bbcf25f','volumes___DEFAULT__',-1,'2026-02-01 08:18:16',NULL),('2026-01-31 08:18:16','2026-01-31 08:18:16','2026-01-31 08:18:16',1,184,'5643234e-1d9f-48e6-b614-1f4c690ac626',56,'1633c84ea1bf46b080aaafd30bbcf25f','gigabytes___DEFAULT__',-1,'2026-02-01 08:18:16',NULL),('2026-01-31 08:18:18','2026-01-31 08:18:18','2026-01-31 08:18:18',1,185,'09c86a58-923d-4c3d-aa97-3f14dac02f3d',69,'b2f8be0146584893ac5b769dff931958','snapshots',-1,'2026-02-01 08:18:18',NULL),('2026-01-31 08:18:18','2026-01-31 08:18:18','2026-01-31 08:18:18',1,186,'9e3be391-67e0-4f19-a7a3-c92eb18709fd',66,'b2f8be0146584893ac5b769dff931958','gigabytes',-1,'2026-02-01 08:18:18',NULL),('2026-01-31 08:18:18','2026-01-31 08:18:18','2026-01-31 08:18:18',1,187,'d51b1e8e-72e7-46c6-90c3-aaf77c929d16',68,'b2f8be0146584893ac5b769dff931958','gigabytes___DEFAULT__',-1,'2026-02-01 08:18:18',NULL),('2026-01-31 08:18:18','2026-01-31 08:18:18','2026-01-31 08:18:18',1,188,'749a54b4-a73e-43b3-8b1a-af43637b073d',70,'b2f8be0146584893ac5b769dff931958','snapshots___DEFAULT__',-1,'2026-02-01 08:18:18',NULL),('2026-01-31 08:18:20','2026-01-31 08:18:20','2026-01-31 08:18:20',1,189,'b9f02c76-fe53-4329-89c3-47b5b51091e6',65,'b2f8be0146584893ac5b769dff931958','volumes',-1,'2026-02-01 08:18:20',NULL),('2026-01-31 08:18:20','2026-01-31 08:18:20','2026-01-31 08:18:20',1,190,'59a2a430-e6b2-4704-886a-f2ebdcf87b54',66,'b2f8be0146584893ac5b769dff931958','gigabytes',-1,'2026-02-01 08:18:20',NULL),('2026-01-31 08:18:20','2026-01-31 08:18:20','2026-01-31 08:18:20',1,191,'de93934b-2102-4004-a27d-21cf5de74eaa',67,'b2f8be0146584893ac5b769dff931958','volumes___DEFAULT__',-1,'2026-02-01 08:18:20',NULL),('2026-01-31 08:18:20','2026-01-31 08:18:20','2026-01-31 08:18:20',1,192,'eb3e14ef-8f80-486e-87dd-6dfb8515708a',68,'b2f8be0146584893ac5b769dff931958','gigabytes___DEFAULT__',-1,'2026-02-01 08:18:20',NULL),('2026-01-31 08:19:02','2026-01-31 08:19:02','2026-01-31 08:19:02',1,193,'f71e960d-14d7-471c-9b94-c3967019025d',57,'bda3ebf6541d46309fc9b2ce089dd857','volumes',-1,'2026-02-01 08:19:02',NULL),('2026-01-31 08:19:02','2026-01-31 08:19:02','2026-01-31 08:19:02',1,194,'80498116-c08e-4d91-8112-950fbd0daa3b',58,'bda3ebf6541d46309fc9b2ce089dd857','gigabytes',-1,'2026-02-01 08:19:02',NULL),('2026-01-31 08:19:02','2026-01-31 08:19:02','2026-01-31 08:19:02',1,195,'134c74c5-fc9a-4b05-bf9b-646ac3fd70ef',59,'bda3ebf6541d46309fc9b2ce089dd857','volumes___DEFAULT__',-1,'2026-02-01 08:19:02',NULL),('2026-01-31 08:19:02','2026-01-31 08:19:02','2026-01-31 08:19:02',1,196,'10296251-f41e-4f29-901f-7b5c1afeb43e',60,'bda3ebf6541d46309fc9b2ce089dd857','gigabytes___DEFAULT__',-1,'2026-02-01 08:19:02',NULL),('2026-01-31 08:19:28','2026-01-31 08:19:28','2026-01-31 08:19:28',1,197,'ed196cb2-ca74-46ba-a9e7-291b6f713a4a',71,'134c066ac92844ff853b216870fa8eed','volumes',1,'2026-02-01 08:19:28',NULL),('2026-01-31 08:19:28','2026-01-31 08:19:28','2026-01-31 08:19:28',1,198,'e0574102-0956-4354-a028-bc1b8a4cf610',72,'134c066ac92844ff853b216870fa8eed','gigabytes',1,'2026-02-01 08:19:28',NULL),('2026-01-31 08:19:28','2026-01-31 08:19:28','2026-01-31 08:19:28',1,199,'a24c9350-3978-43a1-b0da-66ddb2d7b8b5',73,'134c066ac92844ff853b216870fa8eed','volumes___DEFAULT__',1,'2026-02-01 08:19:28',NULL),('2026-01-31 08:19:28','2026-01-31 08:19:28','2026-01-31 08:19:28',1,200,'94490482-fe14-4549-b459-fa9610732f21',74,'134c066ac92844ff853b216870fa8eed','gigabytes___DEFAULT__',1,'2026-02-01 08:19:28',NULL),('2026-01-31 08:19:33','2026-01-31 08:19:33','2026-01-31 08:19:33',1,201,'0c6e7b35-b052-496c-8fc9-e0619ea9ad5c',61,'3b06982960ad4453b8e542cb6330835d','volumes',1,'2026-02-01 08:19:33',NULL),('2026-01-31 08:19:33','2026-01-31 08:19:33','2026-01-31 08:19:33',1,202,'44931528-14a2-48b3-9633-dcf18d641866',62,'3b06982960ad4453b8e542cb6330835d','gigabytes',1,'2026-02-01 08:19:33',NULL),('2026-01-31 08:19:33','2026-01-31 08:19:33','2026-01-31 08:19:33',1,203,'e7dcd238-96d5-4661-b5d6-8e53d2f6ca48',63,'3b06982960ad4453b8e542cb6330835d','volumes___DEFAULT__',1,'2026-02-01 08:19:33',NULL),('2026-01-31 08:19:33','2026-01-31 08:19:33','2026-01-31 08:19:33',1,204,'d3248b1c-8091-4857-b1ac-3859fec314a9',64,'3b06982960ad4453b8e542cb6330835d','gigabytes___DEFAULT__',1,'2026-02-01 08:19:33',NULL),('2026-01-31 08:19:34','2026-01-31 08:19:34','2026-01-31 08:19:34',1,205,'9a5f958f-05a7-4487-804f-b8ab1d29fb18',75,'134c066ac92844ff853b216870fa8eed','snapshots',1,'2026-02-01 08:19:34',NULL),('2026-01-31 08:19:34','2026-01-31 08:19:34','2026-01-31 08:19:34',1,206,'0a779ca8-6a3e-4312-8792-889e840c5c52',72,'134c066ac92844ff853b216870fa8eed','gigabytes',1,'2026-02-01 08:19:34',NULL),('2026-01-31 08:19:34','2026-01-31 08:19:34','2026-01-31 08:19:34',1,207,'a1c6b005-0758-41e5-bf55-b8679fc37d99',74,'134c066ac92844ff853b216870fa8eed','gigabytes___DEFAULT__',1,'2026-02-01 08:19:34',NULL),('2026-01-31 08:19:34','2026-01-31 08:19:34','2026-01-31 08:19:34',1,208,'d4d1f0c4-0a56-4ceb-922e-96b6edde6280',76,'134c066ac92844ff853b216870fa8eed','snapshots___DEFAULT__',1,'2026-02-01 08:19:34',NULL),('2026-01-31 08:20:05','2026-01-31 08:20:05','2026-01-31 08:20:05',1,209,'1ff371ed-a607-4e71-968a-e0dca5691f42',75,'134c066ac92844ff853b216870fa8eed','snapshots',-1,'2026-02-01 08:20:05',NULL),('2026-01-31 08:20:05','2026-01-31 08:20:05','2026-01-31 08:20:05',1,210,'173404ff-e5f7-40d5-9045-b88d972e260f',72,'134c066ac92844ff853b216870fa8eed','gigabytes',-1,'2026-02-01 08:20:05',NULL),('2026-01-31 08:20:05','2026-01-31 08:20:05','2026-01-31 08:20:05',1,211,'a9b5a385-71fa-45ed-87dc-919b5dabe18e',74,'134c066ac92844ff853b216870fa8eed','gigabytes___DEFAULT__',-1,'2026-02-01 08:20:05',NULL),('2026-01-31 08:20:05','2026-01-31 08:20:05','2026-01-31 08:20:05',1,212,'557765f2-3d8d-4786-ab1b-eeafd6030602',76,'134c066ac92844ff853b216870fa8eed','snapshots___DEFAULT__',-1,'2026-02-01 08:20:05',NULL),('2026-01-31 08:20:31','2026-01-31 08:20:31','2026-01-31 08:20:31',1,213,'ea187ff9-e932-4d45-9ec4-6c07a9bbb06a',77,'4849ff916e1b4e2aa162faaf2c0717a2','volumes',1,'2026-02-01 08:20:31',NULL),('2026-01-31 08:20:31','2026-01-31 08:20:31','2026-01-31 08:20:31',1,214,'b626f17e-8e9c-4fe5-a741-1e7b7a85e138',78,'4849ff916e1b4e2aa162faaf2c0717a2','gigabytes',1,'2026-02-01 08:20:31',NULL),('2026-01-31 08:20:31','2026-01-31 08:20:31','2026-01-31 08:20:31',1,215,'a80272e2-43d0-43f4-99a3-d43eb73b22d0',79,'4849ff916e1b4e2aa162faaf2c0717a2','volumes___DEFAULT__',1,'2026-02-01 08:20:31',NULL),('2026-01-31 08:20:31','2026-01-31 08:20:31','2026-01-31 08:20:31',1,216,'f9e934a2-92f4-4dcf-8db3-11e0907f55e5',80,'4849ff916e1b4e2aa162faaf2c0717a2','gigabytes___DEFAULT__',1,'2026-02-01 08:20:31',NULL),('2026-01-31 08:20:48','2026-01-31 08:20:48','2026-01-31 08:20:48',1,217,'f550d74e-8939-4249-a0c4-3635caa6dfce',61,'3b06982960ad4453b8e542cb6330835d','volumes',-1,'2026-02-01 08:20:48',NULL),('2026-01-31 08:20:48','2026-01-31 08:20:48','2026-01-31 08:20:48',1,218,'626b9772-9630-4afd-8002-d80708bc5cac',62,'3b06982960ad4453b8e542cb6330835d','gigabytes',-1,'2026-02-01 08:20:48',NULL),('2026-01-31 08:20:48','2026-01-31 08:20:48','2026-01-31 08:20:48',1,219,'fb7397bc-9c4c-4e2d-ac80-71ab79101c4e',63,'3b06982960ad4453b8e542cb6330835d','volumes___DEFAULT__',-1,'2026-02-01 08:20:48',NULL),('2026-01-31 08:20:48','2026-01-31 08:20:48','2026-01-31 08:20:48',1,220,'1c5f3af4-cd7a-4616-88da-a9f4c6047c6b',64,'3b06982960ad4453b8e542cb6330835d','gigabytes___DEFAULT__',-1,'2026-02-01 08:20:48',NULL),('2026-01-31 08:20:50','2026-01-31 08:20:50','2026-01-31 08:20:50',1,221,'384f43d5-107a-4006-8805-d41bf8f0b090',61,'3b06982960ad4453b8e542cb6330835d','volumes',-1,'2026-02-01 08:20:50',NULL),('2026-01-31 08:20:50','2026-01-31 08:20:50','2026-01-31 08:20:50',1,222,'78cdbd8b-6b20-457e-80e6-6f2345e38433',62,'3b06982960ad4453b8e542cb6330835d','gigabytes',-1,'2026-02-01 08:20:50',NULL),('2026-01-31 08:20:50','2026-01-31 08:20:50','2026-01-31 08:20:50',1,223,'674cf09d-faa3-44d3-baba-793edff96669',63,'3b06982960ad4453b8e542cb6330835d','volumes___DEFAULT__',-1,'2026-02-01 08:20:50',NULL),('2026-01-31 08:20:50','2026-01-31 08:20:50','2026-01-31 08:20:50',1,224,'e8c322e9-85af-427e-a24d-78c819dce800',64,'3b06982960ad4453b8e542cb6330835d','gigabytes___DEFAULT__',-1,'2026-02-01 08:20:50',NULL),('2026-01-31 08:20:52','2026-01-31 08:20:52','2026-01-31 08:20:52',1,225,'e83ef377-6e82-4fae-8428-be3afe647af0',77,'4849ff916e1b4e2aa162faaf2c0717a2','volumes',1,'2026-02-01 08:20:52',NULL),('2026-01-31 08:20:52','2026-01-31 08:20:52','2026-01-31 08:20:52',1,226,'14e54db2-9ac0-47ca-ba91-9ee3bd19ff0a',78,'4849ff916e1b4e2aa162faaf2c0717a2','gigabytes',1,'2026-02-01 08:20:52',NULL),('2026-01-31 08:20:52','2026-01-31 08:20:52','2026-01-31 08:20:52',1,227,'ec6eec69-ab6e-4de2-8fe0-7a743de42002',79,'4849ff916e1b4e2aa162faaf2c0717a2','volumes___DEFAULT__',1,'2026-02-01 08:20:52',NULL),('2026-01-31 08:20:52','2026-01-31 08:20:52','2026-01-31 08:20:52',1,228,'61f58469-4526-4777-b153-29bbf98bb8cb',80,'4849ff916e1b4e2aa162faaf2c0717a2','gigabytes___DEFAULT__',1,'2026-02-01 08:20:52',NULL),('2026-01-31 08:21:05','2026-01-31 08:21:05','2026-01-31 08:21:05',1,229,'b67fba92-4f01-428e-b008-5dce01156384',71,'134c066ac92844ff853b216870fa8eed','volumes',-1,'2026-02-01 08:21:05',NULL),('2026-01-31 08:21:05','2026-01-31 08:21:05','2026-01-31 08:21:05',1,230,'d0d0db01-fe8b-405b-8b9a-0b725e38cdad',72,'134c066ac92844ff853b216870fa8eed','gigabytes',-1,'2026-02-01 08:21:05',NULL),('2026-01-31 08:21:05','2026-01-31 08:21:05','2026-01-31 08:21:05',1,231,'1ffde612-fcb6-4911-a7e6-933875bb2d7c',73,'134c066ac92844ff853b216870fa8eed','volumes___DEFAULT__',-1,'2026-02-01 08:21:05',NULL),('2026-01-31 08:21:05','2026-01-31 08:21:05','2026-01-31 08:21:05',1,232,'19a9d4f8-36df-4269-91c1-e1b8edfaf143',74,'134c066ac92844ff853b216870fa8eed','gigabytes___DEFAULT__',-1,'2026-02-01 08:21:05',NULL),('2026-01-31 08:21:25','2026-01-31 08:21:25','2026-01-31 08:21:25',1,233,'3208fc09-f1c9-45d1-a741-523b4c3e94c8',81,'c90ea7f1be5f484bb873548236fadc00','volumes',1,'2026-02-01 08:21:25',NULL),('2026-01-31 08:21:25','2026-01-31 08:21:25','2026-01-31 08:21:25',1,234,'28838151-1814-4be2-8c92-fa9f640060f1',82,'c90ea7f1be5f484bb873548236fadc00','gigabytes',1,'2026-02-01 08:21:25',NULL),('2026-01-31 08:21:25','2026-01-31 08:21:25','2026-01-31 08:21:25',1,235,'b8f507b5-b17f-440d-9833-326e9f5e3d38',83,'c90ea7f1be5f484bb873548236fadc00','volumes___DEFAULT__',1,'2026-02-01 08:21:25',NULL),('2026-01-31 08:21:25','2026-01-31 08:21:25','2026-01-31 08:21:25',1,236,'75c66126-a409-44ae-b1dd-ad0bbad1c166',84,'c90ea7f1be5f484bb873548236fadc00','gigabytes___DEFAULT__',1,'2026-02-01 08:21:25',NULL),('2026-01-31 08:21:34','2026-01-31 08:21:34','2026-01-31 08:21:34',1,237,'4172703f-c710-4ef8-881b-8e21ebdadd61',71,'134c066ac92844ff853b216870fa8eed','volumes',1,'2026-02-01 08:21:34',NULL),('2026-01-31 08:21:34','2026-01-31 08:21:34','2026-01-31 08:21:34',1,238,'f1b4dea5-cdeb-443e-a3a1-deba913a6fc5',72,'134c066ac92844ff853b216870fa8eed','gigabytes',1,'2026-02-01 08:21:34',NULL),('2026-01-31 08:21:34','2026-01-31 08:21:34','2026-01-31 08:21:34',1,239,'e0ab68d1-26d7-43e9-b430-2cf33dea864a',73,'134c066ac92844ff853b216870fa8eed','volumes___DEFAULT__',1,'2026-02-01 08:21:34',NULL),('2026-01-31 08:21:34','2026-01-31 08:21:34','2026-01-31 08:21:34',1,240,'cf3330a5-01c3-4d86-926a-c77fe7cc472e',74,'134c066ac92844ff853b216870fa8eed','gigabytes___DEFAULT__',1,'2026-02-01 08:21:34',NULL),('2026-01-31 08:22:12','2026-01-31 08:22:12','2026-01-31 08:22:12',1,241,'ddf4009d-1bc0-4f1e-9cfc-bf490293f617',85,'fdf18f1faf4846e2a6e2eab4ac2aec02','volumes',1,'2026-02-01 08:22:12',NULL),('2026-01-31 08:22:12','2026-01-31 08:22:12','2026-01-31 08:22:12',1,242,'d5892b22-c29e-4b70-b353-aa2228f9dad6',86,'fdf18f1faf4846e2a6e2eab4ac2aec02','gigabytes',1,'2026-02-01 08:22:12',NULL),('2026-01-31 08:22:12','2026-01-31 08:22:12','2026-01-31 08:22:12',1,243,'be9881f4-8810-4dad-b723-7a7b535a9dc1',87,'fdf18f1faf4846e2a6e2eab4ac2aec02','volumes___DEFAULT__',1,'2026-02-01 08:22:12',NULL),('2026-01-31 08:22:12','2026-01-31 08:22:12','2026-01-31 08:22:12',1,244,'4ff6d1d9-f736-4c15-9a99-9cf2bef11e30',88,'fdf18f1faf4846e2a6e2eab4ac2aec02','gigabytes___DEFAULT__',1,'2026-02-01 08:22:12',NULL),('2026-01-31 08:22:42','2026-01-31 08:22:42','2026-01-31 08:22:42',1,245,'8b631947-bf00-434a-bde5-3fca004a20dc',71,'134c066ac92844ff853b216870fa8eed','volumes',-1,'2026-02-01 08:22:42',NULL),('2026-01-31 08:22:42','2026-01-31 08:22:42','2026-01-31 08:22:42',1,246,'05fc6364-4b9b-4d73-a79b-df0aaa8bb31b',72,'134c066ac92844ff853b216870fa8eed','gigabytes',-1,'2026-02-01 08:22:42',NULL),('2026-01-31 08:22:42','2026-01-31 08:22:42','2026-01-31 08:22:42',1,247,'fd083439-9dd4-42a0-aed2-736525974741',73,'134c066ac92844ff853b216870fa8eed','volumes___DEFAULT__',-1,'2026-02-01 08:22:42',NULL),('2026-01-31 08:22:42','2026-01-31 08:22:42','2026-01-31 08:22:42',1,248,'2a7b29df-222d-4785-98cd-6a336747302a',74,'134c066ac92844ff853b216870fa8eed','gigabytes___DEFAULT__',-1,'2026-02-01 08:22:42',NULL),('2026-01-31 08:22:52','2026-01-31 08:22:52','2026-01-31 08:22:52',1,249,'24b096dc-24cc-4675-949b-6bb9e7d45133',77,'4849ff916e1b4e2aa162faaf2c0717a2','volumes',-1,'2026-02-01 08:22:52',NULL),('2026-01-31 08:22:52','2026-01-31 08:22:52','2026-01-31 08:22:52',1,250,'7804e766-d3ed-4e96-9c9e-ff325a2a109e',78,'4849ff916e1b4e2aa162faaf2c0717a2','gigabytes',-1,'2026-02-01 08:22:52',NULL),('2026-01-31 08:22:52','2026-01-31 08:22:52','2026-01-31 08:22:52',1,251,'4b728d16-a304-46c7-b58f-6e2be8ee8c83',79,'4849ff916e1b4e2aa162faaf2c0717a2','volumes___DEFAULT__',-1,'2026-02-01 08:22:52',NULL),('2026-01-31 08:22:52','2026-01-31 08:22:52','2026-01-31 08:22:52',1,252,'eb7ae3d4-9cab-45e0-913e-523c083cc8b9',80,'4849ff916e1b4e2aa162faaf2c0717a2','gigabytes___DEFAULT__',-1,'2026-02-01 08:22:52',NULL),('2026-01-31 08:22:54','2026-01-31 08:22:55','2026-01-31 08:22:55',1,253,'0fd39082-db2f-43f1-b51e-8867bcb6c394',77,'4849ff916e1b4e2aa162faaf2c0717a2','volumes',-1,'2026-02-01 08:22:54',NULL),('2026-01-31 08:22:54','2026-01-31 08:22:55','2026-01-31 08:22:55',1,254,'f5d53879-d605-4338-91b4-9ee8df94cffb',78,'4849ff916e1b4e2aa162faaf2c0717a2','gigabytes',-1,'2026-02-01 08:22:54',NULL),('2026-01-31 08:22:54','2026-01-31 08:22:55','2026-01-31 08:22:55',1,255,'5aeaff51-5f7a-4ebd-8cf2-1be3df8d9eb0',79,'4849ff916e1b4e2aa162faaf2c0717a2','volumes___DEFAULT__',-1,'2026-02-01 08:22:54',NULL),('2026-01-31 08:22:54','2026-01-31 08:22:55','2026-01-31 08:22:55',1,256,'f4bc6e03-be1e-45fb-851a-3aa6fb28ee18',80,'4849ff916e1b4e2aa162faaf2c0717a2','gigabytes___DEFAULT__',-1,'2026-02-01 08:22:54',NULL),('2026-01-31 08:23:45','2026-01-31 08:23:45','2026-01-31 08:23:45',1,257,'3bda1a06-b743-4fb5-91e0-bc02d00b0c0d',81,'c90ea7f1be5f484bb873548236fadc00','volumes',1,'2026-02-01 08:23:45',NULL),('2026-01-31 08:23:45','2026-01-31 08:23:45','2026-01-31 08:23:45',1,258,'acd3fc78-b6e9-4e3e-b468-87d4a67918de',82,'c90ea7f1be5f484bb873548236fadc00','gigabytes',1,'2026-02-01 08:23:45',NULL),('2026-01-31 08:23:45','2026-01-31 08:23:45','2026-01-31 08:23:45',1,259,'2400699a-900a-499a-9d99-6cf2901495d6',83,'c90ea7f1be5f484bb873548236fadc00','volumes___DEFAULT__',1,'2026-02-01 08:23:45',NULL),('2026-01-31 08:23:45','2026-01-31 08:23:45','2026-01-31 08:23:45',1,260,'8f69050a-6baf-4763-bd82-a4ac6f824a0d',84,'c90ea7f1be5f484bb873548236fadc00','gigabytes___DEFAULT__',1,'2026-02-01 08:23:45',NULL),('2026-01-31 08:24:31','2026-01-31 08:24:31','2026-01-31 08:24:31',1,261,'d759ee66-224c-4b31-91d4-bac51178184b',89,'48bbdbdee526499e90da7e971ede68d3','volumes',1,'2026-02-01 08:24:31',NULL),('2026-01-31 08:24:31','2026-01-31 08:24:31','2026-01-31 08:24:31',1,262,'e6cd1df8-fcb3-4f85-84cb-23aa59636683',90,'48bbdbdee526499e90da7e971ede68d3','gigabytes',1,'2026-02-01 08:24:31',NULL),('2026-01-31 08:24:31','2026-01-31 08:24:31','2026-01-31 08:24:31',1,263,'a9d53552-94e8-4820-ae3f-2b0b439013eb',91,'48bbdbdee526499e90da7e971ede68d3','volumes_multiattach',1,'2026-02-01 08:24:31',NULL),('2026-01-31 08:24:31','2026-01-31 08:24:31','2026-01-31 08:24:31',1,264,'e110f946-32a3-4181-ba6f-2dabcae209a1',92,'48bbdbdee526499e90da7e971ede68d3','gigabytes_multiattach',1,'2026-02-01 08:24:31',NULL),('2026-01-31 08:24:34','2026-01-31 08:24:34','2026-01-31 08:24:34',1,265,'c816e53e-c1cb-4739-94df-dd4ffb86223d',85,'fdf18f1faf4846e2a6e2eab4ac2aec02','volumes',1,'2026-02-01 08:24:34',NULL),('2026-01-31 08:24:34','2026-01-31 08:24:34','2026-01-31 08:24:34',1,266,'994e73fb-fefe-4f79-a980-636b21065a43',86,'fdf18f1faf4846e2a6e2eab4ac2aec02','gigabytes',1,'2026-02-01 08:24:34',NULL),('2026-01-31 08:24:34','2026-01-31 08:24:34','2026-01-31 08:24:34',1,267,'d9dedb9f-e315-4dda-93bf-86fd50c609b0',87,'fdf18f1faf4846e2a6e2eab4ac2aec02','volumes___DEFAULT__',1,'2026-02-01 08:24:34',NULL),('2026-01-31 08:24:34','2026-01-31 08:24:34','2026-01-31 08:24:34',1,268,'40792d4f-0642-4516-b1d8-bcbd9a64f541',88,'fdf18f1faf4846e2a6e2eab4ac2aec02','gigabytes___DEFAULT__',1,'2026-02-01 08:24:34',NULL),('2026-01-31 08:24:39','2026-01-31 08:24:39','2026-01-31 08:24:39',1,269,'820d7e49-446b-490d-bec8-d816f9f67d92',85,'fdf18f1faf4846e2a6e2eab4ac2aec02','volumes',1,'2026-02-01 08:24:39',NULL),('2026-01-31 08:24:39','2026-01-31 08:24:39','2026-01-31 08:24:39',1,270,'daa26c1f-0c81-4fca-83ae-1cebd195cbc1',86,'fdf18f1faf4846e2a6e2eab4ac2aec02','gigabytes',1,'2026-02-01 08:24:39',NULL),('2026-01-31 08:24:39','2026-01-31 08:24:39','2026-01-31 08:24:39',1,271,'650e38e8-40cc-4fd4-8a1d-ef61da7d8aed',87,'fdf18f1faf4846e2a6e2eab4ac2aec02','volumes___DEFAULT__',1,'2026-02-01 08:24:39',NULL),('2026-01-31 08:24:39','2026-01-31 08:24:39','2026-01-31 08:24:39',1,272,'d5ba4cef-f7fb-4e3d-8722-756e1712e139',88,'fdf18f1faf4846e2a6e2eab4ac2aec02','gigabytes___DEFAULT__',1,'2026-02-01 08:24:39',NULL),('2026-01-31 08:25:00','2026-01-31 08:25:00','2026-01-31 08:25:00',1,273,'9f687371-f1ee-4851-9094-56338a455ae9',85,'fdf18f1faf4846e2a6e2eab4ac2aec02','volumes',-1,'2026-02-01 08:25:00',NULL),('2026-01-31 08:25:00','2026-01-31 08:25:00','2026-01-31 08:25:00',1,274,'67a4274e-7f1d-4c8b-898f-54cdaa2b11f8',86,'fdf18f1faf4846e2a6e2eab4ac2aec02','gigabytes',-1,'2026-02-01 08:25:00',NULL),('2026-01-31 08:25:00','2026-01-31 08:25:00','2026-01-31 08:25:00',1,275,'7df0a207-5bcd-4a3b-b81e-c56b5537902d',87,'fdf18f1faf4846e2a6e2eab4ac2aec02','volumes___DEFAULT__',-1,'2026-02-01 08:25:00',NULL),('2026-01-31 08:25:00','2026-01-31 08:25:00','2026-01-31 08:25:00',1,276,'b258ba16-9d1c-4ba5-be49-1365447293a0',88,'fdf18f1faf4846e2a6e2eab4ac2aec02','gigabytes___DEFAULT__',-1,'2026-02-01 08:25:00',NULL),('2026-01-31 08:25:03','2026-01-31 08:25:03','2026-01-31 08:25:03',1,277,'cfca0030-1cd3-49aa-91fc-efd849ea3368',85,'fdf18f1faf4846e2a6e2eab4ac2aec02','volumes',-1,'2026-02-01 08:25:03',NULL),('2026-01-31 08:25:03','2026-01-31 08:25:03','2026-01-31 08:25:03',1,278,'97642b3f-8df3-4e38-8e74-73acb2054acd',86,'fdf18f1faf4846e2a6e2eab4ac2aec02','gigabytes',-1,'2026-02-01 08:25:03',NULL),('2026-01-31 08:25:03','2026-01-31 08:25:03','2026-01-31 08:25:03',1,279,'f0dba209-b7ac-4026-aab7-07db8ff394da',87,'fdf18f1faf4846e2a6e2eab4ac2aec02','volumes___DEFAULT__',-1,'2026-02-01 08:25:03',NULL),('2026-01-31 08:25:03','2026-01-31 08:25:03','2026-01-31 08:25:03',1,280,'bc0a46ff-8caf-463a-b958-1aba9669ea42',88,'fdf18f1faf4846e2a6e2eab4ac2aec02','gigabytes___DEFAULT__',-1,'2026-02-01 08:25:03',NULL),('2026-01-31 08:25:06','2026-01-31 08:25:07','2026-01-31 08:25:07',1,281,'45f3a426-6244-4070-a6ea-5c5a34fee4de',85,'fdf18f1faf4846e2a6e2eab4ac2aec02','volumes',-1,'2026-02-01 08:25:06',NULL),('2026-01-31 08:25:06','2026-01-31 08:25:07','2026-01-31 08:25:07',1,282,'946a4537-ffbe-4d2a-b386-c39b2dad7d56',86,'fdf18f1faf4846e2a6e2eab4ac2aec02','gigabytes',-1,'2026-02-01 08:25:06',NULL),('2026-01-31 08:25:06','2026-01-31 08:25:07','2026-01-31 08:25:07',1,283,'26e3978c-3491-47d0-84dd-349b56a6cab5',87,'fdf18f1faf4846e2a6e2eab4ac2aec02','volumes___DEFAULT__',-1,'2026-02-01 08:25:06',NULL),('2026-01-31 08:25:07','2026-01-31 08:25:07','2026-01-31 08:25:07',1,284,'ba2bf117-937f-4f00-8a0f-95ca2ae94372',88,'fdf18f1faf4846e2a6e2eab4ac2aec02','gigabytes___DEFAULT__',-1,'2026-02-01 08:25:06',NULL),('2026-01-31 08:26:23','2026-01-31 08:26:23','2026-01-31 08:26:23',1,285,'59371648-b0fd-4643-86e0-acc8e2150f9f',89,'48bbdbdee526499e90da7e971ede68d3','volumes',1,'2026-02-01 08:26:23',NULL),('2026-01-31 08:26:23','2026-01-31 08:26:23','2026-01-31 08:26:23',1,286,'499daaf6-94ad-4435-bba7-8d842b515b51',90,'48bbdbdee526499e90da7e971ede68d3','gigabytes',1,'2026-02-01 08:26:23',NULL),('2026-01-31 08:26:23','2026-01-31 08:26:23','2026-01-31 08:26:23',1,287,'9ef16fe9-3faa-41af-b580-dabb37715ee8',91,'48bbdbdee526499e90da7e971ede68d3','volumes_multiattach',1,'2026-02-01 08:26:23',NULL),('2026-01-31 08:26:23','2026-01-31 08:26:23','2026-01-31 08:26:23',1,288,'7f07329a-0558-4d60-9fb2-4333e44f4f0e',92,'48bbdbdee526499e90da7e971ede68d3','gigabytes_multiattach',1,'2026-02-01 08:26:23',NULL),('2026-01-31 08:27:07','2026-01-31 08:27:08','2026-01-31 08:27:08',1,289,'d9a37f03-014c-45c1-9d02-97a91b8f065a',93,'418d5319c640455ab23850c0b0f24f92','volumes',1,'2026-02-01 08:27:07',NULL),('2026-01-31 08:27:07','2026-01-31 08:27:08','2026-01-31 08:27:08',1,290,'f732e97f-6be8-4d3f-a128-49ee8840d420',94,'418d5319c640455ab23850c0b0f24f92','gigabytes',1,'2026-02-01 08:27:07',NULL),('2026-01-31 08:27:07','2026-01-31 08:27:08','2026-01-31 08:27:08',1,291,'532557d5-fd91-4714-bafe-d2275ea76d7f',95,'418d5319c640455ab23850c0b0f24f92','volumes___DEFAULT__',1,'2026-02-01 08:27:07',NULL),('2026-01-31 08:27:07','2026-01-31 08:27:08','2026-01-31 08:27:08',1,292,'764e9420-9ec2-4913-988b-6db16db28ec9',96,'418d5319c640455ab23850c0b0f24f92','gigabytes___DEFAULT__',1,'2026-02-01 08:27:07',NULL),('2026-01-31 08:27:32','2026-01-31 08:27:32','2026-01-31 08:27:32',1,293,'330a7658-a259-4f1c-b563-ef7ddb7e0eaf',89,'48bbdbdee526499e90da7e971ede68d3','volumes',1,'2026-02-01 08:27:32',NULL),('2026-01-31 08:27:32','2026-01-31 08:27:32','2026-01-31 08:27:32',1,294,'346240e5-17e7-40b8-ae19-8d75ff4eaa2c',90,'48bbdbdee526499e90da7e971ede68d3','gigabytes',1,'2026-02-01 08:27:32',NULL),('2026-01-31 08:27:32','2026-01-31 08:27:32','2026-01-31 08:27:32',1,295,'20c6c157-8955-46c8-b3b7-4bee46b8e5bf',91,'48bbdbdee526499e90da7e971ede68d3','volumes_multiattach',1,'2026-02-01 08:27:32',NULL),('2026-01-31 08:27:32','2026-01-31 08:27:32','2026-01-31 08:27:32',1,296,'834b7699-bc54-4025-9246-1e8a709850df',92,'48bbdbdee526499e90da7e971ede68d3','gigabytes_multiattach',1,'2026-02-01 08:27:32',NULL),('2026-01-31 08:29:04','2026-01-31 08:29:04','2026-01-31 08:29:04',1,297,'a65369e0-c947-4f18-bd42-6bb69ae0be3c',97,'722ab2e9dd674709953be812d4c88493','volumes',1,'2026-02-01 08:29:04',NULL),('2026-01-31 08:29:04','2026-01-31 08:29:04','2026-01-31 08:29:04',1,298,'4d5c587f-3210-436d-88cc-7765275cddba',98,'722ab2e9dd674709953be812d4c88493','gigabytes',1,'2026-02-01 08:29:04',NULL),('2026-01-31 08:29:04','2026-01-31 08:29:04','2026-01-31 08:29:04',1,299,'7ce93957-a379-41c7-96f3-1a84af4d704c',99,'722ab2e9dd674709953be812d4c88493','volumes___DEFAULT__',1,'2026-02-01 08:29:04',NULL),('2026-01-31 08:29:04','2026-01-31 08:29:04','2026-01-31 08:29:04',1,300,'aac074b2-b0d8-4802-9ba1-1c8287710791',100,'722ab2e9dd674709953be812d4c88493','gigabytes___DEFAULT__',1,'2026-02-01 08:29:04',NULL),('2026-01-31 08:29:13','2026-01-31 08:29:13','2026-01-31 08:29:13',1,301,'28783d00-6493-4748-9b33-9b7ebd90357d',97,'722ab2e9dd674709953be812d4c88493','volumes',1,'2026-02-01 08:29:13',NULL),('2026-01-31 08:29:13','2026-01-31 08:29:13','2026-01-31 08:29:13',1,302,'fc8d2d76-b05d-44a8-8e9f-71fbcb48f33d',98,'722ab2e9dd674709953be812d4c88493','gigabytes',1,'2026-02-01 08:29:13',NULL),('2026-01-31 08:29:13','2026-01-31 08:29:13','2026-01-31 08:29:13',1,303,'8d1a0685-bc33-4110-ac4e-2b3bdb4adffa',99,'722ab2e9dd674709953be812d4c88493','volumes___DEFAULT__',1,'2026-02-01 08:29:13',NULL),('2026-01-31 08:29:13','2026-01-31 08:29:13','2026-01-31 08:29:13',1,304,'508181d2-f05c-4d83-854d-33d1be3b9e39',100,'722ab2e9dd674709953be812d4c88493','gigabytes___DEFAULT__',1,'2026-02-01 08:29:13',NULL),('2026-01-31 08:29:52','2026-01-31 08:29:52','2026-01-31 08:29:52',1,305,'cfa1fcf2-71d2-4e68-9bc1-dbcf73dde782',89,'48bbdbdee526499e90da7e971ede68d3','volumes',1,'2026-02-01 08:29:52',NULL),('2026-01-31 08:29:52','2026-01-31 08:29:52','2026-01-31 08:29:52',1,306,'d9c00c14-9745-4923-ba1e-ba734e2764e2',90,'48bbdbdee526499e90da7e971ede68d3','gigabytes',1,'2026-02-01 08:29:52',NULL),('2026-01-31 08:29:52','2026-01-31 08:29:52','2026-01-31 08:29:52',1,307,'89ec77de-e77f-4629-9f34-7b392e456845',91,'48bbdbdee526499e90da7e971ede68d3','volumes_multiattach',1,'2026-02-01 08:29:52',NULL),('2026-01-31 08:29:52','2026-01-31 08:29:52','2026-01-31 08:29:52',1,308,'73320e7c-49d2-4cdf-8f76-6c511609d988',92,'48bbdbdee526499e90da7e971ede68d3','gigabytes_multiattach',1,'2026-02-01 08:29:52',NULL),('2026-01-31 08:30:05','2026-01-31 08:30:05','2026-01-31 08:30:05',1,309,'1a874b7f-16b2-4837-a488-62cd2a28d33e',93,'418d5319c640455ab23850c0b0f24f92','volumes',1,'2026-02-01 08:30:05',NULL),('2026-01-31 08:30:05','2026-01-31 08:30:05','2026-01-31 08:30:05',1,310,'00b52e80-7dbb-4314-8c8e-0d0ddeb590a5',94,'418d5319c640455ab23850c0b0f24f92','gigabytes',1,'2026-02-01 08:30:05',NULL),('2026-01-31 08:30:05','2026-01-31 08:30:05','2026-01-31 08:30:05',1,311,'32ca64ec-295f-48dc-84eb-2540ae9ff9bc',95,'418d5319c640455ab23850c0b0f24f92','volumes___DEFAULT__',1,'2026-02-01 08:30:05',NULL),('2026-01-31 08:30:05','2026-01-31 08:30:05','2026-01-31 08:30:05',1,312,'0e372c5c-be79-4513-bc1e-b9045b939c34',96,'418d5319c640455ab23850c0b0f24f92','gigabytes___DEFAULT__',1,'2026-02-01 08:30:05',NULL),('2026-01-31 08:30:29','2026-01-31 08:30:29','2026-01-31 08:30:29',1,313,'a06f82c9-f563-4e23-8e40-6859ddc81846',101,'48bbdbdee526499e90da7e971ede68d3','snapshots',1,'2026-02-01 08:30:29',NULL),('2026-01-31 08:30:29','2026-01-31 08:30:29','2026-01-31 08:30:29',1,314,'025293fe-5e14-4eee-ac77-094f6b37ebe1',90,'48bbdbdee526499e90da7e971ede68d3','gigabytes',1,'2026-02-01 08:30:29',NULL),('2026-01-31 08:30:29','2026-01-31 08:30:29','2026-01-31 08:30:29',1,315,'af1ca636-ed73-47b0-a14a-607fc3d3de65',92,'48bbdbdee526499e90da7e971ede68d3','gigabytes_multiattach',1,'2026-02-01 08:30:29',NULL),('2026-01-31 08:30:29','2026-01-31 08:30:29','2026-01-31 08:30:29',1,316,'c057bd59-d6b5-4ee4-9213-d67f730da1e4',102,'48bbdbdee526499e90da7e971ede68d3','snapshots_multiattach',1,'2026-02-01 08:30:29',NULL),('2026-01-31 08:30:47','2026-01-31 08:30:48','2026-01-31 08:30:48',1,317,'00282e0f-112a-4536-831b-78afd134f815',101,'48bbdbdee526499e90da7e971ede68d3','snapshots',-1,'2026-02-01 08:30:47',NULL),('2026-01-31 08:30:47','2026-01-31 08:30:48','2026-01-31 08:30:48',1,318,'e24d8068-271c-4bd4-a93b-1acebc1bdb70',90,'48bbdbdee526499e90da7e971ede68d3','gigabytes',-1,'2026-02-01 08:30:47',NULL),('2026-01-31 08:30:47','2026-01-31 08:30:48','2026-01-31 08:30:48',1,319,'4195fd1a-0f02-487f-99ab-67a91547b36b',92,'48bbdbdee526499e90da7e971ede68d3','gigabytes_multiattach',-1,'2026-02-01 08:30:47',NULL),('2026-01-31 08:30:47','2026-01-31 08:30:48','2026-01-31 08:30:48',1,320,'afb15702-0475-46dd-8e88-e807487aa8dd',102,'48bbdbdee526499e90da7e971ede68d3','snapshots_multiattach',-1,'2026-02-01 08:30:47',NULL),('2026-01-31 08:30:50','2026-01-31 08:30:51','2026-01-31 08:30:51',1,321,'bfb8cf67-afad-498a-92cd-48568068dbb5',89,'48bbdbdee526499e90da7e971ede68d3','volumes',-1,'2026-02-01 08:30:50',NULL),('2026-01-31 08:30:50','2026-01-31 08:30:51','2026-01-31 08:30:51',1,322,'05929e7a-3cf4-4e29-b45d-3919049c3130',90,'48bbdbdee526499e90da7e971ede68d3','gigabytes',-1,'2026-02-01 08:30:50',NULL),('2026-01-31 08:30:50','2026-01-31 08:30:51','2026-01-31 08:30:51',1,323,'bcf5613b-37c4-4c10-901d-cc2892015ba5',91,'48bbdbdee526499e90da7e971ede68d3','volumes_multiattach',-1,'2026-02-01 08:30:50',NULL),('2026-01-31 08:30:50','2026-01-31 08:30:51','2026-01-31 08:30:51',1,324,'e41df25d-cf53-4c36-875e-fdafd292438a',92,'48bbdbdee526499e90da7e971ede68d3','gigabytes_multiattach',-1,'2026-02-01 08:30:50',NULL),('2026-01-31 08:31:03','2026-01-31 08:31:04','2026-01-31 08:31:04',1,325,'5a04291b-12d7-47a4-b925-f143aba47c0b',89,'48bbdbdee526499e90da7e971ede68d3','volumes',-1,'2026-02-01 08:31:03',NULL),('2026-01-31 08:31:03','2026-01-31 08:31:04','2026-01-31 08:31:04',1,326,'50860109-e42b-420d-adb2-266434704ec6',90,'48bbdbdee526499e90da7e971ede68d3','gigabytes',-1,'2026-02-01 08:31:03',NULL),('2026-01-31 08:31:03','2026-01-31 08:31:04','2026-01-31 08:31:04',1,327,'3464f658-cbc2-4bb3-95e2-6391ae897453',91,'48bbdbdee526499e90da7e971ede68d3','volumes_multiattach',-1,'2026-02-01 08:31:03',NULL),('2026-01-31 08:31:03','2026-01-31 08:31:04','2026-01-31 08:31:04',1,328,'6c291165-4cb0-41fa-a442-1be1b5f6afc8',92,'48bbdbdee526499e90da7e971ede68d3','gigabytes_multiattach',-1,'2026-02-01 08:31:03',NULL),('2026-01-31 08:31:20','2026-01-31 08:31:20','2026-01-31 08:31:20',1,329,'b712b69c-6148-4f9c-919f-ec501d2e0f37',93,'418d5319c640455ab23850c0b0f24f92','volumes',1,'2026-02-01 08:31:20',NULL),('2026-01-31 08:31:20','2026-01-31 08:31:20','2026-01-31 08:31:20',1,330,'14ec2a39-8a25-40ad-b034-ac516f16e554',94,'418d5319c640455ab23850c0b0f24f92','gigabytes',1,'2026-02-01 08:31:20',NULL),('2026-01-31 08:31:20','2026-01-31 08:31:20','2026-01-31 08:31:20',1,331,'c825f558-ec8b-4de9-9316-04ca3c450730',95,'418d5319c640455ab23850c0b0f24f92','volumes___DEFAULT__',1,'2026-02-01 08:31:20',NULL),('2026-01-31 08:31:20','2026-01-31 08:31:20','2026-01-31 08:31:20',1,332,'98dee601-8958-4686-8ff4-96f735f57b08',96,'418d5319c640455ab23850c0b0f24f92','gigabytes___DEFAULT__',1,'2026-02-01 08:31:20',NULL),('2026-01-31 08:31:33','2026-01-31 08:31:33','2026-01-31 08:31:33',1,333,'7ae64727-31fd-4ce9-9cc6-47b5c9cb0afa',89,'48bbdbdee526499e90da7e971ede68d3','volumes',-1,'2026-02-01 08:31:32',NULL),('2026-01-31 08:31:33','2026-01-31 08:31:33','2026-01-31 08:31:33',1,334,'b74860d5-b86c-4386-bd08-108923c10569',90,'48bbdbdee526499e90da7e971ede68d3','gigabytes',-1,'2026-02-01 08:31:32',NULL),('2026-01-31 08:31:33','2026-01-31 08:31:33','2026-01-31 08:31:33',1,335,'c0f256e3-d8de-41a4-bfdd-c5d70d72d3d3',91,'48bbdbdee526499e90da7e971ede68d3','volumes_multiattach',-1,'2026-02-01 08:31:32',NULL),('2026-01-31 08:31:33','2026-01-31 08:31:33','2026-01-31 08:31:33',1,336,'41f589ad-a0f2-447b-83a9-92a00d02d240',92,'48bbdbdee526499e90da7e971ede68d3','gigabytes_multiattach',-1,'2026-02-01 08:31:32',NULL),('2026-01-31 08:31:46','2026-01-31 08:31:47','2026-01-31 08:31:47',1,337,'0b7419d8-8065-4fa1-9e8f-feeb3730be8e',93,'418d5319c640455ab23850c0b0f24f92','volumes',-1,'2026-02-01 08:31:46',NULL),('2026-01-31 08:31:46','2026-01-31 08:31:47','2026-01-31 08:31:47',1,338,'7253d069-e2c8-4a6c-8ea3-e1f7b1335652',94,'418d5319c640455ab23850c0b0f24f92','gigabytes',-1,'2026-02-01 08:31:46',NULL),('2026-01-31 08:31:46','2026-01-31 08:31:47','2026-01-31 08:31:47',1,339,'2d436a9d-4e23-4750-b6f5-57089b2a3d72',95,'418d5319c640455ab23850c0b0f24f92','volumes___DEFAULT__',-1,'2026-02-01 08:31:46',NULL),('2026-01-31 08:31:46','2026-01-31 08:31:47','2026-01-31 08:31:47',1,340,'f6c9b644-56df-4574-b8dc-0e0b1594a40e',96,'418d5319c640455ab23850c0b0f24f92','gigabytes___DEFAULT__',-1,'2026-02-01 08:31:46',NULL),('2026-01-31 08:31:59','2026-01-31 08:31:59','2026-01-31 08:31:59',1,341,'bf8f634e-4a8c-45a7-af17-6ff1fdca2f93',93,'418d5319c640455ab23850c0b0f24f92','volumes',-1,'2026-02-01 08:31:59',NULL),('2026-01-31 08:31:59','2026-01-31 08:31:59','2026-01-31 08:31:59',1,342,'3522ea0c-08d9-445b-8837-301d9befb3be',94,'418d5319c640455ab23850c0b0f24f92','gigabytes',-1,'2026-02-01 08:31:59',NULL),('2026-01-31 08:31:59','2026-01-31 08:31:59','2026-01-31 08:31:59',1,343,'5d5028f0-88da-4689-8274-a39e080108ee',95,'418d5319c640455ab23850c0b0f24f92','volumes___DEFAULT__',-1,'2026-02-01 08:31:59',NULL),('2026-01-31 08:31:59','2026-01-31 08:31:59','2026-01-31 08:31:59',1,344,'7356bce4-d01e-4b72-b311-619499e28ad9',96,'418d5319c640455ab23850c0b0f24f92','gigabytes___DEFAULT__',-1,'2026-02-01 08:31:59',NULL),('2026-01-31 08:32:04','2026-01-31 08:32:05','2026-01-31 08:32:05',1,345,'8784ee5e-911c-4c8c-9ff1-eb71f2d46593',93,'418d5319c640455ab23850c0b0f24f92','volumes',-1,'2026-02-01 08:32:04',NULL),('2026-01-31 08:32:04','2026-01-31 08:32:05','2026-01-31 08:32:05',1,346,'e8065844-e5ae-44ec-b768-145ddaf63937',94,'418d5319c640455ab23850c0b0f24f92','gigabytes',-1,'2026-02-01 08:32:04',NULL),('2026-01-31 08:32:04','2026-01-31 08:32:05','2026-01-31 08:32:05',1,347,'3ce5a41f-d2fb-4ee7-871a-fc9457a83e3e',95,'418d5319c640455ab23850c0b0f24f92','volumes___DEFAULT__',-1,'2026-02-01 08:32:04',NULL),('2026-01-31 08:32:04','2026-01-31 08:32:05','2026-01-31 08:32:05',1,348,'fdea9931-5b69-4a7a-ad58-e7b4dcdd3fd6',96,'418d5319c640455ab23850c0b0f24f92','gigabytes___DEFAULT__',-1,'2026-02-01 08:32:04',NULL),('2026-01-31 08:32:17','2026-01-31 08:32:17','2026-01-31 08:32:17',1,349,'55628b5a-d546-408c-93f4-223e701c7854',89,'48bbdbdee526499e90da7e971ede68d3','volumes',-1,'2026-02-01 08:32:17',NULL),('2026-01-31 08:32:17','2026-01-31 08:32:17','2026-01-31 08:32:17',1,350,'9d280254-420a-4845-8a2e-93674a0f223f',90,'48bbdbdee526499e90da7e971ede68d3','gigabytes',-1,'2026-02-01 08:32:17',NULL),('2026-01-31 08:32:17','2026-01-31 08:32:17','2026-01-31 08:32:17',1,351,'3ac401a4-b737-49b6-ae9d-c0feee3594a2',91,'48bbdbdee526499e90da7e971ede68d3','volumes_multiattach',-1,'2026-02-01 08:32:17',NULL),('2026-01-31 08:32:17','2026-01-31 08:32:17','2026-01-31 08:32:17',1,352,'07d902da-c796-44ce-90de-53b358757ae4',92,'48bbdbdee526499e90da7e971ede68d3','gigabytes_multiattach',-1,'2026-02-01 08:32:17',NULL),('2026-01-31 08:32:34','2026-01-31 08:32:34','2026-01-31 08:32:34',1,353,'3b9701e9-2d7b-4846-a2fd-29382b1b18a9',103,'b71e7a1d6f714f7680acaa04670308f6','volumes',1,'2026-02-01 08:32:33',NULL),('2026-01-31 08:32:34','2026-01-31 08:32:34','2026-01-31 08:32:34',1,354,'0cd339ee-20c2-46c2-842c-874769bbcc66',104,'b71e7a1d6f714f7680acaa04670308f6','gigabytes',1,'2026-02-01 08:32:33',NULL),('2026-01-31 08:32:34','2026-01-31 08:32:34','2026-01-31 08:32:34',1,355,'3dd375ba-9a22-4717-8d7c-3c1572e0926a',105,'b71e7a1d6f714f7680acaa04670308f6','volumes___DEFAULT__',1,'2026-02-01 08:32:33',NULL),('2026-01-31 08:32:34','2026-01-31 08:32:34','2026-01-31 08:32:34',1,356,'237416c3-11f7-47f5-a938-69d1525377a7',106,'b71e7a1d6f714f7680acaa04670308f6','gigabytes___DEFAULT__',1,'2026-02-01 08:32:33',NULL),('2026-01-31 08:32:38','2026-01-31 08:32:38','2026-01-31 08:32:38',1,357,'b2914f0c-0f9b-49d9-b871-553181b2abc5',103,'b71e7a1d6f714f7680acaa04670308f6','volumes',-1,'2026-02-01 08:32:38',NULL),('2026-01-31 08:32:38','2026-01-31 08:32:38','2026-01-31 08:32:38',1,358,'b00c474a-ad69-4efe-b974-862905cf8dbf',104,'b71e7a1d6f714f7680acaa04670308f6','gigabytes',-1,'2026-02-01 08:32:38',NULL),('2026-01-31 08:32:38','2026-01-31 08:32:38','2026-01-31 08:32:38',1,359,'2c9593de-335c-47c9-9b6c-47c245928e0e',105,'b71e7a1d6f714f7680acaa04670308f6','volumes___DEFAULT__',-1,'2026-02-01 08:32:38',NULL),('2026-01-31 08:32:38','2026-01-31 08:32:38','2026-01-31 08:32:38',1,360,'2666ff30-aaad-4b8a-96e5-32dfd7b50637',106,'b71e7a1d6f714f7680acaa04670308f6','gigabytes___DEFAULT__',-1,'2026-02-01 08:32:38',NULL),('2026-01-31 08:32:51','2026-01-31 08:32:52','2026-01-31 08:32:52',1,361,'5a80b1e4-5191-4a20-ae98-f9220dea3ae7',107,'92845e9c9ab24edbb2412cff577a0903','volumes',1,'2026-02-01 08:32:51',NULL),('2026-01-31 08:32:51','2026-01-31 08:32:52','2026-01-31 08:32:52',1,362,'48f1c9ad-b888-4c99-bb4b-4df4a0be6d68',108,'92845e9c9ab24edbb2412cff577a0903','gigabytes',1,'2026-02-01 08:32:51',NULL),('2026-01-31 08:32:51','2026-01-31 08:32:52','2026-01-31 08:32:52',1,363,'856128f4-c38f-479d-9772-5e0949d41497',109,'92845e9c9ab24edbb2412cff577a0903','volumes___DEFAULT__',1,'2026-02-01 08:32:51',NULL),('2026-01-31 08:32:51','2026-01-31 08:32:52','2026-01-31 08:32:52',1,364,'753ac887-11c7-4eb3-a18b-47cd032ce6ac',110,'92845e9c9ab24edbb2412cff577a0903','gigabytes___DEFAULT__',1,'2026-02-01 08:32:51',NULL),('2026-01-31 08:33:03','2026-01-31 08:33:04','2026-01-31 08:33:04',1,365,'e5468534-1c2e-46f4-b880-cf898a2be05d',107,'92845e9c9ab24edbb2412cff577a0903','volumes',1,'2026-02-01 08:33:03',NULL),('2026-01-31 08:33:03','2026-01-31 08:33:04','2026-01-31 08:33:04',1,366,'655e016c-404d-4910-b7af-3a4c787e470d',108,'92845e9c9ab24edbb2412cff577a0903','gigabytes',1,'2026-02-01 08:33:03',NULL),('2026-01-31 08:33:03','2026-01-31 08:33:04','2026-01-31 08:33:04',1,367,'f0a86cf2-875b-4235-baaf-cde89973370e',109,'92845e9c9ab24edbb2412cff577a0903','volumes___DEFAULT__',1,'2026-02-01 08:33:03',NULL),('2026-01-31 08:33:03','2026-01-31 08:33:04','2026-01-31 08:33:04',1,368,'25c6d207-0b62-4714-83e1-6de1b4f86995',110,'92845e9c9ab24edbb2412cff577a0903','gigabytes___DEFAULT__',1,'2026-02-01 08:33:03',NULL),('2026-01-31 08:33:10','2026-01-31 08:33:10','2026-01-31 08:33:10',1,369,'08876fe7-a217-4bee-8a7b-68e53c4619d7',107,'92845e9c9ab24edbb2412cff577a0903','volumes',1,'2026-02-01 08:33:10',NULL),('2026-01-31 08:33:10','2026-01-31 08:33:10','2026-01-31 08:33:10',1,370,'6271875b-60b8-4d6b-a5f4-764701ff8b45',108,'92845e9c9ab24edbb2412cff577a0903','gigabytes',1,'2026-02-01 08:33:10',NULL),('2026-01-31 08:33:10','2026-01-31 08:33:10','2026-01-31 08:33:10',1,371,'4195c7d1-fa07-4478-9c1d-d97176f88b19',109,'92845e9c9ab24edbb2412cff577a0903','volumes___DEFAULT__',1,'2026-02-01 08:33:10',NULL),('2026-01-31 08:33:10','2026-01-31 08:33:10','2026-01-31 08:33:10',1,372,'7af43199-93a0-40dc-a1e6-bad1720abd26',110,'92845e9c9ab24edbb2412cff577a0903','gigabytes___DEFAULT__',1,'2026-02-01 08:33:10',NULL),('2026-01-31 08:33:12','2026-01-31 08:33:12','2026-01-31 08:33:12',1,373,'fd24f895-03f6-4236-9b49-8e034669ff1e',97,'722ab2e9dd674709953be812d4c88493','volumes',-1,'2026-02-01 08:33:12',NULL),('2026-01-31 08:33:12','2026-01-31 08:33:12','2026-01-31 08:33:12',1,374,'39c22f5a-13e7-4f49-8180-742da5bfa758',98,'722ab2e9dd674709953be812d4c88493','gigabytes',-1,'2026-02-01 08:33:12',NULL),('2026-01-31 08:33:12','2026-01-31 08:33:12','2026-01-31 08:33:12',1,375,'9857481e-8a58-4142-a3bb-8e75dc28dca1',99,'722ab2e9dd674709953be812d4c88493','volumes___DEFAULT__',-1,'2026-02-01 08:33:12',NULL),('2026-01-31 08:33:12','2026-01-31 08:33:12','2026-01-31 08:33:12',1,376,'edaf2749-c42e-479b-adf2-25dddec337d9',100,'722ab2e9dd674709953be812d4c88493','gigabytes___DEFAULT__',-1,'2026-02-01 08:33:12',NULL),('2026-01-31 08:33:17','2026-01-31 08:33:17','2026-01-31 08:33:17',1,377,'e580e8f7-652d-4c08-8367-67bf6d64cd9c',97,'722ab2e9dd674709953be812d4c88493','volumes',-1,'2026-02-01 08:33:16',NULL),('2026-01-31 08:33:17','2026-01-31 08:33:17','2026-01-31 08:33:17',1,378,'685fc1d6-eb86-40f5-8c8d-7d7cc09417c5',98,'722ab2e9dd674709953be812d4c88493','gigabytes',-1,'2026-02-01 08:33:16',NULL),('2026-01-31 08:33:17','2026-01-31 08:33:17','2026-01-31 08:33:17',1,379,'6aab8257-8044-4c21-a5f7-18012684e845',99,'722ab2e9dd674709953be812d4c88493','volumes___DEFAULT__',-1,'2026-02-01 08:33:16',NULL),('2026-01-31 08:33:17','2026-01-31 08:33:17','2026-01-31 08:33:17',1,380,'69ccb20e-b202-4174-b11d-d5b324f82980',100,'722ab2e9dd674709953be812d4c88493','gigabytes___DEFAULT__',-1,'2026-02-01 08:33:16',NULL),('2026-01-31 08:33:21','2026-01-31 08:33:21','2026-01-31 08:33:21',1,381,'d90f8ef0-2225-479c-9498-716ab812d6eb',107,'92845e9c9ab24edbb2412cff577a0903','volumes',-1,'2026-02-01 08:33:21',NULL),('2026-01-31 08:33:21','2026-01-31 08:33:21','2026-01-31 08:33:21',1,382,'49379311-0b25-49fd-be75-7105e56984e7',108,'92845e9c9ab24edbb2412cff577a0903','gigabytes',-1,'2026-02-01 08:33:21',NULL),('2026-01-31 08:33:21','2026-01-31 08:33:21','2026-01-31 08:33:21',1,383,'ee7c63a8-864a-4d04-8bd1-3eeed5590fe2',109,'92845e9c9ab24edbb2412cff577a0903','volumes___DEFAULT__',-1,'2026-02-01 08:33:21',NULL),('2026-01-31 08:33:21','2026-01-31 08:33:21','2026-01-31 08:33:21',1,384,'6fe7e44b-e027-4dc9-8f74-8304fec8bf60',110,'92845e9c9ab24edbb2412cff577a0903','gigabytes___DEFAULT__',-1,'2026-02-01 08:33:21',NULL),('2026-01-31 08:33:22','2026-01-31 08:33:22','2026-01-31 08:33:22',1,385,'4dc8a5e9-c902-4b4e-a516-947a05bf7090',107,'92845e9c9ab24edbb2412cff577a0903','volumes',-1,'2026-02-01 08:33:22',NULL),('2026-01-31 08:33:22','2026-01-31 08:33:22','2026-01-31 08:33:22',1,386,'c40679e4-67ab-4729-ba65-6fa95e769294',108,'92845e9c9ab24edbb2412cff577a0903','gigabytes',-1,'2026-02-01 08:33:22',NULL),('2026-01-31 08:33:22','2026-01-31 08:33:22','2026-01-31 08:33:22',1,387,'a1424f28-b8b7-457b-ac4d-40ccdd60ba0f',109,'92845e9c9ab24edbb2412cff577a0903','volumes___DEFAULT__',-1,'2026-02-01 08:33:22',NULL),('2026-01-31 08:33:22','2026-01-31 08:33:22','2026-01-31 08:33:22',1,388,'6bc38a78-bec2-4d3d-bd41-341c07e8b0dd',110,'92845e9c9ab24edbb2412cff577a0903','gigabytes___DEFAULT__',-1,'2026-02-01 08:33:22',NULL),('2026-01-31 08:33:24','2026-01-31 08:33:25','2026-01-31 08:33:25',1,389,'c072de2a-dd18-4ac2-94c3-17ec6e420775',107,'92845e9c9ab24edbb2412cff577a0903','volumes',-1,'2026-02-01 08:33:24',NULL),('2026-01-31 08:33:24','2026-01-31 08:33:25','2026-01-31 08:33:25',1,390,'67c6efbb-1e7a-40d2-9ab1-31cee9fdd56b',108,'92845e9c9ab24edbb2412cff577a0903','gigabytes',-1,'2026-02-01 08:33:24',NULL),('2026-01-31 08:33:25','2026-01-31 08:33:25','2026-01-31 08:33:25',1,391,'05df9283-7b59-4630-a5f5-1e9154f62ddc',109,'92845e9c9ab24edbb2412cff577a0903','volumes___DEFAULT__',-1,'2026-02-01 08:33:24',NULL),('2026-01-31 08:33:25','2026-01-31 08:33:25','2026-01-31 08:33:25',1,392,'349e4a63-ba94-458e-aec9-3988fe7800b2',110,'92845e9c9ab24edbb2412cff577a0903','gigabytes___DEFAULT__',-1,'2026-02-01 08:33:24',NULL),('2026-01-31 08:34:20','2026-01-31 08:34:20','2026-01-31 08:34:20',1,393,'78104f83-923f-40fc-a7f8-c38cfcade522',111,'149ccba7b87e4284a3a6462e3a1dace1','volumes',1,'2026-02-01 08:34:19',NULL),('2026-01-31 08:34:20','2026-01-31 08:34:20','2026-01-31 08:34:20',1,394,'3fe6386c-6900-4139-85f0-4d24b1b001cd',112,'149ccba7b87e4284a3a6462e3a1dace1','gigabytes',1,'2026-02-01 08:34:19',NULL),('2026-01-31 08:34:20','2026-01-31 08:34:20','2026-01-31 08:34:20',1,395,'96ad49d8-9a27-4288-acf4-8e8e688bfb54',113,'149ccba7b87e4284a3a6462e3a1dace1','volumes_tempest-scenario-type-luks-1109613392',1,'2026-02-01 08:34:19',NULL),('2026-01-31 08:34:20','2026-01-31 08:34:20','2026-01-31 08:34:20',1,396,'40cb8498-1e17-47d0-be3a-fc77ccba60cd',114,'149ccba7b87e4284a3a6462e3a1dace1','gigabytes_tempest-scenario-type-luks-1109613392',1,'2026-02-01 08:34:19',NULL),('2026-01-31 08:36:27','2026-01-31 08:36:28','2026-01-31 08:36:28',1,397,'7242f5f1-85ed-454f-8e67-3d344e83cef9',111,'149ccba7b87e4284a3a6462e3a1dace1','volumes',-1,'2026-02-01 08:36:27',NULL),('2026-01-31 08:36:27','2026-01-31 08:36:28','2026-01-31 08:36:28',1,398,'9a28d546-77f4-4fba-9802-6e96fce7eecf',112,'149ccba7b87e4284a3a6462e3a1dace1','gigabytes',-1,'2026-02-01 08:36:27',NULL),('2026-01-31 08:36:28','2026-01-31 08:36:28','2026-01-31 08:36:28',1,399,'39b5036c-bc12-41ac-b911-1d569afe8559',113,'149ccba7b87e4284a3a6462e3a1dace1','volumes_tempest-scenario-type-luks-1109613392',-1,'2026-02-01 08:36:27',NULL),('2026-01-31 08:36:28','2026-01-31 08:36:28','2026-01-31 08:36:28',1,400,'160f792e-d3a8-4360-b668-9d8a18fb40b5',114,'149ccba7b87e4284a3a6462e3a1dace1','gigabytes_tempest-scenario-type-luks-1109613392',-1,'2026-02-01 08:36:27',NULL),('2026-01-31 08:38:10','2026-01-31 08:38:10','2026-01-31 08:38:10',1,401,'942179a6-4433-4b30-88d1-b44e38f5e6ef',115,'4b38141686534a0fb9b947a7886cd4b6','volumes',1,'2026-02-01 08:38:10',NULL),('2026-01-31 08:38:10','2026-01-31 08:38:10','2026-01-31 08:38:10',1,402,'6eb6636c-fdd7-4026-8506-77b47a6763c1',116,'4b38141686534a0fb9b947a7886cd4b6','gigabytes',1,'2026-02-01 08:38:10',NULL),('2026-01-31 08:38:10','2026-01-31 08:38:10','2026-01-31 08:38:10',1,403,'5071a061-2c4e-48ee-a9e9-69291d27ffaa',117,'4b38141686534a0fb9b947a7886cd4b6','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-580248439-755666519',1,'2026-02-01 08:38:10',NULL),('2026-01-31 08:38:10','2026-01-31 08:38:10','2026-01-31 08:38:10',1,404,'7ae91929-6fd7-44b7-824c-e45b07990744',118,'4b38141686534a0fb9b947a7886cd4b6','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-580248439-755666519',1,'2026-02-01 08:38:10',NULL),('2026-01-31 08:38:10','2026-01-31 08:38:10','2026-01-31 08:38:10',1,405,'60bf7a36-d839-4f08-beaa-31971ac4500a',115,'4b38141686534a0fb9b947a7886cd4b6','volumes',1,'2026-02-01 08:38:10',NULL),('2026-01-31 08:38:10','2026-01-31 08:38:10','2026-01-31 08:38:10',1,406,'04a7f904-6e50-481f-9b88-c48fa65feed9',116,'4b38141686534a0fb9b947a7886cd4b6','gigabytes',1,'2026-02-01 08:38:10',NULL),('2026-01-31 08:38:10','2026-01-31 08:38:10','2026-01-31 08:38:10',1,407,'5dbfac74-06f7-4739-a60e-ebd1475d3946',119,'4b38141686534a0fb9b947a7886cd4b6','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-350934863-1039133705',1,'2026-02-01 08:38:10',NULL),('2026-01-31 08:38:10','2026-01-31 08:38:10','2026-01-31 08:38:10',1,408,'3fcd31d4-140e-407e-9694-f0f672441af2',120,'4b38141686534a0fb9b947a7886cd4b6','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-350934863-1039133705',1,'2026-02-01 08:38:10',NULL),('2026-01-31 08:38:10','2026-01-31 08:38:10','2026-01-31 08:38:10',1,409,'b83befe2-bd09-42b7-b9d9-36a8a62a914a',115,'4b38141686534a0fb9b947a7886cd4b6','volumes',1,'2026-02-01 08:38:10',NULL),('2026-01-31 08:38:10','2026-01-31 08:38:10','2026-01-31 08:38:10',1,410,'668dc6d8-79f9-457f-a49c-f03e35b15499',116,'4b38141686534a0fb9b947a7886cd4b6','gigabytes',1,'2026-02-01 08:38:10',NULL),('2026-01-31 08:38:10','2026-01-31 08:38:10','2026-01-31 08:38:10',1,411,'60974950-ab78-445c-8010-54b9a82b752e',117,'4b38141686534a0fb9b947a7886cd4b6','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-580248439-755666519',1,'2026-02-01 08:38:10',NULL),('2026-01-31 08:38:10','2026-01-31 08:38:10','2026-01-31 08:38:10',1,412,'7a903a7c-90af-4fe6-a1a3-975bb8244bc8',118,'4b38141686534a0fb9b947a7886cd4b6','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-580248439-755666519',1,'2026-02-01 08:38:10',NULL),('2026-01-31 08:38:11','2026-01-31 08:38:11','2026-01-31 08:38:11',1,413,'7af51a44-2290-4da5-9e53-6af2b73b26e4',115,'4b38141686534a0fb9b947a7886cd4b6','volumes',1,'2026-02-01 08:38:11',NULL),('2026-01-31 08:38:11','2026-01-31 08:38:11','2026-01-31 08:38:11',1,414,'8442fa54-8ee6-48f6-891b-06901a5fec2d',116,'4b38141686534a0fb9b947a7886cd4b6','gigabytes',1,'2026-02-01 08:38:11',NULL),('2026-01-31 08:38:11','2026-01-31 08:38:11','2026-01-31 08:38:11',1,415,'65d44f87-648c-4702-9fa5-abafc24c61be',119,'4b38141686534a0fb9b947a7886cd4b6','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-350934863-1039133705',1,'2026-02-01 08:38:11',NULL),('2026-01-31 08:38:11','2026-01-31 08:38:11','2026-01-31 08:38:11',1,416,'eddfcfb3-599e-4526-8862-58f8020b2c5a',120,'4b38141686534a0fb9b947a7886cd4b6','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-350934863-1039133705',1,'2026-02-01 08:38:11',NULL),('2026-01-31 08:38:11','2026-01-31 08:38:11','2026-01-31 08:38:11',1,417,'2f5905d4-0711-4f5a-befb-90a9cd6fce78',115,'4b38141686534a0fb9b947a7886cd4b6','volumes',1,'2026-02-01 08:38:11',NULL),('2026-01-31 08:38:11','2026-01-31 08:38:11','2026-01-31 08:38:11',1,418,'8791f694-1772-4093-93fa-53f012758285',116,'4b38141686534a0fb9b947a7886cd4b6','gigabytes',1,'2026-02-01 08:38:11',NULL),('2026-01-31 08:38:11','2026-01-31 08:38:11','2026-01-31 08:38:11',1,419,'b1e93887-9519-420c-9ea5-570efb45bd16',117,'4b38141686534a0fb9b947a7886cd4b6','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-580248439-755666519',1,'2026-02-01 08:38:11',NULL),('2026-01-31 08:38:11','2026-01-31 08:38:11','2026-01-31 08:38:11',1,420,'9abe78f7-c78d-4eb9-9b9b-bbd06457fed7',118,'4b38141686534a0fb9b947a7886cd4b6','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-580248439-755666519',1,'2026-02-01 08:38:11',NULL),('2026-01-31 08:38:11','2026-01-31 08:38:11','2026-01-31 08:38:11',1,421,'d18af79b-df96-47be-a2a0-8e885a3d4e72',115,'4b38141686534a0fb9b947a7886cd4b6','volumes',1,'2026-02-01 08:38:11',NULL),('2026-01-31 08:38:11','2026-01-31 08:38:11','2026-01-31 08:38:11',1,422,'cbc64032-fc8c-4cd7-a669-a2b35d8070f6',116,'4b38141686534a0fb9b947a7886cd4b6','gigabytes',1,'2026-02-01 08:38:11',NULL),('2026-01-31 08:38:11','2026-01-31 08:38:11','2026-01-31 08:38:11',1,423,'ea64f4c0-78b0-4c3a-939e-cd8c1113f8dd',119,'4b38141686534a0fb9b947a7886cd4b6','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-350934863-1039133705',1,'2026-02-01 08:38:11',NULL),('2026-01-31 08:38:11','2026-01-31 08:38:11','2026-01-31 08:38:11',1,424,'45b3ed92-b1d9-492c-b909-9f22a674240f',120,'4b38141686534a0fb9b947a7886cd4b6','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-350934863-1039133705',1,'2026-02-01 08:38:11',NULL),('2026-01-31 08:38:13','2026-01-31 08:38:14','2026-01-31 08:38:14',1,425,'6da43072-f40d-46bd-bf2b-504bf0adbbc8',115,'4b38141686534a0fb9b947a7886cd4b6','volumes',1,'2026-02-01 08:38:13',NULL),('2026-01-31 08:38:13','2026-01-31 08:38:14','2026-01-31 08:38:14',1,426,'bd2f8abf-ce15-440b-af69-a65f88dae451',116,'4b38141686534a0fb9b947a7886cd4b6','gigabytes',1,'2026-02-01 08:38:13',NULL),('2026-01-31 08:38:13','2026-01-31 08:38:14','2026-01-31 08:38:14',1,427,'9c8c7da9-4606-4e20-92b1-5cdcfab99313',121,'4b38141686534a0fb9b947a7886cd4b6','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-519012021-1114870271',1,'2026-02-01 08:38:13',NULL),('2026-01-31 08:38:13','2026-01-31 08:38:14','2026-01-31 08:38:14',1,428,'2d791df0-9f55-4023-9336-89b726e8b998',122,'4b38141686534a0fb9b947a7886cd4b6','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-519012021-1114870271',1,'2026-02-01 08:38:13',NULL),('2026-01-31 08:38:15','2026-01-31 08:38:15','2026-01-31 08:38:15',1,429,'485a595e-1054-4ebe-a5d7-649f47f2a723',115,'4b38141686534a0fb9b947a7886cd4b6','volumes',1,'2026-02-01 08:38:15',NULL),('2026-01-31 08:38:15','2026-01-31 08:38:15','2026-01-31 08:38:15',1,430,'4f63c91e-593f-47a4-92e7-6ca4724e65a1',116,'4b38141686534a0fb9b947a7886cd4b6','gigabytes',1,'2026-02-01 08:38:15',NULL),('2026-01-31 08:38:15','2026-01-31 08:38:15','2026-01-31 08:38:15',1,431,'e55a1a17-0558-4348-ad96-39d58bd05100',121,'4b38141686534a0fb9b947a7886cd4b6','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-519012021-1114870271',1,'2026-02-01 08:38:15',NULL),('2026-01-31 08:38:15','2026-01-31 08:38:15','2026-01-31 08:38:15',1,432,'e80a9d6b-2b7a-4c21-b59b-5d3eb8d4894b',122,'4b38141686534a0fb9b947a7886cd4b6','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-519012021-1114870271',1,'2026-02-01 08:38:15',NULL),('2026-01-31 08:38:17','2026-01-31 08:38:17','2026-01-31 08:38:17',1,433,'82a8282b-a5ab-4fa2-ad04-92c8f66b2861',115,'4b38141686534a0fb9b947a7886cd4b6','volumes',1,'2026-02-01 08:38:17',NULL),('2026-01-31 08:38:17','2026-01-31 08:38:17','2026-01-31 08:38:17',1,434,'751802f0-fcd4-42d8-a2f5-fa3870dd22d6',116,'4b38141686534a0fb9b947a7886cd4b6','gigabytes',1,'2026-02-01 08:38:17',NULL),('2026-01-31 08:38:17','2026-01-31 08:38:17','2026-01-31 08:38:17',1,435,'a7b33f16-493f-4b1b-9f0e-17f6a7d5053a',121,'4b38141686534a0fb9b947a7886cd4b6','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-519012021-1114870271',1,'2026-02-01 08:38:17',NULL),('2026-01-31 08:38:17','2026-01-31 08:38:17','2026-01-31 08:38:17',1,436,'62b9ce71-1b45-4f82-a2aa-537214b8bbe7',122,'4b38141686534a0fb9b947a7886cd4b6','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-519012021-1114870271',1,'2026-02-01 08:38:17',NULL),('2026-01-31 08:39:51','2026-01-31 08:39:51','2026-01-31 08:39:51',1,437,'ebc50888-a12e-45b8-ae9b-fad21710c34e',115,'4b38141686534a0fb9b947a7886cd4b6','volumes',-1,'2026-02-01 08:39:51',NULL),('2026-01-31 08:39:51','2026-01-31 08:39:51','2026-01-31 08:39:51',1,438,'74092114-2cc5-4f6c-b361-d4d952846ccb',116,'4b38141686534a0fb9b947a7886cd4b6','gigabytes',-1,'2026-02-01 08:39:51',NULL),('2026-01-31 08:39:51','2026-01-31 08:39:51','2026-01-31 08:39:51',1,439,'916d1fce-1722-4478-8f76-61124744dbfa',117,'4b38141686534a0fb9b947a7886cd4b6','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-580248439-755666519',-1,'2026-02-01 08:39:51',NULL),('2026-01-31 08:39:51','2026-01-31 08:39:51','2026-01-31 08:39:51',1,440,'e5d58c61-7363-4db2-bb1d-40478c95b941',118,'4b38141686534a0fb9b947a7886cd4b6','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-580248439-755666519',-1,'2026-02-01 08:39:51',NULL),('2026-01-31 08:40:01','2026-01-31 08:40:01','2026-01-31 08:40:01',1,441,'f2db0abc-02f0-4011-8993-c72527e0e8af',115,'4b38141686534a0fb9b947a7886cd4b6','volumes',-1,'2026-02-01 08:40:01',NULL),('2026-01-31 08:40:01','2026-01-31 08:40:01','2026-01-31 08:40:01',1,442,'8340af03-c8f8-44bc-beeb-c64023c965fb',116,'4b38141686534a0fb9b947a7886cd4b6','gigabytes',-1,'2026-02-01 08:40:01',NULL),('2026-01-31 08:40:01','2026-01-31 08:40:01','2026-01-31 08:40:01',1,443,'957aa876-684c-4f49-87e7-5e0df7dff2b9',119,'4b38141686534a0fb9b947a7886cd4b6','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-350934863-1039133705',-1,'2026-02-01 08:40:01',NULL),('2026-01-31 08:40:01','2026-01-31 08:40:01','2026-01-31 08:40:01',1,444,'c1918693-53d3-46ef-881a-a0e1c1ef17c5',120,'4b38141686534a0fb9b947a7886cd4b6','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-350934863-1039133705',-1,'2026-02-01 08:40:01',NULL),('2026-01-31 08:41:04','2026-01-31 08:41:05','2026-01-31 08:41:05',1,445,'e10e3fd3-7d43-496c-a182-89519016f9fe',115,'4b38141686534a0fb9b947a7886cd4b6','volumes',-1,'2026-02-01 08:41:04',NULL),('2026-01-31 08:41:04','2026-01-31 08:41:05','2026-01-31 08:41:05',1,446,'c08b748e-2cf8-4457-ba8d-6aeb7e369dbf',116,'4b38141686534a0fb9b947a7886cd4b6','gigabytes',-1,'2026-02-01 08:41:04',NULL),('2026-01-31 08:41:04','2026-01-31 08:41:05','2026-01-31 08:41:05',1,447,'889c2da6-057c-4227-a191-11325bf6cea7',117,'4b38141686534a0fb9b947a7886cd4b6','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-580248439-755666519',-1,'2026-02-01 08:41:04',NULL),('2026-01-31 08:41:04','2026-01-31 08:41:05','2026-01-31 08:41:05',1,448,'2e6cd5f4-a87a-405c-a380-6fa0608a154f',118,'4b38141686534a0fb9b947a7886cd4b6','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-580248439-755666519',-1,'2026-02-01 08:41:04',NULL),('2026-01-31 08:41:10','2026-01-31 08:41:10','2026-01-31 08:41:10',1,449,'fc7f2ed8-7024-4f0c-b3a6-06e3c7bccd97',115,'4b38141686534a0fb9b947a7886cd4b6','volumes',-1,'2026-02-01 08:41:10',NULL),('2026-01-31 08:41:10','2026-01-31 08:41:10','2026-01-31 08:41:10',1,450,'7e4b1fd6-7e82-404c-a728-db04e76e4903',116,'4b38141686534a0fb9b947a7886cd4b6','gigabytes',-1,'2026-02-01 08:41:10',NULL),('2026-01-31 08:41:10','2026-01-31 08:41:10','2026-01-31 08:41:10',1,451,'65248a8b-73a5-4fdf-976e-8d33b529e677',119,'4b38141686534a0fb9b947a7886cd4b6','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-350934863-1039133705',-1,'2026-02-01 08:41:10',NULL),('2026-01-31 08:41:10','2026-01-31 08:41:10','2026-01-31 08:41:10',1,452,'bc3feff5-0991-4a48-bbbf-316d614cff20',120,'4b38141686534a0fb9b947a7886cd4b6','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-350934863-1039133705',-1,'2026-02-01 08:41:10',NULL),('2026-01-31 08:42:10','2026-01-31 08:42:10','2026-01-31 08:42:10',1,453,'b0ad398c-6bfe-4e70-a19d-fa3ae8d91e6c',115,'4b38141686534a0fb9b947a7886cd4b6','volumes',-1,'2026-02-01 08:42:10',NULL),('2026-01-31 08:42:10','2026-01-31 08:42:10','2026-01-31 08:42:10',1,454,'ebb50016-736a-4928-a5e2-c24783357b52',116,'4b38141686534a0fb9b947a7886cd4b6','gigabytes',-1,'2026-02-01 08:42:10',NULL),('2026-01-31 08:42:10','2026-01-31 08:42:10','2026-01-31 08:42:10',1,455,'6434d249-affc-4bc9-93f7-9712c5a5479f',117,'4b38141686534a0fb9b947a7886cd4b6','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-580248439-755666519',-1,'2026-02-01 08:42:10',NULL),('2026-01-31 08:42:10','2026-01-31 08:42:10','2026-01-31 08:42:10',1,456,'c1bc6e5a-8891-4026-b08f-61cb0ff90b50',118,'4b38141686534a0fb9b947a7886cd4b6','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-580248439-755666519',-1,'2026-02-01 08:42:10',NULL),('2026-01-31 08:42:18','2026-01-31 08:42:18','2026-01-31 08:42:18',1,457,'872a301f-6d9b-43eb-8b0c-0683c3b44508',115,'4b38141686534a0fb9b947a7886cd4b6','volumes',-1,'2026-02-01 08:42:18',NULL),('2026-01-31 08:42:18','2026-01-31 08:42:18','2026-01-31 08:42:18',1,458,'1fc18664-f83b-44c2-b79f-6d2860fa825f',116,'4b38141686534a0fb9b947a7886cd4b6','gigabytes',-1,'2026-02-01 08:42:18',NULL),('2026-01-31 08:42:18','2026-01-31 08:42:18','2026-01-31 08:42:18',1,459,'38ba878d-3190-4764-beb3-91baab4ff739',119,'4b38141686534a0fb9b947a7886cd4b6','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-350934863-1039133705',-1,'2026-02-01 08:42:18',NULL),('2026-01-31 08:42:18','2026-01-31 08:42:18','2026-01-31 08:42:18',1,460,'2a689d90-1bbb-4491-9a44-5ab048899455',120,'4b38141686534a0fb9b947a7886cd4b6','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-350934863-1039133705',-1,'2026-02-01 08:42:18',NULL),('2026-01-31 08:43:46','2026-01-31 08:43:46','2026-01-31 08:43:46',1,461,'2bf5b170-8f4c-41e6-b048-1f80a8cbfb91',115,'4b38141686534a0fb9b947a7886cd4b6','volumes',-1,'2026-02-01 08:43:46',NULL),('2026-01-31 08:43:46','2026-01-31 08:43:46','2026-01-31 08:43:46',1,462,'6da1e0dd-2192-4fc3-8046-47c1fc6ffb9f',116,'4b38141686534a0fb9b947a7886cd4b6','gigabytes',-1,'2026-02-01 08:43:46',NULL),('2026-01-31 08:43:46','2026-01-31 08:43:46','2026-01-31 08:43:46',1,463,'1b1bf670-7d2f-4a4f-995d-21fb53d77b84',121,'4b38141686534a0fb9b947a7886cd4b6','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-519012021-1114870271',-1,'2026-02-01 08:43:46',NULL),('2026-01-31 08:43:46','2026-01-31 08:43:46','2026-01-31 08:43:46',1,464,'69489aee-646b-4de0-9e1c-e77430852618',122,'4b38141686534a0fb9b947a7886cd4b6','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-519012021-1114870271',-1,'2026-02-01 08:43:46',NULL),('2026-01-31 08:43:48','2026-01-31 08:43:48','2026-01-31 08:43:48',1,465,'27563b6b-3e57-48ef-afa9-2a3294fefb74',115,'4b38141686534a0fb9b947a7886cd4b6','volumes',-1,'2026-02-01 08:43:48',NULL),('2026-01-31 08:43:48','2026-01-31 08:43:48','2026-01-31 08:43:48',1,466,'fb1472f0-9f1a-4512-9e01-3ad6c5ce01ea',116,'4b38141686534a0fb9b947a7886cd4b6','gigabytes',-1,'2026-02-01 08:43:48',NULL),('2026-01-31 08:43:48','2026-01-31 08:43:48','2026-01-31 08:43:48',1,467,'6082c361-a399-43c1-ac9d-98dcc60dc4da',121,'4b38141686534a0fb9b947a7886cd4b6','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-519012021-1114870271',-1,'2026-02-01 08:43:48',NULL),('2026-01-31 08:43:48','2026-01-31 08:43:48','2026-01-31 08:43:48',1,468,'32b1af75-d9ef-4891-a859-6fc38149e080',122,'4b38141686534a0fb9b947a7886cd4b6','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-519012021-1114870271',-1,'2026-02-01 08:43:48',NULL),('2026-01-31 08:43:49','2026-01-31 08:43:49','2026-01-31 08:43:49',1,469,'dbca676a-9724-4cff-9839-af2422d86181',115,'4b38141686534a0fb9b947a7886cd4b6','volumes',-1,'2026-02-01 08:43:49',NULL),('2026-01-31 08:43:49','2026-01-31 08:43:49','2026-01-31 08:43:49',1,470,'b8cc6367-98d6-41a0-9d2b-f994368576e2',116,'4b38141686534a0fb9b947a7886cd4b6','gigabytes',-1,'2026-02-01 08:43:49',NULL),('2026-01-31 08:43:49','2026-01-31 08:43:49','2026-01-31 08:43:49',1,471,'ad929409-3b64-49d2-8fe9-25e0f6232ca7',121,'4b38141686534a0fb9b947a7886cd4b6','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-519012021-1114870271',-1,'2026-02-01 08:43:49',NULL),('2026-01-31 08:43:49','2026-01-31 08:43:49','2026-01-31 08:43:49',1,472,'a00a7099-fe70-4337-905f-a1ae9f9a6e72',122,'4b38141686534a0fb9b947a7886cd4b6','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-519012021-1114870271',-1,'2026-02-01 08:43:49',NULL),('2026-01-31 08:53:57','2026-01-31 08:53:57','2026-01-31 08:53:57',1,473,'b19b41d6-f30a-45e5-badf-ca70db2c217f',123,'e6e96de7b2784be1adce763bc9c9adc5','volumes',1,'2026-02-01 08:53:57',NULL),('2026-01-31 08:53:57','2026-01-31 08:53:57','2026-01-31 08:53:57',1,474,'0822a23d-4d09-4326-8d1a-00659ca9ea63',124,'e6e96de7b2784be1adce763bc9c9adc5','gigabytes',1,'2026-02-01 08:53:57',NULL),('2026-01-31 08:53:57','2026-01-31 08:53:57','2026-01-31 08:53:57',1,475,'03a96526-7309-40f0-8f19-16187ab56de8',125,'e6e96de7b2784be1adce763bc9c9adc5','volumes___DEFAULT__',1,'2026-02-01 08:53:57',NULL),('2026-01-31 08:53:57','2026-01-31 08:53:57','2026-01-31 08:53:57',1,476,'d2b73d60-dff2-45fb-bcc0-678584910215',126,'e6e96de7b2784be1adce763bc9c9adc5','gigabytes___DEFAULT__',1,'2026-02-01 08:53:57',NULL),('2026-01-31 08:54:50','2026-01-31 08:54:50','2026-01-31 08:54:50',1,477,'a592a901-e503-46a8-8e22-0188d9082de1',127,'e6e96de7b2784be1adce763bc9c9adc5','snapshots',1,'2026-02-01 08:54:49',NULL),('2026-01-31 08:54:50','2026-01-31 08:54:50','2026-01-31 08:54:50',1,478,'84e72fd7-a95b-4509-be7f-eafaaedcc999',124,'e6e96de7b2784be1adce763bc9c9adc5','gigabytes',1,'2026-02-01 08:54:49',NULL),('2026-01-31 08:54:50','2026-01-31 08:54:50','2026-01-31 08:54:50',1,479,'bbeec2cf-7a12-4cc7-86f2-fa1c310f1567',126,'e6e96de7b2784be1adce763bc9c9adc5','gigabytes___DEFAULT__',1,'2026-02-01 08:54:49',NULL),('2026-01-31 08:54:50','2026-01-31 08:54:50','2026-01-31 08:54:50',1,480,'4c735cfb-c1c7-4b55-89dc-262e14685b14',128,'e6e96de7b2784be1adce763bc9c9adc5','snapshots___DEFAULT__',1,'2026-02-01 08:54:49',NULL),('2026-01-31 08:54:59','2026-01-31 08:54:59','2026-01-31 08:54:59',1,481,'2500a992-841b-42e2-8825-e454fcaf5acf',123,'e6e96de7b2784be1adce763bc9c9adc5','volumes',1,'2026-02-01 08:54:59',NULL),('2026-01-31 08:54:59','2026-01-31 08:54:59','2026-01-31 08:54:59',1,482,'ddebf64a-cd2c-4a7d-a1d1-5778729dee6a',124,'e6e96de7b2784be1adce763bc9c9adc5','gigabytes',1,'2026-02-01 08:54:59',NULL),('2026-01-31 08:54:59','2026-01-31 08:54:59','2026-01-31 08:54:59',1,483,'92fa0678-d12c-46a8-9b53-a656617b4794',125,'e6e96de7b2784be1adce763bc9c9adc5','volumes___DEFAULT__',1,'2026-02-01 08:54:59',NULL),('2026-01-31 08:54:59','2026-01-31 08:54:59','2026-01-31 08:54:59',1,484,'e5a85e53-0a72-49b4-8467-079a68c998af',126,'e6e96de7b2784be1adce763bc9c9adc5','gigabytes___DEFAULT__',1,'2026-02-01 08:54:59',NULL),('2026-01-31 08:56:22','2026-01-31 08:56:23','2026-01-31 08:56:23',1,485,'1a791536-b753-40fc-963f-9093b593e26c',123,'e6e96de7b2784be1adce763bc9c9adc5','volumes',-1,'2026-02-01 08:56:22',NULL),('2026-01-31 08:56:22','2026-01-31 08:56:23','2026-01-31 08:56:23',1,486,'11700461-5abb-44fa-bb31-c5660c2bf126',124,'e6e96de7b2784be1adce763bc9c9adc5','gigabytes',-1,'2026-02-01 08:56:22',NULL),('2026-01-31 08:56:22','2026-01-31 08:56:23','2026-01-31 08:56:23',1,487,'7743a0bd-8c69-4752-a77f-bf8e0f07f4d2',125,'e6e96de7b2784be1adce763bc9c9adc5','volumes___DEFAULT__',-1,'2026-02-01 08:56:22',NULL),('2026-01-31 08:56:22','2026-01-31 08:56:23','2026-01-31 08:56:23',1,488,'d597708c-1929-496b-bd72-f523f4c5b736',126,'e6e96de7b2784be1adce763bc9c9adc5','gigabytes___DEFAULT__',-1,'2026-02-01 08:56:22',NULL),('2026-01-31 08:56:26','2026-01-31 08:56:26','2026-01-31 08:56:26',1,489,'be7e78d5-ca0b-4e50-bfd3-6474e45396d8',127,'e6e96de7b2784be1adce763bc9c9adc5','snapshots',-1,'2026-02-01 08:56:26',NULL),('2026-01-31 08:56:26','2026-01-31 08:56:26','2026-01-31 08:56:26',1,490,'a23a6856-8976-426f-ae8f-195d934c0369',124,'e6e96de7b2784be1adce763bc9c9adc5','gigabytes',-1,'2026-02-01 08:56:26',NULL),('2026-01-31 08:56:26','2026-01-31 08:56:26','2026-01-31 08:56:26',1,491,'628c13e7-e6b7-4beb-a2ac-a62bc4e1444d',126,'e6e96de7b2784be1adce763bc9c9adc5','gigabytes___DEFAULT__',-1,'2026-02-01 08:56:26',NULL),('2026-01-31 08:56:26','2026-01-31 08:56:26','2026-01-31 08:56:26',1,492,'7be389d5-fdd5-46dc-afcf-8c924d73fc05',128,'e6e96de7b2784be1adce763bc9c9adc5','snapshots___DEFAULT__',-1,'2026-02-01 08:56:26',NULL),('2026-01-31 08:56:42','2026-01-31 08:56:43','2026-01-31 08:56:43',1,493,'5a960d7b-2ebc-477c-85d7-1d7fedb7010b',123,'e6e96de7b2784be1adce763bc9c9adc5','volumes',-1,'2026-02-01 08:56:42',NULL),('2026-01-31 08:56:42','2026-01-31 08:56:43','2026-01-31 08:56:43',1,494,'76627ef2-82b4-4400-bae9-dfb8a8ee9fff',124,'e6e96de7b2784be1adce763bc9c9adc5','gigabytes',-1,'2026-02-01 08:56:42',NULL),('2026-01-31 08:56:42','2026-01-31 08:56:43','2026-01-31 08:56:43',1,495,'a0e6b4b6-e9b7-409d-906f-43e38ad4e4d2',125,'e6e96de7b2784be1adce763bc9c9adc5','volumes___DEFAULT__',-1,'2026-02-01 08:56:42',NULL),('2026-01-31 08:56:42','2026-01-31 08:56:43','2026-01-31 08:56:43',1,496,'4ae42122-2ac3-4d99-a02f-ad6bcb35910d',126,'e6e96de7b2784be1adce763bc9c9adc5','gigabytes___DEFAULT__',-1,'2026-02-01 08:56:42',NULL),('2026-01-31 08:58:04','2026-01-31 08:58:04','2026-01-31 08:58:04',1,497,'7a675224-b06d-45ad-afb5-23393ea254ae',129,'e458566e0de24b2fb797037d94d9014c','volumes',1,'2026-02-01 08:58:04',NULL),('2026-01-31 08:58:04','2026-01-31 08:58:04','2026-01-31 08:58:04',1,498,'a9816c99-d886-4866-a995-fb53da1d4279',130,'e458566e0de24b2fb797037d94d9014c','gigabytes',1,'2026-02-01 08:58:04',NULL),('2026-01-31 08:58:04','2026-01-31 08:58:04','2026-01-31 08:58:04',1,499,'8762bd11-9f5f-4f9a-9230-11de986375aa',131,'e458566e0de24b2fb797037d94d9014c','volumes___DEFAULT__',1,'2026-02-01 08:58:04',NULL),('2026-01-31 08:58:04','2026-01-31 08:58:04','2026-01-31 08:58:04',1,500,'d3153b76-7f4f-408b-bc1c-eafd5d7ff9f7',132,'e458566e0de24b2fb797037d94d9014c','gigabytes___DEFAULT__',1,'2026-02-01 08:58:04',NULL),('2026-01-31 08:58:15','2026-01-31 08:58:16','2026-01-31 08:58:16',1,501,'5aad376a-72d7-4af1-bd59-700053047dba',133,'e458566e0de24b2fb797037d94d9014c','backups',1,'2026-02-01 08:58:15',NULL),('2026-01-31 08:58:15','2026-01-31 08:58:16','2026-01-31 08:58:16',1,502,'ad9aed3d-4ce9-4a17-ba3e-494807406ee3',134,'e458566e0de24b2fb797037d94d9014c','backup_gigabytes',1,'2026-02-01 08:58:15',NULL),('2026-01-31 08:58:25','2026-01-31 08:58:25','2026-01-31 08:58:25',1,503,'8485d7ad-bc01-4478-aa28-3b828880bb51',129,'e458566e0de24b2fb797037d94d9014c','volumes',1,'2026-02-01 08:58:25',NULL),('2026-01-31 08:58:25','2026-01-31 08:58:25','2026-01-31 08:58:25',1,504,'856321df-1754-4c48-a806-71d72e6cffdc',130,'e458566e0de24b2fb797037d94d9014c','gigabytes',1,'2026-02-01 08:58:25',NULL),('2026-01-31 08:58:25','2026-01-31 08:58:25','2026-01-31 08:58:25',1,505,'b917c44e-ba64-4755-aa48-9f53f857bfd7',131,'e458566e0de24b2fb797037d94d9014c','volumes___DEFAULT__',1,'2026-02-01 08:58:25',NULL),('2026-01-31 08:58:25','2026-01-31 08:58:25','2026-01-31 08:58:25',1,506,'c22ee16e-c4de-45ac-a9a5-acc6a6bf34d7',132,'e458566e0de24b2fb797037d94d9014c','gigabytes___DEFAULT__',1,'2026-02-01 08:58:25',NULL),('2026-01-31 08:59:26','2026-01-31 08:59:26','2026-01-31 08:59:26',1,507,'a0806f9b-ce72-430f-a90c-dfc3311b8652',129,'e458566e0de24b2fb797037d94d9014c','volumes',-1,'2026-02-01 08:59:25',NULL),('2026-01-31 08:59:26','2026-01-31 08:59:26','2026-01-31 08:59:26',1,508,'a84b8a35-fdae-4462-852c-6a814d062bca',130,'e458566e0de24b2fb797037d94d9014c','gigabytes',-1,'2026-02-01 08:59:25',NULL),('2026-01-31 08:59:26','2026-01-31 08:59:26','2026-01-31 08:59:26',1,509,'1f3fbf01-156c-4737-a1fd-1b33746f7f2a',131,'e458566e0de24b2fb797037d94d9014c','volumes___DEFAULT__',-1,'2026-02-01 08:59:25',NULL),('2026-01-31 08:59:26','2026-01-31 08:59:26','2026-01-31 08:59:26',1,510,'3ccfb540-bc10-40b5-95bb-9c30da25dbe7',132,'e458566e0de24b2fb797037d94d9014c','gigabytes___DEFAULT__',-1,'2026-02-01 08:59:25',NULL),('2026-01-31 08:59:27','2026-01-31 08:59:28','2026-01-31 08:59:28',1,511,'0ddcbf37-2e3b-48dd-913e-230de89b3e5e',133,'e458566e0de24b2fb797037d94d9014c','backups',-1,'2026-02-01 08:59:27',NULL),('2026-01-31 08:59:27','2026-01-31 08:59:28','2026-01-31 08:59:28',1,512,'0b9eb842-4b47-4da0-92af-09a8a212480b',134,'e458566e0de24b2fb797037d94d9014c','backup_gigabytes',-1,'2026-02-01 08:59:27',NULL),('2026-01-31 08:59:28','2026-01-31 08:59:28','2026-01-31 08:59:28',1,513,'c6497076-3f4c-4db6-ab7f-448526c4c883',129,'e458566e0de24b2fb797037d94d9014c','volumes',-1,'2026-02-01 08:59:28',NULL),('2026-01-31 08:59:28','2026-01-31 08:59:28','2026-01-31 08:59:28',1,514,'1f41b143-df53-45a6-bdac-610641b1b41b',130,'e458566e0de24b2fb797037d94d9014c','gigabytes',-1,'2026-02-01 08:59:28',NULL),('2026-01-31 08:59:28','2026-01-31 08:59:28','2026-01-31 08:59:28',1,515,'400358fa-f1ec-42d7-a239-e9761e037c56',131,'e458566e0de24b2fb797037d94d9014c','volumes___DEFAULT__',-1,'2026-02-01 08:59:28',NULL),('2026-01-31 08:59:28','2026-01-31 08:59:28','2026-01-31 08:59:28',1,516,'6557dea3-4cad-411a-a850-cdc320dcb458',132,'e458566e0de24b2fb797037d94d9014c','gigabytes___DEFAULT__',-1,'2026-02-01 08:59:28',NULL),('2026-01-31 09:08:09','2026-01-31 09:08:09','2026-01-31 09:08:09',1,517,'d553a537-737d-4558-a01a-71060ea3f4d9',135,'496e06c7521f45c994e6426c4313acea','volumes',1,'2026-02-01 09:08:09',NULL),('2026-01-31 09:08:09','2026-01-31 09:08:09','2026-01-31 09:08:09',1,518,'21cdd9e9-17a3-4d01-ac43-778475c99884',136,'496e06c7521f45c994e6426c4313acea','gigabytes',1,'2026-02-01 09:08:09',NULL),('2026-01-31 09:08:09','2026-01-31 09:08:09','2026-01-31 09:08:09',1,519,'06015165-f778-4d7b-915d-9dcb0087b149',137,'496e06c7521f45c994e6426c4313acea','volumes___DEFAULT__',1,'2026-02-01 09:08:09',NULL),('2026-01-31 09:08:09','2026-01-31 09:08:09','2026-01-31 09:08:09',1,520,'bbc61fad-0d24-4976-bf3f-bb9710a6d1d3',138,'496e06c7521f45c994e6426c4313acea','gigabytes___DEFAULT__',1,'2026-02-01 09:08:09',NULL),('2026-01-31 09:09:54','2026-01-31 09:09:54','2026-01-31 09:09:54',1,521,'622c2a3c-332c-4e45-b4cf-3dfb3778c036',135,'496e06c7521f45c994e6426c4313acea','volumes',-1,'2026-02-01 09:09:54',NULL),('2026-01-31 09:09:54','2026-01-31 09:09:54','2026-01-31 09:09:54',1,522,'be68ef55-5b2a-4100-a78d-04e34a244446',136,'496e06c7521f45c994e6426c4313acea','gigabytes',-1,'2026-02-01 09:09:54',NULL),('2026-01-31 09:09:54','2026-01-31 09:09:54','2026-01-31 09:09:54',1,523,'626cafef-357a-4a69-a4a2-b61bcb4fa075',137,'496e06c7521f45c994e6426c4313acea','volumes___DEFAULT__',-1,'2026-02-01 09:09:54',NULL),('2026-01-31 09:09:54','2026-01-31 09:09:54','2026-01-31 09:09:54',1,524,'38de46e9-d98b-4b21-9c2a-d0f0ec304a44',138,'496e06c7521f45c994e6426c4313acea','gigabytes___DEFAULT__',-1,'2026-02-01 09:09:54',NULL),('2026-01-31 09:11:11','2026-01-31 09:11:11','2026-01-31 09:11:11',1,525,'b474eb44-5ef1-4e46-ae12-0585d70203e2',139,'98d10c0290e340a08e9d1726bf0066bf','volumes',1,'2026-02-01 09:11:11',NULL),('2026-01-31 09:11:11','2026-01-31 09:11:11','2026-01-31 09:11:11',1,526,'4bf3f577-92bc-4f40-b8e8-ab956690ccbf',140,'98d10c0290e340a08e9d1726bf0066bf','gigabytes',1,'2026-02-01 09:11:11',NULL),('2026-01-31 09:11:11','2026-01-31 09:11:11','2026-01-31 09:11:11',1,527,'5f1cd369-e091-48a6-98e1-b7fc55371f0b',141,'98d10c0290e340a08e9d1726bf0066bf','volumes_tempest-scenario-type-luks-1946719417',1,'2026-02-01 09:11:11',NULL),('2026-01-31 09:11:11','2026-01-31 09:11:11','2026-01-31 09:11:11',1,528,'5a077404-b40c-4fe2-ab82-13b6c02bda61',142,'98d10c0290e340a08e9d1726bf0066bf','gigabytes_tempest-scenario-type-luks-1946719417',1,'2026-02-01 09:11:11',NULL),('2026-01-31 09:12:09','2026-01-31 09:12:09','2026-01-31 09:12:09',1,529,'addd7866-d3ac-47af-af91-dc9738e2b9f9',139,'98d10c0290e340a08e9d1726bf0066bf','volumes',-1,'2026-02-01 09:12:09',NULL),('2026-01-31 09:12:09','2026-01-31 09:12:09','2026-01-31 09:12:09',1,530,'695bc436-1609-4a58-bf77-a152293742bb',140,'98d10c0290e340a08e9d1726bf0066bf','gigabytes',-1,'2026-02-01 09:12:09',NULL),('2026-01-31 09:12:09','2026-01-31 09:12:09','2026-01-31 09:12:09',1,531,'5edb1863-0cb6-4097-b7bf-c23c939259a3',141,'98d10c0290e340a08e9d1726bf0066bf','volumes_tempest-scenario-type-luks-1946719417',-1,'2026-02-01 09:12:09',NULL),('2026-01-31 09:12:09','2026-01-31 09:12:09','2026-01-31 09:12:09',1,532,'f5a4a628-e223-4566-b23d-73383bd9fa6f',142,'98d10c0290e340a08e9d1726bf0066bf','gigabytes_tempest-scenario-type-luks-1946719417',-1,'2026-02-01 09:12:09',NULL),('2026-01-31 09:12:12','2026-01-31 09:12:12','2026-01-31 09:12:12',1,533,'6f72c066-390c-415d-824f-d9de90679a51',139,'98d10c0290e340a08e9d1726bf0066bf','volumes',1,'2026-02-01 09:12:12',NULL),('2026-01-31 09:12:12','2026-01-31 09:12:12','2026-01-31 09:12:12',1,534,'bf798efe-306d-4ed4-8425-2bb99076c42b',140,'98d10c0290e340a08e9d1726bf0066bf','gigabytes',1,'2026-02-01 09:12:12',NULL),('2026-01-31 09:12:12','2026-01-31 09:12:12','2026-01-31 09:12:12',1,535,'eb749674-91c1-45be-9550-1b1dc8bdb78b',143,'98d10c0290e340a08e9d1726bf0066bf','volumes___DEFAULT__',1,'2026-02-01 09:12:12',NULL),('2026-01-31 09:12:12','2026-01-31 09:12:12','2026-01-31 09:12:12',1,536,'a29d4768-d401-4ed8-84f3-78c6f6c3c050',144,'98d10c0290e340a08e9d1726bf0066bf','gigabytes___DEFAULT__',1,'2026-02-01 09:12:12',NULL),('2026-01-31 09:12:28','2026-01-31 09:12:28','2026-01-31 09:12:28',1,537,'810289d5-b285-4cc0-bf33-3ce3acf8e01a',145,'98d10c0290e340a08e9d1726bf0066bf','snapshots',1,'2026-02-01 09:12:28',NULL),('2026-01-31 09:12:28','2026-01-31 09:12:28','2026-01-31 09:12:28',1,538,'0a5f47ff-1b4b-4bef-8db1-bfbffd84b382',140,'98d10c0290e340a08e9d1726bf0066bf','gigabytes',1,'2026-02-01 09:12:28',NULL),('2026-01-31 09:12:28','2026-01-31 09:12:28','2026-01-31 09:12:28',1,539,'547a4a44-531a-4cac-9e43-3dfacfb5e33d',144,'98d10c0290e340a08e9d1726bf0066bf','gigabytes___DEFAULT__',1,'2026-02-01 09:12:28',NULL),('2026-01-31 09:12:28','2026-01-31 09:12:28','2026-01-31 09:12:28',1,540,'350d78cf-51e2-412c-9747-6d72d7885445',146,'98d10c0290e340a08e9d1726bf0066bf','snapshots___DEFAULT__',1,'2026-02-01 09:12:28',NULL),('2026-01-31 09:12:40','2026-01-31 09:12:40','2026-01-31 09:12:40',1,541,'f945ff18-087f-47a3-ac0e-03b8e267f9d6',139,'98d10c0290e340a08e9d1726bf0066bf','volumes',1,'2026-02-01 09:12:40',NULL),('2026-01-31 09:12:40','2026-01-31 09:12:40','2026-01-31 09:12:40',1,542,'c80e2e4c-d982-498a-a7b1-ae80f82f7818',140,'98d10c0290e340a08e9d1726bf0066bf','gigabytes',1,'2026-02-01 09:12:40',NULL),('2026-01-31 09:12:40','2026-01-31 09:12:40','2026-01-31 09:12:40',1,543,'03e96ce0-b255-4694-af66-6c753824bb92',143,'98d10c0290e340a08e9d1726bf0066bf','volumes___DEFAULT__',1,'2026-02-01 09:12:40',NULL),('2026-01-31 09:12:40','2026-01-31 09:12:40','2026-01-31 09:12:40',1,544,'c4310c32-41db-4055-a887-f9c3d103711b',144,'98d10c0290e340a08e9d1726bf0066bf','gigabytes___DEFAULT__',1,'2026-02-01 09:12:40',NULL),('2026-01-31 09:13:04','2026-01-31 09:13:04','2026-01-31 09:13:04',1,545,'3969c7e1-4df6-4707-bf54-d6901d414d36',139,'98d10c0290e340a08e9d1726bf0066bf','volumes',-1,'2026-02-01 09:13:04',NULL),('2026-01-31 09:13:04','2026-01-31 09:13:04','2026-01-31 09:13:04',1,546,'bd7aaf8c-4f8e-47d2-bfa3-57d683e932ae',140,'98d10c0290e340a08e9d1726bf0066bf','gigabytes',-1,'2026-02-01 09:13:04',NULL),('2026-01-31 09:13:04','2026-01-31 09:13:04','2026-01-31 09:13:04',1,547,'99187b15-664c-4761-ab5c-0d05c9943e24',143,'98d10c0290e340a08e9d1726bf0066bf','volumes___DEFAULT__',-1,'2026-02-01 09:13:04',NULL),('2026-01-31 09:13:04','2026-01-31 09:13:04','2026-01-31 09:13:04',1,548,'fc0294c0-da1a-4293-8867-41884e1c3728',144,'98d10c0290e340a08e9d1726bf0066bf','gigabytes___DEFAULT__',-1,'2026-02-01 09:13:04',NULL),('2026-01-31 09:13:07','2026-01-31 09:13:07','2026-01-31 09:13:07',1,549,'84ebc16f-acaf-4584-a50d-0ad0190700d7',145,'98d10c0290e340a08e9d1726bf0066bf','snapshots',-1,'2026-02-01 09:13:07',NULL),('2026-01-31 09:13:07','2026-01-31 09:13:07','2026-01-31 09:13:07',1,550,'1f082857-d6c2-4dd5-b413-dd1cff708a10',140,'98d10c0290e340a08e9d1726bf0066bf','gigabytes',-1,'2026-02-01 09:13:07',NULL),('2026-01-31 09:13:07','2026-01-31 09:13:07','2026-01-31 09:13:07',1,551,'efc2d52e-05fd-4ef2-b339-cdd2bca78862',144,'98d10c0290e340a08e9d1726bf0066bf','gigabytes___DEFAULT__',-1,'2026-02-01 09:13:07',NULL),('2026-01-31 09:13:07','2026-01-31 09:13:07','2026-01-31 09:13:07',1,552,'48f97017-e83d-4ace-b39f-bc016c49101f',146,'98d10c0290e340a08e9d1726bf0066bf','snapshots___DEFAULT__',-1,'2026-02-01 09:13:07',NULL),('2026-01-31 09:13:11','2026-01-31 09:13:11','2026-01-31 09:13:11',1,553,'dbdf36b7-16cf-4591-899d-859b266a917f',139,'98d10c0290e340a08e9d1726bf0066bf','volumes',-1,'2026-02-01 09:13:11',NULL),('2026-01-31 09:13:11','2026-01-31 09:13:11','2026-01-31 09:13:11',1,554,'bac28b33-692a-4aa1-a973-5868bdefb33e',140,'98d10c0290e340a08e9d1726bf0066bf','gigabytes',-1,'2026-02-01 09:13:11',NULL),('2026-01-31 09:13:11','2026-01-31 09:13:11','2026-01-31 09:13:11',1,555,'7322fac2-40f7-45e7-9292-4c9d463ebb97',143,'98d10c0290e340a08e9d1726bf0066bf','volumes___DEFAULT__',-1,'2026-02-01 09:13:11',NULL),('2026-01-31 09:13:11','2026-01-31 09:13:11','2026-01-31 09:13:11',1,556,'c36fd006-3db1-4b85-9660-38f6aca214e5',144,'98d10c0290e340a08e9d1726bf0066bf','gigabytes___DEFAULT__',-1,'2026-02-01 09:13:11',NULL),('2026-01-31 09:13:14','2026-01-31 09:13:14','2026-01-31 09:13:14',1,557,'fb9e7409-9907-4623-ba99-8abbce6378aa',139,'98d10c0290e340a08e9d1726bf0066bf','volumes',1,'2026-02-01 09:13:14',NULL),('2026-01-31 09:13:14','2026-01-31 09:13:14','2026-01-31 09:13:14',1,558,'c46c12bd-b8eb-4a70-9d5e-14ff32ed458f',140,'98d10c0290e340a08e9d1726bf0066bf','gigabytes',1,'2026-02-01 09:13:14',NULL),('2026-01-31 09:13:14','2026-01-31 09:13:14','2026-01-31 09:13:14',1,559,'f83e9979-8cca-4e35-9506-73ccd500060d',143,'98d10c0290e340a08e9d1726bf0066bf','volumes___DEFAULT__',1,'2026-02-01 09:13:14',NULL),('2026-01-31 09:13:14','2026-01-31 09:13:14','2026-01-31 09:13:14',1,560,'79bc2c31-cdbf-4046-a96f-af40d4f4738d',144,'98d10c0290e340a08e9d1726bf0066bf','gigabytes___DEFAULT__',1,'2026-02-01 09:13:14',NULL),('2026-01-31 09:14:24','2026-01-31 09:14:24','2026-01-31 09:14:24',1,561,'79469d81-4afc-4e87-a514-d0fc07e2572d',145,'98d10c0290e340a08e9d1726bf0066bf','snapshots',1,'2026-02-01 09:14:24',NULL),('2026-01-31 09:14:24','2026-01-31 09:14:24','2026-01-31 09:14:24',1,562,'857c2fe1-0655-4de7-b7c5-90f685b0a921',140,'98d10c0290e340a08e9d1726bf0066bf','gigabytes',1,'2026-02-01 09:14:24',NULL),('2026-01-31 09:14:24','2026-01-31 09:14:24','2026-01-31 09:14:24',1,563,'ab817943-4f71-460d-b633-863541ae97e5',144,'98d10c0290e340a08e9d1726bf0066bf','gigabytes___DEFAULT__',1,'2026-02-01 09:14:24',NULL),('2026-01-31 09:14:24','2026-01-31 09:14:24','2026-01-31 09:14:24',1,564,'09899759-ff4b-4424-b785-6dd9fe420b53',146,'98d10c0290e340a08e9d1726bf0066bf','snapshots___DEFAULT__',1,'2026-02-01 09:14:24',NULL),('2026-01-31 09:14:37','2026-01-31 09:14:37','2026-01-31 09:14:37',1,565,'0b9b6521-1436-41dc-9c23-0473d670915d',139,'98d10c0290e340a08e9d1726bf0066bf','volumes',1,'2026-02-01 09:14:37',NULL),('2026-01-31 09:14:37','2026-01-31 09:14:37','2026-01-31 09:14:37',1,566,'04bda34e-c501-4bd4-88f7-45a99f4a217a',140,'98d10c0290e340a08e9d1726bf0066bf','gigabytes',1,'2026-02-01 09:14:37',NULL),('2026-01-31 09:14:37','2026-01-31 09:14:37','2026-01-31 09:14:37',1,567,'2645b744-33e5-456a-8215-0e61b79d75a1',143,'98d10c0290e340a08e9d1726bf0066bf','volumes___DEFAULT__',1,'2026-02-01 09:14:37',NULL),('2026-01-31 09:14:37','2026-01-31 09:14:37','2026-01-31 09:14:37',1,568,'473d9c24-27ea-4a11-8358-71bd68ed1931',144,'98d10c0290e340a08e9d1726bf0066bf','gigabytes___DEFAULT__',1,'2026-02-01 09:14:37',NULL),('2026-01-31 09:15:39','2026-01-31 09:15:39','2026-01-31 09:15:39',1,569,'94c3fa47-ff71-43b6-860c-33dc48aa4405',139,'98d10c0290e340a08e9d1726bf0066bf','volumes',-1,'2026-02-01 09:15:39',NULL),('2026-01-31 09:15:39','2026-01-31 09:15:39','2026-01-31 09:15:39',1,570,'b12b7754-8089-444a-a1e1-e245fe086cae',140,'98d10c0290e340a08e9d1726bf0066bf','gigabytes',-1,'2026-02-01 09:15:39',NULL),('2026-01-31 09:15:39','2026-01-31 09:15:39','2026-01-31 09:15:39',1,571,'c00ecf5c-516a-4887-9d33-5302770e82c0',143,'98d10c0290e340a08e9d1726bf0066bf','volumes___DEFAULT__',-1,'2026-02-01 09:15:39',NULL),('2026-01-31 09:15:39','2026-01-31 09:15:39','2026-01-31 09:15:39',1,572,'b09ebf98-ad34-4eb1-96a2-d689096f9894',144,'98d10c0290e340a08e9d1726bf0066bf','gigabytes___DEFAULT__',-1,'2026-02-01 09:15:39',NULL),('2026-01-31 09:15:41','2026-01-31 09:15:41','2026-01-31 09:15:41',1,573,'1a0a92a5-58a0-48b8-92e9-5644be353526',145,'98d10c0290e340a08e9d1726bf0066bf','snapshots',-1,'2026-02-01 09:15:41',NULL),('2026-01-31 09:15:41','2026-01-31 09:15:41','2026-01-31 09:15:41',1,574,'c8f48537-22e7-4c31-a013-8314d296ca94',140,'98d10c0290e340a08e9d1726bf0066bf','gigabytes',-1,'2026-02-01 09:15:41',NULL),('2026-01-31 09:15:41','2026-01-31 09:15:41','2026-01-31 09:15:41',1,575,'230cb425-92d4-49a5-9929-2d3a901cf206',144,'98d10c0290e340a08e9d1726bf0066bf','gigabytes___DEFAULT__',-1,'2026-02-01 09:15:41',NULL),('2026-01-31 09:15:41','2026-01-31 09:15:41','2026-01-31 09:15:41',1,576,'41f4399e-baba-40eb-9f8a-2ed620e623e4',146,'98d10c0290e340a08e9d1726bf0066bf','snapshots___DEFAULT__',-1,'2026-02-01 09:15:41',NULL),('2026-01-31 09:15:47','2026-01-31 09:15:47','2026-01-31 09:15:47',1,577,'59b6d63f-208b-4f48-9296-62cc9e09e34e',139,'98d10c0290e340a08e9d1726bf0066bf','volumes',-1,'2026-02-01 09:15:47',NULL),('2026-01-31 09:15:47','2026-01-31 09:15:47','2026-01-31 09:15:47',1,578,'714cdff2-8803-4750-a1d4-05c291cd5c1e',140,'98d10c0290e340a08e9d1726bf0066bf','gigabytes',-1,'2026-02-01 09:15:47',NULL),('2026-01-31 09:15:47','2026-01-31 09:15:47','2026-01-31 09:15:47',1,579,'d19a9b00-6d1e-457f-8306-519e6a8edc96',143,'98d10c0290e340a08e9d1726bf0066bf','volumes___DEFAULT__',-1,'2026-02-01 09:15:47',NULL),('2026-01-31 09:15:47','2026-01-31 09:15:47','2026-01-31 09:15:47',1,580,'364d3d6e-5063-4ee0-a9af-873fe6157fed',144,'98d10c0290e340a08e9d1726bf0066bf','gigabytes___DEFAULT__',-1,'2026-02-01 09:15:47',NULL),('2026-01-31 09:16:03','2026-01-31 09:16:04','2026-01-31 09:16:04',1,581,'153d0ae7-21c6-4aeb-9e90-1756d133c8a0',139,'98d10c0290e340a08e9d1726bf0066bf','volumes',1,'2026-02-01 09:16:03',NULL),('2026-01-31 09:16:03','2026-01-31 09:16:04','2026-01-31 09:16:04',1,582,'e880b493-483f-4820-9687-ab2a2d639085',140,'98d10c0290e340a08e9d1726bf0066bf','gigabytes',1,'2026-02-01 09:16:03',NULL),('2026-01-31 09:16:03','2026-01-31 09:16:04','2026-01-31 09:16:04',1,583,'27d4127d-a2bf-4b43-9aa6-7654d444baab',143,'98d10c0290e340a08e9d1726bf0066bf','volumes___DEFAULT__',1,'2026-02-01 09:16:03',NULL),('2026-01-31 09:16:04','2026-01-31 09:16:04','2026-01-31 09:16:04',1,584,'39b9cf47-0fde-408d-a25a-d3b0174241f3',144,'98d10c0290e340a08e9d1726bf0066bf','gigabytes___DEFAULT__',1,'2026-02-01 09:16:03',NULL),('2026-01-31 09:18:10','2026-01-31 09:18:10','2026-01-31 09:18:10',1,585,'29a5b035-0273-4e3f-ac88-e02e003213b2',145,'98d10c0290e340a08e9d1726bf0066bf','snapshots',1,'2026-02-01 09:18:10',NULL),('2026-01-31 09:18:10','2026-01-31 09:18:10','2026-01-31 09:18:10',1,586,'f6892bbb-7249-4b65-9428-1302cf9ff475',140,'98d10c0290e340a08e9d1726bf0066bf','gigabytes',1,'2026-02-01 09:18:10',NULL),('2026-01-31 09:18:10','2026-01-31 09:18:10','2026-01-31 09:18:10',1,587,'e38c17c9-bef6-4234-8a28-3aae600ba2c4',144,'98d10c0290e340a08e9d1726bf0066bf','gigabytes___DEFAULT__',1,'2026-02-01 09:18:10',NULL),('2026-01-31 09:18:10','2026-01-31 09:18:10','2026-01-31 09:18:10',1,588,'69cd1ab5-5259-4773-8be3-705e1997e57d',146,'98d10c0290e340a08e9d1726bf0066bf','snapshots___DEFAULT__',1,'2026-02-01 09:18:10',NULL),('2026-01-31 09:18:13','2026-01-31 09:18:13','2026-01-31 09:18:13',1,589,'c2fc57d5-0b91-4b46-8179-bd1860391cbc',139,'98d10c0290e340a08e9d1726bf0066bf','volumes',1,'2026-02-01 09:18:13',NULL),('2026-01-31 09:18:13','2026-01-31 09:18:13','2026-01-31 09:18:13',1,590,'3fdd9f77-69e6-4c62-bc55-153f9f0e972c',140,'98d10c0290e340a08e9d1726bf0066bf','gigabytes',1,'2026-02-01 09:18:13',NULL),('2026-01-31 09:18:13','2026-01-31 09:18:13','2026-01-31 09:18:13',1,591,'e80f84f5-04b7-40ad-8321-9cf8a99b3664',143,'98d10c0290e340a08e9d1726bf0066bf','volumes___DEFAULT__',1,'2026-02-01 09:18:13',NULL),('2026-01-31 09:18:13','2026-01-31 09:18:13','2026-01-31 09:18:13',1,592,'f7d1d652-57f5-42a8-aca4-79860f0a0a6c',144,'98d10c0290e340a08e9d1726bf0066bf','gigabytes___DEFAULT__',1,'2026-02-01 09:18:13',NULL),('2026-01-31 09:19:00','2026-01-31 09:19:00','2026-01-31 09:19:00',1,593,'1539ccaf-b2d7-448d-a87e-36ab6b0d3340',139,'98d10c0290e340a08e9d1726bf0066bf','volumes',-1,'2026-02-01 09:19:00',NULL),('2026-01-31 09:19:00','2026-01-31 09:19:00','2026-01-31 09:19:00',1,594,'d69d2055-4068-4fdf-b7ab-f5ca42facde3',140,'98d10c0290e340a08e9d1726bf0066bf','gigabytes',-1,'2026-02-01 09:19:00',NULL),('2026-01-31 09:19:00','2026-01-31 09:19:00','2026-01-31 09:19:00',1,595,'f0aa74da-49f8-4438-ad72-d76558623e41',143,'98d10c0290e340a08e9d1726bf0066bf','volumes___DEFAULT__',-1,'2026-02-01 09:19:00',NULL),('2026-01-31 09:19:00','2026-01-31 09:19:00','2026-01-31 09:19:00',1,596,'d018f3da-709d-4f94-b458-67aee5fe5d9b',144,'98d10c0290e340a08e9d1726bf0066bf','gigabytes___DEFAULT__',-1,'2026-02-01 09:19:00',NULL),('2026-01-31 09:19:03','2026-01-31 09:19:03','2026-01-31 09:19:03',1,597,'f8eace56-d3aa-4fd8-a891-24a49e129c19',145,'98d10c0290e340a08e9d1726bf0066bf','snapshots',-1,'2026-02-01 09:19:03',NULL),('2026-01-31 09:19:03','2026-01-31 09:19:03','2026-01-31 09:19:03',1,598,'02e9f4a0-449d-48fb-a66e-900d27da1c2f',140,'98d10c0290e340a08e9d1726bf0066bf','gigabytes',-1,'2026-02-01 09:19:03',NULL),('2026-01-31 09:19:03','2026-01-31 09:19:03','2026-01-31 09:19:03',1,599,'5872b22d-5f5b-484a-b8cd-ef40c4c481ac',144,'98d10c0290e340a08e9d1726bf0066bf','gigabytes___DEFAULT__',-1,'2026-02-01 09:19:03',NULL),('2026-01-31 09:19:03','2026-01-31 09:19:03','2026-01-31 09:19:03',1,600,'3feb469b-ee23-44a8-86cd-519b98a3ca51',146,'98d10c0290e340a08e9d1726bf0066bf','snapshots___DEFAULT__',-1,'2026-02-01 09:19:03',NULL),('2026-01-31 09:19:17','2026-01-31 09:19:17','2026-01-31 09:19:17',1,601,'2aa5f41c-cdfd-43f0-a14f-44125aef8f07',139,'98d10c0290e340a08e9d1726bf0066bf','volumes',-1,'2026-02-01 09:19:17',NULL),('2026-01-31 09:19:17','2026-01-31 09:19:17','2026-01-31 09:19:17',1,602,'510f0d49-bec2-4111-a2a3-78258701cb43',140,'98d10c0290e340a08e9d1726bf0066bf','gigabytes',-1,'2026-02-01 09:19:17',NULL),('2026-01-31 09:19:17','2026-01-31 09:19:17','2026-01-31 09:19:17',1,603,'3f22acea-cafb-4fce-b2b2-4d1a157378b4',143,'98d10c0290e340a08e9d1726bf0066bf','volumes___DEFAULT__',-1,'2026-02-01 09:19:17',NULL),('2026-01-31 09:19:17','2026-01-31 09:19:17','2026-01-31 09:19:17',1,604,'424572e2-80de-4499-b3d0-3572299b5277',144,'98d10c0290e340a08e9d1726bf0066bf','gigabytes___DEFAULT__',-1,'2026-02-01 09:19:17',NULL);
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `rpc_current_version` varchar(36) DEFAULT NULL,
  `object_current_version` varchar(36) DEFAULT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `frozen` tinyint(1) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `services_uuid_idx` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone`, `disabled_reason`, `modified_at`, `rpc_current_version`, `object_current_version`, `replication_status`, `frozen`, `active_backend_id`, `cluster_name`, `uuid`) VALUES ('2026-01-31 06:51:40','2026-01-31 09:26:44',NULL,0,1,'cinder-scheduler-0','cinder-scheduler','cinder-scheduler',925,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'9e250942-6577-40cd-bf1f-780b5f401d6c'),('2026-01-31 07:26:16','2026-01-31 09:26:49',NULL,0,2,'cinder-backup-0','cinder-backup','cinder-backup',722,0,'nova',NULL,NULL,'2.4','1.39','not-capable',0,NULL,NULL,'44b235e8-9594-4bae-bdf9-dc8037923a01'),('2026-01-31 07:26:18','2026-01-31 09:26:44',NULL,0,3,'hostgroup@ceph','cinder-volume','cinder-volume',719,0,'nova',NULL,NULL,'3.18','1.39','disabled',0,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot_metadata`
--

DROP TABLE IF EXISTS `snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshot_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `snapshot_metadata_ibfk_1` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot_metadata`
--

LOCK TABLES `snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `snapshot_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshots`
--

DROP TABLE IF EXISTS `snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `volume_size` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `provider_auth` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshots_cgsnapshot_id` (`cgsnapshot_id`),
  KEY `ix_snapshots_volume_id` (`volume_id`),
  KEY `ix_snapshots_group_snapshot_id` (`group_snapshot_id`),
  KEY `snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `snapshots_ibfk_1` FOREIGN KEY (`cgsnapshot_id`) REFERENCES `cgsnapshots` (`id`),
  CONSTRAINT `snapshots_ibfk_2` FOREIGN KEY (`group_snapshot_id`) REFERENCES `group_snapshots` (`id`),
  CONSTRAINT `snapshots_volume_id_fkey` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshots`
--

LOCK TABLES `snapshots` WRITE;
/*!40000 ALTER TABLE `snapshots` DISABLE KEYS */;
INSERT INTO `snapshots` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `status`, `progress`, `volume_size`, `scheduled_at`, `display_name`, `display_description`, `provider_location`, `encryption_key_id`, `volume_type_id`, `cgsnapshot_id`, `provider_id`, `provider_auth`, `group_snapshot_id`, `use_quota`) VALUES ('2026-01-31 09:14:24','2026-01-31 09:15:40','2026-01-31 09:15:41',1,'19cd7d76-1c46-4377-b72d-ef79e4149d09','bef842a0-76ba-4e96-aba4-abce4554dd0c','ecd39871d7fd438f88b36601f25d6eb6','98d10c0290e340a08e9d1726bf0066bf','deleted','100%',1,NULL,'snapshot for tempest-TestVolumeBootPatternsnapshot-1538724823',NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,NULL,NULL,NULL,1),('2026-01-31 08:30:29','2026-01-31 08:30:46','2026-01-31 08:30:48',1,'21b15817-28c2-42de-bee4-9bdbb61c9822','cb325f0f-dc0c-4601-836f-df0aeb8cb723','85dfa8546d9942648bb4197c8b1947e3','48bbdbdee526499e90da7e971ede68d3','deleted','100%',1,NULL,'snapshot for multiattach-snapshot',NULL,NULL,NULL,'db898b53-b4de-412a-8bc7-bb25173e9740',NULL,NULL,NULL,NULL,1),('2026-01-31 09:12:28','2026-01-31 09:13:06','2026-01-31 09:13:07',1,'3d93d6e9-0ee1-4a3d-9ffd-2035ed6de999','027031c1-d50c-4a4a-a95f-34197cb6ba25','ecd39871d7fd438f88b36601f25d6eb6','98d10c0290e340a08e9d1726bf0066bf','deleted','100%',1,NULL,'tempest-TestVolumeBootPattern-snapshot-1041264280',NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,NULL,NULL,NULL,1),('2026-01-31 08:18:12','2026-01-31 08:18:16','2026-01-31 08:18:18',1,'43a4a46a-90f5-439f-8e0f-d138466ac6fe','d29f163b-986a-4747-b432-83f1e4f3b968','8c6601bfb5e74d24897f5c67e7765ffe','b2f8be0146584893ac5b769dff931958','deleted','100%',1,NULL,'tempest-VolumesSnapshotsTestJSON-Snapshot-954799526',NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,NULL,NULL,NULL,1),('2026-01-31 08:19:34','2026-01-31 08:20:04','2026-01-31 08:20:05',1,'60eb918f-d7e8-49e3-a679-91185186ea7a','124bfb1e-b91a-4179-9a6b-46ee143687ea','7f0be9090fdf49d2ac15246a0a820d3f','134c066ac92844ff853b216870fa8eed','deleted','100%',1,NULL,'tempest-TestMinimumBasicScenario-snapshot-383956900',NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,NULL,NULL,NULL,1),('2026-01-31 09:18:10','2026-01-31 09:19:01','2026-01-31 09:19:03',1,'ba746e36-34fc-458c-89f2-6c51d7e7976f','16971cc6-6c7b-47eb-9656-600213b7ac4e','ecd39871d7fd438f88b36601f25d6eb6','98d10c0290e340a08e9d1726bf0066bf','deleted','100%',1,NULL,'tempest-TestVolumeBootPattern-snapshot-1911779614',NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,NULL,NULL,NULL,1),('2026-01-31 08:54:50','2026-01-31 08:56:25','2026-01-31 08:56:26',1,'f7b92810-f6c7-4b0e-ae3e-0828d5334595','9ef5b6cb-4a21-4534-a367-ffc4848e8857','a798fdf6d13d4af4b166dd94b5cea7cc','e6e96de7b2784be1adce763bc9c9adc5','deleted','100%',1,NULL,'tempest-TestStampPattern-snapshot-782058163',NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,NULL,NULL,NULL,1);
/*!40000 ALTER TABLE `snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `no_snapshots` tinyint(1) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_transfers_volume_id` (`volume_id`),
  CONSTRAINT `transfers_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_admin_metadata`
--

DROP TABLE IF EXISTS `volume_admin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_admin_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_admin_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_admin_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_admin_metadata`
--

LOCK TABLES `volume_admin_metadata` WRITE;
/*!40000 ALTER TABLE `volume_admin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_admin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_attachment`
--

DROP TABLE IF EXISTS `volume_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_attachment` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `attached_host` varchar(255) DEFAULT NULL,
  `instance_uuid` varchar(36) DEFAULT NULL,
  `mountpoint` varchar(255) DEFAULT NULL,
  `attach_time` datetime DEFAULT NULL,
  `detach_time` datetime DEFAULT NULL,
  `attach_mode` varchar(36) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `connection_info` text DEFAULT NULL,
  `connector` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_attachment_volume_id` (`volume_id`),
  CONSTRAINT `volume_attachment_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_attachment`
--

LOCK TABLES `volume_attachment` WRITE;
/*!40000 ALTER TABLE `volume_attachment` DISABLE KEYS */;
INSERT INTO `volume_attachment` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `attached_host`, `instance_uuid`, `mountpoint`, `attach_time`, `detach_time`, `attach_mode`, `attach_status`, `connection_info`, `connector`) VALUES ('2026-01-31 07:51:12','2026-01-31 07:53:06','2026-01-31 07:53:06',1,'05e2eb3f-84f5-40b7-bd25-9e9d1b26cfd7','f4f1465d-4b57-44df-8e66-548b09052627','compute-0.ctlplane.example.com','9f390c61-950a-4c26-8733-d43d910f2430','/dev/vdb','2026-01-31 07:51:32','2026-01-31 07:53:06','rw','detached','{\"name\": \"volumes/volume-f4f1465d-4b57-44df-8e66-548b09052627\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"f4f1465d-4b57-44df-8e66-548b09052627\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"05e2eb3f-84f5-40b7-bd25-9e9d1b26cfd7\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:20:03','2026-01-31 08:20:05','2026-01-31 08:20:05',1,'070b3a49-c58c-4ede-aa2e-baf99796709b','c689a81c-bd37-441d-bd9d-94305c3032f6',NULL,'ac849bdd-07a0-459f-b207-2a3f239d0272',NULL,NULL,'2026-01-31 08:20:05','null','detached','{}',NULL),('2026-01-31 07:36:12','2026-01-31 07:36:38','2026-01-31 07:36:38',1,'07354d43-185b-4fd2-8dc3-63e0a2cce98a','21ac0cb5-f889-4135-9b17-5debc0b9246e','compute-2.ctlplane.example.com','71265e55-f168-471c-80bc-80b49177a637','/dev/vda','2026-01-31 07:36:17','2026-01-31 07:36:38','rw','detached','{\"name\": \"volumes/volume-21ac0cb5-f889-4135-9b17-5debc0b9246e\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"21ac0cb5-f889-4135-9b17-5debc0b9246e\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"07354d43-185b-4fd2-8dc3-63e0a2cce98a\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:70a4e945afb\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"d14f084b-ec77-4fba-801f-103494d34b3a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:41:19','2026-01-31 08:42:08','2026-01-31 08:42:08',1,'08e8d20e-744f-44e5-988a-74c74ca5dbc2','f0bb0c0d-db6f-42f3-aad1-86e70cc695a6','compute-0.ctlplane.example.com','5f00cd9b-b5f3-4eb6-ab53-387687853c27','/dev/vdb','2026-01-31 08:41:22','2026-01-31 08:42:08','rw','detached','{\"name\": \"volumes/volume-f0bb0c0d-db6f-42f3-aad1-86e70cc695a6\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"f0bb0c0d-db6f-42f3-aad1-86e70cc695a6\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"08e8d20e-744f-44e5-988a-74c74ca5dbc2\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 07:45:48','2026-01-31 07:46:00','2026-01-31 07:46:00',1,'0c8e863f-aae8-4385-bd78-857678107448','d1aca578-ec32-4cbf-a124-22c55e831394','compute-2.ctlplane.example.com','e7df3fd9-ff03-4b35-930a-330e9dff6d0e','/dev/vdb','2026-01-31 07:45:50','2026-01-31 07:46:00','rw','detached','{\"name\": \"volumes/volume-d1aca578-ec32-4cbf-a124-22c55e831394\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"d1aca578-ec32-4cbf-a124-22c55e831394\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"0c8e863f-aae8-4385-bd78-857678107448\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:70a4e945afb\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"d14f084b-ec77-4fba-801f-103494d34b3a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:54:43','2026-01-31 08:54:49','2026-01-31 08:54:49',1,'0f8033ff-c269-4449-a084-9c11dbe7d6e2','9ef5b6cb-4a21-4534-a367-ffc4848e8857','compute-0.ctlplane.example.com','da90f1fb-9090-49b5-a510-d7e6ac7a30d6','/dev/vdb','2026-01-31 08:54:45','2026-01-31 08:54:49','rw','detached','{\"name\": \"volumes/volume-9ef5b6cb-4a21-4534-a367-ffc4848e8857\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"9ef5b6cb-4a21-4534-a367-ffc4848e8857\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"0f8033ff-c269-4449-a084-9c11dbe7d6e2\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:30:10','2026-01-31 08:30:42','2026-01-31 08:30:42',1,'10af0b0e-5ef2-4c55-8239-29de6540845c','cb325f0f-dc0c-4601-836f-df0aeb8cb723','compute-0.ctlplane.example.com','a845825c-4dfb-41ff-b896-557e01cb3e3b','/dev/vda','2026-01-31 08:30:14','2026-01-31 08:30:42','rw','detached','{\"name\": \"volumes/volume-cb325f0f-dc0c-4601-836f-df0aeb8cb723\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"cb325f0f-dc0c-4601-836f-df0aeb8cb723\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"10af0b0e-5ef2-4c55-8239-29de6540845c\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:11:15','2026-01-31 08:11:36','2026-01-31 08:11:36',1,'11dcf9ec-8116-45f2-b743-b88783331531','eba44545-2378-4cdd-bfad-f9f0d9c730c0','compute-0.ctlplane.example.com','af8d85d9-c7a2-4709-a234-19511f3e4395','/dev/vdb','2026-01-31 08:11:17','2026-01-31 08:11:36','rw','detached','{\"name\": \"volumes/volume-eba44545-2378-4cdd-bfad-f9f0d9c730c0\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"eba44545-2378-4cdd-bfad-f9f0d9c730c0\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"11dcf9ec-8116-45f2-b743-b88783331531\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:41:31','2026-01-31 08:42:15','2026-01-31 08:42:15',1,'129c0381-e5b0-416a-8a82-a0a26dc055b8','273b2ec0-261d-40ed-887b-96124699257b','compute-0.ctlplane.example.com','5f00cd9b-b5f3-4eb6-ab53-387687853c27','/dev/vdc','2026-01-31 08:41:33','2026-01-31 08:42:15','rw','detached','{\"name\": \"volumes/volume-273b2ec0-261d-40ed-887b-96124699257b\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"273b2ec0-261d-40ed-887b-96124699257b\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"129c0381-e5b0-416a-8a82-a0a26dc055b8\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2026-01-31 08:28:05','2026-01-31 08:29:43','2026-01-31 08:29:43',1,'13b69764-03f6-48ee-b1e0-87f9db57136b','c66e3c0d-56c2-4ac0-89fe-027a1e7afcf4','compute-2.ctlplane.example.com','e89132fd-2d0c-475e-a3c5-0407e4cbbbb8','/dev/vdb','2026-01-31 08:28:13','2026-01-31 08:29:43','rw','detached','{\"name\": \"volumes/volume-c66e3c0d-56c2-4ac0-89fe-027a1e7afcf4\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"c66e3c0d-56c2-4ac0-89fe-027a1e7afcf4\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"13b69764-03f6-48ee-b1e0-87f9db57136b\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:70a4e945afb\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"d14f084b-ec77-4fba-801f-103494d34b3a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 09:17:24','2026-01-31 09:19:09','2026-01-31 09:19:09',1,'13d7a7e2-35f7-4e10-b402-b0425f10344f','16971cc6-6c7b-47eb-9656-600213b7ac4e','compute-0.ctlplane.example.com','dcc57ec3-f59a-4574-9cd4-389ae92c9e11','/dev/vda','2026-01-31 09:17:29','2026-01-31 09:19:09','rw','detached','{\"name\": \"volumes/volume-16971cc6-6c7b-47eb-9656-600213b7ac4e\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"16971cc6-6c7b-47eb-9656-600213b7ac4e\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"13d7a7e2-35f7-4e10-b402-b0425f10344f\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:01:56','2026-01-31 08:02:04','2026-01-31 08:02:04',1,'13f4ec6b-044a-427f-b078-a9d63d3a5753','746b1dd4-a34a-454d-a628-2fc84c0145c9','compute-0.ctlplane.example.com','cebc73e4-5b0d-4a7c-b9e3-4bb7575794bb','/dev/vdb','2026-01-31 08:01:58','2026-01-31 08:02:04','rw','detached','{\"name\": \"volumes/volume-746b1dd4-a34a-454d-a628-2fc84c0145c9\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"746b1dd4-a34a-454d-a628-2fc84c0145c9\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"13f4ec6b-044a-427f-b078-a9d63d3a5753\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:11:33','2026-01-31 08:12:03','2026-01-31 08:12:03',1,'213fde95-979c-4b76-ae5d-150b7df48047','eba44545-2378-4cdd-bfad-f9f0d9c730c0','compute-2.ctlplane.example.com','af8d85d9-c7a2-4709-a234-19511f3e4395','/dev/vdb','2026-01-31 08:11:44','2026-01-31 08:12:03','rw','detached','{\"name\": \"volumes/volume-eba44545-2378-4cdd-bfad-f9f0d9c730c0\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"eba44545-2378-4cdd-bfad-f9f0d9c730c0\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"213fde95-979c-4b76-ae5d-150b7df48047\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:70a4e945afb\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"d14f084b-ec77-4fba-801f-103494d34b3a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:05:31','2026-01-31 08:06:15','2026-01-31 08:06:15',1,'2277f03c-62a2-425b-9c8f-4f58661ba4de','0eed4460-dbe8-45e7-8d1d-2c1a6334d70e','compute-1.ctlplane.example.com','0f94fbbc-a8e1-4d6e-838f-925bcbdf538e','/dev/vda','2026-01-31 08:05:37','2026-01-31 08:06:15','rw','detached','{\"name\": \"volumes/volume-0eed4460-dbe8-45e7-8d1d-2c1a6334d70e\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"0eed4460-dbe8-45e7-8d1d-2c1a6334d70e\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"2277f03c-62a2-425b-9c8f-4f58661ba4de\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1765b9b6275c\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"231927d4-1ded-4b84-843c-456d697af567\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 09:12:44','2026-01-31 09:13:00','2026-01-31 09:13:00',1,'263fbd73-b688-40bf-9156-ed122af11c41','d574299e-ff71-4c51-9235-0d741f4c633c','compute-0.ctlplane.example.com','66b31a08-89b1-4470-b197-7fd3bf1820c4','/dev/vda','2026-01-31 09:12:45','2026-01-31 09:13:00','rw','detached','{\"name\": \"volumes/volume-d574299e-ff71-4c51-9235-0d741f4c633c\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"d574299e-ff71-4c51-9235-0d741f4c633c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"263fbd73-b688-40bf-9156-ed122af11c41\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:28:59','2026-01-31 08:29:45','2026-01-31 08:29:45',1,'28ab6c6c-1b6f-4e9f-a289-867ba20770bd','c66e3c0d-56c2-4ac0-89fe-027a1e7afcf4','compute-2.ctlplane.example.com','10816ede-cf43-4736-aba7-48389f607d30','/dev/vdb','2026-01-31 08:29:12','2026-01-31 08:29:45','rw','detached','{\"name\": \"volumes/volume-c66e3c0d-56c2-4ac0-89fe-027a1e7afcf4\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"c66e3c0d-56c2-4ac0-89fe-027a1e7afcf4\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"28ab6c6c-1b6f-4e9f-a289-867ba20770bd\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:70a4e945afb\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"d14f084b-ec77-4fba-801f-103494d34b3a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:17:39','2026-01-31 08:18:26','2026-01-31 08:18:26',1,'341e2c00-961d-4cab-a3b1-d0caae0c47b1','404c4de7-aa21-488f-9d20-6b6e4016f179','compute-2.ctlplane.example.com','2c1aa7ad-f9c1-4e05-8261-defaa3eef40b','/dev/vdc','2026-01-31 08:17:47','2026-01-31 08:18:26','rw','detached','{\"name\": \"volumes/volume-404c4de7-aa21-488f-9d20-6b6e4016f179\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"404c4de7-aa21-488f-9d20-6b6e4016f179\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"341e2c00-961d-4cab-a3b1-d0caae0c47b1\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:70a4e945afb\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"d14f084b-ec77-4fba-801f-103494d34b3a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2026-01-31 08:39:12','2026-01-31 08:39:55','2026-01-31 08:39:55',1,'36f527e6-fb0a-420f-a7d0-bbc889038fc1','67e8063c-e5d3-4497-bf93-33d59b6a9eb4','compute-1.ctlplane.example.com','233d3314-7d9d-49a5-818f-909d78422fb9','/dev/vdc','2026-01-31 08:39:15','2026-01-31 08:39:55','rw','detached','{\"name\": \"volumes/volume-67e8063c-e5d3-4497-bf93-33d59b6a9eb4\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"67e8063c-e5d3-4497-bf93-33d59b6a9eb4\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"36f527e6-fb0a-420f-a7d0-bbc889038fc1\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1765b9b6275c\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"231927d4-1ded-4b84-843c-456d697af567\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2026-01-31 07:33:50','2026-01-31 07:34:08','2026-01-31 07:34:08',1,'376452e0-a4e8-4be7-acb9-1409e24ca4ed','802e207e-cc7b-4779-89dc-d399ba68dc38','compute-0.ctlplane.example.com','4444d8df-265a-48a7-a945-08eb55a365e1','/dev/vda','2026-01-31 07:33:51','2026-01-31 07:34:08','null','detached','{\"name\": \"volumes/volume-802e207e-cc7b-4779-89dc-d399ba68dc38\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"802e207e-cc7b-4779-89dc-d399ba68dc38\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"376452e0-a4e8-4be7-acb9-1409e24ca4ed\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2026-01-31 08:31:24','2026-01-31 08:31:33','2026-01-31 08:31:33',1,'3cbea2b7-8782-4e83-a9f6-74d8d9194732','85d89a65-6e1e-4b74-97bb-e5082330369c','compute-2.ctlplane.example.com','cd7614f6-e095-4eaf-bc4a-f749f49d3da7','/dev/vdb','2026-01-31 08:31:26','2026-01-31 08:31:33','rw','detached','{\"name\": \"volumes/volume-85d89a65-6e1e-4b74-97bb-e5082330369c\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"85d89a65-6e1e-4b74-97bb-e5082330369c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"3cbea2b7-8782-4e83-a9f6-74d8d9194732\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:70a4e945afb\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"d14f084b-ec77-4fba-801f-103494d34b3a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:35:38','2026-01-31 08:36:02','2026-01-31 08:36:02',1,'3e821dc7-a772-419c-a06c-2ca20fe9cff2','6d2d8f34-806c-41f7-aa1a-a0cc062684f4','compute-2.ctlplane.example.com','e93a14b8-ef43-4615-a9c8-8b2df69d20d6','/dev/vdb','2026-01-31 08:35:51','2026-01-31 08:36:02','rw','detached','{\"name\": \"volumes/volume-6d2d8f34-806c-41f7-aa1a-a0cc062684f4\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"6d2d8f34-806c-41f7-aa1a-a0cc062684f4\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": true, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"3e821dc7-a772-419c-a06c-2ca20fe9cff2\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:70a4e945afb\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"d14f084b-ec77-4fba-801f-103494d34b3a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:24:42','2026-01-31 08:24:49','2026-01-31 08:24:49',1,'40ee5842-f664-4e19-b852-da2cb237beea','e0ddd33b-2a84-4319-a509-f1419e80aa70','compute-1.ctlplane.example.com','bebd0cd6-4043-4283-aee6-2b2d313ca46f','/dev/vdc','2026-01-31 08:24:43','2026-01-31 08:24:49','rw','detached','{\"name\": \"volumes/volume-e0ddd33b-2a84-4319-a509-f1419e80aa70\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"e0ddd33b-2a84-4319-a509-f1419e80aa70\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"40ee5842-f664-4e19-b852-da2cb237beea\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1765b9b6275c\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"231927d4-1ded-4b84-843c-456d697af567\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2026-01-31 08:19:31','2026-01-31 08:21:02','2026-01-31 08:21:02',1,'427a8d76-874f-48e6-8b77-2a24c293c220','124bfb1e-b91a-4179-9a6b-46ee143687ea','compute-0.ctlplane.example.com','2050d0a7-d773-4467-886b-af07b4efa0d8','/dev/vdb','2026-01-31 08:19:33','2026-01-31 08:21:02','rw','detached','{\"name\": \"volumes/volume-124bfb1e-b91a-4179-9a6b-46ee143687ea\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"124bfb1e-b91a-4179-9a6b-46ee143687ea\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"427a8d76-874f-48e6-8b77-2a24c293c220\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:12:02','2026-01-31 08:12:37','2026-01-31 08:12:37',1,'45d037e6-681c-4fcd-b6f6-8c6313d49ebf','eba44545-2378-4cdd-bfad-f9f0d9c730c0','compute-0.ctlplane.example.com','af8d85d9-c7a2-4709-a234-19511f3e4395','/dev/vdb','2026-01-31 08:12:15','2026-01-31 08:12:37','rw','detached','{\"name\": \"volumes/volume-eba44545-2378-4cdd-bfad-f9f0d9c730c0\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"eba44545-2378-4cdd-bfad-f9f0d9c730c0\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"45d037e6-681c-4fcd-b6f6-8c6313d49ebf\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:21:50','2026-01-31 08:22:33','2026-01-31 08:22:33',1,'49d7fed1-88b6-4b64-8464-c958a7045955','9e7640b2-419e-4d50-9b23-7d76e34131d8','compute-0.ctlplane.example.com','9461628f-d09f-4923-824c-3b03dfe4bb13','/dev/vdb','2026-01-31 08:21:51','2026-01-31 08:22:33','rw','detached','{\"name\": \"volumes/volume-9e7640b2-419e-4d50-9b23-7d76e34131d8\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"9e7640b2-419e-4d50-9b23-7d76e34131d8\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"49d7fed1-88b6-4b64-8464-c958a7045955\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:38:36','2026-01-31 08:43:28','2026-01-31 08:43:28',1,'527351c5-ae12-43b2-bd7c-041790d888c0','52013e9d-e76f-40eb-be07-4c6f98de0219','compute-0.ctlplane.example.com','9e883c68-083a-45ab-81fe-942de74e50ef','/dev/vda','2026-01-31 08:38:42','2026-01-31 08:43:28','rw','detached','{\"name\": \"volumes/volume-52013e9d-e76f-40eb-be07-4c6f98de0219\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"52013e9d-e76f-40eb-be07-4c6f98de0219\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"527351c5-ae12-43b2-bd7c-041790d888c0\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:04:03','2026-01-31 08:05:52','2026-01-31 08:05:52',1,'54981775-e281-4e88-8440-b87bd4e8d7a3','5839a328-04ff-4569-98df-b992860dfc6d','compute-2.ctlplane.example.com','b0ff8f26-937f-43e0-b422-8a0fb0226eac','/dev/vdb','2026-01-31 08:04:17','2026-01-31 08:05:52','rw','detached','{\"name\": \"volumes/volume-5839a328-04ff-4569-98df-b992860dfc6d\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"5839a328-04ff-4569-98df-b992860dfc6d\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"54981775-e281-4e88-8440-b87bd4e8d7a3\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:70a4e945afb\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"d14f084b-ec77-4fba-801f-103494d34b3a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 07:33:11','2026-01-31 07:33:34','2026-01-31 07:33:34',1,'574cf48c-3357-4054-9e8a-58b071261019','802e207e-cc7b-4779-89dc-d399ba68dc38','compute-0.ctlplane.example.com','4444d8df-265a-48a7-a945-08eb55a365e1','/dev/vda','2026-01-31 07:33:14','2026-01-31 07:33:34','rw','detached','{\"name\": \"volumes/volume-802e207e-cc7b-4779-89dc-d399ba68dc38\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"802e207e-cc7b-4779-89dc-d399ba68dc38\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"574cf48c-3357-4054-9e8a-58b071261019\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 07:45:08','2026-01-31 07:45:22','2026-01-31 07:45:22',1,'5a116532-3ed2-4ade-98d5-9a22d8432372','111b00c1-b66c-4cba-bfe9-abb2e4396a68','compute-1.ctlplane.example.com','3087c480-1e28-4efd-8f41-70490a9295ef','/dev/vdb','2026-01-31 07:45:11','2026-01-31 07:45:22','rw','detached','{\"name\": \"volumes/volume-111b00c1-b66c-4cba-bfe9-abb2e4396a68\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"111b00c1-b66c-4cba-bfe9-abb2e4396a68\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"5a116532-3ed2-4ade-98d5-9a22d8432372\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1765b9b6275c\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"231927d4-1ded-4b84-843c-456d697af567\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:17:04','2026-01-31 08:17:57','2026-01-31 08:17:57',1,'602d0d17-75b2-4e80-9833-94a1008d60c6','28bdb463-7d0a-42f5-8392-3acd847cfe3e','compute-0.ctlplane.example.com','83252cb5-25d7-40e3-823d-02d1d0eb73f1','/dev/vda','2026-01-31 08:17:12','2026-01-31 08:17:57','rw','detached','{\"name\": \"volumes/volume-28bdb463-7d0a-42f5-8392-3acd847cfe3e\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"28bdb463-7d0a-42f5-8392-3acd847cfe3e\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"602d0d17-75b2-4e80-9833-94a1008d60c6\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 07:33:28','2026-01-31 07:33:57','2026-01-31 07:33:57',1,'632e6ca3-f050-475e-bcd6-268090116cf1','802e207e-cc7b-4779-89dc-d399ba68dc38','compute-1.ctlplane.example.com','4444d8df-265a-48a7-a945-08eb55a365e1','/dev/vda','2026-01-31 07:33:29','2026-01-31 07:33:57','null','detached','{\"name\": \"volumes/volume-802e207e-cc7b-4779-89dc-d399ba68dc38\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"802e207e-cc7b-4779-89dc-d399ba68dc38\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"632e6ca3-f050-475e-bcd6-268090116cf1\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1765b9b6275c\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"231927d4-1ded-4b84-843c-456d697af567\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2026-01-31 07:41:44','2026-01-31 07:41:56','2026-01-31 07:41:56',1,'6446c35a-18be-4e82-954d-47b753e36829','23d2de7d-d18d-40c1-8f76-18391958864a','compute-2.ctlplane.example.com','c030025f-5967-4922-a748-2f999d0645b1','/dev/vdb','2026-01-31 07:41:46','2026-01-31 07:41:56','rw','detached','{\"name\": \"volumes/volume-23d2de7d-d18d-40c1-8f76-18391958864a\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"23d2de7d-d18d-40c1-8f76-18391958864a\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"6446c35a-18be-4e82-954d-47b753e36829\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:70a4e945afb\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"d14f084b-ec77-4fba-801f-103494d34b3a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:30:09','2026-01-31 08:30:16','2026-01-31 08:30:16',1,'656fced6-5ce0-4274-82ee-e8e078dea578','5279c0c3-4a03-4ce2-a469-4152d8ade465','compute-2.ctlplane.example.com','b17f15ec-65a0-4d5b-a53b-9e9fda7eafd5','/dev/vdb','2026-01-31 08:30:11','2026-01-31 08:30:16','rw','detached','{\"name\": \"volumes/volume-5279c0c3-4a03-4ce2-a469-4152d8ade465\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"5279c0c3-4a03-4ce2-a469-4152d8ade465\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"656fced6-5ce0-4274-82ee-e8e078dea578\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:70a4e945afb\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"d14f084b-ec77-4fba-801f-103494d34b3a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 07:31:40','2026-01-31 07:32:11','2026-01-31 07:32:11',1,'666c639f-1a54-48ac-89a9-c7b2a2580395','1bbb8596-60ef-452c-be5b-f1b3f34acf56','compute-0.ctlplane.example.com','f610bafa-64ee-4d38-8be4-7c17cd2b2a99','/dev/vdb','2026-01-31 07:31:44','2026-01-31 07:32:11','rw','detached','{\"name\": \"volumes/volume-1bbb8596-60ef-452c-be5b-f1b3f34acf56\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"1bbb8596-60ef-452c-be5b-f1b3f34acf56\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"666c639f-1a54-48ac-89a9-c7b2a2580395\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 09:14:41','2026-01-31 09:15:35','2026-01-31 09:15:35',1,'6950d456-da22-44be-910e-060a13ad0ffd','873ab52c-6ddb-4591-95be-4fd33ed9a07f','compute-2.ctlplane.example.com','71be684d-2233-462f-8268-a0bf7ea3f281','/dev/vda','2026-01-31 09:14:42','2026-01-31 09:15:35','rw','detached','{\"name\": \"volumes/volume-873ab52c-6ddb-4591-95be-4fd33ed9a07f\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"873ab52c-6ddb-4591-95be-4fd33ed9a07f\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"6950d456-da22-44be-910e-060a13ad0ffd\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:70a4e945afb\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"d14f084b-ec77-4fba-801f-103494d34b3a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 09:16:27','2026-01-31 09:17:14','2026-01-31 09:17:14',1,'6a3470bf-28e7-4cb3-86a3-aead50eba653','16971cc6-6c7b-47eb-9656-600213b7ac4e','compute-0.ctlplane.example.com','6b297264-ad85-4d75-97eb-afe8844db41c','/dev/vda','2026-01-31 09:16:31','2026-01-31 09:17:14','rw','detached','{\"name\": \"volumes/volume-16971cc6-6c7b-47eb-9656-600213b7ac4e\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"16971cc6-6c7b-47eb-9656-600213b7ac4e\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"6a3470bf-28e7-4cb3-86a3-aead50eba653\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:17:56','2026-01-31 08:19:01','2026-01-31 08:19:01',1,'702eea6c-f82b-4551-9b33-10fe93968866','28bdb463-7d0a-42f5-8392-3acd847cfe3e','compute-0.ctlplane.example.com','83252cb5-25d7-40e3-823d-02d1d0eb73f1','/dev/vda','2026-01-31 08:18:12','2026-01-31 08:19:01','rw','detached','{\"name\": \"volumes/volume-28bdb463-7d0a-42f5-8392-3acd847cfe3e\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"28bdb463-7d0a-42f5-8392-3acd847cfe3e\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"702eea6c-f82b-4551-9b33-10fe93968866\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 09:08:57','2026-01-31 09:09:53','2026-01-31 09:09:53',1,'70ee36d0-631d-4d42-9f55-4e4b543c4804','cf361715-504e-40e5-87bf-5f49366009aa','compute-2.ctlplane.example.com','9a579d21-79af-418a-a1d6-756329428431','/dev/vda','2026-01-31 09:09:02','2026-01-31 09:09:53','rw','detached','{\"name\": \"volumes/volume-cf361715-504e-40e5-87bf-5f49366009aa\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"cf361715-504e-40e5-87bf-5f49366009aa\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"70ee36d0-631d-4d42-9f55-4e4b543c4804\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:70a4e945afb\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"d14f084b-ec77-4fba-801f-103494d34b3a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:38:40','2026-01-31 08:43:08','2026-01-31 08:43:08',1,'724a860c-bb9f-4cd1-8cef-1d90670977f8','937c2f7d-b961-4dec-b1ad-34dd4c2d4cac','compute-0.ctlplane.example.com','5f00cd9b-b5f3-4eb6-ab53-387687853c27','/dev/vda','2026-01-31 08:38:51','2026-01-31 08:43:08','rw','detached','{\"name\": \"volumes/volume-937c2f7d-b961-4dec-b1ad-34dd4c2d4cac\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"937c2f7d-b961-4dec-b1ad-34dd4c2d4cac\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"724a860c-bb9f-4cd1-8cef-1d90670977f8\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 07:39:53','2026-01-31 07:39:57','2026-01-31 07:39:57',1,'727ce9e7-c88c-41c6-a7bc-1248fde884b8','0de5a428-04b5-4163-84c5-f4e760bbda69','compute-0.ctlplane.example.com','30b63014-8760-428b-a66d-201587534734','/dev/sdc','2026-01-31 07:39:54','2026-01-31 07:39:57','rw','detached','{\"name\": \"volumes/volume-0de5a428-04b5-4163-84c5-f4e760bbda69\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"0de5a428-04b5-4163-84c5-f4e760bbda69\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"727ce9e7-c88c-41c6-a7bc-1248fde884b8\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/sdc\"}'),('2026-01-31 08:04:07','2026-01-31 08:04:26','2026-01-31 08:04:26',1,'78c846b9-b07c-49d7-921b-b840c2849b01','008cf290-7941-4c64-a361-689cb2af7bcc','compute-1.ctlplane.example.com','79977ab8-f5fd-4e71-b86e-34bf6e623879','/dev/vdb','2026-01-31 08:04:10','2026-01-31 08:04:26','rw','detached','{\"name\": \"volumes/volume-008cf290-7941-4c64-a361-689cb2af7bcc\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"008cf290-7941-4c64-a361-689cb2af7bcc\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"78c846b9-b07c-49d7-921b-b840c2849b01\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1765b9b6275c\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"231927d4-1ded-4b84-843c-456d697af567\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:26:32','2026-01-31 08:26:42','2026-01-31 08:26:42',1,'7d1a6c4a-de83-4ac6-a420-a85b4d557c1a','4e49c5a3-4191-4757-9b9f-0465fe16a7f1','compute-0.ctlplane.example.com','bbc5f09e-71d7-4009-bdf6-06e95b32574c','/dev/vdb','2026-01-31 08:26:34','2026-01-31 08:26:42','rw','detached','{\"name\": \"volumes/volume-4e49c5a3-4191-4757-9b9f-0465fe16a7f1\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"4e49c5a3-4191-4757-9b9f-0465fe16a7f1\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"7d1a6c4a-de83-4ac6-a420-a85b4d557c1a\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:22:14','2026-01-31 08:23:10','2026-01-31 08:23:10',1,'7fceadad-37e2-4c13-8ac8-9c60e9870397','5cf392c9-4c4c-4680-9529-6ff296b6467e','compute-1.ctlplane.example.com','20cc7040-fd06-49c7-8e68-41cb74e67e9a','/dev/vdb','2026-01-31 08:22:15','2026-01-31 08:23:10','rw','detached','{\"name\": \"volumes/volume-5cf392c9-4c4c-4680-9529-6ff296b6467e\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"5cf392c9-4c4c-4680-9529-6ff296b6467e\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"7fceadad-37e2-4c13-8ac8-9c60e9870397\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1765b9b6275c\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"231927d4-1ded-4b84-843c-456d697af567\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 07:36:30','2026-01-31 07:36:58','2026-01-31 07:36:58',1,'813cfeab-a1f5-44af-8928-fed3ed24d043','21ac0cb5-f889-4135-9b17-5debc0b9246e','compute-1.ctlplane.example.com','71265e55-f168-471c-80bc-80b49177a637','/dev/vda','2026-01-31 07:36:31','2026-01-31 07:36:58','null','detached','{\"name\": \"volumes/volume-21ac0cb5-f889-4135-9b17-5debc0b9246e\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"21ac0cb5-f889-4135-9b17-5debc0b9246e\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"813cfeab-a1f5-44af-8928-fed3ed24d043\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1765b9b6275c\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"231927d4-1ded-4b84-843c-456d697af567\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2026-01-31 08:40:17','2026-01-31 08:41:07','2026-01-31 08:41:07',1,'853a354f-45a8-4694-8e0d-8b79cafba13b','32f698bc-fdf5-4d95-826a-13f70e60d6b8','compute-0.ctlplane.example.com','9e883c68-083a-45ab-81fe-942de74e50ef','/dev/vdc','2026-01-31 08:40:19','2026-01-31 08:41:07','rw','detached','{\"name\": \"volumes/volume-32f698bc-fdf5-4d95-826a-13f70e60d6b8\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"32f698bc-fdf5-4d95-826a-13f70e60d6b8\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"853a354f-45a8-4694-8e0d-8b79cafba13b\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2026-01-31 08:38:31','2026-01-31 08:43:38','2026-01-31 08:43:38',1,'85d6cc81-8ef1-4d41-b5be-78882cf4696d','98644432-f138-4ffa-ac72-90128df20205','compute-1.ctlplane.example.com','233d3314-7d9d-49a5-818f-909d78422fb9','/dev/vda','2026-01-31 08:38:37','2026-01-31 08:43:38','rw','detached','{\"name\": \"volumes/volume-98644432-f138-4ffa-ac72-90128df20205\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"98644432-f138-4ffa-ac72-90128df20205\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"85d6cc81-8ef1-4d41-b5be-78882cf4696d\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1765b9b6275c\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"231927d4-1ded-4b84-843c-456d697af567\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:56:02','2026-01-31 08:56:11','2026-01-31 08:56:11',1,'9070e2db-feb7-4020-9ab8-67041d6df378','da113752-340c-4a7b-98c3-707e5c3c2d4b','compute-2.ctlplane.example.com','27645b95-3e37-43ba-8465-c8789c0f8700','/dev/vdb','2026-01-31 08:56:04','2026-01-31 08:56:11','rw','detached','{\"name\": \"volumes/volume-da113752-340c-4a7b-98c3-707e5c3c2d4b\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"da113752-340c-4a7b-98c3-707e5c3c2d4b\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"9070e2db-feb7-4020-9ab8-67041d6df378\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:70a4e945afb\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"d14f084b-ec77-4fba-801f-103494d34b3a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 07:36:53','2026-01-31 07:37:11','2026-01-31 07:37:11',1,'9464adf5-0d15-4a7f-b59e-f30b825dce00','21ac0cb5-f889-4135-9b17-5debc0b9246e','compute-2.ctlplane.example.com','71265e55-f168-471c-80bc-80b49177a637','/dev/vda','2026-01-31 07:36:53','2026-01-31 07:37:11','null','detached','{\"name\": \"volumes/volume-21ac0cb5-f889-4135-9b17-5debc0b9246e\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"21ac0cb5-f889-4135-9b17-5debc0b9246e\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"9464adf5-0d15-4a7f-b59e-f30b825dce00\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:70a4e945afb\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"d14f084b-ec77-4fba-801f-103494d34b3a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2026-01-31 08:24:36','2026-01-31 08:24:46','2026-01-31 08:24:46',1,'98e91211-70ba-46de-8359-01cc8f145c58','c7efb5e6-4cbc-4621-8f4f-a1a945d0bb8c','compute-1.ctlplane.example.com','bebd0cd6-4043-4283-aee6-2b2d313ca46f','/dev/vdb','2026-01-31 08:24:38','2026-01-31 08:24:46','rw','detached','{\"name\": \"volumes/volume-c7efb5e6-4cbc-4621-8f4f-a1a945d0bb8c\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"c7efb5e6-4cbc-4621-8f4f-a1a945d0bb8c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"98e91211-70ba-46de-8359-01cc8f145c58\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1765b9b6275c\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"231927d4-1ded-4b84-843c-456d697af567\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:27:34','2026-01-31 08:28:06','2026-01-31 08:28:06',1,'98f56350-b4f9-4380-9298-d7e2a6967b73','c66e3c0d-56c2-4ac0-89fe-027a1e7afcf4','compute-2.ctlplane.example.com','e89132fd-2d0c-475e-a3c5-0407e4cbbbb8','/dev/vdb','2026-01-31 08:27:36','2026-01-31 08:28:06','rw','detached','{\"name\": \"volumes/volume-c66e3c0d-56c2-4ac0-89fe-027a1e7afcf4\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"c66e3c0d-56c2-4ac0-89fe-027a1e7afcf4\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"98f56350-b4f9-4380-9298-d7e2a6967b73\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:70a4e945afb\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"d14f084b-ec77-4fba-801f-103494d34b3a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 07:45:39','2026-01-31 07:46:04','2026-01-31 07:46:04',1,'a0d524fc-94e0-41e3-aefa-aa210cff89f9','d1aca578-ec32-4cbf-a124-22c55e831394','compute-0.ctlplane.example.com','a2a97039-8813-4ebf-9ce0-488982bece16','/dev/vdb','2026-01-31 07:45:45','2026-01-31 07:46:04','rw','detached','{\"name\": \"volumes/volume-d1aca578-ec32-4cbf-a124-22c55e831394\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"d1aca578-ec32-4cbf-a124-22c55e831394\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"a0d524fc-94e0-41e3-aefa-aa210cff89f9\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:39:05','2026-01-31 08:39:47','2026-01-31 08:39:47',1,'b5494f9d-2db0-4fde-95c9-dc967b04b9a1','be0b3094-6fbc-448a-804b-4a365824d522','compute-1.ctlplane.example.com','233d3314-7d9d-49a5-818f-909d78422fb9','/dev/vdb','2026-01-31 08:39:10','2026-01-31 08:39:47','rw','detached','{\"name\": \"volumes/volume-be0b3094-6fbc-448a-804b-4a365824d522\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"be0b3094-6fbc-448a-804b-4a365824d522\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"b5494f9d-2db0-4fde-95c9-dc967b04b9a1\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1765b9b6275c\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"231927d4-1ded-4b84-843c-456d697af567\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 09:18:20','2026-01-31 09:18:58','2026-01-31 09:18:58',1,'b5702e65-231f-4ca6-87f6-2e9fa6ea2d08','b13e384a-f308-411e-add5-2e1bc75b4439','compute-2.ctlplane.example.com','aa28bdce-0eba-4f00-a4f5-954f6254edd9','/dev/vda','2026-01-31 09:18:25','2026-01-31 09:18:58','rw','detached','{\"name\": \"volumes/volume-b13e384a-f308-411e-add5-2e1bc75b4439\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"b13e384a-f308-411e-add5-2e1bc75b4439\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"b5702e65-231f-4ca6-87f6-2e9fa6ea2d08\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:70a4e945afb\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"d14f084b-ec77-4fba-801f-103494d34b3a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:24:44','2026-01-31 08:32:06','2026-01-31 08:32:06',1,'baed91ee-e5df-4d94-afbd-ea04a1f2d51b','aa9253f0-3405-4d95-ab32-e423b297e3e5','compute-0.ctlplane.example.com','1beb42da-13c9-4f95-8a5d-e2c3c1affd2a','/dev/vda','2026-01-31 08:24:48','2026-01-31 08:32:06','rw','detached','{\"name\": \"volumes/volume-aa9253f0-3405-4d95-ab32-e423b297e3e5\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"aa9253f0-3405-4d95-ab32-e423b297e3e5\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"baed91ee-e5df-4d94-afbd-ea04a1f2d51b\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 09:08:19','2026-01-31 09:08:58','2026-01-31 09:08:58',1,'c8db5bd0-1a98-4aee-9c13-632937fd835a','cf361715-504e-40e5-87bf-5f49366009aa','compute-1.ctlplane.example.com','9a579d21-79af-418a-a1d6-756329428431','/dev/vda','2026-01-31 09:08:23','2026-01-31 09:08:58','rw','detached','{\"name\": \"volumes/volume-cf361715-504e-40e5-87bf-5f49366009aa\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"cf361715-504e-40e5-87bf-5f49366009aa\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"c8db5bd0-1a98-4aee-9c13-632937fd835a\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1765b9b6275c\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"231927d4-1ded-4b84-843c-456d697af567\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:27:10','2026-01-31 08:28:44','2026-01-31 08:28:44',1,'cea545d4-0d68-460c-b27d-29f6b2c30e27','d1f290e7-6438-4a38-9b76-cefa7f5a6025','compute-0.ctlplane.example.com','884d5d5d-6ad9-46a8-867a-b01ed20a527d','/dev/vdb','2026-01-31 08:27:12','2026-01-31 08:28:44','rw','detached','{\"name\": \"volumes/volume-d1f290e7-6438-4a38-9b76-cefa7f5a6025\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"d1f290e7-6438-4a38-9b76-cefa7f5a6025\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"cea545d4-0d68-460c-b27d-29f6b2c30e27\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:27:38','2026-01-31 08:28:59','2026-01-31 08:28:59',1,'cf5beae6-16a5-4e99-b7c5-ed0efcabe671','c66e3c0d-56c2-4ac0-89fe-027a1e7afcf4','compute-0.ctlplane.example.com','10816ede-cf43-4736-aba7-48389f607d30','/dev/vdb','2026-01-31 08:27:40','2026-01-31 08:28:59','rw','detached','{\"name\": \"volumes/volume-c66e3c0d-56c2-4ac0-89fe-027a1e7afcf4\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"c66e3c0d-56c2-4ac0-89fe-027a1e7afcf4\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"cf5beae6-16a5-4e99-b7c5-ed0efcabe671\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 09:11:25','2026-01-31 09:12:04','2026-01-31 09:12:04',1,'db0d205e-31f6-4e20-96ba-6275d6869991','2af2ded2-cbd7-44f4-b8e4-72d974e773dd','compute-1.ctlplane.example.com','8a396bde-ca33-406e-a877-1d3e33fec3e7','/dev/vda','2026-01-31 09:11:32','2026-01-31 09:12:04','rw','detached','{\"name\": \"volumes/volume-2af2ded2-cbd7-44f4-b8e4-72d974e773dd\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"2af2ded2-cbd7-44f4-b8e4-72d974e773dd\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": true, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"db0d205e-31f6-4e20-96ba-6275d6869991\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1765b9b6275c\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"231927d4-1ded-4b84-843c-456d697af567\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:21:26','2026-01-31 08:24:55','2026-01-31 08:24:55',1,'db690fac-05bc-4a16-95ca-cd07b52ed09d','9963309d-4585-4a8d-8bdf-00f8aa2f69e1','compute-1.ctlplane.example.com','946cb648-0758-4617-bd3a-142804fd70f7','/dev/vda','2026-01-31 08:21:28','2026-01-31 08:24:55','rw','detached','{\"name\": \"volumes/volume-9963309d-4585-4a8d-8bdf-00f8aa2f69e1\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"9963309d-4585-4a8d-8bdf-00f8aa2f69e1\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"db690fac-05bc-4a16-95ca-cd07b52ed09d\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1765b9b6275c\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"231927d4-1ded-4b84-843c-456d697af567\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 07:51:13','2026-01-31 07:53:07','2026-01-31 07:53:07',1,'de9a0d23-e1e1-45b6-afc1-1d3caabd10dc','9b441e8b-6bb5-4554-9b00-62c0672ca9cf','compute-0.ctlplane.example.com','9f390c61-950a-4c26-8733-d43d910f2430','/dev/vdc','2026-01-31 07:51:36','2026-01-31 07:53:07','rw','detached','{\"name\": \"volumes/volume-9b441e8b-6bb5-4554-9b00-62c0672ca9cf\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"9b441e8b-6bb5-4554-9b00-62c0672ca9cf\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"de9a0d23-e1e1-45b6-afc1-1d3caabd10dc\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2026-01-31 08:06:11','2026-01-31 08:06:58','2026-01-31 08:06:58',1,'ded4e542-1993-4756-afd5-73d156885b75','0eed4460-dbe8-45e7-8d1d-2c1a6334d70e','compute-0.ctlplane.example.com','0f94fbbc-a8e1-4d6e-838f-925bcbdf538e','/dev/vda','2026-01-31 08:06:25','2026-01-31 08:06:58','rw','detached','{\"name\": \"volumes/volume-0eed4460-dbe8-45e7-8d1d-2c1a6334d70e\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"0eed4460-dbe8-45e7-8d1d-2c1a6334d70e\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"ded4e542-1993-4756-afd5-73d156885b75\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:03:57','2026-01-31 08:04:07','2026-01-31 08:04:07',1,'dfdf7988-9c47-4683-adbf-be7e041137af','008cf290-7941-4c64-a361-689cb2af7bcc','compute-1.ctlplane.example.com','79977ab8-f5fd-4e71-b86e-34bf6e623879','/dev/vdb','2026-01-31 08:03:58','2026-01-31 08:04:07','rw','detached','{\"name\": \"volumes/volume-008cf290-7941-4c64-a361-689cb2af7bcc\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"008cf290-7941-4c64-a361-689cb2af7bcc\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"dfdf7988-9c47-4683-adbf-be7e041137af\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1765b9b6275c\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"231927d4-1ded-4b84-843c-456d697af567\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 07:52:35','2026-01-31 07:53:16','2026-01-31 07:53:16',1,'e45281b4-66a6-4aa0-89ef-c871e880bb7d','a1b4a963-bab3-4e88-b617-96814bf6094a','compute-1.ctlplane.example.com','c440f73c-e6b3-46be-a2e3-702703379890','/dev/vda','2026-01-31 07:52:38','2026-01-31 07:53:16','rw','detached','{\"name\": \"volumes/volume-a1b4a963-bab3-4e88-b617-96814bf6094a\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"a1b4a963-bab3-4e88-b617-96814bf6094a\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"e45281b4-66a6-4aa0-89ef-c871e880bb7d\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1765b9b6275c\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"231927d4-1ded-4b84-843c-456d697af567\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:26:27','2026-01-31 08:26:39','2026-01-31 08:26:39',1,'e7959411-8aea-4bb3-83f7-22e949a10669','4e49c5a3-4191-4757-9b9f-0465fe16a7f1','compute-1.ctlplane.example.com','8bf29da0-2e1a-4e89-bce8-b293a938c742','/dev/vdb','2026-01-31 08:26:29','2026-01-31 08:26:39','rw','detached','{\"name\": \"volumes/volume-4e49c5a3-4191-4757-9b9f-0465fe16a7f1\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"4e49c5a3-4191-4757-9b9f-0465fe16a7f1\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"e7959411-8aea-4bb3-83f7-22e949a10669\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1765b9b6275c\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"231927d4-1ded-4b84-843c-456d697af567\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:04:03','2026-01-31 08:05:52','2026-01-31 08:05:52',1,'eb70e519-8547-4929-bfc1-f1fa7219cf7b','799c0e3e-5252-4646-befe-0999c33cc481','compute-2.ctlplane.example.com','b0ff8f26-937f-43e0-b422-8a0fb0226eac','/dev/vdc','2026-01-31 08:04:19','2026-01-31 08:05:52','rw','detached','{\"name\": \"volumes/volume-799c0e3e-5252-4646-befe-0999c33cc481\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"799c0e3e-5252-4646-befe-0999c33cc481\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"eb70e519-8547-4929-bfc1-f1fa7219cf7b\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:70a4e945afb\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"d14f084b-ec77-4fba-801f-103494d34b3a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2026-01-31 09:13:33','2026-01-31 09:15:46','2026-01-31 09:15:46',1,'ed0090a8-6dee-4bb3-bf34-9b308526c7b0','bef842a0-76ba-4e96-aba4-abce4554dd0c','compute-0.ctlplane.example.com','f82c07b4-3acf-4385-9b7a-8a49da3cd55a','/dev/vda','2026-01-31 09:13:37','2026-01-31 09:15:46','rw','detached','{\"name\": \"volumes/volume-bef842a0-76ba-4e96-aba4-abce4554dd0c\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"bef842a0-76ba-4e96-aba4-abce4554dd0c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"ed0090a8-6dee-4bb3-bf34-9b308526c7b0\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:40:10','2026-01-31 08:41:02','2026-01-31 08:41:02',1,'ef357034-57ec-488f-9238-ba9816613ea0','5e3dddd5-2020-4bc8-ad80-973dfd3573b1','compute-0.ctlplane.example.com','9e883c68-083a-45ab-81fe-942de74e50ef','/dev/vdb','2026-01-31 08:40:13','2026-01-31 08:41:02','rw','detached','{\"name\": \"volumes/volume-5e3dddd5-2020-4bc8-ad80-973dfd3573b1\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"5e3dddd5-2020-4bc8-ad80-973dfd3573b1\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"ef357034-57ec-488f-9238-ba9816613ea0\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 07:51:12','2026-01-31 07:53:06','2026-01-31 07:53:06',1,'f045fb93-8f01-48c8-8c73-a75112fb995b','a8fc40ce-92f5-4848-b108-e10dbbb71633','compute-0.ctlplane.example.com','9f390c61-950a-4c26-8733-d43d910f2430','/dev/vda','2026-01-31 07:51:27','2026-01-31 07:53:06','rw','detached','{\"name\": \"volumes/volume-a8fc40ce-92f5-4848-b108-e10dbbb71633\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"a8fc40ce-92f5-4848-b108-e10dbbb71633\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"f045fb93-8f01-48c8-8c73-a75112fb995b\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:24:00','2026-01-31 08:24:42','2026-01-31 08:24:42',1,'f16d44ff-26d6-4ad8-8798-323b6a48be9d','bb6c3a76-a1e4-4bd7-8526-2c74f412b508','compute-0.ctlplane.example.com','6a10c21a-772d-4a5c-8f62-3d90d4b7ca56','/dev/vda','2026-01-31 08:24:01','2026-01-31 08:24:42','rw','detached','{\"name\": \"volumes/volume-bb6c3a76-a1e4-4bd7-8526-2c74f412b508\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"bb6c3a76-a1e4-4bd7-8526-2c74f412b508\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"f16d44ff-26d6-4ad8-8798-323b6a48be9d\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:21:36','2026-01-31 08:22:36','2026-01-31 08:22:36',1,'f22791e6-dc5c-4007-ae59-452a2e598637','9e79b760-3e32-4b0f-9644-d12b3e5189ad','compute-2.ctlplane.example.com','aa396f7d-4c1b-445e-807c-05107a729be4','/dev/vdb','2026-01-31 08:21:37','2026-01-31 08:22:36','rw','detached','{\"name\": \"volumes/volume-9e79b760-3e32-4b0f-9644-d12b3e5189ad\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"9e79b760-3e32-4b0f-9644-d12b3e5189ad\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"f22791e6-dc5c-4007-ae59-452a2e598637\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:70a4e945afb\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"d14f084b-ec77-4fba-801f-103494d34b3a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:04:02','2026-01-31 08:05:52','2026-01-31 08:05:52',1,'f51781cc-c8af-46ab-9e0f-4fa3ba2d07c1','38f98947-0572-42f2-a1bf-7adcaef6ac4c','compute-2.ctlplane.example.com','b0ff8f26-937f-43e0-b422-8a0fb0226eac','/dev/vda','2026-01-31 08:04:15','2026-01-31 08:05:52','rw','detached','{\"name\": \"volumes/volume-38f98947-0572-42f2-a1bf-7adcaef6ac4c\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"38f98947-0572-42f2-a1bf-7adcaef6ac4c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"f51781cc-c8af-46ab-9e0f-4fa3ba2d07c1\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:70a4e945afb\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"d14f084b-ec77-4fba-801f-103494d34b3a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:16:35','2026-01-31 08:17:57','2026-01-31 08:17:57',1,'f59239f8-ac09-4b3b-a97a-ef159be2d50b','ddc44c03-3580-457e-b1d4-9a35d3c393e8','compute-0.ctlplane.example.com','743cf933-3139-4c25-9c75-b45150274ae3','/dev/vdb','2026-01-31 08:16:53','2026-01-31 08:17:57','rw','detached','{\"name\": \"volumes/volume-ddc44c03-3580-457e-b1d4-9a35d3c393e8\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"ddc44c03-3580-457e-b1d4-9a35d3c393e8\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"f59239f8-ac09-4b3b-a97a-ef159be2d50b\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:58:40','2026-01-31 08:59:17','2026-01-31 08:59:17',1,'f9cb034f-03a7-4914-ba0e-94615d09a9f6','4fa6de41-50fa-4a7f-9f53-f34c852aad03','compute-0.ctlplane.example.com','b5a9d1f1-65d6-4560-98fa-a2eb7858eb30','/dev/vda','2026-01-31 08:58:43','2026-01-31 08:59:17','rw','detached','{\"name\": \"volumes/volume-4fa6de41-50fa-4a7f-9f53-f34c852aad03\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"f70fcd2a-dcb4-5f89-a4ba-79a09959083b\", \"volume_id\": \"4fa6de41-50fa-4a7f-9f53-f34c852aad03\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"f9cb034f-03a7-4914-ba0e-94615d09a9f6\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:8e229365167\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"8f281c2a-1a44-41ea-8268-6c420f002b7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}');
/*!40000 ALTER TABLE `volume_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_glance_metadata`
--

DROP TABLE IF EXISTS `volume_glance_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_glance_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_glance_metadata_snapshot_id` (`snapshot_id`),
  KEY `ix_volume_glance_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_glance_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `volume_glance_metadata_ibfk_2` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=267 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_glance_metadata`
--

LOCK TABLES `volume_glance_metadata` WRITE;
/*!40000 ALTER TABLE `volume_glance_metadata` DISABLE KEYS */;
INSERT INTO `volume_glance_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `snapshot_id`, `key`, `value`) VALUES ('2026-01-31 07:33:01',NULL,'2026-01-31 07:34:09',1,1,'802e207e-cc7b-4779-89dc-d399ba68dc38',NULL,'signature_verified','False'),('2026-01-31 07:33:07',NULL,'2026-01-31 07:34:09',1,2,'802e207e-cc7b-4779-89dc-d399ba68dc38',NULL,'hw_rng_model','virtio'),('2026-01-31 07:33:07',NULL,'2026-01-31 07:34:09',1,3,'802e207e-cc7b-4779-89dc-d399ba68dc38',NULL,'image_id','7c23949f-bba8-4466-bb79-caf568852d38'),('2026-01-31 07:33:07',NULL,'2026-01-31 07:34:09',1,4,'802e207e-cc7b-4779-89dc-d399ba68dc38',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 07:33:07',NULL,'2026-01-31 07:34:09',1,5,'802e207e-cc7b-4779-89dc-d399ba68dc38',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 07:33:07',NULL,'2026-01-31 07:34:09',1,6,'802e207e-cc7b-4779-89dc-d399ba68dc38',NULL,'container_format','bare'),('2026-01-31 07:33:07',NULL,'2026-01-31 07:34:09',1,7,'802e207e-cc7b-4779-89dc-d399ba68dc38',NULL,'disk_format','qcow2'),('2026-01-31 07:33:07',NULL,'2026-01-31 07:34:09',1,8,'802e207e-cc7b-4779-89dc-d399ba68dc38',NULL,'min_disk','0'),('2026-01-31 07:33:07',NULL,'2026-01-31 07:34:09',1,9,'802e207e-cc7b-4779-89dc-d399ba68dc38',NULL,'min_ram','0'),('2026-01-31 07:33:07',NULL,'2026-01-31 07:34:09',1,10,'802e207e-cc7b-4779-89dc-d399ba68dc38',NULL,'size','21430272'),('2026-01-31 07:36:05',NULL,'2026-01-31 07:37:12',1,11,'21ac0cb5-f889-4135-9b17-5debc0b9246e',NULL,'signature_verified','False'),('2026-01-31 07:36:09',NULL,'2026-01-31 07:37:12',1,12,'21ac0cb5-f889-4135-9b17-5debc0b9246e',NULL,'hw_rng_model','virtio'),('2026-01-31 07:36:09',NULL,'2026-01-31 07:37:12',1,13,'21ac0cb5-f889-4135-9b17-5debc0b9246e',NULL,'image_id','7c23949f-bba8-4466-bb79-caf568852d38'),('2026-01-31 07:36:09',NULL,'2026-01-31 07:37:12',1,14,'21ac0cb5-f889-4135-9b17-5debc0b9246e',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 07:36:09',NULL,'2026-01-31 07:37:12',1,15,'21ac0cb5-f889-4135-9b17-5debc0b9246e',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 07:36:09',NULL,'2026-01-31 07:37:12',1,16,'21ac0cb5-f889-4135-9b17-5debc0b9246e',NULL,'container_format','bare'),('2026-01-31 07:36:09',NULL,'2026-01-31 07:37:12',1,17,'21ac0cb5-f889-4135-9b17-5debc0b9246e',NULL,'disk_format','qcow2'),('2026-01-31 07:36:09',NULL,'2026-01-31 07:37:12',1,18,'21ac0cb5-f889-4135-9b17-5debc0b9246e',NULL,'min_disk','0'),('2026-01-31 07:36:09',NULL,'2026-01-31 07:37:12',1,19,'21ac0cb5-f889-4135-9b17-5debc0b9246e',NULL,'min_ram','0'),('2026-01-31 07:36:09',NULL,'2026-01-31 07:37:12',1,20,'21ac0cb5-f889-4135-9b17-5debc0b9246e',NULL,'size','21430272'),('2026-01-31 07:50:35',NULL,'2026-01-31 07:53:22',1,21,'a8fc40ce-92f5-4848-b108-e10dbbb71633',NULL,'signature_verified','False'),('2026-01-31 07:50:41',NULL,'2026-01-31 07:53:22',1,22,'a8fc40ce-92f5-4848-b108-e10dbbb71633',NULL,'hw_rng_model','virtio'),('2026-01-31 07:50:41',NULL,'2026-01-31 07:53:22',1,23,'a8fc40ce-92f5-4848-b108-e10dbbb71633',NULL,'image_id','7c23949f-bba8-4466-bb79-caf568852d38'),('2026-01-31 07:50:41',NULL,'2026-01-31 07:53:22',1,24,'a8fc40ce-92f5-4848-b108-e10dbbb71633',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 07:50:41',NULL,'2026-01-31 07:53:22',1,25,'a8fc40ce-92f5-4848-b108-e10dbbb71633',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 07:50:41',NULL,'2026-01-31 07:53:22',1,26,'a8fc40ce-92f5-4848-b108-e10dbbb71633',NULL,'container_format','bare'),('2026-01-31 07:50:41',NULL,'2026-01-31 07:53:22',1,27,'a8fc40ce-92f5-4848-b108-e10dbbb71633',NULL,'disk_format','qcow2'),('2026-01-31 07:50:41',NULL,'2026-01-31 07:53:22',1,28,'a8fc40ce-92f5-4848-b108-e10dbbb71633',NULL,'min_disk','0'),('2026-01-31 07:50:41',NULL,'2026-01-31 07:53:22',1,29,'a8fc40ce-92f5-4848-b108-e10dbbb71633',NULL,'min_ram','0'),('2026-01-31 07:50:41',NULL,'2026-01-31 07:53:22',1,30,'a8fc40ce-92f5-4848-b108-e10dbbb71633',NULL,'size','21430272'),('2026-01-31 07:52:17',NULL,'2026-01-31 07:53:19',1,31,'a1b4a963-bab3-4e88-b617-96814bf6094a',NULL,'signature_verified','False'),('2026-01-31 07:52:30',NULL,'2026-01-31 07:53:19',1,32,'a1b4a963-bab3-4e88-b617-96814bf6094a',NULL,'hw_rng_model','virtio'),('2026-01-31 07:52:30',NULL,'2026-01-31 07:53:19',1,33,'a1b4a963-bab3-4e88-b617-96814bf6094a',NULL,'image_id','7c23949f-bba8-4466-bb79-caf568852d38'),('2026-01-31 07:52:30',NULL,'2026-01-31 07:53:19',1,34,'a1b4a963-bab3-4e88-b617-96814bf6094a',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 07:52:30',NULL,'2026-01-31 07:53:19',1,35,'a1b4a963-bab3-4e88-b617-96814bf6094a',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 07:52:31',NULL,'2026-01-31 07:53:19',1,36,'a1b4a963-bab3-4e88-b617-96814bf6094a',NULL,'container_format','bare'),('2026-01-31 07:52:31',NULL,'2026-01-31 07:53:19',1,37,'a1b4a963-bab3-4e88-b617-96814bf6094a',NULL,'disk_format','qcow2'),('2026-01-31 07:52:31',NULL,'2026-01-31 07:53:19',1,38,'a1b4a963-bab3-4e88-b617-96814bf6094a',NULL,'min_disk','0'),('2026-01-31 07:52:31',NULL,'2026-01-31 07:53:19',1,39,'a1b4a963-bab3-4e88-b617-96814bf6094a',NULL,'min_ram','0'),('2026-01-31 07:52:31',NULL,'2026-01-31 07:53:19',1,40,'a1b4a963-bab3-4e88-b617-96814bf6094a',NULL,'size','21430272'),('2026-01-31 08:03:26',NULL,'2026-01-31 08:06:09',1,41,'38f98947-0572-42f2-a1bf-7adcaef6ac4c',NULL,'signature_verified','False'),('2026-01-31 08:03:32',NULL,'2026-01-31 08:06:09',1,42,'38f98947-0572-42f2-a1bf-7adcaef6ac4c',NULL,'hw_rng_model','virtio'),('2026-01-31 08:03:32',NULL,'2026-01-31 08:06:09',1,43,'38f98947-0572-42f2-a1bf-7adcaef6ac4c',NULL,'image_id','7c23949f-bba8-4466-bb79-caf568852d38'),('2026-01-31 08:03:32',NULL,'2026-01-31 08:06:09',1,44,'38f98947-0572-42f2-a1bf-7adcaef6ac4c',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 08:03:32',NULL,'2026-01-31 08:06:09',1,45,'38f98947-0572-42f2-a1bf-7adcaef6ac4c',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 08:03:32',NULL,'2026-01-31 08:06:09',1,46,'38f98947-0572-42f2-a1bf-7adcaef6ac4c',NULL,'container_format','bare'),('2026-01-31 08:03:32',NULL,'2026-01-31 08:06:09',1,47,'38f98947-0572-42f2-a1bf-7adcaef6ac4c',NULL,'disk_format','qcow2'),('2026-01-31 08:03:32',NULL,'2026-01-31 08:06:09',1,48,'38f98947-0572-42f2-a1bf-7adcaef6ac4c',NULL,'min_disk','0'),('2026-01-31 08:03:32',NULL,'2026-01-31 08:06:09',1,49,'38f98947-0572-42f2-a1bf-7adcaef6ac4c',NULL,'min_ram','0'),('2026-01-31 08:03:32',NULL,'2026-01-31 08:06:09',1,50,'38f98947-0572-42f2-a1bf-7adcaef6ac4c',NULL,'size','21430272'),('2026-01-31 08:05:18',NULL,'2026-01-31 08:07:03',1,51,'0eed4460-dbe8-45e7-8d1d-2c1a6334d70e',NULL,'signature_verified','False'),('2026-01-31 08:05:27',NULL,'2026-01-31 08:07:03',1,52,'0eed4460-dbe8-45e7-8d1d-2c1a6334d70e',NULL,'hw_rng_model','virtio'),('2026-01-31 08:05:27',NULL,'2026-01-31 08:07:03',1,53,'0eed4460-dbe8-45e7-8d1d-2c1a6334d70e',NULL,'image_id','7c23949f-bba8-4466-bb79-caf568852d38'),('2026-01-31 08:05:27',NULL,'2026-01-31 08:07:03',1,54,'0eed4460-dbe8-45e7-8d1d-2c1a6334d70e',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 08:05:27',NULL,'2026-01-31 08:07:03',1,55,'0eed4460-dbe8-45e7-8d1d-2c1a6334d70e',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 08:05:27',NULL,'2026-01-31 08:07:03',1,56,'0eed4460-dbe8-45e7-8d1d-2c1a6334d70e',NULL,'container_format','bare'),('2026-01-31 08:05:27',NULL,'2026-01-31 08:07:03',1,57,'0eed4460-dbe8-45e7-8d1d-2c1a6334d70e',NULL,'disk_format','qcow2'),('2026-01-31 08:05:27',NULL,'2026-01-31 08:07:03',1,58,'0eed4460-dbe8-45e7-8d1d-2c1a6334d70e',NULL,'min_disk','0'),('2026-01-31 08:05:27',NULL,'2026-01-31 08:07:03',1,59,'0eed4460-dbe8-45e7-8d1d-2c1a6334d70e',NULL,'min_ram','0'),('2026-01-31 08:05:27',NULL,'2026-01-31 08:07:03',1,60,'0eed4460-dbe8-45e7-8d1d-2c1a6334d70e',NULL,'size','21430272'),('2026-01-31 08:16:33',NULL,'2026-01-31 08:18:09',1,61,'28bdb463-7d0a-42f5-8392-3acd847cfe3e',NULL,'signature_verified','False'),('2026-01-31 08:16:57',NULL,'2026-01-31 08:18:09',1,62,'28bdb463-7d0a-42f5-8392-3acd847cfe3e',NULL,'hw_rng_model','virtio'),('2026-01-31 08:16:57',NULL,'2026-01-31 08:18:09',1,63,'28bdb463-7d0a-42f5-8392-3acd847cfe3e',NULL,'image_id','7c23949f-bba8-4466-bb79-caf568852d38'),('2026-01-31 08:16:57',NULL,'2026-01-31 08:18:09',1,64,'28bdb463-7d0a-42f5-8392-3acd847cfe3e',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 08:16:57',NULL,'2026-01-31 08:18:09',1,65,'28bdb463-7d0a-42f5-8392-3acd847cfe3e',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 08:16:57',NULL,'2026-01-31 08:18:09',1,66,'28bdb463-7d0a-42f5-8392-3acd847cfe3e',NULL,'container_format','bare'),('2026-01-31 08:16:57',NULL,'2026-01-31 08:18:09',1,67,'28bdb463-7d0a-42f5-8392-3acd847cfe3e',NULL,'disk_format','qcow2'),('2026-01-31 08:16:57',NULL,'2026-01-31 08:18:09',1,68,'28bdb463-7d0a-42f5-8392-3acd847cfe3e',NULL,'min_disk','0'),('2026-01-31 08:16:57',NULL,'2026-01-31 08:18:09',1,69,'28bdb463-7d0a-42f5-8392-3acd847cfe3e',NULL,'min_ram','0'),('2026-01-31 08:16:57',NULL,'2026-01-31 08:18:09',1,70,'28bdb463-7d0a-42f5-8392-3acd847cfe3e',NULL,'size','21430272'),('2026-01-31 08:18:09',NULL,'2026-01-31 08:19:02',1,71,'28bdb463-7d0a-42f5-8392-3acd847cfe3e',NULL,'hw_rng_model','virtio'),('2026-01-31 08:18:09',NULL,'2026-01-31 08:19:02',1,72,'28bdb463-7d0a-42f5-8392-3acd847cfe3e',NULL,'image_id','40cf2ff3-f7ff-4843-b4ab-b7dcc843006f'),('2026-01-31 08:18:09',NULL,'2026-01-31 08:19:02',1,73,'28bdb463-7d0a-42f5-8392-3acd847cfe3e',NULL,'image_name','cirros-0.6.2-x86_64-disk.img_alt'),('2026-01-31 08:18:09',NULL,'2026-01-31 08:19:02',1,74,'28bdb463-7d0a-42f5-8392-3acd847cfe3e',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 08:18:09',NULL,'2026-01-31 08:19:02',1,75,'28bdb463-7d0a-42f5-8392-3acd847cfe3e',NULL,'container_format','bare'),('2026-01-31 08:18:09',NULL,'2026-01-31 08:19:02',1,76,'28bdb463-7d0a-42f5-8392-3acd847cfe3e',NULL,'disk_format','qcow2'),('2026-01-31 08:18:09',NULL,'2026-01-31 08:19:02',1,77,'28bdb463-7d0a-42f5-8392-3acd847cfe3e',NULL,'min_disk','0'),('2026-01-31 08:18:09',NULL,'2026-01-31 08:19:02',1,78,'28bdb463-7d0a-42f5-8392-3acd847cfe3e',NULL,'min_ram','0'),('2026-01-31 08:18:09',NULL,'2026-01-31 08:19:02',1,79,'28bdb463-7d0a-42f5-8392-3acd847cfe3e',NULL,'size','21430272'),('2026-01-31 08:23:50',NULL,NULL,0,80,'bb6c3a76-a1e4-4bd7-8526-2c74f412b508',NULL,'signature_verified','False'),('2026-01-31 08:23:57',NULL,NULL,0,81,'bb6c3a76-a1e4-4bd7-8526-2c74f412b508',NULL,'hw_rng_model','virtio'),('2026-01-31 08:23:57',NULL,NULL,0,82,'bb6c3a76-a1e4-4bd7-8526-2c74f412b508',NULL,'image_id','7c23949f-bba8-4466-bb79-caf568852d38'),('2026-01-31 08:23:57',NULL,NULL,0,83,'bb6c3a76-a1e4-4bd7-8526-2c74f412b508',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 08:23:57',NULL,NULL,0,84,'bb6c3a76-a1e4-4bd7-8526-2c74f412b508',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 08:23:57',NULL,NULL,0,85,'bb6c3a76-a1e4-4bd7-8526-2c74f412b508',NULL,'container_format','bare'),('2026-01-31 08:23:57',NULL,NULL,0,86,'bb6c3a76-a1e4-4bd7-8526-2c74f412b508',NULL,'disk_format','qcow2'),('2026-01-31 08:23:57',NULL,NULL,0,87,'bb6c3a76-a1e4-4bd7-8526-2c74f412b508',NULL,'min_disk','0'),('2026-01-31 08:23:57',NULL,NULL,0,88,'bb6c3a76-a1e4-4bd7-8526-2c74f412b508',NULL,'min_ram','0'),('2026-01-31 08:23:57',NULL,NULL,0,89,'bb6c3a76-a1e4-4bd7-8526-2c74f412b508',NULL,'size','21430272'),('2026-01-31 08:24:35',NULL,'2026-01-31 08:32:17',1,90,'aa9253f0-3405-4d95-ab32-e423b297e3e5',NULL,'signature_verified','False'),('2026-01-31 08:24:40',NULL,'2026-01-31 08:32:17',1,91,'aa9253f0-3405-4d95-ab32-e423b297e3e5',NULL,'hw_rng_model','virtio'),('2026-01-31 08:24:40',NULL,'2026-01-31 08:32:17',1,92,'aa9253f0-3405-4d95-ab32-e423b297e3e5',NULL,'image_id','7c23949f-bba8-4466-bb79-caf568852d38'),('2026-01-31 08:24:40',NULL,'2026-01-31 08:32:17',1,93,'aa9253f0-3405-4d95-ab32-e423b297e3e5',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 08:24:40',NULL,'2026-01-31 08:32:17',1,94,'aa9253f0-3405-4d95-ab32-e423b297e3e5',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 08:24:40',NULL,'2026-01-31 08:32:17',1,95,'aa9253f0-3405-4d95-ab32-e423b297e3e5',NULL,'container_format','bare'),('2026-01-31 08:24:40',NULL,'2026-01-31 08:32:17',1,96,'aa9253f0-3405-4d95-ab32-e423b297e3e5',NULL,'disk_format','qcow2'),('2026-01-31 08:24:40',NULL,'2026-01-31 08:32:17',1,97,'aa9253f0-3405-4d95-ab32-e423b297e3e5',NULL,'min_disk','0'),('2026-01-31 08:24:40',NULL,'2026-01-31 08:32:17',1,98,'aa9253f0-3405-4d95-ab32-e423b297e3e5',NULL,'min_ram','0'),('2026-01-31 08:24:40',NULL,'2026-01-31 08:32:17',1,99,'aa9253f0-3405-4d95-ab32-e423b297e3e5',NULL,'size','21430272'),('2026-01-31 08:29:57',NULL,'2026-01-31 08:30:51',1,100,'cb325f0f-dc0c-4601-836f-df0aeb8cb723',NULL,'signature_verified','False'),('2026-01-31 08:30:05',NULL,'2026-01-31 08:30:51',1,101,'cb325f0f-dc0c-4601-836f-df0aeb8cb723',NULL,'hw_rng_model','virtio'),('2026-01-31 08:30:05',NULL,'2026-01-31 08:30:51',1,102,'cb325f0f-dc0c-4601-836f-df0aeb8cb723',NULL,'image_id','7c23949f-bba8-4466-bb79-caf568852d38'),('2026-01-31 08:30:05',NULL,'2026-01-31 08:30:51',1,103,'cb325f0f-dc0c-4601-836f-df0aeb8cb723',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 08:30:05',NULL,'2026-01-31 08:30:51',1,104,'cb325f0f-dc0c-4601-836f-df0aeb8cb723',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 08:30:05',NULL,'2026-01-31 08:30:51',1,105,'cb325f0f-dc0c-4601-836f-df0aeb8cb723',NULL,'container_format','bare'),('2026-01-31 08:30:05',NULL,'2026-01-31 08:30:51',1,106,'cb325f0f-dc0c-4601-836f-df0aeb8cb723',NULL,'disk_format','qcow2'),('2026-01-31 08:30:05',NULL,'2026-01-31 08:30:51',1,107,'cb325f0f-dc0c-4601-836f-df0aeb8cb723',NULL,'min_disk','0'),('2026-01-31 08:30:05',NULL,'2026-01-31 08:30:51',1,108,'cb325f0f-dc0c-4601-836f-df0aeb8cb723',NULL,'min_ram','0'),('2026-01-31 08:30:05',NULL,'2026-01-31 08:30:51',1,109,'cb325f0f-dc0c-4601-836f-df0aeb8cb723',NULL,'size','21430272'),('2026-01-31 08:30:31',NULL,'2026-01-31 08:30:48',1,110,NULL,'21b15817-28c2-42de-bee4-9bdbb61c9822','signature_verified','False'),('2026-01-31 08:30:31',NULL,'2026-01-31 08:30:48',1,111,NULL,'21b15817-28c2-42de-bee4-9bdbb61c9822','hw_rng_model','virtio'),('2026-01-31 08:30:31',NULL,'2026-01-31 08:30:48',1,112,NULL,'21b15817-28c2-42de-bee4-9bdbb61c9822','image_id','7c23949f-bba8-4466-bb79-caf568852d38'),('2026-01-31 08:30:31',NULL,'2026-01-31 08:30:48',1,113,NULL,'21b15817-28c2-42de-bee4-9bdbb61c9822','image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 08:30:31',NULL,'2026-01-31 08:30:48',1,114,NULL,'21b15817-28c2-42de-bee4-9bdbb61c9822','checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 08:30:31',NULL,'2026-01-31 08:30:48',1,115,NULL,'21b15817-28c2-42de-bee4-9bdbb61c9822','container_format','bare'),('2026-01-31 08:30:31',NULL,'2026-01-31 08:30:48',1,116,NULL,'21b15817-28c2-42de-bee4-9bdbb61c9822','disk_format','qcow2'),('2026-01-31 08:30:31',NULL,'2026-01-31 08:30:48',1,117,NULL,'21b15817-28c2-42de-bee4-9bdbb61c9822','min_disk','0'),('2026-01-31 08:30:31',NULL,'2026-01-31 08:30:48',1,118,NULL,'21b15817-28c2-42de-bee4-9bdbb61c9822','min_ram','0'),('2026-01-31 08:30:31',NULL,'2026-01-31 08:30:48',1,119,NULL,'21b15817-28c2-42de-bee4-9bdbb61c9822','size','21430272'),('2026-01-31 08:38:19',NULL,'2026-01-31 08:43:49',1,120,'98644432-f138-4ffa-ac72-90128df20205',NULL,'signature_verified','False'),('2026-01-31 08:38:19',NULL,'2026-01-31 08:43:48',1,121,'52013e9d-e76f-40eb-be07-4c6f98de0219',NULL,'signature_verified','False'),('2026-01-31 08:38:23',NULL,'2026-01-31 08:43:46',1,122,'937c2f7d-b961-4dec-b1ad-34dd4c2d4cac',NULL,'signature_verified','False'),('2026-01-31 08:38:26',NULL,'2026-01-31 08:43:48',1,123,'52013e9d-e76f-40eb-be07-4c6f98de0219',NULL,'image_id','5c110bb6-9d02-475d-ac34-1ec891f50aba'),('2026-01-31 08:38:26',NULL,'2026-01-31 08:43:48',1,124,'52013e9d-e76f-40eb-be07-4c6f98de0219',NULL,'image_name','tempest-scenario-img--163750645'),('2026-01-31 08:38:26',NULL,'2026-01-31 08:43:48',1,125,'52013e9d-e76f-40eb-be07-4c6f98de0219',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 08:38:26',NULL,'2026-01-31 08:43:48',1,126,'52013e9d-e76f-40eb-be07-4c6f98de0219',NULL,'container_format','bare'),('2026-01-31 08:38:26',NULL,'2026-01-31 08:43:48',1,127,'52013e9d-e76f-40eb-be07-4c6f98de0219',NULL,'disk_format','qcow2'),('2026-01-31 08:38:26',NULL,'2026-01-31 08:43:48',1,128,'52013e9d-e76f-40eb-be07-4c6f98de0219',NULL,'min_disk','0'),('2026-01-31 08:38:26',NULL,'2026-01-31 08:43:48',1,129,'52013e9d-e76f-40eb-be07-4c6f98de0219',NULL,'min_ram','0'),('2026-01-31 08:38:26',NULL,'2026-01-31 08:43:48',1,130,'52013e9d-e76f-40eb-be07-4c6f98de0219',NULL,'size','21430272'),('2026-01-31 08:38:26',NULL,'2026-01-31 08:43:49',1,131,'98644432-f138-4ffa-ac72-90128df20205',NULL,'image_id','5c110bb6-9d02-475d-ac34-1ec891f50aba'),('2026-01-31 08:38:26',NULL,'2026-01-31 08:43:49',1,132,'98644432-f138-4ffa-ac72-90128df20205',NULL,'image_name','tempest-scenario-img--163750645'),('2026-01-31 08:38:26',NULL,'2026-01-31 08:43:49',1,133,'98644432-f138-4ffa-ac72-90128df20205',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 08:38:26',NULL,'2026-01-31 08:43:49',1,134,'98644432-f138-4ffa-ac72-90128df20205',NULL,'container_format','bare'),('2026-01-31 08:38:26',NULL,'2026-01-31 08:43:49',1,135,'98644432-f138-4ffa-ac72-90128df20205',NULL,'disk_format','qcow2'),('2026-01-31 08:38:26',NULL,'2026-01-31 08:43:49',1,136,'98644432-f138-4ffa-ac72-90128df20205',NULL,'min_disk','0'),('2026-01-31 08:38:26',NULL,'2026-01-31 08:43:49',1,137,'98644432-f138-4ffa-ac72-90128df20205',NULL,'min_ram','0'),('2026-01-31 08:38:26',NULL,'2026-01-31 08:43:49',1,138,'98644432-f138-4ffa-ac72-90128df20205',NULL,'size','21430272'),('2026-01-31 08:38:29',NULL,'2026-01-31 08:43:46',1,139,'937c2f7d-b961-4dec-b1ad-34dd4c2d4cac',NULL,'image_id','5c110bb6-9d02-475d-ac34-1ec891f50aba'),('2026-01-31 08:38:29',NULL,'2026-01-31 08:43:46',1,140,'937c2f7d-b961-4dec-b1ad-34dd4c2d4cac',NULL,'image_name','tempest-scenario-img--163750645'),('2026-01-31 08:38:29',NULL,'2026-01-31 08:43:46',1,141,'937c2f7d-b961-4dec-b1ad-34dd4c2d4cac',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 08:38:29',NULL,'2026-01-31 08:43:46',1,142,'937c2f7d-b961-4dec-b1ad-34dd4c2d4cac',NULL,'container_format','bare'),('2026-01-31 08:38:29',NULL,'2026-01-31 08:43:46',1,143,'937c2f7d-b961-4dec-b1ad-34dd4c2d4cac',NULL,'disk_format','qcow2'),('2026-01-31 08:38:29',NULL,'2026-01-31 08:43:46',1,144,'937c2f7d-b961-4dec-b1ad-34dd4c2d4cac',NULL,'min_disk','0'),('2026-01-31 08:38:29',NULL,'2026-01-31 08:43:46',1,145,'937c2f7d-b961-4dec-b1ad-34dd4c2d4cac',NULL,'min_ram','0'),('2026-01-31 08:38:29',NULL,'2026-01-31 08:43:46',1,146,'937c2f7d-b961-4dec-b1ad-34dd4c2d4cac',NULL,'size','21430272'),('2026-01-31 08:58:07',NULL,'2026-01-31 08:59:28',1,147,'f0449ef7-c417-44d1-9add-b0929b3d95af',NULL,'signature_verified','False'),('2026-01-31 08:58:14',NULL,'2026-01-31 08:59:28',1,148,'f0449ef7-c417-44d1-9add-b0929b3d95af',NULL,'hw_rng_model','virtio'),('2026-01-31 08:58:14',NULL,'2026-01-31 08:59:28',1,149,'f0449ef7-c417-44d1-9add-b0929b3d95af',NULL,'image_id','7c23949f-bba8-4466-bb79-caf568852d38'),('2026-01-31 08:58:14',NULL,'2026-01-31 08:59:28',1,150,'f0449ef7-c417-44d1-9add-b0929b3d95af',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 08:58:14',NULL,'2026-01-31 08:59:28',1,151,'f0449ef7-c417-44d1-9add-b0929b3d95af',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 08:58:14',NULL,'2026-01-31 08:59:28',1,152,'f0449ef7-c417-44d1-9add-b0929b3d95af',NULL,'container_format','bare'),('2026-01-31 08:58:14',NULL,'2026-01-31 08:59:28',1,153,'f0449ef7-c417-44d1-9add-b0929b3d95af',NULL,'disk_format','qcow2'),('2026-01-31 08:58:14',NULL,'2026-01-31 08:59:28',1,154,'f0449ef7-c417-44d1-9add-b0929b3d95af',NULL,'min_disk','0'),('2026-01-31 08:58:15',NULL,'2026-01-31 08:59:28',1,155,'f0449ef7-c417-44d1-9add-b0929b3d95af',NULL,'min_ram','0'),('2026-01-31 08:58:15',NULL,'2026-01-31 08:59:28',1,156,'f0449ef7-c417-44d1-9add-b0929b3d95af',NULL,'size','21430272'),('2026-01-31 08:58:30',NULL,'2026-01-31 08:59:26',1,157,'4fa6de41-50fa-4a7f-9f53-f34c852aad03',NULL,'signature_verified','False'),('2026-01-31 08:58:30',NULL,'2026-01-31 08:59:26',1,158,'4fa6de41-50fa-4a7f-9f53-f34c852aad03',NULL,'hw_rng_model','virtio'),('2026-01-31 08:58:30',NULL,'2026-01-31 08:59:26',1,159,'4fa6de41-50fa-4a7f-9f53-f34c852aad03',NULL,'image_id','7c23949f-bba8-4466-bb79-caf568852d38'),('2026-01-31 08:58:30',NULL,'2026-01-31 08:59:26',1,160,'4fa6de41-50fa-4a7f-9f53-f34c852aad03',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 08:58:30',NULL,'2026-01-31 08:59:26',1,161,'4fa6de41-50fa-4a7f-9f53-f34c852aad03',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 08:58:30',NULL,'2026-01-31 08:59:26',1,162,'4fa6de41-50fa-4a7f-9f53-f34c852aad03',NULL,'container_format','bare'),('2026-01-31 08:58:31',NULL,'2026-01-31 08:59:26',1,163,'4fa6de41-50fa-4a7f-9f53-f34c852aad03',NULL,'disk_format','qcow2'),('2026-01-31 08:58:31',NULL,'2026-01-31 08:59:26',1,164,'4fa6de41-50fa-4a7f-9f53-f34c852aad03',NULL,'min_disk','0'),('2026-01-31 08:58:31',NULL,'2026-01-31 08:59:26',1,165,'4fa6de41-50fa-4a7f-9f53-f34c852aad03',NULL,'min_ram','0'),('2026-01-31 08:58:31',NULL,'2026-01-31 08:59:26',1,166,'4fa6de41-50fa-4a7f-9f53-f34c852aad03',NULL,'size','21430272'),('2026-01-31 09:08:12',NULL,'2026-01-31 09:09:54',1,167,'cf361715-504e-40e5-87bf-5f49366009aa',NULL,'signature_verified','False'),('2026-01-31 09:08:16',NULL,'2026-01-31 09:09:54',1,168,'cf361715-504e-40e5-87bf-5f49366009aa',NULL,'hw_rng_model','virtio'),('2026-01-31 09:08:16',NULL,'2026-01-31 09:09:54',1,169,'cf361715-504e-40e5-87bf-5f49366009aa',NULL,'image_id','7c23949f-bba8-4466-bb79-caf568852d38'),('2026-01-31 09:08:16',NULL,'2026-01-31 09:09:54',1,170,'cf361715-504e-40e5-87bf-5f49366009aa',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 09:08:16',NULL,'2026-01-31 09:09:54',1,171,'cf361715-504e-40e5-87bf-5f49366009aa',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 09:08:16',NULL,'2026-01-31 09:09:54',1,172,'cf361715-504e-40e5-87bf-5f49366009aa',NULL,'container_format','bare'),('2026-01-31 09:08:16',NULL,'2026-01-31 09:09:54',1,173,'cf361715-504e-40e5-87bf-5f49366009aa',NULL,'disk_format','qcow2'),('2026-01-31 09:08:16',NULL,'2026-01-31 09:09:54',1,174,'cf361715-504e-40e5-87bf-5f49366009aa',NULL,'min_disk','0'),('2026-01-31 09:08:16',NULL,'2026-01-31 09:09:54',1,175,'cf361715-504e-40e5-87bf-5f49366009aa',NULL,'min_ram','0'),('2026-01-31 09:08:16',NULL,'2026-01-31 09:09:54',1,176,'cf361715-504e-40e5-87bf-5f49366009aa',NULL,'size','21430272'),('2026-01-31 09:12:17',NULL,'2026-01-31 09:13:11',1,177,'027031c1-d50c-4a4a-a95f-34197cb6ba25',NULL,'signature_verified','False'),('2026-01-31 09:12:27',NULL,'2026-01-31 09:13:11',1,178,'027031c1-d50c-4a4a-a95f-34197cb6ba25',NULL,'hw_rng_model','virtio'),('2026-01-31 09:12:27',NULL,'2026-01-31 09:13:11',1,179,'027031c1-d50c-4a4a-a95f-34197cb6ba25',NULL,'image_id','7c23949f-bba8-4466-bb79-caf568852d38'),('2026-01-31 09:12:27',NULL,'2026-01-31 09:13:11',1,180,'027031c1-d50c-4a4a-a95f-34197cb6ba25',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 09:12:27',NULL,'2026-01-31 09:13:11',1,181,'027031c1-d50c-4a4a-a95f-34197cb6ba25',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 09:12:27',NULL,'2026-01-31 09:13:11',1,182,'027031c1-d50c-4a4a-a95f-34197cb6ba25',NULL,'container_format','bare'),('2026-01-31 09:12:27',NULL,'2026-01-31 09:13:11',1,183,'027031c1-d50c-4a4a-a95f-34197cb6ba25',NULL,'disk_format','qcow2'),('2026-01-31 09:12:27',NULL,'2026-01-31 09:13:11',1,184,'027031c1-d50c-4a4a-a95f-34197cb6ba25',NULL,'min_disk','0'),('2026-01-31 09:12:27',NULL,'2026-01-31 09:13:11',1,185,'027031c1-d50c-4a4a-a95f-34197cb6ba25',NULL,'min_ram','0'),('2026-01-31 09:12:27',NULL,'2026-01-31 09:13:11',1,186,'027031c1-d50c-4a4a-a95f-34197cb6ba25',NULL,'size','21430272'),('2026-01-31 09:12:30',NULL,'2026-01-31 09:13:07',1,187,NULL,'3d93d6e9-0ee1-4a3d-9ffd-2035ed6de999','signature_verified','False'),('2026-01-31 09:12:30',NULL,'2026-01-31 09:13:07',1,188,NULL,'3d93d6e9-0ee1-4a3d-9ffd-2035ed6de999','hw_rng_model','virtio'),('2026-01-31 09:12:30',NULL,'2026-01-31 09:13:07',1,189,NULL,'3d93d6e9-0ee1-4a3d-9ffd-2035ed6de999','image_id','7c23949f-bba8-4466-bb79-caf568852d38'),('2026-01-31 09:12:30',NULL,'2026-01-31 09:13:07',1,190,NULL,'3d93d6e9-0ee1-4a3d-9ffd-2035ed6de999','image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 09:12:30',NULL,'2026-01-31 09:13:07',1,191,NULL,'3d93d6e9-0ee1-4a3d-9ffd-2035ed6de999','checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 09:12:30',NULL,'2026-01-31 09:13:07',1,192,NULL,'3d93d6e9-0ee1-4a3d-9ffd-2035ed6de999','container_format','bare'),('2026-01-31 09:12:30',NULL,'2026-01-31 09:13:07',1,193,NULL,'3d93d6e9-0ee1-4a3d-9ffd-2035ed6de999','disk_format','qcow2'),('2026-01-31 09:12:30',NULL,'2026-01-31 09:13:07',1,194,NULL,'3d93d6e9-0ee1-4a3d-9ffd-2035ed6de999','min_disk','0'),('2026-01-31 09:12:30',NULL,'2026-01-31 09:13:07',1,195,NULL,'3d93d6e9-0ee1-4a3d-9ffd-2035ed6de999','min_ram','0'),('2026-01-31 09:12:30',NULL,'2026-01-31 09:13:07',1,196,NULL,'3d93d6e9-0ee1-4a3d-9ffd-2035ed6de999','size','21430272'),('2026-01-31 09:12:41',NULL,'2026-01-31 09:13:04',1,197,'d574299e-ff71-4c51-9235-0d741f4c633c',NULL,'signature_verified','False'),('2026-01-31 09:12:41',NULL,'2026-01-31 09:13:04',1,198,'d574299e-ff71-4c51-9235-0d741f4c633c',NULL,'hw_rng_model','virtio'),('2026-01-31 09:12:41',NULL,'2026-01-31 09:13:04',1,199,'d574299e-ff71-4c51-9235-0d741f4c633c',NULL,'image_id','7c23949f-bba8-4466-bb79-caf568852d38'),('2026-01-31 09:12:41',NULL,'2026-01-31 09:13:04',1,200,'d574299e-ff71-4c51-9235-0d741f4c633c',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 09:12:41',NULL,'2026-01-31 09:13:04',1,201,'d574299e-ff71-4c51-9235-0d741f4c633c',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 09:12:41',NULL,'2026-01-31 09:13:04',1,202,'d574299e-ff71-4c51-9235-0d741f4c633c',NULL,'container_format','bare'),('2026-01-31 09:12:41',NULL,'2026-01-31 09:13:04',1,203,'d574299e-ff71-4c51-9235-0d741f4c633c',NULL,'disk_format','qcow2'),('2026-01-31 09:12:41',NULL,'2026-01-31 09:13:04',1,204,'d574299e-ff71-4c51-9235-0d741f4c633c',NULL,'min_disk','0'),('2026-01-31 09:12:41',NULL,'2026-01-31 09:13:04',1,205,'d574299e-ff71-4c51-9235-0d741f4c633c',NULL,'min_ram','0'),('2026-01-31 09:12:41',NULL,'2026-01-31 09:13:04',1,206,'d574299e-ff71-4c51-9235-0d741f4c633c',NULL,'size','21430272'),('2026-01-31 09:13:17',NULL,'2026-01-31 09:15:47',1,207,'bef842a0-76ba-4e96-aba4-abce4554dd0c',NULL,'signature_verified','False'),('2026-01-31 09:13:25',NULL,'2026-01-31 09:15:47',1,208,'bef842a0-76ba-4e96-aba4-abce4554dd0c',NULL,'hw_rng_model','virtio'),('2026-01-31 09:13:25',NULL,'2026-01-31 09:15:47',1,209,'bef842a0-76ba-4e96-aba4-abce4554dd0c',NULL,'image_id','7c23949f-bba8-4466-bb79-caf568852d38'),('2026-01-31 09:13:25',NULL,'2026-01-31 09:15:47',1,210,'bef842a0-76ba-4e96-aba4-abce4554dd0c',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 09:13:25',NULL,'2026-01-31 09:15:47',1,211,'bef842a0-76ba-4e96-aba4-abce4554dd0c',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 09:13:25',NULL,'2026-01-31 09:15:47',1,212,'bef842a0-76ba-4e96-aba4-abce4554dd0c',NULL,'container_format','bare'),('2026-01-31 09:13:25',NULL,'2026-01-31 09:15:47',1,213,'bef842a0-76ba-4e96-aba4-abce4554dd0c',NULL,'disk_format','qcow2'),('2026-01-31 09:13:25',NULL,'2026-01-31 09:15:47',1,214,'bef842a0-76ba-4e96-aba4-abce4554dd0c',NULL,'min_disk','0'),('2026-01-31 09:13:25',NULL,'2026-01-31 09:15:47',1,215,'bef842a0-76ba-4e96-aba4-abce4554dd0c',NULL,'min_ram','0'),('2026-01-31 09:13:25',NULL,'2026-01-31 09:15:47',1,216,'bef842a0-76ba-4e96-aba4-abce4554dd0c',NULL,'size','21430272'),('2026-01-31 09:14:26',NULL,'2026-01-31 09:15:41',1,217,NULL,'19cd7d76-1c46-4377-b72d-ef79e4149d09','signature_verified','False'),('2026-01-31 09:14:26',NULL,'2026-01-31 09:15:41',1,218,NULL,'19cd7d76-1c46-4377-b72d-ef79e4149d09','hw_rng_model','virtio'),('2026-01-31 09:14:26',NULL,'2026-01-31 09:15:41',1,219,NULL,'19cd7d76-1c46-4377-b72d-ef79e4149d09','image_id','7c23949f-bba8-4466-bb79-caf568852d38'),('2026-01-31 09:14:26',NULL,'2026-01-31 09:15:41',1,220,NULL,'19cd7d76-1c46-4377-b72d-ef79e4149d09','image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 09:14:26',NULL,'2026-01-31 09:15:41',1,221,NULL,'19cd7d76-1c46-4377-b72d-ef79e4149d09','checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 09:14:26',NULL,'2026-01-31 09:15:41',1,222,NULL,'19cd7d76-1c46-4377-b72d-ef79e4149d09','container_format','bare'),('2026-01-31 09:14:26',NULL,'2026-01-31 09:15:41',1,223,NULL,'19cd7d76-1c46-4377-b72d-ef79e4149d09','disk_format','qcow2'),('2026-01-31 09:14:26',NULL,'2026-01-31 09:15:41',1,224,NULL,'19cd7d76-1c46-4377-b72d-ef79e4149d09','min_disk','0'),('2026-01-31 09:14:26',NULL,'2026-01-31 09:15:41',1,225,NULL,'19cd7d76-1c46-4377-b72d-ef79e4149d09','min_ram','0'),('2026-01-31 09:14:26',NULL,'2026-01-31 09:15:41',1,226,NULL,'19cd7d76-1c46-4377-b72d-ef79e4149d09','size','21430272'),('2026-01-31 09:14:38',NULL,'2026-01-31 09:15:39',1,227,'873ab52c-6ddb-4591-95be-4fd33ed9a07f',NULL,'signature_verified','False'),('2026-01-31 09:14:38',NULL,'2026-01-31 09:15:39',1,228,'873ab52c-6ddb-4591-95be-4fd33ed9a07f',NULL,'hw_rng_model','virtio'),('2026-01-31 09:14:38',NULL,'2026-01-31 09:15:39',1,229,'873ab52c-6ddb-4591-95be-4fd33ed9a07f',NULL,'image_id','7c23949f-bba8-4466-bb79-caf568852d38'),('2026-01-31 09:14:38',NULL,'2026-01-31 09:15:39',1,230,'873ab52c-6ddb-4591-95be-4fd33ed9a07f',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 09:14:38',NULL,'2026-01-31 09:15:39',1,231,'873ab52c-6ddb-4591-95be-4fd33ed9a07f',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 09:14:38',NULL,'2026-01-31 09:15:39',1,232,'873ab52c-6ddb-4591-95be-4fd33ed9a07f',NULL,'container_format','bare'),('2026-01-31 09:14:38',NULL,'2026-01-31 09:15:39',1,233,'873ab52c-6ddb-4591-95be-4fd33ed9a07f',NULL,'disk_format','qcow2'),('2026-01-31 09:14:38',NULL,'2026-01-31 09:15:39',1,234,'873ab52c-6ddb-4591-95be-4fd33ed9a07f',NULL,'min_disk','0'),('2026-01-31 09:14:38',NULL,'2026-01-31 09:15:39',1,235,'873ab52c-6ddb-4591-95be-4fd33ed9a07f',NULL,'min_ram','0'),('2026-01-31 09:14:38',NULL,'2026-01-31 09:15:39',1,236,'873ab52c-6ddb-4591-95be-4fd33ed9a07f',NULL,'size','21430272'),('2026-01-31 09:16:10',NULL,'2026-01-31 09:19:17',1,237,'16971cc6-6c7b-47eb-9656-600213b7ac4e',NULL,'signature_verified','False'),('2026-01-31 09:16:19',NULL,'2026-01-31 09:19:17',1,238,'16971cc6-6c7b-47eb-9656-600213b7ac4e',NULL,'hw_rng_model','virtio'),('2026-01-31 09:16:19',NULL,'2026-01-31 09:19:17',1,239,'16971cc6-6c7b-47eb-9656-600213b7ac4e',NULL,'image_id','7c23949f-bba8-4466-bb79-caf568852d38'),('2026-01-31 09:16:19',NULL,'2026-01-31 09:19:17',1,240,'16971cc6-6c7b-47eb-9656-600213b7ac4e',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 09:16:19',NULL,'2026-01-31 09:19:17',1,241,'16971cc6-6c7b-47eb-9656-600213b7ac4e',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 09:16:19',NULL,'2026-01-31 09:19:17',1,242,'16971cc6-6c7b-47eb-9656-600213b7ac4e',NULL,'container_format','bare'),('2026-01-31 09:16:19',NULL,'2026-01-31 09:19:17',1,243,'16971cc6-6c7b-47eb-9656-600213b7ac4e',NULL,'disk_format','qcow2'),('2026-01-31 09:16:19',NULL,'2026-01-31 09:19:17',1,244,'16971cc6-6c7b-47eb-9656-600213b7ac4e',NULL,'min_disk','0'),('2026-01-31 09:16:19',NULL,'2026-01-31 09:19:17',1,245,'16971cc6-6c7b-47eb-9656-600213b7ac4e',NULL,'min_ram','0'),('2026-01-31 09:16:19',NULL,'2026-01-31 09:19:17',1,246,'16971cc6-6c7b-47eb-9656-600213b7ac4e',NULL,'size','21430272'),('2026-01-31 09:18:12',NULL,'2026-01-31 09:19:03',1,247,NULL,'ba746e36-34fc-458c-89f2-6c51d7e7976f','signature_verified','False'),('2026-01-31 09:18:12',NULL,'2026-01-31 09:19:03',1,248,NULL,'ba746e36-34fc-458c-89f2-6c51d7e7976f','hw_rng_model','virtio'),('2026-01-31 09:18:12',NULL,'2026-01-31 09:19:03',1,249,NULL,'ba746e36-34fc-458c-89f2-6c51d7e7976f','image_id','7c23949f-bba8-4466-bb79-caf568852d38'),('2026-01-31 09:18:12',NULL,'2026-01-31 09:19:03',1,250,NULL,'ba746e36-34fc-458c-89f2-6c51d7e7976f','image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 09:18:12',NULL,'2026-01-31 09:19:03',1,251,NULL,'ba746e36-34fc-458c-89f2-6c51d7e7976f','checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 09:18:12',NULL,'2026-01-31 09:19:03',1,252,NULL,'ba746e36-34fc-458c-89f2-6c51d7e7976f','container_format','bare'),('2026-01-31 09:18:12',NULL,'2026-01-31 09:19:03',1,253,NULL,'ba746e36-34fc-458c-89f2-6c51d7e7976f','disk_format','qcow2'),('2026-01-31 09:18:12',NULL,'2026-01-31 09:19:03',1,254,NULL,'ba746e36-34fc-458c-89f2-6c51d7e7976f','min_disk','0'),('2026-01-31 09:18:12',NULL,'2026-01-31 09:19:03',1,255,NULL,'ba746e36-34fc-458c-89f2-6c51d7e7976f','min_ram','0'),('2026-01-31 09:18:12',NULL,'2026-01-31 09:19:03',1,256,NULL,'ba746e36-34fc-458c-89f2-6c51d7e7976f','size','21430272'),('2026-01-31 09:18:14',NULL,'2026-01-31 09:19:00',1,257,'b13e384a-f308-411e-add5-2e1bc75b4439',NULL,'signature_verified','False'),('2026-01-31 09:18:14',NULL,'2026-01-31 09:19:00',1,258,'b13e384a-f308-411e-add5-2e1bc75b4439',NULL,'hw_rng_model','virtio'),('2026-01-31 09:18:14',NULL,'2026-01-31 09:19:00',1,259,'b13e384a-f308-411e-add5-2e1bc75b4439',NULL,'image_id','7c23949f-bba8-4466-bb79-caf568852d38'),('2026-01-31 09:18:14',NULL,'2026-01-31 09:19:00',1,260,'b13e384a-f308-411e-add5-2e1bc75b4439',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 09:18:14',NULL,'2026-01-31 09:19:00',1,261,'b13e384a-f308-411e-add5-2e1bc75b4439',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 09:18:14',NULL,'2026-01-31 09:19:00',1,262,'b13e384a-f308-411e-add5-2e1bc75b4439',NULL,'container_format','bare'),('2026-01-31 09:18:14',NULL,'2026-01-31 09:19:00',1,263,'b13e384a-f308-411e-add5-2e1bc75b4439',NULL,'disk_format','qcow2'),('2026-01-31 09:18:14',NULL,'2026-01-31 09:19:00',1,264,'b13e384a-f308-411e-add5-2e1bc75b4439',NULL,'min_disk','0'),('2026-01-31 09:18:14',NULL,'2026-01-31 09:19:00',1,265,'b13e384a-f308-411e-add5-2e1bc75b4439',NULL,'min_ram','0'),('2026-01-31 09:18:14',NULL,'2026-01-31 09:19:00',1,266,'b13e384a-f308-411e-add5-2e1bc75b4439',NULL,'size','21430272');
/*!40000 ALTER TABLE `volume_glance_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_metadata`
--

DROP TABLE IF EXISTS `volume_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_metadata`
--

LOCK TABLES `volume_metadata` WRITE;
/*!40000 ALTER TABLE `volume_metadata` DISABLE KEYS */;
INSERT INTO `volume_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `key`, `value`) VALUES ('2026-01-31 08:32:34',NULL,'2026-01-31 08:32:38',1,1,'c9cd26af-69ac-4a85-8953-3eff06046dfa','Type','work'),('2026-01-31 08:32:51',NULL,'2026-01-31 08:33:25',1,2,'9875c61a-69aa-48ba-b497-26d09e6503db','Type','work'),('2026-01-31 08:33:04',NULL,'2026-01-31 08:33:22',1,3,'75a7d111-25de-4980-b2de-d82d3f3eb735','Type','work'),('2026-01-31 08:33:10',NULL,'2026-01-31 08:33:21',1,4,'25f00e6a-4f71-4ed0-b68a-41b925b7d747','Type','work'),('2026-01-31 08:58:31',NULL,'2026-01-31 08:59:26',1,5,'4fa6de41-50fa-4a7f-9f53-f34c852aad03','src_backup_id','69a82e51-75e6-4706-8ee3-fb74b30544df');
/*!40000 ALTER TABLE `volume_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_extra_specs`
--

DROP TABLE IF EXISTS `volume_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_extra_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_type_extra_specs_volume_type_id` (`volume_type_id`),
  CONSTRAINT `volume_type_extra_specs_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_extra_specs`
--

LOCK TABLES `volume_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `volume_type_extra_specs` DISABLE KEYS */;
INSERT INTO `volume_type_extra_specs` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_type_id`, `key`, `value`) VALUES ('2026-01-31 07:28:10',NULL,NULL,0,1,'db898b53-b4de-412a-8bc7-bb25173e9740','multiattach','<is> True');
/*!40000 ALTER TABLE `volume_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_projects`
--

DROP TABLE IF EXISTS `volume_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `volume_type_id` (`volume_type_id`,`project_id`,`deleted`),
  CONSTRAINT `volume_type_projects_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_projects`
--

LOCK TABLES `volume_type_projects` WRITE;
/*!40000 ALTER TABLE `volume_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_types`
--

DROP TABLE IF EXISTS `volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `qos_specs_id` varchar(36) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_types_qos_specs_id` (`qos_specs_id`),
  CONSTRAINT `volume_types_ibfk_1` FOREIGN KEY (`qos_specs_id`) REFERENCES `quality_of_service_specs` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_types`
--

LOCK TABLES `volume_types` WRITE;
/*!40000 ALTER TABLE `volume_types` DISABLE KEYS */;
INSERT INTO `volume_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `qos_specs_id`, `is_public`, `description`) VALUES ('2026-01-31 06:51:25','2026-01-31 06:51:25',NULL,0,'0387ec84-8d90-4723-8b28-b9ecb2113a6e','__DEFAULT__',NULL,1,'Default Volume Type'),('2026-01-31 09:11:10',NULL,'2026-01-31 09:12:10',1,'137055c9-e6a8-42c2-a995-573f153330b6','tempest-scenario-type-luks-1946719417',NULL,1,NULL),('2026-01-31 08:37:58',NULL,'2026-01-31 08:43:59',1,'36695a7f-ef38-4e87-888b-74e11ee4c18d','tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-519012021-1114870271',NULL,1,NULL),('2026-01-31 08:38:09',NULL,'2026-01-31 08:43:55',1,'5b2b2f5e-5406-4e6d-be69-58683c458f31','tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-580248439-755666519',NULL,1,NULL),('2026-01-31 08:38:09',NULL,'2026-01-31 08:43:55',1,'74d83e29-6956-4f21-a10b-49d98c7d1093','tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-350934863-1039133705',NULL,1,NULL),('2026-01-31 08:34:13',NULL,'2026-01-31 08:36:29',1,'baf04557-9b93-4186-9309-b086e77b17c8','tempest-scenario-type-luks-1109613392',NULL,1,NULL),('2026-01-31 07:28:06',NULL,NULL,0,'db898b53-b4de-412a-8bc7-bb25173e9740','multiattach',NULL,1,NULL);
/*!40000 ALTER TABLE `volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ec2_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(256) DEFAULT NULL,
  `provider_auth` varchar(256) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `source_volid` varchar(36) DEFAULT NULL,
  `bootable` tinyint(1) DEFAULT NULL,
  `provider_geometry` varchar(255) DEFAULT NULL,
  `_name_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `migration_status` varchar(255) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  `replication_extended_status` varchar(255) DEFAULT NULL,
  `replication_driver_data` varchar(255) DEFAULT NULL,
  `consistencygroup_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `multiattach` tinyint(1) DEFAULT NULL,
  `previous_status` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `group_id` varchar(36) DEFAULT NULL,
  `service_uuid` varchar(36) DEFAULT NULL,
  `shared_targets` tinyint(1) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volumes_consistencygroup_id` (`consistencygroup_id`),
  KEY `ix_volumes_group_id` (`group_id`),
  KEY `volumes_service_uuid_idx` (`service_uuid`,`deleted`),
  KEY `volumes_deleted_project_id_idx` (`deleted`,`project_id`),
  KEY `volumes_deleted_host_idx` (`deleted`,`host`),
  CONSTRAINT `volumes_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `volumes_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `volumes_ibfk_3` FOREIGN KEY (`service_uuid`) REFERENCES `services` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
INSERT INTO `volumes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `ec2_id`, `user_id`, `project_id`, `host`, `size`, `availability_zone`, `status`, `attach_status`, `scheduled_at`, `launched_at`, `terminated_at`, `display_name`, `display_description`, `provider_location`, `provider_auth`, `snapshot_id`, `volume_type_id`, `source_volid`, `bootable`, `provider_geometry`, `_name_id`, `encryption_key_id`, `migration_status`, `replication_status`, `replication_extended_status`, `replication_driver_data`, `consistencygroup_id`, `provider_id`, `multiattach`, `previous_status`, `cluster_name`, `group_id`, `service_uuid`, `shared_targets`, `use_quota`) VALUES ('2026-01-31 08:03:14','2026-01-31 08:07:12','2026-01-31 08:07:16',1,'008cf290-7941-4c64-a361-689cb2af7bcc',NULL,'31043e345f6b48b585fb7b8ab7304764','d352316ff6534075952e2d0c28061b09','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:03:14','2026-01-31 08:03:15','2026-01-31 08:07:12','tempest-ServerActionsTestOtherA-volume-162898323',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 09:12:12','2026-01-31 09:13:08','2026-01-31 09:13:11',1,'027031c1-d50c-4a4a-a95f-34197cb6ba25',NULL,'ecd39871d7fd438f88b36601f25d6eb6','98d10c0290e340a08e9d1726bf0066bf','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 09:12:13','2026-01-31 09:12:27','2026-01-31 09:13:08','tempest-TestVolumeBootPattern-volume-origin-572657218',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 07:43:52','2026-01-31 07:46:27','2026-01-31 07:46:30',1,'0820c20c-f9e4-4bf3-938f-b72587adf944',NULL,'b4865905ed4e4262a2242d3f323d4314','9ddf930129cf4e0395f8c5e70fd9eda8','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 07:43:52','2026-01-31 07:43:58','2026-01-31 07:46:27','tempest-UpdateMultiattachVolumeNegativeTest-volume-60395314',NULL,'{\"saved_features\":61}',NULL,NULL,'db898b53-b4de-412a-8bc7-bb25173e9740',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 07:39:50','2026-01-31 07:40:07','2026-01-31 07:40:10',1,'0de5a428-04b5-4163-84c5-f4e760bbda69',NULL,'7c95bb3f52804685a0ba62164a02b535','72635784cc4840bba682e8305945e795','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 07:39:51','2026-01-31 07:39:51','2026-01-31 07:40:07','tempest-AttachSCSIVolumeTestJSON-volume-675473801',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:05:14','2026-01-31 08:06:58','2026-01-31 08:07:03',1,'0eed4460-dbe8-45e7-8d1d-2c1a6334d70e',NULL,'31043e345f6b48b585fb7b8ab7304764','d352316ff6534075952e2d0c28061b09','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:05:14','2026-01-31 08:05:27','2026-01-31 08:06:58','tempest-tempest.common.compute-volume-1343908444',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 07:45:03','2026-01-31 07:49:54','2026-01-31 07:49:54',1,'111b00c1-b66c-4cba-bfe9-abb2e4396a68',NULL,'97abab8eb79247cd89fb2ebff295b890','f299640bb1f64e5fa12b23955e5a2127','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 07:45:04','2026-01-31 07:45:06','2026-01-31 07:49:54','tempest-DeleteServersTestJSON-volume-25222029',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:19:28','2026-01-31 08:21:04','2026-01-31 08:21:05',1,'124bfb1e-b91a-4179-9a6b-46ee143687ea',NULL,'7f0be9090fdf49d2ac15246a0a820d3f','134c066ac92844ff853b216870fa8eed','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:19:28','2026-01-31 08:19:29','2026-01-31 08:21:04','tempest-TestMinimumBasicScenario-volume-1449972335',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 09:16:04','2026-01-31 09:19:11','2026-01-31 09:19:17',1,'16971cc6-6c7b-47eb-9656-600213b7ac4e',NULL,'ecd39871d7fd438f88b36601f25d6eb6','98d10c0290e340a08e9d1726bf0066bf','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 09:16:04','2026-01-31 09:16:20','2026-01-31 09:19:11','tempest-TestVolumeBootPattern-volume-origin-2065453733',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 07:30:46','2026-01-31 07:32:13','2026-01-31 07:32:15',1,'1bbb8596-60ef-452c-be5b-f1b3f34acf56',NULL,'77ae480a4e8844c48c9dcde43f333250','c8eab1fe01c14c5aa74f8b1c00292fee','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 07:30:47','2026-01-31 07:30:48','2026-01-31 07:32:13','tempest-VolumesAssistedSnapshotsTest-volume-575300237',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 07:36:03','2026-01-31 07:37:11','2026-01-31 07:37:12',1,'21ac0cb5-f889-4135-9b17-5debc0b9246e',NULL,'ea44c45fe7df4f36b5c722fbfc214f2e','29d136be5e384689a95acd607131dfd0','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 07:36:03','2026-01-31 07:36:09','2026-01-31 07:37:11','tempest-tempest.common.compute-volume-656334778',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 07:41:41','2026-01-31 07:42:38','2026-01-31 07:42:43',1,'23d2de7d-d18d-40c1-8f76-18391958864a',NULL,'b873da8845e6461088fcff99c5c140b1','016f45da455049d7aad578f0a534a0f2','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 07:41:42','2026-01-31 07:41:43','2026-01-31 07:42:38','tempest-VolumesAdminNegativeTest-volume-803473173',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:29:04','2026-01-31 08:33:13','2026-01-31 08:33:17',1,'24c2ccab-1de3-49e1-8745-ab056fd86efb',NULL,'eac51187531841e2891fc5d3c5f84123','722ab2e9dd674709953be812d4c88493','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:29:04','2026-01-31 08:29:05','2026-01-31 08:33:13','tempest-ServersNegativeTestJSON-volume-1454528979',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:33:10','2026-01-31 08:33:18','2026-01-31 08:33:21',1,'25f00e6a-4f71-4ed0-b68a-41b925b7d747',NULL,'2a735f9cbf0d459896a036bb9845ef3d','92845e9c9ab24edbb2412cff577a0903','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:33:11','2026-01-31 08:33:12','2026-01-31 08:33:18','tempest-VolumesTestJSON-volume-1551461925',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:38:11','2026-01-31 08:42:16','2026-01-31 08:42:18',1,'273b2ec0-261d-40ed-887b-96124699257b',NULL,'cfc8a271e75e4a92b16ee6b5da9cfc9f','4b38141686534a0fb9b947a7886cd4b6','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:38:12','2026-01-31 08:38:12','2026-01-31 08:42:16','tempest-TestInstancesWithCinderVolumes-volume-412996320',NULL,NULL,NULL,NULL,'74d83e29-6956-4f21-a10b-49d98c7d1093',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:16:28','2026-01-31 08:19:01','2026-01-31 08:19:02',1,'28bdb463-7d0a-42f5-8392-3acd847cfe3e',NULL,'90313c82677c4144953c58efc0e13c3e','bda3ebf6541d46309fc9b2ce089dd857','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:16:28','2026-01-31 08:16:57','2026-01-31 08:19:01','tempest-tempest.common.compute-volume-2001294192',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'reserved',NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 09:11:11','2026-01-31 09:12:06','2026-01-31 09:12:09',1,'2af2ded2-cbd7-44f4-b8e4-72d974e773dd',NULL,'ecd39871d7fd438f88b36601f25d6eb6','98d10c0290e340a08e9d1726bf0066bf','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 09:11:11','2026-01-31 09:11:20','2026-01-31 09:12:06','tempest-TestVolumeBootPattern-volume-1019587099',NULL,NULL,NULL,NULL,'137055c9-e6a8-42c2-a995-573f153330b6',NULL,1,NULL,NULL,'ec92ef3b-edd6-40a0-a6ad-12d162206d8b',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:38:11','2026-01-31 08:41:09','2026-01-31 08:41:10',1,'32f698bc-fdf5-4d95-826a-13f70e60d6b8',NULL,'cfc8a271e75e4a92b16ee6b5da9cfc9f','4b38141686534a0fb9b947a7886cd4b6','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:38:11','2026-01-31 08:38:12','2026-01-31 08:41:09','tempest-TestInstancesWithCinderVolumes-volume-1513768518',NULL,NULL,NULL,NULL,'74d83e29-6956-4f21-a10b-49d98c7d1093',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:03:22','2026-01-31 08:06:08','2026-01-31 08:06:09',1,'38f98947-0572-42f2-a1bf-7adcaef6ac4c',NULL,'8ff6e8783c3f4132b787cb0653fff9b0','2327b93dd7d648efad6d2b303f9e462e','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:03:23','2026-01-31 08:03:32','2026-01-31 08:06:08','tempest-TaggedBootDevicesTest_v242-volume-1561011666',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:20:31','2026-01-31 08:22:53','2026-01-31 08:22:54',1,'3d6341af-3fa9-4df9-97f7-fed952eac1e6',NULL,'6788b0883cb348719d1222b1c9483be2','4849ff916e1b4e2aa162faaf2c0717a2','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:20:31','2026-01-31 08:20:32','2026-01-31 08:22:53','tempest-ServerRescueNegativeTestJSON-volume-507576413',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:17:11','2026-01-31 08:20:49','2026-01-31 08:20:50',1,'404c4de7-aa21-488f-9d20-6b6e4016f179',NULL,'3b153d2832404e5b9250422b70ba522d','3b06982960ad4453b8e542cb6330835d','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:17:12','2026-01-31 08:17:12','2026-01-31 08:20:49','tempest-AttachVolumeShelveTestJSON-volume-233364926',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:26:23','2026-01-31 08:31:31','2026-01-31 08:31:33',1,'4e49c5a3-4191-4757-9b9f-0465fe16a7f1',NULL,'85dfa8546d9942648bb4197c8b1947e3','48bbdbdee526499e90da7e971ede68d3','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:26:23','2026-01-31 08:26:24','2026-01-31 08:31:31','tempest-AttachVolumeMultiAttachTest-volume-346216670',NULL,'{\"saved_features\":61}',NULL,NULL,'db898b53-b4de-412a-8bc7-bb25173e9740',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:58:25','2026-01-31 08:59:21','2026-01-31 08:59:26',1,'4fa6de41-50fa-4a7f-9f53-f34c852aad03',NULL,'fe599a5134944b9fbf952e83fdf41c55','e458566e0de24b2fb797037d94d9014c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:58:25','2026-01-31 08:58:26','2026-01-31 08:59:21','tempest-TestVolumeBackupRestore-volume-572345543',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:38:15','2026-01-31 08:43:46','2026-01-31 08:43:48',1,'52013e9d-e76f-40eb-be07-4c6f98de0219',NULL,'cfc8a271e75e4a92b16ee6b5da9cfc9f','4b38141686534a0fb9b947a7886cd4b6','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:38:16','2026-01-31 08:38:26','2026-01-31 08:43:46','tempest-TestInstancesWithCinderVolumes-volume-507490364',NULL,NULL,NULL,NULL,'36695a7f-ef38-4e87-888b-74e11ee4c18d',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:30:05','2026-01-31 08:31:49','2026-01-31 08:31:59',1,'5279c0c3-4a03-4ce2-a469-4152d8ade465',NULL,'48d684de9ba340f48e249b4cce857bfa','418d5319c640455ab23850c0b0f24f92','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:30:06','2026-01-31 08:30:06','2026-01-31 08:31:49','tempest-AttachVolumeNegativeTest-volume-1684927429',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:03:32','2026-01-31 08:06:06','2026-01-31 08:06:08',1,'5839a328-04ff-4569-98df-b992860dfc6d',NULL,'8ff6e8783c3f4132b787cb0653fff9b0','2327b93dd7d648efad6d2b303f9e462e','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:03:32','2026-01-31 08:03:33','2026-01-31 08:06:06','tempest-TaggedBootDevicesTest_v242-volume-1508888230',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:22:12','2026-01-31 08:25:04','2026-01-31 08:25:07',1,'5cf392c9-4c4c-4680-9529-6ff296b6467e',NULL,'3ada90dc4b77478cb4b93c63409d8537','fdf18f1faf4846e2a6e2eab4ac2aec02','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:22:12','2026-01-31 08:22:12','2026-01-31 08:25:04','tempest-AttachVolumeTestJSON-volume-956059227',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:38:10','2026-01-31 08:41:03','2026-01-31 08:41:04',1,'5e3dddd5-2020-4bc8-ad80-973dfd3573b1',NULL,'cfc8a271e75e4a92b16ee6b5da9cfc9f','4b38141686534a0fb9b947a7886cd4b6','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:38:11','2026-01-31 08:38:11','2026-01-31 08:41:03','tempest-TestInstancesWithCinderVolumes-volume-84133880',NULL,NULL,NULL,NULL,'5b2b2f5e-5406-4e6d-be69-58683c458f31',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:38:10','2026-01-31 08:39:57','2026-01-31 08:40:01',1,'67e8063c-e5d3-4497-bf93-33d59b6a9eb4',NULL,'cfc8a271e75e4a92b16ee6b5da9cfc9f','4b38141686534a0fb9b947a7886cd4b6','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:38:10','2026-01-31 08:38:11','2026-01-31 08:39:57','tempest-TestInstancesWithCinderVolumes-volume-1962186962',NULL,NULL,NULL,NULL,'74d83e29-6956-4f21-a10b-49d98c7d1093',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:34:20','2026-01-31 08:36:24','2026-01-31 08:36:28',1,'6d2d8f34-806c-41f7-aa1a-a0cc062684f4',NULL,'eb8e3d6cd4094a62b23e39cec9023f18','149ccba7b87e4284a3a6462e3a1dace1','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:34:21','2026-01-31 08:34:35','2026-01-31 08:36:24','tempest-TestEncryptedCinderVolumes-volume-744105315',NULL,NULL,NULL,NULL,'baf04557-9b93-4186-9309-b086e77b17c8',NULL,0,NULL,NULL,'2ca6a990-a9f2-407b-95b2-5887f411722b',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:29:13','2026-01-31 08:33:07','2026-01-31 08:33:12',1,'6f54fe89-3655-420b-a04a-ff9e613e50fc',NULL,'eac51187531841e2891fc5d3c5f84123','722ab2e9dd674709953be812d4c88493','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:29:13','2026-01-31 08:29:14','2026-01-31 08:33:07','tempest-ServersNegativeTestJSON-volume-1718675297',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:00:27','2026-01-31 08:02:24','2026-01-31 08:02:25',1,'746b1dd4-a34a-454d-a628-2fc84c0145c9',NULL,'d454a4ec91e645e992f4a88ac60da747','2ab30fd72657435fb442fc59a53da644','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:00:27','2026-01-31 08:00:28','2026-01-31 08:02:24','tempest-TaggedAttachmentsTest-volume-1796411333',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:33:04','2026-01-31 08:33:21','2026-01-31 08:33:22',1,'75a7d111-25de-4980-b2de-d82d3f3eb735',NULL,'2a735f9cbf0d459896a036bb9845ef3d','92845e9c9ab24edbb2412cff577a0903','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:33:07','2026-01-31 08:33:08','2026-01-31 08:33:21','tempest-VolumesTestJSON-volume-1082386882',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:03:34','2026-01-31 08:06:05','2026-01-31 08:06:06',1,'799c0e3e-5252-4646-befe-0999c33cc481',NULL,'8ff6e8783c3f4132b787cb0653fff9b0','2327b93dd7d648efad6d2b303f9e462e','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:03:34','2026-01-31 08:03:34','2026-01-31 08:06:05','tempest-TaggedBootDevicesTest_v242-volume-919012069',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 07:32:49','2026-01-31 07:34:08','2026-01-31 07:34:09',1,'802e207e-cc7b-4779-89dc-d399ba68dc38',NULL,'0a59df5da6284e4e8764816e1f8dfaa3','dfb4d4079ac944b288d5e285ce1de95a','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 07:32:49','2026-01-31 07:33:07','2026-01-31 07:34:08','tempest-tempest.common.compute-volume-1010675242',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:31:20','2026-01-31 08:31:45','2026-01-31 08:31:47',1,'85d89a65-6e1e-4b74-97bb-e5082330369c',NULL,'48d684de9ba340f48e249b4cce857bfa','418d5319c640455ab23850c0b0f24f92','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:31:21','2026-01-31 08:31:22','2026-01-31 08:31:45','tempest-AttachVolumeNegativeTest-volume-858223898',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 09:14:37','2026-01-31 09:15:35','2026-01-31 09:15:39',1,'873ab52c-6ddb-4591-95be-4fd33ed9a07f',NULL,'ecd39871d7fd438f88b36601f25d6eb6','98d10c0290e340a08e9d1726bf0066bf','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 09:14:38','2026-01-31 09:14:38','2026-01-31 09:15:35','','',NULL,NULL,'19cd7d76-1c46-4377-b72d-ef79e4149d09','0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:38:17','2026-01-31 08:43:44','2026-01-31 08:43:46',1,'937c2f7d-b961-4dec-b1ad-34dd4c2d4cac',NULL,'cfc8a271e75e4a92b16ee6b5da9cfc9f','4b38141686534a0fb9b947a7886cd4b6','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:38:18','2026-01-31 08:38:29','2026-01-31 08:43:44','tempest-TestInstancesWithCinderVolumes-volume-337227836',NULL,NULL,NULL,NULL,'36695a7f-ef38-4e87-888b-74e11ee4c18d',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:38:14','2026-01-31 08:43:48','2026-01-31 08:43:49',1,'98644432-f138-4ffa-ac72-90128df20205',NULL,'cfc8a271e75e4a92b16ee6b5da9cfc9f','4b38141686534a0fb9b947a7886cd4b6','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:38:14','2026-01-31 08:38:26','2026-01-31 08:43:48','tempest-TestInstancesWithCinderVolumes-volume-861164866',NULL,NULL,NULL,NULL,'36695a7f-ef38-4e87-888b-74e11ee4c18d',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:32:51','2026-01-31 08:33:23','2026-01-31 08:33:25',1,'9875c61a-69aa-48ba-b497-26d09e6503db',NULL,'2a735f9cbf0d459896a036bb9845ef3d','92845e9c9ab24edbb2412cff577a0903','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:32:53','2026-01-31 08:33:02','2026-01-31 08:33:23','tempest-VolumesTestJSON-volume-2056294402',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:21:25','2026-01-31 08:24:55',NULL,0,'9963309d-4585-4a8d-8bdf-00f8aa2f69e1',NULL,'038e2b3b4f174162a3ac6c4870857e60','c90ea7f1be5f484bb873548236fadc00','hostgroup@ceph#ceph',1,'nova','available','detached','2026-01-31 08:21:25','2026-01-31 08:21:26',NULL,'946cb648-0758-4617-bd3a-142804fd70f7-blank-vol','',NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 07:50:43','2026-01-31 07:53:17','2026-01-31 07:53:18',1,'9b441e8b-6bb5-4554-9b00-62c0672ca9cf',NULL,'eb0d7106e4b04ac980748beb40d5cedf','3264618ebdfa4478919141d5d3c4d3b3','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 07:50:43','2026-01-31 07:50:43','2026-01-31 07:53:17','tempest-TaggedBootDevicesTest-volume-269017764',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:20:52','2026-01-31 08:22:52','2026-01-31 08:22:52',1,'9e7640b2-419e-4d50-9b23-7d76e34131d8',NULL,'6788b0883cb348719d1222b1c9483be2','4849ff916e1b4e2aa162faaf2c0717a2','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:20:52','2026-01-31 08:20:53','2026-01-31 08:22:52','tempest-ServerRescueNegativeTestJSON-volume-671147707',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:21:34','2026-01-31 08:22:39','2026-01-31 08:22:42',1,'9e79b760-3e32-4b0f-9644-d12b3e5189ad',NULL,'7f0be9090fdf49d2ac15246a0a820d3f','134c066ac92844ff853b216870fa8eed','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:21:34','2026-01-31 08:21:34','2026-01-31 08:22:39','tempest-TestMinimumBasicScenario-volume-1941280606',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:53:57','2026-01-31 08:56:37','2026-01-31 08:56:43',1,'9ef5b6cb-4a21-4534-a367-ffc4848e8857',NULL,'a798fdf6d13d4af4b166dd94b5cea7cc','e6e96de7b2784be1adce763bc9c9adc5','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:53:58','2026-01-31 08:53:59','2026-01-31 08:56:37','tempest-TestStampPattern-volume-916471123',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 07:42:26','2026-01-31 07:42:28','2026-01-31 07:42:29',1,'9fbf8666-c3ea-4612-a72e-27a4ba7bd983',NULL,'b873da8845e6461088fcff99c5c140b1','016f45da455049d7aad578f0a534a0f2','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 07:42:27','2026-01-31 07:42:27','2026-01-31 07:42:28','tempest-VolumesAdminNegativeTest-volume-1147762085',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 07:52:07','2026-01-31 07:53:16','2026-01-31 07:53:19',1,'a1b4a963-bab3-4e88-b617-96814bf6094a',NULL,'93403129e78e44f3916d321433a31bd2','4a9ee1af66824e368ddad5ea68a3201b','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 07:52:12','2026-01-31 07:52:31','2026-01-31 07:53:16','tempest-tempest.common.compute-volume-1722181320',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 07:50:32','2026-01-31 07:53:21','2026-01-31 07:53:22',1,'a8fc40ce-92f5-4848-b108-e10dbbb71633',NULL,'eb0d7106e4b04ac980748beb40d5cedf','3264618ebdfa4478919141d5d3c4d3b3','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 07:50:32','2026-01-31 07:50:41','2026-01-31 07:53:21','tempest-TaggedBootDevicesTest-volume-1753702144',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:24:31','2026-01-31 08:32:09','2026-01-31 08:32:17',1,'aa9253f0-3405-4d95-ab32-e423b297e3e5',NULL,'85dfa8546d9942648bb4197c8b1947e3','48bbdbdee526499e90da7e971ede68d3','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:24:31','2026-01-31 08:24:40','2026-01-31 08:32:09','tempest-AttachVolumeMultiAttachTest-volume-285600335',NULL,'{\"saved_features\":61}',NULL,NULL,'db898b53-b4de-412a-8bc7-bb25173e9740',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 09:18:13','2026-01-31 09:18:59','2026-01-31 09:19:00',1,'b13e384a-f308-411e-add5-2e1bc75b4439',NULL,'ecd39871d7fd438f88b36601f25d6eb6','98d10c0290e340a08e9d1726bf0066bf','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 09:18:13','2026-01-31 09:18:14','2026-01-31 09:18:59','tempest-TestVolumeBootPattern-volume-1916713974',NULL,NULL,NULL,'ba746e36-34fc-458c-89f2-6c51d7e7976f','0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:23:45','2026-01-31 08:24:42',NULL,0,'bb6c3a76-a1e4-4bd7-8526-2c74f412b508',NULL,'038e2b3b4f174162a3ac6c4870857e60','c90ea7f1be5f484bb873548236fadc00','hostgroup@ceph#ceph',1,'nova','available','detached','2026-01-31 08:23:45','2026-01-31 08:23:57',NULL,'','',NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:38:10','2026-01-31 08:39:49','2026-01-31 08:39:51',1,'be0b3094-6fbc-448a-804b-4a365824d522',NULL,'cfc8a271e75e4a92b16ee6b5da9cfc9f','4b38141686534a0fb9b947a7886cd4b6','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:38:10','2026-01-31 08:38:10','2026-01-31 08:39:49','tempest-TestInstancesWithCinderVolumes-volume-1123040128',NULL,NULL,NULL,NULL,'5b2b2f5e-5406-4e6d-be69-58683c458f31',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 09:13:14','2026-01-31 09:15:46','2026-01-31 09:15:47',1,'bef842a0-76ba-4e96-aba4-abce4554dd0c',NULL,'ecd39871d7fd438f88b36601f25d6eb6','98d10c0290e340a08e9d1726bf0066bf','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 09:13:14','2026-01-31 09:13:25','2026-01-31 09:15:46','tempest-TestVolumeBootPattern-volume-origin-1233931759',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:27:32','2026-01-31 08:30:56','2026-01-31 08:31:04',1,'c66e3c0d-56c2-4ac0-89fe-027a1e7afcf4',NULL,'85dfa8546d9942648bb4197c8b1947e3','48bbdbdee526499e90da7e971ede68d3','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:27:32','2026-01-31 08:27:33','2026-01-31 08:30:56','tempest-AttachVolumeMultiAttachTest-volume-686896347',NULL,'{\"saved_features\":61}',NULL,NULL,'db898b53-b4de-412a-8bc7-bb25173e9740',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:19:33','2026-01-31 08:20:47','2026-01-31 08:20:48',1,'c689a81c-bd37-441d-bd9d-94305c3032f6',NULL,'3b153d2832404e5b9250422b70ba522d','3b06982960ad4453b8e542cb6330835d','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:19:33','2026-01-31 08:19:33','2026-01-31 08:20:47','tempest-AttachVolumeShelveTestJSON-volume-1805143284',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:24:34','2026-01-31 08:25:01','2026-01-31 08:25:03',1,'c7efb5e6-4cbc-4621-8f4f-a1a945d0bb8c',NULL,'3ada90dc4b77478cb4b93c63409d8537','fdf18f1faf4846e2a6e2eab4ac2aec02','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:24:34','2026-01-31 08:24:34','2026-01-31 08:25:01','tempest-AttachVolumeTestJSON-volume-957105882',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:32:34','2026-01-31 08:32:36','2026-01-31 08:32:38',1,'c9cd26af-69ac-4a85-8953-3eff06046dfa',NULL,'85c39e9c52d84f4185c0afab0f3fb734','b71e7a1d6f714f7680acaa04670308f6','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:32:34','2026-01-31 08:32:35','2026-01-31 08:32:36','tempest-VolumesGetTestJSON-Volume-349164538',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:29:52','2026-01-31 08:30:46','2026-01-31 08:30:51',1,'cb325f0f-dc0c-4601-836f-df0aeb8cb723',NULL,'85dfa8546d9942648bb4197c8b1947e3','48bbdbdee526499e90da7e971ede68d3','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:29:53','2026-01-31 08:30:05','2026-01-31 08:30:46','tempest-AttachVolumeMultiAttachTest-volume-363123314',NULL,'{\"saved_features\":61}',NULL,NULL,'db898b53-b4de-412a-8bc7-bb25173e9740',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 09:08:09','2026-01-31 09:09:53','2026-01-31 09:09:54',1,'cf361715-504e-40e5-87bf-5f49366009aa',NULL,'4883c0d4a7f54a6898eba5bfdbb41266','496e06c7521f45c994e6426c4313acea','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 09:08:09','2026-01-31 09:08:16','2026-01-31 09:09:53','tempest-tempest.common.compute-volume-690736671',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 07:43:47','2026-01-31 07:46:31','2026-01-31 07:46:36',1,'d1aca578-ec32-4cbf-a124-22c55e831394',NULL,'b4865905ed4e4262a2242d3f323d4314','9ddf930129cf4e0395f8c5e70fd9eda8','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 07:43:48','2026-01-31 07:43:51','2026-01-31 07:46:31','tempest-UpdateMultiattachVolumeNegativeTest-volume-2040585812',NULL,'{\"saved_features\":61}',NULL,NULL,'db898b53-b4de-412a-8bc7-bb25173e9740',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:27:07','2026-01-31 08:32:02','2026-01-31 08:32:05',1,'d1f290e7-6438-4a38-9b76-cefa7f5a6025',NULL,'48d684de9ba340f48e249b4cce857bfa','418d5319c640455ab23850c0b0f24f92','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:27:08','2026-01-31 08:27:08','2026-01-31 08:32:02','tempest-AttachVolumeNegativeTest-volume-1158121275',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:18:09','2026-01-31 08:18:19','2026-01-31 08:18:20',1,'d29f163b-986a-4747-b432-83f1e4f3b968',NULL,'8c6601bfb5e74d24897f5c67e7765ffe','b2f8be0146584893ac5b769dff931958','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:18:09','2026-01-31 08:18:10','2026-01-31 08:18:19','tempest-VolumesSnapshotsTestJSON-volume-768494143',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 09:12:40','2026-01-31 09:13:00','2026-01-31 09:13:04',1,'d574299e-ff71-4c51-9235-0d741f4c633c',NULL,'ecd39871d7fd438f88b36601f25d6eb6','98d10c0290e340a08e9d1726bf0066bf','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 09:12:40','2026-01-31 09:12:41','2026-01-31 09:13:00','','',NULL,NULL,'3d93d6e9-0ee1-4a3d-9ffd-2035ed6de999','0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:54:59','2026-01-31 08:56:21','2026-01-31 08:56:23',1,'da113752-340c-4a7b-98c3-707e5c3c2d4b',NULL,'a798fdf6d13d4af4b166dd94b5cea7cc','e6e96de7b2784be1adce763bc9c9adc5','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:55:00','2026-01-31 08:55:01','2026-01-31 08:56:21','tempest-TestStampPattern-volume-1895172154',NULL,NULL,NULL,'f7b92810-f6c7-4b0e-ae3e-0828d5334595','0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:15:17','2026-01-31 08:18:13','2026-01-31 08:18:16',1,'ddc44c03-3580-457e-b1d4-9a35d3c393e8',NULL,'d7d9a44201d548aba1e1654e136ddd06','1633c84ea1bf46b080aaafd30bbcf25f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:15:18','2026-01-31 08:15:18','2026-01-31 08:18:13','tempest-ServerStableDeviceRescueTest-volume-1736572451',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:24:39','2026-01-31 08:24:59','2026-01-31 08:25:00',1,'e0ddd33b-2a84-4319-a509-f1419e80aa70',NULL,'3ada90dc4b77478cb4b93c63409d8537','fdf18f1faf4846e2a6e2eab4ac2aec02','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:24:40','2026-01-31 08:24:40','2026-01-31 08:24:59','tempest-AttachVolumeTestJSON-volume-1309549350',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:11:11','2026-01-31 08:15:45','2026-01-31 08:15:46',1,'eba44545-2378-4cdd-bfad-f9f0d9c730c0',NULL,'18aee9d81d404f77ac81cde538f140d8','c3ddadeb950a490db5c99da98a32c9ec','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:11:12','2026-01-31 08:11:12','2026-01-31 08:15:45','tempest-ServerActionsTestOtherB-volume-1465272483',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:58:04','2026-01-31 08:59:26','2026-01-31 08:59:28',1,'f0449ef7-c417-44d1-9add-b0929b3d95af',NULL,'fe599a5134944b9fbf952e83fdf41c55','e458566e0de24b2fb797037d94d9014c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:58:04','2026-01-31 08:58:15','2026-01-31 08:59:26','tempest-TestVolumeBackupRestore-volume-572345543',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 08:38:11','2026-01-31 08:42:09','2026-01-31 08:42:10',1,'f0bb0c0d-db6f-42f3-aad1-86e70cc695a6',NULL,'cfc8a271e75e4a92b16ee6b5da9cfc9f','4b38141686534a0fb9b947a7886cd4b6','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:38:11','2026-01-31 08:38:12','2026-01-31 08:42:09','tempest-TestInstancesWithCinderVolumes-volume-124032153',NULL,NULL,NULL,NULL,'5b2b2f5e-5406-4e6d-be69-58683c458f31',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1),('2026-01-31 07:50:41','2026-01-31 07:53:18','2026-01-31 07:53:21',1,'f4f1465d-4b57-44df-8e66-548b09052627',NULL,'eb0d7106e4b04ac980748beb40d5cedf','3264618ebdfa4478919141d5d3c4d3b3','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 07:50:41','2026-01-31 07:50:42','2026-01-31 07:53:18','tempest-TaggedBootDevicesTest-volume-1859801206',NULL,NULL,NULL,NULL,'0387ec84-8d90-4723-8b28-b9ecb2113a6e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'36488391-fd26-4f4f-b73b-14ce1ad5af54',0,1);
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workers`
--

DROP TABLE IF EXISTS `workers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `workers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(40) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  `status` varchar(255) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_type` (`resource_type`,`resource_id`),
  KEY `ix_workers_service_id` (`service_id`),
  CONSTRAINT `workers_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=145 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workers`
--

LOCK TABLES `workers` WRITE;
/*!40000 ALTER TABLE `workers` DISABLE KEYS */;
INSERT INTO `workers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `resource_type`, `resource_id`, `status`, `service_id`, `race_preventer`) VALUES ('2026-01-31 06:51:25','2026-01-31 06:51:25.000123',NULL,0,1,'SENTINEL','SUB-SECOND','OK',NULL,0);
/*!40000 ALTER TABLE `workers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `glance`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `glance` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `glance`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('2023_1_contract01');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_locations`
--

DROP TABLE IF EXISTS `image_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `meta_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `ix_image_locations_deleted` (`deleted`),
  KEY `ix_image_locations_image_id` (`image_id`),
  CONSTRAINT `image_locations_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_locations`
--

LOCK TABLES `image_locations` WRITE;
/*!40000 ALTER TABLE `image_locations` DISABLE KEYS */;
INSERT INTO `image_locations` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `meta_data`, `status`) VALUES (1,'7c23949f-bba8-4466-bb79-caf568852d38','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/7c23949f-bba8-4466-bb79-caf568852d38/snap','2026-01-31 07:29:33','2026-01-31 07:29:33',NULL,0,'{\"store\": \"default_backend\"}','active'),(2,'40cf2ff3-f7ff-4843-b4ab-b7dcc843006f','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/40cf2ff3-f7ff-4843-b4ab-b7dcc843006f/snap','2026-01-31 07:29:39','2026-01-31 07:29:39',NULL,0,'{\"store\": \"default_backend\"}','active'),(3,'ead592bd-b181-468e-8645-8b0745b2d7d2','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/ead592bd-b181-468e-8645-8b0745b2d7d2/snap','2026-01-31 07:37:19','2026-01-31 07:37:24','2026-01-31 07:37:24',1,'{\"store\": \"default_backend\"}','deleted'),(4,'e939cee4-d39b-49b2-a849-509ee7169ea6','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/e939cee4-d39b-49b2-a849-509ee7169ea6/snap','2026-01-31 07:38:21','2026-01-31 07:38:24','2026-01-31 07:38:24',1,'{\"store\": \"default_backend\"}','deleted'),(5,'6e711352-ba7c-4c7d-858b-ee38dcbc90e8','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/6e711352-ba7c-4c7d-858b-ee38dcbc90e8/snap','2026-01-31 07:38:50','2026-01-31 07:40:07','2026-01-31 07:40:07',1,'{\"store\": \"default_backend\"}','deleted'),(6,'627417b9-a501-49db-939e-bae37ed6ee98','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/627417b9-a501-49db-939e-bae37ed6ee98/snap','2026-01-31 07:39:19','2026-01-31 07:39:29','2026-01-31 07:39:29',1,'{\"store\": \"default_backend\"}','deleted'),(7,'4cb863eb-873b-4a83-aef8-5fea8d796cf2','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/4cb863eb-873b-4a83-aef8-5fea8d796cf2/snap','2026-01-31 07:39:30','2026-01-31 07:39:34','2026-01-31 07:39:34',1,'{\"store\": \"default_backend\"}','deleted'),(8,'eec3485d-bba1-4018-9e35-7f9f59c9e839','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/eec3485d-bba1-4018-9e35-7f9f59c9e839/snap','2026-01-31 07:39:46','2026-01-31 07:39:50','2026-01-31 07:39:50',1,'{\"store\": \"default_backend\"}','deleted'),(9,'19e1c9c2-3ea0-4549-b950-2d6bc24c2405','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/19e1c9c2-3ea0-4549-b950-2d6bc24c2405/snap','2026-01-31 07:39:59','2026-01-31 07:40:03','2026-01-31 07:40:03',1,'{\"store\": \"default_backend\"}','deleted'),(10,'1c1b7167-294e-43fd-b811-31bea4078f3d','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/1c1b7167-294e-43fd-b811-31bea4078f3d/snap','2026-01-31 07:40:25','2026-01-31 07:41:03','2026-01-31 07:41:03',1,'{\"store\": \"default_backend\"}','deleted'),(11,'41472c33-f8e9-4285-8ebd-4297b1fe1775','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/41472c33-f8e9-4285-8ebd-4297b1fe1775/snap','2026-01-31 07:41:14','2026-01-31 07:41:32','2026-01-31 07:41:32',1,'{\"store\": \"default_backend\"}','deleted'),(12,'0b8514e3-4251-4bd6-a806-b742c737781f','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/0b8514e3-4251-4bd6-a806-b742c737781f/snap','2026-01-31 07:42:07','2026-01-31 07:42:34','2026-01-31 07:42:34',1,'{\"store\": \"default_backend\"}','deleted'),(13,'ad1ed4e3-2333-4ea6-adf4-7e4aad3fefe3','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/ad1ed4e3-2333-4ea6-adf4-7e4aad3fefe3/snap','2026-01-31 07:47:00','2026-01-31 07:48:57','2026-01-31 07:48:57',1,'{\"store\": \"default_backend\"}','deleted'),(14,'099d2e45-4409-4b4d-b402-9a886f0c164b','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/099d2e45-4409-4b4d-b402-9a886f0c164b/snap','2026-01-31 07:47:05','2026-01-31 07:48:53','2026-01-31 07:48:53',1,'{\"store\": \"default_backend\"}','deleted'),(15,'b009eb64-1e75-45c8-99c5-fb9d2b66fdcb','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/b009eb64-1e75-45c8-99c5-fb9d2b66fdcb/snap','2026-01-31 07:47:07','2026-01-31 07:47:23','2026-01-31 07:47:23',1,'{\"store\": \"default_backend\"}','deleted'),(16,'c14ad43b-58f4-4ef0-a2f4-0d06b8e83718','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/c14ad43b-58f4-4ef0-a2f4-0d06b8e83718/snap','2026-01-31 07:47:09','2026-01-31 07:48:51','2026-01-31 07:48:51',1,'{\"store\": \"default_backend\"}','deleted'),(17,'32133469-37ac-412d-b940-c908b55cf858','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/32133469-37ac-412d-b940-c908b55cf858/snap','2026-01-31 07:47:46','2026-01-31 07:48:33','2026-01-31 07:48:33',1,'{\"store\": \"default_backend\"}','deleted'),(18,'2afd45fd-a049-4e1d-819a-36a36d22f6a2','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/2afd45fd-a049-4e1d-819a-36a36d22f6a2/snap','2026-01-31 07:47:58','2026-01-31 07:48:30','2026-01-31 07:48:30',1,'{\"store\": \"default_backend\"}','deleted'),(19,'ba20a523-9c85-4f5a-958b-3ab7efcbb3ba','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/ba20a523-9c85-4f5a-958b-3ab7efcbb3ba/snap','2026-01-31 07:48:12','2026-01-31 07:48:26','2026-01-31 07:48:26',1,'{\"store\": \"default_backend\"}','deleted'),(20,'3456c8a1-e00b-403c-938b-5db22092f19b','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/3456c8a1-e00b-403c-938b-5db22092f19b/snap','2026-01-31 07:49:03','2026-01-31 07:49:24','2026-01-31 07:49:24',1,'{\"store\": \"default_backend\"}','deleted'),(21,'94599989-66dd-45c0-95bf-4799dd46478c','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/94599989-66dd-45c0-95bf-4799dd46478c/snap','2026-01-31 08:08:01','2026-01-31 08:08:23','2026-01-31 08:08:23',1,'{\"store\": \"default_backend\"}','deleted'),(22,'c4db27fa-394f-44cc-aad2-82f8c71ac7b7','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/c4db27fa-394f-44cc-aad2-82f8c71ac7b7/snap','2026-01-31 08:08:12','2026-01-31 08:08:39','2026-01-31 08:08:39',1,'{\"store\": \"default_backend\"}','deleted'),(23,'29ae106c-3bc3-4dca-bd69-8cd8e500fc3f','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/29ae106c-3bc3-4dca-bd69-8cd8e500fc3f/snap','2026-01-31 08:08:21','2026-01-31 08:08:30','2026-01-31 08:08:30',1,'{\"store\": \"default_backend\"}','deleted'),(24,'7a74ff6f-b876-4da2-8910-2a6929d0fcbc','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/7a74ff6f-b876-4da2-8910-2a6929d0fcbc/snap','2026-01-31 08:11:33','2026-01-31 08:18:45','2026-01-31 08:18:45',1,'{\"store\": \"default_backend\"}','deleted'),(25,'ae58104d-ec03-4878-8203-221e83ac3a09','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/ae58104d-ec03-4878-8203-221e83ac3a09/snap','2026-01-31 08:12:44','2026-01-31 08:18:33','2026-01-31 08:18:33',1,'{\"store\": \"default_backend\"}','deleted'),(26,'5df2a010-0131-4bd4-8096-45b6ac756af0','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/5df2a010-0131-4bd4-8096-45b6ac756af0/snap','2026-01-31 08:14:26','2026-01-31 08:18:20','2026-01-31 08:18:20',1,'{\"store\": \"default_backend\"}','deleted'),(27,'d7589e47-590e-4196-b561-0595216f339a','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/d7589e47-590e-4196-b561-0595216f339a/snap','2026-01-31 08:14:29','2026-01-31 08:15:36','2026-01-31 08:15:36',1,'{\"store\": \"default_backend\"}','deleted'),(28,'70966e79-230e-420e-aa68-b04da70a01e2','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/70966e79-230e-420e-aa68-b04da70a01e2/snap','2026-01-31 08:14:53','2026-01-31 08:15:29','2026-01-31 08:15:29',1,'{\"store\": \"default_backend\"}','deleted'),(29,'2ca7a053-cec0-4d6e-8cfb-6697bc58e21c','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/2ca7a053-cec0-4d6e-8cfb-6697bc58e21c/snap','2026-01-31 08:16:29','2026-01-31 08:18:02','2026-01-31 08:18:02',1,'{\"store\": \"default_backend\"}','deleted'),(30,'9d458b54-ba05-4df1-8123-8bec7fac57ca','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/9d458b54-ba05-4df1-8123-8bec7fac57ca/snap','2026-01-31 08:17:27','2026-01-31 08:18:03','2026-01-31 08:18:03',1,'{\"store\": \"default_backend\"}','deleted'),(31,'f053e722-a943-4ece-ad77-a071fe4c9f59','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/f053e722-a943-4ece-ad77-a071fe4c9f59/snap','2026-01-31 08:19:03','2026-01-31 08:21:12','2026-01-31 08:21:12',1,'{\"store\": \"default_backend\"}','deleted'),(32,'5b5ac3f7-b093-4152-83a1-6cb8fa870d17','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/5b5ac3f7-b093-4152-83a1-6cb8fa870d17/snap','2026-01-31 08:19:51','2026-01-31 08:20:21','2026-01-31 08:20:21',1,'{\"store\": \"default_backend\"}','deleted'),(33,'1a3bb6f8-bfef-4edf-a7ea-1489b5cad196','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/1a3bb6f8-bfef-4edf-a7ea-1489b5cad196/snap','2026-01-31 08:21:14','2026-01-31 08:22:53','2026-01-31 08:22:53',1,'{\"store\": \"default_backend\"}','deleted'),(34,'af02be56-bd6f-4200-837f-ea1f7e8d93ec','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/af02be56-bd6f-4200-837f-ea1f7e8d93ec/snap','2026-01-31 08:21:17','2026-01-31 08:24:59','2026-01-31 08:24:59',1,'{\"store\": \"default_backend\"}','deleted'),(35,'9a73b720-4ab7-4126-8c93-bff12492db80','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/9a73b720-4ab7-4126-8c93-bff12492db80/snap','2026-01-31 08:23:34','2026-01-31 08:24:46','2026-01-31 08:24:46',1,'{\"store\": \"default_backend\"}','deleted'),(36,'d0c05f70-473f-4406-999b-251a35bed209','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/d0c05f70-473f-4406-999b-251a35bed209/snap','2026-01-31 08:30:33','2026-01-31 08:30:55','2026-01-31 08:30:55',1,'{\"store\": \"default_backend\"}','deleted'),(37,'1ba15ea8-5b3a-4a00-83dd-a3e208812118','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/1ba15ea8-5b3a-4a00-83dd-a3e208812118/snap','2026-01-31 08:31:06','2026-01-31 08:31:58','2026-01-31 08:31:58',1,'{\"store\": \"default_backend\"}','deleted'),(38,'5c110bb6-9d02-475d-ac34-1ec891f50aba','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/5c110bb6-9d02-475d-ac34-1ec891f50aba/snap','2026-01-31 08:38:08','2026-01-31 08:43:58','2026-01-31 08:43:58',1,'{\"store\": \"default_backend\"}','deleted'),(39,'e29674ab-eaa7-4f25-a795-4373e5f5c4e8','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/e29674ab-eaa7-4f25-a795-4373e5f5c4e8/snap','2026-01-31 08:52:50','2026-01-31 08:54:02','2026-01-31 08:54:02',1,'{\"store\": \"default_backend\"}','deleted'),(40,'27f20f89-310d-4b9a-9cbf-b30cb0f65051','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/27f20f89-310d-4b9a-9cbf-b30cb0f65051/snap','2026-01-31 08:53:47','2026-01-31 08:53:49','2026-01-31 08:53:49',1,'{\"store\": \"default_backend\"}','deleted'),(41,'6827763f-c9c4-43fc-825d-2f9c946c4536','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/6827763f-c9c4-43fc-825d-2f9c946c4536/snap','2026-01-31 08:54:59','2026-01-31 08:56:24','2026-01-31 08:56:24',1,'{\"store\": \"default_backend\"}','deleted'),(42,'f336042a-a032-4a9a-8976-bb911c951591','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/f336042a-a032-4a9a-8976-bb911c951591/snap','2026-01-31 09:07:11','2026-01-31 09:07:30','2026-01-31 09:07:30',1,'{\"store\": \"default_backend\"}','deleted'),(43,'3235f05a-670b-496a-a8b6-5b3e82346d62','rbd://f70fcd2a-dcb4-5f89-a4ba-79a09959083b/images/3235f05a-670b-496a-a8b6-5b3e82346d62/snap','2026-01-31 09:14:27','2026-01-31 09:15:56','2026-01-31 09:15:56',1,'{\"store\": \"default_backend\"}','deleted');
/*!40000 ALTER TABLE `image_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_members`
--

DROP TABLE IF EXISTS `image_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `member` varchar(255) NOT NULL,
  `can_share` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image_members_image_id_member_deleted_at_key` (`image_id`,`member`,`deleted_at`),
  KEY `ix_image_members_deleted` (`deleted`),
  KEY `ix_image_members_image_id` (`image_id`),
  KEY `ix_image_members_image_id_member` (`image_id`,`member`),
  CONSTRAINT `image_members_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`can_share` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_members`
--

LOCK TABLES `image_members` WRITE;
/*!40000 ALTER TABLE `image_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_properties`
--

DROP TABLE IF EXISTS `image_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_image_properties_image_id_name` (`image_id`,`name`),
  KEY `ix_image_properties_deleted` (`deleted`),
  KEY `ix_image_properties_image_id` (`image_id`),
  CONSTRAINT `image_properties_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=661 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_properties`
--

LOCK TABLES `image_properties` WRITE;
/*!40000 ALTER TABLE `image_properties` DISABLE KEYS */;
INSERT INTO `image_properties` (`id`, `image_id`, `name`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'7c23949f-bba8-4466-bb79-caf568852d38','hw_rng_model','virtio','2026-01-31 07:29:26','2026-01-31 07:29:26',NULL,0),(2,'40cf2ff3-f7ff-4843-b4ab-b7dcc843006f','hw_rng_model','virtio','2026-01-31 07:29:34','2026-01-31 07:29:34',NULL,0),(3,'e939cee4-d39b-49b2-a849-509ee7169ea6','hw_rng_model','virtio','2026-01-31 07:38:14','2026-01-31 07:38:24','2026-01-31 07:38:24',1),(4,'e939cee4-d39b-49b2-a849-509ee7169ea6','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 07:38:14','2026-01-31 07:38:24','2026-01-31 07:38:24',1),(5,'e939cee4-d39b-49b2-a849-509ee7169ea6','owner_user_name','tempest-ImagesTestJSON-533495031-project-member','2026-01-31 07:38:14','2026-01-31 07:38:24','2026-01-31 07:38:24',1),(6,'e939cee4-d39b-49b2-a849-509ee7169ea6','owner_project_name','tempest-ImagesTestJSON-533495031','2026-01-31 07:38:14','2026-01-31 07:38:24','2026-01-31 07:38:24',1),(7,'e939cee4-d39b-49b2-a849-509ee7169ea6','boot_roles','reader,member','2026-01-31 07:38:14','2026-01-31 07:38:24','2026-01-31 07:38:24',1),(8,'e939cee4-d39b-49b2-a849-509ee7169ea6','hw_machine_type','q35','2026-01-31 07:38:14','2026-01-31 07:38:24','2026-01-31 07:38:24',1),(9,'e939cee4-d39b-49b2-a849-509ee7169ea6','hw_cdrom_bus','sata','2026-01-31 07:38:14','2026-01-31 07:38:24','2026-01-31 07:38:24',1),(10,'e939cee4-d39b-49b2-a849-509ee7169ea6','hw_disk_bus','virtio','2026-01-31 07:38:14','2026-01-31 07:38:24','2026-01-31 07:38:24',1),(11,'e939cee4-d39b-49b2-a849-509ee7169ea6','hw_input_bus','usb','2026-01-31 07:38:14','2026-01-31 07:38:24','2026-01-31 07:38:24',1),(12,'e939cee4-d39b-49b2-a849-509ee7169ea6','hw_pointer_model','usbtablet','2026-01-31 07:38:14','2026-01-31 07:38:24','2026-01-31 07:38:24',1),(13,'e939cee4-d39b-49b2-a849-509ee7169ea6','hw_video_model','virtio','2026-01-31 07:38:14','2026-01-31 07:38:24','2026-01-31 07:38:24',1),(14,'e939cee4-d39b-49b2-a849-509ee7169ea6','hw_vif_model','virtio','2026-01-31 07:38:14','2026-01-31 07:38:24','2026-01-31 07:38:24',1),(15,'e939cee4-d39b-49b2-a849-509ee7169ea6','instance_uuid','c9aecf4d-ed14-40d4-9751-902d85959701','2026-01-31 07:38:14','2026-01-31 07:38:24','2026-01-31 07:38:24',1),(16,'e939cee4-d39b-49b2-a849-509ee7169ea6','user_id','533eaca1e9c4430dabe2b0a39039ca65','2026-01-31 07:38:14','2026-01-31 07:38:24','2026-01-31 07:38:24',1),(17,'e939cee4-d39b-49b2-a849-509ee7169ea6','image_type','snapshot','2026-01-31 07:38:14','2026-01-31 07:38:24','2026-01-31 07:38:24',1),(18,'e939cee4-d39b-49b2-a849-509ee7169ea6','image_location','snapshot','2026-01-31 07:38:20','2026-01-31 07:38:24','2026-01-31 07:38:24',1),(19,'e939cee4-d39b-49b2-a849-509ee7169ea6','owner_id','b3e3e6f216d24c1f9f68777cfb63dbf8','2026-01-31 07:38:20','2026-01-31 07:38:24','2026-01-31 07:38:24',1),(20,'e939cee4-d39b-49b2-a849-509ee7169ea6','image_state','available','2026-01-31 07:38:20','2026-01-31 07:38:24','2026-01-31 07:38:24',1),(21,'6e711352-ba7c-4c7d-858b-ee38dcbc90e8','hw_scsi_model','virtio-scsi','2026-01-31 07:38:46','2026-01-31 07:40:07','2026-01-31 07:40:07',1),(22,'6e711352-ba7c-4c7d-858b-ee38dcbc90e8','hw_disk_bus','scsi','2026-01-31 07:38:46','2026-01-31 07:40:07','2026-01-31 07:40:07',1),(23,'6e711352-ba7c-4c7d-858b-ee38dcbc90e8','hw_cdrom_bus','scsi','2026-01-31 07:38:46','2026-01-31 07:40:07','2026-01-31 07:40:07',1),(24,'627417b9-a501-49db-939e-bae37ed6ee98','hw_rng_model','virtio','2026-01-31 07:39:07','2026-01-31 07:39:29','2026-01-31 07:39:29',1),(25,'627417b9-a501-49db-939e-bae37ed6ee98','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 07:39:07','2026-01-31 07:39:29','2026-01-31 07:39:29',1),(26,'627417b9-a501-49db-939e-bae37ed6ee98','owner_user_name','tempest-ImagesTestJSON-533495031-project-member','2026-01-31 07:39:07','2026-01-31 07:39:29','2026-01-31 07:39:29',1),(27,'627417b9-a501-49db-939e-bae37ed6ee98','owner_project_name','tempest-ImagesTestJSON-533495031','2026-01-31 07:39:07','2026-01-31 07:39:29','2026-01-31 07:39:29',1),(28,'627417b9-a501-49db-939e-bae37ed6ee98','boot_roles','reader,member','2026-01-31 07:39:07','2026-01-31 07:39:29','2026-01-31 07:39:29',1),(29,'627417b9-a501-49db-939e-bae37ed6ee98','hw_machine_type','q35','2026-01-31 07:39:07','2026-01-31 07:39:29','2026-01-31 07:39:29',1),(30,'627417b9-a501-49db-939e-bae37ed6ee98','hw_cdrom_bus','sata','2026-01-31 07:39:07','2026-01-31 07:39:29','2026-01-31 07:39:29',1),(31,'627417b9-a501-49db-939e-bae37ed6ee98','hw_disk_bus','virtio','2026-01-31 07:39:07','2026-01-31 07:39:29','2026-01-31 07:39:29',1),(32,'627417b9-a501-49db-939e-bae37ed6ee98','hw_input_bus','usb','2026-01-31 07:39:07','2026-01-31 07:39:29','2026-01-31 07:39:29',1),(33,'627417b9-a501-49db-939e-bae37ed6ee98','hw_pointer_model','usbtablet','2026-01-31 07:39:07','2026-01-31 07:39:29','2026-01-31 07:39:29',1),(34,'627417b9-a501-49db-939e-bae37ed6ee98','hw_video_model','virtio','2026-01-31 07:39:07','2026-01-31 07:39:29','2026-01-31 07:39:29',1),(35,'627417b9-a501-49db-939e-bae37ed6ee98','hw_vif_model','virtio','2026-01-31 07:39:07','2026-01-31 07:39:29','2026-01-31 07:39:29',1),(36,'627417b9-a501-49db-939e-bae37ed6ee98','instance_uuid','ec81b99d-17fb-4dd1-aa76-67b3780fce15','2026-01-31 07:39:07','2026-01-31 07:39:29','2026-01-31 07:39:29',1),(37,'627417b9-a501-49db-939e-bae37ed6ee98','user_id','533eaca1e9c4430dabe2b0a39039ca65','2026-01-31 07:39:07','2026-01-31 07:39:29','2026-01-31 07:39:29',1),(38,'627417b9-a501-49db-939e-bae37ed6ee98','image_type','snapshot','2026-01-31 07:39:07','2026-01-31 07:39:29','2026-01-31 07:39:29',1),(39,'4cb863eb-873b-4a83-aef8-5fea8d796cf2','hw_rng_model','virtio','2026-01-31 07:39:11','2026-01-31 07:39:35','2026-01-31 07:39:35',1),(40,'4cb863eb-873b-4a83-aef8-5fea8d796cf2','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 07:39:11','2026-01-31 07:39:35','2026-01-31 07:39:35',1),(41,'4cb863eb-873b-4a83-aef8-5fea8d796cf2','owner_user_name','tempest-ImagesOneServerTestJSON-626457921-project-member','2026-01-31 07:39:11','2026-01-31 07:39:35','2026-01-31 07:39:35',1),(42,'4cb863eb-873b-4a83-aef8-5fea8d796cf2','owner_project_name','tempest-ImagesOneServerTestJSON-626457921','2026-01-31 07:39:11','2026-01-31 07:39:35','2026-01-31 07:39:35',1),(43,'4cb863eb-873b-4a83-aef8-5fea8d796cf2','boot_roles','reader,member','2026-01-31 07:39:11','2026-01-31 07:39:35','2026-01-31 07:39:35',1),(44,'4cb863eb-873b-4a83-aef8-5fea8d796cf2','hw_machine_type','q35','2026-01-31 07:39:11','2026-01-31 07:39:35','2026-01-31 07:39:35',1),(45,'4cb863eb-873b-4a83-aef8-5fea8d796cf2','hw_cdrom_bus','sata','2026-01-31 07:39:11','2026-01-31 07:39:35','2026-01-31 07:39:35',1),(46,'4cb863eb-873b-4a83-aef8-5fea8d796cf2','hw_disk_bus','virtio','2026-01-31 07:39:11','2026-01-31 07:39:35','2026-01-31 07:39:35',1),(47,'4cb863eb-873b-4a83-aef8-5fea8d796cf2','hw_input_bus','usb','2026-01-31 07:39:11','2026-01-31 07:39:35','2026-01-31 07:39:35',1),(48,'4cb863eb-873b-4a83-aef8-5fea8d796cf2','hw_pointer_model','usbtablet','2026-01-31 07:39:11','2026-01-31 07:39:35','2026-01-31 07:39:35',1),(49,'4cb863eb-873b-4a83-aef8-5fea8d796cf2','hw_video_model','virtio','2026-01-31 07:39:11','2026-01-31 07:39:35','2026-01-31 07:39:35',1),(50,'4cb863eb-873b-4a83-aef8-5fea8d796cf2','hw_vif_model','virtio','2026-01-31 07:39:11','2026-01-31 07:39:35','2026-01-31 07:39:35',1),(51,'4cb863eb-873b-4a83-aef8-5fea8d796cf2','instance_uuid','4987b961-5362-48cd-80ca-ff6a201327e6','2026-01-31 07:39:11','2026-01-31 07:39:35','2026-01-31 07:39:35',1),(52,'4cb863eb-873b-4a83-aef8-5fea8d796cf2','user_id','73c9db412cc647958ba8093d8f187dce','2026-01-31 07:39:11','2026-01-31 07:39:35','2026-01-31 07:39:35',1),(53,'4cb863eb-873b-4a83-aef8-5fea8d796cf2','image_type','test','2026-01-31 07:39:11','2026-01-31 07:39:35','2026-01-31 07:39:35',1),(54,'627417b9-a501-49db-939e-bae37ed6ee98','image_location','snapshot','2026-01-31 07:39:18','2026-01-31 07:39:29','2026-01-31 07:39:29',1),(55,'627417b9-a501-49db-939e-bae37ed6ee98','owner_id','b3e3e6f216d24c1f9f68777cfb63dbf8','2026-01-31 07:39:18','2026-01-31 07:39:29','2026-01-31 07:39:29',1),(56,'627417b9-a501-49db-939e-bae37ed6ee98','image_state','available','2026-01-31 07:39:18','2026-01-31 07:39:29','2026-01-31 07:39:29',1),(57,'4cb863eb-873b-4a83-aef8-5fea8d796cf2','owner_id','4511f016f1e44a299447f7fe1ad1a7ab','2026-01-31 07:39:29','2026-01-31 07:39:35','2026-01-31 07:39:35',1),(58,'4cb863eb-873b-4a83-aef8-5fea8d796cf2','image_location','snapshot','2026-01-31 07:39:29','2026-01-31 07:39:35','2026-01-31 07:39:35',1),(59,'4cb863eb-873b-4a83-aef8-5fea8d796cf2','image_state','available','2026-01-31 07:39:29','2026-01-31 07:39:35','2026-01-31 07:39:35',1),(60,'eec3485d-bba1-4018-9e35-7f9f59c9e839','hw_rng_model','virtio','2026-01-31 07:39:35','2026-01-31 07:39:50','2026-01-31 07:39:50',1),(61,'eec3485d-bba1-4018-9e35-7f9f59c9e839','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 07:39:35','2026-01-31 07:39:50','2026-01-31 07:39:50',1),(62,'eec3485d-bba1-4018-9e35-7f9f59c9e839','owner_user_name','tempest-ImagesOneServerTestJSON-626457921-project-member','2026-01-31 07:39:35','2026-01-31 07:39:50','2026-01-31 07:39:50',1),(63,'eec3485d-bba1-4018-9e35-7f9f59c9e839','owner_project_name','tempest-ImagesOneServerTestJSON-626457921','2026-01-31 07:39:35','2026-01-31 07:39:50','2026-01-31 07:39:50',1),(64,'eec3485d-bba1-4018-9e35-7f9f59c9e839','boot_roles','reader,member','2026-01-31 07:39:35','2026-01-31 07:39:50','2026-01-31 07:39:50',1),(65,'eec3485d-bba1-4018-9e35-7f9f59c9e839','hw_machine_type','q35','2026-01-31 07:39:35','2026-01-31 07:39:50','2026-01-31 07:39:50',1),(66,'eec3485d-bba1-4018-9e35-7f9f59c9e839','hw_cdrom_bus','sata','2026-01-31 07:39:35','2026-01-31 07:39:50','2026-01-31 07:39:50',1),(67,'eec3485d-bba1-4018-9e35-7f9f59c9e839','hw_disk_bus','virtio','2026-01-31 07:39:35','2026-01-31 07:39:50','2026-01-31 07:39:50',1),(68,'eec3485d-bba1-4018-9e35-7f9f59c9e839','hw_input_bus','usb','2026-01-31 07:39:35','2026-01-31 07:39:50','2026-01-31 07:39:50',1),(69,'eec3485d-bba1-4018-9e35-7f9f59c9e839','hw_pointer_model','usbtablet','2026-01-31 07:39:35','2026-01-31 07:39:50','2026-01-31 07:39:50',1),(70,'eec3485d-bba1-4018-9e35-7f9f59c9e839','hw_video_model','virtio','2026-01-31 07:39:35','2026-01-31 07:39:50','2026-01-31 07:39:50',1),(71,'eec3485d-bba1-4018-9e35-7f9f59c9e839','hw_vif_model','virtio','2026-01-31 07:39:35','2026-01-31 07:39:50','2026-01-31 07:39:50',1),(72,'eec3485d-bba1-4018-9e35-7f9f59c9e839','instance_uuid','4987b961-5362-48cd-80ca-ff6a201327e6','2026-01-31 07:39:35','2026-01-31 07:39:50','2026-01-31 07:39:50',1),(73,'eec3485d-bba1-4018-9e35-7f9f59c9e839','user_id','73c9db412cc647958ba8093d8f187dce','2026-01-31 07:39:35','2026-01-31 07:39:50','2026-01-31 07:39:50',1),(74,'eec3485d-bba1-4018-9e35-7f9f59c9e839','image_type','snapshot','2026-01-31 07:39:35','2026-01-31 07:39:50','2026-01-31 07:39:50',1),(75,'eec3485d-bba1-4018-9e35-7f9f59c9e839','owner_id','4511f016f1e44a299447f7fe1ad1a7ab','2026-01-31 07:39:45','2026-01-31 07:39:50','2026-01-31 07:39:50',1),(76,'eec3485d-bba1-4018-9e35-7f9f59c9e839','image_location','snapshot','2026-01-31 07:39:45','2026-01-31 07:39:50','2026-01-31 07:39:50',1),(77,'eec3485d-bba1-4018-9e35-7f9f59c9e839','image_state','available','2026-01-31 07:39:45','2026-01-31 07:39:50','2026-01-31 07:39:50',1),(78,'19e1c9c2-3ea0-4549-b950-2d6bc24c2405','hw_rng_model','virtio','2026-01-31 07:39:53','2026-01-31 07:40:03','2026-01-31 07:40:03',1),(79,'19e1c9c2-3ea0-4549-b950-2d6bc24c2405','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 07:39:53','2026-01-31 07:40:03','2026-01-31 07:40:03',1),(80,'19e1c9c2-3ea0-4549-b950-2d6bc24c2405','owner_user_name','tempest-ImagesTestJSON-533495031-project-member','2026-01-31 07:39:53','2026-01-31 07:40:03','2026-01-31 07:40:03',1),(81,'19e1c9c2-3ea0-4549-b950-2d6bc24c2405','owner_project_name','tempest-ImagesTestJSON-533495031','2026-01-31 07:39:53','2026-01-31 07:40:03','2026-01-31 07:40:03',1),(82,'19e1c9c2-3ea0-4549-b950-2d6bc24c2405','boot_roles','reader,member','2026-01-31 07:39:53','2026-01-31 07:40:03','2026-01-31 07:40:03',1),(83,'19e1c9c2-3ea0-4549-b950-2d6bc24c2405','hw_machine_type','q35','2026-01-31 07:39:53','2026-01-31 07:40:03','2026-01-31 07:40:03',1),(84,'19e1c9c2-3ea0-4549-b950-2d6bc24c2405','hw_cdrom_bus','sata','2026-01-31 07:39:53','2026-01-31 07:40:03','2026-01-31 07:40:03',1),(85,'19e1c9c2-3ea0-4549-b950-2d6bc24c2405','hw_disk_bus','virtio','2026-01-31 07:39:53','2026-01-31 07:40:03','2026-01-31 07:40:03',1),(86,'19e1c9c2-3ea0-4549-b950-2d6bc24c2405','hw_input_bus','usb','2026-01-31 07:39:53','2026-01-31 07:40:03','2026-01-31 07:40:03',1),(87,'19e1c9c2-3ea0-4549-b950-2d6bc24c2405','hw_pointer_model','usbtablet','2026-01-31 07:39:53','2026-01-31 07:40:03','2026-01-31 07:40:03',1),(88,'19e1c9c2-3ea0-4549-b950-2d6bc24c2405','hw_video_model','virtio','2026-01-31 07:39:53','2026-01-31 07:40:03','2026-01-31 07:40:03',1),(89,'19e1c9c2-3ea0-4549-b950-2d6bc24c2405','hw_vif_model','virtio','2026-01-31 07:39:53','2026-01-31 07:40:03','2026-01-31 07:40:03',1),(90,'19e1c9c2-3ea0-4549-b950-2d6bc24c2405','old_vm_state','active','2026-01-31 07:39:53','2026-01-31 07:40:03','2026-01-31 07:40:03',1),(91,'19e1c9c2-3ea0-4549-b950-2d6bc24c2405','instance_uuid','2622b77a-7331-4b1f-b3f6-b18902724ea8','2026-01-31 07:39:53','2026-01-31 07:40:03','2026-01-31 07:40:03',1),(92,'19e1c9c2-3ea0-4549-b950-2d6bc24c2405','user_id','533eaca1e9c4430dabe2b0a39039ca65','2026-01-31 07:39:53','2026-01-31 07:40:03','2026-01-31 07:40:03',1),(93,'19e1c9c2-3ea0-4549-b950-2d6bc24c2405','image_type','snapshot','2026-01-31 07:39:53','2026-01-31 07:40:03','2026-01-31 07:40:03',1),(94,'19e1c9c2-3ea0-4549-b950-2d6bc24c2405','image_location','snapshot','2026-01-31 07:39:59','2026-01-31 07:40:03','2026-01-31 07:40:03',1),(95,'19e1c9c2-3ea0-4549-b950-2d6bc24c2405','owner_id','b3e3e6f216d24c1f9f68777cfb63dbf8','2026-01-31 07:39:59','2026-01-31 07:40:03','2026-01-31 07:40:03',1),(96,'19e1c9c2-3ea0-4549-b950-2d6bc24c2405','image_state','available','2026-01-31 07:39:59','2026-01-31 07:40:03','2026-01-31 07:40:03',1),(97,'1c1b7167-294e-43fd-b811-31bea4078f3d','hw_rng_model','virtio','2026-01-31 07:40:20','2026-01-31 07:41:03','2026-01-31 07:41:03',1),(98,'1c1b7167-294e-43fd-b811-31bea4078f3d','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 07:40:20','2026-01-31 07:41:03','2026-01-31 07:41:03',1),(99,'1c1b7167-294e-43fd-b811-31bea4078f3d','owner_user_name','tempest-ImagesTestJSON-533495031-project-member','2026-01-31 07:40:20','2026-01-31 07:41:03','2026-01-31 07:41:03',1),(100,'1c1b7167-294e-43fd-b811-31bea4078f3d','owner_project_name','tempest-ImagesTestJSON-533495031','2026-01-31 07:40:20','2026-01-31 07:41:03','2026-01-31 07:41:03',1),(101,'1c1b7167-294e-43fd-b811-31bea4078f3d','boot_roles','member,reader','2026-01-31 07:40:20','2026-01-31 07:41:03','2026-01-31 07:41:03',1),(102,'1c1b7167-294e-43fd-b811-31bea4078f3d','hw_machine_type','q35','2026-01-31 07:40:20','2026-01-31 07:41:03','2026-01-31 07:41:03',1),(103,'1c1b7167-294e-43fd-b811-31bea4078f3d','hw_cdrom_bus','sata','2026-01-31 07:40:20','2026-01-31 07:41:03','2026-01-31 07:41:03',1),(104,'1c1b7167-294e-43fd-b811-31bea4078f3d','hw_disk_bus','virtio','2026-01-31 07:40:20','2026-01-31 07:41:03','2026-01-31 07:41:03',1),(105,'1c1b7167-294e-43fd-b811-31bea4078f3d','hw_input_bus','usb','2026-01-31 07:40:20','2026-01-31 07:41:03','2026-01-31 07:41:03',1),(106,'1c1b7167-294e-43fd-b811-31bea4078f3d','hw_pointer_model','usbtablet','2026-01-31 07:40:20','2026-01-31 07:41:03','2026-01-31 07:41:03',1),(107,'1c1b7167-294e-43fd-b811-31bea4078f3d','hw_video_model','virtio','2026-01-31 07:40:20','2026-01-31 07:41:03','2026-01-31 07:41:03',1),(108,'1c1b7167-294e-43fd-b811-31bea4078f3d','hw_vif_model','virtio','2026-01-31 07:40:20','2026-01-31 07:41:03','2026-01-31 07:41:03',1),(109,'1c1b7167-294e-43fd-b811-31bea4078f3d','instance_uuid','314f0738-9cae-4fe8-8b90-3d18f72488ef','2026-01-31 07:40:20','2026-01-31 07:41:03','2026-01-31 07:41:03',1),(110,'1c1b7167-294e-43fd-b811-31bea4078f3d','user_id','533eaca1e9c4430dabe2b0a39039ca65','2026-01-31 07:40:20','2026-01-31 07:41:03','2026-01-31 07:41:03',1),(111,'1c1b7167-294e-43fd-b811-31bea4078f3d','image_type','snapshot','2026-01-31 07:40:20','2026-01-31 07:41:03','2026-01-31 07:41:03',1),(112,'1c1b7167-294e-43fd-b811-31bea4078f3d','image_location','snapshot','2026-01-31 07:40:24','2026-01-31 07:41:03','2026-01-31 07:41:03',1),(113,'1c1b7167-294e-43fd-b811-31bea4078f3d','owner_id','b3e3e6f216d24c1f9f68777cfb63dbf8','2026-01-31 07:40:24','2026-01-31 07:41:03','2026-01-31 07:41:03',1),(114,'1c1b7167-294e-43fd-b811-31bea4078f3d','image_state','available','2026-01-31 07:40:24','2026-01-31 07:41:03','2026-01-31 07:41:03',1),(115,'41472c33-f8e9-4285-8ebd-4297b1fe1775','hw_rng_model','virtio','2026-01-31 07:40:53','2026-01-31 07:41:32','2026-01-31 07:41:32',1),(116,'41472c33-f8e9-4285-8ebd-4297b1fe1775','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 07:40:54','2026-01-31 07:41:32','2026-01-31 07:41:32',1),(117,'41472c33-f8e9-4285-8ebd-4297b1fe1775','owner_user_name','tempest-UnshelveToHostMultiNodesTest-877324354-project-member','2026-01-31 07:40:54','2026-01-31 07:41:32','2026-01-31 07:41:32',1),(118,'41472c33-f8e9-4285-8ebd-4297b1fe1775','owner_project_name','tempest-UnshelveToHostMultiNodesTest-877324354','2026-01-31 07:40:54','2026-01-31 07:41:32','2026-01-31 07:41:32',1),(119,'41472c33-f8e9-4285-8ebd-4297b1fe1775','boot_roles','member,reader','2026-01-31 07:40:54','2026-01-31 07:41:32','2026-01-31 07:41:32',1),(120,'41472c33-f8e9-4285-8ebd-4297b1fe1775','hw_machine_type','q35','2026-01-31 07:40:54','2026-01-31 07:41:32','2026-01-31 07:41:32',1),(121,'41472c33-f8e9-4285-8ebd-4297b1fe1775','hw_cdrom_bus','sata','2026-01-31 07:40:54','2026-01-31 07:41:32','2026-01-31 07:41:32',1),(122,'41472c33-f8e9-4285-8ebd-4297b1fe1775','hw_disk_bus','virtio','2026-01-31 07:40:54','2026-01-31 07:41:32','2026-01-31 07:41:32',1),(123,'41472c33-f8e9-4285-8ebd-4297b1fe1775','hw_input_bus','usb','2026-01-31 07:40:54','2026-01-31 07:41:32','2026-01-31 07:41:32',1),(124,'41472c33-f8e9-4285-8ebd-4297b1fe1775','hw_pointer_model','usbtablet','2026-01-31 07:40:54','2026-01-31 07:41:32','2026-01-31 07:41:32',1),(125,'41472c33-f8e9-4285-8ebd-4297b1fe1775','hw_video_model','virtio','2026-01-31 07:40:54','2026-01-31 07:41:32','2026-01-31 07:41:32',1),(126,'41472c33-f8e9-4285-8ebd-4297b1fe1775','hw_vif_model','virtio','2026-01-31 07:40:54','2026-01-31 07:41:32','2026-01-31 07:41:32',1),(127,'41472c33-f8e9-4285-8ebd-4297b1fe1775','instance_uuid','49c2b2d1-3230-4f75-bc49-86230accc637','2026-01-31 07:40:54','2026-01-31 07:41:32','2026-01-31 07:41:32',1),(128,'41472c33-f8e9-4285-8ebd-4297b1fe1775','user_id','cda91adb5caf4eeb81b5a934ccbb1a1e','2026-01-31 07:40:54','2026-01-31 07:41:32','2026-01-31 07:41:32',1),(129,'41472c33-f8e9-4285-8ebd-4297b1fe1775','image_type','snapshot','2026-01-31 07:40:54','2026-01-31 07:41:32','2026-01-31 07:41:32',1),(130,'41472c33-f8e9-4285-8ebd-4297b1fe1775','owner_id','37a878bbb1224cfeabcbe629345fc85d','2026-01-31 07:41:13','2026-01-31 07:41:32','2026-01-31 07:41:32',1),(131,'41472c33-f8e9-4285-8ebd-4297b1fe1775','image_location','snapshot','2026-01-31 07:41:13','2026-01-31 07:41:32','2026-01-31 07:41:32',1),(132,'41472c33-f8e9-4285-8ebd-4297b1fe1775','image_state','available','2026-01-31 07:41:13','2026-01-31 07:41:32','2026-01-31 07:41:32',1),(133,'18697fed-07f1-495d-b1ed-b20c2cf25fce','hw_rng_model','virtio','2026-01-31 07:41:24','2026-01-31 07:41:25','2026-01-31 07:41:25',1),(134,'18697fed-07f1-495d-b1ed-b20c2cf25fce','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 07:41:24','2026-01-31 07:41:25','2026-01-31 07:41:25',1),(135,'18697fed-07f1-495d-b1ed-b20c2cf25fce','owner_user_name','tempest-ImagesTestJSON-533495031-project-member','2026-01-31 07:41:24','2026-01-31 07:41:25','2026-01-31 07:41:25',1),(136,'18697fed-07f1-495d-b1ed-b20c2cf25fce','owner_project_name','tempest-ImagesTestJSON-533495031','2026-01-31 07:41:24','2026-01-31 07:41:25','2026-01-31 07:41:25',1),(137,'18697fed-07f1-495d-b1ed-b20c2cf25fce','boot_roles','member,reader','2026-01-31 07:41:24','2026-01-31 07:41:25','2026-01-31 07:41:25',1),(138,'18697fed-07f1-495d-b1ed-b20c2cf25fce','hw_machine_type','q35','2026-01-31 07:41:24','2026-01-31 07:41:25','2026-01-31 07:41:25',1),(139,'18697fed-07f1-495d-b1ed-b20c2cf25fce','hw_cdrom_bus','sata','2026-01-31 07:41:24','2026-01-31 07:41:25','2026-01-31 07:41:25',1),(140,'18697fed-07f1-495d-b1ed-b20c2cf25fce','hw_disk_bus','virtio','2026-01-31 07:41:24','2026-01-31 07:41:25','2026-01-31 07:41:25',1),(141,'18697fed-07f1-495d-b1ed-b20c2cf25fce','hw_input_bus','usb','2026-01-31 07:41:24','2026-01-31 07:41:25','2026-01-31 07:41:25',1),(142,'18697fed-07f1-495d-b1ed-b20c2cf25fce','hw_pointer_model','usbtablet','2026-01-31 07:41:24','2026-01-31 07:41:25','2026-01-31 07:41:25',1),(143,'18697fed-07f1-495d-b1ed-b20c2cf25fce','hw_video_model','virtio','2026-01-31 07:41:24','2026-01-31 07:41:25','2026-01-31 07:41:25',1),(144,'18697fed-07f1-495d-b1ed-b20c2cf25fce','hw_vif_model','virtio','2026-01-31 07:41:24','2026-01-31 07:41:25','2026-01-31 07:41:25',1),(145,'18697fed-07f1-495d-b1ed-b20c2cf25fce','instance_uuid','c15e2982-5d12-4b02-9e21-c5ae81e3f478','2026-01-31 07:41:24','2026-01-31 07:41:25','2026-01-31 07:41:25',1),(146,'18697fed-07f1-495d-b1ed-b20c2cf25fce','user_id','533eaca1e9c4430dabe2b0a39039ca65','2026-01-31 07:41:24','2026-01-31 07:41:25','2026-01-31 07:41:25',1),(147,'18697fed-07f1-495d-b1ed-b20c2cf25fce','image_type','snapshot','2026-01-31 07:41:24','2026-01-31 07:41:25','2026-01-31 07:41:25',1),(148,'0b8514e3-4251-4bd6-a806-b742c737781f','hw_rng_model','virtio','2026-01-31 07:41:35','2026-01-31 07:42:34','2026-01-31 07:42:34',1),(149,'0b8514e3-4251-4bd6-a806-b742c737781f','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 07:41:36','2026-01-31 07:42:34','2026-01-31 07:42:34',1),(150,'0b8514e3-4251-4bd6-a806-b742c737781f','owner_user_name','tempest-UnshelveToHostMultiNodesTest-877324354-project-member','2026-01-31 07:41:37','2026-01-31 07:42:34','2026-01-31 07:42:34',1),(151,'0b8514e3-4251-4bd6-a806-b742c737781f','owner_project_name','tempest-UnshelveToHostMultiNodesTest-877324354','2026-01-31 07:41:37','2026-01-31 07:42:34','2026-01-31 07:42:34',1),(152,'0b8514e3-4251-4bd6-a806-b742c737781f','boot_roles','member,reader','2026-01-31 07:41:37','2026-01-31 07:42:34','2026-01-31 07:42:34',1),(153,'0b8514e3-4251-4bd6-a806-b742c737781f','hw_machine_type','q35','2026-01-31 07:41:37','2026-01-31 07:42:34','2026-01-31 07:42:34',1),(154,'0b8514e3-4251-4bd6-a806-b742c737781f','hw_cdrom_bus','sata','2026-01-31 07:41:37','2026-01-31 07:42:34','2026-01-31 07:42:34',1),(155,'0b8514e3-4251-4bd6-a806-b742c737781f','hw_disk_bus','virtio','2026-01-31 07:41:37','2026-01-31 07:42:34','2026-01-31 07:42:34',1),(156,'0b8514e3-4251-4bd6-a806-b742c737781f','hw_input_bus','usb','2026-01-31 07:41:37','2026-01-31 07:42:34','2026-01-31 07:42:34',1),(157,'0b8514e3-4251-4bd6-a806-b742c737781f','hw_pointer_model','usbtablet','2026-01-31 07:41:37','2026-01-31 07:42:34','2026-01-31 07:42:34',1),(158,'0b8514e3-4251-4bd6-a806-b742c737781f','hw_video_model','virtio','2026-01-31 07:41:37','2026-01-31 07:42:34','2026-01-31 07:42:34',1),(159,'0b8514e3-4251-4bd6-a806-b742c737781f','hw_vif_model','virtio','2026-01-31 07:41:37','2026-01-31 07:42:34','2026-01-31 07:42:34',1),(160,'0b8514e3-4251-4bd6-a806-b742c737781f','clean_attempts','1','2026-01-31 07:41:37','2026-01-31 07:42:34','2026-01-31 07:42:34',1),(161,'0b8514e3-4251-4bd6-a806-b742c737781f','instance_uuid','49c2b2d1-3230-4f75-bc49-86230accc637','2026-01-31 07:41:37','2026-01-31 07:42:34','2026-01-31 07:42:34',1),(162,'0b8514e3-4251-4bd6-a806-b742c737781f','user_id','cda91adb5caf4eeb81b5a934ccbb1a1e','2026-01-31 07:41:37','2026-01-31 07:42:34','2026-01-31 07:42:34',1),(163,'0b8514e3-4251-4bd6-a806-b742c737781f','image_type','snapshot','2026-01-31 07:41:37','2026-01-31 07:42:34','2026-01-31 07:42:34',1),(164,'0b8514e3-4251-4bd6-a806-b742c737781f','owner_id','37a878bbb1224cfeabcbe629345fc85d','2026-01-31 07:42:04','2026-01-31 07:42:34','2026-01-31 07:42:34',1),(165,'0b8514e3-4251-4bd6-a806-b742c737781f','image_location','snapshot','2026-01-31 07:42:04','2026-01-31 07:42:34','2026-01-31 07:42:34',1),(166,'0b8514e3-4251-4bd6-a806-b742c737781f','image_state','available','2026-01-31 07:42:04','2026-01-31 07:42:34','2026-01-31 07:42:34',1),(167,'ed46ac7b-1d36-47b6-9e31-f3feaccdcefd','hw_rng_model','virtio','2026-01-31 07:44:29','2026-01-31 07:44:34','2026-01-31 07:44:34',1),(168,'ed46ac7b-1d36-47b6-9e31-f3feaccdcefd','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 07:44:29','2026-01-31 07:44:34','2026-01-31 07:44:34',1),(169,'ed46ac7b-1d36-47b6-9e31-f3feaccdcefd','owner_user_name','tempest-ImagesOneServerNegativeTestJSON-536491326-project-member','2026-01-31 07:44:29','2026-01-31 07:44:34','2026-01-31 07:44:34',1),(170,'ed46ac7b-1d36-47b6-9e31-f3feaccdcefd','owner_project_name','tempest-ImagesOneServerNegativeTestJSON-536491326','2026-01-31 07:44:29','2026-01-31 07:44:34','2026-01-31 07:44:34',1),(171,'ed46ac7b-1d36-47b6-9e31-f3feaccdcefd','boot_roles','member,reader','2026-01-31 07:44:29','2026-01-31 07:44:34','2026-01-31 07:44:34',1),(172,'ed46ac7b-1d36-47b6-9e31-f3feaccdcefd','hw_machine_type','q35','2026-01-31 07:44:29','2026-01-31 07:44:34','2026-01-31 07:44:34',1),(173,'ed46ac7b-1d36-47b6-9e31-f3feaccdcefd','hw_cdrom_bus','sata','2026-01-31 07:44:29','2026-01-31 07:44:34','2026-01-31 07:44:34',1),(174,'ed46ac7b-1d36-47b6-9e31-f3feaccdcefd','hw_disk_bus','virtio','2026-01-31 07:44:29','2026-01-31 07:44:35','2026-01-31 07:44:35',1),(175,'ed46ac7b-1d36-47b6-9e31-f3feaccdcefd','hw_input_bus','usb','2026-01-31 07:44:29','2026-01-31 07:44:35','2026-01-31 07:44:35',1),(176,'ed46ac7b-1d36-47b6-9e31-f3feaccdcefd','hw_pointer_model','usbtablet','2026-01-31 07:44:29','2026-01-31 07:44:35','2026-01-31 07:44:35',1),(177,'ed46ac7b-1d36-47b6-9e31-f3feaccdcefd','hw_video_model','virtio','2026-01-31 07:44:29','2026-01-31 07:44:35','2026-01-31 07:44:35',1),(178,'ed46ac7b-1d36-47b6-9e31-f3feaccdcefd','hw_vif_model','virtio','2026-01-31 07:44:29','2026-01-31 07:44:35','2026-01-31 07:44:35',1),(179,'ed46ac7b-1d36-47b6-9e31-f3feaccdcefd','instance_uuid','0de34c85-05be-461e-ae22-ac3816f1018d','2026-01-31 07:44:29','2026-01-31 07:44:35','2026-01-31 07:44:35',1),(180,'ed46ac7b-1d36-47b6-9e31-f3feaccdcefd','user_id','4cdbfeb437d54df89a0fb0f6621b8fdc','2026-01-31 07:44:29','2026-01-31 07:44:35','2026-01-31 07:44:35',1),(181,'ed46ac7b-1d36-47b6-9e31-f3feaccdcefd','image_type','snapshot','2026-01-31 07:44:29','2026-01-31 07:44:35','2026-01-31 07:44:35',1),(182,'d0b187ca-45f7-4a66-bf6d-895562fb5aaf','hw_rng_model','virtio','2026-01-31 07:45:34','2026-01-31 07:45:34','2026-01-31 07:45:34',1),(183,'d0b187ca-45f7-4a66-bf6d-895562fb5aaf','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 07:45:34','2026-01-31 07:45:35','2026-01-31 07:45:35',1),(184,'d0b187ca-45f7-4a66-bf6d-895562fb5aaf','owner_user_name','tempest-ImagesOneServerNegativeTestJSON-536491326-project-member','2026-01-31 07:45:34','2026-01-31 07:45:35','2026-01-31 07:45:35',1),(185,'d0b187ca-45f7-4a66-bf6d-895562fb5aaf','owner_project_name','tempest-ImagesOneServerNegativeTestJSON-536491326','2026-01-31 07:45:34','2026-01-31 07:45:35','2026-01-31 07:45:35',1),(186,'d0b187ca-45f7-4a66-bf6d-895562fb5aaf','boot_roles','reader,member','2026-01-31 07:45:34','2026-01-31 07:45:35','2026-01-31 07:45:35',1),(187,'d0b187ca-45f7-4a66-bf6d-895562fb5aaf','hw_machine_type','q35','2026-01-31 07:45:34','2026-01-31 07:45:35','2026-01-31 07:45:35',1),(188,'d0b187ca-45f7-4a66-bf6d-895562fb5aaf','hw_cdrom_bus','sata','2026-01-31 07:45:34','2026-01-31 07:45:35','2026-01-31 07:45:35',1),(189,'d0b187ca-45f7-4a66-bf6d-895562fb5aaf','hw_disk_bus','virtio','2026-01-31 07:45:34','2026-01-31 07:45:35','2026-01-31 07:45:35',1),(190,'d0b187ca-45f7-4a66-bf6d-895562fb5aaf','hw_input_bus','usb','2026-01-31 07:45:34','2026-01-31 07:45:35','2026-01-31 07:45:35',1),(191,'d0b187ca-45f7-4a66-bf6d-895562fb5aaf','hw_pointer_model','usbtablet','2026-01-31 07:45:34','2026-01-31 07:45:35','2026-01-31 07:45:35',1),(192,'d0b187ca-45f7-4a66-bf6d-895562fb5aaf','hw_video_model','virtio','2026-01-31 07:45:34','2026-01-31 07:45:35','2026-01-31 07:45:35',1),(193,'d0b187ca-45f7-4a66-bf6d-895562fb5aaf','hw_vif_model','virtio','2026-01-31 07:45:34','2026-01-31 07:45:35','2026-01-31 07:45:35',1),(194,'d0b187ca-45f7-4a66-bf6d-895562fb5aaf','instance_uuid','14852aaa-992b-4b7c-9a9c-dd811ac8617a','2026-01-31 07:45:34','2026-01-31 07:45:35','2026-01-31 07:45:35',1),(195,'d0b187ca-45f7-4a66-bf6d-895562fb5aaf','user_id','4cdbfeb437d54df89a0fb0f6621b8fdc','2026-01-31 07:45:34','2026-01-31 07:45:35','2026-01-31 07:45:35',1),(196,'d0b187ca-45f7-4a66-bf6d-895562fb5aaf','image_type','snapshot','2026-01-31 07:45:34','2026-01-31 07:45:35','2026-01-31 07:45:35',1),(197,'b009eb64-1e75-45c8-99c5-fb9d2b66fdcb','hw_rng_model','virtio','2026-01-31 07:46:32','2026-01-31 07:47:23','2026-01-31 07:47:23',1),(198,'b009eb64-1e75-45c8-99c5-fb9d2b66fdcb','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 07:46:32','2026-01-31 07:47:23','2026-01-31 07:47:23',1),(199,'b009eb64-1e75-45c8-99c5-fb9d2b66fdcb','owner_user_name','tempest-DeleteServersTestJSON-2031597701-project-member','2026-01-31 07:46:32','2026-01-31 07:47:23','2026-01-31 07:47:23',1),(200,'b009eb64-1e75-45c8-99c5-fb9d2b66fdcb','owner_project_name','tempest-DeleteServersTestJSON-2031597701','2026-01-31 07:46:32','2026-01-31 07:47:23','2026-01-31 07:47:23',1),(201,'b009eb64-1e75-45c8-99c5-fb9d2b66fdcb','boot_roles','reader,member','2026-01-31 07:46:32','2026-01-31 07:47:23','2026-01-31 07:47:23',1),(202,'b009eb64-1e75-45c8-99c5-fb9d2b66fdcb','hw_machine_type','q35','2026-01-31 07:46:32','2026-01-31 07:47:23','2026-01-31 07:47:23',1),(203,'b009eb64-1e75-45c8-99c5-fb9d2b66fdcb','hw_cdrom_bus','sata','2026-01-31 07:46:32','2026-01-31 07:47:23','2026-01-31 07:47:23',1),(204,'b009eb64-1e75-45c8-99c5-fb9d2b66fdcb','hw_disk_bus','virtio','2026-01-31 07:46:32','2026-01-31 07:47:23','2026-01-31 07:47:23',1),(205,'b009eb64-1e75-45c8-99c5-fb9d2b66fdcb','hw_input_bus','usb','2026-01-31 07:46:32','2026-01-31 07:47:23','2026-01-31 07:47:23',1),(206,'b009eb64-1e75-45c8-99c5-fb9d2b66fdcb','hw_pointer_model','usbtablet','2026-01-31 07:46:32','2026-01-31 07:47:23','2026-01-31 07:47:23',1),(207,'b009eb64-1e75-45c8-99c5-fb9d2b66fdcb','hw_video_model','virtio','2026-01-31 07:46:32','2026-01-31 07:47:23','2026-01-31 07:47:23',1),(208,'b009eb64-1e75-45c8-99c5-fb9d2b66fdcb','hw_vif_model','virtio','2026-01-31 07:46:32','2026-01-31 07:47:23','2026-01-31 07:47:23',1),(209,'b009eb64-1e75-45c8-99c5-fb9d2b66fdcb','instance_uuid','070c0648-719f-49ef-9721-ce18b2d03fd3','2026-01-31 07:46:32','2026-01-31 07:47:23','2026-01-31 07:47:23',1),(210,'b009eb64-1e75-45c8-99c5-fb9d2b66fdcb','user_id','97abab8eb79247cd89fb2ebff295b890','2026-01-31 07:46:32','2026-01-31 07:47:23','2026-01-31 07:47:23',1),(211,'b009eb64-1e75-45c8-99c5-fb9d2b66fdcb','image_type','snapshot','2026-01-31 07:46:32','2026-01-31 07:47:23','2026-01-31 07:47:23',1),(212,'b009eb64-1e75-45c8-99c5-fb9d2b66fdcb','owner_id','f299640bb1f64e5fa12b23955e5a2127','2026-01-31 07:47:06','2026-01-31 07:47:23','2026-01-31 07:47:23',1),(213,'b009eb64-1e75-45c8-99c5-fb9d2b66fdcb','image_location','snapshot','2026-01-31 07:47:06','2026-01-31 07:47:23','2026-01-31 07:47:23',1),(214,'b009eb64-1e75-45c8-99c5-fb9d2b66fdcb','image_state','available','2026-01-31 07:47:06','2026-01-31 07:47:23','2026-01-31 07:47:23',1),(215,'32133469-37ac-412d-b940-c908b55cf858','hw_rng_model','virtio','2026-01-31 07:47:32','2026-01-31 07:48:34','2026-01-31 07:48:34',1),(216,'32133469-37ac-412d-b940-c908b55cf858','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 07:47:32','2026-01-31 07:48:34','2026-01-31 07:48:34',1),(217,'32133469-37ac-412d-b940-c908b55cf858','owner_user_name','tempest-ListImageFiltersTestJSON-1086962866-project-member','2026-01-31 07:47:32','2026-01-31 07:48:34','2026-01-31 07:48:34',1),(218,'32133469-37ac-412d-b940-c908b55cf858','owner_project_name','tempest-ListImageFiltersTestJSON-1086962866','2026-01-31 07:47:32','2026-01-31 07:48:34','2026-01-31 07:48:34',1),(219,'32133469-37ac-412d-b940-c908b55cf858','boot_roles','member,reader','2026-01-31 07:47:32','2026-01-31 07:48:34','2026-01-31 07:48:34',1),(220,'32133469-37ac-412d-b940-c908b55cf858','hw_machine_type','q35','2026-01-31 07:47:32','2026-01-31 07:48:34','2026-01-31 07:48:34',1),(221,'32133469-37ac-412d-b940-c908b55cf858','hw_cdrom_bus','sata','2026-01-31 07:47:32','2026-01-31 07:48:34','2026-01-31 07:48:34',1),(222,'32133469-37ac-412d-b940-c908b55cf858','hw_disk_bus','virtio','2026-01-31 07:47:32','2026-01-31 07:48:34','2026-01-31 07:48:34',1),(223,'32133469-37ac-412d-b940-c908b55cf858','hw_input_bus','usb','2026-01-31 07:47:32','2026-01-31 07:48:34','2026-01-31 07:48:34',1),(224,'32133469-37ac-412d-b940-c908b55cf858','hw_pointer_model','usbtablet','2026-01-31 07:47:32','2026-01-31 07:48:34','2026-01-31 07:48:34',1),(225,'32133469-37ac-412d-b940-c908b55cf858','hw_video_model','virtio','2026-01-31 07:47:32','2026-01-31 07:48:34','2026-01-31 07:48:34',1),(226,'32133469-37ac-412d-b940-c908b55cf858','hw_vif_model','virtio','2026-01-31 07:47:32','2026-01-31 07:48:34','2026-01-31 07:48:34',1),(227,'32133469-37ac-412d-b940-c908b55cf858','instance_uuid','2d280afb-69f5-4511-8134-19901686f5fc','2026-01-31 07:47:32','2026-01-31 07:48:34','2026-01-31 07:48:34',1),(228,'32133469-37ac-412d-b940-c908b55cf858','user_id','aeb97fa2b1284c3faf0028734652a72c','2026-01-31 07:47:32','2026-01-31 07:48:34','2026-01-31 07:48:34',1),(229,'32133469-37ac-412d-b940-c908b55cf858','image_type','snapshot','2026-01-31 07:47:32','2026-01-31 07:48:34','2026-01-31 07:48:34',1),(230,'32133469-37ac-412d-b940-c908b55cf858','image_location','snapshot','2026-01-31 07:47:45','2026-01-31 07:48:34','2026-01-31 07:48:34',1),(231,'32133469-37ac-412d-b940-c908b55cf858','owner_id','d8503864fef643f698a175cc6364101c','2026-01-31 07:47:45','2026-01-31 07:48:34','2026-01-31 07:48:34',1),(232,'32133469-37ac-412d-b940-c908b55cf858','image_state','available','2026-01-31 07:47:45','2026-01-31 07:48:34','2026-01-31 07:48:34',1),(233,'2afd45fd-a049-4e1d-819a-36a36d22f6a2','hw_rng_model','virtio','2026-01-31 07:47:50','2026-01-31 07:48:30','2026-01-31 07:48:30',1),(234,'2afd45fd-a049-4e1d-819a-36a36d22f6a2','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 07:47:50','2026-01-31 07:48:30','2026-01-31 07:48:30',1),(235,'2afd45fd-a049-4e1d-819a-36a36d22f6a2','owner_user_name','tempest-ListImageFiltersTestJSON-1086962866-project-member','2026-01-31 07:47:50','2026-01-31 07:48:30','2026-01-31 07:48:30',1),(236,'2afd45fd-a049-4e1d-819a-36a36d22f6a2','owner_project_name','tempest-ListImageFiltersTestJSON-1086962866','2026-01-31 07:47:50','2026-01-31 07:48:30','2026-01-31 07:48:30',1),(237,'2afd45fd-a049-4e1d-819a-36a36d22f6a2','boot_roles','member,reader','2026-01-31 07:47:50','2026-01-31 07:48:30','2026-01-31 07:48:30',1),(238,'2afd45fd-a049-4e1d-819a-36a36d22f6a2','hw_machine_type','q35','2026-01-31 07:47:50','2026-01-31 07:48:30','2026-01-31 07:48:30',1),(239,'2afd45fd-a049-4e1d-819a-36a36d22f6a2','hw_cdrom_bus','sata','2026-01-31 07:47:50','2026-01-31 07:48:30','2026-01-31 07:48:30',1),(240,'2afd45fd-a049-4e1d-819a-36a36d22f6a2','hw_disk_bus','virtio','2026-01-31 07:47:50','2026-01-31 07:48:30','2026-01-31 07:48:30',1),(241,'2afd45fd-a049-4e1d-819a-36a36d22f6a2','hw_input_bus','usb','2026-01-31 07:47:50','2026-01-31 07:48:30','2026-01-31 07:48:30',1),(242,'2afd45fd-a049-4e1d-819a-36a36d22f6a2','hw_pointer_model','usbtablet','2026-01-31 07:47:50','2026-01-31 07:48:30','2026-01-31 07:48:30',1),(243,'2afd45fd-a049-4e1d-819a-36a36d22f6a2','hw_video_model','virtio','2026-01-31 07:47:50','2026-01-31 07:48:30','2026-01-31 07:48:30',1),(244,'2afd45fd-a049-4e1d-819a-36a36d22f6a2','hw_vif_model','virtio','2026-01-31 07:47:50','2026-01-31 07:48:30','2026-01-31 07:48:30',1),(245,'2afd45fd-a049-4e1d-819a-36a36d22f6a2','instance_uuid','1605ed48-f361-4895-81e2-915a59f90ec9','2026-01-31 07:47:50','2026-01-31 07:48:30','2026-01-31 07:48:30',1),(246,'2afd45fd-a049-4e1d-819a-36a36d22f6a2','user_id','aeb97fa2b1284c3faf0028734652a72c','2026-01-31 07:47:50','2026-01-31 07:48:30','2026-01-31 07:48:30',1),(247,'2afd45fd-a049-4e1d-819a-36a36d22f6a2','image_type','snapshot','2026-01-31 07:47:50','2026-01-31 07:48:30','2026-01-31 07:48:30',1),(248,'2afd45fd-a049-4e1d-819a-36a36d22f6a2','owner_id','d8503864fef643f698a175cc6364101c','2026-01-31 07:47:57','2026-01-31 07:48:30','2026-01-31 07:48:30',1),(249,'2afd45fd-a049-4e1d-819a-36a36d22f6a2','image_location','snapshot','2026-01-31 07:47:57','2026-01-31 07:48:30','2026-01-31 07:48:30',1),(250,'2afd45fd-a049-4e1d-819a-36a36d22f6a2','image_state','available','2026-01-31 07:47:57','2026-01-31 07:48:30','2026-01-31 07:48:30',1),(251,'ba20a523-9c85-4f5a-958b-3ab7efcbb3ba','hw_rng_model','virtio','2026-01-31 07:48:02','2026-01-31 07:48:26','2026-01-31 07:48:26',1),(252,'ba20a523-9c85-4f5a-958b-3ab7efcbb3ba','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 07:48:02','2026-01-31 07:48:26','2026-01-31 07:48:26',1),(253,'ba20a523-9c85-4f5a-958b-3ab7efcbb3ba','owner_user_name','tempest-ListImageFiltersTestJSON-1086962866-project-member','2026-01-31 07:48:02','2026-01-31 07:48:26','2026-01-31 07:48:26',1),(254,'ba20a523-9c85-4f5a-958b-3ab7efcbb3ba','owner_project_name','tempest-ListImageFiltersTestJSON-1086962866','2026-01-31 07:48:02','2026-01-31 07:48:26','2026-01-31 07:48:26',1),(255,'ba20a523-9c85-4f5a-958b-3ab7efcbb3ba','boot_roles','member,reader','2026-01-31 07:48:02','2026-01-31 07:48:26','2026-01-31 07:48:26',1),(256,'ba20a523-9c85-4f5a-958b-3ab7efcbb3ba','hw_machine_type','q35','2026-01-31 07:48:02','2026-01-31 07:48:26','2026-01-31 07:48:26',1),(257,'ba20a523-9c85-4f5a-958b-3ab7efcbb3ba','hw_cdrom_bus','sata','2026-01-31 07:48:02','2026-01-31 07:48:26','2026-01-31 07:48:26',1),(258,'ba20a523-9c85-4f5a-958b-3ab7efcbb3ba','hw_disk_bus','virtio','2026-01-31 07:48:02','2026-01-31 07:48:26','2026-01-31 07:48:26',1),(259,'ba20a523-9c85-4f5a-958b-3ab7efcbb3ba','hw_input_bus','usb','2026-01-31 07:48:02','2026-01-31 07:48:26','2026-01-31 07:48:26',1),(260,'ba20a523-9c85-4f5a-958b-3ab7efcbb3ba','hw_pointer_model','usbtablet','2026-01-31 07:48:02','2026-01-31 07:48:26','2026-01-31 07:48:26',1),(261,'ba20a523-9c85-4f5a-958b-3ab7efcbb3ba','hw_video_model','virtio','2026-01-31 07:48:02','2026-01-31 07:48:26','2026-01-31 07:48:26',1),(262,'ba20a523-9c85-4f5a-958b-3ab7efcbb3ba','hw_vif_model','virtio','2026-01-31 07:48:02','2026-01-31 07:48:26','2026-01-31 07:48:26',1),(263,'ba20a523-9c85-4f5a-958b-3ab7efcbb3ba','instance_uuid','2d280afb-69f5-4511-8134-19901686f5fc','2026-01-31 07:48:02','2026-01-31 07:48:26','2026-01-31 07:48:26',1),(264,'ba20a523-9c85-4f5a-958b-3ab7efcbb3ba','user_id','aeb97fa2b1284c3faf0028734652a72c','2026-01-31 07:48:02','2026-01-31 07:48:26','2026-01-31 07:48:26',1),(265,'ba20a523-9c85-4f5a-958b-3ab7efcbb3ba','image_type','snapshot','2026-01-31 07:48:02','2026-01-31 07:48:26','2026-01-31 07:48:26',1),(266,'ba20a523-9c85-4f5a-958b-3ab7efcbb3ba','image_location','snapshot','2026-01-31 07:48:11','2026-01-31 07:48:26','2026-01-31 07:48:26',1),(267,'ba20a523-9c85-4f5a-958b-3ab7efcbb3ba','owner_id','d8503864fef643f698a175cc6364101c','2026-01-31 07:48:11','2026-01-31 07:48:26','2026-01-31 07:48:26',1),(268,'ba20a523-9c85-4f5a-958b-3ab7efcbb3ba','image_state','available','2026-01-31 07:48:11','2026-01-31 07:48:26','2026-01-31 07:48:26',1),(269,'3456c8a1-e00b-403c-938b-5db22092f19b','os_distro','value2','2026-01-31 07:49:04','2026-01-31 07:49:24','2026-01-31 07:49:24',1),(270,'3456c8a1-e00b-403c-938b-5db22092f19b','os_version','alt1','2026-01-31 07:49:04','2026-01-31 07:49:24','2026-01-31 07:49:24',1),(271,'3456c8a1-e00b-403c-938b-5db22092f19b','architecture','value3','2026-01-31 07:49:13','2026-01-31 07:49:24','2026-01-31 07:49:24',1),(272,'94599989-66dd-45c0-95bf-4799dd46478c','hw_rng_model','virtio','2026-01-31 08:07:53','2026-01-31 08:08:23','2026-01-31 08:08:23',1),(273,'94599989-66dd-45c0-95bf-4799dd46478c','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 08:07:53','2026-01-31 08:08:23','2026-01-31 08:08:23',1),(274,'94599989-66dd-45c0-95bf-4799dd46478c','owner_user_name','tempest-ServerActionsTestOtherB-2012907318-project-member','2026-01-31 08:07:53','2026-01-31 08:08:23','2026-01-31 08:08:23',1),(275,'94599989-66dd-45c0-95bf-4799dd46478c','owner_project_name','tempest-ServerActionsTestOtherB-2012907318','2026-01-31 08:07:53','2026-01-31 08:08:23','2026-01-31 08:08:23',1),(276,'94599989-66dd-45c0-95bf-4799dd46478c','boot_roles','reader,member','2026-01-31 08:07:53','2026-01-31 08:08:23','2026-01-31 08:08:23',1),(277,'94599989-66dd-45c0-95bf-4799dd46478c','hw_machine_type','q35','2026-01-31 08:07:53','2026-01-31 08:08:23','2026-01-31 08:08:23',1),(278,'94599989-66dd-45c0-95bf-4799dd46478c','hw_cdrom_bus','sata','2026-01-31 08:07:53','2026-01-31 08:08:23','2026-01-31 08:08:23',1),(279,'94599989-66dd-45c0-95bf-4799dd46478c','hw_disk_bus','virtio','2026-01-31 08:07:53','2026-01-31 08:08:23','2026-01-31 08:08:23',1),(280,'94599989-66dd-45c0-95bf-4799dd46478c','hw_input_bus','usb','2026-01-31 08:07:53','2026-01-31 08:08:23','2026-01-31 08:08:23',1),(281,'94599989-66dd-45c0-95bf-4799dd46478c','hw_pointer_model','usbtablet','2026-01-31 08:07:53','2026-01-31 08:08:23','2026-01-31 08:08:23',1),(282,'94599989-66dd-45c0-95bf-4799dd46478c','hw_video_model','virtio','2026-01-31 08:07:53','2026-01-31 08:08:23','2026-01-31 08:08:23',1),(283,'94599989-66dd-45c0-95bf-4799dd46478c','hw_vif_model','virtio','2026-01-31 08:07:53','2026-01-31 08:08:23','2026-01-31 08:08:23',1),(284,'94599989-66dd-45c0-95bf-4799dd46478c','instance_uuid','1d463d8d-cbf7-43ec-8042-83d2c9aa5c69','2026-01-31 08:07:53','2026-01-31 08:08:23','2026-01-31 08:08:23',1),(285,'94599989-66dd-45c0-95bf-4799dd46478c','user_id','18aee9d81d404f77ac81cde538f140d8','2026-01-31 08:07:53','2026-01-31 08:08:24','2026-01-31 08:08:24',1),(286,'94599989-66dd-45c0-95bf-4799dd46478c','image_type','backup','2026-01-31 08:07:53','2026-01-31 08:08:24','2026-01-31 08:08:24',1),(287,'94599989-66dd-45c0-95bf-4799dd46478c','backup_type','daily','2026-01-31 08:07:53','2026-01-31 08:08:24','2026-01-31 08:08:24',1),(288,'94599989-66dd-45c0-95bf-4799dd46478c','image_location','snapshot','2026-01-31 08:08:00','2026-01-31 08:08:24','2026-01-31 08:08:24',1),(289,'94599989-66dd-45c0-95bf-4799dd46478c','owner_id','c3ddadeb950a490db5c99da98a32c9ec','2026-01-31 08:08:00','2026-01-31 08:08:24','2026-01-31 08:08:24',1),(290,'94599989-66dd-45c0-95bf-4799dd46478c','image_state','available','2026-01-31 08:08:00','2026-01-31 08:08:24','2026-01-31 08:08:24',1),(291,'c4db27fa-394f-44cc-aad2-82f8c71ac7b7','hw_rng_model','virtio','2026-01-31 08:08:05','2026-01-31 08:08:39','2026-01-31 08:08:39',1),(292,'c4db27fa-394f-44cc-aad2-82f8c71ac7b7','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 08:08:05','2026-01-31 08:08:39','2026-01-31 08:08:39',1),(293,'c4db27fa-394f-44cc-aad2-82f8c71ac7b7','owner_user_name','tempest-ServerActionsTestOtherB-2012907318-project-member','2026-01-31 08:08:05','2026-01-31 08:08:39','2026-01-31 08:08:39',1),(294,'c4db27fa-394f-44cc-aad2-82f8c71ac7b7','owner_project_name','tempest-ServerActionsTestOtherB-2012907318','2026-01-31 08:08:05','2026-01-31 08:08:39','2026-01-31 08:08:39',1),(295,'c4db27fa-394f-44cc-aad2-82f8c71ac7b7','boot_roles','reader,member','2026-01-31 08:08:05','2026-01-31 08:08:39','2026-01-31 08:08:39',1),(296,'c4db27fa-394f-44cc-aad2-82f8c71ac7b7','hw_machine_type','q35','2026-01-31 08:08:05','2026-01-31 08:08:39','2026-01-31 08:08:39',1),(297,'c4db27fa-394f-44cc-aad2-82f8c71ac7b7','hw_cdrom_bus','sata','2026-01-31 08:08:05','2026-01-31 08:08:39','2026-01-31 08:08:39',1),(298,'c4db27fa-394f-44cc-aad2-82f8c71ac7b7','hw_disk_bus','virtio','2026-01-31 08:08:05','2026-01-31 08:08:39','2026-01-31 08:08:39',1),(299,'c4db27fa-394f-44cc-aad2-82f8c71ac7b7','hw_input_bus','usb','2026-01-31 08:08:05','2026-01-31 08:08:39','2026-01-31 08:08:39',1),(300,'c4db27fa-394f-44cc-aad2-82f8c71ac7b7','hw_pointer_model','usbtablet','2026-01-31 08:08:05','2026-01-31 08:08:39','2026-01-31 08:08:39',1),(301,'c4db27fa-394f-44cc-aad2-82f8c71ac7b7','hw_video_model','virtio','2026-01-31 08:08:05','2026-01-31 08:08:39','2026-01-31 08:08:39',1),(302,'c4db27fa-394f-44cc-aad2-82f8c71ac7b7','hw_vif_model','virtio','2026-01-31 08:08:05','2026-01-31 08:08:39','2026-01-31 08:08:39',1),(303,'c4db27fa-394f-44cc-aad2-82f8c71ac7b7','instance_uuid','1d463d8d-cbf7-43ec-8042-83d2c9aa5c69','2026-01-31 08:08:05','2026-01-31 08:08:39','2026-01-31 08:08:39',1),(304,'c4db27fa-394f-44cc-aad2-82f8c71ac7b7','user_id','18aee9d81d404f77ac81cde538f140d8','2026-01-31 08:08:05','2026-01-31 08:08:39','2026-01-31 08:08:39',1),(305,'c4db27fa-394f-44cc-aad2-82f8c71ac7b7','image_type','backup','2026-01-31 08:08:05','2026-01-31 08:08:39','2026-01-31 08:08:39',1),(306,'c4db27fa-394f-44cc-aad2-82f8c71ac7b7','backup_type','daily','2026-01-31 08:08:05','2026-01-31 08:08:39','2026-01-31 08:08:39',1),(307,'c4db27fa-394f-44cc-aad2-82f8c71ac7b7','image_location','snapshot','2026-01-31 08:08:10','2026-01-31 08:08:39','2026-01-31 08:08:39',1),(308,'c4db27fa-394f-44cc-aad2-82f8c71ac7b7','owner_id','c3ddadeb950a490db5c99da98a32c9ec','2026-01-31 08:08:11','2026-01-31 08:08:39','2026-01-31 08:08:39',1),(309,'c4db27fa-394f-44cc-aad2-82f8c71ac7b7','image_state','available','2026-01-31 08:08:11','2026-01-31 08:08:39','2026-01-31 08:08:39',1),(310,'29ae106c-3bc3-4dca-bd69-8cd8e500fc3f','hw_rng_model','virtio','2026-01-31 08:08:14','2026-01-31 08:08:30','2026-01-31 08:08:30',1),(311,'29ae106c-3bc3-4dca-bd69-8cd8e500fc3f','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 08:08:14','2026-01-31 08:08:30','2026-01-31 08:08:30',1),(312,'29ae106c-3bc3-4dca-bd69-8cd8e500fc3f','owner_user_name','tempest-ServerActionsTestOtherB-2012907318-project-member','2026-01-31 08:08:14','2026-01-31 08:08:30','2026-01-31 08:08:30',1),(313,'29ae106c-3bc3-4dca-bd69-8cd8e500fc3f','owner_project_name','tempest-ServerActionsTestOtherB-2012907318','2026-01-31 08:08:14','2026-01-31 08:08:30','2026-01-31 08:08:30',1),(314,'29ae106c-3bc3-4dca-bd69-8cd8e500fc3f','boot_roles','reader,member','2026-01-31 08:08:14','2026-01-31 08:08:30','2026-01-31 08:08:30',1),(315,'29ae106c-3bc3-4dca-bd69-8cd8e500fc3f','hw_machine_type','q35','2026-01-31 08:08:14','2026-01-31 08:08:30','2026-01-31 08:08:30',1),(316,'29ae106c-3bc3-4dca-bd69-8cd8e500fc3f','hw_cdrom_bus','sata','2026-01-31 08:08:14','2026-01-31 08:08:30','2026-01-31 08:08:30',1),(317,'29ae106c-3bc3-4dca-bd69-8cd8e500fc3f','hw_disk_bus','virtio','2026-01-31 08:08:14','2026-01-31 08:08:30','2026-01-31 08:08:30',1),(318,'29ae106c-3bc3-4dca-bd69-8cd8e500fc3f','hw_input_bus','usb','2026-01-31 08:08:14','2026-01-31 08:08:30','2026-01-31 08:08:30',1),(319,'29ae106c-3bc3-4dca-bd69-8cd8e500fc3f','hw_pointer_model','usbtablet','2026-01-31 08:08:14','2026-01-31 08:08:30','2026-01-31 08:08:30',1),(320,'29ae106c-3bc3-4dca-bd69-8cd8e500fc3f','hw_video_model','virtio','2026-01-31 08:08:14','2026-01-31 08:08:30','2026-01-31 08:08:30',1),(321,'29ae106c-3bc3-4dca-bd69-8cd8e500fc3f','hw_vif_model','virtio','2026-01-31 08:08:14','2026-01-31 08:08:30','2026-01-31 08:08:30',1),(322,'29ae106c-3bc3-4dca-bd69-8cd8e500fc3f','instance_uuid','1d463d8d-cbf7-43ec-8042-83d2c9aa5c69','2026-01-31 08:08:14','2026-01-31 08:08:30','2026-01-31 08:08:30',1),(323,'29ae106c-3bc3-4dca-bd69-8cd8e500fc3f','user_id','18aee9d81d404f77ac81cde538f140d8','2026-01-31 08:08:14','2026-01-31 08:08:30','2026-01-31 08:08:30',1),(324,'29ae106c-3bc3-4dca-bd69-8cd8e500fc3f','image_type','backup','2026-01-31 08:08:14','2026-01-31 08:08:30','2026-01-31 08:08:30',1),(325,'29ae106c-3bc3-4dca-bd69-8cd8e500fc3f','backup_type','daily','2026-01-31 08:08:14','2026-01-31 08:08:30','2026-01-31 08:08:30',1),(326,'29ae106c-3bc3-4dca-bd69-8cd8e500fc3f','image_location','snapshot','2026-01-31 08:08:20','2026-01-31 08:08:30','2026-01-31 08:08:30',1),(327,'29ae106c-3bc3-4dca-bd69-8cd8e500fc3f','owner_id','c3ddadeb950a490db5c99da98a32c9ec','2026-01-31 08:08:20','2026-01-31 08:08:30','2026-01-31 08:08:30',1),(328,'29ae106c-3bc3-4dca-bd69-8cd8e500fc3f','image_state','available','2026-01-31 08:08:20','2026-01-31 08:08:30','2026-01-31 08:08:30',1),(329,'7a74ff6f-b876-4da2-8910-2a6929d0fcbc','hw_rng_model','virtio','2026-01-31 08:11:26','2026-01-31 08:18:45','2026-01-31 08:18:45',1),(330,'7a74ff6f-b876-4da2-8910-2a6929d0fcbc','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 08:11:26','2026-01-31 08:18:45','2026-01-31 08:18:45',1),(331,'7a74ff6f-b876-4da2-8910-2a6929d0fcbc','owner_user_name','tempest-ServerStableDeviceRescueTest-569420416-project-member','2026-01-31 08:11:26','2026-01-31 08:18:45','2026-01-31 08:18:45',1),(332,'7a74ff6f-b876-4da2-8910-2a6929d0fcbc','owner_project_name','tempest-ServerStableDeviceRescueTest-569420416','2026-01-31 08:11:26','2026-01-31 08:18:45','2026-01-31 08:18:45',1),(333,'7a74ff6f-b876-4da2-8910-2a6929d0fcbc','boot_roles','reader,member','2026-01-31 08:11:26','2026-01-31 08:18:45','2026-01-31 08:18:45',1),(334,'7a74ff6f-b876-4da2-8910-2a6929d0fcbc','hw_machine_type','q35','2026-01-31 08:11:26','2026-01-31 08:18:45','2026-01-31 08:18:45',1),(335,'7a74ff6f-b876-4da2-8910-2a6929d0fcbc','hw_cdrom_bus','sata','2026-01-31 08:11:26','2026-01-31 08:18:45','2026-01-31 08:18:45',1),(336,'7a74ff6f-b876-4da2-8910-2a6929d0fcbc','hw_disk_bus','virtio','2026-01-31 08:11:26','2026-01-31 08:18:45','2026-01-31 08:18:45',1),(337,'7a74ff6f-b876-4da2-8910-2a6929d0fcbc','hw_input_bus','usb','2026-01-31 08:11:26','2026-01-31 08:18:45','2026-01-31 08:18:45',1),(338,'7a74ff6f-b876-4da2-8910-2a6929d0fcbc','hw_pointer_model','usbtablet','2026-01-31 08:11:26','2026-01-31 08:18:45','2026-01-31 08:18:45',1),(339,'7a74ff6f-b876-4da2-8910-2a6929d0fcbc','hw_video_model','virtio','2026-01-31 08:11:26','2026-01-31 08:18:45','2026-01-31 08:18:45',1),(340,'7a74ff6f-b876-4da2-8910-2a6929d0fcbc','hw_vif_model','virtio','2026-01-31 08:11:26','2026-01-31 08:18:45','2026-01-31 08:18:45',1),(341,'7a74ff6f-b876-4da2-8910-2a6929d0fcbc','instance_uuid','981eb990-ec0c-4673-98e7-102afbe0bb51','2026-01-31 08:11:26','2026-01-31 08:18:45','2026-01-31 08:18:45',1),(342,'7a74ff6f-b876-4da2-8910-2a6929d0fcbc','user_id','d7d9a44201d548aba1e1654e136ddd06','2026-01-31 08:11:26','2026-01-31 08:18:45','2026-01-31 08:18:45',1),(343,'7a74ff6f-b876-4da2-8910-2a6929d0fcbc','image_type','snapshot','2026-01-31 08:11:26','2026-01-31 08:18:45','2026-01-31 08:18:45',1),(344,'7a74ff6f-b876-4da2-8910-2a6929d0fcbc','image_location','snapshot','2026-01-31 08:11:32','2026-01-31 08:18:45','2026-01-31 08:18:45',1),(345,'7a74ff6f-b876-4da2-8910-2a6929d0fcbc','owner_id','1633c84ea1bf46b080aaafd30bbcf25f','2026-01-31 08:11:32','2026-01-31 08:18:45','2026-01-31 08:18:45',1),(346,'7a74ff6f-b876-4da2-8910-2a6929d0fcbc','image_state','available','2026-01-31 08:11:32','2026-01-31 08:18:45','2026-01-31 08:18:45',1),(347,'7a74ff6f-b876-4da2-8910-2a6929d0fcbc','hw_rescue_bus','scsi','2026-01-31 08:11:38','2026-01-31 08:18:45','2026-01-31 08:18:45',1),(348,'7a74ff6f-b876-4da2-8910-2a6929d0fcbc','hw_rescue_device','disk','2026-01-31 08:11:39','2026-01-31 08:18:45','2026-01-31 08:18:45',1),(349,'ae58104d-ec03-4878-8203-221e83ac3a09','hw_rng_model','virtio','2026-01-31 08:12:37','2026-01-31 08:18:33','2026-01-31 08:18:33',1),(350,'ae58104d-ec03-4878-8203-221e83ac3a09','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 08:12:37','2026-01-31 08:18:33','2026-01-31 08:18:33',1),(351,'ae58104d-ec03-4878-8203-221e83ac3a09','owner_user_name','tempest-ServerStableDeviceRescueTest-569420416-project-member','2026-01-31 08:12:37','2026-01-31 08:18:33','2026-01-31 08:18:33',1),(352,'ae58104d-ec03-4878-8203-221e83ac3a09','owner_project_name','tempest-ServerStableDeviceRescueTest-569420416','2026-01-31 08:12:37','2026-01-31 08:18:33','2026-01-31 08:18:33',1),(353,'ae58104d-ec03-4878-8203-221e83ac3a09','boot_roles','member,reader','2026-01-31 08:12:37','2026-01-31 08:18:33','2026-01-31 08:18:33',1),(354,'ae58104d-ec03-4878-8203-221e83ac3a09','hw_machine_type','q35','2026-01-31 08:12:37','2026-01-31 08:18:33','2026-01-31 08:18:33',1),(355,'ae58104d-ec03-4878-8203-221e83ac3a09','hw_cdrom_bus','sata','2026-01-31 08:12:37','2026-01-31 08:18:33','2026-01-31 08:18:33',1),(356,'ae58104d-ec03-4878-8203-221e83ac3a09','hw_disk_bus','virtio','2026-01-31 08:12:37','2026-01-31 08:18:33','2026-01-31 08:18:33',1),(357,'ae58104d-ec03-4878-8203-221e83ac3a09','hw_input_bus','usb','2026-01-31 08:12:37','2026-01-31 08:18:33','2026-01-31 08:18:33',1),(358,'ae58104d-ec03-4878-8203-221e83ac3a09','hw_pointer_model','usbtablet','2026-01-31 08:12:37','2026-01-31 08:18:33','2026-01-31 08:18:33',1),(359,'ae58104d-ec03-4878-8203-221e83ac3a09','hw_video_model','virtio','2026-01-31 08:12:37','2026-01-31 08:18:33','2026-01-31 08:18:33',1),(360,'ae58104d-ec03-4878-8203-221e83ac3a09','hw_vif_model','virtio','2026-01-31 08:12:37','2026-01-31 08:18:33','2026-01-31 08:18:33',1),(361,'ae58104d-ec03-4878-8203-221e83ac3a09','instance_uuid','518d36e7-b77a-415d-bd48-f53e637ed0d8','2026-01-31 08:12:37','2026-01-31 08:18:33','2026-01-31 08:18:33',1),(362,'ae58104d-ec03-4878-8203-221e83ac3a09','user_id','d7d9a44201d548aba1e1654e136ddd06','2026-01-31 08:12:37','2026-01-31 08:18:33','2026-01-31 08:18:33',1),(363,'ae58104d-ec03-4878-8203-221e83ac3a09','image_type','snapshot','2026-01-31 08:12:37','2026-01-31 08:18:33','2026-01-31 08:18:33',1),(364,'ae58104d-ec03-4878-8203-221e83ac3a09','image_location','snapshot','2026-01-31 08:12:43','2026-01-31 08:18:33','2026-01-31 08:18:33',1),(365,'ae58104d-ec03-4878-8203-221e83ac3a09','owner_id','1633c84ea1bf46b080aaafd30bbcf25f','2026-01-31 08:12:43','2026-01-31 08:18:33','2026-01-31 08:18:33',1),(366,'ae58104d-ec03-4878-8203-221e83ac3a09','image_state','available','2026-01-31 08:12:43','2026-01-31 08:18:33','2026-01-31 08:18:33',1),(367,'ae58104d-ec03-4878-8203-221e83ac3a09','hw_rescue_bus','usb','2026-01-31 08:12:49','2026-01-31 08:18:33','2026-01-31 08:18:33',1),(368,'ae58104d-ec03-4878-8203-221e83ac3a09','hw_rescue_device','disk','2026-01-31 08:12:50','2026-01-31 08:18:33','2026-01-31 08:18:33',1),(369,'5df2a010-0131-4bd4-8096-45b6ac756af0','hw_rng_model','virtio','2026-01-31 08:13:59','2026-01-31 08:18:20','2026-01-31 08:18:20',1),(370,'5df2a010-0131-4bd4-8096-45b6ac756af0','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 08:13:59','2026-01-31 08:18:20','2026-01-31 08:18:20',1),(371,'5df2a010-0131-4bd4-8096-45b6ac756af0','owner_user_name','tempest-ServerStableDeviceRescueTest-569420416-project-member','2026-01-31 08:13:59','2026-01-31 08:18:20','2026-01-31 08:18:20',1),(372,'5df2a010-0131-4bd4-8096-45b6ac756af0','owner_project_name','tempest-ServerStableDeviceRescueTest-569420416','2026-01-31 08:13:59','2026-01-31 08:18:20','2026-01-31 08:18:20',1),(373,'5df2a010-0131-4bd4-8096-45b6ac756af0','boot_roles','member,reader','2026-01-31 08:13:59','2026-01-31 08:18:20','2026-01-31 08:18:20',1),(374,'5df2a010-0131-4bd4-8096-45b6ac756af0','hw_machine_type','q35','2026-01-31 08:13:59','2026-01-31 08:18:20','2026-01-31 08:18:20',1),(375,'5df2a010-0131-4bd4-8096-45b6ac756af0','hw_cdrom_bus','sata','2026-01-31 08:13:59','2026-01-31 08:18:20','2026-01-31 08:18:20',1),(376,'5df2a010-0131-4bd4-8096-45b6ac756af0','hw_disk_bus','virtio','2026-01-31 08:13:59','2026-01-31 08:18:20','2026-01-31 08:18:20',1),(377,'5df2a010-0131-4bd4-8096-45b6ac756af0','hw_input_bus','usb','2026-01-31 08:13:59','2026-01-31 08:18:20','2026-01-31 08:18:20',1),(378,'5df2a010-0131-4bd4-8096-45b6ac756af0','hw_pointer_model','usbtablet','2026-01-31 08:13:59','2026-01-31 08:18:20','2026-01-31 08:18:20',1),(379,'5df2a010-0131-4bd4-8096-45b6ac756af0','hw_video_model','virtio','2026-01-31 08:13:59','2026-01-31 08:18:20','2026-01-31 08:18:20',1),(380,'5df2a010-0131-4bd4-8096-45b6ac756af0','hw_vif_model','virtio','2026-01-31 08:13:59','2026-01-31 08:18:20','2026-01-31 08:18:20',1),(381,'5df2a010-0131-4bd4-8096-45b6ac756af0','instance_uuid','9fac8a1f-1f12-41c8-81b6-59c0bf962590','2026-01-31 08:13:59','2026-01-31 08:18:20','2026-01-31 08:18:20',1),(382,'5df2a010-0131-4bd4-8096-45b6ac756af0','user_id','d7d9a44201d548aba1e1654e136ddd06','2026-01-31 08:13:59','2026-01-31 08:18:20','2026-01-31 08:18:20',1),(383,'5df2a010-0131-4bd4-8096-45b6ac756af0','image_type','snapshot','2026-01-31 08:13:59','2026-01-31 08:18:20','2026-01-31 08:18:20',1),(384,'d7589e47-590e-4196-b561-0595216f339a','hw_rng_model','virtio','2026-01-31 08:14:07','2026-01-31 08:15:36','2026-01-31 08:15:36',1),(385,'d7589e47-590e-4196-b561-0595216f339a','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 08:14:07','2026-01-31 08:15:36','2026-01-31 08:15:36',1),(386,'d7589e47-590e-4196-b561-0595216f339a','owner_user_name','tempest-ServerActionsTestOtherB-2012907318-project-member','2026-01-31 08:14:07','2026-01-31 08:15:36','2026-01-31 08:15:36',1),(387,'d7589e47-590e-4196-b561-0595216f339a','owner_project_name','tempest-ServerActionsTestOtherB-2012907318','2026-01-31 08:14:07','2026-01-31 08:15:36','2026-01-31 08:15:36',1),(388,'d7589e47-590e-4196-b561-0595216f339a','boot_roles','member,reader','2026-01-31 08:14:07','2026-01-31 08:15:36','2026-01-31 08:15:36',1),(389,'d7589e47-590e-4196-b561-0595216f339a','hw_machine_type','q35','2026-01-31 08:14:07','2026-01-31 08:15:36','2026-01-31 08:15:36',1),(390,'d7589e47-590e-4196-b561-0595216f339a','hw_cdrom_bus','sata','2026-01-31 08:14:07','2026-01-31 08:15:36','2026-01-31 08:15:36',1),(391,'d7589e47-590e-4196-b561-0595216f339a','hw_disk_bus','virtio','2026-01-31 08:14:07','2026-01-31 08:15:36','2026-01-31 08:15:36',1),(392,'d7589e47-590e-4196-b561-0595216f339a','hw_input_bus','usb','2026-01-31 08:14:07','2026-01-31 08:15:36','2026-01-31 08:15:36',1),(393,'d7589e47-590e-4196-b561-0595216f339a','hw_pointer_model','usbtablet','2026-01-31 08:14:07','2026-01-31 08:15:36','2026-01-31 08:15:36',1),(394,'d7589e47-590e-4196-b561-0595216f339a','hw_video_model','virtio','2026-01-31 08:14:07','2026-01-31 08:15:36','2026-01-31 08:15:36',1),(395,'d7589e47-590e-4196-b561-0595216f339a','hw_vif_model','virtio','2026-01-31 08:14:07','2026-01-31 08:15:36','2026-01-31 08:15:36',1),(396,'d7589e47-590e-4196-b561-0595216f339a','instance_uuid','966eef30-6a53-4f56-a48f-d9c2b4348db8','2026-01-31 08:14:07','2026-01-31 08:15:36','2026-01-31 08:15:36',1),(397,'d7589e47-590e-4196-b561-0595216f339a','user_id','18aee9d81d404f77ac81cde538f140d8','2026-01-31 08:14:07','2026-01-31 08:15:36','2026-01-31 08:15:36',1),(398,'d7589e47-590e-4196-b561-0595216f339a','image_type','snapshot','2026-01-31 08:14:07','2026-01-31 08:15:36','2026-01-31 08:15:36',1),(399,'5df2a010-0131-4bd4-8096-45b6ac756af0','image_location','snapshot','2026-01-31 08:14:21','2026-01-31 08:18:20','2026-01-31 08:18:20',1),(400,'5df2a010-0131-4bd4-8096-45b6ac756af0','owner_id','1633c84ea1bf46b080aaafd30bbcf25f','2026-01-31 08:14:21','2026-01-31 08:18:20','2026-01-31 08:18:20',1),(401,'5df2a010-0131-4bd4-8096-45b6ac756af0','image_state','available','2026-01-31 08:14:21','2026-01-31 08:18:20','2026-01-31 08:18:20',1),(402,'d7589e47-590e-4196-b561-0595216f339a','owner_id','c3ddadeb950a490db5c99da98a32c9ec','2026-01-31 08:14:27','2026-01-31 08:15:36','2026-01-31 08:15:36',1),(403,'d7589e47-590e-4196-b561-0595216f339a','image_location','snapshot','2026-01-31 08:14:27','2026-01-31 08:15:36','2026-01-31 08:15:36',1),(404,'d7589e47-590e-4196-b561-0595216f339a','image_state','available','2026-01-31 08:14:27','2026-01-31 08:15:36','2026-01-31 08:15:36',1),(405,'5df2a010-0131-4bd4-8096-45b6ac756af0','hw_rescue_bus','virtio','2026-01-31 08:14:30','2026-01-31 08:18:20','2026-01-31 08:18:20',1),(406,'5df2a010-0131-4bd4-8096-45b6ac756af0','hw_rescue_device','disk','2026-01-31 08:14:31','2026-01-31 08:18:20','2026-01-31 08:18:20',1),(407,'70966e79-230e-420e-aa68-b04da70a01e2','hw_rng_model','virtio','2026-01-31 08:14:44','2026-01-31 08:15:29','2026-01-31 08:15:29',1),(408,'70966e79-230e-420e-aa68-b04da70a01e2','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 08:14:44','2026-01-31 08:15:29','2026-01-31 08:15:29',1),(409,'70966e79-230e-420e-aa68-b04da70a01e2','owner_user_name','tempest-ServerActionsTestOtherB-2012907318-project-member','2026-01-31 08:14:44','2026-01-31 08:15:29','2026-01-31 08:15:29',1),(410,'70966e79-230e-420e-aa68-b04da70a01e2','owner_project_name','tempest-ServerActionsTestOtherB-2012907318','2026-01-31 08:14:44','2026-01-31 08:15:29','2026-01-31 08:15:29',1),(411,'70966e79-230e-420e-aa68-b04da70a01e2','boot_roles','member,reader','2026-01-31 08:14:44','2026-01-31 08:15:29','2026-01-31 08:15:29',1),(412,'70966e79-230e-420e-aa68-b04da70a01e2','hw_machine_type','q35','2026-01-31 08:14:44','2026-01-31 08:15:29','2026-01-31 08:15:29',1),(413,'70966e79-230e-420e-aa68-b04da70a01e2','hw_cdrom_bus','sata','2026-01-31 08:14:44','2026-01-31 08:15:29','2026-01-31 08:15:29',1),(414,'70966e79-230e-420e-aa68-b04da70a01e2','hw_disk_bus','virtio','2026-01-31 08:14:44','2026-01-31 08:15:29','2026-01-31 08:15:29',1),(415,'70966e79-230e-420e-aa68-b04da70a01e2','hw_input_bus','usb','2026-01-31 08:14:44','2026-01-31 08:15:29','2026-01-31 08:15:29',1),(416,'70966e79-230e-420e-aa68-b04da70a01e2','hw_pointer_model','usbtablet','2026-01-31 08:14:44','2026-01-31 08:15:29','2026-01-31 08:15:29',1),(417,'70966e79-230e-420e-aa68-b04da70a01e2','hw_video_model','virtio','2026-01-31 08:14:44','2026-01-31 08:15:29','2026-01-31 08:15:29',1),(418,'70966e79-230e-420e-aa68-b04da70a01e2','hw_vif_model','virtio','2026-01-31 08:14:44','2026-01-31 08:15:29','2026-01-31 08:15:29',1),(419,'70966e79-230e-420e-aa68-b04da70a01e2','instance_uuid','5a59388d-bade-4df0-9ac0-0022df15ea02','2026-01-31 08:14:44','2026-01-31 08:15:29','2026-01-31 08:15:29',1),(420,'70966e79-230e-420e-aa68-b04da70a01e2','user_id','18aee9d81d404f77ac81cde538f140d8','2026-01-31 08:14:44','2026-01-31 08:15:29','2026-01-31 08:15:29',1),(421,'70966e79-230e-420e-aa68-b04da70a01e2','image_type','snapshot','2026-01-31 08:14:44','2026-01-31 08:15:29','2026-01-31 08:15:29',1),(422,'70966e79-230e-420e-aa68-b04da70a01e2','owner_id','c3ddadeb950a490db5c99da98a32c9ec','2026-01-31 08:14:52','2026-01-31 08:15:29','2026-01-31 08:15:29',1),(423,'70966e79-230e-420e-aa68-b04da70a01e2','image_location','snapshot','2026-01-31 08:14:52','2026-01-31 08:15:29','2026-01-31 08:15:29',1),(424,'70966e79-230e-420e-aa68-b04da70a01e2','image_state','available','2026-01-31 08:14:52','2026-01-31 08:15:29','2026-01-31 08:15:29',1),(425,'2ca7a053-cec0-4d6e-8cfb-6697bc58e21c','hw_rng_model','virtio','2026-01-31 08:16:19','2026-01-31 08:18:02','2026-01-31 08:18:02',1),(426,'2ca7a053-cec0-4d6e-8cfb-6697bc58e21c','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 08:16:19','2026-01-31 08:18:02','2026-01-31 08:18:02',1),(427,'2ca7a053-cec0-4d6e-8cfb-6697bc58e21c','owner_user_name','tempest-ServerStableDeviceRescueTest-569420416-project-member','2026-01-31 08:16:19','2026-01-31 08:18:02','2026-01-31 08:18:02',1),(428,'2ca7a053-cec0-4d6e-8cfb-6697bc58e21c','owner_project_name','tempest-ServerStableDeviceRescueTest-569420416','2026-01-31 08:16:19','2026-01-31 08:18:02','2026-01-31 08:18:02',1),(429,'2ca7a053-cec0-4d6e-8cfb-6697bc58e21c','boot_roles','reader,member','2026-01-31 08:16:19','2026-01-31 08:18:02','2026-01-31 08:18:02',1),(430,'2ca7a053-cec0-4d6e-8cfb-6697bc58e21c','hw_machine_type','q35','2026-01-31 08:16:19','2026-01-31 08:18:02','2026-01-31 08:18:02',1),(431,'2ca7a053-cec0-4d6e-8cfb-6697bc58e21c','hw_cdrom_bus','sata','2026-01-31 08:16:19','2026-01-31 08:18:02','2026-01-31 08:18:02',1),(432,'2ca7a053-cec0-4d6e-8cfb-6697bc58e21c','hw_disk_bus','virtio','2026-01-31 08:16:19','2026-01-31 08:18:02','2026-01-31 08:18:02',1),(433,'2ca7a053-cec0-4d6e-8cfb-6697bc58e21c','hw_input_bus','usb','2026-01-31 08:16:19','2026-01-31 08:18:02','2026-01-31 08:18:02',1),(434,'2ca7a053-cec0-4d6e-8cfb-6697bc58e21c','hw_pointer_model','usbtablet','2026-01-31 08:16:19','2026-01-31 08:18:02','2026-01-31 08:18:02',1),(435,'2ca7a053-cec0-4d6e-8cfb-6697bc58e21c','hw_video_model','virtio','2026-01-31 08:16:19','2026-01-31 08:18:03','2026-01-31 08:18:03',1),(436,'2ca7a053-cec0-4d6e-8cfb-6697bc58e21c','hw_vif_model','virtio','2026-01-31 08:16:19','2026-01-31 08:18:03','2026-01-31 08:18:03',1),(437,'2ca7a053-cec0-4d6e-8cfb-6697bc58e21c','instance_uuid','743cf933-3139-4c25-9c75-b45150274ae3','2026-01-31 08:16:19','2026-01-31 08:18:03','2026-01-31 08:18:03',1),(438,'2ca7a053-cec0-4d6e-8cfb-6697bc58e21c','user_id','d7d9a44201d548aba1e1654e136ddd06','2026-01-31 08:16:19','2026-01-31 08:18:03','2026-01-31 08:18:03',1),(439,'2ca7a053-cec0-4d6e-8cfb-6697bc58e21c','image_type','snapshot','2026-01-31 08:16:19','2026-01-31 08:18:03','2026-01-31 08:18:03',1),(440,'2ca7a053-cec0-4d6e-8cfb-6697bc58e21c','image_location','snapshot','2026-01-31 08:16:28','2026-01-31 08:18:03','2026-01-31 08:18:03',1),(441,'2ca7a053-cec0-4d6e-8cfb-6697bc58e21c','owner_id','1633c84ea1bf46b080aaafd30bbcf25f','2026-01-31 08:16:28','2026-01-31 08:18:03','2026-01-31 08:18:03',1),(442,'2ca7a053-cec0-4d6e-8cfb-6697bc58e21c','image_state','available','2026-01-31 08:16:28','2026-01-31 08:18:03','2026-01-31 08:18:03',1),(443,'2ca7a053-cec0-4d6e-8cfb-6697bc58e21c','hw_rescue_bus','virtio','2026-01-31 08:16:32','2026-01-31 08:18:03','2026-01-31 08:18:03',1),(444,'2ca7a053-cec0-4d6e-8cfb-6697bc58e21c','hw_rescue_device','disk','2026-01-31 08:16:33','2026-01-31 08:18:03','2026-01-31 08:18:03',1),(445,'9d458b54-ba05-4df1-8123-8bec7fac57ca','hw_rng_model','virtio','2026-01-31 08:17:15','2026-01-31 08:18:03','2026-01-31 08:18:03',1),(446,'9d458b54-ba05-4df1-8123-8bec7fac57ca','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 08:17:15','2026-01-31 08:18:03','2026-01-31 08:18:03',1),(447,'9d458b54-ba05-4df1-8123-8bec7fac57ca','owner_user_name','tempest-AttachVolumeShelveTestJSON-332944999-project-member','2026-01-31 08:17:15','2026-01-31 08:18:03','2026-01-31 08:18:03',1),(448,'9d458b54-ba05-4df1-8123-8bec7fac57ca','owner_project_name','tempest-AttachVolumeShelveTestJSON-332944999','2026-01-31 08:17:15','2026-01-31 08:18:03','2026-01-31 08:18:03',1),(449,'9d458b54-ba05-4df1-8123-8bec7fac57ca','boot_roles','reader,member','2026-01-31 08:17:15','2026-01-31 08:18:03','2026-01-31 08:18:03',1),(450,'9d458b54-ba05-4df1-8123-8bec7fac57ca','hw_machine_type','q35','2026-01-31 08:17:15','2026-01-31 08:18:03','2026-01-31 08:18:03',1),(451,'9d458b54-ba05-4df1-8123-8bec7fac57ca','hw_cdrom_bus','sata','2026-01-31 08:17:15','2026-01-31 08:18:03','2026-01-31 08:18:03',1),(452,'9d458b54-ba05-4df1-8123-8bec7fac57ca','hw_disk_bus','virtio','2026-01-31 08:17:15','2026-01-31 08:18:03','2026-01-31 08:18:03',1),(453,'9d458b54-ba05-4df1-8123-8bec7fac57ca','hw_input_bus','usb','2026-01-31 08:17:15','2026-01-31 08:18:03','2026-01-31 08:18:03',1),(454,'9d458b54-ba05-4df1-8123-8bec7fac57ca','hw_pointer_model','usbtablet','2026-01-31 08:17:15','2026-01-31 08:18:03','2026-01-31 08:18:03',1),(455,'9d458b54-ba05-4df1-8123-8bec7fac57ca','hw_video_model','virtio','2026-01-31 08:17:15','2026-01-31 08:18:03','2026-01-31 08:18:03',1),(456,'9d458b54-ba05-4df1-8123-8bec7fac57ca','hw_vif_model','virtio','2026-01-31 08:17:15','2026-01-31 08:18:03','2026-01-31 08:18:03',1),(457,'9d458b54-ba05-4df1-8123-8bec7fac57ca','instance_uuid','2c1aa7ad-f9c1-4e05-8261-defaa3eef40b','2026-01-31 08:17:15','2026-01-31 08:18:03','2026-01-31 08:18:03',1),(458,'9d458b54-ba05-4df1-8123-8bec7fac57ca','user_id','3b153d2832404e5b9250422b70ba522d','2026-01-31 08:17:15','2026-01-31 08:18:03','2026-01-31 08:18:03',1),(459,'9d458b54-ba05-4df1-8123-8bec7fac57ca','image_type','snapshot','2026-01-31 08:17:15','2026-01-31 08:18:03','2026-01-31 08:18:03',1),(460,'9d458b54-ba05-4df1-8123-8bec7fac57ca','owner_id','3b06982960ad4453b8e542cb6330835d','2026-01-31 08:17:26','2026-01-31 08:18:03','2026-01-31 08:18:03',1),(461,'9d458b54-ba05-4df1-8123-8bec7fac57ca','image_location','snapshot','2026-01-31 08:17:26','2026-01-31 08:18:03','2026-01-31 08:18:03',1),(462,'9d458b54-ba05-4df1-8123-8bec7fac57ca','image_state','available','2026-01-31 08:17:26','2026-01-31 08:18:03','2026-01-31 08:18:03',1),(463,'d312ef25-f354-483d-8db4-8f428dbab83b','hw_rng_model','virtio','2026-01-31 08:19:31','2026-01-31 08:19:32','2026-01-31 08:19:32',1),(464,'d312ef25-f354-483d-8db4-8f428dbab83b','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 08:19:31','2026-01-31 08:19:32','2026-01-31 08:19:32',1),(465,'d312ef25-f354-483d-8db4-8f428dbab83b','owner_user_name','tempest-ServersAaction247Test-1991115500-project-member','2026-01-31 08:19:31','2026-01-31 08:19:32','2026-01-31 08:19:32',1),(466,'d312ef25-f354-483d-8db4-8f428dbab83b','owner_project_name','tempest-ServersAaction247Test-1991115500','2026-01-31 08:19:31','2026-01-31 08:19:32','2026-01-31 08:19:32',1),(467,'d312ef25-f354-483d-8db4-8f428dbab83b','boot_roles','member,reader','2026-01-31 08:19:31','2026-01-31 08:19:32','2026-01-31 08:19:32',1),(468,'d312ef25-f354-483d-8db4-8f428dbab83b','hw_machine_type','q35','2026-01-31 08:19:31','2026-01-31 08:19:32','2026-01-31 08:19:32',1),(469,'d312ef25-f354-483d-8db4-8f428dbab83b','hw_cdrom_bus','sata','2026-01-31 08:19:31','2026-01-31 08:19:32','2026-01-31 08:19:32',1),(470,'d312ef25-f354-483d-8db4-8f428dbab83b','hw_disk_bus','virtio','2026-01-31 08:19:31','2026-01-31 08:19:32','2026-01-31 08:19:32',1),(471,'d312ef25-f354-483d-8db4-8f428dbab83b','hw_input_bus','usb','2026-01-31 08:19:31','2026-01-31 08:19:32','2026-01-31 08:19:32',1),(472,'d312ef25-f354-483d-8db4-8f428dbab83b','hw_pointer_model','usbtablet','2026-01-31 08:19:31','2026-01-31 08:19:32','2026-01-31 08:19:32',1),(473,'d312ef25-f354-483d-8db4-8f428dbab83b','hw_video_model','virtio','2026-01-31 08:19:31','2026-01-31 08:19:32','2026-01-31 08:19:32',1),(474,'d312ef25-f354-483d-8db4-8f428dbab83b','hw_vif_model','virtio','2026-01-31 08:19:31','2026-01-31 08:19:32','2026-01-31 08:19:32',1),(475,'d312ef25-f354-483d-8db4-8f428dbab83b','instance_uuid','e10c32ff-8ad4-41d6-9f1c-81e52bd41fb8','2026-01-31 08:19:31','2026-01-31 08:19:32','2026-01-31 08:19:32',1),(476,'d312ef25-f354-483d-8db4-8f428dbab83b','user_id','35ab955828314bdc9adf0dff227f0b71','2026-01-31 08:19:31','2026-01-31 08:19:32','2026-01-31 08:19:32',1),(477,'d312ef25-f354-483d-8db4-8f428dbab83b','image_type','backup','2026-01-31 08:19:31','2026-01-31 08:19:32','2026-01-31 08:19:32',1),(478,'d312ef25-f354-483d-8db4-8f428dbab83b','backup_type','daily','2026-01-31 08:19:31','2026-01-31 08:19:32','2026-01-31 08:19:32',1),(479,'5b5ac3f7-b093-4152-83a1-6cb8fa870d17','hw_rng_model','virtio','2026-01-31 08:19:36','2026-01-31 08:20:21','2026-01-31 08:20:21',1),(480,'5b5ac3f7-b093-4152-83a1-6cb8fa870d17','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 08:19:36','2026-01-31 08:20:21','2026-01-31 08:20:21',1),(481,'5b5ac3f7-b093-4152-83a1-6cb8fa870d17','owner_user_name','tempest-AttachVolumeShelveTestJSON-332944999-project-member','2026-01-31 08:19:36','2026-01-31 08:20:21','2026-01-31 08:20:21',1),(482,'5b5ac3f7-b093-4152-83a1-6cb8fa870d17','owner_project_name','tempest-AttachVolumeShelveTestJSON-332944999','2026-01-31 08:19:36','2026-01-31 08:20:21','2026-01-31 08:20:21',1),(483,'5b5ac3f7-b093-4152-83a1-6cb8fa870d17','boot_roles','member,reader','2026-01-31 08:19:36','2026-01-31 08:20:21','2026-01-31 08:20:21',1),(484,'5b5ac3f7-b093-4152-83a1-6cb8fa870d17','hw_machine_type','q35','2026-01-31 08:19:36','2026-01-31 08:20:21','2026-01-31 08:20:21',1),(485,'5b5ac3f7-b093-4152-83a1-6cb8fa870d17','hw_cdrom_bus','sata','2026-01-31 08:19:36','2026-01-31 08:20:21','2026-01-31 08:20:21',1),(486,'5b5ac3f7-b093-4152-83a1-6cb8fa870d17','hw_disk_bus','virtio','2026-01-31 08:19:36','2026-01-31 08:20:21','2026-01-31 08:20:21',1),(487,'5b5ac3f7-b093-4152-83a1-6cb8fa870d17','hw_input_bus','usb','2026-01-31 08:19:36','2026-01-31 08:20:21','2026-01-31 08:20:21',1),(488,'5b5ac3f7-b093-4152-83a1-6cb8fa870d17','hw_pointer_model','usbtablet','2026-01-31 08:19:36','2026-01-31 08:20:21','2026-01-31 08:20:21',1),(489,'5b5ac3f7-b093-4152-83a1-6cb8fa870d17','hw_video_model','virtio','2026-01-31 08:19:36','2026-01-31 08:20:21','2026-01-31 08:20:21',1),(490,'5b5ac3f7-b093-4152-83a1-6cb8fa870d17','hw_vif_model','virtio','2026-01-31 08:19:36','2026-01-31 08:20:21','2026-01-31 08:20:21',1),(491,'5b5ac3f7-b093-4152-83a1-6cb8fa870d17','instance_uuid','ac849bdd-07a0-459f-b207-2a3f239d0272','2026-01-31 08:19:36','2026-01-31 08:20:21','2026-01-31 08:20:21',1),(492,'5b5ac3f7-b093-4152-83a1-6cb8fa870d17','user_id','3b153d2832404e5b9250422b70ba522d','2026-01-31 08:19:36','2026-01-31 08:20:21','2026-01-31 08:20:21',1),(493,'5b5ac3f7-b093-4152-83a1-6cb8fa870d17','image_type','snapshot','2026-01-31 08:19:36','2026-01-31 08:20:21','2026-01-31 08:20:21',1),(494,'5b5ac3f7-b093-4152-83a1-6cb8fa870d17','image_location','snapshot','2026-01-31 08:19:49','2026-01-31 08:20:21','2026-01-31 08:20:21',1),(495,'5b5ac3f7-b093-4152-83a1-6cb8fa870d17','owner_id','3b06982960ad4453b8e542cb6330835d','2026-01-31 08:19:49','2026-01-31 08:20:21','2026-01-31 08:20:21',1),(496,'5b5ac3f7-b093-4152-83a1-6cb8fa870d17','image_state','available','2026-01-31 08:19:49','2026-01-31 08:20:21','2026-01-31 08:20:21',1),(497,'af02be56-bd6f-4200-837f-ea1f7e8d93ec','hw_rng_model','virtio','2026-01-31 08:21:12','2026-01-31 08:24:59','2026-01-31 08:24:59',1),(498,'af02be56-bd6f-4200-837f-ea1f7e8d93ec','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 08:21:12','2026-01-31 08:24:59','2026-01-31 08:24:59',1),(499,'af02be56-bd6f-4200-837f-ea1f7e8d93ec','owner_user_name','tempest-ServerBootFromVolumeStableRescueTest-1116995694-project-member','2026-01-31 08:21:12','2026-01-31 08:24:59','2026-01-31 08:24:59',1),(500,'af02be56-bd6f-4200-837f-ea1f7e8d93ec','owner_project_name','tempest-ServerBootFromVolumeStableRescueTest-1116995694','2026-01-31 08:21:12','2026-01-31 08:24:59','2026-01-31 08:24:59',1),(501,'af02be56-bd6f-4200-837f-ea1f7e8d93ec','boot_roles','member,reader','2026-01-31 08:21:12','2026-01-31 08:24:59','2026-01-31 08:24:59',1),(502,'af02be56-bd6f-4200-837f-ea1f7e8d93ec','hw_machine_type','q35','2026-01-31 08:21:12','2026-01-31 08:24:59','2026-01-31 08:24:59',1),(503,'af02be56-bd6f-4200-837f-ea1f7e8d93ec','hw_cdrom_bus','sata','2026-01-31 08:21:12','2026-01-31 08:24:59','2026-01-31 08:24:59',1),(504,'af02be56-bd6f-4200-837f-ea1f7e8d93ec','hw_disk_bus','virtio','2026-01-31 08:21:12','2026-01-31 08:24:59','2026-01-31 08:24:59',1),(505,'af02be56-bd6f-4200-837f-ea1f7e8d93ec','hw_input_bus','usb','2026-01-31 08:21:12','2026-01-31 08:24:59','2026-01-31 08:24:59',1),(506,'af02be56-bd6f-4200-837f-ea1f7e8d93ec','hw_pointer_model','usbtablet','2026-01-31 08:21:12','2026-01-31 08:24:59','2026-01-31 08:24:59',1),(507,'af02be56-bd6f-4200-837f-ea1f7e8d93ec','hw_video_model','virtio','2026-01-31 08:21:12','2026-01-31 08:24:59','2026-01-31 08:24:59',1),(508,'af02be56-bd6f-4200-837f-ea1f7e8d93ec','hw_vif_model','virtio','2026-01-31 08:21:12','2026-01-31 08:24:59','2026-01-31 08:24:59',1),(509,'af02be56-bd6f-4200-837f-ea1f7e8d93ec','instance_uuid','e8e7a13f-a648-45dc-b768-ac5deac97083','2026-01-31 08:21:12','2026-01-31 08:24:59','2026-01-31 08:24:59',1),(510,'af02be56-bd6f-4200-837f-ea1f7e8d93ec','user_id','038e2b3b4f174162a3ac6c4870857e60','2026-01-31 08:21:12','2026-01-31 08:24:59','2026-01-31 08:24:59',1),(511,'af02be56-bd6f-4200-837f-ea1f7e8d93ec','image_type','snapshot','2026-01-31 08:21:12','2026-01-31 08:24:59','2026-01-31 08:24:59',1),(512,'af02be56-bd6f-4200-837f-ea1f7e8d93ec','owner_id','c90ea7f1be5f484bb873548236fadc00','2026-01-31 08:21:16','2026-01-31 08:24:59','2026-01-31 08:24:59',1),(513,'af02be56-bd6f-4200-837f-ea1f7e8d93ec','image_location','snapshot','2026-01-31 08:21:16','2026-01-31 08:24:59','2026-01-31 08:24:59',1),(514,'af02be56-bd6f-4200-837f-ea1f7e8d93ec','image_state','available','2026-01-31 08:21:16','2026-01-31 08:24:59','2026-01-31 08:24:59',1),(515,'af02be56-bd6f-4200-837f-ea1f7e8d93ec','hw_rescue_bus','virtio','2026-01-31 08:21:36','2026-01-31 08:24:59','2026-01-31 08:24:59',1),(516,'af02be56-bd6f-4200-837f-ea1f7e8d93ec','hw_rescue_device','disk','2026-01-31 08:21:37','2026-01-31 08:24:59','2026-01-31 08:24:59',1),(517,'9a73b720-4ab7-4126-8c93-bff12492db80','hw_rng_model','virtio','2026-01-31 08:23:23','2026-01-31 08:24:46','2026-01-31 08:24:46',1),(518,'9a73b720-4ab7-4126-8c93-bff12492db80','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 08:23:23','2026-01-31 08:24:46','2026-01-31 08:24:46',1),(519,'9a73b720-4ab7-4126-8c93-bff12492db80','owner_user_name','tempest-ServerBootFromVolumeStableRescueTest-1116995694-project-member','2026-01-31 08:23:23','2026-01-31 08:24:46','2026-01-31 08:24:46',1),(520,'9a73b720-4ab7-4126-8c93-bff12492db80','owner_project_name','tempest-ServerBootFromVolumeStableRescueTest-1116995694','2026-01-31 08:23:23','2026-01-31 08:24:46','2026-01-31 08:24:46',1),(521,'9a73b720-4ab7-4126-8c93-bff12492db80','boot_roles','member,reader','2026-01-31 08:23:23','2026-01-31 08:24:46','2026-01-31 08:24:46',1),(522,'9a73b720-4ab7-4126-8c93-bff12492db80','hw_machine_type','q35','2026-01-31 08:23:23','2026-01-31 08:24:46','2026-01-31 08:24:46',1),(523,'9a73b720-4ab7-4126-8c93-bff12492db80','hw_cdrom_bus','sata','2026-01-31 08:23:23','2026-01-31 08:24:46','2026-01-31 08:24:46',1),(524,'9a73b720-4ab7-4126-8c93-bff12492db80','hw_disk_bus','virtio','2026-01-31 08:23:23','2026-01-31 08:24:46','2026-01-31 08:24:46',1),(525,'9a73b720-4ab7-4126-8c93-bff12492db80','hw_input_bus','usb','2026-01-31 08:23:23','2026-01-31 08:24:46','2026-01-31 08:24:46',1),(526,'9a73b720-4ab7-4126-8c93-bff12492db80','hw_pointer_model','usbtablet','2026-01-31 08:23:23','2026-01-31 08:24:46','2026-01-31 08:24:46',1),(527,'9a73b720-4ab7-4126-8c93-bff12492db80','hw_video_model','virtio','2026-01-31 08:23:23','2026-01-31 08:24:46','2026-01-31 08:24:46',1),(528,'9a73b720-4ab7-4126-8c93-bff12492db80','hw_vif_model','virtio','2026-01-31 08:23:23','2026-01-31 08:24:46','2026-01-31 08:24:46',1),(529,'9a73b720-4ab7-4126-8c93-bff12492db80','instance_uuid','ed055707-78a7-4777-97f3-842e56be52d9','2026-01-31 08:23:23','2026-01-31 08:24:46','2026-01-31 08:24:46',1),(530,'9a73b720-4ab7-4126-8c93-bff12492db80','user_id','038e2b3b4f174162a3ac6c4870857e60','2026-01-31 08:23:23','2026-01-31 08:24:46','2026-01-31 08:24:46',1),(531,'9a73b720-4ab7-4126-8c93-bff12492db80','image_type','snapshot','2026-01-31 08:23:23','2026-01-31 08:24:46','2026-01-31 08:24:46',1),(532,'9a73b720-4ab7-4126-8c93-bff12492db80','image_location','snapshot','2026-01-31 08:23:32','2026-01-31 08:24:46','2026-01-31 08:24:46',1),(533,'9a73b720-4ab7-4126-8c93-bff12492db80','owner_id','c90ea7f1be5f484bb873548236fadc00','2026-01-31 08:23:32','2026-01-31 08:24:46','2026-01-31 08:24:46',1),(534,'9a73b720-4ab7-4126-8c93-bff12492db80','image_state','available','2026-01-31 08:23:32','2026-01-31 08:24:46','2026-01-31 08:24:46',1),(535,'9a73b720-4ab7-4126-8c93-bff12492db80','hw_rescue_bus','virtio','2026-01-31 08:24:07','2026-01-31 08:24:46','2026-01-31 08:24:46',1),(536,'9a73b720-4ab7-4126-8c93-bff12492db80','hw_rescue_device','disk','2026-01-31 08:24:07','2026-01-31 08:24:47','2026-01-31 08:24:47',1),(537,'d0c05f70-473f-4406-999b-251a35bed209','signature_verified','False','2026-01-31 08:30:32','2026-01-31 08:30:55','2026-01-31 08:30:55',1),(538,'d0c05f70-473f-4406-999b-251a35bed209','hw_rng_model','virtio','2026-01-31 08:30:32','2026-01-31 08:30:55','2026-01-31 08:30:55',1),(539,'d0c05f70-473f-4406-999b-251a35bed209','base_image_ref','','2026-01-31 08:30:32','2026-01-31 08:30:55','2026-01-31 08:30:55',1),(540,'d0c05f70-473f-4406-999b-251a35bed209','owner_user_name','tempest-AttachVolumeMultiAttachTest-2017021026-project-member','2026-01-31 08:30:32','2026-01-31 08:30:55','2026-01-31 08:30:55',1),(541,'d0c05f70-473f-4406-999b-251a35bed209','owner_project_name','tempest-AttachVolumeMultiAttachTest-2017021026','2026-01-31 08:30:32','2026-01-31 08:30:55','2026-01-31 08:30:55',1),(542,'d0c05f70-473f-4406-999b-251a35bed209','boot_roles','reader,member','2026-01-31 08:30:32','2026-01-31 08:30:55','2026-01-31 08:30:55',1),(543,'d0c05f70-473f-4406-999b-251a35bed209','hw_machine_type','q35','2026-01-31 08:30:32','2026-01-31 08:30:55','2026-01-31 08:30:55',1),(544,'d0c05f70-473f-4406-999b-251a35bed209','hw_cdrom_bus','sata','2026-01-31 08:30:32','2026-01-31 08:30:55','2026-01-31 08:30:55',1),(545,'d0c05f70-473f-4406-999b-251a35bed209','hw_disk_bus','virtio','2026-01-31 08:30:32','2026-01-31 08:30:55','2026-01-31 08:30:55',1),(546,'d0c05f70-473f-4406-999b-251a35bed209','hw_input_bus','usb','2026-01-31 08:30:32','2026-01-31 08:30:55','2026-01-31 08:30:55',1),(547,'d0c05f70-473f-4406-999b-251a35bed209','hw_pointer_model','usbtablet','2026-01-31 08:30:32','2026-01-31 08:30:55','2026-01-31 08:30:55',1),(548,'d0c05f70-473f-4406-999b-251a35bed209','hw_video_model','virtio','2026-01-31 08:30:32','2026-01-31 08:30:55','2026-01-31 08:30:55',1),(549,'d0c05f70-473f-4406-999b-251a35bed209','hw_vif_model','virtio','2026-01-31 08:30:32','2026-01-31 08:30:55','2026-01-31 08:30:55',1),(550,'d0c05f70-473f-4406-999b-251a35bed209','root_device_name','/dev/vda','2026-01-31 08:30:32','2026-01-31 08:30:55','2026-01-31 08:30:55',1),(551,'d0c05f70-473f-4406-999b-251a35bed209','block_device_mapping','[{\"snapshot_id\": \"21b15817-28c2-42de-bee4-9bdbb61c9822\", \"volume_id\": null, \"tag\": null, \"encryption_secret_uuid\": null, \"image_id\": null, \"source_type\": \"snapshot\", \"disk_bus\": \"virtio\", \"no_device\": null, \"boot_index\": 0, \"encrypted\": null, \"guest_format\": null, \"device_name\": \"/dev/vda\", \"delete_on_termination\": false, \"volume_type\": null, \"volume_size\": 1, \"device_type\": \"disk\", \"encryption_format\": null, \"destination_type\": \"volume\", \"encryption_options\": null}]','2026-01-31 08:30:32','2026-01-31 08:30:55','2026-01-31 08:30:55',1),(552,'d0c05f70-473f-4406-999b-251a35bed209','bdm_v2','True','2026-01-31 08:30:32','2026-01-31 08:30:55','2026-01-31 08:30:55',1),(553,'1ba15ea8-5b3a-4a00-83dd-a3e208812118','hw_rng_model','virtio','2026-01-31 08:30:50','2026-01-31 08:31:59','2026-01-31 08:31:59',1),(554,'1ba15ea8-5b3a-4a00-83dd-a3e208812118','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 08:30:50','2026-01-31 08:31:59','2026-01-31 08:31:59',1),(555,'1ba15ea8-5b3a-4a00-83dd-a3e208812118','owner_user_name','tempest-ServersNegativeTestJSON-1810683467-project-member','2026-01-31 08:30:50','2026-01-31 08:31:59','2026-01-31 08:31:59',1),(556,'1ba15ea8-5b3a-4a00-83dd-a3e208812118','owner_project_name','tempest-ServersNegativeTestJSON-1810683467','2026-01-31 08:30:50','2026-01-31 08:31:59','2026-01-31 08:31:59',1),(557,'1ba15ea8-5b3a-4a00-83dd-a3e208812118','boot_roles','reader,member','2026-01-31 08:30:50','2026-01-31 08:31:59','2026-01-31 08:31:59',1),(558,'1ba15ea8-5b3a-4a00-83dd-a3e208812118','hw_machine_type','q35','2026-01-31 08:30:50','2026-01-31 08:31:59','2026-01-31 08:31:59',1),(559,'1ba15ea8-5b3a-4a00-83dd-a3e208812118','hw_cdrom_bus','sata','2026-01-31 08:30:50','2026-01-31 08:31:59','2026-01-31 08:31:59',1),(560,'1ba15ea8-5b3a-4a00-83dd-a3e208812118','hw_disk_bus','virtio','2026-01-31 08:30:50','2026-01-31 08:31:59','2026-01-31 08:31:59',1),(561,'1ba15ea8-5b3a-4a00-83dd-a3e208812118','hw_input_bus','usb','2026-01-31 08:30:50','2026-01-31 08:31:59','2026-01-31 08:31:59',1),(562,'1ba15ea8-5b3a-4a00-83dd-a3e208812118','hw_pointer_model','usbtablet','2026-01-31 08:30:50','2026-01-31 08:31:59','2026-01-31 08:31:59',1),(563,'1ba15ea8-5b3a-4a00-83dd-a3e208812118','hw_video_model','virtio','2026-01-31 08:30:50','2026-01-31 08:31:59','2026-01-31 08:31:59',1),(564,'1ba15ea8-5b3a-4a00-83dd-a3e208812118','hw_vif_model','virtio','2026-01-31 08:30:50','2026-01-31 08:31:59','2026-01-31 08:31:59',1),(565,'1ba15ea8-5b3a-4a00-83dd-a3e208812118','instance_uuid','20d5fd84-de90-46b0-816e-0f378fd7d0c7','2026-01-31 08:30:50','2026-01-31 08:31:59','2026-01-31 08:31:59',1),(566,'1ba15ea8-5b3a-4a00-83dd-a3e208812118','user_id','eac51187531841e2891fc5d3c5f84123','2026-01-31 08:30:50','2026-01-31 08:31:59','2026-01-31 08:31:59',1),(567,'1ba15ea8-5b3a-4a00-83dd-a3e208812118','image_type','snapshot','2026-01-31 08:30:50','2026-01-31 08:31:59','2026-01-31 08:31:59',1),(568,'1ba15ea8-5b3a-4a00-83dd-a3e208812118','image_location','snapshot','2026-01-31 08:31:04','2026-01-31 08:31:59','2026-01-31 08:31:59',1),(569,'1ba15ea8-5b3a-4a00-83dd-a3e208812118','owner_id','722ab2e9dd674709953be812d4c88493','2026-01-31 08:31:04','2026-01-31 08:31:59','2026-01-31 08:31:59',1),(570,'1ba15ea8-5b3a-4a00-83dd-a3e208812118','image_state','available','2026-01-31 08:31:04','2026-01-31 08:31:59','2026-01-31 08:31:59',1),(571,'e29674ab-eaa7-4f25-a795-4373e5f5c4e8','hw_rng_model','virtio','2026-01-31 08:52:38','2026-01-31 08:54:02','2026-01-31 08:54:02',1),(572,'e29674ab-eaa7-4f25-a795-4373e5f5c4e8','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 08:52:38','2026-01-31 08:54:02','2026-01-31 08:54:02',1),(573,'e29674ab-eaa7-4f25-a795-4373e5f5c4e8','owner_user_name','tempest-TestSnapshotPattern-920311190-project-member','2026-01-31 08:52:38','2026-01-31 08:54:02','2026-01-31 08:54:02',1),(574,'e29674ab-eaa7-4f25-a795-4373e5f5c4e8','owner_project_name','tempest-TestSnapshotPattern-920311190','2026-01-31 08:52:38','2026-01-31 08:54:02','2026-01-31 08:54:02',1),(575,'e29674ab-eaa7-4f25-a795-4373e5f5c4e8','boot_roles','reader,member','2026-01-31 08:52:38','2026-01-31 08:54:02','2026-01-31 08:54:02',1),(576,'e29674ab-eaa7-4f25-a795-4373e5f5c4e8','hw_machine_type','q35','2026-01-31 08:52:38','2026-01-31 08:54:02','2026-01-31 08:54:02',1),(577,'e29674ab-eaa7-4f25-a795-4373e5f5c4e8','hw_cdrom_bus','sata','2026-01-31 08:52:38','2026-01-31 08:54:02','2026-01-31 08:54:02',1),(578,'e29674ab-eaa7-4f25-a795-4373e5f5c4e8','hw_disk_bus','virtio','2026-01-31 08:52:38','2026-01-31 08:54:02','2026-01-31 08:54:02',1),(579,'e29674ab-eaa7-4f25-a795-4373e5f5c4e8','hw_input_bus','usb','2026-01-31 08:52:38','2026-01-31 08:54:02','2026-01-31 08:54:02',1),(580,'e29674ab-eaa7-4f25-a795-4373e5f5c4e8','hw_pointer_model','usbtablet','2026-01-31 08:52:38','2026-01-31 08:54:02','2026-01-31 08:54:02',1),(581,'e29674ab-eaa7-4f25-a795-4373e5f5c4e8','hw_video_model','virtio','2026-01-31 08:52:38','2026-01-31 08:54:02','2026-01-31 08:54:02',1),(582,'e29674ab-eaa7-4f25-a795-4373e5f5c4e8','hw_vif_model','virtio','2026-01-31 08:52:38','2026-01-31 08:54:02','2026-01-31 08:54:02',1),(583,'e29674ab-eaa7-4f25-a795-4373e5f5c4e8','instance_uuid','c304efec-22bc-408c-adea-b06aaf5fbe40','2026-01-31 08:52:38','2026-01-31 08:54:02','2026-01-31 08:54:02',1),(584,'e29674ab-eaa7-4f25-a795-4373e5f5c4e8','user_id','5a37d71e432b45168339dde5abdbe7b6','2026-01-31 08:52:38','2026-01-31 08:54:02','2026-01-31 08:54:02',1),(585,'e29674ab-eaa7-4f25-a795-4373e5f5c4e8','image_type','snapshot','2026-01-31 08:52:38','2026-01-31 08:54:02','2026-01-31 08:54:02',1),(586,'e29674ab-eaa7-4f25-a795-4373e5f5c4e8','owner_id','996284baaa2946258a0ab1be9a30d1f6','2026-01-31 08:52:47','2026-01-31 08:54:02','2026-01-31 08:54:02',1),(587,'e29674ab-eaa7-4f25-a795-4373e5f5c4e8','image_location','snapshot','2026-01-31 08:52:47','2026-01-31 08:54:03','2026-01-31 08:54:03',1),(588,'e29674ab-eaa7-4f25-a795-4373e5f5c4e8','image_state','available','2026-01-31 08:52:47','2026-01-31 08:54:03','2026-01-31 08:54:03',1),(589,'e29674ab-eaa7-4f25-a795-4373e5f5c4e8','version','8.0','2026-01-31 08:52:50','2026-01-31 08:54:03','2026-01-31 08:54:03',1),(590,'27f20f89-310d-4b9a-9cbf-b30cb0f65051','hw_rng_model','virtio','2026-01-31 08:53:38','2026-01-31 08:53:51','2026-01-31 08:53:51',1),(591,'27f20f89-310d-4b9a-9cbf-b30cb0f65051','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 08:53:38','2026-01-31 08:53:51','2026-01-31 08:53:51',1),(592,'27f20f89-310d-4b9a-9cbf-b30cb0f65051','owner_user_name','tempest-TestSnapshotPattern-920311190-project-member','2026-01-31 08:53:38','2026-01-31 08:53:51','2026-01-31 08:53:51',1),(593,'27f20f89-310d-4b9a-9cbf-b30cb0f65051','owner_project_name','tempest-TestSnapshotPattern-920311190','2026-01-31 08:53:38','2026-01-31 08:53:51','2026-01-31 08:53:51',1),(594,'27f20f89-310d-4b9a-9cbf-b30cb0f65051','boot_roles','member,reader','2026-01-31 08:53:38','2026-01-31 08:53:51','2026-01-31 08:53:51',1),(595,'27f20f89-310d-4b9a-9cbf-b30cb0f65051','hw_machine_type','q35','2026-01-31 08:53:38','2026-01-31 08:53:52','2026-01-31 08:53:52',1),(596,'27f20f89-310d-4b9a-9cbf-b30cb0f65051','hw_cdrom_bus','sata','2026-01-31 08:53:38','2026-01-31 08:53:52','2026-01-31 08:53:52',1),(597,'27f20f89-310d-4b9a-9cbf-b30cb0f65051','hw_disk_bus','virtio','2026-01-31 08:53:38','2026-01-31 08:53:52','2026-01-31 08:53:52',1),(598,'27f20f89-310d-4b9a-9cbf-b30cb0f65051','hw_input_bus','usb','2026-01-31 08:53:38','2026-01-31 08:53:52','2026-01-31 08:53:52',1),(599,'27f20f89-310d-4b9a-9cbf-b30cb0f65051','hw_pointer_model','usbtablet','2026-01-31 08:53:38','2026-01-31 08:53:52','2026-01-31 08:53:52',1),(600,'27f20f89-310d-4b9a-9cbf-b30cb0f65051','hw_video_model','virtio','2026-01-31 08:53:38','2026-01-31 08:53:52','2026-01-31 08:53:52',1),(601,'27f20f89-310d-4b9a-9cbf-b30cb0f65051','hw_vif_model','virtio','2026-01-31 08:53:38','2026-01-31 08:53:52','2026-01-31 08:53:52',1),(602,'27f20f89-310d-4b9a-9cbf-b30cb0f65051','instance_uuid','3d81873b-9fc8-47da-8ff3-81d0b7715556','2026-01-31 08:53:38','2026-01-31 08:53:52','2026-01-31 08:53:52',1),(603,'27f20f89-310d-4b9a-9cbf-b30cb0f65051','user_id','5a37d71e432b45168339dde5abdbe7b6','2026-01-31 08:53:38','2026-01-31 08:53:52','2026-01-31 08:53:52',1),(604,'27f20f89-310d-4b9a-9cbf-b30cb0f65051','image_type','snapshot','2026-01-31 08:53:38','2026-01-31 08:53:52','2026-01-31 08:53:52',1),(605,'27f20f89-310d-4b9a-9cbf-b30cb0f65051','owner_id','996284baaa2946258a0ab1be9a30d1f6','2026-01-31 08:53:38','2026-01-31 08:53:52','2026-01-31 08:53:52',1),(606,'27f20f89-310d-4b9a-9cbf-b30cb0f65051','image_location','snapshot','2026-01-31 08:53:38','2026-01-31 08:53:52','2026-01-31 08:53:52',1),(607,'27f20f89-310d-4b9a-9cbf-b30cb0f65051','image_state','available','2026-01-31 08:53:38','2026-01-31 08:53:52','2026-01-31 08:53:52',1),(608,'27f20f89-310d-4b9a-9cbf-b30cb0f65051','version','8.0','2026-01-31 08:53:38','2026-01-31 08:53:52','2026-01-31 08:53:52',1),(609,'6827763f-c9c4-43fc-825d-2f9c946c4536','hw_rng_model','virtio','2026-01-31 08:54:52','2026-01-31 08:56:24','2026-01-31 08:56:24',1),(610,'6827763f-c9c4-43fc-825d-2f9c946c4536','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 08:54:52','2026-01-31 08:56:24','2026-01-31 08:56:24',1),(611,'6827763f-c9c4-43fc-825d-2f9c946c4536','owner_user_name','tempest-TestStampPattern-23409568-project-member','2026-01-31 08:54:52','2026-01-31 08:56:24','2026-01-31 08:56:24',1),(612,'6827763f-c9c4-43fc-825d-2f9c946c4536','owner_project_name','tempest-TestStampPattern-23409568','2026-01-31 08:54:52','2026-01-31 08:56:24','2026-01-31 08:56:24',1),(613,'6827763f-c9c4-43fc-825d-2f9c946c4536','boot_roles','reader,member','2026-01-31 08:54:52','2026-01-31 08:56:24','2026-01-31 08:56:24',1),(614,'6827763f-c9c4-43fc-825d-2f9c946c4536','hw_machine_type','q35','2026-01-31 08:54:52','2026-01-31 08:56:24','2026-01-31 08:56:24',1),(615,'6827763f-c9c4-43fc-825d-2f9c946c4536','hw_cdrom_bus','sata','2026-01-31 08:54:52','2026-01-31 08:56:24','2026-01-31 08:56:24',1),(616,'6827763f-c9c4-43fc-825d-2f9c946c4536','hw_disk_bus','virtio','2026-01-31 08:54:52','2026-01-31 08:56:24','2026-01-31 08:56:24',1),(617,'6827763f-c9c4-43fc-825d-2f9c946c4536','hw_input_bus','usb','2026-01-31 08:54:52','2026-01-31 08:56:24','2026-01-31 08:56:24',1),(618,'6827763f-c9c4-43fc-825d-2f9c946c4536','hw_pointer_model','usbtablet','2026-01-31 08:54:52','2026-01-31 08:56:24','2026-01-31 08:56:24',1),(619,'6827763f-c9c4-43fc-825d-2f9c946c4536','hw_video_model','virtio','2026-01-31 08:54:52','2026-01-31 08:56:24','2026-01-31 08:56:24',1),(620,'6827763f-c9c4-43fc-825d-2f9c946c4536','hw_vif_model','virtio','2026-01-31 08:54:52','2026-01-31 08:56:24','2026-01-31 08:56:24',1),(621,'6827763f-c9c4-43fc-825d-2f9c946c4536','instance_uuid','da90f1fb-9090-49b5-a510-d7e6ac7a30d6','2026-01-31 08:54:52','2026-01-31 08:56:24','2026-01-31 08:56:24',1),(622,'6827763f-c9c4-43fc-825d-2f9c946c4536','user_id','a798fdf6d13d4af4b166dd94b5cea7cc','2026-01-31 08:54:52','2026-01-31 08:56:24','2026-01-31 08:56:24',1),(623,'6827763f-c9c4-43fc-825d-2f9c946c4536','image_type','snapshot','2026-01-31 08:54:52','2026-01-31 08:56:24','2026-01-31 08:56:24',1),(624,'6827763f-c9c4-43fc-825d-2f9c946c4536','image_location','snapshot','2026-01-31 08:54:58','2026-01-31 08:56:24','2026-01-31 08:56:24',1),(625,'6827763f-c9c4-43fc-825d-2f9c946c4536','owner_id','e6e96de7b2784be1adce763bc9c9adc5','2026-01-31 08:54:58','2026-01-31 08:56:24','2026-01-31 08:56:24',1),(626,'6827763f-c9c4-43fc-825d-2f9c946c4536','image_state','available','2026-01-31 08:54:58','2026-01-31 08:56:24','2026-01-31 08:56:24',1),(627,'f336042a-a032-4a9a-8976-bb911c951591','hw_rng_model','virtio','2026-01-31 09:06:58','2026-01-31 09:07:30','2026-01-31 09:07:30',1),(628,'f336042a-a032-4a9a-8976-bb911c951591','base_image_ref','7c23949f-bba8-4466-bb79-caf568852d38','2026-01-31 09:06:58','2026-01-31 09:07:30','2026-01-31 09:07:30',1),(629,'f336042a-a032-4a9a-8976-bb911c951591','owner_user_name','tempest-TestShelveInstance-1485729988-project-member','2026-01-31 09:06:58','2026-01-31 09:07:30','2026-01-31 09:07:30',1),(630,'f336042a-a032-4a9a-8976-bb911c951591','owner_project_name','tempest-TestShelveInstance-1485729988','2026-01-31 09:06:58','2026-01-31 09:07:30','2026-01-31 09:07:30',1),(631,'f336042a-a032-4a9a-8976-bb911c951591','boot_roles','member,reader','2026-01-31 09:06:58','2026-01-31 09:07:30','2026-01-31 09:07:30',1),(632,'f336042a-a032-4a9a-8976-bb911c951591','hw_machine_type','q35','2026-01-31 09:06:58','2026-01-31 09:07:30','2026-01-31 09:07:30',1),(633,'f336042a-a032-4a9a-8976-bb911c951591','hw_cdrom_bus','sata','2026-01-31 09:06:58','2026-01-31 09:07:30','2026-01-31 09:07:30',1),(634,'f336042a-a032-4a9a-8976-bb911c951591','hw_disk_bus','virtio','2026-01-31 09:06:58','2026-01-31 09:07:30','2026-01-31 09:07:30',1),(635,'f336042a-a032-4a9a-8976-bb911c951591','hw_input_bus','usb','2026-01-31 09:06:58','2026-01-31 09:07:30','2026-01-31 09:07:30',1),(636,'f336042a-a032-4a9a-8976-bb911c951591','hw_pointer_model','usbtablet','2026-01-31 09:06:58','2026-01-31 09:07:30','2026-01-31 09:07:30',1),(637,'f336042a-a032-4a9a-8976-bb911c951591','hw_video_model','virtio','2026-01-31 09:06:58','2026-01-31 09:07:30','2026-01-31 09:07:30',1),(638,'f336042a-a032-4a9a-8976-bb911c951591','hw_vif_model','virtio','2026-01-31 09:06:58','2026-01-31 09:07:30','2026-01-31 09:07:30',1),(639,'f336042a-a032-4a9a-8976-bb911c951591','instance_uuid','1fb94592-4c46-41d2-990b-7d5d8d1a7fce','2026-01-31 09:06:58','2026-01-31 09:07:30','2026-01-31 09:07:30',1),(640,'f336042a-a032-4a9a-8976-bb911c951591','user_id','4883c0d4a7f54a6898eba5bfdbb41266','2026-01-31 09:06:58','2026-01-31 09:07:30','2026-01-31 09:07:30',1),(641,'f336042a-a032-4a9a-8976-bb911c951591','image_type','snapshot','2026-01-31 09:06:58','2026-01-31 09:07:30','2026-01-31 09:07:30',1),(642,'f336042a-a032-4a9a-8976-bb911c951591','owner_id','496e06c7521f45c994e6426c4313acea','2026-01-31 09:07:10','2026-01-31 09:07:30','2026-01-31 09:07:30',1),(643,'f336042a-a032-4a9a-8976-bb911c951591','image_location','snapshot','2026-01-31 09:07:10','2026-01-31 09:07:30','2026-01-31 09:07:30',1),(644,'f336042a-a032-4a9a-8976-bb911c951591','image_state','available','2026-01-31 09:07:10','2026-01-31 09:07:30','2026-01-31 09:07:30',1),(645,'3235f05a-670b-496a-a8b6-5b3e82346d62','signature_verified','False','2026-01-31 09:14:24','2026-01-31 09:15:56','2026-01-31 09:15:56',1),(646,'3235f05a-670b-496a-a8b6-5b3e82346d62','hw_rng_model','virtio','2026-01-31 09:14:24','2026-01-31 09:15:56','2026-01-31 09:15:56',1),(647,'3235f05a-670b-496a-a8b6-5b3e82346d62','base_image_ref','','2026-01-31 09:14:24','2026-01-31 09:15:56','2026-01-31 09:15:56',1),(648,'3235f05a-670b-496a-a8b6-5b3e82346d62','owner_user_name','tempest-TestVolumeBootPattern-1294459393-project-member','2026-01-31 09:14:24','2026-01-31 09:15:56','2026-01-31 09:15:56',1),(649,'3235f05a-670b-496a-a8b6-5b3e82346d62','owner_project_name','tempest-TestVolumeBootPattern-1294459393','2026-01-31 09:14:24','2026-01-31 09:15:56','2026-01-31 09:15:56',1),(650,'3235f05a-670b-496a-a8b6-5b3e82346d62','boot_roles','member,reader','2026-01-31 09:14:24','2026-01-31 09:15:56','2026-01-31 09:15:56',1),(651,'3235f05a-670b-496a-a8b6-5b3e82346d62','hw_machine_type','q35','2026-01-31 09:14:24','2026-01-31 09:15:56','2026-01-31 09:15:56',1),(652,'3235f05a-670b-496a-a8b6-5b3e82346d62','hw_cdrom_bus','sata','2026-01-31 09:14:24','2026-01-31 09:15:56','2026-01-31 09:15:56',1),(653,'3235f05a-670b-496a-a8b6-5b3e82346d62','hw_disk_bus','virtio','2026-01-31 09:14:24','2026-01-31 09:15:56','2026-01-31 09:15:56',1),(654,'3235f05a-670b-496a-a8b6-5b3e82346d62','hw_input_bus','usb','2026-01-31 09:14:24','2026-01-31 09:15:56','2026-01-31 09:15:56',1),(655,'3235f05a-670b-496a-a8b6-5b3e82346d62','hw_pointer_model','usbtablet','2026-01-31 09:14:24','2026-01-31 09:15:56','2026-01-31 09:15:56',1),(656,'3235f05a-670b-496a-a8b6-5b3e82346d62','hw_video_model','virtio','2026-01-31 09:14:24','2026-01-31 09:15:56','2026-01-31 09:15:56',1),(657,'3235f05a-670b-496a-a8b6-5b3e82346d62','hw_vif_model','virtio','2026-01-31 09:14:24','2026-01-31 09:15:56','2026-01-31 09:15:56',1),(658,'3235f05a-670b-496a-a8b6-5b3e82346d62','root_device_name','/dev/vda','2026-01-31 09:14:24','2026-01-31 09:15:56','2026-01-31 09:15:56',1),(659,'3235f05a-670b-496a-a8b6-5b3e82346d62','block_device_mapping','[{\"device_name\": \"/dev/vda\", \"no_device\": null, \"encryption_options\": null, \"volume_size\": 1, \"tag\": null, \"source_type\": \"snapshot\", \"image_id\": null, \"volume_type\": null, \"encryption_format\": null, \"volume_id\": null, \"delete_on_termination\": true, \"snapshot_id\": \"19cd7d76-1c46-4377-b72d-ef79e4149d09\", \"boot_index\": 0, \"destination_type\": \"volume\", \"encrypted\": null, \"guest_format\": null, \"encryption_secret_uuid\": null, \"device_type\": \"disk\", \"disk_bus\": \"virtio\"}]','2026-01-31 09:14:24','2026-01-31 09:15:56','2026-01-31 09:15:56',1),(660,'3235f05a-670b-496a-a8b6-5b3e82346d62','bdm_v2','True','2026-01-31 09:14:24','2026-01-31 09:15:56','2026-01-31 09:15:56',1);
/*!40000 ALTER TABLE `image_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_tags`
--

DROP TABLE IF EXISTS `image_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_tags_image_id` (`image_id`),
  KEY `ix_image_tags_image_id_tag_value` (`image_id`,`value`),
  CONSTRAINT `image_tags_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_tags`
--

LOCK TABLES `image_tags` WRITE;
/*!40000 ALTER TABLE `image_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `disk_format` varchar(20) DEFAULT NULL,
  `container_format` varchar(20) DEFAULT NULL,
  `checksum` varchar(32) DEFAULT NULL,
  `owner` varchar(255) DEFAULT NULL,
  `min_disk` int(11) NOT NULL,
  `min_ram` int(11) NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT 0,
  `virtual_size` bigint(20) DEFAULT NULL,
  `visibility` enum('private','public','shared','community') NOT NULL DEFAULT 'shared',
  `os_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `os_hash_algo` varchar(64) DEFAULT NULL,
  `os_hash_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checksum_image_idx` (`checksum`),
  KEY `ix_images_deleted` (`deleted`),
  KEY `owner_image_idx` (`owner`),
  KEY `created_at_image_idx` (`created_at`),
  KEY `updated_at_image_idx` (`updated_at`),
  KEY `visibility_image_idx` (`visibility`),
  KEY `os_hidden_image_idx` (`os_hidden`),
  KEY `os_hash_value_image_idx` (`os_hash_value`),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`protected` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` (`id`, `name`, `size`, `status`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `disk_format`, `container_format`, `checksum`, `owner`, `min_disk`, `min_ram`, `protected`, `virtual_size`, `visibility`, `os_hidden`, `os_hash_algo`, `os_hash_value`) VALUES ('099d2e45-4409-4b4d-b402-9a886f0c164b','tempest-ListImageFiltersTestJSON-image-963804522',1024,'deleted','2026-01-31 07:47:02','2026-01-31 07:48:53','2026-01-31 07:48:53',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','d8503864fef643f698a175cc6364101c',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('0b8514e3-4251-4bd6-a806-b742c737781f','tempest-UnshelveToHostMultiNodesTest-server-1773899943-shelved',1073741824,'deleted','2026-01-31 07:41:35','2026-01-31 07:42:34','2026-01-31 07:42:34',1,'raw','bare',NULL,'37a878bbb1224cfeabcbe629345fc85d',1,0,0,NULL,'private',0,NULL,NULL),('18697fed-07f1-495d-b1ed-b20c2cf25fce','tempest-test-snap-1423245024',NULL,'deleted','2026-01-31 07:41:24','2026-01-31 07:41:26','2026-01-31 07:41:26',1,NULL,NULL,NULL,'b3e3e6f216d24c1f9f68777cfb63dbf8',1,0,0,NULL,'private',0,NULL,NULL),('19e1c9c2-3ea0-4549-b950-2d6bc24c2405','tempest-test-snap-1683764968',1073741824,'deleted','2026-01-31 07:39:53','2026-01-31 07:40:03','2026-01-31 07:40:03',1,'raw','bare',NULL,'b3e3e6f216d24c1f9f68777cfb63dbf8',1,0,0,NULL,'private',0,NULL,NULL),('1a3bb6f8-bfef-4edf-a7ea-1489b5cad196','tempest-scenario-img--231190322',21430272,'deleted','2026-01-31 08:21:12','2026-01-31 08:22:53','2026-01-31 08:22:53',1,'qcow2','bare','c8fc807773e5354afe61636071771906','134c066ac92844ff853b216870fa8eed',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('1ba15ea8-5b3a-4a00-83dd-a3e208812118','tempest-ServersNegativeTestJSON-server-711445957-shelved',1073741824,'deleted','2026-01-31 08:30:50','2026-01-31 08:31:59','2026-01-31 08:31:59',1,'raw','bare',NULL,'722ab2e9dd674709953be812d4c88493',1,0,0,NULL,'private',0,NULL,NULL),('1c1b7167-294e-43fd-b811-31bea4078f3d','tempest-test-snap-1998051882',1073741824,'deleted','2026-01-31 07:40:20','2026-01-31 07:41:04','2026-01-31 07:41:04',1,'raw','bare',NULL,'b3e3e6f216d24c1f9f68777cfb63dbf8',1,0,0,NULL,'private',0,NULL,NULL),('27f20f89-310d-4b9a-9cbf-b30cb0f65051','tempest-TestSnapshotPatternsnapshot-1146364969',1073741824,'deleted','2026-01-31 08:53:38','2026-01-31 08:53:52','2026-01-31 08:53:52',1,'raw','bare',NULL,'996284baaa2946258a0ab1be9a30d1f6',1,0,0,NULL,'private',0,NULL,NULL),('29ae106c-3bc3-4dca-bd69-8cd8e500fc3f','tempest-backup-3-578942666',1073741824,'deleted','2026-01-31 08:08:14','2026-01-31 08:08:30','2026-01-31 08:08:30',1,'raw','bare',NULL,'c3ddadeb950a490db5c99da98a32c9ec',1,0,0,NULL,'private',0,NULL,NULL),('2afd45fd-a049-4e1d-819a-36a36d22f6a2','tempest-ListImageFiltersTestJSON-image-2067401616',1073741824,'deleted','2026-01-31 07:47:50','2026-01-31 07:48:30','2026-01-31 07:48:30',1,'raw','bare',NULL,'d8503864fef643f698a175cc6364101c',1,0,0,NULL,'private',0,NULL,NULL),('2ca7a053-cec0-4d6e-8cfb-6697bc58e21c','tempest-ServerStableDeviceRescueTest-image-2121844181',1073741824,'deleted','2026-01-31 08:16:19','2026-01-31 08:18:03','2026-01-31 08:18:03',1,'raw','bare',NULL,'1633c84ea1bf46b080aaafd30bbcf25f',1,0,0,NULL,'private',0,NULL,NULL),('32133469-37ac-412d-b940-c908b55cf858','tempest-ListImageFiltersTestJSON-image-1108433630',1073741824,'deleted','2026-01-31 07:47:32','2026-01-31 07:48:34','2026-01-31 07:48:34',1,'raw','bare',NULL,'d8503864fef643f698a175cc6364101c',1,0,0,NULL,'private',0,NULL,NULL),('3235f05a-670b-496a-a8b6-5b3e82346d62','tempest-TestVolumeBootPatternsnapshot-1538724823',0,'deleted','2026-01-31 09:14:24','2026-01-31 09:15:56','2026-01-31 09:15:56',1,'qcow2','bare','d41d8cd98f00b204e9800998ecf8427e','98d10c0290e340a08e9d1726bf0066bf',1,0,0,NULL,'private',0,'sha512','cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e'),('3456c8a1-e00b-403c-938b-5db22092f19b','tempest-image-604769014',1024,'deleted','2026-01-31 07:49:02','2026-01-31 07:49:24','2026-01-31 07:49:24',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','c28908ad026147af81cd7dd48d992cb6',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('40cf2ff3-f7ff-4843-b4ab-b7dcc843006f','cirros-0.6.2-x86_64-disk.img_alt',21430272,'active','2026-01-31 07:29:34','2026-01-31 07:29:39',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','f1803bf3df964a3f90dda65daa6f9a53',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('41472c33-f8e9-4285-8ebd-4297b1fe1775','tempest-UnshelveToHostMultiNodesTest-server-1773899943-shelved',1073741824,'deleted','2026-01-31 07:40:53','2026-01-31 07:41:32','2026-01-31 07:41:32',1,'raw','bare',NULL,'37a878bbb1224cfeabcbe629345fc85d',1,0,0,NULL,'private',0,NULL,NULL),('4cb863eb-873b-4a83-aef8-5fea8d796cf2','tempest-image-361525968',1073741824,'deleted','2026-01-31 07:39:10','2026-01-31 07:39:35','2026-01-31 07:39:35',1,'raw','bare',NULL,'4511f016f1e44a299447f7fe1ad1a7ab',1,0,0,NULL,'private',0,NULL,NULL),('5b5ac3f7-b093-4152-83a1-6cb8fa870d17','tempest-AttachVolumeShelveTestJSON-server-154682825-shelved',1073741824,'deleted','2026-01-31 08:19:36','2026-01-31 08:20:21','2026-01-31 08:20:21',1,'raw','bare',NULL,'3b06982960ad4453b8e542cb6330835d',1,0,0,NULL,'private',0,NULL,NULL),('5c110bb6-9d02-475d-ac34-1ec891f50aba','tempest-scenario-img--163750645',21430272,'deleted','2026-01-31 08:37:59','2026-01-31 08:43:58','2026-01-31 08:43:58',1,'qcow2','bare','c8fc807773e5354afe61636071771906','4b38141686534a0fb9b947a7886cd4b6',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('5df2a010-0131-4bd4-8096-45b6ac756af0','tempest-ServerStableDeviceRescueTest-image-957882760',1073741824,'deleted','2026-01-31 08:13:59','2026-01-31 08:18:20','2026-01-31 08:18:20',1,'raw','bare',NULL,'1633c84ea1bf46b080aaafd30bbcf25f',1,0,0,NULL,'private',0,NULL,NULL),('627417b9-a501-49db-939e-bae37ed6ee98','tempest-test-snap-2112432349',1073741824,'deleted','2026-01-31 07:39:07','2026-01-31 07:39:29','2026-01-31 07:39:29',1,'raw','bare',NULL,'b3e3e6f216d24c1f9f68777cfb63dbf8',1,0,0,NULL,'private',0,NULL,NULL),('6827763f-c9c4-43fc-825d-2f9c946c4536','tempest-TestStampPatternsnapshot-1067192783',1073741824,'deleted','2026-01-31 08:54:52','2026-01-31 08:56:24','2026-01-31 08:56:24',1,'raw','bare',NULL,'e6e96de7b2784be1adce763bc9c9adc5',1,0,0,NULL,'private',0,NULL,NULL),('6e711352-ba7c-4c7d-858b-ee38dcbc90e8',NULL,21430272,'deleted','2026-01-31 07:38:46','2026-01-31 07:40:07','2026-01-31 07:40:07',1,'qcow2','bare','c8fc807773e5354afe61636071771906','a066230603dc4a20a9c1449125db0ac6',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('70966e79-230e-420e-aa68-b04da70a01e2','tempest-ServerActionsTestOtherB-server-993615947-shelved',1073741824,'deleted','2026-01-31 08:14:44','2026-01-31 08:15:29','2026-01-31 08:15:29',1,'raw','bare',NULL,'c3ddadeb950a490db5c99da98a32c9ec',1,0,0,NULL,'private',0,NULL,NULL),('7a74ff6f-b876-4da2-8910-2a6929d0fcbc','tempest-ServerStableDeviceRescueTest-image-1084146782',1073741824,'deleted','2026-01-31 08:11:26','2026-01-31 08:18:46','2026-01-31 08:18:46',1,'raw','bare',NULL,'1633c84ea1bf46b080aaafd30bbcf25f',1,0,0,NULL,'private',0,NULL,NULL),('7c23949f-bba8-4466-bb79-caf568852d38','cirros-0.6.2-x86_64-disk.img',21430272,'active','2026-01-31 07:29:26','2026-01-31 07:29:33',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','f1803bf3df964a3f90dda65daa6f9a53',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('94599989-66dd-45c0-95bf-4799dd46478c','tempest-backup-1-848043571',1073741824,'deleted','2026-01-31 08:07:53','2026-01-31 08:08:24','2026-01-31 08:08:24',1,'raw','bare',NULL,'c3ddadeb950a490db5c99da98a32c9ec',1,0,0,NULL,'private',0,NULL,NULL),('9a73b720-4ab7-4126-8c93-bff12492db80','tempest-ServerBootFromVolumeStableRescueTest-image-749600474',1073741824,'deleted','2026-01-31 08:23:23','2026-01-31 08:24:47','2026-01-31 08:24:47',1,'raw','bare',NULL,'c90ea7f1be5f484bb873548236fadc00',1,0,0,NULL,'private',0,NULL,NULL),('9d458b54-ba05-4df1-8123-8bec7fac57ca','tempest-AttachVolumeShelveTestJSON-server-1656500391-shelved',1073741824,'deleted','2026-01-31 08:17:15','2026-01-31 08:18:03','2026-01-31 08:18:03',1,'raw','bare',NULL,'3b06982960ad4453b8e542cb6330835d',1,0,0,NULL,'private',0,NULL,NULL),('ad1ed4e3-2333-4ea6-adf4-7e4aad3fefe3','tempest-ListImageFiltersTestJSON-image-1520943092',1024,'deleted','2026-01-31 07:46:57','2026-01-31 07:48:57','2026-01-31 07:48:57',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','d8503864fef643f698a175cc6364101c',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('ae58104d-ec03-4878-8203-221e83ac3a09','tempest-ServerStableDeviceRescueTest-image-982218050',1073741824,'deleted','2026-01-31 08:12:37','2026-01-31 08:18:33','2026-01-31 08:18:33',1,'raw','bare',NULL,'1633c84ea1bf46b080aaafd30bbcf25f',1,0,0,NULL,'private',0,NULL,NULL),('af02be56-bd6f-4200-837f-ea1f7e8d93ec','tempest-ServerBootFromVolumeStableRescueTest-image-1640612361',1073741824,'deleted','2026-01-31 08:21:12','2026-01-31 08:24:59','2026-01-31 08:24:59',1,'raw','bare',NULL,'c90ea7f1be5f484bb873548236fadc00',1,0,0,NULL,'private',0,NULL,NULL),('b009eb64-1e75-45c8-99c5-fb9d2b66fdcb','tempest-DeleteServersTestJSON-server-216539408-shelved',1073741824,'deleted','2026-01-31 07:46:32','2026-01-31 07:47:23','2026-01-31 07:47:23',1,'raw','bare',NULL,'f299640bb1f64e5fa12b23955e5a2127',1,0,0,NULL,'private',0,NULL,NULL),('ba20a523-9c85-4f5a-958b-3ab7efcbb3ba','tempest-ListImageFiltersTestJSON-image-1083122097',1073741824,'deleted','2026-01-31 07:48:02','2026-01-31 07:48:26','2026-01-31 07:48:26',1,'raw','bare',NULL,'d8503864fef643f698a175cc6364101c',1,0,0,NULL,'private',0,NULL,NULL),('c14ad43b-58f4-4ef0-a2f4-0d06b8e83718','tempest-ListImageFiltersTestJSON-image-561912544',1024,'deleted','2026-01-31 07:47:07','2026-01-31 07:48:51','2026-01-31 07:48:51',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','d8503864fef643f698a175cc6364101c',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('c4db27fa-394f-44cc-aad2-82f8c71ac7b7','tempest-backup-2-1752321331',1073741824,'deleted','2026-01-31 08:08:05','2026-01-31 08:08:39','2026-01-31 08:08:39',1,'raw','bare',NULL,'c3ddadeb950a490db5c99da98a32c9ec',1,0,0,NULL,'private',0,NULL,NULL),('d0b187ca-45f7-4a66-bf6d-895562fb5aaf','tempest-ImagesOneServerNegativeTestJSON-image-1730243712',NULL,'deleted','2026-01-31 07:45:34','2026-01-31 07:45:35','2026-01-31 07:45:35',1,NULL,NULL,NULL,'9a5c5f11e8f24f898d16bceb9925aaa0',1,0,0,NULL,'private',0,NULL,NULL),('d0c05f70-473f-4406-999b-251a35bed209','multiattach-snapshot',0,'deleted','2026-01-31 08:30:32','2026-01-31 08:30:56','2026-01-31 08:30:56',1,'qcow2','bare','d41d8cd98f00b204e9800998ecf8427e','48bbdbdee526499e90da7e971ede68d3',1,0,0,NULL,'private',0,'sha512','cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e'),('d312ef25-f354-483d-8db4-8f428dbab83b','tempest-backup-1-1849227995',NULL,'deleted','2026-01-31 08:19:31','2026-01-31 08:19:32','2026-01-31 08:19:32',1,'qcow2','bare',NULL,'6bd585668c8f42ad9197c73d4bd2ca6f',1,0,0,NULL,'private',0,NULL,NULL),('d7589e47-590e-4196-b561-0595216f339a','tempest-ServerActionsTestOtherB-server-1412905283-shelved',1073741824,'deleted','2026-01-31 08:14:07','2026-01-31 08:15:36','2026-01-31 08:15:36',1,'raw','bare',NULL,'c3ddadeb950a490db5c99da98a32c9ec',1,0,0,NULL,'private',0,NULL,NULL),('e29674ab-eaa7-4f25-a795-4373e5f5c4e8','tempest-TestSnapshotPatternsnapshot-105993315',1073741824,'deleted','2026-01-31 08:52:38','2026-01-31 08:54:03','2026-01-31 08:54:03',1,'raw','bare',NULL,'996284baaa2946258a0ab1be9a30d1f6',1,0,0,NULL,'private',0,NULL,NULL),('e939cee4-d39b-49b2-a849-509ee7169ea6','tempest-test-snap-317740189',1073741824,'deleted','2026-01-31 07:38:14','2026-01-31 07:38:24','2026-01-31 07:38:24',1,'raw','bare',NULL,'b3e3e6f216d24c1f9f68777cfb63dbf8',1,0,0,NULL,'private',0,NULL,NULL),('ead592bd-b181-468e-8645-8b0745b2d7d2','tempest-image-1797936897',1402,'deleted','2026-01-31 07:37:18','2026-01-31 07:37:24','2026-01-31 07:37:24',1,'qcow2','bare','91b24b7054884b8ab181bf622bac5f4f','5b15e559eb1a4c58bf720a624382279c',0,129,0,NULL,'private',0,'sha512','317a4896cd8bc7f64890725539ebbc68ae05c0333514861e7fd1b0708610554da84f1be121aed13dc3425b605bf76b409f09dadea19ea40fa659cae4df580417'),('ed46ac7b-1d36-47b6-9e31-f3feaccdcefd','tempest-ImagesOneServerNegativeTestJSON-image-661676683',NULL,'deleted','2026-01-31 07:44:29','2026-01-31 07:44:35','2026-01-31 07:44:35',1,NULL,NULL,NULL,'9a5c5f11e8f24f898d16bceb9925aaa0',1,0,0,NULL,'private',0,NULL,NULL),('eec3485d-bba1-4018-9e35-7f9f59c9e839','tempest-₡-2026310525',1073741824,'deleted','2026-01-31 07:39:35','2026-01-31 07:39:50','2026-01-31 07:39:50',1,'raw','bare',NULL,'4511f016f1e44a299447f7fe1ad1a7ab',1,0,0,NULL,'private',0,NULL,NULL),('f053e722-a943-4ece-ad77-a071fe4c9f59','tempest-scenario-img--811139934',21430272,'deleted','2026-01-31 08:19:01','2026-01-31 08:21:12','2026-01-31 08:21:12',1,'qcow2','bare','c8fc807773e5354afe61636071771906','134c066ac92844ff853b216870fa8eed',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('f336042a-a032-4a9a-8976-bb911c951591','tempest-TestShelveInstance-server-863769904-shelved',1073741824,'deleted','2026-01-31 09:06:58','2026-01-31 09:07:30','2026-01-31 09:07:30',1,'raw','bare',NULL,'496e06c7521f45c994e6426c4313acea',1,0,0,NULL,'private',0,NULL,NULL);
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespace_resource_types`
--

DROP TABLE IF EXISTS `metadef_namespace_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespace_resource_types` (
  `resource_type_id` int(11) NOT NULL,
  `namespace_id` int(11) NOT NULL,
  `properties_target` varchar(80) DEFAULT NULL,
  `prefix` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`resource_type_id`,`namespace_id`),
  KEY `ix_metadef_ns_res_types_namespace_id` (`namespace_id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_2` FOREIGN KEY (`resource_type_id`) REFERENCES `metadef_resource_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespace_resource_types`
--

LOCK TABLES `metadef_namespace_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_namespace_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_namespace_resource_types` (`resource_type_id`, `namespace_id`, `properties_target`, `prefix`, `created_at`, `updated_at`) VALUES (1,1,'image','CIM_PASD_','2026-01-31 06:51:07',NULL),(1,2,'image','CIM_RASD_','2026-01-31 06:51:13',NULL),(1,3,NULL,'CIM_SASD_','2026-01-31 06:51:16',NULL),(1,9,'image','hw_','2026-01-31 06:51:26',NULL),(1,10,'image','hw_','2026-01-31 06:51:26',NULL),(1,14,'image',NULL,'2026-01-31 06:51:27',NULL),(1,19,'image','hw_','2026-01-31 06:51:32',NULL),(1,25,'image','hw_','2026-01-31 06:51:34',NULL),(1,29,'image',NULL,'2026-01-31 06:51:43',NULL),(1,30,'image',NULL,'2026-01-31 06:51:44',NULL),(1,31,'image',NULL,'2026-01-31 06:51:48',NULL),(1,32,'image',NULL,'2026-01-31 06:51:54',NULL),(2,1,NULL,'CIM_PASD_','2026-01-31 06:51:10',NULL),(2,8,NULL,'hw_','2026-01-31 06:51:26',NULL),(2,9,NULL,'hw_','2026-01-31 06:51:26',NULL),(2,10,NULL,'hw_','2026-01-31 06:51:26',NULL),(2,11,NULL,NULL,'2026-01-31 06:51:26',NULL),(2,13,NULL,NULL,'2026-01-31 06:51:27',NULL),(2,14,NULL,NULL,'2026-01-31 06:51:27',NULL),(2,15,NULL,NULL,'2026-01-31 06:51:27',NULL),(2,16,NULL,'hw_','2026-01-31 06:51:29',NULL),(2,19,NULL,'hw_','2026-01-31 06:51:32',NULL),(2,22,NULL,NULL,'2026-01-31 06:51:33',NULL),(2,23,NULL,'hw_','2026-01-31 06:51:33',NULL),(2,24,NULL,'traits:','2026-01-31 06:51:33',NULL),(2,25,NULL,'hw_','2026-01-31 06:51:34',NULL),(2,26,NULL,NULL,'2026-01-31 06:51:40',NULL),(2,28,NULL,NULL,'2026-01-31 06:51:42',NULL),(2,29,NULL,NULL,'2026-01-31 06:51:43',NULL),(2,30,NULL,NULL,'2026-01-31 06:51:44',NULL),(2,31,NULL,NULL,'2026-01-31 06:51:48',NULL),(2,32,NULL,NULL,'2026-01-31 06:51:54',NULL),(2,33,NULL,'cinder_','2026-01-31 06:51:54',NULL),(3,1,NULL,'CIM_PASD_','2026-01-31 06:51:11',NULL),(3,2,NULL,'CIM_RASD_','2026-01-31 06:51:13',NULL),(3,3,NULL,'CIM_SASD_','2026-01-31 06:51:16',NULL),(3,4,NULL,'CIM_VSSD_','2026-01-31 06:51:17',NULL),(3,5,NULL,NULL,'2026-01-31 06:51:25',NULL),(3,6,NULL,NULL,'2026-01-31 06:51:25',NULL),(3,7,NULL,NULL,'2026-01-31 06:51:25',NULL),(3,12,NULL,'aggregate_instance_extra_specs:','2026-01-31 06:51:26',NULL),(4,1,NULL,'CIM_PASD_','2026-01-31 06:51:11',NULL),(4,2,NULL,'CIM_RASD_','2026-01-31 06:51:13',NULL),(4,3,NULL,'CIM_SASD_','2026-01-31 06:51:16',NULL),(4,4,NULL,'CIM_VSSD_','2026-01-31 06:51:17',NULL),(4,8,NULL,'hw:','2026-01-31 06:51:26',NULL),(4,9,NULL,'hw:','2026-01-31 06:51:26',NULL),(4,10,NULL,'hw:','2026-01-31 06:51:26',NULL),(4,12,NULL,'capabilities:','2026-01-31 06:51:26',NULL),(4,16,NULL,'hw:','2026-01-31 06:51:30',NULL),(4,17,NULL,NULL,'2026-01-31 06:51:31',NULL),(4,18,NULL,NULL,'2026-01-31 06:51:31',NULL),(4,19,NULL,'hw:','2026-01-31 06:51:32',NULL),(4,20,NULL,NULL,'2026-01-31 06:51:32',NULL),(4,21,NULL,NULL,'2026-01-31 06:51:33',NULL),(4,23,NULL,'hw:','2026-01-31 06:51:33',NULL),(4,24,NULL,'traits:','2026-01-31 06:51:33',NULL),(4,25,NULL,'hw:','2026-01-31 06:51:34',NULL),(5,1,'scheduler_hints',NULL,'2026-01-31 06:51:12',NULL),(5,30,'metadata',NULL,'2026-01-31 06:51:44',NULL),(5,31,'metadata',NULL,'2026-01-31 06:51:49',NULL),(5,32,'metadata',NULL,'2026-01-31 06:51:54',NULL),(6,30,NULL,NULL,'2026-01-31 06:51:44',NULL);
/*!40000 ALTER TABLE `metadef_namespace_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespaces`
--

DROP TABLE IF EXISTS `metadef_namespaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespaces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace` varchar(80) NOT NULL,
  `display_name` varchar(80) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `visibility` varchar(32) DEFAULT NULL,
  `protected` tinyint(1) DEFAULT NULL,
  `owner` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_namespaces_namespace` (`namespace`),
  KEY `ix_metadef_namespaces_owner` (`owner`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespaces`
--

LOCK TABLES `metadef_namespaces` WRITE;
/*!40000 ALTER TABLE `metadef_namespaces` DISABLE KEYS */;
INSERT INTO `metadef_namespaces` (`id`, `namespace`, `display_name`, `description`, `visibility`, `protected`, `owner`, `created_at`, `updated_at`) VALUES (1,'CIM::ProcessorAllocationSettingData','CIM Processor Allocation Setting','Properties related to the resource allocation settings of a processor (CPU) from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These are properties that identify processor setting data and may be specified to volume, image, host aggregate, flavor and Nova server as scheduler hint. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ProcessorAllocationSettingData.html.','public',1,'admin','2026-01-31 06:51:04',NULL),(2,'CIM::ResourceAllocationSettingData','CIM Resource Allocation Setting Data','Properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim) that represent settings specifically related to an allocated resource that are outside the scope of the CIM class typically used to represent the resource itself. These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ResourceAllocationSettingData.html.','public',1,'admin','2026-01-31 06:51:13',NULL),(3,'CIM::StorageAllocationSettingData','CIM Storage Allocation Setting Data','Properties related to the allocation of virtual storage from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_StorageAllocationSettingData.html.','public',1,'admin','2026-01-31 06:51:15',NULL),(4,'CIM::VirtualSystemSettingData','CIM Virtual System Setting Data','A set of virtualization specific properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim), which define the virtual aspects of a virtual system. These properties may be specified to host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_VirtualSystemSettingData.html.','public',1,'admin','2026-01-31 06:51:17',NULL),(5,'OS::Compute::AggregateDiskFilter','Disk Allocation per Host','Properties related to the Nova scheduler filter AggregateDiskFilter. Filters aggregate hosts based on the available disk space compared to the requested disk space. Hosts in the aggregate with not enough usable disk will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2026-01-31 06:51:25',NULL),(6,'OS::Compute::AggregateIoOpsFilter','IO Ops per Host','Properties related to the Nova scheduler filter AggregateIoOpsFilter. Filters aggregate hosts based on the number of instances currently changing state. Hosts in the aggregate with too many instances changing state will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2026-01-31 06:51:25',NULL),(7,'OS::Compute::AggregateNumInstancesFilter','Instances per Host','Properties related to the Nova scheduler filter AggregateNumInstancesFilter. Filters aggregate hosts by the number of running instances on it. Hosts in the aggregate with too many instances will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',0,'admin','2026-01-31 06:51:25',NULL),(8,'OS::Compute::CPUMode','CPU Mode','This provides the preferred CPU Model to be used when booting up a guest VM.','public',NULL,'admin','2026-01-31 06:51:25',NULL),(9,'OS::Compute::CPUPinning','CPU Pinning','This provides the preferred CPU pinning and CPU thread pinning policy to be used when pinning vCPU of the guest to pCPU of the host. See http://docs.openstack.org/admin-guide/compute-numa-cpu-pinning.html','public',1,'admin','2026-01-31 06:51:26',NULL),(10,'OS::Compute::GuestMemoryBacking','Guest Memory Backing','This provides the preferred backing option for guest RAM. Guest\'s memory can be backed by hugepages to limit TLB lookups. See also: https://wiki.openstack.org/wiki/VirtDriverGuestCPUMemoryPlacement','public',1,'admin','2026-01-31 06:51:26',NULL),(11,'OS::Compute::GuestShutdownBehavior','Shutdown Behavior','These properties allow modifying the shutdown behavior for stop, rescue, resize, and shelve operations.','public',1,'admin','2026-01-31 06:51:26',NULL),(12,'OS::Compute::HostCapabilities','Compute Host Capabilities','Hardware capabilities provided by the compute host. This provides the ability to fine tune the hardware specification required when an instance is requested. The ComputeCapabilitiesFilter should be enabled in the Nova scheduler to use these properties. When enabled, this filter checks that the capabilities provided by the compute host satisfy any extra specifications requested. Only hosts that can provide the requested capabilities will be eligible for hosting the instance.','public',1,'admin','2026-01-31 06:51:26',NULL),(13,'OS::Compute::Hypervisor','Hypervisor Selection','OpenStack Compute supports many hypervisors, although most installations use only one hypervisor. For installations with multiple supported hypervisors, you can schedule different hypervisors using the ImagePropertiesFilter. This filters compute nodes that satisfy any architecture, hypervisor type, or virtual machine mode properties specified on the instance\'s image properties.','public',1,'admin','2026-01-31 06:51:27',NULL),(14,'OS::Compute::InstanceData','Instance Config Data','Instances can perform self-configuration based on data made available to the running instance. These properties affect instance configuration.','public',1,'admin','2026-01-31 06:51:27',NULL),(15,'OS::Compute::LibvirtImage','libvirt Driver Options for Images','The libvirt Compute Driver Options for Glance Images.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-31 06:51:27',NULL),(16,'OS::Compute::Libvirt','libvirt Driver Options','The libvirt compute driver options.  \n\nThese are properties that affect the libvirt compute driver and may be specified on flavors and images.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-31 06:51:29',NULL),(17,'OS::Compute::Quota','Flavor Quota','Compute drivers may enable quotas on CPUs available to a VM, disk tuning, bandwidth I/O, and instance VIF traffic control.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-31 06:51:31',NULL),(18,'OS::Compute::RandomNumberGenerator','Random Number Generator','If a random-number generator device has been added to the instance through its image properties, the device can be enabled and configured.','public',1,'admin','2026-01-31 06:51:31',NULL),(19,'OS::Compute::VirtCPUTopology','Virtual CPU Topology','This provides the preferred socket/core/thread counts for the virtual CPU instance exposed to guests. This enables the ability to avoid hitting limitations on vCPU topologies that OS vendors place on their products. See also: https://opendev.org/openstack/nova-specs/src/branch/master/specs/juno/implemented/virt-driver-vcpu-topology.rst','public',1,'admin','2026-01-31 06:51:32',NULL),(20,'OS::Compute::VMwareFlavor','VMware Driver Options for Flavors','VMware Driver Options for Flavors may be used to customize and manage Nova Flavors. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-31 06:51:32',NULL),(21,'OS::Compute::VMwareQuotaFlavor','VMware Quota for Flavors','The VMware compute driver allows various compute quotas to be specified on flavors. When specified, the VMWare driver will ensure that the quota is enforced. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. For a list of hypervisors, see: https://wiki.openstack.org/wiki/HypervisorSupportMatrix. For flavor customization, see: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-31 06:51:33',NULL),(22,'OS::Compute::VMware','VMware Driver Options','The VMware compute driver options.  \n\nThese are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-31 06:51:33',NULL),(23,'OS::Compute::TPM','TPM Options','Configuration options for TPM','public',1,'admin','2026-01-31 06:51:33',NULL),(24,'OS::Compute::VTPM','Emulated Virtual TPM','Configuration options for Emulated Virtual TPM','public',1,'admin','2026-01-31 06:51:33',NULL),(25,'OS::Compute::Watchdog','Watchdog Behavior','Compute drivers may enable watchdog behavior over instances.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-31 06:51:34',NULL),(26,'OS::Compute::XenAPI','XenAPI Driver Options','The XenAPI compute driver options.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-31 06:51:40',NULL),(27,'OS::Glance::CommonImageProperties','Common Image Properties','When adding an image to Glance, you may specify some common image properties that may prove useful to consumers of your image.',NULL,1,'admin','2026-01-31 06:51:40',NULL),(28,'OS::Glance::Signatures','Image Signature Verification','Image signature verification allows the user to verify that an image has not been modified prior to booting the image.','public',0,'admin','2026-01-31 06:51:42',NULL),(29,'OS::OperatingSystem','Common Operating System Properties','Details of the operating system contained within this image as well as common operating system properties that can be set on a VM instance created from this image.',NULL,1,'admin','2026-01-31 06:51:43',NULL),(30,'OS::Software::DBMS','Database Software','A database is an organized collection of data. The data is typically organized to model aspects of reality in a way that supports processes requiring information. Database management systems are computer software applications that interact with the user, other applications, and the database itself to capture and analyze data. (http://en.wikipedia.org/wiki/Database)','public',1,'admin','2026-01-31 06:51:44',NULL),(31,'OS::Software::Runtimes','Runtime Environment','Software is written in a specific programming language and the language must execute within a runtime environment. The runtime environment provides an abstraction to utilizing a computer\'s processor, memory (RAM), and other system resources.','public',1,'admin','2026-01-31 06:51:47',NULL),(32,'OS::Software::WebServers','Web Servers','A web server is a computer system that processes requests via HTTP, the basic network protocol used to distribute information on the World Wide Web. The most common use of web servers is to host websites, but there are other uses such as gaming, data storage, running enterprise applications, handling email, FTP, or other web uses. (http://en.wikipedia.org/wiki/Web_server)','public',1,'admin','2026-01-31 06:51:54',NULL),(33,'OS::Cinder::Volumetype','Cinder Volume Type','The Cinder volume type configuration option. Volume type assignment provides a mechanism not only to provide scheduling to a specific storage back-end, but also can be used to specify specific information for a back-end storage device to act upon.','public',1,'admin','2026-01-31 06:51:54',NULL);
/*!40000 ALTER TABLE `metadef_namespaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_objects`
--

DROP TABLE IF EXISTS `metadef_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `description` text DEFAULT NULL,
  `required` text DEFAULT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_objects_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_objects_name` (`name`),
  CONSTRAINT `metadef_objects_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_objects`
--

LOCK TABLES `metadef_objects` WRITE;
/*!40000 ALTER TABLE `metadef_objects` DISABLE KEYS */;
INSERT INTO `metadef_objects` (`id`, `namespace_id`, `name`, `description`, `required`, `json_schema`, `created_at`, `updated_at`) VALUES (1,17,'CPU Limits','You can configure the CPU limits with control parameters.',NULL,'{\"quota:cpu_shares\": {\"title\": \"Quota: CPU Shares\", \"description\": \"Specifies the proportional weighted share for the domain. If this element is omitted, the service defaults to the OS provided defaults. There is no unit for the value; it is a relative measure based on the setting of other VMs. For example, a VM configured with value 2048 gets twice as much CPU time as a VM configured with value 1024.\", \"type\": \"integer\"}, \"quota:cpu_period\": {\"title\": \"Quota: CPU Period\", \"description\": \"Specifies the enforcement interval (unit: microseconds) for QEMU and LXC hypervisors. Within a period, each VCPU of the domain is not allowed to consume more than the quota worth of runtime. The value should be in range [1000, 1000000]. A period with value 0 means no value.\", \"type\": \"integer\", \"minimum\": 1000, \"maximum\": 1000000}, \"quota:cpu_quota\": {\"title\": \"Quota: CPU Quota\", \"description\": \"Specifies the maximum allowed bandwidth (unit: microseconds). A domain with a negative-value quota indicates that the domain has infinite bandwidth, which means that it is not bandwidth controlled. The value should be in range [1000, 18446744073709551] or less than 0. A quota with value 0 means no value. You can use this feature to ensure that all vCPUs run at the same speed.\", \"type\": \"integer\"}}','2026-01-31 06:51:31',NULL),(2,17,'Disk QoS','Using disk I/O quotas, you can set maximum disk write to 10 MB per second for a VM user.',NULL,'{\"quota:disk_read_bytes_sec\": {\"title\": \"Quota: Disk read bytes / sec\", \"description\": \"Sets disk I/O quota for disk read bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_read_iops_sec\": {\"title\": \"Quota: Disk read IOPS / sec\", \"description\": \"Sets disk I/O quota for disk read IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_write_bytes_sec\": {\"title\": \"Quota: Disk Write Bytes / sec\", \"description\": \"Sets disk I/O quota for disk write bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_write_iops_sec\": {\"title\": \"Quota: Disk Write IOPS / sec\", \"description\": \"Sets disk I/O quota for disk write IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_total_bytes_sec\": {\"title\": \"Quota: Disk Total Bytes / sec\", \"description\": \"Sets disk I/O quota for total disk bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_total_iops_sec\": {\"title\": \"Quota: Disk Total IOPS / sec\", \"description\": \"Sets disk I/O quota for disk total IOPS / sec.\", \"type\": \"integer\"}}','2026-01-31 06:51:31',NULL),(3,17,'Virtual Interface QoS','Bandwidth QoS tuning for instance virtual interfaces (VIFs) may be specified with these properties. Incoming and outgoing traffic can be shaped independently. If not specified, no quality of service (QoS) is applied on that traffic direction. So, if you want to shape only the network\'s incoming traffic, use inbound only (and vice versa). The OpenStack Networking service abstracts the physical implementation of the network, allowing plugins to configure and manage physical resources. Virtual Interfaces (VIF) in the logical model are analogous to physical network interface cards (NICs). VIFs are typically owned a managed by an external service; for instance when OpenStack Networking is used for building OpenStack networks, VIFs would be created, owned, and managed in Nova. VIFs are connected to OpenStack Networking networks via ports. A port is analogous to a port on a network switch, and it has an administrative state. When a VIF is attached to a port the OpenStack Networking API creates an attachment object, which specifies the fact that a VIF with a given identifier is plugged into the port.',NULL,'{\"quota:vif_inbound_average\": {\"title\": \"Quota: VIF Inbound Average\", \"description\": \"Network Virtual Interface (VIF) inbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_inbound_burst\": {\"title\": \"Quota: VIF Inbound Burst\", \"description\": \"Network Virtual Interface (VIF) inbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_inbound_peak\": {\"title\": \"Quota: VIF Inbound Peak\", \"description\": \"Network Virtual Interface (VIF) inbound peak in kilobytes per second. Specifies maximum rate at which an interface can receive data.\", \"type\": \"integer\"}, \"quota:vif_outbound_average\": {\"title\": \"Quota: VIF Outbound Average\", \"description\": \"Network Virtual Interface (VIF) outbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_outbound_burst\": {\"title\": \"Quota: VIF Outbound Burst\", \"description\": \"Network Virtual Interface (VIF) outbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_outbound_peak\": {\"title\": \"Quota: VIF Outbound Peak\", \"description\": \"Network Virtual Interface (VIF) outbound peak in kilobytes per second. Specifies maximum rate at which an interface can send data.\", \"type\": \"integer\"}}','2026-01-31 06:51:31',NULL),(4,30,'MySQL','MySQL is an object-relational database management system (ORDBMS). The MySQL development project has made its source code available under the terms of the GNU General Public License, as well as under a variety of proprietary agreements. MySQL was owned and sponsored by a single for-profit firm, the Swedish company MySQL AB, now owned by Oracle Corporation. MySQL is a popular choice of database for use in web applications, and is a central component of the widely used LAMP open source web application software stack (and other \'AMP\' stacks). (http://en.wikipedia.org/wiki/MySQL)',NULL,'{\"sw_database_mysql_version\": {\"title\": \"Version\", \"description\": \"The specific version of MySQL.\", \"type\": \"string\"}, \"sw_database_mysql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"The configured TCP/IP port which MySQL listens for incoming connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 3606}, \"sw_database_mysql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"root\"}}','2026-01-31 06:51:44',NULL),(5,30,'PostgreSQL','PostgreSQL, often simply \'Postgres\', is an object-relational database management system (ORDBMS) with an emphasis on extensibility and standards-compliance. PostgreSQL is cross-platform and runs on many operating systems. (http://en.wikipedia.org/wiki/PostgreSQL)',NULL,'{\"sw_database_postgresql_version\": {\"title\": \"Version\", \"description\": \"The specific version of PostgreSQL.\", \"type\": \"string\"}, \"sw_database_postgresql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which PostgreSQL is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_postgresql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"postgres\"}}','2026-01-31 06:51:44',NULL),(6,30,'SQL Server','Microsoft SQL Server is a relational database management system developed by Microsoft. There are at least a dozen different editions of Microsoft SQL Server aimed at different audiences and for workloads ranging from small single-machine applications to large Internet-facing applications with many concurrent users. Its primary query languages are T-SQL and ANSI SQL. (http://en.wikipedia.org/wiki/Microsoft_SQL_Server)',NULL,'{\"sw_database_sqlserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Microsoft SQL Server.\", \"type\": \"string\"}, \"sw_database_sqlserver_edition\": {\"title\": \"Edition\", \"description\": \"SQL Server is available in multiple editions, with different feature sets and targeting different users.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Datacenter\", \"Enterprise\", \"Standard\", \"Web\", \"Business Intelligence\", \"Workgroup\", \"Express\", \"Compact (SQL CE)\", \"Developer\", \"Embedded (SSEE)\", \"Express\", \"Fast Track\", \"LocalDB\", \"Parallel Data Warehouse (PDW)\", \"Business Intelligence\", \"Datawarehouse Appliance Edition\"]}, \"sw_database_sqlserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which SQL Server is to listen for connections from client applications. The default SQL Server port is 1433, and client ports are assigned a random value between 1024 and 5000.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1433}, \"sw_database_postsqlserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"sa\"}}','2026-01-31 06:51:45',NULL),(7,30,'Oracle','Oracle Database (commonly referred to as Oracle RDBMS or simply as Oracle) is an object-relational database management system produced and marketed by Oracle Corporation. (http://en.wikipedia.org/wiki/Oracle_Database)',NULL,'{\"sw_database_oracle_version\": {\"title\": \"Version\", \"description\": \"The specific version of Oracle.\", \"type\": \"string\"}, \"sw_database_oracle_edition\": {\"title\": \"Edition\", \"description\": \"Over and above the different versions of the Oracle database management software developed over time, Oracle Corporation subdivides its product into varying editions.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Enterprise\", \"Standard\", \"Standard Edition One\", \"Express (XE)\", \"Workgroup\", \"Lite\"]}, \"sw_database_oracle_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Oracle is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1521}}','2026-01-31 06:51:45',NULL),(8,30,'DB2','IBM DB2 is a family of database server products developed by IBM. These products all support the relational model, but in recent years some products have been extended to support object-relational features and non-relational structures, in particular XML. (http://en.wikipedia.org/wiki/IBM_DB2)',NULL,'{\"sw_database_db2_version\": {\"title\": \"Version\", \"description\": \"The specific version of DB2.\", \"type\": \"string\"}, \"sw_database_db2_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which DB2 is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_db2_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-01-31 06:51:45',NULL),(9,30,'MongoDB','MongoDB is a cross-platform document-oriented database. Classified as a NoSQL database, MongoDB uses JSON-like documents with dynamic schemas (MongoDB calls the format BSON), making the integration of data in certain types of applications easier and faster. Released under a combination of the GNU Affero General Public License and the Apache License, MongoDB is free and open-source software. (http://en.wikipedia.org/wiki/MongoDB)',NULL,'{\"sw_database_mongodb_version\": {\"title\": \"Version\", \"description\": \"The specific version of MongoDB.\", \"type\": \"string\"}, \"sw_database_mongodb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which MongoDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 27017}, \"sw_database_mongodb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-01-31 06:51:45',NULL),(10,30,'Couchbase Server','Couchbase Server, originally known as Membase, is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications. These applications must serve many concurrent users by creating, storing, retrieving, aggregating, manipulating and presenting data. In support of these kinds of application needs, Couchbase is designed to provide easy-to-scale key-value or document access with low latency and high sustained throughput. (http://en.wikipedia.org/wiki/Couchbase_Server)',NULL,'{\"sw_database_couchbaseserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Couchbase Server.\", \"type\": \"string\"}, \"sw_database_couchbaseserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Couchbase is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 11211}, \"sw_database_couchbaseserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2026-01-31 06:51:46',NULL),(11,30,'Redis','Redis is a data structure server (NoSQL). It is open-source, networked, in-memory, and stores keys with optional durability. The development of Redis has been sponsored by Pivotal Software since May 2013; before that, it was sponsored by VMware. The name Redis means REmote DIctionary Server. (http://en.wikipedia.org/wiki/Redis)',NULL,'{\"sw_database_redis_version\": {\"title\": \"Version\", \"description\": \"The specific version of Redis.\", \"type\": \"string\"}, \"sw_database_redis_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Redis is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 6379}, \"sw_database_redis_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2026-01-31 06:51:46',NULL),(12,30,'CouchDB','Apache CouchDB, commonly referred to as CouchDB, is an open source NoSQL database. It is a NoSQL database that uses JSON to store data, JavaScript as its query language using MapReduce, and HTTP for an API. One of its distinguishing features is multi-master replication. CouchDB was first released in 2005 and later became an Apache project in 2008. (http://en.wikipedia.org/wiki/CouchDB)',NULL,'{\"sw_database_couchdb_version\": {\"title\": \"Version\", \"description\": \"The specific version of CouchDB.\", \"type\": \"string\"}, \"sw_database_couchdb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which CouchDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5984}, \"sw_database_couchdb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-01-31 06:51:47',NULL),(13,30,'Apache Cassandra','Apache Cassandra is an open source distributed NoSQL database management system designed to handle large amounts of data across many commodity servers, providing high availability with no single point of failure. (http://en.wikipedia.org/wiki/Apache_Cassandra)',NULL,'{\"sw_database_cassandra_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache Cassandra.\", \"type\": \"string\"}, \"sw_database_cassandra_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Cassandra is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 9160}, \"sw_database_cassandra_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"cassandra\"}}','2026-01-31 06:51:47',NULL),(14,30,'HBase','HBase is an open source, non-relational (NoSQL), distributed database modeled after Google\'s BigTable and written in Java. It is developed as part of Apache Software Foundation\'s Apache Hadoop project and runs on top of HDFS (Hadoop Distributed Filesystem), providing BigTable-like capabilities for Hadoop. (http://en.wikipedia.org/wiki/Apache_HBase)',NULL,'{\"sw_database_hbase_version\": {\"title\": \"Version\", \"description\": \"The specific version of HBase.\", \"type\": \"string\"}}','2026-01-31 06:51:47',NULL),(15,30,'Hazlecast','In computing, Hazelcast is an in-memory open source software data grid based on Java. By having multiple nodes form a cluster, data is evenly distributed among the nodes. This allows for horizontal scaling both in terms of available storage space and processing power. Backups are also distributed in a similar fashion to other nodes, based on configuration, thereby protecting against single node failure. (http://en.wikipedia.org/wiki/Hazelcast)',NULL,'{\"sw_database_hazlecast_version\": {\"title\": \"Version\", \"description\": \"The specific version of Hazlecast.\", \"type\": \"string\"}, \"sw_database_hazlecast_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Hazlecast is to listen for connections between members.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5701}}','2026-01-31 06:51:47',NULL),(16,31,'PHP','PHP is a server-side scripting language designed for web development but also used as a general-purpose programming language. PHP code can be simply mixed with HTML code, or it can be used in combination with various templating engines and web frameworks. PHP code is usually processed by a PHP interpreter, which is usually implemented as a web server\'s native module or a Common Gateway Interface (CGI) executable. After the PHP code is interpreted and executed, the web server sends resulting output to its client, usually in form of a part of the generated web page – for example, PHP code can generate a web page\'s HTML code, an image, or some other data. PHP has also evolved to include a command-line interface (CLI) capability and can be used in standalone graphical applications. (http://en.wikipedia.org/wiki/PHP)',NULL,'{\"sw_runtime_php_version\": {\"title\": \"Version\", \"description\": \"The specific version of PHP.\", \"type\": \"string\"}}','2026-01-31 06:51:52',NULL),(17,31,'Python','Python is a widely used general-purpose, high-level programming language. Its design philosophy emphasizes code readability, and its syntax allows programmers to express concepts in fewer lines of code than would be possible in languages such as C++ or Java. The language provides constructs intended to enable clear programs on both a small and large scale. Python supports multiple programming paradigms, including object-oriented, imperative and functional programming or procedural styles. It features a dynamic type system and automatic memory management and has a large and comprehensive standard library. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_python_version\": {\"title\": \"Version\", \"description\": \"The specific version of python.\", \"type\": \"string\"}}','2026-01-31 06:51:54',NULL),(18,31,'Java','Java is a functional computer programming language that is concurrent, class-based, object-oriented, and specifically designed to have as few implementation dependencies as possible. It is intended to let application developers write once, run anywhere (WORA), meaning that code that runs on one platform does not need to be recompiled to run on another. Java applications are typically compiled to bytecode that can run on any Java virtual machine (JVM) regardless of computer architecture. (http://en.wikipedia.org/wiki/Java_(programming_language))',NULL,'{\"sw_runtime_java_version\": {\"title\": \"Version\", \"description\": \"The specific version of Java.\", \"type\": \"string\"}}','2026-01-31 06:51:54',NULL),(19,31,'Ruby','Ruby is a dynamic, reflective, object-oriented, general-purpose programming language. It was designed and developed in the mid-1990s by Yukihiro Matsumoto in Japan. According to its authors, Ruby was influenced by Perl, Smalltalk, Eiffel, Ada, and Lisp. It supports multiple programming paradigms, including functional, object-oriented, and imperative. It also has a dynamic type system and automatic memory management. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_ruby_version\": {\"title\": \"Version\", \"description\": \"The specific version of Ruby.\", \"type\": \"string\"}}','2026-01-31 06:51:54',NULL),(20,31,'Perl','Perl is a family of high-level, general-purpose, interpreted, dynamic programming languages. The languages in this family include Perl 5 and Perl 6. Though Perl is not officially an acronym, there are various backronyms in use, the most well-known being Practical Extraction and Reporting Language (http://en.wikipedia.org/wiki/Perl)',NULL,'{\"sw_runtime_perl_version\": {\"title\": \"Version\", \"description\": \"The specific version of Perl.\", \"type\": \"string\"}}','2026-01-31 06:51:54',NULL),(21,32,'Apache HTTP Server','The Apache HTTP Server, colloquially called Apache, is a Web server application notable for playing a key role in the initial growth of the World Wide Web. Apache is developed and maintained by an open community of developers under the auspices of the Apache Software Foundation. Most commonly used on a Unix-like system, the software is available for a wide variety of operating systems, including Unix, FreeBSD, Linux, Solaris, Novell NetWare, OS X, Microsoft Windows, OS/2, TPF, OpenVMS and eComStation. Released under the Apache License, Apache is open-source software. (http://en.wikipedia.org/wiki/Apache_HTTP_Server)',NULL,'{\"sw_webserver_apache_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache.\", \"type\": \"string\"}, \"sw_webserver_apache_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_apache_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-01-31 06:51:54',NULL),(22,32,'Nginx','Nginx (pronounced \'engine-x\') is an open source reverse proxy server for HTTP, HTTPS, SMTP, POP3, and IMAP protocols, as well as a load balancer, HTTP cache, and a web server (origin server). The nginx project started with a strong focus on high concurrency, high performance and low memory usage. It is licensed under the 2-clause BSD-like license and it runs on Linux, BSD variants, Mac OS X, Solaris, AIX, HP-UX, as well as on other *nix flavors. It also has a proof of concept port for Microsoft Windows. (http://en.wikipedia.org/wiki/Nginx)',NULL,'{\"sw_webserver_nginx_version\": {\"title\": \"Version\", \"description\": \"The specific version of Nginx.\", \"type\": \"string\"}, \"sw_webserver_nginx_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_nginx_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-01-31 06:51:54',NULL),(23,32,'IIS','Internet Information Services (IIS, formerly Internet Information Server) is an extensible web server created by Microsoft. IIS supports HTTP, HTTPS, FTP, FTPS, SMTP and NNTP. IIS is not turned on by default when Windows is installed. The IIS Manager is accessed through the Microsoft Management Console or Administrative Tools in the Control Panel. (http://en.wikipedia.org/wiki/Internet_Information_Services)',NULL,'{\"sw_webserver_iis_version\": {\"title\": \"Version\", \"description\": \"The specific version of IIS.\", \"type\": \"string\"}, \"sw_webserver_iis_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_iis_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-01-31 06:51:54',NULL);
/*!40000 ALTER TABLE `metadef_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_properties`
--

DROP TABLE IF EXISTS `metadef_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_properties_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_properties_name` (`name`),
  CONSTRAINT `metadef_properties_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_properties`
--

LOCK TABLES `metadef_properties` WRITE;
/*!40000 ALTER TABLE `metadef_properties` DISABLE KEYS */;
INSERT INTO `metadef_properties` (`id`, `namespace_id`, `name`, `json_schema`, `created_at`, `updated_at`) VALUES (1,1,'InstructionSet','{\"title\": \"Instruction Set\", \"description\": \"Identifies the instruction set of the processor within a processor architecture.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86:i386\", \"x86:i486\", \"x86:i586\", \"x86:i686\", \"x86:64\", \"IA-64:IA-64\", \"AS/400:TIMI\", \"Power:Power_2.03\", \"Power:Power_2.04\", \"Power:Power_2.05\", \"Power:Power_2.06\", \"S/390:ESA/390\", \"S/390:z/Architecture\", \"S/390:z/Architecture_2\", \"PA-RISC:PA-RISC_1.0\", \"PA-RISC:PA-RISC_2.0\", \"ARM:A32\", \"ARM:A64\", \"MIPS:MIPS_I\", \"MIPS:MIPS_II\", \"MIPS:MIPS_III\", \"MIPS:MIPS_IV\", \"MIPS:MIPS_V\", \"MIPS:MIPS32\", \"MIPS64:MIPS64\", \"Alpha:Alpha\", \"SPARC:SPARC_V7\", \"SPARC:SPARC_V8\", \"SPARC:SPARC_V9\", \"SPARC:SPARC_JPS1\", \"SPARC:UltraSPARC2005\", \"SPARC:UltraSPARC2007\", \"68k:68000\", \"68k:68010\", \"68k:68020\", \"68k:68030\", \"68k:68040\", \"68k:68060\"]}','2026-01-31 06:51:12',NULL),(2,1,'ProcessorArchitecture','{\"title\": \"Processor Architecture\", \"description\": \"Identifies the processor architecture of the processor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"IA-64\", \"AS/400\", \"Power\", \"S/390\", \"PA-RISC\", \"ARM\", \"MIPS\", \"Alpha\", \"SPARC\", \"68k\"]}','2026-01-31 06:51:12',NULL),(3,1,'InstructionSetExtensionName','{\"title\": \"Instruction Set Extension\", \"description\": \"Identifies the instruction set extensions of the processor within a processor architecture.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"x86:3DNow\", \"x86:3DNowExt\", \"x86:ABM\", \"x86:AES\", \"x86:AVX\", \"x86:AVX2\", \"x86:BMI\", \"x86:CX16\", \"x86:F16C\", \"x86:FSGSBASE\", \"x86:LWP\", \"x86:MMX\", \"x86:PCLMUL\", \"x86:RDRND\", \"x86:SSE2\", \"x86:SSE3\", \"x86:SSSE3\", \"x86:SSE4A\", \"x86:SSE41\", \"x86:SSE42\", \"x86:FMA3\", \"x86:FMA4\", \"x86:XOP\", \"x86:TBM\", \"x86:VT-d\", \"x86:VT-x\", \"x86:EPT\", \"x86:SVM\", \"PA-RISC:MAX\", \"PA-RISC:MAX2\", \"ARM:DSP\", \"ARM:Jazelle-DBX\", \"ARM:Thumb\", \"ARM:Thumb-2\", \"ARM:ThumbEE)\", \"ARM:VFP\", \"ARM:NEON\", \"ARM:TrustZone\", \"MIPS:MDMX\", \"MIPS:MIPS-3D\", \"Alpha:BWX\", \"Alpha:FIX\", \"Alpha:CIX\", \"Alpha:MVI\"]}}','2026-01-31 06:51:13',NULL),(4,2,'Address','{\"title\": \"Address\", \"description\": \"The address of the resource.\", \"type\": \"string\"}','2026-01-31 06:51:13',NULL),(5,2,'AddressOnParent','{\"title\": \"Address On Parent\", \"description\": \"Describes the address of this resource in the context of the Parent.\", \"type\": \"string\"}','2026-01-31 06:51:14',NULL),(6,2,'AllocationUnits','{\"title\": \"Allocation Units\", \"description\": \"This property specifies the units of allocation used by the Reservation and Limit properties.\", \"type\": \"string\"}','2026-01-31 06:51:14',NULL),(7,2,'AutomaticAllocation','{\"title\": \"Automatic Allocation\", \"description\": \"This property specifies if the resource will be automatically allocated.\", \"type\": \"boolean\"}','2026-01-31 06:51:14',NULL),(8,2,'AutomaticDeallocation','{\"title\": \"Automatic Deallocation\", \"description\": \"This property specifies if the resource will be automatically de-allocated.\", \"type\": \"boolean\"}','2026-01-31 06:51:14',NULL),(9,2,'ConsumerVisibility','{\"title\": \"Consumer Visibility\", \"description\": \"Describes the consumers visibility to the allocated resource.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Passed-Through\", \"Virtualized\", \"Not represented\", \"DMTF reserved\", \"Vendor Reserved\"]}','2026-01-31 06:51:14',NULL),(10,2,'Limit','{\"title\": \"Limit\", \"description\": \"This property specifies the upper bound, or maximum amount of resource that will be granted for this allocation.\", \"type\": \"string\"}','2026-01-31 06:51:14',NULL),(11,2,'MappingBehavior','{\"title\": \"Mapping Behavior\", \"description\": \"Specifies how this resource maps to underlying resources. If the HostResource array contains any entries, this property reflects how the resource maps to those specific resources.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Not Supported\", \"Dedicated\", \"Soft Affinity\", \"Hard Affinity\", \"DMTF Reserved\", \"Vendor Reserved\"]}','2026-01-31 06:51:14',NULL),(12,2,'OtherResourceType','{\"title\": \"Other Resource Type\", \"description\": \"A string that describes the resource type when a well defined value is not available and ResourceType has the value \'Other\'.\", \"type\": \"string\"}','2026-01-31 06:51:14',NULL),(13,2,'Parent','{\"title\": \"Parent\", \"description\": \"The Parent of the resource.\", \"type\": \"string\"}','2026-01-31 06:51:14',NULL),(14,2,'PoolID','{\"title\": \"Pool ID\", \"description\": \"This property specifies which ResourcePool the resource is currently allocated from, or which ResourcePool the resource will be allocated from when the allocation occurs.\", \"type\": \"string\"}','2026-01-31 06:51:14',NULL),(15,2,'Reservation','{\"title\": \"Reservation\", \"description\": \"This property specifies the amount of resource guaranteed to be available for this allocation.\", \"type\": \"string\"}','2026-01-31 06:51:15',NULL),(16,2,'ResourceSubType','{\"title\": \"Resource Sub Type\", \"description\": \"A string describing an implementation specific sub-type for this resource.\", \"type\": \"string\"}','2026-01-31 06:51:15',NULL),(17,2,'ResourceType','{\"title\": \"Resource Type\", \"description\": \"The type of resource this allocation setting represents.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Other\", \"Computer System\", \"Processor\", \"Memory\", \"IDE Controller\", \"Parallel SCSI HBA\", \"FC HBA\", \"iSCSI HBA\", \"IB HCA\", \"Ethernet Adapter\", \"Other Network Adapter\", \"I/O Slot\", \"I/O Device\", \"Floppy Drive\", \"CD Drive\", \"DVD drive\", \"Disk Drive\", \"Tape Drive\", \"Storage Extent\", \"Other storage device\", \"Serial port\", \"Parallel port\", \"USB Controller\", \"Graphics controller\", \"IEEE 1394 Controller\", \"Partitionable Unit\", \"Base Partitionable Unit\", \"Power\", \"Cooling Capacity\", \"Ethernet Switch Port\", \"Logical Disk\", \"Storage Volume\", \"Ethernet Connection\", \"DMTF reserved\", \"Vendor Reserved\"]}','2026-01-31 06:51:15',NULL),(18,2,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"This property specifies the quantity of resources presented to the consumer.\", \"type\": \"string\"}','2026-01-31 06:51:15',NULL),(19,2,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2026-01-31 06:51:15',NULL),(20,2,'Weight','{\"title\": \"Weight\", \"description\": \"This property specifies a relative priority for this allocation in relation to other allocations from the same ResourcePool.\", \"type\": \"string\"}','2026-01-31 06:51:15',NULL),(21,2,'Connection','{\"title\": \"Connection\", \"description\": \"The thing to which this resource is connected.\", \"type\": \"string\"}','2026-01-31 06:51:15',NULL),(22,2,'HostResource','{\"title\": \"Host Resource\", \"description\": \"This property exposes specific assignment of resources.\", \"type\": \"string\"}','2026-01-31 06:51:15',NULL),(23,3,'Access','{\"title\": \"Access\", \"description\": \"Access describes whether the allocated storage extent is 1 (readable), 2 (writeable), or 3 (both).\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Readable\", \"Writeable\", \"Read/Write Supported\", \"DMTF Reserved\"]}','2026-01-31 06:51:16',NULL),(24,3,'HostExtentName','{\"title\": \"Host Extent Name\", \"description\": \"A unique identifier for the host extent.\", \"type\": \"string\"}','2026-01-31 06:51:16',NULL),(25,3,'HostExtentNameFormat','{\"title\": \"Host Extent Name Format\", \"description\": \"The HostExtentNameFormat property identifies the format that is used for the value of the HostExtentName property.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"SNVM\", \"NAA\", \"EUI64\", \"T10VID\", \"OS Device Name\", \"DMTF Reserved\"]}','2026-01-31 06:51:16',NULL),(26,3,'HostExtentNameNamespace','{\"title\": \"Host Extent Name Namespace\", \"description\": \"If the host extent is a SCSI volume, then the preferred source for SCSI volume names is SCSI VPD Page 83 responses.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"VPD83Type3\", \"VPD83Type2\", \"VPD83Type1\", \"VPD80\", \"NodeWWN\", \"SNVM\", \"OS Device Namespace\", \"DMTF Reserved\"]}','2026-01-31 06:51:16',NULL),(27,3,'HostExtentStartingAddress','{\"title\": \"Host Extent Starting Address\", \"description\": \"The HostExtentStartingAddress property identifies the starting address on the host storage extent identified by the value of the HostExtentName property that is used for the allocation of the virtual storage extent.\", \"type\": \"string\"}','2026-01-31 06:51:16',NULL),(28,3,'HostResourceBlockSize','{\"title\": \"Host Resource Block Size\", \"description\": \"Size in bytes of the blocks that are allocated at the host as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2026-01-31 06:51:16',NULL),(29,3,'Limit','{\"title\": \"Limit\", \"description\": \"The maximum amount of blocks that will be granted for this storage resource allocation at the host.\", \"type\": \"string\"}','2026-01-31 06:51:17',NULL),(30,3,'OtherHostExtentNameFormat','{\"title\": \"Other Host Extent Name Format\", \"description\": \"A string describing the format of the HostExtentName property if the value of the HostExtentNameFormat property is 1 (Other).\", \"type\": \"string\"}','2026-01-31 06:51:17',NULL),(31,3,'OtherHostExtentNameNamespace','{\"title\": \"Other Host Extent Name Namespace\", \"description\": \"A string describing the namespace of the HostExtentName property if the value of the HostExtentNameNamespace matches 1 (Other).\", \"type\": \"string\"}','2026-01-31 06:51:17',NULL),(32,3,'Reservation','{\"title\": \"Reservation\", \"description\": \"The amount of blocks that are guaranteed to be available for this storage resource allocation at the host.\", \"type\": \"string\"}','2026-01-31 06:51:17',NULL),(33,3,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"Number of blocks that are presented to the consumer.\", \"type\": \"string\"}','2026-01-31 06:51:17',NULL),(34,3,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2026-01-31 06:51:17',NULL),(35,3,'VirtualResourceBlockSize','{\"title\": \"Virtual Resource Block Size\", \"description\": \"Size in bytes of the blocks that are presented to the consumer as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2026-01-31 06:51:17',NULL),(36,4,'AutomaticRecoveryAction','{\"title\": \"Automatic Recovery Action\", \"description\": \"Action to take for the virtual system when the software executed by the virtual system fails.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart\", \"Revert to snapshot\", \"DMTF Reserved\"]}','2026-01-31 06:51:17',NULL),(37,4,'AutomaticShutdownAction','{\"title\": \"Automatic Shutdown Action\", \"description\": \"Action to take for the virtual system when the host is shut down.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Turn Off\", \"Save state\", \"Shutdown\", \"DMTF Reserved\"]}','2026-01-31 06:51:18',NULL),(38,4,'AutomaticStartupAction','{\"title\": \"Automatic Startup Action\", \"description\": \"Action to take for the virtual system when the host is started.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart if previously active\", \"Always startup\", \"DMTF Reserved\"]}','2026-01-31 06:51:18',NULL),(39,4,'AutomaticStartupActionDelay','{\"title\": \"Automatic Startup Action Delay\", \"description\": \"Delay applicable to startup action.\", \"type\": \"string\"}','2026-01-31 06:51:18',NULL),(40,4,'AutomaticStartupActionSequenceNumber','{\"title\": \"Automatic Startup Action Sequence Number\", \"description\": \"Number indicating the relative sequence of virtual system activation when the host system is started.\", \"type\": \"string\"}','2026-01-31 06:51:19',NULL),(41,4,'ConfigurationDataRoot','{\"title\": \"Configuration Data Root\", \"description\": \"Filepath of a directory where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2026-01-31 06:51:20',NULL),(42,4,'ConfigurationFile','{\"title\": \"Configuration File\", \"description\": \"Filepath of a file where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2026-01-31 06:51:20',NULL),(43,4,'ConfigurationID','{\"title\": \"Configuration ID\", \"description\": \"Unique id of the virtual system configuration.\", \"type\": \"string\"}','2026-01-31 06:51:20',NULL),(44,4,'CreationTime','{\"title\": \"Creation Time\", \"description\": \"Time when the virtual system configuration was created.\", \"type\": \"string\"}','2026-01-31 06:51:21',NULL),(45,4,'LogDataRoot','{\"title\": \"Log Data Root\", \"description\": \"Filepath of a directory where log information about the virtual system is stored.\", \"type\": \"string\"}','2026-01-31 06:51:21',NULL),(46,4,'RecoveryFile','{\"title\": \"Recovery File\", \"description\": \"Filepath of a file where recovery relateded information of the virtual system is stored.\", \"type\": \"string\"}','2026-01-31 06:51:21',NULL),(47,4,'SnapshotDataRoot','{\"title\": \"Snapshot Data Root\", \"description\": \"Filepath of a directory where information about virtual system snapshots is stored.\", \"type\": \"string\"}','2026-01-31 06:51:21',NULL),(48,4,'SuspendDataRoot','{\"title\": \"Suspend Data Root\", \"description\": \"Filepath of a directory where suspend related information about the virtual system is stored.\", \"type\": \"string\"}','2026-01-31 06:51:21',NULL),(49,4,'SwapFileDataRoot','{\"title\": \"Swap File Data Root\", \"description\": \"Filepath of a directory where swapfiles of the virtual system are stored.\", \"type\": \"string\"}','2026-01-31 06:51:21',NULL),(50,4,'VirtualSystemIdentifier','{\"title\": \"Virtual System Identifier\", \"description\": \"VirtualSystemIdentifier shall reflect a unique name for the system as it is used within the virtualization platform.\", \"type\": \"string\"}','2026-01-31 06:51:22',NULL),(51,4,'VirtualSystemType','{\"title\": \"Virtual System Type\", \"description\": \"VirtualSystemType shall reflect a particular type of virtual system.\", \"type\": \"string\"}','2026-01-31 06:51:22',NULL),(52,4,'Notes','{\"title\": \"Notes\", \"description\": \"End-user supplied notes that are related to the virtual system.\", \"type\": \"string\"}','2026-01-31 06:51:24',NULL),(53,5,'disk_allocation_ratio','{\"title\": \"Disk Subscription Ratio\", \"description\": \"Allows the host to be under and over subscribed for the amount of disk space requested for an instance. A ratio greater than 1.0 allows for over subscription (hosts may have less usable disk space than requested). A ratio less than 1.0 allows for under subscription.\", \"type\": \"number\", \"readonly\": false}','2026-01-31 06:51:25',NULL),(54,6,'max_io_ops_per_host','{\"title\": \"Maximum IO Operations per Host\", \"description\": \"Prevents hosts in the aggregate that have this many or more instances currently in build, resize, snapshot, migrate, rescue or unshelve to be scheduled for new instances.\", \"type\": \"integer\", \"readonly\": false, \"default\": 8, \"minimum\": 1}','2026-01-31 06:51:25',NULL),(55,7,'max_instances_per_host','{\"title\": \"Max Instances Per Host\", \"description\": \"Maximum number of instances allowed to run on a host in the aggregate.\", \"type\": \"integer\", \"readonly\": false, \"minimum\": 0}','2026-01-31 06:51:25',NULL),(56,8,'cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"Type of CPU Mode.\", \"type\": \"string\", \"enum\": [\"none\", \"host-model\", \"host-passthrough\", \"custom\"]}','2026-01-31 06:51:26',NULL),(57,9,'cpu_policy','{\"title\": \"CPU Pinning policy\", \"description\": \"Type of CPU pinning policy.\", \"type\": \"string\", \"enum\": [\"shared\", \"dedicated\"]}','2026-01-31 06:51:26',NULL),(58,9,'cpu_thread_policy','{\"title\": \"CPU Thread Pinning Policy.\", \"description\": \"Type of CPU thread pinning policy.\", \"type\": \"string\", \"enum\": [\"isolate\", \"prefer\", \"require\"]}','2026-01-31 06:51:26',NULL),(59,10,'mem_page_size','{\"title\": \"Size of memory page\", \"description\": \"Page size to be used for Guest memory backing. Value can be specified as <number><unit> (i.e.: 2MB, 1GB) or \'any\', \'small\', \'large\'. If this property is set in Image metadata then only \'any\' and \'large\' values are accepted in Flavor metadata by Nova API.\", \"type\": \"string\"}','2026-01-31 06:51:26',NULL),(60,11,'os_shutdown_timeout','{\"title\": \"Shutdown timeout\", \"description\": \"By default, guests will be given 60 seconds to perform a graceful shutdown. After that, the VM is powered off.  This property allows overriding the amount of time (unit: seconds) to allow a guest OS to cleanly shut down before power off. A value of 0 (zero) means the guest will be powered off immediately with no opportunity for guest OS clean-up.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-31 06:51:26',NULL),(61,12,'cpu_info:vendor','{\"title\": \"Vendor\", \"description\": \"Specifies the CPU manufacturer.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Intel\", \"AMD\"]}','2026-01-31 06:51:26',NULL),(62,12,'cpu_info:model','{\"title\": \"Model\", \"description\": \"Specifies the CPU model. Use this property to ensure that your vm runs on a specific cpu model.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Conroe\", \"Core2Duo\", \"Penryn\", \"Nehalem\", \"Westmere\", \"SandyBridge\", \"IvyBridge\", \"Haswell\", \"Broadwell\", \"Delhi\", \"Seoul\", \"Abu Dhabi\", \"Interlagos\", \"Kabini\", \"Valencia\", \"Zurich\", \"Budapest\", \"Barcelona\", \"Suzuka\", \"Shanghai\", \"Istanbul\", \"Lisbon\", \"Magny-Cours\", \"Valencia\", \"Cortex-A57\", \"Cortex-A53\", \"Cortex-A12\", \"Cortex-A17\", \"Cortex-A15\", \"Coretx-A7\", \"X-Gene\"]}','2026-01-31 06:51:26',NULL),(63,12,'cpu_info:arch','{\"title\": \"Architecture\", \"description\": \"Specifies the CPU architecture. Use this property to specify the architecture supported by the hypervisor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"x86_64\", \"i686\", \"ia64\", \"ARMv8-A\", \"ARMv7-A\"]}','2026-01-31 06:51:26',NULL),(64,12,'cpu_info:topology:cores','{\"title\": \"cores\", \"description\": \"Number of cores.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-01-31 06:51:26',NULL),(65,12,'cpu_info:topology:threads','{\"title\": \"threads\", \"description\": \"Number of threads.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-01-31 06:51:27',NULL),(66,12,'cpu_info:topology:sockets','{\"title\": \"sockets\", \"description\": \"Number of sockets.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-01-31 06:51:27',NULL),(67,12,'cpu_info:features','{\"title\": \"Features\", \"description\": \"Specifies CPU flags/features. Using this property you can specify the required set of instructions supported by a vm.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"fpu\", \"vme\", \"de\", \"pse\", \"tsc\", \"msr\", \"pae\", \"mce\", \"cx8\", \"apic\", \"sep\", \"mtrr\", \"pge\", \"mca\", \"cmov\", \"pat\", \"pse36\", \"pn\", \"clflush\", \"dts\", \"acpi\", \"mmx\", \"fxsr\", \"sse\", \"sse2\", \"ss\", \"ht\", \"tm\", \"ia64\", \"pbe\", \"syscall\", \"mp\", \"nx\", \"mmxext\", \"fxsr_opt\", \"pdpe1gb\", \"rdtscp\", \"lm\", \"3dnowext\", \"3dnow\", \"arch_perfmon\", \"pebs\", \"bts\", \"rep_good\", \"nopl\", \"xtopology\", \"tsc_reliable\", \"nonstop_tsc\", \"extd_apicid\", \"amd_dcm\", \"aperfmperf\", \"eagerfpu\", \"nonstop_tsc_s3\", \"pni\", \"pclmulqdq\", \"dtes64\", \"monitor\", \"ds_cpl\", \"vmx\", \"smx\", \"est\", \"tm2\", \"ssse3\", \"cid\", \"fma\", \"cx16\", \"xtpr\", \"pdcm\", \"pcid\", \"dca\", \"sse4_1\", \"sse4_2\", \"x2apic\", \"movbe\", \"popcnt\", \"tsc_deadline_timer\", \"aes\", \"xsave\", \"avx\", \"f16c\", \"rdrand\", \"hypervisor\", \"rng\", \"rng_en\", \"ace\", \"ace_en\", \"ace2\", \"ace2_en\", \"phe\", \"phe_en\", \"pmm\", \"pmm_en\", \"lahf_lm\", \"cmp_legacy\", \"svm\", \"extapic\", \"cr8_legacy\", \"abm\", \"sse4a\", \"misalignsse\", \"3dnowprefetch\", \"osvw\", \"ibs\", \"xop\", \"skinit\", \"wdt\", \"lwp\", \"fma4\", \"tce\", \"nodeid_msr\", \"tbm\", \"topoext\", \"perfctr_core\", \"perfctr_nb\", \"bpext\", \"perfctr_l2\", \"mwaitx\", \"ida\", \"arat\", \"cpb\", \"epb\", \"pln\", \"pts\", \"dtherm\", \"hw_pstate\", \"proc_feedback\", \"hwp\", \"hwp_notify\", \"hwp_act_window\", \"hwp_epp\", \"hwp_pkg_req\", \"intel_pt\", \"tpr_shadow\", \"vnmi\", \"flexpriority\", \"ept\", \"vpid\", \"npt\", \"lbrv\", \"svm_lock\", \"nrip_save\", \"tsc_scale\", \"vmcb_clean\", \"flushbyasid\", \"decodeassists\", \"pausefilter\", \"pfthreshold\", \"vmmcall\", \"fsgsbase\", \"tsc_adjust\", \"bmi1\", \"hle\", \"avx2\", \"smep\", \"bmi2\", \"erms\", \"invpcid\", \"rtm\", \"cqm\", \"mpx\", \"avx512f\", \"rdseed\", \"adx\", \"smap\", \"pcommit\", \"clflushopt\", \"clwb\", \"avx512pf\", \"avx512er\", \"avx512cd\", \"sha_ni\", \"xsaveopt\", \"xsavec\", \"xgetbv1\", \"xsaves\", \"cqm_llc\", \"cqm_occup_llc\", \"clzero\"]}}','2026-01-31 06:51:27',NULL),(68,13,'hypervisor_type','{\"title\": \"Hypervisor Type\", \"description\": \"Hypervisor type required by the image. Used with the ImagePropertiesFilter. \\n\\n Baremetal - physical provisioning. hyperv - Microsoft\\u00ae hyperv. KVM - Kernel-based Virtual Machine. LXC - Linux Containers (through libvirt). powervm - IBM\\u00ae PowerVM\\u00ae. QEMU - Quick EMUlator. UML - User Mode Linux. vmware - VMware\\u00ae vsphere. VZ - Virtuozzo OS Containers and Virtual Machines (through libvirt). For more information, see: https://docs.openstack.org/nova/latest/admin/configuration/hypervisors.html\", \"type\": \"string\", \"enum\": [\"baremetal\", \"hyperv\", \"kvm\", \"lxc\", \"powervm\", \"qemu\", \"uml\", \"vmware\", \"vz\", \"xen\"]}','2026-01-31 06:51:27',NULL),(69,13,'vm_mode','{\"title\": \"VM Mode\", \"description\": \"The virtual machine mode. This represents the host/guest ABI (application binary interface) used for the virtual machine. Used with the ImagePropertiesFilter. \\n\\n hvm \\u2014 Fully virtualized - This is the virtual machine mode (vm_mode) used by QEMU and KVM. \\n\\n xen - Xen 3.0 paravirtualized. \\n\\n uml \\u2014 User Mode Linux paravirtualized. \\n\\n exe \\u2014 Executables in containers. This is the mode used by LXC.\", \"type\": \"string\", \"enum\": [\"hvm\", \"xen\", \"uml\", \"exe\"]}','2026-01-31 06:51:27',NULL),(70,14,'img_config_drive','{\"title\": \"Config Drive\", \"description\": \"This property specifies whether or not Nova should use a config drive when booting the image. Mandatory means that Nova will always use a config drive when booting the image. OpenStack can be configured to write metadata to a special configuration drive that will be attached to the instance when it boots. The instance can retrieve any information from the config drive. One use case for the config drive is to pass network configuration information to the instance. See also: http://docs.openstack.org/user-guide/cli_config_drive.html\", \"type\": \"string\", \"enum\": [\"optional\", \"mandatory\"]}','2026-01-31 06:51:27',NULL),(71,14,'os_require_quiesce','{\"title\": \"Require Quiescent File system\", \"description\": \"This property specifies whether or not the filesystem must be quiesced during snapshot processing. For volume backed and image backed snapshots, yes means that snapshotting is aborted when quiescing fails, whereas, no means quiescing will be skipped and snapshot processing will continue after the quiesce failure.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-01-31 06:51:27',NULL),(72,15,'hw_cdrom_bus','{\"title\": \"CD-ROM Bus\", \"description\": \"Specifies the type of disk controller to attach CD-ROM devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2026-01-31 06:51:27',NULL),(73,15,'hw_disk_bus','{\"title\": \"Disk Bus\", \"description\": \"Specifies the type of disk controller to attach disk devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2026-01-31 06:51:27',NULL),(74,15,'hw_firmware_type','{\"title\": \"Firmware Type\", \"description\": \"Specifies whether the image should be booted with a legacy BIOS or with UEFI.\", \"type\": \"string\", \"enum\": [\"bios\", \"uefi\"]}','2026-01-31 06:51:28',NULL),(75,15,'hw_rng_model','{\"title\": \"Random Number Generator Device\", \"description\": \"Adds a random-number generator device to the image\'s instances. The cloud administrator can enable and control device behavior by configuring the instance\'s flavor. By default: The generator device is disabled. /dev/random is used as the default entropy source. To specify a physical HW RNG device, use the following option in the nova.conf file: rng_dev_path=/dev/hwrng\", \"type\": \"string\", \"default\": \"virtio\"}','2026-01-31 06:51:28',NULL),(76,15,'hw_machine_type','{\"title\": \"Machine Type\", \"description\": \"Enables booting an ARM system using the specified machine type. By default, if an ARM image is used and its type is not specified, Compute uses vexpress-a15 (for ARMv7) or virt (for AArch64) machine types. Valid types can be viewed by using the virsh capabilities command (machine types are displayed in the machine tag).\", \"type\": \"string\"}','2026-01-31 06:51:28',NULL),(77,15,'hw_scsi_model','{\"title\": \"SCSI Model\", \"description\": \"Enables the use of VirtIO SCSI (virtio-scsi) to provide block device access for compute instances; by default, instances use VirtIO Block (virtio-blk). VirtIO SCSI is a para-virtualized SCSI controller device that provides improved scalability and performance, and supports advanced SCSI hardware.\", \"type\": \"string\", \"default\": \"virtio-scsi\"}','2026-01-31 06:51:28',NULL),(78,15,'hw_video_model','{\"title\": \"Video Model\", \"description\": \"The graphic device model presented to the guest. hw_video_model=none disables the graphics device in the guest and should generally be used when using gpu passthrough.\", \"type\": \"string\", \"enum\": [\"vga\", \"cirrus\", \"vmvga\", \"xen\", \"qxl\", \"virtio\", \"gop\", \"none\", \"bochs\"]}','2026-01-31 06:51:28',NULL),(79,15,'hw_video_ram','{\"title\": \"Max Video Ram\", \"description\": \"Maximum RAM (unit: MB) for the video image. Used only if a hw_video:ram_max_mb value has been set in the flavor\'s extra_specs and that value is higher than the value set in hw_video_ram.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-31 06:51:28',NULL),(80,15,'os_command_line','{\"title\": \"Kernel Command Line\", \"description\": \"The kernel command line to be used by the libvirt driver, instead of the default. For linux containers (LXC), the value is used as arguments for initialization. This key is valid only for Amazon kernel, ramdisk, or machine images (aki, ari, or ami).\", \"type\": \"string\"}','2026-01-31 06:51:28',NULL),(81,15,'os_type','{\"title\": \"OS Type\", \"description\": \"The operating system installed on the image. The libvirt driver contains logic that takes different actions depending on the value of the os_type parameter of the image. For example, for os_type=windows images, it creates a FAT32-based swap partition instead of a Linux swap partition, and it limits the injected host name to less than 16 characters.\", \"type\": \"string\", \"enum\": [\"linux\", \"windows\"]}','2026-01-31 06:51:28',NULL),(82,15,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor configuration. libvirt driver options: KVM and QEMU: e1000, ne2k_pci, pcnet, rtl8139, spapr-vlan, virtio, e1000e and vmxnet3. Xen: e1000, netfront, ne2k_pci, pcnet, and rtl8139.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"ne2k_pci\", \"netfront\", \"pcnet\", \"rtl8139\", \"spapr-vlan\", \"virtio\", \"vmxnet3\"]}','2026-01-31 06:51:28',NULL),(83,15,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-31 06:51:28',NULL),(84,15,'hw_pmu','{\"title\": \"Virtual Performance Monitoring Unit\", \"description\": \"Controls emulation of a vPMU in the guest. To reduce latency in realtime workloads disable the vPMU by setting hw_pmu=false\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-31 06:51:28',NULL),(85,15,'hw_qemu_guest_agent','{\"title\": \"QEMU Guest Agent\", \"description\": \"This is a background process which helps management applications execute guest OS level commands. For example, freezing and thawing filesystems, entering suspend. However, guest agent (GA) is not bullet proof, and hostile guest OS can send spurious replies.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-01-31 06:51:28',NULL),(86,15,'hw_pointer_model','{\"title\": \"Pointer Model\", \"description\": \"Input devices allow interaction with a graphical framebuffer. For example to provide a graphic tablet for absolute cursor movement. Currently only supported by the KVM/QEMU hypervisor configuration and VNC or SPICE consoles must be enabled.\", \"type\": \"string\", \"enum\": [\"usbtablet\"]}','2026-01-31 06:51:29',NULL),(87,15,'img_hide_hypervisor_id','{\"title\": \"Hide hypervisor id\", \"description\": \"Enables hiding the host hypervisor signature in the guest OS.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-01-31 06:51:29',NULL),(88,16,'serial_port_count','{\"title\": \"Serial Port Count\", \"description\": \"Specifies the count of serial ports that should be provided. If hw:serial_port_count is not set in the flavor\'s extra_specs, then any count is permitted. If hw:serial_port_count is set, then this provides the default serial port count. It is permitted to override the default serial port count, but only with a lower value.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-31 06:51:30',NULL),(89,16,'boot_menu','{\"title\": \"Boot Menu\", \"description\": \"If true, enables the BIOS bootmenu. In cases where both the image metadata and Extra Spec are set, the Extra Spec setting is used. This allows for flexibility in setting/overriding the default behavior as needed.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-31 06:51:30',NULL),(90,16,'mem_encryption','{\"title\": \"Hardware Memory Encryption\", \"description\": \"Enables encryption of guest memory at the hardware level, if there are compute hosts available which support this. See https://docs.openstack.org/nova/latest/admin/configuration/hypervisor-kvm.html#amd-sev-secure-encrypted-virtualization for details.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-31 06:51:30',NULL),(91,18,'hw_rng:allowed','{\"title\": \"Random Number Generator Allowed\", \"description\": \"\", \"type\": \"boolean\"}','2026-01-31 06:51:31',NULL),(92,18,'hw_rng:rate_bytes','{\"title\": \"Random number generator limits.\", \"description\": \"Allowed amount of bytes that the guest can read from the host\'s entropy per period.\", \"type\": \"integer\"}','2026-01-31 06:51:31',NULL),(93,18,'hw_rng:rate_period','{\"title\": \"Random number generator read period.\", \"description\": \"Duration of the read period in milliseconds.\", \"type\": \"integer\"}','2026-01-31 06:51:32',NULL),(94,19,'cpu_sockets','{\"title\": \"vCPU Sockets\", \"description\": \"Preferred number of sockets to expose to the guest.\", \"type\": \"integer\"}','2026-01-31 06:51:32',NULL),(95,19,'cpu_cores','{\"title\": \"vCPU Cores\", \"description\": \"Preferred number of cores to expose to the guest.\", \"type\": \"integer\"}','2026-01-31 06:51:32',NULL),(96,19,'cpu_threads','{\"title\": \" vCPU Threads\", \"description\": \"Preferred number of threads to expose to the guest.\", \"type\": \"integer\"}','2026-01-31 06:51:32',NULL),(97,19,'cpu_max_sockets','{\"title\": \"Max vCPU Sockets\", \"description\": \"Maximum number of sockets to expose to the guest.\", \"type\": \"integer\"}','2026-01-31 06:51:32',NULL),(98,19,'cpu_max_cores','{\"title\": \"Max vCPU Cores\", \"description\": \"Maximum number of cores to expose to the guest.\", \"type\": \"integer\"}','2026-01-31 06:51:32',NULL),(99,19,'cpu_max_threads','{\"title\": \"Max vCPU Threads\", \"description\": \"Maximum number of threads to expose to the guest.\", \"type\": \"integer\"}','2026-01-31 06:51:32',NULL),(100,20,'vmware:hw_version','{\"title\": \"VMware Hardware Version\", \"description\": \"Specifies the hardware version VMware uses to create images. If the hardware version needs to be compatible with a cluster version, for backward compatibility or other circumstances, the vmware:hw_version key specifies a virtual machine hardware version. In the event that a cluster has mixed host version types, the key will enable the vCenter to place the cluster on the correct host.\", \"type\": \"string\", \"enum\": [\"vmx-13\", \"vmx-11\", \"vmx-10\", \"vmx-09\", \"vmx-08\", \"vmx-07\", \"vmx-04\", \"vmx-03\"]}','2026-01-31 06:51:33',NULL),(101,20,'vmware:storage_policy','{\"title\": \"VMware Storage Policy\", \"description\": \"Specifies the storage policy to be applied for newly created instance. If not provided, the default storage policy specified in config file will be used. If Storage Policy Based Management (SPBM) is not enabled in config file, this value won\'t be used.\", \"type\": \"string\"}','2026-01-31 06:51:33',NULL),(102,21,'quota:cpu_limit','{\"title\": \"Quota: CPU Limit\", \"description\": \"Specifies the upper limit for CPU allocation in MHz. This parameter ensures that a machine never uses more than the defined amount of CPU time. It can be used to enforce a limit on the machine\'s CPU performance. The value should be a numerical value in MHz. If zero is supplied then the cpu_limit is unlimited.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-31 06:51:33',NULL),(103,21,'quota:cpu_reservation','{\"title\": \"Quota: CPU Reservation Limit\", \"description\": \"Specifies the guaranteed minimum CPU reservation in MHz. This means that if needed, the machine will definitely get allocated the reserved amount of CPU cycles. The value should be a numerical value in MHz.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-31 06:51:33',NULL),(104,22,'img_linked_clone','{\"title\": \"Linked Clone\", \"description\": \"By default, the VMware compute driver creates linked clones when possible (though this can be turned off by the operator). You can use this image property on a per-image basis to control whether virtual machines booted from the image are treated as full clones (value: false) or linked clones (value: true). Please refer to VMware documentation for information about full vs. linked clones.\", \"type\": \"boolean\"}','2026-01-31 06:51:33',NULL),(105,22,'vmware_adaptertype','{\"title\": \"Disk Adapter Type\", \"description\": \"The virtual SCSI or IDE controller used by the hypervisor.\", \"type\": \"string\", \"enum\": [\"lsiLogic\", \"lsiLogicsas\", \"paraVirtual\", \"busLogic\", \"ide\"], \"default\": \"lsiLogic\"}','2026-01-31 06:51:33',NULL),(106,22,'vmware_disktype','{\"title\": \"Disk Provisioning Type\", \"description\": \"When performing operations such as creating a virtual disk, cloning, or migrating, the disk provisioning type may be specified. Please refer to VMware documentation for more.\", \"type\": \"string\", \"enum\": [\"streamOptimized\", \"sparse\", \"preallocated\"], \"default\": \"preallocated\"}','2026-01-31 06:51:33',NULL),(107,22,'vmware_ostype','{\"title\": \"OS Type\", \"description\": \"A VMware GuestID which describes the operating system installed in the image. This value is passed to the hypervisor when creating a virtual machine. If not specified, the key defaults to otherGuest. See thinkvirt.com.\", \"type\": \"string\", \"enum\": [\"asianux3_64Guest\", \"asianux3Guest\", \"asianux4_64Guest\", \"asianux4Guest\", \"asianux5_64Guest\", \"asianux7_64Guest\", \"centos64Guest\", \"centosGuest\", \"centos6Guest\", \"centos6_64Guest\", \"centos7_64Guest\", \"coreos64Guest\", \"darwin10_64Guest\", \"darwin10Guest\", \"darwin11_64Guest\", \"darwin11Guest\", \"darwin12_64Guest\", \"darwin13_64Guest\", \"darwin14_64Guest\", \"darwin15_64Guest\", \"darwin16_64Guest\", \"darwin64Guest\", \"darwinGuest\", \"debian4_64Guest\", \"debian4Guest\", \"debian5_64Guest\", \"debian5Guest\", \"debian6_64Guest\", \"debian6Guest\", \"debian7_64Guest\", \"debian7Guest\", \"debian8_64Guest\", \"debian8Guest\", \"debian9_64Guest\", \"debian9Guest\", \"debian10_64Guest\", \"debian10Guest\", \"dosGuest\", \"eComStation2Guest\", \"eComStationGuest\", \"fedora64Guest\", \"fedoraGuest\", \"freebsd64Guest\", \"freebsdGuest\", \"genericLinuxGuest\", \"mandrakeGuest\", \"mandriva64Guest\", \"mandrivaGuest\", \"netware4Guest\", \"netware5Guest\", \"netware6Guest\", \"nld9Guest\", \"oesGuest\", \"openServer5Guest\", \"openServer6Guest\", \"opensuse64Guest\", \"opensuseGuest\", \"oracleLinux64Guest\", \"oracleLinuxGuest\", \"oracleLinux6Guest\", \"oracleLinux6_64Guest\", \"oracleLinux7_64Guest\", \"os2Guest\", \"other24xLinux64Guest\", \"other24xLinuxGuest\", \"other26xLinux64Guest\", \"other26xLinuxGuest\", \"other3xLinux64Guest\", \"other3xLinuxGuest\", \"otherGuest\", \"otherGuest64\", \"otherLinux64Guest\", \"otherLinuxGuest\", \"redhatGuest\", \"rhel2Guest\", \"rhel3_64Guest\", \"rhel3Guest\", \"rhel4_64Guest\", \"rhel4Guest\", \"rhel5_64Guest\", \"rhel5Guest\", \"rhel6_64Guest\", \"rhel6Guest\", \"rhel7_64Guest\", \"rhel7Guest\", \"sjdsGuest\", \"sles10_64Guest\", \"sles10Guest\", \"sles11_64Guest\", \"sles11Guest\", \"sles12_64Guest\", \"sles12Guest\", \"sles64Guest\", \"slesGuest\", \"solaris10_64Guest\", \"solaris10Guest\", \"solaris11_64Guest\", \"solaris6Guest\", \"solaris7Guest\", \"solaris8Guest\", \"solaris9Guest\", \"turboLinux64Guest\", \"turboLinuxGuest\", \"ubuntu64Guest\", \"ubuntuGuest\", \"unixWare7Guest\", \"vmkernel5Guest\", \"vmkernel6Guest\", \"vmkernel65Guest\", \"vmkernelGuest\", \"vmwarePhoton64Guest\", \"win2000AdvServGuest\", \"win2000ProGuest\", \"win2000ServGuest\", \"win31Guest\", \"win95Guest\", \"win98Guest\", \"windows7_64Guest\", \"windows7Guest\", \"windows7Server64Guest\", \"windows8_64Guest\", \"windows8Guest\", \"windows8Server64Guest\", \"windows9_64Guest\", \"windows9Guest\", \"windows9Server64Guest\", \"windowsHyperVGuest\", \"winLonghorn64Guest\", \"winLonghornGuest\", \"winMeGuest\", \"winNetBusinessGuest\", \"winNetDatacenter64Guest\", \"winNetDatacenterGuest\", \"winNetEnterprise64Guest\", \"winNetEnterpriseGuest\", \"winNetStandard64Guest\", \"winNetStandardGuest\", \"winNetWebGuest\", \"winNTGuest\", \"winVista64Guest\", \"winVistaGuest\", \"winXPHomeGuest\", \"winXPPro64Guest\", \"winXPProGuest\"], \"default\": \"otherGuest\"}','2026-01-31 06:51:33',NULL),(108,22,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor. VMware driver supported options: e1000, e1000e, VirtualE1000, VirtualE1000e, VirtualPCNet32, and VirtualVmxnet.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"VirtualE1000\", \"VirtualE1000e\", \"VirtualPCNet32\", \"VirtualVmxnet\", \"VirtualVmxnet3\"], \"default\": \"e1000\"}','2026-01-31 06:51:33',NULL),(109,22,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-31 06:51:33',NULL),(110,23,'tpm_model','{\"title\": \"TPM model\", \"description\": \"TPM model to use. Option CRB is only valid for TPM version 2.0. Defaults to TIS.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"TIS\", \"CRB\"], \"default\": \"TIS\"}','2026-01-31 06:51:33',NULL),(111,24,'COMPUTE_SECURITY_TPM_1_2','{\"title\": \"Virtual TPM Version 1.2 Support\", \"description\": \"Enables virtual TPM version 1.2.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2026-01-31 06:51:34',NULL),(112,24,'COMPUTE_SECURITY_TPM_2_0','{\"title\": \"Virtual TPM Version 2.0 Support\", \"description\": \"Enables virtual TPM version 2.0.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2026-01-31 06:51:34',NULL),(113,25,'watchdog_action','{\"title\": \"Watchdog Action\", \"description\": \"For the libvirt driver, you can enable and set the behavior of a virtual hardware watchdog device for each flavor. Watchdog devices keep an eye on the guest server, and carry out the configured action, if the server hangs. The watchdog uses the i6300esb device (emulating a PCI Intel 6300ESB). If hw_watchdog_action is not specified, the watchdog is disabled. Watchdog behavior set using a specific image\'s properties will override behavior set using flavors.\", \"type\": \"string\", \"enum\": [\"disabled\", \"reset\", \"poweroff\", \"pause\", \"none\"]}','2026-01-31 06:51:37',NULL),(114,26,'auto_disk_config','{\"title\": \"Disk Adapter Type\", \"description\": \"If true, the root partition on the disk is automatically resized before the instance boots. This value is only taken into account by the Compute service when using a Xen-based hypervisor with the XenAPI driver. The Compute service will only attempt to resize if there is a single partition on the image, and only if the partition is in ext3 or ext4 format.\", \"type\": \"boolean\"}','2026-01-31 06:51:40',NULL),(115,27,'kernel_id','{\"title\": \"Kernel ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the kernel when booting an AMI-style image.\"}','2026-01-31 06:51:40',NULL),(116,27,'ramdisk_id','{\"title\": \"Ramdisk ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the ramdisk when booting an AMI-style image.\"}','2026-01-31 06:51:40',NULL),(117,27,'instance_uuid','{\"title\": \"Instance ID\", \"type\": \"string\", \"description\": \"Metadata which can be used to record which instance this image is associated with. (Informational only, does not create an instance snapshot.)\"}','2026-01-31 06:51:41',NULL),(118,27,'architecture','{\"title\": \"CPU Architecture\", \"description\": \"The CPU architecture that must be supported by the hypervisor. For example, x86_64, arm, or ppc64. Run uname -m to get the architecture of a machine. We strongly recommend using the architecture data vocabulary defined by the libosinfo project for this purpose.\", \"type\": \"string\"}','2026-01-31 06:51:41',NULL),(119,27,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2026-01-31 06:51:41',NULL),(120,27,'hw_cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"This specifies the CPU Mode for the guest vm\", \"type\": \"string\"}','2026-01-31 06:51:41',NULL),(121,27,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2026-01-31 06:51:41',NULL),(122,27,'description','{\"title\": \"Image description\", \"description\": \"A human-readable string describing this image.\", \"type\": \"string\"}','2026-01-31 06:51:41',NULL),(123,27,'cinder_encryption_key_id','{\"title\": \"Cinder Encryption Key ID\", \"description\": \"Identifier in the OpenStack Key Management Service for the encryption key for the Block Storage Service to use when mounting a volume created from this image\", \"type\": \"string\"}','2026-01-31 06:51:42',NULL),(124,27,'cinder_encryption_key_deletion_policy','{\"title\": \"Cinder Encryption Key Deletion Policy\", \"description\": \"States the condition under which the Image Service will delete the object associated with the \'cinder_encryption_key_id\' image property.  If this property is missing, the Image Service will take no action\", \"type\": \"string\", \"enum\": [\"on_image_deletion\", \"do_not_delete\"]}','2026-01-31 06:51:42',NULL),(125,28,'img_signature','{\"title\": \"Image Signature\", \"description\": \"The signature of the image data encoded in base64 format.\", \"type\": \"string\"}','2026-01-31 06:51:42',NULL),(126,28,'img_signature_certificate_uuid','{\"title\": \"Image Signature Certificate UUID\", \"description\": \"The UUID used to retrieve the certificate from the key manager.\", \"type\": \"string\"}','2026-01-31 06:51:42',NULL),(127,28,'img_signature_hash_method','{\"title\": \"Image Signature Hash Method\", \"description\": \"The hash method used in creating the signature.\", \"type\": \"string\", \"enum\": [\"SHA-224\", \"SHA-256\", \"SHA-384\", \"SHA-512\"]}','2026-01-31 06:51:42',NULL),(128,28,'img_signature_key_type','{\"title\": \"Image Signature Key Type\", \"description\": \"The key type used in creating the signature.\", \"type\": \"string\", \"enum\": [\"RSA-PSS\", \"DSA\", \"ECC_SECT571K1\", \"ECC_SECT409K1\", \"ECC_SECT571R1\", \"ECC_SECT409R1\", \"ECC_SECP521R1\", \"ECC_SECP384R1\"]}','2026-01-31 06:51:42',NULL),(129,29,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2026-01-31 06:51:43',NULL),(130,29,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2026-01-31 06:51:44',NULL),(131,29,'os_admin_user','{\"title\": \"OS Admin User\", \"description\": \"The name of the user with admin privileges.\", \"type\": \"string\"}','2026-01-31 06:51:44',NULL),(132,33,'img_volume_type','{\"title\": \"Image Volume Type\", \"description\": \"Specifies the volume type that should be applied during new volume creation with a image. This value is passed to Cinder when creating a new volume. Priority of volume type related parameters are 1.volume_type(via API or CLI), 2.cinder_img_volume_type, 3.default_volume_type(via cinder.conf). If not specified, volume_type or default_volume_type will be referred based on their priority.\", \"type\": \"string\"}','2026-01-31 06:51:55',NULL);
/*!40000 ALTER TABLE `metadef_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_resource_types`
--

DROP TABLE IF EXISTS `metadef_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_resource_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `protected` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_resource_types_name` (`name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_resource_types`
--

LOCK TABLES `metadef_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_resource_types` (`id`, `name`, `protected`, `created_at`, `updated_at`) VALUES (1,'OS::Cinder::Volume',1,'2026-01-31 06:51:05',NULL),(2,'OS::Glance::Image',1,'2026-01-31 06:51:09',NULL),(3,'OS::Nova::Aggregate',1,'2026-01-31 06:51:10',NULL),(4,'OS::Nova::Flavor',1,'2026-01-31 06:51:11',NULL),(5,'OS::Nova::Server',1,'2026-01-31 06:51:12',NULL),(6,'OS::Trove::Instance',1,'2026-01-31 06:51:44',NULL);
/*!40000 ALTER TABLE `metadef_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_tags`
--

DROP TABLE IF EXISTS `metadef_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_tags_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_tags_name` (`name`),
  CONSTRAINT `metadef_tags_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_tags`
--

LOCK TABLES `metadef_tags` WRITE;
/*!40000 ALTER TABLE `metadef_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadef_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_info`
--

DROP TABLE IF EXISTS `task_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_info` (
  `task_id` varchar(36) NOT NULL,
  `input` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  CONSTRAINT `task_info_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_info`
--

LOCK TABLES `task_info` WRITE;
/*!40000 ALTER TABLE `task_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` varchar(36) NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `image_id` varchar(36) DEFAULT NULL,
  `request_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_tasks_deleted` (`deleted`),
  KEY `ix_tasks_owner` (`owner`),
  KEY `ix_tasks_status` (`status`),
  KEY `ix_tasks_type` (`type`),
  KEY `ix_tasks_updated_at` (`updated_at`),
  KEY `ix_tasks_image_id` (`image_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `keystone`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `keystone` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `keystone`;

--
-- Table structure for table `access_rule`
--

DROP TABLE IF EXISTS `access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(64) DEFAULT NULL,
  `path` varchar(128) DEFAULT NULL,
  `method` varchar(16) DEFAULT NULL,
  `external_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_rule_external_id_key` (`external_id`),
  UNIQUE KEY `duplicate_access_rule_for_user_constraint` (`user_id`,`service`,`path`,`method`),
  KEY `external_id` (`external_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_rule`
--

LOCK TABLES `access_rule` WRITE;
/*!40000 ALTER TABLE `access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_token`
--

DROP TABLE IF EXISTS `access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_token` (
  `id` varchar(64) NOT NULL,
  `access_secret` varchar(64) NOT NULL,
  `authorizing_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  `role_ids` text NOT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_access_token_authorizing_user_id` (`authorizing_user_id`),
  KEY `ix_access_token_consumer_id` (`consumer_id`),
  CONSTRAINT `access_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_token`
--

LOCK TABLES `access_token` WRITE;
/*!40000 ALTER TABLE `access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('29e87d24a316'),('e25ffa003242');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential`
--

DROP TABLE IF EXISTS `application_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential` (
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `secret_hash` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `system` varchar(64) DEFAULT NULL,
  `unrestricted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `duplicate_app_cred_constraint` (`user_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential`
--

LOCK TABLES `application_credential` WRITE;
/*!40000 ALTER TABLE `application_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_access_rule`
--

DROP TABLE IF EXISTS `application_credential_access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_access_rule` (
  `application_credential_id` int(11) NOT NULL,
  `access_rule_id` int(11) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`access_rule_id`),
  KEY `access_rule_id` (`access_rule_id`),
  CONSTRAINT `application_credential_access_rule_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE,
  CONSTRAINT `application_credential_access_rule_ibfk_2` FOREIGN KEY (`access_rule_id`) REFERENCES `access_rule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_access_rule`
--

LOCK TABLES `application_credential_access_rule` WRITE;
/*!40000 ALTER TABLE `application_credential_access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_role`
--

DROP TABLE IF EXISTS `application_credential_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_role` (
  `application_credential_id` int(11) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`role_id`),
  CONSTRAINT `application_credential_role_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_role`
--

LOCK TABLES `application_credential_role` WRITE;
/*!40000 ALTER TABLE `application_credential_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assignment` (
  `type` enum('UserProject','GroupProject','UserDomain','GroupDomain') NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  KEY `ix_actor_id` (`actor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserProject','0c1329ae1eaf4c70bef5e8b9509033ac','8aa8accd246f4c91857447e1cc9391b2','4a81eb6ae9b241379ea5dfe7b66fd877',0),('UserProject','0c1329ae1eaf4c70bef5e8b9509033ac','8aa8accd246f4c91857447e1cc9391b2','7f9f399b2a944bb38afe6fafcd143b1a',0),('UserProject','23611f48d74f4bb59a8d380f541b978c','8aa8accd246f4c91857447e1cc9391b2','4a81eb6ae9b241379ea5dfe7b66fd877',0),('UserProject','23611f48d74f4bb59a8d380f541b978c','8aa8accd246f4c91857447e1cc9391b2','7f9f399b2a944bb38afe6fafcd143b1a',0),('UserProject','4520278528294040b3584e8da3cdf83e','8aa8accd246f4c91857447e1cc9391b2','4a81eb6ae9b241379ea5dfe7b66fd877',0),('UserProject','4520278528294040b3584e8da3cdf83e','8aa8accd246f4c91857447e1cc9391b2','7f9f399b2a944bb38afe6fafcd143b1a',0),('UserProject','56002d9dca034ce2b7f7186567cfa432','8aa8accd246f4c91857447e1cc9391b2','4a81eb6ae9b241379ea5dfe7b66fd877',0),('UserProject','56002d9dca034ce2b7f7186567cfa432','8aa8accd246f4c91857447e1cc9391b2','7f9f399b2a944bb38afe6fafcd143b1a',0),('UserProject','59630ee0089643e78d944136d6bced30','8aa8accd246f4c91857447e1cc9391b2','4a81eb6ae9b241379ea5dfe7b66fd877',0),('UserProject','59630ee0089643e78d944136d6bced30','8aa8accd246f4c91857447e1cc9391b2','7f9f399b2a944bb38afe6fafcd143b1a',0),('UserProject','7236ad21d7ab4000b7ab6db9df93bca9','624dad82ad26433498495a3960830cf8','7f9f399b2a944bb38afe6fafcd143b1a',0),('UserProject','7236ad21d7ab4000b7ab6db9df93bca9','f1803bf3df964a3f90dda65daa6f9a53','7f9f399b2a944bb38afe6fafcd143b1a',0),('UserProject','7236ad21d7ab4000b7ab6db9df93bca9','f1803bf3df964a3f90dda65daa6f9a53','ca2733069aa142f3bec82e9ef36453f2',0),('UserProject','785b59e67da64455b59713abf44ce739','8aa8accd246f4c91857447e1cc9391b2','4a81eb6ae9b241379ea5dfe7b66fd877',0),('UserProject','785b59e67da64455b59713abf44ce739','8aa8accd246f4c91857447e1cc9391b2','7f9f399b2a944bb38afe6fafcd143b1a',0),('UserProject','a4e8b8c71ff54fc6ab4c60984f2adc58','8aa8accd246f4c91857447e1cc9391b2','4a81eb6ae9b241379ea5dfe7b66fd877',0),('UserProject','a4e8b8c71ff54fc6ab4c60984f2adc58','8aa8accd246f4c91857447e1cc9391b2','7f9f399b2a944bb38afe6fafcd143b1a',0),('UserProject','b99780d961474219b403eaf2b1627219','8aa8accd246f4c91857447e1cc9391b2','59f3f5a8126b435583b2f020ac319d86',0),('UserProject','b99780d961474219b403eaf2b1627219','8aa8accd246f4c91857447e1cc9391b2','7f9f399b2a944bb38afe6fafcd143b1a',0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_register`
--

DROP TABLE IF EXISTS `config_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_register` (
  `type` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_register`
--

LOCK TABLES `config_register` WRITE;
/*!40000 ALTER TABLE `config_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `config_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumer`
--

DROP TABLE IF EXISTS `consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumer` (
  `id` varchar(64) NOT NULL,
  `description` varchar(64) DEFAULT NULL,
  `secret` varchar(64) NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumer`
--

LOCK TABLES `consumer` WRITE;
/*!40000 ALTER TABLE `consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credential` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `key_hash` varchar(64) NOT NULL,
  `encrypted_blob` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint` (
  `id` varchar(64) NOT NULL,
  `legacy_endpoint_id` varchar(64) DEFAULT NULL,
  `interface` varchar(8) NOT NULL,
  `service_id` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `region_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_endpoint_region_id` (`region_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `endpoint_service_id_fkey` FOREIGN KEY (`service_id`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_endpoint_region_id` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
INSERT INTO `endpoint` (`id`, `legacy_endpoint_id`, `interface`, `service_id`, `url`, `extra`, `enabled`, `region_id`) VALUES ('07b7b1f9fe8f49bd840c5dc1f25a6ebf',NULL,'internal','9dc869cf4b1d407ebae3104260dcda5b','https://keystone-internal.openstack.svc:5000','{}',1,'regionOne'),('269045f2db7f41d1a9632300757fc21f',NULL,'public','9dc869cf4b1d407ebae3104260dcda5b','https://keystone-public-openstack.apps-crc.testing','{}',1,'regionOne'),('2d9fbd47438148a4aeade0ae6fa45451',NULL,'public','330f7c5b72d34ee8a0037d44f709f854','https://placement-public-openstack.apps-crc.testing','{\"name\": \"placement\"}',1,'regionOne'),('3d6f79e536b6486cac0a2d8ae833589b',NULL,'internal','ef65955ca2174b85a7cef21d36d55ecf','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne'),('3eae6ea580dc43a69c26221480052ce4',NULL,'internal','b1a5a1ce93d34afeb162bb3723bf80ce','https://barbican-internal.openstack.svc:9311','{\"name\": \"barbican\"}',1,'regionOne'),('42339381be79480fbc030090ff22d95b',NULL,'public','ef65955ca2174b85a7cef21d36d55ecf','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne'),('453432564c1b45b5bc352c891db46ec1',NULL,'public','49602f11b2c44ab4a541e9bb9c21b0b8','https://cinder-public-openstack.apps-crc.testing/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('543c64b132ba437395a598b56666b9a8',NULL,'internal','49602f11b2c44ab4a541e9bb9c21b0b8','https://cinder-internal.openstack.svc:8776/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('5c44baa126de418dadd373ab3639ec18',NULL,'public','a67a3bbb97ff45a48f45dc998bbfdd60','https://glance-default-public-openstack.apps-crc.testing','{\"name\": \"glance\"}',1,'regionOne'),('8c6edf7971b64934aa4a571c937d1e00',NULL,'internal','f679c407fb3c4d6fa80e09faa2d77b7d','https://neutron-internal.openstack.svc:9696','{\"name\": \"neutron\"}',1,'regionOne'),('b2963298766f4afea049662710f9afd0',NULL,'internal','a67a3bbb97ff45a48f45dc998bbfdd60','https://glance-default-internal.openstack.svc:9292','{\"name\": \"glance\"}',1,'regionOne'),('b3f2bf26828c4614952163e42406b07e',NULL,'public','506827dc2ec64cee97dab2f39c6e16f1','https://nova-public-openstack.apps-crc.testing/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('b85bb39ff2c14cee8a47aaae8467b798',NULL,'public','b1a5a1ce93d34afeb162bb3723bf80ce','https://barbican-public-openstack.apps-crc.testing','{\"name\": \"barbican\"}',1,'regionOne'),('bb5fb2f6728540ecabd6e1b4eae3d8ec',NULL,'internal','506827dc2ec64cee97dab2f39c6e16f1','https://nova-internal.openstack.svc:8774/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('cfff0549c8df4ff9a4fa33b4b5927859',NULL,'internal','330f7c5b72d34ee8a0037d44f709f854','https://placement-internal.openstack.svc:8778','{\"name\": \"placement\"}',1,'regionOne'),('fdf9099e608949418594e9dd8ec6260e',NULL,'public','f679c407fb3c4d6fa80e09faa2d77b7d','https://neutron-public-openstack.apps-crc.testing','{\"name\": \"neutron\"}',1,'regionOne');
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint_group`
--

DROP TABLE IF EXISTS `endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint_group` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `filters` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint_group`
--

LOCK TABLES `endpoint_group` WRITE;
/*!40000 ALTER TABLE `endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expiring_user_group_membership`
--

DROP TABLE IF EXISTS `expiring_user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expiring_user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `last_verified` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`,`idp_id`),
  KEY `group_id` (`group_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_3` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expiring_user_group_membership`
--

LOCK TABLES `expiring_user_group_membership` WRITE;
/*!40000 ALTER TABLE `expiring_user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `expiring_user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federated_user`
--

DROP TABLE IF EXISTS `federated_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federated_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `protocol_id` varchar(64) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idp_id` (`idp_id`,`protocol_id`,`unique_id`),
  KEY `federated_user_protocol_id_fkey` (`protocol_id`,`idp_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `federated_user_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_ibfk_2` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_protocol_id_fkey` FOREIGN KEY (`protocol_id`, `idp_id`) REFERENCES `federation_protocol` (`id`, `idp_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federated_user`
--

LOCK TABLES `federated_user` WRITE;
/*!40000 ALTER TABLE `federated_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `federated_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federation_protocol`
--

DROP TABLE IF EXISTS `federation_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federation_protocol` (
  `id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `mapping_id` varchar(64) NOT NULL,
  `remote_id_attribute` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`,`idp_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `federation_protocol_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federation_protocol`
--

LOCK TABLES `federation_protocol` WRITE;
/*!40000 ALTER TABLE `federation_protocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `federation_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group`
--

DROP TABLE IF EXISTS `group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group` (
  `id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_group_name_domain_id` (`domain_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group`
--

LOCK TABLES `group` WRITE;
/*!40000 ALTER TABLE `group` DISABLE KEYS */;
/*!40000 ALTER TABLE `group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `id_mapping`
--

DROP TABLE IF EXISTS `id_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `id_mapping` (
  `public_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `local_id` varchar(255) NOT NULL,
  `entity_type` enum('user','group') NOT NULL,
  PRIMARY KEY (`public_id`),
  UNIQUE KEY `domain_id` (`domain_id`,`local_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `id_mapping`
--

LOCK TABLES `id_mapping` WRITE;
/*!40000 ALTER TABLE `id_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `id_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `identity_provider`
--

DROP TABLE IF EXISTS `identity_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `identity_provider` (
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `authorization_ttl` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `identity_provider`
--

LOCK TABLES `identity_provider` WRITE;
/*!40000 ALTER TABLE `identity_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `identity_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `idp_remote_ids`
--

DROP TABLE IF EXISTS `idp_remote_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `idp_remote_ids` (
  `idp_id` varchar(64) DEFAULT NULL,
  `remote_id` varchar(255) NOT NULL,
  PRIMARY KEY (`remote_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `idp_remote_ids_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `idp_remote_ids`
--

LOCK TABLES `idp_remote_ids` WRITE;
/*!40000 ALTER TABLE `idp_remote_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `idp_remote_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `implied_role`
--

DROP TABLE IF EXISTS `implied_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `implied_role` (
  `prior_role_id` varchar(64) NOT NULL,
  `implied_role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`prior_role_id`,`implied_role_id`),
  KEY `implied_role_implied_role_id_fkey` (`implied_role_id`),
  CONSTRAINT `implied_role_implied_role_id_fkey` FOREIGN KEY (`implied_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE,
  CONSTRAINT `implied_role_prior_role_id_fkey` FOREIGN KEY (`prior_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `implied_role`
--

LOCK TABLES `implied_role` WRITE;
/*!40000 ALTER TABLE `implied_role` DISABLE KEYS */;
INSERT INTO `implied_role` (`prior_role_id`, `implied_role_id`) VALUES ('59f3f5a8126b435583b2f020ac319d86','f01974279bc64a399c07cbdda528d828'),('7f9f399b2a944bb38afe6fafcd143b1a','59f3f5a8126b435583b2f020ac319d86');
/*!40000 ALTER TABLE `implied_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `limit`
--

DROP TABLE IF EXISTS `limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `limit` (
  `id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `resource_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `registered_limit_id` varchar(64) DEFAULT NULL,
  `domain_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `limit_id_key` (`id`),
  KEY `registered_limit_id` (`registered_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `limit`
--

LOCK TABLES `limit` WRITE;
/*!40000 ALTER TABLE `limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_user`
--

DROP TABLE IF EXISTS `local_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `local_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `failed_auth_count` int(11) DEFAULT NULL,
  `failed_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_id` (`domain_id`,`name`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `local_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `local_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=254 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `local_user`
--

LOCK TABLES `local_user` WRITE;
/*!40000 ALTER TABLE `local_user` DISABLE KEYS */;
INSERT INTO `local_user` (`id`, `user_id`, `domain_id`, `name`, `failed_auth_count`, `failed_auth_at`) VALUES (1,'7236ad21d7ab4000b7ab6db9df93bca9','default','admin',0,NULL),(2,'0c1329ae1eaf4c70bef5e8b9509033ac','default','glance',0,NULL),(3,'785b59e67da64455b59713abf44ce739','default','nova',0,NULL),(4,'a4e8b8c71ff54fc6ab4c60984f2adc58','default','barbican',0,NULL),(5,'23611f48d74f4bb59a8d380f541b978c','default','ceilometer',0,NULL),(6,'4520278528294040b3584e8da3cdf83e','default','placement',0,NULL),(7,'56002d9dca034ce2b7f7186567cfa432','default','cinder',0,NULL),(8,'59630ee0089643e78d944136d6bced30','default','neutron',0,NULL),(9,'b99780d961474219b403eaf2b1627219','default','swift',0,NULL),(10,'081828351901493690484ec6ac138e05','default','demo_tempestconf',0,NULL),(11,'4b43316665864b4e8e638e38986e06e4','default','alt_demo_tempestconf',0,NULL);
/*!40000 ALTER TABLE `local_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mapping`
--

DROP TABLE IF EXISTS `mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mapping` (
  `id` varchar(64) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mapping`
--

LOCK TABLES `mapping` WRITE;
/*!40000 ALTER TABLE `mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nonlocal_user`
--

DROP TABLE IF EXISTS `nonlocal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nonlocal_user` (
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  PRIMARY KEY (`domain_id`,`name`),
  UNIQUE KEY `ixu_nonlocal_user_user_id` (`user_id`),
  KEY `nonlocal_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `nonlocal_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nonlocal_user`
--

LOCK TABLES `nonlocal_user` WRITE;
/*!40000 ALTER TABLE `nonlocal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `nonlocal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password`
--

DROP TABLE IF EXISTS `password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_user_id` int(11) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `self_service` tinyint(1) NOT NULL DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `created_at_int` bigint(20) NOT NULL DEFAULT 0,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `local_user_id` (`local_user_id`),
  CONSTRAINT `password_ibfk_1` FOREIGN KEY (`local_user_id`) REFERENCES `local_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=254 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password`
--

LOCK TABLES `password` WRITE;
/*!40000 ALTER TABLE `password` DISABLE KEYS */;
INSERT INTO `password` (`id`, `local_user_id`, `expires_at`, `self_service`, `password_hash`, `created_at_int`, `expires_at_int`, `created_at`) VALUES (1,1,NULL,0,'$2b$12$/69v7jRBsV//7rpZxh6Iyur6DDoGfl3WjvzUHyCNI2zF5ESusF5Mi',1769842162140167,NULL,'2026-01-31 06:49:22'),(2,2,NULL,0,'$2b$12$zj/Si9HIG8xTYbJI.3nX/eQtoKyDO66y8Dm9xT3Lpyxcr/KeV2o5S',1769842262865930,NULL,'2026-01-31 06:51:02'),(3,3,NULL,0,'$2b$12$fzhtH6.LSWXgKLeQiO6Vde1UZYi6WnNXe87AGUtYj.7/Xa7Q6XePK',1769842273155820,NULL,'2026-01-31 06:51:13'),(4,4,NULL,0,'$2b$12$P7PC8EQ4SW39G3AmUBmtze2KRFTCE0Jve6dEQnxIKuYtYEvR5n11a',1769842279917570,NULL,'2026-01-31 06:51:19'),(5,5,NULL,0,'$2b$12$PTmisKP2J4annHxn9QAitOPEOjlq5geFueoCOJWnJCD98s5td9yr6',1769842288903450,NULL,'2026-01-31 06:51:28'),(6,6,NULL,0,'$2b$12$SR.6WnFVu4pwPC/m.vt1AeqnwZ7iNjaza7ORv.DoDXlHblVF/qK4y',1769842332425483,NULL,'2026-01-31 06:52:12'),(7,7,NULL,0,'$2b$12$WWRUneYQ10Cyh3M4X47GDe0GC1uUSSQBOgGgYxMlEGWlb4MSXN0lq',1769842337672758,NULL,'2026-01-31 06:52:17'),(8,8,NULL,0,'$2b$12$VHCFa1Fypc0qnD51rblGxOaNfBJRZTEuhbPssWf2pLFYEcL2zDyKS',1769842356022503,NULL,'2026-01-31 06:52:36'),(9,9,NULL,0,'$2b$12$zkvBua2NLHImXdb3a3.QDu/m9hIq1k8WQIkpvSHcZjPdL8m6/yvuq',1769843316943242,NULL,'2026-01-31 07:08:36'),(10,10,NULL,0,'$2b$12$3JYaH0eamwjwErqxKXdZReFQr04XyagQ8S6nbkiden3BMlLhY3iIe',1769844558031761,NULL,'2026-01-31 07:29:18'),(11,11,NULL,0,'$2b$12$GR6RZHbA2aiVP6GCTApHKO5VVZFqShPGO9DyH1BVw12aZbAWDXMWe',1769844559091745,NULL,'2026-01-31 07:29:19');
/*!40000 ALTER TABLE `password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `blob` text NOT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_association`
--

DROP TABLE IF EXISTS `policy_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy_association` (
  `id` varchar(64) NOT NULL,
  `policy_id` varchar(64) NOT NULL,
  `endpoint_id` varchar(64) DEFAULT NULL,
  `service_id` varchar(64) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `endpoint_id` (`endpoint_id`,`service_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_association`
--

LOCK TABLES `policy_association` WRITE;
/*!40000 ALTER TABLE `policy_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project` (
  `id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL,
  `is_domain` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_project_name_domain_id` (`domain_id`,`name`),
  KEY `project_parent_id_fkey` (`parent_id`),
  CONSTRAINT `project_domain_id_fkey` FOREIGN KEY (`domain_id`) REFERENCES `project` (`id`),
  CONSTRAINT `project_parent_id_fkey` FOREIGN KEY (`parent_id`) REFERENCES `project` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
INSERT INTO `project` (`id`, `name`, `extra`, `description`, `enabled`, `domain_id`, `parent_id`, `is_domain`) VALUES ('624dad82ad26433498495a3960830cf8','demo','{}','Project for Tempest demo_tempestconf user',1,'default','default',0),('8aa8accd246f4c91857447e1cc9391b2','service','{}','service',1,'default','default',0),('<<keystone.domain.root>>','<<keystone.domain.root>>','{}','',0,'<<keystone.domain.root>>',NULL,1),('a60ce9f4e8ce44949e0e7997297c4ab2','alt_demo','{}','Project for Tempest alt_demo_tempestconf user',1,'default','default',0),('default','Default','{}','The default domain',1,'<<keystone.domain.root>>',NULL,1),('f1803bf3df964a3f90dda65daa6f9a53','admin','{}','Bootstrap project for initializing the cloud.',1,'default','default',0);
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint`
--

DROP TABLE IF EXISTS `project_endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint` (
  `endpoint_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint`
--

LOCK TABLES `project_endpoint` WRITE;
/*!40000 ALTER TABLE `project_endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint_group`
--

DROP TABLE IF EXISTS `project_endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint_group` (
  `endpoint_group_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_group_id`,`project_id`),
  CONSTRAINT `project_endpoint_group_ibfk_1` FOREIGN KEY (`endpoint_group_id`) REFERENCES `endpoint_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint_group`
--

LOCK TABLES `project_endpoint_group` WRITE;
/*!40000 ALTER TABLE `project_endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_option`
--

DROP TABLE IF EXISTS `project_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_option` (
  `project_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`project_id`,`option_id`),
  CONSTRAINT `project_option_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_option`
--

LOCK TABLES `project_option` WRITE;
/*!40000 ALTER TABLE `project_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_tag`
--

DROP TABLE IF EXISTS `project_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_tag` (
  `project_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`project_id`,`name`),
  UNIQUE KEY `project_id` (`project_id`,`name`),
  CONSTRAINT `project_tag_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_tag`
--

LOCK TABLES `project_tag` WRITE;
/*!40000 ALTER TABLE `project_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `parent_region_id` varchar(255) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` (`id`, `description`, `parent_region_id`, `extra`) VALUES ('regionOne','',NULL,'{}');
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registered_limit`
--

DROP TABLE IF EXISTS `registered_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `registered_limit` (
  `id` varchar(64) NOT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `default_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `registered_limit_id_key` (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `registered_limit`
--

LOCK TABLES `registered_limit` WRITE;
/*!40000 ALTER TABLE `registered_limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `registered_limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_token`
--

DROP TABLE IF EXISTS `request_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_token` (
  `id` varchar(64) NOT NULL,
  `request_secret` varchar(64) NOT NULL,
  `verifier` varchar(64) DEFAULT NULL,
  `authorizing_user_id` varchar(64) DEFAULT NULL,
  `requested_project_id` varchar(64) NOT NULL,
  `role_ids` text DEFAULT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_request_token_consumer_id` (`consumer_id`),
  CONSTRAINT `request_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_token`
--

LOCK TABLES `request_token` WRITE;
/*!40000 ALTER TABLE `request_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revocation_event`
--

DROP TABLE IF EXISTS `revocation_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revocation_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` varchar(64) DEFAULT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  `role_id` varchar(64) DEFAULT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `consumer_id` varchar(64) DEFAULT NULL,
  `access_token_id` varchar(64) DEFAULT NULL,
  `issued_before` datetime NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `revoked_at` datetime NOT NULL,
  `audit_id` varchar(32) DEFAULT NULL,
  `audit_chain_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_revocation_event_audit_id_issued_before` (`audit_id`,`issued_before`),
  KEY `ix_revocation_event_new_revoked_at` (`revoked_at`),
  KEY `ix_revocation_event_issued_before` (`issued_before`),
  KEY `ix_revocation_event_project_id_issued_before` (`project_id`,`issued_before`),
  KEY `ix_revocation_event_user_id_issued_before` (`user_id`,`issued_before`)
) ENGINE=InnoDB AUTO_INCREMENT=482 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revocation_event`
--

LOCK TABLES `revocation_event` WRITE;
/*!40000 ALTER TABLE `revocation_event` DISABLE KEYS */;
INSERT INTO `revocation_event` (`id`, `domain_id`, `project_id`, `user_id`, `role_id`, `trust_id`, `consumer_id`, `access_token_id`, `issued_before`, `expires_at`, `revoked_at`, `audit_id`, `audit_chain_id`) VALUES (280,NULL,NULL,'46f81e876bc74bce80d1cdb57cd04752',NULL,NULL,NULL,NULL,'2026-01-31 07:49:36',NULL,'2026-01-31 07:49:36',NULL,NULL),(281,NULL,'204ee17508b64808bd35a0370f5c7d61',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:49:38',NULL,'2026-01-31 07:49:38',NULL,NULL),(282,NULL,NULL,'464fb513247a4057820d05a29487c043',NULL,NULL,NULL,NULL,'2026-01-31 07:49:42',NULL,'2026-01-31 07:49:42',NULL,NULL),(283,NULL,'4494f0f8d0134e738a023b72a8ea8ec9',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:49:44',NULL,'2026-01-31 07:49:44',NULL,NULL),(284,NULL,NULL,'1f49c380515b47a5996feeec42e5e410',NULL,NULL,NULL,NULL,'2026-01-31 07:49:47',NULL,'2026-01-31 07:49:47',NULL,NULL),(285,NULL,'b28f3eeea44c4119a027a38df81767ae',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:49:49',NULL,'2026-01-31 07:49:49',NULL,NULL),(286,NULL,NULL,'1b0a2b45cb1a4f21bc266b37b9df1b80',NULL,NULL,NULL,NULL,'2026-01-31 07:49:54',NULL,'2026-01-31 07:49:54',NULL,NULL),(287,NULL,'425bf8417c72454e9551e1afd458c61b',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:49:58',NULL,'2026-01-31 07:49:58',NULL,NULL),(288,NULL,NULL,'97abab8eb79247cd89fb2ebff295b890',NULL,NULL,NULL,NULL,'2026-01-31 07:50:05',NULL,'2026-01-31 07:50:05',NULL,NULL),(289,NULL,'f299640bb1f64e5fa12b23955e5a2127',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:50:08',NULL,'2026-01-31 07:50:08',NULL,NULL),(290,NULL,NULL,'1497b216d5784688becdd387b89f9c76',NULL,NULL,NULL,NULL,'2026-01-31 07:50:09',NULL,'2026-01-31 07:50:09',NULL,NULL),(291,NULL,'bccb910cacf24941a5b053ed0699af32',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:50:11',NULL,'2026-01-31 07:50:11',NULL,NULL),(292,NULL,NULL,'384c79e6eafa4913ad029ce16e57e4ed',NULL,NULL,NULL,NULL,'2026-01-31 07:50:19',NULL,'2026-01-31 07:50:19',NULL,NULL),(293,NULL,'9b2ffc13611f4a8481f11dfdddb58e2b',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:50:20',NULL,'2026-01-31 07:50:20',NULL,NULL),(294,NULL,NULL,'07aa1b5aaea444449f8ef00dfe56e8eb',NULL,NULL,NULL,NULL,'2026-01-31 07:51:12',NULL,'2026-01-31 07:51:12',NULL,NULL),(295,NULL,'2a52e7591d7f4e068e3f9fa0e4e288d5',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:51:17',NULL,'2026-01-31 07:51:17',NULL,NULL),(296,NULL,NULL,'740bac6c626349c08c76a3db3a6060b9',NULL,NULL,NULL,NULL,'2026-01-31 07:51:21',NULL,'2026-01-31 07:51:21',NULL,NULL),(297,NULL,'78ef9d49a6e847d182e2f27ef141c65c',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:51:30',NULL,'2026-01-31 07:51:30',NULL,NULL),(298,NULL,NULL,'da7f93fef8fa4e0d8682702e040a7476',NULL,NULL,NULL,NULL,'2026-01-31 07:52:31',NULL,'2026-01-31 07:52:31',NULL,NULL),(299,NULL,'c8a037791bb04bafaec8d4639d3907ae',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:52:32',NULL,'2026-01-31 07:52:32',NULL,NULL),(300,NULL,NULL,'93403129e78e44f3916d321433a31bd2',NULL,NULL,NULL,NULL,'2026-01-31 07:53:28',NULL,'2026-01-31 07:53:28',NULL,NULL),(301,NULL,NULL,'db9fe8a6ca1443d099966af09b0a5402',NULL,NULL,NULL,NULL,'2026-01-31 07:53:30',NULL,'2026-01-31 07:53:30',NULL,NULL),(302,NULL,'4a9ee1af66824e368ddad5ea68a3201b',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:53:30',NULL,'2026-01-31 07:53:30',NULL,NULL),(303,NULL,'4ce2602aa08c4766b5f575340b920fd7',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:53:32',NULL,'2026-01-31 07:53:32',NULL,NULL),(304,NULL,NULL,'eb0d7106e4b04ac980748beb40d5cedf',NULL,NULL,NULL,NULL,'2026-01-31 07:53:41',NULL,'2026-01-31 07:53:41',NULL,NULL),(305,NULL,NULL,'ae0bcac3402d418babb3436e4d93fb5f',NULL,NULL,NULL,NULL,'2026-01-31 07:53:46',NULL,'2026-01-31 07:53:46',NULL,NULL),(306,NULL,'3264618ebdfa4478919141d5d3c4d3b3',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:53:52',NULL,'2026-01-31 07:53:52',NULL,NULL),(307,NULL,'88d584466c7049f8b5724880cbaa3d65',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:53:57',NULL,'2026-01-31 07:53:57',NULL,NULL),(308,NULL,NULL,'73dd06404c1f40adb74b624862a57628',NULL,NULL,NULL,NULL,'2026-01-31 07:55:56',NULL,'2026-01-31 07:55:56',NULL,NULL),(309,NULL,'71d60d9604414f9d88093c29f5f816cb',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:56:05',NULL,'2026-01-31 07:56:05',NULL,NULL),(310,NULL,NULL,'41f8b35d7c8b43d9b3583e6e2b1385cb',NULL,NULL,NULL,NULL,'2026-01-31 07:56:28',NULL,'2026-01-31 07:56:28',NULL,NULL),(311,NULL,'9bc07928b022430ba8bcc450bbb5c7f5',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:56:32',NULL,'2026-01-31 07:56:32',NULL,NULL),(312,NULL,NULL,'56eecf4373334b18a454186e0c54e924',NULL,NULL,NULL,NULL,'2026-01-31 07:58:16',NULL,'2026-01-31 07:58:16',NULL,NULL),(313,NULL,'56ce08a86486427fbebbfbd075cdb404',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:58:23',NULL,'2026-01-31 07:58:23',NULL,NULL),(314,NULL,NULL,'1e1c5eef3d264666bc90735dd338d82a',NULL,NULL,NULL,NULL,'2026-01-31 07:58:24',NULL,'2026-01-31 07:58:24',NULL,NULL),(315,NULL,'a8cbd6cc22654dfab04487522a63426c',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:58:30',NULL,'2026-01-31 07:58:30',NULL,NULL),(316,NULL,NULL,'f60419a58aea43b9a0b6db7d61d71246',NULL,NULL,NULL,NULL,'2026-01-31 07:58:55',NULL,'2026-01-31 07:58:55',NULL,NULL),(317,NULL,'1cd91610847a480caeee0ae3cdabf066',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:58:57',NULL,'2026-01-31 07:58:57',NULL,NULL),(318,NULL,NULL,'f64f1ef9370e4177b114d6c71857656d',NULL,NULL,NULL,NULL,'2026-01-31 07:59:10',NULL,'2026-01-31 07:59:10',NULL,NULL),(319,NULL,'777e9a4d5b284c9eb16aa35161bd7517',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:59:12',NULL,'2026-01-31 07:59:12',NULL,NULL),(320,NULL,NULL,'fb422aa2270c43fa9ecb0da10968f867',NULL,NULL,NULL,NULL,'2026-01-31 08:00:14',NULL,'2026-01-31 08:00:14',NULL,NULL),(321,NULL,'18503ca80bcc4b588e398b4f03f7908b',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:00:20',NULL,'2026-01-31 08:00:20',NULL,NULL),(322,NULL,NULL,'ea670e6956634b1b82cb9bcb09ff4400',NULL,NULL,NULL,NULL,'2026-01-31 08:00:33',NULL,'2026-01-31 08:00:33',NULL,NULL),(323,NULL,'eefab01229294ca9bb0e9aed1933e3b4',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:00:41',NULL,'2026-01-31 08:00:41',NULL,NULL),(324,NULL,NULL,'d454a4ec91e645e992f4a88ac60da747',NULL,NULL,NULL,NULL,'2026-01-31 08:02:43',NULL,'2026-01-31 08:02:43',NULL,NULL),(325,NULL,NULL,'b7e06c7b201d4fd29480f9c644aa478f',NULL,NULL,NULL,NULL,'2026-01-31 08:02:43',NULL,'2026-01-31 08:02:43',NULL,NULL),(326,NULL,'2ab30fd72657435fb442fc59a53da644',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:02:44',NULL,'2026-01-31 08:02:44',NULL,NULL),(327,NULL,'1fd2be04c6f44bee96e151fe63374aa9',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:02:46',NULL,'2026-01-31 08:02:46',NULL,NULL),(328,NULL,NULL,'63e95edea0164ae2a9820dc10467335d',NULL,NULL,NULL,NULL,'2026-01-31 08:04:44',NULL,'2026-01-31 08:04:44',NULL,NULL),(329,NULL,'be74d11d2f5a4d9aae2dbe32c31ad9c3',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:04:46',NULL,'2026-01-31 08:04:46',NULL,NULL),(330,NULL,NULL,'a4721a8ec2c640e9974410c4fff33dfc',NULL,NULL,NULL,NULL,'2026-01-31 08:05:40',NULL,'2026-01-31 08:05:40',NULL,NULL),(331,NULL,'37e2e9f699f541eda70b24ee42388ea2',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:05:41',NULL,'2026-01-31 08:05:41',NULL,NULL),(332,NULL,NULL,'8ff6e8783c3f4132b787cb0653fff9b0',NULL,NULL,NULL,NULL,'2026-01-31 08:06:34',NULL,'2026-01-31 08:06:34',NULL,NULL),(333,NULL,NULL,'789f0674c10a41d1ae97f6e29b4b9989',NULL,NULL,NULL,NULL,'2026-01-31 08:06:34',NULL,'2026-01-31 08:06:34',NULL,NULL),(334,NULL,'70237af45fdf4162ac04bfb85844ca9d',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:06:35',NULL,'2026-01-31 08:06:35',NULL,NULL),(335,NULL,'2327b93dd7d648efad6d2b303f9e462e',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:06:36',NULL,'2026-01-31 08:06:36',NULL,NULL),(336,NULL,NULL,'972b6e928f014e5394261f9c8655f1de',NULL,NULL,NULL,NULL,'2026-01-31 08:06:45',NULL,'2026-01-31 08:06:45',NULL,NULL),(337,NULL,'43b462f5b43d48b4a33a13b069618e4c',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:06:50',NULL,'2026-01-31 08:06:50',NULL,NULL),(338,NULL,NULL,'31043e345f6b48b585fb7b8ab7304764',NULL,NULL,NULL,NULL,'2026-01-31 08:07:45',NULL,'2026-01-31 08:07:45',NULL,NULL),(339,NULL,'d352316ff6534075952e2d0c28061b09',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:07:50',NULL,'2026-01-31 08:07:50',NULL,NULL),(340,NULL,NULL,'5ba00f420cd940ff802c16e8c25c35c4',NULL,NULL,NULL,NULL,'2026-01-31 08:08:25',NULL,'2026-01-31 08:08:25',NULL,NULL),(341,NULL,'b97d933ec6c34696b0483a895f47feef',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:08:28',NULL,'2026-01-31 08:08:28',NULL,NULL),(342,NULL,NULL,'d9ed446fb2cf4fc0a4e619c6c766fddc',NULL,NULL,NULL,NULL,'2026-01-31 08:08:33',NULL,'2026-01-31 08:08:33',NULL,NULL),(343,NULL,NULL,'cee6b6562ca2446393f78dea508a5df1',NULL,NULL,NULL,NULL,'2026-01-31 08:08:34',NULL,'2026-01-31 08:08:34',NULL,NULL),(344,NULL,'1fcec9ca13964c7191134db4420ab049',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:08:35',NULL,'2026-01-31 08:08:35',NULL,NULL),(345,NULL,'bab8ede4b1e1465c80bdf42d46ba937c',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:08:37',NULL,'2026-01-31 08:08:37',NULL,NULL),(346,NULL,NULL,'41e4bf44a95742c68d5709b7cd31d18b',NULL,NULL,NULL,NULL,'2026-01-31 08:08:58',NULL,'2026-01-31 08:08:58',NULL,NULL),(347,NULL,'861b60b5b65c4460a2d622f9ae973d86',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:08:59',NULL,'2026-01-31 08:08:59',NULL,NULL),(348,NULL,NULL,'f694162f685a48139cf09d24531572e2',NULL,NULL,NULL,NULL,'2026-01-31 08:09:47',NULL,'2026-01-31 08:09:47',NULL,NULL),(349,NULL,NULL,'221dc0e49994443e8b86a6a9949ee1aa',NULL,NULL,NULL,NULL,'2026-01-31 08:09:48',NULL,'2026-01-31 08:09:48',NULL,NULL),(350,NULL,'acc43e4b8be149d9adc0a3c8e9f9ddd7',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:09:49',NULL,'2026-01-31 08:09:49',NULL,NULL),(351,NULL,'0e5e834897a04940b210da74cc674879',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:09:50',NULL,'2026-01-31 08:09:50',NULL,NULL),(352,NULL,NULL,'980bfa1a3c534ad9a69602ee65887906',NULL,NULL,NULL,NULL,'2026-01-31 08:10:30',NULL,'2026-01-31 08:10:30',NULL,NULL),(353,NULL,'81972c04c41b4103927f1d36518986c8',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:10:31',NULL,'2026-01-31 08:10:31',NULL,NULL),(354,NULL,NULL,'162a66f52a10400aad586654cbabfbfd',NULL,NULL,NULL,NULL,'2026-01-31 08:10:50',NULL,'2026-01-31 08:10:50',NULL,NULL),(355,NULL,NULL,'6215f7b8636349358e68ad58782a5ed9',NULL,NULL,NULL,NULL,'2026-01-31 08:10:53',NULL,'2026-01-31 08:10:53',NULL,NULL),(356,NULL,'1bd92af54c2f44f1913c48ef5ebd6c42',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:10:53',NULL,'2026-01-31 08:10:53',NULL,NULL),(357,NULL,'9d0c9f5a2b074ef290312d1045d1747f',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:10:55',NULL,'2026-01-31 08:10:55',NULL,NULL),(358,NULL,NULL,'358ec3f014264f7c89f19a9ad2ce8166',NULL,NULL,NULL,NULL,'2026-01-31 08:11:47',NULL,'2026-01-31 08:11:47',NULL,NULL),(359,NULL,'0268430b3cb6412c94362feb0e114d3b',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:11:51',NULL,'2026-01-31 08:11:51',NULL,NULL),(360,NULL,NULL,'6ab9e181016f4d5a899c91dae3aa26e0',NULL,NULL,NULL,NULL,'2026-01-31 08:15:06',NULL,'2026-01-31 08:15:06',NULL,NULL),(361,NULL,'cbd0f41e455b4b3b9a8edf35ef0b85ed',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:15:13',NULL,'2026-01-31 08:15:13',NULL,NULL),(362,NULL,NULL,'5366d122b359489fb9d2bda8d19611a6',NULL,NULL,NULL,NULL,'2026-01-31 08:15:33',NULL,'2026-01-31 08:15:33',NULL,NULL),(363,NULL,NULL,'e928e8e2719b471c8b2087aa2f0bfd6d',NULL,NULL,NULL,NULL,'2026-01-31 08:15:33',NULL,'2026-01-31 08:15:33',NULL,NULL),(364,NULL,'4aa06cf35d8c468fb16884f19dc8ce71',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:15:36',NULL,'2026-01-31 08:15:36',NULL,NULL),(365,NULL,NULL,'811fc064a56744afb183cbb4695db65e',NULL,NULL,NULL,NULL,'2026-01-31 08:15:41',NULL,'2026-01-31 08:15:41',NULL,NULL),(366,NULL,'eebd77ea383043c79c9af2d2712ac16b',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:15:44',NULL,'2026-01-31 08:15:44',NULL,NULL),(367,NULL,NULL,'b161ff9ec17b4398b91a1d6f0aaeea12',NULL,NULL,NULL,NULL,'2026-01-31 08:15:47',NULL,'2026-01-31 08:15:47',NULL,NULL),(368,NULL,'2e9b3b2cf597445e9c5dd696eb1ced7b',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:15:49',NULL,'2026-01-31 08:15:49',NULL,NULL),(369,NULL,NULL,'18aee9d81d404f77ac81cde538f140d8',NULL,NULL,NULL,NULL,'2026-01-31 08:16:01',NULL,'2026-01-31 08:16:01',NULL,NULL),(370,NULL,'c3ddadeb950a490db5c99da98a32c9ec',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:16:02',NULL,'2026-01-31 08:16:02',NULL,NULL),(371,NULL,NULL,'5e598a75077944569409ad429a456aea',NULL,NULL,NULL,NULL,'2026-01-31 08:16:08',NULL,'2026-01-31 08:16:08',NULL,NULL),(372,NULL,'20a1c4d130394aa79f7e0825cb720528',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:16:10',NULL,'2026-01-31 08:16:10',NULL,NULL),(373,NULL,NULL,'9ca99c4062164ef3b438a9f924677d01',NULL,NULL,NULL,NULL,'2026-01-31 08:17:44',NULL,'2026-01-31 08:17:44',NULL,NULL),(374,NULL,NULL,'21b05a653cb94d85be61298e8b0d972a',NULL,NULL,NULL,NULL,'2026-01-31 08:17:44',NULL,'2026-01-31 08:17:44',NULL,NULL),(375,NULL,'01ce47028736438f9ad0116eb59179ee',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:17:48',NULL,'2026-01-31 08:17:48',NULL,NULL),(376,NULL,'120d0fd1a2da48e3b76cc3c39ee91084',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:17:51',NULL,'2026-01-31 08:17:51',NULL,NULL),(377,NULL,NULL,'1996e83a53d240ae97292577aa404eb4',NULL,NULL,NULL,NULL,'2026-01-31 08:18:01',NULL,'2026-01-31 08:18:01',NULL,NULL),(378,NULL,'ba633b0d15d54200a76696d54ffca7fc',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:18:04',NULL,'2026-01-31 08:18:04',NULL,NULL),(379,NULL,NULL,'8c6601bfb5e74d24897f5c67e7765ffe',NULL,NULL,NULL,NULL,'2026-01-31 08:18:22',NULL,'2026-01-31 08:18:22',NULL,NULL),(380,NULL,'b2f8be0146584893ac5b769dff931958',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:18:26',NULL,'2026-01-31 08:18:26',NULL,NULL),(381,NULL,NULL,'d7d9a44201d548aba1e1654e136ddd06',NULL,NULL,NULL,NULL,'2026-01-31 08:19:07',NULL,'2026-01-31 08:19:07',NULL,NULL),(382,NULL,'1633c84ea1bf46b080aaafd30bbcf25f',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:19:09',NULL,'2026-01-31 08:19:09',NULL,NULL),(383,NULL,NULL,'90313c82677c4144953c58efc0e13c3e',NULL,NULL,NULL,NULL,'2026-01-31 08:19:15',NULL,'2026-01-31 08:19:15',NULL,NULL),(384,NULL,'bda3ebf6541d46309fc9b2ce089dd857',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:19:19',NULL,'2026-01-31 08:19:19',NULL,NULL),(385,NULL,NULL,'35ab955828314bdc9adf0dff227f0b71',NULL,NULL,NULL,NULL,'2026-01-31 08:19:34',NULL,'2026-01-31 08:19:34',NULL,NULL),(386,NULL,'6bd585668c8f42ad9197c73d4bd2ca6f',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:19:37',NULL,'2026-01-31 08:19:37',NULL,NULL),(387,NULL,NULL,'fdeb8f10b75f4d65be0e243714de9420',NULL,NULL,NULL,NULL,'2026-01-31 08:20:32',NULL,'2026-01-31 08:20:32',NULL,NULL),(388,NULL,'5946643c9f6741e299159c7a6903a9f9',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:20:34',NULL,'2026-01-31 08:20:34',NULL,NULL),(389,NULL,NULL,'3b153d2832404e5b9250422b70ba522d',NULL,NULL,NULL,NULL,'2026-01-31 08:21:01',NULL,'2026-01-31 08:21:01',NULL,NULL),(390,NULL,'3b06982960ad4453b8e542cb6330835d',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:21:03',NULL,'2026-01-31 08:21:03',NULL,NULL),(391,NULL,NULL,'7f0be9090fdf49d2ac15246a0a820d3f',NULL,NULL,NULL,NULL,'2026-01-31 08:23:10',NULL,'2026-01-31 08:23:10',NULL,NULL),(392,NULL,NULL,'d70e6793c39b4798abcefeb9422d6f12',NULL,NULL,NULL,NULL,'2026-01-31 08:23:11',NULL,'2026-01-31 08:23:11',NULL,NULL),(393,NULL,'06ec257548f84884b0861e53500df1cd',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:23:13',NULL,'2026-01-31 08:23:13',NULL,NULL),(394,NULL,'134c066ac92844ff853b216870fa8eed',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:23:15',NULL,'2026-01-31 08:23:15',NULL,NULL),(395,NULL,NULL,'6788b0883cb348719d1222b1c9483be2',NULL,NULL,NULL,NULL,'2026-01-31 08:23:16',NULL,'2026-01-31 08:23:16',NULL,NULL),(396,NULL,'4849ff916e1b4e2aa162faaf2c0717a2',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:23:20',NULL,'2026-01-31 08:23:20',NULL,NULL),(397,NULL,NULL,'a1da90915f9344c292a208246f6a75ff',NULL,NULL,NULL,NULL,'2026-01-31 08:24:06',NULL,'2026-01-31 08:24:06',NULL,NULL),(398,NULL,'17987cbe856c4f6aab27787ff02572d5',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:24:08',NULL,'2026-01-31 08:24:08',NULL,NULL),(399,NULL,NULL,'c5be034949844ed2ac84259147655163',NULL,NULL,NULL,NULL,'2026-01-31 08:24:12',NULL,'2026-01-31 08:24:12',NULL,NULL),(400,NULL,'2750bf3af9824ee9a1b53caa9395ce01',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:24:13',NULL,'2026-01-31 08:24:13',NULL,NULL),(401,NULL,NULL,'038e2b3b4f174162a3ac6c4870857e60',NULL,NULL,NULL,NULL,'2026-01-31 08:25:23',NULL,'2026-01-31 08:25:23',NULL,NULL),(402,NULL,'c90ea7f1be5f484bb873548236fadc00',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:25:27',NULL,'2026-01-31 08:25:27',NULL,NULL),(403,NULL,NULL,'3ada90dc4b77478cb4b93c63409d8537',NULL,NULL,NULL,NULL,'2026-01-31 08:25:28',NULL,'2026-01-31 08:25:28',NULL,NULL),(404,NULL,'fdf18f1faf4846e2a6e2eab4ac2aec02',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:25:32',NULL,'2026-01-31 08:25:32',NULL,NULL),(405,NULL,NULL,'3ebb4f01dd6e420b91e5f2282ecfd49d',NULL,NULL,NULL,NULL,'2026-01-31 08:26:29',NULL,'2026-01-31 08:26:29',NULL,NULL),(406,NULL,NULL,'49e8401f845140b8828aab35a8ebc698',NULL,NULL,NULL,NULL,'2026-01-31 08:26:29',NULL,'2026-01-31 08:26:29',NULL,NULL),(407,NULL,'03f29bb9f284401a8ff5c6431219974b',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:26:33',NULL,'2026-01-31 08:26:33',NULL,NULL),(408,NULL,NULL,'678cc7a5b6654a4183681a8f76675585',NULL,NULL,NULL,NULL,'2026-01-31 08:26:37',NULL,'2026-01-31 08:26:37',NULL,NULL),(409,NULL,NULL,'024f8feedf7d48b3a579b621c5ea8129',NULL,NULL,NULL,NULL,'2026-01-31 08:26:37',NULL,'2026-01-31 08:26:37',NULL,NULL),(410,NULL,'34f0cdf19ff24de2bf3b24e99db43b0f',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:26:40',NULL,'2026-01-31 08:26:40',NULL,NULL),(411,NULL,NULL,'c3fccb843f7e4945a32e8bd3ea398cbe',NULL,NULL,NULL,NULL,'2026-01-31 08:27:15',NULL,'2026-01-31 08:27:15',NULL,NULL),(412,NULL,'8c8f9946318d4a17b0d659dea7815cb7',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:27:21',NULL,'2026-01-31 08:27:21',NULL,NULL),(413,NULL,NULL,'48d684de9ba340f48e249b4cce857bfa',NULL,NULL,NULL,NULL,'2026-01-31 08:32:21',NULL,'2026-01-31 08:32:21',NULL,NULL),(414,NULL,'418d5319c640455ab23850c0b0f24f92',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:32:25',NULL,'2026-01-31 08:32:25',NULL,NULL),(415,NULL,NULL,'85c39e9c52d84f4185c0afab0f3fb734',NULL,NULL,NULL,NULL,'2026-01-31 08:32:39',NULL,'2026-01-31 08:32:39',NULL,NULL),(416,NULL,NULL,'85dfa8546d9942648bb4197c8b1947e3',NULL,NULL,NULL,NULL,'2026-01-31 08:32:40',NULL,'2026-01-31 08:32:40',NULL,NULL),(417,NULL,'48bbdbdee526499e90da7e971ede68d3',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:32:46',NULL,'2026-01-31 08:32:46',NULL,NULL),(418,NULL,'b71e7a1d6f714f7680acaa04670308f6',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:32:47',NULL,'2026-01-31 08:32:47',NULL,NULL),(419,NULL,NULL,'2a735f9cbf0d459896a036bb9845ef3d',NULL,NULL,NULL,NULL,'2026-01-31 08:33:26',NULL,'2026-01-31 08:33:26',NULL,NULL),(420,NULL,'92845e9c9ab24edbb2412cff577a0903',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:33:29',NULL,'2026-01-31 08:33:29',NULL,NULL),(421,NULL,NULL,'eac51187531841e2891fc5d3c5f84123',NULL,NULL,NULL,NULL,'2026-01-31 08:33:36',NULL,'2026-01-31 08:33:36',NULL,NULL),(422,NULL,'722ab2e9dd674709953be812d4c88493',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:33:39',NULL,'2026-01-31 08:33:39',NULL,NULL),(423,NULL,NULL,'f35e7c5bd29b4f94b5f0472543c418b2',NULL,NULL,NULL,NULL,'2026-01-31 08:33:45',NULL,'2026-01-31 08:33:45',NULL,NULL),(424,NULL,'846a950a225342f3879d0db00f9e4011',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:33:48',NULL,'2026-01-31 08:33:48',NULL,NULL),(425,NULL,NULL,'b750e0622d8144aca31bb33f213fce68',NULL,NULL,NULL,NULL,'2026-01-31 08:35:37',NULL,'2026-01-31 08:35:37',NULL,NULL),(426,NULL,NULL,'f601ac628957410b995fa67e240e4871',NULL,NULL,NULL,NULL,'2026-01-31 08:35:37',NULL,'2026-01-31 08:35:37',NULL,NULL),(427,NULL,'d69b70b0e4e340758cc43d45c1113d2f',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:35:53',NULL,'2026-01-31 08:35:53',NULL,NULL),(428,NULL,'9b7e7970671444098929a5073af4ba21',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:35:58',NULL,'2026-01-31 08:35:58',NULL,NULL),(429,NULL,NULL,'eb8e3d6cd4094a62b23e39cec9023f18',NULL,NULL,NULL,NULL,'2026-01-31 08:37:09',NULL,'2026-01-31 08:37:09',NULL,NULL),(430,NULL,NULL,'c7a32afabea341a29ec8bb42db1fa616',NULL,NULL,NULL,NULL,'2026-01-31 08:37:10',NULL,'2026-01-31 08:37:10',NULL,NULL),(431,NULL,NULL,'fcb5022093894937a2ca4aa327dfe0a1',NULL,NULL,NULL,NULL,'2026-01-31 08:37:11',NULL,'2026-01-31 08:37:11',NULL,NULL),(432,NULL,NULL,'b41b496faa264901b9be3ff9eb8126bb',NULL,NULL,NULL,NULL,'2026-01-31 08:37:11',NULL,'2026-01-31 08:37:11',NULL,NULL),(433,NULL,'254a514e139747df89e9f6d9caf882f1',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:37:11',NULL,'2026-01-31 08:37:11',NULL,NULL),(434,NULL,'6ceb92e1518441d697b35052f46fd276',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:37:12',NULL,'2026-01-31 08:37:12',NULL,NULL),(435,NULL,'149ccba7b87e4284a3a6462e3a1dace1',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:37:13',NULL,'2026-01-31 08:37:13',NULL,NULL),(436,NULL,NULL,'cfc8a271e75e4a92b16ee6b5da9cfc9f',NULL,NULL,NULL,NULL,'2026-01-31 08:44:37',NULL,'2026-01-31 08:44:37',NULL,NULL),(437,NULL,NULL,'8c8d9ba41b8f46b993dfad4e5c90295f',NULL,NULL,NULL,NULL,'2026-01-31 08:44:44',NULL,'2026-01-31 08:44:44',NULL,NULL),(438,NULL,'4b38141686534a0fb9b947a7886cd4b6',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:44:53',NULL,'2026-01-31 08:44:53',NULL,NULL),(439,NULL,'ecd604d8d3ea4bb0ac224ad20d4355c9',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:45:02',NULL,'2026-01-31 08:45:02',NULL,NULL),(440,NULL,NULL,'4d0e9d918b4041fabd5ded633b4cf404',NULL,NULL,NULL,NULL,'2026-01-31 08:47:12',NULL,'2026-01-31 08:47:12',NULL,NULL),(441,NULL,NULL,'af307e30a6d7498fba4a004660bea0ee',NULL,NULL,NULL,NULL,'2026-01-31 08:47:13',NULL,'2026-01-31 08:47:13',NULL,NULL),(442,NULL,'9710f0cf77d84353ae13fa47922b085d',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:47:16',NULL,'2026-01-31 08:47:16',NULL,NULL),(443,NULL,'cd06f893291343c99e6ddf4e33b223da',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:47:22',NULL,'2026-01-31 08:47:22',NULL,NULL),(444,NULL,NULL,'429612bcc82f4c6a99fe57f4d9b01624',NULL,NULL,NULL,NULL,'2026-01-31 08:49:19',NULL,'2026-01-31 08:49:19',NULL,NULL),(445,NULL,NULL,'c83ffc787c524b148e75812d105dc9d6',NULL,NULL,NULL,NULL,'2026-01-31 08:49:21',NULL,'2026-01-31 08:49:21',NULL,NULL),(446,NULL,'e1a1c923b1d14e44b30717c742870aa1',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:49:26',NULL,'2026-01-31 08:49:26',NULL,NULL),(447,NULL,'bd6b982712bb47fb869262f40cbd35b6',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:49:33',NULL,'2026-01-31 08:49:33',NULL,NULL),(448,NULL,NULL,'c6968a1ee10e4e3b8651ffe0240a7e46',NULL,NULL,NULL,NULL,'2026-01-31 08:50:26',NULL,'2026-01-31 08:50:26',NULL,NULL),(449,NULL,NULL,'6bb0d6544be445f6a04b52b326336c8f',NULL,NULL,NULL,NULL,'2026-01-31 08:50:28',NULL,'2026-01-31 08:50:28',NULL,NULL),(450,NULL,NULL,'123ac033c5384fbd8a35e50521a83a46',NULL,NULL,NULL,NULL,'2026-01-31 08:50:30',NULL,'2026-01-31 08:50:30',NULL,NULL),(451,NULL,'0bd4754df8e146b59c21f37f688bda4b',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:50:37',NULL,'2026-01-31 08:50:37',NULL,NULL),(452,NULL,'ba35ae24dbf3443e8a526dce39c6793b',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:50:40',NULL,'2026-01-31 08:50:40',NULL,NULL),(453,NULL,'49eb9aae5e984a72b3c0b1e5316e2172',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:50:43',NULL,'2026-01-31 08:50:43',NULL,NULL),(454,NULL,NULL,'76212a9fc119475bb419a1bdb1e55e2e',NULL,NULL,NULL,NULL,'2026-01-31 08:52:45',NULL,'2026-01-31 08:52:45',NULL,NULL),(455,NULL,NULL,'3db5ce8e9fb4455f8157f7e9122d27c5',NULL,NULL,NULL,NULL,'2026-01-31 08:52:46',NULL,'2026-01-31 08:52:46',NULL,NULL),(456,NULL,'f97da783b69a4b49a0fcba49641c47dd',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:52:51',NULL,'2026-01-31 08:52:51',NULL,NULL),(457,NULL,'9141737aac2e46fca7bc57616fd70c44',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:52:54',NULL,'2026-01-31 08:52:54',NULL,NULL),(458,NULL,NULL,'5a37d71e432b45168339dde5abdbe7b6',NULL,NULL,NULL,NULL,'2026-01-31 08:54:29',NULL,'2026-01-31 08:54:29',NULL,NULL),(459,NULL,NULL,'a70797d01bfc404abcc3b02296c66189',NULL,NULL,NULL,NULL,'2026-01-31 08:54:30',NULL,'2026-01-31 08:54:30',NULL,NULL),(460,NULL,'69c420793c7e4707b6e11b9391dacc9f',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:54:31',NULL,'2026-01-31 08:54:31',NULL,NULL),(461,NULL,'996284baaa2946258a0ab1be9a30d1f6',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:54:32',NULL,'2026-01-31 08:54:32',NULL,NULL),(462,NULL,NULL,'a798fdf6d13d4af4b166dd94b5cea7cc',NULL,NULL,NULL,NULL,'2026-01-31 08:57:09',NULL,'2026-01-31 08:57:09',NULL,NULL),(463,NULL,NULL,'461ed75dd7e34a19a549d96d48aa7c46',NULL,NULL,NULL,NULL,'2026-01-31 08:57:09',NULL,'2026-01-31 08:57:09',NULL,NULL),(464,NULL,'3d82dcc8478f4304a633e8ba7e555f24',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:57:22',NULL,'2026-01-31 08:57:22',NULL,NULL),(465,NULL,'e6e96de7b2784be1adce763bc9c9adc5',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:57:27',NULL,'2026-01-31 08:57:27',NULL,NULL),(466,NULL,NULL,'fe599a5134944b9fbf952e83fdf41c55',NULL,NULL,NULL,NULL,'2026-01-31 08:59:55',NULL,'2026-01-31 08:59:55',NULL,NULL),(467,NULL,NULL,'630a207159f64ee78bb55f28471b619f',NULL,NULL,NULL,NULL,'2026-01-31 08:59:56',NULL,'2026-01-31 08:59:56',NULL,NULL),(468,NULL,'a7aab85e32634ad4be674bb1aa906949',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:59:56',NULL,'2026-01-31 08:59:56',NULL,NULL),(469,NULL,'e458566e0de24b2fb797037d94d9014c',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:59:57',NULL,'2026-01-31 08:59:57',NULL,NULL),(470,NULL,NULL,'4a56abd8fdd341ae88a99e102ab399de',NULL,NULL,NULL,NULL,'2026-01-31 09:05:32',NULL,'2026-01-31 09:05:32',NULL,NULL),(471,NULL,NULL,'2bcc91d4a1014418af6cb5cd19f40742',NULL,NULL,NULL,NULL,'2026-01-31 09:05:33',NULL,'2026-01-31 09:05:33',NULL,NULL),(472,NULL,'0d55ec1a5544450dba4e4fd1426395d7',NULL,NULL,NULL,NULL,NULL,'2026-01-31 09:05:34',NULL,'2026-01-31 09:05:34',NULL,NULL),(473,NULL,'aa997c9ea7d8480a9b97845f3e5faf44',NULL,NULL,NULL,NULL,NULL,'2026-01-31 09:05:39',NULL,'2026-01-31 09:05:39',NULL,NULL),(474,NULL,NULL,'4883c0d4a7f54a6898eba5bfdbb41266',NULL,NULL,NULL,NULL,'2026-01-31 09:10:26',NULL,'2026-01-31 09:10:26',NULL,NULL),(475,NULL,NULL,'f04956dfae6648e689c2321a04cb4adb',NULL,NULL,NULL,NULL,'2026-01-31 09:10:27',NULL,'2026-01-31 09:10:27',NULL,NULL),(476,NULL,'c2164b9381024c48bbabb24762dea92f',NULL,NULL,NULL,NULL,NULL,'2026-01-31 09:10:32',NULL,'2026-01-31 09:10:32',NULL,NULL),(477,NULL,'496e06c7521f45c994e6426c4313acea',NULL,NULL,NULL,NULL,NULL,'2026-01-31 09:10:34',NULL,'2026-01-31 09:10:34',NULL,NULL),(478,NULL,NULL,'ecd39871d7fd438f88b36601f25d6eb6',NULL,NULL,NULL,NULL,'2026-01-31 09:19:32',NULL,'2026-01-31 09:19:32',NULL,NULL),(479,NULL,NULL,'195da9cf2e82450bb026c094e894239c',NULL,NULL,NULL,NULL,'2026-01-31 09:19:32',NULL,'2026-01-31 09:19:32',NULL,NULL),(480,NULL,'12aaefd215d7455d89ae19ca3d1c8afd',NULL,NULL,NULL,NULL,NULL,'2026-01-31 09:19:33',NULL,'2026-01-31 09:19:33',NULL,NULL),(481,NULL,'98d10c0290e340a08e9d1726bf0066bf',NULL,NULL,NULL,NULL,NULL,'2026-01-31 09:19:34',NULL,'2026-01-31 09:19:34',NULL,NULL);
/*!40000 ALTER TABLE `revocation_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL DEFAULT '<<null>>',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_role_name_domain_id` (`name`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` (`id`, `name`, `extra`, `domain_id`, `description`) VALUES ('4a81eb6ae9b241379ea5dfe7b66fd877','service','{}','<<null>>',NULL),('521ab0ae247f494b8c46c362a3a3dbc2','ResellerAdmin','{}','<<null>>',NULL),('59f3f5a8126b435583b2f020ac319d86','member','{}','<<null>>',NULL),('7f9f399b2a944bb38afe6fafcd143b1a','admin','{}','<<null>>',NULL),('ca2733069aa142f3bec82e9ef36453f2','swiftoperator','{}','<<null>>',NULL),('f01974279bc64a399c07cbdda528d828','reader','{}','<<null>>',NULL);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_option`
--

DROP TABLE IF EXISTS `role_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_option` (
  `role_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`role_id`,`option_id`),
  CONSTRAINT `role_option_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_option`
--

LOCK TABLES `role_option` WRITE;
/*!40000 ALTER TABLE `role_option` DISABLE KEYS */;
INSERT INTO `role_option` (`role_id`, `option_id`, `option_value`) VALUES ('59f3f5a8126b435583b2f020ac319d86','IMMU','true'),('7f9f399b2a944bb38afe6fafcd143b1a','IMMU','true'),('f01974279bc64a399c07cbdda528d828','IMMU','true');
/*!40000 ALTER TABLE `role_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sensitive_config`
--

DROP TABLE IF EXISTS `sensitive_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sensitive_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sensitive_config`
--

LOCK TABLES `sensitive_config` WRITE;
/*!40000 ALTER TABLE `sensitive_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sensitive_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `type`, `enabled`, `extra`) VALUES ('330f7c5b72d34ee8a0037d44f709f854','placement',1,'{\"description\": \"Placement Service\", \"name\": \"placement\"}'),('49602f11b2c44ab4a541e9bb9c21b0b8','volumev3',1,'{\"description\": \"Cinder V3 Service\", \"name\": \"cinderv3\"}'),('506827dc2ec64cee97dab2f39c6e16f1','compute',1,'{\"description\": \"Nova Compute Service\", \"name\": \"nova\"}'),('9dc869cf4b1d407ebae3104260dcda5b','identity',1,'{\"name\": \"keystone\"}'),('a67a3bbb97ff45a48f45dc998bbfdd60','image',1,'{\"description\": \"Glance Service\", \"name\": \"glance\"}'),('b1a5a1ce93d34afeb162bb3723bf80ce','key-manager',1,'{\"description\": \"Barbican Service\", \"name\": \"barbican\"}'),('b56b72be8ba04d58ac44a61574de668c','Ceilometer',1,'{\"description\": \"Ceilometer Service\", \"name\": \"ceilometer\"}'),('ef65955ca2174b85a7cef21d36d55ecf','object-store',1,'{\"name\": \"swift\", \"description\": \"OpenStack Object Storage\"}'),('f679c407fb3c4d6fa80e09faa2d77b7d','network',1,'{\"description\": \"Openstack Networking\", \"name\": \"neutron\"}');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_provider`
--

DROP TABLE IF EXISTS `service_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_provider` (
  `auth_url` varchar(256) NOT NULL,
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `sp_url` varchar(256) NOT NULL,
  `relay_state_prefix` varchar(256) NOT NULL DEFAULT 'ss:mem:',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_provider`
--

LOCK TABLES `service_provider` WRITE;
/*!40000 ALTER TABLE `service_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `service_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_assignment`
--

DROP TABLE IF EXISTS `system_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_assignment` (
  `type` varchar(64) NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_assignment`
--

LOCK TABLES `system_assignment` WRITE;
/*!40000 ALTER TABLE `system_assignment` DISABLE KEYS */;
INSERT INTO `system_assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserSystem','7236ad21d7ab4000b7ab6db9df93bca9','system','7f9f399b2a944bb38afe6fafcd143b1a',0);
/*!40000 ALTER TABLE `system_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `token`
--

DROP TABLE IF EXISTS `token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `token` (
  `id` varchar(64) NOT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_token_expires_valid` (`expires`,`valid`),
  KEY `ix_token_expires` (`expires`),
  KEY `ix_token_trust_id` (`trust_id`),
  KEY `ix_token_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `token`
--

LOCK TABLES `token` WRITE;
/*!40000 ALTER TABLE `token` DISABLE KEYS */;
/*!40000 ALTER TABLE `token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust`
--

DROP TABLE IF EXISTS `trust`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust` (
  `id` varchar(64) NOT NULL,
  `trustor_user_id` varchar(64) NOT NULL,
  `trustee_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `impersonation` tinyint(1) NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `remaining_uses` int(11) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `redelegated_trust_id` varchar(64) DEFAULT NULL,
  `redelegation_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `duplicate_trust_constraint_expanded` (`trustor_user_id`,`trustee_user_id`,`project_id`,`impersonation`,`expires_at`,`expires_at_int`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust`
--

LOCK TABLES `trust` WRITE;
/*!40000 ALTER TABLE `trust` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust_role`
--

DROP TABLE IF EXISTS `trust_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust_role` (
  `trust_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`trust_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust_role`
--

LOCK TABLES `trust_role` WRITE;
/*!40000 ALTER TABLE `trust_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `default_project_id` varchar(64) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_active_at` date DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_user_id_domain_id` (`id`,`domain_id`),
  KEY `ix_default_project_id` (`default_project_id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `extra`, `enabled`, `default_project_id`, `created_at`, `last_active_at`, `domain_id`) VALUES ('081828351901493690484ec6ac138e05','{\"tenantId\": \"624dad82ad26433498495a3960830cf8\", \"email\": \"demo_tempestconf@test.com\"}',1,NULL,'2026-01-31 07:29:18',NULL,'default'),('0c1329ae1eaf4c70bef5e8b9509033ac','{}',1,'8aa8accd246f4c91857447e1cc9391b2','2026-01-31 06:51:03','2026-01-31','default'),('23611f48d74f4bb59a8d380f541b978c','{}',1,'8aa8accd246f4c91857447e1cc9391b2','2026-01-31 06:51:29','2026-01-31','default'),('4520278528294040b3584e8da3cdf83e','{}',1,'8aa8accd246f4c91857447e1cc9391b2','2026-01-31 06:52:12','2026-01-31','default'),('4b43316665864b4e8e638e38986e06e4','{\"tenantId\": \"a60ce9f4e8ce44949e0e7997297c4ab2\", \"email\": \"alt_demo_tempestconf@test.com\"}',1,NULL,'2026-01-31 07:29:19',NULL,'default'),('56002d9dca034ce2b7f7186567cfa432','{}',1,'8aa8accd246f4c91857447e1cc9391b2','2026-01-31 06:52:17','2026-01-31','default'),('59630ee0089643e78d944136d6bced30','{}',1,'8aa8accd246f4c91857447e1cc9391b2','2026-01-31 06:52:36','2026-01-31','default'),('7236ad21d7ab4000b7ab6db9df93bca9','{}',1,NULL,'2026-01-31 06:49:22','2026-01-31','default'),('785b59e67da64455b59713abf44ce739','{}',1,'8aa8accd246f4c91857447e1cc9391b2','2026-01-31 06:51:13','2026-01-31','default'),('a4e8b8c71ff54fc6ab4c60984f2adc58','{}',1,'8aa8accd246f4c91857447e1cc9391b2','2026-01-31 06:51:20','2026-01-31','default'),('b99780d961474219b403eaf2b1627219','{}',1,'8aa8accd246f4c91857447e1cc9391b2','2026-01-31 07:08:37',NULL,'default');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_group_membership`
--

DROP TABLE IF EXISTS `user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `fk_user_group_membership_group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `fk_user_group_membership_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_group_membership`
--

LOCK TABLES `user_group_membership` WRITE;
/*!40000 ALTER TABLE `user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_option`
--

DROP TABLE IF EXISTS `user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_option` (
  `user_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`user_id`,`option_id`),
  CONSTRAINT `user_option_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_option`
--

LOCK TABLES `user_option` WRITE;
/*!40000 ALTER TABLE `user_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whitelisted_config`
--

DROP TABLE IF EXISTS `whitelisted_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whitelisted_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whitelisted_config`
--

LOCK TABLES `whitelisted_config` WRITE;
/*!40000 ALTER TABLE `whitelisted_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `whitelisted_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `mysql`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `mysql` /*!40100 DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci */;

USE `mysql`;

--
-- Table structure for table `general_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `general_log` (
  `event_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `command_type` varchar(64) NOT NULL,
  `argument` mediumtext NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='General log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slow_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `slow_log` (
  `start_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `query_time` time(6) NOT NULL,
  `lock_time` time(6) NOT NULL,
  `rows_sent` bigint(20) unsigned NOT NULL,
  `rows_examined` bigint(20) unsigned NOT NULL,
  `db` varchar(512) NOT NULL,
  `last_insert_id` int(11) NOT NULL,
  `insert_id` int(11) NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `sql_text` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `rows_affected` bigint(20) unsigned NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Slow log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `column_stats`
--

DROP TABLE IF EXISTS `column_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `column_stats` (
  `db_name` varchar(64) NOT NULL,
  `table_name` varchar(64) NOT NULL,
  `column_name` varchar(64) NOT NULL,
  `min_value` varbinary(255) DEFAULT NULL,
  `max_value` varbinary(255) DEFAULT NULL,
  `nulls_ratio` decimal(12,4) DEFAULT NULL,
  `avg_length` decimal(12,4) DEFAULT NULL,
  `avg_frequency` decimal(12,4) DEFAULT NULL,
  `hist_size` tinyint(3) unsigned DEFAULT NULL,
  `hist_type` enum('SINGLE_PREC_HB','DOUBLE_PREC_HB') DEFAULT NULL,
  `histogram` varbinary(255) DEFAULT NULL,
  PRIMARY KEY (`db_name`,`table_name`,`column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='Statistics on Columns';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `column_stats`
--

LOCK TABLES `column_stats` WRITE;
/*!40000 ALTER TABLE `column_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `column_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `columns_priv`
--

DROP TABLE IF EXISTS `columns_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `columns_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Table_name` char(64) NOT NULL DEFAULT '',
  `Column_name` char(64) NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `Column_priv` set('Select','Insert','Update','References') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`Host`,`Db`,`User`,`Table_name`,`Column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Column privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `columns_priv`
--

LOCK TABLES `columns_priv` WRITE;
/*!40000 ALTER TABLE `columns_priv` DISABLE KEYS */;
/*!40000 ALTER TABLE `columns_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db`
--

DROP TABLE IF EXISTS `db`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `db` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Event_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_history_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Host`,`Db`,`User`),
  KEY `User` (`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Database privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `db`
--

LOCK TABLES `db` WRITE;
/*!40000 ALTER TABLE `db` DISABLE KEYS */;
INSERT INTO `db` (`Host`, `Db`, `User`, `Select_priv`, `Insert_priv`, `Update_priv`, `Delete_priv`, `Create_priv`, `Drop_priv`, `Grant_priv`, `References_priv`, `Index_priv`, `Alter_priv`, `Create_tmp_table_priv`, `Lock_tables_priv`, `Create_view_priv`, `Show_view_priv`, `Create_routine_priv`, `Alter_routine_priv`, `Execute_priv`, `Event_priv`, `Trigger_priv`, `Delete_history_priv`) VALUES ('localhost','keystone','keystone_9cf5','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','placement','placement_b9d2','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','keystone','keystone_9cf5','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','placement','placement_b9d2','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','glance','glance_451c','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','glance','glance_451c','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','neutron','neutron_ca6c','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','cinder','cinder_5d73','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','barbican','barbican_70d6','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','neutron','neutron_ca6c','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','cinder','cinder_5d73','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','barbican','barbican_70d6','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_api','nova_api_909c','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_cell0','nova_cell0_39df','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_api','nova_api_909c','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_cell0','nova_cell0_39df','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');
/*!40000 ALTER TABLE `db` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `db` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `name` char(64) NOT NULL DEFAULT '',
  `body` longblob NOT NULL,
  `definer` char(141) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `execute_at` datetime DEFAULT NULL,
  `interval_value` int(11) DEFAULT NULL,
  `interval_field` enum('YEAR','QUARTER','MONTH','DAY','HOUR','MINUTE','WEEK','SECOND','MICROSECOND','YEAR_MONTH','DAY_HOUR','DAY_MINUTE','DAY_SECOND','HOUR_MINUTE','HOUR_SECOND','MINUTE_SECOND','DAY_MICROSECOND','HOUR_MICROSECOND','MINUTE_MICROSECOND','SECOND_MICROSECOND') DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_executed` datetime DEFAULT NULL,
  `starts` datetime DEFAULT NULL,
  `ends` datetime DEFAULT NULL,
  `status` enum('ENABLED','DISABLED','SLAVESIDE_DISABLED') NOT NULL DEFAULT 'ENABLED',
  `on_completion` enum('DROP','PRESERVE') NOT NULL DEFAULT 'DROP',
  `sql_mode` set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','IGNORE_BAD_TABLE_OPTIONS','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH','EMPTY_STRING_IS_NULL','SIMULTANEOUS_ASSIGNMENT','TIME_ROUND_FRACTIONAL') NOT NULL DEFAULT '',
  `comment` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `originator` int(10) unsigned NOT NULL,
  `time_zone` char(64) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT 'SYSTEM',
  `character_set_client` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `collation_connection` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `db_collation` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `body_utf8` longblob DEFAULT NULL,
  PRIMARY KEY (`db`,`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Events';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `func`
--

DROP TABLE IF EXISTS `func`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `func` (
  `name` char(64) NOT NULL DEFAULT '',
  `ret` tinyint(1) NOT NULL DEFAULT 0,
  `dl` char(128) NOT NULL DEFAULT '',
  `type` enum('function','aggregate') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='User defined functions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `func`
--

LOCK TABLES `func` WRITE;
/*!40000 ALTER TABLE `func` DISABLE KEYS */;
/*!40000 ALTER TABLE `func` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `global_priv`
--

DROP TABLE IF EXISTS `global_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Priv` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '{}' CHECK (json_valid(`Priv`)),
  PRIMARY KEY (`Host`,`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Users and global privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `global_priv`
--

LOCK TABLES `global_priv` WRITE;
/*!40000 ALTER TABLE `global_priv` DISABLE KEYS */;
INSERT INTO `global_priv` (`Host`, `User`, `Priv`) VALUES ('localhost','mariadb.sys','{\"access\":0,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"\",\"account_locked\":true,\"password_last_changed\":0}'),('localhost','root','{\"access\": 549755813887, \"plugin\": \"mysql_native_password\", \"authentication_string\": \"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\", \"auth_or\": [{}],\"version_id\":100529,\"password_last_changed\":1769842044}'),('%','root','{\"access\":549755813887,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\",\"password_last_changed\":1769842047}'),('localhost','keystone_9cf5','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*DAAD80E2F5B7B648C61090C5631A2FE9CC7603D9\",\"password_last_changed\":1769842032}'),('localhost','placement_b9d2','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*F3D3D8FFE3B8320330549D8B66E6FCC83E8FA1E6\",\"password_last_changed\":1769842032}'),('%','keystone_9cf5','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*DAAD80E2F5B7B648C61090C5631A2FE9CC7603D9\",\"password_last_changed\":1769842032}'),('%','placement_b9d2','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*F3D3D8FFE3B8320330549D8B66E6FCC83E8FA1E6\",\"password_last_changed\":1769842032}'),('localhost','glance_451c','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*27874EB821346E79E0C68815AB4B3355957BB5D2\",\"password_last_changed\":1769842038}'),('%','glance_451c','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*27874EB821346E79E0C68815AB4B3355957BB5D2\",\"password_last_changed\":1769842039}'),('localhost','neutron_ca6c','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*7E7FC776164ADDDB06283CD6065108B280CD5B2F\",\"password_last_changed\":1769842043}'),('localhost','cinder_5d73','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*17CBB7D451850580E8A314DDEC7FF1807DBCF0F1\",\"password_last_changed\":1769842043}'),('localhost','barbican_70d6','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*A498C0CE6143C4C3F9BFF7BF499BB5FE279189E7\",\"password_last_changed\":1769842043}'),('%','neutron_ca6c','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*7E7FC776164ADDDB06283CD6065108B280CD5B2F\",\"password_last_changed\":1769842045}'),('%','cinder_5d73','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*17CBB7D451850580E8A314DDEC7FF1807DBCF0F1\",\"password_last_changed\":1769842047}'),('%','barbican_70d6','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*A498C0CE6143C4C3F9BFF7BF499BB5FE279189E7\",\"password_last_changed\":1769842047}'),('localhost','nova_api_909c','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*EC7079C78722BBCD0E5E97835D2086E249BBF082\",\"password_last_changed\":1769842279}'),('localhost','nova_cell0_39df','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*C14D370D0AFCF364060E0C2F961D75B806536026\",\"password_last_changed\":1769842280}'),('%','nova_api_909c','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*EC7079C78722BBCD0E5E97835D2086E249BBF082\",\"password_last_changed\":1769842280}'),('%','nova_cell0_39df','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*C14D370D0AFCF364060E0C2F961D75B806536026\",\"password_last_changed\":1769842280}');
/*!40000 ALTER TABLE `global_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gtid_slave_pos`
--

DROP TABLE IF EXISTS `gtid_slave_pos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gtid_slave_pos` (
  `domain_id` int(10) unsigned NOT NULL,
  `sub_id` bigint(20) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `seq_no` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`domain_id`,`sub_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci COMMENT='Replication slave GTID position';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gtid_slave_pos`
--

LOCK TABLES `gtid_slave_pos` WRITE;
/*!40000 ALTER TABLE `gtid_slave_pos` DISABLE KEYS */;
/*!40000 ALTER TABLE `gtid_slave_pos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_category`
--

DROP TABLE IF EXISTS `help_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_category` (
  `help_category_id` smallint(5) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `parent_category_id` smallint(5) unsigned DEFAULT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_category_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_category`
--

LOCK TABLES `help_category` WRITE;
/*!40000 ALTER TABLE `help_category` DISABLE KEYS */;
INSERT INTO `help_category` (`help_category_id`, `name`, `parent_category_id`, `url`) VALUES (1,'Contents',0,''),(2,'Polygon Properties',34,''),(3,'WKT',34,''),(4,'Numeric Functions',37,''),(5,'Plugins',1,''),(6,'MBR',34,''),(7,'Control Flow Functions',37,''),(8,'Transactions',1,''),(9,'Help Metadata',1,''),(10,'Account Management',1,''),(11,'Point Properties',34,''),(12,'Encryption Functions',37,''),(13,'LineString Properties',34,''),(14,'Miscellaneous Functions',37,''),(15,'Logical Operators',47,''),(16,'Functions and Modifiers for Use with GROUP BY',1,''),(17,'Information Functions',37,''),(18,'Assignment Operators',47,''),(19,'Comparison Operators',47,''),(20,'Bit Functions',37,''),(21,'Table Maintenance',1,''),(22,'User-Defined Functions',1,''),(23,'Data Types',1,''),(24,'Compound Statements',1,''),(25,'Geometry Constructors',34,''),(26,'Administration',1,''),(27,'Data Manipulation',1,''),(28,'Utility',1,''),(29,'Language Structure',1,''),(30,'Geometry Relations',34,''),(31,'Date and Time Functions',37,''),(32,'WKB',34,''),(33,'Procedures',1,''),(34,'Geographic Features',1,''),(35,'Geometry Properties',34,''),(36,'String Functions',37,''),(37,'Functions',1,''),(38,'Data Definition',1,''),(39,'Sequences',1,''),(40,'JSON Functions',37,''),(41,'Window Functions',37,''),(42,'Spider Functions',37,''),(43,'Dynamic Column Functions',37,''),(44,'Galera Functions',37,''),(45,'Temporal Tables',1,''),(46,'GeoJSON',34,''),(47,'Operators',1,''),(48,'Arithmetic Operators',47,''),(49,'Replication',1,''),(50,'Prepared Statements',1,'');
/*!40000 ALTER TABLE `help_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_keyword`
--

DROP TABLE IF EXISTS `help_keyword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_keyword` (
  `help_keyword_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  PRIMARY KEY (`help_keyword_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help keywords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_keyword`
--

LOCK TABLES `help_keyword` WRITE;
/*!40000 ALTER TABLE `help_keyword` DISABLE KEYS */;
INSERT INTO `help_keyword` (`help_keyword_id`, `name`) VALUES (1,'work'),(2,'locks'),(3,'locking'),(4,'drop'),(5,'super'),(6,'usage'),(7,'binlog admin'),(8,'binlog monitor'),(9,'binlog replay'),(10,'connection admin'),(11,'federated admin'),(12,'grant option'),(13,'read_only admin'),(14,'replica monitor'),(15,'replication replica'),(16,'roles'),(17,'values'),(18,'value'),(19,'not'),(20,'and'),(21,'or'),(22,':='),(23,'assignment operator'),(24,'='),(25,'!='),(26,'<>'),(27,'not equal'),(28,'less than'),(29,'less than or equal'),(30,'NULL-safe equal'),(31,'equal'),(32,'greater than'),(33,'greater than or equal'),(34,'bitwise and'),(35,'shift left'),(36,'shift right'),(37,'bitwise xor'),(38,'bitwise or'),(39,'bitwise not'),(40,'returns'),(41,'udfs'),(42,'udf calling sequences'),(43,'udf security'),(44,'int1'),(45,'int2'),(46,'int3'),(47,'integer'),(48,'int4'),(49,'int8'),(50,'dec'),(51,'numeric'),(52,'fixed'),(53,'number'),(54,'real'),(55,'double precision'),(56,'nchar'),(57,'long'),(58,'long varchar'),(59,'repeat'),(60,'declare'),(61,'cursor'),(62,'show'),(63,'columns'),(64,'kill connection'),(65,'kill query'),(66,'delete returning'),(67,'sql_big_result'),(68,'minus'),(69,'cte'),(70,'insert returning'),(71,'queries'),(72,'query'),(73,'explain format'),(74,'explain format json'),(75,'rlike'),(76,'character_length'),(77,'escape'),(78,'mode'),(79,'trim_oracle'),(80,'schedule'),(81,'row_format'),(82,'starts'),(83,'host'),(84,'generated columns'),(85,'virtual columns'),(86,'computed columns'),(87,'hidden columns'),(88,'nextval'),(89,'lastval'),(90,'+'),(91,'addition operator'),(92,'/'),(93,'division operator'),(94,'%'),(95,'modulo operator'),(96,'*'),(97,'multiplication operator'),(98,'-'),(99,'subtraction operator'),(100,'master_ssl_verify_cert'),(101,'start replica'),(102,'stop replica'),(103,'reset slave'),(104,'reset replica'),(105,'drop prepare'),(106,'deallocate prepare');
/*!40000 ALTER TABLE `help_keyword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_relation`
--

DROP TABLE IF EXISTS `help_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_relation` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `help_keyword_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`help_keyword_id`,`help_topic_id`),
  KEY `help_topic_id` (`help_topic_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='keyword-topic relation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_relation`
--

LOCK TABLES `help_relation` WRITE;
/*!40000 ALTER TABLE `help_relation` DISABLE KEYS */;
INSERT INTO `help_relation` (`help_topic_id`, `help_keyword_id`) VALUES (94,1),(97,2),(99,2),(101,2),(116,2),(147,2),(152,2),(157,2),(161,2),(162,2),(338,2),(438,2),(97,3),(99,3),(101,3),(116,3),(147,3),(152,3),(157,3),(161,3),(162,3),(338,3),(438,3),(106,4),(112,4),(250,4),(687,4),(697,4),(713,4),(714,4),(715,4),(716,4),(717,4),(718,4),(719,4),(720,4),(722,4),(723,4),(731,4),(107,5),(107,6),(107,7),(107,8),(107,9),(107,10),(107,11),(107,12),(107,13),(107,14),(107,15),(115,16),(166,17),(166,18),(167,19),(168,20),(170,21),(210,22),(210,23),(211,23),(211,24),(212,25),(212,26),(212,27),(213,28),(214,29),(215,30),(216,31),(217,32),(218,33),(232,34),(233,35),(234,36),(236,37),(237,38),(238,39),(249,40),(251,41),(252,42),(253,43),(255,44),(257,45),(258,46),(259,47),(259,48),(260,49),(261,50),(261,51),(261,52),(261,53),(263,54),(263,55),(269,56),(275,57),(275,58),(304,59),(664,59),(311,60),(311,61),(331,62),(332,62),(333,62),(334,62),(335,62),(342,62),(343,62),(344,62),(345,62),(346,62),(347,62),(354,62),(356,62),(357,62),(358,62),(359,62),(360,62),(361,62),(362,62),(363,62),(364,62),(365,62),(366,62),(367,62),(368,62),(369,62),(370,62),(371,62),(372,62),(373,62),(374,62),(375,62),(376,62),(377,62),(378,62),(379,62),(380,62),(381,62),(382,62),(383,62),(384,62),(385,62),(386,62),(387,62),(388,62),(389,62),(390,62),(391,62),(392,62),(393,62),(394,62),(395,62),(396,62),(397,62),(398,62),(408,62),(409,62),(333,63),(403,64),(403,65),(410,66),(414,67),(425,68),(431,69),(432,69),(433,69),(453,70),(460,71),(460,72),(466,73),(466,74),(622,75),(632,76),(651,77),(657,78),(678,79),(689,80),(696,81),(701,82),(707,83),(711,84),(711,85),(711,86),(712,87),(732,88),(733,89),(804,90),(804,91),(805,92),(805,93),(806,94),(806,95),(807,96),(807,97),(808,98),(808,99),(809,100),(810,101),(811,102),(812,103),(812,104),(816,105),(816,106);
/*!40000 ALTER TABLE `help_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_topic`
--

DROP TABLE IF EXISTS `help_topic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_topic` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `help_category_id` smallint(5) unsigned NOT NULL,
  `description` text NOT NULL,
  `example` text NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_topic_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help topics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_topic`
--

LOCK TABLES `help_topic` WRITE;
/*!40000 ALTER TABLE `help_topic` DISABLE KEYS */;
INSERT INTO `help_topic` (`help_topic_id`, `name`, `help_category_id`, `description`, `example`, `url`) VALUES (1,'HELP_DATE',9,'Help Contents generated from the MariaDB Knowledge Base on 23 January 2023.','',''),(2,'HELP_VERSION',9,'Help Contents generated for MariaDB 10.5 from the MariaDB Knowledge Base on 23 January 2023.','',''),(3,'AREA',2,'A synonym for ST_AREA.\n\nURL: https://mariadb.com/kb/en/polygon-properties-area/','','https://mariadb.com/kb/en/polygon-properties-area/'),(4,'CENTROID',2,'A synonym for ST_CENTROID.\n\nURL: https://mariadb.com/kb/en/centroid/','','https://mariadb.com/kb/en/centroid/'),(5,'ExteriorRing',2,'A synonym for ST_ExteriorRing.\n\nURL: https://mariadb.com/kb/en/polygon-properties-exteriorring/','','https://mariadb.com/kb/en/polygon-properties-exteriorring/'),(6,'InteriorRingN',2,'A synonym for ST_InteriorRingN.\n\nURL: https://mariadb.com/kb/en/polygon-properties-interiorringn/','','https://mariadb.com/kb/en/polygon-properties-interiorringn/'),(7,'NumInteriorRings',2,'A synonym for ST_NumInteriorRings.\n\nURL: https://mariadb.com/kb/en/polygon-properties-numinteriorrings/','','https://mariadb.com/kb/en/polygon-properties-numinteriorrings/'),(8,'ST_AREA',2,'Syntax\n------\n\nST_Area(poly)\nArea(poly)\n\nDescription\n-----------\n\nReturns as a double-precision number the area of the Polygon value poly, as\nmeasured in its spatial reference system.\n\nST_Area() and Area() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\n\nSELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+\n\nURL: https://mariadb.com/kb/en/st_area/','','https://mariadb.com/kb/en/st_area/'),(9,'ST_CENTROID',2,'Syntax\n------\n\nST_Centroid(mpoly)\nCentroid(mpoly)\n\nDescription\n-----------\n\nReturns a point reflecting the mathematical centroid (geometric center) for\nthe MultiPolygon mpoly. The resulting point will not necessarily be on the\nMultiPolygon.\n\nST_Centroid() and Centroid() are synonyms.\n\nExamples\n--------\n\nSET @poly = ST_GeomFromText(\'POLYGON((0 0,20 0,20 20,0 20,0 0))\');\nSELECT ST_AsText(ST_Centroid(@poly)) AS center;\n+--------------+\n| center       |\n+--------------+\n| POINT(10 10) |\n+--------------+\n\nURL: https://mariadb.com/kb/en/st_centroid/','','https://mariadb.com/kb/en/st_centroid/'),(10,'ST_ExteriorRing',2,'Syntax\n------\n\nST_ExteriorRing(poly)\nExteriorRing(poly)\n\nDescription\n-----------\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nST_ExteriorRing() and ExteriorRing() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_exteriorring/','','https://mariadb.com/kb/en/st_exteriorring/'),(11,'ST_InteriorRingN',2,'Syntax\n------\n\nST_InteriorRingN(poly,N)\nInteriorRingN(poly,N)\n\nDescription\n-----------\n\nReturns the N-th interior ring for the Polygon value poly as a LineString.\nRings are numbered beginning with 1.\n\nST_InteriorRingN() and InteriorRingN() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_interiorringn/','','https://mariadb.com/kb/en/st_interiorringn/'),(12,'ST_NumInteriorRings',2,'Syntax\n------\n\nST_NumInteriorRings(poly)\nNumInteriorRings(poly)\n\nDescription\n-----------\n\nReturns an integer containing the number of interior rings in the Polygon\nvalue poly.\n\nNote that according the the OpenGIS standard, a POLYGON should have exactly\none ExteriorRing and all other rings should lie within that ExteriorRing and\nthus be the InteriorRings. Practically, however, some systems, including\nMariaDB\'s, permit polygons to have several \'ExteriorRings\'. In the case of\nthere being multiple, non-overlapping exterior rings ST_NumInteriorRings()\nwill return 1.\n\nST_NumInteriorRings() and NumInteriorRings() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\n\nNon-overlapping \'polygon\':\n\nSELECT ST_NumInteriorRings(ST_PolyFromText(\'POLYGON((0 0,10 0,10 10,0 10,0 0),\n (-1 -1,-5 -1,-5 -5,-1 -5,-1 -1))\')) AS NumInteriorRings;\n+------------------+\n| NumInteriorRings |\n+------------------+\n|                1 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/st_numinteriorrings/','','https://mariadb.com/kb/en/st_numinteriorrings/'),(14,'AsText',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-astext/','','https://mariadb.com/kb/en/wkt-astext/'),(15,'AsWKT',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-aswkt/','','https://mariadb.com/kb/en/wkt-aswkt/'),(16,'GeomCollFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomcollfromtext/','','https://mariadb.com/kb/en/wkt-geomcollfromtext/'),(17,'GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/geometrycollectionfromtext/','','https://mariadb.com/kb/en/geometrycollectionfromtext/'),(18,'GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/geometryfromtext/','','https://mariadb.com/kb/en/geometryfromtext/'),(19,'GeomFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomfromtext/','','https://mariadb.com/kb/en/wkt-geomfromtext/'),(20,'LineFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/wkt-linefromtext/','','https://mariadb.com/kb/en/wkt-linefromtext/'),(21,'LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/linestringfromtext/','','https://mariadb.com/kb/en/linestringfromtext/'),(22,'MLineFromText',3,'Syntax\n------\n\nMLineFromText(wkt[,srid])\nMultiLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTILINESTRING value using its WKT representation and SRID.\n\nMLineFromText() and MultiLineStringFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nSHOW FIELDS FROM gis_multi_line;\nINSERT INTO gis_multi_line VALUES\n  (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16\n23,16 48))\')),\n  (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n  (MLineFromWKB(AsWKB(MultiLineString(\n   LineString(Point(1, 2), Point(3, 5)),\n   LineString(Point(2, 5), Point(5, 8), Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/mlinefromtext/','','https://mariadb.com/kb/en/mlinefromtext/'),(23,'MPointFromText',3,'Syntax\n------\n\nMPointFromText(wkt[,srid])\nMultiPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n\nMPointFromText() and MultiPointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nSHOW FIELDS FROM gis_multi_point;\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/mpointfromtext/','','https://mariadb.com/kb/en/mpointfromtext/'),(13,'WKT Definition',3,'Description\n-----------\n\nThe Well-Known Text (WKT) representation of Geometry is designed to exchange\ngeometry data in ASCII form. Examples of the basic geometry types include:\n\n+-----------------------------------------------------------------------------+\n| Geometry Types                                                              |\n+-----------------------------------------------------------------------------+\n| POINT                                                                       |\n+-----------------------------------------------------------------------------+\n| LINESTRING                                                                  |\n+-----------------------------------------------------------------------------+\n| POLYGON                                                                     |\n+-----------------------------------------------------------------------------+\n| MULTIPOINT                                                                  |\n+-----------------------------------------------------------------------------+\n| MULTILINESTRING                                                             |\n+-----------------------------------------------------------------------------+\n| MULTIPOLYGON                                                                |\n+-----------------------------------------------------------------------------+\n| GEOMETRYCOLLECTION                                                          |\n+-----------------------------------------------------------------------------+\n| GEOMETRY                                                                    |\n+-----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/wkt-definition/','','https://mariadb.com/kb/en/wkt-definition/'),(24,'MPolyFromText',3,'Syntax\n------\n\nMPolyFromText(wkt[,srid])\nMultiPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n\nMPolyFromText() and MultiPolygonFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_polygon  (g MULTIPOLYGON);\nSHOW FIELDS FROM gis_multi_polygon;\nINSERT INTO gis_multi_polygon VALUES\n  (MultiPolygonFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromWKB(AsWKB(MultiPolygon(Polygon(\n   LineString(Point(0, 3), Point(3, 3), Point(3, 0), Point(0, 3)))))));\n\nURL: https://mariadb.com/kb/en/mpolyfromtext/','','https://mariadb.com/kb/en/mpolyfromtext/'),(25,'MultiLineStringFromText',3,'A synonym for MLineFromText.\n\nURL: https://mariadb.com/kb/en/multilinestringfromtext/','','https://mariadb.com/kb/en/multilinestringfromtext/'),(26,'MultiPointFromText',3,'A synonym for MPointFromText.\n\nURL: https://mariadb.com/kb/en/multipointfromtext/','','https://mariadb.com/kb/en/multipointfromtext/'),(27,'MultiPolygonFromText',3,'A synonym for MPolyFromText.\n\nURL: https://mariadb.com/kb/en/multipolygonfromtext/','','https://mariadb.com/kb/en/multipolygonfromtext/'),(28,'PointFromText',3,'A synonym for ST_PointFromText.\n\nURL: https://mariadb.com/kb/en/wkt-pointfromtext/','','https://mariadb.com/kb/en/wkt-pointfromtext/'),(29,'PolyFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/wkt-polyfromtext/','','https://mariadb.com/kb/en/wkt-polyfromtext/'),(30,'PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/polygonfromtext/','','https://mariadb.com/kb/en/polygonfromtext/'),(31,'ST_AsText',3,'Syntax\n------\n\nST_AsText(g)\nAsText(g)\nST_AsWKT(g)\nAsWKT(g)\n\nDescription\n-----------\n\nConverts a value in internal geometry format to its WKT representation and\nreturns the string result.\n\nST_AsText(), AsText(), ST_AsWKT() and AsWKT() are all synonyms.\n\nExamples\n--------\n\nSET @g = \'LineString(1 1,4 4,6 6)\';\n\nSELECT ST_AsText(ST_GeomFromText(@g));\n+--------------------------------+\n| ST_AsText(ST_GeomFromText(@g)) |\n+--------------------------------+\n| LINESTRING(1 1,4 4,6 6)        |\n+--------------------------------+\n\nURL: https://mariadb.com/kb/en/st_astext/','','https://mariadb.com/kb/en/st_astext/'),(32,'ST_ASWKT',3,'A synonym for ST_ASTEXT().\n\nURL: https://mariadb.com/kb/en/st_aswkt/','','https://mariadb.com/kb/en/st_aswkt/'),(33,'ST_GeomCollFromText',3,'Syntax\n------\n\nST_GeomCollFromText(wkt[,srid])\nST_GeometryCollectionFromText(wkt[,srid])\nGeomCollFromText(wkt[,srid])\nGeometryCollectionFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and SRID.\n\nST_GeomCollFromText(), ST_GeometryCollectionFromText(), GeomCollFromText() and\nGeometryCollectionFromText() are all synonyms.\n\nExample\n-------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/st_geomcollfromtext/','','https://mariadb.com/kb/en/st_geomcollfromtext/'),(34,'ST_GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/st_geometrycollectionfromtext/','','https://mariadb.com/kb/en/st_geometrycollectionfromtext/'),(35,'ST_GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/st_geometryfromtext/','','https://mariadb.com/kb/en/st_geometryfromtext/'),(36,'ST_GeomFromText',3,'Syntax\n------\n\nST_GeomFromText(wkt[,srid])\nST_GeometryFromText(wkt[,srid])\nGeomFromText(wkt[,srid])\nGeometryFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a geometry value of any type using its WKT representation and SRID.\n\nGeomFromText(), GeometryFromText(), ST_GeomFromText() and\nST_GeometryFromText() are all synonyms.\n\nExample\n-------\n\nSET @g = ST_GEOMFROMTEXT(\'POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1 1))\');\n\nURL: https://mariadb.com/kb/en/st_geomfromtext/','','https://mariadb.com/kb/en/st_geomfromtext/'),(37,'ST_LineFromText',3,'Syntax\n------\n\nST_LineFromText(wkt[,srid])\nST_LineStringFromText(wkt[,srid])\nLineFromText(wkt[,srid])\nLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a LINESTRING value using its WKT representation and SRID.\n\nST_LineFromText(), ST_LineStringFromText(), ST_LineFromText() and\nST_LineStringFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_line  (g LINESTRING);\nSHOW FIELDS FROM gis_line;\nINSERT INTO gis_line VALUES\n  (LineFromText(\'LINESTRING(0 0,0 10,10 0)\')),\n  (LineStringFromText(\'LINESTRING(10 10,20 10,20 20,10 20,10 10)\')),\n  (LineStringFromWKB(AsWKB(LineString(Point(10, 10), Point(40, 10)))));\n\nURL: https://mariadb.com/kb/en/st_linefromtext/','','https://mariadb.com/kb/en/st_linefromtext/'),(38,'ST_LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/st_linestringfromtext/','','https://mariadb.com/kb/en/st_linestringfromtext/'),(39,'ST_PointFromText',3,'Syntax\n------\n\nST_PointFromText(wkt[,srid])\nPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POINT value using its WKT representation and SRID.\n\nST_PointFromText() and PointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_point  (g POINT);\nSHOW FIELDS FROM gis_point;\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/st_pointfromtext/','','https://mariadb.com/kb/en/st_pointfromtext/'),(40,'ST_PolyFromText',3,'Syntax\n------\n\nST_PolyFromText(wkt[,srid])\nST_PolygonFromText(wkt[,srid])\nPolyFromText(wkt[,srid])\nPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POLYGON value using its WKT representation and SRID.\n\nST_PolyFromText(), ST_PolygonFromText(), PolyFromText() and\nST_PolygonFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_polygon   (g POLYGON);\nINSERT INTO gis_polygon VALUES\n  (PolygonFromText(\'POLYGON((10 10,20 10,20 20,10 20,10 10))\')),\n  (PolyFromText(\'POLYGON((0 0,50 0,50 50,0 50,0 0), (10 10,20 10,20 20,10\n20,10 10))\'));\n\nURL: https://mariadb.com/kb/en/st_polyfromtext/','','https://mariadb.com/kb/en/st_polyfromtext/'),(41,'ST_PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/st_polygonfromtext/','','https://mariadb.com/kb/en/st_polygonfromtext/'),(42,'DIV',4,'Syntax\n------\n\nDIV\n\nDescription\n-----------\n\nInteger division. Similar to FLOOR(), but is safe with BIGINT values.\nIncorrect results may occur for non-integer operands that exceed BIGINT range.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, a division by zero produces\nan error. Otherwise, it returns NULL.\n\nThe remainder of a division can be obtained using the MOD operator.\n\nExamples\n--------\n\nSELECT 300 DIV 7;\n+-----------+\n| 300 DIV 7 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT 300 DIV 0;\n+-----------+\n| 300 DIV 0 |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/div/','','https://mariadb.com/kb/en/div/'),(43,'ABS',4,'Syntax\n------\n\nABS(X)\n\nDescription\n-----------\n\nReturns the absolute (non-negative) value of X. If X is not a number, it is\nconverted to a numeric type.\n\nExamples\n--------\n\nSELECT ABS(42);\n+---------+\n| ABS(42) |\n+---------+\n|      42 |\n+---------+\n\nSELECT ABS(-42);\n+----------+\n| ABS(-42) |\n+----------+\n|       42 |\n+----------+\n\nSELECT ABS(DATE \'1994-01-01\');\n+------------------------+\n| ABS(DATE \'1994-01-01\') |\n+------------------------+\n|               19940101 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/abs/','','https://mariadb.com/kb/en/abs/'),(44,'ACOS',4,'Syntax\n------\n\nACOS(X)\n\nDescription\n-----------\n\nReturns the arc cosine of X, that is, the value whose cosine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ACOS(1);\n+---------+\n| ACOS(1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ACOS(1.0001);\n+--------------+\n| ACOS(1.0001) |\n+--------------+\n|         NULL |\n+--------------+\n\nSELECT ACOS(0);\n+-----------------+\n| ACOS(0)         |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT ACOS(0.234);\n+------------------+\n| ACOS(0.234)      |\n+------------------+\n| 1.33460644244679 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/acos/','','https://mariadb.com/kb/en/acos/'),(45,'ASIN',4,'Syntax\n------\n\nASIN(X)\n\nDescription\n-----------\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns NULL if\nX is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ASIN(0.2);\n+--------------------+\n| ASIN(0.2)          |\n+--------------------+\n| 0.2013579207903308 |\n+--------------------+\n\nSELECT ASIN(\'foo\');\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n\nSHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n\nURL: https://mariadb.com/kb/en/asin/','','https://mariadb.com/kb/en/asin/'),(46,'ATAN',4,'Syntax\n------\n\nATAN(X)\n\nDescription\n-----------\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nExamples\n--------\n\nSELECT ATAN(2);\n+--------------------+\n| ATAN(2)            |\n+--------------------+\n| 1.1071487177940904 |\n+--------------------+\n\nSELECT ATAN(-2);\n+---------------------+\n| ATAN(-2)            |\n+---------------------+\n| -1.1071487177940904 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/atan/','','https://mariadb.com/kb/en/atan/'),(47,'ATAN2',4,'Syntax\n------\n\nATAN(Y,X), ATAN2(Y,X)\n\nDescription\n-----------\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both arguments\nare used to determine the quadrant of the result.\n\nExamples\n--------\n\nSELECT ATAN(-2,2);\n+---------------------+\n| ATAN(-2,2)          |\n+---------------------+\n| -0.7853981633974483 |\n+---------------------+\n\nSELECT ATAN2(PI(),0);\n+--------------------+\n| ATAN2(PI(),0)      |\n+--------------------+\n| 1.5707963267948966 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/atan2/','','https://mariadb.com/kb/en/atan2/'),(48,'CEIL',4,'Syntax\n------\n\nCEIL(X)\n\nDescription\n-----------\n\nCEIL() is a synonym for CEILING().\n\nURL: https://mariadb.com/kb/en/ceil/','','https://mariadb.com/kb/en/ceil/'),(49,'CEILING',4,'Syntax\n------\n\nCEILING(X)\n\nDescription\n-----------\n\nReturns the smallest integer value not less than X.\n\nExamples\n--------\n\nSELECT CEILING(1.23);\n+---------------+\n| CEILING(1.23) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT CEILING(-1.23);\n+----------------+\n| CEILING(-1.23) |\n+----------------+\n|             -1 |\n+----------------+\n\nURL: https://mariadb.com/kb/en/ceiling/','','https://mariadb.com/kb/en/ceiling/'),(51,'COS',4,'Syntax\n------\n\nCOS(X)\n\nDescription\n-----------\n\nReturns the cosine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT COS(PI());\n+-----------+\n| COS(PI()) |\n+-----------+\n|        -1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/cos/','','https://mariadb.com/kb/en/cos/'),(52,'COT',4,'Syntax\n------\n\nCOT(X)\n\nDescription\n-----------\n\nReturns the cotangent of X.\n\nExamples\n--------\n\nSELECT COT(42);\n+--------------------+\n| COT(42)            |\n+--------------------+\n| 0.4364167060752729 |\n+--------------------+\n\nSELECT COT(12);\n+---------------------+\n| COT(12)             |\n+---------------------+\n| -1.5726734063976893 |\n+---------------------+\n\nSELECT COT(0);\nERROR 1690 (22003): DOUBLE value is out of range in \'cot(0)\'\n\nURL: https://mariadb.com/kb/en/cot/','','https://mariadb.com/kb/en/cot/'),(54,'DEGREES',4,'Syntax\n------\n\nDEGREES(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from radians to degrees.\n\nThis is the converse of the RADIANS() function.\n\nExamples\n--------\n\nSELECT DEGREES(PI());\n+---------------+\n| DEGREES(PI()) |\n+---------------+\n|           180 |\n+---------------+\n\nSELECT DEGREES(PI() / 2);\n+-------------------+\n| DEGREES(PI() / 2) |\n+-------------------+\n|                90 |\n+-------------------+\n\nSELECT DEGREES(45);\n+-----------------+\n| DEGREES(45)     |\n+-----------------+\n| 2578.3100780887 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/degrees/','','https://mariadb.com/kb/en/degrees/'),(55,'EXP',4,'Syntax\n------\n\nEXP(X)\n\nDescription\n-----------\n\nReturns the value of e (the base of natural logarithms) raised to the power of\nX. The inverse of this function is LOG() (using a single argument only) or\nLN().\n\nIf X is NULL, this function returns NULL.\n\nExamples\n--------\n\nSELECT EXP(2);\n+------------------+\n| EXP(2)           |\n+------------------+\n| 7.38905609893065 |\n+------------------+\n\nSELECT EXP(-2);\n+--------------------+\n| EXP(-2)            |\n+--------------------+\n| 0.1353352832366127 |\n+--------------------+\n\nSELECT EXP(0);\n+--------+\n| EXP(0) |\n+--------+\n|      1 |\n+--------+\n\nSELECT EXP(NULL);\n+-----------+\n| EXP(NULL) |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/exp/','','https://mariadb.com/kb/en/exp/'),(50,'CONV',4,'Syntax\n------\n\nCONV(N,from_base,to_base)\n\nDescription\n-----------\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base to_base.\n\nReturns NULL if any argument is NULL, or if the second or third argument are\nnot in the allowed range.\n\nThe argument N is interpreted as an integer, but may be specified as an\ninteger or a string. The minimum base is 2 and the maximum base is 36. If\nto_base is a negative number, N is regarded as a signed number. Otherwise, N\nis treated as unsigned. CONV() works with 64-bit precision.\n\nSome shortcuts for this function are also available: BIN(), OCT(), HEX(),\nUNHEX(). Also, MariaDB allows binary literal values and hexadecimal literal\nvalues.\n\nExamples\n--------\n\nSELECT CONV(\'a\',16,2);\n+----------------+\n| CONV(\'a\',16,2) |\n+----------------+\n| 1010           |\n+----------------+\n\nSELECT CONV(\'6E\',18,8);\n+-----------------+\n| CONV(\'6E\',18,8) |\n+-----------------+\n| 172             |\n+-----------------+\n\nSELECT CONV(-17,10,-18);\n+------------------+\n| CONV(-17,10,-18) |\n+------------------+\n| -H               |\n+------------------+\n\nSELECT CONV(12+\'10\'+\'10\'+0xa,10,10);\n+------------------------------+\n| CONV(12+\'10\'+\'10\'+0xa,10,10) |\n+------------------------------+\n| 42                           |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/conv/','','https://mariadb.com/kb/en/conv/'),(53,'CRC32',4,'Syntax\n------\n\n<= MariaDB 10.7\n\nCRC32(expr)\n\nFrom MariaDB 10.8\n\nCRC32([par,]expr)\n\nDescription\n-----------\n\nComputes a cyclic redundancy check (CRC) value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is expected to\nbe a string and (if possible) is treated as one if it is not.\n\nUses the ISO 3309 polynomial that used by zlib and many others. MariaDB 10.8\nintroduced the CRC32C() function, which uses the alternate Castagnoli\npolynomia.\n\nMariaDB starting with 10.8\n--------------------------\nOften, CRC is computed in pieces. To facilitate this, MariaDB 10.8.0\nintroduced an optional parameter: CRC32(\'MariaDB\')=CRC32(CRC32(\'Maria\'),\'DB\').\n\nExamples\n--------\n\nSELECT CRC32(\'MariaDB\');\n+------------------+\n| CRC32(\'MariaDB\') |\n+------------------+\n|       4227209140 |\n+------------------+\n\nSELECT CRC32(\'mariadb\');\n+------------------+\n| CRC32(\'mariadb\') |\n+------------------+\n|       2594253378 |\n+------------------+\n\nFrom MariaDB 10.8.0\n\nSELECT CRC32(CRC32(\'Maria\'),\'DB\');\n+----------------------------+\n| CRC32(CRC32(\'Maria\'),\'DB\') |\n+----------------------------+\n|                 4227209140 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/crc32/','','https://mariadb.com/kb/en/crc32/'),(56,'FLOOR',4,'Syntax\n------\n\nFLOOR(X)\n\nDescription\n-----------\n\nReturns the largest integer value not greater than X.\n\nExamples\n--------\n\nSELECT FLOOR(1.23);\n+-------------+\n| FLOOR(1.23) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT FLOOR(-1.23);\n+--------------+\n| FLOOR(-1.23) |\n+--------------+\n|           -2 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/floor/','','https://mariadb.com/kb/en/floor/'),(57,'LN',4,'Syntax\n------\n\nLN(X)\n\nDescription\n-----------\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X. If X\nis less than or equal to 0, or NULL, then NULL is returned.\n\nThe inverse of this function is EXP().\n\nExamples\n--------\n\nSELECT LN(2);\n+-------------------+\n| LN(2)             |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LN(-2);\n+--------+\n| LN(-2) |\n+--------+\n|   NULL |\n+--------+\n\nURL: https://mariadb.com/kb/en/ln/','','https://mariadb.com/kb/en/ln/'),(58,'LOG',4,'Syntax\n------\n\nLOG(X), LOG(B,X)\n\nDescription\n-----------\n\nIf called with one parameter, this function returns the natural logarithm of\nX. If X is less than or equal to 0, then NULL is returned.\n\nIf called with two parameters, it returns the logarithm of X to the base B. If\nB is <= 1 or X <= 0, the function returns NULL.\n\nIf any argument is NULL, the function returns NULL.\n\nThe inverse of this function (when called with a single argument) is the EXP()\nfunction.\n\nExamples\n--------\n\nLOG(X):\n\nSELECT LOG(2);\n+-------------------+\n| LOG(2)            |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LOG(-2);\n+---------+\n| LOG(-2) |\n+---------+\n|    NULL |\n+---------+\n\nLOG(B,X)\n\nSELECT LOG(2,16);\n+-----------+\n| LOG(2,16) |\n+-----------+\n|         4 |\n+-----------+\n\nSELECT LOG(3,27);\n+-----------+\n| LOG(3,27) |\n+-----------+\n|         3 |\n+-----------+\n\nSELECT LOG(3,1);\n+----------+\n| LOG(3,1) |\n+----------+\n|        0 |\n+----------+\n\nSELECT LOG(3,0);\n+----------+\n| LOG(3,0) |\n+----------+\n|     NULL |\n+----------+\n\nURL: https://mariadb.com/kb/en/log/','','https://mariadb.com/kb/en/log/'),(59,'LOG10',4,'Syntax\n------\n\nLOG10(X)\n\nDescription\n-----------\n\nReturns the base-10 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG10(2);\n+-------------------+\n| LOG10(2)          |\n+-------------------+\n| 0.301029995663981 |\n+-------------------+\n\nSELECT LOG10(100);\n+------------+\n| LOG10(100) |\n+------------+\n|          2 |\n+------------+\n\nSELECT LOG10(-100);\n+-------------+\n| LOG10(-100) |\n+-------------+\n|        NULL |\n+-------------+\n\nURL: https://mariadb.com/kb/en/log10/','','https://mariadb.com/kb/en/log10/'),(60,'LOG2',4,'Syntax\n------\n\nLOG2(X)\n\nDescription\n-----------\n\nReturns the base-2 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG2(4398046511104);\n+---------------------+\n| LOG2(4398046511104) |\n+---------------------+\n|                  42 |\n+---------------------+\n\nSELECT LOG2(65536);\n+-------------+\n| LOG2(65536) |\n+-------------+\n|          16 |\n+-------------+\n\nSELECT LOG2(-100);\n+------------+\n| LOG2(-100) |\n+------------+\n|       NULL |\n+------------+\n\nURL: https://mariadb.com/kb/en/log2/','','https://mariadb.com/kb/en/log2/'),(62,'OCT',4,'Syntax\n------\n\nOCT(N)\n\nDescription\n-----------\n\nReturns a string representation of the octal value of N, where N is a longlong\n(BIGINT) number. This is equivalent to CONV(N,10,8). Returns NULL if N is NULL.\n\nExamples\n--------\n\nSELECT OCT(34);\n+---------+\n| OCT(34) |\n+---------+\n| 42      |\n+---------+\n\nSELECT OCT(12);\n+---------+\n| OCT(12) |\n+---------+\n| 14      |\n+---------+\n\nURL: https://mariadb.com/kb/en/oct/','','https://mariadb.com/kb/en/oct/'),(63,'PI',4,'Syntax\n------\n\nPI()\n\nDescription\n-----------\n\nReturns the value of π (pi). The default number of decimal places displayed is\nsix, but MariaDB uses the full double-precision value internally.\n\nExamples\n--------\n\nSELECT PI();\n+----------+\n| PI()     |\n+----------+\n| 3.141593 |\n+----------+\n\nSELECT PI()+0.0000000000000000000000;\n+-------------------------------+\n| PI()+0.0000000000000000000000 |\n+-------------------------------+\n|      3.1415926535897931159980 |\n+-------------------------------+\n\nURL: https://mariadb.com/kb/en/pi/','','https://mariadb.com/kb/en/pi/'),(64,'POW',4,'Syntax\n------\n\nPOW(X,Y)\n\nDescription\n-----------\n\nReturns the value of X raised to the power of Y.\n\nPOWER() is a synonym.\n\nExamples\n--------\n\nSELECT POW(2,3);\n+----------+\n| POW(2,3) |\n+----------+\n|        8 |\n+----------+\n\nSELECT POW(2,-2);\n+-----------+\n| POW(2,-2) |\n+-----------+\n|      0.25 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/pow/','','https://mariadb.com/kb/en/pow/'),(65,'POWER',4,'Syntax\n------\n\nPOWER(X,Y)\n\nDescription\n-----------\n\nThis is a synonym for POW(), which returns the value of X raised to the power\nof Y.\n\nURL: https://mariadb.com/kb/en/power/','','https://mariadb.com/kb/en/power/'),(61,'MOD',4,'Syntax\n------\n\nMOD(N,M), N % M, N MOD M\n\nDescription\n-----------\n\nModulo operation. Returns the remainder of N divided by M. See also Modulo\nOperator.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, any number modulus zero\nproduces an error. Otherwise, it returns NULL.\n\nThe integer part of a division can be obtained using DIV.\n\nExamples\n--------\n\nSELECT 1042 % 50;\n+-----------+\n| 1042 % 50 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT MOD(234, 10);\n+--------------+\n| MOD(234, 10) |\n+--------------+\n|            4 |\n+--------------+\n\nSELECT 253 % 7;\n+---------+\n| 253 % 7 |\n+---------+\n|       1 |\n+---------+\n\nSELECT MOD(29,9);\n+-----------+\n| MOD(29,9) |\n+-----------+\n|         2 |\n+-----------+\n\nSELECT 29 MOD 9;\n+----------+\n| 29 MOD 9 |\n+----------+\n|        2 |\n+----------+\n\nURL: https://mariadb.com/kb/en/mod/','','https://mariadb.com/kb/en/mod/'),(66,'RADIANS',4,'Syntax\n------\n\nRADIANS(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from degrees to radians. Note that π radians\nequals 180 degrees.\n\nThis is the converse of the DEGREES() function.\n\nExamples\n--------\n\nSELECT RADIANS(45);\n+-------------------+\n| RADIANS(45)       |\n+-------------------+\n| 0.785398163397448 |\n+-------------------+\n\nSELECT RADIANS(90);\n+-----------------+\n| RADIANS(90)     |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT RADIANS(PI());\n+--------------------+\n| RADIANS(PI())      |\n+--------------------+\n| 0.0548311355616075 |\n+--------------------+\n\nSELECT RADIANS(180);\n+------------------+\n| RADIANS(180)     |\n+------------------+\n| 3.14159265358979 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/radians/','','https://mariadb.com/kb/en/radians/'),(67,'RAND',4,'Syntax\n------\n\nRAND(), RAND(N)\n\nDescription\n-----------\n\nReturns a random DOUBLE precision floating point value v in the range 0 <= v <\n1.0. If a constant integer argument N is specified, it is used as the seed\nvalue, which produces a repeatable sequence of column values. In the example\nbelow, note that the sequences of values produced by RAND(3) is the same both\nplaces where it occurs.\n\nIn a WHERE clause, RAND() is evaluated each time the WHERE is executed.\n\nStatements using the RAND() function are not safe for statement-based\nreplication.\n\nPractical uses\n--------------\n\nThe expression to get a random integer from a given range is the following:\n\nFLOOR(min_value + RAND() * (max_value - min_value +1))\n\nRAND() is often used to read random rows from a table, as follows:\n\nSELECT * FROM my_table ORDER BY RAND() LIMIT 10;\n\nNote, however, that this technique should never be used on a large table as it\nwill be extremely slow. MariaDB will read all rows in the table, generate a\nrandom value for each of them, order them, and finally will apply the LIMIT\nclause.\n\nExamples\n--------\n\nCREATE TABLE t (i INT);\n\nINSERT INTO t VALUES(1),(2),(3);\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.255651095188829 |\n|    2 | 0.833920199269355 |\n|    3 |  0.40264774151393 |\n+------+-------------------+\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.511478140495232 |\n|    2 | 0.349447508668012 |\n|    3 | 0.212803152588013 |\n+------+-------------------+\n\nUsing the same seed, the same sequence will be returned:\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nGenerating a random number from 5 to 15:\n\nSELECT FLOOR(5 + (RAND() * 11));\n\nURL: https://mariadb.com/kb/en/rand/','','https://mariadb.com/kb/en/rand/'),(68,'ROUND',4,'Syntax\n------\n\nROUND(X), ROUND(X,D)\n\nDescription\n-----------\n\nRounds the argument X to D decimal places. D defaults to 0 if not specified. D\ncan be negative to cause D digits left of the decimal point of the value X to\nbecome zero.\n\nThe rounding algorithm depends on the data type of X:\n\n* for floating point types (FLOAT, DOUBLE) the C libraries rounding function\nis used, so the behavior *may* differ between operating systems\n* for fixed point types (DECIMAL, DEC/NUMBER/FIXED) the \"round half up\" rule\nis used, meaning that e.g. a value ending in exactly .5 is always rounded up.\n\nExamples\n--------\n\nSELECT ROUND(-1.23);\n+--------------+\n| ROUND(-1.23) |\n+--------------+\n|           -1 |\n+--------------+\n\nSELECT ROUND(-1.58);\n+--------------+\n| ROUND(-1.58) |\n+--------------+\n|           -2 |\n+--------------+\n\nSELECT ROUND(1.58); \n+-------------+\n| ROUND(1.58) |\n+-------------+\n|           2 |\n+-------------+\n\nSELECT ROUND(1.298, 1);\n+-----------------+\n| ROUND(1.298, 1) |\n+-----------------+\n|             1.3 |\n+-----------------+\n\nSELECT ROUND(1.298, 0);\n+-----------------+\n| ROUND(1.298, 0) |\n+-----------------+\n|               1 |\n+-----------------+\n\nSELECT ROUND(23.298, -1);\n+-------------------+\n| ROUND(23.298, -1) |\n+-------------------+\n|                20 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/round/','','https://mariadb.com/kb/en/round/'),(69,'SIGN',4,'Syntax\n------\n\nSIGN(X)\n\nDescription\n-----------\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X is\nnegative, zero, or positive.\n\nExamples\n--------\n\nSELECT SIGN(-32);\n+-----------+\n| SIGN(-32) |\n+-----------+\n|        -1 |\n+-----------+\n\nSELECT SIGN(0);\n+---------+\n| SIGN(0) |\n+---------+\n|       0 |\n+---------+\n\nSELECT SIGN(234);\n+-----------+\n| SIGN(234) |\n+-----------+\n|         1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/sign/','','https://mariadb.com/kb/en/sign/'),(70,'SIN',4,'Syntax\n------\n\nSIN(X)\n\nDescription\n-----------\n\nReturns the sine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT SIN(1.5707963267948966);\n+-------------------------+\n| SIN(1.5707963267948966) |\n+-------------------------+\n|                       1 |\n+-------------------------+\n\nSELECT SIN(PI());\n+----------------------+\n| SIN(PI())            |\n+----------------------+\n| 1.22460635382238e-16 |\n+----------------------+\n\nSELECT ROUND(SIN(PI()));\n+------------------+\n| ROUND(SIN(PI())) |\n+------------------+\n|                0 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/sin/','','https://mariadb.com/kb/en/sin/'),(71,'SQRT',4,'Syntax\n------\n\nSQRT(X)\n\nDescription\n-----------\n\nReturns the square root of X. If X is negative, NULL is returned.\n\nExamples\n--------\n\nSELECT SQRT(4);\n+---------+\n| SQRT(4) |\n+---------+\n|       2 |\n+---------+\n\nSELECT SQRT(20);\n+------------------+\n| SQRT(20)         |\n+------------------+\n| 4.47213595499958 |\n+------------------+\n\nSELECT SQRT(-16);\n+-----------+\n| SQRT(-16) |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT SQRT(1764);\n+------------+\n| SQRT(1764) |\n+------------+\n|         42 |\n+------------+\n\nURL: https://mariadb.com/kb/en/sqrt/','','https://mariadb.com/kb/en/sqrt/'),(72,'TAN',4,'Syntax\n------\n\nTAN(X)\n\nDescription\n-----------\n\nReturns the tangent of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT TAN(0.7853981633974483);\n+-------------------------+\n| TAN(0.7853981633974483) |\n+-------------------------+\n|      0.9999999999999999 |\n+-------------------------+\n\nSELECT TAN(PI());\n+-----------------------+\n| TAN(PI())             |\n+-----------------------+\n| -1.22460635382238e-16 |\n+-----------------------+\n\nSELECT TAN(PI()+1);\n+-----------------+\n| TAN(PI()+1)     |\n+-----------------+\n| 1.5574077246549 |\n+-----------------+\n\nSELECT TAN(RADIANS(PI()));\n+--------------------+\n| TAN(RADIANS(PI())) |\n+--------------------+\n| 0.0548861508080033 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/tan/','','https://mariadb.com/kb/en/tan/'),(73,'TRUNCATE',4,'This page documents the TRUNCATE function. See TRUNCATE TABLE for the DDL\nstatement.\n\nSyntax\n------\n\nTRUNCATE(X,D)\n\nDescription\n-----------\n\nReturns the number X, truncated to D decimal places. If D is 0, the result has\nno decimal point or fractional part. D can be negative to cause D digits left\nof the decimal point of the value X to become zero.\n\nExamples\n--------\n\nSELECT TRUNCATE(1.223,1);\n+-------------------+\n| TRUNCATE(1.223,1) |\n+-------------------+\n|               1.2 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,1);\n+-------------------+\n| TRUNCATE(1.999,1) |\n+-------------------+\n|               1.9 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,0); \n+-------------------+\n| TRUNCATE(1.999,0) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSELECT TRUNCATE(-1.999,1);\n+--------------------+\n| TRUNCATE(-1.999,1) |\n+--------------------+\n|               -1.9 |\n+--------------------+\n\nSELECT TRUNCATE(122,-2);\n+------------------+\n| TRUNCATE(122,-2) |\n+------------------+\n|              100 |\n+------------------+\n\nSELECT TRUNCATE(10.28*100,0);\n+-----------------------+\n| TRUNCATE(10.28*100,0) |\n+-----------------------+\n|                  1028 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/truncate/','','https://mariadb.com/kb/en/truncate/'),(74,'INSTALL PLUGIN',5,'Syntax\n------\n\nINSTALL PLUGIN [IF NOT EXISTS] plugin_name SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement installs an individual plugin from the specified library. To\ninstall the whole library (which could be required), use INSTALL SONAME. See\nalso Installing a Plugin.\n\nplugin_name is the name of the plugin as defined in the plugin declaration\nstructure contained in the library file. Plugin names are not case sensitive.\nFor maximal compatibility, plugin names should be limited to ASCII letters,\ndigits, and underscore, because they are used in C source files, shell command\nlines, M4 and Bourne shell scripts, and SQL environments.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension can be omitted (which makes the statement look\nthe same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL PLUGIN adds a line to the mysql.plugin table that describes the\nplugin. This table contains the plugin name and library file name.\n\nINSTALL PLUGIN causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL PLUGIN also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL PLUGIN, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nPLUGIN only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a note instead of\nan error if the specified plugin already exists. See SHOW WARNINGS.\n\nExamples\n--------\n\nINSTALL PLUGIN sphinx SONAME \'ha_sphinx.so\';\n\nThe extension can also be omitted:\n\nINSTALL PLUGIN innodb SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected (0.104 sec)\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+------------------------------------+\n| Level | Code | Message                            |\n+-------+------+------------------------------------+\n| Note  | 1968 | Plugin \'example\' already installed |\n+-------+------+------------------------------------+\n\nURL: https://mariadb.com/kb/en/install-plugin/','','https://mariadb.com/kb/en/install-plugin/'),(78,'Plugin Overview',5,'Plugins are server components that enhance MariaDB in some way. These can be\nanything from new storage engines, plugins for enhancing full-text parsing, or\neven small enhancements, such as a plugin to get a timestamp as an integer.\n\nQuerying Plugin Information\n---------------------------\n\nThere are a number of ways to see which plugins are currently active.\n\nA server almost always has a large number of active plugins, because the\nserver contains a large number of built-in plugins, which are active by\ndefault and cannot be uninstalled.\n\nQuerying Plugin Information with SHOW PLUGINS\n---------------------------------------------\n\nThe SHOW PLUGINS statement can be used to query information about all active\nplugins.\n\nFor example:\n\nSHOW PLUGINS\\G;\n********************** 1. row **********************\n Name: binlog\n Status: ACTIVE\n Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n********************** 2. row **********************\n Name: mysql_native_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n********************** 3. row **********************\n Name: mysql_old_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n...\n\nIf a plugin\'s Library column has a NULL value, then the plugin is built-in,\nand it cannot be uninstalled.\n\nQuerying Plugin Information with information_schema.PLUGINS\n-----------------------------------------------------------\n\nThe information_schema.PLUGINS table can be queried to get more detailed\ninformation about plugins.\n\nFor example:\n\nSELECT * FROM information_schema.PLUGINS\\G\n...\n*************************** 6. row ***************************\n     PLUGIN_NAME: CSV\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: Brian Aker, MySQL AB\n  PLUGIN_DESCRIPTION: CSV storage engine\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n*************************** 7. row ***************************\n     PLUGIN_NAME: MEMORY\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: MySQL AB\n  PLUGIN_DESCRIPTION: Hash based, stored in memory, useful for temporary\ntables\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n...\n\nIf a plugin\'s PLUGIN_LIBRARY column has the NULL value, then the plugin is\nbuilt-in, and it cannot be uninstalled.\n\nQuerying Plugin Information with mysql.plugin\n---------------------------------------------\n\nThe mysql.plugin table can be queried to get information about installed\nplugins.\n\nThis table only contains information about plugins that have been installed\nvia the following methods:\n\n* The INSTALL SONAME statement.\n* The INSTALL PLUGIN statement.\n* The mysql_plugin utility.\n\nThis table does not contain information about:\n\n* Built-in plugins.\n* Plugins loaded with the --plugin-load-add option.\n* Plugins loaded with the --plugin-load option.\n\nThis table only contains enough information to reload the plugin when the\nserver is restarted, which means it only contains the plugin name and the\nplugin library.\n\nFor example:\n\nSELECT * FROM mysql.plugin;\n\n+------+------------+\n| name | dl         |\n+------+------------+\n| PBXT | libpbxt.so |\n+------+------------+\n\nInstalling a Plugin\n-------------------\n\nThere are three primary ways to install a plugin:\n\n* A plugin can be installed dynamically with an SQL statement.\n* A plugin can be installed with a mysqld option, but it requires a server\nrestart.\n* A plugin can be installed with the mysql_plugin utility, while the server is\ncompletely offline.\n\nWhen you are installing a plugin, you also have to ensure that:\n\n* The server\'s plugin directory is properly configured, and the plugin\'s\nlibrary is in the plugin directory.\n* The server\'s minimum plugin maturity is properly configured, and the plugin\nis mature enough to be installed.\n\nInstalling a Plugin Dynamically\n-------------------------------\n\nA plugin can be installed dynamically by executing either the INSTALL SONAME\nor the INSTALL PLUGIN statement.\n\nIf a plugin is installed with one of these statements, then a record will be\nadded to the mysql.plugins table for the plugin. This means that the plugin\nwill automatically be loaded every time the server restarts, unless\nspecifically uninstalled or deactivated.\n\nInstalling a Plugin with INSTALL SONAME\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL SONAME\nstatement. INSTALL SONAME installs all plugins from the given plugin library.\nThis could be required for some plugin libraries.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin), you could execute the\nfollowing:\n\nINSTALL SONAME \'server_audit\';\n\nInstalling a Plugin with INSTALL PLUGIN\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL PLUGIN\nstatement. INSTALL PLUGIN installs a single plugin from the given plugin\nlibrary.\n\nFor example, to install the server_audit audit plugin from the server_audit\nplugin library, you could execute the following:\n\nINSTALL PLUGIN server_audit SONAME \'server_audit\';\n\nInstalling a Plugin with Plugin Load Options\n--------------------------------------------\n\nA plugin can be installed with a mysqld option by providing either the\n--plugin-load-add or the --plugin-load option.\n\nIf a plugin is installed with one of these options, then a record will not be\nadded to the mysql.plugins table for the plugin. This means that if the server\nis restarted without the same option set, then the plugin will not\nautomatically be loaded.\n\nInstalling a Plugin with --plugin-load-add\n------------------------------------------\n\nYou can install a plugin with the --plugin-load-add option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load-add option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load-add=\'server_audit\'\n--plugin-load-add=\'ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nSpecial care must be taken when specifying both the --plugin-load option and\nthe --plugin-load-add option together. The --plugin-load option resets the\nplugin load list, and this can cause unexpected problems if you are not aware.\nThe --plugin-load-add option does not reset the plugin load list, so it is\nmuch safer to use. See Specifying Multiple Plugin Load Options for more\ninformation.\n\nInstalling a Plugin with --plugin-load\n--------------------------------------\n\nYou can install a plugin with the --plugin-load option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load=\'server_audit;ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load = server_audit;ed25519=auth_ed25519\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option together. The --plugin-load option resets the plugin\nload list, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use. See Specifying Multiple Plugin Load Options for more information.\n\nSpecifying Multiple Plugin Load Options\n---------------------------------------\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option. The --plugin-load option resets the plugin load\nlist, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use.\n\nThis can have the following consequences:\n\n* If the --plugin-load option is specified multiple times, then only the last\ninstance will have any effect. For example, in the following case, the first\ninstance of the option is reset:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* If the --plugin-load option is specified after the --plugin-load-add option,\nthen it will also reset the changes made by that option. For example, in the\nfollowing case, the --plugin-load-add option does not do anything, because the\nsubsequent --plugin-load option resets the plugin load list:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* In contrast, if the --plugin-load option is specified before the\n--plugin-load-add option, then it will work fine, because the\n--plugin-load-add option does not reset the plugin load list. For example, in\nthe following case, both plugins are properly loaded:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nInstalling a Plugin with mysql_plugin\n-------------------------------------\n\nA plugin can be installed with the mysql_plugin utility if the server is\ncompletely offline.\n\nThe syntax is:\n\nmysql_plugin [options] <plugin> ENABLE|DISABLE\n\nFor example, to install the server_audit audit plugin, you could execute the\nfollowing:\n\nmysql_plugin server_audit ENABLE\n\nIf a plugin is installed with this utility, then a record will be added to the\nmysql.plugins table for the plugin. This means that the plugin will\nautomatically be loaded every time the server restarts, unless specifically\nuninstalled or deactivated.\n\nConfiguring the Plugin Directory\n--------------------------------\n\nWhen a plugin is being installed, the server looks for the plugin\'s library in\nthe server\'s plugin directory. This directory is configured by the plugin_dir\nsystem variable. This can be specified as a command-line argument to mysqld or\nit can be specified in a relevant server option group in an option file. For\nexample:\n\n[mariadb]\n...\nplugin_dir = /usr/lib64/mysql/plugin\n\nConfiguring the Minimum Plugin Maturity\n---------------------------------------\n\nWhen a plugin is being installed, the server compares the plugin\'s maturity\nlevel against the server\'s minimum allowed plugin maturity. This can help\nprevent users from using unstable plugins on production servers. This minimum\nplugin maturity is configured by the plugin_maturity system variable. This can\nbe specified as a command-line argument to mysqld or it can be specified in a\nrelevant server option group in an option file. For example:\n\n[mariadb]\n...\nplugin_maturity = stable\n\nConfiguring Plugin Activation at Server Startup\n-----------------------------------------------\n\nA plugin will be loaded by default when the server starts if:\n\n* The plugin was installed with the INSTALL SONAME statement.\n* The plugin was installed with the INSTALL PLUGIN statement.\n* The plugin was installed with the mysql_plugin utility.\n* The server is configured to load the plugin with the --plugin-load-add\noption.\n* The server is configured to load the plugin with the --plugin-load option.\n\nThis behavior can be changed with special options that take the form\n--plugin-name. For example, for the server_audit audit plugin, the special\noption is called --server-audit.\n\nThe possible values for these special options are:\n\n+---------------------------------------+------------------------------------+\n| Option Value                          | Description                        |\n+---------------------------------------+------------------------------------+\n| OFF                                   | Disables the plugin without        |\n|                                       | removing it from the               |\n|                                       | mysql.plugins table.               |\n+---------------------------------------+------------------------------------+\n| ON                                    | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will still continue         |\n|                                       | starting up, but the plugin will   |\n|                                       | be disabled.                       |\n+---------------------------------------+------------------------------------+\n| FORCE                                 | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error.                             |\n+---------------------------------------+------------------------------------+\n| FORCE_PLUS_PERMANENT                  | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error. In addition, the plugin     |\n|                                       | cannot be uninstalled with         |\n|                                       | UNINSTALL SONAME or UNINSTALL      |\n|                                       | PLUGIN while the server is         |\n|                                       | running.                           |\n+---------------------------------------+------------------------------------+\n\nA plugin\'s status can be found by looking at the PLUGIN_STATUS column of the\ninformation_schema.PLUGINS table.\n\nUninstalling Plugins\n--------------------\n\nPlugins that are found in the mysql.plugin table, that is those that were\ninstalled with INSTALL SONAME, INSTALL PLUGIN or mysql_plugin can be\nuninstalled in one of two ways:\n\n* The UNINSTALL SONAME or the UNINSTALL PLUGIN statement while the server is\nrunning\n* With mysql_plugin while the server is offline.\n\nPlugins that were enabled as a --plugin-load option do not need to be\nuninstalled. If --plugin-load is omitted the next time the server starts, or\nthe plugin is not listed as one of the --plugin-load entries, the plugin will\nnot be loaded.\n\nUNINSTALL PLUGIN uninstalls a single installed plugin, while UNINSTALL SONAME\nuninstalls all plugins belonging to a given library.\n\nURL: https://mariadb.com/kb/en/plugin-overview/','','https://mariadb.com/kb/en/plugin-overview/'),(79,'MBR Definition',6,'Description\n-----------\n\nThe MBR (Minimum Bounding Rectangle), or Envelope is the bounding geometry,\nformed by the minimum and maximum (X,Y) coordinates:\n\nExamples\n--------\n\n((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n\nURL: https://mariadb.com/kb/en/mbr-definition/','','https://mariadb.com/kb/en/mbr-definition/'),(80,'MBRContains',6,'Syntax\n------\n\nMBRContains(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1\ncontains the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRWithin().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\n\nSET @g2 = GeomFromText(\'Point(1 1)\');\n\nSELECT MBRContains(@g1,@g2), MBRContains(@g2,@g1);\n+----------------------+----------------------+\n| MBRContains(@g1,@g2) | MBRContains(@g2,@g1) |\n+----------------------+----------------------+\n|                    1 |                    0 |\n+----------------------+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrcontains/','','https://mariadb.com/kb/en/mbrcontains/'),(82,'MBREqual',6,'Syntax\n------\n\nMBREqual(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are the same.\n\nExamples\n--------\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 2)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 2, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 3)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 4, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 0 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/mbrequal/','','https://mariadb.com/kb/en/mbrequal/'),(86,'MBRWithin',6,'Syntax\n------\n\nMBRWithin(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1 is\nwithin the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRContains().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((0 0,0 5,5 5,5 0,0 0))\');\nSELECT MBRWithin(@g1,@g2), MBRWithin(@g2,@g1);\n+--------------------+--------------------+\n| MBRWithin(@g1,@g2) | MBRWithin(@g2,@g1) |\n+--------------------+--------------------+\n|                  1 |                  0 |\n+--------------------+--------------------+\n\nURL: https://mariadb.com/kb/en/mbrwithin/','','https://mariadb.com/kb/en/mbrwithin/'),(75,'UNINSTALL PLUGIN',5,'Syntax\n------\n\nUNINSTALL PLUGIN [IF EXISTS] plugin_name\n\nDescription\n-----------\n\nThis statement removes a single installed plugin. To uninstall the whole\nlibrary which contains the plugin, use UNINSTALL SONAME. You cannot uninstall\na plugin if any table that uses it is open.\n\nplugin_name must be the name of some plugin that is listed in the mysql.plugin\ntable. The server executes the plugin\'s deinitialization function and removes\nthe row for the plugin from the mysql.plugin table, so that subsequent server\nrestarts will not load and initialize the plugin. UNINSTALL PLUGIN does not\nremove the plugin\'s shared library file.\n\nTo use UNINSTALL PLUGIN, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nUNINSTALL PLUGIN example;\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------+\n| Level | Code | Message                       |\n+-------+------+-------------------------------+\n| Note  | 1305 | PLUGIN example does not exist |\n+-------+------+-------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-plugin/','','https://mariadb.com/kb/en/uninstall-plugin/'),(76,'INSTALL SONAME',5,'Syntax\n------\n\nINSTALL SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of INSTALL PLUGIN. It installs all plugins from a\ngiven plugin_library. See INSTALL PLUGIN for details.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL SONAME adds one or more lines to the mysql.plugin table that describes\nthe plugin. This table contains the plugin name and library file name.\n\nINSTALL SONAME causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL SONAME also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL SONAME, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nSONAME only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nIf you need to install only one plugin from a library, use the INSTALL PLUGIN\nstatement.\n\nExamples\n--------\n\nTo load the XtraDB storage engine and all of its information_schema tables\nwith one statement, use\n\nINSTALL SONAME \'ha_xtradb\';\n\nThis statement can be used instead of INSTALL PLUGIN even when the library\ncontains only one plugin:\n\nINSTALL SONAME \'ha_sequence\';\n\nURL: https://mariadb.com/kb/en/install-soname/','','https://mariadb.com/kb/en/install-soname/'),(77,'UNINSTALL SONAME',5,'Syntax\n------\n\nUNINSTALL SONAME  [IF EXISTS] \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of UNINSTALL PLUGIN statement, that removes all\nplugins belonging to a specified plugin_library. See UNINSTALL PLUGIN for\ndetails.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nTo use UNINSTALL SONAME, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin library does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nTo uninstall the XtraDB plugin and all of its information_schema tables with\none statement, use\n\nUNINSTALL SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------------+\n| Level | Code | Message                             |\n+-------+------+-------------------------------------+\n| Note  | 1305 | SONAME ha_example.so does not exist |\n+-------+------+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-soname/','','https://mariadb.com/kb/en/uninstall-soname/'),(90,'NULLIF',7,'Syntax\n------\n\nNULLIF(expr1,expr2)\n\nDescription\n-----------\n\nReturns NULL if expr1 = expr2 is true, otherwise returns expr1. This is the\nsame as CASE WHEN expr1 = expr2 THEN NULL ELSE expr1 END.\n\nExamples\n--------\n\nSELECT NULLIF(1,1);\n+-------------+\n| NULLIF(1,1) |\n+-------------+\n|        NULL |\n+-------------+\n\nSELECT NULLIF(1,2);\n+-------------+\n| NULLIF(1,2) |\n+-------------+\n|           1 |\n+-------------+\n\nURL: https://mariadb.com/kb/en/nullif/','','https://mariadb.com/kb/en/nullif/'),(91,'NVL',7,'MariaDB starting with 10.3\n--------------------------\nFrom MariaDB 10.3, NVL is a synonym for IFNULL.\n\nURL: https://mariadb.com/kb/en/nvl/','','https://mariadb.com/kb/en/nvl/'),(92,'NVL2',7,'MariaDB starting with 10.3\n--------------------------\nThe NLV2 function was introduced in MariaDB 10.3.0.\n\nSyntax\n------\n\nNVL2(expr1,expr2,expr3)\n\nDescription\n-----------\n\nThe NVL2 function returns a value based on whether a specified expression is\nNULL or not. If expr1 is not NULL, then NVL2 returns expr2. If expr1 is NULL,\nthen NVL2 returns expr3.\n\nExamples\n--------\n\nSELECT NVL2(NULL,1,2);\n+----------------+\n| NVL2(NULL,1,2) |\n+----------------+\n|              2 |\n+----------------+\n\nSELECT NVL2(\'x\',1,2);\n+---------------+\n| NVL2(\'x\',1,2) |\n+---------------+\n|             1 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/nvl2/','','https://mariadb.com/kb/en/nvl2/'),(81,'MBRDisjoint',6,'Syntax\n------\n\nMBRDisjoint(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are disjoint. Two geometries are disjoint if they do not\nintersect, that is touch or overlap.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECTmbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrdisjoint/','','https://mariadb.com/kb/en/mbrdisjoint/'),(83,'MBRIntersects',6,'Syntax\n------\n\nMBRIntersects(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 intersect.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      1 |\n+------------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      0 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/mbrintersects/','','https://mariadb.com/kb/en/mbrintersects/'),(84,'MBROverlaps',6,'Syntax\n------\n\nMBROverlaps(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 overlap. The term spatially overlaps is used if two\ngeometries intersect and their intersection results in a geometry of the same\ndimension but not equal to either of the given geometries.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbroverlaps/','','https://mariadb.com/kb/en/mbroverlaps/'),(85,'MBRTouches',6,'Syntax\n------\n\nMBRTouches(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 touch. Two geometries spatially touch if the interiors of\nthe geometries do not intersect, but the boundary of one of the geometries\nintersects either the boundary or the interior of the other.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   1 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/mbrtouches/','','https://mariadb.com/kb/en/mbrtouches/'),(87,'CASE OPERATOR',7,'Syntax\n------\n\nCASE value WHEN [compare_value] THEN result [WHEN [compare_value] THEN\nresult ...] [ELSE result] END\n\nCASE WHEN [condition] THEN result [WHEN [condition] THEN result ...]\n[ELSE result] END\n\nDescription\n-----------\n\nThe first version returns the result where value=compare_value. The second\nversion returns the result for the first condition that is true. If there was\nno matching result value, the result after ELSE is returned, or NULL if there\nis no ELSE part.\n\nThere is also a CASE statement, which differs from the CASE operator described\nhere.\n\nExamples\n--------\n\nSELECT CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END;\n+------------------------------------------------------------+\n| CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END |\n+------------------------------------------------------------+\n| one                                                        |\n+------------------------------------------------------------+\n\nSELECT CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END;\n+--------------------------------------------+\n| CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END |\n+--------------------------------------------+\n| true                                       |\n+--------------------------------------------+\n\nSELECT CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END;\n+-----------------------------------------------------+\n| CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END |\n+-----------------------------------------------------+\n|                                                NULL |\n+-----------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/case-operator/','','https://mariadb.com/kb/en/case-operator/'),(101,'UNLOCK TABLES',8,'Syntax\n------\n\nUNLOCK TABLES\n\nDescription\n-----------\n\nUNLOCK TABLES explicitly releases any table locks held by the current session.\nSee LOCK TABLES for more information.\n\nIn addition to releasing table locks acquired by the LOCK TABLES statement,\nthe UNLOCK TABLES statement also releases the global read lock acquired by the\nFLUSH TABLES WITH READ LOCK statement. The FLUSH TABLES WITH READ LOCK\nstatement is very useful for performing backups. See FLUSH for more\ninformation about FLUSH TABLES WITH READ LOCK.\n\nURL: https://mariadb.com/kb/en/transactions-unlock-tables/','','https://mariadb.com/kb/en/transactions-unlock-tables/'),(103,'XA Transactions',8,'Overview\n--------\n\nThe MariaDB XA implementation is based on the X/Open CAE document Distributed\nTransaction Processing: The XA Specification. This document is published by\nThe Open Group and available at\nhttp://www.opengroup.org/public/pubs/catalog/c193.htm.\n\nXA transactions are designed to allow distributed transactions, where a\ntransaction manager (the application) controls a transaction which involves\nmultiple resources. Such resources are usually DBMSs, but could be resources\nof any type. The whole set of required transactional operations is called a\nglobal transaction. Each subset of operations which involve a single resource\nis called a local transaction. XA used a 2-phases commit (2PC). With the first\ncommit, the transaction manager tells each resource to prepare an effective\ncommit, and waits for a confirm message. The changes are not still made\neffective at this point. If any of the resources encountered an error, the\ntransaction manager will rollback the global transaction. If all resources\ncommunicate that the first commit is successful, the transaction manager can\nrequire a second commit, which makes the changes effective.\n\nIn MariaDB, XA transactions can only be used with storage engines that support\nthem. At least InnoDB, TokuDB, SPIDER and MyRocks support them. For InnoDB,\nuntil MariaDB 10.2, XA transactions can be disabled by setting the\ninnodb_support_xa server system variable to 0. From MariaDB 10.3, XA\ntransactions are always supported.\n\nLike regular transactions, XA transactions create metadata locks on accessed\ntables.\n\nXA transactions require REPEATABLE READ as a minimum isolation level. However,\ndistributed transactions should always use SERIALIZABLE.\n\nTrying to start more than one XA transaction at the same time produces a 1400\nerror (SQLSTATE \'XAE09\'). The same error is produced when attempting to start\nan XA transaction while a regular transaction is in effect. Trying to start a\nregular transaction while an XA transaction is in effect produces a 1399 error\n(SQLSTATE \'XAE07\').\n\nThe statements that cause an implicit COMMIT for regular transactions produce\na 1400 error (SQLSTATE \'XAE09\') if a XA transaction is in effect.\n\nInternal XA vs External XA\n--------------------------\n\nXA transactions are an overloaded term in MariaDB. If a storage engine is\nXA-capable, it can mean one or both of these:\n\n* It supports MariaDB\'s internal two-phase commit API. This is transparent to\nthe user. Sometimes this is called \"internal XA\", since MariaDB\'s internal\ntransaction coordinator log can handle coordinating these transactions.\n\n* It supports XA transactions, with the XA START, XA PREPARE, XA COMMIT, etc.\nstatements. Sometimes this is called \"external XA\", since it requires the use\nof an external transaction coordinator to use this feature properly.\n\nTransaction Coordinator Log\n---------------------------\n\nIf you have two or more XA-capable storage engines enabled, then a transaction\ncoordinator log must be available.\n\nThere are currently two implementations of the transaction coordinator log:\n\n* Binary log-based transaction coordinator log\n* Memory-mapped file-based transaction coordinator log\n\nIf the binary log is enabled on a server, then the server will use the binary\nlog-based transaction coordinator log. Otherwise, it will use the\nmemory-mapped file-based transaction coordinator log.\n\nSee Transaction Coordinator Log for more information.\n\nSyntax\n------\n\nXA {START|BEGIN} xid [JOIN|RESUME]\n\nXA END xid [SUSPEND [FOR MIGRATE]]\n\nXA PREPARE xid\n\nXA COMMIT xid [ONE PHASE]\n\nXA ROLLBACK xid\n\nXA RECOVER [FORMAT=[\'RAW\'|\'SQL\']]\n\nxid: gtrid [, bqual [, formatID ]]\n\nThe interface to XA transactions is a set of SQL statements starting with XA.\nEach statement changes a transaction\'s state, determining which actions it can\nperform. A transaction which does not exist is in the NON-EXISTING state.\n\nXA START (or BEGIN) starts a transaction and defines its xid (a transaction\nidentifier). The JOIN or RESUME keywords have no effect. The new transaction\nwill be in ACTIVE state.\n\nThe xid can have 3 components, though only the first one is mandatory. gtrid\nis a quoted string representing a global transaction identifier. bqual is a\nquoted string representing a local transaction identifier. formatID is an\nunsigned integer indicating the format used for the first two components; if\nnot specified, defaults to 1. MariaDB does not interpret in any way these\ncomponents, and only uses them to identify a transaction. xids of transactions\nin effect must be unique.\n\nXA END declares that the specified ACTIVE transaction is finished and it\nchanges its state to IDLE. SUSPEND [FOR MIGRATE] has no effect.\n\nXA PREPARE prepares an IDLE transaction for commit, changing its state to\nPREPARED. This is the first commit.\n\nXA COMMIT definitely commits and terminates a transaction which has already\nbeen PREPARED. If the ONE PHASE clause is specified, this statements performs\na 1-phase commit on an IDLE transaction.\n\nXA ROLLBACK rolls back and terminates an IDLE or PREPARED transaction.\n\nXA RECOVER shows information about all PREPARED transactions.\n\nWhen trying to execute an operation which is not allowed for the transaction\'s\ncurrent state, an error is produced:\n\nXA COMMIT \'test\' ONE PHASE;\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  ACTIVE state\n\nXA COMMIT \'test2\';\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  NON-EXISTING state\n\nXA RECOVER\n----------\n\nThe XA RECOVER statement shows information about all transactions which are in\nthe PREPARED state. It does not matter which connection created the\ntransaction: if it has been PREPARED, it appears. But this does not mean that\na connection can commit or rollback a transaction which was started by another\nconnection. Note that transactions using a 1-phase commit are never in the\nPREPARED state, so they cannot be shown by XA RECOVER.\n\nXA RECOVER produces four columns:\n\nXA RECOVER;\n+----------+--------------+--------------+------+\n| formatID | gtrid_length | bqual_length | data |\n+----------+--------------+--------------+------+\n|        1 |            4 |            0 | test |\n+----------+--------------+--------------+------+\n\nMariaDB starting with 10.3.3\n----------------------------\nYou can use XA RECOVER FORMAT=\'SQL\' to get the data in a human readable form\nthat can be directly copy-pasted into XA COMMIT or XA ROLLBACK. This is\nparticularly useful for binary xid generated by some transaction coordinators.\n\nformatID is the formatID part of xid.\n\ndata are the gtrid and bqual parts of xid, concatenated.\n\ngtrid_length and bqual_length are the lengths of gtrid and bqual, respectevely.\n\nExamples\n--------\n\n2-phases commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA PREPARE \'test\';\n\nXA COMMIT \'test\';\n\n1-phase commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA COMMIT \'test\' ONE PHASE;\n\nHuman-readable:\n\nxa start \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\ninsert t1 values (40);\n\nxa end \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa prepare \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa recover format=\'RAW\';\n+----------+--------------+--------------+--------------------+\n| formatID | gtrid_length | bqual_length | data               |\n+----------+--------------+--------------+--------------------+\n34      67v78abc       11 |            7 | 12\ndef |\n+----------+--------------+--------------+--------------------+\n\nxa recover format=\'SQL\';\n+----------+--------------+--------------+-------------------------------------\n---------+\n| formatID | gtrid_length | bqual_length | data                               \n     |\n+----------+--------------+--------------+-------------------------------------\n---------+\n|        3 |           11 |            7 |\nX\'31320d3334093637763738\',X\'6162630a646566\',3 |\n+----------+--------------+--------------+-------------------------------------\n---------+\n\nxa rollback X\'31320d3334093637763738\',X\'6162630a646566\',3;\n\nKnown Issues\n------------\n\nMariaDB Galera Cluster\n----------------------\n\nMariaDB Galera Cluster does not support XA transactions.\n\nHowever, MariaDB Galera Cluster builds include a built-in plugin called wsrep.\nPrior to MariaDB 10.4.3, this plugin was internally considered an XA-capable\nstorage engine. Consequently, these MariaDB Galera Cluster builds have\nmultiple XA-capable storage engines by default, even if the only \"real\"\nstorage engine that supports external XA transactions enabled on these builds\nby default is InnoDB. Therefore, when using one these builds MariaDB would be\nforced to use a transaction coordinator log by default, which could have\nperformance implications.\n\nSee Transaction Coordinator Log Overview: MariaDB Galera Cluster for more\ninformation.\n\nURL: https://mariadb.com/kb/en/xa-transactions/','','https://mariadb.com/kb/en/xa-transactions/'),(104,'CREATE USER',10,'Syntax\n------\n\nCREATE [OR REPLACE] USER [IF NOT EXISTS] \n user_specification [,user_specification ...] \n [REQUIRE {NONE | tls_option [[AND] tls_option ...] }]\n [WITH resource_option [resource_option ...] ]\n [lock_option] [password_option]\n\nuser_specification:\n username [authentication_option]\n\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule  ...]\n\nauthentication_rule:\n  authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\ntls_option:\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n\nlock_option:\n  ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n\nDescription\n-----------\n\nThe CREATE USER statement creates new MariaDB accounts. To use it, you must\nhave the global CREATE USER privilege or the INSERT privilege for the mysql\ndatabase. For each account, CREATE USER creates a new row in mysql.user (until\nMariaDB 10.3 this is a table, from MariaDB 10.4 it\'s a view) or\nmysql.global_priv_table (from MariaDB 10.4) that has no privileges.\n\nIf any of the specified accounts, or any permissions for the specified\naccounts, already exist, then the server returns ERROR 1396 (HY000). If an\nerror occurs, CREATE USER will still create the accounts that do not result in\nan error. Only one error is produced for all users which have not been created:\n\nERROR 1396 (HY000): \n Operation CREATE USER failed for \'u1\'@\'%\',\'u2\'@\'%\'\n\nCREATE USER, DROP USER, CREATE ROLE, and DROP ROLE all produce the same error\ncode when they fail.\n\nSee Account Names below for details on how account names are specified.\n\nOR REPLACE\n----------\n\nIf the optional OR REPLACE clause is used, it is basically a shortcut for:\n\nDROP USER IF EXISTS name;\nCREATE USER name ...;\n\nFor example:\n\nCREATE USER foo2@test IDENTIFIED BY \'password\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'foo2\'@\'test\'\n\nCREATE OR REPLACE USER foo2@test IDENTIFIED BY \'password\';\nQuery OK, 0 rows affected (0.00 sec)\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a warning instead\nof an error if the specified user already exists.\n\nFor example:\n\nCREATE USER foo2@test IDENTIFIED BY \'password\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'foo2\'@\'test\'\n\nCREATE USER IF NOT EXISTS foo2@test IDENTIFIED BY \'password\';\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+----------------------------------------------------+\n| Level | Code | Message                                            |\n+-------+------+----------------------------------------------------+\n| Note  | 1973 | Can\'t create user \'foo2\'@\'test\'; it already exists |\n+-------+------+----------------------------------------------------+\n\nAuthentication Options\n----------------------\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored in the\nmysql.user/mysql.global_priv_table table.\n\nFor example, if our password is mariadb, then we can create the user with:\n\nCREATE USER foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD function. It will be stored in the\nmysql.user/mysql.global_priv_table table as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n\nAnd then we can create a user with the hash:\n\nCREATE USER foo2@test IDENTIFIED BY PASSWORD\n\'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nCREATE USER foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nCREATE USER foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nMariaDB starting with 10.4.0\n----------------------------\nThe USING or AS keyword can also be used to provide a plain-text password to a\nplugin if it\'s provided as an argument to the PASSWORD() function. This is\nonly valid for authentication plugins that have implemented a hook for the\nPASSWORD() function. For example, the ed25519 authentication plugin supports\nthis:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nMariaDB starting with 10.4.3\n----------------------------\nOne can specify many authentication plugins, they all work as alternatives\nways of authenticating a user:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\') OR\nunix_socket;\n\nBy default, when you create a user without specifying an authentication\nplugin, MariaDB uses the mysql_native_password plugin.\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can create a user account that requires these TLS options\nwith the following:\n\nCREATE USER \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\'\n AND ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+--------------------------------------+--------------------------------------+\n| Limit Type                           | Decription                           |\n+--------------------------------------+--------------------------------------+\n| MAX_QUERIES_PER_HOUR                 | Number of statements that the        |\n|                                      | account can issue per hour           |\n|                                      | (including updates)                  |\n+--------------------------------------+--------------------------------------+\n| MAX_UPDATES_PER_HOUR                 | Number of updates (not queries)      |\n|                                      | that the account can issue per hour  |\n+--------------------------------------+--------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR             | Number of connections that the       |\n|                                      | account can start per hour           |\n+--------------------------------------+--------------------------------------+\n| MAX_USER_CONNECTIONS                 | Number of simultaneous connections   |\n|                                      | that can be accepted from the same   |\n|                                      | account; if it is 0,                 |\n|                                      | max_connections will be used         |\n|                                      | instead; if max_connections is 0,    |\n|                                      | there is no limit for this           |\n|                                      | account\'s simultaneous connections.  |\n+--------------------------------------+--------------------------------------+\n| MAX_STATEMENT_TIME                   | Timeout, in seconds, for statements  |\n|                                      | executed by the user. See also       |\n|                                      | Aborting Statements that Exceed a    |\n|                                      | Certain Time to Execute.             |\n+--------------------------------------+--------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nHere is an example showing how to create a user with resource limits:\n\nCREATE USER \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 10\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nAccount Names\n-------------\n\nAccount names have both a user name component and a host name component, and\nare specified as \'user_name\'@\'host_name\'.\n\nThe user name and host name may be unquoted, quoted as strings using double\nquotes (\") or single quotes (\'), or quoted as identifiers using backticks (`).\nYou must use quotes when using special characters (such as a hyphen) or\nwildcard characters. If you quote, you must quote the user name and host name\nseparately (for example \'user_name\'@\'host_name\').\n\nHost Name Component\n-------------------\n\nIf the host name is not provided, it is assumed to be \'%\'.\n\nHost names may contain the wildcard characters % and _. They are matched as if\nby the LIKE clause. If you need to use a wildcard character literally (for\nexample, to match a domain name with an underscore), prefix the character with\na backslash. See LIKE for more information on escaping wildcard characters.\n\nHost name matches are case-insensitive. Host names can match either domain\nnames or IP addresses. Use \'localhost\' as the host name to allow only local\nclient connections.\n\nYou can use a netmask to match a range of IP addresses using \'base_ip/netmask\'\nas the host name. A user with an IP address ip_addr will be allowed to connect\nif the following condition is true:\n\nip_addr & netmask = base_ip\n\nFor example, given a user:\n\nCREATE USER \'maria\'@\'247.150.130.0/255.255.255.0\';\n\nthe IP addresses satisfying this condition range from 247.150.130.0 to\n247.150.130.255.\n\nUsing 255.255.255.255 is equivalent to not using a netmask at all. Netmasks\ncannot be used for IPv6 addresses.\n\nNote that the credentials added when creating a user with the \'%\' wildcard\nhost will not grant access in all cases. For example, some systems come with\nan anonymous localhost user, and when connecting from localhost this will take\nprecedence.\n\nBefore MariaDB 10.6, the host name component could be up to 60 characters in\nlength. Starting from MariaDB 10.6, it can be up to 255 characters.\n\nUser Name Component\n-------------------\n\nUser names must match exactly, including case. A user name that is empty is\nknown as an anonymous account and is allowed to match a login attempt with any\nuser name component. These are described more in the next section.\n\nFor valid identifiers to use as user names, see Identifier Names.\n\nIt is possible for more than one account to match when a user connects.\nMariaDB selects the first matching account after sorting according to the\nfollowing criteria:\n\n* Accounts with an exact host name are sorted before accounts using a wildcard\nin the\nhost name. Host names using a netmask are considered to be exact for sorting.\n* Accounts with a wildcard in the host name are sorted according to the\nposition of\nthe first wildcard character. Those with a wildcard character later in the\nhost name\nsort before those with a wildcard character earlier in the host name.\n* Accounts with a non-empty user name sort before accounts with an empty user\nname.\n* Accounts with an empty user name are sorted last. As mentioned previously,\nthese are known as anonymous accounts. These are described more in the next\nsection.\n\nThe following table shows a list of example account as sorted by these\ncriteria:\n\n+---------+-------------+\n| User    | Host        |\n+---------+-------------+\n| joffrey | 192.168.0.3 |\n|         | 192.168.0.% |\n| joffrey | 192.168.%   |\n|         | 192.168.%   |\n+---------+-------------+\n\nOnce connected, you only have the privileges granted to the account that\nmatched, not all accounts that could have matched. For example, consider the\nfollowing commands:\n\nCREATE USER \'joffrey\'@\'192.168.0.3\';\nCREATE USER \'joffrey\'@\'%\';\nGRANT SELECT ON test.t1 to \'joffrey\'@\'192.168.0.3\';\nGRANT SELECT ON test.t2 to \'joffrey\'@\'%\';\n\nIf you connect as joffrey from 192.168.0.3, you will have the SELECT privilege\non the table test.t1, but not on the table test.t2. If you connect as joffrey\nfrom any other IP address, you will have the SELECT privilege on the table\ntest.t2, but not on the table test.t1.\n\nUsernames can be up to 80 characters long before 10.6 and starting from 10.6\nit can be 128 characters long.\n\nAnonymous Accounts\n------------------\n\nAnonymous accounts are accounts where the user name portion of the account\nname is empty. These accounts act as special catch-all accounts. If a user\nattempts to log into the system from a host, and an anonymous account exists\nwith a host name portion that matches the user\'s host, then the user will log\nin as the anonymous account if there is no more specific account match for the\nuser name that the user entered.\n\nFor example, here are some anonymous accounts:\n\nCREATE USER \'\'@\'localhost\';\nCREATE USER \'\'@\'192.168.0.3\';\n\nFixing a Legacy Default Anonymous Account\n-----------------------------------------\n\nOn some systems, the mysql.db table has some entries for the \'\'@\'%\' anonymous\naccount by default. Unfortunately, there is no matching entry in the\nmysql.user/mysql.global_priv_table table, which means that this anonymous\naccount doesn\'t exactly exist, but it does have privileges--usually on the\ndefault test database created by mysql_install_db. These account-less\nprivileges are a legacy that is leftover from a time when MySQL\'s privilege\nsystem was less advanced.\n\nThis situation means that you will run into errors if you try to create a\n\'\'@\'%\' account. For example:\n\nCREATE USER \'\'@\'%\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'\'@\'%\'\n\nThe fix is to DELETE the row in the mysql.db table and then execute FLUSH\nPRIVILEGES:\n\nDELETE FROM mysql.db WHERE User=\'\' AND Host=\'%\';\nFLUSH PRIVILEGES;\n\nAnd then the account can be created:\n\nCREATE USER \'\'@\'%\';\nQuery OK, 0 rows affected (0.01 sec)\n\nSee MDEV-13486 for more information.\n\nPassword Expiry\n---------------\n\nMariaDB starting with 10.4.3\n----------------------------\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal setting, for example:\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\n\nSee User Password Expiry for more details.\n\nAccount Locking\n---------------\n\nMariaDB starting with 10.4.2\n----------------------------\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected). For example:\n\nCREATE USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nSee Account Locking for more details.\n\nFrom MariaDB 10.4.7 and MariaDB 10.5.8, the lock_option and password_option\nclauses can occur in either order.\n\nURL: https://mariadb.com/kb/en/create-user/','','https://mariadb.com/kb/en/create-user/'),(105,'ALTER USER',10,'Syntax\n------\n\nALTER USER [IF EXISTS] \n user_specification [,user_specification] ...\n [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n [WITH resource_option [resource_option] ...]\n [lock_option] [password_option]\n\nuser_specification:\n username [authentication_option]\n\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule] ...\n\nauthentication_rule:\n authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\ntls_option\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nresource_option\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n\nlock_option:\n  ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n\nDescription\n-----------\n\nThe ALTER USER statement modifies existing MariaDB accounts. To use it, you\nmust have the global CREATE USER privilege or the UPDATE privilege for the\nmysql database. The global SUPER privilege is also required if the read_only\nsystem variable is enabled.\n\nIf any of the specified user accounts do not yet exist, an error results. If\nan error occurs, ALTER USER will still modify the accounts that do not result\nin an error. Only one error is produced for all users which have not been\nmodified.\n\nIF EXISTS\n---------\n\nWhen the IF EXISTS clause is used, MariaDB will return a warning instead of an\nerror for each specified user that does not exist.\n\nAccount Names\n-------------\n\nFor ALTER USER statements, account names are specified as the username\nargument in the same way as they are for CREATE USER statements. See account\nnames from the CREATE USER page for details on how account names are specified.\n\nCURRENT_USER or CURRENT_USER() can also be used to alter the account logged\ninto the current session. For example, to change the current user\'s password\nto mariadb:\n\nALTER USER CURRENT_USER() IDENTIFIED BY \'mariadb\';\n\nAuthentication Options\n----------------------\n\nMariaDB starting with 10.4\n--------------------------\nFrom MariaDB 10.4, it is possible to use more than one authentication plugin\nfor each user account. For example, this can be useful to slowly migrate users\nto the more secure ed25519 authentication plugin over time, while allowing the\nold mysql_native_password authentication plugin as an alternative for the\ntransitional period. See Authentication from MariaDB 10.4 for more.\n\nWhen running ALTER USER, not specifying an authentication option in the\nIDENTIFIED VIA clause will remove that authentication method. (However this\nwas not the case before MariaDB 10.4.13, see MDEV-21928)\n\nFor example, a user is created with the ability to authenticate via both a\npassword and unix_socket:\n\nCREATE USER \'bob\'@\'localhost\' \n IDENTIFIED VIA mysql_native_password USING PASSWORD(\'pwd\')\n OR unix_socket;\n\nSHOW CREATE USER \'bob\'@\'localhost\'\\G\n*************************** 1. row ***************************\nCREATE USER for bob@localhost: CREATE USER `bob`@`localhost` \n IDENTIFIED VIA mysql_native_password\n USING \'*975B2CD4FF9AE554FE8AD33168FBFC326D2021DD\'\n OR unix_socket\n\nIf the user\'s password is updated, but unix_socket authentication is not\nspecified in the IDENTIFIED VIA clause, unix_socket authentication will no\nlonger be permitted.\n\nALTER USER \'bob\'@\'localhost\' IDENTIFIED VIA mysql_native_password \n USING PASSWORD(\'pwd2\');\n\nSHOW CREATE USER \'bob\'@\'localhost\'\\G\n*************************** 1. row ***************************\nCREATE USER for bob@localhost: CREATE USER `bob`@`localhost` \n IDENTIFIED BY PASSWORD \'*38366FDA01695B6A5A9DD4E428D9FB8F7EB75512\'\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored to the mysql.user table.\n\nFor example, if our password is mariadb, then we can set the account\'s\npassword with:\n\nALTER USER foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD#function. It will be stored to the\nmysql.user table as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n\nAnd then we can set an account\'s password with the hash:\n\nALTER USER foo2@test \n IDENTIFIED BY PASSWORD \'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nALTER USER foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nALTER USER foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nIn MariaDB 10.4 and later, the USING or AS keyword can also be used to provide\na plain-text password to a plugin if it\'s provided as an argument to the\nPASSWORD() function. This is only valid for authentication plugins that have\nimplemented a hook for the PASSWORD() function. For example, the ed25519\nauthentication plugin supports this:\n\nALTER USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can alter a user account to require these TLS options with\nthe following:\n\nALTER USER \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\' AND\n ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+------------------------------------+---------------------------------------+\n| Limit Type                         | Description                           |\n+------------------------------------+---------------------------------------+\n| MAX_QUERIES_PER_HOUR               | Number of statements that the         |\n|                                    | account can issue per hour            |\n|                                    | (including updates)                   |\n+------------------------------------+---------------------------------------+\n| MAX_UPDATES_PER_HOUR               | Number of updates (not queries) that  |\n|                                    | the account can issue per hour        |\n+------------------------------------+---------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR           | Number of connections that the        |\n|                                    | account can start per hour            |\n+------------------------------------+---------------------------------------+\n| MAX_USER_CONNECTIONS               | Number of simultaneous connections    |\n|                                    | that can be accepted from the same    |\n|                                    | account; if it is 0, max_connections  |\n|                                    | will be used instead; if              |\n|                                    | max_connections is 0, there is no     |\n|                                    | limit for this account\'s              |\n|                                    | simultaneous connections.             |\n+------------------------------------+---------------------------------------+\n| MAX_STATEMENT_TIME                 | Timeout, in seconds, for statements   |\n|                                    | executed by the user. See also        |\n|                                    | Aborting Statements that Exceed a     |\n|                                    | Certain Time to Execute.              |\n+------------------------------------+---------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nHere is an example showing how to set an account\'s resource limits:\n\nALTER USER \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 10\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nPassword Expiry\n---------------\n\nMariaDB starting with 10.4.3\n----------------------------\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal setting, for example:\n\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE NEVER;\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n\nSee User Password Expiry for more details.\n\nAccount Locking\n---------------\n\nMariaDB starting with 10.4.2\n----------------------------\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected). For example:\n\nALTER USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nSee Account Locking for more details.\n\nFrom MariaDB 10.4.7 and MariaDB 10.5.8, the lock_option and password_option\nclauses can occur in either order.\n\nURL: https://mariadb.com/kb/en/alter-user/','','https://mariadb.com/kb/en/alter-user/'),(107,'GRANT',10,'Syntax\n------\n\nGRANT\n  priv_type [(column_list)]\n   [, priv_type [(column_list)]] ...\n  ON [object_type] priv_level\n  TO user_specification [ user_options ...]\n\nuser_specification:\n username [authentication_option]\n | PUBLIC\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule  ...]\n\nauthentication_rule:\n  authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\nGRANT PROXY ON username\n  TO user_specification [, user_specification ...]\n  [WITH GRANT OPTION]\n\nGRANT rolename TO grantee [, grantee ...]\n  [WITH ADMIN OPTION]\n\ngrantee:\n  rolename\n  username [authentication_option]\n\nuser_options:\n  [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n  [WITH with_option [with_option] ...]\n\nobject_type:\n  TABLE\n | FUNCTION\n | PROCEDURE\n | PACKAGE\n\npriv_level:\n  *\n | *.*\n | db_name.*\n | db_name.tbl_name\n | tbl_name\n | db_name.routine_name\n\nwith_option:\n  GRANT OPTION\n | resource_option\n\nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\ntls_option:\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nDescription\n-----------\n\nThe GRANT statement allows you to grant privileges or roles to accounts. To\nuse GRANT, you must have the GRANT OPTION privilege, and you must have the\nprivileges that you are granting.\n\nUse the REVOKE statement to revoke privileges granted with the GRANT statement.\n\nUse the SHOW GRANTS statement to determine what privileges an account has.\n\nAccount Names\n-------------\n\nFor GRANT statements, account names are specified as the username argument in\nthe same way as they are for CREATE USER statements. See account names from\nthe CREATE USER page for details on how account names are specified.\n\nImplicit Account Creation\n-------------------------\n\nThe GRANT statement also allows you to implicitly create accounts in some\ncases.\n\nIf the account does not yet exist, then GRANT can implicitly create it. To\nimplicitly create an account with GRANT, a user is required to have the same\nprivileges that would be required to explicitly create the account with the\nCREATE USER statement.\n\nIf the NO_AUTO_CREATE_USER SQL_MODE is set, then accounts can only be created\nif authentication information is specified, or with a CREATE USER statement.\nIf no authentication information is provided, GRANT will produce an error when\nthe specified account does not exist, for example:\n\nshow variables like \'%sql_mode%\' ;\n+---------------+--------------------------------------------+\n| Variable_name | Value                                      |\n+---------------+--------------------------------------------+\n| sql_mode      | NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION |\n+---------------+--------------------------------------------+\n\nGRANT USAGE ON *.* TO \'user123\'@\'%\' IDENTIFIED BY \'\';\nERROR 1133 (28000): Can\'t find any matching row in the user table\n\nGRANT USAGE ON *.* TO \'user123\'@\'%\' \n IDENTIFIED VIA PAM using \'mariadb\' require ssl ;\nQuery OK, 0 rows affected (0.00 sec)\n\nselect host, user from mysql.user where user=\'user123\' ;\n\n+------+----------+\n| host | user     |\n+------+----------+\n| %    | user123 |\n+------+----------+\n\nPrivilege Levels\n----------------\n\nPrivileges can be set globally, for an entire database, for a table or\nroutine, or for individual columns in a table. Certain privileges can only be\nset at certain levels.\n\n* Global privileges priv_type are granted using *.* for\npriv_level. Global privileges include privileges to administer the database\nand manage user accounts, as well as privileges for all tables, functions, and\nprocedures. Global privileges are stored in the mysql.user table prior to\nMariaDB 10.4, and in  mysql.global_priv table afterwards.\n* Database privileges priv_type are granted using db_name.*\nfor priv_level, or using just * to use default database. Database\nprivileges include privileges to create tables and functions, as well as\nprivileges for all tables, functions, and procedures in the database. Database\nprivileges are stored in the mysql.db table.\n* Table privileges priv_type are granted using db_name.tbl_name\nfor priv_level, or using just tbl_name to specify a table in the default\ndatabase. The TABLE keyword is optional. Table privileges include the\nability to select and change data in the table. Certain table privileges can\nbe granted for individual columns.\n* Column privileges priv_type are granted by specifying a table for\npriv_level and providing a column list after the privilege type. They allow\nyou to control exactly which columns in a table users can select and change.\n* Function privileges priv_type are granted using FUNCTION db_name.routine_name\nfor priv_level, or using just  FUNCTION routine_name to specify a function\nin the default database.\n* Procedure privileges priv_type are granted using PROCEDURE\ndb_name.routine_name\nfor priv_level, or using just PROCEDURE routine_name to specify a procedure\nin the default database.\n\nThe USAGE Privilege\n-------------------\n\nThe USAGE privilege grants no real privileges. The SHOW GRANTS statement will\nshow a global USAGE privilege for a newly-created user. You can use USAGE with\nthe GRANT statement to change options like GRANT OPTION and\nMAX_USER_CONNECTIONS without changing any account privileges.\n\nThe ALL PRIVILEGES Privilege\n----------------------------\n\nThe ALL PRIVILEGES privilege grants all available privileges. Granting all\nprivileges only affects the given privilege level. For example, granting all\nprivileges on a table does not grant any privileges on the database or\nglobally.\n\nUsing ALL PRIVILEGES does not grant the special GRANT OPTION privilege.\n\nYou can use ALL instead of ALL PRIVILEGES.\n\nThe GRANT OPTION Privilege\n--------------------------\n\nUse the WITH GRANT OPTION clause to give users the ability to grant privileges\nto other users at the given privilege level. Users with the GRANT OPTION\nprivilege can only grant privileges they have. They cannot grant privileges at\na higher privilege level than they have the GRANT OPTION privilege.\n\nThe GRANT OPTION privilege cannot be set for individual columns. If you use\nWITH GRANT OPTION when specifying column privileges, the GRANT OPTION\nprivilege will be granted for the entire table.\n\nUsing the WITH GRANT OPTION clause is equivalent to listing GRANT OPTION as a\nprivilege.\n\nGlobal Privileges\n-----------------\n\nThe following table lists the privileges that can be granted globally. You can\nalso grant all database, table, and function privileges globally. When granted\nglobally, these privileges apply to all databases, tables, or functions,\nincluding those created later.\n\nTo set a global privilege, use *.* for priv_level.\n\nBINLOG ADMIN\n------------\n\nEnables administration of the binary log, including the PURGE BINARY LOGS\nstatement and setting the system variables:\n\n* binlog_annotate_row_events\n* binlog_cache_size\n* binlog_commit_wait_count\n* binlog_commit_wait_usec\n* binlog_direct_non_transactional_updates\n* binlog_expire_logs_seconds\n* binlog_file_cache_size\n* binlog_format\n* binlog_row_image\n* binlog_row_metadata\n* binlog_stmt_cache_size\n* expire_logs_days\n* log_bin_compress\n* log_bin_compress_min_len\n* log_bin_trust_function_creators\n* max_binlog_cache_size\n* max_binlog_size\n* max_binlog_stmt_cache_size\n* sql_log_bin and\n* sync_binlog.\n\nAdded in MariaDB 10.5.2.\n\nBINLOG MONITOR\n--------------\n\nNew name for REPLICATION CLIENT from MariaDB 10.5.2, (REPLICATION CLIENT still\nsupported as an alias for compatibility purposes). Permits running SHOW\ncommands related to the binary log, in particular the SHOW BINLOG STATUS and\nSHOW BINARY LOGS statements. Unlike REPLICATION CLIENT prior to MariaDB 10.5,\nSHOW REPLICA STATUS isn\'t included in this privilege, and REPLICA MONITOR is\nrequired.\n\nBINLOG REPLAY\n-------------\n\nEnables replaying the binary log with the BINLOG statement (generated by\nmariadb-binlog), executing SET timestamp when secure_timestamp is set to\nreplication, and setting the session values of system variables usually\nincluded in BINLOG output, in particular:\n\n* gtid_domain_id\n* gtid_seq_no\n* pseudo_thread_id\n* server_id.\n\nAdded in MariaDB 10.5.2\n\nCONNECTION ADMIN\n----------------\n\nEnables administering connection resource limit options. This includes\nignoring the limits specified by:\n\n* max_connections\n* max_user_connections and\n* max_password_errors.\n\nThe statements specified in init_connect are not executed, killing connections\nand queries owned by other users is permitted. The following\nconnection-related system variables can be changed:\n\n* connect_timeout\n* disconnect_on_expired_password\n* extra_max_connections\n* init_connect\n* max_connections\n* max_connect_errors\n* max_password_errors\n* proxy_protocol_networks\n* secure_auth\n* slow_launch_time\n* thread_pool_exact_stats\n* thread_pool_dedicated_listener\n* thread_pool_idle_timeout\n* thread_pool_max_threads\n* thread_pool_min_threads\n* thread_pool_oversubscribe\n* thread_pool_prio_kickup_timer\n* thread_pool_priority\n* thread_pool_size, and\n* thread_pool_stall_limit.\n\nAdded in MariaDB 10.5.2.\n\nCREATE USER\n-----------\n\nCreate a user using the CREATE USER statement, or implicitly create a user\nwith the GRANT statement.\n\nFEDERATED ADMIN\n---------------\n\nExecute CREATE SERVER, ALTER SERVER, and DROP SERVER statements. Added in\nMariaDB 10.5.2.\n\nFILE\n----\n\nRead and write files on the server, using statements like LOAD DATA INFILE or\nfunctions like LOAD_FILE(). Also needed to create CONNECT outward tables.\nMariaDB server must have the permissions to access those files.\n\nGRANT OPTION\n------------\n\nGrant global privileges. You can only grant privileges that you have.\n\nPROCESS\n-------\n\nShow information about the active processes, for example via SHOW PROCESSLIST\nor mysqladmin processlist. If you have the PROCESS privilege, you can see all\nthreads. Otherwise, you can see only your own threads (that is, threads\nassociated with the MariaDB account that you are using).\n\nREAD_ONLY ADMIN\n---------------\n\nUser can set the read_only system variable and allows the user to perform\nwrite operations, even when the read_only option is active. Added in MariaDB\n10.5.2.\n\nFrom MariaDB 10.11.0, the READ_ONLY ADMIN privilege has been removed from\nSUPER. The benefit of this is that one can remove the READ_ONLY ADMIN\nprivilege from all users and ensure that no one can make any changes on any\nnon-temporary tables. This is useful on replicas when one wants to ensure that\nthe replica is kept identical to the primary.\n\nRELOAD\n------\n\nExecute FLUSH statements or equivalent mariadb-admin/mysqladmin commands.\n\nREPLICATION CLIENT\n------------------\n\nExecute SHOW MASTER STATUS and SHOW BINARY LOGS informative statements.\nRenamed to BINLOG MONITOR in MariaDB 10.5.2 (but still supported as an alias\nfor compatibility reasons). SHOW SLAVE STATUS was part of REPLICATION CLIENT\nprior to MariaDB 10.5.\n\nREPLICATION MASTER ADMIN\n------------------------\n\nPermits administration of primary servers, including the SHOW REPLICA HOSTS\nstatement, and setting the gtid_binlog_state, gtid_domain_id,\nmaster_verify_checksum and server_id system variables. Added in MariaDB 10.5.2.\n\nREPLICA MONITOR\n---------------\n\nPermit SHOW REPLICA STATUS and SHOW RELAYLOG EVENTS. From MariaDB 10.5.9.\n\nWhen a user would upgrade from an older major release to a MariaDB 10.5 minor\nrelease prior to MariaDB 10.5.9, certain user accounts would lose\ncapabilities. For example, a user account that had the REPLICATION CLIENT\nprivilege in older major releases could run SHOW REPLICA STATUS, but after\nupgrading to a MariaDB 10.5 minor release prior to MariaDB 10.5.9, they could\nno longer run SHOW REPLICA STATUS, because that statement was changed to\nrequire the REPLICATION REPLICA ADMIN privilege.\n\nThis issue is fixed in MariaDB 10.5.9 with this new privilege, which now\ngrants the user the ability to execute SHOW [ALL] (SLAVE | REPLICA) STATUS.\n\nWhen a database is upgraded from an older major release to MariaDB Server\n10.5.9 or later, any user accounts with the REPLICATION CLIENT or REPLICATION\nSLAVE privileges will automatically be granted the new REPLICA MONITOR\nprivilege. The privilege fix occurs when the server is started up, not when\nmariadb-upgrade is performed.\n\nHowever, when a database is upgraded from an early 10.5 minor release to\n10.5.9 and later, the user will have to fix any user account privileges\nmanually.\n\nREPLICATION REPLICA\n-------------------\n\nSynonym for REPLICATION SLAVE. From MariaDB 10.5.1.\n\nREPLICATION SLAVE\n-----------------\n\nAccounts used by replica servers on the primary need this privilege. This is\nneeded to get the updates made on the master. From MariaDB 10.5.1, REPLICATION\nREPLICA is an alias for REPLICATION SLAVE.\n\nREPLICATION SLAVE ADMIN\n-----------------------\n\nPermits administering replica servers, including START REPLICA/SLAVE, STOP\nREPLICA/SLAVE, CHANGE MASTER, SHOW REPLICA/SLAVE STATUS, SHOW RELAYLOG EVENTS\nstatements, replaying the binary log with the BINLOG statement (generated by\nmariadb-binlog), and setting the system variables:\n\n* gtid_cleanup_batch_size\n* gtid_ignore_duplicates\n* gtid_pos_auto_engines\n* gtid_slave_pos\n* gtid_strict_mode\n* init_slave\n* read_binlog_speed_limit\n* relay_log_purge\n* relay_log_recovery\n* replicate_do_db\n* replicate_do_table\n* replicate_events_marked_for_skip\n* replicate_ignore_db\n* replicate_ignore_table\n* replicate_wild_do_table\n* replicate_wild_ignore_table\n* slave_compressed_protocol\n* slave_ddl_exec_mode\n* slave_domain_parallel_threads\n* slave_exec_mode\n* slave_max_allowed_packet\n* slave_net_timeout\n* slave_parallel_max_queued\n* slave_parallel_mode\n* slave_parallel_threads\n* slave_parallel_workers\n* slave_run_triggers_for_rbr\n* slave_sql_verify_checksum\n* slave_transaction_retry_interval\n* slave_type_conversions\n* sync_master_info\n* sync_relay_log, and\n* sync_relay_log_info.\n\nAdded in MariaDB 10.5.2.\n\nSET USER\n--------\n\nEnables setting the DEFINER when creating triggers, views, stored functions\nand stored procedures. Added in MariaDB 10.5.2.\n\nSHOW DATABASES\n--------------\n\nList all databases using the SHOW DATABASES statement. Without the SHOW\nDATABASES privilege, you can still issue the SHOW DATABASES statement, but it\nwill only list databases containing tables on which you have privileges.\n\nSHUTDOWN\n--------\n\nShut down the server using SHUTDOWN or the mysqladmin shutdown command.\n\nSUPER\n-----\n\nExecute superuser statements: CHANGE MASTER TO, KILL (users who do not have\nthis privilege can only KILL their own threads), PURGE LOGS, SET global system\nvariables, or the mysqladmin debug command. Also, this permission allows the\nuser to write data even if the read_only startup option is set, enable or\ndisable logging, enable or disable replication on replica, specify a DEFINER\nfor statements that support that clause, connect once reaching the\nMAX_CONNECTIONS. If a statement has been specified for the init-connect mysqld\noption, that command will not be executed when a user with SUPER privileges\nconnects to the server.\n\nThe SUPER privilege has been split into multiple smaller privileges from\nMariaDB 10.5.2 to allow for more fine-grained privileges, although it remains\nan alias for these smaller privileges.\n\nFrom MariaDB 10.11.0, the READ_ONLY ADMIN privilege has been removed from\nSUPER. The benefit of this is that one can remove the READ_ONLY ADMIN\nprivilege from all users and ensure that no one can make any changes on any\nnon-temporary tables. This is useful on replicas when one wants to ensure that\nthe replica is kept identical to the primary.\n\nDatabase Privileges\n-------------------\n\nThe following table lists the privileges that can be granted at the database\nlevel. You can also grant all table and function privileges at the database\nlevel. Table and function privileges on a database apply to all tables or\nfunctions in that database, including those created later.\n\nTo set a privilege for a database, specify the database using db_name.* for\npriv_level, or just use * to specify the default database.\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| CREATE                           | Create a database using the CREATE      |\n|                                  | DATABASE statement, when the privilege  |\n|                                  | is granted for a database. You can      |\n|                                  | grant the CREATE privilege on           |\n|                                  | databases that do not yet exist. This   |\n|                                  | also grants the CREATE privilege on     |\n|                                  | all tables in the database.             |\n+----------------------------------+-----------------------------------------+\n| CREATE ROUTINE                   | Create Stored Programs using the        |\n|                                  | CREATE PROCEDURE and CREATE FUNCTION    |\n|                                  | statements.                             |\n+----------------------------------+-----------------------------------------+\n| CREATE TEMPORARY TABLES          | Create temporary tables with the        |\n|                                  | CREATE TEMPORARY TABLE statement. This  |\n|                                  | privilege enable writing and dropping   |\n|                                  | those temporary tables                  |\n+----------------------------------+-----------------------------------------+\n| DROP                             | Drop a database using the DROP          |\n|                                  | DATABASE statement, when the privilege  |\n|                                  | is granted for a database. This also    |\n|                                  | grants the DROP privilege on all        |\n|                                  | tables in the database.                 |\n+----------------------------------+-----------------------------------------+\n| EVENT                            | Create, drop and alter EVENTs.          |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant database privileges. You can      |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n| LOCK TABLES                      | Acquire explicit locks using the LOCK   |\n|                                  | TABLES statement; you also need to      |\n|                                  | have the SELECT privilege on a table,   |\n|                                  | in order to lock it.                    |\n+----------------------------------+-----------------------------------------+\n\nTable Privileges\n----------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER                            | Change the structure of an existing     |\n|                                  | table using the ALTER TABLE statement.  |\n+----------------------------------+-----------------------------------------+\n| CREATE                           | Create a table using the CREATE TABLE   |\n|                                  | statement.  You can grant the CREATE    |\n|                                  | privilege on tables that do not yet     |\n|                                  | exist.                                  |\n+----------------------------------+-----------------------------------------+\n| CREATE VIEW                      | Create a view using the CREATE_VIEW     |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| DELETE                           | Remove rows from a table using the      |\n|                                  | DELETE statement.                       |\n+----------------------------------+-----------------------------------------+\n| DELETE HISTORY                   | Remove historical rows from a table     |\n|                                  | using the DELETE HISTORY statement.     |\n|                                  | Displays as DELETE VERSIONING ROWS      |\n|                                  | when running SHOW GRANTS until MariaDB  |\n|                                  | 10.3.15 and until MariaDB 10.4.5        |\n|                                  | (MDEV-17655), or when running SHOW      |\n|                                  | PRIVILEGES until MariaDB 10.5.2,        |\n|                                  | MariaDB 10.4.13 and MariaDB 10.3.23     |\n|                                  | (MDEV-20382). From MariaDB 10.3.4.      |\n|                                  | From MariaDB 10.3.5, if a user has the  |\n|                                  | SUPER privilege but not this            |\n|                                  | privilege, running mysql_upgrade will   |\n|                                  | grant this privilege as well.           |\n+----------------------------------+-----------------------------------------+\n| DROP                             | Drop a table using the DROP TABLE       |\n|                                  | statement or a view using the DROP      |\n|                                  | VIEW statement. Also required to        |\n|                                  | execute the TRUNCATE TABLE statement.   |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant table privileges. You can only    |\n|                                  | grant privileges that you have.         |\n+----------------------------------+-----------------------------------------+\n| INDEX                            | Create an index on a table using the    |\n|                                  | CREATE INDEX statement. Without the     |\n|                                  | INDEX privilege, you can still create   |\n|                                  | indexes when creating a table using     |\n|                                  | the CREATE TABLE statement if the you   |\n|                                  | have the CREATE privilege, and you can  |\n|                                  | create indexes using the ALTER TABLE    |\n|                                  | statement if you have the ALTER         |\n|                                  | privilege.                              |\n+----------------------------------+-----------------------------------------+\n| INSERT                           | Add rows to a table using the INSERT    |\n|                                  | statement.  The INSERT privilege can    |\n|                                  | also be set on individual columns; see  |\n|                                  | Column Privileges below for details.    |\n+----------------------------------+-----------------------------------------+\n| REFERENCES                       | Unused.                                 |\n+----------------------------------+-----------------------------------------+\n| SELECT                           | Read data from a table using the        |\n|                                  | SELECT statement. The SELECT privilege  |\n|                                  | can also be set on individual columns;  |\n|                                  | see Column Privileges below for         |\n|                                  | details.                                |\n+----------------------------------+-----------------------------------------+\n| SHOW VIEW                        | Show the CREATE VIEW statement to       |\n|                                  | create a view using the SHOW CREATE     |\n|                                  | VIEW statement.                         |\n+----------------------------------+-----------------------------------------+\n| TRIGGER                          | Execute triggers associated to tables   |\n|                                  | you update, execute the CREATE TRIGGER  |\n|                                  | and DROP TRIGGER statements. You will   |\n|                                  | still be able to see triggers.          |\n+----------------------------------+-----------------------------------------+\n| UPDATE                           | Update existing rows in a table using   |\n|                                  | the UPDATE statement. UPDATE            |\n|                                  | statements usually include a WHERE      |\n|                                  | clause to update only certain rows.     |\n|                                  | You must have SELECT privileges on the  |\n|                                  | table or the appropriate columns for    |\n|                                  | the WHERE clause. The UPDATE privilege  |\n|                                  | can also be set on individual columns;  |\n|                                  | see Column Privileges below for         |\n|                                  | details.                                |\n+----------------------------------+-----------------------------------------+\n\nColumn Privileges\n-----------------\n\nSome table privileges can be set for individual columns of a table. To use\ncolumn privileges, specify the table explicitly and provide a list of column\nnames after the privilege type. For example, the following statement would\nallow the user to read the names and positions of employees, but not other\ninformation from the same table, such as salaries.\n\nGRANT SELECT (name, position) on Employee to \'jeffrey\'@\'localhost\';\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| INSERT (column_list)             | Add rows specifying values in columns   |\n|                                  | using the INSERT statement. If you      |\n|                                  | only have column-level INSERT           |\n|                                  | privileges, you must specify the        |\n|                                  | columns you are setting in the INSERT   |\n|                                  | statement. All other columns will be    |\n|                                  | set to their default values, or NULL.   |\n+----------------------------------+-----------------------------------------+\n| REFERENCES (column_list)         | Unused.                                 |\n+----------------------------------+-----------------------------------------+\n| SELECT (column_list)             | Read values in columns using the        |\n|                                  | SELECT statement. You cannot access or  |\n|                                  | query any columns for which you do not  |\n|                                  | have SELECT privileges, including in    |\n|                                  | WHERE, ON, GROUP BY, and ORDER BY       |\n|                                  | clauses.                                |\n+----------------------------------+-----------------------------------------+\n| UPDATE (column_list)             | Update values in columns of existing    |\n|                                  | rows using the UPDATE statement.        |\n|                                  | UPDATE statements usually include a     |\n|                                  | WHERE clause to update only certain     |\n|                                  | rows. You must have SELECT privileges   |\n|                                  | on the table or the appropriate         |\n|                                  | columns for the WHERE clause.           |\n+----------------------------------+-----------------------------------------+\n\nFunction Privileges\n-------------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER ROUTINE                    | Change the characteristics of a stored  |\n|                                  | function using the ALTER FUNCTION       |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| EXECUTE                          | Use a stored function. You need SELECT  |\n|                                  | privileges for any tables or columns    |\n|                                  | accessed by the function.               |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant function privileges. You can      |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n\nProcedure Privileges\n--------------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER ROUTINE                    | Change the characteristics of a stored  |\n|                                  | procedure using the ALTER PROCEDURE     |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| EXECUTE                          | Execute a stored procedure using the    |\n|                                  | CALL statement. The privilege to call   |\n|                                  | a procedure may allow you to perform    |\n|                                  | actions you wouldn\'t otherwise be able  |\n|                                  | to do, such as insert rows into a       |\n|                                  | table.                                  |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant procedure privileges. You can     |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n\nGRANT EXECUTE ON PROCEDURE mysql.create_db TO maintainer;\n\nProxy Privileges\n----------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| PROXY                            | Permits one user to be a proxy for      |\n|                                  | another.                                |\n+----------------------------------+-----------------------------------------+\n\nThe PROXY privilege allows one user to proxy as another user, which means\ntheir privileges change to that of the proxy user, and the CURRENT_USER()\nfunction returns the user name of the proxy user.\n\nThe PROXY privilege only works with authentication plugins that support it.\nThe default mysql_native_password authentication plugin does not support proxy\nusers.\n\nThe pam authentication plugin is the only plugin included with MariaDB that\ncurrently supports proxy users. The PROXY privilege is commonly used with the\npam authentication plugin to enable user and group mapping with PAM.\n\nFor example, to grant the PROXY privilege to an anonymous account that\nauthenticates with the pam authentication plugin, you could execute the\nfollowing:\n\nCREATE USER \'dba\'@\'%\' IDENTIFIED BY \'strongpassword\';\nGRANT ALL PRIVILEGES ON *.* TO \'dba\'@\'%\' ;\n\nCREATE USER \'\'@\'%\' IDENTIFIED VIA pam USING \'mariadb\';\nGRANT PROXY ON \'dba\'@\'%\' TO \'\'@\'%\';\n\nA user account can only grant the PROXY privilege for a specific user account\nif the granter also has the PROXY privilege for that specific user account,\nand if that privilege is defined WITH GRANT OPTION. For example, the following\nexample fails because the granter does not have the PROXY privilege for that\nspecific user account at all:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------+\n| Grants for alice@localhost                                                  \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' |\n+------------------------------------------------------------------------------\n----------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nERROR 1698 (28000): Access denied for user \'alice\'@\'localhost\'\n\nAnd the following example fails because the granter does have the PROXY\nprivilege for that specific user account, but it is not defined WITH GRANT\nOPTION:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------+\n| Grants for alice@localhost                                                  \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' |\n| GRANT PROXY ON \'dba\'@\'localhost\' TO \'alice\'@\'localhost\'                     \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nERROR 1698 (28000): Access denied for user \'alice\'@\'localhost\'\n\nBut the following example succeeds because the granter does have the PROXY\nprivilege for that specific user account, and it is defined WITH GRANT OPTION:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| Grants for alice@localhost                                                  \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' WITH GRANT OPTION |\n| GRANT PROXY ON \'dba\'@\'localhost\' TO \'alice\'@\'localhost\' WITH GRANT OPTION   \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\n\nA user account can grant the PROXY privilege for any other user account if the\ngranter has the PROXY privilege for the \'\'@\'%\' anonymous user account, like\nthis:\n\nGRANT PROXY ON \'\'@\'%\' TO \'dba\'@\'localhost\' WITH GRANT OPTION;\n\nFor example, the following example succeeds because the user can grant the\nPROXY privilege for any other user account:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| Grants for alice@localhost                                                  \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' WITH GRANT OPTION |\n| GRANT PROXY ON \'\'@\'%\' TO \'alice\'@\'localhost\' WITH GRANT OPTION              \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n\nGRANT PROXY ON \'app1_dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nQuery OK, 0 rows affected (0.004 sec)\n\nGRANT PROXY ON \'app2_dba\'@\'localhost\' TO \'carol\'@\'localhost\';\nQuery OK, 0 rows affected (0.004 sec)\n\nThe default root user accounts created by mysql_install_db have this\nprivilege. For example:\n\nGRANT ALL PRIVILEGES ON *.* TO \'root\'@\'localhost\' WITH GRANT OPTION;\nGRANT PROXY ON \'\'@\'%\' TO \'root\'@\'localhost\' WITH GRANT OPTION;\n\nThis allows the default root user accounts to grant the PROXY privilege for\nany other user account, and it also allows the default root user accounts to\ngrant others the privilege to do the same.\n\nAuthentication Options\n----------------------\n\nThe authentication options for the GRANT statement are the same as those for\nthe CREATE USER statement.\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored.\n\nFor example, if our password is mariadb, then we can create the user with:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nIf the user account already exists and if you provide the IDENTIFIED BY\nclause, then the user\'s password will be changed. You must have the privileges\nneeded for the SET PASSWORD statement to change a user\'s password with GRANT.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD function. It will be stored as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n\nAnd then we can create a user with the hash:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED BY \n PASSWORD \'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nIf the user account already exists and if you provide the IDENTIFIED BY\nclause, then the user\'s password will be changed. You must have the privileges\nneeded for the SET PASSWORD statement to change a user\'s password with GRANT.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nMariaDB starting with 10.4.0\n----------------------------\nThe USING or AS keyword can also be used to provide a plain-text password to a\nplugin if it\'s provided as an argument to the PASSWORD() function. This is\nonly valid for authentication plugins that have implemented a hook for the\nPASSWORD() function. For example, the ed25519 authentication plugin supports\nthis:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 \n USING PASSWORD(\'secret\');\n\nMariaDB starting with 10.4.3\n----------------------------\nOne can specify many authentication plugins, they all work as alternatives\nways of authenticating a user:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 \n USING PASSWORD(\'secret\') OR unix_socket;\n\nBy default, when you create a user without specifying an authentication\nplugin, MariaDB uses the mysql_native_password plugin.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+--------------------------------------+--------------------------------------+\n| Limit Type                           | Decription                           |\n+--------------------------------------+--------------------------------------+\n| MAX_QUERIES_PER_HOUR                 | Number of statements that the        |\n|                                      | account can issue per hour           |\n|                                      | (including updates)                  |\n+--------------------------------------+--------------------------------------+\n| MAX_UPDATES_PER_HOUR                 | Number of updates (not queries)      |\n|                                      | that the account can issue per hour  |\n+--------------------------------------+--------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR             | Number of connections that the       |\n|                                      | account can start per hour           |\n+--------------------------------------+--------------------------------------+\n| MAX_USER_CONNECTIONS                 | Number of simultaneous connections   |\n|                                      | that can be accepted from the same   |\n|                                      | account; if it is 0,                 |\n|                                      | max_connections will be used         |\n|                                      | instead; if max_connections is 0,    |\n|                                      | there is no limit for this           |\n|                                      | account\'s simultaneous connections.  |\n+--------------------------------------+--------------------------------------+\n| MAX_STATEMENT_TIME                   | Timeout, in seconds, for statements  |\n|                                      | executed by the user. See also       |\n|                                      | Aborting Statements that Exceed a    |\n|                                      | Certain Time to Execute.             |\n+--------------------------------------+--------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nTo set resource limits for an account, if you do not want to change that\naccount\'s privileges, you can issue a GRANT statement with the USAGE\nprivilege, which has no meaning. The statement can name some or all limit\ntypes, in any order.\n\nHere is an example showing how to set resource limits:\n\nGRANT USAGE ON *.* TO \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 0\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nUsers with the CONNECTION ADMIN privilege (in MariaDB 10.5.2 and later) or the\nSUPER privilege are not restricted by max_user_connections, max_connections,\nor max_password_errors.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can create a user account that requires these TLS options\nwith the following:\n\nGRANT USAGE ON *.* TO \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\'\n AND ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nRoles\n-----\n\nSyntax\n------\n\nGRANT role TO grantee [, grantee ... ]\n[ WITH ADMIN OPTION ]\n\ngrantee:\n  rolename\n  username [authentication_option]\n\nThe GRANT statement is also used to grant the use of a role to one or more\nusers or other roles. In order to be able to grant a role, the grantor doing\nso must have permission to do so (see WITH ADMIN in the CREATE ROLE article).\n\nSpecifying the WITH ADMIN OPTION permits the grantee to in turn grant the role\nto another.\n\nFor example, the following commands show how to grant the same role to a\ncouple different users.\n\nGRANT journalist TO hulda;\n\nGRANT journalist TO berengar WITH ADMIN OPTION;\n\nIf a user has been granted a role, they do not automatically obtain all\npermissions associated with that role. These permissions are only in use when\nthe user activates the role with the SET ROLE statement.\n\nTO PUBLIC\n---------\n\nMariaDB starting with 10.11\n---------------------------\n\nSyntax\n------\n\nGRANT <privilege> ON <database>.<object> TO PUBLIC;\nREVOKE <privilege> ON <database>.<object> FROM PUBLIC;\n\nGRANT ... TO PUBLIC grants privileges to all users with access to the server.\nThe privileges also apply to users created after the privileges are granted.\nThis can be useful when one only wants to state once that all users need to\nhave a certain set of privileges.\n\nWhen running SHOW GRANTS, a user will also see all privileges inherited from\nPUBLIC. SHOW GRANTS FOR PUBLIC will only show TO PUBLIC grants.\n\nGrant Examples\n--------------\n\nGranting Root-like Privileges\n-----------------------------\n\nYou can create a user that has privileges similar to the default root accounts\nby executing the following:\n\nCREATE USER \'alexander\'@\'localhost\';\nGRANT ALL PRIVILEGES ON  *.* to \'alexander\'@\'localhost\' WITH GRANT OPTION;\n\nURL: https://mariadb.com/kb/en/grant/','','https://mariadb.com/kb/en/grant/'),(117,'Authentication from MariaDB 10.4',10,'MariaDB starting with 10.4\n--------------------------\nMariaDB 10.4 introduced a number of changes to the authentication process,\nintended to make things easier and more intuitive.\n\nOverview\n--------\n\nThere are four new main features in 10.4 relating to authentication:\n\n* It is possible to use more than one authentication plugin for each user\naccount. For example, this can be useful to slowly migrate users to the more\nsecure ed25519 authentication plugin over time, while allowing the old\nmysql_native_password authentication plugin as an alternative for the\ntransitional period.\n* The root@localhost user account created by mysql_install_db is created with\nthe ability to use two authentication plugins.\nFirst, it is configured to try to use the unix_socket authentication plugin.\nThis allows the root@localhost user to login without a password via the local\nUnix socket file defined by the socket system variable, as long as the login\nis attempted from a process owned by the operating system root user account.\nSecond, if authentication fails with the unix_socket authentication plugin,\nthen it is configured to try to use the mysql_native_password authentication\nplugin. However, an invalid password is initially set, so in order to\nauthenticate this way, a password must be set with SET PASSWORD.\nHowever, just using the unix_socket authentication plugin may be fine for many\nusers, and it is very secure. You may want to try going without password\nauthentication to see how well it works for you. Remember, the best way to\nkeep your password safe is not to have one!\n\n* All user accounts, passwords, and global privileges are now stored in the\nmysql.global_priv table. The mysql.user table still exists and has exactly the\nsame set of columns as before, but it’s now a view that references the\nmysql.global_priv table. Tools that analyze the mysql.user table should\ncontinue to work as before. From MariaDB 10.4.13, the dedicated mariadb.sys\nuser is created as the definer of this view. Previously root was the definer,\nwhich resulted in privilege problems when this username was changed.\n* MariaDB 10.4 adds supports for User Password Expiry, which is not active by\ndefault.\n\nDescription\n-----------\n\nAs a result of the above changes, the open-for-everyone all-powerful root\naccount is finally gone. And installation scripts will no longer demand that\nyou \"PLEASE REMEMBER TO SET A PASSWORD FOR THE MariaDB root USER !\", because\nthe root account is securely created automatically.\n\nTwo all-powerful accounts are created by default — root and the OS user that\nowns the data directory, typically mysql. They are created as:\n\nCREATE USER root@localhost IDENTIFIED VIA unix_socket OR mysql_native_password\nUSING \'invalid\'\nCREATE USER mysql@localhost IDENTIFIED VIA unix_socket OR\nmysql_native_password USING \'invalid\'\n\nUsing unix_socket means that if you are the system root user, you can login as\nroot@locahost without a password. This technique was pioneered by Otto\nKekäläinen in Debian MariaDB packages and has been successfully used in Debian\nsince as early as MariaDB 10.0.\n\nIt is based on a simple fact that asking the system root for a password adds\nno extra security — root has full access to all the data files and all process\nmemory anyway. But not asking for a password means, there is no root password\nto forget (no need for the numerous tutorials on \"how to reset MariaDB root\npassword\"). And if you want to script some tedious database work, there is no\nneed to store the root password in plain text for the script to use (no need\nfor debian-sys-maint user).\n\nStill, some users may wish to log in as MariaDB root without using sudo. Hence\nthe old authentication method — conventional MariaDB password — is still\navailable. By default it is disabled (\"invalid\" is not a valid password hash),\nbut one can set the password with a usual SET PASSWORD statement. And still\nretain the password-less access via sudo.\n\nIf you install MariaDB locally (say from a tarball), you would not want to use\nsudo to be able to login. This is why MariaDB creates a second all-powerful\nuser with the same name as a system user that owns the data directory. In\nlocal (not system-wide) installations, this will be the user who installed\nMariaDB — they automatically get convenient password-less root-like access,\nbecause they can access all the data files anyway.\n\nEven if MariaDB is installed system-wide, you may not want to run your\ndatabase maintenance scripts as system root — now you can run them as system\nmysql user. And you will know that they will never destroy your entire system,\neven if you make a typo in a shell script.\n\nHowever, seasoned MariaDB DBAs who are used to the old ways do need to make\nsome changes. See the examples below for common tasks.\n\nCookbook\n--------\n\nAfter installing MariaDB system-wide the first thing you’ve got used to doing\nis logging in into the unprotected root account and protecting it, that is,\nsetting the root password:\n\n$ sudo dnf install MariaDB-server\n$ mysql -uroot\n...\nMariaDB> set password = password(\"XH4VmT3_jt\");\n\nThis is not only unnecessary now, it will simply not work — there is no\nunprotected root account. To login as root use\n\n$ sudo dnf install MariaDB-server\n$ sudo mysql\n\nNote that it implies you are connecting via the unix socket, not tcp. If you\nhappen to have protocol=tcp in a system-wide /etc/my.cnf file, use sudo mysql\n--protocol=socket.\n\nAfter installing MariaDB locally you’ve also used to connect to the\nunprotected root account using mysql -uroot. This will not work either, simply\nuse mysql without specifying a username.\n\nIf you\'ve forgotten your root password, no problem — you can still connect\nusing sudo and change the password. And if you\'ve also removed unix_socket\nauthentication, to restore access do as follows:\n\n* restart MariaDB with --skip-grant-tables\n* login into the unprotected server\n* run FLUSH PRIVILEGES (note, before 10.4 this would’ve been the last step,\nnot anymore). This disables --skip-grant-tables and allows you to change the\nstored authentication method\n* run SET PASSWORD FOR root@localhost to change the root password.\n\nTo view inside privilege tables, the old mysql.user table still exists. You\ncan select from it as before, although you cannot update it anymore. It\ndoesn’t show alternative authentication plugins and this was one of the\nreasons for switching to the mysql.global_priv table — complex authentication\nrules did not fit into rigid structure of a relational table. You can select\nfrom the new table, for example:\n\nselect concat(user, \'@\', host, \' => \', json_detailed(priv)) from\nmysql.global_priv;\n\nReverting to the Previous Authentication Method for root@localhost\n------------------------------------------------------------------\n\nIf you don\'t want the root@localhost user account created by mysql_install_db\nto use unix_socket authentication by default, then there are a few ways to\nrevert to the previous mysql_native_password authentication method for this\nuser account.\n\nConfiguring mysql_install_db to Revert to the Previous Authentication Method\n----------------------------------------------------------------------------\n\nOne way to revert to the previous mysql_native_password authentication method\nfor the root@localhost user account is to execute mysql_install_db with a\nspecial option. If mysql_install_db is executed while\n--auth-root-authentication-method=normal is specified, then it will create the\ndefault user accounts using the default behavior of MariaDB 10.3 and before.\n\nThis means that the root@localhost user account will use mysql_native_password\nauthentication by default. There are some other differences as well. See\nmysql_install_db: User Accounts Created by Default for more information.\n\nFor example, the option can be set on the command-line while running\nmysql_install_db:\n\nmysql_install_db --user=mysql --datadir=/var/lib/mysql\n--auth-root-authentication-method=normal\n\nThe option can also be set in an option file in an option group supported by\nmysql_install_db. For example:\n\n[mysql_install_db]\nauth_root_authentication_method=normal\n\nIf the option is set in an option file and if mysql_install_db is executed,\nthen mysql_install_db will read this option from the option file, and it will\nautomatically set this option.\n\nAltering the User Account to Revert to the Previous Authentication Method\n-------------------------------------------------------------------------\n\nIf you have already installed MariaDB, and if the root@localhost user account\nis already using unix_socket authentication, then you can revert to the old\nmysql_native_password authentication method for the user account by executing\nthe following:\n\nALTER USER root@localhost IDENTIFIED VIA mysql_native_password USING\nPASSWORD(\"verysecret\")\n\nURL: https://mariadb.com/kb/en/authentication-from-mariadb-104/','','https://mariadb.com/kb/en/authentication-from-mariadb-104/'),(119,'ST_X',11,'Syntax\n------\n\nST_X(p)\nX(p)\n\nDescription\n-----------\n\nReturns the X-coordinate value for the point p as a double-precision number.\n\nST_X() and X() are synonyms.\n\nExamples\n--------\n\nSET @pt = \'Point(56.7 53.34)\';\n\nSELECT X(GeomFromText(@pt));\n+----------------------+\n| X(GeomFromText(@pt)) |\n+----------------------+\n|                 56.7 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/st_x/','','https://mariadb.com/kb/en/st_x/'),(88,'IF Function',7,'Syntax\n------\n\nIF(expr1,expr2,expr3)\n\nDescription\n-----------\n\nIf expr1 is TRUE (expr1 <> 0 and expr1 <> NULL) then IF() returns expr2;\notherwise it returns expr3. IF() returns a numeric or string value, depending\non the context in which it is used.\n\nNote: There is also an IF statement which differs from the IF() function\ndescribed here.\n\nExamples\n--------\n\nSELECT IF(1>2,2,3);\n+-------------+\n| IF(1>2,2,3) |\n+-------------+\n|           3 |\n+-------------+\n\nSELECT IF(1<2,\'yes\',\'no\');\n+--------------------+\n| IF(1<2,\'yes\',\'no\') |\n+--------------------+\n| yes                |\n+--------------------+\n\nSELECT IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\');\n+---------------------------------------+\n| IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\') |\n+---------------------------------------+\n| no                                    |\n+---------------------------------------+\n\nURL: https://mariadb.com/kb/en/if-function/','','https://mariadb.com/kb/en/if-function/'),(89,'IFNULL',7,'Syntax\n------\n\nIFNULL(expr1,expr2)\nNVL(expr1,expr2)\n\nDescription\n-----------\n\nIf expr1 is not NULL, IFNULL() returns expr1; otherwise it returns expr2.\nIFNULL() returns a numeric or string value, depending on the context in which\nit is used.\n\nFrom MariaDB 10.3, NVL() is an alias for IFNULL().\n\nExamples\n--------\n\nSELECT IFNULL(1,0); \n+-------------+\n| IFNULL(1,0) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT IFNULL(NULL,10);\n+-----------------+\n| IFNULL(NULL,10) |\n+-----------------+\n|              10 |\n+-----------------+\n\nSELECT IFNULL(1/0,10);\n+----------------+\n| IFNULL(1/0,10) |\n+----------------+\n|        10.0000 |\n+----------------+\n\nSELECT IFNULL(1/0,\'yes\');\n+-------------------+\n| IFNULL(1/0,\'yes\') |\n+-------------------+\n| yes               |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/ifnull/','','https://mariadb.com/kb/en/ifnull/'),(94,'START TRANSACTION',8,'Syntax\n------\n\nSTART TRANSACTION [transaction_property [, transaction_property] ...] | BEGIN\n[WORK]\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nROLLBACK [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nSET autocommit = {0 | 1}\n\ntransaction_property:\n  WITH CONSISTENT SNAPSHOT\n | READ WRITE\n | READ ONLY\n\nDescription\n-----------\n\nThe START TRANSACTION or BEGIN statement begins a new transaction. COMMIT\ncommits the current transaction, making its changes permanent. ROLLBACK rolls\nback the current transaction, canceling its changes. The SET autocommit\nstatement disables or enables the default autocommit mode for the current\nsession.\n\nSTART TRANSACTION and SET autocommit = 1 implicitly commit the current\ntransaction, if any.\n\nThe optional WORK keyword is supported for COMMIT and ROLLBACK, as are the\nCHAIN and RELEASE clauses. CHAIN and RELEASE can be used for additional\ncontrol over transaction completion. The value of the completion_type system\nvariable determines the default completion behavior.\n\nThe AND CHAIN clause causes a new transaction to begin as soon as the current\none ends, and the new transaction has the same isolation level as the\njust-terminated transaction. The RELEASE clause causes the server to\ndisconnect the current client session after terminating the current\ntransaction. Including the NO keyword suppresses CHAIN or RELEASE completion,\nwhich can be useful if the completion_type system variable is set to cause\nchaining or release completion by default.\n\nAccess Mode\n-----------\n\nThe access mode specifies whether the transaction is allowed to write data or\nnot. By default, transactions are in READ WRITE mode (see the tx_read_only\nsystem variable). READ ONLY mode allows the storage engine to apply\noptimizations that cannot be used for transactions which write data. The only\nexception to this rule is that read only transactions can perform DDL\nstatements on temporary tables.\n\nIt is not permitted to specify both READ WRITE and READ ONLY in the same\nstatement.\n\nREAD WRITE and READ ONLY can also be specified in the SET TRANSACTION\nstatement, in which case the specified mode is valid for all sessions, or for\nall subsequent transaction used by the current session.\n\nautocommit\n----------\n\nBy default, MariaDB runs with autocommit mode enabled. This means that as soon\nas you execute a statement that updates (modifies) a table, MariaDB stores the\nupdate on disk to make it permanent. To disable autocommit mode, use the\nfollowing statement:\n\nSET autocommit=0;\n\nAfter disabling autocommit mode by setting the autocommit variable to zero,\nchanges to transaction-safe tables (such as those for InnoDB or NDBCLUSTER)\nare not made permanent immediately. You must use COMMIT to store your changes\nto disk or ROLLBACK to ignore the changes.\n\nTo disable autocommit mode for a single series of statements, use the START\nTRANSACTION statement.\n\nDDL Statements\n--------------\n\nDDL statements (CREATE, ALTER, DROP) and administrative statements (FLUSH,\nRESET, OPTIMIZE, ANALYZE, CHECK, REPAIR, CACHE INDEX), transaction management\nstatements (BEGIN, START TRANSACTION) and LOAD DATA INFILE, cause an implicit\nCOMMIT and start a new transaction. An exception to this rule are the DDL that\noperate on temporary tables: you can CREATE, ALTER and DROP them without\ncausing any COMMIT, but those actions cannot be rolled back. This means that\nif you call ROLLBACK, the temporary tables you created in the transaction will\nremain, while the rest of the transaction will be rolled back.\n\nTransactions cannot be used in Stored Functions or Triggers. In Stored\nProcedures and Events BEGIN is not allowed, so you should use START\nTRANSACTION instead.\n\nA transaction acquires a metadata lock on every table it accesses to prevent\nother connections from altering their structure. The lock is released at the\nend of the transaction. This happens even with non-transactional storage\nengines (like MEMORY or CONNECT), so it makes sense to use transactions with\nnon-transactional tables.\n\nin_transaction\n--------------\n\nThe in_transaction system variable is a session-only, read-only variable that\nreturns 1 inside a transaction, and 0 if not in a transaction.\n\nWITH CONSISTENT SNAPSHOT\n------------------------\n\nThe WITH CONSISTENT SNAPSHOT option starts a consistent read for storage\nengines such as InnoDB that can do so, the same as if a START TRANSACTION\nfollowed by a SELECT from any InnoDB table was issued.\n\nSee Enhancements for START TRANSACTION WITH CONSISTENT SNAPSHOT.\n\nExamples\n--------\n\nSTART TRANSACTION;\nSELECT @A:=SUM(salary) FROM table1 WHERE type=1;\nUPDATE table2 SET summary=@A WHERE type=1;\nCOMMIT;\n\nURL: https://mariadb.com/kb/en/start-transaction/','','https://mariadb.com/kb/en/start-transaction/'),(120,'ST_Y',11,'Syntax\n------\n\nST_Y(p)\nY(p)\n\nDescription\n-----------\n\nReturns the Y-coordinate value for the point p as a double-precision number.\n\nST_Y() and Y() are synonyms.\n\nExamples\n--------\n\nSET @pt = \'Point(56.7 53.34)\';\n\nSELECT Y(GeomFromText(@pt));\n+----------------------+\n| Y(GeomFromText(@pt)) |\n+----------------------+\n|                53.34 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/st_y/','','https://mariadb.com/kb/en/st_y/'),(121,'X',11,'A synonym for ST_X.\n\nURL: https://mariadb.com/kb/en/point-properties-x/','','https://mariadb.com/kb/en/point-properties-x/'),(122,'Y',11,'A synonym for ST_Y.\n\nURL: https://mariadb.com/kb/en/point-properties-y/','','https://mariadb.com/kb/en/point-properties-y/'),(125,'DECODE_ORACLE',12,'MariaDB starting with 10.3.2\n----------------------------\nDECODE_ORACLE is a synonym for the Oracle mode version of the DECODE function,\nand is available in all modes.\n\nURL: https://mariadb.com/kb/en/decode_oracle/','','https://mariadb.com/kb/en/decode_oracle/'),(93,'SET TRANSACTION',8,'Syntax\n------\n\nSET [GLOBAL | SESSION] TRANSACTION\n  transaction_property [, transaction_property] ...\n\ntransaction_property:\n  ISOLATION LEVEL level\n | READ WRITE\n | READ ONLY\n\nlevel:\n  REPEATABLE READ\n | READ COMMITTED\n | READ UNCOMMITTED\n | SERIALIZABLE\n\nDescription\n-----------\n\nThis statement sets the transaction isolation level or the transaction access\nmode globally, for the current session, or for the next transaction:\n\n* With the GLOBAL keyword, the statement sets the default\n transaction level globally for all subsequent sessions. Existing sessions are\n unaffected.\n* With the SESSION keyword, the statement sets the default\n transaction level for all subsequent transactions performed within the\n current session.\n* Without any SESSION or GLOBAL keyword,\n the statement sets the isolation level for the next (not started) transaction\n performed within the current session.\n\nA change to the global default isolation level requires the SUPER privilege.\nAny session is free to change its session isolation level (even in the middle\nof a transaction), or the isolation level for its next transaction.\n\nIsolation Level\n---------------\n\nTo set the global default isolation level at server startup, use the\n--transaction-isolation=level option on the command line or in an option file.\nValues of level for this option use dashes rather than spaces, so the\nallowable values are READ-UNCOMMITTED, READ-COMMITTED, REPEATABLE-READ, or\nSERIALIZABLE. For example, to set the default isolation level to REPEATABLE\nREAD, use these lines in the [mysqld] section of an option file:\n\n[mysqld]\ntransaction-isolation = REPEATABLE-READ\nTo determine the global and session transaction isolation levels at runtime,\ncheck the value of the tx_isolation system variable:\n\nSELECT @@GLOBAL.tx_isolation, @@tx_isolation;\n\nInnoDB supports each of the translation isolation levels described here using\ndifferent locking strategies. The default level is REPEATABLE READ. For\nadditional information about InnoDB record-level locks and how it uses them to\nexecute various types of statements, see InnoDB Lock Modes, and\nhttp://dev.mysql.com/doc/refman/en/innodb-locks-set.html.\n\nIsolation Levels\n----------------\n\nThe following sections describe how MariaDB supports the different transaction\nlevels.\n\nREAD UNCOMMITTED\n----------------\n\nSELECT statements are performed in a non-locking fashion, but a possible\nearlier version of a row might be used. Thus, using this isolation level, such\nreads are not consistent. This is also called a \"dirty read.\" Otherwise, this\nisolation level works like READ COMMITTED.\n\nREAD COMMITTED\n--------------\n\nA somewhat Oracle-like isolation level with respect to consistent\n(non-locking) reads: Each consistent read, even within the same transaction,\nsets and reads its own fresh snapshot. See\nhttp://dev.mysql.com/doc/refman/en/innodb-consistent-read.html.\n\nFor locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE), InnoDB locks\nonly index records, not the gaps before them, and thus allows the free\ninsertion of new records next to locked records. For UPDATE and DELETE\nstatements, locking depends on whether the statement uses a unique index with\na unique search condition (such as WHERE id = 100), or a range-type search\ncondition (such as WHERE id > 100). For a unique index with a unique search\ncondition, InnoDB locks only the index record found, not the gap before it.\nFor range-type searches, InnoDB locks the index range scanned, using gap locks\nor next-key (gap plus index-record) locks to block insertions by other\nsessions into the gaps covered by the range. This is necessary because\n\"phantom rows\" must be blocked for MySQL replication and recovery to work.\n\nNote: If the READ COMMITTED isolation level is used or the\ninnodb_locks_unsafe_for_binlog system variable is enabled, there is no InnoDB\ngap locking except for foreign-key constraint checking and duplicate-key\nchecking. Also, record locks for non-matching rows are released after MariaDB\nhas evaluated the WHERE condition.If you use READ COMMITTED or enable\ninnodb_locks_unsafe_for_binlog, you must use row-based binary logging.\n\nREPEATABLE READ\n---------------\n\nThis is the default isolation level for InnoDB. For consistent reads, there is\nan important difference from the READ COMMITTED isolation level: All\nconsistent reads within the same transaction read the snapshot established by\nthe first read. This convention means that if you issue several plain\n(non-locking) SELECT statements within the same transaction, these SELECT\nstatements are consistent also with respect to each other. See\nhttp://dev.mysql.com/doc/refman/en/innodb-consistent-read.html.\n\nFor locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE), UPDATE, and\nDELETE statements, locking depends on whether the statement uses a unique\nindex with a unique search condition, or a range-type search condition. For a\nunique index with a unique search condition, InnoDB locks only the index\nrecord found, not the gap before it. For other search conditions, InnoDB locks\nthe index range scanned, using gap locks or next-key (gap plus index-record)\nlocks to block insertions by other sessions into the gaps covered by the range.\n\nThis is the minimum isolation level for non-distributed XA transactions.\n\nSERIALIZABLE\n------------\n\nThis level is like REPEATABLE READ, but InnoDB implicitly converts all plain\nSELECT statements to SELECT ... LOCK IN SHARE MODE if autocommit is disabled.\nIf autocommit is enabled, the SELECT is its own transaction. It therefore is\nknown to be read only and can be serialized if performed as a consistent\n(non-locking) read and need not block for other transactions. (This means that\nto force a plain SELECT to block if other transactions have modified the\nselected rows, you should disable autocommit.)\n\nDistributed XA transactions should always use this isolation level.\n\nAccess Mode\n-----------\n\nThe access mode specifies whether the transaction is allowed to write data or\nnot. By default, transactions are in READ WRITE mode (see the tx_read_only\nsystem variable). READ ONLY mode allows the storage engine to apply\noptimizations that cannot be used for transactions which write data. The only\nexception to this rule is that read only transactions can perform DDL\nstatements on temporary tables.\n\nIt is not permitted to specify both READ WRITE and READ ONLY in the same\nstatement.\n\nREAD WRITE and READ ONLY can also be specified in the START TRANSACTION\nstatement, in which case the specified mode is only valid for one transaction.\n\nExamples\n--------\n\nSET GLOBAL TRANSACTION ISOLATION LEVEL SERIALIZABLE;\n\nAttempting to set the isolation level within an existing transaction without\nspecifying GLOBAL or SESSION.\n\nSTART TRANSACTION;\n\nSET TRANSACTION ISOLATION LEVEL SERIALIZABLE;\nERROR 1568 (25001): Transaction characteristics can\'t be changed while a\ntransaction is in progress\n\nURL: https://mariadb.com/kb/en/set-transaction/','','https://mariadb.com/kb/en/set-transaction/'),(126,'AES_DECRYPT',12,'Syntax\n------\n\nAES_DECRYPT(crypt_str,key_str)\n\nDescription\n-----------\n\nThis function allows decryption of data using the official AES (Advanced\nEncryption Standard) algorithm. For more information, see the description of\nAES_ENCRYPT().\n\nURL: https://mariadb.com/kb/en/aes_decrypt/','','https://mariadb.com/kb/en/aes_decrypt/'),(133,'MD5',12,'Syntax\n------\n\nMD5(str)\n\nDescription\n-----------\n\nCalculates an MD5 128-bit checksum for the string.\n\nThe return value is a 32-hex digit string, and as of MariaDB 5.5, is a\nnonbinary string in the connection character set and collation, determined by\nthe values of the character_set_connection and collation_connection system\nvariables. Before 5.5, the return value was a binary string.\n\nNULL is returned if the argument was NULL.\n\nExamples\n--------\n\nSELECT MD5(\'testing\');\n+----------------------------------+\n| MD5(\'testing\')                   |\n+----------------------------------+\n| ae2b1fca515949e5d54fb22b8ed95575 |\n+----------------------------------+\n\nURL: https://mariadb.com/kb/en/md5/','','https://mariadb.com/kb/en/md5/'),(95,'COMMIT',8,'The COMMIT statement ends a transaction, saving any changes to the data so\nthat they become visible to subsequent transactions. Also, unlocks metadata\nchanged by current transaction. If autocommit is set to 1, an implicit commit\nis performed after each statement. Otherwise, all transactions which don\'t end\nwith an explicit COMMIT are implicitly rollbacked and the changes are lost.\nThe ROLLBACK statement can be used to do this explicitly.\n\nThe required syntax for the COMMIT statement is as follows:\n\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\n\nCOMMIT is the more important transaction terminator, as well as the more\ninteresting one. The basic form of the COMMIT statement is simply the keyword\nCOMMIT (the keyword WORK is simply noise and can be omitted without changing\nthe effect).\n\nThe optional AND CHAIN clause is a convenience for initiating a new\ntransaction as soon as the old transaction terminates. If AND CHAIN is\nspecified, then there is effectively nothing between the old and new\ntransactions, although they remain separate. The characteristics of the new\ntransaction will be the same as the characteristics of the old one — that is,\nthe new transaction will have the same access mode, isolation level and\ndiagnostics area size (we\'ll discuss all of these shortly) as the transaction\njust terminated.\n\nRELEASE tells the server to disconnect the client immediately after the\ncurrent transaction.\n\nThere are NO RELEASE and AND NO CHAIN options. By default, commits do not\nRELEASE or CHAIN, but it\'s possible to change this default behavior with the\ncompletion_type server system variable. In this case, the AND NO CHAIN and NO\nRELEASE options override the server default.\n\nURL: https://mariadb.com/kb/en/commit/','','https://mariadb.com/kb/en/commit/'),(96,'ROLLBACK',8,'The ROLLBACK statement rolls back (ends) a transaction, destroying any changes\nto SQL-data so that they never become visible to subsequent transactions. The\nrequired syntax for the ROLLBACK statement is as follows.\n\nROLLBACK [ WORK ] [ AND [ NO ] CHAIN ] \n[ TO [ SAVEPOINT ] {<savepoint name> | <simple target specification>} ]\n\nThe ROLLBACK statement will either end a transaction, destroying all data\nchanges that happened during any of the transaction, or it will just destroy\nany data changes that happened since you established a savepoint. The basic\nform of the ROLLBACK statement is just the keyword ROLLBACK (the keyword WORK\nis simply noise and can be omitted without changing the effect).\n\nThe optional AND CHAIN clause is a convenience for initiating a new\ntransaction as soon as the old transaction terminates. If AND CHAIN is\nspecified, then there is effectively nothing between the old and new\ntransactions, although they remain separate. The characteristics of the new\ntransaction will be the same as the characteristics of the old one — that is,\nthe new transaction will have the same access mode, isolation level and\ndiagnostics area size (we\'ll discuss all of these shortly) as the transaction\njust terminated. The AND NO CHAIN option just tells your DBMS to end the\ntransaction — that is, these four SQL statements are equivalent:\n\nROLLBACK; \nROLLBACK WORK; \nROLLBACK AND NO CHAIN; \nROLLBACK WORK AND NO CHAIN;\n\nAll of them end a transaction without saving any transaction characteristics.\nThe only other options, the equivalent statements:\n\nROLLBACK AND CHAIN;\nROLLBACK WORK AND CHAIN;\n\nboth tell your DBMS to end a transaction, but to save that transaction\'s\ncharacteristics for the next transaction.\n\nROLLBACK is much simpler than COMMIT: it may involve no more than a few\ndeletions (of Cursors, locks, prepared SQL statements and log-file entries).\nIt\'s usually assumed that ROLLBACK can\'t fail, although such a thing is\nconceivable (for example, an encompassing transaction might reject an attempt\nto ROLLBACK because it\'s lining up for a COMMIT).\n\nROLLBACK cancels all effects of a transaction. It does not cancel effects on\nobjects outside the DBMS\'s control (for example the values in host program\nvariables or the settings made by some SQL/CLI function calls). But in\ngeneral, it is a convenient statement for those situations when you say \"oops,\nthis isn\'t working\" or when you simply don\'t care whether your temporary work\nbecomes permanent or not.\n\nHere is a moot question. If all you\'ve been doing is SELECTs, so that there\nhave been no data changes, should you end the transaction with ROLLBACK or\nCOMMIT? It shouldn\'t really matter because both ROLLBACK and COMMIT do the\nsame transaction-terminating job. However, the popular conception is that\nROLLBACK implies failure, so after a successful series of SELECT statements\nthe convention is to end the transaction with COMMIT rather than ROLLBACK.\n\nMariaDB (and most other DBMSs) supports rollback of SQL-data change\nstatements, but not of SQL-Schema statements. This means that if you use any\nof CREATE, ALTER, DROP, GRANT, REVOKE, you are implicitly committing at\nexecution time.\n\nINSERT INTO Table_2 VALUES(5); \nDROP TABLE Table_3 CASCADE; \nROLLBACK;\n\nThe result will be that both the INSERT and the DROP will go through as\nseparate transactions so the ROLLBACK will have no effect.\n\nURL: https://mariadb.com/kb/en/rollback/','','https://mariadb.com/kb/en/rollback/'),(138,'ENDPOINT',13,'A synonym for ST_ENDPOINT.\n\nURL: https://mariadb.com/kb/en/linestring-properties-endpoint/','','https://mariadb.com/kb/en/linestring-properties-endpoint/'),(139,'GLENGTH',13,'Syntax\n------\n\nGLength(ls)\n\nDescription\n-----------\n\nReturns as a double-precision number the length of the LineString value ls in\nits associated spatial reference.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT GLength(GeomFromText(@ls));\n+----------------------------+\n| GLength(GeomFromText(@ls)) |\n+----------------------------+\n|           2.82842712474619 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/glength/','','https://mariadb.com/kb/en/glength/'),(140,'NumPoints',13,'A synonym for ST_NumPoints.\n\nURL: https://mariadb.com/kb/en/linestring-properties-numpoints/','','https://mariadb.com/kb/en/linestring-properties-numpoints/'),(141,'PointN',13,'A synonym for ST_PointN.\n\nURL: https://mariadb.com/kb/en/linestring-properties-pointn/','','https://mariadb.com/kb/en/linestring-properties-pointn/'),(142,'STARTPOINT',13,'A synonym for ST_STARTPOINT.\n\nURL: https://mariadb.com/kb/en/linestring-properties-startpoint/','','https://mariadb.com/kb/en/linestring-properties-startpoint/'),(143,'ST_ENDPOINT',13,'Syntax\n------\n\nST_EndPoint(ls)\nEndPoint(ls)\n\nDescription\n-----------\n\nReturns the Point that is the endpoint of the LineString value ls.\n\nST_EndPoint() and EndPoint() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(EndPoint(GeomFromText(@ls)));\n+-------------------------------------+\n| AsText(EndPoint(GeomFromText(@ls))) |\n+-------------------------------------+\n| POINT(3 3)                          |\n+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_endpoint/','','https://mariadb.com/kb/en/st_endpoint/'),(144,'ST_NUMPOINTS',13,'Syntax\n------\n\nST_NumPoints(ls)\nNumPoints(ls)\n\nDescription\n-----------\n\nReturns the number of Point objects in the LineString value ls.\n\nST_NumPoints() and NumPoints() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT NumPoints(GeomFromText(@ls));\n+------------------------------+\n| NumPoints(GeomFromText(@ls)) |\n+------------------------------+\n|                            3 |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/st_numpoints/','','https://mariadb.com/kb/en/st_numpoints/'),(97,'LOCK TABLES',8,'Syntax\n------\n\nLOCK TABLE[S]\n  tbl_name [[AS] alias] lock_type\n  [, tbl_name [[AS] alias] lock_type] ...\n  [WAIT n|NOWAIT]\n\nlock_type:\n  READ [LOCAL]\n | [LOW_PRIORITY] WRITE\n | WRITE CONCURRENT\n\nUNLOCK TABLES\n\nDescription\n-----------\n\nThe lock_type can be one of:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| READ                      | Read lock, no writes allowed                   |\n+---------------------------+------------------------------------------------+\n| READ LOCAL                | Read lock, but allow concurrent inserts        |\n+---------------------------+------------------------------------------------+\n| WRITE                     | Exclusive write lock. No other connections     |\n|                           | can read or write to this table                |\n+---------------------------+------------------------------------------------+\n| LOW_PRIORITY WRITE        | Exclusive write lock, but allow new read       |\n|                           | locks on the table until we get the write      |\n|                           | lock.                                          |\n+---------------------------+------------------------------------------------+\n| WRITE CONCURRENT          | Exclusive write lock, but allow READ LOCAL     |\n|                           | locks to the table.                            |\n+---------------------------+------------------------------------------------+\n\nMariaDB enables client sessions to acquire table locks explicitly for the\npurpose of cooperating with other sessions for access to tables, or to prevent\nother sessions from modifying tables during periods when a session requires\nexclusive access to them. A session can acquire or release locks only for\nitself. One session cannot acquire locks for another session or release locks\nheld by another session.\n\nLocks may be used to emulate transactions or to get more speed when updating\ntables.\n\nLOCK TABLES explicitly acquires table locks for the current client session.\nTable locks can be acquired for base tables or views. To use LOCK TABLES, you\nmust have the LOCK TABLES privilege, and the SELECT privilege for each object\nto be locked. See GRANT\n\nFor view locking, LOCK TABLES adds all base tables used in the view to the set\nof tables to be locked and locks them automatically. If you lock a table\nexplicitly with LOCK TABLES, any tables used in triggers are also locked\nimplicitly, as described in Triggers and Implicit Locks.\n\nUNLOCK TABLES explicitly releases any table locks held by the current session.\n\nMariaDB starting with 10.3.0\n----------------------------\n\nWAIT/NOWAIT\n-----------\n\nSet the lock wait timeout. See WAIT and NOWAIT.\n\nLimitations\n-----------\n\n* LOCK TABLES doesn\'t work when using Galera cluster.   You may experience\ncrashes or locks when used with Galera.\n* LOCK TABLES works on XtraDB/InnoDB tables only if the innodb_table_locks\nsystem variable is set to 1 (the default) and autocommit is set to 0 (1 is\ndefault). Please note that no error message will be returned on LOCK TABLES\nwith innodb_table_locks = 0.\n* LOCK TABLES implicitly commits the active transaction, if any. Also,\nstarting a transaction always releases all table locks acquired with LOCK\nTABLES. This means that there is no way to have table locks and an active\ntransaction at the same time. The only exceptions are the transactions in\nautocommit mode. To preserve the data integrity between transactional and\nnon-transactional tables, the GET_LOCK() function can be used.\n* When using LOCK TABLES on a TEMPORARY table, it will always be locked with a\nWRITE lock.\n* While a connection holds an explicit read lock on a table, it cannot modify\nit. If you try, the following error will be produced:\n\nERROR 1099 (HY000): Table \'tab_name\' was locked with a READ lock and can\'t be\nupdated\n\n* While a connection holds an explicit lock on a table, it cannot access a\nnon-locked table. If you try, the following error will be produced:\n\nERROR 1100 (HY000): Table \'tab_name\' was not locked with LOCK TABLES\n\n* While a connection holds an explicit lock on a table, it cannot issue the\nfollowing: INSERT DELAYED, CREATE TABLE, CREATE TABLE ... LIKE, and DDL\nstatements involving stored programs and views (except for triggers). If you\ntry, the following error will be produced:\n\nERROR 1192 (HY000): Can\'t execute the given command because you have active\nlocked tables or an active transaction\n\n* LOCK TABLES can not be used in stored routines - if you try, the following\nerror will be produced on creation. This restriction was removed in MariaDB\n10.6.2:\n\nERROR 1314 (0A000): LOCK is not allowed in stored procedures\n\nURL: https://mariadb.com/kb/en/lock-tables/','','https://mariadb.com/kb/en/lock-tables/'),(145,'ST_POINTN',13,'Syntax\n------\n\nST_PointN(ls,N)\nPointN(ls,N)\n\nDescription\n-----------\n\nReturns the N-th Point in the LineString value ls. Points are numbered\nbeginning with 1.\n\nST_PointN() and PointN() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(PointN(GeomFromText(@ls),2));\n+-------------------------------------+\n| AsText(PointN(GeomFromText(@ls),2)) |\n+-------------------------------------+\n| POINT(2 2)                          |\n+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_pointn/','','https://mariadb.com/kb/en/st_pointn/'),(146,'ST_STARTPOINT',13,'Syntax\n------\n\nST_StartPoint(ls)\nStartPoint(ls)\n\nDescription\n-----------\n\nReturns the Point that is the start point of the LineString value ls.\n\nST_StartPoint() and StartPoint() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(StartPoint(GeomFromText(@ls)));\n+---------------------------------------+\n| AsText(StartPoint(GeomFromText(@ls))) |\n+---------------------------------------+\n| POINT(1 1)                            |\n+---------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_startpoint/','','https://mariadb.com/kb/en/st_startpoint/'),(150,'INET_ATON',14,'Syntax\n------\n\nINET_ATON(expr)\n\nDescription\n-----------\n\nGiven the dotted-quad representation of an IPv4 network address as a string,\nreturns an integer that represents the numeric value of the address. Addresses\nmay be 4- or 8-byte addresses.\n\nReturns NULL if the argument is not understood.\n\nExamples\n--------\n\nSELECT INET_ATON(\'192.168.1.1\');\n+--------------------------+\n| INET_ATON(\'192.168.1.1\') |\n+--------------------------+\n|               3232235777 |\n+--------------------------+\n\nThis is calculated as follows: 192 x 2563 + 168 x 256 2 + 1 x 256 + 1\n\nURL: https://mariadb.com/kb/en/inet_aton/','','https://mariadb.com/kb/en/inet_aton/'),(151,'INET_NTOA',14,'Syntax\n------\n\nINET_NTOA(expr)\n\nDescription\n-----------\n\nGiven a numeric IPv4 network address in network byte order (4 or 8 byte),\nreturns the dotted-quad representation of the address as a string.\n\nExamples\n--------\n\nSELECT INET_NTOA(3232235777);\n+-----------------------+\n| INET_NTOA(3232235777) |\n+-----------------------+\n| 192.168.1.1           |\n+-----------------------+\n\n192.168.1.1 corresponds to 3232235777 since 192 x 2563 + 168 x 256 2 + 1 x 256\n+ 1 = 3232235777\n\nURL: https://mariadb.com/kb/en/inet_ntoa/','','https://mariadb.com/kb/en/inet_ntoa/'),(98,'SAVEPOINT',8,'Syntax\n------\n\nSAVEPOINT identifier\nROLLBACK [WORK] TO [SAVEPOINT] identifier\nRELEASE SAVEPOINT identifier\n\nDescription\n-----------\n\nInnoDB supports the SQL statements SAVEPOINT, ROLLBACK TO SAVEPOINT, RELEASE\nSAVEPOINT and the optional WORK keyword for ROLLBACK.\n\nEach savepoint must have a legal MariaDB identifier. A savepoint is a named\nsub-transaction.\n\nNormally ROLLBACK undoes the changes performed by the whole transaction. When\nused with the TO clause, it undoes the changes performed after the specified\nsavepoint, and erases all subsequent savepoints. However, all locks that have\nbeen acquired after the save point will survive. RELEASE SAVEPOINT does not\nrollback or commit any changes, but removes the specified savepoint.\n\nWhen the execution of a trigger or a stored function begins, it is not\npossible to use statements which reference a savepoint which was defined from\nout of that stored program.\n\nWhen a COMMIT (including implicit commits) or a ROLLBACK statement (with no TO\nclause) is performed, they act on the whole transaction, and all savepoints\nare removed.\n\nErrors\n------\n\nIf COMMIT or ROLLBACK is issued and no transaction was started, no error is\nreported.\n\nIf SAVEPOINT is issued and no transaction was started, no error is reported\nbut no savepoint is created. When ROLLBACK TO SAVEPOINT or RELEASE SAVEPOINT\nis called for a savepoint that does not exist, an error like this is issued:\n\nERROR 1305 (42000): SAVEPOINT svp_name does not exist\n\nURL: https://mariadb.com/kb/en/savepoint/','','https://mariadb.com/kb/en/savepoint/'),(99,'Metadata Locking',8,'MariaDB supports metadata locking. This means that when a transaction\n(including XA transactions) uses a table, it locks its metadata until the end\nof transaction. Non-transactional tables are also locked, as well as views and\nobjects which are related to locked tables/views (stored functions, triggers,\netc). When a connection tries to use a DDL statement (like an ALTER TABLE)\nwhich modifies a table that is locked, that connection is queued, and has to\nwait until it\'s unlocked. Using savepoints and performing a partial rollback\ndoes not release metadata locks.\n\nLOCK TABLES ... WRITE are also queued. Some wrong statements which produce an\nerror may not need to wait for the lock to be freed.\n\nThe metadata lock\'s timeout is determined by the value of the\nlock_wait_timeout server system variable (in seconds). However, note that its\ndefault value is 31536000 (1 year, MariaDB <= 10.2.3), or 86400 (1 day,\nMariaDB >= 10.2.4). If this timeout is exceeded, the following error is\nreturned:\n\nERROR 1205 (HY000): Lock wait timeout exceeded; try restarting transaction\n\nIf the metadata_lock_info plugin is installed, the Information Schema\nmetadata_lock_info table stores information about existing metadata locks.\n\nMariaDB starting with 10.5.2\n----------------------------\nFrom MariaDB 10.5, the Performance Schema metadata_locks table contains\nmetadata lock information.\n\nExample\n-------\n\nLet\'s use the following MEMORY (non-transactional) table:\n\nCREATE TABLE t (a INT) ENGINE = MEMORY;\n\nConnection 1 starts a transaction, and INSERTs a row into t:\n\nSTART TRANSACTION;\n\nINSERT INTO t SET a=1;\n\nt\'s metadata is now locked by connection 1. Connection 2 tries to alter t, but\nhas to wait:\n\nALTER TABLE t ADD COLUMN b INT;\n\nConnection 2\'s prompt is blocked now.\n\nNow connection 1 ends the transaction:\n\nCOMMIT;\n\n...and connection 2 finally gets the output of its command:\n\nQuery OK, 1 row affected (35.23 sec)\nRecords: 1  Duplicates: 0  Warnings: 0\n\nURL: https://mariadb.com/kb/en/metadata-locking/','','https://mariadb.com/kb/en/metadata-locking/'),(100,'Transaction Timeouts',8,'MariaDB has always had the wait_timeout and interactive_timeout settings,\nwhich close connections after a certain period of inactivity.\n\nHowever, these are by default set to a long wait period. In situations where\ntransactions may be started, but not committed or rolled back, more granular\ncontrol and a shorter timeout may be desirable so as to avoid locks being held\nfor too long.\n\nMariaDB 10.3 introduced three new variables to handle this situation.\n\n* idle_transaction_timeout (all transactions)\n* idle_write_transaction_timeout (write transactions - called\nidle_readwrite_transaction_timeout until MariaDB 10.3.2)\n* idle_readonly_transaction_timeout (read transactions)\n\nThese accept a time in seconds to time out, by closing the connection,\ntransactions that are idle for longer than this period. By default all are set\nto zero, or no timeout.\n\nidle_transaction_timeout affects all transactions,\nidle_write_transaction_timeout affects write transactions only and\nidle_readonly_transaction_timeout affects read transactions only. The latter\ntwo variables work independently. However, if either is set along with\nidle_transaction_timeout, the settings for idle_write_transaction_timeout or\nidle_readonly_transaction_timeout will take precedence.\n\nExamples\n--------\n\nSET SESSION idle_transaction_timeout=2;\nBEGIN;\nSELECT * FROM t;\nEmpty set (0.000 sec)\n## wait 3 seconds\nSELECT * FROM t;\nERROR 2006 (HY000): MySQL server has gone away\n\nSET SESSION idle_write_transaction_timeout=2;\nBEGIN;\nSELECT * FROM t;\nEmpty set (0.000 sec)\n## wait 3 seconds\nSELECT * FROM t;\nEmpty set (0.000 sec)\nINSERT INTO t VALUES(1);\n## wait 3 seconds\nSELECT * FROM t;\nERROR 2006 (HY000): MySQL server has gone away\n\nSET SESSION idle_transaction_timeout=2, SESSION\nidle_readonly_transaction_timeout=10;\nBEGIN;\nSELECT * FROM t;\nEmpty set (0.000 sec)\n ## wait 3 seconds\nSELECT * FROM t;\nEmpty set (0.000 sec)\n## wait 11 seconds\nSELECT * FROM t;\nERROR 2006 (HY000): MySQL server has gone away\n\nURL: https://mariadb.com/kb/en/transaction-timeouts/','','https://mariadb.com/kb/en/transaction-timeouts/'),(152,'IS_FREE_LOCK',14,'Syntax\n------\n\nIS_FREE_LOCK(str)\n\nDescription\n-----------\n\nChecks whether the lock named str is free to use (that is, not locked).\nReturns 1 if the lock is free (no one is using the lock), 0 if the lock is in\nuse, and NULL if an error occurs (such as an incorrect argument, like an empty\nstring or NULL). str is case insensitive.\n\nIf the metadata_lock_info plugin is installed, the Information Schema\nmetadata_lock_info table contains information about locks of this kind (as\nwell as metadata locks).\n\nStatements using the IS_FREE_LOCK function are not safe for statement-based\nreplication.\n\nURL: https://mariadb.com/kb/en/is_free_lock/','','https://mariadb.com/kb/en/is_free_lock/'),(156,'IS_IPV6',14,'Syntax\n------\n\nIS_IPV6(expr)\n\nDescription\n-----------\n\nReturns 1 if the expression is a valid IPv6 address specified as a string,\notherwise returns 0. Does not consider IPv4 addresses to be valid IPv6\naddresses.\n\nExamples\n--------\n\nSELECT IS_IPV6(\'48f3::d432:1431:ba23:846f\');\n+--------------------------------------+\n| IS_IPV6(\'48f3::d432:1431:ba23:846f\') |\n+--------------------------------------+\n|                                    1 |\n+--------------------------------------+\n1 row in set (0.02 sec)\n\nSELECT IS_IPV6(\'10.0.1.1\');\n+---------------------+\n| IS_IPV6(\'10.0.1.1\') |\n+---------------------+\n|                   0 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/is_ipv6/','','https://mariadb.com/kb/en/is_ipv6/'),(157,'IS_USED_LOCK',14,'Syntax\n------\n\nIS_USED_LOCK(str)\n\nDescription\n-----------\n\nChecks whether the lock named str is in use (that is, locked). If so, it\nreturns the connection identifier of the client that holds the lock.\nOtherwise, it returns NULL. str is case insensitive.\n\nIf the metadata_lock_info plugin is installed, the Information Schema\nmetadata_lock_info table contains information about locks of this kind (as\nwell as metadata locks).\n\nStatements using the IS_USED_LOCK function are not safe for statement-based\nreplication.\n\nURL: https://mariadb.com/kb/en/is_used_lock/','','https://mariadb.com/kb/en/is_used_lock/'),(102,'WAIT and NOWAIT',8,'MariaDB starting with 10.3.0\n----------------------------\nMariaDB 10.3.0 introduced extended syntax so that it is possible to set\ninnodb_lock_wait_timeout and lock_wait_timeout for the following statements:\n\nSyntax\n------\n\nALTER TABLE tbl_name [WAIT n|NOWAIT] ...\nCREATE ... INDEX ON tbl_name (index_col_name, ...) [WAIT n|NOWAIT] ...\nDROP INDEX ... [WAIT n|NOWAIT]\nDROP TABLE tbl_name [WAIT n|NOWAIT] ...\nLOCK TABLE ... [WAIT n|NOWAIT]\nOPTIMIZE TABLE tbl_name [WAIT n|NOWAIT]\nRENAME TABLE tbl_name [WAIT n|NOWAIT] ...\nSELECT ... FOR UPDATE [WAIT n|NOWAIT]\nSELECT ... LOCK IN SHARE MODE [WAIT n|NOWAIT]\nTRUNCATE TABLE tbl_name [WAIT n|NOWAIT]\n\nDescription\n-----------\n\nThe lock wait timeout can be explicitly set in the statement by using either\nWAIT n (to set the wait in seconds) or NOWAIT, in which case the statement\nwill immediately fail if the lock cannot be obtained. WAIT 0 is equivalent to\nNOWAIT.\n\nURL: https://mariadb.com/kb/en/wait-and-nowait/','','https://mariadb.com/kb/en/wait-and-nowait/'),(106,'DROP USER',10,'Syntax\n------\n\nDROP USER [IF EXISTS] user_name [, user_name] ...\n\nDescription\n-----------\n\nThe DROP USER statement removes one or more MariaDB accounts. It removes\nprivilege rows for the account from all grant tables. To use this statement,\nyou must have the global CREATE USER privilege or the DELETE privilege for the\nmysql database. Each account is named using the same format as for the CREATE\nUSER statement; for example, \'jeffrey\'@\'localhost\'. If you specify only the\nuser name part of the account name, a host name part of \'%\' is used. For\nadditional information about specifying account names, see CREATE USER.\n\nNote that, if you specify an account that is currently connected, it will not\nbe deleted until the connection is closed. The connection will not be\nautomatically closed.\n\nIf any of the specified user accounts do not exist, ERROR 1396 (HY000)\nresults. If an error occurs, DROP USER will still drop the accounts that do\nnot result in an error. Only one error is produced for all users which have\nnot been dropped:\n\nERROR 1396 (HY000): Operation DROP USER failed for \'u1\'@\'%\',\'u2\'@\'%\'\n\nFailed CREATE or DROP operations, for both users and roles, produce the same\nerror code.\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the user does not exist.\n\nExamples\n--------\n\nDROP USER bob;\n\nDROP USER foo2@localhost,foo2@\'127.%\';\n\nIF EXISTS:\n\nDROP USER bob;\nERROR 1396 (HY000): Operation DROP USER failed for \'bob\'@\'%\'\n\nDROP USER IF EXISTS bob;\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+---------------------------------------------+\n| Level | Code | Message                                     |\n+-------+------+---------------------------------------------+\n| Note  | 1974 | Can\'t drop user \'bob\'@\'%\'; it doesn\'t exist |\n+-------+------+---------------------------------------------+\n\nURL: https://mariadb.com/kb/en/drop-user/','','https://mariadb.com/kb/en/drop-user/'),(108,'RENAME USER',10,'Syntax\n------\n\nRENAME USER old_user TO new_user\n  [, old_user TO new_user] ...\n\nDescription\n-----------\n\nThe RENAME USER statement renames existing MariaDB accounts. To use it, you\nmust have the global CREATE USER privilege or the UPDATE privilege for the\nmysql database. Each account is named using the same format as for the CREATE\nUSER statement; for example, \'jeffrey\'@\'localhost\'. If you specify only the\nuser name part of the account name, a host name part of \'%\' is used.\n\nIf any of the old user accounts do not exist or any of the new user accounts\nalready exist, ERROR 1396 (HY000) results. If an error occurs, RENAME USER\nwill still rename the accounts that do not result in an error.\n\nExamples\n--------\n\nCREATE USER \'donald\', \'mickey\';\nRENAME USER \'donald\' TO \'duck\'@\'localhost\', \'mickey\' TO \'mouse\'@\'localhost\';\n\nURL: https://mariadb.com/kb/en/rename-user/','','https://mariadb.com/kb/en/rename-user/'),(109,'REVOKE',10,'Privileges\n----------\n\nSyntax\n------\n\nREVOKE \n  priv_type [(column_list)]\n   [, priv_type [(column_list)]] ...\n  ON [object_type] priv_level\n  FROM user [, user] ...\n\nREVOKE ALL PRIVILEGES, GRANT OPTION\n  FROM user [, user] ...\n\nDescription\n-----------\n\nThe REVOKE statement enables system administrators to revoke privileges (or\nroles - see section below) from MariaDB accounts. Each account is named using\nthe same format as for the GRANT statement; for example,\n\'jeffrey\'@\'localhost\'. If you specify only the user name part of the account\nname, a host name part of \'%\' is used. For details on the levels at which\nprivileges exist, the allowable priv_type and priv_level values, and the\nsyntax for specifying users and passwords, see GRANT.\n\nTo use the first REVOKE syntax, you must have the GRANT OPTION privilege, and\nyou must have the privileges that you are revoking.\n\nTo revoke all privileges, use the second syntax, which drops all global,\ndatabase, table, column, and routine privileges for the named user or users:\n\nREVOKE ALL PRIVILEGES, GRANT OPTION FROM user [, user] ...\n\nTo use this REVOKE syntax, you must have the global CREATE USER privilege or\nthe UPDATE privilege for the mysql database. See GRANT.\n\nExamples\n--------\n\nREVOKE SUPER ON *.* FROM \'alexander\'@\'localhost\';\n\nRoles\n-----\n\nSyntax\n------\n\nREVOKE role  [, role ...]\n  FROM grantee [, grantee2 ... ]\n\nREVOKE ADMIN OPTION FOR role FROM grantee [, grantee2]\n\nDescription\n-----------\n\nREVOKE is also used to remove a role from a user or another role that it\'s\npreviously been assigned to. If a role has previously been set as a default\nrole, REVOKE does not remove the record of the default role from the\nmysql.user table. If the role is subsequently granted again, it will again be\nthe user\'s default. Use SET DEFAULT ROLE NONE to explicitly remove this.\n\nBefore MariaDB 10.1.13, the REVOKE role statement was not permitted in\nprepared statements.\n\nExample\n-------\n\nREVOKE journalist FROM hulda\n\nURL: https://mariadb.com/kb/en/revoke/','','https://mariadb.com/kb/en/revoke/'),(160,'NAME_CONST',14,'Syntax\n------\n\nNAME_CONST(name,value)\n\nDescription\n-----------\n\nReturns the given value. When used to produce a result set column,\nNAME_CONST() causes the column to have the given name. The arguments should be\nconstants.\n\nThis function is used internally when replicating stored procedures. It makes\nlittle sense to use it explicitly in SQL statements, and it was not supposed\nto be used like that.\n\nSELECT NAME_CONST(\'myname\', 14);\n+--------+\n| myname |\n+--------+\n|     14 |\n+--------+\n\nURL: https://mariadb.com/kb/en/name_const/','','https://mariadb.com/kb/en/name_const/'),(163,'SLEEP',14,'Syntax\n------\n\nSLEEP(duration)\n\nDescription\n-----------\n\nSleeps (pauses) for the number of seconds given by the duration argument, then\nreturns 0. If SLEEP() is interrupted, it returns 1. The duration may have a\nfractional part given in microseconds.\n\nStatements using the SLEEP() function are not safe for replication.\n\nExample\n-------\n\nSELECT SLEEP(5.5);\n+------------+\n| SLEEP(5.5) |\n+------------+\n|          0 |\n+------------+\n1 row in set (5.50 sec)\n\nURL: https://mariadb.com/kb/en/sleep/','','https://mariadb.com/kb/en/sleep/'),(167,'!',15,'Syntax\n------\n\nNOT, !\n\nDescription\n-----------\n\nLogical NOT. Evaluates to 1 if the operand is 0, to 0 if the operand is\nnon-zero, and NOT NULL returns NULL.\n\nBy default, the ! operator has a higher precedence. If the HIGH_NOT_PRECEDENCE\nSQL_MODE flag is set, NOT and ! have the same precedence.\n\nExamples\n--------\n\nSELECT NOT 10;\n+--------+\n| NOT 10 |\n+--------+\n|      0 |\n+--------+\n\nSELECT NOT 0;\n+-------+\n| NOT 0 |\n+-------+\n|     1 |\n+-------+\n\nSELECT NOT NULL;\n+----------+\n| NOT NULL |\n+----------+\n|     NULL |\n+----------+\n\nSELECT ! (1+1);\n+---------+\n| ! (1+1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ! 1+1;\n+-------+\n| ! 1+1 |\n+-------+\n|     1 |\n+-------+\n\nURL: https://mariadb.com/kb/en/not/','','https://mariadb.com/kb/en/not/'),(110,'SET PASSWORD',10,'Syntax\n------\n\nSET PASSWORD [FOR user] =\n  {\n    PASSWORD(\'some password\')\n   | OLD_PASSWORD(\'some password\')\n   | \'encrypted password\'\n  }\n\nDescription\n-----------\n\nThe SET PASSWORD statement assigns a password to an existing MariaDB user\naccount.\n\nIf the password is specified using the PASSWORD() or OLD_PASSWORD() function,\nthe literal text of the password should be given. If the password is specified\nwithout using either function, the password should be the already-encrypted\npassword value as returned by PASSWORD().\n\nOLD_PASSWORD() should only be used if your MariaDB/MySQL clients are very old\n(< 4.0.0).\n\nWith no FOR clause, this statement sets the password for the current user. Any\nclient that has connected to the server using a non-anonymous account can\nchange the password for that account.\n\nWith a FOR clause, this statement sets the password for a specific account on\nthe current server host. Only clients that have the UPDATE privilege for the\nmysql database can do this. The user value should be given in\nuser_name@host_name format, where user_name and host_name are exactly as they\nare listed in the User and Host columns of the mysql.user table (or view in\nMariaDB-10.4 onwards) entry.\n\nThe argument to PASSWORD() and the password given to MariaDB clients can be of\narbitrary length.\n\nAuthentication Plugin Support\n-----------------------------\n\nMariaDB starting with 10.4\n--------------------------\nIn MariaDB 10.4 and later, SET PASSWORD (with or without PASSWORD()) works for\naccounts authenticated via any authentication plugin that supports passwords\nstored in the mysql.global_priv table.\n\nThe ed25519, mysql_native_password, and mysql_old_password authentication\nplugins store passwords in the mysql.global_priv table.\n\nIf you run SET PASSWORD on an account that authenticates with one of these\nauthentication plugins that stores passwords in the mysql.global_priv table,\nthen the PASSWORD() function is evaluated by the specific authentication\nplugin used by the account. The authentication plugin hashes the password with\na method that is compatible with that specific authentication plugin.\n\nThe unix_socket, named_pipe, gssapi, and pam authentication plugins do not\nstore passwords in the mysql.global_priv table. These authentication plugins\nrely on other methods to authenticate the user.\n\nIf you attempt to run SET PASSWORD on an account that authenticates with one\nof these authentication plugins that doesn\'t store a password in the\nmysql.global_priv table, then MariaDB Server will raise a warning like the\nfollowing:\n\nSET PASSWORD is ignored for users authenticating via unix_socket plugin\n\nSee Authentication from MariaDB 10.4 for an overview of authentication changes\nin MariaDB 10.4.\n\nMariaDB until 10.3\n------------------\nIn MariaDB 10.3 and before, SET PASSWORD (with or without PASSWORD()) only\nworks for accounts authenticated via mysql_native_password or\nmysql_old_password authentication plugins\n\nPasswordless User Accounts\n--------------------------\n\nUser accounts do not always require passwords to login.\n\nThe unix_socket , named_pipe and gssapi authentication plugins do not require\na password to authenticate the user.\n\nThe pam authentication plugin may or may not require a password to\nauthenticate the user, depending on the specific configuration.\n\nThe mysql_native_password and mysql_old_password authentication plugins\nrequire passwords for authentication, but the password can be blank. In that\ncase, no password is required.\n\nIf you provide a password while attempting to log into the server as an\naccount that doesn\'t require a password, then MariaDB server will simply\nignore the password.\n\nMariaDB starting with 10.4\n--------------------------\nIn MariaDB 10.4 and later, a user account can be defined to use multiple\nauthentication plugins in a specific order of preference. This specific\nscenario may be more noticeable in these versions, since an account could be\nassociated with some authentication plugins that require a password, and some\nthat do not.\n\nExample\n-------\n\nFor example, if you had an entry with User and Host column values of \'bob\' and\n\'%.loc.gov\', you would write the statement like this:\n\nSET PASSWORD FOR \'bob\'@\'%.loc.gov\' = PASSWORD(\'newpass\');\n\nIf you want to delete a password for a user, you would do:\n\nSET PASSWORD FOR \'bob\'@localhost = PASSWORD(\"\");\n\nURL: https://mariadb.com/kb/en/set-password/','','https://mariadb.com/kb/en/set-password/'),(112,'DROP ROLE',10,'Syntax\n------\n\nDROP ROLE [IF EXISTS] role_name [,role_name ...]\n\nDescription\n-----------\n\nThe DROP ROLE statement removes one or more MariaDB roles. To use this\nstatement, you must have the global CREATE USER privilege or the DELETE\nprivilege for the mysql database.\n\nDROP ROLE does not disable roles for connections which selected them with SET\nROLE. If a role has previously been set as a default role, DROP ROLE does not\nremove the record of the default role from the mysql.user table. If the role\nis subsequently recreated and granted, it will again be the user\'s default.\nUse SET DEFAULT ROLE NONE to explicitly remove this.\n\nIf any of the specified user accounts do not exist, ERROR 1396 (HY000)\nresults. If an error occurs, DROP ROLE will still drop the roles that do not\nresult in an error. Only one error is produced for all roles which have not\nbeen dropped:\n\nERROR 1396 (HY000): Operation DROP ROLE failed for \'a\',\'b\',\'c\'\n\nFailed CREATE or DROP operations, for both users and roles, produce the same\nerror code.\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a warning instead of an\nerror if the role does not exist.\n\nExamples\n--------\n\nDROP ROLE journalist;\n\nThe same thing using the optional IF EXISTS clause:\n\nDROP ROLE journalist;\nERROR 1396 (HY000): Operation DROP ROLE failed for \'journalist\'\n\nDROP ROLE IF EXISTS journalist;\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nNote (Code 1975): Can\'t drop role \'journalist\'; it doesn\'t exist\n\nURL: https://mariadb.com/kb/en/drop-role/','','https://mariadb.com/kb/en/drop-role/'),(168,'&&',15,'Syntax\n------\n\nAND, &&\n\nDescription\n-----------\n\nLogical AND. Evaluates to 1 if all operands are non-zero and not NULL, to 0 if\none or more operands are 0, otherwise NULL is returned.\n\nFor this operator, short-circuit evaluation can be used.\n\nExamples\n--------\n\nSELECT 1 && 1;\n+--------+\n| 1 && 1 |\n+--------+\n|      1 |\n+--------+\n\nSELECT 1 && 0;\n+--------+\n| 1 && 0 |\n+--------+\n|      0 |\n+--------+\n\nSELECT 1 && NULL;\n+-----------+\n| 1 && NULL |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT 0 && NULL;\n+-----------+\n| 0 && NULL |\n+-----------+\n|         0 |\n+-----------+\n\nSELECT NULL && 0;\n+-----------+\n| NULL && 0 |\n+-----------+\n|         0 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/and/','','https://mariadb.com/kb/en/and/'),(169,'XOR',15,'Syntax\n------\n\nXOR\n\nDescription\n-----------\n\nXOR stands for eXclusive OR. Returns NULL if either operand is NULL. For\nnon-NULL operands, evaluates to 1 if an odd number of operands is non-zero,\notherwise 0 is returned.\n\nExamples\n--------\n\nSELECT 1 XOR 1;\n+---------+\n| 1 XOR 1 |\n+---------+\n|       0 |\n+---------+\n\nSELECT 1 XOR 0;\n+---------+\n| 1 XOR 0 |\n+---------+\n|       1 |\n+---------+\n\nSELECT 1 XOR NULL;\n+------------+\n| 1 XOR NULL |\n+------------+\n|       NULL |\n+------------+\n\nIn the following example, the right 1 XOR 1 is evaluated first, and returns 0.\nThen, 1 XOR 0 is evaluated, and 1 is returned.\n\nSELECT 1 XOR 1 XOR 1;\n+---------------+\n| 1 XOR 1 XOR 1 |\n+---------------+\n|             1 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/xor/','','https://mariadb.com/kb/en/xor/'),(111,'CREATE ROLE',10,'Syntax\n------\n\nCREATE [OR REPLACE] ROLE [IF NOT EXISTS] role \n [WITH ADMIN\n  {CURRENT_USER | CURRENT_ROLE | user | role}]\n\nDescription\n-----------\n\nThe CREATE ROLE statement creates one or more MariaDB roles. To use it, you\nmust have the global CREATE USER privilege or the INSERT privilege for the\nmysql database. For each account, CREATE ROLE creates a new row in the\nmysql.user table that has no privileges, and with the corresponding is_role\nfield set to Y. It also creates a record in the mysql.roles_mapping table.\n\nIf any of the specified roles already exist, ERROR 1396 (HY000) results. If an\nerror occurs, CREATE ROLE will still create the roles that do not result in an\nerror. The maximum length for a role is 128 characters. Role names can be\nquoted, as explained in the Identifier names page. Only one error is produced\nfor all roles which have not been created:\n\nERROR 1396 (HY000): Operation CREATE ROLE failed for \'a\',\'b\',\'c\'\n\nFailed CREATE or DROP operations, for both users and roles, produce the same\nerror code.\n\nPUBLIC and NONE are reserved, and cannot be used as role names. NONE is used\nto unset a role and PUBLIC has a special use in other systems, such as Oracle,\nso is reserved for compatibility purposes.\n\nFor valid identifiers to use as role names, see Identifier Names.\n\nWITH ADMIN\n----------\n\nThe optional WITH ADMIN clause determines whether the current user, the\ncurrent role or another user or role has use of the newly created role. If the\nclause is omitted, WITH ADMIN CURRENT_USER is treated as the default, which\nmeans that the current user will be able to GRANT this role to users.\n\nOR REPLACE\n----------\n\nIf the optional OR REPLACE clause is used, it acts as a shortcut for:\n\nDROP ROLE IF EXISTS name;\nCREATE ROLE name ...;\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a warning instead\nof an error if the specified role already exists. Cannot be used together with\nthe OR REPLACE clause.\n\nExamples\n--------\n\nCREATE ROLE journalist;\n\nCREATE ROLE developer WITH ADMIN lorinda@localhost;\n\nGranting the role to another user. Only user lorinda@localhost has permission\nto grant the developer role:\n\nSELECT USER();\n+-------------------+\n| USER()            |\n+-------------------+\n| henning@localhost |\n+-------------------+\n...\nGRANT developer TO ian@localhost;\nAccess denied for user \'henning\'@\'localhost\'\n\nSELECT USER();\n+-------------------+\n| USER()            |\n+-------------------+\n| lorinda@localhost |\n+-------------------+\n\nGRANT m_role TO ian@localhost;\n\nThe OR REPLACE and IF NOT EXISTS clauses. The journalist role already exists:\n\nCREATE ROLE journalist;\nERROR 1396 (HY000): Operation CREATE ROLE failed for \'journalist\'\n\nCREATE OR REPLACE ROLE journalist;\nQuery OK, 0 rows affected (0.00 sec)\n\nCREATE ROLE IF NOT EXISTS journalist;\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+---------------------------------------------------+\n| Level | Code | Message                                           |\n+-------+------+---------------------------------------------------+\n| Note  | 1975 | Can\'t create role \'journalist\'; it already exists |\n+-------+------+---------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/create-role/','','https://mariadb.com/kb/en/create-role/'),(113,'SET ROLE',10,'Syntax\n------\n\nSET ROLE { role | NONE }\n\nDescription\n-----------\n\nThe SET ROLE statement enables a role, along with all of its associated\npermissions, for the current session. To unset a role, use NONE .\n\nIf a role that doesn\'t exist, or to which the user has not been assigned, is\nspecified, an ERROR 1959 (OP000): Invalid role specification error occurs.\n\nAn automatic SET ROLE is implicitly performed when a use