/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `barbican`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `barbican` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `barbican`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('8c74e2d7f1ff');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authorities`
--

DROP TABLE IF EXISTS `certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `plugin_ca_id` text NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cas_project_fk` (`project_id`),
  CONSTRAINT `cas_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authorities`
--

LOCK TABLES `certificate_authorities` WRITE;
/*!40000 ALTER TABLE `certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authority_metadata`
--

DROP TABLE IF EXISTS `certificate_authority_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authority_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_certificate_authority_metadatum_uc` (`ca_id`,`key`),
  KEY `ix_certificate_authority_metadata_ca_id` (`ca_id`),
  KEY `ix_certificate_authority_metadata_key` (`key`),
  CONSTRAINT `certificate_authority_metadata_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authority_metadata`
--

LOCK TABLES `certificate_authority_metadata` WRITE;
/*!40000 ALTER TABLE `certificate_authority_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authority_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acl_users`
--

DROP TABLE IF EXISTS `container_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_container_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `container_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `container_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acl_users`
--

LOCK TABLES `container_acl_users` WRITE;
/*!40000 ALTER TABLE `container_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acls`
--

DROP TABLE IF EXISTS `container_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_operation_uc` (`container_id`,`operation`),
  KEY `ix_container_acls_container_id` (`container_id`),
  CONSTRAINT `container_acls_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acls`
--

LOCK TABLES `container_acls` WRITE;
/*!40000 ALTER TABLE `container_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_consumer_metadata`
--

DROP TABLE IF EXISTS `container_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `name` varchar(36) DEFAULT NULL,
  `URL` varchar(255) DEFAULT NULL,
  `data_hash` char(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_consumer_hashed_container_name_url_uc` (`data_hash`),
  KEY `ix_container_consumer_metadata_container_id` (`container_id`),
  KEY `ix_container_consumer_metadata_project_id` (`project_id`),
  KEY `values_index` (`container_id`,`name`,`URL`),
  CONSTRAINT `container_consumer_metadata_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_consumer_metadata_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_consumer_metadata`
--

LOCK TABLES `container_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `container_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_secret`
--

DROP TABLE IF EXISTS `container_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_secret` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `container_id` varchar(36) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_secret_name_uc` (`container_id`,`secret_id`,`name`),
  KEY `ix_container_secret_container_id` (`container_id`),
  KEY `ix_container_secret_secret_id` (`secret_id`),
  CONSTRAINT `container_secret_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_secret_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_secret`
--

LOCK TABLES `container_secret` WRITE;
/*!40000 ALTER TABLE `container_secret` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `containers`
--

DROP TABLE IF EXISTS `containers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `containers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('generic','rsa','dsa','certificate') DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_containers_project_id` (`project_id`),
  CONSTRAINT `containers_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `containers`
--

LOCK TABLES `containers` WRITE;
/*!40000 ALTER TABLE `containers` DISABLE KEYS */;
/*!40000 ALTER TABLE `containers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encrypted_data`
--

DROP TABLE IF EXISTS `encrypted_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encrypted_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `secret_id` varchar(36) NOT NULL,
  `kek_id` varchar(36) NOT NULL,
  `cypher_text` text DEFAULT NULL,
  `kek_meta_extended` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_encrypted_data_kek_id` (`kek_id`),
  KEY `ix_encrypted_data_secret_id` (`secret_id`),
  CONSTRAINT `encrypted_data_ibfk_1` FOREIGN KEY (`kek_id`) REFERENCES `kek_data` (`id`),
  CONSTRAINT `encrypted_data_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encrypted_data`
--

LOCK TABLES `encrypted_data` WRITE;
/*!40000 ALTER TABLE `encrypted_data` DISABLE KEYS */;
INSERT INTO `encrypted_data` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `content_type`, `secret_id`, `kek_id`, `cypher_text`, `kek_meta_extended`) VALUES ('4dcce2fc-738c-461c-b897-469a6c28e182','2025-11-29 08:46:18','2025-11-29 08:47:01','2025-11-29 08:47:01',1,'ACTIVE','application/octet-stream','091a9a2e-d1cc-44d2-be96-b1719b550e5c','b39375e6-38fe-43bd-a2de-310e23bfa4e7','Z0FBQUFBQnBLckxheEhzTm5KZDhKQmllbEFoSHhodVN5WlFaSV9BUTlZeWdrLWRuZUZWMDVWdmk2WVc1SlRUR1VCQmJoV01uWVNUOHFEX3d6cGhjLU1raTQwNHNPcW1QMlltaWw3WWhGdE1yM0tGN1NRU3pvZzZ4eGhUQjFfY0pLdlpiMmY2ZXBfTHU=',NULL),('e8378afb-347d-425f-a76e-870dd99e89ec','2025-11-29 08:41:40','2025-11-29 08:42:49','2025-11-29 08:42:49',1,'ACTIVE','application/octet-stream','f1784f4d-bd83-4c57-a711-5366b7510394','18b062b9-79e9-499d-be49-45eccf959383','Z0FBQUFBQnBLckhFdzB4UTNhbU1jMDZWdS1HclNxeGJnamJqLVdhalFaTGxMYXAzNUdaV3l6N0c1cWpMVHppbndReENDaXh2Z09pcF92Njg5TTBLNjlzZkU4YktMVE5sbTJ4YlJwSkhmZzhSMnlncDRvSnN0NlhETVljY1BFQ19RUFdPZlVUdGVqQ1A=',NULL);
/*!40000 ALTER TABLE `encrypted_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kek_data`
--

DROP TABLE IF EXISTS `kek_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kek_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `kek_label` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `bind_completed` tinyint(1) NOT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `plugin_meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_kek_data_project_id` (`project_id`),
  CONSTRAINT `kek_data_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kek_data`
--

LOCK TABLES `kek_data` WRITE;
/*!40000 ALTER TABLE `kek_data` DISABLE KEYS */;
INSERT INTO `kek_data` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `plugin_name`, `kek_label`, `project_id`, `active`, `bind_completed`, `algorithm`, `bit_length`, `mode`, `plugin_meta`) VALUES ('18b062b9-79e9-499d-be49-45eccf959383','2025-11-29 08:41:40','2025-11-29 08:43:08','2025-11-29 08:43:08',1,'ACTIVE','barbican.plugin.crypto.simple_crypto.SimpleCryptoPlugin','project-c80b570a17ee4094b96a75465fc34ae7-key-4d839413-17b3-4cc3-ac75-b9d618f47a92','1155968a-5b13-4041-945e-d24bacd2d304',1,1,'aes',128,'cbc','gAAAAABpKrHEmoN9Hz2-cjuQg35gjxBlZIyFjmatFlDbqxXfRWuHVdzhw8z9vNnrZt028BCsYC6M6mmxYOhpP87eBFdcjD_tmsz0H-ObpO7kdGVFHOZ6Mco-mRLS-rVax2fE_0b2HcGC'),('b39375e6-38fe-43bd-a2de-310e23bfa4e7','2025-11-29 08:46:18','2025-11-29 08:53:19','2025-11-29 08:53:19',1,'ACTIVE','barbican.plugin.crypto.simple_crypto.SimpleCryptoPlugin','project-b7ffcb23bac14ee49474df9aee5f7dae-key-4f615c63-550c-47a2-863e-93de2db2c936','899fa3bf-6fc2-451e-ae44-1e5826eef71b',1,1,'aes',128,'cbc','gAAAAABpKrLatTgKqlUR6QGNuLQcvYN9sjjQ4RM2o-7X7ZXnG-YYbIaBdeyCM9HKPF8mBgnQWst75BM4P-yM-EjPqKfls47D-BrH5JkmdQ41hzQQKdFO_K3sq_ffRIO4XGIRCszqxWRs');
/*!40000 ALTER TABLE `kek_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_barbican_metadata`
--

DROP TABLE IF EXISTS `order_barbican_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_barbican_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_barbican_metadata_order_id` (`order_id`),
  CONSTRAINT `order_barbican_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_barbican_metadata`
--

LOCK TABLES `order_barbican_metadata` WRITE;
/*!40000 ALTER TABLE `order_barbican_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_barbican_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_plugin_metadata`
--

DROP TABLE IF EXISTS `order_plugin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_plugin_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_plugin_metadata_order_id` (`order_id`),
  CONSTRAINT `order_plugin_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_plugin_metadata`
--

LOCK TABLES `order_plugin_metadata` WRITE;
/*!40000 ALTER TABLE `order_plugin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_plugin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_retry_tasks`
--

DROP TABLE IF EXISTS `order_retry_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_retry_tasks` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `id` varchar(36) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `retry_task` text NOT NULL,
  `retry_at` datetime NOT NULL,
  `retry_args` text NOT NULL,
  `retry_kwargs` text NOT NULL,
  `retry_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_retry_tasks_order_id` (`order_id`),
  CONSTRAINT `order_retry_tasks_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_retry_tasks`
--

LOCK TABLES `order_retry_tasks` WRITE;
/*!40000 ALTER TABLE `order_retry_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_retry_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `error_status_code` varchar(16) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  `secret_id` varchar(36) DEFAULT NULL,
  `container_id` varchar(36) DEFAULT NULL,
  `sub_status` varchar(36) DEFAULT NULL,
  `sub_status_message` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_orders_container_id` (`container_id`),
  KEY `ix_orders_project_id` (`project_id`),
  KEY `ix_orders_secret_id` (`secret_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`),
  CONSTRAINT `orders_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
INSERT INTO `orders` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `type`, `project_id`, `error_status_code`, `error_reason`, `meta`, `secret_id`, `container_id`, `sub_status`, `sub_status_message`, `creator_id`) VALUES ('537b56c1-909a-4148-8961-9c648c95ba47','2025-11-29 08:41:40','2025-11-29 08:41:40',NULL,0,'ACTIVE','key','1155968a-5b13-4041-945e-d24bacd2d304',NULL,NULL,'{\"algorithm\": \"aes\", \"bit_length\": 256, \"name\": null, \"expiration\": null}','f1784f4d-bd83-4c57-a711-5366b7510394',NULL,'Unknown','Unknown','ea98d0ceb3954515a9c726d0d32d30cb'),('a84cd04d-e959-496b-92eb-d531f490abc2','2025-11-29 08:46:18','2025-11-29 08:46:18',NULL,0,'ACTIVE','key','899fa3bf-6fc2-451e-ae44-1e5826eef71b',NULL,NULL,'{\"algorithm\": \"aes\", \"bit_length\": 256, \"name\": null, \"expiration\": null}','091a9a2e-d1cc-44d2-be96-b1719b550e5c',NULL,'Unknown','Unknown','b576a51181b5425aa6e44a0eb0a22803');
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preferred_certificate_authorities`
--

DROP TABLE IF EXISTS `preferred_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `preferred_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_preferred_certificate_authorities_project_id` (`project_id`),
  KEY `ix_preferred_certificate_authorities_ca_id` (`ca_id`),
  CONSTRAINT `preferred_certificate_authorities_fk` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `preferred_certificate_authorities_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preferred_certificate_authorities`
--

LOCK TABLES `preferred_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `preferred_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `preferred_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_certificate_authorities`
--

DROP TABLE IF EXISTS `project_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_certificate_authority_uc` (`project_id`,`ca_id`),
  KEY `ix_project_certificate_authorities_ca_id` (`ca_id`),
  KEY `ix_project_certificate_authorities_project_id` (`project_id`),
  CONSTRAINT `project_certificate_authorities_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `project_certificate_authorities_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_certificate_authorities`
--

LOCK TABLES `project_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `project_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_quotas`
--

DROP TABLE IF EXISTS `project_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_quotas` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `secrets` int(11) DEFAULT NULL,
  `orders` int(11) DEFAULT NULL,
  `containers` int(11) DEFAULT NULL,
  `consumers` int(11) DEFAULT NULL,
  `cas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_project_quotas_project_id` (`project_id`),
  CONSTRAINT `project_quotas_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_quotas`
--

LOCK TABLES `project_quotas` WRITE;
/*!40000 ALTER TABLE `project_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_secret_store`
--

DROP TABLE IF EXISTS `project_secret_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_secret_store` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_store_id` varchar(36) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_secret_store_project_uc` (`project_id`),
  KEY `ix_project_secret_store_project_id` (`project_id`),
  KEY `ix_project_secret_store_secret_store_id` (`secret_store_id`),
  CONSTRAINT `project_secret_store_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `project_secret_store_ibfk_2` FOREIGN KEY (`secret_store_id`) REFERENCES `secret_stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_secret_store`
--

LOCK TABLES `project_secret_store` WRITE;
/*!40000 ALTER TABLE `project_secret_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_secret_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `external_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
INSERT INTO `projects` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `external_id`) VALUES ('1155968a-5b13-4041-945e-d24bacd2d304','2025-11-29 08:41:40','2025-11-29 08:43:08','2025-11-29 08:43:08',1,'ACTIVE','c80b570a17ee4094b96a75465fc34ae7'),('899fa3bf-6fc2-451e-ae44-1e5826eef71b','2025-11-29 08:46:18','2025-11-29 08:53:19','2025-11-29 08:53:19',1,'ACTIVE','b7ffcb23bac14ee49474df9aee5f7dae');
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acl_users`
--

DROP TABLE IF EXISTS `secret_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_secret_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `secret_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `secret_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acl_users`
--

LOCK TABLES `secret_acl_users` WRITE;
/*!40000 ALTER TABLE `secret_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acls`
--

DROP TABLE IF EXISTS `secret_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_operation_uc` (`secret_id`,`operation`),
  KEY `ix_secret_acls_secret_id` (`secret_id`),
  CONSTRAINT `secret_acls_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acls`
--

LOCK TABLES `secret_acls` WRITE;
/*!40000 ALTER TABLE `secret_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_consumer_metadata`
--

DROP TABLE IF EXISTS `secret_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `service` varchar(255) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_consumer_resource_uc` (`secret_id`,`service`,`resource_type`,`resource_id`),
  KEY `ix_secret_consumer_metadata_resource_id` (`resource_id`),
  KEY `ix_secret_consumer_metadata_secret_id` (`secret_id`),
  KEY `ix_secret_consumer_metadata_project_id` (`project_id`),
  CONSTRAINT `fk_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `secret_consumer_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_consumer_metadata`
--

LOCK TABLES `secret_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `secret_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_store_metadata`
--

DROP TABLE IF EXISTS `secret_store_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_store_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secret_store_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_store_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_store_metadata`
--

LOCK TABLES `secret_store_metadata` WRITE;
/*!40000 ALTER TABLE `secret_store_metadata` DISABLE KEYS */;
INSERT INTO `secret_store_metadata` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `key`, `value`, `secret_id`) VALUES ('0658849b-5249-44b3-92c1-a9683bccf89e','2025-11-29 08:41:40','2025-11-29 08:42:49','2025-11-29 08:42:49',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','f1784f4d-bd83-4c57-a711-5366b7510394'),('4af98581-2bf7-46c4-9b18-56081b0136ce','2025-11-29 08:41:40','2025-11-29 08:42:49','2025-11-29 08:42:49',1,'PENDING','content_type','application/octet-stream','f1784f4d-bd83-4c57-a711-5366b7510394'),('eccb6279-9855-4b51-aa7e-4036f0526976','2025-11-29 08:46:18','2025-11-29 08:47:01','2025-11-29 08:47:01',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','091a9a2e-d1cc-44d2-be96-b1719b550e5c'),('fc5a91a2-cf6b-44cb-a6cd-d683fcdf00b5','2025-11-29 08:46:18','2025-11-29 08:47:01','2025-11-29 08:47:01',1,'PENDING','content_type','application/octet-stream','091a9a2e-d1cc-44d2-be96-b1719b550e5c');
/*!40000 ALTER TABLE `secret_store_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_stores`
--

DROP TABLE IF EXISTS `secret_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_stores` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `store_plugin` varchar(255) NOT NULL,
  `crypto_plugin` varchar(255) DEFAULT NULL,
  `global_default` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_stores_name_uc` (`name`),
  UNIQUE KEY `_secret_stores_plugin_names_uc` (`store_plugin`,`crypto_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_stores`
--

LOCK TABLES `secret_stores` WRITE;
/*!40000 ALTER TABLE `secret_stores` DISABLE KEYS */;
INSERT INTO `secret_stores` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `store_plugin`, `crypto_plugin`, `global_default`, `name`) VALUES ('9706112e-4528-47db-9df6-fca1d4d7fc69','2025-11-29 06:55:48','2025-11-29 06:55:48',NULL,0,'ACTIVE','store_crypto','simple_crypto',1,'Software Only Crypto');
/*!40000 ALTER TABLE `secret_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_user_metadata`
--

DROP TABLE IF EXISTS `secret_user_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_user_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_key_uc` (`secret_id`,`key`),
  KEY `ix_secret_user_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_user_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_user_metadata`
--

LOCK TABLES `secret_user_metadata` WRITE;
/*!40000 ALTER TABLE `secret_user_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_user_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secrets`
--

DROP TABLE IF EXISTS `secrets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secrets` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `secret_type` varchar(255) DEFAULT 'opaque',
  `expiration` datetime DEFAULT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secrets_project_id` (`project_id`),
  CONSTRAINT `secrets_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secrets`
--

LOCK TABLES `secrets` WRITE;
/*!40000 ALTER TABLE `secrets` DISABLE KEYS */;
INSERT INTO `secrets` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `name`, `secret_type`, `expiration`, `algorithm`, `bit_length`, `mode`, `creator_id`, `project_id`) VALUES ('091a9a2e-d1cc-44d2-be96-b1719b550e5c','2025-11-29 08:46:18','2025-11-29 08:47:01','2025-11-29 08:47:01',1,'ACTIVE',NULL,'symmetric',NULL,'aes',256,NULL,'b576a51181b5425aa6e44a0eb0a22803','899fa3bf-6fc2-451e-ae44-1e5826eef71b'),('f1784f4d-bd83-4c57-a711-5366b7510394','2025-11-29 08:41:40','2025-11-29 08:42:49','2025-11-29 08:42:49',1,'ACTIVE',NULL,'symmetric',NULL,'aes',256,NULL,'ea98d0ceb3954515a9c726d0d32d30cb','1155968a-5b13-4041-945e-d24bacd2d304');
/*!40000 ALTER TABLE `secrets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_keys`
--

DROP TABLE IF EXISTS `transport_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transport_keys` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `transport_key` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_keys`
--

LOCK TABLES `transport_keys` WRITE;
/*!40000 ALTER TABLE `transport_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `cinder`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `cinder` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `cinder`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('daa98075b90d');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment_specs`
--

DROP TABLE IF EXISTS `attachment_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_attachment_specs_attachment_id` (`attachment_id`),
  CONSTRAINT `attachment_specs_ibfk_1` FOREIGN KEY (`attachment_id`) REFERENCES `volume_attachment` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment_specs`
--

LOCK TABLES `attachment_specs` WRITE;
/*!40000 ALTER TABLE `attachment_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_metadata`
--

DROP TABLE IF EXISTS `backup_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_backup_metadata_backup_id` (`backup_id`),
  CONSTRAINT `backup_metadata_ibfk_1` FOREIGN KEY (`backup_id`) REFERENCES `backups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_metadata`
--

LOCK TABLES `backup_metadata` WRITE;
/*!40000 ALTER TABLE `backup_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `container` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fail_reason` varchar(255) DEFAULT NULL,
  `service_metadata` varchar(255) DEFAULT NULL,
  `service` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `object_count` int(11) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `temp_volume_id` varchar(36) DEFAULT NULL,
  `temp_snapshot_id` varchar(36) DEFAULT NULL,
  `num_dependent_backups` int(11) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `data_timestamp` datetime DEFAULT NULL,
  `restore_volume_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
INSERT INTO `backups` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `host`, `availability_zone`, `display_name`, `display_description`, `container`, `status`, `fail_reason`, `service_metadata`, `service`, `size`, `object_count`, `parent_id`, `temp_volume_id`, `temp_snapshot_id`, `num_dependent_backups`, `snapshot_id`, `data_timestamp`, `restore_volume_id`, `encryption_key_id`) VALUES ('2025-11-29 08:51:55','2025-11-29 08:52:51','2025-11-29 08:52:52',1,'c8953a74-a0fc-4433-b15f-8c123b9fb922','c95c9cac-92b7-4049-a506-241e7c32e9cd','c3778685080b4955bd80ff7056a1c9f2','676f70280bf945cd90578b14202243e2','cinder-backup-0',NULL,'tempest-TestVolumeBackupRestore-backup-367019359',NULL,'backups','deleted',NULL,'{\"base\": \"volume-c95c9cac-92b7-4049-a506-241e7c32e9cd.backup.c8953a74-a0fc-4433-b15f-8c123b9fb922\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:51:55','08dcfaf9-1c01-4432-a48d-de20b4481b2d',NULL);
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cgsnapshots`
--

DROP TABLE IF EXISTS `cgsnapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cgsnapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `consistencygroup_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_cgsnapshots_consistencygroup_id` (`consistencygroup_id`),
  CONSTRAINT `cgsnapshots_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cgsnapshots`
--

LOCK TABLES `cgsnapshots` WRITE;
/*!40000 ALTER TABLE `cgsnapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `cgsnapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clusters`
--

DROP TABLE IF EXISTS `clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clusters` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`binary`,`race_preventer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clusters`
--

LOCK TABLES `clusters` WRITE;
/*!40000 ALTER TABLE `clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consistencygroups`
--

DROP TABLE IF EXISTS `consistencygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consistencygroups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `volume_type_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `source_cgid` varchar(36) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consistencygroups`
--

LOCK TABLES `consistencygroups` WRITE;
/*!40000 ALTER TABLE `consistencygroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `consistencygroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_volume_types`
--

DROP TABLE IF EXISTS `default_volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `default_volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  KEY `ix_default_volume_types_volume_type_id` (`volume_type_id`),
  CONSTRAINT `default_volume_types_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_volume_types`
--

LOCK TABLES `default_volume_types` WRITE;
/*!40000 ALTER TABLE `default_volume_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver_initiator_data`
--

DROP TABLE IF EXISTS `driver_initiator_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `driver_initiator_data` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `initiator` (`initiator`,`namespace`,`key`),
  KEY `ix_driver_initiator_data_initiator` (`initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver_initiator_data`
--

LOCK TABLES `driver_initiator_data` WRITE;
/*!40000 ALTER TABLE `driver_initiator_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `driver_initiator_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encryption`
--

DROP TABLE IF EXISTS `encryption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encryption` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `cipher` varchar(255) DEFAULT NULL,
  `control_location` varchar(255) NOT NULL,
  `key_size` int(11) DEFAULT NULL,
  `provider` varchar(255) NOT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `encryption_id` varchar(36) NOT NULL,
  PRIMARY KEY (`encryption_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encryption`
--

LOCK TABLES `encryption` WRITE;
/*!40000 ALTER TABLE `encryption` DISABLE KEYS */;
INSERT INTO `encryption` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `cipher`, `control_location`, `key_size`, `provider`, `volume_type_id`, `encryption_id`) VALUES ('2025-11-29 08:46:18',NULL,'2025-11-29 08:47:03',1,'aes-xts-plain64','front-end',256,'luks','d2b244a1-75e7-4ea9-a00a-c6558e187208','9aa8f8d0-d0da-4328-8c43-7b7fefab0dd4'),('2025-11-29 08:41:39',NULL,'2025-11-29 08:42:50',1,'aes-xts-plain64','front-end',256,'luks','abf7c55e-ae5e-4bec-b06e-872d499cb5c4','ffb079c1-193e-408c-9a97-014e5f2ab7ca');
/*!40000 ALTER TABLE `encryption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_snapshots`
--

DROP TABLE IF EXISTS `group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_snapshots_group_id` (`group_id`),
  KEY `group_snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `group_snapshots_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_snapshots`
--

LOCK TABLES `group_snapshots` WRITE;
/*!40000 ALTER TABLE `group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_projects`
--

DROP TABLE IF EXISTS `group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_type_id` (`group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `group_type_projects_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_projects`
--

LOCK TABLES `group_type_projects` WRITE;
/*!40000 ALTER TABLE `group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_specs`
--

DROP TABLE IF EXISTS `group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_type_specs_group_type_id` (`group_type_id`),
  CONSTRAINT `group_type_specs_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_specs`
--

LOCK TABLES `group_type_specs` WRITE;
/*!40000 ALTER TABLE `group_type_specs` DISABLE KEYS */;
INSERT INTO `group_type_specs` (`id`, `key`, `value`, `group_type_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'consistent_group_snapshot_enabled','<is> True','5bd0f5d2-c4e6-43b0-bac7-5fed7c51757b','2025-11-29 06:55:38','2025-11-29 06:55:38',NULL,0);
/*!40000 ALTER TABLE `group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_types`
--

DROP TABLE IF EXISTS `group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_types` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_types`
--

LOCK TABLES `group_types` WRITE;
/*!40000 ALTER TABLE `group_types` DISABLE KEYS */;
INSERT INTO `group_types` (`id`, `name`, `description`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `is_public`) VALUES ('5bd0f5d2-c4e6-43b0-bac7-5fed7c51757b','default_cgsnapshot_type','Default group type for migrating cgsnapshot','2025-11-29 06:55:38','2025-11-29 06:55:38',NULL,0,1);
/*!40000 ALTER TABLE `group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_volume_type_mapping`
--

DROP TABLE IF EXISTS `group_volume_type_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_volume_type_mapping` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_volume_type_mapping_group_id` (`group_id`),
  KEY `ix_group_volume_type_mapping_volume_type_id` (`volume_type_id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_volume_type_mapping`
--

LOCK TABLES `group_volume_type_mapping` WRITE;
/*!40000 ALTER TABLE `group_volume_type_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_volume_type_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `groups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `source_group_id` varchar(36) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groups_deleted_project_id_idx` (`deleted`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_volume_cache_entries`
--

DROP TABLE IF EXISTS `image_volume_cache_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_volume_cache_entries` (
  `image_updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `image_id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `size` int(11) NOT NULL,
  `last_used` datetime NOT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_volume_cache_entries_image_id` (`image_id`),
  KEY `ix_image_volume_cache_entries_host` (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_volume_cache_entries`
--

LOCK TABLES `image_volume_cache_entries` WRITE;
/*!40000 ALTER TABLE `image_volume_cache_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_volume_cache_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(36) DEFAULT NULL,
  `resource_uuid` varchar(255) DEFAULT NULL,
  `event_id` varchar(255) NOT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `action_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_messages_expires_at` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quality_of_service_specs`
--

DROP TABLE IF EXISTS `quality_of_service_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quality_of_service_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `specs_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quality_of_service_specs_specs_id` (`specs_id`),
  CONSTRAINT `quality_of_service_specs_ibfk_1` FOREIGN KEY (`specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quality_of_service_specs`
--

LOCK TABLES `quality_of_service_specs` WRITE;
/*!40000 ALTER TABLE `quality_of_service_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `quality_of_service_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
INSERT INTO `quota_classes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `class_name`, `resource`, `hard_limit`) VALUES ('2025-11-29 06:55:18',NULL,NULL,0,1,'default','volumes',10),('2025-11-29 06:55:18',NULL,NULL,0,2,'default','snapshots',10),('2025-11-29 06:55:18',NULL,NULL,0,3,'default','gigabytes',1000),('2025-11-29 06:55:18',NULL,NULL,0,4,'default','consistencygroups',10),('2025-11-29 06:55:18',NULL,NULL,0,5,'default','per_volume_gigabytes',-1),('2025-11-29 06:55:18',NULL,NULL,0,6,'default','groups',10);
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(300) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `race_preventer` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`,`race_preventer`),
  KEY `ix_quota_usages_project_id` (`project_id`),
  KEY `quota_usage_project_resource_idx` (`project_id`,`resource`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=147 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
INSERT INTO `quota_usages` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `project_id`, `resource`, `in_use`, `reserved`, `until_refresh`, `race_preventer`) VALUES ('2025-11-29 07:49:48','2025-11-29 07:51:27',NULL,0,1,'93de83185bb14386b1526c79641f9a31','volumes',0,0,NULL,1),('2025-11-29 07:49:48','2025-11-29 07:51:27',NULL,0,2,'93de83185bb14386b1526c79641f9a31','gigabytes',0,0,NULL,1),('2025-11-29 07:49:48','2025-11-29 07:51:27',NULL,0,3,'93de83185bb14386b1526c79641f9a31','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 07:49:48','2025-11-29 07:51:27',NULL,0,4,'93de83185bb14386b1526c79641f9a31','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 07:53:14','2025-11-29 07:53:49',NULL,0,5,'ba323f7dc95a4f11911e6559a1b3c99e','volumes',0,0,NULL,1),('2025-11-29 07:53:14','2025-11-29 07:53:49',NULL,0,6,'ba323f7dc95a4f11911e6559a1b3c99e','gigabytes',0,0,NULL,1),('2025-11-29 07:53:14','2025-11-29 07:53:49',NULL,0,7,'ba323f7dc95a4f11911e6559a1b3c99e','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 07:53:14','2025-11-29 07:53:49',NULL,0,8,'ba323f7dc95a4f11911e6559a1b3c99e','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 07:54:04','2025-11-29 07:55:33',NULL,0,9,'1963a097b7694450aa0d7c30b27b38ac','volumes',0,0,NULL,1),('2025-11-29 07:54:04','2025-11-29 07:55:33',NULL,0,10,'1963a097b7694450aa0d7c30b27b38ac','gigabytes',0,0,NULL,1),('2025-11-29 07:54:04','2025-11-29 07:55:33',NULL,0,11,'1963a097b7694450aa0d7c30b27b38ac','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 07:54:04','2025-11-29 07:55:33',NULL,0,12,'1963a097b7694450aa0d7c30b27b38ac','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 07:54:04','2025-11-29 07:56:11',NULL,0,13,'f91d373d1ef64146866ef08735a75efa','volumes',0,0,NULL,1),('2025-11-29 07:54:04','2025-11-29 07:56:11',NULL,0,14,'f91d373d1ef64146866ef08735a75efa','gigabytes',0,0,NULL,1),('2025-11-29 07:54:04','2025-11-29 07:56:11',NULL,0,15,'f91d373d1ef64146866ef08735a75efa','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 07:54:04','2025-11-29 07:56:11',NULL,0,16,'f91d373d1ef64146866ef08735a75efa','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 07:58:25','2025-11-29 07:59:19',NULL,0,17,'4004f4fd97dd4d0e8e83dd715ffb8e9c','volumes',0,0,NULL,1),('2025-11-29 07:58:25','2025-11-29 07:59:19',NULL,0,18,'4004f4fd97dd4d0e8e83dd715ffb8e9c','gigabytes',0,0,NULL,1),('2025-11-29 07:58:25','2025-11-29 07:59:19',NULL,0,19,'4004f4fd97dd4d0e8e83dd715ffb8e9c','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 07:58:25','2025-11-29 07:59:19',NULL,0,20,'4004f4fd97dd4d0e8e83dd715ffb8e9c','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:00:38','2025-11-29 08:03:10',NULL,0,21,'afaf65dfeab546ee991af0438784b8a3','volumes',0,0,NULL,1),('2025-11-29 08:00:38','2025-11-29 08:03:10',NULL,0,22,'afaf65dfeab546ee991af0438784b8a3','gigabytes',0,0,NULL,1),('2025-11-29 08:00:38','2025-11-29 08:03:10',NULL,0,23,'afaf65dfeab546ee991af0438784b8a3','volumes_multiattach',0,0,NULL,1),('2025-11-29 08:00:38','2025-11-29 08:03:10',NULL,0,24,'afaf65dfeab546ee991af0438784b8a3','gigabytes_multiattach',0,0,NULL,1),('2025-11-29 08:01:02','2025-11-29 08:01:55',NULL,0,25,'a3c8b78b8a34400682bf8bbef740a22c','volumes',0,0,NULL,1),('2025-11-29 08:01:02','2025-11-29 08:01:55',NULL,0,26,'a3c8b78b8a34400682bf8bbef740a22c','gigabytes',0,0,NULL,1),('2025-11-29 08:01:02','2025-11-29 08:01:55',NULL,0,27,'a3c8b78b8a34400682bf8bbef740a22c','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:01:02','2025-11-29 08:01:55',NULL,0,28,'a3c8b78b8a34400682bf8bbef740a22c','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:04:31','2025-11-29 08:08:10',NULL,0,29,'90c23935e0214785a9dc5061b91cf29c','volumes',0,0,NULL,1),('2025-11-29 08:04:31','2025-11-29 08:08:10',NULL,0,30,'90c23935e0214785a9dc5061b91cf29c','gigabytes',0,0,NULL,1),('2025-11-29 08:04:31','2025-11-29 08:08:10',NULL,0,31,'90c23935e0214785a9dc5061b91cf29c','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:04:31','2025-11-29 08:08:10',NULL,0,32,'90c23935e0214785a9dc5061b91cf29c','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:09:04','2025-11-29 08:11:15',NULL,0,33,'28c3d09b9e21417cb7bc44b8552f1b81','volumes',0,0,NULL,1),('2025-11-29 08:09:04','2025-11-29 08:11:15',NULL,0,34,'28c3d09b9e21417cb7bc44b8552f1b81','gigabytes',0,0,NULL,1),('2025-11-29 08:09:04','2025-11-29 08:11:15',NULL,0,35,'28c3d09b9e21417cb7bc44b8552f1b81','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:09:04','2025-11-29 08:11:15',NULL,0,36,'28c3d09b9e21417cb7bc44b8552f1b81','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:13:30','2025-11-29 08:14:52',NULL,0,37,'b5f1f0d72cd0427a8cda48db244caf6c','volumes',0,0,NULL,1),('2025-11-29 08:13:30','2025-11-29 08:14:52',NULL,0,38,'b5f1f0d72cd0427a8cda48db244caf6c','gigabytes',0,0,NULL,1),('2025-11-29 08:13:30','2025-11-29 08:14:52',NULL,0,39,'b5f1f0d72cd0427a8cda48db244caf6c','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:13:30','2025-11-29 08:14:52',NULL,0,40,'b5f1f0d72cd0427a8cda48db244caf6c','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:15:38','2025-11-29 08:18:44',NULL,0,41,'1b8899f76f554afc96bb2441424e5a77','volumes',0,0,NULL,1),('2025-11-29 08:15:38','2025-11-29 08:18:44',NULL,0,42,'1b8899f76f554afc96bb2441424e5a77','gigabytes',0,0,NULL,1),('2025-11-29 08:15:38','2025-11-29 08:18:44',NULL,0,43,'1b8899f76f554afc96bb2441424e5a77','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:15:38','2025-11-29 08:18:44',NULL,0,44,'1b8899f76f554afc96bb2441424e5a77','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:15:46','2025-11-29 08:18:09',NULL,0,45,'9e6235234e63419ead82cbd9a07d500f','volumes',0,0,NULL,1),('2025-11-29 08:15:46','2025-11-29 08:18:09',NULL,0,46,'9e6235234e63419ead82cbd9a07d500f','gigabytes',0,0,NULL,1),('2025-11-29 08:15:46','2025-11-29 08:18:09',NULL,0,47,'9e6235234e63419ead82cbd9a07d500f','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:15:46','2025-11-29 08:18:09',NULL,0,48,'9e6235234e63419ead82cbd9a07d500f','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:18:42','2025-11-29 08:18:53',NULL,0,49,'8d6a508547b04ab19c5e5aa532a792a1','volumes',0,0,NULL,1),('2025-11-29 08:18:42','2025-11-29 08:18:53',NULL,0,50,'8d6a508547b04ab19c5e5aa532a792a1','gigabytes',0,0,NULL,1),('2025-11-29 08:18:42','2025-11-29 08:18:53',NULL,0,51,'8d6a508547b04ab19c5e5aa532a792a1','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:18:42','2025-11-29 08:18:53',NULL,0,52,'8d6a508547b04ab19c5e5aa532a792a1','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:19:11','2025-11-29 08:20:50',NULL,0,53,'696ec278f2ec426fa75ebb50bdf1c16a','volumes',0,0,NULL,1),('2025-11-29 08:19:11','2025-11-29 08:20:50',NULL,0,54,'696ec278f2ec426fa75ebb50bdf1c16a','gigabytes',0,0,NULL,1),('2025-11-29 08:19:11','2025-11-29 08:20:50',NULL,0,55,'696ec278f2ec426fa75ebb50bdf1c16a','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:19:11','2025-11-29 08:20:50',NULL,0,56,'696ec278f2ec426fa75ebb50bdf1c16a','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:21:46','2025-11-29 08:25:19',NULL,0,57,'0bace34c102e4d56b089fd695d324f10','volumes',0,0,NULL,1),('2025-11-29 08:21:46','2025-11-29 08:25:19',NULL,0,58,'0bace34c102e4d56b089fd695d324f10','gigabytes',0,0,NULL,1),('2025-11-29 08:21:46','2025-11-29 08:25:19',NULL,0,59,'0bace34c102e4d56b089fd695d324f10','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:21:46','2025-11-29 08:25:19',NULL,0,60,'0bace34c102e4d56b089fd695d324f10','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:26:07','2025-11-29 08:28:00',NULL,0,61,'a9a83f8d8d7f4d08890407f978c05166','volumes',0,0,NULL,1),('2025-11-29 08:26:07','2025-11-29 08:28:00',NULL,0,62,'a9a83f8d8d7f4d08890407f978c05166','gigabytes',0,0,NULL,1),('2025-11-29 08:26:07','2025-11-29 08:28:00',NULL,0,63,'a9a83f8d8d7f4d08890407f978c05166','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:26:07','2025-11-29 08:28:00',NULL,0,64,'a9a83f8d8d7f4d08890407f978c05166','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:26:58','2025-11-29 08:28:53',NULL,0,65,'ea7b24ea9d7b4d239b4741634ac3f10c','volumes',0,0,NULL,1),('2025-11-29 08:26:58','2025-11-29 08:28:53',NULL,0,66,'ea7b24ea9d7b4d239b4741634ac3f10c','gigabytes',0,0,NULL,1),('2025-11-29 08:26:58','2025-11-29 08:28:53',NULL,0,67,'ea7b24ea9d7b4d239b4741634ac3f10c','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:26:59','2025-11-29 08:28:53',NULL,0,68,'ea7b24ea9d7b4d239b4741634ac3f10c','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:27:41','2025-11-29 08:29:41',NULL,0,69,'ae71059d02774857be85797a3be0e4e6','volumes',2,0,NULL,1),('2025-11-29 08:27:41','2025-11-29 08:29:41',NULL,0,70,'ae71059d02774857be85797a3be0e4e6','gigabytes',2,0,NULL,1),('2025-11-29 08:27:41','2025-11-29 08:29:41',NULL,0,71,'ae71059d02774857be85797a3be0e4e6','volumes___DEFAULT__',2,0,NULL,1),('2025-11-29 08:27:41','2025-11-29 08:29:41',NULL,0,72,'ae71059d02774857be85797a3be0e4e6','gigabytes___DEFAULT__',2,0,NULL,1),('2025-11-29 08:31:11','2025-11-29 08:34:16',NULL,0,73,'1981e9617628491f938ef0ef01c061c5','volumes',0,0,NULL,1),('2025-11-29 08:31:11','2025-11-29 08:34:16',NULL,0,74,'1981e9617628491f938ef0ef01c061c5','gigabytes',0,0,NULL,1),('2025-11-29 08:31:11','2025-11-29 08:34:16',NULL,0,75,'1981e9617628491f938ef0ef01c061c5','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:31:11','2025-11-29 08:34:16',NULL,0,76,'1981e9617628491f938ef0ef01c061c5','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:31:17','2025-11-29 08:35:44',NULL,0,77,'d4f6db81949d487b853d7567f8a2e6d4','volumes',0,0,NULL,1),('2025-11-29 08:31:17','2025-11-29 08:35:44',NULL,0,78,'d4f6db81949d487b853d7567f8a2e6d4','gigabytes',0,0,NULL,1),('2025-11-29 08:31:17','2025-11-29 08:35:44',NULL,0,79,'d4f6db81949d487b853d7567f8a2e6d4','volumes_multiattach',0,0,NULL,1),('2025-11-29 08:31:17','2025-11-29 08:35:44',NULL,0,80,'d4f6db81949d487b853d7567f8a2e6d4','gigabytes_multiattach',0,0,NULL,1),('2025-11-29 08:34:34','2025-11-29 08:36:45',NULL,0,81,'96e72e7660da497a8b6bf9fdb03fe84c','volumes',0,0,NULL,1),('2025-11-29 08:34:34','2025-11-29 08:36:45',NULL,0,82,'96e72e7660da497a8b6bf9fdb03fe84c','gigabytes',0,0,NULL,1),('2025-11-29 08:34:34','2025-11-29 08:36:45',NULL,0,83,'96e72e7660da497a8b6bf9fdb03fe84c','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:34:34','2025-11-29 08:36:45',NULL,0,84,'96e72e7660da497a8b6bf9fdb03fe84c','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:35:11','2025-11-29 08:35:18',NULL,0,85,'d4f6db81949d487b853d7567f8a2e6d4','snapshots',0,0,NULL,1),('2025-11-29 08:35:11','2025-11-29 08:35:18',NULL,0,86,'d4f6db81949d487b853d7567f8a2e6d4','snapshots_multiattach',0,0,NULL,1),('2025-11-29 08:35:24','2025-11-29 08:38:38',NULL,0,87,'368e3a44279843f5947188dd045d65b6','volumes',0,0,NULL,1),('2025-11-29 08:35:24','2025-11-29 08:38:38',NULL,0,88,'368e3a44279843f5947188dd045d65b6','gigabytes',0,0,NULL,1),('2025-11-29 08:35:24','2025-11-29 08:38:38',NULL,0,89,'368e3a44279843f5947188dd045d65b6','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:35:24','2025-11-29 08:38:38',NULL,0,90,'368e3a44279843f5947188dd045d65b6','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:36:50','2025-11-29 08:39:48',NULL,0,91,'8d5e30b74e6449dd90ecb667977d1fe9','volumes',0,0,NULL,1),('2025-11-29 08:36:50','2025-11-29 08:39:48',NULL,0,92,'8d5e30b74e6449dd90ecb667977d1fe9','gigabytes',0,0,NULL,1),('2025-11-29 08:36:50','2025-11-29 08:39:48',NULL,0,93,'8d5e30b74e6449dd90ecb667977d1fe9','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:36:50','2025-11-29 08:39:48',NULL,0,94,'8d5e30b74e6449dd90ecb667977d1fe9','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:36:55','2025-11-29 08:37:17',NULL,0,95,'8d5e30b74e6449dd90ecb667977d1fe9','snapshots',0,0,NULL,1),('2025-11-29 08:36:55','2025-11-29 08:37:17',NULL,0,96,'8d5e30b74e6449dd90ecb667977d1fe9','snapshots___DEFAULT__',0,0,NULL,1),('2025-11-29 08:38:02','2025-11-29 08:40:54',NULL,0,97,'889608c71d13429fb37793575792ae74','volumes',0,0,NULL,1),('2025-11-29 08:38:02','2025-11-29 08:40:54',NULL,0,98,'889608c71d13429fb37793575792ae74','gigabytes',0,0,NULL,1),('2025-11-29 08:38:02','2025-11-29 08:40:54',NULL,0,99,'889608c71d13429fb37793575792ae74','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:38:02','2025-11-29 08:40:54',NULL,0,100,'889608c71d13429fb37793575792ae74','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:39:08','2025-11-29 08:41:34',NULL,0,101,'62ca01275fe34ea0af31d00b34d6d9a5','volumes',0,0,NULL,1),('2025-11-29 08:39:08','2025-11-29 08:41:34',NULL,0,102,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes',0,0,NULL,1),('2025-11-29 08:39:08','2025-11-29 08:41:08',NULL,0,103,'62ca01275fe34ea0af31d00b34d6d9a5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1962685100-62209477',0,0,NULL,1),('2025-11-29 08:39:08','2025-11-29 08:41:08',NULL,0,104,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1962685100-62209477',0,0,NULL,1),('2025-11-29 08:39:08','2025-11-29 08:41:11',NULL,0,105,'62ca01275fe34ea0af31d00b34d6d9a5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-334379363-1778895309',0,0,NULL,1),('2025-11-29 08:39:08','2025-11-29 08:41:11',NULL,0,106,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-334379363-1778895309',0,0,NULL,1),('2025-11-29 08:39:10','2025-11-29 08:41:34',NULL,0,107,'62ca01275fe34ea0af31d00b34d6d9a5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1204371373-2122106632',0,0,NULL,1),('2025-11-29 08:39:10','2025-11-29 08:41:34',NULL,0,108,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1204371373-2122106632',0,0,NULL,1),('2025-11-29 08:41:05','2025-11-29 08:41:11',NULL,0,109,'89fad883285a4255b3b35c445f93c900','volumes',0,0,NULL,1),('2025-11-29 08:41:05','2025-11-29 08:41:11',NULL,0,110,'89fad883285a4255b3b35c445f93c900','gigabytes',0,0,NULL,1),('2025-11-29 08:41:05','2025-11-29 08:41:11',NULL,0,111,'89fad883285a4255b3b35c445f93c900','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:41:05','2025-11-29 08:41:11',NULL,0,112,'89fad883285a4255b3b35c445f93c900','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:41:06','2025-11-29 08:41:09',NULL,0,113,'89fad883285a4255b3b35c445f93c900','snapshots',0,0,NULL,1),('2025-11-29 08:41:06','2025-11-29 08:41:09',NULL,0,114,'89fad883285a4255b3b35c445f93c900','snapshots___DEFAULT__',0,0,NULL,1),('2025-11-29 08:41:16','2025-11-29 08:41:20',NULL,0,115,'0ccc70201c12433cba2c77f57171fc5a','volumes',0,0,NULL,1),('2025-11-29 08:41:16','2025-11-29 08:41:20',NULL,0,116,'0ccc70201c12433cba2c77f57171fc5a','gigabytes',0,0,NULL,1),('2025-11-29 08:41:16','2025-11-29 08:41:20',NULL,0,117,'0ccc70201c12433cba2c77f57171fc5a','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:41:16','2025-11-29 08:41:20',NULL,0,118,'0ccc70201c12433cba2c77f57171fc5a','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:41:40','2025-11-29 08:42:49',NULL,0,119,'c80b570a17ee4094b96a75465fc34ae7','volumes',0,0,NULL,1),('2025-11-29 08:41:40','2025-11-29 08:42:49',NULL,0,120,'c80b570a17ee4094b96a75465fc34ae7','gigabytes',0,0,NULL,1),('2025-11-29 08:41:40','2025-11-29 08:42:49',NULL,0,121,'c80b570a17ee4094b96a75465fc34ae7','volumes_tempest-scenario-type-luks-1501415148',0,0,NULL,1),('2025-11-29 08:41:40','2025-11-29 08:42:49',NULL,0,122,'c80b570a17ee4094b96a75465fc34ae7','gigabytes_tempest-scenario-type-luks-1501415148',0,0,NULL,1),('2025-11-29 08:43:24','2025-11-29 08:45:47',NULL,0,123,'3b3b0484057a4e3db51366d29c6b684d','volumes',0,0,NULL,1),('2025-11-29 08:43:24','2025-11-29 08:45:47',NULL,0,124,'3b3b0484057a4e3db51366d29c6b684d','gigabytes',0,0,NULL,1),('2025-11-29 08:43:24','2025-11-29 08:45:47',NULL,0,125,'3b3b0484057a4e3db51366d29c6b684d','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:43:24','2025-11-29 08:45:47',NULL,0,126,'3b3b0484057a4e3db51366d29c6b684d','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:44:22','2025-11-29 08:45:38',NULL,0,127,'3b3b0484057a4e3db51366d29c6b684d','snapshots',0,0,NULL,1),('2025-11-29 08:44:22','2025-11-29 08:45:38',NULL,0,128,'3b3b0484057a4e3db51366d29c6b684d','snapshots___DEFAULT__',0,0,NULL,1),('2025-11-29 08:46:19','2025-11-29 08:53:03',NULL,0,129,'b7ffcb23bac14ee49474df9aee5f7dae','volumes',0,0,NULL,1),('2025-11-29 08:46:19','2025-11-29 08:53:03',NULL,0,130,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes',0,0,NULL,1),('2025-11-29 08:46:19','2025-11-29 08:47:01',NULL,0,131,'b7ffcb23bac14ee49474df9aee5f7dae','volumes_tempest-scenario-type-luks-677447409',0,0,NULL,1),('2025-11-29 08:46:19','2025-11-29 08:47:01',NULL,0,132,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes_tempest-scenario-type-luks-677447409',0,0,NULL,1),('2025-11-29 08:47:06','2025-11-29 08:53:03',NULL,0,133,'b7ffcb23bac14ee49474df9aee5f7dae','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:47:06','2025-11-29 08:53:03',NULL,0,134,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:47:14','2025-11-29 08:52:54',NULL,0,135,'b7ffcb23bac14ee49474df9aee5f7dae','snapshots',0,0,NULL,1),('2025-11-29 08:47:14','2025-11-29 08:52:54',NULL,0,136,'b7ffcb23bac14ee49474df9aee5f7dae','snapshots___DEFAULT__',0,0,NULL,1),('2025-11-29 08:48:49','2025-11-29 08:50:29',NULL,0,137,'2e636ab14fe94059b82b9cbcf8831d87','volumes',0,0,NULL,1),('2025-11-29 08:48:49','2025-11-29 08:50:29',NULL,0,138,'2e636ab14fe94059b82b9cbcf8831d87','gigabytes',0,0,NULL,1),('2025-11-29 08:48:49','2025-11-29 08:50:29',NULL,0,139,'2e636ab14fe94059b82b9cbcf8831d87','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:48:49','2025-11-29 08:50:29',NULL,0,140,'2e636ab14fe94059b82b9cbcf8831d87','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:51:38','2025-11-29 08:52:52',NULL,0,141,'676f70280bf945cd90578b14202243e2','volumes',0,0,NULL,1),('2025-11-29 08:51:38','2025-11-29 08:52:52',NULL,0,142,'676f70280bf945cd90578b14202243e2','gigabytes',0,0,NULL,1),('2025-11-29 08:51:38','2025-11-29 08:52:52',NULL,0,143,'676f70280bf945cd90578b14202243e2','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:51:38','2025-11-29 08:52:52',NULL,0,144,'676f70280bf945cd90578b14202243e2','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:51:55','2025-11-29 08:52:52',NULL,0,145,'676f70280bf945cd90578b14202243e2','backups',0,0,NULL,1),('2025-11-29 08:51:55','2025-11-29 08:52:52',NULL,0,146,'676f70280bf945cd90578b14202243e2','backup_gigabytes',0,0,NULL,1);
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `allocated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `allocated_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_reservations_allocated_id` (`allocated_id`),
  KEY `ix_reservations_usage_id` (`usage_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `reservations_deleted_uuid_idx` (`deleted`,`uuid`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`),
  CONSTRAINT `reservations_ibfk_2` FOREIGN KEY (`allocated_id`) REFERENCES `quotas` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=605 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
INSERT INTO `reservations` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `uuid`, `usage_id`, `project_id`, `resource`, `delta`, `expire`, `allocated_id`) VALUES ('2025-11-29 07:49:48','2025-11-29 07:49:48','2025-11-29 07:49:48',1,1,'d48b977f-e406-48bb-a889-eaa401d21c9c',1,'93de83185bb14386b1526c79641f9a31','volumes',1,'2025-11-30 07:49:48',NULL),('2025-11-29 07:49:48','2025-11-29 07:49:48','2025-11-29 07:49:48',1,2,'74d7b6b3-e918-4e80-bd12-70f5c6f198a3',2,'93de83185bb14386b1526c79641f9a31','gigabytes',1,'2025-11-30 07:49:48',NULL),('2025-11-29 07:49:48','2025-11-29 07:49:48','2025-11-29 07:49:48',1,3,'5d76e44f-e6ec-4b8e-bbf6-bfc3e57c2fe4',3,'93de83185bb14386b1526c79641f9a31','volumes___DEFAULT__',1,'2025-11-30 07:49:48',NULL),('2025-11-29 07:49:48','2025-11-29 07:49:48','2025-11-29 07:49:48',1,4,'aeb19d1c-f7e0-46f1-8d6c-3b2413c698a1',4,'93de83185bb14386b1526c79641f9a31','gigabytes___DEFAULT__',1,'2025-11-30 07:49:48',NULL),('2025-11-29 07:51:27','2025-11-29 07:51:27','2025-11-29 07:51:27',1,5,'54d84d65-5074-4e4c-bdc9-e3460ca86e28',1,'93de83185bb14386b1526c79641f9a31','volumes',-1,'2025-11-30 07:51:27',NULL),('2025-11-29 07:51:27','2025-11-29 07:51:27','2025-11-29 07:51:27',1,6,'4a282581-1017-4518-9232-608ed35777b8',2,'93de83185bb14386b1526c79641f9a31','gigabytes',-1,'2025-11-30 07:51:27',NULL),('2025-11-29 07:51:27','2025-11-29 07:51:27','2025-11-29 07:51:27',1,7,'daa2f65a-984f-4e27-aa41-7a80f28484d6',3,'93de83185bb14386b1526c79641f9a31','volumes___DEFAULT__',-1,'2025-11-30 07:51:27',NULL),('2025-11-29 07:51:27','2025-11-29 07:51:27','2025-11-29 07:51:27',1,8,'539861e7-ce14-4e9d-8efd-e9706009f801',4,'93de83185bb14386b1526c79641f9a31','gigabytes___DEFAULT__',-1,'2025-11-30 07:51:27',NULL),('2025-11-29 07:53:14','2025-11-29 07:53:14','2025-11-29 07:53:14',1,9,'3227d589-670b-4b63-9e59-7699388a086b',5,'ba323f7dc95a4f11911e6559a1b3c99e','volumes',1,'2025-11-30 07:53:14',NULL),('2025-11-29 07:53:14','2025-11-29 07:53:14','2025-11-29 07:53:14',1,10,'cc4d6c24-5d84-43ae-b479-19016748fc82',6,'ba323f7dc95a4f11911e6559a1b3c99e','gigabytes',1,'2025-11-30 07:53:14',NULL),('2025-11-29 07:53:14','2025-11-29 07:53:14','2025-11-29 07:53:14',1,11,'77931e0e-b5e9-4472-9517-d640a4c757a0',7,'ba323f7dc95a4f11911e6559a1b3c99e','volumes___DEFAULT__',1,'2025-11-30 07:53:14',NULL),('2025-11-29 07:53:14','2025-11-29 07:53:14','2025-11-29 07:53:14',1,12,'7798e3fc-a7d0-4d11-95c4-c159da56b884',8,'ba323f7dc95a4f11911e6559a1b3c99e','gigabytes___DEFAULT__',1,'2025-11-30 07:53:14',NULL),('2025-11-29 07:53:39','2025-11-29 07:53:39','2025-11-29 07:53:39',1,13,'f651112a-3a7e-480a-8489-90368b69f375',5,'ba323f7dc95a4f11911e6559a1b3c99e','volumes',1,'2025-11-30 07:53:39',NULL),('2025-11-29 07:53:39','2025-11-29 07:53:39','2025-11-29 07:53:39',1,14,'e57c54ca-06d4-4db7-83a2-78dd65380c44',6,'ba323f7dc95a4f11911e6559a1b3c99e','gigabytes',1,'2025-11-30 07:53:39',NULL),('2025-11-29 07:53:39','2025-11-29 07:53:39','2025-11-29 07:53:39',1,15,'28f9ff2c-4c70-41f3-9557-24da78a6fbaa',7,'ba323f7dc95a4f11911e6559a1b3c99e','volumes___DEFAULT__',1,'2025-11-30 07:53:39',NULL),('2025-11-29 07:53:39','2025-11-29 07:53:39','2025-11-29 07:53:39',1,16,'889eefa3-662a-463f-ad48-39ad89b43f56',8,'ba323f7dc95a4f11911e6559a1b3c99e','gigabytes___DEFAULT__',1,'2025-11-30 07:53:39',NULL),('2025-11-29 07:53:42','2025-11-29 07:53:42','2025-11-29 07:53:42',1,17,'a3b39f8c-adb0-47fd-98ba-e53bf76edab1',5,'ba323f7dc95a4f11911e6559a1b3c99e','volumes',-1,'2025-11-30 07:53:42',NULL),('2025-11-29 07:53:42','2025-11-29 07:53:42','2025-11-29 07:53:42',1,18,'1aa195d5-73ff-457f-a0b6-a94f2a9fa70c',6,'ba323f7dc95a4f11911e6559a1b3c99e','gigabytes',-1,'2025-11-30 07:53:42',NULL),('2025-11-29 07:53:42','2025-11-29 07:53:42','2025-11-29 07:53:42',1,19,'3c9f26b4-4c36-40cf-9caa-7d607a0920c7',7,'ba323f7dc95a4f11911e6559a1b3c99e','volumes___DEFAULT__',-1,'2025-11-30 07:53:42',NULL),('2025-11-29 07:53:42','2025-11-29 07:53:42','2025-11-29 07:53:42',1,20,'d69535e8-2f1e-4a0d-8598-72437097e382',8,'ba323f7dc95a4f11911e6559a1b3c99e','gigabytes___DEFAULT__',-1,'2025-11-30 07:53:42',NULL),('2025-11-29 07:53:49','2025-11-29 07:53:49','2025-11-29 07:53:49',1,21,'65f3976e-c753-4186-bbfc-a1a3554b0168',5,'ba323f7dc95a4f11911e6559a1b3c99e','volumes',-1,'2025-11-30 07:53:49',NULL),('2025-11-29 07:53:49','2025-11-29 07:53:49','2025-11-29 07:53:49',1,22,'38246cfc-a2d7-4300-8c65-9fd8427717e2',6,'ba323f7dc95a4f11911e6559a1b3c99e','gigabytes',-1,'2025-11-30 07:53:49',NULL),('2025-11-29 07:53:49','2025-11-29 07:53:49','2025-11-29 07:53:49',1,23,'5f873331-5d4b-485d-aabd-a759dbfd3448',7,'ba323f7dc95a4f11911e6559a1b3c99e','volumes___DEFAULT__',-1,'2025-11-30 07:53:49',NULL),('2025-11-29 07:53:49','2025-11-29 07:53:49','2025-11-29 07:53:49',1,24,'f07572e5-f349-4a47-b9c4-010c8052e224',8,'ba323f7dc95a4f11911e6559a1b3c99e','gigabytes___DEFAULT__',-1,'2025-11-30 07:53:49',NULL),('2025-11-29 07:54:04','2025-11-29 07:54:04','2025-11-29 07:54:04',1,25,'2c074570-6322-4f4e-b515-4e12c3514d88',9,'1963a097b7694450aa0d7c30b27b38ac','volumes',1,'2025-11-30 07:54:04',NULL),('2025-11-29 07:54:04','2025-11-29 07:54:04','2025-11-29 07:54:04',1,26,'275b5da3-f30d-451d-842f-8e8398237155',10,'1963a097b7694450aa0d7c30b27b38ac','gigabytes',1,'2025-11-30 07:54:04',NULL),('2025-11-29 07:54:04','2025-11-29 07:54:04','2025-11-29 07:54:04',1,27,'929c3fc4-9e51-4bae-b731-9f14a0ed6ee9',11,'1963a097b7694450aa0d7c30b27b38ac','volumes___DEFAULT__',1,'2025-11-30 07:54:04',NULL),('2025-11-29 07:54:04','2025-11-29 07:54:04','2025-11-29 07:54:04',1,28,'19effb1d-4d18-42bd-813c-19a01dcdd7a4',12,'1963a097b7694450aa0d7c30b27b38ac','gigabytes___DEFAULT__',1,'2025-11-30 07:54:04',NULL),('2025-11-29 07:54:04','2025-11-29 07:54:04','2025-11-29 07:54:04',1,29,'bbf271ed-958d-4c68-b304-72f1f567c4f8',13,'f91d373d1ef64146866ef08735a75efa','volumes',1,'2025-11-30 07:54:04',NULL),('2025-11-29 07:54:04','2025-11-29 07:54:04','2025-11-29 07:54:04',1,30,'42d39f63-b1af-421b-b2bc-cf33c85fbd0a',14,'f91d373d1ef64146866ef08735a75efa','gigabytes',1,'2025-11-30 07:54:04',NULL),('2025-11-29 07:54:04','2025-11-29 07:54:04','2025-11-29 07:54:04',1,31,'862a1157-4a64-46eb-b0e4-436636cd549c',15,'f91d373d1ef64146866ef08735a75efa','volumes___DEFAULT__',1,'2025-11-30 07:54:04',NULL),('2025-11-29 07:54:04','2025-11-29 07:54:04','2025-11-29 07:54:04',1,32,'0396f7eb-0ee9-4080-882a-f1d8eff3440f',16,'f91d373d1ef64146866ef08735a75efa','gigabytes___DEFAULT__',1,'2025-11-30 07:54:04',NULL),('2025-11-29 07:55:33','2025-11-29 07:55:33','2025-11-29 07:55:33',1,33,'d3a06a34-5899-42b9-b70b-edac78450082',9,'1963a097b7694450aa0d7c30b27b38ac','volumes',-1,'2025-11-30 07:55:33',NULL),('2025-11-29 07:55:33','2025-11-29 07:55:33','2025-11-29 07:55:33',1,34,'5df847bd-1039-4fd9-82e0-8fa2b2842eea',10,'1963a097b7694450aa0d7c30b27b38ac','gigabytes',-1,'2025-11-30 07:55:33',NULL),('2025-11-29 07:55:33','2025-11-29 07:55:33','2025-11-29 07:55:33',1,35,'ff70c06a-8064-40f0-96c3-078adad713c9',11,'1963a097b7694450aa0d7c30b27b38ac','volumes___DEFAULT__',-1,'2025-11-30 07:55:33',NULL),('2025-11-29 07:55:33','2025-11-29 07:55:33','2025-11-29 07:55:33',1,36,'bb1cae8f-be1e-472e-9d85-bdaf4d5d8ac5',12,'1963a097b7694450aa0d7c30b27b38ac','gigabytes___DEFAULT__',-1,'2025-11-30 07:55:33',NULL),('2025-11-29 07:56:11','2025-11-29 07:56:11','2025-11-29 07:56:11',1,37,'427f6b86-a9db-487f-9689-9d86d8b3fe39',13,'f91d373d1ef64146866ef08735a75efa','volumes',-1,'2025-11-30 07:56:11',NULL),('2025-11-29 07:56:11','2025-11-29 07:56:11','2025-11-29 07:56:11',1,38,'7edb84f1-16c3-430d-b3f8-f7312caffaa5',14,'f91d373d1ef64146866ef08735a75efa','gigabytes',-1,'2025-11-30 07:56:11',NULL),('2025-11-29 07:56:11','2025-11-29 07:56:11','2025-11-29 07:56:11',1,39,'425006d4-e74a-4392-a27f-352cc675e30f',15,'f91d373d1ef64146866ef08735a75efa','volumes___DEFAULT__',-1,'2025-11-30 07:56:11',NULL),('2025-11-29 07:56:11','2025-11-29 07:56:11','2025-11-29 07:56:11',1,40,'8daad4ef-ac64-48fb-b145-8a4a2bcba353',16,'f91d373d1ef64146866ef08735a75efa','gigabytes___DEFAULT__',-1,'2025-11-30 07:56:11',NULL),('2025-11-29 07:58:25','2025-11-29 07:58:26','2025-11-29 07:58:26',1,41,'8a3f9e18-493c-4b46-843b-90ffc717c6d6',17,'4004f4fd97dd4d0e8e83dd715ffb8e9c','volumes',1,'2025-11-30 07:58:25',NULL),('2025-11-29 07:58:25','2025-11-29 07:58:26','2025-11-29 07:58:26',1,42,'ba2b326f-8c5b-4704-be47-19856a4df24b',18,'4004f4fd97dd4d0e8e83dd715ffb8e9c','gigabytes',1,'2025-11-30 07:58:25',NULL),('2025-11-29 07:58:25','2025-11-29 07:58:26','2025-11-29 07:58:26',1,43,'019858d5-ec81-4606-91d9-6dbce7126be8',19,'4004f4fd97dd4d0e8e83dd715ffb8e9c','volumes___DEFAULT__',1,'2025-11-30 07:58:25',NULL),('2025-11-29 07:58:25','2025-11-29 07:58:26','2025-11-29 07:58:26',1,44,'60c67b6b-b75d-4e1d-8ac4-60ef15b0660c',20,'4004f4fd97dd4d0e8e83dd715ffb8e9c','gigabytes___DEFAULT__',1,'2025-11-30 07:58:25',NULL),('2025-11-29 07:59:19','2025-11-29 07:59:19','2025-11-29 07:59:19',1,45,'99b023a3-0159-40ae-91e3-bba074faad28',17,'4004f4fd97dd4d0e8e83dd715ffb8e9c','volumes',-1,'2025-11-30 07:59:19',NULL),('2025-11-29 07:59:19','2025-11-29 07:59:19','2025-11-29 07:59:19',1,46,'195a0519-8390-4110-b8cb-1e4bca216e1b',18,'4004f4fd97dd4d0e8e83dd715ffb8e9c','gigabytes',-1,'2025-11-30 07:59:19',NULL),('2025-11-29 07:59:19','2025-11-29 07:59:19','2025-11-29 07:59:19',1,47,'cf63f95b-d890-4a2f-8b06-d0b236f8f5e7',19,'4004f4fd97dd4d0e8e83dd715ffb8e9c','volumes___DEFAULT__',-1,'2025-11-30 07:59:19',NULL),('2025-11-29 07:59:19','2025-11-29 07:59:19','2025-11-29 07:59:19',1,48,'596e896c-5fe4-464f-894c-4109170eb31f',20,'4004f4fd97dd4d0e8e83dd715ffb8e9c','gigabytes___DEFAULT__',-1,'2025-11-30 07:59:19',NULL),('2025-11-29 08:00:38','2025-11-29 08:00:38','2025-11-29 08:00:38',1,49,'62a6266b-2b7e-4469-9465-62e6b14ec3b1',21,'afaf65dfeab546ee991af0438784b8a3','volumes',1,'2025-11-30 08:00:38',NULL),('2025-11-29 08:00:38','2025-11-29 08:00:38','2025-11-29 08:00:38',1,50,'e8dc0acd-2d86-4030-9f59-35c290759e04',22,'afaf65dfeab546ee991af0438784b8a3','gigabytes',1,'2025-11-30 08:00:38',NULL),('2025-11-29 08:00:38','2025-11-29 08:00:38','2025-11-29 08:00:38',1,51,'d16bc107-ef56-4c3b-b7a3-f0dd9ad0f2ee',23,'afaf65dfeab546ee991af0438784b8a3','volumes_multiattach',1,'2025-11-30 08:00:38',NULL),('2025-11-29 08:00:38','2025-11-29 08:00:38','2025-11-29 08:00:38',1,52,'bbc00109-a21a-4b6d-9477-0b3685d57865',24,'afaf65dfeab546ee991af0438784b8a3','gigabytes_multiattach',1,'2025-11-30 08:00:38',NULL),('2025-11-29 08:00:40','2025-11-29 08:00:40','2025-11-29 08:00:40',1,53,'7e77ca11-b92e-4405-89cd-fcd8c5334396',21,'afaf65dfeab546ee991af0438784b8a3','volumes',1,'2025-11-30 08:00:40',NULL),('2025-11-29 08:00:40','2025-11-29 08:00:40','2025-11-29 08:00:40',1,54,'bdbd3cc7-6a05-467a-abde-b9913cee8cb3',22,'afaf65dfeab546ee991af0438784b8a3','gigabytes',1,'2025-11-30 08:00:40',NULL),('2025-11-29 08:00:40','2025-11-29 08:00:40','2025-11-29 08:00:40',1,55,'1615ff2a-0a18-4246-8228-939bcdbe02ba',23,'afaf65dfeab546ee991af0438784b8a3','volumes_multiattach',1,'2025-11-30 08:00:40',NULL),('2025-11-29 08:00:40','2025-11-29 08:00:40','2025-11-29 08:00:40',1,56,'b800e86e-de39-4052-8e75-ff98da0e5860',24,'afaf65dfeab546ee991af0438784b8a3','gigabytes_multiattach',1,'2025-11-30 08:00:40',NULL),('2025-11-29 08:01:02','2025-11-29 08:01:02','2025-11-29 08:01:02',1,57,'4b16daf0-b712-443f-9224-692a8d43606d',25,'a3c8b78b8a34400682bf8bbef740a22c','volumes',1,'2025-11-30 08:01:02',NULL),('2025-11-29 08:01:02','2025-11-29 08:01:02','2025-11-29 08:01:02',1,58,'fbcfe810-9bce-49ff-b0eb-2628e04b3bf9',26,'a3c8b78b8a34400682bf8bbef740a22c','gigabytes',1,'2025-11-30 08:01:02',NULL),('2025-11-29 08:01:02','2025-11-29 08:01:02','2025-11-29 08:01:02',1,59,'0725b923-d8eb-4ebc-ae98-7f9e24b763f9',27,'a3c8b78b8a34400682bf8bbef740a22c','volumes___DEFAULT__',1,'2025-11-30 08:01:02',NULL),('2025-11-29 08:01:02','2025-11-29 08:01:02','2025-11-29 08:01:02',1,60,'86ba5bd7-5698-4798-9202-81260f2160b1',28,'a3c8b78b8a34400682bf8bbef740a22c','gigabytes___DEFAULT__',1,'2025-11-30 08:01:02',NULL),('2025-11-29 08:01:55','2025-11-29 08:01:55','2025-11-29 08:01:55',1,61,'536b8397-2a17-478e-9761-0cd5dbed01f0',25,'a3c8b78b8a34400682bf8bbef740a22c','volumes',-1,'2025-11-30 08:01:55',NULL),('2025-11-29 08:01:55','2025-11-29 08:01:55','2025-11-29 08:01:55',1,62,'0e037465-72ff-4677-b482-ab1a73ba78c0',26,'a3c8b78b8a34400682bf8bbef740a22c','gigabytes',-1,'2025-11-30 08:01:55',NULL),('2025-11-29 08:01:55','2025-11-29 08:01:55','2025-11-29 08:01:55',1,63,'fe5693e5-b2a3-4399-95ca-a15120a4531d',27,'a3c8b78b8a34400682bf8bbef740a22c','volumes___DEFAULT__',-1,'2025-11-30 08:01:55',NULL),('2025-11-29 08:01:55','2025-11-29 08:01:55','2025-11-29 08:01:55',1,64,'db86c1b9-8f02-4a49-b4a4-e2eeebfa3302',28,'a3c8b78b8a34400682bf8bbef740a22c','gigabytes___DEFAULT__',-1,'2025-11-30 08:01:55',NULL),('2025-11-29 08:03:05','2025-11-29 08:03:05','2025-11-29 08:03:05',1,65,'3e8986b0-de85-4b6b-a641-5e3250dfa5c7',21,'afaf65dfeab546ee991af0438784b8a3','volumes',-1,'2025-11-30 08:03:05',NULL),('2025-11-29 08:03:05','2025-11-29 08:03:05','2025-11-29 08:03:05',1,66,'150e4594-d52b-4cc0-b533-296a4dbb2541',22,'afaf65dfeab546ee991af0438784b8a3','gigabytes',-1,'2025-11-30 08:03:05',NULL),('2025-11-29 08:03:05','2025-11-29 08:03:05','2025-11-29 08:03:05',1,67,'9cf06e51-e0c3-4740-ab99-c7a066c240c6',23,'afaf65dfeab546ee991af0438784b8a3','volumes_multiattach',-1,'2025-11-30 08:03:05',NULL),('2025-11-29 08:03:05','2025-11-29 08:03:05','2025-11-29 08:03:05',1,68,'94635931-86d5-4c01-8abc-965f6944cd57',24,'afaf65dfeab546ee991af0438784b8a3','gigabytes_multiattach',-1,'2025-11-30 08:03:05',NULL),('2025-11-29 08:03:10','2025-11-29 08:03:10','2025-11-29 08:03:10',1,69,'16a1e23a-9788-4cf2-9423-e861e61141c4',21,'afaf65dfeab546ee991af0438784b8a3','volumes',-1,'2025-11-30 08:03:10',NULL),('2025-11-29 08:03:10','2025-11-29 08:03:10','2025-11-29 08:03:10',1,70,'de7a6196-a3d4-422e-a62b-26408b3a0484',22,'afaf65dfeab546ee991af0438784b8a3','gigabytes',-1,'2025-11-30 08:03:10',NULL),('2025-11-29 08:03:10','2025-11-29 08:03:10','2025-11-29 08:03:10',1,71,'5b21a60b-865d-4f3e-9ab6-fabb1347ee4b',23,'afaf65dfeab546ee991af0438784b8a3','volumes_multiattach',-1,'2025-11-30 08:03:10',NULL),('2025-11-29 08:03:10','2025-11-29 08:03:10','2025-11-29 08:03:10',1,72,'0b178354-a55b-485d-a923-852a90421356',24,'afaf65dfeab546ee991af0438784b8a3','gigabytes_multiattach',-1,'2025-11-30 08:03:10',NULL),('2025-11-29 08:04:31','2025-11-29 08:04:31','2025-11-29 08:04:31',1,73,'e1e3aed0-2473-499f-bdc7-43d667322296',29,'90c23935e0214785a9dc5061b91cf29c','volumes',1,'2025-11-30 08:04:31',NULL),('2025-11-29 08:04:31','2025-11-29 08:04:31','2025-11-29 08:04:31',1,74,'c851644a-78f8-42d5-9be2-86469179afc9',30,'90c23935e0214785a9dc5061b91cf29c','gigabytes',1,'2025-11-30 08:04:31',NULL),('2025-11-29 08:04:31','2025-11-29 08:04:31','2025-11-29 08:04:31',1,75,'f6145704-90c7-4a56-8287-ba271c8a945d',31,'90c23935e0214785a9dc5061b91cf29c','volumes___DEFAULT__',1,'2025-11-30 08:04:31',NULL),('2025-11-29 08:04:31','2025-11-29 08:04:31','2025-11-29 08:04:31',1,76,'5c5ca6aa-4ba9-4432-a28c-5970c4b3b83b',32,'90c23935e0214785a9dc5061b91cf29c','gigabytes___DEFAULT__',1,'2025-11-30 08:04:31',NULL),('2025-11-29 08:08:10','2025-11-29 08:08:10','2025-11-29 08:08:10',1,77,'432df4c0-43dc-47b1-9ae7-0a2c77694b18',29,'90c23935e0214785a9dc5061b91cf29c','volumes',-1,'2025-11-30 08:08:10',NULL),('2025-11-29 08:08:10','2025-11-29 08:08:10','2025-11-29 08:08:10',1,78,'4e292b6e-3bc3-426c-b7ef-6dde2b97dc7f',30,'90c23935e0214785a9dc5061b91cf29c','gigabytes',-1,'2025-11-30 08:08:10',NULL),('2025-11-29 08:08:10','2025-11-29 08:08:10','2025-11-29 08:08:10',1,79,'e99a46a6-e972-42f5-8e25-5a7de76fe415',31,'90c23935e0214785a9dc5061b91cf29c','volumes___DEFAULT__',-1,'2025-11-30 08:08:10',NULL),('2025-11-29 08:08:10','2025-11-29 08:08:10','2025-11-29 08:08:10',1,80,'26c70363-5adf-4549-97e9-f5702ba9379e',32,'90c23935e0214785a9dc5061b91cf29c','gigabytes___DEFAULT__',-1,'2025-11-30 08:08:10',NULL),('2025-11-29 08:09:04','2025-11-29 08:09:04','2025-11-29 08:09:04',1,81,'492cebd3-8320-4821-a3b8-f47265a5fc97',33,'28c3d09b9e21417cb7bc44b8552f1b81','volumes',1,'2025-11-30 08:09:04',NULL),('2025-11-29 08:09:04','2025-11-29 08:09:04','2025-11-29 08:09:04',1,82,'d2a1c6b0-2379-4a21-9aa0-8b4eddcc5858',34,'28c3d09b9e21417cb7bc44b8552f1b81','gigabytes',1,'2025-11-30 08:09:04',NULL),('2025-11-29 08:09:04','2025-11-29 08:09:04','2025-11-29 08:09:04',1,83,'efa05504-980a-48d4-9b03-50d8d7658b6b',35,'28c3d09b9e21417cb7bc44b8552f1b81','volumes___DEFAULT__',1,'2025-11-30 08:09:04',NULL),('2025-11-29 08:09:04','2025-11-29 08:09:04','2025-11-29 08:09:04',1,84,'064dae17-71a3-4fb4-9c37-d6c3f0b6d852',36,'28c3d09b9e21417cb7bc44b8552f1b81','gigabytes___DEFAULT__',1,'2025-11-30 08:09:04',NULL),('2025-11-29 08:09:13','2025-11-29 08:09:13','2025-11-29 08:09:13',1,85,'dc263a37-fc13-43a6-873f-c56711cadd58',33,'28c3d09b9e21417cb7bc44b8552f1b81','volumes',1,'2025-11-30 08:09:13',NULL),('2025-11-29 08:09:13','2025-11-29 08:09:13','2025-11-29 08:09:13',1,86,'47b588c0-80aa-43aa-b486-7e1c60a17a66',34,'28c3d09b9e21417cb7bc44b8552f1b81','gigabytes',1,'2025-11-30 08:09:13',NULL),('2025-11-29 08:09:13','2025-11-29 08:09:13','2025-11-29 08:09:13',1,87,'14224f95-a6dd-4871-97fd-a06ad234eb2d',35,'28c3d09b9e21417cb7bc44b8552f1b81','volumes___DEFAULT__',1,'2025-11-30 08:09:13',NULL),('2025-11-29 08:09:13','2025-11-29 08:09:13','2025-11-29 08:09:13',1,88,'daffa947-8ef3-4882-a229-87de9a793c24',36,'28c3d09b9e21417cb7bc44b8552f1b81','gigabytes___DEFAULT__',1,'2025-11-30 08:09:13',NULL),('2025-11-29 08:09:14','2025-11-29 08:09:14','2025-11-29 08:09:14',1,89,'12bfe138-e93d-4a48-b7c4-646e3597e0f2',33,'28c3d09b9e21417cb7bc44b8552f1b81','volumes',1,'2025-11-30 08:09:14',NULL),('2025-11-29 08:09:14','2025-11-29 08:09:14','2025-11-29 08:09:14',1,90,'19b88ea4-d08f-4287-a792-e1bebd4dddae',34,'28c3d09b9e21417cb7bc44b8552f1b81','gigabytes',1,'2025-11-30 08:09:14',NULL),('2025-11-29 08:09:14','2025-11-29 08:09:14','2025-11-29 08:09:14',1,91,'1fd15d84-fbc9-44b7-959c-61a1ae042a9a',35,'28c3d09b9e21417cb7bc44b8552f1b81','volumes___DEFAULT__',1,'2025-11-30 08:09:14',NULL),('2025-11-29 08:09:14','2025-11-29 08:09:14','2025-11-29 08:09:14',1,92,'c84bc639-54a0-48d5-8afd-bfe713e6da58',36,'28c3d09b9e21417cb7bc44b8552f1b81','gigabytes___DEFAULT__',1,'2025-11-30 08:09:14',NULL),('2025-11-29 08:11:11','2025-11-29 08:11:11','2025-11-29 08:11:11',1,93,'aeded676-ad08-42ee-ba56-b45c0dc8763e',33,'28c3d09b9e21417cb7bc44b8552f1b81','volumes',-1,'2025-11-30 08:11:11',NULL),('2025-11-29 08:11:11','2025-11-29 08:11:11','2025-11-29 08:11:11',1,94,'51afa895-6bea-4bad-9bc1-e2cb1340031d',34,'28c3d09b9e21417cb7bc44b8552f1b81','gigabytes',-1,'2025-11-30 08:11:11',NULL),('2025-11-29 08:11:11','2025-11-29 08:11:11','2025-11-29 08:11:11',1,95,'e34947b1-2608-4da9-96eb-166b33409338',35,'28c3d09b9e21417cb7bc44b8552f1b81','volumes___DEFAULT__',-1,'2025-11-30 08:11:11',NULL),('2025-11-29 08:11:11','2025-11-29 08:11:11','2025-11-29 08:11:11',1,96,'247f671a-5d8c-4442-b2eb-439c3c568cdf',36,'28c3d09b9e21417cb7bc44b8552f1b81','gigabytes___DEFAULT__',-1,'2025-11-30 08:11:11',NULL),('2025-11-29 08:11:13','2025-11-29 08:11:13','2025-11-29 08:11:13',1,97,'9164e319-2946-4025-9c16-7270c105f825',33,'28c3d09b9e21417cb7bc44b8552f1b81','volumes',-1,'2025-11-30 08:11:13',NULL),('2025-11-29 08:11:13','2025-11-29 08:11:13','2025-11-29 08:11:13',1,98,'e4b5d946-5e1b-46d0-ada0-49797e3a84e3',34,'28c3d09b9e21417cb7bc44b8552f1b81','gigabytes',-1,'2025-11-30 08:11:13',NULL),('2025-11-29 08:11:13','2025-11-29 08:11:13','2025-11-29 08:11:13',1,99,'9d1e71c9-30eb-4e92-b2c5-6346c9778a1b',35,'28c3d09b9e21417cb7bc44b8552f1b81','volumes___DEFAULT__',-1,'2025-11-30 08:11:13',NULL),('2025-11-29 08:11:13','2025-11-29 08:11:13','2025-11-29 08:11:13',1,100,'5b89cc8d-8bbf-4928-a134-d26115cda313',36,'28c3d09b9e21417cb7bc44b8552f1b81','gigabytes___DEFAULT__',-1,'2025-11-30 08:11:13',NULL),('2025-11-29 08:11:15','2025-11-29 08:11:15','2025-11-29 08:11:15',1,101,'8f85d684-072e-49ee-b349-baad4643b590',33,'28c3d09b9e21417cb7bc44b8552f1b81','volumes',-1,'2025-11-30 08:11:15',NULL),('2025-11-29 08:11:15','2025-11-29 08:11:15','2025-11-29 08:11:15',1,102,'41a84334-8dac-4c79-8722-08394e9fba67',34,'28c3d09b9e21417cb7bc44b8552f1b81','gigabytes',-1,'2025-11-30 08:11:15',NULL),('2025-11-29 08:11:15','2025-11-29 08:11:15','2025-11-29 08:11:15',1,103,'644784cd-fcbe-43ca-b53d-f6447c3241e9',35,'28c3d09b9e21417cb7bc44b8552f1b81','volumes___DEFAULT__',-1,'2025-11-30 08:11:15',NULL),('2025-11-29 08:11:15','2025-11-29 08:11:15','2025-11-29 08:11:15',1,104,'db4d8cee-3889-4a63-a7e3-a690fd1d7e01',36,'28c3d09b9e21417cb7bc44b8552f1b81','gigabytes___DEFAULT__',-1,'2025-11-30 08:11:15',NULL),('2025-11-29 08:13:30','2025-11-29 08:13:30','2025-11-29 08:13:30',1,105,'6f1a7303-f9d1-4b4c-8163-7673a5cc91b1',37,'b5f1f0d72cd0427a8cda48db244caf6c','volumes',1,'2025-11-30 08:13:30',NULL),('2025-11-29 08:13:30','2025-11-29 08:13:30','2025-11-29 08:13:30',1,106,'b1ac7637-e82b-411e-a2ff-e35e732ee681',38,'b5f1f0d72cd0427a8cda48db244caf6c','gigabytes',1,'2025-11-30 08:13:30',NULL),('2025-11-29 08:13:30','2025-11-29 08:13:30','2025-11-29 08:13:30',1,107,'378d5ccf-2790-4026-942a-8ba07ad1b118',39,'b5f1f0d72cd0427a8cda48db244caf6c','volumes___DEFAULT__',1,'2025-11-30 08:13:30',NULL),('2025-11-29 08:13:30','2025-11-29 08:13:30','2025-11-29 08:13:30',1,108,'3dcaee9f-ee37-4297-9fca-9a3d129182c9',40,'b5f1f0d72cd0427a8cda48db244caf6c','gigabytes___DEFAULT__',1,'2025-11-30 08:13:30',NULL),('2025-11-29 08:14:52','2025-11-29 08:14:52','2025-11-29 08:14:52',1,109,'3df1aa1e-4b1b-40e0-babd-2758341e8346',37,'b5f1f0d72cd0427a8cda48db244caf6c','volumes',-1,'2025-11-30 08:14:52',NULL),('2025-11-29 08:14:52','2025-11-29 08:14:52','2025-11-29 08:14:52',1,110,'35865ba7-ec4f-42e8-a42f-3c42ed5e8ed6',38,'b5f1f0d72cd0427a8cda48db244caf6c','gigabytes',-1,'2025-11-30 08:14:52',NULL),('2025-11-29 08:14:52','2025-11-29 08:14:52','2025-11-29 08:14:52',1,111,'7c6b9cdb-12f8-4367-ab2d-6d573e192192',39,'b5f1f0d72cd0427a8cda48db244caf6c','volumes___DEFAULT__',-1,'2025-11-30 08:14:52',NULL),('2025-11-29 08:14:52','2025-11-29 08:14:52','2025-11-29 08:14:52',1,112,'5d8bcf96-e463-4d1d-8819-aa4ac277a514',40,'b5f1f0d72cd0427a8cda48db244caf6c','gigabytes___DEFAULT__',-1,'2025-11-30 08:14:52',NULL),('2025-11-29 08:15:39','2025-11-29 08:15:39','2025-11-29 08:15:39',1,113,'c0b0f311-a4e0-4cd1-8c8f-4c07edb36f45',41,'1b8899f76f554afc96bb2441424e5a77','volumes',1,'2025-11-30 08:15:38',NULL),('2025-11-29 08:15:39','2025-11-29 08:15:39','2025-11-29 08:15:39',1,114,'aa32ff2b-ef61-4dce-a73e-4eebf47d4f4f',42,'1b8899f76f554afc96bb2441424e5a77','gigabytes',1,'2025-11-30 08:15:38',NULL),('2025-11-29 08:15:39','2025-11-29 08:15:39','2025-11-29 08:15:39',1,115,'eae3f3e8-2a9e-4f62-abb7-9d99eac29c6e',43,'1b8899f76f554afc96bb2441424e5a77','volumes___DEFAULT__',1,'2025-11-30 08:15:38',NULL),('2025-11-29 08:15:39','2025-11-29 08:15:39','2025-11-29 08:15:39',1,116,'0e23adea-b43d-45d9-b8a8-d168e5d6225b',44,'1b8899f76f554afc96bb2441424e5a77','gigabytes___DEFAULT__',1,'2025-11-30 08:15:38',NULL),('2025-11-29 08:15:46','2025-11-29 08:15:46','2025-11-29 08:15:46',1,117,'59bc3884-6b21-4343-916d-8da231b3143a',45,'9e6235234e63419ead82cbd9a07d500f','volumes',1,'2025-11-30 08:15:46',NULL),('2025-11-29 08:15:46','2025-11-29 08:15:46','2025-11-29 08:15:46',1,118,'63530ab3-7097-469a-8718-6ec5331b2987',46,'9e6235234e63419ead82cbd9a07d500f','gigabytes',1,'2025-11-30 08:15:46',NULL),('2025-11-29 08:15:46','2025-11-29 08:15:46','2025-11-29 08:15:46',1,119,'216e3abe-c919-4244-b9f4-e1c271dace54',47,'9e6235234e63419ead82cbd9a07d500f','volumes___DEFAULT__',1,'2025-11-30 08:15:46',NULL),('2025-11-29 08:15:46','2025-11-29 08:15:46','2025-11-29 08:15:46',1,120,'0e503e0b-662a-4b48-90b5-ffbdba55c8ae',48,'9e6235234e63419ead82cbd9a07d500f','gigabytes___DEFAULT__',1,'2025-11-30 08:15:46',NULL),('2025-11-29 08:15:56','2025-11-29 08:15:56','2025-11-29 08:15:56',1,121,'54c706a8-b7f3-44d6-a25f-1c5c6d62b5bc',45,'9e6235234e63419ead82cbd9a07d500f','volumes',1,'2025-11-30 08:15:56',NULL),('2025-11-29 08:15:56','2025-11-29 08:15:56','2025-11-29 08:15:56',1,122,'5fa80e7a-af60-401c-8864-c29e15af8b73',46,'9e6235234e63419ead82cbd9a07d500f','gigabytes',1,'2025-11-30 08:15:56',NULL),('2025-11-29 08:15:56','2025-11-29 08:15:56','2025-11-29 08:15:56',1,123,'d68d48b7-6427-4bce-8714-9fce61e3f5b4',47,'9e6235234e63419ead82cbd9a07d500f','volumes___DEFAULT__',1,'2025-11-30 08:15:56',NULL),('2025-11-29 08:15:56','2025-11-29 08:15:56','2025-11-29 08:15:56',1,124,'fa1bff0a-b496-444a-a4d9-0b798e03530b',48,'9e6235234e63419ead82cbd9a07d500f','gigabytes___DEFAULT__',1,'2025-11-30 08:15:56',NULL),('2025-11-29 08:15:57','2025-11-29 08:15:57','2025-11-29 08:15:57',1,125,'d65c9ad4-1b7a-4177-b00d-cd38452a87bc',45,'9e6235234e63419ead82cbd9a07d500f','volumes',1,'2025-11-30 08:15:57',NULL),('2025-11-29 08:15:57','2025-11-29 08:15:57','2025-11-29 08:15:57',1,126,'86aadf6f-a632-490c-929d-b96109fab198',46,'9e6235234e63419ead82cbd9a07d500f','gigabytes',1,'2025-11-30 08:15:57',NULL),('2025-11-29 08:15:57','2025-11-29 08:15:57','2025-11-29 08:15:57',1,127,'3a361478-e944-4f6f-a884-f967c58f3fe4',47,'9e6235234e63419ead82cbd9a07d500f','volumes___DEFAULT__',1,'2025-11-30 08:15:57',NULL),('2025-11-29 08:15:57','2025-11-29 08:15:57','2025-11-29 08:15:57',1,128,'cd93c976-463e-4b98-b600-5343fdd806bb',48,'9e6235234e63419ead82cbd9a07d500f','gigabytes___DEFAULT__',1,'2025-11-30 08:15:57',NULL),('2025-11-29 08:17:59','2025-11-29 08:17:59','2025-11-29 08:17:59',1,129,'bf0b2148-8bee-40d2-bea5-9fd1152d198a',45,'9e6235234e63419ead82cbd9a07d500f','volumes',-1,'2025-11-30 08:17:59',NULL),('2025-11-29 08:17:59','2025-11-29 08:17:59','2025-11-29 08:17:59',1,130,'09bce74e-13ac-4300-8cda-06646784cc65',46,'9e6235234e63419ead82cbd9a07d500f','gigabytes',-1,'2025-11-30 08:17:59',NULL),('2025-11-29 08:17:59','2025-11-29 08:17:59','2025-11-29 08:17:59',1,131,'7ec1c3bb-4f47-491a-8773-1dc111b8893a',47,'9e6235234e63419ead82cbd9a07d500f','volumes___DEFAULT__',-1,'2025-11-30 08:17:59',NULL),('2025-11-29 08:17:59','2025-11-29 08:17:59','2025-11-29 08:17:59',1,132,'f170ccf4-aef2-4fc2-83d9-285605df36b8',48,'9e6235234e63419ead82cbd9a07d500f','gigabytes___DEFAULT__',-1,'2025-11-30 08:17:59',NULL),('2025-11-29 08:18:03','2025-11-29 08:18:03','2025-11-29 08:18:03',1,133,'15dc3228-a92f-40bc-815a-799407b38193',45,'9e6235234e63419ead82cbd9a07d500f','volumes',-1,'2025-11-30 08:18:03',NULL),('2025-11-29 08:18:03','2025-11-29 08:18:03','2025-11-29 08:18:03',1,134,'870a0def-b070-4c52-83ff-37fe7020e3ca',46,'9e6235234e63419ead82cbd9a07d500f','gigabytes',-1,'2025-11-30 08:18:03',NULL),('2025-11-29 08:18:03','2025-11-29 08:18:03','2025-11-29 08:18:03',1,135,'c5b3fda4-8690-4aed-aa03-e25e3ecd7d5b',47,'9e6235234e63419ead82cbd9a07d500f','volumes___DEFAULT__',-1,'2025-11-30 08:18:03',NULL),('2025-11-29 08:18:03','2025-11-29 08:18:03','2025-11-29 08:18:03',1,136,'3e0b52b8-9612-42fb-9fe2-11b8bb1cee93',48,'9e6235234e63419ead82cbd9a07d500f','gigabytes___DEFAULT__',-1,'2025-11-30 08:18:03',NULL),('2025-11-29 08:18:09','2025-11-29 08:18:09','2025-11-29 08:18:09',1,137,'5488fed6-27a5-4221-8db9-6277b5144876',45,'9e6235234e63419ead82cbd9a07d500f','volumes',-1,'2025-11-30 08:18:09',NULL),('2025-11-29 08:18:09','2025-11-29 08:18:09','2025-11-29 08:18:09',1,138,'cdac8645-0be7-4c20-8090-8821ebb2d53e',46,'9e6235234e63419ead82cbd9a07d500f','gigabytes',-1,'2025-11-30 08:18:09',NULL),('2025-11-29 08:18:09','2025-11-29 08:18:09','2025-11-29 08:18:09',1,139,'fcd405be-3975-48ea-aa95-edfe77b37454',47,'9e6235234e63419ead82cbd9a07d500f','volumes___DEFAULT__',-1,'2025-11-30 08:18:09',NULL),('2025-11-29 08:18:09','2025-11-29 08:18:09','2025-11-29 08:18:09',1,140,'fa2fafcf-7a39-41e2-8f19-4a3b5ca971ee',48,'9e6235234e63419ead82cbd9a07d500f','gigabytes___DEFAULT__',-1,'2025-11-30 08:18:09',NULL),('2025-11-29 08:18:42','2025-11-29 08:18:42','2025-11-29 08:18:42',1,141,'05eb9e64-427f-434a-aafa-e00c1ba27de3',49,'8d6a508547b04ab19c5e5aa532a792a1','volumes',1,'2025-11-30 08:18:42',NULL),('2025-11-29 08:18:42','2025-11-29 08:18:42','2025-11-29 08:18:42',1,142,'35502765-ed3f-4cce-9b3f-b210d44ab064',50,'8d6a508547b04ab19c5e5aa532a792a1','gigabytes',1,'2025-11-30 08:18:42',NULL),('2025-11-29 08:18:42','2025-11-29 08:18:42','2025-11-29 08:18:42',1,143,'8f9a1b7f-3722-457c-858d-e1ec68083bda',51,'8d6a508547b04ab19c5e5aa532a792a1','volumes___DEFAULT__',1,'2025-11-30 08:18:42',NULL),('2025-11-29 08:18:42','2025-11-29 08:18:42','2025-11-29 08:18:42',1,144,'496b2adf-4918-4751-9b6b-4433905cca1a',52,'8d6a508547b04ab19c5e5aa532a792a1','gigabytes___DEFAULT__',1,'2025-11-30 08:18:42',NULL),('2025-11-29 08:18:44','2025-11-29 08:18:44','2025-11-29 08:18:44',1,145,'37691d33-d58a-47e9-b4a0-f7daf13a6dfe',49,'8d6a508547b04ab19c5e5aa532a792a1','volumes',1,'2025-11-30 08:18:44',NULL),('2025-11-29 08:18:44','2025-11-29 08:18:44','2025-11-29 08:18:44',1,146,'58e07ba9-4d60-41fb-b2e1-b1fadf7e675f',50,'8d6a508547b04ab19c5e5aa532a792a1','gigabytes',1,'2025-11-30 08:18:44',NULL),('2025-11-29 08:18:44','2025-11-29 08:18:44','2025-11-29 08:18:44',1,147,'903da82e-fc76-44ae-a720-2459116f5524',51,'8d6a508547b04ab19c5e5aa532a792a1','volumes___DEFAULT__',1,'2025-11-30 08:18:44',NULL),('2025-11-29 08:18:44','2025-11-29 08:18:44','2025-11-29 08:18:44',1,148,'5354a3a2-8313-4ba0-9ac6-d7015fccf4a6',52,'8d6a508547b04ab19c5e5aa532a792a1','gigabytes___DEFAULT__',1,'2025-11-30 08:18:44',NULL),('2025-11-29 08:18:44','2025-11-29 08:18:44','2025-11-29 08:18:44',1,149,'c926ef83-99c6-4a11-adc9-0e0bd6bfbb6c',41,'1b8899f76f554afc96bb2441424e5a77','volumes',-1,'2025-11-30 08:18:44',NULL),('2025-11-29 08:18:44','2025-11-29 08:18:44','2025-11-29 08:18:44',1,150,'1cb14488-7d39-4b03-9052-001d9362dde2',42,'1b8899f76f554afc96bb2441424e5a77','gigabytes',-1,'2025-11-30 08:18:44',NULL),('2025-11-29 08:18:44','2025-11-29 08:18:44','2025-11-29 08:18:44',1,151,'18704ada-33a5-432e-a058-3103ff12512b',43,'1b8899f76f554afc96bb2441424e5a77','volumes___DEFAULT__',-1,'2025-11-30 08:18:44',NULL),('2025-11-29 08:18:44','2025-11-29 08:18:44','2025-11-29 08:18:44',1,152,'76a289c0-b8c0-42c7-814e-7755f50aae24',44,'1b8899f76f554afc96bb2441424e5a77','gigabytes___DEFAULT__',-1,'2025-11-30 08:18:44',NULL),('2025-11-29 08:18:46','2025-11-29 08:18:46','2025-11-29 08:18:46',1,153,'197512c6-2016-49cd-b81d-bb5b304e8767',49,'8d6a508547b04ab19c5e5aa532a792a1','volumes',1,'2025-11-30 08:18:46',NULL),('2025-11-29 08:18:46','2025-11-29 08:18:46','2025-11-29 08:18:46',1,154,'79fedc74-6e13-4cef-9210-333a52ba0170',50,'8d6a508547b04ab19c5e5aa532a792a1','gigabytes',1,'2025-11-30 08:18:46',NULL),('2025-11-29 08:18:46','2025-11-29 08:18:46','2025-11-29 08:18:46',1,155,'f778611c-f605-4f13-a5ca-edc7f80b9b07',51,'8d6a508547b04ab19c5e5aa532a792a1','volumes___DEFAULT__',1,'2025-11-30 08:18:46',NULL),('2025-11-29 08:18:46','2025-11-29 08:18:46','2025-11-29 08:18:46',1,156,'6e6dedee-5a1e-4259-9766-a8cac1d7d584',52,'8d6a508547b04ab19c5e5aa532a792a1','gigabytes___DEFAULT__',1,'2025-11-30 08:18:46',NULL),('2025-11-29 08:18:50','2025-11-29 08:18:50','2025-11-29 08:18:50',1,157,'cc74607b-40c5-4477-9829-227c60194b23',49,'8d6a508547b04ab19c5e5aa532a792a1','volumes',-1,'2025-11-30 08:18:50',NULL),('2025-11-29 08:18:50','2025-11-29 08:18:50','2025-11-29 08:18:50',1,158,'f1a3377d-b481-443e-8a34-9624e4ca8885',50,'8d6a508547b04ab19c5e5aa532a792a1','gigabytes',-1,'2025-11-30 08:18:50',NULL),('2025-11-29 08:18:50','2025-11-29 08:18:50','2025-11-29 08:18:50',1,159,'c42e6627-89d2-4271-9128-37fd08ad9973',51,'8d6a508547b04ab19c5e5aa532a792a1','volumes___DEFAULT__',-1,'2025-11-30 08:18:50',NULL),('2025-11-29 08:18:50','2025-11-29 08:18:50','2025-11-29 08:18:50',1,160,'3876f769-e324-4832-85f6-11a38ea789a0',52,'8d6a508547b04ab19c5e5aa532a792a1','gigabytes___DEFAULT__',-1,'2025-11-30 08:18:50',NULL),('2025-11-29 08:18:52','2025-11-29 08:18:52','2025-11-29 08:18:52',1,161,'33b73cf7-e166-4dbb-9f01-be93a4c10339',49,'8d6a508547b04ab19c5e5aa532a792a1','volumes',-1,'2025-11-30 08:18:52',NULL),('2025-11-29 08:18:52','2025-11-29 08:18:52','2025-11-29 08:18:52',1,162,'374b6e2c-ea23-4446-a5e6-ccc2e6fd3664',50,'8d6a508547b04ab19c5e5aa532a792a1','gigabytes',-1,'2025-11-30 08:18:52',NULL),('2025-11-29 08:18:52','2025-11-29 08:18:52','2025-11-29 08:18:52',1,163,'0a94b55f-568d-418d-863d-dfca604abd02',51,'8d6a508547b04ab19c5e5aa532a792a1','volumes___DEFAULT__',-1,'2025-11-30 08:18:52',NULL),('2025-11-29 08:18:52','2025-11-29 08:18:52','2025-11-29 08:18:52',1,164,'c3619f27-a76b-4733-8969-8cfd54d3b048',52,'8d6a508547b04ab19c5e5aa532a792a1','gigabytes___DEFAULT__',-1,'2025-11-30 08:18:52',NULL),('2025-11-29 08:18:53','2025-11-29 08:18:53','2025-11-29 08:18:53',1,165,'5738fa00-87f1-4f6f-9e0f-460eb8aaa538',49,'8d6a508547b04ab19c5e5aa532a792a1','volumes',-1,'2025-11-30 08:18:53',NULL),('2025-11-29 08:18:53','2025-11-29 08:18:53','2025-11-29 08:18:53',1,166,'352aa575-d8a0-4925-b940-30de9917217f',50,'8d6a508547b04ab19c5e5aa532a792a1','gigabytes',-1,'2025-11-30 08:18:53',NULL),('2025-11-29 08:18:53','2025-11-29 08:18:53','2025-11-29 08:18:53',1,167,'026e021c-001d-4ebf-82a3-2692aa419498',51,'8d6a508547b04ab19c5e5aa532a792a1','volumes___DEFAULT__',-1,'2025-11-30 08:18:53',NULL),('2025-11-29 08:18:53','2025-11-29 08:18:53','2025-11-29 08:18:53',1,168,'7af1e783-5a94-411b-b1ab-a417c63ffaaf',52,'8d6a508547b04ab19c5e5aa532a792a1','gigabytes___DEFAULT__',-1,'2025-11-30 08:18:53',NULL),('2025-11-29 08:19:11','2025-11-29 08:19:11','2025-11-29 08:19:11',1,169,'47d4810b-0bda-40b3-8cdf-6d7752c20cfb',53,'696ec278f2ec426fa75ebb50bdf1c16a','volumes',1,'2025-11-30 08:19:11',NULL),('2025-11-29 08:19:11','2025-11-29 08:19:11','2025-11-29 08:19:11',1,170,'11f3bd8e-e9ae-487c-ac3c-5ab98de273a4',54,'696ec278f2ec426fa75ebb50bdf1c16a','gigabytes',1,'2025-11-30 08:19:11',NULL),('2025-11-29 08:19:11','2025-11-29 08:19:11','2025-11-29 08:19:11',1,171,'79173da4-a3d1-4602-bc4d-911712e32344',55,'696ec278f2ec426fa75ebb50bdf1c16a','volumes___DEFAULT__',1,'2025-11-30 08:19:11',NULL),('2025-11-29 08:19:11','2025-11-29 08:19:11','2025-11-29 08:19:11',1,172,'4aeaefbb-229e-4c1a-be5e-0c727c48abf8',56,'696ec278f2ec426fa75ebb50bdf1c16a','gigabytes___DEFAULT__',1,'2025-11-30 08:19:11',NULL),('2025-11-29 08:20:50','2025-11-29 08:20:50','2025-11-29 08:20:50',1,173,'b8a1838e-98d2-4ccc-9644-bc4712e182ad',53,'696ec278f2ec426fa75ebb50bdf1c16a','volumes',-1,'2025-11-30 08:20:50',NULL),('2025-11-29 08:20:50','2025-11-29 08:20:50','2025-11-29 08:20:50',1,174,'40d64d50-88a3-4b6c-a001-410ca8baad6e',54,'696ec278f2ec426fa75ebb50bdf1c16a','gigabytes',-1,'2025-11-30 08:20:50',NULL),('2025-11-29 08:20:50','2025-11-29 08:20:50','2025-11-29 08:20:50',1,175,'0c53694d-f512-4f56-81b8-6f5d74aca5d7',55,'696ec278f2ec426fa75ebb50bdf1c16a','volumes___DEFAULT__',-1,'2025-11-30 08:20:50',NULL),('2025-11-29 08:20:50','2025-11-29 08:20:50','2025-11-29 08:20:50',1,176,'a7be2d6d-79e6-43fd-82f4-8f57188882cc',56,'696ec278f2ec426fa75ebb50bdf1c16a','gigabytes___DEFAULT__',-1,'2025-11-30 08:20:50',NULL),('2025-11-29 08:21:46','2025-11-29 08:21:46','2025-11-29 08:21:46',1,177,'5bb530e1-6d91-4ff4-b4eb-e4b6be538480',57,'0bace34c102e4d56b089fd695d324f10','volumes',1,'2025-11-30 08:21:46',NULL),('2025-11-29 08:21:46','2025-11-29 08:21:46','2025-11-29 08:21:46',1,178,'c1a410a3-633b-4cf6-9ea4-14d19bc32d95',58,'0bace34c102e4d56b089fd695d324f10','gigabytes',1,'2025-11-30 08:21:46',NULL),('2025-11-29 08:21:46','2025-11-29 08:21:46','2025-11-29 08:21:46',1,179,'35a41bb6-d35f-4ee0-b900-d6afd1dcedc2',59,'0bace34c102e4d56b089fd695d324f10','volumes___DEFAULT__',1,'2025-11-30 08:21:46',NULL),('2025-11-29 08:21:46','2025-11-29 08:21:46','2025-11-29 08:21:46',1,180,'8026a53c-e93e-4fb6-8500-df836d2f6c54',60,'0bace34c102e4d56b089fd695d324f10','gigabytes___DEFAULT__',1,'2025-11-30 08:21:46',NULL),('2025-11-29 08:23:35','2025-11-29 08:23:35','2025-11-29 08:23:35',1,181,'c2df6e24-2ac3-40d8-becb-adcc93bae7f6',57,'0bace34c102e4d56b089fd695d324f10','volumes',1,'2025-11-30 08:23:35',NULL),('2025-11-29 08:23:35','2025-11-29 08:23:35','2025-11-29 08:23:35',1,182,'c196ef5a-7364-43fe-a5f4-e5b4a50d48d8',58,'0bace34c102e4d56b089fd695d324f10','gigabytes',1,'2025-11-30 08:23:35',NULL),('2025-11-29 08:23:35','2025-11-29 08:23:35','2025-11-29 08:23:35',1,183,'bc253dd8-677f-4140-a95f-7bdcd566be55',59,'0bace34c102e4d56b089fd695d324f10','volumes___DEFAULT__',1,'2025-11-30 08:23:35',NULL),('2025-11-29 08:23:35','2025-11-29 08:23:35','2025-11-29 08:23:35',1,184,'7ebc79d6-c033-4350-bf08-74dc5e21a4a5',60,'0bace34c102e4d56b089fd695d324f10','gigabytes___DEFAULT__',1,'2025-11-30 08:23:35',NULL),('2025-11-29 08:25:14','2025-11-29 08:25:14','2025-11-29 08:25:14',1,185,'4cc0e00c-3ebc-4e64-835b-3e2b0f4f772f',57,'0bace34c102e4d56b089fd695d324f10','volumes',-1,'2025-11-30 08:25:14',NULL),('2025-11-29 08:25:14','2025-11-29 08:25:14','2025-11-29 08:25:14',1,186,'86a3b6fe-31eb-4dde-a672-7dc0e64b3162',58,'0bace34c102e4d56b089fd695d324f10','gigabytes',-1,'2025-11-30 08:25:14',NULL),('2025-11-29 08:25:14','2025-11-29 08:25:14','2025-11-29 08:25:14',1,187,'753d1f98-2e9c-43cd-af3e-14ffe9778846',59,'0bace34c102e4d56b089fd695d324f10','volumes___DEFAULT__',-1,'2025-11-30 08:25:14',NULL),('2025-11-29 08:25:14','2025-11-29 08:25:14','2025-11-29 08:25:14',1,188,'939c2663-3c02-43c7-ab95-f60ef1b1d6be',60,'0bace34c102e4d56b089fd695d324f10','gigabytes___DEFAULT__',-1,'2025-11-30 08:25:14',NULL),('2025-11-29 08:25:19','2025-11-29 08:25:19','2025-11-29 08:25:19',1,189,'76ef3c79-cc40-4f27-b856-7a42ab97167f',57,'0bace34c102e4d56b089fd695d324f10','volumes',-1,'2025-11-30 08:25:19',NULL),('2025-11-29 08:25:19','2025-11-29 08:25:19','2025-11-29 08:25:19',1,190,'eb7f29ec-8891-41de-bb1c-c449cfce8851',58,'0bace34c102e4d56b089fd695d324f10','gigabytes',-1,'2025-11-30 08:25:19',NULL),('2025-11-29 08:25:19','2025-11-29 08:25:19','2025-11-29 08:25:19',1,191,'1aaa3b8a-bddc-4cbd-acd2-45adf8a1a993',59,'0bace34c102e4d56b089fd695d324f10','volumes___DEFAULT__',-1,'2025-11-30 08:25:19',NULL),('2025-11-29 08:25:19','2025-11-29 08:25:19','2025-11-29 08:25:19',1,192,'3daefed1-6a8c-4c77-9eda-8c4b27e3ee7c',60,'0bace34c102e4d56b089fd695d324f10','gigabytes___DEFAULT__',-1,'2025-11-30 08:25:19',NULL),('2025-11-29 08:26:07','2025-11-29 08:26:08','2025-11-29 08:26:08',1,193,'34de5c5a-e07c-472b-a5f2-31182dccc58b',61,'a9a83f8d8d7f4d08890407f978c05166','volumes',1,'2025-11-30 08:26:07',NULL),('2025-11-29 08:26:07','2025-11-29 08:26:08','2025-11-29 08:26:08',1,194,'748f704d-4c15-49a1-b37c-48ccf8c7e71d',62,'a9a83f8d8d7f4d08890407f978c05166','gigabytes',1,'2025-11-30 08:26:07',NULL),('2025-11-29 08:26:07','2025-11-29 08:26:08','2025-11-29 08:26:08',1,195,'ea32aed7-7dc5-4ee4-bb95-5eb1a1fe0f97',63,'a9a83f8d8d7f4d08890407f978c05166','volumes___DEFAULT__',1,'2025-11-30 08:26:07',NULL),('2025-11-29 08:26:07','2025-11-29 08:26:08','2025-11-29 08:26:08',1,196,'2c117659-ebf3-4d4b-823b-0f975f94a35f',64,'a9a83f8d8d7f4d08890407f978c05166','gigabytes___DEFAULT__',1,'2025-11-30 08:26:07',NULL),('2025-11-29 08:26:59','2025-11-29 08:26:59','2025-11-29 08:26:59',1,197,'3fb18e2d-5eaf-4fe8-bce0-ef3879bd632a',65,'ea7b24ea9d7b4d239b4741634ac3f10c','volumes',1,'2025-11-30 08:26:58',NULL),('2025-11-29 08:26:59','2025-11-29 08:26:59','2025-11-29 08:26:59',1,198,'5101ec0f-0788-4699-8830-bc1438e63b78',66,'ea7b24ea9d7b4d239b4741634ac3f10c','gigabytes',1,'2025-11-30 08:26:58',NULL),('2025-11-29 08:26:59','2025-11-29 08:26:59','2025-11-29 08:26:59',1,199,'b8136be7-9772-4ac4-9e68-20975d9ca431',67,'ea7b24ea9d7b4d239b4741634ac3f10c','volumes___DEFAULT__',1,'2025-11-30 08:26:58',NULL),('2025-11-29 08:26:59','2025-11-29 08:26:59','2025-11-29 08:26:59',1,200,'239b709e-8fba-43db-9f2d-b9aeeb07d910',68,'ea7b24ea9d7b4d239b4741634ac3f10c','gigabytes___DEFAULT__',1,'2025-11-30 08:26:58',NULL),('2025-11-29 08:27:21','2025-11-29 08:27:21','2025-11-29 08:27:21',1,201,'693924a5-5d32-464b-bb84-02f7acec5c13',65,'ea7b24ea9d7b4d239b4741634ac3f10c','volumes',1,'2025-11-30 08:27:21',NULL),('2025-11-29 08:27:21','2025-11-29 08:27:21','2025-11-29 08:27:21',1,202,'9a517925-71e0-4625-a032-343dd9214f8a',66,'ea7b24ea9d7b4d239b4741634ac3f10c','gigabytes',1,'2025-11-30 08:27:21',NULL),('2025-11-29 08:27:21','2025-11-29 08:27:21','2025-11-29 08:27:21',1,203,'0aac63b1-983e-4d01-838d-4e09836a2615',67,'ea7b24ea9d7b4d239b4741634ac3f10c','volumes___DEFAULT__',1,'2025-11-30 08:27:21',NULL),('2025-11-29 08:27:21','2025-11-29 08:27:21','2025-11-29 08:27:21',1,204,'b0993a9d-7858-4044-a7f1-1e5d957ea54f',68,'ea7b24ea9d7b4d239b4741634ac3f10c','gigabytes___DEFAULT__',1,'2025-11-30 08:27:21',NULL),('2025-11-29 08:27:41','2025-11-29 08:27:41','2025-11-29 08:27:41',1,205,'0c91563e-69cb-4d0a-aafc-68bc4f675d1e',69,'ae71059d02774857be85797a3be0e4e6','volumes',1,'2025-11-30 08:27:41',NULL),('2025-11-29 08:27:41','2025-11-29 08:27:41','2025-11-29 08:27:41',1,206,'e274fa86-47d1-4162-b3ef-d369ca00d689',70,'ae71059d02774857be85797a3be0e4e6','gigabytes',1,'2025-11-30 08:27:41',NULL),('2025-11-29 08:27:41','2025-11-29 08:27:41','2025-11-29 08:27:41',1,207,'bf758cc6-b854-425a-a0d5-b8fad18da153',71,'ae71059d02774857be85797a3be0e4e6','volumes___DEFAULT__',1,'2025-11-30 08:27:41',NULL),('2025-11-29 08:27:41','2025-11-29 08:27:41','2025-11-29 08:27:41',1,208,'16330d08-0577-4a0b-b150-f5f3b8d871fd',72,'ae71059d02774857be85797a3be0e4e6','gigabytes___DEFAULT__',1,'2025-11-30 08:27:41',NULL),('2025-11-29 08:28:00','2025-11-29 08:28:00','2025-11-29 08:28:00',1,209,'9a90bc5f-538f-4bf9-93f9-e0a94acb5ba9',61,'a9a83f8d8d7f4d08890407f978c05166','volumes',-1,'2025-11-30 08:28:00',NULL),('2025-11-29 08:28:00','2025-11-29 08:28:00','2025-11-29 08:28:00',1,210,'616b09aa-0b3b-49a9-b522-3d86bb8369dd',62,'a9a83f8d8d7f4d08890407f978c05166','gigabytes',-1,'2025-11-30 08:28:00',NULL),('2025-11-29 08:28:00','2025-11-29 08:28:00','2025-11-29 08:28:00',1,211,'27b0c38c-4e49-4183-953c-22245d45c8e3',63,'a9a83f8d8d7f4d08890407f978c05166','volumes___DEFAULT__',-1,'2025-11-30 08:28:00',NULL),('2025-11-29 08:28:00','2025-11-29 08:28:00','2025-11-29 08:28:00',1,212,'eaccaf72-60ff-49dc-82b5-f4816b6d5452',64,'a9a83f8d8d7f4d08890407f978c05166','gigabytes___DEFAULT__',-1,'2025-11-30 08:28:00',NULL),('2025-11-29 08:28:51','2025-11-29 08:28:52','2025-11-29 08:28:52',1,213,'d3c0c5e4-1d0c-4592-9eaa-612de7b6b7c4',65,'ea7b24ea9d7b4d239b4741634ac3f10c','volumes',-1,'2025-11-30 08:28:51',NULL),('2025-11-29 08:28:51','2025-11-29 08:28:52','2025-11-29 08:28:52',1,214,'c5e72222-ad59-40be-9629-9d4028997833',66,'ea7b24ea9d7b4d239b4741634ac3f10c','gigabytes',-1,'2025-11-30 08:28:51',NULL),('2025-11-29 08:28:51','2025-11-29 08:28:52','2025-11-29 08:28:52',1,215,'b4027537-f03c-470d-a23e-f0301bc8a893',67,'ea7b24ea9d7b4d239b4741634ac3f10c','volumes___DEFAULT__',-1,'2025-11-30 08:28:51',NULL),('2025-11-29 08:28:51','2025-11-29 08:28:52','2025-11-29 08:28:52',1,216,'9d55f0c5-780f-4805-8dda-19c30efa48d7',68,'ea7b24ea9d7b4d239b4741634ac3f10c','gigabytes___DEFAULT__',-1,'2025-11-30 08:28:51',NULL),('2025-11-29 08:28:53','2025-11-29 08:28:53','2025-11-29 08:28:53',1,217,'f2cd0cb8-f0e8-4210-84b3-2ad218f4ac1c',65,'ea7b24ea9d7b4d239b4741634ac3f10c','volumes',-1,'2025-11-30 08:28:53',NULL),('2025-11-29 08:28:53','2025-11-29 08:28:53','2025-11-29 08:28:53',1,218,'13640d6b-8168-4657-90b2-f1bf5d1eba57',66,'ea7b24ea9d7b4d239b4741634ac3f10c','gigabytes',-1,'2025-11-30 08:28:53',NULL),('2025-11-29 08:28:53','2025-11-29 08:28:53','2025-11-29 08:28:53',1,219,'e70b91fe-7e14-4656-81a7-e8e655464762',67,'ea7b24ea9d7b4d239b4741634ac3f10c','volumes___DEFAULT__',-1,'2025-11-30 08:28:53',NULL),('2025-11-29 08:28:53','2025-11-29 08:28:53','2025-11-29 08:28:53',1,220,'9e40241e-71f0-47dd-9254-5f9bd46367e6',68,'ea7b24ea9d7b4d239b4741634ac3f10c','gigabytes___DEFAULT__',-1,'2025-11-30 08:28:53',NULL),('2025-11-29 08:29:40','2025-11-29 08:29:41','2025-11-29 08:29:41',1,221,'221306cd-a287-4182-9294-c97b8938f9e6',69,'ae71059d02774857be85797a3be0e4e6','volumes',1,'2025-11-30 08:29:40',NULL),('2025-11-29 08:29:40','2025-11-29 08:29:41','2025-11-29 08:29:41',1,222,'3a0d49a2-dfd9-4ecf-888d-e2ffa8068e19',70,'ae71059d02774857be85797a3be0e4e6','gigabytes',1,'2025-11-30 08:29:40',NULL),('2025-11-29 08:29:40','2025-11-29 08:29:41','2025-11-29 08:29:41',1,223,'0ef06ccd-c8fa-4185-a93f-4eb317a8a551',71,'ae71059d02774857be85797a3be0e4e6','volumes___DEFAULT__',1,'2025-11-30 08:29:40',NULL),('2025-11-29 08:29:40','2025-11-29 08:29:41','2025-11-29 08:29:41',1,224,'d04fc2e5-e2d8-4054-ab7c-15c616fb2eb0',72,'ae71059d02774857be85797a3be0e4e6','gigabytes___DEFAULT__',1,'2025-11-30 08:29:40',NULL),('2025-11-29 08:31:11','2025-11-29 08:31:11','2025-11-29 08:31:11',1,225,'19b3a650-d10f-40ce-bfb1-d46a3a25419f',73,'1981e9617628491f938ef0ef01c061c5','volumes',1,'2025-11-30 08:31:11',NULL),('2025-11-29 08:31:11','2025-11-29 08:31:11','2025-11-29 08:31:11',1,226,'2d49ac7c-ba52-44e9-83bd-479d350f8aec',74,'1981e9617628491f938ef0ef01c061c5','gigabytes',1,'2025-11-30 08:31:11',NULL),('2025-11-29 08:31:11','2025-11-29 08:31:11','2025-11-29 08:31:11',1,227,'abee49c0-f3d2-4784-bc16-935bc6969405',75,'1981e9617628491f938ef0ef01c061c5','volumes___DEFAULT__',1,'2025-11-30 08:31:11',NULL),('2025-11-29 08:31:11','2025-11-29 08:31:11','2025-11-29 08:31:11',1,228,'6f43e701-37f3-4af7-9e0f-a7d765f6a15a',76,'1981e9617628491f938ef0ef01c061c5','gigabytes___DEFAULT__',1,'2025-11-30 08:31:11',NULL),('2025-11-29 08:31:17','2025-11-29 08:31:17','2025-11-29 08:31:17',1,229,'2ede8c6a-a757-45c6-bb37-aeeefba3d2dd',77,'d4f6db81949d487b853d7567f8a2e6d4','volumes',1,'2025-11-30 08:31:17',NULL),('2025-11-29 08:31:17','2025-11-29 08:31:17','2025-11-29 08:31:17',1,230,'5d003bd8-2e9c-4dfb-998d-08fbdada0506',78,'d4f6db81949d487b853d7567f8a2e6d4','gigabytes',1,'2025-11-30 08:31:17',NULL),('2025-11-29 08:31:17','2025-11-29 08:31:17','2025-11-29 08:31:17',1,231,'a08ab1dc-0631-400d-b01a-ab72f27d8eeb',79,'d4f6db81949d487b853d7567f8a2e6d4','volumes_multiattach',1,'2025-11-30 08:31:17',NULL),('2025-11-29 08:31:17','2025-11-29 08:31:17','2025-11-29 08:31:17',1,232,'ef51e64b-c720-4cfc-b07b-20f7d8612a51',80,'d4f6db81949d487b853d7567f8a2e6d4','gigabytes_multiattach',1,'2025-11-30 08:31:17',NULL),('2025-11-29 08:32:13','2025-11-29 08:32:13','2025-11-29 08:32:13',1,233,'95b06e66-4fe8-4b48-a1d6-fd61f5f0adfa',77,'d4f6db81949d487b853d7567f8a2e6d4','volumes',1,'2025-11-30 08:32:13',NULL),('2025-11-29 08:32:13','2025-11-29 08:32:13','2025-11-29 08:32:13',1,234,'596474cb-6aee-4ac2-bb6b-a60928740f10',78,'d4f6db81949d487b853d7567f8a2e6d4','gigabytes',1,'2025-11-30 08:32:13',NULL),('2025-11-29 08:32:13','2025-11-29 08:32:13','2025-11-29 08:32:13',1,235,'d1b12692-890d-43d1-a50b-09cf6009f350',79,'d4f6db81949d487b853d7567f8a2e6d4','volumes_multiattach',1,'2025-11-30 08:32:13',NULL),('2025-11-29 08:32:13','2025-11-29 08:32:13','2025-11-29 08:32:13',1,236,'2be0addb-93e3-43f8-bd12-2bfd87fd6dfd',80,'d4f6db81949d487b853d7567f8a2e6d4','gigabytes_multiattach',1,'2025-11-30 08:32:13',NULL),('2025-11-29 08:33:11','2025-11-29 08:33:11','2025-11-29 08:33:11',1,237,'1220e66a-b67e-4dba-a1ed-f25d3df2b647',77,'d4f6db81949d487b853d7567f8a2e6d4','volumes',1,'2025-11-30 08:33:11',NULL),('2025-11-29 08:33:11','2025-11-29 08:33:11','2025-11-29 08:33:11',1,238,'eed8284d-d35c-4cb5-8bd4-300123e17d87',78,'d4f6db81949d487b853d7567f8a2e6d4','gigabytes',1,'2025-11-30 08:33:11',NULL),('2025-11-29 08:33:11','2025-11-29 08:33:11','2025-11-29 08:33:11',1,239,'3e5cb31a-50ef-4459-b47c-fe1469e3d4fa',79,'d4f6db81949d487b853d7567f8a2e6d4','volumes_multiattach',1,'2025-11-30 08:33:11',NULL),('2025-11-29 08:33:11','2025-11-29 08:33:11','2025-11-29 08:33:11',1,240,'82210a5d-a3dd-4e2a-b4b0-25f345538244',80,'d4f6db81949d487b853d7567f8a2e6d4','gigabytes_multiattach',1,'2025-11-30 08:33:11',NULL),('2025-11-29 08:33:47','2025-11-29 08:33:47','2025-11-29 08:33:47',1,241,'326a785e-63ef-49b3-9552-2073dd9f33f8',73,'1981e9617628491f938ef0ef01c061c5','volumes',1,'2025-11-30 08:33:47',NULL),('2025-11-29 08:33:47','2025-11-29 08:33:47','2025-11-29 08:33:47',1,242,'8c853700-c4a6-41de-907e-629940afb5ce',74,'1981e9617628491f938ef0ef01c061c5','gigabytes',1,'2025-11-30 08:33:47',NULL),('2025-11-29 08:33:47','2025-11-29 08:33:47','2025-11-29 08:33:47',1,243,'e46a72d3-fe62-484a-aa7f-006a173bf753',75,'1981e9617628491f938ef0ef01c061c5','volumes___DEFAULT__',1,'2025-11-30 08:33:47',NULL),('2025-11-29 08:33:47','2025-11-29 08:33:47','2025-11-29 08:33:47',1,244,'6406749d-1b2f-4b48-8f41-277d65ca756a',76,'1981e9617628491f938ef0ef01c061c5','gigabytes___DEFAULT__',1,'2025-11-30 08:33:47',NULL),('2025-11-29 08:33:54','2025-11-29 08:33:54','2025-11-29 08:33:54',1,245,'9d7fed8b-bdba-42d7-9efc-1b8bb446e15b',73,'1981e9617628491f938ef0ef01c061c5','volumes',1,'2025-11-30 08:33:54',NULL),('2025-11-29 08:33:54','2025-11-29 08:33:54','2025-11-29 08:33:54',1,246,'79cd3c31-4ab6-4680-9d9c-7de01ecea471',74,'1981e9617628491f938ef0ef01c061c5','gigabytes',1,'2025-11-30 08:33:54',NULL),('2025-11-29 08:33:54','2025-11-29 08:33:54','2025-11-29 08:33:54',1,247,'68ca2a3e-9dbf-474f-ac7b-a0ecbf34134e',75,'1981e9617628491f938ef0ef01c061c5','volumes___DEFAULT__',1,'2025-11-30 08:33:54',NULL),('2025-11-29 08:33:54','2025-11-29 08:33:54','2025-11-29 08:33:54',1,248,'cd04350d-b384-40f7-bc69-6fc5e1ff1195',76,'1981e9617628491f938ef0ef01c061c5','gigabytes___DEFAULT__',1,'2025-11-30 08:33:54',NULL),('2025-11-29 08:34:13','2025-11-29 08:34:13','2025-11-29 08:34:13',1,249,'d437968e-0891-41d5-9531-7c75269111c0',73,'1981e9617628491f938ef0ef01c061c5','volumes',-1,'2025-11-30 08:34:13',NULL),('2025-11-29 08:34:13','2025-11-29 08:34:13','2025-11-29 08:34:13',1,250,'d3cf2d3d-8e3a-484a-a9b5-2b2d6067cdc1',74,'1981e9617628491f938ef0ef01c061c5','gigabytes',-1,'2025-11-30 08:34:13',NULL),('2025-11-29 08:34:13','2025-11-29 08:34:13','2025-11-29 08:34:13',1,251,'7e93c18f-9bbf-459e-b2b9-9b2aca183114',75,'1981e9617628491f938ef0ef01c061c5','volumes___DEFAULT__',-1,'2025-11-30 08:34:13',NULL),('2025-11-29 08:34:13','2025-11-29 08:34:13','2025-11-29 08:34:13',1,252,'acd19ddb-9d7e-4fec-a0d1-537316a96d26',76,'1981e9617628491f938ef0ef01c061c5','gigabytes___DEFAULT__',-1,'2025-11-30 08:34:13',NULL),('2025-11-29 08:34:14','2025-11-29 08:34:14','2025-11-29 08:34:14',1,253,'98ae5a97-1b47-46f1-a3de-f03d7e9fd4d1',73,'1981e9617628491f938ef0ef01c061c5','volumes',-1,'2025-11-30 08:34:14',NULL),('2025-11-29 08:34:14','2025-11-29 08:34:14','2025-11-29 08:34:14',1,254,'f36df1c0-f950-4a96-8927-e2cddf7898f4',74,'1981e9617628491f938ef0ef01c061c5','gigabytes',-1,'2025-11-30 08:34:14',NULL),('2025-11-29 08:34:14','2025-11-29 08:34:14','2025-11-29 08:34:14',1,255,'ee586d96-fa8a-4bb5-86f1-fb119fa91db4',75,'1981e9617628491f938ef0ef01c061c5','volumes___DEFAULT__',-1,'2025-11-30 08:34:14',NULL),('2025-11-29 08:34:14','2025-11-29 08:34:14','2025-11-29 08:34:14',1,256,'d655122d-8a5a-43f1-b09b-807e95d473a9',76,'1981e9617628491f938ef0ef01c061c5','gigabytes___DEFAULT__',-1,'2025-11-30 08:34:14',NULL),('2025-11-29 08:34:16','2025-11-29 08:34:16','2025-11-29 08:34:16',1,257,'80b8c6e3-4217-47a9-a110-813b708227b2',73,'1981e9617628491f938ef0ef01c061c5','volumes',-1,'2025-11-30 08:34:16',NULL),('2025-11-29 08:34:16','2025-11-29 08:34:16','2025-11-29 08:34:16',1,258,'f848c3b7-5daa-4ae7-92ab-2ccab9aa24f6',74,'1981e9617628491f938ef0ef01c061c5','gigabytes',-1,'2025-11-30 08:34:16',NULL),('2025-11-29 08:34:16','2025-11-29 08:34:16','2025-11-29 08:34:16',1,259,'663db20a-d8b6-4093-aebb-ff33af11997a',75,'1981e9617628491f938ef0ef01c061c5','volumes___DEFAULT__',-1,'2025-11-30 08:34:16',NULL),('2025-11-29 08:34:16','2025-11-29 08:34:16','2025-11-29 08:34:16',1,260,'f867a6ef-4c96-4606-b43e-df9753df42da',76,'1981e9617628491f938ef0ef01c061c5','gigabytes___DEFAULT__',-1,'2025-11-30 08:34:16',NULL),('2025-11-29 08:34:34','2025-11-29 08:34:34','2025-11-29 08:34:34',1,261,'396b19c0-7be8-4c6e-8ee6-57ef07070570',81,'96e72e7660da497a8b6bf9fdb03fe84c','volumes',1,'2025-11-30 08:34:34',NULL),('2025-11-29 08:34:34','2025-11-29 08:34:34','2025-11-29 08:34:34',1,262,'849ce6aa-262a-4f84-b6bc-8041b5054d5f',82,'96e72e7660da497a8b6bf9fdb03fe84c','gigabytes',1,'2025-11-30 08:34:34',NULL),('2025-11-29 08:34:34','2025-11-29 08:34:34','2025-11-29 08:34:34',1,263,'6ed8af03-af99-4300-b1fa-dc863ca9bcc9',83,'96e72e7660da497a8b6bf9fdb03fe84c','volumes___DEFAULT__',1,'2025-11-30 08:34:34',NULL),('2025-11-29 08:34:34','2025-11-29 08:34:34','2025-11-29 08:34:34',1,264,'16b7cb5a-8569-4ca6-bb74-a244c07cbea9',84,'96e72e7660da497a8b6bf9fdb03fe84c','gigabytes___DEFAULT__',1,'2025-11-30 08:34:34',NULL),('2025-11-29 08:34:37','2025-11-29 08:34:37','2025-11-29 08:34:37',1,265,'eedec354-6bec-48af-935f-742028bae305',81,'96e72e7660da497a8b6bf9fdb03fe84c','volumes',1,'2025-11-30 08:34:37',NULL),('2025-11-29 08:34:37','2025-11-29 08:34:37','2025-11-29 08:34:37',1,266,'cd66d42e-0a4d-423a-b57f-db8a404bb3c1',82,'96e72e7660da497a8b6bf9fdb03fe84c','gigabytes',1,'2025-11-30 08:34:37',NULL),('2025-11-29 08:34:37','2025-11-29 08:34:37','2025-11-29 08:34:37',1,267,'8ccf7adf-99aa-447b-b53c-e68d06b8cb7d',83,'96e72e7660da497a8b6bf9fdb03fe84c','volumes___DEFAULT__',1,'2025-11-30 08:34:37',NULL),('2025-11-29 08:34:37','2025-11-29 08:34:37','2025-11-29 08:34:37',1,268,'32e5ff88-fefb-47f2-b602-ed0b048e8ecb',84,'96e72e7660da497a8b6bf9fdb03fe84c','gigabytes___DEFAULT__',1,'2025-11-30 08:34:37',NULL),('2025-11-29 08:34:51','2025-11-29 08:34:51','2025-11-29 08:34:51',1,269,'d9cce301-31ce-47c6-91e0-715daac819e5',77,'d4f6db81949d487b853d7567f8a2e6d4','volumes',1,'2025-11-30 08:34:51',NULL),('2025-11-29 08:34:51','2025-11-29 08:34:51','2025-11-29 08:34:51',1,270,'88ecef3a-9929-42ad-87bf-2369d08388a9',78,'d4f6db81949d487b853d7567f8a2e6d4','gigabytes',1,'2025-11-30 08:34:51',NULL),('2025-11-29 08:34:51','2025-11-29 08:34:51','2025-11-29 08:34:51',1,271,'803cb34a-25c9-4335-8134-1b18e9446789',79,'d4f6db81949d487b853d7567f8a2e6d4','volumes_multiattach',1,'2025-11-30 08:34:51',NULL),('2025-11-29 08:34:51','2025-11-29 08:34:51','2025-11-29 08:34:51',1,272,'98fae922-a929-49c5-9f96-8458a0b75d55',80,'d4f6db81949d487b853d7567f8a2e6d4','gigabytes_multiattach',1,'2025-11-30 08:34:51',NULL),('2025-11-29 08:35:11','2025-11-29 08:35:11','2025-11-29 08:35:11',1,273,'133b0440-78d3-46b3-a7a6-3aaa2eea3394',85,'d4f6db81949d487b853d7567f8a2e6d4','snapshots',1,'2025-11-30 08:35:11',NULL),('2025-11-29 08:35:11','2025-11-29 08:35:11','2025-11-29 08:35:11',1,274,'02429f26-db59-4c75-b81a-f4f7ff493bf1',78,'d4f6db81949d487b853d7567f8a2e6d4','gigabytes',1,'2025-11-30 08:35:11',NULL),('2025-11-29 08:35:11','2025-11-29 08:35:11','2025-11-29 08:35:11',1,275,'e74ef9aa-a5e3-4bc4-892f-316e89c9f000',80,'d4f6db81949d487b853d7567f8a2e6d4','gigabytes_multiattach',1,'2025-11-30 08:35:11',NULL),('2025-11-29 08:35:11','2025-11-29 08:35:11','2025-11-29 08:35:11',1,276,'e9a23433-7f56-4f38-ab35-cd2269ce9446',86,'d4f6db81949d487b853d7567f8a2e6d4','snapshots_multiattach',1,'2025-11-30 08:35:11',NULL),('2025-11-29 08:35:18','2025-11-29 08:35:18','2025-11-29 08:35:18',1,277,'9999ab24-62a0-49f0-8c03-8e3baafc1b5f',85,'d4f6db81949d487b853d7567f8a2e6d4','snapshots',-1,'2025-11-30 08:35:18',NULL),('2025-11-29 08:35:18','2025-11-29 08:35:18','2025-11-29 08:35:18',1,278,'f24c4d90-5dbd-4a19-93dd-fc71168b0bae',78,'d4f6db81949d487b853d7567f8a2e6d4','gigabytes',-1,'2025-11-30 08:35:18',NULL),('2025-11-29 08:35:18','2025-11-29 08:35:18','2025-11-29 08:35:18',1,279,'49e6856e-8f90-4262-8cce-4b922de18009',80,'d4f6db81949d487b853d7567f8a2e6d4','gigabytes_multiattach',-1,'2025-11-30 08:35:18',NULL),('2025-11-29 08:35:18','2025-11-29 08:35:18','2025-11-29 08:35:18',1,280,'a8a66197-b32c-492c-aa39-9f690c82abad',86,'d4f6db81949d487b853d7567f8a2e6d4','snapshots_multiattach',-1,'2025-11-30 08:35:18',NULL),('2025-11-29 08:35:19','2025-11-29 08:35:19','2025-11-29 08:35:19',1,281,'ecd64ce5-66d9-444b-a7d0-59a52889b1c3',77,'d4f6db81949d487b853d7567f8a2e6d4','volumes',-1,'2025-11-30 08:35:19',NULL),('2025-11-29 08:35:19','2025-11-29 08:35:19','2025-11-29 08:35:19',1,282,'6f9776ea-c03c-4254-b441-255e6c5d2d19',78,'d4f6db81949d487b853d7567f8a2e6d4','gigabytes',-1,'2025-11-30 08:35:19',NULL),('2025-11-29 08:35:19','2025-11-29 08:35:19','2025-11-29 08:35:19',1,283,'3cd949f0-9633-4726-a25e-8906ed2017c1',79,'d4f6db81949d487b853d7567f8a2e6d4','volumes_multiattach',-1,'2025-11-30 08:35:19',NULL),('2025-11-29 08:35:19','2025-11-29 08:35:19','2025-11-29 08:35:19',1,284,'4716e94a-6a89-4fbc-8cec-afafb17f62fc',80,'d4f6db81949d487b853d7567f8a2e6d4','gigabytes_multiattach',-1,'2025-11-30 08:35:19',NULL),('2025-11-29 08:35:20','2025-11-29 08:35:20','2025-11-29 08:35:20',1,285,'1c956b66-2edf-4a52-a15c-1122906a04f9',77,'d4f6db81949d487b853d7567f8a2e6d4','volumes',-1,'2025-11-30 08:35:20',NULL),('2025-11-29 08:35:20','2025-11-29 08:35:20','2025-11-29 08:35:20',1,286,'c48a834c-33bf-4feb-bf17-dd36109bcba5',78,'d4f6db81949d487b853d7567f8a2e6d4','gigabytes',-1,'2025-11-30 08:35:20',NULL),('2025-11-29 08:35:20','2025-11-29 08:35:20','2025-11-29 08:35:20',1,287,'7ce6f204-e650-4c4d-be29-ff5170495495',79,'d4f6db81949d487b853d7567f8a2e6d4','volumes_multiattach',-1,'2025-11-30 08:35:20',NULL),('2025-11-29 08:35:20','2025-11-29 08:35:20','2025-11-29 08:35:20',1,288,'42df1a95-0b58-4a6c-b364-1ea0de4c6d0b',80,'d4f6db81949d487b853d7567f8a2e6d4','gigabytes_multiattach',-1,'2025-11-30 08:35:20',NULL),('2025-11-29 08:35:24','2025-11-29 08:35:24','2025-11-29 08:35:24',1,289,'2e6388f9-5956-4f8a-84b8-e853a5b3d47f',87,'368e3a44279843f5947188dd045d65b6','volumes',1,'2025-11-30 08:35:24',NULL),('2025-11-29 08:35:24','2025-11-29 08:35:24','2025-11-29 08:35:24',1,290,'fcbbaf10-0f12-4cea-9d70-1d17d2f6b744',88,'368e3a44279843f5947188dd045d65b6','gigabytes',1,'2025-11-30 08:35:24',NULL),('2025-11-29 08:35:24','2025-11-29 08:35:24','2025-11-29 08:35:24',1,291,'08e167e1-c68b-44b8-a86a-d76da7fbfa23',89,'368e3a44279843f5947188dd045d65b6','volumes___DEFAULT__',1,'2025-11-30 08:35:24',NULL),('2025-11-29 08:35:24','2025-11-29 08:35:24','2025-11-29 08:35:24',1,292,'4f670e19-e2da-4069-b03f-17642e0b3736',90,'368e3a44279843f5947188dd045d65b6','gigabytes___DEFAULT__',1,'2025-11-30 08:35:24',NULL),('2025-11-29 08:35:31','2025-11-29 08:35:31','2025-11-29 08:35:31',1,293,'683225e1-6e84-49cb-adef-969fef79ab66',77,'d4f6db81949d487b853d7567f8a2e6d4','volumes',-1,'2025-11-30 08:35:31',NULL),('2025-11-29 08:35:31','2025-11-29 08:35:31','2025-11-29 08:35:31',1,294,'3e983b8b-dfa0-4b32-9cbe-89da0a9fec61',78,'d4f6db81949d487b853d7567f8a2e6d4','gigabytes',-1,'2025-11-30 08:35:31',NULL),('2025-11-29 08:35:31','2025-11-29 08:35:31','2025-11-29 08:35:31',1,295,'dc66c946-955d-4cc8-ad12-a8c9facb9ffa',79,'d4f6db81949d487b853d7567f8a2e6d4','volumes_multiattach',-1,'2025-11-30 08:35:31',NULL),('2025-11-29 08:35:31','2025-11-29 08:35:31','2025-11-29 08:35:31',1,296,'e1bcc476-7bea-4043-b813-c132429c52b8',80,'d4f6db81949d487b853d7567f8a2e6d4','gigabytes_multiattach',-1,'2025-11-30 08:35:31',NULL),('2025-11-29 08:35:44','2025-11-29 08:35:44','2025-11-29 08:35:44',1,297,'4aee8e78-f090-483a-8611-e686b3c64f95',77,'d4f6db81949d487b853d7567f8a2e6d4','volumes',-1,'2025-11-30 08:35:44',NULL),('2025-11-29 08:35:44','2025-11-29 08:35:44','2025-11-29 08:35:44',1,298,'0d488eac-e1bd-4d32-a71b-584b8922b31f',78,'d4f6db81949d487b853d7567f8a2e6d4','gigabytes',-1,'2025-11-30 08:35:44',NULL),('2025-11-29 08:35:44','2025-11-29 08:35:44','2025-11-29 08:35:44',1,299,'5798ba8e-9441-4c17-8701-d702f46f6a3e',79,'d4f6db81949d487b853d7567f8a2e6d4','volumes_multiattach',-1,'2025-11-30 08:35:44',NULL),('2025-11-29 08:35:44','2025-11-29 08:35:44','2025-11-29 08:35:44',1,300,'c9fa54b1-3238-436b-90c2-19467e974cc9',80,'d4f6db81949d487b853d7567f8a2e6d4','gigabytes_multiattach',-1,'2025-11-30 08:35:44',NULL),('2025-11-29 08:36:43','2025-11-29 08:36:43','2025-11-29 08:36:43',1,301,'48ed481c-3d28-4a33-88db-5a38dd989ba7',81,'96e72e7660da497a8b6bf9fdb03fe84c','volumes',-1,'2025-11-30 08:36:43',NULL),('2025-11-29 08:36:43','2025-11-29 08:36:43','2025-11-29 08:36:43',1,302,'d269bd5f-5cb2-4501-ade3-f9fd9246f934',82,'96e72e7660da497a8b6bf9fdb03fe84c','gigabytes',-1,'2025-11-30 08:36:43',NULL),('2025-11-29 08:36:43','2025-11-29 08:36:43','2025-11-29 08:36:43',1,303,'e5dac40a-5df0-4309-a0bb-6f21ec3c97a5',83,'96e72e7660da497a8b6bf9fdb03fe84c','volumes___DEFAULT__',-1,'2025-11-30 08:36:43',NULL),('2025-11-29 08:36:43','2025-11-29 08:36:43','2025-11-29 08:36:43',1,304,'f396b828-d57e-421d-8c9f-477761808148',84,'96e72e7660da497a8b6bf9fdb03fe84c','gigabytes___DEFAULT__',-1,'2025-11-30 08:36:43',NULL),('2025-11-29 08:36:44','2025-11-29 08:36:45','2025-11-29 08:36:45',1,305,'0be2e785-d3f1-4503-8903-5e9cbb5249a5',81,'96e72e7660da497a8b6bf9fdb03fe84c','volumes',-1,'2025-11-30 08:36:44',NULL),('2025-11-29 08:36:44','2025-11-29 08:36:45','2025-11-29 08:36:45',1,306,'be850601-6717-477c-8c54-ff29d7d1af40',82,'96e72e7660da497a8b6bf9fdb03fe84c','gigabytes',-1,'2025-11-30 08:36:44',NULL),('2025-11-29 08:36:44','2025-11-29 08:36:45','2025-11-29 08:36:45',1,307,'d07edb50-1f5f-4dac-983f-c0ff0dcd6ba1',83,'96e72e7660da497a8b6bf9fdb03fe84c','volumes___DEFAULT__',-1,'2025-11-30 08:36:44',NULL),('2025-11-29 08:36:44','2025-11-29 08:36:45','2025-11-29 08:36:45',1,308,'3afaac28-f10b-406a-9e6e-b03da28f7ab8',84,'96e72e7660da497a8b6bf9fdb03fe84c','gigabytes___DEFAULT__',-1,'2025-11-30 08:36:44',NULL),('2025-11-29 08:36:50','2025-11-29 08:36:50','2025-11-29 08:36:50',1,309,'046e1f4e-c547-472e-902e-8486e5ca71d3',91,'8d5e30b74e6449dd90ecb667977d1fe9','volumes',1,'2025-11-30 08:36:50',NULL),('2025-11-29 08:36:50','2025-11-29 08:36:50','2025-11-29 08:36:50',1,310,'5d62185a-abee-4c2c-902d-27ba47051531',92,'8d5e30b74e6449dd90ecb667977d1fe9','gigabytes',1,'2025-11-30 08:36:50',NULL),('2025-11-29 08:36:50','2025-11-29 08:36:50','2025-11-29 08:36:50',1,311,'c3c5ac6a-dbaa-4e5a-8395-71d85a1118b0',93,'8d5e30b74e6449dd90ecb667977d1fe9','volumes___DEFAULT__',1,'2025-11-30 08:36:50',NULL),('2025-11-29 08:36:50','2025-11-29 08:36:50','2025-11-29 08:36:50',1,312,'770a8b87-a867-4bf6-94dd-a0f8089d3f33',94,'8d5e30b74e6449dd90ecb667977d1fe9','gigabytes___DEFAULT__',1,'2025-11-30 08:36:50',NULL),('2025-11-29 08:36:55','2025-11-29 08:36:55','2025-11-29 08:36:55',1,313,'a79b7c1b-6140-4f57-a60d-bf7dcf34ee1d',95,'8d5e30b74e6449dd90ecb667977d1fe9','snapshots',1,'2025-11-30 08:36:55',NULL),('2025-11-29 08:36:55','2025-11-29 08:36:55','2025-11-29 08:36:55',1,314,'e11c4eb5-7d14-4da9-9e01-d407313cc5a8',92,'8d5e30b74e6449dd90ecb667977d1fe9','gigabytes',1,'2025-11-30 08:36:55',NULL),('2025-11-29 08:36:55','2025-11-29 08:36:55','2025-11-29 08:36:55',1,315,'2cada296-c4df-42b2-96f4-0fb1d132dbef',94,'8d5e30b74e6449dd90ecb667977d1fe9','gigabytes___DEFAULT__',1,'2025-11-30 08:36:55',NULL),('2025-11-29 08:36:55','2025-11-29 08:36:55','2025-11-29 08:36:55',1,316,'155f28f4-7194-4b9b-b38b-d6a579fc6cbd',96,'8d5e30b74e6449dd90ecb667977d1fe9','snapshots___DEFAULT__',1,'2025-11-30 08:36:55',NULL),('2025-11-29 08:37:11','2025-11-29 08:37:11','2025-11-29 08:37:11',1,317,'e12bc378-0b6f-48d8-8afc-e72933be4840',87,'368e3a44279843f5947188dd045d65b6','volumes',1,'2025-11-30 08:37:11',NULL),('2025-11-29 08:37:11','2025-11-29 08:37:11','2025-11-29 08:37:11',1,318,'bec900c1-6707-488c-8741-49627d58be3c',88,'368e3a44279843f5947188dd045d65b6','gigabytes',1,'2025-11-30 08:37:11',NULL),('2025-11-29 08:37:11','2025-11-29 08:37:11','2025-11-29 08:37:11',1,319,'ee798a0f-764d-4261-8048-6900b3cf8146',89,'368e3a44279843f5947188dd045d65b6','volumes___DEFAULT__',1,'2025-11-30 08:37:11',NULL),('2025-11-29 08:37:11','2025-11-29 08:37:11','2025-11-29 08:37:11',1,320,'c717634f-55ef-4501-97c2-fdeb0f0b9378',90,'368e3a44279843f5947188dd045d65b6','gigabytes___DEFAULT__',1,'2025-11-30 08:37:11',NULL),('2025-11-29 08:37:17','2025-11-29 08:37:17','2025-11-29 08:37:17',1,321,'9603543d-2d0b-459a-93e3-fe79df348435',95,'8d5e30b74e6449dd90ecb667977d1fe9','snapshots',-1,'2025-11-30 08:37:17',NULL),('2025-11-29 08:37:17','2025-11-29 08:37:17','2025-11-29 08:37:17',1,322,'ff2bcf83-5e4a-4fc1-b559-c01919400647',92,'8d5e30b74e6449dd90ecb667977d1fe9','gigabytes',-1,'2025-11-30 08:37:17',NULL),('2025-11-29 08:37:17','2025-11-29 08:37:17','2025-11-29 08:37:17',1,323,'82e79fdc-0e83-42b4-9ce4-4c8bcb045226',94,'8d5e30b74e6449dd90ecb667977d1fe9','gigabytes___DEFAULT__',-1,'2025-11-30 08:37:17',NULL),('2025-11-29 08:37:17','2025-11-29 08:37:17','2025-11-29 08:37:17',1,324,'3724c901-00c9-4437-84e6-6b48eb3b806b',96,'8d5e30b74e6449dd90ecb667977d1fe9','snapshots___DEFAULT__',-1,'2025-11-30 08:37:17',NULL),('2025-11-29 08:38:02','2025-11-29 08:38:02','2025-11-29 08:38:02',1,325,'12fe9755-4a3a-4530-b467-edc4f0652e46',97,'889608c71d13429fb37793575792ae74','volumes',1,'2025-11-30 08:38:02',NULL),('2025-11-29 08:38:02','2025-11-29 08:38:02','2025-11-29 08:38:02',1,326,'34d6d412-419e-4c5f-bcd9-02d572b147d7',98,'889608c71d13429fb37793575792ae74','gigabytes',1,'2025-11-30 08:38:02',NULL),('2025-11-29 08:38:02','2025-11-29 08:38:02','2025-11-29 08:38:02',1,327,'5480e9a4-e578-45e3-9747-7824c9a07d15',99,'889608c71d13429fb37793575792ae74','volumes___DEFAULT__',1,'2025-11-30 08:38:02',NULL),('2025-11-29 08:38:02','2025-11-29 08:38:02','2025-11-29 08:38:02',1,328,'d16a7af8-88de-4bcf-9305-9f4a474a7a8e',100,'889608c71d13429fb37793575792ae74','gigabytes___DEFAULT__',1,'2025-11-30 08:38:02',NULL),('2025-11-29 08:38:06','2025-11-29 08:38:06','2025-11-29 08:38:06',1,329,'eaafced7-732d-422c-a4e1-6d8f45eb6546',91,'8d5e30b74e6449dd90ecb667977d1fe9','volumes',-1,'2025-11-30 08:38:06',NULL),('2025-11-29 08:38:06','2025-11-29 08:38:06','2025-11-29 08:38:06',1,330,'e89618d7-00f0-46dc-887e-31aa43cad1c3',92,'8d5e30b74e6449dd90ecb667977d1fe9','gigabytes',-1,'2025-11-30 08:38:06',NULL),('2025-11-29 08:38:06','2025-11-29 08:38:06','2025-11-29 08:38:06',1,331,'97ea61d0-6efe-459f-bfcd-96e97938e19f',93,'8d5e30b74e6449dd90ecb667977d1fe9','volumes___DEFAULT__',-1,'2025-11-30 08:38:06',NULL),('2025-11-29 08:38:06','2025-11-29 08:38:06','2025-11-29 08:38:06',1,332,'d5a9aeff-f691-47f5-a3f0-b0421f87c406',94,'8d5e30b74e6449dd90ecb667977d1fe9','gigabytes___DEFAULT__',-1,'2025-11-30 08:38:06',NULL),('2025-11-29 08:38:18','2025-11-29 08:38:18','2025-11-29 08:38:18',1,333,'e9d9183e-ebd5-4a46-9a3e-ddbd7835e059',87,'368e3a44279843f5947188dd045d65b6','volumes',1,'2025-11-30 08:38:18',NULL),('2025-11-29 08:38:18','2025-11-29 08:38:18','2025-11-29 08:38:18',1,334,'f8b3c830-9f72-4d2a-91f3-43a029cac325',88,'368e3a44279843f5947188dd045d65b6','gigabytes',1,'2025-11-30 08:38:18',NULL),('2025-11-29 08:38:18','2025-11-29 08:38:18','2025-11-29 08:38:18',1,335,'8069629e-6a11-4341-8223-25cc8c627836',89,'368e3a44279843f5947188dd045d65b6','volumes___DEFAULT__',1,'2025-11-30 08:38:18',NULL),('2025-11-29 08:38:18','2025-11-29 08:38:18','2025-11-29 08:38:18',1,336,'71ab6566-f01d-41bd-b04f-c39c55159eb0',90,'368e3a44279843f5947188dd045d65b6','gigabytes___DEFAULT__',1,'2025-11-30 08:38:18',NULL),('2025-11-29 08:38:32','2025-11-29 08:38:32','2025-11-29 08:38:32',1,337,'595dc1e9-d354-4f26-85eb-6f21a10e56c9',91,'8d5e30b74e6449dd90ecb667977d1fe9','volumes',1,'2025-11-30 08:38:32',NULL),('2025-11-29 08:38:32','2025-11-29 08:38:32','2025-11-29 08:38:32',1,338,'421eae75-b283-4583-874f-2a33d94e1aa0',92,'8d5e30b74e6449dd90ecb667977d1fe9','gigabytes',1,'2025-11-30 08:38:32',NULL),('2025-11-29 08:38:32','2025-11-29 08:38:32','2025-11-29 08:38:32',1,339,'e7677ae8-34d6-4091-995f-8673d626ca4a',93,'8d5e30b74e6449dd90ecb667977d1fe9','volumes___DEFAULT__',1,'2025-11-30 08:38:32',NULL),('2025-11-29 08:38:32','2025-11-29 08:38:32','2025-11-29 08:38:32',1,340,'ca5fac15-7bfb-4b4c-90c5-374c24e53da5',94,'8d5e30b74e6449dd90ecb667977d1fe9','gigabytes___DEFAULT__',1,'2025-11-30 08:38:32',NULL),('2025-11-29 08:38:33','2025-11-29 08:38:34','2025-11-29 08:38:34',1,341,'3f2e1e42-477c-4fdc-a4e3-210b3dd7e7a6',87,'368e3a44279843f5947188dd045d65b6','volumes',-1,'2025-11-30 08:38:33',NULL),('2025-11-29 08:38:33','2025-11-29 08:38:34','2025-11-29 08:38:34',1,342,'cc572b32-fc35-422b-a050-518722abf91b',88,'368e3a44279843f5947188dd045d65b6','gigabytes',-1,'2025-11-30 08:38:33',NULL),('2025-11-29 08:38:33','2025-11-29 08:38:34','2025-11-29 08:38:34',1,343,'fad87a9a-4fb4-4bff-bb55-6049fa36d4b3',89,'368e3a44279843f5947188dd045d65b6','volumes___DEFAULT__',-1,'2025-11-30 08:38:33',NULL),('2025-11-29 08:38:33','2025-11-29 08:38:34','2025-11-29 08:38:34',1,344,'272f442a-9903-41ea-b572-25867cd325ad',90,'368e3a44279843f5947188dd045d65b6','gigabytes___DEFAULT__',-1,'2025-11-30 08:38:33',NULL),('2025-11-29 08:38:36','2025-11-29 08:38:36','2025-11-29 08:38:36',1,345,'fce88c9b-4c54-47d3-9f3f-891466f5db6d',87,'368e3a44279843f5947188dd045d65b6','volumes',-1,'2025-11-30 08:38:36',NULL),('2025-11-29 08:38:36','2025-11-29 08:38:36','2025-11-29 08:38:36',1,346,'c22927e3-ab27-48c0-a784-d4e0229de901',88,'368e3a44279843f5947188dd045d65b6','gigabytes',-1,'2025-11-30 08:38:36',NULL),('2025-11-29 08:38:36','2025-11-29 08:38:36','2025-11-29 08:38:36',1,347,'e165dc02-91cc-466c-992a-e2e9b54bb953',89,'368e3a44279843f5947188dd045d65b6','volumes___DEFAULT__',-1,'2025-11-30 08:38:36',NULL),('2025-11-29 08:38:36','2025-11-29 08:38:36','2025-11-29 08:38:36',1,348,'5ae513c5-34d4-41a7-8d8f-144a9529ec93',90,'368e3a44279843f5947188dd045d65b6','gigabytes___DEFAULT__',-1,'2025-11-30 08:38:36',NULL),('2025-11-29 08:38:38','2025-11-29 08:38:38','2025-11-29 08:38:38',1,349,'841e6b41-e152-420d-8e2d-191d259c7f46',87,'368e3a44279843f5947188dd045d65b6','volumes',-1,'2025-11-30 08:38:37',NULL),('2025-11-29 08:38:38','2025-11-29 08:38:38','2025-11-29 08:38:38',1,350,'e415bc21-60ae-4c9f-9c79-d39cee2ceac9',88,'368e3a44279843f5947188dd045d65b6','gigabytes',-1,'2025-11-30 08:38:37',NULL),('2025-11-29 08:38:38','2025-11-29 08:38:38','2025-11-29 08:38:38',1,351,'19c91867-c9c3-430a-a8b5-399476a74621',89,'368e3a44279843f5947188dd045d65b6','volumes___DEFAULT__',-1,'2025-11-30 08:38:37',NULL),('2025-11-29 08:38:38','2025-11-29 08:38:38','2025-11-29 08:38:38',1,352,'494b3509-0a62-41e4-9d9c-7f7841420e18',90,'368e3a44279843f5947188dd045d65b6','gigabytes___DEFAULT__',-1,'2025-11-30 08:38:37',NULL),('2025-11-29 08:39:08','2025-11-29 08:39:08','2025-11-29 08:39:08',1,353,'d8380503-bc6c-4c7d-b5fa-9ecdb890607f',101,'62ca01275fe34ea0af31d00b34d6d9a5','volumes',1,'2025-11-30 08:39:08',NULL),('2025-11-29 08:39:08','2025-11-29 08:39:08','2025-11-29 08:39:08',1,354,'7db24c21-a3c0-4703-b158-2c3d93280873',102,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes',1,'2025-11-30 08:39:08',NULL),('2025-11-29 08:39:08','2025-11-29 08:39:08','2025-11-29 08:39:08',1,355,'5530e3fe-2abb-4a4c-ae6e-1602b67c4131',103,'62ca01275fe34ea0af31d00b34d6d9a5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1962685100-62209477',1,'2025-11-30 08:39:08',NULL),('2025-11-29 08:39:08','2025-11-29 08:39:08','2025-11-29 08:39:08',1,356,'3502700d-0e95-41eb-9769-bb70e37b9822',104,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1962685100-62209477',1,'2025-11-30 08:39:08',NULL),('2025-11-29 08:39:08','2025-11-29 08:39:08','2025-11-29 08:39:08',1,357,'059f6952-dbd3-4f74-990f-f779b4d96c6f',101,'62ca01275fe34ea0af31d00b34d6d9a5','volumes',1,'2025-11-30 08:39:08',NULL),('2025-11-29 08:39:08','2025-11-29 08:39:08','2025-11-29 08:39:08',1,358,'a0429637-0934-4fa2-a4d6-abc71e7dc642',102,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes',1,'2025-11-30 08:39:08',NULL),('2025-11-29 08:39:08','2025-11-29 08:39:08','2025-11-29 08:39:08',1,359,'dfbc70dc-52ca-436d-8a9d-b21aba83230f',105,'62ca01275fe34ea0af31d00b34d6d9a5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-334379363-1778895309',1,'2025-11-30 08:39:08',NULL),('2025-11-29 08:39:08','2025-11-29 08:39:08','2025-11-29 08:39:08',1,360,'78926807-d1ae-4106-8d15-2d321c5f27ca',106,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-334379363-1778895309',1,'2025-11-30 08:39:08',NULL),('2025-11-29 08:39:08','2025-11-29 08:39:08','2025-11-29 08:39:08',1,361,'f11751ea-9bb7-407f-990f-5fb17dc07ffb',101,'62ca01275fe34ea0af31d00b34d6d9a5','volumes',1,'2025-11-30 08:39:08',NULL),('2025-11-29 08:39:08','2025-11-29 08:39:08','2025-11-29 08:39:08',1,362,'06ce2ec2-966f-47b2-ad03-d6452f99714b',102,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes',1,'2025-11-30 08:39:08',NULL),('2025-11-29 08:39:08','2025-11-29 08:39:08','2025-11-29 08:39:08',1,363,'c92d1684-e527-4fa8-8c3e-409569a0ec4a',103,'62ca01275fe34ea0af31d00b34d6d9a5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1962685100-62209477',1,'2025-11-30 08:39:08',NULL),('2025-11-29 08:39:08','2025-11-29 08:39:08','2025-11-29 08:39:08',1,364,'cccfa05f-3a77-47f5-9017-13dc6e1f1cbb',104,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1962685100-62209477',1,'2025-11-30 08:39:08',NULL),('2025-11-29 08:39:09','2025-11-29 08:39:09','2025-11-29 08:39:09',1,365,'2a649939-90a8-49af-9956-862167c91a01',101,'62ca01275fe34ea0af31d00b34d6d9a5','volumes',1,'2025-11-30 08:39:09',NULL),('2025-11-29 08:39:09','2025-11-29 08:39:09','2025-11-29 08:39:09',1,366,'fc080c4a-d2b9-4f3c-b4b2-5ba69476387a',102,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes',1,'2025-11-30 08:39:09',NULL),('2025-11-29 08:39:09','2025-11-29 08:39:09','2025-11-29 08:39:09',1,367,'d6c613ee-ed9e-45c4-95f6-17b08756706c',105,'62ca01275fe34ea0af31d00b34d6d9a5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-334379363-1778895309',1,'2025-11-30 08:39:09',NULL),('2025-11-29 08:39:09','2025-11-29 08:39:09','2025-11-29 08:39:09',1,368,'48107bba-55b1-48b1-b454-b907be967921',106,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-334379363-1778895309',1,'2025-11-30 08:39:09',NULL),('2025-11-29 08:39:09','2025-11-29 08:39:09','2025-11-29 08:39:09',1,369,'0ddbee1a-cf00-4748-a4f0-bb9839261b84',101,'62ca01275fe34ea0af31d00b34d6d9a5','volumes',1,'2025-11-30 08:39:09',NULL),('2025-11-29 08:39:09','2025-11-29 08:39:09','2025-11-29 08:39:09',1,370,'cdca1c12-f767-4ecc-92ba-d0582632d28b',102,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes',1,'2025-11-30 08:39:09',NULL),('2025-11-29 08:39:09','2025-11-29 08:39:09','2025-11-29 08:39:09',1,371,'53f70738-11af-42b9-b094-5ebdfa7b68a6',103,'62ca01275fe34ea0af31d00b34d6d9a5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1962685100-62209477',1,'2025-11-30 08:39:09',NULL),('2025-11-29 08:39:09','2025-11-29 08:39:09','2025-11-29 08:39:09',1,372,'4c39a301-a4db-4fe5-a95f-ee5ca989d6c2',104,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1962685100-62209477',1,'2025-11-30 08:39:09',NULL),('2025-11-29 08:39:09','2025-11-29 08:39:09','2025-11-29 08:39:09',1,373,'2d9b3e65-46cc-4865-9d4e-c49a977f1627',101,'62ca01275fe34ea0af31d00b34d6d9a5','volumes',1,'2025-11-30 08:39:09',NULL),('2025-11-29 08:39:09','2025-11-29 08:39:09','2025-11-29 08:39:09',1,374,'92f98706-ca06-4be0-8695-491c51cc1373',102,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes',1,'2025-11-30 08:39:09',NULL),('2025-11-29 08:39:09','2025-11-29 08:39:09','2025-11-29 08:39:09',1,375,'98c23ac9-971f-4cc8-9749-dd46d50ce8e7',105,'62ca01275fe34ea0af31d00b34d6d9a5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-334379363-1778895309',1,'2025-11-30 08:39:09',NULL),('2025-11-29 08:39:09','2025-11-29 08:39:09','2025-11-29 08:39:09',1,376,'459343c6-30d1-4aa7-9dc1-d3a2eea05635',106,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-334379363-1778895309',1,'2025-11-30 08:39:09',NULL),('2025-11-29 08:39:10','2025-11-29 08:39:10','2025-11-29 08:39:10',1,377,'ba133092-1c38-4b52-9361-f6e211391bb8',101,'62ca01275fe34ea0af31d00b34d6d9a5','volumes',1,'2025-11-30 08:39:10',NULL),('2025-11-29 08:39:10','2025-11-29 08:39:10','2025-11-29 08:39:10',1,378,'bf169dd2-0254-4c70-b30d-4c4ab80889ff',102,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes',1,'2025-11-30 08:39:10',NULL),('2025-11-29 08:39:10','2025-11-29 08:39:10','2025-11-29 08:39:10',1,379,'ad34d6d6-5893-478a-9c04-123e4db2aca2',107,'62ca01275fe34ea0af31d00b34d6d9a5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1204371373-2122106632',1,'2025-11-30 08:39:10',NULL),('2025-11-29 08:39:10','2025-11-29 08:39:10','2025-11-29 08:39:10',1,380,'5fae687b-b0af-4408-a04e-fafe8b35479b',108,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1204371373-2122106632',1,'2025-11-30 08:39:10',NULL),('2025-11-29 08:39:11','2025-11-29 08:39:11','2025-11-29 08:39:11',1,381,'f9d8da30-624d-4c6c-a6fa-815084b9317a',101,'62ca01275fe34ea0af31d00b34d6d9a5','volumes',1,'2025-11-30 08:39:11',NULL),('2025-11-29 08:39:11','2025-11-29 08:39:11','2025-11-29 08:39:11',1,382,'74c978ef-460a-4904-ba86-8026fb986ffc',102,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes',1,'2025-11-30 08:39:11',NULL),('2025-11-29 08:39:11','2025-11-29 08:39:11','2025-11-29 08:39:11',1,383,'4a16c430-c369-4dfa-bda2-669e05038c36',107,'62ca01275fe34ea0af31d00b34d6d9a5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1204371373-2122106632',1,'2025-11-30 08:39:11',NULL),('2025-11-29 08:39:11','2025-11-29 08:39:11','2025-11-29 08:39:11',1,384,'1c2caaea-5bb7-46bb-b780-da85d92718a2',108,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1204371373-2122106632',1,'2025-11-30 08:39:11',NULL),('2025-11-29 08:39:13','2025-11-29 08:39:13','2025-11-29 08:39:13',1,385,'92d7723c-ef37-4b26-8252-3691197f14d5',101,'62ca01275fe34ea0af31d00b34d6d9a5','volumes',1,'2025-11-30 08:39:13',NULL),('2025-11-29 08:39:13','2025-11-29 08:39:13','2025-11-29 08:39:13',1,386,'2696a9f4-5992-4d45-a0f1-d1bf0ab608a8',102,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes',1,'2025-11-30 08:39:13',NULL),('2025-11-29 08:39:13','2025-11-29 08:39:13','2025-11-29 08:39:13',1,387,'24de10aa-a62d-46cc-8654-4dd00ab77003',107,'62ca01275fe34ea0af31d00b34d6d9a5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1204371373-2122106632',1,'2025-11-30 08:39:13',NULL),('2025-11-29 08:39:13','2025-11-29 08:39:13','2025-11-29 08:39:13',1,388,'d4b7f4c5-e3b3-4f71-9af2-e8753e7ce401',108,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1204371373-2122106632',1,'2025-11-30 08:39:13',NULL),('2025-11-29 08:39:36','2025-11-29 08:39:36','2025-11-29 08:39:36',1,389,'4a33f243-1689-42f4-92b0-b3b7e8947fb3',97,'889608c71d13429fb37793575792ae74','volumes',1,'2025-11-30 08:39:36',NULL),('2025-11-29 08:39:36','2025-11-29 08:39:36','2025-11-29 08:39:36',1,390,'137dba79-1df9-455d-ad02-45098c4ed71d',98,'889608c71d13429fb37793575792ae74','gigabytes',1,'2025-11-30 08:39:36',NULL),('2025-11-29 08:39:36','2025-11-29 08:39:36','2025-11-29 08:39:36',1,391,'e8de6782-2632-4487-b937-873dd589d647',99,'889608c71d13429fb37793575792ae74','volumes___DEFAULT__',1,'2025-11-30 08:39:36',NULL),('2025-11-29 08:39:36','2025-11-29 08:39:36','2025-11-29 08:39:36',1,392,'871efacd-331d-476b-9bdc-f647f92e27f7',100,'889608c71d13429fb37793575792ae74','gigabytes___DEFAULT__',1,'2025-11-30 08:39:36',NULL),('2025-11-29 08:39:48','2025-11-29 08:39:48','2025-11-29 08:39:48',1,393,'faf9b3fa-46ad-4b85-bc21-12f214bc62ca',91,'8d5e30b74e6449dd90ecb667977d1fe9','volumes',-1,'2025-11-30 08:39:48',NULL),('2025-11-29 08:39:48','2025-11-29 08:39:48','2025-11-29 08:39:48',1,394,'261c716a-be9a-4515-bb90-6466d414c6b3',92,'8d5e30b74e6449dd90ecb667977d1fe9','gigabytes',-1,'2025-11-30 08:39:48',NULL),('2025-11-29 08:39:48','2025-11-29 08:39:48','2025-11-29 08:39:48',1,395,'f9012bdd-911b-4787-ba2e-22c91dc309fa',93,'8d5e30b74e6449dd90ecb667977d1fe9','volumes___DEFAULT__',-1,'2025-11-30 08:39:48',NULL),('2025-11-29 08:39:48','2025-11-29 08:39:48','2025-11-29 08:39:48',1,396,'e5e41efe-68e0-4015-88f4-30baf9576e57',94,'8d5e30b74e6449dd90ecb667977d1fe9','gigabytes___DEFAULT__',-1,'2025-11-30 08:39:48',NULL),('2025-11-29 08:39:59','2025-11-29 08:39:59','2025-11-29 08:39:59',1,397,'96605cad-de03-4fa3-933c-b5dd533008b3',101,'62ca01275fe34ea0af31d00b34d6d9a5','volumes',-1,'2025-11-30 08:39:59',NULL),('2025-11-29 08:39:59','2025-11-29 08:39:59','2025-11-29 08:39:59',1,398,'dd1f99af-9f2d-4639-a868-563f0ce6a0c4',102,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes',-1,'2025-11-30 08:39:59',NULL),('2025-11-29 08:39:59','2025-11-29 08:39:59','2025-11-29 08:39:59',1,399,'5f7ed01a-bbaa-4332-a1d0-108fa756e5d2',103,'62ca01275fe34ea0af31d00b34d6d9a5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1962685100-62209477',-1,'2025-11-30 08:39:59',NULL),('2025-11-29 08:39:59','2025-11-29 08:39:59','2025-11-29 08:39:59',1,400,'e46ef223-210a-4c54-8f0b-6b11bee7d9ad',104,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1962685100-62209477',-1,'2025-11-30 08:39:59',NULL),('2025-11-29 08:40:03','2025-11-29 08:40:03','2025-11-29 08:40:03',1,401,'fb110099-50f2-451b-97bc-52948311d78d',101,'62ca01275fe34ea0af31d00b34d6d9a5','volumes',-1,'2025-11-30 08:40:03',NULL),('2025-11-29 08:40:03','2025-11-29 08:40:03','2025-11-29 08:40:03',1,402,'29f48150-c3a0-46db-8335-4bc87a1f2c1c',102,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes',-1,'2025-11-30 08:40:03',NULL),('2025-11-29 08:40:03','2025-11-29 08:40:03','2025-11-29 08:40:03',1,403,'28ea7539-40fe-43df-98fd-d2965bb3ee1c',105,'62ca01275fe34ea0af31d00b34d6d9a5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-334379363-1778895309',-1,'2025-11-30 08:40:03',NULL),('2025-11-29 08:40:03','2025-11-29 08:40:03','2025-11-29 08:40:03',1,404,'5f66505a-5486-40ef-b907-f584e9a58b69',106,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-334379363-1778895309',-1,'2025-11-30 08:40:03',NULL),('2025-11-29 08:40:39','2025-11-29 08:40:39','2025-11-29 08:40:39',1,405,'a4c9a7b9-96d8-4926-82d2-05d48c9206c2',101,'62ca01275fe34ea0af31d00b34d6d9a5','volumes',-1,'2025-11-30 08:40:39',NULL),('2025-11-29 08:40:39','2025-11-29 08:40:39','2025-11-29 08:40:39',1,406,'fa304a7d-f192-4159-b35e-3302fd5e3183',102,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes',-1,'2025-11-30 08:40:39',NULL),('2025-11-29 08:40:39','2025-11-29 08:40:39','2025-11-29 08:40:39',1,407,'36240a76-34a9-4142-9846-9f6c4250d159',103,'62ca01275fe34ea0af31d00b34d6d9a5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1962685100-62209477',-1,'2025-11-30 08:40:39',NULL),('2025-11-29 08:40:39','2025-11-29 08:40:39','2025-11-29 08:40:39',1,408,'c85eb847-0ffd-40df-8799-50521c4e18e5',104,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1962685100-62209477',-1,'2025-11-30 08:40:39',NULL),('2025-11-29 08:40:43','2025-11-29 08:40:43','2025-11-29 08:40:43',1,409,'d2277dba-5f41-4e39-ac5a-f0707eafe063',101,'62ca01275fe34ea0af31d00b34d6d9a5','volumes',-1,'2025-11-30 08:40:43',NULL),('2025-11-29 08:40:43','2025-11-29 08:40:43','2025-11-29 08:40:43',1,410,'0c8dd3ce-8e65-4dbc-ba4d-7fa451640bb1',102,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes',-1,'2025-11-30 08:40:43',NULL),('2025-11-29 08:40:43','2025-11-29 08:40:43','2025-11-29 08:40:43',1,411,'bfaafbdf-c916-44ae-a2d1-5ece22486c98',105,'62ca01275fe34ea0af31d00b34d6d9a5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-334379363-1778895309',-1,'2025-11-30 08:40:43',NULL),('2025-11-29 08:40:43','2025-11-29 08:40:43','2025-11-29 08:40:43',1,412,'f9a23e3f-703c-4d6b-a4cf-754ec83720ef',106,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-334379363-1778895309',-1,'2025-11-30 08:40:43',NULL),('2025-11-29 08:40:53','2025-11-29 08:40:53','2025-11-29 08:40:53',1,413,'6a3bf241-c13a-4333-b204-b531546ff61d',97,'889608c71d13429fb37793575792ae74','volumes',-1,'2025-11-30 08:40:53',NULL),('2025-11-29 08:40:53','2025-11-29 08:40:53','2025-11-29 08:40:53',1,414,'9d5d3779-b685-4da4-82e5-242de22e41ec',98,'889608c71d13429fb37793575792ae74','gigabytes',-1,'2025-11-30 08:40:53',NULL),('2025-11-29 08:40:53','2025-11-29 08:40:53','2025-11-29 08:40:53',1,415,'c4146377-c2a3-41b7-ac5f-824b1993c9c6',99,'889608c71d13429fb37793575792ae74','volumes___DEFAULT__',-1,'2025-11-30 08:40:53',NULL),('2025-11-29 08:40:53','2025-11-29 08:40:53','2025-11-29 08:40:53',1,416,'b7096c52-c3c1-484b-9cb9-93ac6340a05e',100,'889608c71d13429fb37793575792ae74','gigabytes___DEFAULT__',-1,'2025-11-30 08:40:53',NULL),('2025-11-29 08:40:54','2025-11-29 08:40:54','2025-11-29 08:40:54',1,417,'e3ca6c9c-7b8b-4185-9307-02e6c26080dc',97,'889608c71d13429fb37793575792ae74','volumes',-1,'2025-11-30 08:40:54',NULL),('2025-11-29 08:40:54','2025-11-29 08:40:54','2025-11-29 08:40:54',1,418,'5cef81c2-4f3d-40d5-b2c6-768e3be383a7',98,'889608c71d13429fb37793575792ae74','gigabytes',-1,'2025-11-30 08:40:54',NULL),('2025-11-29 08:40:54','2025-11-29 08:40:54','2025-11-29 08:40:54',1,419,'1deeb696-c439-49ba-ac6a-7a30916800ad',99,'889608c71d13429fb37793575792ae74','volumes___DEFAULT__',-1,'2025-11-30 08:40:54',NULL),('2025-11-29 08:40:54','2025-11-29 08:40:54','2025-11-29 08:40:54',1,420,'e6220923-dcd1-4352-91fb-b4848b616f23',100,'889608c71d13429fb37793575792ae74','gigabytes___DEFAULT__',-1,'2025-11-30 08:40:54',NULL),('2025-11-29 08:41:05','2025-11-29 08:41:05','2025-11-29 08:41:05',1,421,'f6a49a28-ec85-4605-bb1c-05f9f04e77be',109,'89fad883285a4255b3b35c445f93c900','volumes',1,'2025-11-30 08:41:05',NULL),('2025-11-29 08:41:05','2025-11-29 08:41:05','2025-11-29 08:41:05',1,422,'2f15741c-262f-4de5-8232-e8196cd2c5df',110,'89fad883285a4255b3b35c445f93c900','gigabytes',1,'2025-11-30 08:41:05',NULL),('2025-11-29 08:41:05','2025-11-29 08:41:05','2025-11-29 08:41:05',1,423,'8fcd3f1f-09bb-4f3a-ac63-1a9ef721f48d',111,'89fad883285a4255b3b35c445f93c900','volumes___DEFAULT__',1,'2025-11-30 08:41:05',NULL),('2025-11-29 08:41:05','2025-11-29 08:41:05','2025-11-29 08:41:05',1,424,'4a43a876-a78f-4a26-b9df-3714f966abf6',112,'89fad883285a4255b3b35c445f93c900','gigabytes___DEFAULT__',1,'2025-11-30 08:41:05',NULL),('2025-11-29 08:41:06','2025-11-29 08:41:06','2025-11-29 08:41:06',1,425,'fa9f2978-5b00-4999-a5d9-4cf6eff066e4',113,'89fad883285a4255b3b35c445f93c900','snapshots',1,'2025-11-30 08:41:06',NULL),('2025-11-29 08:41:06','2025-11-29 08:41:06','2025-11-29 08:41:06',1,426,'3080d4a3-0b2d-4b23-b4b8-47b2ff3b83b8',110,'89fad883285a4255b3b35c445f93c900','gigabytes',1,'2025-11-30 08:41:06',NULL),('2025-11-29 08:41:06','2025-11-29 08:41:06','2025-11-29 08:41:06',1,427,'da298b16-14b8-41ac-ba3d-d3f286d1cb5d',112,'89fad883285a4255b3b35c445f93c900','gigabytes___DEFAULT__',1,'2025-11-30 08:41:06',NULL),('2025-11-29 08:41:06','2025-11-29 08:41:06','2025-11-29 08:41:06',1,428,'9d8190ec-6245-4a4d-91a8-a6f388022c7c',114,'89fad883285a4255b3b35c445f93c900','snapshots___DEFAULT__',1,'2025-11-30 08:41:06',NULL),('2025-11-29 08:41:08','2025-11-29 08:41:08','2025-11-29 08:41:08',1,429,'3c29332c-28dd-4fed-bcb7-5f958a1a4922',101,'62ca01275fe34ea0af31d00b34d6d9a5','volumes',-1,'2025-11-30 08:41:08',NULL),('2025-11-29 08:41:08','2025-11-29 08:41:08','2025-11-29 08:41:08',1,430,'b1c8eb8d-d9d7-4f8c-b626-9768498c452f',102,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes',-1,'2025-11-30 08:41:08',NULL),('2025-11-29 08:41:08','2025-11-29 08:41:08','2025-11-29 08:41:08',1,431,'77e18f76-cb43-48fc-9b05-6c766825c5b3',103,'62ca01275fe34ea0af31d00b34d6d9a5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1962685100-62209477',-1,'2025-11-30 08:41:08',NULL),('2025-11-29 08:41:08','2025-11-29 08:41:08','2025-11-29 08:41:08',1,432,'55b19044-a5d3-4202-809c-6d700052ccf0',104,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1962685100-62209477',-1,'2025-11-30 08:41:08',NULL),('2025-11-29 08:41:09','2025-11-29 08:41:09','2025-11-29 08:41:09',1,433,'b5cb5f8a-77a4-4614-8280-a8bb0d16b17a',113,'89fad883285a4255b3b35c445f93c900','snapshots',-1,'2025-11-30 08:41:09',NULL),('2025-11-29 08:41:09','2025-11-29 08:41:09','2025-11-29 08:41:09',1,434,'977849f1-f59b-41aa-80dd-109e62f6e46f',110,'89fad883285a4255b3b35c445f93c900','gigabytes',-1,'2025-11-30 08:41:09',NULL),('2025-11-29 08:41:09','2025-11-29 08:41:09','2025-11-29 08:41:09',1,435,'b59d83c3-25f8-47e3-820f-2d1282e57037',112,'89fad883285a4255b3b35c445f93c900','gigabytes___DEFAULT__',-1,'2025-11-30 08:41:09',NULL),('2025-11-29 08:41:09','2025-11-29 08:41:09','2025-11-29 08:41:09',1,436,'a961adff-6781-45eb-a037-7a92e9a67b75',114,'89fad883285a4255b3b35c445f93c900','snapshots___DEFAULT__',-1,'2025-11-30 08:41:09',NULL),('2025-11-29 08:41:10','2025-11-29 08:41:11','2025-11-29 08:41:11',1,437,'cc623cdf-c072-45f7-933d-d1ea4601ebd5',109,'89fad883285a4255b3b35c445f93c900','volumes',-1,'2025-11-30 08:41:10',NULL),('2025-11-29 08:41:10','2025-11-29 08:41:11','2025-11-29 08:41:11',1,438,'b0dd68a8-51b5-499c-aae2-ec1b3fae8e0c',110,'89fad883285a4255b3b35c445f93c900','gigabytes',-1,'2025-11-30 08:41:10',NULL),('2025-11-29 08:41:10','2025-11-29 08:41:11','2025-11-29 08:41:11',1,439,'e655879d-2a97-490c-af52-7cf603b22b5f',111,'89fad883285a4255b3b35c445f93c900','volumes___DEFAULT__',-1,'2025-11-30 08:41:10',NULL),('2025-11-29 08:41:10','2025-11-29 08:41:11','2025-11-29 08:41:11',1,440,'c1daf304-233a-4db5-a189-598c25f2cd48',112,'89fad883285a4255b3b35c445f93c900','gigabytes___DEFAULT__',-1,'2025-11-30 08:41:10',NULL),('2025-11-29 08:41:11','2025-11-29 08:41:11','2025-11-29 08:41:11',1,441,'e94951b0-6c09-46e3-991b-6b2c4e9be023',101,'62ca01275fe34ea0af31d00b34d6d9a5','volumes',-1,'2025-11-30 08:41:11',NULL),('2025-11-29 08:41:11','2025-11-29 08:41:11','2025-11-29 08:41:11',1,442,'28f7b5b3-66a5-4930-9a47-d66e057b67bb',102,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes',-1,'2025-11-30 08:41:11',NULL),('2025-11-29 08:41:11','2025-11-29 08:41:11','2025-11-29 08:41:11',1,443,'bb10a82b-3312-4431-8794-c2da7dc7c3e3',105,'62ca01275fe34ea0af31d00b34d6d9a5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-334379363-1778895309',-1,'2025-11-30 08:41:11',NULL),('2025-11-29 08:41:11','2025-11-29 08:41:11','2025-11-29 08:41:11',1,444,'585161eb-98bd-4e6b-8b3b-42b24e4b763b',106,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-334379363-1778895309',-1,'2025-11-30 08:41:11',NULL),('2025-11-29 08:41:16','2025-11-29 08:41:16','2025-11-29 08:41:16',1,445,'5a0437e1-175a-4028-9b7e-fa9136b572b9',115,'0ccc70201c12433cba2c77f57171fc5a','volumes',1,'2025-11-30 08:41:16',NULL),('2025-11-29 08:41:16','2025-11-29 08:41:16','2025-11-29 08:41:16',1,446,'c52c8d87-046d-450c-9688-ff93814c64bf',116,'0ccc70201c12433cba2c77f57171fc5a','gigabytes',1,'2025-11-30 08:41:16',NULL),('2025-11-29 08:41:16','2025-11-29 08:41:16','2025-11-29 08:41:16',1,447,'56429c60-7d1e-4c45-ad44-e3ff9ca08794',117,'0ccc70201c12433cba2c77f57171fc5a','volumes___DEFAULT__',1,'2025-11-30 08:41:16',NULL),('2025-11-29 08:41:16','2025-11-29 08:41:16','2025-11-29 08:41:16',1,448,'08619056-fd2b-4544-b5e0-94853e8e5877',118,'0ccc70201c12433cba2c77f57171fc5a','gigabytes___DEFAULT__',1,'2025-11-30 08:41:16',NULL),('2025-11-29 08:41:20','2025-11-29 08:41:20','2025-11-29 08:41:20',1,449,'fcb095d5-38aa-4964-aa51-2b19a152ef7a',115,'0ccc70201c12433cba2c77f57171fc5a','volumes',-1,'2025-11-30 08:41:20',NULL),('2025-11-29 08:41:20','2025-11-29 08:41:20','2025-11-29 08:41:20',1,450,'a3a40b0f-28d7-4320-b4ab-32934c0d5a12',116,'0ccc70201c12433cba2c77f57171fc5a','gigabytes',-1,'2025-11-30 08:41:20',NULL),('2025-11-29 08:41:20','2025-11-29 08:41:20','2025-11-29 08:41:20',1,451,'8583b7c8-ba04-4090-9605-c9e48b2ff5da',117,'0ccc70201c12433cba2c77f57171fc5a','volumes___DEFAULT__',-1,'2025-11-30 08:41:20',NULL),('2025-11-29 08:41:20','2025-11-29 08:41:20','2025-11-29 08:41:20',1,452,'a1fa2307-f308-4a2f-8930-7734739ebcd0',118,'0ccc70201c12433cba2c77f57171fc5a','gigabytes___DEFAULT__',-1,'2025-11-30 08:41:20',NULL),('2025-11-29 08:41:32','2025-11-29 08:41:32','2025-11-29 08:41:32',1,453,'d30c4018-61a1-4168-a140-aadf63075414',101,'62ca01275fe34ea0af31d00b34d6d9a5','volumes',-1,'2025-11-30 08:41:32',NULL),('2025-11-29 08:41:32','2025-11-29 08:41:32','2025-11-29 08:41:32',1,454,'105db833-2892-4322-93eb-3dd11fa94964',102,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes',-1,'2025-11-30 08:41:32',NULL),('2025-11-29 08:41:32','2025-11-29 08:41:32','2025-11-29 08:41:32',1,455,'c05f86d9-8089-4159-bead-74dd01f85ecd',107,'62ca01275fe34ea0af31d00b34d6d9a5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1204371373-2122106632',-1,'2025-11-30 08:41:32',NULL),('2025-11-29 08:41:32','2025-11-29 08:41:32','2025-11-29 08:41:32',1,456,'b834693e-90a2-4e94-83bb-4083ace8ef07',108,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1204371373-2122106632',-1,'2025-11-30 08:41:32',NULL),('2025-11-29 08:41:33','2025-11-29 08:41:33','2025-11-29 08:41:33',1,457,'cbc5c73a-a993-4bc4-9f81-308d26df75d7',101,'62ca01275fe34ea0af31d00b34d6d9a5','volumes',-1,'2025-11-30 08:41:33',NULL),('2025-11-29 08:41:33','2025-11-29 08:41:33','2025-11-29 08:41:33',1,458,'c1a56c18-fe01-4d10-a927-035dd1c0ca36',102,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes',-1,'2025-11-30 08:41:33',NULL),('2025-11-29 08:41:33','2025-11-29 08:41:33','2025-11-29 08:41:33',1,459,'38c971b3-b091-4830-bc4a-2485e39049df',107,'62ca01275fe34ea0af31d00b34d6d9a5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1204371373-2122106632',-1,'2025-11-30 08:41:33',NULL),('2025-11-29 08:41:33','2025-11-29 08:41:33','2025-11-29 08:41:33',1,460,'f3327c5b-25f4-40f0-9820-1e7af35d0dc2',108,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1204371373-2122106632',-1,'2025-11-30 08:41:33',NULL),('2025-11-29 08:41:34','2025-11-29 08:41:34','2025-11-29 08:41:34',1,461,'60fe7f4f-f10a-4a87-95e4-b7f6440261eb',101,'62ca01275fe34ea0af31d00b34d6d9a5','volumes',-1,'2025-11-30 08:41:34',NULL),('2025-11-29 08:41:34','2025-11-29 08:41:34','2025-11-29 08:41:34',1,462,'7ff7e82a-acae-4653-b57c-e754fb6defce',102,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes',-1,'2025-11-30 08:41:34',NULL),('2025-11-29 08:41:34','2025-11-29 08:41:34','2025-11-29 08:41:34',1,463,'e90cf3c1-655d-4aaf-8b22-10e9d2bdf123',107,'62ca01275fe34ea0af31d00b34d6d9a5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1204371373-2122106632',-1,'2025-11-30 08:41:34',NULL),('2025-11-29 08:41:34','2025-11-29 08:41:34','2025-11-29 08:41:34',1,464,'4cc8a588-e2f3-491c-8957-03328624ad9d',108,'62ca01275fe34ea0af31d00b34d6d9a5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1204371373-2122106632',-1,'2025-11-30 08:41:34',NULL),('2025-11-29 08:41:40','2025-11-29 08:41:41','2025-11-29 08:41:41',1,465,'585fd824-243b-45fe-a73f-596949bc0b20',119,'c80b570a17ee4094b96a75465fc34ae7','volumes',1,'2025-11-30 08:41:40',NULL),('2025-11-29 08:41:40','2025-11-29 08:41:41','2025-11-29 08:41:41',1,466,'5cb01f13-1f1a-4bea-ac7e-ed646e90e2d6',120,'c80b570a17ee4094b96a75465fc34ae7','gigabytes',1,'2025-11-30 08:41:40',NULL),('2025-11-29 08:41:40','2025-11-29 08:41:41','2025-11-29 08:41:41',1,467,'1c681b75-3992-4ac7-bc68-c7f69439c608',121,'c80b570a17ee4094b96a75465fc34ae7','volumes_tempest-scenario-type-luks-1501415148',1,'2025-11-30 08:41:40',NULL),('2025-11-29 08:41:40','2025-11-29 08:41:41','2025-11-29 08:41:41',1,468,'7d29b43d-1d75-44fe-97bb-14ff235985a3',122,'c80b570a17ee4094b96a75465fc34ae7','gigabytes_tempest-scenario-type-luks-1501415148',1,'2025-11-30 08:41:40',NULL),('2025-11-29 08:42:49','2025-11-29 08:42:49','2025-11-29 08:42:49',1,469,'b322ffcb-0a64-4d31-8646-ca1e5dabc63a',119,'c80b570a17ee4094b96a75465fc34ae7','volumes',-1,'2025-11-30 08:42:49',NULL),('2025-11-29 08:42:49','2025-11-29 08:42:49','2025-11-29 08:42:49',1,470,'8bc45d18-0df3-477e-ac7f-bca972687c5d',120,'c80b570a17ee4094b96a75465fc34ae7','gigabytes',-1,'2025-11-30 08:42:49',NULL),('2025-11-29 08:42:49','2025-11-29 08:42:49','2025-11-29 08:42:49',1,471,'749bc1da-da26-4685-96f0-5a2170d9fb3d',121,'c80b570a17ee4094b96a75465fc34ae7','volumes_tempest-scenario-type-luks-1501415148',-1,'2025-11-30 08:42:49',NULL),('2025-11-29 08:42:49','2025-11-29 08:42:49','2025-11-29 08:42:49',1,472,'6b446a46-7d62-4f04-a1f3-6441e5020cfa',122,'c80b570a17ee4094b96a75465fc34ae7','gigabytes_tempest-scenario-type-luks-1501415148',-1,'2025-11-30 08:42:49',NULL),('2025-11-29 08:43:24','2025-11-29 08:43:24','2025-11-29 08:43:24',1,473,'dd9d1e1b-dae0-4c35-929e-f6e7ada5ebed',123,'3b3b0484057a4e3db51366d29c6b684d','volumes',1,'2025-11-30 08:43:24',NULL),('2025-11-29 08:43:24','2025-11-29 08:43:24','2025-11-29 08:43:24',1,474,'f713530b-07d8-42b9-861c-63a4b348c0e7',124,'3b3b0484057a4e3db51366d29c6b684d','gigabytes',1,'2025-11-30 08:43:24',NULL),('2025-11-29 08:43:24','2025-11-29 08:43:24','2025-11-29 08:43:24',1,475,'84220a47-97bf-4837-b117-105b3e37cd57',125,'3b3b0484057a4e3db51366d29c6b684d','volumes___DEFAULT__',1,'2025-11-30 08:43:24',NULL),('2025-11-29 08:43:24','2025-11-29 08:43:24','2025-11-29 08:43:24',1,476,'52cfac55-f9c1-47a9-a7a6-e02f368eba31',126,'3b3b0484057a4e3db51366d29c6b684d','gigabytes___DEFAULT__',1,'2025-11-30 08:43:24',NULL),('2025-11-29 08:44:22','2025-11-29 08:44:22','2025-11-29 08:44:22',1,477,'b4c84f84-9fa5-44df-b073-3d9e10549f49',127,'3b3b0484057a4e3db51366d29c6b684d','snapshots',1,'2025-11-30 08:44:22',NULL),('2025-11-29 08:44:22','2025-11-29 08:44:22','2025-11-29 08:44:22',1,478,'2c15b564-0f2d-440f-a830-696f119f4917',124,'3b3b0484057a4e3db51366d29c6b684d','gigabytes',1,'2025-11-30 08:44:22',NULL),('2025-11-29 08:44:22','2025-11-29 08:44:22','2025-11-29 08:44:22',1,479,'22c97c3c-807f-48e9-a342-1165df1793ee',126,'3b3b0484057a4e3db51366d29c6b684d','gigabytes___DEFAULT__',1,'2025-11-30 08:44:22',NULL),('2025-11-29 08:44:22','2025-11-29 08:44:22','2025-11-29 08:44:22',1,480,'bee82427-059d-4d6c-8cb5-7f2f26c1853a',128,'3b3b0484057a4e3db51366d29c6b684d','snapshots___DEFAULT__',1,'2025-11-30 08:44:22',NULL),('2025-11-29 08:44:29','2025-11-29 08:44:30','2025-11-29 08:44:30',1,481,'5bf247ea-e00c-44c5-a49c-1838b400677f',123,'3b3b0484057a4e3db51366d29c6b684d','volumes',1,'2025-11-30 08:44:29',NULL),('2025-11-29 08:44:29','2025-11-29 08:44:30','2025-11-29 08:44:30',1,482,'a1716fd0-cabd-4e5a-af09-30191be53786',124,'3b3b0484057a4e3db51366d29c6b684d','gigabytes',1,'2025-11-30 08:44:29',NULL),('2025-11-29 08:44:29','2025-11-29 08:44:30','2025-11-29 08:44:30',1,483,'f887a1d3-7533-466e-a8fd-052ba273eb2c',125,'3b3b0484057a4e3db51366d29c6b684d','volumes___DEFAULT__',1,'2025-11-30 08:44:29',NULL),('2025-11-29 08:44:30','2025-11-29 08:44:30','2025-11-29 08:44:30',1,484,'54afb76b-c71e-4c87-aeb3-bdad0a3f8bc2',126,'3b3b0484057a4e3db51366d29c6b684d','gigabytes___DEFAULT__',1,'2025-11-30 08:44:29',NULL),('2025-11-29 08:45:34','2025-11-29 08:45:34','2025-11-29 08:45:34',1,485,'e2333847-2702-4e51-841e-a04debc49792',123,'3b3b0484057a4e3db51366d29c6b684d','volumes',-1,'2025-11-30 08:45:34',NULL),('2025-11-29 08:45:34','2025-11-29 08:45:34','2025-11-29 08:45:34',1,486,'0b25f077-9f39-4526-ba6d-6d69cf812374',124,'3b3b0484057a4e3db51366d29c6b684d','gigabytes',-1,'2025-11-30 08:45:34',NULL),('2025-11-29 08:45:34','2025-11-29 08:45:34','2025-11-29 08:45:34',1,487,'efe41c29-3186-44ae-bd6f-e7c3e564e141',125,'3b3b0484057a4e3db51366d29c6b684d','volumes___DEFAULT__',-1,'2025-11-30 08:45:34',NULL),('2025-11-29 08:45:34','2025-11-29 08:45:34','2025-11-29 08:45:34',1,488,'537c7c8f-d55f-4642-8a96-b0f479339ad5',126,'3b3b0484057a4e3db51366d29c6b684d','gigabytes___DEFAULT__',-1,'2025-11-30 08:45:34',NULL),('2025-11-29 08:45:38','2025-11-29 08:45:38','2025-11-29 08:45:38',1,489,'5d8caf1c-7684-4f16-a473-d26523282a57',127,'3b3b0484057a4e3db51366d29c6b684d','snapshots',-1,'2025-11-30 08:45:38',NULL),('2025-11-29 08:45:38','2025-11-29 08:45:38','2025-11-29 08:45:38',1,490,'dbbe73e5-9786-48ec-aa6c-885bf5536044',124,'3b3b0484057a4e3db51366d29c6b684d','gigabytes',-1,'2025-11-30 08:45:38',NULL),('2025-11-29 08:45:38','2025-11-29 08:45:38','2025-11-29 08:45:38',1,491,'1d18c17f-2a16-4a7f-b6a7-923c16eed5c6',126,'3b3b0484057a4e3db51366d29c6b684d','gigabytes___DEFAULT__',-1,'2025-11-30 08:45:38',NULL),('2025-11-29 08:45:38','2025-11-29 08:45:38','2025-11-29 08:45:38',1,492,'6840ab8b-f957-49cc-af7d-c568956f8cee',128,'3b3b0484057a4e3db51366d29c6b684d','snapshots___DEFAULT__',-1,'2025-11-30 08:45:38',NULL),('2025-11-29 08:45:47','2025-11-29 08:45:47','2025-11-29 08:45:47',1,493,'3d14cf73-18b8-4470-b368-46e235b07d98',123,'3b3b0484057a4e3db51366d29c6b684d','volumes',-1,'2025-11-30 08:45:47',NULL),('2025-11-29 08:45:47','2025-11-29 08:45:47','2025-11-29 08:45:47',1,494,'d577fc0b-bb41-4888-a0cf-972790163632',124,'3b3b0484057a4e3db51366d29c6b684d','gigabytes',-1,'2025-11-30 08:45:47',NULL),('2025-11-29 08:45:47','2025-11-29 08:45:47','2025-11-29 08:45:47',1,495,'8f9d7b5c-a007-4a5c-af9b-0d5510c9c8a7',125,'3b3b0484057a4e3db51366d29c6b684d','volumes___DEFAULT__',-1,'2025-11-30 08:45:47',NULL),('2025-11-29 08:45:47','2025-11-29 08:45:47','2025-11-29 08:45:47',1,496,'e51d87f4-6a7c-4565-996a-68d7f25f22bb',126,'3b3b0484057a4e3db51366d29c6b684d','gigabytes___DEFAULT__',-1,'2025-11-30 08:45:47',NULL),('2025-11-29 08:46:19','2025-11-29 08:46:19','2025-11-29 08:46:19',1,497,'6cdd338d-b5be-4d82-8cef-074f270818f1',129,'b7ffcb23bac14ee49474df9aee5f7dae','volumes',1,'2025-11-30 08:46:19',NULL),('2025-11-29 08:46:19','2025-11-29 08:46:19','2025-11-29 08:46:19',1,498,'3f829144-749e-42f6-9b64-918acd0d6f6e',130,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes',1,'2025-11-30 08:46:19',NULL),('2025-11-29 08:46:19','2025-11-29 08:46:19','2025-11-29 08:46:19',1,499,'c1ea2361-7c8e-49cb-a364-547008793120',131,'b7ffcb23bac14ee49474df9aee5f7dae','volumes_tempest-scenario-type-luks-677447409',1,'2025-11-30 08:46:19',NULL),('2025-11-29 08:46:19','2025-11-29 08:46:19','2025-11-29 08:46:19',1,500,'140e6471-95ad-4280-92d6-6fd015ed3538',132,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes_tempest-scenario-type-luks-677447409',1,'2025-11-30 08:46:19',NULL),('2025-11-29 08:47:01','2025-11-29 08:47:01','2025-11-29 08:47:01',1,501,'22b4c063-9e05-41ef-8c2e-f362b0f74044',129,'b7ffcb23bac14ee49474df9aee5f7dae','volumes',-1,'2025-11-30 08:47:01',NULL),('2025-11-29 08:47:01','2025-11-29 08:47:01','2025-11-29 08:47:01',1,502,'4fa3b710-474e-43ba-acd4-3e53c762ccfd',130,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes',-1,'2025-11-30 08:47:01',NULL),('2025-11-29 08:47:01','2025-11-29 08:47:01','2025-11-29 08:47:01',1,503,'a9e7838a-94e9-4043-920f-f45ef852b9b0',131,'b7ffcb23bac14ee49474df9aee5f7dae','volumes_tempest-scenario-type-luks-677447409',-1,'2025-11-30 08:47:01',NULL),('2025-11-29 08:47:01','2025-11-29 08:47:01','2025-11-29 08:47:01',1,504,'b1d2f7c4-4dbd-4ae3-a38f-1ded0be8270f',132,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes_tempest-scenario-type-luks-677447409',-1,'2025-11-30 08:47:01',NULL),('2025-11-29 08:47:06','2025-11-29 08:47:07','2025-11-29 08:47:07',1,505,'ad7d54b1-78f5-4d4e-b02c-1d39840bad73',129,'b7ffcb23bac14ee49474df9aee5f7dae','volumes',1,'2025-11-30 08:47:06',NULL),('2025-11-29 08:47:06','2025-11-29 08:47:07','2025-11-29 08:47:07',1,506,'a5caeb72-84e4-4b4b-93c0-935611386ddb',130,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes',1,'2025-11-30 08:47:06',NULL),('2025-11-29 08:47:06','2025-11-29 08:47:07','2025-11-29 08:47:07',1,507,'c40d8b79-3d66-4e53-b895-078e7ac6de30',133,'b7ffcb23bac14ee49474df9aee5f7dae','volumes___DEFAULT__',1,'2025-11-30 08:47:06',NULL),('2025-11-29 08:47:06','2025-11-29 08:47:07','2025-11-29 08:47:07',1,508,'b36e38e3-1aee-473e-b580-05f65de0d2ef',134,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes___DEFAULT__',1,'2025-11-30 08:47:06',NULL),('2025-11-29 08:47:14','2025-11-29 08:47:14','2025-11-29 08:47:14',1,509,'6c6d7c61-b4ab-4955-baca-31e0f40921cc',135,'b7ffcb23bac14ee49474df9aee5f7dae','snapshots',1,'2025-11-30 08:47:14',NULL),('2025-11-29 08:47:14','2025-11-29 08:47:14','2025-11-29 08:47:14',1,510,'c72b4800-ec9d-4c60-ac24-8974ead28f27',130,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes',1,'2025-11-30 08:47:14',NULL),('2025-11-29 08:47:14','2025-11-29 08:47:14','2025-11-29 08:47:14',1,511,'22e6bc20-9a19-43b1-a7b3-22f1d0be4ecb',134,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes___DEFAULT__',1,'2025-11-30 08:47:14',NULL),('2025-11-29 08:47:14','2025-11-29 08:47:14','2025-11-29 08:47:14',1,512,'bd65388d-b051-4443-9ec6-e3f900314424',136,'b7ffcb23bac14ee49474df9aee5f7dae','snapshots___DEFAULT__',1,'2025-11-30 08:47:14',NULL),('2025-11-29 08:47:22','2025-11-29 08:47:22','2025-11-29 08:47:22',1,513,'78c63e5a-bb7d-49b7-8236-72c4e5a54173',129,'b7ffcb23bac14ee49474df9aee5f7dae','volumes',1,'2025-11-30 08:47:22',NULL),('2025-11-29 08:47:22','2025-11-29 08:47:22','2025-11-29 08:47:22',1,514,'13de7ce0-03e0-48a6-938b-904266da29a5',130,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes',1,'2025-11-30 08:47:22',NULL),('2025-11-29 08:47:22','2025-11-29 08:47:22','2025-11-29 08:47:22',1,515,'de443812-b527-43c6-b2b2-5ee4875ad9b5',133,'b7ffcb23bac14ee49474df9aee5f7dae','volumes___DEFAULT__',1,'2025-11-30 08:47:22',NULL),('2025-11-29 08:47:22','2025-11-29 08:47:22','2025-11-29 08:47:22',1,516,'a5c92e3f-9737-4078-af54-41c2289f9bf1',134,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes___DEFAULT__',1,'2025-11-30 08:47:22',NULL),('2025-11-29 08:47:36','2025-11-29 08:47:36','2025-11-29 08:47:36',1,517,'64f4a1a5-a001-45ed-93e8-7ec62a6b3309',129,'b7ffcb23bac14ee49474df9aee5f7dae','volumes',-1,'2025-11-30 08:47:36',NULL),('2025-11-29 08:47:36','2025-11-29 08:47:36','2025-11-29 08:47:36',1,518,'84d0882f-bbe6-4c41-8e35-c8cfa79342ae',130,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes',-1,'2025-11-30 08:47:36',NULL),('2025-11-29 08:47:36','2025-11-29 08:47:36','2025-11-29 08:47:36',1,519,'510ef65d-6746-46a9-80f1-2a6d4a8fae00',133,'b7ffcb23bac14ee49474df9aee5f7dae','volumes___DEFAULT__',-1,'2025-11-30 08:47:36',NULL),('2025-11-29 08:47:36','2025-11-29 08:47:36','2025-11-29 08:47:36',1,520,'3cc53136-ccea-45a7-be77-e1595e939144',134,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes___DEFAULT__',-1,'2025-11-30 08:47:36',NULL),('2025-11-29 08:47:38','2025-11-29 08:47:38','2025-11-29 08:47:38',1,521,'57d5292e-925d-4430-8ff9-4254a51511de',135,'b7ffcb23bac14ee49474df9aee5f7dae','snapshots',-1,'2025-11-30 08:47:38',NULL),('2025-11-29 08:47:38','2025-11-29 08:47:38','2025-11-29 08:47:38',1,522,'84698c9c-3f8a-4f69-b593-823b47d30603',130,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes',-1,'2025-11-30 08:47:38',NULL),('2025-11-29 08:47:38','2025-11-29 08:47:38','2025-11-29 08:47:38',1,523,'873dbb81-2848-45b8-8192-1cfefec752dc',134,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes___DEFAULT__',-1,'2025-11-30 08:47:38',NULL),('2025-11-29 08:47:38','2025-11-29 08:47:38','2025-11-29 08:47:38',1,524,'00882bd0-5cc7-49e0-92d1-72eaa89f7749',136,'b7ffcb23bac14ee49474df9aee5f7dae','snapshots___DEFAULT__',-1,'2025-11-30 08:47:38',NULL),('2025-11-29 08:47:39','2025-11-29 08:47:39','2025-11-29 08:47:39',1,525,'a87e9b5f-9549-425f-8bbd-0fa27f7ad680',129,'b7ffcb23bac14ee49474df9aee5f7dae','volumes',-1,'2025-11-30 08:47:39',NULL),('2025-11-29 08:47:39','2025-11-29 08:47:39','2025-11-29 08:47:39',1,526,'e6d72cce-a089-45b8-a6ea-eba2c5c4ef9d',130,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes',-1,'2025-11-30 08:47:39',NULL),('2025-11-29 08:47:39','2025-11-29 08:47:39','2025-11-29 08:47:39',1,527,'56dde12d-32d5-403c-ada2-f2fd78801beb',133,'b7ffcb23bac14ee49474df9aee5f7dae','volumes___DEFAULT__',-1,'2025-11-30 08:47:39',NULL),('2025-11-29 08:47:39','2025-11-29 08:47:39','2025-11-29 08:47:39',1,528,'f81e4305-079c-4c38-bd5f-f99a6d7888ba',134,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes___DEFAULT__',-1,'2025-11-30 08:47:39',NULL),('2025-11-29 08:47:41','2025-11-29 08:47:41','2025-11-29 08:47:41',1,529,'6ac4b908-1d31-4758-a960-5421a2dd0ec4',129,'b7ffcb23bac14ee49474df9aee5f7dae','volumes',1,'2025-11-30 08:47:41',NULL),('2025-11-29 08:47:41','2025-11-29 08:47:41','2025-11-29 08:47:41',1,530,'347a44b6-1c6f-4fe3-9390-db935388b881',130,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes',1,'2025-11-30 08:47:41',NULL),('2025-11-29 08:47:41','2025-11-29 08:47:41','2025-11-29 08:47:41',1,531,'21f79d9d-a066-4463-ae7d-cb9c3a34c6ac',133,'b7ffcb23bac14ee49474df9aee5f7dae','volumes___DEFAULT__',1,'2025-11-30 08:47:41',NULL),('2025-11-29 08:47:41','2025-11-29 08:47:41','2025-11-29 08:47:41',1,532,'0781e7bd-4a64-44e2-8ab8-3a1015301952',134,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes___DEFAULT__',1,'2025-11-30 08:47:41',NULL),('2025-11-29 08:48:43','2025-11-29 08:48:43','2025-11-29 08:48:43',1,533,'e19caba1-da3e-4fda-8e97-8643faa92053',135,'b7ffcb23bac14ee49474df9aee5f7dae','snapshots',1,'2025-11-30 08:48:43',NULL),('2025-11-29 08:48:43','2025-11-29 08:48:43','2025-11-29 08:48:43',1,534,'ac355805-5995-4522-ab4f-2710352fcc75',130,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes',1,'2025-11-30 08:48:43',NULL),('2025-11-29 08:48:43','2025-11-29 08:48:43','2025-11-29 08:48:43',1,535,'82198bde-56ec-4bd6-9652-b7d0fe15d48c',134,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes___DEFAULT__',1,'2025-11-30 08:48:43',NULL),('2025-11-29 08:48:43','2025-11-29 08:48:43','2025-11-29 08:48:43',1,536,'d3b49e78-5c2d-4d47-84ab-37c964aa410c',136,'b7ffcb23bac14ee49474df9aee5f7dae','snapshots___DEFAULT__',1,'2025-11-30 08:48:43',NULL),('2025-11-29 08:48:49','2025-11-29 08:48:49','2025-11-29 08:48:49',1,537,'6c1f1c86-d143-4c03-8639-2a93f5e2521a',137,'2e636ab14fe94059b82b9cbcf8831d87','volumes',1,'2025-11-30 08:48:49',NULL),('2025-11-29 08:48:49','2025-11-29 08:48:49','2025-11-29 08:48:49',1,538,'8828095d-da9e-4a41-8c27-cc069b48eb62',138,'2e636ab14fe94059b82b9cbcf8831d87','gigabytes',1,'2025-11-30 08:48:49',NULL),('2025-11-29 08:48:49','2025-11-29 08:48:49','2025-11-29 08:48:49',1,539,'fa2dd31a-1d36-49af-bd1d-d11f8d4588ae',139,'2e636ab14fe94059b82b9cbcf8831d87','volumes___DEFAULT__',1,'2025-11-30 08:48:49',NULL),('2025-11-29 08:48:49','2025-11-29 08:48:49','2025-11-29 08:48:49',1,540,'d54e09f7-0195-4ae8-94cc-ecea9d703a51',140,'2e636ab14fe94059b82b9cbcf8831d87','gigabytes___DEFAULT__',1,'2025-11-30 08:48:49',NULL),('2025-11-29 08:48:51','2025-11-29 08:48:52','2025-11-29 08:48:52',1,541,'8dd79411-ed1d-4d7a-90b9-efccd060da92',129,'b7ffcb23bac14ee49474df9aee5f7dae','volumes',1,'2025-11-30 08:48:51',NULL),('2025-11-29 08:48:51','2025-11-29 08:48:52','2025-11-29 08:48:52',1,542,'473a0a5b-54ff-491e-97f1-f4f1e3c9b2f4',130,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes',1,'2025-11-30 08:48:51',NULL),('2025-11-29 08:48:51','2025-11-29 08:48:52','2025-11-29 08:48:52',1,543,'96a3ec60-ec9f-404e-bd07-a447ac330722',133,'b7ffcb23bac14ee49474df9aee5f7dae','volumes___DEFAULT__',1,'2025-11-30 08:48:51',NULL),('2025-11-29 08:48:51','2025-11-29 08:48:52','2025-11-29 08:48:52',1,544,'628647ac-5f20-4ca9-80f1-cbbe806ae2ba',134,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes___DEFAULT__',1,'2025-11-30 08:48:51',NULL),('2025-11-29 08:49:40','2025-11-29 08:49:40','2025-11-29 08:49:40',1,545,'363d644b-bdfe-4abb-a7e9-a8cac21f929c',129,'b7ffcb23bac14ee49474df9aee5f7dae','volumes',-1,'2025-11-30 08:49:40',NULL),('2025-11-29 08:49:40','2025-11-29 08:49:40','2025-11-29 08:49:40',1,546,'77d47ebf-da0d-4cae-b347-37a2b17c9094',130,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes',-1,'2025-11-30 08:49:40',NULL),('2025-11-29 08:49:40','2025-11-29 08:49:40','2025-11-29 08:49:40',1,547,'3b60fde5-6d94-452e-b6a7-85ac8cf528ec',133,'b7ffcb23bac14ee49474df9aee5f7dae','volumes___DEFAULT__',-1,'2025-11-30 08:49:40',NULL),('2025-11-29 08:49:40','2025-11-29 08:49:40','2025-11-29 08:49:40',1,548,'b955fdba-cdd0-44d6-b2dd-d1838aee61e4',134,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes___DEFAULT__',-1,'2025-11-30 08:49:40',NULL),('2025-11-29 08:49:43','2025-11-29 08:49:43','2025-11-29 08:49:43',1,549,'8af3d2e1-0c38-43ec-8f1e-6f3679bc8aeb',135,'b7ffcb23bac14ee49474df9aee5f7dae','snapshots',-1,'2025-11-30 08:49:43',NULL),('2025-11-29 08:49:43','2025-11-29 08:49:43','2025-11-29 08:49:43',1,550,'77c80ea5-6689-45fd-8321-5a8270dd04da',130,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes',-1,'2025-11-30 08:49:43',NULL),('2025-11-29 08:49:43','2025-11-29 08:49:43','2025-11-29 08:49:43',1,551,'477c61f8-dcfb-424a-9d71-b1d123913993',134,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes___DEFAULT__',-1,'2025-11-30 08:49:43',NULL),('2025-11-29 08:49:43','2025-11-29 08:49:43','2025-11-29 08:49:43',1,552,'ed8537f2-9aff-4e57-8dce-d99f5d256a13',136,'b7ffcb23bac14ee49474df9aee5f7dae','snapshots___DEFAULT__',-1,'2025-11-30 08:49:43',NULL),('2025-11-29 08:49:46','2025-11-29 08:49:47','2025-11-29 08:49:47',1,553,'b22d5de4-6049-446c-96d0-70cd716dd977',129,'b7ffcb23bac14ee49474df9aee5f7dae','volumes',-1,'2025-11-30 08:49:46',NULL),('2025-11-29 08:49:46','2025-11-29 08:49:47','2025-11-29 08:49:47',1,554,'563c12c2-92d2-410f-94cd-a5bc6a3c7d0e',130,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes',-1,'2025-11-30 08:49:46',NULL),('2025-11-29 08:49:46','2025-11-29 08:49:47','2025-11-29 08:49:47',1,555,'c0aec46c-c604-4774-aa40-97e458448c13',133,'b7ffcb23bac14ee49474df9aee5f7dae','volumes___DEFAULT__',-1,'2025-11-30 08:49:46',NULL),('2025-11-29 08:49:46','2025-11-29 08:49:47','2025-11-29 08:49:47',1,556,'93d18309-0e1b-4b04-8549-49188a88cdfc',134,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes___DEFAULT__',-1,'2025-11-30 08:49:46',NULL),('2025-11-29 08:49:57','2025-11-29 08:49:57','2025-11-29 08:49:57',1,557,'e48747d2-83cd-4c4c-8bb5-8d80f2f3324e',129,'b7ffcb23bac14ee49474df9aee5f7dae','volumes',1,'2025-11-30 08:49:57',NULL),('2025-11-29 08:49:57','2025-11-29 08:49:57','2025-11-29 08:49:57',1,558,'9192f535-75bd-4101-a881-1afbb3e007e2',130,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes',1,'2025-11-30 08:49:57',NULL),('2025-11-29 08:49:57','2025-11-29 08:49:57','2025-11-29 08:49:57',1,559,'5b484402-efb3-49d6-8ff2-6de2aab55786',133,'b7ffcb23bac14ee49474df9aee5f7dae','volumes___DEFAULT__',1,'2025-11-30 08:49:57',NULL),('2025-11-29 08:49:57','2025-11-29 08:49:57','2025-11-29 08:49:57',1,560,'2842c470-cd57-4e33-8d14-f4dd8164183f',134,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes___DEFAULT__',1,'2025-11-30 08:49:57',NULL),('2025-11-29 08:50:29','2025-11-29 08:50:29','2025-11-29 08:50:29',1,561,'e0aaaab6-a4cf-4434-b14b-f1b8f870abbe',137,'2e636ab14fe94059b82b9cbcf8831d87','volumes',-1,'2025-11-30 08:50:29',NULL),('2025-11-29 08:50:29','2025-11-29 08:50:29','2025-11-29 08:50:29',1,562,'928f071f-3c82-4969-b1eb-e471fe4b7bf5',138,'2e636ab14fe94059b82b9cbcf8831d87','gigabytes',-1,'2025-11-30 08:50:29',NULL),('2025-11-29 08:50:29','2025-11-29 08:50:29','2025-11-29 08:50:29',1,563,'3d2bb774-5d49-44e5-8863-10610dde19ce',139,'2e636ab14fe94059b82b9cbcf8831d87','volumes___DEFAULT__',-1,'2025-11-30 08:50:29',NULL),('2025-11-29 08:50:29','2025-11-29 08:50:29','2025-11-29 08:50:29',1,564,'3afc5216-1001-475e-af09-d5ea121eaf38',140,'2e636ab14fe94059b82b9cbcf8831d87','gigabytes___DEFAULT__',-1,'2025-11-30 08:50:29',NULL),('2025-11-29 08:51:38','2025-11-29 08:51:38','2025-11-29 08:51:38',1,565,'fedc91b4-fee5-459f-9cf6-ab3ae93e9346',141,'676f70280bf945cd90578b14202243e2','volumes',1,'2025-11-30 08:51:38',NULL),('2025-11-29 08:51:38','2025-11-29 08:51:38','2025-11-29 08:51:38',1,566,'414173fa-d03e-4d67-bf2f-9410f1b9ea40',142,'676f70280bf945cd90578b14202243e2','gigabytes',1,'2025-11-30 08:51:38',NULL),('2025-11-29 08:51:38','2025-11-29 08:51:38','2025-11-29 08:51:38',1,567,'1391b1ea-8486-42db-857f-1286dd6d6566',143,'676f70280bf945cd90578b14202243e2','volumes___DEFAULT__',1,'2025-11-30 08:51:38',NULL),('2025-11-29 08:51:38','2025-11-29 08:51:38','2025-11-29 08:51:38',1,568,'15b7630d-bf3f-41bc-ae23-c7c1d4337fe3',144,'676f70280bf945cd90578b14202243e2','gigabytes___DEFAULT__',1,'2025-11-30 08:51:38',NULL),('2025-11-29 08:51:40','2025-11-29 08:51:41','2025-11-29 08:51:41',1,569,'05766d3d-67d8-4639-b9ad-04ec917ce173',135,'b7ffcb23bac14ee49474df9aee5f7dae','snapshots',1,'2025-11-30 08:51:40',NULL),('2025-11-29 08:51:40','2025-11-29 08:51:41','2025-11-29 08:51:41',1,570,'df5390e5-387e-4962-b690-d4efa29f7059',130,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes',1,'2025-11-30 08:51:40',NULL),('2025-11-29 08:51:40','2025-11-29 08:51:41','2025-11-29 08:51:41',1,571,'41a4a09d-6b69-4c8a-9a44-97c2bd1a80ec',134,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes___DEFAULT__',1,'2025-11-30 08:51:40',NULL),('2025-11-29 08:51:40','2025-11-29 08:51:41','2025-11-29 08:51:41',1,572,'a3ef197e-a49e-4799-8e27-7fe3b2707256',136,'b7ffcb23bac14ee49474df9aee5f7dae','snapshots___DEFAULT__',1,'2025-11-30 08:51:40',NULL),('2025-11-29 08:51:47','2025-11-29 08:51:48','2025-11-29 08:51:48',1,573,'0add8317-bc4b-4fb6-b06b-9ccfe29327f1',129,'b7ffcb23bac14ee49474df9aee5f7dae','volumes',1,'2025-11-30 08:51:47',NULL),('2025-11-29 08:51:47','2025-11-29 08:51:48','2025-11-29 08:51:48',1,574,'50dd3fd9-2baa-4742-90e4-e89c3f9c5642',130,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes',1,'2025-11-30 08:51:47',NULL),('2025-11-29 08:51:47','2025-11-29 08:51:48','2025-11-29 08:51:48',1,575,'c33ec6c8-48b2-43e4-a408-9c3dec1b97f4',133,'b7ffcb23bac14ee49474df9aee5f7dae','volumes___DEFAULT__',1,'2025-11-30 08:51:47',NULL),('2025-11-29 08:51:47','2025-11-29 08:51:48','2025-11-29 08:51:48',1,576,'79e990f0-7a20-4357-a4ef-4c8442801e35',134,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes___DEFAULT__',1,'2025-11-30 08:51:47',NULL),('2025-11-29 08:51:55','2025-11-29 08:51:55','2025-11-29 08:51:55',1,577,'9006ec62-f5b1-4d13-a24d-201acdb442fd',145,'676f70280bf945cd90578b14202243e2','backups',1,'2025-11-30 08:51:55',NULL),('2025-11-29 08:51:55','2025-11-29 08:51:55','2025-11-29 08:51:55',1,578,'d521ad88-e3fd-4535-8c9f-6d8837908ec2',146,'676f70280bf945cd90578b14202243e2','backup_gigabytes',1,'2025-11-30 08:51:55',NULL),('2025-11-29 08:52:03','2025-11-29 08:52:03','2025-11-29 08:52:03',1,579,'082c10dc-15cd-46fd-9550-68e25623e280',141,'676f70280bf945cd90578b14202243e2','volumes',1,'2025-11-30 08:52:03',NULL),('2025-11-29 08:52:03','2025-11-29 08:52:03','2025-11-29 08:52:03',1,580,'e6532461-f212-4c42-abbc-da665342229c',142,'676f70280bf945cd90578b14202243e2','gigabytes',1,'2025-11-30 08:52:03',NULL),('2025-11-29 08:52:03','2025-11-29 08:52:03','2025-11-29 08:52:03',1,581,'02b02924-5c0d-4e7d-954f-c79efeb3b808',143,'676f70280bf945cd90578b14202243e2','volumes___DEFAULT__',1,'2025-11-30 08:52:03',NULL),('2025-11-29 08:52:03','2025-11-29 08:52:03','2025-11-29 08:52:03',1,582,'42ec376f-fcc3-44c3-95ee-ab83687a7d85',144,'676f70280bf945cd90578b14202243e2','gigabytes___DEFAULT__',1,'2025-11-30 08:52:03',NULL),('2025-11-29 08:52:52','2025-11-29 08:52:52','2025-11-29 08:52:52',1,583,'f5229808-bd0d-4675-a31c-891227e76510',129,'b7ffcb23bac14ee49474df9aee5f7dae','volumes',-1,'2025-11-30 08:52:52',NULL),('2025-11-29 08:52:52','2025-11-29 08:52:52','2025-11-29 08:52:52',1,584,'fe163145-ff43-4e51-a0b5-8c51b7223a62',130,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes',-1,'2025-11-30 08:52:52',NULL),('2025-11-29 08:52:52','2025-11-29 08:52:52','2025-11-29 08:52:52',1,585,'362c6974-206b-44cd-b759-2424a2fe08b0',133,'b7ffcb23bac14ee49474df9aee5f7dae','volumes___DEFAULT__',-1,'2025-11-30 08:52:52',NULL),('2025-11-29 08:52:52','2025-11-29 08:52:52','2025-11-29 08:52:52',1,586,'a5d1e4c1-100d-4aa3-a6af-3c9528813b05',134,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes___DEFAULT__',-1,'2025-11-30 08:52:52',NULL),('2025-11-29 08:52:52','2025-11-29 08:52:52','2025-11-29 08:52:52',1,587,'278fa15e-ac45-42df-8a77-23b09e9e3fbc',141,'676f70280bf945cd90578b14202243e2','volumes',-1,'2025-11-30 08:52:52',NULL),('2025-11-29 08:52:52','2025-11-29 08:52:52','2025-11-29 08:52:52',1,588,'70754001-4b91-4623-abb0-b347466e2193',142,'676f70280bf945cd90578b14202243e2','gigabytes',-1,'2025-11-30 08:52:52',NULL),('2025-11-29 08:52:52','2025-11-29 08:52:52','2025-11-29 08:52:52',1,589,'da54f3d1-b2ba-4281-8bd8-73f1fb14829e',143,'676f70280bf945cd90578b14202243e2','volumes___DEFAULT__',-1,'2025-11-30 08:52:52',NULL),('2025-11-29 08:52:52','2025-11-29 08:52:52','2025-11-29 08:52:52',1,590,'d6a83a79-c208-493b-b5e0-8ab62b26ba86',144,'676f70280bf945cd90578b14202243e2','gigabytes___DEFAULT__',-1,'2025-11-30 08:52:52',NULL),('2025-11-29 08:52:52','2025-11-29 08:52:52','2025-11-29 08:52:52',1,591,'68c318c6-a2c5-46a3-8605-912d64f5a0b9',141,'676f70280bf945cd90578b14202243e2','volumes',-1,'2025-11-30 08:52:52',NULL),('2025-11-29 08:52:52','2025-11-29 08:52:52','2025-11-29 08:52:52',1,592,'8dd288e2-6fb6-438a-b668-1ea90e13ce68',142,'676f70280bf945cd90578b14202243e2','gigabytes',-1,'2025-11-30 08:52:52',NULL),('2025-11-29 08:52:52','2025-11-29 08:52:52','2025-11-29 08:52:52',1,593,'414bb56f-906d-4fc8-82a4-4a7e0346a8cb',145,'676f70280bf945cd90578b14202243e2','backups',-1,'2025-11-30 08:52:52',NULL),('2025-11-29 08:52:52','2025-11-29 08:52:52','2025-11-29 08:52:52',1,594,'bf1bb1cf-fe46-4cd8-9921-aef8346d5a34',143,'676f70280bf945cd90578b14202243e2','volumes___DEFAULT__',-1,'2025-11-30 08:52:52',NULL),('2025-11-29 08:52:52','2025-11-29 08:52:52','2025-11-29 08:52:52',1,595,'5540529d-7919-4f61-a86e-81ea5b84bbc0',146,'676f70280bf945cd90578b14202243e2','backup_gigabytes',-1,'2025-11-30 08:52:52',NULL),('2025-11-29 08:52:52','2025-11-29 08:52:52','2025-11-29 08:52:52',1,596,'de539c67-4acf-4878-808b-4c059b60bfe9',144,'676f70280bf945cd90578b14202243e2','gigabytes___DEFAULT__',-1,'2025-11-30 08:52:52',NULL),('2025-11-29 08:52:54','2025-11-29 08:52:54','2025-11-29 08:52:54',1,597,'a8cddf59-501c-45c5-a9ad-d138d7280c66',135,'b7ffcb23bac14ee49474df9aee5f7dae','snapshots',-1,'2025-11-30 08:52:54',NULL),('2025-11-29 08:52:54','2025-11-29 08:52:54','2025-11-29 08:52:54',1,598,'1c3b1d34-b22a-4e7c-9012-f51ae8626afa',130,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes',-1,'2025-11-30 08:52:54',NULL),('2025-11-29 08:52:54','2025-11-29 08:52:54','2025-11-29 08:52:54',1,599,'ab0a8e59-9272-49cb-845f-fcdb6794667c',134,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes___DEFAULT__',-1,'2025-11-30 08:52:54',NULL),('2025-11-29 08:52:54','2025-11-29 08:52:54','2025-11-29 08:52:54',1,600,'dc1420e1-e8fb-47dc-be7f-800ef94613d3',136,'b7ffcb23bac14ee49474df9aee5f7dae','snapshots___DEFAULT__',-1,'2025-11-30 08:52:54',NULL),('2025-11-29 08:53:03','2025-11-29 08:53:03','2025-11-29 08:53:03',1,601,'562440f7-eabb-459b-a2e8-2efdd6268035',129,'b7ffcb23bac14ee49474df9aee5f7dae','volumes',-1,'2025-11-30 08:53:03',NULL),('2025-11-29 08:53:03','2025-11-29 08:53:03','2025-11-29 08:53:03',1,602,'0e796a95-f7ef-4b10-84e6-760179823562',130,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes',-1,'2025-11-30 08:53:03',NULL),('2025-11-29 08:53:03','2025-11-29 08:53:03','2025-11-29 08:53:03',1,603,'8d7a2105-f722-4746-b493-03118891ea6a',133,'b7ffcb23bac14ee49474df9aee5f7dae','volumes___DEFAULT__',-1,'2025-11-30 08:53:03',NULL),('2025-11-29 08:53:03','2025-11-29 08:53:03','2025-11-29 08:53:03',1,604,'be40493d-0b52-4ca6-9f40-59c2176307f2',134,'b7ffcb23bac14ee49474df9aee5f7dae','gigabytes___DEFAULT__',-1,'2025-11-30 08:53:03',NULL);
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `rpc_current_version` varchar(36) DEFAULT NULL,
  `object_current_version` varchar(36) DEFAULT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `frozen` tinyint(1) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `services_uuid_idx` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone`, `disabled_reason`, `modified_at`, `rpc_current_version`, `object_current_version`, `replication_status`, `frozen`, `active_backend_id`, `cluster_name`, `uuid`) VALUES ('2025-11-29 06:55:48','2025-11-29 09:13:25',NULL,0,1,'cinder-scheduler-0','cinder-scheduler','cinder-scheduler',821,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'5470ff40-ea16-4c63-a0fc-53bbc7e1cb1d'),('2025-11-29 07:44:40','2025-11-29 09:13:23',NULL,0,2,'cinder-backup-0','cinder-backup','cinder-backup',532,0,'nova',NULL,NULL,'2.4','1.39','not-capable',0,NULL,NULL,'119bb385-dcd4-406a-855b-b047e9e6aa40'),('2025-11-29 07:44:41','2025-11-29 09:13:27',NULL,0,3,'hostgroup@ceph','cinder-volume','cinder-volume',532,0,'nova',NULL,NULL,'3.18','1.39','disabled',0,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot_metadata`
--

DROP TABLE IF EXISTS `snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshot_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `snapshot_metadata_ibfk_1` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot_metadata`
--

LOCK TABLES `snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `snapshot_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshots`
--

DROP TABLE IF EXISTS `snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `volume_size` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `provider_auth` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshots_cgsnapshot_id` (`cgsnapshot_id`),
  KEY `ix_snapshots_volume_id` (`volume_id`),
  KEY `ix_snapshots_group_snapshot_id` (`group_snapshot_id`),
  KEY `snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `snapshots_ibfk_1` FOREIGN KEY (`cgsnapshot_id`) REFERENCES `cgsnapshots` (`id`),
  CONSTRAINT `snapshots_ibfk_2` FOREIGN KEY (`group_snapshot_id`) REFERENCES `group_snapshots` (`id`),
  CONSTRAINT `snapshots_volume_id_fkey` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshots`
--

LOCK TABLES `snapshots` WRITE;
/*!40000 ALTER TABLE `snapshots` DISABLE KEYS */;
INSERT INTO `snapshots` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `status`, `progress`, `volume_size`, `scheduled_at`, `display_name`, `display_description`, `provider_location`, `encryption_key_id`, `volume_type_id`, `cgsnapshot_id`, `provider_id`, `provider_auth`, `group_snapshot_id`, `use_quota`) VALUES ('2025-11-29 08:41:06','2025-11-29 08:41:07','2025-11-29 08:41:09',1,'00e5000c-fd30-466d-8cd4-ec94da7bb598','ffeeb721-db06-432c-a16d-7bfb047e02d3','24c3267183e24e99bbb30a96656a36e7','89fad883285a4255b3b35c445f93c900','deleted','100%',1,NULL,'tempest-VolumesSnapshotsTestJSON-Snapshot-735525820',NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,NULL,NULL,NULL,1),('2025-11-29 08:36:55','2025-11-29 08:37:16','2025-11-29 08:37:17',1,'5c204d24-3577-4a22-8731-f84202e1cc58','d0fba77f-63fd-4100-a2fb-b81bfa4b659a','e8b20745b2d14f70b64a43335faed2f4','8d5e30b74e6449dd90ecb667977d1fe9','deleted','100%',1,NULL,'tempest-TestMinimumBasicScenario-snapshot-517880302',NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,NULL,NULL,NULL,1),('2025-11-29 08:47:14','2025-11-29 08:47:37','2025-11-29 08:47:38',1,'91a127b9-1cd6-49a6-97a2-a9c44bf2b597','57f207d9-b8b7-4e93-8117-125577facc2e','b576a51181b5425aa6e44a0eb0a22803','b7ffcb23bac14ee49474df9aee5f7dae','deleted','100%',1,NULL,'tempest-TestVolumeBootPattern-snapshot-1226018042',NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,NULL,NULL,NULL,1),('2025-11-29 08:44:22','2025-11-29 08:45:37','2025-11-29 08:45:38',1,'bffe82e5-41b8-4236-9ff9-21b5e39f73ac','9aa47c29-8250-4a09-aa5f-08b05b14f1c9','01c0b956e2c74d5798d01fc2be0a8bac','3b3b0484057a4e3db51366d29c6b684d','deleted','100%',1,NULL,'tempest-TestStampPattern-snapshot-790481536',NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,NULL,NULL,NULL,1),('2025-11-29 08:51:41','2025-11-29 08:52:53','2025-11-29 08:52:54',1,'d898cedb-1577-453e-a5a3-56529a2d305a','10605c29-d705-4bde-bb14-15733badfd18','b576a51181b5425aa6e44a0eb0a22803','b7ffcb23bac14ee49474df9aee5f7dae','deleted','100%',1,NULL,'tempest-TestVolumeBootPattern-snapshot-1447595525',NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,NULL,NULL,NULL,1),('2025-11-29 08:48:43','2025-11-29 08:49:42','2025-11-29 08:49:43',1,'efcdc2f4-6579-4824-ad08-d6752dc23fc5','bf7e0110-334f-4129-a24d-43eb68f20833','b576a51181b5425aa6e44a0eb0a22803','b7ffcb23bac14ee49474df9aee5f7dae','deleted','100%',1,NULL,'snapshot for tempest-TestVolumeBootPatternsnapshot-481397479',NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,NULL,NULL,NULL,1),('2025-11-29 08:35:11','2025-11-29 08:35:18','2025-11-29 08:35:18',1,'f1b378b6-b3b7-477d-8029-338c3783f767','9b4f6e7c-11e4-4465-94bc-84c3365ec3b9','c5b0953fb7cc415fb26cf4ffdd5908c6','d4f6db81949d487b853d7567f8a2e6d4','deleted','100%',1,NULL,'snapshot for multiattach-snapshot',NULL,NULL,NULL,'693bd8a6-9594-46ee-8a11-532b65e85c26',NULL,NULL,NULL,NULL,1);
/*!40000 ALTER TABLE `snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `no_snapshots` tinyint(1) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_transfers_volume_id` (`volume_id`),
  CONSTRAINT `transfers_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_admin_metadata`
--

DROP TABLE IF EXISTS `volume_admin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_admin_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_admin_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_admin_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_admin_metadata`
--

LOCK TABLES `volume_admin_metadata` WRITE;
/*!40000 ALTER TABLE `volume_admin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_admin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_attachment`
--

DROP TABLE IF EXISTS `volume_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_attachment` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `attached_host` varchar(255) DEFAULT NULL,
  `instance_uuid` varchar(36) DEFAULT NULL,
  `mountpoint` varchar(255) DEFAULT NULL,
  `attach_time` datetime DEFAULT NULL,
  `detach_time` datetime DEFAULT NULL,
  `attach_mode` varchar(36) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `connection_info` text DEFAULT NULL,
  `connector` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_attachment_volume_id` (`volume_id`),
  CONSTRAINT `volume_attachment_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_attachment`
--

LOCK TABLES `volume_attachment` WRITE;
/*!40000 ALTER TABLE `volume_attachment` DISABLE KEYS */;
INSERT INTO `volume_attachment` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `attached_host`, `instance_uuid`, `mountpoint`, `attach_time`, `detach_time`, `attach_mode`, `attach_status`, `connection_info`, `connector`) VALUES ('2025-11-29 08:31:26','2025-11-29 08:35:41','2025-11-29 08:35:41',1,'06c20c1d-fb1e-4003-92cc-86c5030635df','6d9d34fb-9df6-452a-837f-86dd8a2bf2ba','compute-1.ctlplane.example.com','b08df6d7-85bd-4c2a-9bd8-f37384b9148a','/dev/vda','2025-11-29 08:31:29','2025-11-29 08:35:41','rw','detached','{\"name\": \"volumes/volume-6d9d34fb-9df6-452a-837f-86dd8a2bf2ba\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"6d9d34fb-9df6-452a-837f-86dd8a2bf2ba\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"06c20c1d-fb1e-4003-92cc-86c5030635df\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34268feecb6\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2d58586e-4ce1-425d-890c-d5cdff75e822\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 07:54:18','2025-11-29 07:55:08','2025-11-29 07:55:08',1,'086dffa8-4128-4c55-89ad-f4a779ee7ea0','e52d8ac1-8970-4cf0-9aa0-795f616090d0','compute-2.ctlplane.example.com','56f3f72f-7db4-47c8-a4c3-20b2acc58aa9','/dev/vda','2025-11-29 07:54:24','2025-11-29 07:55:08','rw','detached','{\"name\": \"volumes/volume-e52d8ac1-8970-4cf0-9aa0-795f616090d0\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"e52d8ac1-8970-4cf0-9aa0-795f616090d0\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"086dffa8-4128-4c55-89ad-f4a779ee7ea0\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0e73df9328\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"6fbde64a-d978-4f1a-a29d-a77e1f5a1987\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:15:59','2025-11-29 08:16:15','2025-11-29 08:16:15',1,'0c268691-38c6-4db8-ae8c-00bc3286be2e','eb8b2675-ae0e-4130-a3f5-06bcfedbadc6','compute-0.ctlplane.example.com','886e1d81-4445-45c7-8c0a-4838eb595ab1','/dev/vdb','2025-11-29 08:16:05','2025-11-29 08:16:15','rw','detached','{\"name\": \"volumes/volume-eb8b2675-ae0e-4130-a3f5-06bcfedbadc6\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"eb8b2675-ae0e-4130-a3f5-06bcfedbadc6\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"0c268691-38c6-4db8-ae8c-00bc3286be2e\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:babbd27d8a8\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9851e351-ef5d-4a0c-9f85-d561f6a4210f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:34:12','2025-11-29 08:34:49','2025-11-29 08:34:49',1,'0d15bfbf-e33d-40d1-af8b-67b699bb5dc6','d51465d5-c782-4ab5-86e5-16500d7ed93e','compute-0.ctlplane.example.com','f6eba09a-c0cf-4855-afd5-b265b2f2cadc','/dev/vdb','2025-11-29 08:34:18','2025-11-29 08:34:49','rw','detached','{\"name\": \"volumes/volume-d51465d5-c782-4ab5-86e5-16500d7ed93e\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"d51465d5-c782-4ab5-86e5-16500d7ed93e\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"0d15bfbf-e33d-40d1-af8b-67b699bb5dc6\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:babbd27d8a8\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9851e351-ef5d-4a0c-9f85-d561f6a4210f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:51:54','2025-11-29 08:52:50','2025-11-29 08:52:50',1,'0f9405e6-f520-48b3-a6cb-d5f56827c6b9','fee77070-ed28-42d2-8e57-eb8da81862b4','compute-1.ctlplane.example.com','1a52df6e-2dba-41dc-bbcf-68954705ed0a','/dev/vda','2025-11-29 08:52:00','2025-11-29 08:52:50','rw','detached','{\"name\": \"volumes/volume-fee77070-ed28-42d2-8e57-eb8da81862b4\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"fee77070-ed28-42d2-8e57-eb8da81862b4\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"0f9405e6-f520-48b3-a6cb-d5f56827c6b9\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34268feecb6\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2d58586e-4ce1-425d-890c-d5cdff75e822\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:01:14','2025-11-29 08:01:54','2025-11-29 08:01:54',1,'0f9a3feb-8acf-4b8a-b367-d540f943835b','cda8bfe0-3a4d-4d07-beb1-adb73b629321','compute-2.ctlplane.example.com','beda6e02-cb4c-4daf-aefc-0081df73a5c0','/dev/vda','2025-11-29 08:01:19','2025-11-29 08:01:54','rw','detached','{\"name\": \"volumes/volume-cda8bfe0-3a4d-4d07-beb1-adb73b629321\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"cda8bfe0-3a4d-4d07-beb1-adb73b629321\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"0f9a3feb-8acf-4b8a-b367-d540f943835b\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0e73df9328\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"6fbde64a-d978-4f1a-a29d-a77e1f5a1987\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 07:54:44','2025-11-29 07:55:09','2025-11-29 07:55:09',1,'0fdf73ae-cbdf-4670-b55b-bd9dfb3efb32','3ef07b78-0409-49cf-a941-8a19b02dd939','compute-0.ctlplane.example.com','7067462a-37a6-458e-b96c-76adcea5fdfa','/dev/vda','2025-11-29 07:54:44','2025-11-29 07:55:09','null','detached','{\"name\": \"volumes/volume-3ef07b78-0409-49cf-a941-8a19b02dd939\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"3ef07b78-0409-49cf-a941-8a19b02dd939\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"0fdf73ae-cbdf-4670-b55b-bd9dfb3efb32\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:babbd27d8a8\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9851e351-ef5d-4a0c-9f85-d561f6a4210f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2025-11-29 08:33:13','2025-11-29 08:33:31','2025-11-29 08:33:31',1,'1634e0ac-a969-4eaf-8b49-e4304a7b066e','d51465d5-c782-4ab5-86e5-16500d7ed93e','compute-2.ctlplane.example.com','8effb5bc-4bb3-46de-82ab-c8a7a7da2c4a','/dev/vdb','2025-11-29 08:33:14','2025-11-29 08:33:31','rw','detached','{\"name\": \"volumes/volume-d51465d5-c782-4ab5-86e5-16500d7ed93e\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"d51465d5-c782-4ab5-86e5-16500d7ed93e\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"1634e0ac-a969-4eaf-8b49-e4304a7b066e\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0e73df9328\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"6fbde64a-d978-4f1a-a29d-a77e1f5a1987\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:40:13','2025-11-29 08:40:41','2025-11-29 08:40:41',1,'21c590f0-94de-4352-b9d7-f49bae8239c5','86e515f3-ecb8-4e58-99f6-23e4d8ee3e76','compute-0.ctlplane.example.com','db9a33b0-f745-4457-b7a6-d22017777a85','/dev/vdc','2025-11-29 08:40:16','2025-11-29 08:40:41','rw','detached','{\"name\": \"volumes/volume-86e515f3-ecb8-4e58-99f6-23e4d8ee3e76\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"86e515f3-ecb8-4e58-99f6-23e4d8ee3e76\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"21c590f0-94de-4352-b9d7-f49bae8239c5\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:babbd27d8a8\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9851e351-ef5d-4a0c-9f85-d561f6a4210f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-11-29 08:38:20','2025-11-29 08:38:23','2025-11-29 08:38:23',1,'25d43d9c-1ef7-40b5-b1d7-69efabe2ceb4','ce79c491-0b98-4186-bc37-6c4796c913e1','compute-0.ctlplane.example.com','850e472c-8d49-4ecb-8478-992f11eb6196','/dev/vdb','2025-11-29 08:38:21','2025-11-29 08:38:23','rw','detached','{\"name\": \"volumes/volume-ce79c491-0b98-4186-bc37-6c4796c913e1\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"ce79c491-0b98-4186-bc37-6c4796c913e1\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"25d43d9c-1ef7-40b5-b1d7-69efabe2ceb4\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:babbd27d8a8\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9851e351-ef5d-4a0c-9f85-d561f6a4210f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 07:58:28','2025-11-29 07:58:37','2025-11-29 07:58:37',1,'2d220b09-0115-442f-b476-72c5d1b50475','ad8203ea-9ab4-445c-8faf-cf62075ec75c','compute-2.ctlplane.example.com','8b9831df-d3ee-436b-af4e-ad429c1c0227','/dev/sdc','2025-11-29 07:58:29','2025-11-29 07:58:37','rw','detached','{\"name\": \"volumes/volume-ad8203ea-9ab4-445c-8faf-cf62075ec75c\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"ad8203ea-9ab4-445c-8faf-cf62075ec75c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"2d220b09-0115-442f-b476-72c5d1b50475\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0e73df9328\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"6fbde64a-d978-4f1a-a29d-a77e1f5a1987\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/sdc\"}'),('2025-11-29 08:46:29','2025-11-29 08:47:00','2025-11-29 08:47:00',1,'3b199221-236b-4e10-a8d7-4a286122c5ad','3f901e23-17b3-4b75-8f9b-33496e3b8402','compute-1.ctlplane.example.com','9db49dc0-dfcc-4700-a0ff-de58bff013ee','/dev/vda','2025-11-29 08:46:39','2025-11-29 08:47:00','rw','detached','{\"name\": \"volumes/volume-3f901e23-17b3-4b75-8f9b-33496e3b8402\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"3f901e23-17b3-4b75-8f9b-33496e3b8402\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": true, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"3b199221-236b-4e10-a8d7-4a286122c5ad\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34268feecb6\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2d58586e-4ce1-425d-890c-d5cdff75e822\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:39:20','2025-11-29 08:41:30','2025-11-29 08:41:30',1,'3b30ba89-b316-4aa5-bdad-bc6b3c4d20bb','36eafc77-7bfd-44e7-b2f9-bca3cee5c1b3','compute-2.ctlplane.example.com','ee3de57a-2652-4819-880a-6217c00a67a0','/dev/vda','2025-11-29 08:39:23','2025-11-29 08:41:30','rw','detached','{\"name\": \"volumes/volume-36eafc77-7bfd-44e7-b2f9-bca3cee5c1b3\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"36eafc77-7bfd-44e7-b2f9-bca3cee5c1b3\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"3b30ba89-b316-4aa5-bdad-bc6b3c4d20bb\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0e73df9328\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"6fbde64a-d978-4f1a-a29d-a77e1f5a1987\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:39:59','2025-11-29 08:40:00','2025-11-29 08:40:00',1,'402b4ee2-83f1-4e28-9496-bc9b763d9b5f','68efac4f-4452-463d-99e0-c6f94bc84f27',NULL,'78534f04-30a6-4f58-9768-091f48082c9c',NULL,NULL,'2025-11-29 08:40:00','null','detached','{}',NULL),('2025-11-29 08:16:23','2025-11-29 08:17:47','2025-11-29 08:17:47',1,'49cf7d42-57e3-4052-bb5a-bbc8ab6da5bd','618924f8-fe57-45de-85ec-593336349be7','compute-2.ctlplane.example.com','ad6070e8-74bc-4df7-9c2d-5da5da175238','/dev/vda','2025-11-29 08:16:31','2025-11-29 08:17:47','rw','detached','{\"name\": \"volumes/volume-618924f8-fe57-45de-85ec-593336349be7\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"618924f8-fe57-45de-85ec-593336349be7\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"49cf7d42-57e3-4052-bb5a-bbc8ab6da5bd\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0e73df9328\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"6fbde64a-d978-4f1a-a29d-a77e1f5a1987\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:37:13','2025-11-29 08:37:17','2025-11-29 08:37:17',1,'4c453f0f-2349-4554-a07a-8bc29d94a754','a8b37ad1-e3f2-474d-a8f9-2676f112a82c','compute-2.ctlplane.example.com','9722353e-1f13-4d75-97a7-9b251f9385a6','/dev/vdb','2025-11-29 08:37:14','2025-11-29 08:37:17','rw','detached','{\"name\": \"volumes/volume-a8b37ad1-e3f2-474d-a8f9-2676f112a82c\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"a8b37ad1-e3f2-474d-a8f9-2676f112a82c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"4c453f0f-2349-4554-a07a-8bc29d94a754\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0e73df9328\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"6fbde64a-d978-4f1a-a29d-a77e1f5a1987\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:47:25','2025-11-29 08:47:35','2025-11-29 08:47:35',1,'4db65d67-6002-43a1-b283-b01500d0ded7','04876073-8d9f-4092-96a1-ca8b66cb7194','compute-0.ctlplane.example.com','914862a1-ed26-42cf-a984-a50e43676d80','/dev/vda','2025-11-29 08:47:26','2025-11-29 08:47:35','rw','detached','{\"name\": \"volumes/volume-04876073-8d9f-4092-96a1-ca8b66cb7194\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"04876073-8d9f-4092-96a1-ca8b66cb7194\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"4db65d67-6002-43a1-b283-b01500d0ded7\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:babbd27d8a8\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9851e351-ef5d-4a0c-9f85-d561f6a4210f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:49:36','2025-11-29 08:50:28','2025-11-29 08:50:28',1,'50ac5631-c875-4dcf-b755-17af20132ed1','77422021-a8a1-4df0-9b4a-24ac0dd34ac3','compute-0.ctlplane.example.com','e82bbbb4-4776-445f-9d1d-aea28fbbcaa8','/dev/vda','2025-11-29 08:49:44','2025-11-29 08:50:28','rw','detached','{\"name\": \"volumes/volume-77422021-a8a1-4df0-9b4a-24ac0dd34ac3\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"77422021-a8a1-4df0-9b4a-24ac0dd34ac3\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"50ac5631-c875-4dcf-b755-17af20132ed1\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:babbd27d8a8\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9851e351-ef5d-4a0c-9f85-d561f6a4210f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:35:26','2025-11-29 08:36:13','2025-11-29 08:36:13',1,'5353f30b-066b-4573-9b2e-963b5db7f711','2f39efc2-fe1b-41a9-96e3-2aca65cf0fa6','compute-2.ctlplane.example.com','ce8d0714-58a3-470e-bd4e-056510ea90cd','/dev/vdb','2025-11-29 08:35:27','2025-11-29 08:36:13','rw','detached','{\"name\": \"volumes/volume-2f39efc2-fe1b-41a9-96e3-2aca65cf0fa6\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"2f39efc2-fe1b-41a9-96e3-2aca65cf0fa6\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"5353f30b-066b-4573-9b2e-963b5db7f711\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0e73df9328\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"6fbde64a-d978-4f1a-a29d-a77e1f5a1987\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:39:23','2025-11-29 08:41:26','2025-11-29 08:41:26',1,'59489c41-ae26-4b9a-acce-f2bc534e63ad','bd3bcc0c-33d5-4f56-93b8-0804e2446b99','compute-0.ctlplane.example.com','db9a33b0-f745-4457-b7a6-d22017777a85','/dev/vda','2025-11-29 08:39:27','2025-11-29 08:41:26','rw','detached','{\"name\": \"volumes/volume-bd3bcc0c-33d5-4f56-93b8-0804e2446b99\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"bd3bcc0c-33d5-4f56-93b8-0804e2446b99\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"59489c41-ae26-4b9a-acce-f2bc534e63ad\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:babbd27d8a8\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9851e351-ef5d-4a0c-9f85-d561f6a4210f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:32:18','2025-11-29 08:32:25','2025-11-29 08:32:25',1,'5cb6545a-cf46-4ce4-a6e9-76f83d9bbc0b','6273512e-203d-43b7-bb2f-a59b9ff4579f','compute-1.ctlplane.example.com','2293bfb9-d91d-4ee4-8347-317cf45fe9c4','/dev/vdb','2025-11-29 08:32:19','2025-11-29 08:32:25','rw','detached','{\"name\": \"volumes/volume-6273512e-203d-43b7-bb2f-a59b9ff4579f\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"6273512e-203d-43b7-bb2f-a59b9ff4579f\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"5cb6545a-cf46-4ce4-a6e9-76f83d9bbc0b\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34268feecb6\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2d58586e-4ce1-425d-890c-d5cdff75e822\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:50:07','2025-11-29 08:50:45','2025-11-29 08:50:45',1,'5f8fbb9c-5917-40c5-9633-0019669722aa','10605c29-d705-4bde-bb14-15733badfd18','compute-1.ctlplane.example.com','8a308fe2-114e-4322-b527-1dab59c053bb','/dev/vda','2025-11-29 08:50:10','2025-11-29 08:50:45','rw','detached','{\"name\": \"volumes/volume-10605c29-d705-4bde-bb14-15733badfd18\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"10605c29-d705-4bde-bb14-15733badfd18\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"5f8fbb9c-5917-40c5-9633-0019669722aa\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34268feecb6\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2d58586e-4ce1-425d-890c-d5cdff75e822\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:02:21','2025-11-29 08:02:46','2025-11-29 08:02:46',1,'62398f19-0495-4be0-ad68-f9072905252a','87f35256-d25d-497d-b09f-e847b4302174','compute-1.ctlplane.example.com','b8808203-6263-4e9c-bff5-7d273d143a50','/dev/vdb','2025-11-29 08:02:27','2025-11-29 08:02:46','rw','detached','{\"name\": \"volumes/volume-87f35256-d25d-497d-b09f-e847b4302174\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"87f35256-d25d-497d-b09f-e847b4302174\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"62398f19-0495-4be0-ad68-f9072905252a\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34268feecb6\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2d58586e-4ce1-425d-890c-d5cdff75e822\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 07:50:58','2025-11-29 07:51:22','2025-11-29 07:51:22',1,'6789a472-0c8b-4120-be8e-baa2a31a12f5','e9658287-11e8-4a83-a391-d9089e1d2337','compute-0.ctlplane.example.com','65be1187-6d11-4752-8ae6-ba034b77b9e0','/dev/vdb','2025-11-29 07:51:05','2025-11-29 07:51:22','rw','detached','{\"name\": \"volumes/volume-e9658287-11e8-4a83-a391-d9089e1d2337\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"e9658287-11e8-4a83-a391-d9089e1d2337\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"6789a472-0c8b-4120-be8e-baa2a31a12f5\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:babbd27d8a8\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9851e351-ef5d-4a0c-9f85-d561f6a4210f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:02:33','2025-11-29 08:02:43','2025-11-29 08:02:43',1,'6a2615ee-4955-44e0-9406-eaf56d9c5b4b','87f35256-d25d-497d-b09f-e847b4302174','compute-0.ctlplane.example.com','28e30c6c-30cb-4da9-9f29-a5195810cc1b','/dev/vdb','2025-11-29 08:02:36','2025-11-29 08:02:43','rw','detached','{\"name\": \"volumes/volume-87f35256-d25d-497d-b09f-e847b4302174\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"87f35256-d25d-497d-b09f-e847b4302174\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"6a2615ee-4955-44e0-9406-eaf56d9c5b4b\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:babbd27d8a8\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9851e351-ef5d-4a0c-9f85-d561f6a4210f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:20:00','2025-11-29 08:20:49','2025-11-29 08:20:49',1,'6bfc9ef9-9a14-4c36-895a-b788a0f55342','85297db0-ac85-44d1-bc74-6e4a332ee974','compute-1.ctlplane.example.com','a14ca685-ed5c-4583-90e2-565fbf5e1ef0','/dev/vda','2025-11-29 08:20:09','2025-11-29 08:20:49','rw','detached','{\"name\": \"volumes/volume-85297db0-ac85-44d1-bc74-6e4a332ee974\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"85297db0-ac85-44d1-bc74-6e4a332ee974\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"6bfc9ef9-9a14-4c36-895a-b788a0f55342\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34268feecb6\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2d58586e-4ce1-425d-890c-d5cdff75e822\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:40:49','2025-11-29 08:41:07','2025-11-29 08:41:07',1,'6d6d1383-e6ad-4623-a2e8-37a1d85b5465','ddbdab48-23f2-48fc-bdd4-33793fe5d282','compute-1.ctlplane.example.com','fc75971c-cf7e-4383-81cf-81c801f67489','/dev/vdb','2025-11-29 08:40:50','2025-11-29 08:41:07','rw','detached','{\"name\": \"volumes/volume-ddbdab48-23f2-48fc-bdd4-33793fe5d282\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"ddbdab48-23f2-48fc-bdd4-33793fe5d282\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"6d6d1383-e6ad-4623-a2e8-37a1d85b5465\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34268feecb6\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2d58586e-4ce1-425d-890c-d5cdff75e822\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 07:54:18','2025-11-29 07:54:50','2025-11-29 07:54:50',1,'73064fe3-3d3a-4388-bf17-21bd966882ad','3ef07b78-0409-49cf-a941-8a19b02dd939','compute-2.ctlplane.example.com','7067462a-37a6-458e-b96c-76adcea5fdfa','/dev/vda','2025-11-29 07:54:24','2025-11-29 07:54:50','rw','detached','{\"name\": \"volumes/volume-3ef07b78-0409-49cf-a941-8a19b02dd939\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"3ef07b78-0409-49cf-a941-8a19b02dd939\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"73064fe3-3d3a-4388-bf17-21bd966882ad\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0e73df9328\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"6fbde64a-d978-4f1a-a29d-a77e1f5a1987\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:35:03','2025-11-29 08:35:16','2025-11-29 08:35:16',1,'74a6cac2-6e82-4f8d-982b-70fe8a55fe6a','9b4f6e7c-11e4-4465-94bc-84c3365ec3b9','compute-0.ctlplane.example.com','8aee8cc7-7ff1-451b-88f4-7804819fc2b2','/dev/vda','2025-11-29 08:35:05','2025-11-29 08:35:16','rw','detached','{\"name\": \"volumes/volume-9b4f6e7c-11e4-4465-94bc-84c3365ec3b9\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"9b4f6e7c-11e4-4465-94bc-84c3365ec3b9\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"74a6cac2-6e82-4f8d-982b-70fe8a55fe6a\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:babbd27d8a8\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9851e351-ef5d-4a0c-9f85-d561f6a4210f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:42:36','2025-11-29 08:42:44','2025-11-29 08:42:44',1,'783ed1d0-0137-422c-8723-899faeb6c232','12074156-11fd-4503-8e66-ac1cd1f8e83a','compute-0.ctlplane.example.com','60d1a5dc-0c2d-4d8d-8833-f51c3497bcbe','/dev/vdb','2025-11-29 08:42:38','2025-11-29 08:42:44','rw','detached','{\"name\": \"volumes/volume-12074156-11fd-4503-8e66-ac1cd1f8e83a\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"12074156-11fd-4503-8e66-ac1cd1f8e83a\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": true, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"783ed1d0-0137-422c-8723-899faeb6c232\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:babbd27d8a8\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9851e351-ef5d-4a0c-9f85-d561f6a4210f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:33:56','2025-11-29 08:34:03','2025-11-29 08:34:03',1,'7a734bd1-604a-4cf3-87e6-114a00ac2e25','371e8431-582d-4b80-9978-50a1e275178d','compute-2.ctlplane.example.com','64f6896c-17f2-4ceb-98b9-50a541c98b7b','/dev/vdc','2025-11-29 08:33:58','2025-11-29 08:34:03','rw','detached','{\"name\": \"volumes/volume-371e8431-582d-4b80-9978-50a1e275178d\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"371e8431-582d-4b80-9978-50a1e275178d\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"7a734bd1-604a-4cf3-87e6-114a00ac2e25\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0e73df9328\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"6fbde64a-d978-4f1a-a29d-a77e1f5a1987\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-11-29 08:24:37','2025-11-29 08:25:14','2025-11-29 08:25:14',1,'7c339ab5-eb8a-44ea-b6fd-0808065b0014','d807030f-7b93-4396-9211-17a740c6b338','compute-2.ctlplane.example.com','2e7e8742-c504-412d-82cf-4087bd745c3e','/dev/vda','2025-11-29 08:24:42','2025-11-29 08:25:14','rw','detached','{\"name\": \"volumes/volume-d807030f-7b93-4396-9211-17a740c6b338\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"d807030f-7b93-4396-9211-17a740c6b338\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"7c339ab5-eb8a-44ea-b6fd-0808065b0014\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0e73df9328\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"6fbde64a-d978-4f1a-a29d-a77e1f5a1987\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:16:24','2025-11-29 08:17:47','2025-11-29 08:17:47',1,'87251777-4c3d-4b32-b1b1-ffbc41a78285','414e4eae-2565-42a3-bb35-fdd1ef6e127f','compute-2.ctlplane.example.com','ad6070e8-74bc-4df7-9c2d-5da5da175238','/dev/vdc','2025-11-29 08:16:35','2025-11-29 08:17:47','rw','detached','{\"name\": \"volumes/volume-414e4eae-2565-42a3-bb35-fdd1ef6e127f\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"414e4eae-2565-42a3-bb35-fdd1ef6e127f\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"87251777-4c3d-4b32-b1b1-ffbc41a78285\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0e73df9328\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"6fbde64a-d978-4f1a-a29d-a77e1f5a1987\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-11-29 08:27:59','2025-11-29 08:28:43','2025-11-29 08:28:43',1,'8ad5f0ac-9742-4cba-86de-0a554ab0d172','213d91c6-0ee8-47c3-965c-92c80077e9ee','compute-2.ctlplane.example.com','d6363749-92b8-41e7-860c-63dc695390e4','/dev/vdb','2025-11-29 08:28:00','2025-11-29 08:28:43','rw','detached','{\"name\": \"volumes/volume-213d91c6-0ee8-47c3-965c-92c80077e9ee\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"213d91c6-0ee8-47c3-965c-92c80077e9ee\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"8ad5f0ac-9742-4cba-86de-0a554ab0d172\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0e73df9328\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"6fbde64a-d978-4f1a-a29d-a77e1f5a1987\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:15:42','2025-11-29 08:15:59','2025-11-29 08:15:59',1,'8fdcea1d-3748-4c96-b67d-221e641e9f2c','eb8b2675-ae0e-4130-a3f5-06bcfedbadc6','compute-0.ctlplane.example.com','886e1d81-4445-45c7-8c0a-4838eb595ab1','/dev/vdb','2025-11-29 08:15:44','2025-11-29 08:15:59','rw','detached','{\"name\": \"volumes/volume-eb8b2675-ae0e-4130-a3f5-06bcfedbadc6\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"eb8b2675-ae0e-4130-a3f5-06bcfedbadc6\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"8fdcea1d-3748-4c96-b67d-221e641e9f2c\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:babbd27d8a8\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9851e351-ef5d-4a0c-9f85-d561f6a4210f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:40:10','2025-11-29 08:40:37','2025-11-29 08:40:37',1,'9097190e-f4e8-4b35-a7f2-734d36d4a64a','8bde7127-007c-4f43-9a60-267c3b300611','compute-0.ctlplane.example.com','db9a33b0-f745-4457-b7a6-d22017777a85','/dev/vdb','2025-11-29 08:40:11','2025-11-29 08:40:37','rw','detached','{\"name\": \"volumes/volume-8bde7127-007c-4f43-9a60-267c3b300611\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"8bde7127-007c-4f43-9a60-267c3b300611\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"9097190e-f4e8-4b35-a7f2-734d36d4a64a\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:babbd27d8a8\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9851e351-ef5d-4a0c-9f85-d561f6a4210f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:33:50','2025-11-29 08:34:02','2025-11-29 08:34:02',1,'90c7fc65-fd53-40da-9002-ead00ac629f3','b180584d-b262-44fa-b3d3-a5cae1efac78','compute-2.ctlplane.example.com','64f6896c-17f2-4ceb-98b9-50a541c98b7b','/dev/vdb','2025-11-29 08:33:52','2025-11-29 08:34:02','rw','detached','{\"name\": \"volumes/volume-b180584d-b262-44fa-b3d3-a5cae1efac78\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"b180584d-b262-44fa-b3d3-a5cae1efac78\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"90c7fc65-fd53-40da-9002-ead00ac629f3\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0e73df9328\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"6fbde64a-d978-4f1a-a29d-a77e1f5a1987\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 07:53:18','2025-11-29 07:53:23','2025-11-29 07:53:23',1,'96e6bae3-ab2a-4445-adb3-d5c7a0dfa7b0','8da13aec-bfc8-4fe1-b17e-45f2a3f532cf','compute-0.ctlplane.example.com','3fde18f7-843a-48d8-b394-c299cf479c37','/dev/vdb','2025-11-29 07:53:19','2025-11-29 07:53:23','rw','detached','{\"name\": \"volumes/volume-8da13aec-bfc8-4fe1-b17e-45f2a3f532cf\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"8da13aec-bfc8-4fe1-b17e-45f2a3f532cf\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"96e6bae3-ab2a-4445-adb3-d5c7a0dfa7b0\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:babbd27d8a8\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9851e351-ef5d-4a0c-9f85-d561f6a4210f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:36:52','2025-11-29 08:38:04','2025-11-29 08:38:04',1,'9a45bbc0-d369-4b28-b260-27c4a5e2d9ea','d0fba77f-63fd-4100-a2fb-b81bfa4b659a','compute-1.ctlplane.example.com','1f01c882-bb44-4ba5-b82f-e3ffa31b8df1','/dev/vdb','2025-11-29 08:36:53','2025-11-29 08:38:04','rw','detached','{\"name\": \"volumes/volume-d0fba77f-63fd-4100-a2fb-b81bfa4b659a\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"d0fba77f-63fd-4100-a2fb-b81bfa4b659a\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"9a45bbc0-d369-4b28-b260-27c4a5e2d9ea\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34268feecb6\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2d58586e-4ce1-425d-890c-d5cdff75e822\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:39:33','2025-11-29 08:39:58','2025-11-29 08:39:58',1,'9adbbac5-c417-4c86-b7b6-2d408e80ef7a','35daf555-cff7-4c13-98d4-8c31451470ee','compute-2.ctlplane.example.com','ee3de57a-2652-4819-880a-6217c00a67a0','/dev/vdb','2025-11-29 08:39:34','2025-11-29 08:39:58','rw','detached','{\"name\": \"volumes/volume-35daf555-cff7-4c13-98d4-8c31451470ee\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"35daf555-cff7-4c13-98d4-8c31451470ee\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"9adbbac5-c417-4c86-b7b6-2d408e80ef7a\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0e73df9328\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"6fbde64a-d978-4f1a-a29d-a77e1f5a1987\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:38:18','2025-11-29 08:38:54','2025-11-29 08:38:54',1,'a1863a6a-f772-48e4-ba02-325f54dbdba8','d6f82ad4-8ec0-4138-9a4b-77fdefc17bbd','compute-0.ctlplane.example.com','5748313e-fbb3-409e-83e6-aff548491530','/dev/vdc','2025-11-29 08:38:22','2025-11-29 08:38:54','rw','detached','{\"name\": \"volumes/volume-d6f82ad4-8ec0-4138-9a4b-77fdefc17bbd\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"d6f82ad4-8ec0-4138-9a4b-77fdefc17bbd\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"a1863a6a-f772-48e4-ba02-325f54dbdba8\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:babbd27d8a8\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9851e351-ef5d-4a0c-9f85-d561f6a4210f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-11-29 08:33:30','2025-11-29 08:34:47','2025-11-29 08:34:47',1,'a25ffe8f-9aa7-43d7-a806-07b7934cc3c4','d51465d5-c782-4ab5-86e5-16500d7ed93e','compute-0.ctlplane.example.com','8effb5bc-4bb3-46de-82ab-c8a7a7da2c4a','/dev/vdb','2025-11-29 08:33:36','2025-11-29 08:34:47','rw','detached','{\"name\": \"volumes/volume-d51465d5-c782-4ab5-86e5-16500d7ed93e\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"d51465d5-c782-4ab5-86e5-16500d7ed93e\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"a25ffe8f-9aa7-43d7-a806-07b7934cc3c4\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:babbd27d8a8\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9851e351-ef5d-4a0c-9f85-d561f6a4210f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:32:15','2025-11-29 08:32:22','2025-11-29 08:32:22',1,'a720945f-bc54-4053-b932-cb4f783c48ff','6273512e-203d-43b7-bb2f-a59b9ff4579f','compute-0.ctlplane.example.com','1509e19f-b5e6-496d-a0d9-d6740970fad0','/dev/vdb','2025-11-29 08:32:16','2025-11-29 08:32:22','rw','detached','{\"name\": \"volumes/volume-6273512e-203d-43b7-bb2f-a59b9ff4579f\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"6273512e-203d-43b7-bb2f-a59b9ff4579f\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"a720945f-bc54-4053-b932-cb4f783c48ff\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:babbd27d8a8\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9851e351-ef5d-4a0c-9f85-d561f6a4210f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:39:26','2025-11-29 08:41:23','2025-11-29 08:41:23',1,'a7b29211-f924-4277-ac59-60f674168cc5','c9cf1b4f-d920-4673-b1fc-8c791f56541b','compute-1.ctlplane.example.com','fc75971c-cf7e-4383-81cf-81c801f67489','/dev/vda','2025-11-29 08:39:29','2025-11-29 08:41:23','rw','detached','{\"name\": \"volumes/volume-c9cf1b4f-d920-4673-b1fc-8c791f56541b\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"c9cf1b4f-d920-4673-b1fc-8c791f56541b\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"a7b29211-f924-4277-ac59-60f674168cc5\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34268feecb6\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2d58586e-4ce1-425d-890c-d5cdff75e822\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:29:56','2025-11-29 08:30:31','2025-11-29 08:30:31',1,'a9002bdb-9606-46ba-88a2-e1d76472e1dd','afa6b782-fcc2-4a45-bde3-dbc6a832d5c6','compute-1.ctlplane.example.com','a0b7719a-0c0b-4f4a-ae30-77f06c13cbb9','/dev/vda','2025-11-29 08:29:57','2025-11-29 08:30:31','rw','detached','{\"name\": \"volumes/volume-afa6b782-fcc2-4a45-bde3-dbc6a832d5c6\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"afa6b782-fcc2-4a45-bde3-dbc6a832d5c6\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"a9002bdb-9606-46ba-88a2-e1d76472e1dd\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34268feecb6\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2d58586e-4ce1-425d-890c-d5cdff75e822\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:45:21','2025-11-29 08:45:28','2025-11-29 08:45:28',1,'aad096ce-1312-4638-a043-99a0bc49b78e','2fa5bbdf-955a-4fa5-ac81-4ccf91494340','compute-0.ctlplane.example.com','02ec8d3d-66e9-47c4-a5a4-04389383ad38','/dev/vdb','2025-11-29 08:45:24','2025-11-29 08:45:28','rw','detached','{\"name\": \"volumes/volume-2fa5bbdf-955a-4fa5-ac81-4ccf91494340\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"2fa5bbdf-955a-4fa5-ac81-4ccf91494340\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"aad096ce-1312-4638-a043-99a0bc49b78e\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:babbd27d8a8\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9851e351-ef5d-4a0c-9f85-d561f6a4210f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:16:15','2025-11-29 08:16:32','2025-11-29 08:16:32',1,'af39c7eb-4a6e-462e-b129-e7501bb7d547','eb8b2675-ae0e-4130-a3f5-06bcfedbadc6','compute-0.ctlplane.example.com','886e1d81-4445-45c7-8c0a-4838eb595ab1','/dev/vdb','2025-11-29 08:16:20','2025-11-29 08:16:32','rw','detached','{\"name\": \"volumes/volume-eb8b2675-ae0e-4130-a3f5-06bcfedbadc6\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"eb8b2675-ae0e-4130-a3f5-06bcfedbadc6\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"af39c7eb-4a6e-462e-b129-e7501bb7d547\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:babbd27d8a8\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9851e351-ef5d-4a0c-9f85-d561f6a4210f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:23:45','2025-11-29 08:24:37','2025-11-29 08:24:37',1,'b1eb7ca5-9c24-4b9c-83f5-1607b410c2aa','d807030f-7b93-4396-9211-17a740c6b338','compute-1.ctlplane.example.com','2e7e8742-c504-412d-82cf-4087bd745c3e','/dev/vda','2025-11-29 08:23:48','2025-11-29 08:24:37','rw','detached','{\"name\": \"volumes/volume-d807030f-7b93-4396-9211-17a740c6b338\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"d807030f-7b93-4396-9211-17a740c6b338\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"b1eb7ca5-9c24-4b9c-83f5-1607b410c2aa\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34268feecb6\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2d58586e-4ce1-425d-890c-d5cdff75e822\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:16:23','2025-11-29 08:17:47','2025-11-29 08:17:47',1,'b2bb1101-20a8-4887-ba52-422e4e2fe68b','5c8ade3d-ec33-464b-bbb2-0e63ad58b8e9','compute-2.ctlplane.example.com','ad6070e8-74bc-4df7-9c2d-5da5da175238','/dev/vdb','2025-11-29 08:16:33','2025-11-29 08:17:47','rw','detached','{\"name\": \"volumes/volume-5c8ade3d-ec33-464b-bbb2-0e63ad58b8e9\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"5c8ade3d-ec33-464b-bbb2-0e63ad58b8e9\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"b2bb1101-20a8-4887-ba52-422e4e2fe68b\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0e73df9328\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"6fbde64a-d978-4f1a-a29d-a77e1f5a1987\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:44:15','2025-11-29 08:44:21','2025-11-29 08:44:21',1,'b49b892a-ac5a-4566-a337-c119c5661ba9','9aa47c29-8250-4a09-aa5f-08b05b14f1c9','compute-0.ctlplane.example.com','3941161c-104e-452f-8d56-54600d37d0f5','/dev/vdb','2025-11-29 08:44:16','2025-11-29 08:44:21','rw','detached','{\"name\": \"volumes/volume-9aa47c29-8250-4a09-aa5f-08b05b14f1c9\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"9aa47c29-8250-4a09-aa5f-08b05b14f1c9\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"b49b892a-ac5a-4566-a337-c119c5661ba9\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:babbd27d8a8\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9851e351-ef5d-4a0c-9f85-d561f6a4210f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 07:55:01','2025-11-29 07:55:38','2025-11-29 07:55:38',1,'b80f6614-6e08-4c17-b66e-c0f2a630e4d8','e52d8ac1-8970-4cf0-9aa0-795f616090d0','compute-0.ctlplane.example.com','56f3f72f-7db4-47c8-a4c3-20b2acc58aa9','/dev/vda','2025-11-29 07:55:02','2025-11-29 07:55:38','null','detached','{\"name\": \"volumes/volume-e52d8ac1-8970-4cf0-9aa0-795f616090d0\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"e52d8ac1-8970-4cf0-9aa0-795f616090d0\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"b80f6614-6e08-4c17-b66e-c0f2a630e4d8\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:babbd27d8a8\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9851e351-ef5d-4a0c-9f85-d561f6a4210f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2025-11-29 08:40:52','2025-11-29 08:41:10','2025-11-29 08:41:10',1,'beed8568-0144-43ae-b882-fce6ca87d63e','f8d3ed9a-0699-4f69-8315-0c8ebf96b12c','compute-1.ctlplane.example.com','fc75971c-cf7e-4383-81cf-81c801f67489','/dev/vdc','2025-11-29 08:40:53','2025-11-29 08:41:10','rw','detached','{\"name\": \"volumes/volume-f8d3ed9a-0699-4f69-8315-0c8ebf96b12c\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"f8d3ed9a-0699-4f69-8315-0c8ebf96b12c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"beed8568-0144-43ae-b882-fce6ca87d63e\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34268feecb6\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2d58586e-4ce1-425d-890c-d5cdff75e822\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-11-29 08:50:50','2025-11-29 08:52:59','2025-11-29 08:52:59',1,'bf0cb26d-07c5-4f16-a847-e44ab361b6a4','10605c29-d705-4bde-bb14-15733badfd18','compute-0.ctlplane.example.com','9249872d-f151-438a-bddd-e6b41e397647','/dev/vda','2025-11-29 08:50:54','2025-11-29 08:52:59','rw','detached','{\"name\": \"volumes/volume-10605c29-d705-4bde-bb14-15733badfd18\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"10605c29-d705-4bde-bb14-15733badfd18\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"bf0cb26d-07c5-4f16-a847-e44ab361b6a4\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:babbd27d8a8\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9851e351-ef5d-4a0c-9f85-d561f6a4210f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 07:55:03','2025-11-29 07:55:27','2025-11-29 07:55:27',1,'c0b9e72e-fa86-4348-9b79-27c3776cff57','3ef07b78-0409-49cf-a941-8a19b02dd939','compute-2.ctlplane.example.com','7067462a-37a6-458e-b96c-76adcea5fdfa','/dev/vda','2025-11-29 07:55:03','2025-11-29 07:55:27','null','detached','{\"name\": \"volumes/volume-3ef07b78-0409-49cf-a941-8a19b02dd939\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"3ef07b78-0409-49cf-a941-8a19b02dd939\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"c0b9e72e-fa86-4348-9b79-27c3776cff57\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0e73df9328\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"6fbde64a-d978-4f1a-a29d-a77e1f5a1987\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2025-11-29 08:38:35','2025-11-29 08:39:44','2025-11-29 08:39:44',1,'c1401724-e2f9-4264-9485-1111cd333829','4c2de305-8721-44a9-a539-b07eee5e101a','compute-2.ctlplane.example.com','608e1017-9da7-4ba6-a346-f047562d380b','/dev/vdb','2025-11-29 08:38:36','2025-11-29 08:39:44','rw','detached','{\"name\": \"volumes/volume-4c2de305-8721-44a9-a539-b07eee5e101a\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"4c2de305-8721-44a9-a539-b07eee5e101a\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"c1401724-e2f9-4264-9485-1111cd333829\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0e73df9328\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"6fbde64a-d978-4f1a-a29d-a77e1f5a1987\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:04:33','2025-11-29 08:04:40','2025-11-29 08:04:40',1,'c1e1bd19-138b-47cc-a3c2-b49ada1b6f51','c0dd2885-3214-46b3-a61c-f2d3eac073b6','compute-1.ctlplane.example.com','811e2f2f-5e2c-4c60-97e8-c39377dce6dc','/dev/vdb','2025-11-29 08:04:35','2025-11-29 08:04:40','rw','detached','{\"name\": \"volumes/volume-c0dd2885-3214-46b3-a61c-f2d3eac073b6\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"c0dd2885-3214-46b3-a61c-f2d3eac073b6\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"c1e1bd19-138b-47cc-a3c2-b49ada1b6f51\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34268feecb6\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2d58586e-4ce1-425d-890c-d5cdff75e822\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 07:55:27','2025-11-29 07:56:10','2025-11-29 07:56:10',1,'c8227129-6bbe-4228-aa7d-bbd6dba536af','e52d8ac1-8970-4cf0-9aa0-795f616090d0','compute-2.ctlplane.example.com','56f3f72f-7db4-47c8-a4c3-20b2acc58aa9','/dev/vda','2025-11-29 07:55:27','2025-11-29 07:56:10','null','detached','{\"name\": \"volumes/volume-e52d8ac1-8970-4cf0-9aa0-795f616090d0\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"e52d8ac1-8970-4cf0-9aa0-795f616090d0\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"c8227129-6bbe-4228-aa7d-bbd6dba536af\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0e73df9328\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"6fbde64a-d978-4f1a-a29d-a77e1f5a1987\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2025-11-29 08:14:32','2025-11-29 08:14:38','2025-11-29 08:14:38',1,'c947711f-ccd0-49be-844b-6a633b111615','e6cdb61f-1c62-49d7-8d64-b8125afce54e','compute-2.ctlplane.example.com','c32e74e2-e74f-4877-8130-ad35d31bb992','/dev/vdb','2025-11-29 08:14:33','2025-11-29 08:14:38','rw','detached','{\"name\": \"volumes/volume-e6cdb61f-1c62-49d7-8d64-b8125afce54e\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"e6cdb61f-1c62-49d7-8d64-b8125afce54e\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"c947711f-ccd0-49be-844b-6a633b111615\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0e73df9328\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"6fbde64a-d978-4f1a-a29d-a77e1f5a1987\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:47:57','2025-11-29 08:49:46','2025-11-29 08:49:46',1,'cb358295-d686-40bf-92e5-eaba4abcec9a','bf7e0110-334f-4129-a24d-43eb68f20833','compute-2.ctlplane.example.com','8e6ec5c0-7d7c-41e0-9f48-9e526008b00c','/dev/vda','2025-11-29 08:48:00','2025-11-29 08:49:46','rw','detached','{\"name\": \"volumes/volume-bf7e0110-334f-4129-a24d-43eb68f20833\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"bf7e0110-334f-4129-a24d-43eb68f20833\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"cb358295-d686-40bf-92e5-eaba4abcec9a\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0e73df9328\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"6fbde64a-d978-4f1a-a29d-a77e1f5a1987\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:48:58','2025-11-29 08:49:36','2025-11-29 08:49:36',1,'d10519eb-a981-4742-a2f0-dedecae74be4','77422021-a8a1-4df0-9b4a-24ac0dd34ac3','compute-1.ctlplane.example.com','e82bbbb4-4776-445f-9d1d-aea28fbbcaa8','/dev/vda','2025-11-29 08:49:01','2025-11-29 08:49:36','rw','detached','{\"name\": \"volumes/volume-77422021-a8a1-4df0-9b4a-24ac0dd34ac3\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"77422021-a8a1-4df0-9b4a-24ac0dd34ac3\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"d10519eb-a981-4742-a2f0-dedecae74be4\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34268feecb6\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2d58586e-4ce1-425d-890c-d5cdff75e822\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:27:42','2025-11-29 08:30:39','2025-11-29 08:30:39',1,'d17d63cc-1ab4-47ee-898a-6ce311191c86','a54a148c-90d3-4f80-83be-19de09d30ebc','compute-0.ctlplane.example.com','a0310268-d298-469e-9f04-6315f83c3f89','/dev/vda','2025-11-29 08:27:43','2025-11-29 08:30:39','rw','detached','{\"name\": \"volumes/volume-a54a148c-90d3-4f80-83be-19de09d30ebc\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"a54a148c-90d3-4f80-83be-19de09d30ebc\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"d17d63cc-1ab4-47ee-898a-6ce311191c86\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:babbd27d8a8\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9851e351-ef5d-4a0c-9f85-d561f6a4210f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:52:19','2025-11-29 08:52:48','2025-11-29 08:52:48',1,'d1df4608-df42-4250-8634-2a455e298fce','08dcfaf9-1c01-4432-a48d-de20b4481b2d','compute-2.ctlplane.example.com','16db2bb6-d5b2-4f00-8d36-e1ce814cd722','/dev/vda','2025-11-29 08:52:22','2025-11-29 08:52:48','rw','detached','{\"name\": \"volumes/volume-08dcfaf9-1c01-4432-a48d-de20b4481b2d\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"08dcfaf9-1c01-4432-a48d-de20b4481b2d\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"d1df4608-df42-4250-8634-2a455e298fce\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0e73df9328\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"6fbde64a-d978-4f1a-a29d-a77e1f5a1987\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:33:16','2025-11-29 08:34:12','2025-11-29 08:34:12',1,'d3106461-3305-4ffc-b68f-b5055f937fdf','d51465d5-c782-4ab5-86e5-16500d7ed93e','compute-1.ctlplane.example.com','f6eba09a-c0cf-4855-afd5-b265b2f2cadc','/dev/vdb','2025-11-29 08:33:17','2025-11-29 08:34:12','rw','detached','{\"name\": \"volumes/volume-d51465d5-c782-4ab5-86e5-16500d7ed93e\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"d51465d5-c782-4ab5-86e5-16500d7ed93e\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"d3106461-3305-4ffc-b68f-b5055f937fdf\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34268feecb6\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2d58586e-4ce1-425d-890c-d5cdff75e822\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:22:43','2025-11-29 08:22:53','2025-11-29 08:22:53',1,'d6278c17-8f17-4d71-a6a0-36665baf96a1','ca708729-36db-4dd2-9f09-88d87c483376','compute-2.ctlplane.example.com','8f2e1d97-ea5c-43f8-a05f-2f531213d241','/dev/vdb','2025-11-29 08:22:44','2025-11-29 08:22:53','rw','detached','{\"name\": \"volumes/volume-ca708729-36db-4dd2-9f09-88d87c483376\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"ca708729-36db-4dd2-9f09-88d87c483376\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"d6278c17-8f17-4d71-a6a0-36665baf96a1\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0e73df9328\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"6fbde64a-d978-4f1a-a29d-a77e1f5a1987\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:26:50','2025-11-29 08:27:42','2025-11-29 08:27:42',1,'d79b5e8b-7431-43e3-acec-da217fba59ac','8a80d4c0-d642-46d8-a891-79c20b955b6a','compute-2.ctlplane.example.com','50daa6f5-6598-439f-a542-38e8ae7aded0','/dev/vdb','2025-11-29 08:26:52','2025-11-29 08:27:42','rw','detached','{\"name\": \"volumes/volume-8a80d4c0-d642-46d8-a891-79c20b955b6a\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"8a80d4c0-d642-46d8-a891-79c20b955b6a\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"d79b5e8b-7431-43e3-acec-da217fba59ac\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0e73df9328\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"6fbde64a-d978-4f1a-a29d-a77e1f5a1987\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:48:55','2025-11-29 08:49:39','2025-11-29 08:49:39',1,'d9f8bb1c-749b-4658-aafc-a7734a467182','325ae6fa-18bb-47ad-9db3-2501a8dfae90','compute-2.ctlplane.example.com','4ae60306-1870-41f5-b85a-a161040086d0','/dev/vda','2025-11-29 08:48:56','2025-11-29 08:49:39','rw','detached','{\"name\": \"volumes/volume-325ae6fa-18bb-47ad-9db3-2501a8dfae90\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"325ae6fa-18bb-47ad-9db3-2501a8dfae90\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"d9f8bb1c-749b-4658-aafc-a7734a467182\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0e73df9328\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"6fbde64a-d978-4f1a-a29d-a77e1f5a1987\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:31:13','2025-11-29 08:31:58','2025-11-29 08:31:58',1,'dbfb7ff5-c7ea-44e1-b024-388a0296e20e','819403e4-4b9d-48a5-8cd5-1b913fa9f1ae','compute-1.ctlplane.example.com','7f0919df-6a69-4824-b20e-6540d1d3de30','/dev/vdb','2025-11-29 08:31:14','2025-11-29 08:31:58','rw','detached','{\"name\": \"volumes/volume-819403e4-4b9d-48a5-8cd5-1b913fa9f1ae\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"819403e4-4b9d-48a5-8cd5-1b913fa9f1ae\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"dbfb7ff5-c7ea-44e1-b024-388a0296e20e\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34268feecb6\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2d58586e-4ce1-425d-890c-d5cdff75e822\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:22:52','2025-11-29 08:23:06','2025-11-29 08:23:06',1,'e5403fcc-f5f5-410c-90a4-5c76b06c0975','ca708729-36db-4dd2-9f09-88d87c483376','compute-2.ctlplane.example.com','8f2e1d97-ea5c-43f8-a05f-2f531213d241','/dev/vdb','2025-11-29 08:22:54','2025-11-29 08:23:06','rw','detached','{\"name\": \"volumes/volume-ca708729-36db-4dd2-9f09-88d87c483376\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"ca708729-36db-4dd2-9f09-88d87c483376\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"e5403fcc-f5f5-410c-90a4-5c76b06c0975\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0e73df9328\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"6fbde64a-d978-4f1a-a29d-a77e1f5a1987\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:19:21','2025-11-29 08:20:00','2025-11-29 08:20:00',1,'e603fded-cf62-41e6-b73b-0eeec5f57a7e','85297db0-ac85-44d1-bc74-6e4a332ee974','compute-1.ctlplane.example.com','a14ca685-ed5c-4583-90e2-565fbf5e1ef0','/dev/vda','2025-11-29 08:19:24','2025-11-29 08:20:00','rw','detached','{\"name\": \"volumes/volume-85297db0-ac85-44d1-bc74-6e4a332ee974\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"85297db0-ac85-44d1-bc74-6e4a332ee974\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"e603fded-cf62-41e6-b73b-0eeec5f57a7e\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34268feecb6\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2d58586e-4ce1-425d-890c-d5cdff75e822\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:09:31','2025-11-29 08:11:03','2025-11-29 08:11:03',1,'eb056fdb-1deb-4da8-a715-3d46433fc5b1','496b8834-d1bb-44a8-b529-c5cd1c1fcd41','compute-1.ctlplane.example.com','86dc24b2-55cd-4720-825d-14b5a233fc8f','/dev/vdb','2025-11-29 08:09:38','2025-11-29 08:11:03','rw','detached','{\"name\": \"volumes/volume-496b8834-d1bb-44a8-b529-c5cd1c1fcd41\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"496b8834-d1bb-44a8-b529-c5cd1c1fcd41\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"eb056fdb-1deb-4da8-a715-3d46433fc5b1\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34268feecb6\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2d58586e-4ce1-425d-890c-d5cdff75e822\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:39:37','2025-11-29 08:40:01','2025-11-29 08:40:01',1,'ef76ea02-7b8f-4363-8cf6-5ad9e28b3ff4','54fbb1b4-e0a6-4add-a8f8-3d00e149271f','compute-2.ctlplane.example.com','ee3de57a-2652-4819-880a-6217c00a67a0','/dev/vdc','2025-11-29 08:39:38','2025-11-29 08:40:01','rw','detached','{\"name\": \"volumes/volume-54fbb1b4-e0a6-4add-a8f8-3d00e149271f\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"54fbb1b4-e0a6-4add-a8f8-3d00e149271f\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"ef76ea02-7b8f-4363-8cf6-5ad9e28b3ff4\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0e73df9328\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"6fbde64a-d978-4f1a-a29d-a77e1f5a1987\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-11-29 08:09:31','2025-11-29 08:11:02','2025-11-29 08:11:02',1,'f5ba17b7-40f8-4e26-9886-d3d4bc4414ab','7ea84dcf-1b42-49e3-8f53-f5de6e85eeeb','compute-1.ctlplane.example.com','86dc24b2-55cd-4720-825d-14b5a233fc8f','/dev/vda','2025-11-29 08:09:36','2025-11-29 08:11:02','rw','detached','{\"name\": \"volumes/volume-7ea84dcf-1b42-49e3-8f53-f5de6e85eeeb\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"7ea84dcf-1b42-49e3-8f53-f5de6e85eeeb\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"f5ba17b7-40f8-4e26-9886-d3d4bc4414ab\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34268feecb6\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2d58586e-4ce1-425d-890c-d5cdff75e822\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:09:31','2025-11-29 08:11:03','2025-11-29 08:11:03',1,'f854b30a-a6ad-49d6-a8b7-428520e06f25','00dd489a-c89a-475f-adcb-101636396ac7','compute-1.ctlplane.example.com','86dc24b2-55cd-4720-825d-14b5a233fc8f','/dev/vdc','2025-11-29 08:09:39','2025-11-29 08:11:03','rw','detached','{\"name\": \"volumes/volume-00dd489a-c89a-475f-adcb-101636396ac7\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"b66774a7-56d9-5535-bd8c-681234404870\", \"volume_id\": \"00dd489a-c89a-475f-adcb-101636396ac7\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"f854b30a-a6ad-49d6-a8b7-428520e06f25\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34268feecb6\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2d58586e-4ce1-425d-890c-d5cdff75e822\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}');
/*!40000 ALTER TABLE `volume_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_glance_metadata`
--

DROP TABLE IF EXISTS `volume_glance_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_glance_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_glance_metadata_snapshot_id` (`snapshot_id`),
  KEY `ix_volume_glance_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_glance_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `volume_glance_metadata_ibfk_2` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=267 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_glance_metadata`
--

LOCK TABLES `volume_glance_metadata` WRITE;
/*!40000 ALTER TABLE `volume_glance_metadata` DISABLE KEYS */;
INSERT INTO `volume_glance_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `snapshot_id`, `key`, `value`) VALUES ('2025-11-29 07:54:10',NULL,'2025-11-29 07:55:33',1,1,'3ef07b78-0409-49cf-a941-8a19b02dd939',NULL,'signature_verified','False'),('2025-11-29 07:54:10',NULL,'2025-11-29 07:56:11',1,2,'e52d8ac1-8970-4cf0-9aa0-795f616090d0',NULL,'signature_verified','False'),('2025-11-29 07:54:14',NULL,'2025-11-29 07:56:11',1,3,'e52d8ac1-8970-4cf0-9aa0-795f616090d0',NULL,'hw_rng_model','virtio'),('2025-11-29 07:54:14',NULL,'2025-11-29 07:56:11',1,4,'e52d8ac1-8970-4cf0-9aa0-795f616090d0',NULL,'image_id','4873db8c-b414-4e95-acd9-77caabebe722'),('2025-11-29 07:54:14',NULL,'2025-11-29 07:56:11',1,5,'e52d8ac1-8970-4cf0-9aa0-795f616090d0',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 07:54:14',NULL,'2025-11-29 07:56:11',1,6,'e52d8ac1-8970-4cf0-9aa0-795f616090d0',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 07:54:14',NULL,'2025-11-29 07:56:11',1,7,'e52d8ac1-8970-4cf0-9aa0-795f616090d0',NULL,'container_format','bare'),('2025-11-29 07:54:14',NULL,'2025-11-29 07:56:11',1,8,'e52d8ac1-8970-4cf0-9aa0-795f616090d0',NULL,'disk_format','qcow2'),('2025-11-29 07:54:14',NULL,'2025-11-29 07:56:11',1,9,'e52d8ac1-8970-4cf0-9aa0-795f616090d0',NULL,'min_disk','0'),('2025-11-29 07:54:14',NULL,'2025-11-29 07:56:11',1,10,'e52d8ac1-8970-4cf0-9aa0-795f616090d0',NULL,'min_ram','0'),('2025-11-29 07:54:14',NULL,'2025-11-29 07:55:33',1,11,'3ef07b78-0409-49cf-a941-8a19b02dd939',NULL,'hw_rng_model','virtio'),('2025-11-29 07:54:14',NULL,'2025-11-29 07:56:11',1,12,'e52d8ac1-8970-4cf0-9aa0-795f616090d0',NULL,'size','21430272'),('2025-11-29 07:54:14',NULL,'2025-11-29 07:55:33',1,13,'3ef07b78-0409-49cf-a941-8a19b02dd939',NULL,'image_id','4873db8c-b414-4e95-acd9-77caabebe722'),('2025-11-29 07:54:14',NULL,'2025-11-29 07:55:33',1,14,'3ef07b78-0409-49cf-a941-8a19b02dd939',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 07:54:14',NULL,'2025-11-29 07:55:33',1,15,'3ef07b78-0409-49cf-a941-8a19b02dd939',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 07:54:14',NULL,'2025-11-29 07:55:33',1,16,'3ef07b78-0409-49cf-a941-8a19b02dd939',NULL,'container_format','bare'),('2025-11-29 07:54:14',NULL,'2025-11-29 07:55:33',1,17,'3ef07b78-0409-49cf-a941-8a19b02dd939',NULL,'disk_format','qcow2'),('2025-11-29 07:54:14',NULL,'2025-11-29 07:55:33',1,18,'3ef07b78-0409-49cf-a941-8a19b02dd939',NULL,'min_disk','0'),('2025-11-29 07:54:14',NULL,'2025-11-29 07:55:33',1,19,'3ef07b78-0409-49cf-a941-8a19b02dd939',NULL,'min_ram','0'),('2025-11-29 07:54:14',NULL,'2025-11-29 07:55:33',1,20,'3ef07b78-0409-49cf-a941-8a19b02dd939',NULL,'size','21430272'),('2025-11-29 08:01:06',NULL,'2025-11-29 08:01:55',1,21,'cda8bfe0-3a4d-4d07-beb1-adb73b629321',NULL,'signature_verified','False'),('2025-11-29 08:01:10',NULL,'2025-11-29 08:01:55',1,22,'cda8bfe0-3a4d-4d07-beb1-adb73b629321',NULL,'hw_rng_model','virtio'),('2025-11-29 08:01:10',NULL,'2025-11-29 08:01:55',1,23,'cda8bfe0-3a4d-4d07-beb1-adb73b629321',NULL,'image_id','4873db8c-b414-4e95-acd9-77caabebe722'),('2025-11-29 08:01:10',NULL,'2025-11-29 08:01:55',1,24,'cda8bfe0-3a4d-4d07-beb1-adb73b629321',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:01:10',NULL,'2025-11-29 08:01:55',1,25,'cda8bfe0-3a4d-4d07-beb1-adb73b629321',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:01:10',NULL,'2025-11-29 08:01:55',1,26,'cda8bfe0-3a4d-4d07-beb1-adb73b629321',NULL,'container_format','bare'),('2025-11-29 08:01:10',NULL,'2025-11-29 08:01:55',1,27,'cda8bfe0-3a4d-4d07-beb1-adb73b629321',NULL,'disk_format','qcow2'),('2025-11-29 08:01:10',NULL,'2025-11-29 08:01:55',1,28,'cda8bfe0-3a4d-4d07-beb1-adb73b629321',NULL,'min_disk','0'),('2025-11-29 08:01:10',NULL,'2025-11-29 08:01:55',1,29,'cda8bfe0-3a4d-4d07-beb1-adb73b629321',NULL,'min_ram','0'),('2025-11-29 08:01:10',NULL,'2025-11-29 08:01:55',1,30,'cda8bfe0-3a4d-4d07-beb1-adb73b629321',NULL,'size','21430272'),('2025-11-29 08:09:08',NULL,'2025-11-29 08:11:15',1,31,'7ea84dcf-1b42-49e3-8f53-f5de6e85eeeb',NULL,'signature_verified','False'),('2025-11-29 08:09:12',NULL,'2025-11-29 08:11:15',1,32,'7ea84dcf-1b42-49e3-8f53-f5de6e85eeeb',NULL,'hw_rng_model','virtio'),('2025-11-29 08:09:12',NULL,'2025-11-29 08:11:15',1,33,'7ea84dcf-1b42-49e3-8f53-f5de6e85eeeb',NULL,'image_id','4873db8c-b414-4e95-acd9-77caabebe722'),('2025-11-29 08:09:12',NULL,'2025-11-29 08:11:15',1,34,'7ea84dcf-1b42-49e3-8f53-f5de6e85eeeb',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:09:12',NULL,'2025-11-29 08:11:15',1,35,'7ea84dcf-1b42-49e3-8f53-f5de6e85eeeb',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:09:12',NULL,'2025-11-29 08:11:15',1,36,'7ea84dcf-1b42-49e3-8f53-f5de6e85eeeb',NULL,'container_format','bare'),('2025-11-29 08:09:12',NULL,'2025-11-29 08:11:15',1,37,'7ea84dcf-1b42-49e3-8f53-f5de6e85eeeb',NULL,'disk_format','qcow2'),('2025-11-29 08:09:12',NULL,'2025-11-29 08:11:15',1,38,'7ea84dcf-1b42-49e3-8f53-f5de6e85eeeb',NULL,'min_disk','0'),('2025-11-29 08:09:12',NULL,'2025-11-29 08:11:15',1,39,'7ea84dcf-1b42-49e3-8f53-f5de6e85eeeb',NULL,'min_ram','0'),('2025-11-29 08:09:12',NULL,'2025-11-29 08:11:15',1,40,'7ea84dcf-1b42-49e3-8f53-f5de6e85eeeb',NULL,'size','21430272'),('2025-11-29 08:15:50',NULL,'2025-11-29 08:18:09',1,41,'618924f8-fe57-45de-85ec-593336349be7',NULL,'signature_verified','False'),('2025-11-29 08:15:55',NULL,'2025-11-29 08:18:09',1,42,'618924f8-fe57-45de-85ec-593336349be7',NULL,'hw_rng_model','virtio'),('2025-11-29 08:15:55',NULL,'2025-11-29 08:18:09',1,43,'618924f8-fe57-45de-85ec-593336349be7',NULL,'image_id','4873db8c-b414-4e95-acd9-77caabebe722'),('2025-11-29 08:15:55',NULL,'2025-11-29 08:18:09',1,44,'618924f8-fe57-45de-85ec-593336349be7',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:15:55',NULL,'2025-11-29 08:18:09',1,45,'618924f8-fe57-45de-85ec-593336349be7',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:15:55',NULL,'2025-11-29 08:18:09',1,46,'618924f8-fe57-45de-85ec-593336349be7',NULL,'container_format','bare'),('2025-11-29 08:15:55',NULL,'2025-11-29 08:18:09',1,47,'618924f8-fe57-45de-85ec-593336349be7',NULL,'disk_format','qcow2'),('2025-11-29 08:15:55',NULL,'2025-11-29 08:18:09',1,48,'618924f8-fe57-45de-85ec-593336349be7',NULL,'min_disk','0'),('2025-11-29 08:15:55',NULL,'2025-11-29 08:18:09',1,49,'618924f8-fe57-45de-85ec-593336349be7',NULL,'min_ram','0'),('2025-11-29 08:15:55',NULL,'2025-11-29 08:18:09',1,50,'618924f8-fe57-45de-85ec-593336349be7',NULL,'size','21430272'),('2025-11-29 08:19:14',NULL,'2025-11-29 08:20:07',1,51,'85297db0-ac85-44d1-bc74-6e4a332ee974',NULL,'signature_verified','False'),('2025-11-29 08:19:18',NULL,'2025-11-29 08:20:07',1,52,'85297db0-ac85-44d1-bc74-6e4a332ee974',NULL,'hw_rng_model','virtio'),('2025-11-29 08:19:18',NULL,'2025-11-29 08:20:07',1,53,'85297db0-ac85-44d1-bc74-6e4a332ee974',NULL,'image_id','4873db8c-b414-4e95-acd9-77caabebe722'),('2025-11-29 08:19:18',NULL,'2025-11-29 08:20:07',1,54,'85297db0-ac85-44d1-bc74-6e4a332ee974',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:19:18',NULL,'2025-11-29 08:20:07',1,55,'85297db0-ac85-44d1-bc74-6e4a332ee974',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:19:18',NULL,'2025-11-29 08:20:07',1,56,'85297db0-ac85-44d1-bc74-6e4a332ee974',NULL,'container_format','bare'),('2025-11-29 08:19:18',NULL,'2025-11-29 08:20:07',1,57,'85297db0-ac85-44d1-bc74-6e4a332ee974',NULL,'disk_format','qcow2'),('2025-11-29 08:19:18',NULL,'2025-11-29 08:20:07',1,58,'85297db0-ac85-44d1-bc74-6e4a332ee974',NULL,'min_disk','0'),('2025-11-29 08:19:18',NULL,'2025-11-29 08:20:07',1,59,'85297db0-ac85-44d1-bc74-6e4a332ee974',NULL,'min_ram','0'),('2025-11-29 08:19:18',NULL,'2025-11-29 08:20:07',1,60,'85297db0-ac85-44d1-bc74-6e4a332ee974',NULL,'size','21430272'),('2025-11-29 08:20:07',NULL,'2025-11-29 08:20:50',1,61,'85297db0-ac85-44d1-bc74-6e4a332ee974',NULL,'hw_rng_model','virtio'),('2025-11-29 08:20:07',NULL,'2025-11-29 08:20:50',1,62,'85297db0-ac85-44d1-bc74-6e4a332ee974',NULL,'image_id','93eccffb-bacd-407f-af6f-64451dee7b21'),('2025-11-29 08:20:07',NULL,'2025-11-29 08:20:50',1,63,'85297db0-ac85-44d1-bc74-6e4a332ee974',NULL,'image_name','cirros-0.6.2-x86_64-disk.img_alt'),('2025-11-29 08:20:07',NULL,'2025-11-29 08:20:50',1,64,'85297db0-ac85-44d1-bc74-6e4a332ee974',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:20:07',NULL,'2025-11-29 08:20:50',1,65,'85297db0-ac85-44d1-bc74-6e4a332ee974',NULL,'container_format','bare'),('2025-11-29 08:20:07',NULL,'2025-11-29 08:20:50',1,66,'85297db0-ac85-44d1-bc74-6e4a332ee974',NULL,'disk_format','qcow2'),('2025-11-29 08:20:07',NULL,'2025-11-29 08:20:50',1,67,'85297db0-ac85-44d1-bc74-6e4a332ee974',NULL,'min_disk','0'),('2025-11-29 08:20:07',NULL,'2025-11-29 08:20:50',1,68,'85297db0-ac85-44d1-bc74-6e4a332ee974',NULL,'min_ram','0'),('2025-11-29 08:20:07',NULL,'2025-11-29 08:20:50',1,69,'85297db0-ac85-44d1-bc74-6e4a332ee974',NULL,'size','21430272'),('2025-11-29 08:23:38',NULL,'2025-11-29 08:25:14',1,70,'d807030f-7b93-4396-9211-17a740c6b338',NULL,'signature_verified','False'),('2025-11-29 08:23:42',NULL,'2025-11-29 08:25:14',1,71,'d807030f-7b93-4396-9211-17a740c6b338',NULL,'hw_rng_model','virtio'),('2025-11-29 08:23:42',NULL,'2025-11-29 08:25:14',1,72,'d807030f-7b93-4396-9211-17a740c6b338',NULL,'image_id','4873db8c-b414-4e95-acd9-77caabebe722'),('2025-11-29 08:23:42',NULL,'2025-11-29 08:25:14',1,73,'d807030f-7b93-4396-9211-17a740c6b338',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:23:42',NULL,'2025-11-29 08:25:14',1,74,'d807030f-7b93-4396-9211-17a740c6b338',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:23:42',NULL,'2025-11-29 08:25:14',1,75,'d807030f-7b93-4396-9211-17a740c6b338',NULL,'container_format','bare'),('2025-11-29 08:23:42',NULL,'2025-11-29 08:25:14',1,76,'d807030f-7b93-4396-9211-17a740c6b338',NULL,'disk_format','qcow2'),('2025-11-29 08:23:42',NULL,'2025-11-29 08:25:14',1,77,'d807030f-7b93-4396-9211-17a740c6b338',NULL,'min_disk','0'),('2025-11-29 08:23:42',NULL,'2025-11-29 08:25:14',1,78,'d807030f-7b93-4396-9211-17a740c6b338',NULL,'min_ram','0'),('2025-11-29 08:23:42',NULL,'2025-11-29 08:25:14',1,79,'d807030f-7b93-4396-9211-17a740c6b338',NULL,'size','21430272'),('2025-11-29 08:29:47',NULL,NULL,0,80,'afa6b782-fcc2-4a45-bde3-dbc6a832d5c6',NULL,'signature_verified','False'),('2025-11-29 08:29:53',NULL,NULL,0,81,'afa6b782-fcc2-4a45-bde3-dbc6a832d5c6',NULL,'hw_rng_model','virtio'),('2025-11-29 08:29:53',NULL,NULL,0,82,'afa6b782-fcc2-4a45-bde3-dbc6a832d5c6',NULL,'image_id','4873db8c-b414-4e95-acd9-77caabebe722'),('2025-11-29 08:29:53',NULL,NULL,0,83,'afa6b782-fcc2-4a45-bde3-dbc6a832d5c6',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:29:53',NULL,NULL,0,84,'afa6b782-fcc2-4a45-bde3-dbc6a832d5c6',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:29:53',NULL,NULL,0,85,'afa6b782-fcc2-4a45-bde3-dbc6a832d5c6',NULL,'container_format','bare'),('2025-11-29 08:29:53',NULL,NULL,0,86,'afa6b782-fcc2-4a45-bde3-dbc6a832d5c6',NULL,'disk_format','qcow2'),('2025-11-29 08:29:53',NULL,NULL,0,87,'afa6b782-fcc2-4a45-bde3-dbc6a832d5c6',NULL,'min_disk','0'),('2025-11-29 08:29:53',NULL,NULL,0,88,'afa6b782-fcc2-4a45-bde3-dbc6a832d5c6',NULL,'min_ram','0'),('2025-11-29 08:29:53',NULL,NULL,0,89,'afa6b782-fcc2-4a45-bde3-dbc6a832d5c6',NULL,'size','21430272'),('2025-11-29 08:31:19',NULL,'2025-11-29 08:35:44',1,90,'6d9d34fb-9df6-452a-837f-86dd8a2bf2ba',NULL,'signature_verified','False'),('2025-11-29 08:31:24',NULL,'2025-11-29 08:35:44',1,91,'6d9d34fb-9df6-452a-837f-86dd8a2bf2ba',NULL,'hw_rng_model','virtio'),('2025-11-29 08:31:24',NULL,'2025-11-29 08:35:44',1,92,'6d9d34fb-9df6-452a-837f-86dd8a2bf2ba',NULL,'image_id','4873db8c-b414-4e95-acd9-77caabebe722'),('2025-11-29 08:31:24',NULL,'2025-11-29 08:35:44',1,93,'6d9d34fb-9df6-452a-837f-86dd8a2bf2ba',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:31:24',NULL,'2025-11-29 08:35:44',1,94,'6d9d34fb-9df6-452a-837f-86dd8a2bf2ba',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:31:24',NULL,'2025-11-29 08:35:44',1,95,'6d9d34fb-9df6-452a-837f-86dd8a2bf2ba',NULL,'container_format','bare'),('2025-11-29 08:31:24',NULL,'2025-11-29 08:35:44',1,96,'6d9d34fb-9df6-452a-837f-86dd8a2bf2ba',NULL,'disk_format','qcow2'),('2025-11-29 08:31:24',NULL,'2025-11-29 08:35:44',1,97,'6d9d34fb-9df6-452a-837f-86dd8a2bf2ba',NULL,'min_disk','0'),('2025-11-29 08:31:24',NULL,'2025-11-29 08:35:44',1,98,'6d9d34fb-9df6-452a-837f-86dd8a2bf2ba',NULL,'min_ram','0'),('2025-11-29 08:31:24',NULL,'2025-11-29 08:35:44',1,99,'6d9d34fb-9df6-452a-837f-86dd8a2bf2ba',NULL,'size','21430272'),('2025-11-29 08:34:54',NULL,'2025-11-29 08:35:19',1,100,'9b4f6e7c-11e4-4465-94bc-84c3365ec3b9',NULL,'signature_verified','False'),('2025-11-29 08:34:58',NULL,'2025-11-29 08:35:19',1,101,'9b4f6e7c-11e4-4465-94bc-84c3365ec3b9',NULL,'hw_rng_model','virtio'),('2025-11-29 08:34:58',NULL,'2025-11-29 08:35:19',1,102,'9b4f6e7c-11e4-4465-94bc-84c3365ec3b9',NULL,'image_id','4873db8c-b414-4e95-acd9-77caabebe722'),('2025-11-29 08:34:58',NULL,'2025-11-29 08:35:19',1,103,'9b4f6e7c-11e4-4465-94bc-84c3365ec3b9',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:34:58',NULL,'2025-11-29 08:35:19',1,104,'9b4f6e7c-11e4-4465-94bc-84c3365ec3b9',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:34:58',NULL,'2025-11-29 08:35:19',1,105,'9b4f6e7c-11e4-4465-94bc-84c3365ec3b9',NULL,'container_format','bare'),('2025-11-29 08:34:58',NULL,'2025-11-29 08:35:19',1,106,'9b4f6e7c-11e4-4465-94bc-84c3365ec3b9',NULL,'disk_format','qcow2'),('2025-11-29 08:34:58',NULL,'2025-11-29 08:35:19',1,107,'9b4f6e7c-11e4-4465-94bc-84c3365ec3b9',NULL,'min_disk','0'),('2025-11-29 08:34:58',NULL,'2025-11-29 08:35:19',1,108,'9b4f6e7c-11e4-4465-94bc-84c3365ec3b9',NULL,'min_ram','0'),('2025-11-29 08:34:58',NULL,'2025-11-29 08:35:19',1,109,'9b4f6e7c-11e4-4465-94bc-84c3365ec3b9',NULL,'size','21430272'),('2025-11-29 08:35:13',NULL,'2025-11-29 08:35:18',1,110,NULL,'f1b378b6-b3b7-477d-8029-338c3783f767','signature_verified','False'),('2025-11-29 08:35:13',NULL,'2025-11-29 08:35:18',1,111,NULL,'f1b378b6-b3b7-477d-8029-338c3783f767','hw_rng_model','virtio'),('2025-11-29 08:35:13',NULL,'2025-11-29 08:35:18',1,112,NULL,'f1b378b6-b3b7-477d-8029-338c3783f767','image_id','4873db8c-b414-4e95-acd9-77caabebe722'),('2025-11-29 08:35:13',NULL,'2025-11-29 08:35:18',1,113,NULL,'f1b378b6-b3b7-477d-8029-338c3783f767','image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:35:13',NULL,'2025-11-29 08:35:18',1,114,NULL,'f1b378b6-b3b7-477d-8029-338c3783f767','checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:35:13',NULL,'2025-11-29 08:35:18',1,115,NULL,'f1b378b6-b3b7-477d-8029-338c3783f767','container_format','bare'),('2025-11-29 08:35:13',NULL,'2025-11-29 08:35:18',1,116,NULL,'f1b378b6-b3b7-477d-8029-338c3783f767','disk_format','qcow2'),('2025-11-29 08:35:13',NULL,'2025-11-29 08:35:18',1,117,NULL,'f1b378b6-b3b7-477d-8029-338c3783f767','min_disk','0'),('2025-11-29 08:35:13',NULL,'2025-11-29 08:35:18',1,118,NULL,'f1b378b6-b3b7-477d-8029-338c3783f767','min_ram','0'),('2025-11-29 08:35:13',NULL,'2025-11-29 08:35:18',1,119,NULL,'f1b378b6-b3b7-477d-8029-338c3783f767','size','21430272'),('2025-11-29 08:39:12',NULL,'2025-11-29 08:41:34',1,120,'36eafc77-7bfd-44e7-b2f9-bca3cee5c1b3',NULL,'signature_verified','False'),('2025-11-29 08:39:14',NULL,'2025-11-29 08:41:33',1,121,'bd3bcc0c-33d5-4f56-93b8-0804e2446b99',NULL,'signature_verified','False'),('2025-11-29 08:39:16',NULL,'2025-11-29 08:41:32',1,122,'c9cf1b4f-d920-4673-b1fc-8c791f56541b',NULL,'signature_verified','False'),('2025-11-29 08:39:17',NULL,'2025-11-29 08:41:34',1,123,'36eafc77-7bfd-44e7-b2f9-bca3cee5c1b3',NULL,'image_id','10bcdd0b-a9bb-4ca1-8d7b-e11af81db4ec'),('2025-11-29 08:39:17',NULL,'2025-11-29 08:41:34',1,124,'36eafc77-7bfd-44e7-b2f9-bca3cee5c1b3',NULL,'image_name','tempest-scenario-img--1593838428'),('2025-11-29 08:39:17',NULL,'2025-11-29 08:41:34',1,125,'36eafc77-7bfd-44e7-b2f9-bca3cee5c1b3',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:39:17',NULL,'2025-11-29 08:41:34',1,126,'36eafc77-7bfd-44e7-b2f9-bca3cee5c1b3',NULL,'container_format','bare'),('2025-11-29 08:39:17',NULL,'2025-11-29 08:41:34',1,127,'36eafc77-7bfd-44e7-b2f9-bca3cee5c1b3',NULL,'disk_format','qcow2'),('2025-11-29 08:39:17',NULL,'2025-11-29 08:41:34',1,128,'36eafc77-7bfd-44e7-b2f9-bca3cee5c1b3',NULL,'min_disk','0'),('2025-11-29 08:39:17',NULL,'2025-11-29 08:41:34',1,129,'36eafc77-7bfd-44e7-b2f9-bca3cee5c1b3',NULL,'min_ram','0'),('2025-11-29 08:39:17',NULL,'2025-11-29 08:41:34',1,130,'36eafc77-7bfd-44e7-b2f9-bca3cee5c1b3',NULL,'size','21430272'),('2025-11-29 08:39:20',NULL,'2025-11-29 08:41:33',1,131,'bd3bcc0c-33d5-4f56-93b8-0804e2446b99',NULL,'image_id','10bcdd0b-a9bb-4ca1-8d7b-e11af81db4ec'),('2025-11-29 08:39:20',NULL,'2025-11-29 08:41:33',1,132,'bd3bcc0c-33d5-4f56-93b8-0804e2446b99',NULL,'image_name','tempest-scenario-img--1593838428'),('2025-11-29 08:39:20',NULL,'2025-11-29 08:41:33',1,133,'bd3bcc0c-33d5-4f56-93b8-0804e2446b99',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:39:20',NULL,'2025-11-29 08:41:33',1,134,'bd3bcc0c-33d5-4f56-93b8-0804e2446b99',NULL,'container_format','bare'),('2025-11-29 08:39:20',NULL,'2025-11-29 08:41:33',1,135,'bd3bcc0c-33d5-4f56-93b8-0804e2446b99',NULL,'disk_format','qcow2'),('2025-11-29 08:39:20',NULL,'2025-11-29 08:41:33',1,136,'bd3bcc0c-33d5-4f56-93b8-0804e2446b99',NULL,'min_disk','0'),('2025-11-29 08:39:20',NULL,'2025-11-29 08:41:32',1,137,'c9cf1b4f-d920-4673-b1fc-8c791f56541b',NULL,'image_id','10bcdd0b-a9bb-4ca1-8d7b-e11af81db4ec'),('2025-11-29 08:39:20',NULL,'2025-11-29 08:41:32',1,138,'c9cf1b4f-d920-4673-b1fc-8c791f56541b',NULL,'image_name','tempest-scenario-img--1593838428'),('2025-11-29 08:39:20',NULL,'2025-11-29 08:41:32',1,139,'c9cf1b4f-d920-4673-b1fc-8c791f56541b',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:39:20',NULL,'2025-11-29 08:41:33',1,140,'bd3bcc0c-33d5-4f56-93b8-0804e2446b99',NULL,'min_ram','0'),('2025-11-29 08:39:20',NULL,'2025-11-29 08:41:32',1,141,'c9cf1b4f-d920-4673-b1fc-8c791f56541b',NULL,'container_format','bare'),('2025-11-29 08:39:20',NULL,'2025-11-29 08:41:33',1,142,'bd3bcc0c-33d5-4f56-93b8-0804e2446b99',NULL,'size','21430272'),('2025-11-29 08:39:20',NULL,'2025-11-29 08:41:32',1,143,'c9cf1b4f-d920-4673-b1fc-8c791f56541b',NULL,'disk_format','qcow2'),('2025-11-29 08:39:20',NULL,'2025-11-29 08:41:32',1,144,'c9cf1b4f-d920-4673-b1fc-8c791f56541b',NULL,'min_disk','0'),('2025-11-29 08:39:20',NULL,'2025-11-29 08:41:32',1,145,'c9cf1b4f-d920-4673-b1fc-8c791f56541b',NULL,'min_ram','0'),('2025-11-29 08:39:20',NULL,'2025-11-29 08:41:32',1,146,'c9cf1b4f-d920-4673-b1fc-8c791f56541b',NULL,'size','21430272'),('2025-11-29 08:47:09',NULL,'2025-11-29 08:47:39',1,147,'57f207d9-b8b7-4e93-8117-125577facc2e',NULL,'signature_verified','False'),('2025-11-29 08:47:13',NULL,'2025-11-29 08:47:39',1,148,'57f207d9-b8b7-4e93-8117-125577facc2e',NULL,'hw_rng_model','virtio'),('2025-11-29 08:47:13',NULL,'2025-11-29 08:47:39',1,149,'57f207d9-b8b7-4e93-8117-125577facc2e',NULL,'image_id','4873db8c-b414-4e95-acd9-77caabebe722'),('2025-11-29 08:47:13',NULL,'2025-11-29 08:47:39',1,150,'57f207d9-b8b7-4e93-8117-125577facc2e',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:47:13',NULL,'2025-11-29 08:47:39',1,151,'57f207d9-b8b7-4e93-8117-125577facc2e',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:47:13',NULL,'2025-11-29 08:47:39',1,152,'57f207d9-b8b7-4e93-8117-125577facc2e',NULL,'container_format','bare'),('2025-11-29 08:47:13',NULL,'2025-11-29 08:47:39',1,153,'57f207d9-b8b7-4e93-8117-125577facc2e',NULL,'disk_format','qcow2'),('2025-11-29 08:47:13',NULL,'2025-11-29 08:47:39',1,154,'57f207d9-b8b7-4e93-8117-125577facc2e',NULL,'min_disk','0'),('2025-11-29 08:47:13',NULL,'2025-11-29 08:47:39',1,155,'57f207d9-b8b7-4e93-8117-125577facc2e',NULL,'min_ram','0'),('2025-11-29 08:47:13',NULL,'2025-11-29 08:47:39',1,156,'57f207d9-b8b7-4e93-8117-125577facc2e',NULL,'size','21430272'),('2025-11-29 08:47:14',NULL,'2025-11-29 08:47:38',1,157,NULL,'91a127b9-1cd6-49a6-97a2-a9c44bf2b597','signature_verified','False'),('2025-11-29 08:47:14',NULL,'2025-11-29 08:47:38',1,158,NULL,'91a127b9-1cd6-49a6-97a2-a9c44bf2b597','hw_rng_model','virtio'),('2025-11-29 08:47:14',NULL,'2025-11-29 08:47:38',1,159,NULL,'91a127b9-1cd6-49a6-97a2-a9c44bf2b597','image_id','4873db8c-b414-4e95-acd9-77caabebe722'),('2025-11-29 08:47:14',NULL,'2025-11-29 08:47:38',1,160,NULL,'91a127b9-1cd6-49a6-97a2-a9c44bf2b597','image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:47:14',NULL,'2025-11-29 08:47:38',1,161,NULL,'91a127b9-1cd6-49a6-97a2-a9c44bf2b597','checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:47:14',NULL,'2025-11-29 08:47:38',1,162,NULL,'91a127b9-1cd6-49a6-97a2-a9c44bf2b597','container_format','bare'),('2025-11-29 08:47:14',NULL,'2025-11-29 08:47:38',1,163,NULL,'91a127b9-1cd6-49a6-97a2-a9c44bf2b597','disk_format','qcow2'),('2025-11-29 08:47:14',NULL,'2025-11-29 08:47:38',1,164,NULL,'91a127b9-1cd6-49a6-97a2-a9c44bf2b597','min_disk','0'),('2025-11-29 08:47:14',NULL,'2025-11-29 08:47:38',1,165,NULL,'91a127b9-1cd6-49a6-97a2-a9c44bf2b597','min_ram','0'),('2025-11-29 08:47:14',NULL,'2025-11-29 08:47:38',1,166,NULL,'91a127b9-1cd6-49a6-97a2-a9c44bf2b597','size','21430272'),('2025-11-29 08:47:22',NULL,'2025-11-29 08:47:36',1,167,'04876073-8d9f-4092-96a1-ca8b66cb7194',NULL,'signature_verified','False'),('2025-11-29 08:47:22',NULL,'2025-11-29 08:47:36',1,168,'04876073-8d9f-4092-96a1-ca8b66cb7194',NULL,'hw_rng_model','virtio'),('2025-11-29 08:47:22',NULL,'2025-11-29 08:47:36',1,169,'04876073-8d9f-4092-96a1-ca8b66cb7194',NULL,'image_id','4873db8c-b414-4e95-acd9-77caabebe722'),('2025-11-29 08:47:22',NULL,'2025-11-29 08:47:36',1,170,'04876073-8d9f-4092-96a1-ca8b66cb7194',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:47:22',NULL,'2025-11-29 08:47:36',1,171,'04876073-8d9f-4092-96a1-ca8b66cb7194',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:47:22',NULL,'2025-11-29 08:47:36',1,172,'04876073-8d9f-4092-96a1-ca8b66cb7194',NULL,'container_format','bare'),('2025-11-29 08:47:22',NULL,'2025-11-29 08:47:36',1,173,'04876073-8d9f-4092-96a1-ca8b66cb7194',NULL,'disk_format','qcow2'),('2025-11-29 08:47:22',NULL,'2025-11-29 08:47:36',1,174,'04876073-8d9f-4092-96a1-ca8b66cb7194',NULL,'min_disk','0'),('2025-11-29 08:47:22',NULL,'2025-11-29 08:47:36',1,175,'04876073-8d9f-4092-96a1-ca8b66cb7194',NULL,'min_ram','0'),('2025-11-29 08:47:22',NULL,'2025-11-29 08:47:36',1,176,'04876073-8d9f-4092-96a1-ca8b66cb7194',NULL,'size','21430272'),('2025-11-29 08:47:44',NULL,'2025-11-29 08:49:46',1,177,'bf7e0110-334f-4129-a24d-43eb68f20833',NULL,'signature_verified','False'),('2025-11-29 08:47:48',NULL,'2025-11-29 08:49:46',1,178,'bf7e0110-334f-4129-a24d-43eb68f20833',NULL,'hw_rng_model','virtio'),('2025-11-29 08:47:48',NULL,'2025-11-29 08:49:46',1,179,'bf7e0110-334f-4129-a24d-43eb68f20833',NULL,'image_id','4873db8c-b414-4e95-acd9-77caabebe722'),('2025-11-29 08:47:48',NULL,'2025-11-29 08:49:46',1,180,'bf7e0110-334f-4129-a24d-43eb68f20833',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:47:48',NULL,'2025-11-29 08:49:46',1,181,'bf7e0110-334f-4129-a24d-43eb68f20833',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:47:48',NULL,'2025-11-29 08:49:46',1,182,'bf7e0110-334f-4129-a24d-43eb68f20833',NULL,'container_format','bare'),('2025-11-29 08:47:48',NULL,'2025-11-29 08:49:46',1,183,'bf7e0110-334f-4129-a24d-43eb68f20833',NULL,'disk_format','qcow2'),('2025-11-29 08:47:48',NULL,'2025-11-29 08:49:46',1,184,'bf7e0110-334f-4129-a24d-43eb68f20833',NULL,'min_disk','0'),('2025-11-29 08:47:48',NULL,'2025-11-29 08:49:46',1,185,'bf7e0110-334f-4129-a24d-43eb68f20833',NULL,'min_ram','0'),('2025-11-29 08:47:48',NULL,'2025-11-29 08:49:46',1,186,'bf7e0110-334f-4129-a24d-43eb68f20833',NULL,'size','21430272'),('2025-11-29 08:48:44',NULL,'2025-11-29 08:49:43',1,187,NULL,'efcdc2f4-6579-4824-ad08-d6752dc23fc5','signature_verified','False'),('2025-11-29 08:48:44',NULL,'2025-11-29 08:49:43',1,188,NULL,'efcdc2f4-6579-4824-ad08-d6752dc23fc5','hw_rng_model','virtio'),('2025-11-29 08:48:44',NULL,'2025-11-29 08:49:43',1,189,NULL,'efcdc2f4-6579-4824-ad08-d6752dc23fc5','image_id','4873db8c-b414-4e95-acd9-77caabebe722'),('2025-11-29 08:48:44',NULL,'2025-11-29 08:49:43',1,190,NULL,'efcdc2f4-6579-4824-ad08-d6752dc23fc5','image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:48:44',NULL,'2025-11-29 08:49:43',1,191,NULL,'efcdc2f4-6579-4824-ad08-d6752dc23fc5','checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:48:44',NULL,'2025-11-29 08:49:43',1,192,NULL,'efcdc2f4-6579-4824-ad08-d6752dc23fc5','container_format','bare'),('2025-11-29 08:48:44',NULL,'2025-11-29 08:49:43',1,193,NULL,'efcdc2f4-6579-4824-ad08-d6752dc23fc5','disk_format','qcow2'),('2025-11-29 08:48:44',NULL,'2025-11-29 08:49:43',1,194,NULL,'efcdc2f4-6579-4824-ad08-d6752dc23fc5','min_disk','0'),('2025-11-29 08:48:44',NULL,'2025-11-29 08:49:43',1,195,NULL,'efcdc2f4-6579-4824-ad08-d6752dc23fc5','min_ram','0'),('2025-11-29 08:48:44',NULL,'2025-11-29 08:49:43',1,196,NULL,'efcdc2f4-6579-4824-ad08-d6752dc23fc5','size','21430272'),('2025-11-29 08:48:52',NULL,'2025-11-29 08:50:29',1,197,'77422021-a8a1-4df0-9b4a-24ac0dd34ac3',NULL,'signature_verified','False'),('2025-11-29 08:48:52',NULL,'2025-11-29 08:49:40',1,198,'325ae6fa-18bb-47ad-9db3-2501a8dfae90',NULL,'signature_verified','False'),('2025-11-29 08:48:52',NULL,'2025-11-29 08:49:40',1,199,'325ae6fa-18bb-47ad-9db3-2501a8dfae90',NULL,'hw_rng_model','virtio'),('2025-11-29 08:48:52',NULL,'2025-11-29 08:49:40',1,200,'325ae6fa-18bb-47ad-9db3-2501a8dfae90',NULL,'image_id','4873db8c-b414-4e95-acd9-77caabebe722'),('2025-11-29 08:48:52',NULL,'2025-11-29 08:49:40',1,201,'325ae6fa-18bb-47ad-9db3-2501a8dfae90',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:48:52',NULL,'2025-11-29 08:49:40',1,202,'325ae6fa-18bb-47ad-9db3-2501a8dfae90',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:48:52',NULL,'2025-11-29 08:49:40',1,203,'325ae6fa-18bb-47ad-9db3-2501a8dfae90',NULL,'container_format','bare'),('2025-11-29 08:48:52',NULL,'2025-11-29 08:49:40',1,204,'325ae6fa-18bb-47ad-9db3-2501a8dfae90',NULL,'disk_format','qcow2'),('2025-11-29 08:48:52',NULL,'2025-11-29 08:49:40',1,205,'325ae6fa-18bb-47ad-9db3-2501a8dfae90',NULL,'min_disk','0'),('2025-11-29 08:48:52',NULL,'2025-11-29 08:49:40',1,206,'325ae6fa-18bb-47ad-9db3-2501a8dfae90',NULL,'min_ram','0'),('2025-11-29 08:48:52',NULL,'2025-11-29 08:49:40',1,207,'325ae6fa-18bb-47ad-9db3-2501a8dfae90',NULL,'size','21430272'),('2025-11-29 08:48:55',NULL,'2025-11-29 08:50:29',1,208,'77422021-a8a1-4df0-9b4a-24ac0dd34ac3',NULL,'hw_rng_model','virtio'),('2025-11-29 08:48:55',NULL,'2025-11-29 08:50:29',1,209,'77422021-a8a1-4df0-9b4a-24ac0dd34ac3',NULL,'image_id','4873db8c-b414-4e95-acd9-77caabebe722'),('2025-11-29 08:48:55',NULL,'2025-11-29 08:50:29',1,210,'77422021-a8a1-4df0-9b4a-24ac0dd34ac3',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:48:55',NULL,'2025-11-29 08:50:29',1,211,'77422021-a8a1-4df0-9b4a-24ac0dd34ac3',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:48:55',NULL,'2025-11-29 08:50:29',1,212,'77422021-a8a1-4df0-9b4a-24ac0dd34ac3',NULL,'container_format','bare'),('2025-11-29 08:48:55',NULL,'2025-11-29 08:50:29',1,213,'77422021-a8a1-4df0-9b4a-24ac0dd34ac3',NULL,'disk_format','qcow2'),('2025-11-29 08:48:55',NULL,'2025-11-29 08:50:29',1,214,'77422021-a8a1-4df0-9b4a-24ac0dd34ac3',NULL,'min_disk','0'),('2025-11-29 08:48:55',NULL,'2025-11-29 08:50:29',1,215,'77422021-a8a1-4df0-9b4a-24ac0dd34ac3',NULL,'min_ram','0'),('2025-11-29 08:48:55',NULL,'2025-11-29 08:50:29',1,216,'77422021-a8a1-4df0-9b4a-24ac0dd34ac3',NULL,'size','21430272'),('2025-11-29 08:50:00',NULL,'2025-11-29 08:53:03',1,217,'10605c29-d705-4bde-bb14-15733badfd18',NULL,'signature_verified','False'),('2025-11-29 08:50:04',NULL,'2025-11-29 08:53:03',1,218,'10605c29-d705-4bde-bb14-15733badfd18',NULL,'hw_rng_model','virtio'),('2025-11-29 08:50:04',NULL,'2025-11-29 08:53:03',1,219,'10605c29-d705-4bde-bb14-15733badfd18',NULL,'image_id','4873db8c-b414-4e95-acd9-77caabebe722'),('2025-11-29 08:50:04',NULL,'2025-11-29 08:53:03',1,220,'10605c29-d705-4bde-bb14-15733badfd18',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:50:04',NULL,'2025-11-29 08:53:03',1,221,'10605c29-d705-4bde-bb14-15733badfd18',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:50:04',NULL,'2025-11-29 08:53:03',1,222,'10605c29-d705-4bde-bb14-15733badfd18',NULL,'container_format','bare'),('2025-11-29 08:50:04',NULL,'2025-11-29 08:53:03',1,223,'10605c29-d705-4bde-bb14-15733badfd18',NULL,'disk_format','qcow2'),('2025-11-29 08:50:04',NULL,'2025-11-29 08:53:03',1,224,'10605c29-d705-4bde-bb14-15733badfd18',NULL,'min_disk','0'),('2025-11-29 08:50:04',NULL,'2025-11-29 08:53:03',1,225,'10605c29-d705-4bde-bb14-15733badfd18',NULL,'min_ram','0'),('2025-11-29 08:50:04',NULL,'2025-11-29 08:53:03',1,226,'10605c29-d705-4bde-bb14-15733badfd18',NULL,'size','21430272'),('2025-11-29 08:51:43',NULL,'2025-11-29 08:52:52',1,227,'c95c9cac-92b7-4049-a506-241e7c32e9cd',NULL,'signature_verified','False'),('2025-11-29 08:51:46',NULL,'2025-11-29 08:52:54',1,228,NULL,'d898cedb-1577-453e-a5a3-56529a2d305a','signature_verified','False'),('2025-11-29 08:51:46',NULL,'2025-11-29 08:52:54',1,229,NULL,'d898cedb-1577-453e-a5a3-56529a2d305a','hw_rng_model','virtio'),('2025-11-29 08:51:46',NULL,'2025-11-29 08:52:54',1,230,NULL,'d898cedb-1577-453e-a5a3-56529a2d305a','image_id','4873db8c-b414-4e95-acd9-77caabebe722'),('2025-11-29 08:51:46',NULL,'2025-11-29 08:52:54',1,231,NULL,'d898cedb-1577-453e-a5a3-56529a2d305a','image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:51:46',NULL,'2025-11-29 08:52:54',1,232,NULL,'d898cedb-1577-453e-a5a3-56529a2d305a','checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:51:46',NULL,'2025-11-29 08:52:54',1,233,NULL,'d898cedb-1577-453e-a5a3-56529a2d305a','container_format','bare'),('2025-11-29 08:51:46',NULL,'2025-11-29 08:52:54',1,234,NULL,'d898cedb-1577-453e-a5a3-56529a2d305a','disk_format','qcow2'),('2025-11-29 08:51:46',NULL,'2025-11-29 08:52:54',1,235,NULL,'d898cedb-1577-453e-a5a3-56529a2d305a','min_disk','0'),('2025-11-29 08:51:46',NULL,'2025-11-29 08:52:54',1,236,NULL,'d898cedb-1577-453e-a5a3-56529a2d305a','min_ram','0'),('2025-11-29 08:51:46',NULL,'2025-11-29 08:52:54',1,237,NULL,'d898cedb-1577-453e-a5a3-56529a2d305a','size','21430272'),('2025-11-29 08:51:49',NULL,'2025-11-29 08:52:52',1,238,'fee77070-ed28-42d2-8e57-eb8da81862b4',NULL,'signature_verified','False'),('2025-11-29 08:51:49',NULL,'2025-11-29 08:52:52',1,239,'fee77070-ed28-42d2-8e57-eb8da81862b4',NULL,'hw_rng_model','virtio'),('2025-11-29 08:51:49',NULL,'2025-11-29 08:52:52',1,240,'fee77070-ed28-42d2-8e57-eb8da81862b4',NULL,'image_id','4873db8c-b414-4e95-acd9-77caabebe722'),('2025-11-29 08:51:49',NULL,'2025-11-29 08:52:52',1,241,'fee77070-ed28-42d2-8e57-eb8da81862b4',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:51:49',NULL,'2025-11-29 08:52:52',1,242,'fee77070-ed28-42d2-8e57-eb8da81862b4',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:51:49',NULL,'2025-11-29 08:52:52',1,243,'fee77070-ed28-42d2-8e57-eb8da81862b4',NULL,'container_format','bare'),('2025-11-29 08:51:49',NULL,'2025-11-29 08:52:52',1,244,'fee77070-ed28-42d2-8e57-eb8da81862b4',NULL,'disk_format','qcow2'),('2025-11-29 08:51:49',NULL,'2025-11-29 08:52:52',1,245,'fee77070-ed28-42d2-8e57-eb8da81862b4',NULL,'min_disk','0'),('2025-11-29 08:51:49',NULL,'2025-11-29 08:52:52',1,246,'fee77070-ed28-42d2-8e57-eb8da81862b4',NULL,'min_ram','0'),('2025-11-29 08:51:49',NULL,'2025-11-29 08:52:52',1,247,'fee77070-ed28-42d2-8e57-eb8da81862b4',NULL,'size','21430272'),('2025-11-29 08:51:54',NULL,'2025-11-29 08:52:52',1,248,'c95c9cac-92b7-4049-a506-241e7c32e9cd',NULL,'hw_rng_model','virtio'),('2025-11-29 08:51:54',NULL,'2025-11-29 08:52:52',1,249,'c95c9cac-92b7-4049-a506-241e7c32e9cd',NULL,'image_id','4873db8c-b414-4e95-acd9-77caabebe722'),('2025-11-29 08:51:54',NULL,'2025-11-29 08:52:52',1,250,'c95c9cac-92b7-4049-a506-241e7c32e9cd',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:51:54',NULL,'2025-11-29 08:52:52',1,251,'c95c9cac-92b7-4049-a506-241e7c32e9cd',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:51:54',NULL,'2025-11-29 08:52:52',1,252,'c95c9cac-92b7-4049-a506-241e7c32e9cd',NULL,'container_format','bare'),('2025-11-29 08:51:54',NULL,'2025-11-29 08:52:52',1,253,'c95c9cac-92b7-4049-a506-241e7c32e9cd',NULL,'disk_format','qcow2'),('2025-11-29 08:51:54',NULL,'2025-11-29 08:52:52',1,254,'c95c9cac-92b7-4049-a506-241e7c32e9cd',NULL,'min_disk','0'),('2025-11-29 08:51:54',NULL,'2025-11-29 08:52:52',1,255,'c95c9cac-92b7-4049-a506-241e7c32e9cd',NULL,'min_ram','0'),('2025-11-29 08:51:54',NULL,'2025-11-29 08:52:52',1,256,'c95c9cac-92b7-4049-a506-241e7c32e9cd',NULL,'size','21430272'),('2025-11-29 08:52:06',NULL,'2025-11-29 08:52:52',1,257,'08dcfaf9-1c01-4432-a48d-de20b4481b2d',NULL,'signature_verified','False'),('2025-11-29 08:52:06',NULL,'2025-11-29 08:52:52',1,258,'08dcfaf9-1c01-4432-a48d-de20b4481b2d',NULL,'hw_rng_model','virtio'),('2025-11-29 08:52:06',NULL,'2025-11-29 08:52:52',1,259,'08dcfaf9-1c01-4432-a48d-de20b4481b2d',NULL,'image_id','4873db8c-b414-4e95-acd9-77caabebe722'),('2025-11-29 08:52:06',NULL,'2025-11-29 08:52:52',1,260,'08dcfaf9-1c01-4432-a48d-de20b4481b2d',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:52:06',NULL,'2025-11-29 08:52:52',1,261,'08dcfaf9-1c01-4432-a48d-de20b4481b2d',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:52:06',NULL,'2025-11-29 08:52:52',1,262,'08dcfaf9-1c01-4432-a48d-de20b4481b2d',NULL,'container_format','bare'),('2025-11-29 08:52:06',NULL,'2025-11-29 08:52:52',1,263,'08dcfaf9-1c01-4432-a48d-de20b4481b2d',NULL,'disk_format','qcow2'),('2025-11-29 08:52:06',NULL,'2025-11-29 08:52:52',1,264,'08dcfaf9-1c01-4432-a48d-de20b4481b2d',NULL,'min_disk','0'),('2025-11-29 08:52:07',NULL,'2025-11-29 08:52:52',1,265,'08dcfaf9-1c01-4432-a48d-de20b4481b2d',NULL,'min_ram','0'),('2025-11-29 08:52:07',NULL,'2025-11-29 08:52:52',1,266,'08dcfaf9-1c01-4432-a48d-de20b4481b2d',NULL,'size','21430272');
/*!40000 ALTER TABLE `volume_glance_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_metadata`
--

DROP TABLE IF EXISTS `volume_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_metadata`
--

LOCK TABLES `volume_metadata` WRITE;
/*!40000 ALTER TABLE `volume_metadata` DISABLE KEYS */;
INSERT INTO `volume_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `key`, `value`) VALUES ('2025-11-29 08:18:42',NULL,'2025-11-29 08:18:53',1,1,'c345e855-7bd5-4aa7-9a47-bac56b0be48c','Type','work'),('2025-11-29 08:18:44',NULL,'2025-11-29 08:18:52',1,2,'9924eb1b-f775-4059-a2c7-b5aea0bf8d30','Type','work'),('2025-11-29 08:18:46',NULL,'2025-11-29 08:18:50',1,3,'fa769f70-df1d-4fba-80e3-8ee051e19a1a','Type','work'),('2025-11-29 08:41:16',NULL,'2025-11-29 08:41:20',1,4,'bb9230ca-f8b6-4b0e-aa82-885958ef0172','Type','work'),('2025-11-29 08:52:07',NULL,'2025-11-29 08:52:52',1,5,'08dcfaf9-1c01-4432-a48d-de20b4481b2d','src_backup_id','c8953a74-a0fc-4433-b15f-8c123b9fb922');
/*!40000 ALTER TABLE `volume_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_extra_specs`
--

DROP TABLE IF EXISTS `volume_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_extra_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_type_extra_specs_volume_type_id` (`volume_type_id`),
  CONSTRAINT `volume_type_extra_specs_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_extra_specs`
--

LOCK TABLES `volume_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `volume_type_extra_specs` DISABLE KEYS */;
INSERT INTO `volume_type_extra_specs` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_type_id`, `key`, `value`) VALUES ('2025-11-29 07:47:18',NULL,NULL,0,1,'693bd8a6-9594-46ee-8a11-532b65e85c26','multiattach','<is> True');
/*!40000 ALTER TABLE `volume_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_projects`
--

DROP TABLE IF EXISTS `volume_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `volume_type_id` (`volume_type_id`,`project_id`,`deleted`),
  CONSTRAINT `volume_type_projects_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_projects`
--

LOCK TABLES `volume_type_projects` WRITE;
/*!40000 ALTER TABLE `volume_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_types`
--

DROP TABLE IF EXISTS `volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `qos_specs_id` varchar(36) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_types_qos_specs_id` (`qos_specs_id`),
  CONSTRAINT `volume_types_ibfk_1` FOREIGN KEY (`qos_specs_id`) REFERENCES `quality_of_service_specs` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_types`
--

LOCK TABLES `volume_types` WRITE;
/*!40000 ALTER TABLE `volume_types` DISABLE KEYS */;
INSERT INTO `volume_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `qos_specs_id`, `is_public`, `description`) VALUES ('2025-11-29 08:39:08',NULL,'2025-11-29 08:41:36',1,'1df8de75-5537-417c-9507-97fa3907d96f','tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-334379363-1778895309',NULL,1,NULL),('2025-11-29 06:55:38','2025-11-29 06:55:38',NULL,0,'39d21972-2dc2-43ff-bc93-44dae17fa0f9','__DEFAULT__',NULL,1,'Default Volume Type'),('2025-11-29 08:39:06',NULL,'2025-11-29 08:41:38',1,'4a99b942-b940-4fde-b14d-3d1eca116a07','tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1204371373-2122106632',NULL,1,NULL),('2025-11-29 07:47:16',NULL,NULL,0,'693bd8a6-9594-46ee-8a11-532b65e85c26','multiattach',NULL,1,NULL),('2025-11-29 08:39:08',NULL,'2025-11-29 08:41:37',1,'6b67de39-187b-4ace-abba-ddc26b90da11','tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1962685100-62209477',NULL,1,NULL),('2025-11-29 08:41:39',NULL,'2025-11-29 08:42:50',1,'abf7c55e-ae5e-4bec-b06e-872d499cb5c4','tempest-scenario-type-luks-1501415148',NULL,1,NULL),('2025-11-29 08:46:18',NULL,'2025-11-29 08:47:03',1,'d2b244a1-75e7-4ea9-a00a-c6558e187208','tempest-scenario-type-luks-677447409',NULL,1,NULL);
/*!40000 ALTER TABLE `volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ec2_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(256) DEFAULT NULL,
  `provider_auth` varchar(256) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `source_volid` varchar(36) DEFAULT NULL,
  `bootable` tinyint(1) DEFAULT NULL,
  `provider_geometry` varchar(255) DEFAULT NULL,
  `_name_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `migration_status` varchar(255) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  `replication_extended_status` varchar(255) DEFAULT NULL,
  `replication_driver_data` varchar(255) DEFAULT NULL,
  `consistencygroup_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `multiattach` tinyint(1) DEFAULT NULL,
  `previous_status` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `group_id` varchar(36) DEFAULT NULL,
  `service_uuid` varchar(36) DEFAULT NULL,
  `shared_targets` tinyint(1) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volumes_group_id` (`group_id`),
  KEY `ix_volumes_consistencygroup_id` (`consistencygroup_id`),
  KEY `volumes_service_uuid_idx` (`service_uuid`,`deleted`),
  KEY `volumes_deleted_project_id_idx` (`deleted`,`project_id`),
  KEY `volumes_deleted_host_idx` (`deleted`,`host`),
  CONSTRAINT `volumes_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `volumes_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `volumes_ibfk_3` FOREIGN KEY (`service_uuid`) REFERENCES `services` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
INSERT INTO `volumes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `ec2_id`, `user_id`, `project_id`, `host`, `size`, `availability_zone`, `status`, `attach_status`, `scheduled_at`, `launched_at`, `terminated_at`, `display_name`, `display_description`, `provider_location`, `provider_auth`, `snapshot_id`, `volume_type_id`, `source_volid`, `bootable`, `provider_geometry`, `_name_id`, `encryption_key_id`, `migration_status`, `replication_status`, `replication_extended_status`, `replication_driver_data`, `consistencygroup_id`, `provider_id`, `multiattach`, `previous_status`, `cluster_name`, `group_id`, `service_uuid`, `shared_targets`, `use_quota`) VALUES ('2025-11-29 08:09:14','2025-11-29 08:11:10','2025-11-29 08:11:11',1,'00dd489a-c89a-475f-adcb-101636396ac7',NULL,'6ef481e9e8e0440c91abe11aee229780','28c3d09b9e21417cb7bc44b8552f1b81','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:09:14','2025-11-29 08:09:15','2025-11-29 08:11:10','tempest-TaggedBootDevicesTest_v242-volume-292055805',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:47:22','2025-11-29 08:47:36','2025-11-29 08:47:36',1,'04876073-8d9f-4092-96a1-ca8b66cb7194',NULL,'b576a51181b5425aa6e44a0eb0a22803','b7ffcb23bac14ee49474df9aee5f7dae','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:47:22','2025-11-29 08:47:22','2025-11-29 08:47:36','','',NULL,NULL,'91a127b9-1cd6-49a6-97a2-a9c44bf2b597','39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:52:03','2025-11-29 08:52:51','2025-11-29 08:52:52',1,'08dcfaf9-1c01-4432-a48d-de20b4481b2d',NULL,'c3778685080b4955bd80ff7056a1c9f2','676f70280bf945cd90578b14202243e2','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:52:04','2025-11-29 08:52:04','2025-11-29 08:52:51','tempest-TestVolumeBackupRestore-volume-515131276',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:49:57','2025-11-29 08:53:03','2025-11-29 08:53:03',1,'10605c29-d705-4bde-bb14-15733badfd18',NULL,'b576a51181b5425aa6e44a0eb0a22803','b7ffcb23bac14ee49474df9aee5f7dae','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:49:57','2025-11-29 08:50:04','2025-11-29 08:53:03','tempest-TestVolumeBootPattern-volume-origin-1563699686',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:41:40','2025-11-29 08:42:49','2025-11-29 08:42:49',1,'12074156-11fd-4503-8e66-ac1cd1f8e83a',NULL,'ea98d0ceb3954515a9c726d0d32d30cb','c80b570a17ee4094b96a75465fc34ae7','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:41:41','2025-11-29 08:41:50','2025-11-29 08:42:49','tempest-TestEncryptedCinderVolumes-volume-146218286',NULL,NULL,NULL,NULL,'abf7c55e-ae5e-4bec-b06e-872d499cb5c4',NULL,0,NULL,NULL,'f1784f4d-bd83-4c57-a711-5366b7510394',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:27:21','2025-11-29 08:28:51','2025-11-29 08:28:51',1,'213d91c6-0ee8-47c3-965c-92c80077e9ee',NULL,'283f8136265e4425a5a31f840935b9ab','ea7b24ea9d7b4d239b4741634ac3f10c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:27:22','2025-11-29 08:27:22','2025-11-29 08:28:51','tempest-ServerRescueNegativeTestJSON-volume-930907898',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:35:24','2025-11-29 08:38:37','2025-11-29 08:38:38',1,'2f39efc2-fe1b-41a9-96e3-2aca65cf0fa6',NULL,'bdbcdbdc435844ee8d866288c969331b','368e3a44279843f5947188dd045d65b6','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:35:24','2025-11-29 08:35:24','2025-11-29 08:38:37','tempest-AttachVolumeNegativeTest-volume-1762897926',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:44:30','2025-11-29 08:45:34','2025-11-29 08:45:34',1,'2fa5bbdf-955a-4fa5-ac81-4ccf91494340',NULL,'01c0b956e2c74d5798d01fc2be0a8bac','3b3b0484057a4e3db51366d29c6b684d','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:44:30','2025-11-29 08:44:30','2025-11-29 08:45:34','tempest-TestStampPattern-volume-117686216',NULL,NULL,NULL,'bffe82e5-41b8-4236-9ff9-21b5e39f73ac','39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:48:52','2025-11-29 08:49:40','2025-11-29 08:49:40',1,'325ae6fa-18bb-47ad-9db3-2501a8dfae90',NULL,'b576a51181b5425aa6e44a0eb0a22803','b7ffcb23bac14ee49474df9aee5f7dae','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:48:52','2025-11-29 08:48:52','2025-11-29 08:49:40','','',NULL,NULL,'efcdc2f4-6579-4824-ad08-d6752dc23fc5','39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:39:08','2025-11-29 08:39:58','2025-11-29 08:39:59',1,'35daf555-cff7-4c13-98d4-8c31451470ee',NULL,'facf4db8501041ab9628ff9f5684c992','62ca01275fe34ea0af31d00b34d6d9a5','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:39:08','2025-11-29 08:39:08','2025-11-29 08:39:58','tempest-TestInstancesWithCinderVolumes-volume-862103034',NULL,NULL,NULL,NULL,'6b67de39-187b-4ace-abba-ddc26b90da11',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:39:10','2025-11-29 08:41:34','2025-11-29 08:41:34',1,'36eafc77-7bfd-44e7-b2f9-bca3cee5c1b3',NULL,'facf4db8501041ab9628ff9f5684c992','62ca01275fe34ea0af31d00b34d6d9a5','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:39:10','2025-11-29 08:39:17','2025-11-29 08:41:34','tempest-TestInstancesWithCinderVolumes-volume-420272366',NULL,NULL,NULL,NULL,'4a99b942-b940-4fde-b14d-3d1eca116a07',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:33:54','2025-11-29 08:34:12','2025-11-29 08:34:13',1,'371e8431-582d-4b80-9978-50a1e275178d',NULL,'5b0fe4d78df74554a3a5875ab629d59c','1981e9617628491f938ef0ef01c061c5','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:33:54','2025-11-29 08:33:54','2025-11-29 08:34:12','tempest-AttachVolumeTestJSON-volume-1854762457',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 07:54:04','2025-11-29 07:55:27','2025-11-29 07:55:33',1,'3ef07b78-0409-49cf-a941-8a19b02dd939',NULL,'85f5548e01234fe4ae9b88e998e943f8','1963a097b7694450aa0d7c30b27b38ac','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 07:54:04','2025-11-29 07:54:14','2025-11-29 07:55:27','tempest-tempest.common.compute-volume-1485475969',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:46:19','2025-11-29 08:47:01','2025-11-29 08:47:01',1,'3f901e23-17b3-4b75-8f9b-33496e3b8402',NULL,'b576a51181b5425aa6e44a0eb0a22803','b7ffcb23bac14ee49474df9aee5f7dae','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:46:19','2025-11-29 08:46:26','2025-11-29 08:47:01','tempest-TestVolumeBootPattern-volume-1673726171',NULL,NULL,NULL,NULL,'d2b244a1-75e7-4ea9-a00a-c6558e187208',NULL,1,NULL,NULL,'091a9a2e-d1cc-44d2-be96-b1719b550e5c',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:15:57','2025-11-29 08:17:59','2025-11-29 08:17:59',1,'414e4eae-2565-42a3-bb35-fdd1ef6e127f',NULL,'2646d924f10246c98f4ee29d496eb0f3','9e6235234e63419ead82cbd9a07d500f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:15:58','2025-11-29 08:15:59','2025-11-29 08:17:59','tempest-TaggedBootDevicesTest-volume-283747001',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:09:13','2025-11-29 08:11:12','2025-11-29 08:11:13',1,'496b8834-d1bb-44a8-b529-c5cd1c1fcd41',NULL,'6ef481e9e8e0440c91abe11aee229780','28c3d09b9e21417cb7bc44b8552f1b81','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:09:13','2025-11-29 08:09:13','2025-11-29 08:11:12','tempest-TaggedBootDevicesTest_v242-volume-1082478904',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:38:32','2025-11-29 08:39:45','2025-11-29 08:39:48',1,'4c2de305-8721-44a9-a539-b07eee5e101a',NULL,'e8b20745b2d14f70b64a43335faed2f4','8d5e30b74e6449dd90ecb667977d1fe9','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:38:32','2025-11-29 08:38:32','2025-11-29 08:39:45','tempest-TestMinimumBasicScenario-volume-73879732',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:39:08','2025-11-29 08:40:02','2025-11-29 08:40:03',1,'54fbb1b4-e0a6-4add-a8f8-3d00e149271f',NULL,'facf4db8501041ab9628ff9f5684c992','62ca01275fe34ea0af31d00b34d6d9a5','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:39:08','2025-11-29 08:39:08','2025-11-29 08:40:02','tempest-TestInstancesWithCinderVolumes-volume-1160853891',NULL,NULL,NULL,NULL,'1df8de75-5537-417c-9507-97fa3907d96f',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:47:06','2025-11-29 08:47:38','2025-11-29 08:47:39',1,'57f207d9-b8b7-4e93-8117-125577facc2e',NULL,'b576a51181b5425aa6e44a0eb0a22803','b7ffcb23bac14ee49474df9aee5f7dae','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:47:07','2025-11-29 08:47:13','2025-11-29 08:47:38','tempest-TestVolumeBootPattern-volume-origin-1915941220',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:15:56','2025-11-29 08:18:00','2025-11-29 08:18:03',1,'5c8ade3d-ec33-464b-bbb2-0e63ad58b8e9',NULL,'2646d924f10246c98f4ee29d496eb0f3','9e6235234e63419ead82cbd9a07d500f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:15:56','2025-11-29 08:15:56','2025-11-29 08:18:00','tempest-TaggedBootDevicesTest-volume-219711718',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:15:46','2025-11-29 08:18:04','2025-11-29 08:18:09',1,'618924f8-fe57-45de-85ec-593336349be7',NULL,'2646d924f10246c98f4ee29d496eb0f3','9e6235234e63419ead82cbd9a07d500f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:15:46','2025-11-29 08:15:55','2025-11-29 08:18:04','tempest-TaggedBootDevicesTest-volume-1086631508',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:32:13','2025-11-29 08:35:31','2025-11-29 08:35:31',1,'6273512e-203d-43b7-bb2f-a59b9ff4579f',NULL,'c5b0953fb7cc415fb26cf4ffdd5908c6','d4f6db81949d487b853d7567f8a2e6d4','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:32:13','2025-11-29 08:32:13','2025-11-29 08:35:31','tempest-AttachVolumeMultiAttachTest-volume-665792740',NULL,'{\"saved_features\":61}',NULL,NULL,'693bd8a6-9594-46ee-8a11-532b65e85c26',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:34:34','2025-11-29 08:36:44','2025-11-29 08:36:45',1,'64bbfa9c-d43c-43e9-9778-a0574da20e96',NULL,'a57807acb02b45d082f242ec62cd5b6f','96e72e7660da497a8b6bf9fdb03fe84c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:34:34','2025-11-29 08:34:34','2025-11-29 08:36:44','tempest-ServersNegativeTestJSON-volume-345503623',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:39:36','2025-11-29 08:40:53','2025-11-29 08:40:53',1,'68efac4f-4452-463d-99e0-c6f94bc84f27',NULL,'eeba34466b8f4a1bb5f742f1e811053c','889608c71d13429fb37793575792ae74','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:39:36','2025-11-29 08:39:37','2025-11-29 08:40:52','tempest-AttachVolumeShelveTestJSON-volume-441027612',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:31:17','2025-11-29 08:35:43','2025-11-29 08:35:44',1,'6d9d34fb-9df6-452a-837f-86dd8a2bf2ba',NULL,'c5b0953fb7cc415fb26cf4ffdd5908c6','d4f6db81949d487b853d7567f8a2e6d4','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:31:17','2025-11-29 08:31:24','2025-11-29 08:35:43','tempest-AttachVolumeMultiAttachTest-volume-996757568',NULL,'{\"saved_features\":61}',NULL,NULL,'693bd8a6-9594-46ee-8a11-532b65e85c26',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:48:49','2025-11-29 08:50:28','2025-11-29 08:50:29',1,'77422021-a8a1-4df0-9b4a-24ac0dd34ac3',NULL,'14d446574294425e9bc89e596ea56dc9','2e636ab14fe94059b82b9cbcf8831d87','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:48:49','2025-11-29 08:48:55','2025-11-29 08:50:28','tempest-tempest.common.compute-volume-1820265749',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:00:40','2025-11-29 08:03:04','2025-11-29 08:03:05',1,'78d7295a-1d09-4e50-9943-5daf7dc56278',NULL,'ba1b423b724a47f692a3d9cbf91860d7','afaf65dfeab546ee991af0438784b8a3','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:00:40','2025-11-29 08:00:41','2025-11-29 08:03:04','tempest-UpdateMultiattachVolumeNegativeTest-volume-868768074',NULL,'{\"saved_features\":61}',NULL,NULL,'693bd8a6-9594-46ee-8a11-532b65e85c26',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:09:04','2025-11-29 08:11:13','2025-11-29 08:11:15',1,'7ea84dcf-1b42-49e3-8f53-f5de6e85eeeb',NULL,'6ef481e9e8e0440c91abe11aee229780','28c3d09b9e21417cb7bc44b8552f1b81','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:09:04','2025-11-29 08:09:12','2025-11-29 08:11:13','tempest-TaggedBootDevicesTest_v242-volume-611551478',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:31:11','2025-11-29 08:34:15','2025-11-29 08:34:16',1,'819403e4-4b9d-48a5-8cd5-1b913fa9f1ae',NULL,'5b0fe4d78df74554a3a5875ab629d59c','1981e9617628491f938ef0ef01c061c5','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:31:12','2025-11-29 08:31:13','2025-11-29 08:34:15','tempest-AttachVolumeTestJSON-volume-2077644601',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:19:11','2025-11-29 08:20:50','2025-11-29 08:20:50',1,'85297db0-ac85-44d1-bc74-6e4a332ee974',NULL,'697e5f10e07b4256a3dc2ad3906db9d2','696ec278f2ec426fa75ebb50bdf1c16a','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:19:11','2025-11-29 08:19:18','2025-11-29 08:20:50','tempest-tempest.common.compute-volume-118449145',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'reserved',NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:39:09','2025-11-29 08:40:42','2025-11-29 08:40:43',1,'86e515f3-ecb8-4e58-99f6-23e4d8ee3e76',NULL,'facf4db8501041ab9628ff9f5684c992','62ca01275fe34ea0af31d00b34d6d9a5','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:39:09','2025-11-29 08:39:09','2025-11-29 08:40:42','tempest-TestInstancesWithCinderVolumes-volume-988895589',NULL,NULL,NULL,NULL,'1df8de75-5537-417c-9507-97fa3907d96f',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:00:38','2025-11-29 08:03:07','2025-11-29 08:03:10',1,'87f35256-d25d-497d-b09f-e847b4302174',NULL,'ba1b423b724a47f692a3d9cbf91860d7','afaf65dfeab546ee991af0438784b8a3','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:00:38','2025-11-29 08:00:38','2025-11-29 08:03:07','tempest-UpdateMultiattachVolumeNegativeTest-volume-167566760',NULL,'{\"saved_features\":61}',NULL,NULL,'693bd8a6-9594-46ee-8a11-532b65e85c26',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:26:08','2025-11-29 08:27:57','2025-11-29 08:28:00',1,'8a80d4c0-d642-46d8-a891-79c20b955b6a',NULL,'873186539acb4bf9b90513e0e1beb56f','a9a83f8d8d7f4d08890407f978c05166','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:26:08','2025-11-29 08:26:08','2025-11-29 08:27:57','tempest-ServerStableDeviceRescueTest-volume-98294000',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:39:08','2025-11-29 08:40:38','2025-11-29 08:40:39',1,'8bde7127-007c-4f43-9a60-267c3b300611',NULL,'facf4db8501041ab9628ff9f5684c992','62ca01275fe34ea0af31d00b34d6d9a5','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:39:08','2025-11-29 08:39:09','2025-11-29 08:40:38','tempest-TestInstancesWithCinderVolumes-volume-1994123282',NULL,NULL,NULL,NULL,'6b67de39-187b-4ace-abba-ddc26b90da11',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 07:53:14','2025-11-29 07:53:48','2025-11-29 07:53:49',1,'8da13aec-bfc8-4fe1-b17e-45f2a3f532cf',NULL,'7f80aba0abfa403b80928e251377a7cd','ba323f7dc95a4f11911e6559a1b3c99e','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 07:53:14','2025-11-29 07:53:16','2025-11-29 07:53:48','tempest-VolumesAdminNegativeTest-volume-1411397383',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:18:44','2025-11-29 08:18:52','2025-11-29 08:18:52',1,'9924eb1b-f775-4059-a2c7-b5aea0bf8d30',NULL,'b48256fe29554511b25c2f5c20387645','8d6a508547b04ab19c5e5aa532a792a1','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:18:44','2025-11-29 08:18:44','2025-11-29 08:18:52','tempest-VolumesTestJSON-volume-661301324',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:43:24','2025-11-29 08:45:46','2025-11-29 08:45:47',1,'9aa47c29-8250-4a09-aa5f-08b05b14f1c9',NULL,'01c0b956e2c74d5798d01fc2be0a8bac','3b3b0484057a4e3db51366d29c6b684d','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:43:24','2025-11-29 08:43:24','2025-11-29 08:45:46','tempest-TestStampPattern-volume-1125887956',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:34:51','2025-11-29 08:35:18','2025-11-29 08:35:19',1,'9b4f6e7c-11e4-4465-94bc-84c3365ec3b9',NULL,'c5b0953fb7cc415fb26cf4ffdd5908c6','d4f6db81949d487b853d7567f8a2e6d4','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:34:51','2025-11-29 08:34:58','2025-11-29 08:35:18','tempest-AttachVolumeMultiAttachTest-volume-2022498381',NULL,'{\"saved_features\":61}',NULL,NULL,'693bd8a6-9594-46ee-8a11-532b65e85c26',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:27:41','2025-11-29 08:30:39',NULL,0,'a54a148c-90d3-4f80-83be-19de09d30ebc',NULL,'64b11a4dc36b4f55b85dbe846183be55','ae71059d02774857be85797a3be0e4e6','hostgroup@ceph#ceph',1,'nova','available','detached','2025-11-29 08:27:41','2025-11-29 08:27:41',NULL,'a0310268-d298-469e-9f04-6315f83c3f89-blank-vol','',NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:37:11','2025-11-29 08:38:36','2025-11-29 08:38:36',1,'a8b37ad1-e3f2-474d-a8f9-2676f112a82c',NULL,'bdbcdbdc435844ee8d866288c969331b','368e3a44279843f5947188dd045d65b6','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:37:11','2025-11-29 08:37:12','2025-11-29 08:38:36','tempest-AttachVolumeNegativeTest-volume-711515234',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 07:58:26','2025-11-29 07:59:09','2025-11-29 07:59:19',1,'ad8203ea-9ab4-445c-8faf-cf62075ec75c',NULL,'07c7f32f7d494f29b99afe2b074d0f68','4004f4fd97dd4d0e8e83dd715ffb8e9c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 07:58:26','2025-11-29 07:58:26','2025-11-29 07:59:09','tempest-AttachSCSIVolumeTestJSON-volume-668181380',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:29:41','2025-11-29 08:30:31',NULL,0,'afa6b782-fcc2-4a45-bde3-dbc6a832d5c6',NULL,'64b11a4dc36b4f55b85dbe846183be55','ae71059d02774857be85797a3be0e4e6','hostgroup@ceph#ceph',1,'nova','available','detached','2025-11-29 08:29:41','2025-11-29 08:29:53',NULL,'','',NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:33:47','2025-11-29 08:34:13','2025-11-29 08:34:14',1,'b180584d-b262-44fa-b3d3-a5cae1efac78',NULL,'5b0fe4d78df74554a3a5875ab629d59c','1981e9617628491f938ef0ef01c061c5','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:33:48','2025-11-29 08:33:48','2025-11-29 08:34:13','tempest-AttachVolumeTestJSON-volume-330496841',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:41:16','2025-11-29 08:41:18','2025-11-29 08:41:20',1,'bb9230ca-f8b6-4b0e-aa82-885958ef0172',NULL,'48c4f3f10bf249d5a724a70622e20291','0ccc70201c12433cba2c77f57171fc5a','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:41:16','2025-11-29 08:41:17','2025-11-29 08:41:18','tempest-VolumesGetTestJSON-Volume-1162108693',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:39:11','2025-11-29 08:41:33','2025-11-29 08:41:33',1,'bd3bcc0c-33d5-4f56-93b8-0804e2446b99',NULL,'facf4db8501041ab9628ff9f5684c992','62ca01275fe34ea0af31d00b34d6d9a5','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:39:11','2025-11-29 08:39:20','2025-11-29 08:41:33','tempest-TestInstancesWithCinderVolumes-volume-2130222043',NULL,NULL,NULL,NULL,'4a99b942-b940-4fde-b14d-3d1eca116a07',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:47:41','2025-11-29 08:49:46','2025-11-29 08:49:46',1,'bf7e0110-334f-4129-a24d-43eb68f20833',NULL,'b576a51181b5425aa6e44a0eb0a22803','b7ffcb23bac14ee49474df9aee5f7dae','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:47:41','2025-11-29 08:47:48','2025-11-29 08:49:46','tempest-TestVolumeBootPattern-volume-origin-1009765324',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:04:31','2025-11-29 08:08:10','2025-11-29 08:08:10',1,'c0dd2885-3214-46b3-a61c-f2d3eac073b6',NULL,'104aea18c5154615b602f032bdb49681','90c23935e0214785a9dc5061b91cf29c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:04:31','2025-11-29 08:04:31','2025-11-29 08:08:10','tempest-DeleteServersTestJSON-volume-1507899714',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:18:42','2025-11-29 08:18:53','2025-11-29 08:18:53',1,'c345e855-7bd5-4aa7-9a47-bac56b0be48c',NULL,'b48256fe29554511b25c2f5c20387645','8d6a508547b04ab19c5e5aa532a792a1','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:18:42','2025-11-29 08:18:43','2025-11-29 08:18:53','tempest-VolumesTestJSON-volume-863666099',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:51:38','2025-11-29 08:52:51','2025-11-29 08:52:52',1,'c95c9cac-92b7-4049-a506-241e7c32e9cd',NULL,'c3778685080b4955bd80ff7056a1c9f2','676f70280bf945cd90578b14202243e2','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:51:39','2025-11-29 08:51:54','2025-11-29 08:52:51','tempest-TestVolumeBackupRestore-volume-515131276',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:39:13','2025-11-29 08:41:31','2025-11-29 08:41:32',1,'c9cf1b4f-d920-4673-b1fc-8c791f56541b',NULL,'facf4db8501041ab9628ff9f5684c992','62ca01275fe34ea0af31d00b34d6d9a5','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:39:13','2025-11-29 08:39:20','2025-11-29 08:41:31','tempest-TestInstancesWithCinderVolumes-volume-1847455065',NULL,NULL,NULL,NULL,'4a99b942-b940-4fde-b14d-3d1eca116a07',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:21:46','2025-11-29 08:25:18','2025-11-29 08:25:19',1,'ca708729-36db-4dd2-9f09-88d87c483376',NULL,'1552f15deb524705a9456cbe9b54c429','0bace34c102e4d56b089fd695d324f10','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:21:46','2025-11-29 08:21:47','2025-11-29 08:25:18','tempest-ServerActionsTestOtherA-volume-2013518415',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:01:02','2025-11-29 08:01:54','2025-11-29 08:01:55',1,'cda8bfe0-3a4d-4d07-beb1-adb73b629321',NULL,'b37d614815064829b8372abbdbe8b3c4','a3c8b78b8a34400682bf8bbef740a22c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:01:02','2025-11-29 08:01:10','2025-11-29 08:01:54','tempest-tempest.common.compute-volume-1400931999',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:38:18','2025-11-29 08:38:33','2025-11-29 08:38:34',1,'ce79c491-0b98-4186-bc37-6c4796c913e1',NULL,'bdbcdbdc435844ee8d866288c969331b','368e3a44279843f5947188dd045d65b6','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:38:18','2025-11-29 08:38:18','2025-11-29 08:38:33','tempest-AttachVolumeNegativeTest-volume-475626607',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:36:50','2025-11-29 08:38:05','2025-11-29 08:38:06',1,'d0fba77f-63fd-4100-a2fb-b81bfa4b659a',NULL,'e8b20745b2d14f70b64a43335faed2f4','8d5e30b74e6449dd90ecb667977d1fe9','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:36:50','2025-11-29 08:36:50','2025-11-29 08:38:05','tempest-TestMinimumBasicScenario-volume-2033140579',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:33:11','2025-11-29 08:35:20','2025-11-29 08:35:20',1,'d51465d5-c782-4ab5-86e5-16500d7ed93e',NULL,'c5b0953fb7cc415fb26cf4ffdd5908c6','d4f6db81949d487b853d7567f8a2e6d4','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:33:11','2025-11-29 08:33:12','2025-11-29 08:35:20','tempest-AttachVolumeMultiAttachTest-volume-500920005',NULL,'{\"saved_features\":61}',NULL,NULL,'693bd8a6-9594-46ee-8a11-532b65e85c26',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:38:02','2025-11-29 08:40:54','2025-11-29 08:40:54',1,'d6f82ad4-8ec0-4138-9a4b-77fdefc17bbd',NULL,'eeba34466b8f4a1bb5f742f1e811053c','889608c71d13429fb37793575792ae74','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:38:02','2025-11-29 08:38:02','2025-11-29 08:40:54','tempest-AttachVolumeShelveTestJSON-volume-1686278705',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:23:35','2025-11-29 08:25:14','2025-11-29 08:25:14',1,'d807030f-7b93-4396-9211-17a740c6b338',NULL,'1552f15deb524705a9456cbe9b54c429','0bace34c102e4d56b089fd695d324f10','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:23:35','2025-11-29 08:23:42','2025-11-29 08:25:14','tempest-tempest.common.compute-volume-308585124',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 07:53:39','2025-11-29 07:53:40','2025-11-29 07:53:42',1,'dbd47277-1fd4-4e6c-ab7d-2b78cec995e8',NULL,'7f80aba0abfa403b80928e251377a7cd','ba323f7dc95a4f11911e6559a1b3c99e','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 07:53:39','2025-11-29 07:53:39','2025-11-29 07:53:40','tempest-VolumesAdminNegativeTest-volume-2029557964',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:39:09','2025-11-29 08:41:07','2025-11-29 08:41:08',1,'ddbdab48-23f2-48fc-bdd4-33793fe5d282',NULL,'facf4db8501041ab9628ff9f5684c992','62ca01275fe34ea0af31d00b34d6d9a5','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:39:09','2025-11-29 08:39:09','2025-11-29 08:41:07','tempest-TestInstancesWithCinderVolumes-volume-1555756605',NULL,NULL,NULL,NULL,'6b67de39-187b-4ace-abba-ddc26b90da11',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 07:54:04','2025-11-29 07:56:10','2025-11-29 07:56:11',1,'e52d8ac1-8970-4cf0-9aa0-795f616090d0',NULL,'b8f5b14bc98a47f29238140d1d3f1220','f91d373d1ef64146866ef08735a75efa','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 07:54:04','2025-11-29 07:54:14','2025-11-29 07:56:10','tempest-tempest.common.compute-volume-1012108512',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:13:30','2025-11-29 08:14:51','2025-11-29 08:14:52',1,'e6cdb61f-1c62-49d7-8d64-b8125afce54e',NULL,'90573489491c4659ba4a8ccbd6b896a7','b5f1f0d72cd0427a8cda48db244caf6c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:13:30','2025-11-29 08:13:30','2025-11-29 08:14:51','tempest-TaggedAttachmentsTest-volume-339566376',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 07:49:48','2025-11-29 07:51:26','2025-11-29 07:51:27',1,'e9658287-11e8-4a83-a391-d9089e1d2337',NULL,'87a8af2d3a924844ad3b9279035f79d6','93de83185bb14386b1526c79641f9a31','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 07:49:48','2025-11-29 07:49:50','2025-11-29 07:51:26','tempest-VolumesAssistedSnapshotsTest-volume-1326233932',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:15:39','2025-11-29 08:18:42','2025-11-29 08:18:44',1,'eb8b2675-ae0e-4130-a3f5-06bcfedbadc6',NULL,'c5e3ade3963d47be97b545b2e3779b6b','1b8899f76f554afc96bb2441424e5a77','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:15:39','2025-11-29 08:15:39','2025-11-29 08:18:42','tempest-ServerActionsTestOtherB-volume-337957217',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:34:37','2025-11-29 08:36:42','2025-11-29 08:36:43',1,'f5ef4a8f-7575-4b34-8ba3-715c1936b553',NULL,'a57807acb02b45d082f242ec62cd5b6f','96e72e7660da497a8b6bf9fdb03fe84c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:34:37','2025-11-29 08:34:38','2025-11-29 08:36:42','tempest-ServersNegativeTestJSON-volume-1902223900',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:39:09','2025-11-29 08:41:11','2025-11-29 08:41:11',1,'f8d3ed9a-0699-4f69-8315-0c8ebf96b12c',NULL,'facf4db8501041ab9628ff9f5684c992','62ca01275fe34ea0af31d00b34d6d9a5','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:39:09','2025-11-29 08:39:09','2025-11-29 08:41:11','tempest-TestInstancesWithCinderVolumes-volume-1248714466',NULL,NULL,NULL,NULL,'1df8de75-5537-417c-9507-97fa3907d96f',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:26:59','2025-11-29 08:28:52','2025-11-29 08:28:53',1,'f90f4e44-b3f5-446d-9049-bc8689808d12',NULL,'283f8136265e4425a5a31f840935b9ab','ea7b24ea9d7b4d239b4741634ac3f10c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:26:59','2025-11-29 08:26:59','2025-11-29 08:28:52','tempest-ServerRescueNegativeTestJSON-volume-834589437',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:18:46','2025-11-29 08:18:49','2025-11-29 08:18:50',1,'fa769f70-df1d-4fba-80e3-8ee051e19a1a',NULL,'b48256fe29554511b25c2f5c20387645','8d6a508547b04ab19c5e5aa532a792a1','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:18:46','2025-11-29 08:18:46','2025-11-29 08:18:49','tempest-VolumesTestJSON-volume-739287856',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:51:48','2025-11-29 08:52:52','2025-11-29 08:52:52',1,'fee77070-ed28-42d2-8e57-eb8da81862b4',NULL,'b576a51181b5425aa6e44a0eb0a22803','b7ffcb23bac14ee49474df9aee5f7dae','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:51:48','2025-11-29 08:51:49','2025-11-29 08:52:52','tempest-TestVolumeBootPattern-volume-1487151247',NULL,NULL,NULL,'d898cedb-1577-453e-a5a3-56529a2d305a','39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1),('2025-11-29 08:41:05','2025-11-29 08:41:10','2025-11-29 08:41:10',1,'ffeeb721-db06-432c-a16d-7bfb047e02d3',NULL,'24c3267183e24e99bbb30a96656a36e7','89fad883285a4255b3b35c445f93c900','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:41:05','2025-11-29 08:41:05','2025-11-29 08:41:10','tempest-VolumesSnapshotsTestJSON-volume-1256391276',NULL,NULL,NULL,NULL,'39d21972-2dc2-43ff-bc93-44dae17fa0f9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'2a3877af-b120-4190-9f49-352e1566fe8e',0,1);
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workers`
--

DROP TABLE IF EXISTS `workers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `workers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(40) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  `status` varchar(255) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_type` (`resource_type`,`resource_id`),
  KEY `ix_workers_service_id` (`service_id`),
  CONSTRAINT `workers_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=145 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workers`
--

LOCK TABLES `workers` WRITE;
/*!40000 ALTER TABLE `workers` DISABLE KEYS */;
INSERT INTO `workers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `resource_type`, `resource_id`, `status`, `service_id`, `race_preventer`) VALUES ('2025-11-29 06:55:38','2025-11-29 06:55:38.000123',NULL,0,1,'SENTINEL','SUB-SECOND','OK',NULL,0);
/*!40000 ALTER TABLE `workers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `glance`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `glance` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `glance`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('2023_1_contract01');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_locations`
--

DROP TABLE IF EXISTS `image_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `meta_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `ix_image_locations_deleted` (`deleted`),
  KEY `ix_image_locations_image_id` (`image_id`),
  CONSTRAINT `image_locations_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_locations`
--

LOCK TABLES `image_locations` WRITE;
/*!40000 ALTER TABLE `image_locations` DISABLE KEYS */;
INSERT INTO `image_locations` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `meta_data`, `status`) VALUES (1,'4873db8c-b414-4e95-acd9-77caabebe722','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/4873db8c-b414-4e95-acd9-77caabebe722/snap','2025-11-29 07:48:34','2025-11-29 07:48:34',NULL,0,'{\"store\": \"default_backend\"}','active'),(2,'93eccffb-bacd-407f-af6f-64451dee7b21','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/93eccffb-bacd-407f-af6f-64451dee7b21/snap','2025-11-29 07:48:41','2025-11-29 07:48:41',NULL,0,'{\"store\": \"default_backend\"}','active'),(3,'ca49c32b-cb06-40a8-be71-35eeb05e9ca2','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/ca49c32b-cb06-40a8-be71-35eeb05e9ca2/snap','2025-11-29 07:57:35','2025-11-29 07:59:08','2025-11-29 07:59:08',1,'{\"store\": \"default_backend\"}','deleted'),(4,'67d99282-8a43-4e0e-a784-9938a71f1f74','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/67d99282-8a43-4e0e-a784-9938a71f1f74/snap','2025-11-29 07:59:52','2025-11-29 08:00:01','2025-11-29 08:00:01',1,'{\"store\": \"default_backend\"}','deleted'),(5,'8b027c1d-b864-4b5a-a6b8-86f9eb11eb8a','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/8b027c1d-b864-4b5a-a6b8-86f9eb11eb8a/snap','2025-11-29 08:03:20','2025-11-29 08:03:41','2025-11-29 08:03:41',1,'{\"store\": \"default_backend\"}','deleted'),(6,'0cf2e679-5ab5-4c82-bff4-cafd6b290960','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/0cf2e679-5ab5-4c82-bff4-cafd6b290960/snap','2025-11-29 08:03:25','2025-11-29 08:04:50','2025-11-29 08:04:50',1,'{\"store\": \"default_backend\"}','deleted'),(7,'49df0a7c-7efb-4ede-af6c-1d3cec45987f','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/49df0a7c-7efb-4ede-af6c-1d3cec45987f/snap','2025-11-29 08:03:29','2025-11-29 08:04:48','2025-11-29 08:04:48',1,'{\"store\": \"default_backend\"}','deleted'),(8,'2108a514-c4e3-4d77-9b23-07f5f704a34d','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/2108a514-c4e3-4d77-9b23-07f5f704a34d/snap','2025-11-29 08:03:34','2025-11-29 08:04:46','2025-11-29 08:04:46',1,'{\"store\": \"default_backend\"}','deleted'),(9,'be6a1bec-5785-4873-ac75-fe1aa2fbc126','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/be6a1bec-5785-4873-ac75-fe1aa2fbc126/snap','2025-11-29 08:04:03','2025-11-29 08:04:37','2025-11-29 08:04:37',1,'{\"store\": \"default_backend\"}','deleted'),(10,'ecb74341-a505-46e6-a429-f2d9cba0e680','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/ecb74341-a505-46e6-a429-f2d9cba0e680/snap','2025-11-29 08:04:12','2025-11-29 08:04:36','2025-11-29 08:04:36',1,'{\"store\": \"default_backend\"}','deleted'),(11,'f84b19f0-6dcc-469f-91bc-16d537cf010a','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/f84b19f0-6dcc-469f-91bc-16d537cf010a/snap','2025-11-29 08:04:23','2025-11-29 08:04:34','2025-11-29 08:04:34',1,'{\"store\": \"default_backend\"}','deleted'),(12,'c44b1015-4b83-4a23-8199-4ab6d8120f18','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/c44b1015-4b83-4a23-8199-4ab6d8120f18/snap','2025-11-29 08:04:23','2025-11-29 08:04:26','2025-11-29 08:04:26',1,'{\"store\": \"default_backend\"}','deleted'),(13,'fea86ab8-1607-4850-b354-0a134f3e6647','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/fea86ab8-1607-4850-b354-0a134f3e6647/snap','2025-11-29 08:05:03','2025-11-29 08:05:06','2025-11-29 08:05:06',1,'{\"store\": \"default_backend\"}','deleted'),(14,'f6492822-3635-4784-934e-4aff1e94e9cf','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/f6492822-3635-4784-934e-4aff1e94e9cf/snap','2025-11-29 08:05:13','2025-11-29 08:05:25','2025-11-29 08:05:25',1,'{\"store\": \"default_backend\"}','deleted'),(15,'0bdf7515-c07e-4918-9c17-60eba424f483','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/0bdf7515-c07e-4918-9c17-60eba424f483/snap','2025-11-29 08:05:28','2025-11-29 08:05:31','2025-11-29 08:05:31',1,'{\"store\": \"default_backend\"}','deleted'),(16,'f953a29b-1cff-4723-9bbc-02d6d0bd3151','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/f953a29b-1cff-4723-9bbc-02d6d0bd3151/snap','2025-11-29 08:05:50','2025-11-29 08:06:06','2025-11-29 08:06:06',1,'{\"store\": \"default_backend\"}','deleted'),(17,'36c33ac0-d290-4825-8d63-52b362736e81','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/36c33ac0-d290-4825-8d63-52b362736e81/snap','2025-11-29 08:05:53','2025-11-29 08:06:04','2025-11-29 08:06:04',1,'{\"store\": \"default_backend\"}','deleted'),(18,'37d12ee4-89a4-499b-beea-6b6d4e46474b','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/37d12ee4-89a4-499b-beea-6b6d4e46474b/snap','2025-11-29 08:05:56','2025-11-29 08:06:18','2025-11-29 08:06:18',1,'{\"store\": \"default_backend\"}','deleted'),(19,'6a630c30-934b-49f9-92fa-38811e802998','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/6a630c30-934b-49f9-92fa-38811e802998/snap','2025-11-29 08:07:44','2025-11-29 08:07:47','2025-11-29 08:07:47',1,'{\"store\": \"default_backend\"}','deleted'),(20,'aa6ac671-fc8d-4598-a390-3f4d0b610d84','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/aa6ac671-fc8d-4598-a390-3f4d0b610d84/snap','2025-11-29 08:07:53','2025-11-29 08:07:57','2025-11-29 08:07:57',1,'{\"store\": \"default_backend\"}','deleted'),(21,'7e8836eb-bacd-485f-b61b-a89bcd8f6e84','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/7e8836eb-bacd-485f-b61b-a89bcd8f6e84/snap','2025-11-29 08:12:54','2025-11-29 08:13:14','2025-11-29 08:13:14',1,'{\"store\": \"default_backend\"}','deleted'),(22,'3c08af3e-7b9c-4dba-a2c8-3cba120c3814','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/3c08af3e-7b9c-4dba-a2c8-3cba120c3814/snap','2025-11-29 08:13:01','2025-11-29 08:13:18','2025-11-29 08:13:18',1,'{\"store\": \"default_backend\"}','deleted'),(23,'4e132098-a673-4ed7-8cfc-d67f77fc5495','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/4e132098-a673-4ed7-8cfc-d67f77fc5495/snap','2025-11-29 08:13:11','2025-11-29 08:13:17','2025-11-29 08:13:17',1,'{\"store\": \"default_backend\"}','deleted'),(24,'159b7691-923b-4bf5-a065-6be0cf4e75ba','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/159b7691-923b-4bf5-a065-6be0cf4e75ba/snap','2025-11-29 08:17:40','2025-11-29 08:18:34','2025-11-29 08:18:34',1,'{\"store\": \"default_backend\"}','deleted'),(25,'c28b4cfd-fa14-4a57-95be-5fa2d667ebc5','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/c28b4cfd-fa14-4a57-95be-5fa2d667ebc5/snap','2025-11-29 08:18:01','2025-11-29 08:18:29','2025-11-29 08:18:29',1,'{\"store\": \"default_backend\"}','deleted'),(26,'c5df7ff6-8c6a-4656-a8c2-618a39624a42','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/c5df7ff6-8c6a-4656-a8c2-618a39624a42/snap','2025-11-29 08:24:10','2025-11-29 08:28:19','2025-11-29 08:28:19',1,'{\"store\": \"default_backend\"}','deleted'),(27,'7462d96e-a79d-4947-a963-039652361944','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/7462d96e-a79d-4947-a963-039652361944/snap','2025-11-29 08:25:05','2025-11-29 08:28:09','2025-11-29 08:28:09',1,'{\"store\": \"default_backend\"}','deleted'),(28,'c73d83e2-0a3c-4e73-907f-124979a361df','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/c73d83e2-0a3c-4e73-907f-124979a361df/snap','2025-11-29 08:25:46','2025-11-29 08:28:02','2025-11-29 08:28:02',1,'{\"store\": \"default_backend\"}','deleted'),(29,'f5aee037-dd13-47e6-81af-147c317d7457','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/f5aee037-dd13-47e6-81af-147c317d7457/snap','2025-11-29 08:26:47','2025-11-29 08:27:46','2025-11-29 08:27:46',1,'{\"store\": \"default_backend\"}','deleted'),(30,'ff39bd0f-b544-46e3-a2c3-0aed51f8ff44','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/ff39bd0f-b544-46e3-a2c3-0aed51f8ff44/snap','2025-11-29 08:27:34','2025-11-29 08:30:42','2025-11-29 08:30:42',1,'{\"store\": \"default_backend\"}','deleted'),(31,'2d9af198-baca-4fb0-8bbb-100141aac9db','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/2d9af198-baca-4fb0-8bbb-100141aac9db/snap','2025-11-29 08:29:32','2025-11-29 08:30:33','2025-11-29 08:30:33',1,'{\"store\": \"default_backend\"}','deleted'),(32,'2ec96c0d-69b9-4690-b860-0f20dd8b17cd','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/2ec96c0d-69b9-4690-b860-0f20dd8b17cd/snap','2025-11-29 08:35:13','2025-11-29 08:35:19','2025-11-29 08:35:19',1,'{\"store\": \"default_backend\"}','deleted'),(33,'f502084d-e717-47c5-8881-072bf335e491','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/f502084d-e717-47c5-8881-072bf335e491/snap','2025-11-29 08:35:41','2025-11-29 08:36:15','2025-11-29 08:36:15',1,'{\"store\": \"default_backend\"}','deleted'),(34,'8a30eb6e-dddc-4108-8576-dcd7c8d5406f','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/8a30eb6e-dddc-4108-8576-dcd7c8d5406f/snap','2025-11-29 08:36:33','2025-11-29 08:38:13','2025-11-29 08:38:13',1,'{\"store\": \"default_backend\"}','deleted'),(35,'c373ab38-0e65-4d5c-bf51-8234f0ed5ffd','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/c373ab38-0e65-4d5c-bf51-8234f0ed5ffd/snap','2025-11-29 08:38:13','2025-11-29 08:38:34','2025-11-29 08:38:34',1,'{\"store\": \"default_backend\"}','deleted'),(36,'91e66a4f-7b40-4f67-810c-3642968fad68','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/91e66a4f-7b40-4f67-810c-3642968fad68/snap','2025-11-29 08:38:15','2025-11-29 08:39:57','2025-11-29 08:39:57',1,'{\"store\": \"default_backend\"}','deleted'),(37,'10bcdd0b-a9bb-4ca1-8d7b-e11af81db4ec','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/10bcdd0b-a9bb-4ca1-8d7b-e11af81db4ec/snap','2025-11-29 08:39:07','2025-11-29 08:41:38','2025-11-29 08:41:38',1,'{\"store\": \"default_backend\"}','deleted'),(38,'eb8dd751-ecc7-464b-8f9f-4f4d38e755cf','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/eb8dd751-ecc7-464b-8f9f-4f4d38e755cf/snap','2025-11-29 08:39:53','2025-11-29 08:40:14','2025-11-29 08:40:14',1,'{\"store\": \"default_backend\"}','deleted'),(39,'19c04997-1e5f-42a9-90ff-a53c93a49ed0','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/19c04997-1e5f-42a9-90ff-a53c93a49ed0/snap','2025-11-29 08:44:28','2025-11-29 08:45:35','2025-11-29 08:45:35',1,'{\"store\": \"default_backend\"}','deleted'),(40,'a9d624a0-fd76-47d0-81ab-f89f80fec0c1','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/a9d624a0-fd76-47d0-81ab-f89f80fec0c1/snap','2025-11-29 08:44:28','2025-11-29 08:45:37','2025-11-29 08:45:37',1,'{\"store\": \"default_backend\"}','deleted'),(41,'ea9de80a-851e-4cb9-ab40-64d7952ffbd1','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/ea9de80a-851e-4cb9-ab40-64d7952ffbd1/snap','2025-11-29 08:45:26','2025-11-29 08:45:28','2025-11-29 08:45:28',1,'{\"store\": \"default_backend\"}','deleted'),(42,'e21e97a9-475e-4ed4-bd3f-ad8000b59f07','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/e21e97a9-475e-4ed4-bd3f-ad8000b59f07/snap','2025-11-29 08:48:06','2025-11-29 08:48:24','2025-11-29 08:48:24',1,'{\"store\": \"default_backend\"}','deleted'),(43,'ad73a146-3d66-454f-a206-ab6de9891225','rbd://b66774a7-56d9-5535-bd8c-681234404870/images/ad73a146-3d66-454f-a206-ab6de9891225/snap','2025-11-29 08:48:44','2025-11-29 08:49:50','2025-11-29 08:49:50',1,'{\"store\": \"default_backend\"}','deleted');
/*!40000 ALTER TABLE `image_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_members`
--

DROP TABLE IF EXISTS `image_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `member` varchar(255) NOT NULL,
  `can_share` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image_members_image_id_member_deleted_at_key` (`image_id`,`member`,`deleted_at`),
  KEY `ix_image_members_deleted` (`deleted`),
  KEY `ix_image_members_image_id` (`image_id`),
  KEY `ix_image_members_image_id_member` (`image_id`,`member`),
  CONSTRAINT `image_members_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`can_share` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_members`
--

LOCK TABLES `image_members` WRITE;
/*!40000 ALTER TABLE `image_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_properties`
--

DROP TABLE IF EXISTS `image_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_image_properties_image_id_name` (`image_id`,`name`),
  KEY `ix_image_properties_deleted` (`deleted`),
  KEY `ix_image_properties_image_id` (`image_id`),
  CONSTRAINT `image_properties_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=661 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_properties`
--

LOCK TABLES `image_properties` WRITE;
/*!40000 ALTER TABLE `image_properties` DISABLE KEYS */;
INSERT INTO `image_properties` (`id`, `image_id`, `name`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'4873db8c-b414-4e95-acd9-77caabebe722','hw_rng_model','virtio','2025-11-29 07:48:23','2025-11-29 07:48:23',NULL,0),(2,'93eccffb-bacd-407f-af6f-64451dee7b21','hw_rng_model','virtio','2025-11-29 07:48:36','2025-11-29 07:48:36',NULL,0),(3,'ca49c32b-cb06-40a8-be71-35eeb05e9ca2','hw_scsi_model','virtio-scsi','2025-11-29 07:57:33','2025-11-29 07:59:08','2025-11-29 07:59:08',1),(4,'ca49c32b-cb06-40a8-be71-35eeb05e9ca2','hw_disk_bus','scsi','2025-11-29 07:57:33','2025-11-29 07:59:08','2025-11-29 07:59:08',1),(5,'ca49c32b-cb06-40a8-be71-35eeb05e9ca2','hw_cdrom_bus','scsi','2025-11-29 07:57:33','2025-11-29 07:59:08','2025-11-29 07:59:08',1),(6,'8b027c1d-b864-4b5a-a6b8-86f9eb11eb8a','os_distro','value2','2025-11-29 08:03:22','2025-11-29 08:03:41','2025-11-29 08:03:41',1),(7,'8b027c1d-b864-4b5a-a6b8-86f9eb11eb8a','os_version','alt1','2025-11-29 08:03:22','2025-11-29 08:03:41','2025-11-29 08:03:41',1),(8,'8b027c1d-b864-4b5a-a6b8-86f9eb11eb8a','architecture','value3','2025-11-29 08:03:29','2025-11-29 08:03:41','2025-11-29 08:03:41',1),(9,'be6a1bec-5785-4873-ac75-fe1aa2fbc126','hw_rng_model','virtio','2025-11-29 08:03:49','2025-11-29 08:04:37','2025-11-29 08:04:37',1),(10,'be6a1bec-5785-4873-ac75-fe1aa2fbc126','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:03:49','2025-11-29 08:04:37','2025-11-29 08:04:37',1),(11,'be6a1bec-5785-4873-ac75-fe1aa2fbc126','owner_user_name','tempest-ListImageFiltersTestJSON-262348058-project-member','2025-11-29 08:03:49','2025-11-29 08:04:37','2025-11-29 08:04:37',1),(12,'be6a1bec-5785-4873-ac75-fe1aa2fbc126','owner_project_name','tempest-ListImageFiltersTestJSON-262348058','2025-11-29 08:03:49','2025-11-29 08:04:37','2025-11-29 08:04:37',1),(13,'be6a1bec-5785-4873-ac75-fe1aa2fbc126','boot_roles','reader,member','2025-11-29 08:03:49','2025-11-29 08:04:37','2025-11-29 08:04:37',1),(14,'be6a1bec-5785-4873-ac75-fe1aa2fbc126','hw_machine_type','q35','2025-11-29 08:03:49','2025-11-29 08:04:37','2025-11-29 08:04:37',1),(15,'be6a1bec-5785-4873-ac75-fe1aa2fbc126','hw_cdrom_bus','sata','2025-11-29 08:03:49','2025-11-29 08:04:37','2025-11-29 08:04:37',1),(16,'be6a1bec-5785-4873-ac75-fe1aa2fbc126','hw_disk_bus','virtio','2025-11-29 08:03:49','2025-11-29 08:04:37','2025-11-29 08:04:37',1),(17,'be6a1bec-5785-4873-ac75-fe1aa2fbc126','hw_input_bus','usb','2025-11-29 08:03:49','2025-11-29 08:04:37','2025-11-29 08:04:37',1),(18,'be6a1bec-5785-4873-ac75-fe1aa2fbc126','hw_pointer_model','usbtablet','2025-11-29 08:03:49','2025-11-29 08:04:37','2025-11-29 08:04:37',1),(19,'be6a1bec-5785-4873-ac75-fe1aa2fbc126','hw_video_model','virtio','2025-11-29 08:03:49','2025-11-29 08:04:37','2025-11-29 08:04:37',1),(20,'be6a1bec-5785-4873-ac75-fe1aa2fbc126','hw_vif_model','virtio','2025-11-29 08:03:49','2025-11-29 08:04:37','2025-11-29 08:04:37',1),(21,'be6a1bec-5785-4873-ac75-fe1aa2fbc126','instance_uuid','885925d1-baac-4205-8817-4d9b92b082de','2025-11-29 08:03:49','2025-11-29 08:04:37','2025-11-29 08:04:37',1),(22,'be6a1bec-5785-4873-ac75-fe1aa2fbc126','user_id','e34525c38d50445e9771f1b8e18bc428','2025-11-29 08:03:49','2025-11-29 08:04:37','2025-11-29 08:04:37',1),(23,'be6a1bec-5785-4873-ac75-fe1aa2fbc126','image_type','snapshot','2025-11-29 08:03:49','2025-11-29 08:04:37','2025-11-29 08:04:37',1),(24,'be6a1bec-5785-4873-ac75-fe1aa2fbc126','owner_id','1a7ab40578b84f6aa0f4d2225a36bf9e','2025-11-29 08:04:00','2025-11-29 08:04:37','2025-11-29 08:04:37',1),(25,'be6a1bec-5785-4873-ac75-fe1aa2fbc126','image_state','available','2025-11-29 08:04:00','2025-11-29 08:04:37','2025-11-29 08:04:37',1),(26,'be6a1bec-5785-4873-ac75-fe1aa2fbc126','image_location','snapshot','2025-11-29 08:04:00','2025-11-29 08:04:37','2025-11-29 08:04:37',1),(27,'ecb74341-a505-46e6-a429-f2d9cba0e680','hw_rng_model','virtio','2025-11-29 08:04:05','2025-11-29 08:04:36','2025-11-29 08:04:36',1),(28,'ecb74341-a505-46e6-a429-f2d9cba0e680','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:04:05','2025-11-29 08:04:36','2025-11-29 08:04:36',1),(29,'ecb74341-a505-46e6-a429-f2d9cba0e680','owner_user_name','tempest-ListImageFiltersTestJSON-262348058-project-member','2025-11-29 08:04:05','2025-11-29 08:04:36','2025-11-29 08:04:36',1),(30,'ecb74341-a505-46e6-a429-f2d9cba0e680','owner_project_name','tempest-ListImageFiltersTestJSON-262348058','2025-11-29 08:04:05','2025-11-29 08:04:36','2025-11-29 08:04:36',1),(31,'ecb74341-a505-46e6-a429-f2d9cba0e680','boot_roles','reader,member','2025-11-29 08:04:05','2025-11-29 08:04:36','2025-11-29 08:04:36',1),(32,'ecb74341-a505-46e6-a429-f2d9cba0e680','hw_machine_type','q35','2025-11-29 08:04:05','2025-11-29 08:04:36','2025-11-29 08:04:36',1),(33,'ecb74341-a505-46e6-a429-f2d9cba0e680','hw_cdrom_bus','sata','2025-11-29 08:04:05','2025-11-29 08:04:36','2025-11-29 08:04:36',1),(34,'ecb74341-a505-46e6-a429-f2d9cba0e680','hw_disk_bus','virtio','2025-11-29 08:04:05','2025-11-29 08:04:36','2025-11-29 08:04:36',1),(35,'ecb74341-a505-46e6-a429-f2d9cba0e680','hw_input_bus','usb','2025-11-29 08:04:05','2025-11-29 08:04:36','2025-11-29 08:04:36',1),(36,'ecb74341-a505-46e6-a429-f2d9cba0e680','hw_pointer_model','usbtablet','2025-11-29 08:04:05','2025-11-29 08:04:36','2025-11-29 08:04:36',1),(37,'ecb74341-a505-46e6-a429-f2d9cba0e680','hw_video_model','virtio','2025-11-29 08:04:05','2025-11-29 08:04:36','2025-11-29 08:04:36',1),(38,'ecb74341-a505-46e6-a429-f2d9cba0e680','hw_vif_model','virtio','2025-11-29 08:04:05','2025-11-29 08:04:36','2025-11-29 08:04:36',1),(39,'ecb74341-a505-46e6-a429-f2d9cba0e680','instance_uuid','1585e4de-af24-40bc-8d7d-d715357a957c','2025-11-29 08:04:05','2025-11-29 08:04:36','2025-11-29 08:04:36',1),(40,'ecb74341-a505-46e6-a429-f2d9cba0e680','user_id','e34525c38d50445e9771f1b8e18bc428','2025-11-29 08:04:05','2025-11-29 08:04:36','2025-11-29 08:04:36',1),(41,'ecb74341-a505-46e6-a429-f2d9cba0e680','image_type','snapshot','2025-11-29 08:04:05','2025-11-29 08:04:36','2025-11-29 08:04:36',1),(42,'ecb74341-a505-46e6-a429-f2d9cba0e680','owner_id','1a7ab40578b84f6aa0f4d2225a36bf9e','2025-11-29 08:04:10','2025-11-29 08:04:36','2025-11-29 08:04:36',1),(43,'ecb74341-a505-46e6-a429-f2d9cba0e680','image_state','available','2025-11-29 08:04:10','2025-11-29 08:04:36','2025-11-29 08:04:36',1),(44,'ecb74341-a505-46e6-a429-f2d9cba0e680','image_location','snapshot','2025-11-29 08:04:10','2025-11-29 08:04:36','2025-11-29 08:04:36',1),(45,'f84b19f0-6dcc-469f-91bc-16d537cf010a','hw_rng_model','virtio','2025-11-29 08:04:14','2025-11-29 08:04:34','2025-11-29 08:04:34',1),(46,'f84b19f0-6dcc-469f-91bc-16d537cf010a','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:04:14','2025-11-29 08:04:34','2025-11-29 08:04:34',1),(47,'f84b19f0-6dcc-469f-91bc-16d537cf010a','owner_user_name','tempest-ListImageFiltersTestJSON-262348058-project-member','2025-11-29 08:04:14','2025-11-29 08:04:34','2025-11-29 08:04:34',1),(48,'f84b19f0-6dcc-469f-91bc-16d537cf010a','owner_project_name','tempest-ListImageFiltersTestJSON-262348058','2025-11-29 08:04:14','2025-11-29 08:04:34','2025-11-29 08:04:34',1),(49,'f84b19f0-6dcc-469f-91bc-16d537cf010a','boot_roles','reader,member','2025-11-29 08:04:14','2025-11-29 08:04:34','2025-11-29 08:04:34',1),(50,'f84b19f0-6dcc-469f-91bc-16d537cf010a','hw_machine_type','q35','2025-11-29 08:04:14','2025-11-29 08:04:34','2025-11-29 08:04:34',1),(51,'f84b19f0-6dcc-469f-91bc-16d537cf010a','hw_cdrom_bus','sata','2025-11-29 08:04:14','2025-11-29 08:04:34','2025-11-29 08:04:34',1),(52,'f84b19f0-6dcc-469f-91bc-16d537cf010a','hw_disk_bus','virtio','2025-11-29 08:04:14','2025-11-29 08:04:34','2025-11-29 08:04:34',1),(53,'f84b19f0-6dcc-469f-91bc-16d537cf010a','hw_input_bus','usb','2025-11-29 08:04:14','2025-11-29 08:04:34','2025-11-29 08:04:34',1),(54,'f84b19f0-6dcc-469f-91bc-16d537cf010a','hw_pointer_model','usbtablet','2025-11-29 08:04:14','2025-11-29 08:04:34','2025-11-29 08:04:34',1),(55,'f84b19f0-6dcc-469f-91bc-16d537cf010a','hw_video_model','virtio','2025-11-29 08:04:14','2025-11-29 08:04:34','2025-11-29 08:04:34',1),(56,'f84b19f0-6dcc-469f-91bc-16d537cf010a','hw_vif_model','virtio','2025-11-29 08:04:14','2025-11-29 08:04:34','2025-11-29 08:04:34',1),(57,'f84b19f0-6dcc-469f-91bc-16d537cf010a','instance_uuid','885925d1-baac-4205-8817-4d9b92b082de','2025-11-29 08:04:14','2025-11-29 08:04:34','2025-11-29 08:04:34',1),(58,'f84b19f0-6dcc-469f-91bc-16d537cf010a','user_id','e34525c38d50445e9771f1b8e18bc428','2025-11-29 08:04:14','2025-11-29 08:04:34','2025-11-29 08:04:34',1),(59,'f84b19f0-6dcc-469f-91bc-16d537cf010a','image_type','snapshot','2025-11-29 08:04:14','2025-11-29 08:04:34','2025-11-29 08:04:34',1),(60,'c44b1015-4b83-4a23-8199-4ab6d8120f18','hw_rng_model','virtio','2025-11-29 08:04:17','2025-11-29 08:04:26','2025-11-29 08:04:26',1),(61,'c44b1015-4b83-4a23-8199-4ab6d8120f18','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:04:17','2025-11-29 08:04:26','2025-11-29 08:04:26',1),(62,'c44b1015-4b83-4a23-8199-4ab6d8120f18','owner_user_name','tempest-ImagesTestJSON-1682881466-project-member','2025-11-29 08:04:17','2025-11-29 08:04:26','2025-11-29 08:04:26',1),(63,'c44b1015-4b83-4a23-8199-4ab6d8120f18','owner_project_name','tempest-ImagesTestJSON-1682881466','2025-11-29 08:04:17','2025-11-29 08:04:26','2025-11-29 08:04:26',1),(64,'c44b1015-4b83-4a23-8199-4ab6d8120f18','boot_roles','member,reader','2025-11-29 08:04:17','2025-11-29 08:04:26','2025-11-29 08:04:26',1),(65,'c44b1015-4b83-4a23-8199-4ab6d8120f18','hw_machine_type','q35','2025-11-29 08:04:17','2025-11-29 08:04:26','2025-11-29 08:04:26',1),(66,'c44b1015-4b83-4a23-8199-4ab6d8120f18','hw_cdrom_bus','sata','2025-11-29 08:04:17','2025-11-29 08:04:26','2025-11-29 08:04:26',1),(67,'c44b1015-4b83-4a23-8199-4ab6d8120f18','hw_disk_bus','virtio','2025-11-29 08:04:17','2025-11-29 08:04:26','2025-11-29 08:04:26',1),(68,'c44b1015-4b83-4a23-8199-4ab6d8120f18','hw_input_bus','usb','2025-11-29 08:04:17','2025-11-29 08:04:26','2025-11-29 08:04:26',1),(69,'c44b1015-4b83-4a23-8199-4ab6d8120f18','hw_pointer_model','usbtablet','2025-11-29 08:04:17','2025-11-29 08:04:26','2025-11-29 08:04:26',1),(70,'c44b1015-4b83-4a23-8199-4ab6d8120f18','hw_video_model','virtio','2025-11-29 08:04:17','2025-11-29 08:04:26','2025-11-29 08:04:26',1),(71,'c44b1015-4b83-4a23-8199-4ab6d8120f18','hw_vif_model','virtio','2025-11-29 08:04:17','2025-11-29 08:04:26','2025-11-29 08:04:26',1),(72,'c44b1015-4b83-4a23-8199-4ab6d8120f18','instance_uuid','d3837ff2-ce61-4144-ac9b-c032a188450a','2025-11-29 08:04:17','2025-11-29 08:04:26','2025-11-29 08:04:26',1),(73,'c44b1015-4b83-4a23-8199-4ab6d8120f18','user_id','fddc5f5801764ee19d5253e2cab34df3','2025-11-29 08:04:17','2025-11-29 08:04:26','2025-11-29 08:04:26',1),(74,'c44b1015-4b83-4a23-8199-4ab6d8120f18','image_type','snapshot','2025-11-29 08:04:17','2025-11-29 08:04:26','2025-11-29 08:04:26',1),(75,'f84b19f0-6dcc-469f-91bc-16d537cf010a','owner_id','1a7ab40578b84f6aa0f4d2225a36bf9e','2025-11-29 08:04:22','2025-11-29 08:04:34','2025-11-29 08:04:34',1),(76,'f84b19f0-6dcc-469f-91bc-16d537cf010a','image_state','available','2025-11-29 08:04:22','2025-11-29 08:04:34','2025-11-29 08:04:34',1),(77,'f84b19f0-6dcc-469f-91bc-16d537cf010a','image_location','snapshot','2025-11-29 08:04:22','2025-11-29 08:04:34','2025-11-29 08:04:34',1),(78,'c44b1015-4b83-4a23-8199-4ab6d8120f18','image_location','snapshot','2025-11-29 08:04:23','2025-11-29 08:04:26','2025-11-29 08:04:26',1),(79,'c44b1015-4b83-4a23-8199-4ab6d8120f18','owner_id','638fd52fccf14f16b56d0860553063f3','2025-11-29 08:04:23','2025-11-29 08:04:26','2025-11-29 08:04:26',1),(80,'c44b1015-4b83-4a23-8199-4ab6d8120f18','image_state','available','2025-11-29 08:04:23','2025-11-29 08:04:26','2025-11-29 08:04:26',1),(81,'f6492822-3635-4784-934e-4aff1e94e9cf','hw_rng_model','virtio','2025-11-29 08:04:55','2025-11-29 08:05:25','2025-11-29 08:05:25',1),(82,'f6492822-3635-4784-934e-4aff1e94e9cf','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:04:55','2025-11-29 08:05:25','2025-11-29 08:05:25',1),(83,'f6492822-3635-4784-934e-4aff1e94e9cf','owner_user_name','tempest-UnshelveToHostMultiNodesTest-1345262936-project-member','2025-11-29 08:04:55','2025-11-29 08:05:25','2025-11-29 08:05:25',1),(84,'f6492822-3635-4784-934e-4aff1e94e9cf','owner_project_name','tempest-UnshelveToHostMultiNodesTest-1345262936','2025-11-29 08:04:55','2025-11-29 08:05:25','2025-11-29 08:05:25',1),(85,'f6492822-3635-4784-934e-4aff1e94e9cf','boot_roles','reader,member','2025-11-29 08:04:55','2025-11-29 08:05:25','2025-11-29 08:05:25',1),(86,'f6492822-3635-4784-934e-4aff1e94e9cf','hw_machine_type','q35','2025-11-29 08:04:55','2025-11-29 08:05:25','2025-11-29 08:05:25',1),(87,'f6492822-3635-4784-934e-4aff1e94e9cf','hw_cdrom_bus','sata','2025-11-29 08:04:55','2025-11-29 08:05:25','2025-11-29 08:05:25',1),(88,'f6492822-3635-4784-934e-4aff1e94e9cf','hw_disk_bus','virtio','2025-11-29 08:04:55','2025-11-29 08:05:25','2025-11-29 08:05:25',1),(89,'f6492822-3635-4784-934e-4aff1e94e9cf','hw_input_bus','usb','2025-11-29 08:04:55','2025-11-29 08:05:25','2025-11-29 08:05:25',1),(90,'f6492822-3635-4784-934e-4aff1e94e9cf','hw_pointer_model','usbtablet','2025-11-29 08:04:55','2025-11-29 08:05:25','2025-11-29 08:05:25',1),(91,'f6492822-3635-4784-934e-4aff1e94e9cf','hw_video_model','virtio','2025-11-29 08:04:55','2025-11-29 08:05:25','2025-11-29 08:05:25',1),(92,'f6492822-3635-4784-934e-4aff1e94e9cf','hw_vif_model','virtio','2025-11-29 08:04:55','2025-11-29 08:05:25','2025-11-29 08:05:25',1),(93,'f6492822-3635-4784-934e-4aff1e94e9cf','instance_uuid','59628432-68dc-48d9-8986-8511c376a62d','2025-11-29 08:04:55','2025-11-29 08:05:25','2025-11-29 08:05:25',1),(94,'f6492822-3635-4784-934e-4aff1e94e9cf','user_id','dc44b9aeabb442f582688b672dd724f3','2025-11-29 08:04:55','2025-11-29 08:05:25','2025-11-29 08:05:25',1),(95,'f6492822-3635-4784-934e-4aff1e94e9cf','image_type','snapshot','2025-11-29 08:04:55','2025-11-29 08:05:25','2025-11-29 08:05:25',1),(96,'fea86ab8-1607-4850-b354-0a134f3e6647','hw_rng_model','virtio','2025-11-29 08:04:58','2025-11-29 08:05:06','2025-11-29 08:05:06',1),(97,'fea86ab8-1607-4850-b354-0a134f3e6647','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:04:58','2025-11-29 08:05:06','2025-11-29 08:05:06',1),(98,'fea86ab8-1607-4850-b354-0a134f3e6647','owner_user_name','tempest-ImagesTestJSON-1682881466-project-member','2025-11-29 08:04:58','2025-11-29 08:05:06','2025-11-29 08:05:06',1),(99,'fea86ab8-1607-4850-b354-0a134f3e6647','owner_project_name','tempest-ImagesTestJSON-1682881466','2025-11-29 08:04:58','2025-11-29 08:05:06','2025-11-29 08:05:06',1),(100,'fea86ab8-1607-4850-b354-0a134f3e6647','boot_roles','member,reader','2025-11-29 08:04:58','2025-11-29 08:05:06','2025-11-29 08:05:06',1),(101,'fea86ab8-1607-4850-b354-0a134f3e6647','hw_machine_type','q35','2025-11-29 08:04:58','2025-11-29 08:05:06','2025-11-29 08:05:06',1),(102,'fea86ab8-1607-4850-b354-0a134f3e6647','hw_cdrom_bus','sata','2025-11-29 08:04:58','2025-11-29 08:05:06','2025-11-29 08:05:06',1),(103,'fea86ab8-1607-4850-b354-0a134f3e6647','hw_disk_bus','virtio','2025-11-29 08:04:58','2025-11-29 08:05:06','2025-11-29 08:05:06',1),(104,'fea86ab8-1607-4850-b354-0a134f3e6647','hw_input_bus','usb','2025-11-29 08:04:58','2025-11-29 08:05:06','2025-11-29 08:05:06',1),(105,'fea86ab8-1607-4850-b354-0a134f3e6647','hw_pointer_model','usbtablet','2025-11-29 08:04:58','2025-11-29 08:05:06','2025-11-29 08:05:06',1),(106,'fea86ab8-1607-4850-b354-0a134f3e6647','hw_video_model','virtio','2025-11-29 08:04:58','2025-11-29 08:05:06','2025-11-29 08:05:06',1),(107,'fea86ab8-1607-4850-b354-0a134f3e6647','hw_vif_model','virtio','2025-11-29 08:04:58','2025-11-29 08:05:06','2025-11-29 08:05:06',1),(108,'fea86ab8-1607-4850-b354-0a134f3e6647','instance_uuid','d9ae79a9-263e-4f0c-8538-a4f6b99a3cfa','2025-11-29 08:04:58','2025-11-29 08:05:06','2025-11-29 08:05:06',1),(109,'fea86ab8-1607-4850-b354-0a134f3e6647','user_id','fddc5f5801764ee19d5253e2cab34df3','2025-11-29 08:04:58','2025-11-29 08:05:06','2025-11-29 08:05:06',1),(110,'fea86ab8-1607-4850-b354-0a134f3e6647','image_type','snapshot','2025-11-29 08:04:58','2025-11-29 08:05:06','2025-11-29 08:05:06',1),(111,'fea86ab8-1607-4850-b354-0a134f3e6647','image_location','snapshot','2025-11-29 08:05:02','2025-11-29 08:05:06','2025-11-29 08:05:06',1),(112,'fea86ab8-1607-4850-b354-0a134f3e6647','owner_id','638fd52fccf14f16b56d0860553063f3','2025-11-29 08:05:02','2025-11-29 08:05:06','2025-11-29 08:05:06',1),(113,'fea86ab8-1607-4850-b354-0a134f3e6647','image_state','available','2025-11-29 08:05:02','2025-11-29 08:05:06','2025-11-29 08:05:06',1),(114,'f6492822-3635-4784-934e-4aff1e94e9cf','owner_id','49ee945ea42e47ad9f070078a4d5179b','2025-11-29 08:05:13','2025-11-29 08:05:25','2025-11-29 08:05:25',1),(115,'f6492822-3635-4784-934e-4aff1e94e9cf','image_state','available','2025-11-29 08:05:13','2025-11-29 08:05:25','2025-11-29 08:05:25',1),(116,'f6492822-3635-4784-934e-4aff1e94e9cf','image_location','snapshot','2025-11-29 08:05:13','2025-11-29 08:05:25','2025-11-29 08:05:25',1),(117,'36c33ac0-d290-4825-8d63-52b362736e81','hw_rng_model','virtio','2025-11-29 08:05:18','2025-11-29 08:06:04','2025-11-29 08:06:04',1),(118,'36c33ac0-d290-4825-8d63-52b362736e81','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:05:18','2025-11-29 08:06:04','2025-11-29 08:06:04',1),(119,'36c33ac0-d290-4825-8d63-52b362736e81','owner_user_name','tempest-DeleteServersTestJSON-294503786-project-member','2025-11-29 08:05:18','2025-11-29 08:06:04','2025-11-29 08:06:04',1),(120,'36c33ac0-d290-4825-8d63-52b362736e81','owner_project_name','tempest-DeleteServersTestJSON-294503786','2025-11-29 08:05:18','2025-11-29 08:06:04','2025-11-29 08:06:04',1),(121,'36c33ac0-d290-4825-8d63-52b362736e81','boot_roles','reader,member','2025-11-29 08:05:18','2025-11-29 08:06:04','2025-11-29 08:06:04',1),(122,'36c33ac0-d290-4825-8d63-52b362736e81','hw_machine_type','q35','2025-11-29 08:05:18','2025-11-29 08:06:04','2025-11-29 08:06:04',1),(123,'36c33ac0-d290-4825-8d63-52b362736e81','hw_cdrom_bus','sata','2025-11-29 08:05:18','2025-11-29 08:06:04','2025-11-29 08:06:04',1),(124,'36c33ac0-d290-4825-8d63-52b362736e81','hw_disk_bus','virtio','2025-11-29 08:05:18','2025-11-29 08:06:04','2025-11-29 08:06:04',1),(125,'36c33ac0-d290-4825-8d63-52b362736e81','hw_input_bus','usb','2025-11-29 08:05:18','2025-11-29 08:06:04','2025-11-29 08:06:04',1),(126,'36c33ac0-d290-4825-8d63-52b362736e81','hw_pointer_model','usbtablet','2025-11-29 08:05:18','2025-11-29 08:06:04','2025-11-29 08:06:04',1),(127,'36c33ac0-d290-4825-8d63-52b362736e81','hw_video_model','virtio','2025-11-29 08:05:18','2025-11-29 08:06:04','2025-11-29 08:06:04',1),(128,'36c33ac0-d290-4825-8d63-52b362736e81','hw_vif_model','virtio','2025-11-29 08:05:18','2025-11-29 08:06:04','2025-11-29 08:06:04',1),(129,'36c33ac0-d290-4825-8d63-52b362736e81','instance_uuid','afe3bf93-f54a-4a11-8f71-87b27ee7290a','2025-11-29 08:05:18','2025-11-29 08:06:04','2025-11-29 08:06:04',1),(130,'36c33ac0-d290-4825-8d63-52b362736e81','user_id','104aea18c5154615b602f032bdb49681','2025-11-29 08:05:18','2025-11-29 08:06:04','2025-11-29 08:06:04',1),(131,'36c33ac0-d290-4825-8d63-52b362736e81','image_type','snapshot','2025-11-29 08:05:18','2025-11-29 08:06:04','2025-11-29 08:06:04',1),(132,'0bdf7515-c07e-4918-9c17-60eba424f483','hw_rng_model','virtio','2025-11-29 08:05:21','2025-11-29 08:05:31','2025-11-29 08:05:31',1),(133,'0bdf7515-c07e-4918-9c17-60eba424f483','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:05:21','2025-11-29 08:05:31','2025-11-29 08:05:31',1),(134,'0bdf7515-c07e-4918-9c17-60eba424f483','owner_user_name','tempest-ImagesTestJSON-1682881466-project-member','2025-11-29 08:05:21','2025-11-29 08:05:31','2025-11-29 08:05:31',1),(135,'0bdf7515-c07e-4918-9c17-60eba424f483','owner_project_name','tempest-ImagesTestJSON-1682881466','2025-11-29 08:05:21','2025-11-29 08:05:31','2025-11-29 08:05:31',1),(136,'0bdf7515-c07e-4918-9c17-60eba424f483','boot_roles','reader,member','2025-11-29 08:05:21','2025-11-29 08:05:31','2025-11-29 08:05:31',1),(137,'0bdf7515-c07e-4918-9c17-60eba424f483','hw_machine_type','q35','2025-11-29 08:05:21','2025-11-29 08:05:31','2025-11-29 08:05:31',1),(138,'0bdf7515-c07e-4918-9c17-60eba424f483','hw_cdrom_bus','sata','2025-11-29 08:05:21','2025-11-29 08:05:31','2025-11-29 08:05:31',1),(139,'0bdf7515-c07e-4918-9c17-60eba424f483','hw_disk_bus','virtio','2025-11-29 08:05:21','2025-11-29 08:05:31','2025-11-29 08:05:31',1),(140,'0bdf7515-c07e-4918-9c17-60eba424f483','hw_input_bus','usb','2025-11-29 08:05:21','2025-11-29 08:05:31','2025-11-29 08:05:31',1),(141,'0bdf7515-c07e-4918-9c17-60eba424f483','hw_pointer_model','usbtablet','2025-11-29 08:05:21','2025-11-29 08:05:31','2025-11-29 08:05:31',1),(142,'0bdf7515-c07e-4918-9c17-60eba424f483','hw_video_model','virtio','2025-11-29 08:05:21','2025-11-29 08:05:31','2025-11-29 08:05:31',1),(143,'0bdf7515-c07e-4918-9c17-60eba424f483','hw_vif_model','virtio','2025-11-29 08:05:21','2025-11-29 08:05:31','2025-11-29 08:05:31',1),(144,'0bdf7515-c07e-4918-9c17-60eba424f483','old_vm_state','active','2025-11-29 08:05:21','2025-11-29 08:05:31','2025-11-29 08:05:31',1),(145,'0bdf7515-c07e-4918-9c17-60eba424f483','instance_uuid','c99fb9ee-05eb-4a44-8d78-3c719ed060b1','2025-11-29 08:05:21','2025-11-29 08:05:31','2025-11-29 08:05:31',1),(146,'0bdf7515-c07e-4918-9c17-60eba424f483','user_id','fddc5f5801764ee19d5253e2cab34df3','2025-11-29 08:05:21','2025-11-29 08:05:31','2025-11-29 08:05:31',1),(147,'0bdf7515-c07e-4918-9c17-60eba424f483','image_type','snapshot','2025-11-29 08:05:21','2025-11-29 08:05:31','2025-11-29 08:05:31',1),(148,'0bdf7515-c07e-4918-9c17-60eba424f483','image_location','snapshot','2025-11-29 08:05:27','2025-11-29 08:05:31','2025-11-29 08:05:31',1),(149,'0bdf7515-c07e-4918-9c17-60eba424f483','owner_id','638fd52fccf14f16b56d0860553063f3','2025-11-29 08:05:27','2025-11-29 08:05:31','2025-11-29 08:05:31',1),(150,'0bdf7515-c07e-4918-9c17-60eba424f483','image_state','available','2025-11-29 08:05:27','2025-11-29 08:05:31','2025-11-29 08:05:31',1),(151,'f953a29b-1cff-4723-9bbc-02d6d0bd3151','hw_rng_model','virtio','2025-11-29 08:05:28','2025-11-29 08:06:06','2025-11-29 08:06:06',1),(152,'f953a29b-1cff-4723-9bbc-02d6d0bd3151','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:05:28','2025-11-29 08:06:06','2025-11-29 08:06:06',1),(153,'f953a29b-1cff-4723-9bbc-02d6d0bd3151','owner_user_name','tempest-UnshelveToHostMultiNodesTest-1345262936-project-member','2025-11-29 08:05:28','2025-11-29 08:06:06','2025-11-29 08:06:06',1),(154,'f953a29b-1cff-4723-9bbc-02d6d0bd3151','owner_project_name','tempest-UnshelveToHostMultiNodesTest-1345262936','2025-11-29 08:05:28','2025-11-29 08:06:06','2025-11-29 08:06:06',1),(155,'f953a29b-1cff-4723-9bbc-02d6d0bd3151','boot_roles','reader,member','2025-11-29 08:05:28','2025-11-29 08:06:06','2025-11-29 08:06:06',1),(156,'f953a29b-1cff-4723-9bbc-02d6d0bd3151','hw_machine_type','q35','2025-11-29 08:05:28','2025-11-29 08:06:06','2025-11-29 08:06:06',1),(157,'f953a29b-1cff-4723-9bbc-02d6d0bd3151','hw_cdrom_bus','sata','2025-11-29 08:05:28','2025-11-29 08:06:06','2025-11-29 08:06:06',1),(158,'f953a29b-1cff-4723-9bbc-02d6d0bd3151','hw_disk_bus','virtio','2025-11-29 08:05:28','2025-11-29 08:06:06','2025-11-29 08:06:06',1),(159,'f953a29b-1cff-4723-9bbc-02d6d0bd3151','hw_input_bus','usb','2025-11-29 08:05:28','2025-11-29 08:06:06','2025-11-29 08:06:06',1),(160,'f953a29b-1cff-4723-9bbc-02d6d0bd3151','hw_pointer_model','usbtablet','2025-11-29 08:05:28','2025-11-29 08:06:06','2025-11-29 08:06:06',1),(161,'f953a29b-1cff-4723-9bbc-02d6d0bd3151','hw_video_model','virtio','2025-11-29 08:05:28','2025-11-29 08:06:06','2025-11-29 08:06:06',1),(162,'f953a29b-1cff-4723-9bbc-02d6d0bd3151','hw_vif_model','virtio','2025-11-29 08:05:28','2025-11-29 08:06:06','2025-11-29 08:06:06',1),(163,'f953a29b-1cff-4723-9bbc-02d6d0bd3151','clean_attempts','1','2025-11-29 08:05:28','2025-11-29 08:06:06','2025-11-29 08:06:06',1),(164,'f953a29b-1cff-4723-9bbc-02d6d0bd3151','instance_uuid','59628432-68dc-48d9-8986-8511c376a62d','2025-11-29 08:05:28','2025-11-29 08:06:06','2025-11-29 08:06:06',1),(165,'f953a29b-1cff-4723-9bbc-02d6d0bd3151','user_id','dc44b9aeabb442f582688b672dd724f3','2025-11-29 08:05:28','2025-11-29 08:06:06','2025-11-29 08:06:06',1),(166,'f953a29b-1cff-4723-9bbc-02d6d0bd3151','image_type','snapshot','2025-11-29 08:05:28','2025-11-29 08:06:06','2025-11-29 08:06:06',1),(167,'37d12ee4-89a4-499b-beea-6b6d4e46474b','hw_rng_model','virtio','2025-11-29 08:05:47','2025-11-29 08:06:18','2025-11-29 08:06:18',1),(168,'37d12ee4-89a4-499b-beea-6b6d4e46474b','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:05:47','2025-11-29 08:06:18','2025-11-29 08:06:18',1),(169,'37d12ee4-89a4-499b-beea-6b6d4e46474b','owner_user_name','tempest-ImagesTestJSON-1682881466-project-member','2025-11-29 08:05:47','2025-11-29 08:06:18','2025-11-29 08:06:18',1),(170,'37d12ee4-89a4-499b-beea-6b6d4e46474b','owner_project_name','tempest-ImagesTestJSON-1682881466','2025-11-29 08:05:47','2025-11-29 08:06:18','2025-11-29 08:06:18',1),(171,'37d12ee4-89a4-499b-beea-6b6d4e46474b','boot_roles','reader,member','2025-11-29 08:05:47','2025-11-29 08:06:18','2025-11-29 08:06:18',1),(172,'37d12ee4-89a4-499b-beea-6b6d4e46474b','hw_machine_type','q35','2025-11-29 08:05:47','2025-11-29 08:06:18','2025-11-29 08:06:18',1),(173,'37d12ee4-89a4-499b-beea-6b6d4e46474b','hw_cdrom_bus','sata','2025-11-29 08:05:47','2025-11-29 08:06:18','2025-11-29 08:06:18',1),(174,'37d12ee4-89a4-499b-beea-6b6d4e46474b','hw_disk_bus','virtio','2025-11-29 08:05:47','2025-11-29 08:06:18','2025-11-29 08:06:18',1),(175,'37d12ee4-89a4-499b-beea-6b6d4e46474b','hw_input_bus','usb','2025-11-29 08:05:47','2025-11-29 08:06:18','2025-11-29 08:06:18',1),(176,'37d12ee4-89a4-499b-beea-6b6d4e46474b','hw_pointer_model','usbtablet','2025-11-29 08:05:47','2025-11-29 08:06:18','2025-11-29 08:06:18',1),(177,'37d12ee4-89a4-499b-beea-6b6d4e46474b','hw_video_model','virtio','2025-11-29 08:05:47','2025-11-29 08:06:18','2025-11-29 08:06:18',1),(178,'37d12ee4-89a4-499b-beea-6b6d4e46474b','hw_vif_model','virtio','2025-11-29 08:05:47','2025-11-29 08:06:18','2025-11-29 08:06:18',1),(179,'37d12ee4-89a4-499b-beea-6b6d4e46474b','instance_uuid','7c7286ee-7432-4e68-a574-bbe535d1f203','2025-11-29 08:05:47','2025-11-29 08:06:18','2025-11-29 08:06:18',1),(180,'37d12ee4-89a4-499b-beea-6b6d4e46474b','user_id','fddc5f5801764ee19d5253e2cab34df3','2025-11-29 08:05:47','2025-11-29 08:06:18','2025-11-29 08:06:18',1),(181,'37d12ee4-89a4-499b-beea-6b6d4e46474b','image_type','snapshot','2025-11-29 08:05:47','2025-11-29 08:06:18','2025-11-29 08:06:18',1),(182,'f953a29b-1cff-4723-9bbc-02d6d0bd3151','owner_id','49ee945ea42e47ad9f070078a4d5179b','2025-11-29 08:05:49','2025-11-29 08:06:06','2025-11-29 08:06:06',1),(183,'f953a29b-1cff-4723-9bbc-02d6d0bd3151','image_state','available','2025-11-29 08:05:49','2025-11-29 08:06:06','2025-11-29 08:06:06',1),(184,'f953a29b-1cff-4723-9bbc-02d6d0bd3151','image_location','snapshot','2025-11-29 08:05:49','2025-11-29 08:06:06','2025-11-29 08:06:06',1),(185,'36c33ac0-d290-4825-8d63-52b362736e81','image_location','snapshot','2025-11-29 08:05:52','2025-11-29 08:06:04','2025-11-29 08:06:04',1),(186,'36c33ac0-d290-4825-8d63-52b362736e81','owner_id','90c23935e0214785a9dc5061b91cf29c','2025-11-29 08:05:52','2025-11-29 08:06:04','2025-11-29 08:06:04',1),(187,'36c33ac0-d290-4825-8d63-52b362736e81','image_state','available','2025-11-29 08:05:52','2025-11-29 08:06:04','2025-11-29 08:06:04',1),(188,'37d12ee4-89a4-499b-beea-6b6d4e46474b','image_location','snapshot','2025-11-29 08:05:55','2025-11-29 08:06:18','2025-11-29 08:06:18',1),(189,'37d12ee4-89a4-499b-beea-6b6d4e46474b','owner_id','638fd52fccf14f16b56d0860553063f3','2025-11-29 08:05:55','2025-11-29 08:06:18','2025-11-29 08:06:18',1),(190,'37d12ee4-89a4-499b-beea-6b6d4e46474b','image_state','available','2025-11-29 08:05:55','2025-11-29 08:06:18','2025-11-29 08:06:18',1),(191,'e2197e65-1840-49d9-98ce-4e37b9f34409','hw_rng_model','virtio','2025-11-29 08:06:36','2025-11-29 08:06:38','2025-11-29 08:06:38',1),(192,'e2197e65-1840-49d9-98ce-4e37b9f34409','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:06:36','2025-11-29 08:06:38','2025-11-29 08:06:38',1),(193,'e2197e65-1840-49d9-98ce-4e37b9f34409','owner_user_name','tempest-ImagesTestJSON-1682881466-project-member','2025-11-29 08:06:36','2025-11-29 08:06:38','2025-11-29 08:06:38',1),(194,'e2197e65-1840-49d9-98ce-4e37b9f34409','owner_project_name','tempest-ImagesTestJSON-1682881466','2025-11-29 08:06:36','2025-11-29 08:06:38','2025-11-29 08:06:38',1),(195,'e2197e65-1840-49d9-98ce-4e37b9f34409','boot_roles','member,reader','2025-11-29 08:06:36','2025-11-29 08:06:38','2025-11-29 08:06:38',1),(196,'e2197e65-1840-49d9-98ce-4e37b9f34409','hw_machine_type','q35','2025-11-29 08:06:36','2025-11-29 08:06:38','2025-11-29 08:06:38',1),(197,'e2197e65-1840-49d9-98ce-4e37b9f34409','hw_cdrom_bus','sata','2025-11-29 08:06:36','2025-11-29 08:06:38','2025-11-29 08:06:38',1),(198,'e2197e65-1840-49d9-98ce-4e37b9f34409','hw_disk_bus','virtio','2025-11-29 08:06:36','2025-11-29 08:06:38','2025-11-29 08:06:38',1),(199,'e2197e65-1840-49d9-98ce-4e37b9f34409','hw_input_bus','usb','2025-11-29 08:06:36','2025-11-29 08:06:38','2025-11-29 08:06:38',1),(200,'e2197e65-1840-49d9-98ce-4e37b9f34409','hw_pointer_model','usbtablet','2025-11-29 08:06:36','2025-11-29 08:06:38','2025-11-29 08:06:38',1),(201,'e2197e65-1840-49d9-98ce-4e37b9f34409','hw_video_model','virtio','2025-11-29 08:06:36','2025-11-29 08:06:38','2025-11-29 08:06:38',1),(202,'e2197e65-1840-49d9-98ce-4e37b9f34409','hw_vif_model','virtio','2025-11-29 08:06:36','2025-11-29 08:06:38','2025-11-29 08:06:38',1),(203,'e2197e65-1840-49d9-98ce-4e37b9f34409','instance_uuid','d14e9535-21d2-42b8-9c24-d37708970336','2025-11-29 08:06:36','2025-11-29 08:06:38','2025-11-29 08:06:38',1),(204,'e2197e65-1840-49d9-98ce-4e37b9f34409','user_id','fddc5f5801764ee19d5253e2cab34df3','2025-11-29 08:06:36','2025-11-29 08:06:38','2025-11-29 08:06:38',1),(205,'e2197e65-1840-49d9-98ce-4e37b9f34409','image_type','snapshot','2025-11-29 08:06:36','2025-11-29 08:06:38','2025-11-29 08:06:38',1),(206,'6a630c30-934b-49f9-92fa-38811e802998','hw_rng_model','virtio','2025-11-29 08:07:39','2025-11-29 08:07:47','2025-11-29 08:07:47',1),(207,'6a630c30-934b-49f9-92fa-38811e802998','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:07:39','2025-11-29 08:07:47','2025-11-29 08:07:47',1),(208,'6a630c30-934b-49f9-92fa-38811e802998','owner_user_name','tempest-ImagesOneServerTestJSON-941250990-project-member','2025-11-29 08:07:39','2025-11-29 08:07:47','2025-11-29 08:07:47',1),(209,'6a630c30-934b-49f9-92fa-38811e802998','owner_project_name','tempest-ImagesOneServerTestJSON-941250990','2025-11-29 08:07:39','2025-11-29 08:07:47','2025-11-29 08:07:47',1),(210,'6a630c30-934b-49f9-92fa-38811e802998','boot_roles','reader,member','2025-11-29 08:07:39','2025-11-29 08:07:47','2025-11-29 08:07:47',1),(211,'6a630c30-934b-49f9-92fa-38811e802998','hw_machine_type','q35','2025-11-29 08:07:39','2025-11-29 08:07:47','2025-11-29 08:07:47',1),(212,'6a630c30-934b-49f9-92fa-38811e802998','hw_cdrom_bus','sata','2025-11-29 08:07:39','2025-11-29 08:07:47','2025-11-29 08:07:47',1),(213,'6a630c30-934b-49f9-92fa-38811e802998','hw_disk_bus','virtio','2025-11-29 08:07:39','2025-11-29 08:07:47','2025-11-29 08:07:47',1),(214,'6a630c30-934b-49f9-92fa-38811e802998','hw_input_bus','usb','2025-11-29 08:07:39','2025-11-29 08:07:47','2025-11-29 08:07:47',1),(215,'6a630c30-934b-49f9-92fa-38811e802998','hw_pointer_model','usbtablet','2025-11-29 08:07:39','2025-11-29 08:07:47','2025-11-29 08:07:47',1),(216,'6a630c30-934b-49f9-92fa-38811e802998','hw_video_model','virtio','2025-11-29 08:07:39','2025-11-29 08:07:47','2025-11-29 08:07:47',1),(217,'6a630c30-934b-49f9-92fa-38811e802998','hw_vif_model','virtio','2025-11-29 08:07:39','2025-11-29 08:07:47','2025-11-29 08:07:47',1),(218,'6a630c30-934b-49f9-92fa-38811e802998','instance_uuid','9cebdce6-6212-492b-8105-301f19edb8b3','2025-11-29 08:07:39','2025-11-29 08:07:47','2025-11-29 08:07:47',1),(219,'6a630c30-934b-49f9-92fa-38811e802998','user_id','d0a358b2256f49b085b6e0d27911e743','2025-11-29 08:07:39','2025-11-29 08:07:47','2025-11-29 08:07:47',1),(220,'6a630c30-934b-49f9-92fa-38811e802998','image_type','test','2025-11-29 08:07:39','2025-11-29 08:07:47','2025-11-29 08:07:47',1),(221,'123394a7-8fc1-4d5c-8e9e-60cf6e1a8762','hw_rng_model','virtio','2025-11-29 08:07:41','2025-11-29 08:07:42','2025-11-29 08:07:42',1),(222,'123394a7-8fc1-4d5c-8e9e-60cf6e1a8762','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:07:41','2025-11-29 08:07:42','2025-11-29 08:07:42',1),(223,'123394a7-8fc1-4d5c-8e9e-60cf6e1a8762','owner_user_name','tempest-ImagesOneServerNegativeTestJSON-167104479-project-member','2025-11-29 08:07:41','2025-11-29 08:07:42','2025-11-29 08:07:42',1),(224,'123394a7-8fc1-4d5c-8e9e-60cf6e1a8762','owner_project_name','tempest-ImagesOneServerNegativeTestJSON-167104479','2025-11-29 08:07:41','2025-11-29 08:07:42','2025-11-29 08:07:42',1),(225,'123394a7-8fc1-4d5c-8e9e-60cf6e1a8762','boot_roles','member,reader','2025-11-29 08:07:41','2025-11-29 08:07:42','2025-11-29 08:07:42',1),(226,'123394a7-8fc1-4d5c-8e9e-60cf6e1a8762','hw_machine_type','q35','2025-11-29 08:07:41','2025-11-29 08:07:42','2025-11-29 08:07:42',1),(227,'123394a7-8fc1-4d5c-8e9e-60cf6e1a8762','hw_cdrom_bus','sata','2025-11-29 08:07:41','2025-11-29 08:07:42','2025-11-29 08:07:42',1),(228,'123394a7-8fc1-4d5c-8e9e-60cf6e1a8762','hw_disk_bus','virtio','2025-11-29 08:07:41','2025-11-29 08:07:42','2025-11-29 08:07:42',1),(229,'123394a7-8fc1-4d5c-8e9e-60cf6e1a8762','hw_input_bus','usb','2025-11-29 08:07:41','2025-11-29 08:07:42','2025-11-29 08:07:42',1),(230,'123394a7-8fc1-4d5c-8e9e-60cf6e1a8762','hw_pointer_model','usbtablet','2025-11-29 08:07:41','2025-11-29 08:07:42','2025-11-29 08:07:42',1),(231,'123394a7-8fc1-4d5c-8e9e-60cf6e1a8762','hw_video_model','virtio','2025-11-29 08:07:41','2025-11-29 08:07:42','2025-11-29 08:07:42',1),(232,'123394a7-8fc1-4d5c-8e9e-60cf6e1a8762','hw_vif_model','virtio','2025-11-29 08:07:41','2025-11-29 08:07:42','2025-11-29 08:07:42',1),(233,'123394a7-8fc1-4d5c-8e9e-60cf6e1a8762','instance_uuid','ed7a6200-c4d2-4554-bdb4-57e02fa79386','2025-11-29 08:07:41','2025-11-29 08:07:42','2025-11-29 08:07:42',1),(234,'123394a7-8fc1-4d5c-8e9e-60cf6e1a8762','user_id','1a010a95085342c5ae9a02f15b334fad','2025-11-29 08:07:41','2025-11-29 08:07:42','2025-11-29 08:07:42',1),(235,'123394a7-8fc1-4d5c-8e9e-60cf6e1a8762','image_type','snapshot','2025-11-29 08:07:41','2025-11-29 08:07:42','2025-11-29 08:07:42',1),(236,'6a630c30-934b-49f9-92fa-38811e802998','image_location','snapshot','2025-11-29 08:07:44','2025-11-29 08:07:47','2025-11-29 08:07:47',1),(237,'6a630c30-934b-49f9-92fa-38811e802998','owner_id','02545fd3735d4977afe5612632ee4832','2025-11-29 08:07:44','2025-11-29 08:07:47','2025-11-29 08:07:47',1),(238,'6a630c30-934b-49f9-92fa-38811e802998','image_state','available','2025-11-29 08:07:44','2025-11-29 08:07:47','2025-11-29 08:07:47',1),(239,'aa6ac671-fc8d-4598-a390-3f4d0b610d84','hw_rng_model','virtio','2025-11-29 08:07:48','2025-11-29 08:07:57','2025-11-29 08:07:57',1),(240,'aa6ac671-fc8d-4598-a390-3f4d0b610d84','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:07:48','2025-11-29 08:07:57','2025-11-29 08:07:57',1),(241,'aa6ac671-fc8d-4598-a390-3f4d0b610d84','owner_user_name','tempest-ImagesOneServerTestJSON-941250990-project-member','2025-11-29 08:07:48','2025-11-29 08:07:57','2025-11-29 08:07:57',1),(242,'aa6ac671-fc8d-4598-a390-3f4d0b610d84','owner_project_name','tempest-ImagesOneServerTestJSON-941250990','2025-11-29 08:07:48','2025-11-29 08:07:57','2025-11-29 08:07:57',1),(243,'aa6ac671-fc8d-4598-a390-3f4d0b610d84','boot_roles','reader,member','2025-11-29 08:07:48','2025-11-29 08:07:57','2025-11-29 08:07:57',1),(244,'aa6ac671-fc8d-4598-a390-3f4d0b610d84','hw_machine_type','q35','2025-11-29 08:07:48','2025-11-29 08:07:57','2025-11-29 08:07:57',1),(245,'aa6ac671-fc8d-4598-a390-3f4d0b610d84','hw_cdrom_bus','sata','2025-11-29 08:07:48','2025-11-29 08:07:57','2025-11-29 08:07:57',1),(246,'aa6ac671-fc8d-4598-a390-3f4d0b610d84','hw_disk_bus','virtio','2025-11-29 08:07:48','2025-11-29 08:07:57','2025-11-29 08:07:57',1),(247,'aa6ac671-fc8d-4598-a390-3f4d0b610d84','hw_input_bus','usb','2025-11-29 08:07:48','2025-11-29 08:07:57','2025-11-29 08:07:57',1),(248,'aa6ac671-fc8d-4598-a390-3f4d0b610d84','hw_pointer_model','usbtablet','2025-11-29 08:07:48','2025-11-29 08:07:57','2025-11-29 08:07:57',1),(249,'aa6ac671-fc8d-4598-a390-3f4d0b610d84','hw_video_model','virtio','2025-11-29 08:07:48','2025-11-29 08:07:57','2025-11-29 08:07:57',1),(250,'aa6ac671-fc8d-4598-a390-3f4d0b610d84','hw_vif_model','virtio','2025-11-29 08:07:48','2025-11-29 08:07:57','2025-11-29 08:07:57',1),(251,'aa6ac671-fc8d-4598-a390-3f4d0b610d84','instance_uuid','9cebdce6-6212-492b-8105-301f19edb8b3','2025-11-29 08:07:48','2025-11-29 08:07:57','2025-11-29 08:07:57',1),(252,'aa6ac671-fc8d-4598-a390-3f4d0b610d84','user_id','d0a358b2256f49b085b6e0d27911e743','2025-11-29 08:07:48','2025-11-29 08:07:57','2025-11-29 08:07:57',1),(253,'aa6ac671-fc8d-4598-a390-3f4d0b610d84','image_type','snapshot','2025-11-29 08:07:48','2025-11-29 08:07:57','2025-11-29 08:07:57',1),(254,'aa6ac671-fc8d-4598-a390-3f4d0b610d84','image_location','snapshot','2025-11-29 08:07:53','2025-11-29 08:07:57','2025-11-29 08:07:57',1),(255,'aa6ac671-fc8d-4598-a390-3f4d0b610d84','owner_id','02545fd3735d4977afe5612632ee4832','2025-11-29 08:07:53','2025-11-29 08:07:57','2025-11-29 08:07:57',1),(256,'aa6ac671-fc8d-4598-a390-3f4d0b610d84','image_state','available','2025-11-29 08:07:53','2025-11-29 08:07:57','2025-11-29 08:07:57',1),(257,'68cf293e-7e4e-4b94-aea6-5b4d60641413','hw_rng_model','virtio','2025-11-29 08:08:14','2025-11-29 08:08:15','2025-11-29 08:08:15',1),(258,'68cf293e-7e4e-4b94-aea6-5b4d60641413','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:08:14','2025-11-29 08:08:15','2025-11-29 08:08:15',1),(259,'68cf293e-7e4e-4b94-aea6-5b4d60641413','owner_user_name','tempest-ImagesOneServerNegativeTestJSON-167104479-project-member','2025-11-29 08:08:14','2025-11-29 08:08:15','2025-11-29 08:08:15',1),(260,'68cf293e-7e4e-4b94-aea6-5b4d60641413','owner_project_name','tempest-ImagesOneServerNegativeTestJSON-167104479','2025-11-29 08:08:14','2025-11-29 08:08:15','2025-11-29 08:08:15',1),(261,'68cf293e-7e4e-4b94-aea6-5b4d60641413','boot_roles','member,reader','2025-11-29 08:08:14','2025-11-29 08:08:15','2025-11-29 08:08:15',1),(262,'68cf293e-7e4e-4b94-aea6-5b4d60641413','hw_machine_type','q35','2025-11-29 08:08:14','2025-11-29 08:08:15','2025-11-29 08:08:15',1),(263,'68cf293e-7e4e-4b94-aea6-5b4d60641413','hw_cdrom_bus','sata','2025-11-29 08:08:14','2025-11-29 08:08:15','2025-11-29 08:08:15',1),(264,'68cf293e-7e4e-4b94-aea6-5b4d60641413','hw_disk_bus','virtio','2025-11-29 08:08:14','2025-11-29 08:08:15','2025-11-29 08:08:15',1),(265,'68cf293e-7e4e-4b94-aea6-5b4d60641413','hw_input_bus','usb','2025-11-29 08:08:14','2025-11-29 08:08:15','2025-11-29 08:08:15',1),(266,'68cf293e-7e4e-4b94-aea6-5b4d60641413','hw_pointer_model','usbtablet','2025-11-29 08:08:14','2025-11-29 08:08:15','2025-11-29 08:08:15',1),(267,'68cf293e-7e4e-4b94-aea6-5b4d60641413','hw_video_model','virtio','2025-11-29 08:08:14','2025-11-29 08:08:15','2025-11-29 08:08:15',1),(268,'68cf293e-7e4e-4b94-aea6-5b4d60641413','hw_vif_model','virtio','2025-11-29 08:08:14','2025-11-29 08:08:15','2025-11-29 08:08:15',1),(269,'68cf293e-7e4e-4b94-aea6-5b4d60641413','instance_uuid','78549bb3-c5a0-4092-b64e-b4608e724d9c','2025-11-29 08:08:14','2025-11-29 08:08:15','2025-11-29 08:08:15',1),(270,'68cf293e-7e4e-4b94-aea6-5b4d60641413','user_id','1a010a95085342c5ae9a02f15b334fad','2025-11-29 08:08:14','2025-11-29 08:08:15','2025-11-29 08:08:15',1),(271,'68cf293e-7e4e-4b94-aea6-5b4d60641413','image_type','snapshot','2025-11-29 08:08:14','2025-11-29 08:08:15','2025-11-29 08:08:15',1),(272,'7e8836eb-bacd-485f-b61b-a89bcd8f6e84','hw_rng_model','virtio','2025-11-29 08:12:49','2025-11-29 08:13:14','2025-11-29 08:13:14',1),(273,'7e8836eb-bacd-485f-b61b-a89bcd8f6e84','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:12:49','2025-11-29 08:13:14','2025-11-29 08:13:14',1),(274,'7e8836eb-bacd-485f-b61b-a89bcd8f6e84','owner_user_name','tempest-ServerActionsTestOtherB-477220446-project-member','2025-11-29 08:12:49','2025-11-29 08:13:14','2025-11-29 08:13:14',1),(275,'7e8836eb-bacd-485f-b61b-a89bcd8f6e84','owner_project_name','tempest-ServerActionsTestOtherB-477220446','2025-11-29 08:12:49','2025-11-29 08:13:14','2025-11-29 08:13:14',1),(276,'7e8836eb-bacd-485f-b61b-a89bcd8f6e84','boot_roles','member,reader','2025-11-29 08:12:49','2025-11-29 08:13:14','2025-11-29 08:13:14',1),(277,'7e8836eb-bacd-485f-b61b-a89bcd8f6e84','hw_machine_type','q35','2025-11-29 08:12:49','2025-11-29 08:13:14','2025-11-29 08:13:14',1),(278,'7e8836eb-bacd-485f-b61b-a89bcd8f6e84','hw_cdrom_bus','sata','2025-11-29 08:12:49','2025-11-29 08:13:14','2025-11-29 08:13:14',1),(279,'7e8836eb-bacd-485f-b61b-a89bcd8f6e84','hw_disk_bus','virtio','2025-11-29 08:12:49','2025-11-29 08:13:14','2025-11-29 08:13:14',1),(280,'7e8836eb-bacd-485f-b61b-a89bcd8f6e84','hw_input_bus','usb','2025-11-29 08:12:49','2025-11-29 08:13:14','2025-11-29 08:13:14',1),(281,'7e8836eb-bacd-485f-b61b-a89bcd8f6e84','hw_pointer_model','usbtablet','2025-11-29 08:12:49','2025-11-29 08:13:14','2025-11-29 08:13:14',1),(282,'7e8836eb-bacd-485f-b61b-a89bcd8f6e84','hw_video_model','virtio','2025-11-29 08:12:49','2025-11-29 08:13:14','2025-11-29 08:13:14',1),(283,'7e8836eb-bacd-485f-b61b-a89bcd8f6e84','hw_vif_model','virtio','2025-11-29 08:12:49','2025-11-29 08:13:14','2025-11-29 08:13:14',1),(284,'7e8836eb-bacd-485f-b61b-a89bcd8f6e84','instance_uuid','19e85fae-c57e-409b-95f7-b53ddb4c928e','2025-11-29 08:12:49','2025-11-29 08:13:14','2025-11-29 08:13:14',1),(285,'7e8836eb-bacd-485f-b61b-a89bcd8f6e84','user_id','c5e3ade3963d47be97b545b2e3779b6b','2025-11-29 08:12:49','2025-11-29 08:13:14','2025-11-29 08:13:14',1),(286,'7e8836eb-bacd-485f-b61b-a89bcd8f6e84','image_type','backup','2025-11-29 08:12:49','2025-11-29 08:13:14','2025-11-29 08:13:14',1),(287,'7e8836eb-bacd-485f-b61b-a89bcd8f6e84','backup_type','daily','2025-11-29 08:12:49','2025-11-29 08:13:14','2025-11-29 08:13:14',1),(288,'7e8836eb-bacd-485f-b61b-a89bcd8f6e84','owner_id','1b8899f76f554afc96bb2441424e5a77','2025-11-29 08:12:53','2025-11-29 08:13:14','2025-11-29 08:13:14',1),(289,'7e8836eb-bacd-485f-b61b-a89bcd8f6e84','image_state','available','2025-11-29 08:12:53','2025-11-29 08:13:14','2025-11-29 08:13:14',1),(290,'7e8836eb-bacd-485f-b61b-a89bcd8f6e84','image_location','snapshot','2025-11-29 08:12:53','2025-11-29 08:13:14','2025-11-29 08:13:14',1),(291,'3c08af3e-7b9c-4dba-a2c8-3cba120c3814','hw_rng_model','virtio','2025-11-29 08:12:56','2025-11-29 08:13:18','2025-11-29 08:13:18',1),(292,'3c08af3e-7b9c-4dba-a2c8-3cba120c3814','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:12:56','2025-11-29 08:13:18','2025-11-29 08:13:18',1),(293,'3c08af3e-7b9c-4dba-a2c8-3cba120c3814','owner_user_name','tempest-ServerActionsTestOtherB-477220446-project-member','2025-11-29 08:12:56','2025-11-29 08:13:18','2025-11-29 08:13:18',1),(294,'3c08af3e-7b9c-4dba-a2c8-3cba120c3814','owner_project_name','tempest-ServerActionsTestOtherB-477220446','2025-11-29 08:12:56','2025-11-29 08:13:18','2025-11-29 08:13:18',1),(295,'3c08af3e-7b9c-4dba-a2c8-3cba120c3814','boot_roles','member,reader','2025-11-29 08:12:56','2025-11-29 08:13:18','2025-11-29 08:13:18',1),(296,'3c08af3e-7b9c-4dba-a2c8-3cba120c3814','hw_machine_type','q35','2025-11-29 08:12:56','2025-11-29 08:13:18','2025-11-29 08:13:18',1),(297,'3c08af3e-7b9c-4dba-a2c8-3cba120c3814','hw_cdrom_bus','sata','2025-11-29 08:12:56','2025-11-29 08:13:18','2025-11-29 08:13:18',1),(298,'3c08af3e-7b9c-4dba-a2c8-3cba120c3814','hw_disk_bus','virtio','2025-11-29 08:12:56','2025-11-29 08:13:18','2025-11-29 08:13:18',1),(299,'3c08af3e-7b9c-4dba-a2c8-3cba120c3814','hw_input_bus','usb','2025-11-29 08:12:56','2025-11-29 08:13:18','2025-11-29 08:13:18',1),(300,'3c08af3e-7b9c-4dba-a2c8-3cba120c3814','hw_pointer_model','usbtablet','2025-11-29 08:12:56','2025-11-29 08:13:18','2025-11-29 08:13:18',1),(301,'3c08af3e-7b9c-4dba-a2c8-3cba120c3814','hw_video_model','virtio','2025-11-29 08:12:56','2025-11-29 08:13:18','2025-11-29 08:13:18',1),(302,'3c08af3e-7b9c-4dba-a2c8-3cba120c3814','hw_vif_model','virtio','2025-11-29 08:12:56','2025-11-29 08:13:18','2025-11-29 08:13:18',1),(303,'3c08af3e-7b9c-4dba-a2c8-3cba120c3814','instance_uuid','19e85fae-c57e-409b-95f7-b53ddb4c928e','2025-11-29 08:12:56','2025-11-29 08:13:18','2025-11-29 08:13:18',1),(304,'3c08af3e-7b9c-4dba-a2c8-3cba120c3814','user_id','c5e3ade3963d47be97b545b2e3779b6b','2025-11-29 08:12:56','2025-11-29 08:13:18','2025-11-29 08:13:18',1),(305,'3c08af3e-7b9c-4dba-a2c8-3cba120c3814','image_type','backup','2025-11-29 08:12:56','2025-11-29 08:13:18','2025-11-29 08:13:18',1),(306,'3c08af3e-7b9c-4dba-a2c8-3cba120c3814','backup_type','daily','2025-11-29 08:12:56','2025-11-29 08:13:18','2025-11-29 08:13:18',1),(307,'3c08af3e-7b9c-4dba-a2c8-3cba120c3814','owner_id','1b8899f76f554afc96bb2441424e5a77','2025-11-29 08:13:01','2025-11-29 08:13:18','2025-11-29 08:13:18',1),(308,'3c08af3e-7b9c-4dba-a2c8-3cba120c3814','image_state','available','2025-11-29 08:13:01','2025-11-29 08:13:18','2025-11-29 08:13:18',1),(309,'3c08af3e-7b9c-4dba-a2c8-3cba120c3814','image_location','snapshot','2025-11-29 08:13:01','2025-11-29 08:13:18','2025-11-29 08:13:18',1),(310,'4e132098-a673-4ed7-8cfc-d67f77fc5495','hw_rng_model','virtio','2025-11-29 08:13:05','2025-11-29 08:13:17','2025-11-29 08:13:17',1),(311,'4e132098-a673-4ed7-8cfc-d67f77fc5495','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:13:05','2025-11-29 08:13:17','2025-11-29 08:13:17',1),(312,'4e132098-a673-4ed7-8cfc-d67f77fc5495','owner_user_name','tempest-ServerActionsTestOtherB-477220446-project-member','2025-11-29 08:13:05','2025-11-29 08:13:17','2025-11-29 08:13:17',1),(313,'4e132098-a673-4ed7-8cfc-d67f77fc5495','owner_project_name','tempest-ServerActionsTestOtherB-477220446','2025-11-29 08:13:05','2025-11-29 08:13:17','2025-11-29 08:13:17',1),(314,'4e132098-a673-4ed7-8cfc-d67f77fc5495','boot_roles','member,reader','2025-11-29 08:13:05','2025-11-29 08:13:17','2025-11-29 08:13:17',1),(315,'4e132098-a673-4ed7-8cfc-d67f77fc5495','hw_machine_type','q35','2025-11-29 08:13:05','2025-11-29 08:13:17','2025-11-29 08:13:17',1),(316,'4e132098-a673-4ed7-8cfc-d67f77fc5495','hw_cdrom_bus','sata','2025-11-29 08:13:05','2025-11-29 08:13:17','2025-11-29 08:13:17',1),(317,'4e132098-a673-4ed7-8cfc-d67f77fc5495','hw_disk_bus','virtio','2025-11-29 08:13:05','2025-11-29 08:13:17','2025-11-29 08:13:17',1),(318,'4e132098-a673-4ed7-8cfc-d67f77fc5495','hw_input_bus','usb','2025-11-29 08:13:05','2025-11-29 08:13:17','2025-11-29 08:13:17',1),(319,'4e132098-a673-4ed7-8cfc-d67f77fc5495','hw_pointer_model','usbtablet','2025-11-29 08:13:05','2025-11-29 08:13:17','2025-11-29 08:13:17',1),(320,'4e132098-a673-4ed7-8cfc-d67f77fc5495','hw_video_model','virtio','2025-11-29 08:13:05','2025-11-29 08:13:17','2025-11-29 08:13:17',1),(321,'4e132098-a673-4ed7-8cfc-d67f77fc5495','hw_vif_model','virtio','2025-11-29 08:13:05','2025-11-29 08:13:17','2025-11-29 08:13:17',1),(322,'4e132098-a673-4ed7-8cfc-d67f77fc5495','instance_uuid','19e85fae-c57e-409b-95f7-b53ddb4c928e','2025-11-29 08:13:05','2025-11-29 08:13:17','2025-11-29 08:13:17',1),(323,'4e132098-a673-4ed7-8cfc-d67f77fc5495','user_id','c5e3ade3963d47be97b545b2e3779b6b','2025-11-29 08:13:05','2025-11-29 08:13:17','2025-11-29 08:13:17',1),(324,'4e132098-a673-4ed7-8cfc-d67f77fc5495','image_type','backup','2025-11-29 08:13:05','2025-11-29 08:13:17','2025-11-29 08:13:17',1),(325,'4e132098-a673-4ed7-8cfc-d67f77fc5495','backup_type','daily','2025-11-29 08:13:05','2025-11-29 08:13:17','2025-11-29 08:13:17',1),(326,'4e132098-a673-4ed7-8cfc-d67f77fc5495','owner_id','1b8899f76f554afc96bb2441424e5a77','2025-11-29 08:13:10','2025-11-29 08:13:17','2025-11-29 08:13:17',1),(327,'4e132098-a673-4ed7-8cfc-d67f77fc5495','image_state','available','2025-11-29 08:13:10','2025-11-29 08:13:17','2025-11-29 08:13:17',1),(328,'4e132098-a673-4ed7-8cfc-d67f77fc5495','image_location','snapshot','2025-11-29 08:13:10','2025-11-29 08:13:17','2025-11-29 08:13:17',1),(329,'159b7691-923b-4bf5-a065-6be0cf4e75ba','hw_rng_model','virtio','2025-11-29 08:17:33','2025-11-29 08:18:34','2025-11-29 08:18:34',1),(330,'159b7691-923b-4bf5-a065-6be0cf4e75ba','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:17:33','2025-11-29 08:18:34','2025-11-29 08:18:34',1),(331,'159b7691-923b-4bf5-a065-6be0cf4e75ba','owner_user_name','tempest-ServerActionsTestOtherB-477220446-project-member','2025-11-29 08:17:33','2025-11-29 08:18:34','2025-11-29 08:18:34',1),(332,'159b7691-923b-4bf5-a065-6be0cf4e75ba','owner_project_name','tempest-ServerActionsTestOtherB-477220446','2025-11-29 08:17:33','2025-11-29 08:18:34','2025-11-29 08:18:34',1),(333,'159b7691-923b-4bf5-a065-6be0cf4e75ba','boot_roles','member,reader','2025-11-29 08:17:33','2025-11-29 08:18:34','2025-11-29 08:18:34',1),(334,'159b7691-923b-4bf5-a065-6be0cf4e75ba','hw_machine_type','q35','2025-11-29 08:17:33','2025-11-29 08:18:34','2025-11-29 08:18:34',1),(335,'159b7691-923b-4bf5-a065-6be0cf4e75ba','hw_cdrom_bus','sata','2025-11-29 08:17:33','2025-11-29 08:18:34','2025-11-29 08:18:34',1),(336,'159b7691-923b-4bf5-a065-6be0cf4e75ba','hw_disk_bus','virtio','2025-11-29 08:17:33','2025-11-29 08:18:34','2025-11-29 08:18:34',1),(337,'159b7691-923b-4bf5-a065-6be0cf4e75ba','hw_input_bus','usb','2025-11-29 08:17:33','2025-11-29 08:18:34','2025-11-29 08:18:34',1),(338,'159b7691-923b-4bf5-a065-6be0cf4e75ba','hw_pointer_model','usbtablet','2025-11-29 08:17:33','2025-11-29 08:18:34','2025-11-29 08:18:34',1),(339,'159b7691-923b-4bf5-a065-6be0cf4e75ba','hw_video_model','virtio','2025-11-29 08:17:33','2025-11-29 08:18:34','2025-11-29 08:18:34',1),(340,'159b7691-923b-4bf5-a065-6be0cf4e75ba','hw_vif_model','virtio','2025-11-29 08:17:33','2025-11-29 08:18:34','2025-11-29 08:18:34',1),(341,'159b7691-923b-4bf5-a065-6be0cf4e75ba','instance_uuid','187cf9d2-4ae7-4113-af4c-2ec0ce078494','2025-11-29 08:17:33','2025-11-29 08:18:34','2025-11-29 08:18:34',1),(342,'159b7691-923b-4bf5-a065-6be0cf4e75ba','user_id','c5e3ade3963d47be97b545b2e3779b6b','2025-11-29 08:17:33','2025-11-29 08:18:34','2025-11-29 08:18:34',1),(343,'159b7691-923b-4bf5-a065-6be0cf4e75ba','image_type','snapshot','2025-11-29 08:17:33','2025-11-29 08:18:34','2025-11-29 08:18:34',1),(344,'159b7691-923b-4bf5-a065-6be0cf4e75ba','owner_id','1b8899f76f554afc96bb2441424e5a77','2025-11-29 08:17:39','2025-11-29 08:18:34','2025-11-29 08:18:34',1),(345,'159b7691-923b-4bf5-a065-6be0cf4e75ba','image_state','available','2025-11-29 08:17:39','2025-11-29 08:18:34','2025-11-29 08:18:34',1),(346,'159b7691-923b-4bf5-a065-6be0cf4e75ba','image_location','snapshot','2025-11-29 08:17:39','2025-11-29 08:18:34','2025-11-29 08:18:34',1),(347,'c28b4cfd-fa14-4a57-95be-5fa2d667ebc5','hw_rng_model','virtio','2025-11-29 08:17:50','2025-11-29 08:18:29','2025-11-29 08:18:29',1),(348,'c28b4cfd-fa14-4a57-95be-5fa2d667ebc5','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:17:50','2025-11-29 08:18:29','2025-11-29 08:18:29',1),(349,'c28b4cfd-fa14-4a57-95be-5fa2d667ebc5','owner_user_name','tempest-ServerActionsTestOtherB-477220446-project-member','2025-11-29 08:17:50','2025-11-29 08:18:29','2025-11-29 08:18:29',1),(350,'c28b4cfd-fa14-4a57-95be-5fa2d667ebc5','owner_project_name','tempest-ServerActionsTestOtherB-477220446','2025-11-29 08:17:50','2025-11-29 08:18:29','2025-11-29 08:18:29',1),(351,'c28b4cfd-fa14-4a57-95be-5fa2d667ebc5','boot_roles','member,reader','2025-11-29 08:17:50','2025-11-29 08:18:29','2025-11-29 08:18:29',1),(352,'c28b4cfd-fa14-4a57-95be-5fa2d667ebc5','hw_machine_type','q35','2025-11-29 08:17:50','2025-11-29 08:18:29','2025-11-29 08:18:29',1),(353,'c28b4cfd-fa14-4a57-95be-5fa2d667ebc5','hw_cdrom_bus','sata','2025-11-29 08:17:50','2025-11-29 08:18:29','2025-11-29 08:18:29',1),(354,'c28b4cfd-fa14-4a57-95be-5fa2d667ebc5','hw_disk_bus','virtio','2025-11-29 08:17:50','2025-11-29 08:18:29','2025-11-29 08:18:29',1),(355,'c28b4cfd-fa14-4a57-95be-5fa2d667ebc5','hw_input_bus','usb','2025-11-29 08:17:50','2025-11-29 08:18:29','2025-11-29 08:18:29',1),(356,'c28b4cfd-fa14-4a57-95be-5fa2d667ebc5','hw_pointer_model','usbtablet','2025-11-29 08:17:50','2025-11-29 08:18:29','2025-11-29 08:18:29',1),(357,'c28b4cfd-fa14-4a57-95be-5fa2d667ebc5','hw_video_model','virtio','2025-11-29 08:17:50','2025-11-29 08:18:29','2025-11-29 08:18:29',1),(358,'c28b4cfd-fa14-4a57-95be-5fa2d667ebc5','hw_vif_model','virtio','2025-11-29 08:17:50','2025-11-29 08:18:29','2025-11-29 08:18:29',1),(359,'c28b4cfd-fa14-4a57-95be-5fa2d667ebc5','instance_uuid','68c19565-6fe1-4c2c-927d-87f801074e18','2025-11-29 08:17:50','2025-11-29 08:18:29','2025-11-29 08:18:29',1),(360,'c28b4cfd-fa14-4a57-95be-5fa2d667ebc5','user_id','c5e3ade3963d47be97b545b2e3779b6b','2025-11-29 08:17:50','2025-11-29 08:18:29','2025-11-29 08:18:29',1),(361,'c28b4cfd-fa14-4a57-95be-5fa2d667ebc5','image_type','snapshot','2025-11-29 08:17:50','2025-11-29 08:18:29','2025-11-29 08:18:29',1),(362,'c28b4cfd-fa14-4a57-95be-5fa2d667ebc5','owner_id','1b8899f76f554afc96bb2441424e5a77','2025-11-29 08:18:00','2025-11-29 08:18:29','2025-11-29 08:18:29',1),(363,'c28b4cfd-fa14-4a57-95be-5fa2d667ebc5','image_state','available','2025-11-29 08:18:00','2025-11-29 08:18:29','2025-11-29 08:18:29',1),(364,'c28b4cfd-fa14-4a57-95be-5fa2d667ebc5','image_location','snapshot','2025-11-29 08:18:00','2025-11-29 08:18:29','2025-11-29 08:18:29',1),(365,'22c1bddc-ba6e-468e-8d62-0351bef23ed0','hw_rng_model','virtio','2025-11-29 08:21:19','2025-11-29 08:21:20','2025-11-29 08:21:20',1),(366,'22c1bddc-ba6e-468e-8d62-0351bef23ed0','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:21:19','2025-11-29 08:21:20','2025-11-29 08:21:20',1),(367,'22c1bddc-ba6e-468e-8d62-0351bef23ed0','owner_user_name','tempest-ServersAaction247Test-639981495-project-member','2025-11-29 08:21:19','2025-11-29 08:21:20','2025-11-29 08:21:20',1),(368,'22c1bddc-ba6e-468e-8d62-0351bef23ed0','owner_project_name','tempest-ServersAaction247Test-639981495','2025-11-29 08:21:19','2025-11-29 08:21:20','2025-11-29 08:21:20',1),(369,'22c1bddc-ba6e-468e-8d62-0351bef23ed0','boot_roles','reader,member','2025-11-29 08:21:19','2025-11-29 08:21:20','2025-11-29 08:21:20',1),(370,'22c1bddc-ba6e-468e-8d62-0351bef23ed0','hw_machine_type','q35','2025-11-29 08:21:19','2025-11-29 08:21:20','2025-11-29 08:21:20',1),(371,'22c1bddc-ba6e-468e-8d62-0351bef23ed0','hw_cdrom_bus','sata','2025-11-29 08:21:19','2025-11-29 08:21:20','2025-11-29 08:21:20',1),(372,'22c1bddc-ba6e-468e-8d62-0351bef23ed0','hw_disk_bus','virtio','2025-11-29 08:21:19','2025-11-29 08:21:20','2025-11-29 08:21:20',1),(373,'22c1bddc-ba6e-468e-8d62-0351bef23ed0','hw_input_bus','usb','2025-11-29 08:21:19','2025-11-29 08:21:20','2025-11-29 08:21:20',1),(374,'22c1bddc-ba6e-468e-8d62-0351bef23ed0','hw_pointer_model','usbtablet','2025-11-29 08:21:19','2025-11-29 08:21:20','2025-11-29 08:21:20',1),(375,'22c1bddc-ba6e-468e-8d62-0351bef23ed0','hw_video_model','virtio','2025-11-29 08:21:19','2025-11-29 08:21:20','2025-11-29 08:21:20',1),(376,'22c1bddc-ba6e-468e-8d62-0351bef23ed0','hw_vif_model','virtio','2025-11-29 08:21:19','2025-11-29 08:21:20','2025-11-29 08:21:20',1),(377,'22c1bddc-ba6e-468e-8d62-0351bef23ed0','instance_uuid','1439a5a5-effe-49c7-b030-71c47af51dc9','2025-11-29 08:21:19','2025-11-29 08:21:20','2025-11-29 08:21:20',1),(378,'22c1bddc-ba6e-468e-8d62-0351bef23ed0','user_id','464a845eba164483a26ad56dca49af3d','2025-11-29 08:21:19','2025-11-29 08:21:20','2025-11-29 08:21:20',1),(379,'22c1bddc-ba6e-468e-8d62-0351bef23ed0','image_type','backup','2025-11-29 08:21:19','2025-11-29 08:21:20','2025-11-29 08:21:20',1),(380,'22c1bddc-ba6e-468e-8d62-0351bef23ed0','backup_type','daily','2025-11-29 08:21:19','2025-11-29 08:21:20','2025-11-29 08:21:20',1),(381,'c5df7ff6-8c6a-4656-a8c2-618a39624a42','hw_rng_model','virtio','2025-11-29 08:23:59','2025-11-29 08:28:20','2025-11-29 08:28:20',1),(382,'c5df7ff6-8c6a-4656-a8c2-618a39624a42','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:23:59','2025-11-29 08:28:20','2025-11-29 08:28:20',1),(383,'c5df7ff6-8c6a-4656-a8c2-618a39624a42','owner_user_name','tempest-ServerStableDeviceRescueTest-507673154-project-member','2025-11-29 08:23:59','2025-11-29 08:28:20','2025-11-29 08:28:20',1),(384,'c5df7ff6-8c6a-4656-a8c2-618a39624a42','owner_project_name','tempest-ServerStableDeviceRescueTest-507673154','2025-11-29 08:23:59','2025-11-29 08:28:20','2025-11-29 08:28:20',1),(385,'c5df7ff6-8c6a-4656-a8c2-618a39624a42','boot_roles','member,reader','2025-11-29 08:23:59','2025-11-29 08:28:20','2025-11-29 08:28:20',1),(386,'c5df7ff6-8c6a-4656-a8c2-618a39624a42','hw_machine_type','q35','2025-11-29 08:23:59','2025-11-29 08:28:20','2025-11-29 08:28:20',1),(387,'c5df7ff6-8c6a-4656-a8c2-618a39624a42','hw_cdrom_bus','sata','2025-11-29 08:23:59','2025-11-29 08:28:20','2025-11-29 08:28:20',1),(388,'c5df7ff6-8c6a-4656-a8c2-618a39624a42','hw_disk_bus','virtio','2025-11-29 08:23:59','2025-11-29 08:28:20','2025-11-29 08:28:20',1),(389,'c5df7ff6-8c6a-4656-a8c2-618a39624a42','hw_input_bus','usb','2025-11-29 08:23:59','2025-11-29 08:28:20','2025-11-29 08:28:20',1),(390,'c5df7ff6-8c6a-4656-a8c2-618a39624a42','hw_pointer_model','usbtablet','2025-11-29 08:23:59','2025-11-29 08:28:20','2025-11-29 08:28:20',1),(391,'c5df7ff6-8c6a-4656-a8c2-618a39624a42','hw_video_model','virtio','2025-11-29 08:23:59','2025-11-29 08:28:20','2025-11-29 08:28:20',1),(392,'c5df7ff6-8c6a-4656-a8c2-618a39624a42','hw_vif_model','virtio','2025-11-29 08:23:59','2025-11-29 08:28:20','2025-11-29 08:28:20',1),(393,'c5df7ff6-8c6a-4656-a8c2-618a39624a42','instance_uuid','4702f4ee-458d-4146-b9b2-70ecf718176c','2025-11-29 08:23:59','2025-11-29 08:28:20','2025-11-29 08:28:20',1),(394,'c5df7ff6-8c6a-4656-a8c2-618a39624a42','user_id','873186539acb4bf9b90513e0e1beb56f','2025-11-29 08:23:59','2025-11-29 08:28:20','2025-11-29 08:28:20',1),(395,'c5df7ff6-8c6a-4656-a8c2-618a39624a42','image_type','snapshot','2025-11-29 08:23:59','2025-11-29 08:28:20','2025-11-29 08:28:20',1),(396,'c5df7ff6-8c6a-4656-a8c2-618a39624a42','owner_id','a9a83f8d8d7f4d08890407f978c05166','2025-11-29 08:24:09','2025-11-29 08:28:20','2025-11-29 08:28:20',1),(397,'c5df7ff6-8c6a-4656-a8c2-618a39624a42','image_state','available','2025-11-29 08:24:09','2025-11-29 08:28:20','2025-11-29 08:28:20',1),(398,'c5df7ff6-8c6a-4656-a8c2-618a39624a42','image_location','snapshot','2025-11-29 08:24:09','2025-11-29 08:28:20','2025-11-29 08:28:20',1),(399,'c5df7ff6-8c6a-4656-a8c2-618a39624a42','hw_rescue_bus','scsi','2025-11-29 08:24:13','2025-11-29 08:28:20','2025-11-29 08:28:20',1),(400,'c5df7ff6-8c6a-4656-a8c2-618a39624a42','hw_rescue_device','disk','2025-11-29 08:24:14','2025-11-29 08:28:20','2025-11-29 08:28:20',1),(401,'7462d96e-a79d-4947-a963-039652361944','hw_rng_model','virtio','2025-11-29 08:24:58','2025-11-29 08:28:09','2025-11-29 08:28:09',1),(402,'7462d96e-a79d-4947-a963-039652361944','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:24:58','2025-11-29 08:28:09','2025-11-29 08:28:09',1),(403,'7462d96e-a79d-4947-a963-039652361944','owner_user_name','tempest-ServerStableDeviceRescueTest-507673154-project-member','2025-11-29 08:24:58','2025-11-29 08:28:09','2025-11-29 08:28:09',1),(404,'7462d96e-a79d-4947-a963-039652361944','owner_project_name','tempest-ServerStableDeviceRescueTest-507673154','2025-11-29 08:24:58','2025-11-29 08:28:09','2025-11-29 08:28:09',1),(405,'7462d96e-a79d-4947-a963-039652361944','boot_roles','member,reader','2025-11-29 08:24:58','2025-11-29 08:28:09','2025-11-29 08:28:09',1),(406,'7462d96e-a79d-4947-a963-039652361944','hw_machine_type','q35','2025-11-29 08:24:58','2025-11-29 08:28:09','2025-11-29 08:28:09',1),(407,'7462d96e-a79d-4947-a963-039652361944','hw_cdrom_bus','sata','2025-11-29 08:24:58','2025-11-29 08:28:09','2025-11-29 08:28:09',1),(408,'7462d96e-a79d-4947-a963-039652361944','hw_disk_bus','virtio','2025-11-29 08:24:58','2025-11-29 08:28:09','2025-11-29 08:28:09',1),(409,'7462d96e-a79d-4947-a963-039652361944','hw_input_bus','usb','2025-11-29 08:24:58','2025-11-29 08:28:09','2025-11-29 08:28:09',1),(410,'7462d96e-a79d-4947-a963-039652361944','hw_pointer_model','usbtablet','2025-11-29 08:24:58','2025-11-29 08:28:09','2025-11-29 08:28:09',1),(411,'7462d96e-a79d-4947-a963-039652361944','hw_video_model','virtio','2025-11-29 08:24:58','2025-11-29 08:28:09','2025-11-29 08:28:09',1),(412,'7462d96e-a79d-4947-a963-039652361944','hw_vif_model','virtio','2025-11-29 08:24:58','2025-11-29 08:28:09','2025-11-29 08:28:09',1),(413,'7462d96e-a79d-4947-a963-039652361944','instance_uuid','346e849d-fa61-4451-b34c-d6165fea3aa4','2025-11-29 08:24:58','2025-11-29 08:28:09','2025-11-29 08:28:09',1),(414,'7462d96e-a79d-4947-a963-039652361944','user_id','873186539acb4bf9b90513e0e1beb56f','2025-11-29 08:24:58','2025-11-29 08:28:09','2025-11-29 08:28:09',1),(415,'7462d96e-a79d-4947-a963-039652361944','image_type','snapshot','2025-11-29 08:24:58','2025-11-29 08:28:09','2025-11-29 08:28:09',1),(416,'7462d96e-a79d-4947-a963-039652361944','owner_id','a9a83f8d8d7f4d08890407f978c05166','2025-11-29 08:25:04','2025-11-29 08:28:09','2025-11-29 08:28:09',1),(417,'7462d96e-a79d-4947-a963-039652361944','image_state','available','2025-11-29 08:25:04','2025-11-29 08:28:09','2025-11-29 08:28:09',1),(418,'7462d96e-a79d-4947-a963-039652361944','image_location','snapshot','2025-11-29 08:25:04','2025-11-29 08:28:09','2025-11-29 08:28:09',1),(419,'7462d96e-a79d-4947-a963-039652361944','hw_rescue_bus','usb','2025-11-29 08:25:07','2025-11-29 08:28:09','2025-11-29 08:28:09',1),(420,'7462d96e-a79d-4947-a963-039652361944','hw_rescue_device','disk','2025-11-29 08:25:07','2025-11-29 08:28:09','2025-11-29 08:28:09',1),(421,'c73d83e2-0a3c-4e73-907f-124979a361df','hw_rng_model','virtio','2025-11-29 08:25:41','2025-11-29 08:28:02','2025-11-29 08:28:02',1),(422,'c73d83e2-0a3c-4e73-907f-124979a361df','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:25:41','2025-11-29 08:28:02','2025-11-29 08:28:02',1),(423,'c73d83e2-0a3c-4e73-907f-124979a361df','owner_user_name','tempest-ServerStableDeviceRescueTest-507673154-project-member','2025-11-29 08:25:41','2025-11-29 08:28:02','2025-11-29 08:28:02',1),(424,'c73d83e2-0a3c-4e73-907f-124979a361df','owner_project_name','tempest-ServerStableDeviceRescueTest-507673154','2025-11-29 08:25:41','2025-11-29 08:28:02','2025-11-29 08:28:02',1),(425,'c73d83e2-0a3c-4e73-907f-124979a361df','boot_roles','member,reader','2025-11-29 08:25:41','2025-11-29 08:28:02','2025-11-29 08:28:02',1),(426,'c73d83e2-0a3c-4e73-907f-124979a361df','hw_machine_type','q35','2025-11-29 08:25:41','2025-11-29 08:28:02','2025-11-29 08:28:02',1),(427,'c73d83e2-0a3c-4e73-907f-124979a361df','hw_cdrom_bus','sata','2025-11-29 08:25:41','2025-11-29 08:28:02','2025-11-29 08:28:02',1),(428,'c73d83e2-0a3c-4e73-907f-124979a361df','hw_disk_bus','virtio','2025-11-29 08:25:41','2025-11-29 08:28:02','2025-11-29 08:28:02',1),(429,'c73d83e2-0a3c-4e73-907f-124979a361df','hw_input_bus','usb','2025-11-29 08:25:41','2025-11-29 08:28:02','2025-11-29 08:28:02',1),(430,'c73d83e2-0a3c-4e73-907f-124979a361df','hw_pointer_model','usbtablet','2025-11-29 08:25:41','2025-11-29 08:28:02','2025-11-29 08:28:02',1),(431,'c73d83e2-0a3c-4e73-907f-124979a361df','hw_video_model','virtio','2025-11-29 08:25:41','2025-11-29 08:28:02','2025-11-29 08:28:02',1),(432,'c73d83e2-0a3c-4e73-907f-124979a361df','hw_vif_model','virtio','2025-11-29 08:25:41','2025-11-29 08:28:02','2025-11-29 08:28:02',1),(433,'c73d83e2-0a3c-4e73-907f-124979a361df','instance_uuid','e5dc7e85-787d-4ed8-9752-a604a1815f2b','2025-11-29 08:25:41','2025-11-29 08:28:02','2025-11-29 08:28:02',1),(434,'c73d83e2-0a3c-4e73-907f-124979a361df','user_id','873186539acb4bf9b90513e0e1beb56f','2025-11-29 08:25:41','2025-11-29 08:28:02','2025-11-29 08:28:02',1),(435,'c73d83e2-0a3c-4e73-907f-124979a361df','image_type','snapshot','2025-11-29 08:25:41','2025-11-29 08:28:02','2025-11-29 08:28:02',1),(436,'c73d83e2-0a3c-4e73-907f-124979a361df','image_location','snapshot','2025-11-29 08:25:45','2025-11-29 08:28:03','2025-11-29 08:28:03',1),(437,'c73d83e2-0a3c-4e73-907f-124979a361df','owner_id','a9a83f8d8d7f4d08890407f978c05166','2025-11-29 08:25:45','2025-11-29 08:28:03','2025-11-29 08:28:03',1),(438,'c73d83e2-0a3c-4e73-907f-124979a361df','image_state','available','2025-11-29 08:25:45','2025-11-29 08:28:03','2025-11-29 08:28:03',1),(439,'c73d83e2-0a3c-4e73-907f-124979a361df','hw_rescue_bus','virtio','2025-11-29 08:25:48','2025-11-29 08:28:03','2025-11-29 08:28:03',1),(440,'c73d83e2-0a3c-4e73-907f-124979a361df','hw_rescue_device','disk','2025-11-29 08:25:48','2025-11-29 08:28:03','2025-11-29 08:28:03',1),(441,'f5aee037-dd13-47e6-81af-147c317d7457','hw_rng_model','virtio','2025-11-29 08:26:40','2025-11-29 08:27:46','2025-11-29 08:27:46',1),(442,'f5aee037-dd13-47e6-81af-147c317d7457','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:26:40','2025-11-29 08:27:46','2025-11-29 08:27:46',1),(443,'f5aee037-dd13-47e6-81af-147c317d7457','owner_user_name','tempest-ServerStableDeviceRescueTest-507673154-project-member','2025-11-29 08:26:40','2025-11-29 08:27:46','2025-11-29 08:27:46',1),(444,'f5aee037-dd13-47e6-81af-147c317d7457','owner_project_name','tempest-ServerStableDeviceRescueTest-507673154','2025-11-29 08:26:40','2025-11-29 08:27:46','2025-11-29 08:27:46',1),(445,'f5aee037-dd13-47e6-81af-147c317d7457','boot_roles','reader,member','2025-11-29 08:26:40','2025-11-29 08:27:46','2025-11-29 08:27:46',1),(446,'f5aee037-dd13-47e6-81af-147c317d7457','hw_machine_type','q35','2025-11-29 08:26:40','2025-11-29 08:27:46','2025-11-29 08:27:46',1),(447,'f5aee037-dd13-47e6-81af-147c317d7457','hw_cdrom_bus','sata','2025-11-29 08:26:40','2025-11-29 08:27:46','2025-11-29 08:27:46',1),(448,'f5aee037-dd13-47e6-81af-147c317d7457','hw_disk_bus','virtio','2025-11-29 08:26:40','2025-11-29 08:27:46','2025-11-29 08:27:46',1),(449,'f5aee037-dd13-47e6-81af-147c317d7457','hw_input_bus','usb','2025-11-29 08:26:40','2025-11-29 08:27:46','2025-11-29 08:27:46',1),(450,'f5aee037-dd13-47e6-81af-147c317d7457','hw_pointer_model','usbtablet','2025-11-29 08:26:40','2025-11-29 08:27:47','2025-11-29 08:27:47',1),(451,'f5aee037-dd13-47e6-81af-147c317d7457','hw_video_model','virtio','2025-11-29 08:26:40','2025-11-29 08:27:47','2025-11-29 08:27:47',1),(452,'f5aee037-dd13-47e6-81af-147c317d7457','hw_vif_model','virtio','2025-11-29 08:26:40','2025-11-29 08:27:47','2025-11-29 08:27:47',1),(453,'f5aee037-dd13-47e6-81af-147c317d7457','instance_uuid','50daa6f5-6598-439f-a542-38e8ae7aded0','2025-11-29 08:26:40','2025-11-29 08:27:47','2025-11-29 08:27:47',1),(454,'f5aee037-dd13-47e6-81af-147c317d7457','user_id','873186539acb4bf9b90513e0e1beb56f','2025-11-29 08:26:40','2025-11-29 08:27:47','2025-11-29 08:27:47',1),(455,'f5aee037-dd13-47e6-81af-147c317d7457','image_type','snapshot','2025-11-29 08:26:40','2025-11-29 08:27:47','2025-11-29 08:27:47',1),(456,'f5aee037-dd13-47e6-81af-147c317d7457','image_location','snapshot','2025-11-29 08:26:46','2025-11-29 08:27:47','2025-11-29 08:27:47',1),(457,'f5aee037-dd13-47e6-81af-147c317d7457','owner_id','a9a83f8d8d7f4d08890407f978c05166','2025-11-29 08:26:46','2025-11-29 08:27:47','2025-11-29 08:27:47',1),(458,'f5aee037-dd13-47e6-81af-147c317d7457','image_state','available','2025-11-29 08:26:46','2025-11-29 08:27:47','2025-11-29 08:27:47',1),(459,'f5aee037-dd13-47e6-81af-147c317d7457','hw_rescue_bus','virtio','2025-11-29 08:26:49','2025-11-29 08:27:47','2025-11-29 08:27:47',1),(460,'f5aee037-dd13-47e6-81af-147c317d7457','hw_rescue_device','disk','2025-11-29 08:26:49','2025-11-29 08:27:47','2025-11-29 08:27:47',1),(461,'ff39bd0f-b544-46e3-a2c3-0aed51f8ff44','hw_rng_model','virtio','2025-11-29 08:27:27','2025-11-29 08:30:42','2025-11-29 08:30:42',1),(462,'ff39bd0f-b544-46e3-a2c3-0aed51f8ff44','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:27:27','2025-11-29 08:30:42','2025-11-29 08:30:42',1),(463,'ff39bd0f-b544-46e3-a2c3-0aed51f8ff44','owner_user_name','tempest-ServerBootFromVolumeStableRescueTest-1715153470-project-member','2025-11-29 08:27:27','2025-11-29 08:30:42','2025-11-29 08:30:42',1),(464,'ff39bd0f-b544-46e3-a2c3-0aed51f8ff44','owner_project_name','tempest-ServerBootFromVolumeStableRescueTest-1715153470','2025-11-29 08:27:27','2025-11-29 08:30:42','2025-11-29 08:30:42',1),(465,'ff39bd0f-b544-46e3-a2c3-0aed51f8ff44','boot_roles','member,reader','2025-11-29 08:27:27','2025-11-29 08:30:42','2025-11-29 08:30:42',1),(466,'ff39bd0f-b544-46e3-a2c3-0aed51f8ff44','hw_machine_type','q35','2025-11-29 08:27:27','2025-11-29 08:30:42','2025-11-29 08:30:42',1),(467,'ff39bd0f-b544-46e3-a2c3-0aed51f8ff44','hw_cdrom_bus','sata','2025-11-29 08:27:27','2025-11-29 08:30:42','2025-11-29 08:30:42',1),(468,'ff39bd0f-b544-46e3-a2c3-0aed51f8ff44','hw_disk_bus','virtio','2025-11-29 08:27:27','2025-11-29 08:30:42','2025-11-29 08:30:42',1),(469,'ff39bd0f-b544-46e3-a2c3-0aed51f8ff44','hw_input_bus','usb','2025-11-29 08:27:27','2025-11-29 08:30:42','2025-11-29 08:30:42',1),(470,'ff39bd0f-b544-46e3-a2c3-0aed51f8ff44','hw_pointer_model','usbtablet','2025-11-29 08:27:27','2025-11-29 08:30:42','2025-11-29 08:30:42',1),(471,'ff39bd0f-b544-46e3-a2c3-0aed51f8ff44','hw_video_model','virtio','2025-11-29 08:27:27','2025-11-29 08:30:42','2025-11-29 08:30:42',1),(472,'ff39bd0f-b544-46e3-a2c3-0aed51f8ff44','hw_vif_model','virtio','2025-11-29 08:27:27','2025-11-29 08:30:42','2025-11-29 08:30:42',1),(473,'ff39bd0f-b544-46e3-a2c3-0aed51f8ff44','instance_uuid','480ae817-3676-4499-a047-6b8b383e7bf2','2025-11-29 08:27:27','2025-11-29 08:30:42','2025-11-29 08:30:42',1),(474,'ff39bd0f-b544-46e3-a2c3-0aed51f8ff44','user_id','64b11a4dc36b4f55b85dbe846183be55','2025-11-29 08:27:27','2025-11-29 08:30:42','2025-11-29 08:30:42',1),(475,'ff39bd0f-b544-46e3-a2c3-0aed51f8ff44','image_type','snapshot','2025-11-29 08:27:27','2025-11-29 08:30:42','2025-11-29 08:30:42',1),(476,'ff39bd0f-b544-46e3-a2c3-0aed51f8ff44','image_location','snapshot','2025-11-29 08:27:33','2025-11-29 08:30:42','2025-11-29 08:30:42',1),(477,'ff39bd0f-b544-46e3-a2c3-0aed51f8ff44','owner_id','ae71059d02774857be85797a3be0e4e6','2025-11-29 08:27:33','2025-11-29 08:30:42','2025-11-29 08:30:42',1),(478,'ff39bd0f-b544-46e3-a2c3-0aed51f8ff44','image_state','available','2025-11-29 08:27:33','2025-11-29 08:30:42','2025-11-29 08:30:42',1),(479,'ff39bd0f-b544-46e3-a2c3-0aed51f8ff44','hw_rescue_bus','virtio','2025-11-29 08:27:50','2025-11-29 08:30:42','2025-11-29 08:30:42',1),(480,'ff39bd0f-b544-46e3-a2c3-0aed51f8ff44','hw_rescue_device','disk','2025-11-29 08:27:50','2025-11-29 08:30:42','2025-11-29 08:30:42',1),(481,'2d9af198-baca-4fb0-8bbb-100141aac9db','hw_rng_model','virtio','2025-11-29 08:29:26','2025-11-29 08:30:33','2025-11-29 08:30:33',1),(482,'2d9af198-baca-4fb0-8bbb-100141aac9db','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:29:26','2025-11-29 08:30:33','2025-11-29 08:30:33',1),(483,'2d9af198-baca-4fb0-8bbb-100141aac9db','owner_user_name','tempest-ServerBootFromVolumeStableRescueTest-1715153470-project-member','2025-11-29 08:29:26','2025-11-29 08:30:33','2025-11-29 08:30:33',1),(484,'2d9af198-baca-4fb0-8bbb-100141aac9db','owner_project_name','tempest-ServerBootFromVolumeStableRescueTest-1715153470','2025-11-29 08:29:26','2025-11-29 08:30:33','2025-11-29 08:30:33',1),(485,'2d9af198-baca-4fb0-8bbb-100141aac9db','boot_roles','reader,member','2025-11-29 08:29:26','2025-11-29 08:30:33','2025-11-29 08:30:33',1),(486,'2d9af198-baca-4fb0-8bbb-100141aac9db','hw_machine_type','q35','2025-11-29 08:29:26','2025-11-29 08:30:33','2025-11-29 08:30:33',1),(487,'2d9af198-baca-4fb0-8bbb-100141aac9db','hw_cdrom_bus','sata','2025-11-29 08:29:26','2025-11-29 08:30:33','2025-11-29 08:30:33',1),(488,'2d9af198-baca-4fb0-8bbb-100141aac9db','hw_disk_bus','virtio','2025-11-29 08:29:26','2025-11-29 08:30:33','2025-11-29 08:30:33',1),(489,'2d9af198-baca-4fb0-8bbb-100141aac9db','hw_input_bus','usb','2025-11-29 08:29:26','2025-11-29 08:30:33','2025-11-29 08:30:33',1),(490,'2d9af198-baca-4fb0-8bbb-100141aac9db','hw_pointer_model','usbtablet','2025-11-29 08:29:26','2025-11-29 08:30:33','2025-11-29 08:30:33',1),(491,'2d9af198-baca-4fb0-8bbb-100141aac9db','hw_video_model','virtio','2025-11-29 08:29:26','2025-11-29 08:30:33','2025-11-29 08:30:33',1),(492,'2d9af198-baca-4fb0-8bbb-100141aac9db','hw_vif_model','virtio','2025-11-29 08:29:26','2025-11-29 08:30:33','2025-11-29 08:30:33',1),(493,'2d9af198-baca-4fb0-8bbb-100141aac9db','instance_uuid','8ba722d8-f0b0-426b-a972-888ebce61a32','2025-11-29 08:29:26','2025-11-29 08:30:33','2025-11-29 08:30:33',1),(494,'2d9af198-baca-4fb0-8bbb-100141aac9db','user_id','64b11a4dc36b4f55b85dbe846183be55','2025-11-29 08:29:26','2025-11-29 08:30:33','2025-11-29 08:30:33',1),(495,'2d9af198-baca-4fb0-8bbb-100141aac9db','image_type','snapshot','2025-11-29 08:29:26','2025-11-29 08:30:33','2025-11-29 08:30:33',1),(496,'2d9af198-baca-4fb0-8bbb-100141aac9db','image_location','snapshot','2025-11-29 08:29:31','2025-11-29 08:30:33','2025-11-29 08:30:33',1),(497,'2d9af198-baca-4fb0-8bbb-100141aac9db','owner_id','ae71059d02774857be85797a3be0e4e6','2025-11-29 08:29:31','2025-11-29 08:30:33','2025-11-29 08:30:33',1),(498,'2d9af198-baca-4fb0-8bbb-100141aac9db','image_state','available','2025-11-29 08:29:31','2025-11-29 08:30:33','2025-11-29 08:30:33',1),(499,'2d9af198-baca-4fb0-8bbb-100141aac9db','hw_rescue_bus','virtio','2025-11-29 08:30:02','2025-11-29 08:30:33','2025-11-29 08:30:33',1),(500,'2d9af198-baca-4fb0-8bbb-100141aac9db','hw_rescue_device','disk','2025-11-29 08:30:02','2025-11-29 08:30:33','2025-11-29 08:30:33',1),(501,'2ec96c0d-69b9-4690-b860-0f20dd8b17cd','signature_verified','False','2025-11-29 08:35:12','2025-11-29 08:35:19','2025-11-29 08:35:19',1),(502,'2ec96c0d-69b9-4690-b860-0f20dd8b17cd','hw_rng_model','virtio','2025-11-29 08:35:12','2025-11-29 08:35:19','2025-11-29 08:35:19',1),(503,'2ec96c0d-69b9-4690-b860-0f20dd8b17cd','base_image_ref','','2025-11-29 08:35:12','2025-11-29 08:35:19','2025-11-29 08:35:19',1),(504,'2ec96c0d-69b9-4690-b860-0f20dd8b17cd','owner_user_name','tempest-AttachVolumeMultiAttachTest-573425942-project-member','2025-11-29 08:35:12','2025-11-29 08:35:19','2025-11-29 08:35:19',1),(505,'2ec96c0d-69b9-4690-b860-0f20dd8b17cd','owner_project_name','tempest-AttachVolumeMultiAttachTest-573425942','2025-11-29 08:35:12','2025-11-29 08:35:19','2025-11-29 08:35:19',1),(506,'2ec96c0d-69b9-4690-b860-0f20dd8b17cd','boot_roles','member,reader','2025-11-29 08:35:12','2025-11-29 08:35:19','2025-11-29 08:35:19',1),(507,'2ec96c0d-69b9-4690-b860-0f20dd8b17cd','hw_machine_type','q35','2025-11-29 08:35:12','2025-11-29 08:35:19','2025-11-29 08:35:19',1),(508,'2ec96c0d-69b9-4690-b860-0f20dd8b17cd','hw_cdrom_bus','sata','2025-11-29 08:35:12','2025-11-29 08:35:19','2025-11-29 08:35:19',1),(509,'2ec96c0d-69b9-4690-b860-0f20dd8b17cd','hw_disk_bus','virtio','2025-11-29 08:35:12','2025-11-29 08:35:19','2025-11-29 08:35:19',1),(510,'2ec96c0d-69b9-4690-b860-0f20dd8b17cd','hw_input_bus','usb','2025-11-29 08:35:12','2025-11-29 08:35:19','2025-11-29 08:35:19',1),(511,'2ec96c0d-69b9-4690-b860-0f20dd8b17cd','hw_pointer_model','usbtablet','2025-11-29 08:35:12','2025-11-29 08:35:19','2025-11-29 08:35:19',1),(512,'2ec96c0d-69b9-4690-b860-0f20dd8b17cd','hw_video_model','virtio','2025-11-29 08:35:12','2025-11-29 08:35:19','2025-11-29 08:35:19',1),(513,'2ec96c0d-69b9-4690-b860-0f20dd8b17cd','hw_vif_model','virtio','2025-11-29 08:35:12','2025-11-29 08:35:20','2025-11-29 08:35:20',1),(514,'2ec96c0d-69b9-4690-b860-0f20dd8b17cd','root_device_name','/dev/vda','2025-11-29 08:35:12','2025-11-29 08:35:20','2025-11-29 08:35:20',1),(515,'2ec96c0d-69b9-4690-b860-0f20dd8b17cd','block_device_mapping','[{\"device_name\": \"/dev/vda\", \"snapshot_id\": \"f1b378b6-b3b7-477d-8029-338c3783f767\", \"destination_type\": \"volume\", \"volume_type\": null, \"encryption_options\": null, \"volume_id\": null, \"source_type\": \"snapshot\", \"no_device\": null, \"guest_format\": null, \"tag\": null, \"volume_size\": 1, \"device_type\": \"disk\", \"disk_bus\": \"virtio\", \"encryption_secret_uuid\": null, \"boot_index\": 0, \"encryption_format\": null, \"encrypted\": null, \"delete_on_termination\": false, \"image_id\": null}]','2025-11-29 08:35:12','2025-11-29 08:35:20','2025-11-29 08:35:20',1),(516,'2ec96c0d-69b9-4690-b860-0f20dd8b17cd','bdm_v2','True','2025-11-29 08:35:12','2025-11-29 08:35:20','2025-11-29 08:35:20',1),(517,'f502084d-e717-47c5-8881-072bf335e491','hw_rng_model','virtio','2025-11-29 08:35:32','2025-11-29 08:36:15','2025-11-29 08:36:15',1),(518,'f502084d-e717-47c5-8881-072bf335e491','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:35:32','2025-11-29 08:36:15','2025-11-29 08:36:15',1),(519,'f502084d-e717-47c5-8881-072bf335e491','owner_user_name','tempest-ServersNegativeTestJSON-1016750887-project-member','2025-11-29 08:35:32','2025-11-29 08:36:15','2025-11-29 08:36:15',1),(520,'f502084d-e717-47c5-8881-072bf335e491','owner_project_name','tempest-ServersNegativeTestJSON-1016750887','2025-11-29 08:35:32','2025-11-29 08:36:15','2025-11-29 08:36:15',1),(521,'f502084d-e717-47c5-8881-072bf335e491','boot_roles','reader,member','2025-11-29 08:35:32','2025-11-29 08:36:15','2025-11-29 08:36:15',1),(522,'f502084d-e717-47c5-8881-072bf335e491','hw_machine_type','q35','2025-11-29 08:35:32','2025-11-29 08:36:15','2025-11-29 08:36:15',1),(523,'f502084d-e717-47c5-8881-072bf335e491','hw_cdrom_bus','sata','2025-11-29 08:35:32','2025-11-29 08:36:15','2025-11-29 08:36:15',1),(524,'f502084d-e717-47c5-8881-072bf335e491','hw_disk_bus','virtio','2025-11-29 08:35:32','2025-11-29 08:36:15','2025-11-29 08:36:15',1),(525,'f502084d-e717-47c5-8881-072bf335e491','hw_input_bus','usb','2025-11-29 08:35:32','2025-11-29 08:36:15','2025-11-29 08:36:15',1),(526,'f502084d-e717-47c5-8881-072bf335e491','hw_pointer_model','usbtablet','2025-11-29 08:35:32','2025-11-29 08:36:15','2025-11-29 08:36:15',1),(527,'f502084d-e717-47c5-8881-072bf335e491','hw_video_model','virtio','2025-11-29 08:35:32','2025-11-29 08:36:15','2025-11-29 08:36:15',1),(528,'f502084d-e717-47c5-8881-072bf335e491','hw_vif_model','virtio','2025-11-29 08:35:32','2025-11-29 08:36:15','2025-11-29 08:36:15',1),(529,'f502084d-e717-47c5-8881-072bf335e491','instance_uuid','aaaa6a6b-0c21-483c-b891-02ebe64e6aab','2025-11-29 08:35:32','2025-11-29 08:36:15','2025-11-29 08:36:15',1),(530,'f502084d-e717-47c5-8881-072bf335e491','user_id','a57807acb02b45d082f242ec62cd5b6f','2025-11-29 08:35:32','2025-11-29 08:36:15','2025-11-29 08:36:15',1),(531,'f502084d-e717-47c5-8881-072bf335e491','image_type','snapshot','2025-11-29 08:35:32','2025-11-29 08:36:15','2025-11-29 08:36:15',1),(532,'f502084d-e717-47c5-8881-072bf335e491','image_location','snapshot','2025-11-29 08:35:40','2025-11-29 08:36:15','2025-11-29 08:36:15',1),(533,'f502084d-e717-47c5-8881-072bf335e491','owner_id','96e72e7660da497a8b6bf9fdb03fe84c','2025-11-29 08:35:40','2025-11-29 08:36:15','2025-11-29 08:36:15',1),(534,'f502084d-e717-47c5-8881-072bf335e491','image_state','available','2025-11-29 08:35:40','2025-11-29 08:36:15','2025-11-29 08:36:15',1),(535,'c373ab38-0e65-4d5c-bf51-8234f0ed5ffd','hw_rng_model','virtio','2025-11-29 08:38:04','2025-11-29 08:38:35','2025-11-29 08:38:35',1),(536,'c373ab38-0e65-4d5c-bf51-8234f0ed5ffd','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:38:04','2025-11-29 08:38:35','2025-11-29 08:38:35',1),(537,'c373ab38-0e65-4d5c-bf51-8234f0ed5ffd','owner_user_name','tempest-AttachVolumeShelveTestJSON-907905934-project-member','2025-11-29 08:38:04','2025-11-29 08:38:35','2025-11-29 08:38:35',1),(538,'c373ab38-0e65-4d5c-bf51-8234f0ed5ffd','owner_project_name','tempest-AttachVolumeShelveTestJSON-907905934','2025-11-29 08:38:04','2025-11-29 08:38:35','2025-11-29 08:38:35',1),(539,'c373ab38-0e65-4d5c-bf51-8234f0ed5ffd','boot_roles','member,reader','2025-11-29 08:38:04','2025-11-29 08:38:35','2025-11-29 08:38:35',1),(540,'c373ab38-0e65-4d5c-bf51-8234f0ed5ffd','hw_machine_type','q35','2025-11-29 08:38:04','2025-11-29 08:38:35','2025-11-29 08:38:35',1),(541,'c373ab38-0e65-4d5c-bf51-8234f0ed5ffd','hw_cdrom_bus','sata','2025-11-29 08:38:04','2025-11-29 08:38:35','2025-11-29 08:38:35',1),(542,'c373ab38-0e65-4d5c-bf51-8234f0ed5ffd','hw_disk_bus','virtio','2025-11-29 08:38:04','2025-11-29 08:38:35','2025-11-29 08:38:35',1),(543,'c373ab38-0e65-4d5c-bf51-8234f0ed5ffd','hw_input_bus','usb','2025-11-29 08:38:04','2025-11-29 08:38:35','2025-11-29 08:38:35',1),(544,'c373ab38-0e65-4d5c-bf51-8234f0ed5ffd','hw_pointer_model','usbtablet','2025-11-29 08:38:04','2025-11-29 08:38:35','2025-11-29 08:38:35',1),(545,'c373ab38-0e65-4d5c-bf51-8234f0ed5ffd','hw_video_model','virtio','2025-11-29 08:38:04','2025-11-29 08:38:35','2025-11-29 08:38:35',1),(546,'c373ab38-0e65-4d5c-bf51-8234f0ed5ffd','hw_vif_model','virtio','2025-11-29 08:38:04','2025-11-29 08:38:35','2025-11-29 08:38:35',1),(547,'c373ab38-0e65-4d5c-bf51-8234f0ed5ffd','instance_uuid','5748313e-fbb3-409e-83e6-aff548491530','2025-11-29 08:38:04','2025-11-29 08:38:35','2025-11-29 08:38:35',1),(548,'c373ab38-0e65-4d5c-bf51-8234f0ed5ffd','user_id','eeba34466b8f4a1bb5f742f1e811053c','2025-11-29 08:38:04','2025-11-29 08:38:35','2025-11-29 08:38:35',1),(549,'c373ab38-0e65-4d5c-bf51-8234f0ed5ffd','image_type','snapshot','2025-11-29 08:38:04','2025-11-29 08:38:35','2025-11-29 08:38:35',1),(550,'c373ab38-0e65-4d5c-bf51-8234f0ed5ffd','image_location','snapshot','2025-11-29 08:38:12','2025-11-29 08:38:35','2025-11-29 08:38:35',1),(551,'c373ab38-0e65-4d5c-bf51-8234f0ed5ffd','owner_id','889608c71d13429fb37793575792ae74','2025-11-29 08:38:12','2025-11-29 08:38:35','2025-11-29 08:38:35',1),(552,'c373ab38-0e65-4d5c-bf51-8234f0ed5ffd','image_state','available','2025-11-29 08:38:12','2025-11-29 08:38:35','2025-11-29 08:38:35',1),(553,'eb8dd751-ecc7-464b-8f9f-4f4d38e755cf','hw_rng_model','virtio','2025-11-29 08:39:38','2025-11-29 08:40:14','2025-11-29 08:40:14',1),(554,'eb8dd751-ecc7-464b-8f9f-4f4d38e755cf','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:39:38','2025-11-29 08:40:14','2025-11-29 08:40:14',1),(555,'eb8dd751-ecc7-464b-8f9f-4f4d38e755cf','owner_user_name','tempest-AttachVolumeShelveTestJSON-907905934-project-member','2025-11-29 08:39:38','2025-11-29 08:40:14','2025-11-29 08:40:14',1),(556,'eb8dd751-ecc7-464b-8f9f-4f4d38e755cf','owner_project_name','tempest-AttachVolumeShelveTestJSON-907905934','2025-11-29 08:39:38','2025-11-29 08:40:14','2025-11-29 08:40:14',1),(557,'eb8dd751-ecc7-464b-8f9f-4f4d38e755cf','boot_roles','reader,member','2025-11-29 08:39:38','2025-11-29 08:40:14','2025-11-29 08:40:14',1),(558,'eb8dd751-ecc7-464b-8f9f-4f4d38e755cf','hw_machine_type','q35','2025-11-29 08:39:38','2025-11-29 08:40:14','2025-11-29 08:40:14',1),(559,'eb8dd751-ecc7-464b-8f9f-4f4d38e755cf','hw_cdrom_bus','sata','2025-11-29 08:39:38','2025-11-29 08:40:14','2025-11-29 08:40:14',1),(560,'eb8dd751-ecc7-464b-8f9f-4f4d38e755cf','hw_disk_bus','virtio','2025-11-29 08:39:38','2025-11-29 08:40:14','2025-11-29 08:40:14',1),(561,'eb8dd751-ecc7-464b-8f9f-4f4d38e755cf','hw_input_bus','usb','2025-11-29 08:39:38','2025-11-29 08:40:14','2025-11-29 08:40:14',1),(562,'eb8dd751-ecc7-464b-8f9f-4f4d38e755cf','hw_pointer_model','usbtablet','2025-11-29 08:39:38','2025-11-29 08:40:14','2025-11-29 08:40:14',1),(563,'eb8dd751-ecc7-464b-8f9f-4f4d38e755cf','hw_video_model','virtio','2025-11-29 08:39:38','2025-11-29 08:40:14','2025-11-29 08:40:14',1),(564,'eb8dd751-ecc7-464b-8f9f-4f4d38e755cf','hw_vif_model','virtio','2025-11-29 08:39:38','2025-11-29 08:40:14','2025-11-29 08:40:14',1),(565,'eb8dd751-ecc7-464b-8f9f-4f4d38e755cf','instance_uuid','78534f04-30a6-4f58-9768-091f48082c9c','2025-11-29 08:39:38','2025-11-29 08:40:14','2025-11-29 08:40:14',1),(566,'eb8dd751-ecc7-464b-8f9f-4f4d38e755cf','user_id','eeba34466b8f4a1bb5f742f1e811053c','2025-11-29 08:39:38','2025-11-29 08:40:14','2025-11-29 08:40:14',1),(567,'eb8dd751-ecc7-464b-8f9f-4f4d38e755cf','image_type','snapshot','2025-11-29 08:39:38','2025-11-29 08:40:14','2025-11-29 08:40:14',1),(568,'eb8dd751-ecc7-464b-8f9f-4f4d38e755cf','owner_id','889608c71d13429fb37793575792ae74','2025-11-29 08:39:52','2025-11-29 08:40:14','2025-11-29 08:40:14',1),(569,'eb8dd751-ecc7-464b-8f9f-4f4d38e755cf','image_state','available','2025-11-29 08:39:52','2025-11-29 08:40:14','2025-11-29 08:40:14',1),(570,'eb8dd751-ecc7-464b-8f9f-4f4d38e755cf','image_location','snapshot','2025-11-29 08:39:52','2025-11-29 08:40:14','2025-11-29 08:40:14',1),(571,'a9d624a0-fd76-47d0-81ab-f89f80fec0c1','hw_rng_model','virtio','2025-11-29 08:44:23','2025-11-29 08:45:37','2025-11-29 08:45:37',1),(572,'a9d624a0-fd76-47d0-81ab-f89f80fec0c1','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:44:23','2025-11-29 08:45:37','2025-11-29 08:45:37',1),(573,'a9d624a0-fd76-47d0-81ab-f89f80fec0c1','owner_user_name','tempest-TestStampPattern-1305027466-project-member','2025-11-29 08:44:23','2025-11-29 08:45:37','2025-11-29 08:45:37',1),(574,'a9d624a0-fd76-47d0-81ab-f89f80fec0c1','owner_project_name','tempest-TestStampPattern-1305027466','2025-11-29 08:44:23','2025-11-29 08:45:37','2025-11-29 08:45:37',1),(575,'a9d624a0-fd76-47d0-81ab-f89f80fec0c1','boot_roles','member,reader','2025-11-29 08:44:23','2025-11-29 08:45:37','2025-11-29 08:45:37',1),(576,'a9d624a0-fd76-47d0-81ab-f89f80fec0c1','hw_machine_type','q35','2025-11-29 08:44:23','2025-11-29 08:45:37','2025-11-29 08:45:37',1),(577,'a9d624a0-fd76-47d0-81ab-f89f80fec0c1','hw_cdrom_bus','sata','2025-11-29 08:44:23','2025-11-29 08:45:37','2025-11-29 08:45:37',1),(578,'a9d624a0-fd76-47d0-81ab-f89f80fec0c1','hw_disk_bus','virtio','2025-11-29 08:44:23','2025-11-29 08:45:37','2025-11-29 08:45:37',1),(579,'a9d624a0-fd76-47d0-81ab-f89f80fec0c1','hw_input_bus','usb','2025-11-29 08:44:23','2025-11-29 08:45:37','2025-11-29 08:45:37',1),(580,'a9d624a0-fd76-47d0-81ab-f89f80fec0c1','hw_pointer_model','usbtablet','2025-11-29 08:44:23','2025-11-29 08:45:37','2025-11-29 08:45:37',1),(581,'a9d624a0-fd76-47d0-81ab-f89f80fec0c1','hw_video_model','virtio','2025-11-29 08:44:24','2025-11-29 08:45:37','2025-11-29 08:45:37',1),(582,'a9d624a0-fd76-47d0-81ab-f89f80fec0c1','hw_vif_model','virtio','2025-11-29 08:44:24','2025-11-29 08:45:37','2025-11-29 08:45:37',1),(583,'a9d624a0-fd76-47d0-81ab-f89f80fec0c1','instance_uuid','3941161c-104e-452f-8d56-54600d37d0f5','2025-11-29 08:44:24','2025-11-29 08:45:37','2025-11-29 08:45:37',1),(584,'a9d624a0-fd76-47d0-81ab-f89f80fec0c1','user_id','01c0b956e2c74d5798d01fc2be0a8bac','2025-11-29 08:44:24','2025-11-29 08:45:37','2025-11-29 08:45:37',1),(585,'a9d624a0-fd76-47d0-81ab-f89f80fec0c1','image_type','snapshot','2025-11-29 08:44:24','2025-11-29 08:45:37','2025-11-29 08:45:37',1),(586,'19c04997-1e5f-42a9-90ff-a53c93a49ed0','hw_rng_model','virtio','2025-11-29 08:44:24','2025-11-29 08:45:35','2025-11-29 08:45:35',1),(587,'19c04997-1e5f-42a9-90ff-a53c93a49ed0','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:44:24','2025-11-29 08:45:35','2025-11-29 08:45:35',1),(588,'19c04997-1e5f-42a9-90ff-a53c93a49ed0','owner_user_name','tempest-TestSnapshotPattern-1740419556-project-member','2025-11-29 08:44:24','2025-11-29 08:45:35','2025-11-29 08:45:35',1),(589,'19c04997-1e5f-42a9-90ff-a53c93a49ed0','owner_project_name','tempest-TestSnapshotPattern-1740419556','2025-11-29 08:44:24','2025-11-29 08:45:35','2025-11-29 08:45:35',1),(590,'19c04997-1e5f-42a9-90ff-a53c93a49ed0','boot_roles','reader,member','2025-11-29 08:44:24','2025-11-29 08:45:35','2025-11-29 08:45:35',1),(591,'19c04997-1e5f-42a9-90ff-a53c93a49ed0','hw_machine_type','q35','2025-11-29 08:44:24','2025-11-29 08:45:35','2025-11-29 08:45:35',1),(592,'19c04997-1e5f-42a9-90ff-a53c93a49ed0','hw_cdrom_bus','sata','2025-11-29 08:44:24','2025-11-29 08:45:35','2025-11-29 08:45:35',1),(593,'19c04997-1e5f-42a9-90ff-a53c93a49ed0','hw_disk_bus','virtio','2025-11-29 08:44:24','2025-11-29 08:45:35','2025-11-29 08:45:35',1),(594,'19c04997-1e5f-42a9-90ff-a53c93a49ed0','hw_input_bus','usb','2025-11-29 08:44:24','2025-11-29 08:45:35','2025-11-29 08:45:35',1),(595,'19c04997-1e5f-42a9-90ff-a53c93a49ed0','hw_pointer_model','usbtablet','2025-11-29 08:44:24','2025-11-29 08:45:35','2025-11-29 08:45:35',1),(596,'19c04997-1e5f-42a9-90ff-a53c93a49ed0','hw_video_model','virtio','2025-11-29 08:44:24','2025-11-29 08:45:35','2025-11-29 08:45:35',1),(597,'19c04997-1e5f-42a9-90ff-a53c93a49ed0','hw_vif_model','virtio','2025-11-29 08:44:24','2025-11-29 08:45:35','2025-11-29 08:45:35',1),(598,'19c04997-1e5f-42a9-90ff-a53c93a49ed0','instance_uuid','da14f334-c7fe-428d-b6d2-32c2f4cc4054','2025-11-29 08:44:24','2025-11-29 08:45:35','2025-11-29 08:45:35',1),(599,'19c04997-1e5f-42a9-90ff-a53c93a49ed0','user_id','5ac9cfdaf51b4a5ab874f7e3571f88a0','2025-11-29 08:44:24','2025-11-29 08:45:35','2025-11-29 08:45:35',1),(600,'19c04997-1e5f-42a9-90ff-a53c93a49ed0','image_type','snapshot','2025-11-29 08:44:24','2025-11-29 08:45:35','2025-11-29 08:45:35',1),(601,'19c04997-1e5f-42a9-90ff-a53c93a49ed0','image_location','snapshot','2025-11-29 08:44:28','2025-11-29 08:45:35','2025-11-29 08:45:35',1),(602,'19c04997-1e5f-42a9-90ff-a53c93a49ed0','owner_id','66ee3b60fb89476383201ba204858d4d','2025-11-29 08:44:28','2025-11-29 08:45:35','2025-11-29 08:45:35',1),(603,'19c04997-1e5f-42a9-90ff-a53c93a49ed0','image_state','available','2025-11-29 08:44:28','2025-11-29 08:45:35','2025-11-29 08:45:35',1),(604,'a9d624a0-fd76-47d0-81ab-f89f80fec0c1','owner_id','3b3b0484057a4e3db51366d29c6b684d','2025-11-29 08:44:28','2025-11-29 08:45:37','2025-11-29 08:45:37',1),(605,'a9d624a0-fd76-47d0-81ab-f89f80fec0c1','image_state','available','2025-11-29 08:44:28','2025-11-29 08:45:37','2025-11-29 08:45:37',1),(606,'a9d624a0-fd76-47d0-81ab-f89f80fec0c1','image_location','snapshot','2025-11-29 08:44:28','2025-11-29 08:45:37','2025-11-29 08:45:37',1),(607,'19c04997-1e5f-42a9-90ff-a53c93a49ed0','version','8.0','2025-11-29 08:44:29','2025-11-29 08:45:35','2025-11-29 08:45:35',1),(608,'ea9de80a-851e-4cb9-ab40-64d7952ffbd1','hw_rng_model','virtio','2025-11-29 08:45:20','2025-11-29 08:45:28','2025-11-29 08:45:28',1),(609,'ea9de80a-851e-4cb9-ab40-64d7952ffbd1','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:45:20','2025-11-29 08:45:28','2025-11-29 08:45:28',1),(610,'ea9de80a-851e-4cb9-ab40-64d7952ffbd1','owner_user_name','tempest-TestSnapshotPattern-1740419556-project-member','2025-11-29 08:45:20','2025-11-29 08:45:28','2025-11-29 08:45:28',1),(611,'ea9de80a-851e-4cb9-ab40-64d7952ffbd1','owner_project_name','tempest-TestSnapshotPattern-1740419556','2025-11-29 08:45:20','2025-11-29 08:45:28','2025-11-29 08:45:28',1),(612,'ea9de80a-851e-4cb9-ab40-64d7952ffbd1','boot_roles','reader,member','2025-11-29 08:45:20','2025-11-29 08:45:28','2025-11-29 08:45:28',1),(613,'ea9de80a-851e-4cb9-ab40-64d7952ffbd1','hw_machine_type','q35','2025-11-29 08:45:20','2025-11-29 08:45:28','2025-11-29 08:45:28',1),(614,'ea9de80a-851e-4cb9-ab40-64d7952ffbd1','hw_cdrom_bus','sata','2025-11-29 08:45:20','2025-11-29 08:45:28','2025-11-29 08:45:28',1),(615,'ea9de80a-851e-4cb9-ab40-64d7952ffbd1','hw_disk_bus','virtio','2025-11-29 08:45:20','2025-11-29 08:45:28','2025-11-29 08:45:28',1),(616,'ea9de80a-851e-4cb9-ab40-64d7952ffbd1','hw_input_bus','usb','2025-11-29 08:45:20','2025-11-29 08:45:28','2025-11-29 08:45:28',1),(617,'ea9de80a-851e-4cb9-ab40-64d7952ffbd1','hw_pointer_model','usbtablet','2025-11-29 08:45:20','2025-11-29 08:45:28','2025-11-29 08:45:28',1),(618,'ea9de80a-851e-4cb9-ab40-64d7952ffbd1','hw_video_model','virtio','2025-11-29 08:45:20','2025-11-29 08:45:28','2025-11-29 08:45:28',1),(619,'ea9de80a-851e-4cb9-ab40-64d7952ffbd1','hw_vif_model','virtio','2025-11-29 08:45:20','2025-11-29 08:45:28','2025-11-29 08:45:28',1),(620,'ea9de80a-851e-4cb9-ab40-64d7952ffbd1','instance_uuid','4208aeda-c433-4ac5-8312-fb09ac9f4f83','2025-11-29 08:45:20','2025-11-29 08:45:28','2025-11-29 08:45:28',1),(621,'ea9de80a-851e-4cb9-ab40-64d7952ffbd1','user_id','5ac9cfdaf51b4a5ab874f7e3571f88a0','2025-11-29 08:45:20','2025-11-29 08:45:28','2025-11-29 08:45:28',1),(622,'ea9de80a-851e-4cb9-ab40-64d7952ffbd1','image_type','snapshot','2025-11-29 08:45:20','2025-11-29 08:45:28','2025-11-29 08:45:28',1),(623,'ea9de80a-851e-4cb9-ab40-64d7952ffbd1','image_location','snapshot','2025-11-29 08:45:20','2025-11-29 08:45:28','2025-11-29 08:45:28',1),(624,'ea9de80a-851e-4cb9-ab40-64d7952ffbd1','owner_id','66ee3b60fb89476383201ba204858d4d','2025-11-29 08:45:20','2025-11-29 08:45:28','2025-11-29 08:45:28',1),(625,'ea9de80a-851e-4cb9-ab40-64d7952ffbd1','image_state','available','2025-11-29 08:45:20','2025-11-29 08:45:28','2025-11-29 08:45:28',1),(626,'ea9de80a-851e-4cb9-ab40-64d7952ffbd1','version','8.0','2025-11-29 08:45:20','2025-11-29 08:45:28','2025-11-29 08:45:28',1),(627,'e21e97a9-475e-4ed4-bd3f-ad8000b59f07','hw_rng_model','virtio','2025-11-29 08:47:58','2025-11-29 08:48:24','2025-11-29 08:48:24',1),(628,'e21e97a9-475e-4ed4-bd3f-ad8000b59f07','base_image_ref','4873db8c-b414-4e95-acd9-77caabebe722','2025-11-29 08:47:58','2025-11-29 08:48:24','2025-11-29 08:48:24',1),(629,'e21e97a9-475e-4ed4-bd3f-ad8000b59f07','owner_user_name','tempest-TestShelveInstance-498716578-project-member','2025-11-29 08:47:58','2025-11-29 08:48:24','2025-11-29 08:48:24',1),(630,'e21e97a9-475e-4ed4-bd3f-ad8000b59f07','owner_project_name','tempest-TestShelveInstance-498716578','2025-11-29 08:47:58','2025-11-29 08:48:24','2025-11-29 08:48:24',1),(631,'e21e97a9-475e-4ed4-bd3f-ad8000b59f07','boot_roles','member,reader','2025-11-29 08:47:58','2025-11-29 08:48:24','2025-11-29 08:48:24',1),(632,'e21e97a9-475e-4ed4-bd3f-ad8000b59f07','hw_machine_type','q35','2025-11-29 08:47:58','2025-11-29 08:48:24','2025-11-29 08:48:24',1),(633,'e21e97a9-475e-4ed4-bd3f-ad8000b59f07','hw_cdrom_bus','sata','2025-11-29 08:47:58','2025-11-29 08:48:24','2025-11-29 08:48:24',1),(634,'e21e97a9-475e-4ed4-bd3f-ad8000b59f07','hw_disk_bus','virtio','2025-11-29 08:47:58','2025-11-29 08:48:24','2025-11-29 08:48:24',1),(635,'e21e97a9-475e-4ed4-bd3f-ad8000b59f07','hw_input_bus','usb','2025-11-29 08:47:58','2025-11-29 08:48:24','2025-11-29 08:48:24',1),(636,'e21e97a9-475e-4ed4-bd3f-ad8000b59f07','hw_pointer_model','usbtablet','2025-11-29 08:47:58','2025-11-29 08:48:24','2025-11-29 08:48:24',1),(637,'e21e97a9-475e-4ed4-bd3f-ad8000b59f07','hw_video_model','virtio','2025-11-29 08:47:58','2025-11-29 08:48:24','2025-11-29 08:48:24',1),(638,'e21e97a9-475e-4ed4-bd3f-ad8000b59f07','hw_vif_model','virtio','2025-11-29 08:47:58','2025-11-29 08:48:24','2025-11-29 08:48:24',1),(639,'e21e97a9-475e-4ed4-bd3f-ad8000b59f07','instance_uuid','6b7b3384-3de2-4098-b77f-3658f82eedfc','2025-11-29 08:47:58','2025-11-29 08:48:24','2025-11-29 08:48:24',1),(640,'e21e97a9-475e-4ed4-bd3f-ad8000b59f07','user_id','14d446574294425e9bc89e596ea56dc9','2025-11-29 08:47:58','2025-11-29 08:48:24','2025-11-29 08:48:24',1),(641,'e21e97a9-475e-4ed4-bd3f-ad8000b59f07','image_type','snapshot','2025-11-29 08:47:58','2025-11-29 08:48:24','2025-11-29 08:48:24',1),(642,'e21e97a9-475e-4ed4-bd3f-ad8000b59f07','image_location','snapshot','2025-11-29 08:48:05','2025-11-29 08:48:24','2025-11-29 08:48:24',1),(643,'e21e97a9-475e-4ed4-bd3f-ad8000b59f07','owner_id','2e636ab14fe94059b82b9cbcf8831d87','2025-11-29 08:48:05','2025-11-29 08:48:24','2025-11-29 08:48:24',1),(644,'e21e97a9-475e-4ed4-bd3f-ad8000b59f07','image_state','available','2025-11-29 08:48:05','2025-11-29 08:48:24','2025-11-29 08:48:24',1),(645,'ad73a146-3d66-454f-a206-ab6de9891225','signature_verified','False','2025-11-29 08:48:44','2025-11-29 08:49:50','2025-11-29 08:49:50',1),(646,'ad73a146-3d66-454f-a206-ab6de9891225','hw_rng_model','virtio','2025-11-29 08:48:44','2025-11-29 08:49:50','2025-11-29 08:49:50',1),(647,'ad73a146-3d66-454f-a206-ab6de9891225','base_image_ref','','2025-11-29 08:48:44','2025-11-29 08:49:50','2025-11-29 08:49:50',1),(648,'ad73a146-3d66-454f-a206-ab6de9891225','owner_user_name','tempest-TestVolumeBootPattern-1614567902-project-member','2025-11-29 08:48:44','2025-11-29 08:49:50','2025-11-29 08:49:50',1),(649,'ad73a146-3d66-454f-a206-ab6de9891225','owner_project_name','tempest-TestVolumeBootPattern-1614567902','2025-11-29 08:48:44','2025-11-29 08:49:50','2025-11-29 08:49:50',1),(650,'ad73a146-3d66-454f-a206-ab6de9891225','boot_roles','reader,member','2025-11-29 08:48:44','2025-11-29 08:49:50','2025-11-29 08:49:50',1),(651,'ad73a146-3d66-454f-a206-ab6de9891225','hw_machine_type','q35','2025-11-29 08:48:44','2025-11-29 08:49:50','2025-11-29 08:49:50',1),(652,'ad73a146-3d66-454f-a206-ab6de9891225','hw_cdrom_bus','sata','2025-11-29 08:48:44','2025-11-29 08:49:50','2025-11-29 08:49:50',1),(653,'ad73a146-3d66-454f-a206-ab6de9891225','hw_disk_bus','virtio','2025-11-29 08:48:44','2025-11-29 08:49:50','2025-11-29 08:49:50',1),(654,'ad73a146-3d66-454f-a206-ab6de9891225','hw_input_bus','usb','2025-11-29 08:48:44','2025-11-29 08:49:50','2025-11-29 08:49:50',1),(655,'ad73a146-3d66-454f-a206-ab6de9891225','hw_pointer_model','usbtablet','2025-11-29 08:48:44','2025-11-29 08:49:50','2025-11-29 08:49:50',1),(656,'ad73a146-3d66-454f-a206-ab6de9891225','hw_video_model','virtio','2025-11-29 08:48:44','2025-11-29 08:49:50','2025-11-29 08:49:50',1),(657,'ad73a146-3d66-454f-a206-ab6de9891225','hw_vif_model','virtio','2025-11-29 08:48:44','2025-11-29 08:49:50','2025-11-29 08:49:50',1),(658,'ad73a146-3d66-454f-a206-ab6de9891225','root_device_name','/dev/vda','2025-11-29 08:48:44','2025-11-29 08:49:50','2025-11-29 08:49:50',1),(659,'ad73a146-3d66-454f-a206-ab6de9891225','block_device_mapping','[{\"guest_format\": null, \"tag\": null, \"encrypted\": null, \"source_type\": \"snapshot\", \"no_device\": null, \"encryption_format\": null, \"volume_id\": null, \"boot_index\": 0, \"encryption_secret_uuid\": null, \"device_name\": \"/dev/vda\", \"disk_bus\": \"virtio\", \"device_type\": \"disk\", \"destination_type\": \"volume\", \"delete_on_termination\": true, \"encryption_options\": null, \"snapshot_id\": \"efcdc2f4-6579-4824-ad08-d6752dc23fc5\", \"image_id\": null, \"volume_size\": 1, \"volume_type\": null}]','2025-11-29 08:48:44','2025-11-29 08:49:50','2025-11-29 08:49:50',1),(660,'ad73a146-3d66-454f-a206-ab6de9891225','bdm_v2','True','2025-11-29 08:48:44','2025-11-29 08:49:50','2025-11-29 08:49:50',1);
/*!40000 ALTER TABLE `image_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_tags`
--

DROP TABLE IF EXISTS `image_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_tags_image_id` (`image_id`),
  KEY `ix_image_tags_image_id_tag_value` (`image_id`,`value`),
  CONSTRAINT `image_tags_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_tags`
--

LOCK TABLES `image_tags` WRITE;
/*!40000 ALTER TABLE `image_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `disk_format` varchar(20) DEFAULT NULL,
  `container_format` varchar(20) DEFAULT NULL,
  `checksum` varchar(32) DEFAULT NULL,
  `owner` varchar(255) DEFAULT NULL,
  `min_disk` int(11) NOT NULL,
  `min_ram` int(11) NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT 0,
  `virtual_size` bigint(20) DEFAULT NULL,
  `visibility` enum('private','public','shared','community') NOT NULL DEFAULT 'shared',
  `os_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `os_hash_algo` varchar(64) DEFAULT NULL,
  `os_hash_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checksum_image_idx` (`checksum`),
  KEY `ix_images_deleted` (`deleted`),
  KEY `owner_image_idx` (`owner`),
  KEY `created_at_image_idx` (`created_at`),
  KEY `updated_at_image_idx` (`updated_at`),
  KEY `visibility_image_idx` (`visibility`),
  KEY `os_hidden_image_idx` (`os_hidden`),
  KEY `os_hash_value_image_idx` (`os_hash_value`),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`protected` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` (`id`, `name`, `size`, `status`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `disk_format`, `container_format`, `checksum`, `owner`, `min_disk`, `min_ram`, `protected`, `virtual_size`, `visibility`, `os_hidden`, `os_hash_algo`, `os_hash_value`) VALUES ('0bdf7515-c07e-4918-9c17-60eba424f483','tempest-test-snap-1453916354',1073741824,'deleted','2025-11-29 08:05:21','2025-11-29 08:05:31','2025-11-29 08:05:31',1,'raw','bare',NULL,'638fd52fccf14f16b56d0860553063f3',1,0,0,NULL,'private',0,NULL,NULL),('0cf2e679-5ab5-4c82-bff4-cafd6b290960','tempest-ListImageFiltersTestJSON-image-1740489923',1024,'deleted','2025-11-29 08:03:22','2025-11-29 08:04:50','2025-11-29 08:04:50',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','1a7ab40578b84f6aa0f4d2225a36bf9e',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('10bcdd0b-a9bb-4ca1-8d7b-e11af81db4ec','tempest-scenario-img--1593838428',21430272,'deleted','2025-11-29 08:39:06','2025-11-29 08:41:38','2025-11-29 08:41:38',1,'qcow2','bare','c8fc807773e5354afe61636071771906','62ca01275fe34ea0af31d00b34d6d9a5',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('123394a7-8fc1-4d5c-8e9e-60cf6e1a8762','tempest-ImagesOneServerNegativeTestJSON-image-1240134964',NULL,'deleted','2025-11-29 08:07:41','2025-11-29 08:07:42','2025-11-29 08:07:42',1,NULL,NULL,NULL,'5c57433fd3834430904b1908f24f3f2f',1,0,0,NULL,'private',0,NULL,NULL),('159b7691-923b-4bf5-a065-6be0cf4e75ba','tempest-ServerActionsTestOtherB-server-296895970-shelved',1073741824,'deleted','2025-11-29 08:17:33','2025-11-29 08:18:34','2025-11-29 08:18:34',1,'raw','bare',NULL,'1b8899f76f554afc96bb2441424e5a77',1,0,0,NULL,'private',0,NULL,NULL),('19c04997-1e5f-42a9-90ff-a53c93a49ed0','tempest-TestSnapshotPatternsnapshot-1064327949',1073741824,'deleted','2025-11-29 08:44:24','2025-11-29 08:45:35','2025-11-29 08:45:35',1,'raw','bare',NULL,'66ee3b60fb89476383201ba204858d4d',1,0,0,NULL,'private',0,NULL,NULL),('2108a514-c4e3-4d77-9b23-07f5f704a34d','tempest-ListImageFiltersTestJSON-image-90184257',1024,'deleted','2025-11-29 08:03:30','2025-11-29 08:04:46','2025-11-29 08:04:46',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','1a7ab40578b84f6aa0f4d2225a36bf9e',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('22c1bddc-ba6e-468e-8d62-0351bef23ed0','tempest-backup-1-548496762',NULL,'deleted','2025-11-29 08:21:19','2025-11-29 08:21:20','2025-11-29 08:21:20',1,'qcow2','bare',NULL,'6aa17a00c635424f98f28f89b9229ee2',1,0,0,NULL,'private',0,NULL,NULL),('2d9af198-baca-4fb0-8bbb-100141aac9db','tempest-ServerBootFromVolumeStableRescueTest-image-301328268',1073741824,'deleted','2025-11-29 08:29:26','2025-11-29 08:30:33','2025-11-29 08:30:33',1,'raw','bare',NULL,'ae71059d02774857be85797a3be0e4e6',1,0,0,NULL,'private',0,NULL,NULL),('2ec96c0d-69b9-4690-b860-0f20dd8b17cd','multiattach-snapshot',0,'deleted','2025-11-29 08:35:12','2025-11-29 08:35:20','2025-11-29 08:35:20',1,'qcow2','bare','d41d8cd98f00b204e9800998ecf8427e','d4f6db81949d487b853d7567f8a2e6d4',1,0,0,NULL,'private',0,'sha512','cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e'),('36c33ac0-d290-4825-8d63-52b362736e81','tempest-DeleteServersTestJSON-server-1666023155-shelved',1073741824,'deleted','2025-11-29 08:05:18','2025-11-29 08:06:05','2025-11-29 08:06:05',1,'raw','bare',NULL,'90c23935e0214785a9dc5061b91cf29c',1,0,0,NULL,'private',0,NULL,NULL),('37d12ee4-89a4-499b-beea-6b6d4e46474b','tempest-test-snap-1148249820',1073741824,'deleted','2025-11-29 08:05:47','2025-11-29 08:06:18','2025-11-29 08:06:18',1,'raw','bare',NULL,'638fd52fccf14f16b56d0860553063f3',1,0,0,NULL,'private',0,NULL,NULL),('3c08af3e-7b9c-4dba-a2c8-3cba120c3814','tempest-backup-2-1617456108',1073741824,'deleted','2025-11-29 08:12:56','2025-11-29 08:13:18','2025-11-29 08:13:18',1,'raw','bare',NULL,'1b8899f76f554afc96bb2441424e5a77',1,0,0,NULL,'private',0,NULL,NULL),('4873db8c-b414-4e95-acd9-77caabebe722','cirros-0.6.2-x86_64-disk.img',21430272,'active','2025-11-29 07:48:23','2025-11-29 07:48:34',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','313f5427e3624aa189013c3cc05bee02',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('49df0a7c-7efb-4ede-af6c-1d3cec45987f','tempest-ListImageFiltersTestJSON-image-431853295',1024,'deleted','2025-11-29 08:03:26','2025-11-29 08:04:48','2025-11-29 08:04:48',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','1a7ab40578b84f6aa0f4d2225a36bf9e',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('4e132098-a673-4ed7-8cfc-d67f77fc5495','tempest-backup-3-1564847374',1073741824,'deleted','2025-11-29 08:13:05','2025-11-29 08:13:17','2025-11-29 08:13:17',1,'raw','bare',NULL,'1b8899f76f554afc96bb2441424e5a77',1,0,0,NULL,'private',0,NULL,NULL),('67d99282-8a43-4e0e-a784-9938a71f1f74','tempest-image-1496523280',2546,'deleted','2025-11-29 07:59:37','2025-11-29 08:00:01','2025-11-29 08:00:01',1,'qcow2','bare','ae7b011a4aeb43f5ae7967b650400e7c','59ac24037fa74ffea33e0c1806437e4f',0,129,0,NULL,'private',0,'sha512','41f330eec2f06779d88bbbf921273be590a2a314050dba7633a0e9301cef1d71d0bf7b11aae808d20f379277d1f88e01fa0f01cac7d3e79d81f5fa3e33f9511d'),('68cf293e-7e4e-4b94-aea6-5b4d60641413','tempest-ImagesOneServerNegativeTestJSON-image-1107002382',NULL,'deleted','2025-11-29 08:08:14','2025-11-29 08:08:15','2025-11-29 08:08:15',1,NULL,NULL,NULL,'5c57433fd3834430904b1908f24f3f2f',1,0,0,NULL,'private',0,NULL,NULL),('6a630c30-934b-49f9-92fa-38811e802998','tempest-image-660367920',1073741824,'deleted','2025-11-29 08:07:39','2025-11-29 08:07:47','2025-11-29 08:07:47',1,'raw','bare',NULL,'02545fd3735d4977afe5612632ee4832',1,0,0,NULL,'private',0,NULL,NULL),('7462d96e-a79d-4947-a963-039652361944','tempest-ServerStableDeviceRescueTest-image-448068836',1073741824,'deleted','2025-11-29 08:24:58','2025-11-29 08:28:09','2025-11-29 08:28:09',1,'raw','bare',NULL,'a9a83f8d8d7f4d08890407f978c05166',1,0,0,NULL,'private',0,NULL,NULL),('7e8836eb-bacd-485f-b61b-a89bcd8f6e84','tempest-backup-1-1562382096',1073741824,'deleted','2025-11-29 08:12:49','2025-11-29 08:13:14','2025-11-29 08:13:14',1,'raw','bare',NULL,'1b8899f76f554afc96bb2441424e5a77',1,0,0,NULL,'private',0,NULL,NULL),('8a30eb6e-dddc-4108-8576-dcd7c8d5406f','tempest-scenario-img--1804933970',21430272,'deleted','2025-11-29 08:36:31','2025-11-29 08:38:13','2025-11-29 08:38:13',1,'qcow2','bare','c8fc807773e5354afe61636071771906','8d5e30b74e6449dd90ecb667977d1fe9',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('8b027c1d-b864-4b5a-a6b8-86f9eb11eb8a','tempest-image-59377925',1024,'deleted','2025-11-29 08:03:16','2025-11-29 08:03:41','2025-11-29 08:03:41',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','9d6b98d45e324cc7b3097900bad0b511',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('91e66a4f-7b40-4f67-810c-3642968fad68','tempest-scenario-img--334853480',21430272,'deleted','2025-11-29 08:38:13','2025-11-29 08:39:57','2025-11-29 08:39:57',1,'qcow2','bare','c8fc807773e5354afe61636071771906','8d5e30b74e6449dd90ecb667977d1fe9',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('93eccffb-bacd-407f-af6f-64451dee7b21','cirros-0.6.2-x86_64-disk.img_alt',21430272,'active','2025-11-29 07:48:36','2025-11-29 07:48:41',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','313f5427e3624aa189013c3cc05bee02',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('a9d624a0-fd76-47d0-81ab-f89f80fec0c1','tempest-TestStampPatternsnapshot-1409388708',1073741824,'deleted','2025-11-29 08:44:23','2025-11-29 08:45:37','2025-11-29 08:45:37',1,'raw','bare',NULL,'3b3b0484057a4e3db51366d29c6b684d',1,0,0,NULL,'private',0,NULL,NULL),('aa6ac671-fc8d-4598-a390-3f4d0b610d84','tempest-₡-1329984679',1073741824,'deleted','2025-11-29 08:07:48','2025-11-29 08:07:57','2025-11-29 08:07:57',1,'raw','bare',NULL,'02545fd3735d4977afe5612632ee4832',1,0,0,NULL,'private',0,NULL,NULL),('ad73a146-3d66-454f-a206-ab6de9891225','tempest-TestVolumeBootPatternsnapshot-481397479',0,'deleted','2025-11-29 08:48:44','2025-11-29 08:49:50','2025-11-29 08:49:50',1,'qcow2','bare','d41d8cd98f00b204e9800998ecf8427e','b7ffcb23bac14ee49474df9aee5f7dae',1,0,0,NULL,'private',0,'sha512','cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e'),('be6a1bec-5785-4873-ac75-fe1aa2fbc126','tempest-ListImageFiltersTestJSON-image-118137168',1073741824,'deleted','2025-11-29 08:03:49','2025-11-29 08:04:37','2025-11-29 08:04:37',1,'raw','bare',NULL,'1a7ab40578b84f6aa0f4d2225a36bf9e',1,0,0,NULL,'private',0,NULL,NULL),('c28b4cfd-fa14-4a57-95be-5fa2d667ebc5','tempest-ServerActionsTestOtherB-server-671911008-shelved',1073741824,'deleted','2025-11-29 08:17:50','2025-11-29 08:18:29','2025-11-29 08:18:29',1,'raw','bare',NULL,'1b8899f76f554afc96bb2441424e5a77',1,0,0,NULL,'private',0,NULL,NULL),('c373ab38-0e65-4d5c-bf51-8234f0ed5ffd','tempest-AttachVolumeShelveTestJSON-server-716574022-shelved',1073741824,'deleted','2025-11-29 08:38:04','2025-11-29 08:38:35','2025-11-29 08:38:35',1,'raw','bare',NULL,'889608c71d13429fb37793575792ae74',1,0,0,NULL,'private',0,NULL,NULL),('c44b1015-4b83-4a23-8199-4ab6d8120f18','tempest-test-snap-1334861906',1073741824,'deleted','2025-11-29 08:04:17','2025-11-29 08:04:26','2025-11-29 08:04:26',1,'raw','bare',NULL,'638fd52fccf14f16b56d0860553063f3',1,0,0,NULL,'private',0,NULL,NULL),('c5df7ff6-8c6a-4656-a8c2-618a39624a42','tempest-ServerStableDeviceRescueTest-image-1361558626',1073741824,'deleted','2025-11-29 08:23:59','2025-11-29 08:28:20','2025-11-29 08:28:20',1,'raw','bare',NULL,'a9a83f8d8d7f4d08890407f978c05166',1,0,0,NULL,'private',0,NULL,NULL),('c73d83e2-0a3c-4e73-907f-124979a361df','tempest-ServerStableDeviceRescueTest-image-1185747959',1073741824,'deleted','2025-11-29 08:25:41','2025-11-29 08:28:03','2025-11-29 08:28:03',1,'raw','bare',NULL,'a9a83f8d8d7f4d08890407f978c05166',1,0,0,NULL,'private',0,NULL,NULL),('ca49c32b-cb06-40a8-be71-35eeb05e9ca2',NULL,21430272,'deleted','2025-11-29 07:57:33','2025-11-29 07:59:08','2025-11-29 07:59:08',1,'qcow2','bare','c8fc807773e5354afe61636071771906','fefd450a22f6433fbea03a8da1e1492d',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('e2197e65-1840-49d9-98ce-4e37b9f34409','tempest-test-snap-1424761292',NULL,'deleted','2025-11-29 08:06:36','2025-11-29 08:06:38','2025-11-29 08:06:38',1,NULL,NULL,NULL,'638fd52fccf14f16b56d0860553063f3',1,0,0,NULL,'private',0,NULL,NULL),('e21e97a9-475e-4ed4-bd3f-ad8000b59f07','tempest-TestShelveInstance-server-1254459075-shelved',1073741824,'deleted','2025-11-29 08:47:58','2025-11-29 08:48:24','2025-11-29 08:48:24',1,'raw','bare',NULL,'2e636ab14fe94059b82b9cbcf8831d87',1,0,0,NULL,'private',0,NULL,NULL),('ea9de80a-851e-4cb9-ab40-64d7952ffbd1','tempest-TestSnapshotPatternsnapshot-1576903950',1073741824,'deleted','2025-11-29 08:45:20','2025-11-29 08:45:28','2025-11-29 08:45:28',1,'raw','bare',NULL,'66ee3b60fb89476383201ba204858d4d',1,0,0,NULL,'private',0,NULL,NULL),('eb8dd751-ecc7-464b-8f9f-4f4d38e755cf','tempest-AttachVolumeShelveTestJSON-server-1172691465-shelved',1073741824,'deleted','2025-11-29 08:39:38','2025-11-29 08:40:14','2025-11-29 08:40:14',1,'raw','bare',NULL,'889608c71d13429fb37793575792ae74',1,0,0,NULL,'private',0,NULL,NULL),('ecb74341-a505-46e6-a429-f2d9cba0e680','tempest-ListImageFiltersTestJSON-image-700630006',1073741824,'deleted','2025-11-29 08:04:05','2025-11-29 08:04:36','2025-11-29 08:04:36',1,'raw','bare',NULL,'1a7ab40578b84f6aa0f4d2225a36bf9e',1,0,0,NULL,'private',0,NULL,NULL),('f502084d-e717-47c5-8881-072bf335e491','tempest-ServersNegativeTestJSON-server-1484770108-shelved',1073741824,'deleted','2025-11-29 08:35:32','2025-11-29 08:36:15','2025-11-29 08:36:15',1,'raw','bare',NULL,'96e72e7660da497a8b6bf9fdb03fe84c',1,0,0,NULL,'private',0,NULL,NULL),('f5aee037-dd13-47e6-81af-147c317d7457','tempest-ServerStableDeviceRescueTest-image-1250872659',1073741824,'deleted','2025-11-29 08:26:40','2025-11-29 08:27:47','2025-11-29 08:27:47',1,'raw','bare',NULL,'a9a83f8d8d7f4d08890407f978c05166',1,0,0,NULL,'private',0,NULL,NULL),('f6492822-3635-4784-934e-4aff1e94e9cf','tempest-UnshelveToHostMultiNodesTest-server-106050071-shelved',1073741824,'deleted','2025-11-29 08:04:55','2025-11-29 08:05:25','2025-11-29 08:05:25',1,'raw','bare',NULL,'49ee945ea42e47ad9f070078a4d5179b',1,0,0,NULL,'private',0,NULL,NULL),('f84b19f0-6dcc-469f-91bc-16d537cf010a','tempest-ListImageFiltersTestJSON-image-105212877',1073741824,'deleted','2025-11-29 08:04:14','2025-11-29 08:04:34','2025-11-29 08:04:34',1,'raw','bare',NULL,'1a7ab40578b84f6aa0f4d2225a36bf9e',1,0,0,NULL,'private',0,NULL,NULL),('f953a29b-1cff-4723-9bbc-02d6d0bd3151','tempest-UnshelveToHostMultiNodesTest-server-106050071-shelved',1073741824,'deleted','2025-11-29 08:05:28','2025-11-29 08:06:06','2025-11-29 08:06:06',1,'raw','bare',NULL,'49ee945ea42e47ad9f070078a4d5179b',1,0,0,NULL,'private',0,NULL,NULL),('fea86ab8-1607-4850-b354-0a134f3e6647','tempest-test-snap-1813542190',1073741824,'deleted','2025-11-29 08:04:58','2025-11-29 08:05:06','2025-11-29 08:05:06',1,'raw','bare',NULL,'638fd52fccf14f16b56d0860553063f3',1,0,0,NULL,'private',0,NULL,NULL),('ff39bd0f-b544-46e3-a2c3-0aed51f8ff44','tempest-ServerBootFromVolumeStableRescueTest-image-844203478',1073741824,'deleted','2025-11-29 08:27:27','2025-11-29 08:30:42','2025-11-29 08:30:42',1,'raw','bare',NULL,'ae71059d02774857be85797a3be0e4e6',1,0,0,NULL,'private',0,NULL,NULL);
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespace_resource_types`
--

DROP TABLE IF EXISTS `metadef_namespace_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespace_resource_types` (
  `resource_type_id` int(11) NOT NULL,
  `namespace_id` int(11) NOT NULL,
  `properties_target` varchar(80) DEFAULT NULL,
  `prefix` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`resource_type_id`,`namespace_id`),
  KEY `ix_metadef_ns_res_types_namespace_id` (`namespace_id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_2` FOREIGN KEY (`resource_type_id`) REFERENCES `metadef_resource_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespace_resource_types`
--

LOCK TABLES `metadef_namespace_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_namespace_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_namespace_resource_types` (`resource_type_id`, `namespace_id`, `properties_target`, `prefix`, `created_at`, `updated_at`) VALUES (1,1,'image','CIM_PASD_','2025-11-29 06:54:31',NULL),(1,2,'image','CIM_RASD_','2025-11-29 06:54:32',NULL),(1,3,NULL,'CIM_SASD_','2025-11-29 06:54:32',NULL),(1,9,'image','hw_','2025-11-29 06:54:32',NULL),(1,10,'image','hw_','2025-11-29 06:54:32',NULL),(1,14,'image',NULL,'2025-11-29 06:54:33',NULL),(1,19,'image','hw_','2025-11-29 06:54:33',NULL),(1,25,'image','hw_','2025-11-29 06:54:33',NULL),(1,29,'image',NULL,'2025-11-29 06:54:33',NULL),(1,30,'image',NULL,'2025-11-29 06:54:33',NULL),(1,31,'image',NULL,'2025-11-29 06:54:33',NULL),(1,32,'image',NULL,'2025-11-29 06:54:34',NULL),(2,1,NULL,'CIM_PASD_','2025-11-29 06:54:31',NULL),(2,8,NULL,'hw_','2025-11-29 06:54:32',NULL),(2,9,NULL,'hw_','2025-11-29 06:54:32',NULL),(2,10,NULL,'hw_','2025-11-29 06:54:32',NULL),(2,11,NULL,NULL,'2025-11-29 06:54:32',NULL),(2,13,NULL,NULL,'2025-11-29 06:54:32',NULL),(2,14,NULL,NULL,'2025-11-29 06:54:33',NULL),(2,15,NULL,NULL,'2025-11-29 06:54:33',NULL),(2,16,NULL,'hw_','2025-11-29 06:54:33',NULL),(2,19,NULL,'hw_','2025-11-29 06:54:33',NULL),(2,22,NULL,NULL,'2025-11-29 06:54:33',NULL),(2,23,NULL,'hw_','2025-11-29 06:54:33',NULL),(2,24,NULL,'traits:','2025-11-29 06:54:33',NULL),(2,25,NULL,'hw_','2025-11-29 06:54:33',NULL),(2,26,NULL,NULL,'2025-11-29 06:54:33',NULL),(2,28,NULL,NULL,'2025-11-29 06:54:33',NULL),(2,29,NULL,NULL,'2025-11-29 06:54:33',NULL),(2,30,NULL,NULL,'2025-11-29 06:54:33',NULL),(2,31,NULL,NULL,'2025-11-29 06:54:33',NULL),(2,32,NULL,NULL,'2025-11-29 06:54:34',NULL),(2,33,NULL,'cinder_','2025-11-29 06:54:34',NULL),(3,1,NULL,'CIM_PASD_','2025-11-29 06:54:31',NULL),(3,2,NULL,'CIM_RASD_','2025-11-29 06:54:32',NULL),(3,3,NULL,'CIM_SASD_','2025-11-29 06:54:32',NULL),(3,4,NULL,'CIM_VSSD_','2025-11-29 06:54:32',NULL),(3,5,NULL,NULL,'2025-11-29 06:54:32',NULL),(3,6,NULL,NULL,'2025-11-29 06:54:32',NULL),(3,7,NULL,NULL,'2025-11-29 06:54:32',NULL),(3,12,NULL,'aggregate_instance_extra_specs:','2025-11-29 06:54:32',NULL),(4,1,NULL,'CIM_PASD_','2025-11-29 06:54:31',NULL),(4,2,NULL,'CIM_RASD_','2025-11-29 06:54:32',NULL),(4,3,NULL,'CIM_SASD_','2025-11-29 06:54:32',NULL),(4,4,NULL,'CIM_VSSD_','2025-11-29 06:54:32',NULL),(4,8,NULL,'hw:','2025-11-29 06:54:32',NULL),(4,9,NULL,'hw:','2025-11-29 06:54:32',NULL),(4,10,NULL,'hw:','2025-11-29 06:54:32',NULL),(4,12,NULL,'capabilities:','2025-11-29 06:54:32',NULL),(4,16,NULL,'hw:','2025-11-29 06:54:33',NULL),(4,17,NULL,NULL,'2025-11-29 06:54:33',NULL),(4,18,NULL,NULL,'2025-11-29 06:54:33',NULL),(4,19,NULL,'hw:','2025-11-29 06:54:33',NULL),(4,20,NULL,NULL,'2025-11-29 06:54:33',NULL),(4,21,NULL,NULL,'2025-11-29 06:54:33',NULL),(4,23,NULL,'hw:','2025-11-29 06:54:33',NULL),(4,24,NULL,'traits:','2025-11-29 06:54:33',NULL),(4,25,NULL,'hw:','2025-11-29 06:54:33',NULL),(5,1,'scheduler_hints',NULL,'2025-11-29 06:54:32',NULL),(5,30,'metadata',NULL,'2025-11-29 06:54:33',NULL),(5,31,'metadata',NULL,'2025-11-29 06:54:34',NULL),(5,32,'metadata',NULL,'2025-11-29 06:54:34',NULL),(6,30,NULL,NULL,'2025-11-29 06:54:33',NULL);
/*!40000 ALTER TABLE `metadef_namespace_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespaces`
--

DROP TABLE IF EXISTS `metadef_namespaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespaces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace` varchar(80) NOT NULL,
  `display_name` varchar(80) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `visibility` varchar(32) DEFAULT NULL,
  `protected` tinyint(1) DEFAULT NULL,
  `owner` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_namespaces_namespace` (`namespace`),
  KEY `ix_metadef_namespaces_owner` (`owner`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespaces`
--

LOCK TABLES `metadef_namespaces` WRITE;
/*!40000 ALTER TABLE `metadef_namespaces` DISABLE KEYS */;
INSERT INTO `metadef_namespaces` (`id`, `namespace`, `display_name`, `description`, `visibility`, `protected`, `owner`, `created_at`, `updated_at`) VALUES (1,'CIM::ProcessorAllocationSettingData','CIM Processor Allocation Setting','Properties related to the resource allocation settings of a processor (CPU) from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These are properties that identify processor setting data and may be specified to volume, image, host aggregate, flavor and Nova server as scheduler hint. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ProcessorAllocationSettingData.html.','public',1,'admin','2025-11-29 06:54:31',NULL),(2,'CIM::ResourceAllocationSettingData','CIM Resource Allocation Setting Data','Properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim) that represent settings specifically related to an allocated resource that are outside the scope of the CIM class typically used to represent the resource itself. These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ResourceAllocationSettingData.html.','public',1,'admin','2025-11-29 06:54:32',NULL),(3,'CIM::StorageAllocationSettingData','CIM Storage Allocation Setting Data','Properties related to the allocation of virtual storage from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_StorageAllocationSettingData.html.','public',1,'admin','2025-11-29 06:54:32',NULL),(4,'CIM::VirtualSystemSettingData','CIM Virtual System Setting Data','A set of virtualization specific properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim), which define the virtual aspects of a virtual system. These properties may be specified to host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_VirtualSystemSettingData.html.','public',1,'admin','2025-11-29 06:54:32',NULL),(5,'OS::Compute::AggregateDiskFilter','Disk Allocation per Host','Properties related to the Nova scheduler filter AggregateDiskFilter. Filters aggregate hosts based on the available disk space compared to the requested disk space. Hosts in the aggregate with not enough usable disk will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-11-29 06:54:32',NULL),(6,'OS::Compute::AggregateIoOpsFilter','IO Ops per Host','Properties related to the Nova scheduler filter AggregateIoOpsFilter. Filters aggregate hosts based on the number of instances currently changing state. Hosts in the aggregate with too many instances changing state will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-11-29 06:54:32',NULL),(7,'OS::Compute::AggregateNumInstancesFilter','Instances per Host','Properties related to the Nova scheduler filter AggregateNumInstancesFilter. Filters aggregate hosts by the number of running instances on it. Hosts in the aggregate with too many instances will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',0,'admin','2025-11-29 06:54:32',NULL),(8,'OS::Compute::CPUMode','CPU Mode','This provides the preferred CPU Model to be used when booting up a guest VM.','public',NULL,'admin','2025-11-29 06:54:32',NULL),(9,'OS::Compute::CPUPinning','CPU Pinning','This provides the preferred CPU pinning and CPU thread pinning policy to be used when pinning vCPU of the guest to pCPU of the host. See http://docs.openstack.org/admin-guide/compute-numa-cpu-pinning.html','public',1,'admin','2025-11-29 06:54:32',NULL),(10,'OS::Compute::GuestMemoryBacking','Guest Memory Backing','This provides the preferred backing option for guest RAM. Guest\'s memory can be backed by hugepages to limit TLB lookups. See also: https://wiki.openstack.org/wiki/VirtDriverGuestCPUMemoryPlacement','public',1,'admin','2025-11-29 06:54:32',NULL),(11,'OS::Compute::GuestShutdownBehavior','Shutdown Behavior','These properties allow modifying the shutdown behavior for stop, rescue, resize, and shelve operations.','public',1,'admin','2025-11-29 06:54:32',NULL),(12,'OS::Compute::HostCapabilities','Compute Host Capabilities','Hardware capabilities provided by the compute host. This provides the ability to fine tune the hardware specification required when an instance is requested. The ComputeCapabilitiesFilter should be enabled in the Nova scheduler to use these properties. When enabled, this filter checks that the capabilities provided by the compute host satisfy any extra specifications requested. Only hosts that can provide the requested capabilities will be eligible for hosting the instance.','public',1,'admin','2025-11-29 06:54:32',NULL),(13,'OS::Compute::Hypervisor','Hypervisor Selection','OpenStack Compute supports many hypervisors, although most installations use only one hypervisor. For installations with multiple supported hypervisors, you can schedule different hypervisors using the ImagePropertiesFilter. This filters compute nodes that satisfy any architecture, hypervisor type, or virtual machine mode properties specified on the instance\'s image properties.','public',1,'admin','2025-11-29 06:54:32',NULL),(14,'OS::Compute::InstanceData','Instance Config Data','Instances can perform self-configuration based on data made available to the running instance. These properties affect instance configuration.','public',1,'admin','2025-11-29 06:54:32',NULL),(15,'OS::Compute::LibvirtImage','libvirt Driver Options for Images','The libvirt Compute Driver Options for Glance Images.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-11-29 06:54:33',NULL),(16,'OS::Compute::Libvirt','libvirt Driver Options','The libvirt compute driver options.  \n\nThese are properties that affect the libvirt compute driver and may be specified on flavors and images.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-11-29 06:54:33',NULL),(17,'OS::Compute::Quota','Flavor Quota','Compute drivers may enable quotas on CPUs available to a VM, disk tuning, bandwidth I/O, and instance VIF traffic control.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-11-29 06:54:33',NULL),(18,'OS::Compute::RandomNumberGenerator','Random Number Generator','If a random-number generator device has been added to the instance through its image properties, the device can be enabled and configured.','public',1,'admin','2025-11-29 06:54:33',NULL),(19,'OS::Compute::VirtCPUTopology','Virtual CPU Topology','This provides the preferred socket/core/thread counts for the virtual CPU instance exposed to guests. This enables the ability to avoid hitting limitations on vCPU topologies that OS vendors place on their products. See also: https://opendev.org/openstack/nova-specs/src/branch/master/specs/juno/implemented/virt-driver-vcpu-topology.rst','public',1,'admin','2025-11-29 06:54:33',NULL),(20,'OS::Compute::VMwareFlavor','VMware Driver Options for Flavors','VMware Driver Options for Flavors may be used to customize and manage Nova Flavors. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-11-29 06:54:33',NULL),(21,'OS::Compute::VMwareQuotaFlavor','VMware Quota for Flavors','The VMware compute driver allows various compute quotas to be specified on flavors. When specified, the VMWare driver will ensure that the quota is enforced. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. For a list of hypervisors, see: https://wiki.openstack.org/wiki/HypervisorSupportMatrix. For flavor customization, see: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-11-29 06:54:33',NULL),(22,'OS::Compute::VMware','VMware Driver Options','The VMware compute driver options.  \n\nThese are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-11-29 06:54:33',NULL),(23,'OS::Compute::TPM','TPM Options','Configuration options for TPM','public',1,'admin','2025-11-29 06:54:33',NULL),(24,'OS::Compute::VTPM','Emulated Virtual TPM','Configuration options for Emulated Virtual TPM','public',1,'admin','2025-11-29 06:54:33',NULL),(25,'OS::Compute::Watchdog','Watchdog Behavior','Compute drivers may enable watchdog behavior over instances.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-11-29 06:54:33',NULL),(26,'OS::Compute::XenAPI','XenAPI Driver Options','The XenAPI compute driver options.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-11-29 06:54:33',NULL),(27,'OS::Glance::CommonImageProperties','Common Image Properties','When adding an image to Glance, you may specify some common image properties that may prove useful to consumers of your image.',NULL,1,'admin','2025-11-29 06:54:33',NULL),(28,'OS::Glance::Signatures','Image Signature Verification','Image signature verification allows the user to verify that an image has not been modified prior to booting the image.','public',0,'admin','2025-11-29 06:54:33',NULL),(29,'OS::OperatingSystem','Common Operating System Properties','Details of the operating system contained within this image as well as common operating system properties that can be set on a VM instance created from this image.',NULL,1,'admin','2025-11-29 06:54:33',NULL),(30,'OS::Software::DBMS','Database Software','A database is an organized collection of data. The data is typically organized to model aspects of reality in a way that supports processes requiring information. Database management systems are computer software applications that interact with the user, other applications, and the database itself to capture and analyze data. (http://en.wikipedia.org/wiki/Database)','public',1,'admin','2025-11-29 06:54:33',NULL),(31,'OS::Software::Runtimes','Runtime Environment','Software is written in a specific programming language and the language must execute within a runtime environment. The runtime environment provides an abstraction to utilizing a computer\'s processor, memory (RAM), and other system resources.','public',1,'admin','2025-11-29 06:54:33',NULL),(32,'OS::Software::WebServers','Web Servers','A web server is a computer system that processes requests via HTTP, the basic network protocol used to distribute information on the World Wide Web. The most common use of web servers is to host websites, but there are other uses such as gaming, data storage, running enterprise applications, handling email, FTP, or other web uses. (http://en.wikipedia.org/wiki/Web_server)','public',1,'admin','2025-11-29 06:54:34',NULL),(33,'OS::Cinder::Volumetype','Cinder Volume Type','The Cinder volume type configuration option. Volume type assignment provides a mechanism not only to provide scheduling to a specific storage back-end, but also can be used to specify specific information for a back-end storage device to act upon.','public',1,'admin','2025-11-29 06:54:34',NULL);
/*!40000 ALTER TABLE `metadef_namespaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_objects`
--

DROP TABLE IF EXISTS `metadef_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `description` text DEFAULT NULL,
  `required` text DEFAULT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_objects_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_objects_name` (`name`),
  CONSTRAINT `metadef_objects_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_objects`
--

LOCK TABLES `metadef_objects` WRITE;
/*!40000 ALTER TABLE `metadef_objects` DISABLE KEYS */;
INSERT INTO `metadef_objects` (`id`, `namespace_id`, `name`, `description`, `required`, `json_schema`, `created_at`, `updated_at`) VALUES (1,17,'CPU Limits','You can configure the CPU limits with control parameters.',NULL,'{\"quota:cpu_shares\": {\"title\": \"Quota: CPU Shares\", \"description\": \"Specifies the proportional weighted share for the domain. If this element is omitted, the service defaults to the OS provided defaults. There is no unit for the value; it is a relative measure based on the setting of other VMs. For example, a VM configured with value 2048 gets twice as much CPU time as a VM configured with value 1024.\", \"type\": \"integer\"}, \"quota:cpu_period\": {\"title\": \"Quota: CPU Period\", \"description\": \"Specifies the enforcement interval (unit: microseconds) for QEMU and LXC hypervisors. Within a period, each VCPU of the domain is not allowed to consume more than the quota worth of runtime. The value should be in range [1000, 1000000]. A period with value 0 means no value.\", \"type\": \"integer\", \"minimum\": 1000, \"maximum\": 1000000}, \"quota:cpu_quota\": {\"title\": \"Quota: CPU Quota\", \"description\": \"Specifies the maximum allowed bandwidth (unit: microseconds). A domain with a negative-value quota indicates that the domain has infinite bandwidth, which means that it is not bandwidth controlled. The value should be in range [1000, 18446744073709551] or less than 0. A quota with value 0 means no value. You can use this feature to ensure that all vCPUs run at the same speed.\", \"type\": \"integer\"}}','2025-11-29 06:54:33',NULL),(2,17,'Disk QoS','Using disk I/O quotas, you can set maximum disk write to 10 MB per second for a VM user.',NULL,'{\"quota:disk_read_bytes_sec\": {\"title\": \"Quota: Disk read bytes / sec\", \"description\": \"Sets disk I/O quota for disk read bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_read_iops_sec\": {\"title\": \"Quota: Disk read IOPS / sec\", \"description\": \"Sets disk I/O quota for disk read IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_write_bytes_sec\": {\"title\": \"Quota: Disk Write Bytes / sec\", \"description\": \"Sets disk I/O quota for disk write bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_write_iops_sec\": {\"title\": \"Quota: Disk Write IOPS / sec\", \"description\": \"Sets disk I/O quota for disk write IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_total_bytes_sec\": {\"title\": \"Quota: Disk Total Bytes / sec\", \"description\": \"Sets disk I/O quota for total disk bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_total_iops_sec\": {\"title\": \"Quota: Disk Total IOPS / sec\", \"description\": \"Sets disk I/O quota for disk total IOPS / sec.\", \"type\": \"integer\"}}','2025-11-29 06:54:33',NULL),(3,17,'Virtual Interface QoS','Bandwidth QoS tuning for instance virtual interfaces (VIFs) may be specified with these properties. Incoming and outgoing traffic can be shaped independently. If not specified, no quality of service (QoS) is applied on that traffic direction. So, if you want to shape only the network\'s incoming traffic, use inbound only (and vice versa). The OpenStack Networking service abstracts the physical implementation of the network, allowing plugins to configure and manage physical resources. Virtual Interfaces (VIF) in the logical model are analogous to physical network interface cards (NICs). VIFs are typically owned a managed by an external service; for instance when OpenStack Networking is used for building OpenStack networks, VIFs would be created, owned, and managed in Nova. VIFs are connected to OpenStack Networking networks via ports. A port is analogous to a port on a network switch, and it has an administrative state. When a VIF is attached to a port the OpenStack Networking API creates an attachment object, which specifies the fact that a VIF with a given identifier is plugged into the port.',NULL,'{\"quota:vif_inbound_average\": {\"title\": \"Quota: VIF Inbound Average\", \"description\": \"Network Virtual Interface (VIF) inbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_inbound_burst\": {\"title\": \"Quota: VIF Inbound Burst\", \"description\": \"Network Virtual Interface (VIF) inbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_inbound_peak\": {\"title\": \"Quota: VIF Inbound Peak\", \"description\": \"Network Virtual Interface (VIF) inbound peak in kilobytes per second. Specifies maximum rate at which an interface can receive data.\", \"type\": \"integer\"}, \"quota:vif_outbound_average\": {\"title\": \"Quota: VIF Outbound Average\", \"description\": \"Network Virtual Interface (VIF) outbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_outbound_burst\": {\"title\": \"Quota: VIF Outbound Burst\", \"description\": \"Network Virtual Interface (VIF) outbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_outbound_peak\": {\"title\": \"Quota: VIF Outbound Peak\", \"description\": \"Network Virtual Interface (VIF) outbound peak in kilobytes per second. Specifies maximum rate at which an interface can send data.\", \"type\": \"integer\"}}','2025-11-29 06:54:33',NULL),(4,30,'MySQL','MySQL is an object-relational database management system (ORDBMS). The MySQL development project has made its source code available under the terms of the GNU General Public License, as well as under a variety of proprietary agreements. MySQL was owned and sponsored by a single for-profit firm, the Swedish company MySQL AB, now owned by Oracle Corporation. MySQL is a popular choice of database for use in web applications, and is a central component of the widely used LAMP open source web application software stack (and other \'AMP\' stacks). (http://en.wikipedia.org/wiki/MySQL)',NULL,'{\"sw_database_mysql_version\": {\"title\": \"Version\", \"description\": \"The specific version of MySQL.\", \"type\": \"string\"}, \"sw_database_mysql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"The configured TCP/IP port which MySQL listens for incoming connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 3606}, \"sw_database_mysql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"root\"}}','2025-11-29 06:54:33',NULL),(5,30,'PostgreSQL','PostgreSQL, often simply \'Postgres\', is an object-relational database management system (ORDBMS) with an emphasis on extensibility and standards-compliance. PostgreSQL is cross-platform and runs on many operating systems. (http://en.wikipedia.org/wiki/PostgreSQL)',NULL,'{\"sw_database_postgresql_version\": {\"title\": \"Version\", \"description\": \"The specific version of PostgreSQL.\", \"type\": \"string\"}, \"sw_database_postgresql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which PostgreSQL is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_postgresql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"postgres\"}}','2025-11-29 06:54:33',NULL),(6,30,'SQL Server','Microsoft SQL Server is a relational database management system developed by Microsoft. There are at least a dozen different editions of Microsoft SQL Server aimed at different audiences and for workloads ranging from small single-machine applications to large Internet-facing applications with many concurrent users. Its primary query languages are T-SQL and ANSI SQL. (http://en.wikipedia.org/wiki/Microsoft_SQL_Server)',NULL,'{\"sw_database_sqlserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Microsoft SQL Server.\", \"type\": \"string\"}, \"sw_database_sqlserver_edition\": {\"title\": \"Edition\", \"description\": \"SQL Server is available in multiple editions, with different feature sets and targeting different users.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Datacenter\", \"Enterprise\", \"Standard\", \"Web\", \"Business Intelligence\", \"Workgroup\", \"Express\", \"Compact (SQL CE)\", \"Developer\", \"Embedded (SSEE)\", \"Express\", \"Fast Track\", \"LocalDB\", \"Parallel Data Warehouse (PDW)\", \"Business Intelligence\", \"Datawarehouse Appliance Edition\"]}, \"sw_database_sqlserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which SQL Server is to listen for connections from client applications. The default SQL Server port is 1433, and client ports are assigned a random value between 1024 and 5000.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1433}, \"sw_database_postsqlserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"sa\"}}','2025-11-29 06:54:33',NULL),(7,30,'Oracle','Oracle Database (commonly referred to as Oracle RDBMS or simply as Oracle) is an object-relational database management system produced and marketed by Oracle Corporation. (http://en.wikipedia.org/wiki/Oracle_Database)',NULL,'{\"sw_database_oracle_version\": {\"title\": \"Version\", \"description\": \"The specific version of Oracle.\", \"type\": \"string\"}, \"sw_database_oracle_edition\": {\"title\": \"Edition\", \"description\": \"Over and above the different versions of the Oracle database management software developed over time, Oracle Corporation subdivides its product into varying editions.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Enterprise\", \"Standard\", \"Standard Edition One\", \"Express (XE)\", \"Workgroup\", \"Lite\"]}, \"sw_database_oracle_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Oracle is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1521}}','2025-11-29 06:54:33',NULL),(8,30,'DB2','IBM DB2 is a family of database server products developed by IBM. These products all support the relational model, but in recent years some products have been extended to support object-relational features and non-relational structures, in particular XML. (http://en.wikipedia.org/wiki/IBM_DB2)',NULL,'{\"sw_database_db2_version\": {\"title\": \"Version\", \"description\": \"The specific version of DB2.\", \"type\": \"string\"}, \"sw_database_db2_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which DB2 is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_db2_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-11-29 06:54:33',NULL),(9,30,'MongoDB','MongoDB is a cross-platform document-oriented database. Classified as a NoSQL database, MongoDB uses JSON-like documents with dynamic schemas (MongoDB calls the format BSON), making the integration of data in certain types of applications easier and faster. Released under a combination of the GNU Affero General Public License and the Apache License, MongoDB is free and open-source software. (http://en.wikipedia.org/wiki/MongoDB)',NULL,'{\"sw_database_mongodb_version\": {\"title\": \"Version\", \"description\": \"The specific version of MongoDB.\", \"type\": \"string\"}, \"sw_database_mongodb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which MongoDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 27017}, \"sw_database_mongodb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-11-29 06:54:33',NULL),(10,30,'Couchbase Server','Couchbase Server, originally known as Membase, is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications. These applications must serve many concurrent users by creating, storing, retrieving, aggregating, manipulating and presenting data. In support of these kinds of application needs, Couchbase is designed to provide easy-to-scale key-value or document access with low latency and high sustained throughput. (http://en.wikipedia.org/wiki/Couchbase_Server)',NULL,'{\"sw_database_couchbaseserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Couchbase Server.\", \"type\": \"string\"}, \"sw_database_couchbaseserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Couchbase is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 11211}, \"sw_database_couchbaseserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-11-29 06:54:33',NULL),(11,30,'Redis','Redis is a data structure server (NoSQL). It is open-source, networked, in-memory, and stores keys with optional durability. The development of Redis has been sponsored by Pivotal Software since May 2013; before that, it was sponsored by VMware. The name Redis means REmote DIctionary Server. (http://en.wikipedia.org/wiki/Redis)',NULL,'{\"sw_database_redis_version\": {\"title\": \"Version\", \"description\": \"The specific version of Redis.\", \"type\": \"string\"}, \"sw_database_redis_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Redis is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 6379}, \"sw_database_redis_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-11-29 06:54:33',NULL),(12,30,'CouchDB','Apache CouchDB, commonly referred to as CouchDB, is an open source NoSQL database. It is a NoSQL database that uses JSON to store data, JavaScript as its query language using MapReduce, and HTTP for an API. One of its distinguishing features is multi-master replication. CouchDB was first released in 2005 and later became an Apache project in 2008. (http://en.wikipedia.org/wiki/CouchDB)',NULL,'{\"sw_database_couchdb_version\": {\"title\": \"Version\", \"description\": \"The specific version of CouchDB.\", \"type\": \"string\"}, \"sw_database_couchdb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which CouchDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5984}, \"sw_database_couchdb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-11-29 06:54:33',NULL),(13,30,'Apache Cassandra','Apache Cassandra is an open source distributed NoSQL database management system designed to handle large amounts of data across many commodity servers, providing high availability with no single point of failure. (http://en.wikipedia.org/wiki/Apache_Cassandra)',NULL,'{\"sw_database_cassandra_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache Cassandra.\", \"type\": \"string\"}, \"sw_database_cassandra_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Cassandra is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 9160}, \"sw_database_cassandra_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"cassandra\"}}','2025-11-29 06:54:33',NULL),(14,30,'HBase','HBase is an open source, non-relational (NoSQL), distributed database modeled after Google\'s BigTable and written in Java. It is developed as part of Apache Software Foundation\'s Apache Hadoop project and runs on top of HDFS (Hadoop Distributed Filesystem), providing BigTable-like capabilities for Hadoop. (http://en.wikipedia.org/wiki/Apache_HBase)',NULL,'{\"sw_database_hbase_version\": {\"title\": \"Version\", \"description\": \"The specific version of HBase.\", \"type\": \"string\"}}','2025-11-29 06:54:33',NULL),(15,30,'Hazlecast','In computing, Hazelcast is an in-memory open source software data grid based on Java. By having multiple nodes form a cluster, data is evenly distributed among the nodes. This allows for horizontal scaling both in terms of available storage space and processing power. Backups are also distributed in a similar fashion to other nodes, based on configuration, thereby protecting against single node failure. (http://en.wikipedia.org/wiki/Hazelcast)',NULL,'{\"sw_database_hazlecast_version\": {\"title\": \"Version\", \"description\": \"The specific version of Hazlecast.\", \"type\": \"string\"}, \"sw_database_hazlecast_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Hazlecast is to listen for connections between members.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5701}}','2025-11-29 06:54:33',NULL),(16,31,'PHP','PHP is a server-side scripting language designed for web development but also used as a general-purpose programming language. PHP code can be simply mixed with HTML code, or it can be used in combination with various templating engines and web frameworks. PHP code is usually processed by a PHP interpreter, which is usually implemented as a web server\'s native module or a Common Gateway Interface (CGI) executable. After the PHP code is interpreted and executed, the web server sends resulting output to its client, usually in form of a part of the generated web page – for example, PHP code can generate a web page\'s HTML code, an image, or some other data. PHP has also evolved to include a command-line interface (CLI) capability and can be used in standalone graphical applications. (http://en.wikipedia.org/wiki/PHP)',NULL,'{\"sw_runtime_php_version\": {\"title\": \"Version\", \"description\": \"The specific version of PHP.\", \"type\": \"string\"}}','2025-11-29 06:54:34',NULL),(17,31,'Python','Python is a widely used general-purpose, high-level programming language. Its design philosophy emphasizes code readability, and its syntax allows programmers to express concepts in fewer lines of code than would be possible in languages such as C++ or Java. The language provides constructs intended to enable clear programs on both a small and large scale. Python supports multiple programming paradigms, including object-oriented, imperative and functional programming or procedural styles. It features a dynamic type system and automatic memory management and has a large and comprehensive standard library. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_python_version\": {\"title\": \"Version\", \"description\": \"The specific version of python.\", \"type\": \"string\"}}','2025-11-29 06:54:34',NULL),(18,31,'Java','Java is a functional computer programming language that is concurrent, class-based, object-oriented, and specifically designed to have as few implementation dependencies as possible. It is intended to let application developers write once, run anywhere (WORA), meaning that code that runs on one platform does not need to be recompiled to run on another. Java applications are typically compiled to bytecode that can run on any Java virtual machine (JVM) regardless of computer architecture. (http://en.wikipedia.org/wiki/Java_(programming_language))',NULL,'{\"sw_runtime_java_version\": {\"title\": \"Version\", \"description\": \"The specific version of Java.\", \"type\": \"string\"}}','2025-11-29 06:54:34',NULL),(19,31,'Ruby','Ruby is a dynamic, reflective, object-oriented, general-purpose programming language. It was designed and developed in the mid-1990s by Yukihiro Matsumoto in Japan. According to its authors, Ruby was influenced by Perl, Smalltalk, Eiffel, Ada, and Lisp. It supports multiple programming paradigms, including functional, object-oriented, and imperative. It also has a dynamic type system and automatic memory management. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_ruby_version\": {\"title\": \"Version\", \"description\": \"The specific version of Ruby.\", \"type\": \"string\"}}','2025-11-29 06:54:34',NULL),(20,31,'Perl','Perl is a family of high-level, general-purpose, interpreted, dynamic programming languages. The languages in this family include Perl 5 and Perl 6. Though Perl is not officially an acronym, there are various backronyms in use, the most well-known being Practical Extraction and Reporting Language (http://en.wikipedia.org/wiki/Perl)',NULL,'{\"sw_runtime_perl_version\": {\"title\": \"Version\", \"description\": \"The specific version of Perl.\", \"type\": \"string\"}}','2025-11-29 06:54:34',NULL),(21,32,'Apache HTTP Server','The Apache HTTP Server, colloquially called Apache, is a Web server application notable for playing a key role in the initial growth of the World Wide Web. Apache is developed and maintained by an open community of developers under the auspices of the Apache Software Foundation. Most commonly used on a Unix-like system, the software is available for a wide variety of operating systems, including Unix, FreeBSD, Linux, Solaris, Novell NetWare, OS X, Microsoft Windows, OS/2, TPF, OpenVMS and eComStation. Released under the Apache License, Apache is open-source software. (http://en.wikipedia.org/wiki/Apache_HTTP_Server)',NULL,'{\"sw_webserver_apache_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache.\", \"type\": \"string\"}, \"sw_webserver_apache_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_apache_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-11-29 06:54:34',NULL),(22,32,'Nginx','Nginx (pronounced \'engine-x\') is an open source reverse proxy server for HTTP, HTTPS, SMTP, POP3, and IMAP protocols, as well as a load balancer, HTTP cache, and a web server (origin server). The nginx project started with a strong focus on high concurrency, high performance and low memory usage. It is licensed under the 2-clause BSD-like license and it runs on Linux, BSD variants, Mac OS X, Solaris, AIX, HP-UX, as well as on other *nix flavors. It also has a proof of concept port for Microsoft Windows. (http://en.wikipedia.org/wiki/Nginx)',NULL,'{\"sw_webserver_nginx_version\": {\"title\": \"Version\", \"description\": \"The specific version of Nginx.\", \"type\": \"string\"}, \"sw_webserver_nginx_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_nginx_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-11-29 06:54:34',NULL),(23,32,'IIS','Internet Information Services (IIS, formerly Internet Information Server) is an extensible web server created by Microsoft. IIS supports HTTP, HTTPS, FTP, FTPS, SMTP and NNTP. IIS is not turned on by default when Windows is installed. The IIS Manager is accessed through the Microsoft Management Console or Administrative Tools in the Control Panel. (http://en.wikipedia.org/wiki/Internet_Information_Services)',NULL,'{\"sw_webserver_iis_version\": {\"title\": \"Version\", \"description\": \"The specific version of IIS.\", \"type\": \"string\"}, \"sw_webserver_iis_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_iis_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-11-29 06:54:34',NULL);
/*!40000 ALTER TABLE `metadef_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_properties`
--

DROP TABLE IF EXISTS `metadef_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_properties_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_properties_name` (`name`),
  CONSTRAINT `metadef_properties_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_properties`
--

LOCK TABLES `metadef_properties` WRITE;
/*!40000 ALTER TABLE `metadef_properties` DISABLE KEYS */;
INSERT INTO `metadef_properties` (`id`, `namespace_id`, `name`, `json_schema`, `created_at`, `updated_at`) VALUES (1,1,'InstructionSet','{\"title\": \"Instruction Set\", \"description\": \"Identifies the instruction set of the processor within a processor architecture.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86:i386\", \"x86:i486\", \"x86:i586\", \"x86:i686\", \"x86:64\", \"IA-64:IA-64\", \"AS/400:TIMI\", \"Power:Power_2.03\", \"Power:Power_2.04\", \"Power:Power_2.05\", \"Power:Power_2.06\", \"S/390:ESA/390\", \"S/390:z/Architecture\", \"S/390:z/Architecture_2\", \"PA-RISC:PA-RISC_1.0\", \"PA-RISC:PA-RISC_2.0\", \"ARM:A32\", \"ARM:A64\", \"MIPS:MIPS_I\", \"MIPS:MIPS_II\", \"MIPS:MIPS_III\", \"MIPS:MIPS_IV\", \"MIPS:MIPS_V\", \"MIPS:MIPS32\", \"MIPS64:MIPS64\", \"Alpha:Alpha\", \"SPARC:SPARC_V7\", \"SPARC:SPARC_V8\", \"SPARC:SPARC_V9\", \"SPARC:SPARC_JPS1\", \"SPARC:UltraSPARC2005\", \"SPARC:UltraSPARC2007\", \"68k:68000\", \"68k:68010\", \"68k:68020\", \"68k:68030\", \"68k:68040\", \"68k:68060\"]}','2025-11-29 06:54:32',NULL),(2,1,'ProcessorArchitecture','{\"title\": \"Processor Architecture\", \"description\": \"Identifies the processor architecture of the processor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"IA-64\", \"AS/400\", \"Power\", \"S/390\", \"PA-RISC\", \"ARM\", \"MIPS\", \"Alpha\", \"SPARC\", \"68k\"]}','2025-11-29 06:54:32',NULL),(3,1,'InstructionSetExtensionName','{\"title\": \"Instruction Set Extension\", \"description\": \"Identifies the instruction set extensions of the processor within a processor architecture.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"x86:3DNow\", \"x86:3DNowExt\", \"x86:ABM\", \"x86:AES\", \"x86:AVX\", \"x86:AVX2\", \"x86:BMI\", \"x86:CX16\", \"x86:F16C\", \"x86:FSGSBASE\", \"x86:LWP\", \"x86:MMX\", \"x86:PCLMUL\", \"x86:RDRND\", \"x86:SSE2\", \"x86:SSE3\", \"x86:SSSE3\", \"x86:SSE4A\", \"x86:SSE41\", \"x86:SSE42\", \"x86:FMA3\", \"x86:FMA4\", \"x86:XOP\", \"x86:TBM\", \"x86:VT-d\", \"x86:VT-x\", \"x86:EPT\", \"x86:SVM\", \"PA-RISC:MAX\", \"PA-RISC:MAX2\", \"ARM:DSP\", \"ARM:Jazelle-DBX\", \"ARM:Thumb\", \"ARM:Thumb-2\", \"ARM:ThumbEE)\", \"ARM:VFP\", \"ARM:NEON\", \"ARM:TrustZone\", \"MIPS:MDMX\", \"MIPS:MIPS-3D\", \"Alpha:BWX\", \"Alpha:FIX\", \"Alpha:CIX\", \"Alpha:MVI\"]}}','2025-11-29 06:54:32',NULL),(4,2,'Address','{\"title\": \"Address\", \"description\": \"The address of the resource.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(5,2,'AddressOnParent','{\"title\": \"Address On Parent\", \"description\": \"Describes the address of this resource in the context of the Parent.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(6,2,'AllocationUnits','{\"title\": \"Allocation Units\", \"description\": \"This property specifies the units of allocation used by the Reservation and Limit properties.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(7,2,'AutomaticAllocation','{\"title\": \"Automatic Allocation\", \"description\": \"This property specifies if the resource will be automatically allocated.\", \"type\": \"boolean\"}','2025-11-29 06:54:32',NULL),(8,2,'AutomaticDeallocation','{\"title\": \"Automatic Deallocation\", \"description\": \"This property specifies if the resource will be automatically de-allocated.\", \"type\": \"boolean\"}','2025-11-29 06:54:32',NULL),(9,2,'ConsumerVisibility','{\"title\": \"Consumer Visibility\", \"description\": \"Describes the consumers visibility to the allocated resource.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Passed-Through\", \"Virtualized\", \"Not represented\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-11-29 06:54:32',NULL),(10,2,'Limit','{\"title\": \"Limit\", \"description\": \"This property specifies the upper bound, or maximum amount of resource that will be granted for this allocation.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(11,2,'MappingBehavior','{\"title\": \"Mapping Behavior\", \"description\": \"Specifies how this resource maps to underlying resources. If the HostResource array contains any entries, this property reflects how the resource maps to those specific resources.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Not Supported\", \"Dedicated\", \"Soft Affinity\", \"Hard Affinity\", \"DMTF Reserved\", \"Vendor Reserved\"]}','2025-11-29 06:54:32',NULL),(12,2,'OtherResourceType','{\"title\": \"Other Resource Type\", \"description\": \"A string that describes the resource type when a well defined value is not available and ResourceType has the value \'Other\'.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(13,2,'Parent','{\"title\": \"Parent\", \"description\": \"The Parent of the resource.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(14,2,'PoolID','{\"title\": \"Pool ID\", \"description\": \"This property specifies which ResourcePool the resource is currently allocated from, or which ResourcePool the resource will be allocated from when the allocation occurs.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(15,2,'Reservation','{\"title\": \"Reservation\", \"description\": \"This property specifies the amount of resource guaranteed to be available for this allocation.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(16,2,'ResourceSubType','{\"title\": \"Resource Sub Type\", \"description\": \"A string describing an implementation specific sub-type for this resource.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(17,2,'ResourceType','{\"title\": \"Resource Type\", \"description\": \"The type of resource this allocation setting represents.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Other\", \"Computer System\", \"Processor\", \"Memory\", \"IDE Controller\", \"Parallel SCSI HBA\", \"FC HBA\", \"iSCSI HBA\", \"IB HCA\", \"Ethernet Adapter\", \"Other Network Adapter\", \"I/O Slot\", \"I/O Device\", \"Floppy Drive\", \"CD Drive\", \"DVD drive\", \"Disk Drive\", \"Tape Drive\", \"Storage Extent\", \"Other storage device\", \"Serial port\", \"Parallel port\", \"USB Controller\", \"Graphics controller\", \"IEEE 1394 Controller\", \"Partitionable Unit\", \"Base Partitionable Unit\", \"Power\", \"Cooling Capacity\", \"Ethernet Switch Port\", \"Logical Disk\", \"Storage Volume\", \"Ethernet Connection\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-11-29 06:54:32',NULL),(18,2,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"This property specifies the quantity of resources presented to the consumer.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(19,2,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(20,2,'Weight','{\"title\": \"Weight\", \"description\": \"This property specifies a relative priority for this allocation in relation to other allocations from the same ResourcePool.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(21,2,'Connection','{\"title\": \"Connection\", \"description\": \"The thing to which this resource is connected.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(22,2,'HostResource','{\"title\": \"Host Resource\", \"description\": \"This property exposes specific assignment of resources.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(23,3,'Access','{\"title\": \"Access\", \"description\": \"Access describes whether the allocated storage extent is 1 (readable), 2 (writeable), or 3 (both).\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Readable\", \"Writeable\", \"Read/Write Supported\", \"DMTF Reserved\"]}','2025-11-29 06:54:32',NULL),(24,3,'HostExtentName','{\"title\": \"Host Extent Name\", \"description\": \"A unique identifier for the host extent.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(25,3,'HostExtentNameFormat','{\"title\": \"Host Extent Name Format\", \"description\": \"The HostExtentNameFormat property identifies the format that is used for the value of the HostExtentName property.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"SNVM\", \"NAA\", \"EUI64\", \"T10VID\", \"OS Device Name\", \"DMTF Reserved\"]}','2025-11-29 06:54:32',NULL),(26,3,'HostExtentNameNamespace','{\"title\": \"Host Extent Name Namespace\", \"description\": \"If the host extent is a SCSI volume, then the preferred source for SCSI volume names is SCSI VPD Page 83 responses.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"VPD83Type3\", \"VPD83Type2\", \"VPD83Type1\", \"VPD80\", \"NodeWWN\", \"SNVM\", \"OS Device Namespace\", \"DMTF Reserved\"]}','2025-11-29 06:54:32',NULL),(27,3,'HostExtentStartingAddress','{\"title\": \"Host Extent Starting Address\", \"description\": \"The HostExtentStartingAddress property identifies the starting address on the host storage extent identified by the value of the HostExtentName property that is used for the allocation of the virtual storage extent.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(28,3,'HostResourceBlockSize','{\"title\": \"Host Resource Block Size\", \"description\": \"Size in bytes of the blocks that are allocated at the host as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(29,3,'Limit','{\"title\": \"Limit\", \"description\": \"The maximum amount of blocks that will be granted for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(30,3,'OtherHostExtentNameFormat','{\"title\": \"Other Host Extent Name Format\", \"description\": \"A string describing the format of the HostExtentName property if the value of the HostExtentNameFormat property is 1 (Other).\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(31,3,'OtherHostExtentNameNamespace','{\"title\": \"Other Host Extent Name Namespace\", \"description\": \"A string describing the namespace of the HostExtentName property if the value of the HostExtentNameNamespace matches 1 (Other).\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(32,3,'Reservation','{\"title\": \"Reservation\", \"description\": \"The amount of blocks that are guaranteed to be available for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(33,3,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"Number of blocks that are presented to the consumer.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(34,3,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(35,3,'VirtualResourceBlockSize','{\"title\": \"Virtual Resource Block Size\", \"description\": \"Size in bytes of the blocks that are presented to the consumer as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(36,4,'AutomaticRecoveryAction','{\"title\": \"Automatic Recovery Action\", \"description\": \"Action to take for the virtual system when the software executed by the virtual system fails.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart\", \"Revert to snapshot\", \"DMTF Reserved\"]}','2025-11-29 06:54:32',NULL),(37,4,'AutomaticShutdownAction','{\"title\": \"Automatic Shutdown Action\", \"description\": \"Action to take for the virtual system when the host is shut down.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Turn Off\", \"Save state\", \"Shutdown\", \"DMTF Reserved\"]}','2025-11-29 06:54:32',NULL),(38,4,'AutomaticStartupAction','{\"title\": \"Automatic Startup Action\", \"description\": \"Action to take for the virtual system when the host is started.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart if previously active\", \"Always startup\", \"DMTF Reserved\"]}','2025-11-29 06:54:32',NULL),(39,4,'AutomaticStartupActionDelay','{\"title\": \"Automatic Startup Action Delay\", \"description\": \"Delay applicable to startup action.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(40,4,'AutomaticStartupActionSequenceNumber','{\"title\": \"Automatic Startup Action Sequence Number\", \"description\": \"Number indicating the relative sequence of virtual system activation when the host system is started.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(41,4,'ConfigurationDataRoot','{\"title\": \"Configuration Data Root\", \"description\": \"Filepath of a directory where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(42,4,'ConfigurationFile','{\"title\": \"Configuration File\", \"description\": \"Filepath of a file where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(43,4,'ConfigurationID','{\"title\": \"Configuration ID\", \"description\": \"Unique id of the virtual system configuration.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(44,4,'CreationTime','{\"title\": \"Creation Time\", \"description\": \"Time when the virtual system configuration was created.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(45,4,'LogDataRoot','{\"title\": \"Log Data Root\", \"description\": \"Filepath of a directory where log information about the virtual system is stored.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(46,4,'RecoveryFile','{\"title\": \"Recovery File\", \"description\": \"Filepath of a file where recovery relateded information of the virtual system is stored.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(47,4,'SnapshotDataRoot','{\"title\": \"Snapshot Data Root\", \"description\": \"Filepath of a directory where information about virtual system snapshots is stored.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(48,4,'SuspendDataRoot','{\"title\": \"Suspend Data Root\", \"description\": \"Filepath of a directory where suspend related information about the virtual system is stored.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(49,4,'SwapFileDataRoot','{\"title\": \"Swap File Data Root\", \"description\": \"Filepath of a directory where swapfiles of the virtual system are stored.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(50,4,'VirtualSystemIdentifier','{\"title\": \"Virtual System Identifier\", \"description\": \"VirtualSystemIdentifier shall reflect a unique name for the system as it is used within the virtualization platform.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(51,4,'VirtualSystemType','{\"title\": \"Virtual System Type\", \"description\": \"VirtualSystemType shall reflect a particular type of virtual system.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(52,4,'Notes','{\"title\": \"Notes\", \"description\": \"End-user supplied notes that are related to the virtual system.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(53,5,'disk_allocation_ratio','{\"title\": \"Disk Subscription Ratio\", \"description\": \"Allows the host to be under and over subscribed for the amount of disk space requested for an instance. A ratio greater than 1.0 allows for over subscription (hosts may have less usable disk space than requested). A ratio less than 1.0 allows for under subscription.\", \"type\": \"number\", \"readonly\": false}','2025-11-29 06:54:32',NULL),(54,6,'max_io_ops_per_host','{\"title\": \"Maximum IO Operations per Host\", \"description\": \"Prevents hosts in the aggregate that have this many or more instances currently in build, resize, snapshot, migrate, rescue or unshelve to be scheduled for new instances.\", \"type\": \"integer\", \"readonly\": false, \"default\": 8, \"minimum\": 1}','2025-11-29 06:54:32',NULL),(55,7,'max_instances_per_host','{\"title\": \"Max Instances Per Host\", \"description\": \"Maximum number of instances allowed to run on a host in the aggregate.\", \"type\": \"integer\", \"readonly\": false, \"minimum\": 0}','2025-11-29 06:54:32',NULL),(56,8,'cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"Type of CPU Mode.\", \"type\": \"string\", \"enum\": [\"none\", \"host-model\", \"host-passthrough\", \"custom\"]}','2025-11-29 06:54:32',NULL),(57,9,'cpu_policy','{\"title\": \"CPU Pinning policy\", \"description\": \"Type of CPU pinning policy.\", \"type\": \"string\", \"enum\": [\"shared\", \"dedicated\"]}','2025-11-29 06:54:32',NULL),(58,9,'cpu_thread_policy','{\"title\": \"CPU Thread Pinning Policy.\", \"description\": \"Type of CPU thread pinning policy.\", \"type\": \"string\", \"enum\": [\"isolate\", \"prefer\", \"require\"]}','2025-11-29 06:54:32',NULL),(59,10,'mem_page_size','{\"title\": \"Size of memory page\", \"description\": \"Page size to be used for Guest memory backing. Value can be specified as <number><unit> (i.e.: 2MB, 1GB) or \'any\', \'small\', \'large\'. If this property is set in Image metadata then only \'any\' and \'large\' values are accepted in Flavor metadata by Nova API.\", \"type\": \"string\"}','2025-11-29 06:54:32',NULL),(60,11,'os_shutdown_timeout','{\"title\": \"Shutdown timeout\", \"description\": \"By default, guests will be given 60 seconds to perform a graceful shutdown. After that, the VM is powered off.  This property allows overriding the amount of time (unit: seconds) to allow a guest OS to cleanly shut down before power off. A value of 0 (zero) means the guest will be powered off immediately with no opportunity for guest OS clean-up.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-29 06:54:32',NULL),(61,12,'cpu_info:vendor','{\"title\": \"Vendor\", \"description\": \"Specifies the CPU manufacturer.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Intel\", \"AMD\"]}','2025-11-29 06:54:32',NULL),(62,12,'cpu_info:model','{\"title\": \"Model\", \"description\": \"Specifies the CPU model. Use this property to ensure that your vm runs on a specific cpu model.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Conroe\", \"Core2Duo\", \"Penryn\", \"Nehalem\", \"Westmere\", \"SandyBridge\", \"IvyBridge\", \"Haswell\", \"Broadwell\", \"Delhi\", \"Seoul\", \"Abu Dhabi\", \"Interlagos\", \"Kabini\", \"Valencia\", \"Zurich\", \"Budapest\", \"Barcelona\", \"Suzuka\", \"Shanghai\", \"Istanbul\", \"Lisbon\", \"Magny-Cours\", \"Valencia\", \"Cortex-A57\", \"Cortex-A53\", \"Cortex-A12\", \"Cortex-A17\", \"Cortex-A15\", \"Coretx-A7\", \"X-Gene\"]}','2025-11-29 06:54:32',NULL),(63,12,'cpu_info:arch','{\"title\": \"Architecture\", \"description\": \"Specifies the CPU architecture. Use this property to specify the architecture supported by the hypervisor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"x86_64\", \"i686\", \"ia64\", \"ARMv8-A\", \"ARMv7-A\"]}','2025-11-29 06:54:32',NULL),(64,12,'cpu_info:topology:cores','{\"title\": \"cores\", \"description\": \"Number of cores.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-11-29 06:54:32',NULL),(65,12,'cpu_info:topology:threads','{\"title\": \"threads\", \"description\": \"Number of threads.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-11-29 06:54:32',NULL),(66,12,'cpu_info:topology:sockets','{\"title\": \"sockets\", \"description\": \"Number of sockets.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-11-29 06:54:32',NULL),(67,12,'cpu_info:features','{\"title\": \"Features\", \"description\": \"Specifies CPU flags/features. Using this property you can specify the required set of instructions supported by a vm.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"fpu\", \"vme\", \"de\", \"pse\", \"tsc\", \"msr\", \"pae\", \"mce\", \"cx8\", \"apic\", \"sep\", \"mtrr\", \"pge\", \"mca\", \"cmov\", \"pat\", \"pse36\", \"pn\", \"clflush\", \"dts\", \"acpi\", \"mmx\", \"fxsr\", \"sse\", \"sse2\", \"ss\", \"ht\", \"tm\", \"ia64\", \"pbe\", \"syscall\", \"mp\", \"nx\", \"mmxext\", \"fxsr_opt\", \"pdpe1gb\", \"rdtscp\", \"lm\", \"3dnowext\", \"3dnow\", \"arch_perfmon\", \"pebs\", \"bts\", \"rep_good\", \"nopl\", \"xtopology\", \"tsc_reliable\", \"nonstop_tsc\", \"extd_apicid\", \"amd_dcm\", \"aperfmperf\", \"eagerfpu\", \"nonstop_tsc_s3\", \"pni\", \"pclmulqdq\", \"dtes64\", \"monitor\", \"ds_cpl\", \"vmx\", \"smx\", \"est\", \"tm2\", \"ssse3\", \"cid\", \"fma\", \"cx16\", \"xtpr\", \"pdcm\", \"pcid\", \"dca\", \"sse4_1\", \"sse4_2\", \"x2apic\", \"movbe\", \"popcnt\", \"tsc_deadline_timer\", \"aes\", \"xsave\", \"avx\", \"f16c\", \"rdrand\", \"hypervisor\", \"rng\", \"rng_en\", \"ace\", \"ace_en\", \"ace2\", \"ace2_en\", \"phe\", \"phe_en\", \"pmm\", \"pmm_en\", \"lahf_lm\", \"cmp_legacy\", \"svm\", \"extapic\", \"cr8_legacy\", \"abm\", \"sse4a\", \"misalignsse\", \"3dnowprefetch\", \"osvw\", \"ibs\", \"xop\", \"skinit\", \"wdt\", \"lwp\", \"fma4\", \"tce\", \"nodeid_msr\", \"tbm\", \"topoext\", \"perfctr_core\", \"perfctr_nb\", \"bpext\", \"perfctr_l2\", \"mwaitx\", \"ida\", \"arat\", \"cpb\", \"epb\", \"pln\", \"pts\", \"dtherm\", \"hw_pstate\", \"proc_feedback\", \"hwp\", \"hwp_notify\", \"hwp_act_window\", \"hwp_epp\", \"hwp_pkg_req\", \"intel_pt\", \"tpr_shadow\", \"vnmi\", \"flexpriority\", \"ept\", \"vpid\", \"npt\", \"lbrv\", \"svm_lock\", \"nrip_save\", \"tsc_scale\", \"vmcb_clean\", \"flushbyasid\", \"decodeassists\", \"pausefilter\", \"pfthreshold\", \"vmmcall\", \"fsgsbase\", \"tsc_adjust\", \"bmi1\", \"hle\", \"avx2\", \"smep\", \"bmi2\", \"erms\", \"invpcid\", \"rtm\", \"cqm\", \"mpx\", \"avx512f\", \"rdseed\", \"adx\", \"smap\", \"pcommit\", \"clflushopt\", \"clwb\", \"avx512pf\", \"avx512er\", \"avx512cd\", \"sha_ni\", \"xsaveopt\", \"xsavec\", \"xgetbv1\", \"xsaves\", \"cqm_llc\", \"cqm_occup_llc\", \"clzero\"]}}','2025-11-29 06:54:32',NULL),(68,13,'hypervisor_type','{\"title\": \"Hypervisor Type\", \"description\": \"Hypervisor type required by the image. Used with the ImagePropertiesFilter. \\n\\n Baremetal - physical provisioning. hyperv - Microsoft\\u00ae hyperv. KVM - Kernel-based Virtual Machine. LXC - Linux Containers (through libvirt). powervm - IBM\\u00ae PowerVM\\u00ae. QEMU - Quick EMUlator. UML - User Mode Linux. vmware - VMware\\u00ae vsphere. VZ - Virtuozzo OS Containers and Virtual Machines (through libvirt). For more information, see: https://docs.openstack.org/nova/latest/admin/configuration/hypervisors.html\", \"type\": \"string\", \"enum\": [\"baremetal\", \"hyperv\", \"kvm\", \"lxc\", \"powervm\", \"qemu\", \"uml\", \"vmware\", \"vz\", \"xen\"]}','2025-11-29 06:54:32',NULL),(69,13,'vm_mode','{\"title\": \"VM Mode\", \"description\": \"The virtual machine mode. This represents the host/guest ABI (application binary interface) used for the virtual machine. Used with the ImagePropertiesFilter. \\n\\n hvm \\u2014 Fully virtualized - This is the virtual machine mode (vm_mode) used by QEMU and KVM. \\n\\n xen - Xen 3.0 paravirtualized. \\n\\n uml \\u2014 User Mode Linux paravirtualized. \\n\\n exe \\u2014 Executables in containers. This is the mode used by LXC.\", \"type\": \"string\", \"enum\": [\"hvm\", \"xen\", \"uml\", \"exe\"]}','2025-11-29 06:54:32',NULL),(70,14,'img_config_drive','{\"title\": \"Config Drive\", \"description\": \"This property specifies whether or not Nova should use a config drive when booting the image. Mandatory means that Nova will always use a config drive when booting the image. OpenStack can be configured to write metadata to a special configuration drive that will be attached to the instance when it boots. The instance can retrieve any information from the config drive. One use case for the config drive is to pass network configuration information to the instance. See also: http://docs.openstack.org/user-guide/cli_config_drive.html\", \"type\": \"string\", \"enum\": [\"optional\", \"mandatory\"]}','2025-11-29 06:54:33',NULL),(71,14,'os_require_quiesce','{\"title\": \"Require Quiescent File system\", \"description\": \"This property specifies whether or not the filesystem must be quiesced during snapshot processing. For volume backed and image backed snapshots, yes means that snapshotting is aborted when quiescing fails, whereas, no means quiescing will be skipped and snapshot processing will continue after the quiesce failure.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-11-29 06:54:33',NULL),(72,15,'hw_cdrom_bus','{\"title\": \"CD-ROM Bus\", \"description\": \"Specifies the type of disk controller to attach CD-ROM devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-11-29 06:54:33',NULL),(73,15,'hw_disk_bus','{\"title\": \"Disk Bus\", \"description\": \"Specifies the type of disk controller to attach disk devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-11-29 06:54:33',NULL),(74,15,'hw_firmware_type','{\"title\": \"Firmware Type\", \"description\": \"Specifies whether the image should be booted with a legacy BIOS or with UEFI.\", \"type\": \"string\", \"enum\": [\"bios\", \"uefi\"]}','2025-11-29 06:54:33',NULL),(75,15,'hw_rng_model','{\"title\": \"Random Number Generator Device\", \"description\": \"Adds a random-number generator device to the image\'s instances. The cloud administrator can enable and control device behavior by configuring the instance\'s flavor. By default: The generator device is disabled. /dev/random is used as the default entropy source. To specify a physical HW RNG device, use the following option in the nova.conf file: rng_dev_path=/dev/hwrng\", \"type\": \"string\", \"default\": \"virtio\"}','2025-11-29 06:54:33',NULL),(76,15,'hw_machine_type','{\"title\": \"Machine Type\", \"description\": \"Enables booting an ARM system using the specified machine type. By default, if an ARM image is used and its type is not specified, Compute uses vexpress-a15 (for ARMv7) or virt (for AArch64) machine types. Valid types can be viewed by using the virsh capabilities command (machine types are displayed in the machine tag).\", \"type\": \"string\"}','2025-11-29 06:54:33',NULL),(77,15,'hw_scsi_model','{\"title\": \"SCSI Model\", \"description\": \"Enables the use of VirtIO SCSI (virtio-scsi) to provide block device access for compute instances; by default, instances use VirtIO Block (virtio-blk). VirtIO SCSI is a para-virtualized SCSI controller device that provides improved scalability and performance, and supports advanced SCSI hardware.\", \"type\": \"string\", \"default\": \"virtio-scsi\"}','2025-11-29 06:54:33',NULL),(78,15,'hw_video_model','{\"title\": \"Video Model\", \"description\": \"The graphic device model presented to the guest. hw_video_model=none disables the graphics device in the guest and should generally be used when using gpu passthrough.\", \"type\": \"string\", \"enum\": [\"vga\", \"cirrus\", \"vmvga\", \"xen\", \"qxl\", \"virtio\", \"gop\", \"none\", \"bochs\"]}','2025-11-29 06:54:33',NULL),(79,15,'hw_video_ram','{\"title\": \"Max Video Ram\", \"description\": \"Maximum RAM (unit: MB) for the video image. Used only if a hw_video:ram_max_mb value has been set in the flavor\'s extra_specs and that value is higher than the value set in hw_video_ram.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-29 06:54:33',NULL),(80,15,'os_command_line','{\"title\": \"Kernel Command Line\", \"description\": \"The kernel command line to be used by the libvirt driver, instead of the default. For linux containers (LXC), the value is used as arguments for initialization. This key is valid only for Amazon kernel, ramdisk, or machine images (aki, ari, or ami).\", \"type\": \"string\"}','2025-11-29 06:54:33',NULL),(81,15,'os_type','{\"title\": \"OS Type\", \"description\": \"The operating system installed on the image. The libvirt driver contains logic that takes different actions depending on the value of the os_type parameter of the image. For example, for os_type=windows images, it creates a FAT32-based swap partition instead of a Linux swap partition, and it limits the injected host name to less than 16 characters.\", \"type\": \"string\", \"enum\": [\"linux\", \"windows\"]}','2025-11-29 06:54:33',NULL),(82,15,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor configuration. libvirt driver options: KVM and QEMU: e1000, ne2k_pci, pcnet, rtl8139, spapr-vlan, virtio, e1000e and vmxnet3. Xen: e1000, netfront, ne2k_pci, pcnet, and rtl8139.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"ne2k_pci\", \"netfront\", \"pcnet\", \"rtl8139\", \"spapr-vlan\", \"virtio\", \"vmxnet3\"]}','2025-11-29 06:54:33',NULL),(83,15,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-29 06:54:33',NULL),(84,15,'hw_pmu','{\"title\": \"Virtual Performance Monitoring Unit\", \"description\": \"Controls emulation of a vPMU in the guest. To reduce latency in realtime workloads disable the vPMU by setting hw_pmu=false\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-29 06:54:33',NULL),(85,15,'hw_qemu_guest_agent','{\"title\": \"QEMU Guest Agent\", \"description\": \"This is a background process which helps management applications execute guest OS level commands. For example, freezing and thawing filesystems, entering suspend. However, guest agent (GA) is not bullet proof, and hostile guest OS can send spurious replies.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-11-29 06:54:33',NULL),(86,15,'hw_pointer_model','{\"title\": \"Pointer Model\", \"description\": \"Input devices allow interaction with a graphical framebuffer. For example to provide a graphic tablet for absolute cursor movement. Currently only supported by the KVM/QEMU hypervisor configuration and VNC or SPICE consoles must be enabled.\", \"type\": \"string\", \"enum\": [\"usbtablet\"]}','2025-11-29 06:54:33',NULL),(87,15,'img_hide_hypervisor_id','{\"title\": \"Hide hypervisor id\", \"description\": \"Enables hiding the host hypervisor signature in the guest OS.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-11-29 06:54:33',NULL),(88,16,'serial_port_count','{\"title\": \"Serial Port Count\", \"description\": \"Specifies the count of serial ports that should be provided. If hw:serial_port_count is not set in the flavor\'s extra_specs, then any count is permitted. If hw:serial_port_count is set, then this provides the default serial port count. It is permitted to override the default serial port count, but only with a lower value.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-29 06:54:33',NULL),(89,16,'boot_menu','{\"title\": \"Boot Menu\", \"description\": \"If true, enables the BIOS bootmenu. In cases where both the image metadata and Extra Spec are set, the Extra Spec setting is used. This allows for flexibility in setting/overriding the default behavior as needed.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-29 06:54:33',NULL),(90,16,'mem_encryption','{\"title\": \"Hardware Memory Encryption\", \"description\": \"Enables encryption of guest memory at the hardware level, if there are compute hosts available which support this. See https://docs.openstack.org/nova/latest/admin/configuration/hypervisor-kvm.html#amd-sev-secure-encrypted-virtualization for details.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-29 06:54:33',NULL),(91,18,'hw_rng:allowed','{\"title\": \"Random Number Generator Allowed\", \"description\": \"\", \"type\": \"boolean\"}','2025-11-29 06:54:33',NULL),(92,18,'hw_rng:rate_bytes','{\"title\": \"Random number generator limits.\", \"description\": \"Allowed amount of bytes that the guest can read from the host\'s entropy per period.\", \"type\": \"integer\"}','2025-11-29 06:54:33',NULL),(93,18,'hw_rng:rate_period','{\"title\": \"Random number generator read period.\", \"description\": \"Duration of the read period in milliseconds.\", \"type\": \"integer\"}','2025-11-29 06:54:33',NULL),(94,19,'cpu_sockets','{\"title\": \"vCPU Sockets\", \"description\": \"Preferred number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-11-29 06:54:33',NULL),(95,19,'cpu_cores','{\"title\": \"vCPU Cores\", \"description\": \"Preferred number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-11-29 06:54:33',NULL),(96,19,'cpu_threads','{\"title\": \" vCPU Threads\", \"description\": \"Preferred number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-11-29 06:54:33',NULL),(97,19,'cpu_max_sockets','{\"title\": \"Max vCPU Sockets\", \"description\": \"Maximum number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-11-29 06:54:33',NULL),(98,19,'cpu_max_cores','{\"title\": \"Max vCPU Cores\", \"description\": \"Maximum number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-11-29 06:54:33',NULL),(99,19,'cpu_max_threads','{\"title\": \"Max vCPU Threads\", \"description\": \"Maximum number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-11-29 06:54:33',NULL),(100,20,'vmware:hw_version','{\"title\": \"VMware Hardware Version\", \"description\": \"Specifies the hardware version VMware uses to create images. If the hardware version needs to be compatible with a cluster version, for backward compatibility or other circumstances, the vmware:hw_version key specifies a virtual machine hardware version. In the event that a cluster has mixed host version types, the key will enable the vCenter to place the cluster on the correct host.\", \"type\": \"string\", \"enum\": [\"vmx-13\", \"vmx-11\", \"vmx-10\", \"vmx-09\", \"vmx-08\", \"vmx-07\", \"vmx-04\", \"vmx-03\"]}','2025-11-29 06:54:33',NULL),(101,20,'vmware:storage_policy','{\"title\": \"VMware Storage Policy\", \"description\": \"Specifies the storage policy to be applied for newly created instance. If not provided, the default storage policy specified in config file will be used. If Storage Policy Based Management (SPBM) is not enabled in config file, this value won\'t be used.\", \"type\": \"string\"}','2025-11-29 06:54:33',NULL),(102,21,'quota:cpu_limit','{\"title\": \"Quota: CPU Limit\", \"description\": \"Specifies the upper limit for CPU allocation in MHz. This parameter ensures that a machine never uses more than the defined amount of CPU time. It can be used to enforce a limit on the machine\'s CPU performance. The value should be a numerical value in MHz. If zero is supplied then the cpu_limit is unlimited.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-29 06:54:33',NULL),(103,21,'quota:cpu_reservation','{\"title\": \"Quota: CPU Reservation Limit\", \"description\": \"Specifies the guaranteed minimum CPU reservation in MHz. This means that if needed, the machine will definitely get allocated the reserved amount of CPU cycles. The value should be a numerical value in MHz.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-29 06:54:33',NULL),(104,22,'img_linked_clone','{\"title\": \"Linked Clone\", \"description\": \"By default, the VMware compute driver creates linked clones when possible (though this can be turned off by the operator). You can use this image property on a per-image basis to control whether virtual machines booted from the image are treated as full clones (value: false) or linked clones (value: true). Please refer to VMware documentation for information about full vs. linked clones.\", \"type\": \"boolean\"}','2025-11-29 06:54:33',NULL),(105,22,'vmware_adaptertype','{\"title\": \"Disk Adapter Type\", \"description\": \"The virtual SCSI or IDE controller used by the hypervisor.\", \"type\": \"string\", \"enum\": [\"lsiLogic\", \"lsiLogicsas\", \"paraVirtual\", \"busLogic\", \"ide\"], \"default\": \"lsiLogic\"}','2025-11-29 06:54:33',NULL),(106,22,'vmware_disktype','{\"title\": \"Disk Provisioning Type\", \"description\": \"When performing operations such as creating a virtual disk, cloning, or migrating, the disk provisioning type may be specified. Please refer to VMware documentation for more.\", \"type\": \"string\", \"enum\": [\"streamOptimized\", \"sparse\", \"preallocated\"], \"default\": \"preallocated\"}','2025-11-29 06:54:33',NULL),(107,22,'vmware_ostype','{\"title\": \"OS Type\", \"description\": \"A VMware GuestID which describes the operating system installed in the image. This value is passed to the hypervisor when creating a virtual machine. If not specified, the key defaults to otherGuest. See thinkvirt.com.\", \"type\": \"string\", \"enum\": [\"asianux3_64Guest\", \"asianux3Guest\", \"asianux4_64Guest\", \"asianux4Guest\", \"asianux5_64Guest\", \"asianux7_64Guest\", \"centos64Guest\", \"centosGuest\", \"centos6Guest\", \"centos6_64Guest\", \"centos7_64Guest\", \"coreos64Guest\", \"darwin10_64Guest\", \"darwin10Guest\", \"darwin11_64Guest\", \"darwin11Guest\", \"darwin12_64Guest\", \"darwin13_64Guest\", \"darwin14_64Guest\", \"darwin15_64Guest\", \"darwin16_64Guest\", \"darwin64Guest\", \"darwinGuest\", \"debian4_64Guest\", \"debian4Guest\", \"debian5_64Guest\", \"debian5Guest\", \"debian6_64Guest\", \"debian6Guest\", \"debian7_64Guest\", \"debian7Guest\", \"debian8_64Guest\", \"debian8Guest\", \"debian9_64Guest\", \"debian9Guest\", \"debian10_64Guest\", \"debian10Guest\", \"dosGuest\", \"eComStation2Guest\", \"eComStationGuest\", \"fedora64Guest\", \"fedoraGuest\", \"freebsd64Guest\", \"freebsdGuest\", \"genericLinuxGuest\", \"mandrakeGuest\", \"mandriva64Guest\", \"mandrivaGuest\", \"netware4Guest\", \"netware5Guest\", \"netware6Guest\", \"nld9Guest\", \"oesGuest\", \"openServer5Guest\", \"openServer6Guest\", \"opensuse64Guest\", \"opensuseGuest\", \"oracleLinux64Guest\", \"oracleLinuxGuest\", \"oracleLinux6Guest\", \"oracleLinux6_64Guest\", \"oracleLinux7_64Guest\", \"os2Guest\", \"other24xLinux64Guest\", \"other24xLinuxGuest\", \"other26xLinux64Guest\", \"other26xLinuxGuest\", \"other3xLinux64Guest\", \"other3xLinuxGuest\", \"otherGuest\", \"otherGuest64\", \"otherLinux64Guest\", \"otherLinuxGuest\", \"redhatGuest\", \"rhel2Guest\", \"rhel3_64Guest\", \"rhel3Guest\", \"rhel4_64Guest\", \"rhel4Guest\", \"rhel5_64Guest\", \"rhel5Guest\", \"rhel6_64Guest\", \"rhel6Guest\", \"rhel7_64Guest\", \"rhel7Guest\", \"sjdsGuest\", \"sles10_64Guest\", \"sles10Guest\", \"sles11_64Guest\", \"sles11Guest\", \"sles12_64Guest\", \"sles12Guest\", \"sles64Guest\", \"slesGuest\", \"solaris10_64Guest\", \"solaris10Guest\", \"solaris11_64Guest\", \"solaris6Guest\", \"solaris7Guest\", \"solaris8Guest\", \"solaris9Guest\", \"turboLinux64Guest\", \"turboLinuxGuest\", \"ubuntu64Guest\", \"ubuntuGuest\", \"unixWare7Guest\", \"vmkernel5Guest\", \"vmkernel6Guest\", \"vmkernel65Guest\", \"vmkernelGuest\", \"vmwarePhoton64Guest\", \"win2000AdvServGuest\", \"win2000ProGuest\", \"win2000ServGuest\", \"win31Guest\", \"win95Guest\", \"win98Guest\", \"windows7_64Guest\", \"windows7Guest\", \"windows7Server64Guest\", \"windows8_64Guest\", \"windows8Guest\", \"windows8Server64Guest\", \"windows9_64Guest\", \"windows9Guest\", \"windows9Server64Guest\", \"windowsHyperVGuest\", \"winLonghorn64Guest\", \"winLonghornGuest\", \"winMeGuest\", \"winNetBusinessGuest\", \"winNetDatacenter64Guest\", \"winNetDatacenterGuest\", \"winNetEnterprise64Guest\", \"winNetEnterpriseGuest\", \"winNetStandard64Guest\", \"winNetStandardGuest\", \"winNetWebGuest\", \"winNTGuest\", \"winVista64Guest\", \"winVistaGuest\", \"winXPHomeGuest\", \"winXPPro64Guest\", \"winXPProGuest\"], \"default\": \"otherGuest\"}','2025-11-29 06:54:33',NULL),(108,22,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor. VMware driver supported options: e1000, e1000e, VirtualE1000, VirtualE1000e, VirtualPCNet32, and VirtualVmxnet.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"VirtualE1000\", \"VirtualE1000e\", \"VirtualPCNet32\", \"VirtualVmxnet\", \"VirtualVmxnet3\"], \"default\": \"e1000\"}','2025-11-29 06:54:33',NULL),(109,22,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-29 06:54:33',NULL),(110,23,'tpm_model','{\"title\": \"TPM model\", \"description\": \"TPM model to use. Option CRB is only valid for TPM version 2.0. Defaults to TIS.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"TIS\", \"CRB\"], \"default\": \"TIS\"}','2025-11-29 06:54:33',NULL),(111,24,'COMPUTE_SECURITY_TPM_1_2','{\"title\": \"Virtual TPM Version 1.2 Support\", \"description\": \"Enables virtual TPM version 1.2.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-11-29 06:54:33',NULL),(112,24,'COMPUTE_SECURITY_TPM_2_0','{\"title\": \"Virtual TPM Version 2.0 Support\", \"description\": \"Enables virtual TPM version 2.0.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-11-29 06:54:33',NULL),(113,25,'watchdog_action','{\"title\": \"Watchdog Action\", \"description\": \"For the libvirt driver, you can enable and set the behavior of a virtual hardware watchdog device for each flavor. Watchdog devices keep an eye on the guest server, and carry out the configured action, if the server hangs. The watchdog uses the i6300esb device (emulating a PCI Intel 6300ESB). If hw_watchdog_action is not specified, the watchdog is disabled. Watchdog behavior set using a specific image\'s properties will override behavior set using flavors.\", \"type\": \"string\", \"enum\": [\"disabled\", \"reset\", \"poweroff\", \"pause\", \"none\"]}','2025-11-29 06:54:33',NULL),(114,26,'auto_disk_config','{\"title\": \"Disk Adapter Type\", \"description\": \"If true, the root partition on the disk is automatically resized before the instance boots. This value is only taken into account by the Compute service when using a Xen-based hypervisor with the XenAPI driver. The Compute service will only attempt to resize if there is a single partition on the image, and only if the partition is in ext3 or ext4 format.\", \"type\": \"boolean\"}','2025-11-29 06:54:33',NULL),(115,27,'kernel_id','{\"title\": \"Kernel ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the kernel when booting an AMI-style image.\"}','2025-11-29 06:54:33',NULL),(116,27,'ramdisk_id','{\"title\": \"Ramdisk ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the ramdisk when booting an AMI-style image.\"}','2025-11-29 06:54:33',NULL),(117,27,'instance_uuid','{\"title\": \"Instance ID\", \"type\": \"string\", \"description\": \"Metadata which can be used to record which instance this image is associated with. (Informational only, does not create an instance snapshot.)\"}','2025-11-29 06:54:33',NULL),(118,27,'architecture','{\"title\": \"CPU Architecture\", \"description\": \"The CPU architecture that must be supported by the hypervisor. For example, x86_64, arm, or ppc64. Run uname -m to get the architecture of a machine. We strongly recommend using the architecture data vocabulary defined by the libosinfo project for this purpose.\", \"type\": \"string\"}','2025-11-29 06:54:33',NULL),(119,27,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-11-29 06:54:33',NULL),(120,27,'hw_cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"This specifies the CPU Mode for the guest vm\", \"type\": \"string\"}','2025-11-29 06:54:33',NULL),(121,27,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-11-29 06:54:33',NULL),(122,27,'description','{\"title\": \"Image description\", \"description\": \"A human-readable string describing this image.\", \"type\": \"string\"}','2025-11-29 06:54:33',NULL),(123,27,'cinder_encryption_key_id','{\"title\": \"Cinder Encryption Key ID\", \"description\": \"Identifier in the OpenStack Key Management Service for the encryption key for the Block Storage Service to use when mounting a volume created from this image\", \"type\": \"string\"}','2025-11-29 06:54:33',NULL),(124,27,'cinder_encryption_key_deletion_policy','{\"title\": \"Cinder Encryption Key Deletion Policy\", \"description\": \"States the condition under which the Image Service will delete the object associated with the \'cinder_encryption_key_id\' image property.  If this property is missing, the Image Service will take no action\", \"type\": \"string\", \"enum\": [\"on_image_deletion\", \"do_not_delete\"]}','2025-11-29 06:54:33',NULL),(125,28,'img_signature','{\"title\": \"Image Signature\", \"description\": \"The signature of the image data encoded in base64 format.\", \"type\": \"string\"}','2025-11-29 06:54:33',NULL),(126,28,'img_signature_certificate_uuid','{\"title\": \"Image Signature Certificate UUID\", \"description\": \"The UUID used to retrieve the certificate from the key manager.\", \"type\": \"string\"}','2025-11-29 06:54:33',NULL),(127,28,'img_signature_hash_method','{\"title\": \"Image Signature Hash Method\", \"description\": \"The hash method used in creating the signature.\", \"type\": \"string\", \"enum\": [\"SHA-224\", \"SHA-256\", \"SHA-384\", \"SHA-512\"]}','2025-11-29 06:54:33',NULL),(128,28,'img_signature_key_type','{\"title\": \"Image Signature Key Type\", \"description\": \"The key type used in creating the signature.\", \"type\": \"string\", \"enum\": [\"RSA-PSS\", \"DSA\", \"ECC_SECT571K1\", \"ECC_SECT409K1\", \"ECC_SECT571R1\", \"ECC_SECT409R1\", \"ECC_SECP521R1\", \"ECC_SECP384R1\"]}','2025-11-29 06:54:33',NULL),(129,29,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-11-29 06:54:33',NULL),(130,29,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-11-29 06:54:33',NULL),(131,29,'os_admin_user','{\"title\": \"OS Admin User\", \"description\": \"The name of the user with admin privileges.\", \"type\": \"string\"}','2025-11-29 06:54:33',NULL),(132,33,'img_volume_type','{\"title\": \"Image Volume Type\", \"description\": \"Specifies the volume type that should be applied during new volume creation with a image. This value is passed to Cinder when creating a new volume. Priority of volume type related parameters are 1.volume_type(via API or CLI), 2.cinder_img_volume_type, 3.default_volume_type(via cinder.conf). If not specified, volume_type or default_volume_type will be referred based on their priority.\", \"type\": \"string\"}','2025-11-29 06:54:34',NULL);
/*!40000 ALTER TABLE `metadef_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_resource_types`
--

DROP TABLE IF EXISTS `metadef_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_resource_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `protected` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_resource_types_name` (`name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_resource_types`
--

LOCK TABLES `metadef_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_resource_types` (`id`, `name`, `protected`, `created_at`, `updated_at`) VALUES (1,'OS::Cinder::Volume',1,'2025-11-29 06:54:31',NULL),(2,'OS::Glance::Image',1,'2025-11-29 06:54:31',NULL),(3,'OS::Nova::Aggregate',1,'2025-11-29 06:54:31',NULL),(4,'OS::Nova::Flavor',1,'2025-11-29 06:54:31',NULL),(5,'OS::Nova::Server',1,'2025-11-29 06:54:31',NULL),(6,'OS::Trove::Instance',1,'2025-11-29 06:54:33',NULL);
/*!40000 ALTER TABLE `metadef_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_tags`
--

DROP TABLE IF EXISTS `metadef_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_tags_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_tags_name` (`name`),
  CONSTRAINT `metadef_tags_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_tags`
--

LOCK TABLES `metadef_tags` WRITE;
/*!40000 ALTER TABLE `metadef_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadef_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_info`
--

DROP TABLE IF EXISTS `task_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_info` (
  `task_id` varchar(36) NOT NULL,
  `input` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  CONSTRAINT `task_info_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_info`
--

LOCK TABLES `task_info` WRITE;
/*!40000 ALTER TABLE `task_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` varchar(36) NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `image_id` varchar(36) DEFAULT NULL,
  `request_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_tasks_deleted` (`deleted`),
  KEY `ix_tasks_owner` (`owner`),
  KEY `ix_tasks_status` (`status`),
  KEY `ix_tasks_type` (`type`),
  KEY `ix_tasks_updated_at` (`updated_at`),
  KEY `ix_tasks_image_id` (`image_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `keystone`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `keystone` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `keystone`;

--
-- Table structure for table `access_rule`
--

DROP TABLE IF EXISTS `access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(64) DEFAULT NULL,
  `path` varchar(128) DEFAULT NULL,
  `method` varchar(16) DEFAULT NULL,
  `external_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_rule_external_id_key` (`external_id`),
  UNIQUE KEY `duplicate_access_rule_for_user_constraint` (`user_id`,`service`,`path`,`method`),
  KEY `external_id` (`external_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_rule`
--

LOCK TABLES `access_rule` WRITE;
/*!40000 ALTER TABLE `access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_token`
--

DROP TABLE IF EXISTS `access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_token` (
  `id` varchar(64) NOT NULL,
  `access_secret` varchar(64) NOT NULL,
  `authorizing_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  `role_ids` text NOT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_access_token_authorizing_user_id` (`authorizing_user_id`),
  KEY `ix_access_token_consumer_id` (`consumer_id`),
  CONSTRAINT `access_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_token`
--

LOCK TABLES `access_token` WRITE;
/*!40000 ALTER TABLE `access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('29e87d24a316'),('e25ffa003242');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential`
--

DROP TABLE IF EXISTS `application_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential` (
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `secret_hash` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `system` varchar(64) DEFAULT NULL,
  `unrestricted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `duplicate_app_cred_constraint` (`user_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential`
--

LOCK TABLES `application_credential` WRITE;
/*!40000 ALTER TABLE `application_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_access_rule`
--

DROP TABLE IF EXISTS `application_credential_access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_access_rule` (
  `application_credential_id` int(11) NOT NULL,
  `access_rule_id` int(11) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`access_rule_id`),
  KEY `access_rule_id` (`access_rule_id`),
  CONSTRAINT `application_credential_access_rule_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE,
  CONSTRAINT `application_credential_access_rule_ibfk_2` FOREIGN KEY (`access_rule_id`) REFERENCES `access_rule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_access_rule`
--

LOCK TABLES `application_credential_access_rule` WRITE;
/*!40000 ALTER TABLE `application_credential_access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_role`
--

DROP TABLE IF EXISTS `application_credential_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_role` (
  `application_credential_id` int(11) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`role_id`),
  CONSTRAINT `application_credential_role_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_role`
--

LOCK TABLES `application_credential_role` WRITE;
/*!40000 ALTER TABLE `application_credential_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assignment` (
  `type` enum('UserProject','GroupProject','UserDomain','GroupDomain') NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  KEY `ix_actor_id` (`actor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserProject','07d8fdc1f04d4769b5744eeac3a6f5f4','313f5427e3624aa189013c3cc05bee02','4ab5e58929544d36be00d28d28cd1485',0),('UserProject','07d8fdc1f04d4769b5744eeac3a6f5f4','313f5427e3624aa189013c3cc05bee02','ae4a1c424e744d14ab2b8be75d253e0a',0),('UserProject','07d8fdc1f04d4769b5744eeac3a6f5f4','e3d094cabd5e4c46ae4c1fc0a07878f3','4ab5e58929544d36be00d28d28cd1485',0),('UserProject','0b5e852f4a214b5fad81b314f18939d1','ecbeee0b8f0d4eb4a70c29ecb044cf2a','1fb5b35072264d2daf875dd0816311df',0),('UserProject','0b5e852f4a214b5fad81b314f18939d1','ecbeee0b8f0d4eb4a70c29ecb044cf2a','4ab5e58929544d36be00d28d28cd1485',0),('UserProject','154b87b301664cbb87dcabd0078959a4','ecbeee0b8f0d4eb4a70c29ecb044cf2a','1fb5b35072264d2daf875dd0816311df',0),('UserProject','154b87b301664cbb87dcabd0078959a4','ecbeee0b8f0d4eb4a70c29ecb044cf2a','4ab5e58929544d36be00d28d28cd1485',0),('UserProject','322529fd0a444bda9d365f78b23f9b7c','ecbeee0b8f0d4eb4a70c29ecb044cf2a','1fb5b35072264d2daf875dd0816311df',0),('UserProject','322529fd0a444bda9d365f78b23f9b7c','ecbeee0b8f0d4eb4a70c29ecb044cf2a','4ab5e58929544d36be00d28d28cd1485',0),('UserProject','3412e27b49e5442fa73da6dd686d0b3a','ecbeee0b8f0d4eb4a70c29ecb044cf2a','1fb5b35072264d2daf875dd0816311df',0),('UserProject','3412e27b49e5442fa73da6dd686d0b3a','ecbeee0b8f0d4eb4a70c29ecb044cf2a','4ab5e58929544d36be00d28d28cd1485',0),('UserProject','42c693593bc84068b5dc10095b3dfc4b','ecbeee0b8f0d4eb4a70c29ecb044cf2a','04bf06f01b0e4121b205ab6b844f95a9',0),('UserProject','42c693593bc84068b5dc10095b3dfc4b','ecbeee0b8f0d4eb4a70c29ecb044cf2a','4ab5e58929544d36be00d28d28cd1485',0),('UserProject','c491675d5f06426092a19d82da1b5638','ecbeee0b8f0d4eb4a70c29ecb044cf2a','1fb5b35072264d2daf875dd0816311df',0),('UserProject','c491675d5f06426092a19d82da1b5638','ecbeee0b8f0d4eb4a70c29ecb044cf2a','4ab5e58929544d36be00d28d28cd1485',0),('UserProject','f1de88c0afe14c67a5e9319365e6639c','ecbeee0b8f0d4eb4a70c29ecb044cf2a','1fb5b35072264d2daf875dd0816311df',0),('UserProject','f1de88c0afe14c67a5e9319365e6639c','ecbeee0b8f0d4eb4a70c29ecb044cf2a','4ab5e58929544d36be00d28d28cd1485',0),('UserProject','fc1f94c9796d48eda7e2546e034a5b57','ecbeee0b8f0d4eb4a70c29ecb044cf2a','1fb5b35072264d2daf875dd0816311df',0),('UserProject','fc1f94c9796d48eda7e2546e034a5b57','ecbeee0b8f0d4eb4a70c29ecb044cf2a','4ab5e58929544d36be00d28d28cd1485',0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_register`
--

DROP TABLE IF EXISTS `config_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_register` (
  `type` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_register`
--

LOCK TABLES `config_register` WRITE;
/*!40000 ALTER TABLE `config_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `config_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumer`
--

DROP TABLE IF EXISTS `consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumer` (
  `id` varchar(64) NOT NULL,
  `description` varchar(64) DEFAULT NULL,
  `secret` varchar(64) NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumer`
--

LOCK TABLES `consumer` WRITE;
/*!40000 ALTER TABLE `consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credential` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `key_hash` varchar(64) NOT NULL,
  `encrypted_blob` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint` (
  `id` varchar(64) NOT NULL,
  `legacy_endpoint_id` varchar(64) DEFAULT NULL,
  `interface` varchar(8) NOT NULL,
  `service_id` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `region_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_endpoint_region_id` (`region_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `endpoint_service_id_fkey` FOREIGN KEY (`service_id`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_endpoint_region_id` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
INSERT INTO `endpoint` (`id`, `legacy_endpoint_id`, `interface`, `service_id`, `url`, `extra`, `enabled`, `region_id`) VALUES ('1771545f30214461bdb068fbe9cd82de',NULL,'internal','cce233c47340431ab7f2a0205f5bd0fb','https://neutron-internal.openstack.svc:9696','{\"name\": \"neutron\"}',1,'regionOne'),('1fec5c4bf28843b68339ccbc4a448f58',NULL,'internal','27424dfb271640158e449513621da8a4','https://barbican-internal.openstack.svc:9311','{\"name\": \"barbican\"}',1,'regionOne'),('36268a264840428daa65841770735f36',NULL,'public','04798044e0e7463192922f909e83b7a6','https://keystone-public-openstack.apps-crc.testing','{}',1,'regionOne'),('385ce9798d2f4697b57ea99962df6682',NULL,'public','2e9613f0af6f4c73856a69c6797721b7','https://cinder-public-openstack.apps-crc.testing/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('4b468759eec949f7a9d9cc1ca4ce6edc',NULL,'internal','aab5d088d8ee44dcb35e8db6f7344159','https://placement-internal.openstack.svc:8778','{\"name\": \"placement\"}',1,'regionOne'),('563c67e7150f4047bf4309808b147e81',NULL,'public','bb11416d93654a988b6034d41e099615','https://glance-default-public-openstack.apps-crc.testing','{\"name\": \"glance\"}',1,'regionOne'),('67ecb08691ed4556803ebb6d28c0516f',NULL,'internal','6a7453ef7c7b4d3d88909ab42bee6d17','https://nova-internal.openstack.svc:8774/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('7498d6fe013342cd80e2040bdc10387a',NULL,'public','27424dfb271640158e449513621da8a4','https://barbican-public-openstack.apps-crc.testing','{\"name\": \"barbican\"}',1,'regionOne'),('756f8493a45347fc832b5e56d2117aff',NULL,'public','62510965ab77429781a62bed6f089b07','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne'),('82bd0458832841a69521a24352667182',NULL,'internal','04798044e0e7463192922f909e83b7a6','https://keystone-internal.openstack.svc:5000','{}',1,'regionOne'),('99ccfca1b681454ab8d1ad3036776559',NULL,'internal','bb11416d93654a988b6034d41e099615','https://glance-default-internal.openstack.svc:9292','{\"name\": \"glance\"}',1,'regionOne'),('b19ba6ad50f745edb70a008fddb4283c',NULL,'public','aab5d088d8ee44dcb35e8db6f7344159','https://placement-public-openstack.apps-crc.testing','{\"name\": \"placement\"}',1,'regionOne'),('c5d8ffb5167d41cea83b67b6139af226',NULL,'public','cce233c47340431ab7f2a0205f5bd0fb','https://neutron-public-openstack.apps-crc.testing','{\"name\": \"neutron\"}',1,'regionOne'),('df132992300a4d86970917c2e3a24145',NULL,'internal','2e9613f0af6f4c73856a69c6797721b7','https://cinder-internal.openstack.svc:8776/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('e3bbdd1d4f7f4c5b9196c56fdb81ef36',NULL,'public','6a7453ef7c7b4d3d88909ab42bee6d17','https://nova-public-openstack.apps-crc.testing/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('fbd9cb5c285d4745960fc90c95813cb4',NULL,'internal','62510965ab77429781a62bed6f089b07','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne');
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint_group`
--

DROP TABLE IF EXISTS `endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint_group` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `filters` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint_group`
--

LOCK TABLES `endpoint_group` WRITE;
/*!40000 ALTER TABLE `endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expiring_user_group_membership`
--

DROP TABLE IF EXISTS `expiring_user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expiring_user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `last_verified` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`,`idp_id`),
  KEY `group_id` (`group_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_3` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expiring_user_group_membership`
--

LOCK TABLES `expiring_user_group_membership` WRITE;
/*!40000 ALTER TABLE `expiring_user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `expiring_user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federated_user`
--

DROP TABLE IF EXISTS `federated_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federated_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `protocol_id` varchar(64) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idp_id` (`idp_id`,`protocol_id`,`unique_id`),
  KEY `federated_user_protocol_id_fkey` (`protocol_id`,`idp_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `federated_user_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_ibfk_2` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_protocol_id_fkey` FOREIGN KEY (`protocol_id`, `idp_id`) REFERENCES `federation_protocol` (`id`, `idp_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federated_user`
--

LOCK TABLES `federated_user` WRITE;
/*!40000 ALTER TABLE `federated_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `federated_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federation_protocol`
--

DROP TABLE IF EXISTS `federation_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federation_protocol` (
  `id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `mapping_id` varchar(64) NOT NULL,
  `remote_id_attribute` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`,`idp_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `federation_protocol_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federation_protocol`
--

LOCK TABLES `federation_protocol` WRITE;
/*!40000 ALTER TABLE `federation_protocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `federation_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group`
--

DROP TABLE IF EXISTS `group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group` (
  `id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_group_name_domain_id` (`domain_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group`
--

LOCK TABLES `group` WRITE;
/*!40000 ALTER TABLE `group` DISABLE KEYS */;
/*!40000 ALTER TABLE `group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `id_mapping`
--

DROP TABLE IF EXISTS `id_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `id_mapping` (
  `public_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `local_id` varchar(255) NOT NULL,
  `entity_type` enum('user','group') NOT NULL,
  PRIMARY KEY (`public_id`),
  UNIQUE KEY `domain_id` (`domain_id`,`local_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `id_mapping`
--

LOCK TABLES `id_mapping` WRITE;
/*!40000 ALTER TABLE `id_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `id_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `identity_provider`
--

DROP TABLE IF EXISTS `identity_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `identity_provider` (
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `authorization_ttl` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `identity_provider`
--

LOCK TABLES `identity_provider` WRITE;
/*!40000 ALTER TABLE `identity_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `identity_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `idp_remote_ids`
--

DROP TABLE IF EXISTS `idp_remote_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `idp_remote_ids` (
  `idp_id` varchar(64) DEFAULT NULL,
  `remote_id` varchar(255) NOT NULL,
  PRIMARY KEY (`remote_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `idp_remote_ids_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `idp_remote_ids`
--

LOCK TABLES `idp_remote_ids` WRITE;
/*!40000 ALTER TABLE `idp_remote_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `idp_remote_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `implied_role`
--

DROP TABLE IF EXISTS `implied_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `implied_role` (
  `prior_role_id` varchar(64) NOT NULL,
  `implied_role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`prior_role_id`,`implied_role_id`),
  KEY `implied_role_implied_role_id_fkey` (`implied_role_id`),
  CONSTRAINT `implied_role_implied_role_id_fkey` FOREIGN KEY (`implied_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE,
  CONSTRAINT `implied_role_prior_role_id_fkey` FOREIGN KEY (`prior_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `implied_role`
--

LOCK TABLES `implied_role` WRITE;
/*!40000 ALTER TABLE `implied_role` DISABLE KEYS */;
INSERT INTO `implied_role` (`prior_role_id`, `implied_role_id`) VALUES ('04bf06f01b0e4121b205ab6b844f95a9','59f0753a912449cca75cd42b1a2387d3'),('4ab5e58929544d36be00d28d28cd1485','04bf06f01b0e4121b205ab6b844f95a9');
/*!40000 ALTER TABLE `implied_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `limit`
--

DROP TABLE IF EXISTS `limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `limit` (
  `id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `resource_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `registered_limit_id` varchar(64) DEFAULT NULL,
  `domain_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `limit_id_key` (`id`),
  KEY `registered_limit_id` (`registered_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `limit`
--

LOCK TABLES `limit` WRITE;
/*!40000 ALTER TABLE `limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_user`
--

DROP TABLE IF EXISTS `local_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `local_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `failed_auth_count` int(11) DEFAULT NULL,
  `failed_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_id` (`domain_id`,`name`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `local_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `local_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=254 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `local_user`
--

LOCK TABLES `local_user` WRITE;
/*!40000 ALTER TABLE `local_user` DISABLE KEYS */;
INSERT INTO `local_user` (`id`, `user_id`, `domain_id`, `name`, `failed_auth_count`, `failed_auth_at`) VALUES (1,'07d8fdc1f04d4769b5744eeac3a6f5f4','default','admin',0,NULL),(2,'322529fd0a444bda9d365f78b23f9b7c','default','neutron',0,NULL),(3,'f1de88c0afe14c67a5e9319365e6639c','default','glance',0,NULL),(4,'0b5e852f4a214b5fad81b314f18939d1','default','cinder',0,NULL),(5,'c491675d5f06426092a19d82da1b5638','default','barbican',0,NULL),(6,'154b87b301664cbb87dcabd0078959a4','default','nova',0,NULL),(7,'3412e27b49e5442fa73da6dd686d0b3a','default','ceilometer',0,NULL),(8,'fc1f94c9796d48eda7e2546e034a5b57','default','placement',0,NULL),(9,'42c693593bc84068b5dc10095b3dfc4b','default','swift',0,NULL),(10,'256c8a1ee11a4186828e6bc6a73449c9','default','demo_tempestconf',0,NULL),(11,'c56f5d50072247b1bef168b51c299cba','default','alt_demo_tempestconf',0,NULL);
/*!40000 ALTER TABLE `local_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mapping`
--

DROP TABLE IF EXISTS `mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mapping` (
  `id` varchar(64) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mapping`
--

LOCK TABLES `mapping` WRITE;
/*!40000 ALTER TABLE `mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nonlocal_user`
--

DROP TABLE IF EXISTS `nonlocal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nonlocal_user` (
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  PRIMARY KEY (`domain_id`,`name`),
  UNIQUE KEY `ixu_nonlocal_user_user_id` (`user_id`),
  KEY `nonlocal_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `nonlocal_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nonlocal_user`
--

LOCK TABLES `nonlocal_user` WRITE;
/*!40000 ALTER TABLE `nonlocal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `nonlocal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password`
--

DROP TABLE IF EXISTS `password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_user_id` int(11) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `self_service` tinyint(1) NOT NULL DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `created_at_int` bigint(20) NOT NULL DEFAULT 0,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `local_user_id` (`local_user_id`),
  CONSTRAINT `password_ibfk_1` FOREIGN KEY (`local_user_id`) REFERENCES `local_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=254 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password`
--

LOCK TABLES `password` WRITE;
/*!40000 ALTER TABLE `password` DISABLE KEYS */;
INSERT INTO `password` (`id`, `local_user_id`, `expires_at`, `self_service`, `password_hash`, `created_at_int`, `expires_at_int`, `created_at`) VALUES (1,1,NULL,0,'$2b$12$1qjdKawf0KSgGfkyFgTAWeBRf/kV9FAKFU2ov7Z/bQ8K9JF23Qv2.',1764399296059953,NULL,'2025-11-29 06:54:56'),(2,2,NULL,0,'$2b$12$nKXbFvLmN7VGvTR8CzLN5uiArhb36vX1CfwGp3oFh2k4TyQ7f8oxO',1764399365510352,NULL,'2025-11-29 06:56:05'),(3,3,NULL,0,'$2b$12$NzANDVgedxFpe8WJjFJh/u7qh/s3S1IKV2lH2BcXZzEaSj8pwnzR2',1764399369622056,NULL,'2025-11-29 06:56:09'),(4,4,NULL,0,'$2b$12$1tQtEH2a6YPUd6OUvgu5aeXEvrBUSI1zLpK4FAUYnQWrycsW.S3OK',1764399374880679,NULL,'2025-11-29 06:56:14'),(5,5,NULL,0,'$2b$12$ZYKfKmcG7bjgE5RjML6Cb.i/M7PE7kAkjiOaY.MBU6awhW6aLrLWO',1764399377642031,NULL,'2025-11-29 06:56:17'),(6,6,NULL,0,'$2b$12$UL5/CRvFx2SxwhLfF17.5.9p/wIXRgIiiaOqGbtW3M3zpNcQ9K2ue',1764399384430972,NULL,'2025-11-29 06:56:24'),(7,7,NULL,0,'$2b$12$22gY/vGlaD26p32YbKTUWOEqCWZsM.8LdSBR58S2XLZx7pINtLHlO',1764399389579032,NULL,'2025-11-29 06:56:29'),(8,8,NULL,0,'$2b$12$wHimCetlR3Ifd3EE0ednZe.0odOXeI8B2zv4bHJI17FbeXrz7JRQa',1764399401002317,NULL,'2025-11-29 06:56:41'),(9,9,NULL,0,'$2b$12$L9Fl7xZQX0svSmHZDZYOfOleq0vQT9OQx82CLTDXFG.X8T6FRMROq',1764400595180300,NULL,'2025-11-29 07:16:35'),(10,10,NULL,0,'$2b$12$zPO.zwg8xwYVP4Z.hSDHU.UwdgL4RC57rnaDbg7LnRK9Wcykp8nzu',1764402494681780,NULL,'2025-11-29 07:48:14'),(11,11,NULL,0,'$2b$12$CAqeVeGjtojunoc.VgaRmuDDdkBBBqSCssIz4wKslLDa3moLTbnGK',1764402495932448,NULL,'2025-11-29 07:48:15');
/*!40000 ALTER TABLE `password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `blob` text NOT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_association`
--

DROP TABLE IF EXISTS `policy_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy_association` (
  `id` varchar(64) NOT NULL,
  `policy_id` varchar(64) NOT NULL,
  `endpoint_id` varchar(64) DEFAULT NULL,
  `service_id` varchar(64) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `endpoint_id` (`endpoint_id`,`service_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_association`
--

LOCK TABLES `policy_association` WRITE;
/*!40000 ALTER TABLE `policy_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project` (
  `id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL,
  `is_domain` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_project_name_domain_id` (`domain_id`,`name`),
  KEY `project_parent_id_fkey` (`parent_id`),
  CONSTRAINT `project_domain_id_fkey` FOREIGN KEY (`domain_id`) REFERENCES `project` (`id`),
  CONSTRAINT `project_parent_id_fkey` FOREIGN KEY (`parent_id`) REFERENCES `project` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
INSERT INTO `project` (`id`, `name`, `extra`, `description`, `enabled`, `domain_id`, `parent_id`, `is_domain`) VALUES ('313f5427e3624aa189013c3cc05bee02','admin','{}','Bootstrap project for initializing the cloud.',1,'default','default',0),('<<keystone.domain.root>>','<<keystone.domain.root>>','{}','',0,'<<keystone.domain.root>>',NULL,1),('aa123ad9ac964c8499db667425cde073','alt_demo','{}','Project for Tempest alt_demo_tempestconf user',1,'default','default',0),('default','Default','{}','The default domain',1,'<<keystone.domain.root>>',NULL,1),('e3d094cabd5e4c46ae4c1fc0a07878f3','demo','{}','Project for Tempest demo_tempestconf user',1,'default','default',0),('ecbeee0b8f0d4eb4a70c29ecb044cf2a','service','{}','service',1,'default','default',0);
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint`
--

DROP TABLE IF EXISTS `project_endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint` (
  `endpoint_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint`
--

LOCK TABLES `project_endpoint` WRITE;
/*!40000 ALTER TABLE `project_endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint_group`
--

DROP TABLE IF EXISTS `project_endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint_group` (
  `endpoint_group_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_group_id`,`project_id`),
  CONSTRAINT `project_endpoint_group_ibfk_1` FOREIGN KEY (`endpoint_group_id`) REFERENCES `endpoint_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint_group`
--

LOCK TABLES `project_endpoint_group` WRITE;
/*!40000 ALTER TABLE `project_endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_option`
--

DROP TABLE IF EXISTS `project_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_option` (
  `project_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`project_id`,`option_id`),
  CONSTRAINT `project_option_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_option`
--

LOCK TABLES `project_option` WRITE;
/*!40000 ALTER TABLE `project_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_tag`
--

DROP TABLE IF EXISTS `project_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_tag` (
  `project_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`project_id`,`name`),
  UNIQUE KEY `project_id` (`project_id`,`name`),
  CONSTRAINT `project_tag_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_tag`
--

LOCK TABLES `project_tag` WRITE;
/*!40000 ALTER TABLE `project_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `parent_region_id` varchar(255) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` (`id`, `description`, `parent_region_id`, `extra`) VALUES ('regionOne','',NULL,'{}');
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registered_limit`
--

DROP TABLE IF EXISTS `registered_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `registered_limit` (
  `id` varchar(64) NOT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `default_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `registered_limit_id_key` (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `registered_limit`
--

LOCK TABLES `registered_limit` WRITE;
/*!40000 ALTER TABLE `registered_limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `registered_limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_token`
--

DROP TABLE IF EXISTS `request_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_token` (
  `id` varchar(64) NOT NULL,
  `request_secret` varchar(64) NOT NULL,
  `verifier` varchar(64) DEFAULT NULL,
  `authorizing_user_id` varchar(64) DEFAULT NULL,
  `requested_project_id` varchar(64) NOT NULL,
  `role_ids` text DEFAULT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_request_token_consumer_id` (`consumer_id`),
  CONSTRAINT `request_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_token`
--

LOCK TABLES `request_token` WRITE;
/*!40000 ALTER TABLE `request_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revocation_event`
--

DROP TABLE IF EXISTS `revocation_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revocation_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` varchar(64) DEFAULT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  `role_id` varchar(64) DEFAULT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `consumer_id` varchar(64) DEFAULT NULL,
  `access_token_id` varchar(64) DEFAULT NULL,
  `issued_before` datetime NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `revoked_at` datetime NOT NULL,
  `audit_id` varchar(32) DEFAULT NULL,
  `audit_chain_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_revocation_event_audit_id_issued_before` (`audit_id`,`issued_before`),
  KEY `ix_revocation_event_new_revoked_at` (`revoked_at`),
  KEY `ix_revocation_event_issued_before` (`issued_before`),
  KEY `ix_revocation_event_project_id_issued_before` (`project_id`,`issued_before`),
  KEY `ix_revocation_event_user_id_issued_before` (`user_id`,`issued_before`)
) ENGINE=InnoDB AUTO_INCREMENT=482 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revocation_event`
--

LOCK TABLES `revocation_event` WRITE;
/*!40000 ALTER TABLE `revocation_event` DISABLE KEYS */;
INSERT INTO `revocation_event` (`id`, `domain_id`, `project_id`, `user_id`, `role_id`, `trust_id`, `consumer_id`, `access_token_id`, `issued_before`, `expires_at`, `revoked_at`, `audit_id`, `audit_chain_id`) VALUES (1,NULL,NULL,'e49e89b1ef454a00b493279c99bc414e',NULL,NULL,NULL,NULL,'2025-11-29 07:48:59',NULL,'2025-11-29 07:48:59',NULL,NULL),(2,NULL,NULL,'2f8e3317f12b455ca9c51a9299f0d3c5',NULL,NULL,NULL,NULL,'2025-11-29 07:48:59',NULL,'2025-11-29 07:48:59',NULL,NULL),(3,NULL,'d722c2e11c3e45568fdbc5a3c72520a4',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:49:01',NULL,'2025-11-29 07:49:01',NULL,NULL),(4,NULL,'cad15282598049feb97de3e4f356602d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:49:02',NULL,'2025-11-29 07:49:02',NULL,NULL),(5,NULL,NULL,'72b1dc822e6f4c6e987b537b46fad89d',NULL,NULL,NULL,NULL,'2025-11-29 07:49:05',NULL,'2025-11-29 07:49:05',NULL,NULL),(6,NULL,NULL,'4d47853977b0496ebdf0a41221079e1e',NULL,NULL,NULL,NULL,'2025-11-29 07:49:06',NULL,'2025-11-29 07:49:06',NULL,NULL),(7,NULL,'5105842a08aa4df6ac5ae887e078469e',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:49:08',NULL,'2025-11-29 07:49:08',NULL,NULL),(8,NULL,'4c1c5613861e4ce999b5cce570423ea7',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:49:09',NULL,'2025-11-29 07:49:09',NULL,NULL),(9,NULL,NULL,'6cff25b3f0a14b15bf0530ce42e77d9f',NULL,NULL,NULL,NULL,'2025-11-29 07:49:58',NULL,'2025-11-29 07:49:58',NULL,NULL),(10,NULL,NULL,'66e7ff2e3386476f831f6618802e13ab',NULL,NULL,NULL,NULL,'2025-11-29 07:49:58',NULL,'2025-11-29 07:49:58',NULL,NULL),(11,NULL,'8bfd2dd46a074fe0808eaaa25f332bc1',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:50:01',NULL,'2025-11-29 07:50:01',NULL,NULL),(12,NULL,'1f12e768fee8474da3ae1ade631a0456',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:50:03',NULL,'2025-11-29 07:50:03',NULL,NULL),(13,NULL,NULL,'011c8fce41f44134a242bd9d62589524',NULL,NULL,NULL,NULL,'2025-11-29 07:50:08',NULL,'2025-11-29 07:50:08',NULL,NULL),(14,NULL,NULL,'754ec70247a14f7e91a4c3b753f9b02f',NULL,NULL,NULL,NULL,'2025-11-29 07:50:08',NULL,'2025-11-29 07:50:08',NULL,NULL),(15,NULL,'2608dc4e009044fda3e98a7614233386',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:50:13',NULL,'2025-11-29 07:50:13',NULL,NULL),(16,NULL,'7232a05ad33148b788f8d8aeb4fc05f1',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:50:14',NULL,'2025-11-29 07:50:14',NULL,NULL),(17,NULL,NULL,'29bdf3ad4f7a45b3a55470af215b9f5c',NULL,NULL,NULL,NULL,'2025-11-29 07:50:19',NULL,'2025-11-29 07:50:19',NULL,NULL),(18,NULL,NULL,'ad76d625085947ef9486fe1509f8b09d',NULL,NULL,NULL,NULL,'2025-11-29 07:50:20',NULL,'2025-11-29 07:50:20',NULL,NULL),(19,NULL,'8bc244ad55cd4942b945486f09e3e4b4',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:50:23',NULL,'2025-11-29 07:50:23',NULL,NULL),(20,NULL,'bc4b69e279d24a578c76e24516f0cac3',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:50:24',NULL,'2025-11-29 07:50:24',NULL,NULL),(21,NULL,NULL,'eefa213a2af1478da3afb24554d31a68',NULL,NULL,NULL,NULL,'2025-11-29 07:50:27',NULL,'2025-11-29 07:50:27',NULL,NULL),(22,NULL,NULL,'318c20e59f8748ad81a0405eedbff910',NULL,NULL,NULL,NULL,'2025-11-29 07:50:27',NULL,'2025-11-29 07:50:27',NULL,NULL),(23,NULL,'45047a1f79d14fe591aa7c30d4ab33f3',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:50:32',NULL,'2025-11-29 07:50:32',NULL,NULL),(24,NULL,'8bbb4c806a6941849b399c700c21864e',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:50:33',NULL,'2025-11-29 07:50:33',NULL,NULL),(25,NULL,NULL,'a70a34c4b9a243749a2bc234e384c389',NULL,NULL,NULL,NULL,'2025-11-29 07:51:00',NULL,'2025-11-29 07:51:00',NULL,NULL),(26,NULL,NULL,'50394ceae90042dabee2be68f1c23bb2',NULL,NULL,NULL,NULL,'2025-11-29 07:51:00',NULL,'2025-11-29 07:51:00',NULL,NULL),(27,NULL,'033bc3a89aae4e7db02ab7b819c8380c',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:51:16',NULL,'2025-11-29 07:51:16',NULL,NULL),(28,NULL,'4ec875eb6be146c58584e57e51696dcc',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:51:18',NULL,'2025-11-29 07:51:18',NULL,NULL),(29,NULL,NULL,'f40a70f33d244c668432b20fa4de23fb',NULL,NULL,NULL,NULL,'2025-11-29 07:51:28',NULL,'2025-11-29 07:51:28',NULL,NULL),(30,NULL,NULL,'01739124bee74c899af6384f8ec2d427',NULL,NULL,NULL,NULL,'2025-11-29 07:51:29',NULL,'2025-11-29 07:51:29',NULL,NULL),(31,NULL,NULL,'c869369e14164dee98e628dab4b39f03',NULL,NULL,NULL,NULL,'2025-11-29 07:51:29',NULL,'2025-11-29 07:51:29',NULL,NULL),(32,NULL,'3c7cd563ba394223a76bd2579800406c',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:51:30',NULL,'2025-11-29 07:51:30',NULL,NULL),(33,NULL,'a4a10a8371914722adf9604a040be9ba',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:51:32',NULL,'2025-11-29 07:51:32',NULL,NULL),(34,NULL,'c0a238b20ef74dd8bced1ace156147ec',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:51:34',NULL,'2025-11-29 07:51:34',NULL,NULL),(35,NULL,NULL,'beb94e54788b4e48a96141dd244b9c4e',NULL,NULL,NULL,NULL,'2025-11-29 07:51:40',NULL,'2025-11-29 07:51:40',NULL,NULL),(36,NULL,NULL,'36a693c3809f4cd7819098fcba825e82',NULL,NULL,NULL,NULL,'2025-11-29 07:51:40',NULL,'2025-11-29 07:51:40',NULL,NULL),(37,NULL,'b5125e984ede4b22a1e8b280807a34c2',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:51:44',NULL,'2025-11-29 07:51:44',NULL,NULL),(38,NULL,'d36c92a77ca745ed879f98caf5cb5de6',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:51:45',NULL,'2025-11-29 07:51:45',NULL,NULL),(39,NULL,NULL,'d57d713485e84d19a429533b570c4189',NULL,NULL,NULL,NULL,'2025-11-29 07:51:47',NULL,'2025-11-29 07:51:47',NULL,NULL),(40,NULL,NULL,'5751f09ba897458d983132170fd7facf',NULL,NULL,NULL,NULL,'2025-11-29 07:51:48',NULL,'2025-11-29 07:51:48',NULL,NULL),(41,NULL,'06acd02df57149e795d2be57787bb9ed',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:51:49',NULL,'2025-11-29 07:51:49',NULL,NULL),(42,NULL,'b31e58c9cb9a4895a6944d1696464d33',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:51:50',NULL,'2025-11-29 07:51:50',NULL,NULL),(43,NULL,NULL,'33ea9a355be349d3a74c8049a6a8d579',NULL,NULL,NULL,NULL,'2025-11-29 07:51:55',NULL,'2025-11-29 07:51:55',NULL,NULL),(44,NULL,NULL,'fc93a223551c4068bea3d47bcabb5021',NULL,NULL,NULL,NULL,'2025-11-29 07:51:56',NULL,'2025-11-29 07:51:56',NULL,NULL),(45,NULL,NULL,'24b6be0dcb9a47aaa2356f6bcab4ef1c',NULL,NULL,NULL,NULL,'2025-11-29 07:51:56',NULL,'2025-11-29 07:51:56',NULL,NULL),(46,NULL,NULL,'87697f1c359a420b87e5117546f93346',NULL,NULL,NULL,NULL,'2025-11-29 07:51:56',NULL,'2025-11-29 07:51:56',NULL,NULL),(47,NULL,NULL,'831a89e028cb45118603a13efca6e156',NULL,NULL,NULL,NULL,'2025-11-29 07:51:56',NULL,'2025-11-29 07:51:56',NULL,NULL),(48,NULL,NULL,'9f154daa451949a2bb29846c525238ff',NULL,NULL,NULL,NULL,'2025-11-29 07:51:56',NULL,'2025-11-29 07:51:56',NULL,NULL),(49,NULL,NULL,'87a8af2d3a924844ad3b9279035f79d6',NULL,NULL,NULL,NULL,'2025-11-29 07:51:56',NULL,'2025-11-29 07:51:56',NULL,NULL),(50,NULL,NULL,'c9ba83c37c7346e8813378b9eed7b3c2',NULL,NULL,NULL,NULL,'2025-11-29 07:51:57',NULL,'2025-11-29 07:51:57',NULL,NULL),(51,NULL,'fa00908198f941b5afb99ba561a959d1',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:51:58',NULL,'2025-11-29 07:51:58',NULL,NULL),(52,NULL,'9485228936ab4b039f3fdf1c45d3e502',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:51:58',NULL,'2025-11-29 07:51:58',NULL,NULL),(53,NULL,'77da7fce701a496f9ce35c7256cf9b2b',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:51:58',NULL,'2025-11-29 07:51:58',NULL,NULL),(54,NULL,'e3b6aa0314c4478c9bec34cb13079b54',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:51:59',NULL,'2025-11-29 07:51:59',NULL,NULL),(55,NULL,'e2d0cea1586c4a168b1727ff2ee000c9',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:51:59',NULL,'2025-11-29 07:51:59',NULL,NULL),(56,NULL,'f31ed2167dc24547ba450a8d4f514bc7',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:00',NULL,'2025-11-29 07:52:00',NULL,NULL),(57,NULL,'93de83185bb14386b1526c79641f9a31',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:00',NULL,'2025-11-29 07:52:00',NULL,NULL),(58,NULL,'5b72f712b1fb4a5abdc2c28d4049d17a',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:01',NULL,'2025-11-29 07:52:01',NULL,NULL),(59,NULL,NULL,'2bee4812040241728cc65165ad10a418',NULL,NULL,NULL,NULL,'2025-11-29 07:52:03',NULL,'2025-11-29 07:52:03',NULL,NULL),(60,NULL,NULL,'07405d1b2a8746978aedca4d59aa03e0',NULL,NULL,NULL,NULL,'2025-11-29 07:52:03',NULL,'2025-11-29 07:52:03',NULL,NULL),(61,NULL,NULL,'0a833fce31634bf6bd66ab3738839900',NULL,NULL,NULL,NULL,'2025-11-29 07:52:04',NULL,'2025-11-29 07:52:04',NULL,NULL),(62,NULL,NULL,'9a0e35b809584dccb57c675121339cf2',NULL,NULL,NULL,NULL,'2025-11-29 07:52:04',NULL,'2025-11-29 07:52:04',NULL,NULL),(63,NULL,NULL,'a28a95c3314744e683194f8f3fa92cda',NULL,NULL,NULL,NULL,'2025-11-29 07:52:04',NULL,'2025-11-29 07:52:04',NULL,NULL),(64,NULL,NULL,'2f9ca5520d204a479c06f770c390059d',NULL,NULL,NULL,NULL,'2025-11-29 07:52:04',NULL,'2025-11-29 07:52:04',NULL,NULL),(65,NULL,'3724272c890141998760756a7493a3c1',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:05',NULL,'2025-11-29 07:52:05',NULL,NULL),(66,NULL,'cc2441844719401c9c33284dfc3f804c',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:06',NULL,'2025-11-29 07:52:06',NULL,NULL),(67,NULL,'9ba48fad6b7943c59d92bc5eac58fa30',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:06',NULL,'2025-11-29 07:52:06',NULL,NULL),(68,NULL,NULL,'e24a38263a23458eb93c306435f64432',NULL,NULL,NULL,NULL,'2025-11-29 07:52:06',NULL,'2025-11-29 07:52:06',NULL,NULL),(69,NULL,NULL,'ae2eb1d8665c435991c20c197f60c9ac',NULL,NULL,NULL,NULL,'2025-11-29 07:52:06',NULL,'2025-11-29 07:52:06',NULL,NULL),(70,NULL,'85bca96095bd46858da93dbad2f2ccdc',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:07',NULL,'2025-11-29 07:52:07',NULL,NULL),(71,NULL,'f6d714475ce94005a414ce3ce84337a7',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:08',NULL,'2025-11-29 07:52:08',NULL,NULL),(72,NULL,'daa7ccd0b70c411facbc943072211506',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:08',NULL,'2025-11-29 07:52:08',NULL,NULL),(73,NULL,'00a6f0b79e894366b12d1461b02dae3e',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:08',NULL,'2025-11-29 07:52:08',NULL,NULL),(74,NULL,'ec8e0cadc345416fabf57829654a5423',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:10',NULL,'2025-11-29 07:52:10',NULL,NULL),(75,NULL,NULL,'eda56d33ea2c4112ad69610a5bb16d30',NULL,NULL,NULL,NULL,'2025-11-29 07:52:12',NULL,'2025-11-29 07:52:12',NULL,NULL),(76,NULL,NULL,'bc149ab00113445898c1faff8072d7f7',NULL,NULL,NULL,NULL,'2025-11-29 07:52:13',NULL,'2025-11-29 07:52:13',NULL,NULL),(77,NULL,NULL,'8168a671bb7f4f2790cab18e8ee5b25a',NULL,NULL,NULL,NULL,'2025-11-29 07:52:13',NULL,'2025-11-29 07:52:13',NULL,NULL),(78,NULL,NULL,'0b05db756a544bd9a1d7fba063a17492',NULL,NULL,NULL,NULL,'2025-11-29 07:52:13',NULL,'2025-11-29 07:52:13',NULL,NULL),(79,NULL,NULL,'1a1539250d904a3ba587d45b441dedf4',NULL,NULL,NULL,NULL,'2025-11-29 07:52:14',NULL,'2025-11-29 07:52:14',NULL,NULL),(80,NULL,NULL,'d78a4bb97bc7445487ed3f1a17789032',NULL,NULL,NULL,NULL,'2025-11-29 07:52:14',NULL,'2025-11-29 07:52:14',NULL,NULL),(81,NULL,'76aa4c5109de4ef399a20e55bbc0827a',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:15',NULL,'2025-11-29 07:52:15',NULL,NULL),(82,NULL,'1b2a7915e5df4d64a2b24425d0ed077b',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:15',NULL,'2025-11-29 07:52:15',NULL,NULL),(83,NULL,'b2057c4a68a24e7ebfe5d40744542c01',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:17',NULL,'2025-11-29 07:52:17',NULL,NULL),(84,NULL,'90d59e9fa44f426f9261ed5aa0e261d4',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:17',NULL,'2025-11-29 07:52:17',NULL,NULL),(85,NULL,'b682ed4d5c24432db1a3315ee293a4cc',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:17',NULL,'2025-11-29 07:52:17',NULL,NULL),(86,NULL,'2f0c6a21f01a4a5b9762f4f83b910cbd',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:18',NULL,'2025-11-29 07:52:18',NULL,NULL),(87,NULL,NULL,'ecdd2b53092c499d8828e2872044dc49',NULL,NULL,NULL,NULL,'2025-11-29 07:52:21',NULL,'2025-11-29 07:52:21',NULL,NULL),(88,NULL,NULL,'2f98cd6b562f49ae8a0dbb4d5ed759b1',NULL,NULL,NULL,NULL,'2025-11-29 07:52:21',NULL,'2025-11-29 07:52:21',NULL,NULL),(89,NULL,NULL,'7adcd35656374f598c6c0aae30e349cf',NULL,NULL,NULL,NULL,'2025-11-29 07:52:21',NULL,'2025-11-29 07:52:21',NULL,NULL),(90,NULL,NULL,'19ae5453353241f8b9d82446630aac69',NULL,NULL,NULL,NULL,'2025-11-29 07:52:21',NULL,'2025-11-29 07:52:21',NULL,NULL),(91,NULL,'d37a42452a11402a816e1f9094f4bcfd',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:22',NULL,'2025-11-29 07:52:22',NULL,NULL),(92,NULL,'0bd4200a18844b41a37c3247e9d61eb8',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:22',NULL,'2025-11-29 07:52:22',NULL,NULL),(93,NULL,'30cdcbdf282947279a72796d3d35e7e5',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:23',NULL,'2025-11-29 07:52:23',NULL,NULL),(94,NULL,NULL,'d725fd05803d47ed89ebcb4904307bfa',NULL,NULL,NULL,NULL,'2025-11-29 07:52:24',NULL,'2025-11-29 07:52:24',NULL,NULL),(95,NULL,NULL,'38f49ec067c641baaaf46a69d196d620',NULL,NULL,NULL,NULL,'2025-11-29 07:52:24',NULL,'2025-11-29 07:52:24',NULL,NULL),(96,NULL,'729cfb24cec343daa969b4af1367e1ec',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:25',NULL,'2025-11-29 07:52:25',NULL,NULL),(97,NULL,'7ffefb7ab4ff4284b3ed538f0dbc99c6',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:26',NULL,'2025-11-29 07:52:26',NULL,NULL),(98,NULL,'f89edbf7a93b4eda9699e57b60458653',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:27',NULL,'2025-11-29 07:52:27',NULL,NULL),(99,NULL,NULL,'33b2f54fe1654105bff692a58861d477',NULL,NULL,NULL,NULL,'2025-11-29 07:52:29',NULL,'2025-11-29 07:52:29',NULL,NULL),(100,NULL,NULL,'914deea586c64d7d8e996c559a4f9add',NULL,NULL,NULL,NULL,'2025-11-29 07:52:29',NULL,'2025-11-29 07:52:29',NULL,NULL),(101,NULL,'25beb4f9e78c4f0da4071842e1864c18',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:31',NULL,'2025-11-29 07:52:31',NULL,NULL),(102,NULL,NULL,'ebda5c096942417b9fbbd5f33c1bd5a1',NULL,NULL,NULL,NULL,'2025-11-29 07:52:31',NULL,'2025-11-29 07:52:31',NULL,NULL),(103,NULL,NULL,'c15dd3c16ac5463688ec5b6a780f2980',NULL,NULL,NULL,NULL,'2025-11-29 07:52:31',NULL,'2025-11-29 07:52:31',NULL,NULL),(104,NULL,NULL,'72fe4c54d6484b71a765202cf7868c45',NULL,NULL,NULL,NULL,'2025-11-29 07:52:32',NULL,'2025-11-29 07:52:32',NULL,NULL),(105,NULL,NULL,'e26063083f504f85b6530ae2ff243f3b',NULL,NULL,NULL,NULL,'2025-11-29 07:52:32',NULL,'2025-11-29 07:52:32',NULL,NULL),(106,NULL,'3af8afec2e29420aba391e896a9b3a52',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:32',NULL,'2025-11-29 07:52:32',NULL,NULL),(107,NULL,'811633596dd243aba8d21776a608a812',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:33',NULL,'2025-11-29 07:52:33',NULL,NULL),(108,NULL,'5580505afa604700aa86f1caf3bbe510',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:36',NULL,'2025-11-29 07:52:36',NULL,NULL),(109,NULL,'7562d9e87619403f970b99be81b6f26e',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:36',NULL,'2025-11-29 07:52:36',NULL,NULL),(110,NULL,'420384d966b64ebca8ee0628ce59fc06',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:37',NULL,'2025-11-29 07:52:37',NULL,NULL),(111,NULL,NULL,'9b0a73bf93424ec9a4e978a928ada0c3',NULL,NULL,NULL,NULL,'2025-11-29 07:52:39',NULL,'2025-11-29 07:52:39',NULL,NULL),(112,NULL,NULL,'a042b92edb48455ba17a714cefa2f3e6',NULL,NULL,NULL,NULL,'2025-11-29 07:52:39',NULL,'2025-11-29 07:52:39',NULL,NULL),(113,NULL,NULL,'13b30f4c61df48f8b99f74f0f9521c09',NULL,NULL,NULL,NULL,'2025-11-29 07:52:46',NULL,'2025-11-29 07:52:46',NULL,NULL),(114,NULL,NULL,'92319944dde243528ab04f8564d28b6e',NULL,NULL,NULL,NULL,'2025-11-29 07:52:46',NULL,'2025-11-29 07:52:46',NULL,NULL),(115,NULL,'199f6b2e93a64be4a4b2910151fc9986',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:47',NULL,'2025-11-29 07:52:47',NULL,NULL),(116,NULL,'88e5226afcce44e69b246f5b76428158',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:48',NULL,'2025-11-29 07:52:48',NULL,NULL),(117,NULL,NULL,'800f98e2c5c545128950a8d6a9164ccf',NULL,NULL,NULL,NULL,'2025-11-29 07:52:49',NULL,'2025-11-29 07:52:49',NULL,NULL),(118,NULL,'682083a3ee7f49c3b6dce25b814346ed',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:49',NULL,'2025-11-29 07:52:49',NULL,NULL),(119,NULL,NULL,'70d32e0e23514c5f85dfeadf1c929fde',NULL,NULL,NULL,NULL,'2025-11-29 07:52:49',NULL,'2025-11-29 07:52:49',NULL,NULL),(120,NULL,'290408d7386744309012f2eb4548a245',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:50',NULL,'2025-11-29 07:52:50',NULL,NULL),(121,NULL,'1a43bd4b5d024f0d84f7d723ff6d63bc',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:51',NULL,'2025-11-29 07:52:51',NULL,NULL),(122,NULL,'00a98ac6093f419d841bd8aab3cc57e1',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:52',NULL,'2025-11-29 07:52:52',NULL,NULL),(123,NULL,'4629a3f4e8424378abffe1418d7cf6f0',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:54',NULL,'2025-11-29 07:52:54',NULL,NULL),(124,NULL,NULL,'5b29371a911749a587d7b1e9e6aa3158',NULL,NULL,NULL,NULL,'2025-11-29 07:52:54',NULL,'2025-11-29 07:52:54',NULL,NULL),(125,NULL,NULL,'e6fd443319d9412799fc7b221805e1d3',NULL,NULL,NULL,NULL,'2025-11-29 07:52:55',NULL,'2025-11-29 07:52:55',NULL,NULL),(126,NULL,NULL,'9f695aca15b44d17890d64ecdd04cdb1',NULL,NULL,NULL,NULL,'2025-11-29 07:52:57',NULL,'2025-11-29 07:52:57',NULL,NULL),(127,NULL,'c870ccb932004e1cb4fb3091c05940a3',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:57',NULL,'2025-11-29 07:52:57',NULL,NULL),(128,NULL,'4ffa41eba2634fe6a7706fbec9c9b26a',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:57',NULL,'2025-11-29 07:52:57',NULL,NULL),(129,NULL,'1809b064a8d4452184221409087de917',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:59',NULL,'2025-11-29 07:52:59',NULL,NULL),(130,NULL,NULL,'7f79f8a0c7724a28a9fd61f516f679b1',NULL,NULL,NULL,NULL,'2025-11-29 07:53:00',NULL,'2025-11-29 07:53:00',NULL,NULL),(131,NULL,NULL,'bcfc4f1075d64eb0a25b79954f6a1705',NULL,NULL,NULL,NULL,'2025-11-29 07:53:00',NULL,'2025-11-29 07:53:00',NULL,NULL),(132,NULL,'ebfb6f31d55f4f6fab3d64d47339d3f2',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:53:02',NULL,'2025-11-29 07:53:02',NULL,NULL),(133,NULL,'31f94257e140446292a441dcd32c02b0',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:53:03',NULL,'2025-11-29 07:53:03',NULL,NULL),(134,NULL,NULL,'e60989e23cab4b719931dc44d92f6147',NULL,NULL,NULL,NULL,'2025-11-29 07:53:19',NULL,'2025-11-29 07:53:19',NULL,NULL),(135,NULL,NULL,'7f21c02bc11944769e080cb837716f57',NULL,NULL,NULL,NULL,'2025-11-29 07:53:19',NULL,'2025-11-29 07:53:19',NULL,NULL),(136,NULL,'2a6ec6b54c2b49e3aad32e5b49642d28',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:53:20',NULL,'2025-11-29 07:53:20',NULL,NULL),(137,NULL,'d1f7ca31303b42929184e52bbc0039cd',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:53:21',NULL,'2025-11-29 07:53:21',NULL,NULL),(138,NULL,NULL,'1b9c3a107fc44f18a57c8943c76bcaf8',NULL,NULL,NULL,NULL,'2025-11-29 07:53:41',NULL,'2025-11-29 07:53:41',NULL,NULL),(139,NULL,NULL,'5b08b0088e144bd98f47883bd24c8163',NULL,NULL,NULL,NULL,'2025-11-29 07:53:42',NULL,'2025-11-29 07:53:42',NULL,NULL),(140,NULL,'67c4298658e247c2807afaa880050cdc',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:53:44',NULL,'2025-11-29 07:53:44',NULL,NULL),(141,NULL,'58bf089eea784846944620e132a2e85d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:53:46',NULL,'2025-11-29 07:53:46',NULL,NULL),(142,NULL,NULL,'7f80aba0abfa403b80928e251377a7cd',NULL,NULL,NULL,NULL,'2025-11-29 07:54:08',NULL,'2025-11-29 07:54:08',NULL,NULL),(143,NULL,NULL,'32b1fa84778e45fab6eee84ff9a788fb',NULL,NULL,NULL,NULL,'2025-11-29 07:54:08',NULL,'2025-11-29 07:54:08',NULL,NULL),(144,NULL,'0d0324366b424af185a2192a315cebcc',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:54:09',NULL,'2025-11-29 07:54:09',NULL,NULL),(145,NULL,'ba323f7dc95a4f11911e6559a1b3c99e',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:54:10',NULL,'2025-11-29 07:54:10',NULL,NULL),(146,NULL,NULL,'0e126000d89d4373aa7c1902b1a4055f',NULL,NULL,NULL,NULL,'2025-11-29 07:54:14',NULL,'2025-11-29 07:54:14',NULL,NULL),(147,NULL,'c25546f7ac2945078f853d00be3ce8b8',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:54:16',NULL,'2025-11-29 07:54:16',NULL,NULL),(148,NULL,NULL,'2cc9de54e1764131aa2748a7f9a1df6d',NULL,NULL,NULL,NULL,'2025-11-29 07:55:45',NULL,'2025-11-29 07:55:45',NULL,NULL),(149,NULL,'c9c2bff0c0a24bebb1149177689b64d7',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:55:46',NULL,'2025-11-29 07:55:46',NULL,NULL),(150,NULL,NULL,'85f5548e01234fe4ae9b88e998e943f8',NULL,NULL,NULL,NULL,'2025-11-29 07:56:27',NULL,'2025-11-29 07:56:27',NULL,NULL),(151,NULL,NULL,'8756f93764c14f80808ae58acc73d953',NULL,NULL,NULL,NULL,'2025-11-29 07:56:27',NULL,'2025-11-29 07:56:27',NULL,NULL),(152,NULL,'ba14a9d547174e87a330644bcaa101ea',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:56:28',NULL,'2025-11-29 07:56:28',NULL,NULL),(153,NULL,NULL,'0b27bb620cf04ab58f835d6d1f802d0e',NULL,NULL,NULL,NULL,'2025-11-29 07:56:29',NULL,'2025-11-29 07:56:29',NULL,NULL),(154,NULL,'1963a097b7694450aa0d7c30b27b38ac',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:56:29',NULL,'2025-11-29 07:56:29',NULL,NULL),(155,NULL,'23813087e6bc4eb3b38cf8d39f082d19',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:56:31',NULL,'2025-11-29 07:56:31',NULL,NULL),(156,NULL,NULL,'b8f5b14bc98a47f29238140d1d3f1220',NULL,NULL,NULL,NULL,'2025-11-29 07:56:38',NULL,'2025-11-29 07:56:38',NULL,NULL),(157,NULL,NULL,'82f20a64d74c4e828a3bcc36c01b947f',NULL,NULL,NULL,NULL,'2025-11-29 07:56:39',NULL,'2025-11-29 07:56:39',NULL,NULL),(158,NULL,'d7ed55b45c19429eb46f57b6ebce2647',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:56:40',NULL,'2025-11-29 07:56:40',NULL,NULL),(159,NULL,'f91d373d1ef64146866ef08735a75efa',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:56:44',NULL,'2025-11-29 07:56:44',NULL,NULL),(160,NULL,NULL,'446b0f05699845e8bd9f7d59c787f671',NULL,NULL,NULL,NULL,'2025-11-29 07:56:56',NULL,'2025-11-29 07:56:56',NULL,NULL),(161,NULL,NULL,'e6de179afa044479a7d74c611f9b5398',NULL,NULL,NULL,NULL,'2025-11-29 07:56:56',NULL,'2025-11-29 07:56:56',NULL,NULL),(162,NULL,'1f48e629446148199d44b34243b98b8a',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:56:59',NULL,'2025-11-29 07:56:59',NULL,NULL),(163,NULL,'0fa19cbd18c2485a99a4bcf4d81ee542',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:00',NULL,'2025-11-29 07:57:00',NULL,NULL),(164,NULL,NULL,'0fc8d55b9ff846aab4dcd41976ff6b75',NULL,NULL,NULL,NULL,'2025-11-29 07:57:04',NULL,'2025-11-29 07:57:04',NULL,NULL),(165,NULL,NULL,'1613633143c8456da9cec482e9390480',NULL,NULL,NULL,NULL,'2025-11-29 07:57:04',NULL,'2025-11-29 07:57:04',NULL,NULL),(166,NULL,'09af0826e3144418a1efe441c7f392a6',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:06',NULL,'2025-11-29 07:57:06',NULL,NULL),(167,NULL,'07a3fc2952c6446aa5169e1a551f3735',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:07',NULL,'2025-11-29 07:57:07',NULL,NULL),(168,NULL,NULL,'0d89fa00c6634218a57a0de8eede1b0b',NULL,NULL,NULL,NULL,'2025-11-29 07:57:08',NULL,'2025-11-29 07:57:08',NULL,NULL),(169,NULL,'3643d322c9e64d06bf85f3d338e9c1d1',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:09',NULL,'2025-11-29 07:57:09',NULL,NULL),(170,NULL,NULL,'3341a2383d20408e98bbfc6eb079c9ae',NULL,NULL,NULL,NULL,'2025-11-29 07:57:11',NULL,'2025-11-29 07:57:11',NULL,NULL),(171,NULL,NULL,'4ef3255f9437422ab39246e04da5a356',NULL,NULL,NULL,NULL,'2025-11-29 07:57:11',NULL,'2025-11-29 07:57:11',NULL,NULL),(172,NULL,NULL,'0486787ea22d467493df98a0aaa7ae3f',NULL,NULL,NULL,NULL,'2025-11-29 07:57:13',NULL,'2025-11-29 07:57:13',NULL,NULL),(173,NULL,'d29567d68c7b49b1a74587d24862335f',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:14',NULL,'2025-11-29 07:57:14',NULL,NULL),(174,NULL,'6d130dc235f6458685d4e3569b44bff4',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:14',NULL,'2025-11-29 07:57:14',NULL,NULL),(175,NULL,'a3f1d0a6087d46d98136ddfd9b32bffc',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:15',NULL,'2025-11-29 07:57:15',NULL,NULL),(176,NULL,NULL,'e685df98cbea484eaceb61d35d3f2daa',NULL,NULL,NULL,NULL,'2025-11-29 07:57:18',NULL,'2025-11-29 07:57:18',NULL,NULL),(177,NULL,'253a98dacce34426b14433f0ccd018ed',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:19',NULL,'2025-11-29 07:57:19',NULL,NULL),(178,NULL,NULL,'8d70080854cd432eb4d60eaa335e9658',NULL,NULL,NULL,NULL,'2025-11-29 07:57:20',NULL,'2025-11-29 07:57:20',NULL,NULL),(179,NULL,NULL,'9ec8be824a7548a09861fa5edc71554b',NULL,NULL,NULL,NULL,'2025-11-29 07:57:20',NULL,'2025-11-29 07:57:20',NULL,NULL),(180,NULL,NULL,'b9477e58adb049a2a893b2d9c74e8651',NULL,NULL,NULL,NULL,'2025-11-29 07:57:22',NULL,'2025-11-29 07:57:22',NULL,NULL),(181,NULL,'5b3a09c5b05a4c6183d2a04e9c1cdb60',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:22',NULL,'2025-11-29 07:57:22',NULL,NULL),(182,NULL,'a20e261a6e5247c5a6a89f85be36c69c',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:24',NULL,'2025-11-29 07:57:24',NULL,NULL),(183,NULL,'5d4b9daf873a4cba8663953435a6a357',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:25',NULL,'2025-11-29 07:57:25',NULL,NULL),(184,NULL,NULL,'854124d19b1b499796668cb7fc391542',NULL,NULL,NULL,NULL,'2025-11-29 07:57:29',NULL,'2025-11-29 07:57:29',NULL,NULL),(185,NULL,NULL,'e3ec4bdba78c459589e595ae688c3b38',NULL,NULL,NULL,NULL,'2025-11-29 07:57:29',NULL,'2025-11-29 07:57:29',NULL,NULL),(186,NULL,NULL,'0227e9c8ea8e417785e3b7765423f791',NULL,NULL,NULL,NULL,'2025-11-29 07:57:29',NULL,'2025-11-29 07:57:29',NULL,NULL),(187,NULL,'8f0a6cb03edf4643b06e4cd7e4cf8df0',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:30',NULL,'2025-11-29 07:57:30',NULL,NULL),(188,NULL,'9c12158e1b624f2bacd9be005c8716e9',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:30',NULL,'2025-11-29 07:57:30',NULL,NULL),(189,NULL,'33f93dfa47c54f44a1a01dfe30717ce6',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:32',NULL,'2025-11-29 07:57:32',NULL,NULL),(190,NULL,NULL,'6b290e8dce5c4f5fa6f9b393a68aff3e',NULL,NULL,NULL,NULL,'2025-11-29 07:57:34',NULL,'2025-11-29 07:57:34',NULL,NULL),(191,NULL,'48ae36cd5c4d48ea8dad86a11af7f266',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:35',NULL,'2025-11-29 07:57:35',NULL,NULL),(192,NULL,NULL,'e29d804537f847639cff711296d0f9af',NULL,NULL,NULL,NULL,'2025-11-29 07:57:36',NULL,'2025-11-29 07:57:36',NULL,NULL),(193,NULL,NULL,'559c0358c6194a2caecf8e8432c7d08c',NULL,NULL,NULL,NULL,'2025-11-29 07:57:36',NULL,'2025-11-29 07:57:36',NULL,NULL),(194,NULL,'8b2874bf321a43ad9fd9ef7319b0633d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:38',NULL,'2025-11-29 07:57:38',NULL,NULL),(195,NULL,'c3bfe22e97d94f8c806943da11cb345b',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:39',NULL,'2025-11-29 07:57:39',NULL,NULL),(196,NULL,NULL,'9688c69b7cf74866ae2d73c7c7ba8fc7',NULL,NULL,NULL,NULL,'2025-11-29 07:57:41',NULL,'2025-11-29 07:57:41',NULL,NULL),(197,NULL,'2a792621be26430ca47b0cf53310db99',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:43',NULL,'2025-11-29 07:57:43',NULL,NULL),(198,NULL,NULL,'7ac104bfbe684199868a0ffe8e1f4f84',NULL,NULL,NULL,NULL,'2025-11-29 07:57:46',NULL,'2025-11-29 07:57:46',NULL,NULL),(199,NULL,'e0cc2e7774f34617bea12f2c9eabb827',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:46',NULL,'2025-11-29 07:57:46',NULL,NULL),(200,NULL,NULL,'6de7e830a65043438630e49f88f7afa7',NULL,NULL,NULL,NULL,'2025-11-29 07:57:46',NULL,'2025-11-29 07:57:46',NULL,NULL),(201,NULL,NULL,'8e026f86bbd54e6cae1ff4155e1f6623',NULL,NULL,NULL,NULL,'2025-11-29 07:57:46',NULL,'2025-11-29 07:57:46',NULL,NULL),(202,NULL,'faf2691b1e6d44b2b4e9bdfb89ec402c',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:47',NULL,'2025-11-29 07:57:47',NULL,NULL),(203,NULL,'cec309e2227a4efcb9a2ce76c959d0ed',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:49',NULL,'2025-11-29 07:57:49',NULL,NULL),(204,NULL,NULL,'8f9d9787ce164ac081f2eb888d78c6e1',NULL,NULL,NULL,NULL,'2025-11-29 07:57:54',NULL,'2025-11-29 07:57:54',NULL,NULL),(205,NULL,'0be5d7f8f5c548c98ecfa63646e4e2c1',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:54',NULL,'2025-11-29 07:57:54',NULL,NULL),(206,NULL,NULL,'bc50ee2c827b473f8b334b981836d2cc',NULL,NULL,NULL,NULL,'2025-11-29 07:57:54',NULL,'2025-11-29 07:57:54',NULL,NULL),(207,NULL,NULL,'cfa73ebb9e3b4189a06c2b716ef66300',NULL,NULL,NULL,NULL,'2025-11-29 07:57:55',NULL,'2025-11-29 07:57:55',NULL,NULL),(208,NULL,'8fd4ea75572449c1a1e39e3f6a0cc0f2',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:57',NULL,'2025-11-29 07:57:57',NULL,NULL),(209,NULL,'9a3781f31aa046db906af4f92fa4f436',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:59',NULL,'2025-11-29 07:57:59',NULL,NULL),(210,NULL,NULL,'e9bb5c912ca1471c895b844b43ac4831',NULL,NULL,NULL,NULL,'2025-11-29 07:59:28',NULL,'2025-11-29 07:59:28',NULL,NULL),(211,NULL,'d932eef5d5104a79bd9aec0bbc489384',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:59:30',NULL,'2025-11-29 07:59:30',NULL,NULL),(212,NULL,NULL,'07c7f32f7d494f29b99afe2b074d0f68',NULL,NULL,NULL,NULL,'2025-11-29 07:59:31',NULL,'2025-11-29 07:59:31',NULL,NULL),(213,NULL,NULL,'ce1b4c1dee274dedbc5243fe8e7c3982',NULL,NULL,NULL,NULL,'2025-11-29 07:59:31',NULL,'2025-11-29 07:59:31',NULL,NULL),(214,NULL,'4004f4fd97dd4d0e8e83dd715ffb8e9c',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:59:34',NULL,'2025-11-29 07:59:34',NULL,NULL),(215,NULL,'fefd450a22f6433fbea03a8da1e1492d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:59:35',NULL,'2025-11-29 07:59:35',NULL,NULL),(216,NULL,NULL,'83cbfda08549451c8499d3e9bfd0d2ff',NULL,NULL,NULL,NULL,'2025-11-29 07:59:50',NULL,'2025-11-29 07:59:50',NULL,NULL),(217,NULL,NULL,'3a7601c8276948e98a343db1dddbe667',NULL,NULL,NULL,NULL,'2025-11-29 07:59:51',NULL,'2025-11-29 07:59:51',NULL,NULL),(218,NULL,'a34b88ea36a3473ebf4b27de006d2277',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:59:56',NULL,'2025-11-29 07:59:56',NULL,NULL),(219,NULL,'8f436e4e1ee14fa09904e250330051d0',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:59:58',NULL,'2025-11-29 07:59:58',NULL,NULL),(220,NULL,NULL,'b9b944588e8943c5895ee1a898de393c',NULL,NULL,NULL,NULL,'2025-11-29 08:00:01',NULL,'2025-11-29 08:00:01',NULL,NULL),(221,NULL,'59ac24037fa74ffea33e0c1806437e4f',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:00:05',NULL,'2025-11-29 08:00:05',NULL,NULL),(222,NULL,NULL,'d26800adb7534fb6b85bcefeb114a77d',NULL,NULL,NULL,NULL,'2025-11-29 08:00:38',NULL,'2025-11-29 08:00:38',NULL,NULL),(223,NULL,'8c3ebd49ecd442d8a0b6da0eeb15abcc',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:00:39',NULL,'2025-11-29 08:00:39',NULL,NULL),(224,NULL,NULL,'067b8ce2083347108eafd98743f82209',NULL,NULL,NULL,NULL,'2025-11-29 08:00:41',NULL,'2025-11-29 08:00:41',NULL,NULL),(225,NULL,'fd485df2c44741338e45f9fa1527d678',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:00:42',NULL,'2025-11-29 08:00:42',NULL,NULL),(226,NULL,NULL,'51ae07f600c545c0b4c7fae00657ea40',NULL,NULL,NULL,NULL,'2025-11-29 08:01:05',NULL,'2025-11-29 08:01:05',NULL,NULL),(227,NULL,NULL,'e9c5a793e885447b8b387d31e35002a5',NULL,NULL,NULL,NULL,'2025-11-29 08:01:05',NULL,'2025-11-29 08:01:05',NULL,NULL),(228,NULL,'f32c5413dfce491a96f52ef642d44d10',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:01:06',NULL,'2025-11-29 08:01:06',NULL,NULL),(229,NULL,'6717732f9fa242b181f58881b03d246f',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:01:09',NULL,'2025-11-29 08:01:09',NULL,NULL),(230,NULL,NULL,'5763bb0d81ff46d49c13fd394a7e357b',NULL,NULL,NULL,NULL,'2025-11-29 08:01:14',NULL,'2025-11-29 08:01:14',NULL,NULL),(231,NULL,NULL,'0467d449c71b4c4892d2ff2ee78a13f6',NULL,NULL,NULL,NULL,'2025-11-29 08:01:14',NULL,'2025-11-29 08:01:14',NULL,NULL),(232,NULL,'6de1849ee88340cc997ff1e503caafdc',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:01:17',NULL,'2025-11-29 08:01:17',NULL,NULL),(233,NULL,'0cdf3d54d2674f76a99c0f2422244661',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:01:19',NULL,'2025-11-29 08:01:19',NULL,NULL),(234,NULL,NULL,'33b1115167e8417c8ed3c2687c7b1865',NULL,NULL,NULL,NULL,'2025-11-29 08:01:33',NULL,'2025-11-29 08:01:33',NULL,NULL),(235,NULL,NULL,'76ad9b9b0d9b4f82a0c0eca62c593865',NULL,NULL,NULL,NULL,'2025-11-29 08:01:33',NULL,'2025-11-29 08:01:33',NULL,NULL),(236,NULL,'40644acfe9654688b1a09ebe3a465a62',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:01:35',NULL,'2025-11-29 08:01:35',NULL,NULL),(237,NULL,'6df32ad0e6794a23bf3b7268328e642b',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:01:36',NULL,'2025-11-29 08:01:36',NULL,NULL),(238,NULL,NULL,'b956671bad8a4a0b99469a9d0258a2bc',NULL,NULL,NULL,NULL,'2025-11-29 08:01:51',NULL,'2025-11-29 08:01:51',NULL,NULL),(239,NULL,'86064cd197e14fa8a17d2a0d9547af3e',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:01:52',NULL,'2025-11-29 08:01:52',NULL,NULL),(240,NULL,NULL,'b37d614815064829b8372abbdbe8b3c4',NULL,NULL,NULL,NULL,'2025-11-29 08:02:02',NULL,'2025-11-29 08:02:02',NULL,NULL),(241,NULL,NULL,'81c93a09c1b0475aac91299a1bae36c9',NULL,NULL,NULL,NULL,'2025-11-29 08:02:02',NULL,'2025-11-29 08:02:02',NULL,NULL),(242,NULL,NULL,'a0ee8fbcfa2b43a296188a59d33ca391',NULL,NULL,NULL,NULL,'2025-11-29 08:02:02',NULL,'2025-11-29 08:02:02',NULL,NULL),(243,NULL,'a3c8b78b8a34400682bf8bbef740a22c',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:02:03',NULL,'2025-11-29 08:02:03',NULL,NULL),(244,NULL,'132abeb6a490432292d29a40ab72f4b0',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:02:05',NULL,'2025-11-29 08:02:05',NULL,NULL),(245,NULL,'df358e17a9d545dcbdf27798cc165c96',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:02:08',NULL,'2025-11-29 08:02:08',NULL,NULL),(246,NULL,NULL,'3b275dc858bd4328808c27dbaf172f8c',NULL,NULL,NULL,NULL,'2025-11-29 08:02:46',NULL,'2025-11-29 08:02:46',NULL,NULL),(247,NULL,NULL,'f15eca173e2f484984c0d76f457b519a',NULL,NULL,NULL,NULL,'2025-11-29 08:02:46',NULL,'2025-11-29 08:02:46',NULL,NULL),(248,NULL,NULL,'4cccdc247f2342f9bbd38c1238437de1',NULL,NULL,NULL,NULL,'2025-11-29 08:02:47',NULL,'2025-11-29 08:02:47',NULL,NULL),(249,NULL,NULL,'f022fd6fd66e4e6da2cda8af4797e5e1',NULL,NULL,NULL,NULL,'2025-11-29 08:02:49',NULL,'2025-11-29 08:02:49',NULL,NULL),(250,NULL,'6e169525d3b345b588b4fcf946bacf81',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:02:49',NULL,'2025-11-29 08:02:49',NULL,NULL),(251,NULL,'ca9f1fc46c6c4e70bf251dbc40d4d95a',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:02:50',NULL,'2025-11-29 08:02:50',NULL,NULL),(252,NULL,'acf5114526e34421a66a8ee35227cd24',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:02:51',NULL,'2025-11-29 08:02:51',NULL,NULL),(253,NULL,'9dcb1ac8a85e499885d60a274f723258',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:02:52',NULL,'2025-11-29 08:02:52',NULL,NULL),(254,NULL,NULL,'93e99151115f454c84ebdae692c05837',NULL,NULL,NULL,NULL,'2025-11-29 08:03:14',NULL,'2025-11-29 08:03:14',NULL,NULL),(255,NULL,'8a7f945c49d546279a638fad8d9770ba',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:03:14',NULL,'2025-11-29 08:03:14',NULL,NULL),(256,NULL,NULL,'ba1b423b724a47f692a3d9cbf91860d7',NULL,NULL,NULL,NULL,'2025-11-29 08:03:19',NULL,'2025-11-29 08:03:19',NULL,NULL),(257,NULL,NULL,'ca4de5e31f584c7596b16b6c3f8e433a',NULL,NULL,NULL,NULL,'2025-11-29 08:03:19',NULL,'2025-11-29 08:03:19',NULL,NULL),(258,NULL,'afaf65dfeab546ee991af0438784b8a3',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:03:19',NULL,'2025-11-29 08:03:19',NULL,NULL),(259,NULL,'523d57f8c7ee4b7194f7f0fa57d4d3e9',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:03:20',NULL,'2025-11-29 08:03:20',NULL,NULL),(260,NULL,NULL,'516e17df54a041ee8101fb121e5d5740',NULL,NULL,NULL,NULL,'2025-11-29 08:03:33',NULL,'2025-11-29 08:03:33',NULL,NULL),(261,NULL,NULL,'ca7ab7dbe9a7409e8024d14f444f4914',NULL,NULL,NULL,NULL,'2025-11-29 08:03:33',NULL,'2025-11-29 08:03:33',NULL,NULL),(262,NULL,NULL,'1725cd9cd6474f59b213ec05ccd5c878',NULL,NULL,NULL,NULL,'2025-11-29 08:03:35',NULL,'2025-11-29 08:03:35',NULL,NULL),(263,NULL,'9dce6bedcb494f548ade2886837f6193',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:03:35',NULL,'2025-11-29 08:03:35',NULL,NULL),(264,NULL,'e901587fd87545d2b2c4a7872915b1fb',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:03:36',NULL,'2025-11-29 08:03:36',NULL,NULL),(265,NULL,'392223643d6d4b8b96eaa27c4a0d41cc',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:03:39',NULL,'2025-11-29 08:03:39',NULL,NULL),(266,NULL,NULL,'2a2fffb52449476eb517866150344c1b',NULL,NULL,NULL,NULL,'2025-11-29 08:03:41',NULL,'2025-11-29 08:03:41',NULL,NULL),(267,NULL,'9d6b98d45e324cc7b3097900bad0b511',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:03:43',NULL,'2025-11-29 08:03:43',NULL,NULL),(268,NULL,NULL,'1b85c3911b7c4e558779a15904c3ce58',NULL,NULL,NULL,NULL,'2025-11-29 08:04:41',NULL,'2025-11-29 08:04:41',NULL,NULL),(269,NULL,NULL,'3177c19feaed444baabfeba47f928566',NULL,NULL,NULL,NULL,'2025-11-29 08:04:41',NULL,'2025-11-29 08:04:41',NULL,NULL),(270,NULL,'07897dbad9f74d4e954edcb86d3634f2',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:04:42',NULL,'2025-11-29 08:04:42',NULL,NULL),(271,NULL,'4fe9ef6d6ed6441e87cf5bdb5d40af4b',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:04:43',NULL,'2025-11-29 08:04:43',NULL,NULL),(272,NULL,NULL,'e34525c38d50445e9771f1b8e18bc428',NULL,NULL,NULL,NULL,'2025-11-29 08:04:50',NULL,'2025-11-29 08:04:50',NULL,NULL),(273,NULL,'1a7ab40578b84f6aa0f4d2225a36bf9e',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:04:52',NULL,'2025-11-29 08:04:52',NULL,NULL),(274,NULL,NULL,'d62d80d75d7a4dfebaff77f7b70a5b29',NULL,NULL,NULL,NULL,'2025-11-29 08:04:55',NULL,'2025-11-29 08:04:55',NULL,NULL),(275,NULL,'d5ca20d2071c4de0a0735cc81d33a2c0',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:04:57',NULL,'2025-11-29 08:04:57',NULL,NULL),(276,NULL,NULL,'0d18eb0f3c884b668ff601577f521732',NULL,NULL,NULL,NULL,'2025-11-29 08:05:26',NULL,'2025-11-29 08:05:26',NULL,NULL),(277,NULL,'f2e57cf385dc4eaeb942a22a68a98f67',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:05:27',NULL,'2025-11-29 08:05:27',NULL,NULL),(278,NULL,NULL,'dc44b9aeabb442f582688b672dd724f3',NULL,NULL,NULL,NULL,'2025-11-29 08:06:12',NULL,'2025-11-29 08:06:12',NULL,NULL),(279,NULL,NULL,'82a66062264749d58d7659df1ac8e620',NULL,NULL,NULL,NULL,'2025-11-29 08:06:12',NULL,'2025-11-29 08:06:12',NULL,NULL),(280,NULL,'761fb1f5e11e49f0957cb4ed97553c31',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:06:13',NULL,'2025-11-29 08:06:13',NULL,NULL),(281,NULL,'49ee945ea42e47ad9f070078a4d5179b',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:06:14',NULL,'2025-11-29 08:06:14',NULL,NULL),(282,NULL,NULL,'7f7f42bfe6ee49b088f30c9eb496e288',NULL,NULL,NULL,NULL,'2025-11-29 08:07:07',NULL,'2025-11-29 08:07:07',NULL,NULL),(283,NULL,'c1b873d94187455ea17d369aa54754b3',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:07:07',NULL,'2025-11-29 08:07:07',NULL,NULL),(284,NULL,NULL,'9ee7a93f60394fd9b004c90c25ff5fc1',NULL,NULL,NULL,NULL,'2025-11-29 08:07:07',NULL,'2025-11-29 08:07:07',NULL,NULL),(285,NULL,NULL,'fddc5f5801764ee19d5253e2cab34df3',NULL,NULL,NULL,NULL,'2025-11-29 08:07:08',NULL,'2025-11-29 08:07:08',NULL,NULL),(286,NULL,'9e02874a2dc44489adba1420baa460f2',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:07:08',NULL,'2025-11-29 08:07:08',NULL,NULL),(287,NULL,'638fd52fccf14f16b56d0860553063f3',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:07:09',NULL,'2025-11-29 08:07:09',NULL,NULL),(288,NULL,NULL,'f8d48b0cbd3b4441a07cb93bc1460b93',NULL,NULL,NULL,NULL,'2025-11-29 08:07:29',NULL,'2025-11-29 08:07:29',NULL,NULL),(289,NULL,'52ae8510935245e3b8e3bd3930932fa0',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:07:32',NULL,'2025-11-29 08:07:32',NULL,NULL),(290,NULL,NULL,'d0a358b2256f49b085b6e0d27911e743',NULL,NULL,NULL,NULL,'2025-11-29 08:08:10',NULL,'2025-11-29 08:08:10',NULL,NULL),(291,NULL,'02545fd3735d4977afe5612632ee4832',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:08:11',NULL,'2025-11-29 08:08:11',NULL,NULL),(292,NULL,NULL,'08e32559f8cf4ab9a4e9dba945f68401',NULL,NULL,NULL,NULL,'2025-11-29 08:08:13',NULL,'2025-11-29 08:08:13',NULL,NULL),(293,NULL,'d72e84f500a848a0a6be5d3719fababc',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:08:15',NULL,'2025-11-29 08:08:15',NULL,NULL),(294,NULL,NULL,'104aea18c5154615b602f032bdb49681',NULL,NULL,NULL,NULL,'2025-11-29 08:08:16',NULL,'2025-11-29 08:08:16',NULL,NULL),(295,NULL,'90c23935e0214785a9dc5061b91cf29c',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:08:17',NULL,'2025-11-29 08:08:17',NULL,NULL),(296,NULL,NULL,'a1e2ed0f888d443a8f98ac647af0d492',NULL,NULL,NULL,NULL,'2025-11-29 08:08:19',NULL,'2025-11-29 08:08:19',NULL,NULL),(297,NULL,'b8431ab2a7fc4b4f8a538ab755a8704b',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:08:20',NULL,'2025-11-29 08:08:20',NULL,NULL),(298,NULL,NULL,'4d0fdc99d9764df9a0868625cd14f49a',NULL,NULL,NULL,NULL,'2025-11-29 08:08:35',NULL,'2025-11-29 08:08:35',NULL,NULL),(299,NULL,'b6b2c950ad924f9c9d1a44696045a508',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:08:37',NULL,'2025-11-29 08:08:37',NULL,NULL),(300,NULL,NULL,'846dafbd619c4153a209795e55202c49',NULL,NULL,NULL,NULL,'2025-11-29 08:08:53',NULL,'2025-11-29 08:08:53',NULL,NULL),(301,NULL,'bfed6d2f9d8c429bbd81417ea0d86674',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:08:54',NULL,'2025-11-29 08:08:54',NULL,NULL),(302,NULL,NULL,'1a010a95085342c5ae9a02f15b334fad',NULL,NULL,NULL,NULL,'2025-11-29 08:08:58',NULL,'2025-11-29 08:08:58',NULL,NULL),(303,NULL,'5c57433fd3834430904b1908f24f3f2f',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:09:00',NULL,'2025-11-29 08:09:00',NULL,NULL),(304,NULL,NULL,'623e430e64a04e20a3224da48323ec68',NULL,NULL,NULL,NULL,'2025-11-29 08:09:57',NULL,'2025-11-29 08:09:57',NULL,NULL),(305,NULL,'3915075f6af64d22aacc0d811789b57a',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:09:59',NULL,'2025-11-29 08:09:59',NULL,NULL),(306,NULL,NULL,'aa730ff43688414fbafb9fb85e566a1a',NULL,NULL,NULL,NULL,'2025-11-29 08:11:08',NULL,'2025-11-29 08:11:08',NULL,NULL),(307,NULL,'01e87a17aae64e93bdb507d58a515a3f',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:11:09',NULL,'2025-11-29 08:11:09',NULL,NULL),(308,NULL,NULL,'6ef481e9e8e0440c91abe11aee229780',NULL,NULL,NULL,NULL,'2025-11-29 08:11:29',NULL,'2025-11-29 08:11:29',NULL,NULL),(309,NULL,NULL,'710352fb9c7342efab89ef0c90618a3e',NULL,NULL,NULL,NULL,'2025-11-29 08:11:29',NULL,'2025-11-29 08:11:29',NULL,NULL),(310,NULL,'28c3d09b9e21417cb7bc44b8552f1b81',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:11:34',NULL,'2025-11-29 08:11:34',NULL,NULL),(311,NULL,'b10d15e216984b7aa8f2194abbb49f97',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:11:38',NULL,'2025-11-29 08:11:38',NULL,NULL),(312,NULL,NULL,'9ab0114aca6149af994da2b9052c1368',NULL,NULL,NULL,NULL,'2025-11-29 08:12:40',NULL,'2025-11-29 08:12:40',NULL,NULL),(313,NULL,'8384e5887c0948f5876c019d50057152',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:12:42',NULL,'2025-11-29 08:12:42',NULL,NULL),(314,NULL,NULL,'247a4abb59cd459fa66a891e998e548c',NULL,NULL,NULL,NULL,'2025-11-29 08:13:03',NULL,'2025-11-29 08:13:03',NULL,NULL),(315,NULL,'c5e5a2f42dc64b7cb0a22b666f160b1d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:13:05',NULL,'2025-11-29 08:13:05',NULL,NULL),(316,NULL,NULL,'8c106fd8f8d448ebb9235a2cec9752a0',NULL,NULL,NULL,NULL,'2025-11-29 08:13:24',NULL,'2025-11-29 08:13:24',NULL,NULL),(317,NULL,NULL,'b95b3e841be1420c99ee0a04dd0840f1',NULL,NULL,NULL,NULL,'2025-11-29 08:13:24',NULL,'2025-11-29 08:13:24',NULL,NULL),(318,NULL,'ff7c805d4242453aa2148a247956391d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:13:25',NULL,'2025-11-29 08:13:25',NULL,NULL),(319,NULL,'a79b4d10530a4e1b93fd74acae457024',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:13:25',NULL,'2025-11-29 08:13:25',NULL,NULL),(320,NULL,NULL,'5dc4cc7160064e9e82d9d21ebfd05d2f',NULL,NULL,NULL,NULL,'2025-11-29 08:14:23',NULL,'2025-11-29 08:14:23',NULL,NULL),(321,NULL,'c89019b6f53547259a833925c95b09c1',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:14:26',NULL,'2025-11-29 08:14:26',NULL,NULL),(322,NULL,NULL,'dd2122dcf7a74b5592b6f6fc97c6bc1d',NULL,NULL,NULL,NULL,'2025-11-29 08:14:31',NULL,'2025-11-29 08:14:31',NULL,NULL),(323,NULL,'a47585e78989482c8551e3199c323bfd',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:14:34',NULL,'2025-11-29 08:14:34',NULL,NULL),(324,NULL,NULL,'05e59f4debd946ad9b7a4bac0e968bc6',NULL,NULL,NULL,NULL,'2025-11-29 08:14:52',NULL,'2025-11-29 08:14:52',NULL,NULL),(325,NULL,'17c0ff0fdeac43fc8fa0d7bedad67c34',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:14:53',NULL,'2025-11-29 08:14:53',NULL,NULL),(326,NULL,NULL,'90573489491c4659ba4a8ccbd6b896a7',NULL,NULL,NULL,NULL,'2025-11-29 08:15:07',NULL,'2025-11-29 08:15:07',NULL,NULL),(327,NULL,NULL,'454ab943cc834ddb96f6674b15aef470',NULL,NULL,NULL,NULL,'2025-11-29 08:15:07',NULL,'2025-11-29 08:15:07',NULL,NULL),(328,NULL,'b5f1f0d72cd0427a8cda48db244caf6c',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:15:08',NULL,'2025-11-29 08:15:08',NULL,NULL),(329,NULL,'7c246bdfc56c4ab28e6f5890b083100b',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:15:09',NULL,'2025-11-29 08:15:09',NULL,NULL),(330,NULL,NULL,'0bd9df09f1324e3f9dba099f03ffe1c6',NULL,NULL,NULL,NULL,'2025-11-29 08:16:11',NULL,'2025-11-29 08:16:11',NULL,NULL),(331,NULL,'647c3591c2b940409293763c6c83e58c',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:16:12',NULL,'2025-11-29 08:16:12',NULL,NULL),(332,NULL,NULL,'f4c89c9953854ecf96a802dc6055db9d',NULL,NULL,NULL,NULL,'2025-11-29 08:16:39',NULL,'2025-11-29 08:16:39',NULL,NULL),(333,NULL,'4da7fb77734a4135a6f8b5b70bed7a2f',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:16:41',NULL,'2025-11-29 08:16:41',NULL,NULL),(334,NULL,NULL,'f5ee3792ff1a4aa3ab899edb89244703',NULL,NULL,NULL,NULL,'2025-11-29 08:17:00',NULL,'2025-11-29 08:17:00',NULL,NULL),(335,NULL,'3dddf50fa9834b84b8c792205ab0590e',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:17:01',NULL,'2025-11-29 08:17:01',NULL,NULL),(336,NULL,NULL,'132e3b01995f42c28e20f5d190885d00',NULL,NULL,NULL,NULL,'2025-11-29 08:17:25',NULL,'2025-11-29 08:17:25',NULL,NULL),(337,NULL,NULL,'fc6c7dafe6cc4a1fb8982fefaa672d30',NULL,NULL,NULL,NULL,'2025-11-29 08:17:25',NULL,'2025-11-29 08:17:25',NULL,NULL),(338,NULL,'98623544266946388dc2821daacd91e3',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:17:27',NULL,'2025-11-29 08:17:27',NULL,NULL),(339,NULL,NULL,'2646d924f10246c98f4ee29d496eb0f3',NULL,NULL,NULL,NULL,'2025-11-29 08:18:28',NULL,'2025-11-29 08:18:28',NULL,NULL),(340,NULL,NULL,'70ca51be767d45ddad8194df5321cc0a',NULL,NULL,NULL,NULL,'2025-11-29 08:18:28',NULL,'2025-11-29 08:18:28',NULL,NULL),(341,NULL,'6186d631a9cc4e06b92380689bece269',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:18:29',NULL,'2025-11-29 08:18:29',NULL,NULL),(342,NULL,'9e6235234e63419ead82cbd9a07d500f',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:18:30',NULL,'2025-11-29 08:18:30',NULL,NULL),(343,NULL,NULL,'eb363261bdab40e790d3017750f85069',NULL,NULL,NULL,NULL,'2025-11-29 08:18:32',NULL,'2025-11-29 08:18:32',NULL,NULL),(344,NULL,NULL,'093bae346b2b48e9a758fd175e18f6d3',NULL,NULL,NULL,NULL,'2025-11-29 08:18:32',NULL,'2025-11-29 08:18:32',NULL,NULL),(345,NULL,'6d98110ddcfe42419e0a7a45ebcbf1b5',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:18:33',NULL,'2025-11-29 08:18:33',NULL,NULL),(346,NULL,'4e5f917d899b41e7b5ec4efeeb4fc74f',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:18:34',NULL,'2025-11-29 08:18:34',NULL,NULL),(347,NULL,NULL,'07252d4da1d846bb9c6e3eb705f9fbd8',NULL,NULL,NULL,NULL,'2025-11-29 08:18:37',NULL,'2025-11-29 08:18:37',NULL,NULL),(348,NULL,'984c93e3ceff4794a06823f1b76f0203',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:18:40',NULL,'2025-11-29 08:18:40',NULL,NULL),(349,NULL,NULL,'c5e3ade3963d47be97b545b2e3779b6b',NULL,NULL,NULL,NULL,'2025-11-29 08:18:54',NULL,'2025-11-29 08:18:54',NULL,NULL),(350,NULL,NULL,'b48256fe29554511b25c2f5c20387645',NULL,NULL,NULL,NULL,'2025-11-29 08:18:54',NULL,'2025-11-29 08:18:54',NULL,NULL),(351,NULL,'1b8899f76f554afc96bb2441424e5a77',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:18:55',NULL,'2025-11-29 08:18:55',NULL,NULL),(352,NULL,'8d6a508547b04ab19c5e5aa532a792a1',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:18:56',NULL,'2025-11-29 08:18:56',NULL,NULL),(353,NULL,NULL,'0eae60e4659a41fc95ec8930f0ff58c9',NULL,NULL,NULL,NULL,'2025-11-29 08:18:59',NULL,'2025-11-29 08:18:59',NULL,NULL),(354,NULL,'16f2c8c680d84a12abf1469c681fd328',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:19:01',NULL,'2025-11-29 08:19:01',NULL,NULL),(355,NULL,NULL,'c2d81b2cb6a140dc94e2c0965d4219cb',NULL,NULL,NULL,NULL,'2025-11-29 08:19:11',NULL,'2025-11-29 08:19:11',NULL,NULL),(356,NULL,'742c4de6c1314ca1aeaf3f5666a16967',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:19:12',NULL,'2025-11-29 08:19:12',NULL,NULL),(357,NULL,NULL,'14d293467f8e498eaa87b6b8976b34d9',NULL,NULL,NULL,NULL,'2025-11-29 08:19:59',NULL,'2025-11-29 08:19:59',NULL,NULL),(358,NULL,'27fd30263a7f4717b84946720a5770b5',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:19:59',NULL,'2025-11-29 08:19:59',NULL,NULL),(359,NULL,NULL,'697e5f10e07b4256a3dc2ad3906db9d2',NULL,NULL,NULL,NULL,'2025-11-29 08:21:04',NULL,'2025-11-29 08:21:04',NULL,NULL),(360,NULL,'696ec278f2ec426fa75ebb50bdf1c16a',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:21:06',NULL,'2025-11-29 08:21:06',NULL,NULL),(361,NULL,NULL,'464a845eba164483a26ad56dca49af3d',NULL,NULL,NULL,NULL,'2025-11-29 08:21:22',NULL,'2025-11-29 08:21:22',NULL,NULL),(362,NULL,'6aa17a00c635424f98f28f89b9229ee2',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:21:23',NULL,'2025-11-29 08:21:23',NULL,NULL),(363,NULL,NULL,'0662b63a7f1f4a00960875249475e54a',NULL,NULL,NULL,NULL,'2025-11-29 08:22:04',NULL,'2025-11-29 08:22:04',NULL,NULL),(364,NULL,'36e3df454d054a1abd33ac1e9ae39e7f',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:22:06',NULL,'2025-11-29 08:22:06',NULL,NULL),(365,NULL,NULL,'0a8754f9da5640b784a1a46ae3b4d9e2',NULL,NULL,NULL,NULL,'2025-11-29 08:22:39',NULL,'2025-11-29 08:22:39',NULL,NULL),(366,NULL,'44709b8542a14e20970b111bd3fce127',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:22:42',NULL,'2025-11-29 08:22:42',NULL,NULL),(367,NULL,NULL,'ac72c18a5c6f43faa861ede8af0e4363',NULL,NULL,NULL,NULL,'2025-11-29 08:23:29',NULL,'2025-11-29 08:23:29',NULL,NULL),(368,NULL,'ac24a4866299495cb28b7d3f281ec632',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:23:31',NULL,'2025-11-29 08:23:31',NULL,NULL),(369,NULL,NULL,'80ceb9112b3a4f119c05f21fd617af11',NULL,NULL,NULL,NULL,'2025-11-29 08:23:49',NULL,'2025-11-29 08:23:49',NULL,NULL),(370,NULL,'26e3508b949a4dbf960d7befc8f27869',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:23:51',NULL,'2025-11-29 08:23:51',NULL,NULL),(371,NULL,NULL,'d49b9d546af249fc80268c1bdd5884f6',NULL,NULL,NULL,NULL,'2025-11-29 08:24:55',NULL,'2025-11-29 08:24:55',NULL,NULL),(372,NULL,'252fdae97c7e4dec97ac9a23d72747cc',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:24:57',NULL,'2025-11-29 08:24:57',NULL,NULL),(373,NULL,NULL,'1552f15deb524705a9456cbe9b54c429',NULL,NULL,NULL,NULL,'2025-11-29 08:25:32',NULL,'2025-11-29 08:25:32',NULL,NULL),(374,NULL,'0bace34c102e4d56b089fd695d324f10',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:25:34',NULL,'2025-11-29 08:25:34',NULL,NULL),(375,NULL,NULL,'e5346d862b0f4465aa9162f206696903',NULL,NULL,NULL,NULL,'2025-11-29 08:26:04',NULL,'2025-11-29 08:26:04',NULL,NULL),(376,NULL,'dd5ce4a2eb794cdd850dd88487f89b9a',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:26:05',NULL,'2025-11-29 08:26:05',NULL,NULL),(377,NULL,NULL,'8516d6a79ffe412bbe8552fc233adf59',NULL,NULL,NULL,NULL,'2025-11-29 08:26:07',NULL,'2025-11-29 08:26:07',NULL,NULL),(378,NULL,'34cdf0e4d08f40cfb54455e1f681aea2',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:26:07',NULL,'2025-11-29 08:26:07',NULL,NULL),(379,NULL,NULL,'ca6429b45fce4c1dac912e22a4cc92a0',NULL,NULL,NULL,NULL,'2025-11-29 08:26:21',NULL,'2025-11-29 08:26:21',NULL,NULL),(380,NULL,'ac24f86e54af4b2fa7d52499b2a2ac48',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:26:21',NULL,'2025-11-29 08:26:21',NULL,NULL),(381,NULL,NULL,'ac7e861322894ae387d8f7062a73dddb',NULL,NULL,NULL,NULL,'2025-11-29 08:26:57',NULL,'2025-11-29 08:26:57',NULL,NULL),(382,NULL,'14c2056117984f1e86ae3f64a5fee48c',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:26:58',NULL,'2025-11-29 08:26:58',NULL,NULL),(383,NULL,NULL,'873186539acb4bf9b90513e0e1beb56f',NULL,NULL,NULL,NULL,'2025-11-29 08:28:27',NULL,'2025-11-29 08:28:27',NULL,NULL),(384,NULL,'a9a83f8d8d7f4d08890407f978c05166',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:28:28',NULL,'2025-11-29 08:28:28',NULL,NULL),(385,NULL,NULL,'3b82660ada2f4c5e928f81c904052ede',NULL,NULL,NULL,NULL,'2025-11-29 08:28:31',NULL,'2025-11-29 08:28:31',NULL,NULL),(386,NULL,NULL,'7187983dc9a840d984e18e1c2aef0c34',NULL,NULL,NULL,NULL,'2025-11-29 08:28:31',NULL,'2025-11-29 08:28:31',NULL,NULL),(387,NULL,'11d369fbb4134866903aa4cc051f476e',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:28:33',NULL,'2025-11-29 08:28:33',NULL,NULL),(388,NULL,NULL,'283f8136265e4425a5a31f840935b9ab',NULL,NULL,NULL,NULL,'2025-11-29 08:29:13',NULL,'2025-11-29 08:29:13',NULL,NULL),(389,NULL,'ea7b24ea9d7b4d239b4741634ac3f10c',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:29:15',NULL,'2025-11-29 08:29:15',NULL,NULL),(390,NULL,NULL,'795ef5ce2edb4c1987378419f19947a2',NULL,NULL,NULL,NULL,'2025-11-29 08:30:06',NULL,'2025-11-29 08:30:06',NULL,NULL),(391,NULL,'39da21e61faa40aa979d498a98e394c9',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:30:07',NULL,'2025-11-29 08:30:07',NULL,NULL),(392,NULL,NULL,'55c38d3084c341e79bdd5a5fe9fdbcf3',NULL,NULL,NULL,NULL,'2025-11-29 08:30:09',NULL,'2025-11-29 08:30:09',NULL,NULL),(393,NULL,'f332b307155a4faeb11e045751138db4',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:30:11',NULL,'2025-11-29 08:30:11',NULL,NULL),(394,NULL,NULL,'64b11a4dc36b4f55b85dbe846183be55',NULL,NULL,NULL,NULL,'2025-11-29 08:30:53',NULL,'2025-11-29 08:30:53',NULL,NULL),(395,NULL,'ae71059d02774857be85797a3be0e4e6',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:30:53',NULL,'2025-11-29 08:30:53',NULL,NULL),(396,NULL,NULL,'a0cb6498950f4379bd812fb7e930b557',NULL,NULL,NULL,NULL,'2025-11-29 08:30:56',NULL,'2025-11-29 08:30:56',NULL,NULL),(397,NULL,'79be861842ba4648bf3bb80bbf042f62',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:30:57',NULL,'2025-11-29 08:30:57',NULL,NULL),(398,NULL,NULL,'53bb5b4c54c7482b837a1c8ed16dcde5',NULL,NULL,NULL,NULL,'2025-11-29 08:31:04',NULL,'2025-11-29 08:31:04',NULL,NULL),(399,NULL,'e508e27e991841b19cf33b0355ad7b80',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:31:05',NULL,'2025-11-29 08:31:05',NULL,NULL),(400,NULL,NULL,'0741d46905e94415a372bd62751dff66',NULL,NULL,NULL,NULL,'2025-11-29 08:32:07',NULL,'2025-11-29 08:32:07',NULL,NULL),(401,NULL,NULL,'7d0fe4959da2448bb03287ffc6c1eba7',NULL,NULL,NULL,NULL,'2025-11-29 08:32:07',NULL,'2025-11-29 08:32:07',NULL,NULL),(402,NULL,'5970d12b2c42419e889cd48de28c4b86',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:32:08',NULL,'2025-11-29 08:32:08',NULL,NULL),(403,NULL,NULL,'fed6803a835e471f9bd60e3236e78e5d',NULL,NULL,NULL,NULL,'2025-11-29 08:32:20',NULL,'2025-11-29 08:32:20',NULL,NULL),(404,NULL,NULL,'5da137b03369494c991c9e0197471f42',NULL,NULL,NULL,NULL,'2025-11-29 08:32:20',NULL,'2025-11-29 08:32:20',NULL,NULL),(405,NULL,'4145ed6cde61439ebcc12fae2609b724',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:32:24',NULL,'2025-11-29 08:32:24',NULL,NULL),(406,NULL,'cc9ff77d04cd4758aad09958f24a7a9a',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:32:26',NULL,'2025-11-29 08:32:26',NULL,NULL),(407,NULL,NULL,'ce5327e4760541578f2a465a788d04f7',NULL,NULL,NULL,NULL,'2025-11-29 08:32:52',NULL,'2025-11-29 08:32:52',NULL,NULL),(408,NULL,'d2ecba0524c44f4d89c1560f849c7be4',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:32:53',NULL,'2025-11-29 08:32:53',NULL,NULL),(409,NULL,NULL,'7147127ad2c248a6977704a1850eb832',NULL,NULL,NULL,NULL,'2025-11-29 08:33:45',NULL,'2025-11-29 08:33:45',NULL,NULL),(410,NULL,'61c2a7b8d2c741a1af85aefdb0eb7132',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:33:46',NULL,'2025-11-29 08:33:46',NULL,NULL),(411,NULL,NULL,'5b0fe4d78df74554a3a5875ab629d59c',NULL,NULL,NULL,NULL,'2025-11-29 08:34:22',NULL,'2025-11-29 08:34:22',NULL,NULL),(412,NULL,'1981e9617628491f938ef0ef01c061c5',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:34:23',NULL,'2025-11-29 08:34:23',NULL,NULL),(413,NULL,NULL,'c5b0953fb7cc415fb26cf4ffdd5908c6',NULL,NULL,NULL,NULL,'2025-11-29 08:36:07',NULL,'2025-11-29 08:36:07',NULL,NULL),(414,NULL,'d4f6db81949d487b853d7567f8a2e6d4',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:36:08',NULL,'2025-11-29 08:36:08',NULL,NULL),(415,NULL,NULL,'a57807acb02b45d082f242ec62cd5b6f',NULL,NULL,NULL,NULL,'2025-11-29 08:36:55',NULL,'2025-11-29 08:36:55',NULL,NULL),(416,NULL,'96e72e7660da497a8b6bf9fdb03fe84c',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:36:56',NULL,'2025-11-29 08:36:56',NULL,NULL),(417,NULL,NULL,'bdbcdbdc435844ee8d866288c969331b',NULL,NULL,NULL,NULL,'2025-11-29 08:38:43',NULL,'2025-11-29 08:38:43',NULL,NULL),(418,NULL,'368e3a44279843f5947188dd045d65b6',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:38:44',NULL,'2025-11-29 08:38:44',NULL,NULL),(419,NULL,NULL,'e8b20745b2d14f70b64a43335faed2f4',NULL,NULL,NULL,NULL,'2025-11-29 08:40:07',NULL,'2025-11-29 08:40:07',NULL,NULL),(420,NULL,NULL,'7ce5ccb7d1c84e168d3dd52a6e1df092',NULL,NULL,NULL,NULL,'2025-11-29 08:40:07',NULL,'2025-11-29 08:40:07',NULL,NULL),(421,NULL,'8d5e30b74e6449dd90ecb667977d1fe9',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:40:08',NULL,'2025-11-29 08:40:08',NULL,NULL),(422,NULL,'ec003a605b1d455986bd520e2566635c',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:40:09',NULL,'2025-11-29 08:40:09',NULL,NULL),(423,NULL,NULL,'eeba34466b8f4a1bb5f742f1e811053c',NULL,NULL,NULL,NULL,'2025-11-29 08:41:02',NULL,'2025-11-29 08:41:02',NULL,NULL),(424,NULL,'889608c71d13429fb37793575792ae74',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:41:03',NULL,'2025-11-29 08:41:03',NULL,NULL),(425,NULL,NULL,'24c3267183e24e99bbb30a96656a36e7',NULL,NULL,NULL,NULL,'2025-11-29 08:41:12',NULL,'2025-11-29 08:41:12',NULL,NULL),(426,NULL,'89fad883285a4255b3b35c445f93c900',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:41:14',NULL,'2025-11-29 08:41:14',NULL,NULL),(427,NULL,NULL,'48c4f3f10bf249d5a724a70622e20291',NULL,NULL,NULL,NULL,'2025-11-29 08:41:21',NULL,'2025-11-29 08:41:21',NULL,NULL),(428,NULL,'0ccc70201c12433cba2c77f57171fc5a',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:41:22',NULL,'2025-11-29 08:41:22',NULL,NULL),(429,NULL,NULL,'facf4db8501041ab9628ff9f5684c992',NULL,NULL,NULL,NULL,'2025-11-29 08:41:50',NULL,'2025-11-29 08:41:50',NULL,NULL),(430,NULL,NULL,'c916dc47add5438481c43c087b9c9931',NULL,NULL,NULL,NULL,'2025-11-29 08:41:50',NULL,'2025-11-29 08:41:50',NULL,NULL),(431,NULL,'a5eb9a643c604b2a967a30114afaf5be',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:41:51',NULL,'2025-11-29 08:41:51',NULL,NULL),(432,NULL,'62ca01275fe34ea0af31d00b34d6d9a5',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:41:52',NULL,'2025-11-29 08:41:52',NULL,NULL),(433,NULL,NULL,'e115b7a476df47299b386ec2447637e9',NULL,NULL,NULL,NULL,'2025-11-29 08:42:53',NULL,'2025-11-29 08:42:53',NULL,NULL),(434,NULL,NULL,'dda7b3867e5c45a7bb78d049103bc095',NULL,NULL,NULL,NULL,'2025-11-29 08:42:53',NULL,'2025-11-29 08:42:53',NULL,NULL),(435,NULL,'6519f321a4954567ab99a11cc07cc5ac',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:42:54',NULL,'2025-11-29 08:42:54',NULL,NULL),(436,NULL,'df59ee3c04c04efabfae553312366b99',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:42:55',NULL,'2025-11-29 08:42:55',NULL,NULL),(437,NULL,NULL,'ea98d0ceb3954515a9c726d0d32d30cb',NULL,NULL,NULL,NULL,'2025-11-29 08:43:04',NULL,'2025-11-29 08:43:04',NULL,NULL),(438,NULL,NULL,'189288f9eae34bc889327d769c26cca2',NULL,NULL,NULL,NULL,'2025-11-29 08:43:04',NULL,'2025-11-29 08:43:04',NULL,NULL),(439,NULL,'50ef2e8e769e46a4bfb960f85b59352d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:43:06',NULL,'2025-11-29 08:43:06',NULL,NULL),(440,NULL,'c80b570a17ee4094b96a75465fc34ae7',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:43:08',NULL,'2025-11-29 08:43:08',NULL,NULL),(441,NULL,NULL,'5ac9cfdaf51b4a5ab874f7e3571f88a0',NULL,NULL,NULL,NULL,'2025-11-29 08:45:55',NULL,'2025-11-29 08:45:55',NULL,NULL),(442,NULL,NULL,'e268203769c3462e92e4a2ce0b822f1f',NULL,NULL,NULL,NULL,'2025-11-29 08:45:56',NULL,'2025-11-29 08:45:56',NULL,NULL),(443,NULL,'66ee3b60fb89476383201ba204858d4d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:45:57',NULL,'2025-11-29 08:45:57',NULL,NULL),(444,NULL,NULL,'4774e2851bc6407cb0fcde15bd24d1b3',NULL,NULL,NULL,NULL,'2025-11-29 08:45:57',NULL,'2025-11-29 08:45:57',NULL,NULL),(445,NULL,NULL,'b9c9f368567b4f458c1f24839d56d06b',NULL,NULL,NULL,NULL,'2025-11-29 08:45:58',NULL,'2025-11-29 08:45:58',NULL,NULL),(446,NULL,'29c94103685649f9b4245f7c66941d45',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:45:58',NULL,'2025-11-29 08:45:58',NULL,NULL),(447,NULL,'0471b9b208874403aa3f0fbe7504ad19',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:45:59',NULL,'2025-11-29 08:45:59',NULL,NULL),(448,NULL,NULL,'01c0b956e2c74d5798d01fc2be0a8bac',NULL,NULL,NULL,NULL,'2025-11-29 08:45:59',NULL,'2025-11-29 08:45:59',NULL,NULL),(449,NULL,NULL,'0354f2cc3d6c4c0ca7c560bb73080718',NULL,NULL,NULL,NULL,'2025-11-29 08:45:59',NULL,'2025-11-29 08:45:59',NULL,NULL),(450,NULL,'610836eb8b224162b2d3bb77a5d10a7f',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:46:00',NULL,'2025-11-29 08:46:00',NULL,NULL),(451,NULL,'3b3b0484057a4e3db51366d29c6b684d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:46:00',NULL,'2025-11-29 08:46:00',NULL,NULL),(452,NULL,'14c1841096db4ee78f0cc73943d60b06',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:46:01',NULL,'2025-11-29 08:46:01',NULL,NULL),(453,NULL,NULL,'344d31c1be5d41b1af2cc7427e8e0457',NULL,NULL,NULL,NULL,'2025-11-29 08:47:01',NULL,'2025-11-29 08:47:01',NULL,NULL),(454,NULL,NULL,'03831b8a817f4214b045b6d39cbe46da',NULL,NULL,NULL,NULL,'2025-11-29 08:47:01',NULL,'2025-11-29 08:47:01',NULL,NULL),(455,NULL,'6963376bdd13402b87e3cd5008e9a984',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:47:03',NULL,'2025-11-29 08:47:03',NULL,NULL),(456,NULL,'053dbfa33fdc48d6ad41e28ea7a34860',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:47:03',NULL,'2025-11-29 08:47:03',NULL,NULL),(457,NULL,NULL,'de2965680b714b539553cf0792584e1e',NULL,NULL,NULL,NULL,'2025-11-29 08:48:11',NULL,'2025-11-29 08:48:11',NULL,NULL),(458,NULL,NULL,'a9046bfcf55a4809aaf25edff2e41e75',NULL,NULL,NULL,NULL,'2025-11-29 08:48:11',NULL,'2025-11-29 08:48:11',NULL,NULL),(459,NULL,NULL,'8177124baedd434892cd11b707db0b34',NULL,NULL,NULL,NULL,'2025-11-29 08:48:11',NULL,'2025-11-29 08:48:11',NULL,NULL),(460,NULL,'75423dfb570f4b2bbc2f8de4f3a65d18',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:48:13',NULL,'2025-11-29 08:48:13',NULL,NULL),(461,NULL,'f62777789c6f4c779695a4bd13f4a8a5',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:48:14',NULL,'2025-11-29 08:48:14',NULL,NULL),(462,NULL,'b49fa6f805e04e859a86029c0785b60c',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:48:15',NULL,'2025-11-29 08:48:15',NULL,NULL),(463,NULL,NULL,'01dac15e9e59419d98c66eb08a434612',NULL,NULL,NULL,NULL,'2025-11-29 08:49:38',NULL,'2025-11-29 08:49:38',NULL,NULL),(464,NULL,NULL,'82e4243b28374a0f868350f325dea150',NULL,NULL,NULL,NULL,'2025-11-29 08:49:39',NULL,'2025-11-29 08:49:39',NULL,NULL),(465,NULL,'7514c18ff0d64f6dbdddadeb7faa4e9b',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:49:40',NULL,'2025-11-29 08:49:40',NULL,NULL),(466,NULL,'56b9fd3ff0794089a4e086cd4ca0c36d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:49:41',NULL,'2025-11-29 08:49:41',NULL,NULL),(467,NULL,NULL,'14d446574294425e9bc89e596ea56dc9',NULL,NULL,NULL,NULL,'2025-11-29 08:50:41',NULL,'2025-11-29 08:50:41',NULL,NULL),(468,NULL,NULL,'ba1af609947b48299d793241b33fe297',NULL,NULL,NULL,NULL,'2025-11-29 08:50:41',NULL,'2025-11-29 08:50:41',NULL,NULL),(469,NULL,'2e636ab14fe94059b82b9cbcf8831d87',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:50:43',NULL,'2025-11-29 08:50:43',NULL,NULL),(470,NULL,'a59a3ea65ce149d5acfebcda374d24b8',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:50:45',NULL,'2025-11-29 08:50:45',NULL,NULL),(471,NULL,NULL,'1ced5eb1f1a747719e0b0023efef7753',NULL,NULL,NULL,NULL,'2025-11-29 08:51:05',NULL,'2025-11-29 08:51:05',NULL,NULL),(472,NULL,NULL,'928c6c6e0456401e86795ea38f12e276',NULL,NULL,NULL,NULL,'2025-11-29 08:51:06',NULL,'2025-11-29 08:51:06',NULL,NULL),(473,NULL,'e459d5bb0f7a460ca1074f341c4fc08f',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:51:07',NULL,'2025-11-29 08:51:07',NULL,NULL),(474,NULL,NULL,'c3778685080b4955bd80ff7056a1c9f2',NULL,NULL,NULL,NULL,'2025-11-29 08:53:04',NULL,'2025-11-29 08:53:04',NULL,NULL),(475,NULL,NULL,'7715999d9df64830bfb01c03c3fa834b',NULL,NULL,NULL,NULL,'2025-11-29 08:53:05',NULL,'2025-11-29 08:53:05',NULL,NULL),(476,NULL,'29f553e696c746688e0cfedd88eebaf5',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:53:06',NULL,'2025-11-29 08:53:06',NULL,NULL),(477,NULL,'676f70280bf945cd90578b14202243e2',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:53:07',NULL,'2025-11-29 08:53:07',NULL,NULL),(478,NULL,NULL,'b576a51181b5425aa6e44a0eb0a22803',NULL,NULL,NULL,NULL,'2025-11-29 08:53:18',NULL,'2025-11-29 08:53:18',NULL,NULL),(479,NULL,NULL,'cd23a71fedba4c88b86965fc3d868552',NULL,NULL,NULL,NULL,'2025-11-29 08:53:18',NULL,'2025-11-29 08:53:18',NULL,NULL),(480,NULL,'c1a81d6c21294947838756d6acac00c8',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:53:19',NULL,'2025-11-29 08:53:19',NULL,NULL),(481,NULL,'b7ffcb23bac14ee49474df9aee5f7dae',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:53:19',NULL,'2025-11-29 08:53:19',NULL,NULL);
/*!40000 ALTER TABLE `revocation_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL DEFAULT '<<null>>',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_role_name_domain_id` (`name`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` (`id`, `name`, `extra`, `domain_id`, `description`) VALUES ('04bf06f01b0e4121b205ab6b844f95a9','member','{}','<<null>>',NULL),('1fb5b35072264d2daf875dd0816311df','service','{}','<<null>>',NULL),('4ab5e58929544d36be00d28d28cd1485','admin','{}','<<null>>',NULL),('59f0753a912449cca75cd42b1a2387d3','reader','{}','<<null>>',NULL),('ae4a1c424e744d14ab2b8be75d253e0a','swiftoperator','{}','<<null>>',NULL),('c30083c0eb584225a6c576cbb6cf0bb8','ResellerAdmin','{}','<<null>>',NULL);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_option`
--

DROP TABLE IF EXISTS `role_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_option` (
  `role_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`role_id`,`option_id`),
  CONSTRAINT `role_option_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_option`
--

LOCK TABLES `role_option` WRITE;
/*!40000 ALTER TABLE `role_option` DISABLE KEYS */;
INSERT INTO `role_option` (`role_id`, `option_id`, `option_value`) VALUES ('04bf06f01b0e4121b205ab6b844f95a9','IMMU','true'),('4ab5e58929544d36be00d28d28cd1485','IMMU','true'),('59f0753a912449cca75cd42b1a2387d3','IMMU','true');
/*!40000 ALTER TABLE `role_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sensitive_config`
--

DROP TABLE IF EXISTS `sensitive_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sensitive_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sensitive_config`
--

LOCK TABLES `sensitive_config` WRITE;
/*!40000 ALTER TABLE `sensitive_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sensitive_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `type`, `enabled`, `extra`) VALUES ('04798044e0e7463192922f909e83b7a6','identity',1,'{\"name\": \"keystone\"}'),('27424dfb271640158e449513621da8a4','key-manager',1,'{\"description\": \"Barbican Service\", \"name\": \"barbican\"}'),('28a101df3ded442c97f664654bb73e6b','Ceilometer',1,'{\"description\": \"Ceilometer Service\", \"name\": \"ceilometer\"}'),('2e9613f0af6f4c73856a69c6797721b7','volumev3',1,'{\"description\": \"Cinder V3 Service\", \"name\": \"cinderv3\"}'),('62510965ab77429781a62bed6f089b07','object-store',1,'{\"name\": \"swift\", \"description\": \"OpenStack Object Storage\"}'),('6a7453ef7c7b4d3d88909ab42bee6d17','compute',1,'{\"description\": \"Nova Compute Service\", \"name\": \"nova\"}'),('aab5d088d8ee44dcb35e8db6f7344159','placement',1,'{\"description\": \"Placement Service\", \"name\": \"placement\"}'),('bb11416d93654a988b6034d41e099615','image',1,'{\"description\": \"Glance Service\", \"name\": \"glance\"}'),('cce233c47340431ab7f2a0205f5bd0fb','network',1,'{\"description\": \"Openstack Networking\", \"name\": \"neutron\"}');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_provider`
--

DROP TABLE IF EXISTS `service_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_provider` (
  `auth_url` varchar(256) NOT NULL,
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `sp_url` varchar(256) NOT NULL,
  `relay_state_prefix` varchar(256) NOT NULL DEFAULT 'ss:mem:',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_provider`
--

LOCK TABLES `service_provider` WRITE;
/*!40000 ALTER TABLE `service_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `service_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_assignment`
--

DROP TABLE IF EXISTS `system_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_assignment` (
  `type` varchar(64) NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_assignment`
--

LOCK TABLES `system_assignment` WRITE;
/*!40000 ALTER TABLE `system_assignment` DISABLE KEYS */;
INSERT INTO `system_assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserSystem','07d8fdc1f04d4769b5744eeac3a6f5f4','system','4ab5e58929544d36be00d28d28cd1485',0);
/*!40000 ALTER TABLE `system_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `token`
--

DROP TABLE IF EXISTS `token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `token` (
  `id` varchar(64) NOT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_token_expires_valid` (`expires`,`valid`),
  KEY `ix_token_expires` (`expires`),
  KEY `ix_token_trust_id` (`trust_id`),
  KEY `ix_token_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `token`
--

LOCK TABLES `token` WRITE;
/*!40000 ALTER TABLE `token` DISABLE KEYS */;
/*!40000 ALTER TABLE `token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust`
--

DROP TABLE IF EXISTS `trust`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust` (
  `id` varchar(64) NOT NULL,
  `trustor_user_id` varchar(64) NOT NULL,
  `trustee_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `impersonation` tinyint(1) NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `remaining_uses` int(11) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `redelegated_trust_id` varchar(64) DEFAULT NULL,
  `redelegation_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `duplicate_trust_constraint_expanded` (`trustor_user_id`,`trustee_user_id`,`project_id`,`impersonation`,`expires_at`,`expires_at_int`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust`
--

LOCK TABLES `trust` WRITE;
/*!40000 ALTER TABLE `trust` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust_role`
--

DROP TABLE IF EXISTS `trust_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust_role` (
  `trust_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`trust_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust_role`
--

LOCK TABLES `trust_role` WRITE;
/*!40000 ALTER TABLE `trust_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `default_project_id` varchar(64) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_active_at` date DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_user_id_domain_id` (`id`,`domain_id`),
  KEY `ix_default_project_id` (`default_project_id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `extra`, `enabled`, `default_project_id`, `created_at`, `last_active_at`, `domain_id`) VALUES ('07d8fdc1f04d4769b5744eeac3a6f5f4','{}',1,NULL,'2025-11-29 06:54:56','2025-11-29','default'),('0b5e852f4a214b5fad81b314f18939d1','{}',1,'ecbeee0b8f0d4eb4a70c29ecb044cf2a','2025-11-29 06:56:15','2025-11-29','default'),('154b87b301664cbb87dcabd0078959a4','{}',1,'ecbeee0b8f0d4eb4a70c29ecb044cf2a','2025-11-29 06:56:24','2025-11-29','default'),('256c8a1ee11a4186828e6bc6a73449c9','{\"tenantId\": \"e3d094cabd5e4c46ae4c1fc0a07878f3\", \"email\": \"demo_tempestconf@test.com\"}',1,NULL,'2025-11-29 07:48:14',NULL,'default'),('322529fd0a444bda9d365f78b23f9b7c','{}',1,'ecbeee0b8f0d4eb4a70c29ecb044cf2a','2025-11-29 06:56:06','2025-11-29','default'),('3412e27b49e5442fa73da6dd686d0b3a','{}',1,'ecbeee0b8f0d4eb4a70c29ecb044cf2a','2025-11-29 06:56:29','2025-11-29','default'),('42c693593bc84068b5dc10095b3dfc4b','{}',1,'ecbeee0b8f0d4eb4a70c29ecb044cf2a','2025-11-29 07:16:35',NULL,'default'),('c491675d5f06426092a19d82da1b5638','{}',1,'ecbeee0b8f0d4eb4a70c29ecb044cf2a','2025-11-29 06:56:17','2025-11-29','default'),('c56f5d50072247b1bef168b51c299cba','{\"tenantId\": \"aa123ad9ac964c8499db667425cde073\", \"email\": \"alt_demo_tempestconf@test.com\"}',1,NULL,'2025-11-29 07:48:16',NULL,'default'),('f1de88c0afe14c67a5e9319365e6639c','{}',1,'ecbeee0b8f0d4eb4a70c29ecb044cf2a','2025-11-29 06:56:09','2025-11-29','default'),('fc1f94c9796d48eda7e2546e034a5b57','{}',1,'ecbeee0b8f0d4eb4a70c29ecb044cf2a','2025-11-29 06:56:41','2025-11-29','default');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_group_membership`
--

DROP TABLE IF EXISTS `user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `fk_user_group_membership_group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `fk_user_group_membership_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_group_membership`
--

LOCK TABLES `user_group_membership` WRITE;
/*!40000 ALTER TABLE `user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_option`
--

DROP TABLE IF EXISTS `user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_option` (
  `user_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`user_id`,`option_id`),
  CONSTRAINT `user_option_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_option`
--

LOCK TABLES `user_option` WRITE;
/*!40000 ALTER TABLE `user_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whitelisted_config`
--

DROP TABLE IF EXISTS `whitelisted_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whitelisted_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whitelisted_config`
--

LOCK TABLES `whitelisted_config` WRITE;
/*!40000 ALTER TABLE `whitelisted_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `whitelisted_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `mysql`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `mysql` /*!40100 DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci */;

USE `mysql`;

--
-- Table structure for table `general_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `general_log` (
  `event_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `command_type` varchar(64) NOT NULL,
  `argument` mediumtext NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='General log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slow_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `slow_log` (
  `start_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `query_time` time(6) NOT NULL,
  `lock_time` time(6) NOT NULL,
  `rows_sent` bigint(20) unsigned NOT NULL,
  `rows_examined` bigint(20) unsigned NOT NULL,
  `db` varchar(512) NOT NULL,
  `last_insert_id` int(11) NOT NULL,
  `insert_id` int(11) NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `sql_text` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `rows_affected` bigint(20) unsigned NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Slow log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `column_stats`
--

DROP TABLE IF EXISTS `column_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `column_stats` (
  `db_name` varchar(64) NOT NULL,
  `table_name` varchar(64) NOT NULL,
  `column_name` varchar(64) NOT NULL,
  `min_value` varbinary(255) DEFAULT NULL,
  `max_value` varbinary(255) DEFAULT NULL,
  `nulls_ratio` decimal(12,4) DEFAULT NULL,
  `avg_length` decimal(12,4) DEFAULT NULL,
  `avg_frequency` decimal(12,4) DEFAULT NULL,
  `hist_size` tinyint(3) unsigned DEFAULT NULL,
  `hist_type` enum('SINGLE_PREC_HB','DOUBLE_PREC_HB') DEFAULT NULL,
  `histogram` varbinary(255) DEFAULT NULL,
  PRIMARY KEY (`db_name`,`table_name`,`column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='Statistics on Columns';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `column_stats`
--

LOCK TABLES `column_stats` WRITE;
/*!40000 ALTER TABLE `column_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `column_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `columns_priv`
--

DROP TABLE IF EXISTS `columns_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `columns_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Table_name` char(64) NOT NULL DEFAULT '',
  `Column_name` char(64) NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `Column_priv` set('Select','Insert','Update','References') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`Host`,`Db`,`User`,`Table_name`,`Column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Column privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `columns_priv`
--

LOCK TABLES `columns_priv` WRITE;
/*!40000 ALTER TABLE `columns_priv` DISABLE KEYS */;
/*!40000 ALTER TABLE `columns_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db`
--

DROP TABLE IF EXISTS `db`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `db` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Event_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_history_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Host`,`Db`,`User`),
  KEY `User` (`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Database privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `db`
--

LOCK TABLES `db` WRITE;
/*!40000 ALTER TABLE `db` DISABLE KEYS */;
INSERT INTO `db` (`Host`, `Db`, `User`, `Select_priv`, `Insert_priv`, `Update_priv`, `Delete_priv`, `Create_priv`, `Drop_priv`, `Grant_priv`, `References_priv`, `Index_priv`, `Alter_priv`, `Create_tmp_table_priv`, `Lock_tables_priv`, `Create_view_priv`, `Show_view_priv`, `Create_routine_priv`, `Alter_routine_priv`, `Execute_priv`, `Event_priv`, `Trigger_priv`, `Delete_history_priv`) VALUES ('localhost','glance','glance_7797','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','glance','glance_7797','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','keystone','keystone_4eff','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','keystone','keystone_4eff','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','placement','placement_7c8d','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','placement','placement_7c8d','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','barbican','barbican_ea5d','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','barbican','barbican_ea5d','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','cinder','cinder_ebe5','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','cinder','cinder_ebe5','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','neutron','neutron_594c','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','neutron','neutron_594c','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_cell0','nova_cell0_c5ae','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_api','nova_api_ace2','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_cell0','nova_cell0_c5ae','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_api','nova_api_ace2','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');
/*!40000 ALTER TABLE `db` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `db` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `name` char(64) NOT NULL DEFAULT '',
  `body` longblob NOT NULL,
  `definer` char(141) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `execute_at` datetime DEFAULT NULL,
  `interval_value` int(11) DEFAULT NULL,
  `interval_field` enum('YEAR','QUARTER','MONTH','DAY','HOUR','MINUTE','WEEK','SECOND','MICROSECOND','YEAR_MONTH','DAY_HOUR','DAY_MINUTE','DAY_SECOND','HOUR_MINUTE','HOUR_SECOND','MINUTE_SECOND','DAY_MICROSECOND','HOUR_MICROSECOND','MINUTE_MICROSECOND','SECOND_MICROSECOND') DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_executed` datetime DEFAULT NULL,
  `starts` datetime DEFAULT NULL,
  `ends` datetime DEFAULT NULL,
  `status` enum('ENABLED','DISABLED','SLAVESIDE_DISABLED') NOT NULL DEFAULT 'ENABLED',
  `on_completion` enum('DROP','PRESERVE') NOT NULL DEFAULT 'DROP',
  `sql_mode` set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','IGNORE_BAD_TABLE_OPTIONS','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH','EMPTY_STRING_IS_NULL','SIMULTANEOUS_ASSIGNMENT','TIME_ROUND_FRACTIONAL') NOT NULL DEFAULT '',
  `comment` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `originator` int(10) unsigned NOT NULL,
  `time_zone` char(64) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT 'SYSTEM',
  `character_set_client` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `collation_connection` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `db_collation` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `body_utf8` longblob DEFAULT NULL,
  PRIMARY KEY (`db`,`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Events';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `func`
--

DROP TABLE IF EXISTS `func`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `func` (
  `name` char(64) NOT NULL DEFAULT '',
  `ret` tinyint(1) NOT NULL DEFAULT 0,
  `dl` char(128) NOT NULL DEFAULT '',
  `type` enum('function','aggregate') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='User defined functions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `func`
--

LOCK TABLES `func` WRITE;
/*!40000 ALTER TABLE `func` DISABLE KEYS */;
/*!40000 ALTER TABLE `func` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `global_priv`
--

DROP TABLE IF EXISTS `global_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Priv` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '{}' CHECK (json_valid(`Priv`)),
  PRIMARY KEY (`Host`,`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Users and global privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `global_priv`
--

LOCK TABLES `global_priv` WRITE;
/*!40000 ALTER TABLE `global_priv` DISABLE KEYS */;
INSERT INTO `global_priv` (`Host`, `User`, `Priv`) VALUES ('localhost','mariadb.sys','{\"access\":0,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"\",\"account_locked\":true,\"password_last_changed\":0}'),('localhost','root','{\"access\": 549755813887, \"plugin\": \"mysql_native_password\", \"authentication_string\": \"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\", \"auth_or\": [{}],\"version_id\":100529,\"password_last_changed\":1764399217}'),('%','root','{\"access\":549755813887,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\",\"password_last_changed\":1764399217}'),('localhost','glance_7797','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*90871BBBCE04C3C0B99C5B7D9FA2D5B2F904B5A3\",\"password_last_changed\":1764399235}'),('%','glance_7797','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*90871BBBCE04C3C0B99C5B7D9FA2D5B2F904B5A3\",\"password_last_changed\":1764399235}'),('localhost','keystone_4eff','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*09E8B97AC2A58D7B9B69D6B15F6F96B58B595BC1\",\"password_last_changed\":1764399238}'),('%','keystone_4eff','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*09E8B97AC2A58D7B9B69D6B15F6F96B58B595BC1\",\"password_last_changed\":1764399238}'),('localhost','placement_7c8d','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*2334BE2B661524DD6F4D4AB9AE0D5D3422851AF2\",\"password_last_changed\":1764399238}'),('%','placement_7c8d','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*2334BE2B661524DD6F4D4AB9AE0D5D3422851AF2\",\"password_last_changed\":1764399238}'),('localhost','barbican_ea5d','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*8B33C6885F50A9190B42E637728233F9D193F3DA\",\"password_last_changed\":1764399267}'),('%','barbican_ea5d','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*8B33C6885F50A9190B42E637728233F9D193F3DA\",\"password_last_changed\":1764399267}'),('localhost','cinder_ebe5','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*22BB44DAE83E3F1144A0789FBA27E2697CCA296A\",\"password_last_changed\":1764399267}'),('%','cinder_ebe5','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*22BB44DAE83E3F1144A0789FBA27E2697CCA296A\",\"password_last_changed\":1764399267}'),('localhost','neutron_594c','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*97112414D5583608D8780BE291E4750DB54E7E47\",\"password_last_changed\":1764399267}'),('%','neutron_594c','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*97112414D5583608D8780BE291E4750DB54E7E47\",\"password_last_changed\":1764399267}'),('localhost','nova_cell0_c5ae','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B160A625B1F1B6CD1DFBE68BA7ED2CE3EBE11A15\",\"password_last_changed\":1764399389}'),('localhost','nova_api_ace2','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*E8D319756ADD12F102A09A6EEAF298F248B7ADE7\",\"password_last_changed\":1764399389}'),('%','nova_cell0_c5ae','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B160A625B1F1B6CD1DFBE68BA7ED2CE3EBE11A15\",\"password_last_changed\":1764399389}'),('%','nova_api_ace2','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*E8D319756ADD12F102A09A6EEAF298F248B7ADE7\",\"password_last_changed\":1764399389}');
/*!40000 ALTER TABLE `global_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gtid_slave_pos`
--

DROP TABLE IF EXISTS `gtid_slave_pos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gtid_slave_pos` (
  `domain_id` int(10) unsigned NOT NULL,
  `sub_id` bigint(20) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `seq_no` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`domain_id`,`sub_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci COMMENT='Replication slave GTID position';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gtid_slave_pos`
--

LOCK TABLES `gtid_slave_pos` WRITE;
/*!40000 ALTER TABLE `gtid_slave_pos` DISABLE KEYS */;
/*!40000 ALTER TABLE `gtid_slave_pos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_category`
--

DROP TABLE IF EXISTS `help_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_category` (
  `help_category_id` smallint(5) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `parent_category_id` smallint(5) unsigned DEFAULT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_category_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_category`
--

LOCK TABLES `help_category` WRITE;
/*!40000 ALTER TABLE `help_category` DISABLE KEYS */;
INSERT INTO `help_category` (`help_category_id`, `name`, `parent_category_id`, `url`) VALUES (1,'Contents',0,''),(2,'Polygon Properties',34,''),(3,'WKT',34,''),(4,'Numeric Functions',37,''),(5,'Plugins',1,''),(6,'MBR',34,''),(7,'Control Flow Functions',37,''),(8,'Transactions',1,''),(9,'Help Metadata',1,''),(10,'Account Management',1,''),(11,'Point Properties',34,''),(12,'Encryption Functions',37,''),(13,'LineString Properties',34,''),(14,'Miscellaneous Functions',37,''),(15,'Logical Operators',47,''),(16,'Functions and Modifiers for Use with GROUP BY',1,''),(17,'Information Functions',37,''),(18,'Assignment Operators',47,''),(19,'Comparison Operators',47,''),(20,'Bit Functions',37,''),(21,'Table Maintenance',1,''),(22,'User-Defined Functions',1,''),(23,'Data Types',1,''),(24,'Compound Statements',1,''),(25,'Geometry Constructors',34,''),(26,'Administration',1,''),(27,'Data Manipulation',1,''),(28,'Utility',1,''),(29,'Language Structure',1,''),(30,'Geometry Relations',34,''),(31,'Date and Time Functions',37,''),(32,'WKB',34,''),(33,'Procedures',1,''),(34,'Geographic Features',1,''),(35,'Geometry Properties',34,''),(36,'String Functions',37,''),(37,'Functions',1,''),(38,'Data Definition',1,''),(39,'Sequences',1,''),(40,'JSON Functions',37,''),(41,'Window Functions',37,''),(42,'Spider Functions',37,''),(43,'Dynamic Column Functions',37,''),(44,'Galera Functions',37,''),(45,'Temporal Tables',1,''),(46,'GeoJSON',34,''),(47,'Operators',1,''),(48,'Arithmetic Operators',47,''),(49,'Replication',1,''),(50,'Prepared Statements',1,'');
/*!40000 ALTER TABLE `help_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_keyword`
--

DROP TABLE IF EXISTS `help_keyword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_keyword` (
  `help_keyword_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  PRIMARY KEY (`help_keyword_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help keywords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_keyword`
--

LOCK TABLES `help_keyword` WRITE;
/*!40000 ALTER TABLE `help_keyword` DISABLE KEYS */;
INSERT INTO `help_keyword` (`help_keyword_id`, `name`) VALUES (1,'work'),(2,'locks'),(3,'locking'),(4,'drop'),(5,'super'),(6,'usage'),(7,'binlog admin'),(8,'binlog monitor'),(9,'binlog replay'),(10,'connection admin'),(11,'federated admin'),(12,'grant option'),(13,'read_only admin'),(14,'replica monitor'),(15,'replication replica'),(16,'roles'),(17,'values'),(18,'value'),(19,'not'),(20,'and'),(21,'or'),(22,':='),(23,'assignment operator'),(24,'='),(25,'!='),(26,'<>'),(27,'not equal'),(28,'less than'),(29,'less than or equal'),(30,'NULL-safe equal'),(31,'equal'),(32,'greater than'),(33,'greater than or equal'),(34,'bitwise and'),(35,'shift left'),(36,'shift right'),(37,'bitwise xor'),(38,'bitwise or'),(39,'bitwise not'),(40,'returns'),(41,'udfs'),(42,'udf calling sequences'),(43,'udf security'),(44,'int1'),(45,'int2'),(46,'int3'),(47,'integer'),(48,'int4'),(49,'int8'),(50,'dec'),(51,'numeric'),(52,'fixed'),(53,'number'),(54,'real'),(55,'double precision'),(56,'nchar'),(57,'long'),(58,'long varchar'),(59,'repeat'),(60,'declare'),(61,'cursor'),(62,'show'),(63,'columns'),(64,'kill connection'),(65,'kill query'),(66,'delete returning'),(67,'sql_big_result'),(68,'minus'),(69,'cte'),(70,'insert returning'),(71,'queries'),(72,'query'),(73,'explain format'),(74,'explain format json'),(75,'rlike'),(76,'character_length'),(77,'escape'),(78,'mode'),(79,'trim_oracle'),(80,'schedule'),(81,'row_format'),(82,'starts'),(83,'host'),(84,'generated columns'),(85,'virtual columns'),(86,'computed columns'),(87,'hidden columns'),(88,'nextval'),(89,'lastval'),(90,'+'),(91,'addition operator'),(92,'/'),(93,'division operator'),(94,'%'),(95,'modulo operator'),(96,'*'),(97,'multiplication operator'),(98,'-'),(99,'subtraction operator'),(100,'master_ssl_verify_cert'),(101,'start replica'),(102,'stop replica'),(103,'reset slave'),(104,'reset replica'),(105,'drop prepare'),(106,'deallocate prepare');
/*!40000 ALTER TABLE `help_keyword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_relation`
--

DROP TABLE IF EXISTS `help_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_relation` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `help_keyword_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`help_keyword_id`,`help_topic_id`),
  KEY `help_topic_id` (`help_topic_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='keyword-topic relation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_relation`
--

LOCK TABLES `help_relation` WRITE;
/*!40000 ALTER TABLE `help_relation` DISABLE KEYS */;
INSERT INTO `help_relation` (`help_topic_id`, `help_keyword_id`) VALUES (94,1),(97,2),(99,2),(101,2),(116,2),(147,2),(152,2),(157,2),(161,2),(162,2),(338,2),(438,2),(97,3),(99,3),(101,3),(116,3),(147,3),(152,3),(157,3),(161,3),(162,3),(338,3),(438,3),(106,4),(112,4),(250,4),(687,4),(697,4),(713,4),(714,4),(715,4),(716,4),(717,4),(718,4),(719,4),(720,4),(722,4),(723,4),(731,4),(107,5),(107,6),(107,7),(107,8),(107,9),(107,10),(107,11),(107,12),(107,13),(107,14),(107,15),(115,16),(166,17),(166,18),(167,19),(168,20),(170,21),(210,22),(210,23),(211,23),(211,24),(212,25),(212,26),(212,27),(213,28),(214,29),(215,30),(216,31),(217,32),(218,33),(232,34),(233,35),(234,36),(236,37),(237,38),(238,39),(249,40),(251,41),(252,42),(253,43),(255,44),(257,45),(258,46),(259,47),(259,48),(260,49),(261,50),(261,51),(261,52),(261,53),(263,54),(263,55),(269,56),(275,57),(275,58),(304,59),(664,59),(311,60),(311,61),(331,62),(332,62),(333,62),(334,62),(335,62),(342,62),(343,62),(344,62),(345,62),(346,62),(347,62),(354,62),(356,62),(357,62),(358,62),(359,62),(360,62),(361,62),(362,62),(363,62),(364,62),(365,62),(366,62),(367,62),(368,62),(369,62),(370,62),(371,62),(372,62),(373,62),(374,62),(375,62),(376,62),(377,62),(378,62),(379,62),(380,62),(381,62),(382,62),(383,62),(384,62),(385,62),(386,62),(387,62),(388,62),(389,62),(390,62),(391,62),(392,62),(393,62),(394,62),(395,62),(396,62),(397,62),(398,62),(408,62),(409,62),(333,63),(403,64),(403,65),(410,66),(414,67),(425,68),(431,69),(432,69),(433,69),(453,70),(460,71),(460,72),(466,73),(466,74),(622,75),(632,76),(651,77),(657,78),(678,79),(689,80),(696,81),(701,82),(707,83),(711,84),(711,85),(711,86),(712,87),(732,88),(733,89),(804,90),(804,91),(805,92),(805,93),(806,94),(806,95),(807,96),(807,97),(808,98),(808,99),(809,100),(810,101),(811,102),(812,103),(812,104),(816,105),(816,106);
/*!40000 ALTER TABLE `help_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_topic`
--

DROP TABLE IF EXISTS `help_topic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_topic` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `help_category_id` smallint(5) unsigned NOT NULL,
  `description` text NOT NULL,
  `example` text NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_topic_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help topics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_topic`
--

LOCK TABLES `help_topic` WRITE;
/*!40000 ALTER TABLE `help_topic` DISABLE KEYS */;
INSERT INTO `help_topic` (`help_topic_id`, `name`, `help_category_id`, `description`, `example`, `url`) VALUES (1,'HELP_DATE',9,'Help Contents generated from the MariaDB Knowledge Base on 23 January 2023.','',''),(2,'HELP_VERSION',9,'Help Contents generated for MariaDB 10.5 from the MariaDB Knowledge Base on 23 January 2023.','',''),(3,'AREA',2,'A synonym for ST_AREA.\n\nURL: https://mariadb.com/kb/en/polygon-properties-area/','','https://mariadb.com/kb/en/polygon-properties-area/'),(4,'CENTROID',2,'A synonym for ST_CENTROID.\n\nURL: https://mariadb.com/kb/en/centroid/','','https://mariadb.com/kb/en/centroid/'),(5,'ExteriorRing',2,'A synonym for ST_ExteriorRing.\n\nURL: https://mariadb.com/kb/en/polygon-properties-exteriorring/','','https://mariadb.com/kb/en/polygon-properties-exteriorring/'),(6,'InteriorRingN',2,'A synonym for ST_InteriorRingN.\n\nURL: https://mariadb.com/kb/en/polygon-properties-interiorringn/','','https://mariadb.com/kb/en/polygon-properties-interiorringn/'),(7,'NumInteriorRings',2,'A synonym for ST_NumInteriorRings.\n\nURL: https://mariadb.com/kb/en/polygon-properties-numinteriorrings/','','https://mariadb.com/kb/en/polygon-properties-numinteriorrings/'),(8,'ST_AREA',2,'Syntax\n------\n\nST_Area(poly)\nArea(poly)\n\nDescription\n-----------\n\nReturns as a double-precision number the area of the Polygon value poly, as\nmeasured in its spatial reference system.\n\nST_Area() and Area() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\n\nSELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+\n\nURL: https://mariadb.com/kb/en/st_area/','','https://mariadb.com/kb/en/st_area/'),(9,'ST_CENTROID',2,'Syntax\n------\n\nST_Centroid(mpoly)\nCentroid(mpoly)\n\nDescription\n-----------\n\nReturns a point reflecting the mathematical centroid (geometric center) for\nthe MultiPolygon mpoly. The resulting point will not necessarily be on the\nMultiPolygon.\n\nST_Centroid() and Centroid() are synonyms.\n\nExamples\n--------\n\nSET @poly = ST_GeomFromText(\'POLYGON((0 0,20 0,20 20,0 20,0 0))\');\nSELECT ST_AsText(ST_Centroid(@poly)) AS center;\n+--------------+\n| center       |\n+--------------+\n| POINT(10 10) |\n+--------------+\n\nURL: https://mariadb.com/kb/en/st_centroid/','','https://mariadb.com/kb/en/st_centroid/'),(10,'ST_ExteriorRing',2,'Syntax\n------\n\nST_ExteriorRing(poly)\nExteriorRing(poly)\n\nDescription\n-----------\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nST_ExteriorRing() and ExteriorRing() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_exteriorring/','','https://mariadb.com/kb/en/st_exteriorring/'),(11,'ST_InteriorRingN',2,'Syntax\n------\n\nST_InteriorRingN(poly,N)\nInteriorRingN(poly,N)\n\nDescription\n-----------\n\nReturns the N-th interior ring for the Polygon value poly as a LineString.\nRings are numbered beginning with 1.\n\nST_InteriorRingN() and InteriorRingN() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_interiorringn/','','https://mariadb.com/kb/en/st_interiorringn/'),(12,'ST_NumInteriorRings',2,'Syntax\n------\n\nST_NumInteriorRings(poly)\nNumInteriorRings(poly)\n\nDescription\n-----------\n\nReturns an integer containing the number of interior rings in the Polygon\nvalue poly.\n\nNote that according the the OpenGIS standard, a POLYGON should have exactly\none ExteriorRing and all other rings should lie within that ExteriorRing and\nthus be the InteriorRings. Practically, however, some systems, including\nMariaDB\'s, permit polygons to have several \'ExteriorRings\'. In the case of\nthere being multiple, non-overlapping exterior rings ST_NumInteriorRings()\nwill return 1.\n\nST_NumInteriorRings() and NumInteriorRings() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\n\nNon-overlapping \'polygon\':\n\nSELECT ST_NumInteriorRings(ST_PolyFromText(\'POLYGON((0 0,10 0,10 10,0 10,0 0),\n (-1 -1,-5 -1,-5 -5,-1 -5,-1 -1))\')) AS NumInteriorRings;\n+------------------+\n| NumInteriorRings |\n+------------------+\n|                1 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/st_numinteriorrings/','','https://mariadb.com/kb/en/st_numinteriorrings/'),(14,'AsText',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-astext/','','https://mariadb.com/kb/en/wkt-astext/'),(15,'AsWKT',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-aswkt/','','https://mariadb.com/kb/en/wkt-aswkt/'),(16,'GeomCollFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomcollfromtext/','','https://mariadb.com/kb/en/wkt-geomcollfromtext/'),(17,'GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/geometrycollectionfromtext/','','https://mariadb.com/kb/en/geometrycollectionfromtext/'),(18,'GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/geometryfromtext/','','https://mariadb.com/kb/en/geometryfromtext/'),(19,'GeomFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomfromtext/','','https://mariadb.com/kb/en/wkt-geomfromtext/'),(20,'LineFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/wkt-linefromtext/','','https://mariadb.com/kb/en/wkt-linefromtext/'),(21,'LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/linestringfromtext/','','https://mariadb.com/kb/en/linestringfromtext/'),(22,'MLineFromText',3,'Syntax\n------\n\nMLineFromText(wkt[,srid])\nMultiLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTILINESTRING value using its WKT representation and SRID.\n\nMLineFromText() and MultiLineStringFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nSHOW FIELDS FROM gis_multi_line;\nINSERT INTO gis_multi_line VALUES\n  (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16\n23,16 48))\')),\n  (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n  (MLineFromWKB(AsWKB(MultiLineString(\n   LineString(Point(1, 2), Point(3, 5)),\n   LineString(Point(2, 5), Point(5, 8), Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/mlinefromtext/','','https://mariadb.com/kb/en/mlinefromtext/'),(23,'MPointFromText',3,'Syntax\n------\n\nMPointFromText(wkt[,srid])\nMultiPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n\nMPointFromText() and MultiPointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nSHOW FIELDS FROM gis_multi_point;\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/mpointfromtext/','','https://mariadb.com/kb/en/mpointfromtext/'),(13,'WKT Definition',3,'Description\n-----------\n\nThe Well-Known Text (WKT) representation of Geometry is designed to exchange\ngeometry data in ASCII form. Examples of the basic geometry types include:\n\n+-----------------------------------------------------------------------------+\n| Geometry Types                                                              |\n+-----------------------------------------------------------------------------+\n| POINT                                                                       |\n+-----------------------------------------------------------------------------+\n| LINESTRING                                                                  |\n+-----------------------------------------------------------------------------+\n| POLYGON                                                                     |\n+-----------------------------------------------------------------------------+\n| MULTIPOINT                                                                  |\n+-----------------------------------------------------------------------------+\n| MULTILINESTRING                                                             |\n+-----------------------------------------------------------------------------+\n| MULTIPOLYGON                                                                |\n+-----------------------------------------------------------------------------+\n| GEOMETRYCOLLECTION                                                          |\n+-----------------------------------------------------------------------------+\n| GEOMETRY                                                                    |\n+-----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/wkt-definition/','','https://mariadb.com/kb/en/wkt-definition/'),(24,'MPolyFromText',3,'Syntax\n------\n\nMPolyFromText(wkt[,srid])\nMultiPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n\nMPolyFromText() and MultiPolygonFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_polygon  (g MULTIPOLYGON);\nSHOW FIELDS FROM gis_multi_polygon;\nINSERT INTO gis_multi_polygon VALUES\n  (MultiPolygonFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromWKB(AsWKB(MultiPolygon(Polygon(\n   LineString(Point(0, 3), Point(3, 3), Point(3, 0), Point(0, 3)))))));\n\nURL: https://mariadb.com/kb/en/mpolyfromtext/','','https://mariadb.com/kb/en/mpolyfromtext/'),(25,'MultiLineStringFromText',3,'A synonym for MLineFromText.\n\nURL: https://mariadb.com/kb/en/multilinestringfromtext/','','https://mariadb.com/kb/en/multilinestringfromtext/'),(26,'MultiPointFromText',3,'A synonym for MPointFromText.\n\nURL: https://mariadb.com/kb/en/multipointfromtext/','','https://mariadb.com/kb/en/multipointfromtext/'),(27,'MultiPolygonFromText',3,'A synonym for MPolyFromText.\n\nURL: https://mariadb.com/kb/en/multipolygonfromtext/','','https://mariadb.com/kb/en/multipolygonfromtext/'),(28,'PointFromText',3,'A synonym for ST_PointFromText.\n\nURL: https://mariadb.com/kb/en/wkt-pointfromtext/','','https://mariadb.com/kb/en/wkt-pointfromtext/'),(29,'PolyFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/wkt-polyfromtext/','','https://mariadb.com/kb/en/wkt-polyfromtext/'),(30,'PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/polygonfromtext/','','https://mariadb.com/kb/en/polygonfromtext/'),(31,'ST_AsText',3,'Syntax\n------\n\nST_AsText(g)\nAsText(g)\nST_AsWKT(g)\nAsWKT(g)\n\nDescription\n-----------\n\nConverts a value in internal geometry format to its WKT representation and\nreturns the string result.\n\nST_AsText(), AsText(), ST_AsWKT() and AsWKT() are all synonyms.\n\nExamples\n--------\n\nSET @g = \'LineString(1 1,4 4,6 6)\';\n\nSELECT ST_AsText(ST_GeomFromText(@g));\n+--------------------------------+\n| ST_AsText(ST_GeomFromText(@g)) |\n+--------------------------------+\n| LINESTRING(1 1,4 4,6 6)        |\n+--------------------------------+\n\nURL: https://mariadb.com/kb/en/st_astext/','','https://mariadb.com/kb/en/st_astext/'),(32,'ST_ASWKT',3,'A synonym for ST_ASTEXT().\n\nURL: https://mariadb.com/kb/en/st_aswkt/','','https://mariadb.com/kb/en/st_aswkt/'),(33,'ST_GeomCollFromText',3,'Syntax\n------\n\nST_GeomCollFromText(wkt[,srid])\nST_GeometryCollectionFromText(wkt[,srid])\nGeomCollFromText(wkt[,srid])\nGeometryCollectionFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and SRID.\n\nST_GeomCollFromText(), ST_GeometryCollectionFromText(), GeomCollFromText() and\nGeometryCollectionFromText() are all synonyms.\n\nExample\n-------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/st_geomcollfromtext/','','https://mariadb.com/kb/en/st_geomcollfromtext/'),(34,'ST_GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/st_geometrycollectionfromtext/','','https://mariadb.com/kb/en/st_geometrycollectionfromtext/'),(35,'ST_GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/st_geometryfromtext/','','https://mariadb.com/kb/en/st_geometryfromtext/'),(36,'ST_GeomFromText',3,'Syntax\n------\n\nST_GeomFromText(wkt[,srid])\nST_GeometryFromText(wkt[,srid])\nGeomFromText(wkt[,srid])\nGeometryFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a geometry value of any type using its WKT representation and SRID.\n\nGeomFromText(), GeometryFromText(), ST_GeomFromText() and\nST_GeometryFromText() are all synonyms.\n\nExample\n-------\n\nSET @g = ST_GEOMFROMTEXT(\'POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1 1))\');\n\nURL: https://mariadb.com/kb/en/st_geomfromtext/','','https://mariadb.com/kb/en/st_geomfromtext/'),(37,'ST_LineFromText',3,'Syntax\n------\n\nST_LineFromText(wkt[,srid])\nST_LineStringFromText(wkt[,srid])\nLineFromText(wkt[,srid])\nLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a LINESTRING value using its WKT representation and SRID.\n\nST_LineFromText(), ST_LineStringFromText(), ST_LineFromText() and\nST_LineStringFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_line  (g LINESTRING);\nSHOW FIELDS FROM gis_line;\nINSERT INTO gis_line VALUES\n  (LineFromText(\'LINESTRING(0 0,0 10,10 0)\')),\n  (LineStringFromText(\'LINESTRING(10 10,20 10,20 20,10 20,10 10)\')),\n  (LineStringFromWKB(AsWKB(LineString(Point(10, 10), Point(40, 10)))));\n\nURL: https://mariadb.com/kb/en/st_linefromtext/','','https://mariadb.com/kb/en/st_linefromtext/'),(38,'ST_LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/st_linestringfromtext/','','https://mariadb.com/kb/en/st_linestringfromtext/'),(39,'ST_PointFromText',3,'Syntax\n------\n\nST_PointFromText(wkt[,srid])\nPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POINT value using its WKT representation and SRID.\n\nST_PointFromText() and PointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_point  (g POINT);\nSHOW FIELDS FROM gis_point;\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/st_pointfromtext/','','https://mariadb.com/kb/en/st_pointfromtext/'),(40,'ST_PolyFromText',3,'Syntax\n------\n\nST_PolyFromText(wkt[,srid])\nST_PolygonFromText(wkt[,srid])\nPolyFromText(wkt[,srid])\nPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POLYGON value using its WKT representation and SRID.\n\nST_PolyFromText(), ST_PolygonFromText(), PolyFromText() and\nST_PolygonFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_polygon   (g POLYGON);\nINSERT INTO gis_polygon VALUES\n  (PolygonFromText(\'POLYGON((10 10,20 10,20 20,10 20,10 10))\')),\n  (PolyFromText(\'POLYGON((0 0,50 0,50 50,0 50,0 0), (10 10,20 10,20 20,10\n20,10 10))\'));\n\nURL: https://mariadb.com/kb/en/st_polyfromtext/','','https://mariadb.com/kb/en/st_polyfromtext/'),(41,'ST_PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/st_polygonfromtext/','','https://mariadb.com/kb/en/st_polygonfromtext/'),(42,'DIV',4,'Syntax\n------\n\nDIV\n\nDescription\n-----------\n\nInteger division. Similar to FLOOR(), but is safe with BIGINT values.\nIncorrect results may occur for non-integer operands that exceed BIGINT range.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, a division by zero produces\nan error. Otherwise, it returns NULL.\n\nThe remainder of a division can be obtained using the MOD operator.\n\nExamples\n--------\n\nSELECT 300 DIV 7;\n+-----------+\n| 300 DIV 7 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT 300 DIV 0;\n+-----------+\n| 300 DIV 0 |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/div/','','https://mariadb.com/kb/en/div/'),(43,'ABS',4,'Syntax\n------\n\nABS(X)\n\nDescription\n-----------\n\nReturns the absolute (non-negative) value of X. If X is not a number, it is\nconverted to a numeric type.\n\nExamples\n--------\n\nSELECT ABS(42);\n+---------+\n| ABS(42) |\n+---------+\n|      42 |\n+---------+\n\nSELECT ABS(-42);\n+----------+\n| ABS(-42) |\n+----------+\n|       42 |\n+----------+\n\nSELECT ABS(DATE \'1994-01-01\');\n+------------------------+\n| ABS(DATE \'1994-01-01\') |\n+------------------------+\n|               19940101 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/abs/','','https://mariadb.com/kb/en/abs/'),(44,'ACOS',4,'Syntax\n------\n\nACOS(X)\n\nDescription\n-----------\n\nReturns the arc cosine of X, that is, the value whose cosine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ACOS(1);\n+---------+\n| ACOS(1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ACOS(1.0001);\n+--------------+\n| ACOS(1.0001) |\n+--------------+\n|         NULL |\n+--------------+\n\nSELECT ACOS(0);\n+-----------------+\n| ACOS(0)         |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT ACOS(0.234);\n+------------------+\n| ACOS(0.234)      |\n+------------------+\n| 1.33460644244679 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/acos/','','https://mariadb.com/kb/en/acos/'),(45,'ASIN',4,'Syntax\n------\n\nASIN(X)\n\nDescription\n-----------\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns NULL if\nX is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ASIN(0.2);\n+--------------------+\n| ASIN(0.2)          |\n+--------------------+\n| 0.2013579207903308 |\n+--------------------+\n\nSELECT ASIN(\'foo\');\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n\nSHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n\nURL: https://mariadb.com/kb/en/asin/','','https://mariadb.com/kb/en/asin/'),(46,'ATAN',4,'Syntax\n------\n\nATAN(X)\n\nDescription\n-----------\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nExamples\n--------\n\nSELECT ATAN(2);\n+--------------------+\n| ATAN(2)            |\n+--------------------+\n| 1.1071487177940904 |\n+--------------------+\n\nSELECT ATAN(-2);\n+---------------------+\n| ATAN(-2)            |\n+---------------------+\n| -1.1071487177940904 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/atan/','','https://mariadb.com/kb/en/atan/'),(47,'ATAN2',4,'Syntax\n------\n\nATAN(Y,X), ATAN2(Y,X)\n\nDescription\n-----------\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both arguments\nare used to determine the quadrant of the result.\n\nExamples\n--------\n\nSELECT ATAN(-2,2);\n+---------------------+\n| ATAN(-2,2)          |\n+---------------------+\n| -0.7853981633974483 |\n+---------------------+\n\nSELECT ATAN2(PI(),0);\n+--------------------+\n| ATAN2(PI(),0)      |\n+--------------------+\n| 1.5707963267948966 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/atan2/','','https://mariadb.com/kb/en/atan2/'),(48,'CEIL',4,'Syntax\n------\n\nCEIL(X)\n\nDescription\n-----------\n\nCEIL() is a synonym for CEILING().\n\nURL: https://mariadb.com/kb/en/ceil/','','https://mariadb.com/kb/en/ceil/'),(49,'CEILING',4,'Syntax\n------\n\nCEILING(X)\n\nDescription\n-----------\n\nReturns the smallest integer value not less than X.\n\nExamples\n--------\n\nSELECT CEILING(1.23);\n+---------------+\n| CEILING(1.23) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT CEILING(-1.23);\n+----------------+\n| CEILING(-1.23) |\n+----------------+\n|             -1 |\n+----------------+\n\nURL: https://mariadb.com/kb/en/ceiling/','','https://mariadb.com/kb/en/ceiling/'),(51,'COS',4,'Syntax\n------\n\nCOS(X)\n\nDescription\n-----------\n\nReturns the cosine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT COS(PI());\n+-----------+\n| COS(PI()) |\n+-----------+\n|        -1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/cos/','','https://mariadb.com/kb/en/cos/'),(52,'COT',4,'Syntax\n------\n\nCOT(X)\n\nDescription\n-----------\n\nReturns the cotangent of X.\n\nExamples\n--------\n\nSELECT COT(42);\n+--------------------+\n| COT(42)            |\n+--------------------+\n| 0.4364167060752729 |\n+--------------------+\n\nSELECT COT(12);\n+---------------------+\n| COT(12)             |\n+---------------------+\n| -1.5726734063976893 |\n+---------------------+\n\nSELECT COT(0);\nERROR 1690 (22003): DOUBLE value is out of range in \'cot(0)\'\n\nURL: https://mariadb.com/kb/en/cot/','','https://mariadb.com/kb/en/cot/'),(54,'DEGREES',4,'Syntax\n------\n\nDEGREES(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from radians to degrees.\n\nThis is the converse of the RADIANS() function.\n\nExamples\n--------\n\nSELECT DEGREES(PI());\n+---------------+\n| DEGREES(PI()) |\n+---------------+\n|           180 |\n+---------------+\n\nSELECT DEGREES(PI() / 2);\n+-------------------+\n| DEGREES(PI() / 2) |\n+-------------------+\n|                90 |\n+-------------------+\n\nSELECT DEGREES(45);\n+-----------------+\n| DEGREES(45)     |\n+-----------------+\n| 2578.3100780887 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/degrees/','','https://mariadb.com/kb/en/degrees/'),(55,'EXP',4,'Syntax\n------\n\nEXP(X)\n\nDescription\n-----------\n\nReturns the value of e (the base of natural logarithms) raised to the power of\nX. The inverse of this function is LOG() (using a single argument only) or\nLN().\n\nIf X is NULL, this function returns NULL.\n\nExamples\n--------\n\nSELECT EXP(2);\n+------------------+\n| EXP(2)           |\n+------------------+\n| 7.38905609893065 |\n+------------------+\n\nSELECT EXP(-2);\n+--------------------+\n| EXP(-2)            |\n+--------------------+\n| 0.1353352832366127 |\n+--------------------+\n\nSELECT EXP(0);\n+--------+\n| EXP(0) |\n+--------+\n|      1 |\n+--------+\n\nSELECT EXP(NULL);\n+-----------+\n| EXP(NULL) |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/exp/','','https://mariadb.com/kb/en/exp/'),(50,'CONV',4,'Syntax\n------\n\nCONV(N,from_base,to_base)\n\nDescription\n-----------\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base to_base.\n\nReturns NULL if any argument is NULL, or if the second or third argument are\nnot in the allowed range.\n\nThe argument N is interpreted as an integer, but may be specified as an\ninteger or a string. The minimum base is 2 and the maximum base is 36. If\nto_base is a negative number, N is regarded as a signed number. Otherwise, N\nis treated as unsigned. CONV() works with 64-bit precision.\n\nSome shortcuts for this function are also available: BIN(), OCT(), HEX(),\nUNHEX(). Also, MariaDB allows binary literal values and hexadecimal literal\nvalues.\n\nExamples\n--------\n\nSELECT CONV(\'a\',16,2);\n+----------------+\n| CONV(\'a\',16,2) |\n+----------------+\n| 1010           |\n+----------------+\n\nSELECT CONV(\'6E\',18,8);\n+-----------------+\n| CONV(\'6E\',18,8) |\n+-----------------+\n| 172             |\n+-----------------+\n\nSELECT CONV(-17,10,-18);\n+------------------+\n| CONV(-17,10,-18) |\n+------------------+\n| -H               |\n+------------------+\n\nSELECT CONV(12+\'10\'+\'10\'+0xa,10,10);\n+------------------------------+\n| CONV(12+\'10\'+\'10\'+0xa,10,10) |\n+------------------------------+\n| 42                           |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/conv/','','https://mariadb.com/kb/en/conv/'),(53,'CRC32',4,'Syntax\n------\n\n<= MariaDB 10.7\n\nCRC32(expr)\n\nFrom MariaDB 10.8\n\nCRC32([par,]expr)\n\nDescription\n-----------\n\nComputes a cyclic redundancy check (CRC) value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is expected to\nbe a string and (if possible) is treated as one if it is not.\n\nUses the ISO 3309 polynomial that used by zlib and many others. MariaDB 10.8\nintroduced the CRC32C() function, which uses the alternate Castagnoli\npolynomia.\n\nMariaDB starting with 10.8\n--------------------------\nOften, CRC is computed in pieces. To facilitate this, MariaDB 10.8.0\nintroduced an optional parameter: CRC32(\'MariaDB\')=CRC32(CRC32(\'Maria\'),\'DB\').\n\nExamples\n--------\n\nSELECT CRC32(\'MariaDB\');\n+------------------+\n| CRC32(\'MariaDB\') |\n+------------------+\n|       4227209140 |\n+------------------+\n\nSELECT CRC32(\'mariadb\');\n+------------------+\n| CRC32(\'mariadb\') |\n+------------------+\n|       2594253378 |\n+------------------+\n\nFrom MariaDB 10.8.0\n\nSELECT CRC32(CRC32(\'Maria\'),\'DB\');\n+----------------------------+\n| CRC32(CRC32(\'Maria\'),\'DB\') |\n+----------------------------+\n|                 4227209140 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/crc32/','','https://mariadb.com/kb/en/crc32/'),(56,'FLOOR',4,'Syntax\n------\n\nFLOOR(X)\n\nDescription\n-----------\n\nReturns the largest integer value not greater than X.\n\nExamples\n--------\n\nSELECT FLOOR(1.23);\n+-------------+\n| FLOOR(1.23) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT FLOOR(-1.23);\n+--------------+\n| FLOOR(-1.23) |\n+--------------+\n|           -2 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/floor/','','https://mariadb.com/kb/en/floor/'),(57,'LN',4,'Syntax\n------\n\nLN(X)\n\nDescription\n-----------\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X. If X\nis less than or equal to 0, or NULL, then NULL is returned.\n\nThe inverse of this function is EXP().\n\nExamples\n--------\n\nSELECT LN(2);\n+-------------------+\n| LN(2)             |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LN(-2);\n+--------+\n| LN(-2) |\n+--------+\n|   NULL |\n+--------+\n\nURL: https://mariadb.com/kb/en/ln/','','https://mariadb.com/kb/en/ln/'),(58,'LOG',4,'Syntax\n------\n\nLOG(X), LOG(B,X)\n\nDescription\n-----------\n\nIf called with one parameter, this function returns the natural logarithm of\nX. If X is less than or equal to 0, then NULL is returned.\n\nIf called with two parameters, it returns the logarithm of X to the base B. If\nB is <= 1 or X <= 0, the function returns NULL.\n\nIf any argument is NULL, the function returns NULL.\n\nThe inverse of this function (when called with a single argument) is the EXP()\nfunction.\n\nExamples\n--------\n\nLOG(X):\n\nSELECT LOG(2);\n+-------------------+\n| LOG(2)            |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LOG(-2);\n+---------+\n| LOG(-2) |\n+---------+\n|    NULL |\n+---------+\n\nLOG(B,X)\n\nSELECT LOG(2,16);\n+-----------+\n| LOG(2,16) |\n+-----------+\n|         4 |\n+-----------+\n\nSELECT LOG(3,27);\n+-----------+\n| LOG(3,27) |\n+-----------+\n|         3 |\n+-----------+\n\nSELECT LOG(3,1);\n+----------+\n| LOG(3,1) |\n+----------+\n|        0 |\n+----------+\n\nSELECT LOG(3,0);\n+----------+\n| LOG(3,0) |\n+----------+\n|     NULL |\n+----------+\n\nURL: https://mariadb.com/kb/en/log/','','https://mariadb.com/kb/en/log/'),(59,'LOG10',4,'Syntax\n------\n\nLOG10(X)\n\nDescription\n-----------\n\nReturns the base-10 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG10(2);\n+-------------------+\n| LOG10(2)          |\n+-------------------+\n| 0.301029995663981 |\n+-------------------+\n\nSELECT LOG10(100);\n+------------+\n| LOG10(100) |\n+------------+\n|          2 |\n+------------+\n\nSELECT LOG10(-100);\n+-------------+\n| LOG10(-100) |\n+-------------+\n|        NULL |\n+-------------+\n\nURL: https://mariadb.com/kb/en/log10/','','https://mariadb.com/kb/en/log10/'),(60,'LOG2',4,'Syntax\n------\n\nLOG2(X)\n\nDescription\n-----------\n\nReturns the base-2 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG2(4398046511104);\n+---------------------+\n| LOG2(4398046511104) |\n+---------------------+\n|                  42 |\n+---------------------+\n\nSELECT LOG2(65536);\n+-------------+\n| LOG2(65536) |\n+-------------+\n|          16 |\n+-------------+\n\nSELECT LOG2(-100);\n+------------+\n| LOG2(-100) |\n+------------+\n|       NULL |\n+------------+\n\nURL: https://mariadb.com/kb/en/log2/','','https://mariadb.com/kb/en/log2/'),(62,'OCT',4,'Syntax\n------\n\nOCT(N)\n\nDescription\n-----------\n\nReturns a string representation of the octal value of N, where N is a longlong\n(BIGINT) number. This is equivalent to CONV(N,10,8). Returns NULL if N is NULL.\n\nExamples\n--------\n\nSELECT OCT(34);\n+---------+\n| OCT(34) |\n+---------+\n| 42      |\n+---------+\n\nSELECT OCT(12);\n+---------+\n| OCT(12) |\n+---------+\n| 14      |\n+---------+\n\nURL: https://mariadb.com/kb/en/oct/','','https://mariadb.com/kb/en/oct/'),(63,'PI',4,'Syntax\n------\n\nPI()\n\nDescription\n-----------\n\nReturns the value of π (pi). The default number of decimal places displayed is\nsix, but MariaDB uses the full double-precision value internally.\n\nExamples\n--------\n\nSELECT PI();\n+----------+\n| PI()     |\n+----------+\n| 3.141593 |\n+----------+\n\nSELECT PI()+0.0000000000000000000000;\n+-------------------------------+\n| PI()+0.0000000000000000000000 |\n+-------------------------------+\n|      3.1415926535897931159980 |\n+-------------------------------+\n\nURL: https://mariadb.com/kb/en/pi/','','https://mariadb.com/kb/en/pi/'),(64,'POW',4,'Syntax\n------\n\nPOW(X,Y)\n\nDescription\n-----------\n\nReturns the value of X raised to the power of Y.\n\nPOWER() is a synonym.\n\nExamples\n--------\n\nSELECT POW(2,3);\n+----------+\n| POW(2,3) |\n+----------+\n|        8 |\n+----------+\n\nSELECT POW(2,-2);\n+-----------+\n| POW(2,-2) |\n+-----------+\n|      0.25 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/pow/','','https://mariadb.com/kb/en/pow/'),(65,'POWER',4,'Syntax\n------\n\nPOWER(X,Y)\n\nDescription\n-----------\n\nThis is a synonym for POW(), which returns the value of X raised to the power\nof Y.\n\nURL: https://mariadb.com/kb/en/power/','','https://mariadb.com/kb/en/power/'),(61,'MOD',4,'Syntax\n------\n\nMOD(N,M), N % M, N MOD M\n\nDescription\n-----------\n\nModulo operation. Returns the remainder of N divided by M. See also Modulo\nOperator.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, any number modulus zero\nproduces an error. Otherwise, it returns NULL.\n\nThe integer part of a division can be obtained using DIV.\n\nExamples\n--------\n\nSELECT 1042 % 50;\n+-----------+\n| 1042 % 50 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT MOD(234, 10);\n+--------------+\n| MOD(234, 10) |\n+--------------+\n|            4 |\n+--------------+\n\nSELECT 253 % 7;\n+---------+\n| 253 % 7 |\n+---------+\n|       1 |\n+---------+\n\nSELECT MOD(29,9);\n+-----------+\n| MOD(29,9) |\n+-----------+\n|         2 |\n+-----------+\n\nSELECT 29 MOD 9;\n+----------+\n| 29 MOD 9 |\n+----------+\n|        2 |\n+----------+\n\nURL: https://mariadb.com/kb/en/mod/','','https://mariadb.com/kb/en/mod/'),(66,'RADIANS',4,'Syntax\n------\n\nRADIANS(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from degrees to radians. Note that π radians\nequals 180 degrees.\n\nThis is the converse of the DEGREES() function.\n\nExamples\n--------\n\nSELECT RADIANS(45);\n+-------------------+\n| RADIANS(45)       |\n+-------------------+\n| 0.785398163397448 |\n+-------------------+\n\nSELECT RADIANS(90);\n+-----------------+\n| RADIANS(90)     |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT RADIANS(PI());\n+--------------------+\n| RADIANS(PI())      |\n+--------------------+\n| 0.0548311355616075 |\n+--------------------+\n\nSELECT RADIANS(180);\n+------------------+\n| RADIANS(180)     |\n+------------------+\n| 3.14159265358979 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/radians/','','https://mariadb.com/kb/en/radians/'),(67,'RAND',4,'Syntax\n------\n\nRAND(), RAND(N)\n\nDescription\n-----------\n\nReturns a random DOUBLE precision floating point value v in the range 0 <= v <\n1.0. If a constant integer argument N is specified, it is used as the seed\nvalue, which produces a repeatable sequence of column values. In the example\nbelow, note that the sequences of values produced by RAND(3) is the same both\nplaces where it occurs.\n\nIn a WHERE clause, RAND() is evaluated each time the WHERE is executed.\n\nStatements using the RAND() function are not safe for statement-based\nreplication.\n\nPractical uses\n--------------\n\nThe expression to get a random integer from a given range is the following:\n\nFLOOR(min_value + RAND() * (max_value - min_value +1))\n\nRAND() is often used to read random rows from a table, as follows:\n\nSELECT * FROM my_table ORDER BY RAND() LIMIT 10;\n\nNote, however, that this technique should never be used on a large table as it\nwill be extremely slow. MariaDB will read all rows in the table, generate a\nrandom value for each of them, order them, and finally will apply the LIMIT\nclause.\n\nExamples\n--------\n\nCREATE TABLE t (i INT);\n\nINSERT INTO t VALUES(1),(2),(3);\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.255651095188829 |\n|    2 | 0.833920199269355 |\n|    3 |  0.40264774151393 |\n+------+-------------------+\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.511478140495232 |\n|    2 | 0.349447508668012 |\n|    3 | 0.212803152588013 |\n+------+-------------------+\n\nUsing the same seed, the same sequence will be returned:\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nGenerating a random number from 5 to 15:\n\nSELECT FLOOR(5 + (RAND() * 11));\n\nURL: https://mariadb.com/kb/en/rand/','','https://mariadb.com/kb/en/rand/'),(68,'ROUND',4,'Syntax\n------\n\nROUND(X), ROUND(X,D)\n\nDescription\n-----------\n\nRounds the argument X to D decimal places. D defaults to 0 if not specified. D\ncan be negative to cause D digits left of the decimal point of the value X to\nbecome zero.\n\nThe rounding algorithm depends on the data type of X:\n\n* for floating point types (FLOAT, DOUBLE) the C libraries rounding function\nis used, so the behavior *may* differ between operating systems\n* for fixed point types (DECIMAL, DEC/NUMBER/FIXED) the \"round half up\" rule\nis used, meaning that e.g. a value ending in exactly .5 is always rounded up.\n\nExamples\n--------\n\nSELECT ROUND(-1.23);\n+--------------+\n| ROUND(-1.23) |\n+--------------+\n|           -1 |\n+--------------+\n\nSELECT ROUND(-1.58);\n+--------------+\n| ROUND(-1.58) |\n+--------------+\n|           -2 |\n+--------------+\n\nSELECT ROUND(1.58); \n+-------------+\n| ROUND(1.58) |\n+-------------+\n|           2 |\n+-------------+\n\nSELECT ROUND(1.298, 1);\n+-----------------+\n| ROUND(1.298, 1) |\n+-----------------+\n|             1.3 |\n+-----------------+\n\nSELECT ROUND(1.298, 0);\n+-----------------+\n| ROUND(1.298, 0) |\n+-----------------+\n|               1 |\n+-----------------+\n\nSELECT ROUND(23.298, -1);\n+-------------------+\n| ROUND(23.298, -1) |\n+-------------------+\n|                20 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/round/','','https://mariadb.com/kb/en/round/'),(69,'SIGN',4,'Syntax\n------\n\nSIGN(X)\n\nDescription\n-----------\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X is\nnegative, zero, or positive.\n\nExamples\n--------\n\nSELECT SIGN(-32);\n+-----------+\n| SIGN(-32) |\n+-----------+\n|        -1 |\n+-----------+\n\nSELECT SIGN(0);\n+---------+\n| SIGN(0) |\n+---------+\n|       0 |\n+---------+\n\nSELECT SIGN(234);\n+-----------+\n| SIGN(234) |\n+-----------+\n|         1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/sign/','','https://mariadb.com/kb/en/sign/'),(70,'SIN',4,'Syntax\n------\n\nSIN(X)\n\nDescription\n-----------\n\nReturns the sine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT SIN(1.5707963267948966);\n+-------------------------+\n| SIN(1.5707963267948966) |\n+-------------------------+\n|                       1 |\n+-------------------------+\n\nSELECT SIN(PI());\n+----------------------+\n| SIN(PI())            |\n+----------------------+\n| 1.22460635382238e-16 |\n+----------------------+\n\nSELECT ROUND(SIN(PI()));\n+------------------+\n| ROUND(SIN(PI())) |\n+------------------+\n|                0 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/sin/','','https://mariadb.com/kb/en/sin/'),(71,'SQRT',4,'Syntax\n------\n\nSQRT(X)\n\nDescription\n-----------\n\nReturns the square root of X. If X is negative, NULL is returned.\n\nExamples\n--------\n\nSELECT SQRT(4);\n+---------+\n| SQRT(4) |\n+---------+\n|       2 |\n+---------+\n\nSELECT SQRT(20);\n+------------------+\n| SQRT(20)         |\n+------------------+\n| 4.47213595499958 |\n+------------------+\n\nSELECT SQRT(-16);\n+-----------+\n| SQRT(-16) |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT SQRT(1764);\n+------------+\n| SQRT(1764) |\n+------------+\n|         42 |\n+------------+\n\nURL: https://mariadb.com/kb/en/sqrt/','','https://mariadb.com/kb/en/sqrt/'),(72,'TAN',4,'Syntax\n------\n\nTAN(X)\n\nDescription\n-----------\n\nReturns the tangent of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT TAN(0.7853981633974483);\n+-------------------------+\n| TAN(0.7853981633974483) |\n+-------------------------+\n|      0.9999999999999999 |\n+-------------------------+\n\nSELECT TAN(PI());\n+-----------------------+\n| TAN(PI())             |\n+-----------------------+\n| -1.22460635382238e-16 |\n+-----------------------+\n\nSELECT TAN(PI()+1);\n+-----------------+\n| TAN(PI()+1)     |\n+-----------------+\n| 1.5574077246549 |\n+-----------------+\n\nSELECT TAN(RADIANS(PI()));\n+--------------------+\n| TAN(RADIANS(PI())) |\n+--------------------+\n| 0.0548861508080033 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/tan/','','https://mariadb.com/kb/en/tan/'),(73,'TRUNCATE',4,'This page documents the TRUNCATE function. See TRUNCATE TABLE for the DDL\nstatement.\n\nSyntax\n------\n\nTRUNCATE(X,D)\n\nDescription\n-----------\n\nReturns the number X, truncated to D decimal places. If D is 0, the result has\nno decimal point or fractional part. D can be negative to cause D digits left\nof the decimal point of the value X to become zero.\n\nExamples\n--------\n\nSELECT TRUNCATE(1.223,1);\n+-------------------+\n| TRUNCATE(1.223,1) |\n+-------------------+\n|               1.2 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,1);\n+-------------------+\n| TRUNCATE(1.999,1) |\n+-------------------+\n|               1.9 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,0); \n+-------------------+\n| TRUNCATE(1.999,0) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSELECT TRUNCATE(-1.999,1);\n+--------------------+\n| TRUNCATE(-1.999,1) |\n+--------------------+\n|               -1.9 |\n+--------------------+\n\nSELECT TRUNCATE(122,-2);\n+------------------+\n| TRUNCATE(122,-2) |\n+------------------+\n|              100 |\n+------------------+\n\nSELECT TRUNCATE(10.28*100,0);\n+-----------------------+\n| TRUNCATE(10.28*100,0) |\n+-----------------------+\n|                  1028 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/truncate/','','https://mariadb.com/kb/en/truncate/'),(74,'INSTALL PLUGIN',5,'Syntax\n------\n\nINSTALL PLUGIN [IF NOT EXISTS] plugin_name SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement installs an individual plugin from the specified library. To\ninstall the whole library (which could be required), use INSTALL SONAME. See\nalso Installing a Plugin.\n\nplugin_name is the name of the plugin as defined in the plugin declaration\nstructure contained in the library file. Plugin names are not case sensitive.\nFor maximal compatibility, plugin names should be limited to ASCII letters,\ndigits, and underscore, because they are used in C source files, shell command\nlines, M4 and Bourne shell scripts, and SQL environments.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension can be omitted (which makes the statement look\nthe same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL PLUGIN adds a line to the mysql.plugin table that describes the\nplugin. This table contains the plugin name and library file name.\n\nINSTALL PLUGIN causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL PLUGIN also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL PLUGIN, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nPLUGIN only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a note instead of\nan error if the specified plugin already exists. See SHOW WARNINGS.\n\nExamples\n--------\n\nINSTALL PLUGIN sphinx SONAME \'ha_sphinx.so\';\n\nThe extension can also be omitted:\n\nINSTALL PLUGIN innodb SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected (0.104 sec)\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+------------------------------------+\n| Level | Code | Message                            |\n+-------+------+------------------------------------+\n| Note  | 1968 | Plugin \'example\' already installed |\n+-------+------+------------------------------------+\n\nURL: https://mariadb.com/kb/en/install-plugin/','','https://mariadb.com/kb/en/install-plugin/'),(78,'Plugin Overview',5,'Plugins are server components that enhance MariaDB in some way. These can be\nanything from new storage engines, plugins for enhancing full-text parsing, or\neven small enhancements, such as a plugin to get a timestamp as an integer.\n\nQuerying Plugin Information\n---------------------------\n\nThere are a number of ways to see which plugins are currently active.\n\nA server almost always has a large number of active plugins, because the\nserver contains a large number of built-in plugins, which are active by\ndefault and cannot be uninstalled.\n\nQuerying Plugin Information with SHOW PLUGINS\n---------------------------------------------\n\nThe SHOW PLUGINS statement can be used to query information about all active\nplugins.\n\nFor example:\n\nSHOW PLUGINS\\G;\n********************** 1. row **********************\n Name: binlog\n Status: ACTIVE\n Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n********************** 2. row **********************\n Name: mysql_native_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n********************** 3. row **********************\n Name: mysql_old_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n...\n\nIf a plugin\'s Library column has a NULL value, then the plugin is built-in,\nand it cannot be uninstalled.\n\nQuerying Plugin Information with information_schema.PLUGINS\n-----------------------------------------------------------\n\nThe information_schema.PLUGINS table can be queried to get more detailed\ninformation about plugins.\n\nFor example:\n\nSELECT * FROM information_schema.PLUGINS\\G\n...\n*************************** 6. row ***************************\n     PLUGIN_NAME: CSV\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: Brian Aker, MySQL AB\n  PLUGIN_DESCRIPTION: CSV storage engine\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n*************************** 7. row ***************************\n     PLUGIN_NAME: MEMORY\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: MySQL AB\n  PLUGIN_DESCRIPTION: Hash based, stored in memory, useful for temporary\ntables\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n...\n\nIf a plugin\'s PLUGIN_LIBRARY column has the NULL value, then the plugin is\nbuilt-in, and it cannot be uninstalled.\n\nQuerying Plugin Information with mysql.plugin\n---------------------------------------------\n\nThe mysql.plugin table can be queried to get information about installed\nplugins.\n\nThis table only contains information about plugins that have been installed\nvia the following methods:\n\n* The INSTALL SONAME statement.\n* The INSTALL PLUGIN statement.\n* The mysql_plugin utility.\n\nThis table does not contain information about:\n\n* Built-in plugins.\n* Plugins loaded with the --plugin-load-add option.\n* Plugins loaded with the --plugin-load option.\n\nThis table only contains enough information to reload the plugin when the\nserver is restarted, which means it only contains the plugin name and the\nplugin library.\n\nFor example:\n\nSELECT * FROM mysql.plugin;\n\n+------+------------+\n| name | dl         |\n+------+------------+\n| PBXT | libpbxt.so |\n+------+------------+\n\nInstalling a Plugin\n-------------------\n\nThere are three primary ways to install a plugin:\n\n* A plugin can be installed dynamically with an SQL statement.\n* A plugin can be installed with a mysqld option, but it requires a server\nrestart.\n* A plugin can be installed with the mysql_plugin utility, while the server is\ncompletely offline.\n\nWhen you are installing a plugin, you also have to ensure that:\n\n* The server\'s plugin directory is properly configured, and the plugin\'s\nlibrary is in the plugin directory.\n* The server\'s minimum plugin maturity is properly configured, and the plugin\nis mature enough to be installed.\n\nInstalling a Plugin Dynamically\n-------------------------------\n\nA plugin can be installed dynamically by executing either the INSTALL SONAME\nor the INSTALL PLUGIN statement.\n\nIf a plugin is installed with one of these statements, then a record will be\nadded to the mysql.plugins table for the plugin. This means that the plugin\nwill automatically be loaded every time the server restarts, unless\nspecifically uninstalled or deactivated.\n\nInstalling a Plugin with INSTALL SONAME\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL SONAME\nstatement. INSTALL SONAME installs all plugins from the given plugin library.\nThis could be required for some plugin libraries.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin), you could execute the\nfollowing:\n\nINSTALL SONAME \'server_audit\';\n\nInstalling a Plugin with INSTALL PLUGIN\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL PLUGIN\nstatement. INSTALL PLUGIN installs a single plugin from the given plugin\nlibrary.\n\nFor example, to install the server_audit audit plugin from the server_audit\nplugin library, you could execute the following:\n\nINSTALL PLUGIN server_audit SONAME \'server_audit\';\n\nInstalling a Plugin with Plugin Load Options\n--------------------------------------------\n\nA plugin can be installed with a mysqld option by providing either the\n--plugin-load-add or the --plugin-load option.\n\nIf a plugin is installed with one of these options, then a record will not be\nadded to the mysql.plugins table for the plugin. This means that if the server\nis restarted without the same option set, then the plugin will not\nautomatically be loaded.\n\nInstalling a Plugin with --plugin-load-add\n------------------------------------------\n\nYou can install a plugin with the --plugin-load-add option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load-add option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load-add=\'server_audit\'\n--plugin-load-add=\'ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nSpecial care must be taken when specifying both the --plugin-load option and\nthe --plugin-load-add option together. The --plugin-load option resets the\nplugin load list, and this can cause unexpected problems if you are not aware.\nThe --plugin-load-add option does not reset the plugin load list, so it is\nmuch safer to use. See Specifying Multiple Plugin Load Options for more\ninformation.\n\nInstalling a Plugin with --plugin-load\n--------------------------------------\n\nYou can install a plugin with the --plugin-load option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load=\'server_audit;ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load = server_audit;ed25519=auth_ed25519\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option together. The --plugin-load option resets the plugin\nload list, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use. See Specifying Multiple Plugin Load Options for more information.\n\nSpecifying Multiple Plugin Load Options\n---------------------------------------\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option. The --plugin-load option resets the plugin load\nlist, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use.\n\nThis can have the following consequences:\n\n* If the --plugin-load option is specified multiple times, then only the last\ninstance will have any effect. For example, in the following case, the first\ninstance of the option is reset:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* If the --plugin-load option is specified after the --plugin-load-add option,\nthen it will also reset the changes made by that option. For example, in the\nfollowing case, the --plugin-load-add option does not do anything, because the\nsubsequent --plugin-load option resets the plugin load list:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* In contrast, if the --plugin-load option is specified before the\n--plugin-load-add option, then it will work fine, because the\n--plugin-load-add option does not reset the plugin load list. For example, in\nthe following case, both plugins are properly loaded:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nInstalling a Plugin with mysql_plugin\n-------------------------------------\n\nA plugin can be installed with the mysql_plugin utility if the server is\ncompletely offline.\n\nThe syntax is:\n\nmysql_plugin [options] <plugin> ENABLE|DISABLE\n\nFor example, to install the server_audit audit plugin, you could execute the\nfollowing:\n\nmysql_plugin server_audit ENABLE\n\nIf a plugin is installed with this utility, then a record will be added to the\nmysql.plugins table for the plugin. This means that the plugin will\nautomatically be loaded every time the server restarts, unless specifically\nuninstalled or deactivated.\n\nConfiguring the Plugin Directory\n--------------------------------\n\nWhen a plugin is being installed, the server looks for the plugin\'s library in\nthe server\'s plugin directory. This directory is configured by the plugin_dir\nsystem variable. This can be specified as a command-line argument to mysqld or\nit can be specified in a relevant server option group in an option file. For\nexample:\n\n[mariadb]\n...\nplugin_dir = /usr/lib64/mysql/plugin\n\nConfiguring the Minimum Plugin Maturity\n---------------------------------------\n\nWhen a plugin is being installed, the server compares the plugin\'s maturity\nlevel against the server\'s minimum allowed plugin maturity. This can help\nprevent users from using unstable plugins on production servers. This minimum\nplugin maturity is configured by the plugin_maturity system variable. This can\nbe specified as a command-line argument to mysqld or it can be specified in a\nrelevant server option group in an option file. For example:\n\n[mariadb]\n...\nplugin_maturity = stable\n\nConfiguring Plugin Activation at Server Startup\n-----------------------------------------------\n\nA plugin will be loaded by default when the server starts if:\n\n* The plugin was installed with the INSTALL SONAME statement.\n* The plugin was installed with the INSTALL PLUGIN statement.\n* The plugin was installed with the mysql_plugin utility.\n* The server is configured to load the plugin with the --plugin-load-add\noption.\n* The server is configured to load the plugin with the --plugin-load option.\n\nThis behavior can be changed with special options that take the form\n--plugin-name. For example, for the server_audit audit plugin, the special\noption is called --server-audit.\n\nThe possible values for these special options are:\n\n+---------------------------------------+------------------------------------+\n| Option Value                          | Description                        |\n+---------------------------------------+------------------------------------+\n| OFF                                   | Disables the plugin without        |\n|                                       | removing it from the               |\n|                                       | mysql.plugins table.               |\n+---------------------------------------+------------------------------------+\n| ON                                    | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will still continue         |\n|                                       | starting up, but the plugin will   |\n|                                       | be disabled.                       |\n+---------------------------------------+------------------------------------+\n| FORCE                                 | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error.                             |\n+---------------------------------------+------------------------------------+\n| FORCE_PLUS_PERMANENT                  | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error. In addition, the plugin     |\n|                                       | cannot be uninstalled with         |\n|                                       | UNINSTALL SONAME or UNINSTALL      |\n|                                       | PLUGIN while the server is         |\n|                                       | running.                           |\n+---------------------------------------+------------------------------------+\n\nA plugin\'s status can be found by looking at the PLUGIN_STATUS column of the\ninformation_schema.PLUGINS table.\n\nUninstalling Plugins\n--------------------\n\nPlugins that are found in the mysql.plugin table, that is those that were\ninstalled with INSTALL SONAME, INSTALL PLUGIN or mysql_plugin can be\nuninstalled in one of two ways:\n\n* The UNINSTALL SONAME or the UNINSTALL PLUGIN statement while the server is\nrunning\n* With mysql_plugin while the server is offline.\n\nPlugins that were enabled as a --plugin-load option do not need to be\nuninstalled. If --plugin-load is omitted the next time the server starts, or\nthe plugin is not listed as one of the --plugin-load entries, the plugin will\nnot be loaded.\n\nUNINSTALL PLUGIN uninstalls a single installed plugin, while UNINSTALL SONAME\nuninstalls all plugins belonging to a given library.\n\nURL: https://mariadb.com/kb/en/plugin-overview/','','https://mariadb.com/kb/en/plugin-overview/'),(79,'MBR Definition',6,'Description\n-----------\n\nThe MBR (Minimum Bounding Rectangle), or Envelope is the bounding geometry,\nformed by the minimum and maximum (X,Y) coordinates:\n\nExamples\n--------\n\n((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n\nURL: https://mariadb.com/kb/en/mbr-definition/','','https://mariadb.com/kb/en/mbr-definition/'),(80,'MBRContains',6,'Syntax\n------\n\nMBRContains(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1\ncontains the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRWithin().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\n\nSET @g2 = GeomFromText(\'Point(1 1)\');\n\nSELECT MBRContains(@g1,@g2), MBRContains(@g2,@g1);\n+----------------------+----------------------+\n| MBRContains(@g1,@g2) | MBRContains(@g2,@g1) |\n+----------------------+----------------------+\n|                    1 |                    0 |\n+----------------------+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrcontains/','','https://mariadb.com/kb/en/mbrcontains/'),(82,'MBREqual',6,'Syntax\n------\n\nMBREqual(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are the same.\n\nExamples\n--------\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 2)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 2, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 3)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 4, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 0 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/mbrequal/','','https://mariadb.com/kb/en/mbrequal/'),(86,'MBRWithin',6,'Syntax\n------\n\nMBRWithin(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1 is\nwithin the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRContains().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((0 0,0 5,5 5,5 0,0 0))\');\nSELECT MBRWithin(@g1,@g2), MBRWithin(@g2,@g1);\n+--------------------+--------------------+\n| MBRWithin(@g1,@g2) | MBRWithin(@g2,@g1) |\n+--------------------+--------------------+\n|                  1 |                  0 |\n+--------------------+--------------------+\n\nURL: https://mariadb.com/kb/en/mbrwithin/','','https://mariadb.com/kb/en/mbrwithin/'),(75,'UNINSTALL PLUGIN',5,'Syntax\n------\n\nUNINSTALL PLUGIN [IF EXISTS] plugin_name\n\nDescription\n-----------\n\nThis statement removes a single installed plugin. To uninstall the whole\nlibrary which contains the plugin, use UNINSTALL SONAME. You cannot uninstall\na plugin if any table that uses it is open.\n\nplugin_name must be the name of some plugin that is listed in the mysql.plugin\ntable. The server executes the plugin\'s deinitialization function and removes\nthe row for the plugin from the mysql.plugin table, so that subsequent server\nrestarts will not load and initialize the plugin. UNINSTALL PLUGIN does not\nremove the plugin\'s shared library file.\n\nTo use UNINSTALL PLUGIN, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nUNINSTALL PLUGIN example;\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------+\n| Level | Code | Message                       |\n+-------+------+-------------------------------+\n| Note  | 1305 | PLUGIN example does not exist |\n+-------+------+-------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-plugin/','','https://mariadb.com/kb/en/uninstall-plugin/'),(76,'INSTALL SONAME',5,'Syntax\n------\n\nINSTALL SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of INSTALL PLUGIN. It installs all plugins from a\ngiven plugin_library. See INSTALL PLUGIN for details.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL SONAME adds one or more lines to the mysql.plugin table that describes\nthe plugin. This table contains the plugin name and library file name.\n\nINSTALL SONAME causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL SONAME also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL SONAME, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nSONAME only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nIf you need to install only one plugin from a library, use the INSTALL PLUGIN\nstatement.\n\nExamples\n--------\n\nTo load the XtraDB storage engine and all of its information_schema tables\nwith one statement, use\n\nINSTALL SONAME \'ha_xtradb\';\n\nThis statement can be used instead of INSTALL PLUGIN even when the library\ncontains only one plugin:\n\nINSTALL SONAME \'ha_sequence\';\n\nURL: https://mariadb.com/kb/en/install-soname/','','https://mariadb.com/kb/en/install-soname/'),(77,'UNINSTALL SONAME',5,'Syntax\n------\n\nUNINSTALL SONAME  [IF EXISTS] \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of UNINSTALL PLUGIN statement, that removes all\nplugins belonging to a specified plugin_library. See UNINSTALL PLUGIN for\ndetails.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nTo use UNINSTALL SONAME, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin library does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nTo uninstall the XtraDB plugin and all of its information_schema tables with\none statement, use\n\nUNINSTALL SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------------+\n| Level | Code | Message                             |\n+-------+------+-------------------------------------+\n| Note  | 1305 | SONAME ha_example.so does not exist |\n+-------+------+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-soname/','','https://mariadb.com/kb/en/uninstall-soname/'),(90,'NULLIF',7,'Syntax\n------\n\nNULLIF(expr1,expr2)\n\nDescription\n-----------\n\nReturns NULL if expr1 = expr2 is true, otherwise returns expr1. This is the\nsame as CASE WHEN expr1 = expr2 THEN NULL ELSE expr1 END.\n\nExamples\n--------\n\nSELECT NULLIF(1,1);\n+-------------+\n| NULLIF(1,1) |\n+-------------+\n|        NULL |\n+-------------+\n\nSELECT NULLIF(1,2);\n+-------------+\n| NULLIF(1,2) |\n+-------------+\n|           1 |\n+-------------+\n\nURL: https://mariadb.com/kb/en/nullif/','','https://mariadb.com/kb/en/nullif/'),(91,'NVL',7,'MariaDB starting with 10.3\n--------------------------\nFrom MariaDB 10.3, NVL is a synonym for IFNULL.\n\nURL: https://mariadb.com/kb/en/nvl/','','https://mariadb.com/kb/en/nvl/'),(92,'NVL2',7,'MariaDB starting with 10.3\n--------------------------\nThe NLV2 function was introduced in MariaDB 10.3.0.\n\nSyntax\n------\n\nNVL2(expr1,expr2,expr3)\n\nDescription\n-----------\n\nThe NVL2 function returns a value based on whether a specified expression is\nNULL or not. If expr1 is not NULL, then NVL2 returns expr2. If expr1 is NULL,\nthen NVL2 returns expr3.\n\nExamples\n--------\n\nSELECT NVL2(NULL,1,2);\n+----------------+\n| NVL2(NULL,1,2) |\n+----------------+\n|              2 |\n+----------------+\n\nSELECT NVL2(\'x\',1,2);\n+---------------+\n| NVL2(\'x\',1,2) |\n+---------------+\n|             1 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/nvl2/','','https://mariadb.com/kb/en/nvl2/'),(81,'MBRDisjoint',6,'Syntax\n------\n\nMBRDisjoint(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are disjoint. Two geometries are disjoint if they do not\nintersect, that is touch or overlap.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECTmbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrdisjoint/','','https://mariadb.com/kb/en/mbrdisjoint/'),(83,'MBRIntersects',6,'Syntax\n------\n\nMBRIntersects(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 intersect.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      1 |\n+------------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      0 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/mbrintersects/','','https://mariadb.com/kb/en/mbrintersects/'),(84,'MBROverlaps',6,'Syntax\n------\n\nMBROverlaps(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 overlap. The term spatially overlaps is used if two\ngeometries intersect and their intersection results in a geometry of the same\ndimension but not equal to either of the given geometries.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbroverlaps/','','https://mariadb.com/kb/en/mbroverlaps/'),(85,'MBRTouches',6,'Syntax\n------\n\nMBRTouches(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 touch. Two geometries spatially touch if the interiors of\nthe geometries do not intersect, but the boundary of one of the geometries\nintersects either the boundary or the interior of the other.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   1 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/mbrtouches/','','https://mariadb.com/kb/en/mbrtouches/'),(87,'CASE OPERATOR',7,'Syntax\n------\n\nCASE value WHEN [compare_value] THEN result [WHEN [compare_value] THEN\nresult ...] [ELSE result] END\n\nCASE WHEN [condition] THEN result [WHEN [condition] THEN result ...]\n[ELSE result] END\n\nDescription\n-----------\n\nThe first version returns the result where value=compare_value. The second\nversion returns the result for the first condition that is true. If there was\nno matching result value, the result after ELSE is returned, or NULL if there\nis no ELSE part.\n\nThere is also a CASE statement, which differs from the CASE operator described\nhere.\n\nExamples\n--------\n\nSELECT CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END;\n+------------------------------------------------------------+\n| CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END |\n+------------------------------------------------------------+\n| one                                                        |\n+------------------------------------------------------------+\n\nSELECT CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END;\n+--------------------------------------------+\n| CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END |\n+--------------------------------------------+\n| true                                       |\n+--------------------------------------------+\n\nSELECT CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END;\n+-----------------------------------------------------+\n| CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END |\n+-----------------------------------------------------+\n|                                                NULL |\n+-----------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/case-operator/','','https://mariadb.com/kb/en/case-operator/'),(101,'UNLOCK TABLES',8,'Syntax\n------\n\nUNLOCK TABLES\n\nDescription\n-----------\n\nUNLOCK TABLES explicitly releases any table locks held by the current session.\nSee LOCK TABLES for more information.\n\nIn addition to releasing table locks acquired by the LOCK TABLES statement,\nthe UNLOCK TABLES statement also releases the global read lock acquired by the\nFLUSH TABLES WITH READ LOCK statement. The FLUSH TABLES WITH READ LOCK\nstatement is very useful for performing backups. See FLUSH for more\ninformation about FLUSH TABLES WITH READ LOCK.\n\nURL: https://mariadb.com/kb/en/transactions-unlock-tables/','','https://mariadb.com/kb/en/transactions-unlock-tables/'),(103,'XA Transactions',8,'Overview\n--------\n\nThe MariaDB XA implementation is based on the X/Open CAE document Distributed\nTransaction Processing: The XA Specification. This document is published by\nThe Open Group and available at\nhttp://www.opengroup.org/public/pubs/catalog/c193.htm.\n\nXA transactions are designed to allow distributed transactions, where a\ntransaction manager (the application) controls a transaction which involves\nmultiple resources. Such resources are usually DBMSs, but could be resources\nof any type. The whole set of required transactional operations is called a\nglobal transaction. Each subset of operations which involve a single resource\nis called a local transaction. XA used a 2-phases commit (2PC). With the first\ncommit, the transaction manager tells each resource to prepare an effective\ncommit, and waits for a confirm message. The changes are not still made\neffective at this point. If any of the resources encountered an error, the\ntransaction manager will rollback the global transaction. If all resources\ncommunicate that the first commit is successful, the transaction manager can\nrequire a second commit, which makes the changes effective.\n\nIn MariaDB, XA transactions can only be used with storage engines that support\nthem. At least InnoDB, TokuDB, SPIDER and MyRocks support them. For InnoDB,\nuntil MariaDB 10.2, XA transactions can be disabled by setting the\ninnodb_support_xa server system variable to 0. From MariaDB 10.3, XA\ntransactions are always supported.\n\nLike regular transactions, XA transactions create metadata locks on accessed\ntables.\n\nXA transactions require REPEATABLE READ as a minimum isolation level. However,\ndistributed transactions should always use SERIALIZABLE.\n\nTrying to start more than one XA transaction at the same time produces a 1400\nerror (SQLSTATE \'XAE09\'). The same error is produced when attempting to start\nan XA transaction while a regular transaction is in effect. Trying to start a\nregular transaction while an XA transaction is in effect produces a 1399 error\n(SQLSTATE \'XAE07\').\n\nThe statements that cause an implicit COMMIT for regular transactions produce\na 1400 error (SQLSTATE \'XAE09\') if a XA transaction is in effect.\n\nInternal XA vs External XA\n--------------------------\n\nXA transactions are an overloaded term in MariaDB. If a storage engine is\nXA-capable, it can mean one or both of these:\n\n* It supports MariaDB\'s internal two-phase commit API. This is transparent to\nthe user. Sometimes this is called \"internal XA\", since MariaDB\'s internal\ntransaction coordinator log can handle coordinating these transactions.\n\n* It supports XA transactions, with the XA START, XA PREPARE, XA COMMIT, etc.\nstatements. Sometimes this is called \"external XA\", since it requires the use\nof an external transaction coordinator to use this feature properly.\n\nTransaction Coordinator Log\n---------------------------\n\nIf you have two or more XA-capable storage engines enabled, then a transaction\ncoordinator log must be available.\n\nThere are currently two implementations of the transaction coordinator log:\n\n* Binary log-based transaction coordinator log\n* Memory-mapped file-based transaction coordinator log\n\nIf the binary log is enabled on a server, then the server will use the binary\nlog-based transaction coordinator log. Otherwise, it will use the\nmemory-mapped file-based transaction coordinator log.\n\nSee Transaction Coordinator Log for more information.\n\nSyntax\n------\n\nXA {START|BEGIN} xid [JOIN|RESUME]\n\nXA END xid [SUSPEND [FOR MIGRATE]]\n\nXA PREPARE xid\n\nXA COMMIT xid [ONE PHASE]\n\nXA ROLLBACK xid\n\nXA RECOVER [FORMAT=[\'RAW\'|\'SQL\']]\n\nxid: gtrid [, bqual [, formatID ]]\n\nThe interface to XA transactions is a set of SQL statements starting with XA.\nEach statement changes a transaction\'s state, determining which actions it can\nperform. A transaction which does not exist is in the NON-EXISTING state.\n\nXA START (or BEGIN) starts a transaction and defines its xid (a transaction\nidentifier). The JOIN or RESUME keywords have no effect. The new transaction\nwill be in ACTIVE state.\n\nThe xid can have 3 components, though only the first one is mandatory. gtrid\nis a quoted string representing a global transaction identifier. bqual is a\nquoted string representing a local transaction identifier. formatID is an\nunsigned integer indicating the format used for the first two components; if\nnot specified, defaults to 1. MariaDB does not interpret in any way these\ncomponents, and only uses them to identify a transaction. xids of transactions\nin effect must be unique.\n\nXA END declares that the specified ACTIVE transaction is finished and it\nchanges its state to IDLE. SUSPEND [FOR MIGRATE] has no effect.\n\nXA PREPARE prepares an IDLE transaction for commit, changing its state to\nPREPARED. This is the first commit.\n\nXA COMMIT definitely commits and terminates a transaction which has already\nbeen PREPARED. If the ONE PHASE clause is specified, this statements performs\na 1-phase commit on an IDLE transaction.\n\nXA ROLLBACK rolls back and terminates an IDLE or PREPARED transaction.\n\nXA RECOVER shows information about all PREPARED transactions.\n\nWhen trying to execute an operation which is not allowed for the transaction\'s\ncurrent state, an error is produced:\n\nXA COMMIT \'test\' ONE PHASE;\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  ACTIVE state\n\nXA COMMIT \'test2\';\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  NON-EXISTING state\n\nXA RECOVER\n----------\n\nThe XA RECOVER statement shows information about all transactions which are in\nthe PREPARED state. It does not matter which connection created the\ntransaction: if it has been PREPARED, it appears. But this does not mean that\na connection can commit or rollback a transaction which was started by another\nconnection. Note that transactions using a 1-phase commit are never in the\nPREPARED state, so they cannot be shown by XA RECOVER.\n\nXA RECOVER produces four columns:\n\nXA RECOVER;\n+----------+--------------+--------------+------+\n| formatID | gtrid_length | bqual_length | data |\n+----------+--------------+--------------+------+\n|        1 |            4 |            0 | test |\n+----------+--------------+--------------+------+\n\nMariaDB starting with 10.3.3\n----------------------------\nYou can use XA RECOVER FORMAT=\'SQL\' to get the data in a human readable form\nthat can be directly copy-pasted into XA COMMIT or XA ROLLBACK. This is\nparticularly useful for binary xid generated by some transaction coordinators.\n\nformatID is the formatID part of xid.\n\ndata are the gtrid and bqual parts of xid, concatenated.\n\ngtrid_length and bqual_length are the lengths of gtrid and bqual, respectevely.\n\nExamples\n--------\n\n2-phases commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA PREPARE \'test\';\n\nXA COMMIT \'test\';\n\n1-phase commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA COMMIT \'test\' ONE PHASE;\n\nHuman-readable:\n\nxa start \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\ninsert t1 values (40);\n\nxa end \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa prepare \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa recover format=\'RAW\';\n+----------+--------------+--------------+--------------------+\n| formatID | gtrid_length | bqual_length | data               |\n+----------+--------------+--------------+--------------------+\n34      67v78abc       11 |            7 | 12\ndef |\n+----------+--------------+--------------+--------------------+\n\nxa recover format=\'SQL\';\n+----------+--------------+--------------+-------------------------------------\n---------+\n| formatID | gtrid_length | bqual_length | data                               \n     |\n+----------+--------------+--------------+-------------------------------------\n---------+\n|        3 |           11 |            7 |\nX\'31320d3334093637763738\',X\'6162630a646566\',3 |\n+----------+--------------+--------------+-------------------------------------\n---------+\n\nxa rollback X\'31320d3334093637763738\',X\'6162630a646566\',3;\n\nKnown Issues\n------------\n\nMariaDB Galera Cluster\n----------------------\n\nMariaDB Galera Cluster does not support XA transactions.\n\nHowever, MariaDB Galera Cluster builds include a built-in plugin called wsrep.\nPrior to MariaDB 10.4.3, this plugin was internally considered an XA-capable\nstorage engine. Consequently, these MariaDB Galera Cluster builds have\nmultiple XA-capable storage engines by default, even if the only \"real\"\nstorage engine that supports external XA transactions enabled on these builds\nby default is InnoDB. Therefore, when using one these builds MariaDB would be\nforced to use a transaction coordinator log by default, which could have\nperformance implications.\n\nSee Transaction Coordinator Log Overview: MariaDB Galera Cluster for more\ninformation.\n\nURL: https://mariadb.com/kb/en/xa-transactions/','','https://mariadb.com/kb/en/xa-transactions/'),(104,'CREATE USER',10,'Syntax\n------\n\nCREATE [OR REPLACE] USER [IF NOT EXISTS] \n user_specification [,user_specification ...] \n [REQUIRE {NONE | tls_option [[AND] tls_option ...] }]\n [WITH resource_option [resource_option ...] ]\n [lock_option] [password_option]\n\nuser_specification:\n username [authentication_option]\n\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule  ...]\n\nauthentication_rule:\n  authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\ntls_option:\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n\nlock_option:\n  ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n\nDescription\n-----------\n\nThe CREATE USER statement creates new MariaDB accounts. To use it, you must\nhave the global CREATE USER privilege or the INSERT privilege for the mysql\ndatabase. For each account, CREATE USER creates a new row in mysql.user (until\nMariaDB 10.3 this is a table, from MariaDB 10.4 it\'s a view) or\nmysql.global_priv_table (from MariaDB 10.4) that has no privileges.\n\nIf any of the specified accounts, or any permissions for the specified\naccounts, already exist, then the server returns ERROR 1396 (HY000). If an\nerror occurs, CREATE USER will still create the accounts that do not result in\nan error. Only one error is produced for all users which have not been created:\n\nERROR 1396 (HY000): \n Operation CREATE USER failed for \'u1\'@\'%\',\'u2\'@\'%\'\n\nCREATE USER, DROP USER, CREATE ROLE, and DROP ROLE all produce the same error\ncode when they fail.\n\nSee Account Names below for details on how account names are specified.\n\nOR REPLACE\n----------\n\nIf the optional OR REPLACE clause is used, it is basically a shortcut for:\n\nDROP USER IF EXISTS name;\nCREATE USER name ...;\n\nFor example:\n\nCREATE USER foo2@test IDENTIFIED BY \'password\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'foo2\'@\'test\'\n\nCREATE OR REPLACE USER foo2@test IDENTIFIED BY \'password\';\nQuery OK, 0 rows affected (0.00 sec)\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a warning instead\nof an error if the specified user already exists.\n\nFor example:\n\nCREATE USER foo2@test IDENTIFIED BY \'password\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'foo2\'@\'test\'\n\nCREATE USER IF NOT EXISTS foo2@test IDENTIFIED BY \'password\';\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+----------------------------------------------------+\n| Level | Code | Message                                            |\n+-------+------+----------------------------------------------------+\n| Note  | 1973 | Can\'t create user \'foo2\'@\'test\'; it already exists |\n+-------+------+----------------------------------------------------+\n\nAuthentication Options\n----------------------\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored in the\nmysql.user/mysql.global_priv_table table.\n\nFor example, if our password is mariadb, then we can create the user with:\n\nCREATE USER foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD function. It will be stored in the\nmysql.user/mysql.global_priv_table table as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n\nAnd then we can create a user with the hash:\n\nCREATE USER foo2@test IDENTIFIED BY PASSWORD\n\'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nCREATE USER foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nCREATE USER foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nMariaDB starting with 10.4.0\n----------------------------\nThe USING or AS keyword can also be used to provide a plain-text password to a\nplugin if it\'s provided as an argument to the PASSWORD() function. This is\nonly valid for authentication plugins that have implemented a hook for the\nPASSWORD() function. For example, the ed25519 authentication plugin supports\nthis:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nMariaDB starting with 10.4.3\n----------------------------\nOne can specify many authentication plugins, they all work as alternatives\nways of authenticating a user:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\') OR\nunix_socket;\n\nBy default, when you create a user without specifying an authentication\nplugin, MariaDB uses the mysql_native_password plugin.\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can create a user account that requires these TLS options\nwith the following:\n\nCREATE USER \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\'\n AND ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+--------------------------------------+--------------------------------------+\n| Limit Type                           | Decription                           |\n+--------------------------------------+--------------------------------------+\n| MAX_QUERIES_PER_HOUR                 | Number of statements that the        |\n|                                      | account can issue per hour           |\n|                                      | (including updates)                  |\n+--------------------------------------+--------------------------------------+\n| MAX_UPDATES_PER_HOUR                 | Number of updates (not queries)      |\n|                                      | that the account can issue per hour  |\n+--------------------------------------+--------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR             | Number of connections that the       |\n|                                      | account can start per hour           |\n+--------------------------------------+--------------------------------------+\n| MAX_USER_CONNECTIONS                 | Number of simultaneous connections   |\n|                                      | that can be accepted from the same   |\n|                                      | account; if it is 0,                 |\n|                                      | max_connections will be used         |\n|                                      | instead; if max_connections is 0,    |\n|                                      | there is no limit for this           |\n|                                      | account\'s simultaneous connections.  |\n+--------------------------------------+--------------------------------------+\n| MAX_STATEMENT_TIME                   | Timeout, in seconds, for statements  |\n|                                      | executed by the user. See also       |\n|                                      | Aborting Statements that Exceed a    |\n|                                      | Certain Time to Execute.             |\n+--------------------------------------+--------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nHere is an example showing how to create a user with resource limits:\n\nCREATE USER \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 10\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nAccount Names\n-------------\n\nAccount names have both a user name component and a host name component, and\nare specified as \'user_name\'@\'host_name\'.\n\nThe user name and host name may be unquoted, quoted as strings using double\nquotes (\") or single quotes (\'), or quoted as identifiers using backticks (`).\nYou must use quotes when using special characters (such as a hyphen) or\nwildcard characters. If you quote, you must quote the user name and host name\nseparately (for example \'user_name\'@\'host_name\').\n\nHost Name Component\n-------------------\n\nIf the host name is not provided, it is assumed to be \'%\'.\n\nHost names may contain the wildcard characters % and _. They are matched as if\nby the LIKE clause. If you need to use a wildcard character literally (for\nexample, to match a domain name with an underscore), prefix the character with\na backslash. See LIKE for more information on escaping wildcard characters.\n\nHost name matches are case-insensitive. Host names can match either domain\nnames or IP addresses. Use \'localhost\' as the host name to allow only local\nclient connections.\n\nYou can use a netmask to match a range of IP addresses using \'base_ip/netmask\'\nas the host name. A user with an IP address ip_addr will be allowed to connect\nif the following condition is true:\n\nip_addr & netmask = base_ip\n\nFor example, given a user:\n\nCREATE USER \'maria\'@\'247.150.130.0/255.255.255.0\';\n\nthe IP addresses satisfying this condition range from 247.150.130.0 to\n247.150.130.255.\n\nUsing 255.255.255.255 is equivalent to not using a netmask at all. Netmasks\ncannot be used for IPv6 addresses.\n\nNote that the credentials added when creating a user with the \'%\' wildcard\nhost will not grant access in all cases. For example, some systems come with\nan anonymous localhost user, and when connecting from localhost this will take\nprecedence.\n\nBefore MariaDB 10.6, the host name component could be up to 60 characters in\nlength. Starting from MariaDB 10.6, it can be up to 255 characters.\n\nUser Name Component\n-------------------\n\nUser names must match exactly, including case. A user name that is empty is\nknown as an anonymous account and is allowed to match a login attempt with any\nuser name component. These are described more in the next section.\n\nFor valid identifiers to use as user names, see Identifier Names.\n\nIt is possible for more than one account to match when a user connects.\nMariaDB selects the first matching account after sorting according to the\nfollowing criteria:\n\n* Accounts with an exact host name are sorted before accounts using a wildcard\nin the\nhost name. Host names using a netmask are considered to be exact for sorting.\n* Accounts with a wildcard in the host name are sorted according to the\nposition of\nthe first wildcard character. Those with a wildcard character later in the\nhost name\nsort before those with a wildcard character earlier in the host name.\n* Accounts with a non-empty user name sort before accounts with an empty user\nname.\n* Accounts with an empty user name are sorted last. As mentioned previously,\nthese are known as anonymous accounts. These are described more in the next\nsection.\n\nThe following table shows a list of example account as sorted by these\ncriteria:\n\n+---------+-------------+\n| User    | Host        |\n+---------+-------------+\n| joffrey | 192.168.0.3 |\n|         | 192.168.0.% |\n| joffrey | 192.168.%   |\n|         | 192.168.%   |\n+---------+-------------+\n\nOnce connected, you only have the privileges granted to the account that\nmatched, not all accounts that could have matched. For example, consider the\nfollowing commands:\n\nCREATE USER \'joffrey\'@\'192.168.0.3\';\nCREATE USER \'joffrey\'@\'%\';\nGRANT SELECT ON test.t1 to \'joffrey\'@\'192.168.0.3\';\nGRANT SELECT ON test.t2 to \'joffrey\'@\'%\';\n\nIf you connect as joffrey from 192.168.0.3, you will have the SELECT privilege\non the table test.t1, but not on the table test.t2. If you connect as joffrey\nfrom any other IP address, you will have the SELECT privilege on the table\ntest.t2, but not on the table test.t1.\n\nUsernames can be up to 80 characters long before 10.6 and starting from 10.6\nit can be 128 characters long.\n\nAnonymous Accounts\n------------------\n\nAnonymous accounts are accounts where the user name portion of the account\nname is empty. These accounts act as special catch-all accounts. If a user\nattempts to log into the system from a host, and an anonymous account exists\nwith a host name portion that matches the user\'s host, then the user will log\nin as the anonymous account if there is no more specific account match for the\nuser name that the user entered.\n\nFor example, here are some anonymous accounts:\n\nCREATE USER \'\'@\'localhost\';\nCREATE USER \'\'@\'192.168.0.3\';\n\nFixing a Legacy Default Anonymous Account\n-----------------------------------------\n\nOn some systems, the mysql.db table has some entries for the \'\'@\'%\' anonymous\naccount by default. Unfortunately, there is no matching entry in the\nmysql.user/mysql.global_priv_table table, which means that this anonymous\naccount doesn\'t exactly exist, but it does have privileges--usually on the\ndefault test database created by mysql_install_db. These account-less\nprivileges are a legacy that is leftover from a time when MySQL\'s privilege\nsystem was less advanced.\n\nThis situation means that you will run into errors if you try to create a\n\'\'@\'%\' account. For example:\n\nCREATE USER \'\'@\'%\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'\'@\'%\'\n\nThe fix is to DELETE the row in the mysql.db table and then execute FLUSH\nPRIVILEGES:\n\nDELETE FROM mysql.db WHERE User=\'\' AND Host=\'%\';\nFLUSH PRIVILEGES;\n\nAnd then the account can be created:\n\nCREATE USER \'\'@\'%\';\nQuery OK, 0 rows affected (0.01 sec)\n\nSee MDEV-13486 for more information.\n\nPassword Expiry\n---------------\n\nMariaDB starting with 10.4.3\n----------------------------\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal setting, for example:\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\n\nSee User Password Expiry for more details.\n\nAccount Locking\n---------------\n\nMariaDB starting with 10.4.2\n----------------------------\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected). For example:\n\nCREATE USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nSee Account Locking for more details.\n\nFrom MariaDB 10.4.7 and MariaDB 10.5.8, the lock_option and password_option\nclauses can occur in either order.\n\nURL: https://mariadb.com/kb/en/create-user/','','https://mariadb.com/kb/en/create-user/'),(105,'ALTER USER',10,'Syntax\n------\n\nALTER USER [IF EXISTS] \n user_specification [,user_specification] ...\n [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n [WITH resource_option [resource_option] ...]\n [lock_option] [password_option]\n\nuser_specification:\n username [authentication_option]\n\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule] ...\n\nauthentication_rule:\n authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\ntls_option\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nresource_option\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n\nlock_option:\n  ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n\nDescription\n-----------\n\nThe ALTER USER statement modifies existing MariaDB accounts. To use it, you\nmust have the global CREATE USER privilege or the UPDATE privilege for the\nmysql database. The global SUPER privilege is also required if the read_only\nsystem variable is enabled.\n\nIf any of the specified user accounts do not yet exist, an error results. If\nan error occurs, ALTER USER will still modify the accounts that do not result\nin an error. Only one error is produced for all users which have not been\nmodified.\n\nIF EXISTS\n---------\n\nWhen the IF EXISTS clause is used, MariaDB will return a warning instead of an\nerror for each specified user that does not exist.\n\nAccount Names\n-------------\n\nFor ALTER USER statements, account names are specified as the username\nargument in the same way as they are for CREATE USER statements. See account\nnames from the CREATE USER page for details on how account names are specified.\n\nCURRENT_USER or CURRENT_USER() can also be used to alter the account logged\ninto the current session. For example, to change the current user\'s password\nto mariadb:\n\nALTER USER CURRENT_USER() IDENTIFIED BY \'mariadb\';\n\nAuthentication Options\n----------------------\n\nMariaDB starting with 10.4\n--------------------------\nFrom MariaDB 10.4, it is possible to use more than one authentication plugin\nfor each user account. For example, this can be useful to slowly migrate users\nto the more secure ed25519 authentication plugin over time, while allowing the\nold mysql_native_password authentication plugin as an alternative for the\ntransitional period. See Authentication from MariaDB 10.4 for more.\n\nWhen running ALTER USER, not specifying an authentication option in the\nIDENTIFIED VIA clause will remove that authentication method. (However this\nwas not the case before MariaDB 10.4.13, see MDEV-21928)\n\nFor example, a user is created with the ability to authenticate via both a\npassword and unix_socket:\n\nCREATE USER \'bob\'@\'localhost\' \n IDENTIFIED VIA mysql_native_password USING PASSWORD(\'pwd\')\n OR unix_socket;\n\nSHOW CREATE USER \'bob\'@\'localhost\'\\G\n*************************** 1. row ***************************\nCREATE USER for bob@localhost: CREATE USER `bob`@`localhost` \n IDENTIFIED VIA mysql_native_password\n USING \'*975B2CD4FF9AE554FE8AD33168FBFC326D2021DD\'\n OR unix_socket\n\nIf the user\'s password is updated, but unix_socket authentication is not\nspecified in the IDENTIFIED VIA clause, unix_socket authentication will no\nlonger be permitted.\n\nALTER USER \'bob\'@\'localhost\' IDENTIFIED VIA mysql_native_password \n USING PASSWORD(\'pwd2\');\n\nSHOW CREATE USER \'bob\'@\'localhost\'\\G\n*************************** 1. row ***************************\nCREATE USER for bob@localhost: CREATE USER `bob`@`localhost` \n IDENTIFIED BY PASSWORD \'*38366FDA01695B6A5A9DD4E428D9FB8F7EB75512\'\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored to the mysql.user table.\n\nFor example, if our password is mariadb, then we can set the account\'s\npassword with:\n\nALTER USER foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD#function. It will be stored to the\nmysql.user table as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n\nAnd then we can set an account\'s password with the hash:\n\nALTER USER foo2@test \n IDENTIFIED BY PASSWORD \'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nALTER USER foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nALTER USER foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nIn MariaDB 10.4 and later, the USING or AS keyword can also be used to provide\na plain-text password to a plugin if it\'s provided as an argument to the\nPASSWORD() function. This is only valid for authentication plugins that have\nimplemented a hook for the PASSWORD() function. For example, the ed25519\nauthentication plugin supports this:\n\nALTER USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can alter a user account to require these TLS options with\nthe following:\n\nALTER USER \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\' AND\n ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+------------------------------------+---------------------------------------+\n| Limit Type                         | Description                           |\n+------------------------------------+---------------------------------------+\n| MAX_QUERIES_PER_HOUR               | Number of statements that the         |\n|                                    | account can issue per hour            |\n|                                    | (including updates)                   |\n+------------------------------------+---------------------------------------+\n| MAX_UPDATES_PER_HOUR               | Number of updates (not queries) that  |\n|                                    | the account can issue per hour        |\n+------------------------------------+---------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR           | Number of connections that the        |\n|                                    | account can start per hour            |\n+------------------------------------+---------------------------------------+\n| MAX_USER_CONNECTIONS               | Number of simultaneous connections    |\n|                                    | that can be accepted from the same    |\n|                                    | account; if it is 0, max_connections  |\n|                                    | will be used instead; if              |\n|                                    | max_connections is 0, there is no     |\n|                                    | limit for this account\'s              |\n|                                    | simultaneous connections.             |\n+------------------------------------+---------------------------------------+\n| MAX_STATEMENT_TIME                 | Timeout, in seconds, for statements   |\n|                                    | executed by the user. See also        |\n|                                    | Aborting Statements that Exceed a     |\n|                                    | Certain Time to Execute.              |\n+------------------------------------+---------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nHere is an example showing how to set an account\'s resource limits:\n\nALTER USER \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 10\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nPassword Expiry\n---------------\n\nMariaDB starting with 10.4.3\n----------------------------\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal setting, for example:\n\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE NEVER;\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n\nSee User Password Expiry for more details.\n\nAccount Locking\n---------------\n\nMariaDB starting with 10.4.2\n----------------------------\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected). For example:\n\nALTER USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nSee Account Locking for more details.\n\nFrom MariaDB 10.4.7 and MariaDB 10.5.8, the lock_option and password_option\nclauses can occur in either order.\n\nURL: https://mariadb.com/kb/en/alter-user/','','https://mariadb.com/kb/en/alter-user/'),(107,'GRANT',10,'Syntax\n------\n\nGRANT\n  priv_type [(column_list)]\n   [, priv_type [(column_list)]] ...\n  ON [object_type] priv_level\n  TO user_specification [ user_options ...]\n\nuser_specification:\n username [authentication_option]\n | PUBLIC\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule  ...]\n\nauthentication_rule:\n  authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\nGRANT PROXY ON username\n  TO user_specification [, user_specification ...]\n  [WITH GRANT OPTION]\n\nGRANT rolename TO grantee [, grantee ...]\n  [WITH ADMIN OPTION]\n\ngrantee:\n  rolename\n  username [authentication_option]\n\nuser_options:\n  [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n  [WITH with_option [with_option] ...]\n\nobject_type:\n  TABLE\n | FUNCTION\n | PROCEDURE\n | PACKAGE\n\npriv_level:\n  *\n | *.*\n | db_name.*\n | db_name.tbl_name\n | tbl_name\n | db_name.routine_name\n\nwith_option:\n  GRANT OPTION\n | resource_option\n\nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\ntls_option:\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nDescription\n-----------\n\nThe GRANT statement allows you to grant privileges or roles to accounts. To\nuse GRANT, you must have the GRANT OPTION privilege, and you must have the\nprivileges that you are granting.\n\nUse the REVOKE statement to revoke privileges granted with the GRANT statement.\n\nUse the SHOW GRANTS statement to determine what privileges an account has.\n\nAccount Names\n-------------\n\nFor GRANT statements, account names are specified as the username argument in\nthe same way as they are for CREATE USER statements. See account names from\nthe CREATE USER page for details on how account names are specified.\n\nImplicit Account Creation\n-------------------------\n\nThe GRANT statement also allows you to implicitly create accounts in some\ncases.\n\nIf the account does not yet exist, then GRANT can implicitly create it. To\nimplicitly create an account with GRANT, a user is required to have the same\nprivileges that would be required to explicitly create the account with the\nCREATE USER statement.\n\nIf the NO_AUTO_CREATE_USER SQL_MODE is set, then accounts can only be created\nif authentication information is specified, or with a CREATE USER statement.\nIf no authentication information is provided, GRANT will produce an error when\nthe specified account does not exist, for example:\n\nshow variables like \'%sql_mode%\' ;\n+---------------+--------------------------------------------+\n| Variable_name | Value                                      |\n+---------------+--------------------------------------------+\n| sql_mode      | NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION |\n+---------------+--------------------------------------------+\n\nGRANT USAGE ON *.* TO \'user123\'@\'%\' IDENTIFIED BY \'\';\nERROR 1133 (28000): Can\'t find any matching row in the user table\n\nGRANT USAGE ON *.* TO \'user123\'@\'%\' \n IDENTIFIED VIA PAM using \'mariadb\' require ssl ;\nQuery OK, 0 rows affected (0.00 sec)\n\nselect host, user from mysql.user where user=\'user123\' ;\n\n+------+----------+\n| host | user     |\n+------+----------+\n| %    | user123 |\n+------+----------+\n\nPrivilege Levels\n----------------\n\nPrivileges can be set globally, for an entire database, for a table or\nroutine, or for individual columns in a table. Certain privileges can only be\nset at certain levels.\n\n* Global privileges priv_type are granted using *.* for\npriv_level. Global privileges include privileges to administer the database\nand manage user accounts, as well as privileges for all tables, functions, and\nprocedures. Global privileges are stored in the mysql.user table prior to\nMariaDB 10.4, and in  mysql.global_priv table afterwards.\n* Database privileges priv_type are granted using db_name.*\nfor priv_level, or using just * to use default database. Database\nprivileges include privileges to create tables and functions, as well as\nprivileges for all tables, functions, and procedures in the database. Database\nprivileges are stored in the mysql.db table.\n* Table privileges priv_type are granted using db_name.tbl_name\nfor priv_level, or using just tbl_name to specify a table in the default\ndatabase. The TABLE keyword is optional. Table privileges include the\nability to select and change data in the table. Certain table privileges can\nbe granted for individual columns.\n* Column privileges priv_type are granted by specifying a table for\npriv_level and providing a column list after the privilege type. They allow\nyou to control exactly which columns in a table users can select and change.\n* Function privileges priv_type are granted using FUNCTION db_name.routine_name\nfor priv_level, or using just  FUNCTION routine_name to specify a function\nin the default database.\n* Procedure privileges priv_type are granted using PROCEDURE\ndb_name.routine_name\nfor priv_level, or using just PROCEDURE routine_name to specify a procedure\nin the default database.\n\nThe USAGE Privilege\n-------------------\n\nThe USAGE privilege grants no real privileges. The SHOW GRANTS statement will\nshow a global USAGE privilege for a newly-created user. You can use USAGE with\nthe GRANT statement to change options like GRANT OPTION and\nMAX_USER_CONNECTIONS without changing any account privileges.\n\nThe ALL PRIVILEGES Privilege\n----------------------------\n\nThe ALL PRIVILEGES privilege grants all available privileges. Granting all\nprivileges only affects the given privilege level. For example, granting all\nprivileges on a table does not grant any privileges on the database or\nglobally.\n\nUsing ALL PRIVILEGES does not grant the special GRANT OPTION privilege.\n\nYou can use ALL instead of ALL PRIVILEGES.\n\nThe GRANT OPTION Privilege\n--------------------------\n\nUse the WITH GRANT OPTION clause to give users the ability to grant privileges\nto other users at the given privilege level. Users with the GRANT OPTION\nprivilege can only grant privileges they have. They cannot grant privileges at\na higher privilege level than they have the GRANT OPTION privilege.\n\nThe GRANT OPTION privilege cannot be set for individual columns. If you use\nWITH GRANT OPTION when specifying column privileges, the GRANT OPTION\nprivilege will be granted for the entire table.\n\nUsing the WITH GRANT OPTION clause is equivalent to listing GRANT OPTION as a\nprivilege.\n\nGlobal Privileges\n-----------------\n\nThe following table lists the privileges that can be granted globally. You can\nalso grant all database, table, and function privileges globally. When granted\nglobally, these privileges apply to all databases, tables, or functions,\nincluding those created later.\n\nTo set a global privilege, use *.* for priv_level.\n\nBINLOG ADMIN\n------------\n\nEnables administration of the binary log, including the PURGE BINARY LOGS\nstatement and setting the system variables:\n\n* binlog_annotate_row_events\n* binlog_cache_size\n* binlog_commit_wait_count\n* binlog_commit_wait_usec\n* binlog_direct_non_transactional_updates\n* binlog_expire_logs_seconds\n* binlog_file_cache_size\n* binlog_format\n* binlog_row_image\n* binlog_row_metadata\n* binlog_stmt_cache_size\n* expire_logs_days\n* log_bin_compress\n* log_bin_compress_min_len\n* log_bin_trust_function_creators\n* max_binlog_cache_size\n* max_binlog_size\n* max_binlog_stmt_cache_size\n* sql_log_bin and\n* sync_binlog.\n\nAdded in MariaDB 10.5.2.\n\nBINLOG MONITOR\n--------------\n\nNew name for REPLICATION CLIENT from MariaDB 10.5.2, (REPLICATION CLIENT still\nsupported as an alias for compatibility purposes). Permits running SHOW\ncommands related to the binary log, in particular the SHOW BINLOG STATUS and\nSHOW BINARY LOGS statements. Unlike REPLICATION CLIENT prior to MariaDB 10.5,\nSHOW REPLICA STATUS isn\'t included in this privilege, and REPLICA MONITOR is\nrequired.\n\nBINLOG REPLAY\n-------------\n\nEnables replaying the binary log with the BINLOG statement (generated by\nmariadb-binlog), executing SET timestamp when secure_timestamp is set to\nreplication, and setting the session values of system variables usually\nincluded in BINLOG output, in particular:\n\n* gtid_domain_id\n* gtid_seq_no\n* pseudo_thread_id\n* server_id.\n\nAdded in MariaDB 10.5.2\n\nCONNECTION ADMIN\n----------------\n\nEnables administering connection resource limit options. This includes\nignoring the limits specified by:\n\n* max_connections\n* max_user_connections and\n* max_password_errors.\n\nThe statements specified in init_connect are not executed, killing connections\nand queries owned by other users is permitted. The following\nconnection-related system variables can be changed:\n\n* connect_timeout\n* disconnect_on_expired_password\n* extra_max_connections\n* init_connect\n* max_connections\n* max_connect_errors\n* max_password_errors\n* proxy_protocol_networks\n* secure_auth\n* slow_launch_time\n* thread_pool_exact_stats\n* thread_pool_dedicated_listener\n* thread_pool_idle_timeout\n* thread_pool_max_threads\n* thread_pool_min_threads\n* thread_pool_oversubscribe\n* thread_pool_prio_kickup_timer\n* thread_pool_priority\n* thread_pool_size, and\n* thread_pool_stall_limit.\n\nAdded in MariaDB 10.5.2.\n\nCREATE USER\n-----------\n\nCreate a user using the CREATE USER statement, or implicitly create a user\nwith the GRANT statement.\n\nFEDERATED ADMIN\n---------------\n\nExecute CREATE SERVER, ALTER SERVER, and DROP SERVER statements. Added in\nMariaDB 10.5.2.\n\nFILE\n----\n\nRead and write files on the server, using statements like LOAD DATA INFILE or\nfunctions like LOAD_FILE(). Also needed to create CONNECT outward tables.\nMariaDB server must have the permissions to access those files.\n\nGRANT OPTION\n------------\n\nGrant global privileges. You can only grant privileges that you have.\n\nPROCESS\n-------\n\nShow information about the active processes, for example via SHOW PROCESSLIST\nor mysqladmin processlist. If you have the PROCESS privilege, you can see all\nthreads. Otherwise, you can see only your own threads (that is, threads\nassociated with the MariaDB account that you are using).\n\nREAD_ONLY ADMIN\n---------------\n\nUser can set the read_only system variable and allows the user to perform\nwrite operations, even when the read_only option is active. Added in MariaDB\n10.5.2.\n\nFrom MariaDB 10.11.0, the READ_ONLY ADMIN privilege has been removed from\nSUPER. The benefit of this is that one can remove the READ_ONLY ADMIN\nprivilege from all users and ensure that no one can make any changes on any\nnon-temporary tables. This is useful on replicas when one wants to ensure that\nthe replica is kept identical to the primary.\n\nRELOAD\n------\n\nExecute FLUSH statements or equivalent mariadb-admin/mysqladmin commands.\n\nREPLICATION CLIENT\n------------------\n\nExecute SHOW MASTER STATUS and SHOW BINARY LOGS informative statements.\nRenamed to BINLOG MONITOR in MariaDB 10.5.2 (but still supported as an alias\nfor compatibility reasons). SHOW SLAVE STATUS was part of REPLICATION CLIENT\nprior to MariaDB 10.5.\n\nREPLICATION MASTER ADMIN\n------------------------\n\nPermits administration of primary servers, including the SHOW REPLICA HOSTS\nstatement, and setting the gtid_binlog_state, gtid_domain_id,\nmaster_verify_checksum and server_id system variables. Added in MariaDB 10.5.2.\n\nREPLICA MONITOR\n---------------\n\nPermit SHOW REPLICA STATUS and SHOW RELAYLOG EVENTS. From MariaDB 10.5.9.\n\nWhen a user would upgrade from an older major release to a MariaDB 10.5 minor\nrelease prior to MariaDB 10.5.9, certain user accounts would lose\ncapabilities. For example, a user account that had the REPLICATION CLIENT\nprivilege in older major releases could run SHOW REPLICA STATUS, but after\nupgrading to a MariaDB 10.5 minor release prior to MariaDB 10.5.9, they could\nno longer run SHOW REPLICA STATUS, because that statement was changed to\nrequire the REPLICATION REPLICA ADMIN privilege.\n\nThis issue is fixed in MariaDB 10.5.9 with this new privilege, which now\ngrants the user the ability to execute SHOW [ALL] (SLAVE | REPLICA) STATUS.\n\nWhen a database is upgraded from an older major release to MariaDB Server\n10.5.9 or later, any user accounts with the REPLICATION CLIENT or REPLICATION\nSLAVE privileges will automatically be granted the new REPLICA MONITOR\nprivilege. The privilege fix occurs when the server is started up, not when\nmariadb-upgrade is performed.\n\nHowever, when a database is upgraded from an early 10.5 minor release to\n10.5.9 and later, the user will have to fix any user account privileges\nmanually.\n\nREPLICATION REPLICA\n-------------------\n\nSynonym for REPLICATION SLAVE. From MariaDB 10.5.1.\n\nREPLICATION SLAVE\n-----------------\n\nAccounts used by replica servers on the primary need this privilege. This is\nneeded to get the updates made on the master. From MariaDB 10.5.1, REPLICATION\nREPLICA is an alias for REPLICATION SLAVE.\n\nREPLICATION SLAVE ADMIN\n-----------------------\n\nPermits administering replica servers, including START REPLICA/SLAVE, STOP\nREPLICA/SLAVE, CHANGE MASTER, SHOW REPLICA/SLAVE STATUS, SHOW RELAYLOG EVENTS\nstatements, replaying the binary log with the BINLOG statement (generated by\nmariadb-binlog), and setting the system variables:\n\n* gtid_cleanup_batch_size\n* gtid_ignore_duplicates\n* gtid_pos_auto_engines\n* gtid_slave_pos\n* gtid_strict_mode\n* init_slave\n* read_binlog_speed_limit\n* relay_log_purge\n* relay_log_recovery\n* replicate_do_db\n* replicate_do_table\n* replicate_events_marked_for_skip\n* replicate_ignore_db\n* replicate_ignore_table\n* replicate_wild_do_table\n* replicate_wild_ignore_table\n* slave_compressed_protocol\n* slave_ddl_exec_mode\n* slave_domain_parallel_threads\n* slave_exec_mode\n* slave_max_allowed_packet\n* slave_net_timeout\n* slave_parallel_max_queued\n* slave_parallel_mode\n* slave_parallel_threads\n* slave_parallel_workers\n* slave_run_triggers_for_rbr\n* slave_sql_verify_checksum\n* slave_transaction_retry_interval\n* slave_type_conversions\n* sync_master_info\n* sync_relay_log, and\n* sync_relay_log_info.\n\nAdded in MariaDB 10.5.2.\n\nSET USER\n--------\n\nEnables setting the DEFINER when creating triggers, views, stored functions\nand stored procedures. Added in MariaDB 10.5.2.\n\nSHOW DATABASES\n--------------\n\nList all databases using the SHOW DATABASES statement. Without the SHOW\nDATABASES privilege, you can still issue the SHOW DATABASES statement, but it\nwill only list databases containing tables on which you have privileges.\n\nSHUTDOWN\n--------\n\nShut down the server using SHUTDOWN or the mysqladmin shutdown command.\n\nSUPER\n-----\n\nExecute superuser statements: CHANGE MASTER TO, KILL (users who do not have\nthis privilege can only KILL their own threads), PURGE LOGS, SET global system\nvariables, or the mysqladmin debug command. Also, this permission allows the\nuser to write data even if the read_only startup option is set, enable or\ndisable logging, enable or disable replication on replica, specify a DEFINER\nfor statements that support that clause, connect once reaching the\nMAX_CONNECTIONS. If a statement has been specified for the init-connect mysqld\noption, that command will not be executed when a user with SUPER privileges\nconnects to the server.\n\nThe SUPER privilege has been split into multiple smaller privileges from\nMariaDB 10.5.2 to allow for more fine-grained privileges, although it remains\nan alias for these smaller privileges.\n\nFrom MariaDB 10.11.0, the READ_ONLY ADMIN privilege has been removed from\nSUPER. The benefit of this is that one can remove the READ_ONLY ADMIN\nprivilege from all users and ensure that no one can make any changes on any\nnon-temporary tables. This is useful on replicas when one wants to ensure that\nthe replica is kept identical to the primary.\n\nDatabase Privileges\n-------------------\n\nThe following table lists the privileges that can be granted at the database\nlevel. You can also grant all table and function privileges at the database\nlevel. Table and function privileges on a database apply to all tables or\nfunctions in that database, including those created later.\n\nTo set a privilege for a database, specify the database using db_name.* for\npriv_level, or just use * to specify the default database.\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| CREATE                           | Create a database using the CREATE      |\n|                                  | DATABASE statement, when the privilege  |\n|                                  | is granted for a database. You can      |\n|                                  | grant the CREATE privilege on           |\n|                                  | databases that do not yet exist. This   |\n|                                  | also grants the CREATE privilege on     |\n|                                  | all tables in the database.             |\n+----------------------------------+-----------------------------------------+\n| CREATE ROUTINE                   | Create Stored Programs using the        |\n|                                  | CREATE PROCEDURE and CREATE FUNCTION    |\n|                                  | statements.                             |\n+----------------------------------+-----------------------------------------+\n| CREATE TEMPORARY TABLES          | Create temporary tables with the        |\n|                                  | CREATE TEMPORARY TABLE statement. This  |\n|                                  | privilege enable writing and dropping   |\n|                                  | those temporary tables                  |\n+----------------------------------+-----------------------------------------+\n| DROP                             | Drop a database using the DROP          |\n|                                  | DATABASE statement, when the privilege  |\n|                                  | is granted for a database. This also    |\n|                                  | grants the DROP privilege on all        |\n|                                  | tables in the database.                 |\n+----------------------------------+-----------------------------------------+\n| EVENT                            | Create, drop and alter EVENTs.          |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant database privileges. You can      |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n| LOCK TABLES                      | Acquire explicit locks using the LOCK   |\n|                                  | TABLES statement; you also need to      |\n|                                  | have the SELECT privilege on a table,   |\n|                                  | in order to lock it.                    |\n+----------------------------------+-----------------------------------------+\n\nTable Privileges\n----------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER                            | Change the structure of an existing     |\n|                                  | table using the ALTER TABLE statement.  |\n+----------------------------------+-----------------------------------------+\n| CREATE                           | Create a table using the CREATE TABLE   |\n|                                  | statement.  You can grant the CREATE    |\n|                                  | privilege on tables that do not yet     |\n|                                  | exist.                                  |\n+----------------------------------+-----------------------------------------+\n| CREATE VIEW                      | Create a view using the CREATE_VIEW     |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| DELETE                           | Remove rows from a table using the      |\n|                                  | DELETE statement.                       |\n+----------------------------------+-----------------------------------------+\n| DELETE HISTORY                   | Remove historical rows from a table     |\n|                                  | using the DELETE HISTORY statement.     |\n|                                  | Displays as DELETE VERSIONING ROWS      |\n|                                  | when running SHOW GRANTS until MariaDB  |\n|                                  | 10.3.15 and until MariaDB 10.4.5        |\n|                                  | (MDEV-17655), or when running SHOW      |\n|                                  | PRIVILEGES until MariaDB 10.5.2,        |\n|                                  | MariaDB 10.4.13 and MariaDB 10.3.23     |\n|                                  | (MDEV-20382). From MariaDB 10.3.4.      |\n|                                  | From MariaDB 10.3.5, if a user has the  |\n|                                  | SUPER privilege but not this            |\n|                                  | privilege, running mysql_upgrade will   |\n|                                  | grant this privilege as well.           |\n+----------------------------------+-----------------------------------------+\n| DROP                             | Drop a table using the DROP TABLE       |\n|                                  | statement or a view using the DROP      |\n|                                  | VIEW statement. Also required to        |\n|                                  | execute the TRUNCATE TABLE statement.   |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant table privileges. You can only    |\n|                                  | grant privileges that you have.         |\n+----------------------------------+-----------------------------------------+\n| INDEX                            | Create an index on a table using the    |\n|                                  | CREATE INDEX statement. Without the     |\n|                                  | INDEX privilege, you can still create   |\n|                                  | indexes when creating a table using     |\n|                                  | the CREATE TABLE statement if the you   |\n|                                  | have the CREATE privilege, and you can  |\n|                                  | create indexes using the ALTER TABLE    |\n|                                  | statement if you have the ALTER         |\n|                                  | privilege.                              |\n+----------------------------------+-----------------------------------------+\n| INSERT                           | Add rows to a table using the INSERT    |\n|                                  | statement.  The INSERT privilege can    |\n|                                  | also be set on individual columns; see  |\n|                                  | Column Privileges below for details.    |\n+----------------------------------+-----------------------------------------+\n| REFERENCES                       | Unused.                                 |\n+----------------------------------+-----------------------------------------+\n| SELECT                           | Read data from a table using the        |\n|                                  | SELECT statement. The SELECT privilege  |\n|                                  | can also be set on individual columns;  |\n|                                  | see Column Privileges below for         |\n|                                  | details.                                |\n+----------------------------------+-----------------------------------------+\n| SHOW VIEW                        | Show the CREATE VIEW statement to       |\n|                                  | create a view using the SHOW CREATE     |\n|                                  | VIEW statement.                         |\n+----------------------------------+-----------------------------------------+\n| TRIGGER                          | Execute triggers associated to tables   |\n|                                  | you update, execute the CREATE TRIGGER  |\n|                                  | and DROP TRIGGER statements. You will   |\n|                                  | still be able to see triggers.          |\n+----------------------------------+-----------------------------------------+\n| UPDATE                           | Update existing rows in a table using   |\n|                                  | the UPDATE statement. UPDATE            |\n|                                  | statements usually include a WHERE      |\n|                                  | clause to update only certain rows.     |\n|                                  | You must have SELECT privileges on the  |\n|                                  | table or the appropriate columns for    |\n|                                  | the WHERE clause. The UPDATE privilege  |\n|                                  | can also be set on individual columns;  |\n|                                  | see Column Privileges below for         |\n|                                  | details.                                |\n+----------------------------------+-----------------------------------------+\n\nColumn Privileges\n-----------------\n\nSome table privileges can be set for individual columns of a table. To use\ncolumn privileges, specify the table explicitly and provide a list of column\nnames after the privilege type. For example, the following statement would\nallow the user to read the names and positions of employees, but not other\ninformation from the same table, such as salaries.\n\nGRANT SELECT (name, position) on Employee to \'jeffrey\'@\'localhost\';\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| INSERT (column_list)             | Add rows specifying values in columns   |\n|                                  | using the INSERT statement. If you      |\n|                                  | only have column-level INSERT           |\n|                                  | privileges, you must specify the        |\n|                                  | columns you are setting in the INSERT   |\n|                                  | statement. All other columns will be    |\n|                                  | set to their default values, or NULL.   |\n+----------------------------------+-----------------------------------------+\n| REFERENCES (column_list)         | Unused.                                 |\n+----------------------------------+-----------------------------------------+\n| SELECT (column_list)             | Read values in columns using the        |\n|                                  | SELECT statement. You cannot access or  |\n|                                  | query any columns for which you do not  |\n|                                  | have SELECT privileges, including in    |\n|                                  | WHERE, ON, GROUP BY, and ORDER BY       |\n|                                  | clauses.                                |\n+----------------------------------+-----------------------------------------+\n| UPDATE (column_list)             | Update values in columns of existing    |\n|                                  | rows using the UPDATE statement.        |\n|                                  | UPDATE statements usually include a     |\n|                                  | WHERE clause to update only certain     |\n|                                  | rows. You must have SELECT privileges   |\n|                                  | on the table or the appropriate         |\n|                                  | columns for the WHERE clause.           |\n+----------------------------------+-----------------------------------------+\n\nFunction Privileges\n-------------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER ROUTINE                    | Change the characteristics of a stored  |\n|                                  | function using the ALTER FUNCTION       |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| EXECUTE                          | Use a stored function. You need SELECT  |\n|                                  | privileges for any tables or columns    |\n|                                  | accessed by the function.               |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant function privileges. You can      |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n\nProcedure Privileges\n--------------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER ROUTINE                    | Change the characteristics of a stored  |\n|                                  | procedure using the ALTER PROCEDURE     |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| EXECUTE                          | Execute a stored procedure using the    |\n|                                  | CALL statement. The privilege to call   |\n|                                  | a procedure may allow you to perform    |\n|                                  | actions you wouldn\'t otherwise be able  |\n|                                  | to do, such as insert rows into a       |\n|                                  | table.                                  |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant procedure privileges. You can     |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n\nGRANT EXECUTE ON PROCEDURE mysql.create_db TO maintainer;\n\nProxy Privileges\n----------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| PROXY                            | Permits one user to be a proxy for      |\n|                                  | another.                                |\n+----------------------------------+-----------------------------------------+\n\nThe PROXY privilege allows one user to proxy as another user, which means\ntheir privileges change to that of the proxy user, and the CURRENT_USER()\nfunction returns the user name of the proxy user.\n\nThe PROXY privilege only works with authentication plugins that support it.\nThe default mysql_native_password authentication plugin does not support proxy\nusers.\n\nThe pam authentication plugin is the only plugin included with MariaDB that\ncurrently supports proxy users. The PROXY privilege is commonly used with the\npam authentication plugin to enable user and group mapping with PAM.\n\nFor example, to grant the PROXY privilege to an anonymous account that\nauthenticates with the pam authentication plugin, you could execute the\nfollowing:\n\nCREATE USER \'dba\'@\'%\' IDENTIFIED BY \'strongpassword\';\nGRANT ALL PRIVILEGES ON *.* TO \'dba\'@\'%\' ;\n\nCREATE USER \'\'@\'%\' IDENTIFIED VIA pam USING \'mariadb\';\nGRANT PROXY ON \'dba\'@\'%\' TO \'\'@\'%\';\n\nA user account can only grant the PROXY privilege for a specific user account\nif the granter also has the PROXY privilege for that specific user account,\nand if that privilege is defined WITH GRANT OPTION. For example, the following\nexample fails because the granter does not have the PROXY privilege for that\nspecific user account at all:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------+\n| Grants for alice@localhost                                                  \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' |\n+------------------------------------------------------------------------------\n----------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nERROR 1698 (28000): Access denied for user \'alice\'@\'localhost\'\n\nAnd the following example fails because the granter does have the PROXY\nprivilege for that specific user account, but it is not defined WITH GRANT\nOPTION:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------+\n| Grants for alice@localhost                                                  \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' |\n| GRANT PROXY ON \'dba\'@\'localhost\' TO \'alice\'@\'localhost\'                     \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nERROR 1698 (28000): Access denied for user \'alice\'@\'localhost\'\n\nBut the following example succeeds because the granter does have the PROXY\nprivilege for that specific user account, and it is defined WITH GRANT OPTION:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| Grants for alice@localhost                                                  \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' WITH GRANT OPTION |\n| GRANT PROXY ON \'dba\'@\'localhost\' TO \'alice\'@\'localhost\' WITH GRANT OPTION   \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\n\nA user account can grant the PROXY privilege for any other user account if the\ngranter has the PROXY privilege for the \'\'@\'%\' anonymous user account, like\nthis:\n\nGRANT PROXY ON \'\'@\'%\' TO \'dba\'@\'localhost\' WITH GRANT OPTION;\n\nFor example, the following example succeeds because the user can grant the\nPROXY privilege for any other user account:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| Grants for alice@localhost                                                  \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' WITH GRANT OPTION |\n| GRANT PROXY ON \'\'@\'%\' TO \'alice\'@\'localhost\' WITH GRANT OPTION              \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n\nGRANT PROXY ON \'app1_dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nQuery OK, 0 rows affected (0.004 sec)\n\nGRANT PROXY ON \'app2_dba\'@\'localhost\' TO \'carol\'@\'localhost\';\nQuery OK, 0 rows affected (0.004 sec)\n\nThe default root user accounts created by mysql_install_db have this\nprivilege. For example:\n\nGRANT ALL PRIVILEGES ON *.* TO \'root\'@\'localhost\' WITH GRANT OPTION;\nGRANT PROXY ON \'\'@\'%\' TO \'root\'@\'localhost\' WITH GRANT OPTION;\n\nThis allows the default root user accounts to grant the PROXY privilege for\nany other user account, and it also allows the default root user accounts to\ngrant others the privilege to do the same.\n\nAuthentication Options\n----------------------\n\nThe authentication options for the GRANT statement are the same as those for\nthe CREATE USER statement.\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored.\n\nFor example, if our password is mariadb, then we can create the user with:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nIf the user account already exists and if you provide the IDENTIFIED BY\nclause, then the user\'s password will be changed. You must have the privileges\nneeded for the SET PASSWORD statement to change a user\'s password with GRANT.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD function. It will be stored as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n\nAnd then we can create a user with the hash:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED BY \n PASSWORD \'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nIf the user account already exists and if you provide the IDENTIFIED BY\nclause, then the user\'s password will be changed. You must have the privileges\nneeded for the SET PASSWORD statement to change a user\'s password with GRANT.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nMariaDB starting with 10.4.0\n----------------------------\nThe USING or AS keyword can also be used to provide a plain-text password to a\nplugin if it\'s provided as an argument to the PASSWORD() function. This is\nonly valid for authentication plugins that have implemented a hook for the\nPASSWORD() function. For example, the ed25519 authentication plugin supports\nthis:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 \n USING PASSWORD(\'secret\');\n\nMariaDB starting with 10.4.3\n----------------------------\nOne can specify many authentication plugins, they all work as alternatives\nways of authenticating a user:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 \n USING PASSWORD(\'secret\') OR unix_socket;\n\nBy default, when you create a user without specifying an authentication\nplugin, MariaDB uses the mysql_native_password plugin.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+--------------------------------------+--------------------------------------+\n| Limit Type                           | Decription                           |\n+--------------------------------------+--------------------------------------+\n| MAX_QUERIES_PER_HOUR                 | Number of statements that the        |\n|                                      | account can issue per hour           |\n|                                      | (including updates)                  |\n+--------------------------------------+--------------------------------------+\n| MAX_UPDATES_PER_HOUR                 | Number of updates (not queries)      |\n|                                      | that the account can issue per hour  |\n+--------------------------------------+--------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR             | Number of connections that the       |\n|                                      | account can start per hour           |\n+--------------------------------------+--------------------------------------+\n| MAX_USER_CONNECTIONS                 | Number of simultaneous connections   |\n|                                      | that can be accepted from the same   |\n|                                      | account; if it is 0,                 |\n|                                      | max_connections will be used         |\n|                                      | instead; if max_connections is 0,    |\n|                                      | there is no limit for this           |\n|                                      | account\'s simultaneous connections.  |\n+--------------------------------------+--------------------------------------+\n| MAX_STATEMENT_TIME                   | Timeout, in seconds, for statements  |\n|                                      | executed by the user. See also       |\n|                                      | Aborting Statements that Exceed a    |\n|                                      | Certain Time to Execute.             |\n+--------------------------------------+--------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nTo set resource limits for an account, if you do not want to change that\naccount\'s privileges, you can issue a GRANT statement with the USAGE\nprivilege, which has no meaning. The statement can name some or all limit\ntypes, in any order.\n\nHere is an example showing how to set resource limits:\n\nGRANT USAGE ON *.* TO \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 0\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nUsers with the CONNECTION ADMIN privilege (in MariaDB 10.5.2 and later) or the\nSUPER privilege are not restricted by max_user_connections, max_connections,\nor max_password_errors.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can create a user account that requires these TLS options\nwith the following:\n\nGRANT USAGE ON *.* TO \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\'\n AND ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nRoles\n-----\n\nSyntax\n------\n\nGRANT role TO grantee [, grantee ... ]\n[ WITH ADMIN OPTION ]\n\ngrantee:\n  rolename\n  username [authentication_option]\n\nThe GRANT statement is also used to grant the use of a role to one or more\nusers or other roles. In order to be able to grant a role, the grantor doing\nso must have permission to do so (see WITH ADMIN in the CREATE ROLE article).\n\nSpecifying the WITH ADMIN OPTION permits the grantee to in turn grant the role\nto another.\n\nFor example, the following commands show how to grant the same role to a\ncouple different users.\n\nGRANT journalist TO hulda;\n\nGRANT journalist TO berengar WITH ADMIN OPTION;\n\nIf a user has been granted a role, they do not automatically obtain all\npermissions associated with that role. These permissions are only in use when\nthe user activates the role with the SET ROLE statement.\n\nTO PUBLIC\n---------\n\nMariaDB starting with 10.11\n---------------------------\n\nSyntax\n------\n\nGRANT <privilege> ON <database>.<object> TO PUBLIC;\nREVOKE <privilege> ON <database>.<object> FROM PUBLIC;\n\nGRANT ... TO PUBLIC grants privileges to all users with access to the server.\nThe privileges also apply to users created after the privileges are granted.\nThis can be useful when one only wants to state once that all users need to\nhave a certain set of privileges.\n\nWhen running SHOW GRANTS, a user will also see all privileges inherited from\nPUBLIC. SHOW GRANTS FOR PUBLIC will only show TO PUBLIC grants.\n\nGrant Examples\n--------------\n\nGranting Root-like Privileges\n-----------------------------\n\nYou can create a user that has privileges similar to the default root accounts\nby executing the following:\n\nCREATE USER \'alexander\'@\'localhost\';\nGRANT ALL PRIVILEGES ON  *.* to \'alexander\'@\'localhost\' WITH GRANT OPTION;\n\nURL: https://mariadb.com/kb/en/grant/','','https://mariadb.com/kb/en/grant/'),(117,'Authentication from MariaDB 10.4',10,'MariaDB starting with 10.4\n--------------------------\nMariaDB 10.4 introduced a number of changes to the authentication process,\nintended to make things easier and more intuitive.\n\nOverview\n--------\n\nThere are four new main features in 10.4 relating to authentication:\n\n* It is possible to use more than one authentication plugin for each user\naccount. For example, this can be useful to slowly migrate users to the more\nsecure ed25519 authentication plugin over time, while allowing the old\nmysql_native_password authentication plugin as an alternative for the\ntransitional period.\n* The root@localhost user account created by mysql_install_db is created with\nthe ability to use two authentication plugins.\nFirst, it is configured to try to use the unix_socket authentication plugin.\nThis allows the root@localhost user to login without a password via the local\nUnix socket file defined by the socket system variable, as long as the login\nis attempted from a process owned by the operating system root user account.\nSecond, if authentication fails with the unix_socket authentication plugin,\nthen it is configured to try to use the mysql_native_password authentication\nplugin. However, an invalid password is initially set, so in order to\nauthenticate this way, a password must be set with SET PASSWORD.\nHowever, just using the unix_socket authentication plugin may be fine for many\nusers, and it is very secure. You may want to try going without password\nauthentication to see how well it works for you. Remember, the best way to\nkeep your password safe is not to have one!\n\n* All user accounts, passwords, and global privileges are now stored in the\nmysql.global_priv table. The mysql.user table still exists and has exactly the\nsame set of columns as before, but it’s now a view that references the\nmysql.global_priv table. Tools that analyze the mysql.user table should\ncontinue to work as before. From MariaDB 10.4.13, the dedicated mariadb.sys\nuser is created as the definer of this view. Previously root was the definer,\nwhich resulted in privilege problems when this username was changed.\n* MariaDB 10.4 adds supports for User Password Expiry, which is not active by\ndefault.\n\nDescription\n-----------\n\nAs a result of the above changes, the open-for-everyone all-powerful root\naccount is finally gone. And installation scripts will no longer demand that\nyou \"PLEASE REMEMBER TO SET A PASSWORD FOR THE MariaDB root USER !\", because\nthe root account is securely created automatically.\n\nTwo all-powerful accounts are created by default — root and the OS user that\nowns the data directory, typically mysql. They are created as:\n\nCREATE USER root@localhost IDENTIFIED VIA unix_socket OR mysql_native_password\nUSING \'invalid\'\nCREATE USER mysql@localhost IDENTIFIED VIA unix_socket OR\nmysql_native_password USING \'invalid\'\n\nUsing unix_socket means that if you are the system root user, you can login as\nroot@locahost without a password. This technique was pioneered by Otto\nKekäläinen in Debian MariaDB packages and has been successfully used in Debian\nsince as early as MariaDB 10.0.\n\nIt is based on a simple fact that asking the system root for a password adds\nno extra security — root has full access to all the data files and all process\nmemory anyway. But not asking for a password means, there is no root password\nto forget (no need for the numerous tutorials on \"how to reset MariaDB root\npassword\"). And if you want to script some tedious database work, there is no\nneed to store the root password in plain text for the script to use (no need\nfor debian-sys-maint user).\n\nStill, some users may wish to log in as MariaDB root without using sudo. Hence\nthe old authentication method — conventional MariaDB password — is still\navailable. By default it is disabled (\"invalid\" is not a valid password hash),\nbut one can set the password with a usual SET PASSWORD statement. And still\nretain the password-less access via sudo.\n\nIf you install MariaDB locally (say from a tarball), you would not want to use\nsudo to be able to login. This is why MariaDB creates a second all-powerful\nuser with the same name as a system user that owns the data directory. In\nlocal (not system-wide) installations, this will be the user who installed\nMariaDB — they automatically get convenient password-less root-like access,\nbecause they can access all the data files anyway.\n\nEven if MariaDB is installed system-wide, you may not want to run your\ndatabase maintenance scripts as system root — now you can run them as system\nmysql user. And you will know that they will never destroy your entire system,\neven if you make a typo in a shell script.\n\nHowever, seasoned MariaDB DBAs who are used to the old ways do need to make\nsome changes. See the examples below for common tasks.\n\nCookbook\n--------\n\nAfter installing MariaDB system-wide the first thing you’ve got used to doing\nis logging in into the unprotected root account and protecting it, that is,\nsetting the root password:\n\n$ sudo dnf install MariaDB-server\n$ mysql -uroot\n...\nMariaDB> set password = password(\"XH4VmT3_jt\");\n\nThis is not only unnecessary now, it will simply not work — there is no\nunprotected root account. To login as root use\n\n$ sudo dnf install MariaDB-server\n$ sudo mysql\n\nNote that it implies you are connecting via the unix socket, not tcp. If you\nhappen to have protocol=tcp in a system-wide /etc/my.cnf file, use sudo mysql\n--protocol=socket.\n\nAfter installing MariaDB locally you’ve also used to connect to the\nunprotected root account using mysql -uroot. This will not work either, simply\nuse mysql without specifying a username.\n\nIf you\'ve forgotten your root password, no problem — you can still connect\nusing sudo and change the password. And if you\'ve also removed unix_socket\nauthentication, to restore access do as follows:\n\n* restart MariaDB with --skip-grant-tables\n* login into the unprotected server\n* run FLUSH PRIVILEGES (note, before 10.4 this would’ve been the last step,\nnot anymore). This disables --skip-grant-tables and allows you to change the\nstored authentication method\n* run SET PASSWORD FOR root@localhost to change the root password.\n\nTo view inside privilege tables, the old mysql.user table still exists. You\ncan select from it as before, although you cannot update it anymore. It\ndoesn’t show alternative authentication plugins and this was one of the\nreasons for switching to the mysql.global_priv table — complex authentication\nrules did not fit into rigid structure of a relational table. You can select\nfrom the new table, for example:\n\nselect concat(user, \'@\', host, \' => \', json_detailed(priv)) from\nmysql.global_priv;\n\nReverting to the Previous Authentication Method for root@localhost\n------------------------------------------------------------------\n\nIf you don\'t want the root@localhost user account created by mysql_install_db\nto use unix_socket authentication by default, then there are a few ways to\nrevert to the previous mysql_native_password authentication method for this\nuser account.\n\nConfiguring mysql_install_db to Revert to the Previous Authentication Method\n----------------------------------------------------------------------------\n\nOne way to revert to the previous mysql_native_password authentication method\nfor the root@localhost user account is to execute mysql_install_db with a\nspecial option. If mysql_install_db is executed while\n--auth-root-authentication-method=normal is specified, then it will create the\ndefault user accounts using the default behavior of MariaDB 10.3 and before.\n\nThis means that the root@localhost user account will use mysql_native_password\nauthentication by default. There are some other differences as well. See\nmysql_install_db: User Accounts Created by Default for more information.\n\nFor example, the option can be set on the command-line while running\nmysql_install_db:\n\nmysql_install_db --user=mysql --datadir=/var/lib/mysql\n--auth-root-authentication-method=normal\n\nThe option can also be set in an option file in an option group supported by\nmysql_install_db. For example:\n\n[mysql_install_db]\nauth_root_authentication_method=normal\n\nIf the option is set in an option file and if mysql_install_db is executed,\nthen mysql_install_db will read this option from the option file, and it will\nautomatically set this option.\n\nAltering the User Account to Revert to the Previous Authentication Method\n-------------------------------------------------------------------------\n\nIf you have already installed MariaDB, and if the root@localhost user account\nis already using unix_socket authentication, then you can revert to the old\nmysql_native_password authentication method for the user account by executing\nthe following:\n\nALTER USER root@localhost IDENTIFIED VIA mysql_native_password USING\nPASSWORD(\"verysecret\")\n\nURL: https://mariadb.com/kb/en/authentication-from-mariadb-104/','','https://mariadb.com/kb/en/authentication-from-mariadb-104/'),(119,'ST_X',11,'Syntax\n------\n\nST_X(p)\nX(p)\n\nDescription\n-----------\n\nReturns the X-coordinate value for the point p as a double-precision number.\n\nST_X() and X() are synonyms.\n\nExamples\n--------\n\nSET @pt = \'Point(56.7 53.34)\';\n\nSELECT X(GeomFromText(@pt));\n+----------------------+\n| X(GeomFromText(@pt)) |\n+----------------------+\n|                 56.7 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/st_x/','','https://mariadb.com/kb/en/st_x/'),(88,'IF Function',7,'Syntax\n------\n\nIF(expr1,expr2,expr3)\n\nDescription\n-----------\n\nIf expr1 is TRUE (expr1 <> 0 and expr1 <> NULL) then IF() returns expr2;\notherwise it returns expr3. IF() returns a numeric or string value, depending\non the context in which it is used.\n\nNote: There is also an IF statement which differs from the IF() function\ndescribed here.\n\nExamples\n--------\n\nSELECT IF(1>2,2,3);\n+-------------+\n| IF(1>2,2,3) |\n+-------------+\n|           3 |\n+-------------+\n\nSELECT IF(1<2,\'yes\',\'no\');\n+--------------------+\n| IF(1<2,\'yes\',\'no\') |\n+--------------------+\n| yes                |\n+--------------------+\n\nSELECT IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\');\n+---------------------------------------+\n| IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\') |\n+---------------------------------------+\n| no                                    |\n+---------------------------------------+\n\nURL: https://mariadb.com/kb/en/if-function/','','https://mariadb.com/kb/en/if-function/'),(89,'IFNULL',7,'Syntax\n------\n\nIFNULL(expr1,expr2)\nNVL(expr1,expr2)\n\nDescription\n-----------\n\nIf expr1 is not NULL, IFNULL() returns expr1; otherwise it returns expr2.\nIFNULL() returns a numeric or string value, depending on the context in which\nit is used.\n\nFrom MariaDB 10.3, NVL() is an alias for IFNULL().\n\nExamples\n--------\n\nSELECT IFNULL(1,0); \n+-------------+\n| IFNULL(1,0) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT IFNULL(NULL,10);\n+-----------------+\n| IFNULL(NULL,10) |\n+-----------------+\n|              10 |\n+-----------------+\n\nSELECT IFNULL(1/0,10);\n+----------------+\n| IFNULL(1/0,10) |\n+----------------+\n|        10.0000 |\n+----------------+\n\nSELECT IFNULL(1/0,\'yes\');\n+-------------------+\n| IFNULL(1/0,\'yes\') |\n+-------------------+\n| yes               |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/ifnull/','','https://mariadb.com/kb/en/ifnull/'),(94,'START TRANSACTION',8,'Syntax\n------\n\nSTART TRANSACTION [transaction_property [, transaction_property] ...] | BEGIN\n[WORK]\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nROLLBACK [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nSET autocommit = {0 | 1}\n\ntransaction_property:\n  WITH CONSISTENT SNAPSHOT\n | READ WRITE\n | READ ONLY\n\nDescription\n-----------\n\nThe START TRANSACTION or BEGIN statement begins a new transaction. COMMIT\ncommits the current transaction, making its changes permanent. ROLLBACK rolls\nback the current transaction, canceling its changes. The SET autocommit\nstatement disables or enables the default autocommit mode for the current\nsession.\n\nSTART TRANSACTION and SET autocommit = 1 implicitly commit the current\ntransaction, if any.\n\nThe optional WORK keyword is supported for COMMIT and ROLLBACK, as are the\nCHAIN and RELEASE clauses. CHAIN and RELEASE can be used for additional\ncontrol over transaction completion. The value of the completion_type system\nvariable determines the default completion behavior.\n\nThe AND CHAIN clause causes a new transaction to begin as soon as the current\none ends, and the new transaction has the same isolation level as the\njust-terminated transaction. The RELEASE clause causes the server to\ndisconnect the current client session after terminating the current\ntransaction. Including the NO keyword suppresses CHAIN or RELEASE completion,\nwhich can be useful if the completion_type system variable is set to cause\nchaining or release completion by default.\n\nAccess Mode\n-----------\n\nThe access mode specifies whether the transaction is allowed to write data or\nnot. By default, transactions are in READ WRITE mode (see the tx_read_only\nsystem variable). READ ONLY mode allows the storage engine to apply\noptimizations that cannot be used for transactions which write data. The only\nexception to this rule is that read only transactions can perform DDL\nstatements on temporary tables.\n\nIt is not permitted to specify both READ WRITE and READ ONLY in the same\nstatement.\n\nREAD WRITE and READ ONLY can also be specified in the SET TRANSACTION\nstatement, in which case the specified mode is valid for all sessions, or for\nall subsequent transaction used by the current session.\n\nautocommit\n----------\n\nBy default, MariaDB runs with autocommit mode enabled. This means that as soon\nas you execute a statement that updates (modifies) a table, MariaDB stores the\nupdate on disk to make it permanent. To disable autocommit mode, use the\nfollowing statement:\n\nSET autocommit=0;\n\nAfter disabling autocommit mode by setting the autocommit variable to zero,\nchanges to transaction-safe tables (such as those for InnoDB or NDBCLUSTER)\nare not made permanent immediately. You must use COMMIT to store your changes\nto disk or ROLLBACK to ignore the changes.\n\nTo disable autocommit mode for a single series of statements, use the START\nTRANSACTION statement.\n\nDDL Statements\n--------------\n\nDDL statements (CREATE, ALTER, DROP) and administrative statements (FLUSH,\nRESET, OPTIMIZE, ANALYZE, CHECK, REPAIR, CACHE INDEX), transaction management\nstatements (BEGIN, START TRANSACTION) and LOAD DATA INFILE, cause an implicit\nCOMMIT and start a new transaction. An exception to this rule are the DDL that\noperate on temporary tables: you can CREATE, ALTER and DROP them without\ncausing any COMMIT, but those actions cannot be rolled back. This means that\nif you call ROLLBACK, the temporary tables you created in the transaction will\nremain, while the rest of the transaction will be rolled back.\n\nTransactions cannot be used in Stored Functions or Triggers. In Stored\nProcedures and Events BEGIN is not allowed, so you should use START\nTRANSACTION instead.\n\nA transaction acquires a metadata lock on every table it accesses to prevent\nother connections from altering their structure. The lock is released at the\nend of the transaction. This happens even with non-transactional storage\nengines (like MEMORY or CONNECT), so it makes sense to use transactions with\nnon-transactional tables.\n\nin_transaction\n--------------\n\nThe in_transaction system variable is a session-only, read-only variable that\nreturns 1 inside a transaction, and 0 if not in a transaction.\n\nWITH CONSISTENT SNAPSHOT\n------------------------\n\nThe WITH CONSISTENT SNAPSHOT option starts a consistent read for storage\nengines such as InnoDB that can do so, the same as if a START TRANSACTION\nfollowed by a SELECT from any InnoDB table was issued.\n\nSee Enhancements for START TRANSACTION WITH CONSISTENT SNAPSHOT.\n\nExamples\n--------\n\nSTART TRANSACTION;\nSELECT @A:=SUM(salary) FROM table1 WHERE type=1;\nUPDATE table2 SET summary=@A WHERE type=1;\nCOMMIT;\n\nURL: https://mariadb.com/kb/en/start-transaction/','','https://mariadb.com/kb/en/start-transaction/'),(120,'ST_Y',11,'Syntax\n------\n\nST_Y(p)\nY(p)\n\nDescription\n-----------\n\nReturns the Y-coordinate value for the point p as a double-precision number.\n\nST_Y() and Y() are synonyms.\n\nExamples\n--------\n\nSET @pt = \'Point(56.7 53.34)\';\n\nSELECT Y(GeomFromText(@pt));\n+----------------------+\n| Y(GeomFromText(@pt)) |\n+----------------------+\n|                53.34 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/st_y/','','https://mariadb.com/kb/en/st_y/'),(121,'X',11,'A synonym for ST_X.\n\nURL: https://mariadb.com/kb/en/point-properties-x/','','https://mariadb.com/kb/en/point-properties-x/'),(122,'Y',11,'A synonym for ST_Y.\n\nURL: https://mariadb.com/kb/en/point-properties-y/','','https://mariadb.com/kb/en/point-properties-y/'),(125,'DECODE_ORACLE',12,'MariaDB starting with 10.3.2\n----------------------------\nDECODE_ORACLE is a synonym for the Oracle mode version of the DECODE function,\nand is available in all modes.\n\nURL: https://mariadb.com/kb/en/decode_oracle/','','https://mariadb.com/kb/en/decode_oracle/'),(93,'SET TRANSACTION',8,'Syntax\n------\n\nSET [GLOBAL | SESSION] TRANSACTION\n  transaction_property [, transaction_property] ...\n\ntransaction_property:\n  ISOLATION LEVEL level\n | READ WRITE\n | READ ONLY\n\nlevel:\n  REPEATABLE READ\n | READ COMMITTED\n | READ UNCOMMITTED\n | SERIALIZABLE\n\nDescription\n-----------\n\nThis statement sets the transaction isolation level or the transaction access\nmode globally, for the current session, or for the next transaction:\n\n* With the GLOBAL keyword, the statement sets the default\n transaction level globally for all subsequent sessions. Existing sessions are\n unaffected.\n* With the SESSION keyword, the statement sets the default\n transaction level for all subsequent transactions performed within the\n current session.\n* Without any SESSION or GLOBAL keyword,\n the statement sets the isolation level for the next (not started) transaction\n performed within the current session.\n\nA change to the global default isolation level requires the SUPER privilege.\nAny session is free to change its session isolation level (even in the middle\nof a transaction), or the isolation level for its next transaction.\n\nIsolation Level\n---------------\n\nTo set the global default isolation level at server startup, use the\n--transaction-isolation=level option on the command line or in an option file.\nValues of level for this option use dashes rather than spaces, so the\nallowable values are READ-UNCOMMITTED, READ-COMMITTED, REPEATABLE-READ, or\nSERIALIZABLE. For example, to set the default isolation level to REPEATABLE\nREAD, use these lines in the [mysqld] section of an option file:\n\n[mysqld]\ntransaction-isolation = REPEATABLE-READ\nTo determine the global and session transaction isolation levels at runtime,\ncheck the value of the tx_isolation system variable:\n\nSELECT @@GLOBAL.tx_isolation, @@tx_isolation;\n\nInnoDB supports each of the translation isolation levels described here using\ndifferent locking strategies. The default level is REPEATABLE READ. For\nadditional information about InnoDB record-level locks and how it uses them to\nexecute various types of statements, see InnoDB Lock Modes, and\nhttp://dev.mysql.com/doc/refman/en/innodb-locks-set.html.\n\nIsolation Levels\n----------------\n\nThe following sections describe how MariaDB supports the different transaction\nlevels.\n\nREAD UNCOMMITTED\n----------------\n\nSELECT statements are performed in a non-locking fashion, but a possible\nearlier version of a row might be used. Thus, using this isolation level, such\nreads are not consistent. This is also called a \"dirty read.\" Otherwise, this\nisolation level works like READ COMMITTED.\n\nREAD COMMITTED\n--------------\n\nA somewhat Oracle-like isolation level with respect to consistent\n(non-locking) reads: Each consistent read, even within the same transaction,\nsets and reads its own fresh snapshot. See\nhttp://dev.mysql.com/doc/refman/en/innodb-consistent-read.html.\n\nFor locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE), InnoDB locks\nonly index records, not the gaps before them, and thus allows the free\ninsertion of new records next to locked records. For UPDATE and DELETE\nstatements, locking depends on whether the statement uses a unique index with\na unique search condition (such as WHERE id = 100), or a range-type search\ncondition (such as WHERE id > 100). For a unique index with a unique search\ncondition, InnoDB locks only the index record found, not the gap before it.\nFor range-type searches, InnoDB locks the index range scanned, using gap locks\nor next-key (gap plus index-record) locks to block insertions by other\nsessions into the gaps covered by the range. This is necessary because\n\"phantom rows\" must be blocked for MySQL replication and recovery to work.\n\nNote: If the READ COMMITTED isolation level is used or the\ninnodb_locks_unsafe_for_binlog system variable is enabled, there is no InnoDB\ngap locking except for foreign-key constraint checking and duplicate-key\nchecking. Also, record locks for non-matching rows are released after MariaDB\nhas evaluated the WHERE condition.If you use READ COMMITTED or enable\ninnodb_locks_unsafe_for_binlog, you must use row-based binary logging.\n\nREPEATABLE READ\n---------------\n\nThis is the default isolation level for InnoDB. For consistent reads, there is\nan important difference from the READ COMMITTED isolation level: All\nconsistent reads within the same transaction read the snapshot established by\nthe first read. This convention means that if you issue several plain\n(non-locking) SELECT statements within the same transaction, these SELECT\nstatements are consistent also with respect to each other. See\nhttp://dev.mysql.com/doc/refman/en/innodb-consistent-read.html.\n\nFor locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE), UPDATE, and\nDELETE statements, locking depends on whether the statement uses a unique\nindex with a unique search condition, or a range-type search condition. For a\nunique index with a unique search condition, InnoDB locks only the index\nrecord found, not the gap before it. For other search conditions, InnoDB locks\nthe index range scanned, using gap locks or next-key (gap plus index-record)\nlocks to block insertions by other sessions into the gaps covered by the range.\n\nThis is the minimum isolation level for non-distributed XA transactions.\n\nSERIALIZABLE\n------------\n\nThis level is like REPEATABLE READ, but InnoDB implicitly converts all plain\nSELECT statements to SELECT ... LOCK IN SHARE MODE if autocommit is disabled.\nIf autocommit is enabled, the SELECT is its own transaction. It therefore is\nknown to be read only and can be serialized if performed as a consistent\n(non-locking) read and need not block for other transactions. (This means that\nto force a plain SELECT to block if other transactions have modified the\nselected rows, you should disable autocommit.)\n\nDistributed XA transactions should always use this isolation level.\n\nAccess Mode\n-----------\n\nThe access mode specifies whether the transaction is allowed to write data or\nnot. By default, transactions are in READ WRITE mode (see the tx_read_only\nsystem variable). READ ONLY mode allows the storage engine to apply\noptimizations that cannot be used for transactions which write data. The only\nexception to this rule is that read only transactions can perform DDL\nstatements on temporary tables.\n\nIt is not permitted to specify both READ WRITE and READ ONLY in the same\nstatement.\n\nREAD WRITE and READ ONLY can also be specified in the START TRANSACTION\nstatement, in which case the specified mode is only valid for one transaction.\n\nExamples\n--------\n\nSET GLOBAL TRANSACTION ISOLATION LEVEL SERIALIZABLE;\n\nAttempting to set the isolation level within an existing transaction without\nspecifying GLOBAL or SESSION.\n\nSTART TRANSACTION;\n\nSET TRANSACTION ISOLATION LEVEL SERIALIZABLE;\nERROR 1568 (25001): Transaction characteristics can\'t be changed while a\ntransaction is in progress\n\nURL: https://mariadb.com/kb/en/set-transaction/','','https://mariadb.com/kb/en/set-transaction/'),(126,'AES_DECRYPT',12,'Syntax\n------\n\nAES_DECRYPT(crypt_str,key_str)\n\nDescription\n-----------\n\nThis function allows decryption of data using the official AES (Advanced\nEncryption Standard) algorithm. For more information, see the description of\nAES_ENCRYPT().\n\nURL: https://mariadb.com/kb/en/aes_decrypt/','','https://mariadb.com/kb/en/aes_decrypt/'),(133,'MD5',12,'Syntax\n------\n\nMD5(str)\n\nDescription\n-----------\n\nCalculates an MD5 128-bit checksum for the string.\n\nThe return value is a 32-hex digit string, and as of MariaDB 5.5, is a\nnonbinary string in the connection character set and collation, determined by\nthe values of the character_set_connection and collation_connection system\nvariables. Before 5.5, the return value was a binary string.\n\nNULL is returned if the argument was NULL.\n\nExamples\n--------\n\nSELECT MD5(\'testing\');\n+----------------------------------+\n| MD5(\'testing\')                   |\n+----------------------------------+\n| ae2b1fca515949e5d54fb22b8ed95575 |\n+----------------------------------+\n\nURL: https://mariadb.com/kb/en/md5/','','https://mariadb.com/kb/en/md5/'),(95,'COMMIT',8,'The COMMIT statement ends a transaction, saving any changes to the data so\nthat they become visible to subsequent transactions. Also, unlocks metadata\nchanged by current transaction. If autocommit is set to 1, an implicit commit\nis performed after each statement. Otherwise, all transactions which don\'t end\nwith an explicit COMMIT are implicitly rollbacked and the changes are lost.\nThe ROLLBACK statement can be used to do this explicitly.\n\nThe required syntax for the COMMIT statement is as follows:\n\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\n\nCOMMIT is the more important transaction terminator, as well as the more\ninteresting one. The basic form of the COMMIT statement is simply the keyword\nCOMMIT (the keyword WORK is simply noise and can be omitted without changing\nthe effect).\n\nThe optional AND CHAIN clause is a convenience for initiating a new\ntransaction as soon as the old transaction terminates. If AND CHAIN is\nspecified, then there is effectively nothing between the old and new\ntransactions, although they remain separate. The characteristics of the new\ntransaction will be the same as the characteristics of the old one — that is,\nthe new transaction will have the same access mode, isolation level and\ndiagnostics area size (we\'ll discuss all of these shortly) as the transaction\njust terminated.\n\nRELEASE tells the server to disconnect the client immediately after the\ncurrent transaction.\n\nThere are NO RELEASE and AND NO CHAIN options. By default, commits do not\nRELEASE or CHAIN, but it\'s possible to change this default behavior with the\ncompletion_type server system variable. In this case, the AND NO CHAIN and NO\nRELEASE options override the server default.\n\nURL: https://mariadb.com/kb/en/commit/','','https://mariadb.com/kb/en/commit/'),(96,'ROLLBACK',8,'The ROLLBACK statement rolls back (ends) a transaction, destroying any changes\nto SQL-data so that they never become visible to subsequent transactions. The\nrequired syntax for the ROLLBACK statement is as follows.\n\nROLLBACK [ WORK ] [ AND [ NO ] CHAIN ] \n[ TO [ SAVEPOINT ] {<savepoint name> | <simple target specification>} ]\n\nThe ROLLBACK statement will either end a transaction, destroying all data\nchanges that happened during any of the transaction, or it will just destroy\nany data changes that happened since you established a savepoint. The basic\nform of the ROLLBACK statement is just the keyword ROLLBACK (the keyword WORK\nis simply noise and can be omitted without changing the effect).\n\nThe optional AND CHAIN clause is a convenience for initiating a new\ntransaction as soon as the old transaction terminates. If AND CHAIN is\nspecified, then there is effectively nothing between the old and new\ntransactions, although they remain separate. The characteristics of the new\ntransaction will be the same as the characteristics of the old one — that is,\nthe new transaction will have the same access mode, isolation level and\ndiagnostics area size (we\'ll discuss all of these shortly) as the transaction\njust terminated. The AND NO CHAIN option just tells your DBMS to end the\ntransaction — that is, these four SQL statements are equivalent:\n\nROLLBACK; \nROLLBACK WORK; \nROLLBACK AND NO CHAIN; \nROLLBACK WORK AND NO CHAIN;\n\nAll of them end a transaction without saving any transaction characteristics.\nThe only other options, the equivalent statements:\n\nROLLBACK AND CHAIN;\nROLLBACK WORK AND CHAIN;\n\nboth tell your DBMS to end a transaction, but to save that transaction\'s\ncharacteristics for the next transaction.\n\nROLLBACK is much simpler than COMMIT: it may involve no more than a few\ndeletions (of Cursors, locks, prepared SQL statements and log-file entries).\nIt\'s usually assumed that ROLLBACK can\'t fail, although such a thing is\nconceivable (for example, an encompassing transaction might reject an attempt\nto ROLLBACK because it\'s lining up for a COMMIT).\n\nROLLBACK cancels all effects of a transaction. It does not cancel effects on\nobjects outside the DBMS\'s control (for example the values in host program\nvariables or the settings made by some SQL/CLI function calls). But in\ngeneral, it is a convenient statement for those situations when you say \"oops,\nthis isn\'t working\" or when you simply don\'t care whether your temporary work\nbecomes permanent or not.\n\nHere is a moot question. If all you\'ve been doing is SELECTs, so that there\nhave been no data changes, should you end the transaction with ROLLBACK or\nCOMMIT? It shouldn\'t really matter because both ROLLBACK and COMMIT do the\nsame transaction-terminating job. However, the popular conception is that\nROLLBACK implies failure, so after a successful series of SELECT statements\nthe convention is to end the transaction with COMMIT rather than ROLLBACK.\n\nMariaDB (and most other DBMSs) supports rollback of SQL-data change\nstatements, but not of SQL-Schema statements. This means that if you use any\nof CREATE, ALTER, DROP, GRANT, REVOKE, you are implicitly committing at\nexecution time.\n\nINSERT INTO Table_2 VALUES(5); \nDROP TABLE Table_3 CASCADE; \nROLLBACK;\n\nThe result will be that both the INSERT and the DROP will go through as\nseparate transactions so the ROLLBACK will have no effect.\n\nURL: https://mariadb.com/kb/en/rollback/','','https://mariadb.com/kb/en/rollback/'),(138,'ENDPOINT',13,'A synonym for ST_ENDPOINT.\n\nURL: https://mariadb.com/kb/en/linestring-properties-endpoint/','','https://mariadb.com/kb/en/linestring-properties-endpoint/'),(139,'GLENGTH',13,'Syntax\n------\n\nGLength(ls)\n\nDescription\n-----------\n\nReturns as a double-precision number the length of the LineString value ls in\nits associated spatial reference.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT GLength(GeomFromText(@ls));\n+----------------------------+\n| GLength(GeomFromText(@ls)) |\n+----------------------------+\n|           2.82842712474619 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/glength/','','https://mariadb.com/kb/en/glength/'),(140,'NumPoints',13,'A synonym for ST_NumPoints.\n\nURL: https://mariadb.com/kb/en/linestring-properties-numpoints/','','https://mariadb.com/kb/en/linestring-properties-numpoints/'),(141,'PointN',13,'A synonym for ST_PointN.\n\nURL: https://mariadb.com/kb/en/linestring-properties-pointn/','','https://mariadb.com/kb/en/linestring-properties-pointn/'),(142,'STARTPOINT',13,'A synonym for ST_STARTPOINT.\n\nURL: https://mariadb.com/kb/en/linestring-properties-startpoint/','','https://mariadb.com/kb/en/linestring-properties-startpoint/'),(143,'ST_ENDPOINT',13,'Syntax\n------\n\nST_EndPoint(ls)\nEndPoint(ls)\n\nDescription\n-----------\n\nReturns the Point that is the endpoint of the LineString value ls.\n\nST_EndPoint() and EndPoint() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(EndPoint(GeomFromText(@ls)));\n+-------------------------------------+\n| AsText(EndPoint(GeomFromText(@ls))) |\n+-------------------------------------+\n| POINT(3 3)                          |\n+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_endpoint/','','https://mariadb.com/kb/en/st_endpoint/'),(144,'ST_NUMPOINTS',13,'Syntax\n------\n\nST_NumPoints(ls)\nNumPoints(ls)\n\nDescription\n-----------\n\nReturns the number of Point objects in the LineString value ls.\n\nST_NumPoints() and NumPoints() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT NumPoints(GeomF