/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `barbican`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `barbican` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `barbican`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('8c74e2d7f1ff');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authorities`
--

DROP TABLE IF EXISTS `certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `plugin_ca_id` text NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cas_project_fk` (`project_id`),
  CONSTRAINT `cas_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authorities`
--

LOCK TABLES `certificate_authorities` WRITE;
/*!40000 ALTER TABLE `certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authority_metadata`
--

DROP TABLE IF EXISTS `certificate_authority_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authority_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_certificate_authority_metadatum_uc` (`ca_id`,`key`),
  KEY `ix_certificate_authority_metadata_ca_id` (`ca_id`),
  KEY `ix_certificate_authority_metadata_key` (`key`),
  CONSTRAINT `certificate_authority_metadata_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authority_metadata`
--

LOCK TABLES `certificate_authority_metadata` WRITE;
/*!40000 ALTER TABLE `certificate_authority_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authority_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acl_users`
--

DROP TABLE IF EXISTS `container_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_container_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `container_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `container_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acl_users`
--

LOCK TABLES `container_acl_users` WRITE;
/*!40000 ALTER TABLE `container_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acls`
--

DROP TABLE IF EXISTS `container_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_operation_uc` (`container_id`,`operation`),
  KEY `ix_container_acls_container_id` (`container_id`),
  CONSTRAINT `container_acls_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acls`
--

LOCK TABLES `container_acls` WRITE;
/*!40000 ALTER TABLE `container_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_consumer_metadata`
--

DROP TABLE IF EXISTS `container_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `name` varchar(36) DEFAULT NULL,
  `URL` varchar(255) DEFAULT NULL,
  `data_hash` char(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_consumer_hashed_container_name_url_uc` (`data_hash`),
  KEY `ix_container_consumer_metadata_container_id` (`container_id`),
  KEY `ix_container_consumer_metadata_project_id` (`project_id`),
  KEY `values_index` (`container_id`,`name`,`URL`),
  CONSTRAINT `container_consumer_metadata_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_consumer_metadata_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_consumer_metadata`
--

LOCK TABLES `container_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `container_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_secret`
--

DROP TABLE IF EXISTS `container_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_secret` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `container_id` varchar(36) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_secret_name_uc` (`container_id`,`secret_id`,`name`),
  KEY `ix_container_secret_container_id` (`container_id`),
  KEY `ix_container_secret_secret_id` (`secret_id`),
  CONSTRAINT `container_secret_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_secret_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_secret`
--

LOCK TABLES `container_secret` WRITE;
/*!40000 ALTER TABLE `container_secret` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `containers`
--

DROP TABLE IF EXISTS `containers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `containers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('generic','rsa','dsa','certificate') DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_containers_project_id` (`project_id`),
  CONSTRAINT `containers_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `containers`
--

LOCK TABLES `containers` WRITE;
/*!40000 ALTER TABLE `containers` DISABLE KEYS */;
/*!40000 ALTER TABLE `containers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encrypted_data`
--

DROP TABLE IF EXISTS `encrypted_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encrypted_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `secret_id` varchar(36) NOT NULL,
  `kek_id` varchar(36) NOT NULL,
  `cypher_text` text DEFAULT NULL,
  `kek_meta_extended` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_encrypted_data_kek_id` (`kek_id`),
  KEY `ix_encrypted_data_secret_id` (`secret_id`),
  CONSTRAINT `encrypted_data_ibfk_1` FOREIGN KEY (`kek_id`) REFERENCES `kek_data` (`id`),
  CONSTRAINT `encrypted_data_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encrypted_data`
--

LOCK TABLES `encrypted_data` WRITE;
/*!40000 ALTER TABLE `encrypted_data` DISABLE KEYS */;
INSERT INTO `encrypted_data` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `content_type`, `secret_id`, `kek_id`, `cypher_text`, `kek_meta_extended`) VALUES ('61d3f6f4-3ca4-4944-a668-5096ba7b7fbf','2025-10-02 13:02:35','2025-10-02 13:03:31','2025-10-02 13:03:31',1,'ACTIVE','application/octet-stream','c869a339-7d8b-47df-83d3-eb6943847d77','8260ddfa-6b7b-4afa-8ef4-3fbd49e8c0e5','Z0FBQUFBQm8zbmZyZGh3WTJ6eXJ0UkNoTm1TT3QzSnJCOFZQU05fTkRQejR2RXhReDktREw2UnNaQm9KMDV6LVNqUXhOR0p2dmhRVTNhS3BXWi1BSEt0Q2pGLXZpbE9GRXl4c3g4aWdydFJIcWo0SHl6VVp1RkJteXByM2dMWTV5TnBtazlBN00xMkE=',NULL),('f5448790-966a-48a2-aeca-6cd5777b6b26','2025-10-02 13:26:06','2025-10-02 13:26:33','2025-10-02 13:26:33',1,'ACTIVE','application/octet-stream','5df1a5a9-8b62-44cc-bef4-5aec82b14056','170c08fe-15db-429e-acdb-e6f0e0f1cd66','Z0FBQUFBQm8zbjF1WDVxaXlUQ0FTWEZDWHV3QU5qRHVOdWZjNXUyS2NtZnVhTDhMZHNPN0lOLXpKWUdzdy02ZDlBOF8tQlNFSF9lZHRGYThxUkZ6LW51MmZBeThVNWd3S3NuNlFEc0Zkcl9UbEhhUDFJYmhIZmtuNDFNdTR6THc0Rm5WU3FNRnBENHU=',NULL);
/*!40000 ALTER TABLE `encrypted_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kek_data`
--

DROP TABLE IF EXISTS `kek_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kek_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `kek_label` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `bind_completed` tinyint(1) NOT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `plugin_meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_kek_data_project_id` (`project_id`),
  CONSTRAINT `kek_data_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kek_data`
--

LOCK TABLES `kek_data` WRITE;
/*!40000 ALTER TABLE `kek_data` DISABLE KEYS */;
INSERT INTO `kek_data` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `plugin_name`, `kek_label`, `project_id`, `active`, `bind_completed`, `algorithm`, `bit_length`, `mode`, `plugin_meta`) VALUES ('170c08fe-15db-429e-acdb-e6f0e0f1cd66','2025-10-02 13:26:06','2025-10-02 13:32:53','2025-10-02 13:32:53',1,'ACTIVE','barbican.plugin.crypto.simple_crypto.SimpleCryptoPlugin','project-18799a1c93354809911705bb424e673f-key-61b8403e-8048-4614-a716-c2ebc3518377','58cfb09b-3612-42e5-88e1-c3fd0680c883',1,1,'aes',128,'cbc','gAAAAABo3n1uq-EfeS1Lu4F9gByPsMbDHLIdygixZO917ycM1cBtGXWqCow27hu3vW6pvIuICqhH8e1NqqZ7eKA7lVK8K5BJrFld-WqyOsKfCJk1XDySFrFmiRdo3Tne8Uty65XWZPFe'),('8260ddfa-6b7b-4afa-8ef4-3fbd49e8c0e5','2025-10-02 13:02:35','2025-10-02 13:03:45','2025-10-02 13:03:45',1,'ACTIVE','barbican.plugin.crypto.simple_crypto.SimpleCryptoPlugin','project-6e8f1f6ceb7b40ee9fa002d881b59a44-key-d46ea187-0272-48b4-a698-61188c574180','f314cd59-9471-4241-8934-17105b8c50e4',1,1,'aes',128,'cbc','gAAAAABo3nfrgxhKGYfru3uxkbO3yL7Egsio1uie-PcLDxuKErlmrJudXdTQA_gzbpruM4ySPluRdMRpZXNOoxMW4m_LWXWV0F3h8MATaCnJ7FR-xzyz_WJVC8XoEY7S9VRvaQYVKzV1');
/*!40000 ALTER TABLE `kek_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_barbican_metadata`
--

DROP TABLE IF EXISTS `order_barbican_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_barbican_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_barbican_metadata_order_id` (`order_id`),
  CONSTRAINT `order_barbican_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_barbican_metadata`
--

LOCK TABLES `order_barbican_metadata` WRITE;
/*!40000 ALTER TABLE `order_barbican_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_barbican_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_plugin_metadata`
--

DROP TABLE IF EXISTS `order_plugin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_plugin_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_plugin_metadata_order_id` (`order_id`),
  CONSTRAINT `order_plugin_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_plugin_metadata`
--

LOCK TABLES `order_plugin_metadata` WRITE;
/*!40000 ALTER TABLE `order_plugin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_plugin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_retry_tasks`
--

DROP TABLE IF EXISTS `order_retry_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_retry_tasks` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `id` varchar(36) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `retry_task` text NOT NULL,
  `retry_at` datetime NOT NULL,
  `retry_args` text NOT NULL,
  `retry_kwargs` text NOT NULL,
  `retry_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_retry_tasks_order_id` (`order_id`),
  CONSTRAINT `order_retry_tasks_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_retry_tasks`
--

LOCK TABLES `order_retry_tasks` WRITE;
/*!40000 ALTER TABLE `order_retry_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_retry_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `error_status_code` varchar(16) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  `secret_id` varchar(36) DEFAULT NULL,
  `container_id` varchar(36) DEFAULT NULL,
  `sub_status` varchar(36) DEFAULT NULL,
  `sub_status_message` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_orders_container_id` (`container_id`),
  KEY `ix_orders_project_id` (`project_id`),
  KEY `ix_orders_secret_id` (`secret_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`),
  CONSTRAINT `orders_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
INSERT INTO `orders` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `type`, `project_id`, `error_status_code`, `error_reason`, `meta`, `secret_id`, `container_id`, `sub_status`, `sub_status_message`, `creator_id`) VALUES ('46f8f74c-f3ef-42b3-9de5-faaa0fefb125','2025-10-02 13:26:06','2025-10-02 13:26:06',NULL,0,'ACTIVE','key','58cfb09b-3612-42e5-88e1-c3fd0680c883',NULL,NULL,'{\"algorithm\": \"aes\", \"bit_length\": 256, \"name\": null, \"expiration\": null}','5df1a5a9-8b62-44cc-bef4-5aec82b14056',NULL,'Unknown','Unknown','2cb47684d0b34c729e9611e7b3943bed'),('b66d3e2b-d7dc-4ed3-82b9-00387aa02a8a','2025-10-02 13:02:34','2025-10-02 13:02:35',NULL,0,'ACTIVE','key','f314cd59-9471-4241-8934-17105b8c50e4',NULL,NULL,'{\"algorithm\": \"aes\", \"bit_length\": 256, \"name\": null, \"expiration\": null}','c869a339-7d8b-47df-83d3-eb6943847d77',NULL,'Unknown','Unknown','cb1643b3981d49ceaebfabe1577596fd');
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preferred_certificate_authorities`
--

DROP TABLE IF EXISTS `preferred_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `preferred_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_preferred_certificate_authorities_project_id` (`project_id`),
  KEY `ix_preferred_certificate_authorities_ca_id` (`ca_id`),
  CONSTRAINT `preferred_certificate_authorities_fk` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `preferred_certificate_authorities_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preferred_certificate_authorities`
--

LOCK TABLES `preferred_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `preferred_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `preferred_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_certificate_authorities`
--

DROP TABLE IF EXISTS `project_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_certificate_authority_uc` (`project_id`,`ca_id`),
  KEY `ix_project_certificate_authorities_ca_id` (`ca_id`),
  KEY `ix_project_certificate_authorities_project_id` (`project_id`),
  CONSTRAINT `project_certificate_authorities_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `project_certificate_authorities_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_certificate_authorities`
--

LOCK TABLES `project_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `project_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_quotas`
--

DROP TABLE IF EXISTS `project_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_quotas` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `secrets` int(11) DEFAULT NULL,
  `orders` int(11) DEFAULT NULL,
  `containers` int(11) DEFAULT NULL,
  `consumers` int(11) DEFAULT NULL,
  `cas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_project_quotas_project_id` (`project_id`),
  CONSTRAINT `project_quotas_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_quotas`
--

LOCK TABLES `project_quotas` WRITE;
/*!40000 ALTER TABLE `project_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_secret_store`
--

DROP TABLE IF EXISTS `project_secret_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_secret_store` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_store_id` varchar(36) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_secret_store_project_uc` (`project_id`),
  KEY `ix_project_secret_store_project_id` (`project_id`),
  KEY `ix_project_secret_store_secret_store_id` (`secret_store_id`),
  CONSTRAINT `project_secret_store_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `project_secret_store_ibfk_2` FOREIGN KEY (`secret_store_id`) REFERENCES `secret_stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_secret_store`
--

LOCK TABLES `project_secret_store` WRITE;
/*!40000 ALTER TABLE `project_secret_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_secret_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `external_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
INSERT INTO `projects` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `external_id`) VALUES ('58cfb09b-3612-42e5-88e1-c3fd0680c883','2025-10-02 13:26:06','2025-10-02 13:32:53','2025-10-02 13:32:53',1,'ACTIVE','18799a1c93354809911705bb424e673f'),('f314cd59-9471-4241-8934-17105b8c50e4','2025-10-02 13:02:34','2025-10-02 13:03:45','2025-10-02 13:03:45',1,'ACTIVE','6e8f1f6ceb7b40ee9fa002d881b59a44');
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acl_users`
--

DROP TABLE IF EXISTS `secret_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_secret_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `secret_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `secret_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acl_users`
--

LOCK TABLES `secret_acl_users` WRITE;
/*!40000 ALTER TABLE `secret_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acls`
--

DROP TABLE IF EXISTS `secret_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_operation_uc` (`secret_id`,`operation`),
  KEY `ix_secret_acls_secret_id` (`secret_id`),
  CONSTRAINT `secret_acls_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acls`
--

LOCK TABLES `secret_acls` WRITE;
/*!40000 ALTER TABLE `secret_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_consumer_metadata`
--

DROP TABLE IF EXISTS `secret_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `service` varchar(255) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_consumer_resource_uc` (`secret_id`,`service`,`resource_type`,`resource_id`),
  KEY `ix_secret_consumer_metadata_resource_id` (`resource_id`),
  KEY `ix_secret_consumer_metadata_secret_id` (`secret_id`),
  KEY `ix_secret_consumer_metadata_project_id` (`project_id`),
  CONSTRAINT `fk_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `secret_consumer_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_consumer_metadata`
--

LOCK TABLES `secret_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `secret_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_store_metadata`
--

DROP TABLE IF EXISTS `secret_store_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_store_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secret_store_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_store_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_store_metadata`
--

LOCK TABLES `secret_store_metadata` WRITE;
/*!40000 ALTER TABLE `secret_store_metadata` DISABLE KEYS */;
INSERT INTO `secret_store_metadata` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `key`, `value`, `secret_id`) VALUES ('5b50ebc5-fc86-4fe4-845b-1d86d890b7e8','2025-10-02 13:02:35','2025-10-02 13:03:31','2025-10-02 13:03:31',1,'PENDING','content_type','application/octet-stream','c869a339-7d8b-47df-83d3-eb6943847d77'),('d40e4f4a-7787-447f-93df-4c8b1528ca72','2025-10-02 13:26:06','2025-10-02 13:26:33','2025-10-02 13:26:33',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','5df1a5a9-8b62-44cc-bef4-5aec82b14056'),('de3e4b91-b8a8-4048-99de-803c242d340b','2025-10-02 13:26:06','2025-10-02 13:26:33','2025-10-02 13:26:33',1,'PENDING','content_type','application/octet-stream','5df1a5a9-8b62-44cc-bef4-5aec82b14056'),('fd8c55eb-e65c-4870-89d1-7ccfb9583089','2025-10-02 13:02:35','2025-10-02 13:03:31','2025-10-02 13:03:31',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','c869a339-7d8b-47df-83d3-eb6943847d77');
/*!40000 ALTER TABLE `secret_store_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_stores`
--

DROP TABLE IF EXISTS `secret_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_stores` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `store_plugin` varchar(255) NOT NULL,
  `crypto_plugin` varchar(255) DEFAULT NULL,
  `global_default` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_stores_name_uc` (`name`),
  UNIQUE KEY `_secret_stores_plugin_names_uc` (`store_plugin`,`crypto_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_stores`
--

LOCK TABLES `secret_stores` WRITE;
/*!40000 ALTER TABLE `secret_stores` DISABLE KEYS */;
INSERT INTO `secret_stores` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `store_plugin`, `crypto_plugin`, `global_default`, `name`) VALUES ('4d9dad65-4e07-4034-a9f7-4a5bd8e5dfaa','2025-10-02 11:30:08','2025-10-02 11:30:08',NULL,0,'ACTIVE','store_crypto','simple_crypto',1,'Software Only Crypto');
/*!40000 ALTER TABLE `secret_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_user_metadata`
--

DROP TABLE IF EXISTS `secret_user_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_user_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_key_uc` (`secret_id`,`key`),
  KEY `ix_secret_user_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_user_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_user_metadata`
--

LOCK TABLES `secret_user_metadata` WRITE;
/*!40000 ALTER TABLE `secret_user_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_user_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secrets`
--

DROP TABLE IF EXISTS `secrets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secrets` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `secret_type` varchar(255) DEFAULT 'opaque',
  `expiration` datetime DEFAULT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secrets_project_id` (`project_id`),
  CONSTRAINT `secrets_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secrets`
--

LOCK TABLES `secrets` WRITE;
/*!40000 ALTER TABLE `secrets` DISABLE KEYS */;
INSERT INTO `secrets` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `name`, `secret_type`, `expiration`, `algorithm`, `bit_length`, `mode`, `creator_id`, `project_id`) VALUES ('5df1a5a9-8b62-44cc-bef4-5aec82b14056','2025-10-02 13:26:06','2025-10-02 13:26:33','2025-10-02 13:26:33',1,'ACTIVE',NULL,'symmetric',NULL,'aes',256,NULL,'2cb47684d0b34c729e9611e7b3943bed','58cfb09b-3612-42e5-88e1-c3fd0680c883'),('c869a339-7d8b-47df-83d3-eb6943847d77','2025-10-02 13:02:35','2025-10-02 13:03:31','2025-10-02 13:03:31',1,'ACTIVE',NULL,'symmetric',NULL,'aes',256,NULL,'cb1643b3981d49ceaebfabe1577596fd','f314cd59-9471-4241-8934-17105b8c50e4');
/*!40000 ALTER TABLE `secrets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_keys`
--

DROP TABLE IF EXISTS `transport_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transport_keys` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `transport_key` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_keys`
--

LOCK TABLES `transport_keys` WRITE;
/*!40000 ALTER TABLE `transport_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `cinder`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `cinder` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `cinder`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('daa98075b90d');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment_specs`
--

DROP TABLE IF EXISTS `attachment_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_attachment_specs_attachment_id` (`attachment_id`),
  CONSTRAINT `attachment_specs_ibfk_1` FOREIGN KEY (`attachment_id`) REFERENCES `volume_attachment` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment_specs`
--

LOCK TABLES `attachment_specs` WRITE;
/*!40000 ALTER TABLE `attachment_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_metadata`
--

DROP TABLE IF EXISTS `backup_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_backup_metadata_backup_id` (`backup_id`),
  CONSTRAINT `backup_metadata_ibfk_1` FOREIGN KEY (`backup_id`) REFERENCES `backups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_metadata`
--

LOCK TABLES `backup_metadata` WRITE;
/*!40000 ALTER TABLE `backup_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `container` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fail_reason` varchar(255) DEFAULT NULL,
  `service_metadata` varchar(255) DEFAULT NULL,
  `service` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `object_count` int(11) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `temp_volume_id` varchar(36) DEFAULT NULL,
  `temp_snapshot_id` varchar(36) DEFAULT NULL,
  `num_dependent_backups` int(11) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `data_timestamp` datetime DEFAULT NULL,
  `restore_volume_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
INSERT INTO `backups` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `host`, `availability_zone`, `display_name`, `display_description`, `container`, `status`, `fail_reason`, `service_metadata`, `service`, `size`, `object_count`, `parent_id`, `temp_volume_id`, `temp_snapshot_id`, `num_dependent_backups`, `snapshot_id`, `data_timestamp`, `restore_volume_id`, `encryption_key_id`) VALUES ('2025-10-02 13:13:58','2025-10-02 13:15:04','2025-10-02 13:15:06',1,'8b50465d-c0cc-42cb-9644-ae2739806f2b','d8e6ba23-d512-444c-9b18-1432ad9db22b','216ca241b0c548969467dd331a0d31ef','f75652686f7d404a965745c02c9bb8e0','cinder-backup-0',NULL,'tempest-TestVolumeBackupRestore-backup-2004705173',NULL,'backups','deleted',NULL,'{\"base\": \"volume-d8e6ba23-d512-444c-9b18-1432ad9db22b.backup.8b50465d-c0cc-42cb-9644-ae2739806f2b\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:13:58','322bbc88-53a2-4cfe-95f7-44d52cc69f65',NULL);
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cgsnapshots`
--

DROP TABLE IF EXISTS `cgsnapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cgsnapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `consistencygroup_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_cgsnapshots_consistencygroup_id` (`consistencygroup_id`),
  CONSTRAINT `cgsnapshots_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cgsnapshots`
--

LOCK TABLES `cgsnapshots` WRITE;
/*!40000 ALTER TABLE `cgsnapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `cgsnapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clusters`
--

DROP TABLE IF EXISTS `clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clusters` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`binary`,`race_preventer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clusters`
--

LOCK TABLES `clusters` WRITE;
/*!40000 ALTER TABLE `clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consistencygroups`
--

DROP TABLE IF EXISTS `consistencygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consistencygroups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `volume_type_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `source_cgid` varchar(36) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consistencygroups`
--

LOCK TABLES `consistencygroups` WRITE;
/*!40000 ALTER TABLE `consistencygroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `consistencygroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_volume_types`
--

DROP TABLE IF EXISTS `default_volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `default_volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  KEY `ix_default_volume_types_volume_type_id` (`volume_type_id`),
  CONSTRAINT `default_volume_types_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_volume_types`
--

LOCK TABLES `default_volume_types` WRITE;
/*!40000 ALTER TABLE `default_volume_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver_initiator_data`
--

DROP TABLE IF EXISTS `driver_initiator_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `driver_initiator_data` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `initiator` (`initiator`,`namespace`,`key`),
  KEY `ix_driver_initiator_data_initiator` (`initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver_initiator_data`
--

LOCK TABLES `driver_initiator_data` WRITE;
/*!40000 ALTER TABLE `driver_initiator_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `driver_initiator_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encryption`
--

DROP TABLE IF EXISTS `encryption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encryption` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `cipher` varchar(255) DEFAULT NULL,
  `control_location` varchar(255) NOT NULL,
  `key_size` int(11) DEFAULT NULL,
  `provider` varchar(255) NOT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `encryption_id` varchar(36) NOT NULL,
  PRIMARY KEY (`encryption_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encryption`
--

LOCK TABLES `encryption` WRITE;
/*!40000 ALTER TABLE `encryption` DISABLE KEYS */;
INSERT INTO `encryption` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `cipher`, `control_location`, `key_size`, `provider`, `volume_type_id`, `encryption_id`) VALUES ('2025-10-02 13:26:05',NULL,'2025-10-02 13:26:38',1,'aes-xts-plain64','front-end',256,'luks','f6d2aaa1-dac0-429f-8dde-c2998faa98bb','af6f9432-9385-499d-ba86-2a1b29964092'),('2025-10-02 13:02:33',NULL,'2025-10-02 13:03:35',1,'aes-xts-plain64','front-end',256,'luks','497d6bcf-12c9-4156-a02e-bb36fbdb2b78','f2e74006-e1b0-4ec2-9b34-068317caa1c3');
/*!40000 ALTER TABLE `encryption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_snapshots`
--

DROP TABLE IF EXISTS `group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_snapshots_group_id` (`group_id`),
  KEY `group_snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `group_snapshots_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_snapshots`
--

LOCK TABLES `group_snapshots` WRITE;
/*!40000 ALTER TABLE `group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_projects`
--

DROP TABLE IF EXISTS `group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_type_id` (`group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `group_type_projects_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_projects`
--

LOCK TABLES `group_type_projects` WRITE;
/*!40000 ALTER TABLE `group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_specs`
--

DROP TABLE IF EXISTS `group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_type_specs_group_type_id` (`group_type_id`),
  CONSTRAINT `group_type_specs_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_specs`
--

LOCK TABLES `group_type_specs` WRITE;
/*!40000 ALTER TABLE `group_type_specs` DISABLE KEYS */;
INSERT INTO `group_type_specs` (`id`, `key`, `value`, `group_type_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'consistent_group_snapshot_enabled','<is> True','41a218e8-3dfd-48c7-961c-d3c7c6d3b632','2025-10-02 11:29:59','2025-10-02 11:29:59',NULL,0);
/*!40000 ALTER TABLE `group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_types`
--

DROP TABLE IF EXISTS `group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_types` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_types`
--

LOCK TABLES `group_types` WRITE;
/*!40000 ALTER TABLE `group_types` DISABLE KEYS */;
INSERT INTO `group_types` (`id`, `name`, `description`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `is_public`) VALUES ('41a218e8-3dfd-48c7-961c-d3c7c6d3b632','default_cgsnapshot_type','Default group type for migrating cgsnapshot','2025-10-02 11:29:59','2025-10-02 11:29:59',NULL,0,1);
/*!40000 ALTER TABLE `group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_volume_type_mapping`
--

DROP TABLE IF EXISTS `group_volume_type_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_volume_type_mapping` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_volume_type_mapping_group_id` (`group_id`),
  KEY `ix_group_volume_type_mapping_volume_type_id` (`volume_type_id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_volume_type_mapping`
--

LOCK TABLES `group_volume_type_mapping` WRITE;
/*!40000 ALTER TABLE `group_volume_type_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_volume_type_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `groups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `source_group_id` varchar(36) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groups_deleted_project_id_idx` (`deleted`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_volume_cache_entries`
--

DROP TABLE IF EXISTS `image_volume_cache_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_volume_cache_entries` (
  `image_updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `image_id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `size` int(11) NOT NULL,
  `last_used` datetime NOT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_volume_cache_entries_host` (`host`),
  KEY `ix_image_volume_cache_entries_image_id` (`image_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_volume_cache_entries`
--

LOCK TABLES `image_volume_cache_entries` WRITE;
/*!40000 ALTER TABLE `image_volume_cache_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_volume_cache_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(36) DEFAULT NULL,
  `resource_uuid` varchar(255) DEFAULT NULL,
  `event_id` varchar(255) NOT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `action_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_messages_expires_at` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quality_of_service_specs`
--

DROP TABLE IF EXISTS `quality_of_service_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quality_of_service_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `specs_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quality_of_service_specs_specs_id` (`specs_id`),
  CONSTRAINT `quality_of_service_specs_ibfk_1` FOREIGN KEY (`specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quality_of_service_specs`
--

LOCK TABLES `quality_of_service_specs` WRITE;
/*!40000 ALTER TABLE `quality_of_service_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `quality_of_service_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
INSERT INTO `quota_classes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `class_name`, `resource`, `hard_limit`) VALUES ('2025-10-02 11:29:52',NULL,NULL,0,1,'default','volumes',10),('2025-10-02 11:29:52',NULL,NULL,0,2,'default','snapshots',10),('2025-10-02 11:29:52',NULL,NULL,0,3,'default','gigabytes',1000),('2025-10-02 11:29:52',NULL,NULL,0,4,'default','consistencygroups',10),('2025-10-02 11:29:52',NULL,NULL,0,5,'default','per_volume_gigabytes',-1),('2025-10-02 11:29:52',NULL,NULL,0,6,'default','groups',10);
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(300) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `race_preventer` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`,`race_preventer`),
  KEY `quota_usage_project_resource_idx` (`project_id`,`resource`),
  KEY `ix_quota_usages_project_id` (`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=147 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
INSERT INTO `quota_usages` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `project_id`, `resource`, `in_use`, `reserved`, `until_refresh`, `race_preventer`) VALUES ('2025-10-02 12:10:15','2025-10-02 12:11:19',NULL,0,1,'a5b7ebf61d0a43d39a837b14d0530c61','volumes',0,0,NULL,1),('2025-10-02 12:10:15','2025-10-02 12:11:19',NULL,0,2,'a5b7ebf61d0a43d39a837b14d0530c61','gigabytes',0,0,NULL,1),('2025-10-02 12:10:15','2025-10-02 12:11:19',NULL,0,3,'a5b7ebf61d0a43d39a837b14d0530c61','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:10:15','2025-10-02 12:11:19',NULL,0,4,'a5b7ebf61d0a43d39a837b14d0530c61','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:13:54','2025-10-02 12:15:30',NULL,0,5,'4db2957ac1b546178a9f2c0f24807e5b','volumes',0,0,NULL,1),('2025-10-02 12:13:54','2025-10-02 12:15:30',NULL,0,6,'4db2957ac1b546178a9f2c0f24807e5b','gigabytes',0,0,NULL,1),('2025-10-02 12:13:54','2025-10-02 12:15:30',NULL,0,7,'4db2957ac1b546178a9f2c0f24807e5b','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:13:54','2025-10-02 12:15:30',NULL,0,8,'4db2957ac1b546178a9f2c0f24807e5b','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:17:00','2025-10-02 12:18:10',NULL,0,9,'7f6188e258a04ea1a49e6b415bce3fc9','volumes',0,0,NULL,1),('2025-10-02 12:17:00','2025-10-02 12:18:10',NULL,0,10,'7f6188e258a04ea1a49e6b415bce3fc9','gigabytes',0,0,NULL,1),('2025-10-02 12:17:00','2025-10-02 12:18:10',NULL,0,11,'7f6188e258a04ea1a49e6b415bce3fc9','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:17:00','2025-10-02 12:18:10',NULL,0,12,'7f6188e258a04ea1a49e6b415bce3fc9','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:17:54','2025-10-02 12:18:32',NULL,0,13,'96eda2c1552247d8b6632dd9e7d1f6df','volumes',0,0,NULL,1),('2025-10-02 12:17:54','2025-10-02 12:18:32',NULL,0,14,'96eda2c1552247d8b6632dd9e7d1f6df','gigabytes',0,0,NULL,1),('2025-10-02 12:17:54','2025-10-02 12:18:32',NULL,0,15,'96eda2c1552247d8b6632dd9e7d1f6df','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:17:54','2025-10-02 12:18:32',NULL,0,16,'96eda2c1552247d8b6632dd9e7d1f6df','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:20:54','2025-10-02 12:24:07',NULL,0,17,'dcab4f3b7c604f47befdd0a52db26eea','volumes',0,0,NULL,1),('2025-10-02 12:20:54','2025-10-02 12:24:07',NULL,0,18,'dcab4f3b7c604f47befdd0a52db26eea','gigabytes',0,0,NULL,1),('2025-10-02 12:20:54','2025-10-02 12:24:07',NULL,0,19,'dcab4f3b7c604f47befdd0a52db26eea','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:20:54','2025-10-02 12:24:07',NULL,0,20,'dcab4f3b7c604f47befdd0a52db26eea','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:23:29','2025-10-02 12:26:10',NULL,0,21,'12dfeaa31a6e4a2481a5332ce3094262','volumes',0,0,NULL,1),('2025-10-02 12:23:29','2025-10-02 12:26:10',NULL,0,22,'12dfeaa31a6e4a2481a5332ce3094262','gigabytes',0,0,NULL,1),('2025-10-02 12:23:29','2025-10-02 12:26:10',NULL,0,23,'12dfeaa31a6e4a2481a5332ce3094262','volumes_multiattach',0,0,NULL,1),('2025-10-02 12:23:29','2025-10-02 12:26:10',NULL,0,24,'12dfeaa31a6e4a2481a5332ce3094262','gigabytes_multiattach',0,0,NULL,1),('2025-10-02 12:24:27','2025-10-02 12:24:58',NULL,0,25,'4a6d727642dc44b3997a0b35c67e6ab1','volumes',0,0,NULL,1),('2025-10-02 12:24:27','2025-10-02 12:24:58',NULL,0,26,'4a6d727642dc44b3997a0b35c67e6ab1','gigabytes',0,0,NULL,1),('2025-10-02 12:24:27','2025-10-02 12:24:58',NULL,0,27,'4a6d727642dc44b3997a0b35c67e6ab1','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:24:27','2025-10-02 12:24:58',NULL,0,28,'4a6d727642dc44b3997a0b35c67e6ab1','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:24:54','2025-10-02 12:28:23',NULL,0,29,'6d96bae071ef4595bd93c956dd20796c','volumes',0,0,NULL,1),('2025-10-02 12:24:54','2025-10-02 12:28:23',NULL,0,30,'6d96bae071ef4595bd93c956dd20796c','gigabytes',0,0,NULL,1),('2025-10-02 12:24:54','2025-10-02 12:28:23',NULL,0,31,'6d96bae071ef4595bd93c956dd20796c','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:24:54','2025-10-02 12:28:23',NULL,0,32,'6d96bae071ef4595bd93c956dd20796c','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:32:22','2025-10-02 12:34:00',NULL,0,33,'7846694bb70143aa984e235126fbe15c','volumes',0,0,NULL,1),('2025-10-02 12:32:22','2025-10-02 12:34:00',NULL,0,34,'7846694bb70143aa984e235126fbe15c','gigabytes',0,0,NULL,1),('2025-10-02 12:32:22','2025-10-02 12:34:00',NULL,0,35,'7846694bb70143aa984e235126fbe15c','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:32:22','2025-10-02 12:34:00',NULL,0,36,'7846694bb70143aa984e235126fbe15c','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:34:53','2025-10-02 12:35:55',NULL,0,37,'5c7832aaed82459e908e73712013728c','volumes',0,0,NULL,1),('2025-10-02 12:34:53','2025-10-02 12:35:55',NULL,0,38,'5c7832aaed82459e908e73712013728c','gigabytes',0,0,NULL,1),('2025-10-02 12:34:53','2025-10-02 12:35:55',NULL,0,39,'5c7832aaed82459e908e73712013728c','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:34:53','2025-10-02 12:35:55',NULL,0,40,'5c7832aaed82459e908e73712013728c','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:39:56','2025-10-02 12:42:34',NULL,0,41,'a79bb765ab1e4aa18672c9641b6187b9','volumes',0,0,NULL,1),('2025-10-02 12:39:56','2025-10-02 12:42:34',NULL,0,42,'a79bb765ab1e4aa18672c9641b6187b9','gigabytes',0,0,NULL,1),('2025-10-02 12:39:56','2025-10-02 12:42:34',NULL,0,43,'a79bb765ab1e4aa18672c9641b6187b9','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:39:56','2025-10-02 12:42:34',NULL,0,44,'a79bb765ab1e4aa18672c9641b6187b9','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:41:16','2025-10-02 12:45:17',NULL,0,45,'88141e38aa2347299e7ab249431ef68c','volumes',0,0,NULL,1),('2025-10-02 12:41:16','2025-10-02 12:45:17',NULL,0,46,'88141e38aa2347299e7ab249431ef68c','gigabytes',0,0,NULL,1),('2025-10-02 12:41:16','2025-10-02 12:45:17',NULL,0,47,'88141e38aa2347299e7ab249431ef68c','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:41:16','2025-10-02 12:45:17',NULL,0,48,'88141e38aa2347299e7ab249431ef68c','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:42:32','2025-10-02 12:45:55',NULL,0,49,'f7e2edef094b4ba5a56a5ec5ffce911e','volumes',0,0,NULL,1),('2025-10-02 12:42:32','2025-10-02 12:45:55',NULL,0,50,'f7e2edef094b4ba5a56a5ec5ffce911e','gigabytes',0,0,NULL,1),('2025-10-02 12:42:32','2025-10-02 12:45:55',NULL,0,51,'f7e2edef094b4ba5a56a5ec5ffce911e','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:42:32','2025-10-02 12:45:55',NULL,0,52,'f7e2edef094b4ba5a56a5ec5ffce911e','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:42:48','2025-10-02 12:48:03',NULL,0,53,'58b2fa4ee0cd4b97be1b303c203be14f','volumes',0,0,NULL,1),('2025-10-02 12:42:48','2025-10-02 12:48:03',NULL,0,54,'58b2fa4ee0cd4b97be1b303c203be14f','gigabytes',0,0,NULL,1),('2025-10-02 12:42:48','2025-10-02 12:48:03',NULL,0,55,'58b2fa4ee0cd4b97be1b303c203be14f','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:42:48','2025-10-02 12:48:03',NULL,0,56,'58b2fa4ee0cd4b97be1b303c203be14f','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:44:42','2025-10-02 12:46:49',NULL,0,57,'c87621e5c0ba4f13abfff528143c1c00','volumes',0,0,NULL,1),('2025-10-02 12:44:42','2025-10-02 12:46:49',NULL,0,58,'c87621e5c0ba4f13abfff528143c1c00','gigabytes',0,0,NULL,1),('2025-10-02 12:44:42','2025-10-02 12:46:49',NULL,0,59,'c87621e5c0ba4f13abfff528143c1c00','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:44:42','2025-10-02 12:46:49',NULL,0,60,'c87621e5c0ba4f13abfff528143c1c00','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:46:07','2025-10-02 12:46:17',NULL,0,61,'9a677c6c10fd4da0af5ed44e13f0b6ff','volumes',0,0,NULL,1),('2025-10-02 12:46:07','2025-10-02 12:46:17',NULL,0,62,'9a677c6c10fd4da0af5ed44e13f0b6ff','gigabytes',0,0,NULL,1),('2025-10-02 12:46:07','2025-10-02 12:46:17',NULL,0,63,'9a677c6c10fd4da0af5ed44e13f0b6ff','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:46:07','2025-10-02 12:46:17',NULL,0,64,'9a677c6c10fd4da0af5ed44e13f0b6ff','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:47:05','2025-10-02 12:51:18',NULL,0,65,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes',0,0,NULL,1),('2025-10-02 12:47:05','2025-10-02 12:51:18',NULL,0,66,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes',0,0,NULL,1),('2025-10-02 12:47:05','2025-10-02 12:50:24',NULL,0,67,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1845639578-27731657',0,0,NULL,1),('2025-10-02 12:47:05','2025-10-02 12:50:24',NULL,0,68,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1845639578-27731657',0,0,NULL,1),('2025-10-02 12:47:05','2025-10-02 12:50:31',NULL,0,69,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-458173846-524194211',0,0,NULL,1),('2025-10-02 12:47:05','2025-10-02 12:50:31',NULL,0,70,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-458173846-524194211',0,0,NULL,1),('2025-10-02 12:47:10','2025-10-02 12:51:18',NULL,0,71,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-963401591-1280362666',0,0,NULL,1),('2025-10-02 12:47:10','2025-10-02 12:51:18',NULL,0,72,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-963401591-1280362666',0,0,NULL,1),('2025-10-02 12:49:37','2025-10-02 12:49:42',NULL,0,73,'a5f0c507e8754b67a03586ed76d09b47','volumes',0,0,NULL,1),('2025-10-02 12:49:37','2025-10-02 12:49:42',NULL,0,74,'a5f0c507e8754b67a03586ed76d09b47','gigabytes',0,0,NULL,1),('2025-10-02 12:49:37','2025-10-02 12:49:42',NULL,0,75,'a5f0c507e8754b67a03586ed76d09b47','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:49:37','2025-10-02 12:49:42',NULL,0,76,'a5f0c507e8754b67a03586ed76d09b47','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:49:39','2025-10-02 12:53:54',NULL,0,77,'dbd0afdfb05849f9abfe4cd4454f6a13','volumes',0,0,NULL,1),('2025-10-02 12:49:39','2025-10-02 12:53:54',NULL,0,78,'dbd0afdfb05849f9abfe4cd4454f6a13','gigabytes',0,0,NULL,1),('2025-10-02 12:49:39','2025-10-02 12:53:54',NULL,0,79,'dbd0afdfb05849f9abfe4cd4454f6a13','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:49:39','2025-10-02 12:53:54',NULL,0,80,'dbd0afdfb05849f9abfe4cd4454f6a13','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:49:42','2025-10-02 12:52:10',NULL,0,81,'1308a7eb298f49baaeaf3dc3a6acf592','volumes',0,0,NULL,1),('2025-10-02 12:49:42','2025-10-02 12:52:10',NULL,0,82,'1308a7eb298f49baaeaf3dc3a6acf592','gigabytes',0,0,NULL,1),('2025-10-02 12:49:42','2025-10-02 12:52:10',NULL,0,83,'1308a7eb298f49baaeaf3dc3a6acf592','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:49:42','2025-10-02 12:52:10',NULL,0,84,'1308a7eb298f49baaeaf3dc3a6acf592','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:54:03','2025-10-02 12:56:33',NULL,0,85,'cb2da64acac041cb8d38c3b43fe4dbe9','volumes',2,0,NULL,1),('2025-10-02 12:54:03','2025-10-02 12:56:33',NULL,0,86,'cb2da64acac041cb8d38c3b43fe4dbe9','gigabytes',2,0,NULL,1),('2025-10-02 12:54:03','2025-10-02 12:56:33',NULL,0,87,'cb2da64acac041cb8d38c3b43fe4dbe9','volumes___DEFAULT__',2,0,NULL,1),('2025-10-02 12:54:03','2025-10-02 12:56:33',NULL,0,88,'cb2da64acac041cb8d38c3b43fe4dbe9','gigabytes___DEFAULT__',2,0,NULL,1),('2025-10-02 12:59:08','2025-10-02 13:01:55',NULL,0,89,'0b15f29eb32d4c5cba98baa238cc12e1','volumes',0,0,NULL,1),('2025-10-02 12:59:08','2025-10-02 13:01:55',NULL,0,90,'0b15f29eb32d4c5cba98baa238cc12e1','gigabytes',0,0,NULL,1),('2025-10-02 12:59:08','2025-10-02 13:01:55',NULL,0,91,'0b15f29eb32d4c5cba98baa238cc12e1','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:59:08','2025-10-02 13:01:55',NULL,0,92,'0b15f29eb32d4c5cba98baa238cc12e1','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 13:02:35','2025-10-02 13:03:33',NULL,0,93,'6e8f1f6ceb7b40ee9fa002d881b59a44','volumes',0,0,NULL,1),('2025-10-02 13:02:35','2025-10-02 13:03:33',NULL,0,94,'6e8f1f6ceb7b40ee9fa002d881b59a44','gigabytes',0,0,NULL,1),('2025-10-02 13:02:35','2025-10-02 13:03:33',NULL,0,95,'6e8f1f6ceb7b40ee9fa002d881b59a44','volumes_tempest-scenario-type-luks-1564408968',0,0,NULL,1),('2025-10-02 13:02:35','2025-10-02 13:03:33',NULL,0,96,'6e8f1f6ceb7b40ee9fa002d881b59a44','gigabytes_tempest-scenario-type-luks-1564408968',0,0,NULL,1),('2025-10-02 13:04:26','2025-10-02 13:07:10',NULL,0,97,'52dd3c4419794d0fbecd536c5088c60f','volumes',0,0,NULL,1),('2025-10-02 13:04:26','2025-10-02 13:07:10',NULL,0,98,'52dd3c4419794d0fbecd536c5088c60f','gigabytes',0,0,NULL,1),('2025-10-02 13:04:26','2025-10-02 13:07:10',NULL,0,99,'52dd3c4419794d0fbecd536c5088c60f','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 13:04:26','2025-10-02 13:07:10',NULL,0,100,'52dd3c4419794d0fbecd536c5088c60f','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 13:07:56','2025-10-02 13:13:31',NULL,0,101,'9f85b8f387b146d29eabe946c4fbdee8','volumes',0,0,NULL,1),('2025-10-02 13:07:56','2025-10-02 13:13:31',NULL,0,102,'9f85b8f387b146d29eabe946c4fbdee8','gigabytes',0,0,NULL,1),('2025-10-02 13:07:56','2025-10-02 13:13:31',NULL,0,103,'9f85b8f387b146d29eabe946c4fbdee8','volumes_multiattach',0,0,NULL,1),('2025-10-02 13:07:56','2025-10-02 13:13:31',NULL,0,104,'9f85b8f387b146d29eabe946c4fbdee8','gigabytes_multiattach',0,0,NULL,1),('2025-10-02 13:09:42','2025-10-02 13:11:32',NULL,0,105,'954946ff6b204fba90f767ec67210620','volumes',0,0,NULL,1),('2025-10-02 13:09:42','2025-10-02 13:11:32',NULL,0,106,'954946ff6b204fba90f767ec67210620','gigabytes',0,0,NULL,1),('2025-10-02 13:09:42','2025-10-02 13:11:32',NULL,0,107,'954946ff6b204fba90f767ec67210620','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 13:09:42','2025-10-02 13:11:32',NULL,0,108,'954946ff6b204fba90f767ec67210620','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 13:12:11','2025-10-02 13:12:22',NULL,0,109,'9f85b8f387b146d29eabe946c4fbdee8','snapshots',0,0,NULL,1),('2025-10-02 13:12:11','2025-10-02 13:12:22',NULL,0,110,'9f85b8f387b146d29eabe946c4fbdee8','snapshots_multiattach',0,0,NULL,1),('2025-10-02 13:12:28','2025-10-02 13:15:11',NULL,0,111,'cbaefa5c700c4ed495a5244732eed7e3','volumes',0,0,NULL,1),('2025-10-02 13:12:28','2025-10-02 13:15:11',NULL,0,112,'cbaefa5c700c4ed495a5244732eed7e3','gigabytes',0,0,NULL,1),('2025-10-02 13:12:28','2025-10-02 13:15:11',NULL,0,113,'cbaefa5c700c4ed495a5244732eed7e3','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 13:12:28','2025-10-02 13:15:11',NULL,0,114,'cbaefa5c700c4ed495a5244732eed7e3','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 13:13:33','2025-10-02 13:14:59',NULL,0,115,'cbaefa5c700c4ed495a5244732eed7e3','snapshots',0,0,NULL,1),('2025-10-02 13:13:33','2025-10-02 13:14:59',NULL,0,116,'cbaefa5c700c4ed495a5244732eed7e3','snapshots___DEFAULT__',0,0,NULL,1),('2025-10-02 13:13:48','2025-10-02 13:15:06',NULL,0,117,'f75652686f7d404a965745c02c9bb8e0','volumes',0,0,NULL,1),('2025-10-02 13:13:48','2025-10-02 13:15:06',NULL,0,118,'f75652686f7d404a965745c02c9bb8e0','gigabytes',0,0,NULL,1),('2025-10-02 13:13:48','2025-10-02 13:15:06',NULL,0,119,'f75652686f7d404a965745c02c9bb8e0','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 13:13:48','2025-10-02 13:15:06',NULL,0,120,'f75652686f7d404a965745c02c9bb8e0','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 13:13:58','2025-10-02 13:15:06',NULL,0,121,'f75652686f7d404a965745c02c9bb8e0','backups',0,0,NULL,1),('2025-10-02 13:13:58','2025-10-02 13:15:06',NULL,0,122,'f75652686f7d404a965745c02c9bb8e0','backup_gigabytes',0,0,NULL,1),('2025-10-02 13:14:37','2025-10-02 13:17:21',NULL,0,123,'7f5376733aec4630998da8d11db76561','volumes',0,0,NULL,1),('2025-10-02 13:14:37','2025-10-02 13:17:21',NULL,0,124,'7f5376733aec4630998da8d11db76561','gigabytes',0,0,NULL,1),('2025-10-02 13:14:37','2025-10-02 13:17:21',NULL,0,125,'7f5376733aec4630998da8d11db76561','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 13:14:37','2025-10-02 13:17:21',NULL,0,126,'7f5376733aec4630998da8d11db76561','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 13:17:30','2025-10-02 13:17:36',NULL,0,127,'9d6e19e05bf0433a9d26f845522d79b4','volumes',0,0,NULL,1),('2025-10-02 13:17:30','2025-10-02 13:17:36',NULL,0,128,'9d6e19e05bf0433a9d26f845522d79b4','gigabytes',0,0,NULL,1),('2025-10-02 13:17:30','2025-10-02 13:17:36',NULL,0,129,'9d6e19e05bf0433a9d26f845522d79b4','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 13:17:30','2025-10-02 13:17:36',NULL,0,130,'9d6e19e05bf0433a9d26f845522d79b4','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 13:17:31','2025-10-02 13:17:34',NULL,0,131,'9d6e19e05bf0433a9d26f845522d79b4','snapshots',0,0,NULL,1),('2025-10-02 13:17:31','2025-10-02 13:17:34',NULL,0,132,'9d6e19e05bf0433a9d26f845522d79b4','snapshots___DEFAULT__',0,0,NULL,1),('2025-10-02 13:18:19','2025-10-02 13:21:12',NULL,0,133,'ced4d30c525c44cca617c3b9838d21b7','volumes',0,0,NULL,1),('2025-10-02 13:18:19','2025-10-02 13:21:12',NULL,0,134,'ced4d30c525c44cca617c3b9838d21b7','gigabytes',0,0,NULL,1),('2025-10-02 13:18:19','2025-10-02 13:21:12',NULL,0,135,'ced4d30c525c44cca617c3b9838d21b7','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 13:18:19','2025-10-02 13:21:12',NULL,0,136,'ced4d30c525c44cca617c3b9838d21b7','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 13:18:24','2025-10-02 13:18:43',NULL,0,137,'ced4d30c525c44cca617c3b9838d21b7','snapshots',0,0,NULL,1),('2025-10-02 13:18:24','2025-10-02 13:18:43',NULL,0,138,'ced4d30c525c44cca617c3b9838d21b7','snapshots___DEFAULT__',0,0,NULL,1),('2025-10-02 13:26:06','2025-10-02 13:32:35',NULL,0,139,'18799a1c93354809911705bb424e673f','volumes',0,0,NULL,1),('2025-10-02 13:26:06','2025-10-02 13:32:35',NULL,0,140,'18799a1c93354809911705bb424e673f','gigabytes',0,0,NULL,1),('2025-10-02 13:26:06','2025-10-02 13:26:37',NULL,0,141,'18799a1c93354809911705bb424e673f','volumes_tempest-scenario-type-luks-703155325',0,0,NULL,1),('2025-10-02 13:26:06','2025-10-02 13:26:37',NULL,0,142,'18799a1c93354809911705bb424e673f','gigabytes_tempest-scenario-type-luks-703155325',0,0,NULL,1),('2025-10-02 13:26:39','2025-10-02 13:32:35',NULL,0,143,'18799a1c93354809911705bb424e673f','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 13:26:39','2025-10-02 13:32:35',NULL,0,144,'18799a1c93354809911705bb424e673f','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 13:26:49','2025-10-02 13:32:25',NULL,0,145,'18799a1c93354809911705bb424e673f','snapshots',0,0,NULL,1),('2025-10-02 13:26:49','2025-10-02 13:32:25',NULL,0,146,'18799a1c93354809911705bb424e673f','snapshots___DEFAULT__',0,0,NULL,1);
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `allocated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `allocated_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reservations_deleted_uuid_idx` (`deleted`,`uuid`),
  KEY `ix_reservations_usage_id` (`usage_id`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  KEY `ix_reservations_allocated_id` (`allocated_id`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`),
  CONSTRAINT `reservations_ibfk_2` FOREIGN KEY (`allocated_id`) REFERENCES `quotas` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=605 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
INSERT INTO `reservations` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `uuid`, `usage_id`, `project_id`, `resource`, `delta`, `expire`, `allocated_id`) VALUES ('2025-10-02 12:10:15','2025-10-02 12:10:15','2025-10-02 12:10:15',1,1,'8bb2097f-8bb6-4b82-a291-cee9f3b486be',1,'a5b7ebf61d0a43d39a837b14d0530c61','volumes',1,'2025-10-03 12:10:15',NULL),('2025-10-02 12:10:15','2025-10-02 12:10:15','2025-10-02 12:10:15',1,2,'ed54a2f8-9baf-477d-b400-1d9ee74beabc',2,'a5b7ebf61d0a43d39a837b14d0530c61','gigabytes',1,'2025-10-03 12:10:15',NULL),('2025-10-02 12:10:15','2025-10-02 12:10:15','2025-10-02 12:10:15',1,3,'9f7d8961-c063-4404-921c-fef417a9f9fe',3,'a5b7ebf61d0a43d39a837b14d0530c61','volumes___DEFAULT__',1,'2025-10-03 12:10:15',NULL),('2025-10-02 12:10:15','2025-10-02 12:10:15','2025-10-02 12:10:15',1,4,'016a66da-fc00-4a50-8e69-9fb0dc8df515',4,'a5b7ebf61d0a43d39a837b14d0530c61','gigabytes___DEFAULT__',1,'2025-10-03 12:10:15',NULL),('2025-10-02 12:11:19','2025-10-02 12:11:19','2025-10-02 12:11:19',1,5,'98ef370b-5e18-4791-9ed8-81468b2714ec',1,'a5b7ebf61d0a43d39a837b14d0530c61','volumes',-1,'2025-10-03 12:11:19',NULL),('2025-10-02 12:11:19','2025-10-02 12:11:19','2025-10-02 12:11:19',1,6,'f8398e1e-fd0f-43a2-94dd-49069ba0c6c7',2,'a5b7ebf61d0a43d39a837b14d0530c61','gigabytes',-1,'2025-10-03 12:11:19',NULL),('2025-10-02 12:11:19','2025-10-02 12:11:19','2025-10-02 12:11:19',1,7,'c1770134-f0e2-4b3f-ba2f-584ccbdb60a8',3,'a5b7ebf61d0a43d39a837b14d0530c61','volumes___DEFAULT__',-1,'2025-10-03 12:11:19',NULL),('2025-10-02 12:11:19','2025-10-02 12:11:19','2025-10-02 12:11:19',1,8,'0aa9f1d1-6327-4885-8046-1904d295cb32',4,'a5b7ebf61d0a43d39a837b14d0530c61','gigabytes___DEFAULT__',-1,'2025-10-03 12:11:19',NULL),('2025-10-02 12:13:54','2025-10-02 12:13:54','2025-10-02 12:13:54',1,9,'8b6907eb-6f26-4e62-bc88-4f4e18f64ab6',5,'4db2957ac1b546178a9f2c0f24807e5b','volumes',1,'2025-10-03 12:13:54',NULL),('2025-10-02 12:13:54','2025-10-02 12:13:54','2025-10-02 12:13:54',1,10,'361f471c-7418-47cc-9c3c-0326b6130610',6,'4db2957ac1b546178a9f2c0f24807e5b','gigabytes',1,'2025-10-03 12:13:54',NULL),('2025-10-02 12:13:54','2025-10-02 12:13:54','2025-10-02 12:13:54',1,11,'8299cc3b-ba51-4e96-a232-7fceda6b316f',7,'4db2957ac1b546178a9f2c0f24807e5b','volumes___DEFAULT__',1,'2025-10-03 12:13:54',NULL),('2025-10-02 12:13:54','2025-10-02 12:13:54','2025-10-02 12:13:54',1,12,'aea6b3f0-aaa1-4ec5-a708-74679bc19b1b',8,'4db2957ac1b546178a9f2c0f24807e5b','gigabytes___DEFAULT__',1,'2025-10-03 12:13:54',NULL),('2025-10-02 12:15:30','2025-10-02 12:15:30','2025-10-02 12:15:30',1,13,'1b0d2451-72bc-40ef-a567-90e78982f2b5',5,'4db2957ac1b546178a9f2c0f24807e5b','volumes',-1,'2025-10-03 12:15:30',NULL),('2025-10-02 12:15:30','2025-10-02 12:15:30','2025-10-02 12:15:30',1,14,'2fc15e1f-fc8f-4628-8499-216ecc704e89',6,'4db2957ac1b546178a9f2c0f24807e5b','gigabytes',-1,'2025-10-03 12:15:30',NULL),('2025-10-02 12:15:30','2025-10-02 12:15:30','2025-10-02 12:15:30',1,15,'e2f74aa8-2275-4bca-8c52-c49025d68376',7,'4db2957ac1b546178a9f2c0f24807e5b','volumes___DEFAULT__',-1,'2025-10-03 12:15:30',NULL),('2025-10-02 12:15:30','2025-10-02 12:15:30','2025-10-02 12:15:30',1,16,'ee43df70-ba57-4df3-a7c4-ebc64745539e',8,'4db2957ac1b546178a9f2c0f24807e5b','gigabytes___DEFAULT__',-1,'2025-10-03 12:15:30',NULL),('2025-10-02 12:17:00','2025-10-02 12:17:00','2025-10-02 12:17:00',1,17,'72510660-89ea-4b6a-ae4b-14ba5dc02952',9,'7f6188e258a04ea1a49e6b415bce3fc9','volumes',1,'2025-10-03 12:17:00',NULL),('2025-10-02 12:17:00','2025-10-02 12:17:00','2025-10-02 12:17:00',1,18,'3782a46e-448d-4f15-9808-4fb2ae888534',10,'7f6188e258a04ea1a49e6b415bce3fc9','gigabytes',1,'2025-10-03 12:17:00',NULL),('2025-10-02 12:17:00','2025-10-02 12:17:00','2025-10-02 12:17:00',1,19,'60f7ac85-f098-4b4e-9e5a-3f6174060d5a',11,'7f6188e258a04ea1a49e6b415bce3fc9','volumes___DEFAULT__',1,'2025-10-03 12:17:00',NULL),('2025-10-02 12:17:00','2025-10-02 12:17:00','2025-10-02 12:17:00',1,20,'cd006b15-58f7-4a35-99e0-e08ed36884c0',12,'7f6188e258a04ea1a49e6b415bce3fc9','gigabytes___DEFAULT__',1,'2025-10-03 12:17:00',NULL),('2025-10-02 12:17:54','2025-10-02 12:17:54','2025-10-02 12:17:54',1,21,'f97e9524-0b80-40e1-8383-12eeb9d7d6f2',13,'96eda2c1552247d8b6632dd9e7d1f6df','volumes',1,'2025-10-03 12:17:54',NULL),('2025-10-02 12:17:54','2025-10-02 12:17:54','2025-10-02 12:17:54',1,22,'a2bfacd3-d38a-4131-8e2f-0f59d42e2157',14,'96eda2c1552247d8b6632dd9e7d1f6df','gigabytes',1,'2025-10-03 12:17:54',NULL),('2025-10-02 12:17:54','2025-10-02 12:17:54','2025-10-02 12:17:54',1,23,'980ba6d3-8664-458e-af5a-1f71d8f3032c',15,'96eda2c1552247d8b6632dd9e7d1f6df','volumes___DEFAULT__',1,'2025-10-03 12:17:54',NULL),('2025-10-02 12:17:54','2025-10-02 12:17:54','2025-10-02 12:17:54',1,24,'23521c0e-0bd9-400c-819c-6c38361b992b',16,'96eda2c1552247d8b6632dd9e7d1f6df','gigabytes___DEFAULT__',1,'2025-10-03 12:17:54',NULL),('2025-10-02 12:18:10','2025-10-02 12:18:10','2025-10-02 12:18:10',1,25,'21947568-370d-451c-968a-cd4528999c09',9,'7f6188e258a04ea1a49e6b415bce3fc9','volumes',-1,'2025-10-03 12:18:10',NULL),('2025-10-02 12:18:10','2025-10-02 12:18:10','2025-10-02 12:18:10',1,26,'9497537c-e333-406c-9059-5511e305670c',10,'7f6188e258a04ea1a49e6b415bce3fc9','gigabytes',-1,'2025-10-03 12:18:10',NULL),('2025-10-02 12:18:10','2025-10-02 12:18:10','2025-10-02 12:18:10',1,27,'7c80f24f-3357-4af9-9301-9298356f7fbf',11,'7f6188e258a04ea1a49e6b415bce3fc9','volumes___DEFAULT__',-1,'2025-10-03 12:18:10',NULL),('2025-10-02 12:18:10','2025-10-02 12:18:10','2025-10-02 12:18:10',1,28,'63bf6579-1aeb-44d5-b66f-f510cceefc16',12,'7f6188e258a04ea1a49e6b415bce3fc9','gigabytes___DEFAULT__',-1,'2025-10-03 12:18:10',NULL),('2025-10-02 12:18:20','2025-10-02 12:18:20','2025-10-02 12:18:20',1,29,'2550fe80-d8b7-482a-b27d-4a2d5a353907',13,'96eda2c1552247d8b6632dd9e7d1f6df','volumes',1,'2025-10-03 12:18:20',NULL),('2025-10-02 12:18:20','2025-10-02 12:18:20','2025-10-02 12:18:20',1,30,'91a56f0f-0d25-41d3-ba3f-8d7f89f0bbc7',14,'96eda2c1552247d8b6632dd9e7d1f6df','gigabytes',1,'2025-10-03 12:18:20',NULL),('2025-10-02 12:18:20','2025-10-02 12:18:20','2025-10-02 12:18:20',1,31,'92397c17-afd8-46fc-a546-c6342d585527',15,'96eda2c1552247d8b6632dd9e7d1f6df','volumes___DEFAULT__',1,'2025-10-03 12:18:20',NULL),('2025-10-02 12:18:20','2025-10-02 12:18:20','2025-10-02 12:18:20',1,32,'d7d6d632-0175-4440-ad4f-7b6a3825bb04',16,'96eda2c1552247d8b6632dd9e7d1f6df','gigabytes___DEFAULT__',1,'2025-10-03 12:18:20',NULL),('2025-10-02 12:18:24','2025-10-02 12:18:24','2025-10-02 12:18:24',1,33,'29741218-e4d5-4af5-8042-c716d9b3ca92',13,'96eda2c1552247d8b6632dd9e7d1f6df','volumes',-1,'2025-10-03 12:18:24',NULL),('2025-10-02 12:18:24','2025-10-02 12:18:24','2025-10-02 12:18:24',1,34,'be2e1e54-d068-4b72-a53d-bce5072895c6',14,'96eda2c1552247d8b6632dd9e7d1f6df','gigabytes',-1,'2025-10-03 12:18:24',NULL),('2025-10-02 12:18:24','2025-10-02 12:18:24','2025-10-02 12:18:24',1,35,'6d321d20-5990-43f9-ad8c-9af2825470e4',15,'96eda2c1552247d8b6632dd9e7d1f6df','volumes___DEFAULT__',-1,'2025-10-03 12:18:24',NULL),('2025-10-02 12:18:24','2025-10-02 12:18:24','2025-10-02 12:18:24',1,36,'09b83537-1792-46f4-8373-97f701f02d57',16,'96eda2c1552247d8b6632dd9e7d1f6df','gigabytes___DEFAULT__',-1,'2025-10-03 12:18:24',NULL),('2025-10-02 12:18:32','2025-10-02 12:18:32','2025-10-02 12:18:32',1,37,'b11c40cb-0e4b-479e-a62c-11a460dfe57a',13,'96eda2c1552247d8b6632dd9e7d1f6df','volumes',-1,'2025-10-03 12:18:32',NULL),('2025-10-02 12:18:32','2025-10-02 12:18:32','2025-10-02 12:18:32',1,38,'95a84be9-c492-4b98-94ac-0cbb2578d2ad',14,'96eda2c1552247d8b6632dd9e7d1f6df','gigabytes',-1,'2025-10-03 12:18:32',NULL),('2025-10-02 12:18:32','2025-10-02 12:18:32','2025-10-02 12:18:32',1,39,'5861d62e-f00e-44a8-810c-afa422e4a2df',15,'96eda2c1552247d8b6632dd9e7d1f6df','volumes___DEFAULT__',-1,'2025-10-03 12:18:32',NULL),('2025-10-02 12:18:32','2025-10-02 12:18:32','2025-10-02 12:18:32',1,40,'4b4bc059-db81-42ae-8b4e-41125762d6eb',16,'96eda2c1552247d8b6632dd9e7d1f6df','gigabytes___DEFAULT__',-1,'2025-10-03 12:18:32',NULL),('2025-10-02 12:20:54','2025-10-02 12:20:55','2025-10-02 12:20:55',1,41,'10a579f1-053b-4c8c-bab7-699299228fec',17,'dcab4f3b7c604f47befdd0a52db26eea','volumes',1,'2025-10-03 12:20:54',NULL),('2025-10-02 12:20:54','2025-10-02 12:20:55','2025-10-02 12:20:55',1,42,'6610693e-11fd-4498-b986-67c375ffecd1',18,'dcab4f3b7c604f47befdd0a52db26eea','gigabytes',1,'2025-10-03 12:20:54',NULL),('2025-10-02 12:20:54','2025-10-02 12:20:55','2025-10-02 12:20:55',1,43,'319501f4-e811-4b30-9534-8dca161d6502',19,'dcab4f3b7c604f47befdd0a52db26eea','volumes___DEFAULT__',1,'2025-10-03 12:20:54',NULL),('2025-10-02 12:20:54','2025-10-02 12:20:55','2025-10-02 12:20:55',1,44,'3def0b74-15ce-4ff6-a422-cb688e27c731',20,'dcab4f3b7c604f47befdd0a52db26eea','gigabytes___DEFAULT__',1,'2025-10-03 12:20:54',NULL),('2025-10-02 12:21:09','2025-10-02 12:21:09','2025-10-02 12:21:09',1,45,'c8a74968-3f9a-4f9f-b82a-7fa665243a15',17,'dcab4f3b7c604f47befdd0a52db26eea','volumes',1,'2025-10-03 12:21:09',NULL),('2025-10-02 12:21:09','2025-10-02 12:21:09','2025-10-02 12:21:09',1,46,'3274617e-b910-4521-8f57-1ee91e2d86f2',18,'dcab4f3b7c604f47befdd0a52db26eea','gigabytes',1,'2025-10-03 12:21:09',NULL),('2025-10-02 12:21:09','2025-10-02 12:21:09','2025-10-02 12:21:09',1,47,'8c4b4716-da2e-4eae-882d-cb16eabc8609',19,'dcab4f3b7c604f47befdd0a52db26eea','volumes___DEFAULT__',1,'2025-10-03 12:21:09',NULL),('2025-10-02 12:21:09','2025-10-02 12:21:09','2025-10-02 12:21:09',1,48,'59fc2d8a-a4bd-4ba9-a3ad-8a4bae261d0b',20,'dcab4f3b7c604f47befdd0a52db26eea','gigabytes___DEFAULT__',1,'2025-10-03 12:21:09',NULL),('2025-10-02 12:21:14','2025-10-02 12:21:15','2025-10-02 12:21:15',1,49,'7ef1ffd3-b5ee-4dc0-bbf2-0b3dc37cfd2b',17,'dcab4f3b7c604f47befdd0a52db26eea','volumes',1,'2025-10-03 12:21:14',NULL),('2025-10-02 12:21:14','2025-10-02 12:21:15','2025-10-02 12:21:15',1,50,'88ced6cc-c623-4f6a-b390-2ebb7163871f',18,'dcab4f3b7c604f47befdd0a52db26eea','gigabytes',1,'2025-10-03 12:21:14',NULL),('2025-10-02 12:21:14','2025-10-02 12:21:15','2025-10-02 12:21:15',1,51,'e22d0c86-15a5-4f3c-aa13-be7ec3b9c2b3',19,'dcab4f3b7c604f47befdd0a52db26eea','volumes___DEFAULT__',1,'2025-10-03 12:21:14',NULL),('2025-10-02 12:21:14','2025-10-02 12:21:15','2025-10-02 12:21:15',1,52,'71a13a49-fd59-475f-9b5c-a261efcee24b',20,'dcab4f3b7c604f47befdd0a52db26eea','gigabytes___DEFAULT__',1,'2025-10-03 12:21:14',NULL),('2025-10-02 12:23:29','2025-10-02 12:23:29','2025-10-02 12:23:29',1,53,'d9d8cb38-6cac-46b8-8eca-98a271e00370',21,'12dfeaa31a6e4a2481a5332ce3094262','volumes',1,'2025-10-03 12:23:28',NULL),('2025-10-02 12:23:29','2025-10-02 12:23:29','2025-10-02 12:23:29',1,54,'4864ddb0-7946-4908-accf-0fddda6ed7fb',22,'12dfeaa31a6e4a2481a5332ce3094262','gigabytes',1,'2025-10-03 12:23:28',NULL),('2025-10-02 12:23:29','2025-10-02 12:23:29','2025-10-02 12:23:29',1,55,'bd78172b-0d31-4221-bc87-9184080127bd',23,'12dfeaa31a6e4a2481a5332ce3094262','volumes_multiattach',1,'2025-10-03 12:23:28',NULL),('2025-10-02 12:23:29','2025-10-02 12:23:29','2025-10-02 12:23:29',1,56,'36283712-840d-491c-adb9-fa0a3cf6868b',24,'12dfeaa31a6e4a2481a5332ce3094262','gigabytes_multiattach',1,'2025-10-03 12:23:28',NULL),('2025-10-02 12:23:32','2025-10-02 12:23:32','2025-10-02 12:23:32',1,57,'d11657ea-2165-4e67-b436-ab668f688b50',21,'12dfeaa31a6e4a2481a5332ce3094262','volumes',1,'2025-10-03 12:23:32',NULL),('2025-10-02 12:23:32','2025-10-02 12:23:32','2025-10-02 12:23:32',1,58,'a3ee53c5-e133-47e2-80a7-61233f82754a',22,'12dfeaa31a6e4a2481a5332ce3094262','gigabytes',1,'2025-10-03 12:23:32',NULL),('2025-10-02 12:23:32','2025-10-02 12:23:32','2025-10-02 12:23:32',1,59,'3ad712c4-e0e8-4abc-9ea8-b627152269f9',23,'12dfeaa31a6e4a2481a5332ce3094262','volumes_multiattach',1,'2025-10-03 12:23:32',NULL),('2025-10-02 12:23:32','2025-10-02 12:23:32','2025-10-02 12:23:32',1,60,'1d6f8b9f-0428-4f7c-9a27-32f47f24d497',24,'12dfeaa31a6e4a2481a5332ce3094262','gigabytes_multiattach',1,'2025-10-03 12:23:32',NULL),('2025-10-02 12:24:00','2025-10-02 12:24:00','2025-10-02 12:24:00',1,61,'86fc3047-7ccf-4d81-a399-a72778fc466f',17,'dcab4f3b7c604f47befdd0a52db26eea','volumes',-1,'2025-10-03 12:24:00',NULL),('2025-10-02 12:24:00','2025-10-02 12:24:00','2025-10-02 12:24:00',1,62,'218e4333-0a76-4c71-ad1b-e3353a644510',18,'dcab4f3b7c604f47befdd0a52db26eea','gigabytes',-1,'2025-10-03 12:24:00',NULL),('2025-10-02 12:24:00','2025-10-02 12:24:00','2025-10-02 12:24:00',1,63,'7362c55b-7459-499f-9625-e2bf6211e467',19,'dcab4f3b7c604f47befdd0a52db26eea','volumes___DEFAULT__',-1,'2025-10-03 12:24:00',NULL),('2025-10-02 12:24:00','2025-10-02 12:24:00','2025-10-02 12:24:00',1,64,'cdd899ee-4e04-43a8-a262-e143f88702cb',20,'dcab4f3b7c604f47befdd0a52db26eea','gigabytes___DEFAULT__',-1,'2025-10-03 12:24:00',NULL),('2025-10-02 12:24:01','2025-10-02 12:24:01','2025-10-02 12:24:01',1,65,'7fd3d4f8-dd9e-4deb-85eb-de3be49e881a',17,'dcab4f3b7c604f47befdd0a52db26eea','volumes',-1,'2025-10-03 12:24:01',NULL),('2025-10-02 12:24:01','2025-10-02 12:24:01','2025-10-02 12:24:01',1,66,'f269f47b-d79a-4a3a-8066-bc502f3bb494',18,'dcab4f3b7c604f47befdd0a52db26eea','gigabytes',-1,'2025-10-03 12:24:01',NULL),('2025-10-02 12:24:01','2025-10-02 12:24:01','2025-10-02 12:24:01',1,67,'6df38dd9-37c5-4621-9755-409c7d608310',19,'dcab4f3b7c604f47befdd0a52db26eea','volumes___DEFAULT__',-1,'2025-10-03 12:24:01',NULL),('2025-10-02 12:24:01','2025-10-02 12:24:01','2025-10-02 12:24:01',1,68,'63771392-5840-45b5-a115-14d9baddcd80',20,'dcab4f3b7c604f47befdd0a52db26eea','gigabytes___DEFAULT__',-1,'2025-10-03 12:24:01',NULL),('2025-10-02 12:24:07','2025-10-02 12:24:07','2025-10-02 12:24:07',1,69,'93ce5ba5-5a03-4053-aae6-a1894b1e24e2',17,'dcab4f3b7c604f47befdd0a52db26eea','volumes',-1,'2025-10-03 12:24:07',NULL),('2025-10-02 12:24:07','2025-10-02 12:24:07','2025-10-02 12:24:07',1,70,'7231e44c-357b-4b67-a9d8-d30f4a57a327',18,'dcab4f3b7c604f47befdd0a52db26eea','gigabytes',-1,'2025-10-03 12:24:07',NULL),('2025-10-02 12:24:07','2025-10-02 12:24:07','2025-10-02 12:24:07',1,71,'4310b4ca-add2-498f-a9bc-0e3b0e11d1f8',19,'dcab4f3b7c604f47befdd0a52db26eea','volumes___DEFAULT__',-1,'2025-10-03 12:24:07',NULL),('2025-10-02 12:24:07','2025-10-02 12:24:07','2025-10-02 12:24:07',1,72,'34faad31-18f3-4da5-b60e-13d112019964',20,'dcab4f3b7c604f47befdd0a52db26eea','gigabytes___DEFAULT__',-1,'2025-10-03 12:24:07',NULL),('2025-10-02 12:24:27','2025-10-02 12:24:27','2025-10-02 12:24:27',1,73,'63659253-be78-4d92-9901-6af1dcb97173',25,'4a6d727642dc44b3997a0b35c67e6ab1','volumes',1,'2025-10-03 12:24:27',NULL),('2025-10-02 12:24:27','2025-10-02 12:24:27','2025-10-02 12:24:27',1,74,'2a3a2283-d90f-4a6f-91d0-04ab53bf102b',26,'4a6d727642dc44b3997a0b35c67e6ab1','gigabytes',1,'2025-10-03 12:24:27',NULL),('2025-10-02 12:24:27','2025-10-02 12:24:27','2025-10-02 12:24:27',1,75,'95485689-f54f-4a2c-a548-c7b0a541fdf6',27,'4a6d727642dc44b3997a0b35c67e6ab1','volumes___DEFAULT__',1,'2025-10-03 12:24:27',NULL),('2025-10-02 12:24:27','2025-10-02 12:24:27','2025-10-02 12:24:27',1,76,'7ad5cfae-f1db-48d4-86f7-0c2da35f3d92',28,'4a6d727642dc44b3997a0b35c67e6ab1','gigabytes___DEFAULT__',1,'2025-10-03 12:24:27',NULL),('2025-10-02 12:24:54','2025-10-02 12:24:54','2025-10-02 12:24:54',1,77,'f6db2dcd-86ea-4c13-8539-c14500719cd5',29,'6d96bae071ef4595bd93c956dd20796c','volumes',1,'2025-10-03 12:24:54',NULL),('2025-10-02 12:24:54','2025-10-02 12:24:54','2025-10-02 12:24:54',1,78,'24ca0121-5d22-49c9-9a9c-5ebedbbd68ca',30,'6d96bae071ef4595bd93c956dd20796c','gigabytes',1,'2025-10-03 12:24:54',NULL),('2025-10-02 12:24:54','2025-10-02 12:24:54','2025-10-02 12:24:54',1,79,'43fec87d-273d-4aad-b66b-2f64b7eedcb3',31,'6d96bae071ef4595bd93c956dd20796c','volumes___DEFAULT__',1,'2025-10-03 12:24:54',NULL),('2025-10-02 12:24:54','2025-10-02 12:24:54','2025-10-02 12:24:54',1,80,'d1c94dcc-491d-415c-b135-6731854a1d9a',32,'6d96bae071ef4595bd93c956dd20796c','gigabytes___DEFAULT__',1,'2025-10-03 12:24:54',NULL),('2025-10-02 12:24:58','2025-10-02 12:24:58','2025-10-02 12:24:58',1,81,'e815dc23-d8c8-4b13-b34a-23f31bd6af37',25,'4a6d727642dc44b3997a0b35c67e6ab1','volumes',-1,'2025-10-03 12:24:58',NULL),('2025-10-02 12:24:58','2025-10-02 12:24:58','2025-10-02 12:24:58',1,82,'c48581db-d547-41a7-91ab-4f835be0cc9b',26,'4a6d727642dc44b3997a0b35c67e6ab1','gigabytes',-1,'2025-10-03 12:24:58',NULL),('2025-10-02 12:24:58','2025-10-02 12:24:58','2025-10-02 12:24:58',1,83,'c3bcc054-697d-40df-805b-7c5055003c6e',27,'4a6d727642dc44b3997a0b35c67e6ab1','volumes___DEFAULT__',-1,'2025-10-03 12:24:58',NULL),('2025-10-02 12:24:58','2025-10-02 12:24:58','2025-10-02 12:24:58',1,84,'70630a9c-ea5e-4fa6-8fcb-0da3f6b9820e',28,'4a6d727642dc44b3997a0b35c67e6ab1','gigabytes___DEFAULT__',-1,'2025-10-03 12:24:58',NULL),('2025-10-02 12:25:13','2025-10-02 12:25:13','2025-10-02 12:25:13',1,85,'342b3291-2cfa-417d-9a36-5a1eee3b9f33',29,'6d96bae071ef4595bd93c956dd20796c','volumes',1,'2025-10-03 12:25:13',NULL),('2025-10-02 12:25:13','2025-10-02 12:25:13','2025-10-02 12:25:13',1,86,'31b06f72-4987-4ad8-8e5b-31cbfab806f5',30,'6d96bae071ef4595bd93c956dd20796c','gigabytes',1,'2025-10-03 12:25:13',NULL),('2025-10-02 12:25:13','2025-10-02 12:25:13','2025-10-02 12:25:13',1,87,'f387edd6-fdba-410f-bd0e-b966331a5f78',31,'6d96bae071ef4595bd93c956dd20796c','volumes___DEFAULT__',1,'2025-10-03 12:25:13',NULL),('2025-10-02 12:25:13','2025-10-02 12:25:13','2025-10-02 12:25:13',1,88,'ee78600b-8d2e-450c-887e-156b758425ff',32,'6d96bae071ef4595bd93c956dd20796c','gigabytes___DEFAULT__',1,'2025-10-03 12:25:13',NULL),('2025-10-02 12:25:16','2025-10-02 12:25:16','2025-10-02 12:25:16',1,89,'b890a525-ec25-4e37-a04c-a907476ca2ce',29,'6d96bae071ef4595bd93c956dd20796c','volumes',1,'2025-10-03 12:25:16',NULL),('2025-10-02 12:25:16','2025-10-02 12:25:16','2025-10-02 12:25:16',1,90,'d93e9851-cc8e-4e50-a617-8761ae2266b2',30,'6d96bae071ef4595bd93c956dd20796c','gigabytes',1,'2025-10-03 12:25:16',NULL),('2025-10-02 12:25:16','2025-10-02 12:25:16','2025-10-02 12:25:16',1,91,'d6473280-bd50-4fe7-b65a-65a1956f3c02',31,'6d96bae071ef4595bd93c956dd20796c','volumes___DEFAULT__',1,'2025-10-03 12:25:16',NULL),('2025-10-02 12:25:16','2025-10-02 12:25:16','2025-10-02 12:25:16',1,92,'7e84ad42-a2f6-4edf-8ac3-4055ef933cd6',32,'6d96bae071ef4595bd93c956dd20796c','gigabytes___DEFAULT__',1,'2025-10-03 12:25:16',NULL),('2025-10-02 12:26:06','2025-10-02 12:26:06','2025-10-02 12:26:06',1,93,'5dce5f45-4cd4-4e1f-89fe-5ed6761582a3',21,'12dfeaa31a6e4a2481a5332ce3094262','volumes',-1,'2025-10-03 12:26:06',NULL),('2025-10-02 12:26:06','2025-10-02 12:26:06','2025-10-02 12:26:06',1,94,'0e3568d4-0fe1-468b-bb7d-9acd67acc884',22,'12dfeaa31a6e4a2481a5332ce3094262','gigabytes',-1,'2025-10-03 12:26:06',NULL),('2025-10-02 12:26:06','2025-10-02 12:26:06','2025-10-02 12:26:06',1,95,'4e74ed97-f2fc-46e2-90cf-6ef38660b4e4',23,'12dfeaa31a6e4a2481a5332ce3094262','volumes_multiattach',-1,'2025-10-03 12:26:06',NULL),('2025-10-02 12:26:06','2025-10-02 12:26:06','2025-10-02 12:26:06',1,96,'1903cfa9-76c6-42dd-b26e-3163a4e0c0f3',24,'12dfeaa31a6e4a2481a5332ce3094262','gigabytes_multiattach',-1,'2025-10-03 12:26:06',NULL),('2025-10-02 12:26:10','2025-10-02 12:26:10','2025-10-02 12:26:10',1,97,'f2d5b54d-119d-4e14-bb03-fdbf05532a88',21,'12dfeaa31a6e4a2481a5332ce3094262','volumes',-1,'2025-10-03 12:26:09',NULL),('2025-10-02 12:26:10','2025-10-02 12:26:10','2025-10-02 12:26:10',1,98,'2af8a734-a1e8-4975-9dd7-6e8c73a49773',22,'12dfeaa31a6e4a2481a5332ce3094262','gigabytes',-1,'2025-10-03 12:26:09',NULL),('2025-10-02 12:26:10','2025-10-02 12:26:10','2025-10-02 12:26:10',1,99,'f00070b1-1828-4238-905e-4065ba98997a',23,'12dfeaa31a6e4a2481a5332ce3094262','volumes_multiattach',-1,'2025-10-03 12:26:09',NULL),('2025-10-02 12:26:10','2025-10-02 12:26:10','2025-10-02 12:26:10',1,100,'5a7451cc-c395-4146-af09-8860f452055c',24,'12dfeaa31a6e4a2481a5332ce3094262','gigabytes_multiattach',-1,'2025-10-03 12:26:09',NULL),('2025-10-02 12:28:19','2025-10-02 12:28:19','2025-10-02 12:28:19',1,101,'326d0732-72fa-46d2-baea-2f439842f17c',29,'6d96bae071ef4595bd93c956dd20796c','volumes',-1,'2025-10-03 12:28:19',NULL),('2025-10-02 12:28:19','2025-10-02 12:28:19','2025-10-02 12:28:19',1,102,'0751e2a1-7e92-4afe-bab5-0a3355e860f2',30,'6d96bae071ef4595bd93c956dd20796c','gigabytes',-1,'2025-10-03 12:28:19',NULL),('2025-10-02 12:28:19','2025-10-02 12:28:19','2025-10-02 12:28:19',1,103,'7ab5f274-5d65-445a-ade6-9c31e6a2c279',31,'6d96bae071ef4595bd93c956dd20796c','volumes___DEFAULT__',-1,'2025-10-03 12:28:19',NULL),('2025-10-02 12:28:19','2025-10-02 12:28:19','2025-10-02 12:28:19',1,104,'5e878fc0-393d-4fc1-ba1e-4c9663966160',32,'6d96bae071ef4595bd93c956dd20796c','gigabytes___DEFAULT__',-1,'2025-10-03 12:28:19',NULL),('2025-10-02 12:28:21','2025-10-02 12:28:21','2025-10-02 12:28:21',1,105,'2d48ab53-ae2f-44fe-b93d-4bcf3c5a95ee',29,'6d96bae071ef4595bd93c956dd20796c','volumes',-1,'2025-10-03 12:28:21',NULL),('2025-10-02 12:28:21','2025-10-02 12:28:21','2025-10-02 12:28:21',1,106,'d5ba56b6-e897-40a2-b1b6-7c533e6d8c0b',30,'6d96bae071ef4595bd93c956dd20796c','gigabytes',-1,'2025-10-03 12:28:21',NULL),('2025-10-02 12:28:21','2025-10-02 12:28:21','2025-10-02 12:28:21',1,107,'91797b2d-bab8-480f-b7ea-32735270f273',31,'6d96bae071ef4595bd93c956dd20796c','volumes___DEFAULT__',-1,'2025-10-03 12:28:21',NULL),('2025-10-02 12:28:21','2025-10-02 12:28:21','2025-10-02 12:28:21',1,108,'78c5d6e3-e628-4ca6-9538-26b07489eb74',32,'6d96bae071ef4595bd93c956dd20796c','gigabytes___DEFAULT__',-1,'2025-10-03 12:28:21',NULL),('2025-10-02 12:28:23','2025-10-02 12:28:23','2025-10-02 12:28:23',1,109,'fa0db0a0-113d-45c9-bf4c-0aaef5755017',29,'6d96bae071ef4595bd93c956dd20796c','volumes',-1,'2025-10-03 12:28:23',NULL),('2025-10-02 12:28:23','2025-10-02 12:28:23','2025-10-02 12:28:23',1,110,'7f4b4c42-339f-49e3-9dc5-f73111f7f1cc',30,'6d96bae071ef4595bd93c956dd20796c','gigabytes',-1,'2025-10-03 12:28:23',NULL),('2025-10-02 12:28:23','2025-10-02 12:28:23','2025-10-02 12:28:23',1,111,'170eed80-58eb-435a-b6bb-39a162be057a',31,'6d96bae071ef4595bd93c956dd20796c','volumes___DEFAULT__',-1,'2025-10-03 12:28:23',NULL),('2025-10-02 12:28:23','2025-10-02 12:28:23','2025-10-02 12:28:23',1,112,'f7c5f00b-23e4-426b-8e30-97759fab86da',32,'6d96bae071ef4595bd93c956dd20796c','gigabytes___DEFAULT__',-1,'2025-10-03 12:28:23',NULL),('2025-10-02 12:32:22','2025-10-02 12:32:22','2025-10-02 12:32:22',1,113,'3af26ec1-e49b-45de-8a3b-1e8c81e15c21',33,'7846694bb70143aa984e235126fbe15c','volumes',1,'2025-10-03 12:32:22',NULL),('2025-10-02 12:32:22','2025-10-02 12:32:22','2025-10-02 12:32:22',1,114,'d84a8355-63b8-4177-b78f-14933d64188c',34,'7846694bb70143aa984e235126fbe15c','gigabytes',1,'2025-10-03 12:32:22',NULL),('2025-10-02 12:32:22','2025-10-02 12:32:22','2025-10-02 12:32:22',1,115,'0902e425-90a4-4c35-b60f-65f3532cda06',35,'7846694bb70143aa984e235126fbe15c','volumes___DEFAULT__',1,'2025-10-03 12:32:22',NULL),('2025-10-02 12:32:22','2025-10-02 12:32:22','2025-10-02 12:32:22',1,116,'7ada7fdc-2795-4309-8534-48491c0f37f5',36,'7846694bb70143aa984e235126fbe15c','gigabytes___DEFAULT__',1,'2025-10-03 12:32:22',NULL),('2025-10-02 12:34:00','2025-10-02 12:34:00','2025-10-02 12:34:00',1,117,'d09761f1-0a6f-4122-9e64-14ffd267592a',33,'7846694bb70143aa984e235126fbe15c','volumes',-1,'2025-10-03 12:34:00',NULL),('2025-10-02 12:34:00','2025-10-02 12:34:00','2025-10-02 12:34:00',1,118,'cae22038-37d7-4b80-98ab-2bcb78d63852',34,'7846694bb70143aa984e235126fbe15c','gigabytes',-1,'2025-10-03 12:34:00',NULL),('2025-10-02 12:34:00','2025-10-02 12:34:00','2025-10-02 12:34:00',1,119,'673c9868-74ff-4a62-8cf0-9032d77eb120',35,'7846694bb70143aa984e235126fbe15c','volumes___DEFAULT__',-1,'2025-10-03 12:34:00',NULL),('2025-10-02 12:34:00','2025-10-02 12:34:00','2025-10-02 12:34:00',1,120,'ce066d98-45c9-41c1-9ed9-0bde9bdd5bd5',36,'7846694bb70143aa984e235126fbe15c','gigabytes___DEFAULT__',-1,'2025-10-03 12:34:00',NULL),('2025-10-02 12:34:53','2025-10-02 12:34:53','2025-10-02 12:34:53',1,121,'dc920ccb-e381-4e35-a85b-40ac8ef772a0',37,'5c7832aaed82459e908e73712013728c','volumes',1,'2025-10-03 12:34:53',NULL),('2025-10-02 12:34:53','2025-10-02 12:34:53','2025-10-02 12:34:53',1,122,'e6d640fc-2146-4922-9039-c6b1dd9a089a',38,'5c7832aaed82459e908e73712013728c','gigabytes',1,'2025-10-03 12:34:53',NULL),('2025-10-02 12:34:53','2025-10-02 12:34:53','2025-10-02 12:34:53',1,123,'4e9c94ff-ea92-4eba-aa0e-38f152e4e2eb',39,'5c7832aaed82459e908e73712013728c','volumes___DEFAULT__',1,'2025-10-03 12:34:53',NULL),('2025-10-02 12:34:53','2025-10-02 12:34:53','2025-10-02 12:34:53',1,124,'c85dc16c-b91b-47c5-a409-8c66700037a9',40,'5c7832aaed82459e908e73712013728c','gigabytes___DEFAULT__',1,'2025-10-03 12:34:53',NULL),('2025-10-02 12:35:55','2025-10-02 12:35:55','2025-10-02 12:35:55',1,125,'b3f45fa1-1db2-4cc9-82fb-0d9aaf719801',37,'5c7832aaed82459e908e73712013728c','volumes',-1,'2025-10-03 12:35:55',NULL),('2025-10-02 12:35:55','2025-10-02 12:35:55','2025-10-02 12:35:55',1,126,'8073464e-c126-478f-85aa-983693a98aee',38,'5c7832aaed82459e908e73712013728c','gigabytes',-1,'2025-10-03 12:35:55',NULL),('2025-10-02 12:35:55','2025-10-02 12:35:55','2025-10-02 12:35:55',1,127,'4eee1516-f556-40a8-ab98-63ff5a8dba1f',39,'5c7832aaed82459e908e73712013728c','volumes___DEFAULT__',-1,'2025-10-03 12:35:55',NULL),('2025-10-02 12:35:55','2025-10-02 12:35:55','2025-10-02 12:35:55',1,128,'edaf98da-af5c-4cce-b004-56e4e6491bd0',40,'5c7832aaed82459e908e73712013728c','gigabytes___DEFAULT__',-1,'2025-10-03 12:35:55',NULL),('2025-10-02 12:39:56','2025-10-02 12:39:56','2025-10-02 12:39:56',1,129,'fc4ee3b2-e462-45d3-9de1-c061057f9207',41,'a79bb765ab1e4aa18672c9641b6187b9','volumes',1,'2025-10-03 12:39:56',NULL),('2025-10-02 12:39:56','2025-10-02 12:39:56','2025-10-02 12:39:56',1,130,'88f492c6-e291-4f53-b5d3-1b0d5385201b',42,'a79bb765ab1e4aa18672c9641b6187b9','gigabytes',1,'2025-10-03 12:39:56',NULL),('2025-10-02 12:39:56','2025-10-02 12:39:56','2025-10-02 12:39:56',1,131,'c85f0773-7b9d-40b1-84a7-58cde65e79d3',43,'a79bb765ab1e4aa18672c9641b6187b9','volumes___DEFAULT__',1,'2025-10-03 12:39:56',NULL),('2025-10-02 12:39:56','2025-10-02 12:39:56','2025-10-02 12:39:56',1,132,'19ef29d4-9845-4280-93d1-72d6657d00d8',44,'a79bb765ab1e4aa18672c9641b6187b9','gigabytes___DEFAULT__',1,'2025-10-03 12:39:56',NULL),('2025-10-02 12:41:16','2025-10-02 12:41:16','2025-10-02 12:41:16',1,133,'95b7cdde-ec37-4e77-9e46-db7fab4d88d9',45,'88141e38aa2347299e7ab249431ef68c','volumes',1,'2025-10-03 12:41:16',NULL),('2025-10-02 12:41:16','2025-10-02 12:41:16','2025-10-02 12:41:16',1,134,'05626bae-1948-4ada-a1b7-54e5e31d16a2',46,'88141e38aa2347299e7ab249431ef68c','gigabytes',1,'2025-10-03 12:41:16',NULL),('2025-10-02 12:41:16','2025-10-02 12:41:16','2025-10-02 12:41:16',1,135,'d13fd6de-2f10-4a30-a82a-bf50ef067ea0',47,'88141e38aa2347299e7ab249431ef68c','volumes___DEFAULT__',1,'2025-10-03 12:41:16',NULL),('2025-10-02 12:41:16','2025-10-02 12:41:16','2025-10-02 12:41:16',1,136,'d6d5decd-0330-4326-bb42-4e07f2a0ff7f',48,'88141e38aa2347299e7ab249431ef68c','gigabytes___DEFAULT__',1,'2025-10-03 12:41:16',NULL),('2025-10-02 12:42:32','2025-10-02 12:42:32','2025-10-02 12:42:32',1,137,'1a15211a-b83f-4c01-8b8e-3a262131ebaf',49,'f7e2edef094b4ba5a56a5ec5ffce911e','volumes',1,'2025-10-03 12:42:32',NULL),('2025-10-02 12:42:32','2025-10-02 12:42:32','2025-10-02 12:42:32',1,138,'1142f852-0800-4289-bf18-720af68e9cb8',50,'f7e2edef094b4ba5a56a5ec5ffce911e','gigabytes',1,'2025-10-03 12:42:32',NULL),('2025-10-02 12:42:32','2025-10-02 12:42:32','2025-10-02 12:42:32',1,139,'95dae8de-2c20-4526-87de-1fded888b2ec',51,'f7e2edef094b4ba5a56a5ec5ffce911e','volumes___DEFAULT__',1,'2025-10-03 12:42:32',NULL),('2025-10-02 12:42:32','2025-10-02 12:42:32','2025-10-02 12:42:32',1,140,'119533c7-8478-46cc-9694-2b1ed1d503c0',52,'f7e2edef094b4ba5a56a5ec5ffce911e','gigabytes___DEFAULT__',1,'2025-10-03 12:42:32',NULL),('2025-10-02 12:42:34','2025-10-02 12:42:34','2025-10-02 12:42:34',1,141,'8e866e81-de5b-4b6a-92c2-e3b57725819e',41,'a79bb765ab1e4aa18672c9641b6187b9','volumes',-1,'2025-10-03 12:42:34',NULL),('2025-10-02 12:42:34','2025-10-02 12:42:34','2025-10-02 12:42:34',1,142,'308c935c-faa4-4e96-b18f-6eabb01c51d4',42,'a79bb765ab1e4aa18672c9641b6187b9','gigabytes',-1,'2025-10-03 12:42:34',NULL),('2025-10-02 12:42:34','2025-10-02 12:42:34','2025-10-02 12:42:34',1,143,'2200b863-0be4-4090-8983-74bb4e69d7f1',43,'a79bb765ab1e4aa18672c9641b6187b9','volumes___DEFAULT__',-1,'2025-10-03 12:42:34',NULL),('2025-10-02 12:42:34','2025-10-02 12:42:34','2025-10-02 12:42:34',1,144,'10d8ce38-2e00-4612-b7bb-3fa117336ee5',44,'a79bb765ab1e4aa18672c9641b6187b9','gigabytes___DEFAULT__',-1,'2025-10-03 12:42:34',NULL),('2025-10-02 12:42:48','2025-10-02 12:42:48','2025-10-02 12:42:48',1,145,'b8d68b79-2f14-49ed-a9fd-13a0889a53fe',53,'58b2fa4ee0cd4b97be1b303c203be14f','volumes',1,'2025-10-03 12:42:48',NULL),('2025-10-02 12:42:48','2025-10-02 12:42:48','2025-10-02 12:42:48',1,146,'77362824-21b5-4b3a-958a-ecec82623c46',54,'58b2fa4ee0cd4b97be1b303c203be14f','gigabytes',1,'2025-10-03 12:42:48',NULL),('2025-10-02 12:42:48','2025-10-02 12:42:48','2025-10-02 12:42:48',1,147,'8b965433-f9b4-484c-8c83-4fb7da05a909',55,'58b2fa4ee0cd4b97be1b303c203be14f','volumes___DEFAULT__',1,'2025-10-03 12:42:48',NULL),('2025-10-02 12:42:48','2025-10-02 12:42:48','2025-10-02 12:42:48',1,148,'5f6a256b-3d32-4671-ac70-69b9f2c5306f',56,'58b2fa4ee0cd4b97be1b303c203be14f','gigabytes___DEFAULT__',1,'2025-10-03 12:42:48',NULL),('2025-10-02 12:43:16','2025-10-02 12:43:16','2025-10-02 12:43:16',1,149,'f288ca58-98ad-42db-881e-59c49648b386',45,'88141e38aa2347299e7ab249431ef68c','volumes',1,'2025-10-03 12:43:16',NULL),('2025-10-02 12:43:16','2025-10-02 12:43:16','2025-10-02 12:43:16',1,150,'8b86b18f-2d4b-4094-a295-034aa4cbaacf',46,'88141e38aa2347299e7ab249431ef68c','gigabytes',1,'2025-10-03 12:43:16',NULL),('2025-10-02 12:43:16','2025-10-02 12:43:16','2025-10-02 12:43:16',1,151,'5563dfc3-95bd-4c54-8e1c-5d9efbb14f99',47,'88141e38aa2347299e7ab249431ef68c','volumes___DEFAULT__',1,'2025-10-03 12:43:16',NULL),('2025-10-02 12:43:16','2025-10-02 12:43:16','2025-10-02 12:43:16',1,152,'961104f1-ddf6-4626-9303-6d79103f00a4',48,'88141e38aa2347299e7ab249431ef68c','gigabytes___DEFAULT__',1,'2025-10-03 12:43:16',NULL),('2025-10-02 12:44:36','2025-10-02 12:44:38','2025-10-02 12:44:38',1,153,'d36d3951-f259-4744-bba6-48da2a06e00c',49,'f7e2edef094b4ba5a56a5ec5ffce911e','volumes',1,'2025-10-03 12:44:36',NULL),('2025-10-02 12:44:36','2025-10-02 12:44:38','2025-10-02 12:44:38',1,154,'86f61052-6722-4e03-bd27-29acf46e4805',50,'f7e2edef094b4ba5a56a5ec5ffce911e','gigabytes',1,'2025-10-03 12:44:36',NULL),('2025-10-02 12:44:36','2025-10-02 12:44:38','2025-10-02 12:44:38',1,155,'7db86aab-762f-4a78-93ca-12f87ffe1f1a',51,'f7e2edef094b4ba5a56a5ec5ffce911e','volumes___DEFAULT__',1,'2025-10-03 12:44:36',NULL),('2025-10-02 12:44:36','2025-10-02 12:44:38','2025-10-02 12:44:38',1,156,'8d388465-060e-45e2-9264-fd2e0d3f3fa2',52,'f7e2edef094b4ba5a56a5ec5ffce911e','gigabytes___DEFAULT__',1,'2025-10-03 12:44:36',NULL),('2025-10-02 12:44:42','2025-10-02 12:44:43','2025-10-02 12:44:43',1,157,'d0aaedc9-8e4c-422f-8cd5-8246cff5cca5',57,'c87621e5c0ba4f13abfff528143c1c00','volumes',1,'2025-10-03 12:44:42',NULL),('2025-10-02 12:44:42','2025-10-02 12:44:43','2025-10-02 12:44:43',1,158,'fb62ac4c-5ca8-4136-8cfa-fa871df40a36',58,'c87621e5c0ba4f13abfff528143c1c00','gigabytes',1,'2025-10-03 12:44:42',NULL),('2025-10-02 12:44:42','2025-10-02 12:44:43','2025-10-02 12:44:43',1,159,'f7721649-3131-44c5-ba0c-370c136b5f15',59,'c87621e5c0ba4f13abfff528143c1c00','volumes___DEFAULT__',1,'2025-10-03 12:44:42',NULL),('2025-10-02 12:44:42','2025-10-02 12:44:43','2025-10-02 12:44:43',1,160,'dc87c27c-7a72-41ba-8633-63a53d57aa12',60,'c87621e5c0ba4f13abfff528143c1c00','gigabytes___DEFAULT__',1,'2025-10-03 12:44:42',NULL),('2025-10-02 12:45:10','2025-10-02 12:45:10','2025-10-02 12:45:10',1,161,'472f9592-9b3d-4686-a82f-2e0cf1f1de23',45,'88141e38aa2347299e7ab249431ef68c','volumes',-1,'2025-10-03 12:45:10',NULL),('2025-10-02 12:45:10','2025-10-02 12:45:10','2025-10-02 12:45:10',1,162,'8450c6dc-246c-4d3e-bbe1-9f651dbf3cb4',46,'88141e38aa2347299e7ab249431ef68c','gigabytes',-1,'2025-10-03 12:45:10',NULL),('2025-10-02 12:45:10','2025-10-02 12:45:10','2025-10-02 12:45:10',1,163,'1c7da69a-b3a9-4b24-8edd-3d57a9772af3',47,'88141e38aa2347299e7ab249431ef68c','volumes___DEFAULT__',-1,'2025-10-03 12:45:10',NULL),('2025-10-02 12:45:10','2025-10-02 12:45:10','2025-10-02 12:45:10',1,164,'8a285dad-b2b0-4b60-9f74-1a8daa684364',48,'88141e38aa2347299e7ab249431ef68c','gigabytes___DEFAULT__',-1,'2025-10-03 12:45:10',NULL),('2025-10-02 12:45:11','2025-10-02 12:45:11','2025-10-02 12:45:11',1,165,'b7e6ff42-d12b-480a-8ac0-6e75901fee03',57,'c87621e5c0ba4f13abfff528143c1c00','volumes',1,'2025-10-03 12:45:11',NULL),('2025-10-02 12:45:11','2025-10-02 12:45:11','2025-10-02 12:45:11',1,166,'1d692eb0-ca1a-4011-a9e2-ac0521e689ba',58,'c87621e5c0ba4f13abfff528143c1c00','gigabytes',1,'2025-10-03 12:45:11',NULL),('2025-10-02 12:45:11','2025-10-02 12:45:11','2025-10-02 12:45:11',1,167,'77aab2bb-deb7-41b7-9485-501e7046cb98',59,'c87621e5c0ba4f13abfff528143c1c00','volumes___DEFAULT__',1,'2025-10-03 12:45:11',NULL),('2025-10-02 12:45:11','2025-10-02 12:45:11','2025-10-02 12:45:11',1,168,'9e612403-f76b-493b-9bcc-d4ec64b376be',60,'c87621e5c0ba4f13abfff528143c1c00','gigabytes___DEFAULT__',1,'2025-10-03 12:45:11',NULL),('2025-10-02 12:45:17','2025-10-02 12:45:17','2025-10-02 12:45:17',1,169,'76095919-1358-4d12-b537-999177e83f1f',45,'88141e38aa2347299e7ab249431ef68c','volumes',-1,'2025-10-03 12:45:17',NULL),('2025-10-02 12:45:17','2025-10-02 12:45:17','2025-10-02 12:45:17',1,170,'e05b6002-c19a-4ef3-b62d-a7f1239ab970',46,'88141e38aa2347299e7ab249431ef68c','gigabytes',-1,'2025-10-03 12:45:17',NULL),('2025-10-02 12:45:17','2025-10-02 12:45:17','2025-10-02 12:45:17',1,171,'3acd479d-dab4-4bf7-b55a-bad95f91b59c',47,'88141e38aa2347299e7ab249431ef68c','volumes___DEFAULT__',-1,'2025-10-03 12:45:17',NULL),('2025-10-02 12:45:17','2025-10-02 12:45:17','2025-10-02 12:45:17',1,172,'46c71d47-be07-4374-a325-6c1647f22e2d',48,'88141e38aa2347299e7ab249431ef68c','gigabytes___DEFAULT__',-1,'2025-10-03 12:45:17',NULL),('2025-10-02 12:45:52','2025-10-02 12:45:52','2025-10-02 12:45:52',1,173,'073f31f1-0861-41e9-945a-f37166f108c8',49,'f7e2edef094b4ba5a56a5ec5ffce911e','volumes',-1,'2025-10-03 12:45:52',NULL),('2025-10-02 12:45:52','2025-10-02 12:45:52','2025-10-02 12:45:52',1,174,'8965873d-888e-43fc-a8d1-78d91b05111b',50,'f7e2edef094b4ba5a56a5ec5ffce911e','gigabytes',-1,'2025-10-03 12:45:52',NULL),('2025-10-02 12:45:52','2025-10-02 12:45:52','2025-10-02 12:45:52',1,175,'49fa65dc-35da-482b-a91d-e5c00b9acca4',51,'f7e2edef094b4ba5a56a5ec5ffce911e','volumes___DEFAULT__',-1,'2025-10-03 12:45:52',NULL),('2025-10-02 12:45:52','2025-10-02 12:45:52','2025-10-02 12:45:52',1,176,'c8246de1-ef72-4af0-ab96-b8a4aadfede8',52,'f7e2edef094b4ba5a56a5ec5ffce911e','gigabytes___DEFAULT__',-1,'2025-10-03 12:45:52',NULL),('2025-10-02 12:45:55','2025-10-02 12:45:55','2025-10-02 12:45:55',1,177,'b5421dac-98d4-4c86-b60c-e17b7e3801a1',49,'f7e2edef094b4ba5a56a5ec5ffce911e','volumes',-1,'2025-10-03 12:45:55',NULL),('2025-10-02 12:45:55','2025-10-02 12:45:55','2025-10-02 12:45:55',1,178,'2e222736-edf5-4e75-af22-5d66c03598c3',50,'f7e2edef094b4ba5a56a5ec5ffce911e','gigabytes',-1,'2025-10-03 12:45:55',NULL),('2025-10-02 12:45:55','2025-10-02 12:45:55','2025-10-02 12:45:55',1,179,'b815ba1b-27a0-4ff8-98bc-b8bdb8c5e1c7',51,'f7e2edef094b4ba5a56a5ec5ffce911e','volumes___DEFAULT__',-1,'2025-10-03 12:45:55',NULL),('2025-10-02 12:45:55','2025-10-02 12:45:55','2025-10-02 12:45:55',1,180,'05b14a3a-3fc9-413c-9c5b-d53f85c32cbc',52,'f7e2edef094b4ba5a56a5ec5ffce911e','gigabytes___DEFAULT__',-1,'2025-10-03 12:45:55',NULL),('2025-10-02 12:46:07','2025-10-02 12:46:07','2025-10-02 12:46:07',1,181,'a4575902-5ae5-490c-b93c-6777c5128cd8',61,'9a677c6c10fd4da0af5ed44e13f0b6ff','volumes',1,'2025-10-03 12:46:07',NULL),('2025-10-02 12:46:07','2025-10-02 12:46:07','2025-10-02 12:46:07',1,182,'a48fefce-0479-428d-bc4d-68d9f965b733',62,'9a677c6c10fd4da0af5ed44e13f0b6ff','gigabytes',1,'2025-10-03 12:46:07',NULL),('2025-10-02 12:46:07','2025-10-02 12:46:07','2025-10-02 12:46:07',1,183,'9072570c-c121-4b8b-b95f-a0533afcc651',63,'9a677c6c10fd4da0af5ed44e13f0b6ff','volumes___DEFAULT__',1,'2025-10-03 12:46:07',NULL),('2025-10-02 12:46:07','2025-10-02 12:46:07','2025-10-02 12:46:07',1,184,'623d38f7-2d4b-419d-923e-0a403201fa89',64,'9a677c6c10fd4da0af5ed44e13f0b6ff','gigabytes___DEFAULT__',1,'2025-10-03 12:46:07',NULL),('2025-10-02 12:46:08','2025-10-02 12:46:08','2025-10-02 12:46:08',1,185,'fc5faeb5-a16a-403d-af2a-6c2351b9c1ac',61,'9a677c6c10fd4da0af5ed44e13f0b6ff','volumes',1,'2025-10-03 12:46:08',NULL),('2025-10-02 12:46:08','2025-10-02 12:46:08','2025-10-02 12:46:08',1,186,'02da006c-1435-487c-9cb6-924ba7d7c3b7',62,'9a677c6c10fd4da0af5ed44e13f0b6ff','gigabytes',1,'2025-10-03 12:46:08',NULL),('2025-10-02 12:46:08','2025-10-02 12:46:08','2025-10-02 12:46:08',1,187,'37ad47d8-d4ac-4b75-baca-8ee301acc794',63,'9a677c6c10fd4da0af5ed44e13f0b6ff','volumes___DEFAULT__',1,'2025-10-03 12:46:08',NULL),('2025-10-02 12:46:08','2025-10-02 12:46:08','2025-10-02 12:46:08',1,188,'fa0e6b50-369f-48bd-a34c-79db8f2a64fc',64,'9a677c6c10fd4da0af5ed44e13f0b6ff','gigabytes___DEFAULT__',1,'2025-10-03 12:46:08',NULL),('2025-10-02 12:46:10','2025-10-02 12:46:10','2025-10-02 12:46:10',1,189,'42089d71-a4a0-49a2-9642-6c250d213363',61,'9a677c6c10fd4da0af5ed44e13f0b6ff','volumes',1,'2025-10-03 12:46:10',NULL),('2025-10-02 12:46:10','2025-10-02 12:46:10','2025-10-02 12:46:10',1,190,'181e88f0-1c9a-41b1-8ad6-a57fa67600b6',62,'9a677c6c10fd4da0af5ed44e13f0b6ff','gigabytes',1,'2025-10-03 12:46:10',NULL),('2025-10-02 12:46:10','2025-10-02 12:46:10','2025-10-02 12:46:10',1,191,'57ca538e-3b8d-4f02-b9a7-3fed19d1ba79',63,'9a677c6c10fd4da0af5ed44e13f0b6ff','volumes___DEFAULT__',1,'2025-10-03 12:46:10',NULL),('2025-10-02 12:46:10','2025-10-02 12:46:10','2025-10-02 12:46:10',1,192,'0d1b3d05-af24-4694-b8f4-dc897da85d64',64,'9a677c6c10fd4da0af5ed44e13f0b6ff','gigabytes___DEFAULT__',1,'2025-10-03 12:46:10',NULL),('2025-10-02 12:46:14','2025-10-02 12:46:14','2025-10-02 12:46:14',1,193,'7bd73f25-3f0a-4e4c-b376-9752848dff7f',61,'9a677c6c10fd4da0af5ed44e13f0b6ff','volumes',-1,'2025-10-03 12:46:14',NULL),('2025-10-02 12:46:14','2025-10-02 12:46:14','2025-10-02 12:46:14',1,194,'ff771bb4-46c0-44b3-b1af-c32bb205ee1b',62,'9a677c6c10fd4da0af5ed44e13f0b6ff','gigabytes',-1,'2025-10-03 12:46:14',NULL),('2025-10-02 12:46:14','2025-10-02 12:46:14','2025-10-02 12:46:14',1,195,'21f3b101-8a96-4cab-8148-36860ac97d46',63,'9a677c6c10fd4da0af5ed44e13f0b6ff','volumes___DEFAULT__',-1,'2025-10-03 12:46:14',NULL),('2025-10-02 12:46:14','2025-10-02 12:46:14','2025-10-02 12:46:14',1,196,'c0dc50b2-9119-4180-a448-a77264185082',64,'9a677c6c10fd4da0af5ed44e13f0b6ff','gigabytes___DEFAULT__',-1,'2025-10-03 12:46:14',NULL),('2025-10-02 12:46:15','2025-10-02 12:46:15','2025-10-02 12:46:15',1,197,'911720e1-12fd-4d5c-a6fd-b66eb72d81b7',61,'9a677c6c10fd4da0af5ed44e13f0b6ff','volumes',-1,'2025-10-03 12:46:15',NULL),('2025-10-02 12:46:15','2025-10-02 12:46:15','2025-10-02 12:46:15',1,198,'328f27f0-5552-4a9b-8655-ca218a217fe0',62,'9a677c6c10fd4da0af5ed44e13f0b6ff','gigabytes',-1,'2025-10-03 12:46:15',NULL),('2025-10-02 12:46:15','2025-10-02 12:46:15','2025-10-02 12:46:15',1,199,'c3ade6d0-5d9e-4a46-b393-cc01980722eb',63,'9a677c6c10fd4da0af5ed44e13f0b6ff','volumes___DEFAULT__',-1,'2025-10-03 12:46:15',NULL),('2025-10-02 12:46:15','2025-10-02 12:46:15','2025-10-02 12:46:15',1,200,'889bc408-2ed8-40e6-affa-aecb4ccd36d9',64,'9a677c6c10fd4da0af5ed44e13f0b6ff','gigabytes___DEFAULT__',-1,'2025-10-03 12:46:15',NULL),('2025-10-02 12:46:17','2025-10-02 12:46:17','2025-10-02 12:46:17',1,201,'9c2e5da6-5996-4930-a1b9-dfdf37078a8e',61,'9a677c6c10fd4da0af5ed44e13f0b6ff','volumes',-1,'2025-10-03 12:46:17',NULL),('2025-10-02 12:46:17','2025-10-02 12:46:17','2025-10-02 12:46:17',1,202,'30f6ad1f-8374-40c3-b64f-cf7bbf4ce62f',62,'9a677c6c10fd4da0af5ed44e13f0b6ff','gigabytes',-1,'2025-10-03 12:46:17',NULL),('2025-10-02 12:46:17','2025-10-02 12:46:17','2025-10-02 12:46:17',1,203,'a111c613-e032-46a6-b78b-72fd7db9502c',63,'9a677c6c10fd4da0af5ed44e13f0b6ff','volumes___DEFAULT__',-1,'2025-10-03 12:46:17',NULL),('2025-10-02 12:46:17','2025-10-02 12:46:17','2025-10-02 12:46:17',1,204,'b9640c95-fbb2-4434-a20d-1a0f5fe87b4c',64,'9a677c6c10fd4da0af5ed44e13f0b6ff','gigabytes___DEFAULT__',-1,'2025-10-03 12:46:17',NULL),('2025-10-02 12:46:47','2025-10-02 12:46:47','2025-10-02 12:46:47',1,205,'67e5fd36-d682-434c-baa9-8dbe2939f967',57,'c87621e5c0ba4f13abfff528143c1c00','volumes',-1,'2025-10-03 12:46:46',NULL),('2025-10-02 12:46:47','2025-10-02 12:46:47','2025-10-02 12:46:47',1,206,'102c92ec-eb13-4b7d-b489-9249a3e0111e',58,'c87621e5c0ba4f13abfff528143c1c00','gigabytes',-1,'2025-10-03 12:46:46',NULL),('2025-10-02 12:46:47','2025-10-02 12:46:47','2025-10-02 12:46:47',1,207,'8a8aeb85-4cad-464d-bef9-a68b8b517a50',59,'c87621e5c0ba4f13abfff528143c1c00','volumes___DEFAULT__',-1,'2025-10-03 12:46:46',NULL),('2025-10-02 12:46:47','2025-10-02 12:46:47','2025-10-02 12:46:47',1,208,'70139fad-6069-4fd6-92b0-7882605b2302',60,'c87621e5c0ba4f13abfff528143c1c00','gigabytes___DEFAULT__',-1,'2025-10-03 12:46:46',NULL),('2025-10-02 12:46:49','2025-10-02 12:46:49','2025-10-02 12:46:49',1,209,'6af3e991-4e30-46d0-a23f-f06754134df7',57,'c87621e5c0ba4f13abfff528143c1c00','volumes',-1,'2025-10-03 12:46:49',NULL),('2025-10-02 12:46:49','2025-10-02 12:46:49','2025-10-02 12:46:49',1,210,'b478caf0-c066-4b5a-a635-80b966bd8092',58,'c87621e5c0ba4f13abfff528143c1c00','gigabytes',-1,'2025-10-03 12:46:49',NULL),('2025-10-02 12:46:49','2025-10-02 12:46:49','2025-10-02 12:46:49',1,211,'a4b803cb-2e3d-4d98-870a-6baa18f78768',59,'c87621e5c0ba4f13abfff528143c1c00','volumes___DEFAULT__',-1,'2025-10-03 12:46:49',NULL),('2025-10-02 12:46:49','2025-10-02 12:46:49','2025-10-02 12:46:49',1,212,'ecbbeb73-8a87-49b9-8d1c-dce6aa878ffe',60,'c87621e5c0ba4f13abfff528143c1c00','gigabytes___DEFAULT__',-1,'2025-10-03 12:46:49',NULL),('2025-10-02 12:47:05','2025-10-02 12:47:05','2025-10-02 12:47:05',1,213,'c87c0900-9ac4-49d9-a50d-227a3353647b',65,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes',1,'2025-10-03 12:47:05',NULL),('2025-10-02 12:47:05','2025-10-02 12:47:05','2025-10-02 12:47:05',1,214,'150baa08-07d2-4136-a623-5c6826f39c73',66,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes',1,'2025-10-03 12:47:05',NULL),('2025-10-02 12:47:05','2025-10-02 12:47:05','2025-10-02 12:47:05',1,215,'efeaec0a-0d7a-4d4e-baee-6ad142647b6d',67,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1845639578-27731657',1,'2025-10-03 12:47:05',NULL),('2025-10-02 12:47:05','2025-10-02 12:47:05','2025-10-02 12:47:05',1,216,'38df8634-63d5-4988-abe4-132cd03edc7f',68,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1845639578-27731657',1,'2025-10-03 12:47:05',NULL),('2025-10-02 12:47:05','2025-10-02 12:47:05','2025-10-02 12:47:05',1,217,'5b465eda-40ec-4b57-b8a7-0120c9bc7cac',65,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes',1,'2025-10-03 12:47:05',NULL),('2025-10-02 12:47:05','2025-10-02 12:47:05','2025-10-02 12:47:05',1,218,'df096a9f-7491-4688-86f3-05616963e4f2',66,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes',1,'2025-10-03 12:47:05',NULL),('2025-10-02 12:47:05','2025-10-02 12:47:05','2025-10-02 12:47:05',1,219,'a69e6078-9d5a-4fcd-9203-d4ddeca27f7e',69,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-458173846-524194211',1,'2025-10-03 12:47:05',NULL),('2025-10-02 12:47:05','2025-10-02 12:47:05','2025-10-02 12:47:05',1,220,'89740610-c6f2-4a2f-b45a-258afb65d517',70,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-458173846-524194211',1,'2025-10-03 12:47:05',NULL),('2025-10-02 12:47:06','2025-10-02 12:47:06','2025-10-02 12:47:06',1,221,'a9b92997-92d8-4202-be1e-e973e7aa28dd',65,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes',1,'2025-10-03 12:47:06',NULL),('2025-10-02 12:47:06','2025-10-02 12:47:06','2025-10-02 12:47:06',1,222,'afe7bd19-8644-446e-b139-089fb1559d19',66,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes',1,'2025-10-03 12:47:06',NULL),('2025-10-02 12:47:06','2025-10-02 12:47:06','2025-10-02 12:47:06',1,223,'1ae702a7-6993-49a9-8e70-b19c2265597e',67,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1845639578-27731657',1,'2025-10-03 12:47:06',NULL),('2025-10-02 12:47:06','2025-10-02 12:47:06','2025-10-02 12:47:06',1,224,'7cb348a8-b45a-4423-9e79-0cb7491471c5',68,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1845639578-27731657',1,'2025-10-03 12:47:06',NULL),('2025-10-02 12:47:06','2025-10-02 12:47:06','2025-10-02 12:47:06',1,225,'4ab0f30e-d4bb-4ac2-a494-e0a78a3bdebf',65,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes',1,'2025-10-03 12:47:06',NULL),('2025-10-02 12:47:06','2025-10-02 12:47:06','2025-10-02 12:47:06',1,226,'d36a460c-2767-404f-98bb-8baf8c77c807',66,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes',1,'2025-10-03 12:47:06',NULL),('2025-10-02 12:47:06','2025-10-02 12:47:06','2025-10-02 12:47:06',1,227,'0405fce1-fcb9-4f8e-8dbd-3c790bb36e73',69,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-458173846-524194211',1,'2025-10-03 12:47:06',NULL),('2025-10-02 12:47:06','2025-10-02 12:47:06','2025-10-02 12:47:06',1,228,'6e200582-57af-49f1-ac5d-513d6bf1f09e',70,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-458173846-524194211',1,'2025-10-03 12:47:06',NULL),('2025-10-02 12:47:06','2025-10-02 12:47:06','2025-10-02 12:47:06',1,229,'37896c46-bc4f-49cf-9f55-884059127f95',65,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes',1,'2025-10-03 12:47:06',NULL),('2025-10-02 12:47:06','2025-10-02 12:47:06','2025-10-02 12:47:06',1,230,'1dc90df6-bf74-4765-ad00-dfdea94b2869',66,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes',1,'2025-10-03 12:47:06',NULL),('2025-10-02 12:47:06','2025-10-02 12:47:06','2025-10-02 12:47:06',1,231,'c59b5fd9-4baa-49a1-bfa1-5703140b9764',67,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1845639578-27731657',1,'2025-10-03 12:47:06',NULL),('2025-10-02 12:47:06','2025-10-02 12:47:06','2025-10-02 12:47:06',1,232,'304389c9-e9c6-40ba-995d-b95772f51f76',68,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1845639578-27731657',1,'2025-10-03 12:47:06',NULL),('2025-10-02 12:47:07','2025-10-02 12:47:07','2025-10-02 12:47:07',1,233,'7afeb0eb-80c1-4eaf-b258-007203b0ccf6',65,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes',1,'2025-10-03 12:47:07',NULL),('2025-10-02 12:47:07','2025-10-02 12:47:07','2025-10-02 12:47:07',1,234,'bf39f3a0-b314-448c-b1ae-8d6644ecf445',66,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes',1,'2025-10-03 12:47:07',NULL),('2025-10-02 12:47:07','2025-10-02 12:47:07','2025-10-02 12:47:07',1,235,'76228e8a-c54e-4cb9-8d10-20e72c1c4ae3',69,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-458173846-524194211',1,'2025-10-03 12:47:07',NULL),('2025-10-02 12:47:07','2025-10-02 12:47:07','2025-10-02 12:47:07',1,236,'3950a3fb-8e26-4be0-8d55-9ae959881793',70,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-458173846-524194211',1,'2025-10-03 12:47:07',NULL),('2025-10-02 12:47:10','2025-10-02 12:47:10','2025-10-02 12:47:10',1,237,'5e65eaa4-7619-41ec-ae1c-8e4d92744979',65,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes',1,'2025-10-03 12:47:10',NULL),('2025-10-02 12:47:10','2025-10-02 12:47:10','2025-10-02 12:47:10',1,238,'31c718d5-13a5-4d4f-a5d1-5bcb95c87ffb',66,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes',1,'2025-10-03 12:47:10',NULL),('2025-10-02 12:47:10','2025-10-02 12:47:10','2025-10-02 12:47:10',1,239,'99fa7f44-02eb-498d-b457-78082d90a78e',71,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-963401591-1280362666',1,'2025-10-03 12:47:10',NULL),('2025-10-02 12:47:10','2025-10-02 12:47:10','2025-10-02 12:47:10',1,240,'3cc5ef15-0ea9-468f-88aa-bdfb05e6eaa8',72,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-963401591-1280362666',1,'2025-10-03 12:47:10',NULL),('2025-10-02 12:47:14','2025-10-02 12:47:15','2025-10-02 12:47:15',1,241,'c9912eca-1536-4856-ae8c-b2d44fac525b',65,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes',1,'2025-10-03 12:47:14',NULL),('2025-10-02 12:47:14','2025-10-02 12:47:15','2025-10-02 12:47:15',1,242,'1550c593-26e1-4730-bd84-d52b84613289',66,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes',1,'2025-10-03 12:47:14',NULL),('2025-10-02 12:47:14','2025-10-02 12:47:15','2025-10-02 12:47:15',1,243,'146da2de-dd96-4cbf-983d-dbb6fdfcc048',71,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-963401591-1280362666',1,'2025-10-03 12:47:14',NULL),('2025-10-02 12:47:14','2025-10-02 12:47:15','2025-10-02 12:47:15',1,244,'077645eb-6e85-4a9f-94b6-f6abd7a88057',72,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-963401591-1280362666',1,'2025-10-03 12:47:14',NULL),('2025-10-02 12:47:17','2025-10-02 12:47:18','2025-10-02 12:47:18',1,245,'9d82968a-f6a7-4bca-adb8-54192926504c',65,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes',1,'2025-10-03 12:47:17',NULL),('2025-10-02 12:47:17','2025-10-02 12:47:18','2025-10-02 12:47:18',1,246,'fe366451-9e59-4ebd-bc87-25a899e9bcde',66,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes',1,'2025-10-03 12:47:17',NULL),('2025-10-02 12:47:17','2025-10-02 12:47:18','2025-10-02 12:47:18',1,247,'905f0448-760c-49f3-be00-ac6dfc1202ad',71,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-963401591-1280362666',1,'2025-10-03 12:47:17',NULL),('2025-10-02 12:47:17','2025-10-02 12:47:18','2025-10-02 12:47:18',1,248,'b9f2150d-4d90-412d-9cf2-75b5a5c75427',72,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-963401591-1280362666',1,'2025-10-03 12:47:17',NULL),('2025-10-02 12:48:03','2025-10-02 12:48:03','2025-10-02 12:48:03',1,249,'e496f7e5-49a5-40b5-b7a8-f6452097266e',53,'58b2fa4ee0cd4b97be1b303c203be14f','volumes',-1,'2025-10-03 12:48:03',NULL),('2025-10-02 12:48:03','2025-10-02 12:48:03','2025-10-02 12:48:03',1,250,'bdb6ced7-730e-4f23-9976-0b0cb41c3d06',54,'58b2fa4ee0cd4b97be1b303c203be14f','gigabytes',-1,'2025-10-03 12:48:03',NULL),('2025-10-02 12:48:03','2025-10-02 12:48:03','2025-10-02 12:48:03',1,251,'3d6ecb21-fa51-4db0-8d20-b4bef9df6fd9',55,'58b2fa4ee0cd4b97be1b303c203be14f','volumes___DEFAULT__',-1,'2025-10-03 12:48:03',NULL),('2025-10-02 12:48:03','2025-10-02 12:48:03','2025-10-02 12:48:03',1,252,'aca4035d-aa80-44d6-880c-035f84c7efcc',56,'58b2fa4ee0cd4b97be1b303c203be14f','gigabytes___DEFAULT__',-1,'2025-10-03 12:48:03',NULL),('2025-10-02 12:48:50','2025-10-02 12:48:50','2025-10-02 12:48:50',1,253,'9b27e6e9-be53-4333-8a56-ad8bf2463b97',65,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes',-1,'2025-10-03 12:48:50',NULL),('2025-10-02 12:48:50','2025-10-02 12:48:50','2025-10-02 12:48:50',1,254,'d89fc8be-bf20-4d0e-902a-9c170f6e244a',66,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes',-1,'2025-10-03 12:48:50',NULL),('2025-10-02 12:48:50','2025-10-02 12:48:50','2025-10-02 12:48:50',1,255,'b5d98ee7-26a6-4636-b9eb-bf2a48dece4c',67,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1845639578-27731657',-1,'2025-10-03 12:48:50',NULL),('2025-10-02 12:48:50','2025-10-02 12:48:50','2025-10-02 12:48:50',1,256,'650b109f-f76d-4ee2-8a91-2251ab45e3e2',68,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1845639578-27731657',-1,'2025-10-03 12:48:50',NULL),('2025-10-02 12:48:54','2025-10-02 12:48:54','2025-10-02 12:48:54',1,257,'5d03c758-d6f5-4a6b-8a01-5d1cfa74536f',65,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes',-1,'2025-10-03 12:48:54',NULL),('2025-10-02 12:48:54','2025-10-02 12:48:54','2025-10-02 12:48:54',1,258,'8fa247e9-117c-49f4-9686-b6f36414459a',66,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes',-1,'2025-10-03 12:48:54',NULL),('2025-10-02 12:48:54','2025-10-02 12:48:54','2025-10-02 12:48:54',1,259,'408bb0a6-18df-4614-9318-7f18f75a8786',69,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-458173846-524194211',-1,'2025-10-03 12:48:54',NULL),('2025-10-02 12:48:54','2025-10-02 12:48:54','2025-10-02 12:48:54',1,260,'417ebb5b-36bb-49de-b7b7-54c387cafb78',70,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-458173846-524194211',-1,'2025-10-03 12:48:54',NULL),('2025-10-02 12:49:35','2025-10-02 12:49:35','2025-10-02 12:49:35',1,261,'af3393ce-0010-4daa-af74-0635010cf662',65,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes',-1,'2025-10-03 12:49:35',NULL),('2025-10-02 12:49:35','2025-10-02 12:49:35','2025-10-02 12:49:35',1,262,'0e342e6b-792d-45dd-b724-6a15ece5091c',66,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes',-1,'2025-10-03 12:49:35',NULL),('2025-10-02 12:49:35','2025-10-02 12:49:35','2025-10-02 12:49:35',1,263,'b361ed09-17b6-453b-a28e-1d0b4faf6b37',67,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1845639578-27731657',-1,'2025-10-03 12:49:35',NULL),('2025-10-02 12:49:35','2025-10-02 12:49:35','2025-10-02 12:49:35',1,264,'91ab3572-8bca-4161-ae40-5202fb19cfe5',68,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1845639578-27731657',-1,'2025-10-03 12:49:35',NULL),('2025-10-02 12:49:37','2025-10-02 12:49:37','2025-10-02 12:49:37',1,265,'ce6c2f57-ca9d-4451-b9df-e36159e8de51',73,'a5f0c507e8754b67a03586ed76d09b47','volumes',1,'2025-10-03 12:49:37',NULL),('2025-10-02 12:49:37','2025-10-02 12:49:37','2025-10-02 12:49:37',1,266,'2da4f0ce-02dd-4a59-a625-ecdc49490692',74,'a5f0c507e8754b67a03586ed76d09b47','gigabytes',1,'2025-10-03 12:49:37',NULL),('2025-10-02 12:49:37','2025-10-02 12:49:37','2025-10-02 12:49:37',1,267,'13c0478e-34ed-472f-85ce-e22ac235ae55',75,'a5f0c507e8754b67a03586ed76d09b47','volumes___DEFAULT__',1,'2025-10-03 12:49:37',NULL),('2025-10-02 12:49:37','2025-10-02 12:49:37','2025-10-02 12:49:37',1,268,'546af971-6acf-41ed-8c6d-3e856f5b27e3',76,'a5f0c507e8754b67a03586ed76d09b47','gigabytes___DEFAULT__',1,'2025-10-03 12:49:37',NULL),('2025-10-02 12:49:39','2025-10-02 12:49:39','2025-10-02 12:49:39',1,269,'4ae0a4f9-f195-48f6-8a24-842441020c3f',77,'dbd0afdfb05849f9abfe4cd4454f6a13','volumes',1,'2025-10-03 12:49:39',NULL),('2025-10-02 12:49:39','2025-10-02 12:49:39','2025-10-02 12:49:39',1,270,'4abf90d3-5b6a-4163-abbd-5b04fd3c13df',78,'dbd0afdfb05849f9abfe4cd4454f6a13','gigabytes',1,'2025-10-03 12:49:39',NULL),('2025-10-02 12:49:39','2025-10-02 12:49:39','2025-10-02 12:49:39',1,271,'38f58985-e72e-4fb2-b9b9-160ff86ce9b4',79,'dbd0afdfb05849f9abfe4cd4454f6a13','volumes___DEFAULT__',1,'2025-10-03 12:49:39',NULL),('2025-10-02 12:49:39','2025-10-02 12:49:39','2025-10-02 12:49:39',1,272,'18c4e387-5284-4ea2-8839-84afd1ced672',80,'dbd0afdfb05849f9abfe4cd4454f6a13','gigabytes___DEFAULT__',1,'2025-10-03 12:49:39',NULL),('2025-10-02 12:49:42','2025-10-02 12:49:42','2025-10-02 12:49:42',1,273,'9754eadf-e9bb-4f43-9891-d1bcacb757d7',73,'a5f0c507e8754b67a03586ed76d09b47','volumes',-1,'2025-10-03 12:49:42',NULL),('2025-10-02 12:49:42','2025-10-02 12:49:42','2025-10-02 12:49:42',1,274,'d24e190d-2b6f-4c92-ba7a-dfb5c10b22dd',74,'a5f0c507e8754b67a03586ed76d09b47','gigabytes',-1,'2025-10-03 12:49:42',NULL),('2025-10-02 12:49:42','2025-10-02 12:49:42','2025-10-02 12:49:42',1,275,'97e30ef1-b713-4873-a492-43c23b289b1d',75,'a5f0c507e8754b67a03586ed76d09b47','volumes___DEFAULT__',-1,'2025-10-03 12:49:42',NULL),('2025-10-02 12:49:42','2025-10-02 12:49:42','2025-10-02 12:49:42',1,276,'c3777262-992c-4e56-b19e-21a24741e02f',76,'a5f0c507e8754b67a03586ed76d09b47','gigabytes___DEFAULT__',-1,'2025-10-03 12:49:42',NULL),('2025-10-02 12:49:42','2025-10-02 12:49:42','2025-10-02 12:49:42',1,277,'4ef9506a-18c9-48f7-8036-5c766b42bfdf',81,'1308a7eb298f49baaeaf3dc3a6acf592','volumes',1,'2025-10-03 12:49:42',NULL),('2025-10-02 12:49:42','2025-10-02 12:49:42','2025-10-02 12:49:42',1,278,'0ede31b5-7f1c-4de4-8243-a2c913fc1c6d',82,'1308a7eb298f49baaeaf3dc3a6acf592','gigabytes',1,'2025-10-03 12:49:42',NULL),('2025-10-02 12:49:42','2025-10-02 12:49:42','2025-10-02 12:49:42',1,279,'b269ddcf-79c5-481f-80d3-5db4f24c7a60',83,'1308a7eb298f49baaeaf3dc3a6acf592','volumes___DEFAULT__',1,'2025-10-03 12:49:42',NULL),('2025-10-02 12:49:42','2025-10-02 12:49:42','2025-10-02 12:49:42',1,280,'e08349f0-d830-47bd-9c31-a9f17b75b2d5',84,'1308a7eb298f49baaeaf3dc3a6acf592','gigabytes___DEFAULT__',1,'2025-10-03 12:49:42',NULL),('2025-10-02 12:49:42','2025-10-02 12:49:43','2025-10-02 12:49:43',1,281,'6b5ee326-4468-4948-b145-d64036fcf219',65,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes',-1,'2025-10-03 12:49:42',NULL),('2025-10-02 12:49:42','2025-10-02 12:49:43','2025-10-02 12:49:43',1,282,'28febfce-1e7b-4a93-b9fe-09df0ffe4fc0',66,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes',-1,'2025-10-03 12:49:42',NULL),('2025-10-02 12:49:42','2025-10-02 12:49:43','2025-10-02 12:49:43',1,283,'9a1a6e16-7d02-4afa-b16e-7270b26398a5',69,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-458173846-524194211',-1,'2025-10-03 12:49:42',NULL),('2025-10-02 12:49:42','2025-10-02 12:49:43','2025-10-02 12:49:43',1,284,'f7c0d517-a94d-48fe-9563-ccaa6c8c0cf4',70,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-458173846-524194211',-1,'2025-10-03 12:49:42',NULL),('2025-10-02 12:50:24','2025-10-02 12:50:24','2025-10-02 12:50:24',1,285,'d78d5da9-9c8f-4d82-93f4-f75b0fd5ec88',65,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes',-1,'2025-10-03 12:50:24',NULL),('2025-10-02 12:50:24','2025-10-02 12:50:24','2025-10-02 12:50:24',1,286,'604c92d1-79c0-4396-8d45-017310586f81',66,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes',-1,'2025-10-03 12:50:24',NULL),('2025-10-02 12:50:24','2025-10-02 12:50:24','2025-10-02 12:50:24',1,287,'24a7a8e6-bd0d-44fe-b28d-f8d1c6dc3272',67,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1845639578-27731657',-1,'2025-10-03 12:50:24',NULL),('2025-10-02 12:50:24','2025-10-02 12:50:24','2025-10-02 12:50:24',1,288,'a9b502c6-1578-48af-8390-b4f1eef4d85d',68,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1845639578-27731657',-1,'2025-10-03 12:50:24',NULL),('2025-10-02 12:50:31','2025-10-02 12:50:31','2025-10-02 12:50:31',1,289,'28beac0d-d62e-448a-a12a-8c08ea80b754',65,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes',-1,'2025-10-03 12:50:31',NULL),('2025-10-02 12:50:31','2025-10-02 12:50:31','2025-10-02 12:50:31',1,290,'dfa20e20-d362-4115-bafd-5922c54d0a81',66,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes',-1,'2025-10-03 12:50:31',NULL),('2025-10-02 12:50:31','2025-10-02 12:50:31','2025-10-02 12:50:31',1,291,'4c0a9790-fa48-4a3e-9aee-7e816250e103',69,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-458173846-524194211',-1,'2025-10-03 12:50:31',NULL),('2025-10-02 12:50:31','2025-10-02 12:50:31','2025-10-02 12:50:31',1,292,'3a985bef-554b-4f4f-8ad5-761b6412a108',70,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-458173846-524194211',-1,'2025-10-03 12:50:31',NULL),('2025-10-02 12:51:12','2025-10-02 12:51:13','2025-10-02 12:51:13',1,293,'a008beeb-e69f-4289-b1a8-94cf31bc6646',65,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes',-1,'2025-10-03 12:51:12',NULL),('2025-10-02 12:51:12','2025-10-02 12:51:13','2025-10-02 12:51:13',1,294,'48d4ae05-e30c-4a30-8cf0-d5bb91cd3850',66,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes',-1,'2025-10-03 12:51:12',NULL),('2025-10-02 12:51:12','2025-10-02 12:51:13','2025-10-02 12:51:13',1,295,'b99dd3b4-50f3-47a3-b402-335cd4fd8270',71,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-963401591-1280362666',-1,'2025-10-03 12:51:12',NULL),('2025-10-02 12:51:12','2025-10-02 12:51:13','2025-10-02 12:51:13',1,296,'aa782f8e-e9d8-489b-a795-92e86e9d00d5',72,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-963401591-1280362666',-1,'2025-10-03 12:51:12',NULL),('2025-10-02 12:51:15','2025-10-02 12:51:15','2025-10-02 12:51:15',1,297,'de7e9292-0e47-4326-a921-d864172b098f',65,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes',-1,'2025-10-03 12:51:15',NULL),('2025-10-02 12:51:15','2025-10-02 12:51:15','2025-10-02 12:51:15',1,298,'7a89d55f-20ab-4070-8d3e-067a1add998c',66,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes',-1,'2025-10-03 12:51:15',NULL),('2025-10-02 12:51:15','2025-10-02 12:51:15','2025-10-02 12:51:15',1,299,'32b1e1b0-9fec-4bde-92c9-c7eb611f8463',71,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-963401591-1280362666',-1,'2025-10-03 12:51:15',NULL),('2025-10-02 12:51:15','2025-10-02 12:51:15','2025-10-02 12:51:15',1,300,'cf20a3f2-0dd0-4e36-aa11-4036b540d3d0',72,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-963401591-1280362666',-1,'2025-10-03 12:51:15',NULL),('2025-10-02 12:51:18','2025-10-02 12:51:18','2025-10-02 12:51:18',1,301,'c8390739-85f7-4545-80ca-59d29ba76e67',65,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes',-1,'2025-10-03 12:51:18',NULL),('2025-10-02 12:51:18','2025-10-02 12:51:18','2025-10-02 12:51:18',1,302,'efcc396e-9479-4405-9d23-23447c08100e',66,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes',-1,'2025-10-03 12:51:18',NULL),('2025-10-02 12:51:18','2025-10-02 12:51:18','2025-10-02 12:51:18',1,303,'47ea1ab2-4984-4efb-987b-a27685e7a5fa',71,'d3e0300f3cf5493d8a9e62e2c4a95767','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-963401591-1280362666',-1,'2025-10-03 12:51:18',NULL),('2025-10-02 12:51:18','2025-10-02 12:51:18','2025-10-02 12:51:18',1,304,'c3b2c5b4-2a91-4b94-940d-a23f1694ba6a',72,'d3e0300f3cf5493d8a9e62e2c4a95767','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-963401591-1280362666',-1,'2025-10-03 12:51:18',NULL),('2025-10-02 12:52:10','2025-10-02 12:52:10','2025-10-02 12:52:10',1,305,'cb42fbb3-9a60-443e-aaf3-717b9219ecab',81,'1308a7eb298f49baaeaf3dc3a6acf592','volumes',-1,'2025-10-03 12:52:10',NULL),('2025-10-02 12:52:10','2025-10-02 12:52:10','2025-10-02 12:52:10',1,306,'86a18290-5ea6-42e8-b303-ee8ce0cc25d6',82,'1308a7eb298f49baaeaf3dc3a6acf592','gigabytes',-1,'2025-10-03 12:52:10',NULL),('2025-10-02 12:52:10','2025-10-02 12:52:10','2025-10-02 12:52:10',1,307,'372bc1c9-f5d9-4824-b4fd-36bf6e5ac63b',83,'1308a7eb298f49baaeaf3dc3a6acf592','volumes___DEFAULT__',-1,'2025-10-03 12:52:10',NULL),('2025-10-02 12:52:10','2025-10-02 12:52:10','2025-10-02 12:52:10',1,308,'adc400ac-132a-40cd-b6c5-d5752fc93db3',84,'1308a7eb298f49baaeaf3dc3a6acf592','gigabytes___DEFAULT__',-1,'2025-10-03 12:52:10',NULL),('2025-10-02 12:53:54','2025-10-02 12:53:54','2025-10-02 12:53:54',1,309,'b2b4363a-2334-4ee0-8c5b-fee8c754bff3',77,'dbd0afdfb05849f9abfe4cd4454f6a13','volumes',-1,'2025-10-03 12:53:54',NULL),('2025-10-02 12:53:54','2025-10-02 12:53:54','2025-10-02 12:53:54',1,310,'178ff25b-581c-4791-afeb-eff84b2324a1',78,'dbd0afdfb05849f9abfe4cd4454f6a13','gigabytes',-1,'2025-10-03 12:53:54',NULL),('2025-10-02 12:53:54','2025-10-02 12:53:54','2025-10-02 12:53:54',1,311,'01e7516b-581c-422a-9b20-ea0730b62f53',79,'dbd0afdfb05849f9abfe4cd4454f6a13','volumes___DEFAULT__',-1,'2025-10-03 12:53:54',NULL),('2025-10-02 12:53:54','2025-10-02 12:53:54','2025-10-02 12:53:54',1,312,'559e6806-a108-45a5-82d2-48f17d3d01a5',80,'dbd0afdfb05849f9abfe4cd4454f6a13','gigabytes___DEFAULT__',-1,'2025-10-03 12:53:54',NULL),('2025-10-02 12:54:03','2025-10-02 12:54:03','2025-10-02 12:54:03',1,313,'e6ec7bfb-d044-4435-b208-1d55904474ae',85,'cb2da64acac041cb8d38c3b43fe4dbe9','volumes',1,'2025-10-03 12:54:03',NULL),('2025-10-02 12:54:03','2025-10-02 12:54:03','2025-10-02 12:54:03',1,314,'b281188e-e9e1-4099-8046-18a948ce5390',86,'cb2da64acac041cb8d38c3b43fe4dbe9','gigabytes',1,'2025-10-03 12:54:03',NULL),('2025-10-02 12:54:03','2025-10-02 12:54:03','2025-10-02 12:54:03',1,315,'d0a000fa-d5e7-49cb-a45e-3c7553221651',87,'cb2da64acac041cb8d38c3b43fe4dbe9','volumes___DEFAULT__',1,'2025-10-03 12:54:03',NULL),('2025-10-02 12:54:03','2025-10-02 12:54:03','2025-10-02 12:54:03',1,316,'a414032e-5068-4d41-acb3-24d08e2b2cac',88,'cb2da64acac041cb8d38c3b43fe4dbe9','gigabytes___DEFAULT__',1,'2025-10-03 12:54:03',NULL),('2025-10-02 12:56:33','2025-10-02 12:56:33','2025-10-02 12:56:33',1,317,'572e4922-1cc5-452a-b4e3-111cc4365b89',85,'cb2da64acac041cb8d38c3b43fe4dbe9','volumes',1,'2025-10-03 12:56:33',NULL),('2025-10-02 12:56:33','2025-10-02 12:56:33','2025-10-02 12:56:33',1,318,'a8ee4493-dcb3-47e1-8c00-bfc626fa6f31',86,'cb2da64acac041cb8d38c3b43fe4dbe9','gigabytes',1,'2025-10-03 12:56:33',NULL),('2025-10-02 12:56:33','2025-10-02 12:56:33','2025-10-02 12:56:33',1,319,'7d4893fb-4fd8-44a8-a329-e49020863f77',87,'cb2da64acac041cb8d38c3b43fe4dbe9','volumes___DEFAULT__',1,'2025-10-03 12:56:33',NULL),('2025-10-02 12:56:33','2025-10-02 12:56:33','2025-10-02 12:56:33',1,320,'5b6b45f1-a257-4054-b08b-2539cf3ac8c4',88,'cb2da64acac041cb8d38c3b43fe4dbe9','gigabytes___DEFAULT__',1,'2025-10-03 12:56:33',NULL),('2025-10-02 12:59:08','2025-10-02 12:59:08','2025-10-02 12:59:08',1,321,'f31c0c32-14cf-487b-b98b-34540c6825f5',89,'0b15f29eb32d4c5cba98baa238cc12e1','volumes',1,'2025-10-03 12:59:08',NULL),('2025-10-02 12:59:08','2025-10-02 12:59:08','2025-10-02 12:59:08',1,322,'e943ccbb-f2b1-45be-be91-eede4d7fe05a',90,'0b15f29eb32d4c5cba98baa238cc12e1','gigabytes',1,'2025-10-03 12:59:08',NULL),('2025-10-02 12:59:08','2025-10-02 12:59:08','2025-10-02 12:59:08',1,323,'b6e08944-be3c-4b05-9423-43cb33aa3661',91,'0b15f29eb32d4c5cba98baa238cc12e1','volumes___DEFAULT__',1,'2025-10-03 12:59:08',NULL),('2025-10-02 12:59:08','2025-10-02 12:59:08','2025-10-02 12:59:08',1,324,'763dc962-493e-40ed-ae6b-aeb0a1c44e6c',92,'0b15f29eb32d4c5cba98baa238cc12e1','gigabytes___DEFAULT__',1,'2025-10-03 12:59:08',NULL),('2025-10-02 13:01:15','2025-10-02 13:01:15','2025-10-02 13:01:15',1,325,'af5866d2-5dcb-4d58-acec-0b04644e8162',89,'0b15f29eb32d4c5cba98baa238cc12e1','volumes',1,'2025-10-03 13:01:15',NULL),('2025-10-02 13:01:15','2025-10-02 13:01:15','2025-10-02 13:01:15',1,326,'7e8712b0-9e77-40d0-bb16-0812276a0665',90,'0b15f29eb32d4c5cba98baa238cc12e1','gigabytes',1,'2025-10-03 13:01:15',NULL),('2025-10-02 13:01:15','2025-10-02 13:01:15','2025-10-02 13:01:15',1,327,'19fa0de8-b57d-4baf-8276-0a85c29b061f',91,'0b15f29eb32d4c5cba98baa238cc12e1','volumes___DEFAULT__',1,'2025-10-03 13:01:15',NULL),('2025-10-02 13:01:15','2025-10-02 13:01:15','2025-10-02 13:01:15',1,328,'b8d0f08a-1ca5-4e9a-ba69-e9279ec02114',92,'0b15f29eb32d4c5cba98baa238cc12e1','gigabytes___DEFAULT__',1,'2025-10-03 13:01:15',NULL),('2025-10-02 13:01:21','2025-10-02 13:01:21','2025-10-02 13:01:21',1,329,'df6f1dbe-c172-4296-af94-b9839bf04385',89,'0b15f29eb32d4c5cba98baa238cc12e1','volumes',1,'2025-10-03 13:01:21',NULL),('2025-10-02 13:01:21','2025-10-02 13:01:21','2025-10-02 13:01:21',1,330,'eec4f2af-db1a-4714-8b8b-d75000056ffb',90,'0b15f29eb32d4c5cba98baa238cc12e1','gigabytes',1,'2025-10-03 13:01:21',NULL),('2025-10-02 13:01:21','2025-10-02 13:01:21','2025-10-02 13:01:21',1,331,'03941ce4-095b-4ad6-b514-f3c245fdc858',91,'0b15f29eb32d4c5cba98baa238cc12e1','volumes___DEFAULT__',1,'2025-10-03 13:01:21',NULL),('2025-10-02 13:01:21','2025-10-02 13:01:21','2025-10-02 13:01:21',1,332,'ab777843-7edf-49cc-89c8-f141cc450cfd',92,'0b15f29eb32d4c5cba98baa238cc12e1','gigabytes___DEFAULT__',1,'2025-10-03 13:01:21',NULL),('2025-10-02 13:01:50','2025-10-02 13:01:50','2025-10-02 13:01:50',1,333,'56e1b39b-a82d-4e68-8289-06db4bb60f37',89,'0b15f29eb32d4c5cba98baa238cc12e1','volumes',-1,'2025-10-03 13:01:50',NULL),('2025-10-02 13:01:50','2025-10-02 13:01:50','2025-10-02 13:01:50',1,334,'9e9048c9-a62d-4aa3-a5e9-0bb91d54536c',90,'0b15f29eb32d4c5cba98baa238cc12e1','gigabytes',-1,'2025-10-03 13:01:50',NULL),('2025-10-02 13:01:50','2025-10-02 13:01:50','2025-10-02 13:01:50',1,335,'f8a016a4-5c00-4bc1-95af-09146ff39a94',91,'0b15f29eb32d4c5cba98baa238cc12e1','volumes___DEFAULT__',-1,'2025-10-03 13:01:50',NULL),('2025-10-02 13:01:50','2025-10-02 13:01:50','2025-10-02 13:01:50',1,336,'ee6b2218-c8bc-49e0-a9b2-80175302965a',92,'0b15f29eb32d4c5cba98baa238cc12e1','gigabytes___DEFAULT__',-1,'2025-10-03 13:01:50',NULL),('2025-10-02 13:01:52','2025-10-02 13:01:52','2025-10-02 13:01:52',1,337,'e6958344-f4ae-4308-a9b1-3c5bc29add95',89,'0b15f29eb32d4c5cba98baa238cc12e1','volumes',-1,'2025-10-03 13:01:52',NULL),('2025-10-02 13:01:52','2025-10-02 13:01:52','2025-10-02 13:01:52',1,338,'41ff2778-673f-410d-be04-b8d58b59bc08',90,'0b15f29eb32d4c5cba98baa238cc12e1','gigabytes',-1,'2025-10-03 13:01:52',NULL),('2025-10-02 13:01:52','2025-10-02 13:01:52','2025-10-02 13:01:52',1,339,'b7649f46-5bbd-4ca7-a189-37d3f0618e6a',91,'0b15f29eb32d4c5cba98baa238cc12e1','volumes___DEFAULT__',-1,'2025-10-03 13:01:52',NULL),('2025-10-02 13:01:52','2025-10-02 13:01:52','2025-10-02 13:01:52',1,340,'a76d1c6d-0dbd-421b-ab7e-129f610a0875',92,'0b15f29eb32d4c5cba98baa238cc12e1','gigabytes___DEFAULT__',-1,'2025-10-03 13:01:52',NULL),('2025-10-02 13:01:55','2025-10-02 13:01:55','2025-10-02 13:01:55',1,341,'92882b95-4e25-403e-ae98-c2b92d336b00',89,'0b15f29eb32d4c5cba98baa238cc12e1','volumes',-1,'2025-10-03 13:01:55',NULL),('2025-10-02 13:01:55','2025-10-02 13:01:55','2025-10-02 13:01:55',1,342,'31d1fb97-3239-4bfa-9b7f-59de6d96083c',90,'0b15f29eb32d4c5cba98baa238cc12e1','gigabytes',-1,'2025-10-03 13:01:55',NULL),('2025-10-02 13:01:55','2025-10-02 13:01:55','2025-10-02 13:01:55',1,343,'c28c500e-53ab-49bf-b318-04172e68fe3b',91,'0b15f29eb32d4c5cba98baa238cc12e1','volumes___DEFAULT__',-1,'2025-10-03 13:01:55',NULL),('2025-10-02 13:01:55','2025-10-02 13:01:55','2025-10-02 13:01:55',1,344,'990f8053-121e-4ee7-8990-3ceb7f945dee',92,'0b15f29eb32d4c5cba98baa238cc12e1','gigabytes___DEFAULT__',-1,'2025-10-03 13:01:55',NULL),('2025-10-02 13:02:35','2025-10-02 13:02:35','2025-10-02 13:02:35',1,345,'51d9709b-a4c8-4dad-bbdf-d8cdcf0d207e',93,'6e8f1f6ceb7b40ee9fa002d881b59a44','volumes',1,'2025-10-03 13:02:35',NULL),('2025-10-02 13:02:35','2025-10-02 13:02:35','2025-10-02 13:02:35',1,346,'161f0900-df19-449b-a882-80e74e9ca429',94,'6e8f1f6ceb7b40ee9fa002d881b59a44','gigabytes',1,'2025-10-03 13:02:35',NULL),('2025-10-02 13:02:35','2025-10-02 13:02:35','2025-10-02 13:02:35',1,347,'d11ad606-9770-4b4d-aab9-9eac99e90dd6',95,'6e8f1f6ceb7b40ee9fa002d881b59a44','volumes_tempest-scenario-type-luks-1564408968',1,'2025-10-03 13:02:35',NULL),('2025-10-02 13:02:35','2025-10-02 13:02:35','2025-10-02 13:02:35',1,348,'4c6f0cb4-6008-49fe-942f-48c8e6a1179c',96,'6e8f1f6ceb7b40ee9fa002d881b59a44','gigabytes_tempest-scenario-type-luks-1564408968',1,'2025-10-03 13:02:35',NULL),('2025-10-02 13:03:33','2025-10-02 13:03:33','2025-10-02 13:03:33',1,349,'a33eeed7-b3c2-4d33-bb26-2abe5f0fc533',93,'6e8f1f6ceb7b40ee9fa002d881b59a44','volumes',-1,'2025-10-03 13:03:33',NULL),('2025-10-02 13:03:33','2025-10-02 13:03:33','2025-10-02 13:03:33',1,350,'3d3392ba-00ef-4e48-a6ed-bf652388998c',94,'6e8f1f6ceb7b40ee9fa002d881b59a44','gigabytes',-1,'2025-10-03 13:03:33',NULL),('2025-10-02 13:03:33','2025-10-02 13:03:33','2025-10-02 13:03:33',1,351,'4a863665-2fe2-4485-9184-fee9c9e1a39c',95,'6e8f1f6ceb7b40ee9fa002d881b59a44','volumes_tempest-scenario-type-luks-1564408968',-1,'2025-10-03 13:03:33',NULL),('2025-10-02 13:03:33','2025-10-02 13:03:33','2025-10-02 13:03:33',1,352,'c14590c2-da80-417f-b12b-b385db6f3a8c',96,'6e8f1f6ceb7b40ee9fa002d881b59a44','gigabytes_tempest-scenario-type-luks-1564408968',-1,'2025-10-03 13:03:33',NULL),('2025-10-02 13:04:26','2025-10-02 13:04:26','2025-10-02 13:04:26',1,353,'1e2fa9e6-815c-45a5-8ccd-b42d993e205b',97,'52dd3c4419794d0fbecd536c5088c60f','volumes',1,'2025-10-03 13:04:26',NULL),('2025-10-02 13:04:26','2025-10-02 13:04:26','2025-10-02 13:04:26',1,354,'4e197442-3872-46d6-8375-14ff949f2e87',98,'52dd3c4419794d0fbecd536c5088c60f','gigabytes',1,'2025-10-03 13:04:26',NULL),('2025-10-02 13:04:26','2025-10-02 13:04:26','2025-10-02 13:04:26',1,355,'4276f868-6749-4155-91fa-416639da806f',99,'52dd3c4419794d0fbecd536c5088c60f','volumes___DEFAULT__',1,'2025-10-03 13:04:26',NULL),('2025-10-02 13:04:26','2025-10-02 13:04:26','2025-10-02 13:04:26',1,356,'ccf35fad-e308-4ce2-bafc-281ab0635cfb',100,'52dd3c4419794d0fbecd536c5088c60f','gigabytes___DEFAULT__',1,'2025-10-03 13:04:26',NULL),('2025-10-02 13:04:29','2025-10-02 13:04:29','2025-10-02 13:04:29',1,357,'9850aeac-2e19-438c-9355-33ac99ce1dc2',97,'52dd3c4419794d0fbecd536c5088c60f','volumes',1,'2025-10-03 13:04:29',NULL),('2025-10-02 13:04:29','2025-10-02 13:04:29','2025-10-02 13:04:29',1,358,'5d69492a-c3e7-45ff-9144-d3295d577ecd',98,'52dd3c4419794d0fbecd536c5088c60f','gigabytes',1,'2025-10-03 13:04:29',NULL),('2025-10-02 13:04:29','2025-10-02 13:04:29','2025-10-02 13:04:29',1,359,'0cf91619-b275-44b0-8d15-28a9638ef4c6',99,'52dd3c4419794d0fbecd536c5088c60f','volumes___DEFAULT__',1,'2025-10-03 13:04:29',NULL),('2025-10-02 13:04:29','2025-10-02 13:04:29','2025-10-02 13:04:29',1,360,'5a300140-26ac-4109-9129-c1fab07abbdc',100,'52dd3c4419794d0fbecd536c5088c60f','gigabytes___DEFAULT__',1,'2025-10-03 13:04:29',NULL),('2025-10-02 13:07:09','2025-10-02 13:07:09','2025-10-02 13:07:09',1,361,'14504bdf-e60c-42c8-a668-3b6d78178c08',97,'52dd3c4419794d0fbecd536c5088c60f','volumes',-1,'2025-10-03 13:07:09',NULL),('2025-10-02 13:07:09','2025-10-02 13:07:09','2025-10-02 13:07:09',1,362,'dd3de4d1-bbcc-4db3-a520-2a7c98255248',98,'52dd3c4419794d0fbecd536c5088c60f','gigabytes',-1,'2025-10-03 13:07:09',NULL),('2025-10-02 13:07:09','2025-10-02 13:07:09','2025-10-02 13:07:09',1,363,'02d27272-e889-41c7-b9f2-0c73749c4467',99,'52dd3c4419794d0fbecd536c5088c60f','volumes___DEFAULT__',-1,'2025-10-03 13:07:09',NULL),('2025-10-02 13:07:09','2025-10-02 13:07:09','2025-10-02 13:07:09',1,364,'66c1df5b-d8ba-410e-9b54-45f962394a1b',100,'52dd3c4419794d0fbecd536c5088c60f','gigabytes___DEFAULT__',-1,'2025-10-03 13:07:09',NULL),('2025-10-02 13:07:10','2025-10-02 13:07:10','2025-10-02 13:07:10',1,365,'3e4fb01a-603e-4eaa-8424-e291592a7eb8',97,'52dd3c4419794d0fbecd536c5088c60f','volumes',-1,'2025-10-03 13:07:10',NULL),('2025-10-02 13:07:10','2025-10-02 13:07:10','2025-10-02 13:07:10',1,366,'d78332e3-b74d-47c6-91e8-da186d189fab',98,'52dd3c4419794d0fbecd536c5088c60f','gigabytes',-1,'2025-10-03 13:07:10',NULL),('2025-10-02 13:07:10','2025-10-02 13:07:10','2025-10-02 13:07:10',1,367,'044b056d-30f3-454e-bbaf-dec2611648f4',99,'52dd3c4419794d0fbecd536c5088c60f','volumes___DEFAULT__',-1,'2025-10-03 13:07:10',NULL),('2025-10-02 13:07:10','2025-10-02 13:07:10','2025-10-02 13:07:10',1,368,'4e1f45c5-e867-4953-9c90-93a875f1aedb',100,'52dd3c4419794d0fbecd536c5088c60f','gigabytes___DEFAULT__',-1,'2025-10-03 13:07:10',NULL),('2025-10-02 13:07:56','2025-10-02 13:07:56','2025-10-02 13:07:56',1,369,'9be74fbb-7719-4b13-9e5d-c30f9b9f8551',101,'9f85b8f387b146d29eabe946c4fbdee8','volumes',1,'2025-10-03 13:07:56',NULL),('2025-10-02 13:07:56','2025-10-02 13:07:56','2025-10-02 13:07:56',1,370,'84eebc74-9d35-4199-ad77-85644dd99af7',102,'9f85b8f387b146d29eabe946c4fbdee8','gigabytes',1,'2025-10-03 13:07:56',NULL),('2025-10-02 13:07:56','2025-10-02 13:07:56','2025-10-02 13:07:56',1,371,'f9b176d4-7882-45af-bfd1-3a8e76d14143',103,'9f85b8f387b146d29eabe946c4fbdee8','volumes_multiattach',1,'2025-10-03 13:07:56',NULL),('2025-10-02 13:07:56','2025-10-02 13:07:56','2025-10-02 13:07:56',1,372,'8ef0fed4-6b14-4c35-ae98-c41e04f9b41a',104,'9f85b8f387b146d29eabe946c4fbdee8','gigabytes_multiattach',1,'2025-10-03 13:07:56',NULL),('2025-10-02 13:09:15','2025-10-02 13:09:15','2025-10-02 13:09:15',1,373,'907da94f-3c8d-442a-a076-595a80ad80e2',101,'9f85b8f387b146d29eabe946c4fbdee8','volumes',1,'2025-10-03 13:09:15',NULL),('2025-10-02 13:09:15','2025-10-02 13:09:15','2025-10-02 13:09:15',1,374,'b05b6438-dcc9-40a1-a5ae-7a790eb493c4',102,'9f85b8f387b146d29eabe946c4fbdee8','gigabytes',1,'2025-10-03 13:09:15',NULL),('2025-10-02 13:09:15','2025-10-02 13:09:15','2025-10-02 13:09:15',1,375,'a9694815-a9e0-4f80-8fe2-940b5cd0a79a',103,'9f85b8f387b146d29eabe946c4fbdee8','volumes_multiattach',1,'2025-10-03 13:09:15',NULL),('2025-10-02 13:09:15','2025-10-02 13:09:15','2025-10-02 13:09:15',1,376,'ec2748ad-fc45-47b9-9a53-5960e6c8cd2d',104,'9f85b8f387b146d29eabe946c4fbdee8','gigabytes_multiattach',1,'2025-10-03 13:09:15',NULL),('2025-10-02 13:09:42','2025-10-02 13:09:42','2025-10-02 13:09:42',1,377,'436a30f6-43be-4c00-9bb4-c60e60751df4',105,'954946ff6b204fba90f767ec67210620','volumes',1,'2025-10-03 13:09:42',NULL),('2025-10-02 13:09:42','2025-10-02 13:09:42','2025-10-02 13:09:42',1,378,'cad0d581-4da5-42a2-b5df-ce9a964c54a4',106,'954946ff6b204fba90f767ec67210620','gigabytes',1,'2025-10-03 13:09:42',NULL),('2025-10-02 13:09:42','2025-10-02 13:09:42','2025-10-02 13:09:42',1,379,'b3363322-749f-42e0-a8ed-baa5b96ddc87',107,'954946ff6b204fba90f767ec67210620','volumes___DEFAULT__',1,'2025-10-03 13:09:42',NULL),('2025-10-02 13:09:42','2025-10-02 13:09:42','2025-10-02 13:09:42',1,380,'0e93e079-abe7-4779-83b2-6eaf8eb4d483',108,'954946ff6b204fba90f767ec67210620','gigabytes___DEFAULT__',1,'2025-10-03 13:09:42',NULL),('2025-10-02 13:10:00','2025-10-02 13:10:00','2025-10-02 13:10:00',1,381,'2d11b67e-8547-458b-a30e-516a8735ecd7',101,'9f85b8f387b146d29eabe946c4fbdee8','volumes',1,'2025-10-03 13:10:00',NULL),('2025-10-02 13:10:00','2025-10-02 13:10:00','2025-10-02 13:10:00',1,382,'ca8e4574-9a44-40e3-8cd2-0f5c5570f526',102,'9f85b8f387b146d29eabe946c4fbdee8','gigabytes',1,'2025-10-03 13:10:00',NULL),('2025-10-02 13:10:00','2025-10-02 13:10:00','2025-10-02 13:10:00',1,383,'d834f228-8357-4f9f-bbbe-ea16a1c77993',103,'9f85b8f387b146d29eabe946c4fbdee8','volumes_multiattach',1,'2025-10-03 13:10:00',NULL),('2025-10-02 13:10:00','2025-10-02 13:10:00','2025-10-02 13:10:00',1,384,'a1136bdf-7591-4ec7-970f-8e3b2541d690',104,'9f85b8f387b146d29eabe946c4fbdee8','gigabytes_multiattach',1,'2025-10-03 13:10:00',NULL),('2025-10-02 13:11:32','2025-10-02 13:11:32','2025-10-02 13:11:32',1,385,'6eb71d2e-f2b4-4e4e-b4b2-5bd1faa6f7b1',105,'954946ff6b204fba90f767ec67210620','volumes',-1,'2025-10-03 13:11:32',NULL),('2025-10-02 13:11:32','2025-10-02 13:11:32','2025-10-02 13:11:32',1,386,'95792ba7-50e1-460e-94f7-f9919c421f72',106,'954946ff6b204fba90f767ec67210620','gigabytes',-1,'2025-10-03 13:11:32',NULL),('2025-10-02 13:11:32','2025-10-02 13:11:32','2025-10-02 13:11:32',1,387,'12becf87-5105-4c00-882b-5d4bc4c934f9',107,'954946ff6b204fba90f767ec67210620','volumes___DEFAULT__',-1,'2025-10-03 13:11:32',NULL),('2025-10-02 13:11:32','2025-10-02 13:11:32','2025-10-02 13:11:32',1,388,'cb2b02ab-1c83-4840-b496-83abacbfce72',108,'954946ff6b204fba90f767ec67210620','gigabytes___DEFAULT__',-1,'2025-10-03 13:11:32',NULL),('2025-10-02 13:11:36','2025-10-02 13:11:36','2025-10-02 13:11:36',1,389,'8188335d-f221-4f58-9232-4e4e28ae53a1',101,'9f85b8f387b146d29eabe946c4fbdee8','volumes',1,'2025-10-03 13:11:36',NULL),('2025-10-02 13:11:36','2025-10-02 13:11:36','2025-10-02 13:11:36',1,390,'381b6b9e-171e-425d-af80-401056d9c8bd',102,'9f85b8f387b146d29eabe946c4fbdee8','gigabytes',1,'2025-10-03 13:11:36',NULL),('2025-10-02 13:11:36','2025-10-02 13:11:36','2025-10-02 13:11:36',1,391,'231b36f4-94b4-4ac4-9c53-d72d334a11f7',103,'9f85b8f387b146d29eabe946c4fbdee8','volumes_multiattach',1,'2025-10-03 13:11:36',NULL),('2025-10-02 13:11:36','2025-10-02 13:11:36','2025-10-02 13:11:36',1,392,'681d7212-94cf-4f59-a6ab-9be4313598b3',104,'9f85b8f387b146d29eabe946c4fbdee8','gigabytes_multiattach',1,'2025-10-03 13:11:36',NULL),('2025-10-02 13:12:11','2025-10-02 13:12:11','2025-10-02 13:12:11',1,393,'e9e1706b-b63f-401d-88f3-2bfe1011aabf',109,'9f85b8f387b146d29eabe946c4fbdee8','snapshots',1,'2025-10-03 13:12:11',NULL),('2025-10-02 13:12:11','2025-10-02 13:12:11','2025-10-02 13:12:11',1,394,'bd7fc34e-209d-4fe2-83f3-c2f3c6d6a068',102,'9f85b8f387b146d29eabe946c4fbdee8','gigabytes',1,'2025-10-03 13:12:11',NULL),('2025-10-02 13:12:11','2025-10-02 13:12:11','2025-10-02 13:12:11',1,395,'125a9f63-6654-4243-843e-071325d1c974',104,'9f85b8f387b146d29eabe946c4fbdee8','gigabytes_multiattach',1,'2025-10-03 13:12:11',NULL),('2025-10-02 13:12:11','2025-10-02 13:12:11','2025-10-02 13:12:11',1,396,'6048cfc5-9886-412d-97a3-3fb842a4d753',110,'9f85b8f387b146d29eabe946c4fbdee8','snapshots_multiattach',1,'2025-10-03 13:12:11',NULL),('2025-10-02 13:12:21','2025-10-02 13:12:22','2025-10-02 13:12:22',1,397,'960e8b70-78ad-43db-b8b8-e084580641db',109,'9f85b8f387b146d29eabe946c4fbdee8','snapshots',-1,'2025-10-03 13:12:21',NULL),('2025-10-02 13:12:21','2025-10-02 13:12:22','2025-10-02 13:12:22',1,398,'c7a2e5cd-a952-4da3-b910-3217a8805799',102,'9f85b8f387b146d29eabe946c4fbdee8','gigabytes',-1,'2025-10-03 13:12:21',NULL),('2025-10-02 13:12:21','2025-10-02 13:12:22','2025-10-02 13:12:22',1,399,'88c4f6cf-0003-476f-88d0-5c74f9363f5e',104,'9f85b8f387b146d29eabe946c4fbdee8','gigabytes_multiattach',-1,'2025-10-03 13:12:21',NULL),('2025-10-02 13:12:21','2025-10-02 13:12:22','2025-10-02 13:12:22',1,400,'352e55e5-a04c-4491-9177-05cf314d4379',110,'9f85b8f387b146d29eabe946c4fbdee8','snapshots_multiattach',-1,'2025-10-03 13:12:21',NULL),('2025-10-02 13:12:22','2025-10-02 13:12:22','2025-10-02 13:12:22',1,401,'097b08c3-3228-48c6-94f0-1f424a501a13',101,'9f85b8f387b146d29eabe946c4fbdee8','volumes',-1,'2025-10-03 13:12:22',NULL),('2025-10-02 13:12:22','2025-10-02 13:12:22','2025-10-02 13:12:22',1,402,'9e132fdb-1c52-4e55-bbab-ed0590ad4984',102,'9f85b8f387b146d29eabe946c4fbdee8','gigabytes',-1,'2025-10-03 13:12:22',NULL),('2025-10-02 13:12:22','2025-10-02 13:12:22','2025-10-02 13:12:22',1,403,'83664e55-6eab-4fdb-97e9-394e87923098',103,'9f85b8f387b146d29eabe946c4fbdee8','volumes_multiattach',-1,'2025-10-03 13:12:22',NULL),('2025-10-02 13:12:22','2025-10-02 13:12:22','2025-10-02 13:12:22',1,404,'5f5719ed-9bf9-4509-a8ed-aad5e9b1d7ba',104,'9f85b8f387b146d29eabe946c4fbdee8','gigabytes_multiattach',-1,'2025-10-03 13:12:22',NULL),('2025-10-02 13:12:28','2025-10-02 13:12:28','2025-10-02 13:12:28',1,405,'b5407195-9586-4540-b47f-56d2bccf1dba',111,'cbaefa5c700c4ed495a5244732eed7e3','volumes',1,'2025-10-03 13:12:28',NULL),('2025-10-02 13:12:28','2025-10-02 13:12:28','2025-10-02 13:12:28',1,406,'986d990e-151b-4917-b03c-eabe59be9513',112,'cbaefa5c700c4ed495a5244732eed7e3','gigabytes',1,'2025-10-03 13:12:28',NULL),('2025-10-02 13:12:28','2025-10-02 13:12:28','2025-10-02 13:12:28',1,407,'47e5164f-590b-4f46-8c82-945d447f9b1c',113,'cbaefa5c700c4ed495a5244732eed7e3','volumes___DEFAULT__',1,'2025-10-03 13:12:28',NULL),('2025-10-02 13:12:28','2025-10-02 13:12:28','2025-10-02 13:12:28',1,408,'e26457f9-1818-47b6-996d-7cfc98827554',114,'cbaefa5c700c4ed495a5244732eed7e3','gigabytes___DEFAULT__',1,'2025-10-03 13:12:28',NULL),('2025-10-02 13:12:39','2025-10-02 13:12:39','2025-10-02 13:12:39',1,409,'7c17c88c-7932-46dc-9347-daf3060706ae',101,'9f85b8f387b146d29eabe946c4fbdee8','volumes',-1,'2025-10-03 13:12:39',NULL),('2025-10-02 13:12:39','2025-10-02 13:12:39','2025-10-02 13:12:39',1,410,'d0424d15-3796-4f94-b93b-e17b58bfbb45',102,'9f85b8f387b146d29eabe946c4fbdee8','gigabytes',-1,'2025-10-03 13:12:39',NULL),('2025-10-02 13:12:39','2025-10-02 13:12:39','2025-10-02 13:12:39',1,411,'832e0385-8b09-4f76-8b0a-8b637992378b',103,'9f85b8f387b146d29eabe946c4fbdee8','volumes_multiattach',-1,'2025-10-03 13:12:39',NULL),('2025-10-02 13:12:39','2025-10-02 13:12:39','2025-10-02 13:12:39',1,412,'4caca03c-0121-485f-86a8-f774e5455234',104,'9f85b8f387b146d29eabe946c4fbdee8','gigabytes_multiattach',-1,'2025-10-03 13:12:39',NULL),('2025-10-02 13:13:05','2025-10-02 13:13:05','2025-10-02 13:13:05',1,413,'d8e99b9e-94a0-4290-a456-ca96b9f44a92',101,'9f85b8f387b146d29eabe946c4fbdee8','volumes',-1,'2025-10-03 13:13:05',NULL),('2025-10-02 13:13:05','2025-10-02 13:13:05','2025-10-02 13:13:05',1,414,'1d953cb2-92ce-405d-99a1-dfd30576aed6',102,'9f85b8f387b146d29eabe946c4fbdee8','gigabytes',-1,'2025-10-03 13:13:05',NULL),('2025-10-02 13:13:05','2025-10-02 13:13:05','2025-10-02 13:13:05',1,415,'614b1b5a-f66c-4138-9d54-e2c2f7edfa0f',103,'9f85b8f387b146d29eabe946c4fbdee8','volumes_multiattach',-1,'2025-10-03 13:13:05',NULL),('2025-10-02 13:13:05','2025-10-02 13:13:05','2025-10-02 13:13:05',1,416,'b23f2623-d9c3-48bd-9468-3fa4fd0a6b5b',104,'9f85b8f387b146d29eabe946c4fbdee8','gigabytes_multiattach',-1,'2025-10-03 13:13:05',NULL),('2025-10-02 13:13:31','2025-10-02 13:13:31','2025-10-02 13:13:31',1,417,'b43ddd51-7c58-4ffd-b183-45bc932d2d77',101,'9f85b8f387b146d29eabe946c4fbdee8','volumes',-1,'2025-10-03 13:13:31',NULL),('2025-10-02 13:13:31','2025-10-02 13:13:31','2025-10-02 13:13:31',1,418,'4d93436b-fbbe-4a47-a489-aca2c4892a6a',102,'9f85b8f387b146d29eabe946c4fbdee8','gigabytes',-1,'2025-10-03 13:13:31',NULL),('2025-10-02 13:13:31','2025-10-02 13:13:31','2025-10-02 13:13:31',1,419,'ae47b015-57f9-4153-bfa1-0f745395ef3b',103,'9f85b8f387b146d29eabe946c4fbdee8','volumes_multiattach',-1,'2025-10-03 13:13:31',NULL),('2025-10-02 13:13:31','2025-10-02 13:13:31','2025-10-02 13:13:31',1,420,'5c02bd60-052c-4dcc-a94a-4d9c68e68538',104,'9f85b8f387b146d29eabe946c4fbdee8','gigabytes_multiattach',-1,'2025-10-03 13:13:31',NULL),('2025-10-02 13:13:33','2025-10-02 13:13:33','2025-10-02 13:13:33',1,421,'9f5a5ae8-3723-4058-9be3-b0b4b64fdb15',115,'cbaefa5c700c4ed495a5244732eed7e3','snapshots',1,'2025-10-03 13:13:33',NULL),('2025-10-02 13:13:33','2025-10-02 13:13:33','2025-10-02 13:13:33',1,422,'a8303a7e-32de-48fd-a960-b9c6952b4851',112,'cbaefa5c700c4ed495a5244732eed7e3','gigabytes',1,'2025-10-03 13:13:33',NULL),('2025-10-02 13:13:33','2025-10-02 13:13:33','2025-10-02 13:13:33',1,423,'2ea0404d-f8aa-45c5-8e3d-837b81b1bddd',114,'cbaefa5c700c4ed495a5244732eed7e3','gigabytes___DEFAULT__',1,'2025-10-03 13:13:33',NULL),('2025-10-02 13:13:33','2025-10-02 13:13:33','2025-10-02 13:13:33',1,424,'503baacc-b1da-449f-8e91-a66f380d6827',116,'cbaefa5c700c4ed495a5244732eed7e3','snapshots___DEFAULT__',1,'2025-10-03 13:13:33',NULL),('2025-10-02 13:13:43','2025-10-02 13:13:43','2025-10-02 13:13:43',1,425,'a816a63d-595e-457c-a388-bf226322aab2',111,'cbaefa5c700c4ed495a5244732eed7e3','volumes',1,'2025-10-03 13:13:43',NULL),('2025-10-02 13:13:43','2025-10-02 13:13:43','2025-10-02 13:13:43',1,426,'025313ed-ebc7-4398-9ba8-1693d30efe35',112,'cbaefa5c700c4ed495a5244732eed7e3','gigabytes',1,'2025-10-03 13:13:43',NULL),('2025-10-02 13:13:43','2025-10-02 13:13:43','2025-10-02 13:13:43',1,427,'f089784e-2410-4539-981e-51111cac85cf',113,'cbaefa5c700c4ed495a5244732eed7e3','volumes___DEFAULT__',1,'2025-10-03 13:13:43',NULL),('2025-10-02 13:13:43','2025-10-02 13:13:43','2025-10-02 13:13:43',1,428,'c58328e2-92b7-411e-976c-ef98742f81db',114,'cbaefa5c700c4ed495a5244732eed7e3','gigabytes___DEFAULT__',1,'2025-10-03 13:13:43',NULL),('2025-10-02 13:13:48','2025-10-02 13:13:48','2025-10-02 13:13:48',1,429,'426d1a54-0665-40a3-b2b7-6dda81084887',117,'f75652686f7d404a965745c02c9bb8e0','volumes',1,'2025-10-03 13:13:48',NULL),('2025-10-02 13:13:48','2025-10-02 13:13:48','2025-10-02 13:13:48',1,430,'c808287a-29ed-4448-bcb6-4ad709f6f638',118,'f75652686f7d404a965745c02c9bb8e0','gigabytes',1,'2025-10-03 13:13:48',NULL),('2025-10-02 13:13:48','2025-10-02 13:13:48','2025-10-02 13:13:48',1,431,'43872d15-f378-4f32-b04c-ea43b0a21d17',119,'f75652686f7d404a965745c02c9bb8e0','volumes___DEFAULT__',1,'2025-10-03 13:13:48',NULL),('2025-10-02 13:13:48','2025-10-02 13:13:48','2025-10-02 13:13:48',1,432,'8c1d81ef-fa8c-4833-aeed-318f393996d4',120,'f75652686f7d404a965745c02c9bb8e0','gigabytes___DEFAULT__',1,'2025-10-03 13:13:48',NULL),('2025-10-02 13:13:58','2025-10-02 13:13:58','2025-10-02 13:13:58',1,433,'bd62651c-1450-4d42-945e-0640f5eef27f',121,'f75652686f7d404a965745c02c9bb8e0','backups',1,'2025-10-03 13:13:58',NULL),('2025-10-02 13:13:58','2025-10-02 13:13:58','2025-10-02 13:13:58',1,434,'abc0eb71-a860-4c61-83ed-a38044cdc74e',122,'f75652686f7d404a965745c02c9bb8e0','backup_gigabytes',1,'2025-10-03 13:13:58',NULL),('2025-10-02 13:14:06','2025-10-02 13:14:06','2025-10-02 13:14:06',1,435,'67658e65-8f24-4a0f-9991-d9413af1a80c',117,'f75652686f7d404a965745c02c9bb8e0','volumes',1,'2025-10-03 13:14:06',NULL),('2025-10-02 13:14:06','2025-10-02 13:14:06','2025-10-02 13:14:06',1,436,'ffb4ba00-f08f-4949-807f-0c734c6d5f59',118,'f75652686f7d404a965745c02c9bb8e0','gigabytes',1,'2025-10-03 13:14:06',NULL),('2025-10-02 13:14:06','2025-10-02 13:14:06','2025-10-02 13:14:06',1,437,'c87655b7-3ced-487c-8cfe-42ab66dadc42',119,'f75652686f7d404a965745c02c9bb8e0','volumes___DEFAULT__',1,'2025-10-03 13:14:06',NULL),('2025-10-02 13:14:06','2025-10-02 13:14:06','2025-10-02 13:14:06',1,438,'79463d2b-6d90-4e15-9ca7-2ad1fd880cc0',120,'f75652686f7d404a965745c02c9bb8e0','gigabytes___DEFAULT__',1,'2025-10-03 13:14:06',NULL),('2025-10-02 13:14:38','2025-10-02 13:14:38','2025-10-02 13:14:38',1,439,'70a5f6b5-2bcb-4d8a-ba42-464382ae8588',123,'7f5376733aec4630998da8d11db76561','volumes',1,'2025-10-03 13:14:37',NULL),('2025-10-02 13:14:38','2025-10-02 13:14:38','2025-10-02 13:14:38',1,440,'10ea8e7b-1872-4668-9814-6451ecdbc042',124,'7f5376733aec4630998da8d11db76561','gigabytes',1,'2025-10-03 13:14:37',NULL),('2025-10-02 13:14:38','2025-10-02 13:14:38','2025-10-02 13:14:38',1,441,'8be40cb3-387b-4e3e-8266-bae7c089bc02',125,'7f5376733aec4630998da8d11db76561','volumes___DEFAULT__',1,'2025-10-03 13:14:37',NULL),('2025-10-02 13:14:38','2025-10-02 13:14:38','2025-10-02 13:14:38',1,442,'21263645-425e-4d29-9e35-ea51f7e29cf9',126,'7f5376733aec4630998da8d11db76561','gigabytes___DEFAULT__',1,'2025-10-03 13:14:37',NULL),('2025-10-02 13:14:53','2025-10-02 13:14:53','2025-10-02 13:14:53',1,443,'3dee76f5-45b5-4d40-a519-803167e7f324',111,'cbaefa5c700c4ed495a5244732eed7e3','volumes',-1,'2025-10-03 13:14:53',NULL),('2025-10-02 13:14:53','2025-10-02 13:14:53','2025-10-02 13:14:53',1,444,'32ccd71a-cb85-46db-9d4a-26d8dc0df9aa',112,'cbaefa5c700c4ed495a5244732eed7e3','gigabytes',-1,'2025-10-03 13:14:53',NULL),('2025-10-02 13:14:53','2025-10-02 13:14:53','2025-10-02 13:14:53',1,445,'62a0901e-76ff-451f-bc35-807039fd2c0d',113,'cbaefa5c700c4ed495a5244732eed7e3','volumes___DEFAULT__',-1,'2025-10-03 13:14:53',NULL),('2025-10-02 13:14:53','2025-10-02 13:14:53','2025-10-02 13:14:53',1,446,'26a5f835-4736-4862-8afb-8ccd04d8b7d3',114,'cbaefa5c700c4ed495a5244732eed7e3','gigabytes___DEFAULT__',-1,'2025-10-03 13:14:53',NULL),('2025-10-02 13:14:59','2025-10-02 13:14:59','2025-10-02 13:14:59',1,447,'6391ddb2-8409-448c-8c1d-9d5495f7f14f',115,'cbaefa5c700c4ed495a5244732eed7e3','snapshots',-1,'2025-10-03 13:14:59',NULL),('2025-10-02 13:14:59','2025-10-02 13:14:59','2025-10-02 13:14:59',1,448,'9d7f2d73-ab15-4b23-bc5f-2dafdd640701',112,'cbaefa5c700c4ed495a5244732eed7e3','gigabytes',-1,'2025-10-03 13:14:59',NULL),('2025-10-02 13:14:59','2025-10-02 13:14:59','2025-10-02 13:14:59',1,449,'da5f58e0-3ffa-4962-8d6e-23cb460cc3d4',114,'cbaefa5c700c4ed495a5244732eed7e3','gigabytes___DEFAULT__',-1,'2025-10-03 13:14:59',NULL),('2025-10-02 13:14:59','2025-10-02 13:14:59','2025-10-02 13:14:59',1,450,'06dcc7e0-a954-475b-8e9c-d0790edd5281',116,'cbaefa5c700c4ed495a5244732eed7e3','snapshots___DEFAULT__',-1,'2025-10-03 13:14:59',NULL),('2025-10-02 13:15:06','2025-10-02 13:15:06','2025-10-02 13:15:06',1,451,'73f9db0e-dd92-4bd7-a2a0-38ecaac1a6b9',121,'f75652686f7d404a965745c02c9bb8e0','backups',-1,'2025-10-03 13:15:06',NULL),('2025-10-02 13:15:06','2025-10-02 13:15:06','2025-10-02 13:15:06',1,452,'9b2534db-5cbe-47a9-85cc-c85f0c5503a8',122,'f75652686f7d404a965745c02c9bb8e0','backup_gigabytes',-1,'2025-10-03 13:15:06',NULL),('2025-10-02 13:15:06','2025-10-02 13:15:06','2025-10-02 13:15:06',1,453,'9aa55b59-8b05-4dd5-9ff5-bbaaf75daec1',117,'f75652686f7d404a965745c02c9bb8e0','volumes',-1,'2025-10-03 13:15:06',NULL),('2025-10-02 13:15:06','2025-10-02 13:15:06','2025-10-02 13:15:06',1,454,'7b3c4785-49fb-4a02-b86b-e48d361c5277',118,'f75652686f7d404a965745c02c9bb8e0','gigabytes',-1,'2025-10-03 13:15:06',NULL),('2025-10-02 13:15:06','2025-10-02 13:15:06','2025-10-02 13:15:06',1,455,'39e71683-1118-47f7-85e8-cddd1647fe5a',119,'f75652686f7d404a965745c02c9bb8e0','volumes___DEFAULT__',-1,'2025-10-03 13:15:06',NULL),('2025-10-02 13:15:06','2025-10-02 13:15:06','2025-10-02 13:15:06',1,456,'2a7b8604-d1c9-4330-a383-9e66a51a006e',120,'f75652686f7d404a965745c02c9bb8e0','gigabytes___DEFAULT__',-1,'2025-10-03 13:15:06',NULL),('2025-10-02 13:15:06','2025-10-02 13:15:06','2025-10-02 13:15:06',1,457,'446b3a23-9b88-42b3-b3ce-8e8130eb278b',117,'f75652686f7d404a965745c02c9bb8e0','volumes',-1,'2025-10-03 13:15:06',NULL),('2025-10-02 13:15:06','2025-10-02 13:15:06','2025-10-02 13:15:06',1,458,'16df98d2-9194-405c-b61b-83854cb98649',118,'f75652686f7d404a965745c02c9bb8e0','gigabytes',-1,'2025-10-03 13:15:06',NULL),('2025-10-02 13:15:06','2025-10-02 13:15:06','2025-10-02 13:15:06',1,459,'d0e66e11-70e8-46e8-9a87-cb95fa0b46b5',119,'f75652686f7d404a965745c02c9bb8e0','volumes___DEFAULT__',-1,'2025-10-03 13:15:06',NULL),('2025-10-02 13:15:06','2025-10-02 13:15:06','2025-10-02 13:15:06',1,460,'09e9bdcd-ffae-4d14-90a3-440f2666dd29',120,'f75652686f7d404a965745c02c9bb8e0','gigabytes___DEFAULT__',-1,'2025-10-03 13:15:06',NULL),('2025-10-02 13:15:11','2025-10-02 13:15:11','2025-10-02 13:15:11',1,461,'a827ee16-e7d6-4283-a8dc-036b58d95b35',111,'cbaefa5c700c4ed495a5244732eed7e3','volumes',-1,'2025-10-03 13:15:11',NULL),('2025-10-02 13:15:11','2025-10-02 13:15:11','2025-10-02 13:15:11',1,462,'170a490f-7e53-47ea-9a34-651d302dbf22',112,'cbaefa5c700c4ed495a5244732eed7e3','gigabytes',-1,'2025-10-03 13:15:11',NULL),('2025-10-02 13:15:11','2025-10-02 13:15:11','2025-10-02 13:15:11',1,463,'f2ca3c0b-e6c4-4dc2-868a-c56746bc15b8',113,'cbaefa5c700c4ed495a5244732eed7e3','volumes___DEFAULT__',-1,'2025-10-03 13:15:11',NULL),('2025-10-02 13:15:11','2025-10-02 13:15:11','2025-10-02 13:15:11',1,464,'fd1c20cd-6826-44d9-8a74-f8537af8dd05',114,'cbaefa5c700c4ed495a5244732eed7e3','gigabytes___DEFAULT__',-1,'2025-10-03 13:15:11',NULL),('2025-10-02 13:16:13','2025-10-02 13:16:13','2025-10-02 13:16:13',1,465,'b60e252e-c9f7-4886-9eb9-375bd264b9c7',123,'7f5376733aec4630998da8d11db76561','volumes',1,'2025-10-03 13:16:13',NULL),('2025-10-02 13:16:13','2025-10-02 13:16:13','2025-10-02 13:16:13',1,466,'72ec3d51-6a9b-45ee-b90d-493edecb0114',124,'7f5376733aec4630998da8d11db76561','gigabytes',1,'2025-10-03 13:16:13',NULL),('2025-10-02 13:16:13','2025-10-02 13:16:13','2025-10-02 13:16:13',1,467,'1e5ab5ab-aebf-4ac5-a02f-b913ce04dd83',125,'7f5376733aec4630998da8d11db76561','volumes___DEFAULT__',1,'2025-10-03 13:16:13',NULL),('2025-10-02 13:16:13','2025-10-02 13:16:13','2025-10-02 13:16:13',1,468,'c4f395de-20e5-4458-b60c-98fdc9ff529c',126,'7f5376733aec4630998da8d11db76561','gigabytes___DEFAULT__',1,'2025-10-03 13:16:13',NULL),('2025-10-02 13:17:04','2025-10-02 13:17:04','2025-10-02 13:17:04',1,469,'2fdcc26a-8d7b-4849-889f-77c58c313977',123,'7f5376733aec4630998da8d11db76561','volumes',1,'2025-10-03 13:17:04',NULL),('2025-10-02 13:17:04','2025-10-02 13:17:04','2025-10-02 13:17:04',1,470,'f9c44712-af7c-46ef-b629-4a4e1d372534',124,'7f5376733aec4630998da8d11db76561','gigabytes',1,'2025-10-03 13:17:04',NULL),('2025-10-02 13:17:04','2025-10-02 13:17:04','2025-10-02 13:17:04',1,471,'698a0457-1597-4e5b-bcae-615ffa428fc2',125,'7f5376733aec4630998da8d11db76561','volumes___DEFAULT__',1,'2025-10-03 13:17:04',NULL),('2025-10-02 13:17:04','2025-10-02 13:17:04','2025-10-02 13:17:04',1,472,'7a60d96a-d52f-4df1-85fa-629f6fdfdd2a',126,'7f5376733aec4630998da8d11db76561','gigabytes___DEFAULT__',1,'2025-10-03 13:17:04',NULL),('2025-10-02 13:17:18','2025-10-02 13:17:18','2025-10-02 13:17:18',1,473,'8096df27-2b4c-4cc8-85c5-d8144c4d8391',123,'7f5376733aec4630998da8d11db76561','volumes',-1,'2025-10-03 13:17:18',NULL),('2025-10-02 13:17:18','2025-10-02 13:17:18','2025-10-02 13:17:18',1,474,'c68beca1-ffa2-420b-be1a-696609af9089',124,'7f5376733aec4630998da8d11db76561','gigabytes',-1,'2025-10-03 13:17:18',NULL),('2025-10-02 13:17:18','2025-10-02 13:17:18','2025-10-02 13:17:18',1,475,'6f4c21ca-5de7-4033-9d2a-bed38a4f5df4',125,'7f5376733aec4630998da8d11db76561','volumes___DEFAULT__',-1,'2025-10-03 13:17:18',NULL),('2025-10-02 13:17:18','2025-10-02 13:17:18','2025-10-02 13:17:18',1,476,'ef55dd5c-7275-43a0-9f4b-62518e447b6b',126,'7f5376733aec4630998da8d11db76561','gigabytes___DEFAULT__',-1,'2025-10-03 13:17:18',NULL),('2025-10-02 13:17:19','2025-10-02 13:17:19','2025-10-02 13:17:19',1,477,'28c2c26f-35a8-4c58-88e3-a064aec7b1e3',123,'7f5376733aec4630998da8d11db76561','volumes',-1,'2025-10-03 13:17:19',NULL),('2025-10-02 13:17:19','2025-10-02 13:17:19','2025-10-02 13:17:19',1,478,'6db793e8-9044-4fb4-a9d7-0a2cdab92dbe',124,'7f5376733aec4630998da8d11db76561','gigabytes',-1,'2025-10-03 13:17:19',NULL),('2025-10-02 13:17:19','2025-10-02 13:17:19','2025-10-02 13:17:19',1,479,'f4a34169-2860-4a77-9378-7bb8624f39be',125,'7f5376733aec4630998da8d11db76561','volumes___DEFAULT__',-1,'2025-10-03 13:17:19',NULL),('2025-10-02 13:17:19','2025-10-02 13:17:19','2025-10-02 13:17:19',1,480,'378983c9-a07a-4184-9cdd-47733c2dc2f7',126,'7f5376733aec4630998da8d11db76561','gigabytes___DEFAULT__',-1,'2025-10-03 13:17:19',NULL),('2025-10-02 13:17:21','2025-10-02 13:17:21','2025-10-02 13:17:21',1,481,'fb547403-3492-4e24-815b-ef27b07ec537',123,'7f5376733aec4630998da8d11db76561','volumes',-1,'2025-10-03 13:17:21',NULL),('2025-10-02 13:17:21','2025-10-02 13:17:21','2025-10-02 13:17:21',1,482,'9e21c255-1140-4cab-878a-4f70cceae836',124,'7f5376733aec4630998da8d11db76561','gigabytes',-1,'2025-10-03 13:17:21',NULL),('2025-10-02 13:17:21','2025-10-02 13:17:21','2025-10-02 13:17:21',1,483,'ca02af7d-14ef-4190-8962-44dbb5aa3c39',125,'7f5376733aec4630998da8d11db76561','volumes___DEFAULT__',-1,'2025-10-03 13:17:21',NULL),('2025-10-02 13:17:21','2025-10-02 13:17:21','2025-10-02 13:17:21',1,484,'c78d8f69-2c05-469f-bc8b-d34d3fe1f522',126,'7f5376733aec4630998da8d11db76561','gigabytes___DEFAULT__',-1,'2025-10-03 13:17:21',NULL),('2025-10-02 13:17:30','2025-10-02 13:17:30','2025-10-02 13:17:30',1,485,'3d31b965-de1e-41a3-a9a2-08a005c6c7a0',127,'9d6e19e05bf0433a9d26f845522d79b4','volumes',1,'2025-10-03 13:17:30',NULL),('2025-10-02 13:17:30','2025-10-02 13:17:30','2025-10-02 13:17:30',1,486,'5bc32e3f-eeb0-4807-acd4-2ed3a06dc58d',128,'9d6e19e05bf0433a9d26f845522d79b4','gigabytes',1,'2025-10-03 13:17:30',NULL),('2025-10-02 13:17:30','2025-10-02 13:17:30','2025-10-02 13:17:30',1,487,'62f225f3-a8a4-4641-b97c-5f6bf04aaa3d',129,'9d6e19e05bf0433a9d26f845522d79b4','volumes___DEFAULT__',1,'2025-10-03 13:17:30',NULL),('2025-10-02 13:17:30','2025-10-02 13:17:30','2025-10-02 13:17:30',1,488,'f2e3cec6-dafd-433f-95eb-f0bad188e5b4',130,'9d6e19e05bf0433a9d26f845522d79b4','gigabytes___DEFAULT__',1,'2025-10-03 13:17:30',NULL),('2025-10-02 13:17:31','2025-10-02 13:17:32','2025-10-02 13:17:32',1,489,'4208ad08-6eda-465c-b466-ffd1318938c8',131,'9d6e19e05bf0433a9d26f845522d79b4','snapshots',1,'2025-10-03 13:17:31',NULL),('2025-10-02 13:17:31','2025-10-02 13:17:32','2025-10-02 13:17:32',1,490,'1854ba90-c3b9-48ff-b95d-27071b381895',128,'9d6e19e05bf0433a9d26f845522d79b4','gigabytes',1,'2025-10-03 13:17:31',NULL),('2025-10-02 13:17:31','2025-10-02 13:17:32','2025-10-02 13:17:32',1,491,'2fdad3d3-3b16-4901-83dd-239701ced1f8',130,'9d6e19e05bf0433a9d26f845522d79b4','gigabytes___DEFAULT__',1,'2025-10-03 13:17:31',NULL),('2025-10-02 13:17:32','2025-10-02 13:17:32','2025-10-02 13:17:32',1,492,'cc4bc2c9-b381-432a-8ff2-b158fe261f38',132,'9d6e19e05bf0433a9d26f845522d79b4','snapshots___DEFAULT__',1,'2025-10-03 13:17:31',NULL),('2025-10-02 13:17:34','2025-10-02 13:17:34','2025-10-02 13:17:34',1,493,'99f88983-44ed-42a3-a508-4232b07712e5',131,'9d6e19e05bf0433a9d26f845522d79b4','snapshots',-1,'2025-10-03 13:17:34',NULL),('2025-10-02 13:17:34','2025-10-02 13:17:34','2025-10-02 13:17:34',1,494,'0833d38b-c079-41b4-9ce9-9898f688bb5b',128,'9d6e19e05bf0433a9d26f845522d79b4','gigabytes',-1,'2025-10-03 13:17:34',NULL),('2025-10-02 13:17:34','2025-10-02 13:17:34','2025-10-02 13:17:34',1,495,'036ac523-9142-4ab8-9977-f6ba5cb4c089',130,'9d6e19e05bf0433a9d26f845522d79b4','gigabytes___DEFAULT__',-1,'2025-10-03 13:17:34',NULL),('2025-10-02 13:17:34','2025-10-02 13:17:34','2025-10-02 13:17:34',1,496,'4b5d77b2-3f25-4358-96c5-1b6d79c592a4',132,'9d6e19e05bf0433a9d26f845522d79b4','snapshots___DEFAULT__',-1,'2025-10-03 13:17:34',NULL),('2025-10-02 13:17:36','2025-10-02 13:17:36','2025-10-02 13:17:36',1,497,'8c873815-777e-4a87-bde9-be1be3492f05',127,'9d6e19e05bf0433a9d26f845522d79b4','volumes',-1,'2025-10-03 13:17:35',NULL),('2025-10-02 13:17:36','2025-10-02 13:17:36','2025-10-02 13:17:36',1,498,'b7ecb365-33b5-44e9-affb-46691474c802',128,'9d6e19e05bf0433a9d26f845522d79b4','gigabytes',-1,'2025-10-03 13:17:35',NULL),('2025-10-02 13:17:36','2025-10-02 13:17:36','2025-10-02 13:17:36',1,499,'422b783d-71db-4ea1-bc71-1747f683bc5a',129,'9d6e19e05bf0433a9d26f845522d79b4','volumes___DEFAULT__',-1,'2025-10-03 13:17:35',NULL),('2025-10-02 13:17:36','2025-10-02 13:17:36','2025-10-02 13:17:36',1,500,'d3b566e2-13b4-45ee-a988-f1ca434839ad',130,'9d6e19e05bf0433a9d26f845522d79b4','gigabytes___DEFAULT__',-1,'2025-10-03 13:17:35',NULL),('2025-10-02 13:18:19','2025-10-02 13:18:19','2025-10-02 13:18:19',1,501,'f785e895-9186-44d9-9747-78aa7410fb2e',133,'ced4d30c525c44cca617c3b9838d21b7','volumes',1,'2025-10-03 13:18:19',NULL),('2025-10-02 13:18:19','2025-10-02 13:18:19','2025-10-02 13:18:19',1,502,'79f68e9a-0d77-4e5c-94a2-9dae6e686c19',134,'ced4d30c525c44cca617c3b9838d21b7','gigabytes',1,'2025-10-03 13:18:19',NULL),('2025-10-02 13:18:19','2025-10-02 13:18:19','2025-10-02 13:18:19',1,503,'0cb069fb-f6c3-44fd-a206-bcd0ba31aa38',135,'ced4d30c525c44cca617c3b9838d21b7','volumes___DEFAULT__',1,'2025-10-03 13:18:19',NULL),('2025-10-02 13:18:19','2025-10-02 13:18:19','2025-10-02 13:18:19',1,504,'9b124e37-3006-4c41-84a9-977dcfa8b8b3',136,'ced4d30c525c44cca617c3b9838d21b7','gigabytes___DEFAULT__',1,'2025-10-03 13:18:19',NULL),('2025-10-02 13:18:24','2025-10-02 13:18:24','2025-10-02 13:18:24',1,505,'21c31e59-7fa0-4ab5-a1a1-15dccb87383d',137,'ced4d30c525c44cca617c3b9838d21b7','snapshots',1,'2025-10-03 13:18:24',NULL),('2025-10-02 13:18:24','2025-10-02 13:18:24','2025-10-02 13:18:24',1,506,'291c31a5-d98c-4e11-b86a-f3dbb324753c',134,'ced4d30c525c44cca617c3b9838d21b7','gigabytes',1,'2025-10-03 13:18:24',NULL),('2025-10-02 13:18:24','2025-10-02 13:18:24','2025-10-02 13:18:24',1,507,'865008b5-b4ff-4577-8fee-a8327981e0ca',136,'ced4d30c525c44cca617c3b9838d21b7','gigabytes___DEFAULT__',1,'2025-10-03 13:18:24',NULL),('2025-10-02 13:18:24','2025-10-02 13:18:24','2025-10-02 13:18:24',1,508,'420fec45-0e65-491f-9aa6-fc23caec9cc8',138,'ced4d30c525c44cca617c3b9838d21b7','snapshots___DEFAULT__',1,'2025-10-03 13:18:24',NULL),('2025-10-02 13:18:43','2025-10-02 13:18:43','2025-10-02 13:18:43',1,509,'e9263a84-560e-4601-bd68-27bb31447cb9',137,'ced4d30c525c44cca617c3b9838d21b7','snapshots',-1,'2025-10-03 13:18:43',NULL),('2025-10-02 13:18:43','2025-10-02 13:18:43','2025-10-02 13:18:43',1,510,'49782118-d182-46b9-9809-8d73b326aafb',134,'ced4d30c525c44cca617c3b9838d21b7','gigabytes',-1,'2025-10-03 13:18:43',NULL),('2025-10-02 13:18:43','2025-10-02 13:18:43','2025-10-02 13:18:43',1,511,'c328e758-dbcb-4344-9cc9-83eec8d82a58',136,'ced4d30c525c44cca617c3b9838d21b7','gigabytes___DEFAULT__',-1,'2025-10-03 13:18:43',NULL),('2025-10-02 13:18:43','2025-10-02 13:18:43','2025-10-02 13:18:43',1,512,'305a8cef-a7df-4dde-ab7e-43318f47d1fe',138,'ced4d30c525c44cca617c3b9838d21b7','snapshots___DEFAULT__',-1,'2025-10-03 13:18:43',NULL),('2025-10-02 13:19:24','2025-10-02 13:19:24','2025-10-02 13:19:24',1,513,'db9164f8-1e86-461e-9658-d040ddeefefa',133,'ced4d30c525c44cca617c3b9838d21b7','volumes',-1,'2025-10-03 13:19:24',NULL),('2025-10-02 13:19:24','2025-10-02 13:19:24','2025-10-02 13:19:24',1,514,'2b1deed1-8a56-45af-a87b-903c9e796b4c',134,'ced4d30c525c44cca617c3b9838d21b7','gigabytes',-1,'2025-10-03 13:19:24',NULL),('2025-10-02 13:19:24','2025-10-02 13:19:24','2025-10-02 13:19:24',1,515,'c9f9afe1-8695-4675-8e58-83d41f1ba54f',135,'ced4d30c525c44cca617c3b9838d21b7','volumes___DEFAULT__',-1,'2025-10-03 13:19:24',NULL),('2025-10-02 13:19:24','2025-10-02 13:19:24','2025-10-02 13:19:24',1,516,'b4800403-04a7-43ed-bba4-21d4a6ca8416',136,'ced4d30c525c44cca617c3b9838d21b7','gigabytes___DEFAULT__',-1,'2025-10-03 13:19:24',NULL),('2025-10-02 13:19:58','2025-10-02 13:19:58','2025-10-02 13:19:58',1,517,'fa225f03-0c89-4219-be89-2f099d185d4a',133,'ced4d30c525c44cca617c3b9838d21b7','volumes',1,'2025-10-03 13:19:58',NULL),('2025-10-02 13:19:58','2025-10-02 13:19:58','2025-10-02 13:19:58',1,518,'c74428a2-6050-47a9-8db0-0e9d6fe0289b',134,'ced4d30c525c44cca617c3b9838d21b7','gigabytes',1,'2025-10-03 13:19:58',NULL),('2025-10-02 13:19:58','2025-10-02 13:19:58','2025-10-02 13:19:58',1,519,'38c3434e-444e-4841-bca8-863df677cfd9',135,'ced4d30c525c44cca617c3b9838d21b7','volumes___DEFAULT__',1,'2025-10-03 13:19:58',NULL),('2025-10-02 13:19:58','2025-10-02 13:19:58','2025-10-02 13:19:58',1,520,'ef43ef4a-0dcf-47c8-a283-042e9f901898',136,'ced4d30c525c44cca617c3b9838d21b7','gigabytes___DEFAULT__',1,'2025-10-03 13:19:58',NULL),('2025-10-02 13:21:12','2025-10-02 13:21:12','2025-10-02 13:21:12',1,521,'aea5c444-8ae5-4b7c-84ff-92c5359a6efd',133,'ced4d30c525c44cca617c3b9838d21b7','volumes',-1,'2025-10-03 13:21:12',NULL),('2025-10-02 13:21:12','2025-10-02 13:21:12','2025-10-02 13:21:12',1,522,'3dc8efc0-6785-4a7e-8192-a2024f45f221',134,'ced4d30c525c44cca617c3b9838d21b7','gigabytes',-1,'2025-10-03 13:21:12',NULL),('2025-10-02 13:21:12','2025-10-02 13:21:12','2025-10-02 13:21:12',1,523,'6c30b6d4-7072-4a4c-a325-a0847e714532',135,'ced4d30c525c44cca617c3b9838d21b7','volumes___DEFAULT__',-1,'2025-10-03 13:21:12',NULL),('2025-10-02 13:21:12','2025-10-02 13:21:12','2025-10-02 13:21:12',1,524,'32d9d1cf-8afb-4537-be2c-c9f881d90fc8',136,'ced4d30c525c44cca617c3b9838d21b7','gigabytes___DEFAULT__',-1,'2025-10-03 13:21:12',NULL),('2025-10-02 13:26:06','2025-10-02 13:26:06','2025-10-02 13:26:06',1,525,'d9e23fcd-13b5-4558-a64f-5d60dab8712b',139,'18799a1c93354809911705bb424e673f','volumes',1,'2025-10-03 13:26:06',NULL),('2025-10-02 13:26:06','2025-10-02 13:26:06','2025-10-02 13:26:06',1,526,'a9eb99ac-14fe-4b6b-ae76-3942cf03bbb8',140,'18799a1c93354809911705bb424e673f','gigabytes',1,'2025-10-03 13:26:06',NULL),('2025-10-02 13:26:06','2025-10-02 13:26:06','2025-10-02 13:26:06',1,527,'aff130fa-c877-4378-a31a-590ab73f0033',141,'18799a1c93354809911705bb424e673f','volumes_tempest-scenario-type-luks-703155325',1,'2025-10-03 13:26:06',NULL),('2025-10-02 13:26:06','2025-10-02 13:26:06','2025-10-02 13:26:06',1,528,'b1bd8ffa-430b-43a4-8fb3-c93400289736',142,'18799a1c93354809911705bb424e673f','gigabytes_tempest-scenario-type-luks-703155325',1,'2025-10-03 13:26:06',NULL),('2025-10-02 13:26:37','2025-10-02 13:26:37','2025-10-02 13:26:37',1,529,'c70945ae-de2d-4ce3-94dc-b9e915ee5ffd',139,'18799a1c93354809911705bb424e673f','volumes',-1,'2025-10-03 13:26:37',NULL),('2025-10-02 13:26:37','2025-10-02 13:26:37','2025-10-02 13:26:37',1,530,'a79e2e13-ce6f-4b30-bd80-399769db868f',140,'18799a1c93354809911705bb424e673f','gigabytes',-1,'2025-10-03 13:26:37',NULL),('2025-10-02 13:26:37','2025-10-02 13:26:37','2025-10-02 13:26:37',1,531,'5ad3e91b-6ee9-483f-83c7-3fe188278c7f',141,'18799a1c93354809911705bb424e673f','volumes_tempest-scenario-type-luks-703155325',-1,'2025-10-03 13:26:37',NULL),('2025-10-02 13:26:37','2025-10-02 13:26:37','2025-10-02 13:26:37',1,532,'cf588a1b-46ec-4565-8d27-52aa79aca2c4',142,'18799a1c93354809911705bb424e673f','gigabytes_tempest-scenario-type-luks-703155325',-1,'2025-10-03 13:26:37',NULL),('2025-10-02 13:26:39','2025-10-02 13:26:39','2025-10-02 13:26:39',1,533,'958bb9fc-a811-4c2c-b289-d8364b873431',139,'18799a1c93354809911705bb424e673f','volumes',1,'2025-10-03 13:26:39',NULL),('2025-10-02 13:26:39','2025-10-02 13:26:39','2025-10-02 13:26:39',1,534,'ab65d7c0-0788-4a63-8632-772981ce5973',140,'18799a1c93354809911705bb424e673f','gigabytes',1,'2025-10-03 13:26:39',NULL),('2025-10-02 13:26:39','2025-10-02 13:26:39','2025-10-02 13:26:39',1,535,'f4002d4a-a147-4b41-8ebe-ed451a45583e',143,'18799a1c93354809911705bb424e673f','volumes___DEFAULT__',1,'2025-10-03 13:26:39',NULL),('2025-10-02 13:26:39','2025-10-02 13:26:39','2025-10-02 13:26:39',1,536,'99c1063c-9ea8-4e82-a25a-d0023f073779',144,'18799a1c93354809911705bb424e673f','gigabytes___DEFAULT__',1,'2025-10-03 13:26:39',NULL),('2025-10-02 13:26:49','2025-10-02 13:26:49','2025-10-02 13:26:49',1,537,'912eeed6-9605-4b40-ad1e-595c2a843e56',145,'18799a1c93354809911705bb424e673f','snapshots',1,'2025-10-03 13:26:49',NULL),('2025-10-02 13:26:49','2025-10-02 13:26:49','2025-10-02 13:26:49',1,538,'1380b12d-7825-4dd1-92d6-45c7e4010d3c',140,'18799a1c93354809911705bb424e673f','gigabytes',1,'2025-10-03 13:26:49',NULL),('2025-10-02 13:26:49','2025-10-02 13:26:49','2025-10-02 13:26:49',1,539,'417ff632-dc52-42d6-8aed-08914e1dac84',144,'18799a1c93354809911705bb424e673f','gigabytes___DEFAULT__',1,'2025-10-03 13:26:49',NULL),('2025-10-02 13:26:49','2025-10-02 13:26:49','2025-10-02 13:26:49',1,540,'d8acd34b-0836-4f29-9c96-3112c0786b47',146,'18799a1c93354809911705bb424e673f','snapshots___DEFAULT__',1,'2025-10-03 13:26:49',NULL),('2025-10-02 13:26:57','2025-10-02 13:26:57','2025-10-02 13:26:57',1,541,'332092b0-75bd-41e7-9fb9-a61e3707ae3f',139,'18799a1c93354809911705bb424e673f','volumes',1,'2025-10-03 13:26:57',NULL),('2025-10-02 13:26:57','2025-10-02 13:26:57','2025-10-02 13:26:57',1,542,'b21d037e-92ae-4c2d-8f93-b8490bcc3aa0',140,'18799a1c93354809911705bb424e673f','gigabytes',1,'2025-10-03 13:26:57',NULL),('2025-10-02 13:26:57','2025-10-02 13:26:57','2025-10-02 13:26:57',1,543,'45320f12-2aa8-4abb-9fa7-775d4f9a00f1',143,'18799a1c93354809911705bb424e673f','volumes___DEFAULT__',1,'2025-10-03 13:26:57',NULL),('2025-10-02 13:26:57','2025-10-02 13:26:57','2025-10-02 13:26:57',1,544,'bdde8c67-9532-415e-835d-ba1c6a4968a6',144,'18799a1c93354809911705bb424e673f','gigabytes___DEFAULT__',1,'2025-10-03 13:26:57',NULL),('2025-10-02 13:27:10','2025-10-02 13:27:10','2025-10-02 13:27:10',1,545,'e058d26c-8f83-403e-964d-e7f0404b4d54',139,'18799a1c93354809911705bb424e673f','volumes',-1,'2025-10-03 13:27:10',NULL),('2025-10-02 13:27:10','2025-10-02 13:27:10','2025-10-02 13:27:10',1,546,'b1037268-e57f-4300-b36e-f94620154bec',140,'18799a1c93354809911705bb424e673f','gigabytes',-1,'2025-10-03 13:27:10',NULL),('2025-10-02 13:27:10','2025-10-02 13:27:10','2025-10-02 13:27:10',1,547,'9a1a91fe-120d-405a-a793-e0ee9d2f3c66',143,'18799a1c93354809911705bb424e673f','volumes___DEFAULT__',-1,'2025-10-03 13:27:10',NULL),('2025-10-02 13:27:10','2025-10-02 13:27:10','2025-10-02 13:27:10',1,548,'f62ad21a-4dfc-4b47-9e22-80437e1a3948',144,'18799a1c93354809911705bb424e673f','gigabytes___DEFAULT__',-1,'2025-10-03 13:27:10',NULL),('2025-10-02 13:27:12','2025-10-02 13:27:12','2025-10-02 13:27:12',1,549,'eb20ad1e-a85f-49be-a333-f6ddf404a617',145,'18799a1c93354809911705bb424e673f','snapshots',-1,'2025-10-03 13:27:12',NULL),('2025-10-02 13:27:12','2025-10-02 13:27:12','2025-10-02 13:27:12',1,550,'de7579a7-08f3-41a8-aa76-562ec99fff78',140,'18799a1c93354809911705bb424e673f','gigabytes',-1,'2025-10-03 13:27:12',NULL),('2025-10-02 13:27:12','2025-10-02 13:27:12','2025-10-02 13:27:12',1,551,'a2d4e82a-ee2e-45bf-9254-33b2653b0400',144,'18799a1c93354809911705bb424e673f','gigabytes___DEFAULT__',-1,'2025-10-03 13:27:12',NULL),('2025-10-02 13:27:12','2025-10-02 13:27:12','2025-10-02 13:27:12',1,552,'1ea9ec88-bf49-49fa-bb2a-20ca3b1d02ed',146,'18799a1c93354809911705bb424e673f','snapshots___DEFAULT__',-1,'2025-10-03 13:27:12',NULL),('2025-10-02 13:27:14','2025-10-02 13:27:14','2025-10-02 13:27:14',1,553,'75adc4c4-471c-469f-9867-df275c587844',139,'18799a1c93354809911705bb424e673f','volumes',-1,'2025-10-03 13:27:14',NULL),('2025-10-02 13:27:14','2025-10-02 13:27:14','2025-10-02 13:27:14',1,554,'6cde00bd-6d3a-4b41-b300-23c07e831a5a',140,'18799a1c93354809911705bb424e673f','gigabytes',-1,'2025-10-03 13:27:14',NULL),('2025-10-02 13:27:14','2025-10-02 13:27:14','2025-10-02 13:27:14',1,555,'ec47aee1-f5df-4d03-aef6-ee23e058036e',143,'18799a1c93354809911705bb424e673f','volumes___DEFAULT__',-1,'2025-10-03 13:27:14',NULL),('2025-10-02 13:27:14','2025-10-02 13:27:14','2025-10-02 13:27:14',1,556,'5a5b8ff0-21a5-4549-bd09-345238c05f35',144,'18799a1c93354809911705bb424e673f','gigabytes___DEFAULT__',-1,'2025-10-03 13:27:14',NULL),('2025-10-02 13:27:17','2025-10-02 13:27:17','2025-10-02 13:27:17',1,557,'c4d56f60-ea60-4e19-aa88-8ff55ca6d17b',139,'18799a1c93354809911705bb424e673f','volumes',1,'2025-10-03 13:27:17',NULL),('2025-10-02 13:27:17','2025-10-02 13:27:17','2025-10-02 13:27:17',1,558,'5990e89b-8c3e-4ce8-bbac-513385908d93',140,'18799a1c93354809911705bb424e673f','gigabytes',1,'2025-10-03 13:27:17',NULL),('2025-10-02 13:27:17','2025-10-02 13:27:17','2025-10-02 13:27:17',1,559,'96555e3b-ec04-40c4-b6be-ce2c9fad3b15',143,'18799a1c93354809911705bb424e673f','volumes___DEFAULT__',1,'2025-10-03 13:27:17',NULL),('2025-10-02 13:27:17','2025-10-02 13:27:17','2025-10-02 13:27:17',1,560,'edb2c2d7-b5af-48a3-87b8-12d5d860709d',144,'18799a1c93354809911705bb424e673f','gigabytes___DEFAULT__',1,'2025-10-03 13:27:17',NULL),('2025-10-02 13:28:13','2025-10-02 13:28:13','2025-10-02 13:28:13',1,561,'19cc5ba5-1ed9-4f16-882b-a15fb84e1df8',145,'18799a1c93354809911705bb424e673f','snapshots',1,'2025-10-03 13:28:13',NULL),('2025-10-02 13:28:13','2025-10-02 13:28:13','2025-10-02 13:28:13',1,562,'a245694d-9000-4653-a6e1-9357c93cba41',140,'18799a1c93354809911705bb424e673f','gigabytes',1,'2025-10-03 13:28:13',NULL),('2025-10-02 13:28:13','2025-10-02 13:28:13','2025-10-02 13:28:13',1,563,'9e0204fe-92b2-433f-8550-0b57f9da92c7',144,'18799a1c93354809911705bb424e673f','gigabytes___DEFAULT__',1,'2025-10-03 13:28:13',NULL),('2025-10-02 13:28:13','2025-10-02 13:28:13','2025-10-02 13:28:13',1,564,'065a4a2d-777b-4aa0-ba61-0e2ff1df46b3',146,'18799a1c93354809911705bb424e673f','snapshots___DEFAULT__',1,'2025-10-03 13:28:13',NULL),('2025-10-02 13:28:24','2025-10-02 13:28:24','2025-10-02 13:28:24',1,565,'16596ec9-d741-4077-ab49-49a94eae2df8',139,'18799a1c93354809911705bb424e673f','volumes',1,'2025-10-03 13:28:24',NULL),('2025-10-02 13:28:24','2025-10-02 13:28:24','2025-10-02 13:28:24',1,566,'9e418926-1cf0-467e-9ac9-91ce09e33d55',140,'18799a1c93354809911705bb424e673f','gigabytes',1,'2025-10-03 13:28:24',NULL),('2025-10-02 13:28:24','2025-10-02 13:28:24','2025-10-02 13:28:24',1,567,'a91d936b-9ee3-4a45-9b66-d561de77c6f3',143,'18799a1c93354809911705bb424e673f','volumes___DEFAULT__',1,'2025-10-03 13:28:24',NULL),('2025-10-02 13:28:24','2025-10-02 13:28:24','2025-10-02 13:28:24',1,568,'4fec6698-441e-47e3-abde-d56f7bbe309c',144,'18799a1c93354809911705bb424e673f','gigabytes___DEFAULT__',1,'2025-10-03 13:28:24',NULL),('2025-10-02 13:29:17','2025-10-02 13:29:17','2025-10-02 13:29:17',1,569,'ab681ff6-dba0-4ee3-a22d-56c2c66bec22',139,'18799a1c93354809911705bb424e673f','volumes',-1,'2025-10-03 13:29:17',NULL),('2025-10-02 13:29:17','2025-10-02 13:29:17','2025-10-02 13:29:17',1,570,'18ec77a4-074d-4495-8f1d-d6e6729fad3b',140,'18799a1c93354809911705bb424e673f','gigabytes',-1,'2025-10-03 13:29:17',NULL),('2025-10-02 13:29:17','2025-10-02 13:29:17','2025-10-02 13:29:17',1,571,'0685c442-a442-42e5-b99f-9ec089192dc5',143,'18799a1c93354809911705bb424e673f','volumes___DEFAULT__',-1,'2025-10-03 13:29:17',NULL),('2025-10-02 13:29:17','2025-10-02 13:29:17','2025-10-02 13:29:17',1,572,'1d258f3e-57ba-4ed4-b2ad-086b77ed0e49',144,'18799a1c93354809911705bb424e673f','gigabytes___DEFAULT__',-1,'2025-10-03 13:29:17',NULL),('2025-10-02 13:29:22','2025-10-02 13:29:22','2025-10-02 13:29:22',1,573,'94d60476-daaf-4b58-804c-b655b2bf8e7f',145,'18799a1c93354809911705bb424e673f','snapshots',-1,'2025-10-03 13:29:22',NULL),('2025-10-02 13:29:22','2025-10-02 13:29:22','2025-10-02 13:29:22',1,574,'115ca747-81cb-452f-a15d-99e26bf2bc40',140,'18799a1c93354809911705bb424e673f','gigabytes',-1,'2025-10-03 13:29:22',NULL),('2025-10-02 13:29:22','2025-10-02 13:29:22','2025-10-02 13:29:22',1,575,'73bbdbf8-7e8f-456a-9608-0f0bc684a7b4',144,'18799a1c93354809911705bb424e673f','gigabytes___DEFAULT__',-1,'2025-10-03 13:29:22',NULL),('2025-10-02 13:29:22','2025-10-02 13:29:22','2025-10-02 13:29:22',1,576,'aaaaebef-d065-426f-88ed-6055df881494',146,'18799a1c93354809911705bb424e673f','snapshots___DEFAULT__',-1,'2025-10-03 13:29:22',NULL),('2025-10-02 13:29:35','2025-10-02 13:29:35','2025-10-02 13:29:35',1,577,'c0333f7f-0614-43c8-8563-f72fc4897778',139,'18799a1c93354809911705bb424e673f','volumes',-1,'2025-10-03 13:29:35',NULL),('2025-10-02 13:29:35','2025-10-02 13:29:35','2025-10-02 13:29:35',1,578,'4b8fde8e-2e64-4879-9434-10c497ed4b8a',140,'18799a1c93354809911705bb424e673f','gigabytes',-1,'2025-10-03 13:29:35',NULL),('2025-10-02 13:29:35','2025-10-02 13:29:35','2025-10-02 13:29:35',1,579,'73edd1dd-6a88-4851-b66c-e8c249522f5e',143,'18799a1c93354809911705bb424e673f','volumes___DEFAULT__',-1,'2025-10-03 13:29:35',NULL),('2025-10-02 13:29:35','2025-10-02 13:29:35','2025-10-02 13:29:35',1,580,'75e50502-a0b1-4ba8-b968-7d9f16de233d',144,'18799a1c93354809911705bb424e673f','gigabytes___DEFAULT__',-1,'2025-10-03 13:29:35',NULL),('2025-10-02 13:29:53','2025-10-02 13:29:53','2025-10-02 13:29:53',1,581,'0f1153d5-79cc-4c43-a73d-c68d52ff95fe',139,'18799a1c93354809911705bb424e673f','volumes',1,'2025-10-03 13:29:53',NULL),('2025-10-02 13:29:53','2025-10-02 13:29:53','2025-10-02 13:29:53',1,582,'36799f82-67b6-44ad-a199-fcacf82ac1e8',140,'18799a1c93354809911705bb424e673f','gigabytes',1,'2025-10-03 13:29:53',NULL),('2025-10-02 13:29:53','2025-10-02 13:29:53','2025-10-02 13:29:53',1,583,'c67efc20-c4b3-4f78-ae0f-410889bd61f9',143,'18799a1c93354809911705bb424e673f','volumes___DEFAULT__',1,'2025-10-03 13:29:53',NULL),('2025-10-02 13:29:53','2025-10-02 13:29:53','2025-10-02 13:29:53',1,584,'390a2509-5504-477e-b4d6-b0199e91489d',144,'18799a1c93354809911705bb424e673f','gigabytes___DEFAULT__',1,'2025-10-03 13:29:53',NULL),('2025-10-02 13:31:27','2025-10-02 13:31:27','2025-10-02 13:31:27',1,585,'5950c882-1656-4acb-953c-818dd1f572eb',145,'18799a1c93354809911705bb424e673f','snapshots',1,'2025-10-03 13:31:27',NULL),('2025-10-02 13:31:27','2025-10-02 13:31:27','2025-10-02 13:31:27',1,586,'7766c4c5-79b8-41c9-b1a5-0d5538da9b0e',140,'18799a1c93354809911705bb424e673f','gigabytes',1,'2025-10-03 13:31:27',NULL),('2025-10-02 13:31:27','2025-10-02 13:31:27','2025-10-02 13:31:27',1,587,'ac604fcf-2838-443b-8c4d-ddb6f72e5cc2',144,'18799a1c93354809911705bb424e673f','gigabytes___DEFAULT__',1,'2025-10-03 13:31:27',NULL),('2025-10-02 13:31:27','2025-10-02 13:31:27','2025-10-02 13:31:27',1,588,'afc4e6d4-caf9-4c5f-8c4a-b8685078b66c',146,'18799a1c93354809911705bb424e673f','snapshots___DEFAULT__',1,'2025-10-03 13:31:27',NULL),('2025-10-02 13:31:29','2025-10-02 13:31:29','2025-10-02 13:31:29',1,589,'26319bbc-c515-48f5-b6c8-a6075c273b59',139,'18799a1c93354809911705bb424e673f','volumes',1,'2025-10-03 13:31:29',NULL),('2025-10-02 13:31:29','2025-10-02 13:31:29','2025-10-02 13:31:29',1,590,'da4158f9-7a5b-4026-914a-d7a8961ec6c4',140,'18799a1c93354809911705bb424e673f','gigabytes',1,'2025-10-03 13:31:29',NULL),('2025-10-02 13:31:29','2025-10-02 13:31:29','2025-10-02 13:31:29',1,591,'2f6e51fc-4bae-412d-9ced-c202125926ce',143,'18799a1c93354809911705bb424e673f','volumes___DEFAULT__',1,'2025-10-03 13:31:29',NULL),('2025-10-02 13:31:29','2025-10-02 13:31:29','2025-10-02 13:31:29',1,592,'c9b3c3e7-edb7-4335-9d17-be0ed0731423',144,'18799a1c93354809911705bb424e673f','gigabytes___DEFAULT__',1,'2025-10-03 13:31:29',NULL),('2025-10-02 13:32:23','2025-10-02 13:32:23','2025-10-02 13:32:23',1,593,'1047c2e7-1d4f-4ee8-91d7-54612292bce9',139,'18799a1c93354809911705bb424e673f','volumes',-1,'2025-10-03 13:32:23',NULL),('2025-10-02 13:32:23','2025-10-02 13:32:23','2025-10-02 13:32:23',1,594,'8d474473-9e0a-4f14-ad1e-071b96014765',140,'18799a1c93354809911705bb424e673f','gigabytes',-1,'2025-10-03 13:32:23',NULL),('2025-10-02 13:32:23','2025-10-02 13:32:23','2025-10-02 13:32:23',1,595,'ebf83f9a-d641-416e-ae46-2ad7cf9f0a9a',143,'18799a1c93354809911705bb424e673f','volumes___DEFAULT__',-1,'2025-10-03 13:32:23',NULL),('2025-10-02 13:32:23','2025-10-02 13:32:23','2025-10-02 13:32:23',1,596,'5a63b266-7a7d-49d9-8129-3330448a85ba',144,'18799a1c93354809911705bb424e673f','gigabytes___DEFAULT__',-1,'2025-10-03 13:32:23',NULL),('2025-10-02 13:32:25','2025-10-02 13:32:25','2025-10-02 13:32:25',1,597,'ad269738-e359-4305-ba28-9f1f0851f374',145,'18799a1c93354809911705bb424e673f','snapshots',-1,'2025-10-03 13:32:25',NULL),('2025-10-02 13:32:25','2025-10-02 13:32:25','2025-10-02 13:32:25',1,598,'ba58f707-7a85-4c0a-bd1a-53efae4ae5e9',140,'18799a1c93354809911705bb424e673f','gigabytes',-1,'2025-10-03 13:32:25',NULL),('2025-10-02 13:32:25','2025-10-02 13:32:25','2025-10-02 13:32:25',1,599,'b52bebbb-3235-48f0-9444-de7af8f496e5',144,'18799a1c93354809911705bb424e673f','gigabytes___DEFAULT__',-1,'2025-10-03 13:32:25',NULL),('2025-10-02 13:32:25','2025-10-02 13:32:25','2025-10-02 13:32:25',1,600,'b8de825d-adca-460d-809d-876d93d141f5',146,'18799a1c93354809911705bb424e673f','snapshots___DEFAULT__',-1,'2025-10-03 13:32:25',NULL),('2025-10-02 13:32:35','2025-10-02 13:32:35','2025-10-02 13:32:35',1,601,'cdafca80-bcd4-4a89-a770-8cc51b8eeb0a',139,'18799a1c93354809911705bb424e673f','volumes',-1,'2025-10-03 13:32:35',NULL),('2025-10-02 13:32:35','2025-10-02 13:32:35','2025-10-02 13:32:35',1,602,'3a10a1e6-a424-42d1-9bc3-a05ba0151442',140,'18799a1c93354809911705bb424e673f','gigabytes',-1,'2025-10-03 13:32:35',NULL),('2025-10-02 13:32:35','2025-10-02 13:32:35','2025-10-02 13:32:35',1,603,'6a1105bc-fc24-4d6c-a5eb-da63adc4e0ac',143,'18799a1c93354809911705bb424e673f','volumes___DEFAULT__',-1,'2025-10-03 13:32:35',NULL),('2025-10-02 13:32:35','2025-10-02 13:32:35','2025-10-02 13:32:35',1,604,'3dcb8917-2465-4ec2-91e5-225b345aa202',144,'18799a1c93354809911705bb424e673f','gigabytes___DEFAULT__',-1,'2025-10-03 13:32:35',NULL);
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `rpc_current_version` varchar(36) DEFAULT NULL,
  `object_current_version` varchar(36) DEFAULT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `frozen` tinyint(1) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `services_uuid_idx` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone`, `disabled_reason`, `modified_at`, `rpc_current_version`, `object_current_version`, `replication_status`, `frozen`, `active_backend_id`, `cluster_name`, `uuid`) VALUES ('2025-10-02 11:30:12','2025-10-02 13:51:49',NULL,0,1,'cinder-scheduler-0','cinder-scheduler','cinder-scheduler',845,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'f2dd8109-7243-40d3-8d3b-5c8d9e431e59'),('2025-10-02 12:05:58','2025-10-02 13:51:50',NULL,0,2,'cinder-backup-0','cinder-backup','cinder-backup',635,0,'nova',NULL,NULL,'2.4','1.39','not-capable',0,NULL,NULL,'654b82a9-8339-438d-944e-f80f4b22ec35'),('2025-10-02 12:05:58','2025-10-02 13:51:52',NULL,0,3,'hostgroup@ceph','cinder-volume','cinder-volume',635,0,'nova',NULL,NULL,'3.18','1.39','disabled',0,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot_metadata`
--

DROP TABLE IF EXISTS `snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshot_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `snapshot_metadata_ibfk_1` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot_metadata`
--

LOCK TABLES `snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `snapshot_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshots`
--

DROP TABLE IF EXISTS `snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `volume_size` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `provider_auth` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshots_cgsnapshot_id` (`cgsnapshot_id`),
  KEY `ix_snapshots_volume_id` (`volume_id`),
  KEY `ix_snapshots_group_snapshot_id` (`group_snapshot_id`),
  KEY `snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `snapshots_ibfk_1` FOREIGN KEY (`cgsnapshot_id`) REFERENCES `cgsnapshots` (`id`),
  CONSTRAINT `snapshots_ibfk_2` FOREIGN KEY (`group_snapshot_id`) REFERENCES `group_snapshots` (`id`),
  CONSTRAINT `snapshots_volume_id_fkey` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshots`
--

LOCK TABLES `snapshots` WRITE;
/*!40000 ALTER TABLE `snapshots` DISABLE KEYS */;
INSERT INTO `snapshots` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `status`, `progress`, `volume_size`, `scheduled_at`, `display_name`, `display_description`, `provider_location`, `encryption_key_id`, `volume_type_id`, `cgsnapshot_id`, `provider_id`, `provider_auth`, `group_snapshot_id`, `use_quota`) VALUES ('2025-10-02 13:31:27','2025-10-02 13:32:23','2025-10-02 13:32:25',1,'5ac72b12-8cbc-4ea2-b384-7b18311bda08','c345d50c-19ab-4a23-a4a8-f7c734528d26','2cb47684d0b34c729e9611e7b3943bed','18799a1c93354809911705bb424e673f','deleted','100%',1,NULL,'tempest-TestVolumeBootPattern-snapshot-322205610',NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,NULL,NULL,NULL,1),('2025-10-02 13:18:24','2025-10-02 13:18:42','2025-10-02 13:18:43',1,'842beb83-5e62-4ba2-b7f7-8732f7c9f405','b43f69f8-7c8d-4ef5-af90-c5aa5656977e','74f5186fabfb4fea86d32c8ef1f2e354','ced4d30c525c44cca617c3b9838d21b7','deleted','100%',1,NULL,'tempest-TestMinimumBasicScenario-snapshot-1618479945',NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,NULL,NULL,NULL,1),('2025-10-02 13:26:49','2025-10-02 13:27:11','2025-10-02 13:27:12',1,'9ae89550-43b8-4753-be7a-188d37df60ee','8c46a235-cbac-44eb-b1b6-0f232670dbd3','2cb47684d0b34c729e9611e7b3943bed','18799a1c93354809911705bb424e673f','deleted','100%',1,NULL,'tempest-TestVolumeBootPattern-snapshot-82895809',NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,NULL,NULL,NULL,1),('2025-10-02 13:28:13','2025-10-02 13:29:17','2025-10-02 13:29:22',1,'b50be4d5-612a-4434-8eb6-55d27bed7a4d','ffd00fca-313e-46cc-b503-d377c1529a56','2cb47684d0b34c729e9611e7b3943bed','18799a1c93354809911705bb424e673f','deleted','100%',1,NULL,'snapshot for tempest-TestVolumeBootPatternsnapshot-566470057',NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,NULL,NULL,NULL,1),('2025-10-02 13:17:32','2025-10-02 13:17:33','2025-10-02 13:17:34',1,'cd389899-79e7-47d9-ae8b-a1b97768b881','344c67a5-2b4e-4bc2-9ae2-4634e1a7646e','e3774ac023a94d05b47d4d7871236a37','9d6e19e05bf0433a9d26f845522d79b4','deleted','100%',1,NULL,'tempest-VolumesSnapshotsTestJSON-Snapshot-1817666992',NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,NULL,NULL,NULL,1),('2025-10-02 13:12:11','2025-10-02 13:12:20','2025-10-02 13:12:22',1,'dff6adf7-64dd-40b8-b0c2-8bd3f4e563c0','19b06699-b688-462a-890e-57ac19f2d9e6','156cc6022c70402ab6d194a340b076d5','9f85b8f387b146d29eabe946c4fbdee8','deleted','100%',1,NULL,'snapshot for multiattach-snapshot',NULL,NULL,NULL,'5e6146ac-1671-44a7-8fce-42cadebadfea',NULL,NULL,NULL,NULL,1),('2025-10-02 13:13:33','2025-10-02 13:14:57','2025-10-02 13:14:59',1,'f043ab4d-d32c-42e5-bd46-8b477284e706','d96c5d9f-6560-48dd-8bf0-55b9a4da462b','81db307ac1f846188ce19b644ebcc396','cbaefa5c700c4ed495a5244732eed7e3','deleted','100%',1,NULL,'tempest-TestStampPattern-snapshot-1872895315',NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,NULL,NULL,NULL,1);
/*!40000 ALTER TABLE `snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `no_snapshots` tinyint(1) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_transfers_volume_id` (`volume_id`),
  CONSTRAINT `transfers_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_admin_metadata`
--

DROP TABLE IF EXISTS `volume_admin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_admin_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_admin_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_admin_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_admin_metadata`
--

LOCK TABLES `volume_admin_metadata` WRITE;
/*!40000 ALTER TABLE `volume_admin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_admin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_attachment`
--

DROP TABLE IF EXISTS `volume_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_attachment` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `attached_host` varchar(255) DEFAULT NULL,
  `instance_uuid` varchar(36) DEFAULT NULL,
  `mountpoint` varchar(255) DEFAULT NULL,
  `attach_time` datetime DEFAULT NULL,
  `detach_time` datetime DEFAULT NULL,
  `attach_mode` varchar(36) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `connection_info` text DEFAULT NULL,
  `connector` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_attachment_volume_id` (`volume_id`),
  CONSTRAINT `volume_attachment_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_attachment`
--

LOCK TABLES `volume_attachment` WRITE;
/*!40000 ALTER TABLE `volume_attachment` DISABLE KEYS */;
INSERT INTO `volume_attachment` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `attached_host`, `instance_uuid`, `mountpoint`, `attach_time`, `detach_time`, `attach_mode`, `attach_status`, `connection_info`, `connector`) VALUES ('2025-10-02 12:43:33','2025-10-02 12:44:15','2025-10-02 12:44:15',1,'01c1187a-4578-4575-a086-d9c200afe7f4','fdc5e1d9-2228-4ec0-a6bb-8605f6207831','compute-1.ctlplane.example.com','173830cb-12bb-4e1a-ba80-088da01ad107','/dev/vda','2025-10-02 12:43:37','2025-10-02 12:44:15','rw','detached','{\"name\": \"volumes/volume-fdc5e1d9-2228-4ec0-a6bb-8605f6207831\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"fdc5e1d9-2228-4ec0-a6bb-8605f6207831\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"01c1187a-4578-4575-a086-d9c200afe7f4\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d783e47ecf\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"5d5cabb1-2c53-462b-89f3-16d4280c3e4c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:48:04','2025-10-02 12:48:42','2025-10-02 12:48:42',1,'04cb9bff-78f6-41d7-bf08-73f086d3a288','59930c46-79e6-4eb5-b8a0-3382452117c0','compute-1.ctlplane.example.com','4b2aefbb-92cb-4a24-9ad2-884a12fa514c','/dev/vdb','2025-10-02 12:48:07','2025-10-02 12:48:42','rw','detached','{\"name\": \"volumes/volume-59930c46-79e6-4eb5-b8a0-3382452117c0\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"59930c46-79e6-4eb5-b8a0-3382452117c0\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"04cb9bff-78f6-41d7-bf08-73f086d3a288\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d783e47ecf\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"5d5cabb1-2c53-462b-89f3-16d4280c3e4c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 13:03:15','2025-10-02 13:03:23','2025-10-02 13:03:23',1,'08cb844c-29a1-4f83-81ac-285a7ccb50f3','4318daa3-7890-4295-9085-fac3e8976380','compute-0.ctlplane.example.com','b6d31622-c503-4790-b277-89de495fb364','/dev/vdb','2025-10-02 13:03:17','2025-10-02 13:03:23','rw','detached','{\"name\": \"volumes/volume-4318daa3-7890-4295-9085-fac3e8976380\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"4318daa3-7890-4295-9085-fac3e8976380\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": true, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"08cb844c-29a1-4f83-81ac-285a7ccb50f3\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b6d21f9028d8\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a1e3318-b91c-48d1-8474-e3593dbdcd45\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 13:10:04','2025-10-02 13:10:55','2025-10-02 13:10:55',1,'090235a9-9281-4043-bb90-ab5bad31a26e','8347daf9-f32f-4c50-b89e-df9e913044db','compute-1.ctlplane.example.com','de995ad8-07bb-4097-899b-5c79d62a1f4c','/dev/vdb','2025-10-02 13:10:06','2025-10-02 13:10:55','rw','detached','{\"name\": \"volumes/volume-8347daf9-f32f-4c50-b89e-df9e913044db\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"8347daf9-f32f-4c50-b89e-df9e913044db\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"090235a9-9281-4043-bb90-ab5bad31a26e\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d783e47ecf\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"5d5cabb1-2c53-462b-89f3-16d4280c3e4c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:49:04','2025-10-02 12:49:38','2025-10-02 12:49:38',1,'0a7a6ccd-e966-42ab-95a4-d4a03bcdd5e3','9a0d7849-aa2a-475d-a21d-0d4dd0da6ab2','compute-0.ctlplane.example.com','2755e56a-ea2b-43ad-8bae-29eb7fc0ed60','/dev/vdc','2025-10-02 12:49:05','2025-10-02 12:49:38','rw','detached','{\"name\": \"volumes/volume-9a0d7849-aa2a-475d-a21d-0d4dd0da6ab2\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"9a0d7849-aa2a-475d-a21d-0d4dd0da6ab2\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"0a7a6ccd-e966-42ab-95a4-d4a03bcdd5e3\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b6d21f9028d8\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a1e3318-b91c-48d1-8474-e3593dbdcd45\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-10-02 13:11:57','2025-10-02 13:12:18','2025-10-02 13:12:18',1,'0d0e9cb5-44a1-4c98-87a9-040f5b2c2dc4','19b06699-b688-462a-890e-57ac19f2d9e6','compute-0.ctlplane.example.com','59697a8e-b10c-4ae7-a721-478fb1551925','/dev/vda','2025-10-02 13:12:01','2025-10-02 13:12:18','rw','detached','{\"name\": \"volumes/volume-19b06699-b688-462a-890e-57ac19f2d9e6\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"19b06699-b688-462a-890e-57ac19f2d9e6\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"0d0e9cb5-44a1-4c98-87a9-040f5b2c2dc4\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b6d21f9028d8\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a1e3318-b91c-48d1-8474-e3593dbdcd45\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:25:14','2025-10-02 12:25:42','2025-10-02 12:25:42',1,'0db9806a-63f9-40d6-af04-ea6e4c8861fc','5957fb80-298a-4379-a0ba-fde86e2113d0','compute-2.ctlplane.example.com','b3d45275-f66f-4629-896b-8fe3fceb65a3','/dev/vdb','2025-10-02 12:25:16','2025-10-02 12:25:42','rw','detached','{\"name\": \"volumes/volume-5957fb80-298a-4379-a0ba-fde86e2113d0\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"5957fb80-298a-4379-a0ba-fde86e2113d0\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"0db9806a-63f9-40d6-af04-ea6e4c8861fc\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d79ae5a31735\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"91df6c8e-6fe2-49d2-9991-360b14608f11\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:24:31','2025-10-02 12:24:35','2025-10-02 12:24:35',1,'12eb22e2-2245-49e3-8bc1-c1f37d8f4f7a','f9d9b67b-54c7-4f6f-b70f-7ca98b415001','compute-2.ctlplane.example.com','321c53a8-3488-43dc-b742-27102b6a5016','/dev/sdc','2025-10-02 12:24:32','2025-10-02 12:24:35','rw','detached','{\"name\": \"volumes/volume-f9d9b67b-54c7-4f6f-b70f-7ca98b415001\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"f9d9b67b-54c7-4f6f-b70f-7ca98b415001\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"12eb22e2-2245-49e3-8bc1-c1f37d8f4f7a\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d79ae5a31735\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"91df6c8e-6fe2-49d2-9991-360b14608f11\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/sdc\"}'),('2025-10-02 12:51:07','2025-10-02 12:52:04','2025-10-02 12:52:04',1,'1860ab7f-c635-4488-b2d3-849571b3b102','a7bdd212-0d34-40b8-9af9-06388d215028','compute-1.ctlplane.example.com','33780b49-b5a1-4f3f-a6c5-a00011d53718','/dev/vda','2025-10-02 12:51:16','2025-10-02 12:52:04','rw','detached','{\"name\": \"volumes/volume-a7bdd212-0d34-40b8-9af9-06388d215028\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"a7bdd212-0d34-40b8-9af9-06388d215028\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"1860ab7f-c635-4488-b2d3-849571b3b102\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d783e47ecf\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"5d5cabb1-2c53-462b-89f3-16d4280c3e4c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:33:37','2025-10-02 12:33:43','2025-10-02 12:33:43',1,'1aeb09c5-d42f-4238-8e6e-d89f3a69b10a','c9770430-1295-4cf9-8ead-017246f69f0a','compute-0.ctlplane.example.com','6c768447-ca45-42c7-aee4-09dfe7406a2d','/dev/vdb','2025-10-02 12:33:39','2025-10-02 12:33:43','rw','detached','{\"name\": \"volumes/volume-c9770430-1295-4cf9-8ead-017246f69f0a\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"c9770430-1295-4cf9-8ead-017246f69f0a\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"1aeb09c5-d42f-4238-8e6e-d89f3a69b10a\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b6d21f9028d8\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a1e3318-b91c-48d1-8474-e3593dbdcd45\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 13:10:34','2025-10-02 13:11:30','2025-10-02 13:11:30',1,'1c69fd61-d690-4888-9608-6cf9793b48cc','23ece991-964a-4523-b231-9590440c3d93','compute-0.ctlplane.example.com','79964143-e208-4552-8380-513c3adf09ac','/dev/vda','2025-10-02 13:10:38','2025-10-02 13:11:30','rw','detached','{\"name\": \"volumes/volume-23ece991-964a-4523-b231-9590440c3d93\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"23ece991-964a-4523-b231-9590440c3d93\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"1c69fd61-d690-4888-9608-6cf9793b48cc\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b6d21f9028d8\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a1e3318-b91c-48d1-8474-e3593dbdcd45\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:17:50','2025-10-02 12:18:09','2025-10-02 12:18:09',1,'206c2936-1c28-49f2-9d66-fc7f6ab756d8','20a19061-0239-43b4-b9d7-980e7acde072','compute-2.ctlplane.example.com','ecee1ec0-1a8d-4d67-b996-205a942120ae','/dev/vda','2025-10-02 12:17:51','2025-10-02 12:18:09','null','detached','{\"name\": \"volumes/volume-20a19061-0239-43b4-b9d7-980e7acde072\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"20a19061-0239-43b4-b9d7-980e7acde072\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"206c2936-1c28-49f2-9d66-fc7f6ab756d8\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d79ae5a31735\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"91df6c8e-6fe2-49d2-9991-360b14608f11\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2025-10-02 12:50:02','2025-10-02 12:51:08','2025-10-02 12:51:08',1,'215e435c-8279-4bbc-bbb1-8c2a849c9afe','a7bdd212-0d34-40b8-9af9-06388d215028','compute-1.ctlplane.example.com','33780b49-b5a1-4f3f-a6c5-a00011d53718','/dev/vda','2025-10-02 12:50:09','2025-10-02 12:51:08','rw','detached','{\"name\": \"volumes/volume-a7bdd212-0d34-40b8-9af9-06388d215028\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"a7bdd212-0d34-40b8-9af9-06388d215028\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"215e435c-8279-4bbc-bbb1-8c2a849c9afe\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d783e47ecf\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"5d5cabb1-2c53-462b-89f3-16d4280c3e4c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:42:15','2025-10-02 12:42:37','2025-10-02 12:42:37',1,'21d085da-e46b-4e90-bddb-ca7351a2dfe5','13e98bdf-a59c-4cec-a1d4-6b0f09d31497','compute-0.ctlplane.example.com','0cda84d2-b983-447e-b9ef-6888fdeb2df5','/dev/vdb','2025-10-02 12:42:19','2025-10-02 12:42:37','rw','detached','{\"name\": \"volumes/volume-13e98bdf-a59c-4cec-a1d4-6b0f09d31497\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"13e98bdf-a59c-4cec-a1d4-6b0f09d31497\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"21d085da-e46b-4e90-bddb-ca7351a2dfe5\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b6d21f9028d8\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a1e3318-b91c-48d1-8474-e3593dbdcd45\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:25:20','2025-10-02 12:25:38','2025-10-02 12:25:38',1,'220f75d1-7597-411c-a311-ebd7f4b718f8','5957fb80-298a-4379-a0ba-fde86e2113d0','compute-1.ctlplane.example.com','12ae9024-48e3-4894-ac32-41af4e31c223','/dev/vdb','2025-10-02 12:25:22','2025-10-02 12:25:38','rw','detached','{\"name\": \"volumes/volume-5957fb80-298a-4379-a0ba-fde86e2113d0\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"5957fb80-298a-4379-a0ba-fde86e2113d0\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"220f75d1-7597-411c-a311-ebd7f4b718f8\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d783e47ecf\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"5d5cabb1-2c53-462b-89f3-16d4280c3e4c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:49:43','2025-10-02 12:50:01','2025-10-02 12:50:01',1,'224833de-8155-4c7a-9ea1-ae45f41d1ad3','ac1432a4-bab5-43b6-871c-71608985c7ae','compute-0.ctlplane.example.com','74af08e5-d1ea-478b-ace8-00363679ec4d','/dev/vdb','2025-10-02 12:49:45','2025-10-02 12:50:01','rw','detached','{\"name\": \"volumes/volume-ac1432a4-bab5-43b6-871c-71608985c7ae\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"ac1432a4-bab5-43b6-871c-71608985c7ae\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"224833de-8155-4c7a-9ea1-ae45f41d1ad3\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b6d21f9028d8\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a1e3318-b91c-48d1-8474-e3593dbdcd45\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:14:15','2025-10-02 12:14:51','2025-10-02 12:14:51',1,'22dff84c-2800-4a44-8b74-72aa222f3126','ff92c1da-c1e7-425c-b20d-f332daad4188','compute-1.ctlplane.example.com','b8f8f97e-2823-451c-ab36-7f94ade8be46','/dev/vda','2025-10-02 12:14:22','2025-10-02 12:14:51','rw','detached','{\"name\": \"volumes/volume-ff92c1da-c1e7-425c-b20d-f332daad4188\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"ff92c1da-c1e7-425c-b20d-f332daad4188\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"22dff84c-2800-4a44-8b74-72aa222f3126\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d783e47ecf\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"5d5cabb1-2c53-462b-89f3-16d4280c3e4c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 13:01:17','2025-10-02 13:01:32','2025-10-02 13:01:32',1,'22f3ad43-f6f6-494a-af76-5a8dc92a2077','b91353e7-057c-43fc-be40-fbbc07072322','compute-0.ctlplane.example.com','c7bfcc3e-6b4f-469a-b8cb-4084dcffdf44','/dev/vdb','2025-10-02 13:01:19','2025-10-02 13:01:32','rw','detached','{\"name\": \"volumes/volume-b91353e7-057c-43fc-be40-fbbc07072322\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"b91353e7-057c-43fc-be40-fbbc07072322\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"22f3ad43-f6f6-494a-af76-5a8dc92a2077\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b6d21f9028d8\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a1e3318-b91c-48d1-8474-e3593dbdcd45\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 13:10:55','2025-10-02 13:11:33','2025-10-02 13:11:33',1,'2f0a1f52-338f-461a-ba0a-e3bd32637ff8','8347daf9-f32f-4c50-b89e-df9e913044db','compute-0.ctlplane.example.com','de995ad8-07bb-4097-899b-5c79d62a1f4c','/dev/vdb','2025-10-02 13:11:02','2025-10-02 13:11:33','rw','detached','{\"name\": \"volumes/volume-8347daf9-f32f-4c50-b89e-df9e913044db\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"8347daf9-f32f-4c50-b89e-df9e913044db\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"2f0a1f52-338f-461a-ba0a-e3bd32637ff8\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b6d21f9028d8\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a1e3318-b91c-48d1-8474-e3593dbdcd45\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:59:10','2025-10-02 13:00:01','2025-10-02 13:00:01',1,'31bd947d-5e0a-4d4c-8968-c44c2406b07f','73427f9e-6c2e-43a3-a2f1-b8df606e61c3','compute-2.ctlplane.example.com','3ae8ab55-a114-4284-9d2d-e70ba073cb66','/dev/vdb','2025-10-02 12:59:13','2025-10-02 13:00:01','rw','detached','{\"name\": \"volumes/volume-73427f9e-6c2e-43a3-a2f1-b8df606e61c3\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"73427f9e-6c2e-43a3-a2f1-b8df606e61c3\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"31bd947d-5e0a-4d4c-8968-c44c2406b07f\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d79ae5a31735\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"91df6c8e-6fe2-49d2-9991-360b14608f11\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 13:30:05','2025-10-02 13:30:47','2025-10-02 13:30:47',1,'35d5caec-046e-4321-a915-26dc0ab0740a','c345d50c-19ab-4a23-a4a8-f7c734528d26','compute-2.ctlplane.example.com','61df455a-66c4-4f77-86c9-edad9954045d','/dev/vda','2025-10-02 13:30:12','2025-10-02 13:30:47','rw','detached','{\"name\": \"volumes/volume-c345d50c-19ab-4a23-a4a8-f7c734528d26\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"c345d50c-19ab-4a23-a4a8-f7c734528d26\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"35d5caec-046e-4321-a915-26dc0ab0740a\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d79ae5a31735\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"91df6c8e-6fe2-49d2-9991-360b14608f11\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 13:20:01','2025-10-02 13:21:11','2025-10-02 13:21:11',1,'36d0d5ec-018e-4c04-a804-bceb43745029','501f7163-061f-4829-9c05-ac69ebd0ace5','compute-1.ctlplane.example.com','92ef7ede-4ed2-4a81-9849-bbc39c0be573','/dev/vdb','2025-10-02 13:20:02','2025-10-02 13:21:11','rw','detached','{\"name\": \"volumes/volume-501f7163-061f-4829-9c05-ac69ebd0ace5\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"501f7163-061f-4829-9c05-ac69ebd0ace5\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"36d0d5ec-018e-4c04-a804-bceb43745029\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d783e47ecf\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"5d5cabb1-2c53-462b-89f3-16d4280c3e4c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:54:07','2025-10-02 12:57:43','2025-10-02 12:57:43',1,'370ada91-e18a-4022-9d41-8c5758765ce2','f80c06cb-0550-4a66-a7bd-bba5ed3d622f','compute-2.ctlplane.example.com','58e2a72f-a2b9-41a0-9c67-607e978d8b88','/dev/vda','2025-10-02 12:54:08','2025-10-02 12:57:43','rw','detached','{\"name\": \"volumes/volume-f80c06cb-0550-4a66-a7bd-bba5ed3d622f\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"f80c06cb-0550-4a66-a7bd-bba5ed3d622f\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"370ada91-e18a-4022-9d41-8c5758765ce2\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d79ae5a31735\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"91df6c8e-6fe2-49d2-9991-360b14608f11\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:42:50','2025-10-02 12:43:00','2025-10-02 12:43:00',1,'39f71c1c-2f92-451b-8d2c-d3fca7d63b21','542f01f7-7f03-41d9-ba07-cf427bf3007f','compute-0.ctlplane.example.com','1e02b9cd-d03a-4fd7-bece-d6aac4461748','/dev/vdb','2025-10-02 12:42:51','2025-10-02 12:43:00','rw','detached','{\"name\": \"volumes/volume-542f01f7-7f03-41d9-ba07-cf427bf3007f\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"542f01f7-7f03-41d9-ba07-cf427bf3007f\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"39f71c1c-2f92-451b-8d2c-d3fca7d63b21\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b6d21f9028d8\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a1e3318-b91c-48d1-8474-e3593dbdcd45\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 13:10:16','2025-10-02 13:11:31','2025-10-02 13:11:31',1,'49bf8921-a668-4225-ab0f-aecfaf369881','8347daf9-f32f-4c50-b89e-df9e913044db','compute-2.ctlplane.example.com','469a928f-d7cb-4add-9410-629caac3f6f8','/dev/vdb','2025-10-02 13:10:20','2025-10-02 13:11:31','rw','detached','{\"name\": \"volumes/volume-8347daf9-f32f-4c50-b89e-df9e913044db\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"8347daf9-f32f-4c50-b89e-df9e913044db\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"49bf8921-a668-4225-ab0f-aecfaf369881\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d79ae5a31735\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"91df6c8e-6fe2-49d2-9991-360b14608f11\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 13:28:27','2025-10-02 13:29:15','2025-10-02 13:29:15',1,'4f9bf0c2-6ea0-491d-b924-500ff3decac0','4f5d24ac-9e35-4d38-a9e7-6dec734d8ef8','compute-1.ctlplane.example.com','4fe12372-ed4b-40ab-9cf2-dcf304f21c31','/dev/vda','2025-10-02 13:28:29','2025-10-02 13:29:15','rw','detached','{\"name\": \"volumes/volume-4f5d24ac-9e35-4d38-a9e7-6dec734d8ef8\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"4f5d24ac-9e35-4d38-a9e7-6dec734d8ef8\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"4f9bf0c2-6ea0-491d-b924-500ff3decac0\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d783e47ecf\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"5d5cabb1-2c53-462b-89f3-16d4280c3e4c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 13:14:32','2025-10-02 13:14:38','2025-10-02 13:14:38',1,'509bf0b6-9f7f-4f97-a294-b13da3245f0f','426f9568-783a-4516-9da0-22cf58dd8632','compute-2.ctlplane.example.com','f2511cad-2f04-468f-99b3-f7302be124b8','/dev/vdb','2025-10-02 13:14:34','2025-10-02 13:14:38','rw','detached','{\"name\": \"volumes/volume-426f9568-783a-4516-9da0-22cf58dd8632\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"426f9568-783a-4516-9da0-22cf58dd8632\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"509bf0b6-9f7f-4f97-a294-b13da3245f0f\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d79ae5a31735\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"91df6c8e-6fe2-49d2-9991-360b14608f11\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 13:17:05','2025-10-02 13:17:09','2025-10-02 13:17:09',1,'539e91b3-9c50-4c72-af75-a7fd852145f8','60bad5ae-8a46-4e2e-abef-fbab46d4d0c9','compute-2.ctlplane.example.com','af020c32-e373-4276-a7f7-9cef906e2887','/dev/vdb','2025-10-02 13:17:06','2025-10-02 13:17:09','rw','detached','{\"name\": \"volumes/volume-60bad5ae-8a46-4e2e-abef-fbab46d4d0c9\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"60bad5ae-8a46-4e2e-abef-fbab46d4d0c9\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"539e91b3-9c50-4c72-af75-a7fd852145f8\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d79ae5a31735\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"91df6c8e-6fe2-49d2-9991-360b14608f11\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:22:02','2025-10-02 12:23:48','2025-10-02 12:23:48',1,'54598788-e706-49d2-9e91-e968eea915b1','f3584061-a34e-4c55-a201-ea9e5f60b3e5','compute-1.ctlplane.example.com','bebdf690-5f58-4227-95e0-add2eae14645','/dev/vdc','2025-10-02 12:22:12','2025-10-02 12:23:48','rw','detached','{\"name\": \"volumes/volume-f3584061-a34e-4c55-a201-ea9e5f60b3e5\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"f3584061-a34e-4c55-a201-ea9e5f60b3e5\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"54598788-e706-49d2-9e91-e968eea915b1\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d783e47ecf\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"5d5cabb1-2c53-462b-89f3-16d4280c3e4c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-10-02 12:56:43','2025-10-02 12:57:30','2025-10-02 12:57:30',1,'5581d109-be2f-4a04-92e4-999ae5749856','93f6251c-1119-43b6-b608-e405dc9beae8','compute-2.ctlplane.example.com','1a43d1f5-b1b2-488a-8660-f964ee219489','/dev/vda','2025-10-02 12:56:44','2025-10-02 12:57:30','rw','detached','{\"name\": \"volumes/volume-93f6251c-1119-43b6-b608-e405dc9beae8\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"93f6251c-1119-43b6-b608-e405dc9beae8\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"5581d109-be2f-4a04-92e4-999ae5749856\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d79ae5a31735\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"91df6c8e-6fe2-49d2-9991-360b14608f11\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:49:00','2025-10-02 12:49:33','2025-10-02 12:49:33',1,'57eccb80-4840-4673-8a59-e009e44cd558','b6b70d12-1f08-4fe5-adac-6ced9b30e04f','compute-0.ctlplane.example.com','2755e56a-ea2b-43ad-8bae-29eb7fc0ed60','/dev/vdb','2025-10-02 12:49:01','2025-10-02 12:49:33','rw','detached','{\"name\": \"volumes/volume-b6b70d12-1f08-4fe5-adac-6ced9b30e04f\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"b6b70d12-1f08-4fe5-adac-6ced9b30e04f\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"57eccb80-4840-4673-8a59-e009e44cd558\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b6d21f9028d8\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a1e3318-b91c-48d1-8474-e3593dbdcd45\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:26:01','2025-10-02 12:28:05','2025-10-02 12:28:05',1,'5bc54f85-aaa5-4214-877f-7aa78ebc1f3e','3cae6300-aa08-440b-8899-aaa48fab86bd','compute-2.ctlplane.example.com','776370c1-1213-4676-b85e-ce1c0491afc6','/dev/vdc','2025-10-02 12:26:13','2025-10-02 12:28:05','rw','detached','{\"name\": \"volumes/volume-3cae6300-aa08-440b-8899-aaa48fab86bd\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"3cae6300-aa08-440b-8899-aaa48fab86bd\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"5bc54f85-aaa5-4214-877f-7aa78ebc1f3e\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d79ae5a31735\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"91df6c8e-6fe2-49d2-9991-360b14608f11\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-10-02 13:01:24','2025-10-02 13:01:35','2025-10-02 13:01:35',1,'5c7368fc-feda-4e5b-bc50-cdc9391a7a63','04f00d16-4d54-4085-a9eb-bc69d5b5e61c','compute-0.ctlplane.example.com','c7bfcc3e-6b4f-469a-b8cb-4084dcffdf44','/dev/vdc','2025-10-02 13:01:27','2025-10-02 13:01:35','rw','detached','{\"name\": \"volumes/volume-04f00d16-4d54-4085-a9eb-bc69d5b5e61c\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"04f00d16-4d54-4085-a9eb-bc69d5b5e61c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"5c7368fc-feda-4e5b-bc50-cdc9391a7a63\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b6d21f9028d8\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a1e3318-b91c-48d1-8474-e3593dbdcd45\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-10-02 12:49:53','2025-10-02 12:50:25','2025-10-02 12:50:25',1,'5fd89014-a8a9-427e-ba08-f0b8efc311f1','77e42bdf-1989-460b-aa47-82eb53d89208','compute-1.ctlplane.example.com','3b348c58-f179-41db-bd79-1fdea0ade389','/dev/vdc','2025-10-02 12:49:55','2025-10-02 12:50:25','rw','detached','{\"name\": \"volumes/volume-77e42bdf-1989-460b-aa47-82eb53d89208\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"77e42bdf-1989-460b-aa47-82eb53d89208\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"5fd89014-a8a9-427e-ba08-f0b8efc311f1\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d783e47ecf\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"5d5cabb1-2c53-462b-89f3-16d4280c3e4c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-10-02 13:14:40','2025-10-02 13:15:28','2025-10-02 13:15:28',1,'63eeceae-5e4a-4e89-b426-2b83a872ab02','205d78a9-2344-4c93-8e1b-54d92d0b0fa2','compute-1.ctlplane.example.com','3dbb48be-2da9-48eb-814a-94eac9968d0f','/dev/vdb','2025-10-02 13:14:41','2025-10-02 13:15:28','rw','detached','{\"name\": \"volumes/volume-205d78a9-2344-4c93-8e1b-54d92d0b0fa2\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"205d78a9-2344-4c93-8e1b-54d92d0b0fa2\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"63eeceae-5e4a-4e89-b426-2b83a872ab02\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d783e47ecf\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"5d5cabb1-2c53-462b-89f3-16d4280c3e4c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 13:09:17','2025-10-02 13:09:24','2025-10-02 13:09:24',1,'646f9755-18df-4630-8f00-f869a77fc0ce','2341c515-f8fa-4cdf-87e9-1faa534d8307','compute-2.ctlplane.example.com','f07a4381-2291-4a58-a2ca-b04071e65a0a','/dev/vdb','2025-10-02 13:09:18','2025-10-02 13:09:24','rw','detached','{\"name\": \"volumes/volume-2341c515-f8fa-4cdf-87e9-1faa534d8307\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"2341c515-f8fa-4cdf-87e9-1faa534d8307\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"646f9755-18df-4630-8f00-f869a77fc0ce\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d79ae5a31735\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"91df6c8e-6fe2-49d2-9991-360b14608f11\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:17:15','2025-10-02 12:17:37','2025-10-02 12:17:37',1,'6a6d4750-7860-4bbf-bba3-50eb20d823fd','20a19061-0239-43b4-b9d7-980e7acde072','compute-2.ctlplane.example.com','ecee1ec0-1a8d-4d67-b996-205a942120ae','/dev/vda','2025-10-02 12:17:18','2025-10-02 12:17:37','rw','detached','{\"name\": \"volumes/volume-20a19061-0239-43b4-b9d7-980e7acde072\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"20a19061-0239-43b4-b9d7-980e7acde072\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"6a6d4750-7860-4bbf-bba3-50eb20d823fd\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d79ae5a31735\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"91df6c8e-6fe2-49d2-9991-360b14608f11\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:42:04','2025-10-02 12:42:16','2025-10-02 12:42:16',1,'6a767a41-7929-4e78-ab39-6475cae18c68','13e98bdf-a59c-4cec-a1d4-6b0f09d31497','compute-0.ctlplane.example.com','0cda84d2-b983-447e-b9ef-6888fdeb2df5','/dev/vdb','2025-10-02 12:42:06','2025-10-02 12:42:16','rw','detached','{\"name\": \"volumes/volume-13e98bdf-a59c-4cec-a1d4-6b0f09d31497\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"13e98bdf-a59c-4cec-a1d4-6b0f09d31497\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"6a767a41-7929-4e78-ab39-6475cae18c68\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b6d21f9028d8\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a1e3318-b91c-48d1-8474-e3593dbdcd45\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:26:01','2025-10-02 12:28:04','2025-10-02 12:28:04',1,'723939dd-8ab6-441b-821d-ba26b6f0a41c','d87ab1d9-322f-4ca3-8b9b-14a670a2e320','compute-2.ctlplane.example.com','776370c1-1213-4676-b85e-ce1c0491afc6','/dev/vdb','2025-10-02 12:26:11','2025-10-02 12:28:04','rw','detached','{\"name\": \"volumes/volume-d87ab1d9-322f-4ca3-8b9b-14a670a2e320\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"d87ab1d9-322f-4ca3-8b9b-14a670a2e320\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"723939dd-8ab6-441b-821d-ba26b6f0a41c\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d79ae5a31735\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"91df6c8e-6fe2-49d2-9991-360b14608f11\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:35:11','2025-10-02 12:35:53','2025-10-02 12:35:53',1,'748e3c4e-64ff-474b-9b2d-f528e6710211','9283cdcd-9233-4064-a250-5d9e278af430','compute-1.ctlplane.example.com','00fe5b9d-00be-45d2-9eb8-6ffb8dc0c42f','/dev/vda','2025-10-02 12:35:16','2025-10-02 12:35:53','rw','detached','{\"name\": \"volumes/volume-9283cdcd-9233-4064-a250-5d9e278af430\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"9283cdcd-9233-4064-a250-5d9e278af430\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"748e3c4e-64ff-474b-9b2d-f528e6710211\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d783e47ecf\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"5d5cabb1-2c53-462b-89f3-16d4280c3e4c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:14:40','2025-10-02 12:15:17','2025-10-02 12:15:17',1,'8041298c-4154-45fe-81e2-9dfa6deeae22','ff92c1da-c1e7-425c-b20d-f332daad4188','compute-2.ctlplane.example.com','b8f8f97e-2823-451c-ab36-7f94ade8be46','/dev/vda','2025-10-02 12:14:41','2025-10-02 12:15:17','null','detached','{\"name\": \"volumes/volume-ff92c1da-c1e7-425c-b20d-f332daad4188\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"ff92c1da-c1e7-425c-b20d-f332daad4188\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"8041298c-4154-45fe-81e2-9dfa6deeae22\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d79ae5a31735\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"91df6c8e-6fe2-49d2-9991-360b14608f11\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2025-10-02 12:45:11','2025-10-02 12:45:12','2025-10-02 12:45:12',1,'83c00b1e-cfb1-46ca-8720-084821d8ca98','0aae917b-e115-4c10-86ce-79d95317f8d0',NULL,'9aff2d67-195f-4081-9a1c-ba173a39af9d',NULL,NULL,'2025-10-02 12:45:12','null','detached','{}',NULL),('2025-10-02 12:45:50','2025-10-02 12:46:33','2025-10-02 12:46:33',1,'8795165d-376d-4129-82b5-208bafc1acc5','9405efbb-874d-467a-93c3-bbd76870d422','compute-1.ctlplane.example.com','c2c8068e-6789-48ce-95a5-ecf7cc0e7d0f','/dev/vdb','2025-10-02 12:45:51','2025-10-02 12:46:33','rw','detached','{\"name\": \"volumes/volume-9405efbb-874d-467a-93c3-bbd76870d422\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"9405efbb-874d-467a-93c3-bbd76870d422\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"8795165d-376d-4129-82b5-208bafc1acc5\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d783e47ecf\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"5d5cabb1-2c53-462b-89f3-16d4280c3e4c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 13:30:51','2025-10-02 13:32:32','2025-10-02 13:32:32',1,'88440515-4864-4dd0-8ca6-82833afd669f','c345d50c-19ab-4a23-a4a8-f7c734528d26','compute-0.ctlplane.example.com','800b27d2-30f8-4e7e-9411-bbdae9fd342b','/dev/vda','2025-10-02 13:30:53','2025-10-02 13:32:32','rw','detached','{\"name\": \"volumes/volume-c345d50c-19ab-4a23-a4a8-f7c734528d26\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"c345d50c-19ab-4a23-a4a8-f7c734528d26\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"88440515-4864-4dd0-8ca6-82833afd669f\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b6d21f9028d8\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a1e3318-b91c-48d1-8474-e3593dbdcd45\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:50:24','2025-10-02 12:50:53','2025-10-02 12:50:53',1,'887d737f-0249-43af-a5f4-dcf24c024b39','ac1432a4-bab5-43b6-871c-71608985c7ae','compute-0.ctlplane.example.com','74af08e5-d1ea-478b-ace8-00363679ec4d','/dev/vdb','2025-10-02 12:50:31','2025-10-02 12:50:53','rw','detached','{\"name\": \"volumes/volume-ac1432a4-bab5-43b6-871c-71608985c7ae\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"ac1432a4-bab5-43b6-871c-71608985c7ae\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"887d737f-0249-43af-a5f4-dcf24c024b39\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b6d21f9028d8\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a1e3318-b91c-48d1-8474-e3593dbdcd45\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:47:36','2025-10-02 12:51:04','2025-10-02 12:51:04',1,'92c19cce-94cc-4877-9308-c5354c63f368','4ce2a695-6966-417a-847c-61fce9c9533c','compute-0.ctlplane.example.com','2755e56a-ea2b-43ad-8bae-29eb7fc0ed60','/dev/vda','2025-10-02 12:47:49','2025-10-02 12:51:04','rw','detached','{\"name\": \"volumes/volume-4ce2a695-6966-417a-847c-61fce9c9533c\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"4ce2a695-6966-417a-847c-61fce9c9533c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"92c19cce-94cc-4877-9308-c5354c63f368\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b6d21f9028d8\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a1e3318-b91c-48d1-8474-e3593dbdcd45\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 13:10:01','2025-10-02 13:10:16','2025-10-02 13:10:16',1,'966c0e7d-a9f2-4cd9-848d-e4828fb91485','8347daf9-f32f-4c50-b89e-df9e913044db','compute-0.ctlplane.example.com','469a928f-d7cb-4add-9410-629caac3f6f8','/dev/vdb','2025-10-02 13:10:03','2025-10-02 13:10:16','rw','detached','{\"name\": \"volumes/volume-8347daf9-f32f-4c50-b89e-df9e913044db\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"8347daf9-f32f-4c50-b89e-df9e913044db\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"966c0e7d-a9f2-4cd9-848d-e4828fb91485\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b6d21f9028d8\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a1e3318-b91c-48d1-8474-e3593dbdcd45\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 13:14:13','2025-10-02 13:15:00','2025-10-02 13:15:00',1,'9a16231b-feb9-4c30-8006-da5d7d1ee8d4','322bbc88-53a2-4cfe-95f7-44d52cc69f65','compute-0.ctlplane.example.com','9e8e18b4-2722-4e75-ac1a-35426a38b20b','/dev/vda','2025-10-02 13:14:17','2025-10-02 13:15:00','rw','detached','{\"name\": \"volumes/volume-322bbc88-53a2-4cfe-95f7-44d52cc69f65\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"322bbc88-53a2-4cfe-95f7-44d52cc69f65\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"9a16231b-feb9-4c30-8006-da5d7d1ee8d4\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b6d21f9028d8\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a1e3318-b91c-48d1-8474-e3593dbdcd45\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:47:32','2025-10-02 12:51:10','2025-10-02 12:51:10',1,'9d9b2116-d013-4f8a-99a9-6ebdcb06d0df','aee976fe-a491-4491-adf3-8d226e48711d','compute-1.ctlplane.example.com','4b2aefbb-92cb-4a24-9ad2-884a12fa514c','/dev/vda','2025-10-02 12:47:46','2025-10-02 12:51:10','rw','detached','{\"name\": \"volumes/volume-aee976fe-a491-4491-adf3-8d226e48711d\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"aee976fe-a491-4491-adf3-8d226e48711d\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"9d9b2116-d013-4f8a-99a9-6ebdcb06d0df\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d783e47ecf\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"5d5cabb1-2c53-462b-89f3-16d4280c3e4c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:17:57','2025-10-02 12:18:03','2025-10-02 12:18:03',1,'a0d2bc1f-aebf-4529-b1d9-1b20a27c6c04','9dd4f9e5-e2b6-4aab-8485-5208997de3a8','compute-0.ctlplane.example.com','b91a8089-73c5-41c6-88aa-7681bf70fcad','/dev/vdb','2025-10-02 12:17:58','2025-10-02 12:18:03','rw','detached','{\"name\": \"volumes/volume-9dd4f9e5-e2b6-4aab-8485-5208997de3a8\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"9dd4f9e5-e2b6-4aab-8485-5208997de3a8\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"a0d2bc1f-aebf-4529-b1d9-1b20a27c6c04\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b6d21f9028d8\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a1e3318-b91c-48d1-8474-e3593dbdcd45\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:22:01','2025-10-02 12:23:47','2025-10-02 12:23:47',1,'a17f6c4e-3b3e-4e2a-bc65-6e16cb06b24f','0de00a00-9b68-498b-8bd0-88556bd22393','compute-1.ctlplane.example.com','bebdf690-5f58-4227-95e0-add2eae14645','/dev/vda','2025-10-02 12:22:09','2025-10-02 12:23:47','rw','detached','{\"name\": \"volumes/volume-0de00a00-9b68-498b-8bd0-88556bd22393\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"0de00a00-9b68-498b-8bd0-88556bd22393\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"a17f6c4e-3b3e-4e2a-bc65-6e16cb06b24f\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d783e47ecf\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"5d5cabb1-2c53-462b-89f3-16d4280c3e4c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 13:08:11','2025-10-02 13:13:28','2025-10-02 13:13:28',1,'a51a38b2-1628-4796-9233-e72a61cebdb1','3014eaef-bad8-4a87-9136-52199fbc69cb','compute-2.ctlplane.example.com','61bad754-8d82-465b-8545-25d700a6e146','/dev/vda','2025-10-02 13:08:14','2025-10-02 13:13:28','rw','detached','{\"name\": \"volumes/volume-3014eaef-bad8-4a87-9136-52199fbc69cb\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"3014eaef-bad8-4a87-9136-52199fbc69cb\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"a51a38b2-1628-4796-9233-e72a61cebdb1\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d79ae5a31735\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"91df6c8e-6fe2-49d2-9991-360b14608f11\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 13:31:33','2025-10-02 13:32:20','2025-10-02 13:32:20',1,'a5d24a42-20c2-4952-8e71-9fac1f9674e2','b03ecca0-5e5d-47a6-a97b-d3273a126768','compute-1.ctlplane.example.com','6226ed9a-8df2-43ad-b76c-e27e22f8199c','/dev/vda','2025-10-02 13:31:35','2025-10-02 13:32:20','rw','detached','{\"name\": \"volumes/volume-b03ecca0-5e5d-47a6-a97b-d3273a126768\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"b03ecca0-5e5d-47a6-a97b-d3273a126768\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"a5d24a42-20c2-4952-8e71-9fac1f9674e2\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d783e47ecf\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"5d5cabb1-2c53-462b-89f3-16d4280c3e4c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 13:13:27','2025-10-02 13:13:32','2025-10-02 13:13:32',1,'b26ac390-5800-4d5f-9659-a22fb1a48ad5','d96c5d9f-6560-48dd-8bf0-55b9a4da462b','compute-0.ctlplane.example.com','97dd449c-87a7-4278-a819-3d412f587a4c','/dev/vdb','2025-10-02 13:13:28','2025-10-02 13:13:32','rw','detached','{\"name\": \"volumes/volume-d96c5d9f-6560-48dd-8bf0-55b9a4da462b\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"d96c5d9f-6560-48dd-8bf0-55b9a4da462b\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"b26ac390-5800-4d5f-9659-a22fb1a48ad5\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b6d21f9028d8\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a1e3318-b91c-48d1-8474-e3593dbdcd45\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 13:16:14','2025-10-02 13:16:18','2025-10-02 13:16:18',1,'b292bc0c-9ab5-495c-9b23-3659729eb221','e2a88252-30d2-4853-bab0-09a8623bb9af','compute-2.ctlplane.example.com','ada17de8-afd7-427c-a0c2-43de01a22a93','/dev/vdb','2025-10-02 13:16:15','2025-10-02 13:16:18','rw','detached','{\"name\": \"volumes/volume-e2a88252-30d2-4853-bab0-09a8623bb9af\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"e2a88252-30d2-4853-bab0-09a8623bb9af\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"b292bc0c-9ab5-495c-9b23-3659729eb221\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d79ae5a31735\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"91df6c8e-6fe2-49d2-9991-360b14608f11\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 13:27:01','2025-10-02 13:27:09','2025-10-02 13:27:09',1,'ba8dceeb-6508-446a-a054-9e23f36ad0c3','2426a7f5-76f6-42eb-8c88-184ea4203bdd','compute-2.ctlplane.example.com','94242ea5-c37c-4fde-b4f4-3b1145291ba8','/dev/vda','2025-10-02 13:27:02','2025-10-02 13:27:09','rw','detached','{\"name\": \"volumes/volume-2426a7f5-76f6-42eb-8c88-184ea4203bdd\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"2426a7f5-76f6-42eb-8c88-184ea4203bdd\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"ba8dceeb-6508-446a-a054-9e23f36ad0c3\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d79ae5a31735\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"91df6c8e-6fe2-49d2-9991-360b14608f11\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 13:09:51','2025-10-02 13:10:34','2025-10-02 13:10:34',1,'c562c2d2-86a1-4802-aa4a-ca557acc0921','23ece991-964a-4523-b231-9590440c3d93','compute-2.ctlplane.example.com','79964143-e208-4552-8380-513c3adf09ac','/dev/vda','2025-10-02 13:09:54','2025-10-02 13:10:34','rw','detached','{\"name\": \"volumes/volume-23ece991-964a-4523-b231-9590440c3d93\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"23ece991-964a-4523-b231-9590440c3d93\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"c562c2d2-86a1-4802-aa4a-ca557acc0921\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d79ae5a31735\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"91df6c8e-6fe2-49d2-9991-360b14608f11\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 13:18:22','2025-10-02 13:19:22','2025-10-02 13:19:22',1,'c846ac90-d7e3-4130-adfe-f07a717fc10a','b43f69f8-7c8d-4ef5-af90-c5aa5656977e','compute-0.ctlplane.example.com','42de3106-827c-4d43-988c-18a6f44f3e01','/dev/vdb','2025-10-02 13:18:23','2025-10-02 13:19:22','rw','detached','{\"name\": \"volumes/volume-b43f69f8-7c8d-4ef5-af90-c5aa5656977e\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"b43f69f8-7c8d-4ef5-af90-c5aa5656977e\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"c846ac90-d7e3-4130-adfe-f07a717fc10a\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b6d21f9028d8\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a1e3318-b91c-48d1-8474-e3593dbdcd45\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:49:47','2025-10-02 12:50:19','2025-10-02 12:50:19',1,'ccf2a014-7375-4c5a-86ef-fd81dce50e93','ada5d5be-9d4c-4653-ac57-931c6322dea6','compute-1.ctlplane.example.com','3b348c58-f179-41db-bd79-1fdea0ade389','/dev/vdb','2025-10-02 12:49:50','2025-10-02 12:50:19','rw','detached','{\"name\": \"volumes/volume-ada5d5be-9d4c-4653-ac57-931c6322dea6\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"ada5d5be-9d4c-4653-ac57-931c6322dea6\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"ccf2a014-7375-4c5a-86ef-fd81dce50e93\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d783e47ecf\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"5d5cabb1-2c53-462b-89f3-16d4280c3e4c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:47:47','2025-10-02 12:50:55','2025-10-02 12:50:55',1,'cd97b6b4-f57d-4d9e-b3b1-f6b4e1f9df0e','83afd020-c3e2-4cb0-a15d-83739807079d','compute-1.ctlplane.example.com','3b348c58-f179-41db-bd79-1fdea0ade389','/dev/vda','2025-10-02 12:47:52','2025-10-02 12:50:55','rw','detached','{\"name\": \"volumes/volume-83afd020-c3e2-4cb0-a15d-83739807079d\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"83afd020-c3e2-4cb0-a15d-83739807079d\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"cd97b6b4-f57d-4d9e-b3b1-f6b4e1f9df0e\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d783e47ecf\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"5d5cabb1-2c53-462b-89f3-16d4280c3e4c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:26:01','2025-10-02 12:28:04','2025-10-02 12:28:04',1,'d13ebf65-b423-4dcf-8bca-485d4eec8ed2','d91ade79-bea0-4f14-93f8-80a864c83dfa','compute-2.ctlplane.example.com','776370c1-1213-4676-b85e-ce1c0491afc6','/dev/vda','2025-10-02 12:26:09','2025-10-02 12:28:04','rw','detached','{\"name\": \"volumes/volume-d91ade79-bea0-4f14-93f8-80a864c83dfa\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"d91ade79-bea0-4f14-93f8-80a864c83dfa\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"d13ebf65-b423-4dcf-8bca-485d4eec8ed2\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d79ae5a31735\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"91df6c8e-6fe2-49d2-9991-360b14608f11\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:42:54','2025-10-02 12:43:32','2025-10-02 12:43:32',1,'d29b3e2b-dfc7-4306-8aff-534a50263e4a','6ff47fe7-ec04-463b-9d03-426ce1963408','compute-2.ctlplane.example.com','1f9101c6-f4d8-46c7-8884-386f9f08e6fb','/dev/vdc','2025-10-02 12:43:00','2025-10-02 12:43:32','rw','detached','{\"name\": \"volumes/volume-6ff47fe7-ec04-463b-9d03-426ce1963408\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"6ff47fe7-ec04-463b-9d03-426ce1963408\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"d29b3e2b-dfc7-4306-8aff-534a50263e4a\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d79ae5a31735\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"91df6c8e-6fe2-49d2-9991-360b14608f11\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-10-02 13:27:39','2025-10-02 13:29:29','2025-10-02 13:29:29',1,'d901e444-cc00-4b69-bdfd-7de2ef27e29b','ffd00fca-313e-46cc-b503-d377c1529a56','compute-2.ctlplane.example.com','96f0e757-ffe8-40a4-8b11-c76935502853','/dev/vda','2025-10-02 13:27:42','2025-10-02 13:29:29','rw','detached','{\"name\": \"volumes/volume-ffd00fca-313e-46cc-b503-d377c1529a56\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"ffd00fca-313e-46cc-b503-d377c1529a56\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"d901e444-cc00-4b69-bdfd-7de2ef27e29b\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d79ae5a31735\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"91df6c8e-6fe2-49d2-9991-360b14608f11\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:48:10','2025-10-02 12:48:49','2025-10-02 12:48:49',1,'dd282639-493e-4fcf-8294-2dd5ce05fa0b','58e4ef18-7a31-4027-a9e7-0cc5f7920707','compute-1.ctlplane.example.com','4b2aefbb-92cb-4a24-9ad2-884a12fa514c','/dev/vdc','2025-10-02 12:48:11','2025-10-02 12:48:49','rw','detached','{\"name\": \"volumes/volume-58e4ef18-7a31-4027-a9e7-0cc5f7920707\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"58e4ef18-7a31-4027-a9e7-0cc5f7920707\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"dd282639-493e-4fcf-8294-2dd5ce05fa0b\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d783e47ecf\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"5d5cabb1-2c53-462b-89f3-16d4280c3e4c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-10-02 12:50:01','2025-10-02 12:50:24','2025-10-02 12:50:24',1,'e76d62b4-1ac3-4844-84aa-cf1f33360052','ac1432a4-bab5-43b6-871c-71608985c7ae','compute-2.ctlplane.example.com','74af08e5-d1ea-478b-ace8-00363679ec4d','/dev/vdb','2025-10-02 12:50:10','2025-10-02 12:50:24','rw','detached','{\"name\": \"volumes/volume-ac1432a4-bab5-43b6-871c-71608985c7ae\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"ac1432a4-bab5-43b6-871c-71608985c7ae\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"e76d62b4-1ac3-4844-84aa-cf1f33360052\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d79ae5a31735\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"91df6c8e-6fe2-49d2-9991-360b14608f11\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:22:02','2025-10-02 12:23:48','2025-10-02 12:23:48',1,'eac04b36-4077-49c3-86b1-942e2b6eeb26','b93e6b37-6df0-4c49-81d5-526e5c68b542','compute-1.ctlplane.example.com','bebdf690-5f58-4227-95e0-add2eae14645','/dev/vdb','2025-10-02 12:22:11','2025-10-02 12:23:48','rw','detached','{\"name\": \"volumes/volume-b93e6b37-6df0-4c49-81d5-526e5c68b542\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"b93e6b37-6df0-4c49-81d5-526e5c68b542\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"eac04b36-4077-49c3-86b1-942e2b6eeb26\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d783e47ecf\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"5d5cabb1-2c53-462b-89f3-16d4280c3e4c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:44:14','2025-10-02 12:45:09','2025-10-02 12:45:09',1,'eccd3a32-3cb5-4945-a572-dafcef07df2b','fdc5e1d9-2228-4ec0-a6bb-8605f6207831','compute-0.ctlplane.example.com','173830cb-12bb-4e1a-ba80-088da01ad107','/dev/vda','2025-10-02 12:44:32','2025-10-02 12:45:09','rw','detached','{\"name\": \"volumes/volume-fdc5e1d9-2228-4ec0-a6bb-8605f6207831\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"fdc5e1d9-2228-4ec0-a6bb-8605f6207831\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"eccd3a32-3cb5-4945-a572-dafcef07df2b\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b6d21f9028d8\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a1e3318-b91c-48d1-8474-e3593dbdcd45\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:41:22','2025-10-02 12:42:19','2025-10-02 12:42:19',1,'ed37b226-2e1a-4152-bdb2-a08ff6bfc01b','76444907-9f59-47f1-99d8-aa820d2e0f3a','compute-0.ctlplane.example.com','e5acbf2d-74bd-452c-8732-db2f1c0739ff','/dev/vdb','2025-10-02 12:41:24','2025-10-02 12:42:19','rw','detached','{\"name\": \"volumes/volume-76444907-9f59-47f1-99d8-aa820d2e0f3a\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"76444907-9f59-47f1-99d8-aa820d2e0f3a\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"ed37b226-2e1a-4152-bdb2-a08ff6bfc01b\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b6d21f9028d8\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a1e3318-b91c-48d1-8474-e3593dbdcd45\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 13:09:20','2025-10-02 13:09:25','2025-10-02 13:09:25',1,'f6d5886f-7bf8-455c-85a2-e2c058fd585c','2341c515-f8fa-4cdf-87e9-1faa534d8307','compute-1.ctlplane.example.com','658821a7-5b97-43ad-8fe2-46e5303cf56c','/dev/vdb','2025-10-02 13:09:21','2025-10-02 13:09:25','rw','detached','{\"name\": \"volumes/volume-2341c515-f8fa-4cdf-87e9-1faa534d8307\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"2341c515-f8fa-4cdf-87e9-1faa534d8307\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"f6d5886f-7bf8-455c-85a2-e2c058fd585c\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d783e47ecf\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"5d5cabb1-2c53-462b-89f3-16d4280c3e4c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:11:11','2025-10-02 12:11:17','2025-10-02 12:11:17',1,'f7717d65-077c-46d0-a16c-a7f5d3d10a2f','4eee902f-54cd-4f12-8095-b5f306236ae9','compute-0.ctlplane.example.com','30d82f4f-be7f-4957-a953-d4d82be0e42c','/dev/vdb','2025-10-02 12:11:13','2025-10-02 12:11:17','rw','detached','{\"name\": \"volumes/volume-4eee902f-54cd-4f12-8095-b5f306236ae9\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"4eee902f-54cd-4f12-8095-b5f306236ae9\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"f7717d65-077c-46d0-a16c-a7f5d3d10a2f\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b6d21f9028d8\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a1e3318-b91c-48d1-8474-e3593dbdcd45\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:15:11','2025-10-02 12:15:29','2025-10-02 12:15:29',1,'fafcdb04-7750-4c47-a388-41b43ddd446f','ff92c1da-c1e7-425c-b20d-f332daad4188','compute-1.ctlplane.example.com','b8f8f97e-2823-451c-ab36-7f94ade8be46','/dev/vda','2025-10-02 12:15:12','2025-10-02 12:15:29','null','detached','{\"name\": \"volumes/volume-ff92c1da-c1e7-425c-b20d-f332daad4188\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"ff92c1da-c1e7-425c-b20d-f332daad4188\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"fafcdb04-7750-4c47-a388-41b43ddd446f\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d783e47ecf\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"5d5cabb1-2c53-462b-89f3-16d4280c3e4c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2025-10-02 13:26:16','2025-10-02 13:26:31','2025-10-02 13:26:31',1,'fb876e18-20a0-43ce-8309-1f26bef31159','c3c03e41-d6c3-4680-bbf8-a098e1bc3da4','compute-2.ctlplane.example.com','3ff5ed77-0115-45a2-b09e-31c8fff6ac87','/dev/vda','2025-10-02 13:26:20','2025-10-02 13:26:31','rw','detached','{\"name\": \"volumes/volume-c3c03e41-d6c3-4680-bbf8-a098e1bc3da4\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"c3c03e41-d6c3-4680-bbf8-a098e1bc3da4\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": true, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"fb876e18-20a0-43ce-8309-1f26bef31159\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d79ae5a31735\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"91df6c8e-6fe2-49d2-9991-360b14608f11\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:17:31','2025-10-02 12:17:57','2025-10-02 12:17:57',1,'ff6e5128-91a9-4273-b9c7-d3a4c775f1fa','20a19061-0239-43b4-b9d7-980e7acde072','compute-1.ctlplane.example.com','ecee1ec0-1a8d-4d67-b996-205a942120ae','/dev/vda','2025-10-02 12:17:32','2025-10-02 12:17:57','null','detached','{\"name\": \"volumes/volume-20a19061-0239-43b4-b9d7-980e7acde072\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"20fdc58c-b037-5094-a8ef-d490aa7c36f3\", \"volume_id\": \"20a19061-0239-43b4-b9d7-980e7acde072\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"ff6e5128-91a9-4273-b9c7-d3a4c775f1fa\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d783e47ecf\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"5d5cabb1-2c53-462b-89f3-16d4280c3e4c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}');
/*!40000 ALTER TABLE `volume_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_glance_metadata`
--

DROP TABLE IF EXISTS `volume_glance_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_glance_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_glance_metadata_volume_id` (`volume_id`),
  KEY `ix_volume_glance_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `volume_glance_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `volume_glance_metadata_ibfk_2` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=267 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_glance_metadata`
--

LOCK TABLES `volume_glance_metadata` WRITE;
/*!40000 ALTER TABLE `volume_glance_metadata` DISABLE KEYS */;
INSERT INTO `volume_glance_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `snapshot_id`, `key`, `value`) VALUES ('2025-10-02 12:14:06',NULL,'2025-10-02 12:15:30',1,1,'ff92c1da-c1e7-425c-b20d-f332daad4188',NULL,'signature_verified','False'),('2025-10-02 12:14:12',NULL,'2025-10-02 12:15:30',1,2,'ff92c1da-c1e7-425c-b20d-f332daad4188',NULL,'hw_rng_model','virtio'),('2025-10-02 12:14:12',NULL,'2025-10-02 12:15:30',1,3,'ff92c1da-c1e7-425c-b20d-f332daad4188',NULL,'image_id','423b8b5f-aab8-418b-8fad-d82c90818bdd'),('2025-10-02 12:14:12',NULL,'2025-10-02 12:15:30',1,4,'ff92c1da-c1e7-425c-b20d-f332daad4188',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 12:14:12',NULL,'2025-10-02 12:15:30',1,5,'ff92c1da-c1e7-425c-b20d-f332daad4188',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 12:14:12',NULL,'2025-10-02 12:15:30',1,6,'ff92c1da-c1e7-425c-b20d-f332daad4188',NULL,'container_format','bare'),('2025-10-02 12:14:12',NULL,'2025-10-02 12:15:30',1,7,'ff92c1da-c1e7-425c-b20d-f332daad4188',NULL,'disk_format','qcow2'),('2025-10-02 12:14:12',NULL,'2025-10-02 12:15:30',1,8,'ff92c1da-c1e7-425c-b20d-f332daad4188',NULL,'min_disk','0'),('2025-10-02 12:14:12',NULL,'2025-10-02 12:15:30',1,9,'ff92c1da-c1e7-425c-b20d-f332daad4188',NULL,'min_ram','0'),('2025-10-02 12:14:12',NULL,'2025-10-02 12:15:30',1,10,'ff92c1da-c1e7-425c-b20d-f332daad4188',NULL,'size','21430272'),('2025-10-02 12:17:05',NULL,'2025-10-02 12:18:10',1,11,'20a19061-0239-43b4-b9d7-980e7acde072',NULL,'signature_verified','False'),('2025-10-02 12:17:12',NULL,'2025-10-02 12:18:10',1,12,'20a19061-0239-43b4-b9d7-980e7acde072',NULL,'hw_rng_model','virtio'),('2025-10-02 12:17:12',NULL,'2025-10-02 12:18:10',1,13,'20a19061-0239-43b4-b9d7-980e7acde072',NULL,'image_id','423b8b5f-aab8-418b-8fad-d82c90818bdd'),('2025-10-02 12:17:12',NULL,'2025-10-02 12:18:10',1,14,'20a19061-0239-43b4-b9d7-980e7acde072',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 12:17:12',NULL,'2025-10-02 12:18:10',1,15,'20a19061-0239-43b4-b9d7-980e7acde072',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 12:17:12',NULL,'2025-10-02 12:18:10',1,16,'20a19061-0239-43b4-b9d7-980e7acde072',NULL,'container_format','bare'),('2025-10-02 12:17:12',NULL,'2025-10-02 12:18:10',1,17,'20a19061-0239-43b4-b9d7-980e7acde072',NULL,'disk_format','qcow2'),('2025-10-02 12:17:12',NULL,'2025-10-02 12:18:10',1,18,'20a19061-0239-43b4-b9d7-980e7acde072',NULL,'min_disk','0'),('2025-10-02 12:17:12',NULL,'2025-10-02 12:18:10',1,19,'20a19061-0239-43b4-b9d7-980e7acde072',NULL,'min_ram','0'),('2025-10-02 12:17:12',NULL,'2025-10-02 12:18:10',1,20,'20a19061-0239-43b4-b9d7-980e7acde072',NULL,'size','21430272'),('2025-10-02 12:21:01',NULL,'2025-10-02 12:24:07',1,21,'0de00a00-9b68-498b-8bd0-88556bd22393',NULL,'signature_verified','False'),('2025-10-02 12:21:08',NULL,'2025-10-02 12:24:07',1,22,'0de00a00-9b68-498b-8bd0-88556bd22393',NULL,'hw_rng_model','virtio'),('2025-10-02 12:21:08',NULL,'2025-10-02 12:24:07',1,23,'0de00a00-9b68-498b-8bd0-88556bd22393',NULL,'image_id','423b8b5f-aab8-418b-8fad-d82c90818bdd'),('2025-10-02 12:21:08',NULL,'2025-10-02 12:24:07',1,24,'0de00a00-9b68-498b-8bd0-88556bd22393',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 12:21:08',NULL,'2025-10-02 12:24:07',1,25,'0de00a00-9b68-498b-8bd0-88556bd22393',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 12:21:08',NULL,'2025-10-02 12:24:07',1,26,'0de00a00-9b68-498b-8bd0-88556bd22393',NULL,'container_format','bare'),('2025-10-02 12:21:08',NULL,'2025-10-02 12:24:07',1,27,'0de00a00-9b68-498b-8bd0-88556bd22393',NULL,'disk_format','qcow2'),('2025-10-02 12:21:08',NULL,'2025-10-02 12:24:07',1,28,'0de00a00-9b68-498b-8bd0-88556bd22393',NULL,'min_disk','0'),('2025-10-02 12:21:08',NULL,'2025-10-02 12:24:07',1,29,'0de00a00-9b68-498b-8bd0-88556bd22393',NULL,'min_ram','0'),('2025-10-02 12:21:08',NULL,'2025-10-02 12:24:07',1,30,'0de00a00-9b68-498b-8bd0-88556bd22393',NULL,'size','21430272'),('2025-10-02 12:25:03',NULL,'2025-10-02 12:28:23',1,31,'d91ade79-bea0-4f14-93f8-80a864c83dfa',NULL,'signature_verified','False'),('2025-10-02 12:25:13',NULL,'2025-10-02 12:28:23',1,32,'d91ade79-bea0-4f14-93f8-80a864c83dfa',NULL,'hw_rng_model','virtio'),('2025-10-02 12:25:13',NULL,'2025-10-02 12:28:23',1,33,'d91ade79-bea0-4f14-93f8-80a864c83dfa',NULL,'image_id','423b8b5f-aab8-418b-8fad-d82c90818bdd'),('2025-10-02 12:25:13',NULL,'2025-10-02 12:28:23',1,34,'d91ade79-bea0-4f14-93f8-80a864c83dfa',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 12:25:13',NULL,'2025-10-02 12:28:23',1,35,'d91ade79-bea0-4f14-93f8-80a864c83dfa',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 12:25:13',NULL,'2025-10-02 12:28:23',1,36,'d91ade79-bea0-4f14-93f8-80a864c83dfa',NULL,'container_format','bare'),('2025-10-02 12:25:13',NULL,'2025-10-02 12:28:23',1,37,'d91ade79-bea0-4f14-93f8-80a864c83dfa',NULL,'disk_format','qcow2'),('2025-10-02 12:25:13',NULL,'2025-10-02 12:28:23',1,38,'d91ade79-bea0-4f14-93f8-80a864c83dfa',NULL,'min_disk','0'),('2025-10-02 12:25:13',NULL,'2025-10-02 12:28:23',1,39,'d91ade79-bea0-4f14-93f8-80a864c83dfa',NULL,'min_ram','0'),('2025-10-02 12:25:13',NULL,'2025-10-02 12:28:23',1,40,'d91ade79-bea0-4f14-93f8-80a864c83dfa',NULL,'size','21430272'),('2025-10-02 12:34:58',NULL,'2025-10-02 12:35:55',1,41,'9283cdcd-9233-4064-a250-5d9e278af430',NULL,'signature_verified','False'),('2025-10-02 12:35:08',NULL,'2025-10-02 12:35:55',1,42,'9283cdcd-9233-4064-a250-5d9e278af430',NULL,'hw_rng_model','virtio'),('2025-10-02 12:35:08',NULL,'2025-10-02 12:35:55',1,43,'9283cdcd-9233-4064-a250-5d9e278af430',NULL,'image_id','423b8b5f-aab8-418b-8fad-d82c90818bdd'),('2025-10-02 12:35:08',NULL,'2025-10-02 12:35:55',1,44,'9283cdcd-9233-4064-a250-5d9e278af430',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 12:35:08',NULL,'2025-10-02 12:35:55',1,45,'9283cdcd-9233-4064-a250-5d9e278af430',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 12:35:08',NULL,'2025-10-02 12:35:55',1,46,'9283cdcd-9233-4064-a250-5d9e278af430',NULL,'container_format','bare'),('2025-10-02 12:35:08',NULL,'2025-10-02 12:35:55',1,47,'9283cdcd-9233-4064-a250-5d9e278af430',NULL,'disk_format','qcow2'),('2025-10-02 12:35:08',NULL,'2025-10-02 12:35:55',1,48,'9283cdcd-9233-4064-a250-5d9e278af430',NULL,'min_disk','0'),('2025-10-02 12:35:08',NULL,'2025-10-02 12:35:55',1,49,'9283cdcd-9233-4064-a250-5d9e278af430',NULL,'min_ram','0'),('2025-10-02 12:35:08',NULL,'2025-10-02 12:35:55',1,50,'9283cdcd-9233-4064-a250-5d9e278af430',NULL,'size','21430272'),('2025-10-02 12:43:20',NULL,'2025-10-02 12:45:10',1,51,'fdc5e1d9-2228-4ec0-a6bb-8605f6207831',NULL,'signature_verified','False'),('2025-10-02 12:43:31',NULL,'2025-10-02 12:45:10',1,52,'fdc5e1d9-2228-4ec0-a6bb-8605f6207831',NULL,'hw_rng_model','virtio'),('2025-10-02 12:43:31',NULL,'2025-10-02 12:45:10',1,53,'fdc5e1d9-2228-4ec0-a6bb-8605f6207831',NULL,'image_id','423b8b5f-aab8-418b-8fad-d82c90818bdd'),('2025-10-02 12:43:31',NULL,'2025-10-02 12:45:10',1,54,'fdc5e1d9-2228-4ec0-a6bb-8605f6207831',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 12:43:31',NULL,'2025-10-02 12:45:10',1,55,'fdc5e1d9-2228-4ec0-a6bb-8605f6207831',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 12:43:31',NULL,'2025-10-02 12:45:10',1,56,'fdc5e1d9-2228-4ec0-a6bb-8605f6207831',NULL,'container_format','bare'),('2025-10-02 12:43:31',NULL,'2025-10-02 12:45:10',1,57,'fdc5e1d9-2228-4ec0-a6bb-8605f6207831',NULL,'disk_format','qcow2'),('2025-10-02 12:43:31',NULL,'2025-10-02 12:45:10',1,58,'fdc5e1d9-2228-4ec0-a6bb-8605f6207831',NULL,'min_disk','0'),('2025-10-02 12:43:31',NULL,'2025-10-02 12:45:10',1,59,'fdc5e1d9-2228-4ec0-a6bb-8605f6207831',NULL,'min_ram','0'),('2025-10-02 12:43:31',NULL,'2025-10-02 12:45:10',1,60,'fdc5e1d9-2228-4ec0-a6bb-8605f6207831',NULL,'size','21430272'),('2025-10-02 12:47:17',NULL,'2025-10-02 12:51:18',1,61,'aee976fe-a491-4491-adf3-8d226e48711d',NULL,'signature_verified','False'),('2025-10-02 12:47:20',NULL,'2025-10-02 12:51:15',1,62,'4ce2a695-6966-417a-847c-61fce9c9533c',NULL,'signature_verified','False'),('2025-10-02 12:47:27',NULL,'2025-10-02 12:51:13',1,63,'83afd020-c3e2-4cb0-a15d-83739807079d',NULL,'signature_verified','False'),('2025-10-02 12:47:29',NULL,'2025-10-02 12:51:18',1,64,'aee976fe-a491-4491-adf3-8d226e48711d',NULL,'image_id','2de43632-5d51-4644-b4ab-edaca67d1e25'),('2025-10-02 12:47:29',NULL,'2025-10-02 12:51:18',1,65,'aee976fe-a491-4491-adf3-8d226e48711d',NULL,'image_name','tempest-scenario-img--796530541'),('2025-10-02 12:47:29',NULL,'2025-10-02 12:51:18',1,66,'aee976fe-a491-4491-adf3-8d226e48711d',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 12:47:29',NULL,'2025-10-02 12:51:18',1,67,'aee976fe-a491-4491-adf3-8d226e48711d',NULL,'container_format','bare'),('2025-10-02 12:47:29',NULL,'2025-10-02 12:51:18',1,68,'aee976fe-a491-4491-adf3-8d226e48711d',NULL,'disk_format','qcow2'),('2025-10-02 12:47:29',NULL,'2025-10-02 12:51:18',1,69,'aee976fe-a491-4491-adf3-8d226e48711d',NULL,'min_disk','0'),('2025-10-02 12:47:29',NULL,'2025-10-02 12:51:18',1,70,'aee976fe-a491-4491-adf3-8d226e48711d',NULL,'min_ram','0'),('2025-10-02 12:47:29',NULL,'2025-10-02 12:51:18',1,71,'aee976fe-a491-4491-adf3-8d226e48711d',NULL,'size','21430272'),('2025-10-02 12:47:29',NULL,'2025-10-02 12:51:15',1,72,'4ce2a695-6966-417a-847c-61fce9c9533c',NULL,'image_id','2de43632-5d51-4644-b4ab-edaca67d1e25'),('2025-10-02 12:47:29',NULL,'2025-10-02 12:51:15',1,73,'4ce2a695-6966-417a-847c-61fce9c9533c',NULL,'image_name','tempest-scenario-img--796530541'),('2025-10-02 12:47:29',NULL,'2025-10-02 12:51:15',1,74,'4ce2a695-6966-417a-847c-61fce9c9533c',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 12:47:29',NULL,'2025-10-02 12:51:15',1,75,'4ce2a695-6966-417a-847c-61fce9c9533c',NULL,'container_format','bare'),('2025-10-02 12:47:29',NULL,'2025-10-02 12:51:15',1,76,'4ce2a695-6966-417a-847c-61fce9c9533c',NULL,'disk_format','qcow2'),('2025-10-02 12:47:29',NULL,'2025-10-02 12:51:15',1,77,'4ce2a695-6966-417a-847c-61fce9c9533c',NULL,'min_disk','0'),('2025-10-02 12:47:29',NULL,'2025-10-02 12:51:15',1,78,'4ce2a695-6966-417a-847c-61fce9c9533c',NULL,'min_ram','0'),('2025-10-02 12:47:29',NULL,'2025-10-02 12:51:15',1,79,'4ce2a695-6966-417a-847c-61fce9c9533c',NULL,'size','21430272'),('2025-10-02 12:47:40',NULL,'2025-10-02 12:51:13',1,80,'83afd020-c3e2-4cb0-a15d-83739807079d',NULL,'image_id','2de43632-5d51-4644-b4ab-edaca67d1e25'),('2025-10-02 12:47:41',NULL,'2025-10-02 12:51:13',1,81,'83afd020-c3e2-4cb0-a15d-83739807079d',NULL,'image_name','tempest-scenario-img--796530541'),('2025-10-02 12:47:41',NULL,'2025-10-02 12:51:13',1,82,'83afd020-c3e2-4cb0-a15d-83739807079d',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 12:47:41',NULL,'2025-10-02 12:51:13',1,83,'83afd020-c3e2-4cb0-a15d-83739807079d',NULL,'container_format','bare'),('2025-10-02 12:47:41',NULL,'2025-10-02 12:51:13',1,84,'83afd020-c3e2-4cb0-a15d-83739807079d',NULL,'disk_format','qcow2'),('2025-10-02 12:47:41',NULL,'2025-10-02 12:51:13',1,85,'83afd020-c3e2-4cb0-a15d-83739807079d',NULL,'min_disk','0'),('2025-10-02 12:47:41',NULL,'2025-10-02 12:51:13',1,86,'83afd020-c3e2-4cb0-a15d-83739807079d',NULL,'min_ram','0'),('2025-10-02 12:47:41',NULL,'2025-10-02 12:51:13',1,87,'83afd020-c3e2-4cb0-a15d-83739807079d',NULL,'size','21430272'),('2025-10-02 12:49:49',NULL,'2025-10-02 12:51:14',1,88,'a7bdd212-0d34-40b8-9af9-06388d215028',NULL,'signature_verified','False'),('2025-10-02 12:49:58',NULL,'2025-10-02 12:51:14',1,89,'a7bdd212-0d34-40b8-9af9-06388d215028',NULL,'hw_rng_model','virtio'),('2025-10-02 12:49:58',NULL,'2025-10-02 12:51:14',1,90,'a7bdd212-0d34-40b8-9af9-06388d215028',NULL,'image_id','423b8b5f-aab8-418b-8fad-d82c90818bdd'),('2025-10-02 12:49:58',NULL,'2025-10-02 12:51:14',1,91,'a7bdd212-0d34-40b8-9af9-06388d215028',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 12:49:58',NULL,'2025-10-02 12:51:14',1,92,'a7bdd212-0d34-40b8-9af9-06388d215028',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 12:49:58',NULL,'2025-10-02 12:51:14',1,93,'a7bdd212-0d34-40b8-9af9-06388d215028',NULL,'container_format','bare'),('2025-10-02 12:49:58',NULL,'2025-10-02 12:51:14',1,94,'a7bdd212-0d34-40b8-9af9-06388d215028',NULL,'disk_format','qcow2'),('2025-10-02 12:49:58',NULL,'2025-10-02 12:51:14',1,95,'a7bdd212-0d34-40b8-9af9-06388d215028',NULL,'min_disk','0'),('2025-10-02 12:49:58',NULL,'2025-10-02 12:51:14',1,96,'a7bdd212-0d34-40b8-9af9-06388d215028',NULL,'min_ram','0'),('2025-10-02 12:49:58',NULL,'2025-10-02 12:51:14',1,97,'a7bdd212-0d34-40b8-9af9-06388d215028',NULL,'size','21430272'),('2025-10-02 12:51:14',NULL,'2025-10-02 12:52:10',1,98,'a7bdd212-0d34-40b8-9af9-06388d215028',NULL,'hw_rng_model','virtio'),('2025-10-02 12:51:14',NULL,'2025-10-02 12:52:10',1,99,'a7bdd212-0d34-40b8-9af9-06388d215028',NULL,'image_id','52ef509e-0e22-464e-93c9-3ddcf574cd64'),('2025-10-02 12:51:14',NULL,'2025-10-02 12:52:10',1,100,'a7bdd212-0d34-40b8-9af9-06388d215028',NULL,'image_name','cirros-0.6.2-x86_64-disk.img_alt'),('2025-10-02 12:51:14',NULL,'2025-10-02 12:52:10',1,101,'a7bdd212-0d34-40b8-9af9-06388d215028',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 12:51:14',NULL,'2025-10-02 12:52:10',1,102,'a7bdd212-0d34-40b8-9af9-06388d215028',NULL,'container_format','bare'),('2025-10-02 12:51:14',NULL,'2025-10-02 12:52:10',1,103,'a7bdd212-0d34-40b8-9af9-06388d215028',NULL,'disk_format','qcow2'),('2025-10-02 12:51:14',NULL,'2025-10-02 12:52:10',1,104,'a7bdd212-0d34-40b8-9af9-06388d215028',NULL,'min_disk','0'),('2025-10-02 12:51:14',NULL,'2025-10-02 12:52:10',1,105,'a7bdd212-0d34-40b8-9af9-06388d215028',NULL,'min_ram','0'),('2025-10-02 12:51:14',NULL,'2025-10-02 12:52:10',1,106,'a7bdd212-0d34-40b8-9af9-06388d215028',NULL,'size','21430272'),('2025-10-02 12:56:36',NULL,NULL,0,107,'93f6251c-1119-43b6-b608-e405dc9beae8',NULL,'signature_verified','False'),('2025-10-02 12:56:41',NULL,NULL,0,108,'93f6251c-1119-43b6-b608-e405dc9beae8',NULL,'hw_rng_model','virtio'),('2025-10-02 12:56:41',NULL,NULL,0,109,'93f6251c-1119-43b6-b608-e405dc9beae8',NULL,'image_id','423b8b5f-aab8-418b-8fad-d82c90818bdd'),('2025-10-02 12:56:41',NULL,NULL,0,110,'93f6251c-1119-43b6-b608-e405dc9beae8',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 12:56:41',NULL,NULL,0,111,'93f6251c-1119-43b6-b608-e405dc9beae8',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 12:56:41',NULL,NULL,0,112,'93f6251c-1119-43b6-b608-e405dc9beae8',NULL,'container_format','bare'),('2025-10-02 12:56:41',NULL,NULL,0,113,'93f6251c-1119-43b6-b608-e405dc9beae8',NULL,'disk_format','qcow2'),('2025-10-02 12:56:41',NULL,NULL,0,114,'93f6251c-1119-43b6-b608-e405dc9beae8',NULL,'min_disk','0'),('2025-10-02 12:56:41',NULL,NULL,0,115,'93f6251c-1119-43b6-b608-e405dc9beae8',NULL,'min_ram','0'),('2025-10-02 12:56:41',NULL,NULL,0,116,'93f6251c-1119-43b6-b608-e405dc9beae8',NULL,'size','21430272'),('2025-10-02 13:08:00',NULL,'2025-10-02 13:13:31',1,117,'3014eaef-bad8-4a87-9136-52199fbc69cb',NULL,'signature_verified','False'),('2025-10-02 13:08:07',NULL,'2025-10-02 13:13:31',1,118,'3014eaef-bad8-4a87-9136-52199fbc69cb',NULL,'hw_rng_model','virtio'),('2025-10-02 13:08:07',NULL,'2025-10-02 13:13:31',1,119,'3014eaef-bad8-4a87-9136-52199fbc69cb',NULL,'image_id','423b8b5f-aab8-418b-8fad-d82c90818bdd'),('2025-10-02 13:08:07',NULL,'2025-10-02 13:13:31',1,120,'3014eaef-bad8-4a87-9136-52199fbc69cb',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 13:08:07',NULL,'2025-10-02 13:13:31',1,121,'3014eaef-bad8-4a87-9136-52199fbc69cb',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 13:08:07',NULL,'2025-10-02 13:13:31',1,122,'3014eaef-bad8-4a87-9136-52199fbc69cb',NULL,'container_format','bare'),('2025-10-02 13:08:07',NULL,'2025-10-02 13:13:31',1,123,'3014eaef-bad8-4a87-9136-52199fbc69cb',NULL,'disk_format','qcow2'),('2025-10-02 13:08:07',NULL,'2025-10-02 13:13:31',1,124,'3014eaef-bad8-4a87-9136-52199fbc69cb',NULL,'min_disk','0'),('2025-10-02 13:08:07',NULL,'2025-10-02 13:13:31',1,125,'3014eaef-bad8-4a87-9136-52199fbc69cb',NULL,'min_ram','0'),('2025-10-02 13:08:07',NULL,'2025-10-02 13:13:31',1,126,'3014eaef-bad8-4a87-9136-52199fbc69cb',NULL,'size','21430272'),('2025-10-02 13:09:44',NULL,'2025-10-02 13:11:32',1,127,'23ece991-964a-4523-b231-9590440c3d93',NULL,'signature_verified','False'),('2025-10-02 13:09:49',NULL,'2025-10-02 13:11:32',1,128,'23ece991-964a-4523-b231-9590440c3d93',NULL,'hw_rng_model','virtio'),('2025-10-02 13:09:49',NULL,'2025-10-02 13:11:32',1,129,'23ece991-964a-4523-b231-9590440c3d93',NULL,'image_id','423b8b5f-aab8-418b-8fad-d82c90818bdd'),('2025-10-02 13:09:49',NULL,'2025-10-02 13:11:32',1,130,'23ece991-964a-4523-b231-9590440c3d93',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 13:09:49',NULL,'2025-10-02 13:11:32',1,131,'23ece991-964a-4523-b231-9590440c3d93',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 13:09:49',NULL,'2025-10-02 13:11:32',1,132,'23ece991-964a-4523-b231-9590440c3d93',NULL,'container_format','bare'),('2025-10-02 13:09:49',NULL,'2025-10-02 13:11:32',1,133,'23ece991-964a-4523-b231-9590440c3d93',NULL,'disk_format','qcow2'),('2025-10-02 13:09:49',NULL,'2025-10-02 13:11:32',1,134,'23ece991-964a-4523-b231-9590440c3d93',NULL,'min_disk','0'),('2025-10-02 13:09:49',NULL,'2025-10-02 13:11:32',1,135,'23ece991-964a-4523-b231-9590440c3d93',NULL,'min_ram','0'),('2025-10-02 13:09:49',NULL,'2025-10-02 13:11:32',1,136,'23ece991-964a-4523-b231-9590440c3d93',NULL,'size','21430272'),('2025-10-02 13:11:41',NULL,'2025-10-02 13:12:22',1,137,'19b06699-b688-462a-890e-57ac19f2d9e6',NULL,'signature_verified','False'),('2025-10-02 13:11:53',NULL,'2025-10-02 13:12:22',1,138,'19b06699-b688-462a-890e-57ac19f2d9e6',NULL,'hw_rng_model','virtio'),('2025-10-02 13:11:53',NULL,'2025-10-02 13:12:22',1,139,'19b06699-b688-462a-890e-57ac19f2d9e6',NULL,'image_id','423b8b5f-aab8-418b-8fad-d82c90818bdd'),('2025-10-02 13:11:53',NULL,'2025-10-02 13:12:22',1,140,'19b06699-b688-462a-890e-57ac19f2d9e6',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 13:11:53',NULL,'2025-10-02 13:12:22',1,141,'19b06699-b688-462a-890e-57ac19f2d9e6',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 13:11:53',NULL,'2025-10-02 13:12:22',1,142,'19b06699-b688-462a-890e-57ac19f2d9e6',NULL,'container_format','bare'),('2025-10-02 13:11:53',NULL,'2025-10-02 13:12:22',1,143,'19b06699-b688-462a-890e-57ac19f2d9e6',NULL,'disk_format','qcow2'),('2025-10-02 13:11:53',NULL,'2025-10-02 13:12:22',1,144,'19b06699-b688-462a-890e-57ac19f2d9e6',NULL,'min_disk','0'),('2025-10-02 13:11:53',NULL,'2025-10-02 13:12:22',1,145,'19b06699-b688-462a-890e-57ac19f2d9e6',NULL,'min_ram','0'),('2025-10-02 13:11:53',NULL,'2025-10-02 13:12:22',1,146,'19b06699-b688-462a-890e-57ac19f2d9e6',NULL,'size','21430272'),('2025-10-02 13:12:12',NULL,'2025-10-02 13:12:21',1,147,NULL,'dff6adf7-64dd-40b8-b0c2-8bd3f4e563c0','signature_verified','False'),('2025-10-02 13:12:12',NULL,'2025-10-02 13:12:21',1,148,NULL,'dff6adf7-64dd-40b8-b0c2-8bd3f4e563c0','hw_rng_model','virtio'),('2025-10-02 13:12:12',NULL,'2025-10-02 13:12:21',1,149,NULL,'dff6adf7-64dd-40b8-b0c2-8bd3f4e563c0','image_id','423b8b5f-aab8-418b-8fad-d82c90818bdd'),('2025-10-02 13:12:12',NULL,'2025-10-02 13:12:21',1,150,NULL,'dff6adf7-64dd-40b8-b0c2-8bd3f4e563c0','image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 13:12:12',NULL,'2025-10-02 13:12:21',1,151,NULL,'dff6adf7-64dd-40b8-b0c2-8bd3f4e563c0','checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 13:12:12',NULL,'2025-10-02 13:12:21',1,152,NULL,'dff6adf7-64dd-40b8-b0c2-8bd3f4e563c0','container_format','bare'),('2025-10-02 13:12:12',NULL,'2025-10-02 13:12:21',1,153,NULL,'dff6adf7-64dd-40b8-b0c2-8bd3f4e563c0','disk_format','qcow2'),('2025-10-02 13:12:12',NULL,'2025-10-02 13:12:21',1,154,NULL,'dff6adf7-64dd-40b8-b0c2-8bd3f4e563c0','min_disk','0'),('2025-10-02 13:12:12',NULL,'2025-10-02 13:12:21',1,155,NULL,'dff6adf7-64dd-40b8-b0c2-8bd3f4e563c0','min_ram','0'),('2025-10-02 13:12:12',NULL,'2025-10-02 13:12:21',1,156,NULL,'dff6adf7-64dd-40b8-b0c2-8bd3f4e563c0','size','21430272'),('2025-10-02 13:13:51',NULL,'2025-10-02 13:15:06',1,157,'d8e6ba23-d512-444c-9b18-1432ad9db22b',NULL,'signature_verified','False'),('2025-10-02 13:13:57',NULL,'2025-10-02 13:15:06',1,158,'d8e6ba23-d512-444c-9b18-1432ad9db22b',NULL,'hw_rng_model','virtio'),('2025-10-02 13:13:57',NULL,'2025-10-02 13:15:06',1,159,'d8e6ba23-d512-444c-9b18-1432ad9db22b',NULL,'image_id','423b8b5f-aab8-418b-8fad-d82c90818bdd'),('2025-10-02 13:13:57',NULL,'2025-10-02 13:15:06',1,160,'d8e6ba23-d512-444c-9b18-1432ad9db22b',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 13:13:57',NULL,'2025-10-02 13:15:06',1,161,'d8e6ba23-d512-444c-9b18-1432ad9db22b',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 13:13:57',NULL,'2025-10-02 13:15:06',1,162,'d8e6ba23-d512-444c-9b18-1432ad9db22b',NULL,'container_format','bare'),('2025-10-02 13:13:57',NULL,'2025-10-02 13:15:06',1,163,'d8e6ba23-d512-444c-9b18-1432ad9db22b',NULL,'disk_format','qcow2'),('2025-10-02 13:13:57',NULL,'2025-10-02 13:15:06',1,164,'d8e6ba23-d512-444c-9b18-1432ad9db22b',NULL,'min_disk','0'),('2025-10-02 13:13:57',NULL,'2025-10-02 13:15:06',1,165,'d8e6ba23-d512-444c-9b18-1432ad9db22b',NULL,'min_ram','0'),('2025-10-02 13:13:57',NULL,'2025-10-02 13:15:06',1,166,'d8e6ba23-d512-444c-9b18-1432ad9db22b',NULL,'size','21430272'),('2025-10-02 13:14:09',NULL,'2025-10-02 13:15:06',1,167,'322bbc88-53a2-4cfe-95f7-44d52cc69f65',NULL,'signature_verified','False'),('2025-10-02 13:14:09',NULL,'2025-10-02 13:15:06',1,168,'322bbc88-53a2-4cfe-95f7-44d52cc69f65',NULL,'hw_rng_model','virtio'),('2025-10-02 13:14:09',NULL,'2025-10-02 13:15:06',1,169,'322bbc88-53a2-4cfe-95f7-44d52cc69f65',NULL,'image_id','423b8b5f-aab8-418b-8fad-d82c90818bdd'),('2025-10-02 13:14:09',NULL,'2025-10-02 13:15:06',1,170,'322bbc88-53a2-4cfe-95f7-44d52cc69f65',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 13:14:09',NULL,'2025-10-02 13:15:06',1,171,'322bbc88-53a2-4cfe-95f7-44d52cc69f65',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 13:14:09',NULL,'2025-10-02 13:15:06',1,172,'322bbc88-53a2-4cfe-95f7-44d52cc69f65',NULL,'container_format','bare'),('2025-10-02 13:14:09',NULL,'2025-10-02 13:15:06',1,173,'322bbc88-53a2-4cfe-95f7-44d52cc69f65',NULL,'disk_format','qcow2'),('2025-10-02 13:14:09',NULL,'2025-10-02 13:15:06',1,174,'322bbc88-53a2-4cfe-95f7-44d52cc69f65',NULL,'min_disk','0'),('2025-10-02 13:14:09',NULL,'2025-10-02 13:15:06',1,175,'322bbc88-53a2-4cfe-95f7-44d52cc69f65',NULL,'min_ram','0'),('2025-10-02 13:14:09',NULL,'2025-10-02 13:15:06',1,176,'322bbc88-53a2-4cfe-95f7-44d52cc69f65',NULL,'size','21430272'),('2025-10-02 13:26:41',NULL,'2025-10-02 13:27:14',1,177,'8c46a235-cbac-44eb-b1b6-0f232670dbd3',NULL,'signature_verified','False'),('2025-10-02 13:26:48',NULL,'2025-10-02 13:27:14',1,178,'8c46a235-cbac-44eb-b1b6-0f232670dbd3',NULL,'hw_rng_model','virtio'),('2025-10-02 13:26:48',NULL,'2025-10-02 13:27:14',1,179,'8c46a235-cbac-44eb-b1b6-0f232670dbd3',NULL,'image_id','423b8b5f-aab8-418b-8fad-d82c90818bdd'),('2025-10-02 13:26:48',NULL,'2025-10-02 13:27:14',1,180,'8c46a235-cbac-44eb-b1b6-0f232670dbd3',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 13:26:48',NULL,'2025-10-02 13:27:14',1,181,'8c46a235-cbac-44eb-b1b6-0f232670dbd3',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 13:26:48',NULL,'2025-10-02 13:27:14',1,182,'8c46a235-cbac-44eb-b1b6-0f232670dbd3',NULL,'container_format','bare'),('2025-10-02 13:26:48',NULL,'2025-10-02 13:27:14',1,183,'8c46a235-cbac-44eb-b1b6-0f232670dbd3',NULL,'disk_format','qcow2'),('2025-10-02 13:26:48',NULL,'2025-10-02 13:27:14',1,184,'8c46a235-cbac-44eb-b1b6-0f232670dbd3',NULL,'min_disk','0'),('2025-10-02 13:26:48',NULL,'2025-10-02 13:27:14',1,185,'8c46a235-cbac-44eb-b1b6-0f232670dbd3',NULL,'min_ram','0'),('2025-10-02 13:26:48',NULL,'2025-10-02 13:27:14',1,186,'8c46a235-cbac-44eb-b1b6-0f232670dbd3',NULL,'size','21430272'),('2025-10-02 13:26:50',NULL,'2025-10-02 13:27:12',1,187,NULL,'9ae89550-43b8-4753-be7a-188d37df60ee','signature_verified','False'),('2025-10-02 13:26:50',NULL,'2025-10-02 13:27:12',1,188,NULL,'9ae89550-43b8-4753-be7a-188d37df60ee','hw_rng_model','virtio'),('2025-10-02 13:26:50',NULL,'2025-10-02 13:27:12',1,189,NULL,'9ae89550-43b8-4753-be7a-188d37df60ee','image_id','423b8b5f-aab8-418b-8fad-d82c90818bdd'),('2025-10-02 13:26:50',NULL,'2025-10-02 13:27:12',1,190,NULL,'9ae89550-43b8-4753-be7a-188d37df60ee','image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 13:26:50',NULL,'2025-10-02 13:27:12',1,191,NULL,'9ae89550-43b8-4753-be7a-188d37df60ee','checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 13:26:50',NULL,'2025-10-02 13:27:12',1,192,NULL,'9ae89550-43b8-4753-be7a-188d37df60ee','container_format','bare'),('2025-10-02 13:26:51',NULL,'2025-10-02 13:27:12',1,193,NULL,'9ae89550-43b8-4753-be7a-188d37df60ee','disk_format','qcow2'),('2025-10-02 13:26:51',NULL,'2025-10-02 13:27:12',1,194,NULL,'9ae89550-43b8-4753-be7a-188d37df60ee','min_disk','0'),('2025-10-02 13:26:51',NULL,'2025-10-02 13:27:12',1,195,NULL,'9ae89550-43b8-4753-be7a-188d37df60ee','min_ram','0'),('2025-10-02 13:26:51',NULL,'2025-10-02 13:27:12',1,196,NULL,'9ae89550-43b8-4753-be7a-188d37df60ee','size','21430272'),('2025-10-02 13:26:59',NULL,'2025-10-02 13:27:10',1,197,'2426a7f5-76f6-42eb-8c88-184ea4203bdd',NULL,'signature_verified','False'),('2025-10-02 13:26:59',NULL,'2025-10-02 13:27:10',1,198,'2426a7f5-76f6-42eb-8c88-184ea4203bdd',NULL,'hw_rng_model','virtio'),('2025-10-02 13:26:59',NULL,'2025-10-02 13:27:10',1,199,'2426a7f5-76f6-42eb-8c88-184ea4203bdd',NULL,'image_id','423b8b5f-aab8-418b-8fad-d82c90818bdd'),('2025-10-02 13:26:59',NULL,'2025-10-02 13:27:10',1,200,'2426a7f5-76f6-42eb-8c88-184ea4203bdd',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 13:26:59',NULL,'2025-10-02 13:27:10',1,201,'2426a7f5-76f6-42eb-8c88-184ea4203bdd',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 13:26:59',NULL,'2025-10-02 13:27:10',1,202,'2426a7f5-76f6-42eb-8c88-184ea4203bdd',NULL,'container_format','bare'),('2025-10-02 13:26:59',NULL,'2025-10-02 13:27:10',1,203,'2426a7f5-76f6-42eb-8c88-184ea4203bdd',NULL,'disk_format','qcow2'),('2025-10-02 13:26:59',NULL,'2025-10-02 13:27:10',1,204,'2426a7f5-76f6-42eb-8c88-184ea4203bdd',NULL,'min_disk','0'),('2025-10-02 13:26:59',NULL,'2025-10-02 13:27:10',1,205,'2426a7f5-76f6-42eb-8c88-184ea4203bdd',NULL,'min_ram','0'),('2025-10-02 13:26:59',NULL,'2025-10-02 13:27:10',1,206,'2426a7f5-76f6-42eb-8c88-184ea4203bdd',NULL,'size','21430272'),('2025-10-02 13:27:21',NULL,'2025-10-02 13:29:35',1,207,'ffd00fca-313e-46cc-b503-d377c1529a56',NULL,'signature_verified','False'),('2025-10-02 13:27:31',NULL,'2025-10-02 13:29:35',1,208,'ffd00fca-313e-46cc-b503-d377c1529a56',NULL,'hw_rng_model','virtio'),('2025-10-02 13:27:31',NULL,'2025-10-02 13:29:35',1,209,'ffd00fca-313e-46cc-b503-d377c1529a56',NULL,'image_id','423b8b5f-aab8-418b-8fad-d82c90818bdd'),('2025-10-02 13:27:31',NULL,'2025-10-02 13:29:35',1,210,'ffd00fca-313e-46cc-b503-d377c1529a56',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 13:27:31',NULL,'2025-10-02 13:29:35',1,211,'ffd00fca-313e-46cc-b503-d377c1529a56',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 13:27:31',NULL,'2025-10-02 13:29:35',1,212,'ffd00fca-313e-46cc-b503-d377c1529a56',NULL,'container_format','bare'),('2025-10-02 13:27:31',NULL,'2025-10-02 13:29:35',1,213,'ffd00fca-313e-46cc-b503-d377c1529a56',NULL,'disk_format','qcow2'),('2025-10-02 13:27:31',NULL,'2025-10-02 13:29:35',1,214,'ffd00fca-313e-46cc-b503-d377c1529a56',NULL,'min_disk','0'),('2025-10-02 13:27:31',NULL,'2025-10-02 13:29:35',1,215,'ffd00fca-313e-46cc-b503-d377c1529a56',NULL,'min_ram','0'),('2025-10-02 13:27:31',NULL,'2025-10-02 13:29:35',1,216,'ffd00fca-313e-46cc-b503-d377c1529a56',NULL,'size','21430272'),('2025-10-02 13:28:15',NULL,'2025-10-02 13:29:22',1,217,NULL,'b50be4d5-612a-4434-8eb6-55d27bed7a4d','signature_verified','False'),('2025-10-02 13:28:15',NULL,'2025-10-02 13:29:22',1,218,NULL,'b50be4d5-612a-4434-8eb6-55d27bed7a4d','hw_rng_model','virtio'),('2025-10-02 13:28:15',NULL,'2025-10-02 13:29:22',1,219,NULL,'b50be4d5-612a-4434-8eb6-55d27bed7a4d','image_id','423b8b5f-aab8-418b-8fad-d82c90818bdd'),('2025-10-02 13:28:15',NULL,'2025-10-02 13:29:22',1,220,NULL,'b50be4d5-612a-4434-8eb6-55d27bed7a4d','image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 13:28:15',NULL,'2025-10-02 13:29:22',1,221,NULL,'b50be4d5-612a-4434-8eb6-55d27bed7a4d','checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 13:28:15',NULL,'2025-10-02 13:29:22',1,222,NULL,'b50be4d5-612a-4434-8eb6-55d27bed7a4d','container_format','bare'),('2025-10-02 13:28:15',NULL,'2025-10-02 13:29:22',1,223,NULL,'b50be4d5-612a-4434-8eb6-55d27bed7a4d','disk_format','qcow2'),('2025-10-02 13:28:15',NULL,'2025-10-02 13:29:22',1,224,NULL,'b50be4d5-612a-4434-8eb6-55d27bed7a4d','min_disk','0'),('2025-10-02 13:28:15',NULL,'2025-10-02 13:29:22',1,225,NULL,'b50be4d5-612a-4434-8eb6-55d27bed7a4d','min_ram','0'),('2025-10-02 13:28:15',NULL,'2025-10-02 13:29:22',1,226,NULL,'b50be4d5-612a-4434-8eb6-55d27bed7a4d','size','21430272'),('2025-10-02 13:28:25',NULL,'2025-10-02 13:29:17',1,227,'4f5d24ac-9e35-4d38-a9e7-6dec734d8ef8',NULL,'signature_verified','False'),('2025-10-02 13:28:25',NULL,'2025-10-02 13:29:17',1,228,'4f5d24ac-9e35-4d38-a9e7-6dec734d8ef8',NULL,'hw_rng_model','virtio'),('2025-10-02 13:28:25',NULL,'2025-10-02 13:29:17',1,229,'4f5d24ac-9e35-4d38-a9e7-6dec734d8ef8',NULL,'image_id','423b8b5f-aab8-418b-8fad-d82c90818bdd'),('2025-10-02 13:28:25',NULL,'2025-10-02 13:29:17',1,230,'4f5d24ac-9e35-4d38-a9e7-6dec734d8ef8',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 13:28:25',NULL,'2025-10-02 13:29:17',1,231,'4f5d24ac-9e35-4d38-a9e7-6dec734d8ef8',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 13:28:25',NULL,'2025-10-02 13:29:17',1,232,'4f5d24ac-9e35-4d38-a9e7-6dec734d8ef8',NULL,'container_format','bare'),('2025-10-02 13:28:25',NULL,'2025-10-02 13:29:17',1,233,'4f5d24ac-9e35-4d38-a9e7-6dec734d8ef8',NULL,'disk_format','qcow2'),('2025-10-02 13:28:25',NULL,'2025-10-02 13:29:17',1,234,'4f5d24ac-9e35-4d38-a9e7-6dec734d8ef8',NULL,'min_disk','0'),('2025-10-02 13:28:25',NULL,'2025-10-02 13:29:17',1,235,'4f5d24ac-9e35-4d38-a9e7-6dec734d8ef8',NULL,'min_ram','0'),('2025-10-02 13:28:25',NULL,'2025-10-02 13:29:17',1,236,'4f5d24ac-9e35-4d38-a9e7-6dec734d8ef8',NULL,'size','21430272'),('2025-10-02 13:29:56',NULL,'2025-10-02 13:32:35',1,237,'c345d50c-19ab-4a23-a4a8-f7c734528d26',NULL,'signature_verified','False'),('2025-10-02 13:30:01',NULL,'2025-10-02 13:32:35',1,238,'c345d50c-19ab-4a23-a4a8-f7c734528d26',NULL,'hw_rng_model','virtio'),('2025-10-02 13:30:01',NULL,'2025-10-02 13:32:35',1,239,'c345d50c-19ab-4a23-a4a8-f7c734528d26',NULL,'image_id','423b8b5f-aab8-418b-8fad-d82c90818bdd'),('2025-10-02 13:30:01',NULL,'2025-10-02 13:32:35',1,240,'c345d50c-19ab-4a23-a4a8-f7c734528d26',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 13:30:01',NULL,'2025-10-02 13:32:35',1,241,'c345d50c-19ab-4a23-a4a8-f7c734528d26',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 13:30:01',NULL,'2025-10-02 13:32:35',1,242,'c345d50c-19ab-4a23-a4a8-f7c734528d26',NULL,'container_format','bare'),('2025-10-02 13:30:01',NULL,'2025-10-02 13:32:35',1,243,'c345d50c-19ab-4a23-a4a8-f7c734528d26',NULL,'disk_format','qcow2'),('2025-10-02 13:30:01',NULL,'2025-10-02 13:32:35',1,244,'c345d50c-19ab-4a23-a4a8-f7c734528d26',NULL,'min_disk','0'),('2025-10-02 13:30:01',NULL,'2025-10-02 13:32:35',1,245,'c345d50c-19ab-4a23-a4a8-f7c734528d26',NULL,'min_ram','0'),('2025-10-02 13:30:01',NULL,'2025-10-02 13:32:35',1,246,'c345d50c-19ab-4a23-a4a8-f7c734528d26',NULL,'size','21430272'),('2025-10-02 13:31:28',NULL,'2025-10-02 13:32:25',1,247,NULL,'5ac72b12-8cbc-4ea2-b384-7b18311bda08','signature_verified','False'),('2025-10-02 13:31:28',NULL,'2025-10-02 13:32:25',1,248,NULL,'5ac72b12-8cbc-4ea2-b384-7b18311bda08','hw_rng_model','virtio'),('2025-10-02 13:31:28',NULL,'2025-10-02 13:32:25',1,249,NULL,'5ac72b12-8cbc-4ea2-b384-7b18311bda08','image_id','423b8b5f-aab8-418b-8fad-d82c90818bdd'),('2025-10-02 13:31:28',NULL,'2025-10-02 13:32:25',1,250,NULL,'5ac72b12-8cbc-4ea2-b384-7b18311bda08','image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 13:31:28',NULL,'2025-10-02 13:32:25',1,251,NULL,'5ac72b12-8cbc-4ea2-b384-7b18311bda08','checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 13:31:28',NULL,'2025-10-02 13:32:25',1,252,NULL,'5ac72b12-8cbc-4ea2-b384-7b18311bda08','container_format','bare'),('2025-10-02 13:31:28',NULL,'2025-10-02 13:32:25',1,253,NULL,'5ac72b12-8cbc-4ea2-b384-7b18311bda08','disk_format','qcow2'),('2025-10-02 13:31:28',NULL,'2025-10-02 13:32:25',1,254,NULL,'5ac72b12-8cbc-4ea2-b384-7b18311bda08','min_disk','0'),('2025-10-02 13:31:28',NULL,'2025-10-02 13:32:25',1,255,NULL,'5ac72b12-8cbc-4ea2-b384-7b18311bda08','min_ram','0'),('2025-10-02 13:31:28',NULL,'2025-10-02 13:32:25',1,256,NULL,'5ac72b12-8cbc-4ea2-b384-7b18311bda08','size','21430272'),('2025-10-02 13:31:30',NULL,'2025-10-02 13:32:23',1,257,'b03ecca0-5e5d-47a6-a97b-d3273a126768',NULL,'signature_verified','False'),('2025-10-02 13:31:30',NULL,'2025-10-02 13:32:23',1,258,'b03ecca0-5e5d-47a6-a97b-d3273a126768',NULL,'hw_rng_model','virtio'),('2025-10-02 13:31:30',NULL,'2025-10-02 13:32:23',1,259,'b03ecca0-5e5d-47a6-a97b-d3273a126768',NULL,'image_id','423b8b5f-aab8-418b-8fad-d82c90818bdd'),('2025-10-02 13:31:30',NULL,'2025-10-02 13:32:23',1,260,'b03ecca0-5e5d-47a6-a97b-d3273a126768',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 13:31:30',NULL,'2025-10-02 13:32:23',1,261,'b03ecca0-5e5d-47a6-a97b-d3273a126768',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 13:31:30',NULL,'2025-10-02 13:32:23',1,262,'b03ecca0-5e5d-47a6-a97b-d3273a126768',NULL,'container_format','bare'),('2025-10-02 13:31:30',NULL,'2025-10-02 13:32:23',1,263,'b03ecca0-5e5d-47a6-a97b-d3273a126768',NULL,'disk_format','qcow2'),('2025-10-02 13:31:30',NULL,'2025-10-02 13:32:23',1,264,'b03ecca0-5e5d-47a6-a97b-d3273a126768',NULL,'min_disk','0'),('2025-10-02 13:31:30',NULL,'2025-10-02 13:32:23',1,265,'b03ecca0-5e5d-47a6-a97b-d3273a126768',NULL,'min_ram','0'),('2025-10-02 13:31:30',NULL,'2025-10-02 13:32:23',1,266,'b03ecca0-5e5d-47a6-a97b-d3273a126768',NULL,'size','21430272');
/*!40000 ALTER TABLE `volume_glance_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_metadata`
--

DROP TABLE IF EXISTS `volume_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_metadata`
--

LOCK TABLES `volume_metadata` WRITE;
/*!40000 ALTER TABLE `volume_metadata` DISABLE KEYS */;
INSERT INTO `volume_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `key`, `value`) VALUES ('2025-10-02 12:46:07',NULL,'2025-10-02 12:46:17',1,1,'9768160b-2679-45e0-b0ab-1552e9d2ac55','Type','work'),('2025-10-02 12:46:08',NULL,'2025-10-02 12:46:15',1,2,'77d97836-64eb-4ee4-927d-89f2d934fa6e','Type','work'),('2025-10-02 12:46:10',NULL,'2025-10-02 12:46:14',1,3,'7495c0e2-71df-4630-8a34-83bad33d0392','Type','work'),('2025-10-02 12:49:37',NULL,'2025-10-02 12:49:42',1,4,'4ff31f3a-dc9d-4134-93a3-2fd50e79dd74','Type','work'),('2025-10-02 13:14:09',NULL,'2025-10-02 13:15:06',1,5,'322bbc88-53a2-4cfe-95f7-44d52cc69f65','src_backup_id','8b50465d-c0cc-42cb-9644-ae2739806f2b');
/*!40000 ALTER TABLE `volume_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_extra_specs`
--

DROP TABLE IF EXISTS `volume_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_extra_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_type_extra_specs_volume_type_id` (`volume_type_id`),
  CONSTRAINT `volume_type_extra_specs_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_extra_specs`
--

LOCK TABLES `volume_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `volume_type_extra_specs` DISABLE KEYS */;
INSERT INTO `volume_type_extra_specs` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_type_id`, `key`, `value`) VALUES ('2025-10-02 12:07:52',NULL,NULL,0,1,'5e6146ac-1671-44a7-8fce-42cadebadfea','multiattach','<is> True');
/*!40000 ALTER TABLE `volume_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_projects`
--

DROP TABLE IF EXISTS `volume_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `volume_type_id` (`volume_type_id`,`project_id`,`deleted`),
  CONSTRAINT `volume_type_projects_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_projects`
--

LOCK TABLES `volume_type_projects` WRITE;
/*!40000 ALTER TABLE `volume_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_types`
--

DROP TABLE IF EXISTS `volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `qos_specs_id` varchar(36) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_types_qos_specs_id` (`qos_specs_id`),
  CONSTRAINT `volume_types_ibfk_1` FOREIGN KEY (`qos_specs_id`) REFERENCES `quality_of_service_specs` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_types`
--

LOCK TABLES `volume_types` WRITE;
/*!40000 ALTER TABLE `volume_types` DISABLE KEYS */;
INSERT INTO `volume_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `qos_specs_id`, `is_public`, `description`) VALUES ('2025-10-02 12:47:04',NULL,'2025-10-02 12:51:20',1,'1a006eb0-25fa-49ae-8528-4bdc937bccec','tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-458173846-524194211',NULL,1,NULL),('2025-10-02 12:47:04',NULL,'2025-10-02 12:51:20',1,'256fd643-1ca4-4479-81f4-fa19f71208ce','tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1845639578-27731657',NULL,1,NULL),('2025-10-02 13:02:33',NULL,'2025-10-02 13:03:35',1,'497d6bcf-12c9-4156-a02e-bb36fbdb2b78','tempest-scenario-type-luks-1564408968',NULL,1,NULL),('2025-10-02 12:07:50',NULL,NULL,0,'5e6146ac-1671-44a7-8fce-42cadebadfea','multiattach',NULL,1,NULL),('2025-10-02 11:29:59','2025-10-02 11:29:59',NULL,0,'73cd3555-fc9d-4e48-a14b-3667d6c50115','__DEFAULT__',NULL,1,'Default Volume Type'),('2025-10-02 13:26:05',NULL,'2025-10-02 13:26:38',1,'f6d2aaa1-dac0-429f-8dde-c2998faa98bb','tempest-scenario-type-luks-703155325',NULL,1,NULL),('2025-10-02 12:47:00',NULL,'2025-10-02 12:51:26',1,'faf29980-f597-40c8-8b37-5ca585e4970f','tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-963401591-1280362666',NULL,1,NULL);
/*!40000 ALTER TABLE `volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ec2_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(256) DEFAULT NULL,
  `provider_auth` varchar(256) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `source_volid` varchar(36) DEFAULT NULL,
  `bootable` tinyint(1) DEFAULT NULL,
  `provider_geometry` varchar(255) DEFAULT NULL,
  `_name_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `migration_status` varchar(255) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  `replication_extended_status` varchar(255) DEFAULT NULL,
  `replication_driver_data` varchar(255) DEFAULT NULL,
  `consistencygroup_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `multiattach` tinyint(1) DEFAULT NULL,
  `previous_status` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `group_id` varchar(36) DEFAULT NULL,
  `service_uuid` varchar(36) DEFAULT NULL,
  `shared_targets` tinyint(1) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `volumes_service_uuid_idx` (`service_uuid`,`deleted`),
  KEY `ix_volumes_group_id` (`group_id`),
  KEY `ix_volumes_consistencygroup_id` (`consistencygroup_id`),
  KEY `volumes_deleted_project_id_idx` (`deleted`,`project_id`),
  KEY `volumes_deleted_host_idx` (`deleted`,`host`),
  CONSTRAINT `volumes_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `volumes_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `volumes_ibfk_3` FOREIGN KEY (`service_uuid`) REFERENCES `services` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
INSERT INTO `volumes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `ec2_id`, `user_id`, `project_id`, `host`, `size`, `availability_zone`, `status`, `attach_status`, `scheduled_at`, `launched_at`, `terminated_at`, `display_name`, `display_description`, `provider_location`, `provider_auth`, `snapshot_id`, `volume_type_id`, `source_volid`, `bootable`, `provider_geometry`, `_name_id`, `encryption_key_id`, `migration_status`, `replication_status`, `replication_extended_status`, `replication_driver_data`, `consistencygroup_id`, `provider_id`, `multiattach`, `previous_status`, `cluster_name`, `group_id`, `service_uuid`, `shared_targets`, `use_quota`) VALUES ('2025-10-02 13:01:21','2025-10-02 13:01:46','2025-10-02 13:01:50',1,'04f00d16-4d54-4085-a9eb-bc69d5b5e61c',NULL,'57a1608ca1fc4bef8b6bc6ad68be3999','0b15f29eb32d4c5cba98baa238cc12e1','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:01:21','2025-10-02 13:01:22','2025-10-02 13:01:46','tempest-AttachVolumeTestJSON-volume-1284983590',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:44:42','2025-10-02 12:46:47','2025-10-02 12:46:49',1,'09d0609f-de75-4d40-9319-5bfc837c5ee7',NULL,'b168e90f7c0c414ba26c576fb8706a80','c87621e5c0ba4f13abfff528143c1c00','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:44:43','2025-10-02 12:44:45','2025-10-02 12:46:47','tempest-ServerRescueNegativeTestJSON-volume-743331535',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:44:36','2025-10-02 12:45:51','2025-10-02 12:45:52',1,'0aae917b-e115-4c10-86ce-79d95317f8d0',NULL,'3151966e941f4652ba984616bfa760c7','f7e2edef094b4ba5a56a5ec5ffce911e','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:44:39','2025-10-02 12:44:40','2025-10-02 12:45:51','tempest-AttachVolumeShelveTestJSON-volume-817034687',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:20:55','2025-10-02 12:24:02','2025-10-02 12:24:07',1,'0de00a00-9b68-498b-8bd0-88556bd22393',NULL,'b978e493dbdc419e864471708c90b0b4','dcab4f3b7c604f47befdd0a52db26eea','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:20:55','2025-10-02 12:21:08','2025-10-02 12:24:02','tempest-TaggedBootDevicesTest-volume-835038130',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:41:16','2025-10-02 12:45:16','2025-10-02 12:45:17',1,'13e98bdf-a59c-4cec-a1d4-6b0f09d31497',NULL,'17a0940c9daf48ac8cfa6c3e56d0e39c','88141e38aa2347299e7ab249431ef68c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:41:17','2025-10-02 12:41:17','2025-10-02 12:45:16','tempest-ServerActionsTestOtherA-volume-642114740',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 13:11:36','2025-10-02 13:12:20','2025-10-02 13:12:22',1,'19b06699-b688-462a-890e-57ac19f2d9e6',NULL,'156cc6022c70402ab6d194a340b076d5','9f85b8f387b146d29eabe946c4fbdee8','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:11:36','2025-10-02 13:11:53','2025-10-02 13:12:20','tempest-AttachVolumeMultiAttachTest-volume-156910844',NULL,'{\"saved_features\":61}',NULL,NULL,'5e6146ac-1671-44a7-8fce-42cadebadfea',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:18:20','2025-10-02 12:18:23','2025-10-02 12:18:24',1,'1f6327ea-b184-4aeb-ae41-b4ee97f872a3',NULL,'3c53fbb5ed1e4cf380a90975be5dc249','96eda2c1552247d8b6632dd9e7d1f6df','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:18:21','2025-10-02 12:18:21','2025-10-02 12:18:23','tempest-VolumesAdminNegativeTest-volume-298990363',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 13:14:38','2025-10-02 13:17:20','2025-10-02 13:17:21',1,'205d78a9-2344-4c93-8e1b-54d92d0b0fa2',NULL,'37083e5fd56c447cb409b86d6394dd43','7f5376733aec4630998da8d11db76561','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:14:38','2025-10-02 13:14:38','2025-10-02 13:17:20','tempest-AttachVolumeNegativeTest-volume-1848758056',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:17:00','2025-10-02 12:18:10','2025-10-02 12:18:10',1,'20a19061-0239-43b4-b9d7-980e7acde072',NULL,'e0cdfd1473bd4963b4ded642a43c35f3','7f6188e258a04ea1a49e6b415bce3fc9','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:17:00','2025-10-02 12:17:12','2025-10-02 12:18:10','tempest-tempest.common.compute-volume-3240330',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 13:09:15','2025-10-02 13:13:01','2025-10-02 13:13:05',1,'2341c515-f8fa-4cdf-87e9-1faa534d8307',NULL,'156cc6022c70402ab6d194a340b076d5','9f85b8f387b146d29eabe946c4fbdee8','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:09:15','2025-10-02 13:09:16','2025-10-02 13:13:01','tempest-AttachVolumeMultiAttachTest-volume-528685809',NULL,'{\"saved_features\":61}',NULL,NULL,'5e6146ac-1671-44a7-8fce-42cadebadfea',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 13:09:42','2025-10-02 13:11:31','2025-10-02 13:11:32',1,'23ece991-964a-4523-b231-9590440c3d93',NULL,'62f4c4b5cc194bd59ca9cc9f1da78a79','954946ff6b204fba90f767ec67210620','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:09:42','2025-10-02 13:09:49','2025-10-02 13:11:31','tempest-tempest.common.compute-volume-2095253644',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 13:26:57','2025-10-02 13:27:09','2025-10-02 13:27:10',1,'2426a7f5-76f6-42eb-8c88-184ea4203bdd',NULL,'2cb47684d0b34c729e9611e7b3943bed','18799a1c93354809911705bb424e673f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:26:58','2025-10-02 13:26:59','2025-10-02 13:27:09','','',NULL,NULL,'9ae89550-43b8-4753-be7a-188d37df60ee','73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 13:07:56','2025-10-02 13:13:29','2025-10-02 13:13:31',1,'3014eaef-bad8-4a87-9136-52199fbc69cb',NULL,'156cc6022c70402ab6d194a340b076d5','9f85b8f387b146d29eabe946c4fbdee8','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:07:56','2025-10-02 13:08:07','2025-10-02 13:13:29','tempest-AttachVolumeMultiAttachTest-volume-2101214205',NULL,'{\"saved_features\":61}',NULL,NULL,'5e6146ac-1671-44a7-8fce-42cadebadfea',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 13:14:06','2025-10-02 13:15:04','2025-10-02 13:15:06',1,'322bbc88-53a2-4cfe-95f7-44d52cc69f65',NULL,'216ca241b0c548969467dd331a0d31ef','f75652686f7d404a965745c02c9bb8e0','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:14:06','2025-10-02 13:14:06','2025-10-02 13:15:04','tempest-TestVolumeBackupRestore-volume-2033633756',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 13:04:29','2025-10-02 13:07:08','2025-10-02 13:07:09',1,'331c2dd5-b599-4925-a3ad-b6e1146e0de7',NULL,'5206d24fd75a48758994a57e7fd259f2','52dd3c4419794d0fbecd536c5088c60f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:04:29','2025-10-02 13:04:29','2025-10-02 13:07:08','tempest-ServersNegativeTestJSON-volume-1367604912',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 13:17:30','2025-10-02 13:17:35','2025-10-02 13:17:36',1,'344c67a5-2b4e-4bc2-9ae2-4634e1a7646e',NULL,'e3774ac023a94d05b47d4d7871236a37','9d6e19e05bf0433a9d26f845522d79b4','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:17:30','2025-10-02 13:17:30','2025-10-02 13:17:35','tempest-VolumesSnapshotsTestJSON-volume-1873264918',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:25:16','2025-10-02 12:28:16','2025-10-02 12:28:19',1,'3cae6300-aa08-440b-8899-aaa48fab86bd',NULL,'94e0e2f26a1648368032ab7e6732655c','6d96bae071ef4595bd93c956dd20796c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:25:16','2025-10-02 12:25:17','2025-10-02 12:28:16','tempest-TaggedBootDevicesTest_v242-volume-1661039737',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 13:13:43','2025-10-02 13:14:52','2025-10-02 13:14:53',1,'426f9568-783a-4516-9da0-22cf58dd8632',NULL,'81db307ac1f846188ce19b644ebcc396','cbaefa5c700c4ed495a5244732eed7e3','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:13:43','2025-10-02 13:13:44','2025-10-02 13:14:52','tempest-TestStampPattern-volume-630437609',NULL,NULL,NULL,'f043ab4d-d32c-42e5-bd46-8b477284e706','73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 13:02:35','2025-10-02 13:03:31','2025-10-02 13:03:33',1,'4318daa3-7890-4295-9085-fac3e8976380',NULL,'cb1643b3981d49ceaebfabe1577596fd','6e8f1f6ceb7b40ee9fa002d881b59a44','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:02:35','2025-10-02 13:02:47','2025-10-02 13:03:31','tempest-TestEncryptedCinderVolumes-volume-1813056238',NULL,NULL,NULL,NULL,'497d6bcf-12c9-4156-a02e-bb36fbdb2b78',NULL,0,NULL,NULL,'c869a339-7d8b-47df-83d3-eb6943847d77',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:47:15','2025-10-02 12:51:13','2025-10-02 12:51:15',1,'4ce2a695-6966-417a-847c-61fce9c9533c',NULL,'e3cd62a3208649c183d3fc2edc1c0f18','d3e0300f3cf5493d8a9e62e2c4a95767','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:47:15','2025-10-02 12:47:29','2025-10-02 12:51:13','tempest-TestInstancesWithCinderVolumes-volume-1022232751',NULL,NULL,NULL,NULL,'faf29980-f597-40c8-8b37-5ca585e4970f',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:10:15','2025-10-02 12:11:18','2025-10-02 12:11:19',1,'4eee902f-54cd-4f12-8095-b5f306236ae9',NULL,'3cd040a5b7f04e9c9dca681a59e324f6','a5b7ebf61d0a43d39a837b14d0530c61','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:10:15','2025-10-02 12:10:18','2025-10-02 12:11:18','tempest-VolumesAssistedSnapshotsTest-volume-625008815',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 13:28:24','2025-10-02 13:29:15','2025-10-02 13:29:17',1,'4f5d24ac-9e35-4d38-a9e7-6dec734d8ef8',NULL,'2cb47684d0b34c729e9611e7b3943bed','18799a1c93354809911705bb424e673f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:28:24','2025-10-02 13:28:25','2025-10-02 13:29:15','','',NULL,NULL,'b50be4d5-612a-4434-8eb6-55d27bed7a4d','73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:49:37','2025-10-02 12:49:40','2025-10-02 12:49:42',1,'4ff31f3a-dc9d-4134-93a3-2fd50e79dd74',NULL,'d531375ce55047caaac676156894af82','a5f0c507e8754b67a03586ed76d09b47','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:49:37','2025-10-02 12:49:38','2025-10-02 12:49:40','tempest-VolumesGetTestJSON-Volume-869502064',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 13:19:58','2025-10-02 13:21:12','2025-10-02 13:21:12',1,'501f7163-061f-4829-9c05-ac69ebd0ace5',NULL,'74f5186fabfb4fea86d32c8ef1f2e354','ced4d30c525c44cca617c3b9838d21b7','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:19:59','2025-10-02 13:19:59','2025-10-02 13:21:12','tempest-TestMinimumBasicScenario-volume-941735096',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:42:48','2025-10-02 12:48:02','2025-10-02 12:48:03',1,'542f01f7-7f03-41d9-ba07-cf427bf3007f',NULL,'ae7bcf1e6a3b4132a7068b0f863ca79c','58b2fa4ee0cd4b97be1b303c203be14f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:42:48','2025-10-02 12:42:49','2025-10-02 12:48:02','tempest-DeleteServersTestJSON-volume-387957983',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:47:05','2025-10-02 12:48:50','2025-10-02 12:48:54',1,'58e4ef18-7a31-4027-a9e7-0cc5f7920707',NULL,'e3cd62a3208649c183d3fc2edc1c0f18','d3e0300f3cf5493d8a9e62e2c4a95767','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:47:06','2025-10-02 12:47:06','2025-10-02 12:48:50','tempest-TestInstancesWithCinderVolumes-volume-691725197',NULL,NULL,NULL,NULL,'1a006eb0-25fa-49ae-8528-4bdc937bccec',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:23:29','2025-10-02 12:26:07','2025-10-02 12:26:10',1,'5957fb80-298a-4379-a0ba-fde86e2113d0',NULL,'51b45ef40bdc499a8409fd2bf3e6a339','12dfeaa31a6e4a2481a5332ce3094262','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:23:29','2025-10-02 12:23:31','2025-10-02 12:26:07','tempest-UpdateMultiattachVolumeNegativeTest-volume-392595611',NULL,'{\"saved_features\":61}',NULL,NULL,'5e6146ac-1671-44a7-8fce-42cadebadfea',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:47:05','2025-10-02 12:48:43','2025-10-02 12:48:50',1,'59930c46-79e6-4eb5-b8a0-3382452117c0',NULL,'e3cd62a3208649c183d3fc2edc1c0f18','d3e0300f3cf5493d8a9e62e2c4a95767','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:47:05','2025-10-02 12:47:05','2025-10-02 12:48:43','tempest-TestInstancesWithCinderVolumes-volume-772729388',NULL,NULL,NULL,NULL,'256fd643-1ca4-4479-81f4-fa19f71208ce',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 13:17:04','2025-10-02 13:17:17','2025-10-02 13:17:18',1,'60bad5ae-8a46-4e2e-abef-fbab46d4d0c9',NULL,'37083e5fd56c447cb409b86d6394dd43','7f5376733aec4630998da8d11db76561','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:17:04','2025-10-02 13:17:04','2025-10-02 13:17:17','tempest-AttachVolumeNegativeTest-volume-959109841',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:42:32','2025-10-02 12:45:52','2025-10-02 12:45:55',1,'6ff47fe7-ec04-463b-9d03-426ce1963408',NULL,'3151966e941f4652ba984616bfa760c7','f7e2edef094b4ba5a56a5ec5ffce911e','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:42:32','2025-10-02 12:42:32','2025-10-02 12:45:52','tempest-AttachVolumeShelveTestJSON-volume-2110384757',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:59:08','2025-10-02 13:01:53','2025-10-02 13:01:55',1,'73427f9e-6c2e-43a3-a2f1-b8df606e61c3',NULL,'57a1608ca1fc4bef8b6bc6ad68be3999','0b15f29eb32d4c5cba98baa238cc12e1','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:59:08','2025-10-02 12:59:09','2025-10-02 13:01:53','tempest-AttachVolumeTestJSON-volume-1280681268',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:46:10','2025-10-02 12:46:13','2025-10-02 12:46:14',1,'7495c0e2-71df-4630-8a34-83bad33d0392',NULL,'a6364dab92d24051b0d97ee76b8bc460','9a677c6c10fd4da0af5ed44e13f0b6ff','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:46:10','2025-10-02 12:46:10','2025-10-02 12:46:13','tempest-VolumesTestJSON-volume-1989750170',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:39:56','2025-10-02 12:42:34','2025-10-02 12:42:34',1,'76444907-9f59-47f1-99d8-aa820d2e0f3a',NULL,'fdbe447f49374937a828d6281949a2a4','a79bb765ab1e4aa18672c9641b6187b9','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:39:57','2025-10-02 12:39:58','2025-10-02 12:42:34','tempest-ServerStableDeviceRescueTest-volume-554407778',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:46:08','2025-10-02 12:46:15','2025-10-02 12:46:15',1,'77d97836-64eb-4ee4-927d-89f2d934fa6e',NULL,'a6364dab92d24051b0d97ee76b8bc460','9a677c6c10fd4da0af5ed44e13f0b6ff','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:46:09','2025-10-02 12:46:09','2025-10-02 12:46:15','tempest-VolumesTestJSON-volume-410618940',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:47:07','2025-10-02 12:50:26','2025-10-02 12:50:31',1,'77e42bdf-1989-460b-aa47-82eb53d89208',NULL,'e3cd62a3208649c183d3fc2edc1c0f18','d3e0300f3cf5493d8a9e62e2c4a95767','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:47:07','2025-10-02 12:47:07','2025-10-02 12:50:26','tempest-TestInstancesWithCinderVolumes-volume-768063874',NULL,NULL,NULL,NULL,'1a006eb0-25fa-49ae-8528-4bdc937bccec',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 13:10:00','2025-10-02 13:12:25','2025-10-02 13:12:39',1,'8347daf9-f32f-4c50-b89e-df9e913044db',NULL,'156cc6022c70402ab6d194a340b076d5','9f85b8f387b146d29eabe946c4fbdee8','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:10:00','2025-10-02 13:10:00','2025-10-02 13:12:25','tempest-AttachVolumeMultiAttachTest-volume-1790234092',NULL,'{\"saved_features\":61}',NULL,NULL,'5e6146ac-1671-44a7-8fce-42cadebadfea',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:47:17','2025-10-02 12:51:11','2025-10-02 12:51:13',1,'83afd020-c3e2-4cb0-a15d-83739807079d',NULL,'e3cd62a3208649c183d3fc2edc1c0f18','d3e0300f3cf5493d8a9e62e2c4a95767','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:47:20','2025-10-02 12:47:41','2025-10-02 12:51:11','tempest-TestInstancesWithCinderVolumes-volume-59265114',NULL,NULL,NULL,NULL,'faf29980-f597-40c8-8b37-5ca585e4970f',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 13:26:39','2025-10-02 13:27:12','2025-10-02 13:27:14',1,'8c46a235-cbac-44eb-b1b6-0f232670dbd3',NULL,'2cb47684d0b34c729e9611e7b3943bed','18799a1c93354809911705bb424e673f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:26:39','2025-10-02 13:26:48','2025-10-02 13:27:12','tempest-TestVolumeBootPattern-volume-origin-1943235194',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:34:53','2025-10-02 12:35:54','2025-10-02 12:35:55',1,'9283cdcd-9233-4064-a250-5d9e278af430',NULL,'32f902c540fc464cb232c0a6942a5d22','5c7832aaed82459e908e73712013728c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:34:53','2025-10-02 12:35:08','2025-10-02 12:35:54','tempest-tempest.common.compute-volume-736839890',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:56:33','2025-10-02 12:57:30',NULL,0,'93f6251c-1119-43b6-b608-e405dc9beae8',NULL,'00be63ea13c84e3d9419078865524099','cb2da64acac041cb8d38c3b43fe4dbe9','hostgroup@ceph#ceph',1,'nova','available','detached','2025-10-02 12:56:33','2025-10-02 12:56:41',NULL,'','',NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:45:11','2025-10-02 12:46:44','2025-10-02 12:46:47',1,'9405efbb-874d-467a-93c3-bbd76870d422',NULL,'b168e90f7c0c414ba26c576fb8706a80','c87621e5c0ba4f13abfff528143c1c00','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:45:11','2025-10-02 12:45:11','2025-10-02 12:46:44','tempest-ServerRescueNegativeTestJSON-volume-1943816915',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:46:07','2025-10-02 12:46:16','2025-10-02 12:46:17',1,'9768160b-2679-45e0-b0ab-1552e9d2ac55',NULL,'a6364dab92d24051b0d97ee76b8bc460','9a677c6c10fd4da0af5ed44e13f0b6ff','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:46:07','2025-10-02 12:46:07','2025-10-02 12:46:16','tempest-VolumesTestJSON-volume-71172555',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:47:06','2025-10-02 12:49:39','2025-10-02 12:49:42',1,'9a0d7849-aa2a-475d-a21d-0d4dd0da6ab2',NULL,'e3cd62a3208649c183d3fc2edc1c0f18','d3e0300f3cf5493d8a9e62e2c4a95767','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:47:06','2025-10-02 12:47:06','2025-10-02 12:49:39','tempest-TestInstancesWithCinderVolumes-volume-1299143749',NULL,NULL,NULL,NULL,'1a006eb0-25fa-49ae-8528-4bdc937bccec',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:17:54','2025-10-02 12:18:30','2025-10-02 12:18:32',1,'9dd4f9e5-e2b6-4aab-8485-5208997de3a8',NULL,'3c53fbb5ed1e4cf380a90975be5dc249','96eda2c1552247d8b6632dd9e7d1f6df','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:17:54','2025-10-02 12:17:55','2025-10-02 12:18:30','tempest-VolumesAdminNegativeTest-volume-449836385',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 13:04:26','2025-10-02 13:07:09','2025-10-02 13:07:10',1,'a3ac5a28-a3da-469d-a324-5dd9026222ac',NULL,'5206d24fd75a48758994a57e7fd259f2','52dd3c4419794d0fbecd536c5088c60f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:04:26','2025-10-02 13:04:26','2025-10-02 13:07:09','tempest-ServersNegativeTestJSON-volume-1409912180',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:49:42','2025-10-02 12:52:05','2025-10-02 12:52:10',1,'a7bdd212-0d34-40b8-9af9-06388d215028',NULL,'af2648eefb594bc49309cccf408f7ae1','1308a7eb298f49baaeaf3dc3a6acf592','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:49:43','2025-10-02 12:49:58','2025-10-02 12:52:05','tempest-tempest.common.compute-volume-1501651023',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'reserved',NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:49:39','2025-10-02 12:53:51','2025-10-02 12:53:54',1,'ac1432a4-bab5-43b6-871c-71608985c7ae',NULL,'b5104e5372994cd19b720862cf1ca2ce','dbd0afdfb05849f9abfe4cd4454f6a13','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:49:39','2025-10-02 12:49:40','2025-10-02 12:53:51','tempest-ServerActionsTestOtherB-volume-1754209158',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:47:06','2025-10-02 12:50:20','2025-10-02 12:50:24',1,'ada5d5be-9d4c-4653-ac57-931c6322dea6',NULL,'e3cd62a3208649c183d3fc2edc1c0f18','d3e0300f3cf5493d8a9e62e2c4a95767','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:47:07','2025-10-02 12:47:07','2025-10-02 12:50:20','tempest-TestInstancesWithCinderVolumes-volume-152429590',NULL,NULL,NULL,NULL,'256fd643-1ca4-4479-81f4-fa19f71208ce',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:47:10','2025-10-02 12:51:15','2025-10-02 12:51:18',1,'aee976fe-a491-4491-adf3-8d226e48711d',NULL,'e3cd62a3208649c183d3fc2edc1c0f18','d3e0300f3cf5493d8a9e62e2c4a95767','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:47:11','2025-10-02 12:47:29','2025-10-02 12:51:15','tempest-TestInstancesWithCinderVolumes-volume-263878213',NULL,NULL,NULL,NULL,'faf29980-f597-40c8-8b37-5ca585e4970f',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 13:31:29','2025-10-02 13:32:22','2025-10-02 13:32:23',1,'b03ecca0-5e5d-47a6-a97b-d3273a126768',NULL,'2cb47684d0b34c729e9611e7b3943bed','18799a1c93354809911705bb424e673f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:31:30','2025-10-02 13:31:30','2025-10-02 13:32:22','tempest-TestVolumeBootPattern-volume-2026404800',NULL,NULL,NULL,'5ac72b12-8cbc-4ea2-b384-7b18311bda08','73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:23:32','2025-10-02 12:26:03','2025-10-02 12:26:06',1,'b153b2e4-51e9-4865-a38e-9b6c9a49adf0',NULL,'51b45ef40bdc499a8409fd2bf3e6a339','12dfeaa31a6e4a2481a5332ce3094262','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:23:32','2025-10-02 12:23:32','2025-10-02 12:26:03','tempest-UpdateMultiattachVolumeNegativeTest-volume-1339290152',NULL,'{\"saved_features\":61}',NULL,NULL,'5e6146ac-1671-44a7-8fce-42cadebadfea',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 13:18:19','2025-10-02 13:19:23','2025-10-02 13:19:24',1,'b43f69f8-7c8d-4ef5-af90-c5aa5656977e',NULL,'74f5186fabfb4fea86d32c8ef1f2e354','ced4d30c525c44cca617c3b9838d21b7','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:18:19','2025-10-02 13:18:20','2025-10-02 13:19:23','tempest-TestMinimumBasicScenario-volume-440363148',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:47:06','2025-10-02 12:49:34','2025-10-02 12:49:35',1,'b6b70d12-1f08-4fe5-adac-6ced9b30e04f',NULL,'e3cd62a3208649c183d3fc2edc1c0f18','d3e0300f3cf5493d8a9e62e2c4a95767','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:47:06','2025-10-02 12:47:06','2025-10-02 12:49:34','tempest-TestInstancesWithCinderVolumes-volume-1647860212',NULL,NULL,NULL,NULL,'256fd643-1ca4-4479-81f4-fa19f71208ce',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 13:01:15','2025-10-02 13:01:51','2025-10-02 13:01:52',1,'b91353e7-057c-43fc-be40-fbbc07072322',NULL,'57a1608ca1fc4bef8b6bc6ad68be3999','0b15f29eb32d4c5cba98baa238cc12e1','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:01:15','2025-10-02 13:01:16','2025-10-02 13:01:51','tempest-AttachVolumeTestJSON-volume-1426573201',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:21:09','2025-10-02 12:24:00','2025-10-02 12:24:01',1,'b93e6b37-6df0-4c49-81d5-526e5c68b542',NULL,'b978e493dbdc419e864471708c90b0b4','dcab4f3b7c604f47befdd0a52db26eea','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:21:12','2025-10-02 12:21:13','2025-10-02 12:24:00','tempest-TaggedBootDevicesTest-volume-758148281',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 13:29:53','2025-10-02 13:32:34','2025-10-02 13:32:35',1,'c345d50c-19ab-4a23-a4a8-f7c734528d26',NULL,'2cb47684d0b34c729e9611e7b3943bed','18799a1c93354809911705bb424e673f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:29:53','2025-10-02 13:30:01','2025-10-02 13:32:34','tempest-TestVolumeBootPattern-volume-origin-418453749',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 13:26:06','2025-10-02 13:26:33','2025-10-02 13:26:37',1,'c3c03e41-d6c3-4680-bbf8-a098e1bc3da4',NULL,'2cb47684d0b34c729e9611e7b3943bed','18799a1c93354809911705bb424e673f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:26:07','2025-10-02 13:26:14','2025-10-02 13:26:33','tempest-TestVolumeBootPattern-volume-1361479983',NULL,NULL,NULL,NULL,'f6d2aaa1-dac0-429f-8dde-c2998faa98bb',NULL,1,NULL,NULL,'5df1a5a9-8b62-44cc-bef4-5aec82b14056',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:32:22','2025-10-02 12:33:59','2025-10-02 12:34:00',1,'c9770430-1295-4cf9-8ead-017246f69f0a',NULL,'1c8eed6cb806403ca545bb7b2820714e','7846694bb70143aa984e235126fbe15c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:32:22','2025-10-02 12:32:23','2025-10-02 12:33:59','tempest-TaggedAttachmentsTest-volume-1171078103',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:25:13','2025-10-02 12:28:20','2025-10-02 12:28:21',1,'d87ab1d9-322f-4ca3-8b9b-14a670a2e320',NULL,'94e0e2f26a1648368032ab7e6732655c','6d96bae071ef4595bd93c956dd20796c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:25:14','2025-10-02 12:25:14','2025-10-02 12:28:20','tempest-TaggedBootDevicesTest_v242-volume-746523241',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 13:13:48','2025-10-02 13:15:04','2025-10-02 13:15:06',1,'d8e6ba23-d512-444c-9b18-1432ad9db22b',NULL,'216ca241b0c548969467dd331a0d31ef','f75652686f7d404a965745c02c9bb8e0','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:13:48','2025-10-02 13:13:57','2025-10-02 13:15:04','tempest-TestVolumeBackupRestore-volume-2033633756',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:24:54','2025-10-02 12:28:22','2025-10-02 12:28:23',1,'d91ade79-bea0-4f14-93f8-80a864c83dfa',NULL,'94e0e2f26a1648368032ab7e6732655c','6d96bae071ef4595bd93c956dd20796c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:24:55','2025-10-02 12:25:13','2025-10-02 12:28:22','tempest-TaggedBootDevicesTest_v242-volume-672304704',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 13:12:28','2025-10-02 13:15:10','2025-10-02 13:15:11',1,'d96c5d9f-6560-48dd-8bf0-55b9a4da462b',NULL,'81db307ac1f846188ce19b644ebcc396','cbaefa5c700c4ed495a5244732eed7e3','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:12:28','2025-10-02 13:12:31','2025-10-02 13:15:10','tempest-TestStampPattern-volume-123804681',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 13:16:13','2025-10-02 13:17:18','2025-10-02 13:17:19',1,'e2a88252-30d2-4853-bab0-09a8623bb9af',NULL,'37083e5fd56c447cb409b86d6394dd43','7f5376733aec4630998da8d11db76561','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:16:13','2025-10-02 13:16:13','2025-10-02 13:17:18','tempest-AttachVolumeNegativeTest-volume-1448247041',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:21:15','2025-10-02 12:23:57','2025-10-02 12:24:00',1,'f3584061-a34e-4c55-a201-ea9e5f60b3e5',NULL,'b978e493dbdc419e864471708c90b0b4','dcab4f3b7c604f47befdd0a52db26eea','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:21:16','2025-10-02 12:21:22','2025-10-02 12:23:57','tempest-TaggedBootDevicesTest-volume-2073702289',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:54:03','2025-10-02 12:57:43',NULL,0,'f80c06cb-0550-4a66-a7bd-bba5ed3d622f',NULL,'00be63ea13c84e3d9419078865524099','cb2da64acac041cb8d38c3b43fe4dbe9','hostgroup@ceph#ceph',1,'nova','available','detached','2025-10-02 12:54:03','2025-10-02 12:54:04',NULL,'58e2a72f-a2b9-41a0-9c67-607e978d8b88-blank-vol','',NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:24:27','2025-10-02 12:24:53','2025-10-02 12:24:58',1,'f9d9b67b-54c7-4f6f-b70f-7ca98b415001',NULL,'5c6bdc1acafd4db2bcc3e0251393b901','4a6d727642dc44b3997a0b35c67e6ab1','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:24:28','2025-10-02 12:24:29','2025-10-02 12:24:53','tempest-AttachSCSIVolumeTestJSON-volume-795837426',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:43:16','2025-10-02 12:45:09','2025-10-02 12:45:10',1,'fdc5e1d9-2228-4ec0-a6bb-8605f6207831',NULL,'17a0940c9daf48ac8cfa6c3e56d0e39c','88141e38aa2347299e7ab249431ef68c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:43:16','2025-10-02 12:43:31','2025-10-02 12:45:09','tempest-tempest.common.compute-volume-1626556385',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 12:13:54','2025-10-02 12:15:30','2025-10-02 12:15:30',1,'ff92c1da-c1e7-425c-b20d-f332daad4188',NULL,'d29391679bd0482aada18c987e4c11ca','4db2957ac1b546178a9f2c0f24807e5b','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:13:54','2025-10-02 12:14:12','2025-10-02 12:15:30','tempest-tempest.common.compute-volume-916919748',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1),('2025-10-02 13:27:17','2025-10-02 13:29:29','2025-10-02 13:29:35',1,'ffd00fca-313e-46cc-b503-d377c1529a56',NULL,'2cb47684d0b34c729e9611e7b3943bed','18799a1c93354809911705bb424e673f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:27:17','2025-10-02 13:27:31','2025-10-02 13:29:29','tempest-TestVolumeBootPattern-volume-origin-530415963',NULL,NULL,NULL,NULL,'73cd3555-fc9d-4e48-a14b-3667d6c50115',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'88483b7b-e1fa-4bbc-9c1a-c9d82454bc51',0,1);
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workers`
--

DROP TABLE IF EXISTS `workers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `workers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(40) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  `status` varchar(255) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_type` (`resource_type`,`resource_id`),
  KEY `ix_workers_service_id` (`service_id`),
  CONSTRAINT `workers_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=145 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workers`
--

LOCK TABLES `workers` WRITE;
/*!40000 ALTER TABLE `workers` DISABLE KEYS */;
INSERT INTO `workers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `resource_type`, `resource_id`, `status`, `service_id`, `race_preventer`) VALUES ('2025-10-02 11:29:59','2025-10-02 11:29:59.000123',NULL,0,1,'SENTINEL','SUB-SECOND','OK',NULL,0);
/*!40000 ALTER TABLE `workers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `glance`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `glance` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `glance`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('2023_1_contract01');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_locations`
--

DROP TABLE IF EXISTS `image_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `meta_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `ix_image_locations_deleted` (`deleted`),
  KEY `ix_image_locations_image_id` (`image_id`),
  CONSTRAINT `image_locations_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_locations`
--

LOCK TABLES `image_locations` WRITE;
/*!40000 ALTER TABLE `image_locations` DISABLE KEYS */;
INSERT INTO `image_locations` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `meta_data`, `status`) VALUES (1,'423b8b5f-aab8-418b-8fad-d82c90818bdd','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/423b8b5f-aab8-418b-8fad-d82c90818bdd/snap','2025-10-02 12:08:54','2025-10-02 12:08:54',NULL,0,'{\"store\": \"default_backend\"}','active'),(2,'52ef509e-0e22-464e-93c9-3ddcf574cd64','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/52ef509e-0e22-464e-93c9-3ddcf574cd64/snap','2025-10-02 12:08:57','2025-10-02 12:08:57',NULL,0,'{\"store\": \"default_backend\"}','active'),(3,'7fb9d0dd-1da7-4b33-8373-4bee7b325cfd','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/7fb9d0dd-1da7-4b33-8373-4bee7b325cfd/snap','2025-10-02 12:11:08','2025-10-02 12:11:13','2025-10-02 12:11:13',1,'{\"store\": \"default_backend\"}','deleted'),(4,'e47e8f63-f84e-437a-b1c3-8f7966140254','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/e47e8f63-f84e-437a-b1c3-8f7966140254/snap','2025-10-02 12:13:17','2025-10-02 12:13:46','2025-10-02 12:13:46',1,'{\"store\": \"default_backend\"}','deleted'),(5,'9f2e97bd-159f-41e5-875d-f066be38a116','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/9f2e97bd-159f-41e5-875d-f066be38a116/snap','2025-10-02 12:15:32','2025-10-02 12:15:36','2025-10-02 12:15:36',1,'{\"store\": \"default_backend\"}','deleted'),(6,'28a7bd8e-0ddc-4cda-9f64-7c1162716074','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/28a7bd8e-0ddc-4cda-9f64-7c1162716074/snap','2025-10-02 12:16:00','2025-10-02 12:16:10','2025-10-02 12:16:10',1,'{\"store\": \"default_backend\"}','deleted'),(7,'15e18cef-aa4b-424b-82b1-3a0edfa62ef7','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/15e18cef-aa4b-424b-82b1-3a0edfa62ef7/snap','2025-10-02 12:20:19','2025-10-02 12:20:21','2025-10-02 12:20:21',1,'{\"store\": \"default_backend\"}','deleted'),(8,'f573b04f-b850-41b8-8b32-8ba00d6690cd','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/f573b04f-b850-41b8-8b32-8ba00d6690cd/snap','2025-10-02 12:20:45','2025-10-02 12:21:06','2025-10-02 12:21:06',1,'{\"store\": \"default_backend\"}','deleted'),(9,'bc229961-c2ce-4076-a41e-7413c2291d5e','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/bc229961-c2ce-4076-a41e-7413c2291d5e/snap','2025-10-02 12:21:22','2025-10-02 12:21:33','2025-10-02 12:21:33',1,'{\"store\": \"default_backend\"}','deleted'),(10,'45a729a3-bfb9-4ba4-a275-e4201ada93ed','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/45a729a3-bfb9-4ba4-a275-e4201ada93ed/snap','2025-10-02 12:21:38','2025-10-02 12:22:06','2025-10-02 12:22:06',1,'{\"store\": \"default_backend\"}','deleted'),(11,'5e6784e9-638e-4f69-b9c1-8a81a55dc0ed','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/5e6784e9-638e-4f69-b9c1-8a81a55dc0ed/snap','2025-10-02 12:22:15','2025-10-02 12:22:22','2025-10-02 12:22:22',1,'{\"store\": \"default_backend\"}','deleted'),(12,'38906c7c-521b-42f0-a991-950eaae1ee1c','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/38906c7c-521b-42f0-a991-950eaae1ee1c/snap','2025-10-02 12:23:06','2025-10-02 12:23:40','2025-10-02 12:23:40',1,'{\"store\": \"default_backend\"}','deleted'),(13,'e7094a19-0695-4486-b083-e54642bc0338','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/e7094a19-0695-4486-b083-e54642bc0338/snap','2025-10-02 12:23:25','2025-10-02 12:24:51','2025-10-02 12:24:51',1,'{\"store\": \"default_backend\"}','deleted'),(14,'a74e1055-5470-4941-8188-b17381cbad4e','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/a74e1055-5470-4941-8188-b17381cbad4e/snap','2025-10-02 12:28:31','2025-10-02 12:30:20','2025-10-02 12:30:20',1,'{\"store\": \"default_backend\"}','deleted'),(15,'2e803658-b995-4556-a393-a91c1a77b934','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/2e803658-b995-4556-a393-a91c1a77b934/snap','2025-10-02 12:28:36','2025-10-02 12:30:10','2025-10-02 12:30:10',1,'{\"store\": \"default_backend\"}','deleted'),(16,'437d8b4c-c859-4756-900b-9c9295a3b60b','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/437d8b4c-c859-4756-900b-9c9295a3b60b/snap','2025-10-02 12:28:43','2025-10-02 12:30:03','2025-10-02 12:30:03',1,'{\"store\": \"default_backend\"}','deleted'),(17,'e63c0054-4f57-471e-a2d8-a929502f4104','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/e63c0054-4f57-471e-a2d8-a929502f4104/snap','2025-10-02 12:29:11','2025-10-02 12:29:52','2025-10-02 12:29:52',1,'{\"store\": \"default_backend\"}','deleted'),(18,'4038405e-7d51-444f-9567-0cdacfa79f42','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/4038405e-7d51-444f-9567-0cdacfa79f42/snap','2025-10-02 12:29:23','2025-10-02 12:29:50','2025-10-02 12:29:50',1,'{\"store\": \"default_backend\"}','deleted'),(19,'d0dced0b-1a65-4528-9713-633878d7128b','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/d0dced0b-1a65-4528-9713-633878d7128b/snap','2025-10-02 12:29:34','2025-10-02 12:29:46','2025-10-02 12:29:46',1,'{\"store\": \"default_backend\"}','deleted'),(20,'d47d5adb-8963-4735-aac4-73e6ace2936e','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/d47d5adb-8963-4735-aac4-73e6ace2936e/snap','2025-10-02 12:37:33','2025-10-02 12:42:58','2025-10-02 12:42:58',1,'{\"store\": \"default_backend\"}','deleted'),(21,'44da8c0b-0cdf-4949-9ff7-57e81c0d3d70','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/44da8c0b-0cdf-4949-9ff7-57e81c0d3d70/snap','2025-10-02 12:38:14','2025-10-02 12:42:48','2025-10-02 12:42:48',1,'{\"store\": \"default_backend\"}','deleted'),(22,'845ab049-b1a7-4b63-95d7-72464046ac90','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/845ab049-b1a7-4b63-95d7-72464046ac90/snap','2025-10-02 12:39:28','2025-10-02 12:42:37','2025-10-02 12:42:37',1,'{\"store\": \"default_backend\"}','deleted'),(23,'2d2735c8-c9f0-487a-8b58-3e359fca2f77','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/2d2735c8-c9f0-487a-8b58-3e359fca2f77/snap','2025-10-02 12:41:15','2025-10-02 12:42:23','2025-10-02 12:42:23',1,'{\"store\": \"default_backend\"}','deleted'),(24,'c37f4151-ac68-47f8-adfa-bd0c85e4c75d','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/c37f4151-ac68-47f8-adfa-bd0c85e4c75d/snap','2025-10-02 12:42:44','2025-10-02 12:43:13','2025-10-02 12:43:13',1,'{\"store\": \"default_backend\"}','deleted'),(25,'8ef5cf5e-703e-423e-815f-02321271fc3c','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/8ef5cf5e-703e-423e-815f-02321271fc3c/snap','2025-10-02 12:44:46','2025-10-02 12:45:07','2025-10-02 12:45:07',1,'{\"store\": \"default_backend\"}','deleted'),(26,'3866598c-0b46-42ff-ba05-28dab62cd167','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/3866598c-0b46-42ff-ba05-28dab62cd167/snap','2025-10-02 12:45:01','2025-10-02 12:45:29','2025-10-02 12:45:29',1,'{\"store\": \"default_backend\"}','deleted'),(27,'732edfd9-86ec-4c72-a1b2-37aec374791c','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/732edfd9-86ec-4c72-a1b2-37aec374791c/snap','2025-10-02 12:46:32','2025-10-02 12:46:59','2025-10-02 12:46:59',1,'{\"store\": \"default_backend\"}','deleted'),(28,'ab4ee30b-1b9c-4a28-9b76-c933be04775b','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/ab4ee30b-1b9c-4a28-9b76-c933be04775b/snap','2025-10-02 12:46:42','2025-10-02 12:47:06','2025-10-02 12:47:06',1,'{\"store\": \"default_backend\"}','deleted'),(29,'849a855e-6143-42a6-8855-a1bf327357a7','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/849a855e-6143-42a6-8855-a1bf327357a7/snap','2025-10-02 12:46:54','2025-10-02 12:47:04','2025-10-02 12:47:04',1,'{\"store\": \"default_backend\"}','deleted'),(30,'2de43632-5d51-4644-b4ab-edaca67d1e25','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/2de43632-5d51-4644-b4ab-edaca67d1e25/snap','2025-10-02 12:47:03','2025-10-02 12:51:25','2025-10-02 12:51:25',1,'{\"store\": \"default_backend\"}','deleted'),(31,'06496a06-9459-4a12-80f1-2f72dd513f0f','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/06496a06-9459-4a12-80f1-2f72dd513f0f/snap','2025-10-02 12:52:16','2025-10-02 12:53:45','2025-10-02 12:53:45',1,'{\"store\": \"default_backend\"}','deleted'),(32,'47596e8e-a667-4ff8-bd1f-3f35c36243ae','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/47596e8e-a667-4ff8-bd1f-3f35c36243ae/snap','2025-10-02 12:53:02','2025-10-02 12:53:40','2025-10-02 12:53:40',1,'{\"store\": \"default_backend\"}','deleted'),(33,'38d5e3ab-8ce6-4053-8f4a-2a76356bf535','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/38d5e3ab-8ce6-4053-8f4a-2a76356bf535/snap','2025-10-02 12:53:57','2025-10-02 12:57:47','2025-10-02 12:57:47',1,'{\"store\": \"default_backend\"}','deleted'),(34,'dbd87d84-17a6-4523-8be2-18de440d9003','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/dbd87d84-17a6-4523-8be2-18de440d9003/snap','2025-10-02 12:56:25','2025-10-02 12:57:35','2025-10-02 12:57:35',1,'{\"store\": \"default_backend\"}','deleted'),(35,'3560df73-c585-4179-87ca-fb0ca65743ee','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/3560df73-c585-4179-87ca-fb0ca65743ee/snap','2025-10-02 13:05:35','2025-10-02 13:06:14','2025-10-02 13:06:14',1,'{\"store\": \"default_backend\"}','deleted'),(36,'c7b69b23-2de1-4a42-80f6-94ba898e82eb','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/c7b69b23-2de1-4a42-80f6-94ba898e82eb/snap','2025-10-02 13:08:53','2025-10-02 13:09:15','2025-10-02 13:09:15',1,'{\"store\": \"default_backend\"}','deleted'),(37,'ce85db7b-3a9c-4836-a59c-ea52c9943289','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/ce85db7b-3a9c-4836-a59c-ea52c9943289/snap','2025-10-02 13:12:13','2025-10-02 13:12:24','2025-10-02 13:12:24',1,'{\"store\": \"default_backend\"}','deleted'),(38,'23101426-fbb2-4946-b9ce-fdcd0b2d5391','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/23101426-fbb2-4946-b9ce-fdcd0b2d5391/snap','2025-10-02 13:13:42','2025-10-02 13:14:56','2025-10-02 13:14:56',1,'{\"store\": \"default_backend\"}','deleted'),(39,'40dbc07f-c919-4d14-85e2-405ded1c3c40','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/40dbc07f-c919-4d14-85e2-405ded1c3c40/snap','2025-10-02 13:18:00','2025-10-02 13:19:32','2025-10-02 13:19:32',1,'{\"store\": \"default_backend\"}','deleted'),(40,'f6be8018-0ea2-42f8-a1d7-8d704069aac9','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/f6be8018-0ea2-42f8-a1d7-8d704069aac9/snap','2025-10-02 13:19:34','2025-10-02 13:21:21','2025-10-02 13:21:21',1,'{\"store\": \"default_backend\"}','deleted'),(41,'4dbf986e-53ef-4e53-875d-c9d73e683338','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/4dbf986e-53ef-4e53-875d-c9d73e683338/snap','2025-10-02 13:24:21','2025-10-02 13:25:27','2025-10-02 13:25:27',1,'{\"store\": \"default_backend\"}','deleted'),(42,'7337ab36-547f-4549-871f-2f16bbc93bb9','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/7337ab36-547f-4549-871f-2f16bbc93bb9/snap','2025-10-02 13:25:16','2025-10-02 13:25:19','2025-10-02 13:25:19',1,'{\"store\": \"default_backend\"}','deleted'),(43,'e0399c4c-8352-497f-b361-45e672712e68','rbd://20fdc58c-b037-5094-a8ef-d490aa7c36f3/images/e0399c4c-8352-497f-b361-45e672712e68/snap','2025-10-02 13:28:14','2025-10-02 13:29:43','2025-10-02 13:29:43',1,'{\"store\": \"default_backend\"}','deleted');
/*!40000 ALTER TABLE `image_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_members`
--

DROP TABLE IF EXISTS `image_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `member` varchar(255) NOT NULL,
  `can_share` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image_members_image_id_member_deleted_at_key` (`image_id`,`member`,`deleted_at`),
  KEY `ix_image_members_deleted` (`deleted`),
  KEY `ix_image_members_image_id` (`image_id`),
  KEY `ix_image_members_image_id_member` (`image_id`,`member`),
  CONSTRAINT `image_members_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`can_share` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_members`
--

LOCK TABLES `image_members` WRITE;
/*!40000 ALTER TABLE `image_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_properties`
--

DROP TABLE IF EXISTS `image_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_image_properties_image_id_name` (`image_id`,`name`),
  KEY `ix_image_properties_deleted` (`deleted`),
  KEY `ix_image_properties_image_id` (`image_id`),
  CONSTRAINT `image_properties_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=661 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_properties`
--

LOCK TABLES `image_properties` WRITE;
/*!40000 ALTER TABLE `image_properties` DISABLE KEYS */;
INSERT INTO `image_properties` (`id`, `image_id`, `name`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'423b8b5f-aab8-418b-8fad-d82c90818bdd','hw_rng_model','virtio','2025-10-02 12:08:46','2025-10-02 12:08:46',NULL,0),(2,'52ef509e-0e22-464e-93c9-3ddcf574cd64','hw_rng_model','virtio','2025-10-02 12:08:54','2025-10-02 12:08:54',NULL,0),(3,'e47e8f63-f84e-437a-b1c3-8f7966140254','os_version','alt1','2025-10-02 12:13:19','2025-10-02 12:13:46','2025-10-02 12:13:46',1),(4,'e47e8f63-f84e-437a-b1c3-8f7966140254','os_distro','value2','2025-10-02 12:13:19','2025-10-02 12:13:46','2025-10-02 12:13:46',1),(5,'e47e8f63-f84e-437a-b1c3-8f7966140254','architecture','value3','2025-10-02 12:13:25','2025-10-02 12:13:46','2025-10-02 12:13:46',1),(6,'9f2e97bd-159f-41e5-875d-f066be38a116','hw_rng_model','virtio','2025-10-02 12:15:26','2025-10-02 12:15:36','2025-10-02 12:15:36',1),(7,'9f2e97bd-159f-41e5-875d-f066be38a116','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 12:15:26','2025-10-02 12:15:36','2025-10-02 12:15:36',1),(8,'9f2e97bd-159f-41e5-875d-f066be38a116','owner_user_name','tempest-ImagesOneServerTestJSON-572210404-project-member','2025-10-02 12:15:26','2025-10-02 12:15:36','2025-10-02 12:15:36',1),(9,'9f2e97bd-159f-41e5-875d-f066be38a116','owner_project_name','tempest-ImagesOneServerTestJSON-572210404','2025-10-02 12:15:26','2025-10-02 12:15:36','2025-10-02 12:15:36',1),(10,'9f2e97bd-159f-41e5-875d-f066be38a116','boot_roles','reader,member','2025-10-02 12:15:26','2025-10-02 12:15:36','2025-10-02 12:15:36',1),(11,'9f2e97bd-159f-41e5-875d-f066be38a116','hw_machine_type','q35','2025-10-02 12:15:26','2025-10-02 12:15:36','2025-10-02 12:15:36',1),(12,'9f2e97bd-159f-41e5-875d-f066be38a116','hw_cdrom_bus','sata','2025-10-02 12:15:26','2025-10-02 12:15:36','2025-10-02 12:15:36',1),(13,'9f2e97bd-159f-41e5-875d-f066be38a116','hw_disk_bus','virtio','2025-10-02 12:15:26','2025-10-02 12:15:36','2025-10-02 12:15:36',1),(14,'9f2e97bd-159f-41e5-875d-f066be38a116','hw_input_bus','usb','2025-10-02 12:15:26','2025-10-02 12:15:36','2025-10-02 12:15:36',1),(15,'9f2e97bd-159f-41e5-875d-f066be38a116','hw_pointer_model','usbtablet','2025-10-02 12:15:26','2025-10-02 12:15:36','2025-10-02 12:15:36',1),(16,'9f2e97bd-159f-41e5-875d-f066be38a116','hw_video_model','virtio','2025-10-02 12:15:26','2025-10-02 12:15:36','2025-10-02 12:15:36',1),(17,'9f2e97bd-159f-41e5-875d-f066be38a116','hw_vif_model','virtio','2025-10-02 12:15:26','2025-10-02 12:15:36','2025-10-02 12:15:36',1),(18,'9f2e97bd-159f-41e5-875d-f066be38a116','instance_uuid','01eee71c-078c-41f4-a1c1-4591cab7195e','2025-10-02 12:15:26','2025-10-02 12:15:36','2025-10-02 12:15:36',1),(19,'9f2e97bd-159f-41e5-875d-f066be38a116','user_id','79b88925d1704f5c9b3d2114c1a9ae4f','2025-10-02 12:15:26','2025-10-02 12:15:36','2025-10-02 12:15:36',1),(20,'9f2e97bd-159f-41e5-875d-f066be38a116','image_type','test','2025-10-02 12:15:26','2025-10-02 12:15:36','2025-10-02 12:15:36',1),(21,'9f2e97bd-159f-41e5-875d-f066be38a116','image_state','available','2025-10-02 12:15:32','2025-10-02 12:15:36','2025-10-02 12:15:36',1),(22,'9f2e97bd-159f-41e5-875d-f066be38a116','image_location','snapshot','2025-10-02 12:15:32','2025-10-02 12:15:36','2025-10-02 12:15:36',1),(23,'9f2e97bd-159f-41e5-875d-f066be38a116','owner_id','d92e60d304e64805972937813fc99606','2025-10-02 12:15:32','2025-10-02 12:15:36','2025-10-02 12:15:36',1),(24,'28a7bd8e-0ddc-4cda-9f64-7c1162716074','hw_rng_model','virtio','2025-10-02 12:15:36','2025-10-02 12:16:10','2025-10-02 12:16:10',1),(25,'28a7bd8e-0ddc-4cda-9f64-7c1162716074','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 12:15:36','2025-10-02 12:16:10','2025-10-02 12:16:10',1),(26,'28a7bd8e-0ddc-4cda-9f64-7c1162716074','owner_user_name','tempest-ImagesOneServerTestJSON-572210404-project-member','2025-10-02 12:15:36','2025-10-02 12:16:10','2025-10-02 12:16:10',1),(27,'28a7bd8e-0ddc-4cda-9f64-7c1162716074','owner_project_name','tempest-ImagesOneServerTestJSON-572210404','2025-10-02 12:15:36','2025-10-02 12:16:10','2025-10-02 12:16:10',1),(28,'28a7bd8e-0ddc-4cda-9f64-7c1162716074','boot_roles','reader,member','2025-10-02 12:15:36','2025-10-02 12:16:10','2025-10-02 12:16:10',1),(29,'28a7bd8e-0ddc-4cda-9f64-7c1162716074','hw_machine_type','q35','2025-10-02 12:15:36','2025-10-02 12:16:10','2025-10-02 12:16:10',1),(30,'28a7bd8e-0ddc-4cda-9f64-7c1162716074','hw_cdrom_bus','sata','2025-10-02 12:15:36','2025-10-02 12:16:10','2025-10-02 12:16:10',1),(31,'28a7bd8e-0ddc-4cda-9f64-7c1162716074','hw_disk_bus','virtio','2025-10-02 12:15:36','2025-10-02 12:16:10','2025-10-02 12:16:10',1),(32,'28a7bd8e-0ddc-4cda-9f64-7c1162716074','hw_input_bus','usb','2025-10-02 12:15:36','2025-10-02 12:16:10','2025-10-02 12:16:10',1),(33,'28a7bd8e-0ddc-4cda-9f64-7c1162716074','hw_pointer_model','usbtablet','2025-10-02 12:15:36','2025-10-02 12:16:10','2025-10-02 12:16:10',1),(34,'28a7bd8e-0ddc-4cda-9f64-7c1162716074','hw_video_model','virtio','2025-10-02 12:15:36','2025-10-02 12:16:10','2025-10-02 12:16:10',1),(35,'28a7bd8e-0ddc-4cda-9f64-7c1162716074','hw_vif_model','virtio','2025-10-02 12:15:36','2025-10-02 12:16:10','2025-10-02 12:16:10',1),(36,'28a7bd8e-0ddc-4cda-9f64-7c1162716074','instance_uuid','01eee71c-078c-41f4-a1c1-4591cab7195e','2025-10-02 12:15:36','2025-10-02 12:16:10','2025-10-02 12:16:10',1),(37,'28a7bd8e-0ddc-4cda-9f64-7c1162716074','user_id','79b88925d1704f5c9b3d2114c1a9ae4f','2025-10-02 12:15:36','2025-10-02 12:16:10','2025-10-02 12:16:10',1),(38,'28a7bd8e-0ddc-4cda-9f64-7c1162716074','image_type','snapshot','2025-10-02 12:15:36','2025-10-02 12:16:10','2025-10-02 12:16:10',1),(39,'28a7bd8e-0ddc-4cda-9f64-7c1162716074','image_state','available','2025-10-02 12:15:57','2025-10-02 12:16:10','2025-10-02 12:16:10',1),(40,'28a7bd8e-0ddc-4cda-9f64-7c1162716074','image_location','snapshot','2025-10-02 12:15:57','2025-10-02 12:16:10','2025-10-02 12:16:10',1),(41,'28a7bd8e-0ddc-4cda-9f64-7c1162716074','owner_id','d92e60d304e64805972937813fc99606','2025-10-02 12:15:57','2025-10-02 12:16:10','2025-10-02 12:16:10',1),(42,'15e18cef-aa4b-424b-82b1-3a0edfa62ef7','hw_rng_model','virtio','2025-10-02 12:20:12','2025-10-02 12:20:21','2025-10-02 12:20:21',1),(43,'15e18cef-aa4b-424b-82b1-3a0edfa62ef7','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 12:20:12','2025-10-02 12:20:21','2025-10-02 12:20:21',1),(44,'15e18cef-aa4b-424b-82b1-3a0edfa62ef7','owner_user_name','tempest-ImagesTestJSON-1681256609-project-member','2025-10-02 12:20:12','2025-10-02 12:20:21','2025-10-02 12:20:21',1),(45,'15e18cef-aa4b-424b-82b1-3a0edfa62ef7','owner_project_name','tempest-ImagesTestJSON-1681256609','2025-10-02 12:20:12','2025-10-02 12:20:21','2025-10-02 12:20:21',1),(46,'15e18cef-aa4b-424b-82b1-3a0edfa62ef7','boot_roles','member,reader','2025-10-02 12:20:12','2025-10-02 12:20:21','2025-10-02 12:20:21',1),(47,'15e18cef-aa4b-424b-82b1-3a0edfa62ef7','hw_machine_type','q35','2025-10-02 12:20:12','2025-10-02 12:20:21','2025-10-02 12:20:21',1),(48,'15e18cef-aa4b-424b-82b1-3a0edfa62ef7','hw_cdrom_bus','sata','2025-10-02 12:20:12','2025-10-02 12:20:21','2025-10-02 12:20:21',1),(49,'15e18cef-aa4b-424b-82b1-3a0edfa62ef7','hw_disk_bus','virtio','2025-10-02 12:20:12','2025-10-02 12:20:21','2025-10-02 12:20:21',1),(50,'15e18cef-aa4b-424b-82b1-3a0edfa62ef7','hw_input_bus','usb','2025-10-02 12:20:12','2025-10-02 12:20:21','2025-10-02 12:20:21',1),(51,'15e18cef-aa4b-424b-82b1-3a0edfa62ef7','hw_pointer_model','usbtablet','2025-10-02 12:20:12','2025-10-02 12:20:21','2025-10-02 12:20:21',1),(52,'15e18cef-aa4b-424b-82b1-3a0edfa62ef7','hw_video_model','virtio','2025-10-02 12:20:12','2025-10-02 12:20:21','2025-10-02 12:20:21',1),(53,'15e18cef-aa4b-424b-82b1-3a0edfa62ef7','hw_vif_model','virtio','2025-10-02 12:20:12','2025-10-02 12:20:21','2025-10-02 12:20:21',1),(54,'15e18cef-aa4b-424b-82b1-3a0edfa62ef7','instance_uuid','8eb476b0-ae5f-44b6-bac9-5a6ade5b24b8','2025-10-02 12:20:12','2025-10-02 12:20:21','2025-10-02 12:20:21',1),(55,'15e18cef-aa4b-424b-82b1-3a0edfa62ef7','user_id','afacfeac9efc4e6fbb83ebe4fe9a8f38','2025-10-02 12:20:12','2025-10-02 12:20:21','2025-10-02 12:20:21',1),(56,'15e18cef-aa4b-424b-82b1-3a0edfa62ef7','image_type','snapshot','2025-10-02 12:20:12','2025-10-02 12:20:21','2025-10-02 12:20:21',1),(57,'15e18cef-aa4b-424b-82b1-3a0edfa62ef7','image_state','available','2025-10-02 12:20:18','2025-10-02 12:20:21','2025-10-02 12:20:21',1),(58,'15e18cef-aa4b-424b-82b1-3a0edfa62ef7','image_location','snapshot','2025-10-02 12:20:18','2025-10-02 12:20:21','2025-10-02 12:20:21',1),(59,'15e18cef-aa4b-424b-82b1-3a0edfa62ef7','owner_id','d0ebb2827cb241e499606ce3a3c67d24','2025-10-02 12:20:18','2025-10-02 12:20:21','2025-10-02 12:20:21',1),(60,'f573b04f-b850-41b8-8b32-8ba00d6690cd','hw_rng_model','virtio','2025-10-02 12:20:20','2025-10-02 12:21:06','2025-10-02 12:21:06',1),(61,'f573b04f-b850-41b8-8b32-8ba00d6690cd','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 12:20:20','2025-10-02 12:21:06','2025-10-02 12:21:06',1),(62,'f573b04f-b850-41b8-8b32-8ba00d6690cd','owner_user_name','tempest-UnshelveToHostMultiNodesTest-2076784560-project-member','2025-10-02 12:20:20','2025-10-02 12:21:06','2025-10-02 12:21:06',1),(63,'f573b04f-b850-41b8-8b32-8ba00d6690cd','owner_project_name','tempest-UnshelveToHostMultiNodesTest-2076784560','2025-10-02 12:20:20','2025-10-02 12:21:06','2025-10-02 12:21:06',1),(64,'f573b04f-b850-41b8-8b32-8ba00d6690cd','boot_roles','reader,member','2025-10-02 12:20:20','2025-10-02 12:21:06','2025-10-02 12:21:06',1),(65,'f573b04f-b850-41b8-8b32-8ba00d6690cd','hw_machine_type','q35','2025-10-02 12:20:20','2025-10-02 12:21:06','2025-10-02 12:21:06',1),(66,'f573b04f-b850-41b8-8b32-8ba00d6690cd','hw_cdrom_bus','sata','2025-10-02 12:20:20','2025-10-02 12:21:06','2025-10-02 12:21:06',1),(67,'f573b04f-b850-41b8-8b32-8ba00d6690cd','hw_disk_bus','virtio','2025-10-02 12:20:20','2025-10-02 12:21:06','2025-10-02 12:21:06',1),(68,'f573b04f-b850-41b8-8b32-8ba00d6690cd','hw_input_bus','usb','2025-10-02 12:20:20','2025-10-02 12:21:06','2025-10-02 12:21:06',1),(69,'f573b04f-b850-41b8-8b32-8ba00d6690cd','hw_pointer_model','usbtablet','2025-10-02 12:20:20','2025-10-02 12:21:06','2025-10-02 12:21:06',1),(70,'f573b04f-b850-41b8-8b32-8ba00d6690cd','hw_video_model','virtio','2025-10-02 12:20:20','2025-10-02 12:21:06','2025-10-02 12:21:06',1),(71,'f573b04f-b850-41b8-8b32-8ba00d6690cd','hw_vif_model','virtio','2025-10-02 12:20:20','2025-10-02 12:21:06','2025-10-02 12:21:06',1),(72,'f573b04f-b850-41b8-8b32-8ba00d6690cd','instance_uuid','7beacac0-65ce-4e15-a73c-9b50a50f968e','2025-10-02 12:20:20','2025-10-02 12:21:06','2025-10-02 12:21:06',1),(73,'f573b04f-b850-41b8-8b32-8ba00d6690cd','user_id','93167a5206ba42b28aa96a676d3edb6d','2025-10-02 12:20:20','2025-10-02 12:21:06','2025-10-02 12:21:06',1),(74,'f573b04f-b850-41b8-8b32-8ba00d6690cd','image_type','snapshot','2025-10-02 12:20:20','2025-10-02 12:21:06','2025-10-02 12:21:06',1),(75,'f573b04f-b850-41b8-8b32-8ba00d6690cd','image_location','snapshot','2025-10-02 12:20:44','2025-10-02 12:21:06','2025-10-02 12:21:06',1),(76,'f573b04f-b850-41b8-8b32-8ba00d6690cd','owner_id','aaf2805394aa4c4cb7977f6433aabf56','2025-10-02 12:20:44','2025-10-02 12:21:06','2025-10-02 12:21:06',1),(77,'f573b04f-b850-41b8-8b32-8ba00d6690cd','image_state','available','2025-10-02 12:20:44','2025-10-02 12:21:06','2025-10-02 12:21:06',1),(78,'bc229961-c2ce-4076-a41e-7413c2291d5e','hw_rng_model','virtio','2025-10-02 12:21:08','2025-10-02 12:21:33','2025-10-02 12:21:33',1),(79,'bc229961-c2ce-4076-a41e-7413c2291d5e','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 12:21:08','2025-10-02 12:21:33','2025-10-02 12:21:33',1),(80,'bc229961-c2ce-4076-a41e-7413c2291d5e','owner_user_name','tempest-ImagesTestJSON-1681256609-project-member','2025-10-02 12:21:08','2025-10-02 12:21:33','2025-10-02 12:21:33',1),(81,'bc229961-c2ce-4076-a41e-7413c2291d5e','owner_project_name','tempest-ImagesTestJSON-1681256609','2025-10-02 12:21:08','2025-10-02 12:21:33','2025-10-02 12:21:33',1),(82,'bc229961-c2ce-4076-a41e-7413c2291d5e','boot_roles','reader,member','2025-10-02 12:21:08','2025-10-02 12:21:33','2025-10-02 12:21:33',1),(83,'bc229961-c2ce-4076-a41e-7413c2291d5e','hw_machine_type','q35','2025-10-02 12:21:08','2025-10-02 12:21:33','2025-10-02 12:21:33',1),(84,'bc229961-c2ce-4076-a41e-7413c2291d5e','hw_cdrom_bus','sata','2025-10-02 12:21:08','2025-10-02 12:21:33','2025-10-02 12:21:33',1),(85,'bc229961-c2ce-4076-a41e-7413c2291d5e','hw_disk_bus','virtio','2025-10-02 12:21:08','2025-10-02 12:21:33','2025-10-02 12:21:33',1),(86,'bc229961-c2ce-4076-a41e-7413c2291d5e','hw_input_bus','usb','2025-10-02 12:21:08','2025-10-02 12:21:33','2025-10-02 12:21:33',1),(87,'bc229961-c2ce-4076-a41e-7413c2291d5e','hw_pointer_model','usbtablet','2025-10-02 12:21:08','2025-10-02 12:21:33','2025-10-02 12:21:33',1),(88,'bc229961-c2ce-4076-a41e-7413c2291d5e','hw_video_model','virtio','2025-10-02 12:21:08','2025-10-02 12:21:33','2025-10-02 12:21:33',1),(89,'bc229961-c2ce-4076-a41e-7413c2291d5e','hw_vif_model','virtio','2025-10-02 12:21:08','2025-10-02 12:21:33','2025-10-02 12:21:33',1),(90,'bc229961-c2ce-4076-a41e-7413c2291d5e','instance_uuid','51faf5e3-3295-46e2-8cf7-ac53503b72ca','2025-10-02 12:21:08','2025-10-02 12:21:33','2025-10-02 12:21:33',1),(91,'bc229961-c2ce-4076-a41e-7413c2291d5e','user_id','afacfeac9efc4e6fbb83ebe4fe9a8f38','2025-10-02 12:21:08','2025-10-02 12:21:33','2025-10-02 12:21:33',1),(92,'bc229961-c2ce-4076-a41e-7413c2291d5e','image_type','snapshot','2025-10-02 12:21:08','2025-10-02 12:21:33','2025-10-02 12:21:33',1),(93,'45a729a3-bfb9-4ba4-a275-e4201ada93ed','hw_rng_model','virtio','2025-10-02 12:21:10','2025-10-02 12:22:06','2025-10-02 12:22:06',1),(94,'45a729a3-bfb9-4ba4-a275-e4201ada93ed','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 12:21:10','2025-10-02 12:22:06','2025-10-02 12:22:06',1),(95,'45a729a3-bfb9-4ba4-a275-e4201ada93ed','owner_user_name','tempest-UnshelveToHostMultiNodesTest-2076784560-project-member','2025-10-02 12:21:10','2025-10-02 12:22:06','2025-10-02 12:22:06',1),(96,'45a729a3-bfb9-4ba4-a275-e4201ada93ed','owner_project_name','tempest-UnshelveToHostMultiNodesTest-2076784560','2025-10-02 12:21:10','2025-10-02 12:22:06','2025-10-02 12:22:06',1),(97,'45a729a3-bfb9-4ba4-a275-e4201ada93ed','boot_roles','reader,member','2025-10-02 12:21:10','2025-10-02 12:22:06','2025-10-02 12:22:06',1),(98,'45a729a3-bfb9-4ba4-a275-e4201ada93ed','hw_machine_type','q35','2025-10-02 12:21:10','2025-10-02 12:22:06','2025-10-02 12:22:06',1),(99,'45a729a3-bfb9-4ba4-a275-e4201ada93ed','hw_cdrom_bus','sata','2025-10-02 12:21:10','2025-10-02 12:22:06','2025-10-02 12:22:06',1),(100,'45a729a3-bfb9-4ba4-a275-e4201ada93ed','hw_disk_bus','virtio','2025-10-02 12:21:10','2025-10-02 12:22:06','2025-10-02 12:22:06',1),(101,'45a729a3-bfb9-4ba4-a275-e4201ada93ed','hw_input_bus','usb','2025-10-02 12:21:10','2025-10-02 12:22:06','2025-10-02 12:22:06',1),(102,'45a729a3-bfb9-4ba4-a275-e4201ada93ed','hw_pointer_model','usbtablet','2025-10-02 12:21:10','2025-10-02 12:22:06','2025-10-02 12:22:06',1),(103,'45a729a3-bfb9-4ba4-a275-e4201ada93ed','hw_video_model','virtio','2025-10-02 12:21:10','2025-10-02 12:22:06','2025-10-02 12:22:06',1),(104,'45a729a3-bfb9-4ba4-a275-e4201ada93ed','hw_vif_model','virtio','2025-10-02 12:21:10','2025-10-02 12:22:06','2025-10-02 12:22:06',1),(105,'45a729a3-bfb9-4ba4-a275-e4201ada93ed','clean_attempts','1','2025-10-02 12:21:10','2025-10-02 12:22:06','2025-10-02 12:22:06',1),(106,'45a729a3-bfb9-4ba4-a275-e4201ada93ed','instance_uuid','7beacac0-65ce-4e15-a73c-9b50a50f968e','2025-10-02 12:21:10','2025-10-02 12:22:06','2025-10-02 12:22:06',1),(107,'45a729a3-bfb9-4ba4-a275-e4201ada93ed','user_id','93167a5206ba42b28aa96a676d3edb6d','2025-10-02 12:21:10','2025-10-02 12:22:06','2025-10-02 12:22:06',1),(108,'45a729a3-bfb9-4ba4-a275-e4201ada93ed','image_type','snapshot','2025-10-02 12:21:10','2025-10-02 12:22:06','2025-10-02 12:22:06',1),(109,'bc229961-c2ce-4076-a41e-7413c2291d5e','owner_id','d0ebb2827cb241e499606ce3a3c67d24','2025-10-02 12:21:16','2025-10-02 12:21:33','2025-10-02 12:21:33',1),(110,'bc229961-c2ce-4076-a41e-7413c2291d5e','image_state','available','2025-10-02 12:21:16','2025-10-02 12:21:33','2025-10-02 12:21:33',1),(111,'bc229961-c2ce-4076-a41e-7413c2291d5e','image_location','snapshot','2025-10-02 12:21:16','2025-10-02 12:21:33','2025-10-02 12:21:33',1),(112,'45a729a3-bfb9-4ba4-a275-e4201ada93ed','image_location','snapshot','2025-10-02 12:21:37','2025-10-02 12:22:06','2025-10-02 12:22:06',1),(113,'45a729a3-bfb9-4ba4-a275-e4201ada93ed','owner_id','aaf2805394aa4c4cb7977f6433aabf56','2025-10-02 12:21:37','2025-10-02 12:22:06','2025-10-02 12:22:06',1),(114,'45a729a3-bfb9-4ba4-a275-e4201ada93ed','image_state','available','2025-10-02 12:21:37','2025-10-02 12:22:06','2025-10-02 12:22:06',1),(115,'5e6784e9-638e-4f69-b9c1-8a81a55dc0ed','hw_rng_model','virtio','2025-10-02 12:22:04','2025-10-02 12:22:22','2025-10-02 12:22:22',1),(116,'5e6784e9-638e-4f69-b9c1-8a81a55dc0ed','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 12:22:04','2025-10-02 12:22:22','2025-10-02 12:22:22',1),(117,'5e6784e9-638e-4f69-b9c1-8a81a55dc0ed','owner_user_name','tempest-ImagesTestJSON-1681256609-project-member','2025-10-02 12:22:04','2025-10-02 12:22:22','2025-10-02 12:22:22',1),(118,'5e6784e9-638e-4f69-b9c1-8a81a55dc0ed','owner_project_name','tempest-ImagesTestJSON-1681256609','2025-10-02 12:22:04','2025-10-02 12:22:22','2025-10-02 12:22:22',1),(119,'5e6784e9-638e-4f69-b9c1-8a81a55dc0ed','boot_roles','reader,member','2025-10-02 12:22:04','2025-10-02 12:22:22','2025-10-02 12:22:22',1),(120,'5e6784e9-638e-4f69-b9c1-8a81a55dc0ed','hw_machine_type','q35','2025-10-02 12:22:04','2025-10-02 12:22:22','2025-10-02 12:22:22',1),(121,'5e6784e9-638e-4f69-b9c1-8a81a55dc0ed','hw_cdrom_bus','sata','2025-10-02 12:22:04','2025-10-02 12:22:22','2025-10-02 12:22:22',1),(122,'5e6784e9-638e-4f69-b9c1-8a81a55dc0ed','hw_disk_bus','virtio','2025-10-02 12:22:04','2025-10-02 12:22:22','2025-10-02 12:22:22',1),(123,'5e6784e9-638e-4f69-b9c1-8a81a55dc0ed','hw_input_bus','usb','2025-10-02 12:22:04','2025-10-02 12:22:22','2025-10-02 12:22:22',1),(124,'5e6784e9-638e-4f69-b9c1-8a81a55dc0ed','hw_pointer_model','usbtablet','2025-10-02 12:22:04','2025-10-02 12:22:22','2025-10-02 12:22:22',1),(125,'5e6784e9-638e-4f69-b9c1-8a81a55dc0ed','hw_video_model','virtio','2025-10-02 12:22:04','2025-10-02 12:22:22','2025-10-02 12:22:22',1),(126,'5e6784e9-638e-4f69-b9c1-8a81a55dc0ed','hw_vif_model','virtio','2025-10-02 12:22:04','2025-10-02 12:22:22','2025-10-02 12:22:22',1),(127,'5e6784e9-638e-4f69-b9c1-8a81a55dc0ed','old_vm_state','active','2025-10-02 12:22:04','2025-10-02 12:22:22','2025-10-02 12:22:22',1),(128,'5e6784e9-638e-4f69-b9c1-8a81a55dc0ed','instance_uuid','2f6accd4-eaf1-4307-9c43-b732c3dd0b3d','2025-10-02 12:22:04','2025-10-02 12:22:22','2025-10-02 12:22:22',1),(129,'5e6784e9-638e-4f69-b9c1-8a81a55dc0ed','user_id','afacfeac9efc4e6fbb83ebe4fe9a8f38','2025-10-02 12:22:04','2025-10-02 12:22:22','2025-10-02 12:22:22',1),(130,'5e6784e9-638e-4f69-b9c1-8a81a55dc0ed','image_type','snapshot','2025-10-02 12:22:04','2025-10-02 12:22:22','2025-10-02 12:22:22',1),(131,'5e6784e9-638e-4f69-b9c1-8a81a55dc0ed','image_location','snapshot','2025-10-02 12:22:14','2025-10-02 12:22:22','2025-10-02 12:22:22',1),(132,'5e6784e9-638e-4f69-b9c1-8a81a55dc0ed','owner_id','d0ebb2827cb241e499606ce3a3c67d24','2025-10-02 12:22:14','2025-10-02 12:22:22','2025-10-02 12:22:22',1),(133,'5e6784e9-638e-4f69-b9c1-8a81a55dc0ed','image_state','available','2025-10-02 12:22:14','2025-10-02 12:22:22','2025-10-02 12:22:22',1),(134,'38906c7c-521b-42f0-a991-950eaae1ee1c','hw_rng_model','virtio','2025-10-02 12:22:50','2025-10-02 12:23:40','2025-10-02 12:23:40',1),(135,'38906c7c-521b-42f0-a991-950eaae1ee1c','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 12:22:50','2025-10-02 12:23:40','2025-10-02 12:23:40',1),(136,'38906c7c-521b-42f0-a991-950eaae1ee1c','owner_user_name','tempest-ImagesTestJSON-1681256609-project-member','2025-10-02 12:22:50','2025-10-02 12:23:40','2025-10-02 12:23:40',1),(137,'38906c7c-521b-42f0-a991-950eaae1ee1c','owner_project_name','tempest-ImagesTestJSON-1681256609','2025-10-02 12:22:50','2025-10-02 12:23:40','2025-10-02 12:23:40',1),(138,'38906c7c-521b-42f0-a991-950eaae1ee1c','boot_roles','member,reader','2025-10-02 12:22:50','2025-10-02 12:23:40','2025-10-02 12:23:40',1),(139,'38906c7c-521b-42f0-a991-950eaae1ee1c','hw_machine_type','q35','2025-10-02 12:22:50','2025-10-02 12:23:40','2025-10-02 12:23:40',1),(140,'38906c7c-521b-42f0-a991-950eaae1ee1c','hw_cdrom_bus','sata','2025-10-02 12:22:50','2025-10-02 12:23:40','2025-10-02 12:23:40',1),(141,'38906c7c-521b-42f0-a991-950eaae1ee1c','hw_disk_bus','virtio','2025-10-02 12:22:50','2025-10-02 12:23:40','2025-10-02 12:23:40',1),(142,'38906c7c-521b-42f0-a991-950eaae1ee1c','hw_input_bus','usb','2025-10-02 12:22:50','2025-10-02 12:23:40','2025-10-02 12:23:40',1),(143,'38906c7c-521b-42f0-a991-950eaae1ee1c','hw_pointer_model','usbtablet','2025-10-02 12:22:50','2025-10-02 12:23:40','2025-10-02 12:23:40',1),(144,'38906c7c-521b-42f0-a991-950eaae1ee1c','hw_video_model','virtio','2025-10-02 12:22:50','2025-10-02 12:23:40','2025-10-02 12:23:40',1),(145,'38906c7c-521b-42f0-a991-950eaae1ee1c','hw_vif_model','virtio','2025-10-02 12:22:50','2025-10-02 12:23:40','2025-10-02 12:23:40',1),(146,'38906c7c-521b-42f0-a991-950eaae1ee1c','instance_uuid','ef0d5be3-6f62-49b2-82fa-b646bea14a10','2025-10-02 12:22:50','2025-10-02 12:23:40','2025-10-02 12:23:40',1),(147,'38906c7c-521b-42f0-a991-950eaae1ee1c','user_id','afacfeac9efc4e6fbb83ebe4fe9a8f38','2025-10-02 12:22:50','2025-10-02 12:23:40','2025-10-02 12:23:40',1),(148,'38906c7c-521b-42f0-a991-950eaae1ee1c','image_type','snapshot','2025-10-02 12:22:50','2025-10-02 12:23:40','2025-10-02 12:23:40',1),(149,'38906c7c-521b-42f0-a991-950eaae1ee1c','owner_id','d0ebb2827cb241e499606ce3a3c67d24','2025-10-02 12:23:05','2025-10-02 12:23:40','2025-10-02 12:23:40',1),(150,'38906c7c-521b-42f0-a991-950eaae1ee1c','image_state','available','2025-10-02 12:23:05','2025-10-02 12:23:40','2025-10-02 12:23:40',1),(151,'38906c7c-521b-42f0-a991-950eaae1ee1c','image_location','snapshot','2025-10-02 12:23:05','2025-10-02 12:23:40','2025-10-02 12:23:40',1),(152,'e7094a19-0695-4486-b083-e54642bc0338','hw_scsi_model','virtio-scsi','2025-10-02 12:23:21','2025-10-02 12:24:52','2025-10-02 12:24:52',1),(153,'e7094a19-0695-4486-b083-e54642bc0338','hw_disk_bus','scsi','2025-10-02 12:23:21','2025-10-02 12:24:52','2025-10-02 12:24:52',1),(154,'e7094a19-0695-4486-b083-e54642bc0338','hw_cdrom_bus','scsi','2025-10-02 12:23:21','2025-10-02 12:24:52','2025-10-02 12:24:52',1),(155,'cf745836-410d-40ce-8229-51a950b72ba1','hw_rng_model','virtio','2025-10-02 12:24:01','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(156,'cf745836-410d-40ce-8229-51a950b72ba1','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 12:24:01','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(157,'cf745836-410d-40ce-8229-51a950b72ba1','owner_user_name','tempest-ImagesTestJSON-1681256609-project-member','2025-10-02 12:24:01','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(158,'cf745836-410d-40ce-8229-51a950b72ba1','owner_project_name','tempest-ImagesTestJSON-1681256609','2025-10-02 12:24:01','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(159,'cf745836-410d-40ce-8229-51a950b72ba1','boot_roles','reader,member','2025-10-02 12:24:01','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(160,'cf745836-410d-40ce-8229-51a950b72ba1','hw_machine_type','q35','2025-10-02 12:24:01','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(161,'cf745836-410d-40ce-8229-51a950b72ba1','hw_cdrom_bus','sata','2025-10-02 12:24:01','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(162,'cf745836-410d-40ce-8229-51a950b72ba1','hw_disk_bus','virtio','2025-10-02 12:24:01','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(163,'cf745836-410d-40ce-8229-51a950b72ba1','hw_input_bus','usb','2025-10-02 12:24:01','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(164,'cf745836-410d-40ce-8229-51a950b72ba1','hw_pointer_model','usbtablet','2025-10-02 12:24:01','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(165,'cf745836-410d-40ce-8229-51a950b72ba1','hw_video_model','virtio','2025-10-02 12:24:01','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(166,'cf745836-410d-40ce-8229-51a950b72ba1','hw_vif_model','virtio','2025-10-02 12:24:01','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(167,'cf745836-410d-40ce-8229-51a950b72ba1','instance_uuid','c1597192-3527-4620-a21f-0e71c9c1c09d','2025-10-02 12:24:01','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(168,'cf745836-410d-40ce-8229-51a950b72ba1','user_id','afacfeac9efc4e6fbb83ebe4fe9a8f38','2025-10-02 12:24:01','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(169,'cf745836-410d-40ce-8229-51a950b72ba1','image_type','snapshot','2025-10-02 12:24:01','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(170,'a1e5194e-ee54-41db-883e-1f37efee5068','hw_rng_model','virtio','2025-10-02 12:27:49','2025-10-02 12:27:49','2025-10-02 12:27:49',1),(171,'a1e5194e-ee54-41db-883e-1f37efee5068','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 12:27:49','2025-10-02 12:27:49','2025-10-02 12:27:49',1),(172,'a1e5194e-ee54-41db-883e-1f37efee5068','owner_user_name','tempest-ImagesOneServerNegativeTestJSON-883313902-project-member','2025-10-02 12:27:49','2025-10-02 12:27:50','2025-10-02 12:27:50',1),(173,'a1e5194e-ee54-41db-883e-1f37efee5068','owner_project_name','tempest-ImagesOneServerNegativeTestJSON-883313902','2025-10-02 12:27:49','2025-10-02 12:27:50','2025-10-02 12:27:50',1),(174,'a1e5194e-ee54-41db-883e-1f37efee5068','boot_roles','reader,member','2025-10-02 12:27:49','2025-10-02 12:27:50','2025-10-02 12:27:50',1),(175,'a1e5194e-ee54-41db-883e-1f37efee5068','hw_machine_type','q35','2025-10-02 12:27:49','2025-10-02 12:27:50','2025-10-02 12:27:50',1),(176,'a1e5194e-ee54-41db-883e-1f37efee5068','hw_cdrom_bus','sata','2025-10-02 12:27:49','2025-10-02 12:27:50','2025-10-02 12:27:50',1),(177,'a1e5194e-ee54-41db-883e-1f37efee5068','hw_disk_bus','virtio','2025-10-02 12:27:49','2025-10-02 12:27:50','2025-10-02 12:27:50',1),(178,'a1e5194e-ee54-41db-883e-1f37efee5068','hw_input_bus','usb','2025-10-02 12:27:49','2025-10-02 12:27:50','2025-10-02 12:27:50',1),(179,'a1e5194e-ee54-41db-883e-1f37efee5068','hw_pointer_model','usbtablet','2025-10-02 12:27:49','2025-10-02 12:27:50','2025-10-02 12:27:50',1),(180,'a1e5194e-ee54-41db-883e-1f37efee5068','hw_video_model','virtio','2025-10-02 12:27:49','2025-10-02 12:27:50','2025-10-02 12:27:50',1),(181,'a1e5194e-ee54-41db-883e-1f37efee5068','hw_vif_model','virtio','2025-10-02 12:27:49','2025-10-02 12:27:50','2025-10-02 12:27:50',1),(182,'a1e5194e-ee54-41db-883e-1f37efee5068','instance_uuid','be855518-90af-4fa9-b969-4a1579934010','2025-10-02 12:27:49','2025-10-02 12:27:50','2025-10-02 12:27:50',1),(183,'a1e5194e-ee54-41db-883e-1f37efee5068','user_id','eff0431e92464c78b780c8365e6e920c','2025-10-02 12:27:49','2025-10-02 12:27:50','2025-10-02 12:27:50',1),(184,'a1e5194e-ee54-41db-883e-1f37efee5068','image_type','snapshot','2025-10-02 12:27:49','2025-10-02 12:27:50','2025-10-02 12:27:50',1),(185,'79274edd-028c-4cfd-9fc0-5c8ea54a5ee4','hw_rng_model','virtio','2025-10-02 12:28:26','2025-10-02 12:28:27','2025-10-02 12:28:27',1),(186,'79274edd-028c-4cfd-9fc0-5c8ea54a5ee4','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 12:28:26','2025-10-02 12:28:27','2025-10-02 12:28:27',1),(187,'79274edd-028c-4cfd-9fc0-5c8ea54a5ee4','owner_user_name','tempest-ImagesOneServerNegativeTestJSON-883313902-project-member','2025-10-02 12:28:26','2025-10-02 12:28:27','2025-10-02 12:28:27',1),(188,'79274edd-028c-4cfd-9fc0-5c8ea54a5ee4','owner_project_name','tempest-ImagesOneServerNegativeTestJSON-883313902','2025-10-02 12:28:26','2025-10-02 12:28:27','2025-10-02 12:28:27',1),(189,'79274edd-028c-4cfd-9fc0-5c8ea54a5ee4','boot_roles','reader,member','2025-10-02 12:28:26','2025-10-02 12:28:27','2025-10-02 12:28:27',1),(190,'79274edd-028c-4cfd-9fc0-5c8ea54a5ee4','hw_machine_type','q35','2025-10-02 12:28:26','2025-10-02 12:28:27','2025-10-02 12:28:27',1),(191,'79274edd-028c-4cfd-9fc0-5c8ea54a5ee4','hw_cdrom_bus','sata','2025-10-02 12:28:26','2025-10-02 12:28:27','2025-10-02 12:28:27',1),(192,'79274edd-028c-4cfd-9fc0-5c8ea54a5ee4','hw_disk_bus','virtio','2025-10-02 12:28:26','2025-10-02 12:28:27','2025-10-02 12:28:27',1),(193,'79274edd-028c-4cfd-9fc0-5c8ea54a5ee4','hw_input_bus','usb','2025-10-02 12:28:26','2025-10-02 12:28:27','2025-10-02 12:28:27',1),(194,'79274edd-028c-4cfd-9fc0-5c8ea54a5ee4','hw_pointer_model','usbtablet','2025-10-02 12:28:26','2025-10-02 12:28:27','2025-10-02 12:28:27',1),(195,'79274edd-028c-4cfd-9fc0-5c8ea54a5ee4','hw_video_model','virtio','2025-10-02 12:28:26','2025-10-02 12:28:27','2025-10-02 12:28:27',1),(196,'79274edd-028c-4cfd-9fc0-5c8ea54a5ee4','hw_vif_model','virtio','2025-10-02 12:28:26','2025-10-02 12:28:27','2025-10-02 12:28:27',1),(197,'79274edd-028c-4cfd-9fc0-5c8ea54a5ee4','instance_uuid','e408d787-b02c-4b28-9af7-b7ae07b54538','2025-10-02 12:28:26','2025-10-02 12:28:27','2025-10-02 12:28:27',1),(198,'79274edd-028c-4cfd-9fc0-5c8ea54a5ee4','user_id','eff0431e92464c78b780c8365e6e920c','2025-10-02 12:28:26','2025-10-02 12:28:27','2025-10-02 12:28:27',1),(199,'79274edd-028c-4cfd-9fc0-5c8ea54a5ee4','image_type','snapshot','2025-10-02 12:28:26','2025-10-02 12:28:27','2025-10-02 12:28:27',1),(200,'e63c0054-4f57-471e-a2d8-a929502f4104','hw_rng_model','virtio','2025-10-02 12:28:56','2025-10-02 12:29:52','2025-10-02 12:29:52',1),(201,'e63c0054-4f57-471e-a2d8-a929502f4104','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 12:28:56','2025-10-02 12:29:52','2025-10-02 12:29:52',1),(202,'e63c0054-4f57-471e-a2d8-a929502f4104','owner_user_name','tempest-ListImageFiltersTestJSON-1602275258-project-member','2025-10-02 12:28:56','2025-10-02 12:29:52','2025-10-02 12:29:52',1),(203,'e63c0054-4f57-471e-a2d8-a929502f4104','owner_project_name','tempest-ListImageFiltersTestJSON-1602275258','2025-10-02 12:28:56','2025-10-02 12:29:52','2025-10-02 12:29:52',1),(204,'e63c0054-4f57-471e-a2d8-a929502f4104','boot_roles','reader,member','2025-10-02 12:28:56','2025-10-02 12:29:52','2025-10-02 12:29:52',1),(205,'e63c0054-4f57-471e-a2d8-a929502f4104','hw_machine_type','q35','2025-10-02 12:28:56','2025-10-02 12:29:52','2025-10-02 12:29:52',1),(206,'e63c0054-4f57-471e-a2d8-a929502f4104','hw_cdrom_bus','sata','2025-10-02 12:28:56','2025-10-02 12:29:52','2025-10-02 12:29:52',1),(207,'e63c0054-4f57-471e-a2d8-a929502f4104','hw_disk_bus','virtio','2025-10-02 12:28:56','2025-10-02 12:29:52','2025-10-02 12:29:52',1),(208,'e63c0054-4f57-471e-a2d8-a929502f4104','hw_input_bus','usb','2025-10-02 12:28:56','2025-10-02 12:29:52','2025-10-02 12:29:52',1),(209,'e63c0054-4f57-471e-a2d8-a929502f4104','hw_pointer_model','usbtablet','2025-10-02 12:28:56','2025-10-02 12:29:52','2025-10-02 12:29:52',1),(210,'e63c0054-4f57-471e-a2d8-a929502f4104','hw_video_model','virtio','2025-10-02 12:28:56','2025-10-02 12:29:52','2025-10-02 12:29:52',1),(211,'e63c0054-4f57-471e-a2d8-a929502f4104','hw_vif_model','virtio','2025-10-02 12:28:56','2025-10-02 12:29:52','2025-10-02 12:29:52',1),(212,'e63c0054-4f57-471e-a2d8-a929502f4104','instance_uuid','55bd545d-c449-4749-a3f1-b04f0f37e06e','2025-10-02 12:28:56','2025-10-02 12:29:52','2025-10-02 12:29:52',1),(213,'e63c0054-4f57-471e-a2d8-a929502f4104','user_id','87db7657bb324d029ff3d66f218f1d8d','2025-10-02 12:28:56','2025-10-02 12:29:52','2025-10-02 12:29:52',1),(214,'e63c0054-4f57-471e-a2d8-a929502f4104','image_type','snapshot','2025-10-02 12:28:56','2025-10-02 12:29:52','2025-10-02 12:29:52',1),(215,'e63c0054-4f57-471e-a2d8-a929502f4104','image_state','available','2025-10-02 12:29:05','2025-10-02 12:29:52','2025-10-02 12:29:52',1),(216,'e63c0054-4f57-471e-a2d8-a929502f4104','image_location','snapshot','2025-10-02 12:29:05','2025-10-02 12:29:52','2025-10-02 12:29:52',1),(217,'e63c0054-4f57-471e-a2d8-a929502f4104','owner_id','494736d8288b414094eb0bc6fbaa8cb7','2025-10-02 12:29:05','2025-10-02 12:29:52','2025-10-02 12:29:52',1),(218,'4038405e-7d51-444f-9567-0cdacfa79f42','hw_rng_model','virtio','2025-10-02 12:29:13','2025-10-02 12:29:50','2025-10-02 12:29:50',1),(219,'4038405e-7d51-444f-9567-0cdacfa79f42','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 12:29:13','2025-10-02 12:29:50','2025-10-02 12:29:50',1),(220,'4038405e-7d51-444f-9567-0cdacfa79f42','owner_user_name','tempest-ListImageFiltersTestJSON-1602275258-project-member','2025-10-02 12:29:13','2025-10-02 12:29:50','2025-10-02 12:29:50',1),(221,'4038405e-7d51-444f-9567-0cdacfa79f42','owner_project_name','tempest-ListImageFiltersTestJSON-1602275258','2025-10-02 12:29:13','2025-10-02 12:29:50','2025-10-02 12:29:50',1),(222,'4038405e-7d51-444f-9567-0cdacfa79f42','boot_roles','reader,member','2025-10-02 12:29:13','2025-10-02 12:29:50','2025-10-02 12:29:50',1),(223,'4038405e-7d51-444f-9567-0cdacfa79f42','hw_machine_type','q35','2025-10-02 12:29:13','2025-10-02 12:29:50','2025-10-02 12:29:50',1),(224,'4038405e-7d51-444f-9567-0cdacfa79f42','hw_cdrom_bus','sata','2025-10-02 12:29:13','2025-10-02 12:29:50','2025-10-02 12:29:50',1),(225,'4038405e-7d51-444f-9567-0cdacfa79f42','hw_disk_bus','virtio','2025-10-02 12:29:13','2025-10-02 12:29:50','2025-10-02 12:29:50',1),(226,'4038405e-7d51-444f-9567-0cdacfa79f42','hw_input_bus','usb','2025-10-02 12:29:13','2025-10-02 12:29:50','2025-10-02 12:29:50',1),(227,'4038405e-7d51-444f-9567-0cdacfa79f42','hw_pointer_model','usbtablet','2025-10-02 12:29:13','2025-10-02 12:29:50','2025-10-02 12:29:50',1),(228,'4038405e-7d51-444f-9567-0cdacfa79f42','hw_video_model','virtio','2025-10-02 12:29:13','2025-10-02 12:29:50','2025-10-02 12:29:50',1),(229,'4038405e-7d51-444f-9567-0cdacfa79f42','hw_vif_model','virtio','2025-10-02 12:29:13','2025-10-02 12:29:50','2025-10-02 12:29:50',1),(230,'4038405e-7d51-444f-9567-0cdacfa79f42','instance_uuid','e985fe5c-e98d-4f5b-8985-61a156cde5f9','2025-10-02 12:29:13','2025-10-02 12:29:50','2025-10-02 12:29:50',1),(231,'4038405e-7d51-444f-9567-0cdacfa79f42','user_id','87db7657bb324d029ff3d66f218f1d8d','2025-10-02 12:29:13','2025-10-02 12:29:50','2025-10-02 12:29:50',1),(232,'4038405e-7d51-444f-9567-0cdacfa79f42','image_type','snapshot','2025-10-02 12:29:13','2025-10-02 12:29:50','2025-10-02 12:29:50',1),(233,'4038405e-7d51-444f-9567-0cdacfa79f42','image_location','snapshot','2025-10-02 12:29:22','2025-10-02 12:29:50','2025-10-02 12:29:50',1),(234,'4038405e-7d51-444f-9567-0cdacfa79f42','owner_id','494736d8288b414094eb0bc6fbaa8cb7','2025-10-02 12:29:22','2025-10-02 12:29:50','2025-10-02 12:29:50',1),(235,'4038405e-7d51-444f-9567-0cdacfa79f42','image_state','available','2025-10-02 12:29:22','2025-10-02 12:29:50','2025-10-02 12:29:50',1),(236,'d0dced0b-1a65-4528-9713-633878d7128b','hw_rng_model','virtio','2025-10-02 12:29:25','2025-10-02 12:29:46','2025-10-02 12:29:46',1),(237,'d0dced0b-1a65-4528-9713-633878d7128b','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 12:29:25','2025-10-02 12:29:46','2025-10-02 12:29:46',1),(238,'d0dced0b-1a65-4528-9713-633878d7128b','owner_user_name','tempest-ListImageFiltersTestJSON-1602275258-project-member','2025-10-02 12:29:25','2025-10-02 12:29:46','2025-10-02 12:29:46',1),(239,'d0dced0b-1a65-4528-9713-633878d7128b','owner_project_name','tempest-ListImageFiltersTestJSON-1602275258','2025-10-02 12:29:25','2025-10-02 12:29:46','2025-10-02 12:29:46',1),(240,'d0dced0b-1a65-4528-9713-633878d7128b','boot_roles','reader,member','2025-10-02 12:29:25','2025-10-02 12:29:46','2025-10-02 12:29:46',1),(241,'d0dced0b-1a65-4528-9713-633878d7128b','hw_machine_type','q35','2025-10-02 12:29:25','2025-10-02 12:29:46','2025-10-02 12:29:46',1),(242,'d0dced0b-1a65-4528-9713-633878d7128b','hw_cdrom_bus','sata','2025-10-02 12:29:25','2025-10-02 12:29:46','2025-10-02 12:29:46',1),(243,'d0dced0b-1a65-4528-9713-633878d7128b','hw_disk_bus','virtio','2025-10-02 12:29:25','2025-10-02 12:29:46','2025-10-02 12:29:46',1),(244,'d0dced0b-1a65-4528-9713-633878d7128b','hw_input_bus','usb','2025-10-02 12:29:25','2025-10-02 12:29:46','2025-10-02 12:29:46',1),(245,'d0dced0b-1a65-4528-9713-633878d7128b','hw_pointer_model','usbtablet','2025-10-02 12:29:25','2025-10-02 12:29:46','2025-10-02 12:29:46',1),(246,'d0dced0b-1a65-4528-9713-633878d7128b','hw_video_model','virtio','2025-10-02 12:29:25','2025-10-02 12:29:46','2025-10-02 12:29:46',1),(247,'d0dced0b-1a65-4528-9713-633878d7128b','hw_vif_model','virtio','2025-10-02 12:29:25','2025-10-02 12:29:46','2025-10-02 12:29:46',1),(248,'d0dced0b-1a65-4528-9713-633878d7128b','instance_uuid','55bd545d-c449-4749-a3f1-b04f0f37e06e','2025-10-02 12:29:25','2025-10-02 12:29:46','2025-10-02 12:29:46',1),(249,'d0dced0b-1a65-4528-9713-633878d7128b','user_id','87db7657bb324d029ff3d66f218f1d8d','2025-10-02 12:29:25','2025-10-02 12:29:46','2025-10-02 12:29:46',1),(250,'d0dced0b-1a65-4528-9713-633878d7128b','image_type','snapshot','2025-10-02 12:29:25','2025-10-02 12:29:46','2025-10-02 12:29:46',1),(251,'d0dced0b-1a65-4528-9713-633878d7128b','image_state','available','2025-10-02 12:29:33','2025-10-02 12:29:46','2025-10-02 12:29:46',1),(252,'d0dced0b-1a65-4528-9713-633878d7128b','image_location','snapshot','2025-10-02 12:29:33','2025-10-02 12:29:46','2025-10-02 12:29:46',1),(253,'d0dced0b-1a65-4528-9713-633878d7128b','owner_id','494736d8288b414094eb0bc6fbaa8cb7','2025-10-02 12:29:33','2025-10-02 12:29:46','2025-10-02 12:29:46',1),(254,'d47d5adb-8963-4735-aac4-73e6ace2936e','hw_rng_model','virtio','2025-10-02 12:37:24','2025-10-02 12:42:58','2025-10-02 12:42:58',1),(255,'d47d5adb-8963-4735-aac4-73e6ace2936e','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 12:37:24','2025-10-02 12:42:58','2025-10-02 12:42:58',1),(256,'d47d5adb-8963-4735-aac4-73e6ace2936e','owner_user_name','tempest-ServerStableDeviceRescueTest-2109974660-project-member','2025-10-02 12:37:24','2025-10-02 12:42:58','2025-10-02 12:42:58',1),(257,'d47d5adb-8963-4735-aac4-73e6ace2936e','owner_project_name','tempest-ServerStableDeviceRescueTest-2109974660','2025-10-02 12:37:24','2025-10-02 12:42:58','2025-10-02 12:42:58',1),(258,'d47d5adb-8963-4735-aac4-73e6ace2936e','boot_roles','member,reader','2025-10-02 12:37:24','2025-10-02 12:42:58','2025-10-02 12:42:58',1),(259,'d47d5adb-8963-4735-aac4-73e6ace2936e','hw_machine_type','q35','2025-10-02 12:37:24','2025-10-02 12:42:58','2025-10-02 12:42:58',1),(260,'d47d5adb-8963-4735-aac4-73e6ace2936e','hw_cdrom_bus','sata','2025-10-02 12:37:24','2025-10-02 12:42:58','2025-10-02 12:42:58',1),(261,'d47d5adb-8963-4735-aac4-73e6ace2936e','hw_disk_bus','virtio','2025-10-02 12:37:24','2025-10-02 12:42:58','2025-10-02 12:42:58',1),(262,'d47d5adb-8963-4735-aac4-73e6ace2936e','hw_input_bus','usb','2025-10-02 12:37:24','2025-10-02 12:42:58','2025-10-02 12:42:58',1),(263,'d47d5adb-8963-4735-aac4-73e6ace2936e','hw_pointer_model','usbtablet','2025-10-02 12:37:24','2025-10-02 12:42:58','2025-10-02 12:42:58',1),(264,'d47d5adb-8963-4735-aac4-73e6ace2936e','hw_video_model','virtio','2025-10-02 12:37:24','2025-10-02 12:42:58','2025-10-02 12:42:58',1),(265,'d47d5adb-8963-4735-aac4-73e6ace2936e','hw_vif_model','virtio','2025-10-02 12:37:24','2025-10-02 12:42:58','2025-10-02 12:42:58',1),(266,'d47d5adb-8963-4735-aac4-73e6ace2936e','instance_uuid','dc4a4f9d-2d68-4b95-a651-f1817489ccd6','2025-10-02 12:37:24','2025-10-02 12:42:58','2025-10-02 12:42:58',1),(267,'d47d5adb-8963-4735-aac4-73e6ace2936e','user_id','fdbe447f49374937a828d6281949a2a4','2025-10-02 12:37:24','2025-10-02 12:42:58','2025-10-02 12:42:58',1),(268,'d47d5adb-8963-4735-aac4-73e6ace2936e','image_type','snapshot','2025-10-02 12:37:24','2025-10-02 12:42:58','2025-10-02 12:42:58',1),(269,'d47d5adb-8963-4735-aac4-73e6ace2936e','image_location','snapshot','2025-10-02 12:37:32','2025-10-02 12:42:58','2025-10-02 12:42:58',1),(270,'d47d5adb-8963-4735-aac4-73e6ace2936e','owner_id','a79bb765ab1e4aa18672c9641b6187b9','2025-10-02 12:37:32','2025-10-02 12:42:58','2025-10-02 12:42:58',1),(271,'d47d5adb-8963-4735-aac4-73e6ace2936e','image_state','available','2025-10-02 12:37:32','2025-10-02 12:42:58','2025-10-02 12:42:58',1),(272,'d47d5adb-8963-4735-aac4-73e6ace2936e','hw_rescue_bus','scsi','2025-10-02 12:37:34','2025-10-02 12:42:58','2025-10-02 12:42:58',1),(273,'d47d5adb-8963-4735-aac4-73e6ace2936e','hw_rescue_device','disk','2025-10-02 12:37:34','2025-10-02 12:42:58','2025-10-02 12:42:58',1),(274,'44da8c0b-0cdf-4949-9ff7-57e81c0d3d70','hw_rng_model','virtio','2025-10-02 12:38:08','2025-10-02 12:42:48','2025-10-02 12:42:48',1),(275,'44da8c0b-0cdf-4949-9ff7-57e81c0d3d70','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 12:38:08','2025-10-02 12:42:48','2025-10-02 12:42:48',1),(276,'44da8c0b-0cdf-4949-9ff7-57e81c0d3d70','owner_user_name','tempest-ServerStableDeviceRescueTest-2109974660-project-member','2025-10-02 12:38:08','2025-10-02 12:42:48','2025-10-02 12:42:48',1),(277,'44da8c0b-0cdf-4949-9ff7-57e81c0d3d70','owner_project_name','tempest-ServerStableDeviceRescueTest-2109974660','2025-10-02 12:38:08','2025-10-02 12:42:48','2025-10-02 12:42:48',1),(278,'44da8c0b-0cdf-4949-9ff7-57e81c0d3d70','boot_roles','member,reader','2025-10-02 12:38:08','2025-10-02 12:42:48','2025-10-02 12:42:48',1),(279,'44da8c0b-0cdf-4949-9ff7-57e81c0d3d70','hw_machine_type','q35','2025-10-02 12:38:08','2025-10-02 12:42:48','2025-10-02 12:42:48',1),(280,'44da8c0b-0cdf-4949-9ff7-57e81c0d3d70','hw_cdrom_bus','sata','2025-10-02 12:38:08','2025-10-02 12:42:48','2025-10-02 12:42:48',1),(281,'44da8c0b-0cdf-4949-9ff7-57e81c0d3d70','hw_disk_bus','virtio','2025-10-02 12:38:08','2025-10-02 12:42:48','2025-10-02 12:42:48',1),(282,'44da8c0b-0cdf-4949-9ff7-57e81c0d3d70','hw_input_bus','usb','2025-10-02 12:38:08','2025-10-02 12:42:48','2025-10-02 12:42:48',1),(283,'44da8c0b-0cdf-4949-9ff7-57e81c0d3d70','hw_pointer_model','usbtablet','2025-10-02 12:38:08','2025-10-02 12:42:48','2025-10-02 12:42:48',1),(284,'44da8c0b-0cdf-4949-9ff7-57e81c0d3d70','hw_video_model','virtio','2025-10-02 12:38:08','2025-10-02 12:42:48','2025-10-02 12:42:48',1),(285,'44da8c0b-0cdf-4949-9ff7-57e81c0d3d70','hw_vif_model','virtio','2025-10-02 12:38:08','2025-10-02 12:42:48','2025-10-02 12:42:48',1),(286,'44da8c0b-0cdf-4949-9ff7-57e81c0d3d70','instance_uuid','1546ac1d-4a04-4c5e-ae02-b005461c7731','2025-10-02 12:38:08','2025-10-02 12:42:48','2025-10-02 12:42:48',1),(287,'44da8c0b-0cdf-4949-9ff7-57e81c0d3d70','user_id','fdbe447f49374937a828d6281949a2a4','2025-10-02 12:38:08','2025-10-02 12:42:48','2025-10-02 12:42:48',1),(288,'44da8c0b-0cdf-4949-9ff7-57e81c0d3d70','image_type','snapshot','2025-10-02 12:38:08','2025-10-02 12:42:48','2025-10-02 12:42:48',1),(289,'44da8c0b-0cdf-4949-9ff7-57e81c0d3d70','owner_id','a79bb765ab1e4aa18672c9641b6187b9','2025-10-02 12:38:13','2025-10-02 12:42:48','2025-10-02 12:42:48',1),(290,'44da8c0b-0cdf-4949-9ff7-57e81c0d3d70','image_state','available','2025-10-02 12:38:13','2025-10-02 12:42:48','2025-10-02 12:42:48',1),(291,'44da8c0b-0cdf-4949-9ff7-57e81c0d3d70','image_location','snapshot','2025-10-02 12:38:13','2025-10-02 12:42:48','2025-10-02 12:42:48',1),(292,'44da8c0b-0cdf-4949-9ff7-57e81c0d3d70','hw_rescue_bus','usb','2025-10-02 12:38:16','2025-10-02 12:42:48','2025-10-02 12:42:48',1),(293,'44da8c0b-0cdf-4949-9ff7-57e81c0d3d70','hw_rescue_device','disk','2025-10-02 12:38:16','2025-10-02 12:42:48','2025-10-02 12:42:48',1),(294,'845ab049-b1a7-4b63-95d7-72464046ac90','hw_rng_model','virtio','2025-10-02 12:39:17','2025-10-02 12:42:37','2025-10-02 12:42:37',1),(295,'845ab049-b1a7-4b63-95d7-72464046ac90','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 12:39:17','2025-10-02 12:42:37','2025-10-02 12:42:37',1),(296,'845ab049-b1a7-4b63-95d7-72464046ac90','owner_user_name','tempest-ServerStableDeviceRescueTest-2109974660-project-member','2025-10-02 12:39:17','2025-10-02 12:42:37','2025-10-02 12:42:37',1),(297,'845ab049-b1a7-4b63-95d7-72464046ac90','owner_project_name','tempest-ServerStableDeviceRescueTest-2109974660','2025-10-02 12:39:17','2025-10-02 12:42:37','2025-10-02 12:42:37',1),(298,'845ab049-b1a7-4b63-95d7-72464046ac90','boot_roles','member,reader','2025-10-02 12:39:17','2025-10-02 12:42:37','2025-10-02 12:42:37',1),(299,'845ab049-b1a7-4b63-95d7-72464046ac90','hw_machine_type','q35','2025-10-02 12:39:17','2025-10-02 12:42:37','2025-10-02 12:42:37',1),(300,'845ab049-b1a7-4b63-95d7-72464046ac90','hw_cdrom_bus','sata','2025-10-02 12:39:17','2025-10-02 12:42:37','2025-10-02 12:42:37',1),(301,'845ab049-b1a7-4b63-95d7-72464046ac90','hw_disk_bus','virtio','2025-10-02 12:39:17','2025-10-02 12:42:37','2025-10-02 12:42:37',1),(302,'845ab049-b1a7-4b63-95d7-72464046ac90','hw_input_bus','usb','2025-10-02 12:39:17','2025-10-02 12:42:37','2025-10-02 12:42:37',1),(303,'845ab049-b1a7-4b63-95d7-72464046ac90','hw_pointer_model','usbtablet','2025-10-02 12:39:17','2025-10-02 12:42:37','2025-10-02 12:42:37',1),(304,'845ab049-b1a7-4b63-95d7-72464046ac90','hw_video_model','virtio','2025-10-02 12:39:17','2025-10-02 12:42:37','2025-10-02 12:42:37',1),(305,'845ab049-b1a7-4b63-95d7-72464046ac90','hw_vif_model','virtio','2025-10-02 12:39:17','2025-10-02 12:42:37','2025-10-02 12:42:37',1),(306,'845ab049-b1a7-4b63-95d7-72464046ac90','instance_uuid','2a9f318e-50b4-47f5-b281-128055b9d810','2025-10-02 12:39:17','2025-10-02 12:42:37','2025-10-02 12:42:37',1),(307,'845ab049-b1a7-4b63-95d7-72464046ac90','user_id','fdbe447f49374937a828d6281949a2a4','2025-10-02 12:39:17','2025-10-02 12:42:37','2025-10-02 12:42:37',1),(308,'845ab049-b1a7-4b63-95d7-72464046ac90','image_type','snapshot','2025-10-02 12:39:17','2025-10-02 12:42:37','2025-10-02 12:42:37',1),(309,'845ab049-b1a7-4b63-95d7-72464046ac90','image_location','snapshot','2025-10-02 12:39:26','2025-10-02 12:42:37','2025-10-02 12:42:37',1),(310,'845ab049-b1a7-4b63-95d7-72464046ac90','owner_id','a79bb765ab1e4aa18672c9641b6187b9','2025-10-02 12:39:26','2025-10-02 12:42:37','2025-10-02 12:42:37',1),(311,'845ab049-b1a7-4b63-95d7-72464046ac90','image_state','available','2025-10-02 12:39:26','2025-10-02 12:42:37','2025-10-02 12:42:37',1),(312,'845ab049-b1a7-4b63-95d7-72464046ac90','hw_rescue_bus','virtio','2025-10-02 12:39:30','2025-10-02 12:42:37','2025-10-02 12:42:37',1),(313,'845ab049-b1a7-4b63-95d7-72464046ac90','hw_rescue_device','disk','2025-10-02 12:39:30','2025-10-02 12:42:37','2025-10-02 12:42:37',1),(314,'2d2735c8-c9f0-487a-8b58-3e359fca2f77','hw_rng_model','virtio','2025-10-02 12:41:07','2025-10-02 12:42:24','2025-10-02 12:42:24',1),(315,'2d2735c8-c9f0-487a-8b58-3e359fca2f77','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 12:41:07','2025-10-02 12:42:24','2025-10-02 12:42:24',1),(316,'2d2735c8-c9f0-487a-8b58-3e359fca2f77','owner_user_name','tempest-ServerStableDeviceRescueTest-2109974660-project-member','2025-10-02 12:41:07','2025-10-02 12:42:24','2025-10-02 12:42:24',1),(317,'2d2735c8-c9f0-487a-8b58-3e359fca2f77','owner_project_name','tempest-ServerStableDeviceRescueTest-2109974660','2025-10-02 12:41:07','2025-10-02 12:42:24','2025-10-02 12:42:24',1),(318,'2d2735c8-c9f0-487a-8b58-3e359fca2f77','boot_roles','member,reader','2025-10-02 12:41:07','2025-10-02 12:42:24','2025-10-02 12:42:24',1),(319,'2d2735c8-c9f0-487a-8b58-3e359fca2f77','hw_machine_type','q35','2025-10-02 12:41:07','2025-10-02 12:42:24','2025-10-02 12:42:24',1),(320,'2d2735c8-c9f0-487a-8b58-3e359fca2f77','hw_cdrom_bus','sata','2025-10-02 12:41:07','2025-10-02 12:42:24','2025-10-02 12:42:24',1),(321,'2d2735c8-c9f0-487a-8b58-3e359fca2f77','hw_disk_bus','virtio','2025-10-02 12:41:07','2025-10-02 12:42:24','2025-10-02 12:42:24',1),(322,'2d2735c8-c9f0-487a-8b58-3e359fca2f77','hw_input_bus','usb','2025-10-02 12:41:07','2025-10-02 12:42:24','2025-10-02 12:42:24',1),(323,'2d2735c8-c9f0-487a-8b58-3e359fca2f77','hw_pointer_model','usbtablet','2025-10-02 12:41:07','2025-10-02 12:42:24','2025-10-02 12:42:24',1),(324,'2d2735c8-c9f0-487a-8b58-3e359fca2f77','hw_video_model','virtio','2025-10-02 12:41:07','2025-10-02 12:42:24','2025-10-02 12:42:24',1),(325,'2d2735c8-c9f0-487a-8b58-3e359fca2f77','hw_vif_model','virtio','2025-10-02 12:41:07','2025-10-02 12:42:24','2025-10-02 12:42:24',1),(326,'2d2735c8-c9f0-487a-8b58-3e359fca2f77','instance_uuid','e5acbf2d-74bd-452c-8732-db2f1c0739ff','2025-10-02 12:41:07','2025-10-02 12:42:24','2025-10-02 12:42:24',1),(327,'2d2735c8-c9f0-487a-8b58-3e359fca2f77','user_id','fdbe447f49374937a828d6281949a2a4','2025-10-02 12:41:07','2025-10-02 12:42:24','2025-10-02 12:42:24',1),(328,'2d2735c8-c9f0-487a-8b58-3e359fca2f77','image_type','snapshot','2025-10-02 12:41:07','2025-10-02 12:42:24','2025-10-02 12:42:24',1),(329,'2d2735c8-c9f0-487a-8b58-3e359fca2f77','owner_id','a79bb765ab1e4aa18672c9641b6187b9','2025-10-02 12:41:14','2025-10-02 12:42:24','2025-10-02 12:42:24',1),(330,'2d2735c8-c9f0-487a-8b58-3e359fca2f77','image_state','available','2025-10-02 12:41:14','2025-10-02 12:42:24','2025-10-02 12:42:24',1),(331,'2d2735c8-c9f0-487a-8b58-3e359fca2f77','image_location','snapshot','2025-10-02 12:41:14','2025-10-02 12:42:24','2025-10-02 12:42:24',1),(332,'2d2735c8-c9f0-487a-8b58-3e359fca2f77','hw_rescue_bus','virtio','2025-10-02 12:41:18','2025-10-02 12:42:24','2025-10-02 12:42:24',1),(333,'2d2735c8-c9f0-487a-8b58-3e359fca2f77','hw_rescue_device','disk','2025-10-02 12:41:18','2025-10-02 12:42:24','2025-10-02 12:42:24',1),(334,'c37f4151-ac68-47f8-adfa-bd0c85e4c75d','hw_rng_model','virtio','2025-10-02 12:42:34','2025-10-02 12:43:13','2025-10-02 12:43:13',1),(335,'c37f4151-ac68-47f8-adfa-bd0c85e4c75d','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 12:42:34','2025-10-02 12:43:13','2025-10-02 12:43:13',1),(336,'c37f4151-ac68-47f8-adfa-bd0c85e4c75d','owner_user_name','tempest-AttachVolumeShelveTestJSON-1943710095-project-member','2025-10-02 12:42:34','2025-10-02 12:43:13','2025-10-02 12:43:13',1),(337,'c37f4151-ac68-47f8-adfa-bd0c85e4c75d','owner_project_name','tempest-AttachVolumeShelveTestJSON-1943710095','2025-10-02 12:42:34','2025-10-02 12:43:13','2025-10-02 12:43:13',1),(338,'c37f4151-ac68-47f8-adfa-bd0c85e4c75d','boot_roles','reader,member','2025-10-02 12:42:34','2025-10-02 12:43:13','2025-10-02 12:43:13',1),(339,'c37f4151-ac68-47f8-adfa-bd0c85e4c75d','hw_machine_type','q35','2025-10-02 12:42:34','2025-10-02 12:43:13','2025-10-02 12:43:13',1),(340,'c37f4151-ac68-47f8-adfa-bd0c85e4c75d','hw_cdrom_bus','sata','2025-10-02 12:42:34','2025-10-02 12:43:13','2025-10-02 12:43:13',1),(341,'c37f4151-ac68-47f8-adfa-bd0c85e4c75d','hw_disk_bus','virtio','2025-10-02 12:42:34','2025-10-02 12:43:13','2025-10-02 12:43:13',1),(342,'c37f4151-ac68-47f8-adfa-bd0c85e4c75d','hw_input_bus','usb','2025-10-02 12:42:34','2025-10-02 12:43:13','2025-10-02 12:43:13',1),(343,'c37f4151-ac68-47f8-adfa-bd0c85e4c75d','hw_pointer_model','usbtablet','2025-10-02 12:42:34','2025-10-02 12:43:13','2025-10-02 12:43:13',1),(344,'c37f4151-ac68-47f8-adfa-bd0c85e4c75d','hw_video_model','virtio','2025-10-02 12:42:34','2025-10-02 12:43:13','2025-10-02 12:43:13',1),(345,'c37f4151-ac68-47f8-adfa-bd0c85e4c75d','hw_vif_model','virtio','2025-10-02 12:42:34','2025-10-02 12:43:13','2025-10-02 12:43:13',1),(346,'c37f4151-ac68-47f8-adfa-bd0c85e4c75d','instance_uuid','1f9101c6-f4d8-46c7-8884-386f9f08e6fb','2025-10-02 12:42:34','2025-10-02 12:43:13','2025-10-02 12:43:13',1),(347,'c37f4151-ac68-47f8-adfa-bd0c85e4c75d','user_id','3151966e941f4652ba984616bfa760c7','2025-10-02 12:42:34','2025-10-02 12:43:13','2025-10-02 12:43:13',1),(348,'c37f4151-ac68-47f8-adfa-bd0c85e4c75d','image_type','snapshot','2025-10-02 12:42:34','2025-10-02 12:43:13','2025-10-02 12:43:13',1),(349,'c37f4151-ac68-47f8-adfa-bd0c85e4c75d','image_state','available','2025-10-02 12:42:43','2025-10-02 12:43:13','2025-10-02 12:43:13',1),(350,'c37f4151-ac68-47f8-adfa-bd0c85e4c75d','image_location','snapshot','2025-10-02 12:42:43','2025-10-02 12:43:13','2025-10-02 12:43:13',1),(351,'c37f4151-ac68-47f8-adfa-bd0c85e4c75d','owner_id','f7e2edef094b4ba5a56a5ec5ffce911e','2025-10-02 12:42:43','2025-10-02 12:43:13','2025-10-02 12:43:13',1),(352,'8ef5cf5e-703e-423e-815f-02321271fc3c','hw_rng_model','virtio','2025-10-02 12:44:03','2025-10-02 12:45:07','2025-10-02 12:45:07',1),(353,'8ef5cf5e-703e-423e-815f-02321271fc3c','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 12:44:03','2025-10-02 12:45:07','2025-10-02 12:45:07',1),(354,'8ef5cf5e-703e-423e-815f-02321271fc3c','owner_user_name','tempest-DeleteServersTestJSON-1740298646-project-member','2025-10-02 12:44:03','2025-10-02 12:45:07','2025-10-02 12:45:07',1),(355,'8ef5cf5e-703e-423e-815f-02321271fc3c','owner_project_name','tempest-DeleteServersTestJSON-1740298646','2025-10-02 12:44:03','2025-10-02 12:45:07','2025-10-02 12:45:07',1),(356,'8ef5cf5e-703e-423e-815f-02321271fc3c','boot_roles','reader,member','2025-10-02 12:44:03','2025-10-02 12:45:07','2025-10-02 12:45:07',1),(357,'8ef5cf5e-703e-423e-815f-02321271fc3c','hw_machine_type','q35','2025-10-02 12:44:03','2025-10-02 12:45:07','2025-10-02 12:45:07',1),(358,'8ef5cf5e-703e-423e-815f-02321271fc3c','hw_cdrom_bus','sata','2025-10-02 12:44:03','2025-10-02 12:45:07','2025-10-02 12:45:07',1),(359,'8ef5cf5e-703e-423e-815f-02321271fc3c','hw_disk_bus','virtio','2025-10-02 12:44:03','2025-10-02 12:45:07','2025-10-02 12:45:07',1),(360,'8ef5cf5e-703e-423e-815f-02321271fc3c','hw_input_bus','usb','2025-10-02 12:44:03','2025-10-02 12:45:07','2025-10-02 12:45:07',1),(361,'8ef5cf5e-703e-423e-815f-02321271fc3c','hw_pointer_model','usbtablet','2025-10-02 12:44:03','2025-10-02 12:45:07','2025-10-02 12:45:07',1),(362,'8ef5cf5e-703e-423e-815f-02321271fc3c','hw_video_model','virtio','2025-10-02 12:44:03','2025-10-02 12:45:07','2025-10-02 12:45:07',1),(363,'8ef5cf5e-703e-423e-815f-02321271fc3c','hw_vif_model','virtio','2025-10-02 12:44:03','2025-10-02 12:45:07','2025-10-02 12:45:07',1),(364,'8ef5cf5e-703e-423e-815f-02321271fc3c','instance_uuid','2c258788-9569-41b0-9163-e8ea9985b91c','2025-10-02 12:44:03','2025-10-02 12:45:07','2025-10-02 12:45:07',1),(365,'8ef5cf5e-703e-423e-815f-02321271fc3c','user_id','ae7bcf1e6a3b4132a7068b0f863ca79c','2025-10-02 12:44:03','2025-10-02 12:45:07','2025-10-02 12:45:07',1),(366,'8ef5cf5e-703e-423e-815f-02321271fc3c','image_type','snapshot','2025-10-02 12:44:03','2025-10-02 12:45:07','2025-10-02 12:45:07',1),(367,'3866598c-0b46-42ff-ba05-28dab62cd167','hw_rng_model','virtio','2025-10-02 12:44:41','2025-10-02 12:45:29','2025-10-02 12:45:29',1),(368,'3866598c-0b46-42ff-ba05-28dab62cd167','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 12:44:41','2025-10-02 12:45:29','2025-10-02 12:45:29',1),(369,'3866598c-0b46-42ff-ba05-28dab62cd167','owner_user_name','tempest-AttachVolumeShelveTestJSON-1943710095-project-member','2025-10-02 12:44:41','2025-10-02 12:45:29','2025-10-02 12:45:29',1),(370,'3866598c-0b46-42ff-ba05-28dab62cd167','owner_project_name','tempest-AttachVolumeShelveTestJSON-1943710095','2025-10-02 12:44:41','2025-10-02 12:45:29','2025-10-02 12:45:29',1),(371,'3866598c-0b46-42ff-ba05-28dab62cd167','boot_roles','member,reader','2025-10-02 12:44:41','2025-10-02 12:45:29','2025-10-02 12:45:29',1),(372,'3866598c-0b46-42ff-ba05-28dab62cd167','hw_machine_type','q35','2025-10-02 12:44:41','2025-10-02 12:45:29','2025-10-02 12:45:29',1),(373,'3866598c-0b46-42ff-ba05-28dab62cd167','hw_cdrom_bus','sata','2025-10-02 12:44:41','2025-10-02 12:45:29','2025-10-02 12:45:29',1),(374,'3866598c-0b46-42ff-ba05-28dab62cd167','hw_disk_bus','virtio','2025-10-02 12:44:41','2025-10-02 12:45:29','2025-10-02 12:45:29',1),(375,'3866598c-0b46-42ff-ba05-28dab62cd167','hw_input_bus','usb','2025-10-02 12:44:41','2025-10-02 12:45:29','2025-10-02 12:45:29',1),(376,'3866598c-0b46-42ff-ba05-28dab62cd167','hw_pointer_model','usbtablet','2025-10-02 12:44:41','2025-10-02 12:45:29','2025-10-02 12:45:29',1),(377,'3866598c-0b46-42ff-ba05-28dab62cd167','hw_video_model','virtio','2025-10-02 12:44:41','2025-10-02 12:45:29','2025-10-02 12:45:29',1),(378,'3866598c-0b46-42ff-ba05-28dab62cd167','hw_vif_model','virtio','2025-10-02 12:44:41','2025-10-02 12:45:29','2025-10-02 12:45:29',1),(379,'3866598c-0b46-42ff-ba05-28dab62cd167','instance_uuid','9aff2d67-195f-4081-9a1c-ba173a39af9d','2025-10-02 12:44:41','2025-10-02 12:45:29','2025-10-02 12:45:29',1),(380,'3866598c-0b46-42ff-ba05-28dab62cd167','user_id','3151966e941f4652ba984616bfa760c7','2025-10-02 12:44:41','2025-10-02 12:45:29','2025-10-02 12:45:29',1),(381,'3866598c-0b46-42ff-ba05-28dab62cd167','image_type','snapshot','2025-10-02 12:44:41','2025-10-02 12:45:29','2025-10-02 12:45:29',1),(382,'8ef5cf5e-703e-423e-815f-02321271fc3c','image_location','snapshot','2025-10-02 12:44:43','2025-10-02 12:45:07','2025-10-02 12:45:07',1),(383,'8ef5cf5e-703e-423e-815f-02321271fc3c','owner_id','58b2fa4ee0cd4b97be1b303c203be14f','2025-10-02 12:44:43','2025-10-02 12:45:07','2025-10-02 12:45:07',1),(384,'8ef5cf5e-703e-423e-815f-02321271fc3c','image_state','available','2025-10-02 12:44:43','2025-10-02 12:45:07','2025-10-02 12:45:07',1),(385,'3866598c-0b46-42ff-ba05-28dab62cd167','owner_id','f7e2edef094b4ba5a56a5ec5ffce911e','2025-10-02 12:44:59','2025-10-02 12:45:29','2025-10-02 12:45:29',1),(386,'3866598c-0b46-42ff-ba05-28dab62cd167','image_state','available','2025-10-02 12:44:59','2025-10-02 12:45:29','2025-10-02 12:45:29',1),(387,'3866598c-0b46-42ff-ba05-28dab62cd167','image_location','snapshot','2025-10-02 12:44:59','2025-10-02 12:45:29','2025-10-02 12:45:29',1),(388,'732edfd9-86ec-4c72-a1b2-37aec374791c','hw_rng_model','virtio','2025-10-02 12:46:27','2025-10-02 12:46:59','2025-10-02 12:46:59',1),(389,'732edfd9-86ec-4c72-a1b2-37aec374791c','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 12:46:27','2025-10-02 12:46:59','2025-10-02 12:46:59',1),(390,'732edfd9-86ec-4c72-a1b2-37aec374791c','owner_user_name','tempest-ServerActionsTestOtherB-858400398-project-member','2025-10-02 12:46:27','2025-10-02 12:46:59','2025-10-02 12:46:59',1),(391,'732edfd9-86ec-4c72-a1b2-37aec374791c','owner_project_name','tempest-ServerActionsTestOtherB-858400398','2025-10-02 12:46:27','2025-10-02 12:46:59','2025-10-02 12:46:59',1),(392,'732edfd9-86ec-4c72-a1b2-37aec374791c','boot_roles','reader,member','2025-10-02 12:46:27','2025-10-02 12:46:59','2025-10-02 12:46:59',1),(393,'732edfd9-86ec-4c72-a1b2-37aec374791c','hw_machine_type','q35','2025-10-02 12:46:27','2025-10-02 12:46:59','2025-10-02 12:46:59',1),(394,'732edfd9-86ec-4c72-a1b2-37aec374791c','hw_cdrom_bus','sata','2025-10-02 12:46:27','2025-10-02 12:46:59','2025-10-02 12:46:59',1),(395,'732edfd9-86ec-4c72-a1b2-37aec374791c','hw_disk_bus','virtio','2025-10-02 12:46:27','2025-10-02 12:46:59','2025-10-02 12:46:59',1),(396,'732edfd9-86ec-4c72-a1b2-37aec374791c','hw_input_bus','usb','2025-10-02 12:46:27','2025-10-02 12:46:59','2025-10-02 12:46:59',1),(397,'732edfd9-86ec-4c72-a1b2-37aec374791c','hw_pointer_model','usbtablet','2025-10-02 12:46:27','2025-10-02 12:46:59','2025-10-02 12:46:59',1),(398,'732edfd9-86ec-4c72-a1b2-37aec374791c','hw_video_model','virtio','2025-10-02 12:46:27','2025-10-02 12:46:59','2025-10-02 12:46:59',1),(399,'732edfd9-86ec-4c72-a1b2-37aec374791c','hw_vif_model','virtio','2025-10-02 12:46:27','2025-10-02 12:46:59','2025-10-02 12:46:59',1),(400,'732edfd9-86ec-4c72-a1b2-37aec374791c','instance_uuid','2c1bf1aa-8fcd-4688-b50c-1b331a3bc8d4','2025-10-02 12:46:27','2025-10-02 12:46:59','2025-10-02 12:46:59',1),(401,'732edfd9-86ec-4c72-a1b2-37aec374791c','user_id','b5104e5372994cd19b720862cf1ca2ce','2025-10-02 12:46:27','2025-10-02 12:46:59','2025-10-02 12:46:59',1),(402,'732edfd9-86ec-4c72-a1b2-37aec374791c','image_type','backup','2025-10-02 12:46:27','2025-10-02 12:46:59','2025-10-02 12:46:59',1),(403,'732edfd9-86ec-4c72-a1b2-37aec374791c','backup_type','daily','2025-10-02 12:46:27','2025-10-02 12:46:59','2025-10-02 12:46:59',1),(404,'732edfd9-86ec-4c72-a1b2-37aec374791c','image_location','snapshot','2025-10-02 12:46:32','2025-10-02 12:46:59','2025-10-02 12:46:59',1),(405,'732edfd9-86ec-4c72-a1b2-37aec374791c','owner_id','dbd0afdfb05849f9abfe4cd4454f6a13','2025-10-02 12:46:32','2025-10-02 12:46:59','2025-10-02 12:46:59',1),(406,'732edfd9-86ec-4c72-a1b2-37aec374791c','image_state','available','2025-10-02 12:46:32','2025-10-02 12:46:59','2025-10-02 12:46:59',1),(407,'ab4ee30b-1b9c-4a28-9b76-c933be04775b','hw_rng_model','virtio','2025-10-02 12:46:35','2025-10-02 12:47:06','2025-10-02 12:47:06',1),(408,'ab4ee30b-1b9c-4a28-9b76-c933be04775b','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 12:46:35','2025-10-02 12:47:06','2025-10-02 12:47:06',1),(409,'ab4ee30b-1b9c-4a28-9b76-c933be04775b','owner_user_name','tempest-ServerActionsTestOtherB-858400398-project-member','2025-10-02 12:46:35','2025-10-02 12:47:06','2025-10-02 12:47:06',1),(410,'ab4ee30b-1b9c-4a28-9b76-c933be04775b','owner_project_name','tempest-ServerActionsTestOtherB-858400398','2025-10-02 12:46:35','2025-10-02 12:47:06','2025-10-02 12:47:06',1),(411,'ab4ee30b-1b9c-4a28-9b76-c933be04775b','boot_roles','reader,member','2025-10-02 12:46:35','2025-10-02 12:47:06','2025-10-02 12:47:06',1),(412,'ab4ee30b-1b9c-4a28-9b76-c933be04775b','hw_machine_type','q35','2025-10-02 12:46:35','2025-10-02 12:47:06','2025-10-02 12:47:06',1),(413,'ab4ee30b-1b9c-4a28-9b76-c933be04775b','hw_cdrom_bus','sata','2025-10-02 12:46:35','2025-10-02 12:47:06','2025-10-02 12:47:06',1),(414,'ab4ee30b-1b9c-4a28-9b76-c933be04775b','hw_disk_bus','virtio','2025-10-02 12:46:35','2025-10-02 12:47:06','2025-10-02 12:47:06',1),(415,'ab4ee30b-1b9c-4a28-9b76-c933be04775b','hw_input_bus','usb','2025-10-02 12:46:35','2025-10-02 12:47:06','2025-10-02 12:47:06',1),(416,'ab4ee30b-1b9c-4a28-9b76-c933be04775b','hw_pointer_model','usbtablet','2025-10-02 12:46:35','2025-10-02 12:47:06','2025-10-02 12:47:06',1),(417,'ab4ee30b-1b9c-4a28-9b76-c933be04775b','hw_video_model','virtio','2025-10-02 12:46:35','2025-10-02 12:47:06','2025-10-02 12:47:06',1),(418,'ab4ee30b-1b9c-4a28-9b76-c933be04775b','hw_vif_model','virtio','2025-10-02 12:46:35','2025-10-02 12:47:06','2025-10-02 12:47:06',1),(419,'ab4ee30b-1b9c-4a28-9b76-c933be04775b','instance_uuid','2c1bf1aa-8fcd-4688-b50c-1b331a3bc8d4','2025-10-02 12:46:35','2025-10-02 12:47:06','2025-10-02 12:47:06',1),(420,'ab4ee30b-1b9c-4a28-9b76-c933be04775b','user_id','b5104e5372994cd19b720862cf1ca2ce','2025-10-02 12:46:35','2025-10-02 12:47:06','2025-10-02 12:47:06',1),(421,'ab4ee30b-1b9c-4a28-9b76-c933be04775b','image_type','backup','2025-10-02 12:46:35','2025-10-02 12:47:06','2025-10-02 12:47:06',1),(422,'ab4ee30b-1b9c-4a28-9b76-c933be04775b','backup_type','daily','2025-10-02 12:46:35','2025-10-02 12:47:06','2025-10-02 12:47:06',1),(423,'ab4ee30b-1b9c-4a28-9b76-c933be04775b','image_location','snapshot','2025-10-02 12:46:40','2025-10-02 12:47:06','2025-10-02 12:47:06',1),(424,'ab4ee30b-1b9c-4a28-9b76-c933be04775b','owner_id','dbd0afdfb05849f9abfe4cd4454f6a13','2025-10-02 12:46:40','2025-10-02 12:47:06','2025-10-02 12:47:06',1),(425,'ab4ee30b-1b9c-4a28-9b76-c933be04775b','image_state','available','2025-10-02 12:46:40','2025-10-02 12:47:06','2025-10-02 12:47:06',1),(426,'849a855e-6143-42a6-8855-a1bf327357a7','hw_rng_model','virtio','2025-10-02 12:46:45','2025-10-02 12:47:04','2025-10-02 12:47:04',1),(427,'849a855e-6143-42a6-8855-a1bf327357a7','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 12:46:45','2025-10-02 12:47:04','2025-10-02 12:47:04',1),(428,'849a855e-6143-42a6-8855-a1bf327357a7','owner_user_name','tempest-ServerActionsTestOtherB-858400398-project-member','2025-10-02 12:46:45','2025-10-02 12:47:04','2025-10-02 12:47:04',1),(429,'849a855e-6143-42a6-8855-a1bf327357a7','owner_project_name','tempest-ServerActionsTestOtherB-858400398','2025-10-02 12:46:45','2025-10-02 12:47:04','2025-10-02 12:47:04',1),(430,'849a855e-6143-42a6-8855-a1bf327357a7','boot_roles','reader,member','2025-10-02 12:46:45','2025-10-02 12:47:04','2025-10-02 12:47:04',1),(431,'849a855e-6143-42a6-8855-a1bf327357a7','hw_machine_type','q35','2025-10-02 12:46:45','2025-10-02 12:47:04','2025-10-02 12:47:04',1),(432,'849a855e-6143-42a6-8855-a1bf327357a7','hw_cdrom_bus','sata','2025-10-02 12:46:45','2025-10-02 12:47:04','2025-10-02 12:47:04',1),(433,'849a855e-6143-42a6-8855-a1bf327357a7','hw_disk_bus','virtio','2025-10-02 12:46:45','2025-10-02 12:47:04','2025-10-02 12:47:04',1),(434,'849a855e-6143-42a6-8855-a1bf327357a7','hw_input_bus','usb','2025-10-02 12:46:45','2025-10-02 12:47:04','2025-10-02 12:47:04',1),(435,'849a855e-6143-42a6-8855-a1bf327357a7','hw_pointer_model','usbtablet','2025-10-02 12:46:45','2025-10-02 12:47:05','2025-10-02 12:47:05',1),(436,'849a855e-6143-42a6-8855-a1bf327357a7','hw_video_model','virtio','2025-10-02 12:46:45','2025-10-02 12:47:05','2025-10-02 12:47:05',1),(437,'849a855e-6143-42a6-8855-a1bf327357a7','hw_vif_model','virtio','2025-10-02 12:46:45','2025-10-02 12:47:05','2025-10-02 12:47:05',1),(438,'849a855e-6143-42a6-8855-a1bf327357a7','instance_uuid','2c1bf1aa-8fcd-4688-b50c-1b331a3bc8d4','2025-10-02 12:46:45','2025-10-02 12:47:05','2025-10-02 12:47:05',1),(439,'849a855e-6143-42a6-8855-a1bf327357a7','user_id','b5104e5372994cd19b720862cf1ca2ce','2025-10-02 12:46:45','2025-10-02 12:47:05','2025-10-02 12:47:05',1),(440,'849a855e-6143-42a6-8855-a1bf327357a7','image_type','backup','2025-10-02 12:46:45','2025-10-02 12:47:05','2025-10-02 12:47:05',1),(441,'849a855e-6143-42a6-8855-a1bf327357a7','backup_type','daily','2025-10-02 12:46:45','2025-10-02 12:47:05','2025-10-02 12:47:05',1),(442,'849a855e-6143-42a6-8855-a1bf327357a7','image_location','snapshot','2025-10-02 12:46:53','2025-10-02 12:47:05','2025-10-02 12:47:05',1),(443,'849a855e-6143-42a6-8855-a1bf327357a7','owner_id','dbd0afdfb05849f9abfe4cd4454f6a13','2025-10-02 12:46:53','2025-10-02 12:47:05','2025-10-02 12:47:05',1),(444,'849a855e-6143-42a6-8855-a1bf327357a7','image_state','available','2025-10-02 12:46:53','2025-10-02 12:47:05','2025-10-02 12:47:05',1),(445,'06496a06-9459-4a12-80f1-2f72dd513f0f','hw_rng_model','virtio','2025-10-02 12:52:03','2025-10-02 12:53:45','2025-10-02 12:53:45',1),(446,'06496a06-9459-4a12-80f1-2f72dd513f0f','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 12:52:03','2025-10-02 12:53:45','2025-10-02 12:53:45',1),(447,'06496a06-9459-4a12-80f1-2f72dd513f0f','owner_user_name','tempest-ServerActionsTestOtherB-858400398-project-member','2025-10-02 12:52:03','2025-10-02 12:53:45','2025-10-02 12:53:45',1),(448,'06496a06-9459-4a12-80f1-2f72dd513f0f','owner_project_name','tempest-ServerActionsTestOtherB-858400398','2025-10-02 12:52:03','2025-10-02 12:53:45','2025-10-02 12:53:45',1),(449,'06496a06-9459-4a12-80f1-2f72dd513f0f','boot_roles','reader,member','2025-10-02 12:52:03','2025-10-02 12:53:45','2025-10-02 12:53:45',1),(450,'06496a06-9459-4a12-80f1-2f72dd513f0f','hw_machine_type','q35','2025-10-02 12:52:03','2025-10-02 12:53:45','2025-10-02 12:53:45',1),(451,'06496a06-9459-4a12-80f1-2f72dd513f0f','hw_cdrom_bus','sata','2025-10-02 12:52:03','2025-10-02 12:53:45','2025-10-02 12:53:45',1),(452,'06496a06-9459-4a12-80f1-2f72dd513f0f','hw_disk_bus','virtio','2025-10-02 12:52:03','2025-10-02 12:53:45','2025-10-02 12:53:45',1),(453,'06496a06-9459-4a12-80f1-2f72dd513f0f','hw_input_bus','usb','2025-10-02 12:52:03','2025-10-02 12:53:45','2025-10-02 12:53:45',1),(454,'06496a06-9459-4a12-80f1-2f72dd513f0f','hw_pointer_model','usbtablet','2025-10-02 12:52:03','2025-10-02 12:53:45','2025-10-02 12:53:45',1),(455,'06496a06-9459-4a12-80f1-2f72dd513f0f','hw_video_model','virtio','2025-10-02 12:52:03','2025-10-02 12:53:45','2025-10-02 12:53:45',1),(456,'06496a06-9459-4a12-80f1-2f72dd513f0f','hw_vif_model','virtio','2025-10-02 12:52:03','2025-10-02 12:53:45','2025-10-02 12:53:45',1),(457,'06496a06-9459-4a12-80f1-2f72dd513f0f','instance_uuid','b461d8a1-bc66-4c64-87ec-dac07e9585c4','2025-10-02 12:52:03','2025-10-02 12:53:45','2025-10-02 12:53:45',1),(458,'06496a06-9459-4a12-80f1-2f72dd513f0f','user_id','b5104e5372994cd19b720862cf1ca2ce','2025-10-02 12:52:03','2025-10-02 12:53:45','2025-10-02 12:53:45',1),(459,'06496a06-9459-4a12-80f1-2f72dd513f0f','image_type','snapshot','2025-10-02 12:52:04','2025-10-02 12:53:45','2025-10-02 12:53:45',1),(460,'06496a06-9459-4a12-80f1-2f72dd513f0f','owner_id','dbd0afdfb05849f9abfe4cd4454f6a13','2025-10-02 12:52:15','2025-10-02 12:53:45','2025-10-02 12:53:45',1),(461,'06496a06-9459-4a12-80f1-2f72dd513f0f','image_state','available','2025-10-02 12:52:15','2025-10-02 12:53:45','2025-10-02 12:53:45',1),(462,'06496a06-9459-4a12-80f1-2f72dd513f0f','image_location','snapshot','2025-10-02 12:52:15','2025-10-02 12:53:45','2025-10-02 12:53:45',1),(463,'bb6e8276-124f-4324-93a4-7816950a2ea0','hw_rng_model','virtio','2025-10-02 12:52:39','2025-10-02 12:52:41','2025-10-02 12:52:41',1),(464,'bb6e8276-124f-4324-93a4-7816950a2ea0','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 12:52:39','2025-10-02 12:52:41','2025-10-02 12:52:41',1),(465,'bb6e8276-124f-4324-93a4-7816950a2ea0','owner_user_name','tempest-ServersAaction247Test-547354818-project-member','2025-10-02 12:52:39','2025-10-02 12:52:41','2025-10-02 12:52:41',1),(466,'bb6e8276-124f-4324-93a4-7816950a2ea0','owner_project_name','tempest-ServersAaction247Test-547354818','2025-10-02 12:52:39','2025-10-02 12:52:41','2025-10-02 12:52:41',1),(467,'bb6e8276-124f-4324-93a4-7816950a2ea0','boot_roles','member,reader','2025-10-02 12:52:39','2025-10-02 12:52:41','2025-10-02 12:52:41',1),(468,'bb6e8276-124f-4324-93a4-7816950a2ea0','hw_machine_type','q35','2025-10-02 12:52:39','2025-10-02 12:52:41','2025-10-02 12:52:41',1),(469,'bb6e8276-124f-4324-93a4-7816950a2ea0','hw_cdrom_bus','sata','2025-10-02 12:52:39','2025-10-02 12:52:41','2025-10-02 12:52:41',1),(470,'bb6e8276-124f-4324-93a4-7816950a2ea0','hw_disk_bus','virtio','2025-10-02 12:52:39','2025-10-02 12:52:41','2025-10-02 12:52:41',1),(471,'bb6e8276-124f-4324-93a4-7816950a2ea0','hw_input_bus','usb','2025-10-02 12:52:39','2025-10-02 12:52:41','2025-10-02 12:52:41',1),(472,'bb6e8276-124f-4324-93a4-7816950a2ea0','hw_pointer_model','usbtablet','2025-10-02 12:52:39','2025-10-02 12:52:41','2025-10-02 12:52:41',1),(473,'bb6e8276-124f-4324-93a4-7816950a2ea0','hw_video_model','virtio','2025-10-02 12:52:39','2025-10-02 12:52:41','2025-10-02 12:52:41',1),(474,'bb6e8276-124f-4324-93a4-7816950a2ea0','hw_vif_model','virtio','2025-10-02 12:52:39','2025-10-02 12:52:41','2025-10-02 12:52:41',1),(475,'bb6e8276-124f-4324-93a4-7816950a2ea0','instance_uuid','9668bd28-30e7-4dd0-87a8-6577135cc19b','2025-10-02 12:52:39','2025-10-02 12:52:41','2025-10-02 12:52:41',1),(476,'bb6e8276-124f-4324-93a4-7816950a2ea0','user_id','c6b3ffaf413a4cc592b58bfbf3b40c2b','2025-10-02 12:52:39','2025-10-02 12:52:41','2025-10-02 12:52:41',1),(477,'bb6e8276-124f-4324-93a4-7816950a2ea0','image_type','backup','2025-10-02 12:52:39','2025-10-02 12:52:41','2025-10-02 12:52:41',1),(478,'bb6e8276-124f-4324-93a4-7816950a2ea0','backup_type','daily','2025-10-02 12:52:39','2025-10-02 12:52:41','2025-10-02 12:52:41',1),(479,'47596e8e-a667-4ff8-bd1f-3f35c36243ae','hw_rng_model','virtio','2025-10-02 12:52:45','2025-10-02 12:53:40','2025-10-02 12:53:40',1),(480,'47596e8e-a667-4ff8-bd1f-3f35c36243ae','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 12:52:45','2025-10-02 12:53:40','2025-10-02 12:53:40',1),(481,'47596e8e-a667-4ff8-bd1f-3f35c36243ae','owner_user_name','tempest-ServerActionsTestOtherB-858400398-project-member','2025-10-02 12:52:45','2025-10-02 12:53:40','2025-10-02 12:53:40',1),(482,'47596e8e-a667-4ff8-bd1f-3f35c36243ae','owner_project_name','tempest-ServerActionsTestOtherB-858400398','2025-10-02 12:52:45','2025-10-02 12:53:40','2025-10-02 12:53:40',1),(483,'47596e8e-a667-4ff8-bd1f-3f35c36243ae','boot_roles','member,reader','2025-10-02 12:52:45','2025-10-02 12:53:40','2025-10-02 12:53:40',1),(484,'47596e8e-a667-4ff8-bd1f-3f35c36243ae','hw_machine_type','q35','2025-10-02 12:52:45','2025-10-02 12:53:40','2025-10-02 12:53:40',1),(485,'47596e8e-a667-4ff8-bd1f-3f35c36243ae','hw_cdrom_bus','sata','2025-10-02 12:52:45','2025-10-02 12:53:40','2025-10-02 12:53:40',1),(486,'47596e8e-a667-4ff8-bd1f-3f35c36243ae','hw_disk_bus','virtio','2025-10-02 12:52:45','2025-10-02 12:53:40','2025-10-02 12:53:40',1),(487,'47596e8e-a667-4ff8-bd1f-3f35c36243ae','hw_input_bus','usb','2025-10-02 12:52:45','2025-10-02 12:53:40','2025-10-02 12:53:40',1),(488,'47596e8e-a667-4ff8-bd1f-3f35c36243ae','hw_pointer_model','usbtablet','2025-10-02 12:52:45','2025-10-02 12:53:40','2025-10-02 12:53:40',1),(489,'47596e8e-a667-4ff8-bd1f-3f35c36243ae','hw_video_model','virtio','2025-10-02 12:52:45','2025-10-02 12:53:40','2025-10-02 12:53:40',1),(490,'47596e8e-a667-4ff8-bd1f-3f35c36243ae','hw_vif_model','virtio','2025-10-02 12:52:45','2025-10-02 12:53:40','2025-10-02 12:53:40',1),(491,'47596e8e-a667-4ff8-bd1f-3f35c36243ae','instance_uuid','a1440a2f-0663-451f-bef5-bbece30acc40','2025-10-02 12:52:45','2025-10-02 12:53:40','2025-10-02 12:53:40',1),(492,'47596e8e-a667-4ff8-bd1f-3f35c36243ae','user_id','b5104e5372994cd19b720862cf1ca2ce','2025-10-02 12:52:45','2025-10-02 12:53:40','2025-10-02 12:53:40',1),(493,'47596e8e-a667-4ff8-bd1f-3f35c36243ae','image_type','snapshot','2025-10-02 12:52:45','2025-10-02 12:53:40','2025-10-02 12:53:40',1),(494,'47596e8e-a667-4ff8-bd1f-3f35c36243ae','image_location','snapshot','2025-10-02 12:53:02','2025-10-02 12:53:40','2025-10-02 12:53:40',1),(495,'47596e8e-a667-4ff8-bd1f-3f35c36243ae','owner_id','dbd0afdfb05849f9abfe4cd4454f6a13','2025-10-02 12:53:02','2025-10-02 12:53:40','2025-10-02 12:53:40',1),(496,'47596e8e-a667-4ff8-bd1f-3f35c36243ae','image_state','available','2025-10-02 12:53:02','2025-10-02 12:53:40','2025-10-02 12:53:40',1),(497,'38d5e3ab-8ce6-4053-8f4a-2a76356bf535','hw_rng_model','virtio','2025-10-02 12:53:48','2025-10-02 12:57:47','2025-10-02 12:57:47',1),(498,'38d5e3ab-8ce6-4053-8f4a-2a76356bf535','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 12:53:48','2025-10-02 12:57:47','2025-10-02 12:57:47',1),(499,'38d5e3ab-8ce6-4053-8f4a-2a76356bf535','owner_user_name','tempest-ServerBootFromVolumeStableRescueTest-1641553658-project-member','2025-10-02 12:53:48','2025-10-02 12:57:47','2025-10-02 12:57:47',1),(500,'38d5e3ab-8ce6-4053-8f4a-2a76356bf535','owner_project_name','tempest-ServerBootFromVolumeStableRescueTest-1641553658','2025-10-02 12:53:48','2025-10-02 12:57:47','2025-10-02 12:57:47',1),(501,'38d5e3ab-8ce6-4053-8f4a-2a76356bf535','boot_roles','reader,member','2025-10-02 12:53:48','2025-10-02 12:57:47','2025-10-02 12:57:47',1),(502,'38d5e3ab-8ce6-4053-8f4a-2a76356bf535','hw_machine_type','q35','2025-10-02 12:53:48','2025-10-02 12:57:47','2025-10-02 12:57:47',1),(503,'38d5e3ab-8ce6-4053-8f4a-2a76356bf535','hw_cdrom_bus','sata','2025-10-02 12:53:48','2025-10-02 12:57:47','2025-10-02 12:57:47',1),(504,'38d5e3ab-8ce6-4053-8f4a-2a76356bf535','hw_disk_bus','virtio','2025-10-02 12:53:48','2025-10-02 12:57:47','2025-10-02 12:57:47',1),(505,'38d5e3ab-8ce6-4053-8f4a-2a76356bf535','hw_input_bus','usb','2025-10-02 12:53:48','2025-10-02 12:57:47','2025-10-02 12:57:47',1),(506,'38d5e3ab-8ce6-4053-8f4a-2a76356bf535','hw_pointer_model','usbtablet','2025-10-02 12:53:48','2025-10-02 12:57:47','2025-10-02 12:57:47',1),(507,'38d5e3ab-8ce6-4053-8f4a-2a76356bf535','hw_video_model','virtio','2025-10-02 12:53:48','2025-10-02 12:57:47','2025-10-02 12:57:47',1),(508,'38d5e3ab-8ce6-4053-8f4a-2a76356bf535','hw_vif_model','virtio','2025-10-02 12:53:48','2025-10-02 12:57:47','2025-10-02 12:57:47',1),(509,'38d5e3ab-8ce6-4053-8f4a-2a76356bf535','instance_uuid','e22a7944-9200-4204-a219-3f7bd720667b','2025-10-02 12:53:48','2025-10-02 12:57:47','2025-10-02 12:57:47',1),(510,'38d5e3ab-8ce6-4053-8f4a-2a76356bf535','user_id','00be63ea13c84e3d9419078865524099','2025-10-02 12:53:48','2025-10-02 12:57:47','2025-10-02 12:57:47',1),(511,'38d5e3ab-8ce6-4053-8f4a-2a76356bf535','image_type','snapshot','2025-10-02 12:53:48','2025-10-02 12:57:47','2025-10-02 12:57:47',1),(512,'38d5e3ab-8ce6-4053-8f4a-2a76356bf535','owner_id','cb2da64acac041cb8d38c3b43fe4dbe9','2025-10-02 12:53:56','2025-10-02 12:57:47','2025-10-02 12:57:47',1),(513,'38d5e3ab-8ce6-4053-8f4a-2a76356bf535','image_state','available','2025-10-02 12:53:56','2025-10-02 12:57:47','2025-10-02 12:57:47',1),(514,'38d5e3ab-8ce6-4053-8f4a-2a76356bf535','image_location','snapshot','2025-10-02 12:53:56','2025-10-02 12:57:47','2025-10-02 12:57:47',1),(515,'38d5e3ab-8ce6-4053-8f4a-2a76356bf535','hw_rescue_bus','virtio','2025-10-02 12:54:12','2025-10-02 12:57:47','2025-10-02 12:57:47',1),(516,'38d5e3ab-8ce6-4053-8f4a-2a76356bf535','hw_rescue_device','disk','2025-10-02 12:54:12','2025-10-02 12:57:47','2025-10-02 12:57:47',1),(517,'dbd87d84-17a6-4523-8be2-18de440d9003','hw_rng_model','virtio','2025-10-02 12:56:00','2025-10-02 12:57:35','2025-10-02 12:57:35',1),(518,'dbd87d84-17a6-4523-8be2-18de440d9003','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 12:56:00','2025-10-02 12:57:35','2025-10-02 12:57:35',1),(519,'dbd87d84-17a6-4523-8be2-18de440d9003','owner_user_name','tempest-ServerBootFromVolumeStableRescueTest-1641553658-project-member','2025-10-02 12:56:00','2025-10-02 12:57:35','2025-10-02 12:57:35',1),(520,'dbd87d84-17a6-4523-8be2-18de440d9003','owner_project_name','tempest-ServerBootFromVolumeStableRescueTest-1641553658','2025-10-02 12:56:00','2025-10-02 12:57:35','2025-10-02 12:57:35',1),(521,'dbd87d84-17a6-4523-8be2-18de440d9003','boot_roles','reader,member','2025-10-02 12:56:00','2025-10-02 12:57:35','2025-10-02 12:57:35',1),(522,'dbd87d84-17a6-4523-8be2-18de440d9003','hw_machine_type','q35','2025-10-02 12:56:00','2025-10-02 12:57:35','2025-10-02 12:57:35',1),(523,'dbd87d84-17a6-4523-8be2-18de440d9003','hw_cdrom_bus','sata','2025-10-02 12:56:00','2025-10-02 12:57:35','2025-10-02 12:57:35',1),(524,'dbd87d84-17a6-4523-8be2-18de440d9003','hw_disk_bus','virtio','2025-10-02 12:56:00','2025-10-02 12:57:35','2025-10-02 12:57:35',1),(525,'dbd87d84-17a6-4523-8be2-18de440d9003','hw_input_bus','usb','2025-10-02 12:56:00','2025-10-02 12:57:35','2025-10-02 12:57:35',1),(526,'dbd87d84-17a6-4523-8be2-18de440d9003','hw_pointer_model','usbtablet','2025-10-02 12:56:00','2025-10-02 12:57:35','2025-10-02 12:57:35',1),(527,'dbd87d84-17a6-4523-8be2-18de440d9003','hw_video_model','virtio','2025-10-02 12:56:00','2025-10-02 12:57:35','2025-10-02 12:57:35',1),(528,'dbd87d84-17a6-4523-8be2-18de440d9003','hw_vif_model','virtio','2025-10-02 12:56:00','2025-10-02 12:57:35','2025-10-02 12:57:35',1),(529,'dbd87d84-17a6-4523-8be2-18de440d9003','instance_uuid','74e69165-006c-41de-82af-bc44cba0a843','2025-10-02 12:56:00','2025-10-02 12:57:35','2025-10-02 12:57:35',1),(530,'dbd87d84-17a6-4523-8be2-18de440d9003','user_id','00be63ea13c84e3d9419078865524099','2025-10-02 12:56:00','2025-10-02 12:57:35','2025-10-02 12:57:35',1),(531,'dbd87d84-17a6-4523-8be2-18de440d9003','image_type','snapshot','2025-10-02 12:56:00','2025-10-02 12:57:35','2025-10-02 12:57:35',1),(532,'dbd87d84-17a6-4523-8be2-18de440d9003','owner_id','cb2da64acac041cb8d38c3b43fe4dbe9','2025-10-02 12:56:23','2025-10-02 12:57:35','2025-10-02 12:57:35',1),(533,'dbd87d84-17a6-4523-8be2-18de440d9003','image_state','available','2025-10-02 12:56:23','2025-10-02 12:57:35','2025-10-02 12:57:35',1),(534,'dbd87d84-17a6-4523-8be2-18de440d9003','image_location','snapshot','2025-10-02 12:56:23','2025-10-02 12:57:35','2025-10-02 12:57:35',1),(535,'dbd87d84-17a6-4523-8be2-18de440d9003','hw_rescue_bus','virtio','2025-10-02 12:56:51','2025-10-02 12:57:35','2025-10-02 12:57:35',1),(536,'dbd87d84-17a6-4523-8be2-18de440d9003','hw_rescue_device','disk','2025-10-02 12:56:52','2025-10-02 12:57:35','2025-10-02 12:57:35',1),(537,'3560df73-c585-4179-87ca-fb0ca65743ee','hw_rng_model','virtio','2025-10-02 13:05:25','2025-10-02 13:06:15','2025-10-02 13:06:15',1),(538,'3560df73-c585-4179-87ca-fb0ca65743ee','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 13:05:25','2025-10-02 13:06:15','2025-10-02 13:06:15',1),(539,'3560df73-c585-4179-87ca-fb0ca65743ee','owner_user_name','tempest-ServersNegativeTestJSON-1205930452-project-member','2025-10-02 13:05:25','2025-10-02 13:06:15','2025-10-02 13:06:15',1),(540,'3560df73-c585-4179-87ca-fb0ca65743ee','owner_project_name','tempest-ServersNegativeTestJSON-1205930452','2025-10-02 13:05:25','2025-10-02 13:06:15','2025-10-02 13:06:15',1),(541,'3560df73-c585-4179-87ca-fb0ca65743ee','boot_roles','member,reader','2025-10-02 13:05:25','2025-10-02 13:06:15','2025-10-02 13:06:15',1),(542,'3560df73-c585-4179-87ca-fb0ca65743ee','hw_machine_type','q35','2025-10-02 13:05:25','2025-10-02 13:06:15','2025-10-02 13:06:15',1),(543,'3560df73-c585-4179-87ca-fb0ca65743ee','hw_cdrom_bus','sata','2025-10-02 13:05:25','2025-10-02 13:06:15','2025-10-02 13:06:15',1),(544,'3560df73-c585-4179-87ca-fb0ca65743ee','hw_disk_bus','virtio','2025-10-02 13:05:25','2025-10-02 13:06:15','2025-10-02 13:06:15',1),(545,'3560df73-c585-4179-87ca-fb0ca65743ee','hw_input_bus','usb','2025-10-02 13:05:25','2025-10-02 13:06:15','2025-10-02 13:06:15',1),(546,'3560df73-c585-4179-87ca-fb0ca65743ee','hw_pointer_model','usbtablet','2025-10-02 13:05:25','2025-10-02 13:06:15','2025-10-02 13:06:15',1),(547,'3560df73-c585-4179-87ca-fb0ca65743ee','hw_video_model','virtio','2025-10-02 13:05:25','2025-10-02 13:06:15','2025-10-02 13:06:15',1),(548,'3560df73-c585-4179-87ca-fb0ca65743ee','hw_vif_model','virtio','2025-10-02 13:05:25','2025-10-02 13:06:15','2025-10-02 13:06:15',1),(549,'3560df73-c585-4179-87ca-fb0ca65743ee','instance_uuid','ea034622-0a48-4de6-8d68-0f2240b54214','2025-10-02 13:05:25','2025-10-02 13:06:15','2025-10-02 13:06:15',1),(550,'3560df73-c585-4179-87ca-fb0ca65743ee','user_id','5206d24fd75a48758994a57e7fd259f2','2025-10-02 13:05:25','2025-10-02 13:06:15','2025-10-02 13:06:15',1),(551,'3560df73-c585-4179-87ca-fb0ca65743ee','image_type','snapshot','2025-10-02 13:05:25','2025-10-02 13:06:15','2025-10-02 13:06:15',1),(552,'3560df73-c585-4179-87ca-fb0ca65743ee','image_state','available','2025-10-02 13:05:34','2025-10-02 13:06:15','2025-10-02 13:06:15',1),(553,'3560df73-c585-4179-87ca-fb0ca65743ee','image_location','snapshot','2025-10-02 13:05:34','2025-10-02 13:06:15','2025-10-02 13:06:15',1),(554,'3560df73-c585-4179-87ca-fb0ca65743ee','owner_id','52dd3c4419794d0fbecd536c5088c60f','2025-10-02 13:05:34','2025-10-02 13:06:15','2025-10-02 13:06:15',1),(555,'c7b69b23-2de1-4a42-80f6-94ba898e82eb','hw_rng_model','virtio','2025-10-02 13:08:37','2025-10-02 13:09:15','2025-10-02 13:09:15',1),(556,'c7b69b23-2de1-4a42-80f6-94ba898e82eb','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 13:08:37','2025-10-02 13:09:15','2025-10-02 13:09:15',1),(557,'c7b69b23-2de1-4a42-80f6-94ba898e82eb','owner_user_name','tempest-TestShelveInstance-228669170-project-member','2025-10-02 13:08:37','2025-10-02 13:09:15','2025-10-02 13:09:15',1),(558,'c7b69b23-2de1-4a42-80f6-94ba898e82eb','owner_project_name','tempest-TestShelveInstance-228669170','2025-10-02 13:08:37','2025-10-02 13:09:15','2025-10-02 13:09:15',1),(559,'c7b69b23-2de1-4a42-80f6-94ba898e82eb','boot_roles','member,reader','2025-10-02 13:08:37','2025-10-02 13:09:15','2025-10-02 13:09:15',1),(560,'c7b69b23-2de1-4a42-80f6-94ba898e82eb','hw_machine_type','q35','2025-10-02 13:08:37','2025-10-02 13:09:15','2025-10-02 13:09:15',1),(561,'c7b69b23-2de1-4a42-80f6-94ba898e82eb','hw_cdrom_bus','sata','2025-10-02 13:08:37','2025-10-02 13:09:15','2025-10-02 13:09:15',1),(562,'c7b69b23-2de1-4a42-80f6-94ba898e82eb','hw_disk_bus','virtio','2025-10-02 13:08:37','2025-10-02 13:09:15','2025-10-02 13:09:15',1),(563,'c7b69b23-2de1-4a42-80f6-94ba898e82eb','hw_input_bus','usb','2025-10-02 13:08:37','2025-10-02 13:09:15','2025-10-02 13:09:15',1),(564,'c7b69b23-2de1-4a42-80f6-94ba898e82eb','hw_pointer_model','usbtablet','2025-10-02 13:08:37','2025-10-02 13:09:15','2025-10-02 13:09:15',1),(565,'c7b69b23-2de1-4a42-80f6-94ba898e82eb','hw_video_model','virtio','2025-10-02 13:08:37','2025-10-02 13:09:15','2025-10-02 13:09:15',1),(566,'c7b69b23-2de1-4a42-80f6-94ba898e82eb','hw_vif_model','virtio','2025-10-02 13:08:37','2025-10-02 13:09:15','2025-10-02 13:09:15',1),(567,'c7b69b23-2de1-4a42-80f6-94ba898e82eb','instance_uuid','b4640b6e-b1e0-4168-9970-c5d05a0e1621','2025-10-02 13:08:37','2025-10-02 13:09:15','2025-10-02 13:09:15',1),(568,'c7b69b23-2de1-4a42-80f6-94ba898e82eb','user_id','62f4c4b5cc194bd59ca9cc9f1da78a79','2025-10-02 13:08:37','2025-10-02 13:09:15','2025-10-02 13:09:15',1),(569,'c7b69b23-2de1-4a42-80f6-94ba898e82eb','image_type','snapshot','2025-10-02 13:08:37','2025-10-02 13:09:15','2025-10-02 13:09:15',1),(570,'c7b69b23-2de1-4a42-80f6-94ba898e82eb','image_state','available','2025-10-02 13:08:51','2025-10-02 13:09:15','2025-10-02 13:09:15',1),(571,'c7b69b23-2de1-4a42-80f6-94ba898e82eb','image_location','snapshot','2025-10-02 13:08:51','2025-10-02 13:09:15','2025-10-02 13:09:15',1),(572,'c7b69b23-2de1-4a42-80f6-94ba898e82eb','owner_id','954946ff6b204fba90f767ec67210620','2025-10-02 13:08:51','2025-10-02 13:09:15','2025-10-02 13:09:15',1),(573,'ce85db7b-3a9c-4836-a59c-ea52c9943289','signature_verified','False','2025-10-02 13:12:11','2025-10-02 13:12:24','2025-10-02 13:12:24',1),(574,'ce85db7b-3a9c-4836-a59c-ea52c9943289','hw_rng_model','virtio','2025-10-02 13:12:11','2025-10-02 13:12:24','2025-10-02 13:12:24',1),(575,'ce85db7b-3a9c-4836-a59c-ea52c9943289','base_image_ref','','2025-10-02 13:12:11','2025-10-02 13:12:24','2025-10-02 13:12:24',1),(576,'ce85db7b-3a9c-4836-a59c-ea52c9943289','owner_user_name','tempest-AttachVolumeMultiAttachTest-2011266702-project-member','2025-10-02 13:12:11','2025-10-02 13:12:24','2025-10-02 13:12:24',1),(577,'ce85db7b-3a9c-4836-a59c-ea52c9943289','owner_project_name','tempest-AttachVolumeMultiAttachTest-2011266702','2025-10-02 13:12:11','2025-10-02 13:12:24','2025-10-02 13:12:24',1),(578,'ce85db7b-3a9c-4836-a59c-ea52c9943289','boot_roles','reader,member','2025-10-02 13:12:11','2025-10-02 13:12:24','2025-10-02 13:12:24',1),(579,'ce85db7b-3a9c-4836-a59c-ea52c9943289','hw_machine_type','q35','2025-10-02 13:12:11','2025-10-02 13:12:24','2025-10-02 13:12:24',1),(580,'ce85db7b-3a9c-4836-a59c-ea52c9943289','hw_cdrom_bus','sata','2025-10-02 13:12:11','2025-10-02 13:12:24','2025-10-02 13:12:24',1),(581,'ce85db7b-3a9c-4836-a59c-ea52c9943289','hw_disk_bus','virtio','2025-10-02 13:12:11','2025-10-02 13:12:24','2025-10-02 13:12:24',1),(582,'ce85db7b-3a9c-4836-a59c-ea52c9943289','hw_input_bus','usb','2025-10-02 13:12:11','2025-10-02 13:12:24','2025-10-02 13:12:24',1),(583,'ce85db7b-3a9c-4836-a59c-ea52c9943289','hw_pointer_model','usbtablet','2025-10-02 13:12:11','2025-10-02 13:12:24','2025-10-02 13:12:24',1),(584,'ce85db7b-3a9c-4836-a59c-ea52c9943289','hw_video_model','virtio','2025-10-02 13:12:11','2025-10-02 13:12:24','2025-10-02 13:12:24',1),(585,'ce85db7b-3a9c-4836-a59c-ea52c9943289','hw_vif_model','virtio','2025-10-02 13:12:11','2025-10-02 13:12:24','2025-10-02 13:12:24',1),(586,'ce85db7b-3a9c-4836-a59c-ea52c9943289','root_device_name','/dev/vda','2025-10-02 13:12:11','2025-10-02 13:12:24','2025-10-02 13:12:24',1),(587,'ce85db7b-3a9c-4836-a59c-ea52c9943289','block_device_mapping','[{\"no_device\": null, \"encryption_options\": null, \"encryption_format\": null, \"device_type\": \"disk\", \"volume_type\": null, \"device_name\": \"/dev/vda\", \"destination_type\": \"volume\", \"volume_size\": 1, \"image_id\": null, \"disk_bus\": \"virtio\", \"boot_index\": 0, \"tag\": null, \"encryption_secret_uuid\": null, \"guest_format\": null, \"snapshot_id\": \"dff6adf7-64dd-40b8-b0c2-8bd3f4e563c0\", \"source_type\": \"snapshot\", \"encrypted\": null, \"volume_id\": null, \"delete_on_termination\": false}]','2025-10-02 13:12:11','2025-10-02 13:12:24','2025-10-02 13:12:24',1),(588,'ce85db7b-3a9c-4836-a59c-ea52c9943289','bdm_v2','True','2025-10-02 13:12:11','2025-10-02 13:12:24','2025-10-02 13:12:24',1),(589,'23101426-fbb2-4946-b9ce-fdcd0b2d5391','hw_rng_model','virtio','2025-10-02 13:13:35','2025-10-02 13:14:56','2025-10-02 13:14:56',1),(590,'23101426-fbb2-4946-b9ce-fdcd0b2d5391','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 13:13:35','2025-10-02 13:14:56','2025-10-02 13:14:56',1),(591,'23101426-fbb2-4946-b9ce-fdcd0b2d5391','owner_user_name','tempest-TestStampPattern-1060565162-project-member','2025-10-02 13:13:35','2025-10-02 13:14:56','2025-10-02 13:14:56',1),(592,'23101426-fbb2-4946-b9ce-fdcd0b2d5391','owner_project_name','tempest-TestStampPattern-1060565162','2025-10-02 13:13:35','2025-10-02 13:14:56','2025-10-02 13:14:56',1),(593,'23101426-fbb2-4946-b9ce-fdcd0b2d5391','boot_roles','member,reader','2025-10-02 13:13:35','2025-10-02 13:14:56','2025-10-02 13:14:56',1),(594,'23101426-fbb2-4946-b9ce-fdcd0b2d5391','hw_machine_type','q35','2025-10-02 13:13:35','2025-10-02 13:14:56','2025-10-02 13:14:56',1),(595,'23101426-fbb2-4946-b9ce-fdcd0b2d5391','hw_cdrom_bus','sata','2025-10-02 13:13:35','2025-10-02 13:14:56','2025-10-02 13:14:56',1),(596,'23101426-fbb2-4946-b9ce-fdcd0b2d5391','hw_disk_bus','virtio','2025-10-02 13:13:35','2025-10-02 13:14:56','2025-10-02 13:14:56',1),(597,'23101426-fbb2-4946-b9ce-fdcd0b2d5391','hw_input_bus','usb','2025-10-02 13:13:35','2025-10-02 13:14:56','2025-10-02 13:14:56',1),(598,'23101426-fbb2-4946-b9ce-fdcd0b2d5391','hw_pointer_model','usbtablet','2025-10-02 13:13:35','2025-10-02 13:14:56','2025-10-02 13:14:56',1),(599,'23101426-fbb2-4946-b9ce-fdcd0b2d5391','hw_video_model','virtio','2025-10-02 13:13:35','2025-10-02 13:14:56','2025-10-02 13:14:56',1),(600,'23101426-fbb2-4946-b9ce-fdcd0b2d5391','hw_vif_model','virtio','2025-10-02 13:13:35','2025-10-02 13:14:56','2025-10-02 13:14:56',1),(601,'23101426-fbb2-4946-b9ce-fdcd0b2d5391','instance_uuid','97dd449c-87a7-4278-a819-3d412f587a4c','2025-10-02 13:13:35','2025-10-02 13:14:56','2025-10-02 13:14:56',1),(602,'23101426-fbb2-4946-b9ce-fdcd0b2d5391','user_id','81db307ac1f846188ce19b644ebcc396','2025-10-02 13:13:35','2025-10-02 13:14:56','2025-10-02 13:14:56',1),(603,'23101426-fbb2-4946-b9ce-fdcd0b2d5391','image_type','snapshot','2025-10-02 13:13:35','2025-10-02 13:14:56','2025-10-02 13:14:56',1),(604,'23101426-fbb2-4946-b9ce-fdcd0b2d5391','owner_id','cbaefa5c700c4ed495a5244732eed7e3','2025-10-02 13:13:42','2025-10-02 13:14:56','2025-10-02 13:14:56',1),(605,'23101426-fbb2-4946-b9ce-fdcd0b2d5391','image_state','available','2025-10-02 13:13:42','2025-10-02 13:14:56','2025-10-02 13:14:56',1),(606,'23101426-fbb2-4946-b9ce-fdcd0b2d5391','image_location','snapshot','2025-10-02 13:13:42','2025-10-02 13:14:56','2025-10-02 13:14:56',1),(607,'4dbf986e-53ef-4e53-875d-c9d73e683338','hw_rng_model','virtio','2025-10-02 13:24:13','2025-10-02 13:25:27','2025-10-02 13:25:27',1),(608,'4dbf986e-53ef-4e53-875d-c9d73e683338','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 13:24:13','2025-10-02 13:25:27','2025-10-02 13:25:27',1),(609,'4dbf986e-53ef-4e53-875d-c9d73e683338','owner_user_name','tempest-TestSnapshotPattern-1671292510-project-member','2025-10-02 13:24:13','2025-10-02 13:25:27','2025-10-02 13:25:27',1),(610,'4dbf986e-53ef-4e53-875d-c9d73e683338','owner_project_name','tempest-TestSnapshotPattern-1671292510','2025-10-02 13:24:13','2025-10-02 13:25:27','2025-10-02 13:25:27',1),(611,'4dbf986e-53ef-4e53-875d-c9d73e683338','boot_roles','reader,member','2025-10-02 13:24:13','2025-10-02 13:25:27','2025-10-02 13:25:27',1),(612,'4dbf986e-53ef-4e53-875d-c9d73e683338','hw_machine_type','q35','2025-10-02 13:24:13','2025-10-02 13:25:27','2025-10-02 13:25:27',1),(613,'4dbf986e-53ef-4e53-875d-c9d73e683338','hw_cdrom_bus','sata','2025-10-02 13:24:13','2025-10-02 13:25:27','2025-10-02 13:25:27',1),(614,'4dbf986e-53ef-4e53-875d-c9d73e683338','hw_disk_bus','virtio','2025-10-02 13:24:13','2025-10-02 13:25:27','2025-10-02 13:25:27',1),(615,'4dbf986e-53ef-4e53-875d-c9d73e683338','hw_input_bus','usb','2025-10-02 13:24:13','2025-10-02 13:25:27','2025-10-02 13:25:27',1),(616,'4dbf986e-53ef-4e53-875d-c9d73e683338','hw_pointer_model','usbtablet','2025-10-02 13:24:13','2025-10-02 13:25:27','2025-10-02 13:25:27',1),(617,'4dbf986e-53ef-4e53-875d-c9d73e683338','hw_video_model','virtio','2025-10-02 13:24:13','2025-10-02 13:25:27','2025-10-02 13:25:27',1),(618,'4dbf986e-53ef-4e53-875d-c9d73e683338','hw_vif_model','virtio','2025-10-02 13:24:13','2025-10-02 13:25:27','2025-10-02 13:25:27',1),(619,'4dbf986e-53ef-4e53-875d-c9d73e683338','instance_uuid','5bc23980-d45b-4acb-9b37-858b821d2252','2025-10-02 13:24:13','2025-10-02 13:25:27','2025-10-02 13:25:27',1),(620,'4dbf986e-53ef-4e53-875d-c9d73e683338','user_id','7eba544d42c8426295f2a88f0e85d446','2025-10-02 13:24:13','2025-10-02 13:25:27','2025-10-02 13:25:27',1),(621,'4dbf986e-53ef-4e53-875d-c9d73e683338','image_type','snapshot','2025-10-02 13:24:13','2025-10-02 13:25:27','2025-10-02 13:25:27',1),(622,'4dbf986e-53ef-4e53-875d-c9d73e683338','owner_id','ecfaf38d20784d06a43ced1560cede11','2025-10-02 13:24:20','2025-10-02 13:25:27','2025-10-02 13:25:27',1),(623,'4dbf986e-53ef-4e53-875d-c9d73e683338','image_state','available','2025-10-02 13:24:20','2025-10-02 13:25:27','2025-10-02 13:25:27',1),(624,'4dbf986e-53ef-4e53-875d-c9d73e683338','image_location','snapshot','2025-10-02 13:24:20','2025-10-02 13:25:27','2025-10-02 13:25:27',1),(625,'4dbf986e-53ef-4e53-875d-c9d73e683338','version','8.0','2025-10-02 13:24:22','2025-10-02 13:25:27','2025-10-02 13:25:27',1),(626,'7337ab36-547f-4549-871f-2f16bbc93bb9','hw_rng_model','virtio','2025-10-02 13:25:11','2025-10-02 13:25:19','2025-10-02 13:25:19',1),(627,'7337ab36-547f-4549-871f-2f16bbc93bb9','base_image_ref','423b8b5f-aab8-418b-8fad-d82c90818bdd','2025-10-02 13:25:11','2025-10-02 13:25:19','2025-10-02 13:25:19',1),(628,'7337ab36-547f-4549-871f-2f16bbc93bb9','owner_user_name','tempest-TestSnapshotPattern-1671292510-project-member','2025-10-02 13:25:11','2025-10-02 13:25:19','2025-10-02 13:25:19',1),(629,'7337ab36-547f-4549-871f-2f16bbc93bb9','owner_project_name','tempest-TestSnapshotPattern-1671292510','2025-10-02 13:25:11','2025-10-02 13:25:19','2025-10-02 13:25:19',1),(630,'7337ab36-547f-4549-871f-2f16bbc93bb9','boot_roles','reader,member','2025-10-02 13:25:11','2025-10-02 13:25:19','2025-10-02 13:25:19',1),(631,'7337ab36-547f-4549-871f-2f16bbc93bb9','hw_machine_type','q35','2025-10-02 13:25:11','2025-10-02 13:25:19','2025-10-02 13:25:19',1),(632,'7337ab36-547f-4549-871f-2f16bbc93bb9','hw_cdrom_bus','sata','2025-10-02 13:25:11','2025-10-02 13:25:19','2025-10-02 13:25:19',1),(633,'7337ab36-547f-4549-871f-2f16bbc93bb9','hw_disk_bus','virtio','2025-10-02 13:25:11','2025-10-02 13:25:19','2025-10-02 13:25:19',1),(634,'7337ab36-547f-4549-871f-2f16bbc93bb9','hw_input_bus','usb','2025-10-02 13:25:11','2025-10-02 13:25:19','2025-10-02 13:25:19',1),(635,'7337ab36-547f-4549-871f-2f16bbc93bb9','hw_pointer_model','usbtablet','2025-10-02 13:25:11','2025-10-02 13:25:19','2025-10-02 13:25:19',1),(636,'7337ab36-547f-4549-871f-2f16bbc93bb9','hw_video_model','virtio','2025-10-02 13:25:11','2025-10-02 13:25:19','2025-10-02 13:25:19',1),(637,'7337ab36-547f-4549-871f-2f16bbc93bb9','hw_vif_model','virtio','2025-10-02 13:25:11','2025-10-02 13:25:19','2025-10-02 13:25:19',1),(638,'7337ab36-547f-4549-871f-2f16bbc93bb9','instance_uuid','265d1e00-c92e-483b-8e0b-153ca45f2fa5','2025-10-02 13:25:11','2025-10-02 13:25:19','2025-10-02 13:25:19',1),(639,'7337ab36-547f-4549-871f-2f16bbc93bb9','user_id','7eba544d42c8426295f2a88f0e85d446','2025-10-02 13:25:11','2025-10-02 13:25:19','2025-10-02 13:25:19',1),(640,'7337ab36-547f-4549-871f-2f16bbc93bb9','image_type','snapshot','2025-10-02 13:25:11','2025-10-02 13:25:19','2025-10-02 13:25:19',1),(641,'7337ab36-547f-4549-871f-2f16bbc93bb9','owner_id','ecfaf38d20784d06a43ced1560cede11','2025-10-02 13:25:11','2025-10-02 13:25:19','2025-10-02 13:25:19',1),(642,'7337ab36-547f-4549-871f-2f16bbc93bb9','image_state','available','2025-10-02 13:25:11','2025-10-02 13:25:19','2025-10-02 13:25:19',1),(643,'7337ab36-547f-4549-871f-2f16bbc93bb9','image_location','snapshot','2025-10-02 13:25:11','2025-10-02 13:25:19','2025-10-02 13:25:19',1),(644,'7337ab36-547f-4549-871f-2f16bbc93bb9','version','8.0','2025-10-02 13:25:11','2025-10-02 13:25:19','2025-10-02 13:25:19',1),(645,'e0399c4c-8352-497f-b361-45e672712e68','signature_verified','False','2025-10-02 13:28:13','2025-10-02 13:29:43','2025-10-02 13:29:43',1),(646,'e0399c4c-8352-497f-b361-45e672712e68','hw_rng_model','virtio','2025-10-02 13:28:13','2025-10-02 13:29:43','2025-10-02 13:29:43',1),(647,'e0399c4c-8352-497f-b361-45e672712e68','base_image_ref','','2025-10-02 13:28:13','2025-10-02 13:29:43','2025-10-02 13:29:43',1),(648,'e0399c4c-8352-497f-b361-45e672712e68','owner_user_name','tempest-TestVolumeBootPattern-1344814684-project-member','2025-10-02 13:28:13','2025-10-02 13:29:43','2025-10-02 13:29:43',1),(649,'e0399c4c-8352-497f-b361-45e672712e68','owner_project_name','tempest-TestVolumeBootPattern-1344814684','2025-10-02 13:28:13','2025-10-02 13:29:43','2025-10-02 13:29:43',1),(650,'e0399c4c-8352-497f-b361-45e672712e68','boot_roles','reader,member','2025-10-02 13:28:13','2025-10-02 13:29:43','2025-10-02 13:29:43',1),(651,'e0399c4c-8352-497f-b361-45e672712e68','hw_machine_type','q35','2025-10-02 13:28:13','2025-10-02 13:29:43','2025-10-02 13:29:43',1),(652,'e0399c4c-8352-497f-b361-45e672712e68','hw_cdrom_bus','sata','2025-10-02 13:28:13','2025-10-02 13:29:43','2025-10-02 13:29:43',1),(653,'e0399c4c-8352-497f-b361-45e672712e68','hw_disk_bus','virtio','2025-10-02 13:28:13','2025-10-02 13:29:43','2025-10-02 13:29:43',1),(654,'e0399c4c-8352-497f-b361-45e672712e68','hw_input_bus','usb','2025-10-02 13:28:13','2025-10-02 13:29:43','2025-10-02 13:29:43',1),(655,'e0399c4c-8352-497f-b361-45e672712e68','hw_pointer_model','usbtablet','2025-10-02 13:28:13','2025-10-02 13:29:43','2025-10-02 13:29:43',1),(656,'e0399c4c-8352-497f-b361-45e672712e68','hw_video_model','virtio','2025-10-02 13:28:13','2025-10-02 13:29:43','2025-10-02 13:29:43',1),(657,'e0399c4c-8352-497f-b361-45e672712e68','hw_vif_model','virtio','2025-10-02 13:28:13','2025-10-02 13:29:43','2025-10-02 13:29:43',1),(658,'e0399c4c-8352-497f-b361-45e672712e68','root_device_name','/dev/vda','2025-10-02 13:28:13','2025-10-02 13:29:43','2025-10-02 13:29:43',1),(659,'e0399c4c-8352-497f-b361-45e672712e68','block_device_mapping','[{\"volume_type\": null, \"device_type\": \"disk\", \"no_device\": null, \"encryption_secret_uuid\": null, \"source_type\": \"snapshot\", \"delete_on_termination\": true, \"guest_format\": null, \"device_name\": \"/dev/vda\", \"encryption_options\": null, \"encrypted\": null, \"volume_id\": null, \"snapshot_id\": \"b50be4d5-612a-4434-8eb6-55d27bed7a4d\", \"encryption_format\": null, \"image_id\": null, \"destination_type\": \"volume\", \"disk_bus\": \"virtio\", \"tag\": null, \"boot_index\": 0, \"volume_size\": 1}]','2025-10-02 13:28:13','2025-10-02 13:29:43','2025-10-02 13:29:43',1),(660,'e0399c4c-8352-497f-b361-45e672712e68','bdm_v2','True','2025-10-02 13:28:13','2025-10-02 13:29:43','2025-10-02 13:29:43',1);
/*!40000 ALTER TABLE `image_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_tags`
--

DROP TABLE IF EXISTS `image_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_tags_image_id` (`image_id`),
  KEY `ix_image_tags_image_id_tag_value` (`image_id`,`value`),
  CONSTRAINT `image_tags_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_tags`
--

LOCK TABLES `image_tags` WRITE;
/*!40000 ALTER TABLE `image_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `disk_format` varchar(20) DEFAULT NULL,
  `container_format` varchar(20) DEFAULT NULL,
  `checksum` varchar(32) DEFAULT NULL,
  `owner` varchar(255) DEFAULT NULL,
  `min_disk` int(11) NOT NULL,
  `min_ram` int(11) NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT 0,
  `virtual_size` bigint(20) DEFAULT NULL,
  `visibility` enum('private','public','shared','community') NOT NULL DEFAULT 'shared',
  `os_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `os_hash_algo` varchar(64) DEFAULT NULL,
  `os_hash_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checksum_image_idx` (`checksum`),
  KEY `ix_images_deleted` (`deleted`),
  KEY `owner_image_idx` (`owner`),
  KEY `created_at_image_idx` (`created_at`),
  KEY `updated_at_image_idx` (`updated_at`),
  KEY `visibility_image_idx` (`visibility`),
  KEY `os_hidden_image_idx` (`os_hidden`),
  KEY `os_hash_value_image_idx` (`os_hash_value`),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`protected` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` (`id`, `name`, `size`, `status`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `disk_format`, `container_format`, `checksum`, `owner`, `min_disk`, `min_ram`, `protected`, `virtual_size`, `visibility`, `os_hidden`, `os_hash_algo`, `os_hash_value`) VALUES ('06496a06-9459-4a12-80f1-2f72dd513f0f','tempest-ServerActionsTestOtherB-server-417900419-shelved',1073741824,'deleted','2025-10-02 12:52:03','2025-10-02 12:53:45','2025-10-02 12:53:45',1,'raw','bare',NULL,'dbd0afdfb05849f9abfe4cd4454f6a13',1,0,0,NULL,'private',0,NULL,NULL),('15e18cef-aa4b-424b-82b1-3a0edfa62ef7','tempest-test-snap-1799220182',1073741824,'deleted','2025-10-02 12:20:12','2025-10-02 12:20:21','2025-10-02 12:20:21',1,'raw','bare',NULL,'d0ebb2827cb241e499606ce3a3c67d24',1,0,0,NULL,'private',0,NULL,NULL),('23101426-fbb2-4946-b9ce-fdcd0b2d5391','tempest-TestStampPatternsnapshot-825838792',1073741824,'deleted','2025-10-02 13:13:35','2025-10-02 13:14:56','2025-10-02 13:14:56',1,'raw','bare',NULL,'cbaefa5c700c4ed495a5244732eed7e3',1,0,0,NULL,'private',0,NULL,NULL),('28a7bd8e-0ddc-4cda-9f64-7c1162716074','tempest-₡-1921565420',1073741824,'deleted','2025-10-02 12:15:36','2025-10-02 12:16:11','2025-10-02 12:16:11',1,'raw','bare',NULL,'d92e60d304e64805972937813fc99606',1,0,0,NULL,'private',0,NULL,NULL),('2d2735c8-c9f0-487a-8b58-3e359fca2f77','tempest-ServerStableDeviceRescueTest-image-1464828867',1073741824,'deleted','2025-10-02 12:41:07','2025-10-02 12:42:24','2025-10-02 12:42:24',1,'raw','bare',NULL,'a79bb765ab1e4aa18672c9641b6187b9',1,0,0,NULL,'private',0,NULL,NULL),('2de43632-5d51-4644-b4ab-edaca67d1e25','tempest-scenario-img--796530541',21430272,'deleted','2025-10-02 12:47:00','2025-10-02 12:51:25','2025-10-02 12:51:25',1,'qcow2','bare','c8fc807773e5354afe61636071771906','d3e0300f3cf5493d8a9e62e2c4a95767',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('2e803658-b995-4556-a393-a91c1a77b934','tempest-ListImageFiltersTestJSON-image-1823157988',1024,'deleted','2025-10-02 12:28:32','2025-10-02 12:30:10','2025-10-02 12:30:10',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','494736d8288b414094eb0bc6fbaa8cb7',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('3560df73-c585-4179-87ca-fb0ca65743ee','tempest-ServersNegativeTestJSON-server-881712342-shelved',1073741824,'deleted','2025-10-02 13:05:25','2025-10-02 13:06:15','2025-10-02 13:06:15',1,'raw','bare',NULL,'52dd3c4419794d0fbecd536c5088c60f',1,0,0,NULL,'private',0,NULL,NULL),('3866598c-0b46-42ff-ba05-28dab62cd167','tempest-AttachVolumeShelveTestJSON-server-1355261775-shelved',1073741824,'deleted','2025-10-02 12:44:41','2025-10-02 12:45:29','2025-10-02 12:45:29',1,'raw','bare',NULL,'f7e2edef094b4ba5a56a5ec5ffce911e',1,0,0,NULL,'private',0,NULL,NULL),('38906c7c-521b-42f0-a991-950eaae1ee1c','tempest-test-snap-1018651021',1073741824,'deleted','2025-10-02 12:22:50','2025-10-02 12:23:40','2025-10-02 12:23:40',1,'raw','bare',NULL,'d0ebb2827cb241e499606ce3a3c67d24',1,0,0,NULL,'private',0,NULL,NULL),('38d5e3ab-8ce6-4053-8f4a-2a76356bf535','tempest-ServerBootFromVolumeStableRescueTest-image-1829438830',1073741824,'deleted','2025-10-02 12:53:48','2025-10-02 12:57:47','2025-10-02 12:57:47',1,'raw','bare',NULL,'cb2da64acac041cb8d38c3b43fe4dbe9',1,0,0,NULL,'private',0,NULL,NULL),('4038405e-7d51-444f-9567-0cdacfa79f42','tempest-ListImageFiltersTestJSON-image-1884157655',1073741824,'deleted','2025-10-02 12:29:13','2025-10-02 12:29:50','2025-10-02 12:29:50',1,'raw','bare',NULL,'494736d8288b414094eb0bc6fbaa8cb7',1,0,0,NULL,'private',0,NULL,NULL),('40dbc07f-c919-4d14-85e2-405ded1c3c40','tempest-scenario-img--1483751743',21430272,'deleted','2025-10-02 13:17:59','2025-10-02 13:19:32','2025-10-02 13:19:32',1,'qcow2','bare','c8fc807773e5354afe61636071771906','ced4d30c525c44cca617c3b9838d21b7',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('423b8b5f-aab8-418b-8fad-d82c90818bdd','cirros-0.6.2-x86_64-disk.img',21430272,'active','2025-10-02 12:08:46','2025-10-02 12:08:54',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','c3a6b94d2b4945a487dafe07f533efd6',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('437d8b4c-c859-4756-900b-9c9295a3b60b','tempest-ListImageFiltersTestJSON-image-2060249120',1024,'deleted','2025-10-02 12:28:37','2025-10-02 12:30:03','2025-10-02 12:30:03',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','494736d8288b414094eb0bc6fbaa8cb7',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('44da8c0b-0cdf-4949-9ff7-57e81c0d3d70','tempest-ServerStableDeviceRescueTest-image-1539405821',1073741824,'deleted','2025-10-02 12:38:08','2025-10-02 12:42:48','2025-10-02 12:42:48',1,'raw','bare',NULL,'a79bb765ab1e4aa18672c9641b6187b9',1,0,0,NULL,'private',0,NULL,NULL),('45a729a3-bfb9-4ba4-a275-e4201ada93ed','tempest-UnshelveToHostMultiNodesTest-server-1498353913-shelved',1073741824,'deleted','2025-10-02 12:21:10','2025-10-02 12:22:06','2025-10-02 12:22:06',1,'raw','bare',NULL,'aaf2805394aa4c4cb7977f6433aabf56',1,0,0,NULL,'private',0,NULL,NULL),('47596e8e-a667-4ff8-bd1f-3f35c36243ae','tempest-ServerActionsTestOtherB-server-1789493944-shelved',1073741824,'deleted','2025-10-02 12:52:45','2025-10-02 12:53:40','2025-10-02 12:53:40',1,'raw','bare',NULL,'dbd0afdfb05849f9abfe4cd4454f6a13',1,0,0,NULL,'private',0,NULL,NULL),('4dbf986e-53ef-4e53-875d-c9d73e683338','tempest-TestSnapshotPatternsnapshot-180760656',1073741824,'deleted','2025-10-02 13:24:13','2025-10-02 13:25:27','2025-10-02 13:25:27',1,'raw','bare',NULL,'ecfaf38d20784d06a43ced1560cede11',1,0,0,NULL,'private',0,NULL,NULL),('52ef509e-0e22-464e-93c9-3ddcf574cd64','cirros-0.6.2-x86_64-disk.img_alt',21430272,'active','2025-10-02 12:08:54','2025-10-02 12:08:57',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','c3a6b94d2b4945a487dafe07f533efd6',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('5e6784e9-638e-4f69-b9c1-8a81a55dc0ed','tempest-test-snap-438752106',1073741824,'deleted','2025-10-02 12:22:04','2025-10-02 12:22:22','2025-10-02 12:22:22',1,'raw','bare',NULL,'d0ebb2827cb241e499606ce3a3c67d24',1,0,0,NULL,'private',0,NULL,NULL),('732edfd9-86ec-4c72-a1b2-37aec374791c','tempest-backup-1-1535281746',1073741824,'deleted','2025-10-02 12:46:27','2025-10-02 12:46:59','2025-10-02 12:46:59',1,'raw','bare',NULL,'dbd0afdfb05849f9abfe4cd4454f6a13',1,0,0,NULL,'private',0,NULL,NULL),('7337ab36-547f-4549-871f-2f16bbc93bb9','tempest-TestSnapshotPatternsnapshot-877007220',1073741824,'deleted','2025-10-02 13:25:11','2025-10-02 13:25:19','2025-10-02 13:25:19',1,'raw','bare',NULL,'ecfaf38d20784d06a43ced1560cede11',1,0,0,NULL,'private',0,NULL,NULL),('79274edd-028c-4cfd-9fc0-5c8ea54a5ee4','tempest-ImagesOneServerNegativeTestJSON-image-892498520',NULL,'deleted','2025-10-02 12:28:26','2025-10-02 12:28:27','2025-10-02 12:28:27',1,NULL,NULL,NULL,'bfd7bec5bd4b4366a96cc55cfe95fcc9',1,0,0,NULL,'private',0,NULL,NULL),('7fb9d0dd-1da7-4b33-8373-4bee7b325cfd','tempest-image-964683074',4081,'deleted','2025-10-02 12:11:05','2025-10-02 12:11:13','2025-10-02 12:11:13',1,'qcow2','bare','05fc33194e24eb2e6501998f039ee167','00baca98289d4bfab464218dcd6e0259',0,129,0,NULL,'private',0,'sha512','601b021a32b4d0b2565c4de0f5e0ec22d804e921ab29586bcf65a92731a68058283568df9cf6293d4f10015350167481dc16bc7137da43ee949f5162b664b0e6'),('845ab049-b1a7-4b63-95d7-72464046ac90','tempest-ServerStableDeviceRescueTest-image-1722810468',1073741824,'deleted','2025-10-02 12:39:17','2025-10-02 12:42:37','2025-10-02 12:42:37',1,'raw','bare',NULL,'a79bb765ab1e4aa18672c9641b6187b9',1,0,0,NULL,'private',0,NULL,NULL),('849a855e-6143-42a6-8855-a1bf327357a7','tempest-backup-3-1472335057',1073741824,'deleted','2025-10-02 12:46:45','2025-10-02 12:47:05','2025-10-02 12:47:05',1,'raw','bare',NULL,'dbd0afdfb05849f9abfe4cd4454f6a13',1,0,0,NULL,'private',0,NULL,NULL),('8ef5cf5e-703e-423e-815f-02321271fc3c','tempest-DeleteServersTestJSON-server-1867337880-shelved',1073741824,'deleted','2025-10-02 12:44:03','2025-10-02 12:45:07','2025-10-02 12:45:07',1,'raw','bare',NULL,'58b2fa4ee0cd4b97be1b303c203be14f',1,0,0,NULL,'private',0,NULL,NULL),('9f2e97bd-159f-41e5-875d-f066be38a116','tempest-image-291935829',1073741824,'deleted','2025-10-02 12:15:26','2025-10-02 12:15:36','2025-10-02 12:15:36',1,'raw','bare',NULL,'d92e60d304e64805972937813fc99606',1,0,0,NULL,'private',0,NULL,NULL),('a1e5194e-ee54-41db-883e-1f37efee5068','tempest-ImagesOneServerNegativeTestJSON-image-1972292898',NULL,'deleted','2025-10-02 12:27:48','2025-10-02 12:27:50','2025-10-02 12:27:50',1,NULL,NULL,NULL,'bfd7bec5bd4b4366a96cc55cfe95fcc9',1,0,0,NULL,'private',0,NULL,NULL),('a74e1055-5470-4941-8188-b17381cbad4e','tempest-ListImageFiltersTestJSON-image-408511042',1024,'deleted','2025-10-02 12:28:25','2025-10-02 12:30:20','2025-10-02 12:30:20',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','494736d8288b414094eb0bc6fbaa8cb7',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('ab4ee30b-1b9c-4a28-9b76-c933be04775b','tempest-backup-2-967133478',1073741824,'deleted','2025-10-02 12:46:35','2025-10-02 12:47:06','2025-10-02 12:47:06',1,'raw','bare',NULL,'dbd0afdfb05849f9abfe4cd4454f6a13',1,0,0,NULL,'private',0,NULL,NULL),('bb6e8276-124f-4324-93a4-7816950a2ea0','tempest-backup-1-984228372',NULL,'deleted','2025-10-02 12:52:39','2025-10-02 12:52:41','2025-10-02 12:52:41',1,'qcow2','bare',NULL,'324f52a964c64bfc9c214faab2ddda5b',1,0,0,NULL,'private',0,NULL,NULL),('bc229961-c2ce-4076-a41e-7413c2291d5e','tempest-test-snap-361503669',1073741824,'deleted','2025-10-02 12:21:08','2025-10-02 12:21:33','2025-10-02 12:21:33',1,'raw','bare',NULL,'d0ebb2827cb241e499606ce3a3c67d24',1,0,0,NULL,'private',0,NULL,NULL),('c37f4151-ac68-47f8-adfa-bd0c85e4c75d','tempest-AttachVolumeShelveTestJSON-server-1408399936-shelved',1073741824,'deleted','2025-10-02 12:42:34','2025-10-02 12:43:13','2025-10-02 12:43:13',1,'raw','bare',NULL,'f7e2edef094b4ba5a56a5ec5ffce911e',1,0,0,NULL,'private',0,NULL,NULL),('c7b69b23-2de1-4a42-80f6-94ba898e82eb','tempest-TestShelveInstance-server-1341299623-shelved',1073741824,'deleted','2025-10-02 13:08:37','2025-10-02 13:09:15','2025-10-02 13:09:15',1,'raw','bare',NULL,'954946ff6b204fba90f767ec67210620',1,0,0,NULL,'private',0,NULL,NULL),('ce85db7b-3a9c-4836-a59c-ea52c9943289','multiattach-snapshot',0,'deleted','2025-10-02 13:12:11','2025-10-02 13:12:24','2025-10-02 13:12:24',1,'qcow2','bare','d41d8cd98f00b204e9800998ecf8427e','9f85b8f387b146d29eabe946c4fbdee8',1,0,0,NULL,'private',0,'sha512','cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e'),('cf745836-410d-40ce-8229-51a950b72ba1','tempest-test-snap-1382278589',NULL,'deleted','2025-10-02 12:24:01','2025-10-02 12:24:03','2025-10-02 12:24:03',1,NULL,NULL,NULL,'d0ebb2827cb241e499606ce3a3c67d24',1,0,0,NULL,'private',0,NULL,NULL),('d0dced0b-1a65-4528-9713-633878d7128b','tempest-ListImageFiltersTestJSON-image-897963533',1073741824,'deleted','2025-10-02 12:29:25','2025-10-02 12:29:46','2025-10-02 12:29:46',1,'raw','bare',NULL,'494736d8288b414094eb0bc6fbaa8cb7',1,0,0,NULL,'private',0,NULL,NULL),('d47d5adb-8963-4735-aac4-73e6ace2936e','tempest-ServerStableDeviceRescueTest-image-492773035',1073741824,'deleted','2025-10-02 12:37:24','2025-10-02 12:42:58','2025-10-02 12:42:58',1,'raw','bare',NULL,'a79bb765ab1e4aa18672c9641b6187b9',1,0,0,NULL,'private',0,NULL,NULL),('dbd87d84-17a6-4523-8be2-18de440d9003','tempest-ServerBootFromVolumeStableRescueTest-image-1639884387',1073741824,'deleted','2025-10-02 12:56:00','2025-10-02 12:57:35','2025-10-02 12:57:35',1,'raw','bare',NULL,'cb2da64acac041cb8d38c3b43fe4dbe9',1,0,0,NULL,'private',0,NULL,NULL),('e0399c4c-8352-497f-b361-45e672712e68','tempest-TestVolumeBootPatternsnapshot-566470057',0,'deleted','2025-10-02 13:28:13','2025-10-02 13:29:43','2025-10-02 13:29:43',1,'qcow2','bare','d41d8cd98f00b204e9800998ecf8427e','18799a1c93354809911705bb424e673f',1,0,0,NULL,'private',0,'sha512','cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e'),('e47e8f63-f84e-437a-b1c3-8f7966140254','tempest-image-787032952',1024,'deleted','2025-10-02 12:13:15','2025-10-02 12:13:46','2025-10-02 12:13:46',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','88fc23a5eeb6404ab728563a204e8ba6',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('e63c0054-4f57-471e-a2d8-a929502f4104','tempest-ListImageFiltersTestJSON-image-1928965386',1073741824,'deleted','2025-10-02 12:28:56','2025-10-02 12:29:52','2025-10-02 12:29:52',1,'raw','bare',NULL,'494736d8288b414094eb0bc6fbaa8cb7',1,0,0,NULL,'private',0,NULL,NULL),('e7094a19-0695-4486-b083-e54642bc0338',NULL,21430272,'deleted','2025-10-02 12:23:21','2025-10-02 12:24:52','2025-10-02 12:24:52',1,'qcow2','bare','c8fc807773e5354afe61636071771906','74d6a07b22004c29bacecf2a4aa70dab',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('f573b04f-b850-41b8-8b32-8ba00d6690cd','tempest-UnshelveToHostMultiNodesTest-server-1498353913-shelved',1073741824,'deleted','2025-10-02 12:20:20','2025-10-02 12:21:06','2025-10-02 12:21:06',1,'raw','bare',NULL,'aaf2805394aa4c4cb7977f6433aabf56',1,0,0,NULL,'private',0,NULL,NULL),('f6be8018-0ea2-42f8-a1d7-8d704069aac9','tempest-scenario-img--1529097385',21430272,'deleted','2025-10-02 13:19:33','2025-10-02 13:21:21','2025-10-02 13:21:21',1,'qcow2','bare','c8fc807773e5354afe61636071771906','ced4d30c525c44cca617c3b9838d21b7',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b');
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespace_resource_types`
--

DROP TABLE IF EXISTS `metadef_namespace_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespace_resource_types` (
  `resource_type_id` int(11) NOT NULL,
  `namespace_id` int(11) NOT NULL,
  `properties_target` varchar(80) DEFAULT NULL,
  `prefix` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`resource_type_id`,`namespace_id`),
  KEY `ix_metadef_ns_res_types_namespace_id` (`namespace_id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_2` FOREIGN KEY (`resource_type_id`) REFERENCES `metadef_resource_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespace_resource_types`
--

LOCK TABLES `metadef_namespace_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_namespace_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_namespace_resource_types` (`resource_type_id`, `namespace_id`, `properties_target`, `prefix`, `created_at`, `updated_at`) VALUES (1,1,'image','CIM_PASD_','2025-10-02 11:27:47',NULL),(1,2,'image','CIM_RASD_','2025-10-02 11:27:47',NULL),(1,3,NULL,'CIM_SASD_','2025-10-02 11:27:47',NULL),(1,9,'image','hw_','2025-10-02 11:27:48',NULL),(1,10,'image','hw_','2025-10-02 11:27:48',NULL),(1,14,'image',NULL,'2025-10-02 11:27:48',NULL),(1,19,'image','hw_','2025-10-02 11:27:48',NULL),(1,25,'image','hw_','2025-10-02 11:27:49',NULL),(1,29,'image',NULL,'2025-10-02 11:27:49',NULL),(1,30,'image',NULL,'2025-10-02 11:27:49',NULL),(1,31,'image',NULL,'2025-10-02 11:27:49',NULL),(1,32,'image',NULL,'2025-10-02 11:27:49',NULL),(2,1,NULL,'CIM_PASD_','2025-10-02 11:27:47',NULL),(2,8,NULL,'hw_','2025-10-02 11:27:48',NULL),(2,9,NULL,'hw_','2025-10-02 11:27:48',NULL),(2,10,NULL,'hw_','2025-10-02 11:27:48',NULL),(2,11,NULL,NULL,'2025-10-02 11:27:48',NULL),(2,13,NULL,NULL,'2025-10-02 11:27:48',NULL),(2,14,NULL,NULL,'2025-10-02 11:27:48',NULL),(2,15,NULL,NULL,'2025-10-02 11:27:48',NULL),(2,16,NULL,'hw_','2025-10-02 11:27:48',NULL),(2,19,NULL,'hw_','2025-10-02 11:27:48',NULL),(2,22,NULL,NULL,'2025-10-02 11:27:48',NULL),(2,23,NULL,'hw_','2025-10-02 11:27:49',NULL),(2,24,NULL,'traits:','2025-10-02 11:27:49',NULL),(2,25,NULL,'hw_','2025-10-02 11:27:49',NULL),(2,26,NULL,NULL,'2025-10-02 11:27:49',NULL),(2,28,NULL,NULL,'2025-10-02 11:27:49',NULL),(2,29,NULL,NULL,'2025-10-02 11:27:49',NULL),(2,30,NULL,NULL,'2025-10-02 11:27:49',NULL),(2,31,NULL,NULL,'2025-10-02 11:27:49',NULL),(2,32,NULL,NULL,'2025-10-02 11:27:49',NULL),(2,33,NULL,'cinder_','2025-10-02 11:27:49',NULL),(3,1,NULL,'CIM_PASD_','2025-10-02 11:27:47',NULL),(3,2,NULL,'CIM_RASD_','2025-10-02 11:27:47',NULL),(3,3,NULL,'CIM_SASD_','2025-10-02 11:27:47',NULL),(3,4,NULL,'CIM_VSSD_','2025-10-02 11:27:48',NULL),(3,5,NULL,NULL,'2025-10-02 11:27:48',NULL),(3,6,NULL,NULL,'2025-10-02 11:27:48',NULL),(3,7,NULL,NULL,'2025-10-02 11:27:48',NULL),(3,12,NULL,'aggregate_instance_extra_specs:','2025-10-02 11:27:48',NULL),(4,1,NULL,'CIM_PASD_','2025-10-02 11:27:47',NULL),(4,2,NULL,'CIM_RASD_','2025-10-02 11:27:47',NULL),(4,3,NULL,'CIM_SASD_','2025-10-02 11:27:47',NULL),(4,4,NULL,'CIM_VSSD_','2025-10-02 11:27:48',NULL),(4,8,NULL,'hw:','2025-10-02 11:27:48',NULL),(4,9,NULL,'hw:','2025-10-02 11:27:48',NULL),(4,10,NULL,'hw:','2025-10-02 11:27:48',NULL),(4,12,NULL,'capabilities:','2025-10-02 11:27:48',NULL),(4,16,NULL,'hw:','2025-10-02 11:27:48',NULL),(4,17,NULL,NULL,'2025-10-02 11:27:48',NULL),(4,18,NULL,NULL,'2025-10-02 11:27:48',NULL),(4,19,NULL,'hw:','2025-10-02 11:27:48',NULL),(4,20,NULL,NULL,'2025-10-02 11:27:48',NULL),(4,21,NULL,NULL,'2025-10-02 11:27:48',NULL),(4,23,NULL,'hw:','2025-10-02 11:27:49',NULL),(4,24,NULL,'traits:','2025-10-02 11:27:49',NULL),(4,25,NULL,'hw:','2025-10-02 11:27:49',NULL),(5,1,'scheduler_hints',NULL,'2025-10-02 11:27:47',NULL),(5,30,'metadata',NULL,'2025-10-02 11:27:49',NULL),(5,31,'metadata',NULL,'2025-10-02 11:27:49',NULL),(5,32,'metadata',NULL,'2025-10-02 11:27:49',NULL),(6,30,NULL,NULL,'2025-10-02 11:27:49',NULL);
/*!40000 ALTER TABLE `metadef_namespace_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespaces`
--

DROP TABLE IF EXISTS `metadef_namespaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespaces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace` varchar(80) NOT NULL,
  `display_name` varchar(80) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `visibility` varchar(32) DEFAULT NULL,
  `protected` tinyint(1) DEFAULT NULL,
  `owner` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_namespaces_namespace` (`namespace`),
  KEY `ix_metadef_namespaces_owner` (`owner`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespaces`
--

LOCK TABLES `metadef_namespaces` WRITE;
/*!40000 ALTER TABLE `metadef_namespaces` DISABLE KEYS */;
INSERT INTO `metadef_namespaces` (`id`, `namespace`, `display_name`, `description`, `visibility`, `protected`, `owner`, `created_at`, `updated_at`) VALUES (1,'CIM::ProcessorAllocationSettingData','CIM Processor Allocation Setting','Properties related to the resource allocation settings of a processor (CPU) from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These are properties that identify processor setting data and may be specified to volume, image, host aggregate, flavor and Nova server as scheduler hint. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ProcessorAllocationSettingData.html.','public',1,'admin','2025-10-02 11:27:47',NULL),(2,'CIM::ResourceAllocationSettingData','CIM Resource Allocation Setting Data','Properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim) that represent settings specifically related to an allocated resource that are outside the scope of the CIM class typically used to represent the resource itself. These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ResourceAllocationSettingData.html.','public',1,'admin','2025-10-02 11:27:47',NULL),(3,'CIM::StorageAllocationSettingData','CIM Storage Allocation Setting Data','Properties related to the allocation of virtual storage from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_StorageAllocationSettingData.html.','public',1,'admin','2025-10-02 11:27:47',NULL),(4,'CIM::VirtualSystemSettingData','CIM Virtual System Setting Data','A set of virtualization specific properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim), which define the virtual aspects of a virtual system. These properties may be specified to host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_VirtualSystemSettingData.html.','public',1,'admin','2025-10-02 11:27:48',NULL),(5,'OS::Compute::AggregateDiskFilter','Disk Allocation per Host','Properties related to the Nova scheduler filter AggregateDiskFilter. Filters aggregate hosts based on the available disk space compared to the requested disk space. Hosts in the aggregate with not enough usable disk will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-10-02 11:27:48',NULL),(6,'OS::Compute::AggregateIoOpsFilter','IO Ops per Host','Properties related to the Nova scheduler filter AggregateIoOpsFilter. Filters aggregate hosts based on the number of instances currently changing state. Hosts in the aggregate with too many instances changing state will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-10-02 11:27:48',NULL),(7,'OS::Compute::AggregateNumInstancesFilter','Instances per Host','Properties related to the Nova scheduler filter AggregateNumInstancesFilter. Filters aggregate hosts by the number of running instances on it. Hosts in the aggregate with too many instances will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',0,'admin','2025-10-02 11:27:48',NULL),(8,'OS::Compute::CPUMode','CPU Mode','This provides the preferred CPU Model to be used when booting up a guest VM.','public',NULL,'admin','2025-10-02 11:27:48',NULL),(9,'OS::Compute::CPUPinning','CPU Pinning','This provides the preferred CPU pinning and CPU thread pinning policy to be used when pinning vCPU of the guest to pCPU of the host. See http://docs.openstack.org/admin-guide/compute-numa-cpu-pinning.html','public',1,'admin','2025-10-02 11:27:48',NULL),(10,'OS::Compute::GuestMemoryBacking','Guest Memory Backing','This provides the preferred backing option for guest RAM. Guest\'s memory can be backed by hugepages to limit TLB lookups. See also: https://wiki.openstack.org/wiki/VirtDriverGuestCPUMemoryPlacement','public',1,'admin','2025-10-02 11:27:48',NULL),(11,'OS::Compute::GuestShutdownBehavior','Shutdown Behavior','These properties allow modifying the shutdown behavior for stop, rescue, resize, and shelve operations.','public',1,'admin','2025-10-02 11:27:48',NULL),(12,'OS::Compute::HostCapabilities','Compute Host Capabilities','Hardware capabilities provided by the compute host. This provides the ability to fine tune the hardware specification required when an instance is requested. The ComputeCapabilitiesFilter should be enabled in the Nova scheduler to use these properties. When enabled, this filter checks that the capabilities provided by the compute host satisfy any extra specifications requested. Only hosts that can provide the requested capabilities will be eligible for hosting the instance.','public',1,'admin','2025-10-02 11:27:48',NULL),(13,'OS::Compute::Hypervisor','Hypervisor Selection','OpenStack Compute supports many hypervisors, although most installations use only one hypervisor. For installations with multiple supported hypervisors, you can schedule different hypervisors using the ImagePropertiesFilter. This filters compute nodes that satisfy any architecture, hypervisor type, or virtual machine mode properties specified on the instance\'s image properties.','public',1,'admin','2025-10-02 11:27:48',NULL),(14,'OS::Compute::InstanceData','Instance Config Data','Instances can perform self-configuration based on data made available to the running instance. These properties affect instance configuration.','public',1,'admin','2025-10-02 11:27:48',NULL),(15,'OS::Compute::LibvirtImage','libvirt Driver Options for Images','The libvirt Compute Driver Options for Glance Images.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-10-02 11:27:48',NULL),(16,'OS::Compute::Libvirt','libvirt Driver Options','The libvirt compute driver options.  \n\nThese are properties that affect the libvirt compute driver and may be specified on flavors and images.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-10-02 11:27:48',NULL),(17,'OS::Compute::Quota','Flavor Quota','Compute drivers may enable quotas on CPUs available to a VM, disk tuning, bandwidth I/O, and instance VIF traffic control.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-10-02 11:27:48',NULL),(18,'OS::Compute::RandomNumberGenerator','Random Number Generator','If a random-number generator device has been added to the instance through its image properties, the device can be enabled and configured.','public',1,'admin','2025-10-02 11:27:48',NULL),(19,'OS::Compute::VirtCPUTopology','Virtual CPU Topology','This provides the preferred socket/core/thread counts for the virtual CPU instance exposed to guests. This enables the ability to avoid hitting limitations on vCPU topologies that OS vendors place on their products. See also: https://opendev.org/openstack/nova-specs/src/branch/master/specs/juno/implemented/virt-driver-vcpu-topology.rst','public',1,'admin','2025-10-02 11:27:48',NULL),(20,'OS::Compute::VMwareFlavor','VMware Driver Options for Flavors','VMware Driver Options for Flavors may be used to customize and manage Nova Flavors. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-10-02 11:27:48',NULL),(21,'OS::Compute::VMwareQuotaFlavor','VMware Quota for Flavors','The VMware compute driver allows various compute quotas to be specified on flavors. When specified, the VMWare driver will ensure that the quota is enforced. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. For a list of hypervisors, see: https://wiki.openstack.org/wiki/HypervisorSupportMatrix. For flavor customization, see: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-10-02 11:27:48',NULL),(22,'OS::Compute::VMware','VMware Driver Options','The VMware compute driver options.  \n\nThese are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-10-02 11:27:48',NULL),(23,'OS::Compute::TPM','TPM Options','Configuration options for TPM','public',1,'admin','2025-10-02 11:27:49',NULL),(24,'OS::Compute::VTPM','Emulated Virtual TPM','Configuration options for Emulated Virtual TPM','public',1,'admin','2025-10-02 11:27:49',NULL),(25,'OS::Compute::Watchdog','Watchdog Behavior','Compute drivers may enable watchdog behavior over instances.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-10-02 11:27:49',NULL),(26,'OS::Compute::XenAPI','XenAPI Driver Options','The XenAPI compute driver options.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-10-02 11:27:49',NULL),(27,'OS::Glance::CommonImageProperties','Common Image Properties','When adding an image to Glance, you may specify some common image properties that may prove useful to consumers of your image.',NULL,1,'admin','2025-10-02 11:27:49',NULL),(28,'OS::Glance::Signatures','Image Signature Verification','Image signature verification allows the user to verify that an image has not been modified prior to booting the image.','public',0,'admin','2025-10-02 11:27:49',NULL),(29,'OS::OperatingSystem','Common Operating System Properties','Details of the operating system contained within this image as well as common operating system properties that can be set on a VM instance created from this image.',NULL,1,'admin','2025-10-02 11:27:49',NULL),(30,'OS::Software::DBMS','Database Software','A database is an organized collection of data. The data is typically organized to model aspects of reality in a way that supports processes requiring information. Database management systems are computer software applications that interact with the user, other applications, and the database itself to capture and analyze data. (http://en.wikipedia.org/wiki/Database)','public',1,'admin','2025-10-02 11:27:49',NULL),(31,'OS::Software::Runtimes','Runtime Environment','Software is written in a specific programming language and the language must execute within a runtime environment. The runtime environment provides an abstraction to utilizing a computer\'s processor, memory (RAM), and other system resources.','public',1,'admin','2025-10-02 11:27:49',NULL),(32,'OS::Software::WebServers','Web Servers','A web server is a computer system that processes requests via HTTP, the basic network protocol used to distribute information on the World Wide Web. The most common use of web servers is to host websites, but there are other uses such as gaming, data storage, running enterprise applications, handling email, FTP, or other web uses. (http://en.wikipedia.org/wiki/Web_server)','public',1,'admin','2025-10-02 11:27:49',NULL),(33,'OS::Cinder::Volumetype','Cinder Volume Type','The Cinder volume type configuration option. Volume type assignment provides a mechanism not only to provide scheduling to a specific storage back-end, but also can be used to specify specific information for a back-end storage device to act upon.','public',1,'admin','2025-10-02 11:27:49',NULL);
/*!40000 ALTER TABLE `metadef_namespaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_objects`
--

DROP TABLE IF EXISTS `metadef_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `description` text DEFAULT NULL,
  `required` text DEFAULT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_objects_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_objects_name` (`name`),
  CONSTRAINT `metadef_objects_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_objects`
--

LOCK TABLES `metadef_objects` WRITE;
/*!40000 ALTER TABLE `metadef_objects` DISABLE KEYS */;
INSERT INTO `metadef_objects` (`id`, `namespace_id`, `name`, `description`, `required`, `json_schema`, `created_at`, `updated_at`) VALUES (1,17,'CPU Limits','You can configure the CPU limits with control parameters.',NULL,'{\"quota:cpu_shares\": {\"title\": \"Quota: CPU Shares\", \"description\": \"Specifies the proportional weighted share for the domain. If this element is omitted, the service defaults to the OS provided defaults. There is no unit for the value; it is a relative measure based on the setting of other VMs. For example, a VM configured with value 2048 gets twice as much CPU time as a VM configured with value 1024.\", \"type\": \"integer\"}, \"quota:cpu_period\": {\"title\": \"Quota: CPU Period\", \"description\": \"Specifies the enforcement interval (unit: microseconds) for QEMU and LXC hypervisors. Within a period, each VCPU of the domain is not allowed to consume more than the quota worth of runtime. The value should be in range [1000, 1000000]. A period with value 0 means no value.\", \"type\": \"integer\", \"minimum\": 1000, \"maximum\": 1000000}, \"quota:cpu_quota\": {\"title\": \"Quota: CPU Quota\", \"description\": \"Specifies the maximum allowed bandwidth (unit: microseconds). A domain with a negative-value quota indicates that the domain has infinite bandwidth, which means that it is not bandwidth controlled. The value should be in range [1000, 18446744073709551] or less than 0. A quota with value 0 means no value. You can use this feature to ensure that all vCPUs run at the same speed.\", \"type\": \"integer\"}}','2025-10-02 11:27:48',NULL),(2,17,'Disk QoS','Using disk I/O quotas, you can set maximum disk write to 10 MB per second for a VM user.',NULL,'{\"quota:disk_read_bytes_sec\": {\"title\": \"Quota: Disk read bytes / sec\", \"description\": \"Sets disk I/O quota for disk read bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_read_iops_sec\": {\"title\": \"Quota: Disk read IOPS / sec\", \"description\": \"Sets disk I/O quota for disk read IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_write_bytes_sec\": {\"title\": \"Quota: Disk Write Bytes / sec\", \"description\": \"Sets disk I/O quota for disk write bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_write_iops_sec\": {\"title\": \"Quota: Disk Write IOPS / sec\", \"description\": \"Sets disk I/O quota for disk write IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_total_bytes_sec\": {\"title\": \"Quota: Disk Total Bytes / sec\", \"description\": \"Sets disk I/O quota for total disk bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_total_iops_sec\": {\"title\": \"Quota: Disk Total IOPS / sec\", \"description\": \"Sets disk I/O quota for disk total IOPS / sec.\", \"type\": \"integer\"}}','2025-10-02 11:27:48',NULL),(3,17,'Virtual Interface QoS','Bandwidth QoS tuning for instance virtual interfaces (VIFs) may be specified with these properties. Incoming and outgoing traffic can be shaped independently. If not specified, no quality of service (QoS) is applied on that traffic direction. So, if you want to shape only the network\'s incoming traffic, use inbound only (and vice versa). The OpenStack Networking service abstracts the physical implementation of the network, allowing plugins to configure and manage physical resources. Virtual Interfaces (VIF) in the logical model are analogous to physical network interface cards (NICs). VIFs are typically owned a managed by an external service; for instance when OpenStack Networking is used for building OpenStack networks, VIFs would be created, owned, and managed in Nova. VIFs are connected to OpenStack Networking networks via ports. A port is analogous to a port on a network switch, and it has an administrative state. When a VIF is attached to a port the OpenStack Networking API creates an attachment object, which specifies the fact that a VIF with a given identifier is plugged into the port.',NULL,'{\"quota:vif_inbound_average\": {\"title\": \"Quota: VIF Inbound Average\", \"description\": \"Network Virtual Interface (VIF) inbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_inbound_burst\": {\"title\": \"Quota: VIF Inbound Burst\", \"description\": \"Network Virtual Interface (VIF) inbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_inbound_peak\": {\"title\": \"Quota: VIF Inbound Peak\", \"description\": \"Network Virtual Interface (VIF) inbound peak in kilobytes per second. Specifies maximum rate at which an interface can receive data.\", \"type\": \"integer\"}, \"quota:vif_outbound_average\": {\"title\": \"Quota: VIF Outbound Average\", \"description\": \"Network Virtual Interface (VIF) outbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_outbound_burst\": {\"title\": \"Quota: VIF Outbound Burst\", \"description\": \"Network Virtual Interface (VIF) outbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_outbound_peak\": {\"title\": \"Quota: VIF Outbound Peak\", \"description\": \"Network Virtual Interface (VIF) outbound peak in kilobytes per second. Specifies maximum rate at which an interface can send data.\", \"type\": \"integer\"}}','2025-10-02 11:27:48',NULL),(4,30,'MySQL','MySQL is an object-relational database management system (ORDBMS). The MySQL development project has made its source code available under the terms of the GNU General Public License, as well as under a variety of proprietary agreements. MySQL was owned and sponsored by a single for-profit firm, the Swedish company MySQL AB, now owned by Oracle Corporation. MySQL is a popular choice of database for use in web applications, and is a central component of the widely used LAMP open source web application software stack (and other \'AMP\' stacks). (http://en.wikipedia.org/wiki/MySQL)',NULL,'{\"sw_database_mysql_version\": {\"title\": \"Version\", \"description\": \"The specific version of MySQL.\", \"type\": \"string\"}, \"sw_database_mysql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"The configured TCP/IP port which MySQL listens for incoming connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 3606}, \"sw_database_mysql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"root\"}}','2025-10-02 11:27:49',NULL),(5,30,'PostgreSQL','PostgreSQL, often simply \'Postgres\', is an object-relational database management system (ORDBMS) with an emphasis on extensibility and standards-compliance. PostgreSQL is cross-platform and runs on many operating systems. (http://en.wikipedia.org/wiki/PostgreSQL)',NULL,'{\"sw_database_postgresql_version\": {\"title\": \"Version\", \"description\": \"The specific version of PostgreSQL.\", \"type\": \"string\"}, \"sw_database_postgresql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which PostgreSQL is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_postgresql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"postgres\"}}','2025-10-02 11:27:49',NULL),(6,30,'SQL Server','Microsoft SQL Server is a relational database management system developed by Microsoft. There are at least a dozen different editions of Microsoft SQL Server aimed at different audiences and for workloads ranging from small single-machine applications to large Internet-facing applications with many concurrent users. Its primary query languages are T-SQL and ANSI SQL. (http://en.wikipedia.org/wiki/Microsoft_SQL_Server)',NULL,'{\"sw_database_sqlserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Microsoft SQL Server.\", \"type\": \"string\"}, \"sw_database_sqlserver_edition\": {\"title\": \"Edition\", \"description\": \"SQL Server is available in multiple editions, with different feature sets and targeting different users.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Datacenter\", \"Enterprise\", \"Standard\", \"Web\", \"Business Intelligence\", \"Workgroup\", \"Express\", \"Compact (SQL CE)\", \"Developer\", \"Embedded (SSEE)\", \"Express\", \"Fast Track\", \"LocalDB\", \"Parallel Data Warehouse (PDW)\", \"Business Intelligence\", \"Datawarehouse Appliance Edition\"]}, \"sw_database_sqlserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which SQL Server is to listen for connections from client applications. The default SQL Server port is 1433, and client ports are assigned a random value between 1024 and 5000.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1433}, \"sw_database_postsqlserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"sa\"}}','2025-10-02 11:27:49',NULL),(7,30,'Oracle','Oracle Database (commonly referred to as Oracle RDBMS or simply as Oracle) is an object-relational database management system produced and marketed by Oracle Corporation. (http://en.wikipedia.org/wiki/Oracle_Database)',NULL,'{\"sw_database_oracle_version\": {\"title\": \"Version\", \"description\": \"The specific version of Oracle.\", \"type\": \"string\"}, \"sw_database_oracle_edition\": {\"title\": \"Edition\", \"description\": \"Over and above the different versions of the Oracle database management software developed over time, Oracle Corporation subdivides its product into varying editions.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Enterprise\", \"Standard\", \"Standard Edition One\", \"Express (XE)\", \"Workgroup\", \"Lite\"]}, \"sw_database_oracle_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Oracle is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1521}}','2025-10-02 11:27:49',NULL),(8,30,'DB2','IBM DB2 is a family of database server products developed by IBM. These products all support the relational model, but in recent years some products have been extended to support object-relational features and non-relational structures, in particular XML. (http://en.wikipedia.org/wiki/IBM_DB2)',NULL,'{\"sw_database_db2_version\": {\"title\": \"Version\", \"description\": \"The specific version of DB2.\", \"type\": \"string\"}, \"sw_database_db2_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which DB2 is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_db2_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-10-02 11:27:49',NULL),(9,30,'MongoDB','MongoDB is a cross-platform document-oriented database. Classified as a NoSQL database, MongoDB uses JSON-like documents with dynamic schemas (MongoDB calls the format BSON), making the integration of data in certain types of applications easier and faster. Released under a combination of the GNU Affero General Public License and the Apache License, MongoDB is free and open-source software. (http://en.wikipedia.org/wiki/MongoDB)',NULL,'{\"sw_database_mongodb_version\": {\"title\": \"Version\", \"description\": \"The specific version of MongoDB.\", \"type\": \"string\"}, \"sw_database_mongodb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which MongoDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 27017}, \"sw_database_mongodb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-10-02 11:27:49',NULL),(10,30,'Couchbase Server','Couchbase Server, originally known as Membase, is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications. These applications must serve many concurrent users by creating, storing, retrieving, aggregating, manipulating and presenting data. In support of these kinds of application needs, Couchbase is designed to provide easy-to-scale key-value or document access with low latency and high sustained throughput. (http://en.wikipedia.org/wiki/Couchbase_Server)',NULL,'{\"sw_database_couchbaseserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Couchbase Server.\", \"type\": \"string\"}, \"sw_database_couchbaseserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Couchbase is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 11211}, \"sw_database_couchbaseserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-10-02 11:27:49',NULL),(11,30,'Redis','Redis is a data structure server (NoSQL). It is open-source, networked, in-memory, and stores keys with optional durability. The development of Redis has been sponsored by Pivotal Software since May 2013; before that, it was sponsored by VMware. The name Redis means REmote DIctionary Server. (http://en.wikipedia.org/wiki/Redis)',NULL,'{\"sw_database_redis_version\": {\"title\": \"Version\", \"description\": \"The specific version of Redis.\", \"type\": \"string\"}, \"sw_database_redis_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Redis is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 6379}, \"sw_database_redis_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-10-02 11:27:49',NULL),(12,30,'CouchDB','Apache CouchDB, commonly referred to as CouchDB, is an open source NoSQL database. It is a NoSQL database that uses JSON to store data, JavaScript as its query language using MapReduce, and HTTP for an API. One of its distinguishing features is multi-master replication. CouchDB was first released in 2005 and later became an Apache project in 2008. (http://en.wikipedia.org/wiki/CouchDB)',NULL,'{\"sw_database_couchdb_version\": {\"title\": \"Version\", \"description\": \"The specific version of CouchDB.\", \"type\": \"string\"}, \"sw_database_couchdb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which CouchDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5984}, \"sw_database_couchdb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-10-02 11:27:49',NULL),(13,30,'Apache Cassandra','Apache Cassandra is an open source distributed NoSQL database management system designed to handle large amounts of data across many commodity servers, providing high availability with no single point of failure. (http://en.wikipedia.org/wiki/Apache_Cassandra)',NULL,'{\"sw_database_cassandra_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache Cassandra.\", \"type\": \"string\"}, \"sw_database_cassandra_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Cassandra is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 9160}, \"sw_database_cassandra_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"cassandra\"}}','2025-10-02 11:27:49',NULL),(14,30,'HBase','HBase is an open source, non-relational (NoSQL), distributed database modeled after Google\'s BigTable and written in Java. It is developed as part of Apache Software Foundation\'s Apache Hadoop project and runs on top of HDFS (Hadoop Distributed Filesystem), providing BigTable-like capabilities for Hadoop. (http://en.wikipedia.org/wiki/Apache_HBase)',NULL,'{\"sw_database_hbase_version\": {\"title\": \"Version\", \"description\": \"The specific version of HBase.\", \"type\": \"string\"}}','2025-10-02 11:27:49',NULL),(15,30,'Hazlecast','In computing, Hazelcast is an in-memory open source software data grid based on Java. By having multiple nodes form a cluster, data is evenly distributed among the nodes. This allows for horizontal scaling both in terms of available storage space and processing power. Backups are also distributed in a similar fashion to other nodes, based on configuration, thereby protecting against single node failure. (http://en.wikipedia.org/wiki/Hazelcast)',NULL,'{\"sw_database_hazlecast_version\": {\"title\": \"Version\", \"description\": \"The specific version of Hazlecast.\", \"type\": \"string\"}, \"sw_database_hazlecast_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Hazlecast is to listen for connections between members.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5701}}','2025-10-02 11:27:49',NULL),(16,31,'PHP','PHP is a server-side scripting language designed for web development but also used as a general-purpose programming language. PHP code can be simply mixed with HTML code, or it can be used in combination with various templating engines and web frameworks. PHP code is usually processed by a PHP interpreter, which is usually implemented as a web server\'s native module or a Common Gateway Interface (CGI) executable. After the PHP code is interpreted and executed, the web server sends resulting output to its client, usually in form of a part of the generated web page – for example, PHP code can generate a web page\'s HTML code, an image, or some other data. PHP has also evolved to include a command-line interface (CLI) capability and can be used in standalone graphical applications. (http://en.wikipedia.org/wiki/PHP)',NULL,'{\"sw_runtime_php_version\": {\"title\": \"Version\", \"description\": \"The specific version of PHP.\", \"type\": \"string\"}}','2025-10-02 11:27:49',NULL),(17,31,'Python','Python is a widely used general-purpose, high-level programming language. Its design philosophy emphasizes code readability, and its syntax allows programmers to express concepts in fewer lines of code than would be possible in languages such as C++ or Java. The language provides constructs intended to enable clear programs on both a small and large scale. Python supports multiple programming paradigms, including object-oriented, imperative and functional programming or procedural styles. It features a dynamic type system and automatic memory management and has a large and comprehensive standard library. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_python_version\": {\"title\": \"Version\", \"description\": \"The specific version of python.\", \"type\": \"string\"}}','2025-10-02 11:27:49',NULL),(18,31,'Java','Java is a functional computer programming language that is concurrent, class-based, object-oriented, and specifically designed to have as few implementation dependencies as possible. It is intended to let application developers write once, run anywhere (WORA), meaning that code that runs on one platform does not need to be recompiled to run on another. Java applications are typically compiled to bytecode that can run on any Java virtual machine (JVM) regardless of computer architecture. (http://en.wikipedia.org/wiki/Java_(programming_language))',NULL,'{\"sw_runtime_java_version\": {\"title\": \"Version\", \"description\": \"The specific version of Java.\", \"type\": \"string\"}}','2025-10-02 11:27:49',NULL),(19,31,'Ruby','Ruby is a dynamic, reflective, object-oriented, general-purpose programming language. It was designed and developed in the mid-1990s by Yukihiro Matsumoto in Japan. According to its authors, Ruby was influenced by Perl, Smalltalk, Eiffel, Ada, and Lisp. It supports multiple programming paradigms, including functional, object-oriented, and imperative. It also has a dynamic type system and automatic memory management. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_ruby_version\": {\"title\": \"Version\", \"description\": \"The specific version of Ruby.\", \"type\": \"string\"}}','2025-10-02 11:27:49',NULL),(20,31,'Perl','Perl is a family of high-level, general-purpose, interpreted, dynamic programming languages. The languages in this family include Perl 5 and Perl 6. Though Perl is not officially an acronym, there are various backronyms in use, the most well-known being Practical Extraction and Reporting Language (http://en.wikipedia.org/wiki/Perl)',NULL,'{\"sw_runtime_perl_version\": {\"title\": \"Version\", \"description\": \"The specific version of Perl.\", \"type\": \"string\"}}','2025-10-02 11:27:49',NULL),(21,32,'Apache HTTP Server','The Apache HTTP Server, colloquially called Apache, is a Web server application notable for playing a key role in the initial growth of the World Wide Web. Apache is developed and maintained by an open community of developers under the auspices of the Apache Software Foundation. Most commonly used on a Unix-like system, the software is available for a wide variety of operating systems, including Unix, FreeBSD, Linux, Solaris, Novell NetWare, OS X, Microsoft Windows, OS/2, TPF, OpenVMS and eComStation. Released under the Apache License, Apache is open-source software. (http://en.wikipedia.org/wiki/Apache_HTTP_Server)',NULL,'{\"sw_webserver_apache_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache.\", \"type\": \"string\"}, \"sw_webserver_apache_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_apache_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-10-02 11:27:49',NULL),(22,32,'Nginx','Nginx (pronounced \'engine-x\') is an open source reverse proxy server for HTTP, HTTPS, SMTP, POP3, and IMAP protocols, as well as a load balancer, HTTP cache, and a web server (origin server). The nginx project started with a strong focus on high concurrency, high performance and low memory usage. It is licensed under the 2-clause BSD-like license and it runs on Linux, BSD variants, Mac OS X, Solaris, AIX, HP-UX, as well as on other *nix flavors. It also has a proof of concept port for Microsoft Windows. (http://en.wikipedia.org/wiki/Nginx)',NULL,'{\"sw_webserver_nginx_version\": {\"title\": \"Version\", \"description\": \"The specific version of Nginx.\", \"type\": \"string\"}, \"sw_webserver_nginx_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_nginx_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-10-02 11:27:49',NULL),(23,32,'IIS','Internet Information Services (IIS, formerly Internet Information Server) is an extensible web server created by Microsoft. IIS supports HTTP, HTTPS, FTP, FTPS, SMTP and NNTP. IIS is not turned on by default when Windows is installed. The IIS Manager is accessed through the Microsoft Management Console or Administrative Tools in the Control Panel. (http://en.wikipedia.org/wiki/Internet_Information_Services)',NULL,'{\"sw_webserver_iis_version\": {\"title\": \"Version\", \"description\": \"The specific version of IIS.\", \"type\": \"string\"}, \"sw_webserver_iis_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_iis_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-10-02 11:27:49',NULL);
/*!40000 ALTER TABLE `metadef_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_properties`
--

DROP TABLE IF EXISTS `metadef_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_properties_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_properties_name` (`name`),
  CONSTRAINT `metadef_properties_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_properties`
--

LOCK TABLES `metadef_properties` WRITE;
/*!40000 ALTER TABLE `metadef_properties` DISABLE KEYS */;
INSERT INTO `metadef_properties` (`id`, `namespace_id`, `name`, `json_schema`, `created_at`, `updated_at`) VALUES (1,1,'InstructionSet','{\"title\": \"Instruction Set\", \"description\": \"Identifies the instruction set of the processor within a processor architecture.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86:i386\", \"x86:i486\", \"x86:i586\", \"x86:i686\", \"x86:64\", \"IA-64:IA-64\", \"AS/400:TIMI\", \"Power:Power_2.03\", \"Power:Power_2.04\", \"Power:Power_2.05\", \"Power:Power_2.06\", \"S/390:ESA/390\", \"S/390:z/Architecture\", \"S/390:z/Architecture_2\", \"PA-RISC:PA-RISC_1.0\", \"PA-RISC:PA-RISC_2.0\", \"ARM:A32\", \"ARM:A64\", \"MIPS:MIPS_I\", \"MIPS:MIPS_II\", \"MIPS:MIPS_III\", \"MIPS:MIPS_IV\", \"MIPS:MIPS_V\", \"MIPS:MIPS32\", \"MIPS64:MIPS64\", \"Alpha:Alpha\", \"SPARC:SPARC_V7\", \"SPARC:SPARC_V8\", \"SPARC:SPARC_V9\", \"SPARC:SPARC_JPS1\", \"SPARC:UltraSPARC2005\", \"SPARC:UltraSPARC2007\", \"68k:68000\", \"68k:68010\", \"68k:68020\", \"68k:68030\", \"68k:68040\", \"68k:68060\"]}','2025-10-02 11:27:47',NULL),(2,1,'ProcessorArchitecture','{\"title\": \"Processor Architecture\", \"description\": \"Identifies the processor architecture of the processor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"IA-64\", \"AS/400\", \"Power\", \"S/390\", \"PA-RISC\", \"ARM\", \"MIPS\", \"Alpha\", \"SPARC\", \"68k\"]}','2025-10-02 11:27:47',NULL),(3,1,'InstructionSetExtensionName','{\"title\": \"Instruction Set Extension\", \"description\": \"Identifies the instruction set extensions of the processor within a processor architecture.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"x86:3DNow\", \"x86:3DNowExt\", \"x86:ABM\", \"x86:AES\", \"x86:AVX\", \"x86:AVX2\", \"x86:BMI\", \"x86:CX16\", \"x86:F16C\", \"x86:FSGSBASE\", \"x86:LWP\", \"x86:MMX\", \"x86:PCLMUL\", \"x86:RDRND\", \"x86:SSE2\", \"x86:SSE3\", \"x86:SSSE3\", \"x86:SSE4A\", \"x86:SSE41\", \"x86:SSE42\", \"x86:FMA3\", \"x86:FMA4\", \"x86:XOP\", \"x86:TBM\", \"x86:VT-d\", \"x86:VT-x\", \"x86:EPT\", \"x86:SVM\", \"PA-RISC:MAX\", \"PA-RISC:MAX2\", \"ARM:DSP\", \"ARM:Jazelle-DBX\", \"ARM:Thumb\", \"ARM:Thumb-2\", \"ARM:ThumbEE)\", \"ARM:VFP\", \"ARM:NEON\", \"ARM:TrustZone\", \"MIPS:MDMX\", \"MIPS:MIPS-3D\", \"Alpha:BWX\", \"Alpha:FIX\", \"Alpha:CIX\", \"Alpha:MVI\"]}}','2025-10-02 11:27:47',NULL),(4,2,'Address','{\"title\": \"Address\", \"description\": \"The address of the resource.\", \"type\": \"string\"}','2025-10-02 11:27:47',NULL),(5,2,'AddressOnParent','{\"title\": \"Address On Parent\", \"description\": \"Describes the address of this resource in the context of the Parent.\", \"type\": \"string\"}','2025-10-02 11:27:47',NULL),(6,2,'AllocationUnits','{\"title\": \"Allocation Units\", \"description\": \"This property specifies the units of allocation used by the Reservation and Limit properties.\", \"type\": \"string\"}','2025-10-02 11:27:47',NULL),(7,2,'AutomaticAllocation','{\"title\": \"Automatic Allocation\", \"description\": \"This property specifies if the resource will be automatically allocated.\", \"type\": \"boolean\"}','2025-10-02 11:27:47',NULL),(8,2,'AutomaticDeallocation','{\"title\": \"Automatic Deallocation\", \"description\": \"This property specifies if the resource will be automatically de-allocated.\", \"type\": \"boolean\"}','2025-10-02 11:27:47',NULL),(9,2,'ConsumerVisibility','{\"title\": \"Consumer Visibility\", \"description\": \"Describes the consumers visibility to the allocated resource.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Passed-Through\", \"Virtualized\", \"Not represented\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-10-02 11:27:47',NULL),(10,2,'Limit','{\"title\": \"Limit\", \"description\": \"This property specifies the upper bound, or maximum amount of resource that will be granted for this allocation.\", \"type\": \"string\"}','2025-10-02 11:27:47',NULL),(11,2,'MappingBehavior','{\"title\": \"Mapping Behavior\", \"description\": \"Specifies how this resource maps to underlying resources. If the HostResource array contains any entries, this property reflects how the resource maps to those specific resources.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Not Supported\", \"Dedicated\", \"Soft Affinity\", \"Hard Affinity\", \"DMTF Reserved\", \"Vendor Reserved\"]}','2025-10-02 11:27:47',NULL),(12,2,'OtherResourceType','{\"title\": \"Other Resource Type\", \"description\": \"A string that describes the resource type when a well defined value is not available and ResourceType has the value \'Other\'.\", \"type\": \"string\"}','2025-10-02 11:27:47',NULL),(13,2,'Parent','{\"title\": \"Parent\", \"description\": \"The Parent of the resource.\", \"type\": \"string\"}','2025-10-02 11:27:47',NULL),(14,2,'PoolID','{\"title\": \"Pool ID\", \"description\": \"This property specifies which ResourcePool the resource is currently allocated from, or which ResourcePool the resource will be allocated from when the allocation occurs.\", \"type\": \"string\"}','2025-10-02 11:27:47',NULL),(15,2,'Reservation','{\"title\": \"Reservation\", \"description\": \"This property specifies the amount of resource guaranteed to be available for this allocation.\", \"type\": \"string\"}','2025-10-02 11:27:47',NULL),(16,2,'ResourceSubType','{\"title\": \"Resource Sub Type\", \"description\": \"A string describing an implementation specific sub-type for this resource.\", \"type\": \"string\"}','2025-10-02 11:27:47',NULL),(17,2,'ResourceType','{\"title\": \"Resource Type\", \"description\": \"The type of resource this allocation setting represents.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Other\", \"Computer System\", \"Processor\", \"Memory\", \"IDE Controller\", \"Parallel SCSI HBA\", \"FC HBA\", \"iSCSI HBA\", \"IB HCA\", \"Ethernet Adapter\", \"Other Network Adapter\", \"I/O Slot\", \"I/O Device\", \"Floppy Drive\", \"CD Drive\", \"DVD drive\", \"Disk Drive\", \"Tape Drive\", \"Storage Extent\", \"Other storage device\", \"Serial port\", \"Parallel port\", \"USB Controller\", \"Graphics controller\", \"IEEE 1394 Controller\", \"Partitionable Unit\", \"Base Partitionable Unit\", \"Power\", \"Cooling Capacity\", \"Ethernet Switch Port\", \"Logical Disk\", \"Storage Volume\", \"Ethernet Connection\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-10-02 11:27:47',NULL),(18,2,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"This property specifies the quantity of resources presented to the consumer.\", \"type\": \"string\"}','2025-10-02 11:27:47',NULL),(19,2,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-10-02 11:27:47',NULL),(20,2,'Weight','{\"title\": \"Weight\", \"description\": \"This property specifies a relative priority for this allocation in relation to other allocations from the same ResourcePool.\", \"type\": \"string\"}','2025-10-02 11:27:47',NULL),(21,2,'Connection','{\"title\": \"Connection\", \"description\": \"The thing to which this resource is connected.\", \"type\": \"string\"}','2025-10-02 11:27:47',NULL),(22,2,'HostResource','{\"title\": \"Host Resource\", \"description\": \"This property exposes specific assignment of resources.\", \"type\": \"string\"}','2025-10-02 11:27:47',NULL),(23,3,'Access','{\"title\": \"Access\", \"description\": \"Access describes whether the allocated storage extent is 1 (readable), 2 (writeable), or 3 (both).\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Readable\", \"Writeable\", \"Read/Write Supported\", \"DMTF Reserved\"]}','2025-10-02 11:27:47',NULL),(24,3,'HostExtentName','{\"title\": \"Host Extent Name\", \"description\": \"A unique identifier for the host extent.\", \"type\": \"string\"}','2025-10-02 11:27:47',NULL),(25,3,'HostExtentNameFormat','{\"title\": \"Host Extent Name Format\", \"description\": \"The HostExtentNameFormat property identifies the format that is used for the value of the HostExtentName property.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"SNVM\", \"NAA\", \"EUI64\", \"T10VID\", \"OS Device Name\", \"DMTF Reserved\"]}','2025-10-02 11:27:47',NULL),(26,3,'HostExtentNameNamespace','{\"title\": \"Host Extent Name Namespace\", \"description\": \"If the host extent is a SCSI volume, then the preferred source for SCSI volume names is SCSI VPD Page 83 responses.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"VPD83Type3\", \"VPD83Type2\", \"VPD83Type1\", \"VPD80\", \"NodeWWN\", \"SNVM\", \"OS Device Namespace\", \"DMTF Reserved\"]}','2025-10-02 11:27:47',NULL),(27,3,'HostExtentStartingAddress','{\"title\": \"Host Extent Starting Address\", \"description\": \"The HostExtentStartingAddress property identifies the starting address on the host storage extent identified by the value of the HostExtentName property that is used for the allocation of the virtual storage extent.\", \"type\": \"string\"}','2025-10-02 11:27:47',NULL),(28,3,'HostResourceBlockSize','{\"title\": \"Host Resource Block Size\", \"description\": \"Size in bytes of the blocks that are allocated at the host as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-10-02 11:27:47',NULL),(29,3,'Limit','{\"title\": \"Limit\", \"description\": \"The maximum amount of blocks that will be granted for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-10-02 11:27:47',NULL),(30,3,'OtherHostExtentNameFormat','{\"title\": \"Other Host Extent Name Format\", \"description\": \"A string describing the format of the HostExtentName property if the value of the HostExtentNameFormat property is 1 (Other).\", \"type\": \"string\"}','2025-10-02 11:27:47',NULL),(31,3,'OtherHostExtentNameNamespace','{\"title\": \"Other Host Extent Name Namespace\", \"description\": \"A string describing the namespace of the HostExtentName property if the value of the HostExtentNameNamespace matches 1 (Other).\", \"type\": \"string\"}','2025-10-02 11:27:47',NULL),(32,3,'Reservation','{\"title\": \"Reservation\", \"description\": \"The amount of blocks that are guaranteed to be available for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-10-02 11:27:48',NULL),(33,3,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"Number of blocks that are presented to the consumer.\", \"type\": \"string\"}','2025-10-02 11:27:48',NULL),(34,3,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-10-02 11:27:48',NULL),(35,3,'VirtualResourceBlockSize','{\"title\": \"Virtual Resource Block Size\", \"description\": \"Size in bytes of the blocks that are presented to the consumer as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-10-02 11:27:48',NULL),(36,4,'AutomaticRecoveryAction','{\"title\": \"Automatic Recovery Action\", \"description\": \"Action to take for the virtual system when the software executed by the virtual system fails.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart\", \"Revert to snapshot\", \"DMTF Reserved\"]}','2025-10-02 11:27:48',NULL),(37,4,'AutomaticShutdownAction','{\"title\": \"Automatic Shutdown Action\", \"description\": \"Action to take for the virtual system when the host is shut down.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Turn Off\", \"Save state\", \"Shutdown\", \"DMTF Reserved\"]}','2025-10-02 11:27:48',NULL),(38,4,'AutomaticStartupAction','{\"title\": \"Automatic Startup Action\", \"description\": \"Action to take for the virtual system when the host is started.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart if previously active\", \"Always startup\", \"DMTF Reserved\"]}','2025-10-02 11:27:48',NULL),(39,4,'AutomaticStartupActionDelay','{\"title\": \"Automatic Startup Action Delay\", \"description\": \"Delay applicable to startup action.\", \"type\": \"string\"}','2025-10-02 11:27:48',NULL),(40,4,'AutomaticStartupActionSequenceNumber','{\"title\": \"Automatic Startup Action Sequence Number\", \"description\": \"Number indicating the relative sequence of virtual system activation when the host system is started.\", \"type\": \"string\"}','2025-10-02 11:27:48',NULL),(41,4,'ConfigurationDataRoot','{\"title\": \"Configuration Data Root\", \"description\": \"Filepath of a directory where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-10-02 11:27:48',NULL),(42,4,'ConfigurationFile','{\"title\": \"Configuration File\", \"description\": \"Filepath of a file where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-10-02 11:27:48',NULL),(43,4,'ConfigurationID','{\"title\": \"Configuration ID\", \"description\": \"Unique id of the virtual system configuration.\", \"type\": \"string\"}','2025-10-02 11:27:48',NULL),(44,4,'CreationTime','{\"title\": \"Creation Time\", \"description\": \"Time when the virtual system configuration was created.\", \"type\": \"string\"}','2025-10-02 11:27:48',NULL),(45,4,'LogDataRoot','{\"title\": \"Log Data Root\", \"description\": \"Filepath of a directory where log information about the virtual system is stored.\", \"type\": \"string\"}','2025-10-02 11:27:48',NULL),(46,4,'RecoveryFile','{\"title\": \"Recovery File\", \"description\": \"Filepath of a file where recovery relateded information of the virtual system is stored.\", \"type\": \"string\"}','2025-10-02 11:27:48',NULL),(47,4,'SnapshotDataRoot','{\"title\": \"Snapshot Data Root\", \"description\": \"Filepath of a directory where information about virtual system snapshots is stored.\", \"type\": \"string\"}','2025-10-02 11:27:48',NULL),(48,4,'SuspendDataRoot','{\"title\": \"Suspend Data Root\", \"description\": \"Filepath of a directory where suspend related information about the virtual system is stored.\", \"type\": \"string\"}','2025-10-02 11:27:48',NULL),(49,4,'SwapFileDataRoot','{\"title\": \"Swap File Data Root\", \"description\": \"Filepath of a directory where swapfiles of the virtual system are stored.\", \"type\": \"string\"}','2025-10-02 11:27:48',NULL),(50,4,'VirtualSystemIdentifier','{\"title\": \"Virtual System Identifier\", \"description\": \"VirtualSystemIdentifier shall reflect a unique name for the system as it is used within the virtualization platform.\", \"type\": \"string\"}','2025-10-02 11:27:48',NULL),(51,4,'VirtualSystemType','{\"title\": \"Virtual System Type\", \"description\": \"VirtualSystemType shall reflect a particular type of virtual system.\", \"type\": \"string\"}','2025-10-02 11:27:48',NULL),(52,4,'Notes','{\"title\": \"Notes\", \"description\": \"End-user supplied notes that are related to the virtual system.\", \"type\": \"string\"}','2025-10-02 11:27:48',NULL),(53,5,'disk_allocation_ratio','{\"title\": \"Disk Subscription Ratio\", \"description\": \"Allows the host to be under and over subscribed for the amount of disk space requested for an instance. A ratio greater than 1.0 allows for over subscription (hosts may have less usable disk space than requested). A ratio less than 1.0 allows for under subscription.\", \"type\": \"number\", \"readonly\": false}','2025-10-02 11:27:48',NULL),(54,6,'max_io_ops_per_host','{\"title\": \"Maximum IO Operations per Host\", \"description\": \"Prevents hosts in the aggregate that have this many or more instances currently in build, resize, snapshot, migrate, rescue or unshelve to be scheduled for new instances.\", \"type\": \"integer\", \"readonly\": false, \"default\": 8, \"minimum\": 1}','2025-10-02 11:27:48',NULL),(55,7,'max_instances_per_host','{\"title\": \"Max Instances Per Host\", \"description\": \"Maximum number of instances allowed to run on a host in the aggregate.\", \"type\": \"integer\", \"readonly\": false, \"minimum\": 0}','2025-10-02 11:27:48',NULL),(56,8,'cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"Type of CPU Mode.\", \"type\": \"string\", \"enum\": [\"none\", \"host-model\", \"host-passthrough\", \"custom\"]}','2025-10-02 11:27:48',NULL),(57,9,'cpu_policy','{\"title\": \"CPU Pinning policy\", \"description\": \"Type of CPU pinning policy.\", \"type\": \"string\", \"enum\": [\"shared\", \"dedicated\"]}','2025-10-02 11:27:48',NULL),(58,9,'cpu_thread_policy','{\"title\": \"CPU Thread Pinning Policy.\", \"description\": \"Type of CPU thread pinning policy.\", \"type\": \"string\", \"enum\": [\"isolate\", \"prefer\", \"require\"]}','2025-10-02 11:27:48',NULL),(59,10,'mem_page_size','{\"title\": \"Size of memory page\", \"description\": \"Page size to be used for Guest memory backing. Value can be specified as <number><unit> (i.e.: 2MB, 1GB) or \'any\', \'small\', \'large\'. If this property is set in Image metadata then only \'any\' and \'large\' values are accepted in Flavor metadata by Nova API.\", \"type\": \"string\"}','2025-10-02 11:27:48',NULL),(60,11,'os_shutdown_timeout','{\"title\": \"Shutdown timeout\", \"description\": \"By default, guests will be given 60 seconds to perform a graceful shutdown. After that, the VM is powered off.  This property allows overriding the amount of time (unit: seconds) to allow a guest OS to cleanly shut down before power off. A value of 0 (zero) means the guest will be powered off immediately with no opportunity for guest OS clean-up.\", \"type\": \"integer\", \"minimum\": 0}','2025-10-02 11:27:48',NULL),(61,12,'cpu_info:vendor','{\"title\": \"Vendor\", \"description\": \"Specifies the CPU manufacturer.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Intel\", \"AMD\"]}','2025-10-02 11:27:48',NULL),(62,12,'cpu_info:model','{\"title\": \"Model\", \"description\": \"Specifies the CPU model. Use this property to ensure that your vm runs on a specific cpu model.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Conroe\", \"Core2Duo\", \"Penryn\", \"Nehalem\", \"Westmere\", \"SandyBridge\", \"IvyBridge\", \"Haswell\", \"Broadwell\", \"Delhi\", \"Seoul\", \"Abu Dhabi\", \"Interlagos\", \"Kabini\", \"Valencia\", \"Zurich\", \"Budapest\", \"Barcelona\", \"Suzuka\", \"Shanghai\", \"Istanbul\", \"Lisbon\", \"Magny-Cours\", \"Valencia\", \"Cortex-A57\", \"Cortex-A53\", \"Cortex-A12\", \"Cortex-A17\", \"Cortex-A15\", \"Coretx-A7\", \"X-Gene\"]}','2025-10-02 11:27:48',NULL),(63,12,'cpu_info:arch','{\"title\": \"Architecture\", \"description\": \"Specifies the CPU architecture. Use this property to specify the architecture supported by the hypervisor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"x86_64\", \"i686\", \"ia64\", \"ARMv8-A\", \"ARMv7-A\"]}','2025-10-02 11:27:48',NULL),(64,12,'cpu_info:topology:cores','{\"title\": \"cores\", \"description\": \"Number of cores.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-10-02 11:27:48',NULL),(65,12,'cpu_info:topology:threads','{\"title\": \"threads\", \"description\": \"Number of threads.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-10-02 11:27:48',NULL),(66,12,'cpu_info:topology:sockets','{\"title\": \"sockets\", \"description\": \"Number of sockets.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-10-02 11:27:48',NULL),(67,12,'cpu_info:features','{\"title\": \"Features\", \"description\": \"Specifies CPU flags/features. Using this property you can specify the required set of instructions supported by a vm.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"fpu\", \"vme\", \"de\", \"pse\", \"tsc\", \"msr\", \"pae\", \"mce\", \"cx8\", \"apic\", \"sep\", \"mtrr\", \"pge\", \"mca\", \"cmov\", \"pat\", \"pse36\", \"pn\", \"clflush\", \"dts\", \"acpi\", \"mmx\", \"fxsr\", \"sse\", \"sse2\", \"ss\", \"ht\", \"tm\", \"ia64\", \"pbe\", \"syscall\", \"mp\", \"nx\", \"mmxext\", \"fxsr_opt\", \"pdpe1gb\", \"rdtscp\", \"lm\", \"3dnowext\", \"3dnow\", \"arch_perfmon\", \"pebs\", \"bts\", \"rep_good\", \"nopl\", \"xtopology\", \"tsc_reliable\", \"nonstop_tsc\", \"extd_apicid\", \"amd_dcm\", \"aperfmperf\", \"eagerfpu\", \"nonstop_tsc_s3\", \"pni\", \"pclmulqdq\", \"dtes64\", \"monitor\", \"ds_cpl\", \"vmx\", \"smx\", \"est\", \"tm2\", \"ssse3\", \"cid\", \"fma\", \"cx16\", \"xtpr\", \"pdcm\", \"pcid\", \"dca\", \"sse4_1\", \"sse4_2\", \"x2apic\", \"movbe\", \"popcnt\", \"tsc_deadline_timer\", \"aes\", \"xsave\", \"avx\", \"f16c\", \"rdrand\", \"hypervisor\", \"rng\", \"rng_en\", \"ace\", \"ace_en\", \"ace2\", \"ace2_en\", \"phe\", \"phe_en\", \"pmm\", \"pmm_en\", \"lahf_lm\", \"cmp_legacy\", \"svm\", \"extapic\", \"cr8_legacy\", \"abm\", \"sse4a\", \"misalignsse\", \"3dnowprefetch\", \"osvw\", \"ibs\", \"xop\", \"skinit\", \"wdt\", \"lwp\", \"fma4\", \"tce\", \"nodeid_msr\", \"tbm\", \"topoext\", \"perfctr_core\", \"perfctr_nb\", \"bpext\", \"perfctr_l2\", \"mwaitx\", \"ida\", \"arat\", \"cpb\", \"epb\", \"pln\", \"pts\", \"dtherm\", \"hw_pstate\", \"proc_feedback\", \"hwp\", \"hwp_notify\", \"hwp_act_window\", \"hwp_epp\", \"hwp_pkg_req\", \"intel_pt\", \"tpr_shadow\", \"vnmi\", \"flexpriority\", \"ept\", \"vpid\", \"npt\", \"lbrv\", \"svm_lock\", \"nrip_save\", \"tsc_scale\", \"vmcb_clean\", \"flushbyasid\", \"decodeassists\", \"pausefilter\", \"pfthreshold\", \"vmmcall\", \"fsgsbase\", \"tsc_adjust\", \"bmi1\", \"hle\", \"avx2\", \"smep\", \"bmi2\", \"erms\", \"invpcid\", \"rtm\", \"cqm\", \"mpx\", \"avx512f\", \"rdseed\", \"adx\", \"smap\", \"pcommit\", \"clflushopt\", \"clwb\", \"avx512pf\", \"avx512er\", \"avx512cd\", \"sha_ni\", \"xsaveopt\", \"xsavec\", \"xgetbv1\", \"xsaves\", \"cqm_llc\", \"cqm_occup_llc\", \"clzero\"]}}','2025-10-02 11:27:48',NULL),(68,13,'hypervisor_type','{\"title\": \"Hypervisor Type\", \"description\": \"Hypervisor type required by the image. Used with the ImagePropertiesFilter. \\n\\n Baremetal - physical provisioning. hyperv - Microsoft\\u00ae hyperv. KVM - Kernel-based Virtual Machine. LXC - Linux Containers (through libvirt). powervm - IBM\\u00ae PowerVM\\u00ae. QEMU - Quick EMUlator. UML - User Mode Linux. vmware - VMware\\u00ae vsphere. VZ - Virtuozzo OS Containers and Virtual Machines (through libvirt). For more information, see: https://docs.openstack.org/nova/latest/admin/configuration/hypervisors.html\", \"type\": \"string\", \"enum\": [\"baremetal\", \"hyperv\", \"kvm\", \"lxc\", \"powervm\", \"qemu\", \"uml\", \"vmware\", \"vz\", \"xen\"]}','2025-10-02 11:27:48',NULL),(69,13,'vm_mode','{\"title\": \"VM Mode\", \"description\": \"The virtual machine mode. This represents the host/guest ABI (application binary interface) used for the virtual machine. Used with the ImagePropertiesFilter. \\n\\n hvm \\u2014 Fully virtualized - This is the virtual machine mode (vm_mode) used by QEMU and KVM. \\n\\n xen - Xen 3.0 paravirtualized. \\n\\n uml \\u2014 User Mode Linux paravirtualized. \\n\\n exe \\u2014 Executables in containers. This is the mode used by LXC.\", \"type\": \"string\", \"enum\": [\"hvm\", \"xen\", \"uml\", \"exe\"]}','2025-10-02 11:27:48',NULL),(70,14,'img_config_drive','{\"title\": \"Config Drive\", \"description\": \"This property specifies whether or not Nova should use a config drive when booting the image. Mandatory means that Nova will always use a config drive when booting the image. OpenStack can be configured to write metadata to a special configuration drive that will be attached to the instance when it boots. The instance can retrieve any information from the config drive. One use case for the config drive is to pass network configuration information to the instance. See also: http://docs.openstack.org/user-guide/cli_config_drive.html\", \"type\": \"string\", \"enum\": [\"optional\", \"mandatory\"]}','2025-10-02 11:27:48',NULL),(71,14,'os_require_quiesce','{\"title\": \"Require Quiescent File system\", \"description\": \"This property specifies whether or not the filesystem must be quiesced during snapshot processing. For volume backed and image backed snapshots, yes means that snapshotting is aborted when quiescing fails, whereas, no means quiescing will be skipped and snapshot processing will continue after the quiesce failure.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-10-02 11:27:48',NULL),(72,15,'hw_cdrom_bus','{\"title\": \"CD-ROM Bus\", \"description\": \"Specifies the type of disk controller to attach CD-ROM devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-10-02 11:27:48',NULL),(73,15,'hw_disk_bus','{\"title\": \"Disk Bus\", \"description\": \"Specifies the type of disk controller to attach disk devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-10-02 11:27:48',NULL),(74,15,'hw_firmware_type','{\"title\": \"Firmware Type\", \"description\": \"Specifies whether the image should be booted with a legacy BIOS or with UEFI.\", \"type\": \"string\", \"enum\": [\"bios\", \"uefi\"]}','2025-10-02 11:27:48',NULL),(75,15,'hw_rng_model','{\"title\": \"Random Number Generator Device\", \"description\": \"Adds a random-number generator device to the image\'s instances. The cloud administrator can enable and control device behavior by configuring the instance\'s flavor. By default: The generator device is disabled. /dev/random is used as the default entropy source. To specify a physical HW RNG device, use the following option in the nova.conf file: rng_dev_path=/dev/hwrng\", \"type\": \"string\", \"default\": \"virtio\"}','2025-10-02 11:27:48',NULL),(76,15,'hw_machine_type','{\"title\": \"Machine Type\", \"description\": \"Enables booting an ARM system using the specified machine type. By default, if an ARM image is used and its type is not specified, Compute uses vexpress-a15 (for ARMv7) or virt (for AArch64) machine types. Valid types can be viewed by using the virsh capabilities command (machine types are displayed in the machine tag).\", \"type\": \"string\"}','2025-10-02 11:27:48',NULL),(77,15,'hw_scsi_model','{\"title\": \"SCSI Model\", \"description\": \"Enables the use of VirtIO SCSI (virtio-scsi) to provide block device access for compute instances; by default, instances use VirtIO Block (virtio-blk). VirtIO SCSI is a para-virtualized SCSI controller device that provides improved scalability and performance, and supports advanced SCSI hardware.\", \"type\": \"string\", \"default\": \"virtio-scsi\"}','2025-10-02 11:27:48',NULL),(78,15,'hw_video_model','{\"title\": \"Video Model\", \"description\": \"The graphic device model presented to the guest. hw_video_model=none disables the graphics device in the guest and should generally be used when using gpu passthrough.\", \"type\": \"string\", \"enum\": [\"vga\", \"cirrus\", \"vmvga\", \"xen\", \"qxl\", \"virtio\", \"gop\", \"none\", \"bochs\"]}','2025-10-02 11:27:48',NULL),(79,15,'hw_video_ram','{\"title\": \"Max Video Ram\", \"description\": \"Maximum RAM (unit: MB) for the video image. Used only if a hw_video:ram_max_mb value has been set in the flavor\'s extra_specs and that value is higher than the value set in hw_video_ram.\", \"type\": \"integer\", \"minimum\": 0}','2025-10-02 11:27:48',NULL),(80,15,'os_command_line','{\"title\": \"Kernel Command Line\", \"description\": \"The kernel command line to be used by the libvirt driver, instead of the default. For linux containers (LXC), the value is used as arguments for initialization. This key is valid only for Amazon kernel, ramdisk, or machine images (aki, ari, or ami).\", \"type\": \"string\"}','2025-10-02 11:27:48',NULL),(81,15,'os_type','{\"title\": \"OS Type\", \"description\": \"The operating system installed on the image. The libvirt driver contains logic that takes different actions depending on the value of the os_type parameter of the image. For example, for os_type=windows images, it creates a FAT32-based swap partition instead of a Linux swap partition, and it limits the injected host name to less than 16 characters.\", \"type\": \"string\", \"enum\": [\"linux\", \"windows\"]}','2025-10-02 11:27:48',NULL),(82,15,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor configuration. libvirt driver options: KVM and QEMU: e1000, ne2k_pci, pcnet, rtl8139, spapr-vlan, virtio, e1000e and vmxnet3. Xen: e1000, netfront, ne2k_pci, pcnet, and rtl8139.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"ne2k_pci\", \"netfront\", \"pcnet\", \"rtl8139\", \"spapr-vlan\", \"virtio\", \"vmxnet3\"]}','2025-10-02 11:27:48',NULL),(83,15,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-10-02 11:27:48',NULL),(84,15,'hw_pmu','{\"title\": \"Virtual Performance Monitoring Unit\", \"description\": \"Controls emulation of a vPMU in the guest. To reduce latency in realtime workloads disable the vPMU by setting hw_pmu=false\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-10-02 11:27:48',NULL),(85,15,'hw_qemu_guest_agent','{\"title\": \"QEMU Guest Agent\", \"description\": \"This is a background process which helps management applications execute guest OS level commands. For example, freezing and thawing filesystems, entering suspend. However, guest agent (GA) is not bullet proof, and hostile guest OS can send spurious replies.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-10-02 11:27:48',NULL),(86,15,'hw_pointer_model','{\"title\": \"Pointer Model\", \"description\": \"Input devices allow interaction with a graphical framebuffer. For example to provide a graphic tablet for absolute cursor movement. Currently only supported by the KVM/QEMU hypervisor configuration and VNC or SPICE consoles must be enabled.\", \"type\": \"string\", \"enum\": [\"usbtablet\"]}','2025-10-02 11:27:48',NULL),(87,15,'img_hide_hypervisor_id','{\"title\": \"Hide hypervisor id\", \"description\": \"Enables hiding the host hypervisor signature in the guest OS.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-10-02 11:27:48',NULL),(88,16,'serial_port_count','{\"title\": \"Serial Port Count\", \"description\": \"Specifies the count of serial ports that should be provided. If hw:serial_port_count is not set in the flavor\'s extra_specs, then any count is permitted. If hw:serial_port_count is set, then this provides the default serial port count. It is permitted to override the default serial port count, but only with a lower value.\", \"type\": \"integer\", \"minimum\": 0}','2025-10-02 11:27:48',NULL),(89,16,'boot_menu','{\"title\": \"Boot Menu\", \"description\": \"If true, enables the BIOS bootmenu. In cases where both the image metadata and Extra Spec are set, the Extra Spec setting is used. This allows for flexibility in setting/overriding the default behavior as needed.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-10-02 11:27:48',NULL),(90,16,'mem_encryption','{\"title\": \"Hardware Memory Encryption\", \"description\": \"Enables encryption of guest memory at the hardware level, if there are compute hosts available which support this. See https://docs.openstack.org/nova/latest/admin/configuration/hypervisor-kvm.html#amd-sev-secure-encrypted-virtualization for details.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-10-02 11:27:48',NULL),(91,18,'hw_rng:allowed','{\"title\": \"Random Number Generator Allowed\", \"description\": \"\", \"type\": \"boolean\"}','2025-10-02 11:27:48',NULL),(92,18,'hw_rng:rate_bytes','{\"title\": \"Random number generator limits.\", \"description\": \"Allowed amount of bytes that the guest can read from the host\'s entropy per period.\", \"type\": \"integer\"}','2025-10-02 11:27:48',NULL),(93,18,'hw_rng:rate_period','{\"title\": \"Random number generator read period.\", \"description\": \"Duration of the read period in milliseconds.\", \"type\": \"integer\"}','2025-10-02 11:27:48',NULL),(94,19,'cpu_sockets','{\"title\": \"vCPU Sockets\", \"description\": \"Preferred number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-10-02 11:27:48',NULL),(95,19,'cpu_cores','{\"title\": \"vCPU Cores\", \"description\": \"Preferred number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-10-02 11:27:48',NULL),(96,19,'cpu_threads','{\"title\": \" vCPU Threads\", \"description\": \"Preferred number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-10-02 11:27:48',NULL),(97,19,'cpu_max_sockets','{\"title\": \"Max vCPU Sockets\", \"description\": \"Maximum number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-10-02 11:27:48',NULL),(98,19,'cpu_max_cores','{\"title\": \"Max vCPU Cores\", \"description\": \"Maximum number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-10-02 11:27:48',NULL),(99,19,'cpu_max_threads','{\"title\": \"Max vCPU Threads\", \"description\": \"Maximum number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-10-02 11:27:48',NULL),(100,20,'vmware:hw_version','{\"title\": \"VMware Hardware Version\", \"description\": \"Specifies the hardware version VMware uses to create images. If the hardware version needs to be compatible with a cluster version, for backward compatibility or other circumstances, the vmware:hw_version key specifies a virtual machine hardware version. In the event that a cluster has mixed host version types, the key will enable the vCenter to place the cluster on the correct host.\", \"type\": \"string\", \"enum\": [\"vmx-13\", \"vmx-11\", \"vmx-10\", \"vmx-09\", \"vmx-08\", \"vmx-07\", \"vmx-04\", \"vmx-03\"]}','2025-10-02 11:27:48',NULL),(101,20,'vmware:storage_policy','{\"title\": \"VMware Storage Policy\", \"description\": \"Specifies the storage policy to be applied for newly created instance. If not provided, the default storage policy specified in config file will be used. If Storage Policy Based Management (SPBM) is not enabled in config file, this value won\'t be used.\", \"type\": \"string\"}','2025-10-02 11:27:48',NULL),(102,21,'quota:cpu_limit','{\"title\": \"Quota: CPU Limit\", \"description\": \"Specifies the upper limit for CPU allocation in MHz. This parameter ensures that a machine never uses more than the defined amount of CPU time. It can be used to enforce a limit on the machine\'s CPU performance. The value should be a numerical value in MHz. If zero is supplied then the cpu_limit is unlimited.\", \"type\": \"integer\", \"minimum\": 0}','2025-10-02 11:27:48',NULL),(103,21,'quota:cpu_reservation','{\"title\": \"Quota: CPU Reservation Limit\", \"description\": \"Specifies the guaranteed minimum CPU reservation in MHz. This means that if needed, the machine will definitely get allocated the reserved amount of CPU cycles. The value should be a numerical value in MHz.\", \"type\": \"integer\", \"minimum\": 0}','2025-10-02 11:27:48',NULL),(104,22,'img_linked_clone','{\"title\": \"Linked Clone\", \"description\": \"By default, the VMware compute driver creates linked clones when possible (though this can be turned off by the operator). You can use this image property on a per-image basis to control whether virtual machines booted from the image are treated as full clones (value: false) or linked clones (value: true). Please refer to VMware documentation for information about full vs. linked clones.\", \"type\": \"boolean\"}','2025-10-02 11:27:48',NULL),(105,22,'vmware_adaptertype','{\"title\": \"Disk Adapter Type\", \"description\": \"The virtual SCSI or IDE controller used by the hypervisor.\", \"type\": \"string\", \"enum\": [\"lsiLogic\", \"lsiLogicsas\", \"paraVirtual\", \"busLogic\", \"ide\"], \"default\": \"lsiLogic\"}','2025-10-02 11:27:48',NULL),(106,22,'vmware_disktype','{\"title\": \"Disk Provisioning Type\", \"description\": \"When performing operations such as creating a virtual disk, cloning, or migrating, the disk provisioning type may be specified. Please refer to VMware documentation for more.\", \"type\": \"string\", \"enum\": [\"streamOptimized\", \"sparse\", \"preallocated\"], \"default\": \"preallocated\"}','2025-10-02 11:27:48',NULL),(107,22,'vmware_ostype','{\"title\": \"OS Type\", \"description\": \"A VMware GuestID which describes the operating system installed in the image. This value is passed to the hypervisor when creating a virtual machine. If not specified, the key defaults to otherGuest. See thinkvirt.com.\", \"type\": \"string\", \"enum\": [\"asianux3_64Guest\", \"asianux3Guest\", \"asianux4_64Guest\", \"asianux4Guest\", \"asianux5_64Guest\", \"asianux7_64Guest\", \"centos64Guest\", \"centosGuest\", \"centos6Guest\", \"centos6_64Guest\", \"centos7_64Guest\", \"coreos64Guest\", \"darwin10_64Guest\", \"darwin10Guest\", \"darwin11_64Guest\", \"darwin11Guest\", \"darwin12_64Guest\", \"darwin13_64Guest\", \"darwin14_64Guest\", \"darwin15_64Guest\", \"darwin16_64Guest\", \"darwin64Guest\", \"darwinGuest\", \"debian4_64Guest\", \"debian4Guest\", \"debian5_64Guest\", \"debian5Guest\", \"debian6_64Guest\", \"debian6Guest\", \"debian7_64Guest\", \"debian7Guest\", \"debian8_64Guest\", \"debian8Guest\", \"debian9_64Guest\", \"debian9Guest\", \"debian10_64Guest\", \"debian10Guest\", \"dosGuest\", \"eComStation2Guest\", \"eComStationGuest\", \"fedora64Guest\", \"fedoraGuest\", \"freebsd64Guest\", \"freebsdGuest\", \"genericLinuxGuest\", \"mandrakeGuest\", \"mandriva64Guest\", \"mandrivaGuest\", \"netware4Guest\", \"netware5Guest\", \"netware6Guest\", \"nld9Guest\", \"oesGuest\", \"openServer5Guest\", \"openServer6Guest\", \"opensuse64Guest\", \"opensuseGuest\", \"oracleLinux64Guest\", \"oracleLinuxGuest\", \"oracleLinux6Guest\", \"oracleLinux6_64Guest\", \"oracleLinux7_64Guest\", \"os2Guest\", \"other24xLinux64Guest\", \"other24xLinuxGuest\", \"other26xLinux64Guest\", \"other26xLinuxGuest\", \"other3xLinux64Guest\", \"other3xLinuxGuest\", \"otherGuest\", \"otherGuest64\", \"otherLinux64Guest\", \"otherLinuxGuest\", \"redhatGuest\", \"rhel2Guest\", \"rhel3_64Guest\", \"rhel3Guest\", \"rhel4_64Guest\", \"rhel4Guest\", \"rhel5_64Guest\", \"rhel5Guest\", \"rhel6_64Guest\", \"rhel6Guest\", \"rhel7_64Guest\", \"rhel7Guest\", \"sjdsGuest\", \"sles10_64Guest\", \"sles10Guest\", \"sles11_64Guest\", \"sles11Guest\", \"sles12_64Guest\", \"sles12Guest\", \"sles64Guest\", \"slesGuest\", \"solaris10_64Guest\", \"solaris10Guest\", \"solaris11_64Guest\", \"solaris6Guest\", \"solaris7Guest\", \"solaris8Guest\", \"solaris9Guest\", \"turboLinux64Guest\", \"turboLinuxGuest\", \"ubuntu64Guest\", \"ubuntuGuest\", \"unixWare7Guest\", \"vmkernel5Guest\", \"vmkernel6Guest\", \"vmkernel65Guest\", \"vmkernelGuest\", \"vmwarePhoton64Guest\", \"win2000AdvServGuest\", \"win2000ProGuest\", \"win2000ServGuest\", \"win31Guest\", \"win95Guest\", \"win98Guest\", \"windows7_64Guest\", \"windows7Guest\", \"windows7Server64Guest\", \"windows8_64Guest\", \"windows8Guest\", \"windows8Server64Guest\", \"windows9_64Guest\", \"windows9Guest\", \"windows9Server64Guest\", \"windowsHyperVGuest\", \"winLonghorn64Guest\", \"winLonghornGuest\", \"winMeGuest\", \"winNetBusinessGuest\", \"winNetDatacenter64Guest\", \"winNetDatacenterGuest\", \"winNetEnterprise64Guest\", \"winNetEnterpriseGuest\", \"winNetStandard64Guest\", \"winNetStandardGuest\", \"winNetWebGuest\", \"winNTGuest\", \"winVista64Guest\", \"winVistaGuest\", \"winXPHomeGuest\", \"winXPPro64Guest\", \"winXPProGuest\"], \"default\": \"otherGuest\"}','2025-10-02 11:27:48',NULL),(108,22,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor. VMware driver supported options: e1000, e1000e, VirtualE1000, VirtualE1000e, VirtualPCNet32, and VirtualVmxnet.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"VirtualE1000\", \"VirtualE1000e\", \"VirtualPCNet32\", \"VirtualVmxnet\", \"VirtualVmxnet3\"], \"default\": \"e1000\"}','2025-10-02 11:27:48',NULL),(109,22,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-10-02 11:27:49',NULL),(110,23,'tpm_model','{\"title\": \"TPM model\", \"description\": \"TPM model to use. Option CRB is only valid for TPM version 2.0. Defaults to TIS.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"TIS\", \"CRB\"], \"default\": \"TIS\"}','2025-10-02 11:27:49',NULL),(111,24,'COMPUTE_SECURITY_TPM_1_2','{\"title\": \"Virtual TPM Version 1.2 Support\", \"description\": \"Enables virtual TPM version 1.2.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-10-02 11:27:49',NULL),(112,24,'COMPUTE_SECURITY_TPM_2_0','{\"title\": \"Virtual TPM Version 2.0 Support\", \"description\": \"Enables virtual TPM version 2.0.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-10-02 11:27:49',NULL),(113,25,'watchdog_action','{\"title\": \"Watchdog Action\", \"description\": \"For the libvirt driver, you can enable and set the behavior of a virtual hardware watchdog device for each flavor. Watchdog devices keep an eye on the guest server, and carry out the configured action, if the server hangs. The watchdog uses the i6300esb device (emulating a PCI Intel 6300ESB). If hw_watchdog_action is not specified, the watchdog is disabled. Watchdog behavior set using a specific image\'s properties will override behavior set using flavors.\", \"type\": \"string\", \"enum\": [\"disabled\", \"reset\", \"poweroff\", \"pause\", \"none\"]}','2025-10-02 11:27:49',NULL),(114,26,'auto_disk_config','{\"title\": \"Disk Adapter Type\", \"description\": \"If true, the root partition on the disk is automatically resized before the instance boots. This value is only taken into account by the Compute service when using a Xen-based hypervisor with the XenAPI driver. The Compute service will only attempt to resize if there is a single partition on the image, and only if the partition is in ext3 or ext4 format.\", \"type\": \"boolean\"}','2025-10-02 11:27:49',NULL),(115,27,'kernel_id','{\"title\": \"Kernel ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the kernel when booting an AMI-style image.\"}','2025-10-02 11:27:49',NULL),(116,27,'ramdisk_id','{\"title\": \"Ramdisk ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the ramdisk when booting an AMI-style image.\"}','2025-10-02 11:27:49',NULL),(117,27,'instance_uuid','{\"title\": \"Instance ID\", \"type\": \"string\", \"description\": \"Metadata which can be used to record which instance this image is associated with. (Informational only, does not create an instance snapshot.)\"}','2025-10-02 11:27:49',NULL),(118,27,'architecture','{\"title\": \"CPU Architecture\", \"description\": \"The CPU architecture that must be supported by the hypervisor. For example, x86_64, arm, or ppc64. Run uname -m to get the architecture of a machine. We strongly recommend using the architecture data vocabulary defined by the libosinfo project for this purpose.\", \"type\": \"string\"}','2025-10-02 11:27:49',NULL),(119,27,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-10-02 11:27:49',NULL),(120,27,'hw_cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"This specifies the CPU Mode for the guest vm\", \"type\": \"string\"}','2025-10-02 11:27:49',NULL),(121,27,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-10-02 11:27:49',NULL),(122,27,'description','{\"title\": \"Image description\", \"description\": \"A human-readable string describing this image.\", \"type\": \"string\"}','2025-10-02 11:27:49',NULL),(123,27,'cinder_encryption_key_id','{\"title\": \"Cinder Encryption Key ID\", \"description\": \"Identifier in the OpenStack Key Management Service for the encryption key for the Block Storage Service to use when mounting a volume created from this image\", \"type\": \"string\"}','2025-10-02 11:27:49',NULL),(124,27,'cinder_encryption_key_deletion_policy','{\"title\": \"Cinder Encryption Key Deletion Policy\", \"description\": \"States the condition under which the Image Service will delete the object associated with the \'cinder_encryption_key_id\' image property.  If this property is missing, the Image Service will take no action\", \"type\": \"string\", \"enum\": [\"on_image_deletion\", \"do_not_delete\"]}','2025-10-02 11:27:49',NULL),(125,28,'img_signature','{\"title\": \"Image Signature\", \"description\": \"The signature of the image data encoded in base64 format.\", \"type\": \"string\"}','2025-10-02 11:27:49',NULL),(126,28,'img_signature_certificate_uuid','{\"title\": \"Image Signature Certificate UUID\", \"description\": \"The UUID used to retrieve the certificate from the key manager.\", \"type\": \"string\"}','2025-10-02 11:27:49',NULL),(127,28,'img_signature_hash_method','{\"title\": \"Image Signature Hash Method\", \"description\": \"The hash method used in creating the signature.\", \"type\": \"string\", \"enum\": [\"SHA-224\", \"SHA-256\", \"SHA-384\", \"SHA-512\"]}','2025-10-02 11:27:49',NULL),(128,28,'img_signature_key_type','{\"title\": \"Image Signature Key Type\", \"description\": \"The key type used in creating the signature.\", \"type\": \"string\", \"enum\": [\"RSA-PSS\", \"DSA\", \"ECC_SECT571K1\", \"ECC_SECT409K1\", \"ECC_SECT571R1\", \"ECC_SECT409R1\", \"ECC_SECP521R1\", \"ECC_SECP384R1\"]}','2025-10-02 11:27:49',NULL),(129,29,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-10-02 11:27:49',NULL),(130,29,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-10-02 11:27:49',NULL),(131,29,'os_admin_user','{\"title\": \"OS Admin User\", \"description\": \"The name of the user with admin privileges.\", \"type\": \"string\"}','2025-10-02 11:27:49',NULL),(132,33,'img_volume_type','{\"title\": \"Image Volume Type\", \"description\": \"Specifies the volume type that should be applied during new volume creation with a image. This value is passed to Cinder when creating a new volume. Priority of volume type related parameters are 1.volume_type(via API or CLI), 2.cinder_img_volume_type, 3.default_volume_type(via cinder.conf). If not specified, volume_type or default_volume_type will be referred based on their priority.\", \"type\": \"string\"}','2025-10-02 11:27:49',NULL);
/*!40000 ALTER TABLE `metadef_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_resource_types`
--

DROP TABLE IF EXISTS `metadef_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_resource_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `protected` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_resource_types_name` (`name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_resource_types`
--

LOCK TABLES `metadef_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_resource_types` (`id`, `name`, `protected`, `created_at`, `updated_at`) VALUES (1,'OS::Cinder::Volume',1,'2025-10-02 11:27:47',NULL),(2,'OS::Glance::Image',1,'2025-10-02 11:27:47',NULL),(3,'OS::Nova::Aggregate',1,'2025-10-02 11:27:47',NULL),(4,'OS::Nova::Flavor',1,'2025-10-02 11:27:47',NULL),(5,'OS::Nova::Server',1,'2025-10-02 11:27:47',NULL),(6,'OS::Trove::Instance',1,'2025-10-02 11:27:49',NULL);
/*!40000 ALTER TABLE `metadef_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_tags`
--

DROP TABLE IF EXISTS `metadef_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_tags_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_tags_name` (`name`),
  CONSTRAINT `metadef_tags_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_tags`
--

LOCK TABLES `metadef_tags` WRITE;
/*!40000 ALTER TABLE `metadef_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadef_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_info`
--

DROP TABLE IF EXISTS `task_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_info` (
  `task_id` varchar(36) NOT NULL,
  `input` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  CONSTRAINT `task_info_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_info`
--

LOCK TABLES `task_info` WRITE;
/*!40000 ALTER TABLE `task_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` varchar(36) NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `image_id` varchar(36) DEFAULT NULL,
  `request_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_tasks_deleted` (`deleted`),
  KEY `ix_tasks_owner` (`owner`),
  KEY `ix_tasks_status` (`status`),
  KEY `ix_tasks_type` (`type`),
  KEY `ix_tasks_updated_at` (`updated_at`),
  KEY `ix_tasks_image_id` (`image_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `keystone`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `keystone` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `keystone`;

--
-- Table structure for table `access_rule`
--

DROP TABLE IF EXISTS `access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(64) DEFAULT NULL,
  `path` varchar(128) DEFAULT NULL,
  `method` varchar(16) DEFAULT NULL,
  `external_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_rule_external_id_key` (`external_id`),
  UNIQUE KEY `duplicate_access_rule_for_user_constraint` (`user_id`,`service`,`path`,`method`),
  KEY `external_id` (`external_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_rule`
--

LOCK TABLES `access_rule` WRITE;
/*!40000 ALTER TABLE `access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_token`
--

DROP TABLE IF EXISTS `access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_token` (
  `id` varchar(64) NOT NULL,
  `access_secret` varchar(64) NOT NULL,
  `authorizing_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  `role_ids` text NOT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_access_token_consumer_id` (`consumer_id`),
  KEY `ix_access_token_authorizing_user_id` (`authorizing_user_id`),
  CONSTRAINT `access_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_token`
--

LOCK TABLES `access_token` WRITE;
/*!40000 ALTER TABLE `access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('29e87d24a316'),('e25ffa003242');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential`
--

DROP TABLE IF EXISTS `application_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential` (
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `secret_hash` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `system` varchar(64) DEFAULT NULL,
  `unrestricted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `duplicate_app_cred_constraint` (`user_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential`
--

LOCK TABLES `application_credential` WRITE;
/*!40000 ALTER TABLE `application_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_access_rule`
--

DROP TABLE IF EXISTS `application_credential_access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_access_rule` (
  `application_credential_id` int(11) NOT NULL,
  `access_rule_id` int(11) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`access_rule_id`),
  KEY `access_rule_id` (`access_rule_id`),
  CONSTRAINT `application_credential_access_rule_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE,
  CONSTRAINT `application_credential_access_rule_ibfk_2` FOREIGN KEY (`access_rule_id`) REFERENCES `access_rule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_access_rule`
--

LOCK TABLES `application_credential_access_rule` WRITE;
/*!40000 ALTER TABLE `application_credential_access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_role`
--

DROP TABLE IF EXISTS `application_credential_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_role` (
  `application_credential_id` int(11) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`role_id`),
  CONSTRAINT `application_credential_role_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_role`
--

LOCK TABLES `application_credential_role` WRITE;
/*!40000 ALTER TABLE `application_credential_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assignment` (
  `type` enum('UserProject','GroupProject','UserDomain','GroupDomain') NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  KEY `ix_actor_id` (`actor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserProject','23aa3f9653ff45328f4e2b94234a971c','516d4d3bc591448c8a9ac3484e15b579','0bcf584c296a431482b6d5379e09b8fc',0),('UserProject','23aa3f9653ff45328f4e2b94234a971c','516d4d3bc591448c8a9ac3484e15b579','26f40970ddec40b2b8c1d9bd9ecfc992',0),('UserProject','2b295092eb574c8e817acce3ed20dc45','516d4d3bc591448c8a9ac3484e15b579','0bcf584c296a431482b6d5379e09b8fc',0),('UserProject','2b295092eb574c8e817acce3ed20dc45','516d4d3bc591448c8a9ac3484e15b579','6b31db46b0a146359705615bb811645e',0),('UserProject','6005b6c7177949febac5e5a925c2f87b','516d4d3bc591448c8a9ac3484e15b579','0bcf584c296a431482b6d5379e09b8fc',0),('UserProject','6005b6c7177949febac5e5a925c2f87b','516d4d3bc591448c8a9ac3484e15b579','26f40970ddec40b2b8c1d9bd9ecfc992',0),('UserProject','7331a01560904b368103c3faa65083fe','516d4d3bc591448c8a9ac3484e15b579','0bcf584c296a431482b6d5379e09b8fc',0),('UserProject','7331a01560904b368103c3faa65083fe','516d4d3bc591448c8a9ac3484e15b579','26f40970ddec40b2b8c1d9bd9ecfc992',0),('UserProject','7720aaf0b6dc41d38f1e03222fa6a93b','516d4d3bc591448c8a9ac3484e15b579','0bcf584c296a431482b6d5379e09b8fc',0),('UserProject','7720aaf0b6dc41d38f1e03222fa6a93b','516d4d3bc591448c8a9ac3484e15b579','26f40970ddec40b2b8c1d9bd9ecfc992',0),('UserProject','83bef9a3b1a9418599f781a62bce437b','516d4d3bc591448c8a9ac3484e15b579','0bcf584c296a431482b6d5379e09b8fc',0),('UserProject','83bef9a3b1a9418599f781a62bce437b','516d4d3bc591448c8a9ac3484e15b579','26f40970ddec40b2b8c1d9bd9ecfc992',0),('UserProject','c004f5628e4845ada3addf46ef5dfd33','c3a6b94d2b4945a487dafe07f533efd6','0bcf584c296a431482b6d5379e09b8fc',0),('UserProject','c004f5628e4845ada3addf46ef5dfd33','c3a6b94d2b4945a487dafe07f533efd6','60bf142325984e5f8f48387577b8120b',0),('UserProject','c004f5628e4845ada3addf46ef5dfd33','c5eb7dea6de74c6a814ab22b8222f732','0bcf584c296a431482b6d5379e09b8fc',0),('UserProject','c33b7673b7de4d34b841170e3e354243','516d4d3bc591448c8a9ac3484e15b579','0bcf584c296a431482b6d5379e09b8fc',0),('UserProject','c33b7673b7de4d34b841170e3e354243','516d4d3bc591448c8a9ac3484e15b579','26f40970ddec40b2b8c1d9bd9ecfc992',0),('UserProject','d3393d667c3c4cbfb478d6009037be7e','516d4d3bc591448c8a9ac3484e15b579','0bcf584c296a431482b6d5379e09b8fc',0),('UserProject','d3393d667c3c4cbfb478d6009037be7e','516d4d3bc591448c8a9ac3484e15b579','26f40970ddec40b2b8c1d9bd9ecfc992',0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_register`
--

DROP TABLE IF EXISTS `config_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_register` (
  `type` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_register`
--

LOCK TABLES `config_register` WRITE;
/*!40000 ALTER TABLE `config_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `config_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumer`
--

DROP TABLE IF EXISTS `consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumer` (
  `id` varchar(64) NOT NULL,
  `description` varchar(64) DEFAULT NULL,
  `secret` varchar(64) NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumer`
--

LOCK TABLES `consumer` WRITE;
/*!40000 ALTER TABLE `consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credential` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `key_hash` varchar(64) NOT NULL,
  `encrypted_blob` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint` (
  `id` varchar(64) NOT NULL,
  `legacy_endpoint_id` varchar(64) DEFAULT NULL,
  `interface` varchar(8) NOT NULL,
  `service_id` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `region_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_endpoint_region_id` (`region_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `endpoint_service_id_fkey` FOREIGN KEY (`service_id`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_endpoint_region_id` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
INSERT INTO `endpoint` (`id`, `legacy_endpoint_id`, `interface`, `service_id`, `url`, `extra`, `enabled`, `region_id`) VALUES ('04c85fefcf274eb48cd04beced886bb6',NULL,'internal','82dbd4a38a5d4c15b206908b3bb05b4f','https://keystone-internal.openstack.svc:5000','{}',1,'regionOne'),('0ec774b0f45b424ca5aefa6658c025b6',NULL,'internal','497bc121086f48ab9376ae6d15e1556b','https://glance-default-internal.openstack.svc:9292','{\"name\": \"glance\"}',1,'regionOne'),('304143b0b4574726ab3a8b3dc60e9cf2',NULL,'public','b91b6e79f838435191b69d2fd9bf09e6','https://neutron-public-openstack.apps-crc.testing','{\"name\": \"neutron\"}',1,'regionOne'),('504eef25527e4510adea21e420b812c1',NULL,'public','698d6307ba7a4e54b4253de1687d0336','https://placement-public-openstack.apps-crc.testing','{\"name\": \"placement\"}',1,'regionOne'),('52f8b28f83d140aaade4bdff9e29d8ed',NULL,'internal','698d6307ba7a4e54b4253de1687d0336','https://placement-internal.openstack.svc:8778','{\"name\": \"placement\"}',1,'regionOne'),('535f0532f9084c288fd36ae298307989',NULL,'internal','50bbc65fd85b4ef3b0ba1c6dfa263096','https://cinder-internal.openstack.svc:8776/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('5b7be0e751344f5b965640388635ee84',NULL,'internal','476eb14e28ee450598b9565f6b8e0458','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne'),('63eed55da88942d4b779b7cc4777bb45',NULL,'internal','70b233106f5d421187e4099e0ec040bd','https://nova-internal.openstack.svc:8774/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('69ca5c0e659a46ea925755f4f74b1414',NULL,'public','82dbd4a38a5d4c15b206908b3bb05b4f','https://keystone-public-openstack.apps-crc.testing','{}',1,'regionOne'),('69dee24200614536a5b30dfd77013aad',NULL,'public','70b233106f5d421187e4099e0ec040bd','https://nova-public-openstack.apps-crc.testing/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('7441fd2dbb064383aeb7ff982eacfc01',NULL,'public','497bc121086f48ab9376ae6d15e1556b','https://glance-default-public-openstack.apps-crc.testing','{\"name\": \"glance\"}',1,'regionOne'),('94f60bd8be1c4bd79aa1df9bf33a4d2e',NULL,'internal','0bc66ea7899c4ad68fa94385934b3b23','https://barbican-internal.openstack.svc:9311','{\"name\": \"barbican\"}',1,'regionOne'),('9c2ba514ac8d4e4f828d0be8a48c8b17',NULL,'public','0bc66ea7899c4ad68fa94385934b3b23','https://barbican-public-openstack.apps-crc.testing','{\"name\": \"barbican\"}',1,'regionOne'),('9d2311401be9490994f8b053701c31fd',NULL,'internal','b91b6e79f838435191b69d2fd9bf09e6','https://neutron-internal.openstack.svc:9696','{\"name\": \"neutron\"}',1,'regionOne'),('a4f35d5ed1ee400cb9086d47d5cdcafa',NULL,'public','50bbc65fd85b4ef3b0ba1c6dfa263096','https://cinder-public-openstack.apps-crc.testing/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('a65e118af94149b29fc970104862801a',NULL,'public','476eb14e28ee450598b9565f6b8e0458','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne');
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint_group`
--

DROP TABLE IF EXISTS `endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint_group` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `filters` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint_group`
--

LOCK TABLES `endpoint_group` WRITE;
/*!40000 ALTER TABLE `endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expiring_user_group_membership`
--

DROP TABLE IF EXISTS `expiring_user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expiring_user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `last_verified` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`,`idp_id`),
  KEY `group_id` (`group_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_3` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expiring_user_group_membership`
--

LOCK TABLES `expiring_user_group_membership` WRITE;
/*!40000 ALTER TABLE `expiring_user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `expiring_user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federated_user`
--

DROP TABLE IF EXISTS `federated_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federated_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `protocol_id` varchar(64) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idp_id` (`idp_id`,`protocol_id`,`unique_id`),
  KEY `federated_user_protocol_id_fkey` (`protocol_id`,`idp_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `federated_user_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_ibfk_2` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_protocol_id_fkey` FOREIGN KEY (`protocol_id`, `idp_id`) REFERENCES `federation_protocol` (`id`, `idp_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federated_user`
--

LOCK TABLES `federated_user` WRITE;
/*!40000 ALTER TABLE `federated_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `federated_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federation_protocol`
--

DROP TABLE IF EXISTS `federation_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federation_protocol` (
  `id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `mapping_id` varchar(64) NOT NULL,
  `remote_id_attribute` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`,`idp_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `federation_protocol_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federation_protocol`
--

LOCK TABLES `federation_protocol` WRITE;
/*!40000 ALTER TABLE `federation_protocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `federation_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group`
--

DROP TABLE IF EXISTS `group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group` (
  `id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_group_name_domain_id` (`domain_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group`
--

LOCK TABLES `group` WRITE;
/*!40000 ALTER TABLE `group` DISABLE KEYS */;
/*!40000 ALTER TABLE `group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `id_mapping`
--

DROP TABLE IF EXISTS `id_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `id_mapping` (
  `public_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `local_id` varchar(255) NOT NULL,
  `entity_type` enum('user','group') NOT NULL,
  PRIMARY KEY (`public_id`),
  UNIQUE KEY `domain_id` (`domain_id`,`local_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `id_mapping`
--

LOCK TABLES `id_mapping` WRITE;
/*!40000 ALTER TABLE `id_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `id_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `identity_provider`
--

DROP TABLE IF EXISTS `identity_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `identity_provider` (
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `authorization_ttl` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `identity_provider`
--

LOCK TABLES `identity_provider` WRITE;
/*!40000 ALTER TABLE `identity_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `identity_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `idp_remote_ids`
--

DROP TABLE IF EXISTS `idp_remote_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `idp_remote_ids` (
  `idp_id` varchar(64) DEFAULT NULL,
  `remote_id` varchar(255) NOT NULL,
  PRIMARY KEY (`remote_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `idp_remote_ids_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `idp_remote_ids`
--

LOCK TABLES `idp_remote_ids` WRITE;
/*!40000 ALTER TABLE `idp_remote_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `idp_remote_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `implied_role`
--

DROP TABLE IF EXISTS `implied_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `implied_role` (
  `prior_role_id` varchar(64) NOT NULL,
  `implied_role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`prior_role_id`,`implied_role_id`),
  KEY `implied_role_implied_role_id_fkey` (`implied_role_id`),
  CONSTRAINT `implied_role_implied_role_id_fkey` FOREIGN KEY (`implied_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE,
  CONSTRAINT `implied_role_prior_role_id_fkey` FOREIGN KEY (`prior_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `implied_role`
--

LOCK TABLES `implied_role` WRITE;
/*!40000 ALTER TABLE `implied_role` DISABLE KEYS */;
INSERT INTO `implied_role` (`prior_role_id`, `implied_role_id`) VALUES ('0bcf584c296a431482b6d5379e09b8fc','6b31db46b0a146359705615bb811645e'),('6b31db46b0a146359705615bb811645e','16474f5a7d274026977f1dbbd94860b8');
/*!40000 ALTER TABLE `implied_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `limit`
--

DROP TABLE IF EXISTS `limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `limit` (
  `id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `resource_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `registered_limit_id` varchar(64) DEFAULT NULL,
  `domain_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `limit_id_key` (`id`),
  KEY `registered_limit_id` (`registered_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `limit`
--

LOCK TABLES `limit` WRITE;
/*!40000 ALTER TABLE `limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_user`
--

DROP TABLE IF EXISTS `local_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `local_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `failed_auth_count` int(11) DEFAULT NULL,
  `failed_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_id` (`domain_id`,`name`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `local_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `local_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=254 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `local_user`
--

LOCK TABLES `local_user` WRITE;
/*!40000 ALTER TABLE `local_user` DISABLE KEYS */;
INSERT INTO `local_user` (`id`, `user_id`, `domain_id`, `name`, `failed_auth_count`, `failed_auth_at`) VALUES (1,'c004f5628e4845ada3addf46ef5dfd33','default','admin',0,NULL),(2,'c33b7673b7de4d34b841170e3e354243','default','nova',0,NULL),(3,'7331a01560904b368103c3faa65083fe','default','barbican',0,NULL),(4,'83bef9a3b1a9418599f781a62bce437b','default','ceilometer',0,NULL),(5,'23aa3f9653ff45328f4e2b94234a971c','default','glance',0,NULL),(6,'d3393d667c3c4cbfb478d6009037be7e','default','placement',0,NULL),(7,'7720aaf0b6dc41d38f1e03222fa6a93b','default','cinder',0,NULL),(8,'6005b6c7177949febac5e5a925c2f87b','default','neutron',0,NULL),(9,'2b295092eb574c8e817acce3ed20dc45','default','swift',0,NULL),(10,'87eb72c517024b2c80adceb6b0e96a5d','default','demo_tempestconf',0,NULL),(11,'b860d2ebdf9c4f3a88a273eb0d47f445','default','alt_demo_tempestconf',0,NULL);
/*!40000 ALTER TABLE `local_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mapping`
--

DROP TABLE IF EXISTS `mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mapping` (
  `id` varchar(64) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mapping`
--

LOCK TABLES `mapping` WRITE;
/*!40000 ALTER TABLE `mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nonlocal_user`
--

DROP TABLE IF EXISTS `nonlocal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nonlocal_user` (
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  PRIMARY KEY (`domain_id`,`name`),
  UNIQUE KEY `ixu_nonlocal_user_user_id` (`user_id`),
  KEY `nonlocal_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `nonlocal_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nonlocal_user`
--

LOCK TABLES `nonlocal_user` WRITE;
/*!40000 ALTER TABLE `nonlocal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `nonlocal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password`
--

DROP TABLE IF EXISTS `password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_user_id` int(11) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `self_service` tinyint(1) NOT NULL DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `created_at_int` bigint(20) NOT NULL DEFAULT 0,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `local_user_id` (`local_user_id`),
  CONSTRAINT `password_ibfk_1` FOREIGN KEY (`local_user_id`) REFERENCES `local_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=254 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password`
--

LOCK TABLES `password` WRITE;
/*!40000 ALTER TABLE `password` DISABLE KEYS */;
INSERT INTO `password` (`id`, `local_user_id`, `expires_at`, `self_service`, `password_hash`, `created_at_int`, `expires_at_int`, `created_at`) VALUES (1,1,NULL,0,'$2b$12$ngmUu4LSpoqw5tPSu.pKjuGGkN9ko7EBu/SO0dWzwj/cajWTHp6q.',1759404482729183,NULL,'2025-10-02 11:28:02'),(2,2,NULL,0,'$2b$12$P1GqS4GUlzt9TavG2xetWusVA9SIcX7d8LbDLmJCiwwc5dG1zLL/q',1759404586862122,NULL,'2025-10-02 11:29:46'),(3,3,NULL,0,'$2b$12$isU1ZqvkGzhkBBz.wjeD2.wMXbhsFylxBs6Qn42/BK/W8Q3ZjESJ6',1759404595282471,NULL,'2025-10-02 11:29:55'),(4,4,NULL,0,'$2b$12$DuP9P20CRqguM5DSm1.sNebVteQTwfDCYuxysbG0brZS4wfF4Zmam',1759404600051311,NULL,'2025-10-02 11:30:00'),(5,5,NULL,0,'$2b$12$Ys9OxiENlcoeM5YZ5QonKOF6PLa2Kmd9C4fPqJzWUQzcw4Obphtlq',1759404608730443,NULL,'2025-10-02 11:30:08'),(6,6,NULL,0,'$2b$12$J4Xz9YMkKL69jf1bV6mww.qX1BriEb4SUQFdNfKDIWAfAuJYQXkeK',1759404619593498,NULL,'2025-10-02 11:30:19'),(7,7,NULL,0,'$2b$12$Qs.jE5q8u7FXE7dlKXy/rup3mtmDfQDpRy93i/vsHQTRMMilo90Gy',1759404635150194,NULL,'2025-10-02 11:30:35'),(8,8,NULL,0,'$2b$12$1.CtAWWVFC1AOX9ZTIJz9.GQ4rVsMhiWlx96avrBPpZVWzmN/d0Tm',1759404659932368,NULL,'2025-10-02 11:30:59'),(9,9,NULL,0,'$2b$12$EVZ0y70VaLjPFneMU8ovrOt0CfhyDVWigexKeUUzVs.cdg2eZLMA2',1759405649959529,NULL,'2025-10-02 11:47:29'),(10,10,NULL,0,'$2b$12$.7gXrY.x9Y2KzO1X/X43GuL7G/ZQoGt1oyIv9EJc4DruzG50.0yKS',1759406918994147,NULL,'2025-10-02 12:08:38'),(11,11,NULL,0,'$2b$12$0riH78Jz2yNM7LwD3rjxveECjifTrqu3WcPQ1NOYA71VgK8mRbW9q',1759406919656573,NULL,'2025-10-02 12:08:39');
/*!40000 ALTER TABLE `password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `blob` text NOT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_association`
--

DROP TABLE IF EXISTS `policy_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy_association` (
  `id` varchar(64) NOT NULL,
  `policy_id` varchar(64) NOT NULL,
  `endpoint_id` varchar(64) DEFAULT NULL,
  `service_id` varchar(64) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `endpoint_id` (`endpoint_id`,`service_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_association`
--

LOCK TABLES `policy_association` WRITE;
/*!40000 ALTER TABLE `policy_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project` (
  `id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL,
  `is_domain` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_project_name_domain_id` (`domain_id`,`name`),
  KEY `project_parent_id_fkey` (`parent_id`),
  CONSTRAINT `project_domain_id_fkey` FOREIGN KEY (`domain_id`) REFERENCES `project` (`id`),
  CONSTRAINT `project_parent_id_fkey` FOREIGN KEY (`parent_id`) REFERENCES `project` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
INSERT INTO `project` (`id`, `name`, `extra`, `description`, `enabled`, `domain_id`, `parent_id`, `is_domain`) VALUES ('516d4d3bc591448c8a9ac3484e15b579','service','{}','service',1,'default','default',0),('7a4d4ad4412d4e9380d1f97190bf5cde','alt_demo','{}','Project for Tempest alt_demo_tempestconf user',1,'default','default',0),('<<keystone.domain.root>>','<<keystone.domain.root>>','{}','',0,'<<keystone.domain.root>>',NULL,1),('c3a6b94d2b4945a487dafe07f533efd6','admin','{}','Bootstrap project for initializing the cloud.',1,'default','default',0),('c5eb7dea6de74c6a814ab22b8222f732','demo','{}','Project for Tempest demo_tempestconf user',1,'default','default',0),('default','Default','{}','The default domain',1,'<<keystone.domain.root>>',NULL,1);
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint`
--

DROP TABLE IF EXISTS `project_endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint` (
  `endpoint_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint`
--

LOCK TABLES `project_endpoint` WRITE;
/*!40000 ALTER TABLE `project_endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint_group`
--

DROP TABLE IF EXISTS `project_endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint_group` (
  `endpoint_group_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_group_id`,`project_id`),
  CONSTRAINT `project_endpoint_group_ibfk_1` FOREIGN KEY (`endpoint_group_id`) REFERENCES `endpoint_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint_group`
--

LOCK TABLES `project_endpoint_group` WRITE;
/*!40000 ALTER TABLE `project_endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_option`
--

DROP TABLE IF EXISTS `project_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_option` (
  `project_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`project_id`,`option_id`),
  CONSTRAINT `project_option_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_option`
--

LOCK TABLES `project_option` WRITE;
/*!40000 ALTER TABLE `project_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_tag`
--

DROP TABLE IF EXISTS `project_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_tag` (
  `project_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`project_id`,`name`),
  UNIQUE KEY `project_id` (`project_id`,`name`),
  CONSTRAINT `project_tag_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_tag`
--

LOCK TABLES `project_tag` WRITE;
/*!40000 ALTER TABLE `project_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `parent_region_id` varchar(255) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` (`id`, `description`, `parent_region_id`, `extra`) VALUES ('regionOne','',NULL,'{}');
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registered_limit`
--

DROP TABLE IF EXISTS `registered_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `registered_limit` (
  `id` varchar(64) NOT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `default_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `registered_limit_id_key` (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `registered_limit`
--

LOCK TABLES `registered_limit` WRITE;
/*!40000 ALTER TABLE `registered_limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `registered_limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_token`
--

DROP TABLE IF EXISTS `request_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_token` (
  `id` varchar(64) NOT NULL,
  `request_secret` varchar(64) NOT NULL,
  `verifier` varchar(64) DEFAULT NULL,
  `authorizing_user_id` varchar(64) DEFAULT NULL,
  `requested_project_id` varchar(64) NOT NULL,
  `role_ids` text DEFAULT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_request_token_consumer_id` (`consumer_id`),
  CONSTRAINT `request_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_token`
--

LOCK TABLES `request_token` WRITE;
/*!40000 ALTER TABLE `request_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revocation_event`
--

DROP TABLE IF EXISTS `revocation_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revocation_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` varchar(64) DEFAULT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  `role_id` varchar(64) DEFAULT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `consumer_id` varchar(64) DEFAULT NULL,
  `access_token_id` varchar(64) DEFAULT NULL,
  `issued_before` datetime NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `revoked_at` datetime NOT NULL,
  `audit_id` varchar(32) DEFAULT NULL,
  `audit_chain_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_revocation_event_new_revoked_at` (`revoked_at`),
  KEY `ix_revocation_event_issued_before` (`issued_before`),
  KEY `ix_revocation_event_project_id_issued_before` (`project_id`,`issued_before`),
  KEY `ix_revocation_event_user_id_issued_before` (`user_id`,`issued_before`),
  KEY `ix_revocation_event_audit_id_issued_before` (`audit_id`,`issued_before`)
) ENGINE=InnoDB AUTO_INCREMENT=482 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revocation_event`
--

LOCK TABLES `revocation_event` WRITE;
/*!40000 ALTER TABLE `revocation_event` DISABLE KEYS */;
INSERT INTO `revocation_event` (`id`, `domain_id`, `project_id`, `user_id`, `role_id`, `trust_id`, `consumer_id`, `access_token_id`, `issued_before`, `expires_at`, `revoked_at`, `audit_id`, `audit_chain_id`) VALUES (1,NULL,NULL,'954ae7e31de64692a511df15acf2b31d',NULL,NULL,NULL,NULL,'2025-10-02 12:09:14',NULL,'2025-10-02 12:09:14',NULL,NULL),(2,NULL,NULL,'7b3d212a37914639922895099cd1fdf5',NULL,NULL,NULL,NULL,'2025-10-02 12:09:14',NULL,'2025-10-02 12:09:14',NULL,NULL),(3,NULL,'e2f8da6fc3594925a0991416ac03fdc8',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:09:17',NULL,'2025-10-02 12:09:17',NULL,NULL),(4,NULL,'a2115020ddc0413e8b40b01d2fff374b',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:09:18',NULL,'2025-10-02 12:09:18',NULL,NULL),(5,NULL,NULL,'9f0283cee87648d98098128bc3ff61e3',NULL,NULL,NULL,NULL,'2025-10-02 12:09:22',NULL,'2025-10-02 12:09:22',NULL,NULL),(6,NULL,NULL,'bfd25e193c0c4dc88eef721628629e9d',NULL,NULL,NULL,NULL,'2025-10-02 12:09:22',NULL,'2025-10-02 12:09:22',NULL,NULL),(7,NULL,'0ed23d7083e443eb8cd50b146b529de6',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:09:24',NULL,'2025-10-02 12:09:24',NULL,NULL),(8,NULL,'90e3401a6de949b5931ff45aa385b6d6',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:09:25',NULL,'2025-10-02 12:09:25',NULL,NULL),(9,NULL,NULL,'be6a55de763e4af8a16c65d7d68cb1a2',NULL,NULL,NULL,NULL,'2025-10-02 12:09:28',NULL,'2025-10-02 12:09:28',NULL,NULL),(10,NULL,NULL,'b5445d20475a40eb88d48f733337241c',NULL,NULL,NULL,NULL,'2025-10-02 12:09:28',NULL,'2025-10-02 12:09:28',NULL,NULL),(11,NULL,'c669b5566eee4f068cdedca12526ce58',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:09:30',NULL,'2025-10-02 12:09:30',NULL,NULL),(12,NULL,'bf7473e25a9642e6b70f7d644910cd92',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:09:30',NULL,'2025-10-02 12:09:30',NULL,NULL),(13,NULL,NULL,'1a4b6867c5ae48a592facf7ab066c0e0',NULL,NULL,NULL,NULL,'2025-10-02 12:09:43',NULL,'2025-10-02 12:09:43',NULL,NULL),(14,NULL,NULL,'9c399b2a35b94f2a88a169ad5a522a44',NULL,NULL,NULL,NULL,'2025-10-02 12:09:43',NULL,'2025-10-02 12:09:43',NULL,NULL),(15,NULL,NULL,'96b01eb551a443288eef65651a5b23a7',NULL,NULL,NULL,NULL,'2025-10-02 12:09:44',NULL,'2025-10-02 12:09:44',NULL,NULL),(16,NULL,'648c6931824441c2b6706240892cb2fe',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:09:49',NULL,'2025-10-02 12:09:49',NULL,NULL),(17,NULL,'d3231bb7a489493099dfead26b903b3f',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:09:52',NULL,'2025-10-02 12:09:52',NULL,NULL),(18,NULL,'50209bac48c541a9aeaeb76cd9082a7a',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:09:56',NULL,'2025-10-02 12:09:56',NULL,NULL),(19,NULL,NULL,'270f85240162479392200ccc48fd7aa6',NULL,NULL,NULL,NULL,'2025-10-02 12:10:04',NULL,'2025-10-02 12:10:04',NULL,NULL),(20,NULL,NULL,'06a83cf8435a421ebaec0537c2018999',NULL,NULL,NULL,NULL,'2025-10-02 12:10:04',NULL,'2025-10-02 12:10:04',NULL,NULL),(21,NULL,'484d6cf8b66d4f43bd8ac924ac10aebb',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:10:07',NULL,'2025-10-02 12:10:07',NULL,NULL),(22,NULL,'bd22a5fe12ab4311a180524b82cb96c3',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:10:09',NULL,'2025-10-02 12:10:09',NULL,NULL),(23,NULL,NULL,'254822d2c3d946f4859405871a2e8741',NULL,NULL,NULL,NULL,'2025-10-02 12:10:16',NULL,'2025-10-02 12:10:16',NULL,NULL),(24,NULL,NULL,'d57c999e1f144f3f9788665fafaad57f',NULL,NULL,NULL,NULL,'2025-10-02 12:10:16',NULL,'2025-10-02 12:10:16',NULL,NULL),(25,NULL,'9a6307fe259b47c3a91f850d6f2cc9cd',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:10:18',NULL,'2025-10-02 12:10:18',NULL,NULL),(26,NULL,'49dec97d513247b1853a1ff1a3c9ba0a',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:10:20',NULL,'2025-10-02 12:10:20',NULL,NULL),(27,NULL,NULL,'bd37f6f0c9404e48b6ed57ae1a98b7e5',NULL,NULL,NULL,NULL,'2025-10-02 12:10:24',NULL,'2025-10-02 12:10:24',NULL,NULL),(28,NULL,NULL,'aed5fa049aec4b3594beb1b01060a2f2',NULL,NULL,NULL,NULL,'2025-10-02 12:10:25',NULL,'2025-10-02 12:10:25',NULL,NULL),(29,NULL,'42526ab6b1604579ae9ddd5edafe1612',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:10:28',NULL,'2025-10-02 12:10:28',NULL,NULL),(30,NULL,'ffdf989c0eb845ba9ed9dda9e9e34345',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:10:29',NULL,'2025-10-02 12:10:29',NULL,NULL),(31,NULL,NULL,'d54d126a712b4d918646d5593b1ed0ab',NULL,NULL,NULL,NULL,'2025-10-02 12:10:59',NULL,'2025-10-02 12:10:59',NULL,NULL),(32,NULL,NULL,'bca058e95a814c89af1fcf4b42ef7fb6',NULL,NULL,NULL,NULL,'2025-10-02 12:10:59',NULL,'2025-10-02 12:10:59',NULL,NULL),(33,NULL,'8049c7d6521b4740b50848c0a6055826',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:11:02',NULL,'2025-10-02 12:11:02',NULL,NULL),(34,NULL,'d47a89b2ac054bcabddb58a69c31d298',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:11:03',NULL,'2025-10-02 12:11:03',NULL,NULL),(35,NULL,NULL,'57c27a54dfc7489eaa25cab0d0495c29',NULL,NULL,NULL,NULL,'2025-10-02 12:11:13',NULL,'2025-10-02 12:11:13',NULL,NULL),(36,NULL,NULL,'b81237ef015d48dfa022b6761d706e36',NULL,NULL,NULL,NULL,'2025-10-02 12:11:13',NULL,'2025-10-02 12:11:13',NULL,NULL),(37,NULL,'00baca98289d4bfab464218dcd6e0259',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:11:14',NULL,'2025-10-02 12:11:14',NULL,NULL),(38,NULL,'fa15236c63df4c43bf19989029fcda0f',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:11:14',NULL,'2025-10-02 12:11:14',NULL,NULL),(39,NULL,NULL,'8ed9f9c5c23d404c93ac6afacb7521ef',NULL,NULL,NULL,NULL,'2025-10-02 12:11:18',NULL,'2025-10-02 12:11:18',NULL,NULL),(40,NULL,NULL,'dbd222e34f6e43e2ba25c1a129b36cb7',NULL,NULL,NULL,NULL,'2025-10-02 12:11:18',NULL,'2025-10-02 12:11:18',NULL,NULL),(41,NULL,'c3d2af05d6544468aeb0f6543fa7dbfd',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:11:20',NULL,'2025-10-02 12:11:20',NULL,NULL),(42,NULL,'e0820abc2dc5483b9c67711c666582cd',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:11:21',NULL,'2025-10-02 12:11:21',NULL,NULL),(43,NULL,NULL,'531ddb9812364f7b9743bd02a8ed797f',NULL,NULL,NULL,NULL,'2025-10-02 12:11:41',NULL,'2025-10-02 12:11:41',NULL,NULL),(44,NULL,NULL,'182d71e9deb54ecd9d3b8752d5e726c2',NULL,NULL,NULL,NULL,'2025-10-02 12:11:41',NULL,'2025-10-02 12:11:41',NULL,NULL),(45,NULL,'3fa76f4479054572a4694dd25f99a127',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:11:43',NULL,'2025-10-02 12:11:43',NULL,NULL),(46,NULL,'2c66662015f74444b15ea4b3d8644714',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:11:45',NULL,'2025-10-02 12:11:45',NULL,NULL),(47,NULL,NULL,'6893393a7bdf4a4f8cdbf2222facdb94',NULL,NULL,NULL,NULL,'2025-10-02 12:11:50',NULL,'2025-10-02 12:11:50',NULL,NULL),(48,NULL,NULL,'12f7cff7f94042bb8e5e96e919cc5a49',NULL,NULL,NULL,NULL,'2025-10-02 12:11:50',NULL,'2025-10-02 12:11:50',NULL,NULL),(49,NULL,NULL,'40989194be64450c86bad57eee45a7b5',NULL,NULL,NULL,NULL,'2025-10-02 12:11:51',NULL,'2025-10-02 12:11:51',NULL,NULL),(50,NULL,NULL,'3cd040a5b7f04e9c9dca681a59e324f6',NULL,NULL,NULL,NULL,'2025-10-02 12:11:51',NULL,'2025-10-02 12:11:51',NULL,NULL),(51,NULL,NULL,'da379ea0e8494b4da47c8d2ccb79c0a8',NULL,NULL,NULL,NULL,'2025-10-02 12:11:52',NULL,'2025-10-02 12:11:52',NULL,NULL),(52,NULL,'dc9308c5cad84e47954e48b4e5204d75',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:11:53',NULL,'2025-10-02 12:11:53',NULL,NULL),(53,NULL,'3c05c3b0c35e4dab854814086f385daa',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:11:54',NULL,'2025-10-02 12:11:54',NULL,NULL),(54,NULL,'fc53700185164ac1b7e78cb5b064a7b3',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:11:55',NULL,'2025-10-02 12:11:55',NULL,NULL),(55,NULL,'76479a377f604fd9944c633349f93469',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:11:55',NULL,'2025-10-02 12:11:55',NULL,NULL),(56,NULL,'a5b7ebf61d0a43d39a837b14d0530c61',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:11:56',NULL,'2025-10-02 12:11:56',NULL,NULL),(57,NULL,NULL,'2cdfea5c8e074c59b963b1fba6b35e1f',NULL,NULL,NULL,NULL,'2025-10-02 12:11:58',NULL,'2025-10-02 12:11:58',NULL,NULL),(58,NULL,NULL,'ce4af777c4dc49f7af0174a5a204b76c',NULL,NULL,NULL,NULL,'2025-10-02 12:11:58',NULL,'2025-10-02 12:11:58',NULL,NULL),(59,NULL,NULL,'80d19315432b41468084b391f1f293f9',NULL,NULL,NULL,NULL,'2025-10-02 12:11:59',NULL,'2025-10-02 12:11:59',NULL,NULL),(60,NULL,NULL,'b95e9ea36b0d4fa791f97663fa947c5f',NULL,NULL,NULL,NULL,'2025-10-02 12:11:59',NULL,'2025-10-02 12:11:59',NULL,NULL),(61,NULL,'14444ba992464a08be0b7dc7a5dd00c2',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:12:00',NULL,'2025-10-02 12:12:00',NULL,NULL),(62,NULL,'e76709d3befb4e8a8ffdf0b34af05d5d',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:12:01',NULL,'2025-10-02 12:12:01',NULL,NULL),(63,NULL,'09b3d7ab67384f858ff14c035de7e86c',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:12:02',NULL,'2025-10-02 12:12:02',NULL,NULL),(64,NULL,NULL,'c8bd85983bc944cf8bd9cf8e7d667252',NULL,NULL,NULL,NULL,'2025-10-02 12:12:02',NULL,'2025-10-02 12:12:02',NULL,NULL),(65,NULL,NULL,'827e8e2f4fde496bbcf1188b879833ca',NULL,NULL,NULL,NULL,'2025-10-02 12:12:02',NULL,'2025-10-02 12:12:02',NULL,NULL),(66,NULL,'81f8275895e448b09d3136ee23489e00',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:12:03',NULL,'2025-10-02 12:12:03',NULL,NULL),(67,NULL,'3614849a835746579df38d46144ede49',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:12:04',NULL,'2025-10-02 12:12:04',NULL,NULL),(68,NULL,'95a6eef622fb4fa7a195e870ac8dd1c7',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:12:05',NULL,'2025-10-02 12:12:05',NULL,NULL),(69,NULL,NULL,'cdd79684968446c69b39322ae21e1844',NULL,NULL,NULL,NULL,'2025-10-02 12:12:08',NULL,'2025-10-02 12:12:08',NULL,NULL),(70,NULL,NULL,'1c564b412972470abdd4de0984130adc',NULL,NULL,NULL,NULL,'2025-10-02 12:12:08',NULL,'2025-10-02 12:12:08',NULL,NULL),(71,NULL,NULL,'afabe31b2dae4f4893a3618bb90226ac',NULL,NULL,NULL,NULL,'2025-10-02 12:12:09',NULL,'2025-10-02 12:12:09',NULL,NULL),(72,NULL,NULL,'cff50b78bc4847698b094f151b77b05c',NULL,NULL,NULL,NULL,'2025-10-02 12:12:10',NULL,'2025-10-02 12:12:10',NULL,NULL),(73,NULL,'8a8600c15a774cb9bdd0e048909d7d7e',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:12:10',NULL,'2025-10-02 12:12:10',NULL,NULL),(74,NULL,'c3af5dfaea1d4d7a9da842362978de12',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:12:11',NULL,'2025-10-02 12:12:11',NULL,NULL),(75,NULL,NULL,'0ca8dfd65fe7482c88daeec3ad32696e',NULL,NULL,NULL,NULL,'2025-10-02 12:12:11',NULL,'2025-10-02 12:12:11',NULL,NULL),(76,NULL,NULL,'6f58fa22fccc406fb861fc4bd173a33e',NULL,NULL,NULL,NULL,'2025-10-02 12:12:12',NULL,'2025-10-02 12:12:12',NULL,NULL),(77,NULL,'96f2583d1ebd49c58d42e7b597923719',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:12:12',NULL,'2025-10-02 12:12:12',NULL,NULL),(78,NULL,'8c5eb614001e4e09836211fce4ed1493',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:12:13',NULL,'2025-10-02 12:12:13',NULL,NULL),(79,NULL,'af95a300d00343e6be99f7cc0ce6fe4d',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:12:13',NULL,'2025-10-02 12:12:13',NULL,NULL),(80,NULL,'2c35fe90b1664ecebf5d9f6611a03706',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:12:14',NULL,'2025-10-02 12:12:14',NULL,NULL),(81,NULL,NULL,'248fea8daa6740fd85be732bf64b98dc',NULL,NULL,NULL,NULL,'2025-10-02 12:12:17',NULL,'2025-10-02 12:12:17',NULL,NULL),(82,NULL,NULL,'59440d881e1641a2bd8fd149ad23ff7c',NULL,NULL,NULL,NULL,'2025-10-02 12:12:17',NULL,'2025-10-02 12:12:17',NULL,NULL),(83,NULL,NULL,'6fbff05c472543adafd3eaf72025ef1e',NULL,NULL,NULL,NULL,'2025-10-02 12:12:18',NULL,'2025-10-02 12:12:18',NULL,NULL),(84,NULL,NULL,'22469badf1ed4c7dae1aa77146f89f61',NULL,NULL,NULL,NULL,'2025-10-02 12:12:18',NULL,'2025-10-02 12:12:18',NULL,NULL),(85,NULL,'5be3bdb34a624343854d2a615c63a249',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:12:19',NULL,'2025-10-02 12:12:19',NULL,NULL),(86,NULL,'1363627f38d0414b98e4fa4a4442a5c3',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:12:20',NULL,'2025-10-02 12:12:20',NULL,NULL),(87,NULL,'216b56b880c947b88d3ec77cc12585e9',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:12:21',NULL,'2025-10-02 12:12:21',NULL,NULL),(88,NULL,NULL,'dd2584f78f8c4eb88ded1e519a80fcd3',NULL,NULL,NULL,NULL,'2025-10-02 12:12:21',NULL,'2025-10-02 12:12:21',NULL,NULL),(89,NULL,NULL,'2c69add26eee4b71b1767da8059bf1c5',NULL,NULL,NULL,NULL,'2025-10-02 12:12:21',NULL,'2025-10-02 12:12:21',NULL,NULL),(90,NULL,'5c2eb604d0a64295897a17f40a6cd851',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:12:22',NULL,'2025-10-02 12:12:22',NULL,NULL),(91,NULL,'f4b0e7bf868448f18c106229d22def77',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:12:23',NULL,'2025-10-02 12:12:23',NULL,NULL),(92,NULL,'af3189ae6f3a44799a07599aa3fc3ed8',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:12:24',NULL,'2025-10-02 12:12:24',NULL,NULL),(93,NULL,NULL,'59e4926e6a8749a8a393630a15b70607',NULL,NULL,NULL,NULL,'2025-10-02 12:12:25',NULL,'2025-10-02 12:12:25',NULL,NULL),(94,NULL,'7f66f0e949a840d789f5980d83c5f225',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:12:26',NULL,'2025-10-02 12:12:26',NULL,NULL),(95,NULL,NULL,'8c6150477b804d47a4ef0c8abed65af5',NULL,NULL,NULL,NULL,'2025-10-02 12:12:28',NULL,'2025-10-02 12:12:28',NULL,NULL),(96,NULL,NULL,'535b3e5d6b224af78aed4519c83964a8',NULL,NULL,NULL,NULL,'2025-10-02 12:12:29',NULL,'2025-10-02 12:12:29',NULL,NULL),(97,NULL,NULL,'48032bafde0c4d7f92af957f0fd8b9fa',NULL,NULL,NULL,NULL,'2025-10-02 12:12:30',NULL,'2025-10-02 12:12:30',NULL,NULL),(98,NULL,NULL,'5137729fefeb495f9f2810eabd82679e',NULL,NULL,NULL,NULL,'2025-10-02 12:12:30',NULL,'2025-10-02 12:12:30',NULL,NULL),(99,NULL,'d005f04e730b425799682acf27eb341e',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:12:32',NULL,'2025-10-02 12:12:32',NULL,NULL),(100,NULL,'edd0c9a7e8ba403696563cf59024b1c3',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:12:33',NULL,'2025-10-02 12:12:33',NULL,NULL),(101,NULL,'ebe9f8a4dd6a42b7b02170c6729ffb46',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:12:34',NULL,'2025-10-02 12:12:34',NULL,NULL),(102,NULL,'a0d3cc10fc954fd39f219858da03e480',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:12:35',NULL,'2025-10-02 12:12:35',NULL,NULL),(103,NULL,NULL,'c56c9fc25e244e1c8b3d5cd397322833',NULL,NULL,NULL,NULL,'2025-10-02 12:12:43',NULL,'2025-10-02 12:12:43',NULL,NULL),(104,NULL,NULL,'85fb99c596514cd3b967186e1f999ace',NULL,NULL,NULL,NULL,'2025-10-02 12:12:44',NULL,'2025-10-02 12:12:44',NULL,NULL),(105,NULL,'a05efde5af6d48b3958e30138059a485',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:12:45',NULL,'2025-10-02 12:12:45',NULL,NULL),(106,NULL,'538ce574594a42adac2748ca81aa7645',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:12:47',NULL,'2025-10-02 12:12:47',NULL,NULL),(107,NULL,NULL,'bedb1ccc29924d97b93220b5b85ee63f',NULL,NULL,NULL,NULL,'2025-10-02 12:12:53',NULL,'2025-10-02 12:12:53',NULL,NULL),(108,NULL,NULL,'073d498dc402440b9339c3ea49e9e93a',NULL,NULL,NULL,NULL,'2025-10-02 12:12:53',NULL,'2025-10-02 12:12:53',NULL,NULL),(109,NULL,'62b91b5cef8b465ba22d68a09708c564',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:12:55',NULL,'2025-10-02 12:12:55',NULL,NULL),(110,NULL,'9d24785c6cd742949fdc3f6069aaa1ae',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:12:57',NULL,'2025-10-02 12:12:57',NULL,NULL),(111,NULL,NULL,'9e4fb8c08fd7480ea97de3721236a481',NULL,NULL,NULL,NULL,'2025-10-02 12:13:02',NULL,'2025-10-02 12:13:02',NULL,NULL),(112,NULL,NULL,'8153b3e00d0b451f90664278a2d2bf88',NULL,NULL,NULL,NULL,'2025-10-02 12:13:02',NULL,'2025-10-02 12:13:02',NULL,NULL),(113,NULL,'7aa3898a9d4b490d95d0c8bbd7e4127c',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:13:03',NULL,'2025-10-02 12:13:03',NULL,NULL),(114,NULL,'d5d17faa65e840feb297551d7e10b241',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:13:04',NULL,'2025-10-02 12:13:04',NULL,NULL),(115,NULL,NULL,'1f77ac1f7dbe4a04950dbe90637d1eb9',NULL,NULL,NULL,NULL,'2025-10-02 12:13:08',NULL,'2025-10-02 12:13:08',NULL,NULL),(116,NULL,NULL,'6d0b65b3f28b47a8880f172665c6521a',NULL,NULL,NULL,NULL,'2025-10-02 12:13:08',NULL,'2025-10-02 12:13:08',NULL,NULL),(117,NULL,'ea8dda38ade34c5ea280df9c71461b15',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:13:09',NULL,'2025-10-02 12:13:09',NULL,NULL),(118,NULL,'c52910383279404ea2ef16bf545067e1',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:13:10',NULL,'2025-10-02 12:13:10',NULL,NULL),(119,NULL,NULL,'999a68f69e0048c5b088c7d0d9176c34',NULL,NULL,NULL,NULL,'2025-10-02 12:13:11',NULL,'2025-10-02 12:13:11',NULL,NULL),(120,NULL,'dcca1ff947014dd6a08a5f21be812c63',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:13:12',NULL,'2025-10-02 12:13:12',NULL,NULL),(121,NULL,NULL,'332b271e7d344388a97ceddff5ab3e6c',NULL,NULL,NULL,NULL,'2025-10-02 12:13:46',NULL,'2025-10-02 12:13:46',NULL,NULL),(122,NULL,'88fc23a5eeb6404ab728563a204e8ba6',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:13:49',NULL,'2025-10-02 12:13:49',NULL,NULL),(123,NULL,NULL,'9a2b9bbd9ba44b22b1a2f6100cbdd67a',NULL,NULL,NULL,NULL,'2025-10-02 12:13:52',NULL,'2025-10-02 12:13:52',NULL,NULL),(124,NULL,'bd9fb8019bc346f299235ac732f1c428',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:13:54',NULL,'2025-10-02 12:13:54',NULL,NULL),(125,NULL,NULL,'8da43dcf236343bfa92dff74df42cb79',NULL,NULL,NULL,NULL,'2025-10-02 12:13:55',NULL,'2025-10-02 12:13:55',NULL,NULL),(126,NULL,NULL,'43f721199ae646a59ae360e489d46a57',NULL,NULL,NULL,NULL,'2025-10-02 12:13:56',NULL,'2025-10-02 12:13:56',NULL,NULL),(127,NULL,'6933706e32a14e3c92fdf8c1df4f90b2',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:13:58',NULL,'2025-10-02 12:13:58',NULL,NULL),(128,NULL,'40ee8077bbf945118456a5e1cecabbda',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:13:59',NULL,'2025-10-02 12:13:59',NULL,NULL),(129,NULL,NULL,'b3b07fd71254446ca25c68ff383cbfaf',NULL,NULL,NULL,NULL,'2025-10-02 12:14:54',NULL,'2025-10-02 12:14:54',NULL,NULL),(130,NULL,'bbb79918378c4b758373ad37cb271097',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:14:57',NULL,'2025-10-02 12:14:57',NULL,NULL),(131,NULL,NULL,'7a80f833255046e7b62d34c1c6066073',NULL,NULL,NULL,NULL,'2025-10-02 12:15:28',NULL,'2025-10-02 12:15:28',NULL,NULL),(132,NULL,NULL,'5b3865f4b6ad4429aba4a9cddf01251b',NULL,NULL,NULL,NULL,'2025-10-02 12:15:29',NULL,'2025-10-02 12:15:29',NULL,NULL),(133,NULL,'39ca581fbb054c959d26096ca39fef05',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:15:29',NULL,'2025-10-02 12:15:29',NULL,NULL),(134,NULL,'1584a97de5e2431e8ad556fdba1d6d48',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:15:30',NULL,'2025-10-02 12:15:30',NULL,NULL),(135,NULL,NULL,'d29391679bd0482aada18c987e4c11ca',NULL,NULL,NULL,NULL,'2025-10-02 12:15:47',NULL,'2025-10-02 12:15:47',NULL,NULL),(136,NULL,NULL,'2d0b44e1ae884cd9b6f5b34c4b20961b',NULL,NULL,NULL,NULL,'2025-10-02 12:15:48',NULL,'2025-10-02 12:15:48',NULL,NULL),(137,NULL,'1e2a07f96ebf489f9ca155f20c045c56',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:15:49',NULL,'2025-10-02 12:15:49',NULL,NULL),(138,NULL,'4db2957ac1b546178a9f2c0f24807e5b',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:15:50',NULL,'2025-10-02 12:15:50',NULL,NULL),(139,NULL,NULL,'79b88925d1704f5c9b3d2114c1a9ae4f',NULL,NULL,NULL,NULL,'2025-10-02 12:16:21',NULL,'2025-10-02 12:16:21',NULL,NULL),(140,NULL,'d92e60d304e64805972937813fc99606',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:16:24',NULL,'2025-10-02 12:16:24',NULL,NULL),(141,NULL,NULL,'27279919e67c49e1a04b6eec249ecc87',NULL,NULL,NULL,NULL,'2025-10-02 12:16:43',NULL,'2025-10-02 12:16:43',NULL,NULL),(142,NULL,NULL,'47a93e27ad394859aad7fc923a6c35fa',NULL,NULL,NULL,NULL,'2025-10-02 12:16:44',NULL,'2025-10-02 12:16:44',NULL,NULL),(143,NULL,'e892b67e06104b40a9f05e9acb365486',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:16:46',NULL,'2025-10-02 12:16:46',NULL,NULL),(144,NULL,'a5ac6058475f4875b46ae8f3c4ff33e8',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:16:48',NULL,'2025-10-02 12:16:48',NULL,NULL),(145,NULL,NULL,'74c29d6c85bd4de3870cb76d91679395',NULL,NULL,NULL,NULL,'2025-10-02 12:16:52',NULL,'2025-10-02 12:16:52',NULL,NULL),(146,NULL,NULL,'df95a3c066b3441fae774cdeaffeddff',NULL,NULL,NULL,NULL,'2025-10-02 12:16:52',NULL,'2025-10-02 12:16:52',NULL,NULL),(147,NULL,'766fa4d3b1d3499d9a00dee4064b5df2',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:16:53',NULL,'2025-10-02 12:16:53',NULL,NULL),(148,NULL,'c3f3987859174604a0d5fa28e6547f1a',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:16:54',NULL,'2025-10-02 12:16:54',NULL,NULL),(149,NULL,NULL,'00162d077e4648d4a5eeb4d3248ea339',NULL,NULL,NULL,NULL,'2025-10-02 12:17:04',NULL,'2025-10-02 12:17:04',NULL,NULL),(150,NULL,'4fd7f90178d8409489c45f125558693e',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:17:05',NULL,'2025-10-02 12:17:05',NULL,NULL),(151,NULL,NULL,'246773fb0dea4f7ca10367bb5e91faf3',NULL,NULL,NULL,NULL,'2025-10-02 12:17:34',NULL,'2025-10-02 12:17:34',NULL,NULL),(152,NULL,'e49351c2a269412894787487ec10636b',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:17:34',NULL,'2025-10-02 12:17:34',NULL,NULL),(153,NULL,NULL,'ac1b39d94ed94e2490ad953afb3c225f',NULL,NULL,NULL,NULL,'2025-10-02 12:17:38',NULL,'2025-10-02 12:17:38',NULL,NULL),(154,NULL,NULL,'b48bf9f19611404983b14ed5245fd047',NULL,NULL,NULL,NULL,'2025-10-02 12:17:38',NULL,'2025-10-02 12:17:38',NULL,NULL),(155,NULL,'7162d8da66f743e9bb917c9bbfc1e2b3',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:17:39',NULL,'2025-10-02 12:17:39',NULL,NULL),(156,NULL,'3d306048f2854052ba5317253b834aa7',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:17:40',NULL,'2025-10-02 12:17:40',NULL,NULL),(157,NULL,NULL,'45c7d01ace9042a485bed36c8bee85a9',NULL,NULL,NULL,NULL,'2025-10-02 12:17:44',NULL,'2025-10-02 12:17:44',NULL,NULL),(158,NULL,NULL,'8a595899b2b14b90902ddae11cffe269',NULL,NULL,NULL,NULL,'2025-10-02 12:17:45',NULL,'2025-10-02 12:17:45',NULL,NULL),(159,NULL,'0443f4e66b8f444095886e39c4904968',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:17:46',NULL,'2025-10-02 12:17:46',NULL,NULL),(160,NULL,'f05105f4ead54ed0b58e31b41069fdf1',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:17:47',NULL,'2025-10-02 12:17:47',NULL,NULL),(161,NULL,NULL,'95fa0300b3db4130b2230de53fdcdbf1',NULL,NULL,NULL,NULL,'2025-10-02 12:17:51',NULL,'2025-10-02 12:17:51',NULL,NULL),(162,NULL,NULL,'18faccbd91ee45a3b7045d041f00f079',NULL,NULL,NULL,NULL,'2025-10-02 12:17:51',NULL,'2025-10-02 12:17:51',NULL,NULL),(163,NULL,'14b6c3e8b62a4386b63962faed3056e6',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:17:52',NULL,'2025-10-02 12:17:52',NULL,NULL),(164,NULL,'9f5f6c0e8eb8418eb3588d00e8e3e86e',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:17:53',NULL,'2025-10-02 12:17:53',NULL,NULL),(165,NULL,'46edc60fc6024400ab51d6114850fe91',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:17:58',NULL,'2025-10-02 12:17:58',NULL,NULL),(166,NULL,NULL,'e1e23c0e39ae46f89363be5892cbc10b',NULL,NULL,NULL,NULL,'2025-10-02 12:18:00',NULL,'2025-10-02 12:18:00',NULL,NULL),(167,NULL,'a539672e898c4dafa84b245b6142a5ad',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:18:00',NULL,'2025-10-02 12:18:00',NULL,NULL),(168,NULL,NULL,'afecdf9a8e6940529b042b46e36c38ba',NULL,NULL,NULL,NULL,'2025-10-02 12:18:02',NULL,'2025-10-02 12:18:02',NULL,NULL),(169,NULL,NULL,'e7debba53b104046b99b438b9200ce5f',NULL,NULL,NULL,NULL,'2025-10-02 12:18:02',NULL,'2025-10-02 12:18:02',NULL,NULL),(170,NULL,'f8c84f046dba49a989158e20cf13a028',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:18:04',NULL,'2025-10-02 12:18:04',NULL,NULL),(171,NULL,'d622266e53d24bdab78d5e8007cc333d',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:18:05',NULL,'2025-10-02 12:18:05',NULL,NULL),(172,NULL,NULL,'f673de24d96a47efb1d7385dbbf17541',NULL,NULL,NULL,NULL,'2025-10-02 12:18:10',NULL,'2025-10-02 12:18:10',NULL,NULL),(173,NULL,'4266c433aec04ad78558b7cf44ef5a53',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:18:10',NULL,'2025-10-02 12:18:10',NULL,NULL),(174,NULL,NULL,'f43e1d640759407b9c09525fed1da1e7',NULL,NULL,NULL,NULL,'2025-10-02 12:18:11',NULL,'2025-10-02 12:18:11',NULL,NULL),(175,NULL,NULL,'d2eb789eb7074c20a7d74ce4e5e81550',NULL,NULL,NULL,NULL,'2025-10-02 12:18:11',NULL,'2025-10-02 12:18:11',NULL,NULL),(176,NULL,'f7e1ad4a56dc4c97ab5fda2c4aa51c48',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:18:16',NULL,'2025-10-02 12:18:16',NULL,NULL),(177,NULL,'c0b0d4a3c65f400ca2da70dedd527d21',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:18:18',NULL,'2025-10-02 12:18:18',NULL,NULL),(178,NULL,NULL,'3a04ef3720044b2d99834374c9e35b5c',NULL,NULL,NULL,NULL,'2025-10-02 12:18:23',NULL,'2025-10-02 12:18:23',NULL,NULL),(179,NULL,NULL,'9e0b5cb8a5ea4130afe8ee94d8e283fe',NULL,NULL,NULL,NULL,'2025-10-02 12:18:23',NULL,'2025-10-02 12:18:23',NULL,NULL),(180,NULL,'ba3029820e81418aa1020d65fd3218ad',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:18:25',NULL,'2025-10-02 12:18:25',NULL,NULL),(181,NULL,'b3768494d0db4189acd907653b90d8b6',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:18:27',NULL,'2025-10-02 12:18:27',NULL,NULL),(182,NULL,NULL,'e0cdfd1473bd4963b4ded642a43c35f3',NULL,NULL,NULL,NULL,'2025-10-02 12:18:36',NULL,'2025-10-02 12:18:36',NULL,NULL),(183,NULL,NULL,'571990bd3b4445a6add45bfb1c70c84c',NULL,NULL,NULL,NULL,'2025-10-02 12:18:36',NULL,'2025-10-02 12:18:36',NULL,NULL),(184,NULL,'7f6188e258a04ea1a49e6b415bce3fc9',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:18:39',NULL,'2025-10-02 12:18:39',NULL,NULL),(185,NULL,'56632b212f4045a2b4bda23a0a743dcd',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:18:41',NULL,'2025-10-02 12:18:41',NULL,NULL),(186,NULL,NULL,'18c680005ba54b029370f4bc48026d5d',NULL,NULL,NULL,NULL,'2025-10-02 12:18:47',NULL,'2025-10-02 12:18:47',NULL,NULL),(187,NULL,'dbcd6c75ce314711bdaf51e9620c9c97',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:18:47',NULL,'2025-10-02 12:18:47',NULL,NULL),(188,NULL,NULL,'c1187b3ad5984b2cbb4b60c6163a9417',NULL,NULL,NULL,NULL,'2025-10-02 12:18:47',NULL,'2025-10-02 12:18:47',NULL,NULL),(189,NULL,NULL,'000f019cc06e4923b8315f3757b30084',NULL,NULL,NULL,NULL,'2025-10-02 12:18:48',NULL,'2025-10-02 12:18:48',NULL,NULL),(190,NULL,'553280d404ac400cbccb18bede5aab9a',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:18:49',NULL,'2025-10-02 12:18:49',NULL,NULL),(191,NULL,'70832f77703243909569ea955d148b54',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:18:51',NULL,'2025-10-02 12:18:51',NULL,NULL),(192,NULL,NULL,'3c53fbb5ed1e4cf380a90975be5dc249',NULL,NULL,NULL,NULL,'2025-10-02 12:18:53',NULL,'2025-10-02 12:18:53',NULL,NULL),(193,NULL,NULL,'6b3c104301fd4c029fccfe94b0e6d6b6',NULL,NULL,NULL,NULL,'2025-10-02 12:18:54',NULL,'2025-10-02 12:18:54',NULL,NULL),(194,NULL,'2a2d6335f2194d868a80951248d7d7ee',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:18:55',NULL,'2025-10-02 12:18:55',NULL,NULL),(195,NULL,'96eda2c1552247d8b6632dd9e7d1f6df',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:18:58',NULL,'2025-10-02 12:18:58',NULL,NULL),(196,NULL,NULL,'c39d93056d3e4b0b8c409a66d7308ffc',NULL,NULL,NULL,NULL,'2025-10-02 12:19:02',NULL,'2025-10-02 12:19:02',NULL,NULL),(197,NULL,NULL,'9de4e861a27d499d80538643fa01d948',NULL,NULL,NULL,NULL,'2025-10-02 12:19:02',NULL,'2025-10-02 12:19:02',NULL,NULL),(198,NULL,NULL,'cdf81f147f604f0ab1a19dbffc7bbc46',NULL,NULL,NULL,NULL,'2025-10-02 12:19:03',NULL,'2025-10-02 12:19:03',NULL,NULL),(199,NULL,'eb2c944f35b94efcaf91b43a8272cc75',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:19:04',NULL,'2025-10-02 12:19:04',NULL,NULL),(200,NULL,NULL,'050f50db01f441f89eb589e23f4760e1',NULL,NULL,NULL,NULL,'2025-10-02 12:19:04',NULL,'2025-10-02 12:19:04',NULL,NULL),(201,NULL,NULL,'7d4ea95ebf8749c3aed355d9b159f82f',NULL,NULL,NULL,NULL,'2025-10-02 12:19:04',NULL,'2025-10-02 12:19:04',NULL,NULL),(202,NULL,'d72030e929964ee58f0dcb180003ccd7',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:19:04',NULL,'2025-10-02 12:19:04',NULL,NULL),(203,NULL,'968f76078e4046fbae8f7230dd0b8147',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:19:05',NULL,'2025-10-02 12:19:05',NULL,NULL),(204,NULL,'a0e5913326e54f2cb18529f05b3c2575',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:19:06',NULL,'2025-10-02 12:19:06',NULL,NULL),(205,NULL,'eec6f606e2db44dcb38fcae1c4d2725c',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:19:07',NULL,'2025-10-02 12:19:07',NULL,NULL),(206,NULL,NULL,'ff48664ff1074652a19816003a063482',NULL,NULL,NULL,NULL,'2025-10-02 12:19:33',NULL,'2025-10-02 12:19:33',NULL,NULL),(207,NULL,'cdba2bc03abe474a904ab560dd348ba8',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:19:35',NULL,'2025-10-02 12:19:35',NULL,NULL),(208,NULL,NULL,'2ed8b6a2129742dfb3b8a0d9f044ac24',NULL,NULL,NULL,NULL,'2025-10-02 12:19:39',NULL,'2025-10-02 12:19:39',NULL,NULL),(209,NULL,NULL,'6d3f08c1bc2844488f5d3fcd1622dd59',NULL,NULL,NULL,NULL,'2025-10-02 12:19:40',NULL,'2025-10-02 12:19:40',NULL,NULL),(210,NULL,NULL,'6512335913754777991846ad7621947f',NULL,NULL,NULL,NULL,'2025-10-02 12:19:40',NULL,'2025-10-02 12:19:40',NULL,NULL),(211,NULL,'f0bd0c6232b84d03a010ba8cf85bda46',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:19:40',NULL,'2025-10-02 12:19:40',NULL,NULL),(212,NULL,NULL,'6c116d69c3ca47b68fd27e8ebc3e8eda',NULL,NULL,NULL,NULL,'2025-10-02 12:19:41',NULL,'2025-10-02 12:19:41',NULL,NULL),(213,NULL,NULL,'96904c4bf7f04d41931b5ed146871131',NULL,NULL,NULL,NULL,'2025-10-02 12:19:41',NULL,'2025-10-02 12:19:41',NULL,NULL),(214,NULL,'aadd85819f8e46b8b2dc6524e9e6fbad',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:19:42',NULL,'2025-10-02 12:19:42',NULL,NULL),(215,NULL,NULL,'2dbd53ffa15c475cb2196d2d66027b00',NULL,NULL,NULL,NULL,'2025-10-02 12:19:42',NULL,'2025-10-02 12:19:42',NULL,NULL),(216,NULL,'a6e9fb1b7d324521a431c2fd18366d1d',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:19:43',NULL,'2025-10-02 12:19:43',NULL,NULL),(217,NULL,'4acd8d33638648bf90e723d49a24f77e',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:19:44',NULL,'2025-10-02 12:19:44',NULL,NULL),(218,NULL,'8e78e4b68f174addac14ea45aa24918e',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:19:44',NULL,'2025-10-02 12:19:44',NULL,NULL),(219,NULL,'0662c685dffd4e818698735ebe4e9ab1',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:19:44',NULL,'2025-10-02 12:19:44',NULL,NULL),(220,NULL,NULL,'f6bb8780a2674a139c7dce031c7afa1b',NULL,NULL,NULL,NULL,'2025-10-02 12:20:01',NULL,'2025-10-02 12:20:01',NULL,NULL),(221,NULL,NULL,'00b4b8d7d0b44477953fcdb8e2eff057',NULL,NULL,NULL,NULL,'2025-10-02 12:20:01',NULL,'2025-10-02 12:20:01',NULL,NULL),(222,NULL,NULL,'82092ade274e49db9a10c3b7cadc6c3f',NULL,NULL,NULL,NULL,'2025-10-02 12:20:01',NULL,'2025-10-02 12:20:01',NULL,NULL),(223,NULL,'c6a80a62ef3945adb3a158602488057f',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:20:03',NULL,'2025-10-02 12:20:03',NULL,NULL),(224,NULL,'dff18422dfa24a55b38800f4c15c0522',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:20:07',NULL,'2025-10-02 12:20:07',NULL,NULL),(225,NULL,'3ff61c12dace43fa9eaf2013407b73d9',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:20:08',NULL,'2025-10-02 12:20:08',NULL,NULL),(226,NULL,NULL,'7384c819e86a426d84c53eace7ec8594',NULL,NULL,NULL,NULL,'2025-10-02 12:20:21',NULL,'2025-10-02 12:20:21',NULL,NULL),(227,NULL,'a376d124dcaf49f2a6c0208610070573',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:20:22',NULL,'2025-10-02 12:20:22',NULL,NULL),(228,NULL,NULL,'3b8995c42df4489099d6e73bc8966fd1',NULL,NULL,NULL,NULL,'2025-10-02 12:20:24',NULL,'2025-10-02 12:20:24',NULL,NULL),(229,NULL,'636e2037da56462e9a223d7659fd0c3b',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:20:26',NULL,'2025-10-02 12:20:26',NULL,NULL),(230,NULL,NULL,'00254a66d4364bc0b5d187d008ba5a9a',NULL,NULL,NULL,NULL,'2025-10-02 12:21:04',NULL,'2025-10-02 12:21:04',NULL,NULL),(231,NULL,NULL,'b16188801c114483a63c75aa705b21de',NULL,NULL,NULL,NULL,'2025-10-02 12:21:04',NULL,'2025-10-02 12:21:04',NULL,NULL),(232,NULL,'c4cda22198d447dfb7abed394e2299e5',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:21:08',NULL,'2025-10-02 12:21:08',NULL,NULL),(233,NULL,'b1871b72e3494da299605236b73c241f',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:21:14',NULL,'2025-10-02 12:21:14',NULL,NULL),(234,NULL,NULL,'93167a5206ba42b28aa96a676d3edb6d',NULL,NULL,NULL,NULL,'2025-10-02 12:22:15',NULL,'2025-10-02 12:22:15',NULL,NULL),(235,NULL,NULL,'1a8336b787b647e1b78cb06dcd9279b4',NULL,NULL,NULL,NULL,'2025-10-02 12:22:15',NULL,'2025-10-02 12:22:15',NULL,NULL),(236,NULL,'aaf2805394aa4c4cb7977f6433aabf56',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:22:18',NULL,'2025-10-02 12:22:18',NULL,NULL),(237,NULL,'0ea4f964a9824c73ada798e6c162b9ea',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:22:19',NULL,'2025-10-02 12:22:19',NULL,NULL),(238,NULL,NULL,'6ce6b90597304cd29e06b1f1e62246eb',NULL,NULL,NULL,NULL,'2025-10-02 12:22:19',NULL,'2025-10-02 12:22:19',NULL,NULL),(239,NULL,NULL,'2f723850db484803b25ad103759fe27f',NULL,NULL,NULL,NULL,'2025-10-02 12:22:20',NULL,'2025-10-02 12:22:20',NULL,NULL),(240,NULL,'1ff6686454554253817cdb343c2f7e5e',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:22:22',NULL,'2025-10-02 12:22:22',NULL,NULL),(241,NULL,'7e9551381eb943a7ad55e26c6de4a1f8',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:22:23',NULL,'2025-10-02 12:22:23',NULL,NULL),(242,NULL,NULL,'3f60ac1fa31742a8adf058678b2dabb3',NULL,NULL,NULL,NULL,'2025-10-02 12:22:28',NULL,'2025-10-02 12:22:28',NULL,NULL),(243,NULL,NULL,'69d0481040844a41849defe5a0312e7f',NULL,NULL,NULL,NULL,'2025-10-02 12:22:29',NULL,'2025-10-02 12:22:29',NULL,NULL),(244,NULL,'d7602f6076e44b008d4bc87b26736458',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:22:30',NULL,'2025-10-02 12:22:30',NULL,NULL),(245,NULL,'9228281b36fa4bf4a2a58699debf5d23',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:22:32',NULL,'2025-10-02 12:22:32',NULL,NULL),(246,NULL,NULL,'d8ae9cb41a6d4687b77d9b4e5a4f0336',NULL,NULL,NULL,NULL,'2025-10-02 12:22:43',NULL,'2025-10-02 12:22:43',NULL,NULL),(247,NULL,NULL,'f8e6803a15a0420e9239e0ec6c91f823',NULL,NULL,NULL,NULL,'2025-10-02 12:22:43',NULL,'2025-10-02 12:22:43',NULL,NULL),(248,NULL,'3703097e11094f05a49d5777d17c8047',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:22:45',NULL,'2025-10-02 12:22:45',NULL,NULL),(249,NULL,NULL,'ebdbd300d8f847ccbbe92d82262322b7',NULL,NULL,NULL,NULL,'2025-10-02 12:22:45',NULL,'2025-10-02 12:22:45',NULL,NULL),(250,NULL,NULL,'d7cc636d569b4f09ad8183479fe5cd36',NULL,NULL,NULL,NULL,'2025-10-02 12:22:46',NULL,'2025-10-02 12:22:46',NULL,NULL),(251,NULL,'5110e1fe3a184585ab8fa7b7bf497f9d',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:22:47',NULL,'2025-10-02 12:22:47',NULL,NULL),(252,NULL,'a0c39a5a9c174db3b11b91097cde9674',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:22:47',NULL,'2025-10-02 12:22:47',NULL,NULL),(253,NULL,'b11410f7db8648e5a46fd3647014b180',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:22:49',NULL,'2025-10-02 12:22:49',NULL,NULL),(254,NULL,NULL,'da6ae60f98e3458e853ec255c4ecc75e',NULL,NULL,NULL,NULL,'2025-10-02 12:22:54',NULL,'2025-10-02 12:22:54',NULL,NULL),(255,NULL,NULL,'d91cbc04e04b4c8ba93d0cedfaade5d5',NULL,NULL,NULL,NULL,'2025-10-02 12:22:55',NULL,'2025-10-02 12:22:55',NULL,NULL),(256,NULL,'ee18d96ff3f0406ab22c900d33c042fb',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:22:57',NULL,'2025-10-02 12:22:57',NULL,NULL),(257,NULL,'b00aac02ef714f54bd3fadc04b4d9ade',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:22:59',NULL,'2025-10-02 12:22:59',NULL,NULL),(258,NULL,NULL,'b978e493dbdc419e864471708c90b0b4',NULL,NULL,NULL,NULL,'2025-10-02 12:24:21',NULL,'2025-10-02 12:24:21',NULL,NULL),(259,NULL,NULL,'89074b0c4a0c43839801a3f80caacc0e',NULL,NULL,NULL,NULL,'2025-10-02 12:24:21',NULL,'2025-10-02 12:24:21',NULL,NULL),(260,NULL,'dcab4f3b7c604f47befdd0a52db26eea',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:24:22',NULL,'2025-10-02 12:24:22',NULL,NULL),(261,NULL,'20271b53262b4b858077df7995550158',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:24:23',NULL,'2025-10-02 12:24:23',NULL,NULL),(262,NULL,NULL,'afacfeac9efc4e6fbb83ebe4fe9a8f38',NULL,NULL,NULL,NULL,'2025-10-02 12:24:40',NULL,'2025-10-02 12:24:40',NULL,NULL),(263,NULL,'d0ebb2827cb241e499606ce3a3c67d24',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:24:41',NULL,'2025-10-02 12:24:41',NULL,NULL),(264,NULL,NULL,'4bf0c3b1aff24ddba71b54d58957f9ec',NULL,NULL,NULL,NULL,'2025-10-02 12:24:46',NULL,'2025-10-02 12:24:46',NULL,NULL),(265,NULL,'50a12630d6244b4997b9af2d8de64475',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:24:48',NULL,'2025-10-02 12:24:48',NULL,NULL),(266,NULL,NULL,'362d48299e034728849dbfc8e146115d',NULL,NULL,NULL,NULL,'2025-10-02 12:24:56',NULL,'2025-10-02 12:24:56',NULL,NULL),(267,NULL,'13c2255e04f24e389007aece037d49ca',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:24:58',NULL,'2025-10-02 12:24:58',NULL,NULL),(268,NULL,NULL,'5f5e0290cf1a40149adb43fecf6fdd55',NULL,NULL,NULL,NULL,'2025-10-02 12:25:03',NULL,'2025-10-02 12:25:03',NULL,NULL),(269,NULL,'008a473e874c4f8cb8bb82cf3045214c',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:25:05',NULL,'2025-10-02 12:25:05',NULL,NULL),(270,NULL,NULL,'5c6bdc1acafd4db2bcc3e0251393b901',NULL,NULL,NULL,NULL,'2025-10-02 12:25:21',NULL,'2025-10-02 12:25:21',NULL,NULL),(271,NULL,NULL,'14e2d87916e349469cfbfae067726f7c',NULL,NULL,NULL,NULL,'2025-10-02 12:25:22',NULL,'2025-10-02 12:25:22',NULL,NULL),(272,NULL,'74d6a07b22004c29bacecf2a4aa70dab',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:25:24',NULL,'2025-10-02 12:25:24',NULL,NULL),(273,NULL,'4a6d727642dc44b3997a0b35c67e6ab1',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:25:33',NULL,'2025-10-02 12:25:33',NULL,NULL),(274,NULL,NULL,'9c7bf8bc056f45e597e6f9d4041b981d',NULL,NULL,NULL,NULL,'2025-10-02 12:26:20',NULL,'2025-10-02 12:26:20',NULL,NULL),(275,NULL,'b58d39e35c914e0cb6368bbfcaab82da',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:26:22',NULL,'2025-10-02 12:26:22',NULL,NULL),(276,NULL,NULL,'51b45ef40bdc499a8409fd2bf3e6a339',NULL,NULL,NULL,NULL,'2025-10-02 12:26:25',NULL,'2025-10-02 12:26:25',NULL,NULL),(277,NULL,NULL,'4bb2487de2d342b99014877490bf37d2',NULL,NULL,NULL,NULL,'2025-10-02 12:26:26',NULL,'2025-10-02 12:26:26',NULL,NULL),(278,NULL,'e9bc3e9c60be40e298a181e067b16239',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:26:28',NULL,'2025-10-02 12:26:28',NULL,NULL),(279,NULL,'12dfeaa31a6e4a2481a5332ce3094262',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:26:30',NULL,'2025-10-02 12:26:30',NULL,NULL),(280,NULL,NULL,'8f91c489af3544528773599afbfcfbae',NULL,NULL,NULL,NULL,'2025-10-02 12:27:02',NULL,'2025-10-02 12:27:02',NULL,NULL),(281,NULL,NULL,'45e71bb62c1e482bbcf07657b3049198',NULL,NULL,NULL,NULL,'2025-10-02 12:27:03',NULL,'2025-10-02 12:27:03',NULL,NULL),(282,NULL,'d8bc951663fe44d081d921dc98da30a3',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:27:04',NULL,'2025-10-02 12:27:04',NULL,NULL),(283,NULL,'2715815cf51b4499b2f5906aa745dedc',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:27:05',NULL,'2025-10-02 12:27:05',NULL,NULL),(284,NULL,NULL,'2b6687fbfb1f484ba99ef93bbb4ffa7e',NULL,NULL,NULL,NULL,'2025-10-02 12:28:22',NULL,'2025-10-02 12:28:22',NULL,NULL),(285,NULL,'c20ce9073494490588607984318667f5',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:28:23',NULL,'2025-10-02 12:28:23',NULL,NULL),(286,NULL,NULL,'e24ea6fbe7394bd8b4b06dd246587041',NULL,NULL,NULL,NULL,'2025-10-02 12:28:29',NULL,'2025-10-02 12:28:29',NULL,NULL),(287,NULL,'a7572f2170094fb7a5d6e212abf9235d',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:28:30',NULL,'2025-10-02 12:28:30',NULL,NULL),(288,NULL,NULL,'94e0e2f26a1648368032ab7e6732655c',NULL,NULL,NULL,NULL,'2025-10-02 12:28:33',NULL,'2025-10-02 12:28:33',NULL,NULL),(289,NULL,NULL,'e683d1f97adf4573bfa283899813fd7e',NULL,NULL,NULL,NULL,'2025-10-02 12:28:33',NULL,'2025-10-02 12:28:33',NULL,NULL),(290,NULL,'6d96bae071ef4595bd93c956dd20796c',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:28:36',NULL,'2025-10-02 12:28:36',NULL,NULL),(291,NULL,'e10e8f980fa342efadf28ad7e4534ac4',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:28:37',NULL,'2025-10-02 12:28:37',NULL,NULL),(292,NULL,NULL,'eff0431e92464c78b780c8365e6e920c',NULL,NULL,NULL,NULL,'2025-10-02 12:29:06',NULL,'2025-10-02 12:29:06',NULL,NULL),(293,NULL,'bfd7bec5bd4b4366a96cc55cfe95fcc9',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:29:07',NULL,'2025-10-02 12:29:07',NULL,NULL),(294,NULL,NULL,'078195ba65024ac599a198bb269dfd3a',NULL,NULL,NULL,NULL,'2025-10-02 12:29:09',NULL,'2025-10-02 12:29:09',NULL,NULL),(295,NULL,'76f9746acf0a4efa9a2544b3c62fa332',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:29:11',NULL,'2025-10-02 12:29:11',NULL,NULL),(296,NULL,NULL,'30d882645d624558a8c934e1e2de3488',NULL,NULL,NULL,NULL,'2025-10-02 12:29:14',NULL,'2025-10-02 12:29:14',NULL,NULL),(297,NULL,NULL,'61e6149575e848ffb09a0adcb1fc0829',NULL,NULL,NULL,NULL,'2025-10-02 12:29:15',NULL,'2025-10-02 12:29:15',NULL,NULL),(298,NULL,'aee47e8927a149149f8b2da7f91e512d',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:29:16',NULL,'2025-10-02 12:29:16',NULL,NULL),(299,NULL,'39b5c552a6cd4929be7dd11a3d28e97e',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:29:17',NULL,'2025-10-02 12:29:17',NULL,NULL),(300,NULL,NULL,'a2dea024deb847a795a1fa651c029a5f',NULL,NULL,NULL,NULL,'2025-10-02 12:29:20',NULL,'2025-10-02 12:29:20',NULL,NULL),(301,NULL,'d3928cc83339407eab7db8ee05ff3e31',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:29:22',NULL,'2025-10-02 12:29:22',NULL,NULL),(302,NULL,NULL,'ac3bf6a0a8364115921b740d0b586c6b',NULL,NULL,NULL,NULL,'2025-10-02 12:29:39',NULL,'2025-10-02 12:29:39',NULL,NULL),(303,NULL,'03a8d1d912cb46bb9292189c731ba756',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:29:39',NULL,'2025-10-02 12:29:39',NULL,NULL),(304,NULL,NULL,'fcf5a512c0c24bebbd413916d07e5b77',NULL,NULL,NULL,NULL,'2025-10-02 12:29:55',NULL,'2025-10-02 12:29:55',NULL,NULL),(305,NULL,'4026877484004ce08dcaf59271d4309e',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:29:56',NULL,'2025-10-02 12:29:56',NULL,NULL),(306,NULL,NULL,'87db7657bb324d029ff3d66f218f1d8d',NULL,NULL,NULL,NULL,'2025-10-02 12:30:20',NULL,'2025-10-02 12:30:20',NULL,NULL),(307,NULL,'494736d8288b414094eb0bc6fbaa8cb7',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:30:22',NULL,'2025-10-02 12:30:22',NULL,NULL),(308,NULL,NULL,'a146ddeb54b04b32af9874800011be4e',NULL,NULL,NULL,NULL,'2025-10-02 12:30:25',NULL,'2025-10-02 12:30:25',NULL,NULL),(309,NULL,'1a64fc283b2b4aa485923ae0b5813b2d',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:30:27',NULL,'2025-10-02 12:30:27',NULL,NULL),(310,NULL,NULL,'045de4bc70204ae8b6975513839061d8',NULL,NULL,NULL,NULL,'2025-10-02 12:31:00',NULL,'2025-10-02 12:31:00',NULL,NULL),(311,NULL,'546222ddef05450d9aeb91e721403b5b',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:31:01',NULL,'2025-10-02 12:31:01',NULL,NULL),(312,NULL,NULL,'eed4fdf8b49f41bfb982bc858fa76bef',NULL,NULL,NULL,NULL,'2025-10-02 12:31:48',NULL,'2025-10-02 12:31:48',NULL,NULL),(313,NULL,'a70008e0fc32481f8ed89060220b28d7',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:31:49',NULL,'2025-10-02 12:31:49',NULL,NULL),(314,NULL,NULL,'28d5425714b04888ba9e6112879fae33',NULL,NULL,NULL,NULL,'2025-10-02 12:33:39',NULL,'2025-10-02 12:33:39',NULL,NULL),(315,NULL,'6b5045a3aa3e42e6b66e2ec8c6bb5810',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:33:40',NULL,'2025-10-02 12:33:40',NULL,NULL),(316,NULL,NULL,'1c8eed6cb806403ca545bb7b2820714e',NULL,NULL,NULL,NULL,'2025-10-02 12:34:16',NULL,'2025-10-02 12:34:16',NULL,NULL),(317,NULL,NULL,'97772803770543d5a88100d6f6a9e193',NULL,NULL,NULL,NULL,'2025-10-02 12:34:16',NULL,'2025-10-02 12:34:16',NULL,NULL),(318,NULL,NULL,'9626ead6e742493492143362866a3aa3',NULL,NULL,NULL,NULL,'2025-10-02 12:34:16',NULL,'2025-10-02 12:34:16',NULL,NULL),(319,NULL,'7846694bb70143aa984e235126fbe15c',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:34:17',NULL,'2025-10-02 12:34:17',NULL,NULL),(320,NULL,'c363199c26c141ca8fac3c71b399ad3c',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:34:18',NULL,'2025-10-02 12:34:18',NULL,NULL),(321,NULL,'18c3b2a918554e46ad5b8a205dee3b4e',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:34:18',NULL,'2025-10-02 12:34:18',NULL,NULL),(322,NULL,NULL,'7a82e7dc296145a2981f82e64bc5c48e',NULL,NULL,NULL,NULL,'2025-10-02 12:34:30',NULL,'2025-10-02 12:34:30',NULL,NULL),(323,NULL,'812b0ca70f56429383e14031946e37e5',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:34:31',NULL,'2025-10-02 12:34:31',NULL,NULL),(324,NULL,NULL,'34a9da53e0cc446593d0cea2f498c53e',NULL,NULL,NULL,NULL,'2025-10-02 12:35:38',NULL,'2025-10-02 12:35:38',NULL,NULL),(325,NULL,'ed58e2bfccb04353b29ae652cfed3546',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:35:41',NULL,'2025-10-02 12:35:41',NULL,NULL),(326,NULL,NULL,'c0d7f2725ce3440b9e998e6efddc4628',NULL,NULL,NULL,NULL,'2025-10-02 12:35:51',NULL,'2025-10-02 12:35:51',NULL,NULL),(327,NULL,'b35e544965644721a29ebea7dd0cc74e',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:35:52',NULL,'2025-10-02 12:35:52',NULL,NULL),(328,NULL,NULL,'351f6ae1babd46b898b8eae9cfafba27',NULL,NULL,NULL,NULL,'2025-10-02 12:35:57',NULL,'2025-10-02 12:35:57',NULL,NULL),(329,NULL,'c7c4f0ed8ef34da39e9305f3538d45ea',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:35:59',NULL,'2025-10-02 12:35:59',NULL,NULL),(330,NULL,NULL,'32f902c540fc464cb232c0a6942a5d22',NULL,NULL,NULL,NULL,'2025-10-02 12:36:01',NULL,'2025-10-02 12:36:01',NULL,NULL),(331,NULL,'5c7832aaed82459e908e73712013728c',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:36:01',NULL,'2025-10-02 12:36:01',NULL,NULL),(332,NULL,NULL,'a6ed6c81c3f041efba3eeba9fc5a4060',NULL,NULL,NULL,NULL,'2025-10-02 12:36:34',NULL,'2025-10-02 12:36:34',NULL,NULL),(333,NULL,'67164307b6c54c85818a4f6aa13779f8',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:36:40',NULL,'2025-10-02 12:36:40',NULL,NULL),(334,NULL,NULL,'9ea96e98e4914b1db7a21226386f1584',NULL,NULL,NULL,NULL,'2025-10-02 12:36:52',NULL,'2025-10-02 12:36:52',NULL,NULL),(335,NULL,'89c910193b7b4d4eaecb3a0a07473ae7',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:36:53',NULL,'2025-10-02 12:36:53',NULL,NULL),(336,NULL,NULL,'f1215de74baa4b7f8522ec44b7a4630b',NULL,NULL,NULL,NULL,'2025-10-02 12:37:31',NULL,'2025-10-02 12:37:31',NULL,NULL),(337,NULL,'15fd01e26e294206846c155a766b0ad2',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:37:32',NULL,'2025-10-02 12:37:32',NULL,NULL),(338,NULL,NULL,'2f79bec3812947f09a3b04d1f31f08fa',NULL,NULL,NULL,NULL,'2025-10-02 12:37:40',NULL,'2025-10-02 12:37:40',NULL,NULL),(339,NULL,'32951c3cc7a049e8b3ecc438ec73ccdd',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:37:41',NULL,'2025-10-02 12:37:41',NULL,NULL),(340,NULL,NULL,'e28e4c343f46426788534c9108c8a7a8',NULL,NULL,NULL,NULL,'2025-10-02 12:38:09',NULL,'2025-10-02 12:38:09',NULL,NULL),(341,NULL,'4179ec2dfcf6411faefd3d7d7e6356d0',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:38:09',NULL,'2025-10-02 12:38:09',NULL,NULL),(342,NULL,NULL,'d8797ccfebd347ec8f3d3aab546aa0b5',NULL,NULL,NULL,NULL,'2025-10-02 12:38:12',NULL,'2025-10-02 12:38:12',NULL,NULL),(343,NULL,NULL,'99f2a6eb6f5747b5a7ab57de625240e2',NULL,NULL,NULL,NULL,'2025-10-02 12:38:13',NULL,'2025-10-02 12:38:13',NULL,NULL),(344,NULL,'9e521e4b46354fb795d419a14039b4f0',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:38:14',NULL,'2025-10-02 12:38:14',NULL,NULL),(345,NULL,NULL,'71d69bc37f274fad8a0b06c0b96f2a64',NULL,NULL,NULL,NULL,'2025-10-02 12:38:44',NULL,'2025-10-02 12:38:44',NULL,NULL),(346,NULL,'3b295760a6d74c82bd0f9ee4154d7d10',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:38:45',NULL,'2025-10-02 12:38:45',NULL,NULL),(347,NULL,NULL,'e01aec1bfdd145338d35a6ab232794a4',NULL,NULL,NULL,NULL,'2025-10-02 12:39:00',NULL,'2025-10-02 12:39:00',NULL,NULL),(348,NULL,'7ac7abbc0acb45d68edcf67f909a8c90',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:39:02',NULL,'2025-10-02 12:39:02',NULL,NULL),(349,NULL,NULL,'0b4b918d10704ca5852d80098d253220',NULL,NULL,NULL,NULL,'2025-10-02 12:39:11',NULL,'2025-10-02 12:39:11',NULL,NULL),(350,NULL,'99ed62753466455f8b5795e12d35034e',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:39:14',NULL,'2025-10-02 12:39:14',NULL,NULL),(351,NULL,NULL,'ea3659a324824b3991f98e26e33c752f',NULL,NULL,NULL,NULL,'2025-10-02 12:41:02',NULL,'2025-10-02 12:41:02',NULL,NULL),(352,NULL,NULL,'5887babbe6ed47158815b3d900668219',NULL,NULL,NULL,NULL,'2025-10-02 12:41:02',NULL,'2025-10-02 12:41:02',NULL,NULL),(353,NULL,'44e6ad861d934450b2090f40fab255f0',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:41:03',NULL,'2025-10-02 12:41:03',NULL,NULL),(354,NULL,'09092cb3e34e455fa8117cb619db752e',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:41:04',NULL,'2025-10-02 12:41:04',NULL,NULL),(355,NULL,NULL,'62ebcdcc8d604385b88563ad4de9fb2a',NULL,NULL,NULL,NULL,'2025-10-02 12:41:08',NULL,'2025-10-02 12:41:08',NULL,NULL),(356,NULL,'f1aacc353947433da32030a2febea226',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:41:14',NULL,'2025-10-02 12:41:14',NULL,NULL),(357,NULL,NULL,'9ef7a5dbc3524ee8a7efcd0d3ae36787',NULL,NULL,NULL,NULL,'2025-10-02 12:41:50',NULL,'2025-10-02 12:41:50',NULL,NULL),(358,NULL,'a82ed194b379425aa5e1f31b993eee81',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:41:51',NULL,'2025-10-02 12:41:51',NULL,NULL),(359,NULL,NULL,'fdbe447f49374937a828d6281949a2a4',NULL,NULL,NULL,NULL,'2025-10-02 12:43:12',NULL,'2025-10-02 12:43:12',NULL,NULL),(360,NULL,'a79bb765ab1e4aa18672c9641b6187b9',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:43:14',NULL,'2025-10-02 12:43:14',NULL,NULL),(361,NULL,NULL,'17a0940c9daf48ac8cfa6c3e56d0e39c',NULL,NULL,NULL,NULL,'2025-10-02 12:45:35',NULL,'2025-10-02 12:45:35',NULL,NULL),(362,NULL,'88141e38aa2347299e7ab249431ef68c',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:45:36',NULL,'2025-10-02 12:45:36',NULL,NULL),(363,NULL,NULL,'3151966e941f4652ba984616bfa760c7',NULL,NULL,NULL,NULL,'2025-10-02 12:46:03',NULL,'2025-10-02 12:46:03',NULL,NULL),(364,NULL,'f7e2edef094b4ba5a56a5ec5ffce911e',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:46:04',NULL,'2025-10-02 12:46:04',NULL,NULL),(365,NULL,NULL,'a6364dab92d24051b0d97ee76b8bc460',NULL,NULL,NULL,NULL,'2025-10-02 12:46:17',NULL,'2025-10-02 12:46:17',NULL,NULL),(366,NULL,'9a677c6c10fd4da0af5ed44e13f0b6ff',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:46:19',NULL,'2025-10-02 12:46:19',NULL,NULL),(367,NULL,NULL,'2e58e33c40a849f78ce89ebb4965c130',NULL,NULL,NULL,NULL,'2025-10-02 12:46:22',NULL,'2025-10-02 12:46:22',NULL,NULL),(368,NULL,'02be5282c98046d08f296aea5a1db76e',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:46:25',NULL,'2025-10-02 12:46:25',NULL,NULL),(369,NULL,NULL,'b168e90f7c0c414ba26c576fb8706a80',NULL,NULL,NULL,NULL,'2025-10-02 12:47:10',NULL,'2025-10-02 12:47:10',NULL,NULL),(370,NULL,'c87621e5c0ba4f13abfff528143c1c00',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:47:13',NULL,'2025-10-02 12:47:13',NULL,NULL),(371,NULL,NULL,'ae7bcf1e6a3b4132a7068b0f863ca79c',NULL,NULL,NULL,NULL,'2025-10-02 12:48:11',NULL,'2025-10-02 12:48:11',NULL,NULL),(372,NULL,'58b2fa4ee0cd4b97be1b303c203be14f',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:48:13',NULL,'2025-10-02 12:48:13',NULL,NULL),(373,NULL,NULL,'537a49488e284c9ab1330c64e8072747',NULL,NULL,NULL,NULL,'2025-10-02 12:48:26',NULL,'2025-10-02 12:48:26',NULL,NULL),(374,NULL,NULL,'501cadebb222402ca85b946b1f8db8ae',NULL,NULL,NULL,NULL,'2025-10-02 12:48:27',NULL,'2025-10-02 12:48:27',NULL,NULL),(375,NULL,'9768ac969bcb49a08f0cf2563ecd3980',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:48:35',NULL,'2025-10-02 12:48:35',NULL,NULL),(376,NULL,NULL,'05ca431bf8724851be4667d4ba4ed232',NULL,NULL,NULL,NULL,'2025-10-02 12:49:15',NULL,'2025-10-02 12:49:15',NULL,NULL),(377,NULL,'18d7b58e1d284072a8871e112ae7b16a',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:49:19',NULL,'2025-10-02 12:49:19',NULL,NULL),(378,NULL,NULL,'30f1ea0145af4353ae1a243777d0e0d9',NULL,NULL,NULL,NULL,'2025-10-02 12:49:25',NULL,'2025-10-02 12:49:25',NULL,NULL),(379,NULL,'272016746c594508b846776ac1682e86',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:49:28',NULL,'2025-10-02 12:49:28',NULL,NULL),(380,NULL,NULL,'59975fda83334828b7fc35da74da583a',NULL,NULL,NULL,NULL,'2025-10-02 12:49:30',NULL,'2025-10-02 12:49:30',NULL,NULL),(381,NULL,'af0b99df042d44fab53df4ebc8070b75',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:49:33',NULL,'2025-10-02 12:49:33',NULL,NULL),(382,NULL,NULL,'d531375ce55047caaac676156894af82',NULL,NULL,NULL,NULL,'2025-10-02 12:49:43',NULL,'2025-10-02 12:49:43',NULL,NULL),(383,NULL,'a5f0c507e8754b67a03586ed76d09b47',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:49:46',NULL,'2025-10-02 12:49:46',NULL,NULL),(384,NULL,NULL,'e3cd62a3208649c183d3fc2edc1c0f18',NULL,NULL,NULL,NULL,'2025-10-02 12:51:34',NULL,'2025-10-02 12:51:34',NULL,NULL),(385,NULL,NULL,'f3bed552ab0944c4ac34f4f30e0adcf1',NULL,NULL,NULL,NULL,'2025-10-02 12:51:34',NULL,'2025-10-02 12:51:34',NULL,NULL),(386,NULL,'d3e0300f3cf5493d8a9e62e2c4a95767',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:51:34',NULL,'2025-10-02 12:51:34',NULL,NULL),(387,NULL,'5b1bcdae3a1c4ee5b4f71ccf6fb325d6',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:51:39',NULL,'2025-10-02 12:51:39',NULL,NULL),(388,NULL,NULL,'af2648eefb594bc49309cccf408f7ae1',NULL,NULL,NULL,NULL,'2025-10-02 12:52:18',NULL,'2025-10-02 12:52:18',NULL,NULL),(389,NULL,'1308a7eb298f49baaeaf3dc3a6acf592',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:52:19',NULL,'2025-10-02 12:52:19',NULL,NULL),(390,NULL,NULL,'c6b3ffaf413a4cc592b58bfbf3b40c2b',NULL,NULL,NULL,NULL,'2025-10-02 12:52:50',NULL,'2025-10-02 12:52:50',NULL,NULL),(391,NULL,'324f52a964c64bfc9c214faab2ddda5b',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:52:54',NULL,'2025-10-02 12:52:54',NULL,NULL),(392,NULL,NULL,'561638c61f6b4628b89ade4daa8b2506',NULL,NULL,NULL,NULL,'2025-10-02 12:53:21',NULL,'2025-10-02 12:53:21',NULL,NULL),(393,NULL,'91b72d40cdb74ace8ad1651eb40de068',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:53:22',NULL,'2025-10-02 12:53:22',NULL,NULL),(394,NULL,NULL,'b5104e5372994cd19b720862cf1ca2ce',NULL,NULL,NULL,NULL,'2025-10-02 12:54:09',NULL,'2025-10-02 12:54:09',NULL,NULL),(395,NULL,'dbd0afdfb05849f9abfe4cd4454f6a13',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:54:09',NULL,'2025-10-02 12:54:09',NULL,NULL),(396,NULL,NULL,'27c79bf1a6974758951669da9f6801c8',NULL,NULL,NULL,NULL,'2025-10-02 12:54:50',NULL,'2025-10-02 12:54:50',NULL,NULL),(397,NULL,'d532dce9bec34631ae80bf8dea164f24',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:54:50',NULL,'2025-10-02 12:54:50',NULL,NULL),(398,NULL,NULL,'9ea4224783c14b01bd0ff8988a45a5f2',NULL,NULL,NULL,NULL,'2025-10-02 12:55:41',NULL,'2025-10-02 12:55:41',NULL,NULL),(399,NULL,'b48381b3787c4f3d9bb0c9050cf4c52c',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:55:42',NULL,'2025-10-02 12:55:42',NULL,NULL),(400,NULL,NULL,'cd676cdd850145d89e214075074d1c8a',NULL,NULL,NULL,NULL,'2025-10-02 12:56:31',NULL,'2025-10-02 12:56:31',NULL,NULL),(401,NULL,'054571901053487f96bb43a2cd1d5537',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:56:32',NULL,'2025-10-02 12:56:32',NULL,NULL),(402,NULL,NULL,'00be63ea13c84e3d9419078865524099',NULL,NULL,NULL,NULL,'2025-10-02 12:57:53',NULL,'2025-10-02 12:57:53',NULL,NULL),(403,NULL,'cb2da64acac041cb8d38c3b43fe4dbe9',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:57:54',NULL,'2025-10-02 12:57:54',NULL,NULL),(404,NULL,NULL,'442bbb3239d147819312f6839b822eb4',NULL,NULL,NULL,NULL,'2025-10-02 12:57:57',NULL,'2025-10-02 12:57:57',NULL,NULL),(405,NULL,'02cc4627f5494e788f9f7aead801eeb3',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:57:59',NULL,'2025-10-02 12:57:59',NULL,NULL),(406,NULL,NULL,'dfe96a8fa48c4243b6262a0359f5b208',NULL,NULL,NULL,NULL,'2025-10-02 12:58:37',NULL,'2025-10-02 12:58:37',NULL,NULL),(407,NULL,'d8f55f9d9ed144629bd9a03edb020c4f',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:58:37',NULL,'2025-10-02 12:58:37',NULL,NULL),(408,NULL,NULL,'1c573c08a89345349ee60a0f1fd80d32',NULL,NULL,NULL,NULL,'2025-10-02 13:00:13',NULL,'2025-10-02 13:00:13',NULL,NULL),(409,NULL,'e75bb30d28cd465fb9e94a4b8bc63349',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:00:14',NULL,'2025-10-02 13:00:14',NULL,NULL),(410,NULL,NULL,'57a1608ca1fc4bef8b6bc6ad68be3999',NULL,NULL,NULL,NULL,'2025-10-02 13:02:02',NULL,'2025-10-02 13:02:02',NULL,NULL),(411,NULL,'0b15f29eb32d4c5cba98baa238cc12e1',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:02:04',NULL,'2025-10-02 13:02:04',NULL,NULL),(412,NULL,NULL,'b04159d5bffe4259876ce57aec09716e',NULL,NULL,NULL,NULL,'2025-10-02 13:03:39',NULL,'2025-10-02 13:03:39',NULL,NULL),(413,NULL,NULL,'558b139695304e9e874dac10170f8da4',NULL,NULL,NULL,NULL,'2025-10-02 13:03:39',NULL,'2025-10-02 13:03:39',NULL,NULL),(414,NULL,'a6be0e77fb5b4355b4f2276c9e57d2bd',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:03:40',NULL,'2025-10-02 13:03:40',NULL,NULL),(415,NULL,NULL,'cb1643b3981d49ceaebfabe1577596fd',NULL,NULL,NULL,NULL,'2025-10-02 13:03:44',NULL,'2025-10-02 13:03:44',NULL,NULL),(416,NULL,NULL,'bc2610eedf74471a96e6431c56a98cd8',NULL,NULL,NULL,NULL,'2025-10-02 13:03:44',NULL,'2025-10-02 13:03:44',NULL,NULL),(417,NULL,'6e8f1f6ceb7b40ee9fa002d881b59a44',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:03:45',NULL,'2025-10-02 13:03:45',NULL,NULL),(418,NULL,'827babbeeb374262b4784fd400313846',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:03:46',NULL,'2025-10-02 13:03:46',NULL,NULL),(419,NULL,NULL,'96fd589a75cb4fcfac0072edabb9b3a1',NULL,NULL,NULL,NULL,'2025-10-02 13:04:48',NULL,'2025-10-02 13:04:48',NULL,NULL),(420,NULL,NULL,'c25076bda694445b9a51dc32f64c0be2',NULL,NULL,NULL,NULL,'2025-10-02 13:04:48',NULL,'2025-10-02 13:04:48',NULL,NULL),(421,NULL,'2456e7dd176d4f3687d7722adf2c53ac',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:04:50',NULL,'2025-10-02 13:04:50',NULL,NULL),(422,NULL,'64f187c60881475e9e1f062bb198d205',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:04:50',NULL,'2025-10-02 13:04:50',NULL,NULL),(423,NULL,NULL,'47f465d8c8ac44c982f2a2e60ae9eb40',NULL,NULL,NULL,NULL,'2025-10-02 13:05:43',NULL,'2025-10-02 13:05:43',NULL,NULL),(424,NULL,NULL,'adfff0af369747f4ba1424297bded55f',NULL,NULL,NULL,NULL,'2025-10-02 13:05:44',NULL,'2025-10-02 13:05:44',NULL,NULL),(425,NULL,'072925a6aec84a77a9c09ae0c83efdb3',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:05:46',NULL,'2025-10-02 13:05:46',NULL,NULL),(426,NULL,'1acc020862eb4ef284d7cdddf3916b77',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:05:48',NULL,'2025-10-02 13:05:48',NULL,NULL),(427,NULL,NULL,'d1cdfd90a66d402a825b94758e12eb7d',NULL,NULL,NULL,NULL,'2025-10-02 13:06:22',NULL,'2025-10-02 13:06:22',NULL,NULL),(428,NULL,NULL,'7fb7e45069d34870bc5f4fa70bd8c6de',NULL,NULL,NULL,NULL,'2025-10-02 13:06:23',NULL,'2025-10-02 13:06:23',NULL,NULL),(429,NULL,'d6ffb4bd012a4aa2ace5c0158f51f8b0',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:06:26',NULL,'2025-10-02 13:06:26',NULL,NULL),(430,NULL,'19365f54974d4109ae80bc13ac9ba55a',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:06:28',NULL,'2025-10-02 13:06:28',NULL,NULL),(431,NULL,NULL,'640d7130b9254a89a545e79fb6bbb3e4',NULL,NULL,NULL,NULL,'2025-10-02 13:07:05',NULL,'2025-10-02 13:07:05',NULL,NULL),(432,NULL,NULL,'c10b7d25cabf4e3f99e3dc5b2abdec75',NULL,NULL,NULL,NULL,'2025-10-02 13:07:05',NULL,'2025-10-02 13:07:05',NULL,NULL),(433,NULL,'b86d1788e6c34190874d1152be6dd242',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:07:08',NULL,'2025-10-02 13:07:08',NULL,NULL),(434,NULL,NULL,'7c99b382e3ea4a03bbcf5bd8e2322243',NULL,NULL,NULL,NULL,'2025-10-02 13:07:13',NULL,'2025-10-02 13:07:13',NULL,NULL),(435,NULL,NULL,'3d87211e4ee84535a95104393a0543da',NULL,NULL,NULL,NULL,'2025-10-02 13:07:13',NULL,'2025-10-02 13:07:13',NULL,NULL),(436,NULL,'68aecf9157774d368c016e89768f535f',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:07:19',NULL,'2025-10-02 13:07:19',NULL,NULL),(437,NULL,'656a7a38393246b091c07c2832c5e9b0',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:07:22',NULL,'2025-10-02 13:07:22',NULL,NULL),(438,NULL,NULL,'5206d24fd75a48758994a57e7fd259f2',NULL,NULL,NULL,NULL,'2025-10-02 13:07:27',NULL,'2025-10-02 13:07:27',NULL,NULL),(439,NULL,'52dd3c4419794d0fbecd536c5088c60f',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:07:28',NULL,'2025-10-02 13:07:28',NULL,NULL),(440,NULL,NULL,'2821c848f5f64ea7b4420c27210f1562',NULL,NULL,NULL,NULL,'2025-10-02 13:07:34',NULL,'2025-10-02 13:07:34',NULL,NULL),(441,NULL,'59c117c00ff14c47b92e52504f7f0a68',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:07:36',NULL,'2025-10-02 13:07:36',NULL,NULL),(442,NULL,NULL,'62f4c4b5cc194bd59ca9cc9f1da78a79',NULL,NULL,NULL,NULL,'2025-10-02 13:11:54',NULL,'2025-10-02 13:11:54',NULL,NULL),(443,NULL,NULL,'849dd3c9c0b142e3b9fd46c5da71ab34',NULL,NULL,NULL,NULL,'2025-10-02 13:11:54',NULL,'2025-10-02 13:11:54',NULL,NULL),(444,NULL,'954946ff6b204fba90f767ec67210620',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:11:55',NULL,'2025-10-02 13:11:55',NULL,NULL),(445,NULL,'5d548435c98f4701bc12aa0e81690155',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:11:56',NULL,'2025-10-02 13:11:56',NULL,NULL),(446,NULL,NULL,'362b536431b64b15b67740060af57e9c',NULL,NULL,NULL,NULL,'2025-10-02 13:13:19',NULL,'2025-10-02 13:13:19',NULL,NULL),(447,NULL,NULL,'93f224db5657410889fd6d1e8031770a',NULL,NULL,NULL,NULL,'2025-10-02 13:13:20',NULL,'2025-10-02 13:13:20',NULL,NULL),(448,NULL,NULL,'64bd41805f2b46a3bc268055a9981ef3',NULL,NULL,NULL,NULL,'2025-10-02 13:13:20',NULL,'2025-10-02 13:13:20',NULL,NULL),(449,NULL,'295433bda03d485d804c6a08a3d35b79',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:13:23',NULL,'2025-10-02 13:13:23',NULL,NULL),(450,NULL,'e911de934ec043d1bd942c8aed562d04',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:13:24',NULL,'2025-10-02 13:13:24',NULL,NULL),(451,NULL,'aed40f24f86c4d4cb4ce0a3d01cde284',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:13:25',NULL,'2025-10-02 13:13:25',NULL,NULL),(452,NULL,NULL,'156cc6022c70402ab6d194a340b076d5',NULL,NULL,NULL,NULL,'2025-10-02 13:13:36',NULL,'2025-10-02 13:13:36',NULL,NULL),(453,NULL,'9f85b8f387b146d29eabe946c4fbdee8',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:13:37',NULL,'2025-10-02 13:13:37',NULL,NULL),(454,NULL,NULL,'216ca241b0c548969467dd331a0d31ef',NULL,NULL,NULL,NULL,'2025-10-02 13:15:15',NULL,'2025-10-02 13:15:15',NULL,NULL),(455,NULL,NULL,'0485e6ed8ef044a8aa0bd4dab3be1f56',NULL,NULL,NULL,NULL,'2025-10-02 13:15:15',NULL,'2025-10-02 13:15:15',NULL,NULL),(456,NULL,'7466ff60beeb4350933019fe341c4383',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:15:16',NULL,'2025-10-02 13:15:16',NULL,NULL),(457,NULL,'f75652686f7d404a965745c02c9bb8e0',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:15:17',NULL,'2025-10-02 13:15:17',NULL,NULL),(458,NULL,NULL,'81db307ac1f846188ce19b644ebcc396',NULL,NULL,NULL,NULL,'2025-10-02 13:15:20',NULL,'2025-10-02 13:15:20',NULL,NULL),(459,NULL,NULL,'39d8ecd295eb419299b7098c4d0efd18',NULL,NULL,NULL,NULL,'2025-10-02 13:15:20',NULL,'2025-10-02 13:15:20',NULL,NULL),(460,NULL,'7d4df478854744bfbecdf8d1f0e2a7b5',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:15:21',NULL,'2025-10-02 13:15:21',NULL,NULL),(461,NULL,'cbaefa5c700c4ed495a5244732eed7e3',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:15:22',NULL,'2025-10-02 13:15:22',NULL,NULL),(462,NULL,NULL,'37083e5fd56c447cb409b86d6394dd43',NULL,NULL,NULL,NULL,'2025-10-02 13:17:27',NULL,'2025-10-02 13:17:27',NULL,NULL),(463,NULL,'7f5376733aec4630998da8d11db76561',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:17:27',NULL,'2025-10-02 13:17:27',NULL,NULL),(464,NULL,NULL,'e3774ac023a94d05b47d4d7871236a37',NULL,NULL,NULL,NULL,'2025-10-02 13:17:37',NULL,'2025-10-02 13:17:37',NULL,NULL),(465,NULL,'9d6e19e05bf0433a9d26f845522d79b4',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:17:39',NULL,'2025-10-02 13:17:39',NULL,NULL),(466,NULL,NULL,'74f5186fabfb4fea86d32c8ef1f2e354',NULL,NULL,NULL,NULL,'2025-10-02 13:21:31',NULL,'2025-10-02 13:21:31',NULL,NULL),(467,NULL,NULL,'6855eb74420f4a3e89959735688e62dc',NULL,NULL,NULL,NULL,'2025-10-02 13:21:31',NULL,'2025-10-02 13:21:31',NULL,NULL),(468,NULL,'ced4d30c525c44cca617c3b9838d21b7',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:21:32',NULL,'2025-10-02 13:21:32',NULL,NULL),(469,NULL,'b5a702e3bf6f40f280e5201c89bf7969',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:21:33',NULL,'2025-10-02 13:21:33',NULL,NULL),(470,NULL,NULL,'ccfaeecf44e04594afffe1129fec1b0b',NULL,NULL,NULL,NULL,'2025-10-02 13:23:10',NULL,'2025-10-02 13:23:10',NULL,NULL),(471,NULL,NULL,'facc1ea98ac44f608c37dcc50eedf998',NULL,NULL,NULL,NULL,'2025-10-02 13:23:11',NULL,'2025-10-02 13:23:11',NULL,NULL),(472,NULL,'8b72785e0faa4a5eae22ec67bc75f68e',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:23:13',NULL,'2025-10-02 13:23:13',NULL,NULL),(473,NULL,'c30951c8f6a744239dba128629a4006c',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:23:14',NULL,'2025-10-02 13:23:14',NULL,NULL),(474,NULL,NULL,'7eba544d42c8426295f2a88f0e85d446',NULL,NULL,NULL,NULL,'2025-10-02 13:25:44',NULL,'2025-10-02 13:25:44',NULL,NULL),(475,NULL,NULL,'2a9933a4c9734056a7bb4e368170cc8f',NULL,NULL,NULL,NULL,'2025-10-02 13:25:45',NULL,'2025-10-02 13:25:45',NULL,NULL),(476,NULL,'dc0a58fcb2074fc785a618a60971b2ce',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:25:46',NULL,'2025-10-02 13:25:46',NULL,NULL),(477,NULL,'ecfaf38d20784d06a43ced1560cede11',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:25:47',NULL,'2025-10-02 13:25:47',NULL,NULL),(478,NULL,NULL,'2cb47684d0b34c729e9611e7b3943bed',NULL,NULL,NULL,NULL,'2025-10-02 13:32:49',NULL,'2025-10-02 13:32:49',NULL,NULL),(479,NULL,NULL,'7663fed244644528947a1af99b9f04db',NULL,NULL,NULL,NULL,'2025-10-02 13:32:50',NULL,'2025-10-02 13:32:50',NULL,NULL),(480,NULL,'62adf807fa014115940ea32518ca6b11',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:32:52',NULL,'2025-10-02 13:32:52',NULL,NULL),(481,NULL,'18799a1c93354809911705bb424e673f',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:32:53',NULL,'2025-10-02 13:32:53',NULL,NULL);
/*!40000 ALTER TABLE `revocation_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL DEFAULT '<<null>>',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_role_name_domain_id` (`name`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` (`id`, `name`, `extra`, `domain_id`, `description`) VALUES ('0bcf584c296a431482b6d5379e09b8fc','admin','{}','<<null>>',NULL),('16474f5a7d274026977f1dbbd94860b8','reader','{}','<<null>>',NULL),('26f40970ddec40b2b8c1d9bd9ecfc992','service','{}','<<null>>',NULL),('60bf142325984e5f8f48387577b8120b','swiftoperator','{}','<<null>>',NULL),('6b31db46b0a146359705615bb811645e','member','{}','<<null>>',NULL),('8bd78b65e19c4189b64866d882f69e5b','ResellerAdmin','{}','<<null>>',NULL);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_option`
--

DROP TABLE IF EXISTS `role_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_option` (
  `role_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`role_id`,`option_id`),
  CONSTRAINT `role_option_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_option`
--

LOCK TABLES `role_option` WRITE;
/*!40000 ALTER TABLE `role_option` DISABLE KEYS */;
INSERT INTO `role_option` (`role_id`, `option_id`, `option_value`) VALUES ('0bcf584c296a431482b6d5379e09b8fc','IMMU','true'),('16474f5a7d274026977f1dbbd94860b8','IMMU','true'),('6b31db46b0a146359705615bb811645e','IMMU','true');
/*!40000 ALTER TABLE `role_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sensitive_config`
--

DROP TABLE IF EXISTS `sensitive_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sensitive_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sensitive_config`
--

LOCK TABLES `sensitive_config` WRITE;
/*!40000 ALTER TABLE `sensitive_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sensitive_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `type`, `enabled`, `extra`) VALUES ('0bc66ea7899c4ad68fa94385934b3b23','key-manager',1,'{\"description\": \"Barbican Service\", \"name\": \"barbican\"}'),('476eb14e28ee450598b9565f6b8e0458','object-store',1,'{\"name\": \"swift\", \"description\": \"OpenStack Object Storage\"}'),('497bc121086f48ab9376ae6d15e1556b','image',1,'{\"description\": \"Glance Service\", \"name\": \"glance\"}'),('50bbc65fd85b4ef3b0ba1c6dfa263096','volumev3',1,'{\"description\": \"Cinder V3 Service\", \"name\": \"cinderv3\"}'),('698d6307ba7a4e54b4253de1687d0336','placement',1,'{\"description\": \"Placement Service\", \"name\": \"placement\"}'),('70b233106f5d421187e4099e0ec040bd','compute',1,'{\"description\": \"Nova Compute Service\", \"name\": \"nova\"}'),('82dbd4a38a5d4c15b206908b3bb05b4f','identity',1,'{\"name\": \"keystone\"}'),('b91b6e79f838435191b69d2fd9bf09e6','network',1,'{\"description\": \"Openstack Networking\", \"name\": \"neutron\"}'),('e8523de2e8d94c7582ad1c14dd828f9b','Ceilometer',1,'{\"description\": \"Ceilometer Service\", \"name\": \"ceilometer\"}');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_provider`
--

DROP TABLE IF EXISTS `service_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_provider` (
  `auth_url` varchar(256) NOT NULL,
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `sp_url` varchar(256) NOT NULL,
  `relay_state_prefix` varchar(256) NOT NULL DEFAULT 'ss:mem:',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_provider`
--

LOCK TABLES `service_provider` WRITE;
/*!40000 ALTER TABLE `service_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `service_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_assignment`
--

DROP TABLE IF EXISTS `system_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_assignment` (
  `type` varchar(64) NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_assignment`
--

LOCK TABLES `system_assignment` WRITE;
/*!40000 ALTER TABLE `system_assignment` DISABLE KEYS */;
INSERT INTO `system_assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserSystem','c004f5628e4845ada3addf46ef5dfd33','system','0bcf584c296a431482b6d5379e09b8fc',0);
/*!40000 ALTER TABLE `system_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `token`
--

DROP TABLE IF EXISTS `token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `token` (
  `id` varchar(64) NOT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_token_user_id` (`user_id`),
  KEY `ix_token_trust_id` (`trust_id`),
  KEY `ix_token_expires` (`expires`),
  KEY `ix_token_expires_valid` (`expires`,`valid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `token`
--

LOCK TABLES `token` WRITE;
/*!40000 ALTER TABLE `token` DISABLE KEYS */;
/*!40000 ALTER TABLE `token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust`
--

DROP TABLE IF EXISTS `trust`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust` (
  `id` varchar(64) NOT NULL,
  `trustor_user_id` varchar(64) NOT NULL,
  `trustee_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `impersonation` tinyint(1) NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `remaining_uses` int(11) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `redelegated_trust_id` varchar(64) DEFAULT NULL,
  `redelegation_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `duplicate_trust_constraint_expanded` (`trustor_user_id`,`trustee_user_id`,`project_id`,`impersonation`,`expires_at`,`expires_at_int`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust`
--

LOCK TABLES `trust` WRITE;
/*!40000 ALTER TABLE `trust` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust_role`
--

DROP TABLE IF EXISTS `trust_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust_role` (
  `trust_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`trust_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust_role`
--

LOCK TABLES `trust_role` WRITE;
/*!40000 ALTER TABLE `trust_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `default_project_id` varchar(64) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_active_at` date DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_user_id_domain_id` (`id`,`domain_id`),
  KEY `ix_default_project_id` (`default_project_id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `extra`, `enabled`, `default_project_id`, `created_at`, `last_active_at`, `domain_id`) VALUES ('23aa3f9653ff45328f4e2b94234a971c','{}',1,'516d4d3bc591448c8a9ac3484e15b579','2025-10-02 11:30:09','2025-10-02','default'),('2b295092eb574c8e817acce3ed20dc45','{}',1,'516d4d3bc591448c8a9ac3484e15b579','2025-10-02 11:47:30',NULL,'default'),('6005b6c7177949febac5e5a925c2f87b','{}',1,'516d4d3bc591448c8a9ac3484e15b579','2025-10-02 11:31:00','2025-10-02','default'),('7331a01560904b368103c3faa65083fe','{}',1,'516d4d3bc591448c8a9ac3484e15b579','2025-10-02 11:29:55','2025-10-02','default'),('7720aaf0b6dc41d38f1e03222fa6a93b','{}',1,'516d4d3bc591448c8a9ac3484e15b579','2025-10-02 11:30:35','2025-10-02','default'),('83bef9a3b1a9418599f781a62bce437b','{}',1,'516d4d3bc591448c8a9ac3484e15b579','2025-10-02 11:30:00','2025-10-02','default'),('87eb72c517024b2c80adceb6b0e96a5d','{\"tenantId\": \"c5eb7dea6de74c6a814ab22b8222f732\", \"email\": \"demo_tempestconf@test.com\"}',1,NULL,'2025-10-02 12:08:39',NULL,'default'),('b860d2ebdf9c4f3a88a273eb0d47f445','{\"tenantId\": \"7a4d4ad4412d4e9380d1f97190bf5cde\", \"email\": \"alt_demo_tempestconf@test.com\"}',1,NULL,'2025-10-02 12:08:39',NULL,'default'),('c004f5628e4845ada3addf46ef5dfd33','{}',1,NULL,'2025-10-02 11:28:03','2025-10-02','default'),('c33b7673b7de4d34b841170e3e354243','{}',1,'516d4d3bc591448c8a9ac3484e15b579','2025-10-02 11:29:47','2025-10-02','default'),('d3393d667c3c4cbfb478d6009037be7e','{}',1,'516d4d3bc591448c8a9ac3484e15b579','2025-10-02 11:30:19','2025-10-02','default');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_group_membership`
--

DROP TABLE IF EXISTS `user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `fk_user_group_membership_group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `fk_user_group_membership_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_group_membership`
--

LOCK TABLES `user_group_membership` WRITE;
/*!40000 ALTER TABLE `user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_option`
--

DROP TABLE IF EXISTS `user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_option` (
  `user_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`user_id`,`option_id`),
  CONSTRAINT `user_option_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_option`
--

LOCK TABLES `user_option` WRITE;
/*!40000 ALTER TABLE `user_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whitelisted_config`
--

DROP TABLE IF EXISTS `whitelisted_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whitelisted_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whitelisted_config`
--

LOCK TABLES `whitelisted_config` WRITE;
/*!40000 ALTER TABLE `whitelisted_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `whitelisted_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `mysql`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `mysql` /*!40100 DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci */;

USE `mysql`;

--
-- Table structure for table `general_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `general_log` (
  `event_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `command_type` varchar(64) NOT NULL,
  `argument` mediumtext NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='General log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slow_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `slow_log` (
  `start_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `query_time` time(6) NOT NULL,
  `lock_time` time(6) NOT NULL,
  `rows_sent` bigint(20) unsigned NOT NULL,
  `rows_examined` bigint(20) unsigned NOT NULL,
  `db` varchar(512) NOT NULL,
  `last_insert_id` int(11) NOT NULL,
  `insert_id` int(11) NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `sql_text` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `rows_affected` bigint(20) unsigned NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Slow log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `column_stats`
--

DROP TABLE IF EXISTS `column_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `column_stats` (
  `db_name` varchar(64) NOT NULL,
  `table_name` varchar(64) NOT NULL,
  `column_name` varchar(64) NOT NULL,
  `min_value` varbinary(255) DEFAULT NULL,
  `max_value` varbinary(255) DEFAULT NULL,
  `nulls_ratio` decimal(12,4) DEFAULT NULL,
  `avg_length` decimal(12,4) DEFAULT NULL,
  `avg_frequency` decimal(12,4) DEFAULT NULL,
  `hist_size` tinyint(3) unsigned DEFAULT NULL,
  `hist_type` enum('SINGLE_PREC_HB','DOUBLE_PREC_HB') DEFAULT NULL,
  `histogram` varbinary(255) DEFAULT NULL,
  PRIMARY KEY (`db_name`,`table_name`,`column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='Statistics on Columns';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `column_stats`
--

LOCK TABLES `column_stats` WRITE;
/*!40000 ALTER TABLE `column_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `column_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `columns_priv`
--

DROP TABLE IF EXISTS `columns_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `columns_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Table_name` char(64) NOT NULL DEFAULT '',
  `Column_name` char(64) NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `Column_priv` set('Select','Insert','Update','References') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`Host`,`Db`,`User`,`Table_name`,`Column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Column privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `columns_priv`
--

LOCK TABLES `columns_priv` WRITE;
/*!40000 ALTER TABLE `columns_priv` DISABLE KEYS */;
/*!40000 ALTER TABLE `columns_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db`
--

DROP TABLE IF EXISTS `db`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `db` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Event_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_history_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Host`,`Db`,`User`),
  KEY `User` (`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Database privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `db`
--

LOCK TABLES `db` WRITE;
/*!40000 ALTER TABLE `db` DISABLE KEYS */;
INSERT INTO `db` (`Host`, `Db`, `User`, `Select_priv`, `Insert_priv`, `Update_priv`, `Delete_priv`, `Create_priv`, `Drop_priv`, `Grant_priv`, `References_priv`, `Index_priv`, `Alter_priv`, `Create_tmp_table_priv`, `Lock_tables_priv`, `Create_view_priv`, `Show_view_priv`, `Create_routine_priv`, `Alter_routine_priv`, `Execute_priv`, `Event_priv`, `Trigger_priv`, `Delete_history_priv`) VALUES ('localhost','glance','glance_ed2d','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','glance','glance_ed2d','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','placement','placement_29fd','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','keystone','keystone_3be1','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','placement','placement_29fd','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','keystone','keystone_3be1','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','barbican','barbican_7aaf','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','barbican','barbican_7aaf','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','neutron','neutron_d04a','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','cinder','cinder_5c21','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','neutron','neutron_d04a','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','cinder','cinder_5c21','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_api','nova_api_f829','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_api','nova_api_f829','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_cell0','nova_cell0_e6b9','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_cell0','nova_cell0_e6b9','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');
/*!40000 ALTER TABLE `db` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `db` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `name` char(64) NOT NULL DEFAULT '',
  `body` longblob NOT NULL,
  `definer` char(141) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `execute_at` datetime DEFAULT NULL,
  `interval_value` int(11) DEFAULT NULL,
  `interval_field` enum('YEAR','QUARTER','MONTH','DAY','HOUR','MINUTE','WEEK','SECOND','MICROSECOND','YEAR_MONTH','DAY_HOUR','DAY_MINUTE','DAY_SECOND','HOUR_MINUTE','HOUR_SECOND','MINUTE_SECOND','DAY_MICROSECOND','HOUR_MICROSECOND','MINUTE_MICROSECOND','SECOND_MICROSECOND') DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_executed` datetime DEFAULT NULL,
  `starts` datetime DEFAULT NULL,
  `ends` datetime DEFAULT NULL,
  `status` enum('ENABLED','DISABLED','SLAVESIDE_DISABLED') NOT NULL DEFAULT 'ENABLED',
  `on_completion` enum('DROP','PRESERVE') NOT NULL DEFAULT 'DROP',
  `sql_mode` set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','IGNORE_BAD_TABLE_OPTIONS','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH','EMPTY_STRING_IS_NULL','SIMULTANEOUS_ASSIGNMENT','TIME_ROUND_FRACTIONAL') NOT NULL DEFAULT '',
  `comment` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `originator` int(10) unsigned NOT NULL,
  `time_zone` char(64) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT 'SYSTEM',
  `character_set_client` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `collation_connection` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `db_collation` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `body_utf8` longblob DEFAULT NULL,
  PRIMARY KEY (`db`,`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Events';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `func`
--

DROP TABLE IF EXISTS `func`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `func` (
  `name` char(64) NOT NULL DEFAULT '',
  `ret` tinyint(1) NOT NULL DEFAULT 0,
  `dl` char(128) NOT NULL DEFAULT '',
  `type` enum('function','aggregate') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='User defined functions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `func`
--

LOCK TABLES `func` WRITE;
/*!40000 ALTER TABLE `func` DISABLE KEYS */;
/*!40000 ALTER TABLE `func` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `global_priv`
--

DROP TABLE IF EXISTS `global_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Priv` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '{}' CHECK (json_valid(`Priv`)),
  PRIMARY KEY (`Host`,`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Users and global privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `global_priv`
--

LOCK TABLES `global_priv` WRITE;
/*!40000 ALTER TABLE `global_priv` DISABLE KEYS */;
INSERT INTO `global_priv` (`Host`, `User`, `Priv`) VALUES ('localhost','mariadb.sys','{\"access\":0,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"\",\"account_locked\":true,\"password_last_changed\":0}'),('localhost','root','{\"access\": 549755813887, \"plugin\": \"mysql_native_password\", \"authentication_string\": \"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\", \"auth_or\": [{}],\"version_id\":100529,\"password_last_changed\":1759404383}'),('%','root','{\"access\":549755813887,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\",\"password_last_changed\":1759404383}'),('localhost','glance_ed2d','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*DFD61A791FFEB831806EA225A59E94EABFF7A2E8\",\"password_last_changed\":1759404421}'),('%','glance_ed2d','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*DFD61A791FFEB831806EA225A59E94EABFF7A2E8\",\"password_last_changed\":1759404421}'),('localhost','placement_29fd','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*7A63FDE5363410AD063683F135A1C2B540E5C72F\",\"password_last_changed\":1759404424}'),('localhost','keystone_3be1','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*67C452E46E9ECE21847CF61B2C2DFF05EA8350FC\",\"password_last_changed\":1759404424}'),('%','placement_29fd','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*7A63FDE5363410AD063683F135A1C2B540E5C72F\",\"password_last_changed\":1759404424}'),('%','keystone_3be1','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*67C452E46E9ECE21847CF61B2C2DFF05EA8350FC\",\"password_last_changed\":1759404425}'),('localhost','barbican_7aaf','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*29F9CE0DA1FA9456E3FE1022036C2325417DFF67\",\"password_last_changed\":1759404485}'),('%','barbican_7aaf','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*29F9CE0DA1FA9456E3FE1022036C2325417DFF67\",\"password_last_changed\":1759404486}'),('localhost','neutron_d04a','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*3EB14E0AA04102D033F56BB1D687D824AE3FC786\",\"password_last_changed\":1759404486}'),('localhost','cinder_5c21','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*52D834DE2C4F7A24FAA11083CA4056B44E30A25D\",\"password_last_changed\":1759404486}'),('%','neutron_d04a','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*3EB14E0AA04102D033F56BB1D687D824AE3FC786\",\"password_last_changed\":1759404486}'),('%','cinder_5c21','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*52D834DE2C4F7A24FAA11083CA4056B44E30A25D\",\"password_last_changed\":1759404486}'),('localhost','nova_api_f829','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*61655BBE06A4E1937B265B1ACA7A520BD534580A\",\"password_last_changed\":1759404605}'),('%','nova_api_f829','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*61655BBE06A4E1937B265B1ACA7A520BD534580A\",\"password_last_changed\":1759404606}'),('localhost','nova_cell0_e6b9','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*61C277B935E83AC6D7BC2A9D7307CA39076B8D26\",\"password_last_changed\":1759404606}'),('%','nova_cell0_e6b9','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*61C277B935E83AC6D7BC2A9D7307CA39076B8D26\",\"password_last_changed\":1759404606}');
/*!40000 ALTER TABLE `global_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gtid_slave_pos`
--

DROP TABLE IF EXISTS `gtid_slave_pos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gtid_slave_pos` (
  `domain_id` int(10) unsigned NOT NULL,
  `sub_id` bigint(20) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `seq_no` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`domain_id`,`sub_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci COMMENT='Replication slave GTID position';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gtid_slave_pos`
--

LOCK TABLES `gtid_slave_pos` WRITE;
/*!40000 ALTER TABLE `gtid_slave_pos` DISABLE KEYS */;
/*!40000 ALTER TABLE `gtid_slave_pos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_category`
--

DROP TABLE IF EXISTS `help_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_category` (
  `help_category_id` smallint(5) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `parent_category_id` smallint(5) unsigned DEFAULT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_category_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_category`
--

LOCK TABLES `help_category` WRITE;
/*!40000 ALTER TABLE `help_category` DISABLE KEYS */;
INSERT INTO `help_category` (`help_category_id`, `name`, `parent_category_id`, `url`) VALUES (1,'Contents',0,''),(2,'Polygon Properties',34,''),(3,'WKT',34,''),(4,'Numeric Functions',37,''),(5,'Plugins',1,''),(6,'MBR',34,''),(7,'Control Flow Functions',37,''),(8,'Transactions',1,''),(9,'Help Metadata',1,''),(10,'Account Management',1,''),(11,'Point Properties',34,''),(12,'Encryption Functions',37,''),(13,'LineString Properties',34,''),(14,'Miscellaneous Functions',37,''),(15,'Logical Operators',47,''),(16,'Functions and Modifiers for Use with GROUP BY',1,''),(17,'Information Functions',37,''),(18,'Assignment Operators',47,''),(19,'Comparison Operators',47,''),(20,'Bit Functions',37,''),(21,'Table Maintenance',1,''),(22,'User-Defined Functions',1,''),(23,'Data Types',1,''),(24,'Compound Statements',1,''),(25,'Geometry Constructors',34,''),(26,'Administration',1,''),(27,'Data Manipulation',1,''),(28,'Utility',1,''),(29,'Language Structure',1,''),(30,'Geometry Relations',34,''),(31,'Date and Time Functions',37,''),(32,'WKB',34,''),(33,'Procedures',1,''),(34,'Geographic Features',1,''),(35,'Geometry Properties',34,''),(36,'String Functions',37,''),(37,'Functions',1,''),(38,'Data Definition',1,''),(39,'Sequences',1,''),(40,'JSON Functions',37,''),(41,'Window Functions',37,''),(42,'Spider Functions',37,''),(43,'Dynamic Column Functions',37,''),(44,'Galera Functions',37,''),(45,'Temporal Tables',1,''),(46,'GeoJSON',34,''),(47,'Operators',1,''),(48,'Arithmetic Operators',47,''),(49,'Replication',1,''),(50,'Prepared Statements',1,'');
/*!40000 ALTER TABLE `help_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_keyword`
--

DROP TABLE IF EXISTS `help_keyword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_keyword` (
  `help_keyword_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  PRIMARY KEY (`help_keyword_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help keywords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_keyword`
--

LOCK TABLES `help_keyword` WRITE;
/*!40000 ALTER TABLE `help_keyword` DISABLE KEYS */;
INSERT INTO `help_keyword` (`help_keyword_id`, `name`) VALUES (1,'work'),(2,'locks'),(3,'locking'),(4,'drop'),(5,'super'),(6,'usage'),(7,'binlog admin'),(8,'binlog monitor'),(9,'binlog replay'),(10,'connection admin'),(11,'federated admin'),(12,'grant option'),(13,'read_only admin'),(14,'replica monitor'),(15,'replication replica'),(16,'roles'),(17,'values'),(18,'value'),(19,'not'),(20,'and'),(21,'or'),(22,':='),(23,'assignment operator'),(24,'='),(25,'!='),(26,'<>'),(27,'not equal'),(28,'less than'),(29,'less than or equal'),(30,'NULL-safe equal'),(31,'equal'),(32,'greater than'),(33,'greater than or equal'),(34,'bitwise and'),(35,'shift left'),(36,'shift right'),(37,'bitwise xor'),(38,'bitwise or'),(39,'bitwise not'),(40,'returns'),(41,'udfs'),(42,'udf calling sequences'),(43,'udf security'),(44,'int1'),(45,'int2'),(46,'int3'),(47,'integer'),(48,'int4'),(49,'int8'),(50,'dec'),(51,'numeric'),(52,'fixed'),(53,'number'),(54,'real'),(55,'double precision'),(56,'nchar'),(57,'long'),(58,'long varchar'),(59,'repeat'),(60,'declare'),(61,'cursor'),(62,'show'),(63,'columns'),(64,'kill connection'),(65,'kill query'),(66,'delete returning'),(67,'sql_big_result'),(68,'minus'),(69,'cte'),(70,'insert returning'),(71,'queries'),(72,'query'),(73,'explain format'),(74,'explain format json'),(75,'rlike'),(76,'character_length'),(77,'escape'),(78,'mode'),(79,'trim_oracle'),(80,'schedule'),(81,'row_format'),(82,'starts'),(83,'host'),(84,'generated columns'),(85,'virtual columns'),(86,'computed columns'),(87,'hidden columns'),(88,'nextval'),(89,'lastval'),(90,'+'),(91,'addition operator'),(92,'/'),(93,'division operator'),(94,'%'),(95,'modulo operator'),(96,'*'),(97,'multiplication operator'),(98,'-'),(99,'subtraction operator'),(100,'master_ssl_verify_cert'),(101,'start replica'),(102,'stop replica'),(103,'reset slave'),(104,'reset replica'),(105,'drop prepare'),(106,'deallocate prepare');
/*!40000 ALTER TABLE `help_keyword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_relation`
--

DROP TABLE IF EXISTS `help_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_relation` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `help_keyword_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`help_keyword_id`,`help_topic_id`),
  KEY `help_topic_id` (`help_topic_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='keyword-topic relation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_relation`
--

LOCK TABLES `help_relation` WRITE;
/*!40000 ALTER TABLE `help_relation` DISABLE KEYS */;
INSERT INTO `help_relation` (`help_topic_id`, `help_keyword_id`) VALUES (94,1),(97,2),(99,2),(101,2),(116,2),(147,2),(152,2),(157,2),(161,2),(162,2),(338,2),(438,2),(97,3),(99,3),(101,3),(116,3),(147,3),(152,3),(157,3),(161,3),(162,3),(338,3),(438,3),(106,4),(112,4),(250,4),(687,4),(697,4),(713,4),(714,4),(715,4),(716,4),(717,4),(718,4),(719,4),(720,4),(722,4),(723,4),(731,4),(107,5),(107,6),(107,7),(107,8),(107,9),(107,10),(107,11),(107,12),(107,13),(107,14),(107,15),(115,16),(166,17),(166,18),(167,19),(168,20),(170,21),(210,22),(210,23),(211,23),(211,24),(212,25),(212,26),(212,27),(213,28),(214,29),(215,30),(216,31),(217,32),(218,33),(232,34),(233,35),(234,36),(236,37),(237,38),(238,39),(249,40),(251,41),(252,42),(253,43),(255,44),(257,45),(258,46),(259,47),(259,48),(260,49),(261,50),(261,51),(261,52),(261,53),(263,54),(263,55),(269,56),(275,57),(275,58),(304,59),(664,59),(311,60),(311,61),(331,62),(332,62),(333,62),(334,62),(335,62),(342,62),(343,62),(344,62),(345,62),(346,62),(347,62),(354,62),(356,62),(357,62),(358,62),(359,62),(360,62),(361,62),(362,62),(363,62),(364,62),(365,62),(366,62),(367,62),(368,62),(369,62),(370,62),(371,62),(372,62),(373,62),(374,62),(375,62),(376,62),(377,62),(378,62),(379,62),(380,62),(381,62),(382,62),(383,62),(384,62),(385,62),(386,62),(387,62),(388,62),(389,62),(390,62),(391,62),(392,62),(393,62),(394,62),(395,62),(396,62),(397,62),(398,62),(408,62),(409,62),(333,63),(403,64),(403,65),(410,66),(414,67),(425,68),(431,69),(432,69),(433,69),(453,70),(460,71),(460,72),(466,73),(466,74),(622,75),(632,76),(651,77),(657,78),(678,79),(689,80),(696,81),(701,82),(707,83),(711,84),(711,85),(711,86),(712,87),(732,88),(733,89),(804,90),(804,91),(805,92),(805,93),(806,94),(806,95),(807,96),(807,97),(808,98),(808,99),(809,100),(810,101),(811,102),(812,103),(812,104),(816,105),(816,106);
/*!40000 ALTER TABLE `help_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_topic`
--

DROP TABLE IF EXISTS `help_topic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_topic` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `help_category_id` smallint(5) unsigned NOT NULL,
  `description` text NOT NULL,
  `example` text NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_topic_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help topics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_topic`
--

LOCK TABLES `help_topic` WRITE;
/*!40000 ALTER TABLE `help_topic` DISABLE KEYS */;
INSERT INTO `help_topic` (`help_topic_id`, `name`, `help_category_id`, `description`, `example`, `url`) VALUES (1,'HELP_DATE',9,'Help Contents generated from the MariaDB Knowledge Base on 23 January 2023.','',''),(2,'HELP_VERSION',9,'Help Contents generated for MariaDB 10.5 from the MariaDB Knowledge Base on 23 January 2023.','',''),(3,'AREA',2,'A synonym for ST_AREA.\n\nURL: https://mariadb.com/kb/en/polygon-properties-area/','','https://mariadb.com/kb/en/polygon-properties-area/'),(4,'CENTROID',2,'A synonym for ST_CENTROID.\n\nURL: https://mariadb.com/kb/en/centroid/','','https://mariadb.com/kb/en/centroid/'),(5,'ExteriorRing',2,'A synonym for ST_ExteriorRing.\n\nURL: https://mariadb.com/kb/en/polygon-properties-exteriorring/','','https://mariadb.com/kb/en/polygon-properties-exteriorring/'),(6,'InteriorRingN',2,'A synonym for ST_InteriorRingN.\n\nURL: https://mariadb.com/kb/en/polygon-properties-interiorringn/','','https://mariadb.com/kb/en/polygon-properties-interiorringn/'),(7,'NumInteriorRings',2,'A synonym for ST_NumInteriorRings.\n\nURL: https://mariadb.com/kb/en/polygon-properties-numinteriorrings/','','https://mariadb.com/kb/en/polygon-properties-numinteriorrings/'),(8,'ST_AREA',2,'Syntax\n------\n\nST_Area(poly)\nArea(poly)\n\nDescription\n-----------\n\nReturns as a double-precision number the area of the Polygon value poly, as\nmeasured in its spatial reference system.\n\nST_Area() and Area() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\n\nSELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+\n\nURL: https://mariadb.com/kb/en/st_area/','','https://mariadb.com/kb/en/st_area/'),(9,'ST_CENTROID',2,'Syntax\n------\n\nST_Centroid(mpoly)\nCentroid(mpoly)\n\nDescription\n-----------\n\nReturns a point reflecting the mathematical centroid (geometric center) for\nthe MultiPolygon mpoly. The resulting point will not necessarily be on the\nMultiPolygon.\n\nST_Centroid() and Centroid() are synonyms.\n\nExamples\n--------\n\nSET @poly = ST_GeomFromText(\'POLYGON((0 0,20 0,20 20,0 20,0 0))\');\nSELECT ST_AsText(ST_Centroid(@poly)) AS center;\n+--------------+\n| center       |\n+--------------+\n| POINT(10 10) |\n+--------------+\n\nURL: https://mariadb.com/kb/en/st_centroid/','','https://mariadb.com/kb/en/st_centroid/'),(10,'ST_ExteriorRing',2,'Syntax\n------\n\nST_ExteriorRing(poly)\nExteriorRing(poly)\n\nDescription\n-----------\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nST_ExteriorRing() and ExteriorRing() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_exteriorring/','','https://mariadb.com/kb/en/st_exteriorring/'),(11,'ST_InteriorRingN',2,'Syntax\n------\n\nST_InteriorRingN(poly,N)\nInteriorRingN(poly,N)\n\nDescription\n-----------\n\nReturns the N-th interior ring for the Polygon value poly as a LineString.\nRings are numbered beginning with 1.\n\nST_InteriorRingN() and InteriorRingN() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_interiorringn/','','https://mariadb.com/kb/en/st_interiorringn/'),(12,'ST_NumInteriorRings',2,'Syntax\n------\n\nST_NumInteriorRings(poly)\nNumInteriorRings(poly)\n\nDescription\n-----------\n\nReturns an integer containing the number of interior rings in the Polygon\nvalue poly.\n\nNote that according the the OpenGIS standard, a POLYGON should have exactly\none ExteriorRing and all other rings should lie within that ExteriorRing and\nthus be the InteriorRings. Practically, however, some systems, including\nMariaDB\'s, permit polygons to have several \'ExteriorRings\'. In the case of\nthere being multiple, non-overlapping exterior rings ST_NumInteriorRings()\nwill return 1.\n\nST_NumInteriorRings() and NumInteriorRings() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\n\nNon-overlapping \'polygon\':\n\nSELECT ST_NumInteriorRings(ST_PolyFromText(\'POLYGON((0 0,10 0,10 10,0 10,0 0),\n (-1 -1,-5 -1,-5 -5,-1 -5,-1 -1))\')) AS NumInteriorRings;\n+------------------+\n| NumInteriorRings |\n+------------------+\n|                1 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/st_numinteriorrings/','','https://mariadb.com/kb/en/st_numinteriorrings/'),(14,'AsText',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-astext/','','https://mariadb.com/kb/en/wkt-astext/'),(15,'AsWKT',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-aswkt/','','https://mariadb.com/kb/en/wkt-aswkt/'),(16,'GeomCollFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomcollfromtext/','','https://mariadb.com/kb/en/wkt-geomcollfromtext/'),(17,'GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/geometrycollectionfromtext/','','https://mariadb.com/kb/en/geometrycollectionfromtext/'),(18,'GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/geometryfromtext/','','https://mariadb.com/kb/en/geometryfromtext/'),(19,'GeomFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomfromtext/','','https://mariadb.com/kb/en/wkt-geomfromtext/'),(20,'LineFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/wkt-linefromtext/','','https://mariadb.com/kb/en/wkt-linefromtext/'),(21,'LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/linestringfromtext/','','https://mariadb.com/kb/en/linestringfromtext/'),(22,'MLineFromText',3,'Syntax\n------\n\nMLineFromText(wkt[,srid])\nMultiLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTILINESTRING value using its WKT representation and SRID.\n\nMLineFromText() and MultiLineStringFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nSHOW FIELDS FROM gis_multi_line;\nINSERT INTO gis_multi_line VALUES\n  (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16\n23,16 48))\')),\n  (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n  (MLineFromWKB(AsWKB(MultiLineString(\n   LineString(Point(1, 2), Point(3, 5)),\n   LineString(Point(2, 5), Point(5, 8), Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/mlinefromtext/','','https://mariadb.com/kb/en/mlinefromtext/'),(23,'MPointFromText',3,'Syntax\n------\n\nMPointFromText(wkt[,srid])\nMultiPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n\nMPointFromText() and MultiPointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nSHOW FIELDS FROM gis_multi_point;\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/mpointfromtext/','','https://mariadb.com/kb/en/mpointfromtext/'),(13,'WKT Definition',3,'Description\n-----------\n\nThe Well-Known Text (WKT) representation of Geometry is designed to exchange\ngeometry data in ASCII form. Examples of the basic geometry types include:\n\n+-----------------------------------------------------------------------------+\n| Geometry Types                                                              |\n+-----------------------------------------------------------------------------+\n| POINT                                                                       |\n+-----------------------------------------------------------------------------+\n| LINESTRING                                                                  |\n+-----------------------------------------------------------------------------+\n| POLYGON                                                                     |\n+-----------------------------------------------------------------------------+\n| MULTIPOINT                                                                  |\n+-----------------------------------------------------------------------------+\n| MULTILINESTRING                                                             |\n+-----------------------------------------------------------------------------+\n| MULTIPOLYGON                                                                |\n+-----------------------------------------------------------------------------+\n| GEOMETRYCOLLECTION                                                          |\n+-----------------------------------------------------------------------------+\n| GEOMETRY                                                                    |\n+-----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/wkt-definition/','','https://mariadb.com/kb/en/wkt-definition/'),(24,'MPolyFromText',3,'Syntax\n------\n\nMPolyFromText(wkt[,srid])\nMultiPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n\nMPolyFromText() and MultiPolygonFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_polygon  (g MULTIPOLYGON);\nSHOW FIELDS FROM gis_multi_polygon;\nINSERT INTO gis_multi_polygon VALUES\n  (MultiPolygonFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromWKB(AsWKB(MultiPolygon(Polygon(\n   LineString(Point(0, 3), Point(3, 3), Point(3, 0), Point(0, 3)))))));\n\nURL: https://mariadb.com/kb/en/mpolyfromtext/','','https://mariadb.com/kb/en/mpolyfromtext/'),(25,'MultiLineStringFromText',3,'A synonym for MLineFromText.\n\nURL: https://mariadb.com/kb/en/multilinestringfromtext/','','https://mariadb.com/kb/en/multilinestringfromtext/'),(26,'MultiPointFromText',3,'A synonym for MPointFromText.\n\nURL: https://mariadb.com/kb/en/multipointfromtext/','','https://mariadb.com/kb/en/multipointfromtext/'),(27,'MultiPolygonFromText',3,'A synonym for MPolyFromText.\n\nURL: https://mariadb.com/kb/en/multipolygonfromtext/','','https://mariadb.com/kb/en/multipolygonfromtext/'),(28,'PointFromText',3,'A synonym for ST_PointFromText.\n\nURL: https://mariadb.com/kb/en/wkt-pointfromtext/','','https://mariadb.com/kb/en/wkt-pointfromtext/'),(29,'PolyFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/wkt-polyfromtext/','','https://mariadb.com/kb/en/wkt-polyfromtext/'),(30,'PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/polygonfromtext/','','https://mariadb.com/kb/en/polygonfromtext/'),(31,'ST_AsText',3,'Syntax\n------\n\nST_AsText(g)\nAsText(g)\nST_AsWKT(g)\nAsWKT(g)\n\nDescription\n-----------\n\nConverts a value in internal geometry format to its WKT representation and\nreturns the string result.\n\nST_AsText(), AsText(), ST_AsWKT() and AsWKT() are all synonyms.\n\nExamples\n--------\n\nSET @g = \'LineString(1 1,4 4,6 6)\';\n\nSELECT ST_AsText(ST_GeomFromText(@g));\n+--------------------------------+\n| ST_AsText(ST_GeomFromText(@g)) |\n+--------------------------------+\n| LINESTRING(1 1,4 4,6 6)        |\n+--------------------------------+\n\nURL: https://mariadb.com/kb/en/st_astext/','','https://mariadb.com/kb/en/st_astext/'),(32,'ST_ASWKT',3,'A synonym for ST_ASTEXT().\n\nURL: https://mariadb.com/kb/en/st_aswkt/','','https://mariadb.com/kb/en/st_aswkt/'),(33,'ST_GeomCollFromText',3,'Syntax\n------\n\nST_GeomCollFromText(wkt[,srid])\nST_GeometryCollectionFromText(wkt[,srid])\nGeomCollFromText(wkt[,srid])\nGeometryCollectionFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and SRID.\n\nST_GeomCollFromText(), ST_GeometryCollectionFromText(), GeomCollFromText() and\nGeometryCollectionFromText() are all synonyms.\n\nExample\n-------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/st_geomcollfromtext/','','https://mariadb.com/kb/en/st_geomcollfromtext/'),(34,'ST_GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/st_geometrycollectionfromtext/','','https://mariadb.com/kb/en/st_geometrycollectionfromtext/'),(35,'ST_GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/st_geometryfromtext/','','https://mariadb.com/kb/en/st_geometryfromtext/'),(36,'ST_GeomFromText',3,'Syntax\n------\n\nST_GeomFromText(wkt[,srid])\nST_GeometryFromText(wkt[,srid])\nGeomFromText(wkt[,srid])\nGeometryFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a geometry value of any type using its WKT representation and SRID.\n\nGeomFromText(), GeometryFromText(), ST_GeomFromText() and\nST_GeometryFromText() are all synonyms.\n\nExample\n-------\n\nSET @g = ST_GEOMFROMTEXT(\'POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1 1))\');\n\nURL: https://mariadb.com/kb/en/st_geomfromtext/','','https://mariadb.com/kb/en/st_geomfromtext/'),(37,'ST_LineFromText',3,'Syntax\n------\n\nST_LineFromText(wkt[,srid])\nST_LineStringFromText(wkt[,srid])\nLineFromText(wkt[,srid])\nLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a LINESTRING value using its WKT representation and SRID.\n\nST_LineFromText(), ST_LineStringFromText(), ST_LineFromText() and\nST_LineStringFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_line  (g LINESTRING);\nSHOW FIELDS FROM gis_line;\nINSERT INTO gis_line VALUES\n  (LineFromText(\'LINESTRING(0 0,0 10,10 0)\')),\n  (LineStringFromText(\'LINESTRING(10 10,20 10,20 20,10 20,10 10)\')),\n  (LineStringFromWKB(AsWKB(LineString(Point(10, 10), Point(40, 10)))));\n\nURL: https://mariadb.com/kb/en/st_linefromtext/','','https://mariadb.com/kb/en/st_linefromtext/'),(38,'ST_LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/st_linestringfromtext/','','https://mariadb.com/kb/en/st_linestringfromtext/'),(39,'ST_PointFromText',3,'Syntax\n------\n\nST_PointFromText(wkt[,srid])\nPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POINT value using its WKT representation and SRID.\n\nST_PointFromText() and PointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_point  (g POINT);\nSHOW FIELDS FROM gis_point;\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/st_pointfromtext/','','https://mariadb.com/kb/en/st_pointfromtext/'),(40,'ST_PolyFromText',3,'Syntax\n------\n\nST_PolyFromText(wkt[,srid])\nST_PolygonFromText(wkt[,srid])\nPolyFromText(wkt[,srid])\nPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POLYGON value using its WKT representation and SRID.\n\nST_PolyFromText(), ST_PolygonFromText(), PolyFromText() and\nST_PolygonFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_polygon   (g POLYGON);\nINSERT INTO gis_polygon VALUES\n  (PolygonFromText(\'POLYGON((10 10,20 10,20 20,10 20,10 10))\')),\n  (PolyFromText(\'POLYGON((0 0,50 0,50 50,0 50,0 0), (10 10,20 10,20 20,10\n20,10 10))\'));\n\nURL: https://mariadb.com/kb/en/st_polyfromtext/','','https://mariadb.com/kb/en/st_polyfromtext/'),(41,'ST_PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/st_polygonfromtext/','','https://mariadb.com/kb/en/st_polygonfromtext/'),(42,'DIV',4,'Syntax\n------\n\nDIV\n\nDescription\n-----------\n\nInteger division. Similar to FLOOR(), but is safe with BIGINT values.\nIncorrect results may occur for non-integer operands that exceed BIGINT range.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, a division by zero produces\nan error. Otherwise, it returns NULL.\n\nThe remainder of a division can be obtained using the MOD operator.\n\nExamples\n--------\n\nSELECT 300 DIV 7;\n+-----------+\n| 300 DIV 7 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT 300 DIV 0;\n+-----------+\n| 300 DIV 0 |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/div/','','https://mariadb.com/kb/en/div/'),(43,'ABS',4,'Syntax\n------\n\nABS(X)\n\nDescription\n-----------\n\nReturns the absolute (non-negative) value of X. If X is not a number, it is\nconverted to a numeric type.\n\nExamples\n--------\n\nSELECT ABS(42);\n+---------+\n| ABS(42) |\n+---------+\n|      42 |\n+---------+\n\nSELECT ABS(-42);\n+----------+\n| ABS(-42) |\n+----------+\n|       42 |\n+----------+\n\nSELECT ABS(DATE \'1994-01-01\');\n+------------------------+\n| ABS(DATE \'1994-01-01\') |\n+------------------------+\n|               19940101 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/abs/','','https://mariadb.com/kb/en/abs/'),(44,'ACOS',4,'Syntax\n------\n\nACOS(X)\n\nDescription\n-----------\n\nReturns the arc cosine of X, that is, the value whose cosine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ACOS(1);\n+---------+\n| ACOS(1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ACOS(1.0001);\n+--------------+\n| ACOS(1.0001) |\n+--------------+\n|         NULL |\n+--------------+\n\nSELECT ACOS(0);\n+-----------------+\n| ACOS(0)         |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT ACOS(0.234);\n+------------------+\n| ACOS(0.234)      |\n+------------------+\n| 1.33460644244679 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/acos/','','https://mariadb.com/kb/en/acos/'),(45,'ASIN',4,'Syntax\n------\n\nASIN(X)\n\nDescription\n-----------\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns NULL if\nX is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ASIN(0.2);\n+--------------------+\n| ASIN(0.2)          |\n+--------------------+\n| 0.2013579207903308 |\n+--------------------+\n\nSELECT ASIN(\'foo\');\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n\nSHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n\nURL: https://mariadb.com/kb/en/asin/','','https://mariadb.com/kb/en/asin/'),(46,'ATAN',4,'Syntax\n------\n\nATAN(X)\n\nDescription\n-----------\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nExamples\n--------\n\nSELECT ATAN(2);\n+--------------------+\n| ATAN(2)            |\n+--------------------+\n| 1.1071487177940904 |\n+--------------------+\n\nSELECT ATAN(-2);\n+---------------------+\n| ATAN(-2)            |\n+---------------------+\n| -1.1071487177940904 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/atan/','','https://mariadb.com/kb/en/atan/'),(47,'ATAN2',4,'Syntax\n------\n\nATAN(Y,X), ATAN2(Y,X)\n\nDescription\n-----------\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both arguments\nare used to determine the quadrant of the result.\n\nExamples\n--------\n\nSELECT ATAN(-2,2);\n+---------------------+\n| ATAN(-2,2)          |\n+---------------------+\n| -0.7853981633974483 |\n+---------------------+\n\nSELECT ATAN2(PI(),0);\n+--------------------+\n| ATAN2(PI(),0)      |\n+--------------------+\n| 1.5707963267948966 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/atan2/','','https://mariadb.com/kb/en/atan2/'),(48,'CEIL',4,'Syntax\n------\n\nCEIL(X)\n\nDescription\n-----------\n\nCEIL() is a synonym for CEILING().\n\nURL: https://mariadb.com/kb/en/ceil/','','https://mariadb.com/kb/en/ceil/'),(49,'CEILING',4,'Syntax\n------\n\nCEILING(X)\n\nDescription\n-----------\n\nReturns the smallest integer value not less than X.\n\nExamples\n--------\n\nSELECT CEILING(1.23);\n+---------------+\n| CEILING(1.23) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT CEILING(-1.23);\n+----------------+\n| CEILING(-1.23) |\n+----------------+\n|             -1 |\n+----------------+\n\nURL: https://mariadb.com/kb/en/ceiling/','','https://mariadb.com/kb/en/ceiling/'),(51,'COS',4,'Syntax\n------\n\nCOS(X)\n\nDescription\n-----------\n\nReturns the cosine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT COS(PI());\n+-----------+\n| COS(PI()) |\n+-----------+\n|        -1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/cos/','','https://mariadb.com/kb/en/cos/'),(52,'COT',4,'Syntax\n------\n\nCOT(X)\n\nDescription\n-----------\n\nReturns the cotangent of X.\n\nExamples\n--------\n\nSELECT COT(42);\n+--------------------+\n| COT(42)            |\n+--------------------+\n| 0.4364167060752729 |\n+--------------------+\n\nSELECT COT(12);\n+---------------------+\n| COT(12)             |\n+---------------------+\n| -1.5726734063976893 |\n+---------------------+\n\nSELECT COT(0);\nERROR 1690 (22003): DOUBLE value is out of range in \'cot(0)\'\n\nURL: https://mariadb.com/kb/en/cot/','','https://mariadb.com/kb/en/cot/'),(54,'DEGREES',4,'Syntax\n------\n\nDEGREES(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from radians to degrees.\n\nThis is the converse of the RADIANS() function.\n\nExamples\n--------\n\nSELECT DEGREES(PI());\n+---------------+\n| DEGREES(PI()) |\n+---------------+\n|           180 |\n+---------------+\n\nSELECT DEGREES(PI() / 2);\n+-------------------+\n| DEGREES(PI() / 2) |\n+-------------------+\n|                90 |\n+-------------------+\n\nSELECT DEGREES(45);\n+-----------------+\n| DEGREES(45)     |\n+-----------------+\n| 2578.3100780887 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/degrees/','','https://mariadb.com/kb/en/degrees/'),(55,'EXP',4,'Syntax\n------\n\nEXP(X)\n\nDescription\n-----------\n\nReturns the value of e (the base of natural logarithms) raised to the power of\nX. The inverse of this function is LOG() (using a single argument only) or\nLN().\n\nIf X is NULL, this function returns NULL.\n\nExamples\n--------\n\nSELECT EXP(2);\n+------------------+\n| EXP(2)           |\n+------------------+\n| 7.38905609893065 |\n+------------------+\n\nSELECT EXP(-2);\n+--------------------+\n| EXP(-2)            |\n+--------------------+\n| 0.1353352832366127 |\n+--------------------+\n\nSELECT EXP(0);\n+--------+\n| EXP(0) |\n+--------+\n|      1 |\n+--------+\n\nSELECT EXP(NULL);\n+-----------+\n| EXP(NULL) |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/exp/','','https://mariadb.com/kb/en/exp/'),(50,'CONV',4,'Syntax\n------\n\nCONV(N,from_base,to_base)\n\nDescription\n-----------\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base to_base.\n\nReturns NULL if any argument is NULL, or if the second or third argument are\nnot in the allowed range.\n\nThe argument N is interpreted as an integer, but may be specified as an\ninteger or a string. The minimum base is 2 and the maximum base is 36. If\nto_base is a negative number, N is regarded as a signed number. Otherwise, N\nis treated as unsigned. CONV() works with 64-bit precision.\n\nSome shortcuts for this function are also available: BIN(), OCT(), HEX(),\nUNHEX(). Also, MariaDB allows binary literal values and hexadecimal literal\nvalues.\n\nExamples\n--------\n\nSELECT CONV(\'a\',16,2);\n+----------------+\n| CONV(\'a\',16,2) |\n+----------------+\n| 1010           |\n+----------------+\n\nSELECT CONV(\'6E\',18,8);\n+-----------------+\n| CONV(\'6E\',18,8) |\n+-----------------+\n| 172             |\n+-----------------+\n\nSELECT CONV(-17,10,-18);\n+------------------+\n| CONV(-17,10,-18) |\n+------------------+\n| -H               |\n+------------------+\n\nSELECT CONV(12+\'10\'+\'10\'+0xa,10,10);\n+------------------------------+\n| CONV(12+\'10\'+\'10\'+0xa,10,10) |\n+------------------------------+\n| 42                           |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/conv/','','https://mariadb.com/kb/en/conv/'),(53,'CRC32',4,'Syntax\n------\n\n<= MariaDB 10.7\n\nCRC32(expr)\n\nFrom MariaDB 10.8\n\nCRC32([par,]expr)\n\nDescription\n-----------\n\nComputes a cyclic redundancy check (CRC) value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is expected to\nbe a string and (if possible) is treated as one if it is not.\n\nUses the ISO 3309 polynomial that used by zlib and many others. MariaDB 10.8\nintroduced the CRC32C() function, which uses the alternate Castagnoli\npolynomia.\n\nMariaDB starting with 10.8\n--------------------------\nOften, CRC is computed in pieces. To facilitate this, MariaDB 10.8.0\nintroduced an optional parameter: CRC32(\'MariaDB\')=CRC32(CRC32(\'Maria\'),\'DB\').\n\nExamples\n--------\n\nSELECT CRC32(\'MariaDB\');\n+------------------+\n| CRC32(\'MariaDB\') |\n+------------------+\n|       4227209140 |\n+------------------+\n\nSELECT CRC32(\'mariadb\');\n+------------------+\n| CRC32(\'mariadb\') |\n+------------------+\n|       2594253378 |\n+------------------+\n\nFrom MariaDB 10.8.0\n\nSELECT CRC32(CRC32(\'Maria\'),\'DB\');\n+----------------------------+\n| CRC32(CRC32(\'Maria\'),\'DB\') |\n+----------------------------+\n|                 4227209140 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/crc32/','','https://mariadb.com/kb/en/crc32/'),(56,'FLOOR',4,'Syntax\n------\n\nFLOOR(X)\n\nDescription\n-----------\n\nReturns the largest integer value not greater than X.\n\nExamples\n--------\n\nSELECT FLOOR(1.23);\n+-------------+\n| FLOOR(1.23) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT FLOOR(-1.23);\n+--------------+\n| FLOOR(-1.23) |\n+--------------+\n|           -2 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/floor/','','https://mariadb.com/kb/en/floor/'),(57,'LN',4,'Syntax\n------\n\nLN(X)\n\nDescription\n-----------\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X. If X\nis less than or equal to 0, or NULL, then NULL is returned.\n\nThe inverse of this function is EXP().\n\nExamples\n--------\n\nSELECT LN(2);\n+-------------------+\n| LN(2)             |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LN(-2);\n+--------+\n| LN(-2) |\n+--------+\n|   NULL |\n+--------+\n\nURL: https://mariadb.com/kb/en/ln/','','https://mariadb.com/kb/en/ln/'),(58,'LOG',4,'Syntax\n------\n\nLOG(X), LOG(B,X)\n\nDescription\n-----------\n\nIf called with one parameter, this function returns the natural logarithm of\nX. If X is less than or equal to 0, then NULL is returned.\n\nIf called with two parameters, it returns the logarithm of X to the base B. If\nB is <= 1 or X <= 0, the function returns NULL.\n\nIf any argument is NULL, the function returns NULL.\n\nThe inverse of this function (when called with a single argument) is the EXP()\nfunction.\n\nExamples\n--------\n\nLOG(X):\n\nSELECT LOG(2);\n+-------------------+\n| LOG(2)            |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LOG(-2);\n+---------+\n| LOG(-2) |\n+---------+\n|    NULL |\n+---------+\n\nLOG(B,X)\n\nSELECT LOG(2,16);\n+-----------+\n| LOG(2,16) |\n+-----------+\n|         4 |\n+-----------+\n\nSELECT LOG(3,27);\n+-----------+\n| LOG(3,27) |\n+-----------+\n|         3 |\n+-----------+\n\nSELECT LOG(3,1);\n+----------+\n| LOG(3,1) |\n+----------+\n|        0 |\n+----------+\n\nSELECT LOG(3,0);\n+----------+\n| LOG(3,0) |\n+----------+\n|     NULL |\n+----------+\n\nURL: https://mariadb.com/kb/en/log/','','https://mariadb.com/kb/en/log/'),(59,'LOG10',4,'Syntax\n------\n\nLOG10(X)\n\nDescription\n-----------\n\nReturns the base-10 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG10(2);\n+-------------------+\n| LOG10(2)          |\n+-------------------+\n| 0.301029995663981 |\n+-------------------+\n\nSELECT LOG10(100);\n+------------+\n| LOG10(100) |\n+------------+\n|          2 |\n+------------+\n\nSELECT LOG10(-100);\n+-------------+\n| LOG10(-100) |\n+-------------+\n|        NULL |\n+-------------+\n\nURL: https://mariadb.com/kb/en/log10/','','https://mariadb.com/kb/en/log10/'),(60,'LOG2',4,'Syntax\n------\n\nLOG2(X)\n\nDescription\n-----------\n\nReturns the base-2 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG2(4398046511104);\n+---------------------+\n| LOG2(4398046511104) |\n+---------------------+\n|                  42 |\n+---------------------+\n\nSELECT LOG2(65536);\n+-------------+\n| LOG2(65536) |\n+-------------+\n|          16 |\n+-------------+\n\nSELECT LOG2(-100);\n+------------+\n| LOG2(-100) |\n+------------+\n|       NULL |\n+------------+\n\nURL: https://mariadb.com/kb/en/log2/','','https://mariadb.com/kb/en/log2/'),(62,'OCT',4,'Syntax\n------\n\nOCT(N)\n\nDescription\n-----------\n\nReturns a string representation of the octal value of N, where N is a longlong\n(BIGINT) number. This is equivalent to CONV(N,10,8). Returns NULL if N is NULL.\n\nExamples\n--------\n\nSELECT OCT(34);\n+---------+\n| OCT(34) |\n+---------+\n| 42      |\n+---------+\n\nSELECT OCT(12);\n+---------+\n| OCT(12) |\n+---------+\n| 14      |\n+---------+\n\nURL: https://mariadb.com/kb/en/oct/','','https://mariadb.com/kb/en/oct/'),(63,'PI',4,'Syntax\n------\n\nPI()\n\nDescription\n-----------\n\nReturns the value of π (pi). The default number of decimal places displayed is\nsix, but MariaDB uses the full double-precision value internally.\n\nExamples\n--------\n\nSELECT PI();\n+----------+\n| PI()     |\n+----------+\n| 3.141593 |\n+----------+\n\nSELECT PI()+0.0000000000000000000000;\n+-------------------------------+\n| PI()+0.0000000000000000000000 |\n+-------------------------------+\n|      3.1415926535897931159980 |\n+-------------------------------+\n\nURL: https://mariadb.com/kb/en/pi/','','https://mariadb.com/kb/en/pi/'),(64,'POW',4,'Syntax\n------\n\nPOW(X,Y)\n\nDescription\n-----------\n\nReturns the value of X raised to the power of Y.\n\nPOWER() is a synonym.\n\nExamples\n--------\n\nSELECT POW(2,3);\n+----------+\n| POW(2,3) |\n+----------+\n|        8 |\n+----------+\n\nSELECT POW(2,-2);\n+-----------+\n| POW(2,-2) |\n+-----------+\n|      0.25 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/pow/','','https://mariadb.com/kb/en/pow/'),(65,'POWER',4,'Syntax\n------\n\nPOWER(X,Y)\n\nDescription\n-----------\n\nThis is a synonym for POW(), which returns the value of X raised to the power\nof Y.\n\nURL: https://mariadb.com/kb/en/power/','','https://mariadb.com/kb/en/power/'),(61,'MOD',4,'Syntax\n------\n\nMOD(N,M), N % M, N MOD M\n\nDescription\n-----------\n\nModulo operation. Returns the remainder of N divided by M. See also Modulo\nOperator.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, any number modulus zero\nproduces an error. Otherwise, it returns NULL.\n\nThe integer part of a division can be obtained using DIV.\n\nExamples\n--------\n\nSELECT 1042 % 50;\n+-----------+\n| 1042 % 50 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT MOD(234, 10);\n+--------------+\n| MOD(234, 10) |\n+--------------+\n|            4 |\n+--------------+\n\nSELECT 253 % 7;\n+---------+\n| 253 % 7 |\n+---------+\n|       1 |\n+---------+\n\nSELECT MOD(29,9);\n+-----------+\n| MOD(29,9) |\n+-----------+\n|         2 |\n+-----------+\n\nSELECT 29 MOD 9;\n+----------+\n| 29 MOD 9 |\n+----------+\n|        2 |\n+----------+\n\nURL: https://mariadb.com/kb/en/mod/','','https://mariadb.com/kb/en/mod/'),(66,'RADIANS',4,'Syntax\n------\n\nRADIANS(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from degrees to radians. Note that π radians\nequals 180 degrees.\n\nThis is the converse of the DEGREES() function.\n\nExamples\n--------\n\nSELECT RADIANS(45);\n+-------------------+\n| RADIANS(45)       |\n+-------------------+\n| 0.785398163397448 |\n+-------------------+\n\nSELECT RADIANS(90);\n+-----------------+\n| RADIANS(90)     |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT RADIANS(PI());\n+--------------------+\n| RADIANS(PI())      |\n+--------------------+\n| 0.0548311355616075 |\n+--------------------+\n\nSELECT RADIANS(180);\n+------------------+\n| RADIANS(180)     |\n+------------------+\n| 3.14159265358979 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/radians/','','https://mariadb.com/kb/en/radians/'),(67,'RAND',4,'Syntax\n------\n\nRAND(), RAND(N)\n\nDescription\n-----------\n\nReturns a random DOUBLE precision floating point value v in the range 0 <= v <\n1.0. If a constant integer argument N is specified, it is used as the seed\nvalue, which produces a repeatable sequence of column values. In the example\nbelow, note that the sequences of values produced by RAND(3) is the same both\nplaces where it occurs.\n\nIn a WHERE clause, RAND() is evaluated each time the WHERE is executed.\n\nStatements using the RAND() function are not safe for statement-based\nreplication.\n\nPractical uses\n--------------\n\nThe expression to get a random integer from a given range is the following:\n\nFLOOR(min_value + RAND() * (max_value - min_value +1))\n\nRAND() is often used to read random rows from a table, as follows:\n\nSELECT * FROM my_table ORDER BY RAND() LIMIT 10;\n\nNote, however, that this technique should never be used on a large table as it\nwill be extremely slow. MariaDB will read all rows in the table, generate a\nrandom value for each of them, order them, and finally will apply the LIMIT\nclause.\n\nExamples\n--------\n\nCREATE TABLE t (i INT);\n\nINSERT INTO t VALUES(1),(2),(3);\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.255651095188829 |\n|    2 | 0.833920199269355 |\n|    3 |  0.40264774151393 |\n+------+-------------------+\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.511478140495232 |\n|    2 | 0.349447508668012 |\n|    3 | 0.212803152588013 |\n+------+-------------------+\n\nUsing the same seed, the same sequence will be returned:\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nGenerating a random number from 5 to 15:\n\nSELECT FLOOR(5 + (RAND() * 11));\n\nURL: https://mariadb.com/kb/en/rand/','','https://mariadb.com/kb/en/rand/'),(68,'ROUND',4,'Syntax\n------\n\nROUND(X), ROUND(X,D)\n\nDescription\n-----------\n\nRounds the argument X to D decimal places. D defaults to 0 if not specified. D\ncan be negative to cause D digits left of the decimal point of the value X to\nbecome zero.\n\nThe rounding algorithm depends on the data type of X:\n\n* for floating point types (FLOAT, DOUBLE) the C libraries rounding function\nis used, so the behavior *may* differ between operating systems\n* for fixed point types (DECIMAL, DEC/NUMBER/FIXED) the \"round half up\" rule\nis used, meaning that e.g. a value ending in exactly .5 is always rounded up.\n\nExamples\n--------\n\nSELECT ROUND(-1.23);\n+--------------+\n| ROUND(-1.23) |\n+--------------+\n|           -1 |\n+--------------+\n\nSELECT ROUND(-1.58);\n+--------------+\n| ROUND(-1.58) |\n+--------------+\n|           -2 |\n+--------------+\n\nSELECT ROUND(1.58); \n+-------------+\n| ROUND(1.58) |\n+-------------+\n|           2 |\n+-------------+\n\nSELECT ROUND(1.298, 1);\n+-----------------+\n| ROUND(1.298, 1) |\n+-----------------+\n|             1.3 |\n+-----------------+\n\nSELECT ROUND(1.298, 0);\n+-----------------+\n| ROUND(1.298, 0) |\n+-----------------+\n|               1 |\n+-----------------+\n\nSELECT ROUND(23.298, -1);\n+-------------------+\n| ROUND(23.298, -1) |\n+-------------------+\n|                20 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/round/','','https://mariadb.com/kb/en/round/'),(69,'SIGN',4,'Syntax\n------\n\nSIGN(X)\n\nDescription\n-----------\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X is\nnegative, zero, or positive.\n\nExamples\n--------\n\nSELECT SIGN(-32);\n+-----------+\n| SIGN(-32) |\n+-----------+\n|        -1 |\n+-----------+\n\nSELECT SIGN(0);\n+---------+\n| SIGN(0) |\n+---------+\n|       0 |\n+---------+\n\nSELECT SIGN(234);\n+-----------+\n| SIGN(234) |\n+-----------+\n|         1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/sign/','','https://mariadb.com/kb/en/sign/'),(70,'SIN',4,'Syntax\n------\n\nSIN(X)\n\nDescription\n-----------\n\nReturns the sine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT SIN(1.5707963267948966);\n+-------------------------+\n| SIN(1.5707963267948966) |\n+-------------------------+\n|                       1 |\n+-------------------------+\n\nSELECT SIN(PI());\n+----------------------+\n| SIN(PI())            |\n+----------------------+\n| 1.22460635382238e-16 |\n+----------------------+\n\nSELECT ROUND(SIN(PI()));\n+------------------+\n| ROUND(SIN(PI())) |\n+------------------+\n|                0 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/sin/','','https://mariadb.com/kb/en/sin/'),(71,'SQRT',4,'Syntax\n------\n\nSQRT(X)\n\nDescription\n-----------\n\nReturns the square root of X. If X is negative, NULL is returned.\n\nExamples\n--------\n\nSELECT SQRT(4);\n+---------+\n| SQRT(4) |\n+---------+\n|       2 |\n+---------+\n\nSELECT SQRT(20);\n+------------------+\n| SQRT(20)         |\n+------------------+\n| 4.47213595499958 |\n+------------------+\n\nSELECT SQRT(-16);\n+-----------+\n| SQRT(-16) |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT SQRT(1764);\n+------------+\n| SQRT(1764) |\n+------------+\n|         42 |\n+------------+\n\nURL: https://mariadb.com/kb/en/sqrt/','','https://mariadb.com/kb/en/sqrt/'),(72,'TAN',4,'Syntax\n------\n\nTAN(X)\n\nDescription\n-----------\n\nReturns the tangent of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT TAN(0.7853981633974483);\n+-------------------------+\n| TAN(0.7853981633974483) |\n+-------------------------+\n|      0.9999999999999999 |\n+-------------------------+\n\nSELECT TAN(PI());\n+-----------------------+\n| TAN(PI())             |\n+-----------------------+\n| -1.22460635382238e-16 |\n+-----------------------+\n\nSELECT TAN(PI()+1);\n+-----------------+\n| TAN(PI()+1)     |\n+-----------------+\n| 1.5574077246549 |\n+-----------------+\n\nSELECT TAN(RADIANS(PI()));\n+--------------------+\n| TAN(RADIANS(PI())) |\n+--------------------+\n| 0.0548861508080033 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/tan/','','https://mariadb.com/kb/en/tan/'),(73,'TRUNCATE',4,'This page documents the TRUNCATE function. See TRUNCATE TABLE for the DDL\nstatement.\n\nSyntax\n------\n\nTRUNCATE(X,D)\n\nDescription\n-----------\n\nReturns the number X, truncated to D decimal places. If D is 0, the result has\nno decimal point or fractional part. D can be negative to cause D digits left\nof the decimal point of the value X to become zero.\n\nExamples\n--------\n\nSELECT TRUNCATE(1.223,1);\n+-------------------+\n| TRUNCATE(1.223,1) |\n+-------------------+\n|               1.2 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,1);\n+-------------------+\n| TRUNCATE(1.999,1) |\n+-------------------+\n|               1.9 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,0); \n+-------------------+\n| TRUNCATE(1.999,0) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSELECT TRUNCATE(-1.999,1);\n+--------------------+\n| TRUNCATE(-1.999,1) |\n+--------------------+\n|               -1.9 |\n+--------------------+\n\nSELECT TRUNCATE(122,-2);\n+------------------+\n| TRUNCATE(122,-2) |\n+------------------+\n|              100 |\n+------------------+\n\nSELECT TRUNCATE(10.28*100,0);\n+-----------------------+\n| TRUNCATE(10.28*100,0) |\n+-----------------------+\n|                  1028 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/truncate/','','https://mariadb.com/kb/en/truncate/'),(74,'INSTALL PLUGIN',5,'Syntax\n------\n\nINSTALL PLUGIN [IF NOT EXISTS] plugin_name SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement installs an individual plugin from the specified library. To\ninstall the whole library (which could be required), use INSTALL SONAME. See\nalso Installing a Plugin.\n\nplugin_name is the name of the plugin as defined in the plugin declaration\nstructure contained in the library file. Plugin names are not case sensitive.\nFor maximal compatibility, plugin names should be limited to ASCII letters,\ndigits, and underscore, because they are used in C source files, shell command\nlines, M4 and Bourne shell scripts, and SQL environments.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension can be omitted (which makes the statement look\nthe same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL PLUGIN adds a line to the mysql.plugin table that describes the\nplugin. This table contains the plugin name and library file name.\n\nINSTALL PLUGIN causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL PLUGIN also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL PLUGIN, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nPLUGIN only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a note instead of\nan error if the specified plugin already exists. See SHOW WARNINGS.\n\nExamples\n--------\n\nINSTALL PLUGIN sphinx SONAME \'ha_sphinx.so\';\n\nThe extension can also be omitted:\n\nINSTALL PLUGIN innodb SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected (0.104 sec)\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+------------------------------------+\n| Level | Code | Message                            |\n+-------+------+------------------------------------+\n| Note  | 1968 | Plugin \'example\' already installed |\n+-------+------+------------------------------------+\n\nURL: https://mariadb.com/kb/en/install-plugin/','','https://mariadb.com/kb/en/install-plugin/'),(78,'Plugin Overview',5,'Plugins are server components that enhance MariaDB in some way. These can be\nanything from new storage engines, plugins for enhancing full-text parsing, or\neven small enhancements, such as a plugin to get a timestamp as an integer.\n\nQuerying Plugin Information\n---------------------------\n\nThere are a number of ways to see which plugins are currently active.\n\nA server almost always has a large number of active plugins, because the\nserver contains a large number of built-in plugins, which are active by\ndefault and cannot be uninstalled.\n\nQuerying Plugin Information with SHOW PLUGINS\n---------------------------------------------\n\nThe SHOW PLUGINS statement can be used to query information about all active\nplugins.\n\nFor example:\n\nSHOW PLUGINS\\G;\n********************** 1. row **********************\n Name: binlog\n Status: ACTIVE\n Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n********************** 2. row **********************\n Name: mysql_native_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n********************** 3. row **********************\n Name: mysql_old_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n...\n\nIf a plugin\'s Library column has a NULL value, then the plugin is built-in,\nand it cannot be uninstalled.\n\nQuerying Plugin Information with information_schema.PLUGINS\n-----------------------------------------------------------\n\nThe information_schema.PLUGINS table can be queried to get more detailed\ninformation about plugins.\n\nFor example:\n\nSELECT * FROM information_schema.PLUGINS\\G\n...\n*************************** 6. row ***************************\n     PLUGIN_NAME: CSV\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: Brian Aker, MySQL AB\n  PLUGIN_DESCRIPTION: CSV storage engine\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n*************************** 7. row ***************************\n     PLUGIN_NAME: MEMORY\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: MySQL AB\n  PLUGIN_DESCRIPTION: Hash based, stored in memory, useful for temporary\ntables\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n...\n\nIf a plugin\'s PLUGIN_LIBRARY column has the NULL value, then the plugin is\nbuilt-in, and it cannot be uninstalled.\n\nQuerying Plugin Information with mysql.plugin\n---------------------------------------------\n\nThe mysql.plugin table can be queried to get information about installed\nplugins.\n\nThis table only contains information about plugins that have been installed\nvia the following methods:\n\n* The INSTALL SONAME statement.\n* The INSTALL PLUGIN statement.\n* The mysql_plugin utility.\n\nThis table does not contain information about:\n\n* Built-in plugins.\n* Plugins loaded with the --plugin-load-add option.\n* Plugins loaded with the --plugin-load option.\n\nThis table only contains enough information to reload the plugin when the\nserver is restarted, which means it only contains the plugin name and the\nplugin library.\n\nFor example:\n\nSELECT * FROM mysql.plugin;\n\n+------+------------+\n| name | dl         |\n+------+------------+\n| PBXT | libpbxt.so |\n+------+------------+\n\nInstalling a Plugin\n-------------------\n\nThere are three primary ways to install a plugin:\n\n* A plugin can be installed dynamically with an SQL statement.\n* A plugin can be installed with a mysqld option, but it requires a server\nrestart.\n* A plugin can be installed with the mysql_plugin utility, while the server is\ncompletely offline.\n\nWhen you are installing a plugin, you also have to ensure that:\n\n* The server\'s plugin directory is properly configured, and the plugin\'s\nlibrary is in the plugin directory.\n* The server\'s minimum plugin maturity is properly configured, and the plugin\nis mature enough to be installed.\n\nInstalling a Plugin Dynamically\n-------------------------------\n\nA plugin can be installed dynamically by executing either the INSTALL SONAME\nor the INSTALL PLUGIN statement.\n\nIf a plugin is installed with one of these statements, then a record will be\nadded to the mysql.plugins table for the plugin. This means that the plugin\nwill automatically be loaded every time the server restarts, unless\nspecifically uninstalled or deactivated.\n\nInstalling a Plugin with INSTALL SONAME\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL SONAME\nstatement. INSTALL SONAME installs all plugins from the given plugin library.\nThis could be required for some plugin libraries.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin), you could execute the\nfollowing:\n\nINSTALL SONAME \'server_audit\';\n\nInstalling a Plugin with INSTALL PLUGIN\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL PLUGIN\nstatement. INSTALL PLUGIN installs a single plugin from the given plugin\nlibrary.\n\nFor example, to install the server_audit audit plugin from the server_audit\nplugin library, you could execute the following:\n\nINSTALL PLUGIN server_audit SONAME \'server_audit\';\n\nInstalling a Plugin with Plugin Load Options\n--------------------------------------------\n\nA plugin can be installed with a mysqld option by providing either the\n--plugin-load-add or the --plugin-load option.\n\nIf a plugin is installed with one of these options, then a record will not be\nadded to the mysql.plugins table for the plugin. This means that if the server\nis restarted without the same option set, then the plugin will not\nautomatically be loaded.\n\nInstalling a Plugin with --plugin-load-add\n------------------------------------------\n\nYou can install a plugin with the --plugin-load-add option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load-add option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load-add=\'server_audit\'\n--plugin-load-add=\'ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nSpecial care must be taken when specifying both the --plugin-load option and\nthe --plugin-load-add option together. The --plugin-load option resets the\nplugin load list, and this can cause unexpected problems if you are not aware.\nThe --plugin-load-add option does not reset the plugin load list, so it is\nmuch safer to use. See Specifying Multiple Plugin Load Options for more\ninformation.\n\nInstalling a Plugin with --plugin-load\n--------------------------------------\n\nYou can install a plugin with the --plugin-load option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load=\'server_audit;ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load = server_audit;ed25519=auth_ed25519\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option together. The --plugin-load option resets the plugin\nload list, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use. See Specifying Multiple Plugin Load Options for more information.\n\nSpecifying Multiple Plugin Load Options\n---------------------------------------\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option. The --plugin-load option resets the plugin load\nlist, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use.\n\nThis can have the following consequences:\n\n* If the --plugin-load option is specified multiple times, then only the last\ninstance will have any effect. For example, in the following case, the first\ninstance of the option is reset:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* If the --plugin-load option is specified after the --plugin-load-add option,\nthen it will also reset the changes made by that option. For example, in the\nfollowing case, the --plugin-load-add option does not do anything, because the\nsubsequent --plugin-load option resets the plugin load list:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* In contrast, if the --plugin-load option is specified before the\n--plugin-load-add option, then it will work fine, because the\n--plugin-load-add option does not reset the plugin load list. For example, in\nthe following case, both plugins are properly loaded:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nInstalling a Plugin with mysql_plugin\n-------------------------------------\n\nA plugin can be installed with the mysql_plugin utility if the server is\ncompletely offline.\n\nThe syntax is:\n\nmysql_plugin [options] <plugin> ENABLE|DISABLE\n\nFor example, to install the server_audit audit plugin, you could execute the\nfollowing:\n\nmysql_plugin server_audit ENABLE\n\nIf a plugin is installed with this utility, then a record will be added to the\nmysql.plugins table for the plugin. This means that the plugin will\nautomatically be loaded every time the server restarts, unless specifically\nuninstalled or deactivated.\n\nConfiguring the Plugin Directory\n--------------------------------\n\nWhen a plugin is being installed, the server looks for the plugin\'s library in\nthe server\'s plugin directory. This directory is configured by the plugin_dir\nsystem variable. This can be specified as a command-line argument to mysqld or\nit can be specified in a relevant server option group in an option file. For\nexample:\n\n[mariadb]\n...\nplugin_dir = /usr/lib64/mysql/plugin\n\nConfiguring the Minimum Plugin Maturity\n---------------------------------------\n\nWhen a plugin is being installed, the server compares the plugin\'s maturity\nlevel against the server\'s minimum allowed plugin maturity. This can help\nprevent users from using unstable plugins on production servers. This minimum\nplugin maturity is configured by the plugin_maturity system variable. This can\nbe specified as a command-line argument to mysqld or it can be specified in a\nrelevant server option group in an option file. For example:\n\n[mariadb]\n...\nplugin_maturity = stable\n\nConfiguring Plugin Activation at Server Startup\n-----------------------------------------------\n\nA plugin will be loaded by default when the server starts if:\n\n* The plugin was installed with the INSTALL SONAME statement.\n* The plugin was installed with the INSTALL PLUGIN statement.\n* The plugin was installed with the mysql_plugin utility.\n* The server is configured to load the plugin with the --plugin-load-add\noption.\n* The server is configured to load the plugin with the --plugin-load option.\n\nThis behavior can be changed with special options that take the form\n--plugin-name. For example, for the server_audit audit plugin, the special\noption is called --server-audit.\n\nThe possible values for these special options are:\n\n+---------------------------------------+------------------------------------+\n| Option Value                          | Description                        |\n+---------------------------------------+------------------------------------+\n| OFF                                   | Disables the plugin without        |\n|                                       | removing it from the               |\n|                                       | mysql.plugins table.               |\n+---------------------------------------+------------------------------------+\n| ON                                    | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will still continue         |\n|                                       | starting up, but the plugin will   |\n|                                       | be disabled.                       |\n+---------------------------------------+------------------------------------+\n| FORCE                                 | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error.                             |\n+---------------------------------------+------------------------------------+\n| FORCE_PLUS_PERMANENT                  | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error. In addition, the plugin     |\n|                                       | cannot be uninstalled with         |\n|                                       | UNINSTALL SONAME or UNINSTALL      |\n|                                       | PLUGIN while the server is         |\n|                                       | running.                           |\n+---------------------------------------+------------------------------------+\n\nA plugin\'s status can be found by looking at the PLUGIN_STATUS column of the\ninformation_schema.PLUGINS table.\n\nUninstalling Plugins\n--------------------\n\nPlugins that are found in the mysql.plugin table, that is those that were\ninstalled with INSTALL SONAME, INSTALL PLUGIN or mysql_plugin can be\nuninstalled in one of two ways:\n\n* The UNINSTALL SONAME or the UNINSTALL PLUGIN statement while the server is\nrunning\n* With mysql_plugin while the server is offline.\n\nPlugins that were enabled as a --plugin-load option do not need to be\nuninstalled. If --plugin-load is omitted the next time the server starts, or\nthe plugin is not listed as one of the --plugin-load entries, the plugin will\nnot be loaded.\n\nUNINSTALL PLUGIN uninstalls a single installed plugin, while UNINSTALL SONAME\nuninstalls all plugins belonging to a given library.\n\nURL: https://mariadb.com/kb/en/plugin-overview/','','https://mariadb.com/kb/en/plugin-overview/'),(79,'MBR Definition',6,'Description\n-----------\n\nThe MBR (Minimum Bounding Rectangle), or Envelope is the bounding geometry,\nformed by the minimum and maximum (X,Y) coordinates:\n\nExamples\n--------\n\n((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n\nURL: https://mariadb.com/kb/en/mbr-definition/','','https://mariadb.com/kb/en/mbr-definition/'),(80,'MBRContains',6,'Syntax\n------\n\nMBRContains(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1\ncontains the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRWithin().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\n\nSET @g2 = GeomFromText(\'Point(1 1)\');\n\nSELECT MBRContains(@g1,@g2), MBRContains(@g2,@g1);\n+----------------------+----------------------+\n| MBRContains(@g1,@g2) | MBRContains(@g2,@g1) |\n+----------------------+----------------------+\n|                    1 |                    0 |\n+----------------------+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrcontains/','','https://mariadb.com/kb/en/mbrcontains/'),(82,'MBREqual',6,'Syntax\n------\n\nMBREqual(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are the same.\n\nExamples\n--------\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 2)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 2, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 3)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 4, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 0 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/mbrequal/','','https://mariadb.com/kb/en/mbrequal/'),(86,'MBRWithin',6,'Syntax\n------\n\nMBRWithin(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1 is\nwithin the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRContains().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((0 0,0 5,5 5,5 0,0 0))\');\nSELECT MBRWithin(@g1,@g2), MBRWithin(@g2,@g1);\n+--------------------+--------------------+\n| MBRWithin(@g1,@g2) | MBRWithin(@g2,@g1) |\n+--------------------+--------------------+\n|                  1 |                  0 |\n+--------------------+--------------------+\n\nURL: https://mariadb.com/kb/en/mbrwithin/','','https://mariadb.com/kb/en/mbrwithin/'),(75,'UNINSTALL PLUGIN',5,'Syntax\n------\n\nUNINSTALL PLUGIN [IF EXISTS] plugin_name\n\nDescription\n-----------\n\nThis statement removes a single installed plugin. To uninstall the whole\nlibrary which contains the plugin, use UNINSTALL SONAME. You cannot uninstall\na plugin if any table that uses it is open.\n\nplugin_name must be the name of some plugin that is listed in the mysql.plugin\ntable. The server executes the plugin\'s deinitialization function and removes\nthe row for the plugin from the mysql.plugin table, so that subsequent server\nrestarts will not load and initialize the plugin. UNINSTALL PLUGIN does not\nremove the plugin\'s shared library file.\n\nTo use UNINSTALL PLUGIN, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nUNINSTALL PLUGIN example;\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------+\n| Level | Code | Message                       |\n+-------+------+-------------------------------+\n| Note  | 1305 | PLUGIN example does not exist |\n+-------+------+-------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-plugin/','','https://mariadb.com/kb/en/uninstall-plugin/'),(76,'INSTALL SONAME',5,'Syntax\n------\n\nINSTALL SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of INSTALL PLUGIN. It installs all plugins from a\ngiven plugin_library. See INSTALL PLUGIN for details.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL SONAME adds one or more lines to the mysql.plugin table that describes\nthe plugin. This table contains the plugin name and library file name.\n\nINSTALL SONAME causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL SONAME also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL SONAME, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nSONAME only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nIf you need to install only one plugin from a library, use the INSTALL PLUGIN\nstatement.\n\nExamples\n--------\n\nTo load the XtraDB storage engine and all of its information_schema tables\nwith one statement, use\n\nINSTALL SONAME \'ha_xtradb\';\n\nThis statement can be used instead of INSTALL PLUGIN even when the library\ncontains only one plugin:\n\nINSTALL SONAME \'ha_sequence\';\n\nURL: https://mariadb.com/kb/en/install-soname/','','https://mariadb.com/kb/en/install-soname/'),(77,'UNINSTALL SONAME',5,'Syntax\n------\n\nUNINSTALL SONAME  [IF EXISTS] \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of UNINSTALL PLUGIN statement, that removes all\nplugins belonging to a specified plugin_library. See UNINSTALL PLUGIN for\ndetails.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nTo use UNINSTALL SONAME, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin library does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nTo uninstall the XtraDB plugin and all of its information_schema tables with\none statement, use\n\nUNINSTALL SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------------+\n| Level | Code | Message                             |\n+-------+------+-------------------------------------+\n| Note  | 1305 | SONAME ha_example.so does not exist |\n+-------+------+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-soname/','','https://mariadb.com/kb/en/uninstall-soname/'),(90,'NULLIF',7,'Syntax\n------\n\nNULLIF(expr1,expr2)\n\nDescription\n-----------\n\nReturns NULL if expr1 = expr2 is true, otherwise returns expr1. This is the\nsame as CASE WHEN expr1 = expr2 THEN NULL ELSE expr1 END.\n\nExamples\n--------\n\nSELECT NULLIF(1,1);\n+-------------+\n| NULLIF(1,1) |\n+-------------+\n|        NULL |\n+-------------+\n\nSELECT NULLIF(1,2);\n+-------------+\n| NULLIF(1,2) |\n+-------------+\n|           1 |\n+-------------+\n\nURL: https://mariadb.com/kb/en/nullif/','','https://mariadb.com/kb/en/nullif/'),(91,'NVL',7,'MariaDB starting with 10.3\n--------------------------\nFrom MariaDB 10.3, NVL is a synonym for IFNULL.\n\nURL: https://mariadb.com/kb/en/nvl/','','https://mariadb.com/kb/en/nvl/'),(92,'NVL2',7,'MariaDB starting with 10.3\n--------------------------\nThe NLV2 function was introduced in MariaDB 10.3.0.\n\nSyntax\n------\n\nNVL2(expr1,expr2,expr3)\n\nDescription\n-----------\n\nThe NVL2 function returns a value based on whether a specified expression is\nNULL or not. If expr1 is not NULL, then NVL2 returns expr2. If expr1 is NULL,\nthen NVL2 returns expr3.\n\nExamples\n--------\n\nSELECT NVL2(NULL,1,2);\n+----------------+\n| NVL2(NULL,1,2) |\n+----------------+\n|              2 |\n+----------------+\n\nSELECT NVL2(\'x\',1,2);\n+---------------+\n| NVL2(\'x\',1,2) |\n+---------------+\n|             1 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/nvl2/','','https://mariadb.com/kb/en/nvl2/'),(81,'MBRDisjoint',6,'Syntax\n------\n\nMBRDisjoint(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are disjoint. Two geometries are disjoint if they do not\nintersect, that is touch or overlap.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECTmbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrdisjoint/','','https://mariadb.com/kb/en/mbrdisjoint/'),(83,'MBRIntersects',6,'Syntax\n------\n\nMBRIntersects(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 intersect.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      1 |\n+------------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      0 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/mbrintersects/','','https://mariadb.com/kb/en/mbrintersects/'),(84,'MBROverlaps',6,'Syntax\n------\n\nMBROverlaps(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 overlap. The term spatially overlaps is used if two\ngeometries intersect and their intersection results in a geometry of the same\ndimension but not equal to either of the given geometries.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbroverlaps/','','https://mariadb.com/kb/en/mbroverlaps/'),(85,'MBRTouches',6,'Syntax\n------\n\nMBRTouches(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 touch. Two geometries spatially touch if the interiors of\nthe geometries do not intersect, but the boundary of one of the geometries\nintersects either the boundary or the interior of the other.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   1 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/mbrtouches/','','https://mariadb.com/kb/en/mbrtouches/'),(87,'CASE OPERATOR',7,'Syntax\n------\n\nCASE value WHEN [compare_value] THEN result [WHEN [compare_value] THEN\nresult ...] [ELSE result] END\n\nCASE WHEN [condition] THEN result [WHEN [condition] THEN result ...]\n[ELSE result] END\n\nDescription\n-----------\n\nThe first version returns the result where value=compare_value. The second\nversion returns the result for the first condition that is true. If there was\nno matching result value, the result after ELSE is returned, or NULL if there\nis no ELSE part.\n\nThere is also a CASE statement, which differs from the CASE operator described\nhere.\n\nExamples\n--------\n\nSELECT CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END;\n+------------------------------------------------------------+\n| CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END |\n+------------------------------------------------------------+\n| one                                                        |\n+------------------------------------------------------------+\n\nSELECT CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END;\n+--------------------------------------------+\n| CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END |\n+--------------------------------------------+\n| true                                       |\n+--------------------------------------------+\n\nSELECT CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END;\n+-----------------------------------------------------+\n| CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END |\n+-----------------------------------------------------+\n|                                                NULL |\n+-----------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/case-operator/','','https://mariadb.com/kb/en/case-operator/'),(101,'UNLOCK TABLES',8,'Syntax\n------\n\nUNLOCK TABLES\n\nDescription\n-----------\n\nUNLOCK TABLES explicitly releases any table locks held by the current session.\nSee LOCK TABLES for more information.\n\nIn addition to releasing table locks acquired by the LOCK TABLES statement,\nthe UNLOCK TABLES statement also releases the global read lock acquired by the\nFLUSH TABLES WITH READ LOCK statement. The FLUSH TABLES WITH READ LOCK\nstatement is very useful for performing backups. See FLUSH for more\ninformation about FLUSH TABLES WITH READ LOCK.\n\nURL: https://mariadb.com/kb/en/transactions-unlock-tables/','','https://mariadb.com/kb/en/transactions-unlock-tables/'),(103,'XA Transactions',8,'Overview\n--------\n\nThe MariaDB XA implementation is based on the X/Open CAE document Distributed\nTransaction Processing: The XA Specification. This document is published by\nThe Open Group and available at\nhttp://www.opengroup.org/public/pubs/catalog/c193.htm.\n\nXA transactions are designed to allow distributed transactions, where a\ntransaction manager (the application) controls a transaction which involves\nmultiple resources. Such resources are usually DBMSs, but could be resources\nof any type. The whole set of required transactional operations is called a\nglobal transaction. Each subset of operations which involve a single resource\nis called a local transaction. XA used a 2-phases commit (2PC). With the first\ncommit, the transaction manager tells each resource to prepare an effective\ncommit, and waits for a confirm message. The changes are not still made\neffective at this point. If any of the resources encountered an error, the\ntransaction manager will rollback the global transaction. If all resources\ncommunicate that the first commit is successful, the transaction manager can\nrequire a second commit, which makes the changes effective.\n\nIn MariaDB, XA transactions can only be used with storage engines that support\nthem. At least InnoDB, TokuDB, SPIDER and MyRocks support them. For InnoDB,\nuntil MariaDB 10.2, XA transactions can be disabled by setting the\ninnodb_support_xa server system variable to 0. From MariaDB 10.3, XA\ntransactions are always supported.\n\nLike regular transactions, XA transactions create metadata locks on accessed\ntables.\n\nXA transactions require REPEATABLE READ as a minimum isolation level. However,\ndistributed transactions should always use SERIALIZABLE.\n\nTrying to start more than one XA transaction at the same time produces a 1400\nerror (SQLSTATE \'XAE09\'). The same error is produced when attempting to start\nan XA transaction while a regular transaction is in effect. Trying to start a\nregular transaction while an XA transaction is in effect produces a 1399 error\n(SQLSTATE \'XAE07\').\n\nThe statements that cause an implicit COMMIT for regular transactions produce\na 1400 error (SQLSTATE \'XAE09\') if a XA transaction is in effect.\n\nInternal XA vs External XA\n--------------------------\n\nXA transactions are an overloaded term in MariaDB. If a storage engine is\nXA-capable, it can mean one or both of these:\n\n* It supports MariaDB\'s internal two-phase commit API. This is transparent to\nthe user. Sometimes this is called \"internal XA\", since MariaDB\'s internal\ntransaction coordinator log can handle coordinating these transactions.\n\n* It supports XA transactions, with the XA START, XA PREPARE, XA COMMIT, etc.\nstatements. Sometimes this is called \"external XA\", since it requires the use\nof an external transaction coordinator to use this feature properly.\n\nTransaction Coordinator Log\n---------------------------\n\nIf you have two or more XA-capable storage engines enabled, then a transaction\ncoordinator log must be available.\n\nThere are currently two implementations of the transaction coordinator log:\n\n* Binary log-based transaction coordinator log\n* Memory-mapped file-based transaction coordinator log\n\nIf the binary log is enabled on a server, then the server will use the binary\nlog-based transaction coordinator log. Otherwise, it will use the\nmemory-mapped file-based transaction coordinator log.\n\nSee Transaction Coordinator Log for more information.\n\nSyntax\n------\n\nXA {START|BEGIN} xid [JOIN|RESUME]\n\nXA END xid [SUSPEND [FOR MIGRATE]]\n\nXA PREPARE xid\n\nXA COMMIT xid [ONE PHASE]\n\nXA ROLLBACK xid\n\nXA RECOVER [FORMAT=[\'RAW\'|\'SQL\']]\n\nxid: gtrid [, bqual [, formatID ]]\n\nThe interface to XA transactions is a set of SQL statements starting with XA.\nEach statement changes a transaction\'s state, determining which actions it can\nperform. A transaction which does not exist is in the NON-EXISTING state.\n\nXA START (or BEGIN) starts a transaction and defines its xid (a transaction\nidentifier). The JOIN or RESUME keywords have no effect. The new transaction\nwill be in ACTIVE state.\n\nThe xid can have 3 components, though only the first one is mandatory. gtrid\nis a quoted string representing a global transaction identifier. bqual is a\nquoted string representing a local transaction identifier. formatID is an\nunsigned integer indicating the format used for the first two components; if\nnot specified, defaults to 1. MariaDB does not interpret in any way these\ncomponents, and only uses them to identify a transaction. xids of transactions\nin effect must be unique.\n\nXA END declares that the specified ACTIVE transaction is finished and it\nchanges its state to IDLE. SUSPEND [FOR MIGRATE] has no effect.\n\nXA PREPARE prepares an IDLE transaction for commit, changing its state to\nPREPARED. This is the first commit.\n\nXA COMMIT definitely commits and terminates a transaction which has already\nbeen PREPARED. If the ONE PHASE clause is specified, this statements performs\na 1-phase commit on an IDLE transaction.\n\nXA ROLLBACK rolls back and terminates an IDLE or PREPARED transaction.\n\nXA RECOVER shows information about all PREPARED transactions.\n\nWhen trying to execute an operation which is not allowed for the transaction\'s\ncurrent state, an error is produced:\n\nXA COMMIT \'test\' ONE PHASE;\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  ACTIVE state\n\nXA COMMIT \'test2\';\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  NON-EXISTING state\n\nXA RECOVER\n----------\n\nThe XA RECOVER statement shows information about all transactions which are in\nthe PREPARED state. It does not matter which connection created the\ntransaction: if it has been PREPARED, it appears. But this does not mean that\na connection can commit or rollback a transaction which was started by another\nconnection. Note that transactions using a 1-phase commit are never in the\nPREPARED state, so they cannot be shown by XA RECOVER.\n\nXA RECOVER produces four columns:\n\nXA RECOVER;\n+----------+--------------+--------------+------+\n| formatID | gtrid_length | bqual_length | data |\n+----------+--------------+--------------+------+\n|        1 |            4 |            0 | test |\n+----------+--------------+--------------+------+\n\nMariaDB starting with 10.3.3\n----------------------------\nYou can use XA RECOVER FORMAT=\'SQL\' to get the data in a human readable form\nthat can be directly copy-pasted into XA COMMIT or XA ROLLBACK. This is\nparticularly useful for binary xid generated by some transaction coordinators.\n\nformatID is the formatID part of xid.\n\ndata are the gtrid and bqual parts of xid, concatenated.\n\ngtrid_length and bqual_length are the lengths of gtrid and bqual, respectevely.\n\nExamples\n--------\n\n2-phases commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA PREPARE \'test\';\n\nXA COMMIT \'test\';\n\n1-phase commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA COMMIT \'test\' ONE PHASE;\n\nHuman-readable:\n\nxa start \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\ninsert t1 values (40);\n\nxa end \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa prepare \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa recover format=\'RAW\';\n+----------+--------------+--------------+--------------------+\n| formatID | gtrid_length | bqual_length | data               |\n+----------+--------------+--------------+--------------------+\n34      67v78abc       11 |            7 | 12\ndef |\n+----------+--------------+--------------+--------------------+\n\nxa recover format=\'SQL\';\n+----------+--------------+--------------+-------------------------------------\n---------+\n| formatID | gtrid_length | bqual_length | data                               \n     |\n+----------+--------------+--------------+-------------------------------------\n---------+\n|        3 |           11 |            7 |\nX\'31320d3334093637763738\',X\'6162630a646566\',3 |\n+----------+--------------+--------------+-------------------------------------\n---------+\n\nxa rollback X\'31320d3334093637763738\',X\'6162630a646566\',3;\n\nKnown Issues\n------------\n\nMariaDB Galera Cluster\n----------------------\n\nMariaDB Galera Cluster does not support XA transactions.\n\nHowever, MariaDB Galera Cluster builds include a built-in plugin called wsrep.\nPrior to MariaDB 10.4.3, this plugin was internally considered an XA-capable\nstorage engine. Consequently, these MariaDB Galera Cluster builds have\nmultiple XA-capable storage engines by default, even if the only \"real\"\nstorage engine that supports external XA transactions enabled on these builds\nby default is InnoDB. Therefore, when using one these builds MariaDB would be\nforced to use a transaction coordinator log by default, which could have\nperformance implications.\n\nSee Transaction Coordinator Log Overview: MariaDB Galera Cluster for more\ninformation.\n\nURL: https://mariadb.com/kb/en/xa-transactions/','','https://mariadb.com/kb/en/xa-transactions/'),(104,'CREATE USER',10,'Syntax\n------\n\nCREATE [OR REPLACE] USER [IF NOT EXISTS] \n user_specification [,user_specification ...] \n [REQUIRE {NONE | tls_option [[AND] tls_option ...] }]\n [WITH resource_option [resource_option ...] ]\n [lock_option] [password_option]\n\nuser_specification:\n username [authentication_option]\n\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule  ...]\n\nauthentication_rule:\n  authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\ntls_option:\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n\nlock_option:\n  ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n\nDescription\n-----------\n\nThe CREATE USER statement creates new MariaDB accounts. To use it, you must\nhave the global CREATE USER privilege or the INSERT privilege for the mysql\ndatabase. For each account, CREATE USER creates a new row in mysql.user (until\nMariaDB 10.3 this is a table, from MariaDB 10.4 it\'s a view) or\nmysql.global_priv_table (from MariaDB 10.4) that has no privileges.\n\nIf any of the specified accounts, or any permissions for the specified\naccounts, already exist, then the server returns ERROR 1396 (HY000). If an\nerror occurs, CREATE USER will still create the accounts that do not result in\nan error. Only one error is produced for all users which have not been created:\n\nERROR 1396 (HY000): \n Operation CREATE USER failed for \'u1\'@\'%\',\'u2\'@\'%\'\n\nCREATE USER, DROP USER, CREATE ROLE, and DROP ROLE all produce the same error\ncode when they fail.\n\nSee Account Names below for details on how account names are specified.\n\nOR REPLACE\n----------\n\nIf the optional OR REPLACE clause is used, it is basically a shortcut for:\n\nDROP USER IF EXISTS name;\nCREATE USER name ...;\n\nFor example:\n\nCREATE USER foo2@test IDENTIFIED BY \'password\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'foo2\'@\'test\'\n\nCREATE OR REPLACE USER foo2@test IDENTIFIED BY \'password\';\nQuery OK, 0 rows affected (0.00 sec)\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a warning instead\nof an error if the specified user already exists.\n\nFor example:\n\nCREATE USER foo2@test IDENTIFIED BY \'password\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'foo2\'@\'test\'\n\nCREATE USER IF NOT EXISTS foo2@test IDENTIFIED BY \'password\';\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+----------------------------------------------------+\n| Level | Code | Message                                            |\n+-------+------+----------------------------------------------------+\n| Note  | 1973 | Can\'t create user \'foo2\'@\'test\'; it already exists |\n+-------+------+----------------------------------------------------+\n\nAuthentication Options\n----------------------\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored in the\nmysql.user/mysql.global_priv_table table.\n\nFor example, if our password is mariadb, then we can create the user with:\n\nCREATE USER foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD function. It will be stored in the\nmysql.user/mysql.global_priv_table table as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n\nAnd then we can create a user with the hash:\n\nCREATE USER foo2@test IDENTIFIED BY PASSWORD\n\'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nCREATE USER foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nCREATE USER foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nMariaDB starting with 10.4.0\n----------------------------\nThe USING or AS keyword can also be used to provide a plain-text password to a\nplugin if it\'s provided as an argument to the PASSWORD() function. This is\nonly valid for authentication plugins that have implemented a hook for the\nPASSWORD() function. For example, the ed25519 authentication plugin supports\nthis:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nMariaDB starting with 10.4.3\n----------------------------\nOne can specify many authentication plugins, they all work as alternatives\nways of authenticating a user:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\') OR\nunix_socket;\n\nBy default, when you create a user without specifying an authentication\nplugin, MariaDB uses the mysql_native_password plugin.\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can create a user account that requires these TLS options\nwith the following:\n\nCREATE USER \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\'\n AND ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+--------------------------------------+--------------------------------------+\n| Limit Type                           | Decription                           |\n+--------------------------------------+--------------------------------------+\n| MAX_QUERIES_PER_HOUR                 | Number of statements that the        |\n|                                      | account can issue per hour           |\n|                                      | (including updates)                  |\n+--------------------------------------+--------------------------------------+\n| MAX_UPDATES_PER_HOUR                 | Number of updates (not queries)      |\n|                                      | that the account can issue per hour  |\n+--------------------------------------+--------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR             | Number of connections that the       |\n|                                      | account can start per hour           |\n+--------------------------------------+--------------------------------------+\n| MAX_USER_CONNECTIONS                 | Number of simultaneous connections   |\n|                                      | that can be accepted from the same   |\n|                                      | account; if it is 0,                 |\n|                                      | max_connections will be used         |\n|                                      | instead; if max_connections is 0,    |\n|                                      | there is no limit for this           |\n|                                      | account\'s simultaneous connections.  |\n+--------------------------------------+--------------------------------------+\n| MAX_STATEMENT_TIME                   | Timeout, in seconds, for statements  |\n|                                      | executed by the user. See also       |\n|                                      | Aborting Statements that Exceed a    |\n|                                      | Certain Time to Execute.             |\n+--------------------------------------+--------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nHere is an example showing how to create a user with resource limits:\n\nCREATE USER \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 10\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nAccount Names\n-------------\n\nAccount names have both a user name component and a host name component, and\nare specified as \'user_name\'@\'host_name\'.\n\nThe user name and host name may be unquoted, quoted as strings using double\nquotes (\") or single quotes (\'), or quoted as identifiers using backticks (`).\nYou must use quotes when using special characters (such as a hyphen) or\nwildcard characters. If you quote, you must quote the user name and host name\nseparately (for example \'user_name\'@\'host_name\').\n\nHost Name Component\n-------------------\n\nIf the host name is not provided, it is assumed to be \'%\'.\n\nHost names may contain the wildcard characters % and _. They are matched as if\nby the LIKE clause. If you need to use a wildcard character literally (for\nexample, to match a domain name with an underscore), prefix the character with\na backslash. See LIKE for more information on escaping wildcard characters.\n\nHost name matches are case-insensitive. Host names can match either domain\nnames or IP addresses. Use \'localhost\' as the host name to allow only local\nclient connections.\n\nYou can use a netmask to match a range of IP addresses using \'base_ip/netmask\'\nas the host name. A user with an IP address ip_addr will be allowed to connect\nif the following condition is true:\n\nip_addr & netmask = base_ip\n\nFor example, given a user:\n\nCREATE USER \'maria\'@\'247.150.130.0/255.255.255.0\';\n\nthe IP addresses satisfying this condition range from 247.150.130.0 to\n247.150.130.255.\n\nUsing 255.255.255.255 is equivalent to not using a netmask at all. Netmasks\ncannot be used for IPv6 addresses.\n\nNote that the credentials added when creating a user with the \'%\' wildcard\nhost will not grant access in all cases. For example, some systems come with\nan anonymous localhost user, and when connecting from localhost this will take\nprecedence.\n\nBefore MariaDB 10.6, the host name component could be up to 60 characters in\nlength. Starting from MariaDB 10.6, it can be up to 255 characters.\n\nUser Name Component\n-------------------\n\nUser names must match exactly, including case. A user name that is empty is\nknown as an anonymous account and is allowed to match a login attempt with any\nuser name component. These are described more in the next section.\n\nFor valid identifiers to use as user names, see Identifier Names.\n\nIt is possible for more than one account to match when a user connects.\nMariaDB selects the first matching account after sorting according to the\nfollowing criteria:\n\n* Accounts with an exact host name are sorted before accounts using a wildcard\nin the\nhost name. Host names using a netmask are considered to be exact for sorting.\n* Accounts with a wildcard in the host name are sorted according to the\nposition of\nthe first wildcard character. Those with a wildcard character later in the\nhost name\nsort before those with a wildcard character earlier in the host name.\n* Accounts with a non-empty user name sort before accounts with an empty user\nname.\n* Accounts with an empty user name are sorted last. As mentioned previously,\nthese are known as anonymous accounts. These are described more in the next\nsection.\n\nThe following table shows a list of example account as sorted by these\ncriteria:\n\n+---------+-------------+\n| User    | Host        |\n+---------+-------------+\n| joffrey | 192.168.0.3 |\n|         | 192.168.0.% |\n| joffrey | 192.168.%   |\n|         | 192.168.%   |\n+---------+-------------+\n\nOnce connected, you only have the privileges granted to the account that\nmatched, not all accounts that could have matched. For example, consider the\nfollowing commands:\n\nCREATE USER \'joffrey\'@\'192.168.0.3\';\nCREATE USER \'joffrey\'@\'%\';\nGRANT SELECT ON test.t1 to \'joffrey\'@\'192.168.0.3\';\nGRANT SELECT ON test.t2 to \'joffrey\'@\'%\';\n\nIf you connect as joffrey from 192.168.0.3, you will have the SELECT privilege\non the table test.t1, but not on the table test.t2. If you connect as joffrey\nfrom any other IP address, you will have the SELECT privilege on the table\ntest.t2, but not on the table test.t1.\n\nUsernames can be up to 80 characters long before 10.6 and starting from 10.6\nit can be 128 characters long.\n\nAnonymous Accounts\n------------------\n\nAnonymous accounts are accounts where the user name portion of the account\nname is empty. These accounts act as special catch-all accounts. If a user\nattempts to log into the system from a host, and an anonymous account exists\nwith a host name portion that matches the user\'s host, then the user will log\nin as the anonymous account if there is no more specific account match for the\nuser name that the user entered.\n\nFor example, here are some anonymous accounts:\n\nCREATE USER \'\'@\'localhost\';\nCREATE USER \'\'@\'192.168.0.3\';\n\nFixing a Legacy Default Anonymous Account\n-----------------------------------------\n\nOn some systems, the mysql.db table has some entries for the \'\'@\'%\' anonymous\naccount by default. Unfortunately, there is no matching entry in the\nmysql.user/mysql.global_priv_table table, which means that this anonymous\naccount doesn\'t exactly exist, but it does have privileges--usually on the\ndefault test database created by mysql_install_db. These account-less\nprivileges are a legacy that is leftover from a time when MySQL\'s privilege\nsystem was less advanced.\n\nThis situation means that you will run into errors if you try to create a\n\'\'@\'%\' account. For example:\n\nCREATE USER \'\'@\'%\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'\'@\'%\'\n\nThe fix is to DELETE the row in the mysql.db table and then execute FLUSH\nPRIVILEGES:\n\nDELETE FROM mysql.db WHERE User=\'\' AND Host=\'%\';\nFLUSH PRIVILEGES;\n\nAnd then the account can be created:\n\nCREATE USER \'\'@\'%\';\nQuery OK, 0 rows affected (0.01 sec)\n\nSee MDEV-13486 for more information.\n\nPassword Expiry\n---------------\n\nMariaDB starting with 10.4.3\n----------------------------\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal setting, for example:\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\n\nSee User Password Expiry for more details.\n\nAccount Locking\n---------------\n\nMariaDB starting with 10.4.2\n----------------------------\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected). For example:\n\nCREATE USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nSee Account Locking for more details.\n\nFrom MariaDB 10.4.7 and MariaDB 10.5.8, the lock_option and password_option\nclauses can occur in either order.\n\nURL: https://mariadb.com/kb/en/create-user/','','https://mariadb.com/kb/en/create-user/'),(105,'ALTER USER',10,'Syntax\n------\n\nALTER USER [IF EXISTS] \n user_specification [,user_specification] ...\n [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n [WITH resource_option [resource_option] ...]\n [lock_option] [password_option]\n\nuser_specification:\n username [authentication_option]\n\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule] ...\n\nauthentication_rule:\n authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\ntls_option\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nresource_option\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n\nlock_option:\n  ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n\nDescription\n-----------\n\nThe ALTER USER statement modifies existing MariaDB accounts. To use it, you\nmust have the global CREATE USER privilege or the UPDATE privilege for the\nmysql database. The global SUPER privilege is also required if the read_only\nsystem variable is enabled.\n\nIf any of the specified user accounts do not yet exist, an error results. If\nan error occurs, ALTER USER will still modify the accounts that do not result\nin an error. Only one error is produced for all users which have not been\nmodified.\n\nIF EXISTS\n---------\n\nWhen the IF EXISTS clause is used, MariaDB will return a warning instead of an\nerror for each specified user that does not exist.\n\nAccount Names\n-------------\n\nFor ALTER USER statements, account names are specified as the username\nargument in the same way as they are for CREATE USER statements. See account\nnames from the CREATE USER page for details on how account names are specified.\n\nCURRENT_USER or CURRENT_USER() can also be used to alter the account logged\ninto the current session. For example, to change the current user\'s password\nto mariadb:\n\nALTER USER CURRENT_USER() IDENTIFIED BY \'mariadb\';\n\nAuthentication Options\n----------------------\n\nMariaDB starting with 10.4\n--------------------------\nFrom MariaDB 10.4, it is possible to use more than one authentication plugin\nfor each user account. For example, this can be useful to slowly migrate users\nto the more secure ed25519 authentication plugin over time, while allowing the\nold mysql_native_password authentication plugin as an alternative for the\ntransitional period. See Authentication from MariaDB 10.4 for more.\n\nWhen running ALTER USER, not specifying an authentication option in the\nIDENTIFIED VIA clause will remove that authentication method. (However this\nwas not the case before MariaDB 10.4.13, see MDEV-21928)\n\nFor example, a user is created with the ability to authenticate via both a\npassword and unix_socket:\n\nCREATE USER \'bob\'@\'localhost\' \n IDENTIFIED VIA mysql_native_password USING PASSWORD(\'pwd\')\n OR unix_socket;\n\nSHOW CREATE USER \'bob\'@\'localhost\'\\G\n*************************** 1. row ***************************\nCREATE USER for bob@localhost: CREATE USER `bob`@`localhost` \n IDENTIFIED VIA mysql_native_password\n USING \'*975B2CD4FF9AE554FE8AD33168FBFC326D2021DD\'\n OR unix_socket\n\nIf the user\'s password is updated, but unix_socket authentication is not\nspecified in the IDENTIFIED VIA clause, unix_socket authentication will no\nlonger be permitted.\n\nALTER USER \'bob\'@\'localhost\' IDENTIFIED VIA mysql_native_password \n USING PASSWORD(\'pwd2\');\n\nSHOW CREATE USER \'bob\'@\'localhost\'\\G\n*************************** 1. row ***************************\nCREATE USER for bob@localhost: CREATE USER `bob`@`localhost` \n IDENTIFIED BY PASSWORD \'*38366FDA01695B6A5A9DD4E428D9FB8F7EB75512\'\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored to the mysql.user table.\n\nFor example, if our password is mariadb, then we can set the account\'s\npassword with:\n\nALTER USER foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD#function. It will be stored to the\nmysql.user table as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n\nAnd then we can set an account\'s password with the hash:\n\nALTER USER foo2@test \n IDENTIFIED BY PASSWORD \'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nALTER USER foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nALTER USER foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nIn MariaDB 10.4 and later, the USING or AS keyword can also be used to provide\na plain-text password to a plugin if it\'s provided as an argument to the\nPASSWORD() function. This is only valid for authentication plugins that have\nimplemented a hook for the PASSWORD() function. For example, the ed25519\nauthentication plugin supports this:\n\nALTER USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can alter a user account to require these TLS options with\nthe following:\n\nALTER USER \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\' AND\n ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+------------------------------------+---------------------------------------+\n| Limit Type                         | Description                           |\n+------------------------------------+---------------------------------------+\n| MAX_QUERIES_PER_HOUR               | Number of statements that the         |\n|                                    | account can issue per hour            |\n|                                    | (including updates)                   |\n+------------------------------------+---------------------------------------+\n| MAX_UPDATES_PER_HOUR               | Number of updates (not queries) that  |\n|                                    | the account can issue per hour        |\n+------------------------------------+---------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR           | Number of connections that the        |\n|                                    | account can start per hour            |\n+------------------------------------+---------------------------------------+\n| MAX_USER_CONNECTIONS               | Number of simultaneous connections    |\n|                                    | that can be accepted from the same    |\n|                                    | account; if it is 0, max_connections  |\n|                                    | will be used instead; if              |\n|                                    | max_connections is 0, there is no     |\n|                                    | limit for this account\'s              |\n|                                    | simultaneous connections.             |\n+------------------------------------+---------------------------------------+\n| MAX_STATEMENT_TIME                 | Timeout, in seconds, for statements   |\n|                                    | executed by the user. See also        |\n|                                    | Aborting Statements that Exceed a     |\n|                                    | Certain Time to Execute.              |\n+------------------------------------+---------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nHere is an example showing how to set an account\'s resource limits:\n\nALTER USER \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 10\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nPassword Expiry\n---------------\n\nMariaDB starting with 10.4.3\n----------------------------\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal setting, for example:\n\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE NEVER;\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n\nSee User Password Expiry for more details.\n\nAccount Locking\n---------------\n\nMariaDB starting with 10.4.2\n----------------------------\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected). For example:\n\nALTER USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nSee Account Locking for more details.\n\nFrom MariaDB 10.4.7 and MariaDB 10.5.8, the lock_option and password_option\nclauses can occur in either order.\n\nURL: https://mariadb.com/kb/en/alter-user/','','https://mariadb.com/kb/en/alter-user/'),(107,'GRANT',10,'Syntax\n------\n\nGRANT\n  priv_type [(column_list)]\n   [, priv_type [(column_list)]] ...\n  ON [object_type] priv_level\n  TO user_specification [ user_options ...]\n\nuser_specification:\n username [authentication_option]\n | PUBLIC\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule  ...]\n\nauthentication_rule:\n  authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\nGRANT PROXY ON username\n  TO user_specification [, user_specification ...]\n  [WITH GRANT OPTION]\n\nGRANT rolename TO grantee [, grantee ...]\n  [WITH ADMIN OPTION]\n\ngrantee:\n  rolename\n  username [authentication_option]\n\nuser_options:\n  [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n  [WITH with_option [with_option] ...]\n\nobject_type:\n  TABLE\n | FUNCTION\n | PROCEDURE\n | PACKAGE\n\npriv_level:\n  *\n | *.*\n | db_name.*\n | db_name.tbl_name\n | tbl_name\n | db_name.routine_name\n\nwith_option:\n  GRANT OPTION\n | resource_option\n\nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\ntls_option:\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nDescription\n-----------\n\nThe GRANT statement allows you to grant privileges or roles to accounts. To\nuse GRANT, you must have the GRANT OPTION privilege, and you must have the\nprivileges that you are granting.\n\nUse the REVOKE statement to revoke privileges granted with the GRANT statement.\n\nUse the SHOW GRANTS statement to determine what privileges an account has.\n\nAccount Names\n-------------\n\nFor GRANT statements, account names are specified as the username argument in\nthe same way as they are for CREATE USER statements. See account names from\nthe CREATE USER page for details on how account names are specified.\n\nImplicit Account Creation\n-------------------------\n\nThe GRANT statement also allows you to implicitly create accounts in some\ncases.\n\nIf the account does not yet exist, then GRANT can implicitly create it. To\nimplicitly create an account with GRANT, a user is required to have the same\nprivileges that would be required to explicitly create the account with the\nCREATE USER statement.\n\nIf the NO_AUTO_CREATE_USER SQL_MODE is set, then accounts can only be created\nif authentication information is specified, or with a CREATE USER statement.\nIf no authentication information is provided, GRANT will produce an error when\nthe specified account does not exist, for example:\n\nshow variables like \'%sql_mode%\' ;\n+---------------+--------------------------------------------+\n| Variable_name | Value                                      |\n+---------------+--------------------------------------------+\n| sql_mode      | NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION |\n+---------------+--------------------------------------------+\n\nGRANT USAGE ON *.* TO \'user123\'@\'%\' IDENTIFIED BY \'\';\nERROR 1133 (28000): Can\'t find any matching row in the user table\n\nGRANT USAGE ON *.* TO \'user123\'@\'%\' \n IDENTIFIED VIA PAM using \'mariadb\' require ssl ;\nQuery OK, 0 rows affected (0.00 sec)\n\nselect host, user from mysql.user where user=\'user123\' ;\n\n+------+----------+\n| host | user     |\n+------+----------+\n| %    | user123 |\n+------+----------+\n\nPrivilege Levels\n----------------\n\nPrivileges can be set globally, for an entire database, for a table or\nroutine, or for individual columns in a table. Certain privileges can only be\nset at certain levels.\n\n* Global privileges priv_type are granted using *.* for\npriv_level. Global privileges include privileges to administer the database\nand manage user accounts, as well as privileges for all tables, functions, and\nprocedures. Global privileges are stored in the mysql.user table prior to\nMariaDB 10.4, and in  mysql.global_priv table afterwards.\n* Database privileges priv_type are granted using db_name.*\nfor priv_level, or using just * to use default database. Database\nprivileges include privileges to create tables and functions, as well as\nprivileges for all tables, functions, and procedures in the database. Database\nprivileges are stored in the mysql.db table.\n* Table privileges priv_type are granted using db_name.tbl_name\nfor priv_level, or using just tbl_name to specify a table in the default\ndatabase. The TABLE keyword is optional. Table privileges include the\nability to select and change data in the table. Certain table privileges can\nbe granted for individual columns.\n* Column privileges priv_type are granted by specifying a table for\npriv_level and providing a column list after the privilege type. They allow\nyou to control exactly which columns in a table users can select and change.\n* Function privileges priv_type are granted using FUNCTION db_name.routine_name\nfor priv_level, or using just  FUNCTION routine_name to specify a function\nin the default database.\n* Procedure privileges priv_type are granted using PROCEDURE\ndb_name.routine_name\nfor priv_level, or using just PROCEDURE routine_name to specify a procedure\nin the default database.\n\nThe USAGE Privilege\n-------------------\n\nThe USAGE privilege grants no real privileges. The SHOW GRANTS statement will\nshow a global USAGE privilege for a newly-created user. You can use USAGE with\nthe GRANT statement to change options like GRANT OPTION and\nMAX_USER_CONNECTIONS without changing any account privileges.\n\nThe ALL PRIVILEGES Privilege\n----------------------------\n\nThe ALL PRIVILEGES privilege grants all available privileges. Granting all\nprivileges only affects the given privilege level. For example, granting all\nprivileges on a table does not grant any privileges on the database or\nglobally.\n\nUsing ALL PRIVILEGES does not grant the special GRANT OPTION privilege.\n\nYou can use ALL instead of ALL PRIVILEGES.\n\nThe GRANT OPTION Privilege\n--------------------------\n\nUse the WITH GRANT OPTION clause to give users the ability to grant privileges\nto other users at the given privilege level. Users with the GRANT OPTION\nprivilege can only grant privileges they have. They cannot grant privileges at\na higher privilege level than they have the GRANT OPTION privilege.\n\nThe GRANT OPTION privilege cannot be set for individual columns. If you use\nWITH GRANT OPTION when specifying column privileges, the GRANT OPTION\nprivilege will be granted for the entire table.\n\nUsing the WITH GRANT OPTION clause is equivalent to listing GRANT OPTION as a\nprivilege.\n\nGlobal Privileges\n-----------------\n\nThe following table lists the privileges that can be granted globally. You can\nalso grant all database, table, and function privileges globally. When granted\nglobally, these privileges apply to all databases, tables, or functions,\nincluding those created later.\n\nTo set a global privilege, use *.* for priv_level.\n\nBINLOG ADMIN\n------------\n\nEnables administration of the binary log, including the PURGE BINARY LOGS\nstatement and setting the system variables:\n\n* binlog_annotate_row_events\n* binlog_cache_size\n* binlog_commit_wait_count\n* binlog_commit_wait_usec\n* binlog_direct_non_transactional_updates\n* binlog_expire_logs_seconds\n* binlog_file_cache_size\n* binlog_format\n* binlog_row_image\n* binlog_row_metadata\n* binlog_stmt_cache_size\n* expire_logs_days\n* log_bin_compress\n* log_bin_compress_min_len\n* log_bin_trust_function_creators\n* max_binlog_cache_size\n* max_binlog_size\n* max_binlog_stmt_cache_size\n* sql_log_bin and\n* sync_binlog.\n\nAdded in MariaDB 10.5.2.\n\nBINLOG MONITOR\n--------------\n\nNew name for REPLICATION CLIENT from MariaDB 10.5.2, (REPLICATION CLIENT still\nsupported as an alias for compatibility purposes). Permits running SHOW\ncommands related to the binary log, in particular the SHOW BINLOG STATUS and\nSHOW BINARY LOGS statements. Unlike REPLICATION CLIENT prior to MariaDB 10.5,\nSHOW REPLICA STATUS isn\'t included in this privilege, and REPLICA MONITOR is\nrequired.\n\nBINLOG REPLAY\n-------------\n\nEnables replaying the binary log with the BINLOG statement (generated by\nmariadb-binlog), executing SET timestamp when secure_timestamp is set to\nreplication, and setting the session values of system variables usually\nincluded in BINLOG output, in particular:\n\n* gtid_domain_id\n* gtid_seq_no\n* pseudo_thread_id\n* server_id.\n\nAdded in MariaDB 10.5.2\n\nCONNECTION ADMIN\n----------------\n\nEnables administering connection resource limit options. This includes\nignoring the limits specified by:\n\n* max_connections\n* max_user_connections and\n* max_password_errors.\n\nThe statements specified in init_connect are not executed, killing connections\nand queries owned by other users is permitted. The following\nconnection-related system variables can be changed:\n\n* connect_timeout\n* disconnect_on_expired_password\n* extra_max_connections\n* init_connect\n* max_connections\n* max_connect_errors\n* max_password_errors\n* proxy_protocol_networks\n* secure_auth\n* slow_launch_time\n* thread_pool_exact_stats\n* thread_pool_dedicated_listener\n* thread_pool_idle_timeout\n* thread_pool_max_threads\n* thread_pool_min_threads\n* thread_pool_oversubscribe\n* thread_pool_prio_kickup_timer\n* thread_pool_priority\n* thread_pool_size, and\n* thread_pool_stall_limit.\n\nAdded in MariaDB 10.5.2.\n\nCREATE USER\n-----------\n\nCreate a user using the CREATE USER statement, or implicitly create a user\nwith the GRANT statement.\n\nFEDERATED ADMIN\n---------------\n\nExecute CREATE SERVER, ALTER SERVER, and DROP SERVER statements. Added in\nMariaDB 10.5.2.\n\nFILE\n----\n\nRead and write files on the server, using statements like LOAD DATA INFILE or\nfunctions like LOAD_FILE(). Also needed to create CONNECT outward tables.\nMariaDB server must have the permissions to access those files.\n\nGRANT OPTION\n------------\n\nGrant global privileges. You can only grant privileges that you have.\n\nPROCESS\n-------\n\nShow information about the active processes, for example via SHOW PROCESSLIST\nor mysqladmin processlist. If you have the PROCESS privilege, you can see all\nthreads. Otherwise, you can see only your own threads (that is, threads\nassociated with the MariaDB account that you are using).\n\nREAD_ONLY ADMIN\n---------------\n\nUser can set the read_only system variable and allows the user to perform\nwrite operations, even when the read_only option is active. Added in MariaDB\n10.5.2.\n\nFrom MariaDB 10.11.0, the READ_ONLY ADMIN privilege has been removed from\nSUPER. The benefit of this is that one can remove the READ_ONLY ADMIN\nprivilege from all users and ensure that no one can make any changes on any\nnon-temporary tables. This is useful on replicas when one wants to ensure that\nthe replica is kept identical to the primary.\n\nRELOAD\n------\n\nExecute FLUSH statements or equivalent mariadb-admin/mysqladmin commands.\n\nREPLICATION CLIENT\n------------------\n\nExecute SHOW MASTER STATUS and SHOW BINARY LOGS informative statements.\nRenamed to BINLOG MONITOR in MariaDB 10.5.2 (but still supported as an alias\nfor compatibility reasons). SHOW SLAVE STATUS was part of REPLICATION CLIENT\nprior to MariaDB 10.5.\n\nREPLICATION MASTER ADMIN\n------------------------\n\nPermits administration of primary servers, including the SHOW REPLICA HOSTS\nstatement, and setting the gtid_binlog_state, gtid_domain_id,\nmaster_verify_checksum and server_id system variables. Added in MariaDB 10.5.2.\n\nREPLICA MONITOR\n---------------\n\nPermit SHOW REPLICA STATUS and SHOW RELAYLOG EVENTS. From MariaDB 10.5.9.\n\nWhen a user would upgrade from an older major release to a MariaDB 10.5 minor\nrelease prior to MariaDB 10.5.9, certain user accounts would lose\ncapabilities. For example, a user account that had the REPLICATION CLIENT\nprivilege in older major releases could run SHOW REPLICA STATUS, but after\nupgrading to a MariaDB 10.5 minor release prior to MariaDB 10.5.9, they could\nno longer run SHOW REPLICA STATUS, because that statement was changed to\nrequire the REPLICATION REPLICA ADMIN privilege.\n\nThis issue is fixed in MariaDB 10.5.9 with this new privilege, which now\ngrants the user the ability to execute SHOW [ALL] (SLAVE | REPLICA) STATUS.\n\nWhen a database is upgraded from an older major release to MariaDB Server\n10.5.9 or later, any user accounts with the REPLICATION CLIENT or REPLICATION\nSLAVE privileges will automatically be granted the new REPLICA MONITOR\nprivilege. The privilege fix occurs when the server is started up, not when\nmariadb-upgrade is performed.\n\nHowever, when a database is upgraded from an early 10.5 minor release to\n10.5.9 and later, the user will have to fix any user account privileges\nmanually.\n\nREPLICATION REPLICA\n-------------------\n\nSynonym for REPLICATION SLAVE. From MariaDB 10.5.1.\n\nREPLICATION SLAVE\n-----------------\n\nAccounts used by replica servers on the primary need this privilege. This is\nneeded to get the updates made on the master. From MariaDB 10.5.1, REPLICATION\nREPLICA is an alias for REPLICATION SLAVE.\n\nREPLICATION SLAVE ADMIN\n-----------------------\n\nPermits administering replica servers, including START REPLICA/SLAVE, STOP\nREPLICA/SLAVE, CHANGE MASTER, SHOW REPLICA/SLAVE STATUS, SHOW RELAYLOG EVENTS\nstatements, replaying the binary log with the BINLOG statement (generated by\nmariadb-binlog), and setting the system variables:\n\n* gtid_cleanup_batch_size\n* gtid_ignore_duplicates\n* gtid_pos_auto_engines\n* gtid_slave_pos\n* gtid_strict_mode\n* init_slave\n* read_binlog_speed_limit\n* relay_log_purge\n* relay_log_recovery\n* replicate_do_db\n* replicate_do_table\n* replicate_events_marked_for_skip\n* replicate_ignore_db\n* replicate_ignore_table\n* replicate_wild_do_table\n* replicate_wild_ignore_table\n* slave_compressed_protocol\n* slave_ddl_exec_mode\n* slave_domain_parallel_threads\n* slave_exec_mode\n* slave_max_allowed_packet\n* slave_net_timeout\n* slave_parallel_max_queued\n* slave_parallel_mode\n* slave_parallel_threads\n* slave_parallel_workers\n* slave_run_triggers_for_rbr\n* slave_sql_verify_checksum\n* slave_transaction_retry_interval\n* slave_type_conversions\n* sync_master_info\n* sync_relay_log, and\n* sync_relay_log_info.\n\nAdded in MariaDB 10.5.2.\n\nSET USER\n--------\n\nEnables setting the DEFINER when creating triggers, views, stored functions\nand stored procedures. Added in MariaDB 10.5.2.\n\nSHOW DATABASES\n--------------\n\nList all databases using the SHOW DATABASES statement. Without the SHOW\nDATABASES privilege, you can still issue the SHOW DATABASES statement, but it\nwill only list databases containing tables on which you have privileges.\n\nSHUTDOWN\n--------\n\nShut down the server using SHUTDOWN or the mysqladmin shutdown command.\n\nSUPER\n-----\n\nExecute superuser statements: CHANGE MASTER TO, KILL (users who do not have\nthis privilege can only KILL their own threads), PURGE LOGS, SET global system\nvariables, or the mysqladmin debug command. Also, this permission allows the\nuser to write data even if the read_only startup option is set, enable or\ndisable logging, enable or disable replication on replica, specify a DEFINER\nfor statements that support that clause, connect once reaching the\nMAX_CONNECTIONS. If a statement has been specified for the init-connect mysqld\noption, that command will not be executed when a user with SUPER privileges\nconnects to the server.\n\nThe SUPER privilege has been split into multiple smaller privileges from\nMariaDB 10.5.2 to allow for more fine-grained privileges, although it remains\nan alias for these smaller privileges.\n\nFrom MariaDB 10.11.0, the READ_ONLY ADMIN privilege has been removed from\nSUPER. The benefit of this is that one can remove the READ_ONLY ADMIN\nprivilege from all users and ensure that no one can make any changes on any\nnon-temporary tables. This is useful on replicas when one wants to ensure that\nthe replica is kept identical to the primary.\n\nDatabase Privileges\n-------------------\n\nThe following table lists the privileges that can be granted at the database\nlevel. You can also grant all table and function privileges at the database\nlevel. Table and function privileges on a database apply to all tables or\nfunctions in that database, including those created later.\n\nTo set a privilege for a database, specify the database using db_name.* for\npriv_level, or just use * to specify the default database.\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| CREATE                           | Create a database using the CREATE      |\n|                                  | DATABASE statement, when the privilege  |\n|                                  | is granted for a database. You can      |\n|                                  | grant the CREATE privilege on           |\n|                                  | databases that do not yet exist. This   |\n|                                  | also grants the CREATE privilege on     |\n|                                  | all tables in the database.             |\n+----------------------------------+-----------------------------------------+\n| CREATE ROUTINE                   | Create Stored Programs using the        |\n|                                  | CREATE PROCEDURE and CREATE FUNCTION    |\n|                                  | statements.                             |\n+----------------------------------+-----------------------------------------+\n| CREATE TEMPORARY TABLES          | Create temporary tables with the        |\n|                                  | CREATE TEMPORARY TABLE statement. This  |\n|                                  | privilege enable writing and dropping   |\n|                                  | those temporary tables                  |\n+----------------------------------+-----------------------------------------+\n| DROP                             | Drop a database using the DROP          |\n|                                  | DATABASE statement, when the privilege  |\n|                                  | is granted for a database. This also    |\n|                                  | grants the DROP privilege on all        |\n|                                  | tables in the database.                 |\n+----------------------------------+-----------------------------------------+\n| EVENT                            | Create, drop and alter EVENTs.          |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant database privileges. You can      |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n| LOCK TABLES                      | Acquire explicit locks using the LOCK   |\n|                                  | TABLES statement; you also need to      |\n|                                  | have the SELECT privilege on a table,   |\n|                                  | in order to lock it.                    |\n+----------------------------------+-----------------------------------------+\n\nTable Privileges\n----------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER                            | Change the structure of an existing     |\n|                                  | table using the ALTER TABLE statement.  |\n+----------------------------------+-----------------------------------------+\n| CREATE                           | Create a table using the CREATE TABLE   |\n|                                  | statement.  You can grant the CREATE    |\n|                                  | privilege on tables that do not yet     |\n|                                  | exist.                                  |\n+----------------------------------+-----------------------------------------+\n| CREATE VIEW                      | Create a view using the CREATE_VIEW     |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| DELETE                           | Remove rows from a table using the      |\n|                                  | DELETE statement.                       |\n+----------------------------------+-----------------------------------------+\n| DELETE HISTORY                   | Remove historical rows from a table     |\n|                                  | using the DELETE HISTORY statement.     |\n|                                  | Displays as DELETE VERSIONING ROWS      |\n|                                  | when running SHOW GRANTS until MariaDB  |\n|                                  | 10.3.15 and until MariaDB 10.4.5        |\n|                                  | (MDEV-17655), or when running SHOW      |\n|                                  | PRIVILEGES until MariaDB 10.5.2,        |\n|                                  | MariaDB 10.4.13 and MariaDB 10.3.23     |\n|                                  | (MDEV-20382). From MariaDB 10.3.4.      |\n|                                  | From MariaDB 10.3.5, if a user has the  |\n|                                  | SUPER privilege but not this            |\n|                                  | privilege, running mysql_upgrade will   |\n|                                  | grant this privilege as well.           |\n+----------------------------------+-----------------------------------------+\n| DROP                             | Drop a table using the DROP TABLE       |\n|                                  | statement or a view using the DROP      |\n|                                  | VIEW statement. Also required to        |\n|                                  | execute the TRUNCATE TABLE statement.   |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant table privileges. You can only    |\n|                                  | grant privileges that you have.         |\n+----------------------------------+-----------------------------------------+\n| INDEX                            | Create an index on a table using the    |\n|                                  | CREATE INDEX statement. Without the     |\n|                                  | INDEX privilege, you can still create   |\n|                                  | indexes when creating a table using     |\n|                                  | the CREATE TABLE statement if the you   |\n|                                  | have the CREATE privilege, and you can  |\n|                                  | create indexes using the ALTER TABLE    |\n|                                  | statement if you have the ALTER         |\n|                                  | privilege.                              |\n+----------------------------------+-----------------------------------------+\n| INSERT                           | Add rows to a table using the INSERT    |\n|                                  | statement.  The INSERT privilege can    |\n|                                  | also be set on individual columns; see  |\n|                                  | Column Privileges below for details.    |\n+----------------------------------+-----------------------------------------+\n| REFERENCES                       | Unused.                                 |\n+----------------------------------+-----------------------------------------+\n| SELECT                           | Read data from a table using the        |\n|                                  | SELECT statement. The SELECT privilege  |\n|                                  | can also be set on individual columns;  |\n|                                  | see Column Privileges below for         |\n|                                  | details.                                |\n+----------------------------------+-----------------------------------------+\n| SHOW VIEW                        | Show the CREATE VIEW statement to       |\n|                                  | create a view using the SHOW CREATE     |\n|                                  | VIEW statement.                         |\n+----------------------------------+-----------------------------------------+\n| TRIGGER                          | Execute triggers associated to tables   |\n|                                  | you update, execute the CREATE TRIGGER  |\n|                                  | and DROP TRIGGER statements. You will   |\n|                                  | still be able to see triggers.          |\n+----------------------------------+-----------------------------------------+\n| UPDATE                           | Update existing rows in a table using   |\n|                                  | the UPDATE statement. UPDATE            |\n|                                  | statements usually include a WHERE      |\n|                                  | clause to update only certain rows.     |\n|                                  | You must have SELECT privileges on the  |\n|                                  | table or the appropriate columns for    |\n|                                  | the WHERE clause. The UPDATE privilege  |\n|                                  | can also be set on individual columns;  |\n|                                  | see Column Privileges below for         |\n|                                  | details.                                |\n+----------------------------------+-----------------------------------------+\n\nColumn Privileges\n-----------------\n\nSome table privileges can be set for individual columns of a table. To use\ncolumn privileges, specify the table explicitly and provide a list of column\nnames after the privilege type. For example, the following statement would\nallow the user to read the names and positions of employees, but not other\ninformation from the same table, such as salaries.\n\nGRANT SELECT (name, position) on Employee to \'jeffrey\'@\'localhost\';\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| INSERT (column_list)             | Add rows specifying values in columns   |\n|                                  | using the INSERT statement. If you      |\n|                                  | only have column-level INSERT           |\n|                                  | privileges, you must specify the        |\n|                                  | columns you are setting in the INSERT   |\n|                                  | statement. All other columns will be    |\n|                                  | set to their default values, or NULL.   |\n+----------------------------------+-----------------------------------------+\n| REFERENCES (column_list)         | Unused.                                 |\n+----------------------------------+-----------------------------------------+\n| SELECT (column_list)             | Read values in columns using the        |\n|                                  | SELECT statement. You cannot access or  |\n|                                  | query any columns for which you do not  |\n|                                  | have SELECT privileges, including in    |\n|                                  | WHERE, ON, GROUP BY, and ORDER BY       |\n|                                  | clauses.                                |\n+----------------------------------+-----------------------------------------+\n| UPDATE (column_list)             | Update values in columns of existing    |\n|                                  | rows using the UPDATE statement.        |\n|                                  | UPDATE statements usually include a     |\n|                                  | WHERE clause to update only certain     |\n|                                  | rows. You must have SELECT privileges   |\n|                                  | on the table or the appropriate         |\n|                                  | columns for the WHERE clause.           |\n+----------------------------------+-----------------------------------------+\n\nFunction Privileges\n-------------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER ROUTINE                    | Change the characteristics of a stored  |\n|                                  | function using the ALTER FUNCTION       |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| EXECUTE                          | Use a stored function. You need SELECT  |\n|                                  | privileges for any tables or columns    |\n|                                  | accessed by the function.               |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant function privileges. You can      |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n\nProcedure Privileges\n--------------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER ROUTINE                    | Change the characteristics of a stored  |\n|                                  | procedure using the ALTER PROCEDURE     |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| EXECUTE                          | Execute a stored procedure using the    |\n|                                  | CALL statement. The privilege to call   |\n|                                  | a procedure may allow you to perform    |\n|                                  | actions you wouldn\'t otherwise be able  |\n|                                  | to do, such as insert rows into a       |\n|                                  | table.                                  |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant procedure privileges. You can     |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n\nGRANT EXECUTE ON PROCEDURE mysql.create_db TO maintainer;\n\nProxy Privileges\n----------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| PROXY                            | Permits one user to be a proxy for      |\n|                                  | another.                                |\n+----------------------------------+-----------------------------------------+\n\nThe PROXY privilege allows one user to proxy as another user, which means\ntheir privileges change to that of the proxy user, and the CURRENT_USER()\nfunction returns the user name of the proxy user.\n\nThe PROXY privilege only works with authentication plugins that support it.\nThe default mysql_native_password authentication plugin does not support proxy\nusers.\n\nThe pam authentication plugin is the only plugin included with MariaDB that\ncurrently supports proxy users. The PROXY privilege is commonly used with the\npam authentication plugin to enable user and group mapping with PAM.\n\nFor example, to grant the PROXY privilege to an anonymous account that\nauthenticates with the pam authentication plugin, you could execute the\nfollowing:\n\nCREATE USER \'dba\'@\'%\' IDENTIFIED BY \'strongpassword\';\nGRANT ALL PRIVILEGES ON *.* TO \'dba\'@\'%\' ;\n\nCREATE USER \'\'@\'%\' IDENTIFIED VIA pam USING \'mariadb\';\nGRANT PROXY ON \'dba\'@\'%\' TO \'\'@\'%\';\n\nA user account can only grant the PROXY privilege for a specific user account\nif the granter also has the PROXY privilege for that specific user account,\nand if that privilege is defined WITH GRANT OPTION. For example, the following\nexample fails because the granter does not have the PROXY privilege for that\nspecific user account at all:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------+\n| Grants for alice@localhost                                                  \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' |\n+------------------------------------------------------------------------------\n----------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nERROR 1698 (28000): Access denied for user \'alice\'@\'localhost\'\n\nAnd the following example fails because the granter does have the PROXY\nprivilege for that specific user account, but it is not defined WITH GRANT\nOPTION:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------+\n| Grants for alice@localhost                                                  \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' |\n| GRANT PROXY ON \'dba\'@\'localhost\' TO \'alice\'@\'localhost\'                     \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nERROR 1698 (28000): Access denied for user \'alice\'@\'localhost\'\n\nBut the following example succeeds because the granter does have the PROXY\nprivilege for that specific user account, and it is defined WITH GRANT OPTION:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| Grants for alice@localhost                                                  \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' WITH GRANT OPTION |\n| GRANT PROXY ON \'dba\'@\'localhost\' TO \'alice\'@\'localhost\' WITH GRANT OPTION   \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\n\nA user account can grant the PROXY privilege for any other user account if the\ngranter has the PROXY privilege for the \'\'@\'%\' anonymous user account, like\nthis:\n\nGRANT PROXY ON \'\'@\'%\' TO \'dba\'@\'localhost\' WITH GRANT OPTION;\n\nFor example, the following example succeeds because the user can grant the\nPROXY privilege for any other user account:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| Grants for alice@localhost                                                  \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' WITH GRANT OPTION |\n| GRANT PROXY ON \'\'@\'%\' TO \'alice\'@\'localhost\' WITH GRANT OPTION              \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n\nGRANT PROXY ON \'app1_dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nQuery OK, 0 rows affected (0.004 sec)\n\nGRANT PROXY ON \'app2_dba\'@\'localhost\' TO \'carol\'@\'localhost\';\nQuery OK, 0 rows affected (0.004 sec)\n\nThe default root user accounts created by mysql_install_db have this\nprivilege. For example:\n\nGRANT ALL PRIVILEGES ON *.* TO \'root\'@\'localhost\' WITH GRANT OPTION;\nGRANT PROXY ON \'\'@\'%\' TO \'root\'@\'localhost\' WITH GRANT OPTION;\n\nThis allows the default root user accounts to grant the PROXY privilege for\nany other user account, and it also allows the default root user accounts to\ngrant others the privilege to do the same.\n\nAuthentication Options\n----------------------\n\nThe authentication options for the GRANT statement are the same as those for\nthe CREATE USER statement.\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored.\n\nFor example, if our password is mariadb, then we can create the user with:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nIf the user account already exists and if you provide the IDENTIFIED BY\nclause, then the user\'s password will be changed. You must have the privileges\nneeded for the SET PASSWORD statement to change a user\'s password with GRANT.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD function. It will be stored as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n\nAnd then we can create a user with the hash:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED BY \n PASSWORD \'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nIf the user account already exists and if you provide the IDENTIFIED BY\nclause, then the user\'s password will be changed. You must have the privileges\nneeded for the SET PASSWORD statement to change a user\'s password with GRANT.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nMariaDB starting with 10.4.0\n----------------------------\nThe USING or AS keyword can also be used to provide a plain-text password to a\nplugin if it\'s provided as an argument to the PASSWORD() function. This is\nonly valid for authentication plugins that have implemented a hook for the\nPASSWORD() function. For example, the ed25519 authentication plugin supports\nthis:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 \n USING PASSWORD(\'secret\');\n\nMariaDB starting with 10.4.3\n----------------------------\nOne can specify many authentication plugins, they all work as alternatives\nways of authenticating a user:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 \n USING PASSWORD(\'secret\') OR unix_socket;\n\nBy default, when you create a user without specifying an authentication\nplugin, MariaDB uses the mysql_native_password plugin.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+--------------------------------------+--------------------------------------+\n| Limit Type                           | Decription                           |\n+--------------------------------------+--------------------------------------+\n| MAX_QUERIES_PER_HOUR                 | Number of statements that the        |\n|                                      | account can issue per hour           |\n|                                      | (including updates)                  |\n+--------------------------------------+--------------------------------------+\n| MAX_UPDATES_PER_HOUR                 | Number of updates (not queries)      |\n|                                      | that the account can issue per hour  |\n+--------------------------------------+--------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR             | Number of connections that the       |\n|                                      | account can start per hour           |\n+--------------------------------------+--------------------------------------+\n| MAX_USER_CONNECTIONS                 | Number of simultaneous connections   |\n|                                      | that can be accepted from the same   |\n|                                      | account; if it is 0,                 |\n|                                      | max_connections will be used         |\n|                                      | instead; if max_connections is 0,    |\n|                                      | there is no limit for this           |\n|                                      | account\'s simultaneous connections.  |\n+--------------------------------------+--------------------------------------+\n| MAX_STATEMENT_TIME                   | Timeout, in seconds, for statements  |\n|                                      | executed by the user. See also       |\n|                                      | Aborting Statements that Exceed a    |\n|                                      | Certain Time to Execute.             |\n+--------------------------------------+--------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nTo set resource limits for an account, if you do not want to change that\naccount\'s privileges, you can issue a GRANT statement with the USAGE\nprivilege, which has no meaning. The statement can name some or all limit\ntypes, in any order.\n\nHere is an example showing how to set resource limits:\n\nGRANT USAGE ON *.* TO \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 0\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nUsers with the CONNECTION ADMIN privilege (in MariaDB 10.5.2 and later) or the\nSUPER privilege are not restricted by max_user_connections, max_connections,\nor max_password_errors.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can create a user account that requires these TLS options\nwith the following:\n\nGRANT USAGE ON *.* TO \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\'\n AND ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nRoles\n-----\n\nSyntax\n------\n\nGRANT role TO grantee [, grantee ... ]\n[ WITH ADMIN OPTION ]\n\ngrantee:\n  rolename\n  username [authentication_option]\n\nThe GRANT statement is also used to grant the use of a role to one or more\nusers or other roles. In order to be able to grant a role, the grantor doing\nso must have permission to do so (see WITH ADMIN in the CREATE ROLE article).\n\nSpecifying the WITH ADMIN OPTION permits the grantee to in turn grant the role\nto another.\n\nFor example, the following commands show how to grant the same role to a\ncouple different users.\n\nGRANT journalist TO hulda;\n\nGRANT journalist TO berengar WITH ADMIN OPTION;\n\nIf a user has been granted a role, they do not automatically obtain all\npermissions associated with that role. These permissions are only in use when\nthe user activates the role with the SET ROLE statement.\n\nTO PUBLIC\n---------\n\nMariaDB starting with 10.11\n---------------------------\n\nSyntax\n------\n\nGRANT <privilege> ON <database>.<object> TO PUBLIC;\nREVOKE <privilege> ON <database>.<object> FROM PUBLIC;\n\nGRANT ... TO PUBLIC grants privileges to all users with access to the server.\nThe privileges also apply to users created after the privileges are granted.\nThis can be useful when one only wants to state once that all users need to\nhave a certain set of privileges.\n\nWhen running SHOW GRANTS, a user will also see all privileges inherited from\nPUBLIC. SHOW GRANTS FOR PUBLIC will only show TO PUBLIC grants.\n\nGrant Examples\n--------------\n\nGranting Root-like Privileges\n-----------------------------\n\nYou can create a user that has privileges similar to the default root accounts\nby executing the following:\n\nCREATE USER \'alexander\'@\'localhost\';\nGRANT ALL PRIVILEGES ON  *.* to \'alexander\'@\'localhost\' WITH GRANT OPTION;\n\nURL: https://mariadb.com/kb/en/grant/','','https://mariadb.com/kb/en/grant/'),(117,'Authentication from MariaDB 10.4',10,'MariaDB starting with 10.4\n--------------------------\nMariaDB 10.4 introduced a number of changes to the authentication process,\nintended to make things easier and more intuitive.\n\nOverview\n--------\n\nThere are four new main features in 10.4 relating to authentication:\n\n* It is possible to use more than one authentication plugin for each user\naccount. For example, this can be useful to slowly migrate users to the more\nsecure ed25519 authentication plugin over time, while allowing the old\nmysql_native_password authentication plugin as an alternative for the\ntransitional period.\n* The root@localhost user account created by mysql_install_db is created with\nthe ability to use two authentication plugins.\nFirst, it is configured to try to use the unix_socket authentication plugin.\nThis allows the root@localhost user to login without a password via the local\nUnix socket file defined by the socket system variable, as long as the login\nis attempted from a process owned by the operating system root user account.\nSecond, if authentication fails with the unix_socket authentication plugin,\nthen it is configured to try to use the mysql_native_password authentication\nplugin. However, an invalid password is initially set, so in order to\nauthenticate this way, a password must be set with SET PASSWORD.\nHowever, just using the unix_socket authentication plugin may be fine for many\nusers, and it is very secure. You may want to try going without password\nauthentication to see how well it works for you. Remember, the best way to\nkeep your password safe is not to have one!\n\n* All user accounts, passwords, and global privileges are now stored in the\nmysql.global_priv table. The mysql.user table still exists and has exactly the\nsame set of columns as before, but it’s now a view that references the\nmysql.global_priv table. Tools that analyze the mysql.user table should\ncontinue to work as before. From MariaDB 10.4.13, the dedicated mariadb.sys\nuser is created as the definer of this view. Previously root was the definer,\nwhich resulted in privilege problems when this username was changed.\n* MariaDB 10.4 adds supports for User Password Expiry, which is not active by\ndefault.\n\nDescription\n-----------\n\nAs a result of the above changes, the open-for-everyone all-powerful root\naccount is finally gone. And installation scripts will no longer demand that\nyou \"PLEASE REMEMBER TO SET A PASSWORD FOR THE MariaDB root USER !\", because\nthe root account is securely created automatically.\n\nTwo all-powerful accounts are created by default — root and the OS user that\nowns the data directory, typically mysql. They are created as:\n\nCREATE USER root@localhost IDENTIFIED VIA unix_socket OR mysql_native_password\nUSING \'invalid\'\nCREATE USER mysql@localhost IDENTIFIED VIA unix_socket OR\nmysql_native_password USING \'invalid\'\n\nUsing unix_socket means that if you are the system root user, you can login as\nroot@locahost without a password. This technique was pioneered by Otto\nKekäläinen in Debian MariaDB packages and has been successfully used in Debian\nsince as early as MariaDB 10.0.\n\nIt is based on a simple fact that asking the system root for a password adds\nno extra security — root has full access to all the data files and all process\nmemory anyway. But not asking for a password means, there is no root password\nto forget (no need for the numerous tutorials on \"how to reset MariaDB root\npassword\"). And if you want to script some tedious database work, there is no\nneed to store the root password in plain text for the script to use (no need\nfor debian-sys-maint user).\n\nStill, some users may wish to log in as MariaDB root without using sudo. Hence\nthe old authentication method — conventional MariaDB password — is still\navailable. By default it is disabled (\"invalid\" is not a valid password hash),\nbut one can set the password with a usual SET PASSWORD statement. And still\nretain the password-less access via sudo.\n\nIf you install MariaDB locally (say from a tarball), you would not want to use\nsudo to be able to login. This is why MariaDB creates a second all-powerful\nuser with the same name as a system user that owns the data directory. In\nlocal (not system-wide) installations, this will be the user who installed\nMariaDB — they automatically get convenient password-less root-like access,\nbecause they can access all the data files anyway.\n\nEven if MariaDB is installed system-wide, you may not want to run your\ndatabase maintenance scripts as system root — now you can run them as system\nmysql user. And you will know that they will never destroy your entire system,\neven if you make a typo in a shell script.\n\nHowever, seasoned MariaDB DBAs who are used to the old ways do need to make\nsome changes. See the examples below for common tasks.\n\nCookbook\n--------\n\nAfter installing MariaDB system-wide the first thing you’ve got used to doing\nis logging in into the unprotected root account and protecting it, that is,\nsetting the root password:\n\n$ sudo dnf install MariaDB-server\n$ mysql -uroot\n...\nMariaDB> set password = password(\"XH4VmT3_jt\");\n\nThis is not only unnecessary now, it will simply not work — there is no\nunprotected root account. To login as root use\n\n$ sudo dnf install MariaDB-server\n$ sudo mysql\n\nNote that it implies you are connecting via the unix socket, not tcp. If you\nhappen to have protocol=tcp in a system-wide /etc/my.cnf file, use sudo mysql\n--protocol=socket.\n\nAfter installing MariaDB locally you’ve also used to connect to the\nunprotected root account using mysql -uroot. This will not work either, simply\nuse mysql without specifying a username.\n\nIf you\'ve forgotten your root password, no problem — you can still connect\nusing sudo and change the password. And if you\'ve also removed unix_socket\nauthentication, to restore access do as follows:\n\n* restart MariaDB with --skip-grant-tables\n* login into the unprotected server\n* run FLUSH PRIVILEGES (note, before 10.4 this would’ve been the last step,\nnot anymore). This disables --skip-grant-tables and allows you to change the\nstored authentication method\n* run SET PASSWORD FOR root@localhost to change the root password.\n\nTo view inside privilege tables, the old mysql.user table still exists. You\ncan select from it as before, although you cannot update it anymore. It\ndoesn’t show alternative authentication plugins and this was one of the\nreasons for switching to the mysql.global_priv table — complex authentication\nrules did not fit into rigid structure of a relational table. You can select\nfrom the new table, for example:\n\nselect concat(user, \'@\', host, \' => \', json_detailed(priv)) from\nmysql.global_priv;\n\nReverting to the Previous Authentication Method for root@localhost\n------------------------------------------------------------------\n\nIf you don\'t want the root@localhost user account created by mysql_install_db\nto use unix_socket authentication by default, then there are a few ways to\nrevert to the previous mysql_native_password authentication method for this\nuser account.\n\nConfiguring mysql_install_db to Revert to the Previous Authentication Method\n----------------------------------------------------------------------------\n\nOne way to revert to the previous mysql_native_password authentication method\nfor the root@localhost user account is to execute mysql_install_db with a\nspecial option. If mysql_install_db is executed while\n--auth-root-authentication-method=normal is specified, then it will create the\ndefault user accounts using the default behavior of MariaDB 10.3 and before.\n\nThis means that the root@localhost user account will use mysql_native_password\nauthentication by default. There are some other differences as well. See\nmysql_install_db: User Accounts Created by Default for more information.\n\nFor example, the option can be set on the command-line while running\nmysql_install_db:\n\nmysql_install_db --user=mysql --datadir=/var/lib/mysql\n--auth-root-authentication-method=normal\n\nThe option can also be set in an option file in an option group supported by\nmysql_install_db. For example:\n\n[mysql_install_db]\nauth_root_authentication_method=normal\n\nIf the option is set in an option file and if mysql_install_db is executed,\nthen mysql_install_db will read this option from the option file, and it will\nautomatically set this option.\n\nAltering the User Account to Revert to the Previous Authentication Method\n-------------------------------------------------------------------------\n\nIf you have already installed MariaDB, and if the root@localhost user account\nis already using unix_socket authentication, then you can revert to the old\nmysql_native_password authentication method for the user account by executing\nthe following:\n\nALTER USER root@localhost IDENTIFIED VIA mysql_native_password USING\nPASSWORD(\"verysecret\")\n\nURL: https://mariadb.com/kb/en/authentication-from-mariadb-104/','','https://mariadb.com/kb/en/authentication-from-mariadb-104/'),(119,'ST_X',11,'Syntax\n------\n\nST_X(p)\nX(p)\n\nDescription\n-----------\n\nReturns the X-coordinate value for the point p as a double-precision number.\n\nST_X() and X() are synonyms.\n\nExamples\n--------\n\nSET @pt = \'Point(56.7 53.34)\';\n\nSELECT X(GeomFromText(@pt));\n+----------------------+\n| X(GeomFromText(@pt)) |\n+----------------------+\n|                 56.7 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/st_x/','','https://mariadb.com/kb/en/st_x/'),(88,'IF Function',7,'Syntax\n------\n\nIF(expr1,expr2,expr3)\n\nDescription\n-----------\n\nIf expr1 is TRUE (expr1 <> 0 and expr1 <> NULL) then IF() returns expr2;\notherwise it returns expr3. IF() returns a numeric or string value, depending\non the context in which it is used.\n\nNote: There is also an IF statement which differs from the IF() function\ndescribed here.\n\nExamples\n--------\n\nSELECT IF(1>2,2,3);\n+-------------+\n| IF(1>2,2,3) |\n+-------------+\n|           3 |\n+-------------+\n\nSELECT IF(1<2,\'yes\',\'no\');\n+--------------------+\n| IF(1<2,\'yes\',\'no\') |\n+--------------------+\n| yes                |\n+--------------------+\n\nSELECT IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\');\n+---------------------------------------+\n| IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\') |\n+---------------------------------------+\n| no                                    |\n+---------------------------------------+\n\nURL: https://mariadb.com/kb/en/if-function/','','https://mariadb.com/kb/en/if-function/'),(89,'IFNULL',7,'Syntax\n------\n\nIFNULL(expr1,expr2)\nNVL(expr1,expr2)\n\nDescription\n-----------\n\nIf expr1 is not NULL, IFNULL() returns expr1; otherwise it returns expr2.\nIFNULL() returns a numeric or string value, depending on the context in which\nit is used.\n\nFrom MariaDB 10.3, NVL() is an alias for IFNULL().\n\nExamples\n--------\n\nSELECT IFNULL(1,0); \n+-------------+\n| IFNULL(1,0) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT IFNULL(NULL,10);\n+-----------------+\n| IFNULL(NULL,10) |\n+-----------------+\n|              10 |\n+-----------------+\n\nSELECT IFNULL(1/0,10);\n+----------------+\n| IFNULL(1/0,10) |\n+----------------+\n|        10.0000 |\n+----------------+\n\nSELECT IFNULL(1/0,\'yes\');\n+-------------------+\n| IFNULL(1/0,\'yes\') |\n+-------------------+\n| yes               |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/ifnull/','','https://mariadb.com/kb/en/ifnull/'),(94,'START TRANSACTION',8,'Syntax\n------\n\nSTART TRANSACTION [transaction_property [, transaction_property] ...] | BEGIN\n[WORK]\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nROLLBACK [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nSET autocommit = {0 | 1}\n\ntransaction_property:\n  WITH CONSISTENT SNAPSHOT\n | READ WRITE\n | READ ONLY\n\nDescription\n-----------\n\nThe START TRANSACTION or BEGIN statement begins a new transaction. COMMIT\ncommits the current transaction, making its changes permanent. ROLLBACK rolls\nback the current transaction, canceling its changes. The SET autocommit\nstatement disables or enables the default autocommit mode for the current\nsession.\n\nSTART TRANSACTION and SET autocommit = 1 implicitly commit the current\ntransaction, if any.\n\nThe optional WORK keyword is supported for COMMIT and ROLLBACK, as are the\nCHAIN and RELEASE clauses. CHAIN and RELEASE can be used for additional\ncontrol over transaction completion. The value of the completion_type system\nvariable determines the default completion behavior.\n\nThe AND CHAIN clause causes a new transaction to begin as soon as the current\none ends, and the new transaction has the same isolation level as the\njust-terminated transaction. The RELEASE clause causes the server to\ndisconnect the current client session after terminating the current\ntransaction. Including the NO keyword suppresses CHAIN or RELEASE completion,\nwhich can be useful if the completion_type system variable is set to cause\nchaining or release completion by default.\n\nAccess Mode\n-----------\n\nThe access mode specifies whether the transaction is allowed to write data or\nnot. By default, transactions are in READ WRITE mode (see the tx_read_only\nsystem variable). READ ONLY mode allows the storage engine to apply\noptimizations that cannot be used for transactions which write data. The only\nexception to this rule is that read only transactions can perform DDL\nstatements on temporary tables.\n\nIt is not permitted to specify both READ WRITE and READ ONLY in the same\nstatement.\n\nREAD WRITE and READ ONLY can also be specified in the SET TRANSACTION\nstatement, in which case the specified mode is valid for all sessions, or for\nall subsequent transaction used by the current session.\n\nautocommit\n----------\n\nBy default, MariaDB runs with autocommit mode enabled. This means that as soon\nas you execute a statement that updates (modifies) a table, MariaDB stores the\nupdate on disk to make it permanent. To disable autocommit mode, use the\nfollowing statement:\n\nSET autocommit=0;\n\nAfter disabling autocommit mode by setting the autocommit variable to zero,\nchanges to transaction-safe tables (such as those for InnoDB or NDBCLUSTER)\nare not made permanent immediately. You must use COMMIT to store your changes\nto disk or ROLLBACK to ignore the changes.\n\nTo disable autocommit mode for a single series of statements, use the START\nTRANSACTION statement.\n\nDDL Statements\n--------------\n\nDDL statements (CREATE, ALTER, DROP) and administrative statements (FLUSH,\nRESET, OPTIMIZE, ANALYZE, CHECK, REPAIR, CACHE INDEX), transaction management\nstatements (BEGIN, START TRANSACTION) and LOAD DATA INFILE, cause an implicit\nCOMMIT and start a new transaction. An exception to this rule are the DDL that\noperate on temporary tables: you can CREATE, ALTER and DROP them without\ncausing any COMMIT, but those actions cannot be rolled back. This means that\nif you call ROLLBACK, the temporary tables you created in the transaction will\nremain, while the rest of the transaction will be rolled back.\n\nTransactions cannot be used in Stored Functions or Triggers. In Stored\nProcedures and Events BEGIN is not allowed, so you should use START\nTRANSACTION instead.\n\nA transaction acquires a metadata lock on every table it accesses to prevent\nother connections from altering their structure. The lock is released at the\nend of the transaction. This happens even with non-transactional storage\nengines (like MEMORY or CONNECT), so it makes sense to use transactions with\nnon-transactional tables.\n\nin_transaction\n--------------\n\nThe in_transaction system variable is a session-only, read-only variable that\nreturns 1 inside a transaction, and 0 if not in a transaction.\n\nWITH CONSISTENT SNAPSHOT\n------------------------\n\nThe WITH CONSISTENT SNAPSHOT option starts a consistent read for storage\nengines such as InnoDB that can do so, the same as if a START TRANSACTION\nfollowed by a SELECT from any InnoDB table was issued.\n\nSee Enhancements for START TRANSACTION WITH CONSISTENT SNAPSHOT.\n\nExamples\n--------\n\nSTART TRANSACTION;\nSELECT @A:=SUM(salary) FROM table1 WHERE type=1;\nUPDATE table2 SET summary=@A WHERE type=1;\nCOMMIT;\n\nURL: https://mariadb.com/kb/en/start-transaction/','','https://mariadb.com/kb/en/start-transaction/'),(120,'ST_Y',11,'Syntax\n------\n\nST_Y(p)\nY(p)\n\nDescription\n-----------\n\nReturns the Y-coordinate value for the point p as a double-precision number.\n\nST_Y() and Y() are synonyms.\n\nExamples\n--------\n\nSET @pt = \'Point(56.7 53.34)\';\n\nSELECT Y(GeomFromText(@pt));\n+----------------------+\n| Y(GeomFromText(@pt)) |\n+----------------------+\n|                53.34 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/st_y/','','https://mariadb.com/kb/en/st_y/'),(121,'X',11,'A synonym for ST_X.\n\nURL: https://mariadb.com/kb/en/point-properties-x/','','https://mariadb.com/kb/en/point-properties-x/'),(122,'Y',11,'A synonym for ST_Y.\n\nURL: https://mariadb.com/kb/en/point-properties-y/','','https://mariadb.com/kb/en/point-properties-y/'),(125,'DECODE_ORACLE',12,'MariaDB starting with 10.3.2\n----------------------------\nDECODE_ORACLE is a synonym for the Oracle mode version of the DECODE function,\nand is available in all modes.\n\nURL: https://mariadb.com/kb/en/decode_oracle/','','https://mariadb.com/kb/en/decode_oracle/'),(93,'SET TRANSACTION',8,'Syntax\n------\n\nSET [GLOBAL | SESSION] TRANSACTION\n  transaction_property [, transaction_property] ...\n\ntransaction_property:\n  ISOLATION LEVEL level\n | READ WRITE\n | READ ONLY\n\nlevel:\n  REPEATABLE READ\n | READ COMMITTED\n | READ UNCOMMITTED\n | SERIALIZABLE\n\nDescription\n-----------\n\nThis statement sets the transaction isolation level or the transaction access\nmode globally, for the current session, or for the next transaction:\n\n* With the GLOBAL keyword, the statement sets the default\n transaction level globally for all subsequent sessions. Existing sessions are\n unaffected.\n* With the SESSION keyword, the statement sets the default\n transaction level for all subsequent transactions performed within the\n current session.\n* Without any SESSION or GLOBAL keyword,\n the statement sets the isolation level for the next (not started) transaction\n performed within the current session.\n\nA change to the global default isolation level requires the SUPER privilege.\nAny session is free to change its session isolation level (even in the middle\nof a transaction), or the isolation level for its next transaction.\n\nIsolation Level\n---------------\n\nTo set the global default isolation level at server startup, use the\n--transaction-isolation=level option on the command line or in an option file.\nValues of level for this option use dashes rather than spaces, so the\nallowable values are READ-UNCOMMITTED, READ-COMMITTED, REPEATABLE-READ, or\nSERIALIZABLE. For example, to set the default isolation level to REPEATABLE\nREAD, use these lines in the [mysqld] section of an option file:\n\n[mysqld]\ntransaction-isolation = REPEATABLE-READ\nTo determine the global and session transaction isolation levels at runtime,\ncheck the value of the tx_isolation system variable:\n\nSELECT @@GLOBAL.tx_isolation, @@tx_isolation;\n\nInnoDB supports each of the translation isolation levels described here using\ndifferent locking strategies. The default level is REPEATABLE READ. For\nadditional information about InnoDB record-level locks and how it uses them to\nexecute various types of statements, see InnoDB Lock Modes, and\nhttp://dev.mysql.com/doc/refman/en/innodb-locks-set.html.\n\nIsolation Levels\n----------------\n\nThe following sections describe how MariaDB supports the different transaction\nlevels.\n\nREAD UNCOMMITTED\n----------------\n\nSELECT statements are performed in a non-locking fashion, but a possible\nearlier version of a row might be used. Thus, using this isolation level, such\nreads are not consistent. This is also called a \"dirty read.\" Otherwise, this\nisolation level works like READ COMMITTED.\n\nREAD COMMITTED\n--------------\n\nA somewhat Oracle-like isolation level with respect to consistent\n(non-locking) reads: Each consistent read, even within the same transaction,\nsets and reads its own fresh snapshot. See\nhttp://dev.mysql.com/doc/refman/en/innodb-consistent-read.html.\n\nFor locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE), InnoDB locks\nonly index records, not the gaps before them, and thus allows the free\ninsertion of new records next to locked records. For UPDATE and DELETE\nstatements, locking depends on whether the statement uses a unique index with\na unique search condition (such as WHERE id = 100), or a range-type search\ncondition (such as WHERE id > 100). For a unique index with a unique search\ncondition, InnoDB locks only the index record found, not the gap before it.\nFor range-type searches, InnoDB locks the index range scanned, using gap locks\nor next-key (gap plus index-record) locks to block insertions by other\nsessions into the gaps covered by the range. This is necessary because\n\"phantom rows\" must be blocked for MySQL replication and recovery to work.\n\nNote: If the READ COMMITTED isolation level is used or the\ninnodb_locks_unsafe_for_binlog system variable is enabled, there is no InnoDB\ngap locking except for foreign-key constraint checking and duplicate-key\nchecking. Also, record locks for non-matching rows are released after MariaDB\nhas evaluated the WHERE condition.If you use READ COMMITTED or enable\ninnodb_locks_unsafe_for_binlog, you must use row-based binary logging.\n\nREPEATABLE READ\n---------------\n\nThis is the default isolation level for InnoDB. For consistent reads, there is\nan important difference from the READ COMMITTED isolation level: All\nconsistent reads within the same transaction read the snapshot established by\nthe first read. This convention means that if you issue several plain\n(non-locking) SELECT statements within the same transaction, these SELECT\nstatements are consistent also with respect to each other. See\nhttp://dev.mysql.com/doc/refman/en/innodb-consistent-read.html.\n\nFor locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE), UPDATE, and\nDELETE statements, locking depends on whether the statement uses a unique\nindex with a unique search condition, or a range-type search condition. For a\nunique index with a unique search condition, InnoDB locks only the index\nrecord found, not the gap before it. For other search conditions, InnoDB locks\nthe index range scanned, using gap locks or next-key (gap plus index-record)\nlocks to block insertions by other sessions into the gaps covered by the range.\n\nThis is the minimum isolation level for non-distributed XA transactions.\n\nSERIALIZABLE\n------------\n\nThis level is like REPEATABLE READ, but InnoDB implicitly converts all plain\nSELECT statements to SELECT ... LOCK IN SHARE MODE if autocommit is disabled.\nIf autocommit is enabled, the SELECT is its own transaction. It therefore is\nknown to be read only and can be serialized if performed as a consistent\n(non-locking) read and need not block for other transactions. (This means that\nto force a plain SELECT to block if other transactions have modified the\nselected rows, you should disable autocommit.)\n\nDistributed XA transactions should always use this isolation level.\n\nAccess Mode\n-----------\n\nThe access mode specifies whether the transaction is allowed to write data or\nnot. By default, transactions are in READ WRITE mode (see the tx_read_only\nsystem variable). READ ONLY mode allows the storage engine to apply\noptimizations that cannot be used for transactions which write data. The only\nexception to this rule is that read only transactions can perform DDL\nstatements on temporary tables.\n\nIt is not permitted to specify both READ WRITE and READ ONLY in the same\nstatement.\n\nREAD WRITE and READ ONLY can also be specified in the START TRANSACTION\nstatement, in which case the specified mode is only valid for one transaction.\n\nExamples\n--------\n\nSET GLOBAL TRANSACTION ISOLATION LEVEL SERIALIZABLE;\n\nAttempting to set the isolation level within an existing transaction without\nspecifying GLOBAL or SESSION.\n\nSTART TRANSACTION;\n\nSET TRANSACTION ISOLATION LEVEL SERIALIZABLE;\nERROR 1568 (25001): Transaction characteristics can\'t be changed while a\ntransaction is in progress\n\nURL: https://mariadb.com/kb/en/set-transaction/','','https://mariadb.com/kb/en/set-transaction/'),(126,'AES_DECRYPT',12,'Syntax\n------\n\nAES_DECRYPT(crypt_str,key_str)\n\nDescription\n-----------\n\nThis function allows decryption of data using the official AES (Advanced\nEncryption Standard) algorithm. For more information, see the description of\nAES_ENCRYPT().\n\nURL: https://mariadb.com/kb/en/aes_decrypt/','','https://mariadb.com/kb/en/aes_decrypt/'),(133,'MD5',12,'Syntax\n------\n\nMD5(str)\n\nDescription\n-----------\n\nCalculates an MD5 128-bit checksum for the string.\n\nThe return value is a 32-hex digit string, and as of MariaDB 5.5, is a\nnonbinary string in the connection character set and collation, determined by\nthe values of the character_set_connection and collation_connection system\nvariables. Before 5.5, the return value was a binary string.\n\nNULL is returned if the argument was NULL.\n\nExamples\n--------\n\nSELECT MD5(\'testing\');\n+----------------------------------+\n| MD5(\'testing\')                   |\n+----------------------------------+\n| ae2b1fca515949e5d54fb22b8ed95575 |\n+----------------------------------+\n\nURL: https://mariadb.com/kb/en/md5/','','https://mariadb.com/kb/en/md5/'),(95,'COMMIT',8,'The COMMIT statement ends a transaction, saving any changes to the data so\nthat they become visible to subsequent transactions. Also, unlocks metadata\nchanged by current transaction. If autocommit is set to 1, an implicit commit\nis performed after each statement. Otherwise, all transactions which don\'t end\nwith an explicit COMMIT are implicitly rollbacked and the changes are lost.\nThe ROLLBACK statement can be used to do this explicitly.\n\nThe required syntax for the COMMIT statement is as follows:\n\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\n\nCOMMIT is the more important transaction terminator, as well as the more\ninteresting one. The basic form of the COMMIT statement is simply the keyword\nCOMMIT (the keyword WORK is simply noise and can be omitted without changing\nthe effect).\n\nThe optional AND CHAIN clause is a convenience for initiating a new\ntransaction as soon as the old transaction terminates. If AND CHAIN is\nspecified, then there is effectively nothing between the old and new\ntransactions, although they remain separate. The characteristics of the new\ntransaction will be the same as the characteristics of the old one — that is,\nthe new transaction will have the same access mode, isolation level and\ndiagnostics area size (we\'ll discuss all of these shortly) as the transaction\njust terminated.\n\nRELEASE tells the server to disconnect the client immediately after the\ncurrent transaction.\n\nThere are NO RELEASE and AND NO CHAIN options. By default, commits do not\nRELEASE or CHAIN, but it\'s possible to change this default behavior with the\ncompletion_type server system variable. In this case, the AND NO CHAIN and NO\nRELEASE options override the server default.\n\nURL: https://mariadb.com/kb/en/commit/','','https://mariadb.com/kb/en/commit/'),(96,'ROLLBACK',8,'The ROLLBACK statement rolls back (ends) a transaction, destroying any changes\nto SQL-data so that they never become visible to subsequent transactions. The\nrequired syntax for the ROLLBACK statement is as follows.\n\nROLLBACK [ WORK ] [ AND [ NO ] CHAIN ] \n[ TO [ SAVEPOINT ] {<savepoint name> | <simple target specification>} ]\n\nThe ROLLBACK statement will either end a transaction, destroying all data\nchanges that happened during any of the transaction, or it will just destroy\nany data changes that happened since you established a savepoint. The basic\nform of the ROLLBACK statement is just the keyword ROLLBACK (the keyword WORK\nis simply noise and can be omitted without changing the effect).\n\nThe optional AND CHAIN clause is a convenience for initiating a new\ntransaction as soon as the old transaction terminates. If AND CHAIN is\nspecified, then there is effectively nothing between the old and new\ntransactions, although they remain separate. The characteristics of the new\ntransaction will be the same as the characteristics of the old one — that is,\nthe new transaction will have the same access mode, isolation level and\ndiagnostics area size (we\'ll discuss all of these shortly) as the transaction\njust terminated. The AND NO CHAIN option just tells your DBMS to end the\ntransaction — that is, these four SQL statements are equivalent:\n\nROLLBACK; \nROLLBACK WORK; \nROLLBACK AND NO CHAIN; \nROLLBACK WORK AND NO CHAIN;\n\nAll of them end a transaction without saving any transaction characteristics.\nThe only other options, the equivalent statements:\n\nROLLBACK AND CHAIN;\nROLLBACK WORK AND CHAIN;\n\nboth tell your DBMS to end a transaction, but to save that transaction\'s\ncharacteristics for the next transaction.\n\nROLLBACK is much simpler than COMMIT: it may involve no more than a few\ndeletions (of Cursors, locks, prepared SQL statements and log-file entries).\nIt\'s usually assumed that ROLLBACK can\'t fail, although such a thing is\nconceivable (for example, an encompassing transaction might reject an attempt\nto ROLLBACK because it\'s lining up for a COMMIT).\n\nROLLBACK cancels all effects of a transaction. It does not cancel effects on\nobjects outside the DBMS\'s control (for example the values in host program\nvariables or the settings made by some SQL/CLI function calls). But in\ngeneral, it is a convenient statement for those situations when you say \"oops,\nthis isn\'t working\" or when you simply don\'t care whether your temporary work\nbecomes permanent or not.\n\nHere is a moot question. If all you\'ve been doing is SELECTs, so that there\nhave been no data changes, should you end the transaction with ROLLBACK or\nCOMMIT? It shouldn\'t really matter because both ROLLBACK and COMMIT do the\nsame transaction-terminating job. However, the popular conception is that\nROLLBACK implies failure, so after a successful series of SELECT statements\nthe convention is to end the transaction with COMMIT rather than ROLLBACK.\n\nMariaDB (and most other DBMSs) supports rollback of SQL-data change\nstatements, but not of SQL-Schema statements. This means that if you use any\nof CREATE, ALTER, DROP, GRANT, REVOKE, you are implicitly committing at\nexecution time.\n\nINSERT INTO Table_2 VALUES(5); \nDROP TABLE Table_3 CASCADE; \nROLLBACK;\n\nThe result will be that both the INSERT and the DROP will go through as\nseparate transactions so the ROLLBACK will have no effect.\n\nURL: https://mariadb.com/kb/en/rollback/','','https://mariadb.com/kb/en/rollback/'),(138,'ENDPOINT',13,'A synonym for ST_ENDPOINT.\n\nURL: https://mariadb.com/kb/en/linestring-properties-endpoint/','','https://mariadb.com/kb/en/linestring-properties-endpoint/'),(139,'GLENGTH',13,'Syntax\n------\n\nGLength(ls)\n\nDescription\n-----------\n\nReturns as a double-precision number the length of the LineString value ls in\nits associated spatial reference.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT GLength(GeomFromText(@ls));\n+----------------------------+\n| GLength(GeomFromText(@ls)) |\n+----------------------------+\n|           2.82842712474619 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/glength/','','https://mariadb.com/kb/en/glength/'),(140,'NumPoints',13,'A synonym for ST_NumPoints.\n\nURL: https://mariadb.com/kb/en/linestring-properties-numpoints/','','https://mariadb.com/kb/en/linestring-properties-numpoints/'),(141,'PointN',13,'A synonym for ST_PointN.\n\nURL: https://mariadb.com/kb/en/linestring-properties-pointn/','','https://mariadb.com/kb/en/linestring-properties-pointn/'),(142,'STARTPOINT',13,'A synonym for ST_STARTPOINT.\n\nURL: https://mariadb.com/kb/en/linestring-properties-startpoint/','','https://mariadb.com/kb/en/linestring-properties-startpoint/'),(143,'ST_ENDPOINT',13,'Syntax\n------\n\nST_EndPoint(ls)\nEndPoint(ls)\n\nDescription\n-----------\n\nReturns the Point that is the endpoint of the LineString value ls.\n\nST_EndPoint() and EndPoint() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(EndPoint(GeomFromText(@ls)));\n+-------------------------------------+\n| AsText(EndPoint(GeomFromText(@ls))) |\n+-------------------------------------+\n| POINT(3 3)                          |\n+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_endpoint/','','https://mariadb.com/kb/en/st_endpoint/'),(144,'ST_NUMPOINTS',13,'Syntax\n------\n\nST_NumPoints(ls)\nNumPoints(ls)\n\nDescription\n-----------\n\nReturns the number of Point objects in the LineString value ls.\n\nST_NumPoints() and NumPoints() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT NumPoints(GeomFr