/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `barbican`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `barbican` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `barbican`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('8c74e2d7f1ff');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authorities`
--

DROP TABLE IF EXISTS `certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `plugin_ca_id` text NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cas_project_fk` (`project_id`),
  CONSTRAINT `cas_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authorities`
--

LOCK TABLES `certificate_authorities` WRITE;
/*!40000 ALTER TABLE `certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authority_metadata`
--

DROP TABLE IF EXISTS `certificate_authority_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authority_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_certificate_authority_metadatum_uc` (`ca_id`,`key`),
  KEY `ix_certificate_authority_metadata_ca_id` (`ca_id`),
  KEY `ix_certificate_authority_metadata_key` (`key`),
  CONSTRAINT `certificate_authority_metadata_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authority_metadata`
--

LOCK TABLES `certificate_authority_metadata` WRITE;
/*!40000 ALTER TABLE `certificate_authority_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authority_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acl_users`
--

DROP TABLE IF EXISTS `container_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_container_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `container_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `container_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acl_users`
--

LOCK TABLES `container_acl_users` WRITE;
/*!40000 ALTER TABLE `container_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acls`
--

DROP TABLE IF EXISTS `container_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_operation_uc` (`container_id`,`operation`),
  KEY `ix_container_acls_container_id` (`container_id`),
  CONSTRAINT `container_acls_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acls`
--

LOCK TABLES `container_acls` WRITE;
/*!40000 ALTER TABLE `container_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_consumer_metadata`
--

DROP TABLE IF EXISTS `container_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `name` varchar(36) DEFAULT NULL,
  `URL` varchar(255) DEFAULT NULL,
  `data_hash` char(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_consumer_hashed_container_name_url_uc` (`data_hash`),
  KEY `ix_container_consumer_metadata_container_id` (`container_id`),
  KEY `ix_container_consumer_metadata_project_id` (`project_id`),
  KEY `values_index` (`container_id`,`name`,`URL`),
  CONSTRAINT `container_consumer_metadata_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_consumer_metadata_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_consumer_metadata`
--

LOCK TABLES `container_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `container_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_secret`
--

DROP TABLE IF EXISTS `container_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_secret` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `container_id` varchar(36) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_secret_name_uc` (`container_id`,`secret_id`,`name`),
  KEY `ix_container_secret_container_id` (`container_id`),
  KEY `ix_container_secret_secret_id` (`secret_id`),
  CONSTRAINT `container_secret_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_secret_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_secret`
--

LOCK TABLES `container_secret` WRITE;
/*!40000 ALTER TABLE `container_secret` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `containers`
--

DROP TABLE IF EXISTS `containers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `containers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('generic','rsa','dsa','certificate') DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_containers_project_id` (`project_id`),
  CONSTRAINT `containers_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `containers`
--

LOCK TABLES `containers` WRITE;
/*!40000 ALTER TABLE `containers` DISABLE KEYS */;
/*!40000 ALTER TABLE `containers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encrypted_data`
--

DROP TABLE IF EXISTS `encrypted_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encrypted_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `secret_id` varchar(36) NOT NULL,
  `kek_id` varchar(36) NOT NULL,
  `cypher_text` text DEFAULT NULL,
  `kek_meta_extended` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_encrypted_data_kek_id` (`kek_id`),
  KEY `ix_encrypted_data_secret_id` (`secret_id`),
  CONSTRAINT `encrypted_data_ibfk_1` FOREIGN KEY (`kek_id`) REFERENCES `kek_data` (`id`),
  CONSTRAINT `encrypted_data_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encrypted_data`
--

LOCK TABLES `encrypted_data` WRITE;
/*!40000 ALTER TABLE `encrypted_data` DISABLE KEYS */;
INSERT INTO `encrypted_data` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `content_type`, `secret_id`, `kek_id`, `cypher_text`, `kek_meta_extended`) VALUES ('371d2839-86ca-4ac9-8535-2e51dd097382','2026-01-20 15:06:38','2026-01-20 15:07:47','2026-01-20 15:07:47',1,'ACTIVE','application/octet-stream','44fbaa9e-d63a-4bf0-9535-e5558eaaa7e4','bc03a41e-43e9-4252-a395-a876f36a72a8','Z0FBQUFBQnBiNW4tQW9hWmE1d1lCSFV0TnBGeGN4dnYweEJ5WnVMeE80SVF0VGFyMXYxYndSNjFJOThGd2NBQ0FIaFdRSkxkZWdMMjR3U2ZIMGxUbnAyWkM5OFBvdi12UXlWY1NueFRUcUdvcXN6Z3o3eHFtVHE1dGtjOVFsOWtWRl9MVHpHeVJNSU0=',NULL),('493b807f-bff1-4b8a-b860-147b5988c92c','2026-01-20 15:09:49','2026-01-20 15:10:23','2026-01-20 15:10:23',1,'ACTIVE','application/octet-stream','349091f0-57cd-4e7a-b935-410f986b1500','6cd1eeaf-a419-458b-94ba-3f74929f1452','Z0FBQUFBQnBiNXE5VGZ4Y2hYWm5vUkE4MGh6ZllWVDRQOGlxTzgxQTlZa3Z5alpjN1lKcnB0M0xkTlJhYWpUOHVrSkozQjZhVDdzd25VYmplYjc4Z01BTUQwUnZPX1JPcFhORFpwdXhqcnpsUFA3eXphYTg3a2I2MDlGSDRJeExUS0p4dWJwRmp3OWo=',NULL);
/*!40000 ALTER TABLE `encrypted_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kek_data`
--

DROP TABLE IF EXISTS `kek_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kek_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `kek_label` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `bind_completed` tinyint(1) NOT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `plugin_meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_kek_data_project_id` (`project_id`),
  CONSTRAINT `kek_data_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kek_data`
--

LOCK TABLES `kek_data` WRITE;
/*!40000 ALTER TABLE `kek_data` DISABLE KEYS */;
INSERT INTO `kek_data` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `plugin_name`, `kek_label`, `project_id`, `active`, `bind_completed`, `algorithm`, `bit_length`, `mode`, `plugin_meta`) VALUES ('6cd1eeaf-a419-458b-94ba-3f74929f1452','2026-01-20 15:09:49','2026-01-20 15:16:06','2026-01-20 15:16:06',1,'ACTIVE','barbican.plugin.crypto.simple_crypto.SimpleCryptoPlugin','project-a49638950e1543fa8e0d251af5479623-key-9fb6f591-58ac-49b4-b117-138957a34134','966adb41-a14e-4ac4-9ef8-ba4fd448c3fb',1,1,'aes',128,'cbc','gAAAAABpb5q9MHg44GxGdZ2NH0XcCi5qVtPopIcPEwJc_Zw37kbLzRyou1Aa5WSBt1_DVeTs8M4I_LpxSEt2_-YwV31mB7s_LnUHHfA73RszKn60-T4kFSFvnCN95-nnIFI0pSaWl6A9'),('bc03a41e-43e9-4252-a395-a876f36a72a8','2026-01-20 15:06:38','2026-01-20 15:08:00','2026-01-20 15:08:00',1,'ACTIVE','barbican.plugin.crypto.simple_crypto.SimpleCryptoPlugin','project-526db518ca3942b58ee346d4bd970e42-key-4cbdcd6f-a713-4e0e-be6f-55a929b04dfc','0a631df2-3ed3-4aab-bb12-2fd3a2439a62',1,1,'aes',128,'cbc','gAAAAABpb5n-BDHtdf-Rw_pPewKZVF_mAVLCljYYohIfQbqAXRT6SSQz9X1djVYserX3Pa5sGfZ-N13695ALpfMiDqZlo19Kf2T8zNdR2t0x319c0M9koU8JFuPbmHLCDeh0tiqGRM52');
/*!40000 ALTER TABLE `kek_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_barbican_metadata`
--

DROP TABLE IF EXISTS `order_barbican_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_barbican_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_barbican_metadata_order_id` (`order_id`),
  CONSTRAINT `order_barbican_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_barbican_metadata`
--

LOCK TABLES `order_barbican_metadata` WRITE;
/*!40000 ALTER TABLE `order_barbican_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_barbican_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_plugin_metadata`
--

DROP TABLE IF EXISTS `order_plugin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_plugin_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_plugin_metadata_order_id` (`order_id`),
  CONSTRAINT `order_plugin_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_plugin_metadata`
--

LOCK TABLES `order_plugin_metadata` WRITE;
/*!40000 ALTER TABLE `order_plugin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_plugin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_retry_tasks`
--

DROP TABLE IF EXISTS `order_retry_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_retry_tasks` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `id` varchar(36) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `retry_task` text NOT NULL,
  `retry_at` datetime NOT NULL,
  `retry_args` text NOT NULL,
  `retry_kwargs` text NOT NULL,
  `retry_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_retry_tasks_order_id` (`order_id`),
  CONSTRAINT `order_retry_tasks_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_retry_tasks`
--

LOCK TABLES `order_retry_tasks` WRITE;
/*!40000 ALTER TABLE `order_retry_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_retry_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `error_status_code` varchar(16) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  `secret_id` varchar(36) DEFAULT NULL,
  `container_id` varchar(36) DEFAULT NULL,
  `sub_status` varchar(36) DEFAULT NULL,
  `sub_status_message` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_orders_container_id` (`container_id`),
  KEY `ix_orders_project_id` (`project_id`),
  KEY `ix_orders_secret_id` (`secret_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`),
  CONSTRAINT `orders_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
INSERT INTO `orders` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `type`, `project_id`, `error_status_code`, `error_reason`, `meta`, `secret_id`, `container_id`, `sub_status`, `sub_status_message`, `creator_id`) VALUES ('0abafc63-259f-4ca8-80d8-c69a99370c80','2026-01-20 15:06:38','2026-01-20 15:06:38',NULL,0,'ACTIVE','key','0a631df2-3ed3-4aab-bb12-2fd3a2439a62',NULL,NULL,'{\"algorithm\": \"aes\", \"bit_length\": 256, \"name\": null, \"expiration\": null}','44fbaa9e-d63a-4bf0-9535-e5558eaaa7e4',NULL,'Unknown','Unknown','1cdce555ec694255a154517f28a12ae5'),('d4a887df-192d-45f1-a3f3-81dfa52d181d','2026-01-20 15:09:49','2026-01-20 15:09:49',NULL,0,'ACTIVE','key','966adb41-a14e-4ac4-9ef8-ba4fd448c3fb',NULL,NULL,'{\"algorithm\": \"aes\", \"bit_length\": 256, \"name\": null, \"expiration\": null}','349091f0-57cd-4e7a-b935-410f986b1500',NULL,'Unknown','Unknown','bf422e55e158420cbdae75f07a3bb97a');
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preferred_certificate_authorities`
--

DROP TABLE IF EXISTS `preferred_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `preferred_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_preferred_certificate_authorities_project_id` (`project_id`),
  KEY `ix_preferred_certificate_authorities_ca_id` (`ca_id`),
  CONSTRAINT `preferred_certificate_authorities_fk` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `preferred_certificate_authorities_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preferred_certificate_authorities`
--

LOCK TABLES `preferred_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `preferred_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `preferred_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_certificate_authorities`
--

DROP TABLE IF EXISTS `project_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_certificate_authority_uc` (`project_id`,`ca_id`),
  KEY `ix_project_certificate_authorities_ca_id` (`ca_id`),
  KEY `ix_project_certificate_authorities_project_id` (`project_id`),
  CONSTRAINT `project_certificate_authorities_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `project_certificate_authorities_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_certificate_authorities`
--

LOCK TABLES `project_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `project_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_quotas`
--

DROP TABLE IF EXISTS `project_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_quotas` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `secrets` int(11) DEFAULT NULL,
  `orders` int(11) DEFAULT NULL,
  `containers` int(11) DEFAULT NULL,
  `consumers` int(11) DEFAULT NULL,
  `cas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_project_quotas_project_id` (`project_id`),
  CONSTRAINT `project_quotas_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_quotas`
--

LOCK TABLES `project_quotas` WRITE;
/*!40000 ALTER TABLE `project_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_secret_store`
--

DROP TABLE IF EXISTS `project_secret_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_secret_store` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_store_id` varchar(36) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_secret_store_project_uc` (`project_id`),
  KEY `ix_project_secret_store_project_id` (`project_id`),
  KEY `ix_project_secret_store_secret_store_id` (`secret_store_id`),
  CONSTRAINT `project_secret_store_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `project_secret_store_ibfk_2` FOREIGN KEY (`secret_store_id`) REFERENCES `secret_stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_secret_store`
--

LOCK TABLES `project_secret_store` WRITE;
/*!40000 ALTER TABLE `project_secret_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_secret_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `external_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
INSERT INTO `projects` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `external_id`) VALUES ('0a631df2-3ed3-4aab-bb12-2fd3a2439a62','2026-01-20 15:06:38','2026-01-20 15:08:00','2026-01-20 15:08:00',1,'ACTIVE','526db518ca3942b58ee346d4bd970e42'),('966adb41-a14e-4ac4-9ef8-ba4fd448c3fb','2026-01-20 15:09:49','2026-01-20 15:16:06','2026-01-20 15:16:06',1,'ACTIVE','a49638950e1543fa8e0d251af5479623');
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acl_users`
--

DROP TABLE IF EXISTS `secret_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_secret_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `secret_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `secret_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acl_users`
--

LOCK TABLES `secret_acl_users` WRITE;
/*!40000 ALTER TABLE `secret_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acls`
--

DROP TABLE IF EXISTS `secret_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_operation_uc` (`secret_id`,`operation`),
  KEY `ix_secret_acls_secret_id` (`secret_id`),
  CONSTRAINT `secret_acls_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acls`
--

LOCK TABLES `secret_acls` WRITE;
/*!40000 ALTER TABLE `secret_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_consumer_metadata`
--

DROP TABLE IF EXISTS `secret_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `service` varchar(255) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_consumer_resource_uc` (`secret_id`,`service`,`resource_type`,`resource_id`),
  KEY `ix_secret_consumer_metadata_secret_id` (`secret_id`),
  KEY `ix_secret_consumer_metadata_resource_id` (`resource_id`),
  KEY `ix_secret_consumer_metadata_project_id` (`project_id`),
  CONSTRAINT `fk_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `secret_consumer_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_consumer_metadata`
--

LOCK TABLES `secret_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `secret_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_store_metadata`
--

DROP TABLE IF EXISTS `secret_store_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_store_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secret_store_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_store_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_store_metadata`
--

LOCK TABLES `secret_store_metadata` WRITE;
/*!40000 ALTER TABLE `secret_store_metadata` DISABLE KEYS */;
INSERT INTO `secret_store_metadata` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `key`, `value`, `secret_id`) VALUES ('35cfdd26-61e1-43a5-ae6b-87113a75e377','2026-01-20 15:06:38','2026-01-20 15:07:47','2026-01-20 15:07:47',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','44fbaa9e-d63a-4bf0-9535-e5558eaaa7e4'),('8d8151bb-4131-42c2-a647-609901812519','2026-01-20 15:06:38','2026-01-20 15:07:47','2026-01-20 15:07:47',1,'PENDING','content_type','application/octet-stream','44fbaa9e-d63a-4bf0-9535-e5558eaaa7e4'),('9cb307f5-4bdb-4e3a-a86a-6d059c32aba9','2026-01-20 15:09:49','2026-01-20 15:10:23','2026-01-20 15:10:23',1,'PENDING','content_type','application/octet-stream','349091f0-57cd-4e7a-b935-410f986b1500'),('d0d3e094-b323-4824-94a8-867de412b0c5','2026-01-20 15:09:49','2026-01-20 15:10:23','2026-01-20 15:10:23',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','349091f0-57cd-4e7a-b935-410f986b1500');
/*!40000 ALTER TABLE `secret_store_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_stores`
--

DROP TABLE IF EXISTS `secret_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_stores` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `store_plugin` varchar(255) NOT NULL,
  `crypto_plugin` varchar(255) DEFAULT NULL,
  `global_default` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_stores_name_uc` (`name`),
  UNIQUE KEY `_secret_stores_plugin_names_uc` (`store_plugin`,`crypto_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_stores`
--

LOCK TABLES `secret_stores` WRITE;
/*!40000 ALTER TABLE `secret_stores` DISABLE KEYS */;
INSERT INTO `secret_stores` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `store_plugin`, `crypto_plugin`, `global_default`, `name`) VALUES ('eb6bae6c-6b92-4a8c-a636-0cec4cf0da8c','2026-01-20 13:41:35','2026-01-20 13:41:35',NULL,0,'ACTIVE','store_crypto','simple_crypto',1,'Software Only Crypto');
/*!40000 ALTER TABLE `secret_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_user_metadata`
--

DROP TABLE IF EXISTS `secret_user_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_user_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_key_uc` (`secret_id`,`key`),
  KEY `ix_secret_user_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_user_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_user_metadata`
--

LOCK TABLES `secret_user_metadata` WRITE;
/*!40000 ALTER TABLE `secret_user_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_user_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secrets`
--

DROP TABLE IF EXISTS `secrets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secrets` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `secret_type` varchar(255) DEFAULT 'opaque',
  `expiration` datetime DEFAULT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secrets_project_id` (`project_id`),
  CONSTRAINT `secrets_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secrets`
--

LOCK TABLES `secrets` WRITE;
/*!40000 ALTER TABLE `secrets` DISABLE KEYS */;
INSERT INTO `secrets` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `name`, `secret_type`, `expiration`, `algorithm`, `bit_length`, `mode`, `creator_id`, `project_id`) VALUES ('349091f0-57cd-4e7a-b935-410f986b1500','2026-01-20 15:09:49','2026-01-20 15:10:23','2026-01-20 15:10:23',1,'ACTIVE',NULL,'symmetric',NULL,'aes',256,NULL,'bf422e55e158420cbdae75f07a3bb97a','966adb41-a14e-4ac4-9ef8-ba4fd448c3fb'),('44fbaa9e-d63a-4bf0-9535-e5558eaaa7e4','2026-01-20 15:06:38','2026-01-20 15:07:47','2026-01-20 15:07:47',1,'ACTIVE',NULL,'symmetric',NULL,'aes',256,NULL,'1cdce555ec694255a154517f28a12ae5','0a631df2-3ed3-4aab-bb12-2fd3a2439a62');
/*!40000 ALTER TABLE `secrets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_keys`
--

DROP TABLE IF EXISTS `transport_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transport_keys` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `transport_key` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_keys`
--

LOCK TABLES `transport_keys` WRITE;
/*!40000 ALTER TABLE `transport_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `cinder`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `cinder` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `cinder`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('daa98075b90d');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment_specs`
--

DROP TABLE IF EXISTS `attachment_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_attachment_specs_attachment_id` (`attachment_id`),
  CONSTRAINT `attachment_specs_ibfk_1` FOREIGN KEY (`attachment_id`) REFERENCES `volume_attachment` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment_specs`
--

LOCK TABLES `attachment_specs` WRITE;
/*!40000 ALTER TABLE `attachment_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_metadata`
--

DROP TABLE IF EXISTS `backup_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_backup_metadata_backup_id` (`backup_id`),
  CONSTRAINT `backup_metadata_ibfk_1` FOREIGN KEY (`backup_id`) REFERENCES `backups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_metadata`
--

LOCK TABLES `backup_metadata` WRITE;
/*!40000 ALTER TABLE `backup_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `container` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fail_reason` varchar(255) DEFAULT NULL,
  `service_metadata` varchar(255) DEFAULT NULL,
  `service` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `object_count` int(11) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `temp_volume_id` varchar(36) DEFAULT NULL,
  `temp_snapshot_id` varchar(36) DEFAULT NULL,
  `num_dependent_backups` int(11) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `data_timestamp` datetime DEFAULT NULL,
  `restore_volume_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
INSERT INTO `backups` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `host`, `availability_zone`, `display_name`, `display_description`, `container`, `status`, `fail_reason`, `service_metadata`, `service`, `size`, `object_count`, `parent_id`, `temp_volume_id`, `temp_snapshot_id`, `num_dependent_backups`, `snapshot_id`, `data_timestamp`, `restore_volume_id`, `encryption_key_id`) VALUES ('2026-01-20 15:08:10','2026-01-20 15:09:03','2026-01-20 15:09:06',1,'d6558c7e-be53-4669-acdb-5b67dd2ebd2f','312280b4-90ae-42ad-9955-fa64a235a337','467630ad66f84c4ba21657f6e5db7d10','48aeeaa346bb4dfba4dfc598ae41f062','cinder-backup-0',NULL,'tempest-TestVolumeBackupRestore-backup-61508551',NULL,'backups','deleted',NULL,'{\"base\": \"volume-312280b4-90ae-42ad-9955-fa64a235a337.backup.d6558c7e-be53-4669-acdb-5b67dd2ebd2f\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:08:10','658f5854-e66e-4c02-a707-dcb4f1727205',NULL);
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cgsnapshots`
--

DROP TABLE IF EXISTS `cgsnapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cgsnapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `consistencygroup_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_cgsnapshots_consistencygroup_id` (`consistencygroup_id`),
  CONSTRAINT `cgsnapshots_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cgsnapshots`
--

LOCK TABLES `cgsnapshots` WRITE;
/*!40000 ALTER TABLE `cgsnapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `cgsnapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clusters`
--

DROP TABLE IF EXISTS `clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clusters` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`binary`,`race_preventer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clusters`
--

LOCK TABLES `clusters` WRITE;
/*!40000 ALTER TABLE `clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consistencygroups`
--

DROP TABLE IF EXISTS `consistencygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consistencygroups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `volume_type_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `source_cgid` varchar(36) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consistencygroups`
--

LOCK TABLES `consistencygroups` WRITE;
/*!40000 ALTER TABLE `consistencygroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `consistencygroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_volume_types`
--

DROP TABLE IF EXISTS `default_volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `default_volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  KEY `ix_default_volume_types_volume_type_id` (`volume_type_id`),
  CONSTRAINT `default_volume_types_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_volume_types`
--

LOCK TABLES `default_volume_types` WRITE;
/*!40000 ALTER TABLE `default_volume_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver_initiator_data`
--

DROP TABLE IF EXISTS `driver_initiator_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `driver_initiator_data` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `initiator` (`initiator`,`namespace`,`key`),
  KEY `ix_driver_initiator_data_initiator` (`initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver_initiator_data`
--

LOCK TABLES `driver_initiator_data` WRITE;
/*!40000 ALTER TABLE `driver_initiator_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `driver_initiator_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encryption`
--

DROP TABLE IF EXISTS `encryption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encryption` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `cipher` varchar(255) DEFAULT NULL,
  `control_location` varchar(255) NOT NULL,
  `key_size` int(11) DEFAULT NULL,
  `provider` varchar(255) NOT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `encryption_id` varchar(36) NOT NULL,
  PRIMARY KEY (`encryption_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encryption`
--

LOCK TABLES `encryption` WRITE;
/*!40000 ALTER TABLE `encryption` DISABLE KEYS */;
INSERT INTO `encryption` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `cipher`, `control_location`, `key_size`, `provider`, `volume_type_id`, `encryption_id`) VALUES ('2026-01-20 15:09:48',NULL,'2026-01-20 15:10:25',1,'aes-xts-plain64','front-end',256,'luks','97532ec0-0821-4438-834b-3de729339510','4814918d-7b28-4530-9f63-1b2e3bda35eb'),('2026-01-20 15:06:37',NULL,'2026-01-20 15:07:49',1,'aes-xts-plain64','front-end',256,'luks','88745016-718c-4c33-be96-1147347c0cc1','ed193d54-3c84-447f-9337-f1996a165add');
/*!40000 ALTER TABLE `encryption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_snapshots`
--

DROP TABLE IF EXISTS `group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_snapshots_group_id` (`group_id`),
  KEY `group_snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `group_snapshots_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_snapshots`
--

LOCK TABLES `group_snapshots` WRITE;
/*!40000 ALTER TABLE `group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_projects`
--

DROP TABLE IF EXISTS `group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_type_id` (`group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `group_type_projects_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_projects`
--

LOCK TABLES `group_type_projects` WRITE;
/*!40000 ALTER TABLE `group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_specs`
--

DROP TABLE IF EXISTS `group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_type_specs_group_type_id` (`group_type_id`),
  CONSTRAINT `group_type_specs_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_specs`
--

LOCK TABLES `group_type_specs` WRITE;
/*!40000 ALTER TABLE `group_type_specs` DISABLE KEYS */;
INSERT INTO `group_type_specs` (`id`, `key`, `value`, `group_type_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'consistent_group_snapshot_enabled','<is> True','9ea28c79-46db-4c8b-ad14-648129a5eeb8','2026-01-20 13:41:32','2026-01-20 13:41:32',NULL,0);
/*!40000 ALTER TABLE `group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_types`
--

DROP TABLE IF EXISTS `group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_types` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_types`
--

LOCK TABLES `group_types` WRITE;
/*!40000 ALTER TABLE `group_types` DISABLE KEYS */;
INSERT INTO `group_types` (`id`, `name`, `description`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `is_public`) VALUES ('9ea28c79-46db-4c8b-ad14-648129a5eeb8','default_cgsnapshot_type','Default group type for migrating cgsnapshot','2026-01-20 13:41:32','2026-01-20 13:41:32',NULL,0,1);
/*!40000 ALTER TABLE `group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_volume_type_mapping`
--

DROP TABLE IF EXISTS `group_volume_type_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_volume_type_mapping` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_volume_type_mapping_group_id` (`group_id`),
  KEY `ix_group_volume_type_mapping_volume_type_id` (`volume_type_id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_volume_type_mapping`
--

LOCK TABLES `group_volume_type_mapping` WRITE;
/*!40000 ALTER TABLE `group_volume_type_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_volume_type_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `groups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `source_group_id` varchar(36) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groups_deleted_project_id_idx` (`deleted`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_volume_cache_entries`
--

DROP TABLE IF EXISTS `image_volume_cache_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_volume_cache_entries` (
  `image_updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `image_id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `size` int(11) NOT NULL,
  `last_used` datetime NOT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_volume_cache_entries_host` (`host`),
  KEY `ix_image_volume_cache_entries_image_id` (`image_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_volume_cache_entries`
--

LOCK TABLES `image_volume_cache_entries` WRITE;
/*!40000 ALTER TABLE `image_volume_cache_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_volume_cache_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(36) DEFAULT NULL,
  `resource_uuid` varchar(255) DEFAULT NULL,
  `event_id` varchar(255) NOT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `action_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_messages_expires_at` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quality_of_service_specs`
--

DROP TABLE IF EXISTS `quality_of_service_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quality_of_service_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `specs_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quality_of_service_specs_specs_id` (`specs_id`),
  CONSTRAINT `quality_of_service_specs_ibfk_1` FOREIGN KEY (`specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quality_of_service_specs`
--

LOCK TABLES `quality_of_service_specs` WRITE;
/*!40000 ALTER TABLE `quality_of_service_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `quality_of_service_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
INSERT INTO `quota_classes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `class_name`, `resource`, `hard_limit`) VALUES ('2026-01-20 13:41:30',NULL,NULL,0,1,'default','volumes',10),('2026-01-20 13:41:30',NULL,NULL,0,2,'default','snapshots',10),('2026-01-20 13:41:30',NULL,NULL,0,3,'default','gigabytes',1000),('2026-01-20 13:41:30',NULL,NULL,0,4,'default','consistencygroups',10),('2026-01-20 13:41:30',NULL,NULL,0,5,'default','per_volume_gigabytes',-1),('2026-01-20 13:41:30',NULL,NULL,0,6,'default','groups',10);
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(300) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `race_preventer` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`,`race_preventer`),
  KEY `ix_quota_usages_project_id` (`project_id`),
  KEY `quota_usage_project_resource_idx` (`project_id`,`resource`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=147 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
INSERT INTO `quota_usages` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `project_id`, `resource`, `in_use`, `reserved`, `until_refresh`, `race_preventer`) VALUES ('2026-01-20 14:23:18','2026-01-20 14:24:18',NULL,0,1,'a46350811ba449b082347f02d76d1c34','volumes',0,0,NULL,1),('2026-01-20 14:23:18','2026-01-20 14:24:18',NULL,0,2,'a46350811ba449b082347f02d76d1c34','gigabytes',0,0,NULL,1),('2026-01-20 14:23:18','2026-01-20 14:24:18',NULL,0,3,'a46350811ba449b082347f02d76d1c34','volumes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:23:18','2026-01-20 14:24:18',NULL,0,4,'a46350811ba449b082347f02d76d1c34','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:24:27','2026-01-20 14:26:03',NULL,0,5,'861a4f2b70b249afadeabfe85bda53a3','volumes',0,0,NULL,1),('2026-01-20 14:24:27','2026-01-20 14:26:03',NULL,0,6,'861a4f2b70b249afadeabfe85bda53a3','gigabytes',0,0,NULL,1),('2026-01-20 14:24:27','2026-01-20 14:26:03',NULL,0,7,'861a4f2b70b249afadeabfe85bda53a3','volumes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:24:27','2026-01-20 14:26:03',NULL,0,8,'861a4f2b70b249afadeabfe85bda53a3','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:27:59','2026-01-20 14:29:13',NULL,0,9,'d15f60b9e48e4175b5520d1e57ed2d3a','volumes',0,0,NULL,1),('2026-01-20 14:27:59','2026-01-20 14:29:13',NULL,0,10,'d15f60b9e48e4175b5520d1e57ed2d3a','gigabytes',0,0,NULL,1),('2026-01-20 14:27:59','2026-01-20 14:29:13',NULL,0,11,'d15f60b9e48e4175b5520d1e57ed2d3a','volumes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:27:59','2026-01-20 14:29:13',NULL,0,12,'d15f60b9e48e4175b5520d1e57ed2d3a','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:28:13','2026-01-20 14:28:32',NULL,0,13,'944b426a2d4c4ad3a01f0b855ad36509','volumes',0,0,NULL,1),('2026-01-20 14:28:13','2026-01-20 14:28:32',NULL,0,14,'944b426a2d4c4ad3a01f0b855ad36509','gigabytes',0,0,NULL,1),('2026-01-20 14:28:13','2026-01-20 14:28:32',NULL,0,15,'944b426a2d4c4ad3a01f0b855ad36509','volumes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:28:13','2026-01-20 14:28:32',NULL,0,16,'944b426a2d4c4ad3a01f0b855ad36509','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:29:08','2026-01-20 14:31:54',NULL,0,17,'0cee74dd60da4a839bb5eb0ba3137edf','volumes',0,0,NULL,1),('2026-01-20 14:29:08','2026-01-20 14:31:54',NULL,0,18,'0cee74dd60da4a839bb5eb0ba3137edf','gigabytes',0,0,NULL,1),('2026-01-20 14:29:08','2026-01-20 14:31:54',NULL,0,19,'0cee74dd60da4a839bb5eb0ba3137edf','volumes_multiattach',0,0,NULL,1),('2026-01-20 14:29:08','2026-01-20 14:31:54',NULL,0,20,'0cee74dd60da4a839bb5eb0ba3137edf','gigabytes_multiattach',0,0,NULL,1),('2026-01-20 14:33:26','2026-01-20 14:34:15',NULL,0,21,'48488e875f2e472f97f07cc7ee07e0be','volumes',0,0,NULL,1),('2026-01-20 14:33:26','2026-01-20 14:34:15',NULL,0,22,'48488e875f2e472f97f07cc7ee07e0be','gigabytes',0,0,NULL,1),('2026-01-20 14:33:26','2026-01-20 14:34:15',NULL,0,23,'48488e875f2e472f97f07cc7ee07e0be','volumes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:33:26','2026-01-20 14:34:15',NULL,0,24,'48488e875f2e472f97f07cc7ee07e0be','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:38:30','2026-01-20 14:40:36',NULL,0,25,'8705404c3964472782118e478eb54e51','volumes',0,0,NULL,1),('2026-01-20 14:38:30','2026-01-20 14:40:36',NULL,0,26,'8705404c3964472782118e478eb54e51','gigabytes',0,0,NULL,1),('2026-01-20 14:38:30','2026-01-20 14:40:36',NULL,0,27,'8705404c3964472782118e478eb54e51','volumes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:38:30','2026-01-20 14:40:36',NULL,0,28,'8705404c3964472782118e478eb54e51','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:44:27','2026-01-20 14:47:58',NULL,0,29,'3b31139b2a4e49cba5e7048febf901c4','volumes',0,0,NULL,1),('2026-01-20 14:44:27','2026-01-20 14:47:58',NULL,0,30,'3b31139b2a4e49cba5e7048febf901c4','gigabytes',0,0,NULL,1),('2026-01-20 14:44:27','2026-01-20 14:47:58',NULL,0,31,'3b31139b2a4e49cba5e7048febf901c4','volumes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:44:27','2026-01-20 14:47:58',NULL,0,32,'3b31139b2a4e49cba5e7048febf901c4','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:44:29','2026-01-20 14:45:30',NULL,0,33,'144d821b8f624db687f0e009c5e06d8b','volumes',0,0,NULL,1),('2026-01-20 14:44:29','2026-01-20 14:45:30',NULL,0,34,'144d821b8f624db687f0e009c5e06d8b','gigabytes',0,0,NULL,1),('2026-01-20 14:44:29','2026-01-20 14:45:30',NULL,0,35,'144d821b8f624db687f0e009c5e06d8b','volumes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:44:29','2026-01-20 14:45:30',NULL,0,36,'144d821b8f624db687f0e009c5e06d8b','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:45:35','2026-01-20 14:48:48',NULL,0,37,'b683fcc0026242e28ba6d8fba638688e','volumes',0,0,NULL,1),('2026-01-20 14:45:35','2026-01-20 14:48:48',NULL,0,38,'b683fcc0026242e28ba6d8fba638688e','gigabytes',0,0,NULL,1),('2026-01-20 14:45:35','2026-01-20 14:48:48',NULL,0,39,'b683fcc0026242e28ba6d8fba638688e','volumes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:45:35','2026-01-20 14:48:48',NULL,0,40,'b683fcc0026242e28ba6d8fba638688e','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:46:00','2026-01-20 14:47:07',NULL,0,41,'7bbf722f17654404925cfb53e48cd473','volumes',0,0,NULL,1),('2026-01-20 14:46:00','2026-01-20 14:47:07',NULL,0,42,'7bbf722f17654404925cfb53e48cd473','gigabytes',0,0,NULL,1),('2026-01-20 14:46:00','2026-01-20 14:47:07',NULL,0,43,'7bbf722f17654404925cfb53e48cd473','volumes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:46:00','2026-01-20 14:47:07',NULL,0,44,'7bbf722f17654404925cfb53e48cd473','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:48:38','2026-01-20 14:51:21',NULL,0,45,'b15c4e6eb57e4b0ca4e63c85ed92fc5f','volumes',0,0,NULL,1),('2026-01-20 14:48:38','2026-01-20 14:51:21',NULL,0,46,'b15c4e6eb57e4b0ca4e63c85ed92fc5f','gigabytes',0,0,NULL,1),('2026-01-20 14:48:38','2026-01-20 14:51:21',NULL,0,47,'b15c4e6eb57e4b0ca4e63c85ed92fc5f','volumes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:48:38','2026-01-20 14:51:21',NULL,0,48,'b15c4e6eb57e4b0ca4e63c85ed92fc5f','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:52:49','2026-01-20 14:54:39',NULL,0,49,'0a29915e0dd2403fbd7b7e847696b00a','volumes',0,0,NULL,1),('2026-01-20 14:52:49','2026-01-20 14:54:39',NULL,0,50,'0a29915e0dd2403fbd7b7e847696b00a','gigabytes',0,0,NULL,1),('2026-01-20 14:52:49','2026-01-20 14:54:39',NULL,0,51,'0a29915e0dd2403fbd7b7e847696b00a','volumes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:52:49','2026-01-20 14:54:39',NULL,0,52,'0a29915e0dd2403fbd7b7e847696b00a','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:52:55','2026-01-20 14:54:42',NULL,0,53,'0ad54030e5cc477e939e073b52024ec4','volumes',0,0,NULL,1),('2026-01-20 14:52:55','2026-01-20 14:54:42',NULL,0,54,'0ad54030e5cc477e939e073b52024ec4','gigabytes',0,0,NULL,1),('2026-01-20 14:52:55','2026-01-20 14:54:42',NULL,0,55,'0ad54030e5cc477e939e073b52024ec4','volumes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:52:55','2026-01-20 14:54:42',NULL,0,56,'0ad54030e5cc477e939e073b52024ec4','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:53:42','2026-01-20 14:56:16',NULL,0,57,'b1e83af992c94112a965575784639d77','volumes',0,0,NULL,1),('2026-01-20 14:53:42','2026-01-20 14:56:16',NULL,0,58,'b1e83af992c94112a965575784639d77','gigabytes',0,0,NULL,1),('2026-01-20 14:53:42','2026-01-20 14:56:16',NULL,0,59,'b1e83af992c94112a965575784639d77','volumes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:53:42','2026-01-20 14:56:16',NULL,0,60,'b1e83af992c94112a965575784639d77','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:55:12','2026-01-20 14:57:45',NULL,0,61,'b3b1b7f5b4f84b5abbc401eb577c85c0','volumes',0,0,NULL,1),('2026-01-20 14:55:12','2026-01-20 14:57:45',NULL,0,62,'b3b1b7f5b4f84b5abbc401eb577c85c0','gigabytes',0,0,NULL,1),('2026-01-20 14:55:12','2026-01-20 14:57:45',NULL,0,63,'b3b1b7f5b4f84b5abbc401eb577c85c0','volumes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:55:12','2026-01-20 14:57:45',NULL,0,64,'b3b1b7f5b4f84b5abbc401eb577c85c0','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:56:25','2026-01-20 14:56:37',NULL,0,65,'fb4410ee5e824adfa71950de60e627af','volumes',0,0,NULL,1),('2026-01-20 14:56:25','2026-01-20 14:56:37',NULL,0,66,'fb4410ee5e824adfa71950de60e627af','gigabytes',0,0,NULL,1),('2026-01-20 14:56:25','2026-01-20 14:56:37',NULL,0,67,'fb4410ee5e824adfa71950de60e627af','volumes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:56:25','2026-01-20 14:56:37',NULL,0,68,'fb4410ee5e824adfa71950de60e627af','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:57:18','2026-01-20 15:00:06',NULL,0,69,'107c1f3b5b7b413d9a389ca1166e331f','volumes',0,0,NULL,1),('2026-01-20 14:57:18','2026-01-20 15:00:06',NULL,0,70,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes',0,0,NULL,1),('2026-01-20 14:57:18','2026-01-20 14:59:35',NULL,0,71,'107c1f3b5b7b413d9a389ca1166e331f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-692148149-672147069',0,0,NULL,1),('2026-01-20 14:57:18','2026-01-20 14:59:35',NULL,0,72,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-692148149-672147069',0,0,NULL,1),('2026-01-20 14:57:19','2026-01-20 14:59:38',NULL,0,73,'107c1f3b5b7b413d9a389ca1166e331f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-472468519-648261730',0,0,NULL,1),('2026-01-20 14:57:19','2026-01-20 14:59:38',NULL,0,74,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-472468519-648261730',0,0,NULL,1),('2026-01-20 14:57:21','2026-01-20 15:00:06',NULL,0,75,'107c1f3b5b7b413d9a389ca1166e331f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-347628217-1040866455',0,0,NULL,1),('2026-01-20 14:57:21','2026-01-20 15:00:06',NULL,0,76,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-347628217-1040866455',0,0,NULL,1),('2026-01-20 14:59:34','2026-01-20 15:01:53',NULL,0,77,'105e56abe3804424885c7aa8d1216d12','volumes',0,0,NULL,1),('2026-01-20 14:59:34','2026-01-20 15:01:53',NULL,0,78,'105e56abe3804424885c7aa8d1216d12','gigabytes',0,0,NULL,1),('2026-01-20 14:59:34','2026-01-20 15:01:53',NULL,0,79,'105e56abe3804424885c7aa8d1216d12','volumes___DEFAULT__',0,0,NULL,1),('2026-01-20 14:59:34','2026-01-20 15:01:53',NULL,0,80,'105e56abe3804424885c7aa8d1216d12','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-20 15:01:45','2026-01-20 15:03:50',NULL,0,81,'63555e5851564db08c6429231d264f2c','volumes',2,0,NULL,1),('2026-01-20 15:01:45','2026-01-20 15:03:50',NULL,0,82,'63555e5851564db08c6429231d264f2c','gigabytes',2,0,NULL,1),('2026-01-20 15:01:45','2026-01-20 15:03:50',NULL,0,83,'63555e5851564db08c6429231d264f2c','volumes___DEFAULT__',2,0,NULL,1),('2026-01-20 15:01:45','2026-01-20 15:03:50',NULL,0,84,'63555e5851564db08c6429231d264f2c','gigabytes___DEFAULT__',2,0,NULL,1),('2026-01-20 15:02:54','2026-01-20 15:05:47',NULL,0,85,'96f7b14c2a9348f08305fe232df2a603','volumes',0,0,NULL,1),('2026-01-20 15:02:54','2026-01-20 15:05:47',NULL,0,86,'96f7b14c2a9348f08305fe232df2a603','gigabytes',0,0,NULL,1),('2026-01-20 15:02:54','2026-01-20 15:05:47',NULL,0,87,'96f7b14c2a9348f08305fe232df2a603','volumes___DEFAULT__',0,0,NULL,1),('2026-01-20 15:02:54','2026-01-20 15:05:47',NULL,0,88,'96f7b14c2a9348f08305fe232df2a603','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-20 15:05:15','2026-01-20 15:07:21',NULL,0,89,'e142d118583b4f9ba3531bcf3838e256','volumes',0,0,NULL,1),('2026-01-20 15:05:15','2026-01-20 15:07:21',NULL,0,90,'e142d118583b4f9ba3531bcf3838e256','gigabytes',0,0,NULL,1),('2026-01-20 15:05:15','2026-01-20 15:07:21',NULL,0,91,'e142d118583b4f9ba3531bcf3838e256','volumes___DEFAULT__',0,0,NULL,1),('2026-01-20 15:05:15','2026-01-20 15:07:21',NULL,0,92,'e142d118583b4f9ba3531bcf3838e256','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-20 15:05:20','2026-01-20 15:07:12',NULL,0,93,'0fc924d2df984301897e81920c5e192f','volumes',0,0,NULL,1),('2026-01-20 15:05:20','2026-01-20 15:07:12',NULL,0,94,'0fc924d2df984301897e81920c5e192f','gigabytes',0,0,NULL,1),('2026-01-20 15:05:20','2026-01-20 15:07:12',NULL,0,95,'0fc924d2df984301897e81920c5e192f','volumes___DEFAULT__',0,0,NULL,1),('2026-01-20 15:05:20','2026-01-20 15:07:12',NULL,0,96,'0fc924d2df984301897e81920c5e192f','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-20 15:05:57','2026-01-20 15:06:03',NULL,0,97,'f9a4fb1ea67548318c6ff2af4e9d4abe','volumes',0,0,NULL,1),('2026-01-20 15:05:57','2026-01-20 15:06:03',NULL,0,98,'f9a4fb1ea67548318c6ff2af4e9d4abe','gigabytes',0,0,NULL,1),('2026-01-20 15:05:57','2026-01-20 15:06:03',NULL,0,99,'f9a4fb1ea67548318c6ff2af4e9d4abe','volumes___DEFAULT__',0,0,NULL,1),('2026-01-20 15:05:57','2026-01-20 15:06:03',NULL,0,100,'f9a4fb1ea67548318c6ff2af4e9d4abe','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-20 15:05:58','2026-01-20 15:07:14',NULL,0,101,'e142d118583b4f9ba3531bcf3838e256','snapshots',0,0,NULL,1),('2026-01-20 15:05:58','2026-01-20 15:07:14',NULL,0,102,'e142d118583b4f9ba3531bcf3838e256','snapshots___DEFAULT__',0,0,NULL,1),('2026-01-20 15:05:59','2026-01-20 15:06:01',NULL,0,103,'f9a4fb1ea67548318c6ff2af4e9d4abe','snapshots',0,0,NULL,1),('2026-01-20 15:05:59','2026-01-20 15:06:01',NULL,0,104,'f9a4fb1ea67548318c6ff2af4e9d4abe','snapshots___DEFAULT__',0,0,NULL,1),('2026-01-20 15:06:09','2026-01-20 15:06:10',NULL,0,105,'329ef67ba7884caa87edf40d2d26e70f','volumes',0,0,NULL,1),('2026-01-20 15:06:09','2026-01-20 15:06:10',NULL,0,106,'329ef67ba7884caa87edf40d2d26e70f','gigabytes',0,0,NULL,1),('2026-01-20 15:06:09','2026-01-20 15:06:10',NULL,0,107,'329ef67ba7884caa87edf40d2d26e70f','volumes___DEFAULT__',0,0,NULL,1),('2026-01-20 15:06:09','2026-01-20 15:06:10',NULL,0,108,'329ef67ba7884caa87edf40d2d26e70f','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-20 15:06:39','2026-01-20 15:07:47',NULL,0,109,'526db518ca3942b58ee346d4bd970e42','volumes',0,0,NULL,1),('2026-01-20 15:06:39','2026-01-20 15:07:47',NULL,0,110,'526db518ca3942b58ee346d4bd970e42','gigabytes',0,0,NULL,1),('2026-01-20 15:06:39','2026-01-20 15:07:47',NULL,0,111,'526db518ca3942b58ee346d4bd970e42','volumes_tempest-scenario-type-luks-1068136217',0,0,NULL,1),('2026-01-20 15:06:39','2026-01-20 15:07:47',NULL,0,112,'526db518ca3942b58ee346d4bd970e42','gigabytes_tempest-scenario-type-luks-1068136217',0,0,NULL,1),('2026-01-20 15:08:02','2026-01-20 15:09:06',NULL,0,113,'48aeeaa346bb4dfba4dfc598ae41f062','volumes',0,0,NULL,1),('2026-01-20 15:08:02','2026-01-20 15:09:06',NULL,0,114,'48aeeaa346bb4dfba4dfc598ae41f062','gigabytes',0,0,NULL,1),('2026-01-20 15:08:02','2026-01-20 15:09:06',NULL,0,115,'48aeeaa346bb4dfba4dfc598ae41f062','volumes___DEFAULT__',0,0,NULL,1),('2026-01-20 15:08:02','2026-01-20 15:09:06',NULL,0,116,'48aeeaa346bb4dfba4dfc598ae41f062','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-20 15:08:10','2026-01-20 15:09:06',NULL,0,117,'48aeeaa346bb4dfba4dfc598ae41f062','backups',0,0,NULL,1),('2026-01-20 15:08:10','2026-01-20 15:09:06',NULL,0,118,'48aeeaa346bb4dfba4dfc598ae41f062','backup_gigabytes',0,0,NULL,1),('2026-01-20 15:08:32','2026-01-20 15:10:36',NULL,0,119,'fc74c4a296554866969b05aef75252af','volumes',0,0,NULL,1),('2026-01-20 15:08:32','2026-01-20 15:10:36',NULL,0,120,'fc74c4a296554866969b05aef75252af','gigabytes',0,0,NULL,1),('2026-01-20 15:08:32','2026-01-20 15:10:36',NULL,0,121,'fc74c4a296554866969b05aef75252af','volumes___DEFAULT__',0,0,NULL,1),('2026-01-20 15:08:32','2026-01-20 15:10:36',NULL,0,122,'fc74c4a296554866969b05aef75252af','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-20 15:08:44','2026-01-20 15:11:15',NULL,0,123,'5b43342be22543f79d4a56e26c6d0c96','volumes',0,0,NULL,1),('2026-01-20 15:08:44','2026-01-20 15:11:15',NULL,0,124,'5b43342be22543f79d4a56e26c6d0c96','gigabytes',0,0,NULL,1),('2026-01-20 15:08:44','2026-01-20 15:11:15',NULL,0,125,'5b43342be22543f79d4a56e26c6d0c96','volumes___DEFAULT__',0,0,NULL,1),('2026-01-20 15:08:44','2026-01-20 15:11:15',NULL,0,126,'5b43342be22543f79d4a56e26c6d0c96','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-20 15:08:51','2026-01-20 15:09:04',NULL,0,127,'5b43342be22543f79d4a56e26c6d0c96','snapshots',0,0,NULL,1),('2026-01-20 15:08:51','2026-01-20 15:09:04',NULL,0,128,'5b43342be22543f79d4a56e26c6d0c96','snapshots___DEFAULT__',0,0,NULL,1),('2026-01-20 15:09:49','2026-01-20 15:15:46',NULL,0,129,'a49638950e1543fa8e0d251af5479623','volumes',0,0,NULL,1),('2026-01-20 15:09:49','2026-01-20 15:15:46',NULL,0,130,'a49638950e1543fa8e0d251af5479623','gigabytes',0,0,NULL,1),('2026-01-20 15:09:49','2026-01-20 15:10:24',NULL,0,131,'a49638950e1543fa8e0d251af5479623','volumes_tempest-scenario-type-luks-795593813',0,0,NULL,1),('2026-01-20 15:09:49','2026-01-20 15:10:24',NULL,0,132,'a49638950e1543fa8e0d251af5479623','gigabytes_tempest-scenario-type-luks-795593813',0,0,NULL,1),('2026-01-20 15:10:26','2026-01-20 15:15:46',NULL,0,133,'a49638950e1543fa8e0d251af5479623','volumes___DEFAULT__',0,0,NULL,1),('2026-01-20 15:10:26','2026-01-20 15:15:46',NULL,0,134,'a49638950e1543fa8e0d251af5479623','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-20 15:10:37','2026-01-20 15:15:38',NULL,0,135,'a49638950e1543fa8e0d251af5479623','snapshots',0,0,NULL,1),('2026-01-20 15:10:37','2026-01-20 15:15:38',NULL,0,136,'a49638950e1543fa8e0d251af5479623','snapshots___DEFAULT__',0,0,NULL,1),('2026-01-20 15:13:10','2026-01-20 15:17:54',NULL,0,137,'fff727019f86407498e83d7948d54962','volumes',0,0,NULL,1),('2026-01-20 15:13:10','2026-01-20 15:17:54',NULL,0,138,'fff727019f86407498e83d7948d54962','gigabytes',0,0,NULL,1),('2026-01-20 15:13:10','2026-01-20 15:17:54',NULL,0,139,'fff727019f86407498e83d7948d54962','volumes_multiattach',0,0,NULL,1),('2026-01-20 15:13:10','2026-01-20 15:17:54',NULL,0,140,'fff727019f86407498e83d7948d54962','gigabytes_multiattach',0,0,NULL,1),('2026-01-20 15:17:14','2026-01-20 15:17:25',NULL,0,141,'fff727019f86407498e83d7948d54962','snapshots',0,0,NULL,1),('2026-01-20 15:17:14','2026-01-20 15:17:25',NULL,0,142,'fff727019f86407498e83d7948d54962','snapshots_multiattach',0,0,NULL,1),('2026-01-20 15:19:05','2026-01-20 15:22:16',NULL,0,143,'9156c0a9920c4721843416b9a44404f9','volumes',0,0,NULL,1),('2026-01-20 15:19:05','2026-01-20 15:22:16',NULL,0,144,'9156c0a9920c4721843416b9a44404f9','gigabytes',0,0,NULL,1),('2026-01-20 15:19:05','2026-01-20 15:22:16',NULL,0,145,'9156c0a9920c4721843416b9a44404f9','volumes___DEFAULT__',0,0,NULL,1),('2026-01-20 15:19:05','2026-01-20 15:22:16',NULL,0,146,'9156c0a9920c4721843416b9a44404f9','gigabytes___DEFAULT__',0,0,NULL,1);
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `allocated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `allocated_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_reservations_allocated_id` (`allocated_id`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  KEY `ix_reservations_usage_id` (`usage_id`),
  KEY `reservations_deleted_uuid_idx` (`deleted`,`uuid`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`),
  CONSTRAINT `reservations_ibfk_2` FOREIGN KEY (`allocated_id`) REFERENCES `quotas` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=605 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
INSERT INTO `reservations` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `uuid`, `usage_id`, `project_id`, `resource`, `delta`, `expire`, `allocated_id`) VALUES ('2026-01-20 14:23:18','2026-01-20 14:23:18','2026-01-20 14:23:18',1,1,'b40ccdef-2adb-414f-bdfa-0e4ab258a08b',1,'a46350811ba449b082347f02d76d1c34','volumes',1,'2026-01-21 14:23:18',NULL),('2026-01-20 14:23:18','2026-01-20 14:23:18','2026-01-20 14:23:18',1,2,'d55725bd-60c5-4cfb-aa3c-a5cf785db1d1',2,'a46350811ba449b082347f02d76d1c34','gigabytes',1,'2026-01-21 14:23:18',NULL),('2026-01-20 14:23:18','2026-01-20 14:23:18','2026-01-20 14:23:18',1,3,'b4521b8e-8e43-4dfb-9dbb-54656e9abb99',3,'a46350811ba449b082347f02d76d1c34','volumes___DEFAULT__',1,'2026-01-21 14:23:18',NULL),('2026-01-20 14:23:18','2026-01-20 14:23:18','2026-01-20 14:23:18',1,4,'e05e4dd4-2758-4271-acf8-9bd20c9e001a',4,'a46350811ba449b082347f02d76d1c34','gigabytes___DEFAULT__',1,'2026-01-21 14:23:18',NULL),('2026-01-20 14:24:18','2026-01-20 14:24:18','2026-01-20 14:24:18',1,5,'bf2e78a6-17dd-4c1d-bdc7-2be1771b9459',1,'a46350811ba449b082347f02d76d1c34','volumes',-1,'2026-01-21 14:24:18',NULL),('2026-01-20 14:24:18','2026-01-20 14:24:18','2026-01-20 14:24:18',1,6,'10926a1a-b4ed-45c4-806f-cbda57115e87',2,'a46350811ba449b082347f02d76d1c34','gigabytes',-1,'2026-01-21 14:24:18',NULL),('2026-01-20 14:24:18','2026-01-20 14:24:18','2026-01-20 14:24:18',1,7,'c5ffd231-abec-472d-ae00-d361a035f46b',3,'a46350811ba449b082347f02d76d1c34','volumes___DEFAULT__',-1,'2026-01-21 14:24:18',NULL),('2026-01-20 14:24:18','2026-01-20 14:24:18','2026-01-20 14:24:18',1,8,'82ccc9a9-1697-41df-87d5-a8cde0ff95fb',4,'a46350811ba449b082347f02d76d1c34','gigabytes___DEFAULT__',-1,'2026-01-21 14:24:18',NULL),('2026-01-20 14:24:27','2026-01-20 14:24:27','2026-01-20 14:24:27',1,9,'1ea42bf5-0a50-445c-a09f-2dc324c4c7de',5,'861a4f2b70b249afadeabfe85bda53a3','volumes',1,'2026-01-21 14:24:27',NULL),('2026-01-20 14:24:27','2026-01-20 14:24:27','2026-01-20 14:24:27',1,10,'1ae6a800-2eb0-48f9-8603-fd3639828aef',6,'861a4f2b70b249afadeabfe85bda53a3','gigabytes',1,'2026-01-21 14:24:27',NULL),('2026-01-20 14:24:27','2026-01-20 14:24:27','2026-01-20 14:24:27',1,11,'6ed23aeb-791d-45da-b55a-1af84fa90b35',7,'861a4f2b70b249afadeabfe85bda53a3','volumes___DEFAULT__',1,'2026-01-21 14:24:27',NULL),('2026-01-20 14:24:27','2026-01-20 14:24:27','2026-01-20 14:24:27',1,12,'fd191b6e-9ee9-4f44-a6e3-a175c79ba09e',8,'861a4f2b70b249afadeabfe85bda53a3','gigabytes___DEFAULT__',1,'2026-01-21 14:24:27',NULL),('2026-01-20 14:26:03','2026-01-20 14:26:03','2026-01-20 14:26:03',1,13,'8b429248-5a4f-4533-a39d-078da8611ca7',5,'861a4f2b70b249afadeabfe85bda53a3','volumes',-1,'2026-01-21 14:26:03',NULL),('2026-01-20 14:26:03','2026-01-20 14:26:03','2026-01-20 14:26:03',1,14,'18781066-e255-4b06-9d94-7b0ed1206a9c',6,'861a4f2b70b249afadeabfe85bda53a3','gigabytes',-1,'2026-01-21 14:26:03',NULL),('2026-01-20 14:26:03','2026-01-20 14:26:03','2026-01-20 14:26:03',1,15,'b38fbd02-f7fb-4b0a-9cdc-613cd32b6e55',7,'861a4f2b70b249afadeabfe85bda53a3','volumes___DEFAULT__',-1,'2026-01-21 14:26:03',NULL),('2026-01-20 14:26:03','2026-01-20 14:26:03','2026-01-20 14:26:03',1,16,'9d470630-63bf-4357-bdb6-2f2bc1d476c7',8,'861a4f2b70b249afadeabfe85bda53a3','gigabytes___DEFAULT__',-1,'2026-01-21 14:26:03',NULL),('2026-01-20 14:27:59','2026-01-20 14:27:59','2026-01-20 14:27:59',1,17,'ff1a8ace-eca6-41e1-b43a-5bec8659f26b',9,'d15f60b9e48e4175b5520d1e57ed2d3a','volumes',1,'2026-01-21 14:27:59',NULL),('2026-01-20 14:27:59','2026-01-20 14:27:59','2026-01-20 14:27:59',1,18,'82bda1c8-55f5-48c1-9f0b-db3d7d30d3bd',10,'d15f60b9e48e4175b5520d1e57ed2d3a','gigabytes',1,'2026-01-21 14:27:59',NULL),('2026-01-20 14:27:59','2026-01-20 14:27:59','2026-01-20 14:27:59',1,19,'24983812-9e3e-4791-86d4-7f5544c417d2',11,'d15f60b9e48e4175b5520d1e57ed2d3a','volumes___DEFAULT__',1,'2026-01-21 14:27:59',NULL),('2026-01-20 14:27:59','2026-01-20 14:27:59','2026-01-20 14:27:59',1,20,'983a3221-51fb-4f47-a760-e5d46c9e6067',12,'d15f60b9e48e4175b5520d1e57ed2d3a','gigabytes___DEFAULT__',1,'2026-01-21 14:27:59',NULL),('2026-01-20 14:28:13','2026-01-20 14:28:14','2026-01-20 14:28:14',1,21,'2f40c54e-c4ec-4e32-8f4a-4e33bbbb940b',13,'944b426a2d4c4ad3a01f0b855ad36509','volumes',1,'2026-01-21 14:28:13',NULL),('2026-01-20 14:28:13','2026-01-20 14:28:14','2026-01-20 14:28:14',1,22,'ff1daad5-4392-4026-841e-dd6770e8a29a',14,'944b426a2d4c4ad3a01f0b855ad36509','gigabytes',1,'2026-01-21 14:28:13',NULL),('2026-01-20 14:28:13','2026-01-20 14:28:14','2026-01-20 14:28:14',1,23,'ad99e1e5-2818-4bfb-8368-5dd2cf406fe6',15,'944b426a2d4c4ad3a01f0b855ad36509','volumes___DEFAULT__',1,'2026-01-21 14:28:13',NULL),('2026-01-20 14:28:13','2026-01-20 14:28:14','2026-01-20 14:28:14',1,24,'e378413d-03ce-4789-8666-0d3f9504820b',16,'944b426a2d4c4ad3a01f0b855ad36509','gigabytes___DEFAULT__',1,'2026-01-21 14:28:13',NULL),('2026-01-20 14:28:32','2026-01-20 14:28:32','2026-01-20 14:28:32',1,25,'d45cbee4-5db5-46ab-b825-28adb6cdbd62',13,'944b426a2d4c4ad3a01f0b855ad36509','volumes',-1,'2026-01-21 14:28:32',NULL),('2026-01-20 14:28:32','2026-01-20 14:28:32','2026-01-20 14:28:32',1,26,'a80b2b81-b719-462a-bd7a-2b670db7594e',14,'944b426a2d4c4ad3a01f0b855ad36509','gigabytes',-1,'2026-01-21 14:28:32',NULL),('2026-01-20 14:28:32','2026-01-20 14:28:32','2026-01-20 14:28:32',1,27,'a6efe7eb-4fac-41e3-ada3-1e992731a7b7',15,'944b426a2d4c4ad3a01f0b855ad36509','volumes___DEFAULT__',-1,'2026-01-21 14:28:32',NULL),('2026-01-20 14:28:32','2026-01-20 14:28:32','2026-01-20 14:28:32',1,28,'19201be7-e533-4baf-ae68-9ece367e57e2',16,'944b426a2d4c4ad3a01f0b855ad36509','gigabytes___DEFAULT__',-1,'2026-01-21 14:28:32',NULL),('2026-01-20 14:29:08','2026-01-20 14:29:08','2026-01-20 14:29:08',1,29,'bbe5f267-1bbc-4f44-aa4d-5dc95c60e7d8',17,'0cee74dd60da4a839bb5eb0ba3137edf','volumes',1,'2026-01-21 14:29:08',NULL),('2026-01-20 14:29:08','2026-01-20 14:29:08','2026-01-20 14:29:08',1,30,'4750d575-b180-4a97-a6ba-6b4de66cf5fb',18,'0cee74dd60da4a839bb5eb0ba3137edf','gigabytes',1,'2026-01-21 14:29:08',NULL),('2026-01-20 14:29:08','2026-01-20 14:29:08','2026-01-20 14:29:08',1,31,'5c2c682b-16be-4f49-b20e-9ed9ec55bfd0',19,'0cee74dd60da4a839bb5eb0ba3137edf','volumes_multiattach',1,'2026-01-21 14:29:08',NULL),('2026-01-20 14:29:08','2026-01-20 14:29:08','2026-01-20 14:29:08',1,32,'9d99f444-66e4-4855-9864-e84363882083',20,'0cee74dd60da4a839bb5eb0ba3137edf','gigabytes_multiattach',1,'2026-01-21 14:29:08',NULL),('2026-01-20 14:29:10','2026-01-20 14:29:10','2026-01-20 14:29:10',1,33,'82437c59-2812-4e37-a982-278844a26152',17,'0cee74dd60da4a839bb5eb0ba3137edf','volumes',1,'2026-01-21 14:29:10',NULL),('2026-01-20 14:29:10','2026-01-20 14:29:10','2026-01-20 14:29:10',1,34,'a332b6c7-b6f8-4719-a58c-cd734615c4dc',18,'0cee74dd60da4a839bb5eb0ba3137edf','gigabytes',1,'2026-01-21 14:29:10',NULL),('2026-01-20 14:29:10','2026-01-20 14:29:10','2026-01-20 14:29:10',1,35,'c6a08682-4546-4e68-b41a-3d4d33acf624',19,'0cee74dd60da4a839bb5eb0ba3137edf','volumes_multiattach',1,'2026-01-21 14:29:10',NULL),('2026-01-20 14:29:10','2026-01-20 14:29:10','2026-01-20 14:29:10',1,36,'397adab6-7e5c-4598-b2e0-761c0af2f559',20,'0cee74dd60da4a839bb5eb0ba3137edf','gigabytes_multiattach',1,'2026-01-21 14:29:10',NULL),('2026-01-20 14:29:13','2026-01-20 14:29:13','2026-01-20 14:29:13',1,37,'1233c8ba-be7d-44eb-9d62-ae2d4cbf58d8',9,'d15f60b9e48e4175b5520d1e57ed2d3a','volumes',-1,'2026-01-21 14:29:13',NULL),('2026-01-20 14:29:13','2026-01-20 14:29:13','2026-01-20 14:29:13',1,38,'33660e29-4c05-4d01-9963-39e2b22b34da',10,'d15f60b9e48e4175b5520d1e57ed2d3a','gigabytes',-1,'2026-01-21 14:29:13',NULL),('2026-01-20 14:29:13','2026-01-20 14:29:13','2026-01-20 14:29:13',1,39,'953ac617-2b23-48a0-9d55-cc48f0a2202b',11,'d15f60b9e48e4175b5520d1e57ed2d3a','volumes___DEFAULT__',-1,'2026-01-21 14:29:13',NULL),('2026-01-20 14:29:13','2026-01-20 14:29:13','2026-01-20 14:29:13',1,40,'0e700f76-c357-4b2e-b64b-74472eb694c7',12,'d15f60b9e48e4175b5520d1e57ed2d3a','gigabytes___DEFAULT__',-1,'2026-01-21 14:29:13',NULL),('2026-01-20 14:31:52','2026-01-20 14:31:52','2026-01-20 14:31:52',1,41,'431ad9d8-348f-454c-8776-81b74b1bf34f',17,'0cee74dd60da4a839bb5eb0ba3137edf','volumes',-1,'2026-01-21 14:31:52',NULL),('2026-01-20 14:31:52','2026-01-20 14:31:52','2026-01-20 14:31:52',1,42,'02ea22aa-db3c-496d-b9f0-45c2600b9380',18,'0cee74dd60da4a839bb5eb0ba3137edf','gigabytes',-1,'2026-01-21 14:31:52',NULL),('2026-01-20 14:31:52','2026-01-20 14:31:52','2026-01-20 14:31:52',1,43,'eeb8a5e6-388c-415d-9f76-4ac2d6b45689',19,'0cee74dd60da4a839bb5eb0ba3137edf','volumes_multiattach',-1,'2026-01-21 14:31:52',NULL),('2026-01-20 14:31:52','2026-01-20 14:31:52','2026-01-20 14:31:52',1,44,'118496e1-dcef-4191-871e-b7eec68dfc43',20,'0cee74dd60da4a839bb5eb0ba3137edf','gigabytes_multiattach',-1,'2026-01-21 14:31:52',NULL),('2026-01-20 14:31:54','2026-01-20 14:31:54','2026-01-20 14:31:54',1,45,'fe03ae0e-d2ed-4657-88aa-f28cd19fdb34',17,'0cee74dd60da4a839bb5eb0ba3137edf','volumes',-1,'2026-01-21 14:31:54',NULL),('2026-01-20 14:31:54','2026-01-20 14:31:54','2026-01-20 14:31:54',1,46,'fca4a785-7c0b-4a49-835e-f605986e6519',18,'0cee74dd60da4a839bb5eb0ba3137edf','gigabytes',-1,'2026-01-21 14:31:54',NULL),('2026-01-20 14:31:54','2026-01-20 14:31:54','2026-01-20 14:31:54',1,47,'c169d264-39ee-46b4-af44-de50742d418d',19,'0cee74dd60da4a839bb5eb0ba3137edf','volumes_multiattach',-1,'2026-01-21 14:31:54',NULL),('2026-01-20 14:31:54','2026-01-20 14:31:54','2026-01-20 14:31:54',1,48,'d649b8e3-82b2-48c4-9fdf-788b13b39c60',20,'0cee74dd60da4a839bb5eb0ba3137edf','gigabytes_multiattach',-1,'2026-01-21 14:31:54',NULL),('2026-01-20 14:33:26','2026-01-20 14:33:26','2026-01-20 14:33:26',1,49,'6966bf4c-bed9-4406-96e0-4ac994f6c3d7',21,'48488e875f2e472f97f07cc7ee07e0be','volumes',1,'2026-01-21 14:33:26',NULL),('2026-01-20 14:33:26','2026-01-20 14:33:26','2026-01-20 14:33:26',1,50,'04c084b1-61ec-4758-b34c-b67d5dd3620f',22,'48488e875f2e472f97f07cc7ee07e0be','gigabytes',1,'2026-01-21 14:33:26',NULL),('2026-01-20 14:33:26','2026-01-20 14:33:26','2026-01-20 14:33:26',1,51,'12ff3b18-283b-478a-9e4a-44d2be6ff1d4',23,'48488e875f2e472f97f07cc7ee07e0be','volumes___DEFAULT__',1,'2026-01-21 14:33:26',NULL),('2026-01-20 14:33:26','2026-01-20 14:33:26','2026-01-20 14:33:26',1,52,'85ba6b41-5c1f-4ab7-801c-7f585ebae966',24,'48488e875f2e472f97f07cc7ee07e0be','gigabytes___DEFAULT__',1,'2026-01-21 14:33:26',NULL),('2026-01-20 14:33:59','2026-01-20 14:33:59','2026-01-20 14:33:59',1,53,'19359c76-091a-4d16-93b9-5bad59206381',21,'48488e875f2e472f97f07cc7ee07e0be','volumes',1,'2026-01-21 14:33:59',NULL),('2026-01-20 14:33:59','2026-01-20 14:33:59','2026-01-20 14:33:59',1,54,'49970e85-b8d4-4618-afac-f0ddab42fdfe',22,'48488e875f2e472f97f07cc7ee07e0be','gigabytes',1,'2026-01-21 14:33:59',NULL),('2026-01-20 14:33:59','2026-01-20 14:33:59','2026-01-20 14:33:59',1,55,'f51cfb55-a8df-4de4-83cf-ea0ae37b25ec',23,'48488e875f2e472f97f07cc7ee07e0be','volumes___DEFAULT__',1,'2026-01-21 14:33:59',NULL),('2026-01-20 14:33:59','2026-01-20 14:33:59','2026-01-20 14:33:59',1,56,'3f74963c-e37f-4e9c-972e-5c0eed69bc6b',24,'48488e875f2e472f97f07cc7ee07e0be','gigabytes___DEFAULT__',1,'2026-01-21 14:33:59',NULL),('2026-01-20 14:34:03','2026-01-20 14:34:03','2026-01-20 14:34:03',1,57,'557aa9cc-1ab7-468a-be4f-25a77debf016',21,'48488e875f2e472f97f07cc7ee07e0be','volumes',-1,'2026-01-21 14:34:03',NULL),('2026-01-20 14:34:03','2026-01-20 14:34:03','2026-01-20 14:34:03',1,58,'b8f6b9a9-0b25-49e2-921f-a73f21e31f8e',22,'48488e875f2e472f97f07cc7ee07e0be','gigabytes',-1,'2026-01-21 14:34:03',NULL),('2026-01-20 14:34:03','2026-01-20 14:34:03','2026-01-20 14:34:03',1,59,'948eae3e-29d9-47d8-a626-2a6de693d8e9',23,'48488e875f2e472f97f07cc7ee07e0be','volumes___DEFAULT__',-1,'2026-01-21 14:34:03',NULL),('2026-01-20 14:34:03','2026-01-20 14:34:03','2026-01-20 14:34:03',1,60,'78b0db4f-c5cc-4b0c-b60b-d47c94133cab',24,'48488e875f2e472f97f07cc7ee07e0be','gigabytes___DEFAULT__',-1,'2026-01-21 14:34:03',NULL),('2026-01-20 14:34:15','2026-01-20 14:34:15','2026-01-20 14:34:15',1,61,'f758d415-ab36-4323-8952-2850c8af56b9',21,'48488e875f2e472f97f07cc7ee07e0be','volumes',-1,'2026-01-21 14:34:15',NULL),('2026-01-20 14:34:15','2026-01-20 14:34:15','2026-01-20 14:34:15',1,62,'2bb8903a-8c41-4ebe-9a2b-dc2800e10f5d',22,'48488e875f2e472f97f07cc7ee07e0be','gigabytes',-1,'2026-01-21 14:34:15',NULL),('2026-01-20 14:34:15','2026-01-20 14:34:15','2026-01-20 14:34:15',1,63,'7f5276e1-d53b-40aa-bbf9-9c3cce1dfe25',23,'48488e875f2e472f97f07cc7ee07e0be','volumes___DEFAULT__',-1,'2026-01-21 14:34:15',NULL),('2026-01-20 14:34:15','2026-01-20 14:34:15','2026-01-20 14:34:15',1,64,'0464f6df-28e1-442e-a5dc-ed6e0541e9f5',24,'48488e875f2e472f97f07cc7ee07e0be','gigabytes___DEFAULT__',-1,'2026-01-21 14:34:15',NULL),('2026-01-20 14:38:30','2026-01-20 14:38:30','2026-01-20 14:38:30',1,65,'79c65e2c-2f46-4a76-997a-92c7033821f2',25,'8705404c3964472782118e478eb54e51','volumes',1,'2026-01-21 14:38:30',NULL),('2026-01-20 14:38:30','2026-01-20 14:38:30','2026-01-20 14:38:30',1,66,'0789966d-7b2f-4083-9203-1a8d0b4167ee',26,'8705404c3964472782118e478eb54e51','gigabytes',1,'2026-01-21 14:38:30',NULL),('2026-01-20 14:38:30','2026-01-20 14:38:30','2026-01-20 14:38:30',1,67,'8946b5cf-1d56-43bb-940a-90b51b5c9f6a',27,'8705404c3964472782118e478eb54e51','volumes___DEFAULT__',1,'2026-01-21 14:38:30',NULL),('2026-01-20 14:38:30','2026-01-20 14:38:30','2026-01-20 14:38:30',1,68,'6e42618d-f91d-4213-b879-4dd10c8dcc0a',28,'8705404c3964472782118e478eb54e51','gigabytes___DEFAULT__',1,'2026-01-21 14:38:30',NULL),('2026-01-20 14:38:39','2026-01-20 14:38:39','2026-01-20 14:38:39',1,69,'61719557-42a1-4880-a07a-38849c5af6f4',25,'8705404c3964472782118e478eb54e51','volumes',1,'2026-01-21 14:38:39',NULL),('2026-01-20 14:38:39','2026-01-20 14:38:39','2026-01-20 14:38:39',1,70,'077f9a42-c592-42bd-aa7c-a688ab898b44',26,'8705404c3964472782118e478eb54e51','gigabytes',1,'2026-01-21 14:38:39',NULL),('2026-01-20 14:38:39','2026-01-20 14:38:39','2026-01-20 14:38:39',1,71,'14b4254a-fef2-47b8-a0a6-bd929298f66e',27,'8705404c3964472782118e478eb54e51','volumes___DEFAULT__',1,'2026-01-21 14:38:39',NULL),('2026-01-20 14:38:39','2026-01-20 14:38:39','2026-01-20 14:38:39',1,72,'ac2cf337-b0cf-4375-b39a-bcc2d4b2b4a8',28,'8705404c3964472782118e478eb54e51','gigabytes___DEFAULT__',1,'2026-01-21 14:38:39',NULL),('2026-01-20 14:38:41','2026-01-20 14:38:41','2026-01-20 14:38:41',1,73,'e09dc5a9-490e-4c5f-9ac8-ad362a98b984',25,'8705404c3964472782118e478eb54e51','volumes',1,'2026-01-21 14:38:41',NULL),('2026-01-20 14:38:41','2026-01-20 14:38:41','2026-01-20 14:38:41',1,74,'df84c4ef-8672-4106-bdc4-78b0154e673a',26,'8705404c3964472782118e478eb54e51','gigabytes',1,'2026-01-21 14:38:41',NULL),('2026-01-20 14:38:41','2026-01-20 14:38:41','2026-01-20 14:38:41',1,75,'b99efd8c-eba7-41d0-8b0f-909149f55438',27,'8705404c3964472782118e478eb54e51','volumes___DEFAULT__',1,'2026-01-21 14:38:41',NULL),('2026-01-20 14:38:41','2026-01-20 14:38:41','2026-01-20 14:38:41',1,76,'0eddaf64-51dd-4f19-9bdb-64463721a80b',28,'8705404c3964472782118e478eb54e51','gigabytes___DEFAULT__',1,'2026-01-21 14:38:41',NULL),('2026-01-20 14:40:31','2026-01-20 14:40:31','2026-01-20 14:40:31',1,77,'3852b2f3-6198-4a20-a848-7f9cb493cd91',25,'8705404c3964472782118e478eb54e51','volumes',-1,'2026-01-21 14:40:31',NULL),('2026-01-20 14:40:31','2026-01-20 14:40:31','2026-01-20 14:40:31',1,78,'fb2d1a8f-1f44-4776-b9b8-4e806f524cfd',26,'8705404c3964472782118e478eb54e51','gigabytes',-1,'2026-01-21 14:40:31',NULL),('2026-01-20 14:40:31','2026-01-20 14:40:31','2026-01-20 14:40:31',1,79,'6e0384f7-87d6-44bd-a034-803a578171e5',27,'8705404c3964472782118e478eb54e51','volumes___DEFAULT__',-1,'2026-01-21 14:40:31',NULL),('2026-01-20 14:40:31','2026-01-20 14:40:31','2026-01-20 14:40:31',1,80,'455b5312-2e7a-4eec-b6cb-457cdf377b92',28,'8705404c3964472782118e478eb54e51','gigabytes___DEFAULT__',-1,'2026-01-21 14:40:31',NULL),('2026-01-20 14:40:33','2026-01-20 14:40:33','2026-01-20 14:40:33',1,81,'15a1115a-cc91-4b1f-9434-c226815103d5',25,'8705404c3964472782118e478eb54e51','volumes',-1,'2026-01-21 14:40:33',NULL),('2026-01-20 14:40:33','2026-01-20 14:40:33','2026-01-20 14:40:33',1,82,'f26026df-6311-43e8-a44a-63da80bbc3fe',26,'8705404c3964472782118e478eb54e51','gigabytes',-1,'2026-01-21 14:40:33',NULL),('2026-01-20 14:40:33','2026-01-20 14:40:33','2026-01-20 14:40:33',1,83,'71ea5a4c-eefe-420f-a131-1d14dcc9d723',27,'8705404c3964472782118e478eb54e51','volumes___DEFAULT__',-1,'2026-01-21 14:40:33',NULL),('2026-01-20 14:40:33','2026-01-20 14:40:33','2026-01-20 14:40:33',1,84,'94873b9d-53ff-425a-a88a-35baebe25909',28,'8705404c3964472782118e478eb54e51','gigabytes___DEFAULT__',-1,'2026-01-21 14:40:33',NULL),('2026-01-20 14:40:36','2026-01-20 14:40:36','2026-01-20 14:40:36',1,85,'d5caba86-f348-4e9c-b1f5-60153f453430',25,'8705404c3964472782118e478eb54e51','volumes',-1,'2026-01-21 14:40:36',NULL),('2026-01-20 14:40:36','2026-01-20 14:40:36','2026-01-20 14:40:36',1,86,'f5f02a97-baf0-40a5-bb73-30e695eb15dc',26,'8705404c3964472782118e478eb54e51','gigabytes',-1,'2026-01-21 14:40:36',NULL),('2026-01-20 14:40:36','2026-01-20 14:40:36','2026-01-20 14:40:36',1,87,'9686d03d-8668-4cd0-8f65-dd043e3987af',27,'8705404c3964472782118e478eb54e51','volumes___DEFAULT__',-1,'2026-01-21 14:40:36',NULL),('2026-01-20 14:40:36','2026-01-20 14:40:36','2026-01-20 14:40:36',1,88,'e39ed609-d36f-4848-8d98-a08c6667016b',28,'8705404c3964472782118e478eb54e51','gigabytes___DEFAULT__',-1,'2026-01-21 14:40:36',NULL),('2026-01-20 14:44:27','2026-01-20 14:44:27','2026-01-20 14:44:27',1,89,'4820040b-2bfe-43d0-a0a9-ba38484d76ee',29,'3b31139b2a4e49cba5e7048febf901c4','volumes',1,'2026-01-21 14:44:27',NULL),('2026-01-20 14:44:27','2026-01-20 14:44:27','2026-01-20 14:44:27',1,90,'c5283564-7ced-4734-b4ad-8a6e3685b498',30,'3b31139b2a4e49cba5e7048febf901c4','gigabytes',1,'2026-01-21 14:44:27',NULL),('2026-01-20 14:44:27','2026-01-20 14:44:27','2026-01-20 14:44:27',1,91,'07f61ba1-63d7-4dcc-9b81-b1cc549bd2da',31,'3b31139b2a4e49cba5e7048febf901c4','volumes___DEFAULT__',1,'2026-01-21 14:44:27',NULL),('2026-01-20 14:44:27','2026-01-20 14:44:27','2026-01-20 14:44:27',1,92,'422b8232-f3a0-408b-9164-dbcda7b05ea2',32,'3b31139b2a4e49cba5e7048febf901c4','gigabytes___DEFAULT__',1,'2026-01-21 14:44:27',NULL),('2026-01-20 14:44:29','2026-01-20 14:44:29','2026-01-20 14:44:29',1,93,'1e2b4e95-e674-4c73-ae36-c6e15e4b983b',33,'144d821b8f624db687f0e009c5e06d8b','volumes',1,'2026-01-21 14:44:29',NULL),('2026-01-20 14:44:29','2026-01-20 14:44:29','2026-01-20 14:44:29',1,94,'7f4274b1-9c15-43f3-aab2-dcbeb89511f8',34,'144d821b8f624db687f0e009c5e06d8b','gigabytes',1,'2026-01-21 14:44:29',NULL),('2026-01-20 14:44:29','2026-01-20 14:44:29','2026-01-20 14:44:29',1,95,'eb88353b-126d-4616-858a-8fce94bdfe5e',35,'144d821b8f624db687f0e009c5e06d8b','volumes___DEFAULT__',1,'2026-01-21 14:44:29',NULL),('2026-01-20 14:44:29','2026-01-20 14:44:29','2026-01-20 14:44:29',1,96,'666dc254-a2f3-48c3-9c99-365a5d5b3c5c',36,'144d821b8f624db687f0e009c5e06d8b','gigabytes___DEFAULT__',1,'2026-01-21 14:44:29',NULL),('2026-01-20 14:45:30','2026-01-20 14:45:30','2026-01-20 14:45:30',1,97,'23f6d7fc-7ac2-4172-b0da-d198db46b906',33,'144d821b8f624db687f0e009c5e06d8b','volumes',-1,'2026-01-21 14:45:30',NULL),('2026-01-20 14:45:30','2026-01-20 14:45:30','2026-01-20 14:45:30',1,98,'af8a26b7-d30f-4e99-826a-498320a36a6d',34,'144d821b8f624db687f0e009c5e06d8b','gigabytes',-1,'2026-01-21 14:45:30',NULL),('2026-01-20 14:45:30','2026-01-20 14:45:30','2026-01-20 14:45:30',1,99,'5baa1b3f-e1e4-4be7-993e-138b0e9d94b1',35,'144d821b8f624db687f0e009c5e06d8b','volumes___DEFAULT__',-1,'2026-01-21 14:45:30',NULL),('2026-01-20 14:45:30','2026-01-20 14:45:30','2026-01-20 14:45:30',1,100,'a4205ba0-f4a4-4be0-9b5d-a2029cfecae8',36,'144d821b8f624db687f0e009c5e06d8b','gigabytes___DEFAULT__',-1,'2026-01-21 14:45:30',NULL),('2026-01-20 14:45:35','2026-01-20 14:45:35','2026-01-20 14:45:35',1,101,'c5bc7a2c-943f-45d8-8e82-6f659d14ef8b',37,'b683fcc0026242e28ba6d8fba638688e','volumes',1,'2026-01-21 14:45:35',NULL),('2026-01-20 14:45:35','2026-01-20 14:45:35','2026-01-20 14:45:35',1,102,'a0518a2e-3e3a-4cbe-9ac3-5a23561b787f',38,'b683fcc0026242e28ba6d8fba638688e','gigabytes',1,'2026-01-21 14:45:35',NULL),('2026-01-20 14:45:35','2026-01-20 14:45:35','2026-01-20 14:45:35',1,103,'d2d21a49-897e-472c-a0b6-52e573c51da1',39,'b683fcc0026242e28ba6d8fba638688e','volumes___DEFAULT__',1,'2026-01-21 14:45:35',NULL),('2026-01-20 14:45:35','2026-01-20 14:45:35','2026-01-20 14:45:35',1,104,'537321c3-71ee-4f69-a7e8-83b10e2c64c2',40,'b683fcc0026242e28ba6d8fba638688e','gigabytes___DEFAULT__',1,'2026-01-21 14:45:35',NULL),('2026-01-20 14:46:00','2026-01-20 14:46:00','2026-01-20 14:46:00',1,105,'5a428bac-dc4a-48b7-b1bb-3cb7964b43e6',41,'7bbf722f17654404925cfb53e48cd473','volumes',1,'2026-01-21 14:46:00',NULL),('2026-01-20 14:46:00','2026-01-20 14:46:00','2026-01-20 14:46:00',1,106,'8d8269da-500f-4c65-b590-c3185d6416ea',42,'7bbf722f17654404925cfb53e48cd473','gigabytes',1,'2026-01-21 14:46:00',NULL),('2026-01-20 14:46:00','2026-01-20 14:46:00','2026-01-20 14:46:00',1,107,'0d5d51da-e542-468f-b2d4-7f256f1f28ea',43,'7bbf722f17654404925cfb53e48cd473','volumes___DEFAULT__',1,'2026-01-21 14:46:00',NULL),('2026-01-20 14:46:00','2026-01-20 14:46:00','2026-01-20 14:46:00',1,108,'eb2cc7f9-15bd-4d88-aa90-04a0f5220d9b',44,'7bbf722f17654404925cfb53e48cd473','gigabytes___DEFAULT__',1,'2026-01-21 14:46:00',NULL),('2026-01-20 14:47:07','2026-01-20 14:47:07','2026-01-20 14:47:07',1,109,'bae52918-3d8a-4ff8-8876-61de01998a4f',41,'7bbf722f17654404925cfb53e48cd473','volumes',-1,'2026-01-21 14:47:07',NULL),('2026-01-20 14:47:07','2026-01-20 14:47:07','2026-01-20 14:47:07',1,110,'32cf3ee8-0546-4581-b503-38b3d6cb31b7',42,'7bbf722f17654404925cfb53e48cd473','gigabytes',-1,'2026-01-21 14:47:07',NULL),('2026-01-20 14:47:07','2026-01-20 14:47:07','2026-01-20 14:47:07',1,111,'fb23ac91-1283-4aaa-9d86-7d64ef599439',43,'7bbf722f17654404925cfb53e48cd473','volumes___DEFAULT__',-1,'2026-01-21 14:47:07',NULL),('2026-01-20 14:47:07','2026-01-20 14:47:07','2026-01-20 14:47:07',1,112,'50a675f5-e982-4d7e-9046-cb549e7e5ed1',44,'7bbf722f17654404925cfb53e48cd473','gigabytes___DEFAULT__',-1,'2026-01-21 14:47:07',NULL),('2026-01-20 14:47:20','2026-01-20 14:47:20','2026-01-20 14:47:20',1,113,'6f9c19ee-9125-4ecf-8c91-94c07c0fcee7',37,'b683fcc0026242e28ba6d8fba638688e','volumes',1,'2026-01-21 14:47:20',NULL),('2026-01-20 14:47:20','2026-01-20 14:47:20','2026-01-20 14:47:20',1,114,'1ba41387-ebdb-4dc1-8d7d-0008695ea83b',38,'b683fcc0026242e28ba6d8fba638688e','gigabytes',1,'2026-01-21 14:47:20',NULL),('2026-01-20 14:47:20','2026-01-20 14:47:20','2026-01-20 14:47:20',1,115,'0f1e1126-4eba-4d52-b451-2fdc988977fd',39,'b683fcc0026242e28ba6d8fba638688e','volumes___DEFAULT__',1,'2026-01-21 14:47:20',NULL),('2026-01-20 14:47:20','2026-01-20 14:47:20','2026-01-20 14:47:20',1,116,'5345ece2-3775-4e60-8321-6d734f77328f',40,'b683fcc0026242e28ba6d8fba638688e','gigabytes___DEFAULT__',1,'2026-01-21 14:47:20',NULL),('2026-01-20 14:47:58','2026-01-20 14:47:58','2026-01-20 14:47:58',1,117,'ee2052b5-c37c-43d9-88c3-3516a263afa7',29,'3b31139b2a4e49cba5e7048febf901c4','volumes',-1,'2026-01-21 14:47:58',NULL),('2026-01-20 14:47:58','2026-01-20 14:47:58','2026-01-20 14:47:58',1,118,'f676da1b-4074-48e6-b93e-2662f99d4a95',30,'3b31139b2a4e49cba5e7048febf901c4','gigabytes',-1,'2026-01-21 14:47:58',NULL),('2026-01-20 14:47:58','2026-01-20 14:47:58','2026-01-20 14:47:58',1,119,'8a19e0a6-b5f3-4b44-ab39-0c3ad2534c87',31,'3b31139b2a4e49cba5e7048febf901c4','volumes___DEFAULT__',-1,'2026-01-21 14:47:58',NULL),('2026-01-20 14:47:58','2026-01-20 14:47:58','2026-01-20 14:47:58',1,120,'b8528fbd-a81f-4653-8393-c78da8b9f40d',32,'3b31139b2a4e49cba5e7048febf901c4','gigabytes___DEFAULT__',-1,'2026-01-21 14:47:58',NULL),('2026-01-20 14:48:38','2026-01-20 14:48:38','2026-01-20 14:48:38',1,121,'7a49f561-a773-4b1a-bd22-0cd020e6f401',45,'b15c4e6eb57e4b0ca4e63c85ed92fc5f','volumes',1,'2026-01-21 14:48:38',NULL),('2026-01-20 14:48:38','2026-01-20 14:48:38','2026-01-20 14:48:38',1,122,'7f83a4ec-9cbd-4080-ae61-0acbb9ce87be',46,'b15c4e6eb57e4b0ca4e63c85ed92fc5f','gigabytes',1,'2026-01-21 14:48:38',NULL),('2026-01-20 14:48:38','2026-01-20 14:48:38','2026-01-20 14:48:38',1,123,'2f167f88-d805-4966-886b-6e909a1af4fa',47,'b15c4e6eb57e4b0ca4e63c85ed92fc5f','volumes___DEFAULT__',1,'2026-01-21 14:48:38',NULL),('2026-01-20 14:48:38','2026-01-20 14:48:38','2026-01-20 14:48:38',1,124,'183e21c1-b700-4041-959a-eb0bf0b6817f',48,'b15c4e6eb57e4b0ca4e63c85ed92fc5f','gigabytes___DEFAULT__',1,'2026-01-21 14:48:38',NULL),('2026-01-20 14:48:41','2026-01-20 14:48:41','2026-01-20 14:48:41',1,125,'e8b11be6-9c9f-4dbf-a226-a50191903355',37,'b683fcc0026242e28ba6d8fba638688e','volumes',-1,'2026-01-21 14:48:40',NULL),('2026-01-20 14:48:41','2026-01-20 14:48:41','2026-01-20 14:48:41',1,126,'df956256-5be5-4213-a8e0-280d3613ef1b',38,'b683fcc0026242e28ba6d8fba638688e','gigabytes',-1,'2026-01-21 14:48:40',NULL),('2026-01-20 14:48:41','2026-01-20 14:48:41','2026-01-20 14:48:41',1,127,'272aaabf-21d7-4c60-b20d-57ab448c6260',39,'b683fcc0026242e28ba6d8fba638688e','volumes___DEFAULT__',-1,'2026-01-21 14:48:40',NULL),('2026-01-20 14:48:41','2026-01-20 14:48:41','2026-01-20 14:48:41',1,128,'62d4d5e3-724d-48ad-b958-b89671b395af',40,'b683fcc0026242e28ba6d8fba638688e','gigabytes___DEFAULT__',-1,'2026-01-21 14:48:40',NULL),('2026-01-20 14:48:47','2026-01-20 14:48:47','2026-01-20 14:48:47',1,129,'2cf5a60e-9059-4a1a-a206-b0cb011f73da',45,'b15c4e6eb57e4b0ca4e63c85ed92fc5f','volumes',1,'2026-01-21 14:48:47',NULL),('2026-01-20 14:48:47','2026-01-20 14:48:47','2026-01-20 14:48:47',1,130,'8c3e4664-2867-4fe6-a0ec-e5c1ab7b99b5',46,'b15c4e6eb57e4b0ca4e63c85ed92fc5f','gigabytes',1,'2026-01-21 14:48:47',NULL),('2026-01-20 14:48:47','2026-01-20 14:48:47','2026-01-20 14:48:47',1,131,'80db5766-dc6a-439f-848c-f08100084ea7',47,'b15c4e6eb57e4b0ca4e63c85ed92fc5f','volumes___DEFAULT__',1,'2026-01-21 14:48:47',NULL),('2026-01-20 14:48:47','2026-01-20 14:48:47','2026-01-20 14:48:47',1,132,'c61fa77f-16f7-4045-9a8c-d60be6679240',48,'b15c4e6eb57e4b0ca4e63c85ed92fc5f','gigabytes___DEFAULT__',1,'2026-01-21 14:48:47',NULL),('2026-01-20 14:48:48','2026-01-20 14:48:48','2026-01-20 14:48:48',1,133,'bf8cad88-8252-4884-b9c5-bea695e21526',37,'b683fcc0026242e28ba6d8fba638688e','volumes',-1,'2026-01-21 14:48:48',NULL),('2026-01-20 14:48:48','2026-01-20 14:48:48','2026-01-20 14:48:48',1,134,'68a3a7b4-a333-4457-9f50-673092f00ff7',38,'b683fcc0026242e28ba6d8fba638688e','gigabytes',-1,'2026-01-21 14:48:48',NULL),('2026-01-20 14:48:48','2026-01-20 14:48:48','2026-01-20 14:48:48',1,135,'fade9526-3d91-4313-aaf9-ed155d05099b',39,'b683fcc0026242e28ba6d8fba638688e','volumes___DEFAULT__',-1,'2026-01-21 14:48:48',NULL),('2026-01-20 14:48:48','2026-01-20 14:48:48','2026-01-20 14:48:48',1,136,'8fa00f27-0df6-41e4-beeb-e4dd0e56dea0',40,'b683fcc0026242e28ba6d8fba638688e','gigabytes___DEFAULT__',-1,'2026-01-21 14:48:48',NULL),('2026-01-20 14:48:49','2026-01-20 14:48:49','2026-01-20 14:48:49',1,137,'ac6fde99-59ac-4ac9-a594-0061a6a98f5b',45,'b15c4e6eb57e4b0ca4e63c85ed92fc5f','volumes',1,'2026-01-21 14:48:49',NULL),('2026-01-20 14:48:49','2026-01-20 14:48:49','2026-01-20 14:48:49',1,138,'3479c7a6-58f0-4ce9-b4f7-cc2bde6e634c',46,'b15c4e6eb57e4b0ca4e63c85ed92fc5f','gigabytes',1,'2026-01-21 14:48:49',NULL),('2026-01-20 14:48:49','2026-01-20 14:48:49','2026-01-20 14:48:49',1,139,'7f2a2962-8189-45db-ac91-386bb455b26e',47,'b15c4e6eb57e4b0ca4e63c85ed92fc5f','volumes___DEFAULT__',1,'2026-01-21 14:48:49',NULL),('2026-01-20 14:48:49','2026-01-20 14:48:49','2026-01-20 14:48:49',1,140,'e1509afe-489a-4b76-aaba-6ae520144be0',48,'b15c4e6eb57e4b0ca4e63c85ed92fc5f','gigabytes___DEFAULT__',1,'2026-01-21 14:48:49',NULL),('2026-01-20 14:51:18','2026-01-20 14:51:18','2026-01-20 14:51:18',1,141,'12407673-3295-4161-ac58-1c8a889059cd',45,'b15c4e6eb57e4b0ca4e63c85ed92fc5f','volumes',-1,'2026-01-21 14:51:18',NULL),('2026-01-20 14:51:18','2026-01-20 14:51:18','2026-01-20 14:51:18',1,142,'884579e7-5cbb-4c55-9233-08b05beb3bc4',46,'b15c4e6eb57e4b0ca4e63c85ed92fc5f','gigabytes',-1,'2026-01-21 14:51:18',NULL),('2026-01-20 14:51:18','2026-01-20 14:51:18','2026-01-20 14:51:18',1,143,'23dd6677-a504-4a12-803b-e4cbb0ab4c1e',47,'b15c4e6eb57e4b0ca4e63c85ed92fc5f','volumes___DEFAULT__',-1,'2026-01-21 14:51:18',NULL),('2026-01-20 14:51:18','2026-01-20 14:51:18','2026-01-20 14:51:18',1,144,'4326d6cd-b46e-4917-9c8d-9dc93067e72a',48,'b15c4e6eb57e4b0ca4e63c85ed92fc5f','gigabytes___DEFAULT__',-1,'2026-01-21 14:51:18',NULL),('2026-01-20 14:51:20','2026-01-20 14:51:20','2026-01-20 14:51:20',1,145,'c2ebb7bf-6576-48c0-baca-0f3c9965ba12',45,'b15c4e6eb57e4b0ca4e63c85ed92fc5f','volumes',-1,'2026-01-21 14:51:20',NULL),('2026-01-20 14:51:20','2026-01-20 14:51:20','2026-01-20 14:51:20',1,146,'24e3d028-dfb2-465f-8ec9-bb5bd6b3f62f',46,'b15c4e6eb57e4b0ca4e63c85ed92fc5f','gigabytes',-1,'2026-01-21 14:51:20',NULL),('2026-01-20 14:51:20','2026-01-20 14:51:20','2026-01-20 14:51:20',1,147,'78ebcd28-5e24-400a-b016-7acac7da1d9f',47,'b15c4e6eb57e4b0ca4e63c85ed92fc5f','volumes___DEFAULT__',-1,'2026-01-21 14:51:20',NULL),('2026-01-20 14:51:20','2026-01-20 14:51:20','2026-01-20 14:51:20',1,148,'6b4fddd6-8169-469c-a109-e3921497c0b2',48,'b15c4e6eb57e4b0ca4e63c85ed92fc5f','gigabytes___DEFAULT__',-1,'2026-01-21 14:51:20',NULL),('2026-01-20 14:51:21','2026-01-20 14:51:21','2026-01-20 14:51:21',1,149,'454089de-f750-4621-b23e-96484eb0806f',45,'b15c4e6eb57e4b0ca4e63c85ed92fc5f','volumes',-1,'2026-01-21 14:51:21',NULL),('2026-01-20 14:51:21','2026-01-20 14:51:21','2026-01-20 14:51:21',1,150,'39575071-27be-4a84-bbd6-eb4c55cbb0c1',46,'b15c4e6eb57e4b0ca4e63c85ed92fc5f','gigabytes',-1,'2026-01-21 14:51:21',NULL),('2026-01-20 14:51:21','2026-01-20 14:51:21','2026-01-20 14:51:21',1,151,'d5ce6d3a-fec5-4756-b3f4-6927cabd886a',47,'b15c4e6eb57e4b0ca4e63c85ed92fc5f','volumes___DEFAULT__',-1,'2026-01-21 14:51:21',NULL),('2026-01-20 14:51:21','2026-01-20 14:51:21','2026-01-20 14:51:21',1,152,'8ae4ce90-4a0a-49b7-a078-edb5f7a647bd',48,'b15c4e6eb57e4b0ca4e63c85ed92fc5f','gigabytes___DEFAULT__',-1,'2026-01-21 14:51:21',NULL),('2026-01-20 14:52:49','2026-01-20 14:52:49','2026-01-20 14:52:49',1,153,'36908f45-2592-49a2-bbf0-d24595c86535',49,'0a29915e0dd2403fbd7b7e847696b00a','volumes',1,'2026-01-21 14:52:49',NULL),('2026-01-20 14:52:49','2026-01-20 14:52:49','2026-01-20 14:52:49',1,154,'c0a0931a-2647-459a-bd25-0ce3fa67ed45',50,'0a29915e0dd2403fbd7b7e847696b00a','gigabytes',1,'2026-01-21 14:52:49',NULL),('2026-01-20 14:52:49','2026-01-20 14:52:49','2026-01-20 14:52:49',1,155,'1f6e67f8-6acd-4c4c-84c6-dcd18277d531',51,'0a29915e0dd2403fbd7b7e847696b00a','volumes___DEFAULT__',1,'2026-01-21 14:52:49',NULL),('2026-01-20 14:52:49','2026-01-20 14:52:49','2026-01-20 14:52:49',1,156,'69c07951-db54-4a72-8bb2-a421e9a2e947',52,'0a29915e0dd2403fbd7b7e847696b00a','gigabytes___DEFAULT__',1,'2026-01-21 14:52:49',NULL),('2026-01-20 14:52:55','2026-01-20 14:52:55','2026-01-20 14:52:55',1,157,'7cbaf990-9e8c-49e9-b284-76b846dcf6a4',53,'0ad54030e5cc477e939e073b52024ec4','volumes',1,'2026-01-21 14:52:55',NULL),('2026-01-20 14:52:55','2026-01-20 14:52:55','2026-01-20 14:52:55',1,158,'6927468f-2572-4b6a-a83f-dd582dc29998',54,'0ad54030e5cc477e939e073b52024ec4','gigabytes',1,'2026-01-21 14:52:55',NULL),('2026-01-20 14:52:55','2026-01-20 14:52:55','2026-01-20 14:52:55',1,159,'8e788c58-d67a-44ed-897f-8e30beb547a3',55,'0ad54030e5cc477e939e073b52024ec4','volumes___DEFAULT__',1,'2026-01-21 14:52:55',NULL),('2026-01-20 14:52:55','2026-01-20 14:52:55','2026-01-20 14:52:55',1,160,'ccc3613f-9bbf-4100-9f60-3ea6a926c496',56,'0ad54030e5cc477e939e073b52024ec4','gigabytes___DEFAULT__',1,'2026-01-21 14:52:55',NULL),('2026-01-20 14:53:42','2026-01-20 14:53:42','2026-01-20 14:53:42',1,161,'e575ac07-e1dc-487d-b8fe-be583a46cb72',57,'b1e83af992c94112a965575784639d77','volumes',1,'2026-01-21 14:53:42',NULL),('2026-01-20 14:53:42','2026-01-20 14:53:42','2026-01-20 14:53:42',1,162,'c1fd8c00-b4a3-47c1-a542-85a3f3a7ba48',58,'b1e83af992c94112a965575784639d77','gigabytes',1,'2026-01-21 14:53:42',NULL),('2026-01-20 14:53:42','2026-01-20 14:53:42','2026-01-20 14:53:42',1,163,'2cb8bd4f-d22a-4493-836f-9ba4468c5da9',59,'b1e83af992c94112a965575784639d77','volumes___DEFAULT__',1,'2026-01-21 14:53:42',NULL),('2026-01-20 14:53:42','2026-01-20 14:53:42','2026-01-20 14:53:42',1,164,'3212756b-8f26-4316-b38e-4f0f3c900f3c',60,'b1e83af992c94112a965575784639d77','gigabytes___DEFAULT__',1,'2026-01-21 14:53:42',NULL),('2026-01-20 14:54:39','2026-01-20 14:54:39','2026-01-20 14:54:39',1,165,'0345179c-103c-467b-89b9-1ceb386477fb',49,'0a29915e0dd2403fbd7b7e847696b00a','volumes',-1,'2026-01-21 14:54:39',NULL),('2026-01-20 14:54:39','2026-01-20 14:54:39','2026-01-20 14:54:39',1,166,'7871fc3c-744d-4897-8f72-e4d4dbb1cb67',50,'0a29915e0dd2403fbd7b7e847696b00a','gigabytes',-1,'2026-01-21 14:54:39',NULL),('2026-01-20 14:54:39','2026-01-20 14:54:39','2026-01-20 14:54:39',1,167,'296d9392-c8eb-47ca-923d-e10fb726f9b2',51,'0a29915e0dd2403fbd7b7e847696b00a','volumes___DEFAULT__',-1,'2026-01-21 14:54:39',NULL),('2026-01-20 14:54:39','2026-01-20 14:54:39','2026-01-20 14:54:39',1,168,'489ef249-8934-42f8-b7bb-505ea2e7b356',52,'0a29915e0dd2403fbd7b7e847696b00a','gigabytes___DEFAULT__',-1,'2026-01-21 14:54:39',NULL),('2026-01-20 14:54:42','2026-01-20 14:54:42','2026-01-20 14:54:42',1,169,'ec8571eb-1a8f-4e66-b7f5-a35323c80d35',53,'0ad54030e5cc477e939e073b52024ec4','volumes',-1,'2026-01-21 14:54:42',NULL),('2026-01-20 14:54:42','2026-01-20 14:54:42','2026-01-20 14:54:42',1,170,'e15c4bde-a3cb-4311-9c89-f496fc44c4b4',54,'0ad54030e5cc477e939e073b52024ec4','gigabytes',-1,'2026-01-21 14:54:42',NULL),('2026-01-20 14:54:42','2026-01-20 14:54:42','2026-01-20 14:54:42',1,171,'38800233-9a0f-4460-a12b-9f304515329d',55,'0ad54030e5cc477e939e073b52024ec4','volumes___DEFAULT__',-1,'2026-01-21 14:54:42',NULL),('2026-01-20 14:54:42','2026-01-20 14:54:42','2026-01-20 14:54:42',1,172,'bc1d10d0-a542-42e0-a91b-70dd3c86bb66',56,'0ad54030e5cc477e939e073b52024ec4','gigabytes___DEFAULT__',-1,'2026-01-21 14:54:42',NULL),('2026-01-20 14:55:12','2026-01-20 14:55:12','2026-01-20 14:55:12',1,173,'d85761af-2229-4527-a95e-08d39b54b506',61,'b3b1b7f5b4f84b5abbc401eb577c85c0','volumes',1,'2026-01-21 14:55:12',NULL),('2026-01-20 14:55:12','2026-01-20 14:55:12','2026-01-20 14:55:12',1,174,'a6ade7c7-0b38-4deb-a9df-31de934600e2',62,'b3b1b7f5b4f84b5abbc401eb577c85c0','gigabytes',1,'2026-01-21 14:55:12',NULL),('2026-01-20 14:55:12','2026-01-20 14:55:12','2026-01-20 14:55:12',1,175,'dfd219fa-1c76-4a1d-b0c3-58660eebf7b7',63,'b3b1b7f5b4f84b5abbc401eb577c85c0','volumes___DEFAULT__',1,'2026-01-21 14:55:12',NULL),('2026-01-20 14:55:12','2026-01-20 14:55:12','2026-01-20 14:55:12',1,176,'3900c221-2772-4dcc-8e82-88f7f4905109',64,'b3b1b7f5b4f84b5abbc401eb577c85c0','gigabytes___DEFAULT__',1,'2026-01-21 14:55:12',NULL),('2026-01-20 14:55:16','2026-01-20 14:55:16','2026-01-20 14:55:16',1,177,'ae143f6e-dad9-4a34-921e-7f6ef54e957c',57,'b1e83af992c94112a965575784639d77','volumes',1,'2026-01-21 14:55:16',NULL),('2026-01-20 14:55:16','2026-01-20 14:55:16','2026-01-20 14:55:16',1,178,'ac450460-3a15-42b9-b35c-89179aaacf4c',58,'b1e83af992c94112a965575784639d77','gigabytes',1,'2026-01-21 14:55:16',NULL),('2026-01-20 14:55:16','2026-01-20 14:55:16','2026-01-20 14:55:16',1,179,'52c07b58-532a-44ae-a81a-cea6fa3ed3c4',59,'b1e83af992c94112a965575784639d77','volumes___DEFAULT__',1,'2026-01-21 14:55:16',NULL),('2026-01-20 14:55:16','2026-01-20 14:55:16','2026-01-20 14:55:16',1,180,'625cc039-ed8c-4a7c-b3f9-3e8f1f8dbd40',60,'b1e83af992c94112a965575784639d77','gigabytes___DEFAULT__',1,'2026-01-21 14:55:16',NULL),('2026-01-20 14:56:15','2026-01-20 14:56:15','2026-01-20 14:56:15',1,181,'b2b83d23-d754-499e-92a3-5c271763b35f',57,'b1e83af992c94112a965575784639d77','volumes',-1,'2026-01-21 14:56:15',NULL),('2026-01-20 14:56:15','2026-01-20 14:56:15','2026-01-20 14:56:15',1,182,'7ff1cb34-a940-4686-9d02-883596001abf',58,'b1e83af992c94112a965575784639d77','gigabytes',-1,'2026-01-21 14:56:15',NULL),('2026-01-20 14:56:15','2026-01-20 14:56:15','2026-01-20 14:56:15',1,183,'8cba95c2-cde8-4c52-897b-cf480055cc6f',59,'b1e83af992c94112a965575784639d77','volumes___DEFAULT__',-1,'2026-01-21 14:56:15',NULL),('2026-01-20 14:56:15','2026-01-20 14:56:15','2026-01-20 14:56:15',1,184,'8c99952f-fc95-4b55-ab2e-5b20f41bb805',60,'b1e83af992c94112a965575784639d77','gigabytes___DEFAULT__',-1,'2026-01-21 14:56:15',NULL),('2026-01-20 14:56:16','2026-01-20 14:56:16','2026-01-20 14:56:16',1,185,'96892646-1190-4f96-87ea-2acbcbdb2371',57,'b1e83af992c94112a965575784639d77','volumes',-1,'2026-01-21 14:56:16',NULL),('2026-01-20 14:56:16','2026-01-20 14:56:16','2026-01-20 14:56:16',1,186,'f233262a-e1f4-4096-a63e-61373e3856ed',58,'b1e83af992c94112a965575784639d77','gigabytes',-1,'2026-01-21 14:56:16',NULL),('2026-01-20 14:56:16','2026-01-20 14:56:16','2026-01-20 14:56:16',1,187,'d8bd8fda-973f-49bb-964a-7d5b1a72a7b9',59,'b1e83af992c94112a965575784639d77','volumes___DEFAULT__',-1,'2026-01-21 14:56:16',NULL),('2026-01-20 14:56:16','2026-01-20 14:56:16','2026-01-20 14:56:16',1,188,'964e2f35-fbdd-489e-8356-7576ba0e3e5b',60,'b1e83af992c94112a965575784639d77','gigabytes___DEFAULT__',-1,'2026-01-21 14:56:16',NULL),('2026-01-20 14:56:25','2026-01-20 14:56:25','2026-01-20 14:56:25',1,189,'41df7ad5-2b2c-4c83-b756-a740aeb426db',65,'fb4410ee5e824adfa71950de60e627af','volumes',1,'2026-01-21 14:56:25',NULL),('2026-01-20 14:56:25','2026-01-20 14:56:25','2026-01-20 14:56:25',1,190,'06e9628e-191d-47b7-a5c9-4d207fd4ba49',66,'fb4410ee5e824adfa71950de60e627af','gigabytes',1,'2026-01-21 14:56:25',NULL),('2026-01-20 14:56:25','2026-01-20 14:56:25','2026-01-20 14:56:25',1,191,'925ab0d2-b5b0-40a5-9da9-5b5d3bd51641',67,'fb4410ee5e824adfa71950de60e627af','volumes___DEFAULT__',1,'2026-01-21 14:56:25',NULL),('2026-01-20 14:56:25','2026-01-20 14:56:25','2026-01-20 14:56:25',1,192,'4100ffaf-d060-4270-84de-3c13aa40e811',68,'fb4410ee5e824adfa71950de60e627af','gigabytes___DEFAULT__',1,'2026-01-21 14:56:25',NULL),('2026-01-20 14:56:27','2026-01-20 14:56:27','2026-01-20 14:56:27',1,193,'bbffcd19-feab-4d01-847c-7f82f1ce69d0',65,'fb4410ee5e824adfa71950de60e627af','volumes',1,'2026-01-21 14:56:27',NULL),('2026-01-20 14:56:27','2026-01-20 14:56:27','2026-01-20 14:56:27',1,194,'50fe1cbd-90ca-4c49-a226-69884b8953ff',66,'fb4410ee5e824adfa71950de60e627af','gigabytes',1,'2026-01-21 14:56:27',NULL),('2026-01-20 14:56:27','2026-01-20 14:56:27','2026-01-20 14:56:27',1,195,'f120747b-3069-4e5c-ac14-d014fbec3fc8',67,'fb4410ee5e824adfa71950de60e627af','volumes___DEFAULT__',1,'2026-01-21 14:56:27',NULL),('2026-01-20 14:56:27','2026-01-20 14:56:27','2026-01-20 14:56:27',1,196,'6c278378-dd59-4101-ba37-12a523df7ead',68,'fb4410ee5e824adfa71950de60e627af','gigabytes___DEFAULT__',1,'2026-01-21 14:56:27',NULL),('2026-01-20 14:56:29','2026-01-20 14:56:29','2026-01-20 14:56:29',1,197,'93fa8bc9-e2c1-40b0-977d-229a431dee58',65,'fb4410ee5e824adfa71950de60e627af','volumes',1,'2026-01-21 14:56:29',NULL),('2026-01-20 14:56:29','2026-01-20 14:56:29','2026-01-20 14:56:29',1,198,'d66c92d9-a04a-4676-975d-56b067419580',66,'fb4410ee5e824adfa71950de60e627af','gigabytes',1,'2026-01-21 14:56:29',NULL),('2026-01-20 14:56:29','2026-01-20 14:56:29','2026-01-20 14:56:29',1,199,'ed55fd81-5e45-4291-a41b-ba0635fc91f9',67,'fb4410ee5e824adfa71950de60e627af','volumes___DEFAULT__',1,'2026-01-21 14:56:29',NULL),('2026-01-20 14:56:29','2026-01-20 14:56:29','2026-01-20 14:56:29',1,200,'40234d53-dbef-46d5-939c-8cbd5aa0c57e',68,'fb4410ee5e824adfa71950de60e627af','gigabytes___DEFAULT__',1,'2026-01-21 14:56:29',NULL),('2026-01-20 14:56:33','2026-01-20 14:56:33','2026-01-20 14:56:33',1,201,'de976a4b-657f-416d-85aa-6937b8e3f1aa',65,'fb4410ee5e824adfa71950de60e627af','volumes',-1,'2026-01-21 14:56:33',NULL),('2026-01-20 14:56:33','2026-01-20 14:56:33','2026-01-20 14:56:33',1,202,'584c09e2-0f70-4d9d-82b6-9245bddc8b6d',66,'fb4410ee5e824adfa71950de60e627af','gigabytes',-1,'2026-01-21 14:56:33',NULL),('2026-01-20 14:56:33','2026-01-20 14:56:33','2026-01-20 14:56:33',1,203,'49eb3f10-312a-4ae4-96fb-075202cbfc0c',67,'fb4410ee5e824adfa71950de60e627af','volumes___DEFAULT__',-1,'2026-01-21 14:56:33',NULL),('2026-01-20 14:56:33','2026-01-20 14:56:33','2026-01-20 14:56:33',1,204,'5ae84ad6-ac45-488f-b7e9-760008c3cd9c',68,'fb4410ee5e824adfa71950de60e627af','gigabytes___DEFAULT__',-1,'2026-01-21 14:56:33',NULL),('2026-01-20 14:56:36','2026-01-20 14:56:36','2026-01-20 14:56:36',1,205,'59cb4d5d-a215-4745-ad84-d4902c9001c6',65,'fb4410ee5e824adfa71950de60e627af','volumes',-1,'2026-01-21 14:56:36',NULL),('2026-01-20 14:56:36','2026-01-20 14:56:36','2026-01-20 14:56:36',1,206,'f5708916-3e93-4186-a54a-f73d1e844d7b',66,'fb4410ee5e824adfa71950de60e627af','gigabytes',-1,'2026-01-21 14:56:36',NULL),('2026-01-20 14:56:36','2026-01-20 14:56:36','2026-01-20 14:56:36',1,207,'36bfdf56-a60b-4993-b5b0-2764b11b45d4',67,'fb4410ee5e824adfa71950de60e627af','volumes___DEFAULT__',-1,'2026-01-21 14:56:36',NULL),('2026-01-20 14:56:36','2026-01-20 14:56:36','2026-01-20 14:56:36',1,208,'f57ea01c-d896-4658-b112-4e2e66339df8',68,'fb4410ee5e824adfa71950de60e627af','gigabytes___DEFAULT__',-1,'2026-01-21 14:56:36',NULL),('2026-01-20 14:56:37','2026-01-20 14:56:37','2026-01-20 14:56:37',1,209,'1f431997-2f83-4492-ad89-e8ec2f11ad41',65,'fb4410ee5e824adfa71950de60e627af','volumes',-1,'2026-01-21 14:56:37',NULL),('2026-01-20 14:56:37','2026-01-20 14:56:37','2026-01-20 14:56:37',1,210,'27d0beed-d7a3-4577-ab16-3fb7ca5d480b',66,'fb4410ee5e824adfa71950de60e627af','gigabytes',-1,'2026-01-21 14:56:37',NULL),('2026-01-20 14:56:37','2026-01-20 14:56:37','2026-01-20 14:56:37',1,211,'558496dc-05e2-460d-953b-c1ee4ed1f98c',67,'fb4410ee5e824adfa71950de60e627af','volumes___DEFAULT__',-1,'2026-01-21 14:56:37',NULL),('2026-01-20 14:56:37','2026-01-20 14:56:37','2026-01-20 14:56:37',1,212,'54c416f7-d9da-49ca-8cb7-878f7fdce297',68,'fb4410ee5e824adfa71950de60e627af','gigabytes___DEFAULT__',-1,'2026-01-21 14:56:37',NULL),('2026-01-20 14:57:18','2026-01-20 14:57:18','2026-01-20 14:57:18',1,213,'aa042009-87f7-4443-bcca-4eb48b8f7517',69,'107c1f3b5b7b413d9a389ca1166e331f','volumes',1,'2026-01-21 14:57:18',NULL),('2026-01-20 14:57:18','2026-01-20 14:57:18','2026-01-20 14:57:18',1,214,'fd46cd35-2ad5-44d7-bf89-bff8f74b2bdc',70,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes',1,'2026-01-21 14:57:18',NULL),('2026-01-20 14:57:18','2026-01-20 14:57:18','2026-01-20 14:57:18',1,215,'74a2d752-f2ef-43f0-9888-6cf2699cfd59',71,'107c1f3b5b7b413d9a389ca1166e331f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-692148149-672147069',1,'2026-01-21 14:57:18',NULL),('2026-01-20 14:57:18','2026-01-20 14:57:18','2026-01-20 14:57:18',1,216,'875c1918-ebd2-4585-bfb5-8f53eb3a431f',72,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-692148149-672147069',1,'2026-01-21 14:57:18',NULL),('2026-01-20 14:57:19','2026-01-20 14:57:19','2026-01-20 14:57:19',1,217,'d57fdb47-cd37-4b16-95ca-f593605fa3ce',69,'107c1f3b5b7b413d9a389ca1166e331f','volumes',1,'2026-01-21 14:57:19',NULL),('2026-01-20 14:57:19','2026-01-20 14:57:19','2026-01-20 14:57:19',1,218,'7a08bdab-4443-45b8-bf90-4a839710247b',70,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes',1,'2026-01-21 14:57:19',NULL),('2026-01-20 14:57:19','2026-01-20 14:57:19','2026-01-20 14:57:19',1,219,'4e37e443-9c5d-4458-842b-e784c44b3860',73,'107c1f3b5b7b413d9a389ca1166e331f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-472468519-648261730',1,'2026-01-21 14:57:19',NULL),('2026-01-20 14:57:19','2026-01-20 14:57:19','2026-01-20 14:57:19',1,220,'4555ec5b-f619-493e-a317-742dd397cb69',74,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-472468519-648261730',1,'2026-01-21 14:57:19',NULL),('2026-01-20 14:57:19','2026-01-20 14:57:19','2026-01-20 14:57:19',1,221,'ba4cdc31-89d3-407c-b41b-089bc856fdd1',69,'107c1f3b5b7b413d9a389ca1166e331f','volumes',1,'2026-01-21 14:57:19',NULL),('2026-01-20 14:57:19','2026-01-20 14:57:19','2026-01-20 14:57:19',1,222,'5fd3bf69-46a7-4fe8-b7b3-b3359d6b4b9a',70,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes',1,'2026-01-21 14:57:19',NULL),('2026-01-20 14:57:19','2026-01-20 14:57:19','2026-01-20 14:57:19',1,223,'07eac94b-1631-475b-b945-c3e85bf7504d',71,'107c1f3b5b7b413d9a389ca1166e331f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-692148149-672147069',1,'2026-01-21 14:57:19',NULL),('2026-01-20 14:57:19','2026-01-20 14:57:19','2026-01-20 14:57:19',1,224,'cc7a6ea3-caf6-47d7-8a8b-5b268c3853b4',72,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-692148149-672147069',1,'2026-01-21 14:57:19',NULL),('2026-01-20 14:57:19','2026-01-20 14:57:19','2026-01-20 14:57:19',1,225,'6a9315a4-5222-4284-84cf-ebaa90158172',69,'107c1f3b5b7b413d9a389ca1166e331f','volumes',1,'2026-01-21 14:57:19',NULL),('2026-01-20 14:57:19','2026-01-20 14:57:19','2026-01-20 14:57:19',1,226,'0cdffe89-9698-4bb1-a836-7629c1b75310',70,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes',1,'2026-01-21 14:57:19',NULL),('2026-01-20 14:57:19','2026-01-20 14:57:19','2026-01-20 14:57:19',1,227,'f9baf40c-fbc8-43c7-96c1-0a83860bb734',73,'107c1f3b5b7b413d9a389ca1166e331f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-472468519-648261730',1,'2026-01-21 14:57:19',NULL),('2026-01-20 14:57:19','2026-01-20 14:57:19','2026-01-20 14:57:19',1,228,'6f1bea6e-c5aa-4762-b09d-f5706f5fe469',74,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-472468519-648261730',1,'2026-01-21 14:57:19',NULL),('2026-01-20 14:57:19','2026-01-20 14:57:19','2026-01-20 14:57:19',1,229,'d495b02f-7f40-49f5-9b8e-fa7e367ab4a9',69,'107c1f3b5b7b413d9a389ca1166e331f','volumes',1,'2026-01-21 14:57:19',NULL),('2026-01-20 14:57:19','2026-01-20 14:57:19','2026-01-20 14:57:19',1,230,'690a9e65-d9d1-4c6f-819c-12334d69da4f',70,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes',1,'2026-01-21 14:57:19',NULL),('2026-01-20 14:57:19','2026-01-20 14:57:19','2026-01-20 14:57:19',1,231,'4d949686-7812-48b4-aa5f-eeaaf7568f90',71,'107c1f3b5b7b413d9a389ca1166e331f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-692148149-672147069',1,'2026-01-21 14:57:19',NULL),('2026-01-20 14:57:19','2026-01-20 14:57:19','2026-01-20 14:57:19',1,232,'eb4df789-932f-485b-8962-ed4bddb53978',72,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-692148149-672147069',1,'2026-01-21 14:57:19',NULL),('2026-01-20 14:57:20','2026-01-20 14:57:20','2026-01-20 14:57:20',1,233,'c3bd2992-2697-4ac7-b80b-ab0cf0cad33e',69,'107c1f3b5b7b413d9a389ca1166e331f','volumes',1,'2026-01-21 14:57:20',NULL),('2026-01-20 14:57:20','2026-01-20 14:57:20','2026-01-20 14:57:20',1,234,'86860bb3-c21c-4eb4-a320-849ad777b2c0',70,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes',1,'2026-01-21 14:57:20',NULL),('2026-01-20 14:57:20','2026-01-20 14:57:20','2026-01-20 14:57:20',1,235,'c6573ae3-6c1d-4397-9628-a2cdd89bd450',73,'107c1f3b5b7b413d9a389ca1166e331f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-472468519-648261730',1,'2026-01-21 14:57:20',NULL),('2026-01-20 14:57:20','2026-01-20 14:57:20','2026-01-20 14:57:20',1,236,'2fb5e405-be69-478d-a968-c9cebc925050',74,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-472468519-648261730',1,'2026-01-21 14:57:20',NULL),('2026-01-20 14:57:21','2026-01-20 14:57:21','2026-01-20 14:57:21',1,237,'33d7f25e-b95b-405b-8773-86e515c192fd',69,'107c1f3b5b7b413d9a389ca1166e331f','volumes',1,'2026-01-21 14:57:21',NULL),('2026-01-20 14:57:21','2026-01-20 14:57:21','2026-01-20 14:57:21',1,238,'ee19e5aa-c465-4e32-9e99-8a469fdbf223',70,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes',1,'2026-01-21 14:57:21',NULL),('2026-01-20 14:57:21','2026-01-20 14:57:21','2026-01-20 14:57:21',1,239,'143a5a42-b78f-4bc9-b8e4-4c713c539fc2',75,'107c1f3b5b7b413d9a389ca1166e331f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-347628217-1040866455',1,'2026-01-21 14:57:21',NULL),('2026-01-20 14:57:21','2026-01-20 14:57:21','2026-01-20 14:57:21',1,240,'aff17d33-c55a-48b2-a0e7-19174565170f',76,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-347628217-1040866455',1,'2026-01-21 14:57:21',NULL),('2026-01-20 14:57:23','2026-01-20 14:57:23','2026-01-20 14:57:23',1,241,'b751bc1d-ca18-4b6a-9bee-76c5461bdcea',69,'107c1f3b5b7b413d9a389ca1166e331f','volumes',1,'2026-01-21 14:57:23',NULL),('2026-01-20 14:57:23','2026-01-20 14:57:23','2026-01-20 14:57:23',1,242,'05472cd0-1d9b-4e09-a5e8-29adb380608d',70,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes',1,'2026-01-21 14:57:23',NULL),('2026-01-20 14:57:23','2026-01-20 14:57:23','2026-01-20 14:57:23',1,243,'62ec78bc-a2c8-4e93-8113-40706e424853',75,'107c1f3b5b7b413d9a389ca1166e331f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-347628217-1040866455',1,'2026-01-21 14:57:23',NULL),('2026-01-20 14:57:23','2026-01-20 14:57:23','2026-01-20 14:57:23',1,244,'c70466ef-378c-434e-baeb-bd9682c2c6d7',76,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-347628217-1040866455',1,'2026-01-21 14:57:23',NULL),('2026-01-20 14:57:24','2026-01-20 14:57:24','2026-01-20 14:57:24',1,245,'a1157393-1946-4587-9640-e34eaa280aae',69,'107c1f3b5b7b413d9a389ca1166e331f','volumes',1,'2026-01-21 14:57:24',NULL),('2026-01-20 14:57:24','2026-01-20 14:57:24','2026-01-20 14:57:24',1,246,'350b0cd2-98db-427c-b03b-e880506ef716',70,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes',1,'2026-01-21 14:57:24',NULL),('2026-01-20 14:57:24','2026-01-20 14:57:24','2026-01-20 14:57:24',1,247,'6960d578-df5a-41b1-ad36-7c972bfdce09',75,'107c1f3b5b7b413d9a389ca1166e331f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-347628217-1040866455',1,'2026-01-21 14:57:24',NULL),('2026-01-20 14:57:24','2026-01-20 14:57:24','2026-01-20 14:57:24',1,248,'80cc73f6-6bad-4be9-bf4a-17b726eeae75',76,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-347628217-1040866455',1,'2026-01-21 14:57:24',NULL),('2026-01-20 14:57:45','2026-01-20 14:57:45','2026-01-20 14:57:45',1,249,'a45352c8-b071-4c19-ae48-ec42a9e8426a',61,'b3b1b7f5b4f84b5abbc401eb577c85c0','volumes',-1,'2026-01-21 14:57:44',NULL),('2026-01-20 14:57:45','2026-01-20 14:57:45','2026-01-20 14:57:45',1,250,'3e5f1315-f3bc-4eae-a6bd-c20dd608901e',62,'b3b1b7f5b4f84b5abbc401eb577c85c0','gigabytes',-1,'2026-01-21 14:57:44',NULL),('2026-01-20 14:57:45','2026-01-20 14:57:45','2026-01-20 14:57:45',1,251,'9bbca12b-819c-4017-9205-b0b83ee44610',63,'b3b1b7f5b4f84b5abbc401eb577c85c0','volumes___DEFAULT__',-1,'2026-01-21 14:57:44',NULL),('2026-01-20 14:57:45','2026-01-20 14:57:45','2026-01-20 14:57:45',1,252,'aeb80934-7e7a-4b2d-9b90-ca0fdb84f54f',64,'b3b1b7f5b4f84b5abbc401eb577c85c0','gigabytes___DEFAULT__',-1,'2026-01-21 14:57:44',NULL),('2026-01-20 14:58:18','2026-01-20 14:58:18','2026-01-20 14:58:18',1,253,'a629f169-c1d4-4aba-a714-2b2b06736dd8',69,'107c1f3b5b7b413d9a389ca1166e331f','volumes',-1,'2026-01-21 14:58:18',NULL),('2026-01-20 14:58:18','2026-01-20 14:58:18','2026-01-20 14:58:18',1,254,'109c51da-107d-4612-98a6-eea1294720e3',70,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes',-1,'2026-01-21 14:58:18',NULL),('2026-01-20 14:58:18','2026-01-20 14:58:18','2026-01-20 14:58:18',1,255,'6b72d13e-d4e2-47ad-b118-23ed019a352c',71,'107c1f3b5b7b413d9a389ca1166e331f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-692148149-672147069',-1,'2026-01-21 14:58:18',NULL),('2026-01-20 14:58:18','2026-01-20 14:58:18','2026-01-20 14:58:18',1,256,'12a368aa-76b2-4132-b718-fec427add6d1',72,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-692148149-672147069',-1,'2026-01-21 14:58:18',NULL),('2026-01-20 14:58:22','2026-01-20 14:58:22','2026-01-20 14:58:22',1,257,'e6ce9df6-82c0-4526-9fc6-6307c5832f16',69,'107c1f3b5b7b413d9a389ca1166e331f','volumes',-1,'2026-01-21 14:58:22',NULL),('2026-01-20 14:58:22','2026-01-20 14:58:22','2026-01-20 14:58:22',1,258,'285e2b56-41c0-4f7e-89fa-b249acc139fd',70,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes',-1,'2026-01-21 14:58:22',NULL),('2026-01-20 14:58:22','2026-01-20 14:58:22','2026-01-20 14:58:22',1,259,'8fa81776-7c53-490d-a68e-67c30763874d',73,'107c1f3b5b7b413d9a389ca1166e331f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-472468519-648261730',-1,'2026-01-21 14:58:22',NULL),('2026-01-20 14:58:22','2026-01-20 14:58:22','2026-01-20 14:58:22',1,260,'33623b38-ccaa-45b4-8245-704cbe799e06',74,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-472468519-648261730',-1,'2026-01-21 14:58:22',NULL),('2026-01-20 14:59:00','2026-01-20 14:59:00','2026-01-20 14:59:00',1,261,'6e214745-c9e9-48cd-8768-ce869b98b3f6',69,'107c1f3b5b7b413d9a389ca1166e331f','volumes',-1,'2026-01-21 14:59:00',NULL),('2026-01-20 14:59:00','2026-01-20 14:59:00','2026-01-20 14:59:00',1,262,'f4172742-6d02-456d-8121-9088717ddc5e',70,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes',-1,'2026-01-21 14:59:00',NULL),('2026-01-20 14:59:00','2026-01-20 14:59:00','2026-01-20 14:59:00',1,263,'a2082ff3-47fc-42d2-b516-4d6cf8764340',71,'107c1f3b5b7b413d9a389ca1166e331f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-692148149-672147069',-1,'2026-01-21 14:59:00',NULL),('2026-01-20 14:59:00','2026-01-20 14:59:00','2026-01-20 14:59:00',1,264,'3f3a5aab-bd44-4a20-8d46-2bb85f332712',72,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-692148149-672147069',-1,'2026-01-21 14:59:00',NULL),('2026-01-20 14:59:05','2026-01-20 14:59:05','2026-01-20 14:59:05',1,265,'e39e0e4c-75dd-4538-9ece-92ffa9a7f106',69,'107c1f3b5b7b413d9a389ca1166e331f','volumes',-1,'2026-01-21 14:59:05',NULL),('2026-01-20 14:59:05','2026-01-20 14:59:05','2026-01-20 14:59:05',1,266,'983a9230-a422-48c4-b543-1de45e1af436',70,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes',-1,'2026-01-21 14:59:05',NULL),('2026-01-20 14:59:05','2026-01-20 14:59:05','2026-01-20 14:59:05',1,267,'c64049ac-db2c-481a-b10a-f0be01b42a4a',73,'107c1f3b5b7b413d9a389ca1166e331f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-472468519-648261730',-1,'2026-01-21 14:59:05',NULL),('2026-01-20 14:59:05','2026-01-20 14:59:05','2026-01-20 14:59:05',1,268,'0c088185-ac28-42e3-9bf2-789a0f2c298b',74,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-472468519-648261730',-1,'2026-01-21 14:59:05',NULL),('2026-01-20 14:59:34','2026-01-20 14:59:34','2026-01-20 14:59:34',1,269,'5aff84d1-dc29-49ca-b87c-65794f746897',77,'105e56abe3804424885c7aa8d1216d12','volumes',1,'2026-01-21 14:59:34',NULL),('2026-01-20 14:59:34','2026-01-20 14:59:34','2026-01-20 14:59:34',1,270,'4022aa60-1c49-4e2e-a689-22aad6b16a22',78,'105e56abe3804424885c7aa8d1216d12','gigabytes',1,'2026-01-21 14:59:34',NULL),('2026-01-20 14:59:34','2026-01-20 14:59:34','2026-01-20 14:59:34',1,271,'d3db445e-288c-4e61-95e8-ff207016b826',79,'105e56abe3804424885c7aa8d1216d12','volumes___DEFAULT__',1,'2026-01-21 14:59:34',NULL),('2026-01-20 14:59:34','2026-01-20 14:59:34','2026-01-20 14:59:34',1,272,'4c52a37c-7a6a-4ac4-9ecf-96e3359969d6',80,'105e56abe3804424885c7aa8d1216d12','gigabytes___DEFAULT__',1,'2026-01-21 14:59:34',NULL),('2026-01-20 14:59:35','2026-01-20 14:59:35','2026-01-20 14:59:35',1,273,'5130dbae-b59d-4138-a20d-11b76fdae7a1',69,'107c1f3b5b7b413d9a389ca1166e331f','volumes',-1,'2026-01-21 14:59:35',NULL),('2026-01-20 14:59:35','2026-01-20 14:59:35','2026-01-20 14:59:35',1,274,'f313c608-6dfb-414c-a50d-3c525654460b',70,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes',-1,'2026-01-21 14:59:35',NULL),('2026-01-20 14:59:35','2026-01-20 14:59:35','2026-01-20 14:59:35',1,275,'237a688a-ff1b-4d4f-b781-e47fb1f624b9',71,'107c1f3b5b7b413d9a389ca1166e331f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-692148149-672147069',-1,'2026-01-21 14:59:35',NULL),('2026-01-20 14:59:35','2026-01-20 14:59:35','2026-01-20 14:59:35',1,276,'abed555d-4771-4d11-824b-13af5a1dbead',72,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-692148149-672147069',-1,'2026-01-21 14:59:35',NULL),('2026-01-20 14:59:38','2026-01-20 14:59:38','2026-01-20 14:59:38',1,277,'17b625ce-9153-46e4-92dc-aeece261bd9f',69,'107c1f3b5b7b413d9a389ca1166e331f','volumes',-1,'2026-01-21 14:59:38',NULL),('2026-01-20 14:59:38','2026-01-20 14:59:38','2026-01-20 14:59:38',1,278,'6d09f98a-1983-41e2-9c57-49226365867d',70,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes',-1,'2026-01-21 14:59:38',NULL),('2026-01-20 14:59:38','2026-01-20 14:59:38','2026-01-20 14:59:38',1,279,'e2b554b0-033b-436d-ab87-da7dada52232',73,'107c1f3b5b7b413d9a389ca1166e331f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-472468519-648261730',-1,'2026-01-21 14:59:38',NULL),('2026-01-20 14:59:38','2026-01-20 14:59:38','2026-01-20 14:59:38',1,280,'573ef68f-6d61-4167-9247-88fa03657de7',74,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-472468519-648261730',-1,'2026-01-21 14:59:38',NULL),('2026-01-20 14:59:39','2026-01-20 14:59:39','2026-01-20 14:59:39',1,281,'8b034d58-56a7-4b0a-9bdf-6aa44cf9d10d',77,'105e56abe3804424885c7aa8d1216d12','volumes',1,'2026-01-21 14:59:39',NULL),('2026-01-20 14:59:39','2026-01-20 14:59:39','2026-01-20 14:59:39',1,282,'55237f08-b370-4af7-9590-23f41036c50e',78,'105e56abe3804424885c7aa8d1216d12','gigabytes',1,'2026-01-21 14:59:39',NULL),('2026-01-20 14:59:39','2026-01-20 14:59:39','2026-01-20 14:59:39',1,283,'1258e97d-69f4-4600-99ad-ac43b510fb33',79,'105e56abe3804424885c7aa8d1216d12','volumes___DEFAULT__',1,'2026-01-21 14:59:39',NULL),('2026-01-20 14:59:39','2026-01-20 14:59:39','2026-01-20 14:59:39',1,284,'b0425552-68c0-462d-92a5-b3eab3f46074',80,'105e56abe3804424885c7aa8d1216d12','gigabytes___DEFAULT__',1,'2026-01-21 14:59:39',NULL),('2026-01-20 15:00:04','2026-01-20 15:00:04','2026-01-20 15:00:04',1,285,'2419df32-a639-449d-b1f1-46d7fe8fac76',69,'107c1f3b5b7b413d9a389ca1166e331f','volumes',-1,'2026-01-21 15:00:04',NULL),('2026-01-20 15:00:04','2026-01-20 15:00:04','2026-01-20 15:00:04',1,286,'7643db4b-8efe-4cba-9d76-4b22204f1370',70,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes',-1,'2026-01-21 15:00:04',NULL),('2026-01-20 15:00:04','2026-01-20 15:00:04','2026-01-20 15:00:04',1,287,'a2cc94ff-4c0a-4158-a4ea-9cac59058512',75,'107c1f3b5b7b413d9a389ca1166e331f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-347628217-1040866455',-1,'2026-01-21 15:00:04',NULL),('2026-01-20 15:00:04','2026-01-20 15:00:04','2026-01-20 15:00:04',1,288,'f70b26d1-654f-48f7-a376-3d769cc5db75',76,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-347628217-1040866455',-1,'2026-01-21 15:00:04',NULL),('2026-01-20 15:00:05','2026-01-20 15:00:05','2026-01-20 15:00:05',1,289,'9f0d3bfc-67ae-4183-9081-f8286dd554c1',69,'107c1f3b5b7b413d9a389ca1166e331f','volumes',-1,'2026-01-21 15:00:05',NULL),('2026-01-20 15:00:05','2026-01-20 15:00:05','2026-01-20 15:00:05',1,290,'6086a63b-43e1-464a-8be2-6f630cc124a0',70,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes',-1,'2026-01-21 15:00:05',NULL),('2026-01-20 15:00:05','2026-01-20 15:00:05','2026-01-20 15:00:05',1,291,'5fec36a8-4db0-4635-b39e-d2c25b9b9ac8',75,'107c1f3b5b7b413d9a389ca1166e331f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-347628217-1040866455',-1,'2026-01-21 15:00:05',NULL),('2026-01-20 15:00:05','2026-01-20 15:00:05','2026-01-20 15:00:05',1,292,'27e2021a-070f-4e53-8f08-4ebf53539cbd',76,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-347628217-1040866455',-1,'2026-01-21 15:00:05',NULL),('2026-01-20 15:00:06','2026-01-20 15:00:06','2026-01-20 15:00:06',1,293,'05390efe-42f7-4750-8506-c29f7044dac8',69,'107c1f3b5b7b413d9a389ca1166e331f','volumes',-1,'2026-01-21 15:00:06',NULL),('2026-01-20 15:00:06','2026-01-20 15:00:06','2026-01-20 15:00:06',1,294,'95834b73-488b-4cc5-8d80-59025fb039b8',70,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes',-1,'2026-01-21 15:00:06',NULL),('2026-01-20 15:00:06','2026-01-20 15:00:06','2026-01-20 15:00:06',1,295,'0c3a93c2-ea0b-41d5-a507-ac1d174639cf',75,'107c1f3b5b7b413d9a389ca1166e331f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-347628217-1040866455',-1,'2026-01-21 15:00:06',NULL),('2026-01-20 15:00:06','2026-01-20 15:00:06','2026-01-20 15:00:06',1,296,'0f4fa241-dd68-4731-b85c-8e8254a37e71',76,'107c1f3b5b7b413d9a389ca1166e331f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-347628217-1040866455',-1,'2026-01-21 15:00:06',NULL),('2026-01-20 15:01:45','2026-01-20 15:01:45','2026-01-20 15:01:45',1,297,'b321e9e1-a69d-48bd-a728-f44b632130b1',81,'63555e5851564db08c6429231d264f2c','volumes',1,'2026-01-21 15:01:45',NULL),('2026-01-20 15:01:45','2026-01-20 15:01:45','2026-01-20 15:01:45',1,298,'8f922d8d-b7d1-4d1a-ad6b-edda1765d255',82,'63555e5851564db08c6429231d264f2c','gigabytes',1,'2026-01-21 15:01:45',NULL),('2026-01-20 15:01:45','2026-01-20 15:01:45','2026-01-20 15:01:45',1,299,'2471727a-7691-4f5b-8748-0022e382f7ef',83,'63555e5851564db08c6429231d264f2c','volumes___DEFAULT__',1,'2026-01-21 15:01:45',NULL),('2026-01-20 15:01:45','2026-01-20 15:01:45','2026-01-20 15:01:45',1,300,'6ee52ba4-7938-4ba6-9911-e6baaeb5ec33',84,'63555e5851564db08c6429231d264f2c','gigabytes___DEFAULT__',1,'2026-01-21 15:01:45',NULL),('2026-01-20 15:01:51','2026-01-20 15:01:51','2026-01-20 15:01:51',1,301,'edec75b8-81e1-4b06-87a3-fa39a5924f6d',77,'105e56abe3804424885c7aa8d1216d12','volumes',-1,'2026-01-21 15:01:51',NULL),('2026-01-20 15:01:51','2026-01-20 15:01:51','2026-01-20 15:01:51',1,302,'35a55ad6-e6eb-496c-a334-c20e172b08c0',78,'105e56abe3804424885c7aa8d1216d12','gigabytes',-1,'2026-01-21 15:01:51',NULL),('2026-01-20 15:01:51','2026-01-20 15:01:51','2026-01-20 15:01:51',1,303,'a0ccbf1a-00aa-40d9-9716-c20ac5118720',79,'105e56abe3804424885c7aa8d1216d12','volumes___DEFAULT__',-1,'2026-01-21 15:01:51',NULL),('2026-01-20 15:01:51','2026-01-20 15:01:51','2026-01-20 15:01:51',1,304,'4f7a3641-d7e2-4752-9aab-2d086bbfda94',80,'105e56abe3804424885c7aa8d1216d12','gigabytes___DEFAULT__',-1,'2026-01-21 15:01:51',NULL),('2026-01-20 15:01:53','2026-01-20 15:01:53','2026-01-20 15:01:53',1,305,'d305c210-41a9-4b50-b21c-60b68542ce32',77,'105e56abe3804424885c7aa8d1216d12','volumes',-1,'2026-01-21 15:01:52',NULL),('2026-01-20 15:01:53','2026-01-20 15:01:53','2026-01-20 15:01:53',1,306,'8974d72f-3fe1-4c25-9a0c-bed48044e237',78,'105e56abe3804424885c7aa8d1216d12','gigabytes',-1,'2026-01-21 15:01:52',NULL),('2026-01-20 15:01:53','2026-01-20 15:01:53','2026-01-20 15:01:53',1,307,'1a1b4b56-53c3-400d-a38e-0eadc0de9b2f',79,'105e56abe3804424885c7aa8d1216d12','volumes___DEFAULT__',-1,'2026-01-21 15:01:52',NULL),('2026-01-20 15:01:53','2026-01-20 15:01:53','2026-01-20 15:01:53',1,308,'38722ec6-3678-4bf4-9a7a-0466b49ca5fb',80,'105e56abe3804424885c7aa8d1216d12','gigabytes___DEFAULT__',-1,'2026-01-21 15:01:52',NULL),('2026-01-20 15:02:54','2026-01-20 15:02:54','2026-01-20 15:02:54',1,309,'5e5cddc0-fb22-484c-942d-f06e7f0324da',85,'96f7b14c2a9348f08305fe232df2a603','volumes',1,'2026-01-21 15:02:54',NULL),('2026-01-20 15:02:54','2026-01-20 15:02:54','2026-01-20 15:02:54',1,310,'f1261f9e-a2e7-4828-8773-58093b1f529d',86,'96f7b14c2a9348f08305fe232df2a603','gigabytes',1,'2026-01-21 15:02:54',NULL),('2026-01-20 15:02:54','2026-01-20 15:02:54','2026-01-20 15:02:54',1,311,'29c68b59-d295-412f-abb4-b27d85aa9f94',87,'96f7b14c2a9348f08305fe232df2a603','volumes___DEFAULT__',1,'2026-01-21 15:02:54',NULL),('2026-01-20 15:02:54','2026-01-20 15:02:54','2026-01-20 15:02:54',1,312,'1367ac13-245c-4d0d-9ec5-8f5054061baa',88,'96f7b14c2a9348f08305fe232df2a603','gigabytes___DEFAULT__',1,'2026-01-21 15:02:54',NULL),('2026-01-20 15:03:49','2026-01-20 15:03:50','2026-01-20 15:03:50',1,313,'f8b68f24-b7f7-44da-ba4e-e692e19674a8',81,'63555e5851564db08c6429231d264f2c','volumes',1,'2026-01-21 15:03:49',NULL),('2026-01-20 15:03:49','2026-01-20 15:03:50','2026-01-20 15:03:50',1,314,'46744446-14cf-45ef-a8c8-ffba14be915a',82,'63555e5851564db08c6429231d264f2c','gigabytes',1,'2026-01-21 15:03:49',NULL),('2026-01-20 15:03:49','2026-01-20 15:03:50','2026-01-20 15:03:50',1,315,'0b45c6f6-77f7-403e-9446-5048ff5775f4',83,'63555e5851564db08c6429231d264f2c','volumes___DEFAULT__',1,'2026-01-21 15:03:49',NULL),('2026-01-20 15:03:49','2026-01-20 15:03:50','2026-01-20 15:03:50',1,316,'bc796922-ffeb-4f7f-8594-532a7a3c5919',84,'63555e5851564db08c6429231d264f2c','gigabytes___DEFAULT__',1,'2026-01-21 15:03:49',NULL),('2026-01-20 15:05:15','2026-01-20 15:05:15','2026-01-20 15:05:15',1,317,'9f33316d-78a8-44a9-990b-f25f4f90f11a',89,'e142d118583b4f9ba3531bcf3838e256','volumes',1,'2026-01-21 15:05:15',NULL),('2026-01-20 15:05:15','2026-01-20 15:05:15','2026-01-20 15:05:15',1,318,'3b93bee7-d366-4086-a68c-552198ba0a63',90,'e142d118583b4f9ba3531bcf3838e256','gigabytes',1,'2026-01-21 15:05:15',NULL),('2026-01-20 15:05:15','2026-01-20 15:05:15','2026-01-20 15:05:15',1,319,'f61d2044-d5b7-4b7a-b9c6-945b91ca0207',91,'e142d118583b4f9ba3531bcf3838e256','volumes___DEFAULT__',1,'2026-01-21 15:05:15',NULL),('2026-01-20 15:05:15','2026-01-20 15:05:15','2026-01-20 15:05:15',1,320,'30311253-0c57-4c4e-904b-33734acb7327',92,'e142d118583b4f9ba3531bcf3838e256','gigabytes___DEFAULT__',1,'2026-01-21 15:05:15',NULL),('2026-01-20 15:05:18','2026-01-20 15:05:18','2026-01-20 15:05:18',1,321,'0f8c3b0c-a819-4ca7-981e-ea999fb385ef',85,'96f7b14c2a9348f08305fe232df2a603','volumes',1,'2026-01-21 15:05:18',NULL),('2026-01-20 15:05:18','2026-01-20 15:05:18','2026-01-20 15:05:18',1,322,'150afbf2-4c0f-42b4-806d-858562746957',86,'96f7b14c2a9348f08305fe232df2a603','gigabytes',1,'2026-01-21 15:05:18',NULL),('2026-01-20 15:05:18','2026-01-20 15:05:18','2026-01-20 15:05:18',1,323,'77de36ff-46ed-4a34-873a-1a937d620a0b',87,'96f7b14c2a9348f08305fe232df2a603','volumes___DEFAULT__',1,'2026-01-21 15:05:18',NULL),('2026-01-20 15:05:18','2026-01-20 15:05:18','2026-01-20 15:05:18',1,324,'f4580531-ae95-438a-a642-f317923f3ef0',88,'96f7b14c2a9348f08305fe232df2a603','gigabytes___DEFAULT__',1,'2026-01-21 15:05:18',NULL),('2026-01-20 15:05:20','2026-01-20 15:05:20','2026-01-20 15:05:20',1,325,'23f2c985-f3c6-4101-8969-51d1c5a26324',93,'0fc924d2df984301897e81920c5e192f','volumes',1,'2026-01-21 15:05:20',NULL),('2026-01-20 15:05:20','2026-01-20 15:05:20','2026-01-20 15:05:20',1,326,'50f78f40-2323-43db-b7e6-625b5bf418be',94,'0fc924d2df984301897e81920c5e192f','gigabytes',1,'2026-01-21 15:05:20',NULL),('2026-01-20 15:05:20','2026-01-20 15:05:20','2026-01-20 15:05:20',1,327,'17524571-4852-4ec6-a7c1-ef21cc7de123',95,'0fc924d2df984301897e81920c5e192f','volumes___DEFAULT__',1,'2026-01-21 15:05:20',NULL),('2026-01-20 15:05:20','2026-01-20 15:05:20','2026-01-20 15:05:20',1,328,'b01c8f8d-1594-4fed-8bbb-10ba64899c44',96,'0fc924d2df984301897e81920c5e192f','gigabytes___DEFAULT__',1,'2026-01-21 15:05:20',NULL),('2026-01-20 15:05:23','2026-01-20 15:05:23','2026-01-20 15:05:23',1,329,'abc7cbf1-60ed-4a09-a681-d744218b3291',85,'96f7b14c2a9348f08305fe232df2a603','volumes',1,'2026-01-21 15:05:23',NULL),('2026-01-20 15:05:23','2026-01-20 15:05:23','2026-01-20 15:05:23',1,330,'1c7b0156-f2fa-4ebe-b9a9-9e4339fbbcf6',86,'96f7b14c2a9348f08305fe232df2a603','gigabytes',1,'2026-01-21 15:05:23',NULL),('2026-01-20 15:05:23','2026-01-20 15:05:23','2026-01-20 15:05:23',1,331,'1edf1fad-4d02-4ed5-ab24-9d8c23cd14cd',87,'96f7b14c2a9348f08305fe232df2a603','volumes___DEFAULT__',1,'2026-01-21 15:05:23',NULL),('2026-01-20 15:05:23','2026-01-20 15:05:23','2026-01-20 15:05:23',1,332,'82d44653-8885-4279-80aa-2f32c2e1d529',88,'96f7b14c2a9348f08305fe232df2a603','gigabytes___DEFAULT__',1,'2026-01-21 15:05:23',NULL),('2026-01-20 15:05:43','2026-01-20 15:05:43','2026-01-20 15:05:43',1,333,'a8d0b9c9-e287-4ce3-aa93-66eff1002e91',85,'96f7b14c2a9348f08305fe232df2a603','volumes',-1,'2026-01-21 15:05:43',NULL),('2026-01-20 15:05:43','2026-01-20 15:05:43','2026-01-20 15:05:43',1,334,'9b751033-444f-498e-baa8-c8472ca8caae',86,'96f7b14c2a9348f08305fe232df2a603','gigabytes',-1,'2026-01-21 15:05:43',NULL),('2026-01-20 15:05:43','2026-01-20 15:05:43','2026-01-20 15:05:43',1,335,'ab77015f-fb89-4aff-b46f-0150cb204890',87,'96f7b14c2a9348f08305fe232df2a603','volumes___DEFAULT__',-1,'2026-01-21 15:05:43',NULL),('2026-01-20 15:05:43','2026-01-20 15:05:43','2026-01-20 15:05:43',1,336,'910113dc-92cd-472d-9514-c31e26e2cc88',88,'96f7b14c2a9348f08305fe232df2a603','gigabytes___DEFAULT__',-1,'2026-01-21 15:05:43',NULL),('2026-01-20 15:05:45','2026-01-20 15:05:45','2026-01-20 15:05:45',1,337,'adfc45b9-a22a-4f98-9385-053856faac8b',85,'96f7b14c2a9348f08305fe232df2a603','volumes',-1,'2026-01-21 15:05:45',NULL),('2026-01-20 15:05:45','2026-01-20 15:05:45','2026-01-20 15:05:45',1,338,'2b366a14-49ab-4d46-b935-9259c3efc99f',86,'96f7b14c2a9348f08305fe232df2a603','gigabytes',-1,'2026-01-21 15:05:45',NULL),('2026-01-20 15:05:45','2026-01-20 15:05:45','2026-01-20 15:05:45',1,339,'ae1a7eb5-df91-490a-880e-ed8c914a175a',87,'96f7b14c2a9348f08305fe232df2a603','volumes___DEFAULT__',-1,'2026-01-21 15:05:45',NULL),('2026-01-20 15:05:45','2026-01-20 15:05:45','2026-01-20 15:05:45',1,340,'598cf71f-12a5-4efa-ac9c-cfd2b0f98c2d',88,'96f7b14c2a9348f08305fe232df2a603','gigabytes___DEFAULT__',-1,'2026-01-21 15:05:45',NULL),('2026-01-20 15:05:47','2026-01-20 15:05:47','2026-01-20 15:05:47',1,341,'d49d3460-7eea-47d5-8f5d-ec6d3aa396a3',85,'96f7b14c2a9348f08305fe232df2a603','volumes',-1,'2026-01-21 15:05:47',NULL),('2026-01-20 15:05:47','2026-01-20 15:05:47','2026-01-20 15:05:47',1,342,'734c99fc-a673-493c-b865-9d15b9fedda9',86,'96f7b14c2a9348f08305fe232df2a603','gigabytes',-1,'2026-01-21 15:05:47',NULL),('2026-01-20 15:05:47','2026-01-20 15:05:47','2026-01-20 15:05:47',1,343,'8a3dcf2a-813a-45b2-96f4-7ee2465ed544',87,'96f7b14c2a9348f08305fe232df2a603','volumes___DEFAULT__',-1,'2026-01-21 15:05:47',NULL),('2026-01-20 15:05:47','2026-01-20 15:05:47','2026-01-20 15:05:47',1,344,'bc0a33b8-5d73-4d47-8584-f7fa7aeb56f7',88,'96f7b14c2a9348f08305fe232df2a603','gigabytes___DEFAULT__',-1,'2026-01-21 15:05:47',NULL),('2026-01-20 15:05:57','2026-01-20 15:05:57','2026-01-20 15:05:57',1,345,'d708db31-550d-42bf-ad41-66e3169d3eaf',97,'f9a4fb1ea67548318c6ff2af4e9d4abe','volumes',1,'2026-01-21 15:05:57',NULL),('2026-01-20 15:05:57','2026-01-20 15:05:57','2026-01-20 15:05:57',1,346,'18dd59eb-c007-4eba-ac2f-36d034574135',98,'f9a4fb1ea67548318c6ff2af4e9d4abe','gigabytes',1,'2026-01-21 15:05:57',NULL),('2026-01-20 15:05:57','2026-01-20 15:05:57','2026-01-20 15:05:57',1,347,'29f0a794-fb1e-4997-8b00-e3c6aca075e2',99,'f9a4fb1ea67548318c6ff2af4e9d4abe','volumes___DEFAULT__',1,'2026-01-21 15:05:57',NULL),('2026-01-20 15:05:57','2026-01-20 15:05:57','2026-01-20 15:05:57',1,348,'1d2798af-cacd-4fb7-b933-9ebd69ee04b9',100,'f9a4fb1ea67548318c6ff2af4e9d4abe','gigabytes___DEFAULT__',1,'2026-01-21 15:05:57',NULL),('2026-01-20 15:05:58','2026-01-20 15:05:58','2026-01-20 15:05:58',1,349,'a92da25e-ea3a-450a-b31b-1a71897829af',101,'e142d118583b4f9ba3531bcf3838e256','snapshots',1,'2026-01-21 15:05:57',NULL),('2026-01-20 15:05:58','2026-01-20 15:05:58','2026-01-20 15:05:58',1,350,'cd2c298f-a006-4d21-ba67-2b85b7607f69',90,'e142d118583b4f9ba3531bcf3838e256','gigabytes',1,'2026-01-21 15:05:57',NULL),('2026-01-20 15:05:58','2026-01-20 15:05:58','2026-01-20 15:05:58',1,351,'d92156ad-5c56-4304-95ae-76c85313ebf7',92,'e142d118583b4f9ba3531bcf3838e256','gigabytes___DEFAULT__',1,'2026-01-21 15:05:57',NULL),('2026-01-20 15:05:58','2026-01-20 15:05:58','2026-01-20 15:05:58',1,352,'9a5b0563-9bdd-4a02-9307-3a5d28084369',102,'e142d118583b4f9ba3531bcf3838e256','snapshots___DEFAULT__',1,'2026-01-21 15:05:57',NULL),('2026-01-20 15:05:59','2026-01-20 15:05:59','2026-01-20 15:05:59',1,353,'13fc1508-2890-4a6a-86c8-90d1cf1b1f37',103,'f9a4fb1ea67548318c6ff2af4e9d4abe','snapshots',1,'2026-01-21 15:05:59',NULL),('2026-01-20 15:05:59','2026-01-20 15:05:59','2026-01-20 15:05:59',1,354,'d077c875-bab5-40eb-aeec-4efa214defee',98,'f9a4fb1ea67548318c6ff2af4e9d4abe','gigabytes',1,'2026-01-21 15:05:59',NULL),('2026-01-20 15:05:59','2026-01-20 15:05:59','2026-01-20 15:05:59',1,355,'62409bc1-4b9a-43df-adb0-6a9e13c16a0b',100,'f9a4fb1ea67548318c6ff2af4e9d4abe','gigabytes___DEFAULT__',1,'2026-01-21 15:05:59',NULL),('2026-01-20 15:05:59','2026-01-20 15:05:59','2026-01-20 15:05:59',1,356,'3812f4e4-77ba-41ec-83ca-0f7f01af537a',104,'f9a4fb1ea67548318c6ff2af4e9d4abe','snapshots___DEFAULT__',1,'2026-01-21 15:05:59',NULL),('2026-01-20 15:06:01','2026-01-20 15:06:01','2026-01-20 15:06:01',1,357,'7600fd11-74d3-48d2-8d9a-2b1801bdbce9',103,'f9a4fb1ea67548318c6ff2af4e9d4abe','snapshots',-1,'2026-01-21 15:06:01',NULL),('2026-01-20 15:06:01','2026-01-20 15:06:01','2026-01-20 15:06:01',1,358,'8025469f-075d-45be-80a3-f56361de3a6e',98,'f9a4fb1ea67548318c6ff2af4e9d4abe','gigabytes',-1,'2026-01-21 15:06:01',NULL),('2026-01-20 15:06:01','2026-01-20 15:06:01','2026-01-20 15:06:01',1,359,'d75db034-02b7-49cd-bc0d-687ec3e8dc05',100,'f9a4fb1ea67548318c6ff2af4e9d4abe','gigabytes___DEFAULT__',-1,'2026-01-21 15:06:01',NULL),('2026-01-20 15:06:01','2026-01-20 15:06:01','2026-01-20 15:06:01',1,360,'2de816e1-b230-4023-833f-cc284bea0a31',104,'f9a4fb1ea67548318c6ff2af4e9d4abe','snapshots___DEFAULT__',-1,'2026-01-21 15:06:01',NULL),('2026-01-20 15:06:03','2026-01-20 15:06:03','2026-01-20 15:06:03',1,361,'c1902c41-688b-40e2-989a-0188a02fd8ea',97,'f9a4fb1ea67548318c6ff2af4e9d4abe','volumes',-1,'2026-01-21 15:06:03',NULL),('2026-01-20 15:06:03','2026-01-20 15:06:03','2026-01-20 15:06:03',1,362,'a5fe8aa7-1a1e-4f3d-9ee4-e5c5b1d1f5f1',98,'f9a4fb1ea67548318c6ff2af4e9d4abe','gigabytes',-1,'2026-01-21 15:06:03',NULL),('2026-01-20 15:06:03','2026-01-20 15:06:03','2026-01-20 15:06:03',1,363,'457a537a-83a8-47e5-b6ed-26adf2a2f524',99,'f9a4fb1ea67548318c6ff2af4e9d4abe','volumes___DEFAULT__',-1,'2026-01-21 15:06:03',NULL),('2026-01-20 15:06:03','2026-01-20 15:06:03','2026-01-20 15:06:03',1,364,'3448d3de-0f0e-4ba7-9306-6f5211930970',100,'f9a4fb1ea67548318c6ff2af4e9d4abe','gigabytes___DEFAULT__',-1,'2026-01-21 15:06:03',NULL),('2026-01-20 15:06:07','2026-01-20 15:06:07','2026-01-20 15:06:07',1,365,'ea1fdff3-2dbe-462a-af8b-a1fd1efff6ad',89,'e142d118583b4f9ba3531bcf3838e256','volumes',1,'2026-01-21 15:06:07',NULL),('2026-01-20 15:06:07','2026-01-20 15:06:07','2026-01-20 15:06:07',1,366,'b5a7f0e7-865a-4c1f-808a-5f7dbc04d165',90,'e142d118583b4f9ba3531bcf3838e256','gigabytes',1,'2026-01-21 15:06:07',NULL),('2026-01-20 15:06:07','2026-01-20 15:06:07','2026-01-20 15:06:07',1,367,'c5477226-d25b-4aad-92d2-3bffd434c35c',91,'e142d118583b4f9ba3531bcf3838e256','volumes___DEFAULT__',1,'2026-01-21 15:06:07',NULL),('2026-01-20 15:06:07','2026-01-20 15:06:07','2026-01-20 15:06:07',1,368,'bdac541a-ce39-4fbf-8ee2-dedf4b671606',92,'e142d118583b4f9ba3531bcf3838e256','gigabytes___DEFAULT__',1,'2026-01-21 15:06:07',NULL),('2026-01-20 15:06:09','2026-01-20 15:06:09','2026-01-20 15:06:09',1,369,'3dc7b717-92fc-4974-99ed-fd0e299aa434',105,'329ef67ba7884caa87edf40d2d26e70f','volumes',1,'2026-01-21 15:06:09',NULL),('2026-01-20 15:06:09','2026-01-20 15:06:09','2026-01-20 15:06:09',1,370,'958b5925-87d3-4791-a1c1-53ff7b744120',106,'329ef67ba7884caa87edf40d2d26e70f','gigabytes',1,'2026-01-21 15:06:09',NULL),('2026-01-20 15:06:09','2026-01-20 15:06:09','2026-01-20 15:06:09',1,371,'e14973bd-1ab6-4d8a-bd08-aefb1bfe3611',107,'329ef67ba7884caa87edf40d2d26e70f','volumes___DEFAULT__',1,'2026-01-21 15:06:09',NULL),('2026-01-20 15:06:09','2026-01-20 15:06:09','2026-01-20 15:06:09',1,372,'c3dc1813-9f1b-4c06-9dd3-63f2cf55ff4d',108,'329ef67ba7884caa87edf40d2d26e70f','gigabytes___DEFAULT__',1,'2026-01-21 15:06:09',NULL),('2026-01-20 15:06:10','2026-01-20 15:06:10','2026-01-20 15:06:10',1,373,'26dd56eb-b028-484e-a799-c75d9f48a267',105,'329ef67ba7884caa87edf40d2d26e70f','volumes',-1,'2026-01-21 15:06:10',NULL),('2026-01-20 15:06:10','2026-01-20 15:06:10','2026-01-20 15:06:10',1,374,'a9c98c54-4d00-4535-9ba7-b5dfbb419148',106,'329ef67ba7884caa87edf40d2d26e70f','gigabytes',-1,'2026-01-21 15:06:10',NULL),('2026-01-20 15:06:10','2026-01-20 15:06:10','2026-01-20 15:06:10',1,375,'31a56007-ee5f-4dde-be6e-51d52055418c',107,'329ef67ba7884caa87edf40d2d26e70f','volumes___DEFAULT__',-1,'2026-01-21 15:06:10',NULL),('2026-01-20 15:06:10','2026-01-20 15:06:10','2026-01-20 15:06:10',1,376,'081a9272-9e3e-4cfe-8560-2d6976e599fa',108,'329ef67ba7884caa87edf40d2d26e70f','gigabytes___DEFAULT__',-1,'2026-01-21 15:06:10',NULL),('2026-01-20 15:06:39','2026-01-20 15:06:39','2026-01-20 15:06:39',1,377,'b4f5bf9a-50b8-4280-80a2-df0b230d7a18',109,'526db518ca3942b58ee346d4bd970e42','volumes',1,'2026-01-21 15:06:39',NULL),('2026-01-20 15:06:39','2026-01-20 15:06:39','2026-01-20 15:06:39',1,378,'f6108444-200a-4422-97d7-dd076fe510e4',110,'526db518ca3942b58ee346d4bd970e42','gigabytes',1,'2026-01-21 15:06:39',NULL),('2026-01-20 15:06:39','2026-01-20 15:06:39','2026-01-20 15:06:39',1,379,'f7c46c9f-081d-4190-85c4-c54379b17f57',111,'526db518ca3942b58ee346d4bd970e42','volumes_tempest-scenario-type-luks-1068136217',1,'2026-01-21 15:06:39',NULL),('2026-01-20 15:06:39','2026-01-20 15:06:39','2026-01-20 15:06:39',1,380,'7091e288-2bfc-4fe9-a71e-760731b32db6',112,'526db518ca3942b58ee346d4bd970e42','gigabytes_tempest-scenario-type-luks-1068136217',1,'2026-01-21 15:06:39',NULL),('2026-01-20 15:07:11','2026-01-20 15:07:11','2026-01-20 15:07:11',1,381,'bdc65e05-05fd-48a3-b72a-57e0295efe25',89,'e142d118583b4f9ba3531bcf3838e256','volumes',-1,'2026-01-21 15:07:11',NULL),('2026-01-20 15:07:11','2026-01-20 15:07:11','2026-01-20 15:07:11',1,382,'243ab437-a2e3-4289-9301-8eebf8eccd9b',90,'e142d118583b4f9ba3531bcf3838e256','gigabytes',-1,'2026-01-21 15:07:11',NULL),('2026-01-20 15:07:11','2026-01-20 15:07:11','2026-01-20 15:07:11',1,383,'9ab9f51f-0821-4bce-9ac0-86e3b3c4c365',91,'e142d118583b4f9ba3531bcf3838e256','volumes___DEFAULT__',-1,'2026-01-21 15:07:11',NULL),('2026-01-20 15:07:11','2026-01-20 15:07:11','2026-01-20 15:07:11',1,384,'66fc80b0-6912-4ac5-be88-6cc2a6b33b41',92,'e142d118583b4f9ba3531bcf3838e256','gigabytes___DEFAULT__',-1,'2026-01-21 15:07:11',NULL),('2026-01-20 15:07:12','2026-01-20 15:07:12','2026-01-20 15:07:12',1,385,'2fa46970-2613-4a1d-ba3a-06852a9a1379',93,'0fc924d2df984301897e81920c5e192f','volumes',-1,'2026-01-21 15:07:12',NULL),('2026-01-20 15:07:12','2026-01-20 15:07:12','2026-01-20 15:07:12',1,386,'a346d5f2-f332-40b3-af95-0d1b8e901ea4',94,'0fc924d2df984301897e81920c5e192f','gigabytes',-1,'2026-01-21 15:07:12',NULL),('2026-01-20 15:07:12','2026-01-20 15:07:12','2026-01-20 15:07:12',1,387,'5b3db4f1-5e5e-49d7-98dd-5fbb1a0853ac',95,'0fc924d2df984301897e81920c5e192f','volumes___DEFAULT__',-1,'2026-01-21 15:07:12',NULL),('2026-01-20 15:07:12','2026-01-20 15:07:12','2026-01-20 15:07:12',1,388,'6f064af2-7080-42bd-b6cc-024adf1f60a7',96,'0fc924d2df984301897e81920c5e192f','gigabytes___DEFAULT__',-1,'2026-01-21 15:07:12',NULL),('2026-01-20 15:07:14','2026-01-20 15:07:14','2026-01-20 15:07:14',1,389,'058723a7-914a-4f64-8a49-26882b9d604c',101,'e142d118583b4f9ba3531bcf3838e256','snapshots',-1,'2026-01-21 15:07:14',NULL),('2026-01-20 15:07:14','2026-01-20 15:07:14','2026-01-20 15:07:14',1,390,'2e1c1be0-500d-47ff-95b2-165ac2156b20',90,'e142d118583b4f9ba3531bcf3838e256','gigabytes',-1,'2026-01-21 15:07:14',NULL),('2026-01-20 15:07:14','2026-01-20 15:07:14','2026-01-20 15:07:14',1,391,'a849ae4c-798d-40f7-bd29-e4a1e09af0a0',92,'e142d118583b4f9ba3531bcf3838e256','gigabytes___DEFAULT__',-1,'2026-01-21 15:07:14',NULL),('2026-01-20 15:07:14','2026-01-20 15:07:14','2026-01-20 15:07:14',1,392,'8027656f-70fe-45ef-92ac-754e4ccf943d',102,'e142d118583b4f9ba3531bcf3838e256','snapshots___DEFAULT__',-1,'2026-01-21 15:07:14',NULL),('2026-01-20 15:07:21','2026-01-20 15:07:21','2026-01-20 15:07:21',1,393,'a22d8a74-7019-4f7e-9fcc-724e9240d5f2',89,'e142d118583b4f9ba3531bcf3838e256','volumes',-1,'2026-01-21 15:07:21',NULL),('2026-01-20 15:07:21','2026-01-20 15:07:21','2026-01-20 15:07:21',1,394,'be2dfc99-c237-41de-80a0-43a92da1c1d7',90,'e142d118583b4f9ba3531bcf3838e256','gigabytes',-1,'2026-01-21 15:07:21',NULL),('2026-01-20 15:07:21','2026-01-20 15:07:21','2026-01-20 15:07:21',1,395,'abb69c45-ba2e-4285-9e15-97ea31f1d9e4',91,'e142d118583b4f9ba3531bcf3838e256','volumes___DEFAULT__',-1,'2026-01-21 15:07:21',NULL),('2026-01-20 15:07:21','2026-01-20 15:07:21','2026-01-20 15:07:21',1,396,'af1d649f-07d1-4d99-881e-ad0b60efda01',92,'e142d118583b4f9ba3531bcf3838e256','gigabytes___DEFAULT__',-1,'2026-01-21 15:07:21',NULL),('2026-01-20 15:07:47','2026-01-20 15:07:47','2026-01-20 15:07:47',1,397,'02747503-66a6-47bf-87fd-92906a02695e',109,'526db518ca3942b58ee346d4bd970e42','volumes',-1,'2026-01-21 15:07:47',NULL),('2026-01-20 15:07:47','2026-01-20 15:07:47','2026-01-20 15:07:47',1,398,'5011c452-d9b9-4b6f-97d0-fd786cfbab42',110,'526db518ca3942b58ee346d4bd970e42','gigabytes',-1,'2026-01-21 15:07:47',NULL),('2026-01-20 15:07:47','2026-01-20 15:07:47','2026-01-20 15:07:47',1,399,'3c8433f3-ce4b-4614-8798-6142c369c185',111,'526db518ca3942b58ee346d4bd970e42','volumes_tempest-scenario-type-luks-1068136217',-1,'2026-01-21 15:07:47',NULL),('2026-01-20 15:07:47','2026-01-20 15:07:47','2026-01-20 15:07:47',1,400,'5736b54f-f969-4883-a89e-6c3ee06a280b',112,'526db518ca3942b58ee346d4bd970e42','gigabytes_tempest-scenario-type-luks-1068136217',-1,'2026-01-21 15:07:47',NULL),('2026-01-20 15:08:02','2026-01-20 15:08:02','2026-01-20 15:08:02',1,401,'0daf66bb-e75f-41de-a717-6b720894fc45',113,'48aeeaa346bb4dfba4dfc598ae41f062','volumes',1,'2026-01-21 15:08:02',NULL),('2026-01-20 15:08:02','2026-01-20 15:08:02','2026-01-20 15:08:02',1,402,'1382bba8-1d98-4f2b-a2b0-fe1b93ca91ec',114,'48aeeaa346bb4dfba4dfc598ae41f062','gigabytes',1,'2026-01-21 15:08:02',NULL),('2026-01-20 15:08:02','2026-01-20 15:08:02','2026-01-20 15:08:02',1,403,'1be3ac7a-4399-4105-8886-2758924b08ae',115,'48aeeaa346bb4dfba4dfc598ae41f062','volumes___DEFAULT__',1,'2026-01-21 15:08:02',NULL),('2026-01-20 15:08:02','2026-01-20 15:08:02','2026-01-20 15:08:02',1,404,'f42b28ee-1bb1-4682-93e6-9ba710e9b577',116,'48aeeaa346bb4dfba4dfc598ae41f062','gigabytes___DEFAULT__',1,'2026-01-21 15:08:02',NULL),('2026-01-20 15:08:10','2026-01-20 15:08:10','2026-01-20 15:08:10',1,405,'01f7f335-5480-400e-b04d-5916a5217395',117,'48aeeaa346bb4dfba4dfc598ae41f062','backups',1,'2026-01-21 15:08:10',NULL),('2026-01-20 15:08:10','2026-01-20 15:08:10','2026-01-20 15:08:10',1,406,'0c4bfadd-c35b-4c14-b417-3707c54a0937',118,'48aeeaa346bb4dfba4dfc598ae41f062','backup_gigabytes',1,'2026-01-21 15:08:10',NULL),('2026-01-20 15:08:17','2026-01-20 15:08:17','2026-01-20 15:08:17',1,407,'050089d0-b9a3-4ab3-b882-9968f9c93d8b',113,'48aeeaa346bb4dfba4dfc598ae41f062','volumes',1,'2026-01-21 15:08:17',NULL),('2026-01-20 15:08:17','2026-01-20 15:08:17','2026-01-20 15:08:17',1,408,'3e7ff62e-6a27-4342-8ea4-44cf23896995',114,'48aeeaa346bb4dfba4dfc598ae41f062','gigabytes',1,'2026-01-21 15:08:17',NULL),('2026-01-20 15:08:17','2026-01-20 15:08:17','2026-01-20 15:08:17',1,409,'e638dbcb-3ae4-4fd9-b337-415398c29a35',115,'48aeeaa346bb4dfba4dfc598ae41f062','volumes___DEFAULT__',1,'2026-01-21 15:08:17',NULL),('2026-01-20 15:08:17','2026-01-20 15:08:17','2026-01-20 15:08:17',1,410,'ed38ce79-eb4a-4767-8f21-11a8de951d4d',116,'48aeeaa346bb4dfba4dfc598ae41f062','gigabytes___DEFAULT__',1,'2026-01-21 15:08:17',NULL),('2026-01-20 15:08:32','2026-01-20 15:08:32','2026-01-20 15:08:32',1,411,'3fa84555-ff22-40c8-9fc1-609749e858be',119,'fc74c4a296554866969b05aef75252af','volumes',1,'2026-01-21 15:08:32',NULL),('2026-01-20 15:08:32','2026-01-20 15:08:32','2026-01-20 15:08:32',1,412,'76c74ae6-dfa7-48bc-9aa0-7005dfa5500a',120,'fc74c4a296554866969b05aef75252af','gigabytes',1,'2026-01-21 15:08:32',NULL),('2026-01-20 15:08:32','2026-01-20 15:08:32','2026-01-20 15:08:32',1,413,'dce9c978-ce5c-4f69-952c-10641f4618d5',121,'fc74c4a296554866969b05aef75252af','volumes___DEFAULT__',1,'2026-01-21 15:08:32',NULL),('2026-01-20 15:08:32','2026-01-20 15:08:32','2026-01-20 15:08:32',1,414,'314ba64c-1dff-4d2d-b4e1-bdcc10552f58',122,'fc74c4a296554866969b05aef75252af','gigabytes___DEFAULT__',1,'2026-01-21 15:08:32',NULL),('2026-01-20 15:08:44','2026-01-20 15:08:44','2026-01-20 15:08:44',1,415,'189319bc-6b56-4c41-b38c-88cad70c5668',123,'5b43342be22543f79d4a56e26c6d0c96','volumes',1,'2026-01-21 15:08:44',NULL),('2026-01-20 15:08:44','2026-01-20 15:08:44','2026-01-20 15:08:44',1,416,'aa7f64f3-ba73-4cfd-84c3-9f1f467a5412',124,'5b43342be22543f79d4a56e26c6d0c96','gigabytes',1,'2026-01-21 15:08:44',NULL),('2026-01-20 15:08:44','2026-01-20 15:08:44','2026-01-20 15:08:44',1,417,'80b09a4c-ac34-498d-b918-ecd107666fee',125,'5b43342be22543f79d4a56e26c6d0c96','volumes___DEFAULT__',1,'2026-01-21 15:08:44',NULL),('2026-01-20 15:08:44','2026-01-20 15:08:44','2026-01-20 15:08:44',1,418,'00308ba6-7f04-45cc-bcf4-154361a04ab0',126,'5b43342be22543f79d4a56e26c6d0c96','gigabytes___DEFAULT__',1,'2026-01-21 15:08:44',NULL),('2026-01-20 15:08:51','2026-01-20 15:08:51','2026-01-20 15:08:51',1,419,'1c63c5c6-ff43-4b09-8061-afb3e4609781',127,'5b43342be22543f79d4a56e26c6d0c96','snapshots',1,'2026-01-21 15:08:51',NULL),('2026-01-20 15:08:51','2026-01-20 15:08:51','2026-01-20 15:08:51',1,420,'8e08b496-84f8-4807-a415-3a0e8892799d',124,'5b43342be22543f79d4a56e26c6d0c96','gigabytes',1,'2026-01-21 15:08:51',NULL),('2026-01-20 15:08:51','2026-01-20 15:08:51','2026-01-20 15:08:51',1,421,'dfdc0db3-2a3d-4c47-a682-124664a7b0fd',126,'5b43342be22543f79d4a56e26c6d0c96','gigabytes___DEFAULT__',1,'2026-01-21 15:08:51',NULL),('2026-01-20 15:08:51','2026-01-20 15:08:51','2026-01-20 15:08:51',1,422,'0e617ca8-4afe-4827-a68d-95acc019eb32',128,'5b43342be22543f79d4a56e26c6d0c96','snapshots___DEFAULT__',1,'2026-01-21 15:08:51',NULL),('2026-01-20 15:08:54','2026-01-20 15:08:54','2026-01-20 15:08:54',1,423,'d62fb0df-0551-4105-aa86-66ff94ff8b32',119,'fc74c4a296554866969b05aef75252af','volumes',1,'2026-01-21 15:08:54',NULL),('2026-01-20 15:08:54','2026-01-20 15:08:54','2026-01-20 15:08:54',1,424,'3e6c400c-cc67-40b0-9031-5fcdf04c80cb',120,'fc74c4a296554866969b05aef75252af','gigabytes',1,'2026-01-21 15:08:54',NULL),('2026-01-20 15:08:54','2026-01-20 15:08:54','2026-01-20 15:08:54',1,425,'2cee5496-1c16-46c2-b11f-701491cc6515',121,'fc74c4a296554866969b05aef75252af','volumes___DEFAULT__',1,'2026-01-21 15:08:54',NULL),('2026-01-20 15:08:54','2026-01-20 15:08:54','2026-01-20 15:08:54',1,426,'d820e99a-5313-4c24-b5c2-f17179b59189',122,'fc74c4a296554866969b05aef75252af','gigabytes___DEFAULT__',1,'2026-01-21 15:08:54',NULL),('2026-01-20 15:09:04','2026-01-20 15:09:04','2026-01-20 15:09:04',1,427,'fd1f545c-bda7-4658-b6c5-a888fdc5b3cf',127,'5b43342be22543f79d4a56e26c6d0c96','snapshots',-1,'2026-01-21 15:09:04',NULL),('2026-01-20 15:09:04','2026-01-20 15:09:04','2026-01-20 15:09:04',1,428,'8c0b2834-24bc-434b-8fef-5078d5993506',124,'5b43342be22543f79d4a56e26c6d0c96','gigabytes',-1,'2026-01-21 15:09:04',NULL),('2026-01-20 15:09:04','2026-01-20 15:09:04','2026-01-20 15:09:04',1,429,'344738f4-f9d9-4046-b1f5-74bbaf8b81c9',126,'5b43342be22543f79d4a56e26c6d0c96','gigabytes___DEFAULT__',-1,'2026-01-21 15:09:04',NULL),('2026-01-20 15:09:04','2026-01-20 15:09:04','2026-01-20 15:09:04',1,430,'bc8f67c0-aa63-4899-b579-508ff8bbf327',128,'5b43342be22543f79d4a56e26c6d0c96','snapshots___DEFAULT__',-1,'2026-01-21 15:09:04',NULL),('2026-01-20 15:09:05','2026-01-20 15:09:05','2026-01-20 15:09:05',1,431,'7c626999-60c5-4b5c-9708-c6ac45ba10a0',113,'48aeeaa346bb4dfba4dfc598ae41f062','volumes',-1,'2026-01-21 15:09:05',NULL),('2026-01-20 15:09:05','2026-01-20 15:09:05','2026-01-20 15:09:05',1,432,'405120ca-a2f1-45b2-b4cd-593f9f449bc9',114,'48aeeaa346bb4dfba4dfc598ae41f062','gigabytes',-1,'2026-01-21 15:09:05',NULL),('2026-01-20 15:09:05','2026-01-20 15:09:05','2026-01-20 15:09:05',1,433,'7d9fa4b7-4493-4d78-ba0b-cb3ad8c5ec2e',115,'48aeeaa346bb4dfba4dfc598ae41f062','volumes___DEFAULT__',-1,'2026-01-21 15:09:05',NULL),('2026-01-20 15:09:05','2026-01-20 15:09:05','2026-01-20 15:09:05',1,434,'d5d0e951-e689-4059-80e8-6dba517a9fd9',116,'48aeeaa346bb4dfba4dfc598ae41f062','gigabytes___DEFAULT__',-1,'2026-01-21 15:09:05',NULL),('2026-01-20 15:09:06','2026-01-20 15:09:06','2026-01-20 15:09:06',1,435,'6da47bc7-91b9-41c6-b3a8-7e9baa36a048',117,'48aeeaa346bb4dfba4dfc598ae41f062','backups',-1,'2026-01-21 15:09:06',NULL),('2026-01-20 15:09:06','2026-01-20 15:09:06','2026-01-20 15:09:06',1,436,'5fbc878d-e4fa-49a8-b87d-abdf25e14893',118,'48aeeaa346bb4dfba4dfc598ae41f062','backup_gigabytes',-1,'2026-01-21 15:09:06',NULL),('2026-01-20 15:09:06','2026-01-20 15:09:06','2026-01-20 15:09:06',1,437,'ee2e3c35-ae5e-427d-a459-b4a362389442',113,'48aeeaa346bb4dfba4dfc598ae41f062','volumes',-1,'2026-01-21 15:09:06',NULL),('2026-01-20 15:09:06','2026-01-20 15:09:06','2026-01-20 15:09:06',1,438,'3659b9bb-1919-41e1-aa32-739171c0310f',114,'48aeeaa346bb4dfba4dfc598ae41f062','gigabytes',-1,'2026-01-21 15:09:06',NULL),('2026-01-20 15:09:06','2026-01-20 15:09:06','2026-01-20 15:09:06',1,439,'544e7b77-5b86-4442-b14e-8a8ae445a5d1',115,'48aeeaa346bb4dfba4dfc598ae41f062','volumes___DEFAULT__',-1,'2026-01-21 15:09:06',NULL),('2026-01-20 15:09:06','2026-01-20 15:09:06','2026-01-20 15:09:06',1,440,'795d2e23-2f7a-42c5-acf8-9d1ca56f4e63',116,'48aeeaa346bb4dfba4dfc598ae41f062','gigabytes___DEFAULT__',-1,'2026-01-21 15:09:06',NULL),('2026-01-20 15:09:35','2026-01-20 15:09:35','2026-01-20 15:09:35',1,441,'e21ec966-4e5a-4c61-ac9c-3fd6981d815f',123,'5b43342be22543f79d4a56e26c6d0c96','volumes',-1,'2026-01-21 15:09:35',NULL),('2026-01-20 15:09:35','2026-01-20 15:09:35','2026-01-20 15:09:35',1,442,'96c787c8-5184-4249-a198-7630cb00b99b',124,'5b43342be22543f79d4a56e26c6d0c96','gigabytes',-1,'2026-01-21 15:09:35',NULL),('2026-01-20 15:09:35','2026-01-20 15:09:35','2026-01-20 15:09:35',1,443,'738f09ce-fdea-4c8d-b8b4-6b1f83a2aa19',125,'5b43342be22543f79d4a56e26c6d0c96','volumes___DEFAULT__',-1,'2026-01-21 15:09:35',NULL),('2026-01-20 15:09:35','2026-01-20 15:09:35','2026-01-20 15:09:35',1,444,'a6e03997-83a7-496d-875b-b2f40ea9e3db',126,'5b43342be22543f79d4a56e26c6d0c96','gigabytes___DEFAULT__',-1,'2026-01-21 15:09:35',NULL),('2026-01-20 15:09:49','2026-01-20 15:09:49','2026-01-20 15:09:49',1,445,'c4a80554-8c39-457c-81c0-d7c2c910812a',129,'a49638950e1543fa8e0d251af5479623','volumes',1,'2026-01-21 15:09:49',NULL),('2026-01-20 15:09:49','2026-01-20 15:09:49','2026-01-20 15:09:49',1,446,'cdf6b362-6204-4237-bb16-99ededf19cb5',130,'a49638950e1543fa8e0d251af5479623','gigabytes',1,'2026-01-21 15:09:49',NULL),('2026-01-20 15:09:49','2026-01-20 15:09:49','2026-01-20 15:09:49',1,447,'15bfbdc4-d9cc-4f04-ae14-3183858df7f4',131,'a49638950e1543fa8e0d251af5479623','volumes_tempest-scenario-type-luks-795593813',1,'2026-01-21 15:09:49',NULL),('2026-01-20 15:09:49','2026-01-20 15:09:49','2026-01-20 15:09:49',1,448,'59c2d9d5-7643-4708-8a46-d696a2daf8af',132,'a49638950e1543fa8e0d251af5479623','gigabytes_tempest-scenario-type-luks-795593813',1,'2026-01-21 15:09:49',NULL),('2026-01-20 15:10:03','2026-01-20 15:10:03','2026-01-20 15:10:03',1,449,'e7a3c9e6-8179-4e3f-8349-213f7ea3379c',123,'5b43342be22543f79d4a56e26c6d0c96','volumes',1,'2026-01-21 15:10:03',NULL),('2026-01-20 15:10:03','2026-01-20 15:10:03','2026-01-20 15:10:03',1,450,'a171699b-8713-4015-bed7-80831a261dd1',124,'5b43342be22543f79d4a56e26c6d0c96','gigabytes',1,'2026-01-21 15:10:03',NULL),('2026-01-20 15:10:03','2026-01-20 15:10:03','2026-01-20 15:10:03',1,451,'2b9d1f24-64e0-4bad-9870-586e5abdfa7a',125,'5b43342be22543f79d4a56e26c6d0c96','volumes___DEFAULT__',1,'2026-01-21 15:10:03',NULL),('2026-01-20 15:10:03','2026-01-20 15:10:03','2026-01-20 15:10:03',1,452,'4db9542a-8be1-4d71-9d3d-807b1ac484af',126,'5b43342be22543f79d4a56e26c6d0c96','gigabytes___DEFAULT__',1,'2026-01-21 15:10:03',NULL),('2026-01-20 15:10:24','2026-01-20 15:10:24','2026-01-20 15:10:24',1,453,'77bed4b9-4c4c-42f6-b2c2-9ab1ba5058f8',129,'a49638950e1543fa8e0d251af5479623','volumes',-1,'2026-01-21 15:10:24',NULL),('2026-01-20 15:10:24','2026-01-20 15:10:24','2026-01-20 15:10:24',1,454,'b6863ba0-13d5-4ad5-910a-a510119a8332',130,'a49638950e1543fa8e0d251af5479623','gigabytes',-1,'2026-01-21 15:10:24',NULL),('2026-01-20 15:10:24','2026-01-20 15:10:24','2026-01-20 15:10:24',1,455,'954a857f-9c89-47dc-b044-da9caccc1854',131,'a49638950e1543fa8e0d251af5479623','volumes_tempest-scenario-type-luks-795593813',-1,'2026-01-21 15:10:24',NULL),('2026-01-20 15:10:24','2026-01-20 15:10:24','2026-01-20 15:10:24',1,456,'3e391a39-a246-4ecf-b2cf-e5458857cb7c',132,'a49638950e1543fa8e0d251af5479623','gigabytes_tempest-scenario-type-luks-795593813',-1,'2026-01-21 15:10:24',NULL),('2026-01-20 15:10:26','2026-01-20 15:10:26','2026-01-20 15:10:26',1,457,'ec9e3f71-6c2c-42f9-8d2a-7f59e5c03075',129,'a49638950e1543fa8e0d251af5479623','volumes',1,'2026-01-21 15:10:26',NULL),('2026-01-20 15:10:26','2026-01-20 15:10:26','2026-01-20 15:10:26',1,458,'682241db-57a0-4007-8001-ef179cc1e555',130,'a49638950e1543fa8e0d251af5479623','gigabytes',1,'2026-01-21 15:10:26',NULL),('2026-01-20 15:10:26','2026-01-20 15:10:26','2026-01-20 15:10:26',1,459,'506db2d1-1704-4383-b19b-3a06defb9f95',133,'a49638950e1543fa8e0d251af5479623','volumes___DEFAULT__',1,'2026-01-21 15:10:26',NULL),('2026-01-20 15:10:26','2026-01-20 15:10:26','2026-01-20 15:10:26',1,460,'3a7cd69a-7a68-4fc6-87c1-eff4d4ec32c6',134,'a49638950e1543fa8e0d251af5479623','gigabytes___DEFAULT__',1,'2026-01-21 15:10:26',NULL),('2026-01-20 15:10:35','2026-01-20 15:10:35','2026-01-20 15:10:35',1,461,'1c65fbb3-e3d1-4d49-a2e6-0cc2b13feb4e',119,'fc74c4a296554866969b05aef75252af','volumes',-1,'2026-01-21 15:10:35',NULL),('2026-01-20 15:10:35','2026-01-20 15:10:35','2026-01-20 15:10:35',1,462,'bf681806-d028-48bc-a2ac-ab11a1ee98e0',120,'fc74c4a296554866969b05aef75252af','gigabytes',-1,'2026-01-21 15:10:35',NULL),('2026-01-20 15:10:35','2026-01-20 15:10:35','2026-01-20 15:10:35',1,463,'37bd30a5-9e87-4d25-b640-69ea04dc2d36',121,'fc74c4a296554866969b05aef75252af','volumes___DEFAULT__',-1,'2026-01-21 15:10:35',NULL),('2026-01-20 15:10:35','2026-01-20 15:10:35','2026-01-20 15:10:35',1,464,'72e8923d-d4a4-4942-9447-2595d78d7588',122,'fc74c4a296554866969b05aef75252af','gigabytes___DEFAULT__',-1,'2026-01-21 15:10:35',NULL),('2026-01-20 15:10:36','2026-01-20 15:10:36','2026-01-20 15:10:36',1,465,'11676ec3-fdab-4868-b8ca-fc40ec8e051f',119,'fc74c4a296554866969b05aef75252af','volumes',-1,'2026-01-21 15:10:36',NULL),('2026-01-20 15:10:36','2026-01-20 15:10:36','2026-01-20 15:10:36',1,466,'465cebfa-aca2-46a3-b912-f2a3597301c9',120,'fc74c4a296554866969b05aef75252af','gigabytes',-1,'2026-01-21 15:10:36',NULL),('2026-01-20 15:10:36','2026-01-20 15:10:36','2026-01-20 15:10:36',1,467,'03a10236-a430-4a4c-bb0d-b2c676261a03',121,'fc74c4a296554866969b05aef75252af','volumes___DEFAULT__',-1,'2026-01-21 15:10:36',NULL),('2026-01-20 15:10:36','2026-01-20 15:10:36','2026-01-20 15:10:36',1,468,'20a9c68f-64ae-4f0e-be72-919c75bd6294',122,'fc74c4a296554866969b05aef75252af','gigabytes___DEFAULT__',-1,'2026-01-21 15:10:36',NULL),('2026-01-20 15:10:37','2026-01-20 15:10:37','2026-01-20 15:10:37',1,469,'ae7540c9-3f85-4cae-bb8e-5188c49befd8',135,'a49638950e1543fa8e0d251af5479623','snapshots',1,'2026-01-21 15:10:37',NULL),('2026-01-20 15:10:37','2026-01-20 15:10:37','2026-01-20 15:10:37',1,470,'e3bf9233-4777-4e21-8408-0442d2cab7dc',130,'a49638950e1543fa8e0d251af5479623','gigabytes',1,'2026-01-21 15:10:37',NULL),('2026-01-20 15:10:37','2026-01-20 15:10:37','2026-01-20 15:10:37',1,471,'a0966d1c-3208-48b6-bd4b-a4174c09ae03',134,'a49638950e1543fa8e0d251af5479623','gigabytes___DEFAULT__',1,'2026-01-21 15:10:37',NULL),('2026-01-20 15:10:37','2026-01-20 15:10:37','2026-01-20 15:10:37',1,472,'4ab1a111-ae94-4260-9a86-182565f4a7ff',136,'a49638950e1543fa8e0d251af5479623','snapshots___DEFAULT__',1,'2026-01-21 15:10:37',NULL),('2026-01-20 15:10:44','2026-01-20 15:10:45','2026-01-20 15:10:45',1,473,'474882a6-2e39-4d49-b55e-17a73c8ed641',129,'a49638950e1543fa8e0d251af5479623','volumes',1,'2026-01-21 15:10:44',NULL),('2026-01-20 15:10:44','2026-01-20 15:10:45','2026-01-20 15:10:45',1,474,'a671afbb-b232-4682-bbde-95bbe7990aec',130,'a49638950e1543fa8e0d251af5479623','gigabytes',1,'2026-01-21 15:10:44',NULL),('2026-01-20 15:10:44','2026-01-20 15:10:45','2026-01-20 15:10:45',1,475,'ef96e259-cdb3-49ed-8f89-3e8050a80507',133,'a49638950e1543fa8e0d251af5479623','volumes___DEFAULT__',1,'2026-01-21 15:10:44',NULL),('2026-01-20 15:10:44','2026-01-20 15:10:45','2026-01-20 15:10:45',1,476,'95e39067-274c-4f71-9266-59d3f7526f84',134,'a49638950e1543fa8e0d251af5479623','gigabytes___DEFAULT__',1,'2026-01-21 15:10:44',NULL),('2026-01-20 15:10:58','2026-01-20 15:10:58','2026-01-20 15:10:58',1,477,'99d92e48-d971-4459-8664-9ca8d8dbcb5b',129,'a49638950e1543fa8e0d251af5479623','volumes',-1,'2026-01-21 15:10:58',NULL),('2026-01-20 15:10:58','2026-01-20 15:10:58','2026-01-20 15:10:58',1,478,'291bb445-0ffe-406e-975f-24aaac5b029a',130,'a49638950e1543fa8e0d251af5479623','gigabytes',-1,'2026-01-21 15:10:58',NULL),('2026-01-20 15:10:58','2026-01-20 15:10:58','2026-01-20 15:10:58',1,479,'1b185fba-8c4d-4528-b27c-22c34ad238c6',133,'a49638950e1543fa8e0d251af5479623','volumes___DEFAULT__',-1,'2026-01-21 15:10:58',NULL),('2026-01-20 15:10:58','2026-01-20 15:10:58','2026-01-20 15:10:58',1,480,'256080ed-f073-43a0-90e7-7147fb19fe31',134,'a49638950e1543fa8e0d251af5479623','gigabytes___DEFAULT__',-1,'2026-01-21 15:10:58',NULL),('2026-01-20 15:11:00','2026-01-20 15:11:00','2026-01-20 15:11:00',1,481,'5de38770-1aa0-4971-8ccf-0e600824c01d',135,'a49638950e1543fa8e0d251af5479623','snapshots',-1,'2026-01-21 15:11:00',NULL),('2026-01-20 15:11:00','2026-01-20 15:11:00','2026-01-20 15:11:00',1,482,'c786f59c-4b4a-4140-8e86-62b8d214c80a',130,'a49638950e1543fa8e0d251af5479623','gigabytes',-1,'2026-01-21 15:11:00',NULL),('2026-01-20 15:11:00','2026-01-20 15:11:00','2026-01-20 15:11:00',1,483,'bebd366b-8778-4a13-bc05-1beb839918c1',134,'a49638950e1543fa8e0d251af5479623','gigabytes___DEFAULT__',-1,'2026-01-21 15:11:00',NULL),('2026-01-20 15:11:00','2026-01-20 15:11:00','2026-01-20 15:11:00',1,484,'84b62894-86db-470e-9e17-6eff9fec9374',136,'a49638950e1543fa8e0d251af5479623','snapshots___DEFAULT__',-1,'2026-01-21 15:11:00',NULL),('2026-01-20 15:11:01','2026-01-20 15:11:01','2026-01-20 15:11:01',1,485,'b1d067f6-7f88-4bf5-8e4d-06e3b5335259',129,'a49638950e1543fa8e0d251af5479623','volumes',-1,'2026-01-21 15:11:01',NULL),('2026-01-20 15:11:01','2026-01-20 15:11:01','2026-01-20 15:11:01',1,486,'24a4fb56-1516-4e16-a870-1c3d69d0a24b',130,'a49638950e1543fa8e0d251af5479623','gigabytes',-1,'2026-01-21 15:11:01',NULL),('2026-01-20 15:11:01','2026-01-20 15:11:01','2026-01-20 15:11:01',1,487,'935c1f1b-3287-44bc-8771-1b5c94901de3',133,'a49638950e1543fa8e0d251af5479623','volumes___DEFAULT__',-1,'2026-01-21 15:11:01',NULL),('2026-01-20 15:11:01','2026-01-20 15:11:01','2026-01-20 15:11:01',1,488,'25f89014-142f-477e-ad84-2e40ccb3fce9',134,'a49638950e1543fa8e0d251af5479623','gigabytes___DEFAULT__',-1,'2026-01-21 15:11:01',NULL),('2026-01-20 15:11:03','2026-01-20 15:11:03','2026-01-20 15:11:03',1,489,'05de44c0-0f8c-44d5-bc3f-b735ec70ec87',129,'a49638950e1543fa8e0d251af5479623','volumes',1,'2026-01-21 15:11:03',NULL),('2026-01-20 15:11:03','2026-01-20 15:11:03','2026-01-20 15:11:03',1,490,'b9b382c5-1237-431e-8372-9821139d350d',130,'a49638950e1543fa8e0d251af5479623','gigabytes',1,'2026-01-21 15:11:03',NULL),('2026-01-20 15:11:03','2026-01-20 15:11:03','2026-01-20 15:11:03',1,491,'628da57b-97d3-4320-88ed-d540bd0921a5',133,'a49638950e1543fa8e0d251af5479623','volumes___DEFAULT__',1,'2026-01-21 15:11:03',NULL),('2026-01-20 15:11:03','2026-01-20 15:11:03','2026-01-20 15:11:03',1,492,'41b83e45-b009-4db7-b627-eb5dade5c531',134,'a49638950e1543fa8e0d251af5479623','gigabytes___DEFAULT__',1,'2026-01-21 15:11:03',NULL),('2026-01-20 15:11:15','2026-01-20 15:11:15','2026-01-20 15:11:15',1,493,'b7045643-ecc4-4ca4-87d4-e9f644fa69d3',123,'5b43342be22543f79d4a56e26c6d0c96','volumes',-1,'2026-01-21 15:11:15',NULL),('2026-01-20 15:11:15','2026-01-20 15:11:15','2026-01-20 15:11:15',1,494,'00366bea-7b93-4a3c-b837-fe7d08a48b52',124,'5b43342be22543f79d4a56e26c6d0c96','gigabytes',-1,'2026-01-21 15:11:15',NULL),('2026-01-20 15:11:15','2026-01-20 15:11:15','2026-01-20 15:11:15',1,495,'97910429-0e5f-40cf-b0c1-a707e1269e04',125,'5b43342be22543f79d4a56e26c6d0c96','volumes___DEFAULT__',-1,'2026-01-21 15:11:15',NULL),('2026-01-20 15:11:15','2026-01-20 15:11:15','2026-01-20 15:11:15',1,496,'fa20c48f-efc0-40d8-b422-67cb28225cf6',126,'5b43342be22543f79d4a56e26c6d0c96','gigabytes___DEFAULT__',-1,'2026-01-21 15:11:15',NULL),('2026-01-20 15:11:45','2026-01-20 15:11:45','2026-01-20 15:11:45',1,497,'70ddf9ce-586c-4631-975a-5a3491f8d878',135,'a49638950e1543fa8e0d251af5479623','snapshots',1,'2026-01-21 15:11:45',NULL),('2026-01-20 15:11:45','2026-01-20 15:11:45','2026-01-20 15:11:45',1,498,'2aa5955f-2acc-4473-a828-ee47fc34af44',130,'a49638950e1543fa8e0d251af5479623','gigabytes',1,'2026-01-21 15:11:45',NULL),('2026-01-20 15:11:45','2026-01-20 15:11:45','2026-01-20 15:11:45',1,499,'a15f5779-c2f7-4128-a1cb-f3802973bedb',134,'a49638950e1543fa8e0d251af5479623','gigabytes___DEFAULT__',1,'2026-01-21 15:11:45',NULL),('2026-01-20 15:11:45','2026-01-20 15:11:45','2026-01-20 15:11:45',1,500,'5102282e-23fd-4a9b-af91-c846114670fa',136,'a49638950e1543fa8e0d251af5479623','snapshots___DEFAULT__',1,'2026-01-21 15:11:45',NULL),('2026-01-20 15:11:54','2026-01-20 15:11:54','2026-01-20 15:11:54',1,501,'0c68fa75-df19-4aee-9e2d-9e937e38b27b',129,'a49638950e1543fa8e0d251af5479623','volumes',1,'2026-01-21 15:11:54',NULL),('2026-01-20 15:11:54','2026-01-20 15:11:54','2026-01-20 15:11:54',1,502,'66200b9b-8867-44b0-b614-c3f488936723',130,'a49638950e1543fa8e0d251af5479623','gigabytes',1,'2026-01-21 15:11:54',NULL),('2026-01-20 15:11:54','2026-01-20 15:11:54','2026-01-20 15:11:54',1,503,'5135a961-70a9-4f15-903c-02334c1a294a',133,'a49638950e1543fa8e0d251af5479623','volumes___DEFAULT__',1,'2026-01-21 15:11:54',NULL),('2026-01-20 15:11:54','2026-01-20 15:11:54','2026-01-20 15:11:54',1,504,'ccedf42b-04f8-45cb-b205-59324b340161',134,'a49638950e1543fa8e0d251af5479623','gigabytes___DEFAULT__',1,'2026-01-21 15:11:54',NULL),('2026-01-20 15:12:35','2026-01-20 15:12:36','2026-01-20 15:12:36',1,505,'30d3f818-54b9-4e93-9e4a-2659155e9932',129,'a49638950e1543fa8e0d251af5479623','volumes',-1,'2026-01-21 15:12:35',NULL),('2026-01-20 15:12:35','2026-01-20 15:12:36','2026-01-20 15:12:36',1,506,'42ddd82d-8d4e-423f-a3c3-8df3ed24232e',130,'a49638950e1543fa8e0d251af5479623','gigabytes',-1,'2026-01-21 15:12:35',NULL),('2026-01-20 15:12:35','2026-01-20 15:12:36','2026-01-20 15:12:36',1,507,'15f5050b-4386-4f24-8ba2-c13613155abc',133,'a49638950e1543fa8e0d251af5479623','volumes___DEFAULT__',-1,'2026-01-21 15:12:35',NULL),('2026-01-20 15:12:35','2026-01-20 15:12:36','2026-01-20 15:12:36',1,508,'f18da717-da86-4ebf-8eb2-d95371554b57',134,'a49638950e1543fa8e0d251af5479623','gigabytes___DEFAULT__',-1,'2026-01-21 15:12:35',NULL),('2026-01-20 15:12:38','2026-01-20 15:12:38','2026-01-20 15:12:38',1,509,'20be9bd5-cc5c-4b00-b8a9-b42341c3e4b4',135,'a49638950e1543fa8e0d251af5479623','snapshots',-1,'2026-01-21 15:12:38',NULL),('2026-01-20 15:12:38','2026-01-20 15:12:38','2026-01-20 15:12:38',1,510,'f898294d-e2da-48de-8a1e-ef6669c0b59d',130,'a49638950e1543fa8e0d251af5479623','gigabytes',-1,'2026-01-21 15:12:38',NULL),('2026-01-20 15:12:38','2026-01-20 15:12:38','2026-01-20 15:12:38',1,511,'1f202235-3455-4d85-b369-4c2bd80f11ec',134,'a49638950e1543fa8e0d251af5479623','gigabytes___DEFAULT__',-1,'2026-01-21 15:12:38',NULL),('2026-01-20 15:12:38','2026-01-20 15:12:38','2026-01-20 15:12:38',1,512,'5d51e972-c05b-41c9-92eb-72ceed336692',136,'a49638950e1543fa8e0d251af5479623','snapshots___DEFAULT__',-1,'2026-01-21 15:12:38',NULL),('2026-01-20 15:12:43','2026-01-20 15:12:43','2026-01-20 15:12:43',1,513,'897ed685-09a6-4cb4-ba66-4a8a74f80f83',129,'a49638950e1543fa8e0d251af5479623','volumes',-1,'2026-01-21 15:12:43',NULL),('2026-01-20 15:12:43','2026-01-20 15:12:43','2026-01-20 15:12:43',1,514,'7d6a6f26-8edf-469e-bcd5-b9b1955cef2d',130,'a49638950e1543fa8e0d251af5479623','gigabytes',-1,'2026-01-21 15:12:43',NULL),('2026-01-20 15:12:43','2026-01-20 15:12:43','2026-01-20 15:12:43',1,515,'de6ab054-2756-4f13-a859-9abb09e5d794',133,'a49638950e1543fa8e0d251af5479623','volumes___DEFAULT__',-1,'2026-01-21 15:12:43',NULL),('2026-01-20 15:12:43','2026-01-20 15:12:43','2026-01-20 15:12:43',1,516,'8b9eb00e-1e2f-4a22-8322-a39546495f33',134,'a49638950e1543fa8e0d251af5479623','gigabytes___DEFAULT__',-1,'2026-01-21 15:12:43',NULL),('2026-01-20 15:12:56','2026-01-20 15:12:56','2026-01-20 15:12:56',1,517,'c7f7e22a-509a-440b-9839-94424763b8ac',129,'a49638950e1543fa8e0d251af5479623','volumes',1,'2026-01-21 15:12:56',NULL),('2026-01-20 15:12:56','2026-01-20 15:12:56','2026-01-20 15:12:56',1,518,'e842df7e-39fe-4d0f-99d1-7dea3ffad890',130,'a49638950e1543fa8e0d251af5479623','gigabytes',1,'2026-01-21 15:12:56',NULL),('2026-01-20 15:12:56','2026-01-20 15:12:56','2026-01-20 15:12:56',1,519,'34b443d8-78f3-4d44-b729-384d3f8684b4',133,'a49638950e1543fa8e0d251af5479623','volumes___DEFAULT__',1,'2026-01-21 15:12:56',NULL),('2026-01-20 15:12:56','2026-01-20 15:12:56','2026-01-20 15:12:56',1,520,'2f9093c8-644c-4097-a25f-6a565f900a8e',134,'a49638950e1543fa8e0d251af5479623','gigabytes___DEFAULT__',1,'2026-01-21 15:12:56',NULL),('2026-01-20 15:13:10','2026-01-20 15:13:10','2026-01-20 15:13:10',1,521,'48762b9f-2230-4c85-9e77-2458b93b2031',137,'fff727019f86407498e83d7948d54962','volumes',1,'2026-01-21 15:13:10',NULL),('2026-01-20 15:13:10','2026-01-20 15:13:10','2026-01-20 15:13:10',1,522,'38309970-3ee1-4d2d-8504-f6d4e9eda7ff',138,'fff727019f86407498e83d7948d54962','gigabytes',1,'2026-01-21 15:13:10',NULL),('2026-01-20 15:13:10','2026-01-20 15:13:10','2026-01-20 15:13:10',1,523,'cded015f-8251-491a-9768-1f8c828dd417',139,'fff727019f86407498e83d7948d54962','volumes_multiattach',1,'2026-01-21 15:13:10',NULL),('2026-01-20 15:13:10','2026-01-20 15:13:10','2026-01-20 15:13:10',1,524,'ac779e00-7bb2-48f6-b698-87aaa9681314',140,'fff727019f86407498e83d7948d54962','gigabytes_multiattach',1,'2026-01-21 15:13:10',NULL),('2026-01-20 15:14:11','2026-01-20 15:14:11','2026-01-20 15:14:11',1,525,'99303b40-febe-457e-b356-7bc8dc67857e',137,'fff727019f86407498e83d7948d54962','volumes',1,'2026-01-21 15:14:11',NULL),('2026-01-20 15:14:11','2026-01-20 15:14:11','2026-01-20 15:14:11',1,526,'58190e7b-55a1-434e-afa4-a5876f28219c',138,'fff727019f86407498e83d7948d54962','gigabytes',1,'2026-01-21 15:14:11',NULL),('2026-01-20 15:14:11','2026-01-20 15:14:11','2026-01-20 15:14:11',1,527,'d5626214-1d87-4081-9dfb-292f472d7ed8',139,'fff727019f86407498e83d7948d54962','volumes_multiattach',1,'2026-01-21 15:14:11',NULL),('2026-01-20 15:14:11','2026-01-20 15:14:11','2026-01-20 15:14:11',1,528,'b462014a-c0db-42c4-824f-89f9749d96da',140,'fff727019f86407498e83d7948d54962','gigabytes_multiattach',1,'2026-01-21 15:14:11',NULL),('2026-01-20 15:14:30','2026-01-20 15:14:31','2026-01-20 15:14:31',1,529,'f2fac4e8-5acc-4ba4-8152-db5821306e5a',135,'a49638950e1543fa8e0d251af5479623','snapshots',1,'2026-01-21 15:14:30',NULL),('2026-01-20 15:14:30','2026-01-20 15:14:31','2026-01-20 15:14:31',1,530,'8e0ac1b9-7c9a-4ea8-8d50-f445f541aa36',130,'a49638950e1543fa8e0d251af5479623','gigabytes',1,'2026-01-21 15:14:30',NULL),('2026-01-20 15:14:30','2026-01-20 15:14:31','2026-01-20 15:14:31',1,531,'634d489d-d25d-49d6-a3a5-3840a18cb339',134,'a49638950e1543fa8e0d251af5479623','gigabytes___DEFAULT__',1,'2026-01-21 15:14:30',NULL),('2026-01-20 15:14:30','2026-01-20 15:14:31','2026-01-20 15:14:31',1,532,'55ed1a1e-b218-412d-b261-18eea2fd01c9',136,'a49638950e1543fa8e0d251af5479623','snapshots___DEFAULT__',1,'2026-01-21 15:14:30',NULL),('2026-01-20 15:14:32','2026-01-20 15:14:32','2026-01-20 15:14:32',1,533,'53101c21-f4bd-4e20-95bb-db3190a51ad3',129,'a49638950e1543fa8e0d251af5479623','volumes',1,'2026-01-21 15:14:32',NULL),('2026-01-20 15:14:32','2026-01-20 15:14:32','2026-01-20 15:14:32',1,534,'c0bc4261-0df5-4eb7-bfc7-f03004827067',130,'a49638950e1543fa8e0d251af5479623','gigabytes',1,'2026-01-21 15:14:32',NULL),('2026-01-20 15:14:32','2026-01-20 15:14:32','2026-01-20 15:14:32',1,535,'8b90ce99-9284-4e5c-b328-1b6045a75ee4',133,'a49638950e1543fa8e0d251af5479623','volumes___DEFAULT__',1,'2026-01-21 15:14:32',NULL),('2026-01-20 15:14:32','2026-01-20 15:14:32','2026-01-20 15:14:32',1,536,'a84e3f6d-2141-432d-9c7c-80eda45be66a',134,'a49638950e1543fa8e0d251af5479623','gigabytes___DEFAULT__',1,'2026-01-21 15:14:32',NULL),('2026-01-20 15:15:04','2026-01-20 15:15:05','2026-01-20 15:15:05',1,537,'b4f13fba-37e1-4760-8221-6d241e5e1a46',137,'fff727019f86407498e83d7948d54962','volumes',1,'2026-01-21 15:15:04',NULL),('2026-01-20 15:15:04','2026-01-20 15:15:05','2026-01-20 15:15:05',1,538,'de6e6b11-e027-47a8-b12b-0ca79c80c28f',138,'fff727019f86407498e83d7948d54962','gigabytes',1,'2026-01-21 15:15:04',NULL),('2026-01-20 15:15:04','2026-01-20 15:15:05','2026-01-20 15:15:05',1,539,'641020fc-4f3b-4eae-9230-0e1bacbbb6b9',139,'fff727019f86407498e83d7948d54962','volumes_multiattach',1,'2026-01-21 15:15:04',NULL),('2026-01-20 15:15:04','2026-01-20 15:15:05','2026-01-20 15:15:05',1,540,'0d32a274-5896-4f69-a368-3714db80e314',140,'fff727019f86407498e83d7948d54962','gigabytes_multiattach',1,'2026-01-21 15:15:04',NULL),('2026-01-20 15:15:35','2026-01-20 15:15:35','2026-01-20 15:15:35',1,541,'9776c613-acdd-457d-a248-f0c24e608e20',129,'a49638950e1543fa8e0d251af5479623','volumes',-1,'2026-01-21 15:15:35',NULL),('2026-01-20 15:15:35','2026-01-20 15:15:35','2026-01-20 15:15:35',1,542,'8047b3ce-3b05-4a1e-886b-32fa64a184cb',130,'a49638950e1543fa8e0d251af5479623','gigabytes',-1,'2026-01-21 15:15:35',NULL),('2026-01-20 15:15:35','2026-01-20 15:15:35','2026-01-20 15:15:35',1,543,'3ff96f36-b029-4301-9815-36d0fef65b2f',133,'a49638950e1543fa8e0d251af5479623','volumes___DEFAULT__',-1,'2026-01-21 15:15:35',NULL),('2026-01-20 15:15:35','2026-01-20 15:15:35','2026-01-20 15:15:35',1,544,'03f47b09-0476-4a2d-b091-3187cc491679',134,'a49638950e1543fa8e0d251af5479623','gigabytes___DEFAULT__',-1,'2026-01-21 15:15:35',NULL),('2026-01-20 15:15:38','2026-01-20 15:15:38','2026-01-20 15:15:38',1,545,'5e4ec60d-f5fd-41a5-8f46-731e286f9e07',135,'a49638950e1543fa8e0d251af5479623','snapshots',-1,'2026-01-21 15:15:38',NULL),('2026-01-20 15:15:38','2026-01-20 15:15:38','2026-01-20 15:15:38',1,546,'0a777bf8-3770-460e-89e0-31d64ff7f124',130,'a49638950e1543fa8e0d251af5479623','gigabytes',-1,'2026-01-21 15:15:38',NULL),('2026-01-20 15:15:38','2026-01-20 15:15:38','2026-01-20 15:15:38',1,547,'6cb99ffe-bcd4-4a95-8e3c-0f00acd48683',134,'a49638950e1543fa8e0d251af5479623','gigabytes___DEFAULT__',-1,'2026-01-21 15:15:38',NULL),('2026-01-20 15:15:38','2026-01-20 15:15:38','2026-01-20 15:15:38',1,548,'1e8e7e03-feb1-4f9f-8a2a-4c6ba3051b13',136,'a49638950e1543fa8e0d251af5479623','snapshots___DEFAULT__',-1,'2026-01-21 15:15:38',NULL),('2026-01-20 15:15:46','2026-01-20 15:15:46','2026-01-20 15:15:46',1,549,'6f73ad7f-b955-441d-9cc7-04fa04610f9c',129,'a49638950e1543fa8e0d251af5479623','volumes',-1,'2026-01-21 15:15:46',NULL),('2026-01-20 15:15:46','2026-01-20 15:15:46','2026-01-20 15:15:46',1,550,'4a343ec7-2c9d-43b8-b47e-5a13e9ac0910',130,'a49638950e1543fa8e0d251af5479623','gigabytes',-1,'2026-01-21 15:15:46',NULL),('2026-01-20 15:15:46','2026-01-20 15:15:46','2026-01-20 15:15:46',1,551,'4ca6b818-c5fa-4aec-88a1-3b5feec00d99',133,'a49638950e1543fa8e0d251af5479623','volumes___DEFAULT__',-1,'2026-01-21 15:15:46',NULL),('2026-01-20 15:15:46','2026-01-20 15:15:46','2026-01-20 15:15:46',1,552,'daa0bc51-bc93-40c7-baab-302ddf827111',134,'a49638950e1543fa8e0d251af5479623','gigabytes___DEFAULT__',-1,'2026-01-21 15:15:46',NULL),('2026-01-20 15:16:52','2026-01-20 15:16:53','2026-01-20 15:16:53',1,553,'8ff9fed0-f6a8-4db7-a208-03f7feff65c2',137,'fff727019f86407498e83d7948d54962','volumes',1,'2026-01-21 15:16:52',NULL),('2026-01-20 15:16:52','2026-01-20 15:16:53','2026-01-20 15:16:53',1,554,'ec742b49-adbe-4b54-bd6f-f11a80111e13',138,'fff727019f86407498e83d7948d54962','gigabytes',1,'2026-01-21 15:16:52',NULL),('2026-01-20 15:16:52','2026-01-20 15:16:53','2026-01-20 15:16:53',1,555,'8d7cbce4-d6d6-4a26-88c1-e05b24dc8029',139,'fff727019f86407498e83d7948d54962','volumes_multiattach',1,'2026-01-21 15:16:52',NULL),('2026-01-20 15:16:52','2026-01-20 15:16:53','2026-01-20 15:16:53',1,556,'f897ba24-50cf-40c3-aa19-0a833498d868',140,'fff727019f86407498e83d7948d54962','gigabytes_multiattach',1,'2026-01-21 15:16:52',NULL),('2026-01-20 15:17:14','2026-01-20 15:17:14','2026-01-20 15:17:14',1,557,'e5281abe-2135-418a-ae9b-82102978de4c',141,'fff727019f86407498e83d7948d54962','snapshots',1,'2026-01-21 15:17:14',NULL),('2026-01-20 15:17:14','2026-01-20 15:17:14','2026-01-20 15:17:14',1,558,'9ec07b30-303f-4dc6-83ab-20a545c7b861',138,'fff727019f86407498e83d7948d54962','gigabytes',1,'2026-01-21 15:17:14',NULL),('2026-01-20 15:17:14','2026-01-20 15:17:14','2026-01-20 15:17:14',1,559,'9cb6e509-1a64-446b-a586-88696d500883',140,'fff727019f86407498e83d7948d54962','gigabytes_multiattach',1,'2026-01-21 15:17:14',NULL),('2026-01-20 15:17:14','2026-01-20 15:17:14','2026-01-20 15:17:14',1,560,'35d0ef14-6cec-4729-b877-d5a1bd7085fb',142,'fff727019f86407498e83d7948d54962','snapshots_multiattach',1,'2026-01-21 15:17:14',NULL),('2026-01-20 15:17:25','2026-01-20 15:17:25','2026-01-20 15:17:25',1,561,'83b35652-3030-4bf6-afe0-2eeb05377dec',141,'fff727019f86407498e83d7948d54962','snapshots',-1,'2026-01-21 15:17:25',NULL),('2026-01-20 15:17:25','2026-01-20 15:17:25','2026-01-20 15:17:25',1,562,'e62d5d63-f590-46fc-aff6-88eab539c1ea',138,'fff727019f86407498e83d7948d54962','gigabytes',-1,'2026-01-21 15:17:25',NULL),('2026-01-20 15:17:25','2026-01-20 15:17:25','2026-01-20 15:17:25',1,563,'7cb1f555-131d-48a4-a0d1-c9a9a8fdf9a3',140,'fff727019f86407498e83d7948d54962','gigabytes_multiattach',-1,'2026-01-21 15:17:25',NULL),('2026-01-20 15:17:25','2026-01-20 15:17:25','2026-01-20 15:17:25',1,564,'12325ed9-b1cf-455c-960b-d3f2d03a2752',142,'fff727019f86407498e83d7948d54962','snapshots_multiattach',-1,'2026-01-21 15:17:25',NULL),('2026-01-20 15:17:26','2026-01-20 15:17:26','2026-01-20 15:17:26',1,565,'46ee63e5-5e1d-4725-bd4f-84ee5a835e30',137,'fff727019f86407498e83d7948d54962','volumes',-1,'2026-01-21 15:17:26',NULL),('2026-01-20 15:17:26','2026-01-20 15:17:26','2026-01-20 15:17:26',1,566,'90a58bc1-5661-4223-ace3-f9f31c955191',138,'fff727019f86407498e83d7948d54962','gigabytes',-1,'2026-01-21 15:17:26',NULL),('2026-01-20 15:17:26','2026-01-20 15:17:26','2026-01-20 15:17:26',1,567,'59a850aa-b900-4ea7-8941-1705baf9f179',139,'fff727019f86407498e83d7948d54962','volumes_multiattach',-1,'2026-01-21 15:17:26',NULL),('2026-01-20 15:17:26','2026-01-20 15:17:26','2026-01-20 15:17:26',1,568,'29a4d5a9-7084-47a9-98b0-6c2bece778a2',140,'fff727019f86407498e83d7948d54962','gigabytes_multiattach',-1,'2026-01-21 15:17:26',NULL),('2026-01-20 15:17:28','2026-01-20 15:17:28','2026-01-20 15:17:28',1,569,'7e0d5e92-5a69-43e3-9559-2b448af7d26b',137,'fff727019f86407498e83d7948d54962','volumes',-1,'2026-01-21 15:17:28',NULL),('2026-01-20 15:17:28','2026-01-20 15:17:28','2026-01-20 15:17:28',1,570,'43e2e8a9-a3b9-458d-b44d-bece1dc7b401',138,'fff727019f86407498e83d7948d54962','gigabytes',-1,'2026-01-21 15:17:28',NULL),('2026-01-20 15:17:28','2026-01-20 15:17:28','2026-01-20 15:17:28',1,571,'19472479-80a7-4491-abf0-6d73623a8d4e',139,'fff727019f86407498e83d7948d54962','volumes_multiattach',-1,'2026-01-21 15:17:28',NULL),('2026-01-20 15:17:28','2026-01-20 15:17:28','2026-01-20 15:17:28',1,572,'2ea1ce92-a465-4fb5-a084-57382eeaf01b',140,'fff727019f86407498e83d7948d54962','gigabytes_multiattach',-1,'2026-01-21 15:17:28',NULL),('2026-01-20 15:17:36','2026-01-20 15:17:36','2026-01-20 15:17:36',1,573,'2627f61d-af7a-47b5-8d8f-9c36ea694866',137,'fff727019f86407498e83d7948d54962','volumes',-1,'2026-01-21 15:17:36',NULL),('2026-01-20 15:17:36','2026-01-20 15:17:36','2026-01-20 15:17:36',1,574,'6e28a871-652b-4319-8be3-7a3e0c350e2b',138,'fff727019f86407498e83d7948d54962','gigabytes',-1,'2026-01-21 15:17:36',NULL),('2026-01-20 15:17:36','2026-01-20 15:17:36','2026-01-20 15:17:36',1,575,'e232bc01-885e-441c-b511-a76e7a26cf50',139,'fff727019f86407498e83d7948d54962','volumes_multiattach',-1,'2026-01-21 15:17:36',NULL),('2026-01-20 15:17:36','2026-01-20 15:17:36','2026-01-20 15:17:36',1,576,'3139396f-0d99-4887-99e1-0773a4a2ba06',140,'fff727019f86407498e83d7948d54962','gigabytes_multiattach',-1,'2026-01-21 15:17:36',NULL),('2026-01-20 15:17:54','2026-01-20 15:17:54','2026-01-20 15:17:54',1,577,'9871cb9e-3bf1-425b-9239-27b6421d7f0c',137,'fff727019f86407498e83d7948d54962','volumes',-1,'2026-01-21 15:17:54',NULL),('2026-01-20 15:17:54','2026-01-20 15:17:54','2026-01-20 15:17:54',1,578,'38aad17a-230b-4684-af8c-c23282195403',138,'fff727019f86407498e83d7948d54962','gigabytes',-1,'2026-01-21 15:17:54',NULL),('2026-01-20 15:17:54','2026-01-20 15:17:54','2026-01-20 15:17:54',1,579,'a619c3ff-1444-4aed-ab30-818ed473e3ae',139,'fff727019f86407498e83d7948d54962','volumes_multiattach',-1,'2026-01-21 15:17:54',NULL),('2026-01-20 15:17:54','2026-01-20 15:17:54','2026-01-20 15:17:54',1,580,'460f025a-55a3-40a0-8aa7-1fb47e7b45f2',140,'fff727019f86407498e83d7948d54962','gigabytes_multiattach',-1,'2026-01-21 15:17:54',NULL),('2026-01-20 15:19:05','2026-01-20 15:19:05','2026-01-20 15:19:05',1,581,'3b080690-b735-4c50-badf-17ccff61911f',143,'9156c0a9920c4721843416b9a44404f9','volumes',1,'2026-01-21 15:19:05',NULL),('2026-01-20 15:19:05','2026-01-20 15:19:05','2026-01-20 15:19:05',1,582,'f2654b8f-d2f3-4af4-b7f2-72e7ac829eda',144,'9156c0a9920c4721843416b9a44404f9','gigabytes',1,'2026-01-21 15:19:05',NULL),('2026-01-20 15:19:05','2026-01-20 15:19:05','2026-01-20 15:19:05',1,583,'36405daf-119d-447e-9c30-75f34b4f3760',145,'9156c0a9920c4721843416b9a44404f9','volumes___DEFAULT__',1,'2026-01-21 15:19:05',NULL),('2026-01-20 15:19:05','2026-01-20 15:19:05','2026-01-20 15:19:05',1,584,'60166fec-2285-4eab-a3b8-384562861f9b',146,'9156c0a9920c4721843416b9a44404f9','gigabytes___DEFAULT__',1,'2026-01-21 15:19:05',NULL),('2026-01-20 15:20:57','2026-01-20 15:20:57','2026-01-20 15:20:57',1,585,'bc4c2489-627f-4d21-aa25-3b16813284ac',143,'9156c0a9920c4721843416b9a44404f9','volumes',1,'2026-01-21 15:20:57',NULL),('2026-01-20 15:20:57','2026-01-20 15:20:57','2026-01-20 15:20:57',1,586,'f440e6c0-ead5-427f-8fc0-785fec0de404',144,'9156c0a9920c4721843416b9a44404f9','gigabytes',1,'2026-01-21 15:20:57',NULL),('2026-01-20 15:20:57','2026-01-20 15:20:57','2026-01-20 15:20:57',1,587,'e2070e27-01e5-4973-ac0e-3e68fd1967b1',145,'9156c0a9920c4721843416b9a44404f9','volumes___DEFAULT__',1,'2026-01-21 15:20:57',NULL),('2026-01-20 15:20:57','2026-01-20 15:20:57','2026-01-20 15:20:57',1,588,'26dcaa5d-66b1-47e2-a070-c2427465ea1c',146,'9156c0a9920c4721843416b9a44404f9','gigabytes___DEFAULT__',1,'2026-01-21 15:20:57',NULL),('2026-01-20 15:22:00','2026-01-20 15:22:01','2026-01-20 15:22:01',1,589,'a390d9b1-d23f-4f79-8cc0-c216edff4b96',143,'9156c0a9920c4721843416b9a44404f9','volumes',1,'2026-01-21 15:22:00',NULL),('2026-01-20 15:22:00','2026-01-20 15:22:01','2026-01-20 15:22:01',1,590,'5688977e-3406-4308-b03f-d3027d68ee2e',144,'9156c0a9920c4721843416b9a44404f9','gigabytes',1,'2026-01-21 15:22:00',NULL),('2026-01-20 15:22:00','2026-01-20 15:22:01','2026-01-20 15:22:01',1,591,'52fd4259-0350-4c0b-aae7-fb047f699b61',145,'9156c0a9920c4721843416b9a44404f9','volumes___DEFAULT__',1,'2026-01-21 15:22:00',NULL),('2026-01-20 15:22:00','2026-01-20 15:22:01','2026-01-20 15:22:01',1,592,'5c26bc67-a2f6-4079-ab84-5de98fa7c56a',146,'9156c0a9920c4721843416b9a44404f9','gigabytes___DEFAULT__',1,'2026-01-21 15:22:00',NULL),('2026-01-20 15:22:13','2026-01-20 15:22:13','2026-01-20 15:22:13',1,593,'968eeeb0-b975-414b-867c-0ea8ec0e86b4',143,'9156c0a9920c4721843416b9a44404f9','volumes',-1,'2026-01-21 15:22:13',NULL),('2026-01-20 15:22:13','2026-01-20 15:22:13','2026-01-20 15:22:13',1,594,'88809d02-23c7-41d2-94e1-f41c9f1b499e',144,'9156c0a9920c4721843416b9a44404f9','gigabytes',-1,'2026-01-21 15:22:13',NULL),('2026-01-20 15:22:13','2026-01-20 15:22:13','2026-01-20 15:22:13',1,595,'bd2f0b53-ae33-47ba-bfbe-3a0cbd6898f9',145,'9156c0a9920c4721843416b9a44404f9','volumes___DEFAULT__',-1,'2026-01-21 15:22:13',NULL),('2026-01-20 15:22:13','2026-01-20 15:22:13','2026-01-20 15:22:13',1,596,'a3214b02-654a-45f9-9574-dc3489a72bbf',146,'9156c0a9920c4721843416b9a44404f9','gigabytes___DEFAULT__',-1,'2026-01-21 15:22:13',NULL),('2026-01-20 15:22:14','2026-01-20 15:22:14','2026-01-20 15:22:14',1,597,'10df22ef-2a31-4d42-a564-6d5243ca3fbd',143,'9156c0a9920c4721843416b9a44404f9','volumes',-1,'2026-01-21 15:22:14',NULL),('2026-01-20 15:22:14','2026-01-20 15:22:14','2026-01-20 15:22:14',1,598,'5dc6d618-6088-4126-affc-b19143ac11e3',144,'9156c0a9920c4721843416b9a44404f9','gigabytes',-1,'2026-01-21 15:22:14',NULL),('2026-01-20 15:22:14','2026-01-20 15:22:14','2026-01-20 15:22:14',1,599,'c792ff89-24bc-4f5d-b703-aa186fcbe611',145,'9156c0a9920c4721843416b9a44404f9','volumes___DEFAULT__',-1,'2026-01-21 15:22:14',NULL),('2026-01-20 15:22:14','2026-01-20 15:22:14','2026-01-20 15:22:14',1,600,'9df6be99-bb19-4de2-ad01-03e8cc0317a9',146,'9156c0a9920c4721843416b9a44404f9','gigabytes___DEFAULT__',-1,'2026-01-21 15:22:14',NULL),('2026-01-20 15:22:16','2026-01-20 15:22:16','2026-01-20 15:22:16',1,601,'5e31ae3e-eca4-4859-8085-0ffb2469bafc',143,'9156c0a9920c4721843416b9a44404f9','volumes',-1,'2026-01-21 15:22:16',NULL),('2026-01-20 15:22:16','2026-01-20 15:22:16','2026-01-20 15:22:16',1,602,'6426d480-41fb-4ab3-b703-121e2198da81',144,'9156c0a9920c4721843416b9a44404f9','gigabytes',-1,'2026-01-21 15:22:16',NULL),('2026-01-20 15:22:16','2026-01-20 15:22:16','2026-01-20 15:22:16',1,603,'da5f3095-c162-4082-83af-f7e329db4da4',145,'9156c0a9920c4721843416b9a44404f9','volumes___DEFAULT__',-1,'2026-01-21 15:22:16',NULL),('2026-01-20 15:22:16','2026-01-20 15:22:16','2026-01-20 15:22:16',1,604,'a8f69c80-0aa7-48ff-b832-7188f9c3e170',146,'9156c0a9920c4721843416b9a44404f9','gigabytes___DEFAULT__',-1,'2026-01-21 15:22:16',NULL);
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `rpc_current_version` varchar(36) DEFAULT NULL,
  `object_current_version` varchar(36) DEFAULT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `frozen` tinyint(1) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `services_uuid_idx` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone`, `disabled_reason`, `modified_at`, `rpc_current_version`, `object_current_version`, `replication_status`, `frozen`, `active_backend_id`, `cluster_name`, `uuid`) VALUES ('2026-01-20 13:41:46','2026-01-20 16:02:28',NULL,0,1,'cinder-scheduler-0','cinder-scheduler','cinder-scheduler',833,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'ed8ae41d-a479-4078-8c0a-b66d39771b02'),('2026-01-20 14:18:41','2026-01-20 16:02:27',NULL,0,2,'cinder-backup-0','cinder-backup','cinder-backup',616,0,'nova',NULL,NULL,'2.4','1.39','not-capable',0,NULL,NULL,'05507834-c9fe-49bd-a34d-e540b9bc17be'),('2026-01-20 14:18:42','2026-01-20 16:02:27',NULL,0,3,'hostgroup@ceph','cinder-volume','cinder-volume',616,0,'nova',NULL,NULL,'3.18','1.39','disabled',0,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot_metadata`
--

DROP TABLE IF EXISTS `snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshot_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `snapshot_metadata_ibfk_1` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot_metadata`
--

LOCK TABLES `snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `snapshot_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshots`
--

DROP TABLE IF EXISTS `snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `volume_size` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `provider_auth` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshots_group_snapshot_id` (`group_snapshot_id`),
  KEY `ix_snapshots_cgsnapshot_id` (`cgsnapshot_id`),
  KEY `ix_snapshots_volume_id` (`volume_id`),
  KEY `snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `snapshots_ibfk_1` FOREIGN KEY (`cgsnapshot_id`) REFERENCES `cgsnapshots` (`id`),
  CONSTRAINT `snapshots_ibfk_2` FOREIGN KEY (`group_snapshot_id`) REFERENCES `group_snapshots` (`id`),
  CONSTRAINT `snapshots_volume_id_fkey` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshots`
--

LOCK TABLES `snapshots` WRITE;
/*!40000 ALTER TABLE `snapshots` DISABLE KEYS */;
INSERT INTO `snapshots` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `status`, `progress`, `volume_size`, `scheduled_at`, `display_name`, `display_description`, `provider_location`, `encryption_key_id`, `volume_type_id`, `cgsnapshot_id`, `provider_id`, `provider_auth`, `group_snapshot_id`, `use_quota`) VALUES ('2026-01-20 15:05:59','2026-01-20 15:06:00','2026-01-20 15:06:01',1,'0bf94a78-a77f-4f4e-823c-2a7c96bc1e33','ec1cc32d-4158-4bf6-a67c-0c226a21fb04','f2cbb7f709bf4399b8a8137d2cbab438','f9a4fb1ea67548318c6ff2af4e9d4abe','deleted','100%',1,NULL,'tempest-VolumesSnapshotsTestJSON-Snapshot-2097944589',NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,NULL,NULL,NULL,1),('2026-01-20 15:10:37','2026-01-20 15:10:59','2026-01-20 15:11:00',1,'33f09854-2fbb-41ab-84ee-a1c4a1274b2b','c2176e35-f749-46e4-b63a-1d086dd1705c','bf422e55e158420cbdae75f07a3bb97a','a49638950e1543fa8e0d251af5479623','deleted','100%',1,NULL,'tempest-TestVolumeBootPattern-snapshot-438963378',NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,NULL,NULL,NULL,1),('2026-01-20 15:14:31','2026-01-20 15:15:36','2026-01-20 15:15:38',1,'3dcf5289-66e6-4e63-98e0-d16423ce9c81','670aaaab-6a81-487d-a346-d03d445d8abe','bf422e55e158420cbdae75f07a3bb97a','a49638950e1543fa8e0d251af5479623','deleted','100%',1,NULL,'tempest-TestVolumeBootPattern-snapshot-2054904817',NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,NULL,NULL,NULL,1),('2026-01-20 15:05:58','2026-01-20 15:07:14','2026-01-20 15:07:14',1,'a82fd77e-f9dd-4a01-9111-5774636cf3b0','4a621494-2aaf-461c-b7c1-05665913aaf9','bc554998e71a4322bdd27ac727a9044c','e142d118583b4f9ba3531bcf3838e256','deleted','100%',1,NULL,'tempest-TestStampPattern-snapshot-1736811740',NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,NULL,NULL,NULL,1),('2026-01-20 15:11:45','2026-01-20 15:12:37','2026-01-20 15:12:38',1,'ac531e53-ece8-4166-8e41-ebb939119e9b','fd11049d-6334-4d6c-ac5d-8cfeca690b75','bf422e55e158420cbdae75f07a3bb97a','a49638950e1543fa8e0d251af5479623','deleted','100%',1,NULL,'snapshot for tempest-TestVolumeBootPatternsnapshot-431707316',NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,NULL,NULL,NULL,1),('2026-01-20 15:08:51','2026-01-20 15:09:02','2026-01-20 15:09:04',1,'c8fcef0d-3444-4fb8-9733-aa2d43d8a44d','1ae2be75-c922-4458-bd11-a97b4f6fdd2b','c98bd3f0904e48efa524d598bcad85e9','5b43342be22543f79d4a56e26c6d0c96','deleted','100%',1,NULL,'tempest-TestMinimumBasicScenario-snapshot-2045526022',NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,NULL,NULL,NULL,1),('2026-01-20 15:17:14','2026-01-20 15:17:24','2026-01-20 15:17:25',1,'e76b9e34-4947-4eda-aa6f-85b2f7ae7aea','972ce456-91dd-4e78-8ae7-4dd3cb2257e8','e9cc4ce3e069479ba9c789b378a68a1d','fff727019f86407498e83d7948d54962','deleted','100%',1,NULL,'snapshot for multiattach-snapshot',NULL,NULL,NULL,'b55b5d00-8b4e-41a3-ab81-22610acc7e5e',NULL,NULL,NULL,NULL,1);
/*!40000 ALTER TABLE `snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `no_snapshots` tinyint(1) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_transfers_volume_id` (`volume_id`),
  CONSTRAINT `transfers_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_admin_metadata`
--

DROP TABLE IF EXISTS `volume_admin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_admin_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_admin_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_admin_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_admin_metadata`
--

LOCK TABLES `volume_admin_metadata` WRITE;
/*!40000 ALTER TABLE `volume_admin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_admin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_attachment`
--

DROP TABLE IF EXISTS `volume_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_attachment` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `attached_host` varchar(255) DEFAULT NULL,
  `instance_uuid` varchar(36) DEFAULT NULL,
  `mountpoint` varchar(255) DEFAULT NULL,
  `attach_time` datetime DEFAULT NULL,
  `detach_time` datetime DEFAULT NULL,
  `attach_mode` varchar(36) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `connection_info` text DEFAULT NULL,
  `connector` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_attachment_volume_id` (`volume_id`),
  CONSTRAINT `volume_attachment_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_attachment`
--

LOCK TABLES `volume_attachment` WRITE;
/*!40000 ALTER TABLE `volume_attachment` DISABLE KEYS */;
INSERT INTO `volume_attachment` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `attached_host`, `instance_uuid`, `mountpoint`, `attach_time`, `detach_time`, `attach_mode`, `attach_status`, `connection_info`, `connector`) VALUES ('2026-01-20 14:24:10','2026-01-20 14:24:17','2026-01-20 14:24:17',1,'05ee5376-30c1-4b06-af38-a41fdab6fc8b','4b77ca01-614c-4b84-ae37-bb7bf58d4923','compute-1.ctlplane.example.com','7108f815-a0ef-4f18-a2c2-c796476ace75','/dev/vdb','2026-01-20 14:24:13','2026-01-20 14:24:17','rw','detached','{\"name\": \"volumes/volume-4b77ca01-614c-4b84-ae37-bb7bf58d4923\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"4b77ca01-614c-4b84-ae37-bb7bf58d4923\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"05ee5376-30c1-4b06-af38-a41fdab6fc8b\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1821ea3dc03d\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"870b1f1c-f19c-477b-b282-ee6eeba50974\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 15:16:19','2026-01-20 15:16:50','2026-01-20 15:16:50',1,'0d9a1862-1a05-483d-a1d0-ba414e1ffed2','933c5c7a-f496-4bcc-b304-68156c235fe5','compute-0.ctlplane.example.com','b3504af3-390e-4ab0-8af6-15749a887d8f','/dev/vdb','2026-01-20 15:16:25','2026-01-20 15:16:50','rw','detached','{\"name\": \"volumes/volume-933c5c7a-f496-4bcc-b304-68156c235fe5\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"933c5c7a-f496-4bcc-b304-68156c235fe5\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"0d9a1862-1a05-483d-a1d0-ba414e1ffed2\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:228389a1f17e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"35085f33-1a27-41e3-805d-02c7ac6a1d7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 14:55:15','2026-01-20 14:55:28','2026-01-20 14:55:28',1,'11b9f326-e25b-487a-9b09-8d4ee125cf3d','f3a427b1-0e50-45b1-a975-3d7aabd0195a','compute-0.ctlplane.example.com','b346e1ba-9e83-4e7f-bc03-c327d3e4173b','/dev/vdb','2026-01-20 14:55:17','2026-01-20 14:55:28','rw','detached','{\"name\": \"volumes/volume-f3a427b1-0e50-45b1-a975-3d7aabd0195a\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"f3a427b1-0e50-45b1-a975-3d7aabd0195a\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"11b9f326-e25b-487a-9b09-8d4ee125cf3d\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:228389a1f17e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"35085f33-1a27-41e3-805d-02c7ac6a1d7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 14:53:53','2026-01-20 14:54:40','2026-01-20 14:54:40',1,'140b4d04-9654-453e-bf6a-b47873d35adc','b687fb44-6160-427b-b91a-091715876a58','compute-0.ctlplane.example.com','d23ddbd4-8b5d-4bf5-a02d-3fb69b940770','/dev/vda','2026-01-20 14:54:02','2026-01-20 14:54:40','rw','detached','{\"name\": \"volumes/volume-b687fb44-6160-427b-b91a-091715876a58\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"b687fb44-6160-427b-b91a-091715876a58\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"140b4d04-9654-453e-bf6a-b47873d35adc\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:228389a1f17e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"35085f33-1a27-41e3-805d-02c7ac6a1d7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-20 14:59:11','2026-01-20 14:59:33','2026-01-20 14:59:33',1,'17fc8ff5-edb4-4dc8-aba8-9dd268a5f344','b0619b28-88eb-4051-9e30-36100f39c117','compute-1.ctlplane.example.com','b4c1468d-9914-426a-9464-c1167de53632','/dev/vdb','2026-01-20 14:59:13','2026-01-20 14:59:33','rw','detached','{\"name\": \"volumes/volume-b0619b28-88eb-4051-9e30-36100f39c117\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"b0619b28-88eb-4051-9e30-36100f39c117\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"17fc8ff5-edb4-4dc8-aba8-9dd268a5f344\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1821ea3dc03d\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"870b1f1c-f19c-477b-b282-ee6eeba50974\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 14:31:03','2026-01-20 14:31:23','2026-01-20 14:31:23',1,'1b82c01d-d5c1-48cc-9d9f-078b75fe40c6','73c5b3f0-c4ca-48f3-9dc2-d2c15d3fd745','compute-1.ctlplane.example.com','f3faf996-e066-4b11-b7f3-30aeffff726e','/dev/vdb','2026-01-20 14:31:05','2026-01-20 14:31:23','rw','detached','{\"name\": \"volumes/volume-73c5b3f0-c4ca-48f3-9dc2-d2c15d3fd745\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"73c5b3f0-c4ca-48f3-9dc2-d2c15d3fd745\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"1b82c01d-d5c1-48cc-9d9f-078b75fe40c6\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1821ea3dc03d\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"870b1f1c-f19c-477b-b282-ee6eeba50974\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 14:49:19','2026-01-20 14:51:07','2026-01-20 14:51:07',1,'1c8151c5-460c-482c-8032-494f5d7b3a37','8cd2ec74-aafb-4e12-a845-44b6fe96ba18','compute-2.ctlplane.example.com','f444ccf6-5adb-489a-b174-7450017a351b','/dev/vda','2026-01-20 14:49:28','2026-01-20 14:51:07','rw','detached','{\"name\": \"volumes/volume-8cd2ec74-aafb-4e12-a845-44b6fe96ba18\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"8cd2ec74-aafb-4e12-a845-44b6fe96ba18\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"1c8151c5-460c-482c-8032-494f5d7b3a37\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:f7e7b2e5d28e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"1190ec40-2b89-4358-8dec-733c5829fbed\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-20 14:39:03','2026-01-20 14:40:21','2026-01-20 14:40:21',1,'2033d6c6-f159-4dd7-9887-2993ee4695aa','41d04608-e9dd-4b22-8440-9cab803a24b7','compute-2.ctlplane.example.com','795b0a95-448b-49b1-80cb-a18e84101480','/dev/vdb','2026-01-20 14:39:09','2026-01-20 14:40:21','rw','detached','{\"name\": \"volumes/volume-41d04608-e9dd-4b22-8440-9cab803a24b7\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"41d04608-e9dd-4b22-8440-9cab803a24b7\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"2033d6c6-f159-4dd7-9887-2993ee4695aa\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:f7e7b2e5d28e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"1190ec40-2b89-4358-8dec-733c5829fbed\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 15:01:46','2026-01-20 15:05:10','2026-01-20 15:05:10',1,'20658306-e0e7-4d9c-a904-24cfdd1b82ee','41743468-7add-45cb-bc94-02eb6f850278','compute-1.ctlplane.example.com','474cec75-3b01-411a-9074-75859d2a9ddf','/dev/vda','2026-01-20 15:01:47','2026-01-20 15:05:10','rw','detached','{\"name\": \"volumes/volume-41743468-7add-45cb-bc94-02eb6f850278\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"41743468-7add-45cb-bc94-02eb6f850278\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"20658306-e0e7-4d9c-a904-24cfdd1b82ee\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1821ea3dc03d\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"870b1f1c-f19c-477b-b282-ee6eeba50974\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-20 15:11:15','2026-01-20 15:12:41','2026-01-20 15:12:41',1,'20ae1978-9442-4aff-9d5a-ea601c28b117','fd11049d-6334-4d6c-ac5d-8cfeca690b75','compute-2.ctlplane.example.com','950f84b7-e9c2-415c-9946-315a443331c9','/dev/vda','2026-01-20 15:11:18','2026-01-20 15:12:41','rw','detached','{\"name\": \"volumes/volume-fd11049d-6334-4d6c-ac5d-8cfeca690b75\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"fd11049d-6334-4d6c-ac5d-8cfeca690b75\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"20ae1978-9442-4aff-9d5a-ea601c28b117\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:f7e7b2e5d28e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"1190ec40-2b89-4358-8dec-733c5829fbed\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-20 14:57:35','2026-01-20 14:59:59','2026-01-20 14:59:59',1,'25d46c6d-0955-42e9-9edd-2c90ded91a6c','5728e8f8-a711-41d5-aa04-a1d9faada8d9','compute-1.ctlplane.example.com','1ebdefed-0903-4d72-b78d-912666c5ce61','/dev/vda','2026-01-20 14:57:39','2026-01-20 14:59:59','rw','detached','{\"name\": \"volumes/volume-5728e8f8-a711-41d5-aa04-a1d9faada8d9\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"5728e8f8-a711-41d5-aa04-a1d9faada8d9\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"25d46c6d-0955-42e9-9edd-2c90ded91a6c\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1821ea3dc03d\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"870b1f1c-f19c-477b-b282-ee6eeba50974\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-20 14:30:59','2026-01-20 14:31:32','2026-01-20 14:31:32',1,'285224ad-1d47-48db-81c5-b2e37e24a7ee','73c5b3f0-c4ca-48f3-9dc2-d2c15d3fd745','compute-0.ctlplane.example.com','ad62888a-ef27-43b4-bb6c-439541ff5524','/dev/vdb','2026-01-20 14:31:01','2026-01-20 14:31:32','rw','detached','{\"name\": \"volumes/volume-73c5b3f0-c4ca-48f3-9dc2-d2c15d3fd745\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"73c5b3f0-c4ca-48f3-9dc2-d2c15d3fd745\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"285224ad-1d47-48db-81c5-b2e37e24a7ee\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:228389a1f17e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"35085f33-1a27-41e3-805d-02c7ac6a1d7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 14:57:48','2026-01-20 14:58:16','2026-01-20 14:58:16',1,'2c0a4684-4e14-4aaa-82b1-ba92b18dafde','06b5ccf9-bd72-4532-983a-75b3b42cbfe9','compute-2.ctlplane.example.com','a9aa8bf0-76a1-45f7-bd38-a7b9f7d0b64f','/dev/vdb','2026-01-20 14:57:50','2026-01-20 14:58:16','rw','detached','{\"name\": \"volumes/volume-06b5ccf9-bd72-4532-983a-75b3b42cbfe9\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"06b5ccf9-bd72-4532-983a-75b3b42cbfe9\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"2c0a4684-4e14-4aaa-82b1-ba92b18dafde\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:f7e7b2e5d28e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"1190ec40-2b89-4358-8dec-733c5829fbed\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 15:15:35','2026-01-20 15:16:49','2026-01-20 15:16:49',1,'2d78d259-3019-4a60-a542-4278ca487610','933c5c7a-f496-4bcc-b304-68156c235fe5','compute-1.ctlplane.example.com','f1ded131-d9a3-4e93-ad99-53ee2695d5c8','/dev/vdb','2026-01-20 15:15:41','2026-01-20 15:16:49','rw','detached','{\"name\": \"volumes/volume-933c5c7a-f496-4bcc-b304-68156c235fe5\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"933c5c7a-f496-4bcc-b304-68156c235fe5\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"2d78d259-3019-4a60-a542-4278ca487610\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1821ea3dc03d\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"870b1f1c-f19c-477b-b282-ee6eeba50974\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 15:04:08','2026-01-20 15:04:57','2026-01-20 15:04:57',1,'2e3b09a8-1ad6-45d8-9497-37288b706f5c','9d237554-9581-4577-897a-3907d38a0cb3','compute-1.ctlplane.example.com','c1db561e-0c8b-4cfb-97bb-55f8d4731b87','/dev/vda','2026-01-20 15:04:11','2026-01-20 15:04:57','rw','detached','{\"name\": \"volumes/volume-9d237554-9581-4577-897a-3907d38a0cb3\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"9d237554-9581-4577-897a-3907d38a0cb3\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"2e3b09a8-1ad6-45d8-9497-37288b706f5c\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1821ea3dc03d\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"870b1f1c-f19c-477b-b282-ee6eeba50974\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-20 15:17:03','2026-01-20 15:17:23','2026-01-20 15:17:23',1,'2f967f97-fbb3-4eef-b805-b5ffb0cafc02','972ce456-91dd-4e78-8ae7-4dd3cb2257e8','compute-2.ctlplane.example.com','13d313ff-27f8-40d0-96d4-5ddb1605cad9','/dev/vda','2026-01-20 15:17:06','2026-01-20 15:17:23','rw','detached','{\"name\": \"volumes/volume-972ce456-91dd-4e78-8ae7-4dd3cb2257e8\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"972ce456-91dd-4e78-8ae7-4dd3cb2257e8\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"2f967f97-fbb3-4eef-b805-b5ffb0cafc02\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:f7e7b2e5d28e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"1190ec40-2b89-4358-8dec-733c5829fbed\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-20 14:58:31','2026-01-20 14:58:59','2026-01-20 14:58:59',1,'33fc5a49-bcff-4298-84b6-8c4fe61f57ab','3381d324-93a9-4d2f-ab25-8460bb2b8e95','compute-1.ctlplane.example.com','1ebdefed-0903-4d72-b78d-912666c5ce61','/dev/vdb','2026-01-20 14:58:32','2026-01-20 14:58:59','rw','detached','{\"name\": \"volumes/volume-3381d324-93a9-4d2f-ab25-8460bb2b8e95\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"3381d324-93a9-4d2f-ab25-8460bb2b8e95\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"33fc5a49-bcff-4298-84b6-8c4fe61f57ab\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1821ea3dc03d\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"870b1f1c-f19c-477b-b282-ee6eeba50974\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 15:05:35','2026-01-20 15:06:17','2026-01-20 15:06:17',1,'355735e8-db73-48e6-9318-c418940c37c9','94300d81-b4ca-4c0a-9283-83b76826d40f','compute-0.ctlplane.example.com','5feeb9de-434b-4ec7-aa99-6da718514c6f','/dev/vda','2026-01-20 15:05:39','2026-01-20 15:06:17','rw','detached','{\"name\": \"volumes/volume-94300d81-b4ca-4c0a-9283-83b76826d40f\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"94300d81-b4ca-4c0a-9283-83b76826d40f\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"355735e8-db73-48e6-9318-c418940c37c9\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:228389a1f17e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"35085f33-1a27-41e3-805d-02c7ac6a1d7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-20 15:08:48','2026-01-20 15:09:34','2026-01-20 15:09:34',1,'381cb790-ccf8-436f-94a0-eae0e8e507cc','1ae2be75-c922-4458-bd11-a97b4f6fdd2b','compute-1.ctlplane.example.com','b4c55640-85f9-4d75-a4df-6ee77b21ca73','/dev/vdb','2026-01-20 15:08:49','2026-01-20 15:09:34','rw','detached','{\"name\": \"volumes/volume-1ae2be75-c922-4458-bd11-a97b4f6fdd2b\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"1ae2be75-c922-4458-bd11-a97b4f6fdd2b\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"381cb790-ccf8-436f-94a0-eae0e8e507cc\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1821ea3dc03d\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"870b1f1c-f19c-477b-b282-ee6eeba50974\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 14:53:12','2026-01-20 14:53:54','2026-01-20 14:53:54',1,'3fc4aa11-5b94-4c96-a371-59de6fc196c2','b687fb44-6160-427b-b91a-091715876a58','compute-0.ctlplane.example.com','d23ddbd4-8b5d-4bf5-a02d-3fb69b940770','/dev/vda','2026-01-20 14:53:17','2026-01-20 14:53:54','rw','detached','{\"name\": \"volumes/volume-b687fb44-6160-427b-b91a-091715876a58\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"b687fb44-6160-427b-b91a-091715876a58\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"3fc4aa11-5b94-4c96-a371-59de6fc196c2\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:228389a1f17e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"35085f33-1a27-41e3-805d-02c7ac6a1d7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-20 15:19:07','2026-01-20 15:20:03','2026-01-20 15:20:03',1,'42dce34d-a725-459d-9faf-f052d4783cbb','9f3cabb8-d51f-4db9-97b3-c5b764893ee2','compute-1.ctlplane.example.com','2b31f3d7-81bd-4712-bcb1-98afd2dc0f44','/dev/vdb','2026-01-20 15:19:08','2026-01-20 15:20:03','rw','detached','{\"name\": \"volumes/volume-9f3cabb8-d51f-4db9-97b3-c5b764893ee2\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"9f3cabb8-d51f-4db9-97b3-c5b764893ee2\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"42dce34d-a725-459d-9faf-f052d4783cbb\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1821ea3dc03d\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"870b1f1c-f19c-477b-b282-ee6eeba50974\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 14:47:30','2026-01-20 14:48:07','2026-01-20 14:48:07',1,'44ad9b49-9629-4243-9bc6-4177f69f7660','9219aafd-6c66-4f38-9927-85b54b4175ae','compute-2.ctlplane.example.com','9beb3ec3-721e-4919-9713-a92c82ad189b','/dev/vda','2026-01-20 14:47:33','2026-01-20 14:48:07','rw','detached','{\"name\": \"volumes/volume-9219aafd-6c66-4f38-9927-85b54b4175ae\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"9219aafd-6c66-4f38-9927-85b54b4175ae\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"44ad9b49-9629-4243-9bc6-4177f69f7660\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:f7e7b2e5d28e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"1190ec40-2b89-4358-8dec-733c5829fbed\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-20 14:53:59','2026-01-20 14:54:33','2026-01-20 14:54:33',1,'45e245a3-2c83-4138-8fd9-f41ae224cc33','763a536d-0897-462a-8acb-fbf9e84e31ea','compute-2.ctlplane.example.com','49919d3f-fab0-404f-a0a0-82610973a254','/dev/vdc','2026-01-20 14:54:04','2026-01-20 14:54:33','rw','detached','{\"name\": \"volumes/volume-763a536d-0897-462a-8acb-fbf9e84e31ea\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"763a536d-0897-462a-8acb-fbf9e84e31ea\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"45e245a3-2c83-4138-8fd9-f41ae224cc33\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:f7e7b2e5d28e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"1190ec40-2b89-4358-8dec-733c5829fbed\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2026-01-20 14:46:28','2026-01-20 14:46:36','2026-01-20 14:46:36',1,'4982b9c6-6475-4038-b1e1-764e3501e6c5','aab03340-0e79-412e-a963-e216832603c4','compute-1.ctlplane.example.com','5f56b3e9-af2b-4934-8184-6257994c6b6a','/dev/vdb','2026-01-20 14:46:29','2026-01-20 14:46:36','rw','detached','{\"name\": \"volumes/volume-aab03340-0e79-412e-a963-e216832603c4\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"aab03340-0e79-412e-a963-e216832603c4\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"4982b9c6-6475-4038-b1e1-764e3501e6c5\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1821ea3dc03d\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"870b1f1c-f19c-477b-b282-ee6eeba50974\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 15:06:16','2026-01-20 15:07:11','2026-01-20 15:07:11',1,'50d9296f-3ad8-43e9-a963-2b942f9bc3e3','94300d81-b4ca-4c0a-9283-83b76826d40f','compute-1.ctlplane.example.com','5feeb9de-434b-4ec7-aa99-6da718514c6f','/dev/vda','2026-01-20 15:06:21','2026-01-20 15:07:11','rw','detached','{\"name\": \"volumes/volume-94300d81-b4ca-4c0a-9283-83b76826d40f\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"94300d81-b4ca-4c0a-9283-83b76826d40f\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"50d9296f-3ad8-43e9-a963-2b942f9bc3e3\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1821ea3dc03d\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"870b1f1c-f19c-477b-b282-ee6eeba50974\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-20 14:44:29','2026-01-20 14:44:36','2026-01-20 14:44:36',1,'53649e5b-5992-49a4-99de-679629482b83','5930261f-9813-4b24-a25f-b6b26b90d24b','compute-2.ctlplane.example.com','c3c7df3a-49bb-4ca6-a517-e560cf730181','/dev/vdb','2026-01-20 14:44:30','2026-01-20 14:44:36','rw','detached','{\"name\": \"volumes/volume-5930261f-9813-4b24-a25f-b6b26b90d24b\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"5930261f-9813-4b24-a25f-b6b26b90d24b\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"53649e5b-5992-49a4-99de-679629482b83\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:f7e7b2e5d28e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"1190ec40-2b89-4358-8dec-733c5829fbed\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 14:55:44','2026-01-20 14:55:57','2026-01-20 14:55:57',1,'557d23e1-f318-4f7d-be6b-c62aa5870a94','f3a427b1-0e50-45b1-a975-3d7aabd0195a','compute-0.ctlplane.example.com','b346e1ba-9e83-4e7f-bc03-c327d3e4173b','/dev/vdb','2026-01-20 14:55:48','2026-01-20 14:55:57','rw','detached','{\"name\": \"volumes/volume-f3a427b1-0e50-45b1-a975-3d7aabd0195a\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"f3a427b1-0e50-45b1-a975-3d7aabd0195a\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"557d23e1-f318-4f7d-be6b-c62aa5870a94\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:228389a1f17e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"35085f33-1a27-41e3-805d-02c7ac6a1d7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 14:28:34','2026-01-20 14:29:02','2026-01-20 14:29:02',1,'636146ab-4bc6-4c21-9609-7755eb208c7c','47e883f3-6efe-40b3-be28-6c01525dfc0c','compute-1.ctlplane.example.com','79b5596e-43c9-4085-9829-454fecf59490','/dev/vda','2026-01-20 14:28:35','2026-01-20 14:29:02','null','detached','{\"name\": \"volumes/volume-47e883f3-6efe-40b3-be28-6c01525dfc0c\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"47e883f3-6efe-40b3-be28-6c01525dfc0c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"636146ab-4bc6-4c21-9609-7755eb208c7c\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1821ea3dc03d\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"870b1f1c-f19c-477b-b282-ee6eeba50974\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2026-01-20 14:46:48','2026-01-20 14:46:53','2026-01-20 14:46:53',1,'6619e757-e35b-4400-88fd-ee32e8d659d5','42ddc596-73e2-4763-a6a5-75e17ba882ad','compute-2.ctlplane.example.com','6d9b0e60-8e92-4c9a-8aab-1b7f44bb2835','/dev/vdb','2026-01-20 14:46:49','2026-01-20 14:46:53','rw','detached','{\"name\": \"volumes/volume-42ddc596-73e2-4763-a6a5-75e17ba882ad\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"42ddc596-73e2-4763-a6a5-75e17ba882ad\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"6619e757-e35b-4400-88fd-ee32e8d659d5\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:f7e7b2e5d28e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"1190ec40-2b89-4358-8dec-733c5829fbed\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 14:55:35','2026-01-20 14:55:36','2026-01-20 14:55:36',1,'687c5968-3b9c-422e-a90a-be105f0b7d8c','a731fcaa-4151-4307-ba1b-6515889f3a7c',NULL,'3bec73f6-5255-44c0-8a10-a64c7e86c0c2',NULL,NULL,'2026-01-20 14:55:36','null','detached','{}',NULL),('2026-01-20 14:44:37','2026-01-20 14:45:30','2026-01-20 14:45:30',1,'6b0d250e-a1b5-4326-abb8-6df5e007e9a0','2441d1fb-fc23-4a6d-b88d-4d82b035b65f','compute-1.ctlplane.example.com','d236e7eb-2b7e-4031-b851-ae2790528213','/dev/vda','2026-01-20 14:44:40','2026-01-20 14:45:30','rw','detached','{\"name\": \"volumes/volume-2441d1fb-fc23-4a6d-b88d-4d82b035b65f\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"2441d1fb-fc23-4a6d-b88d-4d82b035b65f\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"6b0d250e-a1b5-4326-abb8-6df5e007e9a0\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1821ea3dc03d\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"870b1f1c-f19c-477b-b282-ee6eeba50974\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-20 14:28:56','2026-01-20 14:29:13','2026-01-20 14:29:13',1,'6c957d53-8aa2-46d0-909e-8d823c9b1e44','47e883f3-6efe-40b3-be28-6c01525dfc0c','compute-0.ctlplane.example.com','79b5596e-43c9-4085-9829-454fecf59490','/dev/vda','2026-01-20 14:28:57','2026-01-20 14:29:13','null','detached','{\"name\": \"volumes/volume-47e883f3-6efe-40b3-be28-6c01525dfc0c\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"47e883f3-6efe-40b3-be28-6c01525dfc0c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"6c957d53-8aa2-46d0-909e-8d823c9b1e44\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:228389a1f17e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"35085f33-1a27-41e3-805d-02c7ac6a1d7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2026-01-20 14:24:47','2026-01-20 14:25:27','2026-01-20 14:25:27',1,'7d9d6585-3801-4399-b7db-b7178b344eaa','67ec3b5b-23d2-4f8a-84b0-4ee1bda588af','compute-2.ctlplane.example.com','85ec4052-1453-4c76-936e-bf76f2108416','/dev/vda','2026-01-20 14:24:52','2026-01-20 14:25:27','rw','detached','{\"name\": \"volumes/volume-67ec3b5b-23d2-4f8a-84b0-4ee1bda588af\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"67ec3b5b-23d2-4f8a-84b0-4ee1bda588af\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"7d9d6585-3801-4399-b7db-b7178b344eaa\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:f7e7b2e5d28e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"1190ec40-2b89-4358-8dec-733c5829fbed\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-20 15:02:56','2026-01-20 15:03:46','2026-01-20 15:03:46',1,'7fdba019-6b66-4b1c-9d5b-15c02e510fba','d50f7be5-09c1-4898-894c-704176a797ac','compute-2.ctlplane.example.com','75368220-ff38-456b-a0e6-ae1c02625514','/dev/vdb','2026-01-20 15:02:57','2026-01-20 15:03:46','rw','detached','{\"name\": \"volumes/volume-d50f7be5-09c1-4898-894c-704176a797ac\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"d50f7be5-09c1-4898-894c-704176a797ac\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"7fdba019-6b66-4b1c-9d5b-15c02e510fba\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:f7e7b2e5d28e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"1190ec40-2b89-4358-8dec-733c5829fbed\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 15:05:26','2026-01-20 15:05:34','2026-01-20 15:05:34',1,'82c493aa-2be0-4e8e-8cb6-f8854e8da0d8','b2752651-d07b-4c58-8781-1b28cd47b400','compute-2.ctlplane.example.com','3e59fbab-2129-45b7-8fb1-997b2ccede64','/dev/vdc','2026-01-20 15:05:28','2026-01-20 15:05:34','rw','detached','{\"name\": \"volumes/volume-b2752651-d07b-4c58-8781-1b28cd47b400\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"b2752651-d07b-4c58-8781-1b28cd47b400\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"82c493aa-2be0-4e8e-8cb6-f8854e8da0d8\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:f7e7b2e5d28e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"1190ec40-2b89-4358-8dec-733c5829fbed\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2026-01-20 15:14:13','2026-01-20 15:14:20','2026-01-20 15:14:20',1,'840bce26-18f1-490c-9a94-c132dde0458b','8ac6f07e-10cd-4304-b732-9202123dbda4','compute-2.ctlplane.example.com','810e72a9-536d-4214-956b-9d5216cce8ff','/dev/vdb','2026-01-20 15:14:14','2026-01-20 15:14:20','rw','detached','{\"name\": \"volumes/volume-8ac6f07e-10cd-4304-b732-9202123dbda4\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"8ac6f07e-10cd-4304-b732-9202123dbda4\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"840bce26-18f1-490c-9a94-c132dde0458b\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:f7e7b2e5d28e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"1190ec40-2b89-4358-8dec-733c5829fbed\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 14:57:31','2026-01-20 15:00:02','2026-01-20 15:00:02',1,'86aad614-44a2-43a7-a5c0-6a1d947269d9','94858b1a-370f-4ee8-b017-647fe5082382','compute-2.ctlplane.example.com','a9aa8bf0-76a1-45f7-bd38-a7b9f7d0b64f','/dev/vda','2026-01-20 14:57:35','2026-01-20 15:00:02','rw','detached','{\"name\": \"volumes/volume-94858b1a-370f-4ee8-b017-647fe5082382\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"94858b1a-370f-4ee8-b017-647fe5082382\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"86aad614-44a2-43a7-a5c0-6a1d947269d9\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:f7e7b2e5d28e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"1190ec40-2b89-4358-8dec-733c5829fbed\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-20 15:15:09','2026-01-20 15:15:35','2026-01-20 15:15:35',1,'8dd443c2-f151-4144-b3c5-f1165910696f','933c5c7a-f496-4bcc-b304-68156c235fe5','compute-0.ctlplane.example.com','f1ded131-d9a3-4e93-ad99-53ee2695d5c8','/dev/vdb','2026-01-20 15:15:13','2026-01-20 15:15:35','rw','detached','{\"name\": \"volumes/volume-933c5c7a-f496-4bcc-b304-68156c235fe5\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"933c5c7a-f496-4bcc-b304-68156c235fe5\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"8dd443c2-f151-4144-b3c5-f1165910696f\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:228389a1f17e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"35085f33-1a27-41e3-805d-02c7ac6a1d7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 14:33:28','2026-01-20 14:33:35','2026-01-20 14:33:35',1,'8f32b739-0c75-4e74-8c94-29b1c987749e','0a09166e-3f2b-4406-9246-5c03480cda80','compute-0.ctlplane.example.com','a5f0dd02-bd8a-41ed-a3cc-0b52c7e31174','/dev/vdb','2026-01-20 14:33:30','2026-01-20 14:33:35','rw','detached','{\"name\": \"volumes/volume-0a09166e-3f2b-4406-9246-5c03480cda80\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"0a09166e-3f2b-4406-9246-5c03480cda80\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"8f32b739-0c75-4e74-8c94-29b1c987749e\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:228389a1f17e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"35085f33-1a27-41e3-805d-02c7ac6a1d7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 15:14:16','2026-01-20 15:14:22','2026-01-20 15:14:22',1,'907f5af7-31e3-4736-be4c-e2f5a674a9d7','8ac6f07e-10cd-4304-b732-9202123dbda4','compute-2.ctlplane.example.com','54a13784-2a60-4b16-8208-d9b9d0e3033e','/dev/vdb','2026-01-20 15:14:17','2026-01-20 15:14:22','rw','detached','{\"name\": \"volumes/volume-8ac6f07e-10cd-4304-b732-9202123dbda4\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"8ac6f07e-10cd-4304-b732-9202123dbda4\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"907f5af7-31e3-4736-be4c-e2f5a674a9d7\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:f7e7b2e5d28e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"1190ec40-2b89-4358-8dec-733c5829fbed\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 14:25:45','2026-01-20 14:26:01','2026-01-20 14:26:01',1,'954ccf13-9937-4f2e-939d-e917fca9571b','67ec3b5b-23d2-4f8a-84b0-4ee1bda588af','compute-2.ctlplane.example.com','85ec4052-1453-4c76-936e-bf76f2108416','/dev/vda','2026-01-20 14:25:46','2026-01-20 14:26:01','null','detached','{\"name\": \"volumes/volume-67ec3b5b-23d2-4f8a-84b0-4ee1bda588af\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"67ec3b5b-23d2-4f8a-84b0-4ee1bda588af\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"954ccf13-9937-4f2e-939d-e917fca9571b\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:f7e7b2e5d28e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"1190ec40-2b89-4358-8dec-733c5829fbed\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2026-01-20 14:28:16','2026-01-20 14:28:20','2026-01-20 14:28:20',1,'96eb38b6-0b35-4972-95c6-9de22312b89c','0ef22368-9785-4823-bb66-470ea5a5862d','compute-0.ctlplane.example.com','4ee9159e-bf2b-47b7-8568-47fd13815f05','/dev/sdc','2026-01-20 14:28:17','2026-01-20 14:28:20','rw','detached','{\"name\": \"volumes/volume-0ef22368-9785-4823-bb66-470ea5a5862d\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"0ef22368-9785-4823-bb66-470ea5a5862d\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"96eb38b6-0b35-4972-95c6-9de22312b89c\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:228389a1f17e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"35085f33-1a27-41e3-805d-02c7ac6a1d7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/sdc\"}'),('2026-01-20 15:22:02','2026-01-20 15:22:06','2026-01-20 15:22:06',1,'9703280d-0054-47db-b0be-f4797e6f98b3','02088fae-4a9d-4027-a9b3-19d5b159fed0','compute-2.ctlplane.example.com','e6540d15-a33f-4638-b102-8a1629193c18','/dev/vdb','2026-01-20 15:22:03','2026-01-20 15:22:06','rw','detached','{\"name\": \"volumes/volume-02088fae-4a9d-4027-a9b3-19d5b159fed0\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"02088fae-4a9d-4027-a9b3-19d5b159fed0\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"9703280d-0054-47db-b0be-f4797e6f98b3\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:f7e7b2e5d28e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"1190ec40-2b89-4358-8dec-733c5829fbed\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 15:10:48','2026-01-20 15:10:57','2026-01-20 15:10:57',1,'9aa44915-ba45-4054-be03-16dd5a3b8ca4','f396a213-a7f4-434e-a290-c5d9278be4af','compute-1.ctlplane.example.com','35ba4fcf-baa1-45a5-bf4c-4f5cb96653a8','/dev/vda','2026-01-20 15:10:49','2026-01-20 15:10:57','rw','detached','{\"name\": \"volumes/volume-f396a213-a7f4-434e-a290-c5d9278be4af\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"f396a213-a7f4-434e-a290-c5d9278be4af\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"9aa44915-ba45-4054-be03-16dd5a3b8ca4\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1821ea3dc03d\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"870b1f1c-f19c-477b-b282-ee6eeba50974\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-20 14:28:12','2026-01-20 14:28:41','2026-01-20 14:28:41',1,'9eb63166-9838-4b2e-9a3b-635bb42864f1','47e883f3-6efe-40b3-be28-6c01525dfc0c','compute-0.ctlplane.example.com','79b5596e-43c9-4085-9829-454fecf59490','/dev/vda','2026-01-20 14:28:16','2026-01-20 14:28:41','rw','detached','{\"name\": \"volumes/volume-47e883f3-6efe-40b3-be28-6c01525dfc0c\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"47e883f3-6efe-40b3-be28-6c01525dfc0c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"9eb63166-9838-4b2e-9a3b-635bb42864f1\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:228389a1f17e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"35085f33-1a27-41e3-805d-02c7ac6a1d7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-20 14:48:07','2026-01-20 14:48:40','2026-01-20 14:48:40',1,'a2de2d41-d2d4-4195-90f3-7c5d6054f339','9219aafd-6c66-4f38-9927-85b54b4175ae','compute-1.ctlplane.example.com','9beb3ec3-721e-4919-9713-a92c82ad189b','/dev/vda','2026-01-20 14:48:13','2026-01-20 14:48:40','rw','detached','{\"name\": \"volumes/volume-9219aafd-6c66-4f38-9927-85b54b4175ae\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"9219aafd-6c66-4f38-9927-85b54b4175ae\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"a2de2d41-d2d4-4195-90f3-7c5d6054f339\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1821ea3dc03d\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"870b1f1c-f19c-477b-b282-ee6eeba50974\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-20 14:39:03','2026-01-20 14:40:22','2026-01-20 14:40:22',1,'a391e283-eb10-4224-b18a-131281c04977','419220b3-a6cb-447f-be9b-d4de4cac4b79','compute-2.ctlplane.example.com','795b0a95-448b-49b1-80cb-a18e84101480','/dev/vdc','2026-01-20 14:39:11','2026-01-20 14:40:22','rw','detached','{\"name\": \"volumes/volume-419220b3-a6cb-447f-be9b-d4de4cac4b79\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"419220b3-a6cb-447f-be9b-d4de4cac4b79\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"a391e283-eb10-4224-b18a-131281c04977\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:f7e7b2e5d28e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"1190ec40-2b89-4358-8dec-733c5829fbed\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2026-01-20 15:10:05','2026-01-20 15:11:13','2026-01-20 15:11:13',1,'a48d10e0-1635-480d-9912-02d24834bdae','c53232c5-7839-4cc5-8acf-4257d1fb7c13','compute-0.ctlplane.example.com','7f408ee5-e644-4a37-9cd2-3db94e56c638','/dev/vdb','2026-01-20 15:10:06','2026-01-20 15:11:13','rw','detached','{\"name\": \"volumes/volume-c53232c5-7839-4cc5-8acf-4257d1fb7c13\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"c53232c5-7839-4cc5-8acf-4257d1fb7c13\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"a48d10e0-1635-480d-9912-02d24834bdae\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:228389a1f17e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"35085f33-1a27-41e3-805d-02c7ac6a1d7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 14:49:20','2026-01-20 14:51:07','2026-01-20 14:51:07',1,'a8507e5b-0e79-4bf9-bb87-c0c2cd4679ea','9a6aba77-de94-4bfe-8062-70d79455ddbe','compute-2.ctlplane.example.com','f444ccf6-5adb-489a-b174-7450017a351b','/dev/vdc','2026-01-20 14:49:31','2026-01-20 14:51:07','rw','detached','{\"name\": \"volumes/volume-9a6aba77-de94-4bfe-8062-70d79455ddbe\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"9a6aba77-de94-4bfe-8062-70d79455ddbe\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"a8507e5b-0e79-4bf9-bb87-c0c2cd4679ea\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:f7e7b2e5d28e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"1190ec40-2b89-4358-8dec-733c5829fbed\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2026-01-20 14:58:35','2026-01-20 14:59:03','2026-01-20 14:59:03',1,'aa9114da-45ac-4223-b30c-7a489822200c','0d487092-de99-40b0-be3f-425947d7010c','compute-1.ctlplane.example.com','1ebdefed-0903-4d72-b78d-912666c5ce61','/dev/vdc','2026-01-20 14:58:36','2026-01-20 14:59:03','rw','detached','{\"name\": \"volumes/volume-0d487092-de99-40b0-be3f-425947d7010c\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"0d487092-de99-40b0-be3f-425947d7010c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"aa9114da-45ac-4223-b30c-7a489822200c\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1821ea3dc03d\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"870b1f1c-f19c-477b-b282-ee6eeba50974\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2026-01-20 15:08:26','2026-01-20 15:09:00','2026-01-20 15:09:00',1,'ac014952-2475-4e81-98c3-d3d0118a657a','658f5854-e66e-4c02-a707-dcb4f1727205','compute-0.ctlplane.example.com','9f36f762-4fcd-4996-a347-43e8704458c9','/dev/vda','2026-01-20 15:08:28','2026-01-20 15:09:00','rw','detached','{\"name\": \"volumes/volume-658f5854-e66e-4c02-a707-dcb4f1727205\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"658f5854-e66e-4c02-a707-dcb4f1727205\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"ac014952-2475-4e81-98c3-d3d0118a657a\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:228389a1f17e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"35085f33-1a27-41e3-805d-02c7ac6a1d7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-20 14:25:12','2026-01-20 14:25:52','2026-01-20 14:25:52',1,'ae236ab2-4596-49ae-ba58-ece541fcbf59','67ec3b5b-23d2-4f8a-84b0-4ee1bda588af','compute-1.ctlplane.example.com','85ec4052-1453-4c76-936e-bf76f2108416','/dev/vda','2026-01-20 14:25:13','2026-01-20 14:25:52','null','detached','{\"name\": \"volumes/volume-67ec3b5b-23d2-4f8a-84b0-4ee1bda588af\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"67ec3b5b-23d2-4f8a-84b0-4ee1bda588af\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"ae236ab2-4596-49ae-ba58-ece541fcbf59\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1821ea3dc03d\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"870b1f1c-f19c-477b-b282-ee6eeba50974\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2026-01-20 14:57:54','2026-01-20 14:58:20','2026-01-20 14:58:20',1,'b60b56a6-2e45-4be4-9be9-aed60a3c8da7','0668acc6-1fde-4609-addf-37a73f135900','compute-2.ctlplane.example.com','a9aa8bf0-76a1-45f7-bd38-a7b9f7d0b64f','/dev/vdc','2026-01-20 14:57:56','2026-01-20 14:58:20','rw','detached','{\"name\": \"volumes/volume-0668acc6-1fde-4609-addf-37a73f135900\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"0668acc6-1fde-4609-addf-37a73f135900\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"b60b56a6-2e45-4be4-9be9-aed60a3c8da7\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:f7e7b2e5d28e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"1190ec40-2b89-4358-8dec-733c5829fbed\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2026-01-20 15:14:36','2026-01-20 15:15:31','2026-01-20 15:15:31',1,'b71943fe-2a88-4bcf-8d86-3af9f4ede56c','4994c109-f7d8-4642-bf6a-2f796e3851ba','compute-1.ctlplane.example.com','185fbaf7-4372-4e7c-b053-df9c4022514f','/dev/vda','2026-01-20 15:14:39','2026-01-20 15:15:31','rw','detached','{\"name\": \"volumes/volume-4994c109-f7d8-4642-bf6a-2f796e3851ba\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"4994c109-f7d8-4642-bf6a-2f796e3851ba\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"b71943fe-2a88-4bcf-8d86-3af9f4ede56c\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1821ea3dc03d\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"870b1f1c-f19c-477b-b282-ee6eeba50974\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-20 15:15:18','2026-01-20 15:16:19','2026-01-20 15:16:19',1,'b874ec4a-e334-4a3a-9131-ace7a891cf94','933c5c7a-f496-4bcc-b304-68156c235fe5','compute-2.ctlplane.example.com','b3504af3-390e-4ab0-8af6-15749a887d8f','/dev/vdb','2026-01-20 15:15:21','2026-01-20 15:16:19','rw','detached','{\"name\": \"volumes/volume-933c5c7a-f496-4bcc-b304-68156c235fe5\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"933c5c7a-f496-4bcc-b304-68156c235fe5\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"b874ec4a-e334-4a3a-9131-ace7a891cf94\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:f7e7b2e5d28e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"1190ec40-2b89-4358-8dec-733c5829fbed\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 14:57:39','2026-01-20 14:59:54','2026-01-20 14:59:54',1,'b8b8cc31-54c0-4f4d-80cc-6fca4e9cae9f','002e39e3-1bec-4033-aca2-f1428e495087','compute-1.ctlplane.example.com','b4c1468d-9914-426a-9464-c1167de53632','/dev/vda','2026-01-20 14:57:42','2026-01-20 14:59:54','rw','detached','{\"name\": \"volumes/volume-002e39e3-1bec-4033-aca2-f1428e495087\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"002e39e3-1bec-4033-aca2-f1428e495087\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"b8b8cc31-54c0-4f4d-80cc-6fca4e9cae9f\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1821ea3dc03d\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"870b1f1c-f19c-477b-b282-ee6eeba50974\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-20 15:13:41','2026-01-20 15:15:42','2026-01-20 15:15:42',1,'ba0da680-f438-4117-8180-9febfc710658','670aaaab-6a81-487d-a346-d03d445d8abe','compute-0.ctlplane.example.com','5380c3d8-edb4-4366-85ab-3dc76ecc1f43','/dev/vda','2026-01-20 15:13:44','2026-01-20 15:15:42','rw','detached','{\"name\": \"volumes/volume-670aaaab-6a81-487d-a346-d03d445d8abe\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"670aaaab-6a81-487d-a346-d03d445d8abe\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"ba0da680-f438-4117-8180-9febfc710658\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:228389a1f17e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"35085f33-1a27-41e3-805d-02c7ac6a1d7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-20 14:49:20','2026-01-20 14:51:07','2026-01-20 14:51:07',1,'bb01cd80-4d51-458e-a034-095eecb4b63c','25d4c4a0-3582-454d-9d4a-312b5c351d9d','compute-2.ctlplane.example.com','f444ccf6-5adb-489a-b174-7450017a351b','/dev/vdb','2026-01-20 14:49:30','2026-01-20 14:51:07','rw','detached','{\"name\": \"volumes/volume-25d4c4a0-3582-454d-9d4a-312b5c351d9d\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"25d4c4a0-3582-454d-9d4a-312b5c351d9d\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"bb01cd80-4d51-458e-a034-095eecb4b63c\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:f7e7b2e5d28e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"1190ec40-2b89-4358-8dec-733c5829fbed\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 15:05:52','2026-01-20 15:05:57','2026-01-20 15:05:57',1,'c023db9a-8197-4b91-bb70-8b3b1d00be58','4a621494-2aaf-461c-b7c1-05665913aaf9','compute-1.ctlplane.example.com','33ba7a73-3233-40a3-a49a-e5bbd604dc3c','/dev/vdb','2026-01-20 15:05:53','2026-01-20 15:05:57','rw','detached','{\"name\": \"volumes/volume-4a621494-2aaf-461c-b7c1-05665913aaf9\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"4a621494-2aaf-461c-b7c1-05665913aaf9\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"c023db9a-8197-4b91-bb70-8b3b1d00be58\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1821ea3dc03d\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"870b1f1c-f19c-477b-b282-ee6eeba50974\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 15:13:07','2026-01-20 15:13:37','2026-01-20 15:13:37',1,'c84052e2-80a5-4b07-a114-b125b84e1168','670aaaab-6a81-487d-a346-d03d445d8abe','compute-2.ctlplane.example.com','389ff8e0-c114-4960-9561-f6ffef743efa','/dev/vda','2026-01-20 15:13:10','2026-01-20 15:13:37','rw','detached','{\"name\": \"volumes/volume-670aaaab-6a81-487d-a346-d03d445d8abe\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"670aaaab-6a81-487d-a346-d03d445d8abe\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"c84052e2-80a5-4b07-a114-b125b84e1168\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:f7e7b2e5d28e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"1190ec40-2b89-4358-8dec-733c5829fbed\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-20 14:59:18','2026-01-20 14:59:37','2026-01-20 14:59:37',1,'c891cf33-bcd1-4101-99a6-243f9f47c95b','ab9a0bc3-5c61-456d-9fc8-3cb8ce358e66','compute-1.ctlplane.example.com','b4c1468d-9914-426a-9464-c1167de53632','/dev/vdc','2026-01-20 14:59:20','2026-01-20 14:59:37','rw','detached','{\"name\": \"volumes/volume-ab9a0bc3-5c61-456d-9fc8-3cb8ce358e66\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"ab9a0bc3-5c61-456d-9fc8-3cb8ce358e66\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"c891cf33-bcd1-4101-99a6-243f9f47c95b\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1821ea3dc03d\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"870b1f1c-f19c-477b-b282-ee6eeba50974\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2026-01-20 14:46:36','2026-01-20 14:46:53','2026-01-20 14:46:53',1,'c9861cd5-6ebe-4ef9-bc30-869a54cc88ab','aab03340-0e79-412e-a963-e216832603c4','compute-1.ctlplane.example.com','5f56b3e9-af2b-4934-8184-6257994c6b6a','/dev/vdb','2026-01-20 14:46:41','2026-01-20 14:46:53','rw','detached','{\"name\": \"volumes/volume-aab03340-0e79-412e-a963-e216832603c4\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"aab03340-0e79-412e-a963-e216832603c4\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"c9861cd5-6ebe-4ef9-bc30-869a54cc88ab\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1821ea3dc03d\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"870b1f1c-f19c-477b-b282-ee6eeba50974\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 15:09:29','2026-01-20 15:10:23','2026-01-20 15:10:23',1,'ce0e8f37-e6e6-4da1-81ab-5ab109435e13','7d67106f-2f4c-4925-94d7-b60a4418b999','compute-2.ctlplane.example.com','f2e5fbe3-6cd4-45e7-a3ba-50021d42e4f1','/dev/vdb','2026-01-20 15:09:30','2026-01-20 15:10:23','rw','detached','{\"name\": \"volumes/volume-7d67106f-2f4c-4925-94d7-b60a4418b999\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"7d67106f-2f4c-4925-94d7-b60a4418b999\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"ce0e8f37-e6e6-4da1-81ab-5ab109435e13\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:f7e7b2e5d28e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"1190ec40-2b89-4358-8dec-733c5829fbed\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 15:11:58','2026-01-20 15:12:33','2026-01-20 15:12:33',1,'d1f240f5-8538-43ab-a9bf-fe0f26d73875','8692e9bd-7163-4f35-a28b-8a31b1691fc8','compute-0.ctlplane.example.com','cbccef94-6ebf-4050-9b57-31486efe9e8f','/dev/vda','2026-01-20 15:11:59','2026-01-20 15:12:33','rw','detached','{\"name\": \"volumes/volume-8692e9bd-7163-4f35-a28b-8a31b1691fc8\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"8692e9bd-7163-4f35-a28b-8a31b1691fc8\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"d1f240f5-8538-43ab-a9bf-fe0f26d73875\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:228389a1f17e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"35085f33-1a27-41e3-805d-02c7ac6a1d7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-20 14:53:41','2026-01-20 14:54:31','2026-01-20 14:54:31',1,'d9b595f1-88ea-494e-bc6e-d959c2d6b8eb','5f6a803f-d232-4e97-9965-ece0139e0fda','compute-1.ctlplane.example.com','baada610-f563-4c97-89a9-56eba792c352','/dev/vdb','2026-01-20 14:53:42','2026-01-20 14:54:31','rw','detached','{\"name\": \"volumes/volume-5f6a803f-d232-4e97-9965-ece0139e0fda\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"5f6a803f-d232-4e97-9965-ece0139e0fda\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"d9b595f1-88ea-494e-bc6e-d959c2d6b8eb\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1821ea3dc03d\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"870b1f1c-f19c-477b-b282-ee6eeba50974\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 15:20:59','2026-01-20 15:21:03','2026-01-20 15:21:03',1,'dc7fe8a9-25f2-4eb7-8845-f59506394b39','f458dd1d-0a83-4853-b1f9-6b4923a44988','compute-1.ctlplane.example.com','7a53c9b1-e64b-4a31-897a-bbe7d964cf45','/dev/vdb','2026-01-20 15:21:01','2026-01-20 15:21:03','rw','detached','{\"name\": \"volumes/volume-f458dd1d-0a83-4853-b1f9-6b4923a44988\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"f458dd1d-0a83-4853-b1f9-6b4923a44988\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"dc7fe8a9-25f2-4eb7-8845-f59506394b39\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1821ea3dc03d\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"870b1f1c-f19c-477b-b282-ee6eeba50974\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 15:05:20','2026-01-20 15:05:31','2026-01-20 15:05:31',1,'de3ef725-be5d-49bc-982b-c687c272bd73','d93c7cb1-0f58-41fe-b846-7d4d85545927','compute-2.ctlplane.example.com','3e59fbab-2129-45b7-8fb1-997b2ccede64','/dev/vdb','2026-01-20 15:05:21','2026-01-20 15:05:31','rw','detached','{\"name\": \"volumes/volume-d93c7cb1-0f58-41fe-b846-7d4d85545927\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"d93c7cb1-0f58-41fe-b846-7d4d85545927\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"de3ef725-be5d-49bc-982b-c687c272bd73\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:f7e7b2e5d28e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"1190ec40-2b89-4358-8dec-733c5829fbed\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 15:06:58','2026-01-20 15:07:03','2026-01-20 15:07:03',1,'dea25cce-bddc-4c9f-bce3-c68d03f0834f','44e852b3-daf0-4085-aca9-bb61206f2ff9','compute-0.ctlplane.example.com','0c2c1ffa-3cdc-4edb-9a81-b38cfdc7cf04','/dev/vdb','2026-01-20 15:07:00','2026-01-20 15:07:03','rw','detached','{\"name\": \"volumes/volume-44e852b3-daf0-4085-aca9-bb61206f2ff9\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"44e852b3-daf0-4085-aca9-bb61206f2ff9\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"dea25cce-bddc-4c9f-bce3-c68d03f0834f\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:228389a1f17e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"35085f33-1a27-41e3-805d-02c7ac6a1d7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 14:39:03','2026-01-20 14:40:21','2026-01-20 14:40:21',1,'e6db4319-d483-4b50-84db-2afa00acac8f','8e23d5c7-a222-4e45-8e31-6afe42582e8d','compute-2.ctlplane.example.com','795b0a95-448b-49b1-80cb-a18e84101480','/dev/vda','2026-01-20 14:39:08','2026-01-20 14:40:21','rw','detached','{\"name\": \"volumes/volume-8e23d5c7-a222-4e45-8e31-6afe42582e8d\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"8e23d5c7-a222-4e45-8e31-6afe42582e8d\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"e6db4319-d483-4b50-84db-2afa00acac8f\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:f7e7b2e5d28e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"1190ec40-2b89-4358-8dec-733c5829fbed\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-20 15:13:22','2026-01-20 15:17:52','2026-01-20 15:17:52',1,'e7dd1bf8-e492-41ff-9f83-dc8c2cd2340c','c46398b2-4b96-4ab6-ac9b-93d7ea349e92','compute-0.ctlplane.example.com','e79c0704-f95e-422f-9c25-ed35fca7cb7c','/dev/vda','2026-01-20 15:13:25','2026-01-20 15:17:52','rw','detached','{\"name\": \"volumes/volume-c46398b2-4b96-4ab6-ac9b-93d7ea349e92\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"c46398b2-4b96-4ab6-ac9b-93d7ea349e92\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"e7dd1bf8-e492-41ff-9f83-dc8c2cd2340c\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:228389a1f17e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"35085f33-1a27-41e3-805d-02c7ac6a1d7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-20 14:55:28','2026-01-20 14:55:44','2026-01-20 14:55:44',1,'eea3000c-bb00-408a-8f86-bead31fa452f','f3a427b1-0e50-45b1-a975-3d7aabd0195a','compute-0.ctlplane.example.com','b346e1ba-9e83-4e7f-bc03-c327d3e4173b','/dev/vdb','2026-01-20 14:55:33','2026-01-20 14:55:44','rw','detached','{\"name\": \"volumes/volume-f3a427b1-0e50-45b1-a975-3d7aabd0195a\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"f3a427b1-0e50-45b1-a975-3d7aabd0195a\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"eea3000c-bb00-408a-8f86-bead31fa452f\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:228389a1f17e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"35085f33-1a27-41e3-805d-02c7ac6a1d7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-20 15:10:02','2026-01-20 15:10:22','2026-01-20 15:10:22',1,'f4780d3e-d038-4466-9222-3d7730703f45','ccb7c984-4606-40ef-8fcd-a902f5382dee','compute-1.ctlplane.example.com','9e852872-788c-4dac-b7fb-d76d67e7a84f','/dev/vda','2026-01-20 15:10:05','2026-01-20 15:10:22','rw','detached','{\"name\": \"volumes/volume-ccb7c984-4606-40ef-8fcd-a902f5382dee\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"ccb7c984-4606-40ef-8fcd-a902f5382dee\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": true, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"f4780d3e-d038-4466-9222-3d7730703f45\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:1821ea3dc03d\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"870b1f1c-f19c-477b-b282-ee6eeba50974\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-20 15:07:32','2026-01-20 15:07:40','2026-01-20 15:07:40',1,'fc82522d-8641-4a39-b1dc-3d17b874cd70','522e3761-1020-4931-8036-475bf6ddd148','compute-0.ctlplane.example.com','26cf4955-374b-4e19-992f-e9348d555edf','/dev/vdb','2026-01-20 15:07:33','2026-01-20 15:07:40','rw','detached','{\"name\": \"volumes/volume-522e3761-1020-4931-8036-475bf6ddd148\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e399cf45-e6b6-5393-99f1-75c601d3f188\", \"volume_id\": \"522e3761-1020-4931-8036-475bf6ddd148\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": true, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"fc82522d-8641-4a39-b1dc-3d17b874cd70\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:228389a1f17e\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"35085f33-1a27-41e3-805d-02c7ac6a1d7f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}');
/*!40000 ALTER TABLE `volume_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_glance_metadata`
--

DROP TABLE IF EXISTS `volume_glance_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_glance_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_glance_metadata_volume_id` (`volume_id`),
  KEY `ix_volume_glance_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `volume_glance_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `volume_glance_metadata_ibfk_2` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=267 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_glance_metadata`
--

LOCK TABLES `volume_glance_metadata` WRITE;
/*!40000 ALTER TABLE `volume_glance_metadata` DISABLE KEYS */;
INSERT INTO `volume_glance_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `snapshot_id`, `key`, `value`) VALUES ('2026-01-20 14:24:34',NULL,'2026-01-20 14:26:03',1,1,'67ec3b5b-23d2-4f8a-84b0-4ee1bda588af',NULL,'signature_verified','False'),('2026-01-20 14:24:40',NULL,'2026-01-20 14:26:03',1,2,'67ec3b5b-23d2-4f8a-84b0-4ee1bda588af',NULL,'hw_rng_model','virtio'),('2026-01-20 14:24:40',NULL,'2026-01-20 14:26:03',1,3,'67ec3b5b-23d2-4f8a-84b0-4ee1bda588af',NULL,'image_id','a32b3e07-16d8-46fd-9a7b-c242c432fcf9'),('2026-01-20 14:24:40',NULL,'2026-01-20 14:26:03',1,4,'67ec3b5b-23d2-4f8a-84b0-4ee1bda588af',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-20 14:24:40',NULL,'2026-01-20 14:26:03',1,5,'67ec3b5b-23d2-4f8a-84b0-4ee1bda588af',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-20 14:24:40',NULL,'2026-01-20 14:26:03',1,6,'67ec3b5b-23d2-4f8a-84b0-4ee1bda588af',NULL,'container_format','bare'),('2026-01-20 14:24:40',NULL,'2026-01-20 14:26:03',1,7,'67ec3b5b-23d2-4f8a-84b0-4ee1bda588af',NULL,'disk_format','qcow2'),('2026-01-20 14:24:40',NULL,'2026-01-20 14:26:03',1,8,'67ec3b5b-23d2-4f8a-84b0-4ee1bda588af',NULL,'min_disk','0'),('2026-01-20 14:24:40',NULL,'2026-01-20 14:26:03',1,9,'67ec3b5b-23d2-4f8a-84b0-4ee1bda588af',NULL,'min_ram','0'),('2026-01-20 14:24:40',NULL,'2026-01-20 14:26:03',1,10,'67ec3b5b-23d2-4f8a-84b0-4ee1bda588af',NULL,'size','21430272'),('2026-01-20 14:28:02',NULL,'2026-01-20 14:29:13',1,11,'47e883f3-6efe-40b3-be28-6c01525dfc0c',NULL,'signature_verified','False'),('2026-01-20 14:28:09',NULL,'2026-01-20 14:29:13',1,12,'47e883f3-6efe-40b3-be28-6c01525dfc0c',NULL,'hw_rng_model','virtio'),('2026-01-20 14:28:09',NULL,'2026-01-20 14:29:13',1,13,'47e883f3-6efe-40b3-be28-6c01525dfc0c',NULL,'image_id','a32b3e07-16d8-46fd-9a7b-c242c432fcf9'),('2026-01-20 14:28:09',NULL,'2026-01-20 14:29:13',1,14,'47e883f3-6efe-40b3-be28-6c01525dfc0c',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-20 14:28:09',NULL,'2026-01-20 14:29:13',1,15,'47e883f3-6efe-40b3-be28-6c01525dfc0c',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-20 14:28:09',NULL,'2026-01-20 14:29:13',1,16,'47e883f3-6efe-40b3-be28-6c01525dfc0c',NULL,'container_format','bare'),('2026-01-20 14:28:09',NULL,'2026-01-20 14:29:13',1,17,'47e883f3-6efe-40b3-be28-6c01525dfc0c',NULL,'disk_format','qcow2'),('2026-01-20 14:28:09',NULL,'2026-01-20 14:29:13',1,18,'47e883f3-6efe-40b3-be28-6c01525dfc0c',NULL,'min_disk','0'),('2026-01-20 14:28:09',NULL,'2026-01-20 14:29:13',1,19,'47e883f3-6efe-40b3-be28-6c01525dfc0c',NULL,'min_ram','0'),('2026-01-20 14:28:09',NULL,'2026-01-20 14:29:13',1,20,'47e883f3-6efe-40b3-be28-6c01525dfc0c',NULL,'size','21430272'),('2026-01-20 14:38:34',NULL,'2026-01-20 14:40:36',1,21,'8e23d5c7-a222-4e45-8e31-6afe42582e8d',NULL,'signature_verified','False'),('2026-01-20 14:38:38',NULL,'2026-01-20 14:40:36',1,22,'8e23d5c7-a222-4e45-8e31-6afe42582e8d',NULL,'hw_rng_model','virtio'),('2026-01-20 14:38:38',NULL,'2026-01-20 14:40:36',1,23,'8e23d5c7-a222-4e45-8e31-6afe42582e8d',NULL,'image_id','a32b3e07-16d8-46fd-9a7b-c242c432fcf9'),('2026-01-20 14:38:38',NULL,'2026-01-20 14:40:36',1,24,'8e23d5c7-a222-4e45-8e31-6afe42582e8d',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-20 14:38:38',NULL,'2026-01-20 14:40:36',1,25,'8e23d5c7-a222-4e45-8e31-6afe42582e8d',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-20 14:38:38',NULL,'2026-01-20 14:40:36',1,26,'8e23d5c7-a222-4e45-8e31-6afe42582e8d',NULL,'container_format','bare'),('2026-01-20 14:38:38',NULL,'2026-01-20 14:40:36',1,27,'8e23d5c7-a222-4e45-8e31-6afe42582e8d',NULL,'disk_format','qcow2'),('2026-01-20 14:38:38',NULL,'2026-01-20 14:40:36',1,28,'8e23d5c7-a222-4e45-8e31-6afe42582e8d',NULL,'min_disk','0'),('2026-01-20 14:38:38',NULL,'2026-01-20 14:40:36',1,29,'8e23d5c7-a222-4e45-8e31-6afe42582e8d',NULL,'min_ram','0'),('2026-01-20 14:38:38',NULL,'2026-01-20 14:40:36',1,30,'8e23d5c7-a222-4e45-8e31-6afe42582e8d',NULL,'size','21430272'),('2026-01-20 14:44:31',NULL,'2026-01-20 14:45:30',1,31,'2441d1fb-fc23-4a6d-b88d-4d82b035b65f',NULL,'signature_verified','False'),('2026-01-20 14:44:36',NULL,'2026-01-20 14:45:30',1,32,'2441d1fb-fc23-4a6d-b88d-4d82b035b65f',NULL,'hw_rng_model','virtio'),('2026-01-20 14:44:36',NULL,'2026-01-20 14:45:30',1,33,'2441d1fb-fc23-4a6d-b88d-4d82b035b65f',NULL,'image_id','a32b3e07-16d8-46fd-9a7b-c242c432fcf9'),('2026-01-20 14:44:36',NULL,'2026-01-20 14:45:30',1,34,'2441d1fb-fc23-4a6d-b88d-4d82b035b65f',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-20 14:44:36',NULL,'2026-01-20 14:45:30',1,35,'2441d1fb-fc23-4a6d-b88d-4d82b035b65f',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-20 14:44:36',NULL,'2026-01-20 14:45:30',1,36,'2441d1fb-fc23-4a6d-b88d-4d82b035b65f',NULL,'container_format','bare'),('2026-01-20 14:44:36',NULL,'2026-01-20 14:45:30',1,37,'2441d1fb-fc23-4a6d-b88d-4d82b035b65f',NULL,'disk_format','qcow2'),('2026-01-20 14:44:36',NULL,'2026-01-20 14:45:30',1,38,'2441d1fb-fc23-4a6d-b88d-4d82b035b65f',NULL,'min_disk','0'),('2026-01-20 14:44:36',NULL,'2026-01-20 14:45:30',1,39,'2441d1fb-fc23-4a6d-b88d-4d82b035b65f',NULL,'min_ram','0'),('2026-01-20 14:44:36',NULL,'2026-01-20 14:45:30',1,40,'2441d1fb-fc23-4a6d-b88d-4d82b035b65f',NULL,'size','21430272'),('2026-01-20 14:47:23',NULL,'2026-01-20 14:48:41',1,41,'9219aafd-6c66-4f38-9927-85b54b4175ae',NULL,'signature_verified','False'),('2026-01-20 14:47:27',NULL,'2026-01-20 14:48:41',1,42,'9219aafd-6c66-4f38-9927-85b54b4175ae',NULL,'hw_rng_model','virtio'),('2026-01-20 14:47:27',NULL,'2026-01-20 14:48:41',1,43,'9219aafd-6c66-4f38-9927-85b54b4175ae',NULL,'image_id','a32b3e07-16d8-46fd-9a7b-c242c432fcf9'),('2026-01-20 14:47:27',NULL,'2026-01-20 14:48:41',1,44,'9219aafd-6c66-4f38-9927-85b54b4175ae',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-20 14:47:27',NULL,'2026-01-20 14:48:41',1,45,'9219aafd-6c66-4f38-9927-85b54b4175ae',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-20 14:47:27',NULL,'2026-01-20 14:48:41',1,46,'9219aafd-6c66-4f38-9927-85b54b4175ae',NULL,'container_format','bare'),('2026-01-20 14:47:27',NULL,'2026-01-20 14:48:41',1,47,'9219aafd-6c66-4f38-9927-85b54b4175ae',NULL,'disk_format','qcow2'),('2026-01-20 14:47:27',NULL,'2026-01-20 14:48:41',1,48,'9219aafd-6c66-4f38-9927-85b54b4175ae',NULL,'min_disk','0'),('2026-01-20 14:47:27',NULL,'2026-01-20 14:48:41',1,49,'9219aafd-6c66-4f38-9927-85b54b4175ae',NULL,'min_ram','0'),('2026-01-20 14:47:27',NULL,'2026-01-20 14:48:41',1,50,'9219aafd-6c66-4f38-9927-85b54b4175ae',NULL,'size','21430272'),('2026-01-20 14:48:42',NULL,'2026-01-20 14:51:21',1,51,'8cd2ec74-aafb-4e12-a845-44b6fe96ba18',NULL,'signature_verified','False'),('2026-01-20 14:48:46',NULL,'2026-01-20 14:51:21',1,52,'8cd2ec74-aafb-4e12-a845-44b6fe96ba18',NULL,'hw_rng_model','virtio'),('2026-01-20 14:48:46',NULL,'2026-01-20 14:51:21',1,53,'8cd2ec74-aafb-4e12-a845-44b6fe96ba18',NULL,'image_id','a32b3e07-16d8-46fd-9a7b-c242c432fcf9'),('2026-01-20 14:48:46',NULL,'2026-01-20 14:51:21',1,54,'8cd2ec74-aafb-4e12-a845-44b6fe96ba18',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-20 14:48:46',NULL,'2026-01-20 14:51:21',1,55,'8cd2ec74-aafb-4e12-a845-44b6fe96ba18',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-20 14:48:46',NULL,'2026-01-20 14:51:21',1,56,'8cd2ec74-aafb-4e12-a845-44b6fe96ba18',NULL,'container_format','bare'),('2026-01-20 14:48:46',NULL,'2026-01-20 14:51:21',1,57,'8cd2ec74-aafb-4e12-a845-44b6fe96ba18',NULL,'disk_format','qcow2'),('2026-01-20 14:48:46',NULL,'2026-01-20 14:51:21',1,58,'8cd2ec74-aafb-4e12-a845-44b6fe96ba18',NULL,'min_disk','0'),('2026-01-20 14:48:46',NULL,'2026-01-20 14:51:21',1,59,'8cd2ec74-aafb-4e12-a845-44b6fe96ba18',NULL,'min_ram','0'),('2026-01-20 14:48:46',NULL,'2026-01-20 14:51:21',1,60,'8cd2ec74-aafb-4e12-a845-44b6fe96ba18',NULL,'size','21430272'),('2026-01-20 14:53:03',NULL,'2026-01-20 14:54:00',1,61,'b687fb44-6160-427b-b91a-091715876a58',NULL,'signature_verified','False'),('2026-01-20 14:53:08',NULL,'2026-01-20 14:54:00',1,62,'b687fb44-6160-427b-b91a-091715876a58',NULL,'hw_rng_model','virtio'),('2026-01-20 14:53:08',NULL,'2026-01-20 14:54:00',1,63,'b687fb44-6160-427b-b91a-091715876a58',NULL,'image_id','a32b3e07-16d8-46fd-9a7b-c242c432fcf9'),('2026-01-20 14:53:08',NULL,'2026-01-20 14:54:00',1,64,'b687fb44-6160-427b-b91a-091715876a58',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-20 14:53:08',NULL,'2026-01-20 14:54:00',1,65,'b687fb44-6160-427b-b91a-091715876a58',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-20 14:53:08',NULL,'2026-01-20 14:54:00',1,66,'b687fb44-6160-427b-b91a-091715876a58',NULL,'container_format','bare'),('2026-01-20 14:53:08',NULL,'2026-01-20 14:54:00',1,67,'b687fb44-6160-427b-b91a-091715876a58',NULL,'disk_format','qcow2'),('2026-01-20 14:53:08',NULL,'2026-01-20 14:54:00',1,68,'b687fb44-6160-427b-b91a-091715876a58',NULL,'min_disk','0'),('2026-01-20 14:53:08',NULL,'2026-01-20 14:54:00',1,69,'b687fb44-6160-427b-b91a-091715876a58',NULL,'min_ram','0'),('2026-01-20 14:53:08',NULL,'2026-01-20 14:54:00',1,70,'b687fb44-6160-427b-b91a-091715876a58',NULL,'size','21430272'),('2026-01-20 14:54:00',NULL,'2026-01-20 14:54:42',1,71,'b687fb44-6160-427b-b91a-091715876a58',NULL,'hw_rng_model','virtio'),('2026-01-20 14:54:00',NULL,'2026-01-20 14:54:42',1,72,'b687fb44-6160-427b-b91a-091715876a58',NULL,'image_id','26699514-f465-4b50-98b7-36f2cfc6a308'),('2026-01-20 14:54:00',NULL,'2026-01-20 14:54:42',1,73,'b687fb44-6160-427b-b91a-091715876a58',NULL,'image_name','cirros-0.6.2-x86_64-disk.img_alt'),('2026-01-20 14:54:00',NULL,'2026-01-20 14:54:42',1,74,'b687fb44-6160-427b-b91a-091715876a58',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-20 14:54:00',NULL,'2026-01-20 14:54:42',1,75,'b687fb44-6160-427b-b91a-091715876a58',NULL,'container_format','bare'),('2026-01-20 14:54:00',NULL,'2026-01-20 14:54:42',1,76,'b687fb44-6160-427b-b91a-091715876a58',NULL,'disk_format','qcow2'),('2026-01-20 14:54:00',NULL,'2026-01-20 14:54:42',1,77,'b687fb44-6160-427b-b91a-091715876a58',NULL,'min_disk','0'),('2026-01-20 14:54:00',NULL,'2026-01-20 14:54:42',1,78,'b687fb44-6160-427b-b91a-091715876a58',NULL,'min_ram','0'),('2026-01-20 14:54:00',NULL,'2026-01-20 14:54:42',1,79,'b687fb44-6160-427b-b91a-091715876a58',NULL,'size','21430272'),('2026-01-20 14:57:24',NULL,'2026-01-20 15:00:06',1,80,'94858b1a-370f-4ee8-b017-647fe5082382',NULL,'signature_verified','False'),('2026-01-20 14:57:26',NULL,'2026-01-20 15:00:05',1,81,'5728e8f8-a711-41d5-aa04-a1d9faada8d9',NULL,'signature_verified','False'),('2026-01-20 14:57:28',NULL,'2026-01-20 15:00:04',1,82,'002e39e3-1bec-4033-aca2-f1428e495087',NULL,'signature_verified','False'),('2026-01-20 14:57:29',NULL,'2026-01-20 15:00:06',1,83,'94858b1a-370f-4ee8-b017-647fe5082382',NULL,'image_id','099d94f6-c2d2-4c82-ab5e-5cf0c5d78fac'),('2026-01-20 14:57:29',NULL,'2026-01-20 15:00:06',1,84,'94858b1a-370f-4ee8-b017-647fe5082382',NULL,'image_name','tempest-scenario-img--1111569377'),('2026-01-20 14:57:29',NULL,'2026-01-20 15:00:06',1,85,'94858b1a-370f-4ee8-b017-647fe5082382',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-20 14:57:29',NULL,'2026-01-20 15:00:06',1,86,'94858b1a-370f-4ee8-b017-647fe5082382',NULL,'container_format','bare'),('2026-01-20 14:57:29',NULL,'2026-01-20 15:00:06',1,87,'94858b1a-370f-4ee8-b017-647fe5082382',NULL,'disk_format','qcow2'),('2026-01-20 14:57:29',NULL,'2026-01-20 15:00:06',1,88,'94858b1a-370f-4ee8-b017-647fe5082382',NULL,'min_disk','0'),('2026-01-20 14:57:29',NULL,'2026-01-20 15:00:06',1,89,'94858b1a-370f-4ee8-b017-647fe5082382',NULL,'min_ram','0'),('2026-01-20 14:57:29',NULL,'2026-01-20 15:00:06',1,90,'94858b1a-370f-4ee8-b017-647fe5082382',NULL,'size','21430272'),('2026-01-20 14:57:30',NULL,'2026-01-20 15:00:05',1,91,'5728e8f8-a711-41d5-aa04-a1d9faada8d9',NULL,'image_id','099d94f6-c2d2-4c82-ab5e-5cf0c5d78fac'),('2026-01-20 14:57:30',NULL,'2026-01-20 15:00:05',1,92,'5728e8f8-a711-41d5-aa04-a1d9faada8d9',NULL,'image_name','tempest-scenario-img--1111569377'),('2026-01-20 14:57:30',NULL,'2026-01-20 15:00:05',1,93,'5728e8f8-a711-41d5-aa04-a1d9faada8d9',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-20 14:57:30',NULL,'2026-01-20 15:00:05',1,94,'5728e8f8-a711-41d5-aa04-a1d9faada8d9',NULL,'container_format','bare'),('2026-01-20 14:57:30',NULL,'2026-01-20 15:00:05',1,95,'5728e8f8-a711-41d5-aa04-a1d9faada8d9',NULL,'disk_format','qcow2'),('2026-01-20 14:57:30',NULL,'2026-01-20 15:00:05',1,96,'5728e8f8-a711-41d5-aa04-a1d9faada8d9',NULL,'min_disk','0'),('2026-01-20 14:57:30',NULL,'2026-01-20 15:00:05',1,97,'5728e8f8-a711-41d5-aa04-a1d9faada8d9',NULL,'min_ram','0'),('2026-01-20 14:57:30',NULL,'2026-01-20 15:00:05',1,98,'5728e8f8-a711-41d5-aa04-a1d9faada8d9',NULL,'size','21430272'),('2026-01-20 14:57:32',NULL,'2026-01-20 15:00:04',1,99,'002e39e3-1bec-4033-aca2-f1428e495087',NULL,'image_id','099d94f6-c2d2-4c82-ab5e-5cf0c5d78fac'),('2026-01-20 14:57:32',NULL,'2026-01-20 15:00:04',1,100,'002e39e3-1bec-4033-aca2-f1428e495087',NULL,'image_name','tempest-scenario-img--1111569377'),('2026-01-20 14:57:32',NULL,'2026-01-20 15:00:04',1,101,'002e39e3-1bec-4033-aca2-f1428e495087',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-20 14:57:32',NULL,'2026-01-20 15:00:04',1,102,'002e39e3-1bec-4033-aca2-f1428e495087',NULL,'container_format','bare'),('2026-01-20 14:57:32',NULL,'2026-01-20 15:00:04',1,103,'002e39e3-1bec-4033-aca2-f1428e495087',NULL,'disk_format','qcow2'),('2026-01-20 14:57:32',NULL,'2026-01-20 15:00:04',1,104,'002e39e3-1bec-4033-aca2-f1428e495087',NULL,'min_disk','0'),('2026-01-20 14:57:32',NULL,'2026-01-20 15:00:04',1,105,'002e39e3-1bec-4033-aca2-f1428e495087',NULL,'min_ram','0'),('2026-01-20 14:57:32',NULL,'2026-01-20 15:00:04',1,106,'002e39e3-1bec-4033-aca2-f1428e495087',NULL,'size','21430272'),('2026-01-20 15:03:57',NULL,NULL,0,107,'9d237554-9581-4577-897a-3907d38a0cb3',NULL,'signature_verified','False'),('2026-01-20 15:04:07',NULL,NULL,0,108,'9d237554-9581-4577-897a-3907d38a0cb3',NULL,'hw_rng_model','virtio'),('2026-01-20 15:04:07',NULL,NULL,0,109,'9d237554-9581-4577-897a-3907d38a0cb3',NULL,'image_id','a32b3e07-16d8-46fd-9a7b-c242c432fcf9'),('2026-01-20 15:04:07',NULL,NULL,0,110,'9d237554-9581-4577-897a-3907d38a0cb3',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-20 15:04:07',NULL,NULL,0,111,'9d237554-9581-4577-897a-3907d38a0cb3',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-20 15:04:07',NULL,NULL,0,112,'9d237554-9581-4577-897a-3907d38a0cb3',NULL,'container_format','bare'),('2026-01-20 15:04:07',NULL,NULL,0,113,'9d237554-9581-4577-897a-3907d38a0cb3',NULL,'disk_format','qcow2'),('2026-01-20 15:04:07',NULL,NULL,0,114,'9d237554-9581-4577-897a-3907d38a0cb3',NULL,'min_disk','0'),('2026-01-20 15:04:07',NULL,NULL,0,115,'9d237554-9581-4577-897a-3907d38a0cb3',NULL,'min_ram','0'),('2026-01-20 15:04:07',NULL,NULL,0,116,'9d237554-9581-4577-897a-3907d38a0cb3',NULL,'size','21430272'),('2026-01-20 15:05:25',NULL,'2026-01-20 15:07:12',1,117,'94300d81-b4ca-4c0a-9283-83b76826d40f',NULL,'signature_verified','False'),('2026-01-20 15:05:30',NULL,'2026-01-20 15:07:12',1,118,'94300d81-b4ca-4c0a-9283-83b76826d40f',NULL,'hw_rng_model','virtio'),('2026-01-20 15:05:30',NULL,'2026-01-20 15:07:12',1,119,'94300d81-b4ca-4c0a-9283-83b76826d40f',NULL,'image_id','a32b3e07-16d8-46fd-9a7b-c242c432fcf9'),('2026-01-20 15:05:30',NULL,'2026-01-20 15:07:12',1,120,'94300d81-b4ca-4c0a-9283-83b76826d40f',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-20 15:05:30',NULL,'2026-01-20 15:07:12',1,121,'94300d81-b4ca-4c0a-9283-83b76826d40f',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-20 15:05:30',NULL,'2026-01-20 15:07:12',1,122,'94300d81-b4ca-4c0a-9283-83b76826d40f',NULL,'container_format','bare'),('2026-01-20 15:05:30',NULL,'2026-01-20 15:07:12',1,123,'94300d81-b4ca-4c0a-9283-83b76826d40f',NULL,'disk_format','qcow2'),('2026-01-20 15:05:30',NULL,'2026-01-20 15:07:12',1,124,'94300d81-b4ca-4c0a-9283-83b76826d40f',NULL,'min_disk','0'),('2026-01-20 15:05:30',NULL,'2026-01-20 15:07:12',1,125,'94300d81-b4ca-4c0a-9283-83b76826d40f',NULL,'min_ram','0'),('2026-01-20 15:05:30',NULL,'2026-01-20 15:07:12',1,126,'94300d81-b4ca-4c0a-9283-83b76826d40f',NULL,'size','21430272'),('2026-01-20 15:08:05',NULL,'2026-01-20 15:09:06',1,127,'312280b4-90ae-42ad-9955-fa64a235a337',NULL,'signature_verified','False'),('2026-01-20 15:08:09',NULL,'2026-01-20 15:09:06',1,128,'312280b4-90ae-42ad-9955-fa64a235a337',NULL,'hw_rng_model','virtio'),('2026-01-20 15:08:09',NULL,'2026-01-20 15:09:06',1,129,'312280b4-90ae-42ad-9955-fa64a235a337',NULL,'image_id','a32b3e07-16d8-46fd-9a7b-c242c432fcf9'),('2026-01-20 15:08:09',NULL,'2026-01-20 15:09:06',1,130,'312280b4-90ae-42ad-9955-fa64a235a337',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-20 15:08:09',NULL,'2026-01-20 15:09:06',1,131,'312280b4-90ae-42ad-9955-fa64a235a337',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-20 15:08:09',NULL,'2026-01-20 15:09:06',1,132,'312280b4-90ae-42ad-9955-fa64a235a337',NULL,'container_format','bare'),('2026-01-20 15:08:09',NULL,'2026-01-20 15:09:06',1,133,'312280b4-90ae-42ad-9955-fa64a235a337',NULL,'disk_format','qcow2'),('2026-01-20 15:08:09',NULL,'2026-01-20 15:09:06',1,134,'312280b4-90ae-42ad-9955-fa64a235a337',NULL,'min_disk','0'),('2026-01-20 15:08:09',NULL,'2026-01-20 15:09:06',1,135,'312280b4-90ae-42ad-9955-fa64a235a337',NULL,'min_ram','0'),('2026-01-20 15:08:09',NULL,'2026-01-20 15:09:06',1,136,'312280b4-90ae-42ad-9955-fa64a235a337',NULL,'size','21430272'),('2026-01-20 15:08:20',NULL,'2026-01-20 15:09:05',1,137,'658f5854-e66e-4c02-a707-dcb4f1727205',NULL,'signature_verified','False'),('2026-01-20 15:08:21',NULL,'2026-01-20 15:09:05',1,138,'658f5854-e66e-4c02-a707-dcb4f1727205',NULL,'hw_rng_model','virtio'),('2026-01-20 15:08:21',NULL,'2026-01-20 15:09:05',1,139,'658f5854-e66e-4c02-a707-dcb4f1727205',NULL,'image_id','a32b3e07-16d8-46fd-9a7b-c242c432fcf9'),('2026-01-20 15:08:21',NULL,'2026-01-20 15:09:05',1,140,'658f5854-e66e-4c02-a707-dcb4f1727205',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-20 15:08:21',NULL,'2026-01-20 15:09:05',1,141,'658f5854-e66e-4c02-a707-dcb4f1727205',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-20 15:08:21',NULL,'2026-01-20 15:09:05',1,142,'658f5854-e66e-4c02-a707-dcb4f1727205',NULL,'container_format','bare'),('2026-01-20 15:08:21',NULL,'2026-01-20 15:09:05',1,143,'658f5854-e66e-4c02-a707-dcb4f1727205',NULL,'disk_format','qcow2'),('2026-01-20 15:08:21',NULL,'2026-01-20 15:09:05',1,144,'658f5854-e66e-4c02-a707-dcb4f1727205',NULL,'min_disk','0'),('2026-01-20 15:08:21',NULL,'2026-01-20 15:09:05',1,145,'658f5854-e66e-4c02-a707-dcb4f1727205',NULL,'min_ram','0'),('2026-01-20 15:08:21',NULL,'2026-01-20 15:09:05',1,146,'658f5854-e66e-4c02-a707-dcb4f1727205',NULL,'size','21430272'),('2026-01-20 15:10:30',NULL,'2026-01-20 15:11:01',1,147,'c2176e35-f749-46e4-b63a-1d086dd1705c',NULL,'signature_verified','False'),('2026-01-20 15:10:36',NULL,'2026-01-20 15:11:01',1,148,'c2176e35-f749-46e4-b63a-1d086dd1705c',NULL,'hw_rng_model','virtio'),('2026-01-20 15:10:36',NULL,'2026-01-20 15:11:01',1,149,'c2176e35-f749-46e4-b63a-1d086dd1705c',NULL,'image_id','a32b3e07-16d8-46fd-9a7b-c242c432fcf9'),('2026-01-20 15:10:36',NULL,'2026-01-20 15:11:01',1,150,'c2176e35-f749-46e4-b63a-1d086dd1705c',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-20 15:10:36',NULL,'2026-01-20 15:11:01',1,151,'c2176e35-f749-46e4-b63a-1d086dd1705c',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-20 15:10:36',NULL,'2026-01-20 15:11:01',1,152,'c2176e35-f749-46e4-b63a-1d086dd1705c',NULL,'container_format','bare'),('2026-01-20 15:10:36',NULL,'2026-01-20 15:11:01',1,153,'c2176e35-f749-46e4-b63a-1d086dd1705c',NULL,'disk_format','qcow2'),('2026-01-20 15:10:36',NULL,'2026-01-20 15:11:01',1,154,'c2176e35-f749-46e4-b63a-1d086dd1705c',NULL,'min_disk','0'),('2026-01-20 15:10:36',NULL,'2026-01-20 15:11:01',1,155,'c2176e35-f749-46e4-b63a-1d086dd1705c',NULL,'min_ram','0'),('2026-01-20 15:10:36',NULL,'2026-01-20 15:11:01',1,156,'c2176e35-f749-46e4-b63a-1d086dd1705c',NULL,'size','21430272'),('2026-01-20 15:10:38',NULL,'2026-01-20 15:11:00',1,157,NULL,'33f09854-2fbb-41ab-84ee-a1c4a1274b2b','signature_verified','False'),('2026-01-20 15:10:38',NULL,'2026-01-20 15:11:00',1,158,NULL,'33f09854-2fbb-41ab-84ee-a1c4a1274b2b','hw_rng_model','virtio'),('2026-01-20 15:10:38',NULL,'2026-01-20 15:11:00',1,159,NULL,'33f09854-2fbb-41ab-84ee-a1c4a1274b2b','image_id','a32b3e07-16d8-46fd-9a7b-c242c432fcf9'),('2026-01-20 15:10:38',NULL,'2026-01-20 15:11:00',1,160,NULL,'33f09854-2fbb-41ab-84ee-a1c4a1274b2b','image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-20 15:10:38',NULL,'2026-01-20 15:11:00',1,161,NULL,'33f09854-2fbb-41ab-84ee-a1c4a1274b2b','checksum','c8fc807773e5354afe61636071771906'),('2026-01-20 15:10:38',NULL,'2026-01-20 15:11:00',1,162,NULL,'33f09854-2fbb-41ab-84ee-a1c4a1274b2b','container_format','bare'),('2026-01-20 15:10:38',NULL,'2026-01-20 15:11:00',1,163,NULL,'33f09854-2fbb-41ab-84ee-a1c4a1274b2b','disk_format','qcow2'),('2026-01-20 15:10:38',NULL,'2026-01-20 15:11:00',1,164,NULL,'33f09854-2fbb-41ab-84ee-a1c4a1274b2b','min_disk','0'),('2026-01-20 15:10:38',NULL,'2026-01-20 15:11:00',1,165,NULL,'33f09854-2fbb-41ab-84ee-a1c4a1274b2b','min_ram','0'),('2026-01-20 15:10:38',NULL,'2026-01-20 15:11:00',1,166,NULL,'33f09854-2fbb-41ab-84ee-a1c4a1274b2b','size','21430272'),('2026-01-20 15:10:45',NULL,'2026-01-20 15:10:58',1,167,'f396a213-a7f4-434e-a290-c5d9278be4af',NULL,'signature_verified','False'),('2026-01-20 15:10:45',NULL,'2026-01-20 15:10:58',1,168,'f396a213-a7f4-434e-a290-c5d9278be4af',NULL,'hw_rng_model','virtio'),('2026-01-20 15:10:45',NULL,'2026-01-20 15:10:58',1,169,'f396a213-a7f4-434e-a290-c5d9278be4af',NULL,'image_id','a32b3e07-16d8-46fd-9a7b-c242c432fcf9'),('2026-01-20 15:10:45',NULL,'2026-01-20 15:10:58',1,170,'f396a213-a7f4-434e-a290-c5d9278be4af',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-20 15:10:45',NULL,'2026-01-20 15:10:58',1,171,'f396a213-a7f4-434e-a290-c5d9278be4af',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-20 15:10:45',NULL,'2026-01-20 15:10:58',1,172,'f396a213-a7f4-434e-a290-c5d9278be4af',NULL,'container_format','bare'),('2026-01-20 15:10:45',NULL,'2026-01-20 15:10:58',1,173,'f396a213-a7f4-434e-a290-c5d9278be4af',NULL,'disk_format','qcow2'),('2026-01-20 15:10:45',NULL,'2026-01-20 15:10:58',1,174,'f396a213-a7f4-434e-a290-c5d9278be4af',NULL,'min_disk','0'),('2026-01-20 15:10:45',NULL,'2026-01-20 15:10:58',1,175,'f396a213-a7f4-434e-a290-c5d9278be4af',NULL,'min_ram','0'),('2026-01-20 15:10:45',NULL,'2026-01-20 15:10:58',1,176,'f396a213-a7f4-434e-a290-c5d9278be4af',NULL,'size','21430272'),('2026-01-20 15:11:06',NULL,'2026-01-20 15:12:43',1,177,'fd11049d-6334-4d6c-ac5d-8cfeca690b75',NULL,'signature_verified','False'),('2026-01-20 15:11:10',NULL,'2026-01-20 15:12:43',1,178,'fd11049d-6334-4d6c-ac5d-8cfeca690b75',NULL,'hw_rng_model','virtio'),('2026-01-20 15:11:10',NULL,'2026-01-20 15:12:43',1,179,'fd11049d-6334-4d6c-ac5d-8cfeca690b75',NULL,'image_id','a32b3e07-16d8-46fd-9a7b-c242c432fcf9'),('2026-01-20 15:11:10',NULL,'2026-01-20 15:12:43',1,180,'fd11049d-6334-4d6c-ac5d-8cfeca690b75',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-20 15:11:10',NULL,'2026-01-20 15:12:43',1,181,'fd11049d-6334-4d6c-ac5d-8cfeca690b75',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-20 15:11:10',NULL,'2026-01-20 15:12:43',1,182,'fd11049d-6334-4d6c-ac5d-8cfeca690b75',NULL,'container_format','bare'),('2026-01-20 15:11:10',NULL,'2026-01-20 15:12:43',1,183,'fd11049d-6334-4d6c-ac5d-8cfeca690b75',NULL,'disk_format','qcow2'),('2026-01-20 15:11:10',NULL,'2026-01-20 15:12:43',1,184,'fd11049d-6334-4d6c-ac5d-8cfeca690b75',NULL,'min_disk','0'),('2026-01-20 15:11:10',NULL,'2026-01-20 15:12:43',1,185,'fd11049d-6334-4d6c-ac5d-8cfeca690b75',NULL,'min_ram','0'),('2026-01-20 15:11:10',NULL,'2026-01-20 15:12:43',1,186,'fd11049d-6334-4d6c-ac5d-8cfeca690b75',NULL,'size','21430272'),('2026-01-20 15:11:45',NULL,'2026-01-20 15:12:38',1,187,NULL,'ac531e53-ece8-4166-8e41-ebb939119e9b','signature_verified','False'),('2026-01-20 15:11:45',NULL,'2026-01-20 15:12:38',1,188,NULL,'ac531e53-ece8-4166-8e41-ebb939119e9b','hw_rng_model','virtio'),('2026-01-20 15:11:45',NULL,'2026-01-20 15:12:38',1,189,NULL,'ac531e53-ece8-4166-8e41-ebb939119e9b','image_id','a32b3e07-16d8-46fd-9a7b-c242c432fcf9'),('2026-01-20 15:11:45',NULL,'2026-01-20 15:12:38',1,190,NULL,'ac531e53-ece8-4166-8e41-ebb939119e9b','image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-20 15:11:45',NULL,'2026-01-20 15:12:38',1,191,NULL,'ac531e53-ece8-4166-8e41-ebb939119e9b','checksum','c8fc807773e5354afe61636071771906'),('2026-01-20 15:11:45',NULL,'2026-01-20 15:12:38',1,192,NULL,'ac531e53-ece8-4166-8e41-ebb939119e9b','container_format','bare'),('2026-01-20 15:11:45',NULL,'2026-01-20 15:12:38',1,193,NULL,'ac531e53-ece8-4166-8e41-ebb939119e9b','disk_format','qcow2'),('2026-01-20 15:11:45',NULL,'2026-01-20 15:12:38',1,194,NULL,'ac531e53-ece8-4166-8e41-ebb939119e9b','min_disk','0'),('2026-01-20 15:11:45',NULL,'2026-01-20 15:12:38',1,195,NULL,'ac531e53-ece8-4166-8e41-ebb939119e9b','min_ram','0'),('2026-01-20 15:11:45',NULL,'2026-01-20 15:12:38',1,196,NULL,'ac531e53-ece8-4166-8e41-ebb939119e9b','size','21430272'),('2026-01-20 15:11:55',NULL,'2026-01-20 15:12:36',1,197,'8692e9bd-7163-4f35-a28b-8a31b1691fc8',NULL,'signature_verified','False'),('2026-01-20 15:11:55',NULL,'2026-01-20 15:12:36',1,198,'8692e9bd-7163-4f35-a28b-8a31b1691fc8',NULL,'hw_rng_model','virtio'),('2026-01-20 15:11:55',NULL,'2026-01-20 15:12:36',1,199,'8692e9bd-7163-4f35-a28b-8a31b1691fc8',NULL,'image_id','a32b3e07-16d8-46fd-9a7b-c242c432fcf9'),('2026-01-20 15:11:55',NULL,'2026-01-20 15:12:36',1,200,'8692e9bd-7163-4f35-a28b-8a31b1691fc8',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-20 15:11:55',NULL,'2026-01-20 15:12:36',1,201,'8692e9bd-7163-4f35-a28b-8a31b1691fc8',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-20 15:11:55',NULL,'2026-01-20 15:12:36',1,202,'8692e9bd-7163-4f35-a28b-8a31b1691fc8',NULL,'container_format','bare'),('2026-01-20 15:11:55',NULL,'2026-01-20 15:12:36',1,203,'8692e9bd-7163-4f35-a28b-8a31b1691fc8',NULL,'disk_format','qcow2'),('2026-01-20 15:11:55',NULL,'2026-01-20 15:12:36',1,204,'8692e9bd-7163-4f35-a28b-8a31b1691fc8',NULL,'min_disk','0'),('2026-01-20 15:11:55',NULL,'2026-01-20 15:12:36',1,205,'8692e9bd-7163-4f35-a28b-8a31b1691fc8',NULL,'min_ram','0'),('2026-01-20 15:11:55',NULL,'2026-01-20 15:12:36',1,206,'8692e9bd-7163-4f35-a28b-8a31b1691fc8',NULL,'size','21430272'),('2026-01-20 15:13:00',NULL,'2026-01-20 15:15:46',1,207,'670aaaab-6a81-487d-a346-d03d445d8abe',NULL,'signature_verified','False'),('2026-01-20 15:13:04',NULL,'2026-01-20 15:15:46',1,208,'670aaaab-6a81-487d-a346-d03d445d8abe',NULL,'hw_rng_model','virtio'),('2026-01-20 15:13:04',NULL,'2026-01-20 15:15:46',1,209,'670aaaab-6a81-487d-a346-d03d445d8abe',NULL,'image_id','a32b3e07-16d8-46fd-9a7b-c242c432fcf9'),('2026-01-20 15:13:04',NULL,'2026-01-20 15:15:46',1,210,'670aaaab-6a81-487d-a346-d03d445d8abe',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-20 15:13:04',NULL,'2026-01-20 15:15:46',1,211,'670aaaab-6a81-487d-a346-d03d445d8abe',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-20 15:13:04',NULL,'2026-01-20 15:15:46',1,212,'670aaaab-6a81-487d-a346-d03d445d8abe',NULL,'container_format','bare'),('2026-01-20 15:13:04',NULL,'2026-01-20 15:15:46',1,213,'670aaaab-6a81-487d-a346-d03d445d8abe',NULL,'disk_format','qcow2'),('2026-01-20 15:13:04',NULL,'2026-01-20 15:15:46',1,214,'670aaaab-6a81-487d-a346-d03d445d8abe',NULL,'min_disk','0'),('2026-01-20 15:13:04',NULL,'2026-01-20 15:15:46',1,215,'670aaaab-6a81-487d-a346-d03d445d8abe',NULL,'min_ram','0'),('2026-01-20 15:13:04',NULL,'2026-01-20 15:15:46',1,216,'670aaaab-6a81-487d-a346-d03d445d8abe',NULL,'size','21430272'),('2026-01-20 15:13:13',NULL,'2026-01-20 15:17:54',1,217,'c46398b2-4b96-4ab6-ac9b-93d7ea349e92',NULL,'signature_verified','False'),('2026-01-20 15:13:18',NULL,'2026-01-20 15:17:54',1,218,'c46398b2-4b96-4ab6-ac9b-93d7ea349e92',NULL,'hw_rng_model','virtio'),('2026-01-20 15:13:18',NULL,'2026-01-20 15:17:54',1,219,'c46398b2-4b96-4ab6-ac9b-93d7ea349e92',NULL,'image_id','a32b3e07-16d8-46fd-9a7b-c242c432fcf9'),('2026-01-20 15:13:18',NULL,'2026-01-20 15:17:54',1,220,'c46398b2-4b96-4ab6-ac9b-93d7ea349e92',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-20 15:13:18',NULL,'2026-01-20 15:17:54',1,221,'c46398b2-4b96-4ab6-ac9b-93d7ea349e92',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-20 15:13:18',NULL,'2026-01-20 15:17:54',1,222,'c46398b2-4b96-4ab6-ac9b-93d7ea349e92',NULL,'container_format','bare'),('2026-01-20 15:13:18',NULL,'2026-01-20 15:17:54',1,223,'c46398b2-4b96-4ab6-ac9b-93d7ea349e92',NULL,'disk_format','qcow2'),('2026-01-20 15:13:18',NULL,'2026-01-20 15:17:54',1,224,'c46398b2-4b96-4ab6-ac9b-93d7ea349e92',NULL,'min_disk','0'),('2026-01-20 15:13:18',NULL,'2026-01-20 15:17:54',1,225,'c46398b2-4b96-4ab6-ac9b-93d7ea349e92',NULL,'min_ram','0'),('2026-01-20 15:13:18',NULL,'2026-01-20 15:17:54',1,226,'c46398b2-4b96-4ab6-ac9b-93d7ea349e92',NULL,'size','21430272'),('2026-01-20 15:14:31',NULL,'2026-01-20 15:15:38',1,227,NULL,'3dcf5289-66e6-4e63-98e0-d16423ce9c81','signature_verified','False'),('2026-01-20 15:14:31',NULL,'2026-01-20 15:15:38',1,228,NULL,'3dcf5289-66e6-4e63-98e0-d16423ce9c81','hw_rng_model','virtio'),('2026-01-20 15:14:31',NULL,'2026-01-20 15:15:38',1,229,NULL,'3dcf5289-66e6-4e63-98e0-d16423ce9c81','image_id','a32b3e07-16d8-46fd-9a7b-c242c432fcf9'),('2026-01-20 15:14:31',NULL,'2026-01-20 15:15:38',1,230,NULL,'3dcf5289-66e6-4e63-98e0-d16423ce9c81','image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-20 15:14:31',NULL,'2026-01-20 15:15:38',1,231,NULL,'3dcf5289-66e6-4e63-98e0-d16423ce9c81','checksum','c8fc807773e5354afe61636071771906'),('2026-01-20 15:14:31',NULL,'2026-01-20 15:15:38',1,232,NULL,'3dcf5289-66e6-4e63-98e0-d16423ce9c81','container_format','bare'),('2026-01-20 15:14:31',NULL,'2026-01-20 15:15:38',1,233,NULL,'3dcf5289-66e6-4e63-98e0-d16423ce9c81','disk_format','qcow2'),('2026-01-20 15:14:31',NULL,'2026-01-20 15:15:38',1,234,NULL,'3dcf5289-66e6-4e63-98e0-d16423ce9c81','min_disk','0'),('2026-01-20 15:14:31',NULL,'2026-01-20 15:15:38',1,235,NULL,'3dcf5289-66e6-4e63-98e0-d16423ce9c81','min_ram','0'),('2026-01-20 15:14:31',NULL,'2026-01-20 15:15:38',1,236,NULL,'3dcf5289-66e6-4e63-98e0-d16423ce9c81','size','21430272'),('2026-01-20 15:14:32',NULL,'2026-01-20 15:15:35',1,237,'4994c109-f7d8-4642-bf6a-2f796e3851ba',NULL,'signature_verified','False'),('2026-01-20 15:14:32',NULL,'2026-01-20 15:15:35',1,238,'4994c109-f7d8-4642-bf6a-2f796e3851ba',NULL,'hw_rng_model','virtio'),('2026-01-20 15:14:32',NULL,'2026-01-20 15:15:35',1,239,'4994c109-f7d8-4642-bf6a-2f796e3851ba',NULL,'image_id','a32b3e07-16d8-46fd-9a7b-c242c432fcf9'),('2026-01-20 15:14:32',NULL,'2026-01-20 15:15:35',1,240,'4994c109-f7d8-4642-bf6a-2f796e3851ba',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-20 15:14:32',NULL,'2026-01-20 15:15:35',1,241,'4994c109-f7d8-4642-bf6a-2f796e3851ba',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-20 15:14:32',NULL,'2026-01-20 15:15:35',1,242,'4994c109-f7d8-4642-bf6a-2f796e3851ba',NULL,'container_format','bare'),('2026-01-20 15:14:32',NULL,'2026-01-20 15:15:35',1,243,'4994c109-f7d8-4642-bf6a-2f796e3851ba',NULL,'disk_format','qcow2'),('2026-01-20 15:14:32',NULL,'2026-01-20 15:15:35',1,244,'4994c109-f7d8-4642-bf6a-2f796e3851ba',NULL,'min_disk','0'),('2026-01-20 15:14:32',NULL,'2026-01-20 15:15:35',1,245,'4994c109-f7d8-4642-bf6a-2f796e3851ba',NULL,'min_ram','0'),('2026-01-20 15:14:32',NULL,'2026-01-20 15:15:35',1,246,'4994c109-f7d8-4642-bf6a-2f796e3851ba',NULL,'size','21430272'),('2026-01-20 15:16:55',NULL,'2026-01-20 15:17:26',1,247,'972ce456-91dd-4e78-8ae7-4dd3cb2257e8',NULL,'signature_verified','False'),('2026-01-20 15:17:00',NULL,'2026-01-20 15:17:26',1,248,'972ce456-91dd-4e78-8ae7-4dd3cb2257e8',NULL,'hw_rng_model','virtio'),('2026-01-20 15:17:00',NULL,'2026-01-20 15:17:26',1,249,'972ce456-91dd-4e78-8ae7-4dd3cb2257e8',NULL,'image_id','a32b3e07-16d8-46fd-9a7b-c242c432fcf9'),('2026-01-20 15:17:00',NULL,'2026-01-20 15:17:26',1,250,'972ce456-91dd-4e78-8ae7-4dd3cb2257e8',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-20 15:17:00',NULL,'2026-01-20 15:17:26',1,251,'972ce456-91dd-4e78-8ae7-4dd3cb2257e8',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-20 15:17:00',NULL,'2026-01-20 15:17:26',1,252,'972ce456-91dd-4e78-8ae7-4dd3cb2257e8',NULL,'container_format','bare'),('2026-01-20 15:17:00',NULL,'2026-01-20 15:17:26',1,253,'972ce456-91dd-4e78-8ae7-4dd3cb2257e8',NULL,'disk_format','qcow2'),('2026-01-20 15:17:00',NULL,'2026-01-20 15:17:26',1,254,'972ce456-91dd-4e78-8ae7-4dd3cb2257e8',NULL,'min_disk','0'),('2026-01-20 15:17:00',NULL,'2026-01-20 15:17:26',1,255,'972ce456-91dd-4e78-8ae7-4dd3cb2257e8',NULL,'min_ram','0'),('2026-01-20 15:17:00',NULL,'2026-01-20 15:17:26',1,256,'972ce456-91dd-4e78-8ae7-4dd3cb2257e8',NULL,'size','21430272'),('2026-01-20 15:17:15',NULL,'2026-01-20 15:17:25',1,257,NULL,'e76b9e34-4947-4eda-aa6f-85b2f7ae7aea','signature_verified','False'),('2026-01-20 15:17:15',NULL,'2026-01-20 15:17:25',1,258,NULL,'e76b9e34-4947-4eda-aa6f-85b2f7ae7aea','hw_rng_model','virtio'),('2026-01-20 15:17:15',NULL,'2026-01-20 15:17:25',1,259,NULL,'e76b9e34-4947-4eda-aa6f-85b2f7ae7aea','image_id','a32b3e07-16d8-46fd-9a7b-c242c432fcf9'),('2026-01-20 15:17:15',NULL,'2026-01-20 15:17:25',1,260,NULL,'e76b9e34-4947-4eda-aa6f-85b2f7ae7aea','image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-20 15:17:15',NULL,'2026-01-20 15:17:25',1,261,NULL,'e76b9e34-4947-4eda-aa6f-85b2f7ae7aea','checksum','c8fc807773e5354afe61636071771906'),('2026-01-20 15:17:15',NULL,'2026-01-20 15:17:25',1,262,NULL,'e76b9e34-4947-4eda-aa6f-85b2f7ae7aea','container_format','bare'),('2026-01-20 15:17:15',NULL,'2026-01-20 15:17:25',1,263,NULL,'e76b9e34-4947-4eda-aa6f-85b2f7ae7aea','disk_format','qcow2'),('2026-01-20 15:17:15',NULL,'2026-01-20 15:17:25',1,264,NULL,'e76b9e34-4947-4eda-aa6f-85b2f7ae7aea','min_disk','0'),('2026-01-20 15:17:15',NULL,'2026-01-20 15:17:25',1,265,NULL,'e76b9e34-4947-4eda-aa6f-85b2f7ae7aea','min_ram','0'),('2026-01-20 15:17:15',NULL,'2026-01-20 15:17:25',1,266,NULL,'e76b9e34-4947-4eda-aa6f-85b2f7ae7aea','size','21430272');
/*!40000 ALTER TABLE `volume_glance_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_metadata`
--

DROP TABLE IF EXISTS `volume_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_metadata`
--

LOCK TABLES `volume_metadata` WRITE;
/*!40000 ALTER TABLE `volume_metadata` DISABLE KEYS */;
INSERT INTO `volume_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `key`, `value`) VALUES ('2026-01-20 14:56:25',NULL,'2026-01-20 14:56:37',1,1,'187eacdf-24a2-4528-bcf0-2152448d98bf','Type','work'),('2026-01-20 14:56:27',NULL,'2026-01-20 14:56:36',1,2,'b89dc598-8fba-4f9a-8997-6a54f30049ce','Type','work'),('2026-01-20 14:56:29',NULL,'2026-01-20 14:56:33',1,3,'380fcfba-8d95-4877-b230-66cd31b06d1b','Type','work'),('2026-01-20 15:06:09',NULL,'2026-01-20 15:06:10',1,4,'adcffcaa-1170-4516-be1e-22b8d1c23920','Type','work'),('2026-01-20 15:08:21',NULL,'2026-01-20 15:09:05',1,5,'658f5854-e66e-4c02-a707-dcb4f1727205','src_backup_id','d6558c7e-be53-4669-acdb-5b67dd2ebd2f');
/*!40000 ALTER TABLE `volume_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_extra_specs`
--

DROP TABLE IF EXISTS `volume_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_extra_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_type_extra_specs_volume_type_id` (`volume_type_id`),
  CONSTRAINT `volume_type_extra_specs_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_extra_specs`
--

LOCK TABLES `volume_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `volume_type_extra_specs` DISABLE KEYS */;
INSERT INTO `volume_type_extra_specs` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_type_id`, `key`, `value`) VALUES ('2026-01-20 14:20:42',NULL,NULL,0,1,'b55b5d00-8b4e-41a3-ab81-22610acc7e5e','multiattach','<is> True');
/*!40000 ALTER TABLE `volume_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_projects`
--

DROP TABLE IF EXISTS `volume_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `volume_type_id` (`volume_type_id`,`project_id`,`deleted`),
  CONSTRAINT `volume_type_projects_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_projects`
--

LOCK TABLES `volume_type_projects` WRITE;
/*!40000 ALTER TABLE `volume_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_types`
--

DROP TABLE IF EXISTS `volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `qos_specs_id` varchar(36) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_types_qos_specs_id` (`qos_specs_id`),
  CONSTRAINT `volume_types_ibfk_1` FOREIGN KEY (`qos_specs_id`) REFERENCES `quality_of_service_specs` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_types`
--

LOCK TABLES `volume_types` WRITE;
/*!40000 ALTER TABLE `volume_types` DISABLE KEYS */;
INSERT INTO `volume_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `qos_specs_id`, `is_public`, `description`) VALUES ('2026-01-20 13:41:32','2026-01-20 13:41:32',NULL,0,'04dd119c-1c6c-4ffc-95c3-44156e411410','__DEFAULT__',NULL,1,'Default Volume Type'),('2026-01-20 15:06:37',NULL,'2026-01-20 15:07:49',1,'88745016-718c-4c33-be96-1147347c0cc1','tempest-scenario-type-luks-1068136217',NULL,1,NULL),('2026-01-20 15:09:48',NULL,'2026-01-20 15:10:25',1,'97532ec0-0821-4438-834b-3de729339510','tempest-scenario-type-luks-795593813',NULL,1,NULL),('2026-01-20 14:20:40',NULL,NULL,0,'b55b5d00-8b4e-41a3-ab81-22610acc7e5e','multiattach',NULL,1,NULL),('2026-01-20 14:57:16',NULL,'2026-01-20 15:00:10',1,'d5b753be-e483-474f-aacf-74aa9d003304','tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-347628217-1040866455',NULL,1,NULL),('2026-01-20 14:57:18',NULL,'2026-01-20 15:00:09',1,'dad3fd93-bc09-47b4-96fe-8d0ba8dd19e7','tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-692148149-672147069',NULL,1,NULL),('2026-01-20 14:57:18',NULL,'2026-01-20 15:00:08',1,'dbe07089-2a3b-4679-89d5-1cb270f6e395','tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-472468519-648261730',NULL,1,NULL);
/*!40000 ALTER TABLE `volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ec2_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(256) DEFAULT NULL,
  `provider_auth` varchar(256) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `source_volid` varchar(36) DEFAULT NULL,
  `bootable` tinyint(1) DEFAULT NULL,
  `provider_geometry` varchar(255) DEFAULT NULL,
  `_name_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `migration_status` varchar(255) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  `replication_extended_status` varchar(255) DEFAULT NULL,
  `replication_driver_data` varchar(255) DEFAULT NULL,
  `consistencygroup_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `multiattach` tinyint(1) DEFAULT NULL,
  `previous_status` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `group_id` varchar(36) DEFAULT NULL,
  `service_uuid` varchar(36) DEFAULT NULL,
  `shared_targets` tinyint(1) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volumes_group_id` (`group_id`),
  KEY `ix_volumes_consistencygroup_id` (`consistencygroup_id`),
  KEY `volumes_service_uuid_idx` (`service_uuid`,`deleted`),
  KEY `volumes_deleted_project_id_idx` (`deleted`,`project_id`),
  KEY `volumes_deleted_host_idx` (`deleted`,`host`),
  CONSTRAINT `volumes_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `volumes_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `volumes_ibfk_3` FOREIGN KEY (`service_uuid`) REFERENCES `services` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
INSERT INTO `volumes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `ec2_id`, `user_id`, `project_id`, `host`, `size`, `availability_zone`, `status`, `attach_status`, `scheduled_at`, `launched_at`, `terminated_at`, `display_name`, `display_description`, `provider_location`, `provider_auth`, `snapshot_id`, `volume_type_id`, `source_volid`, `bootable`, `provider_geometry`, `_name_id`, `encryption_key_id`, `migration_status`, `replication_status`, `replication_extended_status`, `replication_driver_data`, `consistencygroup_id`, `provider_id`, `multiattach`, `previous_status`, `cluster_name`, `group_id`, `service_uuid`, `shared_targets`, `use_quota`) VALUES ('2026-01-20 14:57:24','2026-01-20 15:00:03','2026-01-20 15:00:04',1,'002e39e3-1bec-4033-aca2-f1428e495087',NULL,'ed2c9bd268d1491fa3484d86bcdb9ec6','107c1f3b5b7b413d9a389ca1166e331f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:57:24','2026-01-20 14:57:32','2026-01-20 15:00:03','tempest-TestInstancesWithCinderVolumes-volume-1264681540',NULL,NULL,NULL,NULL,'d5b753be-e483-474f-aacf-74aa9d003304',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 15:22:00','2026-01-20 15:22:12','2026-01-20 15:22:13',1,'02088fae-4a9d-4027-a9b3-19d5b159fed0',NULL,'cd9a8f26b71f4631a387e555e6b18428','9156c0a9920c4721843416b9a44404f9','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 15:22:01','2026-01-20 15:22:01','2026-01-20 15:22:12','tempest-AttachVolumeNegativeTest-volume-710411635',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:57:19','2026-01-20 14:58:21','2026-01-20 14:58:22',1,'0668acc6-1fde-4609-addf-37a73f135900',NULL,'ed2c9bd268d1491fa3484d86bcdb9ec6','107c1f3b5b7b413d9a389ca1166e331f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:57:19','2026-01-20 14:57:19','2026-01-20 14:58:21','tempest-TestInstancesWithCinderVolumes-volume-2126625279',NULL,NULL,NULL,NULL,'dbe07089-2a3b-4679-89d5-1cb270f6e395',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:57:18','2026-01-20 14:58:17','2026-01-20 14:58:18',1,'06b5ccf9-bd72-4532-983a-75b3b42cbfe9',NULL,'ed2c9bd268d1491fa3484d86bcdb9ec6','107c1f3b5b7b413d9a389ca1166e331f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:57:19','2026-01-20 14:57:19','2026-01-20 14:58:17','tempest-TestInstancesWithCinderVolumes-volume-150756565',NULL,NULL,NULL,NULL,'dad3fd93-bc09-47b4-96fe-8d0ba8dd19e7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:33:26','2026-01-20 14:34:13','2026-01-20 14:34:15',1,'0a09166e-3f2b-4406-9246-5c03480cda80',NULL,'729ca8a2a7414735af25d05df4a563b9','48488e875f2e472f97f07cc7ee07e0be','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:33:26','2026-01-20 14:33:26','2026-01-20 14:34:13','tempest-VolumesAdminNegativeTest-volume-681892375',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:57:19','2026-01-20 14:59:04','2026-01-20 14:59:05',1,'0d487092-de99-40b0-be3f-425947d7010c',NULL,'ed2c9bd268d1491fa3484d86bcdb9ec6','107c1f3b5b7b413d9a389ca1166e331f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:57:19','2026-01-20 14:57:19','2026-01-20 14:59:04','tempest-TestInstancesWithCinderVolumes-volume-1245841200',NULL,NULL,NULL,NULL,'dbe07089-2a3b-4679-89d5-1cb270f6e395',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:28:13','2026-01-20 14:28:32','2026-01-20 14:28:32',1,'0ef22368-9785-4823-bb66-470ea5a5862d',NULL,'eae4ac21a700463eadfdbe7717ed8b13','944b426a2d4c4ad3a01f0b855ad36509','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:28:14','2026-01-20 14:28:14','2026-01-20 14:28:32','tempest-AttachSCSIVolumeTestJSON-volume-368657507',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:56:25','2026-01-20 14:56:37','2026-01-20 14:56:37',1,'187eacdf-24a2-4528-bcf0-2152448d98bf',NULL,'caca84670125404db34273d4d6da36df','fb4410ee5e824adfa71950de60e627af','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:56:25','2026-01-20 14:56:25','2026-01-20 14:56:37','tempest-VolumesTestJSON-volume-303626880',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 15:08:44','2026-01-20 15:09:35','2026-01-20 15:09:35',1,'1ae2be75-c922-4458-bd11-a97b4f6fdd2b',NULL,'c98bd3f0904e48efa524d598bcad85e9','5b43342be22543f79d4a56e26c6d0c96','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 15:08:44','2026-01-20 15:08:44','2026-01-20 15:09:35','tempest-TestMinimumBasicScenario-volume-1618155976',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:44:29','2026-01-20 14:45:30','2026-01-20 14:45:30',1,'2441d1fb-fc23-4a6d-b88d-4d82b035b65f',NULL,'9051b1fd0e0b40c2be07afc6da803903','144d821b8f624db687f0e009c5e06d8b','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:44:29','2026-01-20 14:44:36','2026-01-20 14:45:30','tempest-tempest.common.compute-volume-380859572',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:48:47','2026-01-20 14:51:19','2026-01-20 14:51:20',1,'25d4c4a0-3582-454d-9d4a-312b5c351d9d',NULL,'1d45e7e42e6d419898780db108ff93ff','b15c4e6eb57e4b0ca4e63c85ed92fc5f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:48:47','2026-01-20 14:48:47','2026-01-20 14:51:19','tempest-TaggedBootDevicesTest-volume-147792042',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 15:08:02','2026-01-20 15:09:04','2026-01-20 15:09:06',1,'312280b4-90ae-42ad-9955-fa64a235a337',NULL,'467630ad66f84c4ba21657f6e5db7d10','48aeeaa346bb4dfba4dfc598ae41f062','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 15:08:02','2026-01-20 15:08:09','2026-01-20 15:09:04','tempest-TestVolumeBackupRestore-volume-1770079613',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:57:19','2026-01-20 14:59:00','2026-01-20 14:59:00',1,'3381d324-93a9-4d2f-ab25-8460bb2b8e95',NULL,'ed2c9bd268d1491fa3484d86bcdb9ec6','107c1f3b5b7b413d9a389ca1166e331f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:57:19','2026-01-20 14:57:19','2026-01-20 14:59:00','tempest-TestInstancesWithCinderVolumes-volume-482487090',NULL,NULL,NULL,NULL,'dad3fd93-bc09-47b4-96fe-8d0ba8dd19e7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:56:29','2026-01-20 14:56:33','2026-01-20 14:56:33',1,'380fcfba-8d95-4877-b230-66cd31b06d1b',NULL,'caca84670125404db34273d4d6da36df','fb4410ee5e824adfa71950de60e627af','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:56:29','2026-01-20 14:56:29','2026-01-20 14:56:33','tempest-VolumesTestJSON-volume-1069894863',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 15:01:45','2026-01-20 15:05:10',NULL,0,'41743468-7add-45cb-bc94-02eb6f850278',NULL,'2446e8399b344b29986c1aaf8bf73adf','63555e5851564db08c6429231d264f2c','hostgroup@ceph#ceph',1,'nova','available','detached','2026-01-20 15:01:45','2026-01-20 15:01:45',NULL,'474cec75-3b01-411a-9074-75859d2a9ddf-blank-vol','',NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:38:41','2026-01-20 14:40:30','2026-01-20 14:40:31',1,'419220b3-a6cb-447f-be9b-d4de4cac4b79',NULL,'cd4ba32a01f74af199438da0b72e5a4d','8705404c3964472782118e478eb54e51','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:38:41','2026-01-20 14:38:41','2026-01-20 14:40:30','tempest-TaggedBootDevicesTest_v242-volume-1004937891',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:38:39','2026-01-20 14:40:32','2026-01-20 14:40:33',1,'41d04608-e9dd-4b22-8440-9cab803a24b7',NULL,'cd4ba32a01f74af199438da0b72e5a4d','8705404c3964472782118e478eb54e51','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:38:39','2026-01-20 14:38:39','2026-01-20 14:40:32','tempest-TaggedBootDevicesTest_v242-volume-1972509906',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:46:00','2026-01-20 14:47:07','2026-01-20 14:47:07',1,'42ddc596-73e2-4763-a6a5-75e17ba882ad',NULL,'5cd9508688214bedb977528f8b6f95d1','7bbf722f17654404925cfb53e48cd473','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:46:00','2026-01-20 14:46:00','2026-01-20 14:47:07','tempest-TaggedAttachmentsTest-volume-2032504006',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 15:06:07','2026-01-20 15:07:11','2026-01-20 15:07:11',1,'44e852b3-daf0-4085-aca9-bb61206f2ff9',NULL,'bc554998e71a4322bdd27ac727a9044c','e142d118583b4f9ba3531bcf3838e256','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 15:06:07','2026-01-20 15:06:08','2026-01-20 15:07:11','tempest-TestStampPattern-volume-940811723',NULL,NULL,NULL,'a82fd77e-f9dd-4a01-9111-5774636cf3b0','04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:27:59','2026-01-20 14:29:13','2026-01-20 14:29:13',1,'47e883f3-6efe-40b3-be28-6c01525dfc0c',NULL,'bce7fcbd19554e29bb80c5b93b7dd3c9','d15f60b9e48e4175b5520d1e57ed2d3a','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:28:00','2026-01-20 14:28:09','2026-01-20 14:29:13','tempest-tempest.common.compute-volume-573729404',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 15:14:32','2026-01-20 15:15:32','2026-01-20 15:15:35',1,'4994c109-f7d8-4642-bf6a-2f796e3851ba',NULL,'bf422e55e158420cbdae75f07a3bb97a','a49638950e1543fa8e0d251af5479623','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 15:14:32','2026-01-20 15:14:32','2026-01-20 15:15:32','tempest-TestVolumeBootPattern-volume-1208911189',NULL,NULL,NULL,'3dcf5289-66e6-4e63-98e0-d16423ce9c81','04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 15:05:15','2026-01-20 15:07:21','2026-01-20 15:07:21',1,'4a621494-2aaf-461c-b7c1-05665913aaf9',NULL,'bc554998e71a4322bdd27ac727a9044c','e142d118583b4f9ba3531bcf3838e256','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 15:05:15','2026-01-20 15:05:16','2026-01-20 15:07:21','tempest-TestStampPattern-volume-1603897749',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:23:18','2026-01-20 14:24:17','2026-01-20 14:24:18',1,'4b77ca01-614c-4b84-ae37-bb7bf58d4923',NULL,'0167905b37e04d22b41125ba80c626ca','a46350811ba449b082347f02d76d1c34','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:23:18','2026-01-20 14:23:24','2026-01-20 14:24:17','tempest-VolumesAssistedSnapshotsTest-volume-1036388155',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 15:06:39','2026-01-20 15:07:47','2026-01-20 15:07:47',1,'522e3761-1020-4931-8036-475bf6ddd148',NULL,'1cdce555ec694255a154517f28a12ae5','526db518ca3942b58ee346d4bd970e42','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 15:06:39','2026-01-20 15:06:49','2026-01-20 15:07:47','tempest-TestEncryptedCinderVolumes-volume-2110145018',NULL,NULL,NULL,NULL,'88745016-718c-4c33-be96-1147347c0cc1',NULL,0,NULL,NULL,'44fbaa9e-d63a-4bf0-9535-e5558eaaa7e4',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:57:23','2026-01-20 15:00:04','2026-01-20 15:00:05',1,'5728e8f8-a711-41d5-aa04-a1d9faada8d9',NULL,'ed2c9bd268d1491fa3484d86bcdb9ec6','107c1f3b5b7b413d9a389ca1166e331f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:57:23','2026-01-20 14:57:30','2026-01-20 15:00:04','tempest-TestInstancesWithCinderVolumes-volume-1056324959',NULL,NULL,NULL,NULL,'d5b753be-e483-474f-aacf-74aa9d003304',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:44:27','2026-01-20 14:47:54','2026-01-20 14:47:58',1,'5930261f-9813-4b24-a25f-b6b26b90d24b',NULL,'37e9ef97fbe0448e9fbe32d48b66211f','3b31139b2a4e49cba5e7048febf901c4','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:44:27','2026-01-20 14:44:27','2026-01-20 14:47:54','tempest-DeleteServersTestJSON-volume-703203509',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:52:49','2026-01-20 14:54:38','2026-01-20 14:54:39',1,'5f6a803f-d232-4e97-9965-ece0139e0fda',NULL,'d85d286ce6224326a0f4a15a06afbfea','0a29915e0dd2403fbd7b7e847696b00a','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:52:49','2026-01-20 14:52:49','2026-01-20 14:54:38','tempest-ServerStableDeviceRescueTest-volume-1582750395',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 15:08:17','2026-01-20 15:09:03','2026-01-20 15:09:05',1,'658f5854-e66e-4c02-a707-dcb4f1727205',NULL,'467630ad66f84c4ba21657f6e5db7d10','48aeeaa346bb4dfba4dfc598ae41f062','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 15:08:17','2026-01-20 15:08:18','2026-01-20 15:09:03','tempest-TestVolumeBackupRestore-volume-1770079613',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 15:12:56','2026-01-20 15:15:44','2026-01-20 15:15:46',1,'670aaaab-6a81-487d-a346-d03d445d8abe',NULL,'bf422e55e158420cbdae75f07a3bb97a','a49638950e1543fa8e0d251af5479623','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 15:12:57','2026-01-20 15:13:04','2026-01-20 15:15:44','tempest-TestVolumeBootPattern-volume-origin-1993788943',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:24:27','2026-01-20 14:26:02','2026-01-20 14:26:03',1,'67ec3b5b-23d2-4f8a-84b0-4ee1bda588af',NULL,'aefb5652049e473a948c089d7c62ef1a','861a4f2b70b249afadeabfe85bda53a3','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:24:27','2026-01-20 14:24:40','2026-01-20 14:26:02','tempest-tempest.common.compute-volume-1767180517',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:29:08','2026-01-20 14:31:53','2026-01-20 14:31:54',1,'73c5b3f0-c4ca-48f3-9dc2-d2c15d3fd745',NULL,'6a3fbc3f92a849e88cbf34d28ca17e43','0cee74dd60da4a839bb5eb0ba3137edf','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:29:08','2026-01-20 14:29:09','2026-01-20 14:31:53','tempest-UpdateMultiattachVolumeNegativeTest-volume-1741128589',NULL,'{\"saved_features\":61}',NULL,NULL,'b55b5d00-8b4e-41a3-ab81-22610acc7e5e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:53:42','2026-01-20 14:56:16','2026-01-20 14:56:16',1,'763a536d-0897-462a-8acb-fbf9e84e31ea',NULL,'34eb73f628994c11801d447148d5f142','b1e83af992c94112a965575784639d77','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:53:42','2026-01-20 14:53:43','2026-01-20 14:56:16','tempest-AttachVolumeShelveTestJSON-volume-1637418979',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 15:08:54','2026-01-20 15:10:34','2026-01-20 15:10:35',1,'7d67106f-2f4c-4925-94d7-b60a4418b999',NULL,'27658864f96d453586dd0846a4c55b7d','fc74c4a296554866969b05aef75252af','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 15:08:54','2026-01-20 15:08:54','2026-01-20 15:10:34','tempest-ServerRescueNegativeTestJSON-volume-148998025',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 15:11:54','2026-01-20 15:12:34','2026-01-20 15:12:36',1,'8692e9bd-7163-4f35-a28b-8a31b1691fc8',NULL,'bf422e55e158420cbdae75f07a3bb97a','a49638950e1543fa8e0d251af5479623','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 15:11:54','2026-01-20 15:11:55','2026-01-20 15:12:34','','',NULL,NULL,'ac531e53-ece8-4166-8e41-ebb939119e9b','04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 15:08:32','2026-01-20 15:10:35','2026-01-20 15:10:36',1,'86df2fae-bc2c-4706-b853-fa40d11ebbcb',NULL,'27658864f96d453586dd0846a4c55b7d','fc74c4a296554866969b05aef75252af','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 15:08:32','2026-01-20 15:08:32','2026-01-20 15:10:35','tempest-ServerRescueNegativeTestJSON-volume-653290884',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 15:14:11','2026-01-20 15:17:35','2026-01-20 15:17:36',1,'8ac6f07e-10cd-4304-b732-9202123dbda4',NULL,'e9cc4ce3e069479ba9c789b378a68a1d','fff727019f86407498e83d7948d54962','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 15:14:11','2026-01-20 15:14:12','2026-01-20 15:17:35','tempest-AttachVolumeMultiAttachTest-volume-1457483939',NULL,'{\"saved_features\":61}',NULL,NULL,'b55b5d00-8b4e-41a3-ab81-22610acc7e5e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:48:38','2026-01-20 14:51:20','2026-01-20 14:51:21',1,'8cd2ec74-aafb-4e12-a845-44b6fe96ba18',NULL,'1d45e7e42e6d419898780db108ff93ff','b15c4e6eb57e4b0ca4e63c85ed92fc5f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:48:38','2026-01-20 14:48:46','2026-01-20 14:51:20','tempest-TaggedBootDevicesTest-volume-557834578',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:38:30','2026-01-20 14:40:34','2026-01-20 14:40:36',1,'8e23d5c7-a222-4e45-8e31-6afe42582e8d',NULL,'cd4ba32a01f74af199438da0b72e5a4d','8705404c3964472782118e478eb54e51','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:38:30','2026-01-20 14:38:38','2026-01-20 14:40:34','tempest-TaggedBootDevicesTest_v242-volume-322114637',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:47:20','2026-01-20 14:48:40','2026-01-20 14:48:41',1,'9219aafd-6c66-4f38-9927-85b54b4175ae',NULL,'869086208e10436c9dc96c78bee9a85d','b683fcc0026242e28ba6d8fba638688e','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:47:20','2026-01-20 14:47:27','2026-01-20 14:48:40','tempest-tempest.common.compute-volume-737004476',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 15:15:04','2026-01-20 15:17:27','2026-01-20 15:17:28',1,'933c5c7a-f496-4bcc-b304-68156c235fe5',NULL,'e9cc4ce3e069479ba9c789b378a68a1d','fff727019f86407498e83d7948d54962','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 15:15:06','2026-01-20 15:15:06','2026-01-20 15:17:27','tempest-AttachVolumeMultiAttachTest-volume-174062979',NULL,'{\"saved_features\":61}',NULL,NULL,'b55b5d00-8b4e-41a3-ab81-22610acc7e5e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 15:05:20','2026-01-20 15:07:11','2026-01-20 15:07:12',1,'94300d81-b4ca-4c0a-9283-83b76826d40f',NULL,'b02a8ef6cc3946ceb2c8846aae2eae68','0fc924d2df984301897e81920c5e192f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 15:05:20','2026-01-20 15:05:30','2026-01-20 15:07:11','tempest-tempest.common.compute-volume-1330632735',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:57:21','2026-01-20 15:00:06','2026-01-20 15:00:06',1,'94858b1a-370f-4ee8-b017-647fe5082382',NULL,'ed2c9bd268d1491fa3484d86bcdb9ec6','107c1f3b5b7b413d9a389ca1166e331f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:57:21','2026-01-20 14:57:29','2026-01-20 15:00:06','tempest-TestInstancesWithCinderVolumes-volume-1422577353',NULL,NULL,NULL,NULL,'d5b753be-e483-474f-aacf-74aa9d003304',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 15:16:52','2026-01-20 15:17:24','2026-01-20 15:17:26',1,'972ce456-91dd-4e78-8ae7-4dd3cb2257e8',NULL,'e9cc4ce3e069479ba9c789b378a68a1d','fff727019f86407498e83d7948d54962','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 15:16:53','2026-01-20 15:17:00','2026-01-20 15:17:24','tempest-AttachVolumeMultiAttachTest-volume-1419128264',NULL,'{\"saved_features\":61}',NULL,NULL,'b55b5d00-8b4e-41a3-ab81-22610acc7e5e',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:48:49','2026-01-20 14:51:17','2026-01-20 14:51:18',1,'9a6aba77-de94-4bfe-8062-70d79455ddbe',NULL,'1d45e7e42e6d419898780db108ff93ff','b15c4e6eb57e4b0ca4e63c85ed92fc5f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:48:49','2026-01-20 14:48:49','2026-01-20 14:51:17','tempest-TaggedBootDevicesTest-volume-1809040722',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:59:39','2026-01-20 15:01:50','2026-01-20 15:01:51',1,'9b6cef43-07a2-4998-a095-c58fc6f9b550',NULL,'d77d3db3cf924683a608d10efefcd156','105e56abe3804424885c7aa8d1216d12','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:59:39','2026-01-20 14:59:39','2026-01-20 15:01:50','tempest-ServersNegativeTestJSON-volume-388454110',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 15:03:49','2026-01-20 15:04:57',NULL,0,'9d237554-9581-4577-897a-3907d38a0cb3',NULL,'2446e8399b344b29986c1aaf8bf73adf','63555e5851564db08c6429231d264f2c','hostgroup@ceph#ceph',1,'nova','available','detached','2026-01-20 15:03:50','2026-01-20 15:04:08',NULL,'','',NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 15:19:05','2026-01-20 15:22:15','2026-01-20 15:22:16',1,'9f3cabb8-d51f-4db9-97b3-c5b764893ee2',NULL,'cd9a8f26b71f4631a387e555e6b18428','9156c0a9920c4721843416b9a44404f9','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 15:19:05','2026-01-20 15:19:05','2026-01-20 15:22:15','tempest-AttachVolumeNegativeTest-volume-13407021',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:55:16','2026-01-20 14:56:14','2026-01-20 14:56:15',1,'a731fcaa-4151-4307-ba1b-6515889f3a7c',NULL,'34eb73f628994c11801d447148d5f142','b1e83af992c94112a965575784639d77','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:55:16','2026-01-20 14:55:16','2026-01-20 14:56:14','tempest-AttachVolumeShelveTestJSON-volume-750622108',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:45:35','2026-01-20 14:48:47','2026-01-20 14:48:48',1,'aab03340-0e79-412e-a963-e216832603c4',NULL,'869086208e10436c9dc96c78bee9a85d','b683fcc0026242e28ba6d8fba638688e','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:45:35','2026-01-20 14:45:35','2026-01-20 14:48:47','tempest-ServerActionsTestOtherA-volume-1971997910',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:57:20','2026-01-20 14:59:38','2026-01-20 14:59:38',1,'ab9a0bc3-5c61-456d-9fc8-3cb8ce358e66',NULL,'ed2c9bd268d1491fa3484d86bcdb9ec6','107c1f3b5b7b413d9a389ca1166e331f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:57:20','2026-01-20 14:57:20','2026-01-20 14:59:38','tempest-TestInstancesWithCinderVolumes-volume-1413231525',NULL,NULL,NULL,NULL,'dbe07089-2a3b-4679-89d5-1cb270f6e395',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 15:06:09','2026-01-20 15:06:10','2026-01-20 15:06:10',1,'adcffcaa-1170-4516-be1e-22b8d1c23920',NULL,'8560f9b6edd74b238f90f667e46566ac','329ef67ba7884caa87edf40d2d26e70f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 15:06:09','2026-01-20 15:06:09','2026-01-20 15:06:10','tempest-VolumesGetTestJSON-Volume-712652699',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:57:19','2026-01-20 14:59:34','2026-01-20 14:59:35',1,'b0619b28-88eb-4051-9e30-36100f39c117',NULL,'ed2c9bd268d1491fa3484d86bcdb9ec6','107c1f3b5b7b413d9a389ca1166e331f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:57:19','2026-01-20 14:57:20','2026-01-20 14:59:34','tempest-TestInstancesWithCinderVolumes-volume-1444075858',NULL,NULL,NULL,NULL,'dad3fd93-bc09-47b4-96fe-8d0ba8dd19e7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 15:05:23','2026-01-20 15:05:42','2026-01-20 15:05:43',1,'b2752651-d07b-4c58-8781-1b28cd47b400',NULL,'912329b1a6ad42bdb72e952c03983bdf','96f7b14c2a9348f08305fe232df2a603','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 15:05:24','2026-01-20 15:05:24','2026-01-20 15:05:42','tempest-AttachVolumeTestJSON-volume-537767891',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:52:55','2026-01-20 14:54:40','2026-01-20 14:54:42',1,'b687fb44-6160-427b-b91a-091715876a58',NULL,'15c455b119784bb9abe8e4774dadd01e','0ad54030e5cc477e939e073b52024ec4','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:52:58','2026-01-20 14:53:08','2026-01-20 14:54:40','tempest-tempest.common.compute-volume-828267354',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'reserved',NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:29:10','2026-01-20 14:31:51','2026-01-20 14:31:52',1,'b7f4909e-d176-4977-8b2d-c4938b4a92d0',NULL,'6a3fbc3f92a849e88cbf34d28ca17e43','0cee74dd60da4a839bb5eb0ba3137edf','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:29:10','2026-01-20 14:29:10','2026-01-20 14:31:51','tempest-UpdateMultiattachVolumeNegativeTest-volume-1650831698',NULL,'{\"saved_features\":61}',NULL,NULL,'b55b5d00-8b4e-41a3-ab81-22610acc7e5e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:56:27','2026-01-20 14:56:34','2026-01-20 14:56:36',1,'b89dc598-8fba-4f9a-8997-6a54f30049ce',NULL,'caca84670125404db34273d4d6da36df','fb4410ee5e824adfa71950de60e627af','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:56:27','2026-01-20 14:56:27','2026-01-20 14:56:34','tempest-VolumesTestJSON-volume-1186335192',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 15:10:26','2026-01-20 15:11:00','2026-01-20 15:11:01',1,'c2176e35-f749-46e4-b63a-1d086dd1705c',NULL,'bf422e55e158420cbdae75f07a3bb97a','a49638950e1543fa8e0d251af5479623','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 15:10:26','2026-01-20 15:10:36','2026-01-20 15:11:00','tempest-TestVolumeBootPattern-volume-origin-123277425',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 15:13:10','2026-01-20 15:17:53','2026-01-20 15:17:54',1,'c46398b2-4b96-4ab6-ac9b-93d7ea349e92',NULL,'e9cc4ce3e069479ba9c789b378a68a1d','fff727019f86407498e83d7948d54962','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 15:13:10','2026-01-20 15:13:19','2026-01-20 15:17:53','tempest-AttachVolumeMultiAttachTest-volume-211425527',NULL,'{\"saved_features\":61}',NULL,NULL,'b55b5d00-8b4e-41a3-ab81-22610acc7e5e',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 15:10:03','2026-01-20 15:11:14','2026-01-20 15:11:15',1,'c53232c5-7839-4cc5-8acf-4257d1fb7c13',NULL,'c98bd3f0904e48efa524d598bcad85e9','5b43342be22543f79d4a56e26c6d0c96','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 15:10:03','2026-01-20 15:10:03','2026-01-20 15:11:14','tempest-TestMinimumBasicScenario-volume-830826033',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 15:09:49','2026-01-20 15:10:23','2026-01-20 15:10:24',1,'ccb7c984-4606-40ef-8fcd-a902f5382dee',NULL,'bf422e55e158420cbdae75f07a3bb97a','a49638950e1543fa8e0d251af5479623','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 15:09:49','2026-01-20 15:09:56','2026-01-20 15:10:23','tempest-TestVolumeBootPattern-volume-1435434677',NULL,NULL,NULL,NULL,'97532ec0-0821-4438-834b-3de729339510',NULL,1,NULL,NULL,'349091f0-57cd-4e7a-b935-410f986b1500',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 15:02:54','2026-01-20 15:05:46','2026-01-20 15:05:47',1,'d50f7be5-09c1-4898-894c-704176a797ac',NULL,'912329b1a6ad42bdb72e952c03983bdf','96f7b14c2a9348f08305fe232df2a603','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 15:02:55','2026-01-20 15:02:55','2026-01-20 15:05:46','tempest-AttachVolumeTestJSON-volume-2008101624',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 15:05:18','2026-01-20 15:05:44','2026-01-20 15:05:45',1,'d93c7cb1-0f58-41fe-b846-7d4d85545927',NULL,'912329b1a6ad42bdb72e952c03983bdf','96f7b14c2a9348f08305fe232df2a603','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 15:05:18','2026-01-20 15:05:18','2026-01-20 15:05:44','tempest-AttachVolumeTestJSON-volume-1902371822',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:33:59','2026-01-20 14:34:03','2026-01-20 14:34:03',1,'ea6ddff9-b33e-45d9-91ac-1c2e7ce9cb66',NULL,'729ca8a2a7414735af25d05df4a563b9','48488e875f2e472f97f07cc7ee07e0be','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:33:59','2026-01-20 14:34:01','2026-01-20 14:34:03','tempest-VolumesAdminNegativeTest-volume-147363280',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 15:05:57','2026-01-20 15:06:02','2026-01-20 15:06:03',1,'ec1cc32d-4158-4bf6-a67c-0c226a21fb04',NULL,'f2cbb7f709bf4399b8a8137d2cbab438','f9a4fb1ea67548318c6ff2af4e9d4abe','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 15:05:58','2026-01-20 15:05:59','2026-01-20 15:06:02','tempest-VolumesSnapshotsTestJSON-volume-2079859140',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:59:34','2026-01-20 15:01:52','2026-01-20 15:01:53',1,'f1f8aaee-b13b-470c-963b-331d93437390',NULL,'d77d3db3cf924683a608d10efefcd156','105e56abe3804424885c7aa8d1216d12','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:59:34','2026-01-20 14:59:35','2026-01-20 15:01:52','tempest-ServersNegativeTestJSON-volume-1802472022',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 15:10:45','2026-01-20 15:10:57','2026-01-20 15:10:58',1,'f396a213-a7f4-434e-a290-c5d9278be4af',NULL,'bf422e55e158420cbdae75f07a3bb97a','a49638950e1543fa8e0d251af5479623','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 15:10:45','2026-01-20 15:10:45','2026-01-20 15:10:57','','',NULL,NULL,'33f09854-2fbb-41ab-84ee-a1c4a1274b2b','04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 14:55:12','2026-01-20 14:57:44','2026-01-20 14:57:45',1,'f3a427b1-0e50-45b1-a975-3d7aabd0195a',NULL,'215db37373dc4ae5a75cbd6866f471da','b3b1b7f5b4f84b5abbc401eb577c85c0','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 14:55:12','2026-01-20 14:55:12','2026-01-20 14:57:44','tempest-ServerActionsTestOtherB-volume-1621173241',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 15:20:57','2026-01-20 15:22:14','2026-01-20 15:22:14',1,'f458dd1d-0a83-4853-b1f9-6b4923a44988',NULL,'cd9a8f26b71f4631a387e555e6b18428','9156c0a9920c4721843416b9a44404f9','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 15:20:57','2026-01-20 15:20:57','2026-01-20 15:22:14','tempest-AttachVolumeNegativeTest-volume-2045415141',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1),('2026-01-20 15:11:03','2026-01-20 15:12:42','2026-01-20 15:12:43',1,'fd11049d-6334-4d6c-ac5d-8cfeca690b75',NULL,'bf422e55e158420cbdae75f07a3bb97a','a49638950e1543fa8e0d251af5479623','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-20 15:11:03','2026-01-20 15:11:10','2026-01-20 15:12:42','tempest-TestVolumeBootPattern-volume-origin-1007338085',NULL,NULL,NULL,NULL,'04dd119c-1c6c-4ffc-95c3-44156e411410',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'63e5c6e5-d011-4c19-aff2-ccf017f6ecc5',0,1);
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workers`
--

DROP TABLE IF EXISTS `workers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `workers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(40) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  `status` varchar(255) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_type` (`resource_type`,`resource_id`),
  KEY `ix_workers_service_id` (`service_id`),
  CONSTRAINT `workers_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=145 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workers`
--

LOCK TABLES `workers` WRITE;
/*!40000 ALTER TABLE `workers` DISABLE KEYS */;
INSERT INTO `workers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `resource_type`, `resource_id`, `status`, `service_id`, `race_preventer`) VALUES ('2026-01-20 13:41:32','2026-01-20 13:41:32.000123',NULL,0,1,'SENTINEL','SUB-SECOND','OK',NULL,0);
/*!40000 ALTER TABLE `workers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `glance`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `glance` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `glance`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('2023_1_contract01');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_locations`
--

DROP TABLE IF EXISTS `image_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `meta_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `ix_image_locations_deleted` (`deleted`),
  KEY `ix_image_locations_image_id` (`image_id`),
  CONSTRAINT `image_locations_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_locations`
--

LOCK TABLES `image_locations` WRITE;
/*!40000 ALTER TABLE `image_locations` DISABLE KEYS */;
INSERT INTO `image_locations` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `meta_data`, `status`) VALUES (1,'a32b3e07-16d8-46fd-9a7b-c242c432fcf9','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/a32b3e07-16d8-46fd-9a7b-c242c432fcf9/snap','2026-01-20 14:22:01','2026-01-20 14:22:01',NULL,0,'{\"store\": \"default_backend\"}','active'),(2,'26699514-f465-4b50-98b7-36f2cfc6a308','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/26699514-f465-4b50-98b7-36f2cfc6a308/snap','2026-01-20 14:22:04','2026-01-20 14:22:04',NULL,0,'{\"store\": \"default_backend\"}','active'),(3,'9b402b85-ed3a-4c51-8c4a-aeeda86dfa7c','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/9b402b85-ed3a-4c51-8c4a-aeeda86dfa7c/snap','2026-01-20 14:25:46','2026-01-20 14:26:01','2026-01-20 14:26:01',1,'{\"store\": \"default_backend\"}','deleted'),(4,'0db5d54c-c1b5-4100-80fe-c616a5483520','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/0db5d54c-c1b5-4100-80fe-c616a5483520/snap','2026-01-20 14:26:23','2026-01-20 14:26:47','2026-01-20 14:26:47',1,'{\"store\": \"default_backend\"}','deleted'),(5,'afa12d53-6955-4be8-8dd3-8e7dd18a3d5b','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/afa12d53-6955-4be8-8dd3-8e7dd18a3d5b/snap','2026-01-20 14:27:37','2026-01-20 14:28:31','2026-01-20 14:28:31',1,'{\"store\": \"default_backend\"}','deleted'),(6,'742404f3-b52a-4648-b775-447fbe30a8ba','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/742404f3-b52a-4648-b775-447fbe30a8ba/snap','2026-01-20 14:33:20','2026-01-20 14:33:25','2026-01-20 14:33:25',1,'{\"store\": \"default_backend\"}','deleted'),(7,'da03482c-d942-4ea0-90cf-c59249a144d3','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/da03482c-d942-4ea0-90cf-c59249a144d3/snap','2026-01-20 14:34:39','2026-01-20 14:34:57','2026-01-20 14:34:57',1,'{\"store\": \"default_backend\"}','deleted'),(8,'89cb760a-362a-4b7a-b627-ed8e6a5c1479','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/89cb760a-362a-4b7a-b627-ed8e6a5c1479/snap','2026-01-20 14:34:48','2026-01-20 14:35:52','2026-01-20 14:35:52',1,'{\"store\": \"default_backend\"}','deleted'),(9,'74b6b72a-3e89-4e91-95cd-b3413cc32773','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/74b6b72a-3e89-4e91-95cd-b3413cc32773/snap','2026-01-20 14:34:50','2026-01-20 14:34:52','2026-01-20 14:34:52',1,'{\"store\": \"default_backend\"}','deleted'),(10,'f0498d09-bfa2-4660-8970-6d771b829afc','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/f0498d09-bfa2-4660-8970-6d771b829afc/snap','2026-01-20 14:34:51','2026-01-20 14:35:51','2026-01-20 14:35:51',1,'{\"store\": \"default_backend\"}','deleted'),(11,'8243602f-b497-404e-8582-5eabf284cdfc','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/8243602f-b497-404e-8582-5eabf284cdfc/snap','2026-01-20 14:34:54','2026-01-20 14:35:49','2026-01-20 14:35:49',1,'{\"store\": \"default_backend\"}','deleted'),(12,'70955243-a059-4d15-b65b-03ec50f95c21','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/70955243-a059-4d15-b65b-03ec50f95c21/snap','2026-01-20 14:35:11','2026-01-20 14:35:39','2026-01-20 14:35:39',1,'{\"store\": \"default_backend\"}','deleted'),(13,'c6ead139-3a05-4d56-8181-f09e7d084275','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/c6ead139-3a05-4d56-8181-f09e7d084275/snap','2026-01-20 14:35:20','2026-01-20 14:35:38','2026-01-20 14:35:38',1,'{\"store\": \"default_backend\"}','deleted'),(14,'606f74dc-79ac-4b4e-b154-695b258203bd','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/606f74dc-79ac-4b4e-b154-695b258203bd/snap','2026-01-20 14:35:27','2026-01-20 14:35:37','2026-01-20 14:35:37',1,'{\"store\": \"default_backend\"}','deleted'),(15,'656ef5b8-a536-420e-a7a3-850a33da38a8','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/656ef5b8-a536-420e-a7a3-850a33da38a8/snap','2026-01-20 14:35:37','2026-01-20 14:35:40','2026-01-20 14:35:40',1,'{\"store\": \"default_backend\"}','deleted'),(16,'fba3fdca-b283-4008-bac5-0575a6416bc7','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/fba3fdca-b283-4008-bac5-0575a6416bc7/snap','2026-01-20 14:36:05','2026-01-20 14:36:11','2026-01-20 14:36:11',1,'{\"store\": \"default_backend\"}','deleted'),(17,'71863f13-4d5e-4ff6-bbc9-d5be0e9690ff','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/71863f13-4d5e-4ff6-bbc9-d5be0e9690ff/snap','2026-01-20 14:36:09','2026-01-20 14:36:12','2026-01-20 14:36:12',1,'{\"store\": \"default_backend\"}','deleted'),(18,'17b86a15-4cdb-41f2-82a9-c343b2420f69','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/17b86a15-4cdb-41f2-82a9-c343b2420f69/snap','2026-01-20 14:36:19','2026-01-20 14:36:23','2026-01-20 14:36:23',1,'{\"store\": \"default_backend\"}','deleted'),(19,'d9608a6b-abac-47e3-a9dd-70a6230a92c0','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/d9608a6b-abac-47e3-a9dd-70a6230a92c0/snap','2026-01-20 14:36:37','2026-01-20 14:37:07','2026-01-20 14:37:07',1,'{\"store\": \"default_backend\"}','deleted'),(20,'20f02a0e-ef11-4157-9d07-37674d1e0ea8','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/20f02a0e-ef11-4157-9d07-37674d1e0ea8/snap','2026-01-20 14:45:42','2026-01-20 14:45:57','2026-01-20 14:45:57',1,'{\"store\": \"default_backend\"}','deleted'),(21,'7586ccfe-36ea-40bd-b70d-ce54b80b5faa','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/7586ccfe-36ea-40bd-b70d-ce54b80b5faa/snap','2026-01-20 14:50:38','2026-01-20 14:54:53','2026-01-20 14:54:53',1,'{\"store\": \"default_backend\"}','deleted'),(22,'ae5aa156-02f2-4cbe-8c3c-a41c7fd78b5c','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/ae5aa156-02f2-4cbe-8c3c-a41c7fd78b5c/snap','2026-01-20 14:51:30','2026-01-20 14:54:48','2026-01-20 14:54:48',1,'{\"store\": \"default_backend\"}','deleted'),(23,'a1d1cbcb-c6a5-49c9-8868-06c3872a40d2','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/a1d1cbcb-c6a5-49c9-8868-06c3872a40d2/snap','2026-01-20 14:52:11','2026-01-20 14:54:41','2026-01-20 14:54:41',1,'{\"store\": \"default_backend\"}','deleted'),(24,'165549fb-68ff-4d9c-ab65-c85189d23d7d','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/165549fb-68ff-4d9c-ab65-c85189d23d7d/snap','2026-01-20 14:52:43','2026-01-20 14:53:07','2026-01-20 14:53:07',1,'{\"store\": \"default_backend\"}','deleted'),(25,'d9e08301-4600-4321-b633-e7777cc1e842','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/d9e08301-4600-4321-b633-e7777cc1e842/snap','2026-01-20 14:52:54','2026-01-20 14:53:13','2026-01-20 14:53:13',1,'{\"store\": \"default_backend\"}','deleted'),(26,'bf636010-1d3c-4028-9e00-bc1bb08e7dca','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/bf636010-1d3c-4028-9e00-bc1bb08e7dca/snap','2026-01-20 14:53:05','2026-01-20 14:53:11','2026-01-20 14:53:11',1,'{\"store\": \"default_backend\"}','deleted'),(27,'132a812e-f4a2-4a8b-813d-1df62e09798a','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/132a812e-f4a2-4a8b-813d-1df62e09798a/snap','2026-01-20 14:53:36','2026-01-20 14:54:33','2026-01-20 14:54:33',1,'{\"store\": \"default_backend\"}','deleted'),(28,'6e97db8b-a462-4791-9edf-594ed0f547e6','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/6e97db8b-a462-4791-9edf-594ed0f547e6/snap','2026-01-20 14:53:52','2026-01-20 14:54:14','2026-01-20 14:54:14',1,'{\"store\": \"default_backend\"}','deleted'),(29,'0f1d91a7-05af-4ed6-87af-1e03976e25f0','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/0f1d91a7-05af-4ed6-87af-1e03976e25f0/snap','2026-01-20 14:55:27','2026-01-20 14:55:50','2026-01-20 14:55:50',1,'{\"store\": \"default_backend\"}','deleted'),(30,'6fa40815-d8ae-463b-8e43-fe8a8d4374e5','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/6fa40815-d8ae-463b-8e43-fe8a8d4374e5/snap','2026-01-20 14:56:52','2026-01-20 14:57:38','2026-01-20 14:57:38',1,'{\"store\": \"default_backend\"}','deleted'),(31,'1f2389f5-ba66-4c2e-9f07-9051cd05b976','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/1f2389f5-ba66-4c2e-9f07-9051cd05b976/snap','2026-01-20 14:57:12','2026-01-20 14:57:33','2026-01-20 14:57:33',1,'{\"store\": \"default_backend\"}','deleted'),(32,'099d94f6-c2d2-4c82-ab5e-5cf0c5d78fac','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/099d94f6-c2d2-4c82-ab5e-5cf0c5d78fac/snap','2026-01-20 14:57:18','2026-01-20 15:00:10','2026-01-20 15:00:10',1,'{\"store\": \"default_backend\"}','deleted'),(33,'8976571c-92ae-42ce-94dd-a05ec6e308b3','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/8976571c-92ae-42ce-94dd-a05ec6e308b3/snap','2026-01-20 15:00:51','2026-01-20 15:01:23','2026-01-20 15:01:23',1,'{\"store\": \"default_backend\"}','deleted'),(34,'9c1c8ad1-376e-4dd8-93d8-70f0aa412977','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/9c1c8ad1-376e-4dd8-93d8-70f0aa412977/snap','2026-01-20 15:01:38','2026-01-20 15:05:18','2026-01-20 15:05:18',1,'{\"store\": \"default_backend\"}','deleted'),(35,'97fb0fa0-6803-480b-96d2-4a219153376d','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/97fb0fa0-6803-480b-96d2-4a219153376d/snap','2026-01-20 15:02:25','2026-01-20 15:03:40','2026-01-20 15:03:40',1,'{\"store\": \"default_backend\"}','deleted'),(36,'fc0edfd5-d120-40a0-889d-d3576a58edb6','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/fc0edfd5-d120-40a0-889d-d3576a58edb6/snap','2026-01-20 15:03:21','2026-01-20 15:03:24','2026-01-20 15:03:24',1,'{\"store\": \"default_backend\"}','deleted'),(37,'7f0d068e-5d2b-485d-b65c-7244508ab6b6','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/7f0d068e-5d2b-485d-b65c-7244508ab6b6/snap','2026-01-20 15:03:35','2026-01-20 15:05:00','2026-01-20 15:05:00',1,'{\"store\": \"default_backend\"}','deleted'),(38,'54adca73-9204-4335-8f5e-a77f60750fc4','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/54adca73-9204-4335-8f5e-a77f60750fc4/snap','2026-01-20 15:04:19','2026-01-20 15:04:47','2026-01-20 15:04:47',1,'{\"store\": \"default_backend\"}','deleted'),(39,'8c970c65-2888-4da3-891e-c2b6eb3ea735','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/8c970c65-2888-4da3-891e-c2b6eb3ea735/snap','2026-01-20 15:06:06','2026-01-20 15:07:13','2026-01-20 15:07:13',1,'{\"store\": \"default_backend\"}','deleted'),(40,'5b64c953-6df3-45a3-ae28-e419ba117bb2','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/5b64c953-6df3-45a3-ae28-e419ba117bb2/snap','2026-01-20 15:08:30','2026-01-20 15:09:44','2026-01-20 15:09:44',1,'{\"store\": \"default_backend\"}','deleted'),(41,'f6b86f20-6a27-42dc-9911-14ae5e0ee2dc','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/f6b86f20-6a27-42dc-9911-14ae5e0ee2dc/snap','2026-01-20 15:09:46','2026-01-20 15:11:21','2026-01-20 15:11:21',1,'{\"store\": \"default_backend\"}','deleted'),(42,'172aeba8-ca4a-4189-856b-42b685d4813d','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/172aeba8-ca4a-4189-856b-42b685d4813d/snap','2026-01-20 15:11:46','2026-01-20 15:12:47','2026-01-20 15:12:47',1,'{\"store\": \"default_backend\"}','deleted'),(43,'446516df-d591-4d87-84ee-415617f85cc0','rbd://e399cf45-e6b6-5393-99f1-75c601d3f188/images/446516df-d591-4d87-84ee-415617f85cc0/snap','2026-01-20 15:17:16','2026-01-20 15:17:27','2026-01-20 15:17:27',1,'{\"store\": \"default_backend\"}','deleted');
/*!40000 ALTER TABLE `image_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_members`
--

DROP TABLE IF EXISTS `image_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `member` varchar(255) NOT NULL,
  `can_share` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image_members_image_id_member_deleted_at_key` (`image_id`,`member`,`deleted_at`),
  KEY `ix_image_members_deleted` (`deleted`),
  KEY `ix_image_members_image_id` (`image_id`),
  KEY `ix_image_members_image_id_member` (`image_id`,`member`),
  CONSTRAINT `image_members_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`can_share` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_members`
--

LOCK TABLES `image_members` WRITE;
/*!40000 ALTER TABLE `image_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_properties`
--

DROP TABLE IF EXISTS `image_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_image_properties_image_id_name` (`image_id`,`name`),
  KEY `ix_image_properties_deleted` (`deleted`),
  KEY `ix_image_properties_image_id` (`image_id`),
  CONSTRAINT `image_properties_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=661 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_properties`
--

LOCK TABLES `image_properties` WRITE;
/*!40000 ALTER TABLE `image_properties` DISABLE KEYS */;
INSERT INTO `image_properties` (`id`, `image_id`, `name`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'a32b3e07-16d8-46fd-9a7b-c242c432fcf9','hw_rng_model','virtio','2026-01-20 14:21:57','2026-01-20 14:21:57',NULL,0),(2,'26699514-f465-4b50-98b7-36f2cfc6a308','hw_rng_model','virtio','2026-01-20 14:22:02','2026-01-20 14:22:02',NULL,0),(3,'9b402b85-ed3a-4c51-8c4a-aeeda86dfa7c','hw_rng_model','virtio','2026-01-20 14:25:27','2026-01-20 14:26:01','2026-01-20 14:26:01',1),(4,'9b402b85-ed3a-4c51-8c4a-aeeda86dfa7c','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 14:25:27','2026-01-20 14:26:01','2026-01-20 14:26:01',1),(5,'9b402b85-ed3a-4c51-8c4a-aeeda86dfa7c','owner_user_name','tempest-UnshelveToHostMultiNodesTest-997401309-project-member','2026-01-20 14:25:27','2026-01-20 14:26:01','2026-01-20 14:26:01',1),(6,'9b402b85-ed3a-4c51-8c4a-aeeda86dfa7c','owner_project_name','tempest-UnshelveToHostMultiNodesTest-997401309','2026-01-20 14:25:27','2026-01-20 14:26:01','2026-01-20 14:26:01',1),(7,'9b402b85-ed3a-4c51-8c4a-aeeda86dfa7c','boot_roles','reader,member','2026-01-20 14:25:27','2026-01-20 14:26:01','2026-01-20 14:26:01',1),(8,'9b402b85-ed3a-4c51-8c4a-aeeda86dfa7c','hw_machine_type','q35','2026-01-20 14:25:27','2026-01-20 14:26:01','2026-01-20 14:26:01',1),(9,'9b402b85-ed3a-4c51-8c4a-aeeda86dfa7c','hw_cdrom_bus','sata','2026-01-20 14:25:27','2026-01-20 14:26:01','2026-01-20 14:26:01',1),(10,'9b402b85-ed3a-4c51-8c4a-aeeda86dfa7c','hw_disk_bus','virtio','2026-01-20 14:25:27','2026-01-20 14:26:01','2026-01-20 14:26:01',1),(11,'9b402b85-ed3a-4c51-8c4a-aeeda86dfa7c','hw_input_bus','usb','2026-01-20 14:25:27','2026-01-20 14:26:01','2026-01-20 14:26:01',1),(12,'9b402b85-ed3a-4c51-8c4a-aeeda86dfa7c','hw_pointer_model','usbtablet','2026-01-20 14:25:27','2026-01-20 14:26:01','2026-01-20 14:26:01',1),(13,'9b402b85-ed3a-4c51-8c4a-aeeda86dfa7c','hw_video_model','virtio','2026-01-20 14:25:27','2026-01-20 14:26:01','2026-01-20 14:26:01',1),(14,'9b402b85-ed3a-4c51-8c4a-aeeda86dfa7c','hw_vif_model','virtio','2026-01-20 14:25:27','2026-01-20 14:26:01','2026-01-20 14:26:01',1),(15,'9b402b85-ed3a-4c51-8c4a-aeeda86dfa7c','instance_uuid','6091ab6e-2530-4b48-b482-00867d3c66c5','2026-01-20 14:25:27','2026-01-20 14:26:01','2026-01-20 14:26:01',1),(16,'9b402b85-ed3a-4c51-8c4a-aeeda86dfa7c','user_id','8ea9f3cd2cbb462a8ecbb488e6a1a25d','2026-01-20 14:25:27','2026-01-20 14:26:01','2026-01-20 14:26:01',1),(17,'9b402b85-ed3a-4c51-8c4a-aeeda86dfa7c','image_type','snapshot','2026-01-20 14:25:27','2026-01-20 14:26:01','2026-01-20 14:26:01',1),(18,'9b402b85-ed3a-4c51-8c4a-aeeda86dfa7c','image_state','available','2026-01-20 14:25:46','2026-01-20 14:26:01','2026-01-20 14:26:01',1),(19,'9b402b85-ed3a-4c51-8c4a-aeeda86dfa7c','owner_id','14ebcff06a484899a9725832f1eddfdf','2026-01-20 14:25:46','2026-01-20 14:26:01','2026-01-20 14:26:01',1),(20,'9b402b85-ed3a-4c51-8c4a-aeeda86dfa7c','image_location','snapshot','2026-01-20 14:25:46','2026-01-20 14:26:01','2026-01-20 14:26:01',1),(21,'0db5d54c-c1b5-4100-80fe-c616a5483520','hw_rng_model','virtio','2026-01-20 14:26:03','2026-01-20 14:26:47','2026-01-20 14:26:47',1),(22,'0db5d54c-c1b5-4100-80fe-c616a5483520','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 14:26:03','2026-01-20 14:26:47','2026-01-20 14:26:47',1),(23,'0db5d54c-c1b5-4100-80fe-c616a5483520','owner_user_name','tempest-UnshelveToHostMultiNodesTest-997401309-project-member','2026-01-20 14:26:03','2026-01-20 14:26:47','2026-01-20 14:26:47',1),(24,'0db5d54c-c1b5-4100-80fe-c616a5483520','owner_project_name','tempest-UnshelveToHostMultiNodesTest-997401309','2026-01-20 14:26:03','2026-01-20 14:26:47','2026-01-20 14:26:47',1),(25,'0db5d54c-c1b5-4100-80fe-c616a5483520','boot_roles','reader,member','2026-01-20 14:26:03','2026-01-20 14:26:47','2026-01-20 14:26:47',1),(26,'0db5d54c-c1b5-4100-80fe-c616a5483520','hw_machine_type','q35','2026-01-20 14:26:03','2026-01-20 14:26:47','2026-01-20 14:26:47',1),(27,'0db5d54c-c1b5-4100-80fe-c616a5483520','hw_cdrom_bus','sata','2026-01-20 14:26:03','2026-01-20 14:26:47','2026-01-20 14:26:47',1),(28,'0db5d54c-c1b5-4100-80fe-c616a5483520','hw_disk_bus','virtio','2026-01-20 14:26:03','2026-01-20 14:26:47','2026-01-20 14:26:47',1),(29,'0db5d54c-c1b5-4100-80fe-c616a5483520','hw_input_bus','usb','2026-01-20 14:26:03','2026-01-20 14:26:47','2026-01-20 14:26:47',1),(30,'0db5d54c-c1b5-4100-80fe-c616a5483520','hw_pointer_model','usbtablet','2026-01-20 14:26:03','2026-01-20 14:26:47','2026-01-20 14:26:47',1),(31,'0db5d54c-c1b5-4100-80fe-c616a5483520','hw_video_model','virtio','2026-01-20 14:26:03','2026-01-20 14:26:47','2026-01-20 14:26:47',1),(32,'0db5d54c-c1b5-4100-80fe-c616a5483520','hw_vif_model','virtio','2026-01-20 14:26:03','2026-01-20 14:26:47','2026-01-20 14:26:47',1),(33,'0db5d54c-c1b5-4100-80fe-c616a5483520','clean_attempts','1','2026-01-20 14:26:03','2026-01-20 14:26:47','2026-01-20 14:26:47',1),(34,'0db5d54c-c1b5-4100-80fe-c616a5483520','instance_uuid','6091ab6e-2530-4b48-b482-00867d3c66c5','2026-01-20 14:26:03','2026-01-20 14:26:47','2026-01-20 14:26:47',1),(35,'0db5d54c-c1b5-4100-80fe-c616a5483520','user_id','8ea9f3cd2cbb462a8ecbb488e6a1a25d','2026-01-20 14:26:03','2026-01-20 14:26:47','2026-01-20 14:26:47',1),(36,'0db5d54c-c1b5-4100-80fe-c616a5483520','image_type','snapshot','2026-01-20 14:26:03','2026-01-20 14:26:47','2026-01-20 14:26:47',1),(37,'0db5d54c-c1b5-4100-80fe-c616a5483520','image_state','available','2026-01-20 14:26:22','2026-01-20 14:26:47','2026-01-20 14:26:47',1),(38,'0db5d54c-c1b5-4100-80fe-c616a5483520','owner_id','14ebcff06a484899a9725832f1eddfdf','2026-01-20 14:26:22','2026-01-20 14:26:47','2026-01-20 14:26:47',1),(39,'0db5d54c-c1b5-4100-80fe-c616a5483520','image_location','snapshot','2026-01-20 14:26:22','2026-01-20 14:26:47','2026-01-20 14:26:47',1),(40,'afa12d53-6955-4be8-8dd3-8e7dd18a3d5b','hw_scsi_model','virtio-scsi','2026-01-20 14:27:31','2026-01-20 14:28:31','2026-01-20 14:28:31',1),(41,'afa12d53-6955-4be8-8dd3-8e7dd18a3d5b','hw_disk_bus','scsi','2026-01-20 14:27:31','2026-01-20 14:28:31','2026-01-20 14:28:31',1),(42,'afa12d53-6955-4be8-8dd3-8e7dd18a3d5b','hw_cdrom_bus','scsi','2026-01-20 14:27:31','2026-01-20 14:28:31','2026-01-20 14:28:31',1),(43,'da03482c-d942-4ea0-90cf-c59249a144d3','os_version','alt1','2026-01-20 14:34:41','2026-01-20 14:34:57','2026-01-20 14:34:57',1),(44,'da03482c-d942-4ea0-90cf-c59249a144d3','os_distro','value2','2026-01-20 14:34:41','2026-01-20 14:34:57','2026-01-20 14:34:57',1),(45,'74b6b72a-3e89-4e91-95cd-b3413cc32773','hw_rng_model','virtio','2026-01-20 14:34:44','2026-01-20 14:34:52','2026-01-20 14:34:52',1),(46,'74b6b72a-3e89-4e91-95cd-b3413cc32773','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 14:34:44','2026-01-20 14:34:52','2026-01-20 14:34:52',1),(47,'74b6b72a-3e89-4e91-95cd-b3413cc32773','owner_user_name','tempest-ImagesTestJSON-338390217-project-member','2026-01-20 14:34:44','2026-01-20 14:34:52','2026-01-20 14:34:52',1),(48,'74b6b72a-3e89-4e91-95cd-b3413cc32773','owner_project_name','tempest-ImagesTestJSON-338390217','2026-01-20 14:34:44','2026-01-20 14:34:52','2026-01-20 14:34:52',1),(49,'74b6b72a-3e89-4e91-95cd-b3413cc32773','boot_roles','reader,member','2026-01-20 14:34:44','2026-01-20 14:34:52','2026-01-20 14:34:52',1),(50,'74b6b72a-3e89-4e91-95cd-b3413cc32773','hw_machine_type','q35','2026-01-20 14:34:44','2026-01-20 14:34:52','2026-01-20 14:34:52',1),(51,'74b6b72a-3e89-4e91-95cd-b3413cc32773','hw_cdrom_bus','sata','2026-01-20 14:34:44','2026-01-20 14:34:52','2026-01-20 14:34:52',1),(52,'74b6b72a-3e89-4e91-95cd-b3413cc32773','hw_disk_bus','virtio','2026-01-20 14:34:44','2026-01-20 14:34:52','2026-01-20 14:34:52',1),(53,'74b6b72a-3e89-4e91-95cd-b3413cc32773','hw_input_bus','usb','2026-01-20 14:34:44','2026-01-20 14:34:52','2026-01-20 14:34:52',1),(54,'74b6b72a-3e89-4e91-95cd-b3413cc32773','hw_pointer_model','usbtablet','2026-01-20 14:34:44','2026-01-20 14:34:52','2026-01-20 14:34:52',1),(55,'74b6b72a-3e89-4e91-95cd-b3413cc32773','hw_video_model','virtio','2026-01-20 14:34:44','2026-01-20 14:34:52','2026-01-20 14:34:52',1),(56,'74b6b72a-3e89-4e91-95cd-b3413cc32773','hw_vif_model','virtio','2026-01-20 14:34:44','2026-01-20 14:34:52','2026-01-20 14:34:52',1),(57,'74b6b72a-3e89-4e91-95cd-b3413cc32773','instance_uuid','39013d10-cf09-4fc7-826c-99746ff0eb68','2026-01-20 14:34:44','2026-01-20 14:34:52','2026-01-20 14:34:52',1),(58,'74b6b72a-3e89-4e91-95cd-b3413cc32773','user_id','56e2959629114d3d8a48e7a80ed96c4b','2026-01-20 14:34:44','2026-01-20 14:34:52','2026-01-20 14:34:52',1),(59,'74b6b72a-3e89-4e91-95cd-b3413cc32773','image_type','snapshot','2026-01-20 14:34:44','2026-01-20 14:34:52','2026-01-20 14:34:52',1),(60,'74b6b72a-3e89-4e91-95cd-b3413cc32773','image_state','available','2026-01-20 14:34:49','2026-01-20 14:34:52','2026-01-20 14:34:52',1),(61,'74b6b72a-3e89-4e91-95cd-b3413cc32773','image_location','snapshot','2026-01-20 14:34:49','2026-01-20 14:34:52','2026-01-20 14:34:52',1),(62,'74b6b72a-3e89-4e91-95cd-b3413cc32773','owner_id','3750c56415134773aa9d9880038f1749','2026-01-20 14:34:49','2026-01-20 14:34:52','2026-01-20 14:34:52',1),(63,'da03482c-d942-4ea0-90cf-c59249a144d3','architecture','value3','2026-01-20 14:34:50','2026-01-20 14:34:57','2026-01-20 14:34:57',1),(64,'70955243-a059-4d15-b65b-03ec50f95c21','hw_rng_model','virtio','2026-01-20 14:35:05','2026-01-20 14:35:39','2026-01-20 14:35:39',1),(65,'70955243-a059-4d15-b65b-03ec50f95c21','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 14:35:05','2026-01-20 14:35:39','2026-01-20 14:35:39',1),(66,'70955243-a059-4d15-b65b-03ec50f95c21','owner_user_name','tempest-ListImageFiltersTestJSON-1649594432-project-member','2026-01-20 14:35:05','2026-01-20 14:35:39','2026-01-20 14:35:39',1),(67,'70955243-a059-4d15-b65b-03ec50f95c21','owner_project_name','tempest-ListImageFiltersTestJSON-1649594432','2026-01-20 14:35:05','2026-01-20 14:35:39','2026-01-20 14:35:39',1),(68,'70955243-a059-4d15-b65b-03ec50f95c21','boot_roles','reader,member','2026-01-20 14:35:05','2026-01-20 14:35:39','2026-01-20 14:35:39',1),(69,'70955243-a059-4d15-b65b-03ec50f95c21','hw_machine_type','q35','2026-01-20 14:35:05','2026-01-20 14:35:39','2026-01-20 14:35:39',1),(70,'70955243-a059-4d15-b65b-03ec50f95c21','hw_cdrom_bus','sata','2026-01-20 14:35:05','2026-01-20 14:35:39','2026-01-20 14:35:39',1),(71,'70955243-a059-4d15-b65b-03ec50f95c21','hw_disk_bus','virtio','2026-01-20 14:35:05','2026-01-20 14:35:39','2026-01-20 14:35:39',1),(72,'70955243-a059-4d15-b65b-03ec50f95c21','hw_input_bus','usb','2026-01-20 14:35:05','2026-01-20 14:35:39','2026-01-20 14:35:39',1),(73,'70955243-a059-4d15-b65b-03ec50f95c21','hw_pointer_model','usbtablet','2026-01-20 14:35:05','2026-01-20 14:35:39','2026-01-20 14:35:39',1),(74,'70955243-a059-4d15-b65b-03ec50f95c21','hw_video_model','virtio','2026-01-20 14:35:05','2026-01-20 14:35:39','2026-01-20 14:35:39',1),(75,'70955243-a059-4d15-b65b-03ec50f95c21','hw_vif_model','virtio','2026-01-20 14:35:05','2026-01-20 14:35:39','2026-01-20 14:35:39',1),(76,'70955243-a059-4d15-b65b-03ec50f95c21','instance_uuid','680a9e49-0486-46a0-8857-99a7a56c46e1','2026-01-20 14:35:05','2026-01-20 14:35:39','2026-01-20 14:35:39',1),(77,'70955243-a059-4d15-b65b-03ec50f95c21','user_id','72ad8e217e1348378596753eefca1452','2026-01-20 14:35:05','2026-01-20 14:35:39','2026-01-20 14:35:39',1),(78,'70955243-a059-4d15-b65b-03ec50f95c21','image_type','snapshot','2026-01-20 14:35:05','2026-01-20 14:35:39','2026-01-20 14:35:39',1),(79,'70955243-a059-4d15-b65b-03ec50f95c21','owner_id','9e10f687e8a14fc3bfa98df19df5befd','2026-01-20 14:35:10','2026-01-20 14:35:39','2026-01-20 14:35:39',1),(80,'70955243-a059-4d15-b65b-03ec50f95c21','image_state','available','2026-01-20 14:35:10','2026-01-20 14:35:39','2026-01-20 14:35:39',1),(81,'70955243-a059-4d15-b65b-03ec50f95c21','image_location','snapshot','2026-01-20 14:35:10','2026-01-20 14:35:39','2026-01-20 14:35:39',1),(82,'c6ead139-3a05-4d56-8181-f09e7d084275','hw_rng_model','virtio','2026-01-20 14:35:13','2026-01-20 14:35:38','2026-01-20 14:35:38',1),(83,'c6ead139-3a05-4d56-8181-f09e7d084275','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 14:35:13','2026-01-20 14:35:38','2026-01-20 14:35:38',1),(84,'c6ead139-3a05-4d56-8181-f09e7d084275','owner_user_name','tempest-ListImageFiltersTestJSON-1649594432-project-member','2026-01-20 14:35:13','2026-01-20 14:35:38','2026-01-20 14:35:38',1),(85,'c6ead139-3a05-4d56-8181-f09e7d084275','owner_project_name','tempest-ListImageFiltersTestJSON-1649594432','2026-01-20 14:35:13','2026-01-20 14:35:38','2026-01-20 14:35:38',1),(86,'c6ead139-3a05-4d56-8181-f09e7d084275','boot_roles','reader,member','2026-01-20 14:35:13','2026-01-20 14:35:38','2026-01-20 14:35:38',1),(87,'c6ead139-3a05-4d56-8181-f09e7d084275','hw_machine_type','q35','2026-01-20 14:35:13','2026-01-20 14:35:38','2026-01-20 14:35:38',1),(88,'c6ead139-3a05-4d56-8181-f09e7d084275','hw_cdrom_bus','sata','2026-01-20 14:35:13','2026-01-20 14:35:38','2026-01-20 14:35:38',1),(89,'c6ead139-3a05-4d56-8181-f09e7d084275','hw_disk_bus','virtio','2026-01-20 14:35:13','2026-01-20 14:35:38','2026-01-20 14:35:38',1),(90,'c6ead139-3a05-4d56-8181-f09e7d084275','hw_input_bus','usb','2026-01-20 14:35:13','2026-01-20 14:35:38','2026-01-20 14:35:38',1),(91,'c6ead139-3a05-4d56-8181-f09e7d084275','hw_pointer_model','usbtablet','2026-01-20 14:35:13','2026-01-20 14:35:38','2026-01-20 14:35:38',1),(92,'c6ead139-3a05-4d56-8181-f09e7d084275','hw_video_model','virtio','2026-01-20 14:35:13','2026-01-20 14:35:38','2026-01-20 14:35:38',1),(93,'c6ead139-3a05-4d56-8181-f09e7d084275','hw_vif_model','virtio','2026-01-20 14:35:13','2026-01-20 14:35:38','2026-01-20 14:35:38',1),(94,'c6ead139-3a05-4d56-8181-f09e7d084275','instance_uuid','f7ef5c6e-053e-4a03-a68f-60f399ea2fc9','2026-01-20 14:35:13','2026-01-20 14:35:38','2026-01-20 14:35:38',1),(95,'c6ead139-3a05-4d56-8181-f09e7d084275','user_id','72ad8e217e1348378596753eefca1452','2026-01-20 14:35:13','2026-01-20 14:35:38','2026-01-20 14:35:38',1),(96,'c6ead139-3a05-4d56-8181-f09e7d084275','image_type','snapshot','2026-01-20 14:35:13','2026-01-20 14:35:38','2026-01-20 14:35:38',1),(97,'c6ead139-3a05-4d56-8181-f09e7d084275','image_state','available','2026-01-20 14:35:19','2026-01-20 14:35:38','2026-01-20 14:35:38',1),(98,'c6ead139-3a05-4d56-8181-f09e7d084275','owner_id','9e10f687e8a14fc3bfa98df19df5befd','2026-01-20 14:35:19','2026-01-20 14:35:38','2026-01-20 14:35:38',1),(99,'c6ead139-3a05-4d56-8181-f09e7d084275','image_location','snapshot','2026-01-20 14:35:19','2026-01-20 14:35:38','2026-01-20 14:35:38',1),(100,'606f74dc-79ac-4b4e-b154-695b258203bd','hw_rng_model','virtio','2026-01-20 14:35:22','2026-01-20 14:35:37','2026-01-20 14:35:37',1),(101,'606f74dc-79ac-4b4e-b154-695b258203bd','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 14:35:22','2026-01-20 14:35:37','2026-01-20 14:35:37',1),(102,'606f74dc-79ac-4b4e-b154-695b258203bd','owner_user_name','tempest-ListImageFiltersTestJSON-1649594432-project-member','2026-01-20 14:35:22','2026-01-20 14:35:37','2026-01-20 14:35:37',1),(103,'606f74dc-79ac-4b4e-b154-695b258203bd','owner_project_name','tempest-ListImageFiltersTestJSON-1649594432','2026-01-20 14:35:22','2026-01-20 14:35:37','2026-01-20 14:35:37',1),(104,'606f74dc-79ac-4b4e-b154-695b258203bd','boot_roles','reader,member','2026-01-20 14:35:22','2026-01-20 14:35:37','2026-01-20 14:35:37',1),(105,'606f74dc-79ac-4b4e-b154-695b258203bd','hw_machine_type','q35','2026-01-20 14:35:22','2026-01-20 14:35:37','2026-01-20 14:35:37',1),(106,'606f74dc-79ac-4b4e-b154-695b258203bd','hw_cdrom_bus','sata','2026-01-20 14:35:22','2026-01-20 14:35:37','2026-01-20 14:35:37',1),(107,'606f74dc-79ac-4b4e-b154-695b258203bd','hw_disk_bus','virtio','2026-01-20 14:35:22','2026-01-20 14:35:37','2026-01-20 14:35:37',1),(108,'606f74dc-79ac-4b4e-b154-695b258203bd','hw_input_bus','usb','2026-01-20 14:35:22','2026-01-20 14:35:37','2026-01-20 14:35:37',1),(109,'606f74dc-79ac-4b4e-b154-695b258203bd','hw_pointer_model','usbtablet','2026-01-20 14:35:22','2026-01-20 14:35:37','2026-01-20 14:35:37',1),(110,'606f74dc-79ac-4b4e-b154-695b258203bd','hw_video_model','virtio','2026-01-20 14:35:22','2026-01-20 14:35:37','2026-01-20 14:35:37',1),(111,'606f74dc-79ac-4b4e-b154-695b258203bd','hw_vif_model','virtio','2026-01-20 14:35:22','2026-01-20 14:35:37','2026-01-20 14:35:37',1),(112,'606f74dc-79ac-4b4e-b154-695b258203bd','instance_uuid','680a9e49-0486-46a0-8857-99a7a56c46e1','2026-01-20 14:35:22','2026-01-20 14:35:37','2026-01-20 14:35:37',1),(113,'606f74dc-79ac-4b4e-b154-695b258203bd','user_id','72ad8e217e1348378596753eefca1452','2026-01-20 14:35:22','2026-01-20 14:35:37','2026-01-20 14:35:37',1),(114,'606f74dc-79ac-4b4e-b154-695b258203bd','image_type','snapshot','2026-01-20 14:35:22','2026-01-20 14:35:37','2026-01-20 14:35:37',1),(115,'606f74dc-79ac-4b4e-b154-695b258203bd','owner_id','9e10f687e8a14fc3bfa98df19df5befd','2026-01-20 14:35:26','2026-01-20 14:35:37','2026-01-20 14:35:37',1),(116,'606f74dc-79ac-4b4e-b154-695b258203bd','image_state','available','2026-01-20 14:35:26','2026-01-20 14:35:37','2026-01-20 14:35:37',1),(117,'606f74dc-79ac-4b4e-b154-695b258203bd','image_location','snapshot','2026-01-20 14:35:26','2026-01-20 14:35:37','2026-01-20 14:35:37',1),(118,'656ef5b8-a536-420e-a7a3-850a33da38a8','hw_rng_model','virtio','2026-01-20 14:35:32','2026-01-20 14:35:40','2026-01-20 14:35:40',1),(119,'656ef5b8-a536-420e-a7a3-850a33da38a8','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 14:35:32','2026-01-20 14:35:40','2026-01-20 14:35:40',1),(120,'656ef5b8-a536-420e-a7a3-850a33da38a8','owner_user_name','tempest-ImagesTestJSON-338390217-project-member','2026-01-20 14:35:32','2026-01-20 14:35:40','2026-01-20 14:35:40',1),(121,'656ef5b8-a536-420e-a7a3-850a33da38a8','owner_project_name','tempest-ImagesTestJSON-338390217','2026-01-20 14:35:32','2026-01-20 14:35:40','2026-01-20 14:35:40',1),(122,'656ef5b8-a536-420e-a7a3-850a33da38a8','boot_roles','reader,member','2026-01-20 14:35:32','2026-01-20 14:35:40','2026-01-20 14:35:40',1),(123,'656ef5b8-a536-420e-a7a3-850a33da38a8','hw_machine_type','q35','2026-01-20 14:35:32','2026-01-20 14:35:40','2026-01-20 14:35:40',1),(124,'656ef5b8-a536-420e-a7a3-850a33da38a8','hw_cdrom_bus','sata','2026-01-20 14:35:32','2026-01-20 14:35:40','2026-01-20 14:35:40',1),(125,'656ef5b8-a536-420e-a7a3-850a33da38a8','hw_disk_bus','virtio','2026-01-20 14:35:32','2026-01-20 14:35:40','2026-01-20 14:35:40',1),(126,'656ef5b8-a536-420e-a7a3-850a33da38a8','hw_input_bus','usb','2026-01-20 14:35:32','2026-01-20 14:35:40','2026-01-20 14:35:40',1),(127,'656ef5b8-a536-420e-a7a3-850a33da38a8','hw_pointer_model','usbtablet','2026-01-20 14:35:32','2026-01-20 14:35:40','2026-01-20 14:35:40',1),(128,'656ef5b8-a536-420e-a7a3-850a33da38a8','hw_video_model','virtio','2026-01-20 14:35:32','2026-01-20 14:35:40','2026-01-20 14:35:40',1),(129,'656ef5b8-a536-420e-a7a3-850a33da38a8','hw_vif_model','virtio','2026-01-20 14:35:32','2026-01-20 14:35:40','2026-01-20 14:35:40',1),(130,'656ef5b8-a536-420e-a7a3-850a33da38a8','instance_uuid','e22c5447-900e-45da-b2af-46423bc1e2d8','2026-01-20 14:35:32','2026-01-20 14:35:40','2026-01-20 14:35:40',1),(131,'656ef5b8-a536-420e-a7a3-850a33da38a8','user_id','56e2959629114d3d8a48e7a80ed96c4b','2026-01-20 14:35:32','2026-01-20 14:35:40','2026-01-20 14:35:40',1),(132,'656ef5b8-a536-420e-a7a3-850a33da38a8','image_type','snapshot','2026-01-20 14:35:32','2026-01-20 14:35:40','2026-01-20 14:35:40',1),(133,'656ef5b8-a536-420e-a7a3-850a33da38a8','image_state','available','2026-01-20 14:35:36','2026-01-20 14:35:40','2026-01-20 14:35:40',1),(134,'656ef5b8-a536-420e-a7a3-850a33da38a8','image_location','snapshot','2026-01-20 14:35:36','2026-01-20 14:35:40','2026-01-20 14:35:40',1),(135,'656ef5b8-a536-420e-a7a3-850a33da38a8','owner_id','3750c56415134773aa9d9880038f1749','2026-01-20 14:35:36','2026-01-20 14:35:40','2026-01-20 14:35:40',1),(136,'fba3fdca-b283-4008-bac5-0575a6416bc7','hw_rng_model','virtio','2026-01-20 14:35:59','2026-01-20 14:36:11','2026-01-20 14:36:11',1),(137,'fba3fdca-b283-4008-bac5-0575a6416bc7','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 14:35:59','2026-01-20 14:36:11','2026-01-20 14:36:11',1),(138,'fba3fdca-b283-4008-bac5-0575a6416bc7','owner_user_name','tempest-ImagesOneServerTestJSON-749029286-project-member','2026-01-20 14:35:59','2026-01-20 14:36:11','2026-01-20 14:36:11',1),(139,'fba3fdca-b283-4008-bac5-0575a6416bc7','owner_project_name','tempest-ImagesOneServerTestJSON-749029286','2026-01-20 14:35:59','2026-01-20 14:36:11','2026-01-20 14:36:11',1),(140,'fba3fdca-b283-4008-bac5-0575a6416bc7','boot_roles','reader,member','2026-01-20 14:35:59','2026-01-20 14:36:11','2026-01-20 14:36:11',1),(141,'fba3fdca-b283-4008-bac5-0575a6416bc7','hw_machine_type','q35','2026-01-20 14:35:59','2026-01-20 14:36:11','2026-01-20 14:36:11',1),(142,'fba3fdca-b283-4008-bac5-0575a6416bc7','hw_cdrom_bus','sata','2026-01-20 14:35:59','2026-01-20 14:36:11','2026-01-20 14:36:11',1),(143,'fba3fdca-b283-4008-bac5-0575a6416bc7','hw_disk_bus','virtio','2026-01-20 14:35:59','2026-01-20 14:36:11','2026-01-20 14:36:11',1),(144,'fba3fdca-b283-4008-bac5-0575a6416bc7','hw_input_bus','usb','2026-01-20 14:35:59','2026-01-20 14:36:11','2026-01-20 14:36:11',1),(145,'fba3fdca-b283-4008-bac5-0575a6416bc7','hw_pointer_model','usbtablet','2026-01-20 14:35:59','2026-01-20 14:36:11','2026-01-20 14:36:11',1),(146,'fba3fdca-b283-4008-bac5-0575a6416bc7','hw_video_model','virtio','2026-01-20 14:35:59','2026-01-20 14:36:11','2026-01-20 14:36:11',1),(147,'fba3fdca-b283-4008-bac5-0575a6416bc7','hw_vif_model','virtio','2026-01-20 14:35:59','2026-01-20 14:36:11','2026-01-20 14:36:11',1),(148,'fba3fdca-b283-4008-bac5-0575a6416bc7','instance_uuid','1b3763f0-b328-4db2-844b-7f56cc13c19e','2026-01-20 14:35:59','2026-01-20 14:36:11','2026-01-20 14:36:11',1),(149,'fba3fdca-b283-4008-bac5-0575a6416bc7','user_id','00cec8cbb72b489da46855f8b3b4c42c','2026-01-20 14:35:59','2026-01-20 14:36:11','2026-01-20 14:36:11',1),(150,'fba3fdca-b283-4008-bac5-0575a6416bc7','image_type','test','2026-01-20 14:35:59','2026-01-20 14:36:11','2026-01-20 14:36:11',1),(151,'71863f13-4d5e-4ff6-bbc9-d5be0e9690ff','hw_rng_model','virtio','2026-01-20 14:36:03','2026-01-20 14:36:12','2026-01-20 14:36:12',1),(152,'71863f13-4d5e-4ff6-bbc9-d5be0e9690ff','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 14:36:03','2026-01-20 14:36:12','2026-01-20 14:36:12',1),(153,'71863f13-4d5e-4ff6-bbc9-d5be0e9690ff','owner_user_name','tempest-ImagesTestJSON-338390217-project-member','2026-01-20 14:36:03','2026-01-20 14:36:12','2026-01-20 14:36:12',1),(154,'71863f13-4d5e-4ff6-bbc9-d5be0e9690ff','owner_project_name','tempest-ImagesTestJSON-338390217','2026-01-20 14:36:03','2026-01-20 14:36:12','2026-01-20 14:36:12',1),(155,'71863f13-4d5e-4ff6-bbc9-d5be0e9690ff','boot_roles','reader,member','2026-01-20 14:36:03','2026-01-20 14:36:12','2026-01-20 14:36:12',1),(156,'71863f13-4d5e-4ff6-bbc9-d5be0e9690ff','hw_machine_type','q35','2026-01-20 14:36:03','2026-01-20 14:36:12','2026-01-20 14:36:12',1),(157,'71863f13-4d5e-4ff6-bbc9-d5be0e9690ff','hw_cdrom_bus','sata','2026-01-20 14:36:03','2026-01-20 14:36:12','2026-01-20 14:36:12',1),(158,'71863f13-4d5e-4ff6-bbc9-d5be0e9690ff','hw_disk_bus','virtio','2026-01-20 14:36:03','2026-01-20 14:36:12','2026-01-20 14:36:12',1),(159,'71863f13-4d5e-4ff6-bbc9-d5be0e9690ff','hw_input_bus','usb','2026-01-20 14:36:03','2026-01-20 14:36:12','2026-01-20 14:36:12',1),(160,'71863f13-4d5e-4ff6-bbc9-d5be0e9690ff','hw_pointer_model','usbtablet','2026-01-20 14:36:03','2026-01-20 14:36:12','2026-01-20 14:36:12',1),(161,'71863f13-4d5e-4ff6-bbc9-d5be0e9690ff','hw_video_model','virtio','2026-01-20 14:36:03','2026-01-20 14:36:12','2026-01-20 14:36:12',1),(162,'71863f13-4d5e-4ff6-bbc9-d5be0e9690ff','hw_vif_model','virtio','2026-01-20 14:36:03','2026-01-20 14:36:12','2026-01-20 14:36:12',1),(163,'71863f13-4d5e-4ff6-bbc9-d5be0e9690ff','old_vm_state','active','2026-01-20 14:36:03','2026-01-20 14:36:12','2026-01-20 14:36:12',1),(164,'71863f13-4d5e-4ff6-bbc9-d5be0e9690ff','instance_uuid','a529906d-6908-4a37-ac57-db4384de2893','2026-01-20 14:36:03','2026-01-20 14:36:12','2026-01-20 14:36:12',1),(165,'71863f13-4d5e-4ff6-bbc9-d5be0e9690ff','user_id','56e2959629114d3d8a48e7a80ed96c4b','2026-01-20 14:36:03','2026-01-20 14:36:12','2026-01-20 14:36:12',1),(166,'71863f13-4d5e-4ff6-bbc9-d5be0e9690ff','image_type','snapshot','2026-01-20 14:36:03','2026-01-20 14:36:12','2026-01-20 14:36:12',1),(167,'fba3fdca-b283-4008-bac5-0575a6416bc7','image_state','available','2026-01-20 14:36:04','2026-01-20 14:36:11','2026-01-20 14:36:11',1),(168,'fba3fdca-b283-4008-bac5-0575a6416bc7','owner_id','79601368a3db41e0aacec93e8fd7f1d4','2026-01-20 14:36:04','2026-01-20 14:36:11','2026-01-20 14:36:11',1),(169,'fba3fdca-b283-4008-bac5-0575a6416bc7','image_location','snapshot','2026-01-20 14:36:04','2026-01-20 14:36:11','2026-01-20 14:36:11',1),(170,'71863f13-4d5e-4ff6-bbc9-d5be0e9690ff','image_state','available','2026-01-20 14:36:08','2026-01-20 14:36:12','2026-01-20 14:36:12',1),(171,'71863f13-4d5e-4ff6-bbc9-d5be0e9690ff','owner_id','3750c56415134773aa9d9880038f1749','2026-01-20 14:36:08','2026-01-20 14:36:12','2026-01-20 14:36:12',1),(172,'71863f13-4d5e-4ff6-bbc9-d5be0e9690ff','image_location','snapshot','2026-01-20 14:36:08','2026-01-20 14:36:12','2026-01-20 14:36:12',1),(173,'17b86a15-4cdb-41f2-82a9-c343b2420f69','hw_rng_model','virtio','2026-01-20 14:36:12','2026-01-20 14:36:23','2026-01-20 14:36:23',1),(174,'17b86a15-4cdb-41f2-82a9-c343b2420f69','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 14:36:12','2026-01-20 14:36:23','2026-01-20 14:36:23',1),(175,'17b86a15-4cdb-41f2-82a9-c343b2420f69','owner_user_name','tempest-ImagesOneServerTestJSON-749029286-project-member','2026-01-20 14:36:12','2026-01-20 14:36:23','2026-01-20 14:36:23',1),(176,'17b86a15-4cdb-41f2-82a9-c343b2420f69','owner_project_name','tempest-ImagesOneServerTestJSON-749029286','2026-01-20 14:36:12','2026-01-20 14:36:23','2026-01-20 14:36:23',1),(177,'17b86a15-4cdb-41f2-82a9-c343b2420f69','boot_roles','reader,member','2026-01-20 14:36:12','2026-01-20 14:36:23','2026-01-20 14:36:23',1),(178,'17b86a15-4cdb-41f2-82a9-c343b2420f69','hw_machine_type','q35','2026-01-20 14:36:12','2026-01-20 14:36:23','2026-01-20 14:36:23',1),(179,'17b86a15-4cdb-41f2-82a9-c343b2420f69','hw_cdrom_bus','sata','2026-01-20 14:36:12','2026-01-20 14:36:23','2026-01-20 14:36:23',1),(180,'17b86a15-4cdb-41f2-82a9-c343b2420f69','hw_disk_bus','virtio','2026-01-20 14:36:12','2026-01-20 14:36:23','2026-01-20 14:36:23',1),(181,'17b86a15-4cdb-41f2-82a9-c343b2420f69','hw_input_bus','usb','2026-01-20 14:36:12','2026-01-20 14:36:23','2026-01-20 14:36:23',1),(182,'17b86a15-4cdb-41f2-82a9-c343b2420f69','hw_pointer_model','usbtablet','2026-01-20 14:36:12','2026-01-20 14:36:23','2026-01-20 14:36:23',1),(183,'17b86a15-4cdb-41f2-82a9-c343b2420f69','hw_video_model','virtio','2026-01-20 14:36:12','2026-01-20 14:36:23','2026-01-20 14:36:23',1),(184,'17b86a15-4cdb-41f2-82a9-c343b2420f69','hw_vif_model','virtio','2026-01-20 14:36:12','2026-01-20 14:36:23','2026-01-20 14:36:23',1),(185,'17b86a15-4cdb-41f2-82a9-c343b2420f69','instance_uuid','1b3763f0-b328-4db2-844b-7f56cc13c19e','2026-01-20 14:36:12','2026-01-20 14:36:23','2026-01-20 14:36:23',1),(186,'17b86a15-4cdb-41f2-82a9-c343b2420f69','user_id','00cec8cbb72b489da46855f8b3b4c42c','2026-01-20 14:36:12','2026-01-20 14:36:23','2026-01-20 14:36:23',1),(187,'17b86a15-4cdb-41f2-82a9-c343b2420f69','image_type','snapshot','2026-01-20 14:36:12','2026-01-20 14:36:23','2026-01-20 14:36:23',1),(188,'17b86a15-4cdb-41f2-82a9-c343b2420f69','image_state','available','2026-01-20 14:36:18','2026-01-20 14:36:23','2026-01-20 14:36:23',1),(189,'17b86a15-4cdb-41f2-82a9-c343b2420f69','owner_id','79601368a3db41e0aacec93e8fd7f1d4','2026-01-20 14:36:18','2026-01-20 14:36:23','2026-01-20 14:36:23',1),(190,'17b86a15-4cdb-41f2-82a9-c343b2420f69','image_location','snapshot','2026-01-20 14:36:18','2026-01-20 14:36:23','2026-01-20 14:36:23',1),(191,'d9608a6b-abac-47e3-a9dd-70a6230a92c0','hw_rng_model','virtio','2026-01-20 14:36:30','2026-01-20 14:37:07','2026-01-20 14:37:07',1),(192,'d9608a6b-abac-47e3-a9dd-70a6230a92c0','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 14:36:30','2026-01-20 14:37:07','2026-01-20 14:37:07',1),(193,'d9608a6b-abac-47e3-a9dd-70a6230a92c0','owner_user_name','tempest-ImagesTestJSON-338390217-project-member','2026-01-20 14:36:30','2026-01-20 14:37:07','2026-01-20 14:37:07',1),(194,'d9608a6b-abac-47e3-a9dd-70a6230a92c0','owner_project_name','tempest-ImagesTestJSON-338390217','2026-01-20 14:36:30','2026-01-20 14:37:07','2026-01-20 14:37:07',1),(195,'d9608a6b-abac-47e3-a9dd-70a6230a92c0','boot_roles','member,reader','2026-01-20 14:36:30','2026-01-20 14:37:07','2026-01-20 14:37:07',1),(196,'d9608a6b-abac-47e3-a9dd-70a6230a92c0','hw_machine_type','q35','2026-01-20 14:36:30','2026-01-20 14:37:07','2026-01-20 14:37:07',1),(197,'d9608a6b-abac-47e3-a9dd-70a6230a92c0','hw_cdrom_bus','sata','2026-01-20 14:36:30','2026-01-20 14:37:07','2026-01-20 14:37:07',1),(198,'d9608a6b-abac-47e3-a9dd-70a6230a92c0','hw_disk_bus','virtio','2026-01-20 14:36:30','2026-01-20 14:37:07','2026-01-20 14:37:07',1),(199,'d9608a6b-abac-47e3-a9dd-70a6230a92c0','hw_input_bus','usb','2026-01-20 14:36:30','2026-01-20 14:37:07','2026-01-20 14:37:07',1),(200,'d9608a6b-abac-47e3-a9dd-70a6230a92c0','hw_pointer_model','usbtablet','2026-01-20 14:36:30','2026-01-20 14:37:07','2026-01-20 14:37:07',1),(201,'d9608a6b-abac-47e3-a9dd-70a6230a92c0','hw_video_model','virtio','2026-01-20 14:36:30','2026-01-20 14:37:07','2026-01-20 14:37:07',1),(202,'d9608a6b-abac-47e3-a9dd-70a6230a92c0','hw_vif_model','virtio','2026-01-20 14:36:30','2026-01-20 14:37:07','2026-01-20 14:37:07',1),(203,'d9608a6b-abac-47e3-a9dd-70a6230a92c0','instance_uuid','59387c9d-df91-4f43-b389-00174486fc84','2026-01-20 14:36:30','2026-01-20 14:37:07','2026-01-20 14:37:07',1),(204,'d9608a6b-abac-47e3-a9dd-70a6230a92c0','user_id','56e2959629114d3d8a48e7a80ed96c4b','2026-01-20 14:36:30','2026-01-20 14:37:07','2026-01-20 14:37:07',1),(205,'d9608a6b-abac-47e3-a9dd-70a6230a92c0','image_type','snapshot','2026-01-20 14:36:30','2026-01-20 14:37:07','2026-01-20 14:37:07',1),(206,'d9608a6b-abac-47e3-a9dd-70a6230a92c0','owner_id','3750c56415134773aa9d9880038f1749','2026-01-20 14:36:36','2026-01-20 14:37:07','2026-01-20 14:37:07',1),(207,'d9608a6b-abac-47e3-a9dd-70a6230a92c0','image_state','available','2026-01-20 14:36:36','2026-01-20 14:37:07','2026-01-20 14:37:07',1),(208,'d9608a6b-abac-47e3-a9dd-70a6230a92c0','image_location','snapshot','2026-01-20 14:36:36','2026-01-20 14:37:07','2026-01-20 14:37:07',1),(209,'d81709b0-d34f-4017-a47c-7ee2d9a8bd84','hw_rng_model','virtio','2026-01-20 14:37:08','2026-01-20 14:37:09','2026-01-20 14:37:09',1),(210,'d81709b0-d34f-4017-a47c-7ee2d9a8bd84','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 14:37:08','2026-01-20 14:37:09','2026-01-20 14:37:09',1),(211,'d81709b0-d34f-4017-a47c-7ee2d9a8bd84','owner_user_name','tempest-ImagesOneServerNegativeTestJSON-866315696-project-member','2026-01-20 14:37:08','2026-01-20 14:37:09','2026-01-20 14:37:09',1),(212,'d81709b0-d34f-4017-a47c-7ee2d9a8bd84','owner_project_name','tempest-ImagesOneServerNegativeTestJSON-866315696','2026-01-20 14:37:08','2026-01-20 14:37:09','2026-01-20 14:37:09',1),(213,'d81709b0-d34f-4017-a47c-7ee2d9a8bd84','boot_roles','reader,member','2026-01-20 14:37:08','2026-01-20 14:37:09','2026-01-20 14:37:09',1),(214,'d81709b0-d34f-4017-a47c-7ee2d9a8bd84','hw_machine_type','q35','2026-01-20 14:37:08','2026-01-20 14:37:09','2026-01-20 14:37:09',1),(215,'d81709b0-d34f-4017-a47c-7ee2d9a8bd84','hw_cdrom_bus','sata','2026-01-20 14:37:08','2026-01-20 14:37:09','2026-01-20 14:37:09',1),(216,'d81709b0-d34f-4017-a47c-7ee2d9a8bd84','hw_disk_bus','virtio','2026-01-20 14:37:08','2026-01-20 14:37:09','2026-01-20 14:37:09',1),(217,'d81709b0-d34f-4017-a47c-7ee2d9a8bd84','hw_input_bus','usb','2026-01-20 14:37:08','2026-01-20 14:37:09','2026-01-20 14:37:09',1),(218,'d81709b0-d34f-4017-a47c-7ee2d9a8bd84','hw_pointer_model','usbtablet','2026-01-20 14:37:08','2026-01-20 14:37:09','2026-01-20 14:37:09',1),(219,'d81709b0-d34f-4017-a47c-7ee2d9a8bd84','hw_video_model','virtio','2026-01-20 14:37:08','2026-01-20 14:37:09','2026-01-20 14:37:09',1),(220,'d81709b0-d34f-4017-a47c-7ee2d9a8bd84','hw_vif_model','virtio','2026-01-20 14:37:08','2026-01-20 14:37:09','2026-01-20 14:37:09',1),(221,'d81709b0-d34f-4017-a47c-7ee2d9a8bd84','instance_uuid','f59628d0-8f85-42c2-93ff-a052df4ac20e','2026-01-20 14:37:08','2026-01-20 14:37:09','2026-01-20 14:37:09',1),(222,'d81709b0-d34f-4017-a47c-7ee2d9a8bd84','user_id','592a0204f38a4596ab1ab81774214a6d','2026-01-20 14:37:08','2026-01-20 14:37:09','2026-01-20 14:37:09',1),(223,'d81709b0-d34f-4017-a47c-7ee2d9a8bd84','image_type','snapshot','2026-01-20 14:37:08','2026-01-20 14:37:09','2026-01-20 14:37:09',1),(224,'a619a5a5-7b38-4a60-af81-76a595f37563','hw_rng_model','virtio','2026-01-20 14:37:24','2026-01-20 14:37:26','2026-01-20 14:37:26',1),(225,'a619a5a5-7b38-4a60-af81-76a595f37563','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 14:37:24','2026-01-20 14:37:26','2026-01-20 14:37:26',1),(226,'a619a5a5-7b38-4a60-af81-76a595f37563','owner_user_name','tempest-ImagesTestJSON-338390217-project-member','2026-01-20 14:37:24','2026-01-20 14:37:26','2026-01-20 14:37:26',1),(227,'a619a5a5-7b38-4a60-af81-76a595f37563','owner_project_name','tempest-ImagesTestJSON-338390217','2026-01-20 14:37:24','2026-01-20 14:37:26','2026-01-20 14:37:26',1),(228,'a619a5a5-7b38-4a60-af81-76a595f37563','boot_roles','reader,member','2026-01-20 14:37:24','2026-01-20 14:37:26','2026-01-20 14:37:26',1),(229,'a619a5a5-7b38-4a60-af81-76a595f37563','hw_machine_type','q35','2026-01-20 14:37:24','2026-01-20 14:37:26','2026-01-20 14:37:26',1),(230,'a619a5a5-7b38-4a60-af81-76a595f37563','hw_cdrom_bus','sata','2026-01-20 14:37:24','2026-01-20 14:37:26','2026-01-20 14:37:26',1),(231,'a619a5a5-7b38-4a60-af81-76a595f37563','hw_disk_bus','virtio','2026-01-20 14:37:24','2026-01-20 14:37:26','2026-01-20 14:37:26',1),(232,'a619a5a5-7b38-4a60-af81-76a595f37563','hw_input_bus','usb','2026-01-20 14:37:24','2026-01-20 14:37:26','2026-01-20 14:37:26',1),(233,'a619a5a5-7b38-4a60-af81-76a595f37563','hw_pointer_model','usbtablet','2026-01-20 14:37:24','2026-01-20 14:37:26','2026-01-20 14:37:26',1),(234,'a619a5a5-7b38-4a60-af81-76a595f37563','hw_video_model','virtio','2026-01-20 14:37:24','2026-01-20 14:37:26','2026-01-20 14:37:26',1),(235,'a619a5a5-7b38-4a60-af81-76a595f37563','hw_vif_model','virtio','2026-01-20 14:37:24','2026-01-20 14:37:26','2026-01-20 14:37:26',1),(236,'a619a5a5-7b38-4a60-af81-76a595f37563','instance_uuid','a6c080ba-dcec-4724-ac6c-12c69f617401','2026-01-20 14:37:24','2026-01-20 14:37:26','2026-01-20 14:37:26',1),(237,'a619a5a5-7b38-4a60-af81-76a595f37563','user_id','56e2959629114d3d8a48e7a80ed96c4b','2026-01-20 14:37:24','2026-01-20 14:37:26','2026-01-20 14:37:26',1),(238,'a619a5a5-7b38-4a60-af81-76a595f37563','image_type','snapshot','2026-01-20 14:37:24','2026-01-20 14:37:26','2026-01-20 14:37:26',1),(239,'d6eb065b-6bd9-4a87-ab49-a63678d86cff','hw_rng_model','virtio','2026-01-20 14:37:40','2026-01-20 14:37:41','2026-01-20 14:37:41',1),(240,'d6eb065b-6bd9-4a87-ab49-a63678d86cff','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 14:37:40','2026-01-20 14:37:41','2026-01-20 14:37:41',1),(241,'d6eb065b-6bd9-4a87-ab49-a63678d86cff','owner_user_name','tempest-ImagesOneServerNegativeTestJSON-866315696-project-member','2026-01-20 14:37:40','2026-01-20 14:37:41','2026-01-20 14:37:41',1),(242,'d6eb065b-6bd9-4a87-ab49-a63678d86cff','owner_project_name','tempest-ImagesOneServerNegativeTestJSON-866315696','2026-01-20 14:37:40','2026-01-20 14:37:41','2026-01-20 14:37:41',1),(243,'d6eb065b-6bd9-4a87-ab49-a63678d86cff','boot_roles','reader,member','2026-01-20 14:37:40','2026-01-20 14:37:41','2026-01-20 14:37:41',1),(244,'d6eb065b-6bd9-4a87-ab49-a63678d86cff','hw_machine_type','q35','2026-01-20 14:37:40','2026-01-20 14:37:41','2026-01-20 14:37:41',1),(245,'d6eb065b-6bd9-4a87-ab49-a63678d86cff','hw_cdrom_bus','sata','2026-01-20 14:37:40','2026-01-20 14:37:41','2026-01-20 14:37:41',1),(246,'d6eb065b-6bd9-4a87-ab49-a63678d86cff','hw_disk_bus','virtio','2026-01-20 14:37:40','2026-01-20 14:37:41','2026-01-20 14:37:41',1),(247,'d6eb065b-6bd9-4a87-ab49-a63678d86cff','hw_input_bus','usb','2026-01-20 14:37:40','2026-01-20 14:37:41','2026-01-20 14:37:41',1),(248,'d6eb065b-6bd9-4a87-ab49-a63678d86cff','hw_pointer_model','usbtablet','2026-01-20 14:37:40','2026-01-20 14:37:41','2026-01-20 14:37:41',1),(249,'d6eb065b-6bd9-4a87-ab49-a63678d86cff','hw_video_model','virtio','2026-01-20 14:37:40','2026-01-20 14:37:41','2026-01-20 14:37:41',1),(250,'d6eb065b-6bd9-4a87-ab49-a63678d86cff','hw_vif_model','virtio','2026-01-20 14:37:40','2026-01-20 14:37:41','2026-01-20 14:37:41',1),(251,'d6eb065b-6bd9-4a87-ab49-a63678d86cff','instance_uuid','98e22622-b8b8-44a5-befe-1bd745f9c946','2026-01-20 14:37:40','2026-01-20 14:37:41','2026-01-20 14:37:41',1),(252,'d6eb065b-6bd9-4a87-ab49-a63678d86cff','user_id','592a0204f38a4596ab1ab81774214a6d','2026-01-20 14:37:40','2026-01-20 14:37:41','2026-01-20 14:37:41',1),(253,'d6eb065b-6bd9-4a87-ab49-a63678d86cff','image_type','snapshot','2026-01-20 14:37:40','2026-01-20 14:37:41','2026-01-20 14:37:41',1),(254,'20f02a0e-ef11-4157-9d07-37674d1e0ea8','hw_rng_model','virtio','2026-01-20 14:45:22','2026-01-20 14:45:57','2026-01-20 14:45:57',1),(255,'20f02a0e-ef11-4157-9d07-37674d1e0ea8','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 14:45:22','2026-01-20 14:45:57','2026-01-20 14:45:57',1),(256,'20f02a0e-ef11-4157-9d07-37674d1e0ea8','owner_user_name','tempest-DeleteServersTestJSON-1162922273-project-member','2026-01-20 14:45:22','2026-01-20 14:45:57','2026-01-20 14:45:57',1),(257,'20f02a0e-ef11-4157-9d07-37674d1e0ea8','owner_project_name','tempest-DeleteServersTestJSON-1162922273','2026-01-20 14:45:22','2026-01-20 14:45:57','2026-01-20 14:45:57',1),(258,'20f02a0e-ef11-4157-9d07-37674d1e0ea8','boot_roles','reader,member','2026-01-20 14:45:22','2026-01-20 14:45:57','2026-01-20 14:45:57',1),(259,'20f02a0e-ef11-4157-9d07-37674d1e0ea8','hw_machine_type','q35','2026-01-20 14:45:22','2026-01-20 14:45:57','2026-01-20 14:45:57',1),(260,'20f02a0e-ef11-4157-9d07-37674d1e0ea8','hw_cdrom_bus','sata','2026-01-20 14:45:22','2026-01-20 14:45:57','2026-01-20 14:45:57',1),(261,'20f02a0e-ef11-4157-9d07-37674d1e0ea8','hw_disk_bus','virtio','2026-01-20 14:45:22','2026-01-20 14:45:57','2026-01-20 14:45:57',1),(262,'20f02a0e-ef11-4157-9d07-37674d1e0ea8','hw_input_bus','usb','2026-01-20 14:45:22','2026-01-20 14:45:57','2026-01-20 14:45:57',1),(263,'20f02a0e-ef11-4157-9d07-37674d1e0ea8','hw_pointer_model','usbtablet','2026-01-20 14:45:22','2026-01-20 14:45:57','2026-01-20 14:45:57',1),(264,'20f02a0e-ef11-4157-9d07-37674d1e0ea8','hw_video_model','virtio','2026-01-20 14:45:22','2026-01-20 14:45:57','2026-01-20 14:45:57',1),(265,'20f02a0e-ef11-4157-9d07-37674d1e0ea8','hw_vif_model','virtio','2026-01-20 14:45:22','2026-01-20 14:45:57','2026-01-20 14:45:57',1),(266,'20f02a0e-ef11-4157-9d07-37674d1e0ea8','instance_uuid','163342b0-95c5-4e11-8a6d-f7a9cd588782','2026-01-20 14:45:22','2026-01-20 14:45:57','2026-01-20 14:45:57',1),(267,'20f02a0e-ef11-4157-9d07-37674d1e0ea8','user_id','37e9ef97fbe0448e9fbe32d48b66211f','2026-01-20 14:45:22','2026-01-20 14:45:57','2026-01-20 14:45:57',1),(268,'20f02a0e-ef11-4157-9d07-37674d1e0ea8','image_type','snapshot','2026-01-20 14:45:22','2026-01-20 14:45:57','2026-01-20 14:45:57',1),(269,'20f02a0e-ef11-4157-9d07-37674d1e0ea8','image_state','available','2026-01-20 14:45:41','2026-01-20 14:45:57','2026-01-20 14:45:57',1),(270,'20f02a0e-ef11-4157-9d07-37674d1e0ea8','owner_id','3b31139b2a4e49cba5e7048febf901c4','2026-01-20 14:45:41','2026-01-20 14:45:57','2026-01-20 14:45:57',1),(271,'20f02a0e-ef11-4157-9d07-37674d1e0ea8','image_location','snapshot','2026-01-20 14:45:41','2026-01-20 14:45:57','2026-01-20 14:45:57',1),(272,'7586ccfe-36ea-40bd-b70d-ce54b80b5faa','hw_rng_model','virtio','2026-01-20 14:50:33','2026-01-20 14:54:53','2026-01-20 14:54:53',1),(273,'7586ccfe-36ea-40bd-b70d-ce54b80b5faa','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 14:50:33','2026-01-20 14:54:53','2026-01-20 14:54:53',1),(274,'7586ccfe-36ea-40bd-b70d-ce54b80b5faa','owner_user_name','tempest-ServerStableDeviceRescueTest-129078052-project-member','2026-01-20 14:50:33','2026-01-20 14:54:53','2026-01-20 14:54:53',1),(275,'7586ccfe-36ea-40bd-b70d-ce54b80b5faa','owner_project_name','tempest-ServerStableDeviceRescueTest-129078052','2026-01-20 14:50:33','2026-01-20 14:54:53','2026-01-20 14:54:53',1),(276,'7586ccfe-36ea-40bd-b70d-ce54b80b5faa','boot_roles','reader,member','2026-01-20 14:50:33','2026-01-20 14:54:53','2026-01-20 14:54:53',1),(277,'7586ccfe-36ea-40bd-b70d-ce54b80b5faa','hw_machine_type','q35','2026-01-20 14:50:33','2026-01-20 14:54:53','2026-01-20 14:54:53',1),(278,'7586ccfe-36ea-40bd-b70d-ce54b80b5faa','hw_cdrom_bus','sata','2026-01-20 14:50:33','2026-01-20 14:54:53','2026-01-20 14:54:53',1),(279,'7586ccfe-36ea-40bd-b70d-ce54b80b5faa','hw_disk_bus','virtio','2026-01-20 14:50:33','2026-01-20 14:54:53','2026-01-20 14:54:53',1),(280,'7586ccfe-36ea-40bd-b70d-ce54b80b5faa','hw_input_bus','usb','2026-01-20 14:50:33','2026-01-20 14:54:53','2026-01-20 14:54:53',1),(281,'7586ccfe-36ea-40bd-b70d-ce54b80b5faa','hw_pointer_model','usbtablet','2026-01-20 14:50:33','2026-01-20 14:54:53','2026-01-20 14:54:53',1),(282,'7586ccfe-36ea-40bd-b70d-ce54b80b5faa','hw_video_model','virtio','2026-01-20 14:50:33','2026-01-20 14:54:53','2026-01-20 14:54:53',1),(283,'7586ccfe-36ea-40bd-b70d-ce54b80b5faa','hw_vif_model','virtio','2026-01-20 14:50:33','2026-01-20 14:54:53','2026-01-20 14:54:53',1),(284,'7586ccfe-36ea-40bd-b70d-ce54b80b5faa','instance_uuid','c3b4d4c6-c42f-4abc-9c01-89ec3e10c677','2026-01-20 14:50:33','2026-01-20 14:54:53','2026-01-20 14:54:53',1),(285,'7586ccfe-36ea-40bd-b70d-ce54b80b5faa','user_id','d85d286ce6224326a0f4a15a06afbfea','2026-01-20 14:50:33','2026-01-20 14:54:53','2026-01-20 14:54:53',1),(286,'7586ccfe-36ea-40bd-b70d-ce54b80b5faa','image_type','snapshot','2026-01-20 14:50:33','2026-01-20 14:54:53','2026-01-20 14:54:53',1),(287,'7586ccfe-36ea-40bd-b70d-ce54b80b5faa','image_state','available','2026-01-20 14:50:37','2026-01-20 14:54:53','2026-01-20 14:54:53',1),(288,'7586ccfe-36ea-40bd-b70d-ce54b80b5faa','owner_id','0a29915e0dd2403fbd7b7e847696b00a','2026-01-20 14:50:37','2026-01-20 14:54:53','2026-01-20 14:54:53',1),(289,'7586ccfe-36ea-40bd-b70d-ce54b80b5faa','image_location','snapshot','2026-01-20 14:50:37','2026-01-20 14:54:53','2026-01-20 14:54:53',1),(290,'7586ccfe-36ea-40bd-b70d-ce54b80b5faa','hw_rescue_bus','scsi','2026-01-20 14:50:41','2026-01-20 14:54:53','2026-01-20 14:54:53',1),(291,'7586ccfe-36ea-40bd-b70d-ce54b80b5faa','hw_rescue_device','disk','2026-01-20 14:50:41','2026-01-20 14:54:53','2026-01-20 14:54:53',1),(292,'ae5aa156-02f2-4cbe-8c3c-a41c7fd78b5c','hw_rng_model','virtio','2026-01-20 14:51:25','2026-01-20 14:54:48','2026-01-20 14:54:48',1),(293,'ae5aa156-02f2-4cbe-8c3c-a41c7fd78b5c','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 14:51:25','2026-01-20 14:54:48','2026-01-20 14:54:48',1),(294,'ae5aa156-02f2-4cbe-8c3c-a41c7fd78b5c','owner_user_name','tempest-ServerStableDeviceRescueTest-129078052-project-member','2026-01-20 14:51:25','2026-01-20 14:54:48','2026-01-20 14:54:48',1),(295,'ae5aa156-02f2-4cbe-8c3c-a41c7fd78b5c','owner_project_name','tempest-ServerStableDeviceRescueTest-129078052','2026-01-20 14:51:25','2026-01-20 14:54:48','2026-01-20 14:54:48',1),(296,'ae5aa156-02f2-4cbe-8c3c-a41c7fd78b5c','boot_roles','reader,member','2026-01-20 14:51:25','2026-01-20 14:54:48','2026-01-20 14:54:48',1),(297,'ae5aa156-02f2-4cbe-8c3c-a41c7fd78b5c','hw_machine_type','q35','2026-01-20 14:51:25','2026-01-20 14:54:48','2026-01-20 14:54:48',1),(298,'ae5aa156-02f2-4cbe-8c3c-a41c7fd78b5c','hw_cdrom_bus','sata','2026-01-20 14:51:25','2026-01-20 14:54:48','2026-01-20 14:54:48',1),(299,'ae5aa156-02f2-4cbe-8c3c-a41c7fd78b5c','hw_disk_bus','virtio','2026-01-20 14:51:25','2026-01-20 14:54:48','2026-01-20 14:54:48',1),(300,'ae5aa156-02f2-4cbe-8c3c-a41c7fd78b5c','hw_input_bus','usb','2026-01-20 14:51:25','2026-01-20 14:54:48','2026-01-20 14:54:48',1),(301,'ae5aa156-02f2-4cbe-8c3c-a41c7fd78b5c','hw_pointer_model','usbtablet','2026-01-20 14:51:25','2026-01-20 14:54:48','2026-01-20 14:54:48',1),(302,'ae5aa156-02f2-4cbe-8c3c-a41c7fd78b5c','hw_video_model','virtio','2026-01-20 14:51:25','2026-01-20 14:54:48','2026-01-20 14:54:48',1),(303,'ae5aa156-02f2-4cbe-8c3c-a41c7fd78b5c','hw_vif_model','virtio','2026-01-20 14:51:25','2026-01-20 14:54:48','2026-01-20 14:54:48',1),(304,'ae5aa156-02f2-4cbe-8c3c-a41c7fd78b5c','instance_uuid','7dbd47ad-b9b3-4861-8a8b-f9051fe7a27b','2026-01-20 14:51:25','2026-01-20 14:54:48','2026-01-20 14:54:48',1),(305,'ae5aa156-02f2-4cbe-8c3c-a41c7fd78b5c','user_id','d85d286ce6224326a0f4a15a06afbfea','2026-01-20 14:51:25','2026-01-20 14:54:48','2026-01-20 14:54:48',1),(306,'ae5aa156-02f2-4cbe-8c3c-a41c7fd78b5c','image_type','snapshot','2026-01-20 14:51:25','2026-01-20 14:54:48','2026-01-20 14:54:48',1),(307,'ae5aa156-02f2-4cbe-8c3c-a41c7fd78b5c','image_state','available','2026-01-20 14:51:29','2026-01-20 14:54:48','2026-01-20 14:54:48',1),(308,'ae5aa156-02f2-4cbe-8c3c-a41c7fd78b5c','image_location','snapshot','2026-01-20 14:51:29','2026-01-20 14:54:48','2026-01-20 14:54:48',1),(309,'ae5aa156-02f2-4cbe-8c3c-a41c7fd78b5c','owner_id','0a29915e0dd2403fbd7b7e847696b00a','2026-01-20 14:51:29','2026-01-20 14:54:48','2026-01-20 14:54:48',1),(310,'ae5aa156-02f2-4cbe-8c3c-a41c7fd78b5c','hw_rescue_bus','usb','2026-01-20 14:51:33','2026-01-20 14:54:48','2026-01-20 14:54:48',1),(311,'ae5aa156-02f2-4cbe-8c3c-a41c7fd78b5c','hw_rescue_device','disk','2026-01-20 14:51:33','2026-01-20 14:54:48','2026-01-20 14:54:48',1),(312,'a1d1cbcb-c6a5-49c9-8868-06c3872a40d2','hw_rng_model','virtio','2026-01-20 14:52:05','2026-01-20 14:54:41','2026-01-20 14:54:41',1),(313,'a1d1cbcb-c6a5-49c9-8868-06c3872a40d2','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 14:52:05','2026-01-20 14:54:41','2026-01-20 14:54:41',1),(314,'a1d1cbcb-c6a5-49c9-8868-06c3872a40d2','owner_user_name','tempest-ServerStableDeviceRescueTest-129078052-project-member','2026-01-20 14:52:05','2026-01-20 14:54:41','2026-01-20 14:54:41',1),(315,'a1d1cbcb-c6a5-49c9-8868-06c3872a40d2','owner_project_name','tempest-ServerStableDeviceRescueTest-129078052','2026-01-20 14:52:05','2026-01-20 14:54:41','2026-01-20 14:54:41',1),(316,'a1d1cbcb-c6a5-49c9-8868-06c3872a40d2','boot_roles','reader,member','2026-01-20 14:52:05','2026-01-20 14:54:41','2026-01-20 14:54:41',1),(317,'a1d1cbcb-c6a5-49c9-8868-06c3872a40d2','hw_machine_type','q35','2026-01-20 14:52:05','2026-01-20 14:54:41','2026-01-20 14:54:41',1),(318,'a1d1cbcb-c6a5-49c9-8868-06c3872a40d2','hw_cdrom_bus','sata','2026-01-20 14:52:05','2026-01-20 14:54:41','2026-01-20 14:54:41',1),(319,'a1d1cbcb-c6a5-49c9-8868-06c3872a40d2','hw_disk_bus','virtio','2026-01-20 14:52:05','2026-01-20 14:54:41','2026-01-20 14:54:41',1),(320,'a1d1cbcb-c6a5-49c9-8868-06c3872a40d2','hw_input_bus','usb','2026-01-20 14:52:05','2026-01-20 14:54:41','2026-01-20 14:54:41',1),(321,'a1d1cbcb-c6a5-49c9-8868-06c3872a40d2','hw_pointer_model','usbtablet','2026-01-20 14:52:05','2026-01-20 14:54:41','2026-01-20 14:54:41',1),(322,'a1d1cbcb-c6a5-49c9-8868-06c3872a40d2','hw_video_model','virtio','2026-01-20 14:52:05','2026-01-20 14:54:41','2026-01-20 14:54:41',1),(323,'a1d1cbcb-c6a5-49c9-8868-06c3872a40d2','hw_vif_model','virtio','2026-01-20 14:52:05','2026-01-20 14:54:41','2026-01-20 14:54:41',1),(324,'a1d1cbcb-c6a5-49c9-8868-06c3872a40d2','instance_uuid','23ea4537-f03f-46de-881f-b979e232a3b9','2026-01-20 14:52:05','2026-01-20 14:54:41','2026-01-20 14:54:41',1),(325,'a1d1cbcb-c6a5-49c9-8868-06c3872a40d2','user_id','d85d286ce6224326a0f4a15a06afbfea','2026-01-20 14:52:05','2026-01-20 14:54:41','2026-01-20 14:54:41',1),(326,'a1d1cbcb-c6a5-49c9-8868-06c3872a40d2','image_type','snapshot','2026-01-20 14:52:05','2026-01-20 14:54:41','2026-01-20 14:54:41',1),(327,'a1d1cbcb-c6a5-49c9-8868-06c3872a40d2','owner_id','0a29915e0dd2403fbd7b7e847696b00a','2026-01-20 14:52:10','2026-01-20 14:54:41','2026-01-20 14:54:41',1),(328,'a1d1cbcb-c6a5-49c9-8868-06c3872a40d2','image_state','available','2026-01-20 14:52:10','2026-01-20 14:54:41','2026-01-20 14:54:41',1),(329,'a1d1cbcb-c6a5-49c9-8868-06c3872a40d2','image_location','snapshot','2026-01-20 14:52:10','2026-01-20 14:54:41','2026-01-20 14:54:41',1),(330,'a1d1cbcb-c6a5-49c9-8868-06c3872a40d2','hw_rescue_bus','virtio','2026-01-20 14:52:15','2026-01-20 14:54:41','2026-01-20 14:54:41',1),(331,'a1d1cbcb-c6a5-49c9-8868-06c3872a40d2','hw_rescue_device','disk','2026-01-20 14:52:15','2026-01-20 14:54:41','2026-01-20 14:54:41',1),(332,'165549fb-68ff-4d9c-ab65-c85189d23d7d','hw_rng_model','virtio','2026-01-20 14:52:34','2026-01-20 14:53:07','2026-01-20 14:53:07',1),(333,'165549fb-68ff-4d9c-ab65-c85189d23d7d','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 14:52:34','2026-01-20 14:53:07','2026-01-20 14:53:07',1),(334,'165549fb-68ff-4d9c-ab65-c85189d23d7d','owner_user_name','tempest-ServerActionsTestOtherB-1136521362-project-member','2026-01-20 14:52:34','2026-01-20 14:53:07','2026-01-20 14:53:07',1),(335,'165549fb-68ff-4d9c-ab65-c85189d23d7d','owner_project_name','tempest-ServerActionsTestOtherB-1136521362','2026-01-20 14:52:34','2026-01-20 14:53:07','2026-01-20 14:53:07',1),(336,'165549fb-68ff-4d9c-ab65-c85189d23d7d','boot_roles','reader,member','2026-01-20 14:52:34','2026-01-20 14:53:07','2026-01-20 14:53:07',1),(337,'165549fb-68ff-4d9c-ab65-c85189d23d7d','hw_machine_type','q35','2026-01-20 14:52:34','2026-01-20 14:53:07','2026-01-20 14:53:07',1),(338,'165549fb-68ff-4d9c-ab65-c85189d23d7d','hw_cdrom_bus','sata','2026-01-20 14:52:34','2026-01-20 14:53:07','2026-01-20 14:53:07',1),(339,'165549fb-68ff-4d9c-ab65-c85189d23d7d','hw_disk_bus','virtio','2026-01-20 14:52:34','2026-01-20 14:53:07','2026-01-20 14:53:07',1),(340,'165549fb-68ff-4d9c-ab65-c85189d23d7d','hw_input_bus','usb','2026-01-20 14:52:34','2026-01-20 14:53:07','2026-01-20 14:53:07',1),(341,'165549fb-68ff-4d9c-ab65-c85189d23d7d','hw_pointer_model','usbtablet','2026-01-20 14:52:34','2026-01-20 14:53:07','2026-01-20 14:53:07',1),(342,'165549fb-68ff-4d9c-ab65-c85189d23d7d','hw_video_model','virtio','2026-01-20 14:52:34','2026-01-20 14:53:07','2026-01-20 14:53:07',1),(343,'165549fb-68ff-4d9c-ab65-c85189d23d7d','hw_vif_model','virtio','2026-01-20 14:52:34','2026-01-20 14:53:07','2026-01-20 14:53:07',1),(344,'165549fb-68ff-4d9c-ab65-c85189d23d7d','instance_uuid','7f5cfffe-c1dc-4b00-844e-0fb35b340f44','2026-01-20 14:52:34','2026-01-20 14:53:07','2026-01-20 14:53:07',1),(345,'165549fb-68ff-4d9c-ab65-c85189d23d7d','user_id','215db37373dc4ae5a75cbd6866f471da','2026-01-20 14:52:34','2026-01-20 14:53:07','2026-01-20 14:53:07',1),(346,'165549fb-68ff-4d9c-ab65-c85189d23d7d','image_type','backup','2026-01-20 14:52:34','2026-01-20 14:53:07','2026-01-20 14:53:07',1),(347,'165549fb-68ff-4d9c-ab65-c85189d23d7d','backup_type','daily','2026-01-20 14:52:34','2026-01-20 14:53:07','2026-01-20 14:53:07',1),(348,'165549fb-68ff-4d9c-ab65-c85189d23d7d','image_state','available','2026-01-20 14:52:41','2026-01-20 14:53:07','2026-01-20 14:53:07',1),(349,'165549fb-68ff-4d9c-ab65-c85189d23d7d','owner_id','b3b1b7f5b4f84b5abbc401eb577c85c0','2026-01-20 14:52:41','2026-01-20 14:53:07','2026-01-20 14:53:07',1),(350,'165549fb-68ff-4d9c-ab65-c85189d23d7d','image_location','snapshot','2026-01-20 14:52:41','2026-01-20 14:53:07','2026-01-20 14:53:07',1),(351,'d9e08301-4600-4321-b633-e7777cc1e842','hw_rng_model','virtio','2026-01-20 14:52:47','2026-01-20 14:53:13','2026-01-20 14:53:13',1),(352,'d9e08301-4600-4321-b633-e7777cc1e842','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 14:52:47','2026-01-20 14:53:13','2026-01-20 14:53:13',1),(353,'d9e08301-4600-4321-b633-e7777cc1e842','owner_user_name','tempest-ServerActionsTestOtherB-1136521362-project-member','2026-01-20 14:52:47','2026-01-20 14:53:13','2026-01-20 14:53:13',1),(354,'d9e08301-4600-4321-b633-e7777cc1e842','owner_project_name','tempest-ServerActionsTestOtherB-1136521362','2026-01-20 14:52:47','2026-01-20 14:53:13','2026-01-20 14:53:13',1),(355,'d9e08301-4600-4321-b633-e7777cc1e842','boot_roles','reader,member','2026-01-20 14:52:47','2026-01-20 14:53:13','2026-01-20 14:53:13',1),(356,'d9e08301-4600-4321-b633-e7777cc1e842','hw_machine_type','q35','2026-01-20 14:52:47','2026-01-20 14:53:13','2026-01-20 14:53:13',1),(357,'d9e08301-4600-4321-b633-e7777cc1e842','hw_cdrom_bus','sata','2026-01-20 14:52:47','2026-01-20 14:53:13','2026-01-20 14:53:13',1),(358,'d9e08301-4600-4321-b633-e7777cc1e842','hw_disk_bus','virtio','2026-01-20 14:52:47','2026-01-20 14:53:13','2026-01-20 14:53:13',1),(359,'d9e08301-4600-4321-b633-e7777cc1e842','hw_input_bus','usb','2026-01-20 14:52:47','2026-01-20 14:53:13','2026-01-20 14:53:13',1),(360,'d9e08301-4600-4321-b633-e7777cc1e842','hw_pointer_model','usbtablet','2026-01-20 14:52:47','2026-01-20 14:53:13','2026-01-20 14:53:13',1),(361,'d9e08301-4600-4321-b633-e7777cc1e842','hw_video_model','virtio','2026-01-20 14:52:47','2026-01-20 14:53:13','2026-01-20 14:53:13',1),(362,'d9e08301-4600-4321-b633-e7777cc1e842','hw_vif_model','virtio','2026-01-20 14:52:47','2026-01-20 14:53:13','2026-01-20 14:53:13',1),(363,'d9e08301-4600-4321-b633-e7777cc1e842','instance_uuid','7f5cfffe-c1dc-4b00-844e-0fb35b340f44','2026-01-20 14:52:47','2026-01-20 14:53:13','2026-01-20 14:53:13',1),(364,'d9e08301-4600-4321-b633-e7777cc1e842','user_id','215db37373dc4ae5a75cbd6866f471da','2026-01-20 14:52:47','2026-01-20 14:53:13','2026-01-20 14:53:13',1),(365,'d9e08301-4600-4321-b633-e7777cc1e842','image_type','backup','2026-01-20 14:52:47','2026-01-20 14:53:13','2026-01-20 14:53:13',1),(366,'d9e08301-4600-4321-b633-e7777cc1e842','backup_type','daily','2026-01-20 14:52:47','2026-01-20 14:53:13','2026-01-20 14:53:13',1),(367,'d9e08301-4600-4321-b633-e7777cc1e842','image_state','available','2026-01-20 14:52:52','2026-01-20 14:53:13','2026-01-20 14:53:13',1),(368,'d9e08301-4600-4321-b633-e7777cc1e842','owner_id','b3b1b7f5b4f84b5abbc401eb577c85c0','2026-01-20 14:52:52','2026-01-20 14:53:13','2026-01-20 14:53:13',1),(369,'d9e08301-4600-4321-b633-e7777cc1e842','image_location','snapshot','2026-01-20 14:52:52','2026-01-20 14:53:13','2026-01-20 14:53:13',1),(370,'bf636010-1d3c-4028-9e00-bc1bb08e7dca','hw_rng_model','virtio','2026-01-20 14:52:59','2026-01-20 14:53:11','2026-01-20 14:53:11',1),(371,'bf636010-1d3c-4028-9e00-bc1bb08e7dca','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 14:52:59','2026-01-20 14:53:11','2026-01-20 14:53:11',1),(372,'bf636010-1d3c-4028-9e00-bc1bb08e7dca','owner_user_name','tempest-ServerActionsTestOtherB-1136521362-project-member','2026-01-20 14:52:59','2026-01-20 14:53:11','2026-01-20 14:53:11',1),(373,'bf636010-1d3c-4028-9e00-bc1bb08e7dca','owner_project_name','tempest-ServerActionsTestOtherB-1136521362','2026-01-20 14:52:59','2026-01-20 14:53:11','2026-01-20 14:53:11',1),(374,'bf636010-1d3c-4028-9e00-bc1bb08e7dca','boot_roles','reader,member','2026-01-20 14:52:59','2026-01-20 14:53:11','2026-01-20 14:53:11',1),(375,'bf636010-1d3c-4028-9e00-bc1bb08e7dca','hw_machine_type','q35','2026-01-20 14:52:59','2026-01-20 14:53:11','2026-01-20 14:53:11',1),(376,'bf636010-1d3c-4028-9e00-bc1bb08e7dca','hw_cdrom_bus','sata','2026-01-20 14:52:59','2026-01-20 14:53:11','2026-01-20 14:53:11',1),(377,'bf636010-1d3c-4028-9e00-bc1bb08e7dca','hw_disk_bus','virtio','2026-01-20 14:52:59','2026-01-20 14:53:11','2026-01-20 14:53:11',1),(378,'bf636010-1d3c-4028-9e00-bc1bb08e7dca','hw_input_bus','usb','2026-01-20 14:52:59','2026-01-20 14:53:11','2026-01-20 14:53:11',1),(379,'bf636010-1d3c-4028-9e00-bc1bb08e7dca','hw_pointer_model','usbtablet','2026-01-20 14:52:59','2026-01-20 14:53:11','2026-01-20 14:53:11',1),(380,'bf636010-1d3c-4028-9e00-bc1bb08e7dca','hw_video_model','virtio','2026-01-20 14:52:59','2026-01-20 14:53:11','2026-01-20 14:53:11',1),(381,'bf636010-1d3c-4028-9e00-bc1bb08e7dca','hw_vif_model','virtio','2026-01-20 14:52:59','2026-01-20 14:53:11','2026-01-20 14:53:11',1),(382,'bf636010-1d3c-4028-9e00-bc1bb08e7dca','instance_uuid','7f5cfffe-c1dc-4b00-844e-0fb35b340f44','2026-01-20 14:52:59','2026-01-20 14:53:11','2026-01-20 14:53:11',1),(383,'bf636010-1d3c-4028-9e00-bc1bb08e7dca','user_id','215db37373dc4ae5a75cbd6866f471da','2026-01-20 14:52:59','2026-01-20 14:53:11','2026-01-20 14:53:11',1),(384,'bf636010-1d3c-4028-9e00-bc1bb08e7dca','image_type','backup','2026-01-20 14:52:59','2026-01-20 14:53:11','2026-01-20 14:53:11',1),(385,'bf636010-1d3c-4028-9e00-bc1bb08e7dca','backup_type','daily','2026-01-20 14:52:59','2026-01-20 14:53:11','2026-01-20 14:53:11',1),(386,'bf636010-1d3c-4028-9e00-bc1bb08e7dca','image_state','available','2026-01-20 14:53:03','2026-01-20 14:53:11','2026-01-20 14:53:11',1),(387,'bf636010-1d3c-4028-9e00-bc1bb08e7dca','owner_id','b3b1b7f5b4f84b5abbc401eb577c85c0','2026-01-20 14:53:03','2026-01-20 14:53:11','2026-01-20 14:53:11',1),(388,'bf636010-1d3c-4028-9e00-bc1bb08e7dca','image_location','snapshot','2026-01-20 14:53:03','2026-01-20 14:53:11','2026-01-20 14:53:11',1),(389,'132a812e-f4a2-4a8b-813d-1df62e09798a','hw_rng_model','virtio','2026-01-20 14:53:31','2026-01-20 14:54:33','2026-01-20 14:54:33',1),(390,'132a812e-f4a2-4a8b-813d-1df62e09798a','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 14:53:31','2026-01-20 14:54:33','2026-01-20 14:54:33',1),(391,'132a812e-f4a2-4a8b-813d-1df62e09798a','owner_user_name','tempest-ServerStableDeviceRescueTest-129078052-project-member','2026-01-20 14:53:31','2026-01-20 14:54:33','2026-01-20 14:54:33',1),(392,'132a812e-f4a2-4a8b-813d-1df62e09798a','owner_project_name','tempest-ServerStableDeviceRescueTest-129078052','2026-01-20 14:53:31','2026-01-20 14:54:33','2026-01-20 14:54:33',1),(393,'132a812e-f4a2-4a8b-813d-1df62e09798a','boot_roles','reader,member','2026-01-20 14:53:31','2026-01-20 14:54:33','2026-01-20 14:54:33',1),(394,'132a812e-f4a2-4a8b-813d-1df62e09798a','hw_machine_type','q35','2026-01-20 14:53:31','2026-01-20 14:54:33','2026-01-20 14:54:33',1),(395,'132a812e-f4a2-4a8b-813d-1df62e09798a','hw_cdrom_bus','sata','2026-01-20 14:53:31','2026-01-20 14:54:33','2026-01-20 14:54:33',1),(396,'132a812e-f4a2-4a8b-813d-1df62e09798a','hw_disk_bus','virtio','2026-01-20 14:53:31','2026-01-20 14:54:33','2026-01-20 14:54:33',1),(397,'132a812e-f4a2-4a8b-813d-1df62e09798a','hw_input_bus','usb','2026-01-20 14:53:31','2026-01-20 14:54:33','2026-01-20 14:54:33',1),(398,'132a812e-f4a2-4a8b-813d-1df62e09798a','hw_pointer_model','usbtablet','2026-01-20 14:53:31','2026-01-20 14:54:33','2026-01-20 14:54:33',1),(399,'132a812e-f4a2-4a8b-813d-1df62e09798a','hw_video_model','virtio','2026-01-20 14:53:31','2026-01-20 14:54:33','2026-01-20 14:54:33',1),(400,'132a812e-f4a2-4a8b-813d-1df62e09798a','hw_vif_model','virtio','2026-01-20 14:53:31','2026-01-20 14:54:33','2026-01-20 14:54:33',1),(401,'132a812e-f4a2-4a8b-813d-1df62e09798a','instance_uuid','baada610-f563-4c97-89a9-56eba792c352','2026-01-20 14:53:31','2026-01-20 14:54:33','2026-01-20 14:54:33',1),(402,'132a812e-f4a2-4a8b-813d-1df62e09798a','user_id','d85d286ce6224326a0f4a15a06afbfea','2026-01-20 14:53:31','2026-01-20 14:54:33','2026-01-20 14:54:33',1),(403,'132a812e-f4a2-4a8b-813d-1df62e09798a','image_type','snapshot','2026-01-20 14:53:31','2026-01-20 14:54:33','2026-01-20 14:54:33',1),(404,'132a812e-f4a2-4a8b-813d-1df62e09798a','owner_id','0a29915e0dd2403fbd7b7e847696b00a','2026-01-20 14:53:35','2026-01-20 14:54:33','2026-01-20 14:54:33',1),(405,'132a812e-f4a2-4a8b-813d-1df62e09798a','image_state','available','2026-01-20 14:53:35','2026-01-20 14:54:33','2026-01-20 14:54:33',1),(406,'132a812e-f4a2-4a8b-813d-1df62e09798a','image_location','snapshot','2026-01-20 14:53:35','2026-01-20 14:54:33','2026-01-20 14:54:33',1),(407,'132a812e-f4a2-4a8b-813d-1df62e09798a','hw_rescue_bus','virtio','2026-01-20 14:53:40','2026-01-20 14:54:33','2026-01-20 14:54:33',1),(408,'132a812e-f4a2-4a8b-813d-1df62e09798a','hw_rescue_device','disk','2026-01-20 14:53:40','2026-01-20 14:54:33','2026-01-20 14:54:33',1),(409,'6e97db8b-a462-4791-9edf-594ed0f547e6','hw_rng_model','virtio','2026-01-20 14:53:44','2026-01-20 14:54:14','2026-01-20 14:54:14',1),(410,'6e97db8b-a462-4791-9edf-594ed0f547e6','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 14:53:44','2026-01-20 14:54:14','2026-01-20 14:54:14',1),(411,'6e97db8b-a462-4791-9edf-594ed0f547e6','owner_user_name','tempest-AttachVolumeShelveTestJSON-896995479-project-member','2026-01-20 14:53:44','2026-01-20 14:54:14','2026-01-20 14:54:14',1),(412,'6e97db8b-a462-4791-9edf-594ed0f547e6','owner_project_name','tempest-AttachVolumeShelveTestJSON-896995479','2026-01-20 14:53:44','2026-01-20 14:54:14','2026-01-20 14:54:14',1),(413,'6e97db8b-a462-4791-9edf-594ed0f547e6','boot_roles','member,reader','2026-01-20 14:53:44','2026-01-20 14:54:14','2026-01-20 14:54:14',1),(414,'6e97db8b-a462-4791-9edf-594ed0f547e6','hw_machine_type','q35','2026-01-20 14:53:44','2026-01-20 14:54:14','2026-01-20 14:54:14',1),(415,'6e97db8b-a462-4791-9edf-594ed0f547e6','hw_cdrom_bus','sata','2026-01-20 14:53:44','2026-01-20 14:54:14','2026-01-20 14:54:14',1),(416,'6e97db8b-a462-4791-9edf-594ed0f547e6','hw_disk_bus','virtio','2026-01-20 14:53:44','2026-01-20 14:54:14','2026-01-20 14:54:14',1),(417,'6e97db8b-a462-4791-9edf-594ed0f547e6','hw_input_bus','usb','2026-01-20 14:53:44','2026-01-20 14:54:14','2026-01-20 14:54:14',1),(418,'6e97db8b-a462-4791-9edf-594ed0f547e6','hw_pointer_model','usbtablet','2026-01-20 14:53:44','2026-01-20 14:54:14','2026-01-20 14:54:14',1),(419,'6e97db8b-a462-4791-9edf-594ed0f547e6','hw_video_model','virtio','2026-01-20 14:53:44','2026-01-20 14:54:14','2026-01-20 14:54:14',1),(420,'6e97db8b-a462-4791-9edf-594ed0f547e6','hw_vif_model','virtio','2026-01-20 14:53:44','2026-01-20 14:54:14','2026-01-20 14:54:14',1),(421,'6e97db8b-a462-4791-9edf-594ed0f547e6','instance_uuid','49919d3f-fab0-404f-a0a0-82610973a254','2026-01-20 14:53:44','2026-01-20 14:54:14','2026-01-20 14:54:14',1),(422,'6e97db8b-a462-4791-9edf-594ed0f547e6','user_id','34eb73f628994c11801d447148d5f142','2026-01-20 14:53:44','2026-01-20 14:54:14','2026-01-20 14:54:14',1),(423,'6e97db8b-a462-4791-9edf-594ed0f547e6','image_type','snapshot','2026-01-20 14:53:44','2026-01-20 14:54:14','2026-01-20 14:54:14',1),(424,'6e97db8b-a462-4791-9edf-594ed0f547e6','image_state','available','2026-01-20 14:53:51','2026-01-20 14:54:14','2026-01-20 14:54:14',1),(425,'6e97db8b-a462-4791-9edf-594ed0f547e6','image_location','snapshot','2026-01-20 14:53:51','2026-01-20 14:54:14','2026-01-20 14:54:14',1),(426,'6e97db8b-a462-4791-9edf-594ed0f547e6','owner_id','b1e83af992c94112a965575784639d77','2026-01-20 14:53:51','2026-01-20 14:54:14','2026-01-20 14:54:14',1),(427,'041ed532-ca1e-46fd-bdf4-eb2674a7c406','hw_rng_model','virtio','2026-01-20 14:54:58','2026-01-20 14:55:00','2026-01-20 14:55:00',1),(428,'041ed532-ca1e-46fd-bdf4-eb2674a7c406','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 14:54:58','2026-01-20 14:55:00','2026-01-20 14:55:00',1),(429,'041ed532-ca1e-46fd-bdf4-eb2674a7c406','owner_user_name','tempest-ServersAaction247Test-136177538-project-member','2026-01-20 14:54:58','2026-01-20 14:55:00','2026-01-20 14:55:00',1),(430,'041ed532-ca1e-46fd-bdf4-eb2674a7c406','owner_project_name','tempest-ServersAaction247Test-136177538','2026-01-20 14:54:58','2026-01-20 14:55:00','2026-01-20 14:55:00',1),(431,'041ed532-ca1e-46fd-bdf4-eb2674a7c406','boot_roles','reader,member','2026-01-20 14:54:58','2026-01-20 14:55:00','2026-01-20 14:55:00',1),(432,'041ed532-ca1e-46fd-bdf4-eb2674a7c406','hw_machine_type','q35','2026-01-20 14:54:58','2026-01-20 14:55:00','2026-01-20 14:55:00',1),(433,'041ed532-ca1e-46fd-bdf4-eb2674a7c406','hw_cdrom_bus','sata','2026-01-20 14:54:58','2026-01-20 14:55:00','2026-01-20 14:55:00',1),(434,'041ed532-ca1e-46fd-bdf4-eb2674a7c406','hw_disk_bus','virtio','2026-01-20 14:54:58','2026-01-20 14:55:00','2026-01-20 14:55:00',1),(435,'041ed532-ca1e-46fd-bdf4-eb2674a7c406','hw_input_bus','usb','2026-01-20 14:54:58','2026-01-20 14:55:00','2026-01-20 14:55:00',1),(436,'041ed532-ca1e-46fd-bdf4-eb2674a7c406','hw_pointer_model','usbtablet','2026-01-20 14:54:58','2026-01-20 14:55:00','2026-01-20 14:55:00',1),(437,'041ed532-ca1e-46fd-bdf4-eb2674a7c406','hw_video_model','virtio','2026-01-20 14:54:58','2026-01-20 14:55:00','2026-01-20 14:55:00',1),(438,'041ed532-ca1e-46fd-bdf4-eb2674a7c406','hw_vif_model','virtio','2026-01-20 14:54:58','2026-01-20 14:55:00','2026-01-20 14:55:00',1),(439,'041ed532-ca1e-46fd-bdf4-eb2674a7c406','instance_uuid','c8a40dd4-910a-4389-b1ef-48037cf3c09d','2026-01-20 14:54:58','2026-01-20 14:55:00','2026-01-20 14:55:00',1),(440,'041ed532-ca1e-46fd-bdf4-eb2674a7c406','user_id','50108de2458b4a0988111e0a0e271937','2026-01-20 14:54:58','2026-01-20 14:55:00','2026-01-20 14:55:00',1),(441,'041ed532-ca1e-46fd-bdf4-eb2674a7c406','image_type','backup','2026-01-20 14:54:58','2026-01-20 14:55:00','2026-01-20 14:55:00',1),(442,'041ed532-ca1e-46fd-bdf4-eb2674a7c406','backup_type','daily','2026-01-20 14:54:58','2026-01-20 14:55:00','2026-01-20 14:55:00',1),(443,'0f1d91a7-05af-4ed6-87af-1e03976e25f0','hw_rng_model','virtio','2026-01-20 14:55:18','2026-01-20 14:55:50','2026-01-20 14:55:50',1),(444,'0f1d91a7-05af-4ed6-87af-1e03976e25f0','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 14:55:18','2026-01-20 14:55:50','2026-01-20 14:55:50',1),(445,'0f1d91a7-05af-4ed6-87af-1e03976e25f0','owner_user_name','tempest-AttachVolumeShelveTestJSON-896995479-project-member','2026-01-20 14:55:18','2026-01-20 14:55:50','2026-01-20 14:55:50',1),(446,'0f1d91a7-05af-4ed6-87af-1e03976e25f0','owner_project_name','tempest-AttachVolumeShelveTestJSON-896995479','2026-01-20 14:55:18','2026-01-20 14:55:50','2026-01-20 14:55:50',1),(447,'0f1d91a7-05af-4ed6-87af-1e03976e25f0','boot_roles','member,reader','2026-01-20 14:55:18','2026-01-20 14:55:50','2026-01-20 14:55:50',1),(448,'0f1d91a7-05af-4ed6-87af-1e03976e25f0','hw_machine_type','q35','2026-01-20 14:55:18','2026-01-20 14:55:50','2026-01-20 14:55:50',1),(449,'0f1d91a7-05af-4ed6-87af-1e03976e25f0','hw_cdrom_bus','sata','2026-01-20 14:55:18','2026-01-20 14:55:50','2026-01-20 14:55:50',1),(450,'0f1d91a7-05af-4ed6-87af-1e03976e25f0','hw_disk_bus','virtio','2026-01-20 14:55:18','2026-01-20 14:55:50','2026-01-20 14:55:50',1),(451,'0f1d91a7-05af-4ed6-87af-1e03976e25f0','hw_input_bus','usb','2026-01-20 14:55:18','2026-01-20 14:55:50','2026-01-20 14:55:50',1),(452,'0f1d91a7-05af-4ed6-87af-1e03976e25f0','hw_pointer_model','usbtablet','2026-01-20 14:55:18','2026-01-20 14:55:50','2026-01-20 14:55:50',1),(453,'0f1d91a7-05af-4ed6-87af-1e03976e25f0','hw_video_model','virtio','2026-01-20 14:55:18','2026-01-20 14:55:50','2026-01-20 14:55:50',1),(454,'0f1d91a7-05af-4ed6-87af-1e03976e25f0','hw_vif_model','virtio','2026-01-20 14:55:18','2026-01-20 14:55:50','2026-01-20 14:55:50',1),(455,'0f1d91a7-05af-4ed6-87af-1e03976e25f0','instance_uuid','3bec73f6-5255-44c0-8a10-a64c7e86c0c2','2026-01-20 14:55:18','2026-01-20 14:55:50','2026-01-20 14:55:50',1),(456,'0f1d91a7-05af-4ed6-87af-1e03976e25f0','user_id','34eb73f628994c11801d447148d5f142','2026-01-20 14:55:18','2026-01-20 14:55:50','2026-01-20 14:55:50',1),(457,'0f1d91a7-05af-4ed6-87af-1e03976e25f0','image_type','snapshot','2026-01-20 14:55:18','2026-01-20 14:55:50','2026-01-20 14:55:50',1),(458,'0f1d91a7-05af-4ed6-87af-1e03976e25f0','owner_id','b1e83af992c94112a965575784639d77','2026-01-20 14:55:26','2026-01-20 14:55:50','2026-01-20 14:55:50',1),(459,'0f1d91a7-05af-4ed6-87af-1e03976e25f0','image_state','available','2026-01-20 14:55:26','2026-01-20 14:55:50','2026-01-20 14:55:50',1),(460,'0f1d91a7-05af-4ed6-87af-1e03976e25f0','image_location','snapshot','2026-01-20 14:55:26','2026-01-20 14:55:50','2026-01-20 14:55:50',1),(461,'6fa40815-d8ae-463b-8e43-fe8a8d4374e5','hw_rng_model','virtio','2026-01-20 14:56:46','2026-01-20 14:57:38','2026-01-20 14:57:38',1),(462,'6fa40815-d8ae-463b-8e43-fe8a8d4374e5','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 14:56:46','2026-01-20 14:57:38','2026-01-20 14:57:38',1),(463,'6fa40815-d8ae-463b-8e43-fe8a8d4374e5','owner_user_name','tempest-ServerActionsTestOtherB-1136521362-project-member','2026-01-20 14:56:46','2026-01-20 14:57:38','2026-01-20 14:57:38',1),(464,'6fa40815-d8ae-463b-8e43-fe8a8d4374e5','owner_project_name','tempest-ServerActionsTestOtherB-1136521362','2026-01-20 14:56:46','2026-01-20 14:57:38','2026-01-20 14:57:38',1),(465,'6fa40815-d8ae-463b-8e43-fe8a8d4374e5','boot_roles','reader,member','2026-01-20 14:56:46','2026-01-20 14:57:38','2026-01-20 14:57:38',1),(466,'6fa40815-d8ae-463b-8e43-fe8a8d4374e5','hw_machine_type','q35','2026-01-20 14:56:46','2026-01-20 14:57:38','2026-01-20 14:57:38',1),(467,'6fa40815-d8ae-463b-8e43-fe8a8d4374e5','hw_cdrom_bus','sata','2026-01-20 14:56:46','2026-01-20 14:57:38','2026-01-20 14:57:38',1),(468,'6fa40815-d8ae-463b-8e43-fe8a8d4374e5','hw_disk_bus','virtio','2026-01-20 14:56:46','2026-01-20 14:57:38','2026-01-20 14:57:38',1),(469,'6fa40815-d8ae-463b-8e43-fe8a8d4374e5','hw_input_bus','usb','2026-01-20 14:56:46','2026-01-20 14:57:38','2026-01-20 14:57:38',1),(470,'6fa40815-d8ae-463b-8e43-fe8a8d4374e5','hw_pointer_model','usbtablet','2026-01-20 14:56:46','2026-01-20 14:57:38','2026-01-20 14:57:38',1),(471,'6fa40815-d8ae-463b-8e43-fe8a8d4374e5','hw_video_model','virtio','2026-01-20 14:56:46','2026-01-20 14:57:38','2026-01-20 14:57:38',1),(472,'6fa40815-d8ae-463b-8e43-fe8a8d4374e5','hw_vif_model','virtio','2026-01-20 14:56:46','2026-01-20 14:57:38','2026-01-20 14:57:38',1),(473,'6fa40815-d8ae-463b-8e43-fe8a8d4374e5','instance_uuid','07b956d3-9ad0-4477-9774-52336fa39e0c','2026-01-20 14:56:46','2026-01-20 14:57:38','2026-01-20 14:57:38',1),(474,'6fa40815-d8ae-463b-8e43-fe8a8d4374e5','user_id','215db37373dc4ae5a75cbd6866f471da','2026-01-20 14:56:46','2026-01-20 14:57:38','2026-01-20 14:57:38',1),(475,'6fa40815-d8ae-463b-8e43-fe8a8d4374e5','image_type','snapshot','2026-01-20 14:56:46','2026-01-20 14:57:38','2026-01-20 14:57:38',1),(476,'6fa40815-d8ae-463b-8e43-fe8a8d4374e5','image_state','available','2026-01-20 14:56:52','2026-01-20 14:57:38','2026-01-20 14:57:38',1),(477,'6fa40815-d8ae-463b-8e43-fe8a8d4374e5','owner_id','b3b1b7f5b4f84b5abbc401eb577c85c0','2026-01-20 14:56:52','2026-01-20 14:57:38','2026-01-20 14:57:38',1),(478,'6fa40815-d8ae-463b-8e43-fe8a8d4374e5','image_location','snapshot','2026-01-20 14:56:52','2026-01-20 14:57:38','2026-01-20 14:57:38',1),(479,'1f2389f5-ba66-4c2e-9f07-9051cd05b976','hw_rng_model','virtio','2026-01-20 14:57:04','2026-01-20 14:57:33','2026-01-20 14:57:33',1),(480,'1f2389f5-ba66-4c2e-9f07-9051cd05b976','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 14:57:04','2026-01-20 14:57:33','2026-01-20 14:57:33',1),(481,'1f2389f5-ba66-4c2e-9f07-9051cd05b976','owner_user_name','tempest-ServerActionsTestOtherB-1136521362-project-member','2026-01-20 14:57:04','2026-01-20 14:57:33','2026-01-20 14:57:33',1),(482,'1f2389f5-ba66-4c2e-9f07-9051cd05b976','owner_project_name','tempest-ServerActionsTestOtherB-1136521362','2026-01-20 14:57:04','2026-01-20 14:57:33','2026-01-20 14:57:33',1),(483,'1f2389f5-ba66-4c2e-9f07-9051cd05b976','boot_roles','reader,member','2026-01-20 14:57:04','2026-01-20 14:57:33','2026-01-20 14:57:33',1),(484,'1f2389f5-ba66-4c2e-9f07-9051cd05b976','hw_machine_type','q35','2026-01-20 14:57:04','2026-01-20 14:57:33','2026-01-20 14:57:33',1),(485,'1f2389f5-ba66-4c2e-9f07-9051cd05b976','hw_cdrom_bus','sata','2026-01-20 14:57:04','2026-01-20 14:57:33','2026-01-20 14:57:33',1),(486,'1f2389f5-ba66-4c2e-9f07-9051cd05b976','hw_disk_bus','virtio','2026-01-20 14:57:04','2026-01-20 14:57:33','2026-01-20 14:57:33',1),(487,'1f2389f5-ba66-4c2e-9f07-9051cd05b976','hw_input_bus','usb','2026-01-20 14:57:04','2026-01-20 14:57:33','2026-01-20 14:57:33',1),(488,'1f2389f5-ba66-4c2e-9f07-9051cd05b976','hw_pointer_model','usbtablet','2026-01-20 14:57:04','2026-01-20 14:57:33','2026-01-20 14:57:33',1),(489,'1f2389f5-ba66-4c2e-9f07-9051cd05b976','hw_video_model','virtio','2026-01-20 14:57:04','2026-01-20 14:57:33','2026-01-20 14:57:33',1),(490,'1f2389f5-ba66-4c2e-9f07-9051cd05b976','hw_vif_model','virtio','2026-01-20 14:57:04','2026-01-20 14:57:33','2026-01-20 14:57:33',1),(491,'1f2389f5-ba66-4c2e-9f07-9051cd05b976','instance_uuid','cf24bde1-0912-4d63-8959-6799ae8ab043','2026-01-20 14:57:04','2026-01-20 14:57:33','2026-01-20 14:57:33',1),(492,'1f2389f5-ba66-4c2e-9f07-9051cd05b976','user_id','215db37373dc4ae5a75cbd6866f471da','2026-01-20 14:57:04','2026-01-20 14:57:33','2026-01-20 14:57:33',1),(493,'1f2389f5-ba66-4c2e-9f07-9051cd05b976','image_type','snapshot','2026-01-20 14:57:04','2026-01-20 14:57:33','2026-01-20 14:57:33',1),(494,'1f2389f5-ba66-4c2e-9f07-9051cd05b976','image_state','available','2026-01-20 14:57:11','2026-01-20 14:57:33','2026-01-20 14:57:33',1),(495,'1f2389f5-ba66-4c2e-9f07-9051cd05b976','image_location','snapshot','2026-01-20 14:57:11','2026-01-20 14:57:33','2026-01-20 14:57:33',1),(496,'1f2389f5-ba66-4c2e-9f07-9051cd05b976','owner_id','b3b1b7f5b4f84b5abbc401eb577c85c0','2026-01-20 14:57:11','2026-01-20 14:57:33','2026-01-20 14:57:33',1),(497,'8976571c-92ae-42ce-94dd-a05ec6e308b3','hw_rng_model','virtio','2026-01-20 15:00:42','2026-01-20 15:01:23','2026-01-20 15:01:23',1),(498,'8976571c-92ae-42ce-94dd-a05ec6e308b3','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 15:00:42','2026-01-20 15:01:23','2026-01-20 15:01:23',1),(499,'8976571c-92ae-42ce-94dd-a05ec6e308b3','owner_user_name','tempest-ServersNegativeTestJSON-1233513591-project-member','2026-01-20 15:00:42','2026-01-20 15:01:23','2026-01-20 15:01:23',1),(500,'8976571c-92ae-42ce-94dd-a05ec6e308b3','owner_project_name','tempest-ServersNegativeTestJSON-1233513591','2026-01-20 15:00:42','2026-01-20 15:01:23','2026-01-20 15:01:23',1),(501,'8976571c-92ae-42ce-94dd-a05ec6e308b3','boot_roles','member,reader','2026-01-20 15:00:42','2026-01-20 15:01:23','2026-01-20 15:01:23',1),(502,'8976571c-92ae-42ce-94dd-a05ec6e308b3','hw_machine_type','q35','2026-01-20 15:00:42','2026-01-20 15:01:23','2026-01-20 15:01:23',1),(503,'8976571c-92ae-42ce-94dd-a05ec6e308b3','hw_cdrom_bus','sata','2026-01-20 15:00:42','2026-01-20 15:01:23','2026-01-20 15:01:23',1),(504,'8976571c-92ae-42ce-94dd-a05ec6e308b3','hw_disk_bus','virtio','2026-01-20 15:00:42','2026-01-20 15:01:23','2026-01-20 15:01:23',1),(505,'8976571c-92ae-42ce-94dd-a05ec6e308b3','hw_input_bus','usb','2026-01-20 15:00:42','2026-01-20 15:01:23','2026-01-20 15:01:23',1),(506,'8976571c-92ae-42ce-94dd-a05ec6e308b3','hw_pointer_model','usbtablet','2026-01-20 15:00:42','2026-01-20 15:01:23','2026-01-20 15:01:23',1),(507,'8976571c-92ae-42ce-94dd-a05ec6e308b3','hw_video_model','virtio','2026-01-20 15:00:42','2026-01-20 15:01:23','2026-01-20 15:01:23',1),(508,'8976571c-92ae-42ce-94dd-a05ec6e308b3','hw_vif_model','virtio','2026-01-20 15:00:42','2026-01-20 15:01:23','2026-01-20 15:01:23',1),(509,'8976571c-92ae-42ce-94dd-a05ec6e308b3','instance_uuid','61ae2c61-01df-4ef1-8aa3-0527a43b1798','2026-01-20 15:00:42','2026-01-20 15:01:23','2026-01-20 15:01:23',1),(510,'8976571c-92ae-42ce-94dd-a05ec6e308b3','user_id','d77d3db3cf924683a608d10efefcd156','2026-01-20 15:00:42','2026-01-20 15:01:23','2026-01-20 15:01:23',1),(511,'8976571c-92ae-42ce-94dd-a05ec6e308b3','image_type','snapshot','2026-01-20 15:00:42','2026-01-20 15:01:23','2026-01-20 15:01:23',1),(512,'8976571c-92ae-42ce-94dd-a05ec6e308b3','image_state','available','2026-01-20 15:00:50','2026-01-20 15:01:23','2026-01-20 15:01:23',1),(513,'8976571c-92ae-42ce-94dd-a05ec6e308b3','owner_id','105e56abe3804424885c7aa8d1216d12','2026-01-20 15:00:50','2026-01-20 15:01:23','2026-01-20 15:01:23',1),(514,'8976571c-92ae-42ce-94dd-a05ec6e308b3','image_location','snapshot','2026-01-20 15:00:50','2026-01-20 15:01:23','2026-01-20 15:01:23',1),(515,'9c1c8ad1-376e-4dd8-93d8-70f0aa412977','hw_rng_model','virtio','2026-01-20 15:01:31','2026-01-20 15:05:18','2026-01-20 15:05:18',1),(516,'9c1c8ad1-376e-4dd8-93d8-70f0aa412977','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 15:01:31','2026-01-20 15:05:18','2026-01-20 15:05:18',1),(517,'9c1c8ad1-376e-4dd8-93d8-70f0aa412977','owner_user_name','tempest-ServerBootFromVolumeStableRescueTest-1871371328-project-member','2026-01-20 15:01:31','2026-01-20 15:05:18','2026-01-20 15:05:18',1),(518,'9c1c8ad1-376e-4dd8-93d8-70f0aa412977','owner_project_name','tempest-ServerBootFromVolumeStableRescueTest-1871371328','2026-01-20 15:01:31','2026-01-20 15:05:18','2026-01-20 15:05:18',1),(519,'9c1c8ad1-376e-4dd8-93d8-70f0aa412977','boot_roles','reader,member','2026-01-20 15:01:31','2026-01-20 15:05:18','2026-01-20 15:05:18',1),(520,'9c1c8ad1-376e-4dd8-93d8-70f0aa412977','hw_machine_type','q35','2026-01-20 15:01:31','2026-01-20 15:05:18','2026-01-20 15:05:18',1),(521,'9c1c8ad1-376e-4dd8-93d8-70f0aa412977','hw_cdrom_bus','sata','2026-01-20 15:01:31','2026-01-20 15:05:18','2026-01-20 15:05:18',1),(522,'9c1c8ad1-376e-4dd8-93d8-70f0aa412977','hw_disk_bus','virtio','2026-01-20 15:01:31','2026-01-20 15:05:18','2026-01-20 15:05:18',1),(523,'9c1c8ad1-376e-4dd8-93d8-70f0aa412977','hw_input_bus','usb','2026-01-20 15:01:31','2026-01-20 15:05:18','2026-01-20 15:05:18',1),(524,'9c1c8ad1-376e-4dd8-93d8-70f0aa412977','hw_pointer_model','usbtablet','2026-01-20 15:01:31','2026-01-20 15:05:18','2026-01-20 15:05:18',1),(525,'9c1c8ad1-376e-4dd8-93d8-70f0aa412977','hw_video_model','virtio','2026-01-20 15:01:31','2026-01-20 15:05:18','2026-01-20 15:05:18',1),(526,'9c1c8ad1-376e-4dd8-93d8-70f0aa412977','hw_vif_model','virtio','2026-01-20 15:01:31','2026-01-20 15:05:18','2026-01-20 15:05:18',1),(527,'9c1c8ad1-376e-4dd8-93d8-70f0aa412977','instance_uuid','b3f961d2-e73f-49bf-b141-6505e77ad9ac','2026-01-20 15:01:31','2026-01-20 15:05:18','2026-01-20 15:05:18',1),(528,'9c1c8ad1-376e-4dd8-93d8-70f0aa412977','user_id','2446e8399b344b29986c1aaf8bf73adf','2026-01-20 15:01:31','2026-01-20 15:05:18','2026-01-20 15:05:18',1),(529,'9c1c8ad1-376e-4dd8-93d8-70f0aa412977','image_type','snapshot','2026-01-20 15:01:31','2026-01-20 15:05:18','2026-01-20 15:05:18',1),(530,'9c1c8ad1-376e-4dd8-93d8-70f0aa412977','image_state','available','2026-01-20 15:01:37','2026-01-20 15:05:18','2026-01-20 15:05:18',1),(531,'9c1c8ad1-376e-4dd8-93d8-70f0aa412977','owner_id','63555e5851564db08c6429231d264f2c','2026-01-20 15:01:37','2026-01-20 15:05:18','2026-01-20 15:05:18',1),(532,'9c1c8ad1-376e-4dd8-93d8-70f0aa412977','image_location','snapshot','2026-01-20 15:01:37','2026-01-20 15:05:18','2026-01-20 15:05:18',1),(533,'9c1c8ad1-376e-4dd8-93d8-70f0aa412977','hw_rescue_bus','virtio','2026-01-20 15:01:54','2026-01-20 15:05:18','2026-01-20 15:05:18',1),(534,'9c1c8ad1-376e-4dd8-93d8-70f0aa412977','hw_rescue_device','disk','2026-01-20 15:01:54','2026-01-20 15:05:18','2026-01-20 15:05:18',1),(535,'97fb0fa0-6803-480b-96d2-4a219153376d','hw_rng_model','virtio','2026-01-20 15:02:18','2026-01-20 15:03:40','2026-01-20 15:03:40',1),(536,'97fb0fa0-6803-480b-96d2-4a219153376d','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 15:02:18','2026-01-20 15:03:40','2026-01-20 15:03:40',1),(537,'97fb0fa0-6803-480b-96d2-4a219153376d','owner_user_name','tempest-TestSnapshotPattern-1341092631-project-member','2026-01-20 15:02:18','2026-01-20 15:03:40','2026-01-20 15:03:40',1),(538,'97fb0fa0-6803-480b-96d2-4a219153376d','owner_project_name','tempest-TestSnapshotPattern-1341092631','2026-01-20 15:02:18','2026-01-20 15:03:40','2026-01-20 15:03:40',1),(539,'97fb0fa0-6803-480b-96d2-4a219153376d','boot_roles','member,reader','2026-01-20 15:02:18','2026-01-20 15:03:40','2026-01-20 15:03:40',1),(540,'97fb0fa0-6803-480b-96d2-4a219153376d','hw_machine_type','q35','2026-01-20 15:02:18','2026-01-20 15:03:40','2026-01-20 15:03:40',1),(541,'97fb0fa0-6803-480b-96d2-4a219153376d','hw_cdrom_bus','sata','2026-01-20 15:02:18','2026-01-20 15:03:40','2026-01-20 15:03:40',1),(542,'97fb0fa0-6803-480b-96d2-4a219153376d','hw_disk_bus','virtio','2026-01-20 15:02:18','2026-01-20 15:03:40','2026-01-20 15:03:40',1),(543,'97fb0fa0-6803-480b-96d2-4a219153376d','hw_input_bus','usb','2026-01-20 15:02:18','2026-01-20 15:03:40','2026-01-20 15:03:40',1),(544,'97fb0fa0-6803-480b-96d2-4a219153376d','hw_pointer_model','usbtablet','2026-01-20 15:02:18','2026-01-20 15:03:40','2026-01-20 15:03:40',1),(545,'97fb0fa0-6803-480b-96d2-4a219153376d','hw_video_model','virtio','2026-01-20 15:02:18','2026-01-20 15:03:40','2026-01-20 15:03:40',1),(546,'97fb0fa0-6803-480b-96d2-4a219153376d','hw_vif_model','virtio','2026-01-20 15:02:18','2026-01-20 15:03:40','2026-01-20 15:03:40',1),(547,'97fb0fa0-6803-480b-96d2-4a219153376d','instance_uuid','2b9353e4-2bd0-4a4a-b9a1-dd24929a4af1','2026-01-20 15:02:18','2026-01-20 15:03:40','2026-01-20 15:03:40',1),(548,'97fb0fa0-6803-480b-96d2-4a219153376d','user_id','1654794111844ca88666b3529173e9a7','2026-01-20 15:02:18','2026-01-20 15:03:40','2026-01-20 15:03:40',1),(549,'97fb0fa0-6803-480b-96d2-4a219153376d','image_type','snapshot','2026-01-20 15:02:18','2026-01-20 15:03:40','2026-01-20 15:03:40',1),(550,'97fb0fa0-6803-480b-96d2-4a219153376d','owner_id','3a1d679d5c954662a271e842fe2f2c05','2026-01-20 15:02:24','2026-01-20 15:03:40','2026-01-20 15:03:40',1),(551,'97fb0fa0-6803-480b-96d2-4a219153376d','image_state','available','2026-01-20 15:02:24','2026-01-20 15:03:40','2026-01-20 15:03:40',1),(552,'97fb0fa0-6803-480b-96d2-4a219153376d','image_location','snapshot','2026-01-20 15:02:24','2026-01-20 15:03:40','2026-01-20 15:03:40',1),(553,'97fb0fa0-6803-480b-96d2-4a219153376d','version','8.0','2026-01-20 15:02:25','2026-01-20 15:03:40','2026-01-20 15:03:40',1),(554,'fc0edfd5-d120-40a0-889d-d3576a58edb6','hw_rng_model','virtio','2026-01-20 15:03:16','2026-01-20 15:03:24','2026-01-20 15:03:24',1),(555,'fc0edfd5-d120-40a0-889d-d3576a58edb6','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 15:03:16','2026-01-20 15:03:24','2026-01-20 15:03:24',1),(556,'fc0edfd5-d120-40a0-889d-d3576a58edb6','owner_user_name','tempest-TestSnapshotPattern-1341092631-project-member','2026-01-20 15:03:16','2026-01-20 15:03:24','2026-01-20 15:03:24',1),(557,'fc0edfd5-d120-40a0-889d-d3576a58edb6','owner_project_name','tempest-TestSnapshotPattern-1341092631','2026-01-20 15:03:16','2026-01-20 15:03:24','2026-01-20 15:03:24',1),(558,'fc0edfd5-d120-40a0-889d-d3576a58edb6','boot_roles','reader,member','2026-01-20 15:03:16','2026-01-20 15:03:24','2026-01-20 15:03:24',1),(559,'fc0edfd5-d120-40a0-889d-d3576a58edb6','hw_machine_type','q35','2026-01-20 15:03:16','2026-01-20 15:03:24','2026-01-20 15:03:24',1),(560,'fc0edfd5-d120-40a0-889d-d3576a58edb6','hw_cdrom_bus','sata','2026-01-20 15:03:16','2026-01-20 15:03:24','2026-01-20 15:03:24',1),(561,'fc0edfd5-d120-40a0-889d-d3576a58edb6','hw_disk_bus','virtio','2026-01-20 15:03:16','2026-01-20 15:03:24','2026-01-20 15:03:24',1),(562,'fc0edfd5-d120-40a0-889d-d3576a58edb6','hw_input_bus','usb','2026-01-20 15:03:16','2026-01-20 15:03:24','2026-01-20 15:03:24',1),(563,'fc0edfd5-d120-40a0-889d-d3576a58edb6','hw_pointer_model','usbtablet','2026-01-20 15:03:16','2026-01-20 15:03:24','2026-01-20 15:03:24',1),(564,'fc0edfd5-d120-40a0-889d-d3576a58edb6','hw_video_model','virtio','2026-01-20 15:03:16','2026-01-20 15:03:24','2026-01-20 15:03:24',1),(565,'fc0edfd5-d120-40a0-889d-d3576a58edb6','hw_vif_model','virtio','2026-01-20 15:03:16','2026-01-20 15:03:24','2026-01-20 15:03:24',1),(566,'fc0edfd5-d120-40a0-889d-d3576a58edb6','instance_uuid','c2a7aae5-0ef8-400a-acfe-2fbf83144560','2026-01-20 15:03:16','2026-01-20 15:03:24','2026-01-20 15:03:24',1),(567,'fc0edfd5-d120-40a0-889d-d3576a58edb6','user_id','1654794111844ca88666b3529173e9a7','2026-01-20 15:03:16','2026-01-20 15:03:24','2026-01-20 15:03:24',1),(568,'fc0edfd5-d120-40a0-889d-d3576a58edb6','image_type','snapshot','2026-01-20 15:03:16','2026-01-20 15:03:24','2026-01-20 15:03:24',1),(569,'fc0edfd5-d120-40a0-889d-d3576a58edb6','owner_id','3a1d679d5c954662a271e842fe2f2c05','2026-01-20 15:03:16','2026-01-20 15:03:24','2026-01-20 15:03:24',1),(570,'fc0edfd5-d120-40a0-889d-d3576a58edb6','image_state','available','2026-01-20 15:03:16','2026-01-20 15:03:24','2026-01-20 15:03:24',1),(571,'fc0edfd5-d120-40a0-889d-d3576a58edb6','image_location','snapshot','2026-01-20 15:03:16','2026-01-20 15:03:24','2026-01-20 15:03:24',1),(572,'fc0edfd5-d120-40a0-889d-d3576a58edb6','version','8.0','2026-01-20 15:03:16','2026-01-20 15:03:24','2026-01-20 15:03:24',1),(573,'7f0d068e-5d2b-485d-b65c-7244508ab6b6','hw_rng_model','virtio','2026-01-20 15:03:27','2026-01-20 15:05:00','2026-01-20 15:05:00',1),(574,'7f0d068e-5d2b-485d-b65c-7244508ab6b6','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 15:03:27','2026-01-20 15:05:00','2026-01-20 15:05:00',1),(575,'7f0d068e-5d2b-485d-b65c-7244508ab6b6','owner_user_name','tempest-ServerBootFromVolumeStableRescueTest-1871371328-project-member','2026-01-20 15:03:27','2026-01-20 15:05:00','2026-01-20 15:05:00',1),(576,'7f0d068e-5d2b-485d-b65c-7244508ab6b6','owner_project_name','tempest-ServerBootFromVolumeStableRescueTest-1871371328','2026-01-20 15:03:27','2026-01-20 15:05:00','2026-01-20 15:05:00',1),(577,'7f0d068e-5d2b-485d-b65c-7244508ab6b6','boot_roles','reader,member','2026-01-20 15:03:27','2026-01-20 15:05:00','2026-01-20 15:05:00',1),(578,'7f0d068e-5d2b-485d-b65c-7244508ab6b6','hw_machine_type','q35','2026-01-20 15:03:27','2026-01-20 15:05:00','2026-01-20 15:05:00',1),(579,'7f0d068e-5d2b-485d-b65c-7244508ab6b6','hw_cdrom_bus','sata','2026-01-20 15:03:27','2026-01-20 15:05:00','2026-01-20 15:05:00',1),(580,'7f0d068e-5d2b-485d-b65c-7244508ab6b6','hw_disk_bus','virtio','2026-01-20 15:03:27','2026-01-20 15:05:00','2026-01-20 15:05:00',1),(581,'7f0d068e-5d2b-485d-b65c-7244508ab6b6','hw_input_bus','usb','2026-01-20 15:03:27','2026-01-20 15:05:00','2026-01-20 15:05:00',1),(582,'7f0d068e-5d2b-485d-b65c-7244508ab6b6','hw_pointer_model','usbtablet','2026-01-20 15:03:27','2026-01-20 15:05:00','2026-01-20 15:05:00',1),(583,'7f0d068e-5d2b-485d-b65c-7244508ab6b6','hw_video_model','virtio','2026-01-20 15:03:27','2026-01-20 15:05:00','2026-01-20 15:05:00',1),(584,'7f0d068e-5d2b-485d-b65c-7244508ab6b6','hw_vif_model','virtio','2026-01-20 15:03:27','2026-01-20 15:05:00','2026-01-20 15:05:00',1),(585,'7f0d068e-5d2b-485d-b65c-7244508ab6b6','instance_uuid','83bbf40a-f44e-42fe-b09a-0e635a302f6d','2026-01-20 15:03:27','2026-01-20 15:05:00','2026-01-20 15:05:00',1),(586,'7f0d068e-5d2b-485d-b65c-7244508ab6b6','user_id','2446e8399b344b29986c1aaf8bf73adf','2026-01-20 15:03:27','2026-01-20 15:05:00','2026-01-20 15:05:00',1),(587,'7f0d068e-5d2b-485d-b65c-7244508ab6b6','image_type','snapshot','2026-01-20 15:03:27','2026-01-20 15:05:00','2026-01-20 15:05:00',1),(588,'7f0d068e-5d2b-485d-b65c-7244508ab6b6','image_state','available','2026-01-20 15:03:34','2026-01-20 15:05:00','2026-01-20 15:05:00',1),(589,'7f0d068e-5d2b-485d-b65c-7244508ab6b6','owner_id','63555e5851564db08c6429231d264f2c','2026-01-20 15:03:34','2026-01-20 15:05:00','2026-01-20 15:05:00',1),(590,'7f0d068e-5d2b-485d-b65c-7244508ab6b6','image_location','snapshot','2026-01-20 15:03:34','2026-01-20 15:05:00','2026-01-20 15:05:00',1),(591,'54adca73-9204-4335-8f5e-a77f60750fc4','hw_rng_model','virtio','2026-01-20 15:04:08','2026-01-20 15:04:47','2026-01-20 15:04:47',1),(592,'54adca73-9204-4335-8f5e-a77f60750fc4','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 15:04:08','2026-01-20 15:04:47','2026-01-20 15:04:47',1),(593,'54adca73-9204-4335-8f5e-a77f60750fc4','owner_user_name','tempest-TestShelveInstance-1425544575-project-member','2026-01-20 15:04:08','2026-01-20 15:04:47','2026-01-20 15:04:47',1),(594,'54adca73-9204-4335-8f5e-a77f60750fc4','owner_project_name','tempest-TestShelveInstance-1425544575','2026-01-20 15:04:08','2026-01-20 15:04:47','2026-01-20 15:04:47',1),(595,'54adca73-9204-4335-8f5e-a77f60750fc4','boot_roles','member,reader','2026-01-20 15:04:08','2026-01-20 15:04:47','2026-01-20 15:04:47',1),(596,'54adca73-9204-4335-8f5e-a77f60750fc4','hw_machine_type','q35','2026-01-20 15:04:08','2026-01-20 15:04:47','2026-01-20 15:04:47',1),(597,'54adca73-9204-4335-8f5e-a77f60750fc4','hw_cdrom_bus','sata','2026-01-20 15:04:08','2026-01-20 15:04:47','2026-01-20 15:04:47',1),(598,'54adca73-9204-4335-8f5e-a77f60750fc4','hw_disk_bus','virtio','2026-01-20 15:04:08','2026-01-20 15:04:47','2026-01-20 15:04:47',1),(599,'54adca73-9204-4335-8f5e-a77f60750fc4','hw_input_bus','usb','2026-01-20 15:04:08','2026-01-20 15:04:47','2026-01-20 15:04:47',1),(600,'54adca73-9204-4335-8f5e-a77f60750fc4','hw_pointer_model','usbtablet','2026-01-20 15:04:08','2026-01-20 15:04:47','2026-01-20 15:04:47',1),(601,'54adca73-9204-4335-8f5e-a77f60750fc4','hw_video_model','virtio','2026-01-20 15:04:08','2026-01-20 15:04:47','2026-01-20 15:04:47',1),(602,'54adca73-9204-4335-8f5e-a77f60750fc4','hw_vif_model','virtio','2026-01-20 15:04:08','2026-01-20 15:04:47','2026-01-20 15:04:47',1),(603,'54adca73-9204-4335-8f5e-a77f60750fc4','instance_uuid','a0ce16c6-2b75-472f-a785-890fbb0d748e','2026-01-20 15:04:08','2026-01-20 15:04:47','2026-01-20 15:04:47',1),(604,'54adca73-9204-4335-8f5e-a77f60750fc4','user_id','b02a8ef6cc3946ceb2c8846aae2eae68','2026-01-20 15:04:08','2026-01-20 15:04:47','2026-01-20 15:04:47',1),(605,'54adca73-9204-4335-8f5e-a77f60750fc4','image_type','snapshot','2026-01-20 15:04:08','2026-01-20 15:04:47','2026-01-20 15:04:47',1),(606,'54adca73-9204-4335-8f5e-a77f60750fc4','image_state','available','2026-01-20 15:04:17','2026-01-20 15:04:47','2026-01-20 15:04:47',1),(607,'54adca73-9204-4335-8f5e-a77f60750fc4','image_location','snapshot','2026-01-20 15:04:17','2026-01-20 15:04:47','2026-01-20 15:04:47',1),(608,'54adca73-9204-4335-8f5e-a77f60750fc4','owner_id','0fc924d2df984301897e81920c5e192f','2026-01-20 15:04:17','2026-01-20 15:04:47','2026-01-20 15:04:47',1),(609,'7f0d068e-5d2b-485d-b65c-7244508ab6b6','hw_rescue_bus','virtio','2026-01-20 15:04:18','2026-01-20 15:05:00','2026-01-20 15:05:00',1),(610,'7f0d068e-5d2b-485d-b65c-7244508ab6b6','hw_rescue_device','disk','2026-01-20 15:04:18','2026-01-20 15:05:00','2026-01-20 15:05:00',1),(611,'8c970c65-2888-4da3-891e-c2b6eb3ea735','hw_rng_model','virtio','2026-01-20 15:06:01','2026-01-20 15:07:13','2026-01-20 15:07:13',1),(612,'8c970c65-2888-4da3-891e-c2b6eb3ea735','base_image_ref','a32b3e07-16d8-46fd-9a7b-c242c432fcf9','2026-01-20 15:06:01','2026-01-20 15:07:13','2026-01-20 15:07:13',1),(613,'8c970c65-2888-4da3-891e-c2b6eb3ea735','owner_user_name','tempest-TestStampPattern-487600181-project-member','2026-01-20 15:06:01','2026-01-20 15:07:13','2026-01-20 15:07:13',1),(614,'8c970c65-2888-4da3-891e-c2b6eb3ea735','owner_project_name','tempest-TestStampPattern-487600181','2026-01-20 15:06:01','2026-01-20 15:07:13','2026-01-20 15:07:13',1),(615,'8c970c65-2888-4da3-891e-c2b6eb3ea735','boot_roles','member,reader','2026-01-20 15:06:01','2026-01-20 15:07:13','2026-01-20 15:07:13',1),(616,'8c970c65-2888-4da3-891e-c2b6eb3ea735','hw_machine_type','q35','2026-01-20 15:06:01','2026-01-20 15:07:13','2026-01-20 15:07:13',1),(617,'8c970c65-2888-4da3-891e-c2b6eb3ea735','hw_cdrom_bus','sata','2026-01-20 15:06:01','2026-01-20 15:07:13','2026-01-20 15:07:13',1),(618,'8c970c65-2888-4da3-891e-c2b6eb3ea735','hw_disk_bus','virtio','2026-01-20 15:06:01','2026-01-20 15:07:13','2026-01-20 15:07:13',1),(619,'8c970c65-2888-4da3-891e-c2b6eb3ea735','hw_input_bus','usb','2026-01-20 15:06:01','2026-01-20 15:07:13','2026-01-20 15:07:13',1),(620,'8c970c65-2888-4da3-891e-c2b6eb3ea735','hw_pointer_model','usbtablet','2026-01-20 15:06:01','2026-01-20 15:07:13','2026-01-20 15:07:13',1),(621,'8c970c65-2888-4da3-891e-c2b6eb3ea735','hw_video_model','virtio','2026-01-20 15:06:01','2026-01-20 15:07:13','2026-01-20 15:07:13',1),(622,'8c970c65-2888-4da3-891e-c2b6eb3ea735','hw_vif_model','virtio','2026-01-20 15:06:01','2026-01-20 15:07:13','2026-01-20 15:07:13',1),(623,'8c970c65-2888-4da3-891e-c2b6eb3ea735','instance_uuid','33ba7a73-3233-40a3-a49a-e5bbd604dc3c','2026-01-20 15:06:01','2026-01-20 15:07:13','2026-01-20 15:07:13',1),(624,'8c970c65-2888-4da3-891e-c2b6eb3ea735','user_id','bc554998e71a4322bdd27ac727a9044c','2026-01-20 15:06:01','2026-01-20 15:07:13','2026-01-20 15:07:13',1),(625,'8c970c65-2888-4da3-891e-c2b6eb3ea735','image_type','snapshot','2026-01-20 15:06:01','2026-01-20 15:07:13','2026-01-20 15:07:13',1),(626,'8c970c65-2888-4da3-891e-c2b6eb3ea735','owner_id','e142d118583b4f9ba3531bcf3838e256','2026-01-20 15:06:05','2026-01-20 15:07:13','2026-01-20 15:07:13',1),(627,'8c970c65-2888-4da3-891e-c2b6eb3ea735','image_state','available','2026-01-20 15:06:05','2026-01-20 15:07:13','2026-01-20 15:07:13',1),(628,'8c970c65-2888-4da3-891e-c2b6eb3ea735','image_location','snapshot','2026-01-20 15:06:05','2026-01-20 15:07:13','2026-01-20 15:07:13',1),(629,'172aeba8-ca4a-4189-856b-42b685d4813d','signature_verified','False','2026-01-20 15:11:45','2026-01-20 15:12:47','2026-01-20 15:12:47',1),(630,'172aeba8-ca4a-4189-856b-42b685d4813d','hw_rng_model','virtio','2026-01-20 15:11:45','2026-01-20 15:12:47','2026-01-20 15:12:47',1),(631,'172aeba8-ca4a-4189-856b-42b685d4813d','base_image_ref','','2026-01-20 15:11:45','2026-01-20 15:12:47','2026-01-20 15:12:47',1),(632,'172aeba8-ca4a-4189-856b-42b685d4813d','owner_user_name','tempest-TestVolumeBootPattern-194644003-project-member','2026-01-20 15:11:45','2026-01-20 15:12:47','2026-01-20 15:12:47',1),(633,'172aeba8-ca4a-4189-856b-42b685d4813d','owner_project_name','tempest-TestVolumeBootPattern-194644003','2026-01-20 15:11:45','2026-01-20 15:12:47','2026-01-20 15:12:47',1),(634,'172aeba8-ca4a-4189-856b-42b685d4813d','boot_roles','reader,member','2026-01-20 15:11:45','2026-01-20 15:12:47','2026-01-20 15:12:47',1),(635,'172aeba8-ca4a-4189-856b-42b685d4813d','hw_machine_type','q35','2026-01-20 15:11:45','2026-01-20 15:12:47','2026-01-20 15:12:47',1),(636,'172aeba8-ca4a-4189-856b-42b685d4813d','hw_cdrom_bus','sata','2026-01-20 15:11:45','2026-01-20 15:12:47','2026-01-20 15:12:47',1),(637,'172aeba8-ca4a-4189-856b-42b685d4813d','hw_disk_bus','virtio','2026-01-20 15:11:45','2026-01-20 15:12:47','2026-01-20 15:12:47',1),(638,'172aeba8-ca4a-4189-856b-42b685d4813d','hw_input_bus','usb','2026-01-20 15:11:45','2026-01-20 15:12:47','2026-01-20 15:12:47',1),(639,'172aeba8-ca4a-4189-856b-42b685d4813d','hw_pointer_model','usbtablet','2026-01-20 15:11:45','2026-01-20 15:12:47','2026-01-20 15:12:47',1),(640,'172aeba8-ca4a-4189-856b-42b685d4813d','hw_video_model','virtio','2026-01-20 15:11:45','2026-01-20 15:12:47','2026-01-20 15:12:47',1),(641,'172aeba8-ca4a-4189-856b-42b685d4813d','hw_vif_model','virtio','2026-01-20 15:11:45','2026-01-20 15:12:47','2026-01-20 15:12:47',1),(642,'172aeba8-ca4a-4189-856b-42b685d4813d','root_device_name','/dev/vda','2026-01-20 15:11:45','2026-01-20 15:12:47','2026-01-20 15:12:47',1),(643,'172aeba8-ca4a-4189-856b-42b685d4813d','block_device_mapping','[{\"snapshot_id\": \"ac531e53-ece8-4166-8e41-ebb939119e9b\", \"destination_type\": \"volume\", \"encrypted\": null, \"encryption_options\": null, \"device_type\": \"disk\", \"no_device\": null, \"disk_bus\": \"virtio\", \"tag\": null, \"source_type\": \"snapshot\", \"encryption_format\": null, \"device_name\": \"/dev/vda\", \"volume_id\": null, \"delete_on_termination\": true, \"encryption_secret_uuid\": null, \"guest_format\": null, \"image_id\": null, \"volume_type\": null, \"volume_size\": 1, \"boot_index\": 0}]','2026-01-20 15:11:45','2026-01-20 15:12:47','2026-01-20 15:12:47',1),(644,'172aeba8-ca4a-4189-856b-42b685d4813d','bdm_v2','True','2026-01-20 15:11:45','2026-01-20 15:12:47','2026-01-20 15:12:47',1),(645,'446516df-d591-4d87-84ee-415617f85cc0','signature_verified','False','2026-01-20 15:17:15','2026-01-20 15:17:27','2026-01-20 15:17:27',1),(646,'446516df-d591-4d87-84ee-415617f85cc0','hw_rng_model','virtio','2026-01-20 15:17:15','2026-01-20 15:17:27','2026-01-20 15:17:27',1),(647,'446516df-d591-4d87-84ee-415617f85cc0','base_image_ref','','2026-01-20 15:17:15','2026-01-20 15:17:27','2026-01-20 15:17:27',1),(648,'446516df-d591-4d87-84ee-415617f85cc0','owner_user_name','tempest-AttachVolumeMultiAttachTest-418194625-project-member','2026-01-20 15:17:15','2026-01-20 15:17:27','2026-01-20 15:17:27',1),(649,'446516df-d591-4d87-84ee-415617f85cc0','owner_project_name','tempest-AttachVolumeMultiAttachTest-418194625','2026-01-20 15:17:15','2026-01-20 15:17:27','2026-01-20 15:17:27',1),(650,'446516df-d591-4d87-84ee-415617f85cc0','boot_roles','reader,member','2026-01-20 15:17:15','2026-01-20 15:17:27','2026-01-20 15:17:27',1),(651,'446516df-d591-4d87-84ee-415617f85cc0','hw_machine_type','q35','2026-01-20 15:17:15','2026-01-20 15:17:27','2026-01-20 15:17:27',1),(652,'446516df-d591-4d87-84ee-415617f85cc0','hw_cdrom_bus','sata','2026-01-20 15:17:15','2026-01-20 15:17:27','2026-01-20 15:17:27',1),(653,'446516df-d591-4d87-84ee-415617f85cc0','hw_disk_bus','virtio','2026-01-20 15:17:15','2026-01-20 15:17:27','2026-01-20 15:17:27',1),(654,'446516df-d591-4d87-84ee-415617f85cc0','hw_input_bus','usb','2026-01-20 15:17:15','2026-01-20 15:17:27','2026-01-20 15:17:27',1),(655,'446516df-d591-4d87-84ee-415617f85cc0','hw_pointer_model','usbtablet','2026-01-20 15:17:15','2026-01-20 15:17:27','2026-01-20 15:17:27',1),(656,'446516df-d591-4d87-84ee-415617f85cc0','hw_video_model','virtio','2026-01-20 15:17:15','2026-01-20 15:17:27','2026-01-20 15:17:27',1),(657,'446516df-d591-4d87-84ee-415617f85cc0','hw_vif_model','virtio','2026-01-20 15:17:15','2026-01-20 15:17:27','2026-01-20 15:17:27',1),(658,'446516df-d591-4d87-84ee-415617f85cc0','root_device_name','/dev/vda','2026-01-20 15:17:15','2026-01-20 15:17:27','2026-01-20 15:17:27',1),(659,'446516df-d591-4d87-84ee-415617f85cc0','block_device_mapping','[{\"guest_format\": null, \"encryption_options\": null, \"source_type\": \"snapshot\", \"snapshot_id\": \"e76b9e34-4947-4eda-aa6f-85b2f7ae7aea\", \"encryption_secret_uuid\": null, \"delete_on_termination\": false, \"no_device\": null, \"encryption_format\": null, \"volume_type\": null, \"volume_size\": 1, \"device_type\": \"disk\", \"destination_type\": \"volume\", \"device_name\": \"/dev/vda\", \"disk_bus\": \"virtio\", \"boot_index\": 0, \"image_id\": null, \"encrypted\": null, \"volume_id\": null, \"tag\": null}]','2026-01-20 15:17:15','2026-01-20 15:17:27','2026-01-20 15:17:27',1),(660,'446516df-d591-4d87-84ee-415617f85cc0','bdm_v2','True','2026-01-20 15:17:15','2026-01-20 15:17:27','2026-01-20 15:17:27',1);
/*!40000 ALTER TABLE `image_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_tags`
--

DROP TABLE IF EXISTS `image_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_tags_image_id` (`image_id`),
  KEY `ix_image_tags_image_id_tag_value` (`image_id`,`value`),
  CONSTRAINT `image_tags_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_tags`
--

LOCK TABLES `image_tags` WRITE;
/*!40000 ALTER TABLE `image_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `disk_format` varchar(20) DEFAULT NULL,
  `container_format` varchar(20) DEFAULT NULL,
  `checksum` varchar(32) DEFAULT NULL,
  `owner` varchar(255) DEFAULT NULL,
  `min_disk` int(11) NOT NULL,
  `min_ram` int(11) NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT 0,
  `virtual_size` bigint(20) DEFAULT NULL,
  `visibility` enum('private','public','shared','community') NOT NULL DEFAULT 'shared',
  `os_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `os_hash_algo` varchar(64) DEFAULT NULL,
  `os_hash_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checksum_image_idx` (`checksum`),
  KEY `ix_images_deleted` (`deleted`),
  KEY `owner_image_idx` (`owner`),
  KEY `created_at_image_idx` (`created_at`),
  KEY `updated_at_image_idx` (`updated_at`),
  KEY `visibility_image_idx` (`visibility`),
  KEY `os_hidden_image_idx` (`os_hidden`),
  KEY `os_hash_value_image_idx` (`os_hash_value`),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`protected` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` (`id`, `name`, `size`, `status`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `disk_format`, `container_format`, `checksum`, `owner`, `min_disk`, `min_ram`, `protected`, `virtual_size`, `visibility`, `os_hidden`, `os_hash_algo`, `os_hash_value`) VALUES ('041ed532-ca1e-46fd-bdf4-eb2674a7c406','tempest-backup-1-1242695016',NULL,'deleted','2026-01-20 14:54:58','2026-01-20 14:55:00','2026-01-20 14:55:00',1,'qcow2','bare',NULL,'45810a5a04b6407f90b37499538f63ba',1,0,0,NULL,'private',0,NULL,NULL),('099d94f6-c2d2-4c82-ab5e-5cf0c5d78fac','tempest-scenario-img--1111569377',21430272,'deleted','2026-01-20 14:57:16','2026-01-20 15:00:10','2026-01-20 15:00:10',1,'qcow2','bare','c8fc807773e5354afe61636071771906','107c1f3b5b7b413d9a389ca1166e331f',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('0db5d54c-c1b5-4100-80fe-c616a5483520','tempest-UnshelveToHostMultiNodesTest-server-767584007-shelved',1073741824,'deleted','2026-01-20 14:26:03','2026-01-20 14:26:47','2026-01-20 14:26:47',1,'raw','bare',NULL,'14ebcff06a484899a9725832f1eddfdf',1,0,0,NULL,'private',0,NULL,NULL),('0f1d91a7-05af-4ed6-87af-1e03976e25f0','tempest-AttachVolumeShelveTestJSON-server-913712707-shelved',1073741824,'deleted','2026-01-20 14:55:18','2026-01-20 14:55:50','2026-01-20 14:55:50',1,'raw','bare',NULL,'b1e83af992c94112a965575784639d77',1,0,0,NULL,'private',0,NULL,NULL),('132a812e-f4a2-4a8b-813d-1df62e09798a','tempest-ServerStableDeviceRescueTest-image-381954221',1073741824,'deleted','2026-01-20 14:53:31','2026-01-20 14:54:33','2026-01-20 14:54:33',1,'raw','bare',NULL,'0a29915e0dd2403fbd7b7e847696b00a',1,0,0,NULL,'private',0,NULL,NULL),('165549fb-68ff-4d9c-ab65-c85189d23d7d','tempest-backup-1-1212497161',1073741824,'deleted','2026-01-20 14:52:34','2026-01-20 14:53:07','2026-01-20 14:53:07',1,'raw','bare',NULL,'b3b1b7f5b4f84b5abbc401eb577c85c0',1,0,0,NULL,'private',0,NULL,NULL),('172aeba8-ca4a-4189-856b-42b685d4813d','tempest-TestVolumeBootPatternsnapshot-431707316',0,'deleted','2026-01-20 15:11:45','2026-01-20 15:12:47','2026-01-20 15:12:47',1,'qcow2','bare','d41d8cd98f00b204e9800998ecf8427e','a49638950e1543fa8e0d251af5479623',1,0,0,NULL,'private',0,'sha512','cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e'),('17b86a15-4cdb-41f2-82a9-c343b2420f69','tempest-₡-713291422',1073741824,'deleted','2026-01-20 14:36:12','2026-01-20 14:36:23','2026-01-20 14:36:23',1,'raw','bare',NULL,'79601368a3db41e0aacec93e8fd7f1d4',1,0,0,NULL,'private',0,NULL,NULL),('1f2389f5-ba66-4c2e-9f07-9051cd05b976','tempest-ServerActionsTestOtherB-server-1938504336-shelved',1073741824,'deleted','2026-01-20 14:57:04','2026-01-20 14:57:33','2026-01-20 14:57:33',1,'raw','bare',NULL,'b3b1b7f5b4f84b5abbc401eb577c85c0',1,0,0,NULL,'private',0,NULL,NULL),('20f02a0e-ef11-4157-9d07-37674d1e0ea8','tempest-DeleteServersTestJSON-server-579419372-shelved',1073741824,'deleted','2026-01-20 14:45:22','2026-01-20 14:45:57','2026-01-20 14:45:57',1,'raw','bare',NULL,'3b31139b2a4e49cba5e7048febf901c4',1,0,0,NULL,'private',0,NULL,NULL),('26699514-f465-4b50-98b7-36f2cfc6a308','cirros-0.6.2-x86_64-disk.img_alt',21430272,'active','2026-01-20 14:22:02','2026-01-20 14:22:04',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','4e7b863e1a5b4a8bb85e8466fecb8db2',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('446516df-d591-4d87-84ee-415617f85cc0','multiattach-snapshot',0,'deleted','2026-01-20 15:17:15','2026-01-20 15:17:27','2026-01-20 15:17:27',1,'qcow2','bare','d41d8cd98f00b204e9800998ecf8427e','fff727019f86407498e83d7948d54962',1,0,0,NULL,'private',0,'sha512','cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e'),('54adca73-9204-4335-8f5e-a77f60750fc4','tempest-TestShelveInstance-server-1036076849-shelved',1073741824,'deleted','2026-01-20 15:04:08','2026-01-20 15:04:47','2026-01-20 15:04:47',1,'raw','bare',NULL,'0fc924d2df984301897e81920c5e192f',1,0,0,NULL,'private',0,NULL,NULL),('5b64c953-6df3-45a3-ae28-e419ba117bb2','tempest-scenario-img--310583103',21430272,'deleted','2026-01-20 15:08:29','2026-01-20 15:09:44','2026-01-20 15:09:44',1,'qcow2','bare','c8fc807773e5354afe61636071771906','5b43342be22543f79d4a56e26c6d0c96',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('606f74dc-79ac-4b4e-b154-695b258203bd','tempest-ListImageFiltersTestJSON-image-1118312356',1073741824,'deleted','2026-01-20 14:35:21','2026-01-20 14:35:37','2026-01-20 14:35:37',1,'raw','bare',NULL,'9e10f687e8a14fc3bfa98df19df5befd',1,0,0,NULL,'private',0,NULL,NULL),('656ef5b8-a536-420e-a7a3-850a33da38a8','tempest-test-snap-1883561535',1073741824,'deleted','2026-01-20 14:35:32','2026-01-20 14:35:40','2026-01-20 14:35:40',1,'raw','bare',NULL,'3750c56415134773aa9d9880038f1749',1,0,0,NULL,'private',0,NULL,NULL),('6e97db8b-a462-4791-9edf-594ed0f547e6','tempest-AttachVolumeShelveTestJSON-server-1885581249-shelved',1073741824,'deleted','2026-01-20 14:53:44','2026-01-20 14:54:14','2026-01-20 14:54:14',1,'raw','bare',NULL,'b1e83af992c94112a965575784639d77',1,0,0,NULL,'private',0,NULL,NULL),('6fa40815-d8ae-463b-8e43-fe8a8d4374e5','tempest-ServerActionsTestOtherB-server-24332407-shelved',1073741824,'deleted','2026-01-20 14:56:46','2026-01-20 14:57:38','2026-01-20 14:57:38',1,'raw','bare',NULL,'b3b1b7f5b4f84b5abbc401eb577c85c0',1,0,0,NULL,'private',0,NULL,NULL),('70955243-a059-4d15-b65b-03ec50f95c21','tempest-ListImageFiltersTestJSON-image-1008248209',1073741824,'deleted','2026-01-20 14:35:05','2026-01-20 14:35:39','2026-01-20 14:35:39',1,'raw','bare',NULL,'9e10f687e8a14fc3bfa98df19df5befd',1,0,0,NULL,'private',0,NULL,NULL),('71863f13-4d5e-4ff6-bbc9-d5be0e9690ff','tempest-test-snap-818487529',1073741824,'deleted','2026-01-20 14:36:03','2026-01-20 14:36:12','2026-01-20 14:36:12',1,'raw','bare',NULL,'3750c56415134773aa9d9880038f1749',1,0,0,NULL,'private',0,NULL,NULL),('742404f3-b52a-4648-b775-447fbe30a8ba','tempest-image-1760529640',1881,'deleted','2026-01-20 14:33:19','2026-01-20 14:33:25','2026-01-20 14:33:25',1,'qcow2','bare','1a3b358da263fe2810b7a9b97676b5c9','e087e1247ad849ec88b44c95ca0a443c',0,129,0,NULL,'private',0,'sha512','676ceb60c679a3cc268ebb6137a55e3ee2771d430595c2f2795f58ea3469d25ae005ca2f3775ee455d269fca13c71b263419cd9245c5a1e1d1068c62f5fbad91'),('74b6b72a-3e89-4e91-95cd-b3413cc32773','tempest-test-snap-743414580',1073741824,'deleted','2026-01-20 14:34:44','2026-01-20 14:34:52','2026-01-20 14:34:52',1,'raw','bare',NULL,'3750c56415134773aa9d9880038f1749',1,0,0,NULL,'private',0,NULL,NULL),('7586ccfe-36ea-40bd-b70d-ce54b80b5faa','tempest-ServerStableDeviceRescueTest-image-905845641',1073741824,'deleted','2026-01-20 14:50:33','2026-01-20 14:54:53','2026-01-20 14:54:53',1,'raw','bare',NULL,'0a29915e0dd2403fbd7b7e847696b00a',1,0,0,NULL,'private',0,NULL,NULL),('7f0d068e-5d2b-485d-b65c-7244508ab6b6','tempest-ServerBootFromVolumeStableRescueTest-image-1525366758',1073741824,'deleted','2026-01-20 15:03:27','2026-01-20 15:05:00','2026-01-20 15:05:00',1,'raw','bare',NULL,'63555e5851564db08c6429231d264f2c',1,0,0,NULL,'private',0,NULL,NULL),('8243602f-b497-404e-8582-5eabf284cdfc','tempest-ListImageFiltersTestJSON-image-976732690',1024,'deleted','2026-01-20 14:34:52','2026-01-20 14:35:49','2026-01-20 14:35:49',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','9e10f687e8a14fc3bfa98df19df5befd',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('8976571c-92ae-42ce-94dd-a05ec6e308b3','tempest-ServersNegativeTestJSON-server-1098898119-shelved',1073741824,'deleted','2026-01-20 15:00:42','2026-01-20 15:01:23','2026-01-20 15:01:23',1,'raw','bare',NULL,'105e56abe3804424885c7aa8d1216d12',1,0,0,NULL,'private',0,NULL,NULL),('89cb760a-362a-4b7a-b627-ed8e6a5c1479','tempest-ListImageFiltersTestJSON-image-840834340',1024,'deleted','2026-01-20 14:34:46','2026-01-20 14:35:52','2026-01-20 14:35:52',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','9e10f687e8a14fc3bfa98df19df5befd',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('8c970c65-2888-4da3-891e-c2b6eb3ea735','tempest-TestStampPatternsnapshot-189036364',1073741824,'deleted','2026-01-20 15:06:01','2026-01-20 15:07:13','2026-01-20 15:07:13',1,'raw','bare',NULL,'e142d118583b4f9ba3531bcf3838e256',1,0,0,NULL,'private',0,NULL,NULL),('97fb0fa0-6803-480b-96d2-4a219153376d','tempest-TestSnapshotPatternsnapshot-539580309',1073741824,'deleted','2026-01-20 15:02:18','2026-01-20 15:03:40','2026-01-20 15:03:40',1,'raw','bare',NULL,'3a1d679d5c954662a271e842fe2f2c05',1,0,0,NULL,'private',0,NULL,NULL),('9b402b85-ed3a-4c51-8c4a-aeeda86dfa7c','tempest-UnshelveToHostMultiNodesTest-server-767584007-shelved',1073741824,'deleted','2026-01-20 14:25:27','2026-01-20 14:26:01','2026-01-20 14:26:01',1,'raw','bare',NULL,'14ebcff06a484899a9725832f1eddfdf',1,0,0,NULL,'private',0,NULL,NULL),('9c1c8ad1-376e-4dd8-93d8-70f0aa412977','tempest-ServerBootFromVolumeStableRescueTest-image-645608787',1073741824,'deleted','2026-01-20 15:01:31','2026-01-20 15:05:18','2026-01-20 15:05:18',1,'raw','bare',NULL,'63555e5851564db08c6429231d264f2c',1,0,0,NULL,'private',0,NULL,NULL),('a1d1cbcb-c6a5-49c9-8868-06c3872a40d2','tempest-ServerStableDeviceRescueTest-image-505033824',1073741824,'deleted','2026-01-20 14:52:05','2026-01-20 14:54:41','2026-01-20 14:54:41',1,'raw','bare',NULL,'0a29915e0dd2403fbd7b7e847696b00a',1,0,0,NULL,'private',0,NULL,NULL),('a32b3e07-16d8-46fd-9a7b-c242c432fcf9','cirros-0.6.2-x86_64-disk.img',21430272,'active','2026-01-20 14:21:57','2026-01-20 14:22:01',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','4e7b863e1a5b4a8bb85e8466fecb8db2',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('a619a5a5-7b38-4a60-af81-76a595f37563','tempest-test-snap-2051084242',NULL,'deleted','2026-01-20 14:37:24','2026-01-20 14:37:26','2026-01-20 14:37:26',1,NULL,NULL,NULL,'3750c56415134773aa9d9880038f1749',1,0,0,NULL,'private',0,NULL,NULL),('ae5aa156-02f2-4cbe-8c3c-a41c7fd78b5c','tempest-ServerStableDeviceRescueTest-image-1670184042',1073741824,'deleted','2026-01-20 14:51:25','2026-01-20 14:54:48','2026-01-20 14:54:48',1,'raw','bare',NULL,'0a29915e0dd2403fbd7b7e847696b00a',1,0,0,NULL,'private',0,NULL,NULL),('afa12d53-6955-4be8-8dd3-8e7dd18a3d5b',NULL,21430272,'deleted','2026-01-20 14:27:31','2026-01-20 14:28:31','2026-01-20 14:28:31',1,'qcow2','bare','c8fc807773e5354afe61636071771906','64772ad8e43048d89873964617706532',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('bf636010-1d3c-4028-9e00-bc1bb08e7dca','tempest-backup-3-556519559',1073741824,'deleted','2026-01-20 14:52:59','2026-01-20 14:53:11','2026-01-20 14:53:11',1,'raw','bare',NULL,'b3b1b7f5b4f84b5abbc401eb577c85c0',1,0,0,NULL,'private',0,NULL,NULL),('c6ead139-3a05-4d56-8181-f09e7d084275','tempest-ListImageFiltersTestJSON-image-1804792381',1073741824,'deleted','2026-01-20 14:35:13','2026-01-20 14:35:38','2026-01-20 14:35:38',1,'raw','bare',NULL,'9e10f687e8a14fc3bfa98df19df5befd',1,0,0,NULL,'private',0,NULL,NULL),('d6eb065b-6bd9-4a87-ab49-a63678d86cff','tempest-ImagesOneServerNegativeTestJSON-image-853018464',NULL,'deleted','2026-01-20 14:37:40','2026-01-20 14:37:41','2026-01-20 14:37:41',1,NULL,NULL,NULL,'7d78990d13704d629a8a3e8910d005c5',1,0,0,NULL,'private',0,NULL,NULL),('d81709b0-d34f-4017-a47c-7ee2d9a8bd84','tempest-ImagesOneServerNegativeTestJSON-image-141126531',NULL,'deleted','2026-01-20 14:37:08','2026-01-20 14:37:09','2026-01-20 14:37:09',1,NULL,NULL,NULL,'7d78990d13704d629a8a3e8910d005c5',1,0,0,NULL,'private',0,NULL,NULL),('d9608a6b-abac-47e3-a9dd-70a6230a92c0','tempest-test-snap-969462570',1073741824,'deleted','2026-01-20 14:36:30','2026-01-20 14:37:07','2026-01-20 14:37:07',1,'raw','bare',NULL,'3750c56415134773aa9d9880038f1749',1,0,0,NULL,'private',0,NULL,NULL),('d9e08301-4600-4321-b633-e7777cc1e842','tempest-backup-2-431078193',1073741824,'deleted','2026-01-20 14:52:47','2026-01-20 14:53:13','2026-01-20 14:53:13',1,'raw','bare',NULL,'b3b1b7f5b4f84b5abbc401eb577c85c0',1,0,0,NULL,'private',0,NULL,NULL),('da03482c-d942-4ea0-90cf-c59249a144d3','tempest-image-1179533257',1024,'deleted','2026-01-20 14:34:37','2026-01-20 14:34:57','2026-01-20 14:34:57',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','b4a391a5c99b46fd8fc105b125ed5058',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('f0498d09-bfa2-4660-8970-6d771b829afc','tempest-ListImageFiltersTestJSON-image-1875728895',1024,'deleted','2026-01-20 14:34:49','2026-01-20 14:35:51','2026-01-20 14:35:51',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','9e10f687e8a14fc3bfa98df19df5befd',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('f6b86f20-6a27-42dc-9911-14ae5e0ee2dc','tempest-scenario-img--1212854051',21430272,'deleted','2026-01-20 15:09:44','2026-01-20 15:11:21','2026-01-20 15:11:21',1,'qcow2','bare','c8fc807773e5354afe61636071771906','5b43342be22543f79d4a56e26c6d0c96',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('fba3fdca-b283-4008-bac5-0575a6416bc7','tempest-image-1726326817',1073741824,'deleted','2026-01-20 14:35:59','2026-01-20 14:36:11','2026-01-20 14:36:11',1,'raw','bare',NULL,'79601368a3db41e0aacec93e8fd7f1d4',1,0,0,NULL,'private',0,NULL,NULL),('fc0edfd5-d120-40a0-889d-d3576a58edb6','tempest-TestSnapshotPatternsnapshot-1241856246',1073741824,'deleted','2026-01-20 15:03:16','2026-01-20 15:03:24','2026-01-20 15:03:24',1,'raw','bare',NULL,'3a1d679d5c954662a271e842fe2f2c05',1,0,0,NULL,'private',0,NULL,NULL);
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespace_resource_types`
--

DROP TABLE IF EXISTS `metadef_namespace_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespace_resource_types` (
  `resource_type_id` int(11) NOT NULL,
  `namespace_id` int(11) NOT NULL,
  `properties_target` varchar(80) DEFAULT NULL,
  `prefix` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`resource_type_id`,`namespace_id`),
  KEY `ix_metadef_ns_res_types_namespace_id` (`namespace_id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_2` FOREIGN KEY (`resource_type_id`) REFERENCES `metadef_resource_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespace_resource_types`
--

LOCK TABLES `metadef_namespace_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_namespace_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_namespace_resource_types` (`resource_type_id`, `namespace_id`, `properties_target`, `prefix`, `created_at`, `updated_at`) VALUES (1,1,'image','CIM_PASD_','2026-01-20 13:41:12',NULL),(1,2,'image','CIM_RASD_','2026-01-20 13:41:13',NULL),(1,3,NULL,'CIM_SASD_','2026-01-20 13:41:13',NULL),(1,9,'image','hw_','2026-01-20 13:41:14',NULL),(1,10,'image','hw_','2026-01-20 13:41:14',NULL),(1,14,'image',NULL,'2026-01-20 13:41:15',NULL),(1,19,'image','hw_','2026-01-20 13:41:17',NULL),(1,25,'image','hw_','2026-01-20 13:41:18',NULL),(1,29,'image',NULL,'2026-01-20 13:41:19',NULL),(1,30,'image',NULL,'2026-01-20 13:41:19',NULL),(1,31,'image',NULL,'2026-01-20 13:41:19',NULL),(1,32,'image',NULL,'2026-01-20 13:41:19',NULL),(2,1,NULL,'CIM_PASD_','2026-01-20 13:41:12',NULL),(2,8,NULL,'hw_','2026-01-20 13:41:14',NULL),(2,9,NULL,'hw_','2026-01-20 13:41:14',NULL),(2,10,NULL,'hw_','2026-01-20 13:41:14',NULL),(2,11,NULL,NULL,'2026-01-20 13:41:14',NULL),(2,13,NULL,NULL,'2026-01-20 13:41:14',NULL),(2,14,NULL,NULL,'2026-01-20 13:41:15',NULL),(2,15,NULL,NULL,'2026-01-20 13:41:15',NULL),(2,16,NULL,'hw_','2026-01-20 13:41:16',NULL),(2,19,NULL,'hw_','2026-01-20 13:41:17',NULL),(2,22,NULL,NULL,'2026-01-20 13:41:17',NULL),(2,23,NULL,'hw_','2026-01-20 13:41:18',NULL),(2,24,NULL,'traits:','2026-01-20 13:41:18',NULL),(2,25,NULL,'hw_','2026-01-20 13:41:18',NULL),(2,26,NULL,NULL,'2026-01-20 13:41:18',NULL),(2,28,NULL,NULL,'2026-01-20 13:41:19',NULL),(2,29,NULL,NULL,'2026-01-20 13:41:19',NULL),(2,30,NULL,NULL,'2026-01-20 13:41:19',NULL),(2,31,NULL,NULL,'2026-01-20 13:41:19',NULL),(2,32,NULL,NULL,'2026-01-20 13:41:19',NULL),(2,33,NULL,'cinder_','2026-01-20 13:41:19',NULL),(3,1,NULL,'CIM_PASD_','2026-01-20 13:41:13',NULL),(3,2,NULL,'CIM_RASD_','2026-01-20 13:41:13',NULL),(3,3,NULL,'CIM_SASD_','2026-01-20 13:41:13',NULL),(3,4,NULL,'CIM_VSSD_','2026-01-20 13:41:13',NULL),(3,5,NULL,NULL,'2026-01-20 13:41:14',NULL),(3,6,NULL,NULL,'2026-01-20 13:41:14',NULL),(3,7,NULL,NULL,'2026-01-20 13:41:14',NULL),(3,12,NULL,'aggregate_instance_extra_specs:','2026-01-20 13:41:14',NULL),(4,1,NULL,'CIM_PASD_','2026-01-20 13:41:13',NULL),(4,2,NULL,'CIM_RASD_','2026-01-20 13:41:13',NULL),(4,3,NULL,'CIM_SASD_','2026-01-20 13:41:13',NULL),(4,4,NULL,'CIM_VSSD_','2026-01-20 13:41:13',NULL),(4,8,NULL,'hw:','2026-01-20 13:41:14',NULL),(4,9,NULL,'hw:','2026-01-20 13:41:14',NULL),(4,10,NULL,'hw:','2026-01-20 13:41:14',NULL),(4,12,NULL,'capabilities:','2026-01-20 13:41:14',NULL),(4,16,NULL,'hw:','2026-01-20 13:41:16',NULL),(4,17,NULL,NULL,'2026-01-20 13:41:16',NULL),(4,18,NULL,NULL,'2026-01-20 13:41:17',NULL),(4,19,NULL,'hw:','2026-01-20 13:41:17',NULL),(4,20,NULL,NULL,'2026-01-20 13:41:17',NULL),(4,21,NULL,NULL,'2026-01-20 13:41:17',NULL),(4,23,NULL,'hw:','2026-01-20 13:41:18',NULL),(4,24,NULL,'traits:','2026-01-20 13:41:18',NULL),(4,25,NULL,'hw:','2026-01-20 13:41:18',NULL),(5,1,'scheduler_hints',NULL,'2026-01-20 13:41:13',NULL),(5,30,'metadata',NULL,'2026-01-20 13:41:19',NULL),(5,31,'metadata',NULL,'2026-01-20 13:41:19',NULL),(5,32,'metadata',NULL,'2026-01-20 13:41:19',NULL),(6,30,NULL,NULL,'2026-01-20 13:41:19',NULL);
/*!40000 ALTER TABLE `metadef_namespace_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespaces`
--

DROP TABLE IF EXISTS `metadef_namespaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespaces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace` varchar(80) NOT NULL,
  `display_name` varchar(80) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `visibility` varchar(32) DEFAULT NULL,
  `protected` tinyint(1) DEFAULT NULL,
  `owner` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_namespaces_namespace` (`namespace`),
  KEY `ix_metadef_namespaces_owner` (`owner`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespaces`
--

LOCK TABLES `metadef_namespaces` WRITE;
/*!40000 ALTER TABLE `metadef_namespaces` DISABLE KEYS */;
INSERT INTO `metadef_namespaces` (`id`, `namespace`, `display_name`, `description`, `visibility`, `protected`, `owner`, `created_at`, `updated_at`) VALUES (1,'CIM::ProcessorAllocationSettingData','CIM Processor Allocation Setting','Properties related to the resource allocation settings of a processor (CPU) from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These are properties that identify processor setting data and may be specified to volume, image, host aggregate, flavor and Nova server as scheduler hint. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ProcessorAllocationSettingData.html.','public',1,'admin','2026-01-20 13:41:09',NULL),(2,'CIM::ResourceAllocationSettingData','CIM Resource Allocation Setting Data','Properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim) that represent settings specifically related to an allocated resource that are outside the scope of the CIM class typically used to represent the resource itself. These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ResourceAllocationSettingData.html.','public',1,'admin','2026-01-20 13:41:13',NULL),(3,'CIM::StorageAllocationSettingData','CIM Storage Allocation Setting Data','Properties related to the allocation of virtual storage from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_StorageAllocationSettingData.html.','public',1,'admin','2026-01-20 13:41:13',NULL),(4,'CIM::VirtualSystemSettingData','CIM Virtual System Setting Data','A set of virtualization specific properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim), which define the virtual aspects of a virtual system. These properties may be specified to host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_VirtualSystemSettingData.html.','public',1,'admin','2026-01-20 13:41:13',NULL),(5,'OS::Compute::AggregateDiskFilter','Disk Allocation per Host','Properties related to the Nova scheduler filter AggregateDiskFilter. Filters aggregate hosts based on the available disk space compared to the requested disk space. Hosts in the aggregate with not enough usable disk will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2026-01-20 13:41:14',NULL),(6,'OS::Compute::AggregateIoOpsFilter','IO Ops per Host','Properties related to the Nova scheduler filter AggregateIoOpsFilter. Filters aggregate hosts based on the number of instances currently changing state. Hosts in the aggregate with too many instances changing state will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2026-01-20 13:41:14',NULL),(7,'OS::Compute::AggregateNumInstancesFilter','Instances per Host','Properties related to the Nova scheduler filter AggregateNumInstancesFilter. Filters aggregate hosts by the number of running instances on it. Hosts in the aggregate with too many instances will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',0,'admin','2026-01-20 13:41:14',NULL),(8,'OS::Compute::CPUMode','CPU Mode','This provides the preferred CPU Model to be used when booting up a guest VM.','public',NULL,'admin','2026-01-20 13:41:14',NULL),(9,'OS::Compute::CPUPinning','CPU Pinning','This provides the preferred CPU pinning and CPU thread pinning policy to be used when pinning vCPU of the guest to pCPU of the host. See http://docs.openstack.org/admin-guide/compute-numa-cpu-pinning.html','public',1,'admin','2026-01-20 13:41:14',NULL),(10,'OS::Compute::GuestMemoryBacking','Guest Memory Backing','This provides the preferred backing option for guest RAM. Guest\'s memory can be backed by hugepages to limit TLB lookups. See also: https://wiki.openstack.org/wiki/VirtDriverGuestCPUMemoryPlacement','public',1,'admin','2026-01-20 13:41:14',NULL),(11,'OS::Compute::GuestShutdownBehavior','Shutdown Behavior','These properties allow modifying the shutdown behavior for stop, rescue, resize, and shelve operations.','public',1,'admin','2026-01-20 13:41:14',NULL),(12,'OS::Compute::HostCapabilities','Compute Host Capabilities','Hardware capabilities provided by the compute host. This provides the ability to fine tune the hardware specification required when an instance is requested. The ComputeCapabilitiesFilter should be enabled in the Nova scheduler to use these properties. When enabled, this filter checks that the capabilities provided by the compute host satisfy any extra specifications requested. Only hosts that can provide the requested capabilities will be eligible for hosting the instance.','public',1,'admin','2026-01-20 13:41:14',NULL),(13,'OS::Compute::Hypervisor','Hypervisor Selection','OpenStack Compute supports many hypervisors, although most installations use only one hypervisor. For installations with multiple supported hypervisors, you can schedule different hypervisors using the ImagePropertiesFilter. This filters compute nodes that satisfy any architecture, hypervisor type, or virtual machine mode properties specified on the instance\'s image properties.','public',1,'admin','2026-01-20 13:41:14',NULL),(14,'OS::Compute::InstanceData','Instance Config Data','Instances can perform self-configuration based on data made available to the running instance. These properties affect instance configuration.','public',1,'admin','2026-01-20 13:41:15',NULL),(15,'OS::Compute::LibvirtImage','libvirt Driver Options for Images','The libvirt Compute Driver Options for Glance Images.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-20 13:41:15',NULL),(16,'OS::Compute::Libvirt','libvirt Driver Options','The libvirt compute driver options.  \n\nThese are properties that affect the libvirt compute driver and may be specified on flavors and images.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-20 13:41:16',NULL),(17,'OS::Compute::Quota','Flavor Quota','Compute drivers may enable quotas on CPUs available to a VM, disk tuning, bandwidth I/O, and instance VIF traffic control.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-20 13:41:16',NULL),(18,'OS::Compute::RandomNumberGenerator','Random Number Generator','If a random-number generator device has been added to the instance through its image properties, the device can be enabled and configured.','public',1,'admin','2026-01-20 13:41:16',NULL),(19,'OS::Compute::VirtCPUTopology','Virtual CPU Topology','This provides the preferred socket/core/thread counts for the virtual CPU instance exposed to guests. This enables the ability to avoid hitting limitations on vCPU topologies that OS vendors place on their products. See also: https://opendev.org/openstack/nova-specs/src/branch/master/specs/juno/implemented/virt-driver-vcpu-topology.rst','public',1,'admin','2026-01-20 13:41:17',NULL),(20,'OS::Compute::VMwareFlavor','VMware Driver Options for Flavors','VMware Driver Options for Flavors may be used to customize and manage Nova Flavors. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-20 13:41:17',NULL),(21,'OS::Compute::VMwareQuotaFlavor','VMware Quota for Flavors','The VMware compute driver allows various compute quotas to be specified on flavors. When specified, the VMWare driver will ensure that the quota is enforced. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. For a list of hypervisors, see: https://wiki.openstack.org/wiki/HypervisorSupportMatrix. For flavor customization, see: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-20 13:41:17',NULL),(22,'OS::Compute::VMware','VMware Driver Options','The VMware compute driver options.  \n\nThese are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-20 13:41:17',NULL),(23,'OS::Compute::TPM','TPM Options','Configuration options for TPM','public',1,'admin','2026-01-20 13:41:17',NULL),(24,'OS::Compute::VTPM','Emulated Virtual TPM','Configuration options for Emulated Virtual TPM','public',1,'admin','2026-01-20 13:41:18',NULL),(25,'OS::Compute::Watchdog','Watchdog Behavior','Compute drivers may enable watchdog behavior over instances.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-20 13:41:18',NULL),(26,'OS::Compute::XenAPI','XenAPI Driver Options','The XenAPI compute driver options.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-20 13:41:18',NULL),(27,'OS::Glance::CommonImageProperties','Common Image Properties','When adding an image to Glance, you may specify some common image properties that may prove useful to consumers of your image.',NULL,1,'admin','2026-01-20 13:41:18',NULL),(28,'OS::Glance::Signatures','Image Signature Verification','Image signature verification allows the user to verify that an image has not been modified prior to booting the image.','public',0,'admin','2026-01-20 13:41:19',NULL),(29,'OS::OperatingSystem','Common Operating System Properties','Details of the operating system contained within this image as well as common operating system properties that can be set on a VM instance created from this image.',NULL,1,'admin','2026-01-20 13:41:19',NULL),(30,'OS::Software::DBMS','Database Software','A database is an organized collection of data. The data is typically organized to model aspects of reality in a way that supports processes requiring information. Database management systems are computer software applications that interact with the user, other applications, and the database itself to capture and analyze data. (http://en.wikipedia.org/wiki/Database)','public',1,'admin','2026-01-20 13:41:19',NULL),(31,'OS::Software::Runtimes','Runtime Environment','Software is written in a specific programming language and the language must execute within a runtime environment. The runtime environment provides an abstraction to utilizing a computer\'s processor, memory (RAM), and other system resources.','public',1,'admin','2026-01-20 13:41:19',NULL),(32,'OS::Software::WebServers','Web Servers','A web server is a computer system that processes requests via HTTP, the basic network protocol used to distribute information on the World Wide Web. The most common use of web servers is to host websites, but there are other uses such as gaming, data storage, running enterprise applications, handling email, FTP, or other web uses. (http://en.wikipedia.org/wiki/Web_server)','public',1,'admin','2026-01-20 13:41:19',NULL),(33,'OS::Cinder::Volumetype','Cinder Volume Type','The Cinder volume type configuration option. Volume type assignment provides a mechanism not only to provide scheduling to a specific storage back-end, but also can be used to specify specific information for a back-end storage device to act upon.','public',1,'admin','2026-01-20 13:41:19',NULL);
/*!40000 ALTER TABLE `metadef_namespaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_objects`
--

DROP TABLE IF EXISTS `metadef_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `description` text DEFAULT NULL,
  `required` text DEFAULT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_objects_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_objects_name` (`name`),
  CONSTRAINT `metadef_objects_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_objects`
--

LOCK TABLES `metadef_objects` WRITE;
/*!40000 ALTER TABLE `metadef_objects` DISABLE KEYS */;
INSERT INTO `metadef_objects` (`id`, `namespace_id`, `name`, `description`, `required`, `json_schema`, `created_at`, `updated_at`) VALUES (1,17,'CPU Limits','You can configure the CPU limits with control parameters.',NULL,'{\"quota:cpu_shares\": {\"title\": \"Quota: CPU Shares\", \"description\": \"Specifies the proportional weighted share for the domain. If this element is omitted, the service defaults to the OS provided defaults. There is no unit for the value; it is a relative measure based on the setting of other VMs. For example, a VM configured with value 2048 gets twice as much CPU time as a VM configured with value 1024.\", \"type\": \"integer\"}, \"quota:cpu_period\": {\"title\": \"Quota: CPU Period\", \"description\": \"Specifies the enforcement interval (unit: microseconds) for QEMU and LXC hypervisors. Within a period, each VCPU of the domain is not allowed to consume more than the quota worth of runtime. The value should be in range [1000, 1000000]. A period with value 0 means no value.\", \"type\": \"integer\", \"minimum\": 1000, \"maximum\": 1000000}, \"quota:cpu_quota\": {\"title\": \"Quota: CPU Quota\", \"description\": \"Specifies the maximum allowed bandwidth (unit: microseconds). A domain with a negative-value quota indicates that the domain has infinite bandwidth, which means that it is not bandwidth controlled. The value should be in range [1000, 18446744073709551] or less than 0. A quota with value 0 means no value. You can use this feature to ensure that all vCPUs run at the same speed.\", \"type\": \"integer\"}}','2026-01-20 13:41:16',NULL),(2,17,'Disk QoS','Using disk I/O quotas, you can set maximum disk write to 10 MB per second for a VM user.',NULL,'{\"quota:disk_read_bytes_sec\": {\"title\": \"Quota: Disk read bytes / sec\", \"description\": \"Sets disk I/O quota for disk read bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_read_iops_sec\": {\"title\": \"Quota: Disk read IOPS / sec\", \"description\": \"Sets disk I/O quota for disk read IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_write_bytes_sec\": {\"title\": \"Quota: Disk Write Bytes / sec\", \"description\": \"Sets disk I/O quota for disk write bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_write_iops_sec\": {\"title\": \"Quota: Disk Write IOPS / sec\", \"description\": \"Sets disk I/O quota for disk write IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_total_bytes_sec\": {\"title\": \"Quota: Disk Total Bytes / sec\", \"description\": \"Sets disk I/O quota for total disk bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_total_iops_sec\": {\"title\": \"Quota: Disk Total IOPS / sec\", \"description\": \"Sets disk I/O quota for disk total IOPS / sec.\", \"type\": \"integer\"}}','2026-01-20 13:41:16',NULL),(3,17,'Virtual Interface QoS','Bandwidth QoS tuning for instance virtual interfaces (VIFs) may be specified with these properties. Incoming and outgoing traffic can be shaped independently. If not specified, no quality of service (QoS) is applied on that traffic direction. So, if you want to shape only the network\'s incoming traffic, use inbound only (and vice versa). The OpenStack Networking service abstracts the physical implementation of the network, allowing plugins to configure and manage physical resources. Virtual Interfaces (VIF) in the logical model are analogous to physical network interface cards (NICs). VIFs are typically owned a managed by an external service; for instance when OpenStack Networking is used for building OpenStack networks, VIFs would be created, owned, and managed in Nova. VIFs are connected to OpenStack Networking networks via ports. A port is analogous to a port on a network switch, and it has an administrative state. When a VIF is attached to a port the OpenStack Networking API creates an attachment object, which specifies the fact that a VIF with a given identifier is plugged into the port.',NULL,'{\"quota:vif_inbound_average\": {\"title\": \"Quota: VIF Inbound Average\", \"description\": \"Network Virtual Interface (VIF) inbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_inbound_burst\": {\"title\": \"Quota: VIF Inbound Burst\", \"description\": \"Network Virtual Interface (VIF) inbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_inbound_peak\": {\"title\": \"Quota: VIF Inbound Peak\", \"description\": \"Network Virtual Interface (VIF) inbound peak in kilobytes per second. Specifies maximum rate at which an interface can receive data.\", \"type\": \"integer\"}, \"quota:vif_outbound_average\": {\"title\": \"Quota: VIF Outbound Average\", \"description\": \"Network Virtual Interface (VIF) outbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_outbound_burst\": {\"title\": \"Quota: VIF Outbound Burst\", \"description\": \"Network Virtual Interface (VIF) outbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_outbound_peak\": {\"title\": \"Quota: VIF Outbound Peak\", \"description\": \"Network Virtual Interface (VIF) outbound peak in kilobytes per second. Specifies maximum rate at which an interface can send data.\", \"type\": \"integer\"}}','2026-01-20 13:41:16',NULL),(4,30,'MySQL','MySQL is an object-relational database management system (ORDBMS). The MySQL development project has made its source code available under the terms of the GNU General Public License, as well as under a variety of proprietary agreements. MySQL was owned and sponsored by a single for-profit firm, the Swedish company MySQL AB, now owned by Oracle Corporation. MySQL is a popular choice of database for use in web applications, and is a central component of the widely used LAMP open source web application software stack (and other \'AMP\' stacks). (http://en.wikipedia.org/wiki/MySQL)',NULL,'{\"sw_database_mysql_version\": {\"title\": \"Version\", \"description\": \"The specific version of MySQL.\", \"type\": \"string\"}, \"sw_database_mysql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"The configured TCP/IP port which MySQL listens for incoming connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 3606}, \"sw_database_mysql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"root\"}}','2026-01-20 13:41:19',NULL),(5,30,'PostgreSQL','PostgreSQL, often simply \'Postgres\', is an object-relational database management system (ORDBMS) with an emphasis on extensibility and standards-compliance. PostgreSQL is cross-platform and runs on many operating systems. (http://en.wikipedia.org/wiki/PostgreSQL)',NULL,'{\"sw_database_postgresql_version\": {\"title\": \"Version\", \"description\": \"The specific version of PostgreSQL.\", \"type\": \"string\"}, \"sw_database_postgresql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which PostgreSQL is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_postgresql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"postgres\"}}','2026-01-20 13:41:19',NULL),(6,30,'SQL Server','Microsoft SQL Server is a relational database management system developed by Microsoft. There are at least a dozen different editions of Microsoft SQL Server aimed at different audiences and for workloads ranging from small single-machine applications to large Internet-facing applications with many concurrent users. Its primary query languages are T-SQL and ANSI SQL. (http://en.wikipedia.org/wiki/Microsoft_SQL_Server)',NULL,'{\"sw_database_sqlserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Microsoft SQL Server.\", \"type\": \"string\"}, \"sw_database_sqlserver_edition\": {\"title\": \"Edition\", \"description\": \"SQL Server is available in multiple editions, with different feature sets and targeting different users.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Datacenter\", \"Enterprise\", \"Standard\", \"Web\", \"Business Intelligence\", \"Workgroup\", \"Express\", \"Compact (SQL CE)\", \"Developer\", \"Embedded (SSEE)\", \"Express\", \"Fast Track\", \"LocalDB\", \"Parallel Data Warehouse (PDW)\", \"Business Intelligence\", \"Datawarehouse Appliance Edition\"]}, \"sw_database_sqlserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which SQL Server is to listen for connections from client applications. The default SQL Server port is 1433, and client ports are assigned a random value between 1024 and 5000.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1433}, \"sw_database_postsqlserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"sa\"}}','2026-01-20 13:41:19',NULL),(7,30,'Oracle','Oracle Database (commonly referred to as Oracle RDBMS or simply as Oracle) is an object-relational database management system produced and marketed by Oracle Corporation. (http://en.wikipedia.org/wiki/Oracle_Database)',NULL,'{\"sw_database_oracle_version\": {\"title\": \"Version\", \"description\": \"The specific version of Oracle.\", \"type\": \"string\"}, \"sw_database_oracle_edition\": {\"title\": \"Edition\", \"description\": \"Over and above the different versions of the Oracle database management software developed over time, Oracle Corporation subdivides its product into varying editions.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Enterprise\", \"Standard\", \"Standard Edition One\", \"Express (XE)\", \"Workgroup\", \"Lite\"]}, \"sw_database_oracle_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Oracle is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1521}}','2026-01-20 13:41:19',NULL),(8,30,'DB2','IBM DB2 is a family of database server products developed by IBM. These products all support the relational model, but in recent years some products have been extended to support object-relational features and non-relational structures, in particular XML. (http://en.wikipedia.org/wiki/IBM_DB2)',NULL,'{\"sw_database_db2_version\": {\"title\": \"Version\", \"description\": \"The specific version of DB2.\", \"type\": \"string\"}, \"sw_database_db2_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which DB2 is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_db2_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-01-20 13:41:19',NULL),(9,30,'MongoDB','MongoDB is a cross-platform document-oriented database. Classified as a NoSQL database, MongoDB uses JSON-like documents with dynamic schemas (MongoDB calls the format BSON), making the integration of data in certain types of applications easier and faster. Released under a combination of the GNU Affero General Public License and the Apache License, MongoDB is free and open-source software. (http://en.wikipedia.org/wiki/MongoDB)',NULL,'{\"sw_database_mongodb_version\": {\"title\": \"Version\", \"description\": \"The specific version of MongoDB.\", \"type\": \"string\"}, \"sw_database_mongodb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which MongoDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 27017}, \"sw_database_mongodb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-01-20 13:41:19',NULL),(10,30,'Couchbase Server','Couchbase Server, originally known as Membase, is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications. These applications must serve many concurrent users by creating, storing, retrieving, aggregating, manipulating and presenting data. In support of these kinds of application needs, Couchbase is designed to provide easy-to-scale key-value or document access with low latency and high sustained throughput. (http://en.wikipedia.org/wiki/Couchbase_Server)',NULL,'{\"sw_database_couchbaseserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Couchbase Server.\", \"type\": \"string\"}, \"sw_database_couchbaseserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Couchbase is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 11211}, \"sw_database_couchbaseserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2026-01-20 13:41:19',NULL),(11,30,'Redis','Redis is a data structure server (NoSQL). It is open-source, networked, in-memory, and stores keys with optional durability. The development of Redis has been sponsored by Pivotal Software since May 2013; before that, it was sponsored by VMware. The name Redis means REmote DIctionary Server. (http://en.wikipedia.org/wiki/Redis)',NULL,'{\"sw_database_redis_version\": {\"title\": \"Version\", \"description\": \"The specific version of Redis.\", \"type\": \"string\"}, \"sw_database_redis_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Redis is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 6379}, \"sw_database_redis_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2026-01-20 13:41:19',NULL),(12,30,'CouchDB','Apache CouchDB, commonly referred to as CouchDB, is an open source NoSQL database. It is a NoSQL database that uses JSON to store data, JavaScript as its query language using MapReduce, and HTTP for an API. One of its distinguishing features is multi-master replication. CouchDB was first released in 2005 and later became an Apache project in 2008. (http://en.wikipedia.org/wiki/CouchDB)',NULL,'{\"sw_database_couchdb_version\": {\"title\": \"Version\", \"description\": \"The specific version of CouchDB.\", \"type\": \"string\"}, \"sw_database_couchdb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which CouchDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5984}, \"sw_database_couchdb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-01-20 13:41:19',NULL),(13,30,'Apache Cassandra','Apache Cassandra is an open source distributed NoSQL database management system designed to handle large amounts of data across many commodity servers, providing high availability with no single point of failure. (http://en.wikipedia.org/wiki/Apache_Cassandra)',NULL,'{\"sw_database_cassandra_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache Cassandra.\", \"type\": \"string\"}, \"sw_database_cassandra_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Cassandra is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 9160}, \"sw_database_cassandra_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"cassandra\"}}','2026-01-20 13:41:19',NULL),(14,30,'HBase','HBase is an open source, non-relational (NoSQL), distributed database modeled after Google\'s BigTable and written in Java. It is developed as part of Apache Software Foundation\'s Apache Hadoop project and runs on top of HDFS (Hadoop Distributed Filesystem), providing BigTable-like capabilities for Hadoop. (http://en.wikipedia.org/wiki/Apache_HBase)',NULL,'{\"sw_database_hbase_version\": {\"title\": \"Version\", \"description\": \"The specific version of HBase.\", \"type\": \"string\"}}','2026-01-20 13:41:19',NULL),(15,30,'Hazlecast','In computing, Hazelcast is an in-memory open source software data grid based on Java. By having multiple nodes form a cluster, data is evenly distributed among the nodes. This allows for horizontal scaling both in terms of available storage space and processing power. Backups are also distributed in a similar fashion to other nodes, based on configuration, thereby protecting against single node failure. (http://en.wikipedia.org/wiki/Hazelcast)',NULL,'{\"sw_database_hazlecast_version\": {\"title\": \"Version\", \"description\": \"The specific version of Hazlecast.\", \"type\": \"string\"}, \"sw_database_hazlecast_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Hazlecast is to listen for connections between members.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5701}}','2026-01-20 13:41:19',NULL),(16,31,'PHP','PHP is a server-side scripting language designed for web development but also used as a general-purpose programming language. PHP code can be simply mixed with HTML code, or it can be used in combination with various templating engines and web frameworks. PHP code is usually processed by a PHP interpreter, which is usually implemented as a web server\'s native module or a Common Gateway Interface (CGI) executable. After the PHP code is interpreted and executed, the web server sends resulting output to its client, usually in form of a part of the generated web page – for example, PHP code can generate a web page\'s HTML code, an image, or some other data. PHP has also evolved to include a command-line interface (CLI) capability and can be used in standalone graphical applications. (http://en.wikipedia.org/wiki/PHP)',NULL,'{\"sw_runtime_php_version\": {\"title\": \"Version\", \"description\": \"The specific version of PHP.\", \"type\": \"string\"}}','2026-01-20 13:41:19',NULL),(17,31,'Python','Python is a widely used general-purpose, high-level programming language. Its design philosophy emphasizes code readability, and its syntax allows programmers to express concepts in fewer lines of code than would be possible in languages such as C++ or Java. The language provides constructs intended to enable clear programs on both a small and large scale. Python supports multiple programming paradigms, including object-oriented, imperative and functional programming or procedural styles. It features a dynamic type system and automatic memory management and has a large and comprehensive standard library. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_python_version\": {\"title\": \"Version\", \"description\": \"The specific version of python.\", \"type\": \"string\"}}','2026-01-20 13:41:19',NULL),(18,31,'Java','Java is a functional computer programming language that is concurrent, class-based, object-oriented, and specifically designed to have as few implementation dependencies as possible. It is intended to let application developers write once, run anywhere (WORA), meaning that code that runs on one platform does not need to be recompiled to run on another. Java applications are typically compiled to bytecode that can run on any Java virtual machine (JVM) regardless of computer architecture. (http://en.wikipedia.org/wiki/Java_(programming_language))',NULL,'{\"sw_runtime_java_version\": {\"title\": \"Version\", \"description\": \"The specific version of Java.\", \"type\": \"string\"}}','2026-01-20 13:41:19',NULL),(19,31,'Ruby','Ruby is a dynamic, reflective, object-oriented, general-purpose programming language. It was designed and developed in the mid-1990s by Yukihiro Matsumoto in Japan. According to its authors, Ruby was influenced by Perl, Smalltalk, Eiffel, Ada, and Lisp. It supports multiple programming paradigms, including functional, object-oriented, and imperative. It also has a dynamic type system and automatic memory management. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_ruby_version\": {\"title\": \"Version\", \"description\": \"The specific version of Ruby.\", \"type\": \"string\"}}','2026-01-20 13:41:19',NULL),(20,31,'Perl','Perl is a family of high-level, general-purpose, interpreted, dynamic programming languages. The languages in this family include Perl 5 and Perl 6. Though Perl is not officially an acronym, there are various backronyms in use, the most well-known being Practical Extraction and Reporting Language (http://en.wikipedia.org/wiki/Perl)',NULL,'{\"sw_runtime_perl_version\": {\"title\": \"Version\", \"description\": \"The specific version of Perl.\", \"type\": \"string\"}}','2026-01-20 13:41:19',NULL),(21,32,'Apache HTTP Server','The Apache HTTP Server, colloquially called Apache, is a Web server application notable for playing a key role in the initial growth of the World Wide Web. Apache is developed and maintained by an open community of developers under the auspices of the Apache Software Foundation. Most commonly used on a Unix-like system, the software is available for a wide variety of operating systems, including Unix, FreeBSD, Linux, Solaris, Novell NetWare, OS X, Microsoft Windows, OS/2, TPF, OpenVMS and eComStation. Released under the Apache License, Apache is open-source software. (http://en.wikipedia.org/wiki/Apache_HTTP_Server)',NULL,'{\"sw_webserver_apache_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache.\", \"type\": \"string\"}, \"sw_webserver_apache_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_apache_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-01-20 13:41:19',NULL),(22,32,'Nginx','Nginx (pronounced \'engine-x\') is an open source reverse proxy server for HTTP, HTTPS, SMTP, POP3, and IMAP protocols, as well as a load balancer, HTTP cache, and a web server (origin server). The nginx project started with a strong focus on high concurrency, high performance and low memory usage. It is licensed under the 2-clause BSD-like license and it runs on Linux, BSD variants, Mac OS X, Solaris, AIX, HP-UX, as well as on other *nix flavors. It also has a proof of concept port for Microsoft Windows. (http://en.wikipedia.org/wiki/Nginx)',NULL,'{\"sw_webserver_nginx_version\": {\"title\": \"Version\", \"description\": \"The specific version of Nginx.\", \"type\": \"string\"}, \"sw_webserver_nginx_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_nginx_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-01-20 13:41:19',NULL),(23,32,'IIS','Internet Information Services (IIS, formerly Internet Information Server) is an extensible web server created by Microsoft. IIS supports HTTP, HTTPS, FTP, FTPS, SMTP and NNTP. IIS is not turned on by default when Windows is installed. The IIS Manager is accessed through the Microsoft Management Console or Administrative Tools in the Control Panel. (http://en.wikipedia.org/wiki/Internet_Information_Services)',NULL,'{\"sw_webserver_iis_version\": {\"title\": \"Version\", \"description\": \"The specific version of IIS.\", \"type\": \"string\"}, \"sw_webserver_iis_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_iis_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-01-20 13:41:19',NULL);
/*!40000 ALTER TABLE `metadef_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_properties`
--

DROP TABLE IF EXISTS `metadef_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_properties_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_properties_name` (`name`),
  CONSTRAINT `metadef_properties_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_properties`
--

LOCK TABLES `metadef_properties` WRITE;
/*!40000 ALTER TABLE `metadef_properties` DISABLE KEYS */;
INSERT INTO `metadef_properties` (`id`, `namespace_id`, `name`, `json_schema`, `created_at`, `updated_at`) VALUES (1,1,'InstructionSet','{\"title\": \"Instruction Set\", \"description\": \"Identifies the instruction set of the processor within a processor architecture.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86:i386\", \"x86:i486\", \"x86:i586\", \"x86:i686\", \"x86:64\", \"IA-64:IA-64\", \"AS/400:TIMI\", \"Power:Power_2.03\", \"Power:Power_2.04\", \"Power:Power_2.05\", \"Power:Power_2.06\", \"S/390:ESA/390\", \"S/390:z/Architecture\", \"S/390:z/Architecture_2\", \"PA-RISC:PA-RISC_1.0\", \"PA-RISC:PA-RISC_2.0\", \"ARM:A32\", \"ARM:A64\", \"MIPS:MIPS_I\", \"MIPS:MIPS_II\", \"MIPS:MIPS_III\", \"MIPS:MIPS_IV\", \"MIPS:MIPS_V\", \"MIPS:MIPS32\", \"MIPS64:MIPS64\", \"Alpha:Alpha\", \"SPARC:SPARC_V7\", \"SPARC:SPARC_V8\", \"SPARC:SPARC_V9\", \"SPARC:SPARC_JPS1\", \"SPARC:UltraSPARC2005\", \"SPARC:UltraSPARC2007\", \"68k:68000\", \"68k:68010\", \"68k:68020\", \"68k:68030\", \"68k:68040\", \"68k:68060\"]}','2026-01-20 13:41:13',NULL),(2,1,'ProcessorArchitecture','{\"title\": \"Processor Architecture\", \"description\": \"Identifies the processor architecture of the processor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"IA-64\", \"AS/400\", \"Power\", \"S/390\", \"PA-RISC\", \"ARM\", \"MIPS\", \"Alpha\", \"SPARC\", \"68k\"]}','2026-01-20 13:41:13',NULL),(3,1,'InstructionSetExtensionName','{\"title\": \"Instruction Set Extension\", \"description\": \"Identifies the instruction set extensions of the processor within a processor architecture.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"x86:3DNow\", \"x86:3DNowExt\", \"x86:ABM\", \"x86:AES\", \"x86:AVX\", \"x86:AVX2\", \"x86:BMI\", \"x86:CX16\", \"x86:F16C\", \"x86:FSGSBASE\", \"x86:LWP\", \"x86:MMX\", \"x86:PCLMUL\", \"x86:RDRND\", \"x86:SSE2\", \"x86:SSE3\", \"x86:SSSE3\", \"x86:SSE4A\", \"x86:SSE41\", \"x86:SSE42\", \"x86:FMA3\", \"x86:FMA4\", \"x86:XOP\", \"x86:TBM\", \"x86:VT-d\", \"x86:VT-x\", \"x86:EPT\", \"x86:SVM\", \"PA-RISC:MAX\", \"PA-RISC:MAX2\", \"ARM:DSP\", \"ARM:Jazelle-DBX\", \"ARM:Thumb\", \"ARM:Thumb-2\", \"ARM:ThumbEE)\", \"ARM:VFP\", \"ARM:NEON\", \"ARM:TrustZone\", \"MIPS:MDMX\", \"MIPS:MIPS-3D\", \"Alpha:BWX\", \"Alpha:FIX\", \"Alpha:CIX\", \"Alpha:MVI\"]}}','2026-01-20 13:41:13',NULL),(4,2,'Address','{\"title\": \"Address\", \"description\": \"The address of the resource.\", \"type\": \"string\"}','2026-01-20 13:41:13',NULL),(5,2,'AddressOnParent','{\"title\": \"Address On Parent\", \"description\": \"Describes the address of this resource in the context of the Parent.\", \"type\": \"string\"}','2026-01-20 13:41:13',NULL),(6,2,'AllocationUnits','{\"title\": \"Allocation Units\", \"description\": \"This property specifies the units of allocation used by the Reservation and Limit properties.\", \"type\": \"string\"}','2026-01-20 13:41:13',NULL),(7,2,'AutomaticAllocation','{\"title\": \"Automatic Allocation\", \"description\": \"This property specifies if the resource will be automatically allocated.\", \"type\": \"boolean\"}','2026-01-20 13:41:13',NULL),(8,2,'AutomaticDeallocation','{\"title\": \"Automatic Deallocation\", \"description\": \"This property specifies if the resource will be automatically de-allocated.\", \"type\": \"boolean\"}','2026-01-20 13:41:13',NULL),(9,2,'ConsumerVisibility','{\"title\": \"Consumer Visibility\", \"description\": \"Describes the consumers visibility to the allocated resource.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Passed-Through\", \"Virtualized\", \"Not represented\", \"DMTF reserved\", \"Vendor Reserved\"]}','2026-01-20 13:41:13',NULL),(10,2,'Limit','{\"title\": \"Limit\", \"description\": \"This property specifies the upper bound, or maximum amount of resource that will be granted for this allocation.\", \"type\": \"string\"}','2026-01-20 13:41:13',NULL),(11,2,'MappingBehavior','{\"title\": \"Mapping Behavior\", \"description\": \"Specifies how this resource maps to underlying resources. If the HostResource array contains any entries, this property reflects how the resource maps to those specific resources.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Not Supported\", \"Dedicated\", \"Soft Affinity\", \"Hard Affinity\", \"DMTF Reserved\", \"Vendor Reserved\"]}','2026-01-20 13:41:13',NULL),(12,2,'OtherResourceType','{\"title\": \"Other Resource Type\", \"description\": \"A string that describes the resource type when a well defined value is not available and ResourceType has the value \'Other\'.\", \"type\": \"string\"}','2026-01-20 13:41:13',NULL),(13,2,'Parent','{\"title\": \"Parent\", \"description\": \"The Parent of the resource.\", \"type\": \"string\"}','2026-01-20 13:41:13',NULL),(14,2,'PoolID','{\"title\": \"Pool ID\", \"description\": \"This property specifies which ResourcePool the resource is currently allocated from, or which ResourcePool the resource will be allocated from when the allocation occurs.\", \"type\": \"string\"}','2026-01-20 13:41:13',NULL),(15,2,'Reservation','{\"title\": \"Reservation\", \"description\": \"This property specifies the amount of resource guaranteed to be available for this allocation.\", \"type\": \"string\"}','2026-01-20 13:41:13',NULL),(16,2,'ResourceSubType','{\"title\": \"Resource Sub Type\", \"description\": \"A string describing an implementation specific sub-type for this resource.\", \"type\": \"string\"}','2026-01-20 13:41:13',NULL),(17,2,'ResourceType','{\"title\": \"Resource Type\", \"description\": \"The type of resource this allocation setting represents.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Other\", \"Computer System\", \"Processor\", \"Memory\", \"IDE Controller\", \"Parallel SCSI HBA\", \"FC HBA\", \"iSCSI HBA\", \"IB HCA\", \"Ethernet Adapter\", \"Other Network Adapter\", \"I/O Slot\", \"I/O Device\", \"Floppy Drive\", \"CD Drive\", \"DVD drive\", \"Disk Drive\", \"Tape Drive\", \"Storage Extent\", \"Other storage device\", \"Serial port\", \"Parallel port\", \"USB Controller\", \"Graphics controller\", \"IEEE 1394 Controller\", \"Partitionable Unit\", \"Base Partitionable Unit\", \"Power\", \"Cooling Capacity\", \"Ethernet Switch Port\", \"Logical Disk\", \"Storage Volume\", \"Ethernet Connection\", \"DMTF reserved\", \"Vendor Reserved\"]}','2026-01-20 13:41:13',NULL),(18,2,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"This property specifies the quantity of resources presented to the consumer.\", \"type\": \"string\"}','2026-01-20 13:41:13',NULL),(19,2,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2026-01-20 13:41:13',NULL),(20,2,'Weight','{\"title\": \"Weight\", \"description\": \"This property specifies a relative priority for this allocation in relation to other allocations from the same ResourcePool.\", \"type\": \"string\"}','2026-01-20 13:41:13',NULL),(21,2,'Connection','{\"title\": \"Connection\", \"description\": \"The thing to which this resource is connected.\", \"type\": \"string\"}','2026-01-20 13:41:13',NULL),(22,2,'HostResource','{\"title\": \"Host Resource\", \"description\": \"This property exposes specific assignment of resources.\", \"type\": \"string\"}','2026-01-20 13:41:13',NULL),(23,3,'Access','{\"title\": \"Access\", \"description\": \"Access describes whether the allocated storage extent is 1 (readable), 2 (writeable), or 3 (both).\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Readable\", \"Writeable\", \"Read/Write Supported\", \"DMTF Reserved\"]}','2026-01-20 13:41:13',NULL),(24,3,'HostExtentName','{\"title\": \"Host Extent Name\", \"description\": \"A unique identifier for the host extent.\", \"type\": \"string\"}','2026-01-20 13:41:13',NULL),(25,3,'HostExtentNameFormat','{\"title\": \"Host Extent Name Format\", \"description\": \"The HostExtentNameFormat property identifies the format that is used for the value of the HostExtentName property.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"SNVM\", \"NAA\", \"EUI64\", \"T10VID\", \"OS Device Name\", \"DMTF Reserved\"]}','2026-01-20 13:41:13',NULL),(26,3,'HostExtentNameNamespace','{\"title\": \"Host Extent Name Namespace\", \"description\": \"If the host extent is a SCSI volume, then the preferred source for SCSI volume names is SCSI VPD Page 83 responses.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"VPD83Type3\", \"VPD83Type2\", \"VPD83Type1\", \"VPD80\", \"NodeWWN\", \"SNVM\", \"OS Device Namespace\", \"DMTF Reserved\"]}','2026-01-20 13:41:13',NULL),(27,3,'HostExtentStartingAddress','{\"title\": \"Host Extent Starting Address\", \"description\": \"The HostExtentStartingAddress property identifies the starting address on the host storage extent identified by the value of the HostExtentName property that is used for the allocation of the virtual storage extent.\", \"type\": \"string\"}','2026-01-20 13:41:13',NULL),(28,3,'HostResourceBlockSize','{\"title\": \"Host Resource Block Size\", \"description\": \"Size in bytes of the blocks that are allocated at the host as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2026-01-20 13:41:13',NULL),(29,3,'Limit','{\"title\": \"Limit\", \"description\": \"The maximum amount of blocks that will be granted for this storage resource allocation at the host.\", \"type\": \"string\"}','2026-01-20 13:41:13',NULL),(30,3,'OtherHostExtentNameFormat','{\"title\": \"Other Host Extent Name Format\", \"description\": \"A string describing the format of the HostExtentName property if the value of the HostExtentNameFormat property is 1 (Other).\", \"type\": \"string\"}','2026-01-20 13:41:13',NULL),(31,3,'OtherHostExtentNameNamespace','{\"title\": \"Other Host Extent Name Namespace\", \"description\": \"A string describing the namespace of the HostExtentName property if the value of the HostExtentNameNamespace matches 1 (Other).\", \"type\": \"string\"}','2026-01-20 13:41:13',NULL),(32,3,'Reservation','{\"title\": \"Reservation\", \"description\": \"The amount of blocks that are guaranteed to be available for this storage resource allocation at the host.\", \"type\": \"string\"}','2026-01-20 13:41:13',NULL),(33,3,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"Number of blocks that are presented to the consumer.\", \"type\": \"string\"}','2026-01-20 13:41:13',NULL),(34,3,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2026-01-20 13:41:13',NULL),(35,3,'VirtualResourceBlockSize','{\"title\": \"Virtual Resource Block Size\", \"description\": \"Size in bytes of the blocks that are presented to the consumer as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2026-01-20 13:41:13',NULL),(36,4,'AutomaticRecoveryAction','{\"title\": \"Automatic Recovery Action\", \"description\": \"Action to take for the virtual system when the software executed by the virtual system fails.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart\", \"Revert to snapshot\", \"DMTF Reserved\"]}','2026-01-20 13:41:13',NULL),(37,4,'AutomaticShutdownAction','{\"title\": \"Automatic Shutdown Action\", \"description\": \"Action to take for the virtual system when the host is shut down.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Turn Off\", \"Save state\", \"Shutdown\", \"DMTF Reserved\"]}','2026-01-20 13:41:13',NULL),(38,4,'AutomaticStartupAction','{\"title\": \"Automatic Startup Action\", \"description\": \"Action to take for the virtual system when the host is started.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart if previously active\", \"Always startup\", \"DMTF Reserved\"]}','2026-01-20 13:41:13',NULL),(39,4,'AutomaticStartupActionDelay','{\"title\": \"Automatic Startup Action Delay\", \"description\": \"Delay applicable to startup action.\", \"type\": \"string\"}','2026-01-20 13:41:13',NULL),(40,4,'AutomaticStartupActionSequenceNumber','{\"title\": \"Automatic Startup Action Sequence Number\", \"description\": \"Number indicating the relative sequence of virtual system activation when the host system is started.\", \"type\": \"string\"}','2026-01-20 13:41:13',NULL),(41,4,'ConfigurationDataRoot','{\"title\": \"Configuration Data Root\", \"description\": \"Filepath of a directory where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2026-01-20 13:41:13',NULL),(42,4,'ConfigurationFile','{\"title\": \"Configuration File\", \"description\": \"Filepath of a file where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2026-01-20 13:41:13',NULL),(43,4,'ConfigurationID','{\"title\": \"Configuration ID\", \"description\": \"Unique id of the virtual system configuration.\", \"type\": \"string\"}','2026-01-20 13:41:13',NULL),(44,4,'CreationTime','{\"title\": \"Creation Time\", \"description\": \"Time when the virtual system configuration was created.\", \"type\": \"string\"}','2026-01-20 13:41:13',NULL),(45,4,'LogDataRoot','{\"title\": \"Log Data Root\", \"description\": \"Filepath of a directory where log information about the virtual system is stored.\", \"type\": \"string\"}','2026-01-20 13:41:13',NULL),(46,4,'RecoveryFile','{\"title\": \"Recovery File\", \"description\": \"Filepath of a file where recovery relateded information of the virtual system is stored.\", \"type\": \"string\"}','2026-01-20 13:41:14',NULL),(47,4,'SnapshotDataRoot','{\"title\": \"Snapshot Data Root\", \"description\": \"Filepath of a directory where information about virtual system snapshots is stored.\", \"type\": \"string\"}','2026-01-20 13:41:14',NULL),(48,4,'SuspendDataRoot','{\"title\": \"Suspend Data Root\", \"description\": \"Filepath of a directory where suspend related information about the virtual system is stored.\", \"type\": \"string\"}','2026-01-20 13:41:14',NULL),(49,4,'SwapFileDataRoot','{\"title\": \"Swap File Data Root\", \"description\": \"Filepath of a directory where swapfiles of the virtual system are stored.\", \"type\": \"string\"}','2026-01-20 13:41:14',NULL),(50,4,'VirtualSystemIdentifier','{\"title\": \"Virtual System Identifier\", \"description\": \"VirtualSystemIdentifier shall reflect a unique name for the system as it is used within the virtualization platform.\", \"type\": \"string\"}','2026-01-20 13:41:14',NULL),(51,4,'VirtualSystemType','{\"title\": \"Virtual System Type\", \"description\": \"VirtualSystemType shall reflect a particular type of virtual system.\", \"type\": \"string\"}','2026-01-20 13:41:14',NULL),(52,4,'Notes','{\"title\": \"Notes\", \"description\": \"End-user supplied notes that are related to the virtual system.\", \"type\": \"string\"}','2026-01-20 13:41:14',NULL),(53,5,'disk_allocation_ratio','{\"title\": \"Disk Subscription Ratio\", \"description\": \"Allows the host to be under and over subscribed for the amount of disk space requested for an instance. A ratio greater than 1.0 allows for over subscription (hosts may have less usable disk space than requested). A ratio less than 1.0 allows for under subscription.\", \"type\": \"number\", \"readonly\": false}','2026-01-20 13:41:14',NULL),(54,6,'max_io_ops_per_host','{\"title\": \"Maximum IO Operations per Host\", \"description\": \"Prevents hosts in the aggregate that have this many or more instances currently in build, resize, snapshot, migrate, rescue or unshelve to be scheduled for new instances.\", \"type\": \"integer\", \"readonly\": false, \"default\": 8, \"minimum\": 1}','2026-01-20 13:41:14',NULL),(55,7,'max_instances_per_host','{\"title\": \"Max Instances Per Host\", \"description\": \"Maximum number of instances allowed to run on a host in the aggregate.\", \"type\": \"integer\", \"readonly\": false, \"minimum\": 0}','2026-01-20 13:41:14',NULL),(56,8,'cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"Type of CPU Mode.\", \"type\": \"string\", \"enum\": [\"none\", \"host-model\", \"host-passthrough\", \"custom\"]}','2026-01-20 13:41:14',NULL),(57,9,'cpu_policy','{\"title\": \"CPU Pinning policy\", \"description\": \"Type of CPU pinning policy.\", \"type\": \"string\", \"enum\": [\"shared\", \"dedicated\"]}','2026-01-20 13:41:14',NULL),(58,9,'cpu_thread_policy','{\"title\": \"CPU Thread Pinning Policy.\", \"description\": \"Type of CPU thread pinning policy.\", \"type\": \"string\", \"enum\": [\"isolate\", \"prefer\", \"require\"]}','2026-01-20 13:41:14',NULL),(59,10,'mem_page_size','{\"title\": \"Size of memory page\", \"description\": \"Page size to be used for Guest memory backing. Value can be specified as <number><unit> (i.e.: 2MB, 1GB) or \'any\', \'small\', \'large\'. If this property is set in Image metadata then only \'any\' and \'large\' values are accepted in Flavor metadata by Nova API.\", \"type\": \"string\"}','2026-01-20 13:41:14',NULL),(60,11,'os_shutdown_timeout','{\"title\": \"Shutdown timeout\", \"description\": \"By default, guests will be given 60 seconds to perform a graceful shutdown. After that, the VM is powered off.  This property allows overriding the amount of time (unit: seconds) to allow a guest OS to cleanly shut down before power off. A value of 0 (zero) means the guest will be powered off immediately with no opportunity for guest OS clean-up.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-20 13:41:14',NULL),(61,12,'cpu_info:vendor','{\"title\": \"Vendor\", \"description\": \"Specifies the CPU manufacturer.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Intel\", \"AMD\"]}','2026-01-20 13:41:14',NULL),(62,12,'cpu_info:model','{\"title\": \"Model\", \"description\": \"Specifies the CPU model. Use this property to ensure that your vm runs on a specific cpu model.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Conroe\", \"Core2Duo\", \"Penryn\", \"Nehalem\", \"Westmere\", \"SandyBridge\", \"IvyBridge\", \"Haswell\", \"Broadwell\", \"Delhi\", \"Seoul\", \"Abu Dhabi\", \"Interlagos\", \"Kabini\", \"Valencia\", \"Zurich\", \"Budapest\", \"Barcelona\", \"Suzuka\", \"Shanghai\", \"Istanbul\", \"Lisbon\", \"Magny-Cours\", \"Valencia\", \"Cortex-A57\", \"Cortex-A53\", \"Cortex-A12\", \"Cortex-A17\", \"Cortex-A15\", \"Coretx-A7\", \"X-Gene\"]}','2026-01-20 13:41:14',NULL),(63,12,'cpu_info:arch','{\"title\": \"Architecture\", \"description\": \"Specifies the CPU architecture. Use this property to specify the architecture supported by the hypervisor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"x86_64\", \"i686\", \"ia64\", \"ARMv8-A\", \"ARMv7-A\"]}','2026-01-20 13:41:14',NULL),(64,12,'cpu_info:topology:cores','{\"title\": \"cores\", \"description\": \"Number of cores.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-01-20 13:41:14',NULL),(65,12,'cpu_info:topology:threads','{\"title\": \"threads\", \"description\": \"Number of threads.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-01-20 13:41:14',NULL),(66,12,'cpu_info:topology:sockets','{\"title\": \"sockets\", \"description\": \"Number of sockets.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-01-20 13:41:14',NULL),(67,12,'cpu_info:features','{\"title\": \"Features\", \"description\": \"Specifies CPU flags/features. Using this property you can specify the required set of instructions supported by a vm.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"fpu\", \"vme\", \"de\", \"pse\", \"tsc\", \"msr\", \"pae\", \"mce\", \"cx8\", \"apic\", \"sep\", \"mtrr\", \"pge\", \"mca\", \"cmov\", \"pat\", \"pse36\", \"pn\", \"clflush\", \"dts\", \"acpi\", \"mmx\", \"fxsr\", \"sse\", \"sse2\", \"ss\", \"ht\", \"tm\", \"ia64\", \"pbe\", \"syscall\", \"mp\", \"nx\", \"mmxext\", \"fxsr_opt\", \"pdpe1gb\", \"rdtscp\", \"lm\", \"3dnowext\", \"3dnow\", \"arch_perfmon\", \"pebs\", \"bts\", \"rep_good\", \"nopl\", \"xtopology\", \"tsc_reliable\", \"nonstop_tsc\", \"extd_apicid\", \"amd_dcm\", \"aperfmperf\", \"eagerfpu\", \"nonstop_tsc_s3\", \"pni\", \"pclmulqdq\", \"dtes64\", \"monitor\", \"ds_cpl\", \"vmx\", \"smx\", \"est\", \"tm2\", \"ssse3\", \"cid\", \"fma\", \"cx16\", \"xtpr\", \"pdcm\", \"pcid\", \"dca\", \"sse4_1\", \"sse4_2\", \"x2apic\", \"movbe\", \"popcnt\", \"tsc_deadline_timer\", \"aes\", \"xsave\", \"avx\", \"f16c\", \"rdrand\", \"hypervisor\", \"rng\", \"rng_en\", \"ace\", \"ace_en\", \"ace2\", \"ace2_en\", \"phe\", \"phe_en\", \"pmm\", \"pmm_en\", \"lahf_lm\", \"cmp_legacy\", \"svm\", \"extapic\", \"cr8_legacy\", \"abm\", \"sse4a\", \"misalignsse\", \"3dnowprefetch\", \"osvw\", \"ibs\", \"xop\", \"skinit\", \"wdt\", \"lwp\", \"fma4\", \"tce\", \"nodeid_msr\", \"tbm\", \"topoext\", \"perfctr_core\", \"perfctr_nb\", \"bpext\", \"perfctr_l2\", \"mwaitx\", \"ida\", \"arat\", \"cpb\", \"epb\", \"pln\", \"pts\", \"dtherm\", \"hw_pstate\", \"proc_feedback\", \"hwp\", \"hwp_notify\", \"hwp_act_window\", \"hwp_epp\", \"hwp_pkg_req\", \"intel_pt\", \"tpr_shadow\", \"vnmi\", \"flexpriority\", \"ept\", \"vpid\", \"npt\", \"lbrv\", \"svm_lock\", \"nrip_save\", \"tsc_scale\", \"vmcb_clean\", \"flushbyasid\", \"decodeassists\", \"pausefilter\", \"pfthreshold\", \"vmmcall\", \"fsgsbase\", \"tsc_adjust\", \"bmi1\", \"hle\", \"avx2\", \"smep\", \"bmi2\", \"erms\", \"invpcid\", \"rtm\", \"cqm\", \"mpx\", \"avx512f\", \"rdseed\", \"adx\", \"smap\", \"pcommit\", \"clflushopt\", \"clwb\", \"avx512pf\", \"avx512er\", \"avx512cd\", \"sha_ni\", \"xsaveopt\", \"xsavec\", \"xgetbv1\", \"xsaves\", \"cqm_llc\", \"cqm_occup_llc\", \"clzero\"]}}','2026-01-20 13:41:14',NULL),(68,13,'hypervisor_type','{\"title\": \"Hypervisor Type\", \"description\": \"Hypervisor type required by the image. Used with the ImagePropertiesFilter. \\n\\n Baremetal - physical provisioning. hyperv - Microsoft\\u00ae hyperv. KVM - Kernel-based Virtual Machine. LXC - Linux Containers (through libvirt). powervm - IBM\\u00ae PowerVM\\u00ae. QEMU - Quick EMUlator. UML - User Mode Linux. vmware - VMware\\u00ae vsphere. VZ - Virtuozzo OS Containers and Virtual Machines (through libvirt). For more information, see: https://docs.openstack.org/nova/latest/admin/configuration/hypervisors.html\", \"type\": \"string\", \"enum\": [\"baremetal\", \"hyperv\", \"kvm\", \"lxc\", \"powervm\", \"qemu\", \"uml\", \"vmware\", \"vz\", \"xen\"]}','2026-01-20 13:41:15',NULL),(69,13,'vm_mode','{\"title\": \"VM Mode\", \"description\": \"The virtual machine mode. This represents the host/guest ABI (application binary interface) used for the virtual machine. Used with the ImagePropertiesFilter. \\n\\n hvm \\u2014 Fully virtualized - This is the virtual machine mode (vm_mode) used by QEMU and KVM. \\n\\n xen - Xen 3.0 paravirtualized. \\n\\n uml \\u2014 User Mode Linux paravirtualized. \\n\\n exe \\u2014 Executables in containers. This is the mode used by LXC.\", \"type\": \"string\", \"enum\": [\"hvm\", \"xen\", \"uml\", \"exe\"]}','2026-01-20 13:41:15',NULL),(70,14,'img_config_drive','{\"title\": \"Config Drive\", \"description\": \"This property specifies whether or not Nova should use a config drive when booting the image. Mandatory means that Nova will always use a config drive when booting the image. OpenStack can be configured to write metadata to a special configuration drive that will be attached to the instance when it boots. The instance can retrieve any information from the config drive. One use case for the config drive is to pass network configuration information to the instance. See also: http://docs.openstack.org/user-guide/cli_config_drive.html\", \"type\": \"string\", \"enum\": [\"optional\", \"mandatory\"]}','2026-01-20 13:41:15',NULL),(71,14,'os_require_quiesce','{\"title\": \"Require Quiescent File system\", \"description\": \"This property specifies whether or not the filesystem must be quiesced during snapshot processing. For volume backed and image backed snapshots, yes means that snapshotting is aborted when quiescing fails, whereas, no means quiescing will be skipped and snapshot processing will continue after the quiesce failure.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-01-20 13:41:15',NULL),(72,15,'hw_cdrom_bus','{\"title\": \"CD-ROM Bus\", \"description\": \"Specifies the type of disk controller to attach CD-ROM devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2026-01-20 13:41:15',NULL),(73,15,'hw_disk_bus','{\"title\": \"Disk Bus\", \"description\": \"Specifies the type of disk controller to attach disk devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2026-01-20 13:41:15',NULL),(74,15,'hw_firmware_type','{\"title\": \"Firmware Type\", \"description\": \"Specifies whether the image should be booted with a legacy BIOS or with UEFI.\", \"type\": \"string\", \"enum\": [\"bios\", \"uefi\"]}','2026-01-20 13:41:15',NULL),(75,15,'hw_rng_model','{\"title\": \"Random Number Generator Device\", \"description\": \"Adds a random-number generator device to the image\'s instances. The cloud administrator can enable and control device behavior by configuring the instance\'s flavor. By default: The generator device is disabled. /dev/random is used as the default entropy source. To specify a physical HW RNG device, use the following option in the nova.conf file: rng_dev_path=/dev/hwrng\", \"type\": \"string\", \"default\": \"virtio\"}','2026-01-20 13:41:15',NULL),(76,15,'hw_machine_type','{\"title\": \"Machine Type\", \"description\": \"Enables booting an ARM system using the specified machine type. By default, if an ARM image is used and its type is not specified, Compute uses vexpress-a15 (for ARMv7) or virt (for AArch64) machine types. Valid types can be viewed by using the virsh capabilities command (machine types are displayed in the machine tag).\", \"type\": \"string\"}','2026-01-20 13:41:15',NULL),(77,15,'hw_scsi_model','{\"title\": \"SCSI Model\", \"description\": \"Enables the use of VirtIO SCSI (virtio-scsi) to provide block device access for compute instances; by default, instances use VirtIO Block (virtio-blk). VirtIO SCSI is a para-virtualized SCSI controller device that provides improved scalability and performance, and supports advanced SCSI hardware.\", \"type\": \"string\", \"default\": \"virtio-scsi\"}','2026-01-20 13:41:15',NULL),(78,15,'hw_video_model','{\"title\": \"Video Model\", \"description\": \"The graphic device model presented to the guest. hw_video_model=none disables the graphics device in the guest and should generally be used when using gpu passthrough.\", \"type\": \"string\", \"enum\": [\"vga\", \"cirrus\", \"vmvga\", \"xen\", \"qxl\", \"virtio\", \"gop\", \"none\", \"bochs\"]}','2026-01-20 13:41:15',NULL),(79,15,'hw_video_ram','{\"title\": \"Max Video Ram\", \"description\": \"Maximum RAM (unit: MB) for the video image. Used only if a hw_video:ram_max_mb value has been set in the flavor\'s extra_specs and that value is higher than the value set in hw_video_ram.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-20 13:41:15',NULL),(80,15,'os_command_line','{\"title\": \"Kernel Command Line\", \"description\": \"The kernel command line to be used by the libvirt driver, instead of the default. For linux containers (LXC), the value is used as arguments for initialization. This key is valid only for Amazon kernel, ramdisk, or machine images (aki, ari, or ami).\", \"type\": \"string\"}','2026-01-20 13:41:15',NULL),(81,15,'os_type','{\"title\": \"OS Type\", \"description\": \"The operating system installed on the image. The libvirt driver contains logic that takes different actions depending on the value of the os_type parameter of the image. For example, for os_type=windows images, it creates a FAT32-based swap partition instead of a Linux swap partition, and it limits the injected host name to less than 16 characters.\", \"type\": \"string\", \"enum\": [\"linux\", \"windows\"]}','2026-01-20 13:41:15',NULL),(82,15,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor configuration. libvirt driver options: KVM and QEMU: e1000, ne2k_pci, pcnet, rtl8139, spapr-vlan, virtio, e1000e and vmxnet3. Xen: e1000, netfront, ne2k_pci, pcnet, and rtl8139.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"ne2k_pci\", \"netfront\", \"pcnet\", \"rtl8139\", \"spapr-vlan\", \"virtio\", \"vmxnet3\"]}','2026-01-20 13:41:16',NULL),(83,15,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-20 13:41:16',NULL),(84,15,'hw_pmu','{\"title\": \"Virtual Performance Monitoring Unit\", \"description\": \"Controls emulation of a vPMU in the guest. To reduce latency in realtime workloads disable the vPMU by setting hw_pmu=false\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-20 13:41:16',NULL),(85,15,'hw_qemu_guest_agent','{\"title\": \"QEMU Guest Agent\", \"description\": \"This is a background process which helps management applications execute guest OS level commands. For example, freezing and thawing filesystems, entering suspend. However, guest agent (GA) is not bullet proof, and hostile guest OS can send spurious replies.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-01-20 13:41:16',NULL),(86,15,'hw_pointer_model','{\"title\": \"Pointer Model\", \"description\": \"Input devices allow interaction with a graphical framebuffer. For example to provide a graphic tablet for absolute cursor movement. Currently only supported by the KVM/QEMU hypervisor configuration and VNC or SPICE consoles must be enabled.\", \"type\": \"string\", \"enum\": [\"usbtablet\"]}','2026-01-20 13:41:16',NULL),(87,15,'img_hide_hypervisor_id','{\"title\": \"Hide hypervisor id\", \"description\": \"Enables hiding the host hypervisor signature in the guest OS.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-01-20 13:41:16',NULL),(88,16,'serial_port_count','{\"title\": \"Serial Port Count\", \"description\": \"Specifies the count of serial ports that should be provided. If hw:serial_port_count is not set in the flavor\'s extra_specs, then any count is permitted. If hw:serial_port_count is set, then this provides the default serial port count. It is permitted to override the default serial port count, but only with a lower value.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-20 13:41:16',NULL),(89,16,'boot_menu','{\"title\": \"Boot Menu\", \"description\": \"If true, enables the BIOS bootmenu. In cases where both the image metadata and Extra Spec are set, the Extra Spec setting is used. This allows for flexibility in setting/overriding the default behavior as needed.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-20 13:41:16',NULL),(90,16,'mem_encryption','{\"title\": \"Hardware Memory Encryption\", \"description\": \"Enables encryption of guest memory at the hardware level, if there are compute hosts available which support this. See https://docs.openstack.org/nova/latest/admin/configuration/hypervisor-kvm.html#amd-sev-secure-encrypted-virtualization for details.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-20 13:41:16',NULL),(91,18,'hw_rng:allowed','{\"title\": \"Random Number Generator Allowed\", \"description\": \"\", \"type\": \"boolean\"}','2026-01-20 13:41:17',NULL),(92,18,'hw_rng:rate_bytes','{\"title\": \"Random number generator limits.\", \"description\": \"Allowed amount of bytes that the guest can read from the host\'s entropy per period.\", \"type\": \"integer\"}','2026-01-20 13:41:17',NULL),(93,18,'hw_rng:rate_period','{\"title\": \"Random number generator read period.\", \"description\": \"Duration of the read period in milliseconds.\", \"type\": \"integer\"}','2026-01-20 13:41:17',NULL),(94,19,'cpu_sockets','{\"title\": \"vCPU Sockets\", \"description\": \"Preferred number of sockets to expose to the guest.\", \"type\": \"integer\"}','2026-01-20 13:41:17',NULL),(95,19,'cpu_cores','{\"title\": \"vCPU Cores\", \"description\": \"Preferred number of cores to expose to the guest.\", \"type\": \"integer\"}','2026-01-20 13:41:17',NULL),(96,19,'cpu_threads','{\"title\": \" vCPU Threads\", \"description\": \"Preferred number of threads to expose to the guest.\", \"type\": \"integer\"}','2026-01-20 13:41:17',NULL),(97,19,'cpu_max_sockets','{\"title\": \"Max vCPU Sockets\", \"description\": \"Maximum number of sockets to expose to the guest.\", \"type\": \"integer\"}','2026-01-20 13:41:17',NULL),(98,19,'cpu_max_cores','{\"title\": \"Max vCPU Cores\", \"description\": \"Maximum number of cores to expose to the guest.\", \"type\": \"integer\"}','2026-01-20 13:41:17',NULL),(99,19,'cpu_max_threads','{\"title\": \"Max vCPU Threads\", \"description\": \"Maximum number of threads to expose to the guest.\", \"type\": \"integer\"}','2026-01-20 13:41:17',NULL),(100,20,'vmware:hw_version','{\"title\": \"VMware Hardware Version\", \"description\": \"Specifies the hardware version VMware uses to create images. If the hardware version needs to be compatible with a cluster version, for backward compatibility or other circumstances, the vmware:hw_version key specifies a virtual machine hardware version. In the event that a cluster has mixed host version types, the key will enable the vCenter to place the cluster on the correct host.\", \"type\": \"string\", \"enum\": [\"vmx-13\", \"vmx-11\", \"vmx-10\", \"vmx-09\", \"vmx-08\", \"vmx-07\", \"vmx-04\", \"vmx-03\"]}','2026-01-20 13:41:17',NULL),(101,20,'vmware:storage_policy','{\"title\": \"VMware Storage Policy\", \"description\": \"Specifies the storage policy to be applied for newly created instance. If not provided, the default storage policy specified in config file will be used. If Storage Policy Based Management (SPBM) is not enabled in config file, this value won\'t be used.\", \"type\": \"string\"}','2026-01-20 13:41:17',NULL),(102,21,'quota:cpu_limit','{\"title\": \"Quota: CPU Limit\", \"description\": \"Specifies the upper limit for CPU allocation in MHz. This parameter ensures that a machine never uses more than the defined amount of CPU time. It can be used to enforce a limit on the machine\'s CPU performance. The value should be a numerical value in MHz. If zero is supplied then the cpu_limit is unlimited.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-20 13:41:17',NULL),(103,21,'quota:cpu_reservation','{\"title\": \"Quota: CPU Reservation Limit\", \"description\": \"Specifies the guaranteed minimum CPU reservation in MHz. This means that if needed, the machine will definitely get allocated the reserved amount of CPU cycles. The value should be a numerical value in MHz.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-20 13:41:17',NULL),(104,22,'img_linked_clone','{\"title\": \"Linked Clone\", \"description\": \"By default, the VMware compute driver creates linked clones when possible (though this can be turned off by the operator). You can use this image property on a per-image basis to control whether virtual machines booted from the image are treated as full clones (value: false) or linked clones (value: true). Please refer to VMware documentation for information about full vs. linked clones.\", \"type\": \"boolean\"}','2026-01-20 13:41:17',NULL),(105,22,'vmware_adaptertype','{\"title\": \"Disk Adapter Type\", \"description\": \"The virtual SCSI or IDE controller used by the hypervisor.\", \"type\": \"string\", \"enum\": [\"lsiLogic\", \"lsiLogicsas\", \"paraVirtual\", \"busLogic\", \"ide\"], \"default\": \"lsiLogic\"}','2026-01-20 13:41:17',NULL),(106,22,'vmware_disktype','{\"title\": \"Disk Provisioning Type\", \"description\": \"When performing operations such as creating a virtual disk, cloning, or migrating, the disk provisioning type may be specified. Please refer to VMware documentation for more.\", \"type\": \"string\", \"enum\": [\"streamOptimized\", \"sparse\", \"preallocated\"], \"default\": \"preallocated\"}','2026-01-20 13:41:17',NULL),(107,22,'vmware_ostype','{\"title\": \"OS Type\", \"description\": \"A VMware GuestID which describes the operating system installed in the image. This value is passed to the hypervisor when creating a virtual machine. If not specified, the key defaults to otherGuest. See thinkvirt.com.\", \"type\": \"string\", \"enum\": [\"asianux3_64Guest\", \"asianux3Guest\", \"asianux4_64Guest\", \"asianux4Guest\", \"asianux5_64Guest\", \"asianux7_64Guest\", \"centos64Guest\", \"centosGuest\", \"centos6Guest\", \"centos6_64Guest\", \"centos7_64Guest\", \"coreos64Guest\", \"darwin10_64Guest\", \"darwin10Guest\", \"darwin11_64Guest\", \"darwin11Guest\", \"darwin12_64Guest\", \"darwin13_64Guest\", \"darwin14_64Guest\", \"darwin15_64Guest\", \"darwin16_64Guest\", \"darwin64Guest\", \"darwinGuest\", \"debian4_64Guest\", \"debian4Guest\", \"debian5_64Guest\", \"debian5Guest\", \"debian6_64Guest\", \"debian6Guest\", \"debian7_64Guest\", \"debian7Guest\", \"debian8_64Guest\", \"debian8Guest\", \"debian9_64Guest\", \"debian9Guest\", \"debian10_64Guest\", \"debian10Guest\", \"dosGuest\", \"eComStation2Guest\", \"eComStationGuest\", \"fedora64Guest\", \"fedoraGuest\", \"freebsd64Guest\", \"freebsdGuest\", \"genericLinuxGuest\", \"mandrakeGuest\", \"mandriva64Guest\", \"mandrivaGuest\", \"netware4Guest\", \"netware5Guest\", \"netware6Guest\", \"nld9Guest\", \"oesGuest\", \"openServer5Guest\", \"openServer6Guest\", \"opensuse64Guest\", \"opensuseGuest\", \"oracleLinux64Guest\", \"oracleLinuxGuest\", \"oracleLinux6Guest\", \"oracleLinux6_64Guest\", \"oracleLinux7_64Guest\", \"os2Guest\", \"other24xLinux64Guest\", \"other24xLinuxGuest\", \"other26xLinux64Guest\", \"other26xLinuxGuest\", \"other3xLinux64Guest\", \"other3xLinuxGuest\", \"otherGuest\", \"otherGuest64\", \"otherLinux64Guest\", \"otherLinuxGuest\", \"redhatGuest\", \"rhel2Guest\", \"rhel3_64Guest\", \"rhel3Guest\", \"rhel4_64Guest\", \"rhel4Guest\", \"rhel5_64Guest\", \"rhel5Guest\", \"rhel6_64Guest\", \"rhel6Guest\", \"rhel7_64Guest\", \"rhel7Guest\", \"sjdsGuest\", \"sles10_64Guest\", \"sles10Guest\", \"sles11_64Guest\", \"sles11Guest\", \"sles12_64Guest\", \"sles12Guest\", \"sles64Guest\", \"slesGuest\", \"solaris10_64Guest\", \"solaris10Guest\", \"solaris11_64Guest\", \"solaris6Guest\", \"solaris7Guest\", \"solaris8Guest\", \"solaris9Guest\", \"turboLinux64Guest\", \"turboLinuxGuest\", \"ubuntu64Guest\", \"ubuntuGuest\", \"unixWare7Guest\", \"vmkernel5Guest\", \"vmkernel6Guest\", \"vmkernel65Guest\", \"vmkernelGuest\", \"vmwarePhoton64Guest\", \"win2000AdvServGuest\", \"win2000ProGuest\", \"win2000ServGuest\", \"win31Guest\", \"win95Guest\", \"win98Guest\", \"windows7_64Guest\", \"windows7Guest\", \"windows7Server64Guest\", \"windows8_64Guest\", \"windows8Guest\", \"windows8Server64Guest\", \"windows9_64Guest\", \"windows9Guest\", \"windows9Server64Guest\", \"windowsHyperVGuest\", \"winLonghorn64Guest\", \"winLonghornGuest\", \"winMeGuest\", \"winNetBusinessGuest\", \"winNetDatacenter64Guest\", \"winNetDatacenterGuest\", \"winNetEnterprise64Guest\", \"winNetEnterpriseGuest\", \"winNetStandard64Guest\", \"winNetStandardGuest\", \"winNetWebGuest\", \"winNTGuest\", \"winVista64Guest\", \"winVistaGuest\", \"winXPHomeGuest\", \"winXPPro64Guest\", \"winXPProGuest\"], \"default\": \"otherGuest\"}','2026-01-20 13:41:17',NULL),(108,22,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor. VMware driver supported options: e1000, e1000e, VirtualE1000, VirtualE1000e, VirtualPCNet32, and VirtualVmxnet.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"VirtualE1000\", \"VirtualE1000e\", \"VirtualPCNet32\", \"VirtualVmxnet\", \"VirtualVmxnet3\"], \"default\": \"e1000\"}','2026-01-20 13:41:17',NULL),(109,22,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-20 13:41:17',NULL),(110,23,'tpm_model','{\"title\": \"TPM model\", \"description\": \"TPM model to use. Option CRB is only valid for TPM version 2.0. Defaults to TIS.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"TIS\", \"CRB\"], \"default\": \"TIS\"}','2026-01-20 13:41:18',NULL),(111,24,'COMPUTE_SECURITY_TPM_1_2','{\"title\": \"Virtual TPM Version 1.2 Support\", \"description\": \"Enables virtual TPM version 1.2.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2026-01-20 13:41:18',NULL),(112,24,'COMPUTE_SECURITY_TPM_2_0','{\"title\": \"Virtual TPM Version 2.0 Support\", \"description\": \"Enables virtual TPM version 2.0.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2026-01-20 13:41:18',NULL),(113,25,'watchdog_action','{\"title\": \"Watchdog Action\", \"description\": \"For the libvirt driver, you can enable and set the behavior of a virtual hardware watchdog device for each flavor. Watchdog devices keep an eye on the guest server, and carry out the configured action, if the server hangs. The watchdog uses the i6300esb device (emulating a PCI Intel 6300ESB). If hw_watchdog_action is not specified, the watchdog is disabled. Watchdog behavior set using a specific image\'s properties will override behavior set using flavors.\", \"type\": \"string\", \"enum\": [\"disabled\", \"reset\", \"poweroff\", \"pause\", \"none\"]}','2026-01-20 13:41:18',NULL),(114,26,'auto_disk_config','{\"title\": \"Disk Adapter Type\", \"description\": \"If true, the root partition on the disk is automatically resized before the instance boots. This value is only taken into account by the Compute service when using a Xen-based hypervisor with the XenAPI driver. The Compute service will only attempt to resize if there is a single partition on the image, and only if the partition is in ext3 or ext4 format.\", \"type\": \"boolean\"}','2026-01-20 13:41:18',NULL),(115,27,'kernel_id','{\"title\": \"Kernel ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the kernel when booting an AMI-style image.\"}','2026-01-20 13:41:18',NULL),(116,27,'ramdisk_id','{\"title\": \"Ramdisk ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the ramdisk when booting an AMI-style image.\"}','2026-01-20 13:41:18',NULL),(117,27,'instance_uuid','{\"title\": \"Instance ID\", \"type\": \"string\", \"description\": \"Metadata which can be used to record which instance this image is associated with. (Informational only, does not create an instance snapshot.)\"}','2026-01-20 13:41:18',NULL),(118,27,'architecture','{\"title\": \"CPU Architecture\", \"description\": \"The CPU architecture that must be supported by the hypervisor. For example, x86_64, arm, or ppc64. Run uname -m to get the architecture of a machine. We strongly recommend using the architecture data vocabulary defined by the libosinfo project for this purpose.\", \"type\": \"string\"}','2026-01-20 13:41:19',NULL),(119,27,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2026-01-20 13:41:19',NULL),(120,27,'hw_cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"This specifies the CPU Mode for the guest vm\", \"type\": \"string\"}','2026-01-20 13:41:19',NULL),(121,27,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2026-01-20 13:41:19',NULL),(122,27,'description','{\"title\": \"Image description\", \"description\": \"A human-readable string describing this image.\", \"type\": \"string\"}','2026-01-20 13:41:19',NULL),(123,27,'cinder_encryption_key_id','{\"title\": \"Cinder Encryption Key ID\", \"description\": \"Identifier in the OpenStack Key Management Service for the encryption key for the Block Storage Service to use when mounting a volume created from this image\", \"type\": \"string\"}','2026-01-20 13:41:19',NULL),(124,27,'cinder_encryption_key_deletion_policy','{\"title\": \"Cinder Encryption Key Deletion Policy\", \"description\": \"States the condition under which the Image Service will delete the object associated with the \'cinder_encryption_key_id\' image property.  If this property is missing, the Image Service will take no action\", \"type\": \"string\", \"enum\": [\"on_image_deletion\", \"do_not_delete\"]}','2026-01-20 13:41:19',NULL),(125,28,'img_signature','{\"title\": \"Image Signature\", \"description\": \"The signature of the image data encoded in base64 format.\", \"type\": \"string\"}','2026-01-20 13:41:19',NULL),(126,28,'img_signature_certificate_uuid','{\"title\": \"Image Signature Certificate UUID\", \"description\": \"The UUID used to retrieve the certificate from the key manager.\", \"type\": \"string\"}','2026-01-20 13:41:19',NULL),(127,28,'img_signature_hash_method','{\"title\": \"Image Signature Hash Method\", \"description\": \"The hash method used in creating the signature.\", \"type\": \"string\", \"enum\": [\"SHA-224\", \"SHA-256\", \"SHA-384\", \"SHA-512\"]}','2026-01-20 13:41:19',NULL),(128,28,'img_signature_key_type','{\"title\": \"Image Signature Key Type\", \"description\": \"The key type used in creating the signature.\", \"type\": \"string\", \"enum\": [\"RSA-PSS\", \"DSA\", \"ECC_SECT571K1\", \"ECC_SECT409K1\", \"ECC_SECT571R1\", \"ECC_SECT409R1\", \"ECC_SECP521R1\", \"ECC_SECP384R1\"]}','2026-01-20 13:41:19',NULL),(129,29,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2026-01-20 13:41:19',NULL),(130,29,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2026-01-20 13:41:19',NULL),(131,29,'os_admin_user','{\"title\": \"OS Admin User\", \"description\": \"The name of the user with admin privileges.\", \"type\": \"string\"}','2026-01-20 13:41:19',NULL),(132,33,'img_volume_type','{\"title\": \"Image Volume Type\", \"description\": \"Specifies the volume type that should be applied during new volume creation with a image. This value is passed to Cinder when creating a new volume. Priority of volume type related parameters are 1.volume_type(via API or CLI), 2.cinder_img_volume_type, 3.default_volume_type(via cinder.conf). If not specified, volume_type or default_volume_type will be referred based on their priority.\", \"type\": \"string\"}','2026-01-20 13:41:19',NULL);
/*!40000 ALTER TABLE `metadef_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_resource_types`
--

DROP TABLE IF EXISTS `metadef_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_resource_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `protected` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_resource_types_name` (`name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_resource_types`
--

LOCK TABLES `metadef_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_resource_types` (`id`, `name`, `protected`, `created_at`, `updated_at`) VALUES (1,'OS::Cinder::Volume',1,'2026-01-20 13:41:12',NULL),(2,'OS::Glance::Image',1,'2026-01-20 13:41:12',NULL),(3,'OS::Nova::Aggregate',1,'2026-01-20 13:41:13',NULL),(4,'OS::Nova::Flavor',1,'2026-01-20 13:41:13',NULL),(5,'OS::Nova::Server',1,'2026-01-20 13:41:13',NULL),(6,'OS::Trove::Instance',1,'2026-01-20 13:41:19',NULL);
/*!40000 ALTER TABLE `metadef_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_tags`
--

DROP TABLE IF EXISTS `metadef_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_tags_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_tags_name` (`name`),
  CONSTRAINT `metadef_tags_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_tags`
--

LOCK TABLES `metadef_tags` WRITE;
/*!40000 ALTER TABLE `metadef_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadef_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_info`
--

DROP TABLE IF EXISTS `task_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_info` (
  `task_id` varchar(36) NOT NULL,
  `input` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  CONSTRAINT `task_info_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_info`
--

LOCK TABLES `task_info` WRITE;
/*!40000 ALTER TABLE `task_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` varchar(36) NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `image_id` varchar(36) DEFAULT NULL,
  `request_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_tasks_deleted` (`deleted`),
  KEY `ix_tasks_owner` (`owner`),
  KEY `ix_tasks_status` (`status`),
  KEY `ix_tasks_type` (`type`),
  KEY `ix_tasks_updated_at` (`updated_at`),
  KEY `ix_tasks_image_id` (`image_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `keystone`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `keystone` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `keystone`;

--
-- Table structure for table `access_rule`
--

DROP TABLE IF EXISTS `access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(64) DEFAULT NULL,
  `path` varchar(128) DEFAULT NULL,
  `method` varchar(16) DEFAULT NULL,
  `external_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_rule_external_id_key` (`external_id`),
  UNIQUE KEY `duplicate_access_rule_for_user_constraint` (`user_id`,`service`,`path`,`method`),
  KEY `user_id` (`user_id`),
  KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_rule`
--

LOCK TABLES `access_rule` WRITE;
/*!40000 ALTER TABLE `access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_token`
--

DROP TABLE IF EXISTS `access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_token` (
  `id` varchar(64) NOT NULL,
  `access_secret` varchar(64) NOT NULL,
  `authorizing_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  `role_ids` text NOT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_access_token_authorizing_user_id` (`authorizing_user_id`),
  KEY `ix_access_token_consumer_id` (`consumer_id`),
  CONSTRAINT `access_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_token`
--

LOCK TABLES `access_token` WRITE;
/*!40000 ALTER TABLE `access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('29e87d24a316'),('e25ffa003242');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential`
--

DROP TABLE IF EXISTS `application_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential` (
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `secret_hash` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `system` varchar(64) DEFAULT NULL,
  `unrestricted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `duplicate_app_cred_constraint` (`user_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential`
--

LOCK TABLES `application_credential` WRITE;
/*!40000 ALTER TABLE `application_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_access_rule`
--

DROP TABLE IF EXISTS `application_credential_access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_access_rule` (
  `application_credential_id` int(11) NOT NULL,
  `access_rule_id` int(11) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`access_rule_id`),
  KEY `access_rule_id` (`access_rule_id`),
  CONSTRAINT `application_credential_access_rule_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE,
  CONSTRAINT `application_credential_access_rule_ibfk_2` FOREIGN KEY (`access_rule_id`) REFERENCES `access_rule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_access_rule`
--

LOCK TABLES `application_credential_access_rule` WRITE;
/*!40000 ALTER TABLE `application_credential_access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_role`
--

DROP TABLE IF EXISTS `application_credential_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_role` (
  `application_credential_id` int(11) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`role_id`),
  CONSTRAINT `application_credential_role_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_role`
--

LOCK TABLES `application_credential_role` WRITE;
/*!40000 ALTER TABLE `application_credential_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assignment` (
  `type` enum('UserProject','GroupProject','UserDomain','GroupDomain') NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  KEY `ix_actor_id` (`actor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserProject','0571fdb3621349bf94eb2c6bf0dfc036','d5b132113da54ff6b616e719b9c45446','35591c5f8aef439eb27c5fa09913a1af',0),('UserProject','0571fdb3621349bf94eb2c6bf0dfc036','d5b132113da54ff6b616e719b9c45446','8840d7a5644c44f5a9cc7c7914e8294b',0),('UserProject','15e2d293aecb44f4b8fadb4968d7c65b','d5b132113da54ff6b616e719b9c45446','35591c5f8aef439eb27c5fa09913a1af',0),('UserProject','15e2d293aecb44f4b8fadb4968d7c65b','d5b132113da54ff6b616e719b9c45446','8840d7a5644c44f5a9cc7c7914e8294b',0),('UserProject','34d7ff46e7af49a7aff3be601c2bd8cd','4e7b863e1a5b4a8bb85e8466fecb8db2','23a80ab837af4318bc158d03137a0e60',0),('UserProject','34d7ff46e7af49a7aff3be601c2bd8cd','4e7b863e1a5b4a8bb85e8466fecb8db2','8840d7a5644c44f5a9cc7c7914e8294b',0),('UserProject','34d7ff46e7af49a7aff3be601c2bd8cd','7d598ceddee84859b24e9602515f3a9d','8840d7a5644c44f5a9cc7c7914e8294b',0),('UserProject','549ebda85aa94cd6873c7ba778b288a7','d5b132113da54ff6b616e719b9c45446','35591c5f8aef439eb27c5fa09913a1af',0),('UserProject','549ebda85aa94cd6873c7ba778b288a7','d5b132113da54ff6b616e719b9c45446','8840d7a5644c44f5a9cc7c7914e8294b',0),('UserProject','9588bb9575134e6880029019353bcaaa','d5b132113da54ff6b616e719b9c45446','35591c5f8aef439eb27c5fa09913a1af',0),('UserProject','9588bb9575134e6880029019353bcaaa','d5b132113da54ff6b616e719b9c45446','8840d7a5644c44f5a9cc7c7914e8294b',0),('UserProject','bfd92bb80917444799f1ff7c247bb729','d5b132113da54ff6b616e719b9c45446','35591c5f8aef439eb27c5fa09913a1af',0),('UserProject','bfd92bb80917444799f1ff7c247bb729','d5b132113da54ff6b616e719b9c45446','8840d7a5644c44f5a9cc7c7914e8294b',0),('UserProject','c15645875c0f4d0e88d2a015f8b104c2','d5b132113da54ff6b616e719b9c45446','35591c5f8aef439eb27c5fa09913a1af',0),('UserProject','c15645875c0f4d0e88d2a015f8b104c2','d5b132113da54ff6b616e719b9c45446','8840d7a5644c44f5a9cc7c7914e8294b',0),('UserProject','d2b9e6d2b72b445bab1a5d191f790af1','d5b132113da54ff6b616e719b9c45446','35591c5f8aef439eb27c5fa09913a1af',0),('UserProject','d2b9e6d2b72b445bab1a5d191f790af1','d5b132113da54ff6b616e719b9c45446','8840d7a5644c44f5a9cc7c7914e8294b',0),('UserProject','d9d129f8ada2471a84ab007bbc1a55d6','d5b132113da54ff6b616e719b9c45446','7e9f70942fec45deb0c99fd133db391a',0),('UserProject','d9d129f8ada2471a84ab007bbc1a55d6','d5b132113da54ff6b616e719b9c45446','8840d7a5644c44f5a9cc7c7914e8294b',0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_register`
--

DROP TABLE IF EXISTS `config_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_register` (
  `type` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_register`
--

LOCK TABLES `config_register` WRITE;
/*!40000 ALTER TABLE `config_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `config_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumer`
--

DROP TABLE IF EXISTS `consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumer` (
  `id` varchar(64) NOT NULL,
  `description` varchar(64) DEFAULT NULL,
  `secret` varchar(64) NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumer`
--

LOCK TABLES `consumer` WRITE;
/*!40000 ALTER TABLE `consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credential` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `key_hash` varchar(64) NOT NULL,
  `encrypted_blob` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint` (
  `id` varchar(64) NOT NULL,
  `legacy_endpoint_id` varchar(64) DEFAULT NULL,
  `interface` varchar(8) NOT NULL,
  `service_id` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `region_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_endpoint_region_id` (`region_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `endpoint_service_id_fkey` FOREIGN KEY (`service_id`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_endpoint_region_id` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
INSERT INTO `endpoint` (`id`, `legacy_endpoint_id`, `interface`, `service_id`, `url`, `extra`, `enabled`, `region_id`) VALUES ('058c0d6dedc14035ac798874f7ac175d',NULL,'internal','4aa92dc550804b2f8336f0f453f74b9b','https://keystone-internal.openstack.svc:5000','{}',1,'regionOne'),('1bb80644f3224a2ea03b286cb5109ee7',NULL,'public','6ba3a571ca864d369a674307d594c9a4','https://neutron-public-openstack.apps-crc.testing','{\"name\": \"neutron\"}',1,'regionOne'),('1e4da805a72f4a4b8443ae8380f32ef7',NULL,'public','3deb712684bc4d70a2bd68b2796e9de5','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne'),('44b017702a514fc088a7a9c01fcf867a',NULL,'internal','3deb712684bc4d70a2bd68b2796e9de5','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne'),('5cc52482ecfc41929def229642399d73',NULL,'public','ba9b09d84c304531bec645a1193a89c7','https://nova-public-openstack.apps-crc.testing/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('6504893006664c229f2fdaaa12fe73e4',NULL,'public','9cfe4b5231bb40d8aab35cb8bf62d7fb','https://glance-default-public-openstack.apps-crc.testing','{\"name\": \"glance\"}',1,'regionOne'),('86d17f3b8cad43589e545ec438dbb2f5',NULL,'internal','6ba3a571ca864d369a674307d594c9a4','https://neutron-internal.openstack.svc:9696','{\"name\": \"neutron\"}',1,'regionOne'),('8a860cf7aa5048b7b6be0b39fe8e5154',NULL,'internal','2137298014494960937be604e37746c5','https://placement-internal.openstack.svc:8778','{\"name\": \"placement\"}',1,'regionOne'),('927a26cae66d4a4cb6f27aeb1517080e',NULL,'internal','b7eecfd0562d486dbe12b2f536566536','https://cinder-internal.openstack.svc:8776/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('a0a03344197e433f8c31dae12584f3ce',NULL,'public','2137298014494960937be604e37746c5','https://placement-public-openstack.apps-crc.testing','{\"name\": \"placement\"}',1,'regionOne'),('b14b963162104ea38753399748987a73',NULL,'internal','9cfe4b5231bb40d8aab35cb8bf62d7fb','https://glance-default-internal.openstack.svc:9292','{\"name\": \"glance\"}',1,'regionOne'),('b2dccf590a514071bfbe17fc0ca3d6b4',NULL,'public','c207768545e0472ca9899989ed9ebcdc','https://barbican-public-openstack.apps-crc.testing','{\"name\": \"barbican\"}',1,'regionOne'),('b5e73b537a494552a2460a5028a2c399',NULL,'public','4aa92dc550804b2f8336f0f453f74b9b','https://keystone-public-openstack.apps-crc.testing','{}',1,'regionOne'),('b8b589c07bc74d14b05379652b23a988',NULL,'internal','c207768545e0472ca9899989ed9ebcdc','https://barbican-internal.openstack.svc:9311','{\"name\": \"barbican\"}',1,'regionOne'),('d6ab8e3a0b974e628ec99bcc4e0415ed',NULL,'public','b7eecfd0562d486dbe12b2f536566536','https://cinder-public-openstack.apps-crc.testing/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('e22fa0a495b24e07a302df858dec33e6',NULL,'internal','ba9b09d84c304531bec645a1193a89c7','https://nova-internal.openstack.svc:8774/v2.1','{\"name\": \"nova\"}',1,'regionOne');
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint_group`
--

DROP TABLE IF EXISTS `endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint_group` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `filters` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint_group`
--

LOCK TABLES `endpoint_group` WRITE;
/*!40000 ALTER TABLE `endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expiring_user_group_membership`
--

DROP TABLE IF EXISTS `expiring_user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expiring_user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `last_verified` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`,`idp_id`),
  KEY `group_id` (`group_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_3` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expiring_user_group_membership`
--

LOCK TABLES `expiring_user_group_membership` WRITE;
/*!40000 ALTER TABLE `expiring_user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `expiring_user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federated_user`
--

DROP TABLE IF EXISTS `federated_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federated_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `protocol_id` varchar(64) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idp_id` (`idp_id`,`protocol_id`,`unique_id`),
  KEY `federated_user_protocol_id_fkey` (`protocol_id`,`idp_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `federated_user_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_ibfk_2` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_protocol_id_fkey` FOREIGN KEY (`protocol_id`, `idp_id`) REFERENCES `federation_protocol` (`id`, `idp_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federated_user`
--

LOCK TABLES `federated_user` WRITE;
/*!40000 ALTER TABLE `federated_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `federated_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federation_protocol`
--

DROP TABLE IF EXISTS `federation_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federation_protocol` (
  `id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `mapping_id` varchar(64) NOT NULL,
  `remote_id_attribute` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`,`idp_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `federation_protocol_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federation_protocol`
--

LOCK TABLES `federation_protocol` WRITE;
/*!40000 ALTER TABLE `federation_protocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `federation_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group`
--

DROP TABLE IF EXISTS `group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group` (
  `id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_group_name_domain_id` (`domain_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group`
--

LOCK TABLES `group` WRITE;
/*!40000 ALTER TABLE `group` DISABLE KEYS */;
/*!40000 ALTER TABLE `group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `id_mapping`
--

DROP TABLE IF EXISTS `id_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `id_mapping` (
  `public_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `local_id` varchar(255) NOT NULL,
  `entity_type` enum('user','group') NOT NULL,
  PRIMARY KEY (`public_id`),
  UNIQUE KEY `domain_id` (`domain_id`,`local_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `id_mapping`
--

LOCK TABLES `id_mapping` WRITE;
/*!40000 ALTER TABLE `id_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `id_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `identity_provider`
--

DROP TABLE IF EXISTS `identity_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `identity_provider` (
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `authorization_ttl` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `identity_provider`
--

LOCK TABLES `identity_provider` WRITE;
/*!40000 ALTER TABLE `identity_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `identity_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `idp_remote_ids`
--

DROP TABLE IF EXISTS `idp_remote_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `idp_remote_ids` (
  `idp_id` varchar(64) DEFAULT NULL,
  `remote_id` varchar(255) NOT NULL,
  PRIMARY KEY (`remote_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `idp_remote_ids_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `idp_remote_ids`
--

LOCK TABLES `idp_remote_ids` WRITE;
/*!40000 ALTER TABLE `idp_remote_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `idp_remote_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `implied_role`
--

DROP TABLE IF EXISTS `implied_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `implied_role` (
  `prior_role_id` varchar(64) NOT NULL,
  `implied_role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`prior_role_id`,`implied_role_id`),
  KEY `implied_role_implied_role_id_fkey` (`implied_role_id`),
  CONSTRAINT `implied_role_implied_role_id_fkey` FOREIGN KEY (`implied_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE,
  CONSTRAINT `implied_role_prior_role_id_fkey` FOREIGN KEY (`prior_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `implied_role`
--

LOCK TABLES `implied_role` WRITE;
/*!40000 ALTER TABLE `implied_role` DISABLE KEYS */;
INSERT INTO `implied_role` (`prior_role_id`, `implied_role_id`) VALUES ('7e9f70942fec45deb0c99fd133db391a','9033e069d03e40e1b18e26b64665a511'),('8840d7a5644c44f5a9cc7c7914e8294b','7e9f70942fec45deb0c99fd133db391a');
/*!40000 ALTER TABLE `implied_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `limit`
--

DROP TABLE IF EXISTS `limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `limit` (
  `id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `resource_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `registered_limit_id` varchar(64) DEFAULT NULL,
  `domain_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `limit_id_key` (`id`),
  KEY `registered_limit_id` (`registered_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `limit`
--

LOCK TABLES `limit` WRITE;
/*!40000 ALTER TABLE `limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_user`
--

DROP TABLE IF EXISTS `local_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `local_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `failed_auth_count` int(11) DEFAULT NULL,
  `failed_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_id` (`domain_id`,`name`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `local_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `local_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=254 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `local_user`
--

LOCK TABLES `local_user` WRITE;
/*!40000 ALTER TABLE `local_user` DISABLE KEYS */;
INSERT INTO `local_user` (`id`, `user_id`, `domain_id`, `name`, `failed_auth_count`, `failed_auth_at`) VALUES (1,'34d7ff46e7af49a7aff3be601c2bd8cd','default','admin',0,NULL),(2,'0571fdb3621349bf94eb2c6bf0dfc036','default','cinder',0,NULL),(3,'d2b9e6d2b72b445bab1a5d191f790af1','default','glance',0,NULL),(4,'9588bb9575134e6880029019353bcaaa','default','ceilometer',0,NULL),(5,'549ebda85aa94cd6873c7ba778b288a7','default','barbican',0,NULL),(6,'bfd92bb80917444799f1ff7c247bb729','default','nova',0,NULL),(7,'15e2d293aecb44f4b8fadb4968d7c65b','default','neutron',0,NULL),(8,'c15645875c0f4d0e88d2a015f8b104c2','default','placement',0,NULL),(9,'d9d129f8ada2471a84ab007bbc1a55d6','default','swift',0,NULL),(10,'78e955b46859498ab7cd8a3114b2053d','default','demo_tempestconf',0,NULL),(11,'20793d17eed149f9952ec71136356d92','default','alt_demo_tempestconf',0,NULL);
/*!40000 ALTER TABLE `local_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mapping`
--

DROP TABLE IF EXISTS `mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mapping` (
  `id` varchar(64) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mapping`
--

LOCK TABLES `mapping` WRITE;
/*!40000 ALTER TABLE `mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nonlocal_user`
--

DROP TABLE IF EXISTS `nonlocal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nonlocal_user` (
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  PRIMARY KEY (`domain_id`,`name`),
  UNIQUE KEY `ixu_nonlocal_user_user_id` (`user_id`),
  KEY `nonlocal_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `nonlocal_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nonlocal_user`
--

LOCK TABLES `nonlocal_user` WRITE;
/*!40000 ALTER TABLE `nonlocal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `nonlocal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password`
--

DROP TABLE IF EXISTS `password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_user_id` int(11) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `self_service` tinyint(1) NOT NULL DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `created_at_int` bigint(20) NOT NULL DEFAULT 0,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `local_user_id` (`local_user_id`),
  CONSTRAINT `password_ibfk_1` FOREIGN KEY (`local_user_id`) REFERENCES `local_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=254 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password`
--

LOCK TABLES `password` WRITE;
/*!40000 ALTER TABLE `password` DISABLE KEYS */;
INSERT INTO `password` (`id`, `local_user_id`, `expires_at`, `self_service`, `password_hash`, `created_at_int`, `expires_at_int`, `created_at`) VALUES (1,1,NULL,0,'$2b$12$5bWXHShCY1ZTQ0MIVY/9P.cUjAz2GtVmkuAZiKP13JHbleBprUgey',1768916453690115,NULL,'2026-01-20 13:40:53'),(2,2,NULL,0,'$2b$12$MvLHzNNnbFbgd.rlqfG8YeO42nsMghlQ1FEBHmXal25IWsp7sWEWe',1768916523452975,NULL,'2026-01-20 13:42:03'),(3,3,NULL,0,'$2b$12$3XY1q/x6nuMMrLkSXNd.0OROtb58qoGRFZY/8DstV/HCUazob6Dv.',1768916530564156,NULL,'2026-01-20 13:42:10'),(4,4,NULL,0,'$2b$12$yHxK3qkcQjsSbDhJxKdE1uWgf.pxdBEy5ZobfkBGdtPY6X7xDOsDO',1768916534232999,NULL,'2026-01-20 13:42:14'),(5,5,NULL,0,'$2b$12$Cy7jlL1loUuAIvGxPDzci./qqR4sWLk1Iq6Rv0PjnaNu5Ek4/wDrG',1768916537721031,NULL,'2026-01-20 13:42:17'),(6,6,NULL,0,'$2b$12$VyB5wjk1T9ISwtWbQ6h8KeBqUR0JkVwQwjA3VpPDeS5Zijus2zVqq',1768916540646910,NULL,'2026-01-20 13:42:20'),(7,7,NULL,0,'$2b$12$2KyWE1sl/m1R8nUZpfJH5uhn01zCgVX7sDeHwFh1X0lfLyqeafc1i',1768916544665879,NULL,'2026-01-20 13:42:24'),(8,8,NULL,0,'$2b$12$8t93E3Hyc97iqhRG3MgufepvKImvwe5NMtLNDGvmyTioQ2noTe7aa',1768916550128747,NULL,'2026-01-20 13:42:30'),(9,9,NULL,0,'$2b$12$9CVtIqe9Q8MdYywf82o16uZjL1GCKLOsqnAKq44WjR9zpe3ay6g8O',1768917534521008,NULL,'2026-01-20 13:58:54'),(10,10,NULL,0,'$2b$12$LxVnMRl0u/oPvaq02hdLV.INnmjRzjNkPLaGP0aW6JRqeR35yb1de',1768918909068710,NULL,'2026-01-20 14:21:49'),(11,11,NULL,0,'$2b$12$vIS8hPe.CEhKRJb0zz/VNeWGNp/qNiRS1uwBLb5Ml8Ws2JtWEqvdW',1768918909837356,NULL,'2026-01-20 14:21:49');
/*!40000 ALTER TABLE `password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `blob` text NOT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_association`
--

DROP TABLE IF EXISTS `policy_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy_association` (
  `id` varchar(64) NOT NULL,
  `policy_id` varchar(64) NOT NULL,
  `endpoint_id` varchar(64) DEFAULT NULL,
  `service_id` varchar(64) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `endpoint_id` (`endpoint_id`,`service_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_association`
--

LOCK TABLES `policy_association` WRITE;
/*!40000 ALTER TABLE `policy_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project` (
  `id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL,
  `is_domain` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_project_name_domain_id` (`domain_id`,`name`),
  KEY `project_parent_id_fkey` (`parent_id`),
  CONSTRAINT `project_domain_id_fkey` FOREIGN KEY (`domain_id`) REFERENCES `project` (`id`),
  CONSTRAINT `project_parent_id_fkey` FOREIGN KEY (`parent_id`) REFERENCES `project` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
INSERT INTO `project` (`id`, `name`, `extra`, `description`, `enabled`, `domain_id`, `parent_id`, `is_domain`) VALUES ('4e7b863e1a5b4a8bb85e8466fecb8db2','admin','{}','Bootstrap project for initializing the cloud.',1,'default','default',0),('7d598ceddee84859b24e9602515f3a9d','demo','{}','Project for Tempest demo_tempestconf user',1,'default','default',0),('<<keystone.domain.root>>','<<keystone.domain.root>>','{}','',0,'<<keystone.domain.root>>',NULL,1),('b7a779ee9b29438da0f1f05d7922ccc4','alt_demo','{}','Project for Tempest alt_demo_tempestconf user',1,'default','default',0),('d5b132113da54ff6b616e719b9c45446','service','{}','service',1,'default','default',0),('default','Default','{}','The default domain',1,'<<keystone.domain.root>>',NULL,1);
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint`
--

DROP TABLE IF EXISTS `project_endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint` (
  `endpoint_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint`
--

LOCK TABLES `project_endpoint` WRITE;
/*!40000 ALTER TABLE `project_endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint_group`
--

DROP TABLE IF EXISTS `project_endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint_group` (
  `endpoint_group_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_group_id`,`project_id`),
  CONSTRAINT `project_endpoint_group_ibfk_1` FOREIGN KEY (`endpoint_group_id`) REFERENCES `endpoint_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint_group`
--

LOCK TABLES `project_endpoint_group` WRITE;
/*!40000 ALTER TABLE `project_endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_option`
--

DROP TABLE IF EXISTS `project_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_option` (
  `project_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`project_id`,`option_id`),
  CONSTRAINT `project_option_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_option`
--

LOCK TABLES `project_option` WRITE;
/*!40000 ALTER TABLE `project_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_tag`
--

DROP TABLE IF EXISTS `project_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_tag` (
  `project_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`project_id`,`name`),
  UNIQUE KEY `project_id` (`project_id`,`name`),
  CONSTRAINT `project_tag_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_tag`
--

LOCK TABLES `project_tag` WRITE;
/*!40000 ALTER TABLE `project_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `parent_region_id` varchar(255) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` (`id`, `description`, `parent_region_id`, `extra`) VALUES ('regionOne','',NULL,'{}');
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registered_limit`
--

DROP TABLE IF EXISTS `registered_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `registered_limit` (
  `id` varchar(64) NOT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `default_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `registered_limit_id_key` (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `registered_limit`
--

LOCK TABLES `registered_limit` WRITE;
/*!40000 ALTER TABLE `registered_limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `registered_limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_token`
--

DROP TABLE IF EXISTS `request_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_token` (
  `id` varchar(64) NOT NULL,
  `request_secret` varchar(64) NOT NULL,
  `verifier` varchar(64) DEFAULT NULL,
  `authorizing_user_id` varchar(64) DEFAULT NULL,
  `requested_project_id` varchar(64) NOT NULL,
  `role_ids` text DEFAULT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_request_token_consumer_id` (`consumer_id`),
  CONSTRAINT `request_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_token`
--

LOCK TABLES `request_token` WRITE;
/*!40000 ALTER TABLE `request_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revocation_event`
--

DROP TABLE IF EXISTS `revocation_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revocation_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` varchar(64) DEFAULT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  `role_id` varchar(64) DEFAULT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `consumer_id` varchar(64) DEFAULT NULL,
  `access_token_id` varchar(64) DEFAULT NULL,
  `issued_before` datetime NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `revoked_at` datetime NOT NULL,
  `audit_id` varchar(32) DEFAULT NULL,
  `audit_chain_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_revocation_event_new_revoked_at` (`revoked_at`),
  KEY `ix_revocation_event_issued_before` (`issued_before`),
  KEY `ix_revocation_event_project_id_issued_before` (`project_id`,`issued_before`),
  KEY `ix_revocation_event_user_id_issued_before` (`user_id`,`issued_before`),
  KEY `ix_revocation_event_audit_id_issued_before` (`audit_id`,`issued_before`)
) ENGINE=InnoDB AUTO_INCREMENT=482 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revocation_event`
--

LOCK TABLES `revocation_event` WRITE;
/*!40000 ALTER TABLE `revocation_event` DISABLE KEYS */;
INSERT INTO `revocation_event` (`id`, `domain_id`, `project_id`, `user_id`, `role_id`, `trust_id`, `consumer_id`, `access_token_id`, `issued_before`, `expires_at`, `revoked_at`, `audit_id`, `audit_chain_id`) VALUES (1,NULL,NULL,'e0cedffc537441188af48cac1bb04e93',NULL,NULL,NULL,NULL,'2026-01-20 14:22:34',NULL,'2026-01-20 14:22:34',NULL,NULL),(2,NULL,NULL,'fd6fbe96b2784c329d8b9be1aed6dc06',NULL,NULL,NULL,NULL,'2026-01-20 14:22:35',NULL,'2026-01-20 14:22:35',NULL,NULL),(3,NULL,NULL,'ae7030f5b5374539ad2c025130fbfd0e',NULL,NULL,NULL,NULL,'2026-01-20 14:22:36',NULL,'2026-01-20 14:22:36',NULL,NULL),(4,NULL,NULL,'efa21ae346f54e28b859a231a63154d2',NULL,NULL,NULL,NULL,'2026-01-20 14:22:37',NULL,'2026-01-20 14:22:37',NULL,NULL),(5,NULL,'74467dd374044c1493aae7a907eea88d',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:22:39',NULL,'2026-01-20 14:22:39',NULL,NULL),(6,NULL,'70a591718c3c414a9b97b90eb2c2c7b3',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:22:39',NULL,'2026-01-20 14:22:39',NULL,NULL),(7,NULL,'077e4a3a901c4f9898b8b5924ec42f42',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:22:42',NULL,'2026-01-20 14:22:42',NULL,NULL),(8,NULL,'124535c44e844c129c9ab69ffb080850',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:22:42',NULL,'2026-01-20 14:22:42',NULL,NULL),(9,NULL,NULL,'16db21b3a0a44ee1a85ef6b3f39a8841',NULL,NULL,NULL,NULL,'2026-01-20 14:22:46',NULL,'2026-01-20 14:22:46',NULL,NULL),(10,NULL,NULL,'b23708d5c14348ac8538982b951190f6',NULL,NULL,NULL,NULL,'2026-01-20 14:22:46',NULL,'2026-01-20 14:22:46',NULL,NULL),(11,NULL,NULL,'6fc30630eebd44a99bebbb1eb2ef90b8',NULL,NULL,NULL,NULL,'2026-01-20 14:22:47',NULL,'2026-01-20 14:22:47',NULL,NULL),(12,NULL,NULL,'a638d6e4d5d54d9db87a5bb5b0cb8d5b',NULL,NULL,NULL,NULL,'2026-01-20 14:22:47',NULL,'2026-01-20 14:22:47',NULL,NULL),(13,NULL,'ae256a7a735347c8917f6ed6d61ba661',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:22:48',NULL,'2026-01-20 14:22:48',NULL,NULL),(14,NULL,'95f31f24fd474f418a958ae1b9870a8d',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:22:48',NULL,'2026-01-20 14:22:48',NULL,NULL),(15,NULL,'109750b2418a466996471b1f9c140f54',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:22:49',NULL,'2026-01-20 14:22:49',NULL,NULL),(16,NULL,'dad7826c0ede4471b82a3e232e7ac178',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:22:49',NULL,'2026-01-20 14:22:49',NULL,NULL),(17,NULL,NULL,'d4152b6ae38e4f669d263a862e49e7d2',NULL,NULL,NULL,NULL,'2026-01-20 14:22:57',NULL,'2026-01-20 14:22:57',NULL,NULL),(18,NULL,NULL,'b6af53bd17694b6997026eefa6b23621',NULL,NULL,NULL,NULL,'2026-01-20 14:22:58',NULL,'2026-01-20 14:22:58',NULL,NULL),(19,NULL,'7d9eeb9ec5644e4db920dac09a96e230',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:23:04',NULL,'2026-01-20 14:23:04',NULL,NULL),(20,NULL,'d587e25019ea40d7ad9052e9711bdced',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:23:09',NULL,'2026-01-20 14:23:09',NULL,NULL),(21,NULL,NULL,'fdfb8388f714407087df1fad6a87ae5c',NULL,NULL,NULL,NULL,'2026-01-20 14:23:15',NULL,'2026-01-20 14:23:15',NULL,NULL),(22,NULL,NULL,'fd3c4b62733a4b01911a69589fdd8963',NULL,NULL,NULL,NULL,'2026-01-20 14:23:15',NULL,'2026-01-20 14:23:15',NULL,NULL),(23,NULL,'159c2c286d1d4220b3a152cbd3692584',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:23:18',NULL,'2026-01-20 14:23:18',NULL,NULL),(24,NULL,'b5fba2405ac1466a8423add239a2c35a',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:23:19',NULL,'2026-01-20 14:23:19',NULL,NULL),(25,NULL,NULL,'dce111606d9247748878c3371deb24b3',NULL,NULL,NULL,NULL,'2026-01-20 14:23:24',NULL,'2026-01-20 14:23:24',NULL,NULL),(26,NULL,NULL,'27bbeb2c163b492b8cfbbeaa720c03bc',NULL,NULL,NULL,NULL,'2026-01-20 14:23:24',NULL,'2026-01-20 14:23:24',NULL,NULL),(27,NULL,'31c15f3b49b44ceb9c67f7b6b94cb348',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:23:26',NULL,'2026-01-20 14:23:26',NULL,NULL),(28,NULL,'ecc7ff9185e34e03b5ef3b4c7913f835',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:23:27',NULL,'2026-01-20 14:23:27',NULL,NULL),(29,NULL,NULL,'dc4c49f2a0534d64ab4f1288469ed68c',NULL,NULL,NULL,NULL,'2026-01-20 14:23:32',NULL,'2026-01-20 14:23:32',NULL,NULL),(30,NULL,NULL,'f1ddf107c2214e9ba5bc797e4cc0e037',NULL,NULL,NULL,NULL,'2026-01-20 14:23:32',NULL,'2026-01-20 14:23:32',NULL,NULL),(31,NULL,'5265827963b84070a6a583b02f3c0b48',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:23:38',NULL,'2026-01-20 14:23:38',NULL,NULL),(32,NULL,'11309a20fa3141298bc533588b47cd00',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:23:40',NULL,'2026-01-20 14:23:40',NULL,NULL),(33,NULL,NULL,'4ce1ee89815e441db57f04d586c4f110',NULL,NULL,NULL,NULL,'2026-01-20 14:23:49',NULL,'2026-01-20 14:23:49',NULL,NULL),(34,NULL,NULL,'f1bdfa3d23c34d8286000434f50b18de',NULL,NULL,NULL,NULL,'2026-01-20 14:23:49',NULL,'2026-01-20 14:23:49',NULL,NULL),(35,NULL,'1c1189351dc4432b9b11cef164ae7866',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:23:51',NULL,'2026-01-20 14:23:51',NULL,NULL),(36,NULL,'e02b25959e8e4d5986ff9d8da5cd695f',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:23:52',NULL,'2026-01-20 14:23:52',NULL,NULL),(37,NULL,NULL,'918f290d4c414b71807eacf0b27ad165',NULL,NULL,NULL,NULL,'2026-01-20 14:24:21',NULL,'2026-01-20 14:24:21',NULL,NULL),(38,NULL,'e024eef627014f829fa6e45ffe36c281',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:24:24',NULL,'2026-01-20 14:24:24',NULL,NULL),(39,NULL,NULL,'32a16ea2839748629233294de19222b3',NULL,NULL,NULL,NULL,'2026-01-20 14:24:56',NULL,'2026-01-20 14:24:56',NULL,NULL),(40,NULL,NULL,'e85c68e62be84ebaa5717f7d7e497275',NULL,NULL,NULL,NULL,'2026-01-20 14:24:56',NULL,'2026-01-20 14:24:56',NULL,NULL),(41,NULL,NULL,'6d292784a7494358a137fea52feffec0',NULL,NULL,NULL,NULL,'2026-01-20 14:24:57',NULL,'2026-01-20 14:24:57',NULL,NULL),(42,NULL,NULL,'0167905b37e04d22b41125ba80c626ca',NULL,NULL,NULL,NULL,'2026-01-20 14:24:57',NULL,'2026-01-20 14:24:57',NULL,NULL),(43,NULL,NULL,'fcfea6d5aa8c43228e6b2ba5e902b803',NULL,NULL,NULL,NULL,'2026-01-20 14:24:57',NULL,'2026-01-20 14:24:57',NULL,NULL),(44,NULL,'bec9e078c0db4a208dec89cf6c4458c4',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:24:58',NULL,'2026-01-20 14:24:58',NULL,NULL),(45,NULL,'a46350811ba449b082347f02d76d1c34',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:24:58',NULL,'2026-01-20 14:24:58',NULL,NULL),(46,NULL,'6d9b3587ce494cb8ac153a66886f6883',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:24:59',NULL,'2026-01-20 14:24:59',NULL,NULL),(47,NULL,'986d9f2d9bd24a228e53a76694db0568',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:24:59',NULL,'2026-01-20 14:24:59',NULL,NULL),(48,NULL,'836213a644224fb8877b299d76d5df3b',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:25:00',NULL,'2026-01-20 14:25:00',NULL,NULL),(49,NULL,NULL,'8619863067d04e25a65dcac9b0ef2279',NULL,NULL,NULL,NULL,'2026-01-20 14:25:08',NULL,'2026-01-20 14:25:08',NULL,NULL),(50,NULL,NULL,'51356c0c84ae42b4a5cec7fe243b1139',NULL,NULL,NULL,NULL,'2026-01-20 14:25:08',NULL,'2026-01-20 14:25:08',NULL,NULL),(51,NULL,'71c8709b56144dcc8146d2d4731ad51f',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:25:11',NULL,'2026-01-20 14:25:11',NULL,NULL),(52,NULL,'78e2e5d17e6f44b1a0268d222ca40dab',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:25:14',NULL,'2026-01-20 14:25:14',NULL,NULL),(53,NULL,NULL,'0ccee64504a04e4ab27348efd5bb3410',NULL,NULL,NULL,NULL,'2026-01-20 14:25:31',NULL,'2026-01-20 14:25:31',NULL,NULL),(54,NULL,NULL,'b3cbad2d30524b8691579b6b7e4c4ae5',NULL,NULL,NULL,NULL,'2026-01-20 14:25:31',NULL,'2026-01-20 14:25:31',NULL,NULL),(55,NULL,NULL,'21e853e4fb3e494b954823832a8fc55e',NULL,NULL,NULL,NULL,'2026-01-20 14:25:32',NULL,'2026-01-20 14:25:32',NULL,NULL),(56,NULL,'a6b8b707340e4e909ad5a682e538b17e',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:25:33',NULL,'2026-01-20 14:25:33',NULL,NULL),(57,NULL,'86694371c3e748f38196e995b667e5aa',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:25:35',NULL,'2026-01-20 14:25:35',NULL,NULL),(58,NULL,'0d817a60452849e6b307ef9f6c1f70a6',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:25:39',NULL,'2026-01-20 14:25:39',NULL,NULL),(59,NULL,NULL,'4fc5486d5a53432691da4084385fc905',NULL,NULL,NULL,NULL,'2026-01-20 14:25:44',NULL,'2026-01-20 14:25:44',NULL,NULL),(60,NULL,NULL,'1958f6ce65294a008c6bdc76e73b34ba',NULL,NULL,NULL,NULL,'2026-01-20 14:25:44',NULL,'2026-01-20 14:25:44',NULL,NULL),(61,NULL,'b6cf8a036c14497394bba17afdc7a3b2',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:25:47',NULL,'2026-01-20 14:25:47',NULL,NULL),(62,NULL,'54b44408ea7244668da9f03112a3e42c',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:25:48',NULL,'2026-01-20 14:25:48',NULL,NULL),(63,NULL,NULL,'a25d9d1004384ceba3ab113edc9fdbca',NULL,NULL,NULL,NULL,'2026-01-20 14:25:53',NULL,'2026-01-20 14:25:53',NULL,NULL),(64,NULL,NULL,'74d066b84d404f9387340470cdec0d01',NULL,NULL,NULL,NULL,'2026-01-20 14:25:53',NULL,'2026-01-20 14:25:53',NULL,NULL),(65,NULL,'358295adfe334cd492569c76011e165a',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:25:56',NULL,'2026-01-20 14:25:56',NULL,NULL),(66,NULL,'ee3418d1e69d4d51a88a81a19869be19',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:25:57',NULL,'2026-01-20 14:25:57',NULL,NULL),(67,NULL,NULL,'f01b6d6009a7429fa76d16ce7c5064e4',NULL,NULL,NULL,NULL,'2026-01-20 14:26:02',NULL,'2026-01-20 14:26:02',NULL,NULL),(68,NULL,NULL,'c5a5be333cd742719b69ac82696df2b2',NULL,NULL,NULL,NULL,'2026-01-20 14:26:03',NULL,'2026-01-20 14:26:03',NULL,NULL),(69,NULL,'a8718395ffc2413885699079a1ab512f',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:26:08',NULL,'2026-01-20 14:26:08',NULL,NULL),(70,NULL,'933cbebf428441549bc9cf7b070207eb',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:26:09',NULL,'2026-01-20 14:26:09',NULL,NULL),(71,NULL,NULL,'64b119b629cf4084905141b77b9ca99d',NULL,NULL,NULL,NULL,'2026-01-20 14:26:14',NULL,'2026-01-20 14:26:14',NULL,NULL),(72,NULL,NULL,'2d7edf3128c64c7da825124f22a9d465',NULL,NULL,NULL,NULL,'2026-01-20 14:26:14',NULL,'2026-01-20 14:26:14',NULL,NULL),(73,NULL,'2c622188c3f54e4f977d5752c1c0f7f7',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:26:18',NULL,'2026-01-20 14:26:18',NULL,NULL),(74,NULL,'ef7119e488d748b88d1f537a86c677ef',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:26:20',NULL,'2026-01-20 14:26:20',NULL,NULL),(75,NULL,NULL,'cc9b532872294819b8c964375b87cb65',NULL,NULL,NULL,NULL,'2026-01-20 14:26:24',NULL,'2026-01-20 14:26:24',NULL,NULL),(76,NULL,NULL,'dd68241d6f7b4f90883e6f7ccb482aa5',NULL,NULL,NULL,NULL,'2026-01-20 14:26:25',NULL,'2026-01-20 14:26:25',NULL,NULL),(77,NULL,'f290908144c4443089272c0e80d5ce45',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:26:26',NULL,'2026-01-20 14:26:26',NULL,NULL),(78,NULL,'edce7ee41c8d47d39a1fc821ec100c86',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:26:27',NULL,'2026-01-20 14:26:27',NULL,NULL),(79,NULL,NULL,'aefb5652049e473a948c089d7c62ef1a',NULL,NULL,NULL,NULL,'2026-01-20 14:26:28',NULL,'2026-01-20 14:26:28',NULL,NULL),(80,NULL,NULL,'b9adeab2c2f5486e92ca8534ef11c720',NULL,NULL,NULL,NULL,'2026-01-20 14:26:29',NULL,'2026-01-20 14:26:29',NULL,NULL),(81,NULL,'861a4f2b70b249afadeabfe85bda53a3',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:26:30',NULL,'2026-01-20 14:26:30',NULL,NULL),(82,NULL,'a7bb8a09ecaa40e8980b2ed19afa279f',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:26:31',NULL,'2026-01-20 14:26:31',NULL,NULL),(83,NULL,NULL,'961d6d85e87c48888dcbf9eecacfd08a',NULL,NULL,NULL,NULL,'2026-01-20 14:26:32',NULL,'2026-01-20 14:26:32',NULL,NULL),(84,NULL,NULL,'0df828fe17854d4da0be1a8433946d0a',NULL,NULL,NULL,NULL,'2026-01-20 14:26:32',NULL,'2026-01-20 14:26:32',NULL,NULL),(85,NULL,'d8b0037a1138475985c7eeb07f38ccd8',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:26:33',NULL,'2026-01-20 14:26:33',NULL,NULL),(86,NULL,'7cb369c459bc4a8fad9a3476f2951d86',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:26:35',NULL,'2026-01-20 14:26:35',NULL,NULL),(87,NULL,NULL,'96c419f07f374463aa2a9d0126f8409c',NULL,NULL,NULL,NULL,'2026-01-20 14:26:40',NULL,'2026-01-20 14:26:40',NULL,NULL),(88,NULL,NULL,'65e4401c015b450596b45d65db5635b6',NULL,NULL,NULL,NULL,'2026-01-20 14:26:44',NULL,'2026-01-20 14:26:44',NULL,NULL),(89,NULL,'9f85f17c777a459abd10b8da5febb90a',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:26:50',NULL,'2026-01-20 14:26:50',NULL,NULL),(90,NULL,'d678dbec50454d208dbb4996eaf71e5f',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:26:52',NULL,'2026-01-20 14:26:52',NULL,NULL),(91,NULL,NULL,'8ea9f3cd2cbb462a8ecbb488e6a1a25d',NULL,NULL,NULL,NULL,'2026-01-20 14:26:58',NULL,'2026-01-20 14:26:58',NULL,NULL),(92,NULL,NULL,'c85759c031f744d2b9774757c7eb3cc2',NULL,NULL,NULL,NULL,'2026-01-20 14:26:59',NULL,'2026-01-20 14:26:59',NULL,NULL),(93,NULL,NULL,'57772fbe96764a5c8d54719c376f94aa',NULL,NULL,NULL,NULL,'2026-01-20 14:26:59',NULL,'2026-01-20 14:26:59',NULL,NULL),(94,NULL,NULL,'0e7b939a15384ab5bbfaae91f62f5102',NULL,NULL,NULL,NULL,'2026-01-20 14:26:59',NULL,'2026-01-20 14:26:59',NULL,NULL),(95,NULL,'95f7d246c566473eb07dba860a310578',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:27:01',NULL,'2026-01-20 14:27:01',NULL,NULL),(96,NULL,'3b760fc176e74d4e802dcff4c46f2d19',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:27:01',NULL,'2026-01-20 14:27:01',NULL,NULL),(97,NULL,'14ebcff06a484899a9725832f1eddfdf',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:27:02',NULL,'2026-01-20 14:27:02',NULL,NULL),(98,NULL,'18cc8003c18e407d9b448ac2177fe5ee',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:27:02',NULL,'2026-01-20 14:27:02',NULL,NULL),(99,NULL,NULL,'bb3a87469ef84e78bcbf0b0039374f8a',NULL,NULL,NULL,NULL,'2026-01-20 14:27:07',NULL,'2026-01-20 14:27:07',NULL,NULL),(100,NULL,NULL,'ed49d4ffb263423da2c4a659c6216a2e',NULL,NULL,NULL,NULL,'2026-01-20 14:27:07',NULL,'2026-01-20 14:27:07',NULL,NULL),(101,NULL,NULL,'57d58248fa3b44579c14396dca4a2199',NULL,NULL,NULL,NULL,'2026-01-20 14:27:08',NULL,'2026-01-20 14:27:08',NULL,NULL),(102,NULL,NULL,'5e6a091b55474eb88c09f4a60201f33c',NULL,NULL,NULL,NULL,'2026-01-20 14:27:09',NULL,'2026-01-20 14:27:09',NULL,NULL),(103,NULL,'c7a32006e54d428a9e42dada03c7fc28',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:27:09',NULL,'2026-01-20 14:27:09',NULL,NULL),(104,NULL,'ef783a3b5dd3446faf947d627c64c5da',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:27:10',NULL,'2026-01-20 14:27:10',NULL,NULL),(105,NULL,'29d9d046eeff4d1cabeb41d46999fee4',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:27:11',NULL,'2026-01-20 14:27:11',NULL,NULL),(106,NULL,'f15b0417a4884892808a5dc5de5f5462',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:27:11',NULL,'2026-01-20 14:27:11',NULL,NULL),(107,NULL,NULL,'399cc9abe2cd4ab196a4e5789992ae51',NULL,NULL,NULL,NULL,'2026-01-20 14:27:47',NULL,'2026-01-20 14:27:47',NULL,NULL),(108,NULL,NULL,'8bb376f888a54e9d8ed785e1b46d4fe5',NULL,NULL,NULL,NULL,'2026-01-20 14:27:48',NULL,'2026-01-20 14:27:48',NULL,NULL),(109,NULL,'1759b9d61ad946b6afa3e8448ce02190',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:27:52',NULL,'2026-01-20 14:27:52',NULL,NULL),(110,NULL,NULL,'7dfe92a3bd9c43bbb3d4590ff5a57173',NULL,NULL,NULL,NULL,'2026-01-20 14:27:52',NULL,'2026-01-20 14:27:52',NULL,NULL),(111,NULL,NULL,'fa0d918445034ec398a8a856d02803b8',NULL,NULL,NULL,NULL,'2026-01-20 14:27:53',NULL,'2026-01-20 14:27:53',NULL,NULL),(112,NULL,'7e22d2ad7d84451d89e5288d170589b5',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:27:54',NULL,'2026-01-20 14:27:54',NULL,NULL),(113,NULL,'e3cc4a74e92f45a1811137175eae3af2',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:27:54',NULL,'2026-01-20 14:27:54',NULL,NULL),(114,NULL,'bf17e8c0297a4d0bbeb73dc9125b2f08',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:27:55',NULL,'2026-01-20 14:27:55',NULL,NULL),(115,NULL,NULL,'8341b9f597454b8fa5eafff5c1793d6c',NULL,NULL,NULL,NULL,'2026-01-20 14:28:00',NULL,'2026-01-20 14:28:00',NULL,NULL),(116,NULL,NULL,'877e2a8c686e467ba12f9a0e8a1d9e3b',NULL,NULL,NULL,NULL,'2026-01-20 14:28:00',NULL,'2026-01-20 14:28:00',NULL,NULL),(117,NULL,'ce3da3b73e874fbf9a3297ac1891dec6',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:28:03',NULL,'2026-01-20 14:28:03',NULL,NULL),(118,NULL,'d8f63423dc704f30a634a3b5b0f8d7aa',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:28:04',NULL,'2026-01-20 14:28:04',NULL,NULL),(119,NULL,NULL,'e13a7239f61f42c5a6c1e1049709a9d5',NULL,NULL,NULL,NULL,'2026-01-20 14:28:08',NULL,'2026-01-20 14:28:08',NULL,NULL),(120,NULL,NULL,'8e5881159d564354a27d96c664ff53e9',NULL,NULL,NULL,NULL,'2026-01-20 14:28:08',NULL,'2026-01-20 14:28:08',NULL,NULL),(121,NULL,'3f1b1aab7ed546d4b05f2c480fc04e17',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:28:10',NULL,'2026-01-20 14:28:10',NULL,NULL),(122,NULL,'ea013f8f0e9d46068dad5de6ebb81d93',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:28:12',NULL,'2026-01-20 14:28:12',NULL,NULL),(123,NULL,NULL,'e72a624cae694cc6b881eaabe7e9bb91',NULL,NULL,NULL,NULL,'2026-01-20 14:28:16',NULL,'2026-01-20 14:28:16',NULL,NULL),(124,NULL,NULL,'c6850d9f6ac34c32b02041dfb23a9632',NULL,NULL,NULL,NULL,'2026-01-20 14:28:17',NULL,'2026-01-20 14:28:17',NULL,NULL),(125,NULL,'a0b79ec5d97c461680c508148d3d582b',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:28:20',NULL,'2026-01-20 14:28:20',NULL,NULL),(126,NULL,'08f27847b8ca4cbc8a52b8d2424138a0',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:28:22',NULL,'2026-01-20 14:28:22',NULL,NULL),(127,NULL,NULL,'bb842c9e6d0a4be69ec41f8b43e37803',NULL,NULL,NULL,NULL,'2026-01-20 14:28:29',NULL,'2026-01-20 14:28:29',NULL,NULL),(128,NULL,NULL,'042f1fbc4afc4704a842ac375ffcb84c',NULL,NULL,NULL,NULL,'2026-01-20 14:28:29',NULL,'2026-01-20 14:28:29',NULL,NULL),(129,NULL,'2b3b3d512eca4c659047bcaf9dbaac90',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:28:31',NULL,'2026-01-20 14:28:31',NULL,NULL),(130,NULL,'bdff7b5bc80f4b448cd8c1b16237a94f',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:28:33',NULL,'2026-01-20 14:28:33',NULL,NULL),(131,NULL,'aae84f2d71844147b8ffcf3d0f18f84d',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:28:38',NULL,'2026-01-20 14:28:38',NULL,NULL),(132,NULL,NULL,'68776f89100342c3bee459767444b4a2',NULL,NULL,NULL,NULL,'2026-01-20 14:28:41',NULL,'2026-01-20 14:28:41',NULL,NULL),(133,NULL,'9d4e090eaccc4619906c01cf5db52b51',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:28:41',NULL,'2026-01-20 14:28:41',NULL,NULL),(134,NULL,NULL,'59e1d22248d84ea091b89fbbdecb7837',NULL,NULL,NULL,NULL,'2026-01-20 14:28:43',NULL,'2026-01-20 14:28:43',NULL,NULL),(135,NULL,NULL,'30acfbeaf365477bbaffac2e7ae4c9f5',NULL,NULL,NULL,NULL,'2026-01-20 14:28:43',NULL,'2026-01-20 14:28:43',NULL,NULL),(136,NULL,'0d3031eff8a043338f9ed581afc01f38',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:28:44',NULL,'2026-01-20 14:28:44',NULL,NULL),(137,NULL,NULL,'eae4ac21a700463eadfdbe7717ed8b13',NULL,NULL,NULL,NULL,'2026-01-20 14:28:45',NULL,'2026-01-20 14:28:45',NULL,NULL),(138,NULL,NULL,'9e28d880f74944399d7a2df42cefe0cd',NULL,NULL,NULL,NULL,'2026-01-20 14:28:45',NULL,'2026-01-20 14:28:45',NULL,NULL),(139,NULL,'2bd62eab52c14e95a8c4ab7ed35a69e2',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:28:45',NULL,'2026-01-20 14:28:45',NULL,NULL),(140,NULL,'64772ad8e43048d89873964617706532',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:28:46',NULL,'2026-01-20 14:28:46',NULL,NULL),(141,NULL,'944b426a2d4c4ad3a01f0b855ad36509',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:28:47',NULL,'2026-01-20 14:28:47',NULL,NULL),(142,NULL,NULL,'166fe1508cc7487f92e37d768e860232',NULL,NULL,NULL,NULL,'2026-01-20 14:28:51',NULL,'2026-01-20 14:28:51',NULL,NULL),(143,NULL,'a30adb84111240c9a36b8986784d3f2d',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:28:51',NULL,'2026-01-20 14:28:51',NULL,NULL),(144,NULL,NULL,'74ae4c4faea0487182ab6568066ff7f6',NULL,NULL,NULL,NULL,'2026-01-20 14:28:51',NULL,'2026-01-20 14:28:51',NULL,NULL),(145,NULL,NULL,'486a5dc9d7a648418a542d087a475382',NULL,NULL,NULL,NULL,'2026-01-20 14:28:51',NULL,'2026-01-20 14:28:51',NULL,NULL),(146,NULL,'7af971de19a1445890803e896a641204',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:28:53',NULL,'2026-01-20 14:28:53',NULL,NULL),(147,NULL,'4bb23f64e6d14e57927ae96ac9d7141c',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:28:54',NULL,'2026-01-20 14:28:54',NULL,NULL),(148,NULL,NULL,'13e3609b89ea4ad49d8e1cc5afabec70',NULL,NULL,NULL,NULL,'2026-01-20 14:28:59',NULL,'2026-01-20 14:28:59',NULL,NULL),(149,NULL,NULL,'9fb986a3dc8b45479089ca00f1340e1e',NULL,NULL,NULL,NULL,'2026-01-20 14:28:59',NULL,'2026-01-20 14:28:59',NULL,NULL),(150,NULL,'4471eabe161b469f9bcb318423fc4d4a',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:29:01',NULL,'2026-01-20 14:29:01',NULL,NULL),(151,NULL,'2dcca06533444286af6a7d3af00cd633',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:29:03',NULL,'2026-01-20 14:29:03',NULL,NULL),(152,NULL,NULL,'91c665fb46e847d4a6de7463b12a1d1d',NULL,NULL,NULL,NULL,'2026-01-20 14:29:18',NULL,'2026-01-20 14:29:18',NULL,NULL),(153,NULL,NULL,'eccb47c47df14bd1be032ccf4275cafc',NULL,NULL,NULL,NULL,'2026-01-20 14:29:18',NULL,'2026-01-20 14:29:18',NULL,NULL),(154,NULL,'6f5e30edea464d6c81d8288f6962a297',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:29:22',NULL,'2026-01-20 14:29:22',NULL,NULL),(155,NULL,'a1959aa8761e48ae9c708bd25a18f2fe',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:29:24',NULL,'2026-01-20 14:29:24',NULL,NULL),(156,NULL,NULL,'7f1542e5fcf146c2b3837e555fad5836',NULL,NULL,NULL,NULL,'2026-01-20 14:29:30',NULL,'2026-01-20 14:29:30',NULL,NULL),(157,NULL,'a14f5fc9f89449dc9788546a82b10172',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:29:32',NULL,'2026-01-20 14:29:32',NULL,NULL),(158,NULL,NULL,'bce7fcbd19554e29bb80c5b93b7dd3c9',NULL,NULL,NULL,NULL,'2026-01-20 14:29:40',NULL,'2026-01-20 14:29:40',NULL,NULL),(159,NULL,NULL,'f59120b8f4004c4fb57448db9dcaa6cd',NULL,NULL,NULL,NULL,'2026-01-20 14:29:40',NULL,'2026-01-20 14:29:40',NULL,NULL),(160,NULL,'d15f60b9e48e4175b5520d1e57ed2d3a',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:29:41',NULL,'2026-01-20 14:29:41',NULL,NULL),(161,NULL,'e22b29df381845278c7b679b17d11c8b',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:29:42',NULL,'2026-01-20 14:29:42',NULL,NULL),(162,NULL,NULL,'74ae3912af894b6096aecdc733092fdf',NULL,NULL,NULL,NULL,'2026-01-20 14:29:46',NULL,'2026-01-20 14:29:46',NULL,NULL),(163,NULL,NULL,'4a41b176285a4a948845c5303a667736',NULL,NULL,NULL,NULL,'2026-01-20 14:29:47',NULL,'2026-01-20 14:29:47',NULL,NULL),(164,NULL,'75895dde775640e49016c695ca2b0e7c',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:29:48',NULL,'2026-01-20 14:29:48',NULL,NULL),(165,NULL,'d839d1eef5084757a62bf02f00bf3cad',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:29:49',NULL,'2026-01-20 14:29:49',NULL,NULL),(166,NULL,NULL,'c5a75e25f28a4dd3a87998e63b9c5fcc',NULL,NULL,NULL,NULL,'2026-01-20 14:29:55',NULL,'2026-01-20 14:29:55',NULL,NULL),(167,NULL,NULL,'269a9ab414d84e61b0db69d308cb0c46',NULL,NULL,NULL,NULL,'2026-01-20 14:29:56',NULL,'2026-01-20 14:29:56',NULL,NULL),(168,NULL,'670413cc865045cabb62920d68618cd3',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:29:59',NULL,'2026-01-20 14:29:59',NULL,NULL),(169,NULL,'c2d33275939b4fcea398911e65e6cea5',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:30:02',NULL,'2026-01-20 14:30:02',NULL,NULL),(170,NULL,NULL,'2543033da8e144c5a0cbe80200918c3d',NULL,NULL,NULL,NULL,'2026-01-20 14:30:10',NULL,'2026-01-20 14:30:10',NULL,NULL),(171,NULL,'f63ddddb0ae94301b64e3b529d7cb3e0',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:30:11',NULL,'2026-01-20 14:30:11',NULL,NULL),(172,NULL,NULL,'081515cdb7814662880b152c294848fd',NULL,NULL,NULL,NULL,'2026-01-20 14:30:11',NULL,'2026-01-20 14:30:11',NULL,NULL),(173,NULL,NULL,'e677e70805da4e81ac048b89eeb9a375',NULL,NULL,NULL,NULL,'2026-01-20 14:30:11',NULL,'2026-01-20 14:30:11',NULL,NULL),(174,NULL,'e8088a92256a490890997a75b0535f61',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:30:13',NULL,'2026-01-20 14:30:13',NULL,NULL),(175,NULL,'f74e6c5575a54ab0989c4b713ad7a459',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:30:15',NULL,'2026-01-20 14:30:15',NULL,NULL),(176,NULL,NULL,'9f64ba08e8664899a6c14601e04cce32',NULL,NULL,NULL,NULL,'2026-01-20 14:30:18',NULL,'2026-01-20 14:30:18',NULL,NULL),(177,NULL,NULL,'f7c045a9c5ec44d188d1873346a2a544',NULL,NULL,NULL,NULL,'2026-01-20 14:30:18',NULL,'2026-01-20 14:30:18',NULL,NULL),(178,NULL,'ead75565d1e04300ac62ce0efa352439',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:30:20',NULL,'2026-01-20 14:30:20',NULL,NULL),(179,NULL,'c12458f457964cf19f142f1a93ba54f5',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:30:21',NULL,'2026-01-20 14:30:21',NULL,NULL),(180,NULL,NULL,'86df2c2ba7e34562aecf2f9566e46dc0',NULL,NULL,NULL,NULL,'2026-01-20 14:30:40',NULL,'2026-01-20 14:30:40',NULL,NULL),(181,NULL,NULL,'fb066eb115a5479586f47ca371bba461',NULL,NULL,NULL,NULL,'2026-01-20 14:30:40',NULL,'2026-01-20 14:30:40',NULL,NULL),(182,NULL,'4ac25c78ebe1428c9034578c09eec31e',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:30:42',NULL,'2026-01-20 14:30:42',NULL,NULL),(183,NULL,'4cef207e759c44ec9537cb9b06aec2c8',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:30:43',NULL,'2026-01-20 14:30:43',NULL,NULL),(184,NULL,NULL,'0cec872a00f742d78563d6d16fc545cb',NULL,NULL,NULL,NULL,'2026-01-20 14:30:59',NULL,'2026-01-20 14:30:59',NULL,NULL),(185,NULL,'78f151250c04467bb4f6a229dda16fc5',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:31:01',NULL,'2026-01-20 14:31:01',NULL,NULL),(186,NULL,NULL,'31a6b24ce83d4824b02148030eca531c',NULL,NULL,NULL,NULL,'2026-01-20 14:31:14',NULL,'2026-01-20 14:31:14',NULL,NULL),(187,NULL,NULL,'1431af9a73934db9afa530dc0b75d80f',NULL,NULL,NULL,NULL,'2026-01-20 14:31:14',NULL,'2026-01-20 14:31:14',NULL,NULL),(188,NULL,NULL,'01a3d712f05049b19d4ecc7051720ad5',NULL,NULL,NULL,NULL,'2026-01-20 14:31:18',NULL,'2026-01-20 14:31:18',NULL,NULL),(189,NULL,NULL,'d4b36d8e19cb4f529d2185f573f5072a',NULL,NULL,NULL,NULL,'2026-01-20 14:31:18',NULL,'2026-01-20 14:31:18',NULL,NULL),(190,NULL,'e2ce8450af574dfabee24677527aa662',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:31:21',NULL,'2026-01-20 14:31:21',NULL,NULL),(191,NULL,'2074a786307f4427bbbbc1103d4a9305',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:31:23',NULL,'2026-01-20 14:31:23',NULL,NULL),(192,NULL,'dfafda1e1dad4adfa4b670ec63073d36',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:31:24',NULL,'2026-01-20 14:31:24',NULL,NULL),(193,NULL,'f3c2e72a7148496394c8bcd618a19c80',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:31:24',NULL,'2026-01-20 14:31:24',NULL,NULL),(194,NULL,NULL,'3e77725776434fd9acc2cdac6b5436e3',NULL,NULL,NULL,NULL,'2026-01-20 14:31:59',NULL,'2026-01-20 14:31:59',NULL,NULL),(195,NULL,NULL,'991e789b6af04f21a0ffd7ed5225a1fb',NULL,NULL,NULL,NULL,'2026-01-20 14:32:00',NULL,'2026-01-20 14:32:00',NULL,NULL),(196,NULL,'24d70d1009f54673b37aa7f80bb2d3e0',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:32:02',NULL,'2026-01-20 14:32:02',NULL,NULL),(197,NULL,'168ba715852444468d04454dcff14865',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:32:04',NULL,'2026-01-20 14:32:04',NULL,NULL),(198,NULL,NULL,'6a3fbc3f92a849e88cbf34d28ca17e43',NULL,NULL,NULL,NULL,'2026-01-20 14:32:07',NULL,'2026-01-20 14:32:07',NULL,NULL),(199,NULL,NULL,'5c7e18489e6e438b83e0436992b16e9a',NULL,NULL,NULL,NULL,'2026-01-20 14:32:08',NULL,'2026-01-20 14:32:08',NULL,NULL),(200,NULL,'0cee74dd60da4a839bb5eb0ba3137edf',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:32:09',NULL,'2026-01-20 14:32:09',NULL,NULL),(201,NULL,'c01f6648fefb49ca8467c48a50ea36ff',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:32:10',NULL,'2026-01-20 14:32:10',NULL,NULL),(202,NULL,NULL,'a76f8a7bf01145bf8c953695d87aed2a',NULL,NULL,NULL,NULL,'2026-01-20 14:32:24',NULL,'2026-01-20 14:32:24',NULL,NULL),(203,NULL,NULL,'5629e77b1fe84b4d8f4d891827b1c753',NULL,NULL,NULL,NULL,'2026-01-20 14:32:24',NULL,'2026-01-20 14:32:24',NULL,NULL),(204,NULL,'16c25c6af46845c8b8f7beaa0a50bd38',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:32:26',NULL,'2026-01-20 14:32:26',NULL,NULL),(205,NULL,'0a202ab9a4b941ad953f5d7d57553af2',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:32:28',NULL,'2026-01-20 14:32:28',NULL,NULL),(206,NULL,NULL,'3d51de2ad98d40d8ad12305518d106fd',NULL,NULL,NULL,NULL,'2026-01-20 14:32:39',NULL,'2026-01-20 14:32:39',NULL,NULL),(207,NULL,NULL,'e5b1a5dfe695421db1917f321a1160e5',NULL,NULL,NULL,NULL,'2026-01-20 14:32:39',NULL,'2026-01-20 14:32:39',NULL,NULL),(208,NULL,NULL,'dd0483da65fa4225846c0cc91e8e0275',NULL,NULL,NULL,NULL,'2026-01-20 14:32:39',NULL,'2026-01-20 14:32:39',NULL,NULL),(209,NULL,'ac0564cb541e4c679c6d282fd454c05d',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:32:40',NULL,'2026-01-20 14:32:40',NULL,NULL),(210,NULL,'389fafaa99e14f31988005de907401bf',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:32:41',NULL,'2026-01-20 14:32:41',NULL,NULL),(211,NULL,'3760012f1c3540f68c35e3c53047394f',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:32:42',NULL,'2026-01-20 14:32:42',NULL,NULL),(212,NULL,NULL,'5027e9c3d5f34963b75a4414c51b9ddd',NULL,NULL,NULL,NULL,'2026-01-20 14:32:47',NULL,'2026-01-20 14:32:47',NULL,NULL),(213,NULL,NULL,'d6b8f17b404e47baa7e4c7fb5d187208',NULL,NULL,NULL,NULL,'2026-01-20 14:32:48',NULL,'2026-01-20 14:32:48',NULL,NULL),(214,NULL,NULL,'360feb9a3f0146f0b84b6c28241e41a9',NULL,NULL,NULL,NULL,'2026-01-20 14:32:48',NULL,'2026-01-20 14:32:48',NULL,NULL),(215,NULL,NULL,'30d26a372a454e0abb60b0e937e47d2d',NULL,NULL,NULL,NULL,'2026-01-20 14:32:49',NULL,'2026-01-20 14:32:49',NULL,NULL),(216,NULL,NULL,'fab698d5ba454eb38c305f93992c91ab',NULL,NULL,NULL,NULL,'2026-01-20 14:32:50',NULL,'2026-01-20 14:32:50',NULL,NULL),(217,NULL,'a46dc8f8b5154127821f7fd90dc7a100',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:32:51',NULL,'2026-01-20 14:32:51',NULL,NULL),(218,NULL,'bd830773c45f46e3b6fd28d50255c383',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:32:52',NULL,'2026-01-20 14:32:52',NULL,NULL),(219,NULL,'0e2b622671af4e3fbcdb594e88f55f4c',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:32:55',NULL,'2026-01-20 14:32:55',NULL,NULL),(220,NULL,'3901385c9cfb4fc5852376a3564c0d61',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:32:55',NULL,'2026-01-20 14:32:55',NULL,NULL),(221,NULL,'9ea54f3d1e9d4c3bbc6cf4603395b9d2',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:32:56',NULL,'2026-01-20 14:32:56',NULL,NULL),(222,NULL,NULL,'2bb83ceaf7304b49ae8575e5a3ac6960',NULL,NULL,NULL,NULL,'2026-01-20 14:33:01',NULL,'2026-01-20 14:33:01',NULL,NULL),(223,NULL,NULL,'6ad3319ca4be4dee8d84f1a74c2f25c8',NULL,NULL,NULL,NULL,'2026-01-20 14:33:02',NULL,'2026-01-20 14:33:02',NULL,NULL),(224,NULL,'6154baf5b4ff45d892edb11f4eb7277f',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:33:04',NULL,'2026-01-20 14:33:04',NULL,NULL),(225,NULL,'4d83c89adbe844ed9bb9f55289b799db',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:33:06',NULL,'2026-01-20 14:33:06',NULL,NULL),(226,NULL,NULL,'b9cb29dd754440bf905218745414510b',NULL,NULL,NULL,NULL,'2026-01-20 14:33:11',NULL,'2026-01-20 14:33:11',NULL,NULL),(227,NULL,NULL,'51c93112af2c4d9594e86c8e2d1f8769',NULL,NULL,NULL,NULL,'2026-01-20 14:33:11',NULL,'2026-01-20 14:33:11',NULL,NULL),(228,NULL,'8b9aa6c5d5894f8f9131647eaf597cdd',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:33:13',NULL,'2026-01-20 14:33:13',NULL,NULL),(229,NULL,'9a2f63846f6c4fabbb380f4280246812',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:33:16',NULL,'2026-01-20 14:33:16',NULL,NULL),(230,NULL,NULL,'779b79753cc542d488dbbfd1a7b97e34',NULL,NULL,NULL,NULL,'2026-01-20 14:33:25',NULL,'2026-01-20 14:33:25',NULL,NULL),(231,NULL,'e087e1247ad849ec88b44c95ca0a443c',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:33:27',NULL,'2026-01-20 14:33:27',NULL,NULL),(232,NULL,NULL,'5ac9025f41794a1cbe52dde3fe3420ba',NULL,NULL,NULL,NULL,'2026-01-20 14:33:33',NULL,'2026-01-20 14:33:33',NULL,NULL),(233,NULL,'012df3da5293447db144502f22bdde1c',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:33:34',NULL,'2026-01-20 14:33:34',NULL,NULL),(234,NULL,NULL,'e84fac95bc7c418b85f478d46c042406',NULL,NULL,NULL,NULL,'2026-01-20 14:34:04',NULL,'2026-01-20 14:34:04',NULL,NULL),(235,NULL,'58d8d8710bcc4cd3b91e27065defa7b1',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:34:10',NULL,'2026-01-20 14:34:10',NULL,NULL),(236,NULL,NULL,'e28b74f271d74252925f653fb20bf322',NULL,NULL,NULL,NULL,'2026-01-20 14:34:12',NULL,'2026-01-20 14:34:12',NULL,NULL),(237,NULL,'06ea454f4b1a40bda9e7ae4a93b974e9',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:34:13',NULL,'2026-01-20 14:34:13',NULL,NULL),(238,NULL,NULL,'c44179521c19422ca6789bda5548c724',NULL,NULL,NULL,NULL,'2026-01-20 14:34:33',NULL,'2026-01-20 14:34:33',NULL,NULL),(239,NULL,'a84ff584b4e54885b41223945af5852f',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:34:34',NULL,'2026-01-20 14:34:34',NULL,NULL),(240,NULL,NULL,'729ca8a2a7414735af25d05df4a563b9',NULL,NULL,NULL,NULL,'2026-01-20 14:34:36',NULL,'2026-01-20 14:34:36',NULL,NULL),(241,NULL,NULL,'bf54507eccd247529006a36aa52e4c0d',NULL,NULL,NULL,NULL,'2026-01-20 14:34:36',NULL,'2026-01-20 14:34:36',NULL,NULL),(242,NULL,'48488e875f2e472f97f07cc7ee07e0be',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:34:38',NULL,'2026-01-20 14:34:38',NULL,NULL),(243,NULL,'92687a56688046199a77f8d430487a8f',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:34:39',NULL,'2026-01-20 14:34:39',NULL,NULL),(244,NULL,NULL,'801d1fca0d924c5b997d0a1cdf45001a',NULL,NULL,NULL,NULL,'2026-01-20 14:34:43',NULL,'2026-01-20 14:34:43',NULL,NULL),(245,NULL,'5fe79eeaf2ac4ecfaef7cfd9d34d9d47',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:34:44',NULL,'2026-01-20 14:34:44',NULL,NULL),(246,NULL,NULL,'9a4107c8ec1443b0b5c56dd25260c7a7',NULL,NULL,NULL,NULL,'2026-01-20 14:34:57',NULL,'2026-01-20 14:34:57',NULL,NULL),(247,NULL,'b4a391a5c99b46fd8fc105b125ed5058',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:34:59',NULL,'2026-01-20 14:34:59',NULL,NULL),(248,NULL,NULL,'6bf23282febb455daf4d4f24666cd6c3',NULL,NULL,NULL,NULL,'2026-01-20 14:35:30',NULL,'2026-01-20 14:35:30',NULL,NULL),(249,NULL,'a73bd836c7f64377a24971d95d583639',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:35:31',NULL,'2026-01-20 14:35:31',NULL,NULL),(250,NULL,NULL,'f51c395107c84dbd9067113b84ff01dd',NULL,NULL,NULL,NULL,'2026-01-20 14:35:40',NULL,'2026-01-20 14:35:40',NULL,NULL),(251,NULL,NULL,'4b1ebf2d77844ef9bf7bd8a5f6359af4',NULL,NULL,NULL,NULL,'2026-01-20 14:35:40',NULL,'2026-01-20 14:35:40',NULL,NULL),(252,NULL,'70f46f2d9d2d4c4cb05ef4e71ae50d53',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:35:42',NULL,'2026-01-20 14:35:42',NULL,NULL),(253,NULL,'a841e7a1434c488390475174e10bc161',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:35:43',NULL,'2026-01-20 14:35:43',NULL,NULL),(254,NULL,NULL,'72ad8e217e1348378596753eefca1452',NULL,NULL,NULL,NULL,'2026-01-20 14:35:53',NULL,'2026-01-20 14:35:53',NULL,NULL),(255,NULL,'9e10f687e8a14fc3bfa98df19df5befd',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:35:56',NULL,'2026-01-20 14:35:56',NULL,NULL),(256,NULL,NULL,'71f038e5fb16457a885536b82bfa6cb6',NULL,NULL,NULL,NULL,'2026-01-20 14:35:59',NULL,'2026-01-20 14:35:59',NULL,NULL),(257,NULL,'e6285b6e5ce24d18ab95d0779b45a40b',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:36:01',NULL,'2026-01-20 14:36:01',NULL,NULL),(258,NULL,NULL,'3203983e52d34c539bf34a6e3c9c2a5f',NULL,NULL,NULL,NULL,'2026-01-20 14:36:04',NULL,'2026-01-20 14:36:04',NULL,NULL),(259,NULL,'e97c1b2a84b0409eaf54916a6176594d',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:36:05',NULL,'2026-01-20 14:36:05',NULL,NULL),(260,NULL,NULL,'99c372e44eb84382b6b2231b41bf9898',NULL,NULL,NULL,NULL,'2026-01-20 14:36:08',NULL,'2026-01-20 14:36:08',NULL,NULL),(261,NULL,'f88898dcc20f4b32ae260f1ce732858f',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:36:10',NULL,'2026-01-20 14:36:10',NULL,NULL),(262,NULL,NULL,'ecab37cbd7714ddd81e1db5b37ba85b3',NULL,NULL,NULL,NULL,'2026-01-20 14:36:21',NULL,'2026-01-20 14:36:21',NULL,NULL),(263,NULL,NULL,'3d7010bab0db493e8ba3b1a86ad4cf7d',NULL,NULL,NULL,NULL,'2026-01-20 14:36:21',NULL,'2026-01-20 14:36:21',NULL,NULL),(264,NULL,'5202cc9c82134fadb20a0003e1f09cf3',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:36:22',NULL,'2026-01-20 14:36:22',NULL,NULL),(265,NULL,'b6594bd13c35449abc258d30a1a2509b',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:36:24',NULL,'2026-01-20 14:36:24',NULL,NULL),(266,NULL,NULL,'7c78a4574cb1458d918da172d8396f56',NULL,NULL,NULL,NULL,'2026-01-20 14:36:27',NULL,'2026-01-20 14:36:27',NULL,NULL),(267,NULL,'7917254671194260a7c5d10be3e9f5d0',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:36:28',NULL,'2026-01-20 14:36:28',NULL,NULL),(268,NULL,NULL,'00cec8cbb72b489da46855f8b3b4c42c',NULL,NULL,NULL,NULL,'2026-01-20 14:36:31',NULL,'2026-01-20 14:36:31',NULL,NULL),(269,NULL,'79601368a3db41e0aacec93e8fd7f1d4',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:36:32',NULL,'2026-01-20 14:36:32',NULL,NULL),(270,NULL,NULL,'55cdc2764f8c4d0bae7076cdb36b9f57',NULL,NULL,NULL,NULL,'2026-01-20 14:36:37',NULL,'2026-01-20 14:36:37',NULL,NULL),(271,NULL,'5016255294fd4c72b7f8742aabda7c35',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:36:39',NULL,'2026-01-20 14:36:39',NULL,NULL),(272,NULL,NULL,'83ae9d41b4594c7486dcc574c92ce944',NULL,NULL,NULL,NULL,'2026-01-20 14:36:43',NULL,'2026-01-20 14:36:43',NULL,NULL),(273,NULL,'16be75d1e2294d07afb51be0ae31807f',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:36:46',NULL,'2026-01-20 14:36:46',NULL,NULL),(274,NULL,NULL,'48fdde91404a44d2904341c757fa9932',NULL,NULL,NULL,NULL,'2026-01-20 14:36:50',NULL,'2026-01-20 14:36:50',NULL,NULL),(275,NULL,'687fdd3f41d947a59517c62804d2a269',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:36:55',NULL,'2026-01-20 14:36:55',NULL,NULL),(276,NULL,NULL,'af0dc50e860c4144ab2ecc679760d941',NULL,NULL,NULL,NULL,'2026-01-20 14:37:12',NULL,'2026-01-20 14:37:12',NULL,NULL),(277,NULL,'3b81c28ccb1340c9bb2d254088a5793b',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:37:14',NULL,'2026-01-20 14:37:14',NULL,NULL),(278,NULL,NULL,'16b46a4f9f444ae2b4d07c45d3f28c17',NULL,NULL,NULL,NULL,'2026-01-20 14:37:32',NULL,'2026-01-20 14:37:32',NULL,NULL),(279,NULL,'34582163c66540298cf6cabb1c39f44d',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:37:33',NULL,'2026-01-20 14:37:33',NULL,NULL),(280,NULL,NULL,'56e2959629114d3d8a48e7a80ed96c4b',NULL,NULL,NULL,NULL,'2026-01-20 14:37:45',NULL,'2026-01-20 14:37:45',NULL,NULL),(281,NULL,'3750c56415134773aa9d9880038f1749',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:37:46',NULL,'2026-01-20 14:37:46',NULL,NULL),(282,NULL,NULL,'55b6b4c13c5e43ff9fb46e7ef3c26629',NULL,NULL,NULL,NULL,'2026-01-20 14:37:58',NULL,'2026-01-20 14:37:58',NULL,NULL),(283,NULL,'ef169429126648a18a836e61f98df4d7',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:37:58',NULL,'2026-01-20 14:37:58',NULL,NULL),(284,NULL,NULL,'d0557bccab164a068f5bd532b3f1b00c',NULL,NULL,NULL,NULL,'2026-01-20 14:38:01',NULL,'2026-01-20 14:38:01',NULL,NULL),(285,NULL,'50c6f324a0c94dca80a7054b86198166',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:38:04',NULL,'2026-01-20 14:38:04',NULL,NULL),(286,NULL,NULL,'592a0204f38a4596ab1ab81774214a6d',NULL,NULL,NULL,NULL,'2026-01-20 14:38:19',NULL,'2026-01-20 14:38:19',NULL,NULL),(287,NULL,'7d78990d13704d629a8a3e8910d005c5',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:38:20',NULL,'2026-01-20 14:38:20',NULL,NULL),(288,NULL,NULL,'ebeaeba8054e4d409bce85d7d7f43987',NULL,NULL,NULL,NULL,'2026-01-20 14:38:25',NULL,'2026-01-20 14:38:25',NULL,NULL),(289,NULL,'55e74a7648534480b3fb336e6008d4da',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:38:27',NULL,'2026-01-20 14:38:27',NULL,NULL),(290,NULL,NULL,'070b61b44b5f4adc8eb50454678d1cb4',NULL,NULL,NULL,NULL,'2026-01-20 14:38:28',NULL,'2026-01-20 14:38:28',NULL,NULL),(291,NULL,'f88f3845feba47c58ceb0f95b94eebf0',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:38:29',NULL,'2026-01-20 14:38:29',NULL,NULL),(292,NULL,NULL,'d640d75528bb42fdb7a5516f002216f2',NULL,NULL,NULL,NULL,'2026-01-20 14:38:35',NULL,'2026-01-20 14:38:35',NULL,NULL),(293,NULL,'52415b3ad5fa4b42885bd73bc38ea3ad',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:38:38',NULL,'2026-01-20 14:38:38',NULL,NULL),(294,NULL,NULL,'ddee6eb6c32d451ca50c9ea499a23c1a',NULL,NULL,NULL,NULL,'2026-01-20 14:39:41',NULL,'2026-01-20 14:39:41',NULL,NULL),(295,NULL,'4dadd5f5212f432693d35e765126f4df',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:39:43',NULL,'2026-01-20 14:39:43',NULL,NULL),(296,NULL,NULL,'a3274e8540014ffa8cd910526cd964f7',NULL,NULL,NULL,NULL,'2026-01-20 14:39:58',NULL,'2026-01-20 14:39:58',NULL,NULL),(297,NULL,'ebadba01dc3642a9a3e39469ff5d4708',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:39:59',NULL,'2026-01-20 14:39:59',NULL,NULL),(298,NULL,NULL,'cd4ba32a01f74af199438da0b72e5a4d',NULL,NULL,NULL,NULL,'2026-01-20 14:40:45',NULL,'2026-01-20 14:40:45',NULL,NULL),(299,NULL,NULL,'15c6cf6942544b629ba75b69dfa1e7fc',NULL,NULL,NULL,NULL,'2026-01-20 14:40:46',NULL,'2026-01-20 14:40:46',NULL,NULL),(300,NULL,'d86106494a6049959c104e075ffb47e1',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:40:46',NULL,'2026-01-20 14:40:46',NULL,NULL),(301,NULL,'8705404c3964472782118e478eb54e51',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:40:47',NULL,'2026-01-20 14:40:47',NULL,NULL),(302,NULL,NULL,'1145324e6a8d44f28828a922ee70933a',NULL,NULL,NULL,NULL,'2026-01-20 14:40:56',NULL,'2026-01-20 14:40:56',NULL,NULL),(303,NULL,'8e4d1d7361c94c429f75bf58a2dd432e',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:40:57',NULL,'2026-01-20 14:40:57',NULL,NULL),(304,NULL,NULL,'16c05e1ac16f428bab6b36346856235e',NULL,NULL,NULL,NULL,'2026-01-20 14:41:09',NULL,'2026-01-20 14:41:09',NULL,NULL),(305,NULL,'b50ce2f25e8943e28ddf8bf69c721e75',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:41:11',NULL,'2026-01-20 14:41:11',NULL,NULL),(306,NULL,NULL,'7e3fb126d8254300b5f6f408fceefb19',NULL,NULL,NULL,NULL,'2026-01-20 14:41:31',NULL,'2026-01-20 14:41:31',NULL,NULL),(307,NULL,'c8c509d8e23246e1a509bf2197b73ebf',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:41:38',NULL,'2026-01-20 14:41:38',NULL,NULL),(308,NULL,NULL,'6f68701c3f984f11981d5e1ddaa6f093',NULL,NULL,NULL,NULL,'2026-01-20 14:42:12',NULL,'2026-01-20 14:42:12',NULL,NULL),(309,NULL,'646f2240b79c44f08af243493552cf0e',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:42:14',NULL,'2026-01-20 14:42:14',NULL,NULL),(310,NULL,NULL,'c8a9fb458d27434495a77a94827b6097',NULL,NULL,NULL,NULL,'2026-01-20 14:42:56',NULL,'2026-01-20 14:42:56',NULL,NULL),(311,NULL,'e3f93fd4b2154dda9f38e62334904303',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:42:57',NULL,'2026-01-20 14:42:57',NULL,NULL),(312,NULL,NULL,'ff99fc8eda0640928c6e82981dacb266',NULL,NULL,NULL,NULL,'2026-01-20 14:43:18',NULL,'2026-01-20 14:43:18',NULL,NULL),(313,NULL,'4b95747114ab4043b93a260387199c91',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:43:20',NULL,'2026-01-20 14:43:20',NULL,NULL),(314,NULL,NULL,'aa2e7857e85f483eb0d162e2ee8c2e2c',NULL,NULL,NULL,NULL,'2026-01-20 14:43:28',NULL,'2026-01-20 14:43:28',NULL,NULL),(315,NULL,'a3e022a35f604df2bbc885e498b1e206',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:43:29',NULL,'2026-01-20 14:43:29',NULL,NULL),(316,NULL,NULL,'6a00517a957e4ceb8564cbf1dfa15ee2',NULL,NULL,NULL,NULL,'2026-01-20 14:43:29',NULL,'2026-01-20 14:43:29',NULL,NULL),(317,NULL,'13c0d93976f745dba4ab050770ccaae6',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:43:31',NULL,'2026-01-20 14:43:31',NULL,NULL),(318,NULL,NULL,'5cb9a6185e8b46178f08547a31a61ab7',NULL,NULL,NULL,NULL,'2026-01-20 14:43:34',NULL,'2026-01-20 14:43:34',NULL,NULL),(319,NULL,'cf7c167fbbe144a9b62002cd4690cf35',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:43:39',NULL,'2026-01-20 14:43:39',NULL,NULL),(320,NULL,NULL,'7382dbb4dfeb47a08ece33c6f113d77c',NULL,NULL,NULL,NULL,'2026-01-20 14:44:10',NULL,'2026-01-20 14:44:10',NULL,NULL),(321,NULL,NULL,'2975742546164cad937d13671d17108a',NULL,NULL,NULL,NULL,'2026-01-20 14:44:11',NULL,'2026-01-20 14:44:11',NULL,NULL),(322,NULL,'9fbbc94ed3bb41b1a060e5a7e1099ccf',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:44:12',NULL,'2026-01-20 14:44:12',NULL,NULL),(323,NULL,'28a523cfe06042ff96554913a78e1e3a',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:44:13',NULL,'2026-01-20 14:44:13',NULL,NULL),(324,NULL,NULL,'5c3328d5d79641b0bc4d2f97582ca3cf',NULL,NULL,NULL,NULL,'2026-01-20 14:44:54',NULL,'2026-01-20 14:44:54',NULL,NULL),(325,NULL,'56a999e2b19840cab7a889876343a7db',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:44:55',NULL,'2026-01-20 14:44:55',NULL,NULL),(326,NULL,NULL,'9051b1fd0e0b40c2be07afc6da803903',NULL,NULL,NULL,NULL,'2026-01-20 14:45:36',NULL,'2026-01-20 14:45:36',NULL,NULL),(327,NULL,'144d821b8f624db687f0e009c5e06d8b',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:45:37',NULL,'2026-01-20 14:45:37',NULL,NULL),(328,NULL,NULL,'5cd9508688214bedb977528f8b6f95d1',NULL,NULL,NULL,NULL,'2026-01-20 14:47:15',NULL,'2026-01-20 14:47:15',NULL,NULL),(329,NULL,NULL,'47a8d6ed70fc4043b68f7c1fc1cbed67',NULL,NULL,NULL,NULL,'2026-01-20 14:47:16',NULL,'2026-01-20 14:47:16',NULL,NULL),(330,NULL,'7bbf722f17654404925cfb53e48cd473',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:47:16',NULL,'2026-01-20 14:47:16',NULL,NULL),(331,NULL,'ad41fd058cde40f6b075e55a0de5b4a7',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:47:17',NULL,'2026-01-20 14:47:17',NULL,NULL),(332,NULL,NULL,'37e9ef97fbe0448e9fbe32d48b66211f',NULL,NULL,NULL,NULL,'2026-01-20 14:48:06',NULL,'2026-01-20 14:48:06',NULL,NULL),(333,NULL,'3b31139b2a4e49cba5e7048febf901c4',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:48:07',NULL,'2026-01-20 14:48:07',NULL,NULL),(334,NULL,NULL,'869086208e10436c9dc96c78bee9a85d',NULL,NULL,NULL,NULL,'2026-01-20 14:49:04',NULL,'2026-01-20 14:49:04',NULL,NULL),(335,NULL,'b683fcc0026242e28ba6d8fba638688e',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:49:07',NULL,'2026-01-20 14:49:07',NULL,NULL),(336,NULL,NULL,'38ef13d691534d06a5110be95454010f',NULL,NULL,NULL,NULL,'2026-01-20 14:50:06',NULL,'2026-01-20 14:50:06',NULL,NULL),(337,NULL,'a08a6f2a8aee493980fd658fae9e7fb4',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:50:07',NULL,'2026-01-20 14:50:07',NULL,NULL),(338,NULL,NULL,'1d45e7e42e6d419898780db108ff93ff',NULL,NULL,NULL,NULL,'2026-01-20 14:51:33',NULL,'2026-01-20 14:51:33',NULL,NULL),(339,NULL,NULL,'fb03a502eb1345838f54f770f39378d0',NULL,NULL,NULL,NULL,'2026-01-20 14:51:33',NULL,'2026-01-20 14:51:33',NULL,NULL),(340,NULL,'47bcba959fad4797bb6982399f0815bc',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:51:34',NULL,'2026-01-20 14:51:34',NULL,NULL),(341,NULL,'b15c4e6eb57e4b0ca4e63c85ed92fc5f',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:51:35',NULL,'2026-01-20 14:51:35',NULL,NULL),(342,NULL,NULL,'3e9278fdb9e645b7938f3edb20c4d3cf',NULL,NULL,NULL,NULL,'2026-01-20 14:51:36',NULL,'2026-01-20 14:51:36',NULL,NULL),(343,NULL,'1c5f03d46c0c4162a3b2f1530850bb6c',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:51:37',NULL,'2026-01-20 14:51:37',NULL,NULL),(344,NULL,NULL,'a1bd93d04cc4468abe1d5c61f5144191',NULL,NULL,NULL,NULL,'2026-01-20 14:51:42',NULL,'2026-01-20 14:51:42',NULL,NULL),(345,NULL,'acb30fbc0e3749e390d7f867060b5a2a',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:51:43',NULL,'2026-01-20 14:51:43',NULL,NULL),(346,NULL,NULL,'aa11200594ea436083cff39ea4deb712',NULL,NULL,NULL,NULL,'2026-01-20 14:52:17',NULL,'2026-01-20 14:52:17',NULL,NULL),(347,NULL,'49b57d772e7445cb96a38758bdb38839',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:52:20',NULL,'2026-01-20 14:52:20',NULL,NULL),(348,NULL,NULL,'cdcdce94e7354b3bafb34285408888b9',NULL,NULL,NULL,NULL,'2026-01-20 14:52:31',NULL,'2026-01-20 14:52:31',NULL,NULL),(349,NULL,NULL,'b6c61273669646da957be416d2924a52',NULL,NULL,NULL,NULL,'2026-01-20 14:52:31',NULL,'2026-01-20 14:52:31',NULL,NULL),(350,NULL,'ecfc3366b9194864a3f15ce0114b5ee3',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:52:33',NULL,'2026-01-20 14:52:33',NULL,NULL),(351,NULL,NULL,'6e578c6918854eedb3f2d6466491ff21',NULL,NULL,NULL,NULL,'2026-01-20 14:52:36',NULL,'2026-01-20 14:52:36',NULL,NULL),(352,NULL,'0b3e164aed784d06a5fbc80f7e78ffd9',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:52:42',NULL,'2026-01-20 14:52:42',NULL,NULL),(353,NULL,NULL,'15c455b119784bb9abe8e4774dadd01e',NULL,NULL,NULL,NULL,'2026-01-20 14:54:48',NULL,'2026-01-20 14:54:48',NULL,NULL),(354,NULL,'0ad54030e5cc477e939e073b52024ec4',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:54:49',NULL,'2026-01-20 14:54:49',NULL,NULL),(355,NULL,NULL,'50108de2458b4a0988111e0a0e271937',NULL,NULL,NULL,NULL,'2026-01-20 14:55:02',NULL,'2026-01-20 14:55:02',NULL,NULL),(356,NULL,NULL,'d85d286ce6224326a0f4a15a06afbfea',NULL,NULL,NULL,NULL,'2026-01-20 14:55:04',NULL,'2026-01-20 14:55:04',NULL,NULL),(357,NULL,'45810a5a04b6407f90b37499538f63ba',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:55:06',NULL,'2026-01-20 14:55:06',NULL,NULL),(358,NULL,'0a29915e0dd2403fbd7b7e847696b00a',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:55:07',NULL,'2026-01-20 14:55:07',NULL,NULL),(359,NULL,NULL,'c665b0bab3e6425f98497bc3ebae79da',NULL,NULL,NULL,NULL,'2026-01-20 14:55:11',NULL,'2026-01-20 14:55:11',NULL,NULL),(360,NULL,NULL,'721e16b0108c4098b53125e4e7832793',NULL,NULL,NULL,NULL,'2026-01-20 14:55:11',NULL,'2026-01-20 14:55:11',NULL,NULL),(361,NULL,'b0ff04ef332d41aaac65a7b7f9955fe3',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:55:12',NULL,'2026-01-20 14:55:12',NULL,NULL),(362,NULL,NULL,'87bcc22682984b40b43e0246ea142695',NULL,NULL,NULL,NULL,'2026-01-20 14:55:45',NULL,'2026-01-20 14:55:45',NULL,NULL),(363,NULL,'ec388b65a7fc480f99d0ceb5451725ea',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:55:46',NULL,'2026-01-20 14:55:46',NULL,NULL),(364,NULL,NULL,'34eb73f628994c11801d447148d5f142',NULL,NULL,NULL,NULL,'2026-01-20 14:56:21',NULL,'2026-01-20 14:56:21',NULL,NULL),(365,NULL,'b1e83af992c94112a965575784639d77',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:56:22',NULL,'2026-01-20 14:56:22',NULL,NULL),(366,NULL,NULL,'f6f144f1d330427e82e84c891e9a8a89',NULL,NULL,NULL,NULL,'2026-01-20 14:56:25',NULL,'2026-01-20 14:56:25',NULL,NULL),(367,NULL,'4be5b75b5dcb4eeea9759f7c4a779ffa',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:56:25',NULL,'2026-01-20 14:56:25',NULL,NULL),(368,NULL,NULL,'caca84670125404db34273d4d6da36df',NULL,NULL,NULL,NULL,'2026-01-20 14:56:38',NULL,'2026-01-20 14:56:38',NULL,NULL),(369,NULL,'fb4410ee5e824adfa71950de60e627af',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:56:39',NULL,'2026-01-20 14:56:39',NULL,NULL),(370,NULL,NULL,'dfd5104fceae4866b873bac8a1dcd2f4',NULL,NULL,NULL,NULL,'2026-01-20 14:56:43',NULL,'2026-01-20 14:56:43',NULL,NULL),(371,NULL,'1f63ad86df7645789dbd92ce33f0aa76',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:56:45',NULL,'2026-01-20 14:56:45',NULL,NULL),(372,NULL,NULL,'168ca7898b964a44b76c90912fa89a66',NULL,NULL,NULL,NULL,'2026-01-20 14:57:42',NULL,'2026-01-20 14:57:42',NULL,NULL),(373,NULL,'4d4e37f4fd7f4dbbb25648ec639e0e43',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:57:43',NULL,'2026-01-20 14:57:43',NULL,NULL),(374,NULL,NULL,'215db37373dc4ae5a75cbd6866f471da',NULL,NULL,NULL,NULL,'2026-01-20 14:58:04',NULL,'2026-01-20 14:58:04',NULL,NULL),(375,NULL,'b3b1b7f5b4f84b5abbc401eb577c85c0',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:58:07',NULL,'2026-01-20 14:58:07',NULL,NULL),(376,NULL,NULL,'395a5c503218411284bc94c45263d1fb',NULL,NULL,NULL,NULL,'2026-01-20 14:58:25',NULL,'2026-01-20 14:58:25',NULL,NULL),(377,NULL,NULL,'3585a194e3234df896b058603ef96b65',NULL,NULL,NULL,NULL,'2026-01-20 14:58:26',NULL,'2026-01-20 14:58:26',NULL,NULL),(378,NULL,'ca6cd0afe0ab41e3ab36d21a4129f734',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:58:27',NULL,'2026-01-20 14:58:27',NULL,NULL),(379,NULL,NULL,'0362dea63d5a43778f8d4164a77cd3c6',NULL,NULL,NULL,NULL,'2026-01-20 14:59:02',NULL,'2026-01-20 14:59:02',NULL,NULL),(380,NULL,'bae96a4c20ce4f3a859ff518a8423db5',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:59:03',NULL,'2026-01-20 14:59:03',NULL,NULL),(381,NULL,NULL,'f78d8330caf745e1b9d9eb71d167e735',NULL,NULL,NULL,NULL,'2026-01-20 14:59:10',NULL,'2026-01-20 14:59:10',NULL,NULL),(382,NULL,NULL,'08f862c99a63481fac10cd3626173173',NULL,NULL,NULL,NULL,'2026-01-20 14:59:10',NULL,'2026-01-20 14:59:10',NULL,NULL),(383,NULL,'328eb4a8f5794532b12c0c1568f72f97',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:59:11',NULL,'2026-01-20 14:59:11',NULL,NULL),(384,NULL,'9edd9bb3389a4ef2a90569bcdd524d35',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:59:11',NULL,'2026-01-20 14:59:11',NULL,NULL),(385,NULL,NULL,'d3e90aecf1ba44b78ebb3f84584a1493',NULL,NULL,NULL,NULL,'2026-01-20 14:59:18',NULL,'2026-01-20 14:59:18',NULL,NULL),(386,NULL,'e035f808f4c144beaa4ed012ec39fdc3',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:59:20',NULL,'2026-01-20 14:59:20',NULL,NULL),(387,NULL,NULL,'7814f86431d3447a8bd594c0b06e8814',NULL,NULL,NULL,NULL,'2026-01-20 14:59:25',NULL,'2026-01-20 14:59:25',NULL,NULL),(388,NULL,'997e8ca04b634a8394372ac7b14d3632',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:59:26',NULL,'2026-01-20 14:59:26',NULL,NULL),(389,NULL,NULL,'2065c1af458449dc846927bf26d9e898',NULL,NULL,NULL,NULL,'2026-01-20 14:59:27',NULL,'2026-01-20 14:59:27',NULL,NULL),(390,NULL,'e5c5554522a74ef0b79ef75ce7266d7d',NULL,NULL,NULL,NULL,NULL,'2026-01-20 14:59:29',NULL,'2026-01-20 14:59:29',NULL,NULL),(391,NULL,NULL,'2a9592dd9fc5492a92e3b21c894f6443',NULL,NULL,NULL,NULL,'2026-01-20 15:00:07',NULL,'2026-01-20 15:00:07',NULL,NULL),(392,NULL,'19d56573457a4a0ba86eaae5ca9f2e17',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:00:09',NULL,'2026-01-20 15:00:09',NULL,NULL),(393,NULL,NULL,'ed2c9bd268d1491fa3484d86bcdb9ec6',NULL,NULL,NULL,NULL,'2026-01-20 15:00:24',NULL,'2026-01-20 15:00:24',NULL,NULL),(394,NULL,NULL,'e9e49275579c4c23863bc4bad9e543e8',NULL,NULL,NULL,NULL,'2026-01-20 15:00:24',NULL,'2026-01-20 15:00:24',NULL,NULL),(395,NULL,'7aaf4d4320fd4f65833852a4d02883c7',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:00:27',NULL,'2026-01-20 15:00:27',NULL,NULL),(396,NULL,'107c1f3b5b7b413d9a389ca1166e331f',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:00:29',NULL,'2026-01-20 15:00:29',NULL,NULL),(397,NULL,NULL,'48a567f3890d43dbbcd9ee3c302b1772',NULL,NULL,NULL,NULL,'2026-01-20 15:00:52',NULL,'2026-01-20 15:00:52',NULL,NULL),(398,NULL,'0d9bc40379a44b2eaa53062a0c0385d5',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:00:54',NULL,'2026-01-20 15:00:54',NULL,NULL),(399,NULL,NULL,'2a3fc2ba2a08423eb2e0bd7cf0fd5cf7',NULL,NULL,NULL,NULL,'2026-01-20 15:01:03',NULL,'2026-01-20 15:01:03',NULL,NULL),(400,NULL,NULL,'9b1bb8183cf343d685e73c8fab66d8e5',NULL,NULL,NULL,NULL,'2026-01-20 15:01:04',NULL,'2026-01-20 15:01:04',NULL,NULL),(401,NULL,'87e593e3299148e484ee302888c90c80',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:01:09',NULL,'2026-01-20 15:01:09',NULL,NULL),(402,NULL,'994b02a8c0094d2daa7b775b1f86f394',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:01:10',NULL,'2026-01-20 15:01:10',NULL,NULL),(403,NULL,NULL,'37466ba8c9504f1ca6cfbce8add0b52a',NULL,NULL,NULL,NULL,'2026-01-20 15:01:27',NULL,'2026-01-20 15:01:27',NULL,NULL),(404,NULL,NULL,'f6d0f7b19b0f4e069a9851eeb7084417',NULL,NULL,NULL,NULL,'2026-01-20 15:01:27',NULL,'2026-01-20 15:01:27',NULL,NULL),(405,NULL,'5b0df7d3c2e34d109314d3f7a775d453',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:01:27',NULL,'2026-01-20 15:01:27',NULL,NULL),(406,NULL,'41da7b7508634e869bbbe5203e7023cc',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:01:28',NULL,'2026-01-20 15:01:28',NULL,NULL),(407,NULL,NULL,'d77d3db3cf924683a608d10efefcd156',NULL,NULL,NULL,NULL,'2026-01-20 15:02:05',NULL,'2026-01-20 15:02:05',NULL,NULL),(408,NULL,'105e56abe3804424885c7aa8d1216d12',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:02:07',NULL,'2026-01-20 15:02:07',NULL,NULL),(409,NULL,NULL,'0e171c9791cb4c1b8cb8efa3521425fb',NULL,NULL,NULL,NULL,'2026-01-20 15:02:48',NULL,'2026-01-20 15:02:48',NULL,NULL),(410,NULL,NULL,'158563a99d4a420890aaa00b05c8bb57',NULL,NULL,NULL,NULL,'2026-01-20 15:02:48',NULL,'2026-01-20 15:02:48',NULL,NULL),(411,NULL,'908b5ba217ab458e8c9aa0e5a471c194',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:02:49',NULL,'2026-01-20 15:02:49',NULL,NULL),(412,NULL,'654b3ce7b3644fc58f8dc9f60529320b',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:02:50',NULL,'2026-01-20 15:02:50',NULL,NULL),(413,NULL,NULL,'1654794111844ca88666b3529173e9a7',NULL,NULL,NULL,NULL,'2026-01-20 15:04:23',NULL,'2026-01-20 15:04:23',NULL,NULL),(414,NULL,NULL,'8613d3e299554ff198a2d9b36f4bfbe3',NULL,NULL,NULL,NULL,'2026-01-20 15:04:24',NULL,'2026-01-20 15:04:24',NULL,NULL),(415,NULL,'3a1d679d5c954662a271e842fe2f2c05',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:04:26',NULL,'2026-01-20 15:04:26',NULL,NULL),(416,NULL,'ba4011bcb97141ada81290e8f7801e91',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:04:27',NULL,'2026-01-20 15:04:27',NULL,NULL),(417,NULL,NULL,'2446e8399b344b29986c1aaf8bf73adf',NULL,NULL,NULL,NULL,'2026-01-20 15:05:34',NULL,'2026-01-20 15:05:34',NULL,NULL),(418,NULL,'63555e5851564db08c6429231d264f2c',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:05:35',NULL,'2026-01-20 15:05:35',NULL,NULL),(419,NULL,NULL,'912329b1a6ad42bdb72e952c03983bdf',NULL,NULL,NULL,NULL,'2026-01-20 15:05:55',NULL,'2026-01-20 15:05:55',NULL,NULL),(420,NULL,'96f7b14c2a9348f08305fe232df2a603',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:05:55',NULL,'2026-01-20 15:05:55',NULL,NULL),(421,NULL,NULL,'f2cbb7f709bf4399b8a8137d2cbab438',NULL,NULL,NULL,NULL,'2026-01-20 15:06:04',NULL,'2026-01-20 15:06:04',NULL,NULL),(422,NULL,'f9a4fb1ea67548318c6ff2af4e9d4abe',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:06:06',NULL,'2026-01-20 15:06:06',NULL,NULL),(423,NULL,NULL,'8560f9b6edd74b238f90f667e46566ac',NULL,NULL,NULL,NULL,'2026-01-20 15:06:12',NULL,'2026-01-20 15:06:12',NULL,NULL),(424,NULL,'329ef67ba7884caa87edf40d2d26e70f',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:06:14',NULL,'2026-01-20 15:06:14',NULL,NULL),(425,NULL,NULL,'b02a8ef6cc3946ceb2c8846aae2eae68',NULL,NULL,NULL,NULL,'2026-01-20 15:07:24',NULL,'2026-01-20 15:07:24',NULL,NULL),(426,NULL,NULL,'f6786528de3e4469bfe1b2170457b33f',NULL,NULL,NULL,NULL,'2026-01-20 15:07:24',NULL,'2026-01-20 15:07:24',NULL,NULL),(427,NULL,'0fc924d2df984301897e81920c5e192f',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:07:25',NULL,'2026-01-20 15:07:25',NULL,NULL),(428,NULL,'0f24c2c7642c4c879d983d5f7344cad7',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:07:26',NULL,'2026-01-20 15:07:26',NULL,NULL),(429,NULL,NULL,'bc554998e71a4322bdd27ac727a9044c',NULL,NULL,NULL,NULL,'2026-01-20 15:07:34',NULL,'2026-01-20 15:07:34',NULL,NULL),(430,NULL,NULL,'14500f52247644ceb1be759348dcda8d',NULL,NULL,NULL,NULL,'2026-01-20 15:07:35',NULL,'2026-01-20 15:07:35',NULL,NULL),(431,NULL,NULL,'a2beb3d6247e457abd6e8d93cc602f02',NULL,NULL,NULL,NULL,'2026-01-20 15:07:35',NULL,'2026-01-20 15:07:35',NULL,NULL),(432,NULL,'0d3c7658be134845bc696bd480bc2332',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:07:36',NULL,'2026-01-20 15:07:36',NULL,NULL),(433,NULL,'5e161d5a47f845fd89eb3f10627a0830',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:07:36',NULL,'2026-01-20 15:07:36',NULL,NULL),(434,NULL,'e142d118583b4f9ba3531bcf3838e256',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:07:37',NULL,'2026-01-20 15:07:37',NULL,NULL),(435,NULL,NULL,'2448cb9fc52c409085b592bb68460500',NULL,NULL,NULL,NULL,'2026-01-20 15:07:44',NULL,'2026-01-20 15:07:44',NULL,NULL),(436,NULL,NULL,'609547764c2d425b8ed6a2cd561c903b',NULL,NULL,NULL,NULL,'2026-01-20 15:07:45',NULL,'2026-01-20 15:07:45',NULL,NULL),(437,NULL,'6e6ebd7f79df41f3ac54d0fe19a664a4',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:07:45',NULL,'2026-01-20 15:07:45',NULL,NULL),(438,NULL,NULL,'1cdce555ec694255a154517f28a12ae5',NULL,NULL,NULL,NULL,'2026-01-20 15:07:59',NULL,'2026-01-20 15:07:59',NULL,NULL),(439,NULL,NULL,'88e1a17e3d0f43f2825fc92f6ad06f7f',NULL,NULL,NULL,NULL,'2026-01-20 15:07:59',NULL,'2026-01-20 15:07:59',NULL,NULL),(440,NULL,'526db518ca3942b58ee346d4bd970e42',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:08:00',NULL,'2026-01-20 15:08:00',NULL,NULL),(441,NULL,'124b1704e1184f729f23d30b99629362',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:08:01',NULL,'2026-01-20 15:08:01',NULL,NULL),(442,NULL,NULL,'467630ad66f84c4ba21657f6e5db7d10',NULL,NULL,NULL,NULL,'2026-01-20 15:09:20',NULL,'2026-01-20 15:09:20',NULL,NULL),(443,NULL,NULL,'26430b6554264c98b083c01b3f62b05f',NULL,NULL,NULL,NULL,'2026-01-20 15:09:20',NULL,'2026-01-20 15:09:20',NULL,NULL),(444,NULL,'4f7fa9b51f9141ada831a5221803b261',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:09:21',NULL,'2026-01-20 15:09:21',NULL,NULL),(445,NULL,'48aeeaa346bb4dfba4dfc598ae41f062',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:09:22',NULL,'2026-01-20 15:09:22',NULL,NULL),(446,NULL,NULL,'27658864f96d453586dd0846a4c55b7d',NULL,NULL,NULL,NULL,'2026-01-20 15:10:52',NULL,'2026-01-20 15:10:52',NULL,NULL),(447,NULL,'fc74c4a296554866969b05aef75252af',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:10:53',NULL,'2026-01-20 15:10:53',NULL,NULL),(448,NULL,NULL,'17140eb73c0b4236807367396cc4959b',NULL,NULL,NULL,NULL,'2026-01-20 15:11:30',NULL,'2026-01-20 15:11:30',NULL,NULL),(449,NULL,'eac67fc3f12d4e9f9e47de6b79eea88f',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:11:30',NULL,'2026-01-20 15:11:30',NULL,NULL),(450,NULL,NULL,'c98bd3f0904e48efa524d598bcad85e9',NULL,NULL,NULL,NULL,'2026-01-20 15:11:31',NULL,'2026-01-20 15:11:31',NULL,NULL),(451,NULL,NULL,'8d3565aa0cf54709b7f902f475ce21dc',NULL,NULL,NULL,NULL,'2026-01-20 15:11:31',NULL,'2026-01-20 15:11:31',NULL,NULL),(452,NULL,'525800725fa14781ac981fab8105851a',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:11:32',NULL,'2026-01-20 15:11:32',NULL,NULL),(453,NULL,'5b43342be22543f79d4a56e26c6d0c96',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:11:33',NULL,'2026-01-20 15:11:33',NULL,NULL),(454,NULL,NULL,'8e699d2accae4b489d779507db44504e',NULL,NULL,NULL,NULL,'2026-01-20 15:12:03',NULL,'2026-01-20 15:12:03',NULL,NULL),(455,NULL,'37c01d33832740c3ba018515e081285b',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:12:05',NULL,'2026-01-20 15:12:05',NULL,NULL),(456,NULL,NULL,'a73d4f13c0bf4d1c9497cd04e5db6724',NULL,NULL,NULL,NULL,'2026-01-20 15:12:46',NULL,'2026-01-20 15:12:46',NULL,NULL),(457,NULL,'8550ab6f7bdb4d9faa423c65e76a6818',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:12:48',NULL,'2026-01-20 15:12:48',NULL,NULL),(458,NULL,NULL,'178f27307c70414c8069038b788d2024',NULL,NULL,NULL,NULL,'2026-01-20 15:12:51',NULL,'2026-01-20 15:12:51',NULL,NULL),(459,NULL,'27350e0ef5df40aea21d596568a16a06',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:12:53',NULL,'2026-01-20 15:12:53',NULL,NULL),(460,NULL,NULL,'bf422e55e158420cbdae75f07a3bb97a',NULL,NULL,NULL,NULL,'2026-01-20 15:16:03',NULL,'2026-01-20 15:16:03',NULL,NULL),(461,NULL,NULL,'4b6f6d9dd9bc4b949c1839147a831be2',NULL,NULL,NULL,NULL,'2026-01-20 15:16:03',NULL,'2026-01-20 15:16:03',NULL,NULL),(462,NULL,'a49638950e1543fa8e0d251af5479623',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:16:06',NULL,'2026-01-20 15:16:06',NULL,NULL),(463,NULL,'bb694cce9b3f43409d6501d89e1eb358',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:16:08',NULL,'2026-01-20 15:16:08',NULL,NULL),(464,NULL,NULL,'e9cc4ce3e069479ba9c789b378a68a1d',NULL,NULL,NULL,NULL,'2026-01-20 15:17:59',NULL,'2026-01-20 15:17:59',NULL,NULL),(465,NULL,'fff727019f86407498e83d7948d54962',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:18:01',NULL,'2026-01-20 15:18:01',NULL,NULL),(466,NULL,NULL,'cd9a8f26b71f4631a387e555e6b18428',NULL,NULL,NULL,NULL,'2026-01-20 15:22:23',NULL,'2026-01-20 15:22:23',NULL,NULL),(467,NULL,'9156c0a9920c4721843416b9a44404f9',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:22:24',NULL,'2026-01-20 15:22:24',NULL,NULL),(468,NULL,NULL,'442a7a5cb8ea426a82be9762b262d171',NULL,NULL,NULL,NULL,'2026-01-20 15:25:15',NULL,'2026-01-20 15:25:15',NULL,NULL),(469,NULL,NULL,'1998f6e29a51438c82e65b66da23d380',NULL,NULL,NULL,NULL,'2026-01-20 15:25:15',NULL,'2026-01-20 15:25:15',NULL,NULL),(470,NULL,'22d14e9a73254c8981e4a13fa61158c4',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:25:18',NULL,'2026-01-20 15:25:18',NULL,NULL),(471,NULL,'1ed5feeeafe7448a8efb47ab975b0ead',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:25:19',NULL,'2026-01-20 15:25:19',NULL,NULL),(472,NULL,NULL,'5338aa65dc0e4326a66ce79053787f14',NULL,NULL,NULL,NULL,'2026-01-20 15:39:17',NULL,'2026-01-20 15:39:17',NULL,NULL),(473,NULL,NULL,'e9ecdb95baad4f088b6077b172ee4092',NULL,NULL,NULL,NULL,'2026-01-20 15:39:17',NULL,'2026-01-20 15:39:17',NULL,NULL),(474,NULL,'59d0c966a6f44970bc6b510ede729340',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:39:20',NULL,'2026-01-20 15:39:20',NULL,NULL),(475,NULL,'3168f57421fb49bfb94b85daedd1fe7d',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:39:22',NULL,'2026-01-20 15:39:22',NULL,NULL),(476,NULL,NULL,'5985ef736503499a9f1d734cabc33ce5',NULL,NULL,NULL,NULL,'2026-01-20 15:47:18',NULL,'2026-01-20 15:47:18',NULL,NULL),(477,NULL,NULL,'a8b010c120d8488bb889b23fb6abfc7f',NULL,NULL,NULL,NULL,'2026-01-20 15:47:19',NULL,'2026-01-20 15:47:19',NULL,NULL),(478,NULL,NULL,'3b16f65bd633433c8c7bf226f9e39e82',NULL,NULL,NULL,NULL,'2026-01-20 15:47:19',NULL,'2026-01-20 15:47:19',NULL,NULL),(479,NULL,'5f2ea309ae4d4ce2beba91bca141e485',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:47:24',NULL,'2026-01-20 15:47:24',NULL,NULL),(480,NULL,'124217db76ec4d598d94591670b51957',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:47:28',NULL,'2026-01-20 15:47:28',NULL,NULL),(481,NULL,'728662ec7f654a3fb2e53a90b8707d7e',NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:47:29',NULL,'2026-01-20 15:47:29',NULL,NULL);
/*!40000 ALTER TABLE `revocation_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL DEFAULT '<<null>>',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_role_name_domain_id` (`name`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` (`id`, `name`, `extra`, `domain_id`, `description`) VALUES ('23a80ab837af4318bc158d03137a0e60','swiftoperator','{}','<<null>>',NULL),('35591c5f8aef439eb27c5fa09913a1af','service','{}','<<null>>',NULL),('66d8507e292e45cda619097c69377d0c','ResellerAdmin','{}','<<null>>',NULL),('7e9f70942fec45deb0c99fd133db391a','member','{}','<<null>>',NULL),('8840d7a5644c44f5a9cc7c7914e8294b','admin','{}','<<null>>',NULL),('9033e069d03e40e1b18e26b64665a511','reader','{}','<<null>>',NULL);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_option`
--

DROP TABLE IF EXISTS `role_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_option` (
  `role_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`role_id`,`option_id`),
  CONSTRAINT `role_option_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_option`
--

LOCK TABLES `role_option` WRITE;
/*!40000 ALTER TABLE `role_option` DISABLE KEYS */;
INSERT INTO `role_option` (`role_id`, `option_id`, `option_value`) VALUES ('7e9f70942fec45deb0c99fd133db391a','IMMU','true'),('8840d7a5644c44f5a9cc7c7914e8294b','IMMU','true'),('9033e069d03e40e1b18e26b64665a511','IMMU','true');
/*!40000 ALTER TABLE `role_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sensitive_config`
--

DROP TABLE IF EXISTS `sensitive_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sensitive_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sensitive_config`
--

LOCK TABLES `sensitive_config` WRITE;
/*!40000 ALTER TABLE `sensitive_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sensitive_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `type`, `enabled`, `extra`) VALUES ('2137298014494960937be604e37746c5','placement',1,'{\"description\": \"Placement Service\", \"name\": \"placement\"}'),('3deb712684bc4d70a2bd68b2796e9de5','object-store',1,'{\"name\": \"swift\", \"description\": \"OpenStack Object Storage\"}'),('4aa92dc550804b2f8336f0f453f74b9b','identity',1,'{\"name\": \"keystone\"}'),('6ba3a571ca864d369a674307d594c9a4','network',1,'{\"description\": \"Openstack Networking\", \"name\": \"neutron\"}'),('9cfe4b5231bb40d8aab35cb8bf62d7fb','image',1,'{\"description\": \"Glance Service\", \"name\": \"glance\"}'),('b7eecfd0562d486dbe12b2f536566536','volumev3',1,'{\"description\": \"Cinder V3 Service\", \"name\": \"cinderv3\"}'),('ba9b09d84c304531bec645a1193a89c7','compute',1,'{\"description\": \"Nova Compute Service\", \"name\": \"nova\"}'),('c207768545e0472ca9899989ed9ebcdc','key-manager',1,'{\"description\": \"Barbican Service\", \"name\": \"barbican\"}'),('d176c222dd2d42e6a1161e9cf62307b8','Ceilometer',1,'{\"description\": \"Ceilometer Service\", \"name\": \"ceilometer\"}');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_provider`
--

DROP TABLE IF EXISTS `service_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_provider` (
  `auth_url` varchar(256) NOT NULL,
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `sp_url` varchar(256) NOT NULL,
  `relay_state_prefix` varchar(256) NOT NULL DEFAULT 'ss:mem:',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_provider`
--

LOCK TABLES `service_provider` WRITE;
/*!40000 ALTER TABLE `service_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `service_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_assignment`
--

DROP TABLE IF EXISTS `system_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_assignment` (
  `type` varchar(64) NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_assignment`
--

LOCK TABLES `system_assignment` WRITE;
/*!40000 ALTER TABLE `system_assignment` DISABLE KEYS */;
INSERT INTO `system_assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserSystem','34d7ff46e7af49a7aff3be601c2bd8cd','system','8840d7a5644c44f5a9cc7c7914e8294b',0);
/*!40000 ALTER TABLE `system_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `token`
--

DROP TABLE IF EXISTS `token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `token` (
  `id` varchar(64) NOT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_token_expires` (`expires`),
  KEY `ix_token_trust_id` (`trust_id`),
  KEY `ix_token_user_id` (`user_id`),
  KEY `ix_token_expires_valid` (`expires`,`valid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `token`
--

LOCK TABLES `token` WRITE;
/*!40000 ALTER TABLE `token` DISABLE KEYS */;
/*!40000 ALTER TABLE `token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust`
--

DROP TABLE IF EXISTS `trust`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust` (
  `id` varchar(64) NOT NULL,
  `trustor_user_id` varchar(64) NOT NULL,
  `trustee_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `impersonation` tinyint(1) NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `remaining_uses` int(11) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `redelegated_trust_id` varchar(64) DEFAULT NULL,
  `redelegation_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `duplicate_trust_constraint_expanded` (`trustor_user_id`,`trustee_user_id`,`project_id`,`impersonation`,`expires_at`,`expires_at_int`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust`
--

LOCK TABLES `trust` WRITE;
/*!40000 ALTER TABLE `trust` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust_role`
--

DROP TABLE IF EXISTS `trust_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust_role` (
  `trust_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`trust_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust_role`
--

LOCK TABLES `trust_role` WRITE;
/*!40000 ALTER TABLE `trust_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `default_project_id` varchar(64) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_active_at` date DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_user_id_domain_id` (`id`,`domain_id`),
  KEY `ix_default_project_id` (`default_project_id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `extra`, `enabled`, `default_project_id`, `created_at`, `last_active_at`, `domain_id`) VALUES ('0571fdb3621349bf94eb2c6bf0dfc036','{}',1,'d5b132113da54ff6b616e719b9c45446','2026-01-20 13:42:04','2026-01-20','default'),('15e2d293aecb44f4b8fadb4968d7c65b','{}',1,'d5b132113da54ff6b616e719b9c45446','2026-01-20 13:42:25','2026-01-20','default'),('20793d17eed149f9952ec71136356d92','{\"tenantId\": \"b7a779ee9b29438da0f1f05d7922ccc4\", \"email\": \"alt_demo_tempestconf@test.com\"}',1,NULL,'2026-01-20 14:21:50',NULL,'default'),('34d7ff46e7af49a7aff3be601c2bd8cd','{}',1,NULL,'2026-01-20 13:40:54','2026-01-20','default'),('549ebda85aa94cd6873c7ba778b288a7','{}',1,'d5b132113da54ff6b616e719b9c45446','2026-01-20 13:42:18','2026-01-20','default'),('78e955b46859498ab7cd8a3114b2053d','{\"tenantId\": \"7d598ceddee84859b24e9602515f3a9d\", \"email\": \"demo_tempestconf@test.com\"}',1,NULL,'2026-01-20 14:21:49',NULL,'default'),('9588bb9575134e6880029019353bcaaa','{}',1,'d5b132113da54ff6b616e719b9c45446','2026-01-20 13:42:14','2026-01-20','default'),('bfd92bb80917444799f1ff7c247bb729','{}',1,'d5b132113da54ff6b616e719b9c45446','2026-01-20 13:42:20','2026-01-20','default'),('c15645875c0f4d0e88d2a015f8b104c2','{}',1,'d5b132113da54ff6b616e719b9c45446','2026-01-20 13:42:30','2026-01-20','default'),('d2b9e6d2b72b445bab1a5d191f790af1','{}',1,'d5b132113da54ff6b616e719b9c45446','2026-01-20 13:42:10','2026-01-20','default'),('d9d129f8ada2471a84ab007bbc1a55d6','{}',1,'d5b132113da54ff6b616e719b9c45446','2026-01-20 13:58:54',NULL,'default');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_group_membership`
--

DROP TABLE IF EXISTS `user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `fk_user_group_membership_group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `fk_user_group_membership_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_group_membership`
--

LOCK TABLES `user_group_membership` WRITE;
/*!40000 ALTER TABLE `user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_option`
--

DROP TABLE IF EXISTS `user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_option` (
  `user_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`user_id`,`option_id`),
  CONSTRAINT `user_option_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_option`
--

LOCK TABLES `user_option` WRITE;
/*!40000 ALTER TABLE `user_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whitelisted_config`
--

DROP TABLE IF EXISTS `whitelisted_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whitelisted_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whitelisted_config`
--

LOCK TABLES `whitelisted_config` WRITE;
/*!40000 ALTER TABLE `whitelisted_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `whitelisted_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `mysql`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `mysql` /*!40100 DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci */;

USE `mysql`;

--
-- Table structure for table `general_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `general_log` (
  `event_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `command_type` varchar(64) NOT NULL,
  `argument` mediumtext NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='General log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slow_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `slow_log` (
  `start_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `query_time` time(6) NOT NULL,
  `lock_time` time(6) NOT NULL,
  `rows_sent` bigint(20) unsigned NOT NULL,
  `rows_examined` bigint(20) unsigned NOT NULL,
  `db` varchar(512) NOT NULL,
  `last_insert_id` int(11) NOT NULL,
  `insert_id` int(11) NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `sql_text` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `rows_affected` bigint(20) unsigned NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Slow log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `column_stats`
--

DROP TABLE IF EXISTS `column_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `column_stats` (
  `db_name` varchar(64) NOT NULL,
  `table_name` varchar(64) NOT NULL,
  `column_name` varchar(64) NOT NULL,
  `min_value` varbinary(255) DEFAULT NULL,
  `max_value` varbinary(255) DEFAULT NULL,
  `nulls_ratio` decimal(12,4) DEFAULT NULL,
  `avg_length` decimal(12,4) DEFAULT NULL,
  `avg_frequency` decimal(12,4) DEFAULT NULL,
  `hist_size` tinyint(3) unsigned DEFAULT NULL,
  `hist_type` enum('SINGLE_PREC_HB','DOUBLE_PREC_HB') DEFAULT NULL,
  `histogram` varbinary(255) DEFAULT NULL,
  PRIMARY KEY (`db_name`,`table_name`,`column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='Statistics on Columns';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `column_stats`
--

LOCK TABLES `column_stats` WRITE;
/*!40000 ALTER TABLE `column_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `column_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `columns_priv`
--

DROP TABLE IF EXISTS `columns_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `columns_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Table_name` char(64) NOT NULL DEFAULT '',
  `Column_name` char(64) NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `Column_priv` set('Select','Insert','Update','References') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`Host`,`Db`,`User`,`Table_name`,`Column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Column privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `columns_priv`
--

LOCK TABLES `columns_priv` WRITE;
/*!40000 ALTER TABLE `columns_priv` DISABLE KEYS */;
/*!40000 ALTER TABLE `columns_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db`
--

DROP TABLE IF EXISTS `db`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `db` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Event_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_history_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Host`,`Db`,`User`),
  KEY `User` (`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Database privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `db`
--

LOCK TABLES `db` WRITE;
/*!40000 ALTER TABLE `db` DISABLE KEYS */;
INSERT INTO `db` (`Host`, `Db`, `User`, `Select_priv`, `Insert_priv`, `Update_priv`, `Delete_priv`, `Create_priv`, `Drop_priv`, `Grant_priv`, `References_priv`, `Index_priv`, `Alter_priv`, `Create_tmp_table_priv`, `Lock_tables_priv`, `Create_view_priv`, `Show_view_priv`, `Create_routine_priv`, `Alter_routine_priv`, `Execute_priv`, `Event_priv`, `Trigger_priv`, `Delete_history_priv`) VALUES ('localhost','keystone','keystone_5113','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','keystone','keystone_5113','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','placement','placement_5ac1','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','placement','placement_5ac1','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','glance','glance_5782','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','glance','glance_5782','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','barbican','barbican_87db','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','barbican','barbican_87db','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','cinder','cinder_6398','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','cinder','cinder_6398','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','neutron','neutron_1963','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','neutron','neutron_1963','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_cell0','nova_cell0_0566','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_cell0','nova_cell0_0566','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_api','nova_api_2aef','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_api','nova_api_2aef','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');
/*!40000 ALTER TABLE `db` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `db` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `name` char(64) NOT NULL DEFAULT '',
  `body` longblob NOT NULL,
  `definer` char(141) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `execute_at` datetime DEFAULT NULL,
  `interval_value` int(11) DEFAULT NULL,
  `interval_field` enum('YEAR','QUARTER','MONTH','DAY','HOUR','MINUTE','WEEK','SECOND','MICROSECOND','YEAR_MONTH','DAY_HOUR','DAY_MINUTE','DAY_SECOND','HOUR_MINUTE','HOUR_SECOND','MINUTE_SECOND','DAY_MICROSECOND','HOUR_MICROSECOND','MINUTE_MICROSECOND','SECOND_MICROSECOND') DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_executed` datetime DEFAULT NULL,
  `starts` datetime DEFAULT NULL,
  `ends` datetime DEFAULT NULL,
  `status` enum('ENABLED','DISABLED','SLAVESIDE_DISABLED') NOT NULL DEFAULT 'ENABLED',
  `on_completion` enum('DROP','PRESERVE') NOT NULL DEFAULT 'DROP',
  `sql_mode` set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','IGNORE_BAD_TABLE_OPTIONS','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH','EMPTY_STRING_IS_NULL','SIMULTANEOUS_ASSIGNMENT','TIME_ROUND_FRACTIONAL') NOT NULL DEFAULT '',
  `comment` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `originator` int(10) unsigned NOT NULL,
  `time_zone` char(64) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT 'SYSTEM',
  `character_set_client` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `collation_connection` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `db_collation` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `body_utf8` longblob DEFAULT NULL,
  PRIMARY KEY (`db`,`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Events';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `func`
--

DROP TABLE IF EXISTS `func`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `func` (
  `name` char(64) NOT NULL DEFAULT '',
  `ret` tinyint(1) NOT NULL DEFAULT 0,
  `dl` char(128) NOT NULL DEFAULT '',
  `type` enum('function','aggregate') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='User defined functions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `func`
--

LOCK TABLES `func` WRITE;
/*!40000 ALTER TABLE `func` DISABLE KEYS */;
/*!40000 ALTER TABLE `func` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `global_priv`
--

DROP TABLE IF EXISTS `global_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Priv` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '{}' CHECK (json_valid(`Priv`)),
  PRIMARY KEY (`Host`,`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Users and global privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `global_priv`
--

LOCK TABLES `global_priv` WRITE;
/*!40000 ALTER TABLE `global_priv` DISABLE KEYS */;
INSERT INTO `global_priv` (`Host`, `User`, `Priv`) VALUES ('localhost','mariadb.sys','{\"access\":0,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"\",\"account_locked\":true,\"password_last_changed\":0}'),('localhost','root','{\"access\": 549755813887, \"plugin\": \"mysql_native_password\", \"authentication_string\": \"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\", \"auth_or\": [{}],\"version_id\":100529,\"password_last_changed\":1768916432}'),('%','root','{\"access\":549755813887,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\",\"password_last_changed\":1768916432}'),('localhost','keystone_5113','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*9DFE2F3E07050C2B8ABCCF7AD81C39B14C14FB7D\",\"password_last_changed\":1768916424}'),('%','keystone_5113','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*9DFE2F3E07050C2B8ABCCF7AD81C39B14C14FB7D\",\"password_last_changed\":1768916424}'),('localhost','placement_5ac1','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*18648FC5810E2616E20EE7947BA8523DF9B25F97\",\"password_last_changed\":1768916425}'),('%','placement_5ac1','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*18648FC5810E2616E20EE7947BA8523DF9B25F97\",\"password_last_changed\":1768916425}'),('localhost','glance_5782','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*42B290C578DA67CCC050B0E60B272F2827A5275C\",\"password_last_changed\":1768916430}'),('%','glance_5782','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*42B290C578DA67CCC050B0E60B272F2827A5275C\",\"password_last_changed\":1768916430}'),('localhost','barbican_87db','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*8B44F01BDBE2CB2B99ABC66B426AC5B135BDA133\",\"password_last_changed\":1768916432}'),('%','barbican_87db','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*8B44F01BDBE2CB2B99ABC66B426AC5B135BDA133\",\"password_last_changed\":1768916432}'),('localhost','cinder_6398','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*0090201F63D341C570E8A7AE5A5C065FAF365631\",\"password_last_changed\":1768916432}'),('%','cinder_6398','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*0090201F63D341C570E8A7AE5A5C065FAF365631\",\"password_last_changed\":1768916433}'),('localhost','neutron_1963','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*8B9A40AF02B5D696712A6BAA375AA096D9CD639E\",\"password_last_changed\":1768916433}'),('%','neutron_1963','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*8B9A40AF02B5D696712A6BAA375AA096D9CD639E\",\"password_last_changed\":1768916433}'),('localhost','nova_cell0_0566','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*5ABC9547438D824B62CD8018FBCF58ECC2F6252D\",\"password_last_changed\":1768916545}'),('%','nova_cell0_0566','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*5ABC9547438D824B62CD8018FBCF58ECC2F6252D\",\"password_last_changed\":1768916545}'),('localhost','nova_api_2aef','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*36108156D1286246E3FB69580C39157B5120C977\",\"password_last_changed\":1768916545}'),('%','nova_api_2aef','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*36108156D1286246E3FB69580C39157B5120C977\",\"password_last_changed\":1768916545}');
/*!40000 ALTER TABLE `global_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gtid_slave_pos`
--

DROP TABLE IF EXISTS `gtid_slave_pos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gtid_slave_pos` (
  `domain_id` int(10) unsigned NOT NULL,
  `sub_id` bigint(20) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `seq_no` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`domain_id`,`sub_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci COMMENT='Replication slave GTID position';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gtid_slave_pos`
--

LOCK TABLES `gtid_slave_pos` WRITE;
/*!40000 ALTER TABLE `gtid_slave_pos` DISABLE KEYS */;
/*!40000 ALTER TABLE `gtid_slave_pos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_category`
--

DROP TABLE IF EXISTS `help_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_category` (
  `help_category_id` smallint(5) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `parent_category_id` smallint(5) unsigned DEFAULT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_category_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_category`
--

LOCK TABLES `help_category` WRITE;
/*!40000 ALTER TABLE `help_category` DISABLE KEYS */;
INSERT INTO `help_category` (`help_category_id`, `name`, `parent_category_id`, `url`) VALUES (1,'Contents',0,''),(2,'Polygon Properties',34,''),(3,'WKT',34,''),(4,'Numeric Functions',37,''),(5,'Plugins',1,''),(6,'MBR',34,''),(7,'Control Flow Functions',37,''),(8,'Transactions',1,''),(9,'Help Metadata',1,''),(10,'Account Management',1,''),(11,'Point Properties',34,''),(12,'Encryption Functions',37,''),(13,'LineString Properties',34,''),(14,'Miscellaneous Functions',37,''),(15,'Logical Operators',47,''),(16,'Functions and Modifiers for Use with GROUP BY',1,''),(17,'Information Functions',37,''),(18,'Assignment Operators',47,''),(19,'Comparison Operators',47,''),(20,'Bit Functions',37,''),(21,'Table Maintenance',1,''),(22,'User-Defined Functions',1,''),(23,'Data Types',1,''),(24,'Compound Statements',1,''),(25,'Geometry Constructors',34,''),(26,'Administration',1,''),(27,'Data Manipulation',1,''),(28,'Utility',1,''),(29,'Language Structure',1,''),(30,'Geometry Relations',34,''),(31,'Date and Time Functions',37,''),(32,'WKB',34,''),(33,'Procedures',1,''),(34,'Geographic Features',1,''),(35,'Geometry Properties',34,''),(36,'String Functions',37,''),(37,'Functions',1,''),(38,'Data Definition',1,''),(39,'Sequences',1,''),(40,'JSON Functions',37,''),(41,'Window Functions',37,''),(42,'Spider Functions',37,''),(43,'Dynamic Column Functions',37,''),(44,'Galera Functions',37,''),(45,'Temporal Tables',1,''),(46,'GeoJSON',34,''),(47,'Operators',1,''),(48,'Arithmetic Operators',47,''),(49,'Replication',1,''),(50,'Prepared Statements',1,'');
/*!40000 ALTER TABLE `help_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_keyword`
--

DROP TABLE IF EXISTS `help_keyword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_keyword` (
  `help_keyword_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  PRIMARY KEY (`help_keyword_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help keywords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_keyword`
--

LOCK TABLES `help_keyword` WRITE;
/*!40000 ALTER TABLE `help_keyword` DISABLE KEYS */;
INSERT INTO `help_keyword` (`help_keyword_id`, `name`) VALUES (1,'work'),(2,'locks'),(3,'locking'),(4,'drop'),(5,'super'),(6,'usage'),(7,'binlog admin'),(8,'binlog monitor'),(9,'binlog replay'),(10,'connection admin'),(11,'federated admin'),(12,'grant option'),(13,'read_only admin'),(14,'replica monitor'),(15,'replication replica'),(16,'roles'),(17,'values'),(18,'value'),(19,'not'),(20,'and'),(21,'or'),(22,':='),(23,'assignment operator'),(24,'='),(25,'!='),(26,'<>'),(27,'not equal'),(28,'less than'),(29,'less than or equal'),(30,'NULL-safe equal'),(31,'equal'),(32,'greater than'),(33,'greater than or equal'),(34,'bitwise and'),(35,'shift left'),(36,'shift right'),(37,'bitwise xor'),(38,'bitwise or'),(39,'bitwise not'),(40,'returns'),(41,'udfs'),(42,'udf calling sequences'),(43,'udf security'),(44,'int1'),(45,'int2'),(46,'int3'),(47,'integer'),(48,'int4'),(49,'int8'),(50,'dec'),(51,'numeric'),(52,'fixed'),(53,'number'),(54,'real'),(55,'double precision'),(56,'nchar'),(57,'long'),(58,'long varchar'),(59,'repeat'),(60,'declare'),(61,'cursor'),(62,'show'),(63,'columns'),(64,'kill connection'),(65,'kill query'),(66,'delete returning'),(67,'sql_big_result'),(68,'minus'),(69,'cte'),(70,'insert returning'),(71,'queries'),(72,'query'),(73,'explain format'),(74,'explain format json'),(75,'rlike'),(76,'character_length'),(77,'escape'),(78,'mode'),(79,'trim_oracle'),(80,'schedule'),(81,'row_format'),(82,'starts'),(83,'host'),(84,'generated columns'),(85,'virtual columns'),(86,'computed columns'),(87,'hidden columns'),(88,'nextval'),(89,'lastval'),(90,'+'),(91,'addition operator'),(92,'/'),(93,'division operator'),(94,'%'),(95,'modulo operator'),(96,'*'),(97,'multiplication operator'),(98,'-'),(99,'subtraction operator'),(100,'master_ssl_verify_cert'),(101,'start replica'),(102,'stop replica'),(103,'reset slave'),(104,'reset replica'),(105,'drop prepare'),(106,'deallocate prepare');
/*!40000 ALTER TABLE `help_keyword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_relation`
--

DROP TABLE IF EXISTS `help_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_relation` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `help_keyword_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`help_keyword_id`,`help_topic_id`),
  KEY `help_topic_id` (`help_topic_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='keyword-topic relation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_relation`
--

LOCK TABLES `help_relation` WRITE;
/*!40000 ALTER TABLE `help_relation` DISABLE KEYS */;
INSERT INTO `help_relation` (`help_topic_id`, `help_keyword_id`) VALUES (94,1),(97,2),(99,2),(101,2),(116,2),(147,2),(152,2),(157,2),(161,2),(162,2),(338,2),(438,2),(97,3),(99,3),(101,3),(116,3),(147,3),(152,3),(157,3),(161,3),(162,3),(338,3),(438,3),(106,4),(112,4),(250,4),(687,4),(697,4),(713,4),(714,4),(715,4),(716,4),(717,4),(718,4),(719,4),(720,4),(722,4),(723,4),(731,4),(107,5),(107,6),(107,7),(107,8),(107,9),(107,10),(107,11),(107,12),(107,13),(107,14),(107,15),(115,16),(166,17),(166,18),(167,19),(168,20),(170,21),(210,22),(210,23),(211,23),(211,24),(212,25),(212,26),(212,27),(213,28),(214,29),(215,30),(216,31),(217,32),(218,33),(232,34),(233,35),(234,36),(236,37),(237,38),(238,39),(249,40),(251,41),(252,42),(253,43),(255,44),(257,45),(258,46),(259,47),(259,48),(260,49),(261,50),(261,51),(261,52),(261,53),(263,54),(263,55),(269,56),(275,57),(275,58),(304,59),(664,59),(311,60),(311,61),(331,62),(332,62),(333,62),(334,62),(335,62),(342,62),(343,62),(344,62),(345,62),(346,62),(347,62),(354,62),(356,62),(357,62),(358,62),(359,62),(360,62),(361,62),(362,62),(363,62),(364,62),(365,62),(366,62),(367,62),(368,62),(369,62),(370,62),(371,62),(372,62),(373,62),(374,62),(375,62),(376,62),(377,62),(378,62),(379,62),(380,62),(381,62),(382,62),(383,62),(384,62),(385,62),(386,62),(387,62),(388,62),(389,62),(390,62),(391,62),(392,62),(393,62),(394,62),(395,62),(396,62),(397,62),(398,62),(408,62),(409,62),(333,63),(403,64),(403,65),(410,66),(414,67),(425,68),(431,69),(432,69),(433,69),(453,70),(460,71),(460,72),(466,73),(466,74),(622,75),(632,76),(651,77),(657,78),(678,79),(689,80),(696,81),(701,82),(707,83),(711,84),(711,85),(711,86),(712,87),(732,88),(733,89),(804,90),(804,91),(805,92),(805,93),(806,94),(806,95),(807,96),(807,97),(808,98),(808,99),(809,100),(810,101),(811,102),(812,103),(812,104),(816,105),(816,106);
/*!40000 ALTER TABLE `help_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_topic`
--

DROP TABLE IF EXISTS `help_topic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_topic` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `help_category_id` smallint(5) unsigned NOT NULL,
  `description` text NOT NULL,
  `example` text NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_topic_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help topics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_topic`
--

LOCK TABLES `help_topic` WRITE;
/*!40000 ALTER TABLE `help_topic` DISABLE KEYS */;
INSERT INTO `help_topic` (`help_topic_id`, `name`, `help_category_id`, `description`, `example`, `url`) VALUES (1,'HELP_DATE',9,'Help Contents generated from the MariaDB Knowledge Base on 23 January 2023.','',''),(2,'HELP_VERSION',9,'Help Contents generated for MariaDB 10.5 from the MariaDB Knowledge Base on 23 January 2023.','',''),(3,'AREA',2,'A synonym for ST_AREA.\n\nURL: https://mariadb.com/kb/en/polygon-properties-area/','','https://mariadb.com/kb/en/polygon-properties-area/'),(4,'CENTROID',2,'A synonym for ST_CENTROID.\n\nURL: https://mariadb.com/kb/en/centroid/','','https://mariadb.com/kb/en/centroid/'),(5,'ExteriorRing',2,'A synonym for ST_ExteriorRing.\n\nURL: https://mariadb.com/kb/en/polygon-properties-exteriorring/','','https://mariadb.com/kb/en/polygon-properties-exteriorring/'),(6,'InteriorRingN',2,'A synonym for ST_InteriorRingN.\n\nURL: https://mariadb.com/kb/en/polygon-properties-interiorringn/','','https://mariadb.com/kb/en/polygon-properties-interiorringn/'),(7,'NumInteriorRings',2,'A synonym for ST_NumInteriorRings.\n\nURL: https://mariadb.com/kb/en/polygon-properties-numinteriorrings/','','https://mariadb.com/kb/en/polygon-properties-numinteriorrings/'),(8,'ST_AREA',2,'Syntax\n------\n\nST_Area(poly)\nArea(poly)\n\nDescription\n-----------\n\nReturns as a double-precision number the area of the Polygon value poly, as\nmeasured in its spatial reference system.\n\nST_Area() and Area() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\n\nSELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+\n\nURL: https://mariadb.com/kb/en/st_area/','','https://mariadb.com/kb/en/st_area/'),(9,'ST_CENTROID',2,'Syntax\n------\n\nST_Centroid(mpoly)\nCentroid(mpoly)\n\nDescription\n-----------\n\nReturns a point reflecting the mathematical centroid (geometric center) for\nthe MultiPolygon mpoly. The resulting point will not necessarily be on the\nMultiPolygon.\n\nST_Centroid() and Centroid() are synonyms.\n\nExamples\n--------\n\nSET @poly = ST_GeomFromText(\'POLYGON((0 0,20 0,20 20,0 20,0 0))\');\nSELECT ST_AsText(ST_Centroid(@poly)) AS center;\n+--------------+\n| center       |\n+--------------+\n| POINT(10 10) |\n+--------------+\n\nURL: https://mariadb.com/kb/en/st_centroid/','','https://mariadb.com/kb/en/st_centroid/'),(10,'ST_ExteriorRing',2,'Syntax\n------\n\nST_ExteriorRing(poly)\nExteriorRing(poly)\n\nDescription\n-----------\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nST_ExteriorRing() and ExteriorRing() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_exteriorring/','','https://mariadb.com/kb/en/st_exteriorring/'),(11,'ST_InteriorRingN',2,'Syntax\n------\n\nST_InteriorRingN(poly,N)\nInteriorRingN(poly,N)\n\nDescription\n-----------\n\nReturns the N-th interior ring for the Polygon value poly as a LineString.\nRings are numbered beginning with 1.\n\nST_InteriorRingN() and InteriorRingN() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_interiorringn/','','https://mariadb.com/kb/en/st_interiorringn/'),(12,'ST_NumInteriorRings',2,'Syntax\n------\n\nST_NumInteriorRings(poly)\nNumInteriorRings(poly)\n\nDescription\n-----------\n\nReturns an integer containing the number of interior rings in the Polygon\nvalue poly.\n\nNote that according the the OpenGIS standard, a POLYGON should have exactly\none ExteriorRing and all other rings should lie within that ExteriorRing and\nthus be the InteriorRings. Practically, however, some systems, including\nMariaDB\'s, permit polygons to have several \'ExteriorRings\'. In the case of\nthere being multiple, non-overlapping exterior rings ST_NumInteriorRings()\nwill return 1.\n\nST_NumInteriorRings() and NumInteriorRings() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\n\nNon-overlapping \'polygon\':\n\nSELECT ST_NumInteriorRings(ST_PolyFromText(\'POLYGON((0 0,10 0,10 10,0 10,0 0),\n (-1 -1,-5 -1,-5 -5,-1 -5,-1 -1))\')) AS NumInteriorRings;\n+------------------+\n| NumInteriorRings |\n+------------------+\n|                1 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/st_numinteriorrings/','','https://mariadb.com/kb/en/st_numinteriorrings/'),(14,'AsText',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-astext/','','https://mariadb.com/kb/en/wkt-astext/'),(15,'AsWKT',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-aswkt/','','https://mariadb.com/kb/en/wkt-aswkt/'),(16,'GeomCollFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomcollfromtext/','','https://mariadb.com/kb/en/wkt-geomcollfromtext/'),(17,'GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/geometrycollectionfromtext/','','https://mariadb.com/kb/en/geometrycollectionfromtext/'),(18,'GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/geometryfromtext/','','https://mariadb.com/kb/en/geometryfromtext/'),(19,'GeomFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomfromtext/','','https://mariadb.com/kb/en/wkt-geomfromtext/'),(20,'LineFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/wkt-linefromtext/','','https://mariadb.com/kb/en/wkt-linefromtext/'),(21,'LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/linestringfromtext/','','https://mariadb.com/kb/en/linestringfromtext/'),(22,'MLineFromText',3,'Syntax\n------\n\nMLineFromText(wkt[,srid])\nMultiLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTILINESTRING value using its WKT representation and SRID.\n\nMLineFromText() and MultiLineStringFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nSHOW FIELDS FROM gis_multi_line;\nINSERT INTO gis_multi_line VALUES\n  (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16\n23,16 48))\')),\n  (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n  (MLineFromWKB(AsWKB(MultiLineString(\n   LineString(Point(1, 2), Point(3, 5)),\n   LineString(Point(2, 5), Point(5, 8), Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/mlinefromtext/','','https://mariadb.com/kb/en/mlinefromtext/'),(23,'MPointFromText',3,'Syntax\n------\n\nMPointFromText(wkt[,srid])\nMultiPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n\nMPointFromText() and MultiPointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nSHOW FIELDS FROM gis_multi_point;\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/mpointfromtext/','','https://mariadb.com/kb/en/mpointfromtext/'),(13,'WKT Definition',3,'Description\n-----------\n\nThe Well-Known Text (WKT) representation of Geometry is designed to exchange\ngeometry data in ASCII form. Examples of the basic geometry types include:\n\n+-----------------------------------------------------------------------------+\n| Geometry Types                                                              |\n+-----------------------------------------------------------------------------+\n| POINT                                                                       |\n+-----------------------------------------------------------------------------+\n| LINESTRING                                                                  |\n+-----------------------------------------------------------------------------+\n| POLYGON                                                                     |\n+-----------------------------------------------------------------------------+\n| MULTIPOINT                                                                  |\n+-----------------------------------------------------------------------------+\n| MULTILINESTRING                                                             |\n+-----------------------------------------------------------------------------+\n| MULTIPOLYGON                                                                |\n+-----------------------------------------------------------------------------+\n| GEOMETRYCOLLECTION                                                          |\n+-----------------------------------------------------------------------------+\n| GEOMETRY                                                                    |\n+-----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/wkt-definition/','','https://mariadb.com/kb/en/wkt-definition/'),(24,'MPolyFromText',3,'Syntax\n------\n\nMPolyFromText(wkt[,srid])\nMultiPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n\nMPolyFromText() and MultiPolygonFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_polygon  (g MULTIPOLYGON);\nSHOW FIELDS FROM gis_multi_polygon;\nINSERT INTO gis_multi_polygon VALUES\n  (MultiPolygonFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromWKB(AsWKB(MultiPolygon(Polygon(\n   LineString(Point(0, 3), Point(3, 3), Point(3, 0), Point(0, 3)))))));\n\nURL: https://mariadb.com/kb/en/mpolyfromtext/','','https://mariadb.com/kb/en/mpolyfromtext/'),(25,'MultiLineStringFromText',3,'A synonym for MLineFromText.\n\nURL: https://mariadb.com/kb/en/multilinestringfromtext/','','https://mariadb.com/kb/en/multilinestringfromtext/'),(26,'MultiPointFromText',3,'A synonym for MPointFromText.\n\nURL: https://mariadb.com/kb/en/multipointfromtext/','','https://mariadb.com/kb/en/multipointfromtext/'),(27,'MultiPolygonFromText',3,'A synonym for MPolyFromText.\n\nURL: https://mariadb.com/kb/en/multipolygonfromtext/','','https://mariadb.com/kb/en/multipolygonfromtext/'),(28,'PointFromText',3,'A synonym for ST_PointFromText.\n\nURL: https://mariadb.com/kb/en/wkt-pointfromtext/','','https://mariadb.com/kb/en/wkt-pointfromtext/'),(29,'PolyFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/wkt-polyfromtext/','','https://mariadb.com/kb/en/wkt-polyfromtext/'),(30,'PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/polygonfromtext/','','https://mariadb.com/kb/en/polygonfromtext/'),(31,'ST_AsText',3,'Syntax\n------\n\nST_AsText(g)\nAsText(g)\nST_AsWKT(g)\nAsWKT(g)\n\nDescription\n-----------\n\nConverts a value in internal geometry format to its WKT representation and\nreturns the string result.\n\nST_AsText(), AsText(), ST_AsWKT() and AsWKT() are all synonyms.\n\nExamples\n--------\n\nSET @g = \'LineString(1 1,4 4,6 6)\';\n\nSELECT ST_AsText(ST_GeomFromText(@g));\n+--------------------------------+\n| ST_AsText(ST_GeomFromText(@g)) |\n+--------------------------------+\n| LINESTRING(1 1,4 4,6 6)        |\n+--------------------------------+\n\nURL: https://mariadb.com/kb/en/st_astext/','','https://mariadb.com/kb/en/st_astext/'),(32,'ST_ASWKT',3,'A synonym for ST_ASTEXT().\n\nURL: https://mariadb.com/kb/en/st_aswkt/','','https://mariadb.com/kb/en/st_aswkt/'),(33,'ST_GeomCollFromText',3,'Syntax\n------\n\nST_GeomCollFromText(wkt[,srid])\nST_GeometryCollectionFromText(wkt[,srid])\nGeomCollFromText(wkt[,srid])\nGeometryCollectionFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and SRID.\n\nST_GeomCollFromText(), ST_GeometryCollectionFromText(), GeomCollFromText() and\nGeometryCollectionFromText() are all synonyms.\n\nExample\n-------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/st_geomcollfromtext/','','https://mariadb.com/kb/en/st_geomcollfromtext/'),(34,'ST_GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/st_geometrycollectionfromtext/','','https://mariadb.com/kb/en/st_geometrycollectionfromtext/'),(35,'ST_GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/st_geometryfromtext/','','https://mariadb.com/kb/en/st_geometryfromtext/'),(36,'ST_GeomFromText',3,'Syntax\n------\n\nST_GeomFromText(wkt[,srid])\nST_GeometryFromText(wkt[,srid])\nGeomFromText(wkt[,srid])\nGeometryFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a geometry value of any type using its WKT representation and SRID.\n\nGeomFromText(), GeometryFromText(), ST_GeomFromText() and\nST_GeometryFromText() are all synonyms.\n\nExample\n-------\n\nSET @g = ST_GEOMFROMTEXT(\'POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1 1))\');\n\nURL: https://mariadb.com/kb/en/st_geomfromtext/','','https://mariadb.com/kb/en/st_geomfromtext/'),(37,'ST_LineFromText',3,'Syntax\n------\n\nST_LineFromText(wkt[,srid])\nST_LineStringFromText(wkt[,srid])\nLineFromText(wkt[,srid])\nLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a LINESTRING value using its WKT representation and SRID.\n\nST_LineFromText(), ST_LineStringFromText(), ST_LineFromText() and\nST_LineStringFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_line  (g LINESTRING);\nSHOW FIELDS FROM gis_line;\nINSERT INTO gis_line VALUES\n  (LineFromText(\'LINESTRING(0 0,0 10,10 0)\')),\n  (LineStringFromText(\'LINESTRING(10 10,20 10,20 20,10 20,10 10)\')),\n  (LineStringFromWKB(AsWKB(LineString(Point(10, 10), Point(40, 10)))));\n\nURL: https://mariadb.com/kb/en/st_linefromtext/','','https://mariadb.com/kb/en/st_linefromtext/'),(38,'ST_LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/st_linestringfromtext/','','https://mariadb.com/kb/en/st_linestringfromtext/'),(39,'ST_PointFromText',3,'Syntax\n------\n\nST_PointFromText(wkt[,srid])\nPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POINT value using its WKT representation and SRID.\n\nST_PointFromText() and PointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_point  (g POINT);\nSHOW FIELDS FROM gis_point;\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/st_pointfromtext/','','https://mariadb.com/kb/en/st_pointfromtext/'),(40,'ST_PolyFromText',3,'Syntax\n------\n\nST_PolyFromText(wkt[,srid])\nST_PolygonFromText(wkt[,srid])\nPolyFromText(wkt[,srid])\nPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POLYGON value using its WKT representation and SRID.\n\nST_PolyFromText(), ST_PolygonFromText(), PolyFromText() and\nST_PolygonFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_polygon   (g POLYGON);\nINSERT INTO gis_polygon VALUES\n  (PolygonFromText(\'POLYGON((10 10,20 10,20 20,10 20,10 10))\')),\n  (PolyFromText(\'POLYGON((0 0,50 0,50 50,0 50,0 0), (10 10,20 10,20 20,10\n20,10 10))\'));\n\nURL: https://mariadb.com/kb/en/st_polyfromtext/','','https://mariadb.com/kb/en/st_polyfromtext/'),(41,'ST_PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/st_polygonfromtext/','','https://mariadb.com/kb/en/st_polygonfromtext/'),(42,'DIV',4,'Syntax\n------\n\nDIV\n\nDescription\n-----------\n\nInteger division. Similar to FLOOR(), but is safe with BIGINT values.\nIncorrect results may occur for non-integer operands that exceed BIGINT range.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, a division by zero produces\nan error. Otherwise, it returns NULL.\n\nThe remainder of a division can be obtained using the MOD operator.\n\nExamples\n--------\n\nSELECT 300 DIV 7;\n+-----------+\n| 300 DIV 7 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT 300 DIV 0;\n+-----------+\n| 300 DIV 0 |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/div/','','https://mariadb.com/kb/en/div/'),(43,'ABS',4,'Syntax\n------\n\nABS(X)\n\nDescription\n-----------\n\nReturns the absolute (non-negative) value of X. If X is not a number, it is\nconverted to a numeric type.\n\nExamples\n--------\n\nSELECT ABS(42);\n+---------+\n| ABS(42) |\n+---------+\n|      42 |\n+---------+\n\nSELECT ABS(-42);\n+----------+\n| ABS(-42) |\n+----------+\n|       42 |\n+----------+\n\nSELECT ABS(DATE \'1994-01-01\');\n+------------------------+\n| ABS(DATE \'1994-01-01\') |\n+------------------------+\n|               19940101 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/abs/','','https://mariadb.com/kb/en/abs/'),(44,'ACOS',4,'Syntax\n------\n\nACOS(X)\n\nDescription\n-----------\n\nReturns the arc cosine of X, that is, the value whose cosine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ACOS(1);\n+---------+\n| ACOS(1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ACOS(1.0001);\n+--------------+\n| ACOS(1.0001) |\n+--------------+\n|         NULL |\n+--------------+\n\nSELECT ACOS(0);\n+-----------------+\n| ACOS(0)         |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT ACOS(0.234);\n+------------------+\n| ACOS(0.234)      |\n+------------------+\n| 1.33460644244679 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/acos/','','https://mariadb.com/kb/en/acos/'),(45,'ASIN',4,'Syntax\n------\n\nASIN(X)\n\nDescription\n-----------\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns NULL if\nX is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ASIN(0.2);\n+--------------------+\n| ASIN(0.2)          |\n+--------------------+\n| 0.2013579207903308 |\n+--------------------+\n\nSELECT ASIN(\'foo\');\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n\nSHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n\nURL: https://mariadb.com/kb/en/asin/','','https://mariadb.com/kb/en/asin/'),(46,'ATAN',4,'Syntax\n------\n\nATAN(X)\n\nDescription\n-----------\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nExamples\n--------\n\nSELECT ATAN(2);\n+--------------------+\n| ATAN(2)            |\n+--------------------+\n| 1.1071487177940904 |\n+--------------------+\n\nSELECT ATAN(-2);\n+---------------------+\n| ATAN(-2)            |\n+---------------------+\n| -1.1071487177940904 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/atan/','','https://mariadb.com/kb/en/atan/'),(47,'ATAN2',4,'Syntax\n------\n\nATAN(Y,X), ATAN2(Y,X)\n\nDescription\n-----------\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both arguments\nare used to determine the quadrant of the result.\n\nExamples\n--------\n\nSELECT ATAN(-2,2);\n+---------------------+\n| ATAN(-2,2)          |\n+---------------------+\n| -0.7853981633974483 |\n+---------------------+\n\nSELECT ATAN2(PI(),0);\n+--------------------+\n| ATAN2(PI(),0)      |\n+--------------------+\n| 1.5707963267948966 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/atan2/','','https://mariadb.com/kb/en/atan2/'),(48,'CEIL',4,'Syntax\n------\n\nCEIL(X)\n\nDescription\n-----------\n\nCEIL() is a synonym for CEILING().\n\nURL: https://mariadb.com/kb/en/ceil/','','https://mariadb.com/kb/en/ceil/'),(49,'CEILING',4,'Syntax\n------\n\nCEILING(X)\n\nDescription\n-----------\n\nReturns the smallest integer value not less than X.\n\nExamples\n--------\n\nSELECT CEILING(1.23);\n+---------------+\n| CEILING(1.23) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT CEILING(-1.23);\n+----------------+\n| CEILING(-1.23) |\n+----------------+\n|             -1 |\n+----------------+\n\nURL: https://mariadb.com/kb/en/ceiling/','','https://mariadb.com/kb/en/ceiling/'),(51,'COS',4,'Syntax\n------\n\nCOS(X)\n\nDescription\n-----------\n\nReturns the cosine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT COS(PI());\n+-----------+\n| COS(PI()) |\n+-----------+\n|        -1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/cos/','','https://mariadb.com/kb/en/cos/'),(52,'COT',4,'Syntax\n------\n\nCOT(X)\n\nDescription\n-----------\n\nReturns the cotangent of X.\n\nExamples\n--------\n\nSELECT COT(42);\n+--------------------+\n| COT(42)            |\n+--------------------+\n| 0.4364167060752729 |\n+--------------------+\n\nSELECT COT(12);\n+---------------------+\n| COT(12)             |\n+---------------------+\n| -1.5726734063976893 |\n+---------------------+\n\nSELECT COT(0);\nERROR 1690 (22003): DOUBLE value is out of range in \'cot(0)\'\n\nURL: https://mariadb.com/kb/en/cot/','','https://mariadb.com/kb/en/cot/'),(54,'DEGREES',4,'Syntax\n------\n\nDEGREES(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from radians to degrees.\n\nThis is the converse of the RADIANS() function.\n\nExamples\n--------\n\nSELECT DEGREES(PI());\n+---------------+\n| DEGREES(PI()) |\n+---------------+\n|           180 |\n+---------------+\n\nSELECT DEGREES(PI() / 2);\n+-------------------+\n| DEGREES(PI() / 2) |\n+-------------------+\n|                90 |\n+-------------------+\n\nSELECT DEGREES(45);\n+-----------------+\n| DEGREES(45)     |\n+-----------------+\n| 2578.3100780887 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/degrees/','','https://mariadb.com/kb/en/degrees/'),(55,'EXP',4,'Syntax\n------\n\nEXP(X)\n\nDescription\n-----------\n\nReturns the value of e (the base of natural logarithms) raised to the power of\nX. The inverse of this function is LOG() (using a single argument only) or\nLN().\n\nIf X is NULL, this function returns NULL.\n\nExamples\n--------\n\nSELECT EXP(2);\n+------------------+\n| EXP(2)           |\n+------------------+\n| 7.38905609893065 |\n+------------------+\n\nSELECT EXP(-2);\n+--------------------+\n| EXP(-2)            |\n+--------------------+\n| 0.1353352832366127 |\n+--------------------+\n\nSELECT EXP(0);\n+--------+\n| EXP(0) |\n+--------+\n|      1 |\n+--------+\n\nSELECT EXP(NULL);\n+-----------+\n| EXP(NULL) |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/exp/','','https://mariadb.com/kb/en/exp/'),(50,'CONV',4,'Syntax\n------\n\nCONV(N,from_base,to_base)\n\nDescription\n-----------\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base to_base.\n\nReturns NULL if any argument is NULL, or if the second or third argument are\nnot in the allowed range.\n\nThe argument N is interpreted as an integer, but may be specified as an\ninteger or a string. The minimum base is 2 and the maximum base is 36. If\nto_base is a negative number, N is regarded as a signed number. Otherwise, N\nis treated as unsigned. CONV() works with 64-bit precision.\n\nSome shortcuts for this function are also available: BIN(), OCT(), HEX(),\nUNHEX(). Also, MariaDB allows binary literal values and hexadecimal literal\nvalues.\n\nExamples\n--------\n\nSELECT CONV(\'a\',16,2);\n+----------------+\n| CONV(\'a\',16,2) |\n+----------------+\n| 1010           |\n+----------------+\n\nSELECT CONV(\'6E\',18,8);\n+-----------------+\n| CONV(\'6E\',18,8) |\n+-----------------+\n| 172             |\n+-----------------+\n\nSELECT CONV(-17,10,-18);\n+------------------+\n| CONV(-17,10,-18) |\n+------------------+\n| -H               |\n+------------------+\n\nSELECT CONV(12+\'10\'+\'10\'+0xa,10,10);\n+------------------------------+\n| CONV(12+\'10\'+\'10\'+0xa,10,10) |\n+------------------------------+\n| 42                           |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/conv/','','https://mariadb.com/kb/en/conv/'),(53,'CRC32',4,'Syntax\n------\n\n<= MariaDB 10.7\n\nCRC32(expr)\n\nFrom MariaDB 10.8\n\nCRC32([par,]expr)\n\nDescription\n-----------\n\nComputes a cyclic redundancy check (CRC) value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is expected to\nbe a string and (if possible) is treated as one if it is not.\n\nUses the ISO 3309 polynomial that used by zlib and many others. MariaDB 10.8\nintroduced the CRC32C() function, which uses the alternate Castagnoli\npolynomia.\n\nMariaDB starting with 10.8\n--------------------------\nOften, CRC is computed in pieces. To facilitate this, MariaDB 10.8.0\nintroduced an optional parameter: CRC32(\'MariaDB\')=CRC32(CRC32(\'Maria\'),\'DB\').\n\nExamples\n--------\n\nSELECT CRC32(\'MariaDB\');\n+------------------+\n| CRC32(\'MariaDB\') |\n+------------------+\n|       4227209140 |\n+------------------+\n\nSELECT CRC32(\'mariadb\');\n+------------------+\n| CRC32(\'mariadb\') |\n+------------------+\n|       2594253378 |\n+------------------+\n\nFrom MariaDB 10.8.0\n\nSELECT CRC32(CRC32(\'Maria\'),\'DB\');\n+----------------------------+\n| CRC32(CRC32(\'Maria\'),\'DB\') |\n+----------------------------+\n|                 4227209140 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/crc32/','','https://mariadb.com/kb/en/crc32/'),(56,'FLOOR',4,'Syntax\n------\n\nFLOOR(X)\n\nDescription\n-----------\n\nReturns the largest integer value not greater than X.\n\nExamples\n--------\n\nSELECT FLOOR(1.23);\n+-------------+\n| FLOOR(1.23) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT FLOOR(-1.23);\n+--------------+\n| FLOOR(-1.23) |\n+--------------+\n|           -2 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/floor/','','https://mariadb.com/kb/en/floor/'),(57,'LN',4,'Syntax\n------\n\nLN(X)\n\nDescription\n-----------\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X. If X\nis less than or equal to 0, or NULL, then NULL is returned.\n\nThe inverse of this function is EXP().\n\nExamples\n--------\n\nSELECT LN(2);\n+-------------------+\n| LN(2)             |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LN(-2);\n+--------+\n| LN(-2) |\n+--------+\n|   NULL |\n+--------+\n\nURL: https://mariadb.com/kb/en/ln/','','https://mariadb.com/kb/en/ln/'),(58,'LOG',4,'Syntax\n------\n\nLOG(X), LOG(B,X)\n\nDescription\n-----------\n\nIf called with one parameter, this function returns the natural logarithm of\nX. If X is less than or equal to 0, then NULL is returned.\n\nIf called with two parameters, it returns the logarithm of X to the base B. If\nB is <= 1 or X <= 0, the function returns NULL.\n\nIf any argument is NULL, the function returns NULL.\n\nThe inverse of this function (when called with a single argument) is the EXP()\nfunction.\n\nExamples\n--------\n\nLOG(X):\n\nSELECT LOG(2);\n+-------------------+\n| LOG(2)            |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LOG(-2);\n+---------+\n| LOG(-2) |\n+---------+\n|    NULL |\n+---------+\n\nLOG(B,X)\n\nSELECT LOG(2,16);\n+-----------+\n| LOG(2,16) |\n+-----------+\n|         4 |\n+-----------+\n\nSELECT LOG(3,27);\n+-----------+\n| LOG(3,27) |\n+-----------+\n|         3 |\n+-----------+\n\nSELECT LOG(3,1);\n+----------+\n| LOG(3,1) |\n+----------+\n|        0 |\n+----------+\n\nSELECT LOG(3,0);\n+----------+\n| LOG(3,0) |\n+----------+\n|     NULL |\n+----------+\n\nURL: https://mariadb.com/kb/en/log/','','https://mariadb.com/kb/en/log/'),(59,'LOG10',4,'Syntax\n------\n\nLOG10(X)\n\nDescription\n-----------\n\nReturns the base-10 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG10(2);\n+-------------------+\n| LOG10(2)          |\n+-------------------+\n| 0.301029995663981 |\n+-------------------+\n\nSELECT LOG10(100);\n+------------+\n| LOG10(100) |\n+------------+\n|          2 |\n+------------+\n\nSELECT LOG10(-100);\n+-------------+\n| LOG10(-100) |\n+-------------+\n|        NULL |\n+-------------+\n\nURL: https://mariadb.com/kb/en/log10/','','https://mariadb.com/kb/en/log10/'),(60,'LOG2',4,'Syntax\n------\n\nLOG2(X)\n\nDescription\n-----------\n\nReturns the base-2 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG2(4398046511104);\n+---------------------+\n| LOG2(4398046511104) |\n+---------------------+\n|                  42 |\n+---------------------+\n\nSELECT LOG2(65536);\n+-------------+\n| LOG2(65536) |\n+-------------+\n|          16 |\n+-------------+\n\nSELECT LOG2(-100);\n+------------+\n| LOG2(-100) |\n+------------+\n|       NULL |\n+------------+\n\nURL: https://mariadb.com/kb/en/log2/','','https://mariadb.com/kb/en/log2/'),(62,'OCT',4,'Syntax\n------\n\nOCT(N)\n\nDescription\n-----------\n\nReturns a string representation of the octal value of N, where N is a longlong\n(BIGINT) number. This is equivalent to CONV(N,10,8). Returns NULL if N is NULL.\n\nExamples\n--------\n\nSELECT OCT(34);\n+---------+\n| OCT(34) |\n+---------+\n| 42      |\n+---------+\n\nSELECT OCT(12);\n+---------+\n| OCT(12) |\n+---------+\n| 14      |\n+---------+\n\nURL: https://mariadb.com/kb/en/oct/','','https://mariadb.com/kb/en/oct/'),(63,'PI',4,'Syntax\n------\n\nPI()\n\nDescription\n-----------\n\nReturns the value of π (pi). The default number of decimal places displayed is\nsix, but MariaDB uses the full double-precision value internally.\n\nExamples\n--------\n\nSELECT PI();\n+----------+\n| PI()     |\n+----------+\n| 3.141593 |\n+----------+\n\nSELECT PI()+0.0000000000000000000000;\n+-------------------------------+\n| PI()+0.0000000000000000000000 |\n+-------------------------------+\n|      3.1415926535897931159980 |\n+-------------------------------+\n\nURL: https://mariadb.com/kb/en/pi/','','https://mariadb.com/kb/en/pi/'),(64,'POW',4,'Syntax\n------\n\nPOW(X,Y)\n\nDescription\n-----------\n\nReturns the value of X raised to the power of Y.\n\nPOWER() is a synonym.\n\nExamples\n--------\n\nSELECT POW(2,3);\n+----------+\n| POW(2,3) |\n+----------+\n|        8 |\n+----------+\n\nSELECT POW(2,-2);\n+-----------+\n| POW(2,-2) |\n+-----------+\n|      0.25 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/pow/','','https://mariadb.com/kb/en/pow/'),(65,'POWER',4,'Syntax\n------\n\nPOWER(X,Y)\n\nDescription\n-----------\n\nThis is a synonym for POW(), which returns the value of X raised to the power\nof Y.\n\nURL: https://mariadb.com/kb/en/power/','','https://mariadb.com/kb/en/power/'),(61,'MOD',4,'Syntax\n------\n\nMOD(N,M), N % M, N MOD M\n\nDescription\n-----------\n\nModulo operation. Returns the remainder of N divided by M. See also Modulo\nOperator.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, any number modulus zero\nproduces an error. Otherwise, it returns NULL.\n\nThe integer part of a division can be obtained using DIV.\n\nExamples\n--------\n\nSELECT 1042 % 50;\n+-----------+\n| 1042 % 50 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT MOD(234, 10);\n+--------------+\n| MOD(234, 10) |\n+--------------+\n|            4 |\n+--------------+\n\nSELECT 253 % 7;\n+---------+\n| 253 % 7 |\n+---------+\n|       1 |\n+---------+\n\nSELECT MOD(29,9);\n+-----------+\n| MOD(29,9) |\n+-----------+\n|         2 |\n+-----------+\n\nSELECT 29 MOD 9;\n+----------+\n| 29 MOD 9 |\n+----------+\n|        2 |\n+----------+\n\nURL: https://mariadb.com/kb/en/mod/','','https://mariadb.com/kb/en/mod/'),(66,'RADIANS',4,'Syntax\n------\n\nRADIANS(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from degrees to radians. Note that π radians\nequals 180 degrees.\n\nThis is the converse of the DEGREES() function.\n\nExamples\n--------\n\nSELECT RADIANS(45);\n+-------------------+\n| RADIANS(45)       |\n+-------------------+\n| 0.785398163397448 |\n+-------------------+\n\nSELECT RADIANS(90);\n+-----------------+\n| RADIANS(90)     |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT RADIANS(PI());\n+--------------------+\n| RADIANS(PI())      |\n+--------------------+\n| 0.0548311355616075 |\n+--------------------+\n\nSELECT RADIANS(180);\n+------------------+\n| RADIANS(180)     |\n+------------------+\n| 3.14159265358979 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/radians/','','https://mariadb.com/kb/en/radians/'),(67,'RAND',4,'Syntax\n------\n\nRAND(), RAND(N)\n\nDescription\n-----------\n\nReturns a random DOUBLE precision floating point value v in the range 0 <= v <\n1.0. If a constant integer argument N is specified, it is used as the seed\nvalue, which produces a repeatable sequence of column values. In the example\nbelow, note that the sequences of values produced by RAND(3) is the same both\nplaces where it occurs.\n\nIn a WHERE clause, RAND() is evaluated each time the WHERE is executed.\n\nStatements using the RAND() function are not safe for statement-based\nreplication.\n\nPractical uses\n--------------\n\nThe expression to get a random integer from a given range is the following:\n\nFLOOR(min_value + RAND() * (max_value - min_value +1))\n\nRAND() is often used to read random rows from a table, as follows:\n\nSELECT * FROM my_table ORDER BY RAND() LIMIT 10;\n\nNote, however, that this technique should never be used on a large table as it\nwill be extremely slow. MariaDB will read all rows in the table, generate a\nrandom value for each of them, order them, and finally will apply the LIMIT\nclause.\n\nExamples\n--------\n\nCREATE TABLE t (i INT);\n\nINSERT INTO t VALUES(1),(2),(3);\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.255651095188829 |\n|    2 | 0.833920199269355 |\n|    3 |  0.40264774151393 |\n+------+-------------------+\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.511478140495232 |\n|    2 | 0.349447508668012 |\n|    3 | 0.212803152588013 |\n+------+-------------------+\n\nUsing the same seed, the same sequence will be returned:\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nGenerating a random number from 5 to 15:\n\nSELECT FLOOR(5 + (RAND() * 11));\n\nURL: https://mariadb.com/kb/en/rand/','','https://mariadb.com/kb/en/rand/'),(68,'ROUND',4,'Syntax\n------\n\nROUND(X), ROUND(X,D)\n\nDescription\n-----------\n\nRounds the argument X to D decimal places. D defaults to 0 if not specified. D\ncan be negative to cause D digits left of the decimal point of the value X to\nbecome zero.\n\nThe rounding algorithm depends on the data type of X:\n\n* for floating point types (FLOAT, DOUBLE) the C libraries rounding function\nis used, so the behavior *may* differ between operating systems\n* for fixed point types (DECIMAL, DEC/NUMBER/FIXED) the \"round half up\" rule\nis used, meaning that e.g. a value ending in exactly .5 is always rounded up.\n\nExamples\n--------\n\nSELECT ROUND(-1.23);\n+--------------+\n| ROUND(-1.23) |\n+--------------+\n|           -1 |\n+--------------+\n\nSELECT ROUND(-1.58);\n+--------------+\n| ROUND(-1.58) |\n+--------------+\n|           -2 |\n+--------------+\n\nSELECT ROUND(1.58); \n+-------------+\n| ROUND(1.58) |\n+-------------+\n|           2 |\n+-------------+\n\nSELECT ROUND(1.298, 1);\n+-----------------+\n| ROUND(1.298, 1) |\n+-----------------+\n|             1.3 |\n+-----------------+\n\nSELECT ROUND(1.298, 0);\n+-----------------+\n| ROUND(1.298, 0) |\n+-----------------+\n|               1 |\n+-----------------+\n\nSELECT ROUND(23.298, -1);\n+-------------------+\n| ROUND(23.298, -1) |\n+-------------------+\n|                20 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/round/','','https://mariadb.com/kb/en/round/'),(69,'SIGN',4,'Syntax\n------\n\nSIGN(X)\n\nDescription\n-----------\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X is\nnegative, zero, or positive.\n\nExamples\n--------\n\nSELECT SIGN(-32);\n+-----------+\n| SIGN(-32) |\n+-----------+\n|        -1 |\n+-----------+\n\nSELECT SIGN(0);\n+---------+\n| SIGN(0) |\n+---------+\n|       0 |\n+---------+\n\nSELECT SIGN(234);\n+-----------+\n| SIGN(234) |\n+-----------+\n|         1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/sign/','','https://mariadb.com/kb/en/sign/'),(70,'SIN',4,'Syntax\n------\n\nSIN(X)\n\nDescription\n-----------\n\nReturns the sine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT SIN(1.5707963267948966);\n+-------------------------+\n| SIN(1.5707963267948966) |\n+-------------------------+\n|                       1 |\n+-------------------------+\n\nSELECT SIN(PI());\n+----------------------+\n| SIN(PI())            |\n+----------------------+\n| 1.22460635382238e-16 |\n+----------------------+\n\nSELECT ROUND(SIN(PI()));\n+------------------+\n| ROUND(SIN(PI())) |\n+------------------+\n|                0 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/sin/','','https://mariadb.com/kb/en/sin/'),(71,'SQRT',4,'Syntax\n------\n\nSQRT(X)\n\nDescription\n-----------\n\nReturns the square root of X. If X is negative, NULL is returned.\n\nExamples\n--------\n\nSELECT SQRT(4);\n+---------+\n| SQRT(4) |\n+---------+\n|       2 |\n+---------+\n\nSELECT SQRT(20);\n+------------------+\n| SQRT(20)         |\n+------------------+\n| 4.47213595499958 |\n+------------------+\n\nSELECT SQRT(-16);\n+-----------+\n| SQRT(-16) |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT SQRT(1764);\n+------------+\n| SQRT(1764) |\n+------------+\n|         42 |\n+------------+\n\nURL: https://mariadb.com/kb/en/sqrt/','','https://mariadb.com/kb/en/sqrt/'),(72,'TAN',4,'Syntax\n------\n\nTAN(X)\n\nDescription\n-----------\n\nReturns the tangent of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT TAN(0.7853981633974483);\n+-------------------------+\n| TAN(0.7853981633974483) |\n+-------------------------+\n|      0.9999999999999999 |\n+-------------------------+\n\nSELECT TAN(PI());\n+-----------------------+\n| TAN(PI())             |\n+-----------------------+\n| -1.22460635382238e-16 |\n+-----------------------+\n\nSELECT TAN(PI()+1);\n+-----------------+\n| TAN(PI()+1)     |\n+-----------------+\n| 1.5574077246549 |\n+-----------------+\n\nSELECT TAN(RADIANS(PI()));\n+--------------------+\n| TAN(RADIANS(PI())) |\n+--------------------+\n| 0.0548861508080033 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/tan/','','https://mariadb.com/kb/en/tan/'),(73,'TRUNCATE',4,'This page documents the TRUNCATE function. See TRUNCATE TABLE for the DDL\nstatement.\n\nSyntax\n------\n\nTRUNCATE(X,D)\n\nDescription\n-----------\n\nReturns the number X, truncated to D decimal places. If D is 0, the result has\nno decimal point or fractional part. D can be negative to cause D digits left\nof the decimal point of the value X to become zero.\n\nExamples\n--------\n\nSELECT TRUNCATE(1.223,1);\n+-------------------+\n| TRUNCATE(1.223,1) |\n+-------------------+\n|               1.2 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,1);\n+-------------------+\n| TRUNCATE(1.999,1) |\n+-------------------+\n|               1.9 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,0); \n+-------------------+\n| TRUNCATE(1.999,0) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSELECT TRUNCATE(-1.999,1);\n+--------------------+\n| TRUNCATE(-1.999,1) |\n+--------------------+\n|               -1.9 |\n+--------------------+\n\nSELECT TRUNCATE(122,-2);\n+------------------+\n| TRUNCATE(122,-2) |\n+------------------+\n|              100 |\n+------------------+\n\nSELECT TRUNCATE(10.28*100,0);\n+-----------------------+\n| TRUNCATE(10.28*100,0) |\n+-----------------------+\n|                  1028 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/truncate/','','https://mariadb.com/kb/en/truncate/'),(74,'INSTALL PLUGIN',5,'Syntax\n------\n\nINSTALL PLUGIN [IF NOT EXISTS] plugin_name SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement installs an individual plugin from the specified library. To\ninstall the whole library (which could be required), use INSTALL SONAME. See\nalso Installing a Plugin.\n\nplugin_name is the name of the plugin as defined in the plugin declaration\nstructure contained in the library file. Plugin names are not case sensitive.\nFor maximal compatibility, plugin names should be limited to ASCII letters,\ndigits, and underscore, because they are used in C source files, shell command\nlines, M4 and Bourne shell scripts, and SQL environments.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension can be omitted (which makes the statement look\nthe same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL PLUGIN adds a line to the mysql.plugin table that describes the\nplugin. This table contains the plugin name and library file name.\n\nINSTALL PLUGIN causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL PLUGIN also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL PLUGIN, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nPLUGIN only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a note instead of\nan error if the specified plugin already exists. See SHOW WARNINGS.\n\nExamples\n--------\n\nINSTALL PLUGIN sphinx SONAME \'ha_sphinx.so\';\n\nThe extension can also be omitted:\n\nINSTALL PLUGIN innodb SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected (0.104 sec)\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+------------------------------------+\n| Level | Code | Message                            |\n+-------+------+------------------------------------+\n| Note  | 1968 | Plugin \'example\' already installed |\n+-------+------+------------------------------------+\n\nURL: https://mariadb.com/kb/en/install-plugin/','','https://mariadb.com/kb/en/install-plugin/'),(78,'Plugin Overview',5,'Plugins are server components that enhance MariaDB in some way. These can be\nanything from new storage engines, plugins for enhancing full-text parsing, or\neven small enhancements, such as a plugin to get a timestamp as an integer.\n\nQuerying Plugin Information\n---------------------------\n\nThere are a number of ways to see which plugins are currently active.\n\nA server almost always has a large number of active plugins, because the\nserver contains a large number of built-in plugins, which are active by\ndefault and cannot be uninstalled.\n\nQuerying Plugin Information with SHOW PLUGINS\n---------------------------------------------\n\nThe SHOW PLUGINS statement can be used to query information about all active\nplugins.\n\nFor example:\n\nSHOW PLUGINS\\G;\n********************** 1. row **********************\n Name: binlog\n Status: ACTIVE\n Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n********************** 2. row **********************\n Name: mysql_native_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n********************** 3. row **********************\n Name: mysql_old_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n...\n\nIf a plugin\'s Library column has a NULL value, then the plugin is built-in,\nand it cannot be uninstalled.\n\nQuerying Plugin Information with information_schema.PLUGINS\n-----------------------------------------------------------\n\nThe information_schema.PLUGINS table can be queried to get more detailed\ninformation about plugins.\n\nFor example:\n\nSELECT * FROM information_schema.PLUGINS\\G\n...\n*************************** 6. row ***************************\n     PLUGIN_NAME: CSV\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: Brian Aker, MySQL AB\n  PLUGIN_DESCRIPTION: CSV storage engine\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n*************************** 7. row ***************************\n     PLUGIN_NAME: MEMORY\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: MySQL AB\n  PLUGIN_DESCRIPTION: Hash based, stored in memory, useful for temporary\ntables\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n...\n\nIf a plugin\'s PLUGIN_LIBRARY column has the NULL value, then the plugin is\nbuilt-in, and it cannot be uninstalled.\n\nQuerying Plugin Information with mysql.plugin\n---------------------------------------------\n\nThe mysql.plugin table can be queried to get information about installed\nplugins.\n\nThis table only contains information about plugins that have been installed\nvia the following methods:\n\n* The INSTALL SONAME statement.\n* The INSTALL PLUGIN statement.\n* The mysql_plugin utility.\n\nThis table does not contain information about:\n\n* Built-in plugins.\n* Plugins loaded with the --plugin-load-add option.\n* Plugins loaded with the --plugin-load option.\n\nThis table only contains enough information to reload the plugin when the\nserver is restarted, which means it only contains the plugin name and the\nplugin library.\n\nFor example:\n\nSELECT * FROM mysql.plugin;\n\n+------+------------+\n| name | dl         |\n+------+------------+\n| PBXT | libpbxt.so |\n+------+------------+\n\nInstalling a Plugin\n-------------------\n\nThere are three primary ways to install a plugin:\n\n* A plugin can be installed dynamically with an SQL statement.\n* A plugin can be installed with a mysqld option, but it requires a server\nrestart.\n* A plugin can be installed with the mysql_plugin utility, while the server is\ncompletely offline.\n\nWhen you are installing a plugin, you also have to ensure that:\n\n* The server\'s plugin directory is properly configured, and the plugin\'s\nlibrary is in the plugin directory.\n* The server\'s minimum plugin maturity is properly configured, and the plugin\nis mature enough to be installed.\n\nInstalling a Plugin Dynamically\n-------------------------------\n\nA plugin can be installed dynamically by executing either the INSTALL SONAME\nor the INSTALL PLUGIN statement.\n\nIf a plugin is installed with one of these statements, then a record will be\nadded to the mysql.plugins table for the plugin. This means that the plugin\nwill automatically be loaded every time the server restarts, unless\nspecifically uninstalled or deactivated.\n\nInstalling a Plugin with INSTALL SONAME\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL SONAME\nstatement. INSTALL SONAME installs all plugins from the given plugin library.\nThis could be required for some plugin libraries.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin), you could execute the\nfollowing:\n\nINSTALL SONAME \'server_audit\';\n\nInstalling a Plugin with INSTALL PLUGIN\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL PLUGIN\nstatement. INSTALL PLUGIN installs a single plugin from the given plugin\nlibrary.\n\nFor example, to install the server_audit audit plugin from the server_audit\nplugin library, you could execute the following:\n\nINSTALL PLUGIN server_audit SONAME \'server_audit\';\n\nInstalling a Plugin with Plugin Load Options\n--------------------------------------------\n\nA plugin can be installed with a mysqld option by providing either the\n--plugin-load-add or the --plugin-load option.\n\nIf a plugin is installed with one of these options, then a record will not be\nadded to the mysql.plugins table for the plugin. This means that if the server\nis restarted without the same option set, then the plugin will not\nautomatically be loaded.\n\nInstalling a Plugin with --plugin-load-add\n------------------------------------------\n\nYou can install a plugin with the --plugin-load-add option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load-add option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load-add=\'server_audit\'\n--plugin-load-add=\'ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nSpecial care must be taken when specifying both the --plugin-load option and\nthe --plugin-load-add option together. The --plugin-load option resets the\nplugin load list, and this can cause unexpected problems if you are not aware.\nThe --plugin-load-add option does not reset the plugin load list, so it is\nmuch safer to use. See Specifying Multiple Plugin Load Options for more\ninformation.\n\nInstalling a Plugin with --plugin-load\n--------------------------------------\n\nYou can install a plugin with the --plugin-load option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load=\'server_audit;ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load = server_audit;ed25519=auth_ed25519\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option together. The --plugin-load option resets the plugin\nload list, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use. See Specifying Multiple Plugin Load Options for more information.\n\nSpecifying Multiple Plugin Load Options\n---------------------------------------\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option. The --plugin-load option resets the plugin load\nlist, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use.\n\nThis can have the following consequences:\n\n* If the --plugin-load option is specified multiple times, then only the last\ninstance will have any effect. For example, in the following case, the first\ninstance of the option is reset:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* If the --plugin-load option is specified after the --plugin-load-add option,\nthen it will also reset the changes made by that option. For example, in the\nfollowing case, the --plugin-load-add option does not do anything, because the\nsubsequent --plugin-load option resets the plugin load list:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* In contrast, if the --plugin-load option is specified before the\n--plugin-load-add option, then it will work fine, because the\n--plugin-load-add option does not reset the plugin load list. For example, in\nthe following case, both plugins are properly loaded:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nInstalling a Plugin with mysql_plugin\n-------------------------------------\n\nA plugin can be installed with the mysql_plugin utility if the server is\ncompletely offline.\n\nThe syntax is:\n\nmysql_plugin [options] <plugin> ENABLE|DISABLE\n\nFor example, to install the server_audit audit plugin, you could execute the\nfollowing:\n\nmysql_plugin server_audit ENABLE\n\nIf a plugin is installed with this utility, then a record will be added to the\nmysql.plugins table for the plugin. This means that the plugin will\nautomatically be loaded every time the server restarts, unless specifically\nuninstalled or deactivated.\n\nConfiguring the Plugin Directory\n--------------------------------\n\nWhen a plugin is being installed, the server looks for the plugin\'s library in\nthe server\'s plugin directory. This directory is configured by the plugin_dir\nsystem variable. This can be specified as a command-line argument to mysqld or\nit can be specified in a relevant server option group in an option file. For\nexample:\n\n[mariadb]\n...\nplugin_dir = /usr/lib64/mysql/plugin\n\nConfiguring the Minimum Plugin Maturity\n---------------------------------------\n\nWhen a plugin is being installed, the server compares the plugin\'s maturity\nlevel against the server\'s minimum allowed plugin maturity. This can help\nprevent users from using unstable plugins on production servers. This minimum\nplugin maturity is configured by the plugin_maturity system variable. This can\nbe specified as a command-line argument to mysqld or it can be specified in a\nrelevant server option group in an option file. For example:\n\n[mariadb]\n...\nplugin_maturity = stable\n\nConfiguring Plugin Activation at Server Startup\n-----------------------------------------------\n\nA plugin will be loaded by default when the server starts if:\n\n* The plugin was installed with the INSTALL SONAME statement.\n* The plugin was installed with the INSTALL PLUGIN statement.\n* The plugin was installed with the mysql_plugin utility.\n* The server is configured to load the plugin with the --plugin-load-add\noption.\n* The server is configured to load the plugin with the --plugin-load option.\n\nThis behavior can be changed with special options that take the form\n--plugin-name. For example, for the server_audit audit plugin, the special\noption is called --server-audit.\n\nThe possible values for these special options are:\n\n+---------------------------------------+------------------------------------+\n| Option Value                          | Description                        |\n+---------------------------------------+------------------------------------+\n| OFF                                   | Disables the plugin without        |\n|                                       | removing it from the               |\n|                                       | mysql.plugins table.               |\n+---------------------------------------+------------------------------------+\n| ON                                    | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will still continue         |\n|                                       | starting up, but the plugin will   |\n|                                       | be disabled.                       |\n+---------------------------------------+------------------------------------+\n| FORCE                                 | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error.                             |\n+---------------------------------------+------------------------------------+\n| FORCE_PLUS_PERMANENT                  | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error. In addition, the plugin     |\n|                                       | cannot be uninstalled with         |\n|                                       | UNINSTALL SONAME or UNINSTALL      |\n|                                       | PLUGIN while the server is         |\n|                                       | running.                           |\n+---------------------------------------+------------------------------------+\n\nA plugin\'s status can be found by looking at the PLUGIN_STATUS column of the\ninformation_schema.PLUGINS table.\n\nUninstalling Plugins\n--------------------\n\nPlugins that are found in the mysql.plugin table, that is those that were\ninstalled with INSTALL SONAME, INSTALL PLUGIN or mysql_plugin can be\nuninstalled in one of two ways:\n\n* The UNINSTALL SONAME or the UNINSTALL PLUGIN statement while the server is\nrunning\n* With mysql_plugin while the server is offline.\n\nPlugins that were enabled as a --plugin-load option do not need to be\nuninstalled. If --plugin-load is omitted the next time the server starts, or\nthe plugin is not listed as one of the --plugin-load entries, the plugin will\nnot be loaded.\n\nUNINSTALL PLUGIN uninstalls a single installed plugin, while UNINSTALL SONAME\nuninstalls all plugins belonging to a given library.\n\nURL: https://mariadb.com/kb/en/plugin-overview/','','https://mariadb.com/kb/en/plugin-overview/'),(79,'MBR Definition',6,'Description\n-----------\n\nThe MBR (Minimum Bounding Rectangle), or Envelope is the bounding geometry,\nformed by the minimum and maximum (X,Y) coordinates:\n\nExamples\n--------\n\n((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n\nURL: https://mariadb.com/kb/en/mbr-definition/','','https://mariadb.com/kb/en/mbr-definition/'),(80,'MBRContains',6,'Syntax\n------\n\nMBRContains(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1\ncontains the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRWithin().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\n\nSET @g2 = GeomFromText(\'Point(1 1)\');\n\nSELECT MBRContains(@g1,@g2), MBRContains(@g2,@g1);\n+----------------------+----------------------+\n| MBRContains(@g1,@g2) | MBRContains(@g2,@g1) |\n+----------------------+----------------------+\n|                    1 |                    0 |\n+----------------------+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrcontains/','','https://mariadb.com/kb/en/mbrcontains/'),(82,'MBREqual',6,'Syntax\n------\n\nMBREqual(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are the same.\n\nExamples\n--------\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 2)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 2, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 3)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 4, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 0 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/mbrequal/','','https://mariadb.com/kb/en/mbrequal/'),(86,'MBRWithin',6,'Syntax\n------\n\nMBRWithin(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1 is\nwithin the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRContains().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((0 0,0 5,5 5,5 0,0 0))\');\nSELECT MBRWithin(@g1,@g2), MBRWithin(@g2,@g1);\n+--------------------+--------------------+\n| MBRWithin(@g1,@g2) | MBRWithin(@g2,@g1) |\n+--------------------+--------------------+\n|                  1 |                  0 |\n+--------------------+--------------------+\n\nURL: https://mariadb.com/kb/en/mbrwithin/','','https://mariadb.com/kb/en/mbrwithin/'),(75,'UNINSTALL PLUGIN',5,'Syntax\n------\n\nUNINSTALL PLUGIN [IF EXISTS] plugin_name\n\nDescription\n-----------\n\nThis statement removes a single installed plugin. To uninstall the whole\nlibrary which contains the plugin, use UNINSTALL SONAME. You cannot uninstall\na plugin if any table that uses it is open.\n\nplugin_name must be the name of some plugin that is listed in the mysql.plugin\ntable. The server executes the plugin\'s deinitialization function and removes\nthe row for the plugin from the mysql.plugin table, so that subsequent server\nrestarts will not load and initialize the plugin. UNINSTALL PLUGIN does not\nremove the plugin\'s shared library file.\n\nTo use UNINSTALL PLUGIN, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nUNINSTALL PLUGIN example;\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------+\n| Level | Code | Message                       |\n+-------+------+-------------------------------+\n| Note  | 1305 | PLUGIN example does not exist |\n+-------+------+-------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-plugin/','','https://mariadb.com/kb/en/uninstall-plugin/'),(76,'INSTALL SONAME',5,'Syntax\n------\n\nINSTALL SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of INSTALL PLUGIN. It installs all plugins from a\ngiven plugin_library. See INSTALL PLUGIN for details.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL SONAME adds one or more lines to the mysql.plugin table that describes\nthe plugin. This table contains the plugin name and library file name.\n\nINSTALL SONAME causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL SONAME also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL SONAME, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nSONAME only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nIf you need to install only one plugin from a library, use the INSTALL PLUGIN\nstatement.\n\nExamples\n--------\n\nTo load the XtraDB storage engine and all of its information_schema tables\nwith one statement, use\n\nINSTALL SONAME \'ha_xtradb\';\n\nThis statement can be used instead of INSTALL PLUGIN even when the library\ncontains only one plugin:\n\nINSTALL SONAME \'ha_sequence\';\n\nURL: https://mariadb.com/kb/en/install-soname/','','https://mariadb.com/kb/en/install-soname/'),(77,'UNINSTALL SONAME',5,'Syntax\n------\n\nUNINSTALL SONAME  [IF EXISTS] \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of UNINSTALL PLUGIN statement, that removes all\nplugins belonging to a specified plugin_library. See UNINSTALL PLUGIN for\ndetails.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nTo use UNINSTALL SONAME, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin library does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nTo uninstall the XtraDB plugin and all of its information_schema tables with\none statement, use\n\nUNINSTALL SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------------+\n| Level | Code | Message                             |\n+-------+------+-------------------------------------+\n| Note  | 1305 | SONAME ha_example.so does not exist |\n+-------+------+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-soname/','','https://mariadb.com/kb/en/uninstall-soname/'),(90,'NULLIF',7,'Syntax\n------\n\nNULLIF(expr1,expr2)\n\nDescription\n-----------\n\nReturns NULL if expr1 = expr2 is true, otherwise returns expr1. This is the\nsame as CASE WHEN expr1 = expr2 THEN NULL ELSE expr1 END.\n\nExamples\n--------\n\nSELECT NULLIF(1,1);\n+-------------+\n| NULLIF(1,1) |\n+-------------+\n|        NULL |\n+-------------+\n\nSELECT NULLIF(1,2);\n+-------------+\n| NULLIF(1,2) |\n+-------------+\n|           1 |\n+-------------+\n\nURL: https://mariadb.com/kb/en/nullif/','','https://mariadb.com/kb/en/nullif/'),(91,'NVL',7,'MariaDB starting with 10.3\n--------------------------\nFrom MariaDB 10.3, NVL is a synonym for IFNULL.\n\nURL: https://mariadb.com/kb/en/nvl/','','https://mariadb.com/kb/en/nvl/'),(92,'NVL2',7,'MariaDB starting with 10.3\n--------------------------\nThe NLV2 function was introduced in MariaDB 10.3.0.\n\nSyntax\n------\n\nNVL2(expr1,expr2,expr3)\n\nDescription\n-----------\n\nThe NVL2 function returns a value based on whether a specified expression is\nNULL or not. If expr1 is not NULL, then NVL2 returns expr2. If expr1 is NULL,\nthen NVL2 returns expr3.\n\nExamples\n--------\n\nSELECT NVL2(NULL,1,2);\n+----------------+\n| NVL2(NULL,1,2) |\n+----------------+\n|              2 |\n+----------------+\n\nSELECT NVL2(\'x\',1,2);\n+---------------+\n| NVL2(\'x\',1,2) |\n+---------------+\n|             1 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/nvl2/','','https://mariadb.com/kb/en/nvl2/'),(81,'MBRDisjoint',6,'Syntax\n------\n\nMBRDisjoint(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are disjoint. Two geometries are disjoint if they do not\nintersect, that is touch or overlap.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECTmbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrdisjoint/','','https://mariadb.com/kb/en/mbrdisjoint/'),(83,'MBRIntersects',6,'Syntax\n------\n\nMBRIntersects(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 intersect.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      1 |\n+------------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      0 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/mbrintersects/','','https://mariadb.com/kb/en/mbrintersects/'),(84,'MBROverlaps',6,'Syntax\n------\n\nMBROverlaps(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 overlap. The term spatially overlaps is used if two\ngeometries intersect and their intersection results in a geometry of the same\ndimension but not equal to either of the given geometries.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbroverlaps/','','https://mariadb.com/kb/en/mbroverlaps/'),(85,'MBRTouches',6,'Syntax\n------\n\nMBRTouches(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 touch. Two geometries spatially touch if the interiors of\nthe geometries do not intersect, but the boundary of one of the geometries\nintersects either the boundary or the interior of the other.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   1 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/mbrtouches/','','https://mariadb.com/kb/en/mbrtouches/'),(87,'CASE OPERATOR',7,'Syntax\n------\n\nCASE value WHEN [compare_value] THEN result [WHEN [compare_value] THEN\nresult ...] [ELSE result] END\n\nCASE WHEN [condition] THEN result [WHEN [condition] THEN result ...]\n[ELSE result] END\n\nDescription\n-----------\n\nThe first version returns the result where value=compare_value. The second\nversion returns the result for the first condition that is true. If there was\nno matching result value, the result after ELSE is returned, or NULL if there\nis no ELSE part.\n\nThere is also a CASE statement, which differs from the CASE operator described\nhere.\n\nExamples\n--------\n\nSELECT CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END;\n+------------------------------------------------------------+\n| CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END |\n+------------------------------------------------------------+\n| one                                                        |\n+------------------------------------------------------------+\n\nSELECT CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END;\n+--------------------------------------------+\n| CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END |\n+--------------------------------------------+\n| true                                       |\n+--------------------------------------------+\n\nSELECT CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END;\n+-----------------------------------------------------+\n| CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END |\n+-----------------------------------------------------+\n|                                                NULL |\n+-----------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/case-operator/','','https://mariadb.com/kb/en/case-operator/'),(101,'UNLOCK TABLES',8,'Syntax\n------\n\nUNLOCK TABLES\n\nDescription\n-----------\n\nUNLOCK TABLES explicitly releases any table locks held by the current session.\nSee LOCK TABLES for more information.\n\nIn addition to releasing table locks acquired by the LOCK TABLES statement,\nthe UNLOCK TABLES statement also releases the global read lock acquired by the\nFLUSH TABLES WITH READ LOCK statement. The FLUSH TABLES WITH READ LOCK\nstatement is very useful for performing backups. See FLUSH for more\ninformation about FLUSH TABLES WITH READ LOCK.\n\nURL: https://mariadb.com/kb/en/transactions-unlock-tables/','','https://mariadb.com/kb/en/transactions-unlock-tables/'),(103,'XA Transactions',8,'Overview\n--------\n\nThe MariaDB XA implementation is based on the X/Open CAE document Distributed\nTransaction Processing: The XA Specification. This document is published by\nThe Open Group and available at\nhttp://www.opengroup.org/public/pubs/catalog/c193.htm.\n\nXA transactions are designed to allow distributed transactions, where a\ntransaction manager (the application) controls a transaction which involves\nmultiple resources. Such resources are usually DBMSs, but could be resources\nof any type. The whole set of required transactional operations is called a\nglobal transaction. Each subset of operations which involve a single resource\nis called a local transaction. XA used a 2-phases commit (2PC). With the first\ncommit, the transaction manager tells each resource to prepare an effective\ncommit, and waits for a confirm message. The changes are not still made\neffective at this point. If any of the resources encountered an error, the\ntransaction manager will rollback the global transaction. If all resources\ncommunicate that the first commit is successful, the transaction manager can\nrequire a second commit, which makes the changes effective.\n\nIn MariaDB, XA transactions can only be used with storage engines that support\nthem. At least InnoDB, TokuDB, SPIDER and MyRocks support them. For InnoDB,\nuntil MariaDB 10.2, XA transactions can be disabled by setting the\ninnodb_support_xa server system variable to 0. From MariaDB 10.3, XA\ntransactions are always supported.\n\nLike regular transactions, XA transactions create metadata locks on accessed\ntables.\n\nXA transactions require REPEATABLE READ as a minimum isolation level. However,\ndistributed transactions should always use SERIALIZABLE.\n\nTrying to start more than one XA transaction at the same time produces a 1400\nerror (SQLSTATE \'XAE09\'). The same error is produced when attempting to start\nan XA transaction while a regular transaction is in effect. Trying to start a\nregular transaction while an XA transaction is in effect produces a 1399 error\n(SQLSTATE \'XAE07\').\n\nThe statements that cause an implicit COMMIT for regular transactions produce\na 1400 error (SQLSTATE \'XAE09\') if a XA transaction is in effect.\n\nInternal XA vs External XA\n--------------------------\n\nXA transactions are an overloaded term in MariaDB. If a storage engine is\nXA-capable, it can mean one or both of these:\n\n* It supports MariaDB\'s internal two-phase commit API. This is transparent to\nthe user. Sometimes this is called \"internal XA\", since MariaDB\'s internal\ntransaction coordinator log can handle coordinating these transactions.\n\n* It supports XA transactions, with the XA START, XA PREPARE, XA COMMIT, etc.\nstatements. Sometimes this is called \"external XA\", since it requires the use\nof an external transaction coordinator to use this feature properly.\n\nTransaction Coordinator Log\n---------------------------\n\nIf you have two or more XA-capable storage engines enabled, then a transaction\ncoordinator log must be available.\n\nThere are currently two implementations of the transaction coordinator log:\n\n* Binary log-based transaction coordinator log\n* Memory-mapped file-based transaction coordinator log\n\nIf the binary log is enabled on a server, then the server will use the binary\nlog-based transaction coordinator log. Otherwise, it will use the\nmemory-mapped file-based transaction coordinator log.\n\nSee Transaction Coordinator Log for more information.\n\nSyntax\n------\n\nXA {START|BEGIN} xid [JOIN|RESUME]\n\nXA END xid [SUSPEND [FOR MIGRATE]]\n\nXA PREPARE xid\n\nXA COMMIT xid [ONE PHASE]\n\nXA ROLLBACK xid\n\nXA RECOVER [FORMAT=[\'RAW\'|\'SQL\']]\n\nxid: gtrid [, bqual [, formatID ]]\n\nThe interface to XA transactions is a set of SQL statements starting with XA.\nEach statement changes a transaction\'s state, determining which actions it can\nperform. A transaction which does not exist is in the NON-EXISTING state.\n\nXA START (or BEGIN) starts a transaction and defines its xid (a transaction\nidentifier). The JOIN or RESUME keywords have no effect. The new transaction\nwill be in ACTIVE state.\n\nThe xid can have 3 components, though only the first one is mandatory. gtrid\nis a quoted string representing a global transaction identifier. bqual is a\nquoted string representing a local transaction identifier. formatID is an\nunsigned integer indicating the format used for the first two components; if\nnot specified, defaults to 1. MariaDB does not interpret in any way these\ncomponents, and only uses them to identify a transaction. xids of transactions\nin effect must be unique.\n\nXA END declares that the specified ACTIVE transaction is finished and it\nchanges its state to IDLE. SUSPEND [FOR MIGRATE] has no effect.\n\nXA PREPARE prepares an IDLE transaction for commit, changing its state to\nPREPARED. This is the first commit.\n\nXA COMMIT definitely commits and terminates a transaction which has already\nbeen PREPARED. If the ONE PHASE clause is specified, this statements performs\na 1-phase commit on an IDLE transaction.\n\nXA ROLLBACK rolls back and terminates an IDLE or PREPARED transaction.\n\nXA RECOVER shows information about all PREPARED transactions.\n\nWhen trying to execute an operation which is not allowed for the transaction\'s\ncurrent state, an error is produced:\n\nXA COMMIT \'test\' ONE PHASE;\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  ACTIVE state\n\nXA COMMIT \'test2\';\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  NON-EXISTING state\n\nXA RECOVER\n----------\n\nThe XA RECOVER statement shows information about all transactions which are in\nthe PREPARED state. It does not matter which connection created the\ntransaction: if it has been PREPARED, it appears. But this does not mean that\na connection can commit or rollback a transaction which was started by another\nconnection. Note that transactions using a 1-phase commit are never in the\nPREPARED state, so they cannot be shown by XA RECOVER.\n\nXA RECOVER produces four columns:\n\nXA RECOVER;\n+----------+--------------+--------------+------+\n| formatID | gtrid_length | bqual_length | data |\n+----------+--------------+--------------+------+\n|        1 |            4 |            0 | test |\n+----------+--------------+--------------+------+\n\nMariaDB starting with 10.3.3\n----------------------------\nYou can use XA RECOVER FORMAT=\'SQL\' to get the data in a human readable form\nthat can be directly copy-pasted into XA COMMIT or XA ROLLBACK. This is\nparticularly useful for binary xid generated by some transaction coordinators.\n\nformatID is the formatID part of xid.\n\ndata are the gtrid and bqual parts of xid, concatenated.\n\ngtrid_length and bqual_length are the lengths of gtrid and bqual, respectevely.\n\nExamples\n--------\n\n2-phases commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA PREPARE \'test\';\n\nXA COMMIT \'test\';\n\n1-phase commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA COMMIT \'test\' ONE PHASE;\n\nHuman-readable:\n\nxa start \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\ninsert t1 values (40);\n\nxa end \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa prepare \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa recover format=\'RAW\';\n+----------+--------------+--------------+--------------------+\n| formatID | gtrid_length | bqual_length | data               |\n+----------+--------------+--------------+--------------------+\n34      67v78abc       11 |            7 | 12\ndef |\n+----------+--------------+--------------+--------------------+\n\nxa recover format=\'SQL\';\n+----------+--------------+--------------+-------------------------------------\n---------+\n| formatID | gtrid_length | bqual_length | data                               \n     |\n+----------+--------------+--------------+-------------------------------------\n---------+\n|        3 |           11 |            7 |\nX\'31320d3334093637763738\',X\'6162630a646566\',3 |\n+----------+--------------+--------------+-------------------------------------\n---------+\n\nxa rollback X\'31320d3334093637763738\',X\'6162630a646566\',3;\n\nKnown Issues\n------------\n\nMariaDB Galera Cluster\n----------------------\n\nMariaDB Galera Cluster does not support XA transactions.\n\nHowever, MariaDB Galera Cluster builds include a built-in plugin called wsrep.\nPrior to MariaDB 10.4.3, this plugin was internally considered an XA-capable\nstorage engine. Consequently, these MariaDB Galera Cluster builds have\nmultiple XA-capable storage engines by default, even if the only \"real\"\nstorage engine that supports external XA transactions enabled on these builds\nby default is InnoDB. Therefore, when using one these builds MariaDB would be\nforced to use a transaction coordinator log by default, which could have\nperformance implications.\n\nSee Transaction Coordinator Log Overview: MariaDB Galera Cluster for more\ninformation.\n\nURL: https://mariadb.com/kb/en/xa-transactions/','','https://mariadb.com/kb/en/xa-transactions/'),(104,'CREATE USER',10,'Syntax\n------\n\nCREATE [OR REPLACE] USER [IF NOT EXISTS] \n user_specification [,user_specification ...] \n [REQUIRE {NONE | tls_option [[AND] tls_option ...] }]\n [WITH resource_option [resource_option ...] ]\n [lock_option] [password_option]\n\nuser_specification:\n username [authentication_option]\n\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule  ...]\n\nauthentication_rule:\n  authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\ntls_option:\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n\nlock_option:\n  ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n\nDescription\n-----------\n\nThe CREATE USER statement creates new MariaDB accounts. To use it, you must\nhave the global CREATE USER privilege or the INSERT privilege for the mysql\ndatabase. For each account, CREATE USER creates a new row in mysql.user (until\nMariaDB 10.3 this is a table, from MariaDB 10.4 it\'s a view) or\nmysql.global_priv_table (from MariaDB 10.4) that has no privileges.\n\nIf any of the specified accounts, or any permissions for the specified\naccounts, already exist, then the server returns ERROR 1396 (HY000). If an\nerror occurs, CREATE USER will still create the accounts that do not result in\nan error. Only one error is produced for all users which have not been created:\n\nERROR 1396 (HY000): \n Operation CREATE USER failed for \'u1\'@\'%\',\'u2\'@\'%\'\n\nCREATE USER, DROP USER, CREATE ROLE, and DROP ROLE all produce the same error\ncode when they fail.\n\nSee Account Names below for details on how account names are specified.\n\nOR REPLACE\n----------\n\nIf the optional OR REPLACE clause is used, it is basically a shortcut for:\n\nDROP USER IF EXISTS name;\nCREATE USER name ...;\n\nFor example:\n\nCREATE USER foo2@test IDENTIFIED BY \'password\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'foo2\'@\'test\'\n\nCREATE OR REPLACE USER foo2@test IDENTIFIED BY \'password\';\nQuery OK, 0 rows affected (0.00 sec)\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a warning instead\nof an error if the specified user already exists.\n\nFor example:\n\nCREATE USER foo2@test IDENTIFIED BY \'password\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'foo2\'@\'test\'\n\nCREATE USER IF NOT EXISTS foo2@test IDENTIFIED BY \'password\';\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+----------------------------------------------------+\n| Level | Code | Message                                            |\n+-------+------+----------------------------------------------------+\n| Note  | 1973 | Can\'t create user \'foo2\'@\'test\'; it already exists |\n+-------+------+----------------------------------------------------+\n\nAuthentication Options\n----------------------\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored in the\nmysql.user/mysql.global_priv_table table.\n\nFor example, if our password is mariadb, then we can create the user with:\n\nCREATE USER foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD function. It will be stored in the\nmysql.user/mysql.global_priv_table table as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n\nAnd then we can create a user with the hash:\n\nCREATE USER foo2@test IDENTIFIED BY PASSWORD\n\'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nCREATE USER foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nCREATE USER foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nMariaDB starting with 10.4.0\n----------------------------\nThe USING or AS keyword can also be used to provide a plain-text password to a\nplugin if it\'s provided as an argument to the PASSWORD() function. This is\nonly valid for authentication plugins that have implemented a hook for the\nPASSWORD() function. For example, the ed25519 authentication plugin supports\nthis:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nMariaDB starting with 10.4.3\n----------------------------\nOne can specify many authentication plugins, they all work as alternatives\nways of authenticating a user:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\') OR\nunix_socket;\n\nBy default, when you create a user without specifying an authentication\nplugin, MariaDB uses the mysql_native_password plugin.\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can create a user account that requires these TLS options\nwith the following:\n\nCREATE USER \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\'\n AND ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+--------------------------------------+--------------------------------------+\n| Limit Type                           | Decription                           |\n+--------------------------------------+--------------------------------------+\n| MAX_QUERIES_PER_HOUR                 | Number of statements that the        |\n|                                      | account can issue per hour           |\n|                                      | (including updates)                  |\n+--------------------------------------+--------------------------------------+\n| MAX_UPDATES_PER_HOUR                 | Number of updates (not queries)      |\n|                                      | that the account can issue per hour  |\n+--------------------------------------+--------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR             | Number of connections that the       |\n|                                      | account can start per hour           |\n+--------------------------------------+--------------------------------------+\n| MAX_USER_CONNECTIONS                 | Number of simultaneous connections   |\n|                                      | that can be accepted from the same   |\n|                                      | account; if it is 0,                 |\n|                                      | max_connections will be used         |\n|                                      | instead; if max_connections is 0,    |\n|                                      | there is no limit for this           |\n|                                      | account\'s simultaneous connections.  |\n+--------------------------------------+--------------------------------------+\n| MAX_STATEMENT_TIME                   | Timeout, in seconds, for statements  |\n|                                      | executed by the user. See also       |\n|                                      | Aborting Statements that Exceed a    |\n|                                      | Certain Time to Execute.             |\n+--------------------------------------+--------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nHere is an example showing how to create a user with resource limits:\n\nCREATE USER \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 10\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nAccount Names\n-------------\n\nAccount names have both a user name component and a host name component, and\nare specified as \'user_name\'@\'host_name\'.\n\nThe user name and host name may be unquoted, quoted as strings using double\nquotes (\") or single quotes (\'), or quoted as identifiers using backticks (`).\nYou must use quotes when using special characters (such as a hyphen) or\nwildcard characters. If you quote, you must quote the user name and host name\nseparately (for example \'user_name\'@\'host_name\').\n\nHost Name Component\n-------------------\n\nIf the host name is not provided, it is assumed to be \'%\'.\n\nHost names may contain the wildcard characters % and _. They are matched as if\nby the LIKE clause. If you need to use a wildcard character literally (for\nexample, to match a domain name with an underscore), prefix the character with\na backslash. See LIKE for more information on escaping wildcard characters.\n\nHost name matches are case-insensitive. Host names can match either domain\nnames or IP addresses. Use \'localhost\' as the host name to allow only local\nclient connections.\n\nYou can use a netmask to match a range of IP addresses using \'base_ip/netmask\'\nas the host name. A user with an IP address ip_addr will be allowed to connect\nif the following condition is true:\n\nip_addr & netmask = base_ip\n\nFor example, given a user:\n\nCREATE USER \'maria\'@\'247.150.130.0/255.255.255.0\';\n\nthe IP addresses satisfying this condition range from 247.150.130.0 to\n247.150.130.255.\n\nUsing 255.255.255.255 is equivalent to not using a netmask at all. Netmasks\ncannot be used for IPv6 addresses.\n\nNote that the credentials added when creating a user with the \'%\' wildcard\nhost will not grant access in all cases. For example, some systems come with\nan anonymous localhost user, and when connecting from localhost this will take\nprecedence.\n\nBefore MariaDB 10.6, the host name component could be up to 60 characters in\nlength. Starting from MariaDB 10.6, it can be up to 255 characters.\n\nUser Name Component\n-------------------\n\nUser names must match exactly, including case. A user name that is empty is\nknown as an anonymous account and is allowed to match a login attempt with any\nuser name component. These are described more in the next section.\n\nFor valid identifiers to use as user names, see Identifier Names.\n\nIt is possible for more than one account to match when a user connects.\nMariaDB selects the first matching account after sorting according to the\nfollowing criteria:\n\n* Accounts with an exact host name are sorted before accounts using a wildcard\nin the\nhost name. Host names using a netmask are considered to be exact for sorting.\n* Accounts with a wildcard in the host name are sorted according to the\nposition of\nthe first wildcard character. Those with a wildcard character later in the\nhost name\nsort before those with a wildcard character earlier in the host name.\n* Accounts with a non-empty user name sort before accounts with an empty user\nname.\n* Accounts with an empty user name are sorted last. As mentioned previously,\nthese are known as anonymous accounts. These are described more in the next\nsection.\n\nThe following table shows a list of example account as sorted by these\ncriteria:\n\n+---------+-------------+\n| User    | Host        |\n+---------+-------------+\n| joffrey | 192.168.0.3 |\n|         | 192.168.0.% |\n| joffrey | 192.168.%   |\n|         | 192.168.%   |\n+---------+-------------+\n\nOnce connected, you only have the privileges granted to the account that\nmatched, not all accounts that could have matched. For example, consider the\nfollowing commands:\n\nCREATE USER \'joffrey\'@\'192.168.0.3\';\nCREATE USER \'joffrey\'@\'%\';\nGRANT SELECT ON test.t1 to \'joffrey\'@\'192.168.0.3\';\nGRANT SELECT ON test.t2 to \'joffrey\'@\'%\';\n\nIf you connect as joffrey from 192.168.0.3, you will have the SELECT privilege\non the table test.t1, but not on the table test.t2. If you connect as joffrey\nfrom any other IP address, you will have the SELECT privilege on the table\ntest.t2, but not on the table test.t1.\n\nUsernames can be up to 80 characters long before 10.6 and starting from 10.6\nit can be 128 characters long.\n\nAnonymous Accounts\n------------------\n\nAnonymous accounts are accounts where the user name portion of the account\nname is empty. These accounts act as special catch-all accounts. If a user\nattempts to log into the system from a host, and an anonymous account exists\nwith a host name portion that matches the user\'s host, then the user will log\nin as the anonymous account if there is no more specific account match for the\nuser name that the user entered.\n\nFor example, here are some anonymous accounts:\n\nCREATE USER \'\'@\'localhost\';\nCREATE USER \'\'@\'192.168.0.3\';\n\nFixing a Legacy Default Anonymous Account\n-----------------------------------------\n\nOn some systems, the mysql.db table has some entries for the \'\'@\'%\' anonymous\naccount by default. Unfortunately, there is no matching entry in the\nmysql.user/mysql.global_priv_table table, which means that this anonymous\naccount doesn\'t exactly exist, but it does have privileges--usually on the\ndefault test database created by mysql_install_db. These account-less\nprivileges are a legacy that is leftover from a time when MySQL\'s privilege\nsystem was less advanced.\n\nThis situation means that you will run into errors if you try to create a\n\'\'@\'%\' account. For example:\n\nCREATE USER \'\'@\'%\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'\'@\'%\'\n\nThe fix is to DELETE the row in the mysql.db table and then execute FLUSH\nPRIVILEGES:\n\nDELETE FROM mysql.db WHERE User=\'\' AND Host=\'%\';\nFLUSH PRIVILEGES;\n\nAnd then the account can be created:\n\nCREATE USER \'\'@\'%\';\nQuery OK, 0 rows affected (0.01 sec)\n\nSee MDEV-13486 for more information.\n\nPassword Expiry\n---------------\n\nMariaDB starting with 10.4.3\n----------------------------\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal setting, for example:\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\n\nSee User Password Expiry for more details.\n\nAccount Locking\n---------------\n\nMariaDB starting with 10.4.2\n----------------------------\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected). For example:\n\nCREATE USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nSee Account Locking for more details.\n\nFrom MariaDB 10.4.7 and MariaDB 10.5.8, the lock_option and password_option\nclauses can occur in either order.\n\nURL: https://mariadb.com/kb/en/create-user/','','https://mariadb.com/kb/en/create-user/'),(105,'ALTER USER',10,'Syntax\n------\n\nALTER USER [IF EXISTS] \n user_specification [,user_specification] ...\n [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n [WITH resource_option [resource_option] ...]\n [lock_option] [password_option]\n\nuser_specification:\n username [authentication_option]\n\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule] ...\n\nauthentication_rule:\n authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\ntls_option\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nresource_option\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n\nlock_option:\n  ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n\nDescription\n-----------\n\nThe ALTER USER statement modifies existing MariaDB accounts. To use it, you\nmust have the global CREATE USER privilege or the UPDATE privilege for the\nmysql database. The global SUPER privilege is also required if the read_only\nsystem variable is enabled.\n\nIf any of the specified user accounts do not yet exist, an error results. If\nan error occurs, ALTER USER will still modify the accounts that do not result\nin an error. Only one error is produced for all users which have not been\nmodified.\n\nIF EXISTS\n---------\n\nWhen the IF EXISTS clause is used, MariaDB will return a warning instead of an\nerror for each specified user that does not exist.\n\nAccount Names\n-------------\n\nFor ALTER USER statements, account names are specified as the username\nargument in the same way as they are for CREATE USER statements. See account\nnames from the CREATE USER page for details on how account names are specified.\n\nCURRENT_USER or CURRENT_USER() can also be used to alter the account logged\ninto the current session. For example, to change the current user\'s password\nto mariadb:\n\nALTER USER CURRENT_USER() IDENTIFIED BY \'mariadb\';\n\nAuthentication Options\n----------------------\n\nMariaDB starting with 10.4\n--------------------------\nFrom MariaDB 10.4, it is possible to use more than one authentication plugin\nfor each user account. For example, this can be useful to slowly migrate users\nto the more secure ed25519 authentication plugin over time, while allowing the\nold mysql_native_password authentication plugin as an alternative for the\ntransitional period. See Authentication from MariaDB 10.4 for more.\n\nWhen running ALTER USER, not specifying an authentication option in the\nIDENTIFIED VIA clause will remove that authentication method. (However this\nwas not the case before MariaDB 10.4.13, see MDEV-21928)\n\nFor example, a user is created with the ability to authenticate via both a\npassword and unix_socket:\n\nCREATE USER \'bob\'@\'localhost\' \n IDENTIFIED VIA mysql_native_password USING PASSWORD(\'pwd\')\n OR unix_socket;\n\nSHOW CREATE USER \'bob\'@\'localhost\'\\G\n*************************** 1. row ***************************\nCREATE USER for bob@localhost: CREATE USER `bob`@`localhost` \n IDENTIFIED VIA mysql_native_password\n USING \'*975B2CD4FF9AE554FE8AD33168FBFC326D2021DD\'\n OR unix_socket\n\nIf the user\'s password is updated, but unix_socket authentication is not\nspecified in the IDENTIFIED VIA clause, unix_socket authentication will no\nlonger be permitted.\n\nALTER USER \'bob\'@\'localhost\' IDENTIFIED VIA mysql_native_password \n USING PASSWORD(\'pwd2\');\n\nSHOW CREATE USER \'bob\'@\'localhost\'\\G\n*************************** 1. row ***************************\nCREATE USER for bob@localhost: CREATE USER `bob`@`localhost` \n IDENTIFIED BY PASSWORD \'*38366FDA01695B6A5A9DD4E428D9FB8F7EB75512\'\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored to the mysql.user table.\n\nFor example, if our password is mariadb, then we can set the account\'s\npassword with:\n\nALTER USER foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD#function. It will be stored to the\nmysql.user table as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n\nAnd then we can set an account\'s password with the hash:\n\nALTER USER foo2@test \n IDENTIFIED BY PASSWORD \'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nALTER USER foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nALTER USER foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nIn MariaDB 10.4 and later, the USING or AS keyword can also be used to provide\na plain-text password to a plugin if it\'s provided as an argument to the\nPASSWORD() function. This is only valid for authentication plugins that have\nimplemented a hook for the PASSWORD() function. For example, the ed25519\nauthentication plugin supports this:\n\nALTER USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can alter a user account to require these TLS options with\nthe following:\n\nALTER USER \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\' AND\n ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+------------------------------------+---------------------------------------+\n| Limit Type                         | Description                           |\n+------------------------------------+---------------------------------------+\n| MAX_QUERIES_PER_HOUR               | Number of statements that the         |\n|                                    | account can issue per hour            |\n|                                    | (including updates)                   |\n+------------------------------------+---------------------------------------+\n| MAX_UPDATES_PER_HOUR               | Number of updates (not queries) that  |\n|                                    | the account can issue per hour        |\n+------------------------------------+---------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR           | Number of connections that the        |\n|                                    | account can start per hour            |\n+------------------------------------+---------------------------------------+\n| MAX_USER_CONNECTIONS               | Number of simultaneous connections    |\n|                                    | that can be accepted from the same    |\n|                                    | account; if it is 0, max_connections  |\n|                                    | will be used instead; if              |\n|                                    | max_connections is 0, there is no     |\n|                                    | limit for this account\'s              |\n|                                    | simultaneous connections.             |\n+------------------------------------+---------------------------------------+\n| MAX_STATEMENT_TIME                 | Timeout, in seconds, for statements   |\n|                                    | executed by the user. See also        |\n|                                    | Aborting Statements that Exceed a     |\n|                                    | Certain Time to Execute.              |\n+------------------------------------+---------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nHere is an example showing how to set an account\'s resource limits:\n\nALTER USER \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 10\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nPassword Expiry\n---------------\n\nMariaDB starting with 10.4.3\n----------------------------\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal setting, for example:\n\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE NEVER;\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n\nSee User Password Expiry for more details.\n\nAccount Locking\n---------------\n\nMariaDB starting with 10.4.2\n----------------------------\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected). For example:\n\nALTER USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nSee Account Locking for more details.\n\nFrom MariaDB 10.4.7 and MariaDB 10.5.8, the lock_option and password_option\nclauses can occur in either order.\n\nURL: https://mariadb.com/kb/en/alter-user/','','https://mariadb.com/kb/en/alter-user/'),(107,'GRANT',10,'Syntax\n------\n\nGRANT\n  priv_type [(column_list)]\n   [, priv_type [(column_list)]] ...\n  ON [object_type] priv_level\n  TO user_specification [ user_options ...]\n\nuser_specification:\n username [authentication_option]\n | PUBLIC\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule  ...]\n\nauthentication_rule:\n  authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\nGRANT PROXY ON username\n  TO user_specification [, user_specification ...]\n  [WITH GRANT OPTION]\n\nGRANT rolename TO grantee [, grantee ...]\n  [WITH ADMIN OPTION]\n\ngrantee:\n  rolename\n  username [authentication_option]\n\nuser_options:\n  [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n  [WITH with_option [with_option] ...]\n\nobject_type:\n  TABLE\n | FUNCTION\n | PROCEDURE\n | PACKAGE\n\npriv_level:\n  *\n | *.*\n | db_name.*\n | db_name.tbl_name\n | tbl_name\n | db_name.routine_name\n\nwith_option:\n  GRANT OPTION\n | resource_option\n\nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\ntls_option:\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nDescription\n-----------\n\nThe GRANT statement allows you to grant privileges or roles to accounts. To\nuse GRANT, you must have the GRANT OPTION privilege, and you must have the\nprivileges that you are granting.\n\nUse the REVOKE statement to revoke privileges granted with the GRANT statement.\n\nUse the SHOW GRANTS statement to determine what privileges an account has.\n\nAccount Names\n-------------\n\nFor GRANT statements, account names are specified as the username argument in\nthe same way as they are for CREATE USER statements. See account names from\nthe CREATE USER page for details on how account names are specified.\n\nImplicit Account Creation\n-------------------------\n\nThe GRANT statement also allows you to implicitly create accounts in some\ncases.\n\nIf the account does not yet exist, then GRANT can implicitly create it. To\nimplicitly create an account with GRANT, a user is required to have the same\nprivileges that would be required to explicitly create the account with the\nCREATE USER statement.\n\nIf the NO_AUTO_CREATE_USER SQL_MODE is set, then accounts can only be created\nif authentication information is specified, or with a CREATE USER statement.\nIf no authentication information is provided, GRANT will produce an error when\nthe specified account does not exist, for example:\n\nshow variables like \'%sql_mode%\' ;\n+---------------+--------------------------------------------+\n| Variable_name | Value                                      |\n+---------------+--------------------------------------------+\n| sql_mode      | NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION |\n+---------------+--------------------------------------------+\n\nGRANT USAGE ON *.* TO \'user123\'@\'%\' IDENTIFIED BY \'\';\nERROR 1133 (28000): Can\'t find any matching row in the user table\n\nGRANT USAGE ON *.* TO \'user123\'@\'%\' \n IDENTIFIED VIA PAM using \'mariadb\' require ssl ;\nQuery OK, 0 rows affected (0.00 sec)\n\nselect host, user from mysql.user where user=\'user123\' ;\n\n+------+----------+\n| host | user     |\n+------+----------+\n| %    | user123 |\n+------+----------+\n\nPrivilege Levels\n----------------\n\nPrivileges can be set globally, for an entire database, for a table or\nroutine, or for individual columns in a table. Certain privileges can only be\nset at certain levels.\n\n* Global privileges priv_type are granted using *.* for\npriv_level. Global privileges include privileges to administer the database\nand manage user accounts, as well as privileges for all tables, functions, and\nprocedures. Global privileges are stored in the mysql.user table prior to\nMariaDB 10.4, and in  mysql.global_priv table afterwards.\n* Database privileges priv_type are granted using db_name.*\nfor priv_level, or using just * to use default database. Database\nprivileges include privileges to create tables and functions, as well as\nprivileges for all tables, functions, and procedures in the database. Database\nprivileges are stored in the mysql.db table.\n* Table privileges priv_type are granted using db_name.tbl_name\nfor priv_level, or using just tbl_name to specify a table in the default\ndatabase. The TABLE keyword is optional. Table privileges include the\nability to select and change data in the table. Certain table privileges can\nbe granted for individual columns.\n* Column privileges priv_type are granted by specifying a table for\npriv_level and providing a column list after the privilege type. They allow\nyou to control exactly which columns in a table users can select and change.\n* Function privileges priv_type are granted using FUNCTION db_name.routine_name\nfor priv_level, or using just  FUNCTION routine_name to specify a function\nin the default database.\n* Procedure privileges priv_type are granted using PROCEDURE\ndb_name.routine_name\nfor priv_level, or using just PROCEDURE routine_name to specify a procedure\nin the default database.\n\nThe USAGE Privilege\n-------------------\n\nThe USAGE privilege grants no real privileges. The SHOW GRANTS statement will\nshow a global USAGE privilege for a newly-created user. You can use USAGE with\nthe GRANT statement to change options like GRANT OPTION and\nMAX_USER_CONNECTIONS without changing any account privileges.\n\nThe ALL PRIVILEGES Privilege\n----------------------------\n\nThe ALL PRIVILEGES privilege grants all available privileges. Granting all\nprivileges only affects the given privilege level. For example, granting all\nprivileges on a table does not grant any privileges on the database or\nglobally.\n\nUsing ALL PRIVILEGES does not grant the special GRANT OPTION privilege.\n\nYou can use ALL instead of ALL PRIVILEGES.\n\nThe GRANT OPTION Privilege\n--------------------------\n\nUse the WITH GRANT OPTION clause to give users the ability to grant privileges\nto other users at the given privilege level. Users with the GRANT OPTION\nprivilege can only grant privileges they have. They cannot grant privileges at\na higher privilege level than they have the GRANT OPTION privilege.\n\nThe GRANT OPTION privilege cannot be set for individual columns. If you use\nWITH GRANT OPTION when specifying column privileges, the GRANT OPTION\nprivilege will be granted for the entire table.\n\nUsing the WITH GRANT OPTION clause is equivalent to listing GRANT OPTION as a\nprivilege.\n\nGlobal Privileges\n-----------------\n\nThe following table lists the privileges that can be granted globally. You can\nalso grant all database, table, and function privileges globally. When granted\nglobally, these privileges apply to all databases, tables, or functions,\nincluding those created later.\n\nTo set a global privilege, use *.* for priv_level.\n\nBINLOG ADMIN\n------------\n\nEnables administration of the binary log, including the PURGE BINARY LOGS\nstatement and setting the system variables:\n\n* binlog_annotate_row_events\n* binlog_cache_size\n* binlog_commit_wait_count\n* binlog_commit_wait_usec\n* binlog_direct_non_transactional_updates\n* binlog_expire_logs_seconds\n* binlog_file_cache_size\n* binlog_format\n* binlog_row_image\n* binlog_row_metadata\n* binlog_stmt_cache_size\n* expire_logs_days\n* log_bin_compress\n* log_bin_compress_min_len\n* log_bin_trust_function_creators\n* max_binlog_cache_size\n* max_binlog_size\n* max_binlog_stmt_cache_size\n* sql_log_bin and\n* sync_binlog.\n\nAdded in MariaDB 10.5.2.\n\nBINLOG MONITOR\n--------------\n\nNew name for REPLICATION CLIENT from MariaDB 10.5.2, (REPLICATION CLIENT still\nsupported as an alias for compatibility purposes). Permits running SHOW\ncommands related to the binary log, in particular the SHOW BINLOG STATUS and\nSHOW BINARY LOGS statements. Unlike REPLICATION CLIENT prior to MariaDB 10.5,\nSHOW REPLICA STATUS isn\'t included in this privilege, and REPLICA MONITOR is\nrequired.\n\nBINLOG REPLAY\n-------------\n\nEnables replaying the binary log with the BINLOG statement (generated by\nmariadb-binlog), executing SET timestamp when secure_timestamp is set to\nreplication, and setting the session values of system variables usually\nincluded in BINLOG output, in particular:\n\n* gtid_domain_id\n* gtid_seq_no\n* pseudo_thread_id\n* server_id.\n\nAdded in MariaDB 10.5.2\n\nCONNECTION ADMIN\n----------------\n\nEnables administering connection resource limit options. This includes\nignoring the limits specified by:\n\n* max_connections\n* max_user_connections and\n* max_password_errors.\n\nThe statements specified in init_connect are not executed, killing connections\nand queries owned by other users is permitted. The following\nconnection-related system variables can be changed:\n\n* connect_timeout\n* disconnect_on_expired_password\n* extra_max_connections\n* init_connect\n* max_connections\n* max_connect_errors\n* max_password_errors\n* proxy_protocol_networks\n* secure_auth\n* slow_launch_time\n* thread_pool_exact_stats\n* thread_pool_dedicated_listener\n* thread_pool_idle_timeout\n* thread_pool_max_threads\n* thread_pool_min_threads\n* thread_pool_oversubscribe\n* thread_pool_prio_kickup_timer\n* thread_pool_priority\n* thread_pool_size, and\n* thread_pool_stall_limit.\n\nAdded in MariaDB 10.5.2.\n\nCREATE USER\n-----------\n\nCreate a user using the CREATE USER statement, or implicitly create a user\nwith the GRANT statement.\n\nFEDERATED ADMIN\n---------------\n\nExecute CREATE SERVER, ALTER SERVER, and DROP SERVER statements. Added in\nMariaDB 10.5.2.\n\nFILE\n----\n\nRead and write files on the server, using statements like LOAD DATA INFILE or\nfunctions like LOAD_FILE(). Also needed to create CONNECT outward tables.\nMariaDB server must have the permissions to access those files.\n\nGRANT OPTION\n------------\n\nGrant global privileges. You can only grant privileges that you have.\n\nPROCESS\n-------\n\nShow information about the active processes, for example via SHOW PROCESSLIST\nor mysqladmin processlist. If you have the PROCESS privilege, you can see all\nthreads. Otherwise, you can see only your own threads (that is, threads\nassociated with the MariaDB account that you are using).\n\nREAD_ONLY ADMIN\n---------------\n\nUser can set the read_only system variable and allows the user to perform\nwrite operations, even when the read_only option is active. Added in MariaDB\n10.5.2.\n\nFrom MariaDB 10.11.0, the READ_ONLY ADMIN privilege has been removed from\nSUPER. The benefit of this is that one can remove the READ_ONLY ADMIN\nprivilege from all users and ensure that no one can make any changes on any\nnon-temporary tables. This is useful on replicas when one wants to ensure that\nthe replica is kept identical to the primary.\n\nRELOAD\n------\n\nExecute FLUSH statements or equivalent mariadb-admin/mysqladmin commands.\n\nREPLICATION CLIENT\n------------------\n\nExecute SHOW MASTER STATUS and SHOW BINARY LOGS informative statements.\nRenamed to BINLOG MONITOR in MariaDB 10.5.2 (but still supported as an alias\nfor compatibility reasons). SHOW SLAVE STATUS was part of REPLICATION CLIENT\nprior to MariaDB 10.5.\n\nREPLICATION MASTER ADMIN\n------------------------\n\nPermits administration of primary servers, including the SHOW REPLICA HOSTS\nstatement, and setting the gtid_binlog_state, gtid_domain_id,\nmaster_verify_checksum and server_id system variables. Added in MariaDB 10.5.2.\n\nREPLICA MONITOR\n---------------\n\nPermit SHOW REPLICA STATUS and SHOW RELAYLOG EVENTS. From MariaDB 10.5.9.\n\nWhen a user would upgrade from an older major release to a MariaDB 10.5 minor\nrelease prior to MariaDB 10.5.9, certain user accounts would lose\ncapabilities. For example, a user account that had the REPLICATION CLIENT\nprivilege in older major releases could run SHOW REPLICA STATUS, but after\nupgrading to a MariaDB 10.5 minor release prior to MariaDB 10.5.9, they could\nno longer run SHOW REPLICA STATUS, because that statement was changed to\nrequire the REPLICATION REPLICA ADMIN privilege.\n\nThis issue is fixed in MariaDB 10.5.9 with this new privilege, which now\ngrants the user the ability to execute SHOW [ALL] (SLAVE | REPLICA) STATUS.\n\nWhen a database is upgraded from an older major release to MariaDB Server\n10.5.9 or later, any user accounts with the REPLICATION CLIENT or REPLICATION\nSLAVE privileges will automatically be granted the new REPLICA MONITOR\nprivilege. The privilege fix occurs when the server is started up, not when\nmariadb-upgrade is performed.\n\nHowever, when a database is upgraded from an early 10.5 minor release to\n10.5.9 and later, the user will have to fix any user account privileges\nmanually.\n\nREPLICATION REPLICA\n-------------------\n\nSynonym for REPLICATION SLAVE. From MariaDB 10.5.1.\n\nREPLICATION SLAVE\n-----------------\n\nAccounts used by replica servers on the primary need this privilege. This is\nneeded to get the updates made on the master. From MariaDB 10.5.1, REPLICATION\nREPLICA is an alias for REPLICATION SLAVE.\n\nREPLICATION SLAVE ADMIN\n-----------------------\n\nPermits administering replica servers, including START REPLICA/SLAVE, STOP\nREPLICA/SLAVE, CHANGE MASTER, SHOW REPLICA/SLAVE STATUS, SHOW RELAYLOG EVENTS\nstatements, replaying the binary log with the BINLOG statement (generated by\nmariadb-binlog), and setting the system variables:\n\n* gtid_cleanup_batch_size\n* gtid_ignore_duplicates\n* gtid_pos_auto_engines\n* gtid_slave_pos\n* gtid_strict_mode\n* init_slave\n* read_binlog_speed_limit\n* relay_log_purge\n* relay_log_recovery\n* replicate_do_db\n* replicate_do_table\n* replicate_events_marked_for_skip\n* replicate_ignore_db\n* replicate_ignore_table\n* replicate_wild_do_table\n* replicate_wild_ignore_table\n* slave_compressed_protocol\n* slave_ddl_exec_mode\n* slave_domain_parallel_threads\n* slave_exec_mode\n* slave_max_allowed_packet\n* slave_net_timeout\n* slave_parallel_max_queued\n* slave_parallel_mode\n* slave_parallel_threads\n* slave_parallel_workers\n* slave_run_triggers_for_rbr\n* slave_sql_verify_checksum\n* slave_transaction_retry_interval\n* slave_type_conversions\n* sync_master_info\n* sync_relay_log, and\n* sync_relay_log_info.\n\nAdded in MariaDB 10.5.2.\n\nSET USER\n--------\n\nEnables setting the DEFINER when creating triggers, views, stored functions\nand stored procedures. Added in MariaDB 10.5.2.\n\nSHOW DATABASES\n--------------\n\nList all databases using the SHOW DATABASES statement. Without the SHOW\nDATABASES privilege, you can still issue the SHOW DATABASES statement, but it\nwill only list databases containing tables on which you have privileges.\n\nSHUTDOWN\n--------\n\nShut down the server using SHUTDOWN or the mysqladmin shutdown command.\n\nSUPER\n-----\n\nExecute superuser statements: CHANGE MASTER TO, KILL (users who do not have\nthis privilege can only KILL their own threads), PURGE LOGS, SET global system\nvariables, or the mysqladmin debug command. Also, this permission allows the\nuser to write data even if the read_only startup option is set, enable or\ndisable logging, enable or disable replication on replica, specify a DEFINER\nfor statements that support that clause, connect once reaching the\nMAX_CONNECTIONS. If a statement has been specified for the init-connect mysqld\noption, that command will not be executed when a user with SUPER privileges\nconnects to the server.\n\nThe SUPER privilege has been split into multiple smaller privileges from\nMariaDB 10.5.2 to allow for more fine-grained privileges, although it remains\nan alias for these smaller privileges.\n\nFrom MariaDB 10.11.0, the READ_ONLY ADMIN privilege has been removed from\nSUPER. The benefit of this is that one can remove the READ_ONLY ADMIN\nprivilege from all users and ensure that no one can make any changes on any\nnon-temporary tables. This is useful on replicas when one wants to ensure that\nthe replica is kept identical to the primary.\n\nDatabase Privileges\n-------------------\n\nThe following table lists the privileges that can be granted at the database\nlevel. You can also grant all table and function privileges at the database\nlevel. Table and function privileges on a database apply to all tables or\nfunctions in that database, including those created later.\n\nTo set a privilege for a database, specify the database using db_name.* for\npriv_level, or just use * to specify the default database.\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| CREATE                           | Create a database using the CREATE      |\n|                                  | DATABASE statement, when the privilege  |\n|                                  | is granted for a database. You can      |\n|                                  | grant the CREATE privilege on           |\n|                                  | databases that do not yet exist. This   |\n|                                  | also grants the CREATE privilege on     |\n|                                  | all tables in the database.             |\n+----------------------------------+-----------------------------------------+\n| CREATE ROUTINE                   | Create Stored Programs using the        |\n|                                  | CREATE PROCEDURE and CREATE FUNCTION    |\n|                                  | statements.                             |\n+----------------------------------+-----------------------------------------+\n| CREATE TEMPORARY TABLES          | Create temporary tables with the        |\n|                                  | CREATE TEMPORARY TABLE statement. This  |\n|                                  | privilege enable writing and dropping   |\n|                                  | those temporary tables                  |\n+----------------------------------+-----------------------------------------+\n| DROP                             | Drop a database using the DROP          |\n|                                  | DATABASE statement, when the privilege  |\n|                                  | is granted for a database. This also    |\n|                                  | grants the DROP privilege on all        |\n|                                  | tables in the database.                 |\n+----------------------------------+-----------------------------------------+\n| EVENT                            | Create, drop and alter EVENTs.          |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant database privileges. You can      |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n| LOCK TABLES                      | Acquire explicit locks using the LOCK   |\n|                                  | TABLES statement; you also need to      |\n|                                  | have the SELECT privilege on a table,   |\n|                                  | in order to lock it.                    |\n+----------------------------------+-----------------------------------------+\n\nTable Privileges\n----------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER                            | Change the structure of an existing     |\n|                                  | table using the ALTER TABLE statement.  |\n+----------------------------------+-----------------------------------------+\n| CREATE                           | Create a table using the CREATE TABLE   |\n|                                  | statement.  You can grant the CREATE    |\n|                                  | privilege on tables that do not yet     |\n|                                  | exist.                                  |\n+----------------------------------+-----------------------------------------+\n| CREATE VIEW                      | Create a view using the CREATE_VIEW     |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| DELETE                           | Remove rows from a table using the      |\n|                                  | DELETE statement.                       |\n+----------------------------------+-----------------------------------------+\n| DELETE HISTORY                   | Remove historical rows from a table     |\n|                                  | using the DELETE HISTORY statement.     |\n|                                  | Displays as DELETE VERSIONING ROWS      |\n|                                  | when running SHOW GRANTS until MariaDB  |\n|                                  | 10.3.15 and until MariaDB 10.4.5        |\n|                                  | (MDEV-17655), or when running SHOW      |\n|                                  | PRIVILEGES until MariaDB 10.5.2,        |\n|                                  | MariaDB 10.4.13 and MariaDB 10.3.23     |\n|                                  | (MDEV-20382). From MariaDB 10.3.4.      |\n|                                  | From MariaDB 10.3.5, if a user has the  |\n|                                  | SUPER privilege but not this            |\n|                                  | privilege, running mysql_upgrade will   |\n|                                  | grant this privilege as well.           |\n+----------------------------------+-----------------------------------------+\n| DROP                             | Drop a table using the DROP TABLE       |\n|                                  | statement or a view using the DROP      |\n|                                  | VIEW statement. Also required to        |\n|                                  | execute the TRUNCATE TABLE statement.   |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant table privileges. You can only    |\n|                                  | grant privileges that you have.         |\n+----------------------------------+-----------------------------------------+\n| INDEX                            | Create an index on a table using the    |\n|                                  | CREATE INDEX statement. Without the     |\n|                                  | INDEX privilege, you can still create   |\n|                                  | indexes when creating a table using     |\n|                                  | the CREATE TABLE statement if the you   |\n|                                  | have the CREATE privilege, and you can  |\n|                                  | create indexes using the ALTER TABLE    |\n|                                  | statement if you have the ALTER         |\n|                                  | privilege.                              |\n+----------------------------------+-----------------------------------------+\n| INSERT                           | Add rows to a table using the INSERT    |\n|                                  | statement.  The INSERT privilege can    |\n|                                  | also be set on individual columns; see  |\n|                                  | Column Privileges below for details.    |\n+----------------------------------+-----------------------------------------+\n| REFERENCES                       | Unused.                                 |\n+----------------------------------+-----------------------------------------+\n| SELECT                           | Read data from a table using the        |\n|                                  | SELECT statement. The SELECT privilege  |\n|                                  | can also be set on individual columns;  |\n|                                  | see Column Privileges below for         |\n|                                  | details.                                |\n+----------------------------------+-----------------------------------------+\n| SHOW VIEW                        | Show the CREATE VIEW statement to       |\n|                                  | create a view using the SHOW CREATE     |\n|                                  | VIEW statement.                         |\n+----------------------------------+-----------------------------------------+\n| TRIGGER                          | Execute triggers associated to tables   |\n|                                  | you update, execute the CREATE TRIGGER  |\n|                                  | and DROP TRIGGER statements. You will   |\n|                                  | still be able to see triggers.          |\n+----------------------------------+-----------------------------------------+\n| UPDATE                           | Update existing rows in a table using   |\n|                                  | the UPDATE statement. UPDATE            |\n|                                  | statements usually include a WHERE      |\n|                                  | clause to update only certain rows.     |\n|                                  | You must have SELECT privileges on the  |\n|                                  | table or the appropriate columns for    |\n|                                  | the WHERE clause. The UPDATE privilege  |\n|                                  | can also be set on individual columns;  |\n|                                  | see Column Privileges below for         |\n|                                  | details.                                |\n+----------------------------------+-----------------------------------------+\n\nColumn Privileges\n-----------------\n\nSome table privileges can be set for individual columns of a table. To use\ncolumn privileges, specify the table explicitly and provide a list of column\nnames after the privilege type. For example, the following statement would\nallow the user to read the names and positions of employees, but not other\ninformation from the same table, such as salaries.\n\nGRANT SELECT (name, position) on Employee to \'jeffrey\'@\'localhost\';\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| INSERT (column_list)             | Add rows specifying values in columns   |\n|                                  | using the INSERT statement. If you      |\n|                                  | only have column-level INSERT           |\n|                                  | privileges, you must specify the        |\n|                                  | columns you are setting in the INSERT   |\n|                                  | statement. All other columns will be    |\n|                                  | set to their default values, or NULL.   |\n+----------------------------------+-----------------------------------------+\n| REFERENCES (column_list)         | Unused.                                 |\n+----------------------------------+-----------------------------------------+\n| SELECT (column_list)             | Read values in columns using the        |\n|                                  | SELECT statement. You cannot access or  |\n|                                  | query any columns for which you do not  |\n|                                  | have SELECT privileges, including in    |\n|                                  | WHERE, ON, GROUP BY, and ORDER BY       |\n|                                  | clauses.                                |\n+----------------------------------+-----------------------------------------+\n| UPDATE (column_list)             | Update values in columns of existing    |\n|                                  | rows using the UPDATE statement.        |\n|                                  | UPDATE statements usually include a     |\n|                                  | WHERE clause to update only certain     |\n|                                  | rows. You must have SELECT privileges   |\n|                                  | on the table or the appropriate         |\n|                                  | columns for the WHERE clause.           |\n+----------------------------------+-----------------------------------------+\n\nFunction Privileges\n-------------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER ROUTINE                    | Change the characteristics of a stored  |\n|                                  | function using the ALTER FUNCTION       |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| EXECUTE                          | Use a stored function. You need SELECT  |\n|                                  | privileges for any tables or columns    |\n|                                  | accessed by the function.               |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant function privileges. You can      |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n\nProcedure Privileges\n--------------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER ROUTINE                    | Change the characteristics of a stored  |\n|                                  | procedure using the ALTER PROCEDURE     |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| EXECUTE                          | Execute a stored procedure using the    |\n|                                  | CALL statement. The privilege to call   |\n|                                  | a procedure may allow you to perform    |\n|                                  | actions you wouldn\'t otherwise be able  |\n|                                  | to do, such as insert rows into a       |\n|                                  | table.                                  |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant procedure privileges. You can     |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n\nGRANT EXECUTE ON PROCEDURE mysql.create_db TO maintainer;\n\nProxy Privileges\n----------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| PROXY                            | Permits one user to be a proxy for      |\n|                                  | another.                                |\n+----------------------------------+-----------------------------------------+\n\nThe PROXY privilege allows one user to proxy as another user, which means\ntheir privileges change to that of the proxy user, and the CURRENT_USER()\nfunction returns the user name of the proxy user.\n\nThe PROXY privilege only works with authentication plugins that support it.\nThe default mysql_native_password authentication plugin does not support proxy\nusers.\n\nThe pam authentication plugin is the only plugin included with MariaDB that\ncurrently supports proxy users. The PROXY privilege is commonly used with the\npam authentication plugin to enable user and group mapping with PAM.\n\nFor example, to grant the PROXY privilege to an anonymous account that\nauthenticates with the pam authentication plugin, you could execute the\nfollowing:\n\nCREATE USER \'dba\'@\'%\' IDENTIFIED BY \'strongpassword\';\nGRANT ALL PRIVILEGES ON *.* TO \'dba\'@\'%\' ;\n\nCREATE USER \'\'@\'%\' IDENTIFIED VIA pam USING \'mariadb\';\nGRANT PROXY ON \'dba\'@\'%\' TO \'\'@\'%\';\n\nA user account can only grant the PROXY privilege for a specific user account\nif the granter also has the PROXY privilege for that specific user account,\nand if that privilege is defined WITH GRANT OPTION. For example, the following\nexample fails because the granter does not have the PROXY privilege for that\nspecific user account at all:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------+\n| Grants for alice@localhost                                                  \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' |\n+------------------------------------------------------------------------------\n----------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nERROR 1698 (28000): Access denied for user \'alice\'@\'localhost\'\n\nAnd the following example fails because the granter does have the PROXY\nprivilege for that specific user account, but it is not defined WITH GRANT\nOPTION:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------+\n| Grants for alice@localhost                                                  \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' |\n| GRANT PROXY ON \'dba\'@\'localhost\' TO \'alice\'@\'localhost\'                     \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nERROR 1698 (28000): Access denied for user \'alice\'@\'localhost\'\n\nBut the following example succeeds because the granter does have the PROXY\nprivilege for that specific user account, and it is defined WITH GRANT OPTION:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| Grants for alice@localhost                                                  \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' WITH GRANT OPTION |\n| GRANT PROXY ON \'dba\'@\'localhost\' TO \'alice\'@\'localhost\' WITH GRANT OPTION   \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\n\nA user account can grant the PROXY privilege for any other user account if the\ngranter has the PROXY privilege for the \'\'@\'%\' anonymous user account, like\nthis:\n\nGRANT PROXY ON \'\'@\'%\' TO \'dba\'@\'localhost\' WITH GRANT OPTION;\n\nFor example, the following example succeeds because the user can grant the\nPROXY privilege for any other user account:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| Grants for alice@localhost                                                  \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' WITH GRANT OPTION |\n| GRANT PROXY ON \'\'@\'%\' TO \'alice\'@\'localhost\' WITH GRANT OPTION              \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n\nGRANT PROXY ON \'app1_dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nQuery OK, 0 rows affected (0.004 sec)\n\nGRANT PROXY ON \'app2_dba\'@\'localhost\' TO \'carol\'@\'localhost\';\nQuery OK, 0 rows affected (0.004 sec)\n\nThe default root user accounts created by mysql_install_db have this\nprivilege. For example:\n\nGRANT ALL PRIVILEGES ON *.* TO \'root\'@\'localhost\' WITH GRANT OPTION;\nGRANT PROXY ON \'\'@\'%\' TO \'root\'@\'localhost\' WITH GRANT OPTION;\n\nThis allows the default root user accounts to grant the PROXY privilege for\nany other user account, and it also allows the default root user accounts to\ngrant others the privilege to do the same.\n\nAuthentication Options\n----------------------\n\nThe authentication options for the GRANT statement are the same as those for\nthe CREATE USER statement.\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored.\n\nFor example, if our password is mariadb, then we can create the user with:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nIf the user account already exists and if you provide the IDENTIFIED BY\nclause, then the user\'s password will be changed. You must have the privileges\nneeded for the SET PASSWORD statement to change a user\'s password with GRANT.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD function. It will be stored as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n\nAnd then we can create a user with the hash:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED BY \n PASSWORD \'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nIf the user account already exists and if you provide the IDENTIFIED BY\nclause, then the user\'s password will be changed. You must have the privileges\nneeded for the SET PASSWORD statement to change a user\'s password with GRANT.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nMariaDB starting with 10.4.0\n----------------------------\nThe USING or AS keyword can also be used to provide a plain-text password to a\nplugin if it\'s provided as an argument to the PASSWORD() function. This is\nonly valid for authentication plugins that have implemented a hook for the\nPASSWORD() function. For example, the ed25519 authentication plugin supports\nthis:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 \n USING PASSWORD(\'secret\');\n\nMariaDB starting with 10.4.3\n----------------------------\nOne can specify many authentication plugins, they all work as alternatives\nways of authenticating a user:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 \n USING PASSWORD(\'secret\') OR unix_socket;\n\nBy default, when you create a user without specifying an authentication\nplugin, MariaDB uses the mysql_native_password plugin.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+--------------------------------------+--------------------------------------+\n| Limit Type                           | Decription                           |\n+--------------------------------------+--------------------------------------+\n| MAX_QUERIES_PER_HOUR                 | Number of statements that the        |\n|                                      | account can issue per hour           |\n|                                      | (including updates)                  |\n+--------------------------------------+--------------------------------------+\n| MAX_UPDATES_PER_HOUR                 | Number of updates (not queries)      |\n|                                      | that the account can issue per hour  |\n+--------------------------------------+--------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR             | Number of connections that the       |\n|                                      | account can start per hour           |\n+--------------------------------------+--------------------------------------+\n| MAX_USER_CONNECTIONS                 | Number of simultaneous connections   |\n|                                      | that can be accepted from the same   |\n|                                      | account; if it is 0,                 |\n|                                      | max_connections will be used         |\n|                                      | instead; if max_connections is 0,    |\n|                                      | there is no limit for this           |\n|                                      | account\'s simultaneous connections.  |\n+--------------------------------------+--------------------------------------+\n| MAX_STATEMENT_TIME                   | Timeout, in seconds, for statements  |\n|                                      | executed by the user. See also       |\n|                                      | Aborting Statements that Exceed a    |\n|                                      | Certain Time to Execute.             |\n+--------------------------------------+--------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nTo set resource limits for an account, if you do not want to change that\naccount\'s privileges, you can issue a GRANT statement with the USAGE\nprivilege, which has no meaning. The statement can name some or all limit\ntypes, in any order.\n\nHere is an example showing how to set resource limits:\n\nGRANT USAGE ON *.* TO \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 0\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nUsers with the CONNECTION ADMIN privilege (in MariaDB 10.5.2 and later) or the\nSUPER privilege are not restricted by max_user_connections, max_connections,\nor max_password_errors.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can create a user account that requires these TLS options\nwith the following:\n\nGRANT USAGE ON *.* TO \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\'\n AND ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nRoles\n-----\n\nSyntax\n------\n\nGRANT role TO grantee [, grantee ... ]\n[ WITH ADMIN OPTION ]\n\ngrantee:\n  rolename\n  username [authentication_option]\n\nThe GRANT statement is also used to grant the use of a role to one or more\nusers or other roles. In order to be able to grant a role, the grantor doing\nso must have permission to do so (see WITH ADMIN in the CREATE ROLE article).\n\nSpecifying the WITH ADMIN OPTION permits the grantee to in turn grant the role\nto another.\n\nFor example, the following commands show how to grant the same role to a\ncouple different users.\n\nGRANT journalist TO hulda;\n\nGRANT journalist TO berengar WITH ADMIN OPTION;\n\nIf a user has been granted a role, they do not automatically obtain all\npermissions associated with that role. These permissions are only in use when\nthe user activates the role with the SET ROLE statement.\n\nTO PUBLIC\n---------\n\nMariaDB starting with 10.11\n---------------------------\n\nSyntax\n------\n\nGRANT <privilege> ON <database>.<object> TO PUBLIC;\nREVOKE <privilege> ON <database>.<object> FROM PUBLIC;\n\nGRANT ... TO PUBLIC grants privileges to all users with access to the server.\nThe privileges also apply to users created after the privileges are granted.\nThis can be useful when one only wants to state once that all users need to\nhave a certain set of privileges.\n\nWhen running SHOW GRANTS, a user will also see all privileges inherited from\nPUBLIC. SHOW GRANTS FOR PUBLIC will only show TO PUBLIC grants.\n\nGrant Examples\n--------------\n\nGranting Root-like Privileges\n-----------------------------\n\nYou can create a user that has privileges similar to the default root accounts\nby executing the following:\n\nCREATE USER \'alexander\'@\'localhost\';\nGRANT ALL PRIVILEGES ON  *.* to \'alexander\'@\'localhost\' WITH GRANT OPTION;\n\nURL: https://mariadb.com/kb/en/grant/','','https://mariadb.com/kb/en/grant/'),(117,'Authentication from MariaDB 10.4',10,'MariaDB starting with 10.4\n--------------------------\nMariaDB 10.4 introduced a number of changes to the authentication process,\nintended to make things easier and more intuitive.\n\nOverview\n--------\n\nThere are four new main features in 10.4 relating to authentication:\n\n* It is possible to use more than one authentication plugin for each user\naccount. For example, this can be useful to slowly migrate users to the more\nsecure ed25519 authentication plugin over time, while allowing the old\nmysql_native_password authentication plugin as an alternative for the\ntransitional period.\n* The root@localhost user account created by mysql_install_db is created with\nthe ability to use two authentication plugins.\nFirst, it is configured to try to use the unix_socket authentication plugin.\nThis allows the root@localhost user to login without a password via the local\nUnix socket file defined by the socket system variable, as long as the login\nis attempted from a process owned by the operating system root user account.\nSecond, if authentication fails with the unix_socket authentication plugin,\nthen it is configured to try to use the mysql_native_password authentication\nplugin. However, an invalid password is initially set, so in order to\nauthenticate this way, a password must be set with SET PASSWORD.\nHowever, just using the unix_socket authentication plugin may be fine for many\nusers, and it is very secure. You may want to try going without password\nauthentication to see how well it works for you. Remember, the best way to\nkeep your password safe is not to have one!\n\n* All user accounts, passwords, and global privileges are now stored in the\nmysql.global_priv table. The mysql.user table still exists and has exactly the\nsame set of columns as before, but it’s now a view that references the\nmysql.global_priv table. Tools that analyze the mysql.user table should\ncontinue to work as before. From MariaDB 10.4.13, the dedicated mariadb.sys\nuser is created as the definer of this view. Previously root was the definer,\nwhich resulted in privilege problems when this username was changed.\n* MariaDB 10.4 adds supports for User Password Expiry, which is not active by\ndefault.\n\nDescription\n-----------\n\nAs a result of the above changes, the open-for-everyone all-powerful root\naccount is finally gone. And installation scripts will no longer demand that\nyou \"PLEASE REMEMBER TO SET A PASSWORD FOR THE MariaDB root USER !\", because\nthe root account is securely created automatically.\n\nTwo all-powerful accounts are created by default — root and the OS user that\nowns the data directory, typically mysql. They are created as:\n\nCREATE USER root@localhost IDENTIFIED VIA unix_socket OR mysql_native_password\nUSING \'invalid\'\nCREATE USER mysql@localhost IDENTIFIED VIA unix_socket OR\nmysql_native_password USING \'invalid\'\n\nUsing unix_socket means that if you are the system root user, you can login as\nroot@locahost without a password. This technique was pioneered by Otto\nKekäläinen in Debian MariaDB packages and has been successfully used in Debian\nsince as early as MariaDB 10.0.\n\nIt is based on a simple fact that asking the system root for a password adds\nno extra security — root has full access to all the data files and all process\nmemory anyway. But not asking for a password means, there is no root password\nto forget (no need for the numerous tutorials on \"how to reset MariaDB root\npassword\"). And if you want to script some tedious database work, there is no\nneed to store the root password in plain text for the script to use (no need\nfor debian-sys-maint user).\n\nStill, some users may wish to log in as MariaDB root without using sudo. Hence\nthe old authentication method — conventional MariaDB password — is still\navailable. By default it is disabled (\"invalid\" is not a valid password hash),\nbut one can set the password with a usual SET PASSWORD statement. And still\nretain the password-less access via sudo.\n\nIf you install MariaDB locally (say from a tarball), you would not want to use\nsudo to be able to login. This is why MariaDB creates a second all-powerful\nuser with the same name as a system user that owns the data directory. In\nlocal (not system-wide) installations, this will be the user who installed\nMariaDB — they automatically get convenient password-less root-like access,\nbecause they can access all the data files anyway.\n\nEven if MariaDB is installed system-wide, you may not want to run your\ndatabase maintenance scripts as system root — now you can run them as system\nmysql user. And you will know that they will never destroy your entire system,\neven if you make a typo in a shell script.\n\nHowever, seasoned MariaDB DBAs who are used to the old ways do need to make\nsome changes. See the examples below for common tasks.\n\nCookbook\n--------\n\nAfter installing MariaDB system-wide the first thing you’ve got used to doing\nis logging in into the unprotected root account and protecting it, that is,\nsetting the root password:\n\n$ sudo dnf install MariaDB-server\n$ mysql -uroot\n...\nMariaDB> set password = password(\"XH4VmT3_jt\");\n\nThis is not only unnecessary now, it will simply not work — there is no\nunprotected root account. To login as root use\n\n$ sudo dnf install MariaDB-server\n$ sudo mysql\n\nNote that it implies you are connecting via the unix socket, not tcp. If you\nhappen to have protocol=tcp in a system-wide /etc/my.cnf file, use sudo mysql\n--protocol=socket.\n\nAfter installing MariaDB locally you’ve also used to connect to the\nunprotected root account using mysql -uroot. This will not work either, simply\nuse mysql without specifying a username.\n\nIf you\'ve forgotten your root password, no problem — you can still connect\nusing sudo and change the password. And if you\'ve also removed unix_socket\nauthentication, to restore access do as follows:\n\n* restart MariaDB with --skip-grant-tables\n* login into the unprotected server\n* run FLUSH PRIVILEGES (note, before 10.4 this would’ve been the last step,\nnot anymore). This disables --skip-grant-tables and allows you to change the\nstored authentication method\n* run SET PASSWORD FOR root@localhost to change the root password.\n\nTo view inside privilege tables, the old mysql.user table still exists. You\ncan select from it as before, although you cannot update it anymore. It\ndoesn’t show alternative authentication plugins and this was one of the\nreasons for switching to the mysql.global_priv table — complex authentication\nrules did not fit into rigid structure of a relational table. You can select\nfrom the new table, for example:\n\nselect concat(user, \'@\', host, \' => \', json_detailed(priv)) from\nmysql.global_priv;\n\nReverting to the Previous Authentication Method for root@localhost\n------------------------------------------------------------------\n\nIf you don\'t want the root@localhost user account created by mysql_install_db\nto use unix_socket authentication by default, then there are a few ways to\nrevert to the previous mysql_native_password authentication method for this\nuser account.\n\nConfiguring mysql_install_db to Revert to the Previous Authentication Method\n----------------------------------------------------------------------------\n\nOne way to revert to the previous mysql_native_password authentication method\nfor the root@localhost user account is to execute mysql_install_db with a\nspecial option. If mysql_install_db is executed while\n--auth-root-authentication-method=normal is specified, then it will create the\ndefault user accounts using the default behavior of MariaDB 10.3 and before.\n\nThis means that the root@localhost user account will use mysql_native_password\nauthentication by default. There are some other differences as well. See\nmysql_install_db: User Accounts Created by Default for more information.\n\nFor example, the option can be set on the command-line while running\nmysql_install_db:\n\nmysql_install_db --user=mysql --datadir=/var/lib/mysql\n--auth-root-authentication-method=normal\n\nThe option can also be set in an option file in an option group supported by\nmysql_install_db. For example:\n\n[mysql_install_db]\nauth_root_authentication_method=normal\n\nIf the option is set in an option file and if mysql_install_db is executed,\nthen mysql_install_db will read this option from the option file, and it will\nautomatically set this option.\n\nAltering the User Account to Revert to the Previous Authentication Method\n-------------------------------------------------------------------------\n\nIf you have already installed MariaDB, and if the root@localhost user account\nis already using unix_socket authentication, then you can revert to the old\nmysql_native_password authentication method for the user account by executing\nthe following:\n\nALTER USER root@localhost IDENTIFIED VIA mysql_native_password USING\nPASSWORD(\"verysecret\")\n\nURL: https://mariadb.com/kb/en/authentication-from-mariadb-104/','','https://mariadb.com/kb/en/authentication-from-mariadb-104/'),(119,'ST_X',11,'Syntax\n------\n\nST_X(p)\nX(p)\n\nDescription\n-----------\n\nReturns the X-coordinate value for the point p as a double-precision number.\n\nST_X() and X() are synonyms.\n\nExamples\n--------\n\nSET @pt = \'Point(56.7 53.34)\';\n\nSELECT X(GeomFromText(@pt));\n+----------------------+\n| X(GeomFromText(@pt)) |\n+----------------------+\n|                 56.7 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/st_x/','','https://mariadb.com/kb/en/st_x/'),(88,'IF Function',7,'Syntax\n------\n\nIF(expr1,expr2,expr3)\n\nDescription\n-----------\n\nIf expr1 is TRUE (expr1 <> 0 and expr1 <> NULL) then IF() returns expr2;\notherwise it returns expr3. IF() returns a numeric or string value, depending\non the context in which it is used.\n\nNote: There is also an IF statement which differs from the IF() function\ndescribed here.\n\nExamples\n--------\n\nSELECT IF(1>2,2,3);\n+-------------+\n| IF(1>2,2,3) |\n+-------------+\n|           3 |\n+-------------+\n\nSELECT IF(1<2,\'yes\',\'no\');\n+--------------------+\n| IF(1<2,\'yes\',\'no\') |\n+--------------------+\n| yes                |\n+--------------------+\n\nSELECT IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\');\n+---------------------------------------+\n| IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\') |\n+---------------------------------------+\n| no                                    |\n+---------------------------------------+\n\nURL: https://mariadb.com/kb/en/if-function/','','https://mariadb.com/kb/en/if-function/'),(89,'IFNULL',7,'Syntax\n------\n\nIFNULL(expr1,expr2)\nNVL(expr1,expr2)\n\nDescription\n-----------\n\nIf expr1 is not NULL, IFNULL() returns expr1; otherwise it returns expr2.\nIFNULL() returns a numeric or string value, depending on the context in which\nit is used.\n\nFrom MariaDB 10.3, NVL() is an alias for IFNULL().\n\nExamples\n--------\n\nSELECT IFNULL(1,0); \n+-------------+\n| IFNULL(1,0) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT IFNULL(NULL,10);\n+-----------------+\n| IFNULL(NULL,10) |\n+-----------------+\n|              10 |\n+-----------------+\n\nSELECT IFNULL(1/0,10);\n+----------------+\n| IFNULL(1/0,10) |\n+----------------+\n|        10.0000 |\n+----------------+\n\nSELECT IFNULL(1/0,\'yes\');\n+-------------------+\n| IFNULL(1/0,\'yes\') |\n+-------------------+\n| yes               |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/ifnull/','','https://mariadb.com/kb/en/ifnull/'),(94,'START TRANSACTION',8,'Syntax\n------\n\nSTART TRANSACTION [transaction_property [, transaction_property] ...] | BEGIN\n[WORK]\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nROLLBACK [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nSET autocommit = {0 | 1}\n\ntransaction_property:\n  WITH CONSISTENT SNAPSHOT\n | READ WRITE\n | READ ONLY\n\nDescription\n-----------\n\nThe START TRANSACTION or BEGIN statement begins a new transaction. COMMIT\ncommits the current transaction, making its changes permanent. ROLLBACK rolls\nback the current transaction, canceling its changes. The SET autocommit\nstatement disables or enables the default autocommit mode for the current\nsession.\n\nSTART TRANSACTION and SET autocommit = 1 implicitly commit the current\ntransaction, if any.\n\nThe optional WORK keyword is supported for COMMIT and ROLLBACK, as are the\nCHAIN and RELEASE clauses. CHAIN and RELEASE can be used for additional\ncontrol over transaction completion. The value of the completion_type system\nvariable determines the default completion behavior.\n\nThe AND CHAIN clause causes a new transaction to begin as soon as the current\none ends, and the new transaction has the same isolation level as the\njust-terminated transaction. The RELEASE clause causes the server to\ndisconnect the current client session after terminating the current\ntransaction. Including the NO keyword suppresses CHAIN or RELEASE completion,\nwhich can be useful if the completion_type system variable is set to cause\nchaining or release completion by default.\n\nAccess Mode\n-----------\n\nThe access mode specifies whether the transaction is allowed to write data or\nnot. By default, transactions are in READ WRITE mode (see the tx_read_only\nsystem variable). READ ONLY mode allows the storage engine to apply\noptimizations that cannot be used for transactions which write data. The only\nexception to this rule is that read only transactions can perform DDL\nstatements on temporary tables.\n\nIt is not permitted to specify both READ WRITE and READ ONLY in the same\nstatement.\n\nREAD WRITE and READ ONLY can also be specified in the SET TRANSACTION\nstatement, in which case the specified mode is valid for all sessions, or for\nall subsequent transaction used by the current session.\n\nautocommit\n----------\n\nBy default, MariaDB runs with autocommit mode enabled. This means that as soon\nas you execute a statement that updates (modifies) a table, MariaDB stores the\nupdate on disk to make it permanent. To disable autocommit mode, use the\nfollowing statement:\n\nSET autocommit=0;\n\nAfter disabling autocommit mode by setting the autocommit variable to zero,\nchanges to transaction-safe tables (such as those for InnoDB or NDBCLUSTER)\nare not made permanent immediately. You must use COMMIT to store your changes\nto disk or ROLLBACK to ignore the changes.\n\nTo disable autocommit mode for a single series of statements, use the START\nTRANSACTION statement.\n\nDDL Statements\n--------------\n\nDDL statements (CREATE, ALTER, DROP) and administrative statements (FLUSH,\nRESET, OPTIMIZE, ANALYZE, CHECK, REPAIR, CACHE INDEX), transaction management\nstatements (BEGIN, START TRANSACTION) and LOAD DATA INFILE, cause an implicit\nCOMMIT and start a new transaction. An exception to this rule are the DDL that\noperate on temporary tables: you can CREATE, ALTER and DROP them without\ncausing any COMMIT, but those actions cannot be rolled back. This means that\nif you call ROLLBACK, the temporary tables you created in the transaction will\nremain, while the rest of the transaction will be rolled back.\n\nTransactions cannot be used in Stored Functions or Triggers. In Stored\nProcedures and Events BEGIN is not allowed, so you should use START\nTRANSACTION instead.\n\nA transaction acquires a metadata lock on every table it accesses to prevent\nother connections from altering their structure. The lock is released at the\nend of the transaction. This happens even with non-transactional storage\nengines (like MEMORY or CONNECT), so it makes sense to use transactions with\nnon-transactional tables.\n\nin_transaction\n--------------\n\nThe in_transaction system variable is a session-only, read-only variable that\nreturns 1 inside a transaction, and 0 if not in a transaction.\n\nWITH CONSISTENT SNAPSHOT\n------------------------\n\nThe WITH CONSISTENT SNAPSHOT option starts a consistent read for storage\nengines such as InnoDB that can do so, the same as if a START TRANSACTION\nfollowed by a SELECT from any InnoDB table was issued.\n\nSee Enhancements for START TRANSACTION WITH CONSISTENT SNAPSHOT.\n\nExamples\n--------\n\nSTART TRANSACTION;\nSELECT @A:=SUM(salary) FROM table1 WHERE type=1;\nUPDATE table2 SET summary=@A WHERE type=1;\nCOMMIT;\n\nURL: https://mariadb.com/kb/en/start-transaction/','','https://mariadb.com/kb/en/start-transaction/'),(120,'ST_Y',11,'Syntax\n------\n\nST_Y(p)\nY(p)\n\nDescription\n-----------\n\nReturns the Y-coordinate value for the point p as a double-precision number.\n\nST_Y() and Y() are synonyms.\n\nExamples\n--------\n\nSET @pt = \'Point(56.7 53.34)\';\n\nSELECT Y(GeomFromText(@pt));\n+----------------------+\n| Y(GeomFromText(@pt)) |\n+----------------------+\n|                53.34 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/st_y/','','https://mariadb.com/kb/en/st_y/'),(121,'X',11,'A synonym for ST_X.\n\nURL: https://mariadb.com/kb/en/point-properties-x/','','https://mariadb.com/kb/en/point-properties-x/'),(122,'Y',11,'A synonym for ST_Y.\n\nURL: https://mariadb.com/kb/en/point-properties-y/','','https://mariadb.com/kb/en/point-properties-y/'),(125,'DECODE_ORACLE',12,'MariaDB starting with 10.3.2\n----------------------------\nDECODE_ORACLE is a synonym for the Oracle mode version of the DECODE function,\nand is available in all modes.\n\nURL: https://mariadb.com/kb/en/decode_oracle/','','https://mariadb.com/kb/en/decode_oracle/'),(93,'SET TRANSACTION',8,'Syntax\n------\n\nSET [GLOBAL | SESSION] TRANSACTION\n  transaction_property [, transaction_property] ...\n\ntransaction_property:\n  ISOLATION LEVEL level\n | READ WRITE\n | READ ONLY\n\nlevel:\n  REPEATABLE READ\n | READ COMMITTED\n | READ UNCOMMITTED\n | SERIALIZABLE\n\nDescription\n-----------\n\nThis statement sets the transaction isolation level or the transaction access\nmode globally, for the current session, or for the next transaction:\n\n* With the GLOBAL keyword, the statement sets the default\n transaction level globally for all subsequent sessions. Existing sessions are\n unaffected.\n* With the SESSION keyword, the statement sets the default\n transaction level for all subsequent transactions performed within the\n current session.\n* Without any SESSION or GLOBAL keyword,\n the statement sets the isolation level for the next (not started) transaction\n performed within the current session.\n\nA change to the global default isolation level requires the SUPER privilege.\nAny session is free to change its session isolation level (even in the middle\nof a transaction), or the isolation level for its next transaction.\n\nIsolation Level\n---------------\n\nTo set the global default isolation level at server startup, use the\n--transaction-isolation=level option on the command line or in an option file.\nValues of level for this option use dashes rather than spaces, so the\nallowable values are READ-UNCOMMITTED, READ-COMMITTED, REPEATABLE-READ, or\nSERIALIZABLE. For example, to set the default isolation level to REPEATABLE\nREAD, use these lines in the [mysqld] section of an option file:\n\n[mysqld]\ntransaction-isolation = REPEATABLE-READ\nTo determine the global and session transaction isolation levels at runtime,\ncheck the value of the tx_isolation system variable:\n\nSELECT @@GLOBAL.tx_isolation, @@tx_isolation;\n\nInnoDB supports each of the translation isolation levels described here using\ndifferent locking strategies. The default level is REPEATABLE READ. For\nadditional information about InnoDB record-level locks and how it uses them to\nexecute various types of statements, see InnoDB Lock Modes, and\nhttp://dev.mysql.com/doc/refman/en/innodb-locks-set.html.\n\nIsolation Levels\n----------------\n\nThe following sections describe how MariaDB supports the different transaction\nlevels.\n\nREAD UNCOMMITTED\n----------------\n\nSELECT statements are performed in a non-locking fashion, but a possible\nearlier version of a row might be used. Thus, using this isolation level, such\nreads are not consistent. This is also called a \"dirty read.\" Otherwise, this\nisolation level works like READ COMMITTED.\n\nREAD COMMITTED\n--------------\n\nA somewhat Oracle-like isolation level with respect to consistent\n(non-locking) reads: Each consistent read, even within the same transaction,\nsets and reads its own fresh snapshot. See\nhttp://dev.mysql.com/doc/refman/en/innodb-consistent-read.html.\n\nFor locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE), InnoDB locks\nonly index records, not the gaps before them, and thus allows the free\ninsertion of new records next to locked records. For UPDATE and DELETE\nstatements, locking depends on whether the statement uses a unique index with\na unique search condition (such as WHERE id = 100), or a range-type search\ncondition (such as WHERE id > 100). For a unique index with a unique search\ncondition, InnoDB locks only the index record found, not the gap before it.\nFor range-type searches, InnoDB locks the index range scanned, using gap locks\nor next-key (gap plus index-record) locks to block insertions by other\nsessions into the gaps covered by the range. This is necessary because\n\"phantom rows\" must be blocked for MySQL replication and recovery to work.\n\nNote: If the READ COMMITTED isolation level is used or the\ninnodb_locks_unsafe_for_binlog system variable is enabled, there is no InnoDB\ngap locking except for foreign-key constraint checking and duplicate-key\nchecking. Also, record locks for non-matching rows are released after MariaDB\nhas evaluated the WHERE condition.If you use READ COMMITTED or enable\ninnodb_locks_unsafe_for_binlog, you must use row-based binary logging.\n\nREPEATABLE READ\n---------------\n\nThis is the default isolation level for InnoDB. For consistent reads, there is\nan important difference from the READ COMMITTED isolation level: All\nconsistent reads within the same transaction read the snapshot established by\nthe first read. This convention means that if you issue several plain\n(non-locking) SELECT statements within the same transaction, these SELECT\nstatements are consistent also with respect to each other. See\nhttp://dev.mysql.com/doc/refman/en/innodb-consistent-read.html.\n\nFor locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE), UPDATE, and\nDELETE statements, locking depends on whether the statement uses a unique\nindex with a unique search condition, or a range-type search condition. For a\nunique index with a unique search condition, InnoDB locks only the index\nrecord found, not the gap before it. For other search conditions, InnoDB locks\nthe index range scanned, using gap locks or next-key (gap plus index-record)\nlocks to block insertions by other sessions into the gaps covered by the range.\n\nThis is the minimum isolation level for non-distributed XA transactions.\n\nSERIALIZABLE\n------------\n\nThis level is like REPEATABLE READ, but InnoDB implicitly converts all plain\nSELECT statements to SELECT ... LOCK IN SHARE MODE if autocommit is disabled.\nIf autocommit is enabled, the SELECT is its own transaction. It therefore is\nknown to be read only and can be serialized if performed as a consistent\n(non-locking) read and need not block for other transactions. (This means that\nto force a plain SELECT to block if other transactions have modified the\nselected rows, you should disable autocommit.)\n\nDistributed XA transactions should always use this isolation level.\n\nAccess Mode\n-----------\n\nThe access mode specifies whether the transaction is allowed to write data or\nnot. By default, transactions are in READ WRITE mode (see the tx_read_only\nsystem variable). READ ONLY mode allows the storage engine to apply\noptimizations that cannot be used for transactions which write data. The only\nexception to this rule is that read only transactions can perform DDL\nstatements on temporary tables.\n\nIt is not permitted to specify both READ WRITE and READ ONLY in the same\nstatement.\n\nREAD WRITE and READ ONLY can also be specified in the START TRANSACTION\nstatement, in which case the specified mode is only valid for one transaction.\n\nExamples\n--------\n\nSET GLOBAL TRANSACTION ISOLATION LEVEL SERIALIZABLE;\n\nAttempting to set the isolation level within an existing transaction without\nspecifying GLOBAL or SESSION.\n\nSTART TRANSACTION;\n\nSET TRANSACTION ISOLATION LEVEL SERIALIZABLE;\nERROR 1568 (25001): Transaction characteristics can\'t be changed while a\ntransaction is in progress\n\nURL: https://mariadb.com/kb/en/set-transaction/','','https://mariadb.com/kb/en/set-transaction/'),(126,'AES_DECRYPT',12,'Syntax\n------\n\nAES_DECRYPT(crypt_str,key_str)\n\nDescription\n-----------\n\nThis function allows decryption of data using the official AES (Advanced\nEncryption Standard) algorithm. For more information, see the description of\nAES_ENCRYPT().\n\nURL: https://mariadb.com/kb/en/aes_decrypt/','','https://mariadb.com/kb/en/aes_decrypt/'),(133,'MD5',12,'Syntax\n------\n\nMD5(str)\n\nDescription\n-----------\n\nCalculates an MD5 128-bit checksum for the string.\n\nThe return value is a 32-hex digit string, and as of MariaDB 5.5, is a\nnonbinary string in the connection character set and collation, determined by\nthe values of the character_set_connection and collation_connection system\nvariables. Before 5.5, the return value was a binary string.\n\nNULL is returned if the argument was NULL.\n\nExamples\n--------\n\nSELECT MD5(\'testing\');\n+----------------------------------+\n| MD5(\'testing\')                   |\n+----------------------------------+\n| ae2b1fca515949e5d54fb22b8ed95575 |\n+----------------------------------+\n\nURL: https://mariadb.com/kb/en/md5/','','https://mariadb.com/kb/en/md5/'),(95,'COMMIT',8,'The COMMIT statement ends a transaction, saving any changes to the data so\nthat they become visible to subsequent transactions. Also, unlocks metadata\nchanged by current transaction. If autocommit is set to 1, an implicit commit\nis performed after each statement. Otherwise, all transactions which don\'t end\nwith an explicit COMMIT are implicitly rollbacked and the changes are lost.\nThe ROLLBACK statement can be used to do this explicitly.\n\nThe required syntax for the COMMIT statement is as follows:\n\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\n\nCOMMIT is the more important transaction terminator, as well as the more\ninteresting one. The basic form of the COMMIT statement is simply the keyword\nCOMMIT (the keyword WORK is simply noise and can be omitted without changing\nthe effect).\n\nThe optional AND CHAIN clause is a convenience for initiating a new\ntransaction as soon as the old transaction terminates. If AND CHAIN is\nspecified, then there is effectively nothing between the old and new\ntransactions, although they remain separate. The characteristics of the new\ntransaction will be the same as the characteristics of the old one — that is,\nthe new transaction will have the same access mode, isolation level and\ndiagnostics area size (we\'ll discuss all of these shortly) as the transaction\njust terminated.\n\nRELEASE tells the server to disconnect the client immediately after the\ncurrent transaction.\n\nThere are NO RELEASE and AND NO CHAIN options. By default, commits do not\nRELEASE or CHAIN, but it\'s possible to change this default behavior with the\ncompletion_type server system variable. In this case, the AND NO CHAIN and NO\nRELEASE options override the server default.\n\nURL: https://mariadb.com/kb/en/commit/','','https://mariadb.com/kb/en/commit/'),(96,'ROLLBACK',8,'The ROLLBACK statement rolls back (ends) a transaction, destroying any changes\nto SQL-data so that they never become visible to subsequent transactions. The\nrequired syntax for the ROLLBACK statement is as follows.\n\nROLLBACK [ WORK ] [ AND [ NO ] CHAIN ] \n[ TO [ SAVEPOINT ] {<savepoint name> | <simple target specification>} ]\n\nThe ROLLBACK statement will either end a transaction, destroying all data\nchanges that happened during any of the transaction, or it will just destroy\nany data changes that happened since you established a savepoint. The basic\nform of the ROLLBACK statement is just the keyword ROLLBACK (the keyword WORK\nis simply noise and can be omitted without changing the effect).\n\nThe optional AND CHAIN clause is a convenience for initiating a new\ntransaction as soon as the old transaction terminates. If AND CHAIN is\nspecified, then there is effectively nothing between the old and new\ntransactions, although they remain separate. The characteristics of the new\ntransaction will be the same as the characteristics of the old one — that is,\nthe new transaction will have the same access mode, isolation level and\ndiagnostics area size (we\'ll discuss all of these shortly) as the transaction\njust terminated. The AND NO CHAIN option just tells your DBMS to end the\ntransaction — that is, these four SQL statements are equivalent:\n\nROLLBACK; \nROLLBACK WORK; \nROLLBACK AND NO CHAIN; \nROLLBACK WORK AND NO CHAIN;\n\nAll of them end a transaction without saving any transaction characteristics.\nThe only other options, the equivalent statements:\n\nROLLBACK AND CHAIN;\nROLLBACK WORK AND CHAIN;\n\nboth tell your DBMS to end a transaction, but to save that transaction\'s\ncharacteristics for the next transaction.\n\nROLLBACK is much simpler than COMMIT: it may involve no more than a few\ndeletions (of Cursors, locks, prepared SQL statements and log-file entries).\nIt\'s usually assumed that ROLLBACK can\'t fail, although such a thing is\nconceivable (for example, an encompassing transaction might reject an attempt\nto ROLLBACK because it\'s lining up for a COMMIT).\n\nROLLBACK cancels all effects of a transaction. It does not cancel effects on\nobjects outside the DBMS\'s control (for example the values in host program\nvariables or the settings made by some SQL/CLI function calls). But in\ngeneral, it is a convenient statement for those situations when you say \"oops,\nthis isn\'t working\" or when you simply don\'t care whether your temporary work\nbecomes permanent or not.\n\nHere is a moot question. If all you\'ve been doing is SELECTs, so that there\nhave been no data changes, should you end the transaction with ROLLBACK or\nCOMMIT? It shouldn\'t really matter because both ROLLBACK and COMMIT do the\nsame transaction-terminating job. However, the popular conception is that\nROLLBACK implies failure, so after a successful series of SELECT statements\nthe convention is to end the transaction with COMMIT rather than ROLLBACK.\n\nMariaDB (and most other DBMSs) supports rollback of SQL-data change\nstatements, but not of SQL-Schema statements. This means that if you use any\nof CREATE, ALTER, DROP, GRANT, REVOKE, you are implicitly committing at\nexecution time.\n\nINSERT INTO Table_2 VALUES(5); \nDROP TABLE Table_3 CASCADE; \nROLLBACK;\n\nThe result will be that both the INSERT and the DROP will go through as\nseparate transactions so the ROLLBACK will have no effect.\n\nURL: https://mariadb.com/kb/en/rollback/','','https://mariadb.com/kb/en/rollback/'),(138,'ENDPOINT',13,'A synonym for ST_ENDPOINT.\n\nURL: https://mariadb.com/kb/en/linestring-properties-endpoint/','','https://mariadb.com/kb/en/linestring-properties-endpoint/'),(139,'GLENGTH',13,'Syntax\n------\n\nGLength(ls)\n\nDescription\n-----------\n\nReturns as a double-precision number the length of the LineString value ls in\nits associated spatial reference.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT GLength(GeomFromText(@ls));\n+----------------------------+\n| GLength(GeomFromText(@ls)) |\n+----------------------------+\n|           2.82842712474619 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/glength/','','https://mariadb.com/kb/en/glength/'),(140,'NumPoints',13,'A synonym for ST_NumPoints.\n\nURL: https://mariadb.com/kb/en/linestring-properties-numpoints/','','https://mariadb.com/kb/en/linestring-properties-numpoints/'),(141,'PointN',13,'A synonym for ST_PointN.\n\nURL: https://mariadb.com/kb/en/linestring-properties-pointn/','','https://mariadb.com/kb/en/linestring-properties-pointn/'),(142,'STARTPOINT',13,'A synonym for ST_STARTPOINT.\n\nURL: https://mariadb.com/kb/en/linestring-properties-startpoint/','','https://mariadb.com/kb/en/linestring-properties-startpoint/'),(143,'ST_ENDPOINT',13,'Syntax\n------\n\nST_EndPoint(ls)\nEndPoint(ls)\n\nDescription\n-----------\n\nReturns the Point that is the endpoint of the LineString value ls.\n\nST_EndPoint() and EndPoint() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(EndPoint(GeomFromText(@ls)));\n+-------------------------------------+\n| AsText(EndPoint(GeomFromText(@ls))) |\n+-------------------------------------+\n| POINT(3 3)                          |\n+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_endpoint/','','https://mariadb.com/kb/en/st_endpoint/'),(144,'ST_NUMPOINTS',13,'Syntax\n------\n\nST_NumPoints(ls)\nNumPoints(ls)\n\nDescription\n-----------\n\nReturns the number of Point objects in the LineString value ls.\n\nST_NumPoints() and NumPoints() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\'