/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `barbican`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `barbican` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `barbican`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('8c74e2d7f1ff');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authorities`
--

DROP TABLE IF EXISTS `certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `plugin_ca_id` text NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cas_project_fk` (`project_id`),
  CONSTRAINT `cas_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authorities`
--

LOCK TABLES `certificate_authorities` WRITE;
/*!40000 ALTER TABLE `certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authority_metadata`
--

DROP TABLE IF EXISTS `certificate_authority_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authority_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_certificate_authority_metadatum_uc` (`ca_id`,`key`),
  KEY `ix_certificate_authority_metadata_ca_id` (`ca_id`),
  KEY `ix_certificate_authority_metadata_key` (`key`),
  CONSTRAINT `certificate_authority_metadata_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authority_metadata`
--

LOCK TABLES `certificate_authority_metadata` WRITE;
/*!40000 ALTER TABLE `certificate_authority_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authority_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acl_users`
--

DROP TABLE IF EXISTS `container_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_container_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `container_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `container_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acl_users`
--

LOCK TABLES `container_acl_users` WRITE;
/*!40000 ALTER TABLE `container_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acls`
--

DROP TABLE IF EXISTS `container_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_operation_uc` (`container_id`,`operation`),
  KEY `ix_container_acls_container_id` (`container_id`),
  CONSTRAINT `container_acls_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acls`
--

LOCK TABLES `container_acls` WRITE;
/*!40000 ALTER TABLE `container_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_consumer_metadata`
--

DROP TABLE IF EXISTS `container_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `name` varchar(36) DEFAULT NULL,
  `URL` varchar(255) DEFAULT NULL,
  `data_hash` char(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_consumer_hashed_container_name_url_uc` (`data_hash`),
  KEY `ix_container_consumer_metadata_container_id` (`container_id`),
  KEY `ix_container_consumer_metadata_project_id` (`project_id`),
  KEY `values_index` (`container_id`,`name`,`URL`),
  CONSTRAINT `container_consumer_metadata_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_consumer_metadata_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_consumer_metadata`
--

LOCK TABLES `container_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `container_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_secret`
--

DROP TABLE IF EXISTS `container_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_secret` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `container_id` varchar(36) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_secret_name_uc` (`container_id`,`secret_id`,`name`),
  KEY `ix_container_secret_container_id` (`container_id`),
  KEY `ix_container_secret_secret_id` (`secret_id`),
  CONSTRAINT `container_secret_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_secret_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_secret`
--

LOCK TABLES `container_secret` WRITE;
/*!40000 ALTER TABLE `container_secret` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `containers`
--

DROP TABLE IF EXISTS `containers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `containers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('generic','rsa','dsa','certificate') DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_containers_project_id` (`project_id`),
  CONSTRAINT `containers_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `containers`
--

LOCK TABLES `containers` WRITE;
/*!40000 ALTER TABLE `containers` DISABLE KEYS */;
/*!40000 ALTER TABLE `containers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encrypted_data`
--

DROP TABLE IF EXISTS `encrypted_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encrypted_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `secret_id` varchar(36) NOT NULL,
  `kek_id` varchar(36) NOT NULL,
  `cypher_text` text DEFAULT NULL,
  `kek_meta_extended` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_encrypted_data_kek_id` (`kek_id`),
  KEY `ix_encrypted_data_secret_id` (`secret_id`),
  CONSTRAINT `encrypted_data_ibfk_1` FOREIGN KEY (`kek_id`) REFERENCES `kek_data` (`id`),
  CONSTRAINT `encrypted_data_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encrypted_data`
--

LOCK TABLES `encrypted_data` WRITE;
/*!40000 ALTER TABLE `encrypted_data` DISABLE KEYS */;
INSERT INTO `encrypted_data` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `content_type`, `secret_id`, `kek_id`, `cypher_text`, `kek_meta_extended`) VALUES ('f25eed5c-a3fe-4fe2-9f2d-6d16604063cf','2025-10-02 13:10:27','2025-10-02 13:10:56','2025-10-02 13:10:56',1,'ACTIVE','application/octet-stream','459d2bd8-c04d-4362-8d85-9be2febad4ef','3161cfe9-02e6-482a-a257-a6e3e5dbe795','Z0FBQUFBQm8zbm5EaHJIeHZWYi0wMWhTclBCbWQtLWJ5MnBoMEpOaVlINXJmd2QtOURudWc3TXdSd3VNdi1lcDFKeHVHN1JPM1FiVVhXTFBNWW84OGh6NjJYaXJVb3lQbmxVR3NmS3NwcHpYZHNQOUc0di1QdGJMV0VsUGktVUFFaHZQcHZtZXQtUE4=',NULL),('f8de56b7-50f6-4743-bf42-9d85917a38a0','2025-10-02 12:38:43','2025-10-02 12:40:20','2025-10-02 12:40:20',1,'ACTIVE','application/octet-stream','aa21fc07-13f4-4816-a07d-936433201da9','461c4068-c92d-421d-a984-3826a92f0aa5','Z0FBQUFBQm8zbkpUY1JXWWZoNFIxTGdvOVdkUWdvRGIzcmdnQkFZQUludnpvNl8ySE52MEtPRmp3NGZ2Y2Z1M0Q0RGZvcWRTcDFuSEFWMXhwTS1lNllmeE9EVkJ3cXk5dnMxQTB4MEptVTJ2cHM5bVByb0pNbHgwVGlXWWRzUDl4Nm9MTzdrZlE3UnM=',NULL);
/*!40000 ALTER TABLE `encrypted_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kek_data`
--

DROP TABLE IF EXISTS `kek_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kek_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `kek_label` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `bind_completed` tinyint(1) NOT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `plugin_meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_kek_data_project_id` (`project_id`),
  CONSTRAINT `kek_data_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kek_data`
--

LOCK TABLES `kek_data` WRITE;
/*!40000 ALTER TABLE `kek_data` DISABLE KEYS */;
INSERT INTO `kek_data` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `plugin_name`, `kek_label`, `project_id`, `active`, `bind_completed`, `algorithm`, `bit_length`, `mode`, `plugin_meta`) VALUES ('3161cfe9-02e6-482a-a257-a6e3e5dbe795','2025-10-02 13:10:27','2025-10-02 13:16:28','2025-10-02 13:16:28',1,'ACTIVE','barbican.plugin.crypto.simple_crypto.SimpleCryptoPlugin','project-fbbc6cb494464fd9b31f64c1ad75fa6b-key-01e5c7f7-922c-4ecf-9267-7cc87d2a9e9c','7814b161-8bb1-4fa6-8f53-ffe81ace452e',1,1,'aes',128,'cbc','gAAAAABo3nnD5TQCS3vSpVNO4hPXAVDQ6G4MbUWa9uDACHrNNPHyoH8DfCxARGiZy-z7Eu8UI_BKJCb3tL0POkfOHSqf6_jPVe3bQ4kGNnI_2NA2WXferDoA9H-B7hK48c_hjnPWmM34'),('461c4068-c92d-421d-a984-3826a92f0aa5','2025-10-02 12:38:43','2025-10-02 12:40:50','2025-10-02 12:40:50',1,'ACTIVE','barbican.plugin.crypto.simple_crypto.SimpleCryptoPlugin','project-1294b2ea04b34f7189fde66e2afa2c56-key-92b884a0-15d6-45ba-a825-a8354b80b159','e0b671d3-1198-49dd-aa4c-83bd9d34a295',1,1,'aes',128,'cbc','gAAAAABo3nJTbcsh9bA4oPUecU5l9cwCwTJ4iQUtNMpBtI1HYV25Jzhcpgqj6HAQrGHC8wbA2FNXvKWmyMdZm_bHWvklf8CjXp8LqfGYjqMM1fgEkwjYc1JdQO4foYYvVDBOMHK6HCAP');
/*!40000 ALTER TABLE `kek_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_barbican_metadata`
--

DROP TABLE IF EXISTS `order_barbican_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_barbican_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_barbican_metadata_order_id` (`order_id`),
  CONSTRAINT `order_barbican_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_barbican_metadata`
--

LOCK TABLES `order_barbican_metadata` WRITE;
/*!40000 ALTER TABLE `order_barbican_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_barbican_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_plugin_metadata`
--

DROP TABLE IF EXISTS `order_plugin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_plugin_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_plugin_metadata_order_id` (`order_id`),
  CONSTRAINT `order_plugin_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_plugin_metadata`
--

LOCK TABLES `order_plugin_metadata` WRITE;
/*!40000 ALTER TABLE `order_plugin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_plugin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_retry_tasks`
--

DROP TABLE IF EXISTS `order_retry_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_retry_tasks` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `id` varchar(36) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `retry_task` text NOT NULL,
  `retry_at` datetime NOT NULL,
  `retry_args` text NOT NULL,
  `retry_kwargs` text NOT NULL,
  `retry_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_retry_tasks_order_id` (`order_id`),
  CONSTRAINT `order_retry_tasks_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_retry_tasks`
--

LOCK TABLES `order_retry_tasks` WRITE;
/*!40000 ALTER TABLE `order_retry_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_retry_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `error_status_code` varchar(16) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  `secret_id` varchar(36) DEFAULT NULL,
  `container_id` varchar(36) DEFAULT NULL,
  `sub_status` varchar(36) DEFAULT NULL,
  `sub_status_message` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_orders_container_id` (`container_id`),
  KEY `ix_orders_project_id` (`project_id`),
  KEY `ix_orders_secret_id` (`secret_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`),
  CONSTRAINT `orders_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
INSERT INTO `orders` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `type`, `project_id`, `error_status_code`, `error_reason`, `meta`, `secret_id`, `container_id`, `sub_status`, `sub_status_message`, `creator_id`) VALUES ('09c51ac1-ad67-4388-a880-5aebe6c96dec','2025-10-02 12:38:42','2025-10-02 12:38:43',NULL,0,'ACTIVE','key','e0b671d3-1198-49dd-aa4c-83bd9d34a295',NULL,NULL,'{\"algorithm\": \"aes\", \"bit_length\": 256, \"name\": null, \"expiration\": null}','aa21fc07-13f4-4816-a07d-936433201da9',NULL,'Unknown','Unknown','b4ad22acfd744e47aa9bb09035188e74'),('f99a8b63-1012-42c2-9290-6e94e3ef4a78','2025-10-02 13:10:27','2025-10-02 13:10:27',NULL,0,'ACTIVE','key','7814b161-8bb1-4fa6-8f53-ffe81ace452e',NULL,NULL,'{\"algorithm\": \"aes\", \"bit_length\": 256, \"name\": null, \"expiration\": null}','459d2bd8-c04d-4362-8d85-9be2febad4ef',NULL,'Unknown','Unknown','c10de71fef00497981b8b7cec6a3fff3');
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preferred_certificate_authorities`
--

DROP TABLE IF EXISTS `preferred_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `preferred_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_preferred_certificate_authorities_project_id` (`project_id`),
  KEY `ix_preferred_certificate_authorities_ca_id` (`ca_id`),
  CONSTRAINT `preferred_certificate_authorities_fk` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `preferred_certificate_authorities_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preferred_certificate_authorities`
--

LOCK TABLES `preferred_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `preferred_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `preferred_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_certificate_authorities`
--

DROP TABLE IF EXISTS `project_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_certificate_authority_uc` (`project_id`,`ca_id`),
  KEY `ix_project_certificate_authorities_ca_id` (`ca_id`),
  KEY `ix_project_certificate_authorities_project_id` (`project_id`),
  CONSTRAINT `project_certificate_authorities_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `project_certificate_authorities_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_certificate_authorities`
--

LOCK TABLES `project_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `project_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_quotas`
--

DROP TABLE IF EXISTS `project_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_quotas` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `secrets` int(11) DEFAULT NULL,
  `orders` int(11) DEFAULT NULL,
  `containers` int(11) DEFAULT NULL,
  `consumers` int(11) DEFAULT NULL,
  `cas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_project_quotas_project_id` (`project_id`),
  CONSTRAINT `project_quotas_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_quotas`
--

LOCK TABLES `project_quotas` WRITE;
/*!40000 ALTER TABLE `project_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_secret_store`
--

DROP TABLE IF EXISTS `project_secret_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_secret_store` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_store_id` varchar(36) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_secret_store_project_uc` (`project_id`),
  KEY `ix_project_secret_store_project_id` (`project_id`),
  KEY `ix_project_secret_store_secret_store_id` (`secret_store_id`),
  CONSTRAINT `project_secret_store_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `project_secret_store_ibfk_2` FOREIGN KEY (`secret_store_id`) REFERENCES `secret_stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_secret_store`
--

LOCK TABLES `project_secret_store` WRITE;
/*!40000 ALTER TABLE `project_secret_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_secret_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `external_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
INSERT INTO `projects` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `external_id`) VALUES ('7814b161-8bb1-4fa6-8f53-ffe81ace452e','2025-10-02 13:10:27','2025-10-02 13:16:28','2025-10-02 13:16:28',1,'ACTIVE','fbbc6cb494464fd9b31f64c1ad75fa6b'),('e0b671d3-1198-49dd-aa4c-83bd9d34a295','2025-10-02 12:38:42','2025-10-02 12:40:50','2025-10-02 12:40:50',1,'ACTIVE','1294b2ea04b34f7189fde66e2afa2c56');
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acl_users`
--

DROP TABLE IF EXISTS `secret_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_secret_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `secret_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `secret_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acl_users`
--

LOCK TABLES `secret_acl_users` WRITE;
/*!40000 ALTER TABLE `secret_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acls`
--

DROP TABLE IF EXISTS `secret_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_operation_uc` (`secret_id`,`operation`),
  KEY `ix_secret_acls_secret_id` (`secret_id`),
  CONSTRAINT `secret_acls_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acls`
--

LOCK TABLES `secret_acls` WRITE;
/*!40000 ALTER TABLE `secret_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_consumer_metadata`
--

DROP TABLE IF EXISTS `secret_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `service` varchar(255) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_consumer_resource_uc` (`secret_id`,`service`,`resource_type`,`resource_id`),
  KEY `ix_secret_consumer_metadata_resource_id` (`resource_id`),
  KEY `ix_secret_consumer_metadata_secret_id` (`secret_id`),
  KEY `ix_secret_consumer_metadata_project_id` (`project_id`),
  CONSTRAINT `fk_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `secret_consumer_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_consumer_metadata`
--

LOCK TABLES `secret_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `secret_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_store_metadata`
--

DROP TABLE IF EXISTS `secret_store_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_store_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secret_store_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_store_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_store_metadata`
--

LOCK TABLES `secret_store_metadata` WRITE;
/*!40000 ALTER TABLE `secret_store_metadata` DISABLE KEYS */;
INSERT INTO `secret_store_metadata` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `key`, `value`, `secret_id`) VALUES ('6f1a7094-64ef-4fe1-ac67-73872eeba6be','2025-10-02 13:10:27','2025-10-02 13:10:56','2025-10-02 13:10:56',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','459d2bd8-c04d-4362-8d85-9be2febad4ef'),('87826e63-0c68-4672-8bb5-aed13a82daa8','2025-10-02 12:38:43','2025-10-02 12:40:20','2025-10-02 12:40:20',1,'PENDING','content_type','application/octet-stream','aa21fc07-13f4-4816-a07d-936433201da9'),('8cf0cee4-8c8d-489a-88e2-98f86288c6df','2025-10-02 13:10:27','2025-10-02 13:10:56','2025-10-02 13:10:56',1,'PENDING','content_type','application/octet-stream','459d2bd8-c04d-4362-8d85-9be2febad4ef'),('bc175e42-f69b-4b0b-8c41-f0f62ceb621b','2025-10-02 12:38:43','2025-10-02 12:40:20','2025-10-02 12:40:20',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','aa21fc07-13f4-4816-a07d-936433201da9');
/*!40000 ALTER TABLE `secret_store_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_stores`
--

DROP TABLE IF EXISTS `secret_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_stores` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `store_plugin` varchar(255) NOT NULL,
  `crypto_plugin` varchar(255) DEFAULT NULL,
  `global_default` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_stores_name_uc` (`name`),
  UNIQUE KEY `_secret_stores_plugin_names_uc` (`store_plugin`,`crypto_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_stores`
--

LOCK TABLES `secret_stores` WRITE;
/*!40000 ALTER TABLE `secret_stores` DISABLE KEYS */;
INSERT INTO `secret_stores` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `store_plugin`, `crypto_plugin`, `global_default`, `name`) VALUES ('8e4eb16c-a320-4fb4-91b2-bbe583142261','2025-10-02 11:12:48','2025-10-02 11:12:48',NULL,0,'ACTIVE','store_crypto','simple_crypto',1,'Software Only Crypto');
/*!40000 ALTER TABLE `secret_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_user_metadata`
--

DROP TABLE IF EXISTS `secret_user_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_user_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_key_uc` (`secret_id`,`key`),
  KEY `ix_secret_user_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_user_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_user_metadata`
--

LOCK TABLES `secret_user_metadata` WRITE;
/*!40000 ALTER TABLE `secret_user_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_user_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secrets`
--

DROP TABLE IF EXISTS `secrets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secrets` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `secret_type` varchar(255) DEFAULT 'opaque',
  `expiration` datetime DEFAULT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secrets_project_id` (`project_id`),
  CONSTRAINT `secrets_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secrets`
--

LOCK TABLES `secrets` WRITE;
/*!40000 ALTER TABLE `secrets` DISABLE KEYS */;
INSERT INTO `secrets` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `name`, `secret_type`, `expiration`, `algorithm`, `bit_length`, `mode`, `creator_id`, `project_id`) VALUES ('459d2bd8-c04d-4362-8d85-9be2febad4ef','2025-10-02 13:10:27','2025-10-02 13:10:56','2025-10-02 13:10:56',1,'ACTIVE',NULL,'symmetric',NULL,'aes',256,NULL,'c10de71fef00497981b8b7cec6a3fff3','7814b161-8bb1-4fa6-8f53-ffe81ace452e'),('aa21fc07-13f4-4816-a07d-936433201da9','2025-10-02 12:38:43','2025-10-02 12:40:20','2025-10-02 12:40:20',1,'ACTIVE',NULL,'symmetric',NULL,'aes',256,NULL,'b4ad22acfd744e47aa9bb09035188e74','e0b671d3-1198-49dd-aa4c-83bd9d34a295');
/*!40000 ALTER TABLE `secrets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_keys`
--

DROP TABLE IF EXISTS `transport_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transport_keys` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `transport_key` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_keys`
--

LOCK TABLES `transport_keys` WRITE;
/*!40000 ALTER TABLE `transport_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `cinder`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `cinder` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `cinder`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('daa98075b90d');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment_specs`
--

DROP TABLE IF EXISTS `attachment_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_attachment_specs_attachment_id` (`attachment_id`),
  CONSTRAINT `attachment_specs_ibfk_1` FOREIGN KEY (`attachment_id`) REFERENCES `volume_attachment` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment_specs`
--

LOCK TABLES `attachment_specs` WRITE;
/*!40000 ALTER TABLE `attachment_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_metadata`
--

DROP TABLE IF EXISTS `backup_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_backup_metadata_backup_id` (`backup_id`),
  CONSTRAINT `backup_metadata_ibfk_1` FOREIGN KEY (`backup_id`) REFERENCES `backups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_metadata`
--

LOCK TABLES `backup_metadata` WRITE;
/*!40000 ALTER TABLE `backup_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `container` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fail_reason` varchar(255) DEFAULT NULL,
  `service_metadata` varchar(255) DEFAULT NULL,
  `service` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `object_count` int(11) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `temp_volume_id` varchar(36) DEFAULT NULL,
  `temp_snapshot_id` varchar(36) DEFAULT NULL,
  `num_dependent_backups` int(11) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `data_timestamp` datetime DEFAULT NULL,
  `restore_volume_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
INSERT INTO `backups` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `host`, `availability_zone`, `display_name`, `display_description`, `container`, `status`, `fail_reason`, `service_metadata`, `service`, `size`, `object_count`, `parent_id`, `temp_volume_id`, `temp_snapshot_id`, `num_dependent_backups`, `snapshot_id`, `data_timestamp`, `restore_volume_id`, `encryption_key_id`) VALUES ('2025-10-02 12:58:58','2025-10-02 12:59:56','2025-10-02 12:59:57',1,'c0eef30e-5124-4246-917c-84b3935f5a6a','35b34865-0391-4a63-933b-ea3e47885a2c','729669e8835d4d95b5aae25c140e1f06','55e97477dd13448d9dafe69ec8614ea6','cinder-backup-0',NULL,'tempest-TestVolumeBackupRestore-backup-563244519',NULL,'backups','deleted',NULL,'{\"base\": \"volume-35b34865-0391-4a63-933b-ea3e47885a2c.backup.c0eef30e-5124-4246-917c-84b3935f5a6a\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:58:58','bf6c6619-4739-4799-81d0-3fa07140ece6',NULL);
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cgsnapshots`
--

DROP TABLE IF EXISTS `cgsnapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cgsnapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `consistencygroup_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_cgsnapshots_consistencygroup_id` (`consistencygroup_id`),
  CONSTRAINT `cgsnapshots_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cgsnapshots`
--

LOCK TABLES `cgsnapshots` WRITE;
/*!40000 ALTER TABLE `cgsnapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `cgsnapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clusters`
--

DROP TABLE IF EXISTS `clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clusters` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`binary`,`race_preventer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clusters`
--

LOCK TABLES `clusters` WRITE;
/*!40000 ALTER TABLE `clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consistencygroups`
--

DROP TABLE IF EXISTS `consistencygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consistencygroups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `volume_type_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `source_cgid` varchar(36) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consistencygroups`
--

LOCK TABLES `consistencygroups` WRITE;
/*!40000 ALTER TABLE `consistencygroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `consistencygroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_volume_types`
--

DROP TABLE IF EXISTS `default_volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `default_volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  KEY `ix_default_volume_types_volume_type_id` (`volume_type_id`),
  CONSTRAINT `default_volume_types_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_volume_types`
--

LOCK TABLES `default_volume_types` WRITE;
/*!40000 ALTER TABLE `default_volume_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver_initiator_data`
--

DROP TABLE IF EXISTS `driver_initiator_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `driver_initiator_data` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `initiator` (`initiator`,`namespace`,`key`),
  KEY `ix_driver_initiator_data_initiator` (`initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver_initiator_data`
--

LOCK TABLES `driver_initiator_data` WRITE;
/*!40000 ALTER TABLE `driver_initiator_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `driver_initiator_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encryption`
--

DROP TABLE IF EXISTS `encryption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encryption` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `cipher` varchar(255) DEFAULT NULL,
  `control_location` varchar(255) NOT NULL,
  `key_size` int(11) DEFAULT NULL,
  `provider` varchar(255) NOT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `encryption_id` varchar(36) NOT NULL,
  PRIMARY KEY (`encryption_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encryption`
--

LOCK TABLES `encryption` WRITE;
/*!40000 ALTER TABLE `encryption` DISABLE KEYS */;
INSERT INTO `encryption` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `cipher`, `control_location`, `key_size`, `provider`, `volume_type_id`, `encryption_id`) VALUES ('2025-10-02 13:10:26',NULL,'2025-10-02 13:10:57',1,'aes-xts-plain64','front-end',256,'luks','0229108f-33fe-42b1-b447-db3615f2ec2a','a4b2e85a-f657-44ce-8fc2-6d3a416a4ba3'),('2025-10-02 12:38:42',NULL,'2025-10-02 12:40:36',1,'aes-xts-plain64','front-end',256,'luks','35f14daf-50bb-41b7-acfb-4118f96074f3','ab969e52-1d11-443a-a6ad-ae317ed5248b');
/*!40000 ALTER TABLE `encryption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_snapshots`
--

DROP TABLE IF EXISTS `group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_snapshots_group_id` (`group_id`),
  KEY `group_snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `group_snapshots_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_snapshots`
--

LOCK TABLES `group_snapshots` WRITE;
/*!40000 ALTER TABLE `group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_projects`
--

DROP TABLE IF EXISTS `group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_type_id` (`group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `group_type_projects_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_projects`
--

LOCK TABLES `group_type_projects` WRITE;
/*!40000 ALTER TABLE `group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_specs`
--

DROP TABLE IF EXISTS `group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_type_specs_group_type_id` (`group_type_id`),
  CONSTRAINT `group_type_specs_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_specs`
--

LOCK TABLES `group_type_specs` WRITE;
/*!40000 ALTER TABLE `group_type_specs` DISABLE KEYS */;
INSERT INTO `group_type_specs` (`id`, `key`, `value`, `group_type_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'consistent_group_snapshot_enabled','<is> True','a57c05df-ba14-4aae-affc-ec3d3a10dda7','2025-10-02 11:13:20','2025-10-02 11:13:20',NULL,0);
/*!40000 ALTER TABLE `group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_types`
--

DROP TABLE IF EXISTS `group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_types` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_types`
--

LOCK TABLES `group_types` WRITE;
/*!40000 ALTER TABLE `group_types` DISABLE KEYS */;
INSERT INTO `group_types` (`id`, `name`, `description`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `is_public`) VALUES ('a57c05df-ba14-4aae-affc-ec3d3a10dda7','default_cgsnapshot_type','Default group type for migrating cgsnapshot','2025-10-02 11:13:20','2025-10-02 11:13:20',NULL,0,1);
/*!40000 ALTER TABLE `group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_volume_type_mapping`
--

DROP TABLE IF EXISTS `group_volume_type_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_volume_type_mapping` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_volume_type_mapping_group_id` (`group_id`),
  KEY `ix_group_volume_type_mapping_volume_type_id` (`volume_type_id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_volume_type_mapping`
--

LOCK TABLES `group_volume_type_mapping` WRITE;
/*!40000 ALTER TABLE `group_volume_type_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_volume_type_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `groups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `source_group_id` varchar(36) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groups_deleted_project_id_idx` (`deleted`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_volume_cache_entries`
--

DROP TABLE IF EXISTS `image_volume_cache_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_volume_cache_entries` (
  `image_updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `image_id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `size` int(11) NOT NULL,
  `last_used` datetime NOT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_volume_cache_entries_host` (`host`),
  KEY `ix_image_volume_cache_entries_image_id` (`image_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_volume_cache_entries`
--

LOCK TABLES `image_volume_cache_entries` WRITE;
/*!40000 ALTER TABLE `image_volume_cache_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_volume_cache_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(36) DEFAULT NULL,
  `resource_uuid` varchar(255) DEFAULT NULL,
  `event_id` varchar(255) NOT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `action_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_messages_expires_at` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quality_of_service_specs`
--

DROP TABLE IF EXISTS `quality_of_service_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quality_of_service_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `specs_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quality_of_service_specs_specs_id` (`specs_id`),
  CONSTRAINT `quality_of_service_specs_ibfk_1` FOREIGN KEY (`specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quality_of_service_specs`
--

LOCK TABLES `quality_of_service_specs` WRITE;
/*!40000 ALTER TABLE `quality_of_service_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `quality_of_service_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
INSERT INTO `quota_classes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `class_name`, `resource`, `hard_limit`) VALUES ('2025-10-02 11:12:42',NULL,NULL,0,1,'default','volumes',10),('2025-10-02 11:12:42',NULL,NULL,0,2,'default','snapshots',10),('2025-10-02 11:12:42',NULL,NULL,0,3,'default','gigabytes',1000),('2025-10-02 11:12:42',NULL,NULL,0,4,'default','consistencygroups',10),('2025-10-02 11:12:42',NULL,NULL,0,5,'default','per_volume_gigabytes',-1),('2025-10-02 11:12:42',NULL,NULL,0,6,'default','groups',10);
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(300) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `race_preventer` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`,`race_preventer`),
  KEY `quota_usage_project_resource_idx` (`project_id`,`resource`),
  KEY `ix_quota_usages_project_id` (`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=147 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
INSERT INTO `quota_usages` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `project_id`, `resource`, `in_use`, `reserved`, `until_refresh`, `race_preventer`) VALUES ('2025-10-02 11:58:42','2025-10-02 11:59:50',NULL,0,1,'9fab310b79144b0baa3a349f8bb4143f','volumes',0,0,NULL,1),('2025-10-02 11:58:42','2025-10-02 11:59:50',NULL,0,2,'9fab310b79144b0baa3a349f8bb4143f','gigabytes',0,0,NULL,1),('2025-10-02 11:58:42','2025-10-02 11:59:50',NULL,0,3,'9fab310b79144b0baa3a349f8bb4143f','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 11:58:42','2025-10-02 11:59:50',NULL,0,4,'9fab310b79144b0baa3a349f8bb4143f','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:00:09','2025-10-02 12:01:49',NULL,0,5,'d977ad6a90874946819537242925a8f0','volumes',0,0,NULL,1),('2025-10-02 12:00:09','2025-10-02 12:01:49',NULL,0,6,'d977ad6a90874946819537242925a8f0','gigabytes',0,0,NULL,1),('2025-10-02 12:00:09','2025-10-02 12:01:49',NULL,0,7,'d977ad6a90874946819537242925a8f0','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:00:09','2025-10-02 12:01:49',NULL,0,8,'d977ad6a90874946819537242925a8f0','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:02:12','2025-10-02 12:03:21',NULL,0,9,'3f2b3ac7d7504c9c96f0d4a67e0243c9','volumes',0,0,NULL,1),('2025-10-02 12:02:12','2025-10-02 12:03:21',NULL,0,10,'3f2b3ac7d7504c9c96f0d4a67e0243c9','gigabytes',0,0,NULL,1),('2025-10-02 12:02:12','2025-10-02 12:03:21',NULL,0,11,'3f2b3ac7d7504c9c96f0d4a67e0243c9','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:02:12','2025-10-02 12:03:21',NULL,0,12,'3f2b3ac7d7504c9c96f0d4a67e0243c9','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:06:14','2025-10-02 12:08:22',NULL,0,13,'7359a7dad3b849bfbf075b88f2a261b4','volumes',0,0,NULL,1),('2025-10-02 12:06:14','2025-10-02 12:08:22',NULL,0,14,'7359a7dad3b849bfbf075b88f2a261b4','gigabytes',0,0,NULL,1),('2025-10-02 12:06:14','2025-10-02 12:08:22',NULL,0,15,'7359a7dad3b849bfbf075b88f2a261b4','volumes_multiattach',0,0,NULL,1),('2025-10-02 12:06:14','2025-10-02 12:08:22',NULL,0,16,'7359a7dad3b849bfbf075b88f2a261b4','gigabytes_multiattach',0,0,NULL,1),('2025-10-02 12:08:06','2025-10-02 12:08:27',NULL,0,17,'861ae6a71574411fbcdab09902e6bcc4','volumes',0,0,NULL,1),('2025-10-02 12:08:06','2025-10-02 12:08:27',NULL,0,18,'861ae6a71574411fbcdab09902e6bcc4','gigabytes',0,0,NULL,1),('2025-10-02 12:08:06','2025-10-02 12:08:27',NULL,0,19,'861ae6a71574411fbcdab09902e6bcc4','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:08:06','2025-10-02 12:08:27',NULL,0,20,'861ae6a71574411fbcdab09902e6bcc4','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:09:39','2025-10-02 12:10:21',NULL,0,21,'95056cabad5b4f32916e46a46b10f677','volumes',0,0,NULL,1),('2025-10-02 12:09:39','2025-10-02 12:10:21',NULL,0,22,'95056cabad5b4f32916e46a46b10f677','gigabytes',0,0,NULL,1),('2025-10-02 12:09:39','2025-10-02 12:10:21',NULL,0,23,'95056cabad5b4f32916e46a46b10f677','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:09:39','2025-10-02 12:10:21',NULL,0,24,'95056cabad5b4f32916e46a46b10f677','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:15:59','2025-10-02 12:18:28',NULL,0,25,'a9d3eca266284ae9950c491e566b2523','volumes',0,0,NULL,1),('2025-10-02 12:15:59','2025-10-02 12:18:28',NULL,0,26,'a9d3eca266284ae9950c491e566b2523','gigabytes',0,0,NULL,1),('2025-10-02 12:15:59','2025-10-02 12:18:28',NULL,0,27,'a9d3eca266284ae9950c491e566b2523','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:15:59','2025-10-02 12:18:28',NULL,0,28,'a9d3eca266284ae9950c491e566b2523','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:17:13','2025-10-02 12:19:17',NULL,0,29,'8efba404696b40fbbaa6431b934b87f1','volumes',2,0,NULL,1),('2025-10-02 12:17:13','2025-10-02 12:19:17',NULL,0,30,'8efba404696b40fbbaa6431b934b87f1','gigabytes',2,0,NULL,1),('2025-10-02 12:17:13','2025-10-02 12:19:17',NULL,0,31,'8efba404696b40fbbaa6431b934b87f1','volumes___DEFAULT__',2,0,NULL,1),('2025-10-02 12:17:13','2025-10-02 12:19:17',NULL,0,32,'8efba404696b40fbbaa6431b934b87f1','gigabytes___DEFAULT__',2,0,NULL,1),('2025-10-02 12:18:25','2025-10-02 12:19:40',NULL,0,33,'a07342ec339549a4b091ddbcfedae271','volumes',0,0,NULL,1),('2025-10-02 12:18:25','2025-10-02 12:19:40',NULL,0,34,'a07342ec339549a4b091ddbcfedae271','gigabytes',0,0,NULL,1),('2025-10-02 12:18:25','2025-10-02 12:19:40',NULL,0,35,'a07342ec339549a4b091ddbcfedae271','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:18:25','2025-10-02 12:19:40',NULL,0,36,'a07342ec339549a4b091ddbcfedae271','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:19:26','2025-10-02 12:21:46',NULL,0,37,'84f71f6076f7425db7653ac203257df0','volumes',0,0,NULL,1),('2025-10-02 12:19:26','2025-10-02 12:21:46',NULL,0,38,'84f71f6076f7425db7653ac203257df0','gigabytes',0,0,NULL,1),('2025-10-02 12:19:26','2025-10-02 12:21:46',NULL,0,39,'84f71f6076f7425db7653ac203257df0','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:19:26','2025-10-02 12:21:46',NULL,0,40,'84f71f6076f7425db7653ac203257df0','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:20:36','2025-10-02 12:24:14',NULL,0,41,'1c2c11ebecb14f3188f35ea473c4ca02','volumes',0,0,NULL,1),('2025-10-02 12:20:36','2025-10-02 12:24:14',NULL,0,42,'1c2c11ebecb14f3188f35ea473c4ca02','gigabytes',0,0,NULL,1),('2025-10-02 12:20:36','2025-10-02 12:24:15',NULL,0,43,'1c2c11ebecb14f3188f35ea473c4ca02','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:20:36','2025-10-02 12:24:15',NULL,0,44,'1c2c11ebecb14f3188f35ea473c4ca02','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:22:27','2025-10-02 12:24:28',NULL,0,45,'c740a14d1c5c45d1a0959b0e24ac460b','volumes',0,0,NULL,1),('2025-10-02 12:22:27','2025-10-02 12:24:28',NULL,0,46,'c740a14d1c5c45d1a0959b0e24ac460b','gigabytes',0,0,NULL,1),('2025-10-02 12:22:27','2025-10-02 12:24:28',NULL,0,47,'c740a14d1c5c45d1a0959b0e24ac460b','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:22:27','2025-10-02 12:24:28',NULL,0,48,'c740a14d1c5c45d1a0959b0e24ac460b','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:23:02','2025-10-02 12:26:27',NULL,0,49,'10fff81da7a54740a53a0771ce916329','volumes',0,0,NULL,1),('2025-10-02 12:23:02','2025-10-02 12:26:27',NULL,0,50,'10fff81da7a54740a53a0771ce916329','gigabytes',0,0,NULL,1),('2025-10-02 12:23:02','2025-10-02 12:26:27',NULL,0,51,'10fff81da7a54740a53a0771ce916329','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:23:02','2025-10-02 12:26:27',NULL,0,52,'10fff81da7a54740a53a0771ce916329','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:24:42','2025-10-02 12:26:17',NULL,0,53,'d5bedc1d8125465b92c98f9ebeb80ddb','volumes',0,0,NULL,1),('2025-10-02 12:24:42','2025-10-02 12:26:17',NULL,0,54,'d5bedc1d8125465b92c98f9ebeb80ddb','gigabytes',0,0,NULL,1),('2025-10-02 12:24:42','2025-10-02 12:26:17',NULL,0,55,'d5bedc1d8125465b92c98f9ebeb80ddb','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:24:42','2025-10-02 12:26:17',NULL,0,56,'d5bedc1d8125465b92c98f9ebeb80ddb','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:26:42','2025-10-02 12:33:38',NULL,0,57,'5533aaac08cd4856af72ef4992bb5e76','volumes',0,0,NULL,1),('2025-10-02 12:26:42','2025-10-02 12:33:38',NULL,0,58,'5533aaac08cd4856af72ef4992bb5e76','gigabytes',0,0,NULL,1),('2025-10-02 12:26:42','2025-10-02 12:33:38',NULL,0,59,'5533aaac08cd4856af72ef4992bb5e76','volumes_multiattach',0,0,NULL,1),('2025-10-02 12:26:42','2025-10-02 12:33:38',NULL,0,60,'5533aaac08cd4856af72ef4992bb5e76','gigabytes_multiattach',0,0,NULL,1),('2025-10-02 12:27:06','2025-10-02 12:29:43',NULL,0,61,'7aad01ba5df14c1a9309451d0daaab83','volumes',0,0,NULL,1),('2025-10-02 12:27:06','2025-10-02 12:29:43',NULL,0,62,'7aad01ba5df14c1a9309451d0daaab83','gigabytes',0,0,NULL,1),('2025-10-02 12:27:06','2025-10-02 12:29:43',NULL,0,63,'7aad01ba5df14c1a9309451d0daaab83','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:27:06','2025-10-02 12:29:43',NULL,0,64,'7aad01ba5df14c1a9309451d0daaab83','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:32:39','2025-10-02 12:32:48',NULL,0,65,'5533aaac08cd4856af72ef4992bb5e76','snapshots',0,0,NULL,1),('2025-10-02 12:32:39','2025-10-02 12:32:48',NULL,0,66,'5533aaac08cd4856af72ef4992bb5e76','snapshots_multiattach',0,0,NULL,1),('2025-10-02 12:33:39','2025-10-02 12:36:40',NULL,0,67,'cc4d8f857b2d42bf9ae477fc5f514216','volumes',0,0,NULL,1),('2025-10-02 12:33:39','2025-10-02 12:36:40',NULL,0,68,'cc4d8f857b2d42bf9ae477fc5f514216','gigabytes',0,0,NULL,1),('2025-10-02 12:33:39','2025-10-02 12:36:40',NULL,0,69,'cc4d8f857b2d42bf9ae477fc5f514216','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:33:39','2025-10-02 12:36:40',NULL,0,70,'cc4d8f857b2d42bf9ae477fc5f514216','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:34:41','2025-10-02 12:38:44',NULL,0,71,'1a05e525420b4aa8adcc9561158e73d1','volumes',0,0,NULL,1),('2025-10-02 12:34:41','2025-10-02 12:38:44',NULL,0,72,'1a05e525420b4aa8adcc9561158e73d1','gigabytes',0,0,NULL,1),('2025-10-02 12:34:41','2025-10-02 12:38:44',NULL,0,73,'1a05e525420b4aa8adcc9561158e73d1','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:34:41','2025-10-02 12:38:44',NULL,0,74,'1a05e525420b4aa8adcc9561158e73d1','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:38:32','2025-10-02 12:42:48',NULL,0,75,'6822f02d5ca04c659329a75d487054cf','volumes',0,0,NULL,1),('2025-10-02 12:38:32','2025-10-02 12:42:48',NULL,0,76,'6822f02d5ca04c659329a75d487054cf','gigabytes',0,0,NULL,1),('2025-10-02 12:38:32','2025-10-02 12:42:48',NULL,0,77,'6822f02d5ca04c659329a75d487054cf','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:38:32','2025-10-02 12:42:48',NULL,0,78,'6822f02d5ca04c659329a75d487054cf','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:38:43','2025-10-02 12:40:36',NULL,0,79,'1294b2ea04b34f7189fde66e2afa2c56','volumes',0,0,NULL,1),('2025-10-02 12:38:43','2025-10-02 12:40:36',NULL,0,80,'1294b2ea04b34f7189fde66e2afa2c56','gigabytes',0,0,NULL,1),('2025-10-02 12:38:43','2025-10-02 12:40:36',NULL,0,81,'1294b2ea04b34f7189fde66e2afa2c56','volumes_tempest-scenario-type-luks-308158206',0,0,NULL,1),('2025-10-02 12:38:43','2025-10-02 12:40:36',NULL,0,82,'1294b2ea04b34f7189fde66e2afa2c56','gigabytes_tempest-scenario-type-luks-308158206',0,0,NULL,1),('2025-10-02 12:38:55','2025-10-02 12:39:20',NULL,0,83,'2a9fb2f388654380906f2a0db9d46565','volumes',0,0,NULL,1),('2025-10-02 12:38:55','2025-10-02 12:39:20',NULL,0,84,'2a9fb2f388654380906f2a0db9d46565','gigabytes',0,0,NULL,1),('2025-10-02 12:38:55','2025-10-02 12:39:20',NULL,0,85,'2a9fb2f388654380906f2a0db9d46565','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:38:55','2025-10-02 12:39:20',NULL,0,86,'2a9fb2f388654380906f2a0db9d46565','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:38:57','2025-10-02 12:39:17',NULL,0,87,'2a9fb2f388654380906f2a0db9d46565','snapshots',0,0,NULL,1),('2025-10-02 12:38:57','2025-10-02 12:39:17',NULL,0,88,'2a9fb2f388654380906f2a0db9d46565','snapshots___DEFAULT__',0,0,NULL,1),('2025-10-02 12:40:19','2025-10-02 12:44:15',NULL,0,89,'a41d99312f014c65adddea4f70536a15','volumes',0,0,NULL,1),('2025-10-02 12:40:19','2025-10-02 12:44:15',NULL,0,90,'a41d99312f014c65adddea4f70536a15','gigabytes',0,0,NULL,1),('2025-10-02 12:40:19','2025-10-02 12:43:25',NULL,0,91,'a41d99312f014c65adddea4f70536a15','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-250908576-499919160',0,0,NULL,1),('2025-10-02 12:40:19','2025-10-02 12:43:25',NULL,0,92,'a41d99312f014c65adddea4f70536a15','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-250908576-499919160',0,0,NULL,1),('2025-10-02 12:40:20','2025-10-02 12:43:32',NULL,0,93,'a41d99312f014c65adddea4f70536a15','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-278110967-1260666270',0,0,NULL,1),('2025-10-02 12:40:20','2025-10-02 12:43:32',NULL,0,94,'a41d99312f014c65adddea4f70536a15','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-278110967-1260666270',0,0,NULL,1),('2025-10-02 12:40:26','2025-10-02 12:44:15',NULL,0,95,'a41d99312f014c65adddea4f70536a15','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-3962293-2082593070',0,0,NULL,1),('2025-10-02 12:40:26','2025-10-02 12:44:15',NULL,0,96,'a41d99312f014c65adddea4f70536a15','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-3962293-2082593070',0,0,NULL,1),('2025-10-02 12:40:26','2025-10-02 12:40:52',NULL,0,97,'eb79c45adbb144538245fe5c27fade6d','volumes',0,0,NULL,1),('2025-10-02 12:40:26','2025-10-02 12:40:52',NULL,0,98,'eb79c45adbb144538245fe5c27fade6d','gigabytes',0,0,NULL,1),('2025-10-02 12:40:26','2025-10-02 12:40:52',NULL,0,99,'eb79c45adbb144538245fe5c27fade6d','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:40:26','2025-10-02 12:40:52',NULL,0,100,'eb79c45adbb144538245fe5c27fade6d','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:40:57','2025-10-02 12:41:13',NULL,0,101,'ac8793fd6752403e9dea029569836c09','volumes',0,0,NULL,1),('2025-10-02 12:40:57','2025-10-02 12:41:13',NULL,0,102,'ac8793fd6752403e9dea029569836c09','gigabytes',0,0,NULL,1),('2025-10-02 12:40:57','2025-10-02 12:41:13',NULL,0,103,'ac8793fd6752403e9dea029569836c09','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:40:57','2025-10-02 12:41:13',NULL,0,104,'ac8793fd6752403e9dea029569836c09','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:41:52','2025-10-02 12:45:29',NULL,0,105,'2e53064cd4d645f09bd59bbca09b98e0','volumes',0,0,NULL,1),('2025-10-02 12:41:52','2025-10-02 12:45:29',NULL,0,106,'2e53064cd4d645f09bd59bbca09b98e0','gigabytes',0,0,NULL,1),('2025-10-02 12:41:52','2025-10-02 12:45:29',NULL,0,107,'2e53064cd4d645f09bd59bbca09b98e0','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:41:52','2025-10-02 12:45:29',NULL,0,108,'2e53064cd4d645f09bd59bbca09b98e0','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:41:58','2025-10-02 12:42:19',NULL,0,109,'2e53064cd4d645f09bd59bbca09b98e0','snapshots',0,0,NULL,1),('2025-10-02 12:41:58','2025-10-02 12:42:19',NULL,0,110,'2e53064cd4d645f09bd59bbca09b98e0','snapshots___DEFAULT__',0,0,NULL,1),('2025-10-02 12:44:04','2025-10-02 12:46:06',NULL,0,111,'4b8f9114c7ab4b6e9fc9650d4bd08af9','volumes',0,0,NULL,1),('2025-10-02 12:44:04','2025-10-02 12:46:06',NULL,0,112,'4b8f9114c7ab4b6e9fc9650d4bd08af9','gigabytes',0,0,NULL,1),('2025-10-02 12:44:04','2025-10-02 12:46:06',NULL,0,113,'4b8f9114c7ab4b6e9fc9650d4bd08af9','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:44:04','2025-10-02 12:46:06',NULL,0,114,'4b8f9114c7ab4b6e9fc9650d4bd08af9','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:47:03','2025-10-02 12:49:35',NULL,0,115,'a837417d42da439cb794b4295bca2cee','volumes',0,0,NULL,1),('2025-10-02 12:47:03','2025-10-02 12:49:35',NULL,0,116,'a837417d42da439cb794b4295bca2cee','gigabytes',0,0,NULL,1),('2025-10-02 12:47:03','2025-10-02 12:49:35',NULL,0,117,'a837417d42da439cb794b4295bca2cee','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:47:03','2025-10-02 12:49:35',NULL,0,118,'a837417d42da439cb794b4295bca2cee','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:47:57','2025-10-02 12:49:25',NULL,0,119,'a837417d42da439cb794b4295bca2cee','snapshots',0,0,NULL,1),('2025-10-02 12:47:57','2025-10-02 12:49:25',NULL,0,120,'a837417d42da439cb794b4295bca2cee','snapshots___DEFAULT__',0,0,NULL,1),('2025-10-02 12:51:06','2025-10-02 12:54:59',NULL,0,121,'6a442bc513e14406b73e96e70396e6c3','volumes',0,0,NULL,1),('2025-10-02 12:51:06','2025-10-02 12:54:59',NULL,0,122,'6a442bc513e14406b73e96e70396e6c3','gigabytes',0,0,NULL,1),('2025-10-02 12:51:06','2025-10-02 12:54:59',NULL,0,123,'6a442bc513e14406b73e96e70396e6c3','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:51:06','2025-10-02 12:54:59',NULL,0,124,'6a442bc513e14406b73e96e70396e6c3','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:57:57','2025-10-02 13:00:54',NULL,0,125,'e7168b5b1300495d90592b195824729a','volumes',0,0,NULL,1),('2025-10-02 12:57:57','2025-10-02 13:00:54',NULL,0,126,'e7168b5b1300495d90592b195824729a','gigabytes',0,0,NULL,1),('2025-10-02 12:57:57','2025-10-02 13:00:54',NULL,0,127,'e7168b5b1300495d90592b195824729a','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:57:57','2025-10-02 13:00:54',NULL,0,128,'e7168b5b1300495d90592b195824729a','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:58:47','2025-10-02 12:59:58',NULL,0,129,'55e97477dd13448d9dafe69ec8614ea6','volumes',0,0,NULL,1),('2025-10-02 12:58:47','2025-10-02 12:59:58',NULL,0,130,'55e97477dd13448d9dafe69ec8614ea6','gigabytes',0,0,NULL,1),('2025-10-02 12:58:47','2025-10-02 12:59:58',NULL,0,131,'55e97477dd13448d9dafe69ec8614ea6','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:58:47','2025-10-02 12:59:58',NULL,0,132,'55e97477dd13448d9dafe69ec8614ea6','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 12:58:58','2025-10-02 12:59:57',NULL,0,133,'55e97477dd13448d9dafe69ec8614ea6','backups',0,0,NULL,1),('2025-10-02 12:58:58','2025-10-02 12:59:57',NULL,0,134,'55e97477dd13448d9dafe69ec8614ea6','backup_gigabytes',0,0,NULL,1),('2025-10-02 13:02:27','2025-10-02 13:06:07',NULL,0,135,'5eceae619a6f4fdeaa8ba6fafda4912a','volumes',0,0,NULL,1),('2025-10-02 13:02:27','2025-10-02 13:06:07',NULL,0,136,'5eceae619a6f4fdeaa8ba6fafda4912a','gigabytes',0,0,NULL,1),('2025-10-02 13:02:27','2025-10-02 13:06:07',NULL,0,137,'5eceae619a6f4fdeaa8ba6fafda4912a','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 13:02:27','2025-10-02 13:06:07',NULL,0,138,'5eceae619a6f4fdeaa8ba6fafda4912a','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 13:10:27','2025-10-02 13:16:13',NULL,0,139,'fbbc6cb494464fd9b31f64c1ad75fa6b','volumes',0,0,NULL,1),('2025-10-02 13:10:27','2025-10-02 13:16:13',NULL,0,140,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes',0,0,NULL,1),('2025-10-02 13:10:27','2025-10-02 13:10:57',NULL,0,141,'fbbc6cb494464fd9b31f64c1ad75fa6b','volumes_tempest-scenario-type-luks-849096102',0,0,NULL,1),('2025-10-02 13:10:27','2025-10-02 13:10:57',NULL,0,142,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes_tempest-scenario-type-luks-849096102',0,0,NULL,1),('2025-10-02 13:10:58','2025-10-02 13:16:13',NULL,0,143,'fbbc6cb494464fd9b31f64c1ad75fa6b','volumes___DEFAULT__',0,0,NULL,1),('2025-10-02 13:10:58','2025-10-02 13:16:13',NULL,0,144,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes___DEFAULT__',0,0,NULL,1),('2025-10-02 13:11:06','2025-10-02 13:16:05',NULL,0,145,'fbbc6cb494464fd9b31f64c1ad75fa6b','snapshots',0,0,NULL,1),('2025-10-02 13:11:06','2025-10-02 13:16:05',NULL,0,146,'fbbc6cb494464fd9b31f64c1ad75fa6b','snapshots___DEFAULT__',0,0,NULL,1);
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `allocated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `allocated_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reservations_deleted_uuid_idx` (`deleted`,`uuid`),
  KEY `ix_reservations_usage_id` (`usage_id`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  KEY `ix_reservations_allocated_id` (`allocated_id`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`),
  CONSTRAINT `reservations_ibfk_2` FOREIGN KEY (`allocated_id`) REFERENCES `quotas` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=605 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
INSERT INTO `reservations` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `uuid`, `usage_id`, `project_id`, `resource`, `delta`, `expire`, `allocated_id`) VALUES ('2025-10-02 11:58:42','2025-10-02 11:58:42','2025-10-02 11:58:42',1,1,'4c0f196d-bb75-435e-bbfe-3906f97e1a82',1,'9fab310b79144b0baa3a349f8bb4143f','volumes',1,'2025-10-03 11:58:42',NULL),('2025-10-02 11:58:42','2025-10-02 11:58:42','2025-10-02 11:58:42',1,2,'07385365-437c-4d2c-bf63-ad86b98d278b',2,'9fab310b79144b0baa3a349f8bb4143f','gigabytes',1,'2025-10-03 11:58:42',NULL),('2025-10-02 11:58:42','2025-10-02 11:58:42','2025-10-02 11:58:42',1,3,'ea55be53-3f93-46c9-98b8-9152be364b5d',3,'9fab310b79144b0baa3a349f8bb4143f','volumes___DEFAULT__',1,'2025-10-03 11:58:42',NULL),('2025-10-02 11:58:42','2025-10-02 11:58:42','2025-10-02 11:58:42',1,4,'6def82b5-2c3f-48b2-943b-ee01e78a58f3',4,'9fab310b79144b0baa3a349f8bb4143f','gigabytes___DEFAULT__',1,'2025-10-03 11:58:42',NULL),('2025-10-02 11:59:50','2025-10-02 11:59:50','2025-10-02 11:59:50',1,5,'8940c0bd-aa07-49ef-928d-bff6f7393f6c',1,'9fab310b79144b0baa3a349f8bb4143f','volumes',-1,'2025-10-03 11:59:50',NULL),('2025-10-02 11:59:50','2025-10-02 11:59:50','2025-10-02 11:59:50',1,6,'97ceb5d0-40eb-4916-afa4-40680a8ba5ee',2,'9fab310b79144b0baa3a349f8bb4143f','gigabytes',-1,'2025-10-03 11:59:50',NULL),('2025-10-02 11:59:50','2025-10-02 11:59:50','2025-10-02 11:59:50',1,7,'cea19446-e4ee-4db3-83a8-b59c6c181987',3,'9fab310b79144b0baa3a349f8bb4143f','volumes___DEFAULT__',-1,'2025-10-03 11:59:50',NULL),('2025-10-02 11:59:50','2025-10-02 11:59:50','2025-10-02 11:59:50',1,8,'e88a5691-8109-4cdc-8166-c202b5723788',4,'9fab310b79144b0baa3a349f8bb4143f','gigabytes___DEFAULT__',-1,'2025-10-03 11:59:50',NULL),('2025-10-02 12:00:09','2025-10-02 12:00:09','2025-10-02 12:00:09',1,9,'2d3c5c61-b982-473e-8b7f-bddce87b2988',5,'d977ad6a90874946819537242925a8f0','volumes',1,'2025-10-03 12:00:09',NULL),('2025-10-02 12:00:09','2025-10-02 12:00:09','2025-10-02 12:00:09',1,10,'ae00b5e7-3acd-4588-8c74-766e2fa43d61',6,'d977ad6a90874946819537242925a8f0','gigabytes',1,'2025-10-03 12:00:09',NULL),('2025-10-02 12:00:09','2025-10-02 12:00:09','2025-10-02 12:00:09',1,11,'97fc4c36-ecf7-4c05-a521-b8c5e55c1ac3',7,'d977ad6a90874946819537242925a8f0','volumes___DEFAULT__',1,'2025-10-03 12:00:09',NULL),('2025-10-02 12:00:09','2025-10-02 12:00:09','2025-10-02 12:00:09',1,12,'e6a38263-c748-4c9d-821d-7773f9ed26f4',8,'d977ad6a90874946819537242925a8f0','gigabytes___DEFAULT__',1,'2025-10-03 12:00:09',NULL),('2025-10-02 12:01:49','2025-10-02 12:01:49','2025-10-02 12:01:49',1,13,'11085a8f-cc25-4f79-a5d0-c7b749bf4ddf',5,'d977ad6a90874946819537242925a8f0','volumes',-1,'2025-10-03 12:01:49',NULL),('2025-10-02 12:01:49','2025-10-02 12:01:49','2025-10-02 12:01:49',1,14,'5f286139-398f-4a5d-bac0-362129d4a533',6,'d977ad6a90874946819537242925a8f0','gigabytes',-1,'2025-10-03 12:01:49',NULL),('2025-10-02 12:01:49','2025-10-02 12:01:49','2025-10-02 12:01:49',1,15,'72b7fee9-0a0e-4574-b4ac-8e92c0ee3308',7,'d977ad6a90874946819537242925a8f0','volumes___DEFAULT__',-1,'2025-10-03 12:01:49',NULL),('2025-10-02 12:01:49','2025-10-02 12:01:49','2025-10-02 12:01:49',1,16,'e8163eb5-452c-4706-b81a-4215e581f14c',8,'d977ad6a90874946819537242925a8f0','gigabytes___DEFAULT__',-1,'2025-10-03 12:01:49',NULL),('2025-10-02 12:02:12','2025-10-02 12:02:12','2025-10-02 12:02:12',1,17,'8e07dcc9-6150-4eef-a726-7d81e5fe9f8a',9,'3f2b3ac7d7504c9c96f0d4a67e0243c9','volumes',1,'2025-10-03 12:02:12',NULL),('2025-10-02 12:02:12','2025-10-02 12:02:12','2025-10-02 12:02:12',1,18,'8641abf4-81e3-4cd3-8678-090b1a570adf',10,'3f2b3ac7d7504c9c96f0d4a67e0243c9','gigabytes',1,'2025-10-03 12:02:12',NULL),('2025-10-02 12:02:12','2025-10-02 12:02:12','2025-10-02 12:02:12',1,19,'632bdab3-6f68-4f60-a488-6b536233db99',11,'3f2b3ac7d7504c9c96f0d4a67e0243c9','volumes___DEFAULT__',1,'2025-10-03 12:02:12',NULL),('2025-10-02 12:02:12','2025-10-02 12:02:12','2025-10-02 12:02:12',1,20,'5eae445c-73c1-44f1-a3fb-08c395b88787',12,'3f2b3ac7d7504c9c96f0d4a67e0243c9','gigabytes___DEFAULT__',1,'2025-10-03 12:02:12',NULL),('2025-10-02 12:03:21','2025-10-02 12:03:21','2025-10-02 12:03:21',1,21,'55ecfcbb-e6e7-4b5c-9a88-9aaa52e810af',9,'3f2b3ac7d7504c9c96f0d4a67e0243c9','volumes',-1,'2025-10-03 12:03:21',NULL),('2025-10-02 12:03:21','2025-10-02 12:03:21','2025-10-02 12:03:21',1,22,'ca41337f-709b-4e1a-9a58-f5d6c4e27852',10,'3f2b3ac7d7504c9c96f0d4a67e0243c9','gigabytes',-1,'2025-10-03 12:03:21',NULL),('2025-10-02 12:03:21','2025-10-02 12:03:21','2025-10-02 12:03:21',1,23,'9a0e336a-b544-467f-8f9b-9743567f6a51',11,'3f2b3ac7d7504c9c96f0d4a67e0243c9','volumes___DEFAULT__',-1,'2025-10-03 12:03:21',NULL),('2025-10-02 12:03:21','2025-10-02 12:03:21','2025-10-02 12:03:21',1,24,'15bff4b8-7748-421b-b7c1-3e2fbda3b002',12,'3f2b3ac7d7504c9c96f0d4a67e0243c9','gigabytes___DEFAULT__',-1,'2025-10-03 12:03:21',NULL),('2025-10-02 12:06:15','2025-10-02 12:06:15','2025-10-02 12:06:15',1,25,'2ceffc46-4a5e-4b3e-a007-b236b6a6e9b0',13,'7359a7dad3b849bfbf075b88f2a261b4','volumes',1,'2025-10-03 12:06:14',NULL),('2025-10-02 12:06:15','2025-10-02 12:06:15','2025-10-02 12:06:15',1,26,'7d09af35-1f3a-432e-9a83-53438f7490ba',14,'7359a7dad3b849bfbf075b88f2a261b4','gigabytes',1,'2025-10-03 12:06:14',NULL),('2025-10-02 12:06:15','2025-10-02 12:06:15','2025-10-02 12:06:15',1,27,'27efe86b-d4ab-4701-8c41-42f46d16e8c1',15,'7359a7dad3b849bfbf075b88f2a261b4','volumes_multiattach',1,'2025-10-03 12:06:14',NULL),('2025-10-02 12:06:15','2025-10-02 12:06:15','2025-10-02 12:06:15',1,28,'98dd5f45-2b46-4035-ab94-6ba1db2f47fd',16,'7359a7dad3b849bfbf075b88f2a261b4','gigabytes_multiattach',1,'2025-10-03 12:06:14',NULL),('2025-10-02 12:06:18','2025-10-02 12:06:18','2025-10-02 12:06:18',1,29,'688fef73-e0da-4984-9008-edd3111b7969',13,'7359a7dad3b849bfbf075b88f2a261b4','volumes',1,'2025-10-03 12:06:18',NULL),('2025-10-02 12:06:18','2025-10-02 12:06:18','2025-10-02 12:06:18',1,30,'8ec427a4-5e42-45d2-a374-aaeeefee6e65',14,'7359a7dad3b849bfbf075b88f2a261b4','gigabytes',1,'2025-10-03 12:06:18',NULL),('2025-10-02 12:06:18','2025-10-02 12:06:18','2025-10-02 12:06:18',1,31,'d49c4031-cc55-4eb1-81c8-017d65de9b63',15,'7359a7dad3b849bfbf075b88f2a261b4','volumes_multiattach',1,'2025-10-03 12:06:18',NULL),('2025-10-02 12:06:18','2025-10-02 12:06:18','2025-10-02 12:06:18',1,32,'6039ef1a-cfc4-434c-9789-d6dc973abe50',16,'7359a7dad3b849bfbf075b88f2a261b4','gigabytes_multiattach',1,'2025-10-03 12:06:18',NULL),('2025-10-02 12:08:06','2025-10-02 12:08:06','2025-10-02 12:08:06',1,33,'a17cffe2-285f-4714-ae22-a9d8cab228c9',17,'861ae6a71574411fbcdab09902e6bcc4','volumes',1,'2025-10-03 12:08:06',NULL),('2025-10-02 12:08:06','2025-10-02 12:08:06','2025-10-02 12:08:06',1,34,'18f58c1d-1db5-481b-bf45-7570d1251e56',18,'861ae6a71574411fbcdab09902e6bcc4','gigabytes',1,'2025-10-03 12:08:06',NULL),('2025-10-02 12:08:06','2025-10-02 12:08:06','2025-10-02 12:08:06',1,35,'dbf33bc7-1469-4839-8995-2ee767c32deb',19,'861ae6a71574411fbcdab09902e6bcc4','volumes___DEFAULT__',1,'2025-10-03 12:08:06',NULL),('2025-10-02 12:08:06','2025-10-02 12:08:06','2025-10-02 12:08:06',1,36,'f3cedbc4-5ea2-4fe4-b2e2-894bcc55d70c',20,'861ae6a71574411fbcdab09902e6bcc4','gigabytes___DEFAULT__',1,'2025-10-03 12:08:06',NULL),('2025-10-02 12:08:21','2025-10-02 12:08:21','2025-10-02 12:08:21',1,37,'ca2baa33-3aef-49bc-85c1-3f564f25fe3b',13,'7359a7dad3b849bfbf075b88f2a261b4','volumes',-1,'2025-10-03 12:08:21',NULL),('2025-10-02 12:08:21','2025-10-02 12:08:21','2025-10-02 12:08:21',1,38,'fddc28b9-a7f3-49d3-8da9-d2a04e4a129d',14,'7359a7dad3b849bfbf075b88f2a261b4','gigabytes',-1,'2025-10-03 12:08:21',NULL),('2025-10-02 12:08:21','2025-10-02 12:08:21','2025-10-02 12:08:21',1,39,'ac2cd90e-2edc-4358-b019-33cdbc6b3d68',15,'7359a7dad3b849bfbf075b88f2a261b4','volumes_multiattach',-1,'2025-10-03 12:08:21',NULL),('2025-10-02 12:08:21','2025-10-02 12:08:21','2025-10-02 12:08:21',1,40,'88a36254-e28b-4a6e-a856-9bd7cb68cfd4',16,'7359a7dad3b849bfbf075b88f2a261b4','gigabytes_multiattach',-1,'2025-10-03 12:08:21',NULL),('2025-10-02 12:08:22','2025-10-02 12:08:22','2025-10-02 12:08:22',1,41,'44e595c8-d46f-46ec-a1f2-2343e1e3be95',13,'7359a7dad3b849bfbf075b88f2a261b4','volumes',-1,'2025-10-03 12:08:22',NULL),('2025-10-02 12:08:22','2025-10-02 12:08:22','2025-10-02 12:08:22',1,42,'db8d658d-bdc5-4653-bd04-1611c374a83a',14,'7359a7dad3b849bfbf075b88f2a261b4','gigabytes',-1,'2025-10-03 12:08:22',NULL),('2025-10-02 12:08:22','2025-10-02 12:08:22','2025-10-02 12:08:22',1,43,'6aeeba06-2f81-444c-8f5a-2920e208f5bb',15,'7359a7dad3b849bfbf075b88f2a261b4','volumes_multiattach',-1,'2025-10-03 12:08:22',NULL),('2025-10-02 12:08:22','2025-10-02 12:08:22','2025-10-02 12:08:22',1,44,'250b0e62-7137-4dfc-b8b6-8fba51be8af3',16,'7359a7dad3b849bfbf075b88f2a261b4','gigabytes_multiattach',-1,'2025-10-03 12:08:22',NULL),('2025-10-02 12:08:27','2025-10-02 12:08:27','2025-10-02 12:08:27',1,45,'51ba4e74-23e0-421a-9b43-08ab4fa88ffd',17,'861ae6a71574411fbcdab09902e6bcc4','volumes',-1,'2025-10-03 12:08:27',NULL),('2025-10-02 12:08:27','2025-10-02 12:08:27','2025-10-02 12:08:27',1,46,'810aa0d9-ce2e-437e-93af-aaa678eec574',18,'861ae6a71574411fbcdab09902e6bcc4','gigabytes',-1,'2025-10-03 12:08:27',NULL),('2025-10-02 12:08:27','2025-10-02 12:08:27','2025-10-02 12:08:27',1,47,'f2fc6e0b-2299-42d7-b017-714c3d49d062',19,'861ae6a71574411fbcdab09902e6bcc4','volumes___DEFAULT__',-1,'2025-10-03 12:08:27',NULL),('2025-10-02 12:08:27','2025-10-02 12:08:27','2025-10-02 12:08:27',1,48,'6a63f3d6-c01a-406f-9312-7330602ca74f',20,'861ae6a71574411fbcdab09902e6bcc4','gigabytes___DEFAULT__',-1,'2025-10-03 12:08:27',NULL),('2025-10-02 12:09:39','2025-10-02 12:09:39','2025-10-02 12:09:39',1,49,'0d233b7f-43ac-4ffb-96a1-0e8490fd5ddc',21,'95056cabad5b4f32916e46a46b10f677','volumes',1,'2025-10-03 12:09:39',NULL),('2025-10-02 12:09:39','2025-10-02 12:09:39','2025-10-02 12:09:39',1,50,'0f5687a7-d54f-4803-ae2d-497cbf607f56',22,'95056cabad5b4f32916e46a46b10f677','gigabytes',1,'2025-10-03 12:09:39',NULL),('2025-10-02 12:09:39','2025-10-02 12:09:39','2025-10-02 12:09:39',1,51,'bf7adfdc-66f7-44bb-85d0-178c5e94c45a',23,'95056cabad5b4f32916e46a46b10f677','volumes___DEFAULT__',1,'2025-10-03 12:09:39',NULL),('2025-10-02 12:09:39','2025-10-02 12:09:39','2025-10-02 12:09:39',1,52,'88de290a-25a9-465d-ae0d-ddf02be8468e',24,'95056cabad5b4f32916e46a46b10f677','gigabytes___DEFAULT__',1,'2025-10-03 12:09:39',NULL),('2025-10-02 12:10:12','2025-10-02 12:10:12','2025-10-02 12:10:12',1,53,'ff19ebf7-c60d-466f-98c9-3dc1796bd101',21,'95056cabad5b4f32916e46a46b10f677','volumes',1,'2025-10-03 12:10:12',NULL),('2025-10-02 12:10:12','2025-10-02 12:10:12','2025-10-02 12:10:12',1,54,'99c3b77f-9a68-4ae9-b117-269f9c123fec',22,'95056cabad5b4f32916e46a46b10f677','gigabytes',1,'2025-10-03 12:10:12',NULL),('2025-10-02 12:10:12','2025-10-02 12:10:12','2025-10-02 12:10:12',1,55,'d4124cf9-eec2-44bc-8b9f-1c53a2b58b35',23,'95056cabad5b4f32916e46a46b10f677','volumes___DEFAULT__',1,'2025-10-03 12:10:12',NULL),('2025-10-02 12:10:12','2025-10-02 12:10:12','2025-10-02 12:10:12',1,56,'3b940077-19f1-45ec-b7ed-606b83dd3e63',24,'95056cabad5b4f32916e46a46b10f677','gigabytes___DEFAULT__',1,'2025-10-03 12:10:12',NULL),('2025-10-02 12:10:16','2025-10-02 12:10:16','2025-10-02 12:10:16',1,57,'817380a8-ebe2-41bb-8f84-493068269265',21,'95056cabad5b4f32916e46a46b10f677','volumes',-1,'2025-10-03 12:10:16',NULL),('2025-10-02 12:10:16','2025-10-02 12:10:16','2025-10-02 12:10:16',1,58,'2455e215-cfac-447a-95ed-35489ac6778d',22,'95056cabad5b4f32916e46a46b10f677','gigabytes',-1,'2025-10-03 12:10:16',NULL),('2025-10-02 12:10:16','2025-10-02 12:10:16','2025-10-02 12:10:16',1,59,'89eb6308-3dc1-49e1-aad2-d911460ca96a',23,'95056cabad5b4f32916e46a46b10f677','volumes___DEFAULT__',-1,'2025-10-03 12:10:16',NULL),('2025-10-02 12:10:16','2025-10-02 12:10:16','2025-10-02 12:10:16',1,60,'78488eff-2434-4bc7-9b23-ae0f15c7c126',24,'95056cabad5b4f32916e46a46b10f677','gigabytes___DEFAULT__',-1,'2025-10-03 12:10:16',NULL),('2025-10-02 12:10:21','2025-10-02 12:10:21','2025-10-02 12:10:21',1,61,'e1f21094-8c03-4188-b13b-96987b23fe14',21,'95056cabad5b4f32916e46a46b10f677','volumes',-1,'2025-10-03 12:10:21',NULL),('2025-10-02 12:10:21','2025-10-02 12:10:21','2025-10-02 12:10:21',1,62,'1fc9aa73-aae3-4758-a0c0-b081ce048503',22,'95056cabad5b4f32916e46a46b10f677','gigabytes',-1,'2025-10-03 12:10:21',NULL),('2025-10-02 12:10:21','2025-10-02 12:10:21','2025-10-02 12:10:21',1,63,'e4de0416-0c89-4e2f-955a-5280e5a0d69a',23,'95056cabad5b4f32916e46a46b10f677','volumes___DEFAULT__',-1,'2025-10-03 12:10:21',NULL),('2025-10-02 12:10:21','2025-10-02 12:10:21','2025-10-02 12:10:21',1,64,'b605090e-abbf-4cdb-a953-3a1dfbb79eb7',24,'95056cabad5b4f32916e46a46b10f677','gigabytes___DEFAULT__',-1,'2025-10-03 12:10:21',NULL),('2025-10-02 12:15:59','2025-10-02 12:15:59','2025-10-02 12:15:59',1,65,'3c098716-76ce-488f-b91a-cf9c3e3caff7',25,'a9d3eca266284ae9950c491e566b2523','volumes',1,'2025-10-03 12:15:59',NULL),('2025-10-02 12:15:59','2025-10-02 12:15:59','2025-10-02 12:15:59',1,66,'a26c9a88-bfda-48ce-847c-e1fe5189a776',26,'a9d3eca266284ae9950c491e566b2523','gigabytes',1,'2025-10-03 12:15:59',NULL),('2025-10-02 12:15:59','2025-10-02 12:15:59','2025-10-02 12:15:59',1,67,'c23a0ea6-0ee8-4442-922b-e28574fba2cf',27,'a9d3eca266284ae9950c491e566b2523','volumes___DEFAULT__',1,'2025-10-03 12:15:59',NULL),('2025-10-02 12:15:59','2025-10-02 12:15:59','2025-10-02 12:15:59',1,68,'92a46464-bab9-4971-8da4-9695d1ef450d',28,'a9d3eca266284ae9950c491e566b2523','gigabytes___DEFAULT__',1,'2025-10-03 12:15:59',NULL),('2025-10-02 12:16:09','2025-10-02 12:16:09','2025-10-02 12:16:09',1,69,'4c89f965-cf89-472b-be03-dcb3335e0762',25,'a9d3eca266284ae9950c491e566b2523','volumes',1,'2025-10-03 12:16:09',NULL),('2025-10-02 12:16:09','2025-10-02 12:16:09','2025-10-02 12:16:09',1,70,'d058a6f5-ec16-4b7d-a016-a079b5aa04b8',26,'a9d3eca266284ae9950c491e566b2523','gigabytes',1,'2025-10-03 12:16:09',NULL),('2025-10-02 12:16:09','2025-10-02 12:16:09','2025-10-02 12:16:09',1,71,'b14d958a-1ae6-4f2f-a0dc-942ef11f5667',27,'a9d3eca266284ae9950c491e566b2523','volumes___DEFAULT__',1,'2025-10-03 12:16:09',NULL),('2025-10-02 12:16:09','2025-10-02 12:16:09','2025-10-02 12:16:09',1,72,'91f5778a-c400-4e3a-886c-1fe5c425c98f',28,'a9d3eca266284ae9950c491e566b2523','gigabytes___DEFAULT__',1,'2025-10-03 12:16:09',NULL),('2025-10-02 12:16:11','2025-10-02 12:16:11','2025-10-02 12:16:11',1,73,'3aaf3657-5fb0-4f32-91f5-e05232f2f720',25,'a9d3eca266284ae9950c491e566b2523','volumes',1,'2025-10-03 12:16:11',NULL),('2025-10-02 12:16:11','2025-10-02 12:16:11','2025-10-02 12:16:11',1,74,'5d69cb37-7076-4c9e-9065-e1d03647f680',26,'a9d3eca266284ae9950c491e566b2523','gigabytes',1,'2025-10-03 12:16:11',NULL),('2025-10-02 12:16:11','2025-10-02 12:16:11','2025-10-02 12:16:11',1,75,'1dfa3a37-3c15-4ca7-91d5-991a2c4a6ea5',27,'a9d3eca266284ae9950c491e566b2523','volumes___DEFAULT__',1,'2025-10-03 12:16:11',NULL),('2025-10-02 12:16:11','2025-10-02 12:16:11','2025-10-02 12:16:11',1,76,'50a6cc20-ea4c-43fb-81c9-3ad645cce699',28,'a9d3eca266284ae9950c491e566b2523','gigabytes___DEFAULT__',1,'2025-10-03 12:16:11',NULL),('2025-10-02 12:17:13','2025-10-02 12:17:13','2025-10-02 12:17:13',1,77,'1d20b64d-3447-4cf9-b4d7-ee57c495fcfb',29,'8efba404696b40fbbaa6431b934b87f1','volumes',1,'2025-10-03 12:17:13',NULL),('2025-10-02 12:17:13','2025-10-02 12:17:13','2025-10-02 12:17:13',1,78,'dd5c928c-b8fa-47af-a090-af42a78d3c62',30,'8efba404696b40fbbaa6431b934b87f1','gigabytes',1,'2025-10-03 12:17:13',NULL),('2025-10-02 12:17:13','2025-10-02 12:17:13','2025-10-02 12:17:13',1,79,'fd1ce1df-05d5-45ae-9444-fde8960645b3',31,'8efba404696b40fbbaa6431b934b87f1','volumes___DEFAULT__',1,'2025-10-03 12:17:13',NULL),('2025-10-02 12:17:13','2025-10-02 12:17:13','2025-10-02 12:17:13',1,80,'ba165624-d9d3-49f3-82f4-8f62c454df42',32,'8efba404696b40fbbaa6431b934b87f1','gigabytes___DEFAULT__',1,'2025-10-03 12:17:13',NULL),('2025-10-02 12:18:25','2025-10-02 12:18:25','2025-10-02 12:18:25',1,81,'be8649b2-8d45-43a0-89f7-368fb5970cba',25,'a9d3eca266284ae9950c491e566b2523','volumes',-1,'2025-10-03 12:18:25',NULL),('2025-10-02 12:18:25','2025-10-02 12:18:25','2025-10-02 12:18:25',1,82,'cb39c712-4480-450a-b7f9-b17b6acdebd0',26,'a9d3eca266284ae9950c491e566b2523','gigabytes',-1,'2025-10-03 12:18:25',NULL),('2025-10-02 12:18:25','2025-10-02 12:18:25','2025-10-02 12:18:25',1,83,'a926af43-457b-4fce-9c71-7dec9c9e900c',27,'a9d3eca266284ae9950c491e566b2523','volumes___DEFAULT__',-1,'2025-10-03 12:18:25',NULL),('2025-10-02 12:18:25','2025-10-02 12:18:25','2025-10-02 12:18:25',1,84,'318b616c-4658-4427-aa51-20611a2605cd',28,'a9d3eca266284ae9950c491e566b2523','gigabytes___DEFAULT__',-1,'2025-10-03 12:18:25',NULL),('2025-10-02 12:18:25','2025-10-02 12:18:25','2025-10-02 12:18:25',1,85,'a4603161-5edc-4e51-83a8-69d20bd37561',33,'a07342ec339549a4b091ddbcfedae271','volumes',1,'2025-10-03 12:18:25',NULL),('2025-10-02 12:18:25','2025-10-02 12:18:25','2025-10-02 12:18:25',1,86,'8061095e-2320-44fc-b2ca-003119d00a51',34,'a07342ec339549a4b091ddbcfedae271','gigabytes',1,'2025-10-03 12:18:25',NULL),('2025-10-02 12:18:25','2025-10-02 12:18:25','2025-10-02 12:18:25',1,87,'d3475316-36c8-4f1a-8a6a-719b95ea6167',35,'a07342ec339549a4b091ddbcfedae271','volumes___DEFAULT__',1,'2025-10-03 12:18:25',NULL),('2025-10-02 12:18:25','2025-10-02 12:18:25','2025-10-02 12:18:25',1,88,'593e79f4-9a05-465c-ab18-914d3a42e916',36,'a07342ec339549a4b091ddbcfedae271','gigabytes___DEFAULT__',1,'2025-10-03 12:18:25',NULL),('2025-10-02 12:18:26','2025-10-02 12:18:26','2025-10-02 12:18:26',1,89,'8990ec73-f25a-445c-97a1-6100d34ec99f',25,'a9d3eca266284ae9950c491e566b2523','volumes',-1,'2025-10-03 12:18:26',NULL),('2025-10-02 12:18:26','2025-10-02 12:18:26','2025-10-02 12:18:26',1,90,'7b02a290-a0d1-47bf-b239-37b174704a30',26,'a9d3eca266284ae9950c491e566b2523','gigabytes',-1,'2025-10-03 12:18:26',NULL),('2025-10-02 12:18:26','2025-10-02 12:18:26','2025-10-02 12:18:26',1,91,'55081939-2455-497e-880a-96dfe4c01152',27,'a9d3eca266284ae9950c491e566b2523','volumes___DEFAULT__',-1,'2025-10-03 12:18:26',NULL),('2025-10-02 12:18:26','2025-10-02 12:18:26','2025-10-02 12:18:26',1,92,'13e44a1c-666d-43be-9c05-6dde37fb587c',28,'a9d3eca266284ae9950c491e566b2523','gigabytes___DEFAULT__',-1,'2025-10-03 12:18:26',NULL),('2025-10-02 12:18:28','2025-10-02 12:18:28','2025-10-02 12:18:28',1,93,'6d02961c-ac1b-4d70-a1f2-e846b470ef23',25,'a9d3eca266284ae9950c491e566b2523','volumes',-1,'2025-10-03 12:18:28',NULL),('2025-10-02 12:18:28','2025-10-02 12:18:28','2025-10-02 12:18:28',1,94,'b5ff6fe8-5b5e-4f7c-a213-1f74ba092f1e',26,'a9d3eca266284ae9950c491e566b2523','gigabytes',-1,'2025-10-03 12:18:28',NULL),('2025-10-02 12:18:28','2025-10-02 12:18:28','2025-10-02 12:18:28',1,95,'826b1392-7672-40b5-9d23-b23922198e5b',27,'a9d3eca266284ae9950c491e566b2523','volumes___DEFAULT__',-1,'2025-10-03 12:18:28',NULL),('2025-10-02 12:18:28','2025-10-02 12:18:28','2025-10-02 12:18:28',1,96,'1a983293-648a-4809-a9ed-894e83a43a1c',28,'a9d3eca266284ae9950c491e566b2523','gigabytes___DEFAULT__',-1,'2025-10-03 12:18:28',NULL),('2025-10-02 12:19:17','2025-10-02 12:19:17','2025-10-02 12:19:17',1,97,'f4b21dd2-aef4-4719-9722-c32b0c47e18e',29,'8efba404696b40fbbaa6431b934b87f1','volumes',1,'2025-10-03 12:19:17',NULL),('2025-10-02 12:19:17','2025-10-02 12:19:17','2025-10-02 12:19:17',1,98,'bf085425-4461-43f3-97ab-050e1752ca13',30,'8efba404696b40fbbaa6431b934b87f1','gigabytes',1,'2025-10-03 12:19:17',NULL),('2025-10-02 12:19:17','2025-10-02 12:19:17','2025-10-02 12:19:17',1,99,'0fb4f31f-6efc-492b-8544-d08bdebd1cab',31,'8efba404696b40fbbaa6431b934b87f1','volumes___DEFAULT__',1,'2025-10-03 12:19:17',NULL),('2025-10-02 12:19:17','2025-10-02 12:19:17','2025-10-02 12:19:17',1,100,'5efc0c53-97aa-4f7e-a0af-640071276a9c',32,'8efba404696b40fbbaa6431b934b87f1','gigabytes___DEFAULT__',1,'2025-10-03 12:19:17',NULL),('2025-10-02 12:19:26','2025-10-02 12:19:26','2025-10-02 12:19:26',1,101,'953bd659-ed52-4df7-b522-debbdfbcefbd',37,'84f71f6076f7425db7653ac203257df0','volumes',1,'2025-10-03 12:19:26',NULL),('2025-10-02 12:19:26','2025-10-02 12:19:26','2025-10-02 12:19:26',1,102,'75048cb8-3794-4f24-8917-8bf0da370ef8',38,'84f71f6076f7425db7653ac203257df0','gigabytes',1,'2025-10-03 12:19:26',NULL),('2025-10-02 12:19:26','2025-10-02 12:19:26','2025-10-02 12:19:26',1,103,'dbac00d7-e579-43a7-a7e1-27789f0fe50f',39,'84f71f6076f7425db7653ac203257df0','volumes___DEFAULT__',1,'2025-10-03 12:19:26',NULL),('2025-10-02 12:19:26','2025-10-02 12:19:26','2025-10-02 12:19:26',1,104,'41c4f3b7-9b41-413c-86a5-50e4f16d5e99',40,'84f71f6076f7425db7653ac203257df0','gigabytes___DEFAULT__',1,'2025-10-03 12:19:26',NULL),('2025-10-02 12:19:39','2025-10-02 12:19:39','2025-10-02 12:19:39',1,105,'dccfbbe0-e3ba-4e58-9c2e-f8fda54c511f',37,'84f71f6076f7425db7653ac203257df0','volumes',1,'2025-10-03 12:19:39',NULL),('2025-10-02 12:19:39','2025-10-02 12:19:39','2025-10-02 12:19:39',1,106,'489f8279-8b4a-4986-9462-b95c16c7cccb',38,'84f71f6076f7425db7653ac203257df0','gigabytes',1,'2025-10-03 12:19:39',NULL),('2025-10-02 12:19:39','2025-10-02 12:19:39','2025-10-02 12:19:39',1,107,'8fcab71e-20c4-42e2-98af-9a39003968fa',39,'84f71f6076f7425db7653ac203257df0','volumes___DEFAULT__',1,'2025-10-03 12:19:39',NULL),('2025-10-02 12:19:39','2025-10-02 12:19:39','2025-10-02 12:19:39',1,108,'e42c064d-e432-4eb9-9b83-10f1996d2dad',40,'84f71f6076f7425db7653ac203257df0','gigabytes___DEFAULT__',1,'2025-10-03 12:19:39',NULL),('2025-10-02 12:19:39','2025-10-02 12:19:40','2025-10-02 12:19:40',1,109,'50d63a72-a9fd-4f4a-a25f-9fa683bd70ab',33,'a07342ec339549a4b091ddbcfedae271','volumes',-1,'2025-10-03 12:19:39',NULL),('2025-10-02 12:19:39','2025-10-02 12:19:40','2025-10-02 12:19:40',1,110,'34ec72e7-fc91-48b6-8475-90fe3c2ce4ec',34,'a07342ec339549a4b091ddbcfedae271','gigabytes',-1,'2025-10-03 12:19:39',NULL),('2025-10-02 12:19:39','2025-10-02 12:19:40','2025-10-02 12:19:40',1,111,'78eb911c-29df-41d7-a4d0-9e7caa332673',35,'a07342ec339549a4b091ddbcfedae271','volumes___DEFAULT__',-1,'2025-10-03 12:19:39',NULL),('2025-10-02 12:19:40','2025-10-02 12:19:40','2025-10-02 12:19:40',1,112,'494e067d-1aed-4981-81ba-01bcf99abba2',36,'a07342ec339549a4b091ddbcfedae271','gigabytes___DEFAULT__',-1,'2025-10-03 12:19:39',NULL),('2025-10-02 12:19:41','2025-10-02 12:19:41','2025-10-02 12:19:41',1,113,'9e729533-30c5-4dd8-b1c1-bc1216c254ad',37,'84f71f6076f7425db7653ac203257df0','volumes',1,'2025-10-03 12:19:41',NULL),('2025-10-02 12:19:41','2025-10-02 12:19:41','2025-10-02 12:19:41',1,114,'39aae230-6225-4bd8-ba6d-4ee7136a7aa4',38,'84f71f6076f7425db7653ac203257df0','gigabytes',1,'2025-10-03 12:19:41',NULL),('2025-10-02 12:19:41','2025-10-02 12:19:41','2025-10-02 12:19:41',1,115,'660f060e-084c-4228-990d-0d70def6723a',39,'84f71f6076f7425db7653ac203257df0','volumes___DEFAULT__',1,'2025-10-03 12:19:41',NULL),('2025-10-02 12:19:41','2025-10-02 12:19:41','2025-10-02 12:19:41',1,116,'85b227b3-cace-4814-bcde-c06ee3c04bad',40,'84f71f6076f7425db7653ac203257df0','gigabytes___DEFAULT__',1,'2025-10-03 12:19:41',NULL),('2025-10-02 12:20:36','2025-10-02 12:20:36','2025-10-02 12:20:36',1,117,'a1235583-f1ab-4acc-9c36-e7889f8cc377',41,'1c2c11ebecb14f3188f35ea473c4ca02','volumes',1,'2025-10-03 12:20:36',NULL),('2025-10-02 12:20:36','2025-10-02 12:20:36','2025-10-02 12:20:36',1,118,'d834de99-a733-4376-8ba7-7a0639d8078d',42,'1c2c11ebecb14f3188f35ea473c4ca02','gigabytes',1,'2025-10-03 12:20:36',NULL),('2025-10-02 12:20:36','2025-10-02 12:20:36','2025-10-02 12:20:36',1,119,'1e470903-2bdb-4cad-9c16-d552360e9221',43,'1c2c11ebecb14f3188f35ea473c4ca02','volumes___DEFAULT__',1,'2025-10-03 12:20:36',NULL),('2025-10-02 12:20:36','2025-10-02 12:20:36','2025-10-02 12:20:36',1,120,'fc416472-2da5-43e3-80e8-b1131c865b2c',44,'1c2c11ebecb14f3188f35ea473c4ca02','gigabytes___DEFAULT__',1,'2025-10-03 12:20:36',NULL),('2025-10-02 12:21:39','2025-10-02 12:21:39','2025-10-02 12:21:39',1,121,'dd444d02-f2d9-4911-9526-0404763ed084',37,'84f71f6076f7425db7653ac203257df0','volumes',-1,'2025-10-03 12:21:39',NULL),('2025-10-02 12:21:39','2025-10-02 12:21:39','2025-10-02 12:21:39',1,122,'7491ddd7-d46c-4e0f-9842-1a368e1261c7',38,'84f71f6076f7425db7653ac203257df0','gigabytes',-1,'2025-10-03 12:21:39',NULL),('2025-10-02 12:21:39','2025-10-02 12:21:39','2025-10-02 12:21:39',1,123,'da43b637-f407-484a-a86e-653b7f7f5371',39,'84f71f6076f7425db7653ac203257df0','volumes___DEFAULT__',-1,'2025-10-03 12:21:39',NULL),('2025-10-02 12:21:39','2025-10-02 12:21:39','2025-10-02 12:21:39',1,124,'5763bbd7-b45d-487f-a4c7-ea2edc60380e',40,'84f71f6076f7425db7653ac203257df0','gigabytes___DEFAULT__',-1,'2025-10-03 12:21:39',NULL),('2025-10-02 12:21:43','2025-10-02 12:21:43','2025-10-02 12:21:43',1,125,'01615bd6-9a77-4e39-b108-7a443131b036',37,'84f71f6076f7425db7653ac203257df0','volumes',-1,'2025-10-03 12:21:43',NULL),('2025-10-02 12:21:43','2025-10-02 12:21:43','2025-10-02 12:21:43',1,126,'ba635fff-ad60-458a-97ab-778a060f507f',38,'84f71f6076f7425db7653ac203257df0','gigabytes',-1,'2025-10-03 12:21:43',NULL),('2025-10-02 12:21:43','2025-10-02 12:21:43','2025-10-02 12:21:43',1,127,'be39e50d-8470-4bbd-9098-65bc4387fa0f',39,'84f71f6076f7425db7653ac203257df0','volumes___DEFAULT__',-1,'2025-10-03 12:21:43',NULL),('2025-10-02 12:21:43','2025-10-02 12:21:43','2025-10-02 12:21:43',1,128,'53b22b1d-9115-440e-a8e5-54dc9e6eaa2d',40,'84f71f6076f7425db7653ac203257df0','gigabytes___DEFAULT__',-1,'2025-10-03 12:21:43',NULL),('2025-10-02 12:21:46','2025-10-02 12:21:46','2025-10-02 12:21:46',1,129,'02525432-8c24-4916-9869-0d05ec89e942',37,'84f71f6076f7425db7653ac203257df0','volumes',-1,'2025-10-03 12:21:45',NULL),('2025-10-02 12:21:46','2025-10-02 12:21:46','2025-10-02 12:21:46',1,130,'a91de31e-61f2-4ff6-aa38-13b49b9bdc51',38,'84f71f6076f7425db7653ac203257df0','gigabytes',-1,'2025-10-03 12:21:45',NULL),('2025-10-02 12:21:46','2025-10-02 12:21:46','2025-10-02 12:21:46',1,131,'c475b588-0ef1-458e-8290-af12a440d1f8',39,'84f71f6076f7425db7653ac203257df0','volumes___DEFAULT__',-1,'2025-10-03 12:21:45',NULL),('2025-10-02 12:21:46','2025-10-02 12:21:46','2025-10-02 12:21:46',1,132,'af3192ad-8c7f-4808-90ec-9973f8c9e187',40,'84f71f6076f7425db7653ac203257df0','gigabytes___DEFAULT__',-1,'2025-10-03 12:21:45',NULL),('2025-10-02 12:22:27','2025-10-02 12:22:27','2025-10-02 12:22:27',1,133,'9c79d815-d071-4a69-9da0-d17ef1b50972',45,'c740a14d1c5c45d1a0959b0e24ac460b','volumes',1,'2025-10-03 12:22:26',NULL),('2025-10-02 12:22:27','2025-10-02 12:22:27','2025-10-02 12:22:27',1,134,'d7e82530-7240-4d6c-a0b5-6a773664cf78',46,'c740a14d1c5c45d1a0959b0e24ac460b','gigabytes',1,'2025-10-03 12:22:26',NULL),('2025-10-02 12:22:27','2025-10-02 12:22:27','2025-10-02 12:22:27',1,135,'c7c4ef5c-1d6c-468f-b5ac-e33fcbe609b1',47,'c740a14d1c5c45d1a0959b0e24ac460b','volumes___DEFAULT__',1,'2025-10-03 12:22:26',NULL),('2025-10-02 12:22:27','2025-10-02 12:22:27','2025-10-02 12:22:27',1,136,'195dbc4f-c075-437f-966e-7ffc9d762e18',48,'c740a14d1c5c45d1a0959b0e24ac460b','gigabytes___DEFAULT__',1,'2025-10-03 12:22:26',NULL),('2025-10-02 12:22:31','2025-10-02 12:22:31','2025-10-02 12:22:31',1,137,'5a892766-65d1-4d56-b9a7-b712e5610f8f',45,'c740a14d1c5c45d1a0959b0e24ac460b','volumes',1,'2025-10-03 12:22:31',NULL),('2025-10-02 12:22:31','2025-10-02 12:22:31','2025-10-02 12:22:31',1,138,'61b72275-a887-4573-8b03-4662a6dab579',46,'c740a14d1c5c45d1a0959b0e24ac460b','gigabytes',1,'2025-10-03 12:22:31',NULL),('2025-10-02 12:22:31','2025-10-02 12:22:31','2025-10-02 12:22:31',1,139,'a3203a44-f3ef-4214-8b7d-484649743cd9',47,'c740a14d1c5c45d1a0959b0e24ac460b','volumes___DEFAULT__',1,'2025-10-03 12:22:31',NULL),('2025-10-02 12:22:31','2025-10-02 12:22:31','2025-10-02 12:22:31',1,140,'3c080ae3-0479-4870-a3aa-6053de8cce2f',48,'c740a14d1c5c45d1a0959b0e24ac460b','gigabytes___DEFAULT__',1,'2025-10-03 12:22:31',NULL),('2025-10-02 12:23:02','2025-10-02 12:23:02','2025-10-02 12:23:02',1,141,'81533341-a3d9-4337-a6b3-1a87476a1de0',49,'10fff81da7a54740a53a0771ce916329','volumes',1,'2025-10-03 12:23:02',NULL),('2025-10-02 12:23:02','2025-10-02 12:23:02','2025-10-02 12:23:02',1,142,'29bc66aa-7045-457b-8c07-8c4a169a3d86',50,'10fff81da7a54740a53a0771ce916329','gigabytes',1,'2025-10-03 12:23:02',NULL),('2025-10-02 12:23:02','2025-10-02 12:23:02','2025-10-02 12:23:02',1,143,'aa03033d-c3bd-4e5c-bf13-af5480ae098e',51,'10fff81da7a54740a53a0771ce916329','volumes___DEFAULT__',1,'2025-10-03 12:23:02',NULL),('2025-10-02 12:23:02','2025-10-02 12:23:02','2025-10-02 12:23:02',1,144,'0b49a60a-56cb-43ee-9485-14b40b323b8f',52,'10fff81da7a54740a53a0771ce916329','gigabytes___DEFAULT__',1,'2025-10-03 12:23:02',NULL),('2025-10-02 12:24:14','2025-10-02 12:24:14','2025-10-02 12:24:14',1,145,'e4603b2b-bc45-4135-b783-33359ce7afc2',41,'1c2c11ebecb14f3188f35ea473c4ca02','volumes',-1,'2025-10-03 12:24:14',NULL),('2025-10-02 12:24:14','2025-10-02 12:24:14','2025-10-02 12:24:14',1,146,'3afeb81c-cba5-4f98-b11d-b8c4c339fb5f',42,'1c2c11ebecb14f3188f35ea473c4ca02','gigabytes',-1,'2025-10-03 12:24:14',NULL),('2025-10-02 12:24:14','2025-10-02 12:24:15','2025-10-02 12:24:15',1,147,'98aec6ee-3313-42ec-824a-dc36680fc56f',43,'1c2c11ebecb14f3188f35ea473c4ca02','volumes___DEFAULT__',-1,'2025-10-03 12:24:14',NULL),('2025-10-02 12:24:14','2025-10-02 12:24:15','2025-10-02 12:24:15',1,148,'f208f1ff-4f6a-40a9-a875-2e11308d7619',44,'1c2c11ebecb14f3188f35ea473c4ca02','gigabytes___DEFAULT__',-1,'2025-10-03 12:24:14',NULL),('2025-10-02 12:24:27','2025-10-02 12:24:27','2025-10-02 12:24:27',1,149,'31bb5cb3-5111-4048-8079-a02065e40be9',45,'c740a14d1c5c45d1a0959b0e24ac460b','volumes',-1,'2025-10-03 12:24:27',NULL),('2025-10-02 12:24:27','2025-10-02 12:24:27','2025-10-02 12:24:27',1,150,'7b355107-f15d-4649-957b-074d0affc0ae',46,'c740a14d1c5c45d1a0959b0e24ac460b','gigabytes',-1,'2025-10-03 12:24:27',NULL),('2025-10-02 12:24:27','2025-10-02 12:24:27','2025-10-02 12:24:27',1,151,'57641085-3e69-44dd-8915-bc61c76d4e78',47,'c740a14d1c5c45d1a0959b0e24ac460b','volumes___DEFAULT__',-1,'2025-10-03 12:24:27',NULL),('2025-10-02 12:24:27','2025-10-02 12:24:27','2025-10-02 12:24:27',1,152,'1b219875-623a-4855-93fb-dde21279033f',48,'c740a14d1c5c45d1a0959b0e24ac460b','gigabytes___DEFAULT__',-1,'2025-10-03 12:24:27',NULL),('2025-10-02 12:24:28','2025-10-02 12:24:28','2025-10-02 12:24:28',1,153,'9f24d487-fcab-4a93-94ce-7e23948ba940',45,'c740a14d1c5c45d1a0959b0e24ac460b','volumes',-1,'2025-10-03 12:24:28',NULL),('2025-10-02 12:24:28','2025-10-02 12:24:28','2025-10-02 12:24:28',1,154,'1488eb80-ad77-4fd6-a91b-a5e5c38619fb',46,'c740a14d1c5c45d1a0959b0e24ac460b','gigabytes',-1,'2025-10-03 12:24:28',NULL),('2025-10-02 12:24:28','2025-10-02 12:24:28','2025-10-02 12:24:28',1,155,'d87475c6-d26b-475e-bdbe-45163360074e',47,'c740a14d1c5c45d1a0959b0e24ac460b','volumes___DEFAULT__',-1,'2025-10-03 12:24:28',NULL),('2025-10-02 12:24:28','2025-10-02 12:24:28','2025-10-02 12:24:28',1,156,'15bedab2-c817-4e74-aaa1-c09d5cae2ff6',48,'c740a14d1c5c45d1a0959b0e24ac460b','gigabytes___DEFAULT__',-1,'2025-10-03 12:24:28',NULL),('2025-10-02 12:24:42','2025-10-02 12:24:42','2025-10-02 12:24:42',1,157,'aad17301-4b70-4e19-a6e3-577d7be9af20',53,'d5bedc1d8125465b92c98f9ebeb80ddb','volumes',1,'2025-10-03 12:24:42',NULL),('2025-10-02 12:24:42','2025-10-02 12:24:42','2025-10-02 12:24:42',1,158,'49cbeb96-83d5-43b3-bda9-cb93d0f01b9a',54,'d5bedc1d8125465b92c98f9ebeb80ddb','gigabytes',1,'2025-10-03 12:24:42',NULL),('2025-10-02 12:24:42','2025-10-02 12:24:42','2025-10-02 12:24:42',1,159,'c9a070b6-525b-40a4-a57e-ca77586ec624',55,'d5bedc1d8125465b92c98f9ebeb80ddb','volumes___DEFAULT__',1,'2025-10-03 12:24:42',NULL),('2025-10-02 12:24:42','2025-10-02 12:24:42','2025-10-02 12:24:42',1,160,'3dbf59fb-406a-44a7-aade-d3a879f48628',56,'d5bedc1d8125465b92c98f9ebeb80ddb','gigabytes___DEFAULT__',1,'2025-10-03 12:24:42',NULL),('2025-10-02 12:26:17','2025-10-02 12:26:17','2025-10-02 12:26:17',1,161,'4b42eced-374d-4c85-8a25-e8f6e2154f23',53,'d5bedc1d8125465b92c98f9ebeb80ddb','volumes',-1,'2025-10-03 12:26:17',NULL),('2025-10-02 12:26:17','2025-10-02 12:26:17','2025-10-02 12:26:17',1,162,'0c2f348f-3f77-40d6-b06b-28318effad48',54,'d5bedc1d8125465b92c98f9ebeb80ddb','gigabytes',-1,'2025-10-03 12:26:17',NULL),('2025-10-02 12:26:17','2025-10-02 12:26:17','2025-10-02 12:26:17',1,163,'de3b8f1a-3869-471f-a9c3-353f4fa27fa5',55,'d5bedc1d8125465b92c98f9ebeb80ddb','volumes___DEFAULT__',-1,'2025-10-03 12:26:17',NULL),('2025-10-02 12:26:17','2025-10-02 12:26:17','2025-10-02 12:26:17',1,164,'6fe8963d-220f-4b03-a7d4-9e95de1395a5',56,'d5bedc1d8125465b92c98f9ebeb80ddb','gigabytes___DEFAULT__',-1,'2025-10-03 12:26:17',NULL),('2025-10-02 12:26:27','2025-10-02 12:26:27','2025-10-02 12:26:27',1,165,'e917e397-ca53-47d1-9e8e-a45374bca5b0',49,'10fff81da7a54740a53a0771ce916329','volumes',-1,'2025-10-03 12:26:27',NULL),('2025-10-02 12:26:27','2025-10-02 12:26:27','2025-10-02 12:26:27',1,166,'6ff69d46-14b8-41f3-a5cb-59d35776217b',50,'10fff81da7a54740a53a0771ce916329','gigabytes',-1,'2025-10-03 12:26:27',NULL),('2025-10-02 12:26:27','2025-10-02 12:26:27','2025-10-02 12:26:27',1,167,'1636219e-c98f-473b-a47e-5620e16f9d1d',51,'10fff81da7a54740a53a0771ce916329','volumes___DEFAULT__',-1,'2025-10-03 12:26:27',NULL),('2025-10-02 12:26:27','2025-10-02 12:26:27','2025-10-02 12:26:27',1,168,'d56e5741-7cd7-44c6-820f-55c3cba9da2a',52,'10fff81da7a54740a53a0771ce916329','gigabytes___DEFAULT__',-1,'2025-10-03 12:26:27',NULL),('2025-10-02 12:26:42','2025-10-02 12:26:42','2025-10-02 12:26:42',1,169,'484f0cbd-e7d3-4cff-9ed8-392f3ff296e1',57,'5533aaac08cd4856af72ef4992bb5e76','volumes',1,'2025-10-03 12:26:42',NULL),('2025-10-02 12:26:42','2025-10-02 12:26:42','2025-10-02 12:26:42',1,170,'239d8743-1577-44e0-90f4-81fb89d4f884',58,'5533aaac08cd4856af72ef4992bb5e76','gigabytes',1,'2025-10-03 12:26:42',NULL),('2025-10-02 12:26:42','2025-10-02 12:26:42','2025-10-02 12:26:42',1,171,'529a8561-247f-4cd8-bf20-bd98ceb58ad3',59,'5533aaac08cd4856af72ef4992bb5e76','volumes_multiattach',1,'2025-10-03 12:26:42',NULL),('2025-10-02 12:26:42','2025-10-02 12:26:42','2025-10-02 12:26:42',1,172,'20e30a24-e332-4398-976a-073ff42419db',60,'5533aaac08cd4856af72ef4992bb5e76','gigabytes_multiattach',1,'2025-10-03 12:26:42',NULL),('2025-10-02 12:27:08','2025-10-02 12:27:08','2025-10-02 12:27:08',1,173,'8dff153c-2a3e-4126-ae27-c905bd8fab1c',61,'7aad01ba5df14c1a9309451d0daaab83','volumes',1,'2025-10-03 12:27:06',NULL),('2025-10-02 12:27:08','2025-10-02 12:27:08','2025-10-02 12:27:08',1,174,'f0a6bae5-d7e3-4429-8f04-d9410ba4e1ca',62,'7aad01ba5df14c1a9309451d0daaab83','gigabytes',1,'2025-10-03 12:27:06',NULL),('2025-10-02 12:27:08','2025-10-02 12:27:08','2025-10-02 12:27:08',1,175,'926f38bd-dd54-4648-9d34-000aefb23b12',63,'7aad01ba5df14c1a9309451d0daaab83','volumes___DEFAULT__',1,'2025-10-03 12:27:06',NULL),('2025-10-02 12:27:08','2025-10-02 12:27:08','2025-10-02 12:27:08',1,176,'1c01c9bb-fb1a-40a8-b3a1-8f4bf5dc35d8',64,'7aad01ba5df14c1a9309451d0daaab83','gigabytes___DEFAULT__',1,'2025-10-03 12:27:06',NULL),('2025-10-02 12:28:58','2025-10-02 12:29:01','2025-10-02 12:29:01',1,177,'f0b42680-d7a3-4182-abc4-fbd09c7dd748',57,'5533aaac08cd4856af72ef4992bb5e76','volumes',1,'2025-10-03 12:28:58',NULL),('2025-10-02 12:28:58','2025-10-02 12:29:01','2025-10-02 12:29:01',1,178,'f50a6e9c-01f7-4d7e-afed-e266376d80ed',58,'5533aaac08cd4856af72ef4992bb5e76','gigabytes',1,'2025-10-03 12:28:58',NULL),('2025-10-02 12:28:58','2025-10-02 12:29:01','2025-10-02 12:29:01',1,179,'f52bd2dc-0824-4a42-8d37-f765b45590dd',59,'5533aaac08cd4856af72ef4992bb5e76','volumes_multiattach',1,'2025-10-03 12:28:58',NULL),('2025-10-02 12:28:58','2025-10-02 12:29:01','2025-10-02 12:29:01',1,180,'047333a5-8bad-4903-97ee-62f85f06ea84',60,'5533aaac08cd4856af72ef4992bb5e76','gigabytes_multiattach',1,'2025-10-03 12:28:58',NULL),('2025-10-02 12:29:43','2025-10-02 12:29:43','2025-10-02 12:29:43',1,181,'c7531d2d-d96d-457b-a214-44b718b68c61',61,'7aad01ba5df14c1a9309451d0daaab83','volumes',-1,'2025-10-03 12:29:43',NULL),('2025-10-02 12:29:43','2025-10-02 12:29:43','2025-10-02 12:29:43',1,182,'594a3446-6740-49dd-a679-367c196cf9bb',62,'7aad01ba5df14c1a9309451d0daaab83','gigabytes',-1,'2025-10-03 12:29:43',NULL),('2025-10-02 12:29:43','2025-10-02 12:29:43','2025-10-02 12:29:43',1,183,'b7b36480-2c6d-455e-8a64-1626076f4cee',63,'7aad01ba5df14c1a9309451d0daaab83','volumes___DEFAULT__',-1,'2025-10-03 12:29:43',NULL),('2025-10-02 12:29:43','2025-10-02 12:29:43','2025-10-02 12:29:43',1,184,'6890a36b-71cd-4729-bf6b-a56e1dd2116f',64,'7aad01ba5df14c1a9309451d0daaab83','gigabytes___DEFAULT__',-1,'2025-10-03 12:29:43',NULL),('2025-10-02 12:30:29','2025-10-02 12:30:29','2025-10-02 12:30:29',1,185,'292deebe-94bd-40b6-87b4-31fc882ce602',57,'5533aaac08cd4856af72ef4992bb5e76','volumes',1,'2025-10-03 12:30:29',NULL),('2025-10-02 12:30:29','2025-10-02 12:30:29','2025-10-02 12:30:29',1,186,'8c6a6d9c-616d-4fda-8246-fa8773f1aadd',58,'5533aaac08cd4856af72ef4992bb5e76','gigabytes',1,'2025-10-03 12:30:29',NULL),('2025-10-02 12:30:29','2025-10-02 12:30:29','2025-10-02 12:30:29',1,187,'08d81ca3-1229-41e4-8a2a-94f4d93f9ead',59,'5533aaac08cd4856af72ef4992bb5e76','volumes_multiattach',1,'2025-10-03 12:30:29',NULL),('2025-10-02 12:30:29','2025-10-02 12:30:29','2025-10-02 12:30:29',1,188,'e0edb5d9-f42b-49e0-a227-22ae65024d49',60,'5533aaac08cd4856af72ef4992bb5e76','gigabytes_multiattach',1,'2025-10-03 12:30:29',NULL),('2025-10-02 12:32:14','2025-10-02 12:32:15','2025-10-02 12:32:15',1,189,'d2d6e51f-70c3-4d34-83f3-29b78d4defd3',57,'5533aaac08cd4856af72ef4992bb5e76','volumes',1,'2025-10-03 12:32:14',NULL),('2025-10-02 12:32:14','2025-10-02 12:32:15','2025-10-02 12:32:15',1,190,'f0a64c5d-65e6-454f-b262-beae14b379d9',58,'5533aaac08cd4856af72ef4992bb5e76','gigabytes',1,'2025-10-03 12:32:14',NULL),('2025-10-02 12:32:14','2025-10-02 12:32:15','2025-10-02 12:32:15',1,191,'9315d055-eff6-4ffd-b744-2020f8ce63aa',59,'5533aaac08cd4856af72ef4992bb5e76','volumes_multiattach',1,'2025-10-03 12:32:14',NULL),('2025-10-02 12:32:14','2025-10-02 12:32:15','2025-10-02 12:32:15',1,192,'8272dc6b-d090-48b4-988c-2d747c89ae6b',60,'5533aaac08cd4856af72ef4992bb5e76','gigabytes_multiattach',1,'2025-10-03 12:32:14',NULL),('2025-10-02 12:32:39','2025-10-02 12:32:39','2025-10-02 12:32:39',1,193,'13d70211-dbf7-4fa6-a4f1-594dddd85b63',65,'5533aaac08cd4856af72ef4992bb5e76','snapshots',1,'2025-10-03 12:32:39',NULL),('2025-10-02 12:32:39','2025-10-02 12:32:39','2025-10-02 12:32:39',1,194,'ca11fda2-1195-4459-8f3d-6199b2f7d023',58,'5533aaac08cd4856af72ef4992bb5e76','gigabytes',1,'2025-10-03 12:32:39',NULL),('2025-10-02 12:32:39','2025-10-02 12:32:39','2025-10-02 12:32:39',1,195,'41d31956-d03a-414a-bd58-db1ce1c6d6b2',60,'5533aaac08cd4856af72ef4992bb5e76','gigabytes_multiattach',1,'2025-10-03 12:32:39',NULL),('2025-10-02 12:32:39','2025-10-02 12:32:39','2025-10-02 12:32:39',1,196,'2ac05310-9d22-4b06-bf44-e8e9c3b5cee6',66,'5533aaac08cd4856af72ef4992bb5e76','snapshots_multiattach',1,'2025-10-03 12:32:39',NULL),('2025-10-02 12:32:48','2025-10-02 12:32:48','2025-10-02 12:32:48',1,197,'613430a2-cefc-490f-b35c-da4ab61e9393',65,'5533aaac08cd4856af72ef4992bb5e76','snapshots',-1,'2025-10-03 12:32:48',NULL),('2025-10-02 12:32:48','2025-10-02 12:32:48','2025-10-02 12:32:48',1,198,'0fbd9c7d-b987-4df9-899f-92b229c02f60',58,'5533aaac08cd4856af72ef4992bb5e76','gigabytes',-1,'2025-10-03 12:32:48',NULL),('2025-10-02 12:32:48','2025-10-02 12:32:48','2025-10-02 12:32:48',1,199,'ccd9a184-122e-4049-9f3e-3e92caf8dd6d',60,'5533aaac08cd4856af72ef4992bb5e76','gigabytes_multiattach',-1,'2025-10-03 12:32:48',NULL),('2025-10-02 12:32:48','2025-10-02 12:32:48','2025-10-02 12:32:48',1,200,'95adb5d6-1cbd-47fc-8f5c-c650605d7684',66,'5533aaac08cd4856af72ef4992bb5e76','snapshots_multiattach',-1,'2025-10-03 12:32:48',NULL),('2025-10-02 12:32:49','2025-10-02 12:32:49','2025-10-02 12:32:49',1,201,'a0a042e6-109e-44b4-84ac-633c36c69d59',57,'5533aaac08cd4856af72ef4992bb5e76','volumes',-1,'2025-10-03 12:32:49',NULL),('2025-10-02 12:32:49','2025-10-02 12:32:49','2025-10-02 12:32:49',1,202,'b082ac5a-5a04-4649-8087-c8eec3ee0e6d',58,'5533aaac08cd4856af72ef4992bb5e76','gigabytes',-1,'2025-10-03 12:32:49',NULL),('2025-10-02 12:32:49','2025-10-02 12:32:49','2025-10-02 12:32:49',1,203,'debde9b6-670c-4222-82a9-a9787a6c4479',59,'5533aaac08cd4856af72ef4992bb5e76','volumes_multiattach',-1,'2025-10-03 12:32:49',NULL),('2025-10-02 12:32:49','2025-10-02 12:32:49','2025-10-02 12:32:49',1,204,'e5ebc833-ec4c-4ef3-a3f8-155fd2a076d3',60,'5533aaac08cd4856af72ef4992bb5e76','gigabytes_multiattach',-1,'2025-10-03 12:32:49',NULL),('2025-10-02 12:32:55','2025-10-02 12:32:55','2025-10-02 12:32:55',1,205,'3a4e22f0-051f-48ee-b832-713b09ccd705',57,'5533aaac08cd4856af72ef4992bb5e76','volumes',-1,'2025-10-03 12:32:55',NULL),('2025-10-02 12:32:55','2025-10-02 12:32:55','2025-10-02 12:32:55',1,206,'22fcb909-4ab1-42a6-824f-822b363c2dda',58,'5533aaac08cd4856af72ef4992bb5e76','gigabytes',-1,'2025-10-03 12:32:55',NULL),('2025-10-02 12:32:55','2025-10-02 12:32:55','2025-10-02 12:32:55',1,207,'b40b56e2-d132-408a-b9ba-50b2d94ac868',59,'5533aaac08cd4856af72ef4992bb5e76','volumes_multiattach',-1,'2025-10-03 12:32:55',NULL),('2025-10-02 12:32:55','2025-10-02 12:32:55','2025-10-02 12:32:55',1,208,'929b3cbf-8e62-4140-8739-478e115b2eb3',60,'5533aaac08cd4856af72ef4992bb5e76','gigabytes_multiattach',-1,'2025-10-03 12:32:55',NULL),('2025-10-02 12:33:17','2025-10-02 12:33:17','2025-10-02 12:33:17',1,209,'218ddb6b-9cbc-4395-8b3d-bd0c44b65fa2',57,'5533aaac08cd4856af72ef4992bb5e76','volumes',-1,'2025-10-03 12:33:17',NULL),('2025-10-02 12:33:17','2025-10-02 12:33:17','2025-10-02 12:33:17',1,210,'5457dcfd-7944-4111-8a46-1dcd42ab5159',58,'5533aaac08cd4856af72ef4992bb5e76','gigabytes',-1,'2025-10-03 12:33:17',NULL),('2025-10-02 12:33:17','2025-10-02 12:33:17','2025-10-02 12:33:17',1,211,'66f0aa4a-7009-4e08-8e5f-1b5c5f088580',59,'5533aaac08cd4856af72ef4992bb5e76','volumes_multiattach',-1,'2025-10-03 12:33:17',NULL),('2025-10-02 12:33:17','2025-10-02 12:33:17','2025-10-02 12:33:17',1,212,'fa77c538-2511-4b23-9083-74746fb0b0a4',60,'5533aaac08cd4856af72ef4992bb5e76','gigabytes_multiattach',-1,'2025-10-03 12:33:17',NULL),('2025-10-02 12:33:38','2025-10-02 12:33:38','2025-10-02 12:33:38',1,213,'72e61ed7-6cab-461c-940e-6c81252e0e70',57,'5533aaac08cd4856af72ef4992bb5e76','volumes',-1,'2025-10-03 12:33:38',NULL),('2025-10-02 12:33:38','2025-10-02 12:33:38','2025-10-02 12:33:38',1,214,'ec9450e9-d27d-4d7a-b208-c28427f9da5a',58,'5533aaac08cd4856af72ef4992bb5e76','gigabytes',-1,'2025-10-03 12:33:38',NULL),('2025-10-02 12:33:38','2025-10-02 12:33:38','2025-10-02 12:33:38',1,215,'c10abe2e-9564-4685-848a-dcffbc8220ad',59,'5533aaac08cd4856af72ef4992bb5e76','volumes_multiattach',-1,'2025-10-03 12:33:38',NULL),('2025-10-02 12:33:38','2025-10-02 12:33:38','2025-10-02 12:33:38',1,216,'a1b3a13b-1498-4ad9-821b-df3149e594f4',60,'5533aaac08cd4856af72ef4992bb5e76','gigabytes_multiattach',-1,'2025-10-03 12:33:38',NULL),('2025-10-02 12:33:39','2025-10-02 12:33:39','2025-10-02 12:33:39',1,217,'ff8cd7d7-bc95-4c57-8b5c-b6d7dc7e7718',67,'cc4d8f857b2d42bf9ae477fc5f514216','volumes',1,'2025-10-03 12:33:39',NULL),('2025-10-02 12:33:39','2025-10-02 12:33:39','2025-10-02 12:33:39',1,218,'eff24bd5-8cc6-40f4-b81f-84a966dc9fb4',68,'cc4d8f857b2d42bf9ae477fc5f514216','gigabytes',1,'2025-10-03 12:33:39',NULL),('2025-10-02 12:33:39','2025-10-02 12:33:39','2025-10-02 12:33:39',1,219,'0f8f3406-558d-4a63-97f1-393e1970026a',69,'cc4d8f857b2d42bf9ae477fc5f514216','volumes___DEFAULT__',1,'2025-10-03 12:33:39',NULL),('2025-10-02 12:33:39','2025-10-02 12:33:40','2025-10-02 12:33:40',1,220,'d575792c-b96a-4553-8e7e-cd584292e9e7',70,'cc4d8f857b2d42bf9ae477fc5f514216','gigabytes___DEFAULT__',1,'2025-10-03 12:33:39',NULL),('2025-10-02 12:34:06','2025-10-02 12:34:06','2025-10-02 12:34:06',1,221,'f0478ec0-5526-4c80-bedd-e45b5eeba47a',67,'cc4d8f857b2d42bf9ae477fc5f514216','volumes',1,'2025-10-03 12:34:06',NULL),('2025-10-02 12:34:06','2025-10-02 12:34:06','2025-10-02 12:34:06',1,222,'c8a612cb-aa64-41a8-9cf2-f8f19f93a43a',68,'cc4d8f857b2d42bf9ae477fc5f514216','gigabytes',1,'2025-10-03 12:34:06',NULL),('2025-10-02 12:34:06','2025-10-02 12:34:06','2025-10-02 12:34:06',1,223,'08190698-689f-48d3-946f-d8b8b4f55f56',69,'cc4d8f857b2d42bf9ae477fc5f514216','volumes___DEFAULT__',1,'2025-10-03 12:34:06',NULL),('2025-10-02 12:34:06','2025-10-02 12:34:06','2025-10-02 12:34:06',1,224,'b953997c-7355-420a-b71c-1b7309461081',70,'cc4d8f857b2d42bf9ae477fc5f514216','gigabytes___DEFAULT__',1,'2025-10-03 12:34:06',NULL),('2025-10-02 12:34:41','2025-10-02 12:34:41','2025-10-02 12:34:41',1,225,'796ab420-f559-4812-9e69-313ec3049b83',71,'1a05e525420b4aa8adcc9561158e73d1','volumes',1,'2025-10-03 12:34:41',NULL),('2025-10-02 12:34:41','2025-10-02 12:34:41','2025-10-02 12:34:41',1,226,'fcd8e722-3628-4734-b445-b80f1c1fa64f',72,'1a05e525420b4aa8adcc9561158e73d1','gigabytes',1,'2025-10-03 12:34:41',NULL),('2025-10-02 12:34:41','2025-10-02 12:34:41','2025-10-02 12:34:41',1,227,'4cd26e06-bdce-4c13-9b1d-289df0d86377',73,'1a05e525420b4aa8adcc9561158e73d1','volumes___DEFAULT__',1,'2025-10-03 12:34:41',NULL),('2025-10-02 12:34:41','2025-10-02 12:34:41','2025-10-02 12:34:41',1,228,'b1df45f0-66ea-4a0f-96d1-3e10f3e134d0',74,'1a05e525420b4aa8adcc9561158e73d1','gigabytes___DEFAULT__',1,'2025-10-03 12:34:41',NULL),('2025-10-02 12:36:33','2025-10-02 12:36:33','2025-10-02 12:36:33',1,229,'c842b2cd-05cf-47cf-bcff-60e5a16bb685',67,'cc4d8f857b2d42bf9ae477fc5f514216','volumes',-1,'2025-10-03 12:36:33',NULL),('2025-10-02 12:36:33','2025-10-02 12:36:33','2025-10-02 12:36:33',1,230,'203d679e-2613-4387-b010-33f756407733',68,'cc4d8f857b2d42bf9ae477fc5f514216','gigabytes',-1,'2025-10-03 12:36:33',NULL),('2025-10-02 12:36:33','2025-10-02 12:36:33','2025-10-02 12:36:33',1,231,'185a04d5-3528-44cb-8da7-485daae3f499',69,'cc4d8f857b2d42bf9ae477fc5f514216','volumes___DEFAULT__',-1,'2025-10-03 12:36:33',NULL),('2025-10-02 12:36:33','2025-10-02 12:36:33','2025-10-02 12:36:33',1,232,'6aabbfe0-4902-4722-bba3-e2ad50184850',70,'cc4d8f857b2d42bf9ae477fc5f514216','gigabytes___DEFAULT__',-1,'2025-10-03 12:36:33',NULL),('2025-10-02 12:36:40','2025-10-02 12:36:40','2025-10-02 12:36:40',1,233,'64ff7395-ead7-4dd6-9c24-9b79923f0b7c',67,'cc4d8f857b2d42bf9ae477fc5f514216','volumes',-1,'2025-10-03 12:36:40',NULL),('2025-10-02 12:36:40','2025-10-02 12:36:40','2025-10-02 12:36:40',1,234,'c89b7064-75ee-495e-b39f-0b18312fade7',68,'cc4d8f857b2d42bf9ae477fc5f514216','gigabytes',-1,'2025-10-03 12:36:40',NULL),('2025-10-02 12:36:40','2025-10-02 12:36:40','2025-10-02 12:36:40',1,235,'61d743c5-33c2-4895-aebb-1ea35da73118',69,'cc4d8f857b2d42bf9ae477fc5f514216','volumes___DEFAULT__',-1,'2025-10-03 12:36:40',NULL),('2025-10-02 12:36:40','2025-10-02 12:36:40','2025-10-02 12:36:40',1,236,'6b8ff040-c0b4-4a26-826d-1a4aa0e487d2',70,'cc4d8f857b2d42bf9ae477fc5f514216','gigabytes___DEFAULT__',-1,'2025-10-03 12:36:40',NULL),('2025-10-02 12:37:24','2025-10-02 12:37:24','2025-10-02 12:37:24',1,237,'c65fe1ac-ea43-4086-8e06-32c6d9a98e7a',71,'1a05e525420b4aa8adcc9561158e73d1','volumes',1,'2025-10-03 12:37:24',NULL),('2025-10-02 12:37:24','2025-10-02 12:37:24','2025-10-02 12:37:24',1,238,'a1a14f58-1438-451c-aa79-3e6eab035740',72,'1a05e525420b4aa8adcc9561158e73d1','gigabytes',1,'2025-10-03 12:37:24',NULL),('2025-10-02 12:37:24','2025-10-02 12:37:24','2025-10-02 12:37:24',1,239,'68919b7f-872e-4a7b-8111-ff11cbfa9b2b',73,'1a05e525420b4aa8adcc9561158e73d1','volumes___DEFAULT__',1,'2025-10-03 12:37:24',NULL),('2025-10-02 12:37:24','2025-10-02 12:37:24','2025-10-02 12:37:24',1,240,'7bc1a7a9-c6f8-4e5a-9026-052d096b2d5c',74,'1a05e525420b4aa8adcc9561158e73d1','gigabytes___DEFAULT__',1,'2025-10-03 12:37:24',NULL),('2025-10-02 12:38:32','2025-10-02 12:38:32','2025-10-02 12:38:32',1,241,'4b3a3b69-7fb5-4511-847d-041afa91ade4',75,'6822f02d5ca04c659329a75d487054cf','volumes',1,'2025-10-03 12:38:32',NULL),('2025-10-02 12:38:32','2025-10-02 12:38:32','2025-10-02 12:38:32',1,242,'45e7d385-040e-4ee5-a160-27259554e2b5',76,'6822f02d5ca04c659329a75d487054cf','gigabytes',1,'2025-10-03 12:38:32',NULL),('2025-10-02 12:38:32','2025-10-02 12:38:32','2025-10-02 12:38:32',1,243,'7a7c513b-3714-42dd-864f-b3f0d2341ded',77,'6822f02d5ca04c659329a75d487054cf','volumes___DEFAULT__',1,'2025-10-03 12:38:32',NULL),('2025-10-02 12:38:32','2025-10-02 12:38:32','2025-10-02 12:38:32',1,244,'319da575-cd25-427d-bf51-97e0127868c1',78,'6822f02d5ca04c659329a75d487054cf','gigabytes___DEFAULT__',1,'2025-10-03 12:38:32',NULL),('2025-10-02 12:38:41','2025-10-02 12:38:41','2025-10-02 12:38:41',1,245,'42be7ed9-fa88-46b6-b9e2-daa593f4dd29',71,'1a05e525420b4aa8adcc9561158e73d1','volumes',-1,'2025-10-03 12:38:41',NULL),('2025-10-02 12:38:41','2025-10-02 12:38:41','2025-10-02 12:38:41',1,246,'78ebecb2-4ebd-47dc-8868-12bf93ad49e5',72,'1a05e525420b4aa8adcc9561158e73d1','gigabytes',-1,'2025-10-03 12:38:41',NULL),('2025-10-02 12:38:41','2025-10-02 12:38:41','2025-10-02 12:38:41',1,247,'98bf4815-9465-4631-a218-cde40a60b307',73,'1a05e525420b4aa8adcc9561158e73d1','volumes___DEFAULT__',-1,'2025-10-03 12:38:41',NULL),('2025-10-02 12:38:41','2025-10-02 12:38:41','2025-10-02 12:38:41',1,248,'8f474d2c-956d-4390-9b15-2d51069dcf5a',74,'1a05e525420b4aa8adcc9561158e73d1','gigabytes___DEFAULT__',-1,'2025-10-03 12:38:41',NULL),('2025-10-02 12:38:43','2025-10-02 12:38:43','2025-10-02 12:38:43',1,249,'8fae749b-7098-4eb4-9ab3-40df87d72c06',79,'1294b2ea04b34f7189fde66e2afa2c56','volumes',1,'2025-10-03 12:38:43',NULL),('2025-10-02 12:38:43','2025-10-02 12:38:43','2025-10-02 12:38:43',1,250,'8a670d95-b100-4c0f-9e7a-221803c354d2',80,'1294b2ea04b34f7189fde66e2afa2c56','gigabytes',1,'2025-10-03 12:38:43',NULL),('2025-10-02 12:38:43','2025-10-02 12:38:43','2025-10-02 12:38:43',1,251,'940a8374-aecb-4bd5-918d-6f5263f5e66e',81,'1294b2ea04b34f7189fde66e2afa2c56','volumes_tempest-scenario-type-luks-308158206',1,'2025-10-03 12:38:43',NULL),('2025-10-02 12:38:43','2025-10-02 12:38:43','2025-10-02 12:38:43',1,252,'cd91bac2-7205-46c2-a760-4de5135e4bb2',82,'1294b2ea04b34f7189fde66e2afa2c56','gigabytes_tempest-scenario-type-luks-308158206',1,'2025-10-03 12:38:43',NULL),('2025-10-02 12:38:44','2025-10-02 12:38:44','2025-10-02 12:38:44',1,253,'47992a7e-9c9b-4e67-a15d-f69c56ff8b2b',71,'1a05e525420b4aa8adcc9561158e73d1','volumes',-1,'2025-10-03 12:38:44',NULL),('2025-10-02 12:38:44','2025-10-02 12:38:44','2025-10-02 12:38:44',1,254,'90c3c614-b771-40d2-8293-2f2f3c20f2d6',72,'1a05e525420b4aa8adcc9561158e73d1','gigabytes',-1,'2025-10-03 12:38:44',NULL),('2025-10-02 12:38:44','2025-10-02 12:38:44','2025-10-02 12:38:44',1,255,'a580f96d-1c1b-47bf-92fe-dddcf487b399',73,'1a05e525420b4aa8adcc9561158e73d1','volumes___DEFAULT__',-1,'2025-10-03 12:38:44',NULL),('2025-10-02 12:38:44','2025-10-02 12:38:44','2025-10-02 12:38:44',1,256,'d4a1c30a-d7dd-40d5-965f-1d853ccfc2bc',74,'1a05e525420b4aa8adcc9561158e73d1','gigabytes___DEFAULT__',-1,'2025-10-03 12:38:44',NULL),('2025-10-02 12:38:55','2025-10-02 12:38:55','2025-10-02 12:38:55',1,257,'d259c4bb-d1ad-47b5-8fb3-6394f84c5ddb',83,'2a9fb2f388654380906f2a0db9d46565','volumes',1,'2025-10-03 12:38:55',NULL),('2025-10-02 12:38:55','2025-10-02 12:38:55','2025-10-02 12:38:55',1,258,'a21b9fb7-c948-4fb7-a5ae-3f872de11563',84,'2a9fb2f388654380906f2a0db9d46565','gigabytes',1,'2025-10-03 12:38:55',NULL),('2025-10-02 12:38:55','2025-10-02 12:38:55','2025-10-02 12:38:55',1,259,'393230b9-bea9-4980-8872-251f7ca2f3ac',85,'2a9fb2f388654380906f2a0db9d46565','volumes___DEFAULT__',1,'2025-10-03 12:38:55',NULL),('2025-10-02 12:38:55','2025-10-02 12:38:55','2025-10-02 12:38:55',1,260,'e4b75754-fd5c-4c18-9b50-8a747ee41134',86,'2a9fb2f388654380906f2a0db9d46565','gigabytes___DEFAULT__',1,'2025-10-03 12:38:55',NULL),('2025-10-02 12:38:57','2025-10-02 12:38:57','2025-10-02 12:38:57',1,261,'880db315-c45d-45cc-83c2-c49c0d42e0cf',87,'2a9fb2f388654380906f2a0db9d46565','snapshots',1,'2025-10-03 12:38:57',NULL),('2025-10-02 12:38:57','2025-10-02 12:38:57','2025-10-02 12:38:57',1,262,'95415fe0-02f7-4bba-8f77-455899fea669',84,'2a9fb2f388654380906f2a0db9d46565','gigabytes',1,'2025-10-03 12:38:57',NULL),('2025-10-02 12:38:57','2025-10-02 12:38:57','2025-10-02 12:38:57',1,263,'14158a30-614f-4d57-ad5b-11952e0bf97f',86,'2a9fb2f388654380906f2a0db9d46565','gigabytes___DEFAULT__',1,'2025-10-03 12:38:57',NULL),('2025-10-02 12:38:57','2025-10-02 12:38:57','2025-10-02 12:38:57',1,264,'706c4aa4-ca4d-482f-a392-d6a760c7343c',88,'2a9fb2f388654380906f2a0db9d46565','snapshots___DEFAULT__',1,'2025-10-03 12:38:57',NULL),('2025-10-02 12:39:16','2025-10-02 12:39:17','2025-10-02 12:39:17',1,265,'67a07d7e-ecdd-4759-92a6-adc7f8ca764e',87,'2a9fb2f388654380906f2a0db9d46565','snapshots',-1,'2025-10-03 12:39:16',NULL),('2025-10-02 12:39:16','2025-10-02 12:39:17','2025-10-02 12:39:17',1,266,'2bb2149e-61d7-43e3-a510-1792cc85ab40',84,'2a9fb2f388654380906f2a0db9d46565','gigabytes',-1,'2025-10-03 12:39:16',NULL),('2025-10-02 12:39:16','2025-10-02 12:39:17','2025-10-02 12:39:17',1,267,'208b5d1f-e30b-4856-a977-653cb4459e4b',86,'2a9fb2f388654380906f2a0db9d46565','gigabytes___DEFAULT__',-1,'2025-10-03 12:39:16',NULL),('2025-10-02 12:39:16','2025-10-02 12:39:17','2025-10-02 12:39:17',1,268,'bb3522a1-fd2f-49fc-98db-8cfc29f2f982',88,'2a9fb2f388654380906f2a0db9d46565','snapshots___DEFAULT__',-1,'2025-10-03 12:39:16',NULL),('2025-10-02 12:39:20','2025-10-02 12:39:20','2025-10-02 12:39:20',1,269,'5e5d5d4c-a2a4-409f-bcb9-151f18edb4b4',83,'2a9fb2f388654380906f2a0db9d46565','volumes',-1,'2025-10-03 12:39:20',NULL),('2025-10-02 12:39:20','2025-10-02 12:39:20','2025-10-02 12:39:20',1,270,'87707bce-87e9-402f-852b-d72b567aa693',84,'2a9fb2f388654380906f2a0db9d46565','gigabytes',-1,'2025-10-03 12:39:20',NULL),('2025-10-02 12:39:20','2025-10-02 12:39:20','2025-10-02 12:39:20',1,271,'a161e311-6c87-4f0f-8e4d-75386a751fc9',85,'2a9fb2f388654380906f2a0db9d46565','volumes___DEFAULT__',-1,'2025-10-03 12:39:20',NULL),('2025-10-02 12:39:20','2025-10-02 12:39:20','2025-10-02 12:39:20',1,272,'c9e00fe5-1381-4a83-9e33-45a48546329c',86,'2a9fb2f388654380906f2a0db9d46565','gigabytes___DEFAULT__',-1,'2025-10-03 12:39:20',NULL),('2025-10-02 12:40:19','2025-10-02 12:40:19','2025-10-02 12:40:19',1,273,'688d5a5b-8043-4025-81d7-168c0d2ab1d6',89,'a41d99312f014c65adddea4f70536a15','volumes',1,'2025-10-03 12:40:19',NULL),('2025-10-02 12:40:19','2025-10-02 12:40:19','2025-10-02 12:40:19',1,274,'fea1541f-dfc4-48c2-9042-6152b6e833fe',90,'a41d99312f014c65adddea4f70536a15','gigabytes',1,'2025-10-03 12:40:19',NULL),('2025-10-02 12:40:19','2025-10-02 12:40:19','2025-10-02 12:40:19',1,275,'c0e204c0-e977-4a60-a271-e41002851a21',91,'a41d99312f014c65adddea4f70536a15','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-250908576-499919160',1,'2025-10-03 12:40:19',NULL),('2025-10-02 12:40:19','2025-10-02 12:40:19','2025-10-02 12:40:19',1,276,'f6960c22-8647-4700-99b4-74750d240753',92,'a41d99312f014c65adddea4f70536a15','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-250908576-499919160',1,'2025-10-03 12:40:19',NULL),('2025-10-02 12:40:20','2025-10-02 12:40:20','2025-10-02 12:40:20',1,277,'c17aa065-383a-4c0f-9706-6ac46ecbdf9c',89,'a41d99312f014c65adddea4f70536a15','volumes',1,'2025-10-03 12:40:20',NULL),('2025-10-02 12:40:20','2025-10-02 12:40:20','2025-10-02 12:40:20',1,278,'c6868961-3895-4c66-b178-bf1b1a456a46',90,'a41d99312f014c65adddea4f70536a15','gigabytes',1,'2025-10-03 12:40:20',NULL),('2025-10-02 12:40:20','2025-10-02 12:40:20','2025-10-02 12:40:20',1,279,'000026c5-8326-4353-bc1d-c30ea101a201',93,'a41d99312f014c65adddea4f70536a15','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-278110967-1260666270',1,'2025-10-03 12:40:20',NULL),('2025-10-02 12:40:20','2025-10-02 12:40:20','2025-10-02 12:40:20',1,280,'84019dda-8671-466b-b2db-69568e6c8823',94,'a41d99312f014c65adddea4f70536a15','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-278110967-1260666270',1,'2025-10-03 12:40:20',NULL),('2025-10-02 12:40:20','2025-10-02 12:40:20','2025-10-02 12:40:20',1,281,'ab80bdbd-c8c1-4058-bcfb-54833e00a56e',89,'a41d99312f014c65adddea4f70536a15','volumes',1,'2025-10-03 12:40:20',NULL),('2025-10-02 12:40:20','2025-10-02 12:40:20','2025-10-02 12:40:20',1,282,'fc26da5a-af0e-4bce-87cb-a96432f82658',90,'a41d99312f014c65adddea4f70536a15','gigabytes',1,'2025-10-03 12:40:20',NULL),('2025-10-02 12:40:20','2025-10-02 12:40:20','2025-10-02 12:40:20',1,283,'d86fef22-440e-4896-b24c-0f34f2773e96',91,'a41d99312f014c65adddea4f70536a15','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-250908576-499919160',1,'2025-10-03 12:40:20',NULL),('2025-10-02 12:40:20','2025-10-02 12:40:20','2025-10-02 12:40:20',1,284,'d02df4db-804d-430a-8aa4-8a43ccf07d86',92,'a41d99312f014c65adddea4f70536a15','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-250908576-499919160',1,'2025-10-03 12:40:20',NULL),('2025-10-02 12:40:21','2025-10-02 12:40:22','2025-10-02 12:40:22',1,285,'235e02be-3bac-45f7-9124-3cffb69975dc',89,'a41d99312f014c65adddea4f70536a15','volumes',1,'2025-10-03 12:40:20',NULL),('2025-10-02 12:40:21','2025-10-02 12:40:22','2025-10-02 12:40:22',1,286,'6e87ed32-4b1c-42f3-a6ae-cb4a7bfe8156',90,'a41d99312f014c65adddea4f70536a15','gigabytes',1,'2025-10-03 12:40:20',NULL),('2025-10-02 12:40:21','2025-10-02 12:40:22','2025-10-02 12:40:22',1,287,'3e665988-8a59-41e0-9dad-ee3931ec53d1',93,'a41d99312f014c65adddea4f70536a15','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-278110967-1260666270',1,'2025-10-03 12:40:20',NULL),('2025-10-02 12:40:21','2025-10-02 12:40:22','2025-10-02 12:40:22',1,288,'03801537-192c-4e76-a1d0-7e7c9632bd7a',94,'a41d99312f014c65adddea4f70536a15','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-278110967-1260666270',1,'2025-10-03 12:40:20',NULL),('2025-10-02 12:40:23','2025-10-02 12:40:23','2025-10-02 12:40:23',1,289,'0ee1c970-d4fb-4fb3-bfa3-fec55470bf91',89,'a41d99312f014c65adddea4f70536a15','volumes',1,'2025-10-03 12:40:23',NULL),('2025-10-02 12:40:23','2025-10-02 12:40:23','2025-10-02 12:40:23',1,290,'8383aa86-c180-4275-a2b1-d62826a5bda1',90,'a41d99312f014c65adddea4f70536a15','gigabytes',1,'2025-10-03 12:40:23',NULL),('2025-10-02 12:40:23','2025-10-02 12:40:23','2025-10-02 12:40:23',1,291,'1cd2558a-a35d-4211-bc6e-98de89d00568',91,'a41d99312f014c65adddea4f70536a15','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-250908576-499919160',1,'2025-10-03 12:40:23',NULL),('2025-10-02 12:40:23','2025-10-02 12:40:23','2025-10-02 12:40:23',1,292,'ff63c222-04dc-4d36-828b-0418c616c0d9',92,'a41d99312f014c65adddea4f70536a15','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-250908576-499919160',1,'2025-10-03 12:40:23',NULL),('2025-10-02 12:40:23','2025-10-02 12:40:23','2025-10-02 12:40:23',1,293,'18084855-c6e0-4aec-bce3-70e31f56e155',89,'a41d99312f014c65adddea4f70536a15','volumes',1,'2025-10-03 12:40:23',NULL),('2025-10-02 12:40:23','2025-10-02 12:40:23','2025-10-02 12:40:23',1,294,'2fc06647-a3f8-46be-abea-42129e25e37c',90,'a41d99312f014c65adddea4f70536a15','gigabytes',1,'2025-10-03 12:40:23',NULL),('2025-10-02 12:40:23','2025-10-02 12:40:23','2025-10-02 12:40:23',1,295,'502b4df4-cdd0-4709-bda1-d23cc3cad52c',93,'a41d99312f014c65adddea4f70536a15','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-278110967-1260666270',1,'2025-10-03 12:40:23',NULL),('2025-10-02 12:40:23','2025-10-02 12:40:23','2025-10-02 12:40:23',1,296,'da1ccd3b-e54d-4c02-9cd7-d7f92953f5cd',94,'a41d99312f014c65adddea4f70536a15','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-278110967-1260666270',1,'2025-10-03 12:40:23',NULL),('2025-10-02 12:40:26','2025-10-02 12:40:26','2025-10-02 12:40:26',1,297,'0ffecf88-2436-4b85-bdec-180a37e5ea61',89,'a41d99312f014c65adddea4f70536a15','volumes',1,'2025-10-03 12:40:26',NULL),('2025-10-02 12:40:26','2025-10-02 12:40:26','2025-10-02 12:40:26',1,298,'a831ebbc-de09-4ec4-a31d-9ffae8e340b5',90,'a41d99312f014c65adddea4f70536a15','gigabytes',1,'2025-10-03 12:40:26',NULL),('2025-10-02 12:40:26','2025-10-02 12:40:26','2025-10-02 12:40:26',1,299,'937ec320-719e-46ce-850a-b9db3de7c54a',95,'a41d99312f014c65adddea4f70536a15','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-3962293-2082593070',1,'2025-10-03 12:40:26',NULL),('2025-10-02 12:40:26','2025-10-02 12:40:26','2025-10-02 12:40:26',1,300,'f2e98c19-471b-414c-bcc5-919215165834',96,'a41d99312f014c65adddea4f70536a15','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-3962293-2082593070',1,'2025-10-03 12:40:26',NULL),('2025-10-02 12:40:26','2025-10-02 12:40:26','2025-10-02 12:40:26',1,301,'319b9342-c07d-4f5d-80e4-bb4321d372bf',97,'eb79c45adbb144538245fe5c27fade6d','volumes',1,'2025-10-03 12:40:26',NULL),('2025-10-02 12:40:26','2025-10-02 12:40:26','2025-10-02 12:40:26',1,302,'b764214d-8841-4b17-8c2c-26b83bbe97a7',98,'eb79c45adbb144538245fe5c27fade6d','gigabytes',1,'2025-10-03 12:40:26',NULL),('2025-10-02 12:40:26','2025-10-02 12:40:26','2025-10-02 12:40:26',1,303,'f20fec1d-ffc5-4417-b90f-cebf2d1edb29',99,'eb79c45adbb144538245fe5c27fade6d','volumes___DEFAULT__',1,'2025-10-03 12:40:26',NULL),('2025-10-02 12:40:26','2025-10-02 12:40:26','2025-10-02 12:40:26',1,304,'8ce36ef3-3aae-4389-adf2-fa61c0dc082c',100,'eb79c45adbb144538245fe5c27fade6d','gigabytes___DEFAULT__',1,'2025-10-03 12:40:26',NULL),('2025-10-02 12:40:28','2025-10-02 12:40:28','2025-10-02 12:40:28',1,305,'9c87c749-c201-46d0-809b-fbef85b6f3fe',89,'a41d99312f014c65adddea4f70536a15','volumes',1,'2025-10-03 12:40:28',NULL),('2025-10-02 12:40:28','2025-10-02 12:40:28','2025-10-02 12:40:28',1,306,'8c183ca8-92bb-4458-b566-284ff70826e2',90,'a41d99312f014c65adddea4f70536a15','gigabytes',1,'2025-10-03 12:40:28',NULL),('2025-10-02 12:40:28','2025-10-02 12:40:28','2025-10-02 12:40:28',1,307,'63024713-2f4c-4693-bdb4-dcdd7d86d237',95,'a41d99312f014c65adddea4f70536a15','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-3962293-2082593070',1,'2025-10-03 12:40:28',NULL),('2025-10-02 12:40:28','2025-10-02 12:40:28','2025-10-02 12:40:28',1,308,'3132e2bc-ee76-4386-93a1-22a462c317a7',96,'a41d99312f014c65adddea4f70536a15','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-3962293-2082593070',1,'2025-10-03 12:40:28',NULL),('2025-10-02 12:40:30','2025-10-02 12:40:30','2025-10-02 12:40:30',1,309,'ab4f0331-a128-423b-a93c-4c29fb7c221f',89,'a41d99312f014c65adddea4f70536a15','volumes',1,'2025-10-03 12:40:30',NULL),('2025-10-02 12:40:30','2025-10-02 12:40:30','2025-10-02 12:40:30',1,310,'d4f8ff37-4c8d-4df1-b76c-c3bd14953a62',90,'a41d99312f014c65adddea4f70536a15','gigabytes',1,'2025-10-03 12:40:30',NULL),('2025-10-02 12:40:30','2025-10-02 12:40:30','2025-10-02 12:40:30',1,311,'b6b24ab1-8862-4a66-93de-1def50a945b2',95,'a41d99312f014c65adddea4f70536a15','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-3962293-2082593070',1,'2025-10-03 12:40:30',NULL),('2025-10-02 12:40:30','2025-10-02 12:40:30','2025-10-02 12:40:30',1,312,'11b60458-28d0-4002-a65c-4c4f9177fa3d',96,'a41d99312f014c65adddea4f70536a15','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-3962293-2082593070',1,'2025-10-03 12:40:30',NULL),('2025-10-02 12:40:35','2025-10-02 12:40:36','2025-10-02 12:40:36',1,313,'be639d18-e2e5-4f7d-a5b7-56247e97b2e2',79,'1294b2ea04b34f7189fde66e2afa2c56','volumes',-1,'2025-10-03 12:40:35',NULL),('2025-10-02 12:40:35','2025-10-02 12:40:36','2025-10-02 12:40:36',1,314,'2751c6ec-c3b7-4f3d-908f-9e6c238bdf1a',80,'1294b2ea04b34f7189fde66e2afa2c56','gigabytes',-1,'2025-10-03 12:40:35',NULL),('2025-10-02 12:40:35','2025-10-02 12:40:36','2025-10-02 12:40:36',1,315,'54c77b49-43dc-46af-ae83-9f087b821603',81,'1294b2ea04b34f7189fde66e2afa2c56','volumes_tempest-scenario-type-luks-308158206',-1,'2025-10-03 12:40:35',NULL),('2025-10-02 12:40:35','2025-10-02 12:40:36','2025-10-02 12:40:36',1,316,'76a1dc41-a669-469f-90c9-cca552f98b8d',82,'1294b2ea04b34f7189fde66e2afa2c56','gigabytes_tempest-scenario-type-luks-308158206',-1,'2025-10-03 12:40:35',NULL),('2025-10-02 12:40:52','2025-10-02 12:40:52','2025-10-02 12:40:52',1,317,'6bec406e-0d0a-4272-9751-2de7954495dd',97,'eb79c45adbb144538245fe5c27fade6d','volumes',-1,'2025-10-03 12:40:52',NULL),('2025-10-02 12:40:52','2025-10-02 12:40:52','2025-10-02 12:40:52',1,318,'71d0384a-31c5-4d2c-b012-ca5f4b3fe533',98,'eb79c45adbb144538245fe5c27fade6d','gigabytes',-1,'2025-10-03 12:40:52',NULL),('2025-10-02 12:40:52','2025-10-02 12:40:52','2025-10-02 12:40:52',1,319,'53886afd-7675-4cc1-abed-30dc620dda64',99,'eb79c45adbb144538245fe5c27fade6d','volumes___DEFAULT__',-1,'2025-10-03 12:40:52',NULL),('2025-10-02 12:40:52','2025-10-02 12:40:52','2025-10-02 12:40:52',1,320,'7b0f7d9b-cf4c-41e1-950d-386de4392065',100,'eb79c45adbb144538245fe5c27fade6d','gigabytes___DEFAULT__',-1,'2025-10-03 12:40:52',NULL),('2025-10-02 12:40:56','2025-10-02 12:40:57','2025-10-02 12:40:56',1,321,'6ed4cab9-df55-4ac0-b1d1-8e1fb4bcb827',75,'6822f02d5ca04c659329a75d487054cf','volumes',1,'2025-10-03 12:40:56',NULL),('2025-10-02 12:40:56','2025-10-02 12:40:57','2025-10-02 12:40:57',1,322,'76434b7a-3bcc-45d7-a526-4a3b0a4dcb99',76,'6822f02d5ca04c659329a75d487054cf','gigabytes',1,'2025-10-03 12:40:56',NULL),('2025-10-02 12:40:56','2025-10-02 12:40:57','2025-10-02 12:40:57',1,323,'ac66dbfa-766b-44b7-8bb9-273c033d10d6',77,'6822f02d5ca04c659329a75d487054cf','volumes___DEFAULT__',1,'2025-10-03 12:40:56',NULL),('2025-10-02 12:40:56','2025-10-02 12:40:57','2025-10-02 12:40:57',1,324,'87bf090e-659b-4393-a8c1-0cedc28be3d2',78,'6822f02d5ca04c659329a75d487054cf','gigabytes___DEFAULT__',1,'2025-10-03 12:40:56',NULL),('2025-10-02 12:40:57','2025-10-02 12:40:57','2025-10-02 12:40:57',1,325,'dad5cecf-005c-404c-bb3c-5ef8cd906bec',101,'ac8793fd6752403e9dea029569836c09','volumes',1,'2025-10-03 12:40:57',NULL),('2025-10-02 12:40:57','2025-10-02 12:40:57','2025-10-02 12:40:57',1,326,'03804472-d6d8-4fd6-8f15-0c34c8033a7b',102,'ac8793fd6752403e9dea029569836c09','gigabytes',1,'2025-10-03 12:40:57',NULL),('2025-10-02 12:40:57','2025-10-02 12:40:57','2025-10-02 12:40:57',1,327,'ea4dbb81-0d39-4b11-a87b-30142ace7749',103,'ac8793fd6752403e9dea029569836c09','volumes___DEFAULT__',1,'2025-10-03 12:40:57',NULL),('2025-10-02 12:40:57','2025-10-02 12:40:57','2025-10-02 12:40:57',1,328,'a4de139b-a555-400a-9dd5-ae7cc9969d9a',104,'ac8793fd6752403e9dea029569836c09','gigabytes___DEFAULT__',1,'2025-10-03 12:40:57',NULL),('2025-10-02 12:40:59','2025-10-02 12:40:59','2025-10-02 12:40:59',1,329,'0b262fb8-e099-484c-900e-9b6bbee98ac9',101,'ac8793fd6752403e9dea029569836c09','volumes',1,'2025-10-03 12:40:59',NULL),('2025-10-02 12:40:59','2025-10-02 12:40:59','2025-10-02 12:40:59',1,330,'428280ef-8b29-4e4f-9773-2c0f5129ab59',102,'ac8793fd6752403e9dea029569836c09','gigabytes',1,'2025-10-03 12:40:59',NULL),('2025-10-02 12:40:59','2025-10-02 12:40:59','2025-10-02 12:40:59',1,331,'bef02fe1-f8ed-47f9-bb20-20b1d8e962ab',103,'ac8793fd6752403e9dea029569836c09','volumes___DEFAULT__',1,'2025-10-03 12:40:59',NULL),('2025-10-02 12:40:59','2025-10-02 12:40:59','2025-10-02 12:40:59',1,332,'f4982f4f-bf0a-4d59-9807-db05f34758a7',104,'ac8793fd6752403e9dea029569836c09','gigabytes___DEFAULT__',1,'2025-10-03 12:40:59',NULL),('2025-10-02 12:41:02','2025-10-02 12:41:02','2025-10-02 12:41:02',1,333,'b8145fe6-fe45-4209-bb74-f137fe0a26e1',101,'ac8793fd6752403e9dea029569836c09','volumes',1,'2025-10-03 12:41:02',NULL),('2025-10-02 12:41:02','2025-10-02 12:41:02','2025-10-02 12:41:02',1,334,'f93ef8e5-c1a2-4c84-af57-83c8bcabc1f6',102,'ac8793fd6752403e9dea029569836c09','gigabytes',1,'2025-10-03 12:41:02',NULL),('2025-10-02 12:41:02','2025-10-02 12:41:02','2025-10-02 12:41:02',1,335,'4652d836-cf77-4670-b4b9-010e156df656',103,'ac8793fd6752403e9dea029569836c09','volumes___DEFAULT__',1,'2025-10-03 12:41:02',NULL),('2025-10-02 12:41:02','2025-10-02 12:41:02','2025-10-02 12:41:02',1,336,'0b1cc040-8cc6-4441-94c1-f010f35b6447',104,'ac8793fd6752403e9dea029569836c09','gigabytes___DEFAULT__',1,'2025-10-03 12:41:02',NULL),('2025-10-02 12:41:08','2025-10-02 12:41:08','2025-10-02 12:41:08',1,337,'6f4c7f00-bee6-476e-bb0a-3dd48b28ef22',101,'ac8793fd6752403e9dea029569836c09','volumes',-1,'2025-10-03 12:41:08',NULL),('2025-10-02 12:41:08','2025-10-02 12:41:08','2025-10-02 12:41:08',1,338,'51b81ed3-dc6d-4577-838c-791c2ca36786',102,'ac8793fd6752403e9dea029569836c09','gigabytes',-1,'2025-10-03 12:41:08',NULL),('2025-10-02 12:41:08','2025-10-02 12:41:08','2025-10-02 12:41:08',1,339,'3936eb6d-bc21-424f-afd2-4ea81d74a2c7',103,'ac8793fd6752403e9dea029569836c09','volumes___DEFAULT__',-1,'2025-10-03 12:41:08',NULL),('2025-10-02 12:41:08','2025-10-02 12:41:08','2025-10-02 12:41:08',1,340,'59942564-a3a2-49c9-bb49-d61917eeacee',104,'ac8793fd6752403e9dea029569836c09','gigabytes___DEFAULT__',-1,'2025-10-03 12:41:08',NULL),('2025-10-02 12:41:11','2025-10-02 12:41:11','2025-10-02 12:41:11',1,341,'03c0a5fc-959e-43e6-a53a-6b86f1baa03b',101,'ac8793fd6752403e9dea029569836c09','volumes',-1,'2025-10-03 12:41:11',NULL),('2025-10-02 12:41:11','2025-10-02 12:41:11','2025-10-02 12:41:11',1,342,'a49fd155-f1a4-4e75-bfb6-41286cc377c6',102,'ac8793fd6752403e9dea029569836c09','gigabytes',-1,'2025-10-03 12:41:11',NULL),('2025-10-02 12:41:11','2025-10-02 12:41:11','2025-10-02 12:41:11',1,343,'5be4248f-09f8-4c1f-9b23-97e30926b2bd',103,'ac8793fd6752403e9dea029569836c09','volumes___DEFAULT__',-1,'2025-10-03 12:41:11',NULL),('2025-10-02 12:41:11','2025-10-02 12:41:11','2025-10-02 12:41:11',1,344,'5399f34b-9863-4cda-85c4-43bc5415926e',104,'ac8793fd6752403e9dea029569836c09','gigabytes___DEFAULT__',-1,'2025-10-03 12:41:11',NULL),('2025-10-02 12:41:12','2025-10-02 12:41:13','2025-10-02 12:41:13',1,345,'5d4c443d-9fba-42c6-b08b-156ca7f46460',101,'ac8793fd6752403e9dea029569836c09','volumes',-1,'2025-10-03 12:41:12',NULL),('2025-10-02 12:41:12','2025-10-02 12:41:13','2025-10-02 12:41:13',1,346,'5f8045d7-5b54-4f45-96fe-6e43a4c1b1e4',102,'ac8793fd6752403e9dea029569836c09','gigabytes',-1,'2025-10-03 12:41:12',NULL),('2025-10-02 12:41:12','2025-10-02 12:41:13','2025-10-02 12:41:13',1,347,'32a27a1b-cd7d-400d-822a-4a79b00a4ae4',103,'ac8793fd6752403e9dea029569836c09','volumes___DEFAULT__',-1,'2025-10-03 12:41:12',NULL),('2025-10-02 12:41:12','2025-10-02 12:41:13','2025-10-02 12:41:13',1,348,'0dc3f761-df65-47b1-8d1c-7a4e8df840e5',104,'ac8793fd6752403e9dea029569836c09','gigabytes___DEFAULT__',-1,'2025-10-03 12:41:12',NULL),('2025-10-02 12:41:52','2025-10-02 12:41:52','2025-10-02 12:41:52',1,349,'8d644c09-9793-42ac-8281-22e5ffd9b682',105,'2e53064cd4d645f09bd59bbca09b98e0','volumes',1,'2025-10-03 12:41:52',NULL),('2025-10-02 12:41:52','2025-10-02 12:41:52','2025-10-02 12:41:52',1,350,'11a5f8b4-c48a-4df2-b52c-3d7de054799d',106,'2e53064cd4d645f09bd59bbca09b98e0','gigabytes',1,'2025-10-03 12:41:52',NULL),('2025-10-02 12:41:52','2025-10-02 12:41:52','2025-10-02 12:41:52',1,351,'b1462a9d-33bd-49aa-ae92-f8d6d712bffc',107,'2e53064cd4d645f09bd59bbca09b98e0','volumes___DEFAULT__',1,'2025-10-03 12:41:52',NULL),('2025-10-02 12:41:52','2025-10-02 12:41:52','2025-10-02 12:41:52',1,352,'ac24a7c4-946a-4eb9-b8e3-688750d60205',108,'2e53064cd4d645f09bd59bbca09b98e0','gigabytes___DEFAULT__',1,'2025-10-03 12:41:52',NULL),('2025-10-02 12:41:58','2025-10-02 12:41:58','2025-10-02 12:41:58',1,353,'d8f53348-c156-4f44-af2e-82850fca8834',109,'2e53064cd4d645f09bd59bbca09b98e0','snapshots',1,'2025-10-03 12:41:58',NULL),('2025-10-02 12:41:58','2025-10-02 12:41:58','2025-10-02 12:41:58',1,354,'00477920-b2c0-4f32-b3d0-31ef0c4e8b1e',106,'2e53064cd4d645f09bd59bbca09b98e0','gigabytes',1,'2025-10-03 12:41:58',NULL),('2025-10-02 12:41:58','2025-10-02 12:41:58','2025-10-02 12:41:58',1,355,'f7913579-db2c-43c4-87ed-741e2e32993f',108,'2e53064cd4d645f09bd59bbca09b98e0','gigabytes___DEFAULT__',1,'2025-10-03 12:41:58',NULL),('2025-10-02 12:41:58','2025-10-02 12:41:58','2025-10-02 12:41:58',1,356,'2ccb7b7b-431c-4d9e-bd1a-c03f23b79c7d',110,'2e53064cd4d645f09bd59bbca09b98e0','snapshots___DEFAULT__',1,'2025-10-03 12:41:58',NULL),('2025-10-02 12:42:06','2025-10-02 12:42:06','2025-10-02 12:42:06',1,357,'36c4a67a-161f-455b-9839-87e314ab6f61',89,'a41d99312f014c65adddea4f70536a15','volumes',-1,'2025-10-03 12:42:06',NULL),('2025-10-02 12:42:06','2025-10-02 12:42:06','2025-10-02 12:42:06',1,358,'27303624-b098-4a10-8d92-e2854c55196b',90,'a41d99312f014c65adddea4f70536a15','gigabytes',-1,'2025-10-03 12:42:06',NULL),('2025-10-02 12:42:06','2025-10-02 12:42:06','2025-10-02 12:42:06',1,359,'58193152-3856-4863-a483-804a5d0e95b0',91,'a41d99312f014c65adddea4f70536a15','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-250908576-499919160',-1,'2025-10-03 12:42:06',NULL),('2025-10-02 12:42:06','2025-10-02 12:42:06','2025-10-02 12:42:06',1,360,'1a889c37-f993-438d-978f-32bf1819da24',92,'a41d99312f014c65adddea4f70536a15','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-250908576-499919160',-1,'2025-10-03 12:42:06',NULL),('2025-10-02 12:42:10','2025-10-02 12:42:10','2025-10-02 12:42:10',1,361,'4383ba05-112f-419c-8085-cf233f10ee2f',89,'a41d99312f014c65adddea4f70536a15','volumes',-1,'2025-10-03 12:42:10',NULL),('2025-10-02 12:42:10','2025-10-02 12:42:10','2025-10-02 12:42:10',1,362,'c83c5b9b-dfe2-4501-823b-88b7e021725a',90,'a41d99312f014c65adddea4f70536a15','gigabytes',-1,'2025-10-03 12:42:10',NULL),('2025-10-02 12:42:10','2025-10-02 12:42:10','2025-10-02 12:42:10',1,363,'c2f8c39e-d982-4e79-9c69-41d69fa51cdc',93,'a41d99312f014c65adddea4f70536a15','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-278110967-1260666270',-1,'2025-10-03 12:42:10',NULL),('2025-10-02 12:42:10','2025-10-02 12:42:10','2025-10-02 12:42:10',1,364,'0679d80d-3e59-4e08-aebc-a5b27050a749',94,'a41d99312f014c65adddea4f70536a15','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-278110967-1260666270',-1,'2025-10-03 12:42:10',NULL),('2025-10-02 12:42:19','2025-10-02 12:42:19','2025-10-02 12:42:19',1,365,'7b6cbacc-3048-4dd2-a94b-cc029a8b572b',109,'2e53064cd4d645f09bd59bbca09b98e0','snapshots',-1,'2025-10-03 12:42:19',NULL),('2025-10-02 12:42:19','2025-10-02 12:42:19','2025-10-02 12:42:19',1,366,'f808fd2a-038a-4b23-9670-23c3c12eb73d',106,'2e53064cd4d645f09bd59bbca09b98e0','gigabytes',-1,'2025-10-03 12:42:19',NULL),('2025-10-02 12:42:19','2025-10-02 12:42:19','2025-10-02 12:42:19',1,367,'0fb746ce-531f-4528-9be7-ebded1367fe7',108,'2e53064cd4d645f09bd59bbca09b98e0','gigabytes___DEFAULT__',-1,'2025-10-03 12:42:19',NULL),('2025-10-02 12:42:19','2025-10-02 12:42:19','2025-10-02 12:42:19',1,368,'a0f9c5a9-aecb-459d-9040-3037b437bd9a',110,'2e53064cd4d645f09bd59bbca09b98e0','snapshots___DEFAULT__',-1,'2025-10-03 12:42:19',NULL),('2025-10-02 12:42:39','2025-10-02 12:42:40','2025-10-02 12:42:40',1,369,'4e27266d-fac2-4b6f-af1c-99f083e51bcc',89,'a41d99312f014c65adddea4f70536a15','volumes',-1,'2025-10-03 12:42:39',NULL),('2025-10-02 12:42:39','2025-10-02 12:42:40','2025-10-02 12:42:40',1,370,'61b0ced8-0afb-4f46-95c0-11345a443436',90,'a41d99312f014c65adddea4f70536a15','gigabytes',-1,'2025-10-03 12:42:39',NULL),('2025-10-02 12:42:39','2025-10-02 12:42:40','2025-10-02 12:42:40',1,371,'57c07670-2ba8-4af2-bd6b-66512663d9ec',91,'a41d99312f014c65adddea4f70536a15','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-250908576-499919160',-1,'2025-10-03 12:42:39',NULL),('2025-10-02 12:42:39','2025-10-02 12:42:40','2025-10-02 12:42:40',1,372,'00832a8d-8a5f-48d6-911f-9b50e1784555',92,'a41d99312f014c65adddea4f70536a15','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-250908576-499919160',-1,'2025-10-03 12:42:39',NULL),('2025-10-02 12:42:40','2025-10-02 12:42:40','2025-10-02 12:42:40',1,373,'fece9358-dd91-48e9-9766-dad287c26a16',75,'6822f02d5ca04c659329a75d487054cf','volumes',-1,'2025-10-03 12:42:40',NULL),('2025-10-02 12:42:40','2025-10-02 12:42:40','2025-10-02 12:42:40',1,374,'d14330f4-133a-48f8-9255-62f62eb6f8d9',76,'6822f02d5ca04c659329a75d487054cf','gigabytes',-1,'2025-10-03 12:42:40',NULL),('2025-10-02 12:42:40','2025-10-02 12:42:40','2025-10-02 12:42:40',1,375,'25306e66-c93a-4e0c-b9a2-680232f641e5',77,'6822f02d5ca04c659329a75d487054cf','volumes___DEFAULT__',-1,'2025-10-03 12:42:40',NULL),('2025-10-02 12:42:40','2025-10-02 12:42:40','2025-10-02 12:42:40',1,376,'707c9ea6-77f4-4ca9-8952-a74358ac17b2',78,'6822f02d5ca04c659329a75d487054cf','gigabytes___DEFAULT__',-1,'2025-10-03 12:42:40',NULL),('2025-10-02 12:42:43','2025-10-02 12:42:43','2025-10-02 12:42:43',1,377,'1923ac06-c226-449e-bd80-484ba0b932bb',89,'a41d99312f014c65adddea4f70536a15','volumes',-1,'2025-10-03 12:42:43',NULL),('2025-10-02 12:42:43','2025-10-02 12:42:43','2025-10-02 12:42:43',1,378,'ac5ca64c-ed31-4517-805e-e915acd44056',90,'a41d99312f014c65adddea4f70536a15','gigabytes',-1,'2025-10-03 12:42:43',NULL),('2025-10-02 12:42:43','2025-10-02 12:42:43','2025-10-02 12:42:43',1,379,'856becc2-65ff-48b4-bb8e-e302f4e50605',93,'a41d99312f014c65adddea4f70536a15','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-278110967-1260666270',-1,'2025-10-03 12:42:43',NULL),('2025-10-02 12:42:43','2025-10-02 12:42:43','2025-10-02 12:42:43',1,380,'9f00e827-f634-46dd-acf8-977279600839',94,'a41d99312f014c65adddea4f70536a15','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-278110967-1260666270',-1,'2025-10-03 12:42:43',NULL),('2025-10-02 12:42:47','2025-10-02 12:42:48','2025-10-02 12:42:48',1,381,'fe1a5d0e-e3be-418f-943e-e2c3b6654f1e',75,'6822f02d5ca04c659329a75d487054cf','volumes',-1,'2025-10-03 12:42:47',NULL),('2025-10-02 12:42:47','2025-10-02 12:42:48','2025-10-02 12:42:48',1,382,'ea483fa2-42fb-456d-b90d-ebbb1b7231c9',76,'6822f02d5ca04c659329a75d487054cf','gigabytes',-1,'2025-10-03 12:42:47',NULL),('2025-10-02 12:42:47','2025-10-02 12:42:48','2025-10-02 12:42:48',1,383,'9792f920-c99f-4f00-95ef-58b11aadc4a1',77,'6822f02d5ca04c659329a75d487054cf','volumes___DEFAULT__',-1,'2025-10-03 12:42:47',NULL),('2025-10-02 12:42:48','2025-10-02 12:42:48','2025-10-02 12:42:48',1,384,'ef170a3c-effd-4d74-987f-f650baa44307',78,'6822f02d5ca04c659329a75d487054cf','gigabytes___DEFAULT__',-1,'2025-10-03 12:42:47',NULL),('2025-10-02 12:43:11','2025-10-02 12:43:11','2025-10-02 12:43:11',1,385,'db930164-dabe-445b-a06c-1b958957d9a7',105,'2e53064cd4d645f09bd59bbca09b98e0','volumes',-1,'2025-10-03 12:43:11',NULL),('2025-10-02 12:43:11','2025-10-02 12:43:11','2025-10-02 12:43:11',1,386,'76791901-c5c3-4f2d-a5f9-40e1c4091f6d',106,'2e53064cd4d645f09bd59bbca09b98e0','gigabytes',-1,'2025-10-03 12:43:11',NULL),('2025-10-02 12:43:11','2025-10-02 12:43:11','2025-10-02 12:43:11',1,387,'147f5c28-5074-425e-af05-fc409b8065a2',107,'2e53064cd4d645f09bd59bbca09b98e0','volumes___DEFAULT__',-1,'2025-10-03 12:43:11',NULL),('2025-10-02 12:43:11','2025-10-02 12:43:11','2025-10-02 12:43:11',1,388,'496393d4-3a91-4673-aa36-fada9f8a7796',108,'2e53064cd4d645f09bd59bbca09b98e0','gigabytes___DEFAULT__',-1,'2025-10-03 12:43:11',NULL),('2025-10-02 12:43:24','2025-10-02 12:43:25','2025-10-02 12:43:25',1,389,'c2558c44-c71d-4d6e-899b-d5fcb508ddfa',89,'a41d99312f014c65adddea4f70536a15','volumes',-1,'2025-10-03 12:43:24',NULL),('2025-10-02 12:43:24','2025-10-02 12:43:25','2025-10-02 12:43:25',1,390,'a7ca339c-7434-4d78-bb28-c7c2c14c11d8',90,'a41d99312f014c65adddea4f70536a15','gigabytes',-1,'2025-10-03 12:43:24',NULL),('2025-10-02 12:43:24','2025-10-02 12:43:25','2025-10-02 12:43:25',1,391,'7821b104-27c3-461b-b321-0d8864868d8c',91,'a41d99312f014c65adddea4f70536a15','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-250908576-499919160',-1,'2025-10-03 12:43:24',NULL),('2025-10-02 12:43:24','2025-10-02 12:43:25','2025-10-02 12:43:25',1,392,'437e4e38-47cd-4c1e-9e3e-cce3e76ed017',92,'a41d99312f014c65adddea4f70536a15','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-250908576-499919160',-1,'2025-10-03 12:43:24',NULL),('2025-10-02 12:43:31','2025-10-02 12:43:32','2025-10-02 12:43:32',1,393,'207ed944-b4ce-4f5d-83cc-2a6e06a657ec',89,'a41d99312f014c65adddea4f70536a15','volumes',-1,'2025-10-03 12:43:31',NULL),('2025-10-02 12:43:31','2025-10-02 12:43:32','2025-10-02 12:43:32',1,394,'b8c42715-0086-4c19-8338-86c7319c2732',90,'a41d99312f014c65adddea4f70536a15','gigabytes',-1,'2025-10-03 12:43:31',NULL),('2025-10-02 12:43:31','2025-10-02 12:43:32','2025-10-02 12:43:32',1,395,'05809f7a-686a-4b06-8238-0d0df0537a58',93,'a41d99312f014c65adddea4f70536a15','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-278110967-1260666270',-1,'2025-10-03 12:43:31',NULL),('2025-10-02 12:43:31','2025-10-02 12:43:32','2025-10-02 12:43:32',1,396,'8d6a9a66-61e6-4d4d-afbe-0e1f88c2ded6',94,'a41d99312f014c65adddea4f70536a15','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-278110967-1260666270',-1,'2025-10-03 12:43:31',NULL),('2025-10-02 12:44:03','2025-10-02 12:44:04','2025-10-02 12:44:04',1,397,'fae47ba1-b748-4b1e-9468-f64b1d9159ca',105,'2e53064cd4d645f09bd59bbca09b98e0','volumes',1,'2025-10-03 12:44:03',NULL),('2025-10-02 12:44:03','2025-10-02 12:44:04','2025-10-02 12:44:04',1,398,'3bbba332-d4c2-4f30-8003-b2844a3ca384',106,'2e53064cd4d645f09bd59bbca09b98e0','gigabytes',1,'2025-10-03 12:44:03',NULL),('2025-10-02 12:44:03','2025-10-02 12:44:04','2025-10-02 12:44:04',1,399,'6ebf50d5-5aa3-45d6-860e-b604b3abd997',107,'2e53064cd4d645f09bd59bbca09b98e0','volumes___DEFAULT__',1,'2025-10-03 12:44:03',NULL),('2025-10-02 12:44:03','2025-10-02 12:44:04','2025-10-02 12:44:04',1,400,'1bfaf307-1c14-41a2-9626-d79146d55725',108,'2e53064cd4d645f09bd59bbca09b98e0','gigabytes___DEFAULT__',1,'2025-10-03 12:44:03',NULL),('2025-10-02 12:44:04','2025-10-02 12:44:05','2025-10-02 12:44:05',1,401,'e5bf3b6a-0617-4e77-b963-4582dd833b9c',111,'4b8f9114c7ab4b6e9fc9650d4bd08af9','volumes',1,'2025-10-03 12:44:04',NULL),('2025-10-02 12:44:04','2025-10-02 12:44:05','2025-10-02 12:44:05',1,402,'6ba21f9f-63a8-4983-88cd-cfabc50705ec',112,'4b8f9114c7ab4b6e9fc9650d4bd08af9','gigabytes',1,'2025-10-03 12:44:04',NULL),('2025-10-02 12:44:04','2025-10-02 12:44:05','2025-10-02 12:44:05',1,403,'0a3ad0df-f403-4bd3-8d35-bb5f23ba6dea',113,'4b8f9114c7ab4b6e9fc9650d4bd08af9','volumes___DEFAULT__',1,'2025-10-03 12:44:04',NULL),('2025-10-02 12:44:04','2025-10-02 12:44:05','2025-10-02 12:44:05',1,404,'894e7c89-348c-4498-b803-2e6f47413cd8',114,'4b8f9114c7ab4b6e9fc9650d4bd08af9','gigabytes___DEFAULT__',1,'2025-10-03 12:44:04',NULL),('2025-10-02 12:44:09','2025-10-02 12:44:10','2025-10-02 12:44:10',1,405,'afba3656-7038-4eac-b45d-03c3e8fde0e6',89,'a41d99312f014c65adddea4f70536a15','volumes',-1,'2025-10-03 12:44:09',NULL),('2025-10-02 12:44:09','2025-10-02 12:44:10','2025-10-02 12:44:10',1,406,'8d32b09a-8463-4518-b039-8ddb6606bfb2',90,'a41d99312f014c65adddea4f70536a15','gigabytes',-1,'2025-10-03 12:44:09',NULL),('2025-10-02 12:44:09','2025-10-02 12:44:10','2025-10-02 12:44:10',1,407,'276e9042-f1a4-4c89-b31e-2fe3eaa0b3e0',95,'a41d99312f014c65adddea4f70536a15','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-3962293-2082593070',-1,'2025-10-03 12:44:09',NULL),('2025-10-02 12:44:09','2025-10-02 12:44:10','2025-10-02 12:44:10',1,408,'b6d0b76b-fe71-4611-955f-9fdc2fb0a615',96,'a41d99312f014c65adddea4f70536a15','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-3962293-2082593070',-1,'2025-10-03 12:44:09',NULL),('2025-10-02 12:44:12','2025-10-02 12:44:12','2025-10-02 12:44:12',1,409,'656d17cf-e745-4192-807d-1daae9d203e5',89,'a41d99312f014c65adddea4f70536a15','volumes',-1,'2025-10-03 12:44:12',NULL),('2025-10-02 12:44:12','2025-10-02 12:44:12','2025-10-02 12:44:12',1,410,'0b432d44-0334-4ead-8288-f6e33d721d35',90,'a41d99312f014c65adddea4f70536a15','gigabytes',-1,'2025-10-03 12:44:12',NULL),('2025-10-02 12:44:12','2025-10-02 12:44:12','2025-10-02 12:44:12',1,411,'6093a357-d768-4b7e-b6f6-8b12208fbcab',95,'a41d99312f014c65adddea4f70536a15','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-3962293-2082593070',-1,'2025-10-03 12:44:12',NULL),('2025-10-02 12:44:12','2025-10-02 12:44:12','2025-10-02 12:44:12',1,412,'fcc2c025-40d0-4930-b403-4dc189dbb0f3',96,'a41d99312f014c65adddea4f70536a15','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-3962293-2082593070',-1,'2025-10-03 12:44:12',NULL),('2025-10-02 12:44:15','2025-10-02 12:44:15','2025-10-02 12:44:15',1,413,'d7cb3c07-eb11-49d8-8746-3732ef59e38a',89,'a41d99312f014c65adddea4f70536a15','volumes',-1,'2025-10-03 12:44:15',NULL),('2025-10-02 12:44:15','2025-10-02 12:44:15','2025-10-02 12:44:15',1,414,'8a3dfce4-54ab-448a-9235-7a9ebfdac30e',90,'a41d99312f014c65adddea4f70536a15','gigabytes',-1,'2025-10-03 12:44:15',NULL),('2025-10-02 12:44:15','2025-10-02 12:44:15','2025-10-02 12:44:15',1,415,'bc26f6b9-3c8c-4b01-88b5-5d7f4a9d82f7',95,'a41d99312f014c65adddea4f70536a15','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-3962293-2082593070',-1,'2025-10-03 12:44:15',NULL),('2025-10-02 12:44:15','2025-10-02 12:44:15','2025-10-02 12:44:15',1,416,'b6b57090-1226-49a8-bf64-4bd52e05dc53',96,'a41d99312f014c65adddea4f70536a15','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-3962293-2082593070',-1,'2025-10-03 12:44:15',NULL),('2025-10-02 12:45:29','2025-10-02 12:45:29','2025-10-02 12:45:29',1,417,'83f09ae8-7edd-4b60-86bd-a7c6ee0155a0',105,'2e53064cd4d645f09bd59bbca09b98e0','volumes',-1,'2025-10-03 12:45:29',NULL),('2025-10-02 12:45:29','2025-10-02 12:45:29','2025-10-02 12:45:29',1,418,'8957fa98-b89f-49f1-b36c-cb057d169452',106,'2e53064cd4d645f09bd59bbca09b98e0','gigabytes',-1,'2025-10-03 12:45:29',NULL),('2025-10-02 12:45:29','2025-10-02 12:45:29','2025-10-02 12:45:29',1,419,'beba6001-9c75-402b-bcf4-6b98fe37e8f0',107,'2e53064cd4d645f09bd59bbca09b98e0','volumes___DEFAULT__',-1,'2025-10-03 12:45:29',NULL),('2025-10-02 12:45:29','2025-10-02 12:45:29','2025-10-02 12:45:29',1,420,'0a2e7623-8406-41ff-b326-d11d9a660efb',108,'2e53064cd4d645f09bd59bbca09b98e0','gigabytes___DEFAULT__',-1,'2025-10-03 12:45:29',NULL),('2025-10-02 12:46:05','2025-10-02 12:46:06','2025-10-02 12:46:06',1,421,'57528662-54ed-4859-858e-7924bb5d5907',111,'4b8f9114c7ab4b6e9fc9650d4bd08af9','volumes',-1,'2025-10-03 12:46:05',NULL),('2025-10-02 12:46:05','2025-10-02 12:46:06','2025-10-02 12:46:06',1,422,'a690ce2f-970e-4f20-9662-14726b2b731f',112,'4b8f9114c7ab4b6e9fc9650d4bd08af9','gigabytes',-1,'2025-10-03 12:46:05',NULL),('2025-10-02 12:46:05','2025-10-02 12:46:06','2025-10-02 12:46:06',1,423,'845cf2fb-c92f-41d7-8b3f-55954ef96f97',113,'4b8f9114c7ab4b6e9fc9650d4bd08af9','volumes___DEFAULT__',-1,'2025-10-03 12:46:05',NULL),('2025-10-02 12:46:05','2025-10-02 12:46:06','2025-10-02 12:46:06',1,424,'e5bae3fd-47aa-4a83-8841-48217f2272c5',114,'4b8f9114c7ab4b6e9fc9650d4bd08af9','gigabytes___DEFAULT__',-1,'2025-10-03 12:46:05',NULL),('2025-10-02 12:47:03','2025-10-02 12:47:03','2025-10-02 12:47:03',1,425,'48047bc6-f599-442a-8130-acc6fe9d79f1',115,'a837417d42da439cb794b4295bca2cee','volumes',1,'2025-10-03 12:47:03',NULL),('2025-10-02 12:47:03','2025-10-02 12:47:03','2025-10-02 12:47:03',1,426,'601ba5e1-c945-4ce4-9dd6-a8855849a924',116,'a837417d42da439cb794b4295bca2cee','gigabytes',1,'2025-10-03 12:47:03',NULL),('2025-10-02 12:47:03','2025-10-02 12:47:03','2025-10-02 12:47:03',1,427,'e1dccc47-0acf-4e7a-ac17-ebac26919814',117,'a837417d42da439cb794b4295bca2cee','volumes___DEFAULT__',1,'2025-10-03 12:47:03',NULL),('2025-10-02 12:47:03','2025-10-02 12:47:03','2025-10-02 12:47:03',1,428,'e22b7f19-1b0b-4f8c-a93e-dec99e67af2a',118,'a837417d42da439cb794b4295bca2cee','gigabytes___DEFAULT__',1,'2025-10-03 12:47:03',NULL),('2025-10-02 12:47:57','2025-10-02 12:47:57','2025-10-02 12:47:57',1,429,'b53339e5-ecce-4d5f-a46a-36f693f3c630',119,'a837417d42da439cb794b4295bca2cee','snapshots',1,'2025-10-03 12:47:57',NULL),('2025-10-02 12:47:57','2025-10-02 12:47:57','2025-10-02 12:47:57',1,430,'bbf3931c-56ca-4726-9233-31b33ddbc794',116,'a837417d42da439cb794b4295bca2cee','gigabytes',1,'2025-10-03 12:47:57',NULL),('2025-10-02 12:47:57','2025-10-02 12:47:57','2025-10-02 12:47:57',1,431,'b366673f-a188-4533-a32f-9047e4aa93e9',118,'a837417d42da439cb794b4295bca2cee','gigabytes___DEFAULT__',1,'2025-10-03 12:47:57',NULL),('2025-10-02 12:47:57','2025-10-02 12:47:57','2025-10-02 12:47:57',1,432,'e7656f20-ae79-45de-a516-9f8b83542e43',120,'a837417d42da439cb794b4295bca2cee','snapshots___DEFAULT__',1,'2025-10-03 12:47:57',NULL),('2025-10-02 12:48:10','2025-10-02 12:48:10','2025-10-02 12:48:10',1,433,'41743797-7fc1-4cb2-b619-4a453103e2be',115,'a837417d42da439cb794b4295bca2cee','volumes',1,'2025-10-03 12:48:10',NULL),('2025-10-02 12:48:10','2025-10-02 12:48:10','2025-10-02 12:48:10',1,434,'39916969-bcb6-4896-a242-1fa596c6b2b4',116,'a837417d42da439cb794b4295bca2cee','gigabytes',1,'2025-10-03 12:48:10',NULL),('2025-10-02 12:48:10','2025-10-02 12:48:10','2025-10-02 12:48:10',1,435,'2554e381-d4fa-4319-96cd-e903484ae68e',117,'a837417d42da439cb794b4295bca2cee','volumes___DEFAULT__',1,'2025-10-03 12:48:10',NULL),('2025-10-02 12:48:10','2025-10-02 12:48:10','2025-10-02 12:48:10',1,436,'6bbb10ba-fc0d-4ade-af18-9d14447484a0',118,'a837417d42da439cb794b4295bca2cee','gigabytes___DEFAULT__',1,'2025-10-03 12:48:10',NULL),('2025-10-02 12:49:21','2025-10-02 12:49:21','2025-10-02 12:49:21',1,437,'d7d05616-f0e6-48ad-8b5c-96e520764039',115,'a837417d42da439cb794b4295bca2cee','volumes',-1,'2025-10-03 12:49:21',NULL),('2025-10-02 12:49:21','2025-10-02 12:49:21','2025-10-02 12:49:21',1,438,'9130a72e-b44b-44b6-b5ef-47278c2844e0',116,'a837417d42da439cb794b4295bca2cee','gigabytes',-1,'2025-10-03 12:49:21',NULL),('2025-10-02 12:49:21','2025-10-02 12:49:21','2025-10-02 12:49:21',1,439,'f9aec65d-0987-420d-b84b-285543ffa319',117,'a837417d42da439cb794b4295bca2cee','volumes___DEFAULT__',-1,'2025-10-03 12:49:21',NULL),('2025-10-02 12:49:21','2025-10-02 12:49:21','2025-10-02 12:49:21',1,440,'fc7ef3ff-4881-4784-9370-edee3458e045',118,'a837417d42da439cb794b4295bca2cee','gigabytes___DEFAULT__',-1,'2025-10-03 12:49:21',NULL),('2025-10-02 12:49:25','2025-10-02 12:49:25','2025-10-02 12:49:25',1,441,'a4123f2d-d3aa-4fa8-b323-a7add3708aa7',119,'a837417d42da439cb794b4295bca2cee','snapshots',-1,'2025-10-03 12:49:25',NULL),('2025-10-02 12:49:25','2025-10-02 12:49:25','2025-10-02 12:49:25',1,442,'49da09f0-7ea6-4aa0-900f-2cfab533dbb1',116,'a837417d42da439cb794b4295bca2cee','gigabytes',-1,'2025-10-03 12:49:25',NULL),('2025-10-02 12:49:25','2025-10-02 12:49:25','2025-10-02 12:49:25',1,443,'a5fb5cf1-cfb7-4246-87fd-28f419acdfad',118,'a837417d42da439cb794b4295bca2cee','gigabytes___DEFAULT__',-1,'2025-10-03 12:49:25',NULL),('2025-10-02 12:49:25','2025-10-02 12:49:25','2025-10-02 12:49:25',1,444,'84f56bc7-bcc4-42d0-8542-ea853e9c1b4b',120,'a837417d42da439cb794b4295bca2cee','snapshots___DEFAULT__',-1,'2025-10-03 12:49:25',NULL),('2025-10-02 12:49:35','2025-10-02 12:49:35','2025-10-02 12:49:35',1,445,'05f2db9c-5bf4-48ab-ad14-298b59385c97',115,'a837417d42da439cb794b4295bca2cee','volumes',-1,'2025-10-03 12:49:35',NULL),('2025-10-02 12:49:35','2025-10-02 12:49:35','2025-10-02 12:49:35',1,446,'a2844783-15da-4f9f-97c0-d5f90a291406',116,'a837417d42da439cb794b4295bca2cee','gigabytes',-1,'2025-10-03 12:49:35',NULL),('2025-10-02 12:49:35','2025-10-02 12:49:35','2025-10-02 12:49:35',1,447,'4b76d53c-f1e8-439c-91cf-d4fe1392775a',117,'a837417d42da439cb794b4295bca2cee','volumes___DEFAULT__',-1,'2025-10-03 12:49:35',NULL),('2025-10-02 12:49:35','2025-10-02 12:49:35','2025-10-02 12:49:35',1,448,'47446e83-44bc-46e0-8ecf-32f0e3666e6c',118,'a837417d42da439cb794b4295bca2cee','gigabytes___DEFAULT__',-1,'2025-10-03 12:49:35',NULL),('2025-10-02 12:51:06','2025-10-02 12:51:06','2025-10-02 12:51:06',1,449,'9be351e9-be6e-4978-8f31-42cce12cd61c',121,'6a442bc513e14406b73e96e70396e6c3','volumes',1,'2025-10-03 12:51:06',NULL),('2025-10-02 12:51:06','2025-10-02 12:51:06','2025-10-02 12:51:06',1,450,'7eeb9bbb-ab42-43ab-a820-1e5c6afdc69a',122,'6a442bc513e14406b73e96e70396e6c3','gigabytes',1,'2025-10-03 12:51:06',NULL),('2025-10-02 12:51:06','2025-10-02 12:51:06','2025-10-02 12:51:06',1,451,'eef64ffe-5680-41d4-a59f-a1ac2c1d66cf',123,'6a442bc513e14406b73e96e70396e6c3','volumes___DEFAULT__',1,'2025-10-03 12:51:06',NULL),('2025-10-02 12:51:06','2025-10-02 12:51:06','2025-10-02 12:51:06',1,452,'856a3d56-8647-4fa0-80e9-eaab6c70ae6f',124,'6a442bc513e14406b73e96e70396e6c3','gigabytes___DEFAULT__',1,'2025-10-03 12:51:06',NULL),('2025-10-02 12:54:59','2025-10-02 12:54:59','2025-10-02 12:54:59',1,453,'a33ce7ff-ac53-4395-888d-38605f1386b2',121,'6a442bc513e14406b73e96e70396e6c3','volumes',-1,'2025-10-03 12:54:59',NULL),('2025-10-02 12:54:59','2025-10-02 12:54:59','2025-10-02 12:54:59',1,454,'2b201e65-f045-4be9-b23b-4e03d1e2a75e',122,'6a442bc513e14406b73e96e70396e6c3','gigabytes',-1,'2025-10-03 12:54:59',NULL),('2025-10-02 12:54:59','2025-10-02 12:54:59','2025-10-02 12:54:59',1,455,'55ff549c-ca97-4fc5-8609-6e441ea354d7',123,'6a442bc513e14406b73e96e70396e6c3','volumes___DEFAULT__',-1,'2025-10-03 12:54:59',NULL),('2025-10-02 12:54:59','2025-10-02 12:54:59','2025-10-02 12:54:59',1,456,'85d5cef6-0175-46ef-b477-d1709e5aac77',124,'6a442bc513e14406b73e96e70396e6c3','gigabytes___DEFAULT__',-1,'2025-10-03 12:54:59',NULL),('2025-10-02 12:57:57','2025-10-02 12:57:57','2025-10-02 12:57:57',1,457,'f86e0fd4-e786-4fb8-84ff-adf7cbc9544d',125,'e7168b5b1300495d90592b195824729a','volumes',1,'2025-10-03 12:57:57',NULL),('2025-10-02 12:57:57','2025-10-02 12:57:57','2025-10-02 12:57:57',1,458,'85c89779-6f5b-4d31-b807-bf0a0096cd40',126,'e7168b5b1300495d90592b195824729a','gigabytes',1,'2025-10-03 12:57:57',NULL),('2025-10-02 12:57:57','2025-10-02 12:57:57','2025-10-02 12:57:57',1,459,'192a81ad-56c4-4bfd-9d38-0b0bbd507f08',127,'e7168b5b1300495d90592b195824729a','volumes___DEFAULT__',1,'2025-10-03 12:57:57',NULL),('2025-10-02 12:57:57','2025-10-02 12:57:57','2025-10-02 12:57:57',1,460,'a3c743b9-7209-45a7-b947-2b6d2c20995e',128,'e7168b5b1300495d90592b195824729a','gigabytes___DEFAULT__',1,'2025-10-03 12:57:57',NULL),('2025-10-02 12:58:47','2025-10-02 12:58:47','2025-10-02 12:58:47',1,461,'977e9b96-c5fe-4cce-9cde-eb094d8984d7',129,'55e97477dd13448d9dafe69ec8614ea6','volumes',1,'2025-10-03 12:58:47',NULL),('2025-10-02 12:58:47','2025-10-02 12:58:47','2025-10-02 12:58:47',1,462,'ca2126e8-4082-467d-b7de-b4cdc6aa5de4',130,'55e97477dd13448d9dafe69ec8614ea6','gigabytes',1,'2025-10-03 12:58:47',NULL),('2025-10-02 12:58:47','2025-10-02 12:58:47','2025-10-02 12:58:47',1,463,'39de8266-7817-451a-a923-886116b85e41',131,'55e97477dd13448d9dafe69ec8614ea6','volumes___DEFAULT__',1,'2025-10-03 12:58:47',NULL),('2025-10-02 12:58:47','2025-10-02 12:58:47','2025-10-02 12:58:47',1,464,'b7877c97-930d-4bc7-8c90-8bd0c12cc5b5',132,'55e97477dd13448d9dafe69ec8614ea6','gigabytes___DEFAULT__',1,'2025-10-03 12:58:47',NULL),('2025-10-02 12:58:58','2025-10-02 12:58:58','2025-10-02 12:58:58',1,465,'ef222901-0152-48f4-a859-7787bfb1bae1',133,'55e97477dd13448d9dafe69ec8614ea6','backups',1,'2025-10-03 12:58:58',NULL),('2025-10-02 12:58:58','2025-10-02 12:58:58','2025-10-02 12:58:58',1,466,'355366bc-1097-4a7a-9ef3-b34d10ee336e',134,'55e97477dd13448d9dafe69ec8614ea6','backup_gigabytes',1,'2025-10-03 12:58:58',NULL),('2025-10-02 12:59:05','2025-10-02 12:59:05','2025-10-02 12:59:05',1,467,'8d458e13-2f5d-4426-84ca-9128adba8f76',129,'55e97477dd13448d9dafe69ec8614ea6','volumes',1,'2025-10-03 12:59:05',NULL),('2025-10-02 12:59:05','2025-10-02 12:59:05','2025-10-02 12:59:05',1,468,'e7fc4111-8171-4c42-b007-76077456b49e',130,'55e97477dd13448d9dafe69ec8614ea6','gigabytes',1,'2025-10-03 12:59:05',NULL),('2025-10-02 12:59:05','2025-10-02 12:59:05','2025-10-02 12:59:05',1,469,'a7f8b3d6-cb25-4771-ad79-85a43355bc78',131,'55e97477dd13448d9dafe69ec8614ea6','volumes___DEFAULT__',1,'2025-10-03 12:59:05',NULL),('2025-10-02 12:59:05','2025-10-02 12:59:05','2025-10-02 12:59:05',1,470,'3daa511f-af1a-478f-a4ec-6417998e6d5a',132,'55e97477dd13448d9dafe69ec8614ea6','gigabytes___DEFAULT__',1,'2025-10-03 12:59:05',NULL),('2025-10-02 12:59:57','2025-10-02 12:59:57','2025-10-02 12:59:57',1,471,'5fce9507-6c5b-458e-b30a-0fb3b232b6d4',129,'55e97477dd13448d9dafe69ec8614ea6','volumes',-1,'2025-10-03 12:59:57',NULL),('2025-10-02 12:59:57','2025-10-02 12:59:57','2025-10-02 12:59:57',1,472,'b272146e-2640-4821-933c-ce2a6bdfcee2',130,'55e97477dd13448d9dafe69ec8614ea6','gigabytes',-1,'2025-10-03 12:59:57',NULL),('2025-10-02 12:59:57','2025-10-02 12:59:57','2025-10-02 12:59:57',1,473,'cccda322-e6a4-4be6-8e1b-080e5e2b10b7',131,'55e97477dd13448d9dafe69ec8614ea6','volumes___DEFAULT__',-1,'2025-10-03 12:59:57',NULL),('2025-10-02 12:59:57','2025-10-02 12:59:57','2025-10-02 12:59:57',1,474,'6a88aa3e-305e-4c56-b0d8-ca4685371efc',132,'55e97477dd13448d9dafe69ec8614ea6','gigabytes___DEFAULT__',-1,'2025-10-03 12:59:57',NULL),('2025-10-02 12:59:57','2025-10-02 12:59:57','2025-10-02 12:59:57',1,475,'da38cc7a-8f07-43fc-ab09-d4c0d8d7f641',133,'55e97477dd13448d9dafe69ec8614ea6','backups',-1,'2025-10-03 12:59:57',NULL),('2025-10-02 12:59:57','2025-10-02 12:59:57','2025-10-02 12:59:57',1,476,'f0a37544-1c5e-4217-b761-d4021b0db036',134,'55e97477dd13448d9dafe69ec8614ea6','backup_gigabytes',-1,'2025-10-03 12:59:57',NULL),('2025-10-02 12:59:58','2025-10-02 12:59:58','2025-10-02 12:59:58',1,477,'223af71b-f2e6-4a38-9219-fbee1251ecb7',129,'55e97477dd13448d9dafe69ec8614ea6','volumes',-1,'2025-10-03 12:59:58',NULL),('2025-10-02 12:59:58','2025-10-02 12:59:58','2025-10-02 12:59:58',1,478,'ee71a93d-23d4-4c43-be27-6ee45d04de4d',130,'55e97477dd13448d9dafe69ec8614ea6','gigabytes',-1,'2025-10-03 12:59:58',NULL),('2025-10-02 12:59:58','2025-10-02 12:59:58','2025-10-02 12:59:58',1,479,'0e63fc61-7ce3-4395-8354-bbb6918ac2a5',131,'55e97477dd13448d9dafe69ec8614ea6','volumes___DEFAULT__',-1,'2025-10-03 12:59:58',NULL),('2025-10-02 12:59:58','2025-10-02 12:59:58','2025-10-02 12:59:58',1,480,'9d4be5a0-a9ed-41f6-84df-92ef4e38f80d',132,'55e97477dd13448d9dafe69ec8614ea6','gigabytes___DEFAULT__',-1,'2025-10-03 12:59:58',NULL),('2025-10-02 13:00:28','2025-10-02 13:00:28','2025-10-02 13:00:28',1,481,'bed4d381-0614-46aa-a41a-af5baaf56ebd',125,'e7168b5b1300495d90592b195824729a','volumes',1,'2025-10-03 13:00:28',NULL),('2025-10-02 13:00:28','2025-10-02 13:00:28','2025-10-02 13:00:28',1,482,'377e7c91-c4fa-4efc-b30b-dc7f1911cf07',126,'e7168b5b1300495d90592b195824729a','gigabytes',1,'2025-10-03 13:00:28',NULL),('2025-10-02 13:00:28','2025-10-02 13:00:28','2025-10-02 13:00:28',1,483,'0cd6b324-ceed-4a7b-bc19-8ede7ca06af2',127,'e7168b5b1300495d90592b195824729a','volumes___DEFAULT__',1,'2025-10-03 13:00:28',NULL),('2025-10-02 13:00:28','2025-10-02 13:00:28','2025-10-02 13:00:28',1,484,'fecca4e8-1985-4c1f-a2cd-619f73e29cae',128,'e7168b5b1300495d90592b195824729a','gigabytes___DEFAULT__',1,'2025-10-03 13:00:28',NULL),('2025-10-02 13:00:33','2025-10-02 13:00:33','2025-10-02 13:00:33',1,485,'e3922352-a207-46d5-9d1d-cf85e7bf7b7f',125,'e7168b5b1300495d90592b195824729a','volumes',1,'2025-10-03 13:00:33',NULL),('2025-10-02 13:00:33','2025-10-02 13:00:33','2025-10-02 13:00:33',1,486,'d7e3b892-4c2c-4201-bd44-bcc503fd824f',126,'e7168b5b1300495d90592b195824729a','gigabytes',1,'2025-10-03 13:00:33',NULL),('2025-10-02 13:00:33','2025-10-02 13:00:33','2025-10-02 13:00:33',1,487,'68157743-3739-4e1e-a14b-7b63fb267650',127,'e7168b5b1300495d90592b195824729a','volumes___DEFAULT__',1,'2025-10-03 13:00:33',NULL),('2025-10-02 13:00:33','2025-10-02 13:00:33','2025-10-02 13:00:33',1,488,'8c204ac5-7ae4-433f-a975-e58024920897',128,'e7168b5b1300495d90592b195824729a','gigabytes___DEFAULT__',1,'2025-10-03 13:00:33',NULL),('2025-10-02 13:00:51','2025-10-02 13:00:51','2025-10-02 13:00:51',1,489,'98d6ade7-df36-4efd-be4a-12eb52749973',125,'e7168b5b1300495d90592b195824729a','volumes',-1,'2025-10-03 13:00:51',NULL),('2025-10-02 13:00:51','2025-10-02 13:00:51','2025-10-02 13:00:51',1,490,'6459c53c-854d-4d17-9659-8bbcb29434f5',126,'e7168b5b1300495d90592b195824729a','gigabytes',-1,'2025-10-03 13:00:51',NULL),('2025-10-02 13:00:51','2025-10-02 13:00:51','2025-10-02 13:00:51',1,491,'e690e1f9-d03a-4ec3-86f0-9685bf09807a',127,'e7168b5b1300495d90592b195824729a','volumes___DEFAULT__',-1,'2025-10-03 13:00:51',NULL),('2025-10-02 13:00:51','2025-10-02 13:00:51','2025-10-02 13:00:51',1,492,'a448c3ab-373e-4fae-9734-af829170d8d6',128,'e7168b5b1300495d90592b195824729a','gigabytes___DEFAULT__',-1,'2025-10-03 13:00:51',NULL),('2025-10-02 13:00:52','2025-10-02 13:00:52','2025-10-02 13:00:52',1,493,'371d9748-d381-469f-9f28-e72d3267da63',125,'e7168b5b1300495d90592b195824729a','volumes',-1,'2025-10-03 13:00:52',NULL),('2025-10-02 13:00:52','2025-10-02 13:00:52','2025-10-02 13:00:52',1,494,'8f1df291-fafa-4eea-8208-f789f9573d60',126,'e7168b5b1300495d90592b195824729a','gigabytes',-1,'2025-10-03 13:00:52',NULL),('2025-10-02 13:00:52','2025-10-02 13:00:52','2025-10-02 13:00:52',1,495,'4069cad0-2bdd-4f40-9a3f-63447a02a8f6',127,'e7168b5b1300495d90592b195824729a','volumes___DEFAULT__',-1,'2025-10-03 13:00:52',NULL),('2025-10-02 13:00:52','2025-10-02 13:00:52','2025-10-02 13:00:52',1,496,'52982147-77c5-4b7a-b374-8124375d5227',128,'e7168b5b1300495d90592b195824729a','gigabytes___DEFAULT__',-1,'2025-10-03 13:00:52',NULL),('2025-10-02 13:00:54','2025-10-02 13:00:54','2025-10-02 13:00:54',1,497,'dc1d73b4-e74b-464d-8a50-5fbaf3b981b3',125,'e7168b5b1300495d90592b195824729a','volumes',-1,'2025-10-03 13:00:54',NULL),('2025-10-02 13:00:54','2025-10-02 13:00:54','2025-10-02 13:00:54',1,498,'e4fa99e3-71d3-4ec9-a0ab-19a40efd3c06',126,'e7168b5b1300495d90592b195824729a','gigabytes',-1,'2025-10-03 13:00:54',NULL),('2025-10-02 13:00:54','2025-10-02 13:00:54','2025-10-02 13:00:54',1,499,'112e62fe-3429-4a17-a1c2-32343083b290',127,'e7168b5b1300495d90592b195824729a','volumes___DEFAULT__',-1,'2025-10-03 13:00:54',NULL),('2025-10-02 13:00:54','2025-10-02 13:00:54','2025-10-02 13:00:54',1,500,'802ba697-e13c-4d24-8c60-735dc9753224',128,'e7168b5b1300495d90592b195824729a','gigabytes___DEFAULT__',-1,'2025-10-03 13:00:54',NULL),('2025-10-02 13:02:27','2025-10-02 13:02:27','2025-10-02 13:02:27',1,501,'087ab560-6389-42dd-9e9a-224584fd409d',135,'5eceae619a6f4fdeaa8ba6fafda4912a','volumes',1,'2025-10-03 13:02:27',NULL),('2025-10-02 13:02:27','2025-10-02 13:02:27','2025-10-02 13:02:27',1,502,'97b10ead-f58e-49c4-ad00-2fa59ef02232',136,'5eceae619a6f4fdeaa8ba6fafda4912a','gigabytes',1,'2025-10-03 13:02:27',NULL),('2025-10-02 13:02:27','2025-10-02 13:02:27','2025-10-02 13:02:27',1,503,'8d4f14d9-6097-4a38-bce7-d009cba8ced1',137,'5eceae619a6f4fdeaa8ba6fafda4912a','volumes___DEFAULT__',1,'2025-10-03 13:02:27',NULL),('2025-10-02 13:02:27','2025-10-02 13:02:27','2025-10-02 13:02:27',1,504,'c0930ed2-b262-4c2d-a736-06af58b893c6',138,'5eceae619a6f4fdeaa8ba6fafda4912a','gigabytes___DEFAULT__',1,'2025-10-03 13:02:27',NULL),('2025-10-02 13:04:49','2025-10-02 13:04:49','2025-10-02 13:04:49',1,505,'c6d5263d-0ab0-40b8-9d8c-b21a6f9d23c2',135,'5eceae619a6f4fdeaa8ba6fafda4912a','volumes',1,'2025-10-03 13:04:49',NULL),('2025-10-02 13:04:49','2025-10-02 13:04:49','2025-10-02 13:04:49',1,506,'a2b5e9dd-ffed-48cf-af36-524ae109184b',136,'5eceae619a6f4fdeaa8ba6fafda4912a','gigabytes',1,'2025-10-03 13:04:49',NULL),('2025-10-02 13:04:49','2025-10-02 13:04:49','2025-10-02 13:04:49',1,507,'2f8e48e7-6601-4ffc-80ab-82a68a1a5438',137,'5eceae619a6f4fdeaa8ba6fafda4912a','volumes___DEFAULT__',1,'2025-10-03 13:04:49',NULL),('2025-10-02 13:04:49','2025-10-02 13:04:49','2025-10-02 13:04:49',1,508,'208690ad-420a-47cd-859a-e0584d6462b7',138,'5eceae619a6f4fdeaa8ba6fafda4912a','gigabytes___DEFAULT__',1,'2025-10-03 13:04:49',NULL),('2025-10-02 13:05:49','2025-10-02 13:05:49','2025-10-02 13:05:49',1,509,'98a2de2b-0acb-4001-9fdd-d48b14e96f40',135,'5eceae619a6f4fdeaa8ba6fafda4912a','volumes',1,'2025-10-03 13:05:49',NULL),('2025-10-02 13:05:49','2025-10-02 13:05:49','2025-10-02 13:05:49',1,510,'558bcef3-cd4a-4b5a-aa8c-2a4796feada7',136,'5eceae619a6f4fdeaa8ba6fafda4912a','gigabytes',1,'2025-10-03 13:05:49',NULL),('2025-10-02 13:05:49','2025-10-02 13:05:49','2025-10-02 13:05:49',1,511,'69266bb8-f29f-4108-97e8-e41b9e54fae0',137,'5eceae619a6f4fdeaa8ba6fafda4912a','volumes___DEFAULT__',1,'2025-10-03 13:05:49',NULL),('2025-10-02 13:05:49','2025-10-02 13:05:49','2025-10-02 13:05:49',1,512,'1f5cf241-1b71-49f4-b313-0d52d83a76b1',138,'5eceae619a6f4fdeaa8ba6fafda4912a','gigabytes___DEFAULT__',1,'2025-10-03 13:05:49',NULL),('2025-10-02 13:06:03','2025-10-02 13:06:03','2025-10-02 13:06:03',1,513,'bd87756c-74a8-4b29-88e9-f53af93b64e2',135,'5eceae619a6f4fdeaa8ba6fafda4912a','volumes',-1,'2025-10-03 13:06:03',NULL),('2025-10-02 13:06:03','2025-10-02 13:06:03','2025-10-02 13:06:03',1,514,'9de4bce0-6db9-4c05-a892-3d97e2867c3b',136,'5eceae619a6f4fdeaa8ba6fafda4912a','gigabytes',-1,'2025-10-03 13:06:03',NULL),('2025-10-02 13:06:03','2025-10-02 13:06:03','2025-10-02 13:06:03',1,515,'d01da9ac-5747-4f55-94ba-2ff486a14c0d',137,'5eceae619a6f4fdeaa8ba6fafda4912a','volumes___DEFAULT__',-1,'2025-10-03 13:06:03',NULL),('2025-10-02 13:06:03','2025-10-02 13:06:03','2025-10-02 13:06:03',1,516,'b955525d-a412-4db1-b10b-54e364c03457',138,'5eceae619a6f4fdeaa8ba6fafda4912a','gigabytes___DEFAULT__',-1,'2025-10-03 13:06:03',NULL),('2025-10-02 13:06:04','2025-10-02 13:06:04','2025-10-02 13:06:04',1,517,'f7ff12e1-e176-44c2-8abf-394369f32e5d',135,'5eceae619a6f4fdeaa8ba6fafda4912a','volumes',-1,'2025-10-03 13:06:04',NULL),('2025-10-02 13:06:04','2025-10-02 13:06:04','2025-10-02 13:06:04',1,518,'e134206c-8616-487e-8c64-ba652b8034f8',136,'5eceae619a6f4fdeaa8ba6fafda4912a','gigabytes',-1,'2025-10-03 13:06:04',NULL),('2025-10-02 13:06:04','2025-10-02 13:06:04','2025-10-02 13:06:04',1,519,'baf48cc2-19f1-4616-9738-a1ea8535acf2',137,'5eceae619a6f4fdeaa8ba6fafda4912a','volumes___DEFAULT__',-1,'2025-10-03 13:06:04',NULL),('2025-10-02 13:06:04','2025-10-02 13:06:04','2025-10-02 13:06:04',1,520,'44dc79e4-f02a-421a-bfb1-489c6c1c926b',138,'5eceae619a6f4fdeaa8ba6fafda4912a','gigabytes___DEFAULT__',-1,'2025-10-03 13:06:04',NULL),('2025-10-02 13:06:07','2025-10-02 13:06:07','2025-10-02 13:06:07',1,521,'3e310a88-8e6a-42a9-b103-62aab4453b76',135,'5eceae619a6f4fdeaa8ba6fafda4912a','volumes',-1,'2025-10-03 13:06:06',NULL),('2025-10-02 13:06:07','2025-10-02 13:06:07','2025-10-02 13:06:07',1,522,'913f2118-c282-4f42-bdad-7aeed37eb8d2',136,'5eceae619a6f4fdeaa8ba6fafda4912a','gigabytes',-1,'2025-10-03 13:06:06',NULL),('2025-10-02 13:06:07','2025-10-02 13:06:07','2025-10-02 13:06:07',1,523,'fc802841-a395-42c7-8629-df071363dc37',137,'5eceae619a6f4fdeaa8ba6fafda4912a','volumes___DEFAULT__',-1,'2025-10-03 13:06:06',NULL),('2025-10-02 13:06:07','2025-10-02 13:06:07','2025-10-02 13:06:07',1,524,'a50c4121-d749-4f79-bbc6-bb3a9999450b',138,'5eceae619a6f4fdeaa8ba6fafda4912a','gigabytes___DEFAULT__',-1,'2025-10-03 13:06:06',NULL),('2025-10-02 13:10:27','2025-10-02 13:10:27','2025-10-02 13:10:27',1,525,'5e65c021-36c9-47bf-b5ea-afe40d49b801',139,'fbbc6cb494464fd9b31f64c1ad75fa6b','volumes',1,'2025-10-03 13:10:27',NULL),('2025-10-02 13:10:27','2025-10-02 13:10:27','2025-10-02 13:10:27',1,526,'b4186b56-fcc6-47df-b0ad-18b81c685e13',140,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes',1,'2025-10-03 13:10:27',NULL),('2025-10-02 13:10:27','2025-10-02 13:10:27','2025-10-02 13:10:27',1,527,'f2a62c28-ed3d-4b45-9621-7be74f53f9a0',141,'fbbc6cb494464fd9b31f64c1ad75fa6b','volumes_tempest-scenario-type-luks-849096102',1,'2025-10-03 13:10:27',NULL),('2025-10-02 13:10:27','2025-10-02 13:10:27','2025-10-02 13:10:27',1,528,'9d8864bc-c326-4cb2-a4ad-e51d173663cd',142,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes_tempest-scenario-type-luks-849096102',1,'2025-10-03 13:10:27',NULL),('2025-10-02 13:10:57','2025-10-02 13:10:57','2025-10-02 13:10:57',1,529,'81aca262-014c-441e-98d4-cd0b07f230b0',139,'fbbc6cb494464fd9b31f64c1ad75fa6b','volumes',-1,'2025-10-03 13:10:56',NULL),('2025-10-02 13:10:57','2025-10-02 13:10:57','2025-10-02 13:10:57',1,530,'54c01c56-71ca-4d38-9e78-96eb109643bd',140,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes',-1,'2025-10-03 13:10:56',NULL),('2025-10-02 13:10:57','2025-10-02 13:10:57','2025-10-02 13:10:57',1,531,'49efaf9d-e072-4c81-bb7c-7441cc5b9c24',141,'fbbc6cb494464fd9b31f64c1ad75fa6b','volumes_tempest-scenario-type-luks-849096102',-1,'2025-10-03 13:10:56',NULL),('2025-10-02 13:10:57','2025-10-02 13:10:57','2025-10-02 13:10:57',1,532,'06d7843f-4c37-4aad-a8ee-225d479166f4',142,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes_tempest-scenario-type-luks-849096102',-1,'2025-10-03 13:10:56',NULL),('2025-10-02 13:10:58','2025-10-02 13:10:59','2025-10-02 13:10:59',1,533,'59c0fde2-d00e-4fe9-89f0-27ad8c02e30f',139,'fbbc6cb494464fd9b31f64c1ad75fa6b','volumes',1,'2025-10-03 13:10:58',NULL),('2025-10-02 13:10:58','2025-10-02 13:10:59','2025-10-02 13:10:59',1,534,'111c9d3a-3542-4883-bb5b-f8c60676a9da',140,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes',1,'2025-10-03 13:10:58',NULL),('2025-10-02 13:10:58','2025-10-02 13:10:59','2025-10-02 13:10:59',1,535,'0ba76b87-8efc-4804-9fcc-6f05b17bb38c',143,'fbbc6cb494464fd9b31f64c1ad75fa6b','volumes___DEFAULT__',1,'2025-10-03 13:10:58',NULL),('2025-10-02 13:10:58','2025-10-02 13:10:59','2025-10-02 13:10:59',1,536,'2a3bf081-3626-4375-9099-325add22128f',144,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes___DEFAULT__',1,'2025-10-03 13:10:58',NULL),('2025-10-02 13:11:06','2025-10-02 13:11:06','2025-10-02 13:11:06',1,537,'fede01a3-f474-4a43-b952-b960c3cc3b0a',145,'fbbc6cb494464fd9b31f64c1ad75fa6b','snapshots',1,'2025-10-03 13:11:06',NULL),('2025-10-02 13:11:06','2025-10-02 13:11:06','2025-10-02 13:11:06',1,538,'ac1e566f-16bf-4326-a8c9-119f1c7e5221',140,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes',1,'2025-10-03 13:11:06',NULL),('2025-10-02 13:11:06','2025-10-02 13:11:06','2025-10-02 13:11:06',1,539,'97ecf1c9-45df-4a1f-8c4d-3b7cd0aacf2e',144,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes___DEFAULT__',1,'2025-10-03 13:11:06',NULL),('2025-10-02 13:11:06','2025-10-02 13:11:06','2025-10-02 13:11:06',1,540,'04417f1c-56e6-46d2-b499-8db5e83dfe1b',146,'fbbc6cb494464fd9b31f64c1ad75fa6b','snapshots___DEFAULT__',1,'2025-10-03 13:11:06',NULL),('2025-10-02 13:11:11','2025-10-02 13:11:11','2025-10-02 13:11:11',1,541,'b345a190-af5a-44f3-8098-1acf987d1cef',139,'fbbc6cb494464fd9b31f64c1ad75fa6b','volumes',1,'2025-10-03 13:11:11',NULL),('2025-10-02 13:11:11','2025-10-02 13:11:11','2025-10-02 13:11:11',1,542,'d630bc4b-a9f7-4640-8edc-0ff5321acc4c',140,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes',1,'2025-10-03 13:11:11',NULL),('2025-10-02 13:11:11','2025-10-02 13:11:11','2025-10-02 13:11:11',1,543,'267f78e7-0265-45f6-87d1-1c4c83403c66',143,'fbbc6cb494464fd9b31f64c1ad75fa6b','volumes___DEFAULT__',1,'2025-10-03 13:11:11',NULL),('2025-10-02 13:11:11','2025-10-02 13:11:11','2025-10-02 13:11:11',1,544,'8c33b8d5-2ff2-4e21-85c0-1c7c1add3ba2',144,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes___DEFAULT__',1,'2025-10-03 13:11:11',NULL),('2025-10-02 13:11:27','2025-10-02 13:11:27','2025-10-02 13:11:27',1,545,'f1fc71dd-1d67-4d07-b0f6-586f0b18c5fc',139,'fbbc6cb494464fd9b31f64c1ad75fa6b','volumes',-1,'2025-10-03 13:11:27',NULL),('2025-10-02 13:11:27','2025-10-02 13:11:27','2025-10-02 13:11:27',1,546,'376c55ef-b8e5-49cf-9f1c-31c61fcc6843',140,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes',-1,'2025-10-03 13:11:27',NULL),('2025-10-02 13:11:27','2025-10-02 13:11:27','2025-10-02 13:11:27',1,547,'acc03452-1096-488c-9e98-46e57226016e',143,'fbbc6cb494464fd9b31f64c1ad75fa6b','volumes___DEFAULT__',-1,'2025-10-03 13:11:27',NULL),('2025-10-02 13:11:27','2025-10-02 13:11:27','2025-10-02 13:11:27',1,548,'3ada71b2-ae2c-49a1-ada3-057480141ad9',144,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes___DEFAULT__',-1,'2025-10-03 13:11:27',NULL),('2025-10-02 13:11:30','2025-10-02 13:11:30','2025-10-02 13:11:30',1,549,'bab16205-193e-4c3b-8e3c-3bbea406a03c',145,'fbbc6cb494464fd9b31f64c1ad75fa6b','snapshots',-1,'2025-10-03 13:11:30',NULL),('2025-10-02 13:11:30','2025-10-02 13:11:30','2025-10-02 13:11:30',1,550,'2c5524fd-30b6-4e5e-903c-1f274c320710',140,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes',-1,'2025-10-03 13:11:30',NULL),('2025-10-02 13:11:30','2025-10-02 13:11:30','2025-10-02 13:11:30',1,551,'5b3b8fc7-7911-4703-8b8a-b710f2cd0ccb',144,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes___DEFAULT__',-1,'2025-10-03 13:11:30',NULL),('2025-10-02 13:11:30','2025-10-02 13:11:30','2025-10-02 13:11:30',1,552,'82901a1c-eaab-4c0d-9a69-f407f7b01113',146,'fbbc6cb494464fd9b31f64c1ad75fa6b','snapshots___DEFAULT__',-1,'2025-10-03 13:11:30',NULL),('2025-10-02 13:11:31','2025-10-02 13:11:31','2025-10-02 13:11:31',1,553,'627b7df0-89fb-4f10-8ae4-2c08dc5ba9a0',139,'fbbc6cb494464fd9b31f64c1ad75fa6b','volumes',-1,'2025-10-03 13:11:31',NULL),('2025-10-02 13:11:31','2025-10-02 13:11:31','2025-10-02 13:11:31',1,554,'4f76baed-76b6-4fac-8c95-07234d9c6e7f',140,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes',-1,'2025-10-03 13:11:31',NULL),('2025-10-02 13:11:31','2025-10-02 13:11:31','2025-10-02 13:11:31',1,555,'8b3802ca-bc17-462d-babf-ab1ec29cc3f1',143,'fbbc6cb494464fd9b31f64c1ad75fa6b','volumes___DEFAULT__',-1,'2025-10-03 13:11:31',NULL),('2025-10-02 13:11:31','2025-10-02 13:11:31','2025-10-02 13:11:31',1,556,'b596d95b-c643-41b4-a734-1c6c37a329a8',144,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes___DEFAULT__',-1,'2025-10-03 13:11:31',NULL),('2025-10-02 13:11:33','2025-10-02 13:11:33','2025-10-02 13:11:33',1,557,'97c0c653-75c8-4148-b7f6-b4abb1407463',139,'fbbc6cb494464fd9b31f64c1ad75fa6b','volumes',1,'2025-10-03 13:11:33',NULL),('2025-10-02 13:11:33','2025-10-02 13:11:33','2025-10-02 13:11:33',1,558,'94b145e9-0b4a-4dcd-befc-83f0a3b8c946',140,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes',1,'2025-10-03 13:11:33',NULL),('2025-10-02 13:11:33','2025-10-02 13:11:33','2025-10-02 13:11:33',1,559,'6411c2a3-d955-4802-87ed-821530359956',143,'fbbc6cb494464fd9b31f64c1ad75fa6b','volumes___DEFAULT__',1,'2025-10-03 13:11:33',NULL),('2025-10-02 13:11:33','2025-10-02 13:11:33','2025-10-02 13:11:33',1,560,'c816853f-82eb-4458-b9fc-22852b2dce84',144,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes___DEFAULT__',1,'2025-10-03 13:11:33',NULL),('2025-10-02 13:12:19','2025-10-02 13:12:19','2025-10-02 13:12:19',1,561,'d5c72a03-1ecc-452e-a13e-e614f434748c',145,'fbbc6cb494464fd9b31f64c1ad75fa6b','snapshots',1,'2025-10-03 13:12:19',NULL),('2025-10-02 13:12:19','2025-10-02 13:12:19','2025-10-02 13:12:19',1,562,'9342300e-8d90-4d94-a293-e9c5a4713e16',140,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes',1,'2025-10-03 13:12:19',NULL),('2025-10-02 13:12:19','2025-10-02 13:12:19','2025-10-02 13:12:19',1,563,'7c3add85-1791-450f-aad2-20562cf9cbf1',144,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes___DEFAULT__',1,'2025-10-03 13:12:19',NULL),('2025-10-02 13:12:19','2025-10-02 13:12:19','2025-10-02 13:12:19',1,564,'dcee7964-0292-4740-8558-e379ab639411',146,'fbbc6cb494464fd9b31f64c1ad75fa6b','snapshots___DEFAULT__',1,'2025-10-03 13:12:19',NULL),('2025-10-02 13:12:29','2025-10-02 13:12:29','2025-10-02 13:12:29',1,565,'8175c003-74f8-4bc2-85b4-1fd26fc1e0de',139,'fbbc6cb494464fd9b31f64c1ad75fa6b','volumes',1,'2025-10-03 13:12:29',NULL),('2025-10-02 13:12:29','2025-10-02 13:12:29','2025-10-02 13:12:29',1,566,'9fea3210-40ab-4758-b8ff-4f070ec813ed',140,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes',1,'2025-10-03 13:12:29',NULL),('2025-10-02 13:12:29','2025-10-02 13:12:29','2025-10-02 13:12:29',1,567,'243e7419-5fa1-4ca5-a313-8ee1bc981d2c',143,'fbbc6cb494464fd9b31f64c1ad75fa6b','volumes___DEFAULT__',1,'2025-10-03 13:12:29',NULL),('2025-10-02 13:12:29','2025-10-02 13:12:29','2025-10-02 13:12:29',1,568,'fbd5ad8c-a006-4196-9cce-d42336878ec8',144,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes___DEFAULT__',1,'2025-10-03 13:12:29',NULL),('2025-10-02 13:13:23','2025-10-02 13:13:23','2025-10-02 13:13:23',1,569,'355228fc-0a00-4b7c-aace-eceb24317778',139,'fbbc6cb494464fd9b31f64c1ad75fa6b','volumes',-1,'2025-10-03 13:13:23',NULL),('2025-10-02 13:13:23','2025-10-02 13:13:23','2025-10-02 13:13:23',1,570,'61dab853-99cd-4114-bf86-9e40b03966af',140,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes',-1,'2025-10-03 13:13:23',NULL),('2025-10-02 13:13:23','2025-10-02 13:13:23','2025-10-02 13:13:23',1,571,'26454fba-4f55-4690-a78e-677fd9fbe51f',143,'fbbc6cb494464fd9b31f64c1ad75fa6b','volumes___DEFAULT__',-1,'2025-10-03 13:13:23',NULL),('2025-10-02 13:13:23','2025-10-02 13:13:23','2025-10-02 13:13:23',1,572,'47f91651-37d3-43d8-8c37-31f31712cdeb',144,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes___DEFAULT__',-1,'2025-10-03 13:13:23',NULL),('2025-10-02 13:13:25','2025-10-02 13:13:25','2025-10-02 13:13:25',1,573,'3c0f881c-c118-4ee0-b7b7-f14ba0855d1d',145,'fbbc6cb494464fd9b31f64c1ad75fa6b','snapshots',-1,'2025-10-03 13:13:25',NULL),('2025-10-02 13:13:25','2025-10-02 13:13:25','2025-10-02 13:13:25',1,574,'6f0d519a-b9a5-443d-a8b5-70d6ac63f7ac',140,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes',-1,'2025-10-03 13:13:25',NULL),('2025-10-02 13:13:25','2025-10-02 13:13:25','2025-10-02 13:13:25',1,575,'ee57e05c-69c2-4dea-880f-e5a8f2be9ed3',144,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes___DEFAULT__',-1,'2025-10-03 13:13:25',NULL),('2025-10-02 13:13:25','2025-10-02 13:13:25','2025-10-02 13:13:25',1,576,'68ff9d7b-0729-4da9-86f6-2afe16eea4e7',146,'fbbc6cb494464fd9b31f64c1ad75fa6b','snapshots___DEFAULT__',-1,'2025-10-03 13:13:25',NULL),('2025-10-02 13:13:32','2025-10-02 13:13:32','2025-10-02 13:13:32',1,577,'280bd045-4427-4120-ae6b-83489211cbd0',139,'fbbc6cb494464fd9b31f64c1ad75fa6b','volumes',-1,'2025-10-03 13:13:32',NULL),('2025-10-02 13:13:32','2025-10-02 13:13:32','2025-10-02 13:13:32',1,578,'579adb72-1b7a-4bfb-aefc-248a3e2aee93',140,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes',-1,'2025-10-03 13:13:32',NULL),('2025-10-02 13:13:32','2025-10-02 13:13:32','2025-10-02 13:13:32',1,579,'e0cc1ea0-7490-4027-b3d7-a9132ec89eb0',143,'fbbc6cb494464fd9b31f64c1ad75fa6b','volumes___DEFAULT__',-1,'2025-10-03 13:13:32',NULL),('2025-10-02 13:13:32','2025-10-02 13:13:32','2025-10-02 13:13:32',1,580,'4157d9be-3a51-4ed9-9ec7-424878602a7b',144,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes___DEFAULT__',-1,'2025-10-03 13:13:32',NULL),('2025-10-02 13:13:45','2025-10-02 13:13:45','2025-10-02 13:13:45',1,581,'4ea24f49-282d-4214-90ec-ede0070c38c0',139,'fbbc6cb494464fd9b31f64c1ad75fa6b','volumes',1,'2025-10-03 13:13:45',NULL),('2025-10-02 13:13:45','2025-10-02 13:13:45','2025-10-02 13:13:45',1,582,'2edc69a7-aa57-4dca-ae2e-6df75e106021',140,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes',1,'2025-10-03 13:13:45',NULL),('2025-10-02 13:13:45','2025-10-02 13:13:45','2025-10-02 13:13:45',1,583,'d638816c-383c-4dc2-adf7-f05c7c8e82d3',143,'fbbc6cb494464fd9b31f64c1ad75fa6b','volumes___DEFAULT__',1,'2025-10-03 13:13:45',NULL),('2025-10-02 13:13:45','2025-10-02 13:13:45','2025-10-02 13:13:45',1,584,'f86ed25a-36b5-4d39-b656-95daf5d4e9b2',144,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes___DEFAULT__',1,'2025-10-03 13:13:45',NULL),('2025-10-02 13:15:13','2025-10-02 13:15:13','2025-10-02 13:15:13',1,585,'ee897d9b-97df-4f4a-8b78-3b30ccba6913',145,'fbbc6cb494464fd9b31f64c1ad75fa6b','snapshots',1,'2025-10-03 13:15:13',NULL),('2025-10-02 13:15:13','2025-10-02 13:15:13','2025-10-02 13:15:13',1,586,'6b67a0fa-b814-4b11-9b66-b8e6ff677aff',140,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes',1,'2025-10-03 13:15:13',NULL),('2025-10-02 13:15:13','2025-10-02 13:15:13','2025-10-02 13:15:13',1,587,'4f61e13d-1a41-4adf-8692-4168713c6287',144,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes___DEFAULT__',1,'2025-10-03 13:15:13',NULL),('2025-10-02 13:15:13','2025-10-02 13:15:13','2025-10-02 13:15:13',1,588,'ba561482-a0be-40ac-8261-c973ef9c71fb',146,'fbbc6cb494464fd9b31f64c1ad75fa6b','snapshots___DEFAULT__',1,'2025-10-03 13:15:13',NULL),('2025-10-02 13:15:16','2025-10-02 13:15:16','2025-10-02 13:15:16',1,589,'da77a30c-d16b-4a62-a84b-7bbc4403d920',139,'fbbc6cb494464fd9b31f64c1ad75fa6b','volumes',1,'2025-10-03 13:15:16',NULL),('2025-10-02 13:15:16','2025-10-02 13:15:16','2025-10-02 13:15:16',1,590,'28eb6958-7e4d-472e-8523-a7ede60a5cd6',140,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes',1,'2025-10-03 13:15:16',NULL),('2025-10-02 13:15:16','2025-10-02 13:15:16','2025-10-02 13:15:16',1,591,'b6fcf89f-7360-4c04-9e32-16904ea89128',143,'fbbc6cb494464fd9b31f64c1ad75fa6b','volumes___DEFAULT__',1,'2025-10-03 13:15:16',NULL),('2025-10-02 13:15:16','2025-10-02 13:15:16','2025-10-02 13:15:16',1,592,'c5cb72b3-f041-43fe-9d5d-f15073ea8fac',144,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes___DEFAULT__',1,'2025-10-03 13:15:16',NULL),('2025-10-02 13:16:03','2025-10-02 13:16:03','2025-10-02 13:16:03',1,593,'23b30d96-0bef-4696-b51d-b3d70e645660',139,'fbbc6cb494464fd9b31f64c1ad75fa6b','volumes',-1,'2025-10-03 13:16:03',NULL),('2025-10-02 13:16:03','2025-10-02 13:16:03','2025-10-02 13:16:03',1,594,'355d9fdb-2874-4c7b-9946-3f8bff10b5a5',140,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes',-1,'2025-10-03 13:16:03',NULL),('2025-10-02 13:16:03','2025-10-02 13:16:03','2025-10-02 13:16:03',1,595,'5d9b7226-c7ce-4445-850e-f273d8574902',143,'fbbc6cb494464fd9b31f64c1ad75fa6b','volumes___DEFAULT__',-1,'2025-10-03 13:16:03',NULL),('2025-10-02 13:16:03','2025-10-02 13:16:03','2025-10-02 13:16:03',1,596,'b9ee0fb4-ea9b-40b0-a9a9-e86295ebd9be',144,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes___DEFAULT__',-1,'2025-10-03 13:16:03',NULL),('2025-10-02 13:16:05','2025-10-02 13:16:05','2025-10-02 13:16:05',1,597,'75dc72fd-ddfe-43c1-8b67-5eef66c80733',145,'fbbc6cb494464fd9b31f64c1ad75fa6b','snapshots',-1,'2025-10-03 13:16:05',NULL),('2025-10-02 13:16:05','2025-10-02 13:16:05','2025-10-02 13:16:05',1,598,'58995ab5-8250-4f3d-bfce-3227d8bcd2df',140,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes',-1,'2025-10-03 13:16:05',NULL),('2025-10-02 13:16:05','2025-10-02 13:16:05','2025-10-02 13:16:05',1,599,'389e2d6c-fc10-4257-b0a2-48f33c1b8756',144,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes___DEFAULT__',-1,'2025-10-03 13:16:05',NULL),('2025-10-02 13:16:05','2025-10-02 13:16:05','2025-10-02 13:16:05',1,600,'6b995e1e-9ee3-4b21-8903-30d664dc8df8',146,'fbbc6cb494464fd9b31f64c1ad75fa6b','snapshots___DEFAULT__',-1,'2025-10-03 13:16:05',NULL),('2025-10-02 13:16:13','2025-10-02 13:16:13','2025-10-02 13:16:13',1,601,'ec35b30b-3a24-4cb8-b0f9-a7d144fed58f',139,'fbbc6cb494464fd9b31f64c1ad75fa6b','volumes',-1,'2025-10-03 13:16:13',NULL),('2025-10-02 13:16:13','2025-10-02 13:16:13','2025-10-02 13:16:13',1,602,'585a93cd-1d16-4824-a81d-6870744a89e7',140,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes',-1,'2025-10-03 13:16:13',NULL),('2025-10-02 13:16:13','2025-10-02 13:16:13','2025-10-02 13:16:13',1,603,'d28d17a0-77ae-4a8c-a7bd-26e2e6094546',143,'fbbc6cb494464fd9b31f64c1ad75fa6b','volumes___DEFAULT__',-1,'2025-10-03 13:16:13',NULL),('2025-10-02 13:16:13','2025-10-02 13:16:13','2025-10-02 13:16:13',1,604,'e239d6fe-2195-4e70-a2c6-9b939c2da137',144,'fbbc6cb494464fd9b31f64c1ad75fa6b','gigabytes___DEFAULT__',-1,'2025-10-03 13:16:13',NULL);
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `rpc_current_version` varchar(36) DEFAULT NULL,
  `object_current_version` varchar(36) DEFAULT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `frozen` tinyint(1) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `services_uuid_idx` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone`, `disabled_reason`, `modified_at`, `rpc_current_version`, `object_current_version`, `replication_status`, `frozen`, `active_backend_id`, `cluster_name`, `uuid`) VALUES ('2025-10-02 11:13:31','2025-10-02 13:39:15',NULL,0,1,'cinder-scheduler-0','cinder-scheduler','cinder-scheduler',868,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'5b5a7282-a41e-404f-8b48-f6510e089997'),('2025-10-02 11:53:54','2025-10-02 13:39:20',NULL,0,2,'hostgroup@ceph','cinder-volume','cinder-volume',631,0,'nova',NULL,NULL,'3.18','1.39','disabled',0,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f'),('2025-10-02 11:53:54','2025-10-02 13:39:18',NULL,0,3,'cinder-backup-0','cinder-backup','cinder-backup',632,0,'nova',NULL,NULL,'2.4','1.39','not-capable',0,NULL,NULL,'4b91577f-ddab-4c01-b784-d438b53cf56d');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot_metadata`
--

DROP TABLE IF EXISTS `snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshot_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `snapshot_metadata_ibfk_1` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot_metadata`
--

LOCK TABLES `snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `snapshot_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshots`
--

DROP TABLE IF EXISTS `snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `volume_size` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `provider_auth` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshots_cgsnapshot_id` (`cgsnapshot_id`),
  KEY `ix_snapshots_volume_id` (`volume_id`),
  KEY `ix_snapshots_group_snapshot_id` (`group_snapshot_id`),
  KEY `snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `snapshots_ibfk_1` FOREIGN KEY (`cgsnapshot_id`) REFERENCES `cgsnapshots` (`id`),
  CONSTRAINT `snapshots_ibfk_2` FOREIGN KEY (`group_snapshot_id`) REFERENCES `group_snapshots` (`id`),
  CONSTRAINT `snapshots_volume_id_fkey` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshots`
--

LOCK TABLES `snapshots` WRITE;
/*!40000 ALTER TABLE `snapshots` DISABLE KEYS */;
INSERT INTO `snapshots` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `status`, `progress`, `volume_size`, `scheduled_at`, `display_name`, `display_description`, `provider_location`, `encryption_key_id`, `volume_type_id`, `cgsnapshot_id`, `provider_id`, `provider_auth`, `group_snapshot_id`, `use_quota`) VALUES ('2025-10-02 12:47:57','2025-10-02 12:49:24','2025-10-02 12:49:25',1,'53e30990-58b9-46e2-ae20-e6aa25e4f4af','23d0d8ce-0e39-4b00-81b2-fea970998125','a24a7109471f4d96ad5f11b637fdb8e7','a837417d42da439cb794b4295bca2cee','deleted','100%',1,NULL,'tempest-TestStampPattern-snapshot-1351541154',NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,NULL,NULL,NULL,1),('2025-10-02 12:41:58','2025-10-02 12:42:17','2025-10-02 12:42:19',1,'61a6e88e-f27e-4d93-ab75-e7b2718d7e5f','daaee0e4-d0d6-43f1-84a2-7bb4d00c48ef','734ae44830d540d8ab51c2a3d75ecd80','2e53064cd4d645f09bd59bbca09b98e0','deleted','100%',1,NULL,'tempest-TestMinimumBasicScenario-snapshot-676672431',NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,NULL,NULL,NULL,1),('2025-10-02 12:38:57','2025-10-02 12:39:12','2025-10-02 12:39:16',1,'646cf255-247a-4f2f-8d7a-2846453918b8','096a7aaa-7a08-4732-99f8-fc03083273ca','00f7abe349fb496aaeb6c928e3602a2b','2a9fb2f388654380906f2a0db9d46565','deleted','100%',1,NULL,'tempest-VolumesSnapshotsTestJSON-Snapshot-1850484804',NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,NULL,NULL,NULL,1),('2025-10-02 13:12:19','2025-10-02 13:13:24','2025-10-02 13:13:25',1,'aa979228-d578-4819-bd72-9a5d1ac2ab6f','cce428bb-67ad-45c7-9e76-52ebd4f984b0','c10de71fef00497981b8b7cec6a3fff3','fbbc6cb494464fd9b31f64c1ad75fa6b','deleted','100%',1,NULL,'snapshot for tempest-TestVolumeBootPatternsnapshot-957026105',NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,NULL,NULL,NULL,1),('2025-10-02 12:32:39','2025-10-02 12:32:47','2025-10-02 12:32:48',1,'ca60f0ab-6431-4851-87b3-164a993c75aa','3c189565-c036-47f3-b9f5-ed22810ceabf','22d56fcd2a4b4851bfd126ae4548ee9b','5533aaac08cd4856af72ef4992bb5e76','deleted','100%',1,NULL,'snapshot for multiattach-snapshot',NULL,NULL,NULL,'a5770664-6668-4712-8ea2-73ff2103264d',NULL,NULL,NULL,NULL,1),('2025-10-02 13:15:13','2025-10-02 13:16:04','2025-10-02 13:16:05',1,'f55859d5-64f0-4bc8-b298-3498e2ffc230','970cb928-04fe-4f96-87d5-ef615b8da829','c10de71fef00497981b8b7cec6a3fff3','fbbc6cb494464fd9b31f64c1ad75fa6b','deleted','100%',1,NULL,'tempest-TestVolumeBootPattern-snapshot-1490516457',NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,NULL,NULL,NULL,1),('2025-10-02 13:11:06','2025-10-02 13:11:29','2025-10-02 13:11:30',1,'fbd3196a-4338-47e7-a120-33dcd2b49454','7f222a34-b6b2-4826-ac62-a6a1d06ec099','c10de71fef00497981b8b7cec6a3fff3','fbbc6cb494464fd9b31f64c1ad75fa6b','deleted','100%',1,NULL,'tempest-TestVolumeBootPattern-snapshot-402404993',NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,NULL,NULL,NULL,1);
/*!40000 ALTER TABLE `snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `no_snapshots` tinyint(1) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_transfers_volume_id` (`volume_id`),
  CONSTRAINT `transfers_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_admin_metadata`
--

DROP TABLE IF EXISTS `volume_admin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_admin_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_admin_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_admin_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_admin_metadata`
--

LOCK TABLES `volume_admin_metadata` WRITE;
/*!40000 ALTER TABLE `volume_admin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_admin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_attachment`
--

DROP TABLE IF EXISTS `volume_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_attachment` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `attached_host` varchar(255) DEFAULT NULL,
  `instance_uuid` varchar(36) DEFAULT NULL,
  `mountpoint` varchar(255) DEFAULT NULL,
  `attach_time` datetime DEFAULT NULL,
  `detach_time` datetime DEFAULT NULL,
  `attach_mode` varchar(36) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `connection_info` text DEFAULT NULL,
  `connector` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_attachment_volume_id` (`volume_id`),
  CONSTRAINT `volume_attachment_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_attachment`
--

LOCK TABLES `volume_attachment` WRITE;
/*!40000 ALTER TABLE `volume_attachment` DISABLE KEYS */;
INSERT INTO `volume_attachment` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `attached_host`, `instance_uuid`, `mountpoint`, `attach_time`, `detach_time`, `attach_mode`, `attach_status`, `connection_info`, `connector`) VALUES ('2025-10-02 13:13:57','2025-10-02 13:14:31','2025-10-02 13:14:31',1,'01f8bf84-6d8f-4775-bd13-75d060fe0464','970cb928-04fe-4f96-87d5-ef615b8da829','compute-0.ctlplane.example.com','7398ed9d-ac95-47e9-8de9-af875d198202','/dev/vda','2025-10-02 13:14:00','2025-10-02 13:14:31','rw','detached','{\"name\": \"volumes/volume-970cb928-04fe-4f96-87d5-ef615b8da829\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"970cb928-04fe-4f96-87d5-ef615b8da829\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"01f8bf84-6d8f-4775-bd13-75d060fe0464\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:89256e26a090\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a59133c-d138-4412-952a-4a6587089b61\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:52:54','2025-10-02 12:54:45','2025-10-02 12:54:45',1,'02900367-394e-4e77-ba2a-547333f78a5a','7708c28d-8dd9-455b-9cf8-550d89fddce1','compute-1.ctlplane.example.com','f5646848-ae0c-448c-9912-d5ee5734bd1e','/dev/vdb','2025-10-02 12:53:03','2025-10-02 12:54:45','rw','detached','{\"name\": \"volumes/volume-7708c28d-8dd9-455b-9cf8-550d89fddce1\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"7708c28d-8dd9-455b-9cf8-550d89fddce1\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"02900367-394e-4e77-ba2a-547333f78a5a\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a46b55b0f33d\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"1113ba57-9df9-4fb0-a2ed-0ca31cebd82a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:35:05','2025-10-02 12:36:14','2025-10-02 12:36:14',1,'045962c8-90e7-4348-aad0-c3be55d6ec09','5134bab8-913f-41c9-b5b8-350b459c53e1','compute-0.ctlplane.example.com','7b3aa782-5b49-4fe9-8bbb-4e43b3c8da75','/dev/vdb','2025-10-02 12:35:06','2025-10-02 12:36:14','rw','detached','{\"name\": \"volumes/volume-5134bab8-913f-41c9-b5b8-350b459c53e1\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"5134bab8-913f-41c9-b5b8-350b459c53e1\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"045962c8-90e7-4348-aad0-c3be55d6ec09\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:89256e26a090\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a59133c-d138-4412-952a-4a6587089b61\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:57:58','2025-10-02 12:58:49','2025-10-02 12:58:49',1,'123ee2b6-4c88-4103-8e74-213ec4835687','c4c3ee6e-d57f-4361-8cda-389d0f995821','compute-0.ctlplane.example.com','01108902-768b-4bee-baff-11d5854e2f77','/dev/vdb','2025-10-02 12:57:59','2025-10-02 12:58:49','rw','detached','{\"name\": \"volumes/volume-c4c3ee6e-d57f-4361-8cda-389d0f995821\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"c4c3ee6e-d57f-4361-8cda-389d0f995821\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"123ee2b6-4c88-4103-8e74-213ec4835687\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:89256e26a090\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a59133c-d138-4412-952a-4a6587089b61\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:18:36','2025-10-02 12:19:38','2025-10-02 12:19:38',1,'1b8757e1-8403-4389-af1f-b49cc389a462','6418770c-0612-4553-8861-921425b3c82e','compute-0.ctlplane.example.com','fab74f5b-b97e-42c7-89ac-6cc796bf5b74','/dev/vda','2025-10-02 12:18:40','2025-10-02 12:19:38','rw','detached','{\"name\": \"volumes/volume-6418770c-0612-4553-8861-921425b3c82e\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"6418770c-0612-4553-8861-921425b3c82e\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"1b8757e1-8403-4389-af1f-b49cc389a462\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:89256e26a090\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a59133c-d138-4412-952a-4a6587089b61\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:41:34','2025-10-02 12:42:04','2025-10-02 12:42:04',1,'1be79524-2048-4e8d-9bdd-a2a2c35a9a17','bc8a781d-7240-4c85-8671-db184dc7c32b','compute-2.ctlplane.example.com','5a11dca9-ede5-4fdd-af8e-7936ff4f9980','/dev/vdb','2025-10-02 12:41:36','2025-10-02 12:42:04','rw','detached','{\"name\": \"volumes/volume-bc8a781d-7240-4c85-8671-db184dc7c32b\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"bc8a781d-7240-4c85-8671-db184dc7c32b\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"1be79524-2048-4e8d-9bdd-a2a2c35a9a17\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7daf2c659dfe\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"93278213-1c3c-4fb4-9fd1-d481e0b53ce1\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:16:34','2025-10-02 12:18:13','2025-10-02 12:18:13',1,'1c5135d3-fcf3-4e66-8457-e1dbd53ff6a6','5566db4c-b0ba-4d2b-84a6-1fa1272fec0f','compute-0.ctlplane.example.com','d7e14705-7aeb-440f-8e7e-926cc5b5ab6f','/dev/vdc','2025-10-02 12:16:43','2025-10-02 12:18:13','rw','detached','{\"name\": \"volumes/volume-5566db4c-b0ba-4d2b-84a6-1fa1272fec0f\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"5566db4c-b0ba-4d2b-84a6-1fa1272fec0f\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"1c5135d3-fcf3-4e66-8457-e1dbd53ff6a6\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:89256e26a090\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a59133c-d138-4412-952a-4a6587089b61\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-10-02 12:44:06','2025-10-02 12:45:27','2025-10-02 12:45:27',1,'1c9af883-4d21-48b6-9e77-fd71aed53dbf','5711af91-e6ed-47a0-ad60-a4e65171a2af','compute-0.ctlplane.example.com','4a3d81a0-ce3a-4e61-a0a6-a0eab9546dbf','/dev/vdb','2025-10-02 12:44:07','2025-10-02 12:45:27','rw','detached','{\"name\": \"volumes/volume-5711af91-e6ed-47a0-ad60-a4e65171a2af\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"5711af91-e6ed-47a0-ad60-a4e65171a2af\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"1c9af883-4d21-48b6-9e77-fd71aed53dbf\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:89256e26a090\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a59133c-d138-4412-952a-4a6587089b61\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:20:04','2025-10-02 12:21:29','2025-10-02 12:21:29',1,'1d4eb9f7-4a35-4822-9150-ca4533c919eb','df389b61-10b1-4346-9fa3-6333d5b9d5cf','compute-2.ctlplane.example.com','969ba235-be4a-44e1-a6f2-7c5922b9661e','/dev/vdb','2025-10-02 12:20:12','2025-10-02 12:21:29','rw','detached','{\"name\": \"volumes/volume-df389b61-10b1-4346-9fa3-6333d5b9d5cf\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"df389b61-10b1-4346-9fa3-6333d5b9d5cf\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"1d4eb9f7-4a35-4822-9150-ca4533c919eb\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7daf2c659dfe\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"93278213-1c3c-4fb4-9fd1-d481e0b53ce1\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 13:12:33','2025-10-02 13:13:18','2025-10-02 13:13:18',1,'262bed8e-b429-414f-a538-1eb85633f691','6e153e1f-2b24-48a4-97ce-843802b3972c','compute-1.ctlplane.example.com','b66520bc-5f0e-4a9c-80bd-531f2a57dc67','/dev/vda','2025-10-02 13:12:34','2025-10-02 13:13:18','rw','detached','{\"name\": \"volumes/volume-6e153e1f-2b24-48a4-97ce-843802b3972c\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"6e153e1f-2b24-48a4-97ce-843802b3972c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"262bed8e-b429-414f-a538-1eb85633f691\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a46b55b0f33d\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"1113ba57-9df9-4fb0-a2ed-0ca31cebd82a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:16:33','2025-10-02 12:18:13','2025-10-02 12:18:13',1,'291b04fe-1a16-460c-ae11-af9f070c1703','8c49b0fe-d42a-4dc2-8485-1c114233c6fc','compute-0.ctlplane.example.com','d7e14705-7aeb-440f-8e7e-926cc5b5ab6f','/dev/vdb','2025-10-02 12:16:41','2025-10-02 12:18:13','rw','detached','{\"name\": \"volumes/volume-8c49b0fe-d42a-4dc2-8485-1c114233c6fc\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"8c49b0fe-d42a-4dc2-8485-1c114233c6fc\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"291b04fe-1a16-460c-ae11-af9f070c1703\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:89256e26a090\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a59133c-d138-4412-952a-4a6587089b61\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 11:59:43','2025-10-02 11:59:49','2025-10-02 11:59:49',1,'2cea492b-23bb-4813-965e-cef8abb03743','78cf867c-0608-4b68-9e5e-81bf2bdbef67','compute-1.ctlplane.example.com','05ef51ee-c5d0-405e-a30a-9915a4117983','/dev/vdb','2025-10-02 11:59:45','2025-10-02 11:59:49','rw','detached','{\"name\": \"volumes/volume-78cf867c-0608-4b68-9e5e-81bf2bdbef67\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"78cf867c-0608-4b68-9e5e-81bf2bdbef67\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"2cea492b-23bb-4813-965e-cef8abb03743\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a46b55b0f33d\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"1113ba57-9df9-4fb0-a2ed-0ca31cebd82a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:07:47','2025-10-02 12:07:59','2025-10-02 12:07:59',1,'2cfa8394-65cd-46dd-8912-0c86f0aac0a9','6ee55f1c-32cc-4a1e-b7d7-c50f2e3e5291','compute-2.ctlplane.example.com','8d7306df-bd40-48a7-99a7-36da8b9a67f3','/dev/vdb','2025-10-02 12:07:49','2025-10-02 12:07:59','rw','detached','{\"name\": \"volumes/volume-6ee55f1c-32cc-4a1e-b7d7-c50f2e3e5291\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"6ee55f1c-32cc-4a1e-b7d7-c50f2e3e5291\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"2cfa8394-65cd-46dd-8912-0c86f0aac0a9\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7daf2c659dfe\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"93278213-1c3c-4fb4-9fd1-d481e0b53ce1\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:28:37','2025-10-02 12:29:40','2025-10-02 12:29:40',1,'2ea8cdb1-71fc-40b9-ab28-f6ea4dc1f141','4c9d8719-7ebc-4171-8171-a0e55d9f5992','compute-2.ctlplane.example.com','1e47e923-75c9-4c8c-b5f3-86f715462a64','/dev/vda','2025-10-02 12:29:04','2025-10-02 12:29:40','rw','detached','{\"name\": \"volumes/volume-4c9d8719-7ebc-4171-8171-a0e55d9f5992\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"4c9d8719-7ebc-4171-8171-a0e55d9f5992\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"2ea8cdb1-71fc-40b9-ab28-f6ea4dc1f141\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7daf2c659dfe\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"93278213-1c3c-4fb4-9fd1-d481e0b53ce1\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:39:48','2025-10-02 12:39:58','2025-10-02 12:39:58',1,'32434325-3bb9-4635-b3cf-a531f5083862','6831a10e-a853-4e3f-956f-b5ceafcd071e','compute-0.ctlplane.example.com','c03d6d93-3bfc-4356-bdea-f62670b73a91','/dev/vdb','2025-10-02 12:39:50','2025-10-02 12:39:58','rw','detached','{\"name\": \"volumes/volume-6831a10e-a853-4e3f-956f-b5ceafcd071e\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"6831a10e-a853-4e3f-956f-b5ceafcd071e\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": true, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"32434325-3bb9-4635-b3cf-a531f5083862\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:89256e26a090\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a59133c-d138-4412-952a-4a6587089b61\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 13:11:46','2025-10-02 13:13:31','2025-10-02 13:13:31',1,'3948d9dc-5b2e-4a5e-bc17-9b30f836ba23','cce428bb-67ad-45c7-9e76-52ebd4f984b0','compute-2.ctlplane.example.com','6de68f58-d90f-4bb4-ad9d-4bfa90dcb765','/dev/vda','2025-10-02 13:11:49','2025-10-02 13:13:31','rw','detached','{\"name\": \"volumes/volume-cce428bb-67ad-45c7-9e76-52ebd4f984b0\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"cce428bb-67ad-45c7-9e76-52ebd4f984b0\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"3948d9dc-5b2e-4a5e-bc17-9b30f836ba23\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7daf2c659dfe\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"93278213-1c3c-4fb4-9fd1-d481e0b53ce1\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:02:40','2025-10-02 12:03:08','2025-10-02 12:03:08',1,'3d957787-f9d3-4665-bd82-80e6c561747f','b3df5dc9-9a56-4922-8b65-4162deb6be93','compute-0.ctlplane.example.com','6febae1b-d70f-43e6-8aba-1e913541fec2','/dev/vda','2025-10-02 12:02:41','2025-10-02 12:03:08','null','detached','{\"name\": \"volumes/volume-b3df5dc9-9a56-4922-8b65-4162deb6be93\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"b3df5dc9-9a56-4922-8b65-4162deb6be93\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"3d957787-f9d3-4665-bd82-80e6c561747f\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:89256e26a090\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a59133c-d138-4412-952a-4a6587089b61\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2025-10-02 12:41:59','2025-10-02 12:42:39','2025-10-02 12:42:39',1,'3f6da93c-1313-4502-a0cb-b6367e555b0d','6916418d-7e23-49fb-b41f-d247b7619f6f','compute-0.ctlplane.example.com','f3566799-fdd0-46bf-8256-0294a227030a','/dev/vda','2025-10-02 12:42:06','2025-10-02 12:42:39','rw','detached','{\"name\": \"volumes/volume-6916418d-7e23-49fb-b41f-d247b7619f6f\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"6916418d-7e23-49fb-b41f-d247b7619f6f\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"3f6da93c-1313-4502-a0cb-b6367e555b0d\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:89256e26a090\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a59133c-d138-4412-952a-4a6587089b61\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:09:42','2025-10-02 12:09:47','2025-10-02 12:09:47',1,'403fd515-9007-40ce-b4e1-3421f7a24d84','80038b9a-2fe1-4bab-ad9d-f3986e75d80d','compute-0.ctlplane.example.com','e8828a06-3170-4302-a5f9-2e4ec8445ab2','/dev/vdb','2025-10-02 12:09:43','2025-10-02 12:09:47','rw','detached','{\"name\": \"volumes/volume-80038b9a-2fe1-4bab-ad9d-f3986e75d80d\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"80038b9a-2fe1-4bab-ad9d-f3986e75d80d\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"403fd515-9007-40ce-b4e1-3421f7a24d84\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:89256e26a090\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a59133c-d138-4412-952a-4a6587089b61\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 13:05:51','2025-10-02 13:05:55','2025-10-02 13:05:55',1,'40524711-8ec3-4ab4-a2eb-b60ee2925eaf','4ca63cf3-978e-4b72-859d-58e38ddef02a','compute-1.ctlplane.example.com','039a9f5b-fc39-40c8-8416-4f18a87f9652','/dev/vdb','2025-10-02 13:05:52','2025-10-02 13:05:55','rw','detached','{\"name\": \"volumes/volume-4ca63cf3-978e-4b72-859d-58e38ddef02a\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"4ca63cf3-978e-4b72-859d-58e38ddef02a\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"40524711-8ec3-4ab4-a2eb-b60ee2925eaf\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a46b55b0f33d\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"1113ba57-9df9-4fb0-a2ed-0ca31cebd82a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:37:55','2025-10-02 12:37:56','2025-10-02 12:37:56',1,'41cfe544-605e-4037-abe8-21c4e17a50f3','334ab5af-6228-4371-8840-41f1cb3005a2',NULL,'be1174bf-d7e1-4801-a2eb-67020632d637',NULL,NULL,'2025-10-02 12:37:56','null','detached','{}',NULL),('2025-10-02 12:39:37','2025-10-02 12:40:11','2025-10-02 12:40:11',1,'45eedd3d-5843-49db-8e74-7d74193b28dd','a1bae65f-c0b4-46c3-b2fd-8ed16aa61b19','compute-2.ctlplane.example.com','45079fff-1c54-42d6-921b-150592757d59','/dev/vdb','2025-10-02 12:39:46','2025-10-02 12:40:11','rw','detached','{\"name\": \"volumes/volume-a1bae65f-c0b4-46c3-b2fd-8ed16aa61b19\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"a1bae65f-c0b4-46c3-b2fd-8ed16aa61b19\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"45eedd3d-5843-49db-8e74-7d74193b28dd\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7daf2c659dfe\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"93278213-1c3c-4fb4-9fd1-d481e0b53ce1\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:23:16','2025-10-02 12:23:32','2025-10-02 12:23:32',1,'4828b9c9-25a6-4b60-9892-2c42f1deb7c8','64167daa-7aad-468b-9a08-b3195fe87186','compute-0.ctlplane.example.com','9ae72f32-b9fd-44eb-b10d-79119ad2ca85','/dev/vdb','2025-10-02 12:23:20','2025-10-02 12:23:32','rw','detached','{\"name\": \"volumes/volume-64167daa-7aad-468b-9a08-b3195fe87186\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"64167daa-7aad-468b-9a08-b3195fe87186\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"4828b9c9-25a6-4b60-9892-2c42f1deb7c8\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:89256e26a090\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a59133c-d138-4412-952a-4a6587089b61\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:25:40','2025-10-02 12:25:44','2025-10-02 12:25:44',1,'4ca4093c-a4f7-424a-beb7-6a4a3f2da4cf','739adda1-476e-45a8-9f90-438ba66c8243','compute-1.ctlplane.example.com','e69e3ed0-aca2-475e-9c98-e8d075ea4ce3','/dev/vdb','2025-10-02 12:25:41','2025-10-02 12:25:44','rw','detached','{\"name\": \"volumes/volume-739adda1-476e-45a8-9f90-438ba66c8243\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"739adda1-476e-45a8-9f90-438ba66c8243\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"4ca4093c-a4f7-424a-beb7-6a4a3f2da4cf\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a46b55b0f33d\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"1113ba57-9df9-4fb0-a2ed-0ca31cebd82a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 13:11:15','2025-10-02 13:11:26','2025-10-02 13:11:26',1,'4e19eeb2-9d5b-4380-9267-1cecb534311f','434edc39-4c42-4a71-aa46-369312e08301','compute-2.ctlplane.example.com','7f90eabc-4880-4ade-ba65-ec56679e12ee','/dev/vda','2025-10-02 13:11:16','2025-10-02 13:11:26','rw','detached','{\"name\": \"volumes/volume-434edc39-4c42-4a71-aa46-369312e08301\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"434edc39-4c42-4a71-aa46-369312e08301\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"4e19eeb2-9d5b-4380-9267-1cecb534311f\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7daf2c659dfe\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"93278213-1c3c-4fb4-9fd1-d481e0b53ce1\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:27:29','2025-10-02 12:28:38','2025-10-02 12:28:38',1,'4ecec6ac-c34a-4cf2-8a97-239fe3a61f1a','4c9d8719-7ebc-4171-8171-a0e55d9f5992','compute-2.ctlplane.example.com','1e47e923-75c9-4c8c-b5f3-86f715462a64','/dev/vda','2025-10-02 12:27:53','2025-10-02 12:28:38','rw','detached','{\"name\": \"volumes/volume-4c9d8719-7ebc-4171-8171-a0e55d9f5992\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"4c9d8719-7ebc-4171-8171-a0e55d9f5992\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"4ecec6ac-c34a-4cf2-8a97-239fe3a61f1a\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7daf2c659dfe\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"93278213-1c3c-4fb4-9fd1-d481e0b53ce1\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:32:28','2025-10-02 12:32:46','2025-10-02 12:32:46',1,'4f150204-75b3-49f6-909c-f07b38002c63','3c189565-c036-47f3-b9f5-ed22810ceabf','compute-0.ctlplane.example.com','466310fc-8494-43ad-ab29-1691041fc97d','/dev/vda','2025-10-02 12:32:32','2025-10-02 12:32:46','rw','detached','{\"name\": \"volumes/volume-3c189565-c036-47f3-b9f5-ed22810ceabf\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"3c189565-c036-47f3-b9f5-ed22810ceabf\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"4f150204-75b3-49f6-909c-f07b38002c63\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:89256e26a090\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a59133c-d138-4412-952a-4a6587089b61\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:01:24','2025-10-02 12:01:48','2025-10-02 12:01:48',1,'4f99169b-4463-49cd-9376-86a3da48b01d','134b86f3-5f3c-45b7-9cd8-0ead1590c407','compute-1.ctlplane.example.com','cd9deba5-2505-4edd-ac7c-483615217473','/dev/vda','2025-10-02 12:01:25','2025-10-02 12:01:48','null','detached','{\"name\": \"volumes/volume-134b86f3-5f3c-45b7-9cd8-0ead1590c407\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"134b86f3-5f3c-45b7-9cd8-0ead1590c407\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"4f99169b-4463-49cd-9376-86a3da48b01d\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a46b55b0f33d\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"1113ba57-9df9-4fb0-a2ed-0ca31cebd82a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2025-10-02 12:07:51','2025-10-02 12:07:56','2025-10-02 12:07:56',1,'546c2edf-b7e5-4754-9188-a76c1d348b2b','6ee55f1c-32cc-4a1e-b7d7-c50f2e3e5291','compute-0.ctlplane.example.com','65bbc6a8-390f-4a9a-b86e-8dcbcaf1b632','/dev/vdb','2025-10-02 12:07:52','2025-10-02 12:07:56','rw','detached','{\"name\": \"volumes/volume-6ee55f1c-32cc-4a1e-b7d7-c50f2e3e5291\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"6ee55f1c-32cc-4a1e-b7d7-c50f2e3e5291\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"546c2edf-b7e5-4754-9188-a76c1d348b2b\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:89256e26a090\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a59133c-d138-4412-952a-4a6587089b61\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 13:10:38','2025-10-02 13:10:54','2025-10-02 13:10:54',1,'54785efe-e096-4fa5-a9b9-ef294d95eccb','8173fb80-12b5-41df-9b9e-84a3204dcf2c','compute-2.ctlplane.example.com','1f3cf63d-4aef-4445-b255-5c235b1a1f7d','/dev/vda','2025-10-02 13:10:42','2025-10-02 13:10:54','rw','detached','{\"name\": \"volumes/volume-8173fb80-12b5-41df-9b9e-84a3204dcf2c\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"8173fb80-12b5-41df-9b9e-84a3204dcf2c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": true, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"54785efe-e096-4fa5-a9b9-ef294d95eccb\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7daf2c659dfe\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"93278213-1c3c-4fb4-9fd1-d481e0b53ce1\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:47:45','2025-10-02 12:47:56','2025-10-02 12:47:56',1,'5b502dd5-055b-47c7-aea8-4ed473a43f8e','23d0d8ce-0e39-4b00-81b2-fea970998125','compute-2.ctlplane.example.com','bf9e8de1-5081-4daa-9041-1d329e06be86','/dev/vdb','2025-10-02 12:47:49','2025-10-02 12:47:56','rw','detached','{\"name\": \"volumes/volume-23d0d8ce-0e39-4b00-81b2-fea970998125\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"23d0d8ce-0e39-4b00-81b2-fea970998125\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"5b502dd5-055b-47c7-aea8-4ed473a43f8e\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7daf2c659dfe\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"93278213-1c3c-4fb4-9fd1-d481e0b53ce1\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:02:22','2025-10-02 12:02:48','2025-10-02 12:02:48',1,'5c71f9a3-182a-4066-9e3d-88ac9417292f','b3df5dc9-9a56-4922-8b65-4162deb6be93','compute-1.ctlplane.example.com','6febae1b-d70f-43e6-8aba-1e913541fec2','/dev/vda','2025-10-02 12:02:25','2025-10-02 12:02:48','rw','detached','{\"name\": \"volumes/volume-b3df5dc9-9a56-4922-8b65-4162deb6be93\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"b3df5dc9-9a56-4922-8b65-4162deb6be93\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"5c71f9a3-182a-4066-9e3d-88ac9417292f\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a46b55b0f33d\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"1113ba57-9df9-4fb0-a2ed-0ca31cebd82a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:41:18','2025-10-02 12:41:59','2025-10-02 12:41:59',1,'5dbea56f-5a7c-4179-b71f-9d1d827e5b78','6916418d-7e23-49fb-b41f-d247b7619f6f','compute-1.ctlplane.example.com','f3566799-fdd0-46bf-8256-0294a227030a','/dev/vda','2025-10-02 12:41:24','2025-10-02 12:41:59','rw','detached','{\"name\": \"volumes/volume-6916418d-7e23-49fb-b41f-d247b7619f6f\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"6916418d-7e23-49fb-b41f-d247b7619f6f\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"5dbea56f-5a7c-4179-b71f-9d1d827e5b78\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a46b55b0f33d\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"1113ba57-9df9-4fb0-a2ed-0ca31cebd82a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:41:55','2025-10-02 12:43:09','2025-10-02 12:43:09',1,'5e3f76e3-514c-43ff-9e3a-a3c21da6cf10','daaee0e4-d0d6-43f1-84a2-7bb4d00c48ef','compute-1.ctlplane.example.com','70956832-8f1d-46df-8eeb-3f75ddf40e84','/dev/vdb','2025-10-02 12:41:56','2025-10-02 12:43:09','rw','detached','{\"name\": \"volumes/volume-daaee0e4-d0d6-43f1-84a2-7bb4d00c48ef\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"daaee0e4-d0d6-43f1-84a2-7bb4d00c48ef\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"5e3f76e3-514c-43ff-9e3a-a3c21da6cf10\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a46b55b0f33d\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"1113ba57-9df9-4fb0-a2ed-0ca31cebd82a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:16:33','2025-10-02 12:18:12','2025-10-02 12:18:12',1,'66f30441-268c-44a2-b67b-424f14a0be77','7c616c2f-d398-4818-acf9-c1deefd666a5','compute-0.ctlplane.example.com','d7e14705-7aeb-440f-8e7e-926cc5b5ab6f','/dev/vda','2025-10-02 12:16:40','2025-10-02 12:18:12','rw','detached','{\"name\": \"volumes/volume-7c616c2f-d398-4818-acf9-c1deefd666a5\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"7c616c2f-d398-4818-acf9-c1deefd666a5\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"66f30441-268c-44a2-b67b-424f14a0be77\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:89256e26a090\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a59133c-d138-4412-952a-4a6587089b61\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:20:03','2025-10-02 12:21:28','2025-10-02 12:21:28',1,'67d5bc9c-c6b3-4b48-8f9e-e6ca9555744d','376f4726-152b-47c1-8d56-d366a7938d77','compute-2.ctlplane.example.com','969ba235-be4a-44e1-a6f2-7c5922b9661e','/dev/vda','2025-10-02 12:20:10','2025-10-02 12:21:28','rw','detached','{\"name\": \"volumes/volume-376f4726-152b-47c1-8d56-d366a7938d77\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"376f4726-152b-47c1-8d56-d366a7938d77\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"67d5bc9c-c6b3-4b48-8f9e-e6ca9555744d\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7daf2c659dfe\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"93278213-1c3c-4fb4-9fd1-d481e0b53ce1\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:59:19','2025-10-02 12:59:54','2025-10-02 12:59:54',1,'6a4cd3c6-2522-4cf8-890c-a4cbc4b75cf5','bf6c6619-4739-4799-81d0-3fa07140ece6','compute-1.ctlplane.example.com','af08b6ce-23c3-4ccf-846b-c8c68da5e4e9','/dev/vda','2025-10-02 12:59:23','2025-10-02 12:59:54','rw','detached','{\"name\": \"volumes/volume-bf6c6619-4739-4799-81d0-3fa07140ece6\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"bf6c6619-4739-4799-81d0-3fa07140ece6\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"6a4cd3c6-2522-4cf8-890c-a4cbc4b75cf5\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a46b55b0f33d\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"1113ba57-9df9-4fb0-a2ed-0ca31cebd82a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:23:32','2025-10-02 12:23:46','2025-10-02 12:23:46',1,'6a7b7ebb-fc14-4d46-b6b9-7e3b3004988c','64167daa-7aad-468b-9a08-b3195fe87186','compute-0.ctlplane.example.com','9ae72f32-b9fd-44eb-b10d-79119ad2ca85','/dev/vdb','2025-10-02 12:23:36','2025-10-02 12:23:46','rw','detached','{\"name\": \"volumes/volume-64167daa-7aad-468b-9a08-b3195fe87186\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"64167daa-7aad-468b-9a08-b3195fe87186\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"6a7b7ebb-fc14-4d46-b6b9-7e3b3004988c\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:89256e26a090\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a59133c-d138-4412-952a-4a6587089b61\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:41:16','2025-10-02 12:44:00','2025-10-02 12:44:00',1,'6cbf0e30-594b-47ed-bef7-fc3b77bafd29','0af2788f-a0c7-4253-b4eb-758a295353f8','compute-0.ctlplane.example.com','714ae75f-1424-4b97-b849-84e5b4e77668','/dev/vda','2025-10-02 12:41:21','2025-10-02 12:44:00','rw','detached','{\"name\": \"volumes/volume-0af2788f-a0c7-4253-b4eb-758a295353f8\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"0af2788f-a0c7-4253-b4eb-758a295353f8\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"6cbf0e30-594b-47ed-bef7-fc3b77bafd29\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:89256e26a090\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a59133c-d138-4412-952a-4a6587089b61\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:35:17','2025-10-02 12:36:21','2025-10-02 12:36:21',1,'6e0d7c38-c1b5-4721-97f8-ac34aebd9ec3','d674cd8c-5d45-4ef7-9cb1-cd5cf5c7d43c','compute-2.ctlplane.example.com','8736e2a4-70c8-46c1-8ce5-ff68395a22c9','/dev/vdc','2025-10-02 12:35:26','2025-10-02 12:36:21','rw','detached','{\"name\": \"volumes/volume-d674cd8c-5d45-4ef7-9cb1-cd5cf5c7d43c\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"d674cd8c-5d45-4ef7-9cb1-cd5cf5c7d43c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"6e0d7c38-c1b5-4721-97f8-ac34aebd9ec3\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7daf2c659dfe\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"93278213-1c3c-4fb4-9fd1-d481e0b53ce1\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-10-02 12:45:09','2025-10-02 12:46:04','2025-10-02 12:46:04',1,'6ef1d958-2b5d-43fd-a484-a5fdc599cab6','857b1b6f-42d5-4289-a74d-1acb4fd6b032','compute-0.ctlplane.example.com','38b13275-2908-42f3-bb70-73c050f375ea','/dev/vda','2025-10-02 12:45:13','2025-10-02 12:46:04','rw','detached','{\"name\": \"volumes/volume-857b1b6f-42d5-4289-a74d-1acb4fd6b032\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"857b1b6f-42d5-4289-a74d-1acb4fd6b032\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"6ef1d958-2b5d-43fd-a484-a5fdc599cab6\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:89256e26a090\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a59133c-d138-4412-952a-4a6587089b61\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 13:04:51','2025-10-02 13:04:56','2025-10-02 13:04:56',1,'6f7efa5a-79d5-4ae4-8e82-4792a4025580','dd4a5f3e-c055-4aa9-b3b2-bdd3900319cd','compute-0.ctlplane.example.com','d08382ad-f3df-432b-848a-b0990a79ddf7','/dev/vdb','2025-10-02 13:04:53','2025-10-02 13:04:56','rw','detached','{\"name\": \"volumes/volume-dd4a5f3e-c055-4aa9-b3b2-bdd3900319cd\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"dd4a5f3e-c055-4aa9-b3b2-bdd3900319cd\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"6f7efa5a-79d5-4ae4-8e82-4792a4025580\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:89256e26a090\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a59133c-d138-4412-952a-4a6587089b61\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:03:03','2025-10-02 12:03:21','2025-10-02 12:03:21',1,'75b51a18-127e-4a68-852a-cdb11aa33a0e','b3df5dc9-9a56-4922-8b65-4162deb6be93','compute-1.ctlplane.example.com','6febae1b-d70f-43e6-8aba-1e913541fec2','/dev/vda','2025-10-02 12:03:03','2025-10-02 12:03:21','null','detached','{\"name\": \"volumes/volume-b3df5dc9-9a56-4922-8b65-4162deb6be93\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"b3df5dc9-9a56-4922-8b65-4162deb6be93\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"75b51a18-127e-4a68-852a-cdb11aa33a0e\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a46b55b0f33d\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"1113ba57-9df9-4fb0-a2ed-0ca31cebd82a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2025-10-02 12:42:57','2025-10-02 12:43:26','2025-10-02 12:43:26',1,'763fd409-e162-4b58-89f1-00ddc284204d','438ad3ce-5006-4a29-8013-2d6621c8349e','compute-2.ctlplane.example.com','1ce0c3bd-552b-4bc2-95e9-ccac7b24593c','/dev/vdc','2025-10-02 12:42:59','2025-10-02 12:43:26','rw','detached','{\"name\": \"volumes/volume-438ad3ce-5006-4a29-8013-2d6621c8349e\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"438ad3ce-5006-4a29-8013-2d6621c8349e\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"763fd409-e162-4b58-89f1-00ddc284204d\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7daf2c659dfe\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"93278213-1c3c-4fb4-9fd1-d481e0b53ce1\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-10-02 12:41:42','2025-10-02 12:42:08','2025-10-02 12:42:08',1,'76fd7d8b-2698-4170-afbb-be0640734ebf','1fa11495-af8b-4452-bf4e-b9eb1f185956','compute-2.ctlplane.example.com','5a11dca9-ede5-4fdd-af8e-7936ff4f9980','/dev/vdc','2025-10-02 12:41:44','2025-10-02 12:42:08','rw','detached','{\"name\": \"volumes/volume-1fa11495-af8b-4452-bf4e-b9eb1f185956\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"1fa11495-af8b-4452-bf4e-b9eb1f185956\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"76fd7d8b-2698-4170-afbb-be0640734ebf\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7daf2c659dfe\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"93278213-1c3c-4fb4-9fd1-d481e0b53ce1\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-10-02 12:27:01','2025-10-02 12:33:35','2025-10-02 12:33:35',1,'7b590e49-9c73-46d4-a23e-e0b73ddfbf08','9c6d2b3e-2a88-49f0-aefb-0738951478c4','compute-1.ctlplane.example.com','db5a79b4-af1c-4c62-a8d8-bfc6aab11a19','/dev/vda','2025-10-02 12:27:11','2025-10-02 12:33:35','rw','detached','{\"name\": \"volumes/volume-9c6d2b3e-2a88-49f0-aefb-0738951478c4\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"9c6d2b3e-2a88-49f0-aefb-0738951478c4\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"7b590e49-9c73-46d4-a23e-e0b73ddfbf08\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a46b55b0f33d\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"1113ba57-9df9-4fb0-a2ed-0ca31cebd82a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 13:14:38','2025-10-02 13:16:09','2025-10-02 13:16:09',1,'7dac326f-19dd-416f-82af-0781aea4dc7c','970cb928-04fe-4f96-87d5-ef615b8da829','compute-0.ctlplane.example.com','bfb3e97d-8923-4293-b4ae-a37019fe104c','/dev/vda','2025-10-02 13:14:42','2025-10-02 13:16:09','rw','detached','{\"name\": \"volumes/volume-970cb928-04fe-4f96-87d5-ef615b8da829\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"970cb928-04fe-4f96-87d5-ef615b8da829\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"7dac326f-19dd-416f-82af-0781aea4dc7c\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:89256e26a090\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a59133c-d138-4412-952a-4a6587089b61\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:42:21','2025-10-02 12:42:42','2025-10-02 12:42:42',1,'809af09e-0563-4d39-bb5f-ac55e629447e','4fa9e646-33dd-4e8b-95f5-a1b4436473bb','compute-0.ctlplane.example.com','714ae75f-1424-4b97-b849-84e5b4e77668','/dev/vdc','2025-10-02 12:42:22','2025-10-02 12:42:42','rw','detached','{\"name\": \"volumes/volume-4fa9e646-33dd-4e8b-95f5-a1b4436473bb\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"4fa9e646-33dd-4e8b-95f5-a1b4436473bb\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"809af09e-0563-4d39-bb5f-ac55e629447e\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:89256e26a090\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a59133c-d138-4412-952a-4a6587089b61\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-10-02 12:17:17','2025-10-02 12:20:31','2025-10-02 12:20:31',1,'81d64467-a589-41df-8763-5a45265a1bef','27c2fdcd-9a25-49d0-befe-30f5b9c08453','compute-1.ctlplane.example.com','992b01a0-5a43-42ab-bfcb-96c2db503633','/dev/vda','2025-10-02 12:17:18','2025-10-02 12:20:31','rw','detached','{\"name\": \"volumes/volume-27c2fdcd-9a25-49d0-befe-30f5b9c08453\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"27c2fdcd-9a25-49d0-befe-30f5b9c08453\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"81d64467-a589-41df-8763-5a45265a1bef\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a46b55b0f33d\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"1113ba57-9df9-4fb0-a2ed-0ca31cebd82a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:00:27','2025-10-02 12:00:57','2025-10-02 12:00:57',1,'829db4f7-64a6-478e-8284-7771fae0f3c1','134b86f3-5f3c-45b7-9cd8-0ead1590c407','compute-1.ctlplane.example.com','cd9deba5-2505-4edd-ac7c-483615217473','/dev/vda','2025-10-02 12:00:30','2025-10-02 12:00:57','rw','detached','{\"name\": \"volumes/volume-134b86f3-5f3c-45b7-9cd8-0ead1590c407\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"134b86f3-5f3c-45b7-9cd8-0ead1590c407\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"829db4f7-64a6-478e-8284-7771fae0f3c1\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a46b55b0f33d\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"1113ba57-9df9-4fb0-a2ed-0ca31cebd82a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:23:04','2025-10-02 12:23:16','2025-10-02 12:23:16',1,'87e5f9cc-9f59-4da9-a34b-13e28384afb3','64167daa-7aad-468b-9a08-b3195fe87186','compute-0.ctlplane.example.com','9ae72f32-b9fd-44eb-b10d-79119ad2ca85','/dev/vdb','2025-10-02 12:23:05','2025-10-02 12:23:16','rw','detached','{\"name\": \"volumes/volume-64167daa-7aad-468b-9a08-b3195fe87186\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"64167daa-7aad-468b-9a08-b3195fe87186\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"87e5f9cc-9f59-4da9-a34b-13e28384afb3\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:89256e26a090\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a59133c-d138-4412-952a-4a6587089b61\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:44:18','2025-10-02 12:45:09','2025-10-02 12:45:09',1,'87ef146e-2318-4c72-a2df-e8c485467f1c','857b1b6f-42d5-4289-a74d-1acb4fd6b032','compute-2.ctlplane.example.com','38b13275-2908-42f3-bb70-73c050f375ea','/dev/vda','2025-10-02 12:44:25','2025-10-02 12:45:09','rw','detached','{\"name\": \"volumes/volume-857b1b6f-42d5-4289-a74d-1acb4fd6b032\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"857b1b6f-42d5-4289-a74d-1acb4fd6b032\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"87ef146e-2318-4c72-a2df-e8c485467f1c\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7daf2c659dfe\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"93278213-1c3c-4fb4-9fd1-d481e0b53ce1\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:30:33','2025-10-02 12:30:52','2025-10-02 12:30:52',1,'8c319c65-041c-4a29-b9df-3c90bdb8a438','1f1fe097-f4b6-4748-bf18-8e487e0f3ba6','compute-2.ctlplane.example.com','4297c5cd-77b6-4f80-a746-11b304df8c90','/dev/vdb','2025-10-02 12:30:36','2025-10-02 12:30:52','rw','detached','{\"name\": \"volumes/volume-1f1fe097-f4b6-4748-bf18-8e487e0f3ba6\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"1f1fe097-f4b6-4748-bf18-8e487e0f3ba6\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"8c319c65-041c-4a29-b9df-3c90bdb8a438\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7daf2c659dfe\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"93278213-1c3c-4fb4-9fd1-d481e0b53ce1\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:41:21','2025-10-02 12:43:50','2025-10-02 12:43:50',1,'91d86631-64e7-4787-887f-760c514b960b','9ccd0211-39da-4f0a-ae5b-a7561864b3d4','compute-2.ctlplane.example.com','1ce0c3bd-552b-4bc2-95e9-ccac7b24593c','/dev/vda','2025-10-02 12:41:26','2025-10-02 12:43:50','rw','detached','{\"name\": \"volumes/volume-9ccd0211-39da-4f0a-ae5b-a7561864b3d4\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"9ccd0211-39da-4f0a-ae5b-a7561864b3d4\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"91d86631-64e7-4787-887f-760c514b960b\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7daf2c659dfe\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"93278213-1c3c-4fb4-9fd1-d481e0b53ce1\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:29:15','2025-10-02 12:29:27','2025-10-02 12:29:27',1,'9234c666-4e90-4854-92be-0014295bc368','2a3104a8-1c9f-4fbb-9fab-8943dbcc7eb3','compute-0.ctlplane.example.com','24caf505-35fd-40c1-9bcc-1f83580b142b','/dev/vdb','2025-10-02 12:29:17','2025-10-02 12:29:27','rw','detached','{\"name\": \"volumes/volume-2a3104a8-1c9f-4fbb-9fab-8943dbcc7eb3\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"2a3104a8-1c9f-4fbb-9fab-8943dbcc7eb3\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"9234c666-4e90-4854-92be-0014295bc368\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:89256e26a090\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a59133c-d138-4412-952a-4a6587089b61\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:42:50','2025-10-02 12:43:20','2025-10-02 12:43:20',1,'a404e328-e693-4e3b-82e3-065059927c8f','419667a7-d107-42dc-8a35-e16461ced816','compute-2.ctlplane.example.com','1ce0c3bd-552b-4bc2-95e9-ccac7b24593c','/dev/vdb','2025-10-02 12:42:52','2025-10-02 12:43:20','rw','detached','{\"name\": \"volumes/volume-419667a7-d107-42dc-8a35-e16461ced816\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"419667a7-d107-42dc-8a35-e16461ced816\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"a404e328-e693-4e3b-82e3-065059927c8f\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7daf2c659dfe\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"93278213-1c3c-4fb4-9fd1-d481e0b53ce1\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:49:04','2025-10-02 12:49:12','2025-10-02 12:49:12',1,'aa0c4477-8370-490e-ad5b-2deebd8bc7b6','174dd3a1-2323-41da-aed2-49740942102d','compute-1.ctlplane.example.com','dc0b661c-6c12-4408-9e23-dc3883bd5138','/dev/vdb','2025-10-02 12:49:06','2025-10-02 12:49:12','rw','detached','{\"name\": \"volumes/volume-174dd3a1-2323-41da-aed2-49740942102d\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"174dd3a1-2323-41da-aed2-49740942102d\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"aa0c4477-8370-490e-ad5b-2deebd8bc7b6\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a46b55b0f33d\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"1113ba57-9df9-4fb0-a2ed-0ca31cebd82a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:41:09','2025-10-02 12:44:07','2025-10-02 12:44:07',1,'ae623a24-470d-48aa-b464-ea5427a6c254','6d39578f-a8e9-40a7-8016-2f523024dbcc','compute-2.ctlplane.example.com','5a11dca9-ede5-4fdd-af8e-7936ff4f9980','/dev/vda','2025-10-02 12:41:14','2025-10-02 12:44:07','rw','detached','{\"name\": \"volumes/volume-6d39578f-a8e9-40a7-8016-2f523024dbcc\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"6d39578f-a8e9-40a7-8016-2f523024dbcc\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"ae623a24-470d-48aa-b464-ea5427a6c254\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7daf2c659dfe\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"93278213-1c3c-4fb4-9fd1-d481e0b53ce1\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:30:38','2025-10-02 12:31:39','2025-10-02 12:31:39',1,'b36803f7-f694-48ab-a490-981509461ace','1f1fe097-f4b6-4748-bf18-8e487e0f3ba6','compute-2.ctlplane.example.com','c8b713f4-4f41-4153-928c-164f2ed108ed','/dev/vdb','2025-10-02 12:30:39','2025-10-02 12:31:39','rw','detached','{\"name\": \"volumes/volume-1f1fe097-f4b6-4748-bf18-8e487e0f3ba6\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"1f1fe097-f4b6-4748-bf18-8e487e0f3ba6\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"b36803f7-f694-48ab-a490-981509461ace\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7daf2c659dfe\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"93278213-1c3c-4fb4-9fd1-d481e0b53ce1\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:30:51','2025-10-02 12:32:09','2025-10-02 12:32:09',1,'b51fbf87-59e9-4776-8492-33d39184200e','1f1fe097-f4b6-4748-bf18-8e487e0f3ba6','compute-2.ctlplane.example.com','4297c5cd-77b6-4f80-a746-11b304df8c90','/dev/vdb','2025-10-02 12:30:56','2025-10-02 12:32:09','rw','detached','{\"name\": \"volumes/volume-1f1fe097-f4b6-4748-bf18-8e487e0f3ba6\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"1f1fe097-f4b6-4748-bf18-8e487e0f3ba6\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"b51fbf87-59e9-4776-8492-33d39184200e\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7daf2c659dfe\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"93278213-1c3c-4fb4-9fd1-d481e0b53ce1\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:39:26','2025-10-02 12:39:38','2025-10-02 12:39:38',1,'b5db2386-7cee-4628-9b69-fa0ef8b30fec','a1bae65f-c0b4-46c3-b2fd-8ed16aa61b19','compute-2.ctlplane.example.com','45079fff-1c54-42d6-921b-150592757d59','/dev/vdb','2025-10-02 12:39:28','2025-10-02 12:39:38','rw','detached','{\"name\": \"volumes/volume-a1bae65f-c0b4-46c3-b2fd-8ed16aa61b19\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"a1bae65f-c0b4-46c3-b2fd-8ed16aa61b19\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"b5db2386-7cee-4628-9b69-fa0ef8b30fec\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7daf2c659dfe\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"93278213-1c3c-4fb4-9fd1-d481e0b53ce1\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:31:39','2025-10-02 12:32:11','2025-10-02 12:32:11',1,'b75fb30b-6a63-4647-ae72-6a623b91c7a3','1f1fe097-f4b6-4748-bf18-8e487e0f3ba6','compute-0.ctlplane.example.com','c8b713f4-4f41-4153-928c-164f2ed108ed','/dev/vdb','2025-10-02 12:31:45','2025-10-02 12:32:11','rw','detached','{\"name\": \"volumes/volume-1f1fe097-f4b6-4748-bf18-8e487e0f3ba6\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"1f1fe097-f4b6-4748-bf18-8e487e0f3ba6\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"b75fb30b-6a63-4647-ae72-6a623b91c7a3\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:89256e26a090\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a59133c-d138-4412-952a-4a6587089b61\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:20:04','2025-10-02 12:21:29','2025-10-02 12:21:29',1,'bca78dd3-e5b2-45fd-a77e-e3e4d05f19e3','7a48c418-78a2-476b-af7b-983febde623b','compute-2.ctlplane.example.com','969ba235-be4a-44e1-a6f2-7c5922b9661e','/dev/vdc','2025-10-02 12:20:13','2025-10-02 12:21:29','rw','detached','{\"name\": \"volumes/volume-7a48c418-78a2-476b-af7b-983febde623b\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"7a48c418-78a2-476b-af7b-983febde623b\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"bca78dd3-e5b2-45fd-a77e-e3e4d05f19e3\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7daf2c659dfe\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"93278213-1c3c-4fb4-9fd1-d481e0b53ce1\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-10-02 13:15:22','2025-10-02 13:16:00','2025-10-02 13:16:00',1,'bd85fdc1-9d9d-491a-942f-b625f9757354','fb042846-a135-4c8d-8115-d7e363fd7891','compute-2.ctlplane.example.com','3a7474e0-ede0-4d42-adf1-28b16d03074b','/dev/vda','2025-10-02 13:15:27','2025-10-02 13:16:00','rw','detached','{\"name\": \"volumes/volume-fb042846-a135-4c8d-8115-d7e363fd7891\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"fb042846-a135-4c8d-8115-d7e363fd7891\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"bd85fdc1-9d9d-491a-942f-b625f9757354\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7daf2c659dfe\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"93278213-1c3c-4fb4-9fd1-d481e0b53ce1\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:29:06','2025-10-02 12:29:23','2025-10-02 12:29:23',1,'c3babeec-00a9-4c5c-89b3-1d5c0a4bcc96','2a3104a8-1c9f-4fbb-9fab-8943dbcc7eb3','compute-1.ctlplane.example.com','e744f3b9-ccc1-43b1-b134-e6050b9487eb','/dev/vdb','2025-10-02 12:29:13','2025-10-02 12:29:23','rw','detached','{\"name\": \"volumes/volume-2a3104a8-1c9f-4fbb-9fab-8943dbcc7eb3\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"2a3104a8-1c9f-4fbb-9fab-8943dbcc7eb3\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"c3babeec-00a9-4c5c-89b3-1d5c0a4bcc96\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a46b55b0f33d\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"1113ba57-9df9-4fb0-a2ed-0ca31cebd82a\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:08:08','2025-10-02 12:08:15','2025-10-02 12:08:15',1,'c96b81a8-7637-49cf-8068-2356c09aa2d5','0dd62c4f-a912-4779-b0b4-363755e9a330','compute-2.ctlplane.example.com','1442e48b-6b8f-4c96-b9b7-909071c8ebf2','/dev/sdc','2025-10-02 12:08:10','2025-10-02 12:08:15','rw','detached','{\"name\": \"volumes/volume-0dd62c4f-a912-4779-b0b4-363755e9a330\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"0dd62c4f-a912-4779-b0b4-363755e9a330\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"c96b81a8-7637-49cf-8068-2356c09aa2d5\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7daf2c659dfe\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"93278213-1c3c-4fb4-9fd1-d481e0b53ce1\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/sdc\"}'),('2025-10-02 13:00:30','2025-10-02 13:00:38','2025-10-02 13:00:38',1,'cab1b627-97f1-490d-96ca-0e33b1604a90','e20bbad6-3733-408d-b226-999bd1df2110','compute-0.ctlplane.example.com','15a3e611-0b02-417e-96b9-552573fac39e','/dev/vdb','2025-10-02 13:00:31','2025-10-02 13:00:38','rw','detached','{\"name\": \"volumes/volume-e20bbad6-3733-408d-b226-999bd1df2110\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"e20bbad6-3733-408d-b226-999bd1df2110\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"cab1b627-97f1-490d-96ca-0e33b1604a90\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:89256e26a090\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a59133c-d138-4412-952a-4a6587089b61\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 13:02:30','2025-10-02 13:03:54','2025-10-02 13:03:54',1,'cca26f33-916c-4391-862c-471a8cfad51c','b071d28d-2baf-4099-b6f4-9ad6bb72c88f','compute-0.ctlplane.example.com','08b29362-e7c1-450f-bf22-95d23c21ff23','/dev/vdb','2025-10-02 13:02:32','2025-10-02 13:03:54','rw','detached','{\"name\": \"volumes/volume-b071d28d-2baf-4099-b6f4-9ad6bb72c88f\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"b071d28d-2baf-4099-b6f4-9ad6bb72c88f\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"cca26f33-916c-4391-862c-471a8cfad51c\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:89256e26a090\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a59133c-d138-4412-952a-4a6587089b61\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 13:00:35','2025-10-02 13:00:40','2025-10-02 13:00:40',1,'cfb3de7b-27b7-48ae-aaba-65f3a1c4ead2','34e323fe-cd44-4887-8162-f6a31b8bc60c','compute-0.ctlplane.example.com','15a3e611-0b02-417e-96b9-552573fac39e','/dev/vdc','2025-10-02 13:00:36','2025-10-02 13:00:40','rw','detached','{\"name\": \"volumes/volume-34e323fe-cd44-4887-8162-f6a31b8bc60c\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"34e323fe-cd44-4887-8162-f6a31b8bc60c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"cfb3de7b-27b7-48ae-aaba-65f3a1c4ead2\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:89256e26a090\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a59133c-d138-4412-952a-4a6587089b61\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-10-02 12:42:17','2025-10-02 12:42:38','2025-10-02 12:42:38',1,'d1e501a6-68c9-4c89-b28c-0a15c57c5088','19e6039d-9ba8-4938-aa46-4b4209e53456','compute-0.ctlplane.example.com','714ae75f-1424-4b97-b849-84e5b4e77668','/dev/vdb','2025-10-02 12:42:19','2025-10-02 12:42:38','rw','detached','{\"name\": \"volumes/volume-19e6039d-9ba8-4938-aa46-4b4209e53456\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"19e6039d-9ba8-4938-aa46-4b4209e53456\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"d1e501a6-68c9-4c89-b28c-0a15c57c5088\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:89256e26a090\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a59133c-d138-4412-952a-4a6587089b61\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-10-02 12:19:40','2025-10-02 12:20:20','2025-10-02 12:20:20',1,'d9ca43b3-656f-4879-87cc-759e42fbf324','a1b4f371-5f32-4b45-87d9-56f18142a917','compute-0.ctlplane.example.com','ac0f45a4-0e95-492b-be4f-14fe19840399','/dev/vda','2025-10-02 12:19:42','2025-10-02 12:20:20','rw','detached','{\"name\": \"volumes/volume-a1b4f371-5f32-4b45-87d9-56f18142a917\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"a1b4f371-5f32-4b45-87d9-56f18142a917\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"d9ca43b3-656f-4879-87cc-759e42fbf324\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:89256e26a090\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a59133c-d138-4412-952a-4a6587089b61\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-10-02 12:00:52','2025-10-02 12:01:30','2025-10-02 12:01:30',1,'de5c36e5-1c4e-4ee2-9ef9-4f685e9dc836','134b86f3-5f3c-45b7-9cd8-0ead1590c407','compute-0.ctlplane.example.com','cd9deba5-2505-4edd-ac7c-483615217473','/dev/vda','2025-10-02 12:00:53','2025-10-02 12:01:30','null','detached','{\"name\": \"volumes/volume-134b86f3-5f3c-45b7-9cd8-0ead1590c407\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"134b86f3-5f3c-45b7-9cd8-0ead1590c407\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"de5c36e5-1c4e-4ee2-9ef9-4f685e9dc836\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:89256e26a090\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a59133c-d138-4412-952a-4a6587089b61\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2025-10-02 12:20:38','2025-10-02 12:20:44','2025-10-02 12:20:44',1,'f0d86544-7d7f-4db7-abaf-e2ece5e411a7','041421bd-9b54-4471-8009-d216600b627c','compute-0.ctlplane.example.com','e7e38e6b-74d9-470a-ad54-222ee4a47e1f','/dev/vdb','2025-10-02 12:20:39','2025-10-02 12:20:44','rw','detached','{\"name\": \"volumes/volume-041421bd-9b54-4471-8009-d216600b627c\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"fd4c5763-22d1-50ea-ad0b-96a3dc3040b2\", \"volume_id\": \"041421bd-9b54-4471-8009-d216600b627c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"f0d86544-7d7f-4db7-abaf-e2ece5e411a7\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:89256e26a090\", \"do_local_attach\": false, \"nvme_hostid\": \"2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"system uuid\": \"8a59133c-d138-4412-952a-4a6587089b61\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:2f7d2450-18ac-43a6-80ee-9caa4a7736e0\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}');
/*!40000 ALTER TABLE `volume_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_glance_metadata`
--

DROP TABLE IF EXISTS `volume_glance_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_glance_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_glance_metadata_volume_id` (`volume_id`),
  KEY `ix_volume_glance_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `volume_glance_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `volume_glance_metadata_ibfk_2` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=267 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_glance_metadata`
--

LOCK TABLES `volume_glance_metadata` WRITE;
/*!40000 ALTER TABLE `volume_glance_metadata` DISABLE KEYS */;
INSERT INTO `volume_glance_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `snapshot_id`, `key`, `value`) VALUES ('2025-10-02 12:00:16',NULL,'2025-10-02 12:01:49',1,1,'134b86f3-5f3c-45b7-9cd8-0ead1590c407',NULL,'signature_verified','False'),('2025-10-02 12:00:22',NULL,'2025-10-02 12:01:49',1,2,'134b86f3-5f3c-45b7-9cd8-0ead1590c407',NULL,'hw_rng_model','virtio'),('2025-10-02 12:00:22',NULL,'2025-10-02 12:01:49',1,3,'134b86f3-5f3c-45b7-9cd8-0ead1590c407',NULL,'image_id','c2d0c2bc-fe21-4689-86ae-d6728c15874c'),('2025-10-02 12:00:22',NULL,'2025-10-02 12:01:49',1,4,'134b86f3-5f3c-45b7-9cd8-0ead1590c407',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 12:00:22',NULL,'2025-10-02 12:01:49',1,5,'134b86f3-5f3c-45b7-9cd8-0ead1590c407',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 12:00:22',NULL,'2025-10-02 12:01:49',1,6,'134b86f3-5f3c-45b7-9cd8-0ead1590c407',NULL,'container_format','bare'),('2025-10-02 12:00:22',NULL,'2025-10-02 12:01:49',1,7,'134b86f3-5f3c-45b7-9cd8-0ead1590c407',NULL,'disk_format','qcow2'),('2025-10-02 12:00:22',NULL,'2025-10-02 12:01:49',1,8,'134b86f3-5f3c-45b7-9cd8-0ead1590c407',NULL,'min_disk','0'),('2025-10-02 12:00:22',NULL,'2025-10-02 12:01:49',1,9,'134b86f3-5f3c-45b7-9cd8-0ead1590c407',NULL,'min_ram','0'),('2025-10-02 12:00:22',NULL,'2025-10-02 12:01:49',1,10,'134b86f3-5f3c-45b7-9cd8-0ead1590c407',NULL,'size','21430272'),('2025-10-02 12:02:15',NULL,'2025-10-02 12:03:21',1,11,'b3df5dc9-9a56-4922-8b65-4162deb6be93',NULL,'signature_verified','False'),('2025-10-02 12:02:19',NULL,'2025-10-02 12:03:21',1,12,'b3df5dc9-9a56-4922-8b65-4162deb6be93',NULL,'hw_rng_model','virtio'),('2025-10-02 12:02:19',NULL,'2025-10-02 12:03:21',1,13,'b3df5dc9-9a56-4922-8b65-4162deb6be93',NULL,'image_id','c2d0c2bc-fe21-4689-86ae-d6728c15874c'),('2025-10-02 12:02:19',NULL,'2025-10-02 12:03:21',1,14,'b3df5dc9-9a56-4922-8b65-4162deb6be93',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 12:02:19',NULL,'2025-10-02 12:03:21',1,15,'b3df5dc9-9a56-4922-8b65-4162deb6be93',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 12:02:19',NULL,'2025-10-02 12:03:21',1,16,'b3df5dc9-9a56-4922-8b65-4162deb6be93',NULL,'container_format','bare'),('2025-10-02 12:02:19',NULL,'2025-10-02 12:03:21',1,17,'b3df5dc9-9a56-4922-8b65-4162deb6be93',NULL,'disk_format','qcow2'),('2025-10-02 12:02:19',NULL,'2025-10-02 12:03:21',1,18,'b3df5dc9-9a56-4922-8b65-4162deb6be93',NULL,'min_disk','0'),('2025-10-02 12:02:19',NULL,'2025-10-02 12:03:21',1,19,'b3df5dc9-9a56-4922-8b65-4162deb6be93',NULL,'min_ram','0'),('2025-10-02 12:02:19',NULL,'2025-10-02 12:03:21',1,20,'b3df5dc9-9a56-4922-8b65-4162deb6be93',NULL,'size','21430272'),('2025-10-02 12:16:02',NULL,'2025-10-02 12:18:28',1,21,'7c616c2f-d398-4818-acf9-c1deefd666a5',NULL,'signature_verified','False'),('2025-10-02 12:16:08',NULL,'2025-10-02 12:18:28',1,22,'7c616c2f-d398-4818-acf9-c1deefd666a5',NULL,'hw_rng_model','virtio'),('2025-10-02 12:16:08',NULL,'2025-10-02 12:18:28',1,23,'7c616c2f-d398-4818-acf9-c1deefd666a5',NULL,'image_id','c2d0c2bc-fe21-4689-86ae-d6728c15874c'),('2025-10-02 12:16:08',NULL,'2025-10-02 12:18:28',1,24,'7c616c2f-d398-4818-acf9-c1deefd666a5',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 12:16:08',NULL,'2025-10-02 12:18:28',1,25,'7c616c2f-d398-4818-acf9-c1deefd666a5',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 12:16:08',NULL,'2025-10-02 12:18:28',1,26,'7c616c2f-d398-4818-acf9-c1deefd666a5',NULL,'container_format','bare'),('2025-10-02 12:16:08',NULL,'2025-10-02 12:18:28',1,27,'7c616c2f-d398-4818-acf9-c1deefd666a5',NULL,'disk_format','qcow2'),('2025-10-02 12:16:08',NULL,'2025-10-02 12:18:28',1,28,'7c616c2f-d398-4818-acf9-c1deefd666a5',NULL,'min_disk','0'),('2025-10-02 12:16:08',NULL,'2025-10-02 12:18:28',1,29,'7c616c2f-d398-4818-acf9-c1deefd666a5',NULL,'min_ram','0'),('2025-10-02 12:16:08',NULL,'2025-10-02 12:18:28',1,30,'7c616c2f-d398-4818-acf9-c1deefd666a5',NULL,'size','21430272'),('2025-10-02 12:18:29',NULL,'2025-10-02 12:19:40',1,31,'6418770c-0612-4553-8861-921425b3c82e',NULL,'signature_verified','False'),('2025-10-02 12:18:33',NULL,'2025-10-02 12:19:40',1,32,'6418770c-0612-4553-8861-921425b3c82e',NULL,'hw_rng_model','virtio'),('2025-10-02 12:18:33',NULL,'2025-10-02 12:19:40',1,33,'6418770c-0612-4553-8861-921425b3c82e',NULL,'image_id','c2d0c2bc-fe21-4689-86ae-d6728c15874c'),('2025-10-02 12:18:33',NULL,'2025-10-02 12:19:40',1,34,'6418770c-0612-4553-8861-921425b3c82e',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 12:18:33',NULL,'2025-10-02 12:19:40',1,35,'6418770c-0612-4553-8861-921425b3c82e',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 12:18:33',NULL,'2025-10-02 12:19:40',1,36,'6418770c-0612-4553-8861-921425b3c82e',NULL,'container_format','bare'),('2025-10-02 12:18:33',NULL,'2025-10-02 12:19:40',1,37,'6418770c-0612-4553-8861-921425b3c82e',NULL,'disk_format','qcow2'),('2025-10-02 12:18:33',NULL,'2025-10-02 12:19:40',1,38,'6418770c-0612-4553-8861-921425b3c82e',NULL,'min_disk','0'),('2025-10-02 12:18:33',NULL,'2025-10-02 12:19:40',1,39,'6418770c-0612-4553-8861-921425b3c82e',NULL,'min_ram','0'),('2025-10-02 12:18:33',NULL,'2025-10-02 12:19:40',1,40,'6418770c-0612-4553-8861-921425b3c82e',NULL,'size','21430272'),('2025-10-02 12:19:20',NULL,NULL,0,41,'a1b4f371-5f32-4b45-87d9-56f18142a917',NULL,'signature_verified','False'),('2025-10-02 12:19:29',NULL,'2025-10-02 12:21:46',1,42,'376f4726-152b-47c1-8d56-d366a7938d77',NULL,'signature_verified','False'),('2025-10-02 12:19:37',NULL,NULL,0,43,'a1b4f371-5f32-4b45-87d9-56f18142a917',NULL,'hw_rng_model','virtio'),('2025-10-02 12:19:37',NULL,NULL,0,44,'a1b4f371-5f32-4b45-87d9-56f18142a917',NULL,'image_id','c2d0c2bc-fe21-4689-86ae-d6728c15874c'),('2025-10-02 12:19:37',NULL,NULL,0,45,'a1b4f371-5f32-4b45-87d9-56f18142a917',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 12:19:37',NULL,NULL,0,46,'a1b4f371-5f32-4b45-87d9-56f18142a917',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 12:19:38',NULL,NULL,0,47,'a1b4f371-5f32-4b45-87d9-56f18142a917',NULL,'container_format','bare'),('2025-10-02 12:19:38',NULL,NULL,0,48,'a1b4f371-5f32-4b45-87d9-56f18142a917',NULL,'disk_format','qcow2'),('2025-10-02 12:19:38',NULL,NULL,0,49,'a1b4f371-5f32-4b45-87d9-56f18142a917',NULL,'min_disk','0'),('2025-10-02 12:19:38',NULL,NULL,0,50,'a1b4f371-5f32-4b45-87d9-56f18142a917',NULL,'min_ram','0'),('2025-10-02 12:19:38',NULL,NULL,0,51,'a1b4f371-5f32-4b45-87d9-56f18142a917',NULL,'size','21430272'),('2025-10-02 12:19:38',NULL,'2025-10-02 12:21:46',1,52,'376f4726-152b-47c1-8d56-d366a7938d77',NULL,'hw_rng_model','virtio'),('2025-10-02 12:19:38',NULL,'2025-10-02 12:21:46',1,53,'376f4726-152b-47c1-8d56-d366a7938d77',NULL,'image_id','c2d0c2bc-fe21-4689-86ae-d6728c15874c'),('2025-10-02 12:19:38',NULL,'2025-10-02 12:21:46',1,54,'376f4726-152b-47c1-8d56-d366a7938d77',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 12:19:38',NULL,'2025-10-02 12:21:46',1,55,'376f4726-152b-47c1-8d56-d366a7938d77',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 12:19:38',NULL,'2025-10-02 12:21:46',1,56,'376f4726-152b-47c1-8d56-d366a7938d77',NULL,'container_format','bare'),('2025-10-02 12:19:38',NULL,'2025-10-02 12:21:46',1,57,'376f4726-152b-47c1-8d56-d366a7938d77',NULL,'disk_format','qcow2'),('2025-10-02 12:19:38',NULL,'2025-10-02 12:21:46',1,58,'376f4726-152b-47c1-8d56-d366a7938d77',NULL,'min_disk','0'),('2025-10-02 12:19:38',NULL,'2025-10-02 12:21:46',1,59,'376f4726-152b-47c1-8d56-d366a7938d77',NULL,'min_ram','0'),('2025-10-02 12:19:38',NULL,'2025-10-02 12:21:46',1,60,'376f4726-152b-47c1-8d56-d366a7938d77',NULL,'size','21430272'),('2025-10-02 12:26:46',NULL,'2025-10-02 12:33:38',1,61,'9c6d2b3e-2a88-49f0-aefb-0738951478c4',NULL,'signature_verified','False'),('2025-10-02 12:26:56',NULL,'2025-10-02 12:33:38',1,62,'9c6d2b3e-2a88-49f0-aefb-0738951478c4',NULL,'hw_rng_model','virtio'),('2025-10-02 12:26:57',NULL,'2025-10-02 12:33:38',1,63,'9c6d2b3e-2a88-49f0-aefb-0738951478c4',NULL,'image_id','c2d0c2bc-fe21-4689-86ae-d6728c15874c'),('2025-10-02 12:26:57',NULL,'2025-10-02 12:33:38',1,64,'9c6d2b3e-2a88-49f0-aefb-0738951478c4',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 12:26:57',NULL,'2025-10-02 12:33:38',1,65,'9c6d2b3e-2a88-49f0-aefb-0738951478c4',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 12:26:57',NULL,'2025-10-02 12:33:38',1,66,'9c6d2b3e-2a88-49f0-aefb-0738951478c4',NULL,'container_format','bare'),('2025-10-02 12:26:57',NULL,'2025-10-02 12:33:38',1,67,'9c6d2b3e-2a88-49f0-aefb-0738951478c4',NULL,'disk_format','qcow2'),('2025-10-02 12:26:57',NULL,'2025-10-02 12:33:38',1,68,'9c6d2b3e-2a88-49f0-aefb-0738951478c4',NULL,'min_disk','0'),('2025-10-02 12:26:57',NULL,'2025-10-02 12:33:38',1,69,'9c6d2b3e-2a88-49f0-aefb-0738951478c4',NULL,'min_ram','0'),('2025-10-02 12:26:57',NULL,'2025-10-02 12:33:38',1,70,'9c6d2b3e-2a88-49f0-aefb-0738951478c4',NULL,'size','21430272'),('2025-10-02 12:27:13',NULL,'2025-10-02 12:28:57',1,71,'4c9d8719-7ebc-4171-8171-a0e55d9f5992',NULL,'signature_verified','False'),('2025-10-02 12:27:26',NULL,'2025-10-02 12:28:57',1,72,'4c9d8719-7ebc-4171-8171-a0e55d9f5992',NULL,'hw_rng_model','virtio'),('2025-10-02 12:27:26',NULL,'2025-10-02 12:28:57',1,73,'4c9d8719-7ebc-4171-8171-a0e55d9f5992',NULL,'image_id','c2d0c2bc-fe21-4689-86ae-d6728c15874c'),('2025-10-02 12:27:26',NULL,'2025-10-02 12:28:57',1,74,'4c9d8719-7ebc-4171-8171-a0e55d9f5992',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 12:27:26',NULL,'2025-10-02 12:28:57',1,75,'4c9d8719-7ebc-4171-8171-a0e55d9f5992',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 12:27:26',NULL,'2025-10-02 12:28:57',1,76,'4c9d8719-7ebc-4171-8171-a0e55d9f5992',NULL,'container_format','bare'),('2025-10-02 12:27:26',NULL,'2025-10-02 12:28:57',1,77,'4c9d8719-7ebc-4171-8171-a0e55d9f5992',NULL,'disk_format','qcow2'),('2025-10-02 12:27:26',NULL,'2025-10-02 12:28:57',1,78,'4c9d8719-7ebc-4171-8171-a0e55d9f5992',NULL,'min_disk','0'),('2025-10-02 12:27:26',NULL,'2025-10-02 12:28:57',1,79,'4c9d8719-7ebc-4171-8171-a0e55d9f5992',NULL,'min_ram','0'),('2025-10-02 12:27:26',NULL,'2025-10-02 12:28:57',1,80,'4c9d8719-7ebc-4171-8171-a0e55d9f5992',NULL,'size','21430272'),('2025-10-02 12:28:57',NULL,'2025-10-02 12:29:43',1,81,'4c9d8719-7ebc-4171-8171-a0e55d9f5992',NULL,'hw_rng_model','virtio'),('2025-10-02 12:28:57',NULL,'2025-10-02 12:29:43',1,82,'4c9d8719-7ebc-4171-8171-a0e55d9f5992',NULL,'image_id','db05f54c-61f8-42d6-a1e2-da3219a77b12'),('2025-10-02 12:28:57',NULL,'2025-10-02 12:29:43',1,83,'4c9d8719-7ebc-4171-8171-a0e55d9f5992',NULL,'image_name','cirros-0.6.2-x86_64-disk.img_alt'),('2025-10-02 12:28:57',NULL,'2025-10-02 12:29:43',1,84,'4c9d8719-7ebc-4171-8171-a0e55d9f5992',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 12:28:57',NULL,'2025-10-02 12:29:43',1,85,'4c9d8719-7ebc-4171-8171-a0e55d9f5992',NULL,'container_format','bare'),('2025-10-02 12:28:57',NULL,'2025-10-02 12:29:43',1,86,'4c9d8719-7ebc-4171-8171-a0e55d9f5992',NULL,'disk_format','qcow2'),('2025-10-02 12:28:57',NULL,'2025-10-02 12:29:43',1,87,'4c9d8719-7ebc-4171-8171-a0e55d9f5992',NULL,'min_disk','0'),('2025-10-02 12:28:57',NULL,'2025-10-02 12:29:43',1,88,'4c9d8719-7ebc-4171-8171-a0e55d9f5992',NULL,'min_ram','0'),('2025-10-02 12:28:57',NULL,'2025-10-02 12:29:43',1,89,'4c9d8719-7ebc-4171-8171-a0e55d9f5992',NULL,'size','21430272'),('2025-10-02 12:32:18',NULL,'2025-10-02 12:32:49',1,90,'3c189565-c036-47f3-b9f5-ed22810ceabf',NULL,'signature_verified','False'),('2025-10-02 12:32:25',NULL,'2025-10-02 12:32:49',1,91,'3c189565-c036-47f3-b9f5-ed22810ceabf',NULL,'hw_rng_model','virtio'),('2025-10-02 12:32:25',NULL,'2025-10-02 12:32:49',1,92,'3c189565-c036-47f3-b9f5-ed22810ceabf',NULL,'image_id','c2d0c2bc-fe21-4689-86ae-d6728c15874c'),('2025-10-02 12:32:25',NULL,'2025-10-02 12:32:49',1,93,'3c189565-c036-47f3-b9f5-ed22810ceabf',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 12:32:25',NULL,'2025-10-02 12:32:49',1,94,'3c189565-c036-47f3-b9f5-ed22810ceabf',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 12:32:25',NULL,'2025-10-02 12:32:49',1,95,'3c189565-c036-47f3-b9f5-ed22810ceabf',NULL,'container_format','bare'),('2025-10-02 12:32:25',NULL,'2025-10-02 12:32:49',1,96,'3c189565-c036-47f3-b9f5-ed22810ceabf',NULL,'disk_format','qcow2'),('2025-10-02 12:32:25',NULL,'2025-10-02 12:32:49',1,97,'3c189565-c036-47f3-b9f5-ed22810ceabf',NULL,'min_disk','0'),('2025-10-02 12:32:25',NULL,'2025-10-02 12:32:49',1,98,'3c189565-c036-47f3-b9f5-ed22810ceabf',NULL,'min_ram','0'),('2025-10-02 12:32:25',NULL,'2025-10-02 12:32:49',1,99,'3c189565-c036-47f3-b9f5-ed22810ceabf',NULL,'size','21430272'),('2025-10-02 12:32:40',NULL,'2025-10-02 12:32:48',1,100,NULL,'ca60f0ab-6431-4851-87b3-164a993c75aa','signature_verified','False'),('2025-10-02 12:32:40',NULL,'2025-10-02 12:32:48',1,101,NULL,'ca60f0ab-6431-4851-87b3-164a993c75aa','hw_rng_model','virtio'),('2025-10-02 12:32:40',NULL,'2025-10-02 12:32:48',1,102,NULL,'ca60f0ab-6431-4851-87b3-164a993c75aa','image_id','c2d0c2bc-fe21-4689-86ae-d6728c15874c'),('2025-10-02 12:32:40',NULL,'2025-10-02 12:32:48',1,103,NULL,'ca60f0ab-6431-4851-87b3-164a993c75aa','image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 12:32:40',NULL,'2025-10-02 12:32:48',1,104,NULL,'ca60f0ab-6431-4851-87b3-164a993c75aa','checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 12:32:40',NULL,'2025-10-02 12:32:48',1,105,NULL,'ca60f0ab-6431-4851-87b3-164a993c75aa','container_format','bare'),('2025-10-02 12:32:40',NULL,'2025-10-02 12:32:48',1,106,NULL,'ca60f0ab-6431-4851-87b3-164a993c75aa','disk_format','qcow2'),('2025-10-02 12:32:40',NULL,'2025-10-02 12:32:48',1,107,NULL,'ca60f0ab-6431-4851-87b3-164a993c75aa','min_disk','0'),('2025-10-02 12:32:40',NULL,'2025-10-02 12:32:48',1,108,NULL,'ca60f0ab-6431-4851-87b3-164a993c75aa','min_ram','0'),('2025-10-02 12:32:40',NULL,'2025-10-02 12:32:48',1,109,NULL,'ca60f0ab-6431-4851-87b3-164a993c75aa','size','21430272'),('2025-10-02 12:40:37',NULL,'2025-10-02 12:44:09',1,110,'9ccd0211-39da-4f0a-ae5b-a7561864b3d4',NULL,'signature_verified','False'),('2025-10-02 12:40:38',NULL,'2025-10-02 12:44:15',1,111,'6d39578f-a8e9-40a7-8016-2f523024dbcc',NULL,'signature_verified','False'),('2025-10-02 12:40:38',NULL,'2025-10-02 12:44:12',1,112,'0af2788f-a0c7-4253-b4eb-758a295353f8',NULL,'signature_verified','False'),('2025-10-02 12:40:56',NULL,'2025-10-02 12:44:12',1,113,'0af2788f-a0c7-4253-b4eb-758a295353f8',NULL,'image_id','fdcd4413-2e65-4120-9e32-9681c702a01f'),('2025-10-02 12:40:56',NULL,'2025-10-02 12:44:12',1,114,'0af2788f-a0c7-4253-b4eb-758a295353f8',NULL,'image_name','tempest-scenario-img--1874445515'),('2025-10-02 12:40:56',NULL,'2025-10-02 12:44:12',1,115,'0af2788f-a0c7-4253-b4eb-758a295353f8',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 12:40:56',NULL,'2025-10-02 12:44:12',1,116,'0af2788f-a0c7-4253-b4eb-758a295353f8',NULL,'container_format','bare'),('2025-10-02 12:40:56',NULL,'2025-10-02 12:44:12',1,117,'0af2788f-a0c7-4253-b4eb-758a295353f8',NULL,'disk_format','qcow2'),('2025-10-02 12:40:56',NULL,'2025-10-02 12:44:12',1,118,'0af2788f-a0c7-4253-b4eb-758a295353f8',NULL,'min_disk','0'),('2025-10-02 12:40:56',NULL,'2025-10-02 12:44:12',1,119,'0af2788f-a0c7-4253-b4eb-758a295353f8',NULL,'min_ram','0'),('2025-10-02 12:40:56',NULL,'2025-10-02 12:44:12',1,120,'0af2788f-a0c7-4253-b4eb-758a295353f8',NULL,'size','21430272'),('2025-10-02 12:41:02',NULL,'2025-10-02 12:44:09',1,121,'9ccd0211-39da-4f0a-ae5b-a7561864b3d4',NULL,'image_id','fdcd4413-2e65-4120-9e32-9681c702a01f'),('2025-10-02 12:41:02',NULL,'2025-10-02 12:44:09',1,122,'9ccd0211-39da-4f0a-ae5b-a7561864b3d4',NULL,'image_name','tempest-scenario-img--1874445515'),('2025-10-02 12:41:02',NULL,'2025-10-02 12:44:09',1,123,'9ccd0211-39da-4f0a-ae5b-a7561864b3d4',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 12:41:02',NULL,'2025-10-02 12:44:09',1,124,'9ccd0211-39da-4f0a-ae5b-a7561864b3d4',NULL,'container_format','bare'),('2025-10-02 12:41:02',NULL,'2025-10-02 12:44:09',1,125,'9ccd0211-39da-4f0a-ae5b-a7561864b3d4',NULL,'disk_format','qcow2'),('2025-10-02 12:41:02',NULL,'2025-10-02 12:44:09',1,126,'9ccd0211-39da-4f0a-ae5b-a7561864b3d4',NULL,'min_disk','0'),('2025-10-02 12:41:02',NULL,'2025-10-02 12:44:09',1,127,'9ccd0211-39da-4f0a-ae5b-a7561864b3d4',NULL,'min_ram','0'),('2025-10-02 12:41:02',NULL,'2025-10-02 12:44:09',1,128,'9ccd0211-39da-4f0a-ae5b-a7561864b3d4',NULL,'size','21430272'),('2025-10-02 12:41:02',NULL,'2025-10-02 12:44:15',1,129,'6d39578f-a8e9-40a7-8016-2f523024dbcc',NULL,'image_id','fdcd4413-2e65-4120-9e32-9681c702a01f'),('2025-10-02 12:41:02',NULL,'2025-10-02 12:44:15',1,130,'6d39578f-a8e9-40a7-8016-2f523024dbcc',NULL,'image_name','tempest-scenario-img--1874445515'),('2025-10-02 12:41:02',NULL,'2025-10-02 12:44:15',1,131,'6d39578f-a8e9-40a7-8016-2f523024dbcc',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 12:41:02',NULL,'2025-10-02 12:44:15',1,132,'6d39578f-a8e9-40a7-8016-2f523024dbcc',NULL,'container_format','bare'),('2025-10-02 12:41:02',NULL,'2025-10-02 12:44:15',1,133,'6d39578f-a8e9-40a7-8016-2f523024dbcc',NULL,'disk_format','qcow2'),('2025-10-02 12:41:02',NULL,'2025-10-02 12:44:15',1,134,'6d39578f-a8e9-40a7-8016-2f523024dbcc',NULL,'min_disk','0'),('2025-10-02 12:41:02',NULL,'2025-10-02 12:44:15',1,135,'6d39578f-a8e9-40a7-8016-2f523024dbcc',NULL,'min_ram','0'),('2025-10-02 12:41:02',NULL,'2025-10-02 12:44:15',1,136,'6d39578f-a8e9-40a7-8016-2f523024dbcc',NULL,'size','21430272'),('2025-10-02 12:41:03',NULL,'2025-10-02 12:42:40',1,137,'6916418d-7e23-49fb-b41f-d247b7619f6f',NULL,'signature_verified','False'),('2025-10-02 12:41:13',NULL,'2025-10-02 12:42:40',1,138,'6916418d-7e23-49fb-b41f-d247b7619f6f',NULL,'hw_rng_model','virtio'),('2025-10-02 12:41:13',NULL,'2025-10-02 12:42:40',1,139,'6916418d-7e23-49fb-b41f-d247b7619f6f',NULL,'image_id','c2d0c2bc-fe21-4689-86ae-d6728c15874c'),('2025-10-02 12:41:13',NULL,'2025-10-02 12:42:40',1,140,'6916418d-7e23-49fb-b41f-d247b7619f6f',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 12:41:13',NULL,'2025-10-02 12:42:40',1,141,'6916418d-7e23-49fb-b41f-d247b7619f6f',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 12:41:13',NULL,'2025-10-02 12:42:40',1,142,'6916418d-7e23-49fb-b41f-d247b7619f6f',NULL,'container_format','bare'),('2025-10-02 12:41:13',NULL,'2025-10-02 12:42:40',1,143,'6916418d-7e23-49fb-b41f-d247b7619f6f',NULL,'disk_format','qcow2'),('2025-10-02 12:41:13',NULL,'2025-10-02 12:42:40',1,144,'6916418d-7e23-49fb-b41f-d247b7619f6f',NULL,'min_disk','0'),('2025-10-02 12:41:13',NULL,'2025-10-02 12:42:40',1,145,'6916418d-7e23-49fb-b41f-d247b7619f6f',NULL,'min_ram','0'),('2025-10-02 12:41:13',NULL,'2025-10-02 12:42:40',1,146,'6916418d-7e23-49fb-b41f-d247b7619f6f',NULL,'size','21430272'),('2025-10-02 12:44:08',NULL,'2025-10-02 12:46:05',1,147,'857b1b6f-42d5-4289-a74d-1acb4fd6b032',NULL,'signature_verified','False'),('2025-10-02 12:44:14',NULL,'2025-10-02 12:46:05',1,148,'857b1b6f-42d5-4289-a74d-1acb4fd6b032',NULL,'hw_rng_model','virtio'),('2025-10-02 12:44:14',NULL,'2025-10-02 12:46:05',1,149,'857b1b6f-42d5-4289-a74d-1acb4fd6b032',NULL,'image_id','c2d0c2bc-fe21-4689-86ae-d6728c15874c'),('2025-10-02 12:44:14',NULL,'2025-10-02 12:46:05',1,150,'857b1b6f-42d5-4289-a74d-1acb4fd6b032',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 12:44:14',NULL,'2025-10-02 12:46:05',1,151,'857b1b6f-42d5-4289-a74d-1acb4fd6b032',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 12:44:14',NULL,'2025-10-02 12:46:05',1,152,'857b1b6f-42d5-4289-a74d-1acb4fd6b032',NULL,'container_format','bare'),('2025-10-02 12:44:14',NULL,'2025-10-02 12:46:05',1,153,'857b1b6f-42d5-4289-a74d-1acb4fd6b032',NULL,'disk_format','qcow2'),('2025-10-02 12:44:14',NULL,'2025-10-02 12:46:05',1,154,'857b1b6f-42d5-4289-a74d-1acb4fd6b032',NULL,'min_disk','0'),('2025-10-02 12:44:14',NULL,'2025-10-02 12:46:05',1,155,'857b1b6f-42d5-4289-a74d-1acb4fd6b032',NULL,'min_ram','0'),('2025-10-02 12:44:14',NULL,'2025-10-02 12:46:05',1,156,'857b1b6f-42d5-4289-a74d-1acb4fd6b032',NULL,'size','21430272'),('2025-10-02 12:58:53',NULL,'2025-10-02 12:59:58',1,157,'35b34865-0391-4a63-933b-ea3e47885a2c',NULL,'signature_verified','False'),('2025-10-02 12:58:57',NULL,'2025-10-02 12:59:58',1,158,'35b34865-0391-4a63-933b-ea3e47885a2c',NULL,'hw_rng_model','virtio'),('2025-10-02 12:58:57',NULL,'2025-10-02 12:59:58',1,159,'35b34865-0391-4a63-933b-ea3e47885a2c',NULL,'image_id','c2d0c2bc-fe21-4689-86ae-d6728c15874c'),('2025-10-02 12:58:57',NULL,'2025-10-02 12:59:58',1,160,'35b34865-0391-4a63-933b-ea3e47885a2c',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 12:58:57',NULL,'2025-10-02 12:59:58',1,161,'35b34865-0391-4a63-933b-ea3e47885a2c',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 12:58:57',NULL,'2025-10-02 12:59:58',1,162,'35b34865-0391-4a63-933b-ea3e47885a2c',NULL,'container_format','bare'),('2025-10-02 12:58:57',NULL,'2025-10-02 12:59:58',1,163,'35b34865-0391-4a63-933b-ea3e47885a2c',NULL,'disk_format','qcow2'),('2025-10-02 12:58:57',NULL,'2025-10-02 12:59:58',1,164,'35b34865-0391-4a63-933b-ea3e47885a2c',NULL,'min_disk','0'),('2025-10-02 12:58:57',NULL,'2025-10-02 12:59:58',1,165,'35b34865-0391-4a63-933b-ea3e47885a2c',NULL,'min_ram','0'),('2025-10-02 12:58:57',NULL,'2025-10-02 12:59:58',1,166,'35b34865-0391-4a63-933b-ea3e47885a2c',NULL,'size','21430272'),('2025-10-02 12:59:09',NULL,'2025-10-02 12:59:57',1,167,'bf6c6619-4739-4799-81d0-3fa07140ece6',NULL,'signature_verified','False'),('2025-10-02 12:59:10',NULL,'2025-10-02 12:59:57',1,168,'bf6c6619-4739-4799-81d0-3fa07140ece6',NULL,'hw_rng_model','virtio'),('2025-10-02 12:59:10',NULL,'2025-10-02 12:59:57',1,169,'bf6c6619-4739-4799-81d0-3fa07140ece6',NULL,'image_id','c2d0c2bc-fe21-4689-86ae-d6728c15874c'),('2025-10-02 12:59:10',NULL,'2025-10-02 12:59:57',1,170,'bf6c6619-4739-4799-81d0-3fa07140ece6',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 12:59:10',NULL,'2025-10-02 12:59:57',1,171,'bf6c6619-4739-4799-81d0-3fa07140ece6',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 12:59:10',NULL,'2025-10-02 12:59:57',1,172,'bf6c6619-4739-4799-81d0-3fa07140ece6',NULL,'container_format','bare'),('2025-10-02 12:59:10',NULL,'2025-10-02 12:59:57',1,173,'bf6c6619-4739-4799-81d0-3fa07140ece6',NULL,'disk_format','qcow2'),('2025-10-02 12:59:10',NULL,'2025-10-02 12:59:57',1,174,'bf6c6619-4739-4799-81d0-3fa07140ece6',NULL,'min_disk','0'),('2025-10-02 12:59:10',NULL,'2025-10-02 12:59:57',1,175,'bf6c6619-4739-4799-81d0-3fa07140ece6',NULL,'min_ram','0'),('2025-10-02 12:59:10',NULL,'2025-10-02 12:59:57',1,176,'bf6c6619-4739-4799-81d0-3fa07140ece6',NULL,'size','21430272'),('2025-10-02 13:11:01',NULL,'2025-10-02 13:11:31',1,177,'7f222a34-b6b2-4826-ac62-a6a1d06ec099',NULL,'signature_verified','False'),('2025-10-02 13:11:05',NULL,'2025-10-02 13:11:31',1,178,'7f222a34-b6b2-4826-ac62-a6a1d06ec099',NULL,'hw_rng_model','virtio'),('2025-10-02 13:11:05',NULL,'2025-10-02 13:11:31',1,179,'7f222a34-b6b2-4826-ac62-a6a1d06ec099',NULL,'image_id','c2d0c2bc-fe21-4689-86ae-d6728c15874c'),('2025-10-02 13:11:05',NULL,'2025-10-02 13:11:31',1,180,'7f222a34-b6b2-4826-ac62-a6a1d06ec099',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 13:11:05',NULL,'2025-10-02 13:11:31',1,181,'7f222a34-b6b2-4826-ac62-a6a1d06ec099',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 13:11:05',NULL,'2025-10-02 13:11:31',1,182,'7f222a34-b6b2-4826-ac62-a6a1d06ec099',NULL,'container_format','bare'),('2025-10-02 13:11:05',NULL,'2025-10-02 13:11:31',1,183,'7f222a34-b6b2-4826-ac62-a6a1d06ec099',NULL,'disk_format','qcow2'),('2025-10-02 13:11:05',NULL,'2025-10-02 13:11:31',1,184,'7f222a34-b6b2-4826-ac62-a6a1d06ec099',NULL,'min_disk','0'),('2025-10-02 13:11:05',NULL,'2025-10-02 13:11:31',1,185,'7f222a34-b6b2-4826-ac62-a6a1d06ec099',NULL,'min_ram','0'),('2025-10-02 13:11:05',NULL,'2025-10-02 13:11:31',1,186,'7f222a34-b6b2-4826-ac62-a6a1d06ec099',NULL,'size','21430272'),('2025-10-02 13:11:06',NULL,'2025-10-02 13:11:30',1,187,NULL,'fbd3196a-4338-47e7-a120-33dcd2b49454','signature_verified','False'),('2025-10-02 13:11:06',NULL,'2025-10-02 13:11:30',1,188,NULL,'fbd3196a-4338-47e7-a120-33dcd2b49454','hw_rng_model','virtio'),('2025-10-02 13:11:06',NULL,'2025-10-02 13:11:30',1,189,NULL,'fbd3196a-4338-47e7-a120-33dcd2b49454','image_id','c2d0c2bc-fe21-4689-86ae-d6728c15874c'),('2025-10-02 13:11:06',NULL,'2025-10-02 13:11:30',1,190,NULL,'fbd3196a-4338-47e7-a120-33dcd2b49454','image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 13:11:06',NULL,'2025-10-02 13:11:30',1,191,NULL,'fbd3196a-4338-47e7-a120-33dcd2b49454','checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 13:11:06',NULL,'2025-10-02 13:11:30',1,192,NULL,'fbd3196a-4338-47e7-a120-33dcd2b49454','container_format','bare'),('2025-10-02 13:11:06',NULL,'2025-10-02 13:11:30',1,193,NULL,'fbd3196a-4338-47e7-a120-33dcd2b49454','disk_format','qcow2'),('2025-10-02 13:11:06',NULL,'2025-10-02 13:11:30',1,194,NULL,'fbd3196a-4338-47e7-a120-33dcd2b49454','min_disk','0'),('2025-10-02 13:11:06',NULL,'2025-10-02 13:11:30',1,195,NULL,'fbd3196a-4338-47e7-a120-33dcd2b49454','min_ram','0'),('2025-10-02 13:11:06',NULL,'2025-10-02 13:11:30',1,196,NULL,'fbd3196a-4338-47e7-a120-33dcd2b49454','size','21430272'),('2025-10-02 13:11:12',NULL,'2025-10-02 13:11:27',1,197,'434edc39-4c42-4a71-aa46-369312e08301',NULL,'signature_verified','False'),('2025-10-02 13:11:12',NULL,'2025-10-02 13:11:27',1,198,'434edc39-4c42-4a71-aa46-369312e08301',NULL,'hw_rng_model','virtio'),('2025-10-02 13:11:12',NULL,'2025-10-02 13:11:27',1,199,'434edc39-4c42-4a71-aa46-369312e08301',NULL,'image_id','c2d0c2bc-fe21-4689-86ae-d6728c15874c'),('2025-10-02 13:11:12',NULL,'2025-10-02 13:11:27',1,200,'434edc39-4c42-4a71-aa46-369312e08301',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 13:11:12',NULL,'2025-10-02 13:11:27',1,201,'434edc39-4c42-4a71-aa46-369312e08301',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 13:11:12',NULL,'2025-10-02 13:11:27',1,202,'434edc39-4c42-4a71-aa46-369312e08301',NULL,'container_format','bare'),('2025-10-02 13:11:12',NULL,'2025-10-02 13:11:27',1,203,'434edc39-4c42-4a71-aa46-369312e08301',NULL,'disk_format','qcow2'),('2025-10-02 13:11:12',NULL,'2025-10-02 13:11:27',1,204,'434edc39-4c42-4a71-aa46-369312e08301',NULL,'min_disk','0'),('2025-10-02 13:11:12',NULL,'2025-10-02 13:11:27',1,205,'434edc39-4c42-4a71-aa46-369312e08301',NULL,'min_ram','0'),('2025-10-02 13:11:12',NULL,'2025-10-02 13:11:27',1,206,'434edc39-4c42-4a71-aa46-369312e08301',NULL,'size','21430272'),('2025-10-02 13:11:36',NULL,'2025-10-02 13:13:32',1,207,'cce428bb-67ad-45c7-9e76-52ebd4f984b0',NULL,'signature_verified','False'),('2025-10-02 13:11:42',NULL,'2025-10-02 13:13:32',1,208,'cce428bb-67ad-45c7-9e76-52ebd4f984b0',NULL,'hw_rng_model','virtio'),('2025-10-02 13:11:42',NULL,'2025-10-02 13:13:32',1,209,'cce428bb-67ad-45c7-9e76-52ebd4f984b0',NULL,'image_id','c2d0c2bc-fe21-4689-86ae-d6728c15874c'),('2025-10-02 13:11:42',NULL,'2025-10-02 13:13:32',1,210,'cce428bb-67ad-45c7-9e76-52ebd4f984b0',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 13:11:42',NULL,'2025-10-02 13:13:32',1,211,'cce428bb-67ad-45c7-9e76-52ebd4f984b0',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 13:11:42',NULL,'2025-10-02 13:13:32',1,212,'cce428bb-67ad-45c7-9e76-52ebd4f984b0',NULL,'container_format','bare'),('2025-10-02 13:11:42',NULL,'2025-10-02 13:13:32',1,213,'cce428bb-67ad-45c7-9e76-52ebd4f984b0',NULL,'disk_format','qcow2'),('2025-10-02 13:11:42',NULL,'2025-10-02 13:13:32',1,214,'cce428bb-67ad-45c7-9e76-52ebd4f984b0',NULL,'min_disk','0'),('2025-10-02 13:11:42',NULL,'2025-10-02 13:13:32',1,215,'cce428bb-67ad-45c7-9e76-52ebd4f984b0',NULL,'min_ram','0'),('2025-10-02 13:11:42',NULL,'2025-10-02 13:13:32',1,216,'cce428bb-67ad-45c7-9e76-52ebd4f984b0',NULL,'size','21430272'),('2025-10-02 13:12:21',NULL,'2025-10-02 13:13:25',1,217,NULL,'aa979228-d578-4819-bd72-9a5d1ac2ab6f','signature_verified','False'),('2025-10-02 13:12:21',NULL,'2025-10-02 13:13:25',1,218,NULL,'aa979228-d578-4819-bd72-9a5d1ac2ab6f','hw_rng_model','virtio'),('2025-10-02 13:12:21',NULL,'2025-10-02 13:13:25',1,219,NULL,'aa979228-d578-4819-bd72-9a5d1ac2ab6f','image_id','c2d0c2bc-fe21-4689-86ae-d6728c15874c'),('2025-10-02 13:12:21',NULL,'2025-10-02 13:13:25',1,220,NULL,'aa979228-d578-4819-bd72-9a5d1ac2ab6f','image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 13:12:21',NULL,'2025-10-02 13:13:25',1,221,NULL,'aa979228-d578-4819-bd72-9a5d1ac2ab6f','checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 13:12:21',NULL,'2025-10-02 13:13:25',1,222,NULL,'aa979228-d578-4819-bd72-9a5d1ac2ab6f','container_format','bare'),('2025-10-02 13:12:21',NULL,'2025-10-02 13:13:25',1,223,NULL,'aa979228-d578-4819-bd72-9a5d1ac2ab6f','disk_format','qcow2'),('2025-10-02 13:12:21',NULL,'2025-10-02 13:13:25',1,224,NULL,'aa979228-d578-4819-bd72-9a5d1ac2ab6f','min_disk','0'),('2025-10-02 13:12:21',NULL,'2025-10-02 13:13:25',1,225,NULL,'aa979228-d578-4819-bd72-9a5d1ac2ab6f','min_ram','0'),('2025-10-02 13:12:21',NULL,'2025-10-02 13:13:25',1,226,NULL,'aa979228-d578-4819-bd72-9a5d1ac2ab6f','size','21430272'),('2025-10-02 13:12:30',NULL,'2025-10-02 13:13:23',1,227,'6e153e1f-2b24-48a4-97ce-843802b3972c',NULL,'signature_verified','False'),('2025-10-02 13:12:30',NULL,'2025-10-02 13:13:23',1,228,'6e153e1f-2b24-48a4-97ce-843802b3972c',NULL,'hw_rng_model','virtio'),('2025-10-02 13:12:30',NULL,'2025-10-02 13:13:23',1,229,'6e153e1f-2b24-48a4-97ce-843802b3972c',NULL,'image_id','c2d0c2bc-fe21-4689-86ae-d6728c15874c'),('2025-10-02 13:12:30',NULL,'2025-10-02 13:13:23',1,230,'6e153e1f-2b24-48a4-97ce-843802b3972c',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 13:12:30',NULL,'2025-10-02 13:13:23',1,231,'6e153e1f-2b24-48a4-97ce-843802b3972c',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 13:12:30',NULL,'2025-10-02 13:13:23',1,232,'6e153e1f-2b24-48a4-97ce-843802b3972c',NULL,'container_format','bare'),('2025-10-02 13:12:30',NULL,'2025-10-02 13:13:23',1,233,'6e153e1f-2b24-48a4-97ce-843802b3972c',NULL,'disk_format','qcow2'),('2025-10-02 13:12:30',NULL,'2025-10-02 13:13:23',1,234,'6e153e1f-2b24-48a4-97ce-843802b3972c',NULL,'min_disk','0'),('2025-10-02 13:12:30',NULL,'2025-10-02 13:13:23',1,235,'6e153e1f-2b24-48a4-97ce-843802b3972c',NULL,'min_ram','0'),('2025-10-02 13:12:30',NULL,'2025-10-02 13:13:23',1,236,'6e153e1f-2b24-48a4-97ce-843802b3972c',NULL,'size','21430272'),('2025-10-02 13:13:48',NULL,'2025-10-02 13:16:13',1,237,'970cb928-04fe-4f96-87d5-ef615b8da829',NULL,'signature_verified','False'),('2025-10-02 13:13:52',NULL,'2025-10-02 13:16:13',1,238,'970cb928-04fe-4f96-87d5-ef615b8da829',NULL,'hw_rng_model','virtio'),('2025-10-02 13:13:52',NULL,'2025-10-02 13:16:13',1,239,'970cb928-04fe-4f96-87d5-ef615b8da829',NULL,'image_id','c2d0c2bc-fe21-4689-86ae-d6728c15874c'),('2025-10-02 13:13:52',NULL,'2025-10-02 13:16:13',1,240,'970cb928-04fe-4f96-87d5-ef615b8da829',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 13:13:52',NULL,'2025-10-02 13:16:13',1,241,'970cb928-04fe-4f96-87d5-ef615b8da829',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 13:13:52',NULL,'2025-10-02 13:16:13',1,242,'970cb928-04fe-4f96-87d5-ef615b8da829',NULL,'container_format','bare'),('2025-10-02 13:13:52',NULL,'2025-10-02 13:16:13',1,243,'970cb928-04fe-4f96-87d5-ef615b8da829',NULL,'disk_format','qcow2'),('2025-10-02 13:13:52',NULL,'2025-10-02 13:16:13',1,244,'970cb928-04fe-4f96-87d5-ef615b8da829',NULL,'min_disk','0'),('2025-10-02 13:13:52',NULL,'2025-10-02 13:16:13',1,245,'970cb928-04fe-4f96-87d5-ef615b8da829',NULL,'min_ram','0'),('2025-10-02 13:13:52',NULL,'2025-10-02 13:16:13',1,246,'970cb928-04fe-4f96-87d5-ef615b8da829',NULL,'size','21430272'),('2025-10-02 13:15:15',NULL,'2025-10-02 13:16:05',1,247,NULL,'f55859d5-64f0-4bc8-b298-3498e2ffc230','signature_verified','False'),('2025-10-02 13:15:15',NULL,'2025-10-02 13:16:05',1,248,NULL,'f55859d5-64f0-4bc8-b298-3498e2ffc230','hw_rng_model','virtio'),('2025-10-02 13:15:15',NULL,'2025-10-02 13:16:05',1,249,NULL,'f55859d5-64f0-4bc8-b298-3498e2ffc230','image_id','c2d0c2bc-fe21-4689-86ae-d6728c15874c'),('2025-10-02 13:15:15',NULL,'2025-10-02 13:16:05',1,250,NULL,'f55859d5-64f0-4bc8-b298-3498e2ffc230','image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 13:15:15',NULL,'2025-10-02 13:16:05',1,251,NULL,'f55859d5-64f0-4bc8-b298-3498e2ffc230','checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 13:15:15',NULL,'2025-10-02 13:16:05',1,252,NULL,'f55859d5-64f0-4bc8-b298-3498e2ffc230','container_format','bare'),('2025-10-02 13:15:15',NULL,'2025-10-02 13:16:05',1,253,NULL,'f55859d5-64f0-4bc8-b298-3498e2ffc230','disk_format','qcow2'),('2025-10-02 13:15:15',NULL,'2025-10-02 13:16:05',1,254,NULL,'f55859d5-64f0-4bc8-b298-3498e2ffc230','min_disk','0'),('2025-10-02 13:15:15',NULL,'2025-10-02 13:16:05',1,255,NULL,'f55859d5-64f0-4bc8-b298-3498e2ffc230','min_ram','0'),('2025-10-02 13:15:15',NULL,'2025-10-02 13:16:05',1,256,NULL,'f55859d5-64f0-4bc8-b298-3498e2ffc230','size','21430272'),('2025-10-02 13:15:17',NULL,'2025-10-02 13:16:03',1,257,'fb042846-a135-4c8d-8115-d7e363fd7891',NULL,'signature_verified','False'),('2025-10-02 13:15:17',NULL,'2025-10-02 13:16:03',1,258,'fb042846-a135-4c8d-8115-d7e363fd7891',NULL,'hw_rng_model','virtio'),('2025-10-02 13:15:17',NULL,'2025-10-02 13:16:03',1,259,'fb042846-a135-4c8d-8115-d7e363fd7891',NULL,'image_id','c2d0c2bc-fe21-4689-86ae-d6728c15874c'),('2025-10-02 13:15:17',NULL,'2025-10-02 13:16:03',1,260,'fb042846-a135-4c8d-8115-d7e363fd7891',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-10-02 13:15:17',NULL,'2025-10-02 13:16:03',1,261,'fb042846-a135-4c8d-8115-d7e363fd7891',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-10-02 13:15:17',NULL,'2025-10-02 13:16:03',1,262,'fb042846-a135-4c8d-8115-d7e363fd7891',NULL,'container_format','bare'),('2025-10-02 13:15:17',NULL,'2025-10-02 13:16:03',1,263,'fb042846-a135-4c8d-8115-d7e363fd7891',NULL,'disk_format','qcow2'),('2025-10-02 13:15:17',NULL,'2025-10-02 13:16:03',1,264,'fb042846-a135-4c8d-8115-d7e363fd7891',NULL,'min_disk','0'),('2025-10-02 13:15:17',NULL,'2025-10-02 13:16:03',1,265,'fb042846-a135-4c8d-8115-d7e363fd7891',NULL,'min_ram','0'),('2025-10-02 13:15:17',NULL,'2025-10-02 13:16:03',1,266,'fb042846-a135-4c8d-8115-d7e363fd7891',NULL,'size','21430272');
/*!40000 ALTER TABLE `volume_glance_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_metadata`
--

DROP TABLE IF EXISTS `volume_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_metadata`
--

LOCK TABLES `volume_metadata` WRITE;
/*!40000 ALTER TABLE `volume_metadata` DISABLE KEYS */;
INSERT INTO `volume_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `key`, `value`) VALUES ('2025-10-02 12:40:26',NULL,'2025-10-02 12:40:52',1,1,'d46a167a-d647-4005-a7ef-58b80277e714','Type','work'),('2025-10-02 12:40:57',NULL,'2025-10-02 12:41:13',1,2,'8365bc7c-ee74-440d-939f-50108dbbace9','Type','work'),('2025-10-02 12:40:59',NULL,'2025-10-02 12:41:11',1,3,'1d0c1b7b-379a-49c1-b765-c9c81ba98844','Type','work'),('2025-10-02 12:41:02',NULL,'2025-10-02 12:41:08',1,4,'98bd5e6c-d74e-406d-91ad-27731eba40e6','Type','work'),('2025-10-02 12:59:11',NULL,'2025-10-02 12:59:57',1,5,'bf6c6619-4739-4799-81d0-3fa07140ece6','src_backup_id','c0eef30e-5124-4246-917c-84b3935f5a6a');
/*!40000 ALTER TABLE `volume_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_extra_specs`
--

DROP TABLE IF EXISTS `volume_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_extra_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_type_extra_specs_volume_type_id` (`volume_type_id`),
  CONSTRAINT `volume_type_extra_specs_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_extra_specs`
--

LOCK TABLES `volume_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `volume_type_extra_specs` DISABLE KEYS */;
INSERT INTO `volume_type_extra_specs` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_type_id`, `key`, `value`) VALUES ('2025-10-02 11:56:42',NULL,NULL,0,1,'a5770664-6668-4712-8ea2-73ff2103264d','multiattach','<is> True');
/*!40000 ALTER TABLE `volume_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_projects`
--

DROP TABLE IF EXISTS `volume_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `volume_type_id` (`volume_type_id`,`project_id`,`deleted`),
  CONSTRAINT `volume_type_projects_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_projects`
--

LOCK TABLES `volume_type_projects` WRITE;
/*!40000 ALTER TABLE `volume_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_types`
--

DROP TABLE IF EXISTS `volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `qos_specs_id` varchar(36) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_types_qos_specs_id` (`qos_specs_id`),
  CONSTRAINT `volume_types_ibfk_1` FOREIGN KEY (`qos_specs_id`) REFERENCES `quality_of_service_specs` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_types`
--

LOCK TABLES `volume_types` WRITE;
/*!40000 ALTER TABLE `volume_types` DISABLE KEYS */;
INSERT INTO `volume_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `qos_specs_id`, `is_public`, `description`) VALUES ('2025-10-02 13:10:26',NULL,'2025-10-02 13:10:57',1,'0229108f-33fe-42b1-b447-db3615f2ec2a','tempest-scenario-type-luks-849096102',NULL,1,NULL),('2025-10-02 11:13:20','2025-10-02 11:13:20',NULL,0,'1cc1e254-249c-44da-9045-855b1e05dff7','__DEFAULT__',NULL,1,'Default Volume Type'),('2025-10-02 12:38:41',NULL,'2025-10-02 12:40:36',1,'35f14daf-50bb-41b7-acfb-4118f96074f3','tempest-scenario-type-luks-308158206',NULL,1,NULL),('2025-10-02 12:40:19',NULL,'2025-10-02 12:44:18',1,'6d8e65a5-f379-4e12-a0b3-fd99cd998da8','tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-278110967-1260666270',NULL,1,NULL),('2025-10-02 12:40:14',NULL,'2025-10-02 12:44:22',1,'9f818080-1eb6-4f75-ae4b-98c84f6b2a89','tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-3962293-2082593070',NULL,1,NULL),('2025-10-02 11:56:40',NULL,NULL,0,'a5770664-6668-4712-8ea2-73ff2103264d','multiattach',NULL,1,NULL),('2025-10-02 12:40:19',NULL,'2025-10-02 12:44:18',1,'d05c1d29-71bb-4e43-92a8-63f8e9efac08','tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-250908576-499919160',NULL,1,NULL);
/*!40000 ALTER TABLE `volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ec2_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(256) DEFAULT NULL,
  `provider_auth` varchar(256) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `source_volid` varchar(36) DEFAULT NULL,
  `bootable` tinyint(1) DEFAULT NULL,
  `provider_geometry` varchar(255) DEFAULT NULL,
  `_name_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `migration_status` varchar(255) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  `replication_extended_status` varchar(255) DEFAULT NULL,
  `replication_driver_data` varchar(255) DEFAULT NULL,
  `consistencygroup_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `multiattach` tinyint(1) DEFAULT NULL,
  `previous_status` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `group_id` varchar(36) DEFAULT NULL,
  `service_uuid` varchar(36) DEFAULT NULL,
  `shared_targets` tinyint(1) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `volumes_service_uuid_idx` (`service_uuid`,`deleted`),
  KEY `ix_volumes_group_id` (`group_id`),
  KEY `ix_volumes_consistencygroup_id` (`consistencygroup_id`),
  KEY `volumes_deleted_project_id_idx` (`deleted`,`project_id`),
  KEY `volumes_deleted_host_idx` (`deleted`,`host`),
  CONSTRAINT `volumes_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `volumes_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `volumes_ibfk_3` FOREIGN KEY (`service_uuid`) REFERENCES `services` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
INSERT INTO `volumes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `ec2_id`, `user_id`, `project_id`, `host`, `size`, `availability_zone`, `status`, `attach_status`, `scheduled_at`, `launched_at`, `terminated_at`, `display_name`, `display_description`, `provider_location`, `provider_auth`, `snapshot_id`, `volume_type_id`, `source_volid`, `bootable`, `provider_geometry`, `_name_id`, `encryption_key_id`, `migration_status`, `replication_status`, `replication_extended_status`, `replication_driver_data`, `consistencygroup_id`, `provider_id`, `multiattach`, `previous_status`, `cluster_name`, `group_id`, `service_uuid`, `shared_targets`, `use_quota`) VALUES ('2025-10-02 12:20:36','2025-10-02 12:24:13','2025-10-02 12:24:14',1,'041421bd-9b54-4471-8009-d216600b627c',NULL,'a9f7faffac7240869a0196df1ddda7e5','1c2c11ebecb14f3188f35ea473c4ca02','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:20:36','2025-10-02 12:20:37','2025-10-02 12:24:13','tempest-DeleteServersTestJSON-volume-710810789',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:38:55','2025-10-02 12:39:17','2025-10-02 12:39:20',1,'096a7aaa-7a08-4732-99f8-fc03083273ca',NULL,'00f7abe349fb496aaeb6c928e3602a2b','2a9fb2f388654380906f2a0db9d46565','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:38:55','2025-10-02 12:38:55','2025-10-02 12:39:17','tempest-VolumesSnapshotsTestJSON-volume-1554556614',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:40:28','2025-10-02 12:44:10','2025-10-02 12:44:12',1,'0af2788f-a0c7-4253-b4eb-758a295353f8',NULL,'b82c89ad6c4a49e78943f7a92d0a6560','a41d99312f014c65adddea4f70536a15','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:40:28','2025-10-02 12:40:56','2025-10-02 12:44:10','tempest-TestInstancesWithCinderVolumes-volume-389779582',NULL,NULL,NULL,NULL,'9f818080-1eb6-4f75-ae4b-98c84f6b2a89',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:08:06','2025-10-02 12:08:26','2025-10-02 12:08:27',1,'0dd62c4f-a912-4779-b0b4-363755e9a330',NULL,'4666fdebee9947109da966b5c870b34e','861ae6a71574411fbcdab09902e6bcc4','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:08:07','2025-10-02 12:08:07','2025-10-02 12:08:26','tempest-AttachSCSIVolumeTestJSON-volume-731427710',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:00:09','2025-10-02 12:01:48','2025-10-02 12:01:49',1,'134b86f3-5f3c-45b7-9cd8-0ead1590c407',NULL,'b54b5e15e4c94d1f95a272981e9d9a89','d977ad6a90874946819537242925a8f0','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:00:09','2025-10-02 12:00:22','2025-10-02 12:01:48','tempest-tempest.common.compute-volume-1825106146',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:33:39','2025-10-02 12:36:34','2025-10-02 12:36:40',1,'15e7107a-dfae-4cf5-88dc-14d782b9ed68',NULL,'6c932f0d0e594f00855572fbe06ee3aa','cc4d8f857b2d42bf9ae477fc5f514216','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:33:40','2025-10-02 12:33:40','2025-10-02 12:36:34','tempest-ServerRescueNegativeTestJSON-volume-1609315228',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:48:10','2025-10-02 12:49:20','2025-10-02 12:49:21',1,'174dd3a1-2323-41da-aed2-49740942102d',NULL,'a24a7109471f4d96ad5f11b637fdb8e7','a837417d42da439cb794b4295bca2cee','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:48:10','2025-10-02 12:48:11','2025-10-02 12:49:20','tempest-TestStampPattern-volume-1415003480',NULL,NULL,NULL,'53e30990-58b9-46e2-ae20-e6aa25e4f4af','1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:40:20','2025-10-02 12:42:39','2025-10-02 12:42:39',1,'19e6039d-9ba8-4938-aa46-4b4209e53456',NULL,'b82c89ad6c4a49e78943f7a92d0a6560','a41d99312f014c65adddea4f70536a15','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:40:20','2025-10-02 12:40:30','2025-10-02 12:42:39','tempest-TestInstancesWithCinderVolumes-volume-1829818783',NULL,NULL,NULL,NULL,'d05c1d29-71bb-4e43-92a8-63f8e9efac08',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:40:59','2025-10-02 12:41:08','2025-10-02 12:41:11',1,'1d0c1b7b-379a-49c1-b765-c9c81ba98844',NULL,'e0e5d41da13a47a1aa3210c37b88bbcc','ac8793fd6752403e9dea029569836c09','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:41:00','2025-10-02 12:41:01','2025-10-02 12:41:08','tempest-VolumesTestJSON-volume-1951866097',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:30:29','2025-10-02 12:32:52','2025-10-02 12:32:55',1,'1f1fe097-f4b6-4748-bf18-8e487e0f3ba6',NULL,'22d56fcd2a4b4851bfd126ae4548ee9b','5533aaac08cd4856af72ef4992bb5e76','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:30:30','2025-10-02 12:30:30','2025-10-02 12:32:52','tempest-AttachVolumeMultiAttachTest-volume-663337508',NULL,'{\"saved_features\":61}',NULL,NULL,'a5770664-6668-4712-8ea2-73ff2103264d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:40:20','2025-10-02 12:42:09','2025-10-02 12:42:10',1,'1fa11495-af8b-4452-bf4e-b9eb1f185956',NULL,'b82c89ad6c4a49e78943f7a92d0a6560','a41d99312f014c65adddea4f70536a15','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:40:20','2025-10-02 12:40:21','2025-10-02 12:42:09','tempest-TestInstancesWithCinderVolumes-volume-1906835472',NULL,NULL,NULL,NULL,'6d8e65a5-f379-4e12-a0b3-fd99cd998da8',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:47:03','2025-10-02 12:49:34','2025-10-02 12:49:35',1,'23d0d8ce-0e39-4b00-81b2-fea970998125',NULL,'a24a7109471f4d96ad5f11b637fdb8e7','a837417d42da439cb794b4295bca2cee','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:47:03','2025-10-02 12:47:04','2025-10-02 12:49:34','tempest-TestStampPattern-volume-1092179355',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:17:13','2025-10-02 12:20:31',NULL,0,'27c2fdcd-9a25-49d0-befe-30f5b9c08453',NULL,'69d8e29c6d3747e98a5985a584f4c814','8efba404696b40fbbaa6431b934b87f1','hostgroup@ceph#ceph',1,'nova','available','detached','2025-10-02 12:17:13','2025-10-02 12:17:14',NULL,'992b01a0-5a43-42ab-bfcb-96c2db503633-blank-vol','',NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:29:00','2025-10-02 12:33:13','2025-10-02 12:33:17',1,'2a3104a8-1c9f-4fbb-9fab-8943dbcc7eb3',NULL,'22d56fcd2a4b4851bfd126ae4548ee9b','5533aaac08cd4856af72ef4992bb5e76','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:29:01','2025-10-02 12:29:03','2025-10-02 12:33:13','tempest-AttachVolumeMultiAttachTest-volume-1127393040',NULL,'{\"saved_features\":61}',NULL,NULL,'a5770664-6668-4712-8ea2-73ff2103264d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:37:24','2025-10-02 12:38:40','2025-10-02 12:38:41',1,'334ab5af-6228-4371-8840-41f1cb3005a2',NULL,'bcd36ab668f449959719ba7058f25e72','1a05e525420b4aa8adcc9561158e73d1','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:37:24','2025-10-02 12:37:25','2025-10-02 12:38:40','tempest-AttachVolumeShelveTestJSON-volume-1008307108',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 13:00:33','2025-10-02 13:00:50','2025-10-02 13:00:51',1,'34e323fe-cd44-4887-8162-f6a31b8bc60c',NULL,'3299a1aed5af4843a91417a3f181c172','e7168b5b1300495d90592b195824729a','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:00:33','2025-10-02 13:00:33','2025-10-02 13:00:50','tempest-AttachVolumeTestJSON-volume-1580773271',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:58:47','2025-10-02 12:59:56','2025-10-02 12:59:58',1,'35b34865-0391-4a63-933b-ea3e47885a2c',NULL,'729669e8835d4d95b5aae25c140e1f06','55e97477dd13448d9dafe69ec8614ea6','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:58:48','2025-10-02 12:58:57','2025-10-02 12:59:56','tempest-TestVolumeBackupRestore-volume-880596257',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:19:26','2025-10-02 12:21:44','2025-10-02 12:21:46',1,'376f4726-152b-47c1-8d56-d366a7938d77',NULL,'2a7f7518ce70488fb4f63af1a3bef131','84f71f6076f7425db7653ac203257df0','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:19:26','2025-10-02 12:19:38','2025-10-02 12:21:44','tempest-TaggedBootDevicesTest_v242-volume-1910368845',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:32:14','2025-10-02 12:32:47','2025-10-02 12:32:49',1,'3c189565-c036-47f3-b9f5-ed22810ceabf',NULL,'22d56fcd2a4b4851bfd126ae4548ee9b','5533aaac08cd4856af72ef4992bb5e76','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:32:15','2025-10-02 12:32:25','2025-10-02 12:32:47','tempest-AttachVolumeMultiAttachTest-volume-635783905',NULL,'{\"saved_features\":61}',NULL,NULL,'a5770664-6668-4712-8ea2-73ff2103264d',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:40:23','2025-10-02 12:43:21','2025-10-02 12:43:24',1,'419667a7-d107-42dc-8a35-e16461ced816',NULL,'b82c89ad6c4a49e78943f7a92d0a6560','a41d99312f014c65adddea4f70536a15','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:40:23','2025-10-02 12:40:31','2025-10-02 12:43:21','tempest-TestInstancesWithCinderVolumes-volume-2014571496',NULL,NULL,NULL,NULL,'d05c1d29-71bb-4e43-92a8-63f8e9efac08',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 13:11:11','2025-10-02 13:11:27','2025-10-02 13:11:27',1,'434edc39-4c42-4a71-aa46-369312e08301',NULL,'c10de71fef00497981b8b7cec6a3fff3','fbbc6cb494464fd9b31f64c1ad75fa6b','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:11:11','2025-10-02 13:11:12','2025-10-02 13:11:27','','',NULL,NULL,'fbd3196a-4338-47e7-a120-33dcd2b49454','1cc1e254-249c-44da-9045-855b1e05dff7',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:40:23','2025-10-02 12:43:27','2025-10-02 12:43:31',1,'438ad3ce-5006-4a29-8013-2d6621c8349e',NULL,'b82c89ad6c4a49e78943f7a92d0a6560','a41d99312f014c65adddea4f70536a15','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:40:23','2025-10-02 12:40:31','2025-10-02 12:43:27','tempest-TestInstancesWithCinderVolumes-volume-617468466',NULL,NULL,NULL,NULL,'6d8e65a5-f379-4e12-a0b3-fd99cd998da8',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:27:08','2025-10-02 12:29:40','2025-10-02 12:29:43',1,'4c9d8719-7ebc-4171-8171-a0e55d9f5992',NULL,'c6bda06d7e6348bab069e07b21022b60','7aad01ba5df14c1a9309451d0daaab83','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:27:08','2025-10-02 12:27:26','2025-10-02 12:29:40','tempest-tempest.common.compute-volume-1504178222',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'reserved',NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 13:05:49','2025-10-02 13:06:02','2025-10-02 13:06:03',1,'4ca63cf3-978e-4b72-859d-58e38ddef02a',NULL,'93facc00c95f4cbfa6cecaf3641182bc','5eceae619a6f4fdeaa8ba6fafda4912a','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:05:49','2025-10-02 13:05:49','2025-10-02 13:06:02','tempest-AttachVolumeNegativeTest-volume-447279257',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:40:22','2025-10-02 12:42:43','2025-10-02 12:42:43',1,'4fa9e646-33dd-4e8b-95f5-a1b4436473bb',NULL,'b82c89ad6c4a49e78943f7a92d0a6560','a41d99312f014c65adddea4f70536a15','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:40:22','2025-10-02 12:40:30','2025-10-02 12:42:43','tempest-TestInstancesWithCinderVolumes-volume-1410605007',NULL,NULL,NULL,NULL,'6d8e65a5-f379-4e12-a0b3-fd99cd998da8',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:34:06','2025-10-02 12:36:27','2025-10-02 12:36:33',1,'5134bab8-913f-41c9-b5b8-350b459c53e1',NULL,'6c932f0d0e594f00855572fbe06ee3aa','cc4d8f857b2d42bf9ae477fc5f514216','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:34:07','2025-10-02 12:34:07','2025-10-02 12:36:27','tempest-ServerRescueNegativeTestJSON-volume-739443944',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:16:11','2025-10-02 12:18:24','2025-10-02 12:18:25',1,'5566db4c-b0ba-4d2b-84a6-1fa1272fec0f',NULL,'d4b073f3365d481cabadfd39389c66ba','a9d3eca266284ae9950c491e566b2523','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:16:11','2025-10-02 12:16:11','2025-10-02 12:18:24','tempest-TaggedBootDevicesTest-volume-2139122299',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:44:03','2025-10-02 12:45:28','2025-10-02 12:45:29',1,'5711af91-e6ed-47a0-ad60-a4e65171a2af',NULL,'734ae44830d540d8ab51c2a3d75ecd80','2e53064cd4d645f09bd59bbca09b98e0','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:44:04','2025-10-02 12:44:04','2025-10-02 12:45:28','tempest-TestMinimumBasicScenario-volume-1659243273',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:23:02','2025-10-02 12:26:26','2025-10-02 12:26:27',1,'64167daa-7aad-468b-9a08-b3195fe87186',NULL,'25468893d71641a385711fd2982bb00b','10fff81da7a54740a53a0771ce916329','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:23:02','2025-10-02 12:23:02','2025-10-02 12:26:26','tempest-ServerActionsTestOtherB-volume-298185986',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:18:25','2025-10-02 12:19:39','2025-10-02 12:19:40',1,'6418770c-0612-4553-8861-921425b3c82e',NULL,'0e268197f7054a098b565874c3fdd76c','a07342ec339549a4b091ddbcfedae271','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:18:25','2025-10-02 12:18:33','2025-10-02 12:19:39','tempest-tempest.common.compute-volume-670295576',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:38:43','2025-10-02 12:40:19','2025-10-02 12:40:35',1,'6831a10e-a853-4e3f-956f-b5ceafcd071e',NULL,'b4ad22acfd744e47aa9bb09035188e74','1294b2ea04b34f7189fde66e2afa2c56','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:38:43','2025-10-02 12:38:54','2025-10-02 12:40:19','tempest-TestEncryptedCinderVolumes-volume-1028682911',NULL,NULL,NULL,NULL,'35f14daf-50bb-41b7-acfb-4118f96074f3',NULL,0,NULL,NULL,'aa21fc07-13f4-4816-a07d-936433201da9',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:40:56','2025-10-02 12:42:39','2025-10-02 12:42:40',1,'6916418d-7e23-49fb-b41f-d247b7619f6f',NULL,'c02d1dcc10ea4e57bbc6b7a3c100dc7b','6822f02d5ca04c659329a75d487054cf','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:40:57','2025-10-02 12:41:13','2025-10-02 12:42:39','tempest-tempest.common.compute-volume-1647943773',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:40:26','2025-10-02 12:44:13','2025-10-02 12:44:15',1,'6d39578f-a8e9-40a7-8016-2f523024dbcc',NULL,'b82c89ad6c4a49e78943f7a92d0a6560','a41d99312f014c65adddea4f70536a15','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:40:27','2025-10-02 12:41:02','2025-10-02 12:44:13','tempest-TestInstancesWithCinderVolumes-volume-1864796454',NULL,NULL,NULL,NULL,'9f818080-1eb6-4f75-ae4b-98c84f6b2a89',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 13:12:29','2025-10-02 13:13:19','2025-10-02 13:13:23',1,'6e153e1f-2b24-48a4-97ce-843802b3972c',NULL,'c10de71fef00497981b8b7cec6a3fff3','fbbc6cb494464fd9b31f64c1ad75fa6b','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:12:29','2025-10-02 13:12:30','2025-10-02 13:13:19','','',NULL,NULL,'aa979228-d578-4819-bd72-9a5d1ac2ab6f','1cc1e254-249c-44da-9045-855b1e05dff7',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:06:15','2025-10-02 12:08:21','2025-10-02 12:08:22',1,'6ee55f1c-32cc-4a1e-b7d7-c50f2e3e5291',NULL,'ec17c54e24584f11a5348b68d6e7ca85','7359a7dad3b849bfbf075b88f2a261b4','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:06:16','2025-10-02 12:06:17','2025-10-02 12:08:21','tempest-UpdateMultiattachVolumeNegativeTest-volume-1246821831',NULL,'{\"saved_features\":61}',NULL,NULL,'a5770664-6668-4712-8ea2-73ff2103264d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:24:42','2025-10-02 12:26:16','2025-10-02 12:26:17',1,'739adda1-476e-45a8-9f90-438ba66c8243',NULL,'39945f35886a49cb93285686405e043a','d5bedc1d8125465b92c98f9ebeb80ddb','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:24:43','2025-10-02 12:24:43','2025-10-02 12:26:16','tempest-TaggedAttachmentsTest-volume-1733833630',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:51:06','2025-10-02 12:54:58','2025-10-02 12:54:59',1,'7708c28d-8dd9-455b-9cf8-550d89fddce1',NULL,'6785ffe5d6554514b4ed9fd47665eca0','6a442bc513e14406b73e96e70396e6c3','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:51:06','2025-10-02 12:51:07','2025-10-02 12:54:58','tempest-ServerStableDeviceRescueTest-volume-487350191',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 11:58:42','2025-10-02 11:59:50','2025-10-02 11:59:50',1,'78cf867c-0608-4b68-9e5e-81bf2bdbef67',NULL,'11cba1de83a640aabbce96d56cb376fc','9fab310b79144b0baa3a349f8bb4143f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 11:58:42','2025-10-02 11:58:44','2025-10-02 11:59:50','tempest-VolumesAssistedSnapshotsTest-volume-932386791',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:19:41','2025-10-02 12:21:36','2025-10-02 12:21:39',1,'7a48c418-78a2-476b-af7b-983febde623b',NULL,'2a7f7518ce70488fb4f63af1a3bef131','84f71f6076f7425db7653ac203257df0','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:19:41','2025-10-02 12:19:42','2025-10-02 12:21:36','tempest-TaggedBootDevicesTest_v242-volume-131880680',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:15:59','2025-10-02 12:18:27','2025-10-02 12:18:28',1,'7c616c2f-d398-4818-acf9-c1deefd666a5',NULL,'d4b073f3365d481cabadfd39389c66ba','a9d3eca266284ae9950c491e566b2523','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:15:59','2025-10-02 12:16:08','2025-10-02 12:18:27','tempest-TaggedBootDevicesTest-volume-1127244930',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 13:10:58','2025-10-02 13:11:30','2025-10-02 13:11:31',1,'7f222a34-b6b2-4826-ac62-a6a1d06ec099',NULL,'c10de71fef00497981b8b7cec6a3fff3','fbbc6cb494464fd9b31f64c1ad75fa6b','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:10:59','2025-10-02 13:11:05','2025-10-02 13:11:30','tempest-TestVolumeBootPattern-volume-origin-1021920705',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:09:39','2025-10-02 12:10:20','2025-10-02 12:10:21',1,'80038b9a-2fe1-4bab-ad9d-f3986e75d80d',NULL,'c5ca95bd9fa148c7948c062421011d76','95056cabad5b4f32916e46a46b10f677','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:09:39','2025-10-02 12:09:39','2025-10-02 12:10:20','tempest-VolumesAdminNegativeTest-volume-819931429',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:10:12','2025-10-02 12:10:15','2025-10-02 12:10:16',1,'806c9d06-eaf3-4478-932a-e4e747449c17',NULL,'c5ca95bd9fa148c7948c062421011d76','95056cabad5b4f32916e46a46b10f677','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:10:12','2025-10-02 12:10:13','2025-10-02 12:10:14','tempest-VolumesAdminNegativeTest-volume-1303694648',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 13:10:27','2025-10-02 13:10:56','2025-10-02 13:10:57',1,'8173fb80-12b5-41df-9b9e-84a3204dcf2c',NULL,'c10de71fef00497981b8b7cec6a3fff3','fbbc6cb494464fd9b31f64c1ad75fa6b','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:10:27','2025-10-02 13:10:35','2025-10-02 13:10:56','tempest-TestVolumeBootPattern-volume-1865657937',NULL,NULL,NULL,NULL,'0229108f-33fe-42b1-b447-db3615f2ec2a',NULL,1,NULL,NULL,'459d2bd8-c04d-4362-8d85-9be2febad4ef',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:40:57','2025-10-02 12:41:11','2025-10-02 12:41:13',1,'8365bc7c-ee74-440d-939f-50108dbbace9',NULL,'e0e5d41da13a47a1aa3210c37b88bbcc','ac8793fd6752403e9dea029569836c09','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:40:58','2025-10-02 12:40:59','2025-10-02 12:41:11','tempest-VolumesTestJSON-volume-136148050',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:44:04','2025-10-02 12:46:04','2025-10-02 12:46:05',1,'857b1b6f-42d5-4289-a74d-1acb4fd6b032',NULL,'56c6abe1bb704c8aa499677aeb9017f5','4b8f9114c7ab4b6e9fc9650d4bd08af9','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:44:05','2025-10-02 12:44:14','2025-10-02 12:46:04','tempest-tempest.common.compute-volume-1390832971',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:16:09','2025-10-02 12:18:25','2025-10-02 12:18:26',1,'8c49b0fe-d42a-4dc2-8485-1c114233c6fc',NULL,'d4b073f3365d481cabadfd39389c66ba','a9d3eca266284ae9950c491e566b2523','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:16:09','2025-10-02 12:16:10','2025-10-02 12:18:25','tempest-TaggedBootDevicesTest-volume-1871472698',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:22:31','2025-10-02 12:24:26','2025-10-02 12:24:27',1,'9167ea91-ad1e-4fee-a80e-d0a6e8eac607',NULL,'4146a31af09c4e6a8aee251f2fec4f98','c740a14d1c5c45d1a0959b0e24ac460b','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:22:31','2025-10-02 12:22:31','2025-10-02 12:24:26','tempest-ServersNegativeTestJSON-volume-1114761097',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 13:13:45','2025-10-02 13:16:12','2025-10-02 13:16:13',1,'970cb928-04fe-4f96-87d5-ef615b8da829',NULL,'c10de71fef00497981b8b7cec6a3fff3','fbbc6cb494464fd9b31f64c1ad75fa6b','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:13:46','2025-10-02 13:13:52','2025-10-02 13:16:12','tempest-TestVolumeBootPattern-volume-origin-1925819282',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:41:02','2025-10-02 12:41:07','2025-10-02 12:41:08',1,'98bd5e6c-d74e-406d-91ad-27731eba40e6',NULL,'e0e5d41da13a47a1aa3210c37b88bbcc','ac8793fd6752403e9dea029569836c09','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:41:03','2025-10-02 12:41:03','2025-10-02 12:41:07','tempest-VolumesTestJSON-volume-1464379658',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:26:42','2025-10-02 12:33:37','2025-10-02 12:33:38',1,'9c6d2b3e-2a88-49f0-aefb-0738951478c4',NULL,'22d56fcd2a4b4851bfd126ae4548ee9b','5533aaac08cd4856af72ef4992bb5e76','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:26:42','2025-10-02 12:26:57','2025-10-02 12:33:37','tempest-AttachVolumeMultiAttachTest-volume-226189332',NULL,'{\"saved_features\":61}',NULL,NULL,'a5770664-6668-4712-8ea2-73ff2103264d',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:40:30','2025-10-02 12:44:09','2025-10-02 12:44:09',1,'9ccd0211-39da-4f0a-ae5b-a7561864b3d4',NULL,'b82c89ad6c4a49e78943f7a92d0a6560','a41d99312f014c65adddea4f70536a15','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:40:30','2025-10-02 12:41:02','2025-10-02 12:44:09','tempest-TestInstancesWithCinderVolumes-volume-377061244',NULL,NULL,NULL,NULL,'9f818080-1eb6-4f75-ae4b-98c84f6b2a89',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:22:27','2025-10-02 12:24:28','2025-10-02 12:24:28',1,'9d76220f-c63b-44b9-8f43-b2710348c5af',NULL,'4146a31af09c4e6a8aee251f2fec4f98','c740a14d1c5c45d1a0959b0e24ac460b','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:22:27','2025-10-02 12:22:27','2025-10-02 12:24:28','tempest-ServersNegativeTestJSON-volume-1855263919',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:19:17','2025-10-02 12:20:20',NULL,0,'a1b4f371-5f32-4b45-87d9-56f18142a917',NULL,'69d8e29c6d3747e98a5985a584f4c814','8efba404696b40fbbaa6431b934b87f1','hostgroup@ceph#ceph',1,'nova','available','detached','2025-10-02 12:19:18','2025-10-02 12:19:38',NULL,'','',NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:38:32','2025-10-02 12:42:47','2025-10-02 12:42:48',1,'a1bae65f-c0b4-46c3-b2fd-8ed16aa61b19',NULL,'c02d1dcc10ea4e57bbc6b7a3c100dc7b','6822f02d5ca04c659329a75d487054cf','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:38:33','2025-10-02 12:38:33','2025-10-02 12:42:47','tempest-ServerActionsTestOtherA-volume-1009930894',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 13:02:27','2025-10-02 13:06:05','2025-10-02 13:06:07',1,'b071d28d-2baf-4099-b6f4-9ad6bb72c88f',NULL,'93facc00c95f4cbfa6cecaf3641182bc','5eceae619a6f4fdeaa8ba6fafda4912a','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:02:27','2025-10-02 13:02:28','2025-10-02 13:06:05','tempest-AttachVolumeNegativeTest-volume-146895086',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:02:12','2025-10-02 12:03:21','2025-10-02 12:03:21',1,'b3df5dc9-9a56-4922-8b65-4162deb6be93',NULL,'efb31eeadee34403b1ab7a584f3616f7','3f2b3ac7d7504c9c96f0d4a67e0243c9','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:02:12','2025-10-02 12:02:19','2025-10-02 12:03:21','tempest-tempest.common.compute-volume-821859675',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:40:19','2025-10-02 12:42:05','2025-10-02 12:42:06',1,'bc8a781d-7240-4c85-8671-db184dc7c32b',NULL,'b82c89ad6c4a49e78943f7a92d0a6560','a41d99312f014c65adddea4f70536a15','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:40:20','2025-10-02 12:40:21','2025-10-02 12:42:05','tempest-TestInstancesWithCinderVolumes-volume-749628868',NULL,NULL,NULL,NULL,'d05c1d29-71bb-4e43-92a8-63f8e9efac08',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:59:05','2025-10-02 12:59:56','2025-10-02 12:59:57',1,'bf6c6619-4739-4799-81d0-3fa07140ece6',NULL,'729669e8835d4d95b5aae25c140e1f06','55e97477dd13448d9dafe69ec8614ea6','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:59:05','2025-10-02 12:59:05','2025-10-02 12:59:56','tempest-TestVolumeBackupRestore-volume-880596257',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:57:57','2025-10-02 13:00:53','2025-10-02 13:00:54',1,'c4c3ee6e-d57f-4361-8cda-389d0f995821',NULL,'3299a1aed5af4843a91417a3f181c172','e7168b5b1300495d90592b195824729a','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:57:57','2025-10-02 12:57:57','2025-10-02 13:00:53','tempest-AttachVolumeTestJSON-volume-1760276108',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 13:11:33','2025-10-02 13:13:31','2025-10-02 13:13:32',1,'cce428bb-67ad-45c7-9e76-52ebd4f984b0',NULL,'c10de71fef00497981b8b7cec6a3fff3','fbbc6cb494464fd9b31f64c1ad75fa6b','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:11:33','2025-10-02 13:11:42','2025-10-02 13:13:31','tempest-TestVolumeBootPattern-volume-origin-489945342',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:40:26','2025-10-02 12:40:33','2025-10-02 12:40:52',1,'d46a167a-d647-4005-a7ef-58b80277e714',NULL,'2ef0e75a2eb448f6a88afb59cc60686f','eb79c45adbb144538245fe5c27fade6d','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:40:27','2025-10-02 12:40:31','2025-10-02 12:40:33','tempest-VolumesGetTestJSON-Volume-1396752126',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:34:41','2025-10-02 12:38:41','2025-10-02 12:38:44',1,'d674cd8c-5d45-4ef7-9cb1-cd5cf5c7d43c',NULL,'bcd36ab668f449959719ba7058f25e72','1a05e525420b4aa8adcc9561158e73d1','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:34:41','2025-10-02 12:34:42','2025-10-02 12:38:41','tempest-AttachVolumeShelveTestJSON-volume-1198828296',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:41:52','2025-10-02 12:43:10','2025-10-02 12:43:11',1,'daaee0e4-d0d6-43f1-84a2-7bb4d00c48ef',NULL,'734ae44830d540d8ab51c2a3d75ecd80','2e53064cd4d645f09bd59bbca09b98e0','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:41:52','2025-10-02 12:41:53','2025-10-02 12:43:10','tempest-TestMinimumBasicScenario-volume-68972644',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 13:04:49','2025-10-02 13:06:03','2025-10-02 13:06:04',1,'dd4a5f3e-c055-4aa9-b3b2-bdd3900319cd',NULL,'93facc00c95f4cbfa6cecaf3641182bc','5eceae619a6f4fdeaa8ba6fafda4912a','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:04:49','2025-10-02 13:04:50','2025-10-02 13:06:03','tempest-AttachVolumeNegativeTest-volume-468998626',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:19:39','2025-10-02 12:21:40','2025-10-02 12:21:43',1,'df389b61-10b1-4346-9fa3-6333d5b9d5cf',NULL,'2a7f7518ce70488fb4f63af1a3bef131','84f71f6076f7425db7653ac203257df0','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:19:39','2025-10-02 12:19:40','2025-10-02 12:21:40','tempest-TaggedBootDevicesTest_v242-volume-152169847',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 13:00:28','2025-10-02 13:00:52','2025-10-02 13:00:52',1,'e20bbad6-3733-408d-b226-999bd1df2110',NULL,'3299a1aed5af4843a91417a3f181c172','e7168b5b1300495d90592b195824729a','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:00:28','2025-10-02 13:00:29','2025-10-02 13:00:52','tempest-AttachVolumeTestJSON-volume-355654354',NULL,NULL,NULL,NULL,'1cc1e254-249c-44da-9045-855b1e05dff7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 12:06:18','2025-10-02 12:08:18','2025-10-02 12:08:21',1,'e23e6d4e-f985-4eba-8a06-a71b109ee41e',NULL,'ec17c54e24584f11a5348b68d6e7ca85','7359a7dad3b849bfbf075b88f2a261b4','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 12:06:18','2025-10-02 12:06:19','2025-10-02 12:08:18','tempest-UpdateMultiattachVolumeNegativeTest-volume-499345318',NULL,'{\"saved_features\":61}',NULL,NULL,'a5770664-6668-4712-8ea2-73ff2103264d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1),('2025-10-02 13:15:16','2025-10-02 13:16:02','2025-10-02 13:16:03',1,'fb042846-a135-4c8d-8115-d7e363fd7891',NULL,'c10de71fef00497981b8b7cec6a3fff3','fbbc6cb494464fd9b31f64c1ad75fa6b','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-10-02 13:15:16','2025-10-02 13:15:17','2025-10-02 13:16:02','tempest-TestVolumeBootPattern-volume-1064848305',NULL,NULL,NULL,'f55859d5-64f0-4bc8-b298-3498e2ffc230','1cc1e254-249c-44da-9045-855b1e05dff7',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'979bee14-5c87-4561-bef6-d9e01dcad67f',0,1);
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workers`
--

DROP TABLE IF EXISTS `workers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `workers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(40) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  `status` varchar(255) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_type` (`resource_type`,`resource_id`),
  KEY `ix_workers_service_id` (`service_id`),
  CONSTRAINT `workers_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=145 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workers`
--

LOCK TABLES `workers` WRITE;
/*!40000 ALTER TABLE `workers` DISABLE KEYS */;
INSERT INTO `workers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `resource_type`, `resource_id`, `status`, `service_id`, `race_preventer`) VALUES ('2025-10-02 11:13:20','2025-10-02 11:13:20.000123',NULL,0,1,'SENTINEL','SUB-SECOND','OK',NULL,0);
/*!40000 ALTER TABLE `workers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `glance`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `glance` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `glance`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('2023_1_contract01');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_locations`
--

DROP TABLE IF EXISTS `image_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `meta_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `ix_image_locations_deleted` (`deleted`),
  KEY `ix_image_locations_image_id` (`image_id`),
  CONSTRAINT `image_locations_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_locations`
--

LOCK TABLES `image_locations` WRITE;
/*!40000 ALTER TABLE `image_locations` DISABLE KEYS */;
INSERT INTO `image_locations` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `meta_data`, `status`) VALUES (1,'c2d0c2bc-fe21-4689-86ae-d6728c15874c','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/c2d0c2bc-fe21-4689-86ae-d6728c15874c/snap','2025-10-02 11:57:45','2025-10-02 11:57:45',NULL,0,'{\"store\": \"default_backend\"}','active'),(2,'db05f54c-61f8-42d6-a1e2-da3219a77b12','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/db05f54c-61f8-42d6-a1e2-da3219a77b12/snap','2025-10-02 11:57:49','2025-10-02 11:57:49',NULL,0,'{\"store\": \"default_backend\"}','active'),(3,'bed55885-843b-4de0-bacc-58bcdc0a44ca','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/bed55885-843b-4de0-bacc-58bcdc0a44ca/snap','2025-10-02 12:05:05','2025-10-02 12:05:40','2025-10-02 12:05:40',1,'{\"store\": \"default_backend\"}','deleted'),(4,'a5e65e3c-7180-41c3-815b-a56c1c0389b1','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/a5e65e3c-7180-41c3-815b-a56c1c0389b1/snap','2025-10-02 12:05:56','2025-10-02 12:06:17','2025-10-02 12:06:17',1,'{\"store\": \"default_backend\"}','deleted'),(5,'9ba2a4cf-08bb-442a-b063-4fb551df3759','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/9ba2a4cf-08bb-442a-b063-4fb551df3759/snap','2025-10-02 12:07:16','2025-10-02 12:08:26','2025-10-02 12:08:26',1,'{\"store\": \"default_backend\"}','deleted'),(6,'38df317e-b7ae-4b50-a396-8480c76b07ca','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/38df317e-b7ae-4b50-a396-8480c76b07ca/snap','2025-10-02 12:08:44','2025-10-02 12:08:48','2025-10-02 12:08:48',1,'{\"store\": \"default_backend\"}','deleted'),(7,'ee6de086-2d75-4b23-a7d9-2ce77c5806eb','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/ee6de086-2d75-4b23-a7d9-2ce77c5806eb/snap','2025-10-02 12:09:24','2025-10-02 12:09:45','2025-10-02 12:09:45',1,'{\"store\": \"default_backend\"}','deleted'),(8,'6cb20915-4f3a-4331-8e5e-9cacc75a0090','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/6cb20915-4f3a-4331-8e5e-9cacc75a0090/snap','2025-10-02 12:10:35','2025-10-02 12:10:41','2025-10-02 12:10:41',1,'{\"store\": \"default_backend\"}','deleted'),(9,'856e53ca-7fff-4728-88ae-8118b60bc057','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/856e53ca-7fff-4728-88ae-8118b60bc057/snap','2025-10-02 12:10:51','2025-10-02 12:10:55','2025-10-02 12:10:55',1,'{\"store\": \"default_backend\"}','deleted'),(10,'6e6f7317-b757-4c70-b900-2266125b88d4','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/6e6f7317-b757-4c70-b900-2266125b88d4/snap','2025-10-02 12:10:56','2025-10-02 12:10:58','2025-10-02 12:10:58',1,'{\"store\": \"default_backend\"}','deleted'),(11,'f396cccc-8bcd-476b-8403-dd0820708c77','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/f396cccc-8bcd-476b-8403-dd0820708c77/snap','2025-10-02 12:11:46','2025-10-02 12:11:52','2025-10-02 12:11:52',1,'{\"store\": \"default_backend\"}','deleted'),(12,'2008c515-5405-4e2a-af36-731c08b54231','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/2008c515-5405-4e2a-af36-731c08b54231/snap','2025-10-02 12:12:28','2025-10-02 12:12:31','2025-10-02 12:12:31',1,'{\"store\": \"default_backend\"}','deleted'),(13,'11a037e0-306c-4ca3-91ab-08e92bb1fae5','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/11a037e0-306c-4ca3-91ab-08e92bb1fae5/snap','2025-10-02 12:12:59','2025-10-02 12:13:19','2025-10-02 12:13:19',1,'{\"store\": \"default_backend\"}','deleted'),(14,'3523f109-02ae-486e-b16d-f10c6a8b2ed0','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/3523f109-02ae-486e-b16d-f10c6a8b2ed0/snap','2025-10-02 12:16:23','2025-10-02 12:17:29','2025-10-02 12:17:29',1,'{\"store\": \"default_backend\"}','deleted'),(15,'25a70251-d8a8-4d2b-8882-5f0b56cee70f','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/25a70251-d8a8-4d2b-8882-5f0b56cee70f/snap','2025-10-02 12:16:26','2025-10-02 12:17:28','2025-10-02 12:17:28',1,'{\"store\": \"default_backend\"}','deleted'),(16,'ed9bbd8f-0e2a-4deb-9139-680228c87f79','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/ed9bbd8f-0e2a-4deb-9139-680228c87f79/snap','2025-10-02 12:16:29','2025-10-02 12:17:26','2025-10-02 12:17:26',1,'{\"store\": \"default_backend\"}','deleted'),(17,'3242b862-74d4-4558-9399-2a866969329a','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/3242b862-74d4-4558-9399-2a866969329a/snap','2025-10-02 12:16:47','2025-10-02 12:17:15','2025-10-02 12:17:15',1,'{\"store\": \"default_backend\"}','deleted'),(18,'358aa82b-067b-458c-9095-e40a3a914f59','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/358aa82b-067b-458c-9095-e40a3a914f59/snap','2025-10-02 12:16:55','2025-10-02 12:17:13','2025-10-02 12:17:13',1,'{\"store\": \"default_backend\"}','deleted'),(19,'fdf855eb-5dbd-44e1-9b72-cac174cddd41','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/fdf855eb-5dbd-44e1-9b72-cac174cddd41/snap','2025-10-02 12:17:02','2025-10-02 12:17:12','2025-10-02 12:17:12',1,'{\"store\": \"default_backend\"}','deleted'),(20,'e7ad18e6-654f-48ae-a957-a50e1a2c7a2d','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/e7ad18e6-654f-48ae-a957-a50e1a2c7a2d/snap','2025-10-02 12:17:08','2025-10-02 12:20:34','2025-10-02 12:20:34',1,'{\"store\": \"default_backend\"}','deleted'),(21,'8aa41919-15c5-43d9-ac12-d18997b6c8f0','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/8aa41919-15c5-43d9-ac12-d18997b6c8f0/snap','2025-10-02 12:19:10','2025-10-02 12:20:25','2025-10-02 12:20:25',1,'{\"store\": \"default_backend\"}','deleted'),(22,'6adae2f0-2d5d-4fab-88e2-2a0e5685e8f9','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/6adae2f0-2d5d-4fab-88e2-2a0e5685e8f9/snap','2025-10-02 12:20:41','2025-10-02 12:20:59','2025-10-02 12:20:59',1,'{\"store\": \"default_backend\"}','deleted'),(23,'2410127a-756e-4057-a962-4fe35566fc7f','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/2410127a-756e-4057-a962-4fe35566fc7f/snap','2025-10-02 12:20:48','2025-10-02 12:21:04','2025-10-02 12:21:04',1,'{\"store\": \"default_backend\"}','deleted'),(24,'4b2241f1-ae4c-491b-8811-8c9dd1f13160','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/4b2241f1-ae4c-491b-8811-8c9dd1f13160/snap','2025-10-02 12:20:56','2025-10-02 12:21:02','2025-10-02 12:21:02',1,'{\"store\": \"default_backend\"}','deleted'),(25,'7aeb8031-5492-47ae-a269-5cc3e1a66a2a','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/7aeb8031-5492-47ae-a269-5cc3e1a66a2a/snap','2025-10-02 12:21:48','2025-10-02 12:22:00','2025-10-02 12:22:00',1,'{\"store\": \"default_backend\"}','deleted'),(26,'69218608-9c78-4f65-a885-9cb0c1edca97','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/69218608-9c78-4f65-a885-9cb0c1edca97/snap','2025-10-02 12:23:40','2025-10-02 12:24:03','2025-10-02 12:24:03',1,'{\"store\": \"default_backend\"}','deleted'),(27,'cf521338-6de6-477f-b445-df9c97d57576','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/cf521338-6de6-477f-b445-df9c97d57576/snap','2025-10-02 12:25:03','2025-10-02 12:26:17','2025-10-02 12:26:17',1,'{\"store\": \"default_backend\"}','deleted'),(28,'cf693858-d747-42e7-8f75-d6c36d36cc6c','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/cf693858-d747-42e7-8f75-d6c36d36cc6c/snap','2025-10-02 12:25:31','2025-10-02 12:26:12','2025-10-02 12:26:12',1,'{\"store\": \"default_backend\"}','deleted'),(29,'c9b30ff1-d6cd-4854-b30d-a4ebbd02d3dc','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/c9b30ff1-d6cd-4854-b30d-a4ebbd02d3dc/snap','2025-10-02 12:32:41','2025-10-02 12:32:51','2025-10-02 12:32:51',1,'{\"store\": \"default_backend\"}','deleted'),(30,'656ad3f4-b233-4eb8-822c-07efc986a6e0','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/656ad3f4-b233-4eb8-822c-07efc986a6e0/snap','2025-10-02 12:34:53','2025-10-02 12:35:59','2025-10-02 12:35:59',1,'{\"store\": \"default_backend\"}','deleted'),(31,'766f42a5-3020-41dc-a077-fda5642a1d60','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/766f42a5-3020-41dc-a077-fda5642a1d60/snap','2025-10-02 12:37:37','2025-10-02 12:38:14','2025-10-02 12:38:14',1,'{\"store\": \"default_backend\"}','deleted'),(32,'fdcd4413-2e65-4120-9e32-9681c702a01f','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/fdcd4413-2e65-4120-9e32-9681c702a01f/snap','2025-10-02 12:40:18','2025-10-02 12:44:20','2025-10-02 12:44:20',1,'{\"store\": \"default_backend\"}','deleted'),(33,'881d7140-1aef-4d5d-b04d-76b7b19d6837','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/881d7140-1aef-4d5d-b04d-76b7b19d6837/snap','2025-10-02 12:41:23','2025-10-02 12:43:34','2025-10-02 12:43:34',1,'{\"store\": \"default_backend\"}','deleted'),(34,'b6b477f5-f929-4c8c-a864-0bf66fee68a2','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/b6b477f5-f929-4c8c-a864-0bf66fee68a2/snap','2025-10-02 12:42:58','2025-10-02 12:43:29','2025-10-02 12:43:29',1,'{\"store\": \"default_backend\"}','deleted'),(35,'6225d2a0-8cbb-42ed-9a0a-13744b0f7ae4','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/6225d2a0-8cbb-42ed-9a0a-13744b0f7ae4/snap','2025-10-02 12:43:37','2025-10-02 12:45:34','2025-10-02 12:45:34',1,'{\"store\": \"default_backend\"}','deleted'),(36,'a62d470f-f755-4a5a-b8e5-0dc1be0600d1','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/a62d470f-f755-4a5a-b8e5-0dc1be0600d1/snap','2025-10-02 12:48:09','2025-10-02 12:49:24','2025-10-02 12:49:24',1,'{\"store\": \"default_backend\"}','deleted'),(37,'5428ba77-2370-48a0-8396-a85c08f86505','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/5428ba77-2370-48a0-8396-a85c08f86505/snap','2025-10-02 12:48:39','2025-10-02 12:55:13','2025-10-02 12:55:13',1,'{\"store\": \"default_backend\"}','deleted'),(38,'b25d743c-aae4-4c6f-a9cb-a03c63b08b2c','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/b25d743c-aae4-4c6f-a9cb-a03c63b08b2c/snap','2025-10-02 12:49:31','2025-10-02 12:55:06','2025-10-02 12:55:06',1,'{\"store\": \"default_backend\"}','deleted'),(39,'e3ec26e3-5879-4ab0-bb2c-bf8f5cbdc0c0','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/e3ec26e3-5879-4ab0-bb2c-bf8f5cbdc0c0/snap','2025-10-02 12:50:22','2025-10-02 12:55:00','2025-10-02 12:55:00',1,'{\"store\": \"default_backend\"}','deleted'),(40,'c899ce5c-6879-41fc-92e4-79bd307b464d','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/c899ce5c-6879-41fc-92e4-79bd307b464d/snap','2025-10-02 12:52:34','2025-10-02 12:54:47','2025-10-02 12:54:47',1,'{\"store\": \"default_backend\"}','deleted'),(41,'a1241e22-2f30-42e3-8072-a21ad0ab0f69','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/a1241e22-2f30-42e3-8072-a21ad0ab0f69/snap','2025-10-02 13:08:39','2025-10-02 13:09:51','2025-10-02 13:09:51',1,'{\"store\": \"default_backend\"}','deleted'),(42,'ef37c5e7-f078-42ef-9403-bff6103a0870','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/ef37c5e7-f078-42ef-9403-bff6103a0870/snap','2025-10-02 13:09:42','2025-10-02 13:09:45','2025-10-02 13:09:45',1,'{\"store\": \"default_backend\"}','deleted'),(43,'f1af818e-71fa-4f13-bb73-d787866237a6','rbd://fd4c5763-22d1-50ea-ad0b-96a3dc3040b2/images/f1af818e-71fa-4f13-bb73-d787866237a6/snap','2025-10-02 13:12:22','2025-10-02 13:13:37','2025-10-02 13:13:37',1,'{\"store\": \"default_backend\"}','deleted');
/*!40000 ALTER TABLE `image_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_members`
--

DROP TABLE IF EXISTS `image_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `member` varchar(255) NOT NULL,
  `can_share` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image_members_image_id_member_deleted_at_key` (`image_id`,`member`,`deleted_at`),
  KEY `ix_image_members_deleted` (`deleted`),
  KEY `ix_image_members_image_id` (`image_id`),
  KEY `ix_image_members_image_id_member` (`image_id`,`member`),
  CONSTRAINT `image_members_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`can_share` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_members`
--

LOCK TABLES `image_members` WRITE;
/*!40000 ALTER TABLE `image_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_properties`
--

DROP TABLE IF EXISTS `image_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_image_properties_image_id_name` (`image_id`,`name`),
  KEY `ix_image_properties_deleted` (`deleted`),
  KEY `ix_image_properties_image_id` (`image_id`),
  CONSTRAINT `image_properties_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=661 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_properties`
--

LOCK TABLES `image_properties` WRITE;
/*!40000 ALTER TABLE `image_properties` DISABLE KEYS */;
INSERT INTO `image_properties` (`id`, `image_id`, `name`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'c2d0c2bc-fe21-4689-86ae-d6728c15874c','hw_rng_model','virtio','2025-10-02 11:57:41','2025-10-02 11:57:41',NULL,0),(2,'db05f54c-61f8-42d6-a1e2-da3219a77b12','hw_rng_model','virtio','2025-10-02 11:57:47','2025-10-02 11:57:47',NULL,0),(3,'bed55885-843b-4de0-bacc-58bcdc0a44ca','hw_rng_model','virtio','2025-10-02 12:04:43','2025-10-02 12:05:40','2025-10-02 12:05:40',1),(4,'bed55885-843b-4de0-bacc-58bcdc0a44ca','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:04:43','2025-10-02 12:05:40','2025-10-02 12:05:40',1),(5,'bed55885-843b-4de0-bacc-58bcdc0a44ca','owner_user_name','tempest-UnshelveToHostMultiNodesTest-32053853-project-member','2025-10-02 12:04:43','2025-10-02 12:05:40','2025-10-02 12:05:40',1),(6,'bed55885-843b-4de0-bacc-58bcdc0a44ca','owner_project_name','tempest-UnshelveToHostMultiNodesTest-32053853','2025-10-02 12:04:43','2025-10-02 12:05:40','2025-10-02 12:05:40',1),(7,'bed55885-843b-4de0-bacc-58bcdc0a44ca','boot_roles','member,reader','2025-10-02 12:04:43','2025-10-02 12:05:40','2025-10-02 12:05:40',1),(8,'bed55885-843b-4de0-bacc-58bcdc0a44ca','hw_machine_type','q35','2025-10-02 12:04:43','2025-10-02 12:05:40','2025-10-02 12:05:40',1),(9,'bed55885-843b-4de0-bacc-58bcdc0a44ca','hw_cdrom_bus','sata','2025-10-02 12:04:43','2025-10-02 12:05:40','2025-10-02 12:05:40',1),(10,'bed55885-843b-4de0-bacc-58bcdc0a44ca','hw_disk_bus','virtio','2025-10-02 12:04:43','2025-10-02 12:05:40','2025-10-02 12:05:40',1),(11,'bed55885-843b-4de0-bacc-58bcdc0a44ca','hw_input_bus','usb','2025-10-02 12:04:43','2025-10-02 12:05:40','2025-10-02 12:05:40',1),(12,'bed55885-843b-4de0-bacc-58bcdc0a44ca','hw_pointer_model','usbtablet','2025-10-02 12:04:43','2025-10-02 12:05:40','2025-10-02 12:05:40',1),(13,'bed55885-843b-4de0-bacc-58bcdc0a44ca','hw_video_model','virtio','2025-10-02 12:04:43','2025-10-02 12:05:40','2025-10-02 12:05:40',1),(14,'bed55885-843b-4de0-bacc-58bcdc0a44ca','hw_vif_model','virtio','2025-10-02 12:04:43','2025-10-02 12:05:40','2025-10-02 12:05:40',1),(15,'bed55885-843b-4de0-bacc-58bcdc0a44ca','instance_uuid','81cd8274-bb25-4b6c-aa66-89669fd098d5','2025-10-02 12:04:43','2025-10-02 12:05:40','2025-10-02 12:05:40',1),(16,'bed55885-843b-4de0-bacc-58bcdc0a44ca','user_id','a10a935aed2d40ff8ee890b3089c7d03','2025-10-02 12:04:43','2025-10-02 12:05:40','2025-10-02 12:05:40',1),(17,'bed55885-843b-4de0-bacc-58bcdc0a44ca','image_type','snapshot','2025-10-02 12:04:43','2025-10-02 12:05:40','2025-10-02 12:05:40',1),(18,'bed55885-843b-4de0-bacc-58bcdc0a44ca','owner_id','39f16ad971c74b0296dabeb9b59464da','2025-10-02 12:05:03','2025-10-02 12:05:40','2025-10-02 12:05:40',1),(19,'bed55885-843b-4de0-bacc-58bcdc0a44ca','image_location','snapshot','2025-10-02 12:05:03','2025-10-02 12:05:40','2025-10-02 12:05:40',1),(20,'bed55885-843b-4de0-bacc-58bcdc0a44ca','image_state','available','2025-10-02 12:05:03','2025-10-02 12:05:40','2025-10-02 12:05:40',1),(21,'a5e65e3c-7180-41c3-815b-a56c1c0389b1','hw_rng_model','virtio','2025-10-02 12:05:44','2025-10-02 12:06:17','2025-10-02 12:06:17',1),(22,'a5e65e3c-7180-41c3-815b-a56c1c0389b1','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:05:44','2025-10-02 12:06:17','2025-10-02 12:06:17',1),(23,'a5e65e3c-7180-41c3-815b-a56c1c0389b1','owner_user_name','tempest-UnshelveToHostMultiNodesTest-32053853-project-member','2025-10-02 12:05:44','2025-10-02 12:06:17','2025-10-02 12:06:17',1),(24,'a5e65e3c-7180-41c3-815b-a56c1c0389b1','owner_project_name','tempest-UnshelveToHostMultiNodesTest-32053853','2025-10-02 12:05:44','2025-10-02 12:06:17','2025-10-02 12:06:17',1),(25,'a5e65e3c-7180-41c3-815b-a56c1c0389b1','boot_roles','member,reader','2025-10-02 12:05:44','2025-10-02 12:06:17','2025-10-02 12:06:17',1),(26,'a5e65e3c-7180-41c3-815b-a56c1c0389b1','hw_machine_type','q35','2025-10-02 12:05:44','2025-10-02 12:06:17','2025-10-02 12:06:17',1),(27,'a5e65e3c-7180-41c3-815b-a56c1c0389b1','hw_cdrom_bus','sata','2025-10-02 12:05:44','2025-10-02 12:06:17','2025-10-02 12:06:17',1),(28,'a5e65e3c-7180-41c3-815b-a56c1c0389b1','hw_disk_bus','virtio','2025-10-02 12:05:44','2025-10-02 12:06:17','2025-10-02 12:06:17',1),(29,'a5e65e3c-7180-41c3-815b-a56c1c0389b1','hw_input_bus','usb','2025-10-02 12:05:44','2025-10-02 12:06:17','2025-10-02 12:06:17',1),(30,'a5e65e3c-7180-41c3-815b-a56c1c0389b1','hw_pointer_model','usbtablet','2025-10-02 12:05:44','2025-10-02 12:06:17','2025-10-02 12:06:17',1),(31,'a5e65e3c-7180-41c3-815b-a56c1c0389b1','hw_video_model','virtio','2025-10-02 12:05:44','2025-10-02 12:06:17','2025-10-02 12:06:17',1),(32,'a5e65e3c-7180-41c3-815b-a56c1c0389b1','hw_vif_model','virtio','2025-10-02 12:05:44','2025-10-02 12:06:17','2025-10-02 12:06:17',1),(33,'a5e65e3c-7180-41c3-815b-a56c1c0389b1','clean_attempts','1','2025-10-02 12:05:44','2025-10-02 12:06:17','2025-10-02 12:06:17',1),(34,'a5e65e3c-7180-41c3-815b-a56c1c0389b1','instance_uuid','81cd8274-bb25-4b6c-aa66-89669fd098d5','2025-10-02 12:05:44','2025-10-02 12:06:17','2025-10-02 12:06:17',1),(35,'a5e65e3c-7180-41c3-815b-a56c1c0389b1','user_id','a10a935aed2d40ff8ee890b3089c7d03','2025-10-02 12:05:44','2025-10-02 12:06:17','2025-10-02 12:06:17',1),(36,'a5e65e3c-7180-41c3-815b-a56c1c0389b1','image_type','snapshot','2025-10-02 12:05:44','2025-10-02 12:06:17','2025-10-02 12:06:17',1),(37,'a5e65e3c-7180-41c3-815b-a56c1c0389b1','owner_id','39f16ad971c74b0296dabeb9b59464da','2025-10-02 12:05:55','2025-10-02 12:06:17','2025-10-02 12:06:17',1),(38,'a5e65e3c-7180-41c3-815b-a56c1c0389b1','image_location','snapshot','2025-10-02 12:05:55','2025-10-02 12:06:17','2025-10-02 12:06:17',1),(39,'a5e65e3c-7180-41c3-815b-a56c1c0389b1','image_state','available','2025-10-02 12:05:55','2025-10-02 12:06:17','2025-10-02 12:06:17',1),(40,'9ba2a4cf-08bb-442a-b063-4fb551df3759','hw_scsi_model','virtio-scsi','2025-10-02 12:07:14','2025-10-02 12:08:26','2025-10-02 12:08:26',1),(41,'9ba2a4cf-08bb-442a-b063-4fb551df3759','hw_disk_bus','scsi','2025-10-02 12:07:14','2025-10-02 12:08:26','2025-10-02 12:08:26',1),(42,'9ba2a4cf-08bb-442a-b063-4fb551df3759','hw_cdrom_bus','scsi','2025-10-02 12:07:14','2025-10-02 12:08:26','2025-10-02 12:08:26',1),(43,'ee6de086-2d75-4b23-a7d9-2ce77c5806eb','os_distro','value2','2025-10-02 12:09:25','2025-10-02 12:09:45','2025-10-02 12:09:45',1),(44,'ee6de086-2d75-4b23-a7d9-2ce77c5806eb','os_version','alt1','2025-10-02 12:09:25','2025-10-02 12:09:45','2025-10-02 12:09:45',1),(45,'ee6de086-2d75-4b23-a7d9-2ce77c5806eb','architecture','value3','2025-10-02 12:09:35','2025-10-02 12:09:45','2025-10-02 12:09:45',1),(46,'6cb20915-4f3a-4331-8e5e-9cacc75a0090','hw_rng_model','virtio','2025-10-02 12:10:30','2025-10-02 12:10:41','2025-10-02 12:10:41',1),(47,'6cb20915-4f3a-4331-8e5e-9cacc75a0090','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:10:30','2025-10-02 12:10:41','2025-10-02 12:10:41',1),(48,'6cb20915-4f3a-4331-8e5e-9cacc75a0090','owner_user_name','tempest-ImagesOneServerTestJSON-1710294689-project-member','2025-10-02 12:10:30','2025-10-02 12:10:41','2025-10-02 12:10:41',1),(49,'6cb20915-4f3a-4331-8e5e-9cacc75a0090','owner_project_name','tempest-ImagesOneServerTestJSON-1710294689','2025-10-02 12:10:30','2025-10-02 12:10:41','2025-10-02 12:10:41',1),(50,'6cb20915-4f3a-4331-8e5e-9cacc75a0090','boot_roles','member,reader','2025-10-02 12:10:30','2025-10-02 12:10:41','2025-10-02 12:10:41',1),(51,'6cb20915-4f3a-4331-8e5e-9cacc75a0090','hw_machine_type','q35','2025-10-02 12:10:30','2025-10-02 12:10:41','2025-10-02 12:10:41',1),(52,'6cb20915-4f3a-4331-8e5e-9cacc75a0090','hw_cdrom_bus','sata','2025-10-02 12:10:30','2025-10-02 12:10:41','2025-10-02 12:10:41',1),(53,'6cb20915-4f3a-4331-8e5e-9cacc75a0090','hw_disk_bus','virtio','2025-10-02 12:10:30','2025-10-02 12:10:41','2025-10-02 12:10:41',1),(54,'6cb20915-4f3a-4331-8e5e-9cacc75a0090','hw_input_bus','usb','2025-10-02 12:10:30','2025-10-02 12:10:41','2025-10-02 12:10:41',1),(55,'6cb20915-4f3a-4331-8e5e-9cacc75a0090','hw_pointer_model','usbtablet','2025-10-02 12:10:30','2025-10-02 12:10:41','2025-10-02 12:10:41',1),(56,'6cb20915-4f3a-4331-8e5e-9cacc75a0090','hw_video_model','virtio','2025-10-02 12:10:30','2025-10-02 12:10:41','2025-10-02 12:10:41',1),(57,'6cb20915-4f3a-4331-8e5e-9cacc75a0090','hw_vif_model','virtio','2025-10-02 12:10:30','2025-10-02 12:10:41','2025-10-02 12:10:41',1),(58,'6cb20915-4f3a-4331-8e5e-9cacc75a0090','instance_uuid','2b0bce41-aada-43ea-8c21-a68eeb2720c0','2025-10-02 12:10:30','2025-10-02 12:10:41','2025-10-02 12:10:41',1),(59,'6cb20915-4f3a-4331-8e5e-9cacc75a0090','user_id','3c2b867915b342b5acd8026e8fc9fe00','2025-10-02 12:10:30','2025-10-02 12:10:41','2025-10-02 12:10:41',1),(60,'6cb20915-4f3a-4331-8e5e-9cacc75a0090','image_type','test','2025-10-02 12:10:30','2025-10-02 12:10:41','2025-10-02 12:10:41',1),(61,'6cb20915-4f3a-4331-8e5e-9cacc75a0090','image_location','snapshot','2025-10-02 12:10:34','2025-10-02 12:10:41','2025-10-02 12:10:41',1),(62,'6cb20915-4f3a-4331-8e5e-9cacc75a0090','image_state','available','2025-10-02 12:10:34','2025-10-02 12:10:41','2025-10-02 12:10:41',1),(63,'6cb20915-4f3a-4331-8e5e-9cacc75a0090','owner_id','07abaa757bde49eead1d80ce844ec6ba','2025-10-02 12:10:34','2025-10-02 12:10:41','2025-10-02 12:10:41',1),(64,'856e53ca-7fff-4728-88ae-8118b60bc057','hw_rng_model','virtio','2025-10-02 12:10:42','2025-10-02 12:10:55','2025-10-02 12:10:55',1),(65,'856e53ca-7fff-4728-88ae-8118b60bc057','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:10:42','2025-10-02 12:10:55','2025-10-02 12:10:55',1),(66,'856e53ca-7fff-4728-88ae-8118b60bc057','owner_user_name','tempest-ImagesOneServerTestJSON-1710294689-project-member','2025-10-02 12:10:42','2025-10-02 12:10:55','2025-10-02 12:10:55',1),(67,'856e53ca-7fff-4728-88ae-8118b60bc057','owner_project_name','tempest-ImagesOneServerTestJSON-1710294689','2025-10-02 12:10:42','2025-10-02 12:10:55','2025-10-02 12:10:55',1),(68,'856e53ca-7fff-4728-88ae-8118b60bc057','boot_roles','member,reader','2025-10-02 12:10:42','2025-10-02 12:10:55','2025-10-02 12:10:55',1),(69,'856e53ca-7fff-4728-88ae-8118b60bc057','hw_machine_type','q35','2025-10-02 12:10:42','2025-10-02 12:10:55','2025-10-02 12:10:55',1),(70,'856e53ca-7fff-4728-88ae-8118b60bc057','hw_cdrom_bus','sata','2025-10-02 12:10:42','2025-10-02 12:10:55','2025-10-02 12:10:55',1),(71,'856e53ca-7fff-4728-88ae-8118b60bc057','hw_disk_bus','virtio','2025-10-02 12:10:42','2025-10-02 12:10:55','2025-10-02 12:10:55',1),(72,'856e53ca-7fff-4728-88ae-8118b60bc057','hw_input_bus','usb','2025-10-02 12:10:42','2025-10-02 12:10:55','2025-10-02 12:10:55',1),(73,'856e53ca-7fff-4728-88ae-8118b60bc057','hw_pointer_model','usbtablet','2025-10-02 12:10:42','2025-10-02 12:10:55','2025-10-02 12:10:55',1),(74,'856e53ca-7fff-4728-88ae-8118b60bc057','hw_video_model','virtio','2025-10-02 12:10:42','2025-10-02 12:10:55','2025-10-02 12:10:55',1),(75,'856e53ca-7fff-4728-88ae-8118b60bc057','hw_vif_model','virtio','2025-10-02 12:10:42','2025-10-02 12:10:55','2025-10-02 12:10:55',1),(76,'856e53ca-7fff-4728-88ae-8118b60bc057','instance_uuid','2b0bce41-aada-43ea-8c21-a68eeb2720c0','2025-10-02 12:10:42','2025-10-02 12:10:55','2025-10-02 12:10:55',1),(77,'856e53ca-7fff-4728-88ae-8118b60bc057','user_id','3c2b867915b342b5acd8026e8fc9fe00','2025-10-02 12:10:42','2025-10-02 12:10:55','2025-10-02 12:10:55',1),(78,'856e53ca-7fff-4728-88ae-8118b60bc057','image_type','snapshot','2025-10-02 12:10:42','2025-10-02 12:10:55','2025-10-02 12:10:55',1),(79,'6e6f7317-b757-4c70-b900-2266125b88d4','hw_rng_model','virtio','2025-10-02 12:10:46','2025-10-02 12:10:58','2025-10-02 12:10:58',1),(80,'6e6f7317-b757-4c70-b900-2266125b88d4','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:10:46','2025-10-02 12:10:58','2025-10-02 12:10:58',1),(81,'6e6f7317-b757-4c70-b900-2266125b88d4','owner_user_name','tempest-ImagesTestJSON-2116266493-project-member','2025-10-02 12:10:46','2025-10-02 12:10:58','2025-10-02 12:10:58',1),(82,'6e6f7317-b757-4c70-b900-2266125b88d4','owner_project_name','tempest-ImagesTestJSON-2116266493','2025-10-02 12:10:46','2025-10-02 12:10:58','2025-10-02 12:10:58',1),(83,'6e6f7317-b757-4c70-b900-2266125b88d4','boot_roles','member,reader','2025-10-02 12:10:46','2025-10-02 12:10:58','2025-10-02 12:10:58',1),(84,'6e6f7317-b757-4c70-b900-2266125b88d4','hw_machine_type','q35','2025-10-02 12:10:46','2025-10-02 12:10:58','2025-10-02 12:10:58',1),(85,'6e6f7317-b757-4c70-b900-2266125b88d4','hw_cdrom_bus','sata','2025-10-02 12:10:46','2025-10-02 12:10:58','2025-10-02 12:10:58',1),(86,'6e6f7317-b757-4c70-b900-2266125b88d4','hw_disk_bus','virtio','2025-10-02 12:10:46','2025-10-02 12:10:58','2025-10-02 12:10:58',1),(87,'6e6f7317-b757-4c70-b900-2266125b88d4','hw_input_bus','usb','2025-10-02 12:10:46','2025-10-02 12:10:58','2025-10-02 12:10:58',1),(88,'6e6f7317-b757-4c70-b900-2266125b88d4','hw_pointer_model','usbtablet','2025-10-02 12:10:46','2025-10-02 12:10:58','2025-10-02 12:10:58',1),(89,'6e6f7317-b757-4c70-b900-2266125b88d4','hw_video_model','virtio','2025-10-02 12:10:46','2025-10-02 12:10:58','2025-10-02 12:10:58',1),(90,'6e6f7317-b757-4c70-b900-2266125b88d4','hw_vif_model','virtio','2025-10-02 12:10:46','2025-10-02 12:10:58','2025-10-02 12:10:58',1),(91,'6e6f7317-b757-4c70-b900-2266125b88d4','instance_uuid','9a277afb-614b-4bf4-af98-8d08d450f263','2025-10-02 12:10:46','2025-10-02 12:10:58','2025-10-02 12:10:58',1),(92,'6e6f7317-b757-4c70-b900-2266125b88d4','user_id','0df47040f1ff4ce69a6fbdfd9eba4955','2025-10-02 12:10:46','2025-10-02 12:10:58','2025-10-02 12:10:58',1),(93,'6e6f7317-b757-4c70-b900-2266125b88d4','image_type','snapshot','2025-10-02 12:10:46','2025-10-02 12:10:58','2025-10-02 12:10:58',1),(94,'856e53ca-7fff-4728-88ae-8118b60bc057','image_location','snapshot','2025-10-02 12:10:50','2025-10-02 12:10:55','2025-10-02 12:10:55',1),(95,'856e53ca-7fff-4728-88ae-8118b60bc057','image_state','available','2025-10-02 12:10:50','2025-10-02 12:10:55','2025-10-02 12:10:55',1),(96,'856e53ca-7fff-4728-88ae-8118b60bc057','owner_id','07abaa757bde49eead1d80ce844ec6ba','2025-10-02 12:10:50','2025-10-02 12:10:55','2025-10-02 12:10:55',1),(97,'6e6f7317-b757-4c70-b900-2266125b88d4','owner_id','55d20ae21b6d4f0abfff3bccc371ee7a','2025-10-02 12:10:55','2025-10-02 12:10:58','2025-10-02 12:10:58',1),(98,'6e6f7317-b757-4c70-b900-2266125b88d4','image_location','snapshot','2025-10-02 12:10:55','2025-10-02 12:10:58','2025-10-02 12:10:58',1),(99,'6e6f7317-b757-4c70-b900-2266125b88d4','image_state','available','2025-10-02 12:10:55','2025-10-02 12:10:58','2025-10-02 12:10:58',1),(100,'f396cccc-8bcd-476b-8403-dd0820708c77','hw_rng_model','virtio','2025-10-02 12:11:38','2025-10-02 12:11:52','2025-10-02 12:11:52',1),(101,'f396cccc-8bcd-476b-8403-dd0820708c77','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:11:38','2025-10-02 12:11:52','2025-10-02 12:11:52',1),(102,'f396cccc-8bcd-476b-8403-dd0820708c77','owner_user_name','tempest-ImagesTestJSON-2116266493-project-member','2025-10-02 12:11:38','2025-10-02 12:11:52','2025-10-02 12:11:52',1),(103,'f396cccc-8bcd-476b-8403-dd0820708c77','owner_project_name','tempest-ImagesTestJSON-2116266493','2025-10-02 12:11:38','2025-10-02 12:11:52','2025-10-02 12:11:52',1),(104,'f396cccc-8bcd-476b-8403-dd0820708c77','boot_roles','member,reader','2025-10-02 12:11:38','2025-10-02 12:11:52','2025-10-02 12:11:52',1),(105,'f396cccc-8bcd-476b-8403-dd0820708c77','hw_machine_type','q35','2025-10-02 12:11:38','2025-10-02 12:11:52','2025-10-02 12:11:52',1),(106,'f396cccc-8bcd-476b-8403-dd0820708c77','hw_cdrom_bus','sata','2025-10-02 12:11:38','2025-10-02 12:11:52','2025-10-02 12:11:52',1),(107,'f396cccc-8bcd-476b-8403-dd0820708c77','hw_disk_bus','virtio','2025-10-02 12:11:38','2025-10-02 12:11:52','2025-10-02 12:11:52',1),(108,'f396cccc-8bcd-476b-8403-dd0820708c77','hw_input_bus','usb','2025-10-02 12:11:38','2025-10-02 12:11:52','2025-10-02 12:11:52',1),(109,'f396cccc-8bcd-476b-8403-dd0820708c77','hw_pointer_model','usbtablet','2025-10-02 12:11:38','2025-10-02 12:11:52','2025-10-02 12:11:52',1),(110,'f396cccc-8bcd-476b-8403-dd0820708c77','hw_video_model','virtio','2025-10-02 12:11:38','2025-10-02 12:11:52','2025-10-02 12:11:52',1),(111,'f396cccc-8bcd-476b-8403-dd0820708c77','hw_vif_model','virtio','2025-10-02 12:11:38','2025-10-02 12:11:52','2025-10-02 12:11:52',1),(112,'f396cccc-8bcd-476b-8403-dd0820708c77','instance_uuid','6332947f-08a8-4242-8a69-f3d57b8112e7','2025-10-02 12:11:38','2025-10-02 12:11:52','2025-10-02 12:11:52',1),(113,'f396cccc-8bcd-476b-8403-dd0820708c77','user_id','0df47040f1ff4ce69a6fbdfd9eba4955','2025-10-02 12:11:38','2025-10-02 12:11:52','2025-10-02 12:11:52',1),(114,'f396cccc-8bcd-476b-8403-dd0820708c77','image_type','snapshot','2025-10-02 12:11:38','2025-10-02 12:11:52','2025-10-02 12:11:52',1),(115,'f396cccc-8bcd-476b-8403-dd0820708c77','owner_id','55d20ae21b6d4f0abfff3bccc371ee7a','2025-10-02 12:11:43','2025-10-02 12:11:52','2025-10-02 12:11:52',1),(116,'f396cccc-8bcd-476b-8403-dd0820708c77','image_location','snapshot','2025-10-02 12:11:43','2025-10-02 12:11:52','2025-10-02 12:11:52',1),(117,'f396cccc-8bcd-476b-8403-dd0820708c77','image_state','available','2025-10-02 12:11:43','2025-10-02 12:11:52','2025-10-02 12:11:52',1),(118,'2008c515-5405-4e2a-af36-731c08b54231','hw_rng_model','virtio','2025-10-02 12:12:18','2025-10-02 12:12:31','2025-10-02 12:12:31',1),(119,'2008c515-5405-4e2a-af36-731c08b54231','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:12:18','2025-10-02 12:12:31','2025-10-02 12:12:31',1),(120,'2008c515-5405-4e2a-af36-731c08b54231','owner_user_name','tempest-ImagesTestJSON-2116266493-project-member','2025-10-02 12:12:18','2025-10-02 12:12:31','2025-10-02 12:12:31',1),(121,'2008c515-5405-4e2a-af36-731c08b54231','owner_project_name','tempest-ImagesTestJSON-2116266493','2025-10-02 12:12:18','2025-10-02 12:12:31','2025-10-02 12:12:31',1),(122,'2008c515-5405-4e2a-af36-731c08b54231','boot_roles','member,reader','2025-10-02 12:12:18','2025-10-02 12:12:31','2025-10-02 12:12:31',1),(123,'2008c515-5405-4e2a-af36-731c08b54231','hw_machine_type','q35','2025-10-02 12:12:18','2025-10-02 12:12:31','2025-10-02 12:12:31',1),(124,'2008c515-5405-4e2a-af36-731c08b54231','hw_cdrom_bus','sata','2025-10-02 12:12:18','2025-10-02 12:12:31','2025-10-02 12:12:31',1),(125,'2008c515-5405-4e2a-af36-731c08b54231','hw_disk_bus','virtio','2025-10-02 12:12:18','2025-10-02 12:12:31','2025-10-02 12:12:31',1),(126,'2008c515-5405-4e2a-af36-731c08b54231','hw_input_bus','usb','2025-10-02 12:12:18','2025-10-02 12:12:31','2025-10-02 12:12:31',1),(127,'2008c515-5405-4e2a-af36-731c08b54231','hw_pointer_model','usbtablet','2025-10-02 12:12:18','2025-10-02 12:12:31','2025-10-02 12:12:31',1),(128,'2008c515-5405-4e2a-af36-731c08b54231','hw_video_model','virtio','2025-10-02 12:12:18','2025-10-02 12:12:31','2025-10-02 12:12:31',1),(129,'2008c515-5405-4e2a-af36-731c08b54231','hw_vif_model','virtio','2025-10-02 12:12:18','2025-10-02 12:12:31','2025-10-02 12:12:31',1),(130,'2008c515-5405-4e2a-af36-731c08b54231','old_vm_state','active','2025-10-02 12:12:18','2025-10-02 12:12:31','2025-10-02 12:12:31',1),(131,'2008c515-5405-4e2a-af36-731c08b54231','instance_uuid','130a4f54-6947-473f-bedd-5a3464805fb0','2025-10-02 12:12:18','2025-10-02 12:12:31','2025-10-02 12:12:31',1),(132,'2008c515-5405-4e2a-af36-731c08b54231','user_id','0df47040f1ff4ce69a6fbdfd9eba4955','2025-10-02 12:12:18','2025-10-02 12:12:31','2025-10-02 12:12:31',1),(133,'2008c515-5405-4e2a-af36-731c08b54231','image_type','snapshot','2025-10-02 12:12:18','2025-10-02 12:12:31','2025-10-02 12:12:31',1),(134,'2008c515-5405-4e2a-af36-731c08b54231','owner_id','55d20ae21b6d4f0abfff3bccc371ee7a','2025-10-02 12:12:26','2025-10-02 12:12:31','2025-10-02 12:12:31',1),(135,'2008c515-5405-4e2a-af36-731c08b54231','image_location','snapshot','2025-10-02 12:12:26','2025-10-02 12:12:31','2025-10-02 12:12:31',1),(136,'2008c515-5405-4e2a-af36-731c08b54231','image_state','available','2025-10-02 12:12:26','2025-10-02 12:12:31','2025-10-02 12:12:31',1),(137,'11a037e0-306c-4ca3-91ab-08e92bb1fae5','hw_rng_model','virtio','2025-10-02 12:12:54','2025-10-02 12:13:19','2025-10-02 12:13:19',1),(138,'11a037e0-306c-4ca3-91ab-08e92bb1fae5','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:12:54','2025-10-02 12:13:19','2025-10-02 12:13:19',1),(139,'11a037e0-306c-4ca3-91ab-08e92bb1fae5','owner_user_name','tempest-ImagesTestJSON-2116266493-project-member','2025-10-02 12:12:54','2025-10-02 12:13:19','2025-10-02 12:13:19',1),(140,'11a037e0-306c-4ca3-91ab-08e92bb1fae5','owner_project_name','tempest-ImagesTestJSON-2116266493','2025-10-02 12:12:54','2025-10-02 12:13:19','2025-10-02 12:13:19',1),(141,'11a037e0-306c-4ca3-91ab-08e92bb1fae5','boot_roles','member,reader','2025-10-02 12:12:54','2025-10-02 12:13:19','2025-10-02 12:13:19',1),(142,'11a037e0-306c-4ca3-91ab-08e92bb1fae5','hw_machine_type','q35','2025-10-02 12:12:54','2025-10-02 12:13:19','2025-10-02 12:13:19',1),(143,'11a037e0-306c-4ca3-91ab-08e92bb1fae5','hw_cdrom_bus','sata','2025-10-02 12:12:54','2025-10-02 12:13:19','2025-10-02 12:13:19',1),(144,'11a037e0-306c-4ca3-91ab-08e92bb1fae5','hw_disk_bus','virtio','2025-10-02 12:12:54','2025-10-02 12:13:19','2025-10-02 12:13:19',1),(145,'11a037e0-306c-4ca3-91ab-08e92bb1fae5','hw_input_bus','usb','2025-10-02 12:12:54','2025-10-02 12:13:19','2025-10-02 12:13:19',1),(146,'11a037e0-306c-4ca3-91ab-08e92bb1fae5','hw_pointer_model','usbtablet','2025-10-02 12:12:54','2025-10-02 12:13:19','2025-10-02 12:13:19',1),(147,'11a037e0-306c-4ca3-91ab-08e92bb1fae5','hw_video_model','virtio','2025-10-02 12:12:54','2025-10-02 12:13:19','2025-10-02 12:13:19',1),(148,'11a037e0-306c-4ca3-91ab-08e92bb1fae5','hw_vif_model','virtio','2025-10-02 12:12:54','2025-10-02 12:13:19','2025-10-02 12:13:19',1),(149,'11a037e0-306c-4ca3-91ab-08e92bb1fae5','instance_uuid','d8adf6f4-e7d3-4a21-87f7-4b2396126258','2025-10-02 12:12:54','2025-10-02 12:13:19','2025-10-02 12:13:19',1),(150,'11a037e0-306c-4ca3-91ab-08e92bb1fae5','user_id','0df47040f1ff4ce69a6fbdfd9eba4955','2025-10-02 12:12:54','2025-10-02 12:13:19','2025-10-02 12:13:19',1),(151,'11a037e0-306c-4ca3-91ab-08e92bb1fae5','image_type','snapshot','2025-10-02 12:12:54','2025-10-02 12:13:19','2025-10-02 12:13:19',1),(152,'11a037e0-306c-4ca3-91ab-08e92bb1fae5','owner_id','55d20ae21b6d4f0abfff3bccc371ee7a','2025-10-02 12:12:58','2025-10-02 12:13:19','2025-10-02 12:13:19',1),(153,'11a037e0-306c-4ca3-91ab-08e92bb1fae5','image_state','available','2025-10-02 12:12:58','2025-10-02 12:13:19','2025-10-02 12:13:19',1),(154,'11a037e0-306c-4ca3-91ab-08e92bb1fae5','image_location','snapshot','2025-10-02 12:12:58','2025-10-02 12:13:19','2025-10-02 12:13:19',1),(155,'37de6150-c476-48f0-b3f4-9bad2557dfc2','hw_rng_model','virtio','2025-10-02 12:13:35','2025-10-02 12:13:36','2025-10-02 12:13:36',1),(156,'37de6150-c476-48f0-b3f4-9bad2557dfc2','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:13:35','2025-10-02 12:13:36','2025-10-02 12:13:36',1),(157,'37de6150-c476-48f0-b3f4-9bad2557dfc2','owner_user_name','tempest-ImagesTestJSON-2116266493-project-member','2025-10-02 12:13:35','2025-10-02 12:13:36','2025-10-02 12:13:36',1),(158,'37de6150-c476-48f0-b3f4-9bad2557dfc2','owner_project_name','tempest-ImagesTestJSON-2116266493','2025-10-02 12:13:35','2025-10-02 12:13:36','2025-10-02 12:13:36',1),(159,'37de6150-c476-48f0-b3f4-9bad2557dfc2','boot_roles','member,reader','2025-10-02 12:13:35','2025-10-02 12:13:36','2025-10-02 12:13:36',1),(160,'37de6150-c476-48f0-b3f4-9bad2557dfc2','hw_machine_type','q35','2025-10-02 12:13:35','2025-10-02 12:13:36','2025-10-02 12:13:36',1),(161,'37de6150-c476-48f0-b3f4-9bad2557dfc2','hw_cdrom_bus','sata','2025-10-02 12:13:35','2025-10-02 12:13:36','2025-10-02 12:13:36',1),(162,'37de6150-c476-48f0-b3f4-9bad2557dfc2','hw_disk_bus','virtio','2025-10-02 12:13:35','2025-10-02 12:13:36','2025-10-02 12:13:36',1),(163,'37de6150-c476-48f0-b3f4-9bad2557dfc2','hw_input_bus','usb','2025-10-02 12:13:35','2025-10-02 12:13:36','2025-10-02 12:13:36',1),(164,'37de6150-c476-48f0-b3f4-9bad2557dfc2','hw_pointer_model','usbtablet','2025-10-02 12:13:35','2025-10-02 12:13:36','2025-10-02 12:13:36',1),(165,'37de6150-c476-48f0-b3f4-9bad2557dfc2','hw_video_model','virtio','2025-10-02 12:13:35','2025-10-02 12:13:36','2025-10-02 12:13:36',1),(166,'37de6150-c476-48f0-b3f4-9bad2557dfc2','hw_vif_model','virtio','2025-10-02 12:13:35','2025-10-02 12:13:36','2025-10-02 12:13:36',1),(167,'37de6150-c476-48f0-b3f4-9bad2557dfc2','instance_uuid','8af0743c-0b6a-4e74-a2c7-f8b4ccd83d09','2025-10-02 12:13:35','2025-10-02 12:13:36','2025-10-02 12:13:36',1),(168,'37de6150-c476-48f0-b3f4-9bad2557dfc2','user_id','0df47040f1ff4ce69a6fbdfd9eba4955','2025-10-02 12:13:35','2025-10-02 12:13:36','2025-10-02 12:13:36',1),(169,'37de6150-c476-48f0-b3f4-9bad2557dfc2','image_type','snapshot','2025-10-02 12:13:35','2025-10-02 12:13:36','2025-10-02 12:13:36',1),(170,'7f3fdab7-d2d5-41be-9174-42e3a9caee7b','hw_rng_model','virtio','2025-10-02 12:14:38','2025-10-02 12:14:39','2025-10-02 12:14:39',1),(171,'7f3fdab7-d2d5-41be-9174-42e3a9caee7b','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:14:38','2025-10-02 12:14:39','2025-10-02 12:14:39',1),(172,'7f3fdab7-d2d5-41be-9174-42e3a9caee7b','owner_user_name','tempest-ImagesOneServerNegativeTestJSON-1213912851-project-member','2025-10-02 12:14:38','2025-10-02 12:14:39','2025-10-02 12:14:39',1),(173,'7f3fdab7-d2d5-41be-9174-42e3a9caee7b','owner_project_name','tempest-ImagesOneServerNegativeTestJSON-1213912851','2025-10-02 12:14:38','2025-10-02 12:14:39','2025-10-02 12:14:39',1),(174,'7f3fdab7-d2d5-41be-9174-42e3a9caee7b','boot_roles','reader,member','2025-10-02 12:14:38','2025-10-02 12:14:39','2025-10-02 12:14:39',1),(175,'7f3fdab7-d2d5-41be-9174-42e3a9caee7b','hw_machine_type','q35','2025-10-02 12:14:38','2025-10-02 12:14:39','2025-10-02 12:14:39',1),(176,'7f3fdab7-d2d5-41be-9174-42e3a9caee7b','hw_cdrom_bus','sata','2025-10-02 12:14:38','2025-10-02 12:14:39','2025-10-02 12:14:39',1),(177,'7f3fdab7-d2d5-41be-9174-42e3a9caee7b','hw_disk_bus','virtio','2025-10-02 12:14:38','2025-10-02 12:14:39','2025-10-02 12:14:39',1),(178,'7f3fdab7-d2d5-41be-9174-42e3a9caee7b','hw_input_bus','usb','2025-10-02 12:14:38','2025-10-02 12:14:39','2025-10-02 12:14:39',1),(179,'7f3fdab7-d2d5-41be-9174-42e3a9caee7b','hw_pointer_model','usbtablet','2025-10-02 12:14:38','2025-10-02 12:14:39','2025-10-02 12:14:39',1),(180,'7f3fdab7-d2d5-41be-9174-42e3a9caee7b','hw_video_model','virtio','2025-10-02 12:14:38','2025-10-02 12:14:39','2025-10-02 12:14:39',1),(181,'7f3fdab7-d2d5-41be-9174-42e3a9caee7b','hw_vif_model','virtio','2025-10-02 12:14:38','2025-10-02 12:14:39','2025-10-02 12:14:39',1),(182,'7f3fdab7-d2d5-41be-9174-42e3a9caee7b','instance_uuid','dfaa589c-eb92-4e0f-b1ad-7b4004f0cb96','2025-10-02 12:14:38','2025-10-02 12:14:39','2025-10-02 12:14:39',1),(183,'7f3fdab7-d2d5-41be-9174-42e3a9caee7b','user_id','72c74994085d4fc697ddd4acddfa7a11','2025-10-02 12:14:38','2025-10-02 12:14:39','2025-10-02 12:14:39',1),(184,'7f3fdab7-d2d5-41be-9174-42e3a9caee7b','image_type','snapshot','2025-10-02 12:14:38','2025-10-02 12:14:39','2025-10-02 12:14:39',1),(185,'0b7cb45b-4756-4516-aac2-0c994d6cef99','hw_rng_model','virtio','2025-10-02 12:15:31','2025-10-02 12:15:32','2025-10-02 12:15:32',1),(186,'0b7cb45b-4756-4516-aac2-0c994d6cef99','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:15:31','2025-10-02 12:15:32','2025-10-02 12:15:32',1),(187,'0b7cb45b-4756-4516-aac2-0c994d6cef99','owner_user_name','tempest-ImagesOneServerNegativeTestJSON-1213912851-project-member','2025-10-02 12:15:31','2025-10-02 12:15:32','2025-10-02 12:15:32',1),(188,'0b7cb45b-4756-4516-aac2-0c994d6cef99','owner_project_name','tempest-ImagesOneServerNegativeTestJSON-1213912851','2025-10-02 12:15:31','2025-10-02 12:15:32','2025-10-02 12:15:32',1),(189,'0b7cb45b-4756-4516-aac2-0c994d6cef99','boot_roles','reader,member','2025-10-02 12:15:31','2025-10-02 12:15:32','2025-10-02 12:15:32',1),(190,'0b7cb45b-4756-4516-aac2-0c994d6cef99','hw_machine_type','q35','2025-10-02 12:15:31','2025-10-02 12:15:32','2025-10-02 12:15:32',1),(191,'0b7cb45b-4756-4516-aac2-0c994d6cef99','hw_cdrom_bus','sata','2025-10-02 12:15:31','2025-10-02 12:15:32','2025-10-02 12:15:32',1),(192,'0b7cb45b-4756-4516-aac2-0c994d6cef99','hw_disk_bus','virtio','2025-10-02 12:15:31','2025-10-02 12:15:32','2025-10-02 12:15:32',1),(193,'0b7cb45b-4756-4516-aac2-0c994d6cef99','hw_input_bus','usb','2025-10-02 12:15:31','2025-10-02 12:15:32','2025-10-02 12:15:32',1),(194,'0b7cb45b-4756-4516-aac2-0c994d6cef99','hw_pointer_model','usbtablet','2025-10-02 12:15:31','2025-10-02 12:15:32','2025-10-02 12:15:32',1),(195,'0b7cb45b-4756-4516-aac2-0c994d6cef99','hw_video_model','virtio','2025-10-02 12:15:31','2025-10-02 12:15:32','2025-10-02 12:15:32',1),(196,'0b7cb45b-4756-4516-aac2-0c994d6cef99','hw_vif_model','virtio','2025-10-02 12:15:31','2025-10-02 12:15:32','2025-10-02 12:15:32',1),(197,'0b7cb45b-4756-4516-aac2-0c994d6cef99','instance_uuid','c8781322-d594-4313-9032-0f1c3f66aad1','2025-10-02 12:15:31','2025-10-02 12:15:32','2025-10-02 12:15:32',1),(198,'0b7cb45b-4756-4516-aac2-0c994d6cef99','user_id','72c74994085d4fc697ddd4acddfa7a11','2025-10-02 12:15:31','2025-10-02 12:15:32','2025-10-02 12:15:32',1),(199,'0b7cb45b-4756-4516-aac2-0c994d6cef99','image_type','snapshot','2025-10-02 12:15:31','2025-10-02 12:15:32','2025-10-02 12:15:32',1),(200,'a79596af-3e62-4e36-b88e-7847340ca72b','hw_rng_model','virtio','2025-10-02 12:16:07','2025-10-02 12:16:08','2025-10-02 12:16:08',1),(201,'a79596af-3e62-4e36-b88e-7847340ca72b','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:16:07','2025-10-02 12:16:08','2025-10-02 12:16:08',1),(202,'a79596af-3e62-4e36-b88e-7847340ca72b','owner_user_name','tempest-ServersAaction247Test-1223521410-project-member','2025-10-02 12:16:07','2025-10-02 12:16:08','2025-10-02 12:16:08',1),(203,'a79596af-3e62-4e36-b88e-7847340ca72b','owner_project_name','tempest-ServersAaction247Test-1223521410','2025-10-02 12:16:07','2025-10-02 12:16:08','2025-10-02 12:16:08',1),(204,'a79596af-3e62-4e36-b88e-7847340ca72b','boot_roles','member,reader','2025-10-02 12:16:07','2025-10-02 12:16:08','2025-10-02 12:16:08',1),(205,'a79596af-3e62-4e36-b88e-7847340ca72b','hw_machine_type','q35','2025-10-02 12:16:07','2025-10-02 12:16:08','2025-10-02 12:16:08',1),(206,'a79596af-3e62-4e36-b88e-7847340ca72b','hw_cdrom_bus','sata','2025-10-02 12:16:07','2025-10-02 12:16:08','2025-10-02 12:16:08',1),(207,'a79596af-3e62-4e36-b88e-7847340ca72b','hw_disk_bus','virtio','2025-10-02 12:16:07','2025-10-02 12:16:08','2025-10-02 12:16:08',1),(208,'a79596af-3e62-4e36-b88e-7847340ca72b','hw_input_bus','usb','2025-10-02 12:16:07','2025-10-02 12:16:08','2025-10-02 12:16:08',1),(209,'a79596af-3e62-4e36-b88e-7847340ca72b','hw_pointer_model','usbtablet','2025-10-02 12:16:07','2025-10-02 12:16:08','2025-10-02 12:16:08',1),(210,'a79596af-3e62-4e36-b88e-7847340ca72b','hw_video_model','virtio','2025-10-02 12:16:07','2025-10-02 12:16:08','2025-10-02 12:16:08',1),(211,'a79596af-3e62-4e36-b88e-7847340ca72b','hw_vif_model','virtio','2025-10-02 12:16:07','2025-10-02 12:16:08','2025-10-02 12:16:08',1),(212,'a79596af-3e62-4e36-b88e-7847340ca72b','instance_uuid','5ce6ada0-03ae-4871-998a-8781162b5d4f','2025-10-02 12:16:07','2025-10-02 12:16:08','2025-10-02 12:16:08',1),(213,'a79596af-3e62-4e36-b88e-7847340ca72b','user_id','a77fa2684bba41bb93c60fc0f0279f5f','2025-10-02 12:16:07','2025-10-02 12:16:08','2025-10-02 12:16:08',1),(214,'a79596af-3e62-4e36-b88e-7847340ca72b','image_type','backup','2025-10-02 12:16:07','2025-10-02 12:16:08','2025-10-02 12:16:08',1),(215,'a79596af-3e62-4e36-b88e-7847340ca72b','backup_type','daily','2025-10-02 12:16:07','2025-10-02 12:16:08','2025-10-02 12:16:08',1),(216,'3242b862-74d4-4558-9399-2a866969329a','hw_rng_model','virtio','2025-10-02 12:16:40','2025-10-02 12:17:15','2025-10-02 12:17:15',1),(217,'3242b862-74d4-4558-9399-2a866969329a','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:16:40','2025-10-02 12:17:15','2025-10-02 12:17:15',1),(218,'3242b862-74d4-4558-9399-2a866969329a','owner_user_name','tempest-ListImageFiltersTestJSON-713501412-project-member','2025-10-02 12:16:40','2025-10-02 12:17:15','2025-10-02 12:17:15',1),(219,'3242b862-74d4-4558-9399-2a866969329a','owner_project_name','tempest-ListImageFiltersTestJSON-713501412','2025-10-02 12:16:40','2025-10-02 12:17:15','2025-10-02 12:17:15',1),(220,'3242b862-74d4-4558-9399-2a866969329a','boot_roles','member,reader','2025-10-02 12:16:40','2025-10-02 12:17:15','2025-10-02 12:17:15',1),(221,'3242b862-74d4-4558-9399-2a866969329a','hw_machine_type','q35','2025-10-02 12:16:40','2025-10-02 12:17:15','2025-10-02 12:17:15',1),(222,'3242b862-74d4-4558-9399-2a866969329a','hw_cdrom_bus','sata','2025-10-02 12:16:40','2025-10-02 12:17:15','2025-10-02 12:17:15',1),(223,'3242b862-74d4-4558-9399-2a866969329a','hw_disk_bus','virtio','2025-10-02 12:16:40','2025-10-02 12:17:15','2025-10-02 12:17:15',1),(224,'3242b862-74d4-4558-9399-2a866969329a','hw_input_bus','usb','2025-10-02 12:16:40','2025-10-02 12:17:15','2025-10-02 12:17:15',1),(225,'3242b862-74d4-4558-9399-2a866969329a','hw_pointer_model','usbtablet','2025-10-02 12:16:40','2025-10-02 12:17:15','2025-10-02 12:17:15',1),(226,'3242b862-74d4-4558-9399-2a866969329a','hw_video_model','virtio','2025-10-02 12:16:40','2025-10-02 12:17:15','2025-10-02 12:17:15',1),(227,'3242b862-74d4-4558-9399-2a866969329a','hw_vif_model','virtio','2025-10-02 12:16:40','2025-10-02 12:17:15','2025-10-02 12:17:15',1),(228,'3242b862-74d4-4558-9399-2a866969329a','instance_uuid','4ef4cd21-73d9-4ceb-8bd5-316a831e8e92','2025-10-02 12:16:40','2025-10-02 12:17:16','2025-10-02 12:17:16',1),(229,'3242b862-74d4-4558-9399-2a866969329a','user_id','03f516d263c8402682568b55b658f885','2025-10-02 12:16:40','2025-10-02 12:17:16','2025-10-02 12:17:16',1),(230,'3242b862-74d4-4558-9399-2a866969329a','image_type','snapshot','2025-10-02 12:16:40','2025-10-02 12:17:16','2025-10-02 12:17:16',1),(231,'3242b862-74d4-4558-9399-2a866969329a','image_location','snapshot','2025-10-02 12:16:47','2025-10-02 12:17:16','2025-10-02 12:17:16',1),(232,'3242b862-74d4-4558-9399-2a866969329a','image_state','available','2025-10-02 12:16:47','2025-10-02 12:17:16','2025-10-02 12:17:16',1),(233,'3242b862-74d4-4558-9399-2a866969329a','owner_id','1f9bd65bc7864ca18e1c478ef7e03926','2025-10-02 12:16:47','2025-10-02 12:17:16','2025-10-02 12:17:16',1),(234,'358aa82b-067b-458c-9095-e40a3a914f59','hw_rng_model','virtio','2025-10-02 12:16:50','2025-10-02 12:17:13','2025-10-02 12:17:13',1),(235,'358aa82b-067b-458c-9095-e40a3a914f59','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:16:50','2025-10-02 12:17:13','2025-10-02 12:17:13',1),(236,'358aa82b-067b-458c-9095-e40a3a914f59','owner_user_name','tempest-ListImageFiltersTestJSON-713501412-project-member','2025-10-02 12:16:50','2025-10-02 12:17:13','2025-10-02 12:17:13',1),(237,'358aa82b-067b-458c-9095-e40a3a914f59','owner_project_name','tempest-ListImageFiltersTestJSON-713501412','2025-10-02 12:16:50','2025-10-02 12:17:13','2025-10-02 12:17:13',1),(238,'358aa82b-067b-458c-9095-e40a3a914f59','boot_roles','member,reader','2025-10-02 12:16:50','2025-10-02 12:17:13','2025-10-02 12:17:13',1),(239,'358aa82b-067b-458c-9095-e40a3a914f59','hw_machine_type','q35','2025-10-02 12:16:50','2025-10-02 12:17:13','2025-10-02 12:17:13',1),(240,'358aa82b-067b-458c-9095-e40a3a914f59','hw_cdrom_bus','sata','2025-10-02 12:16:50','2025-10-02 12:17:13','2025-10-02 12:17:13',1),(241,'358aa82b-067b-458c-9095-e40a3a914f59','hw_disk_bus','virtio','2025-10-02 12:16:50','2025-10-02 12:17:13','2025-10-02 12:17:13',1),(242,'358aa82b-067b-458c-9095-e40a3a914f59','hw_input_bus','usb','2025-10-02 12:16:50','2025-10-02 12:17:13','2025-10-02 12:17:13',1),(243,'358aa82b-067b-458c-9095-e40a3a914f59','hw_pointer_model','usbtablet','2025-10-02 12:16:50','2025-10-02 12:17:13','2025-10-02 12:17:13',1),(244,'358aa82b-067b-458c-9095-e40a3a914f59','hw_video_model','virtio','2025-10-02 12:16:50','2025-10-02 12:17:13','2025-10-02 12:17:13',1),(245,'358aa82b-067b-458c-9095-e40a3a914f59','hw_vif_model','virtio','2025-10-02 12:16:50','2025-10-02 12:17:13','2025-10-02 12:17:13',1),(246,'358aa82b-067b-458c-9095-e40a3a914f59','instance_uuid','04b6ea5a-b329-4bd1-bf27-48a8644550c5','2025-10-02 12:16:50','2025-10-02 12:17:13','2025-10-02 12:17:13',1),(247,'358aa82b-067b-458c-9095-e40a3a914f59','user_id','03f516d263c8402682568b55b658f885','2025-10-02 12:16:50','2025-10-02 12:17:13','2025-10-02 12:17:13',1),(248,'358aa82b-067b-458c-9095-e40a3a914f59','image_type','snapshot','2025-10-02 12:16:50','2025-10-02 12:17:13','2025-10-02 12:17:13',1),(249,'358aa82b-067b-458c-9095-e40a3a914f59','owner_id','1f9bd65bc7864ca18e1c478ef7e03926','2025-10-02 12:16:54','2025-10-02 12:17:13','2025-10-02 12:17:13',1),(250,'358aa82b-067b-458c-9095-e40a3a914f59','image_location','snapshot','2025-10-02 12:16:54','2025-10-02 12:17:13','2025-10-02 12:17:13',1),(251,'358aa82b-067b-458c-9095-e40a3a914f59','image_state','available','2025-10-02 12:16:54','2025-10-02 12:17:13','2025-10-02 12:17:13',1),(252,'fdf855eb-5dbd-44e1-9b72-cac174cddd41','hw_rng_model','virtio','2025-10-02 12:16:57','2025-10-02 12:17:12','2025-10-02 12:17:12',1),(253,'fdf855eb-5dbd-44e1-9b72-cac174cddd41','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:16:57','2025-10-02 12:17:12','2025-10-02 12:17:12',1),(254,'fdf855eb-5dbd-44e1-9b72-cac174cddd41','owner_user_name','tempest-ListImageFiltersTestJSON-713501412-project-member','2025-10-02 12:16:57','2025-10-02 12:17:12','2025-10-02 12:17:12',1),(255,'fdf855eb-5dbd-44e1-9b72-cac174cddd41','owner_project_name','tempest-ListImageFiltersTestJSON-713501412','2025-10-02 12:16:57','2025-10-02 12:17:12','2025-10-02 12:17:12',1),(256,'fdf855eb-5dbd-44e1-9b72-cac174cddd41','boot_roles','member,reader','2025-10-02 12:16:57','2025-10-02 12:17:12','2025-10-02 12:17:12',1),(257,'fdf855eb-5dbd-44e1-9b72-cac174cddd41','hw_machine_type','q35','2025-10-02 12:16:57','2025-10-02 12:17:12','2025-10-02 12:17:12',1),(258,'fdf855eb-5dbd-44e1-9b72-cac174cddd41','hw_cdrom_bus','sata','2025-10-02 12:16:57','2025-10-02 12:17:12','2025-10-02 12:17:12',1),(259,'fdf855eb-5dbd-44e1-9b72-cac174cddd41','hw_disk_bus','virtio','2025-10-02 12:16:57','2025-10-02 12:17:12','2025-10-02 12:17:12',1),(260,'fdf855eb-5dbd-44e1-9b72-cac174cddd41','hw_input_bus','usb','2025-10-02 12:16:57','2025-10-02 12:17:12','2025-10-02 12:17:12',1),(261,'fdf855eb-5dbd-44e1-9b72-cac174cddd41','hw_pointer_model','usbtablet','2025-10-02 12:16:57','2025-10-02 12:17:12','2025-10-02 12:17:12',1),(262,'fdf855eb-5dbd-44e1-9b72-cac174cddd41','hw_video_model','virtio','2025-10-02 12:16:57','2025-10-02 12:17:12','2025-10-02 12:17:12',1),(263,'fdf855eb-5dbd-44e1-9b72-cac174cddd41','hw_vif_model','virtio','2025-10-02 12:16:57','2025-10-02 12:17:12','2025-10-02 12:17:12',1),(264,'fdf855eb-5dbd-44e1-9b72-cac174cddd41','instance_uuid','4ef4cd21-73d9-4ceb-8bd5-316a831e8e92','2025-10-02 12:16:57','2025-10-02 12:17:12','2025-10-02 12:17:12',1),(265,'fdf855eb-5dbd-44e1-9b72-cac174cddd41','user_id','03f516d263c8402682568b55b658f885','2025-10-02 12:16:57','2025-10-02 12:17:12','2025-10-02 12:17:12',1),(266,'fdf855eb-5dbd-44e1-9b72-cac174cddd41','image_type','snapshot','2025-10-02 12:16:57','2025-10-02 12:17:12','2025-10-02 12:17:12',1),(267,'e7ad18e6-654f-48ae-a957-a50e1a2c7a2d','hw_rng_model','virtio','2025-10-02 12:17:01','2025-10-02 12:20:34','2025-10-02 12:20:34',1),(268,'e7ad18e6-654f-48ae-a957-a50e1a2c7a2d','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:17:01','2025-10-02 12:20:34','2025-10-02 12:20:34',1),(269,'e7ad18e6-654f-48ae-a957-a50e1a2c7a2d','owner_user_name','tempest-ServerBootFromVolumeStableRescueTest-153154373-project-member','2025-10-02 12:17:01','2025-10-02 12:20:34','2025-10-02 12:20:34',1),(270,'e7ad18e6-654f-48ae-a957-a50e1a2c7a2d','owner_project_name','tempest-ServerBootFromVolumeStableRescueTest-153154373','2025-10-02 12:17:01','2025-10-02 12:20:34','2025-10-02 12:20:34',1),(271,'e7ad18e6-654f-48ae-a957-a50e1a2c7a2d','boot_roles','reader,member','2025-10-02 12:17:01','2025-10-02 12:20:34','2025-10-02 12:20:34',1),(272,'e7ad18e6-654f-48ae-a957-a50e1a2c7a2d','hw_machine_type','q35','2025-10-02 12:17:01','2025-10-02 12:20:34','2025-10-02 12:20:34',1),(273,'e7ad18e6-654f-48ae-a957-a50e1a2c7a2d','hw_cdrom_bus','sata','2025-10-02 12:17:01','2025-10-02 12:20:34','2025-10-02 12:20:34',1),(274,'e7ad18e6-654f-48ae-a957-a50e1a2c7a2d','hw_disk_bus','virtio','2025-10-02 12:17:01','2025-10-02 12:20:34','2025-10-02 12:20:34',1),(275,'e7ad18e6-654f-48ae-a957-a50e1a2c7a2d','hw_input_bus','usb','2025-10-02 12:17:01','2025-10-02 12:20:34','2025-10-02 12:20:34',1),(276,'e7ad18e6-654f-48ae-a957-a50e1a2c7a2d','hw_pointer_model','usbtablet','2025-10-02 12:17:01','2025-10-02 12:20:34','2025-10-02 12:20:34',1),(277,'e7ad18e6-654f-48ae-a957-a50e1a2c7a2d','hw_video_model','virtio','2025-10-02 12:17:01','2025-10-02 12:20:34','2025-10-02 12:20:34',1),(278,'e7ad18e6-654f-48ae-a957-a50e1a2c7a2d','hw_vif_model','virtio','2025-10-02 12:17:01','2025-10-02 12:20:34','2025-10-02 12:20:34',1),(279,'e7ad18e6-654f-48ae-a957-a50e1a2c7a2d','instance_uuid','bc4239f5-3cf2-4325-803c-73121f7e0ee0','2025-10-02 12:17:01','2025-10-02 12:20:34','2025-10-02 12:20:34',1),(280,'e7ad18e6-654f-48ae-a957-a50e1a2c7a2d','user_id','69d8e29c6d3747e98a5985a584f4c814','2025-10-02 12:17:01','2025-10-02 12:20:34','2025-10-02 12:20:34',1),(281,'e7ad18e6-654f-48ae-a957-a50e1a2c7a2d','image_type','snapshot','2025-10-02 12:17:01','2025-10-02 12:20:34','2025-10-02 12:20:34',1),(282,'fdf855eb-5dbd-44e1-9b72-cac174cddd41','image_location','snapshot','2025-10-02 12:17:01','2025-10-02 12:17:12','2025-10-02 12:17:12',1),(283,'fdf855eb-5dbd-44e1-9b72-cac174cddd41','image_state','available','2025-10-02 12:17:01','2025-10-02 12:17:12','2025-10-02 12:17:12',1),(284,'fdf855eb-5dbd-44e1-9b72-cac174cddd41','owner_id','1f9bd65bc7864ca18e1c478ef7e03926','2025-10-02 12:17:01','2025-10-02 12:17:12','2025-10-02 12:17:12',1),(285,'e7ad18e6-654f-48ae-a957-a50e1a2c7a2d','owner_id','8efba404696b40fbbaa6431b934b87f1','2025-10-02 12:17:07','2025-10-02 12:20:34','2025-10-02 12:20:34',1),(286,'e7ad18e6-654f-48ae-a957-a50e1a2c7a2d','image_state','available','2025-10-02 12:17:07','2025-10-02 12:20:34','2025-10-02 12:20:34',1),(287,'e7ad18e6-654f-48ae-a957-a50e1a2c7a2d','image_location','snapshot','2025-10-02 12:17:07','2025-10-02 12:20:34','2025-10-02 12:20:34',1),(288,'e7ad18e6-654f-48ae-a957-a50e1a2c7a2d','hw_rescue_bus','virtio','2025-10-02 12:17:24','2025-10-02 12:20:34','2025-10-02 12:20:34',1),(289,'e7ad18e6-654f-48ae-a957-a50e1a2c7a2d','hw_rescue_device','disk','2025-10-02 12:17:24','2025-10-02 12:20:34','2025-10-02 12:20:34',1),(290,'8aa41919-15c5-43d9-ac12-d18997b6c8f0','hw_rng_model','virtio','2025-10-02 12:19:04','2025-10-02 12:20:25','2025-10-02 12:20:25',1),(291,'8aa41919-15c5-43d9-ac12-d18997b6c8f0','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:19:04','2025-10-02 12:20:25','2025-10-02 12:20:25',1),(292,'8aa41919-15c5-43d9-ac12-d18997b6c8f0','owner_user_name','tempest-ServerBootFromVolumeStableRescueTest-153154373-project-member','2025-10-02 12:19:04','2025-10-02 12:20:25','2025-10-02 12:20:25',1),(293,'8aa41919-15c5-43d9-ac12-d18997b6c8f0','owner_project_name','tempest-ServerBootFromVolumeStableRescueTest-153154373','2025-10-02 12:19:04','2025-10-02 12:20:25','2025-10-02 12:20:25',1),(294,'8aa41919-15c5-43d9-ac12-d18997b6c8f0','boot_roles','member,reader','2025-10-02 12:19:04','2025-10-02 12:20:25','2025-10-02 12:20:25',1),(295,'8aa41919-15c5-43d9-ac12-d18997b6c8f0','hw_machine_type','q35','2025-10-02 12:19:04','2025-10-02 12:20:25','2025-10-02 12:20:25',1),(296,'8aa41919-15c5-43d9-ac12-d18997b6c8f0','hw_cdrom_bus','sata','2025-10-02 12:19:04','2025-10-02 12:20:25','2025-10-02 12:20:25',1),(297,'8aa41919-15c5-43d9-ac12-d18997b6c8f0','hw_disk_bus','virtio','2025-10-02 12:19:04','2025-10-02 12:20:25','2025-10-02 12:20:25',1),(298,'8aa41919-15c5-43d9-ac12-d18997b6c8f0','hw_input_bus','usb','2025-10-02 12:19:04','2025-10-02 12:20:25','2025-10-02 12:20:25',1),(299,'8aa41919-15c5-43d9-ac12-d18997b6c8f0','hw_pointer_model','usbtablet','2025-10-02 12:19:04','2025-10-02 12:20:25','2025-10-02 12:20:25',1),(300,'8aa41919-15c5-43d9-ac12-d18997b6c8f0','hw_video_model','virtio','2025-10-02 12:19:04','2025-10-02 12:20:25','2025-10-02 12:20:25',1),(301,'8aa41919-15c5-43d9-ac12-d18997b6c8f0','hw_vif_model','virtio','2025-10-02 12:19:04','2025-10-02 12:20:25','2025-10-02 12:20:25',1),(302,'8aa41919-15c5-43d9-ac12-d18997b6c8f0','instance_uuid','e116d367-5ae9-4ce2-9d33-3936fd3de658','2025-10-02 12:19:04','2025-10-02 12:20:25','2025-10-02 12:20:25',1),(303,'8aa41919-15c5-43d9-ac12-d18997b6c8f0','user_id','69d8e29c6d3747e98a5985a584f4c814','2025-10-02 12:19:04','2025-10-02 12:20:25','2025-10-02 12:20:25',1),(304,'8aa41919-15c5-43d9-ac12-d18997b6c8f0','image_type','snapshot','2025-10-02 12:19:04','2025-10-02 12:20:25','2025-10-02 12:20:25',1),(305,'8aa41919-15c5-43d9-ac12-d18997b6c8f0','owner_id','8efba404696b40fbbaa6431b934b87f1','2025-10-02 12:19:08','2025-10-02 12:20:25','2025-10-02 12:20:25',1),(306,'8aa41919-15c5-43d9-ac12-d18997b6c8f0','image_state','available','2025-10-02 12:19:08','2025-10-02 12:20:25','2025-10-02 12:20:25',1),(307,'8aa41919-15c5-43d9-ac12-d18997b6c8f0','image_location','snapshot','2025-10-02 12:19:08','2025-10-02 12:20:25','2025-10-02 12:20:25',1),(308,'8aa41919-15c5-43d9-ac12-d18997b6c8f0','hw_rescue_bus','virtio','2025-10-02 12:19:49','2025-10-02 12:20:25','2025-10-02 12:20:25',1),(309,'8aa41919-15c5-43d9-ac12-d18997b6c8f0','hw_rescue_device','disk','2025-10-02 12:19:49','2025-10-02 12:20:25','2025-10-02 12:20:25',1),(310,'6adae2f0-2d5d-4fab-88e2-2a0e5685e8f9','hw_rng_model','virtio','2025-10-02 12:20:36','2025-10-02 12:20:59','2025-10-02 12:20:59',1),(311,'6adae2f0-2d5d-4fab-88e2-2a0e5685e8f9','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:20:36','2025-10-02 12:20:59','2025-10-02 12:20:59',1),(312,'6adae2f0-2d5d-4fab-88e2-2a0e5685e8f9','owner_user_name','tempest-ServerActionsTestOtherB-1686489955-project-member','2025-10-02 12:20:36','2025-10-02 12:20:59','2025-10-02 12:20:59',1),(313,'6adae2f0-2d5d-4fab-88e2-2a0e5685e8f9','owner_project_name','tempest-ServerActionsTestOtherB-1686489955','2025-10-02 12:20:36','2025-10-02 12:20:59','2025-10-02 12:20:59',1),(314,'6adae2f0-2d5d-4fab-88e2-2a0e5685e8f9','boot_roles','member,reader','2025-10-02 12:20:36','2025-10-02 12:20:59','2025-10-02 12:20:59',1),(315,'6adae2f0-2d5d-4fab-88e2-2a0e5685e8f9','hw_machine_type','q35','2025-10-02 12:20:36','2025-10-02 12:20:59','2025-10-02 12:20:59',1),(316,'6adae2f0-2d5d-4fab-88e2-2a0e5685e8f9','hw_cdrom_bus','sata','2025-10-02 12:20:36','2025-10-02 12:20:59','2025-10-02 12:20:59',1),(317,'6adae2f0-2d5d-4fab-88e2-2a0e5685e8f9','hw_disk_bus','virtio','2025-10-02 12:20:36','2025-10-02 12:20:59','2025-10-02 12:20:59',1),(318,'6adae2f0-2d5d-4fab-88e2-2a0e5685e8f9','hw_input_bus','usb','2025-10-02 12:20:36','2025-10-02 12:20:59','2025-10-02 12:20:59',1),(319,'6adae2f0-2d5d-4fab-88e2-2a0e5685e8f9','hw_pointer_model','usbtablet','2025-10-02 12:20:36','2025-10-02 12:20:59','2025-10-02 12:20:59',1),(320,'6adae2f0-2d5d-4fab-88e2-2a0e5685e8f9','hw_video_model','virtio','2025-10-02 12:20:36','2025-10-02 12:20:59','2025-10-02 12:20:59',1),(321,'6adae2f0-2d5d-4fab-88e2-2a0e5685e8f9','hw_vif_model','virtio','2025-10-02 12:20:36','2025-10-02 12:20:59','2025-10-02 12:20:59',1),(322,'6adae2f0-2d5d-4fab-88e2-2a0e5685e8f9','instance_uuid','ef69bc17-6b51-491e-82e9-c4106abb8d74','2025-10-02 12:20:36','2025-10-02 12:20:59','2025-10-02 12:20:59',1),(323,'6adae2f0-2d5d-4fab-88e2-2a0e5685e8f9','user_id','25468893d71641a385711fd2982bb00b','2025-10-02 12:20:36','2025-10-02 12:20:59','2025-10-02 12:20:59',1),(324,'6adae2f0-2d5d-4fab-88e2-2a0e5685e8f9','image_type','backup','2025-10-02 12:20:36','2025-10-02 12:20:59','2025-10-02 12:20:59',1),(325,'6adae2f0-2d5d-4fab-88e2-2a0e5685e8f9','backup_type','daily','2025-10-02 12:20:36','2025-10-02 12:20:59','2025-10-02 12:20:59',1),(326,'6adae2f0-2d5d-4fab-88e2-2a0e5685e8f9','owner_id','10fff81da7a54740a53a0771ce916329','2025-10-02 12:20:40','2025-10-02 12:20:59','2025-10-02 12:20:59',1),(327,'6adae2f0-2d5d-4fab-88e2-2a0e5685e8f9','image_location','snapshot','2025-10-02 12:20:40','2025-10-02 12:20:59','2025-10-02 12:20:59',1),(328,'6adae2f0-2d5d-4fab-88e2-2a0e5685e8f9','image_state','available','2025-10-02 12:20:40','2025-10-02 12:20:59','2025-10-02 12:20:59',1),(329,'2410127a-756e-4057-a962-4fe35566fc7f','hw_rng_model','virtio','2025-10-02 12:20:43','2025-10-02 12:21:04','2025-10-02 12:21:04',1),(330,'2410127a-756e-4057-a962-4fe35566fc7f','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:20:43','2025-10-02 12:21:04','2025-10-02 12:21:04',1),(331,'2410127a-756e-4057-a962-4fe35566fc7f','owner_user_name','tempest-ServerActionsTestOtherB-1686489955-project-member','2025-10-02 12:20:43','2025-10-02 12:21:04','2025-10-02 12:21:04',1),(332,'2410127a-756e-4057-a962-4fe35566fc7f','owner_project_name','tempest-ServerActionsTestOtherB-1686489955','2025-10-02 12:20:43','2025-10-02 12:21:04','2025-10-02 12:21:04',1),(333,'2410127a-756e-4057-a962-4fe35566fc7f','boot_roles','member,reader','2025-10-02 12:20:43','2025-10-02 12:21:04','2025-10-02 12:21:04',1),(334,'2410127a-756e-4057-a962-4fe35566fc7f','hw_machine_type','q35','2025-10-02 12:20:43','2025-10-02 12:21:04','2025-10-02 12:21:04',1),(335,'2410127a-756e-4057-a962-4fe35566fc7f','hw_cdrom_bus','sata','2025-10-02 12:20:43','2025-10-02 12:21:04','2025-10-02 12:21:04',1),(336,'2410127a-756e-4057-a962-4fe35566fc7f','hw_disk_bus','virtio','2025-10-02 12:20:43','2025-10-02 12:21:04','2025-10-02 12:21:04',1),(337,'2410127a-756e-4057-a962-4fe35566fc7f','hw_input_bus','usb','2025-10-02 12:20:43','2025-10-02 12:21:04','2025-10-02 12:21:04',1),(338,'2410127a-756e-4057-a962-4fe35566fc7f','hw_pointer_model','usbtablet','2025-10-02 12:20:43','2025-10-02 12:21:04','2025-10-02 12:21:04',1),(339,'2410127a-756e-4057-a962-4fe35566fc7f','hw_video_model','virtio','2025-10-02 12:20:43','2025-10-02 12:21:04','2025-10-02 12:21:04',1),(340,'2410127a-756e-4057-a962-4fe35566fc7f','hw_vif_model','virtio','2025-10-02 12:20:43','2025-10-02 12:21:04','2025-10-02 12:21:04',1),(341,'2410127a-756e-4057-a962-4fe35566fc7f','instance_uuid','ef69bc17-6b51-491e-82e9-c4106abb8d74','2025-10-02 12:20:43','2025-10-02 12:21:04','2025-10-02 12:21:04',1),(342,'2410127a-756e-4057-a962-4fe35566fc7f','user_id','25468893d71641a385711fd2982bb00b','2025-10-02 12:20:43','2025-10-02 12:21:04','2025-10-02 12:21:04',1),(343,'2410127a-756e-4057-a962-4fe35566fc7f','image_type','backup','2025-10-02 12:20:43','2025-10-02 12:21:04','2025-10-02 12:21:04',1),(344,'2410127a-756e-4057-a962-4fe35566fc7f','backup_type','daily','2025-10-02 12:20:43','2025-10-02 12:21:04','2025-10-02 12:21:04',1),(345,'2410127a-756e-4057-a962-4fe35566fc7f','owner_id','10fff81da7a54740a53a0771ce916329','2025-10-02 12:20:48','2025-10-02 12:21:04','2025-10-02 12:21:04',1),(346,'2410127a-756e-4057-a962-4fe35566fc7f','image_location','snapshot','2025-10-02 12:20:48','2025-10-02 12:21:04','2025-10-02 12:21:04',1),(347,'2410127a-756e-4057-a962-4fe35566fc7f','image_state','available','2025-10-02 12:20:48','2025-10-02 12:21:04','2025-10-02 12:21:04',1),(348,'4b2241f1-ae4c-491b-8811-8c9dd1f13160','hw_rng_model','virtio','2025-10-02 12:20:50','2025-10-02 12:21:03','2025-10-02 12:21:03',1),(349,'4b2241f1-ae4c-491b-8811-8c9dd1f13160','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:20:50','2025-10-02 12:21:03','2025-10-02 12:21:03',1),(350,'4b2241f1-ae4c-491b-8811-8c9dd1f13160','owner_user_name','tempest-ServerActionsTestOtherB-1686489955-project-member','2025-10-02 12:20:50','2025-10-02 12:21:03','2025-10-02 12:21:03',1),(351,'4b2241f1-ae4c-491b-8811-8c9dd1f13160','owner_project_name','tempest-ServerActionsTestOtherB-1686489955','2025-10-02 12:20:50','2025-10-02 12:21:03','2025-10-02 12:21:03',1),(352,'4b2241f1-ae4c-491b-8811-8c9dd1f13160','boot_roles','member,reader','2025-10-02 12:20:50','2025-10-02 12:21:03','2025-10-02 12:21:03',1),(353,'4b2241f1-ae4c-491b-8811-8c9dd1f13160','hw_machine_type','q35','2025-10-02 12:20:50','2025-10-02 12:21:03','2025-10-02 12:21:03',1),(354,'4b2241f1-ae4c-491b-8811-8c9dd1f13160','hw_cdrom_bus','sata','2025-10-02 12:20:50','2025-10-02 12:21:03','2025-10-02 12:21:03',1),(355,'4b2241f1-ae4c-491b-8811-8c9dd1f13160','hw_disk_bus','virtio','2025-10-02 12:20:50','2025-10-02 12:21:03','2025-10-02 12:21:03',1),(356,'4b2241f1-ae4c-491b-8811-8c9dd1f13160','hw_input_bus','usb','2025-10-02 12:20:50','2025-10-02 12:21:03','2025-10-02 12:21:03',1),(357,'4b2241f1-ae4c-491b-8811-8c9dd1f13160','hw_pointer_model','usbtablet','2025-10-02 12:20:50','2025-10-02 12:21:03','2025-10-02 12:21:03',1),(358,'4b2241f1-ae4c-491b-8811-8c9dd1f13160','hw_video_model','virtio','2025-10-02 12:20:50','2025-10-02 12:21:03','2025-10-02 12:21:03',1),(359,'4b2241f1-ae4c-491b-8811-8c9dd1f13160','hw_vif_model','virtio','2025-10-02 12:20:50','2025-10-02 12:21:03','2025-10-02 12:21:03',1),(360,'4b2241f1-ae4c-491b-8811-8c9dd1f13160','instance_uuid','ef69bc17-6b51-491e-82e9-c4106abb8d74','2025-10-02 12:20:50','2025-10-02 12:21:03','2025-10-02 12:21:03',1),(361,'4b2241f1-ae4c-491b-8811-8c9dd1f13160','user_id','25468893d71641a385711fd2982bb00b','2025-10-02 12:20:50','2025-10-02 12:21:03','2025-10-02 12:21:03',1),(362,'4b2241f1-ae4c-491b-8811-8c9dd1f13160','image_type','backup','2025-10-02 12:20:50','2025-10-02 12:21:03','2025-10-02 12:21:03',1),(363,'4b2241f1-ae4c-491b-8811-8c9dd1f13160','backup_type','daily','2025-10-02 12:20:50','2025-10-02 12:21:03','2025-10-02 12:21:03',1),(364,'4b2241f1-ae4c-491b-8811-8c9dd1f13160','owner_id','10fff81da7a54740a53a0771ce916329','2025-10-02 12:20:55','2025-10-02 12:21:03','2025-10-02 12:21:03',1),(365,'4b2241f1-ae4c-491b-8811-8c9dd1f13160','image_location','snapshot','2025-10-02 12:20:55','2025-10-02 12:21:03','2025-10-02 12:21:03',1),(366,'4b2241f1-ae4c-491b-8811-8c9dd1f13160','image_state','available','2025-10-02 12:20:55','2025-10-02 12:21:03','2025-10-02 12:21:03',1),(367,'7aeb8031-5492-47ae-a269-5cc3e1a66a2a','hw_rng_model','virtio','2025-10-02 12:21:26','2025-10-02 12:22:00','2025-10-02 12:22:00',1),(368,'7aeb8031-5492-47ae-a269-5cc3e1a66a2a','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:21:26','2025-10-02 12:22:00','2025-10-02 12:22:00',1),(369,'7aeb8031-5492-47ae-a269-5cc3e1a66a2a','owner_user_name','tempest-DeleteServersTestJSON-1602490521-project-member','2025-10-02 12:21:26','2025-10-02 12:22:00','2025-10-02 12:22:00',1),(370,'7aeb8031-5492-47ae-a269-5cc3e1a66a2a','owner_project_name','tempest-DeleteServersTestJSON-1602490521','2025-10-02 12:21:26','2025-10-02 12:22:00','2025-10-02 12:22:00',1),(371,'7aeb8031-5492-47ae-a269-5cc3e1a66a2a','boot_roles','member,reader','2025-10-02 12:21:26','2025-10-02 12:22:00','2025-10-02 12:22:00',1),(372,'7aeb8031-5492-47ae-a269-5cc3e1a66a2a','hw_machine_type','q35','2025-10-02 12:21:26','2025-10-02 12:22:00','2025-10-02 12:22:00',1),(373,'7aeb8031-5492-47ae-a269-5cc3e1a66a2a','hw_cdrom_bus','sata','2025-10-02 12:21:26','2025-10-02 12:22:00','2025-10-02 12:22:00',1),(374,'7aeb8031-5492-47ae-a269-5cc3e1a66a2a','hw_disk_bus','virtio','2025-10-02 12:21:26','2025-10-02 12:22:00','2025-10-02 12:22:00',1),(375,'7aeb8031-5492-47ae-a269-5cc3e1a66a2a','hw_input_bus','usb','2025-10-02 12:21:26','2025-10-02 12:22:00','2025-10-02 12:22:00',1),(376,'7aeb8031-5492-47ae-a269-5cc3e1a66a2a','hw_pointer_model','usbtablet','2025-10-02 12:21:26','2025-10-02 12:22:00','2025-10-02 12:22:00',1),(377,'7aeb8031-5492-47ae-a269-5cc3e1a66a2a','hw_video_model','virtio','2025-10-02 12:21:26','2025-10-02 12:22:00','2025-10-02 12:22:00',1),(378,'7aeb8031-5492-47ae-a269-5cc3e1a66a2a','hw_vif_model','virtio','2025-10-02 12:21:26','2025-10-02 12:22:00','2025-10-02 12:22:00',1),(379,'7aeb8031-5492-47ae-a269-5cc3e1a66a2a','instance_uuid','9c7a04c1-a740-4d58-bb92-b34f14ccff42','2025-10-02 12:21:26','2025-10-02 12:22:00','2025-10-02 12:22:00',1),(380,'7aeb8031-5492-47ae-a269-5cc3e1a66a2a','user_id','a9f7faffac7240869a0196df1ddda7e5','2025-10-02 12:21:26','2025-10-02 12:22:00','2025-10-02 12:22:00',1),(381,'7aeb8031-5492-47ae-a269-5cc3e1a66a2a','image_type','snapshot','2025-10-02 12:21:26','2025-10-02 12:22:00','2025-10-02 12:22:00',1),(382,'7aeb8031-5492-47ae-a269-5cc3e1a66a2a','owner_id','1c2c11ebecb14f3188f35ea473c4ca02','2025-10-02 12:21:47','2025-10-02 12:22:00','2025-10-02 12:22:00',1),(383,'7aeb8031-5492-47ae-a269-5cc3e1a66a2a','image_state','available','2025-10-02 12:21:47','2025-10-02 12:22:00','2025-10-02 12:22:00',1),(384,'7aeb8031-5492-47ae-a269-5cc3e1a66a2a','image_location','snapshot','2025-10-02 12:21:47','2025-10-02 12:22:00','2025-10-02 12:22:00',1),(385,'69218608-9c78-4f65-a885-9cb0c1edca97','hw_rng_model','virtio','2025-10-02 12:23:31','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(386,'69218608-9c78-4f65-a885-9cb0c1edca97','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:23:31','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(387,'69218608-9c78-4f65-a885-9cb0c1edca97','owner_user_name','tempest-ServersNegativeTestJSON-462972452-project-member','2025-10-02 12:23:31','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(388,'69218608-9c78-4f65-a885-9cb0c1edca97','owner_project_name','tempest-ServersNegativeTestJSON-462972452','2025-10-02 12:23:31','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(389,'69218608-9c78-4f65-a885-9cb0c1edca97','boot_roles','member,reader','2025-10-02 12:23:31','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(390,'69218608-9c78-4f65-a885-9cb0c1edca97','hw_machine_type','q35','2025-10-02 12:23:31','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(391,'69218608-9c78-4f65-a885-9cb0c1edca97','hw_cdrom_bus','sata','2025-10-02 12:23:31','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(392,'69218608-9c78-4f65-a885-9cb0c1edca97','hw_disk_bus','virtio','2025-10-02 12:23:31','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(393,'69218608-9c78-4f65-a885-9cb0c1edca97','hw_input_bus','usb','2025-10-02 12:23:31','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(394,'69218608-9c78-4f65-a885-9cb0c1edca97','hw_pointer_model','usbtablet','2025-10-02 12:23:31','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(395,'69218608-9c78-4f65-a885-9cb0c1edca97','hw_video_model','virtio','2025-10-02 12:23:31','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(396,'69218608-9c78-4f65-a885-9cb0c1edca97','hw_vif_model','virtio','2025-10-02 12:23:31','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(397,'69218608-9c78-4f65-a885-9cb0c1edca97','instance_uuid','3a4d32fc-bed8-4e11-9033-5b73501128fe','2025-10-02 12:23:31','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(398,'69218608-9c78-4f65-a885-9cb0c1edca97','user_id','4146a31af09c4e6a8aee251f2fec4f98','2025-10-02 12:23:31','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(399,'69218608-9c78-4f65-a885-9cb0c1edca97','image_type','snapshot','2025-10-02 12:23:31','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(400,'69218608-9c78-4f65-a885-9cb0c1edca97','owner_id','c740a14d1c5c45d1a0959b0e24ac460b','2025-10-02 12:23:39','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(401,'69218608-9c78-4f65-a885-9cb0c1edca97','image_state','available','2025-10-02 12:23:39','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(402,'69218608-9c78-4f65-a885-9cb0c1edca97','image_location','snapshot','2025-10-02 12:23:39','2025-10-02 12:24:03','2025-10-02 12:24:03',1),(403,'cf521338-6de6-477f-b445-df9c97d57576','hw_rng_model','virtio','2025-10-02 12:24:57','2025-10-02 12:26:17','2025-10-02 12:26:17',1),(404,'cf521338-6de6-477f-b445-df9c97d57576','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:24:57','2025-10-02 12:26:17','2025-10-02 12:26:17',1),(405,'cf521338-6de6-477f-b445-df9c97d57576','owner_user_name','tempest-ServerActionsTestOtherB-1686489955-project-member','2025-10-02 12:24:57','2025-10-02 12:26:17','2025-10-02 12:26:17',1),(406,'cf521338-6de6-477f-b445-df9c97d57576','owner_project_name','tempest-ServerActionsTestOtherB-1686489955','2025-10-02 12:24:57','2025-10-02 12:26:17','2025-10-02 12:26:17',1),(407,'cf521338-6de6-477f-b445-df9c97d57576','boot_roles','member,reader','2025-10-02 12:24:57','2025-10-02 12:26:17','2025-10-02 12:26:17',1),(408,'cf521338-6de6-477f-b445-df9c97d57576','hw_machine_type','q35','2025-10-02 12:24:57','2025-10-02 12:26:17','2025-10-02 12:26:17',1),(409,'cf521338-6de6-477f-b445-df9c97d57576','hw_cdrom_bus','sata','2025-10-02 12:24:57','2025-10-02 12:26:17','2025-10-02 12:26:17',1),(410,'cf521338-6de6-477f-b445-df9c97d57576','hw_disk_bus','virtio','2025-10-02 12:24:57','2025-10-02 12:26:17','2025-10-02 12:26:17',1),(411,'cf521338-6de6-477f-b445-df9c97d57576','hw_input_bus','usb','2025-10-02 12:24:57','2025-10-02 12:26:17','2025-10-02 12:26:17',1),(412,'cf521338-6de6-477f-b445-df9c97d57576','hw_pointer_model','usbtablet','2025-10-02 12:24:57','2025-10-02 12:26:17','2025-10-02 12:26:17',1),(413,'cf521338-6de6-477f-b445-df9c97d57576','hw_video_model','virtio','2025-10-02 12:24:57','2025-10-02 12:26:17','2025-10-02 12:26:17',1),(414,'cf521338-6de6-477f-b445-df9c97d57576','hw_vif_model','virtio','2025-10-02 12:24:57','2025-10-02 12:26:17','2025-10-02 12:26:17',1),(415,'cf521338-6de6-477f-b445-df9c97d57576','instance_uuid','4a3ab1f2-5ef4-4738-a6dc-0a5ae24af158','2025-10-02 12:24:57','2025-10-02 12:26:17','2025-10-02 12:26:17',1),(416,'cf521338-6de6-477f-b445-df9c97d57576','user_id','25468893d71641a385711fd2982bb00b','2025-10-02 12:24:57','2025-10-02 12:26:17','2025-10-02 12:26:17',1),(417,'cf521338-6de6-477f-b445-df9c97d57576','image_type','snapshot','2025-10-02 12:24:57','2025-10-02 12:26:17','2025-10-02 12:26:17',1),(418,'cf521338-6de6-477f-b445-df9c97d57576','image_location','snapshot','2025-10-02 12:25:02','2025-10-02 12:26:17','2025-10-02 12:26:17',1),(419,'cf521338-6de6-477f-b445-df9c97d57576','image_state','available','2025-10-02 12:25:02','2025-10-02 12:26:17','2025-10-02 12:26:17',1),(420,'cf521338-6de6-477f-b445-df9c97d57576','owner_id','10fff81da7a54740a53a0771ce916329','2025-10-02 12:25:02','2025-10-02 12:26:17','2025-10-02 12:26:17',1),(421,'cf693858-d747-42e7-8f75-d6c36d36cc6c','hw_rng_model','virtio','2025-10-02 12:25:16','2025-10-02 12:26:12','2025-10-02 12:26:12',1),(422,'cf693858-d747-42e7-8f75-d6c36d36cc6c','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:25:16','2025-10-02 12:26:12','2025-10-02 12:26:12',1),(423,'cf693858-d747-42e7-8f75-d6c36d36cc6c','owner_user_name','tempest-ServerActionsTestOtherB-1686489955-project-member','2025-10-02 12:25:16','2025-10-02 12:26:12','2025-10-02 12:26:12',1),(424,'cf693858-d747-42e7-8f75-d6c36d36cc6c','owner_project_name','tempest-ServerActionsTestOtherB-1686489955','2025-10-02 12:25:16','2025-10-02 12:26:12','2025-10-02 12:26:12',1),(425,'cf693858-d747-42e7-8f75-d6c36d36cc6c','boot_roles','reader,member','2025-10-02 12:25:16','2025-10-02 12:26:12','2025-10-02 12:26:12',1),(426,'cf693858-d747-42e7-8f75-d6c36d36cc6c','hw_machine_type','q35','2025-10-02 12:25:16','2025-10-02 12:26:12','2025-10-02 12:26:12',1),(427,'cf693858-d747-42e7-8f75-d6c36d36cc6c','hw_cdrom_bus','sata','2025-10-02 12:25:16','2025-10-02 12:26:12','2025-10-02 12:26:12',1),(428,'cf693858-d747-42e7-8f75-d6c36d36cc6c','hw_disk_bus','virtio','2025-10-02 12:25:16','2025-10-02 12:26:12','2025-10-02 12:26:12',1),(429,'cf693858-d747-42e7-8f75-d6c36d36cc6c','hw_input_bus','usb','2025-10-02 12:25:16','2025-10-02 12:26:12','2025-10-02 12:26:12',1),(430,'cf693858-d747-42e7-8f75-d6c36d36cc6c','hw_pointer_model','usbtablet','2025-10-02 12:25:16','2025-10-02 12:26:12','2025-10-02 12:26:12',1),(431,'cf693858-d747-42e7-8f75-d6c36d36cc6c','hw_video_model','virtio','2025-10-02 12:25:16','2025-10-02 12:26:12','2025-10-02 12:26:12',1),(432,'cf693858-d747-42e7-8f75-d6c36d36cc6c','hw_vif_model','virtio','2025-10-02 12:25:16','2025-10-02 12:26:12','2025-10-02 12:26:12',1),(433,'cf693858-d747-42e7-8f75-d6c36d36cc6c','instance_uuid','7b4bdbc9-7451-4500-8794-c8edef50d6a4','2025-10-02 12:25:16','2025-10-02 12:26:12','2025-10-02 12:26:12',1),(434,'cf693858-d747-42e7-8f75-d6c36d36cc6c','user_id','25468893d71641a385711fd2982bb00b','2025-10-02 12:25:16','2025-10-02 12:26:12','2025-10-02 12:26:12',1),(435,'cf693858-d747-42e7-8f75-d6c36d36cc6c','image_type','snapshot','2025-10-02 12:25:16','2025-10-02 12:26:12','2025-10-02 12:26:12',1),(436,'cf693858-d747-42e7-8f75-d6c36d36cc6c','owner_id','10fff81da7a54740a53a0771ce916329','2025-10-02 12:25:29','2025-10-02 12:26:12','2025-10-02 12:26:12',1),(437,'cf693858-d747-42e7-8f75-d6c36d36cc6c','image_state','available','2025-10-02 12:25:29','2025-10-02 12:26:12','2025-10-02 12:26:12',1),(438,'cf693858-d747-42e7-8f75-d6c36d36cc6c','image_location','snapshot','2025-10-02 12:25:29','2025-10-02 12:26:12','2025-10-02 12:26:12',1),(439,'c9b30ff1-d6cd-4854-b30d-a4ebbd02d3dc','signature_verified','False','2025-10-02 12:32:39','2025-10-02 12:32:51','2025-10-02 12:32:51',1),(440,'c9b30ff1-d6cd-4854-b30d-a4ebbd02d3dc','hw_rng_model','virtio','2025-10-02 12:32:39','2025-10-02 12:32:51','2025-10-02 12:32:51',1),(441,'c9b30ff1-d6cd-4854-b30d-a4ebbd02d3dc','base_image_ref','','2025-10-02 12:32:39','2025-10-02 12:32:51','2025-10-02 12:32:51',1),(442,'c9b30ff1-d6cd-4854-b30d-a4ebbd02d3dc','owner_user_name','tempest-AttachVolumeMultiAttachTest-1564585024-project-member','2025-10-02 12:32:39','2025-10-02 12:32:51','2025-10-02 12:32:51',1),(443,'c9b30ff1-d6cd-4854-b30d-a4ebbd02d3dc','owner_project_name','tempest-AttachVolumeMultiAttachTest-1564585024','2025-10-02 12:32:39','2025-10-02 12:32:51','2025-10-02 12:32:51',1),(444,'c9b30ff1-d6cd-4854-b30d-a4ebbd02d3dc','boot_roles','member,reader','2025-10-02 12:32:39','2025-10-02 12:32:51','2025-10-02 12:32:51',1),(445,'c9b30ff1-d6cd-4854-b30d-a4ebbd02d3dc','hw_machine_type','q35','2025-10-02 12:32:39','2025-10-02 12:32:51','2025-10-02 12:32:51',1),(446,'c9b30ff1-d6cd-4854-b30d-a4ebbd02d3dc','hw_cdrom_bus','sata','2025-10-02 12:32:39','2025-10-02 12:32:51','2025-10-02 12:32:51',1),(447,'c9b30ff1-d6cd-4854-b30d-a4ebbd02d3dc','hw_disk_bus','virtio','2025-10-02 12:32:39','2025-10-02 12:32:51','2025-10-02 12:32:51',1),(448,'c9b30ff1-d6cd-4854-b30d-a4ebbd02d3dc','hw_input_bus','usb','2025-10-02 12:32:39','2025-10-02 12:32:51','2025-10-02 12:32:51',1),(449,'c9b30ff1-d6cd-4854-b30d-a4ebbd02d3dc','hw_pointer_model','usbtablet','2025-10-02 12:32:39','2025-10-02 12:32:51','2025-10-02 12:32:51',1),(450,'c9b30ff1-d6cd-4854-b30d-a4ebbd02d3dc','hw_video_model','virtio','2025-10-02 12:32:39','2025-10-02 12:32:51','2025-10-02 12:32:51',1),(451,'c9b30ff1-d6cd-4854-b30d-a4ebbd02d3dc','hw_vif_model','virtio','2025-10-02 12:32:39','2025-10-02 12:32:51','2025-10-02 12:32:51',1),(452,'c9b30ff1-d6cd-4854-b30d-a4ebbd02d3dc','root_device_name','/dev/vda','2025-10-02 12:32:39','2025-10-02 12:32:51','2025-10-02 12:32:51',1),(453,'c9b30ff1-d6cd-4854-b30d-a4ebbd02d3dc','block_device_mapping','[{\"encryption_secret_uuid\": null, \"guest_format\": null, \"delete_on_termination\": false, \"encryption_format\": null, \"device_type\": \"disk\", \"encrypted\": null, \"snapshot_id\": \"ca60f0ab-6431-4851-87b3-164a993c75aa\", \"destination_type\": \"volume\", \"volume_type\": null, \"disk_bus\": \"virtio\", \"no_device\": null, \"volume_size\": 1, \"device_name\": \"/dev/vda\", \"encryption_options\": null, \"image_id\": null, \"source_type\": \"snapshot\", \"volume_id\": null, \"boot_index\": 0, \"tag\": null}]','2025-10-02 12:32:39','2025-10-02 12:32:51','2025-10-02 12:32:51',1),(454,'c9b30ff1-d6cd-4854-b30d-a4ebbd02d3dc','bdm_v2','True','2025-10-02 12:32:39','2025-10-02 12:32:51','2025-10-02 12:32:51',1),(455,'656ad3f4-b233-4eb8-822c-07efc986a6e0','hw_rng_model','virtio','2025-10-02 12:34:43','2025-10-02 12:36:00','2025-10-02 12:36:00',1),(456,'656ad3f4-b233-4eb8-822c-07efc986a6e0','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:34:43','2025-10-02 12:36:00','2025-10-02 12:36:00',1),(457,'656ad3f4-b233-4eb8-822c-07efc986a6e0','owner_user_name','tempest-AttachVolumeShelveTestJSON-405673070-project-member','2025-10-02 12:34:43','2025-10-02 12:36:00','2025-10-02 12:36:00',1),(458,'656ad3f4-b233-4eb8-822c-07efc986a6e0','owner_project_name','tempest-AttachVolumeShelveTestJSON-405673070','2025-10-02 12:34:43','2025-10-02 12:36:00','2025-10-02 12:36:00',1),(459,'656ad3f4-b233-4eb8-822c-07efc986a6e0','boot_roles','reader,member','2025-10-02 12:34:43','2025-10-02 12:36:00','2025-10-02 12:36:00',1),(460,'656ad3f4-b233-4eb8-822c-07efc986a6e0','hw_machine_type','q35','2025-10-02 12:34:43','2025-10-02 12:36:00','2025-10-02 12:36:00',1),(461,'656ad3f4-b233-4eb8-822c-07efc986a6e0','hw_cdrom_bus','sata','2025-10-02 12:34:43','2025-10-02 12:36:00','2025-10-02 12:36:00',1),(462,'656ad3f4-b233-4eb8-822c-07efc986a6e0','hw_disk_bus','virtio','2025-10-02 12:34:43','2025-10-02 12:36:00','2025-10-02 12:36:00',1),(463,'656ad3f4-b233-4eb8-822c-07efc986a6e0','hw_input_bus','usb','2025-10-02 12:34:43','2025-10-02 12:36:00','2025-10-02 12:36:00',1),(464,'656ad3f4-b233-4eb8-822c-07efc986a6e0','hw_pointer_model','usbtablet','2025-10-02 12:34:43','2025-10-02 12:36:00','2025-10-02 12:36:00',1),(465,'656ad3f4-b233-4eb8-822c-07efc986a6e0','hw_video_model','virtio','2025-10-02 12:34:43','2025-10-02 12:36:00','2025-10-02 12:36:00',1),(466,'656ad3f4-b233-4eb8-822c-07efc986a6e0','hw_vif_model','virtio','2025-10-02 12:34:43','2025-10-02 12:36:00','2025-10-02 12:36:00',1),(467,'656ad3f4-b233-4eb8-822c-07efc986a6e0','instance_uuid','8736e2a4-70c8-46c1-8ce5-ff68395a22c9','2025-10-02 12:34:43','2025-10-02 12:36:00','2025-10-02 12:36:00',1),(468,'656ad3f4-b233-4eb8-822c-07efc986a6e0','user_id','bcd36ab668f449959719ba7058f25e72','2025-10-02 12:34:43','2025-10-02 12:36:00','2025-10-02 12:36:00',1),(469,'656ad3f4-b233-4eb8-822c-07efc986a6e0','image_type','snapshot','2025-10-02 12:34:43','2025-10-02 12:36:00','2025-10-02 12:36:00',1),(470,'656ad3f4-b233-4eb8-822c-07efc986a6e0','owner_id','1a05e525420b4aa8adcc9561158e73d1','2025-10-02 12:34:52','2025-10-02 12:36:00','2025-10-02 12:36:00',1),(471,'656ad3f4-b233-4eb8-822c-07efc986a6e0','image_state','available','2025-10-02 12:34:52','2025-10-02 12:36:00','2025-10-02 12:36:00',1),(472,'656ad3f4-b233-4eb8-822c-07efc986a6e0','image_location','snapshot','2025-10-02 12:34:52','2025-10-02 12:36:00','2025-10-02 12:36:00',1),(473,'766f42a5-3020-41dc-a077-fda5642a1d60','hw_rng_model','virtio','2025-10-02 12:37:26','2025-10-02 12:38:14','2025-10-02 12:38:14',1),(474,'766f42a5-3020-41dc-a077-fda5642a1d60','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:37:26','2025-10-02 12:38:14','2025-10-02 12:38:14',1),(475,'766f42a5-3020-41dc-a077-fda5642a1d60','owner_user_name','tempest-AttachVolumeShelveTestJSON-405673070-project-member','2025-10-02 12:37:26','2025-10-02 12:38:14','2025-10-02 12:38:14',1),(476,'766f42a5-3020-41dc-a077-fda5642a1d60','owner_project_name','tempest-AttachVolumeShelveTestJSON-405673070','2025-10-02 12:37:26','2025-10-02 12:38:14','2025-10-02 12:38:14',1),(477,'766f42a5-3020-41dc-a077-fda5642a1d60','boot_roles','reader,member','2025-10-02 12:37:26','2025-10-02 12:38:14','2025-10-02 12:38:14',1),(478,'766f42a5-3020-41dc-a077-fda5642a1d60','hw_machine_type','q35','2025-10-02 12:37:26','2025-10-02 12:38:14','2025-10-02 12:38:14',1),(479,'766f42a5-3020-41dc-a077-fda5642a1d60','hw_cdrom_bus','sata','2025-10-02 12:37:26','2025-10-02 12:38:14','2025-10-02 12:38:14',1),(480,'766f42a5-3020-41dc-a077-fda5642a1d60','hw_disk_bus','virtio','2025-10-02 12:37:26','2025-10-02 12:38:14','2025-10-02 12:38:14',1),(481,'766f42a5-3020-41dc-a077-fda5642a1d60','hw_input_bus','usb','2025-10-02 12:37:26','2025-10-02 12:38:14','2025-10-02 12:38:14',1),(482,'766f42a5-3020-41dc-a077-fda5642a1d60','hw_pointer_model','usbtablet','2025-10-02 12:37:26','2025-10-02 12:38:14','2025-10-02 12:38:14',1),(483,'766f42a5-3020-41dc-a077-fda5642a1d60','hw_video_model','virtio','2025-10-02 12:37:26','2025-10-02 12:38:14','2025-10-02 12:38:14',1),(484,'766f42a5-3020-41dc-a077-fda5642a1d60','hw_vif_model','virtio','2025-10-02 12:37:26','2025-10-02 12:38:14','2025-10-02 12:38:14',1),(485,'766f42a5-3020-41dc-a077-fda5642a1d60','instance_uuid','be1174bf-d7e1-4801-a2eb-67020632d637','2025-10-02 12:37:26','2025-10-02 12:38:14','2025-10-02 12:38:14',1),(486,'766f42a5-3020-41dc-a077-fda5642a1d60','user_id','bcd36ab668f449959719ba7058f25e72','2025-10-02 12:37:26','2025-10-02 12:38:14','2025-10-02 12:38:14',1),(487,'766f42a5-3020-41dc-a077-fda5642a1d60','image_type','snapshot','2025-10-02 12:37:26','2025-10-02 12:38:14','2025-10-02 12:38:14',1),(488,'766f42a5-3020-41dc-a077-fda5642a1d60','owner_id','1a05e525420b4aa8adcc9561158e73d1','2025-10-02 12:37:37','2025-10-02 12:38:14','2025-10-02 12:38:14',1),(489,'766f42a5-3020-41dc-a077-fda5642a1d60','image_state','available','2025-10-02 12:37:37','2025-10-02 12:38:14','2025-10-02 12:38:14',1),(490,'766f42a5-3020-41dc-a077-fda5642a1d60','image_location','snapshot','2025-10-02 12:37:37','2025-10-02 12:38:14','2025-10-02 12:38:14',1),(491,'b6b477f5-f929-4c8c-a864-0bf66fee68a2','hw_rng_model','virtio','2025-10-02 12:42:46','2025-10-02 12:43:29','2025-10-02 12:43:29',1),(492,'b6b477f5-f929-4c8c-a864-0bf66fee68a2','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:42:46','2025-10-02 12:43:29','2025-10-02 12:43:29',1),(493,'b6b477f5-f929-4c8c-a864-0bf66fee68a2','owner_user_name','tempest-TestShelveInstance-1219039163-project-member','2025-10-02 12:42:46','2025-10-02 12:43:29','2025-10-02 12:43:29',1),(494,'b6b477f5-f929-4c8c-a864-0bf66fee68a2','owner_project_name','tempest-TestShelveInstance-1219039163','2025-10-02 12:42:46','2025-10-02 12:43:29','2025-10-02 12:43:29',1),(495,'b6b477f5-f929-4c8c-a864-0bf66fee68a2','boot_roles','member,reader','2025-10-02 12:42:46','2025-10-02 12:43:29','2025-10-02 12:43:29',1),(496,'b6b477f5-f929-4c8c-a864-0bf66fee68a2','hw_machine_type','q35','2025-10-02 12:42:46','2025-10-02 12:43:29','2025-10-02 12:43:29',1),(497,'b6b477f5-f929-4c8c-a864-0bf66fee68a2','hw_cdrom_bus','sata','2025-10-02 12:42:46','2025-10-02 12:43:29','2025-10-02 12:43:29',1),(498,'b6b477f5-f929-4c8c-a864-0bf66fee68a2','hw_disk_bus','virtio','2025-10-02 12:42:46','2025-10-02 12:43:29','2025-10-02 12:43:29',1),(499,'b6b477f5-f929-4c8c-a864-0bf66fee68a2','hw_input_bus','usb','2025-10-02 12:42:46','2025-10-02 12:43:29','2025-10-02 12:43:29',1),(500,'b6b477f5-f929-4c8c-a864-0bf66fee68a2','hw_pointer_model','usbtablet','2025-10-02 12:42:46','2025-10-02 12:43:29','2025-10-02 12:43:29',1),(501,'b6b477f5-f929-4c8c-a864-0bf66fee68a2','hw_video_model','virtio','2025-10-02 12:42:46','2025-10-02 12:43:29','2025-10-02 12:43:29',1),(502,'b6b477f5-f929-4c8c-a864-0bf66fee68a2','hw_vif_model','virtio','2025-10-02 12:42:46','2025-10-02 12:43:29','2025-10-02 12:43:29',1),(503,'b6b477f5-f929-4c8c-a864-0bf66fee68a2','instance_uuid','c70e8f51-9397-40dd-9bbe-210e60b75364','2025-10-02 12:42:46','2025-10-02 12:43:29','2025-10-02 12:43:29',1),(504,'b6b477f5-f929-4c8c-a864-0bf66fee68a2','user_id','56c6abe1bb704c8aa499677aeb9017f5','2025-10-02 12:42:46','2025-10-02 12:43:29','2025-10-02 12:43:29',1),(505,'b6b477f5-f929-4c8c-a864-0bf66fee68a2','image_type','snapshot','2025-10-02 12:42:46','2025-10-02 12:43:29','2025-10-02 12:43:29',1),(506,'b6b477f5-f929-4c8c-a864-0bf66fee68a2','owner_id','4b8f9114c7ab4b6e9fc9650d4bd08af9','2025-10-02 12:42:57','2025-10-02 12:43:29','2025-10-02 12:43:29',1),(507,'b6b477f5-f929-4c8c-a864-0bf66fee68a2','image_state','available','2025-10-02 12:42:57','2025-10-02 12:43:29','2025-10-02 12:43:29',1),(508,'b6b477f5-f929-4c8c-a864-0bf66fee68a2','image_location','snapshot','2025-10-02 12:42:57','2025-10-02 12:43:29','2025-10-02 12:43:29',1),(509,'a62d470f-f755-4a5a-b8e5-0dc1be0600d1','hw_rng_model','virtio','2025-10-02 12:48:00','2025-10-02 12:49:24','2025-10-02 12:49:24',1),(510,'a62d470f-f755-4a5a-b8e5-0dc1be0600d1','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:48:00','2025-10-02 12:49:24','2025-10-02 12:49:24',1),(511,'a62d470f-f755-4a5a-b8e5-0dc1be0600d1','owner_user_name','tempest-TestStampPattern-901207223-project-member','2025-10-02 12:48:00','2025-10-02 12:49:24','2025-10-02 12:49:24',1),(512,'a62d470f-f755-4a5a-b8e5-0dc1be0600d1','owner_project_name','tempest-TestStampPattern-901207223','2025-10-02 12:48:00','2025-10-02 12:49:24','2025-10-02 12:49:24',1),(513,'a62d470f-f755-4a5a-b8e5-0dc1be0600d1','boot_roles','member,reader','2025-10-02 12:48:00','2025-10-02 12:49:24','2025-10-02 12:49:24',1),(514,'a62d470f-f755-4a5a-b8e5-0dc1be0600d1','hw_machine_type','q35','2025-10-02 12:48:00','2025-10-02 12:49:24','2025-10-02 12:49:24',1),(515,'a62d470f-f755-4a5a-b8e5-0dc1be0600d1','hw_cdrom_bus','sata','2025-10-02 12:48:00','2025-10-02 12:49:24','2025-10-02 12:49:24',1),(516,'a62d470f-f755-4a5a-b8e5-0dc1be0600d1','hw_disk_bus','virtio','2025-10-02 12:48:00','2025-10-02 12:49:24','2025-10-02 12:49:24',1),(517,'a62d470f-f755-4a5a-b8e5-0dc1be0600d1','hw_input_bus','usb','2025-10-02 12:48:00','2025-10-02 12:49:24','2025-10-02 12:49:24',1),(518,'a62d470f-f755-4a5a-b8e5-0dc1be0600d1','hw_pointer_model','usbtablet','2025-10-02 12:48:00','2025-10-02 12:49:24','2025-10-02 12:49:24',1),(519,'a62d470f-f755-4a5a-b8e5-0dc1be0600d1','hw_video_model','virtio','2025-10-02 12:48:00','2025-10-02 12:49:24','2025-10-02 12:49:24',1),(520,'a62d470f-f755-4a5a-b8e5-0dc1be0600d1','hw_vif_model','virtio','2025-10-02 12:48:00','2025-10-02 12:49:24','2025-10-02 12:49:24',1),(521,'a62d470f-f755-4a5a-b8e5-0dc1be0600d1','instance_uuid','bf9e8de1-5081-4daa-9041-1d329e06be86','2025-10-02 12:48:00','2025-10-02 12:49:24','2025-10-02 12:49:24',1),(522,'a62d470f-f755-4a5a-b8e5-0dc1be0600d1','user_id','a24a7109471f4d96ad5f11b637fdb8e7','2025-10-02 12:48:00','2025-10-02 12:49:24','2025-10-02 12:49:24',1),(523,'a62d470f-f755-4a5a-b8e5-0dc1be0600d1','image_type','snapshot','2025-10-02 12:48:00','2025-10-02 12:49:24','2025-10-02 12:49:24',1),(524,'a62d470f-f755-4a5a-b8e5-0dc1be0600d1','owner_id','a837417d42da439cb794b4295bca2cee','2025-10-02 12:48:07','2025-10-02 12:49:24','2025-10-02 12:49:24',1),(525,'a62d470f-f755-4a5a-b8e5-0dc1be0600d1','image_state','available','2025-10-02 12:48:07','2025-10-02 12:49:24','2025-10-02 12:49:24',1),(526,'a62d470f-f755-4a5a-b8e5-0dc1be0600d1','image_location','snapshot','2025-10-02 12:48:07','2025-10-02 12:49:24','2025-10-02 12:49:24',1),(527,'5428ba77-2370-48a0-8396-a85c08f86505','hw_rng_model','virtio','2025-10-02 12:48:31','2025-10-02 12:55:13','2025-10-02 12:55:13',1),(528,'5428ba77-2370-48a0-8396-a85c08f86505','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:48:31','2025-10-02 12:55:13','2025-10-02 12:55:13',1),(529,'5428ba77-2370-48a0-8396-a85c08f86505','owner_user_name','tempest-ServerStableDeviceRescueTest-454391960-project-member','2025-10-02 12:48:31','2025-10-02 12:55:13','2025-10-02 12:55:13',1),(530,'5428ba77-2370-48a0-8396-a85c08f86505','owner_project_name','tempest-ServerStableDeviceRescueTest-454391960','2025-10-02 12:48:31','2025-10-02 12:55:13','2025-10-02 12:55:13',1),(531,'5428ba77-2370-48a0-8396-a85c08f86505','boot_roles','reader,member','2025-10-02 12:48:31','2025-10-02 12:55:13','2025-10-02 12:55:13',1),(532,'5428ba77-2370-48a0-8396-a85c08f86505','hw_machine_type','q35','2025-10-02 12:48:31','2025-10-02 12:55:13','2025-10-02 12:55:13',1),(533,'5428ba77-2370-48a0-8396-a85c08f86505','hw_cdrom_bus','sata','2025-10-02 12:48:31','2025-10-02 12:55:13','2025-10-02 12:55:13',1),(534,'5428ba77-2370-48a0-8396-a85c08f86505','hw_disk_bus','virtio','2025-10-02 12:48:31','2025-10-02 12:55:13','2025-10-02 12:55:13',1),(535,'5428ba77-2370-48a0-8396-a85c08f86505','hw_input_bus','usb','2025-10-02 12:48:31','2025-10-02 12:55:13','2025-10-02 12:55:13',1),(536,'5428ba77-2370-48a0-8396-a85c08f86505','hw_pointer_model','usbtablet','2025-10-02 12:48:31','2025-10-02 12:55:13','2025-10-02 12:55:13',1),(537,'5428ba77-2370-48a0-8396-a85c08f86505','hw_video_model','virtio','2025-10-02 12:48:31','2025-10-02 12:55:13','2025-10-02 12:55:13',1),(538,'5428ba77-2370-48a0-8396-a85c08f86505','hw_vif_model','virtio','2025-10-02 12:48:31','2025-10-02 12:55:13','2025-10-02 12:55:13',1),(539,'5428ba77-2370-48a0-8396-a85c08f86505','instance_uuid','439392e5-66ae-4162-a7e5-077f87ca558b','2025-10-02 12:48:31','2025-10-02 12:55:13','2025-10-02 12:55:13',1),(540,'5428ba77-2370-48a0-8396-a85c08f86505','user_id','6785ffe5d6554514b4ed9fd47665eca0','2025-10-02 12:48:31','2025-10-02 12:55:13','2025-10-02 12:55:13',1),(541,'5428ba77-2370-48a0-8396-a85c08f86505','image_type','snapshot','2025-10-02 12:48:31','2025-10-02 12:55:13','2025-10-02 12:55:13',1),(542,'5428ba77-2370-48a0-8396-a85c08f86505','owner_id','6a442bc513e14406b73e96e70396e6c3','2025-10-02 12:48:38','2025-10-02 12:55:13','2025-10-02 12:55:13',1),(543,'5428ba77-2370-48a0-8396-a85c08f86505','image_state','available','2025-10-02 12:48:38','2025-10-02 12:55:13','2025-10-02 12:55:13',1),(544,'5428ba77-2370-48a0-8396-a85c08f86505','image_location','snapshot','2025-10-02 12:48:38','2025-10-02 12:55:13','2025-10-02 12:55:13',1),(545,'5428ba77-2370-48a0-8396-a85c08f86505','hw_rescue_bus','scsi','2025-10-02 12:48:41','2025-10-02 12:55:13','2025-10-02 12:55:13',1),(546,'5428ba77-2370-48a0-8396-a85c08f86505','hw_rescue_device','disk','2025-10-02 12:48:41','2025-10-02 12:55:13','2025-10-02 12:55:13',1),(547,'b25d743c-aae4-4c6f-a9cb-a03c63b08b2c','hw_rng_model','virtio','2025-10-02 12:49:23','2025-10-02 12:55:06','2025-10-02 12:55:06',1),(548,'b25d743c-aae4-4c6f-a9cb-a03c63b08b2c','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:49:23','2025-10-02 12:55:06','2025-10-02 12:55:06',1),(549,'b25d743c-aae4-4c6f-a9cb-a03c63b08b2c','owner_user_name','tempest-ServerStableDeviceRescueTest-454391960-project-member','2025-10-02 12:49:23','2025-10-02 12:55:06','2025-10-02 12:55:06',1),(550,'b25d743c-aae4-4c6f-a9cb-a03c63b08b2c','owner_project_name','tempest-ServerStableDeviceRescueTest-454391960','2025-10-02 12:49:23','2025-10-02 12:55:07','2025-10-02 12:55:07',1),(551,'b25d743c-aae4-4c6f-a9cb-a03c63b08b2c','boot_roles','reader,member','2025-10-02 12:49:23','2025-10-02 12:55:07','2025-10-02 12:55:07',1),(552,'b25d743c-aae4-4c6f-a9cb-a03c63b08b2c','hw_machine_type','q35','2025-10-02 12:49:23','2025-10-02 12:55:07','2025-10-02 12:55:07',1),(553,'b25d743c-aae4-4c6f-a9cb-a03c63b08b2c','hw_cdrom_bus','sata','2025-10-02 12:49:23','2025-10-02 12:55:07','2025-10-02 12:55:07',1),(554,'b25d743c-aae4-4c6f-a9cb-a03c63b08b2c','hw_disk_bus','virtio','2025-10-02 12:49:23','2025-10-02 12:55:07','2025-10-02 12:55:07',1),(555,'b25d743c-aae4-4c6f-a9cb-a03c63b08b2c','hw_input_bus','usb','2025-10-02 12:49:23','2025-10-02 12:55:07','2025-10-02 12:55:07',1),(556,'b25d743c-aae4-4c6f-a9cb-a03c63b08b2c','hw_pointer_model','usbtablet','2025-10-02 12:49:23','2025-10-02 12:55:07','2025-10-02 12:55:07',1),(557,'b25d743c-aae4-4c6f-a9cb-a03c63b08b2c','hw_video_model','virtio','2025-10-02 12:49:23','2025-10-02 12:55:07','2025-10-02 12:55:07',1),(558,'b25d743c-aae4-4c6f-a9cb-a03c63b08b2c','hw_vif_model','virtio','2025-10-02 12:49:23','2025-10-02 12:55:07','2025-10-02 12:55:07',1),(559,'b25d743c-aae4-4c6f-a9cb-a03c63b08b2c','instance_uuid','ac6724c1-4d98-45f7-8e2b-dfac55d9cb13','2025-10-02 12:49:23','2025-10-02 12:55:07','2025-10-02 12:55:07',1),(560,'b25d743c-aae4-4c6f-a9cb-a03c63b08b2c','user_id','6785ffe5d6554514b4ed9fd47665eca0','2025-10-02 12:49:23','2025-10-02 12:55:07','2025-10-02 12:55:07',1),(561,'b25d743c-aae4-4c6f-a9cb-a03c63b08b2c','image_type','snapshot','2025-10-02 12:49:23','2025-10-02 12:55:07','2025-10-02 12:55:07',1),(562,'b25d743c-aae4-4c6f-a9cb-a03c63b08b2c','owner_id','6a442bc513e14406b73e96e70396e6c3','2025-10-02 12:49:29','2025-10-02 12:55:07','2025-10-02 12:55:07',1),(563,'b25d743c-aae4-4c6f-a9cb-a03c63b08b2c','image_state','available','2025-10-02 12:49:29','2025-10-02 12:55:07','2025-10-02 12:55:07',1),(564,'b25d743c-aae4-4c6f-a9cb-a03c63b08b2c','image_location','snapshot','2025-10-02 12:49:29','2025-10-02 12:55:07','2025-10-02 12:55:07',1),(565,'b25d743c-aae4-4c6f-a9cb-a03c63b08b2c','hw_rescue_bus','usb','2025-10-02 12:49:34','2025-10-02 12:55:07','2025-10-02 12:55:07',1),(566,'b25d743c-aae4-4c6f-a9cb-a03c63b08b2c','hw_rescue_device','disk','2025-10-02 12:49:34','2025-10-02 12:55:07','2025-10-02 12:55:07',1),(567,'e3ec26e3-5879-4ab0-bb2c-bf8f5cbdc0c0','hw_rng_model','virtio','2025-10-02 12:50:16','2025-10-02 12:55:00','2025-10-02 12:55:00',1),(568,'e3ec26e3-5879-4ab0-bb2c-bf8f5cbdc0c0','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:50:16','2025-10-02 12:55:00','2025-10-02 12:55:00',1),(569,'e3ec26e3-5879-4ab0-bb2c-bf8f5cbdc0c0','owner_user_name','tempest-ServerStableDeviceRescueTest-454391960-project-member','2025-10-02 12:50:16','2025-10-02 12:55:00','2025-10-02 12:55:00',1),(570,'e3ec26e3-5879-4ab0-bb2c-bf8f5cbdc0c0','owner_project_name','tempest-ServerStableDeviceRescueTest-454391960','2025-10-02 12:50:16','2025-10-02 12:55:00','2025-10-02 12:55:00',1),(571,'e3ec26e3-5879-4ab0-bb2c-bf8f5cbdc0c0','boot_roles','reader,member','2025-10-02 12:50:16','2025-10-02 12:55:00','2025-10-02 12:55:00',1),(572,'e3ec26e3-5879-4ab0-bb2c-bf8f5cbdc0c0','hw_machine_type','q35','2025-10-02 12:50:16','2025-10-02 12:55:00','2025-10-02 12:55:00',1),(573,'e3ec26e3-5879-4ab0-bb2c-bf8f5cbdc0c0','hw_cdrom_bus','sata','2025-10-02 12:50:16','2025-10-02 12:55:00','2025-10-02 12:55:00',1),(574,'e3ec26e3-5879-4ab0-bb2c-bf8f5cbdc0c0','hw_disk_bus','virtio','2025-10-02 12:50:16','2025-10-02 12:55:00','2025-10-02 12:55:00',1),(575,'e3ec26e3-5879-4ab0-bb2c-bf8f5cbdc0c0','hw_input_bus','usb','2025-10-02 12:50:16','2025-10-02 12:55:00','2025-10-02 12:55:00',1),(576,'e3ec26e3-5879-4ab0-bb2c-bf8f5cbdc0c0','hw_pointer_model','usbtablet','2025-10-02 12:50:16','2025-10-02 12:55:00','2025-10-02 12:55:00',1),(577,'e3ec26e3-5879-4ab0-bb2c-bf8f5cbdc0c0','hw_video_model','virtio','2025-10-02 12:50:16','2025-10-02 12:55:00','2025-10-02 12:55:00',1),(578,'e3ec26e3-5879-4ab0-bb2c-bf8f5cbdc0c0','hw_vif_model','virtio','2025-10-02 12:50:16','2025-10-02 12:55:00','2025-10-02 12:55:00',1),(579,'e3ec26e3-5879-4ab0-bb2c-bf8f5cbdc0c0','instance_uuid','8e2c1007-1d07-434c-8a22-6cb98d903d3c','2025-10-02 12:50:16','2025-10-02 12:55:00','2025-10-02 12:55:00',1),(580,'e3ec26e3-5879-4ab0-bb2c-bf8f5cbdc0c0','user_id','6785ffe5d6554514b4ed9fd47665eca0','2025-10-02 12:50:16','2025-10-02 12:55:00','2025-10-02 12:55:00',1),(581,'e3ec26e3-5879-4ab0-bb2c-bf8f5cbdc0c0','image_type','snapshot','2025-10-02 12:50:16','2025-10-02 12:55:00','2025-10-02 12:55:00',1),(582,'e3ec26e3-5879-4ab0-bb2c-bf8f5cbdc0c0','image_location','snapshot','2025-10-02 12:50:22','2025-10-02 12:55:00','2025-10-02 12:55:00',1),(583,'e3ec26e3-5879-4ab0-bb2c-bf8f5cbdc0c0','image_state','available','2025-10-02 12:50:22','2025-10-02 12:55:00','2025-10-02 12:55:00',1),(584,'e3ec26e3-5879-4ab0-bb2c-bf8f5cbdc0c0','owner_id','6a442bc513e14406b73e96e70396e6c3','2025-10-02 12:50:22','2025-10-02 12:55:00','2025-10-02 12:55:00',1),(585,'e3ec26e3-5879-4ab0-bb2c-bf8f5cbdc0c0','hw_rescue_bus','virtio','2025-10-02 12:50:24','2025-10-02 12:55:00','2025-10-02 12:55:00',1),(586,'e3ec26e3-5879-4ab0-bb2c-bf8f5cbdc0c0','hw_rescue_device','disk','2025-10-02 12:50:25','2025-10-02 12:55:00','2025-10-02 12:55:00',1),(587,'c899ce5c-6879-41fc-92e4-79bd307b464d','hw_rng_model','virtio','2025-10-02 12:52:08','2025-10-02 12:54:47','2025-10-02 12:54:47',1),(588,'c899ce5c-6879-41fc-92e4-79bd307b464d','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 12:52:08','2025-10-02 12:54:47','2025-10-02 12:54:47',1),(589,'c899ce5c-6879-41fc-92e4-79bd307b464d','owner_user_name','tempest-ServerStableDeviceRescueTest-454391960-project-member','2025-10-02 12:52:08','2025-10-02 12:54:47','2025-10-02 12:54:47',1),(590,'c899ce5c-6879-41fc-92e4-79bd307b464d','owner_project_name','tempest-ServerStableDeviceRescueTest-454391960','2025-10-02 12:52:08','2025-10-02 12:54:47','2025-10-02 12:54:47',1),(591,'c899ce5c-6879-41fc-92e4-79bd307b464d','boot_roles','reader,member','2025-10-02 12:52:08','2025-10-02 12:54:47','2025-10-02 12:54:47',1),(592,'c899ce5c-6879-41fc-92e4-79bd307b464d','hw_machine_type','q35','2025-10-02 12:52:08','2025-10-02 12:54:47','2025-10-02 12:54:47',1),(593,'c899ce5c-6879-41fc-92e4-79bd307b464d','hw_cdrom_bus','sata','2025-10-02 12:52:08','2025-10-02 12:54:47','2025-10-02 12:54:47',1),(594,'c899ce5c-6879-41fc-92e4-79bd307b464d','hw_disk_bus','virtio','2025-10-02 12:52:08','2025-10-02 12:54:47','2025-10-02 12:54:47',1),(595,'c899ce5c-6879-41fc-92e4-79bd307b464d','hw_input_bus','usb','2025-10-02 12:52:08','2025-10-02 12:54:47','2025-10-02 12:54:47',1),(596,'c899ce5c-6879-41fc-92e4-79bd307b464d','hw_pointer_model','usbtablet','2025-10-02 12:52:08','2025-10-02 12:54:47','2025-10-02 12:54:47',1),(597,'c899ce5c-6879-41fc-92e4-79bd307b464d','hw_video_model','virtio','2025-10-02 12:52:08','2025-10-02 12:54:47','2025-10-02 12:54:47',1),(598,'c899ce5c-6879-41fc-92e4-79bd307b464d','hw_vif_model','virtio','2025-10-02 12:52:08','2025-10-02 12:54:47','2025-10-02 12:54:47',1),(599,'c899ce5c-6879-41fc-92e4-79bd307b464d','instance_uuid','f5646848-ae0c-448c-9912-d5ee5734bd1e','2025-10-02 12:52:08','2025-10-02 12:54:47','2025-10-02 12:54:47',1),(600,'c899ce5c-6879-41fc-92e4-79bd307b464d','user_id','6785ffe5d6554514b4ed9fd47665eca0','2025-10-02 12:52:08','2025-10-02 12:54:47','2025-10-02 12:54:47',1),(601,'c899ce5c-6879-41fc-92e4-79bd307b464d','image_type','snapshot','2025-10-02 12:52:08','2025-10-02 12:54:47','2025-10-02 12:54:47',1),(602,'c899ce5c-6879-41fc-92e4-79bd307b464d','owner_id','6a442bc513e14406b73e96e70396e6c3','2025-10-02 12:52:30','2025-10-02 12:54:47','2025-10-02 12:54:47',1),(603,'c899ce5c-6879-41fc-92e4-79bd307b464d','image_location','snapshot','2025-10-02 12:52:30','2025-10-02 12:54:47','2025-10-02 12:54:47',1),(604,'c899ce5c-6879-41fc-92e4-79bd307b464d','image_state','available','2025-10-02 12:52:30','2025-10-02 12:54:47','2025-10-02 12:54:47',1),(605,'c899ce5c-6879-41fc-92e4-79bd307b464d','hw_rescue_bus','virtio','2025-10-02 12:52:43','2025-10-02 12:54:47','2025-10-02 12:54:47',1),(606,'c899ce5c-6879-41fc-92e4-79bd307b464d','hw_rescue_device','disk','2025-10-02 12:52:43','2025-10-02 12:54:47','2025-10-02 12:54:47',1),(607,'a1241e22-2f30-42e3-8072-a21ad0ab0f69','hw_rng_model','virtio','2025-10-02 13:08:33','2025-10-02 13:09:51','2025-10-02 13:09:51',1),(608,'a1241e22-2f30-42e3-8072-a21ad0ab0f69','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 13:08:33','2025-10-02 13:09:51','2025-10-02 13:09:51',1),(609,'a1241e22-2f30-42e3-8072-a21ad0ab0f69','owner_user_name','tempest-TestSnapshotPattern-400150385-project-member','2025-10-02 13:08:33','2025-10-02 13:09:51','2025-10-02 13:09:51',1),(610,'a1241e22-2f30-42e3-8072-a21ad0ab0f69','owner_project_name','tempest-TestSnapshotPattern-400150385','2025-10-02 13:08:33','2025-10-02 13:09:51','2025-10-02 13:09:51',1),(611,'a1241e22-2f30-42e3-8072-a21ad0ab0f69','boot_roles','reader,member','2025-10-02 13:08:33','2025-10-02 13:09:51','2025-10-02 13:09:51',1),(612,'a1241e22-2f30-42e3-8072-a21ad0ab0f69','hw_machine_type','q35','2025-10-02 13:08:33','2025-10-02 13:09:51','2025-10-02 13:09:51',1),(613,'a1241e22-2f30-42e3-8072-a21ad0ab0f69','hw_cdrom_bus','sata','2025-10-02 13:08:33','2025-10-02 13:09:51','2025-10-02 13:09:51',1),(614,'a1241e22-2f30-42e3-8072-a21ad0ab0f69','hw_disk_bus','virtio','2025-10-02 13:08:33','2025-10-02 13:09:51','2025-10-02 13:09:51',1),(615,'a1241e22-2f30-42e3-8072-a21ad0ab0f69','hw_input_bus','usb','2025-10-02 13:08:33','2025-10-02 13:09:51','2025-10-02 13:09:51',1),(616,'a1241e22-2f30-42e3-8072-a21ad0ab0f69','hw_pointer_model','usbtablet','2025-10-02 13:08:33','2025-10-02 13:09:51','2025-10-02 13:09:51',1),(617,'a1241e22-2f30-42e3-8072-a21ad0ab0f69','hw_video_model','virtio','2025-10-02 13:08:33','2025-10-02 13:09:51','2025-10-02 13:09:51',1),(618,'a1241e22-2f30-42e3-8072-a21ad0ab0f69','hw_vif_model','virtio','2025-10-02 13:08:33','2025-10-02 13:09:51','2025-10-02 13:09:51',1),(619,'a1241e22-2f30-42e3-8072-a21ad0ab0f69','instance_uuid','fc398644-66fc-44e3-9a6a-7389f5a542b8','2025-10-02 13:08:33','2025-10-02 13:09:51','2025-10-02 13:09:51',1),(620,'a1241e22-2f30-42e3-8072-a21ad0ab0f69','user_id','29c8a28c5bdd4feb9412127428bf0c3b','2025-10-02 13:08:33','2025-10-02 13:09:51','2025-10-02 13:09:51',1),(621,'a1241e22-2f30-42e3-8072-a21ad0ab0f69','image_type','snapshot','2025-10-02 13:08:33','2025-10-02 13:09:51','2025-10-02 13:09:51',1),(622,'a1241e22-2f30-42e3-8072-a21ad0ab0f69','owner_id','60bfd415ee154615b20dd99528061614','2025-10-02 13:08:38','2025-10-02 13:09:51','2025-10-02 13:09:51',1),(623,'a1241e22-2f30-42e3-8072-a21ad0ab0f69','image_location','snapshot','2025-10-02 13:08:38','2025-10-02 13:09:51','2025-10-02 13:09:51',1),(624,'a1241e22-2f30-42e3-8072-a21ad0ab0f69','image_state','available','2025-10-02 13:08:38','2025-10-02 13:09:51','2025-10-02 13:09:51',1),(625,'a1241e22-2f30-42e3-8072-a21ad0ab0f69','version','8.0','2025-10-02 13:08:40','2025-10-02 13:09:51','2025-10-02 13:09:51',1),(626,'ef37c5e7-f078-42ef-9403-bff6103a0870','hw_rng_model','virtio','2025-10-02 13:09:37','2025-10-02 13:09:45','2025-10-02 13:09:45',1),(627,'ef37c5e7-f078-42ef-9403-bff6103a0870','base_image_ref','c2d0c2bc-fe21-4689-86ae-d6728c15874c','2025-10-02 13:09:37','2025-10-02 13:09:45','2025-10-02 13:09:45',1),(628,'ef37c5e7-f078-42ef-9403-bff6103a0870','owner_user_name','tempest-TestSnapshotPattern-400150385-project-member','2025-10-02 13:09:37','2025-10-02 13:09:45','2025-10-02 13:09:45',1),(629,'ef37c5e7-f078-42ef-9403-bff6103a0870','owner_project_name','tempest-TestSnapshotPattern-400150385','2025-10-02 13:09:37','2025-10-02 13:09:45','2025-10-02 13:09:45',1),(630,'ef37c5e7-f078-42ef-9403-bff6103a0870','boot_roles','reader,member','2025-10-02 13:09:37','2025-10-02 13:09:45','2025-10-02 13:09:45',1),(631,'ef37c5e7-f078-42ef-9403-bff6103a0870','hw_machine_type','q35','2025-10-02 13:09:37','2025-10-02 13:09:45','2025-10-02 13:09:45',1),(632,'ef37c5e7-f078-42ef-9403-bff6103a0870','hw_cdrom_bus','sata','2025-10-02 13:09:37','2025-10-02 13:09:45','2025-10-02 13:09:45',1),(633,'ef37c5e7-f078-42ef-9403-bff6103a0870','hw_disk_bus','virtio','2025-10-02 13:09:37','2025-10-02 13:09:45','2025-10-02 13:09:45',1),(634,'ef37c5e7-f078-42ef-9403-bff6103a0870','hw_input_bus','usb','2025-10-02 13:09:37','2025-10-02 13:09:45','2025-10-02 13:09:45',1),(635,'ef37c5e7-f078-42ef-9403-bff6103a0870','hw_pointer_model','usbtablet','2025-10-02 13:09:37','2025-10-02 13:09:45','2025-10-02 13:09:45',1),(636,'ef37c5e7-f078-42ef-9403-bff6103a0870','hw_video_model','virtio','2025-10-02 13:09:37','2025-10-02 13:09:45','2025-10-02 13:09:45',1),(637,'ef37c5e7-f078-42ef-9403-bff6103a0870','hw_vif_model','virtio','2025-10-02 13:09:37','2025-10-02 13:09:45','2025-10-02 13:09:45',1),(638,'ef37c5e7-f078-42ef-9403-bff6103a0870','instance_uuid','0f002be2-0f9d-4b3b-a8b2-552c569f0d28','2025-10-02 13:09:37','2025-10-02 13:09:45','2025-10-02 13:09:45',1),(639,'ef37c5e7-f078-42ef-9403-bff6103a0870','user_id','29c8a28c5bdd4feb9412127428bf0c3b','2025-10-02 13:09:37','2025-10-02 13:09:45','2025-10-02 13:09:45',1),(640,'ef37c5e7-f078-42ef-9403-bff6103a0870','image_type','snapshot','2025-10-02 13:09:37','2025-10-02 13:09:45','2025-10-02 13:09:45',1),(641,'ef37c5e7-f078-42ef-9403-bff6103a0870','owner_id','60bfd415ee154615b20dd99528061614','2025-10-02 13:09:37','2025-10-02 13:09:45','2025-10-02 13:09:45',1),(642,'ef37c5e7-f078-42ef-9403-bff6103a0870','image_location','snapshot','2025-10-02 13:09:37','2025-10-02 13:09:45','2025-10-02 13:09:45',1),(643,'ef37c5e7-f078-42ef-9403-bff6103a0870','image_state','available','2025-10-02 13:09:37','2025-10-02 13:09:45','2025-10-02 13:09:45',1),(644,'ef37c5e7-f078-42ef-9403-bff6103a0870','version','8.0','2025-10-02 13:09:37','2025-10-02 13:09:45','2025-10-02 13:09:45',1),(645,'f1af818e-71fa-4f13-bb73-d787866237a6','signature_verified','False','2025-10-02 13:12:20','2025-10-02 13:13:37','2025-10-02 13:13:37',1),(646,'f1af818e-71fa-4f13-bb73-d787866237a6','hw_rng_model','virtio','2025-10-02 13:12:20','2025-10-02 13:13:37','2025-10-02 13:13:37',1),(647,'f1af818e-71fa-4f13-bb73-d787866237a6','base_image_ref','','2025-10-02 13:12:20','2025-10-02 13:13:37','2025-10-02 13:13:37',1),(648,'f1af818e-71fa-4f13-bb73-d787866237a6','owner_user_name','tempest-TestVolumeBootPattern-1200415020-project-member','2025-10-02 13:12:20','2025-10-02 13:13:37','2025-10-02 13:13:37',1),(649,'f1af818e-71fa-4f13-bb73-d787866237a6','owner_project_name','tempest-TestVolumeBootPattern-1200415020','2025-10-02 13:12:20','2025-10-02 13:13:37','2025-10-02 13:13:37',1),(650,'f1af818e-71fa-4f13-bb73-d787866237a6','boot_roles','member,reader','2025-10-02 13:12:20','2025-10-02 13:13:37','2025-10-02 13:13:37',1),(651,'f1af818e-71fa-4f13-bb73-d787866237a6','hw_machine_type','q35','2025-10-02 13:12:20','2025-10-02 13:13:37','2025-10-02 13:13:37',1),(652,'f1af818e-71fa-4f13-bb73-d787866237a6','hw_cdrom_bus','sata','2025-10-02 13:12:20','2025-10-02 13:13:37','2025-10-02 13:13:37',1),(653,'f1af818e-71fa-4f13-bb73-d787866237a6','hw_disk_bus','virtio','2025-10-02 13:12:20','2025-10-02 13:13:37','2025-10-02 13:13:37',1),(654,'f1af818e-71fa-4f13-bb73-d787866237a6','hw_input_bus','usb','2025-10-02 13:12:20','2025-10-02 13:13:37','2025-10-02 13:13:37',1),(655,'f1af818e-71fa-4f13-bb73-d787866237a6','hw_pointer_model','usbtablet','2025-10-02 13:12:20','2025-10-02 13:13:37','2025-10-02 13:13:37',1),(656,'f1af818e-71fa-4f13-bb73-d787866237a6','hw_video_model','virtio','2025-10-02 13:12:20','2025-10-02 13:13:37','2025-10-02 13:13:37',1),(657,'f1af818e-71fa-4f13-bb73-d787866237a6','hw_vif_model','virtio','2025-10-02 13:12:20','2025-10-02 13:13:37','2025-10-02 13:13:37',1),(658,'f1af818e-71fa-4f13-bb73-d787866237a6','root_device_name','/dev/vda','2025-10-02 13:12:20','2025-10-02 13:13:37','2025-10-02 13:13:37',1),(659,'f1af818e-71fa-4f13-bb73-d787866237a6','block_device_mapping','[{\"no_device\": null, \"tag\": null, \"device_type\": \"disk\", \"destination_type\": \"volume\", \"encryption_options\": null, \"image_id\": null, \"encryption_secret_uuid\": null, \"disk_bus\": \"virtio\", \"delete_on_termination\": true, \"snapshot_id\": \"aa979228-d578-4819-bd72-9a5d1ac2ab6f\", \"source_type\": \"snapshot\", \"volume_size\": 1, \"volume_type\": null, \"boot_index\": 0, \"encryption_format\": null, \"volume_id\": null, \"guest_format\": null, \"encrypted\": null, \"device_name\": \"/dev/vda\"}]','2025-10-02 13:12:20','2025-10-02 13:13:37','2025-10-02 13:13:37',1),(660,'f1af818e-71fa-4f13-bb73-d787866237a6','bdm_v2','True','2025-10-02 13:12:20','2025-10-02 13:13:37','2025-10-02 13:13:37',1);
/*!40000 ALTER TABLE `image_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_tags`
--

DROP TABLE IF EXISTS `image_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_tags_image_id` (`image_id`),
  KEY `ix_image_tags_image_id_tag_value` (`image_id`,`value`),
  CONSTRAINT `image_tags_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_tags`
--

LOCK TABLES `image_tags` WRITE;
/*!40000 ALTER TABLE `image_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `disk_format` varchar(20) DEFAULT NULL,
  `container_format` varchar(20) DEFAULT NULL,
  `checksum` varchar(32) DEFAULT NULL,
  `owner` varchar(255) DEFAULT NULL,
  `min_disk` int(11) NOT NULL,
  `min_ram` int(11) NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT 0,
  `virtual_size` bigint(20) DEFAULT NULL,
  `visibility` enum('private','public','shared','community') NOT NULL DEFAULT 'shared',
  `os_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `os_hash_algo` varchar(64) DEFAULT NULL,
  `os_hash_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checksum_image_idx` (`checksum`),
  KEY `ix_images_deleted` (`deleted`),
  KEY `owner_image_idx` (`owner`),
  KEY `created_at_image_idx` (`created_at`),
  KEY `updated_at_image_idx` (`updated_at`),
  KEY `visibility_image_idx` (`visibility`),
  KEY `os_hidden_image_idx` (`os_hidden`),
  KEY `os_hash_value_image_idx` (`os_hash_value`),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`protected` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` (`id`, `name`, `size`, `status`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `disk_format`, `container_format`, `checksum`, `owner`, `min_disk`, `min_ram`, `protected`, `virtual_size`, `visibility`, `os_hidden`, `os_hash_algo`, `os_hash_value`) VALUES ('0b7cb45b-4756-4516-aac2-0c994d6cef99','tempest-ImagesOneServerNegativeTestJSON-image-1636298996',NULL,'deleted','2025-10-02 12:15:31','2025-10-02 12:15:32','2025-10-02 12:15:32',1,NULL,NULL,NULL,'3204d74f349d47fda3152d9d7fbea43e',1,0,0,NULL,'private',0,NULL,NULL),('11a037e0-306c-4ca3-91ab-08e92bb1fae5','tempest-test-snap-900781146',1073741824,'deleted','2025-10-02 12:12:54','2025-10-02 12:13:19','2025-10-02 12:13:19',1,'raw','bare',NULL,'55d20ae21b6d4f0abfff3bccc371ee7a',1,0,0,NULL,'private',0,NULL,NULL),('2008c515-5405-4e2a-af36-731c08b54231','tempest-test-snap-1943180087',1073741824,'deleted','2025-10-02 12:12:18','2025-10-02 12:12:31','2025-10-02 12:12:31',1,'raw','bare',NULL,'55d20ae21b6d4f0abfff3bccc371ee7a',1,0,0,NULL,'private',0,NULL,NULL),('2410127a-756e-4057-a962-4fe35566fc7f','tempest-backup-2-773632485',1073741824,'deleted','2025-10-02 12:20:43','2025-10-02 12:21:04','2025-10-02 12:21:04',1,'raw','bare',NULL,'10fff81da7a54740a53a0771ce916329',1,0,0,NULL,'private',0,NULL,NULL),('25a70251-d8a8-4d2b-8882-5f0b56cee70f','tempest-ListImageFiltersTestJSON-image-427116693',1024,'deleted','2025-10-02 12:16:24','2025-10-02 12:17:28','2025-10-02 12:17:28',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','1f9bd65bc7864ca18e1c478ef7e03926',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('3242b862-74d4-4558-9399-2a866969329a','tempest-ListImageFiltersTestJSON-image-1762843169',1073741824,'deleted','2025-10-02 12:16:40','2025-10-02 12:17:16','2025-10-02 12:17:16',1,'raw','bare',NULL,'1f9bd65bc7864ca18e1c478ef7e03926',1,0,0,NULL,'private',0,NULL,NULL),('3523f109-02ae-486e-b16d-f10c6a8b2ed0','tempest-ListImageFiltersTestJSON-image-87462281',1024,'deleted','2025-10-02 12:16:21','2025-10-02 12:17:29','2025-10-02 12:17:29',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','1f9bd65bc7864ca18e1c478ef7e03926',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('358aa82b-067b-458c-9095-e40a3a914f59','tempest-ListImageFiltersTestJSON-image-612502723',1073741824,'deleted','2025-10-02 12:16:50','2025-10-02 12:17:13','2025-10-02 12:17:13',1,'raw','bare',NULL,'1f9bd65bc7864ca18e1c478ef7e03926',1,0,0,NULL,'private',0,NULL,NULL),('37de6150-c476-48f0-b3f4-9bad2557dfc2','tempest-test-snap-2026546961',NULL,'deleted','2025-10-02 12:13:35','2025-10-02 12:13:36','2025-10-02 12:13:36',1,NULL,NULL,NULL,'55d20ae21b6d4f0abfff3bccc371ee7a',1,0,0,NULL,'private',0,NULL,NULL),('38df317e-b7ae-4b50-a396-8480c76b07ca','tempest-image-573671668',1040,'deleted','2025-10-02 12:08:43','2025-10-02 12:08:48','2025-10-02 12:08:48',1,'qcow2','bare','82a1d4a02029546a1acd244179b1f970','0ccdf5205a8f4bdbae2e3fd11807d5fb',0,129,0,NULL,'private',0,'sha512','0f56cb10f9bd0a1dc8f4fb22413e2f32eca2eed8117c04defdcea80afbe9343cf4ece247f0b9e30b633feb7626ed0ad1cc3ea6eb369f6e3f504d76a28f5a66f9'),('4b2241f1-ae4c-491b-8811-8c9dd1f13160','tempest-backup-3-2065628536',1073741824,'deleted','2025-10-02 12:20:50','2025-10-02 12:21:03','2025-10-02 12:21:03',1,'raw','bare',NULL,'10fff81da7a54740a53a0771ce916329',1,0,0,NULL,'private',0,NULL,NULL),('5428ba77-2370-48a0-8396-a85c08f86505','tempest-ServerStableDeviceRescueTest-image-595820982',1073741824,'deleted','2025-10-02 12:48:31','2025-10-02 12:55:13','2025-10-02 12:55:13',1,'raw','bare',NULL,'6a442bc513e14406b73e96e70396e6c3',1,0,0,NULL,'private',0,NULL,NULL),('6225d2a0-8cbb-42ed-9a0a-13744b0f7ae4','tempest-scenario-img--534925320',21430272,'deleted','2025-10-02 12:43:34','2025-10-02 12:45:34','2025-10-02 12:45:34',1,'qcow2','bare','c8fc807773e5354afe61636071771906','2e53064cd4d645f09bd59bbca09b98e0',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('656ad3f4-b233-4eb8-822c-07efc986a6e0','tempest-AttachVolumeShelveTestJSON-server-639305243-shelved',1073741824,'deleted','2025-10-02 12:34:43','2025-10-02 12:36:01','2025-10-02 12:36:01',1,'raw','bare',NULL,'1a05e525420b4aa8adcc9561158e73d1',1,0,0,NULL,'private',0,NULL,NULL),('69218608-9c78-4f65-a885-9cb0c1edca97','tempest-ServersNegativeTestJSON-server-757604995-shelved',1073741824,'deleted','2025-10-02 12:23:31','2025-10-02 12:24:03','2025-10-02 12:24:03',1,'raw','bare',NULL,'c740a14d1c5c45d1a0959b0e24ac460b',1,0,0,NULL,'private',0,NULL,NULL),('6adae2f0-2d5d-4fab-88e2-2a0e5685e8f9','tempest-backup-1-1152258726',1073741824,'deleted','2025-10-02 12:20:36','2025-10-02 12:20:59','2025-10-02 12:20:59',1,'raw','bare',NULL,'10fff81da7a54740a53a0771ce916329',1,0,0,NULL,'private',0,NULL,NULL),('6cb20915-4f3a-4331-8e5e-9cacc75a0090','tempest-image-1549662519',1073741824,'deleted','2025-10-02 12:10:30','2025-10-02 12:10:41','2025-10-02 12:10:41',1,'raw','bare',NULL,'07abaa757bde49eead1d80ce844ec6ba',1,0,0,NULL,'private',0,NULL,NULL),('6e6f7317-b757-4c70-b900-2266125b88d4','tempest-test-snap-1989647829',1073741824,'deleted','2025-10-02 12:10:46','2025-10-02 12:10:58','2025-10-02 12:10:58',1,'raw','bare',NULL,'55d20ae21b6d4f0abfff3bccc371ee7a',1,0,0,NULL,'private',0,NULL,NULL),('766f42a5-3020-41dc-a077-fda5642a1d60','tempest-AttachVolumeShelveTestJSON-server-2076879726-shelved',1073741824,'deleted','2025-10-02 12:37:26','2025-10-02 12:38:14','2025-10-02 12:38:14',1,'raw','bare',NULL,'1a05e525420b4aa8adcc9561158e73d1',1,0,0,NULL,'private',0,NULL,NULL),('7aeb8031-5492-47ae-a269-5cc3e1a66a2a','tempest-DeleteServersTestJSON-server-97811332-shelved',1073741824,'deleted','2025-10-02 12:21:26','2025-10-02 12:22:00','2025-10-02 12:22:00',1,'raw','bare',NULL,'1c2c11ebecb14f3188f35ea473c4ca02',1,0,0,NULL,'private',0,NULL,NULL),('7f3fdab7-d2d5-41be-9174-42e3a9caee7b','tempest-ImagesOneServerNegativeTestJSON-image-461208495',NULL,'deleted','2025-10-02 12:14:38','2025-10-02 12:14:39','2025-10-02 12:14:39',1,NULL,NULL,NULL,'3204d74f349d47fda3152d9d7fbea43e',1,0,0,NULL,'private',0,NULL,NULL),('856e53ca-7fff-4728-88ae-8118b60bc057','tempest-₡-1745464635',1073741824,'deleted','2025-10-02 12:10:42','2025-10-02 12:10:55','2025-10-02 12:10:55',1,'raw','bare',NULL,'07abaa757bde49eead1d80ce844ec6ba',1,0,0,NULL,'private',0,NULL,NULL),('881d7140-1aef-4d5d-b04d-76b7b19d6837','tempest-scenario-img--1133442680',21430272,'deleted','2025-10-02 12:41:20','2025-10-02 12:43:34','2025-10-02 12:43:34',1,'qcow2','bare','c8fc807773e5354afe61636071771906','2e53064cd4d645f09bd59bbca09b98e0',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('8aa41919-15c5-43d9-ac12-d18997b6c8f0','tempest-ServerBootFromVolumeStableRescueTest-image-1349704941',1073741824,'deleted','2025-10-02 12:19:04','2025-10-02 12:20:25','2025-10-02 12:20:25',1,'raw','bare',NULL,'8efba404696b40fbbaa6431b934b87f1',1,0,0,NULL,'private',0,NULL,NULL),('9ba2a4cf-08bb-442a-b063-4fb551df3759',NULL,21430272,'deleted','2025-10-02 12:07:14','2025-10-02 12:08:26','2025-10-02 12:08:26',1,'qcow2','bare','c8fc807773e5354afe61636071771906','d650efcc52d9448da536370064e1794d',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('a1241e22-2f30-42e3-8072-a21ad0ab0f69','tempest-TestSnapshotPatternsnapshot-685976860',1073741824,'deleted','2025-10-02 13:08:33','2025-10-02 13:09:51','2025-10-02 13:09:51',1,'raw','bare',NULL,'60bfd415ee154615b20dd99528061614',1,0,0,NULL,'private',0,NULL,NULL),('a5e65e3c-7180-41c3-815b-a56c1c0389b1','tempest-UnshelveToHostMultiNodesTest-server-1602823290-shelved',1073741824,'deleted','2025-10-02 12:05:44','2025-10-02 12:06:17','2025-10-02 12:06:17',1,'raw','bare',NULL,'39f16ad971c74b0296dabeb9b59464da',1,0,0,NULL,'private',0,NULL,NULL),('a62d470f-f755-4a5a-b8e5-0dc1be0600d1','tempest-TestStampPatternsnapshot-1647522224',1073741824,'deleted','2025-10-02 12:48:00','2025-10-02 12:49:24','2025-10-02 12:49:24',1,'raw','bare',NULL,'a837417d42da439cb794b4295bca2cee',1,0,0,NULL,'private',0,NULL,NULL),('a79596af-3e62-4e36-b88e-7847340ca72b','tempest-backup-1-1819075634',NULL,'deleted','2025-10-02 12:16:07','2025-10-02 12:16:08','2025-10-02 12:16:08',1,'qcow2','bare',NULL,'6796bbb960be4c70b7177bff719e7ac0',1,0,0,NULL,'private',0,NULL,NULL),('b25d743c-aae4-4c6f-a9cb-a03c63b08b2c','tempest-ServerStableDeviceRescueTest-image-257668238',1073741824,'deleted','2025-10-02 12:49:23','2025-10-02 12:55:07','2025-10-02 12:55:07',1,'raw','bare',NULL,'6a442bc513e14406b73e96e70396e6c3',1,0,0,NULL,'private',0,NULL,NULL),('b6b477f5-f929-4c8c-a864-0bf66fee68a2','tempest-TestShelveInstance-server-561749725-shelved',1073741824,'deleted','2025-10-02 12:42:46','2025-10-02 12:43:29','2025-10-02 12:43:29',1,'raw','bare',NULL,'4b8f9114c7ab4b6e9fc9650d4bd08af9',1,0,0,NULL,'private',0,NULL,NULL),('bed55885-843b-4de0-bacc-58bcdc0a44ca','tempest-UnshelveToHostMultiNodesTest-server-1602823290-shelved',1073741824,'deleted','2025-10-02 12:04:43','2025-10-02 12:05:40','2025-10-02 12:05:40',1,'raw','bare',NULL,'39f16ad971c74b0296dabeb9b59464da',1,0,0,NULL,'private',0,NULL,NULL),('c2d0c2bc-fe21-4689-86ae-d6728c15874c','cirros-0.6.2-x86_64-disk.img',21430272,'active','2025-10-02 11:57:41','2025-10-02 11:57:45',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','1533ac528d35434c826050eed402afba',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('c899ce5c-6879-41fc-92e4-79bd307b464d','tempest-ServerStableDeviceRescueTest-image-2146853874',1073741824,'deleted','2025-10-02 12:52:08','2025-10-02 12:54:47','2025-10-02 12:54:47',1,'raw','bare',NULL,'6a442bc513e14406b73e96e70396e6c3',1,0,0,NULL,'private',0,NULL,NULL),('c9b30ff1-d6cd-4854-b30d-a4ebbd02d3dc','multiattach-snapshot',0,'deleted','2025-10-02 12:32:39','2025-10-02 12:32:51','2025-10-02 12:32:51',1,'qcow2','bare','d41d8cd98f00b204e9800998ecf8427e','5533aaac08cd4856af72ef4992bb5e76',1,0,0,NULL,'private',0,'sha512','cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e'),('cf521338-6de6-477f-b445-df9c97d57576','tempest-ServerActionsTestOtherB-server-1375297496-shelved',1073741824,'deleted','2025-10-02 12:24:57','2025-10-02 12:26:17','2025-10-02 12:26:17',1,'raw','bare',NULL,'10fff81da7a54740a53a0771ce916329',1,0,0,NULL,'private',0,NULL,NULL),('cf693858-d747-42e7-8f75-d6c36d36cc6c','tempest-ServerActionsTestOtherB-server-1305802395-shelved',1073741824,'deleted','2025-10-02 12:25:16','2025-10-02 12:26:13','2025-10-02 12:26:13',1,'raw','bare',NULL,'10fff81da7a54740a53a0771ce916329',1,0,0,NULL,'private',0,NULL,NULL),('db05f54c-61f8-42d6-a1e2-da3219a77b12','cirros-0.6.2-x86_64-disk.img_alt',21430272,'active','2025-10-02 11:57:47','2025-10-02 11:57:49',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','1533ac528d35434c826050eed402afba',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('e3ec26e3-5879-4ab0-bb2c-bf8f5cbdc0c0','tempest-ServerStableDeviceRescueTest-image-1873685482',1073741824,'deleted','2025-10-02 12:50:16','2025-10-02 12:55:00','2025-10-02 12:55:00',1,'raw','bare',NULL,'6a442bc513e14406b73e96e70396e6c3',1,0,0,NULL,'private',0,NULL,NULL),('e7ad18e6-654f-48ae-a957-a50e1a2c7a2d','tempest-ServerBootFromVolumeStableRescueTest-image-1775114270',1073741824,'deleted','2025-10-02 12:17:01','2025-10-02 12:20:34','2025-10-02 12:20:34',1,'raw','bare',NULL,'8efba404696b40fbbaa6431b934b87f1',1,0,0,NULL,'private',0,NULL,NULL),('ed9bbd8f-0e2a-4deb-9139-680228c87f79','tempest-ListImageFiltersTestJSON-image-1276212652',1024,'deleted','2025-10-02 12:16:27','2025-10-02 12:17:26','2025-10-02 12:17:26',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','1f9bd65bc7864ca18e1c478ef7e03926',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('ee6de086-2d75-4b23-a7d9-2ce77c5806eb','tempest-image-984292658',1024,'deleted','2025-10-02 12:09:23','2025-10-02 12:09:45','2025-10-02 12:09:45',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','f56efb617fd14085996f998142cfe1dc',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('ef37c5e7-f078-42ef-9403-bff6103a0870','tempest-TestSnapshotPatternsnapshot-1143862391',1073741824,'deleted','2025-10-02 13:09:37','2025-10-02 13:09:45','2025-10-02 13:09:45',1,'raw','bare',NULL,'60bfd415ee154615b20dd99528061614',1,0,0,NULL,'private',0,NULL,NULL),('f1af818e-71fa-4f13-bb73-d787866237a6','tempest-TestVolumeBootPatternsnapshot-957026105',0,'deleted','2025-10-02 13:12:20','2025-10-02 13:13:37','2025-10-02 13:13:37',1,'qcow2','bare','d41d8cd98f00b204e9800998ecf8427e','fbbc6cb494464fd9b31f64c1ad75fa6b',1,0,0,NULL,'private',0,'sha512','cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e'),('f396cccc-8bcd-476b-8403-dd0820708c77','tempest-test-snap-1682843751',1073741824,'deleted','2025-10-02 12:11:38','2025-10-02 12:11:52','2025-10-02 12:11:52',1,'raw','bare',NULL,'55d20ae21b6d4f0abfff3bccc371ee7a',1,0,0,NULL,'private',0,NULL,NULL),('fdcd4413-2e65-4120-9e32-9681c702a01f','tempest-scenario-img--1874445515',21430272,'deleted','2025-10-02 12:40:15','2025-10-02 12:44:20','2025-10-02 12:44:20',1,'qcow2','bare','c8fc807773e5354afe61636071771906','a41d99312f014c65adddea4f70536a15',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('fdf855eb-5dbd-44e1-9b72-cac174cddd41','tempest-ListImageFiltersTestJSON-image-871042829',1073741824,'deleted','2025-10-02 12:16:57','2025-10-02 12:17:12','2025-10-02 12:17:12',1,'raw','bare',NULL,'1f9bd65bc7864ca18e1c478ef7e03926',1,0,0,NULL,'private',0,NULL,NULL);
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespace_resource_types`
--

DROP TABLE IF EXISTS `metadef_namespace_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespace_resource_types` (
  `resource_type_id` int(11) NOT NULL,
  `namespace_id` int(11) NOT NULL,
  `properties_target` varchar(80) DEFAULT NULL,
  `prefix` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`resource_type_id`,`namespace_id`),
  KEY `ix_metadef_ns_res_types_namespace_id` (`namespace_id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_2` FOREIGN KEY (`resource_type_id`) REFERENCES `metadef_resource_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespace_resource_types`
--

LOCK TABLES `metadef_namespace_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_namespace_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_namespace_resource_types` (`resource_type_id`, `namespace_id`, `properties_target`, `prefix`, `created_at`, `updated_at`) VALUES (1,1,'image','CIM_PASD_','2025-10-02 11:11:52',NULL),(1,2,'image','CIM_RASD_','2025-10-02 11:11:52',NULL),(1,3,NULL,'CIM_SASD_','2025-10-02 11:11:52',NULL),(1,9,'image','hw_','2025-10-02 11:11:53',NULL),(1,10,'image','hw_','2025-10-02 11:11:53',NULL),(1,14,'image',NULL,'2025-10-02 11:11:53',NULL),(1,19,'image','hw_','2025-10-02 11:11:54',NULL),(1,25,'image','hw_','2025-10-02 11:11:56',NULL),(1,29,'image',NULL,'2025-10-02 11:11:58',NULL),(1,30,'image',NULL,'2025-10-02 11:11:59',NULL),(1,31,'image',NULL,'2025-10-02 11:12:00',NULL),(1,32,'image',NULL,'2025-10-02 11:12:00',NULL),(2,1,NULL,'CIM_PASD_','2025-10-02 11:11:52',NULL),(2,8,NULL,'hw_','2025-10-02 11:11:53',NULL),(2,9,NULL,'hw_','2025-10-02 11:11:53',NULL),(2,10,NULL,'hw_','2025-10-02 11:11:53',NULL),(2,11,NULL,NULL,'2025-10-02 11:11:53',NULL),(2,13,NULL,NULL,'2025-10-02 11:11:53',NULL),(2,14,NULL,NULL,'2025-10-02 11:11:53',NULL),(2,15,NULL,NULL,'2025-10-02 11:11:53',NULL),(2,16,NULL,'hw_','2025-10-02 11:11:53',NULL),(2,19,NULL,'hw_','2025-10-02 11:11:54',NULL),(2,22,NULL,NULL,'2025-10-02 11:11:55',NULL),(2,23,NULL,'hw_','2025-10-02 11:11:55',NULL),(2,24,NULL,'traits:','2025-10-02 11:11:56',NULL),(2,25,NULL,'hw_','2025-10-02 11:11:56',NULL),(2,26,NULL,NULL,'2025-10-02 11:11:57',NULL),(2,28,NULL,NULL,'2025-10-02 11:11:58',NULL),(2,29,NULL,NULL,'2025-10-02 11:11:58',NULL),(2,30,NULL,NULL,'2025-10-02 11:11:59',NULL),(2,31,NULL,NULL,'2025-10-02 11:12:00',NULL),(2,32,NULL,NULL,'2025-10-02 11:12:00',NULL),(2,33,NULL,'cinder_','2025-10-02 11:12:00',NULL),(3,1,NULL,'CIM_PASD_','2025-10-02 11:11:52',NULL),(3,2,NULL,'CIM_RASD_','2025-10-02 11:11:52',NULL),(3,3,NULL,'CIM_SASD_','2025-10-02 11:11:52',NULL),(3,4,NULL,'CIM_VSSD_','2025-10-02 11:11:53',NULL),(3,5,NULL,NULL,'2025-10-02 11:11:53',NULL),(3,6,NULL,NULL,'2025-10-02 11:11:53',NULL),(3,7,NULL,NULL,'2025-10-02 11:11:53',NULL),(3,12,NULL,'aggregate_instance_extra_specs:','2025-10-02 11:11:53',NULL),(4,1,NULL,'CIM_PASD_','2025-10-02 11:11:52',NULL),(4,2,NULL,'CIM_RASD_','2025-10-02 11:11:52',NULL),(4,3,NULL,'CIM_SASD_','2025-10-02 11:11:52',NULL),(4,4,NULL,'CIM_VSSD_','2025-10-02 11:11:53',NULL),(4,8,NULL,'hw:','2025-10-02 11:11:53',NULL),(4,9,NULL,'hw:','2025-10-02 11:11:53',NULL),(4,10,NULL,'hw:','2025-10-02 11:11:53',NULL),(4,12,NULL,'capabilities:','2025-10-02 11:11:53',NULL),(4,16,NULL,'hw:','2025-10-02 11:11:53',NULL),(4,17,NULL,NULL,'2025-10-02 11:11:54',NULL),(4,18,NULL,NULL,'2025-10-02 11:11:54',NULL),(4,19,NULL,'hw:','2025-10-02 11:11:54',NULL),(4,20,NULL,NULL,'2025-10-02 11:11:54',NULL),(4,21,NULL,NULL,'2025-10-02 11:11:54',NULL),(4,23,NULL,'hw:','2025-10-02 11:11:55',NULL),(4,24,NULL,'traits:','2025-10-02 11:11:56',NULL),(4,25,NULL,'hw:','2025-10-02 11:11:56',NULL),(5,1,'scheduler_hints',NULL,'2025-10-02 11:11:52',NULL),(5,30,'metadata',NULL,'2025-10-02 11:11:59',NULL),(5,31,'metadata',NULL,'2025-10-02 11:12:00',NULL),(5,32,'metadata',NULL,'2025-10-02 11:12:00',NULL),(6,30,NULL,NULL,'2025-10-02 11:11:59',NULL);
/*!40000 ALTER TABLE `metadef_namespace_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespaces`
--

DROP TABLE IF EXISTS `metadef_namespaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespaces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace` varchar(80) NOT NULL,
  `display_name` varchar(80) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `visibility` varchar(32) DEFAULT NULL,
  `protected` tinyint(1) DEFAULT NULL,
  `owner` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_namespaces_namespace` (`namespace`),
  KEY `ix_metadef_namespaces_owner` (`owner`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespaces`
--

LOCK TABLES `metadef_namespaces` WRITE;
/*!40000 ALTER TABLE `metadef_namespaces` DISABLE KEYS */;
INSERT INTO `metadef_namespaces` (`id`, `namespace`, `display_name`, `description`, `visibility`, `protected`, `owner`, `created_at`, `updated_at`) VALUES (1,'CIM::ProcessorAllocationSettingData','CIM Processor Allocation Setting','Properties related to the resource allocation settings of a processor (CPU) from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These are properties that identify processor setting data and may be specified to volume, image, host aggregate, flavor and Nova server as scheduler hint. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ProcessorAllocationSettingData.html.','public',1,'admin','2025-10-02 11:11:52',NULL),(2,'CIM::ResourceAllocationSettingData','CIM Resource Allocation Setting Data','Properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim) that represent settings specifically related to an allocated resource that are outside the scope of the CIM class typically used to represent the resource itself. These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ResourceAllocationSettingData.html.','public',1,'admin','2025-10-02 11:11:52',NULL),(3,'CIM::StorageAllocationSettingData','CIM Storage Allocation Setting Data','Properties related to the allocation of virtual storage from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_StorageAllocationSettingData.html.','public',1,'admin','2025-10-02 11:11:52',NULL),(4,'CIM::VirtualSystemSettingData','CIM Virtual System Setting Data','A set of virtualization specific properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim), which define the virtual aspects of a virtual system. These properties may be specified to host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_VirtualSystemSettingData.html.','public',1,'admin','2025-10-02 11:11:53',NULL),(5,'OS::Compute::AggregateDiskFilter','Disk Allocation per Host','Properties related to the Nova scheduler filter AggregateDiskFilter. Filters aggregate hosts based on the available disk space compared to the requested disk space. Hosts in the aggregate with not enough usable disk will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-10-02 11:11:53',NULL),(6,'OS::Compute::AggregateIoOpsFilter','IO Ops per Host','Properties related to the Nova scheduler filter AggregateIoOpsFilter. Filters aggregate hosts based on the number of instances currently changing state. Hosts in the aggregate with too many instances changing state will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-10-02 11:11:53',NULL),(7,'OS::Compute::AggregateNumInstancesFilter','Instances per Host','Properties related to the Nova scheduler filter AggregateNumInstancesFilter. Filters aggregate hosts by the number of running instances on it. Hosts in the aggregate with too many instances will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',0,'admin','2025-10-02 11:11:53',NULL),(8,'OS::Compute::CPUMode','CPU Mode','This provides the preferred CPU Model to be used when booting up a guest VM.','public',NULL,'admin','2025-10-02 11:11:53',NULL),(9,'OS::Compute::CPUPinning','CPU Pinning','This provides the preferred CPU pinning and CPU thread pinning policy to be used when pinning vCPU of the guest to pCPU of the host. See http://docs.openstack.org/admin-guide/compute-numa-cpu-pinning.html','public',1,'admin','2025-10-02 11:11:53',NULL),(10,'OS::Compute::GuestMemoryBacking','Guest Memory Backing','This provides the preferred backing option for guest RAM. Guest\'s memory can be backed by hugepages to limit TLB lookups. See also: https://wiki.openstack.org/wiki/VirtDriverGuestCPUMemoryPlacement','public',1,'admin','2025-10-02 11:11:53',NULL),(11,'OS::Compute::GuestShutdownBehavior','Shutdown Behavior','These properties allow modifying the shutdown behavior for stop, rescue, resize, and shelve operations.','public',1,'admin','2025-10-02 11:11:53',NULL),(12,'OS::Compute::HostCapabilities','Compute Host Capabilities','Hardware capabilities provided by the compute host. This provides the ability to fine tune the hardware specification required when an instance is requested. The ComputeCapabilitiesFilter should be enabled in the Nova scheduler to use these properties. When enabled, this filter checks that the capabilities provided by the compute host satisfy any extra specifications requested. Only hosts that can provide the requested capabilities will be eligible for hosting the instance.','public',1,'admin','2025-10-02 11:11:53',NULL),(13,'OS::Compute::Hypervisor','Hypervisor Selection','OpenStack Compute supports many hypervisors, although most installations use only one hypervisor. For installations with multiple supported hypervisors, you can schedule different hypervisors using the ImagePropertiesFilter. This filters compute nodes that satisfy any architecture, hypervisor type, or virtual machine mode properties specified on the instance\'s image properties.','public',1,'admin','2025-10-02 11:11:53',NULL),(14,'OS::Compute::InstanceData','Instance Config Data','Instances can perform self-configuration based on data made available to the running instance. These properties affect instance configuration.','public',1,'admin','2025-10-02 11:11:53',NULL),(15,'OS::Compute::LibvirtImage','libvirt Driver Options for Images','The libvirt Compute Driver Options for Glance Images.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-10-02 11:11:53',NULL),(16,'OS::Compute::Libvirt','libvirt Driver Options','The libvirt compute driver options.  \n\nThese are properties that affect the libvirt compute driver and may be specified on flavors and images.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-10-02 11:11:53',NULL),(17,'OS::Compute::Quota','Flavor Quota','Compute drivers may enable quotas on CPUs available to a VM, disk tuning, bandwidth I/O, and instance VIF traffic control.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-10-02 11:11:54',NULL),(18,'OS::Compute::RandomNumberGenerator','Random Number Generator','If a random-number generator device has been added to the instance through its image properties, the device can be enabled and configured.','public',1,'admin','2025-10-02 11:11:54',NULL),(19,'OS::Compute::VirtCPUTopology','Virtual CPU Topology','This provides the preferred socket/core/thread counts for the virtual CPU instance exposed to guests. This enables the ability to avoid hitting limitations on vCPU topologies that OS vendors place on their products. See also: https://opendev.org/openstack/nova-specs/src/branch/master/specs/juno/implemented/virt-driver-vcpu-topology.rst','public',1,'admin','2025-10-02 11:11:54',NULL),(20,'OS::Compute::VMwareFlavor','VMware Driver Options for Flavors','VMware Driver Options for Flavors may be used to customize and manage Nova Flavors. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-10-02 11:11:54',NULL),(21,'OS::Compute::VMwareQuotaFlavor','VMware Quota for Flavors','The VMware compute driver allows various compute quotas to be specified on flavors. When specified, the VMWare driver will ensure that the quota is enforced. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. For a list of hypervisors, see: https://wiki.openstack.org/wiki/HypervisorSupportMatrix. For flavor customization, see: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-10-02 11:11:54',NULL),(22,'OS::Compute::VMware','VMware Driver Options','The VMware compute driver options.  \n\nThese are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-10-02 11:11:55',NULL),(23,'OS::Compute::TPM','TPM Options','Configuration options for TPM','public',1,'admin','2025-10-02 11:11:55',NULL),(24,'OS::Compute::VTPM','Emulated Virtual TPM','Configuration options for Emulated Virtual TPM','public',1,'admin','2025-10-02 11:11:55',NULL),(25,'OS::Compute::Watchdog','Watchdog Behavior','Compute drivers may enable watchdog behavior over instances.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-10-02 11:11:56',NULL),(26,'OS::Compute::XenAPI','XenAPI Driver Options','The XenAPI compute driver options.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-10-02 11:11:57',NULL),(27,'OS::Glance::CommonImageProperties','Common Image Properties','When adding an image to Glance, you may specify some common image properties that may prove useful to consumers of your image.',NULL,1,'admin','2025-10-02 11:11:57',NULL),(28,'OS::Glance::Signatures','Image Signature Verification','Image signature verification allows the user to verify that an image has not been modified prior to booting the image.','public',0,'admin','2025-10-02 11:11:58',NULL),(29,'OS::OperatingSystem','Common Operating System Properties','Details of the operating system contained within this image as well as common operating system properties that can be set on a VM instance created from this image.',NULL,1,'admin','2025-10-02 11:11:58',NULL),(30,'OS::Software::DBMS','Database Software','A database is an organized collection of data. The data is typically organized to model aspects of reality in a way that supports processes requiring information. Database management systems are computer software applications that interact with the user, other applications, and the database itself to capture and analyze data. (http://en.wikipedia.org/wiki/Database)','public',1,'admin','2025-10-02 11:11:59',NULL),(31,'OS::Software::Runtimes','Runtime Environment','Software is written in a specific programming language and the language must execute within a runtime environment. The runtime environment provides an abstraction to utilizing a computer\'s processor, memory (RAM), and other system resources.','public',1,'admin','2025-10-02 11:11:59',NULL),(32,'OS::Software::WebServers','Web Servers','A web server is a computer system that processes requests via HTTP, the basic network protocol used to distribute information on the World Wide Web. The most common use of web servers is to host websites, but there are other uses such as gaming, data storage, running enterprise applications, handling email, FTP, or other web uses. (http://en.wikipedia.org/wiki/Web_server)','public',1,'admin','2025-10-02 11:12:00',NULL),(33,'OS::Cinder::Volumetype','Cinder Volume Type','The Cinder volume type configuration option. Volume type assignment provides a mechanism not only to provide scheduling to a specific storage back-end, but also can be used to specify specific information for a back-end storage device to act upon.','public',1,'admin','2025-10-02 11:12:00',NULL);
/*!40000 ALTER TABLE `metadef_namespaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_objects`
--

DROP TABLE IF EXISTS `metadef_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `description` text DEFAULT NULL,
  `required` text DEFAULT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_objects_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_objects_name` (`name`),
  CONSTRAINT `metadef_objects_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_objects`
--

LOCK TABLES `metadef_objects` WRITE;
/*!40000 ALTER TABLE `metadef_objects` DISABLE KEYS */;
INSERT INTO `metadef_objects` (`id`, `namespace_id`, `name`, `description`, `required`, `json_schema`, `created_at`, `updated_at`) VALUES (1,17,'CPU Limits','You can configure the CPU limits with control parameters.',NULL,'{\"quota:cpu_shares\": {\"title\": \"Quota: CPU Shares\", \"description\": \"Specifies the proportional weighted share for the domain. If this element is omitted, the service defaults to the OS provided defaults. There is no unit for the value; it is a relative measure based on the setting of other VMs. For example, a VM configured with value 2048 gets twice as much CPU time as a VM configured with value 1024.\", \"type\": \"integer\"}, \"quota:cpu_period\": {\"title\": \"Quota: CPU Period\", \"description\": \"Specifies the enforcement interval (unit: microseconds) for QEMU and LXC hypervisors. Within a period, each VCPU of the domain is not allowed to consume more than the quota worth of runtime. The value should be in range [1000, 1000000]. A period with value 0 means no value.\", \"type\": \"integer\", \"minimum\": 1000, \"maximum\": 1000000}, \"quota:cpu_quota\": {\"title\": \"Quota: CPU Quota\", \"description\": \"Specifies the maximum allowed bandwidth (unit: microseconds). A domain with a negative-value quota indicates that the domain has infinite bandwidth, which means that it is not bandwidth controlled. The value should be in range [1000, 18446744073709551] or less than 0. A quota with value 0 means no value. You can use this feature to ensure that all vCPUs run at the same speed.\", \"type\": \"integer\"}}','2025-10-02 11:11:54',NULL),(2,17,'Disk QoS','Using disk I/O quotas, you can set maximum disk write to 10 MB per second for a VM user.',NULL,'{\"quota:disk_read_bytes_sec\": {\"title\": \"Quota: Disk read bytes / sec\", \"description\": \"Sets disk I/O quota for disk read bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_read_iops_sec\": {\"title\": \"Quota: Disk read IOPS / sec\", \"description\": \"Sets disk I/O quota for disk read IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_write_bytes_sec\": {\"title\": \"Quota: Disk Write Bytes / sec\", \"description\": \"Sets disk I/O quota for disk write bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_write_iops_sec\": {\"title\": \"Quota: Disk Write IOPS / sec\", \"description\": \"Sets disk I/O quota for disk write IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_total_bytes_sec\": {\"title\": \"Quota: Disk Total Bytes / sec\", \"description\": \"Sets disk I/O quota for total disk bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_total_iops_sec\": {\"title\": \"Quota: Disk Total IOPS / sec\", \"description\": \"Sets disk I/O quota for disk total IOPS / sec.\", \"type\": \"integer\"}}','2025-10-02 11:11:54',NULL),(3,17,'Virtual Interface QoS','Bandwidth QoS tuning for instance virtual interfaces (VIFs) may be specified with these properties. Incoming and outgoing traffic can be shaped independently. If not specified, no quality of service (QoS) is applied on that traffic direction. So, if you want to shape only the network\'s incoming traffic, use inbound only (and vice versa). The OpenStack Networking service abstracts the physical implementation of the network, allowing plugins to configure and manage physical resources. Virtual Interfaces (VIF) in the logical model are analogous to physical network interface cards (NICs). VIFs are typically owned a managed by an external service; for instance when OpenStack Networking is used for building OpenStack networks, VIFs would be created, owned, and managed in Nova. VIFs are connected to OpenStack Networking networks via ports. A port is analogous to a port on a network switch, and it has an administrative state. When a VIF is attached to a port the OpenStack Networking API creates an attachment object, which specifies the fact that a VIF with a given identifier is plugged into the port.',NULL,'{\"quota:vif_inbound_average\": {\"title\": \"Quota: VIF Inbound Average\", \"description\": \"Network Virtual Interface (VIF) inbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_inbound_burst\": {\"title\": \"Quota: VIF Inbound Burst\", \"description\": \"Network Virtual Interface (VIF) inbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_inbound_peak\": {\"title\": \"Quota: VIF Inbound Peak\", \"description\": \"Network Virtual Interface (VIF) inbound peak in kilobytes per second. Specifies maximum rate at which an interface can receive data.\", \"type\": \"integer\"}, \"quota:vif_outbound_average\": {\"title\": \"Quota: VIF Outbound Average\", \"description\": \"Network Virtual Interface (VIF) outbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_outbound_burst\": {\"title\": \"Quota: VIF Outbound Burst\", \"description\": \"Network Virtual Interface (VIF) outbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_outbound_peak\": {\"title\": \"Quota: VIF Outbound Peak\", \"description\": \"Network Virtual Interface (VIF) outbound peak in kilobytes per second. Specifies maximum rate at which an interface can send data.\", \"type\": \"integer\"}}','2025-10-02 11:11:54',NULL),(4,30,'MySQL','MySQL is an object-relational database management system (ORDBMS). The MySQL development project has made its source code available under the terms of the GNU General Public License, as well as under a variety of proprietary agreements. MySQL was owned and sponsored by a single for-profit firm, the Swedish company MySQL AB, now owned by Oracle Corporation. MySQL is a popular choice of database for use in web applications, and is a central component of the widely used LAMP open source web application software stack (and other \'AMP\' stacks). (http://en.wikipedia.org/wiki/MySQL)',NULL,'{\"sw_database_mysql_version\": {\"title\": \"Version\", \"description\": \"The specific version of MySQL.\", \"type\": \"string\"}, \"sw_database_mysql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"The configured TCP/IP port which MySQL listens for incoming connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 3606}, \"sw_database_mysql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"root\"}}','2025-10-02 11:11:59',NULL),(5,30,'PostgreSQL','PostgreSQL, often simply \'Postgres\', is an object-relational database management system (ORDBMS) with an emphasis on extensibility and standards-compliance. PostgreSQL is cross-platform and runs on many operating systems. (http://en.wikipedia.org/wiki/PostgreSQL)',NULL,'{\"sw_database_postgresql_version\": {\"title\": \"Version\", \"description\": \"The specific version of PostgreSQL.\", \"type\": \"string\"}, \"sw_database_postgresql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which PostgreSQL is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_postgresql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"postgres\"}}','2025-10-02 11:11:59',NULL),(6,30,'SQL Server','Microsoft SQL Server is a relational database management system developed by Microsoft. There are at least a dozen different editions of Microsoft SQL Server aimed at different audiences and for workloads ranging from small single-machine applications to large Internet-facing applications with many concurrent users. Its primary query languages are T-SQL and ANSI SQL. (http://en.wikipedia.org/wiki/Microsoft_SQL_Server)',NULL,'{\"sw_database_sqlserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Microsoft SQL Server.\", \"type\": \"string\"}, \"sw_database_sqlserver_edition\": {\"title\": \"Edition\", \"description\": \"SQL Server is available in multiple editions, with different feature sets and targeting different users.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Datacenter\", \"Enterprise\", \"Standard\", \"Web\", \"Business Intelligence\", \"Workgroup\", \"Express\", \"Compact (SQL CE)\", \"Developer\", \"Embedded (SSEE)\", \"Express\", \"Fast Track\", \"LocalDB\", \"Parallel Data Warehouse (PDW)\", \"Business Intelligence\", \"Datawarehouse Appliance Edition\"]}, \"sw_database_sqlserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which SQL Server is to listen for connections from client applications. The default SQL Server port is 1433, and client ports are assigned a random value between 1024 and 5000.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1433}, \"sw_database_postsqlserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"sa\"}}','2025-10-02 11:11:59',NULL),(7,30,'Oracle','Oracle Database (commonly referred to as Oracle RDBMS or simply as Oracle) is an object-relational database management system produced and marketed by Oracle Corporation. (http://en.wikipedia.org/wiki/Oracle_Database)',NULL,'{\"sw_database_oracle_version\": {\"title\": \"Version\", \"description\": \"The specific version of Oracle.\", \"type\": \"string\"}, \"sw_database_oracle_edition\": {\"title\": \"Edition\", \"description\": \"Over and above the different versions of the Oracle database management software developed over time, Oracle Corporation subdivides its product into varying editions.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Enterprise\", \"Standard\", \"Standard Edition One\", \"Express (XE)\", \"Workgroup\", \"Lite\"]}, \"sw_database_oracle_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Oracle is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1521}}','2025-10-02 11:11:59',NULL),(8,30,'DB2','IBM DB2 is a family of database server products developed by IBM. These products all support the relational model, but in recent years some products have been extended to support object-relational features and non-relational structures, in particular XML. (http://en.wikipedia.org/wiki/IBM_DB2)',NULL,'{\"sw_database_db2_version\": {\"title\": \"Version\", \"description\": \"The specific version of DB2.\", \"type\": \"string\"}, \"sw_database_db2_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which DB2 is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_db2_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-10-02 11:11:59',NULL),(9,30,'MongoDB','MongoDB is a cross-platform document-oriented database. Classified as a NoSQL database, MongoDB uses JSON-like documents with dynamic schemas (MongoDB calls the format BSON), making the integration of data in certain types of applications easier and faster. Released under a combination of the GNU Affero General Public License and the Apache License, MongoDB is free and open-source software. (http://en.wikipedia.org/wiki/MongoDB)',NULL,'{\"sw_database_mongodb_version\": {\"title\": \"Version\", \"description\": \"The specific version of MongoDB.\", \"type\": \"string\"}, \"sw_database_mongodb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which MongoDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 27017}, \"sw_database_mongodb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-10-02 11:11:59',NULL),(10,30,'Couchbase Server','Couchbase Server, originally known as Membase, is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications. These applications must serve many concurrent users by creating, storing, retrieving, aggregating, manipulating and presenting data. In support of these kinds of application needs, Couchbase is designed to provide easy-to-scale key-value or document access with low latency and high sustained throughput. (http://en.wikipedia.org/wiki/Couchbase_Server)',NULL,'{\"sw_database_couchbaseserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Couchbase Server.\", \"type\": \"string\"}, \"sw_database_couchbaseserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Couchbase is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 11211}, \"sw_database_couchbaseserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-10-02 11:11:59',NULL),(11,30,'Redis','Redis is a data structure server (NoSQL). It is open-source, networked, in-memory, and stores keys with optional durability. The development of Redis has been sponsored by Pivotal Software since May 2013; before that, it was sponsored by VMware. The name Redis means REmote DIctionary Server. (http://en.wikipedia.org/wiki/Redis)',NULL,'{\"sw_database_redis_version\": {\"title\": \"Version\", \"description\": \"The specific version of Redis.\", \"type\": \"string\"}, \"sw_database_redis_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Redis is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 6379}, \"sw_database_redis_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-10-02 11:11:59',NULL),(12,30,'CouchDB','Apache CouchDB, commonly referred to as CouchDB, is an open source NoSQL database. It is a NoSQL database that uses JSON to store data, JavaScript as its query language using MapReduce, and HTTP for an API. One of its distinguishing features is multi-master replication. CouchDB was first released in 2005 and later became an Apache project in 2008. (http://en.wikipedia.org/wiki/CouchDB)',NULL,'{\"sw_database_couchdb_version\": {\"title\": \"Version\", \"description\": \"The specific version of CouchDB.\", \"type\": \"string\"}, \"sw_database_couchdb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which CouchDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5984}, \"sw_database_couchdb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-10-02 11:11:59',NULL),(13,30,'Apache Cassandra','Apache Cassandra is an open source distributed NoSQL database management system designed to handle large amounts of data across many commodity servers, providing high availability with no single point of failure. (http://en.wikipedia.org/wiki/Apache_Cassandra)',NULL,'{\"sw_database_cassandra_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache Cassandra.\", \"type\": \"string\"}, \"sw_database_cassandra_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Cassandra is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 9160}, \"sw_database_cassandra_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"cassandra\"}}','2025-10-02 11:11:59',NULL),(14,30,'HBase','HBase is an open source, non-relational (NoSQL), distributed database modeled after Google\'s BigTable and written in Java. It is developed as part of Apache Software Foundation\'s Apache Hadoop project and runs on top of HDFS (Hadoop Distributed Filesystem), providing BigTable-like capabilities for Hadoop. (http://en.wikipedia.org/wiki/Apache_HBase)',NULL,'{\"sw_database_hbase_version\": {\"title\": \"Version\", \"description\": \"The specific version of HBase.\", \"type\": \"string\"}}','2025-10-02 11:11:59',NULL),(15,30,'Hazlecast','In computing, Hazelcast is an in-memory open source software data grid based on Java. By having multiple nodes form a cluster, data is evenly distributed among the nodes. This allows for horizontal scaling both in terms of available storage space and processing power. Backups are also distributed in a similar fashion to other nodes, based on configuration, thereby protecting against single node failure. (http://en.wikipedia.org/wiki/Hazelcast)',NULL,'{\"sw_database_hazlecast_version\": {\"title\": \"Version\", \"description\": \"The specific version of Hazlecast.\", \"type\": \"string\"}, \"sw_database_hazlecast_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Hazlecast is to listen for connections between members.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5701}}','2025-10-02 11:11:59',NULL),(16,31,'PHP','PHP is a server-side scripting language designed for web development but also used as a general-purpose programming language. PHP code can be simply mixed with HTML code, or it can be used in combination with various templating engines and web frameworks. PHP code is usually processed by a PHP interpreter, which is usually implemented as a web server\'s native module or a Common Gateway Interface (CGI) executable. After the PHP code is interpreted and executed, the web server sends resulting output to its client, usually in form of a part of the generated web page – for example, PHP code can generate a web page\'s HTML code, an image, or some other data. PHP has also evolved to include a command-line interface (CLI) capability and can be used in standalone graphical applications. (http://en.wikipedia.org/wiki/PHP)',NULL,'{\"sw_runtime_php_version\": {\"title\": \"Version\", \"description\": \"The specific version of PHP.\", \"type\": \"string\"}}','2025-10-02 11:12:00',NULL),(17,31,'Python','Python is a widely used general-purpose, high-level programming language. Its design philosophy emphasizes code readability, and its syntax allows programmers to express concepts in fewer lines of code than would be possible in languages such as C++ or Java. The language provides constructs intended to enable clear programs on both a small and large scale. Python supports multiple programming paradigms, including object-oriented, imperative and functional programming or procedural styles. It features a dynamic type system and automatic memory management and has a large and comprehensive standard library. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_python_version\": {\"title\": \"Version\", \"description\": \"The specific version of python.\", \"type\": \"string\"}}','2025-10-02 11:12:00',NULL),(18,31,'Java','Java is a functional computer programming language that is concurrent, class-based, object-oriented, and specifically designed to have as few implementation dependencies as possible. It is intended to let application developers write once, run anywhere (WORA), meaning that code that runs on one platform does not need to be recompiled to run on another. Java applications are typically compiled to bytecode that can run on any Java virtual machine (JVM) regardless of computer architecture. (http://en.wikipedia.org/wiki/Java_(programming_language))',NULL,'{\"sw_runtime_java_version\": {\"title\": \"Version\", \"description\": \"The specific version of Java.\", \"type\": \"string\"}}','2025-10-02 11:12:00',NULL),(19,31,'Ruby','Ruby is a dynamic, reflective, object-oriented, general-purpose programming language. It was designed and developed in the mid-1990s by Yukihiro Matsumoto in Japan. According to its authors, Ruby was influenced by Perl, Smalltalk, Eiffel, Ada, and Lisp. It supports multiple programming paradigms, including functional, object-oriented, and imperative. It also has a dynamic type system and automatic memory management. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_ruby_version\": {\"title\": \"Version\", \"description\": \"The specific version of Ruby.\", \"type\": \"string\"}}','2025-10-02 11:12:00',NULL),(20,31,'Perl','Perl is a family of high-level, general-purpose, interpreted, dynamic programming languages. The languages in this family include Perl 5 and Perl 6. Though Perl is not officially an acronym, there are various backronyms in use, the most well-known being Practical Extraction and Reporting Language (http://en.wikipedia.org/wiki/Perl)',NULL,'{\"sw_runtime_perl_version\": {\"title\": \"Version\", \"description\": \"The specific version of Perl.\", \"type\": \"string\"}}','2025-10-02 11:12:00',NULL),(21,32,'Apache HTTP Server','The Apache HTTP Server, colloquially called Apache, is a Web server application notable for playing a key role in the initial growth of the World Wide Web. Apache is developed and maintained by an open community of developers under the auspices of the Apache Software Foundation. Most commonly used on a Unix-like system, the software is available for a wide variety of operating systems, including Unix, FreeBSD, Linux, Solaris, Novell NetWare, OS X, Microsoft Windows, OS/2, TPF, OpenVMS and eComStation. Released under the Apache License, Apache is open-source software. (http://en.wikipedia.org/wiki/Apache_HTTP_Server)',NULL,'{\"sw_webserver_apache_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache.\", \"type\": \"string\"}, \"sw_webserver_apache_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_apache_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-10-02 11:12:00',NULL),(22,32,'Nginx','Nginx (pronounced \'engine-x\') is an open source reverse proxy server for HTTP, HTTPS, SMTP, POP3, and IMAP protocols, as well as a load balancer, HTTP cache, and a web server (origin server). The nginx project started with a strong focus on high concurrency, high performance and low memory usage. It is licensed under the 2-clause BSD-like license and it runs on Linux, BSD variants, Mac OS X, Solaris, AIX, HP-UX, as well as on other *nix flavors. It also has a proof of concept port for Microsoft Windows. (http://en.wikipedia.org/wiki/Nginx)',NULL,'{\"sw_webserver_nginx_version\": {\"title\": \"Version\", \"description\": \"The specific version of Nginx.\", \"type\": \"string\"}, \"sw_webserver_nginx_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_nginx_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-10-02 11:12:00',NULL),(23,32,'IIS','Internet Information Services (IIS, formerly Internet Information Server) is an extensible web server created by Microsoft. IIS supports HTTP, HTTPS, FTP, FTPS, SMTP and NNTP. IIS is not turned on by default when Windows is installed. The IIS Manager is accessed through the Microsoft Management Console or Administrative Tools in the Control Panel. (http://en.wikipedia.org/wiki/Internet_Information_Services)',NULL,'{\"sw_webserver_iis_version\": {\"title\": \"Version\", \"description\": \"The specific version of IIS.\", \"type\": \"string\"}, \"sw_webserver_iis_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_iis_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-10-02 11:12:00',NULL);
/*!40000 ALTER TABLE `metadef_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_properties`
--

DROP TABLE IF EXISTS `metadef_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_properties_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_properties_name` (`name`),
  CONSTRAINT `metadef_properties_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_properties`
--

LOCK TABLES `metadef_properties` WRITE;
/*!40000 ALTER TABLE `metadef_properties` DISABLE KEYS */;
INSERT INTO `metadef_properties` (`id`, `namespace_id`, `name`, `json_schema`, `created_at`, `updated_at`) VALUES (1,1,'InstructionSet','{\"title\": \"Instruction Set\", \"description\": \"Identifies the instruction set of the processor within a processor architecture.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86:i386\", \"x86:i486\", \"x86:i586\", \"x86:i686\", \"x86:64\", \"IA-64:IA-64\", \"AS/400:TIMI\", \"Power:Power_2.03\", \"Power:Power_2.04\", \"Power:Power_2.05\", \"Power:Power_2.06\", \"S/390:ESA/390\", \"S/390:z/Architecture\", \"S/390:z/Architecture_2\", \"PA-RISC:PA-RISC_1.0\", \"PA-RISC:PA-RISC_2.0\", \"ARM:A32\", \"ARM:A64\", \"MIPS:MIPS_I\", \"MIPS:MIPS_II\", \"MIPS:MIPS_III\", \"MIPS:MIPS_IV\", \"MIPS:MIPS_V\", \"MIPS:MIPS32\", \"MIPS64:MIPS64\", \"Alpha:Alpha\", \"SPARC:SPARC_V7\", \"SPARC:SPARC_V8\", \"SPARC:SPARC_V9\", \"SPARC:SPARC_JPS1\", \"SPARC:UltraSPARC2005\", \"SPARC:UltraSPARC2007\", \"68k:68000\", \"68k:68010\", \"68k:68020\", \"68k:68030\", \"68k:68040\", \"68k:68060\"]}','2025-10-02 11:11:52',NULL),(2,1,'ProcessorArchitecture','{\"title\": \"Processor Architecture\", \"description\": \"Identifies the processor architecture of the processor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"IA-64\", \"AS/400\", \"Power\", \"S/390\", \"PA-RISC\", \"ARM\", \"MIPS\", \"Alpha\", \"SPARC\", \"68k\"]}','2025-10-02 11:11:52',NULL),(3,1,'InstructionSetExtensionName','{\"title\": \"Instruction Set Extension\", \"description\": \"Identifies the instruction set extensions of the processor within a processor architecture.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"x86:3DNow\", \"x86:3DNowExt\", \"x86:ABM\", \"x86:AES\", \"x86:AVX\", \"x86:AVX2\", \"x86:BMI\", \"x86:CX16\", \"x86:F16C\", \"x86:FSGSBASE\", \"x86:LWP\", \"x86:MMX\", \"x86:PCLMUL\", \"x86:RDRND\", \"x86:SSE2\", \"x86:SSE3\", \"x86:SSSE3\", \"x86:SSE4A\", \"x86:SSE41\", \"x86:SSE42\", \"x86:FMA3\", \"x86:FMA4\", \"x86:XOP\", \"x86:TBM\", \"x86:VT-d\", \"x86:VT-x\", \"x86:EPT\", \"x86:SVM\", \"PA-RISC:MAX\", \"PA-RISC:MAX2\", \"ARM:DSP\", \"ARM:Jazelle-DBX\", \"ARM:Thumb\", \"ARM:Thumb-2\", \"ARM:ThumbEE)\", \"ARM:VFP\", \"ARM:NEON\", \"ARM:TrustZone\", \"MIPS:MDMX\", \"MIPS:MIPS-3D\", \"Alpha:BWX\", \"Alpha:FIX\", \"Alpha:CIX\", \"Alpha:MVI\"]}}','2025-10-02 11:11:52',NULL),(4,2,'Address','{\"title\": \"Address\", \"description\": \"The address of the resource.\", \"type\": \"string\"}','2025-10-02 11:11:52',NULL),(5,2,'AddressOnParent','{\"title\": \"Address On Parent\", \"description\": \"Describes the address of this resource in the context of the Parent.\", \"type\": \"string\"}','2025-10-02 11:11:52',NULL),(6,2,'AllocationUnits','{\"title\": \"Allocation Units\", \"description\": \"This property specifies the units of allocation used by the Reservation and Limit properties.\", \"type\": \"string\"}','2025-10-02 11:11:52',NULL),(7,2,'AutomaticAllocation','{\"title\": \"Automatic Allocation\", \"description\": \"This property specifies if the resource will be automatically allocated.\", \"type\": \"boolean\"}','2025-10-02 11:11:52',NULL),(8,2,'AutomaticDeallocation','{\"title\": \"Automatic Deallocation\", \"description\": \"This property specifies if the resource will be automatically de-allocated.\", \"type\": \"boolean\"}','2025-10-02 11:11:52',NULL),(9,2,'ConsumerVisibility','{\"title\": \"Consumer Visibility\", \"description\": \"Describes the consumers visibility to the allocated resource.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Passed-Through\", \"Virtualized\", \"Not represented\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-10-02 11:11:52',NULL),(10,2,'Limit','{\"title\": \"Limit\", \"description\": \"This property specifies the upper bound, or maximum amount of resource that will be granted for this allocation.\", \"type\": \"string\"}','2025-10-02 11:11:52',NULL),(11,2,'MappingBehavior','{\"title\": \"Mapping Behavior\", \"description\": \"Specifies how this resource maps to underlying resources. If the HostResource array contains any entries, this property reflects how the resource maps to those specific resources.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Not Supported\", \"Dedicated\", \"Soft Affinity\", \"Hard Affinity\", \"DMTF Reserved\", \"Vendor Reserved\"]}','2025-10-02 11:11:52',NULL),(12,2,'OtherResourceType','{\"title\": \"Other Resource Type\", \"description\": \"A string that describes the resource type when a well defined value is not available and ResourceType has the value \'Other\'.\", \"type\": \"string\"}','2025-10-02 11:11:52',NULL),(13,2,'Parent','{\"title\": \"Parent\", \"description\": \"The Parent of the resource.\", \"type\": \"string\"}','2025-10-02 11:11:52',NULL),(14,2,'PoolID','{\"title\": \"Pool ID\", \"description\": \"This property specifies which ResourcePool the resource is currently allocated from, or which ResourcePool the resource will be allocated from when the allocation occurs.\", \"type\": \"string\"}','2025-10-02 11:11:52',NULL),(15,2,'Reservation','{\"title\": \"Reservation\", \"description\": \"This property specifies the amount of resource guaranteed to be available for this allocation.\", \"type\": \"string\"}','2025-10-02 11:11:52',NULL),(16,2,'ResourceSubType','{\"title\": \"Resource Sub Type\", \"description\": \"A string describing an implementation specific sub-type for this resource.\", \"type\": \"string\"}','2025-10-02 11:11:52',NULL),(17,2,'ResourceType','{\"title\": \"Resource Type\", \"description\": \"The type of resource this allocation setting represents.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Other\", \"Computer System\", \"Processor\", \"Memory\", \"IDE Controller\", \"Parallel SCSI HBA\", \"FC HBA\", \"iSCSI HBA\", \"IB HCA\", \"Ethernet Adapter\", \"Other Network Adapter\", \"I/O Slot\", \"I/O Device\", \"Floppy Drive\", \"CD Drive\", \"DVD drive\", \"Disk Drive\", \"Tape Drive\", \"Storage Extent\", \"Other storage device\", \"Serial port\", \"Parallel port\", \"USB Controller\", \"Graphics controller\", \"IEEE 1394 Controller\", \"Partitionable Unit\", \"Base Partitionable Unit\", \"Power\", \"Cooling Capacity\", \"Ethernet Switch Port\", \"Logical Disk\", \"Storage Volume\", \"Ethernet Connection\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-10-02 11:11:52',NULL),(18,2,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"This property specifies the quantity of resources presented to the consumer.\", \"type\": \"string\"}','2025-10-02 11:11:52',NULL),(19,2,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-10-02 11:11:52',NULL),(20,2,'Weight','{\"title\": \"Weight\", \"description\": \"This property specifies a relative priority for this allocation in relation to other allocations from the same ResourcePool.\", \"type\": \"string\"}','2025-10-02 11:11:52',NULL),(21,2,'Connection','{\"title\": \"Connection\", \"description\": \"The thing to which this resource is connected.\", \"type\": \"string\"}','2025-10-02 11:11:52',NULL),(22,2,'HostResource','{\"title\": \"Host Resource\", \"description\": \"This property exposes specific assignment of resources.\", \"type\": \"string\"}','2025-10-02 11:11:52',NULL),(23,3,'Access','{\"title\": \"Access\", \"description\": \"Access describes whether the allocated storage extent is 1 (readable), 2 (writeable), or 3 (both).\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Readable\", \"Writeable\", \"Read/Write Supported\", \"DMTF Reserved\"]}','2025-10-02 11:11:52',NULL),(24,3,'HostExtentName','{\"title\": \"Host Extent Name\", \"description\": \"A unique identifier for the host extent.\", \"type\": \"string\"}','2025-10-02 11:11:52',NULL),(25,3,'HostExtentNameFormat','{\"title\": \"Host Extent Name Format\", \"description\": \"The HostExtentNameFormat property identifies the format that is used for the value of the HostExtentName property.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"SNVM\", \"NAA\", \"EUI64\", \"T10VID\", \"OS Device Name\", \"DMTF Reserved\"]}','2025-10-02 11:11:52',NULL),(26,3,'HostExtentNameNamespace','{\"title\": \"Host Extent Name Namespace\", \"description\": \"If the host extent is a SCSI volume, then the preferred source for SCSI volume names is SCSI VPD Page 83 responses.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"VPD83Type3\", \"VPD83Type2\", \"VPD83Type1\", \"VPD80\", \"NodeWWN\", \"SNVM\", \"OS Device Namespace\", \"DMTF Reserved\"]}','2025-10-02 11:11:52',NULL),(27,3,'HostExtentStartingAddress','{\"title\": \"Host Extent Starting Address\", \"description\": \"The HostExtentStartingAddress property identifies the starting address on the host storage extent identified by the value of the HostExtentName property that is used for the allocation of the virtual storage extent.\", \"type\": \"string\"}','2025-10-02 11:11:53',NULL),(28,3,'HostResourceBlockSize','{\"title\": \"Host Resource Block Size\", \"description\": \"Size in bytes of the blocks that are allocated at the host as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-10-02 11:11:53',NULL),(29,3,'Limit','{\"title\": \"Limit\", \"description\": \"The maximum amount of blocks that will be granted for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-10-02 11:11:53',NULL),(30,3,'OtherHostExtentNameFormat','{\"title\": \"Other Host Extent Name Format\", \"description\": \"A string describing the format of the HostExtentName property if the value of the HostExtentNameFormat property is 1 (Other).\", \"type\": \"string\"}','2025-10-02 11:11:53',NULL),(31,3,'OtherHostExtentNameNamespace','{\"title\": \"Other Host Extent Name Namespace\", \"description\": \"A string describing the namespace of the HostExtentName property if the value of the HostExtentNameNamespace matches 1 (Other).\", \"type\": \"string\"}','2025-10-02 11:11:53',NULL),(32,3,'Reservation','{\"title\": \"Reservation\", \"description\": \"The amount of blocks that are guaranteed to be available for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-10-02 11:11:53',NULL),(33,3,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"Number of blocks that are presented to the consumer.\", \"type\": \"string\"}','2025-10-02 11:11:53',NULL),(34,3,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-10-02 11:11:53',NULL),(35,3,'VirtualResourceBlockSize','{\"title\": \"Virtual Resource Block Size\", \"description\": \"Size in bytes of the blocks that are presented to the consumer as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-10-02 11:11:53',NULL),(36,4,'AutomaticRecoveryAction','{\"title\": \"Automatic Recovery Action\", \"description\": \"Action to take for the virtual system when the software executed by the virtual system fails.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart\", \"Revert to snapshot\", \"DMTF Reserved\"]}','2025-10-02 11:11:53',NULL),(37,4,'AutomaticShutdownAction','{\"title\": \"Automatic Shutdown Action\", \"description\": \"Action to take for the virtual system when the host is shut down.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Turn Off\", \"Save state\", \"Shutdown\", \"DMTF Reserved\"]}','2025-10-02 11:11:53',NULL),(38,4,'AutomaticStartupAction','{\"title\": \"Automatic Startup Action\", \"description\": \"Action to take for the virtual system when the host is started.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart if previously active\", \"Always startup\", \"DMTF Reserved\"]}','2025-10-02 11:11:53',NULL),(39,4,'AutomaticStartupActionDelay','{\"title\": \"Automatic Startup Action Delay\", \"description\": \"Delay applicable to startup action.\", \"type\": \"string\"}','2025-10-02 11:11:53',NULL),(40,4,'AutomaticStartupActionSequenceNumber','{\"title\": \"Automatic Startup Action Sequence Number\", \"description\": \"Number indicating the relative sequence of virtual system activation when the host system is started.\", \"type\": \"string\"}','2025-10-02 11:11:53',NULL),(41,4,'ConfigurationDataRoot','{\"title\": \"Configuration Data Root\", \"description\": \"Filepath of a directory where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-10-02 11:11:53',NULL),(42,4,'ConfigurationFile','{\"title\": \"Configuration File\", \"description\": \"Filepath of a file where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-10-02 11:11:53',NULL),(43,4,'ConfigurationID','{\"title\": \"Configuration ID\", \"description\": \"Unique id of the virtual system configuration.\", \"type\": \"string\"}','2025-10-02 11:11:53',NULL),(44,4,'CreationTime','{\"title\": \"Creation Time\", \"description\": \"Time when the virtual system configuration was created.\", \"type\": \"string\"}','2025-10-02 11:11:53',NULL),(45,4,'LogDataRoot','{\"title\": \"Log Data Root\", \"description\": \"Filepath of a directory where log information about the virtual system is stored.\", \"type\": \"string\"}','2025-10-02 11:11:53',NULL),(46,4,'RecoveryFile','{\"title\": \"Recovery File\", \"description\": \"Filepath of a file where recovery relateded information of the virtual system is stored.\", \"type\": \"string\"}','2025-10-02 11:11:53',NULL),(47,4,'SnapshotDataRoot','{\"title\": \"Snapshot Data Root\", \"description\": \"Filepath of a directory where information about virtual system snapshots is stored.\", \"type\": \"string\"}','2025-10-02 11:11:53',NULL),(48,4,'SuspendDataRoot','{\"title\": \"Suspend Data Root\", \"description\": \"Filepath of a directory where suspend related information about the virtual system is stored.\", \"type\": \"string\"}','2025-10-02 11:11:53',NULL),(49,4,'SwapFileDataRoot','{\"title\": \"Swap File Data Root\", \"description\": \"Filepath of a directory where swapfiles of the virtual system are stored.\", \"type\": \"string\"}','2025-10-02 11:11:53',NULL),(50,4,'VirtualSystemIdentifier','{\"title\": \"Virtual System Identifier\", \"description\": \"VirtualSystemIdentifier shall reflect a unique name for the system as it is used within the virtualization platform.\", \"type\": \"string\"}','2025-10-02 11:11:53',NULL),(51,4,'VirtualSystemType','{\"title\": \"Virtual System Type\", \"description\": \"VirtualSystemType shall reflect a particular type of virtual system.\", \"type\": \"string\"}','2025-10-02 11:11:53',NULL),(52,4,'Notes','{\"title\": \"Notes\", \"description\": \"End-user supplied notes that are related to the virtual system.\", \"type\": \"string\"}','2025-10-02 11:11:53',NULL),(53,5,'disk_allocation_ratio','{\"title\": \"Disk Subscription Ratio\", \"description\": \"Allows the host to be under and over subscribed for the amount of disk space requested for an instance. A ratio greater than 1.0 allows for over subscription (hosts may have less usable disk space than requested). A ratio less than 1.0 allows for under subscription.\", \"type\": \"number\", \"readonly\": false}','2025-10-02 11:11:53',NULL),(54,6,'max_io_ops_per_host','{\"title\": \"Maximum IO Operations per Host\", \"description\": \"Prevents hosts in the aggregate that have this many or more instances currently in build, resize, snapshot, migrate, rescue or unshelve to be scheduled for new instances.\", \"type\": \"integer\", \"readonly\": false, \"default\": 8, \"minimum\": 1}','2025-10-02 11:11:53',NULL),(55,7,'max_instances_per_host','{\"title\": \"Max Instances Per Host\", \"description\": \"Maximum number of instances allowed to run on a host in the aggregate.\", \"type\": \"integer\", \"readonly\": false, \"minimum\": 0}','2025-10-02 11:11:53',NULL),(56,8,'cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"Type of CPU Mode.\", \"type\": \"string\", \"enum\": [\"none\", \"host-model\", \"host-passthrough\", \"custom\"]}','2025-10-02 11:11:53',NULL),(57,9,'cpu_policy','{\"title\": \"CPU Pinning policy\", \"description\": \"Type of CPU pinning policy.\", \"type\": \"string\", \"enum\": [\"shared\", \"dedicated\"]}','2025-10-02 11:11:53',NULL),(58,9,'cpu_thread_policy','{\"title\": \"CPU Thread Pinning Policy.\", \"description\": \"Type of CPU thread pinning policy.\", \"type\": \"string\", \"enum\": [\"isolate\", \"prefer\", \"require\"]}','2025-10-02 11:11:53',NULL),(59,10,'mem_page_size','{\"title\": \"Size of memory page\", \"description\": \"Page size to be used for Guest memory backing. Value can be specified as <number><unit> (i.e.: 2MB, 1GB) or \'any\', \'small\', \'large\'. If this property is set in Image metadata then only \'any\' and \'large\' values are accepted in Flavor metadata by Nova API.\", \"type\": \"string\"}','2025-10-02 11:11:53',NULL),(60,11,'os_shutdown_timeout','{\"title\": \"Shutdown timeout\", \"description\": \"By default, guests will be given 60 seconds to perform a graceful shutdown. After that, the VM is powered off.  This property allows overriding the amount of time (unit: seconds) to allow a guest OS to cleanly shut down before power off. A value of 0 (zero) means the guest will be powered off immediately with no opportunity for guest OS clean-up.\", \"type\": \"integer\", \"minimum\": 0}','2025-10-02 11:11:53',NULL),(61,12,'cpu_info:vendor','{\"title\": \"Vendor\", \"description\": \"Specifies the CPU manufacturer.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Intel\", \"AMD\"]}','2025-10-02 11:11:53',NULL),(62,12,'cpu_info:model','{\"title\": \"Model\", \"description\": \"Specifies the CPU model. Use this property to ensure that your vm runs on a specific cpu model.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Conroe\", \"Core2Duo\", \"Penryn\", \"Nehalem\", \"Westmere\", \"SandyBridge\", \"IvyBridge\", \"Haswell\", \"Broadwell\", \"Delhi\", \"Seoul\", \"Abu Dhabi\", \"Interlagos\", \"Kabini\", \"Valencia\", \"Zurich\", \"Budapest\", \"Barcelona\", \"Suzuka\", \"Shanghai\", \"Istanbul\", \"Lisbon\", \"Magny-Cours\", \"Valencia\", \"Cortex-A57\", \"Cortex-A53\", \"Cortex-A12\", \"Cortex-A17\", \"Cortex-A15\", \"Coretx-A7\", \"X-Gene\"]}','2025-10-02 11:11:53',NULL),(63,12,'cpu_info:arch','{\"title\": \"Architecture\", \"description\": \"Specifies the CPU architecture. Use this property to specify the architecture supported by the hypervisor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"x86_64\", \"i686\", \"ia64\", \"ARMv8-A\", \"ARMv7-A\"]}','2025-10-02 11:11:53',NULL),(64,12,'cpu_info:topology:cores','{\"title\": \"cores\", \"description\": \"Number of cores.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-10-02 11:11:53',NULL),(65,12,'cpu_info:topology:threads','{\"title\": \"threads\", \"description\": \"Number of threads.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-10-02 11:11:53',NULL),(66,12,'cpu_info:topology:sockets','{\"title\": \"sockets\", \"description\": \"Number of sockets.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-10-02 11:11:53',NULL),(67,12,'cpu_info:features','{\"title\": \"Features\", \"description\": \"Specifies CPU flags/features. Using this property you can specify the required set of instructions supported by a vm.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"fpu\", \"vme\", \"de\", \"pse\", \"tsc\", \"msr\", \"pae\", \"mce\", \"cx8\", \"apic\", \"sep\", \"mtrr\", \"pge\", \"mca\", \"cmov\", \"pat\", \"pse36\", \"pn\", \"clflush\", \"dts\", \"acpi\", \"mmx\", \"fxsr\", \"sse\", \"sse2\", \"ss\", \"ht\", \"tm\", \"ia64\", \"pbe\", \"syscall\", \"mp\", \"nx\", \"mmxext\", \"fxsr_opt\", \"pdpe1gb\", \"rdtscp\", \"lm\", \"3dnowext\", \"3dnow\", \"arch_perfmon\", \"pebs\", \"bts\", \"rep_good\", \"nopl\", \"xtopology\", \"tsc_reliable\", \"nonstop_tsc\", \"extd_apicid\", \"amd_dcm\", \"aperfmperf\", \"eagerfpu\", \"nonstop_tsc_s3\", \"pni\", \"pclmulqdq\", \"dtes64\", \"monitor\", \"ds_cpl\", \"vmx\", \"smx\", \"est\", \"tm2\", \"ssse3\", \"cid\", \"fma\", \"cx16\", \"xtpr\", \"pdcm\", \"pcid\", \"dca\", \"sse4_1\", \"sse4_2\", \"x2apic\", \"movbe\", \"popcnt\", \"tsc_deadline_timer\", \"aes\", \"xsave\", \"avx\", \"f16c\", \"rdrand\", \"hypervisor\", \"rng\", \"rng_en\", \"ace\", \"ace_en\", \"ace2\", \"ace2_en\", \"phe\", \"phe_en\", \"pmm\", \"pmm_en\", \"lahf_lm\", \"cmp_legacy\", \"svm\", \"extapic\", \"cr8_legacy\", \"abm\", \"sse4a\", \"misalignsse\", \"3dnowprefetch\", \"osvw\", \"ibs\", \"xop\", \"skinit\", \"wdt\", \"lwp\", \"fma4\", \"tce\", \"nodeid_msr\", \"tbm\", \"topoext\", \"perfctr_core\", \"perfctr_nb\", \"bpext\", \"perfctr_l2\", \"mwaitx\", \"ida\", \"arat\", \"cpb\", \"epb\", \"pln\", \"pts\", \"dtherm\", \"hw_pstate\", \"proc_feedback\", \"hwp\", \"hwp_notify\", \"hwp_act_window\", \"hwp_epp\", \"hwp_pkg_req\", \"intel_pt\", \"tpr_shadow\", \"vnmi\", \"flexpriority\", \"ept\", \"vpid\", \"npt\", \"lbrv\", \"svm_lock\", \"nrip_save\", \"tsc_scale\", \"vmcb_clean\", \"flushbyasid\", \"decodeassists\", \"pausefilter\", \"pfthreshold\", \"vmmcall\", \"fsgsbase\", \"tsc_adjust\", \"bmi1\", \"hle\", \"avx2\", \"smep\", \"bmi2\", \"erms\", \"invpcid\", \"rtm\", \"cqm\", \"mpx\", \"avx512f\", \"rdseed\", \"adx\", \"smap\", \"pcommit\", \"clflushopt\", \"clwb\", \"avx512pf\", \"avx512er\", \"avx512cd\", \"sha_ni\", \"xsaveopt\", \"xsavec\", \"xgetbv1\", \"xsaves\", \"cqm_llc\", \"cqm_occup_llc\", \"clzero\"]}}','2025-10-02 11:11:53',NULL),(68,13,'hypervisor_type','{\"title\": \"Hypervisor Type\", \"description\": \"Hypervisor type required by the image. Used with the ImagePropertiesFilter. \\n\\n Baremetal - physical provisioning. hyperv - Microsoft\\u00ae hyperv. KVM - Kernel-based Virtual Machine. LXC - Linux Containers (through libvirt). powervm - IBM\\u00ae PowerVM\\u00ae. QEMU - Quick EMUlator. UML - User Mode Linux. vmware - VMware\\u00ae vsphere. VZ - Virtuozzo OS Containers and Virtual Machines (through libvirt). For more information, see: https://docs.openstack.org/nova/latest/admin/configuration/hypervisors.html\", \"type\": \"string\", \"enum\": [\"baremetal\", \"hyperv\", \"kvm\", \"lxc\", \"powervm\", \"qemu\", \"uml\", \"vmware\", \"vz\", \"xen\"]}','2025-10-02 11:11:53',NULL),(69,13,'vm_mode','{\"title\": \"VM Mode\", \"description\": \"The virtual machine mode. This represents the host/guest ABI (application binary interface) used for the virtual machine. Used with the ImagePropertiesFilter. \\n\\n hvm \\u2014 Fully virtualized - This is the virtual machine mode (vm_mode) used by QEMU and KVM. \\n\\n xen - Xen 3.0 paravirtualized. \\n\\n uml \\u2014 User Mode Linux paravirtualized. \\n\\n exe \\u2014 Executables in containers. This is the mode used by LXC.\", \"type\": \"string\", \"enum\": [\"hvm\", \"xen\", \"uml\", \"exe\"]}','2025-10-02 11:11:53',NULL),(70,14,'img_config_drive','{\"title\": \"Config Drive\", \"description\": \"This property specifies whether or not Nova should use a config drive when booting the image. Mandatory means that Nova will always use a config drive when booting the image. OpenStack can be configured to write metadata to a special configuration drive that will be attached to the instance when it boots. The instance can retrieve any information from the config drive. One use case for the config drive is to pass network configuration information to the instance. See also: http://docs.openstack.org/user-guide/cli_config_drive.html\", \"type\": \"string\", \"enum\": [\"optional\", \"mandatory\"]}','2025-10-02 11:11:53',NULL),(71,14,'os_require_quiesce','{\"title\": \"Require Quiescent File system\", \"description\": \"This property specifies whether or not the filesystem must be quiesced during snapshot processing. For volume backed and image backed snapshots, yes means that snapshotting is aborted when quiescing fails, whereas, no means quiescing will be skipped and snapshot processing will continue after the quiesce failure.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-10-02 11:11:53',NULL),(72,15,'hw_cdrom_bus','{\"title\": \"CD-ROM Bus\", \"description\": \"Specifies the type of disk controller to attach CD-ROM devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-10-02 11:11:53',NULL),(73,15,'hw_disk_bus','{\"title\": \"Disk Bus\", \"description\": \"Specifies the type of disk controller to attach disk devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-10-02 11:11:53',NULL),(74,15,'hw_firmware_type','{\"title\": \"Firmware Type\", \"description\": \"Specifies whether the image should be booted with a legacy BIOS or with UEFI.\", \"type\": \"string\", \"enum\": [\"bios\", \"uefi\"]}','2025-10-02 11:11:53',NULL),(75,15,'hw_rng_model','{\"title\": \"Random Number Generator Device\", \"description\": \"Adds a random-number generator device to the image\'s instances. The cloud administrator can enable and control device behavior by configuring the instance\'s flavor. By default: The generator device is disabled. /dev/random is used as the default entropy source. To specify a physical HW RNG device, use the following option in the nova.conf file: rng_dev_path=/dev/hwrng\", \"type\": \"string\", \"default\": \"virtio\"}','2025-10-02 11:11:53',NULL),(76,15,'hw_machine_type','{\"title\": \"Machine Type\", \"description\": \"Enables booting an ARM system using the specified machine type. By default, if an ARM image is used and its type is not specified, Compute uses vexpress-a15 (for ARMv7) or virt (for AArch64) machine types. Valid types can be viewed by using the virsh capabilities command (machine types are displayed in the machine tag).\", \"type\": \"string\"}','2025-10-02 11:11:53',NULL),(77,15,'hw_scsi_model','{\"title\": \"SCSI Model\", \"description\": \"Enables the use of VirtIO SCSI (virtio-scsi) to provide block device access for compute instances; by default, instances use VirtIO Block (virtio-blk). VirtIO SCSI is a para-virtualized SCSI controller device that provides improved scalability and performance, and supports advanced SCSI hardware.\", \"type\": \"string\", \"default\": \"virtio-scsi\"}','2025-10-02 11:11:53',NULL),(78,15,'hw_video_model','{\"title\": \"Video Model\", \"description\": \"The graphic device model presented to the guest. hw_video_model=none disables the graphics device in the guest and should generally be used when using gpu passthrough.\", \"type\": \"string\", \"enum\": [\"vga\", \"cirrus\", \"vmvga\", \"xen\", \"qxl\", \"virtio\", \"gop\", \"none\", \"bochs\"]}','2025-10-02 11:11:53',NULL),(79,15,'hw_video_ram','{\"title\": \"Max Video Ram\", \"description\": \"Maximum RAM (unit: MB) for the video image. Used only if a hw_video:ram_max_mb value has been set in the flavor\'s extra_specs and that value is higher than the value set in hw_video_ram.\", \"type\": \"integer\", \"minimum\": 0}','2025-10-02 11:11:53',NULL),(80,15,'os_command_line','{\"title\": \"Kernel Command Line\", \"description\": \"The kernel command line to be used by the libvirt driver, instead of the default. For linux containers (LXC), the value is used as arguments for initialization. This key is valid only for Amazon kernel, ramdisk, or machine images (aki, ari, or ami).\", \"type\": \"string\"}','2025-10-02 11:11:53',NULL),(81,15,'os_type','{\"title\": \"OS Type\", \"description\": \"The operating system installed on the image. The libvirt driver contains logic that takes different actions depending on the value of the os_type parameter of the image. For example, for os_type=windows images, it creates a FAT32-based swap partition instead of a Linux swap partition, and it limits the injected host name to less than 16 characters.\", \"type\": \"string\", \"enum\": [\"linux\", \"windows\"]}','2025-10-02 11:11:53',NULL),(82,15,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor configuration. libvirt driver options: KVM and QEMU: e1000, ne2k_pci, pcnet, rtl8139, spapr-vlan, virtio, e1000e and vmxnet3. Xen: e1000, netfront, ne2k_pci, pcnet, and rtl8139.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"ne2k_pci\", \"netfront\", \"pcnet\", \"rtl8139\", \"spapr-vlan\", \"virtio\", \"vmxnet3\"]}','2025-10-02 11:11:53',NULL),(83,15,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-10-02 11:11:53',NULL),(84,15,'hw_pmu','{\"title\": \"Virtual Performance Monitoring Unit\", \"description\": \"Controls emulation of a vPMU in the guest. To reduce latency in realtime workloads disable the vPMU by setting hw_pmu=false\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-10-02 11:11:53',NULL),(85,15,'hw_qemu_guest_agent','{\"title\": \"QEMU Guest Agent\", \"description\": \"This is a background process which helps management applications execute guest OS level commands. For example, freezing and thawing filesystems, entering suspend. However, guest agent (GA) is not bullet proof, and hostile guest OS can send spurious replies.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-10-02 11:11:53',NULL),(86,15,'hw_pointer_model','{\"title\": \"Pointer Model\", \"description\": \"Input devices allow interaction with a graphical framebuffer. For example to provide a graphic tablet for absolute cursor movement. Currently only supported by the KVM/QEMU hypervisor configuration and VNC or SPICE consoles must be enabled.\", \"type\": \"string\", \"enum\": [\"usbtablet\"]}','2025-10-02 11:11:53',NULL),(87,15,'img_hide_hypervisor_id','{\"title\": \"Hide hypervisor id\", \"description\": \"Enables hiding the host hypervisor signature in the guest OS.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-10-02 11:11:53',NULL),(88,16,'serial_port_count','{\"title\": \"Serial Port Count\", \"description\": \"Specifies the count of serial ports that should be provided. If hw:serial_port_count is not set in the flavor\'s extra_specs, then any count is permitted. If hw:serial_port_count is set, then this provides the default serial port count. It is permitted to override the default serial port count, but only with a lower value.\", \"type\": \"integer\", \"minimum\": 0}','2025-10-02 11:11:53',NULL),(89,16,'boot_menu','{\"title\": \"Boot Menu\", \"description\": \"If true, enables the BIOS bootmenu. In cases where both the image metadata and Extra Spec are set, the Extra Spec setting is used. This allows for flexibility in setting/overriding the default behavior as needed.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-10-02 11:11:54',NULL),(90,16,'mem_encryption','{\"title\": \"Hardware Memory Encryption\", \"description\": \"Enables encryption of guest memory at the hardware level, if there are compute hosts available which support this. See https://docs.openstack.org/nova/latest/admin/configuration/hypervisor-kvm.html#amd-sev-secure-encrypted-virtualization for details.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-10-02 11:11:54',NULL),(91,18,'hw_rng:allowed','{\"title\": \"Random Number Generator Allowed\", \"description\": \"\", \"type\": \"boolean\"}','2025-10-02 11:11:54',NULL),(92,18,'hw_rng:rate_bytes','{\"title\": \"Random number generator limits.\", \"description\": \"Allowed amount of bytes that the guest can read from the host\'s entropy per period.\", \"type\": \"integer\"}','2025-10-02 11:11:54',NULL),(93,18,'hw_rng:rate_period','{\"title\": \"Random number generator read period.\", \"description\": \"Duration of the read period in milliseconds.\", \"type\": \"integer\"}','2025-10-02 11:11:54',NULL),(94,19,'cpu_sockets','{\"title\": \"vCPU Sockets\", \"description\": \"Preferred number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-10-02 11:11:54',NULL),(95,19,'cpu_cores','{\"title\": \"vCPU Cores\", \"description\": \"Preferred number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-10-02 11:11:54',NULL),(96,19,'cpu_threads','{\"title\": \" vCPU Threads\", \"description\": \"Preferred number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-10-02 11:11:54',NULL),(97,19,'cpu_max_sockets','{\"title\": \"Max vCPU Sockets\", \"description\": \"Maximum number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-10-02 11:11:54',NULL),(98,19,'cpu_max_cores','{\"title\": \"Max vCPU Cores\", \"description\": \"Maximum number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-10-02 11:11:54',NULL),(99,19,'cpu_max_threads','{\"title\": \"Max vCPU Threads\", \"description\": \"Maximum number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-10-02 11:11:54',NULL),(100,20,'vmware:hw_version','{\"title\": \"VMware Hardware Version\", \"description\": \"Specifies the hardware version VMware uses to create images. If the hardware version needs to be compatible with a cluster version, for backward compatibility or other circumstances, the vmware:hw_version key specifies a virtual machine hardware version. In the event that a cluster has mixed host version types, the key will enable the vCenter to place the cluster on the correct host.\", \"type\": \"string\", \"enum\": [\"vmx-13\", \"vmx-11\", \"vmx-10\", \"vmx-09\", \"vmx-08\", \"vmx-07\", \"vmx-04\", \"vmx-03\"]}','2025-10-02 11:11:54',NULL),(101,20,'vmware:storage_policy','{\"title\": \"VMware Storage Policy\", \"description\": \"Specifies the storage policy to be applied for newly created instance. If not provided, the default storage policy specified in config file will be used. If Storage Policy Based Management (SPBM) is not enabled in config file, this value won\'t be used.\", \"type\": \"string\"}','2025-10-02 11:11:54',NULL),(102,21,'quota:cpu_limit','{\"title\": \"Quota: CPU Limit\", \"description\": \"Specifies the upper limit for CPU allocation in MHz. This parameter ensures that a machine never uses more than the defined amount of CPU time. It can be used to enforce a limit on the machine\'s CPU performance. The value should be a numerical value in MHz. If zero is supplied then the cpu_limit is unlimited.\", \"type\": \"integer\", \"minimum\": 0}','2025-10-02 11:11:55',NULL),(103,21,'quota:cpu_reservation','{\"title\": \"Quota: CPU Reservation Limit\", \"description\": \"Specifies the guaranteed minimum CPU reservation in MHz. This means that if needed, the machine will definitely get allocated the reserved amount of CPU cycles. The value should be a numerical value in MHz.\", \"type\": \"integer\", \"minimum\": 0}','2025-10-02 11:11:55',NULL),(104,22,'img_linked_clone','{\"title\": \"Linked Clone\", \"description\": \"By default, the VMware compute driver creates linked clones when possible (though this can be turned off by the operator). You can use this image property on a per-image basis to control whether virtual machines booted from the image are treated as full clones (value: false) or linked clones (value: true). Please refer to VMware documentation for information about full vs. linked clones.\", \"type\": \"boolean\"}','2025-10-02 11:11:55',NULL),(105,22,'vmware_adaptertype','{\"title\": \"Disk Adapter Type\", \"description\": \"The virtual SCSI or IDE controller used by the hypervisor.\", \"type\": \"string\", \"enum\": [\"lsiLogic\", \"lsiLogicsas\", \"paraVirtual\", \"busLogic\", \"ide\"], \"default\": \"lsiLogic\"}','2025-10-02 11:11:55',NULL),(106,22,'vmware_disktype','{\"title\": \"Disk Provisioning Type\", \"description\": \"When performing operations such as creating a virtual disk, cloning, or migrating, the disk provisioning type may be specified. Please refer to VMware documentation for more.\", \"type\": \"string\", \"enum\": [\"streamOptimized\", \"sparse\", \"preallocated\"], \"default\": \"preallocated\"}','2025-10-02 11:11:55',NULL),(107,22,'vmware_ostype','{\"title\": \"OS Type\", \"description\": \"A VMware GuestID which describes the operating system installed in the image. This value is passed to the hypervisor when creating a virtual machine. If not specified, the key defaults to otherGuest. See thinkvirt.com.\", \"type\": \"string\", \"enum\": [\"asianux3_64Guest\", \"asianux3Guest\", \"asianux4_64Guest\", \"asianux4Guest\", \"asianux5_64Guest\", \"asianux7_64Guest\", \"centos64Guest\", \"centosGuest\", \"centos6Guest\", \"centos6_64Guest\", \"centos7_64Guest\", \"coreos64Guest\", \"darwin10_64Guest\", \"darwin10Guest\", \"darwin11_64Guest\", \"darwin11Guest\", \"darwin12_64Guest\", \"darwin13_64Guest\", \"darwin14_64Guest\", \"darwin15_64Guest\", \"darwin16_64Guest\", \"darwin64Guest\", \"darwinGuest\", \"debian4_64Guest\", \"debian4Guest\", \"debian5_64Guest\", \"debian5Guest\", \"debian6_64Guest\", \"debian6Guest\", \"debian7_64Guest\", \"debian7Guest\", \"debian8_64Guest\", \"debian8Guest\", \"debian9_64Guest\", \"debian9Guest\", \"debian10_64Guest\", \"debian10Guest\", \"dosGuest\", \"eComStation2Guest\", \"eComStationGuest\", \"fedora64Guest\", \"fedoraGuest\", \"freebsd64Guest\", \"freebsdGuest\", \"genericLinuxGuest\", \"mandrakeGuest\", \"mandriva64Guest\", \"mandrivaGuest\", \"netware4Guest\", \"netware5Guest\", \"netware6Guest\", \"nld9Guest\", \"oesGuest\", \"openServer5Guest\", \"openServer6Guest\", \"opensuse64Guest\", \"opensuseGuest\", \"oracleLinux64Guest\", \"oracleLinuxGuest\", \"oracleLinux6Guest\", \"oracleLinux6_64Guest\", \"oracleLinux7_64Guest\", \"os2Guest\", \"other24xLinux64Guest\", \"other24xLinuxGuest\", \"other26xLinux64Guest\", \"other26xLinuxGuest\", \"other3xLinux64Guest\", \"other3xLinuxGuest\", \"otherGuest\", \"otherGuest64\", \"otherLinux64Guest\", \"otherLinuxGuest\", \"redhatGuest\", \"rhel2Guest\", \"rhel3_64Guest\", \"rhel3Guest\", \"rhel4_64Guest\", \"rhel4Guest\", \"rhel5_64Guest\", \"rhel5Guest\", \"rhel6_64Guest\", \"rhel6Guest\", \"rhel7_64Guest\", \"rhel7Guest\", \"sjdsGuest\", \"sles10_64Guest\", \"sles10Guest\", \"sles11_64Guest\", \"sles11Guest\", \"sles12_64Guest\", \"sles12Guest\", \"sles64Guest\", \"slesGuest\", \"solaris10_64Guest\", \"solaris10Guest\", \"solaris11_64Guest\", \"solaris6Guest\", \"solaris7Guest\", \"solaris8Guest\", \"solaris9Guest\", \"turboLinux64Guest\", \"turboLinuxGuest\", \"ubuntu64Guest\", \"ubuntuGuest\", \"unixWare7Guest\", \"vmkernel5Guest\", \"vmkernel6Guest\", \"vmkernel65Guest\", \"vmkernelGuest\", \"vmwarePhoton64Guest\", \"win2000AdvServGuest\", \"win2000ProGuest\", \"win2000ServGuest\", \"win31Guest\", \"win95Guest\", \"win98Guest\", \"windows7_64Guest\", \"windows7Guest\", \"windows7Server64Guest\", \"windows8_64Guest\", \"windows8Guest\", \"windows8Server64Guest\", \"windows9_64Guest\", \"windows9Guest\", \"windows9Server64Guest\", \"windowsHyperVGuest\", \"winLonghorn64Guest\", \"winLonghornGuest\", \"winMeGuest\", \"winNetBusinessGuest\", \"winNetDatacenter64Guest\", \"winNetDatacenterGuest\", \"winNetEnterprise64Guest\", \"winNetEnterpriseGuest\", \"winNetStandard64Guest\", \"winNetStandardGuest\", \"winNetWebGuest\", \"winNTGuest\", \"winVista64Guest\", \"winVistaGuest\", \"winXPHomeGuest\", \"winXPPro64Guest\", \"winXPProGuest\"], \"default\": \"otherGuest\"}','2025-10-02 11:11:55',NULL),(108,22,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor. VMware driver supported options: e1000, e1000e, VirtualE1000, VirtualE1000e, VirtualPCNet32, and VirtualVmxnet.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"VirtualE1000\", \"VirtualE1000e\", \"VirtualPCNet32\", \"VirtualVmxnet\", \"VirtualVmxnet3\"], \"default\": \"e1000\"}','2025-10-02 11:11:55',NULL),(109,22,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-10-02 11:11:55',NULL),(110,23,'tpm_model','{\"title\": \"TPM model\", \"description\": \"TPM model to use. Option CRB is only valid for TPM version 2.0. Defaults to TIS.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"TIS\", \"CRB\"], \"default\": \"TIS\"}','2025-10-02 11:11:55',NULL),(111,24,'COMPUTE_SECURITY_TPM_1_2','{\"title\": \"Virtual TPM Version 1.2 Support\", \"description\": \"Enables virtual TPM version 1.2.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-10-02 11:11:56',NULL),(112,24,'COMPUTE_SECURITY_TPM_2_0','{\"title\": \"Virtual TPM Version 2.0 Support\", \"description\": \"Enables virtual TPM version 2.0.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-10-02 11:11:56',NULL),(113,25,'watchdog_action','{\"title\": \"Watchdog Action\", \"description\": \"For the libvirt driver, you can enable and set the behavior of a virtual hardware watchdog device for each flavor. Watchdog devices keep an eye on the guest server, and carry out the configured action, if the server hangs. The watchdog uses the i6300esb device (emulating a PCI Intel 6300ESB). If hw_watchdog_action is not specified, the watchdog is disabled. Watchdog behavior set using a specific image\'s properties will override behavior set using flavors.\", \"type\": \"string\", \"enum\": [\"disabled\", \"reset\", \"poweroff\", \"pause\", \"none\"]}','2025-10-02 11:11:56',NULL),(114,26,'auto_disk_config','{\"title\": \"Disk Adapter Type\", \"description\": \"If true, the root partition on the disk is automatically resized before the instance boots. This value is only taken into account by the Compute service when using a Xen-based hypervisor with the XenAPI driver. The Compute service will only attempt to resize if there is a single partition on the image, and only if the partition is in ext3 or ext4 format.\", \"type\": \"boolean\"}','2025-10-02 11:11:57',NULL),(115,27,'kernel_id','{\"title\": \"Kernel ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the kernel when booting an AMI-style image.\"}','2025-10-02 11:11:57',NULL),(116,27,'ramdisk_id','{\"title\": \"Ramdisk ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the ramdisk when booting an AMI-style image.\"}','2025-10-02 11:11:57',NULL),(117,27,'instance_uuid','{\"title\": \"Instance ID\", \"type\": \"string\", \"description\": \"Metadata which can be used to record which instance this image is associated with. (Informational only, does not create an instance snapshot.)\"}','2025-10-02 11:11:57',NULL),(118,27,'architecture','{\"title\": \"CPU Architecture\", \"description\": \"The CPU architecture that must be supported by the hypervisor. For example, x86_64, arm, or ppc64. Run uname -m to get the architecture of a machine. We strongly recommend using the architecture data vocabulary defined by the libosinfo project for this purpose.\", \"type\": \"string\"}','2025-10-02 11:11:57',NULL),(119,27,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-10-02 11:11:57',NULL),(120,27,'hw_cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"This specifies the CPU Mode for the guest vm\", \"type\": \"string\"}','2025-10-02 11:11:57',NULL),(121,27,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-10-02 11:11:58',NULL),(122,27,'description','{\"title\": \"Image description\", \"description\": \"A human-readable string describing this image.\", \"type\": \"string\"}','2025-10-02 11:11:58',NULL),(123,27,'cinder_encryption_key_id','{\"title\": \"Cinder Encryption Key ID\", \"description\": \"Identifier in the OpenStack Key Management Service for the encryption key for the Block Storage Service to use when mounting a volume created from this image\", \"type\": \"string\"}','2025-10-02 11:11:58',NULL),(124,27,'cinder_encryption_key_deletion_policy','{\"title\": \"Cinder Encryption Key Deletion Policy\", \"description\": \"States the condition under which the Image Service will delete the object associated with the \'cinder_encryption_key_id\' image property.  If this property is missing, the Image Service will take no action\", \"type\": \"string\", \"enum\": [\"on_image_deletion\", \"do_not_delete\"]}','2025-10-02 11:11:58',NULL),(125,28,'img_signature','{\"title\": \"Image Signature\", \"description\": \"The signature of the image data encoded in base64 format.\", \"type\": \"string\"}','2025-10-02 11:11:58',NULL),(126,28,'img_signature_certificate_uuid','{\"title\": \"Image Signature Certificate UUID\", \"description\": \"The UUID used to retrieve the certificate from the key manager.\", \"type\": \"string\"}','2025-10-02 11:11:58',NULL),(127,28,'img_signature_hash_method','{\"title\": \"Image Signature Hash Method\", \"description\": \"The hash method used in creating the signature.\", \"type\": \"string\", \"enum\": [\"SHA-224\", \"SHA-256\", \"SHA-384\", \"SHA-512\"]}','2025-10-02 11:11:58',NULL),(128,28,'img_signature_key_type','{\"title\": \"Image Signature Key Type\", \"description\": \"The key type used in creating the signature.\", \"type\": \"string\", \"enum\": [\"RSA-PSS\", \"DSA\", \"ECC_SECT571K1\", \"ECC_SECT409K1\", \"ECC_SECT571R1\", \"ECC_SECT409R1\", \"ECC_SECP521R1\", \"ECC_SECP384R1\"]}','2025-10-02 11:11:58',NULL),(129,29,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-10-02 11:11:59',NULL),(130,29,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-10-02 11:11:59',NULL),(131,29,'os_admin_user','{\"title\": \"OS Admin User\", \"description\": \"The name of the user with admin privileges.\", \"type\": \"string\"}','2025-10-02 11:11:59',NULL),(132,33,'img_volume_type','{\"title\": \"Image Volume Type\", \"description\": \"Specifies the volume type that should be applied during new volume creation with a image. This value is passed to Cinder when creating a new volume. Priority of volume type related parameters are 1.volume_type(via API or CLI), 2.cinder_img_volume_type, 3.default_volume_type(via cinder.conf). If not specified, volume_type or default_volume_type will be referred based on their priority.\", \"type\": \"string\"}','2025-10-02 11:12:00',NULL);
/*!40000 ALTER TABLE `metadef_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_resource_types`
--

DROP TABLE IF EXISTS `metadef_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_resource_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `protected` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_resource_types_name` (`name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_resource_types`
--

LOCK TABLES `metadef_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_resource_types` (`id`, `name`, `protected`, `created_at`, `updated_at`) VALUES (1,'OS::Cinder::Volume',1,'2025-10-02 11:11:52',NULL),(2,'OS::Glance::Image',1,'2025-10-02 11:11:52',NULL),(3,'OS::Nova::Aggregate',1,'2025-10-02 11:11:52',NULL),(4,'OS::Nova::Flavor',1,'2025-10-02 11:11:52',NULL),(5,'OS::Nova::Server',1,'2025-10-02 11:11:52',NULL),(6,'OS::Trove::Instance',1,'2025-10-02 11:11:59',NULL);
/*!40000 ALTER TABLE `metadef_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_tags`
--

DROP TABLE IF EXISTS `metadef_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_tags_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_tags_name` (`name`),
  CONSTRAINT `metadef_tags_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_tags`
--

LOCK TABLES `metadef_tags` WRITE;
/*!40000 ALTER TABLE `metadef_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadef_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_info`
--

DROP TABLE IF EXISTS `task_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_info` (
  `task_id` varchar(36) NOT NULL,
  `input` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  CONSTRAINT `task_info_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_info`
--

LOCK TABLES `task_info` WRITE;
/*!40000 ALTER TABLE `task_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` varchar(36) NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `image_id` varchar(36) DEFAULT NULL,
  `request_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_tasks_deleted` (`deleted`),
  KEY `ix_tasks_owner` (`owner`),
  KEY `ix_tasks_status` (`status`),
  KEY `ix_tasks_type` (`type`),
  KEY `ix_tasks_updated_at` (`updated_at`),
  KEY `ix_tasks_image_id` (`image_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `keystone`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `keystone` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `keystone`;

--
-- Table structure for table `access_rule`
--

DROP TABLE IF EXISTS `access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(64) DEFAULT NULL,
  `path` varchar(128) DEFAULT NULL,
  `method` varchar(16) DEFAULT NULL,
  `external_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_rule_external_id_key` (`external_id`),
  UNIQUE KEY `duplicate_access_rule_for_user_constraint` (`user_id`,`service`,`path`,`method`),
  KEY `external_id` (`external_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_rule`
--

LOCK TABLES `access_rule` WRITE;
/*!40000 ALTER TABLE `access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_token`
--

DROP TABLE IF EXISTS `access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_token` (
  `id` varchar(64) NOT NULL,
  `access_secret` varchar(64) NOT NULL,
  `authorizing_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  `role_ids` text NOT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_access_token_authorizing_user_id` (`authorizing_user_id`),
  KEY `ix_access_token_consumer_id` (`consumer_id`),
  CONSTRAINT `access_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_token`
--

LOCK TABLES `access_token` WRITE;
/*!40000 ALTER TABLE `access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('29e87d24a316'),('e25ffa003242');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential`
--

DROP TABLE IF EXISTS `application_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential` (
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `secret_hash` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `system` varchar(64) DEFAULT NULL,
  `unrestricted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `duplicate_app_cred_constraint` (`user_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential`
--

LOCK TABLES `application_credential` WRITE;
/*!40000 ALTER TABLE `application_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_access_rule`
--

DROP TABLE IF EXISTS `application_credential_access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_access_rule` (
  `application_credential_id` int(11) NOT NULL,
  `access_rule_id` int(11) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`access_rule_id`),
  KEY `access_rule_id` (`access_rule_id`),
  CONSTRAINT `application_credential_access_rule_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE,
  CONSTRAINT `application_credential_access_rule_ibfk_2` FOREIGN KEY (`access_rule_id`) REFERENCES `access_rule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_access_rule`
--

LOCK TABLES `application_credential_access_rule` WRITE;
/*!40000 ALTER TABLE `application_credential_access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_role`
--

DROP TABLE IF EXISTS `application_credential_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_role` (
  `application_credential_id` int(11) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`role_id`),
  CONSTRAINT `application_credential_role_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_role`
--

LOCK TABLES `application_credential_role` WRITE;
/*!40000 ALTER TABLE `application_credential_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assignment` (
  `type` enum('UserProject','GroupProject','UserDomain','GroupDomain') NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  KEY `ix_actor_id` (`actor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserProject','2ba37b62dd5f4f568f4f548411019b19','aebeb47424cc4f05b6c098503009ac0d','8855e2cc253a496086a7695dd9c0b945',0),('UserProject','2ba37b62dd5f4f568f4f548411019b19','aebeb47424cc4f05b6c098503009ac0d','a59febc5d6c049ae8f02bb916d6b421f',0),('UserProject','57823c2cf8a04b2abc574ed057efc3db','1533ac528d35434c826050eed402afba','85f92a60b61c46d9a3a532593ecd4d31',0),('UserProject','57823c2cf8a04b2abc574ed057efc3db','1533ac528d35434c826050eed402afba','8855e2cc253a496086a7695dd9c0b945',0),('UserProject','57823c2cf8a04b2abc574ed057efc3db','db0711c79d3343a6b45eee0c395c823b','8855e2cc253a496086a7695dd9c0b945',0),('UserProject','62dc8ee9765446f9820441bcf401f4cc','aebeb47424cc4f05b6c098503009ac0d','8855e2cc253a496086a7695dd9c0b945',0),('UserProject','62dc8ee9765446f9820441bcf401f4cc','aebeb47424cc4f05b6c098503009ac0d','a59febc5d6c049ae8f02bb916d6b421f',0),('UserProject','859ffbc3614042108037541e456daa78','aebeb47424cc4f05b6c098503009ac0d','8855e2cc253a496086a7695dd9c0b945',0),('UserProject','859ffbc3614042108037541e456daa78','aebeb47424cc4f05b6c098503009ac0d','a59febc5d6c049ae8f02bb916d6b421f',0),('UserProject','8ca87a1850614c06b2e2165883628d33','aebeb47424cc4f05b6c098503009ac0d','8855e2cc253a496086a7695dd9c0b945',0),('UserProject','8ca87a1850614c06b2e2165883628d33','aebeb47424cc4f05b6c098503009ac0d','a59febc5d6c049ae8f02bb916d6b421f',0),('UserProject','bb38f143b67741f380a581625d2d2a5c','aebeb47424cc4f05b6c098503009ac0d','8855e2cc253a496086a7695dd9c0b945',0),('UserProject','bb38f143b67741f380a581625d2d2a5c','aebeb47424cc4f05b6c098503009ac0d','a59febc5d6c049ae8f02bb916d6b421f',0),('UserProject','bcce56fe65b04eb9aa1d1152b7e73d5f','aebeb47424cc4f05b6c098503009ac0d','4d67b005c4d741e8bef0179c58976a2c',0),('UserProject','bcce56fe65b04eb9aa1d1152b7e73d5f','aebeb47424cc4f05b6c098503009ac0d','8855e2cc253a496086a7695dd9c0b945',0),('UserProject','d55b3ee250d1468fbcf33643dda37adb','aebeb47424cc4f05b6c098503009ac0d','8855e2cc253a496086a7695dd9c0b945',0),('UserProject','d55b3ee250d1468fbcf33643dda37adb','aebeb47424cc4f05b6c098503009ac0d','a59febc5d6c049ae8f02bb916d6b421f',0),('UserProject','f2700629748f4a53afaee0e33dc39c53','aebeb47424cc4f05b6c098503009ac0d','8855e2cc253a496086a7695dd9c0b945',0),('UserProject','f2700629748f4a53afaee0e33dc39c53','aebeb47424cc4f05b6c098503009ac0d','a59febc5d6c049ae8f02bb916d6b421f',0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_register`
--

DROP TABLE IF EXISTS `config_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_register` (
  `type` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_register`
--

LOCK TABLES `config_register` WRITE;
/*!40000 ALTER TABLE `config_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `config_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumer`
--

DROP TABLE IF EXISTS `consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumer` (
  `id` varchar(64) NOT NULL,
  `description` varchar(64) DEFAULT NULL,
  `secret` varchar(64) NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumer`
--

LOCK TABLES `consumer` WRITE;
/*!40000 ALTER TABLE `consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credential` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `key_hash` varchar(64) NOT NULL,
  `encrypted_blob` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint` (
  `id` varchar(64) NOT NULL,
  `legacy_endpoint_id` varchar(64) DEFAULT NULL,
  `interface` varchar(8) NOT NULL,
  `service_id` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `region_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_endpoint_region_id` (`region_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `endpoint_service_id_fkey` FOREIGN KEY (`service_id`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_endpoint_region_id` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
INSERT INTO `endpoint` (`id`, `legacy_endpoint_id`, `interface`, `service_id`, `url`, `extra`, `enabled`, `region_id`) VALUES ('1169ac49d08d47eb8ebf43a25817afb9',NULL,'internal','fe2ea3816a354dc19a4c123ba1052720','https://glance-default-internal.openstack.svc:9292','{\"name\": \"glance\"}',1,'regionOne'),('139f9aff87bf4d9bae27416bbaab29cc',NULL,'internal','9558262ca0014ff6b26cc5e7fee9c122','https://barbican-internal.openstack.svc:9311','{\"name\": \"barbican\"}',1,'regionOne'),('5ee2cb16ff27490cbe5147172534849d',NULL,'public','38b9e926363f46a0977da878d6c77619','https://neutron-public-openstack.apps-crc.testing','{\"name\": \"neutron\"}',1,'regionOne'),('61f4653385fd42619a5f7cfbca330152',NULL,'public','d1dc8935dbe84cd7a3f63f4e0c8898d8','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne'),('62d45dedcf7d469699aecae02eeafd5a',NULL,'internal','1b2366f0addb45439c1fd4be37efd6bd','https://nova-internal.openstack.svc:8774/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('682a21db9879404d91fe88d363da7a39',NULL,'public','6d3cf1dfd9c44d8c8d6b877d0150dac5','https://placement-public-openstack.apps-crc.testing','{\"name\": \"placement\"}',1,'regionOne'),('8a41b1f817304922a6f77c8df6cdf5fe',NULL,'internal','6d3cf1dfd9c44d8c8d6b877d0150dac5','https://placement-internal.openstack.svc:8778','{\"name\": \"placement\"}',1,'regionOne'),('a3e1a885f2b9427abb0b4d12b8fd2d74',NULL,'internal','cf6fe3f52a634b5398f6784284cf287c','https://cinder-internal.openstack.svc:8776/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('c60af32f54104523b0436dd0aa8c0539',NULL,'public','fe2ea3816a354dc19a4c123ba1052720','https://glance-default-public-openstack.apps-crc.testing','{\"name\": \"glance\"}',1,'regionOne'),('c762a94619ec4f7a9e2e6b493ad1b329',NULL,'public','1b2366f0addb45439c1fd4be37efd6bd','https://nova-public-openstack.apps-crc.testing/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('d5c12f8df87a43eda3b8b2d17d696678',NULL,'public','cf6fe3f52a634b5398f6784284cf287c','https://cinder-public-openstack.apps-crc.testing/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('e02634d028de4b76b550e13d77358afb',NULL,'internal','38b9e926363f46a0977da878d6c77619','https://neutron-internal.openstack.svc:9696','{\"name\": \"neutron\"}',1,'regionOne'),('e4f840c3e0044eabb8e62b21b49e04b2',NULL,'public','d645029339414c309147da31876ff41f','https://keystone-public-openstack.apps-crc.testing','{}',1,'regionOne'),('e508025707f24b548c006cf596626eb3',NULL,'internal','d645029339414c309147da31876ff41f','https://keystone-internal.openstack.svc:5000','{}',1,'regionOne'),('fdda647b77ca49448978d7947eadc435',NULL,'internal','d1dc8935dbe84cd7a3f63f4e0c8898d8','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne'),('fe1e65fb01b94bc194cb2c0ac8dc5bba',NULL,'public','9558262ca0014ff6b26cc5e7fee9c122','https://barbican-public-openstack.apps-crc.testing','{\"name\": \"barbican\"}',1,'regionOne');
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint_group`
--

DROP TABLE IF EXISTS `endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint_group` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `filters` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint_group`
--

LOCK TABLES `endpoint_group` WRITE;
/*!40000 ALTER TABLE `endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expiring_user_group_membership`
--

DROP TABLE IF EXISTS `expiring_user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expiring_user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `last_verified` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`,`idp_id`),
  KEY `group_id` (`group_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_3` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expiring_user_group_membership`
--

LOCK TABLES `expiring_user_group_membership` WRITE;
/*!40000 ALTER TABLE `expiring_user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `expiring_user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federated_user`
--

DROP TABLE IF EXISTS `federated_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federated_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `protocol_id` varchar(64) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idp_id` (`idp_id`,`protocol_id`,`unique_id`),
  KEY `federated_user_protocol_id_fkey` (`protocol_id`,`idp_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `federated_user_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_ibfk_2` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_protocol_id_fkey` FOREIGN KEY (`protocol_id`, `idp_id`) REFERENCES `federation_protocol` (`id`, `idp_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federated_user`
--

LOCK TABLES `federated_user` WRITE;
/*!40000 ALTER TABLE `federated_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `federated_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federation_protocol`
--

DROP TABLE IF EXISTS `federation_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federation_protocol` (
  `id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `mapping_id` varchar(64) NOT NULL,
  `remote_id_attribute` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`,`idp_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `federation_protocol_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federation_protocol`
--

LOCK TABLES `federation_protocol` WRITE;
/*!40000 ALTER TABLE `federation_protocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `federation_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group`
--

DROP TABLE IF EXISTS `group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group` (
  `id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_group_name_domain_id` (`domain_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group`
--

LOCK TABLES `group` WRITE;
/*!40000 ALTER TABLE `group` DISABLE KEYS */;
/*!40000 ALTER TABLE `group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `id_mapping`
--

DROP TABLE IF EXISTS `id_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `id_mapping` (
  `public_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `local_id` varchar(255) NOT NULL,
  `entity_type` enum('user','group') NOT NULL,
  PRIMARY KEY (`public_id`),
  UNIQUE KEY `domain_id` (`domain_id`,`local_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `id_mapping`
--

LOCK TABLES `id_mapping` WRITE;
/*!40000 ALTER TABLE `id_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `id_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `identity_provider`
--

DROP TABLE IF EXISTS `identity_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `identity_provider` (
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `authorization_ttl` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `identity_provider`
--

LOCK TABLES `identity_provider` WRITE;
/*!40000 ALTER TABLE `identity_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `identity_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `idp_remote_ids`
--

DROP TABLE IF EXISTS `idp_remote_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `idp_remote_ids` (
  `idp_id` varchar(64) DEFAULT NULL,
  `remote_id` varchar(255) NOT NULL,
  PRIMARY KEY (`remote_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `idp_remote_ids_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `idp_remote_ids`
--

LOCK TABLES `idp_remote_ids` WRITE;
/*!40000 ALTER TABLE `idp_remote_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `idp_remote_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `implied_role`
--

DROP TABLE IF EXISTS `implied_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `implied_role` (
  `prior_role_id` varchar(64) NOT NULL,
  `implied_role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`prior_role_id`,`implied_role_id`),
  KEY `implied_role_implied_role_id_fkey` (`implied_role_id`),
  CONSTRAINT `implied_role_implied_role_id_fkey` FOREIGN KEY (`implied_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE,
  CONSTRAINT `implied_role_prior_role_id_fkey` FOREIGN KEY (`prior_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `implied_role`
--

LOCK TABLES `implied_role` WRITE;
/*!40000 ALTER TABLE `implied_role` DISABLE KEYS */;
INSERT INTO `implied_role` (`prior_role_id`, `implied_role_id`) VALUES ('4d67b005c4d741e8bef0179c58976a2c','8aa1ee34c62845fbaba587d241e79078'),('8855e2cc253a496086a7695dd9c0b945','4d67b005c4d741e8bef0179c58976a2c');
/*!40000 ALTER TABLE `implied_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `limit`
--

DROP TABLE IF EXISTS `limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `limit` (
  `id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `resource_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `registered_limit_id` varchar(64) DEFAULT NULL,
  `domain_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `limit_id_key` (`id`),
  KEY `registered_limit_id` (`registered_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `limit`
--

LOCK TABLES `limit` WRITE;
/*!40000 ALTER TABLE `limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_user`
--

DROP TABLE IF EXISTS `local_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `local_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `failed_auth_count` int(11) DEFAULT NULL,
  `failed_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_id` (`domain_id`,`name`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `local_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `local_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=254 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `local_user`
--

LOCK TABLES `local_user` WRITE;
/*!40000 ALTER TABLE `local_user` DISABLE KEYS */;
INSERT INTO `local_user` (`id`, `user_id`, `domain_id`, `name`, `failed_auth_count`, `failed_auth_at`) VALUES (1,'57823c2cf8a04b2abc574ed057efc3db','default','admin',0,NULL),(2,'859ffbc3614042108037541e456daa78','default','ceilometer',0,NULL),(3,'bb38f143b67741f380a581625d2d2a5c','default','glance',0,NULL),(4,'8ca87a1850614c06b2e2165883628d33','default','nova',0,NULL),(5,'2ba37b62dd5f4f568f4f548411019b19','default','barbican',0,NULL),(6,'f2700629748f4a53afaee0e33dc39c53','default','cinder',0,NULL),(7,'62dc8ee9765446f9820441bcf401f4cc','default','placement',0,NULL),(8,'d55b3ee250d1468fbcf33643dda37adb','default','neutron',0,NULL),(9,'bcce56fe65b04eb9aa1d1152b7e73d5f','default','swift',0,NULL),(10,'b50e11eaa8fa4f07a33c6bb9133ca7ca','default','demo_tempestconf',0,NULL),(11,'4139fcfb31e0453ca7277317523f248f','default','alt_demo_tempestconf',0,NULL);
/*!40000 ALTER TABLE `local_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mapping`
--

DROP TABLE IF EXISTS `mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mapping` (
  `id` varchar(64) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mapping`
--

LOCK TABLES `mapping` WRITE;
/*!40000 ALTER TABLE `mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nonlocal_user`
--

DROP TABLE IF EXISTS `nonlocal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nonlocal_user` (
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  PRIMARY KEY (`domain_id`,`name`),
  UNIQUE KEY `ixu_nonlocal_user_user_id` (`user_id`),
  KEY `nonlocal_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `nonlocal_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nonlocal_user`
--

LOCK TABLES `nonlocal_user` WRITE;
/*!40000 ALTER TABLE `nonlocal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `nonlocal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password`
--

DROP TABLE IF EXISTS `password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_user_id` int(11) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `self_service` tinyint(1) NOT NULL DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `created_at_int` bigint(20) NOT NULL DEFAULT 0,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `local_user_id` (`local_user_id`),
  CONSTRAINT `password_ibfk_1` FOREIGN KEY (`local_user_id`) REFERENCES `local_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=254 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password`
--

LOCK TABLES `password` WRITE;
/*!40000 ALTER TABLE `password` DISABLE KEYS */;
INSERT INTO `password` (`id`, `local_user_id`, `expires_at`, `self_service`, `password_hash`, `created_at_int`, `expires_at_int`, `created_at`) VALUES (1,1,NULL,0,'$2b$12$r/70BFCxSz0ZBWFhl3y2HeAoX4reiCiFkizxAiKJM.iEr9uDn0HiS',1759403526803583,NULL,'2025-10-02 11:12:06'),(2,2,NULL,0,'$2b$12$6XaY87aolsYQiabo4GTCqepCarz2bJAkYBo2m4Vo0.EDv/rf.j2KK',1759403587193662,NULL,'2025-10-02 11:13:07'),(3,3,NULL,0,'$2b$12$vGWvBJ9cKYhx2.bdxXGgpu6/fArNx9omhk/oQwpe.caUprkDuRW2G',1759403601233511,NULL,'2025-10-02 11:13:21'),(4,4,NULL,0,'$2b$12$Xc.Rjr7cKuasNZWZZLm5/euxCaRqQ4nBK0niaXJnJ5TCkRB23mIum',1759403605045459,NULL,'2025-10-02 11:13:25'),(5,5,NULL,0,'$2b$12$je38uj3mQSu.SNqGCz4LlOsf6DNtQTXk3FmkrNLoqzsRsUKfc618O',1759403611121145,NULL,'2025-10-02 11:13:31'),(6,6,NULL,0,'$2b$12$MLwQVYLbvkJQgW0YKFUzOuBeehxYGkimEtnWa9f3iGWwjTwNkr7HG',1759403639934048,NULL,'2025-10-02 11:13:59'),(7,7,NULL,0,'$2b$12$5NlGKeNS.0P1.yJCV2XfVOoWsPUGvxVhyoKpLSHe/0UwQCyoG9.aO',1759403645416939,NULL,'2025-10-02 11:14:05'),(8,8,NULL,0,'$2b$12$FlxrZUgluVUQ9rU8dUpUV.vajEpZ6YHvUXwnWmFD0K2aMRWWRZNXO',1759403657611142,NULL,'2025-10-02 11:14:17'),(9,9,NULL,0,'$2b$12$o7gFxGDayYY0.iR3tcTq8..itDGQwOUVWMT/shrYPmeWcKt0AnJ32',1759404898024167,NULL,'2025-10-02 11:34:58'),(10,10,NULL,0,'$2b$12$plJh8TEpNEvn3uPMHNCvCuFi/s2LSfo8VrXX0msV3YdpiG8OfjDgG',1759406251274122,NULL,'2025-10-02 11:57:31'),(11,11,NULL,0,'$2b$12$zy2cqRbxDSZXJc6BfkRkEOZSsAkPqU2.maGHgyChPkoD0rNR7g7OS',1759406254999200,NULL,'2025-10-02 11:57:34');
/*!40000 ALTER TABLE `password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `blob` text NOT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_association`
--

DROP TABLE IF EXISTS `policy_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy_association` (
  `id` varchar(64) NOT NULL,
  `policy_id` varchar(64) NOT NULL,
  `endpoint_id` varchar(64) DEFAULT NULL,
  `service_id` varchar(64) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `endpoint_id` (`endpoint_id`,`service_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_association`
--

LOCK TABLES `policy_association` WRITE;
/*!40000 ALTER TABLE `policy_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project` (
  `id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL,
  `is_domain` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_project_name_domain_id` (`domain_id`,`name`),
  KEY `project_parent_id_fkey` (`parent_id`),
  CONSTRAINT `project_domain_id_fkey` FOREIGN KEY (`domain_id`) REFERENCES `project` (`id`),
  CONSTRAINT `project_parent_id_fkey` FOREIGN KEY (`parent_id`) REFERENCES `project` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
INSERT INTO `project` (`id`, `name`, `extra`, `description`, `enabled`, `domain_id`, `parent_id`, `is_domain`) VALUES ('1533ac528d35434c826050eed402afba','admin','{}','Bootstrap project for initializing the cloud.',1,'default','default',0),('<<keystone.domain.root>>','<<keystone.domain.root>>','{}','',0,'<<keystone.domain.root>>',NULL,1),('aebeb47424cc4f05b6c098503009ac0d','service','{}','service',1,'default','default',0),('db0711c79d3343a6b45eee0c395c823b','demo','{}','Project for Tempest demo_tempestconf user',1,'default','default',0),('default','Default','{}','The default domain',1,'<<keystone.domain.root>>',NULL,1),('f83c515bcd6b4dc19a7e40bd81643192','alt_demo','{}','Project for Tempest alt_demo_tempestconf user',1,'default','default',0);
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint`
--

DROP TABLE IF EXISTS `project_endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint` (
  `endpoint_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint`
--

LOCK TABLES `project_endpoint` WRITE;
/*!40000 ALTER TABLE `project_endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint_group`
--

DROP TABLE IF EXISTS `project_endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint_group` (
  `endpoint_group_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_group_id`,`project_id`),
  CONSTRAINT `project_endpoint_group_ibfk_1` FOREIGN KEY (`endpoint_group_id`) REFERENCES `endpoint_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint_group`
--

LOCK TABLES `project_endpoint_group` WRITE;
/*!40000 ALTER TABLE `project_endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_option`
--

DROP TABLE IF EXISTS `project_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_option` (
  `project_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`project_id`,`option_id`),
  CONSTRAINT `project_option_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_option`
--

LOCK TABLES `project_option` WRITE;
/*!40000 ALTER TABLE `project_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_tag`
--

DROP TABLE IF EXISTS `project_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_tag` (
  `project_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`project_id`,`name`),
  UNIQUE KEY `project_id` (`project_id`,`name`),
  CONSTRAINT `project_tag_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_tag`
--

LOCK TABLES `project_tag` WRITE;
/*!40000 ALTER TABLE `project_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `parent_region_id` varchar(255) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` (`id`, `description`, `parent_region_id`, `extra`) VALUES ('regionOne','',NULL,'{}');
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registered_limit`
--

DROP TABLE IF EXISTS `registered_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `registered_limit` (
  `id` varchar(64) NOT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `default_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `registered_limit_id_key` (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `registered_limit`
--

LOCK TABLES `registered_limit` WRITE;
/*!40000 ALTER TABLE `registered_limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `registered_limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_token`
--

DROP TABLE IF EXISTS `request_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_token` (
  `id` varchar(64) NOT NULL,
  `request_secret` varchar(64) NOT NULL,
  `verifier` varchar(64) DEFAULT NULL,
  `authorizing_user_id` varchar(64) DEFAULT NULL,
  `requested_project_id` varchar(64) NOT NULL,
  `role_ids` text DEFAULT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_request_token_consumer_id` (`consumer_id`),
  CONSTRAINT `request_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_token`
--

LOCK TABLES `request_token` WRITE;
/*!40000 ALTER TABLE `request_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revocation_event`
--

DROP TABLE IF EXISTS `revocation_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revocation_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` varchar(64) DEFAULT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  `role_id` varchar(64) DEFAULT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `consumer_id` varchar(64) DEFAULT NULL,
  `access_token_id` varchar(64) DEFAULT NULL,
  `issued_before` datetime NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `revoked_at` datetime NOT NULL,
  `audit_id` varchar(32) DEFAULT NULL,
  `audit_chain_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_revocation_event_issued_before` (`issued_before`),
  KEY `ix_revocation_event_project_id_issued_before` (`project_id`,`issued_before`),
  KEY `ix_revocation_event_user_id_issued_before` (`user_id`,`issued_before`),
  KEY `ix_revocation_event_audit_id_issued_before` (`audit_id`,`issued_before`),
  KEY `ix_revocation_event_new_revoked_at` (`revoked_at`)
) ENGINE=InnoDB AUTO_INCREMENT=482 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revocation_event`
--

LOCK TABLES `revocation_event` WRITE;
/*!40000 ALTER TABLE `revocation_event` DISABLE KEYS */;
INSERT INTO `revocation_event` (`id`, `domain_id`, `project_id`, `user_id`, `role_id`, `trust_id`, `consumer_id`, `access_token_id`, `issued_before`, `expires_at`, `revoked_at`, `audit_id`, `audit_chain_id`) VALUES (1,NULL,NULL,'06f6da729ff34c29b3e1c9c9b5dd81ed',NULL,NULL,NULL,NULL,'2025-10-02 11:58:10',NULL,'2025-10-02 11:58:10',NULL,NULL),(2,NULL,NULL,'f8dc52aa381448269946038202b87fc7',NULL,NULL,NULL,NULL,'2025-10-02 11:58:11',NULL,'2025-10-02 11:58:11',NULL,NULL),(3,NULL,'d7ae58351571405d8859aabced8961ba',NULL,NULL,NULL,NULL,NULL,'2025-10-02 11:58:13',NULL,'2025-10-02 11:58:13',NULL,NULL),(4,NULL,'ea6f939f46f0494db9e169f5afef05f1',NULL,NULL,NULL,NULL,NULL,'2025-10-02 11:58:15',NULL,'2025-10-02 11:58:15',NULL,NULL),(5,NULL,NULL,'78c3e3c284e54ba1aadd31e87a3b9260',NULL,NULL,NULL,NULL,'2025-10-02 11:58:18',NULL,'2025-10-02 11:58:18',NULL,NULL),(6,NULL,NULL,'9269966e86d64b89abaf9e1e9246e6f5',NULL,NULL,NULL,NULL,'2025-10-02 11:58:18',NULL,'2025-10-02 11:58:18',NULL,NULL),(7,NULL,NULL,'86343ce7d92040cda499299697de87b7',NULL,NULL,NULL,NULL,'2025-10-02 11:58:20',NULL,'2025-10-02 11:58:20',NULL,NULL),(8,NULL,NULL,'e1f6cbb7e9c54f8c90776ced04957455',NULL,NULL,NULL,NULL,'2025-10-02 11:58:20',NULL,'2025-10-02 11:58:20',NULL,NULL),(9,NULL,'207f2f8120654a4fb6286f9d49f1f98d',NULL,NULL,NULL,NULL,NULL,'2025-10-02 11:58:20',NULL,'2025-10-02 11:58:20',NULL,NULL),(10,NULL,'d5a1d0deb2b448b5acaa759421430202',NULL,NULL,NULL,NULL,NULL,'2025-10-02 11:58:21',NULL,'2025-10-02 11:58:21',NULL,NULL),(11,NULL,'0307d704add34f9193d9bf54b61a9dba',NULL,NULL,NULL,NULL,NULL,'2025-10-02 11:58:21',NULL,'2025-10-02 11:58:21',NULL,NULL),(12,NULL,'987fbbd00c4b4501bb08f7da146c6b03',NULL,NULL,NULL,NULL,NULL,'2025-10-02 11:58:22',NULL,'2025-10-02 11:58:22',NULL,NULL),(13,NULL,NULL,'1d32b60db476419787ae75ce5f97b2b0',NULL,NULL,NULL,NULL,'2025-10-02 11:58:28',NULL,'2025-10-02 11:58:28',NULL,NULL),(14,NULL,NULL,'3d04499745974bee95a8cf060aa5698e',NULL,NULL,NULL,NULL,'2025-10-02 11:58:28',NULL,'2025-10-02 11:58:28',NULL,NULL),(15,NULL,'7584d0d3d150441f85ef4124e09fad7a',NULL,NULL,NULL,NULL,NULL,'2025-10-02 11:58:31',NULL,'2025-10-02 11:58:31',NULL,NULL),(16,NULL,NULL,'6a5ae4350cea489cbe7e6fb32dfca206',NULL,NULL,NULL,NULL,'2025-10-02 11:58:31',NULL,'2025-10-02 11:58:31',NULL,NULL),(17,NULL,NULL,'5ce3e5368d0e44269f357f9e31c8e665',NULL,NULL,NULL,NULL,'2025-10-02 11:58:32',NULL,'2025-10-02 11:58:32',NULL,NULL),(18,NULL,'295fcfaf9f484aa7affa8d2aca044c7a',NULL,NULL,NULL,NULL,NULL,'2025-10-02 11:58:32',NULL,'2025-10-02 11:58:32',NULL,NULL),(19,NULL,NULL,'1b7cf4072ed941de94801c77b30554ba',NULL,NULL,NULL,NULL,'2025-10-02 11:58:32',NULL,'2025-10-02 11:58:32',NULL,NULL),(20,NULL,'939ff0c6e39348d8916fcd1b53084026',NULL,NULL,NULL,NULL,NULL,'2025-10-02 11:58:35',NULL,'2025-10-02 11:58:35',NULL,NULL),(21,NULL,'b67fdcb997fb46e9950204612924e1b4',NULL,NULL,NULL,NULL,NULL,'2025-10-02 11:58:36',NULL,'2025-10-02 11:58:36',NULL,NULL),(22,NULL,NULL,'a2873a462a344590a18de294d1b63b76',NULL,NULL,NULL,NULL,'2025-10-02 11:58:37',NULL,'2025-10-02 11:58:37',NULL,NULL),(23,NULL,'e8d4d71c5ff34138a785b5660eba46cf',NULL,NULL,NULL,NULL,NULL,'2025-10-02 11:58:38',NULL,'2025-10-02 11:58:38',NULL,NULL),(24,NULL,NULL,'404b7d592a334dc3ac6e0f5f3308cb64',NULL,NULL,NULL,NULL,'2025-10-02 11:58:38',NULL,'2025-10-02 11:58:38',NULL,NULL),(25,NULL,'f2e047c882184edc917d9ded327e8f6a',NULL,NULL,NULL,NULL,NULL,'2025-10-02 11:58:40',NULL,'2025-10-02 11:58:40',NULL,NULL),(26,NULL,'42ace74ca9f743eab4c41f6646b87aa7',NULL,NULL,NULL,NULL,NULL,'2025-10-02 11:58:42',NULL,'2025-10-02 11:58:42',NULL,NULL),(27,NULL,NULL,'91d6c025ee5448bdacca3569fc4b2509',NULL,NULL,NULL,NULL,'2025-10-02 11:58:42',NULL,'2025-10-02 11:58:42',NULL,NULL),(28,NULL,NULL,'8ecbcd7e9f914d178d19f28ef0b304c3',NULL,NULL,NULL,NULL,'2025-10-02 11:58:42',NULL,'2025-10-02 11:58:42',NULL,NULL),(29,NULL,'dadb6af272354c46a3a289d905c84a3e',NULL,NULL,NULL,NULL,NULL,'2025-10-02 11:58:45',NULL,'2025-10-02 11:58:45',NULL,NULL),(30,NULL,'60cc5b1f68ed451c94f66daa7649a665',NULL,NULL,NULL,NULL,NULL,'2025-10-02 11:58:47',NULL,'2025-10-02 11:58:47',NULL,NULL),(31,NULL,NULL,'d86faba332f04a73a1274774378033db',NULL,NULL,NULL,NULL,'2025-10-02 11:58:48',NULL,'2025-10-02 11:58:48',NULL,NULL),(32,NULL,NULL,'d09a8e0c084648b496ef48909eefd722',NULL,NULL,NULL,NULL,'2025-10-02 11:58:48',NULL,'2025-10-02 11:58:48',NULL,NULL),(33,NULL,'07238be87036450fb78f2d62cdd01477',NULL,NULL,NULL,NULL,NULL,'2025-10-02 11:58:50',NULL,'2025-10-02 11:58:50',NULL,NULL),(34,NULL,'abe3cc8da3434a21823a71b307a81a45',NULL,NULL,NULL,NULL,NULL,'2025-10-02 11:58:52',NULL,'2025-10-02 11:58:52',NULL,NULL),(35,NULL,NULL,'626737f8e48145c6af508b1948b3962b',NULL,NULL,NULL,NULL,'2025-10-02 11:58:52',NULL,'2025-10-02 11:58:52',NULL,NULL),(36,NULL,NULL,'0f18874f3a7e4da0aae013d5e8fa1344',NULL,NULL,NULL,NULL,'2025-10-02 11:58:53',NULL,'2025-10-02 11:58:53',NULL,NULL),(37,NULL,'b897f46598b74c56a4daf367fc66ff4c',NULL,NULL,NULL,NULL,NULL,'2025-10-02 11:58:55',NULL,'2025-10-02 11:58:55',NULL,NULL),(38,NULL,NULL,'8551560d44b449a484cb1f08c3abb4cc',NULL,NULL,NULL,NULL,'2025-10-02 11:58:56',NULL,'2025-10-02 11:58:56',NULL,NULL),(39,NULL,NULL,'61c9dc30f57741f2be73e54b95cbf960',NULL,NULL,NULL,NULL,'2025-10-02 11:58:57',NULL,'2025-10-02 11:58:57',NULL,NULL),(40,NULL,'52b89bdb6ae24e24bb1d20b774537a6f',NULL,NULL,NULL,NULL,NULL,'2025-10-02 11:58:57',NULL,'2025-10-02 11:58:57',NULL,NULL),(41,NULL,'30893bcdc04345988ece9d8cf9cedc8c',NULL,NULL,NULL,NULL,NULL,'2025-10-02 11:58:59',NULL,'2025-10-02 11:58:59',NULL,NULL),(42,NULL,'d979a77f0d1b412d8a23824fae491b97',NULL,NULL,NULL,NULL,NULL,'2025-10-02 11:59:00',NULL,'2025-10-02 11:59:00',NULL,NULL),(43,NULL,NULL,'4a24ff70378443b5bc0a9b9c8df78885',NULL,NULL,NULL,NULL,'2025-10-02 11:59:02',NULL,'2025-10-02 11:59:02',NULL,NULL),(44,NULL,NULL,'83577519e0ba4d31b3fe9296bcec84da',NULL,NULL,NULL,NULL,'2025-10-02 11:59:02',NULL,'2025-10-02 11:59:02',NULL,NULL),(45,NULL,'d7b8340ac406494e8c954251502238ca',NULL,NULL,NULL,NULL,NULL,'2025-10-02 11:59:04',NULL,'2025-10-02 11:59:04',NULL,NULL),(46,NULL,'d646660c3ec44ef9a9b8255d5f749fea',NULL,NULL,NULL,NULL,NULL,'2025-10-02 11:59:05',NULL,'2025-10-02 11:59:05',NULL,NULL),(47,NULL,NULL,'3b23f394cfcf4d478dcfb584af3d8513',NULL,NULL,NULL,NULL,'2025-10-02 11:59:09',NULL,'2025-10-02 11:59:09',NULL,NULL),(48,NULL,NULL,'477da58f6d5540358a4682b487dc1016',NULL,NULL,NULL,NULL,'2025-10-02 11:59:09',NULL,'2025-10-02 11:59:09',NULL,NULL),(49,NULL,'6f208dd9c9ad498e900715f7ea7e52da',NULL,NULL,NULL,NULL,NULL,'2025-10-02 11:59:10',NULL,'2025-10-02 11:59:10',NULL,NULL),(50,NULL,'0c5c2f6089d84cc388b98b3584500c19',NULL,NULL,NULL,NULL,NULL,'2025-10-02 11:59:12',NULL,'2025-10-02 11:59:12',NULL,NULL),(51,NULL,NULL,'17903cd0333c407b96f0aede6dd3b16c',NULL,NULL,NULL,NULL,'2025-10-02 11:59:34',NULL,'2025-10-02 11:59:34',NULL,NULL),(52,NULL,'8972026d0f3a4bf4b6debd9555f9225c',NULL,NULL,NULL,NULL,NULL,'2025-10-02 11:59:35',NULL,'2025-10-02 11:59:35',NULL,NULL),(53,NULL,NULL,'455a5d85cd084a4ca5060eb8974fb800',NULL,NULL,NULL,NULL,'2025-10-02 11:59:39',NULL,'2025-10-02 11:59:39',NULL,NULL),(54,NULL,NULL,'4e20c17ccf984a22b9bdc7ad48e8a095',NULL,NULL,NULL,NULL,'2025-10-02 11:59:39',NULL,'2025-10-02 11:59:39',NULL,NULL),(55,NULL,'352c969fb9ef4228b69c58972f2ca7e8',NULL,NULL,NULL,NULL,NULL,'2025-10-02 11:59:40',NULL,'2025-10-02 11:59:40',NULL,NULL),(56,NULL,'e03702034fe34d5aadef080421cefb95',NULL,NULL,NULL,NULL,NULL,'2025-10-02 11:59:42',NULL,'2025-10-02 11:59:42',NULL,NULL),(57,NULL,NULL,'9fd9f964112745dd80d9aa8f83caae89',NULL,NULL,NULL,NULL,'2025-10-02 11:59:49',NULL,'2025-10-02 11:59:49',NULL,NULL),(58,NULL,NULL,'f130650c489c4defb52ff0165fb14517',NULL,NULL,NULL,NULL,'2025-10-02 11:59:50',NULL,'2025-10-02 11:59:50',NULL,NULL),(59,NULL,'bf3dc78cdd8440fdb001acdd63171511',NULL,NULL,NULL,NULL,NULL,'2025-10-02 11:59:51',NULL,'2025-10-02 11:59:51',NULL,NULL),(60,NULL,'08c5852209994abd9c157755a71c26ce',NULL,NULL,NULL,NULL,NULL,'2025-10-02 11:59:51',NULL,'2025-10-02 11:59:51',NULL,NULL),(61,NULL,NULL,'44d31249ad664612ac3c0101f25cd102',NULL,NULL,NULL,NULL,'2025-10-02 11:59:56',NULL,'2025-10-02 11:59:56',NULL,NULL),(62,NULL,NULL,'4e647157b1c5404b9f61143977bb6bc7',NULL,NULL,NULL,NULL,'2025-10-02 11:59:56',NULL,'2025-10-02 11:59:56',NULL,NULL),(63,NULL,'8af54fc101684cc9bb4645f4420ea824',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:00:00',NULL,'2025-10-02 12:00:00',NULL,NULL),(64,NULL,'54365d5636b147548f4efef261c54283',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:00:04',NULL,'2025-10-02 12:00:04',NULL,NULL),(65,NULL,NULL,'05f506df2a9b464fb151c2dc89654d27',NULL,NULL,NULL,NULL,'2025-10-02 12:00:09',NULL,'2025-10-02 12:00:09',NULL,NULL),(66,NULL,NULL,'af4bdaaf66b9479d912bce54ffe803a0',NULL,NULL,NULL,NULL,'2025-10-02 12:00:10',NULL,'2025-10-02 12:00:10',NULL,NULL),(67,NULL,'5795346621f54bb09766e916734047a3',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:00:15',NULL,'2025-10-02 12:00:15',NULL,NULL),(68,NULL,'8d34b7cb23b6481fab7f2907740aa600',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:00:18',NULL,'2025-10-02 12:00:18',NULL,NULL),(69,NULL,NULL,'39f72bf379684b959071ccdf03f5f52f',NULL,NULL,NULL,NULL,'2025-10-02 12:00:23',NULL,'2025-10-02 12:00:23',NULL,NULL),(70,NULL,NULL,'11cba1de83a640aabbce96d56cb376fc',NULL,NULL,NULL,NULL,'2025-10-02 12:00:23',NULL,'2025-10-02 12:00:23',NULL,NULL),(71,NULL,NULL,'9ea6f16f5b154686a9e7eb51a974118c',NULL,NULL,NULL,NULL,'2025-10-02 12:00:23',NULL,'2025-10-02 12:00:23',NULL,NULL),(72,NULL,NULL,'1c22e5d8d5ad46a997c3881c394a1d70',NULL,NULL,NULL,NULL,'2025-10-02 12:00:24',NULL,'2025-10-02 12:00:24',NULL,NULL),(73,NULL,'8b14804ff58240e7b32c0c58b913b595',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:00:24',NULL,'2025-10-02 12:00:24',NULL,NULL),(74,NULL,NULL,'84a90c15c84742b5aa8b02ab858d4ea3',NULL,NULL,NULL,NULL,'2025-10-02 12:00:24',NULL,'2025-10-02 12:00:24',NULL,NULL),(75,NULL,'9fab310b79144b0baa3a349f8bb4143f',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:00:25',NULL,'2025-10-02 12:00:25',NULL,NULL),(76,NULL,'be045fc1d9c1467e9fffd70aa8041e2f',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:00:26',NULL,'2025-10-02 12:00:26',NULL,NULL),(77,NULL,'6807e9c97bd646799d4adfa12cdbd47e',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:00:26',NULL,'2025-10-02 12:00:26',NULL,NULL),(78,NULL,'a6ad3a74027b4d9e818b03df35aea114',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:00:27',NULL,'2025-10-02 12:00:27',NULL,NULL),(79,NULL,NULL,'7775a4e107454c4da8a8e43d1b297e88',NULL,NULL,NULL,NULL,'2025-10-02 12:00:31',NULL,'2025-10-02 12:00:31',NULL,NULL),(80,NULL,NULL,'d314c8249d024aa9aeb463b91527538d',NULL,NULL,NULL,NULL,'2025-10-02 12:00:32',NULL,'2025-10-02 12:00:32',NULL,NULL),(81,NULL,'b7e55c19b975409eb18c8005e4c9595a',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:00:34',NULL,'2025-10-02 12:00:34',NULL,NULL),(82,NULL,'64fe9972c98c46a8b0c57186e1852d8d',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:00:36',NULL,'2025-10-02 12:00:36',NULL,NULL),(83,NULL,NULL,'4f4106c2a0e54f53be56646ffab46e54',NULL,NULL,NULL,NULL,'2025-10-02 12:00:42',NULL,'2025-10-02 12:00:42',NULL,NULL),(84,NULL,NULL,'d41e5d6a3ef041f2b6e0a37b3a127c73',NULL,NULL,NULL,NULL,'2025-10-02 12:00:43',NULL,'2025-10-02 12:00:43',NULL,NULL),(85,NULL,'708213de25ee47df8e695c3cb20e07a7',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:00:44',NULL,'2025-10-02 12:00:44',NULL,NULL),(86,NULL,'52f80e10f15a4400924092c9ee06873c',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:00:46',NULL,'2025-10-02 12:00:46',NULL,NULL),(87,NULL,NULL,'b54b5e15e4c94d1f95a272981e9d9a89',NULL,NULL,NULL,NULL,'2025-10-02 12:02:15',NULL,'2025-10-02 12:02:15',NULL,NULL),(88,NULL,NULL,'32f8fed535f24050a59db923cb598449',NULL,NULL,NULL,NULL,'2025-10-02 12:02:15',NULL,'2025-10-02 12:02:15',NULL,NULL),(89,NULL,'d977ad6a90874946819537242925a8f0',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:02:16',NULL,'2025-10-02 12:02:16',NULL,NULL),(90,NULL,'c62476b2f92d43e69b75e06947d0e894',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:02:17',NULL,'2025-10-02 12:02:17',NULL,NULL),(91,NULL,NULL,'1a06819bf8cc4ff7bccbbb2616ff2d21',NULL,NULL,NULL,NULL,'2025-10-02 12:02:31',NULL,'2025-10-02 12:02:31',NULL,NULL),(92,NULL,NULL,'4b9a52c4eb834c90b054f480d8de237c',NULL,NULL,NULL,NULL,'2025-10-02 12:02:32',NULL,'2025-10-02 12:02:32',NULL,NULL),(93,NULL,'453cdd07db3b4f158d23674cf6281d92',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:02:34',NULL,'2025-10-02 12:02:34',NULL,NULL),(94,NULL,'f1ce36070fb047479c3a083f36733f63',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:02:35',NULL,'2025-10-02 12:02:35',NULL,NULL),(95,NULL,NULL,'a864002d4beb4675a60a587081657213',NULL,NULL,NULL,NULL,'2025-10-02 12:02:40',NULL,'2025-10-02 12:02:40',NULL,NULL),(96,NULL,NULL,'3d0afccdd3f24329983ac6a9d360128f',NULL,NULL,NULL,NULL,'2025-10-02 12:02:40',NULL,'2025-10-02 12:02:40',NULL,NULL),(97,NULL,'a8a3c03c3e8e4eabad19d5fdaa4d1c29',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:02:41',NULL,'2025-10-02 12:02:41',NULL,NULL),(98,NULL,'24721d605f5b438e8cc29117a8b04270',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:02:44',NULL,'2025-10-02 12:02:44',NULL,NULL),(99,NULL,NULL,'f4a02a1717144da38c573ce51c727de8',NULL,NULL,NULL,NULL,'2025-10-02 12:02:55',NULL,'2025-10-02 12:02:55',NULL,NULL),(100,NULL,NULL,'ea56e9c1b4444513a614a07cf3bd8751',NULL,NULL,NULL,NULL,'2025-10-02 12:02:55',NULL,'2025-10-02 12:02:55',NULL,NULL),(101,NULL,NULL,'bea607da06554a67af45c6df851f7c86',NULL,NULL,NULL,NULL,'2025-10-02 12:02:56',NULL,'2025-10-02 12:02:56',NULL,NULL),(102,NULL,NULL,'0fd4663173a44abeb138d3d6a20f8d17',NULL,NULL,NULL,NULL,'2025-10-02 12:02:56',NULL,'2025-10-02 12:02:56',NULL,NULL),(103,NULL,'c5e9843847ca40818aeb259ea2034043',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:02:57',NULL,'2025-10-02 12:02:57',NULL,NULL),(104,NULL,'1040113416964f64b0f1153ff23f45fd',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:02:58',NULL,'2025-10-02 12:02:58',NULL,NULL),(105,NULL,'b6a5858e0d184dd184a3291b74794c14',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:02:58',NULL,'2025-10-02 12:02:58',NULL,NULL),(106,NULL,'1b8418ff78264e3292f5cd5b736866f0',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:02:58',NULL,'2025-10-02 12:02:58',NULL,NULL),(107,NULL,NULL,'31eaede9741f4081ab980b28d38bb847',NULL,NULL,NULL,NULL,'2025-10-02 12:03:01',NULL,'2025-10-02 12:03:01',NULL,NULL),(108,NULL,NULL,'20d2928cce464621a71b7f96249450d3',NULL,NULL,NULL,NULL,'2025-10-02 12:03:01',NULL,'2025-10-02 12:03:01',NULL,NULL),(109,NULL,'ad9cd297d2a44ef3aec7d5bedd232f57',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:03:02',NULL,'2025-10-02 12:03:02',NULL,NULL),(110,NULL,'6f9b46e9f8bd4268b8dde2ab75522cc5',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:03:03',NULL,'2025-10-02 12:03:03',NULL,NULL),(111,NULL,'bd15a45eaa654d4cb18a41be49b967b2',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:03:03',NULL,'2025-10-02 12:03:03',NULL,NULL),(112,NULL,NULL,'e07ebbb900aa4f848834a79f5cb5d1cc',NULL,NULL,NULL,NULL,'2025-10-02 12:03:05',NULL,'2025-10-02 12:03:05',NULL,NULL),(113,NULL,'97cb594932434af1990f9985c5d75b0a',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:03:05',NULL,'2025-10-02 12:03:05',NULL,NULL),(114,NULL,NULL,'6b2a181b66fe4c2bac30767ac1225c54',NULL,NULL,NULL,NULL,'2025-10-02 12:03:07',NULL,'2025-10-02 12:03:07',NULL,NULL),(115,NULL,NULL,'1fc33a35c2c64a5db402c82438ae83ca',NULL,NULL,NULL,NULL,'2025-10-02 12:03:07',NULL,'2025-10-02 12:03:07',NULL,NULL),(116,NULL,'e1815973d70b4ca3b2c4d8488279bfd1',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:03:08',NULL,'2025-10-02 12:03:08',NULL,NULL),(117,NULL,'80f52d3b4a7540ce81287944f378c733',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:03:09',NULL,'2025-10-02 12:03:09',NULL,NULL),(118,NULL,NULL,'e4c9b5cd27074c32aa70e21bbba40334',NULL,NULL,NULL,NULL,'2025-10-02 12:03:13',NULL,'2025-10-02 12:03:13',NULL,NULL),(119,NULL,'2b43629223164ca49f651bc7527f9a3b',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:03:14',NULL,'2025-10-02 12:03:14',NULL,NULL),(120,NULL,NULL,'7fa56a672af44c1ebafc37ca1146df67',NULL,NULL,NULL,NULL,'2025-10-02 12:03:14',NULL,'2025-10-02 12:03:14',NULL,NULL),(121,NULL,NULL,'3d60ca6212464e179506498afcd5f2fc',NULL,NULL,NULL,NULL,'2025-10-02 12:03:14',NULL,'2025-10-02 12:03:14',NULL,NULL),(122,NULL,'04c963d16dbc41e88521ae6053413ee1',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:03:15',NULL,'2025-10-02 12:03:15',NULL,NULL),(123,NULL,'003d06edcf554f6db443e4b3610827bf',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:03:17',NULL,'2025-10-02 12:03:17',NULL,NULL),(124,NULL,NULL,'9088d723f63c46be96487ca378dd484a',NULL,NULL,NULL,NULL,'2025-10-02 12:03:33',NULL,'2025-10-02 12:03:33',NULL,NULL),(125,NULL,NULL,'133ac2ebfb6c41698ae9871583d7de77',NULL,NULL,NULL,NULL,'2025-10-02 12:03:33',NULL,'2025-10-02 12:03:33',NULL,NULL),(126,NULL,'922148cc0a4a4295814d17e4b0e41991',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:03:35',NULL,'2025-10-02 12:03:35',NULL,NULL),(127,NULL,NULL,'4f90aaf0fd8f4214863d9023c775ec7d',NULL,NULL,NULL,NULL,'2025-10-02 12:03:37',NULL,'2025-10-02 12:03:37',NULL,NULL),(128,NULL,NULL,'e829ca31274b48b9b656df1ba321832c',NULL,NULL,NULL,NULL,'2025-10-02 12:03:37',NULL,'2025-10-02 12:03:37',NULL,NULL),(129,NULL,NULL,'f90361c3428c4fbd99169c837f32615c',NULL,NULL,NULL,NULL,'2025-10-02 12:03:37',NULL,'2025-10-02 12:03:37',NULL,NULL),(130,NULL,NULL,'8c3449c8b0404774b93358774236e412',NULL,NULL,NULL,NULL,'2025-10-02 12:03:37',NULL,'2025-10-02 12:03:37',NULL,NULL),(131,NULL,'ffda556e614448dfbe0b67bebc19394b',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:03:37',NULL,'2025-10-02 12:03:37',NULL,NULL),(132,NULL,'a9b443d03bd547af96ec032ee39540b9',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:03:39',NULL,'2025-10-02 12:03:39',NULL,NULL),(133,NULL,'462919ce52394bef90e573962ed18700',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:03:40',NULL,'2025-10-02 12:03:40',NULL,NULL),(134,NULL,'612d5f60edd74e79a420378579b416ea',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:03:40',NULL,'2025-10-02 12:03:40',NULL,NULL),(135,NULL,'186c71c9c685435c9b1bc0ba899c2211',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:03:41',NULL,'2025-10-02 12:03:41',NULL,NULL),(136,NULL,NULL,'9e849268f2a44ae3ab3c6dc9cffcfe6c',NULL,NULL,NULL,NULL,'2025-10-02 12:03:51',NULL,'2025-10-02 12:03:51',NULL,NULL),(137,NULL,NULL,'4f44fa7d20aa4723948423e68485e0ed',NULL,NULL,NULL,NULL,'2025-10-02 12:03:51',NULL,'2025-10-02 12:03:51',NULL,NULL),(138,NULL,NULL,'efb31eeadee34403b1ab7a584f3616f7',NULL,NULL,NULL,NULL,'2025-10-02 12:03:52',NULL,'2025-10-02 12:03:52',NULL,NULL),(139,NULL,NULL,'c087f94b944f499086fc90cd7a8c6ed2',NULL,NULL,NULL,NULL,'2025-10-02 12:03:52',NULL,'2025-10-02 12:03:52',NULL,NULL),(140,NULL,'47be29ffb3f345beb6f503097bad2288',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:04:09',NULL,'2025-10-02 12:04:09',NULL,NULL),(141,NULL,'a45f15d82e6e4e95a422d53281506176',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:04:10',NULL,'2025-10-02 12:04:10',NULL,NULL),(142,NULL,'ba509096e30542ce8978b9722408719c',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:04:11',NULL,'2025-10-02 12:04:11',NULL,NULL),(143,NULL,'3f2b3ac7d7504c9c96f0d4a67e0243c9',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:04:11',NULL,'2025-10-02 12:04:11',NULL,NULL),(144,NULL,NULL,'68356eb070414b8a8d696b8b69437c15',NULL,NULL,NULL,NULL,'2025-10-02 12:04:17',NULL,'2025-10-02 12:04:17',NULL,NULL),(145,NULL,NULL,'28f6b30c3bbb430cb4a0582ef085841d',NULL,NULL,NULL,NULL,'2025-10-02 12:04:17',NULL,'2025-10-02 12:04:17',NULL,NULL),(146,NULL,NULL,'aa48477cd44b4a209c7e0b6d30603459',NULL,NULL,NULL,NULL,'2025-10-02 12:04:18',NULL,'2025-10-02 12:04:18',NULL,NULL),(147,NULL,NULL,'a9995e37693a4bb88ef45195855fc700',NULL,NULL,NULL,NULL,'2025-10-02 12:04:18',NULL,'2025-10-02 12:04:18',NULL,NULL),(148,NULL,'1054899e66eb428baeddf0d256a13c1a',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:04:18',NULL,'2025-10-02 12:04:18',NULL,NULL),(149,NULL,'25b19def0d32494a9d3c10438c5e2bc9',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:04:20',NULL,'2025-10-02 12:04:20',NULL,NULL),(150,NULL,'c24f4456add64379b623c3140daaf6b9',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:04:20',NULL,'2025-10-02 12:04:20',NULL,NULL),(151,NULL,'86e53e684bec44ddbddf6db926da95a5',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:04:21',NULL,'2025-10-02 12:04:21',NULL,NULL),(152,NULL,NULL,'613aafef5cdf4917b8819d273f7ab163',NULL,NULL,NULL,NULL,'2025-10-02 12:04:23',NULL,'2025-10-02 12:04:23',NULL,NULL),(153,NULL,NULL,'ed692bdf337643a6a65422a057305094',NULL,NULL,NULL,NULL,'2025-10-02 12:04:24',NULL,'2025-10-02 12:04:24',NULL,NULL),(154,NULL,NULL,'fdf5255d2fe24e51be4e91ac74a70fd4',NULL,NULL,NULL,NULL,'2025-10-02 12:04:25',NULL,'2025-10-02 12:04:25',NULL,NULL),(155,NULL,NULL,'e426423fefdb4c02bd4b2f5eaf5420e2',NULL,NULL,NULL,NULL,'2025-10-02 12:04:25',NULL,'2025-10-02 12:04:25',NULL,NULL),(156,NULL,'1e6ccaf042df413eb35c8d2bd20a6b6b',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:04:25',NULL,'2025-10-02 12:04:25',NULL,NULL),(157,NULL,NULL,'7c8ea716100c4d2599115fa4b07a4b63',NULL,NULL,NULL,NULL,'2025-10-02 12:04:26',NULL,'2025-10-02 12:04:26',NULL,NULL),(158,NULL,NULL,'4211d1609e10492b8eff1bca6c252afe',NULL,NULL,NULL,NULL,'2025-10-02 12:04:26',NULL,'2025-10-02 12:04:26',NULL,NULL),(159,NULL,'617fb5efbd9349d1a0de54c5a40c845b',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:04:28',NULL,'2025-10-02 12:04:28',NULL,NULL),(160,NULL,'f48b990f725a422eac67852830f99a7a',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:04:28',NULL,'2025-10-02 12:04:28',NULL,NULL),(161,NULL,'fcc11d895f464304922188d4a19586aa',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:04:28',NULL,'2025-10-02 12:04:28',NULL,NULL),(162,NULL,'abaa35424c2c48738efbc958ff1e14fa',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:04:29',NULL,'2025-10-02 12:04:29',NULL,NULL),(163,NULL,'68cc95e1a65a435a830149c0a3c804b7',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:04:29',NULL,'2025-10-02 12:04:29',NULL,NULL),(164,NULL,NULL,'eaf38666d05149d8afd106d694875a05',NULL,NULL,NULL,NULL,'2025-10-02 12:04:33',NULL,'2025-10-02 12:04:33',NULL,NULL),(165,NULL,NULL,'7c597389629f4edaaea8002c9dc8dfc9',NULL,NULL,NULL,NULL,'2025-10-02 12:04:34',NULL,'2025-10-02 12:04:34',NULL,NULL),(166,NULL,'39f09dd44b0b45a285ce851280971e57',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:04:37',NULL,'2025-10-02 12:04:37',NULL,NULL),(167,NULL,'445df72776c44187a4f3adebe08ae145',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:04:40',NULL,'2025-10-02 12:04:40',NULL,NULL),(168,NULL,NULL,'07fa89683e2a4933b8fefb43e7790aae',NULL,NULL,NULL,NULL,'2025-10-02 12:04:45',NULL,'2025-10-02 12:04:45',NULL,NULL),(169,NULL,'2b5dfd2075564ea38d4b29c40fe49fe8',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:04:45',NULL,'2025-10-02 12:04:45',NULL,NULL),(170,NULL,NULL,'c6dce7b30ac240b892cf0ad800ac73cc',NULL,NULL,NULL,NULL,'2025-10-02 12:04:46',NULL,'2025-10-02 12:04:46',NULL,NULL),(171,NULL,NULL,'46c259c9436d44ddb97dfa7485cc244e',NULL,NULL,NULL,NULL,'2025-10-02 12:04:46',NULL,'2025-10-02 12:04:46',NULL,NULL),(172,NULL,'e8bfda99b910416eb126947c43792dae',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:04:48',NULL,'2025-10-02 12:04:48',NULL,NULL),(173,NULL,'9aa58b042df74a19a12cc7e909ad8db4',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:04:50',NULL,'2025-10-02 12:04:50',NULL,NULL),(174,NULL,NULL,'0dcc92914b5b4e959d035d0084906afd',NULL,NULL,NULL,NULL,'2025-10-02 12:05:06',NULL,'2025-10-02 12:05:06',NULL,NULL),(175,NULL,NULL,'af22315fe7d24bf3a126e9b5b95ecf2f',NULL,NULL,NULL,NULL,'2025-10-02 12:05:08',NULL,'2025-10-02 12:05:08',NULL,NULL),(176,NULL,'d82c1b83239b4eb882793cd79c8dcb31',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:05:13',NULL,'2025-10-02 12:05:13',NULL,NULL),(177,NULL,NULL,'c5ab011ce9f04adbb19dab5fa5ed1714',NULL,NULL,NULL,NULL,'2025-10-02 12:05:15',NULL,'2025-10-02 12:05:15',NULL,NULL),(178,NULL,NULL,'5816edde6cf64ef191e2c3856d279084',NULL,NULL,NULL,NULL,'2025-10-02 12:05:17',NULL,'2025-10-02 12:05:17',NULL,NULL),(179,NULL,'9cfd5ff016e3478db3ca3c03509797ed',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:05:19',NULL,'2025-10-02 12:05:19',NULL,NULL),(180,NULL,'6b8ddbfa33c348beb1c883371b5c6909',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:05:20',NULL,'2025-10-02 12:05:20',NULL,NULL),(181,NULL,'90da982012114f5c8ba8b23f4714095b',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:05:23',NULL,'2025-10-02 12:05:23',NULL,NULL),(182,NULL,NULL,'04362838e6ac400480e216d2d7fbfd4a',NULL,NULL,NULL,NULL,'2025-10-02 12:05:30',NULL,'2025-10-02 12:05:30',NULL,NULL),(183,NULL,NULL,'88ecc12b40cb436dbf4c95c2a423ec8d',NULL,NULL,NULL,NULL,'2025-10-02 12:05:30',NULL,'2025-10-02 12:05:30',NULL,NULL),(184,NULL,'cf9324cbc44b4ef9bcfe95d04c4dc0b7',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:05:35',NULL,'2025-10-02 12:05:35',NULL,NULL),(185,NULL,'918c114b16f74585b9d78d1b772a18be',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:05:41',NULL,'2025-10-02 12:05:41',NULL,NULL),(186,NULL,NULL,'415050d5c96b4fcfa58872eb1a8b1ff8',NULL,NULL,NULL,NULL,'2025-10-02 12:05:45',NULL,'2025-10-02 12:05:45',NULL,NULL),(187,NULL,NULL,'ec7f324f30e74eb096a2705c63c5a526',NULL,NULL,NULL,NULL,'2025-10-02 12:05:46',NULL,'2025-10-02 12:05:46',NULL,NULL),(188,NULL,NULL,'afe47cfd3bf742b685c5c028f4f2c52e',NULL,NULL,NULL,NULL,'2025-10-02 12:05:46',NULL,'2025-10-02 12:05:46',NULL,NULL),(189,NULL,'85f367ca009f4d33b27defb9c069e5d4',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:05:50',NULL,'2025-10-02 12:05:50',NULL,NULL),(190,NULL,'463bf1f08e744cea8f9afb27d568bdbe',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:05:55',NULL,'2025-10-02 12:05:55',NULL,NULL),(191,NULL,'1ba010187ec042669294de7ed68dd41e',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:05:57',NULL,'2025-10-02 12:05:57',NULL,NULL),(192,NULL,NULL,'a10a935aed2d40ff8ee890b3089c7d03',NULL,NULL,NULL,NULL,'2025-10-02 12:06:25',NULL,'2025-10-02 12:06:25',NULL,NULL),(193,NULL,NULL,'9fbbb9af77d7442996ea19a4e8e03c07',NULL,NULL,NULL,NULL,'2025-10-02 12:06:26',NULL,'2025-10-02 12:06:26',NULL,NULL),(194,NULL,'39f16ad971c74b0296dabeb9b59464da',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:06:29',NULL,'2025-10-02 12:06:29',NULL,NULL),(195,NULL,'e75d09bf728d4df195c9df2fa73baa9c',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:06:31',NULL,'2025-10-02 12:06:31',NULL,NULL),(196,NULL,NULL,'91b8ff043ce84cc2ae2074da24b942fb',NULL,NULL,NULL,NULL,'2025-10-02 12:06:49',NULL,'2025-10-02 12:06:49',NULL,NULL),(197,NULL,NULL,'a6114a734aea480cb55fc8e1241ad096',NULL,NULL,NULL,NULL,'2025-10-02 12:06:49',NULL,'2025-10-02 12:06:49',NULL,NULL),(198,NULL,'52b5ddca38684163936ded32b4972365',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:06:51',NULL,'2025-10-02 12:06:51',NULL,NULL),(199,NULL,'1cb5ae2bd75b42f583e64220c132e5cd',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:06:52',NULL,'2025-10-02 12:06:52',NULL,NULL),(200,NULL,NULL,'8850add40b254d198f270d9e64c777d5',NULL,NULL,NULL,NULL,'2025-10-02 12:07:00',NULL,'2025-10-02 12:07:00',NULL,NULL),(201,NULL,NULL,'6d62db4a2ce1452594a6f86f4302e10a',NULL,NULL,NULL,NULL,'2025-10-02 12:07:00',NULL,'2025-10-02 12:07:00',NULL,NULL),(202,NULL,'9afa78cc4dec419babdf61fd31f46e28',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:07:01',NULL,'2025-10-02 12:07:01',NULL,NULL),(203,NULL,'9da12fce614f48e180f0bab1515f9dc7',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:07:02',NULL,'2025-10-02 12:07:02',NULL,NULL),(204,NULL,NULL,'cd5239d6c60f420aa80f6449731aa457',NULL,NULL,NULL,NULL,'2025-10-02 12:07:07',NULL,'2025-10-02 12:07:07',NULL,NULL),(205,NULL,NULL,'ee97f9bf162e42729fa7bee9ad4ae454',NULL,NULL,NULL,NULL,'2025-10-02 12:07:07',NULL,'2025-10-02 12:07:07',NULL,NULL),(206,NULL,'022eb055815d4a47978b054e85ed518a',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:07:08',NULL,'2025-10-02 12:07:08',NULL,NULL),(207,NULL,'e87badc4956d4815af132b0a75445dc7',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:07:09',NULL,'2025-10-02 12:07:09',NULL,NULL),(208,NULL,NULL,'c5ffcae7415e4e65bdf37996eab10f90',NULL,NULL,NULL,NULL,'2025-10-02 12:07:21',NULL,'2025-10-02 12:07:21',NULL,NULL),(209,NULL,NULL,'4bd0e9bbd4074e4b9b0df87098b17ed5',NULL,NULL,NULL,NULL,'2025-10-02 12:07:21',NULL,'2025-10-02 12:07:21',NULL,NULL),(210,NULL,'0365a979bc904cdab4f4a40a11c3f6ac',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:07:23',NULL,'2025-10-02 12:07:23',NULL,NULL),(211,NULL,'7730d14683074be79cbff93dd183fca0',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:07:25',NULL,'2025-10-02 12:07:25',NULL,NULL),(212,NULL,NULL,'7ed46b991b844fe2bfa1d9dedc3d16b9',NULL,NULL,NULL,NULL,'2025-10-02 12:08:01',NULL,'2025-10-02 12:08:01',NULL,NULL),(213,NULL,'087032a23f1343b69dad71ab288c8d03',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:08:02',NULL,'2025-10-02 12:08:02',NULL,NULL),(214,NULL,NULL,'42404c05946047b69ea24ea54ed171ae',NULL,NULL,NULL,NULL,'2025-10-02 12:08:20',NULL,'2025-10-02 12:08:20',NULL,NULL),(215,NULL,'12e86e81c89541bb9c4b5f80483d75f8',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:08:21',NULL,'2025-10-02 12:08:21',NULL,NULL),(216,NULL,NULL,'199c0d9541a04c4db07e50bfba9fddb1',NULL,NULL,NULL,NULL,'2025-10-02 12:08:24',NULL,'2025-10-02 12:08:24',NULL,NULL),(217,NULL,NULL,'4f8f0b95ce86417283ae36c0b408299e',NULL,NULL,NULL,NULL,'2025-10-02 12:08:24',NULL,'2025-10-02 12:08:24',NULL,NULL),(218,NULL,'8e33ec2e7da14f5c8a501dffba71ea8a',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:08:25',NULL,'2025-10-02 12:08:25',NULL,NULL),(219,NULL,'62aa9c47ee2841139cd7066168f59650',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:08:26',NULL,'2025-10-02 12:08:26',NULL,NULL),(220,NULL,NULL,'80db090341b3472abc3af3ee68ba3256',NULL,NULL,NULL,NULL,'2025-10-02 12:08:30',NULL,'2025-10-02 12:08:30',NULL,NULL),(221,NULL,NULL,'6a9b64a70d5349f59855acaaa545b244',NULL,NULL,NULL,NULL,'2025-10-02 12:08:31',NULL,'2025-10-02 12:08:31',NULL,NULL),(222,NULL,'91cdd358c5b341c1b161540733f9fdf4',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:08:32',NULL,'2025-10-02 12:08:32',NULL,NULL),(223,NULL,'ee5fdaa0658441da8e242ce3428bcc9f',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:08:33',NULL,'2025-10-02 12:08:33',NULL,NULL),(224,NULL,NULL,'ec17c54e24584f11a5348b68d6e7ca85',NULL,NULL,NULL,NULL,'2025-10-02 12:08:34',NULL,'2025-10-02 12:08:34',NULL,NULL),(225,NULL,NULL,'6d0c8ef85ce847c0a945e8d799332e10',NULL,NULL,NULL,NULL,'2025-10-02 12:08:34',NULL,'2025-10-02 12:08:34',NULL,NULL),(226,NULL,'60c1dbbadd444032942b241f2ad379b0',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:08:35',NULL,'2025-10-02 12:08:35',NULL,NULL),(227,NULL,'7359a7dad3b849bfbf075b88f2a261b4',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:08:36',NULL,'2025-10-02 12:08:36',NULL,NULL),(228,NULL,NULL,'df6260812342416596570b2a639fac76',NULL,NULL,NULL,NULL,'2025-10-02 12:08:37',NULL,'2025-10-02 12:08:37',NULL,NULL),(229,NULL,NULL,'4666fdebee9947109da966b5c870b34e',NULL,NULL,NULL,NULL,'2025-10-02 12:08:37',NULL,'2025-10-02 12:08:37',NULL,NULL),(230,NULL,NULL,'7f989f53f5464b7e8ade50545ce23aae',NULL,NULL,NULL,NULL,'2025-10-02 12:08:38',NULL,'2025-10-02 12:08:38',NULL,NULL),(231,NULL,NULL,'65c9ba5a46fe48d3b3beaa963b655702',NULL,NULL,NULL,NULL,'2025-10-02 12:08:38',NULL,'2025-10-02 12:08:38',NULL,NULL),(232,NULL,'861ae6a71574411fbcdab09902e6bcc4',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:08:39',NULL,'2025-10-02 12:08:39',NULL,NULL),(233,NULL,'837b5936efeb4d0ab74e6ccc78254da5',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:08:40',NULL,'2025-10-02 12:08:40',NULL,NULL),(234,NULL,NULL,'a9a2464e0ef844e5a3151fcae031bd1c',NULL,NULL,NULL,NULL,'2025-10-02 12:08:40',NULL,'2025-10-02 12:08:40',NULL,NULL),(235,NULL,'d650efcc52d9448da536370064e1794d',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:08:40',NULL,'2025-10-02 12:08:40',NULL,NULL),(236,NULL,'060e7164a1ca49b3b578ebc22f035421',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:08:41',NULL,'2025-10-02 12:08:41',NULL,NULL),(237,NULL,'8c096e6383954a7e91ec3d12c83e6350',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:08:41',NULL,'2025-10-02 12:08:41',NULL,NULL),(238,NULL,NULL,'b8753c4c05fe4f97814b0df308658db3',NULL,NULL,NULL,NULL,'2025-10-02 12:08:48',NULL,'2025-10-02 12:08:48',NULL,NULL),(239,NULL,'0ccdf5205a8f4bdbae2e3fd11807d5fb',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:08:50',NULL,'2025-10-02 12:08:50',NULL,NULL),(240,NULL,NULL,'95f5009b917e4bcf95bfd32e0cab3c98',NULL,NULL,NULL,NULL,'2025-10-02 12:08:56',NULL,'2025-10-02 12:08:56',NULL,NULL),(241,NULL,'69487877b1cf44928aea6125a11e7025',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:08:56',NULL,'2025-10-02 12:08:56',NULL,NULL),(242,NULL,NULL,'979ad3d844c4420783a19b1d3b224430',NULL,NULL,NULL,NULL,'2025-10-02 12:09:00',NULL,'2025-10-02 12:09:00',NULL,NULL),(243,NULL,'fe98c84223244e23bd00bb0991e5b82e',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:09:01',NULL,'2025-10-02 12:09:01',NULL,NULL),(244,NULL,NULL,'6af3bf5ab7a04efb81e07634f2293f05',NULL,NULL,NULL,NULL,'2025-10-02 12:09:05',NULL,'2025-10-02 12:09:05',NULL,NULL),(245,NULL,'d76a84b280014206a194ed41d40311bd',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:09:09',NULL,'2025-10-02 12:09:09',NULL,NULL),(246,NULL,NULL,'e32c6c11c2274341948293a76e08d964',NULL,NULL,NULL,NULL,'2025-10-02 12:09:18',NULL,'2025-10-02 12:09:18',NULL,NULL),(247,NULL,'9d574ebeed534ceebb1ab985b8295b8e',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:09:20',NULL,'2025-10-02 12:09:20',NULL,NULL),(248,NULL,NULL,'e50639328d0745b48641de98b993c731',NULL,NULL,NULL,NULL,'2025-10-02 12:09:41',NULL,'2025-10-02 12:09:41',NULL,NULL),(249,NULL,'5aa867f3624c4dafab39f40f860bdd73',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:09:42',NULL,'2025-10-02 12:09:42',NULL,NULL),(250,NULL,NULL,'bdfe7573e6ef43d4b657bc23f7040216',NULL,NULL,NULL,NULL,'2025-10-02 12:09:45',NULL,'2025-10-02 12:09:45',NULL,NULL),(251,NULL,'f56efb617fd14085996f998142cfe1dc',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:09:46',NULL,'2025-10-02 12:09:46',NULL,NULL),(252,NULL,NULL,'c1d44ebb52fa48048749a384c9975fdb',NULL,NULL,NULL,NULL,'2025-10-02 12:09:50',NULL,'2025-10-02 12:09:50',NULL,NULL),(253,NULL,'d34154bdab19466cb51610320606119b',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:09:53',NULL,'2025-10-02 12:09:53',NULL,NULL),(254,NULL,NULL,'245477e4901945099a0da748199456bc',NULL,NULL,NULL,NULL,'2025-10-02 12:10:12',NULL,'2025-10-02 12:10:12',NULL,NULL),(255,NULL,'1d9c4d04247d43b086698f34cdea3ffb',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:10:13',NULL,'2025-10-02 12:10:13',NULL,NULL),(256,NULL,NULL,'c5ca95bd9fa148c7948c062421011d76',NULL,NULL,NULL,NULL,'2025-10-02 12:10:44',NULL,'2025-10-02 12:10:44',NULL,NULL),(257,NULL,NULL,'b8a1150bbc7a40a188be4d8a5e56a993',NULL,NULL,NULL,NULL,'2025-10-02 12:10:44',NULL,'2025-10-02 12:10:44',NULL,NULL),(258,NULL,'a9aab29c338d460a852e0ce15bc3d902',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:10:45',NULL,'2025-10-02 12:10:45',NULL,NULL),(259,NULL,'95056cabad5b4f32916e46a46b10f677',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:10:46',NULL,'2025-10-02 12:10:46',NULL,NULL),(260,NULL,NULL,'f820372ccaff45fbb5124c2e0ba9daee',NULL,NULL,NULL,NULL,'2025-10-02 12:11:01',NULL,'2025-10-02 12:11:01',NULL,NULL),(261,NULL,'eac9e69b67754029940cc0ef4c2ba587',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:11:02',NULL,'2025-10-02 12:11:02',NULL,NULL),(262,NULL,NULL,'3c2b867915b342b5acd8026e8fc9fe00',NULL,NULL,NULL,NULL,'2025-10-02 12:11:04',NULL,'2025-10-02 12:11:04',NULL,NULL),(263,NULL,'07abaa757bde49eead1d80ce844ec6ba',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:11:05',NULL,'2025-10-02 12:11:05',NULL,NULL),(264,NULL,NULL,'981a135a24e64d0aa07512e23330974a',NULL,NULL,NULL,NULL,'2025-10-02 12:11:20',NULL,'2025-10-02 12:11:20',NULL,NULL),(265,NULL,'9e743c722ec0433e854167192b6dd567',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:11:20',NULL,'2025-10-02 12:11:20',NULL,NULL),(266,NULL,NULL,'25be6f5b266f415ba16923bb9c3596e3',NULL,NULL,NULL,NULL,'2025-10-02 12:11:22',NULL,'2025-10-02 12:11:22',NULL,NULL),(267,NULL,'7c1d60f3aa14446abbd988c18daa4c54',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:11:25',NULL,'2025-10-02 12:11:25',NULL,NULL),(268,NULL,NULL,'c2999fde0aa643028301c0aef2c02f66',NULL,NULL,NULL,NULL,'2025-10-02 12:11:42',NULL,'2025-10-02 12:11:42',NULL,NULL),(269,NULL,'7c21a3b8b2ec4521af33df81f746e3ff',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:11:47',NULL,'2025-10-02 12:11:47',NULL,NULL),(270,NULL,NULL,'3b25f643e1c8467b8b3957f87dd7376a',NULL,NULL,NULL,NULL,'2025-10-02 12:11:51',NULL,'2025-10-02 12:11:51',NULL,NULL),(271,NULL,'955799e103c847c2b69557056d5943e3',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:11:54',NULL,'2025-10-02 12:11:54',NULL,NULL),(272,NULL,NULL,'2eeb358da2a74b72899e659bf6bf6815',NULL,NULL,NULL,NULL,'2025-10-02 12:11:58',NULL,'2025-10-02 12:11:58',NULL,NULL),(273,NULL,'7fe83993ca044e9eb7359d6698b2e655',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:12:02',NULL,'2025-10-02 12:12:02',NULL,NULL),(274,NULL,NULL,'33b6f6262d0640ffa417160cbf03ddd0',NULL,NULL,NULL,NULL,'2025-10-02 12:12:09',NULL,'2025-10-02 12:12:09',NULL,NULL),(275,NULL,'716120851ed4411399aa686e695b84ac',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:12:11',NULL,'2025-10-02 12:12:11',NULL,NULL),(276,NULL,NULL,'149e3925214640b484809bc9362e31ac',NULL,NULL,NULL,NULL,'2025-10-02 12:12:37',NULL,'2025-10-02 12:12:37',NULL,NULL),(277,NULL,'515a20f509b440c1bda78c309dea196e',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:12:40',NULL,'2025-10-02 12:12:40',NULL,NULL),(278,NULL,NULL,'e2a366ecf5934af989ad59e70e8c0b40',NULL,NULL,NULL,NULL,'2025-10-02 12:13:00',NULL,'2025-10-02 12:13:00',NULL,NULL),(279,NULL,'e3110a9141bf416d96e84c98f5ec90b6',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:13:03',NULL,'2025-10-02 12:13:03',NULL,NULL),(280,NULL,NULL,'4ce967547d34420fbac2881a819b6047',NULL,NULL,NULL,NULL,'2025-10-02 12:13:03',NULL,'2025-10-02 12:13:03',NULL,NULL),(281,NULL,'b769c3b44c8842328b6c737fc56ffead',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:13:04',NULL,'2025-10-02 12:13:04',NULL,NULL),(282,NULL,NULL,'fe1ce657e99740dfa350bebb77004bfb',NULL,NULL,NULL,NULL,'2025-10-02 12:13:22',NULL,'2025-10-02 12:13:22',NULL,NULL),(283,NULL,'29f45b679f9c4fe791ae97b14dc9b00a',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:13:23',NULL,'2025-10-02 12:13:23',NULL,NULL),(284,NULL,NULL,'ea7aba6956024282ad73d716eded27ce',NULL,NULL,NULL,NULL,'2025-10-02 12:13:50',NULL,'2025-10-02 12:13:50',NULL,NULL),(285,NULL,'b6a848d3ce964c8a830dc094b1fabda3',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:13:51',NULL,'2025-10-02 12:13:51',NULL,NULL),(286,NULL,NULL,'6529c3301c674317b5af53daaa0ee15a',NULL,NULL,NULL,NULL,'2025-10-02 12:13:53',NULL,'2025-10-02 12:13:53',NULL,NULL),(287,NULL,'7f7fda5b2b6844ad82818a60ed39c0b0',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:13:54',NULL,'2025-10-02 12:13:54',NULL,NULL),(288,NULL,NULL,'0df47040f1ff4ce69a6fbdfd9eba4955',NULL,NULL,NULL,NULL,'2025-10-02 12:14:06',NULL,'2025-10-02 12:14:06',NULL,NULL),(289,NULL,'55d20ae21b6d4f0abfff3bccc371ee7a',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:14:07',NULL,'2025-10-02 12:14:07',NULL,NULL),(290,NULL,NULL,'1c085e57b7d944c7a372e604d34c96a3',NULL,NULL,NULL,NULL,'2025-10-02 12:15:01',NULL,'2025-10-02 12:15:01',NULL,NULL),(291,NULL,'635effeb91ed4a7fb29066f894e25c5a',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:15:02',NULL,'2025-10-02 12:15:02',NULL,NULL),(292,NULL,NULL,'d107dd863d2e4a56853a0b758cb2c110',NULL,NULL,NULL,NULL,'2025-10-02 12:15:25',NULL,'2025-10-02 12:15:25',NULL,NULL),(293,NULL,'ba87091f122a4afabe0a62682078fece',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:15:26',NULL,'2025-10-02 12:15:26',NULL,NULL),(294,NULL,NULL,'51229018510440858be9691ef4a0965f',NULL,NULL,NULL,NULL,'2025-10-02 12:15:55',NULL,'2025-10-02 12:15:55',NULL,NULL),(295,NULL,'a0b70ca4a75844a9a91b4e116bc58df9',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:15:55',NULL,'2025-10-02 12:15:55',NULL,NULL),(296,NULL,NULL,'a77fa2684bba41bb93c60fc0f0279f5f',NULL,NULL,NULL,NULL,'2025-10-02 12:16:11',NULL,'2025-10-02 12:16:11',NULL,NULL),(297,NULL,'6796bbb960be4c70b7177bff719e7ac0',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:16:15',NULL,'2025-10-02 12:16:15',NULL,NULL),(298,NULL,NULL,'72c74994085d4fc697ddd4acddfa7a11',NULL,NULL,NULL,NULL,'2025-10-02 12:16:18',NULL,'2025-10-02 12:16:18',NULL,NULL),(299,NULL,'3204d74f349d47fda3152d9d7fbea43e',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:16:19',NULL,'2025-10-02 12:16:19',NULL,NULL),(300,NULL,NULL,'e14f959254f1421186bbeef8d145d4d0',NULL,NULL,NULL,NULL,'2025-10-02 12:16:32',NULL,'2025-10-02 12:16:32',NULL,NULL),(301,NULL,'560ae31d874441fb86fe550ce6bf4d77',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:16:33',NULL,'2025-10-02 12:16:33',NULL,NULL),(302,NULL,NULL,'03f516d263c8402682568b55b658f885',NULL,NULL,NULL,NULL,'2025-10-02 12:17:29',NULL,'2025-10-02 12:17:29',NULL,NULL),(303,NULL,'1f9bd65bc7864ca18e1c478ef7e03926',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:17:31',NULL,'2025-10-02 12:17:31',NULL,NULL),(304,NULL,NULL,'819732421f6e4f1fa192c7f3e1736425',NULL,NULL,NULL,NULL,'2025-10-02 12:17:35',NULL,'2025-10-02 12:17:35',NULL,NULL),(305,NULL,'2622897529bd45628969c22bb296f7b2',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:17:40',NULL,'2025-10-02 12:17:40',NULL,NULL),(306,NULL,NULL,'ddf3cb08a1d24b0f820fa174722a7304',NULL,NULL,NULL,NULL,'2025-10-02 12:17:44',NULL,'2025-10-02 12:17:44',NULL,NULL),(307,NULL,NULL,'8e627e098f2b465d97099fee8f489b71',NULL,NULL,NULL,NULL,'2025-10-02 12:17:45',NULL,'2025-10-02 12:17:45',NULL,NULL),(308,NULL,'1af2874da92d4b1fa05052ce06be0582',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:17:46',NULL,'2025-10-02 12:17:46',NULL,NULL),(309,NULL,'bddf59854a7d4eb1a85ece547923cea0',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:17:47',NULL,'2025-10-02 12:17:47',NULL,NULL),(310,NULL,NULL,'5dc671695bd140f2bf629bf4bd9cf204',NULL,NULL,NULL,NULL,'2025-10-02 12:17:53',NULL,'2025-10-02 12:17:53',NULL,NULL),(311,NULL,'3f46b7253abd4183b9b63a7dbb9fe10a',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:17:58',NULL,'2025-10-02 12:17:58',NULL,NULL),(312,NULL,NULL,'d4b073f3365d481cabadfd39389c66ba',NULL,NULL,NULL,NULL,'2025-10-02 12:18:41',NULL,'2025-10-02 12:18:41',NULL,NULL),(313,NULL,NULL,'938fc0b401bc4bfeac84593ec45ddf21',NULL,NULL,NULL,NULL,'2025-10-02 12:18:41',NULL,'2025-10-02 12:18:41',NULL,NULL),(314,NULL,'40784c6e52c34106acb4b3ebabace249',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:18:45',NULL,'2025-10-02 12:18:45',NULL,NULL),(315,NULL,'a9d3eca266284ae9950c491e566b2523',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:18:46',NULL,'2025-10-02 12:18:46',NULL,NULL),(316,NULL,NULL,'cc0b544e9ae24eb3b638e87ee4428677',NULL,NULL,NULL,NULL,'2025-10-02 12:19:02',NULL,'2025-10-02 12:19:02',NULL,NULL),(317,NULL,'471de2e25ff442629af9380f2f732266',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:19:03',NULL,'2025-10-02 12:19:03',NULL,NULL),(318,NULL,NULL,'2810a2f118b84b3cbc959c8ee3315600',NULL,NULL,NULL,NULL,'2025-10-02 12:19:21',NULL,'2025-10-02 12:19:21',NULL,NULL),(319,NULL,'15a242822e7849ee92179cec8302a315',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:19:22',NULL,'2025-10-02 12:19:22',NULL,NULL),(320,NULL,NULL,'0e268197f7054a098b565874c3fdd76c',NULL,NULL,NULL,NULL,'2025-10-02 12:19:52',NULL,'2025-10-02 12:19:52',NULL,NULL),(321,NULL,'a07342ec339549a4b091ddbcfedae271',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:19:53',NULL,'2025-10-02 12:19:53',NULL,NULL),(322,NULL,NULL,'69d8e29c6d3747e98a5985a584f4c814',NULL,NULL,NULL,NULL,'2025-10-02 12:20:46',NULL,'2025-10-02 12:20:46',NULL,NULL),(323,NULL,'8efba404696b40fbbaa6431b934b87f1',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:20:47',NULL,'2025-10-02 12:20:47',NULL,NULL),(324,NULL,NULL,'a804670c0de24489af33ba77885d5ee6',NULL,NULL,NULL,NULL,'2025-10-02 12:21:30',NULL,'2025-10-02 12:21:30',NULL,NULL),(325,NULL,'a7f4317b8b6c47689bbb12f29d6cab5a',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:21:31',NULL,'2025-10-02 12:21:31',NULL,NULL),(326,NULL,NULL,'2a7f7518ce70488fb4f63af1a3bef131',NULL,NULL,NULL,NULL,'2025-10-02 12:21:57',NULL,'2025-10-02 12:21:57',NULL,NULL),(327,NULL,NULL,'bd9d50fd065d437181cb6eb45430444b',NULL,NULL,NULL,NULL,'2025-10-02 12:21:57',NULL,'2025-10-02 12:21:57',NULL,NULL),(328,NULL,'84f71f6076f7425db7653ac203257df0',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:21:58',NULL,'2025-10-02 12:21:58',NULL,NULL),(329,NULL,'854ad13f25a940598f0a1821a239046c',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:21:59',NULL,'2025-10-02 12:21:59',NULL,NULL),(330,NULL,NULL,'93e805bcb0e047ca9d45c653f5ec913d',NULL,NULL,NULL,NULL,'2025-10-02 12:22:51',NULL,'2025-10-02 12:22:51',NULL,NULL),(331,NULL,'91d108e807094b0fa8e63a923d2269ee',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:22:53',NULL,'2025-10-02 12:22:53',NULL,NULL),(332,NULL,NULL,'6e7ac8498cf5493d9eb7fd8747db6b07',NULL,NULL,NULL,NULL,'2025-10-02 12:23:34',NULL,'2025-10-02 12:23:34',NULL,NULL),(333,NULL,'17f64fa8d6e845999cf42a2e95664585',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:23:34',NULL,'2025-10-02 12:23:34',NULL,NULL),(334,NULL,NULL,'a9f7faffac7240869a0196df1ddda7e5',NULL,NULL,NULL,NULL,'2025-10-02 12:24:20',NULL,'2025-10-02 12:24:20',NULL,NULL),(335,NULL,'1c2c11ebecb14f3188f35ea473c4ca02',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:24:21',NULL,'2025-10-02 12:24:21',NULL,NULL),(336,NULL,NULL,'4146a31af09c4e6a8aee251f2fec4f98',NULL,NULL,NULL,NULL,'2025-10-02 12:24:38',NULL,'2025-10-02 12:24:38',NULL,NULL),(337,NULL,'c740a14d1c5c45d1a0959b0e24ac460b',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:24:40',NULL,'2025-10-02 12:24:40',NULL,NULL),(338,NULL,NULL,'49ce34df164c4ce7a673d8c2ff42451a',NULL,NULL,NULL,NULL,'2025-10-02 12:25:51',NULL,'2025-10-02 12:25:51',NULL,NULL),(339,NULL,NULL,'5ce29b10dcde4e449f0ba357e8b8082e',NULL,NULL,NULL,NULL,'2025-10-02 12:25:52',NULL,'2025-10-02 12:25:52',NULL,NULL),(340,NULL,'bb169657a27d4e129e8479b6c03d6093',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:25:53',NULL,'2025-10-02 12:25:53',NULL,NULL),(341,NULL,'ae7fb724ce7246d89b01c8c2ef3ba962',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:26:11',NULL,'2025-10-02 12:26:11',NULL,NULL),(342,NULL,NULL,'4c5347ce0c734abc8405e9aab279f74c',NULL,NULL,NULL,NULL,'2025-10-02 12:26:14',NULL,'2025-10-02 12:26:14',NULL,NULL),(343,NULL,'6d828aa5def84480bdf10c24ed1af5ef',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:26:17',NULL,'2025-10-02 12:26:17',NULL,NULL),(344,NULL,NULL,'75905d855da84b45938e87f0e196c6d9',NULL,NULL,NULL,NULL,'2025-10-02 12:26:25',NULL,'2025-10-02 12:26:25',NULL,NULL),(345,NULL,'d1d8845b6c424ce9b1afeca588875d3e',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:26:26',NULL,'2025-10-02 12:26:26',NULL,NULL),(346,NULL,NULL,'39945f35886a49cb93285686405e043a',NULL,NULL,NULL,NULL,'2025-10-02 12:26:28',NULL,'2025-10-02 12:26:28',NULL,NULL),(347,NULL,NULL,'1d7a2d33ab1a4cbdb8af06a75057bb8c',NULL,NULL,NULL,NULL,'2025-10-02 12:26:29',NULL,'2025-10-02 12:26:29',NULL,NULL),(348,NULL,'cb0ff2bfa67c445d8fa27ad6d7c2f7a2',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:26:32',NULL,'2025-10-02 12:26:32',NULL,NULL),(349,NULL,'d5bedc1d8125465b92c98f9ebeb80ddb',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:26:33',NULL,'2025-10-02 12:26:33',NULL,NULL),(350,NULL,NULL,'25468893d71641a385711fd2982bb00b',NULL,NULL,NULL,NULL,'2025-10-02 12:26:41',NULL,'2025-10-02 12:26:41',NULL,NULL),(351,NULL,'10fff81da7a54740a53a0771ce916329',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:26:43',NULL,'2025-10-02 12:26:43',NULL,NULL),(352,NULL,NULL,'c6bda06d7e6348bab069e07b21022b60',NULL,NULL,NULL,NULL,'2025-10-02 12:29:51',NULL,'2025-10-02 12:29:51',NULL,NULL),(353,NULL,'7aad01ba5df14c1a9309451d0daaab83',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:29:55',NULL,'2025-10-02 12:29:55',NULL,NULL),(354,NULL,NULL,'88b7b954ac234f7299c3b2da84d2ca46',NULL,NULL,NULL,NULL,'2025-10-02 12:30:53',NULL,'2025-10-02 12:30:53',NULL,NULL),(355,NULL,'ba4a52d51214482ab1572bac703ce258',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:30:54',NULL,'2025-10-02 12:30:54',NULL,NULL),(356,NULL,NULL,'fc18358f9af64753bc8892379b9244c6',NULL,NULL,NULL,NULL,'2025-10-02 12:32:01',NULL,'2025-10-02 12:32:01',NULL,NULL),(357,NULL,'dda4e7689e7440639479cd7b0e4c17df',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:32:02',NULL,'2025-10-02 12:32:02',NULL,NULL),(358,NULL,NULL,'4a89b71e2513413e922ee6d5d06362b1',NULL,NULL,NULL,NULL,'2025-10-02 12:32:12',NULL,'2025-10-02 12:32:12',NULL,NULL),(359,NULL,'27a1729bf10548219b90df46839849f5',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:32:14',NULL,'2025-10-02 12:32:14',NULL,NULL),(360,NULL,NULL,'2bd16d1f5f9d4eb396c474eedee67165',NULL,NULL,NULL,NULL,'2025-10-02 12:32:19',NULL,'2025-10-02 12:32:19',NULL,NULL),(361,NULL,'4b8ca48cb5f64ef3b0736b8be82378b8',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:32:21',NULL,'2025-10-02 12:32:21',NULL,NULL),(362,NULL,NULL,'48a75d0d93424c10a37b179785fd1b2e',NULL,NULL,NULL,NULL,'2025-10-02 12:32:37',NULL,'2025-10-02 12:32:37',NULL,NULL),(363,NULL,'e758f5e629284ecf89b1c87f76580d61',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:32:39',NULL,'2025-10-02 12:32:39',NULL,NULL),(364,NULL,NULL,'0106eca2dafa49be98cd4d80559ecd6e',NULL,NULL,NULL,NULL,'2025-10-02 12:32:51',NULL,'2025-10-02 12:32:51',NULL,NULL),(365,NULL,'9ae403dc06bb4ae2931781d6fdbaba80',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:32:52',NULL,'2025-10-02 12:32:52',NULL,NULL),(366,NULL,NULL,'22d56fcd2a4b4851bfd126ae4548ee9b',NULL,NULL,NULL,NULL,'2025-10-02 12:33:45',NULL,'2025-10-02 12:33:45',NULL,NULL),(367,NULL,'5533aaac08cd4856af72ef4992bb5e76',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:33:46',NULL,'2025-10-02 12:33:46',NULL,NULL),(368,NULL,NULL,'95612007183445418f12dc53405b3e7b',NULL,NULL,NULL,NULL,'2025-10-02 12:33:52',NULL,'2025-10-02 12:33:52',NULL,NULL),(369,NULL,'f2fdda5532bd4487b413e696cfbf1197',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:33:53',NULL,'2025-10-02 12:33:53',NULL,NULL),(370,NULL,NULL,'1c2fbed9aaf84b4e864db97bec4c797c',NULL,NULL,NULL,NULL,'2025-10-02 12:34:20',NULL,'2025-10-02 12:34:20',NULL,NULL),(371,NULL,'385766b9209941f3ab805e8d5e2af163',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:34:21',NULL,'2025-10-02 12:34:21',NULL,NULL),(372,NULL,NULL,'f02a0ac23d9e44d5a6205e853818fa50',NULL,NULL,NULL,NULL,'2025-10-02 12:35:55',NULL,'2025-10-02 12:35:55',NULL,NULL),(373,NULL,'c3b4ed8f5ff54d4cb9f232e285155ca0',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:36:01',NULL,'2025-10-02 12:36:01',NULL,NULL),(374,NULL,NULL,'0461b0ecc68f46c4a844518811ec3622',NULL,NULL,NULL,NULL,'2025-10-02 12:36:09',NULL,'2025-10-02 12:36:09',NULL,NULL),(375,NULL,'e4365702411142a6b3b635d62808325d',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:36:11',NULL,'2025-10-02 12:36:11',NULL,NULL),(376,NULL,NULL,'6c932f0d0e594f00855572fbe06ee3aa',NULL,NULL,NULL,NULL,'2025-10-02 12:36:59',NULL,'2025-10-02 12:36:59',NULL,NULL),(377,NULL,'cc4d8f857b2d42bf9ae477fc5f514216',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:37:01',NULL,'2025-10-02 12:37:01',NULL,NULL),(378,NULL,NULL,'f7d78f04152a425b81d486a834213a76',NULL,NULL,NULL,NULL,'2025-10-02 12:38:11',NULL,'2025-10-02 12:38:11',NULL,NULL),(379,NULL,NULL,'9f0b9dbf274a4acba93f7293c18e2c02',NULL,NULL,NULL,NULL,'2025-10-02 12:38:12',NULL,'2025-10-02 12:38:12',NULL,NULL),(380,NULL,'af873f6cea354e099a97c3b09ce8ca27',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:38:13',NULL,'2025-10-02 12:38:13',NULL,NULL),(381,NULL,NULL,'8a62b6316cbe4a0ba98999e534c3b3c3',NULL,NULL,NULL,NULL,'2025-10-02 12:38:16',NULL,'2025-10-02 12:38:16',NULL,NULL),(382,NULL,NULL,'654b8b5114734d26a1f7f884fc0a7f94',NULL,NULL,NULL,NULL,'2025-10-02 12:38:16',NULL,'2025-10-02 12:38:16',NULL,NULL),(383,NULL,'54b7e131205e411c806645d86f50e5a5',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:38:18',NULL,'2025-10-02 12:38:18',NULL,NULL),(384,NULL,NULL,'a47e54dc71894a96aca3866905f00d1d',NULL,NULL,NULL,NULL,'2025-10-02 12:38:22',NULL,'2025-10-02 12:38:22',NULL,NULL),(385,NULL,'6e703ef5edd647a4a62b9e1536bf6ffa',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:38:23',NULL,'2025-10-02 12:38:23',NULL,NULL),(386,NULL,NULL,'fe9cc788734f406d826446a848700331',NULL,NULL,NULL,NULL,'2025-10-02 12:38:29',NULL,'2025-10-02 12:38:29',NULL,NULL),(387,NULL,NULL,'6d3af14868b54c158c5d037e00c19b6c',NULL,NULL,NULL,NULL,'2025-10-02 12:38:29',NULL,'2025-10-02 12:38:29',NULL,NULL),(388,NULL,'bc0d63d3b4404ef8858166e8836dd0af',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:38:30',NULL,'2025-10-02 12:38:30',NULL,NULL),(389,NULL,NULL,'bcd36ab668f449959719ba7058f25e72',NULL,NULL,NULL,NULL,'2025-10-02 12:38:51',NULL,'2025-10-02 12:38:51',NULL,NULL),(390,NULL,'1a05e525420b4aa8adcc9561158e73d1',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:38:52',NULL,'2025-10-02 12:38:52',NULL,NULL),(391,NULL,NULL,'00f7abe349fb496aaeb6c928e3602a2b',NULL,NULL,NULL,NULL,'2025-10-02 12:39:22',NULL,'2025-10-02 12:39:22',NULL,NULL),(392,NULL,'2a9fb2f388654380906f2a0db9d46565',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:39:25',NULL,'2025-10-02 12:39:25',NULL,NULL),(393,NULL,NULL,'d608dcd0370740e78efce5555136abfd',NULL,NULL,NULL,NULL,'2025-10-02 12:39:56',NULL,'2025-10-02 12:39:56',NULL,NULL),(394,NULL,'0c7abd0bd350497b8968db8ec003111e',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:40:10',NULL,'2025-10-02 12:40:10',NULL,NULL),(395,NULL,NULL,'c069815e606a4e15ab7012d4e87b7b35',NULL,NULL,NULL,NULL,'2025-10-02 12:40:14',NULL,'2025-10-02 12:40:14',NULL,NULL),(396,NULL,'f5c3b0b8571446a78cfa600774ad4e1f',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:40:17',NULL,'2025-10-02 12:40:17',NULL,NULL),(397,NULL,NULL,'10463752a3f74302a1cf367ceb512dac',NULL,NULL,NULL,NULL,'2025-10-02 12:40:20',NULL,'2025-10-02 12:40:20',NULL,NULL),(398,NULL,'e8f94ea84a9040a29e1a7623566b482b',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:40:23',NULL,'2025-10-02 12:40:23',NULL,NULL),(399,NULL,NULL,'b4ad22acfd744e47aa9bb09035188e74',NULL,NULL,NULL,NULL,'2025-10-02 12:40:46',NULL,'2025-10-02 12:40:46',NULL,NULL),(400,NULL,NULL,'34ae33c25b494dd8930fde1be80a2a56',NULL,NULL,NULL,NULL,'2025-10-02 12:40:47',NULL,'2025-10-02 12:40:47',NULL,NULL),(401,NULL,'7f98f3f24d8345acb80cc53224f6d03a',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:40:48',NULL,'2025-10-02 12:40:48',NULL,NULL),(402,NULL,'1294b2ea04b34f7189fde66e2afa2c56',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:40:50',NULL,'2025-10-02 12:40:50',NULL,NULL),(403,NULL,NULL,'2ef0e75a2eb448f6a88afb59cc60686f',NULL,NULL,NULL,NULL,'2025-10-02 12:40:53',NULL,'2025-10-02 12:40:53',NULL,NULL),(404,NULL,'eb79c45adbb144538245fe5c27fade6d',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:40:55',NULL,'2025-10-02 12:40:55',NULL,NULL),(405,NULL,NULL,'e0e5d41da13a47a1aa3210c37b88bbcc',NULL,NULL,NULL,NULL,'2025-10-02 12:41:14',NULL,'2025-10-02 12:41:14',NULL,NULL),(406,NULL,'ac8793fd6752403e9dea029569836c09',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:41:18',NULL,'2025-10-02 12:41:18',NULL,NULL),(407,NULL,NULL,'c02d1dcc10ea4e57bbc6b7a3c100dc7b',NULL,NULL,NULL,NULL,'2025-10-02 12:43:05',NULL,'2025-10-02 12:43:05',NULL,NULL),(408,NULL,'6822f02d5ca04c659329a75d487054cf',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:43:07',NULL,'2025-10-02 12:43:07',NULL,NULL),(409,NULL,NULL,'b52b66b6f76243b28f1ac13ea171269c',NULL,NULL,NULL,NULL,'2025-10-02 12:44:00',NULL,'2025-10-02 12:44:00',NULL,NULL),(410,NULL,'71902e570e234b5fa6914a7b1657bf63',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:44:01',NULL,'2025-10-02 12:44:01',NULL,NULL),(411,NULL,NULL,'b82c89ad6c4a49e78943f7a92d0a6560',NULL,NULL,NULL,NULL,'2025-10-02 12:44:43',NULL,'2025-10-02 12:44:43',NULL,NULL),(412,NULL,NULL,'dea82986e95e4671b4e033f4557fd878',NULL,NULL,NULL,NULL,'2025-10-02 12:44:43',NULL,'2025-10-02 12:44:43',NULL,NULL),(413,NULL,'bf14a9196aef453eaf59821159b0a0d7',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:44:44',NULL,'2025-10-02 12:44:44',NULL,NULL),(414,NULL,'a41d99312f014c65adddea4f70536a15',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:44:45',NULL,'2025-10-02 12:44:45',NULL,NULL),(415,NULL,NULL,'57d85bd790b540cd81dc4d2ab9e6fb13',NULL,NULL,NULL,NULL,'2025-10-02 12:44:53',NULL,'2025-10-02 12:44:53',NULL,NULL),(416,NULL,'1f50509a65834d86866517e09320e48b',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:44:54',NULL,'2025-10-02 12:44:54',NULL,NULL),(417,NULL,NULL,'3f5203753507439b848f7dd6c0782f0e',NULL,NULL,NULL,NULL,'2025-10-02 12:45:40',NULL,'2025-10-02 12:45:40',NULL,NULL),(418,NULL,'338177849a8045758e5c446cc24ffaa8',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:45:42',NULL,'2025-10-02 12:45:42',NULL,NULL),(419,NULL,NULL,'734ae44830d540d8ab51c2a3d75ecd80',NULL,NULL,NULL,NULL,'2025-10-02 12:45:49',NULL,'2025-10-02 12:45:49',NULL,NULL),(420,NULL,NULL,'cb8344dc8b2e402c87142d5a2340b649',NULL,NULL,NULL,NULL,'2025-10-02 12:45:49',NULL,'2025-10-02 12:45:49',NULL,NULL),(421,NULL,'92f7a22f98d44939af137e17a4696d38',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:45:51',NULL,'2025-10-02 12:45:51',NULL,NULL),(422,NULL,'2e53064cd4d645f09bd59bbca09b98e0',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:45:53',NULL,'2025-10-02 12:45:53',NULL,NULL),(423,NULL,NULL,'56c6abe1bb704c8aa499677aeb9017f5',NULL,NULL,NULL,NULL,'2025-10-02 12:46:27',NULL,'2025-10-02 12:46:27',NULL,NULL),(424,NULL,NULL,'6fc82271b52c43f9847c5e275c3619c9',NULL,NULL,NULL,NULL,'2025-10-02 12:46:27',NULL,'2025-10-02 12:46:27',NULL,NULL),(425,NULL,'4b8f9114c7ab4b6e9fc9650d4bd08af9',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:46:29',NULL,'2025-10-02 12:46:29',NULL,NULL),(426,NULL,'aca6167950c94550a6d323739dfefce7',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:46:33',NULL,'2025-10-02 12:46:33',NULL,NULL),(427,NULL,NULL,'f9c1a967b21e4d05a1e9cb54949a7527',NULL,NULL,NULL,NULL,'2025-10-02 12:47:58',NULL,'2025-10-02 12:47:58',NULL,NULL),(428,NULL,'508fca18f76a46cba8f3b8b8d8169ef1',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:47:59',NULL,'2025-10-02 12:47:59',NULL,NULL),(429,NULL,NULL,'a24a7109471f4d96ad5f11b637fdb8e7',NULL,NULL,NULL,NULL,'2025-10-02 12:49:51',NULL,'2025-10-02 12:49:51',NULL,NULL),(430,NULL,NULL,'4599f24aa05a4495994e6d17c41a791c',NULL,NULL,NULL,NULL,'2025-10-02 12:49:51',NULL,'2025-10-02 12:49:51',NULL,NULL),(431,NULL,'a837417d42da439cb794b4295bca2cee',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:49:53',NULL,'2025-10-02 12:49:53',NULL,NULL),(432,NULL,'942605bbab93466a920e2a60cd8f1a30',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:49:53',NULL,'2025-10-02 12:49:53',NULL,NULL),(433,NULL,NULL,'6785ffe5d6554514b4ed9fd47665eca0',NULL,NULL,NULL,NULL,'2025-10-02 12:55:27',NULL,'2025-10-02 12:55:27',NULL,NULL),(434,NULL,'6a442bc513e14406b73e96e70396e6c3',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:55:28',NULL,'2025-10-02 12:55:28',NULL,NULL),(435,NULL,NULL,'16730f38111542e58a05fb4deb2b3914',NULL,NULL,NULL,NULL,'2025-10-02 12:56:22',NULL,'2025-10-02 12:56:22',NULL,NULL),(436,NULL,NULL,'e22bfab495d045efbf09d770e1516f29',NULL,NULL,NULL,NULL,'2025-10-02 12:56:23',NULL,'2025-10-02 12:56:23',NULL,NULL),(437,NULL,NULL,'4f36ce25588d4328a94fd97f5f4641ec',NULL,NULL,NULL,NULL,'2025-10-02 12:56:23',NULL,'2025-10-02 12:56:23',NULL,NULL),(438,NULL,'5ade962c517a483dbfe4bb13386f0006',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:56:25',NULL,'2025-10-02 12:56:25',NULL,NULL),(439,NULL,'9bebc19e62a04c99b7982761086c6bb7',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:56:28',NULL,'2025-10-02 12:56:28',NULL,NULL),(440,NULL,'ae2cf4bda6954412ac1db4e195a70375',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:56:30',NULL,'2025-10-02 12:56:30',NULL,NULL),(441,NULL,NULL,'84e6a279aa124804af5819b25a773dc1',NULL,NULL,NULL,NULL,'2025-10-02 12:56:51',NULL,'2025-10-02 12:56:51',NULL,NULL),(442,NULL,'dec97fbf4fd141868e034a8652cf0c37',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:56:52',NULL,'2025-10-02 12:56:52',NULL,NULL),(443,NULL,NULL,'646b83e0375645cd9c030973c7801061',NULL,NULL,NULL,NULL,'2025-10-02 12:58:13',NULL,'2025-10-02 12:58:13',NULL,NULL),(444,NULL,NULL,'de066041e985417da95924c04915bd11',NULL,NULL,NULL,NULL,'2025-10-02 12:58:13',NULL,'2025-10-02 12:58:13',NULL,NULL),(445,NULL,'8668725b86704fdcacbb467738b51154',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:58:17',NULL,'2025-10-02 12:58:17',NULL,NULL),(446,NULL,'e08031c685814456aa6c43bcc8f98574',NULL,NULL,NULL,NULL,NULL,'2025-10-02 12:58:18',NULL,'2025-10-02 12:58:18',NULL,NULL),(447,NULL,NULL,'729669e8835d4d95b5aae25c140e1f06',NULL,NULL,NULL,NULL,'2025-10-02 13:00:08',NULL,'2025-10-02 13:00:08',NULL,NULL),(448,NULL,NULL,'a6c90d2a31b74dd587c3a14919294ffe',NULL,NULL,NULL,NULL,'2025-10-02 13:00:09',NULL,'2025-10-02 13:00:09',NULL,NULL),(449,NULL,'55e97477dd13448d9dafe69ec8614ea6',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:00:10',NULL,'2025-10-02 13:00:10',NULL,NULL),(450,NULL,'e8c6c84c0a924a09bf0fa4126340651a',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:00:11',NULL,'2025-10-02 13:00:11',NULL,NULL),(451,NULL,NULL,'3299a1aed5af4843a91417a3f181c172',NULL,NULL,NULL,NULL,'2025-10-02 13:01:18',NULL,'2025-10-02 13:01:18',NULL,NULL),(452,NULL,'e7168b5b1300495d90592b195824729a',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:01:22',NULL,'2025-10-02 13:01:22',NULL,NULL),(453,NULL,NULL,'fb366465e6154871b8a53c9f500105ce',NULL,NULL,NULL,NULL,'2025-10-02 13:05:06',NULL,'2025-10-02 13:05:06',NULL,NULL),(454,NULL,NULL,'5e17fffe32b2401b8719126dc858bfc7',NULL,NULL,NULL,NULL,'2025-10-02 13:05:06',NULL,'2025-10-02 13:05:06',NULL,NULL),(455,NULL,'fab6e5c2d1dc465f926ad40b742b18db',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:05:08',NULL,'2025-10-02 13:05:08',NULL,NULL),(456,NULL,'ce2ca82c03554560b55ed747ae63f1fb',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:05:09',NULL,'2025-10-02 13:05:09',NULL,NULL),(457,NULL,NULL,'10c60eb2034e4ded8a792115857927ff',NULL,NULL,NULL,NULL,'2025-10-02 13:05:54',NULL,'2025-10-02 13:05:54',NULL,NULL),(458,NULL,NULL,'bdc8406f2dde462fa434a45ccb849fb1',NULL,NULL,NULL,NULL,'2025-10-02 13:05:54',NULL,'2025-10-02 13:05:54',NULL,NULL),(459,NULL,'01fefa2ea1f14c609320758c48138eae',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:05:55',NULL,'2025-10-02 13:05:55',NULL,NULL),(460,NULL,'fe4f31859f5d412a94d15bbb07e1e35f',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:05:55',NULL,'2025-10-02 13:05:55',NULL,NULL),(461,NULL,NULL,'93facc00c95f4cbfa6cecaf3641182bc',NULL,NULL,NULL,NULL,'2025-10-02 13:06:12',NULL,'2025-10-02 13:06:12',NULL,NULL),(462,NULL,'5eceae619a6f4fdeaa8ba6fafda4912a',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:06:14',NULL,'2025-10-02 13:06:14',NULL,NULL),(463,NULL,NULL,'c3981911a48146829ed4203fd206e201',NULL,NULL,NULL,NULL,'2025-10-02 13:07:33',NULL,'2025-10-02 13:07:33',NULL,NULL),(464,NULL,NULL,'a381ccc8f51f4be19619d081e2b672dc',NULL,NULL,NULL,NULL,'2025-10-02 13:07:33',NULL,'2025-10-02 13:07:33',NULL,NULL),(465,NULL,'692867ea4ac343ada2d8819ca060e938',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:07:35',NULL,'2025-10-02 13:07:35',NULL,NULL),(466,NULL,'a8be669d844b4165b675a7d02f2d8588',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:07:35',NULL,'2025-10-02 13:07:35',NULL,NULL),(467,NULL,NULL,'29c8a28c5bdd4feb9412127428bf0c3b',NULL,NULL,NULL,NULL,'2025-10-02 13:10:04',NULL,'2025-10-02 13:10:04',NULL,NULL),(468,NULL,NULL,'2775e41bfe764fe597b91537ca807d6c',NULL,NULL,NULL,NULL,'2025-10-02 13:10:04',NULL,'2025-10-02 13:10:04',NULL,NULL),(469,NULL,'85b0221b065046a58c3f1b954d3a9a2d',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:10:05',NULL,'2025-10-02 13:10:05',NULL,NULL),(470,NULL,'60bfd415ee154615b20dd99528061614',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:10:06',NULL,'2025-10-02 13:10:06',NULL,NULL),(471,NULL,NULL,'c10de71fef00497981b8b7cec6a3fff3',NULL,NULL,NULL,NULL,'2025-10-02 13:16:25',NULL,'2025-10-02 13:16:25',NULL,NULL),(472,NULL,NULL,'88723f8f3fc7408c99cb292af572f4e8',NULL,NULL,NULL,NULL,'2025-10-02 13:16:25',NULL,'2025-10-02 13:16:25',NULL,NULL),(473,NULL,'2c2410b452ba4637a744bcf2cc6737bd',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:16:26',NULL,'2025-10-02 13:16:26',NULL,NULL),(474,NULL,'fbbc6cb494464fd9b31f64c1ad75fa6b',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:16:28',NULL,'2025-10-02 13:16:28',NULL,NULL),(475,NULL,NULL,'ffe4d737e4414fb3a3e358f8ca3f3e1e',NULL,NULL,NULL,NULL,'2025-10-02 13:19:04',NULL,'2025-10-02 13:19:04',NULL,NULL),(476,NULL,NULL,'67f7dad14d084636b43800f8e31de2b3',NULL,NULL,NULL,NULL,'2025-10-02 13:19:05',NULL,'2025-10-02 13:19:05',NULL,NULL),(477,NULL,'08e102ae48244af2ab448a2e1ff757df',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:19:07',NULL,'2025-10-02 13:19:07',NULL,NULL),(478,NULL,'6c41a7573a694f9fb3ae10771b2fa09f',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:19:08',NULL,'2025-10-02 13:19:08',NULL,NULL),(479,NULL,NULL,'cf146b5405394205a656779cabeab6aa',NULL,NULL,NULL,NULL,'2025-10-02 13:19:31',NULL,'2025-10-02 13:19:31',NULL,NULL),(480,NULL,NULL,'b2eb49e078594fa196f1aa8c5c67ab0a',NULL,NULL,NULL,NULL,'2025-10-02 13:19:31',NULL,'2025-10-02 13:19:31',NULL,NULL),(481,NULL,'b51f77014cbe4368be76848ac56dbfce',NULL,NULL,NULL,NULL,NULL,'2025-10-02 13:19:34',NULL,'2025-10-02 13:19:34',NULL,NULL);
/*!40000 ALTER TABLE `revocation_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL DEFAULT '<<null>>',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_role_name_domain_id` (`name`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` (`id`, `name`, `extra`, `domain_id`, `description`) VALUES ('0775235fad354e3899c9333e7941f97d','ResellerAdmin','{}','<<null>>',NULL),('4d67b005c4d741e8bef0179c58976a2c','member','{}','<<null>>',NULL),('85f92a60b61c46d9a3a532593ecd4d31','swiftoperator','{}','<<null>>',NULL),('8855e2cc253a496086a7695dd9c0b945','admin','{}','<<null>>',NULL),('8aa1ee34c62845fbaba587d241e79078','reader','{}','<<null>>',NULL),('a59febc5d6c049ae8f02bb916d6b421f','service','{}','<<null>>',NULL);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_option`
--

DROP TABLE IF EXISTS `role_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_option` (
  `role_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`role_id`,`option_id`),
  CONSTRAINT `role_option_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_option`
--

LOCK TABLES `role_option` WRITE;
/*!40000 ALTER TABLE `role_option` DISABLE KEYS */;
INSERT INTO `role_option` (`role_id`, `option_id`, `option_value`) VALUES ('4d67b005c4d741e8bef0179c58976a2c','IMMU','true'),('8855e2cc253a496086a7695dd9c0b945','IMMU','true'),('8aa1ee34c62845fbaba587d241e79078','IMMU','true');
/*!40000 ALTER TABLE `role_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sensitive_config`
--

DROP TABLE IF EXISTS `sensitive_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sensitive_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sensitive_config`
--

LOCK TABLES `sensitive_config` WRITE;
/*!40000 ALTER TABLE `sensitive_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sensitive_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `type`, `enabled`, `extra`) VALUES ('1b2366f0addb45439c1fd4be37efd6bd','compute',1,'{\"description\": \"Nova Compute Service\", \"name\": \"nova\"}'),('38b9e926363f46a0977da878d6c77619','network',1,'{\"description\": \"Openstack Networking\", \"name\": \"neutron\"}'),('6d3cf1dfd9c44d8c8d6b877d0150dac5','placement',1,'{\"description\": \"Placement Service\", \"name\": \"placement\"}'),('9558262ca0014ff6b26cc5e7fee9c122','key-manager',1,'{\"description\": \"Barbican Service\", \"name\": \"barbican\"}'),('cf6fe3f52a634b5398f6784284cf287c','volumev3',1,'{\"description\": \"Cinder V3 Service\", \"name\": \"cinderv3\"}'),('d1dc8935dbe84cd7a3f63f4e0c8898d8','object-store',1,'{\"name\": \"swift\", \"description\": \"OpenStack Object Storage\"}'),('d645029339414c309147da31876ff41f','identity',1,'{\"name\": \"keystone\"}'),('ded48b9a3d9e46f49c45e32111c5c49f','Ceilometer',1,'{\"description\": \"Ceilometer Service\", \"name\": \"ceilometer\"}'),('fe2ea3816a354dc19a4c123ba1052720','image',1,'{\"description\": \"Glance Service\", \"name\": \"glance\"}');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_provider`
--

DROP TABLE IF EXISTS `service_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_provider` (
  `auth_url` varchar(256) NOT NULL,
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `sp_url` varchar(256) NOT NULL,
  `relay_state_prefix` varchar(256) NOT NULL DEFAULT 'ss:mem:',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_provider`
--

LOCK TABLES `service_provider` WRITE;
/*!40000 ALTER TABLE `service_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `service_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_assignment`
--

DROP TABLE IF EXISTS `system_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_assignment` (
  `type` varchar(64) NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_assignment`
--

LOCK TABLES `system_assignment` WRITE;
/*!40000 ALTER TABLE `system_assignment` DISABLE KEYS */;
INSERT INTO `system_assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserSystem','57823c2cf8a04b2abc574ed057efc3db','system','8855e2cc253a496086a7695dd9c0b945',0);
/*!40000 ALTER TABLE `system_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `token`
--

DROP TABLE IF EXISTS `token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `token` (
  `id` varchar(64) NOT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_token_user_id` (`user_id`),
  KEY `ix_token_expires_valid` (`expires`,`valid`),
  KEY `ix_token_expires` (`expires`),
  KEY `ix_token_trust_id` (`trust_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `token`
--

LOCK TABLES `token` WRITE;
/*!40000 ALTER TABLE `token` DISABLE KEYS */;
/*!40000 ALTER TABLE `token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust`
--

DROP TABLE IF EXISTS `trust`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust` (
  `id` varchar(64) NOT NULL,
  `trustor_user_id` varchar(64) NOT NULL,
  `trustee_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `impersonation` tinyint(1) NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `remaining_uses` int(11) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `redelegated_trust_id` varchar(64) DEFAULT NULL,
  `redelegation_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `duplicate_trust_constraint_expanded` (`trustor_user_id`,`trustee_user_id`,`project_id`,`impersonation`,`expires_at`,`expires_at_int`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust`
--

LOCK TABLES `trust` WRITE;
/*!40000 ALTER TABLE `trust` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust_role`
--

DROP TABLE IF EXISTS `trust_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust_role` (
  `trust_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`trust_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust_role`
--

LOCK TABLES `trust_role` WRITE;
/*!40000 ALTER TABLE `trust_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `default_project_id` varchar(64) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_active_at` date DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_user_id_domain_id` (`id`,`domain_id`),
  KEY `ix_default_project_id` (`default_project_id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `extra`, `enabled`, `default_project_id`, `created_at`, `last_active_at`, `domain_id`) VALUES ('2ba37b62dd5f4f568f4f548411019b19','{}',1,'aebeb47424cc4f05b6c098503009ac0d','2025-10-02 11:13:31','2025-10-02','default'),('4139fcfb31e0453ca7277317523f248f','{\"tenantId\": \"f83c515bcd6b4dc19a7e40bd81643192\", \"email\": \"alt_demo_tempestconf@test.com\"}',1,NULL,'2025-10-02 11:57:35',NULL,'default'),('57823c2cf8a04b2abc574ed057efc3db','{}',1,NULL,'2025-10-02 11:12:07','2025-10-02','default'),('62dc8ee9765446f9820441bcf401f4cc','{}',1,'aebeb47424cc4f05b6c098503009ac0d','2025-10-02 11:14:05','2025-10-02','default'),('859ffbc3614042108037541e456daa78','{}',1,'aebeb47424cc4f05b6c098503009ac0d','2025-10-02 11:13:07','2025-10-02','default'),('8ca87a1850614c06b2e2165883628d33','{}',1,'aebeb47424cc4f05b6c098503009ac0d','2025-10-02 11:13:25','2025-10-02','default'),('b50e11eaa8fa4f07a33c6bb9133ca7ca','{\"tenantId\": \"db0711c79d3343a6b45eee0c395c823b\", \"email\": \"demo_tempestconf@test.com\"}',1,NULL,'2025-10-02 11:57:31',NULL,'default'),('bb38f143b67741f380a581625d2d2a5c','{}',1,'aebeb47424cc4f05b6c098503009ac0d','2025-10-02 11:13:21','2025-10-02','default'),('bcce56fe65b04eb9aa1d1152b7e73d5f','{}',1,'aebeb47424cc4f05b6c098503009ac0d','2025-10-02 11:34:58',NULL,'default'),('d55b3ee250d1468fbcf33643dda37adb','{}',1,'aebeb47424cc4f05b6c098503009ac0d','2025-10-02 11:14:17','2025-10-02','default'),('f2700629748f4a53afaee0e33dc39c53','{}',1,'aebeb47424cc4f05b6c098503009ac0d','2025-10-02 11:14:00','2025-10-02','default');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_group_membership`
--

DROP TABLE IF EXISTS `user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `fk_user_group_membership_group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `fk_user_group_membership_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_group_membership`
--

LOCK TABLES `user_group_membership` WRITE;
/*!40000 ALTER TABLE `user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_option`
--

DROP TABLE IF EXISTS `user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_option` (
  `user_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`user_id`,`option_id`),
  CONSTRAINT `user_option_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_option`
--

LOCK TABLES `user_option` WRITE;
/*!40000 ALTER TABLE `user_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whitelisted_config`
--

DROP TABLE IF EXISTS `whitelisted_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whitelisted_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whitelisted_config`
--

LOCK TABLES `whitelisted_config` WRITE;
/*!40000 ALTER TABLE `whitelisted_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `whitelisted_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `mysql`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `mysql` /*!40100 DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci */;

USE `mysql`;

--
-- Table structure for table `general_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `general_log` (
  `event_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `command_type` varchar(64) NOT NULL,
  `argument` mediumtext NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='General log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slow_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `slow_log` (
  `start_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `query_time` time(6) NOT NULL,
  `lock_time` time(6) NOT NULL,
  `rows_sent` bigint(20) unsigned NOT NULL,
  `rows_examined` bigint(20) unsigned NOT NULL,
  `db` varchar(512) NOT NULL,
  `last_insert_id` int(11) NOT NULL,
  `insert_id` int(11) NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `sql_text` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `rows_affected` bigint(20) unsigned NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Slow log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `column_stats`
--

DROP TABLE IF EXISTS `column_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `column_stats` (
  `db_name` varchar(64) NOT NULL,
  `table_name` varchar(64) NOT NULL,
  `column_name` varchar(64) NOT NULL,
  `min_value` varbinary(255) DEFAULT NULL,
  `max_value` varbinary(255) DEFAULT NULL,
  `nulls_ratio` decimal(12,4) DEFAULT NULL,
  `avg_length` decimal(12,4) DEFAULT NULL,
  `avg_frequency` decimal(12,4) DEFAULT NULL,
  `hist_size` tinyint(3) unsigned DEFAULT NULL,
  `hist_type` enum('SINGLE_PREC_HB','DOUBLE_PREC_HB') DEFAULT NULL,
  `histogram` varbinary(255) DEFAULT NULL,
  PRIMARY KEY (`db_name`,`table_name`,`column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='Statistics on Columns';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `column_stats`
--

LOCK TABLES `column_stats` WRITE;
/*!40000 ALTER TABLE `column_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `column_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `columns_priv`
--

DROP TABLE IF EXISTS `columns_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `columns_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Table_name` char(64) NOT NULL DEFAULT '',
  `Column_name` char(64) NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `Column_priv` set('Select','Insert','Update','References') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`Host`,`Db`,`User`,`Table_name`,`Column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Column privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `columns_priv`
--

LOCK TABLES `columns_priv` WRITE;
/*!40000 ALTER TABLE `columns_priv` DISABLE KEYS */;
/*!40000 ALTER TABLE `columns_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db`
--

DROP TABLE IF EXISTS `db`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `db` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Event_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_history_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Host`,`Db`,`User`),
  KEY `User` (`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Database privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `db`
--

LOCK TABLES `db` WRITE;
/*!40000 ALTER TABLE `db` DISABLE KEYS */;
INSERT INTO `db` (`Host`, `Db`, `User`, `Select_priv`, `Insert_priv`, `Update_priv`, `Delete_priv`, `Create_priv`, `Drop_priv`, `Grant_priv`, `References_priv`, `Index_priv`, `Alter_priv`, `Create_tmp_table_priv`, `Lock_tables_priv`, `Create_view_priv`, `Show_view_priv`, `Create_routine_priv`, `Alter_routine_priv`, `Execute_priv`, `Event_priv`, `Trigger_priv`, `Delete_history_priv`) VALUES ('localhost','placement','placement_cc0c','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','placement','placement_cc0c','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','glance','glance_fc72','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','glance','glance_fc72','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','keystone','keystone_2998','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','keystone','keystone_2998','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','cinder','cinder_5229','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','cinder','cinder_5229','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','barbican','barbican_c9ea','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','barbican','barbican_c9ea','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','neutron','neutron_9d70','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','neutron','neutron_9d70','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_api','nova_api_22fa','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_api','nova_api_22fa','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_cell0','nova_cell0_eb53','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_cell0','nova_cell0_eb53','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');
/*!40000 ALTER TABLE `db` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `db` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `name` char(64) NOT NULL DEFAULT '',
  `body` longblob NOT NULL,
  `definer` char(141) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `execute_at` datetime DEFAULT NULL,
  `interval_value` int(11) DEFAULT NULL,
  `interval_field` enum('YEAR','QUARTER','MONTH','DAY','HOUR','MINUTE','WEEK','SECOND','MICROSECOND','YEAR_MONTH','DAY_HOUR','DAY_MINUTE','DAY_SECOND','HOUR_MINUTE','HOUR_SECOND','MINUTE_SECOND','DAY_MICROSECOND','HOUR_MICROSECOND','MINUTE_MICROSECOND','SECOND_MICROSECOND') DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_executed` datetime DEFAULT NULL,
  `starts` datetime DEFAULT NULL,
  `ends` datetime DEFAULT NULL,
  `status` enum('ENABLED','DISABLED','SLAVESIDE_DISABLED') NOT NULL DEFAULT 'ENABLED',
  `on_completion` enum('DROP','PRESERVE') NOT NULL DEFAULT 'DROP',
  `sql_mode` set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','IGNORE_BAD_TABLE_OPTIONS','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH','EMPTY_STRING_IS_NULL','SIMULTANEOUS_ASSIGNMENT','TIME_ROUND_FRACTIONAL') NOT NULL DEFAULT '',
  `comment` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `originator` int(10) unsigned NOT NULL,
  `time_zone` char(64) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT 'SYSTEM',
  `character_set_client` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `collation_connection` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `db_collation` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `body_utf8` longblob DEFAULT NULL,
  PRIMARY KEY (`db`,`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Events';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `func`
--

DROP TABLE IF EXISTS `func`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `func` (
  `name` char(64) NOT NULL DEFAULT '',
  `ret` tinyint(1) NOT NULL DEFAULT 0,
  `dl` char(128) NOT NULL DEFAULT '',
  `type` enum('function','aggregate') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='User defined functions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `func`
--

LOCK TABLES `func` WRITE;
/*!40000 ALTER TABLE `func` DISABLE KEYS */;
/*!40000 ALTER TABLE `func` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `global_priv`
--

DROP TABLE IF EXISTS `global_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Priv` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '{}' CHECK (json_valid(`Priv`)),
  PRIMARY KEY (`Host`,`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Users and global privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `global_priv`
--

LOCK TABLES `global_priv` WRITE;
/*!40000 ALTER TABLE `global_priv` DISABLE KEYS */;
INSERT INTO `global_priv` (`Host`, `User`, `Priv`) VALUES ('localhost','mariadb.sys','{\"access\":0,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"\",\"account_locked\":true,\"password_last_changed\":0}'),('localhost','root','{\"access\": 549755813887, \"plugin\": \"mysql_native_password\", \"authentication_string\": \"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\", \"auth_or\": [{}],\"version_id\":100529,\"password_last_changed\":1759403457}'),('%','root','{\"access\":549755813887,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\",\"password_last_changed\":1759403457}'),('localhost','placement_cc0c','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*F6AA36218A640BFED94E19383C1033267C1F7C0E\",\"password_last_changed\":1759403476}'),('%','placement_cc0c','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*F6AA36218A640BFED94E19383C1033267C1F7C0E\",\"password_last_changed\":1759403476}'),('localhost','glance_fc72','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*2A10F491CB4E4DB6D963DCACC3FB650EFB016793\",\"password_last_changed\":1759403482}'),('%','glance_fc72','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*2A10F491CB4E4DB6D963DCACC3FB650EFB016793\",\"password_last_changed\":1759403483}'),('localhost','keystone_2998','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*D232C3BB0AAEBCDF85BD858435CE2A880ABCDB1B\",\"password_last_changed\":1759403486}'),('%','keystone_2998','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*D232C3BB0AAEBCDF85BD858435CE2A880ABCDB1B\",\"password_last_changed\":1759403486}'),('localhost','cinder_5229','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*7B65EC488999C63145CFF7005842FD5A41F6B171\",\"password_last_changed\":1759403524}'),('%','cinder_5229','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*7B65EC488999C63145CFF7005842FD5A41F6B171\",\"password_last_changed\":1759403524}'),('localhost','barbican_c9ea','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*8AD44DCF602FDF9B05A924C0332A649D5CAA1008\",\"password_last_changed\":1759403524}'),('%','barbican_c9ea','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*8AD44DCF602FDF9B05A924C0332A649D5CAA1008\",\"password_last_changed\":1759403524}'),('localhost','neutron_9d70','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*D9A085150CD7E457B2D316CA20FA3DC721EDB187\",\"password_last_changed\":1759403524}'),('%','neutron_9d70','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*D9A085150CD7E457B2D316CA20FA3DC721EDB187\",\"password_last_changed\":1759403524}'),('localhost','nova_api_22fa','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B4991A6F51E6552CF3A5E5302CE386D87E57C51A\",\"password_last_changed\":1759403638}'),('%','nova_api_22fa','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B4991A6F51E6552CF3A5E5302CE386D87E57C51A\",\"password_last_changed\":1759403638}'),('localhost','nova_cell0_eb53','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*8E32A7ED1D946CBA13167F27CD328AF9617793B3\",\"password_last_changed\":1759403638}'),('%','nova_cell0_eb53','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*8E32A7ED1D946CBA13167F27CD328AF9617793B3\",\"password_last_changed\":1759403639}');
/*!40000 ALTER TABLE `global_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gtid_slave_pos`
--

DROP TABLE IF EXISTS `gtid_slave_pos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gtid_slave_pos` (
  `domain_id` int(10) unsigned NOT NULL,
  `sub_id` bigint(20) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `seq_no` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`domain_id`,`sub_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci COMMENT='Replication slave GTID position';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gtid_slave_pos`
--

LOCK TABLES `gtid_slave_pos` WRITE;
/*!40000 ALTER TABLE `gtid_slave_pos` DISABLE KEYS */;
/*!40000 ALTER TABLE `gtid_slave_pos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_category`
--

DROP TABLE IF EXISTS `help_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_category` (
  `help_category_id` smallint(5) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `parent_category_id` smallint(5) unsigned DEFAULT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_category_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_category`
--

LOCK TABLES `help_category` WRITE;
/*!40000 ALTER TABLE `help_category` DISABLE KEYS */;
INSERT INTO `help_category` (`help_category_id`, `name`, `parent_category_id`, `url`) VALUES (1,'Contents',0,''),(2,'Polygon Properties',34,''),(3,'WKT',34,''),(4,'Numeric Functions',37,''),(5,'Plugins',1,''),(6,'MBR',34,''),(7,'Control Flow Functions',37,''),(8,'Transactions',1,''),(9,'Help Metadata',1,''),(10,'Account Management',1,''),(11,'Point Properties',34,''),(12,'Encryption Functions',37,''),(13,'LineString Properties',34,''),(14,'Miscellaneous Functions',37,''),(15,'Logical Operators',47,''),(16,'Functions and Modifiers for Use with GROUP BY',1,''),(17,'Information Functions',37,''),(18,'Assignment Operators',47,''),(19,'Comparison Operators',47,''),(20,'Bit Functions',37,''),(21,'Table Maintenance',1,''),(22,'User-Defined Functions',1,''),(23,'Data Types',1,''),(24,'Compound Statements',1,''),(25,'Geometry Constructors',34,''),(26,'Administration',1,''),(27,'Data Manipulation',1,''),(28,'Utility',1,''),(29,'Language Structure',1,''),(30,'Geometry Relations',34,''),(31,'Date and Time Functions',37,''),(32,'WKB',34,''),(33,'Procedures',1,''),(34,'Geographic Features',1,''),(35,'Geometry Properties',34,''),(36,'String Functions',37,''),(37,'Functions',1,''),(38,'Data Definition',1,''),(39,'Sequences',1,''),(40,'JSON Functions',37,''),(41,'Window Functions',37,''),(42,'Spider Functions',37,''),(43,'Dynamic Column Functions',37,''),(44,'Galera Functions',37,''),(45,'Temporal Tables',1,''),(46,'GeoJSON',34,''),(47,'Operators',1,''),(48,'Arithmetic Operators',47,''),(49,'Replication',1,''),(50,'Prepared Statements',1,'');
/*!40000 ALTER TABLE `help_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_keyword`
--

DROP TABLE IF EXISTS `help_keyword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_keyword` (
  `help_keyword_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  PRIMARY KEY (`help_keyword_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help keywords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_keyword`
--

LOCK TABLES `help_keyword` WRITE;
/*!40000 ALTER TABLE `help_keyword` DISABLE KEYS */;
INSERT INTO `help_keyword` (`help_keyword_id`, `name`) VALUES (1,'work'),(2,'locks'),(3,'locking'),(4,'drop'),(5,'super'),(6,'usage'),(7,'binlog admin'),(8,'binlog monitor'),(9,'binlog replay'),(10,'connection admin'),(11,'federated admin'),(12,'grant option'),(13,'read_only admin'),(14,'replica monitor'),(15,'replication replica'),(16,'roles'),(17,'values'),(18,'value'),(19,'not'),(20,'and'),(21,'or'),(22,':='),(23,'assignment operator'),(24,'='),(25,'!='),(26,'<>'),(27,'not equal'),(28,'less than'),(29,'less than or equal'),(30,'NULL-safe equal'),(31,'equal'),(32,'greater than'),(33,'greater than or equal'),(34,'bitwise and'),(35,'shift left'),(36,'shift right'),(37,'bitwise xor'),(38,'bitwise or'),(39,'bitwise not'),(40,'returns'),(41,'udfs'),(42,'udf calling sequences'),(43,'udf security'),(44,'int1'),(45,'int2'),(46,'int3'),(47,'integer'),(48,'int4'),(49,'int8'),(50,'dec'),(51,'numeric'),(52,'fixed'),(53,'number'),(54,'real'),(55,'double precision'),(56,'nchar'),(57,'long'),(58,'long varchar'),(59,'repeat'),(60,'declare'),(61,'cursor'),(62,'show'),(63,'columns'),(64,'kill connection'),(65,'kill query'),(66,'delete returning'),(67,'sql_big_result'),(68,'minus'),(69,'cte'),(70,'insert returning'),(71,'queries'),(72,'query'),(73,'explain format'),(74,'explain format json'),(75,'rlike'),(76,'character_length'),(77,'escape'),(78,'mode'),(79,'trim_oracle'),(80,'schedule'),(81,'row_format'),(82,'starts'),(83,'host'),(84,'generated columns'),(85,'virtual columns'),(86,'computed columns'),(87,'hidden columns'),(88,'nextval'),(89,'lastval'),(90,'+'),(91,'addition operator'),(92,'/'),(93,'division operator'),(94,'%'),(95,'modulo operator'),(96,'*'),(97,'multiplication operator'),(98,'-'),(99,'subtraction operator'),(100,'master_ssl_verify_cert'),(101,'start replica'),(102,'stop replica'),(103,'reset slave'),(104,'reset replica'),(105,'drop prepare'),(106,'deallocate prepare');
/*!40000 ALTER TABLE `help_keyword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_relation`
--

DROP TABLE IF EXISTS `help_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_relation` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `help_keyword_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`help_keyword_id`,`help_topic_id`),
  KEY `help_topic_id` (`help_topic_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='keyword-topic relation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_relation`
--

LOCK TABLES `help_relation` WRITE;
/*!40000 ALTER TABLE `help_relation` DISABLE KEYS */;
INSERT INTO `help_relation` (`help_topic_id`, `help_keyword_id`) VALUES (94,1),(97,2),(99,2),(101,2),(116,2),(147,2),(152,2),(157,2),(161,2),(162,2),(338,2),(438,2),(97,3),(99,3),(101,3),(116,3),(147,3),(152,3),(157,3),(161,3),(162,3),(338,3),(438,3),(106,4),(112,4),(250,4),(687,4),(697,4),(713,4),(714,4),(715,4),(716,4),(717,4),(718,4),(719,4),(720,4),(722,4),(723,4),(731,4),(107,5),(107,6),(107,7),(107,8),(107,9),(107,10),(107,11),(107,12),(107,13),(107,14),(107,15),(115,16),(166,17),(166,18),(167,19),(168,20),(170,21),(210,22),(210,23),(211,23),(211,24),(212,25),(212,26),(212,27),(213,28),(214,29),(215,30),(216,31),(217,32),(218,33),(232,34),(233,35),(234,36),(236,37),(237,38),(238,39),(249,40),(251,41),(252,42),(253,43),(255,44),(257,45),(258,46),(259,47),(259,48),(260,49),(261,50),(261,51),(261,52),(261,53),(263,54),(263,55),(269,56),(275,57),(275,58),(304,59),(664,59),(311,60),(311,61),(331,62),(332,62),(333,62),(334,62),(335,62),(342,62),(343,62),(344,62),(345,62),(346,62),(347,62),(354,62),(356,62),(357,62),(358,62),(359,62),(360,62),(361,62),(362,62),(363,62),(364,62),(365,62),(366,62),(367,62),(368,62),(369,62),(370,62),(371,62),(372,62),(373,62),(374,62),(375,62),(376,62),(377,62),(378,62),(379,62),(380,62),(381,62),(382,62),(383,62),(384,62),(385,62),(386,62),(387,62),(388,62),(389,62),(390,62),(391,62),(392,62),(393,62),(394,62),(395,62),(396,62),(397,62),(398,62),(408,62),(409,62),(333,63),(403,64),(403,65),(410,66),(414,67),(425,68),(431,69),(432,69),(433,69),(453,70),(460,71),(460,72),(466,73),(466,74),(622,75),(632,76),(651,77),(657,78),(678,79),(689,80),(696,81),(701,82),(707,83),(711,84),(711,85),(711,86),(712,87),(732,88),(733,89),(804,90),(804,91),(805,92),(805,93),(806,94),(806,95),(807,96),(807,97),(808,98),(808,99),(809,100),(810,101),(811,102),(812,103),(812,104),(816,105),(816,106);
/*!40000 ALTER TABLE `help_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_topic`
--

DROP TABLE IF EXISTS `help_topic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_topic` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `help_category_id` smallint(5) unsigned NOT NULL,
  `description` text NOT NULL,
  `example` text NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_topic_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help topics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_topic`
--

LOCK TABLES `help_topic` WRITE;
/*!40000 ALTER TABLE `help_topic` DISABLE KEYS */;
INSERT INTO `help_topic` (`help_topic_id`, `name`, `help_category_id`, `description`, `example`, `url`) VALUES (1,'HELP_DATE',9,'Help Contents generated from the MariaDB Knowledge Base on 23 January 2023.','',''),(2,'HELP_VERSION',9,'Help Contents generated for MariaDB 10.5 from the MariaDB Knowledge Base on 23 January 2023.','',''),(3,'AREA',2,'A synonym for ST_AREA.\n\nURL: https://mariadb.com/kb/en/polygon-properties-area/','','https://mariadb.com/kb/en/polygon-properties-area/'),(4,'CENTROID',2,'A synonym for ST_CENTROID.\n\nURL: https://mariadb.com/kb/en/centroid/','','https://mariadb.com/kb/en/centroid/'),(5,'ExteriorRing',2,'A synonym for ST_ExteriorRing.\n\nURL: https://mariadb.com/kb/en/polygon-properties-exteriorring/','','https://mariadb.com/kb/en/polygon-properties-exteriorring/'),(6,'InteriorRingN',2,'A synonym for ST_InteriorRingN.\n\nURL: https://mariadb.com/kb/en/polygon-properties-interiorringn/','','https://mariadb.com/kb/en/polygon-properties-interiorringn/'),(7,'NumInteriorRings',2,'A synonym for ST_NumInteriorRings.\n\nURL: https://mariadb.com/kb/en/polygon-properties-numinteriorrings/','','https://mariadb.com/kb/en/polygon-properties-numinteriorrings/'),(8,'ST_AREA',2,'Syntax\n------\n\nST_Area(poly)\nArea(poly)\n\nDescription\n-----------\n\nReturns as a double-precision number the area of the Polygon value poly, as\nmeasured in its spatial reference system.\n\nST_Area() and Area() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\n\nSELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+\n\nURL: https://mariadb.com/kb/en/st_area/','','https://mariadb.com/kb/en/st_area/'),(9,'ST_CENTROID',2,'Syntax\n------\n\nST_Centroid(mpoly)\nCentroid(mpoly)\n\nDescription\n-----------\n\nReturns a point reflecting the mathematical centroid (geometric center) for\nthe MultiPolygon mpoly. The resulting point will not necessarily be on the\nMultiPolygon.\n\nST_Centroid() and Centroid() are synonyms.\n\nExamples\n--------\n\nSET @poly = ST_GeomFromText(\'POLYGON((0 0,20 0,20 20,0 20,0 0))\');\nSELECT ST_AsText(ST_Centroid(@poly)) AS center;\n+--------------+\n| center       |\n+--------------+\n| POINT(10 10) |\n+--------------+\n\nURL: https://mariadb.com/kb/en/st_centroid/','','https://mariadb.com/kb/en/st_centroid/'),(10,'ST_ExteriorRing',2,'Syntax\n------\n\nST_ExteriorRing(poly)\nExteriorRing(poly)\n\nDescription\n-----------\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nST_ExteriorRing() and ExteriorRing() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_exteriorring/','','https://mariadb.com/kb/en/st_exteriorring/'),(11,'ST_InteriorRingN',2,'Syntax\n------\n\nST_InteriorRingN(poly,N)\nInteriorRingN(poly,N)\n\nDescription\n-----------\n\nReturns the N-th interior ring for the Polygon value poly as a LineString.\nRings are numbered beginning with 1.\n\nST_InteriorRingN() and InteriorRingN() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_interiorringn/','','https://mariadb.com/kb/en/st_interiorringn/'),(12,'ST_NumInteriorRings',2,'Syntax\n------\n\nST_NumInteriorRings(poly)\nNumInteriorRings(poly)\n\nDescription\n-----------\n\nReturns an integer containing the number of interior rings in the Polygon\nvalue poly.\n\nNote that according the the OpenGIS standard, a POLYGON should have exactly\none ExteriorRing and all other rings should lie within that ExteriorRing and\nthus be the InteriorRings. Practically, however, some systems, including\nMariaDB\'s, permit polygons to have several \'ExteriorRings\'. In the case of\nthere being multiple, non-overlapping exterior rings ST_NumInteriorRings()\nwill return 1.\n\nST_NumInteriorRings() and NumInteriorRings() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\n\nNon-overlapping \'polygon\':\n\nSELECT ST_NumInteriorRings(ST_PolyFromText(\'POLYGON((0 0,10 0,10 10,0 10,0 0),\n (-1 -1,-5 -1,-5 -5,-1 -5,-1 -1))\')) AS NumInteriorRings;\n+------------------+\n| NumInteriorRings |\n+------------------+\n|                1 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/st_numinteriorrings/','','https://mariadb.com/kb/en/st_numinteriorrings/'),(14,'AsText',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-astext/','','https://mariadb.com/kb/en/wkt-astext/'),(15,'AsWKT',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-aswkt/','','https://mariadb.com/kb/en/wkt-aswkt/'),(16,'GeomCollFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomcollfromtext/','','https://mariadb.com/kb/en/wkt-geomcollfromtext/'),(17,'GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/geometrycollectionfromtext/','','https://mariadb.com/kb/en/geometrycollectionfromtext/'),(18,'GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/geometryfromtext/','','https://mariadb.com/kb/en/geometryfromtext/'),(19,'GeomFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomfromtext/','','https://mariadb.com/kb/en/wkt-geomfromtext/'),(20,'LineFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/wkt-linefromtext/','','https://mariadb.com/kb/en/wkt-linefromtext/'),(21,'LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/linestringfromtext/','','https://mariadb.com/kb/en/linestringfromtext/'),(22,'MLineFromText',3,'Syntax\n------\n\nMLineFromText(wkt[,srid])\nMultiLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTILINESTRING value using its WKT representation and SRID.\n\nMLineFromText() and MultiLineStringFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nSHOW FIELDS FROM gis_multi_line;\nINSERT INTO gis_multi_line VALUES\n  (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16\n23,16 48))\')),\n  (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n  (MLineFromWKB(AsWKB(MultiLineString(\n   LineString(Point(1, 2), Point(3, 5)),\n   LineString(Point(2, 5), Point(5, 8), Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/mlinefromtext/','','https://mariadb.com/kb/en/mlinefromtext/'),(23,'MPointFromText',3,'Syntax\n------\n\nMPointFromText(wkt[,srid])\nMultiPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n\nMPointFromText() and MultiPointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nSHOW FIELDS FROM gis_multi_point;\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/mpointfromtext/','','https://mariadb.com/kb/en/mpointfromtext/'),(13,'WKT Definition',3,'Description\n-----------\n\nThe Well-Known Text (WKT) representation of Geometry is designed to exchange\ngeometry data in ASCII form. Examples of the basic geometry types include:\n\n+-----------------------------------------------------------------------------+\n| Geometry Types                                                              |\n+-----------------------------------------------------------------------------+\n| POINT                                                                       |\n+-----------------------------------------------------------------------------+\n| LINESTRING                                                                  |\n+-----------------------------------------------------------------------------+\n| POLYGON                                                                     |\n+-----------------------------------------------------------------------------+\n| MULTIPOINT                                                                  |\n+-----------------------------------------------------------------------------+\n| MULTILINESTRING                                                             |\n+-----------------------------------------------------------------------------+\n| MULTIPOLYGON                                                                |\n+-----------------------------------------------------------------------------+\n| GEOMETRYCOLLECTION                                                          |\n+-----------------------------------------------------------------------------+\n| GEOMETRY                                                                    |\n+-----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/wkt-definition/','','https://mariadb.com/kb/en/wkt-definition/'),(24,'MPolyFromText',3,'Syntax\n------\n\nMPolyFromText(wkt[,srid])\nMultiPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n\nMPolyFromText() and MultiPolygonFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_polygon  (g MULTIPOLYGON);\nSHOW FIELDS FROM gis_multi_polygon;\nINSERT INTO gis_multi_polygon VALUES\n  (MultiPolygonFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromWKB(AsWKB(MultiPolygon(Polygon(\n   LineString(Point(0, 3), Point(3, 3), Point(3, 0), Point(0, 3)))))));\n\nURL: https://mariadb.com/kb/en/mpolyfromtext/','','https://mariadb.com/kb/en/mpolyfromtext/'),(25,'MultiLineStringFromText',3,'A synonym for MLineFromText.\n\nURL: https://mariadb.com/kb/en/multilinestringfromtext/','','https://mariadb.com/kb/en/multilinestringfromtext/'),(26,'MultiPointFromText',3,'A synonym for MPointFromText.\n\nURL: https://mariadb.com/kb/en/multipointfromtext/','','https://mariadb.com/kb/en/multipointfromtext/'),(27,'MultiPolygonFromText',3,'A synonym for MPolyFromText.\n\nURL: https://mariadb.com/kb/en/multipolygonfromtext/','','https://mariadb.com/kb/en/multipolygonfromtext/'),(28,'PointFromText',3,'A synonym for ST_PointFromText.\n\nURL: https://mariadb.com/kb/en/wkt-pointfromtext/','','https://mariadb.com/kb/en/wkt-pointfromtext/'),(29,'PolyFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/wkt-polyfromtext/','','https://mariadb.com/kb/en/wkt-polyfromtext/'),(30,'PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/polygonfromtext/','','https://mariadb.com/kb/en/polygonfromtext/'),(31,'ST_AsText',3,'Syntax\n------\n\nST_AsText(g)\nAsText(g)\nST_AsWKT(g)\nAsWKT(g)\n\nDescription\n-----------\n\nConverts a value in internal geometry format to its WKT representation and\nreturns the string result.\n\nST_AsText(), AsText(), ST_AsWKT() and AsWKT() are all synonyms.\n\nExamples\n--------\n\nSET @g = \'LineString(1 1,4 4,6 6)\';\n\nSELECT ST_AsText(ST_GeomFromText(@g));\n+--------------------------------+\n| ST_AsText(ST_GeomFromText(@g)) |\n+--------------------------------+\n| LINESTRING(1 1,4 4,6 6)        |\n+--------------------------------+\n\nURL: https://mariadb.com/kb/en/st_astext/','','https://mariadb.com/kb/en/st_astext/'),(32,'ST_ASWKT',3,'A synonym for ST_ASTEXT().\n\nURL: https://mariadb.com/kb/en/st_aswkt/','','https://mariadb.com/kb/en/st_aswkt/'),(33,'ST_GeomCollFromText',3,'Syntax\n------\n\nST_GeomCollFromText(wkt[,srid])\nST_GeometryCollectionFromText(wkt[,srid])\nGeomCollFromText(wkt[,srid])\nGeometryCollectionFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and SRID.\n\nST_GeomCollFromText(), ST_GeometryCollectionFromText(), GeomCollFromText() and\nGeometryCollectionFromText() are all synonyms.\n\nExample\n-------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/st_geomcollfromtext/','','https://mariadb.com/kb/en/st_geomcollfromtext/'),(34,'ST_GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/st_geometrycollectionfromtext/','','https://mariadb.com/kb/en/st_geometrycollectionfromtext/'),(35,'ST_GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/st_geometryfromtext/','','https://mariadb.com/kb/en/st_geometryfromtext/'),(36,'ST_GeomFromText',3,'Syntax\n------\n\nST_GeomFromText(wkt[,srid])\nST_GeometryFromText(wkt[,srid])\nGeomFromText(wkt[,srid])\nGeometryFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a geometry value of any type using its WKT representation and SRID.\n\nGeomFromText(), GeometryFromText(), ST_GeomFromText() and\nST_GeometryFromText() are all synonyms.\n\nExample\n-------\n\nSET @g = ST_GEOMFROMTEXT(\'POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1 1))\');\n\nURL: https://mariadb.com/kb/en/st_geomfromtext/','','https://mariadb.com/kb/en/st_geomfromtext/'),(37,'ST_LineFromText',3,'Syntax\n------\n\nST_LineFromText(wkt[,srid])\nST_LineStringFromText(wkt[,srid])\nLineFromText(wkt[,srid])\nLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a LINESTRING value using its WKT representation and SRID.\n\nST_LineFromText(), ST_LineStringFromText(), ST_LineFromText() and\nST_LineStringFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_line  (g LINESTRING);\nSHOW FIELDS FROM gis_line;\nINSERT INTO gis_line VALUES\n  (LineFromText(\'LINESTRING(0 0,0 10,10 0)\')),\n  (LineStringFromText(\'LINESTRING(10 10,20 10,20 20,10 20,10 10)\')),\n  (LineStringFromWKB(AsWKB(LineString(Point(10, 10), Point(40, 10)))));\n\nURL: https://mariadb.com/kb/en/st_linefromtext/','','https://mariadb.com/kb/en/st_linefromtext/'),(38,'ST_LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/st_linestringfromtext/','','https://mariadb.com/kb/en/st_linestringfromtext/'),(39,'ST_PointFromText',3,'Syntax\n------\n\nST_PointFromText(wkt[,srid])\nPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POINT value using its WKT representation and SRID.\n\nST_PointFromText() and PointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_point  (g POINT);\nSHOW FIELDS FROM gis_point;\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/st_pointfromtext/','','https://mariadb.com/kb/en/st_pointfromtext/'),(40,'ST_PolyFromText',3,'Syntax\n------\n\nST_PolyFromText(wkt[,srid])\nST_PolygonFromText(wkt[,srid])\nPolyFromText(wkt[,srid])\nPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POLYGON value using its WKT representation and SRID.\n\nST_PolyFromText(), ST_PolygonFromText(), PolyFromText() and\nST_PolygonFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_polygon   (g POLYGON);\nINSERT INTO gis_polygon VALUES\n  (PolygonFromText(\'POLYGON((10 10,20 10,20 20,10 20,10 10))\')),\n  (PolyFromText(\'POLYGON((0 0,50 0,50 50,0 50,0 0), (10 10,20 10,20 20,10\n20,10 10))\'));\n\nURL: https://mariadb.com/kb/en/st_polyfromtext/','','https://mariadb.com/kb/en/st_polyfromtext/'),(41,'ST_PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/st_polygonfromtext/','','https://mariadb.com/kb/en/st_polygonfromtext/'),(42,'DIV',4,'Syntax\n------\n\nDIV\n\nDescription\n-----------\n\nInteger division. Similar to FLOOR(), but is safe with BIGINT values.\nIncorrect results may occur for non-integer operands that exceed BIGINT range.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, a division by zero produces\nan error. Otherwise, it returns NULL.\n\nThe remainder of a division can be obtained using the MOD operator.\n\nExamples\n--------\n\nSELECT 300 DIV 7;\n+-----------+\n| 300 DIV 7 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT 300 DIV 0;\n+-----------+\n| 300 DIV 0 |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/div/','','https://mariadb.com/kb/en/div/'),(43,'ABS',4,'Syntax\n------\n\nABS(X)\n\nDescription\n-----------\n\nReturns the absolute (non-negative) value of X. If X is not a number, it is\nconverted to a numeric type.\n\nExamples\n--------\n\nSELECT ABS(42);\n+---------+\n| ABS(42) |\n+---------+\n|      42 |\n+---------+\n\nSELECT ABS(-42);\n+----------+\n| ABS(-42) |\n+----------+\n|       42 |\n+----------+\n\nSELECT ABS(DATE \'1994-01-01\');\n+------------------------+\n| ABS(DATE \'1994-01-01\') |\n+------------------------+\n|               19940101 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/abs/','','https://mariadb.com/kb/en/abs/'),(44,'ACOS',4,'Syntax\n------\n\nACOS(X)\n\nDescription\n-----------\n\nReturns the arc cosine of X, that is, the value whose cosine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ACOS(1);\n+---------+\n| ACOS(1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ACOS(1.0001);\n+--------------+\n| ACOS(1.0001) |\n+--------------+\n|         NULL |\n+--------------+\n\nSELECT ACOS(0);\n+-----------------+\n| ACOS(0)         |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT ACOS(0.234);\n+------------------+\n| ACOS(0.234)      |\n+------------------+\n| 1.33460644244679 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/acos/','','https://mariadb.com/kb/en/acos/'),(45,'ASIN',4,'Syntax\n------\n\nASIN(X)\n\nDescription\n-----------\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns NULL if\nX is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ASIN(0.2);\n+--------------------+\n| ASIN(0.2)          |\n+--------------------+\n| 0.2013579207903308 |\n+--------------------+\n\nSELECT ASIN(\'foo\');\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n\nSHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n\nURL: https://mariadb.com/kb/en/asin/','','https://mariadb.com/kb/en/asin/'),(46,'ATAN',4,'Syntax\n------\n\nATAN(X)\n\nDescription\n-----------\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nExamples\n--------\n\nSELECT ATAN(2);\n+--------------------+\n| ATAN(2)            |\n+--------------------+\n| 1.1071487177940904 |\n+--------------------+\n\nSELECT ATAN(-2);\n+---------------------+\n| ATAN(-2)            |\n+---------------------+\n| -1.1071487177940904 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/atan/','','https://mariadb.com/kb/en/atan/'),(47,'ATAN2',4,'Syntax\n------\n\nATAN(Y,X), ATAN2(Y,X)\n\nDescription\n-----------\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both arguments\nare used to determine the quadrant of the result.\n\nExamples\n--------\n\nSELECT ATAN(-2,2);\n+---------------------+\n| ATAN(-2,2)          |\n+---------------------+\n| -0.7853981633974483 |\n+---------------------+\n\nSELECT ATAN2(PI(),0);\n+--------------------+\n| ATAN2(PI(),0)      |\n+--------------------+\n| 1.5707963267948966 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/atan2/','','https://mariadb.com/kb/en/atan2/'),(48,'CEIL',4,'Syntax\n------\n\nCEIL(X)\n\nDescription\n-----------\n\nCEIL() is a synonym for CEILING().\n\nURL: https://mariadb.com/kb/en/ceil/','','https://mariadb.com/kb/en/ceil/'),(49,'CEILING',4,'Syntax\n------\n\nCEILING(X)\n\nDescription\n-----------\n\nReturns the smallest integer value not less than X.\n\nExamples\n--------\n\nSELECT CEILING(1.23);\n+---------------+\n| CEILING(1.23) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT CEILING(-1.23);\n+----------------+\n| CEILING(-1.23) |\n+----------------+\n|             -1 |\n+----------------+\n\nURL: https://mariadb.com/kb/en/ceiling/','','https://mariadb.com/kb/en/ceiling/'),(51,'COS',4,'Syntax\n------\n\nCOS(X)\n\nDescription\n-----------\n\nReturns the cosine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT COS(PI());\n+-----------+\n| COS(PI()) |\n+-----------+\n|        -1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/cos/','','https://mariadb.com/kb/en/cos/'),(52,'COT',4,'Syntax\n------\n\nCOT(X)\n\nDescription\n-----------\n\nReturns the cotangent of X.\n\nExamples\n--------\n\nSELECT COT(42);\n+--------------------+\n| COT(42)            |\n+--------------------+\n| 0.4364167060752729 |\n+--------------------+\n\nSELECT COT(12);\n+---------------------+\n| COT(12)             |\n+---------------------+\n| -1.5726734063976893 |\n+---------------------+\n\nSELECT COT(0);\nERROR 1690 (22003): DOUBLE value is out of range in \'cot(0)\'\n\nURL: https://mariadb.com/kb/en/cot/','','https://mariadb.com/kb/en/cot/'),(54,'DEGREES',4,'Syntax\n------\n\nDEGREES(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from radians to degrees.\n\nThis is the converse of the RADIANS() function.\n\nExamples\n--------\n\nSELECT DEGREES(PI());\n+---------------+\n| DEGREES(PI()) |\n+---------------+\n|           180 |\n+---------------+\n\nSELECT DEGREES(PI() / 2);\n+-------------------+\n| DEGREES(PI() / 2) |\n+-------------------+\n|                90 |\n+-------------------+\n\nSELECT DEGREES(45);\n+-----------------+\n| DEGREES(45)     |\n+-----------------+\n| 2578.3100780887 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/degrees/','','https://mariadb.com/kb/en/degrees/'),(55,'EXP',4,'Syntax\n------\n\nEXP(X)\n\nDescription\n-----------\n\nReturns the value of e (the base of natural logarithms) raised to the power of\nX. The inverse of this function is LOG() (using a single argument only) or\nLN().\n\nIf X is NULL, this function returns NULL.\n\nExamples\n--------\n\nSELECT EXP(2);\n+------------------+\n| EXP(2)           |\n+------------------+\n| 7.38905609893065 |\n+------------------+\n\nSELECT EXP(-2);\n+--------------------+\n| EXP(-2)            |\n+--------------------+\n| 0.1353352832366127 |\n+--------------------+\n\nSELECT EXP(0);\n+--------+\n| EXP(0) |\n+--------+\n|      1 |\n+--------+\n\nSELECT EXP(NULL);\n+-----------+\n| EXP(NULL) |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/exp/','','https://mariadb.com/kb/en/exp/'),(50,'CONV',4,'Syntax\n------\n\nCONV(N,from_base,to_base)\n\nDescription\n-----------\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base to_base.\n\nReturns NULL if any argument is NULL, or if the second or third argument are\nnot in the allowed range.\n\nThe argument N is interpreted as an integer, but may be specified as an\ninteger or a string. The minimum base is 2 and the maximum base is 36. If\nto_base is a negative number, N is regarded as a signed number. Otherwise, N\nis treated as unsigned. CONV() works with 64-bit precision.\n\nSome shortcuts for this function are also available: BIN(), OCT(), HEX(),\nUNHEX(). Also, MariaDB allows binary literal values and hexadecimal literal\nvalues.\n\nExamples\n--------\n\nSELECT CONV(\'a\',16,2);\n+----------------+\n| CONV(\'a\',16,2) |\n+----------------+\n| 1010           |\n+----------------+\n\nSELECT CONV(\'6E\',18,8);\n+-----------------+\n| CONV(\'6E\',18,8) |\n+-----------------+\n| 172             |\n+-----------------+\n\nSELECT CONV(-17,10,-18);\n+------------------+\n| CONV(-17,10,-18) |\n+------------------+\n| -H               |\n+------------------+\n\nSELECT CONV(12+\'10\'+\'10\'+0xa,10,10);\n+------------------------------+\n| CONV(12+\'10\'+\'10\'+0xa,10,10) |\n+------------------------------+\n| 42                           |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/conv/','','https://mariadb.com/kb/en/conv/'),(53,'CRC32',4,'Syntax\n------\n\n<= MariaDB 10.7\n\nCRC32(expr)\n\nFrom MariaDB 10.8\n\nCRC32([par,]expr)\n\nDescription\n-----------\n\nComputes a cyclic redundancy check (CRC) value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is expected to\nbe a string and (if possible) is treated as one if it is not.\n\nUses the ISO 3309 polynomial that used by zlib and many others. MariaDB 10.8\nintroduced the CRC32C() function, which uses the alternate Castagnoli\npolynomia.\n\nMariaDB starting with 10.8\n--------------------------\nOften, CRC is computed in pieces. To facilitate this, MariaDB 10.8.0\nintroduced an optional parameter: CRC32(\'MariaDB\')=CRC32(CRC32(\'Maria\'),\'DB\').\n\nExamples\n--------\n\nSELECT CRC32(\'MariaDB\');\n+------------------+\n| CRC32(\'MariaDB\') |\n+------------------+\n|       4227209140 |\n+------------------+\n\nSELECT CRC32(\'mariadb\');\n+------------------+\n| CRC32(\'mariadb\') |\n+------------------+\n|       2594253378 |\n+------------------+\n\nFrom MariaDB 10.8.0\n\nSELECT CRC32(CRC32(\'Maria\'),\'DB\');\n+----------------------------+\n| CRC32(CRC32(\'Maria\'),\'DB\') |\n+----------------------------+\n|                 4227209140 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/crc32/','','https://mariadb.com/kb/en/crc32/'),(56,'FLOOR',4,'Syntax\n------\n\nFLOOR(X)\n\nDescription\n-----------\n\nReturns the largest integer value not greater than X.\n\nExamples\n--------\n\nSELECT FLOOR(1.23);\n+-------------+\n| FLOOR(1.23) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT FLOOR(-1.23);\n+--------------+\n| FLOOR(-1.23) |\n+--------------+\n|           -2 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/floor/','','https://mariadb.com/kb/en/floor/'),(57,'LN',4,'Syntax\n------\n\nLN(X)\n\nDescription\n-----------\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X. If X\nis less than or equal to 0, or NULL, then NULL is returned.\n\nThe inverse of this function is EXP().\n\nExamples\n--------\n\nSELECT LN(2);\n+-------------------+\n| LN(2)             |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LN(-2);\n+--------+\n| LN(-2) |\n+--------+\n|   NULL |\n+--------+\n\nURL: https://mariadb.com/kb/en/ln/','','https://mariadb.com/kb/en/ln/'),(58,'LOG',4,'Syntax\n------\n\nLOG(X), LOG(B,X)\n\nDescription\n-----------\n\nIf called with one parameter, this function returns the natural logarithm of\nX. If X is less than or equal to 0, then NULL is returned.\n\nIf called with two parameters, it returns the logarithm of X to the base B. If\nB is <= 1 or X <= 0, the function returns NULL.\n\nIf any argument is NULL, the function returns NULL.\n\nThe inverse of this function (when called with a single argument) is the EXP()\nfunction.\n\nExamples\n--------\n\nLOG(X):\n\nSELECT LOG(2);\n+-------------------+\n| LOG(2)            |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LOG(-2);\n+---------+\n| LOG(-2) |\n+---------+\n|    NULL |\n+---------+\n\nLOG(B,X)\n\nSELECT LOG(2,16);\n+-----------+\n| LOG(2,16) |\n+-----------+\n|         4 |\n+-----------+\n\nSELECT LOG(3,27);\n+-----------+\n| LOG(3,27) |\n+-----------+\n|         3 |\n+-----------+\n\nSELECT LOG(3,1);\n+----------+\n| LOG(3,1) |\n+----------+\n|        0 |\n+----------+\n\nSELECT LOG(3,0);\n+----------+\n| LOG(3,0) |\n+----------+\n|     NULL |\n+----------+\n\nURL: https://mariadb.com/kb/en/log/','','https://mariadb.com/kb/en/log/'),(59,'LOG10',4,'Syntax\n------\n\nLOG10(X)\n\nDescription\n-----------\n\nReturns the base-10 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG10(2);\n+-------------------+\n| LOG10(2)          |\n+-------------------+\n| 0.301029995663981 |\n+-------------------+\n\nSELECT LOG10(100);\n+------------+\n| LOG10(100) |\n+------------+\n|          2 |\n+------------+\n\nSELECT LOG10(-100);\n+-------------+\n| LOG10(-100) |\n+-------------+\n|        NULL |\n+-------------+\n\nURL: https://mariadb.com/kb/en/log10/','','https://mariadb.com/kb/en/log10/'),(60,'LOG2',4,'Syntax\n------\n\nLOG2(X)\n\nDescription\n-----------\n\nReturns the base-2 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG2(4398046511104);\n+---------------------+\n| LOG2(4398046511104) |\n+---------------------+\n|                  42 |\n+---------------------+\n\nSELECT LOG2(65536);\n+-------------+\n| LOG2(65536) |\n+-------------+\n|          16 |\n+-------------+\n\nSELECT LOG2(-100);\n+------------+\n| LOG2(-100) |\n+------------+\n|       NULL |\n+------------+\n\nURL: https://mariadb.com/kb/en/log2/','','https://mariadb.com/kb/en/log2/'),(62,'OCT',4,'Syntax\n------\n\nOCT(N)\n\nDescription\n-----------\n\nReturns a string representation of the octal value of N, where N is a longlong\n(BIGINT) number. This is equivalent to CONV(N,10,8). Returns NULL if N is NULL.\n\nExamples\n--------\n\nSELECT OCT(34);\n+---------+\n| OCT(34) |\n+---------+\n| 42      |\n+---------+\n\nSELECT OCT(12);\n+---------+\n| OCT(12) |\n+---------+\n| 14      |\n+---------+\n\nURL: https://mariadb.com/kb/en/oct/','','https://mariadb.com/kb/en/oct/'),(63,'PI',4,'Syntax\n------\n\nPI()\n\nDescription\n-----------\n\nReturns the value of π (pi). The default number of decimal places displayed is\nsix, but MariaDB uses the full double-precision value internally.\n\nExamples\n--------\n\nSELECT PI();\n+----------+\n| PI()     |\n+----------+\n| 3.141593 |\n+----------+\n\nSELECT PI()+0.0000000000000000000000;\n+-------------------------------+\n| PI()+0.0000000000000000000000 |\n+-------------------------------+\n|      3.1415926535897931159980 |\n+-------------------------------+\n\nURL: https://mariadb.com/kb/en/pi/','','https://mariadb.com/kb/en/pi/'),(64,'POW',4,'Syntax\n------\n\nPOW(X,Y)\n\nDescription\n-----------\n\nReturns the value of X raised to the power of Y.\n\nPOWER() is a synonym.\n\nExamples\n--------\n\nSELECT POW(2,3);\n+----------+\n| POW(2,3) |\n+----------+\n|        8 |\n+----------+\n\nSELECT POW(2,-2);\n+-----------+\n| POW(2,-2) |\n+-----------+\n|      0.25 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/pow/','','https://mariadb.com/kb/en/pow/'),(65,'POWER',4,'Syntax\n------\n\nPOWER(X,Y)\n\nDescription\n-----------\n\nThis is a synonym for POW(), which returns the value of X raised to the power\nof Y.\n\nURL: https://mariadb.com/kb/en/power/','','https://mariadb.com/kb/en/power/'),(61,'MOD',4,'Syntax\n------\n\nMOD(N,M), N % M, N MOD M\n\nDescription\n-----------\n\nModulo operation. Returns the remainder of N divided by M. See also Modulo\nOperator.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, any number modulus zero\nproduces an error. Otherwise, it returns NULL.\n\nThe integer part of a division can be obtained using DIV.\n\nExamples\n--------\n\nSELECT 1042 % 50;\n+-----------+\n| 1042 % 50 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT MOD(234, 10);\n+--------------+\n| MOD(234, 10) |\n+--------------+\n|            4 |\n+--------------+\n\nSELECT 253 % 7;\n+---------+\n| 253 % 7 |\n+---------+\n|       1 |\n+---------+\n\nSELECT MOD(29,9);\n+-----------+\n| MOD(29,9) |\n+-----------+\n|         2 |\n+-----------+\n\nSELECT 29 MOD 9;\n+----------+\n| 29 MOD 9 |\n+----------+\n|        2 |\n+----------+\n\nURL: https://mariadb.com/kb/en/mod/','','https://mariadb.com/kb/en/mod/'),(66,'RADIANS',4,'Syntax\n------\n\nRADIANS(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from degrees to radians. Note that π radians\nequals 180 degrees.\n\nThis is the converse of the DEGREES() function.\n\nExamples\n--------\n\nSELECT RADIANS(45);\n+-------------------+\n| RADIANS(45)       |\n+-------------------+\n| 0.785398163397448 |\n+-------------------+\n\nSELECT RADIANS(90);\n+-----------------+\n| RADIANS(90)     |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT RADIANS(PI());\n+--------------------+\n| RADIANS(PI())      |\n+--------------------+\n| 0.0548311355616075 |\n+--------------------+\n\nSELECT RADIANS(180);\n+------------------+\n| RADIANS(180)     |\n+------------------+\n| 3.14159265358979 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/radians/','','https://mariadb.com/kb/en/radians/'),(67,'RAND',4,'Syntax\n------\n\nRAND(), RAND(N)\n\nDescription\n-----------\n\nReturns a random DOUBLE precision floating point value v in the range 0 <= v <\n1.0. If a constant integer argument N is specified, it is used as the seed\nvalue, which produces a repeatable sequence of column values. In the example\nbelow, note that the sequences of values produced by RAND(3) is the same both\nplaces where it occurs.\n\nIn a WHERE clause, RAND() is evaluated each time the WHERE is executed.\n\nStatements using the RAND() function are not safe for statement-based\nreplication.\n\nPractical uses\n--------------\n\nThe expression to get a random integer from a given range is the following:\n\nFLOOR(min_value + RAND() * (max_value - min_value +1))\n\nRAND() is often used to read random rows from a table, as follows:\n\nSELECT * FROM my_table ORDER BY RAND() LIMIT 10;\n\nNote, however, that this technique should never be used on a large table as it\nwill be extremely slow. MariaDB will read all rows in the table, generate a\nrandom value for each of them, order them, and finally will apply the LIMIT\nclause.\n\nExamples\n--------\n\nCREATE TABLE t (i INT);\n\nINSERT INTO t VALUES(1),(2),(3);\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.255651095188829 |\n|    2 | 0.833920199269355 |\n|    3 |  0.40264774151393 |\n+------+-------------------+\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.511478140495232 |\n|    2 | 0.349447508668012 |\n|    3 | 0.212803152588013 |\n+------+-------------------+\n\nUsing the same seed, the same sequence will be returned:\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nGenerating a random number from 5 to 15:\n\nSELECT FLOOR(5 + (RAND() * 11));\n\nURL: https://mariadb.com/kb/en/rand/','','https://mariadb.com/kb/en/rand/'),(68,'ROUND',4,'Syntax\n------\n\nROUND(X), ROUND(X,D)\n\nDescription\n-----------\n\nRounds the argument X to D decimal places. D defaults to 0 if not specified. D\ncan be negative to cause D digits left of the decimal point of the value X to\nbecome zero.\n\nThe rounding algorithm depends on the data type of X:\n\n* for floating point types (FLOAT, DOUBLE) the C libraries rounding function\nis used, so the behavior *may* differ between operating systems\n* for fixed point types (DECIMAL, DEC/NUMBER/FIXED) the \"round half up\" rule\nis used, meaning that e.g. a value ending in exactly .5 is always rounded up.\n\nExamples\n--------\n\nSELECT ROUND(-1.23);\n+--------------+\n| ROUND(-1.23) |\n+--------------+\n|           -1 |\n+--------------+\n\nSELECT ROUND(-1.58);\n+--------------+\n| ROUND(-1.58) |\n+--------------+\n|           -2 |\n+--------------+\n\nSELECT ROUND(1.58); \n+-------------+\n| ROUND(1.58) |\n+-------------+\n|           2 |\n+-------------+\n\nSELECT ROUND(1.298, 1);\n+-----------------+\n| ROUND(1.298, 1) |\n+-----------------+\n|             1.3 |\n+-----------------+\n\nSELECT ROUND(1.298, 0);\n+-----------------+\n| ROUND(1.298, 0) |\n+-----------------+\n|               1 |\n+-----------------+\n\nSELECT ROUND(23.298, -1);\n+-------------------+\n| ROUND(23.298, -1) |\n+-------------------+\n|                20 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/round/','','https://mariadb.com/kb/en/round/'),(69,'SIGN',4,'Syntax\n------\n\nSIGN(X)\n\nDescription\n-----------\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X is\nnegative, zero, or positive.\n\nExamples\n--------\n\nSELECT SIGN(-32);\n+-----------+\n| SIGN(-32) |\n+-----------+\n|        -1 |\n+-----------+\n\nSELECT SIGN(0);\n+---------+\n| SIGN(0) |\n+---------+\n|       0 |\n+---------+\n\nSELECT SIGN(234);\n+-----------+\n| SIGN(234) |\n+-----------+\n|         1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/sign/','','https://mariadb.com/kb/en/sign/'),(70,'SIN',4,'Syntax\n------\n\nSIN(X)\n\nDescription\n-----------\n\nReturns the sine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT SIN(1.5707963267948966);\n+-------------------------+\n| SIN(1.5707963267948966) |\n+-------------------------+\n|                       1 |\n+-------------------------+\n\nSELECT SIN(PI());\n+----------------------+\n| SIN(PI())            |\n+----------------------+\n| 1.22460635382238e-16 |\n+----------------------+\n\nSELECT ROUND(SIN(PI()));\n+------------------+\n| ROUND(SIN(PI())) |\n+------------------+\n|                0 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/sin/','','https://mariadb.com/kb/en/sin/'),(71,'SQRT',4,'Syntax\n------\n\nSQRT(X)\n\nDescription\n-----------\n\nReturns the square root of X. If X is negative, NULL is returned.\n\nExamples\n--------\n\nSELECT SQRT(4);\n+---------+\n| SQRT(4) |\n+---------+\n|       2 |\n+---------+\n\nSELECT SQRT(20);\n+------------------+\n| SQRT(20)         |\n+------------------+\n| 4.47213595499958 |\n+------------------+\n\nSELECT SQRT(-16);\n+-----------+\n| SQRT(-16) |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT SQRT(1764);\n+------------+\n| SQRT(1764) |\n+------------+\n|         42 |\n+------------+\n\nURL: https://mariadb.com/kb/en/sqrt/','','https://mariadb.com/kb/en/sqrt/'),(72,'TAN',4,'Syntax\n------\n\nTAN(X)\n\nDescription\n-----------\n\nReturns the tangent of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT TAN(0.7853981633974483);\n+-------------------------+\n| TAN(0.7853981633974483) |\n+-------------------------+\n|      0.9999999999999999 |\n+-------------------------+\n\nSELECT TAN(PI());\n+-----------------------+\n| TAN(PI())             |\n+-----------------------+\n| -1.22460635382238e-16 |\n+-----------------------+\n\nSELECT TAN(PI()+1);\n+-----------------+\n| TAN(PI()+1)     |\n+-----------------+\n| 1.5574077246549 |\n+-----------------+\n\nSELECT TAN(RADIANS(PI()));\n+--------------------+\n| TAN(RADIANS(PI())) |\n+--------------------+\n| 0.0548861508080033 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/tan/','','https://mariadb.com/kb/en/tan/'),(73,'TRUNCATE',4,'This page documents the TRUNCATE function. See TRUNCATE TABLE for the DDL\nstatement.\n\nSyntax\n------\n\nTRUNCATE(X,D)\n\nDescription\n-----------\n\nReturns the number X, truncated to D decimal places. If D is 0, the result has\nno decimal point or fractional part. D can be negative to cause D digits left\nof the decimal point of the value X to become zero.\n\nExamples\n--------\n\nSELECT TRUNCATE(1.223,1);\n+-------------------+\n| TRUNCATE(1.223,1) |\n+-------------------+\n|               1.2 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,1);\n+-------------------+\n| TRUNCATE(1.999,1) |\n+-------------------+\n|               1.9 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,0); \n+-------------------+\n| TRUNCATE(1.999,0) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSELECT TRUNCATE(-1.999,1);\n+--------------------+\n| TRUNCATE(-1.999,1) |\n+--------------------+\n|               -1.9 |\n+--------------------+\n\nSELECT TRUNCATE(122,-2);\n+------------------+\n| TRUNCATE(122,-2) |\n+------------------+\n|              100 |\n+------------------+\n\nSELECT TRUNCATE(10.28*100,0);\n+-----------------------+\n| TRUNCATE(10.28*100,0) |\n+-----------------------+\n|                  1028 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/truncate/','','https://mariadb.com/kb/en/truncate/'),(74,'INSTALL PLUGIN',5,'Syntax\n------\n\nINSTALL PLUGIN [IF NOT EXISTS] plugin_name SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement installs an individual plugin from the specified library. To\ninstall the whole library (which could be required), use INSTALL SONAME. See\nalso Installing a Plugin.\n\nplugin_name is the name of the plugin as defined in the plugin declaration\nstructure contained in the library file. Plugin names are not case sensitive.\nFor maximal compatibility, plugin names should be limited to ASCII letters,\ndigits, and underscore, because they are used in C source files, shell command\nlines, M4 and Bourne shell scripts, and SQL environments.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension can be omitted (which makes the statement look\nthe same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL PLUGIN adds a line to the mysql.plugin table that describes the\nplugin. This table contains the plugin name and library file name.\n\nINSTALL PLUGIN causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL PLUGIN also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL PLUGIN, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nPLUGIN only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a note instead of\nan error if the specified plugin already exists. See SHOW WARNINGS.\n\nExamples\n--------\n\nINSTALL PLUGIN sphinx SONAME \'ha_sphinx.so\';\n\nThe extension can also be omitted:\n\nINSTALL PLUGIN innodb SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected (0.104 sec)\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+------------------------------------+\n| Level | Code | Message                            |\n+-------+------+------------------------------------+\n| Note  | 1968 | Plugin \'example\' already installed |\n+-------+------+------------------------------------+\n\nURL: https://mariadb.com/kb/en/install-plugin/','','https://mariadb.com/kb/en/install-plugin/'),(78,'Plugin Overview',5,'Plugins are server components that enhance MariaDB in some way. These can be\nanything from new storage engines, plugins for enhancing full-text parsing, or\neven small enhancements, such as a plugin to get a timestamp as an integer.\n\nQuerying Plugin Information\n---------------------------\n\nThere are a number of ways to see which plugins are currently active.\n\nA server almost always has a large number of active plugins, because the\nserver contains a large number of built-in plugins, which are active by\ndefault and cannot be uninstalled.\n\nQuerying Plugin Information with SHOW PLUGINS\n---------------------------------------------\n\nThe SHOW PLUGINS statement can be used to query information about all active\nplugins.\n\nFor example:\n\nSHOW PLUGINS\\G;\n********************** 1. row **********************\n Name: binlog\n Status: ACTIVE\n Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n********************** 2. row **********************\n Name: mysql_native_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n********************** 3. row **********************\n Name: mysql_old_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n...\n\nIf a plugin\'s Library column has a NULL value, then the plugin is built-in,\nand it cannot be uninstalled.\n\nQuerying Plugin Information with information_schema.PLUGINS\n-----------------------------------------------------------\n\nThe information_schema.PLUGINS table can be queried to get more detailed\ninformation about plugins.\n\nFor example:\n\nSELECT * FROM information_schema.PLUGINS\\G\n...\n*************************** 6. row ***************************\n     PLUGIN_NAME: CSV\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: Brian Aker, MySQL AB\n  PLUGIN_DESCRIPTION: CSV storage engine\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n*************************** 7. row ***************************\n     PLUGIN_NAME: MEMORY\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: MySQL AB\n  PLUGIN_DESCRIPTION: Hash based, stored in memory, useful for temporary\ntables\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n...\n\nIf a plugin\'s PLUGIN_LIBRARY column has the NULL value, then the plugin is\nbuilt-in, and it cannot be uninstalled.\n\nQuerying Plugin Information with mysql.plugin\n---------------------------------------------\n\nThe mysql.plugin table can be queried to get information about installed\nplugins.\n\nThis table only contains information about plugins that have been installed\nvia the following methods:\n\n* The INSTALL SONAME statement.\n* The INSTALL PLUGIN statement.\n* The mysql_plugin utility.\n\nThis table does not contain information about:\n\n* Built-in plugins.\n* Plugins loaded with the --plugin-load-add option.\n* Plugins loaded with the --plugin-load option.\n\nThis table only contains enough information to reload the plugin when the\nserver is restarted, which means it only contains the plugin name and the\nplugin library.\n\nFor example:\n\nSELECT * FROM mysql.plugin;\n\n+------+------------+\n| name | dl         |\n+------+------------+\n| PBXT | libpbxt.so |\n+------+------------+\n\nInstalling a Plugin\n-------------------\n\nThere are three primary ways to install a plugin:\n\n* A plugin can be installed dynamically with an SQL statement.\n* A plugin can be installed with a mysqld option, but it requires a server\nrestart.\n* A plugin can be installed with the mysql_plugin utility, while the server is\ncompletely offline.\n\nWhen you are installing a plugin, you also have to ensure that:\n\n* The server\'s plugin directory is properly configured, and the plugin\'s\nlibrary is in the plugin directory.\n* The server\'s minimum plugin maturity is properly configured, and the plugin\nis mature enough to be installed.\n\nInstalling a Plugin Dynamically\n-------------------------------\n\nA plugin can be installed dynamically by executing either the INSTALL SONAME\nor the INSTALL PLUGIN statement.\n\nIf a plugin is installed with one of these statements, then a record will be\nadded to the mysql.plugins table for the plugin. This means that the plugin\nwill automatically be loaded every time the server restarts, unless\nspecifically uninstalled or deactivated.\n\nInstalling a Plugin with INSTALL SONAME\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL SONAME\nstatement. INSTALL SONAME installs all plugins from the given plugin library.\nThis could be required for some plugin libraries.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin), you could execute the\nfollowing:\n\nINSTALL SONAME \'server_audit\';\n\nInstalling a Plugin with INSTALL PLUGIN\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL PLUGIN\nstatement. INSTALL PLUGIN installs a single plugin from the given plugin\nlibrary.\n\nFor example, to install the server_audit audit plugin from the server_audit\nplugin library, you could execute the following:\n\nINSTALL PLUGIN server_audit SONAME \'server_audit\';\n\nInstalling a Plugin with Plugin Load Options\n--------------------------------------------\n\nA plugin can be installed with a mysqld option by providing either the\n--plugin-load-add or the --plugin-load option.\n\nIf a plugin is installed with one of these options, then a record will not be\nadded to the mysql.plugins table for the plugin. This means that if the server\nis restarted without the same option set, then the plugin will not\nautomatically be loaded.\n\nInstalling a Plugin with --plugin-load-add\n------------------------------------------\n\nYou can install a plugin with the --plugin-load-add option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load-add option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load-add=\'server_audit\'\n--plugin-load-add=\'ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nSpecial care must be taken when specifying both the --plugin-load option and\nthe --plugin-load-add option together. The --plugin-load option resets the\nplugin load list, and this can cause unexpected problems if you are not aware.\nThe --plugin-load-add option does not reset the plugin load list, so it is\nmuch safer to use. See Specifying Multiple Plugin Load Options for more\ninformation.\n\nInstalling a Plugin with --plugin-load\n--------------------------------------\n\nYou can install a plugin with the --plugin-load option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load=\'server_audit;ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load = server_audit;ed25519=auth_ed25519\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option together. The --plugin-load option resets the plugin\nload list, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use. See Specifying Multiple Plugin Load Options for more information.\n\nSpecifying Multiple Plugin Load Options\n---------------------------------------\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option. The --plugin-load option resets the plugin load\nlist, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use.\n\nThis can have the following consequences:\n\n* If the --plugin-load option is specified multiple times, then only the last\ninstance will have any effect. For example, in the following case, the first\ninstance of the option is reset:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* If the --plugin-load option is specified after the --plugin-load-add option,\nthen it will also reset the changes made by that option. For example, in the\nfollowing case, the --plugin-load-add option does not do anything, because the\nsubsequent --plugin-load option resets the plugin load list:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* In contrast, if the --plugin-load option is specified before the\n--plugin-load-add option, then it will work fine, because the\n--plugin-load-add option does not reset the plugin load list. For example, in\nthe following case, both plugins are properly loaded:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nInstalling a Plugin with mysql_plugin\n-------------------------------------\n\nA plugin can be installed with the mysql_plugin utility if the server is\ncompletely offline.\n\nThe syntax is:\n\nmysql_plugin [options] <plugin> ENABLE|DISABLE\n\nFor example, to install the server_audit audit plugin, you could execute the\nfollowing:\n\nmysql_plugin server_audit ENABLE\n\nIf a plugin is installed with this utility, then a record will be added to the\nmysql.plugins table for the plugin. This means that the plugin will\nautomatically be loaded every time the server restarts, unless specifically\nuninstalled or deactivated.\n\nConfiguring the Plugin Directory\n--------------------------------\n\nWhen a plugin is being installed, the server looks for the plugin\'s library in\nthe server\'s plugin directory. This directory is configured by the plugin_dir\nsystem variable. This can be specified as a command-line argument to mysqld or\nit can be specified in a relevant server option group in an option file. For\nexample:\n\n[mariadb]\n...\nplugin_dir = /usr/lib64/mysql/plugin\n\nConfiguring the Minimum Plugin Maturity\n---------------------------------------\n\nWhen a plugin is being installed, the server compares the plugin\'s maturity\nlevel against the server\'s minimum allowed plugin maturity. This can help\nprevent users from using unstable plugins on production servers. This minimum\nplugin maturity is configured by the plugin_maturity system variable. This can\nbe specified as a command-line argument to mysqld or it can be specified in a\nrelevant server option group in an option file. For example:\n\n[mariadb]\n...\nplugin_maturity = stable\n\nConfiguring Plugin Activation at Server Startup\n-----------------------------------------------\n\nA plugin will be loaded by default when the server starts if:\n\n* The plugin was installed with the INSTALL SONAME statement.\n* The plugin was installed with the INSTALL PLUGIN statement.\n* The plugin was installed with the mysql_plugin utility.\n* The server is configured to load the plugin with the --plugin-load-add\noption.\n* The server is configured to load the plugin with the --plugin-load option.\n\nThis behavior can be changed with special options that take the form\n--plugin-name. For example, for the server_audit audit plugin, the special\noption is called --server-audit.\n\nThe possible values for these special options are:\n\n+---------------------------------------+------------------------------------+\n| Option Value                          | Description                        |\n+---------------------------------------+------------------------------------+\n| OFF                                   | Disables the plugin without        |\n|                                       | removing it from the               |\n|                                       | mysql.plugins table.               |\n+---------------------------------------+------------------------------------+\n| ON                                    | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will still continue         |\n|                                       | starting up, but the plugin will   |\n|                                       | be disabled.                       |\n+---------------------------------------+------------------------------------+\n| FORCE                                 | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error.                             |\n+---------------------------------------+------------------------------------+\n| FORCE_PLUS_PERMANENT                  | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error. In addition, the plugin     |\n|                                       | cannot be uninstalled with         |\n|                                       | UNINSTALL SONAME or UNINSTALL      |\n|                                       | PLUGIN while the server is         |\n|                                       | running.                           |\n+---------------------------------------+------------------------------------+\n\nA plugin\'s status can be found by looking at the PLUGIN_STATUS column of the\ninformation_schema.PLUGINS table.\n\nUninstalling Plugins\n--------------------\n\nPlugins that are found in the mysql.plugin table, that is those that were\ninstalled with INSTALL SONAME, INSTALL PLUGIN or mysql_plugin can be\nuninstalled in one of two ways:\n\n* The UNINSTALL SONAME or the UNINSTALL PLUGIN statement while the server is\nrunning\n* With mysql_plugin while the server is offline.\n\nPlugins that were enabled as a --plugin-load option do not need to be\nuninstalled. If --plugin-load is omitted the next time the server starts, or\nthe plugin is not listed as one of the --plugin-load entries, the plugin will\nnot be loaded.\n\nUNINSTALL PLUGIN uninstalls a single installed plugin, while UNINSTALL SONAME\nuninstalls all plugins belonging to a given library.\n\nURL: https://mariadb.com/kb/en/plugin-overview/','','https://mariadb.com/kb/en/plugin-overview/'),(79,'MBR Definition',6,'Description\n-----------\n\nThe MBR (Minimum Bounding Rectangle), or Envelope is the bounding geometry,\nformed by the minimum and maximum (X,Y) coordinates:\n\nExamples\n--------\n\n((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n\nURL: https://mariadb.com/kb/en/mbr-definition/','','https://mariadb.com/kb/en/mbr-definition/'),(80,'MBRContains',6,'Syntax\n------\n\nMBRContains(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1\ncontains the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRWithin().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\n\nSET @g2 = GeomFromText(\'Point(1 1)\');\n\nSELECT MBRContains(@g1,@g2), MBRContains(@g2,@g1);\n+----------------------+----------------------+\n| MBRContains(@g1,@g2) | MBRContains(@g2,@g1) |\n+----------------------+----------------------+\n|                    1 |                    0 |\n+----------------------+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrcontains/','','https://mariadb.com/kb/en/mbrcontains/'),(82,'MBREqual',6,'Syntax\n------\n\nMBREqual(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are the same.\n\nExamples\n--------\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 2)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 2, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 3)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 4, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 0 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/mbrequal/','','https://mariadb.com/kb/en/mbrequal/'),(86,'MBRWithin',6,'Syntax\n------\n\nMBRWithin(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1 is\nwithin the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRContains().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((0 0,0 5,5 5,5 0,0 0))\');\nSELECT MBRWithin(@g1,@g2), MBRWithin(@g2,@g1);\n+--------------------+--------------------+\n| MBRWithin(@g1,@g2) | MBRWithin(@g2,@g1) |\n+--------------------+--------------------+\n|                  1 |                  0 |\n+--------------------+--------------------+\n\nURL: https://mariadb.com/kb/en/mbrwithin/','','https://mariadb.com/kb/en/mbrwithin/'),(75,'UNINSTALL PLUGIN',5,'Syntax\n------\n\nUNINSTALL PLUGIN [IF EXISTS] plugin_name\n\nDescription\n-----------\n\nThis statement removes a single installed plugin. To uninstall the whole\nlibrary which contains the plugin, use UNINSTALL SONAME. You cannot uninstall\na plugin if any table that uses it is open.\n\nplugin_name must be the name of some plugin that is listed in the mysql.plugin\ntable. The server executes the plugin\'s deinitialization function and removes\nthe row for the plugin from the mysql.plugin table, so that subsequent server\nrestarts will not load and initialize the plugin. UNINSTALL PLUGIN does not\nremove the plugin\'s shared library file.\n\nTo use UNINSTALL PLUGIN, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nUNINSTALL PLUGIN example;\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------+\n| Level | Code | Message                       |\n+-------+------+-------------------------------+\n| Note  | 1305 | PLUGIN example does not exist |\n+-------+------+-------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-plugin/','','https://mariadb.com/kb/en/uninstall-plugin/'),(76,'INSTALL SONAME',5,'Syntax\n------\n\nINSTALL SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of INSTALL PLUGIN. It installs all plugins from a\ngiven plugin_library. See INSTALL PLUGIN for details.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL SONAME adds one or more lines to the mysql.plugin table that describes\nthe plugin. This table contains the plugin name and library file name.\n\nINSTALL SONAME causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL SONAME also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL SONAME, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nSONAME only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nIf you need to install only one plugin from a library, use the INSTALL PLUGIN\nstatement.\n\nExamples\n--------\n\nTo load the XtraDB storage engine and all of its information_schema tables\nwith one statement, use\n\nINSTALL SONAME \'ha_xtradb\';\n\nThis statement can be used instead of INSTALL PLUGIN even when the library\ncontains only one plugin:\n\nINSTALL SONAME \'ha_sequence\';\n\nURL: https://mariadb.com/kb/en/install-soname/','','https://mariadb.com/kb/en/install-soname/'),(77,'UNINSTALL SONAME',5,'Syntax\n------\n\nUNINSTALL SONAME  [IF EXISTS] \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of UNINSTALL PLUGIN statement, that removes all\nplugins belonging to a specified plugin_library. See UNINSTALL PLUGIN for\ndetails.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nTo use UNINSTALL SONAME, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin library does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nTo uninstall the XtraDB plugin and all of its information_schema tables with\none statement, use\n\nUNINSTALL SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------------+\n| Level | Code | Message                             |\n+-------+------+-------------------------------------+\n| Note  | 1305 | SONAME ha_example.so does not exist |\n+-------+------+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-soname/','','https://mariadb.com/kb/en/uninstall-soname/'),(90,'NULLIF',7,'Syntax\n------\n\nNULLIF(expr1,expr2)\n\nDescription\n-----------\n\nReturns NULL if expr1 = expr2 is true, otherwise returns expr1. This is the\nsame as CASE WHEN expr1 = expr2 THEN NULL ELSE expr1 END.\n\nExamples\n--------\n\nSELECT NULLIF(1,1);\n+-------------+\n| NULLIF(1,1) |\n+-------------+\n|        NULL |\n+-------------+\n\nSELECT NULLIF(1,2);\n+-------------+\n| NULLIF(1,2) |\n+-------------+\n|           1 |\n+-------------+\n\nURL: https://mariadb.com/kb/en/nullif/','','https://mariadb.com/kb/en/nullif/'),(91,'NVL',7,'MariaDB starting with 10.3\n--------------------------\nFrom MariaDB 10.3, NVL is a synonym for IFNULL.\n\nURL: https://mariadb.com/kb/en/nvl/','','https://mariadb.com/kb/en/nvl/'),(92,'NVL2',7,'MariaDB starting with 10.3\n--------------------------\nThe NLV2 function was introduced in MariaDB 10.3.0.\n\nSyntax\n------\n\nNVL2(expr1,expr2,expr3)\n\nDescription\n-----------\n\nThe NVL2 function returns a value based on whether a specified expression is\nNULL or not. If expr1 is not NULL, then NVL2 returns expr2. If expr1 is NULL,\nthen NVL2 returns expr3.\n\nExamples\n--------\n\nSELECT NVL2(NULL,1,2);\n+----------------+\n| NVL2(NULL,1,2) |\n+----------------+\n|              2 |\n+----------------+\n\nSELECT NVL2(\'x\',1,2);\n+---------------+\n| NVL2(\'x\',1,2) |\n+---------------+\n|             1 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/nvl2/','','https://mariadb.com/kb/en/nvl2/'),(81,'MBRDisjoint',6,'Syntax\n------\n\nMBRDisjoint(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are disjoint. Two geometries are disjoint if they do not\nintersect, that is touch or overlap.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECTmbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrdisjoint/','','https://mariadb.com/kb/en/mbrdisjoint/'),(83,'MBRIntersects',6,'Syntax\n------\n\nMBRIntersects(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 intersect.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      1 |\n+------------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      0 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/mbrintersects/','','https://mariadb.com/kb/en/mbrintersects/'),(84,'MBROverlaps',6,'Syntax\n------\n\nMBROverlaps(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 overlap. The term spatially overlaps is used if two\ngeometries intersect and their intersection results in a geometry of the same\ndimension but not equal to either of the given geometries.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbroverlaps/','','https://mariadb.com/kb/en/mbroverlaps/'),(85,'MBRTouches',6,'Syntax\n------\n\nMBRTouches(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 touch. Two geometries spatially touch if the interiors of\nthe geometries do not intersect, but the boundary of one of the geometries\nintersects either the boundary or the interior of the other.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   1 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/mbrtouches/','','https://mariadb.com/kb/en/mbrtouches/'),(87,'CASE OPERATOR',7,'Syntax\n------\n\nCASE value WHEN [compare_value] THEN result [WHEN [compare_value] THEN\nresult ...] [ELSE result] END\n\nCASE WHEN [condition] THEN result [WHEN [condition] THEN result ...]\n[ELSE result] END\n\nDescription\n-----------\n\nThe first version returns the result where value=compare_value. The second\nversion returns the result for the first condition that is true. If there was\nno matching result value, the result after ELSE is returned, or NULL if there\nis no ELSE part.\n\nThere is also a CASE statement, which differs from the CASE operator described\nhere.\n\nExamples\n--------\n\nSELECT CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END;\n+------------------------------------------------------------+\n| CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END |\n+------------------------------------------------------------+\n| one                                                        |\n+------------------------------------------------------------+\n\nSELECT CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END;\n+--------------------------------------------+\n| CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END |\n+--------------------------------------------+\n| true                                       |\n+--------------------------------------------+\n\nSELECT CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END;\n+-----------------------------------------------------+\n| CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END |\n+-----------------------------------------------------+\n|                                                NULL |\n+-----------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/case-operator/','','https://mariadb.com/kb/en/case-operator/'),(101,'UNLOCK TABLES',8,'Syntax\n------\n\nUNLOCK TABLES\n\nDescription\n-----------\n\nUNLOCK TABLES explicitly releases any table locks held by the current session.\nSee LOCK TABLES for more information.\n\nIn addition to releasing table locks acquired by the LOCK TABLES statement,\nthe UNLOCK TABLES statement also releases the global read lock acquired by the\nFLUSH TABLES WITH READ LOCK statement. The FLUSH TABLES WITH READ LOCK\nstatement is very useful for performing backups. See FLUSH for more\ninformation about FLUSH TABLES WITH READ LOCK.\n\nURL: https://mariadb.com/kb/en/transactions-unlock-tables/','','https://mariadb.com/kb/en/transactions-unlock-tables/'),(103,'XA Transactions',8,'Overview\n--------\n\nThe MariaDB XA implementation is based on the X/Open CAE document Distributed\nTransaction Processing: The XA Specification. This document is published by\nThe Open Group and available at\nhttp://www.opengroup.org/public/pubs/catalog/c193.htm.\n\nXA transactions are designed to allow distributed transactions, where a\ntransaction manager (the application) controls a transaction which involves\nmultiple resources. Such resources are usually DBMSs, but could be resources\nof any type. The whole set of required transactional operations is called a\nglobal transaction. Each subset of operations which involve a single resource\nis called a local transaction. XA used a 2-phases commit (2PC). With the first\ncommit, the transaction manager tells each resource to prepare an effective\ncommit, and waits for a confirm message. The changes are not still made\neffective at this point. If any of the resources encountered an error, the\ntransaction manager will rollback the global transaction. If all resources\ncommunicate that the first commit is successful, the transaction manager can\nrequire a second commit, which makes the changes effective.\n\nIn MariaDB, XA transactions can only be used with storage engines that support\nthem. At least InnoDB, TokuDB, SPIDER and MyRocks support them. For InnoDB,\nuntil MariaDB 10.2, XA transactions can be disabled by setting the\ninnodb_support_xa server system variable to 0. From MariaDB 10.3, XA\ntransactions are always supported.\n\nLike regular transactions, XA transactions create metadata locks on accessed\ntables.\n\nXA transactions require REPEATABLE READ as a minimum isolation level. However,\ndistributed transactions should always use SERIALIZABLE.\n\nTrying to start more than one XA transaction at the same time produces a 1400\nerror (SQLSTATE \'XAE09\'). The same error is produced when attempting to start\nan XA transaction while a regular transaction is in effect. Trying to start a\nregular transaction while an XA transaction is in effect produces a 1399 error\n(SQLSTATE \'XAE07\').\n\nThe statements that cause an implicit COMMIT for regular transactions produce\na 1400 error (SQLSTATE \'XAE09\') if a XA transaction is in effect.\n\nInternal XA vs External XA\n--------------------------\n\nXA transactions are an overloaded term in MariaDB. If a storage engine is\nXA-capable, it can mean one or both of these:\n\n* It supports MariaDB\'s internal two-phase commit API. This is transparent to\nthe user. Sometimes this is called \"internal XA\", since MariaDB\'s internal\ntransaction coordinator log can handle coordinating these transactions.\n\n* It supports XA transactions, with the XA START, XA PREPARE, XA COMMIT, etc.\nstatements. Sometimes this is called \"external XA\", since it requires the use\nof an external transaction coordinator to use this feature properly.\n\nTransaction Coordinator Log\n---------------------------\n\nIf you have two or more XA-capable storage engines enabled, then a transaction\ncoordinator log must be available.\n\nThere are currently two implementations of the transaction coordinator log:\n\n* Binary log-based transaction coordinator log\n* Memory-mapped file-based transaction coordinator log\n\nIf the binary log is enabled on a server, then the server will use the binary\nlog-based transaction coordinator log. Otherwise, it will use the\nmemory-mapped file-based transaction coordinator log.\n\nSee Transaction Coordinator Log for more information.\n\nSyntax\n------\n\nXA {START|BEGIN} xid [JOIN|RESUME]\n\nXA END xid [SUSPEND [FOR MIGRATE]]\n\nXA PREPARE xid\n\nXA COMMIT xid [ONE PHASE]\n\nXA ROLLBACK xid\n\nXA RECOVER [FORMAT=[\'RAW\'|\'SQL\']]\n\nxid: gtrid [, bqual [, formatID ]]\n\nThe interface to XA transactions is a set of SQL statements starting with XA.\nEach statement changes a transaction\'s state, determining which actions it can\nperform. A transaction which does not exist is in the NON-EXISTING state.\n\nXA START (or BEGIN) starts a transaction and defines its xid (a transaction\nidentifier). The JOIN or RESUME keywords have no effect. The new transaction\nwill be in ACTIVE state.\n\nThe xid can have 3 components, though only the first one is mandatory. gtrid\nis a quoted string representing a global transaction identifier. bqual is a\nquoted string representing a local transaction identifier. formatID is an\nunsigned integer indicating the format used for the first two components; if\nnot specified, defaults to 1. MariaDB does not interpret in any way these\ncomponents, and only uses them to identify a transaction. xids of transactions\nin effect must be unique.\n\nXA END declares that the specified ACTIVE transaction is finished and it\nchanges its state to IDLE. SUSPEND [FOR MIGRATE] has no effect.\n\nXA PREPARE prepares an IDLE transaction for commit, changing its state to\nPREPARED. This is the first commit.\n\nXA COMMIT definitely commits and terminates a transaction which has already\nbeen PREPARED. If the ONE PHASE clause is specified, this statements performs\na 1-phase commit on an IDLE transaction.\n\nXA ROLLBACK rolls back and terminates an IDLE or PREPARED transaction.\n\nXA RECOVER shows information about all PREPARED transactions.\n\nWhen trying to execute an operation which is not allowed for the transaction\'s\ncurrent state, an error is produced:\n\nXA COMMIT \'test\' ONE PHASE;\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  ACTIVE state\n\nXA COMMIT \'test2\';\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  NON-EXISTING state\n\nXA RECOVER\n----------\n\nThe XA RECOVER statement shows information about all transactions which are in\nthe PREPARED state. It does not matter which connection created the\ntransaction: if it has been PREPARED, it appears. But this does not mean that\na connection can commit or rollback a transaction which was started by another\nconnection. Note that transactions using a 1-phase commit are never in the\nPREPARED state, so they cannot be shown by XA RECOVER.\n\nXA RECOVER produces four columns:\n\nXA RECOVER;\n+----------+--------------+--------------+------+\n| formatID | gtrid_length | bqual_length | data |\n+----------+--------------+--------------+------+\n|        1 |            4 |            0 | test |\n+----------+--------------+--------------+------+\n\nMariaDB starting with 10.3.3\n----------------------------\nYou can use XA RECOVER FORMAT=\'SQL\' to get the data in a human readable form\nthat can be directly copy-pasted into XA COMMIT or XA ROLLBACK. This is\nparticularly useful for binary xid generated by some transaction coordinators.\n\nformatID is the formatID part of xid.\n\ndata are the gtrid and bqual parts of xid, concatenated.\n\ngtrid_length and bqual_length are the lengths of gtrid and bqual, respectevely.\n\nExamples\n--------\n\n2-phases commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA PREPARE \'test\';\n\nXA COMMIT \'test\';\n\n1-phase commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA COMMIT \'test\' ONE PHASE;\n\nHuman-readable:\n\nxa start \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\ninsert t1 values (40);\n\nxa end \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa prepare \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa recover format=\'RAW\';\n+----------+--------------+--------------+--------------------+\n| formatID | gtrid_length | bqual_length | data               |\n+----------+--------------+--------------+--------------------+\n34      67v78abc       11 |            7 | 12\ndef |\n+----------+--------------+--------------+--------------------+\n\nxa recover format=\'SQL\';\n+----------+--------------+--------------+-------------------------------------\n---------+\n| formatID | gtrid_length | bqual_length | data                               \n     |\n+----------+--------------+--------------+-------------------------------------\n---------+\n|        3 |           11 |            7 |\nX\'31320d3334093637763738\',X\'6162630a646566\',3 |\n+----------+--------------+--------------+-------------------------------------\n---------+\n\nxa rollback X\'31320d3334093637763738\',X\'6162630a646566\',3;\n\nKnown Issues\n------------\n\nMariaDB Galera Cluster\n----------------------\n\nMariaDB Galera Cluster does not support XA transactions.\n\nHowever, MariaDB Galera Cluster builds include a built-in plugin called wsrep.\nPrior to MariaDB 10.4.3, this plugin was internally considered an XA-capable\nstorage engine. Consequently, these MariaDB Galera Cluster builds have\nmultiple XA-capable storage engines by default, even if the only \"real\"\nstorage engine that supports external XA transactions enabled on these builds\nby default is InnoDB. Therefore, when using one these builds MariaDB would be\nforced to use a transaction coordinator log by default, which could have\nperformance implications.\n\nSee Transaction Coordinator Log Overview: MariaDB Galera Cluster for more\ninformation.\n\nURL: https://mariadb.com/kb/en/xa-transactions/','','https://mariadb.com/kb/en/xa-transactions/'),(104,'CREATE USER',10,'Syntax\n------\n\nCREATE [OR REPLACE] USER [IF NOT EXISTS] \n user_specification [,user_specification ...] \n [REQUIRE {NONE | tls_option [[AND] tls_option ...] }]\n [WITH resource_option [resource_option ...] ]\n [lock_option] [password_option]\n\nuser_specification:\n username [authentication_option]\n\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule  ...]\n\nauthentication_rule:\n  authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\ntls_option:\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n\nlock_option:\n  ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n\nDescription\n-----------\n\nThe CREATE USER statement creates new MariaDB accounts. To use it, you must\nhave the global CREATE USER privilege or the INSERT privilege for the mysql\ndatabase. For each account, CREATE USER creates a new row in mysql.user (until\nMariaDB 10.3 this is a table, from MariaDB 10.4 it\'s a view) or\nmysql.global_priv_table (from MariaDB 10.4) that has no privileges.\n\nIf any of the specified accounts, or any permissions for the specified\naccounts, already exist, then the server returns ERROR 1396 (HY000). If an\nerror occurs, CREATE USER will still create the accounts that do not result in\nan error. Only one error is produced for all users which have not been created:\n\nERROR 1396 (HY000): \n Operation CREATE USER failed for \'u1\'@\'%\',\'u2\'@\'%\'\n\nCREATE USER, DROP USER, CREATE ROLE, and DROP ROLE all produce the same error\ncode when they fail.\n\nSee Account Names below for details on how account names are specified.\n\nOR REPLACE\n----------\n\nIf the optional OR REPLACE clause is used, it is basically a shortcut for:\n\nDROP USER IF EXISTS name;\nCREATE USER name ...;\n\nFor example:\n\nCREATE USER foo2@test IDENTIFIED BY \'password\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'foo2\'@\'test\'\n\nCREATE OR REPLACE USER foo2@test IDENTIFIED BY \'password\';\nQuery OK, 0 rows affected (0.00 sec)\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a warning instead\nof an error if the specified user already exists.\n\nFor example:\n\nCREATE USER foo2@test IDENTIFIED BY \'password\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'foo2\'@\'test\'\n\nCREATE USER IF NOT EXISTS foo2@test IDENTIFIED BY \'password\';\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+----------------------------------------------------+\n| Level | Code | Message                                            |\n+-------+------+----------------------------------------------------+\n| Note  | 1973 | Can\'t create user \'foo2\'@\'test\'; it already exists |\n+-------+------+----------------------------------------------------+\n\nAuthentication Options\n----------------------\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored in the\nmysql.user/mysql.global_priv_table table.\n\nFor example, if our password is mariadb, then we can create the user with:\n\nCREATE USER foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD function. It will be stored in the\nmysql.user/mysql.global_priv_table table as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n\nAnd then we can create a user with the hash:\n\nCREATE USER foo2@test IDENTIFIED BY PASSWORD\n\'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nCREATE USER foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nCREATE USER foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nMariaDB starting with 10.4.0\n----------------------------\nThe USING or AS keyword can also be used to provide a plain-text password to a\nplugin if it\'s provided as an argument to the PASSWORD() function. This is\nonly valid for authentication plugins that have implemented a hook for the\nPASSWORD() function. For example, the ed25519 authentication plugin supports\nthis:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nMariaDB starting with 10.4.3\n----------------------------\nOne can specify many authentication plugins, they all work as alternatives\nways of authenticating a user:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\') OR\nunix_socket;\n\nBy default, when you create a user without specifying an authentication\nplugin, MariaDB uses the mysql_native_password plugin.\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can create a user account that requires these TLS options\nwith the following:\n\nCREATE USER \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\'\n AND ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+--------------------------------------+--------------------------------------+\n| Limit Type                           | Decription                           |\n+--------------------------------------+--------------------------------------+\n| MAX_QUERIES_PER_HOUR                 | Number of statements that the        |\n|                                      | account can issue per hour           |\n|                                      | (including updates)                  |\n+--------------------------------------+--------------------------------------+\n| MAX_UPDATES_PER_HOUR                 | Number of updates (not queries)      |\n|                                      | that the account can issue per hour  |\n+--------------------------------------+--------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR             | Number of connections that the       |\n|                                      | account can start per hour           |\n+--------------------------------------+--------------------------------------+\n| MAX_USER_CONNECTIONS                 | Number of simultaneous connections   |\n|                                      | that can be accepted from the same   |\n|                                      | account; if it is 0,                 |\n|                                      | max_connections will be used         |\n|                                      | instead; if max_connections is 0,    |\n|                                      | there is no limit for this           |\n|                                      | account\'s simultaneous connections.  |\n+--------------------------------------+--------------------------------------+\n| MAX_STATEMENT_TIME                   | Timeout, in seconds, for statements  |\n|                                      | executed by the user. See also       |\n|                                      | Aborting Statements that Exceed a    |\n|                                      | Certain Time to Execute.             |\n+--------------------------------------+--------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nHere is an example showing how to create a user with resource limits:\n\nCREATE USER \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 10\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nAccount Names\n-------------\n\nAccount names have both a user name component and a host name component, and\nare specified as \'user_name\'@\'host_name\'.\n\nThe user name and host name may be unquoted, quoted as strings using double\nquotes (\") or single quotes (\'), or quoted as identifiers using backticks (`).\nYou must use quotes when using special characters (such as a hyphen) or\nwildcard characters. If you quote, you must quote the user name and host name\nseparately (for example \'user_name\'@\'host_name\').\n\nHost Name Component\n-------------------\n\nIf the host name is not provided, it is assumed to be \'%\'.\n\nHost names may contain the wildcard characters % and _. They are matched as if\nby the LIKE clause. If you need to use a wildcard character literally (for\nexample, to match a domain name with an underscore), prefix the character with\na backslash. See LIKE for more information on escaping wildcard characters.\n\nHost name matches are case-insensitive. Host names can match either domain\nnames or IP addresses. Use \'localhost\' as the host name to allow only local\nclient connections.\n\nYou can use a netmask to match a range of IP addresses using \'base_ip/netmask\'\nas the host name. A user with an IP address ip_addr will be allowed to connect\nif the following condition is true:\n\nip_addr & netmask = base_ip\n\nFor example, given a user:\n\nCREATE USER \'maria\'@\'247.150.130.0/255.255.255.0\';\n\nthe IP addresses satisfying this condition range from 247.150.130.0 to\n247.150.130.255.\n\nUsing 255.255.255.255 is equivalent to not using a netmask at all. Netmasks\ncannot be used for IPv6 addresses.\n\nNote that the credentials added when creating a user with the \'%\' wildcard\nhost will not grant access in all cases. For example, some systems come with\nan anonymous localhost user, and when connecting from localhost this will take\nprecedence.\n\nBefore MariaDB 10.6, the host name component could be up to 60 characters in\nlength. Starting from MariaDB 10.6, it can be up to 255 characters.\n\nUser Name Component\n-------------------\n\nUser names must match exactly, including case. A user name that is empty is\nknown as an anonymous account and is allowed to match a login attempt with any\nuser name component. These are described more in the next section.\n\nFor valid identifiers to use as user names, see Identifier Names.\n\nIt is possible for more than one account to match when a user connects.\nMariaDB selects the first matching account after sorting according to the\nfollowing criteria:\n\n* Accounts with an exact host name are sorted before accounts using a wildcard\nin the\nhost name. Host names using a netmask are considered to be exact for sorting.\n* Accounts with a wildcard in the host name are sorted according to the\nposition of\nthe first wildcard character. Those with a wildcard character later in the\nhost name\nsort before those with a wildcard character earlier in the host name.\n* Accounts with a non-empty user name sort before accounts with an empty user\nname.\n* Accounts with an empty user name are sorted last. As mentioned previously,\nthese are known as anonymous accounts. These are described more in the next\nsection.\n\nThe following table shows a list of example account as sorted by these\ncriteria:\n\n+---------+-------------+\n| User    | Host        |\n+---------+-------------+\n| joffrey | 192.168.0.3 |\n|         | 192.168.0.% |\n| joffrey | 192.168.%   |\n|         | 192.168.%   |\n+---------+-------------+\n\nOnce connected, you only have the privileges granted to the account that\nmatched, not all accounts that could have matched. For example, consider the\nfollowing commands:\n\nCREATE USER \'joffrey\'@\'192.168.0.3\';\nCREATE USER \'joffrey\'@\'%\';\nGRANT SELECT ON test.t1 to \'joffrey\'@\'192.168.0.3\';\nGRANT SELECT ON test.t2 to \'joffrey\'@\'%\';\n\nIf you connect as joffrey from 192.168.0.3, you will have the SELECT privilege\non the table test.t1, but not on the table test.t2. If you connect as joffrey\nfrom any other IP address, you will have the SELECT privilege on the table\ntest.t2, but not on the table test.t1.\n\nUsernames can be up to 80 characters long before 10.6 and starting from 10.6\nit can be 128 characters long.\n\nAnonymous Accounts\n------------------\n\nAnonymous accounts are accounts where the user name portion of the account\nname is empty. These accounts act as special catch-all accounts. If a user\nattempts to log into the system from a host, and an anonymous account exists\nwith a host name portion that matches the user\'s host, then the user will log\nin as the anonymous account if there is no more specific account match for the\nuser name that the user entered.\n\nFor example, here are some anonymous accounts:\n\nCREATE USER \'\'@\'localhost\';\nCREATE USER \'\'@\'192.168.0.3\';\n\nFixing a Legacy Default Anonymous Account\n-----------------------------------------\n\nOn some systems, the mysql.db table has some entries for the \'\'@\'%\' anonymous\naccount by default. Unfortunately, there is no matching entry in the\nmysql.user/mysql.global_priv_table table, which means that this anonymous\naccount doesn\'t exactly exist, but it does have privileges--usually on the\ndefault test database created by mysql_install_db. These account-less\nprivileges are a legacy that is leftover from a time when MySQL\'s privilege\nsystem was less advanced.\n\nThis situation means that you will run into errors if you try to create a\n\'\'@\'%\' account. For example:\n\nCREATE USER \'\'@\'%\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'\'@\'%\'\n\nThe fix is to DELETE the row in the mysql.db table and then execute FLUSH\nPRIVILEGES:\n\nDELETE FROM mysql.db WHERE User=\'\' AND Host=\'%\';\nFLUSH PRIVILEGES;\n\nAnd then the account can be created:\n\nCREATE USER \'\'@\'%\';\nQuery OK, 0 rows affected (0.01 sec)\n\nSee MDEV-13486 for more information.\n\nPassword Expiry\n---------------\n\nMariaDB starting with 10.4.3\n----------------------------\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal setting, for example:\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\n\nSee User Password Expiry for more details.\n\nAccount Locking\n---------------\n\nMariaDB starting with 10.4.2\n----------------------------\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected). For example:\n\nCREATE USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nSee Account Locking for more details.\n\nFrom MariaDB 10.4.7 and MariaDB 10.5.8, the lock_option and password_option\nclauses can occur in either order.\n\nURL: https://mariadb.com/kb/en/create-user/','','https://mariadb.com/kb/en/create-user/'),(105,'ALTER USER',10,'Syntax\n------\n\nALTER USER [IF EXISTS] \n user_specification [,user_specification] ...\n [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n [WITH resource_option [resource_option] ...]\n [lock_option] [password_option]\n\nuser_specification:\n username [authentication_option]\n\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule] ...\n\nauthentication_rule:\n authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\ntls_option\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nresource_option\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n\nlock_option:\n  ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n\nDescription\n-----------\n\nThe ALTER USER statement modifies existing MariaDB accounts. To use it, you\nmust have the global CREATE USER privilege or the UPDATE privilege for the\nmysql database. The global SUPER privilege is also required if the read_only\nsystem variable is enabled.\n\nIf any of the specified user accounts do not yet exist, an error results. If\nan error occurs, ALTER USER will still modify the accounts that do not result\nin an error. Only one error is produced for all users which have not been\nmodified.\n\nIF EXISTS\n---------\n\nWhen the IF EXISTS clause is used, MariaDB will return a warning instead of an\nerror for each specified user that does not exist.\n\nAccount Names\n-------------\n\nFor ALTER USER statements, account names are specified as the username\nargument in the same way as they are for CREATE USER statements. See account\nnames from the CREATE USER page for details on how account names are specified.\n\nCURRENT_USER or CURRENT_USER() can also be used to alter the account logged\ninto the current session. For example, to change the current user\'s password\nto mariadb:\n\nALTER USER CURRENT_USER() IDENTIFIED BY \'mariadb\';\n\nAuthentication Options\n----------------------\n\nMariaDB starting with 10.4\n--------------------------\nFrom MariaDB 10.4, it is possible to use more than one authentication plugin\nfor each user account. For example, this can be useful to slowly migrate users\nto the more secure ed25519 authentication plugin over time, while allowing the\nold mysql_native_password authentication plugin as an alternative for the\ntransitional period. See Authentication from MariaDB 10.4 for more.\n\nWhen running ALTER USER, not specifying an authentication option in the\nIDENTIFIED VIA clause will remove that authentication method. (However this\nwas not the case before MariaDB 10.4.13, see MDEV-21928)\n\nFor example, a user is created with the ability to authenticate via both a\npassword and unix_socket:\n\nCREATE USER \'bob\'@\'localhost\' \n IDENTIFIED VIA mysql_native_password USING PASSWORD(\'pwd\')\n OR unix_socket;\n\nSHOW CREATE USER \'bob\'@\'localhost\'\\G\n*************************** 1. row ***************************\nCREATE USER for bob@localhost: CREATE USER `bob`@`localhost` \n IDENTIFIED VIA mysql_native_password\n USING \'*975B2CD4FF9AE554FE8AD33168FBFC326D2021DD\'\n OR unix_socket\n\nIf the user\'s password is updated, but unix_socket authentication is not\nspecified in the IDENTIFIED VIA clause, unix_socket authentication will no\nlonger be permitted.\n\nALTER USER \'bob\'@\'localhost\' IDENTIFIED VIA mysql_native_password \n USING PASSWORD(\'pwd2\');\n\nSHOW CREATE USER \'bob\'@\'localhost\'\\G\n*************************** 1. row ***************************\nCREATE USER for bob@localhost: CREATE USER `bob`@`localhost` \n IDENTIFIED BY PASSWORD \'*38366FDA01695B6A5A9DD4E428D9FB8F7EB75512\'\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored to the mysql.user table.\n\nFor example, if our password is mariadb, then we can set the account\'s\npassword with:\n\nALTER USER foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD#function. It will be stored to the\nmysql.user table as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n\nAnd then we can set an account\'s password with the hash:\n\nALTER USER foo2@test \n IDENTIFIED BY PASSWORD \'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nALTER USER foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nALTER USER foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nIn MariaDB 10.4 and later, the USING or AS keyword can also be used to provide\na plain-text password to a plugin if it\'s provided as an argument to the\nPASSWORD() function. This is only valid for authentication plugins that have\nimplemented a hook for the PASSWORD() function. For example, the ed25519\nauthentication plugin supports this:\n\nALTER USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can alter a user account to require these TLS options with\nthe following:\n\nALTER USER \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\' AND\n ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+------------------------------------+---------------------------------------+\n| Limit Type                         | Description                           |\n+------------------------------------+---------------------------------------+\n| MAX_QUERIES_PER_HOUR               | Number of statements that the         |\n|                                    | account can issue per hour            |\n|                                    | (including updates)                   |\n+------------------------------------+---------------------------------------+\n| MAX_UPDATES_PER_HOUR               | Number of updates (not queries) that  |\n|                                    | the account can issue per hour        |\n+------------------------------------+---------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR           | Number of connections that the        |\n|                                    | account can start per hour            |\n+------------------------------------+---------------------------------------+\n| MAX_USER_CONNECTIONS               | Number of simultaneous connections    |\n|                                    | that can be accepted from the same    |\n|                                    | account; if it is 0, max_connections  |\n|                                    | will be used instead; if              |\n|                                    | max_connections is 0, there is no     |\n|                                    | limit for this account\'s              |\n|                                    | simultaneous connections.             |\n+------------------------------------+---------------------------------------+\n| MAX_STATEMENT_TIME                 | Timeout, in seconds, for statements   |\n|                                    | executed by the user. See also        |\n|                                    | Aborting Statements that Exceed a     |\n|                                    | Certain Time to Execute.              |\n+------------------------------------+---------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nHere is an example showing how to set an account\'s resource limits:\n\nALTER USER \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 10\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nPassword Expiry\n---------------\n\nMariaDB starting with 10.4.3\n----------------------------\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal setting, for example:\n\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE NEVER;\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n\nSee User Password Expiry for more details.\n\nAccount Locking\n---------------\n\nMariaDB starting with 10.4.2\n----------------------------\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected). For example:\n\nALTER USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nSee Account Locking for more details.\n\nFrom MariaDB 10.4.7 and MariaDB 10.5.8, the lock_option and password_option\nclauses can occur in either order.\n\nURL: https://mariadb.com/kb/en/alter-user/','','https://mariadb.com/kb/en/alter-user/'),(107,'GRANT',10,'Syntax\n------\n\nGRANT\n  priv_type [(column_list)]\n   [, priv_type [(column_list)]] ...\n  ON [object_type] priv_level\n  TO user_specification [ user_options ...]\n\nuser_specification:\n username [authentication_option]\n | PUBLIC\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule  ...]\n\nauthentication_rule:\n  authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\nGRANT PROXY ON username\n  TO user_specification [, user_specification ...]\n  [WITH GRANT OPTION]\n\nGRANT rolename TO grantee [, grantee ...]\n  [WITH ADMIN OPTION]\n\ngrantee:\n  rolename\n  username [authentication_option]\n\nuser_options:\n  [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n  [WITH with_option [with_option] ...]\n\nobject_type:\n  TABLE\n | FUNCTION\n | PROCEDURE\n | PACKAGE\n\npriv_level:\n  *\n | *.*\n | db_name.*\n | db_name.tbl_name\n | tbl_name\n | db_name.routine_name\n\nwith_option:\n  GRANT OPTION\n | resource_option\n\nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\ntls_option:\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nDescription\n-----------\n\nThe GRANT statement allows you to grant privileges or roles to accounts. To\nuse GRANT, you must have the GRANT OPTION privilege, and you must have the\nprivileges that you are granting.\n\nUse the REVOKE statement to revoke privileges granted with the GRANT statement.\n\nUse the SHOW GRANTS statement to determine what privileges an account has.\n\nAccount Names\n-------------\n\nFor GRANT statements, account names are specified as the username argument in\nthe same way as they are for CREATE USER statements. See account names from\nthe CREATE USER page for details on how account names are specified.\n\nImplicit Account Creation\n-------------------------\n\nThe GRANT statement also allows you to implicitly create accounts in some\ncases.\n\nIf the account does not yet exist, then GRANT can implicitly create it. To\nimplicitly create an account with GRANT, a user is required to have the same\nprivileges that would be required to explicitly create the account with the\nCREATE USER statement.\n\nIf the NO_AUTO_CREATE_USER SQL_MODE is set, then accounts can only be created\nif authentication information is specified, or with a CREATE USER statement.\nIf no authentication information is provided, GRANT will produce an error when\nthe specified account does not exist, for example:\n\nshow variables like \'%sql_mode%\' ;\n+---------------+--------------------------------------------+\n| Variable_name | Value                                      |\n+---------------+--------------------------------------------+\n| sql_mode      | NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION |\n+---------------+--------------------------------------------+\n\nGRANT USAGE ON *.* TO \'user123\'@\'%\' IDENTIFIED BY \'\';\nERROR 1133 (28000): Can\'t find any matching row in the user table\n\nGRANT USAGE ON *.* TO \'user123\'@\'%\' \n IDENTIFIED VIA PAM using \'mariadb\' require ssl ;\nQuery OK, 0 rows affected (0.00 sec)\n\nselect host, user from mysql.user where user=\'user123\' ;\n\n+------+----------+\n| host | user     |\n+------+----------+\n| %    | user123 |\n+------+----------+\n\nPrivilege Levels\n----------------\n\nPrivileges can be set globally, for an entire database, for a table or\nroutine, or for individual columns in a table. Certain privileges can only be\nset at certain levels.\n\n* Global privileges priv_type are granted using *.* for\npriv_level. Global privileges include privileges to administer the database\nand manage user accounts, as well as privileges for all tables, functions, and\nprocedures. Global privileges are stored in the mysql.user table prior to\nMariaDB 10.4, and in  mysql.global_priv table afterwards.\n* Database privileges priv_type are granted using db_name.*\nfor priv_level, or using just * to use default database. Database\nprivileges include privileges to create tables and functions, as well as\nprivileges for all tables, functions, and procedures in the database. Database\nprivileges are stored in the mysql.db table.\n* Table privileges priv_type are granted using db_name.tbl_name\nfor priv_level, or using just tbl_name to specify a table in the default\ndatabase. The TABLE keyword is optional. Table privileges include the\nability to select and change data in the table. Certain table privileges can\nbe granted for individual columns.\n* Column privileges priv_type are granted by specifying a table for\npriv_level and providing a column list after the privilege type. They allow\nyou to control exactly which columns in a table users can select and change.\n* Function privileges priv_type are granted using FUNCTION db_name.routine_name\nfor priv_level, or using just  FUNCTION routine_name to specify a function\nin the default database.\n* Procedure privileges priv_type are granted using PROCEDURE\ndb_name.routine_name\nfor priv_level, or using just PROCEDURE routine_name to specify a procedure\nin the default database.\n\nThe USAGE Privilege\n-------------------\n\nThe USAGE privilege grants no real privileges. The SHOW GRANTS statement will\nshow a global USAGE privilege for a newly-created user. You can use USAGE with\nthe GRANT statement to change options like GRANT OPTION and\nMAX_USER_CONNECTIONS without changing any account privileges.\n\nThe ALL PRIVILEGES Privilege\n----------------------------\n\nThe ALL PRIVILEGES privilege grants all available privileges. Granting all\nprivileges only affects the given privilege level. For example, granting all\nprivileges on a table does not grant any privileges on the database or\nglobally.\n\nUsing ALL PRIVILEGES does not grant the special GRANT OPTION privilege.\n\nYou can use ALL instead of ALL PRIVILEGES.\n\nThe GRANT OPTION Privilege\n--------------------------\n\nUse the WITH GRANT OPTION clause to give users the ability to grant privileges\nto other users at the given privilege level. Users with the GRANT OPTION\nprivilege can only grant privileges they have. They cannot grant privileges at\na higher privilege level than they have the GRANT OPTION privilege.\n\nThe GRANT OPTION privilege cannot be set for individual columns. If you use\nWITH GRANT OPTION when specifying column privileges, the GRANT OPTION\nprivilege will be granted for the entire table.\n\nUsing the WITH GRANT OPTION clause is equivalent to listing GRANT OPTION as a\nprivilege.\n\nGlobal Privileges\n-----------------\n\nThe following table lists the privileges that can be granted globally. You can\nalso grant all database, table, and function privileges globally. When granted\nglobally, these privileges apply to all databases, tables, or functions,\nincluding those created later.\n\nTo set a global privilege, use *.* for priv_level.\n\nBINLOG ADMIN\n------------\n\nEnables administration of the binary log, including the PURGE BINARY LOGS\nstatement and setting the system variables:\n\n* binlog_annotate_row_events\n* binlog_cache_size\n* binlog_commit_wait_count\n* binlog_commit_wait_usec\n* binlog_direct_non_transactional_updates\n* binlog_expire_logs_seconds\n* binlog_file_cache_size\n* binlog_format\n* binlog_row_image\n* binlog_row_metadata\n* binlog_stmt_cache_size\n* expire_logs_days\n* log_bin_compress\n* log_bin_compress_min_len\n* log_bin_trust_function_creators\n* max_binlog_cache_size\n* max_binlog_size\n* max_binlog_stmt_cache_size\n* sql_log_bin and\n* sync_binlog.\n\nAdded in MariaDB 10.5.2.\n\nBINLOG MONITOR\n--------------\n\nNew name for REPLICATION CLIENT from MariaDB 10.5.2, (REPLICATION CLIENT still\nsupported as an alias for compatibility purposes). Permits running SHOW\ncommands related to the binary log, in particular the SHOW BINLOG STATUS and\nSHOW BINARY LOGS statements. Unlike REPLICATION CLIENT prior to MariaDB 10.5,\nSHOW REPLICA STATUS isn\'t included in this privilege, and REPLICA MONITOR is\nrequired.\n\nBINLOG REPLAY\n-------------\n\nEnables replaying the binary log with the BINLOG statement (generated by\nmariadb-binlog), executing SET timestamp when secure_timestamp is set to\nreplication, and setting the session values of system variables usually\nincluded in BINLOG output, in particular:\n\n* gtid_domain_id\n* gtid_seq_no\n* pseudo_thread_id\n* server_id.\n\nAdded in MariaDB 10.5.2\n\nCONNECTION ADMIN\n----------------\n\nEnables administering connection resource limit options. This includes\nignoring the limits specified by:\n\n* max_connections\n* max_user_connections and\n* max_password_errors.\n\nThe statements specified in init_connect are not executed, killing connections\nand queries owned by other users is permitted. The following\nconnection-related system variables can be changed:\n\n* connect_timeout\n* disconnect_on_expired_password\n* extra_max_connections\n* init_connect\n* max_connections\n* max_connect_errors\n* max_password_errors\n* proxy_protocol_networks\n* secure_auth\n* slow_launch_time\n* thread_pool_exact_stats\n* thread_pool_dedicated_listener\n* thread_pool_idle_timeout\n* thread_pool_max_threads\n* thread_pool_min_threads\n* thread_pool_oversubscribe\n* thread_pool_prio_kickup_timer\n* thread_pool_priority\n* thread_pool_size, and\n* thread_pool_stall_limit.\n\nAdded in MariaDB 10.5.2.\n\nCREATE USER\n-----------\n\nCreate a user using the CREATE USER statement, or implicitly create a user\nwith the GRANT statement.\n\nFEDERATED ADMIN\n---------------\n\nExecute CREATE SERVER, ALTER SERVER, and DROP SERVER statements. Added in\nMariaDB 10.5.2.\n\nFILE\n----\n\nRead and write files on the server, using statements like LOAD DATA INFILE or\nfunctions like LOAD_FILE(). Also needed to create CONNECT outward tables.\nMariaDB server must have the permissions to access those files.\n\nGRANT OPTION\n------------\n\nGrant global privileges. You can only grant privileges that you have.\n\nPROCESS\n-------\n\nShow information about the active processes, for example via SHOW PROCESSLIST\nor mysqladmin processlist. If you have the PROCESS privilege, you can see all\nthreads. Otherwise, you can see only your own threads (that is, threads\nassociated with the MariaDB account that you are using).\n\nREAD_ONLY ADMIN\n---------------\n\nUser can set the read_only system variable and allows the user to perform\nwrite operations, even when the read_only option is active. Added in MariaDB\n10.5.2.\n\nFrom MariaDB 10.11.0, the READ_ONLY ADMIN privilege has been removed from\nSUPER. The benefit of this is that one can remove the READ_ONLY ADMIN\nprivilege from all users and ensure that no one can make any changes on any\nnon-temporary tables. This is useful on replicas when one wants to ensure that\nthe replica is kept identical to the primary.\n\nRELOAD\n------\n\nExecute FLUSH statements or equivalent mariadb-admin/mysqladmin commands.\n\nREPLICATION CLIENT\n------------------\n\nExecute SHOW MASTER STATUS and SHOW BINARY LOGS informative statements.\nRenamed to BINLOG MONITOR in MariaDB 10.5.2 (but still supported as an alias\nfor compatibility reasons). SHOW SLAVE STATUS was part of REPLICATION CLIENT\nprior to MariaDB 10.5.\n\nREPLICATION MASTER ADMIN\n------------------------\n\nPermits administration of primary servers, including the SHOW REPLICA HOSTS\nstatement, and setting the gtid_binlog_state, gtid_domain_id,\nmaster_verify_checksum and server_id system variables. Added in MariaDB 10.5.2.\n\nREPLICA MONITOR\n---------------\n\nPermit SHOW REPLICA STATUS and SHOW RELAYLOG EVENTS. From MariaDB 10.5.9.\n\nWhen a user would upgrade from an older major release to a MariaDB 10.5 minor\nrelease prior to MariaDB 10.5.9, certain user accounts would lose\ncapabilities. For example, a user account that had the REPLICATION CLIENT\nprivilege in older major releases could run SHOW REPLICA STATUS, but after\nupgrading to a MariaDB 10.5 minor release prior to MariaDB 10.5.9, they could\nno longer run SHOW REPLICA STATUS, because that statement was changed to\nrequire the REPLICATION REPLICA ADMIN privilege.\n\nThis issue is fixed in MariaDB 10.5.9 with this new privilege, which now\ngrants the user the ability to execute SHOW [ALL] (SLAVE | REPLICA) STATUS.\n\nWhen a database is upgraded from an older major release to MariaDB Server\n10.5.9 or later, any user accounts with the REPLICATION CLIENT or REPLICATION\nSLAVE privileges will automatically be granted the new REPLICA MONITOR\nprivilege. The privilege fix occurs when the server is started up, not when\nmariadb-upgrade is performed.\n\nHowever, when a database is upgraded from an early 10.5 minor release to\n10.5.9 and later, the user will have to fix any user account privileges\nmanually.\n\nREPLICATION REPLICA\n-------------------\n\nSynonym for REPLICATION SLAVE. From MariaDB 10.5.1.\n\nREPLICATION SLAVE\n-----------------\n\nAccounts used by replica servers on the primary need this privilege. This is\nneeded to get the updates made on the master. From MariaDB 10.5.1, REPLICATION\nREPLICA is an alias for REPLICATION SLAVE.\n\nREPLICATION SLAVE ADMIN\n-----------------------\n\nPermits administering replica servers, including START REPLICA/SLAVE, STOP\nREPLICA/SLAVE, CHANGE MASTER, SHOW REPLICA/SLAVE STATUS, SHOW RELAYLOG EVENTS\nstatements, replaying the binary log with the BINLOG statement (generated by\nmariadb-binlog), and setting the system variables:\n\n* gtid_cleanup_batch_size\n* gtid_ignore_duplicates\n* gtid_pos_auto_engines\n* gtid_slave_pos\n* gtid_strict_mode\n* init_slave\n* read_binlog_speed_limit\n* relay_log_purge\n* relay_log_recovery\n* replicate_do_db\n* replicate_do_table\n* replicate_events_marked_for_skip\n* replicate_ignore_db\n* replicate_ignore_table\n* replicate_wild_do_table\n* replicate_wild_ignore_table\n* slave_compressed_protocol\n* slave_ddl_exec_mode\n* slave_domain_parallel_threads\n* slave_exec_mode\n* slave_max_allowed_packet\n* slave_net_timeout\n* slave_parallel_max_queued\n* slave_parallel_mode\n* slave_parallel_threads\n* slave_parallel_workers\n* slave_run_triggers_for_rbr\n* slave_sql_verify_checksum\n* slave_transaction_retry_interval\n* slave_type_conversions\n* sync_master_info\n* sync_relay_log, and\n* sync_relay_log_info.\n\nAdded in MariaDB 10.5.2.\n\nSET USER\n--------\n\nEnables setting the DEFINER when creating triggers, views, stored functions\nand stored procedures. Added in MariaDB 10.5.2.\n\nSHOW DATABASES\n--------------\n\nList all databases using the SHOW DATABASES statement. Without the SHOW\nDATABASES privilege, you can still issue the SHOW DATABASES statement, but it\nwill only list databases containing tables on which you have privileges.\n\nSHUTDOWN\n--------\n\nShut down the server using SHUTDOWN or the mysqladmin shutdown command.\n\nSUPER\n-----\n\nExecute superuser statements: CHANGE MASTER TO, KILL (users who do not have\nthis privilege can only KILL their own threads), PURGE LOGS, SET global system\nvariables, or the mysqladmin debug command. Also, this permission allows the\nuser to write data even if the read_only startup option is set, enable or\ndisable logging, enable or disable replication on replica, specify a DEFINER\nfor statements that support that clause, connect once reaching the\nMAX_CONNECTIONS. If a statement has been specified for the init-connect mysqld\noption, that command will not be executed when a user with SUPER privileges\nconnects to the server.\n\nThe SUPER privilege has been split into multiple smaller privileges from\nMariaDB 10.5.2 to allow for more fine-grained privileges, although it remains\nan alias for these smaller privileges.\n\nFrom MariaDB 10.11.0, the READ_ONLY ADMIN privilege has been removed from\nSUPER. The benefit of this is that one can remove the READ_ONLY ADMIN\nprivilege from all users and ensure that no one can make any changes on any\nnon-temporary tables. This is useful on replicas when one wants to ensure that\nthe replica is kept identical to the primary.\n\nDatabase Privileges\n-------------------\n\nThe following table lists the privileges that can be granted at the database\nlevel. You can also grant all table and function privileges at the database\nlevel. Table and function privileges on a database apply to all tables or\nfunctions in that database, including those created later.\n\nTo set a privilege for a database, specify the database using db_name.* for\npriv_level, or just use * to specify the default database.\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| CREATE                           | Create a database using the CREATE      |\n|                                  | DATABASE statement, when the privilege  |\n|                                  | is granted for a database. You can      |\n|                                  | grant the CREATE privilege on           |\n|                                  | databases that do not yet exist. This   |\n|                                  | also grants the CREATE privilege on     |\n|                                  | all tables in the database.             |\n+----------------------------------+-----------------------------------------+\n| CREATE ROUTINE                   | Create Stored Programs using the        |\n|                                  | CREATE PROCEDURE and CREATE FUNCTION    |\n|                                  | statements.                             |\n+----------------------------------+-----------------------------------------+\n| CREATE TEMPORARY TABLES          | Create temporary tables with the        |\n|                                  | CREATE TEMPORARY TABLE statement. This  |\n|                                  | privilege enable writing and dropping   |\n|                                  | those temporary tables                  |\n+----------------------------------+-----------------------------------------+\n| DROP                             | Drop a database using the DROP          |\n|                                  | DATABASE statement, when the privilege  |\n|                                  | is granted for a database. This also    |\n|                                  | grants the DROP privilege on all        |\n|                                  | tables in the database.                 |\n+----------------------------------+-----------------------------------------+\n| EVENT                            | Create, drop and alter EVENTs.          |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant database privileges. You can      |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n| LOCK TABLES                      | Acquire explicit locks using the LOCK   |\n|                                  | TABLES statement; you also need to      |\n|                                  | have the SELECT privilege on a table,   |\n|                                  | in order to lock it.                    |\n+----------------------------------+-----------------------------------------+\n\nTable Privileges\n----------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER                            | Change the structure of an existing     |\n|                                  | table using the ALTER TABLE statement.  |\n+----------------------------------+-----------------------------------------+\n| CREATE                           | Create a table using the CREATE TABLE   |\n|                                  | statement.  You can grant the CREATE    |\n|                                  | privilege on tables that do not yet     |\n|                                  | exist.                                  |\n+----------------------------------+-----------------------------------------+\n| CREATE VIEW                      | Create a view using the CREATE_VIEW     |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| DELETE                           | Remove rows from a table using the      |\n|                                  | DELETE statement.                       |\n+----------------------------------+-----------------------------------------+\n| DELETE HISTORY                   | Remove historical rows from a table     |\n|                                  | using the DELETE HISTORY statement.     |\n|                                  | Displays as DELETE VERSIONING ROWS      |\n|                                  | when running SHOW GRANTS until MariaDB  |\n|                                  | 10.3.15 and until MariaDB 10.4.5        |\n|                                  | (MDEV-17655), or when running SHOW      |\n|                                  | PRIVILEGES until MariaDB 10.5.2,        |\n|                                  | MariaDB 10.4.13 and MariaDB 10.3.23     |\n|                                  | (MDEV-20382). From MariaDB 10.3.4.      |\n|                                  | From MariaDB 10.3.5, if a user has the  |\n|                                  | SUPER privilege but not this            |\n|                                  | privilege, running mysql_upgrade will   |\n|                                  | grant this privilege as well.           |\n+----------------------------------+-----------------------------------------+\n| DROP                             | Drop a table using the DROP TABLE       |\n|                                  | statement or a view using the DROP      |\n|                                  | VIEW statement. Also required to        |\n|                                  | execute the TRUNCATE TABLE statement.   |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant table privileges. You can only    |\n|                                  | grant privileges that you have.         |\n+----------------------------------+-----------------------------------------+\n| INDEX                            | Create an index on a table using the    |\n|                                  | CREATE INDEX statement. Without the     |\n|                                  | INDEX privilege, you can still create   |\n|                                  | indexes when creating a table using     |\n|                                  | the CREATE TABLE statement if the you   |\n|                                  | have the CREATE privilege, and you can  |\n|                                  | create indexes using the ALTER TABLE    |\n|                                  | statement if you have the ALTER         |\n|                                  | privilege.                              |\n+----------------------------------+-----------------------------------------+\n| INSERT                           | Add rows to a table using the INSERT    |\n|                                  | statement.  The INSERT privilege can    |\n|                                  | also be set on individual columns; see  |\n|                                  | Column Privileges below for details.    |\n+----------------------------------+-----------------------------------------+\n| REFERENCES                       | Unused.                                 |\n+----------------------------------+-----------------------------------------+\n| SELECT                           | Read data from a table using the        |\n|                                  | SELECT statement. The SELECT privilege  |\n|                                  | can also be set on individual columns;  |\n|                                  | see Column Privileges below for         |\n|                                  | details.                                |\n+----------------------------------+-----------------------------------------+\n| SHOW VIEW                        | Show the CREATE VIEW statement to       |\n|                                  | create a view using the SHOW CREATE     |\n|                                  | VIEW statement.                         |\n+----------------------------------+-----------------------------------------+\n| TRIGGER                          | Execute triggers associated to tables   |\n|                                  | you update, execute the CREATE TRIGGER  |\n|                                  | and DROP TRIGGER statements. You will   |\n|                                  | still be able to see triggers.          |\n+----------------------------------+-----------------------------------------+\n| UPDATE                           | Update existing rows in a table using   |\n|                                  | the UPDATE statement. UPDATE            |\n|                                  | statements usually include a WHERE      |\n|                                  | clause to update only certain rows.     |\n|                                  | You must have SELECT privileges on the  |\n|                                  | table or the appropriate columns for    |\n|                                  | the WHERE clause. The UPDATE privilege  |\n|                                  | can also be set on individual columns;  |\n|                                  | see Column Privileges below for         |\n|                                  | details.                                |\n+----------------------------------+-----------------------------------------+\n\nColumn Privileges\n-----------------\n\nSome table privileges can be set for individual columns of a table. To use\ncolumn privileges, specify the table explicitly and provide a list of column\nnames after the privilege type. For example, the following statement would\nallow the user to read the names and positions of employees, but not other\ninformation from the same table, such as salaries.\n\nGRANT SELECT (name, position) on Employee to \'jeffrey\'@\'localhost\';\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| INSERT (column_list)             | Add rows specifying values in columns   |\n|                                  | using the INSERT statement. If you      |\n|                                  | only have column-level INSERT           |\n|                                  | privileges, you must specify the        |\n|                                  | columns you are setting in the INSERT   |\n|                                  | statement. All other columns will be    |\n|                                  | set to their default values, or NULL.   |\n+----------------------------------+-----------------------------------------+\n| REFERENCES (column_list)         | Unused.                                 |\n+----------------------------------+-----------------------------------------+\n| SELECT (column_list)             | Read values in columns using the        |\n|                                  | SELECT statement. You cannot access or  |\n|                                  | query any columns for which you do not  |\n|                                  | have SELECT privileges, including in    |\n|                                  | WHERE, ON, GROUP BY, and ORDER BY       |\n|                                  | clauses.                                |\n+----------------------------------+-----------------------------------------+\n| UPDATE (column_list)             | Update values in columns of existing    |\n|                                  | rows using the UPDATE statement.        |\n|                                  | UPDATE statements usually include a     |\n|                                  | WHERE clause to update only certain     |\n|                                  | rows. You must have SELECT privileges   |\n|                                  | on the table or the appropriate         |\n|                                  | columns for the WHERE clause.           |\n+----------------------------------+-----------------------------------------+\n\nFunction Privileges\n-------------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER ROUTINE                    | Change the characteristics of a stored  |\n|                                  | function using the ALTER FUNCTION       |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| EXECUTE                          | Use a stored function. You need SELECT  |\n|                                  | privileges for any tables or columns    |\n|                                  | accessed by the function.               |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant function privileges. You can      |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n\nProcedure Privileges\n--------------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER ROUTINE                    | Change the characteristics of a stored  |\n|                                  | procedure using the ALTER PROCEDURE     |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| EXECUTE                          | Execute a stored procedure using the    |\n|                                  | CALL statement. The privilege to call   |\n|                                  | a procedure may allow you to perform    |\n|                                  | actions you wouldn\'t otherwise be able  |\n|                                  | to do, such as insert rows into a       |\n|                                  | table.                                  |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant procedure privileges. You can     |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n\nGRANT EXECUTE ON PROCEDURE mysql.create_db TO maintainer;\n\nProxy Privileges\n----------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| PROXY                            | Permits one user to be a proxy for      |\n|                                  | another.                                |\n+----------------------------------+-----------------------------------------+\n\nThe PROXY privilege allows one user to proxy as another user, which means\ntheir privileges change to that of the proxy user, and the CURRENT_USER()\nfunction returns the user name of the proxy user.\n\nThe PROXY privilege only works with authentication plugins that support it.\nThe default mysql_native_password authentication plugin does not support proxy\nusers.\n\nThe pam authentication plugin is the only plugin included with MariaDB that\ncurrently supports proxy users. The PROXY privilege is commonly used with the\npam authentication plugin to enable user and group mapping with PAM.\n\nFor example, to grant the PROXY privilege to an anonymous account that\nauthenticates with the pam authentication plugin, you could execute the\nfollowing:\n\nCREATE USER \'dba\'@\'%\' IDENTIFIED BY \'strongpassword\';\nGRANT ALL PRIVILEGES ON *.* TO \'dba\'@\'%\' ;\n\nCREATE USER \'\'@\'%\' IDENTIFIED VIA pam USING \'mariadb\';\nGRANT PROXY ON \'dba\'@\'%\' TO \'\'@\'%\';\n\nA user account can only grant the PROXY privilege for a specific user account\nif the granter also has the PROXY privilege for that specific user account,\nand if that privilege is defined WITH GRANT OPTION. For example, the following\nexample fails because the granter does not have the PROXY privilege for that\nspecific user account at all:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------+\n| Grants for alice@localhost                                                  \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' |\n+------------------------------------------------------------------------------\n----------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nERROR 1698 (28000): Access denied for user \'alice\'@\'localhost\'\n\nAnd the following example fails because the granter does have the PROXY\nprivilege for that specific user account, but it is not defined WITH GRANT\nOPTION:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------+\n| Grants for alice@localhost                                                  \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' |\n| GRANT PROXY ON \'dba\'@\'localhost\' TO \'alice\'@\'localhost\'                     \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nERROR 1698 (28000): Access denied for user \'alice\'@\'localhost\'\n\nBut the following example succeeds because the granter does have the PROXY\nprivilege for that specific user account, and it is defined WITH GRANT OPTION:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| Grants for alice@localhost                                                  \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' WITH GRANT OPTION |\n| GRANT PROXY ON \'dba\'@\'localhost\' TO \'alice\'@\'localhost\' WITH GRANT OPTION   \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\n\nA user account can grant the PROXY privilege for any other user account if the\ngranter has the PROXY privilege for the \'\'@\'%\' anonymous user account, like\nthis:\n\nGRANT PROXY ON \'\'@\'%\' TO \'dba\'@\'localhost\' WITH GRANT OPTION;\n\nFor example, the following example succeeds because the user can grant the\nPROXY privilege for any other user account:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| Grants for alice@localhost                                                  \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' WITH GRANT OPTION |\n| GRANT PROXY ON \'\'@\'%\' TO \'alice\'@\'localhost\' WITH GRANT OPTION              \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n\nGRANT PROXY ON \'app1_dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nQuery OK, 0 rows affected (0.004 sec)\n\nGRANT PROXY ON \'app2_dba\'@\'localhost\' TO \'carol\'@\'localhost\';\nQuery OK, 0 rows affected (0.004 sec)\n\nThe default root user accounts created by mysql_install_db have this\nprivilege. For example:\n\nGRANT ALL PRIVILEGES ON *.* TO \'root\'@\'localhost\' WITH GRANT OPTION;\nGRANT PROXY ON \'\'@\'%\' TO \'root\'@\'localhost\' WITH GRANT OPTION;\n\nThis allows the default root user accounts to grant the PROXY privilege for\nany other user account, and it also allows the default root user accounts to\ngrant others the privilege to do the same.\n\nAuthentication Options\n----------------------\n\nThe authentication options for the GRANT statement are the same as those for\nthe CREATE USER statement.\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored.\n\nFor example, if our password is mariadb, then we can create the user with:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nIf the user account already exists and if you provide the IDENTIFIED BY\nclause, then the user\'s password will be changed. You must have the privileges\nneeded for the SET PASSWORD statement to change a user\'s password with GRANT.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD function. It will be stored as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n\nAnd then we can create a user with the hash:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED BY \n PASSWORD \'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nIf the user account already exists and if you provide the IDENTIFIED BY\nclause, then the user\'s password will be changed. You must have the privileges\nneeded for the SET PASSWORD statement to change a user\'s password with GRANT.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nMariaDB starting with 10.4.0\n----------------------------\nThe USING or AS keyword can also be used to provide a plain-text password to a\nplugin if it\'s provided as an argument to the PASSWORD() function. This is\nonly valid for authentication plugins that have implemented a hook for the\nPASSWORD() function. For example, the ed25519 authentication plugin supports\nthis:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 \n USING PASSWORD(\'secret\');\n\nMariaDB starting with 10.4.3\n----------------------------\nOne can specify many authentication plugins, they all work as alternatives\nways of authenticating a user:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 \n USING PASSWORD(\'secret\') OR unix_socket;\n\nBy default, when you create a user without specifying an authentication\nplugin, MariaDB uses the mysql_native_password plugin.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+--------------------------------------+--------------------------------------+\n| Limit Type                           | Decription                           |\n+--------------------------------------+--------------------------------------+\n| MAX_QUERIES_PER_HOUR                 | Number of statements that the        |\n|                                      | account can issue per hour           |\n|                                      | (including updates)                  |\n+--------------------------------------+--------------------------------------+\n| MAX_UPDATES_PER_HOUR                 | Number of updates (not queries)      |\n|                                      | that the account can issue per hour  |\n+--------------------------------------+--------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR             | Number of connections that the       |\n|                                      | account can start per hour           |\n+--------------------------------------+--------------------------------------+\n| MAX_USER_CONNECTIONS                 | Number of simultaneous connections   |\n|                                      | that can be accepted from the same   |\n|                                      | account; if it is 0,                 |\n|                                      | max_connections will be used         |\n|                                      | instead; if max_connections is 0,    |\n|                                      | there is no limit for this           |\n|                                      | account\'s simultaneous connections.  |\n+--------------------------------------+--------------------------------------+\n| MAX_STATEMENT_TIME                   | Timeout, in seconds, for statements  |\n|                                      | executed by the user. See also       |\n|                                      | Aborting Statements that Exceed a    |\n|                                      | Certain Time to Execute.             |\n+--------------------------------------+--------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nTo set resource limits for an account, if you do not want to change that\naccount\'s privileges, you can issue a GRANT statement with the USAGE\nprivilege, which has no meaning. The statement can name some or all limit\ntypes, in any order.\n\nHere is an example showing how to set resource limits:\n\nGRANT USAGE ON *.* TO \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 0\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nUsers with the CONNECTION ADMIN privilege (in MariaDB 10.5.2 and later) or the\nSUPER privilege are not restricted by max_user_connections, max_connections,\nor max_password_errors.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can create a user account that requires these TLS options\nwith the following:\n\nGRANT USAGE ON *.* TO \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\'\n AND ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nRoles\n-----\n\nSyntax\n------\n\nGRANT role TO grantee [, grantee ... ]\n[ WITH ADMIN OPTION ]\n\ngrantee:\n  rolename\n  username [authentication_option]\n\nThe GRANT statement is also used to grant the use of a role to one or more\nusers or other roles. In order to be able to grant a role, the grantor doing\nso must have permission to do so (see WITH ADMIN in the CREATE ROLE article).\n\nSpecifying the WITH ADMIN OPTION permits the grantee to in turn grant the role\nto another.\n\nFor example, the following commands show how to grant the same role to a\ncouple different users.\n\nGRANT journalist TO hulda;\n\nGRANT journalist TO berengar WITH ADMIN OPTION;\n\nIf a user has been granted a role, they do not automatically obtain all\npermissions associated with that role. These permissions are only in use when\nthe user activates the role with the SET ROLE statement.\n\nTO PUBLIC\n---------\n\nMariaDB starting with 10.11\n---------------------------\n\nSyntax\n------\n\nGRANT <privilege> ON <database>.<object> TO PUBLIC;\nREVOKE <privilege> ON <database>.<object> FROM PUBLIC;\n\nGRANT ... TO PUBLIC grants privileges to all users with access to the server.\nThe privileges also apply to users created after the privileges are granted.\nThis can be useful when one only wants to state once that all users need to\nhave a certain set of privileges.\n\nWhen running SHOW GRANTS, a user will also see all privileges inherited from\nPUBLIC. SHOW GRANTS FOR PUBLIC will only show TO PUBLIC grants.\n\nGrant Examples\n--------------\n\nGranting Root-like Privileges\n-----------------------------\n\nYou can create a user that has privileges similar to the default root accounts\nby executing the following:\n\nCREATE USER \'alexander\'@\'localhost\';\nGRANT ALL PRIVILEGES ON  *.* to \'alexander\'@\'localhost\' WITH GRANT OPTION;\n\nURL: https://mariadb.com/kb/en/grant/','','https://mariadb.com/kb/en/grant/'),(117,'Authentication from MariaDB 10.4',10,'MariaDB starting with 10.4\n--------------------------\nMariaDB 10.4 introduced a number of changes to the authentication process,\nintended to make things easier and more intuitive.\n\nOverview\n--------\n\nThere are four new main features in 10.4 relating to authentication:\n\n* It is possible to use more than one authentication plugin for each user\naccount. For example, this can be useful to slowly migrate users to the more\nsecure ed25519 authentication plugin over time, while allowing the old\nmysql_native_password authentication plugin as an alternative for the\ntransitional period.\n* The root@localhost user account created by mysql_install_db is created with\nthe ability to use two authentication plugins.\nFirst, it is configured to try to use the unix_socket authentication plugin.\nThis allows the root@localhost user to login without a password via the local\nUnix socket file defined by the socket system variable, as long as the login\nis attempted from a process owned by the operating system root user account.\nSecond, if authentication fails with the unix_socket authentication plugin,\nthen it is configured to try to use the mysql_native_password authentication\nplugin. However, an invalid password is initially set, so in order to\nauthenticate this way, a password must be set with SET PASSWORD.\nHowever, just using the unix_socket authentication plugin may be fine for many\nusers, and it is very secure. You may want to try going without password\nauthentication to see how well it works for you. Remember, the best way to\nkeep your password safe is not to have one!\n\n* All user accounts, passwords, and global privileges are now stored in the\nmysql.global_priv table. The mysql.user table still exists and has exactly the\nsame set of columns as before, but it’s now a view that references the\nmysql.global_priv table. Tools that analyze the mysql.user table should\ncontinue to work as before. From MariaDB 10.4.13, the dedicated mariadb.sys\nuser is created as the definer of this view. Previously root was the definer,\nwhich resulted in privilege problems when this username was changed.\n* MariaDB 10.4 adds supports for User Password Expiry, which is not active by\ndefault.\n\nDescription\n-----------\n\nAs a result of the above changes, the open-for-everyone all-powerful root\naccount is finally gone. And installation scripts will no longer demand that\nyou \"PLEASE REMEMBER TO SET A PASSWORD FOR THE MariaDB root USER !\", because\nthe root account is securely created automatically.\n\nTwo all-powerful accounts are created by default — root and the OS user that\nowns the data directory, typically mysql. They are created as:\n\nCREATE USER root@localhost IDENTIFIED VIA unix_socket OR mysql_native_password\nUSING \'invalid\'\nCREATE USER mysql@localhost IDENTIFIED VIA unix_socket OR\nmysql_native_password USING \'invalid\'\n\nUsing unix_socket means that if you are the system root user, you can login as\nroot@locahost without a password. This technique was pioneered by Otto\nKekäläinen in Debian MariaDB packages and has been successfully used in Debian\nsince as early as MariaDB 10.0.\n\nIt is based on a simple fact that asking the system root for a password adds\nno extra security — root has full access to all the data files and all process\nmemory anyway. But not asking for a password means, there is no root password\nto forget (no need for the numerous tutorials on \"how to reset MariaDB root\npassword\"). And if you want to script some tedious database work, there is no\nneed to store the root password in plain text for the script to use (no need\nfor debian-sys-maint user).\n\nStill, some users may wish to log in as MariaDB root without using sudo. Hence\nthe old authentication method — conventional MariaDB password — is still\navailable. By default it is disabled (\"invalid\" is not a valid password hash),\nbut one can set the password with a usual SET PASSWORD statement. And still\nretain the password-less access via sudo.\n\nIf you install MariaDB locally (say from a tarball), you would not want to use\nsudo to be able to login. This is why MariaDB creates a second all-powerful\nuser with the same name as a system user that owns the data directory. In\nlocal (not system-wide) installations, this will be the user who installed\nMariaDB — they automatically get convenient password-less root-like access,\nbecause they can access all the data files anyway.\n\nEven if MariaDB is installed system-wide, you may not want to run your\ndatabase maintenance scripts as system root — now you can run them as system\nmysql user. And you will know that they will never destroy your entire system,\neven if you make a typo in a shell script.\n\nHowever, seasoned MariaDB DBAs who are used to the old ways do need to make\nsome changes. See the examples below for common tasks.\n\nCookbook\n--------\n\nAfter installing MariaDB system-wide the first thing you’ve got used to doing\nis logging in into the unprotected root account and protecting it, that is,\nsetting the root password:\n\n$ sudo dnf install MariaDB-server\n$ mysql -uroot\n...\nMariaDB> set password = password(\"XH4VmT3_jt\");\n\nThis is not only unnecessary now, it will simply not work — there is no\nunprotected root account. To login as root use\n\n$ sudo dnf install MariaDB-server\n$ sudo mysql\n\nNote that it implies you are connecting via the unix socket, not tcp. If you\nhappen to have protocol=tcp in a system-wide /etc/my.cnf file, use sudo mysql\n--protocol=socket.\n\nAfter installing MariaDB locally you’ve also used to connect to the\nunprotected root account using mysql -uroot. This will not work either, simply\nuse mysql without specifying a username.\n\nIf you\'ve forgotten your root password, no problem — you can still connect\nusing sudo and change the password. And if you\'ve also removed unix_socket\nauthentication, to restore access do as follows:\n\n* restart MariaDB with --skip-grant-tables\n* login into the unprotected server\n* run FLUSH PRIVILEGES (note, before 10.4 this would’ve been the last step,\nnot anymore). This disables --skip-grant-tables and allows you to change the\nstored authentication method\n* run SET PASSWORD FOR root@localhost to change the root password.\n\nTo view inside privilege tables, the old mysql.user table still exists. You\ncan select from it as before, although you cannot update it anymore. It\ndoesn’t show alternative authentication plugins and this was one of the\nreasons for switching to the mysql.global_priv table — complex authentication\nrules did not fit into rigid structure of a relational table. You can select\nfrom the new table, for example:\n\nselect concat(user, \'@\', host, \' => \', json_detailed(priv)) from\nmysql.global_priv;\n\nReverting to the Previous Authentication Method for root@localhost\n------------------------------------------------------------------\n\nIf you don\'t want the root@localhost user account created by mysql_install_db\nto use unix_socket authentication by default, then there are a few ways to\nrevert to the previous mysql_native_password authentication method for this\nuser account.\n\nConfiguring mysql_install_db to Revert to the Previous Authentication Method\n----------------------------------------------------------------------------\n\nOne way to revert to the previous mysql_native_password authentication method\nfor the root@localhost user account is to execute mysql_install_db with a\nspecial option. If mysql_install_db is executed while\n--auth-root-authentication-method=normal is specified, then it will create the\ndefault user accounts using the default behavior of MariaDB 10.3 and before.\n\nThis means that the root@localhost user account will use mysql_native_password\nauthentication by default. There are some other differences as well. See\nmysql_install_db: User Accounts Created by Default for more information.\n\nFor example, the option can be set on the command-line while running\nmysql_install_db:\n\nmysql_install_db --user=mysql --datadir=/var/lib/mysql\n--auth-root-authentication-method=normal\n\nThe option can also be set in an option file in an option group supported by\nmysql_install_db. For example:\n\n[mysql_install_db]\nauth_root_authentication_method=normal\n\nIf the option is set in an option file and if mysql_install_db is executed,\nthen mysql_install_db will read this option from the option file, and it will\nautomatically set this option.\n\nAltering the User Account to Revert to the Previous Authentication Method\n-------------------------------------------------------------------------\n\nIf you have already installed MariaDB, and if the root@localhost user account\nis already using unix_socket authentication, then you can revert to the old\nmysql_native_password authentication method for the user account by executing\nthe following:\n\nALTER USER root@localhost IDENTIFIED VIA mysql_native_password USING\nPASSWORD(\"verysecret\")\n\nURL: https://mariadb.com/kb/en/authentication-from-mariadb-104/','','https://mariadb.com/kb/en/authentication-from-mariadb-104/'),(119,'ST_X',11,'Syntax\n------\n\nST_X(p)\nX(p)\n\nDescription\n-----------\n\nReturns the X-coordinate value for the point p as a double-precision number.\n\nST_X() and X() are synonyms.\n\nExamples\n--------\n\nSET @pt = \'Point(56.7 53.34)\';\n\nSELECT X(GeomFromText(@pt));\n+----------------------+\n| X(GeomFromText(@pt)) |\n+----------------------+\n|                 56.7 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/st_x/','','https://mariadb.com/kb/en/st_x/'),(88,'IF Function',7,'Syntax\n------\n\nIF(expr1,expr2,expr3)\n\nDescription\n-----------\n\nIf expr1 is TRUE (expr1 <> 0 and expr1 <> NULL) then IF() returns expr2;\notherwise it returns expr3. IF() returns a numeric or string value, depending\non the context in which it is used.\n\nNote: There is also an IF statement which differs from the IF() function\ndescribed here.\n\nExamples\n--------\n\nSELECT IF(1>2,2,3);\n+-------------+\n| IF(1>2,2,3) |\n+-------------+\n|           3 |\n+-------------+\n\nSELECT IF(1<2,\'yes\',\'no\');\n+--------------------+\n| IF(1<2,\'yes\',\'no\') |\n+--------------------+\n| yes                |\n+--------------------+\n\nSELECT IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\');\n+---------------------------------------+\n| IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\') |\n+---------------------------------------+\n| no                                    |\n+---------------------------------------+\n\nURL: https://mariadb.com/kb/en/if-function/','','https://mariadb.com/kb/en/if-function/'),(89,'IFNULL',7,'Syntax\n------\n\nIFNULL(expr1,expr2)\nNVL(expr1,expr2)\n\nDescription\n-----------\n\nIf expr1 is not NULL, IFNULL() returns expr1; otherwise it returns expr2.\nIFNULL() returns a numeric or string value, depending on the context in which\nit is used.\n\nFrom MariaDB 10.3, NVL() is an alias for IFNULL().\n\nExamples\n--------\n\nSELECT IFNULL(1,0); \n+-------------+\n| IFNULL(1,0) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT IFNULL(NULL,10);\n+-----------------+\n| IFNULL(NULL,10) |\n+-----------------+\n|              10 |\n+-----------------+\n\nSELECT IFNULL(1/0,10);\n+----------------+\n| IFNULL(1/0,10) |\n+----------------+\n|        10.0000 |\n+----------------+\n\nSELECT IFNULL(1/0,\'yes\');\n+-------------------+\n| IFNULL(1/0,\'yes\') |\n+-------------------+\n| yes               |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/ifnull/','','https://mariadb.com/kb/en/ifnull/'),(94,'START TRANSACTION',8,'Syntax\n------\n\nSTART TRANSACTION [transaction_property [, transaction_property] ...] | BEGIN\n[WORK]\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nROLLBACK [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nSET autocommit = {0 | 1}\n\ntransaction_property:\n  WITH CONSISTENT SNAPSHOT\n | READ WRITE\n | READ ONLY\n\nDescription\n-----------\n\nThe START TRANSACTION or BEGIN statement begins a new transaction. COMMIT\ncommits the current transaction, making its changes permanent. ROLLBACK rolls\nback the current transaction, canceling its changes. The SET autocommit\nstatement disables or enables the default autocommit mode for the current\nsession.\n\nSTART TRANSACTION and SET autocommit = 1 implicitly commit the current\ntransaction, if any.\n\nThe optional WORK keyword is supported for COMMIT and ROLLBACK, as are the\nCHAIN and RELEASE clauses. CHAIN and RELEASE can be used for additional\ncontrol over transaction completion. The value of the completion_type system\nvariable determines the default completion behavior.\n\nThe AND CHAIN clause causes a new transaction to begin as soon as the current\none ends, and the new transaction has the same isolation level as the\njust-terminated transaction. The RELEASE clause causes the server to\ndisconnect the current client session after terminating the current\ntransaction. Including the NO keyword suppresses CHAIN or RELEASE completion,\nwhich can be useful if the completion_type system variable is set to cause\nchaining or release completion by default.\n\nAccess Mode\n-----------\n\nThe access mode specifies whether the transaction is allowed to write data or\nnot. By default, transactions are in READ WRITE mode (see the tx_read_only\nsystem variable). READ ONLY mode allows the storage engine to apply\noptimizations that cannot be used for transactions which write data. The only\nexception to this rule is that read only transactions can perform DDL\nstatements on temporary tables.\n\nIt is not permitted to specify both READ WRITE and READ ONLY in the same\nstatement.\n\nREAD WRITE and READ ONLY can also be specified in the SET TRANSACTION\nstatement, in which case the specified mode is valid for all sessions, or for\nall subsequent transaction used by the current session.\n\nautocommit\n----------\n\nBy default, MariaDB runs with autocommit mode enabled. This means that as soon\nas you execute a statement that updates (modifies) a table, MariaDB stores the\nupdate on disk to make it permanent. To disable autocommit mode, use the\nfollowing statement:\n\nSET autocommit=0;\n\nAfter disabling autocommit mode by setting the autocommit variable to zero,\nchanges to transaction-safe tables (such as those for InnoDB or NDBCLUSTER)\nare not made permanent immediately. You must use COMMIT to store your changes\nto disk or ROLLBACK to ignore the changes.\n\nTo disable autocommit mode for a single series of statements, use the START\nTRANSACTION statement.\n\nDDL Statements\n--------------\n\nDDL statements (CREATE, ALTER, DROP) and administrative statements (FLUSH,\nRESET, OPTIMIZE, ANALYZE, CHECK, REPAIR, CACHE INDEX), transaction management\nstatements (BEGIN, START TRANSACTION) and LOAD DATA INFILE, cause an implicit\nCOMMIT and start a new transaction. An exception to this rule are the DDL that\noperate on temporary tables: you can CREATE, ALTER and DROP them without\ncausing any COMMIT, but those actions cannot be rolled back. This means that\nif you call ROLLBACK, the temporary tables you created in the transaction will\nremain, while the rest of the transaction will be rolled back.\n\nTransactions cannot be used in Stored Functions or Triggers. In Stored\nProcedures and Events BEGIN is not allowed, so you should use START\nTRANSACTION instead.\n\nA transaction acquires a metadata lock on every table it accesses to prevent\nother connections from altering their structure. The lock is released at the\nend of the transaction. This happens even with non-transactional storage\nengines (like MEMORY or CONNECT), so it makes sense to use transactions with\nnon-transactional tables.\n\nin_transaction\n--------------\n\nThe in_transaction system variable is a session-only, read-only variable that\nreturns 1 inside a transaction, and 0 if not in a transaction.\n\nWITH CONSISTENT SNAPSHOT\n------------------------\n\nThe WITH CONSISTENT SNAPSHOT option starts a consistent read for storage\nengines such as InnoDB that can do so, the same as if a START TRANSACTION\nfollowed by a SELECT from any InnoDB table was issued.\n\nSee Enhancements for START TRANSACTION WITH CONSISTENT SNAPSHOT.\n\nExamples\n--------\n\nSTART TRANSACTION;\nSELECT @A:=SUM(salary) FROM table1 WHERE type=1;\nUPDATE table2 SET summary=@A WHERE type=1;\nCOMMIT;\n\nURL: https://mariadb.com/kb/en/start-transaction/','','https://mariadb.com/kb/en/start-transaction/'),(120,'ST_Y',11,'Syntax\n------\n\nST_Y(p)\nY(p)\n\nDescription\n-----------\n\nReturns the Y-coordinate value for the point p as a double-precision number.\n\nST_Y() and Y() are synonyms.\n\nExamples\n--------\n\nSET @pt = \'Point(56.7 53.34)\';\n\nSELECT Y(GeomFromText(@pt));\n+----------------------+\n| Y(GeomFromText(@pt)) |\n+----------------------+\n|                53.34 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/st_y/','','https://mariadb.com/kb/en/st_y/'),(121,'X',11,'A synonym for ST_X.\n\nURL: https://mariadb.com/kb/en/point-properties-x/','','https://mariadb.com/kb/en/point-properties-x/'),(122,'Y',11,'A synonym for ST_Y.\n\nURL: https://mariadb.com/kb/en/point-properties-y/','','https://mariadb.com/kb/en/point-properties-y/'),(125,'DECODE_ORACLE',12,'MariaDB starting with 10.3.2\n----------------------------\nDECODE_ORACLE is a synonym for the Oracle mode version of the DECODE function,\nand is available in all modes.\n\nURL: https://mariadb.com/kb/en/decode_oracle/','','https://mariadb.com/kb/en/decode_oracle/'),(93,'SET TRANSACTION',8,'Syntax\n------\n\nSET [GLOBAL | SESSION] TRANSACTION\n  transaction_property [, transaction_property] ...\n\ntransaction_property:\n  ISOLATION LEVEL level\n | READ WRITE\n | READ ONLY\n\nlevel:\n  REPEATABLE READ\n | READ COMMITTED\n | READ UNCOMMITTED\n | SERIALIZABLE\n\nDescription\n-----------\n\nThis statement sets the transaction isolation level or the transaction access\nmode globally, for the current session, or for the next transaction:\n\n* With the GLOBAL keyword, the statement sets the default\n transaction level globally for all subsequent sessions. Existing sessions are\n unaffected.\n* With the SESSION keyword, the statement sets the default\n transaction level for all subsequent transactions performed within the\n current session.\n* Without any SESSION or GLOBAL keyword,\n the statement sets the isolation level for the next (not started) transaction\n performed within the current session.\n\nA change to the global default isolation level requires the SUPER privilege.\nAny session is free to change its session isolation level (even in the middle\nof a transaction), or the isolation level for its next transaction.\n\nIsolation Level\n---------------\n\nTo set the global default isolation level at server startup, use the\n--transaction-isolation=level option on the command line or in an option file.\nValues of level for this option use dashes rather than spaces, so the\nallowable values are READ-UNCOMMITTED, READ-COMMITTED, REPEATABLE-READ, or\nSERIALIZABLE. For example, to set the default isolation level to REPEATABLE\nREAD, use these lines in the [mysqld] section of an option file:\n\n[mysqld]\ntransaction-isolation = REPEATABLE-READ\nTo determine the global and session transaction isolation levels at runtime,\ncheck the value of the tx_isolation system variable:\n\nSELECT @@GLOBAL.tx_isolation, @@tx_isolation;\n\nInnoDB supports each of the translation isolation levels described here using\ndifferent locking strategies. The default level is REPEATABLE READ. For\nadditional information about InnoDB record-level locks and how it uses them to\nexecute various types of statements, see InnoDB Lock Modes, and\nhttp://dev.mysql.com/doc/refman/en/innodb-locks-set.html.\n\nIsolation Levels\n----------------\n\nThe following sections describe how MariaDB supports the different transaction\nlevels.\n\nREAD UNCOMMITTED\n----------------\n\nSELECT statements are performed in a non-locking fashion, but a possible\nearlier version of a row might be used. Thus, using this isolation level, such\nreads are not consistent. This is also called a \"dirty read.\" Otherwise, this\nisolation level works like READ COMMITTED.\n\nREAD COMMITTED\n--------------\n\nA somewhat Oracle-like isolation level with respect to consistent\n(non-locking) reads: Each consistent read, even within the same transaction,\nsets and reads its own fresh snapshot. See\nhttp://dev.mysql.com/doc/refman/en/innodb-consistent-read.html.\n\nFor locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE), InnoDB locks\nonly index records, not the gaps before them, and thus allows the free\ninsertion of new records next to locked records. For UPDATE and DELETE\nstatements, locking depends on whether the statement uses a unique index with\na unique search condition (such as WHERE id = 100), or a range-type search\ncondition (such as WHERE id > 100). For a unique index with a unique search\ncondition, InnoDB locks only the index record found, not the gap before it.\nFor range-type searches, InnoDB locks the index range scanned, using gap locks\nor next-key (gap plus index-record) locks to block insertions by other\nsessions into the gaps covered by the range. This is necessary because\n\"phantom rows\" must be blocked for MySQL replication and recovery to work.\n\nNote: If the READ COMMITTED isolation level is used or the\ninnodb_locks_unsafe_for_binlog system variable is enabled, there is no InnoDB\ngap locking except for foreign-key constraint checking and duplicate-key\nchecking. Also, record locks for non-matching rows are released after MariaDB\nhas evaluated the WHERE condition.If you use READ COMMITTED or enable\ninnodb_locks_unsafe_for_binlog, you must use row-based binary logging.\n\nREPEATABLE READ\n---------------\n\nThis is the default isolation level for InnoDB. For consistent reads, there is\nan important difference from the READ COMMITTED isolation level: All\nconsistent reads within the same transaction read the snapshot established by\nthe first read. This convention means that if you issue several plain\n(non-locking) SELECT statements within the same transaction, these SELECT\nstatements are consistent also with respect to each other. See\nhttp://dev.mysql.com/doc/refman/en/innodb-consistent-read.html.\n\nFor locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE), UPDATE, and\nDELETE statements, locking depends on whether the statement uses a unique\nindex with a unique search condition, or a range-type search condition. For a\nunique index with a unique search condition, InnoDB locks only the index\nrecord found, not the gap before it. For other search conditions, InnoDB locks\nthe index range scanned, using gap locks or next-key (gap plus index-record)\nlocks to block insertions by other sessions into the gaps covered by the range.\n\nThis is the minimum isolation level for non-distributed XA transactions.\n\nSERIALIZABLE\n------------\n\nThis level is like REPEATABLE READ, but InnoDB implicitly converts all plain\nSELECT statements to SELECT ... LOCK IN SHARE MODE if autocommit is disabled.\nIf autocommit is enabled, the SELECT is its own transaction. It therefore is\nknown to be read only and can be serialized if performed as a consistent\n(non-locking) read and need not block for other transactions. (This means that\nto force a plain SELECT to block if other transactions have modified the\nselected rows, you should disable autocommit.)\n\nDistributed XA transactions should always use this isolation level.\n\nAccess Mode\n-----------\n\nThe access mode specifies whether the transaction is allowed to write data or\nnot. By default, transactions are in READ WRITE mode (see the tx_read_only\nsystem variable). READ ONLY mode allows the storage engine to apply\noptimizations that cannot be used for transactions which write data. The only\nexception to this rule is that read only transactions can perform DDL\nstatements on temporary tables.\n\nIt is not permitted to specify both READ WRITE and READ ONLY in the same\nstatement.\n\nREAD WRITE and READ ONLY can also be specified in the START TRANSACTION\nstatement, in which case the specified mode is only valid for one transaction.\n\nExamples\n--------\n\nSET GLOBAL TRANSACTION ISOLATION LEVEL SERIALIZABLE;\n\nAttempting to set the isolation level within an existing transaction without\nspecifying GLOBAL or SESSION.\n\nSTART TRANSACTION;\n\nSET TRANSACTION ISOLATION LEVEL SERIALIZABLE;\nERROR 1568 (25001): Transaction characteristics can\'t be changed while a\ntransaction is in progress\n\nURL: https://mariadb.com/kb/en/set-transaction/','','https://mariadb.com/kb/en/set-transaction/'),(126,'AES_DECRYPT',12,'Syntax\n------\n\nAES_DECRYPT(crypt_str,key_str)\n\nDescription\n-----------\n\nThis function allows decryption of data using the official AES (Advanced\nEncryption Standard) algorithm. For more information, see the description of\nAES_ENCRYPT().\n\nURL: https://mariadb.com/kb/en/aes_decrypt/','','https://mariadb.com/kb/en/aes_decrypt/'),(133,'MD5',12,'Syntax\n------\n\nMD5(str)\n\nDescription\n-----------\n\nCalculates an MD5 128-bit checksum for the string.\n\nThe return value is a 32-hex digit string, and as of MariaDB 5.5, is a\nnonbinary string in the connection character set and collation, determined by\nthe values of the character_set_connection and collation_connection system\nvariables. Before 5.5, the return value was a binary string.\n\nNULL is returned if the argument was NULL.\n\nExamples\n--------\n\nSELECT MD5(\'testing\');\n+----------------------------------+\n| MD5(\'testing\')                   |\n+----------------------------------+\n| ae2b1fca515949e5d54fb22b8ed95575 |\n+----------------------------------+\n\nURL: https://mariadb.com/kb/en/md5/','','https://mariadb.com/kb/en/md5/'),(95,'COMMIT',8,'The COMMIT statement ends a transaction, saving any changes to the data so\nthat they become visible to subsequent transactions. Also, unlocks metadata\nchanged by current transaction. If autocommit is set to 1, an implicit commit\nis performed after each statement. Otherwise, all transactions which don\'t end\nwith an explicit COMMIT are implicitly rollbacked and the changes are lost.\nThe ROLLBACK statement can be used to do this explicitly.\n\nThe required syntax for the COMMIT statement is as follows:\n\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\n\nCOMMIT is the more important transaction terminator, as well as the more\ninteresting one. The basic form of the COMMIT statement is simply the keyword\nCOMMIT (the keyword WORK is simply noise and can be omitted without changing\nthe effect).\n\nThe optional AND CHAIN clause is a convenience for initiating a new\ntransaction as soon as the old transaction terminates. If AND CHAIN is\nspecified, then there is effectively nothing between the old and new\ntransactions, although they remain separate. The characteristics of the new\ntransaction will be the same as the characteristics of the old one — that is,\nthe new transaction will have the same access mode, isolation level and\ndiagnostics area size (we\'ll discuss all of these shortly) as the transaction\njust terminated.\n\nRELEASE tells the server to disconnect the client immediately after the\ncurrent transaction.\n\nThere are NO RELEASE and AND NO CHAIN options. By default, commits do not\nRELEASE or CHAIN, but it\'s possible to change this default behavior with the\ncompletion_type server system variable. In this case, the AND NO CHAIN and NO\nRELEASE options override the server default.\n\nURL: https://mariadb.com/kb/en/commit/','','https://mariadb.com/kb/en/commit/'),(96,'ROLLBACK',8,'The ROLLBACK statement rolls back (ends) a transaction, destroying any changes\nto SQL-data so that they never become visible to subsequent transactions. The\nrequired syntax for the ROLLBACK statement is as follows.\n\nROLLBACK [ WORK ] [ AND [ NO ] CHAIN ] \n[ TO [ SAVEPOINT ] {<savepoint name> | <simple target specification>} ]\n\nThe ROLLBACK statement will either end a transaction, destroying all data\nchanges that happened during any of the transaction, or it will just destroy\nany data changes that happened since you established a savepoint. The basic\nform of the ROLLBACK statement is just the keyword ROLLBACK (the keyword WORK\nis simply noise and can be omitted without changing the effect).\n\nThe optional AND CHAIN clause is a convenience for initiating a new\ntransaction as soon as the old transaction terminates. If AND CHAIN is\nspecified, then there is effectively nothing between the old and new\ntransactions, although they remain separate. The characteristics of the new\ntransaction will be the same as the characteristics of the old one — that is,\nthe new transaction will have the same access mode, isolation level and\ndiagnostics area size (we\'ll discuss all of these shortly) as the transaction\njust terminated. The AND NO CHAIN option just tells your DBMS to end the\ntransaction — that is, these four SQL statements are equivalent:\n\nROLLBACK; \nROLLBACK WORK; \nROLLBACK AND NO CHAIN; \nROLLBACK WORK AND NO CHAIN;\n\nAll of them end a transaction without saving any transaction characteristics.\nThe only other options, the equivalent statements:\n\nROLLBACK AND CHAIN;\nROLLBACK WORK AND CHAIN;\n\nboth tell your DBMS to end a transaction, but to save that transaction\'s\ncharacteristics for the next transaction.\n\nROLLBACK is much simpler than COMMIT: it may involve no more than a few\ndeletions (of Cursors, locks, prepared SQL statements and log-file entries).\nIt\'s usually assumed that ROLLBACK can\'t fail, although such a thing is\nconceivable (for example, an encompassing transaction might reject an attempt\nto ROLLBACK because it\'s lining up for a COMMIT).\n\nROLLBACK cancels all effects of a transaction. It does not cancel effects on\nobjects outside the DBMS\'s control (for example the values in host program\nvariables or the settings made by some SQL/CLI function calls). But in\ngeneral, it is a convenient statement for those situations when you say \"oops,\nthis isn\'t working\" or when you simply don\'t care whether your temporary work\nbecomes permanent or not.\n\nHere is a moot question. If all you\'ve been doing is SELECTs, so that there\nhave been no data changes, should you end the transaction with ROLLBACK or\nCOMMIT? It shouldn\'t really matter because both ROLLBACK and COMMIT do the\nsame transaction-terminating job. However, the popular conception is that\nROLLBACK implies failure, so after a successful series of SELECT statements\nthe convention is to end the transaction with COMMIT rather than ROLLBACK.\n\nMariaDB (and most other DBMSs) supports rollback of SQL-data change\nstatements, but not of SQL-Schema statements. This means that if you use any\nof CREATE, ALTER, DROP, GRANT, REVOKE, you are implicitly committing at\nexecution time.\n\nINSERT INTO Table_2 VALUES(5); \nDROP TABLE Table_3 CASCADE; \nROLLBACK;\n\nThe result will be that both the INSERT and the DROP will go through as\nseparate transactions so the ROLLBACK will have no effect.\n\nURL: https://mariadb.com/kb/en/rollback/','','https://mariadb.com/kb/en/rollback/'),(138,'ENDPOINT',13,'A synonym for ST_ENDPOINT.\n\nURL: https://mariadb.com/kb/en/linestring-properties-endpoint/','','https://mariadb.com/kb/en/linestring-properties-endpoint/'),(139,'GLENGTH',13,'Syntax\n------\n\nGLength(ls)\n\nDescription\n-----------\n\nReturns as a double-precision number the length of the LineString value ls in\nits associated spatial reference.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT GLength(GeomFromText(@ls));\n+----------------------------+\n| GLength(GeomFromText(@ls)) |\n+----------------------------+\n|           2.82842712474619 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/glength/','','https://mariadb.com/kb/en/glength/'),(140,'NumPoints',13,'A synonym for ST_NumPoints.\n\nURL: https://mariadb.com/kb/en/linestring-properties-numpoints/','','https://mariadb.com/kb/en/linestring-properties-numpoints/'),(141,'PointN',13,'A synonym for ST_PointN.\n\nURL: https://mariadb.com/kb/en/linestring-properties-pointn/','','https://mariadb.com/kb/en/linestring-properties-pointn/'),(142,'STARTPOINT',13,'A synonym for ST_STARTPOINT.\n\nURL: https://mariadb.com/kb/en/linestring-properties-startpoint/','','https://mariadb.com/kb/en/linestring-properties-startpoint/'),(143,'ST_ENDPOINT',13,'Syntax\n------\n\nST_EndPoint(ls)\nEndPoint(ls)\n\nDescription\n-----------\n\nReturns the Point that is the endpoint of the LineString value ls.\n\nST_EndPoint() and EndPoint() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(EndPoint(GeomFromText(@ls)));\n+-------------------------------------+\n| AsText(EndPoint(GeomFromText(@ls))) |\n+-------------------------------------+\n| POINT(3 3)                          |\n+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_endpoint/','','https://mariadb.com/kb/en/st_endpoint/'),(144,'ST_NUMPOINTS',13,'Syntax\n------\n\nST_NumPoints(ls)\nNumPoints(ls)\n\nDescription\n-----------\n\nReturns the number of Point objects in the LineString value ls.\n\nST_NumPoints() and NumPoints() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELE