/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `aodh`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `aodh` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `aodh`;

--
-- Table structure for table `alarm`
--

DROP TABLE IF EXISTS `alarm`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alarm` (
  `alarm_id` varchar(128) NOT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `name` text DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `severity` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `timestamp` datetime(6) DEFAULT NULL,
  `user_id` varchar(128) DEFAULT NULL,
  `project_id` varchar(128) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `state_reason` text DEFAULT NULL,
  `state_timestamp` datetime(6) DEFAULT NULL,
  `ok_actions` text DEFAULT NULL,
  `alarm_actions` text DEFAULT NULL,
  `insufficient_data_actions` text DEFAULT NULL,
  `repeat_actions` tinyint(1) DEFAULT NULL,
  `rule` text DEFAULT NULL,
  `time_constraints` text DEFAULT NULL,
  `evaluate_timestamp` datetime DEFAULT NULL,
  PRIMARY KEY (`alarm_id`),
  KEY `ix_alarm_type` (`type`),
  KEY `ix_alarm_user_id` (`user_id`),
  KEY `ix_alarm_project_id` (`project_id`),
  KEY `ix_alarm_enabled` (`enabled`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alarm`
--

LOCK TABLES `alarm` WRITE;
/*!40000 ALTER TABLE `alarm` DISABLE KEYS */;
/*!40000 ALTER TABLE `alarm` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alarm_history`
--

DROP TABLE IF EXISTS `alarm_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alarm_history` (
  `event_id` varchar(128) NOT NULL,
  `alarm_id` varchar(128) DEFAULT NULL,
  `on_behalf_of` varchar(128) DEFAULT NULL,
  `project_id` varchar(128) DEFAULT NULL,
  `user_id` varchar(128) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `detail` text DEFAULT NULL,
  `timestamp` datetime(6) DEFAULT NULL,
  `severity` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`event_id`),
  KEY `ix_alarm_history_alarm_id` (`alarm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alarm_history`
--

LOCK TABLES `alarm_history` WRITE;
/*!40000 ALTER TABLE `alarm_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `alarm_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('007');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota`
--

DROP TABLE IF EXISTS `quota`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(128) DEFAULT NULL,
  `resource` varchar(50) DEFAULT NULL,
  `limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`),
  KEY `ix_quota_project_id_resource` (`project_id`,`resource`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota`
--

LOCK TABLES `quota` WRITE;
/*!40000 ALTER TABLE `quota` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `barbican`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `barbican` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `barbican`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('8c74e2d7f1ff');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authorities`
--

DROP TABLE IF EXISTS `certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `plugin_ca_id` text NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cas_project_fk` (`project_id`),
  CONSTRAINT `cas_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authorities`
--

LOCK TABLES `certificate_authorities` WRITE;
/*!40000 ALTER TABLE `certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authority_metadata`
--

DROP TABLE IF EXISTS `certificate_authority_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authority_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_certificate_authority_metadatum_uc` (`ca_id`,`key`),
  KEY `ix_certificate_authority_metadata_ca_id` (`ca_id`),
  KEY `ix_certificate_authority_metadata_key` (`key`),
  CONSTRAINT `certificate_authority_metadata_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authority_metadata`
--

LOCK TABLES `certificate_authority_metadata` WRITE;
/*!40000 ALTER TABLE `certificate_authority_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authority_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acl_users`
--

DROP TABLE IF EXISTS `container_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_container_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `container_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `container_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acl_users`
--

LOCK TABLES `container_acl_users` WRITE;
/*!40000 ALTER TABLE `container_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acls`
--

DROP TABLE IF EXISTS `container_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_operation_uc` (`container_id`,`operation`),
  KEY `ix_container_acls_container_id` (`container_id`),
  CONSTRAINT `container_acls_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acls`
--

LOCK TABLES `container_acls` WRITE;
/*!40000 ALTER TABLE `container_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_consumer_metadata`
--

DROP TABLE IF EXISTS `container_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `name` varchar(36) DEFAULT NULL,
  `URL` varchar(255) DEFAULT NULL,
  `data_hash` char(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_consumer_hashed_container_name_url_uc` (`data_hash`),
  KEY `ix_container_consumer_metadata_container_id` (`container_id`),
  KEY `ix_container_consumer_metadata_project_id` (`project_id`),
  KEY `values_index` (`container_id`,`name`,`URL`),
  CONSTRAINT `container_consumer_metadata_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_consumer_metadata_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_consumer_metadata`
--

LOCK TABLES `container_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `container_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_secret`
--

DROP TABLE IF EXISTS `container_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_secret` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `container_id` varchar(36) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_secret_name_uc` (`container_id`,`secret_id`,`name`),
  KEY `ix_container_secret_container_id` (`container_id`),
  KEY `ix_container_secret_secret_id` (`secret_id`),
  CONSTRAINT `container_secret_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_secret_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_secret`
--

LOCK TABLES `container_secret` WRITE;
/*!40000 ALTER TABLE `container_secret` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `containers`
--

DROP TABLE IF EXISTS `containers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `containers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('generic','rsa','dsa','certificate') DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_containers_project_id` (`project_id`),
  CONSTRAINT `containers_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `containers`
--

LOCK TABLES `containers` WRITE;
/*!40000 ALTER TABLE `containers` DISABLE KEYS */;
/*!40000 ALTER TABLE `containers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encrypted_data`
--

DROP TABLE IF EXISTS `encrypted_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encrypted_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `secret_id` varchar(36) NOT NULL,
  `kek_id` varchar(36) NOT NULL,
  `cypher_text` text DEFAULT NULL,
  `kek_meta_extended` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_encrypted_data_kek_id` (`kek_id`),
  KEY `ix_encrypted_data_secret_id` (`secret_id`),
  CONSTRAINT `encrypted_data_ibfk_1` FOREIGN KEY (`kek_id`) REFERENCES `kek_data` (`id`),
  CONSTRAINT `encrypted_data_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encrypted_data`
--

LOCK TABLES `encrypted_data` WRITE;
/*!40000 ALTER TABLE `encrypted_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `encrypted_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kek_data`
--

DROP TABLE IF EXISTS `kek_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kek_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `kek_label` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `bind_completed` tinyint(1) NOT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `plugin_meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_kek_data_project_id` (`project_id`),
  CONSTRAINT `kek_data_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kek_data`
--

LOCK TABLES `kek_data` WRITE;
/*!40000 ALTER TABLE `kek_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `kek_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_barbican_metadata`
--

DROP TABLE IF EXISTS `order_barbican_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_barbican_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_barbican_metadata_order_id` (`order_id`),
  CONSTRAINT `order_barbican_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_barbican_metadata`
--

LOCK TABLES `order_barbican_metadata` WRITE;
/*!40000 ALTER TABLE `order_barbican_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_barbican_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_plugin_metadata`
--

DROP TABLE IF EXISTS `order_plugin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_plugin_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_plugin_metadata_order_id` (`order_id`),
  CONSTRAINT `order_plugin_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_plugin_metadata`
--

LOCK TABLES `order_plugin_metadata` WRITE;
/*!40000 ALTER TABLE `order_plugin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_plugin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_retry_tasks`
--

DROP TABLE IF EXISTS `order_retry_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_retry_tasks` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `id` varchar(36) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `retry_task` text NOT NULL,
  `retry_at` datetime NOT NULL,
  `retry_args` text NOT NULL,
  `retry_kwargs` text NOT NULL,
  `retry_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_retry_tasks_order_id` (`order_id`),
  CONSTRAINT `order_retry_tasks_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_retry_tasks`
--

LOCK TABLES `order_retry_tasks` WRITE;
/*!40000 ALTER TABLE `order_retry_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_retry_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `error_status_code` varchar(16) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  `secret_id` varchar(36) DEFAULT NULL,
  `container_id` varchar(36) DEFAULT NULL,
  `sub_status` varchar(36) DEFAULT NULL,
  `sub_status_message` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_orders_container_id` (`container_id`),
  KEY `ix_orders_project_id` (`project_id`),
  KEY `ix_orders_secret_id` (`secret_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`),
  CONSTRAINT `orders_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preferred_certificate_authorities`
--

DROP TABLE IF EXISTS `preferred_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `preferred_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_preferred_certificate_authorities_project_id` (`project_id`),
  KEY `ix_preferred_certificate_authorities_ca_id` (`ca_id`),
  CONSTRAINT `preferred_certificate_authorities_fk` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `preferred_certificate_authorities_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preferred_certificate_authorities`
--

LOCK TABLES `preferred_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `preferred_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `preferred_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_certificate_authorities`
--

DROP TABLE IF EXISTS `project_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_certificate_authority_uc` (`project_id`,`ca_id`),
  KEY `ix_project_certificate_authorities_ca_id` (`ca_id`),
  KEY `ix_project_certificate_authorities_project_id` (`project_id`),
  CONSTRAINT `project_certificate_authorities_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `project_certificate_authorities_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_certificate_authorities`
--

LOCK TABLES `project_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `project_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_quotas`
--

DROP TABLE IF EXISTS `project_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_quotas` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `secrets` int(11) DEFAULT NULL,
  `orders` int(11) DEFAULT NULL,
  `containers` int(11) DEFAULT NULL,
  `consumers` int(11) DEFAULT NULL,
  `cas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_project_quotas_project_id` (`project_id`),
  CONSTRAINT `project_quotas_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_quotas`
--

LOCK TABLES `project_quotas` WRITE;
/*!40000 ALTER TABLE `project_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_secret_store`
--

DROP TABLE IF EXISTS `project_secret_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_secret_store` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_store_id` varchar(36) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_secret_store_project_uc` (`project_id`),
  KEY `ix_project_secret_store_project_id` (`project_id`),
  KEY `ix_project_secret_store_secret_store_id` (`secret_store_id`),
  CONSTRAINT `project_secret_store_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `project_secret_store_ibfk_2` FOREIGN KEY (`secret_store_id`) REFERENCES `secret_stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_secret_store`
--

LOCK TABLES `project_secret_store` WRITE;
/*!40000 ALTER TABLE `project_secret_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_secret_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `external_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acl_users`
--

DROP TABLE IF EXISTS `secret_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_secret_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `secret_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `secret_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acl_users`
--

LOCK TABLES `secret_acl_users` WRITE;
/*!40000 ALTER TABLE `secret_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acls`
--

DROP TABLE IF EXISTS `secret_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_operation_uc` (`secret_id`,`operation`),
  KEY `ix_secret_acls_secret_id` (`secret_id`),
  CONSTRAINT `secret_acls_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acls`
--

LOCK TABLES `secret_acls` WRITE;
/*!40000 ALTER TABLE `secret_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_consumer_metadata`
--

DROP TABLE IF EXISTS `secret_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `service` varchar(255) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_consumer_resource_uc` (`secret_id`,`service`,`resource_type`,`resource_id`),
  KEY `ix_secret_consumer_metadata_secret_id` (`secret_id`),
  KEY `ix_secret_consumer_metadata_resource_id` (`resource_id`),
  KEY `ix_secret_consumer_metadata_project_id` (`project_id`),
  CONSTRAINT `fk_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `secret_consumer_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_consumer_metadata`
--

LOCK TABLES `secret_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `secret_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_store_metadata`
--

DROP TABLE IF EXISTS `secret_store_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_store_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secret_store_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_store_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_store_metadata`
--

LOCK TABLES `secret_store_metadata` WRITE;
/*!40000 ALTER TABLE `secret_store_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_store_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_stores`
--

DROP TABLE IF EXISTS `secret_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_stores` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `store_plugin` varchar(255) NOT NULL,
  `crypto_plugin` varchar(255) DEFAULT NULL,
  `global_default` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_stores_name_uc` (`name`),
  UNIQUE KEY `_secret_stores_plugin_names_uc` (`store_plugin`,`crypto_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_stores`
--

LOCK TABLES `secret_stores` WRITE;
/*!40000 ALTER TABLE `secret_stores` DISABLE KEYS */;
INSERT INTO `secret_stores` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `store_plugin`, `crypto_plugin`, `global_default`, `name`) VALUES ('1815c037-a854-4595-af7a-897713b6c0da','2025-12-05 08:53:52','2025-12-05 08:53:52',NULL,0,'ACTIVE','store_crypto','simple_crypto',1,'Software Only Crypto');
/*!40000 ALTER TABLE `secret_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_user_metadata`
--

DROP TABLE IF EXISTS `secret_user_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_user_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_key_uc` (`secret_id`,`key`),
  KEY `ix_secret_user_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_user_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_user_metadata`
--

LOCK TABLES `secret_user_metadata` WRITE;
/*!40000 ALTER TABLE `secret_user_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_user_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secrets`
--

DROP TABLE IF EXISTS `secrets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secrets` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `secret_type` varchar(255) DEFAULT 'opaque',
  `expiration` datetime DEFAULT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secrets_project_id` (`project_id`),
  CONSTRAINT `secrets_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secrets`
--

LOCK TABLES `secrets` WRITE;
/*!40000 ALTER TABLE `secrets` DISABLE KEYS */;
/*!40000 ALTER TABLE `secrets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_keys`
--

DROP TABLE IF EXISTS `transport_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transport_keys` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `transport_key` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_keys`
--

LOCK TABLES `transport_keys` WRITE;
/*!40000 ALTER TABLE `transport_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `cinder`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `cinder` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `cinder`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('daa98075b90d');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment_specs`
--

DROP TABLE IF EXISTS `attachment_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_attachment_specs_attachment_id` (`attachment_id`),
  CONSTRAINT `attachment_specs_ibfk_1` FOREIGN KEY (`attachment_id`) REFERENCES `volume_attachment` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment_specs`
--

LOCK TABLES `attachment_specs` WRITE;
/*!40000 ALTER TABLE `attachment_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_metadata`
--

DROP TABLE IF EXISTS `backup_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_backup_metadata_backup_id` (`backup_id`),
  CONSTRAINT `backup_metadata_ibfk_1` FOREIGN KEY (`backup_id`) REFERENCES `backups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_metadata`
--

LOCK TABLES `backup_metadata` WRITE;
/*!40000 ALTER TABLE `backup_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `container` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fail_reason` varchar(255) DEFAULT NULL,
  `service_metadata` varchar(255) DEFAULT NULL,
  `service` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `object_count` int(11) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `temp_volume_id` varchar(36) DEFAULT NULL,
  `temp_snapshot_id` varchar(36) DEFAULT NULL,
  `num_dependent_backups` int(11) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `data_timestamp` datetime DEFAULT NULL,
  `restore_volume_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
INSERT INTO `backups` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `host`, `availability_zone`, `display_name`, `display_description`, `container`, `status`, `fail_reason`, `service_metadata`, `service`, `size`, `object_count`, `parent_id`, `temp_volume_id`, `temp_snapshot_id`, `num_dependent_backups`, `snapshot_id`, `data_timestamp`, `restore_volume_id`, `encryption_key_id`) VALUES ('2025-12-05 10:17:00','2025-12-05 10:17:11','2025-12-05 10:17:12',1,'1744acaa-9e34-49c1-8031-dbeeec87ecfe','4fbacb38-5f3a-4696-a23a-bc0346bd5477','0b795e7702e342d9821a3667644be5b0','3554a89b305c449f9fd292eca5647512','cinder-backup-0',NULL,'tempest-VolumesBackupsTest-Backup-1938727994',NULL,'backups','deleted',NULL,'{\"base\": \"volume-4fbacb38-5f3a-4696-a23a-bc0346bd5477.backup.1744acaa-9e34-49c1-8031-dbeeec87ecfe\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:17:00','0acaddf6-99c4-4b5c-b931-29c7c402f0f5',NULL),('2025-12-05 10:12:26','2025-12-05 10:12:41','2025-12-05 10:12:42',1,'1d6d4509-9d60-4ccc-a35b-4c59dc6fc214','e0807f46-fd36-4bd4-bad7-9e310ec0d261','8a838ca5d9b94c4dbba789e07c71cbdf','c70f526bca874e278b9e8fa9cbae7937','cinder-backup-0','nova','tempest-VolumesBackupsAdminTest-Backup-507536680',NULL,'backups','deleted',NULL,'{\"base\": \"volume-e0807f46-fd36-4bd4-bad7-9e310ec0d261.backup.fb2b310c-a127-4cb1-8176-8e0f63a4f16e\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,0,NULL,NULL,NULL,0,NULL,'2025-12-05 10:12:26',NULL,NULL),('2025-12-05 10:18:16','2025-12-05 10:18:21','2025-12-05 10:18:22',1,'3f54787f-0710-48a3-a9e5-796711998a13','c4d37f21-a692-4fd8-a5cf-3ec6f97372f0','0b795e7702e342d9821a3667644be5b0','3554a89b305c449f9fd292eca5647512','cinder-backup-0',NULL,'tempest-VolumesBackupsTest-Backup-849921935',NULL,'backups','deleted',NULL,'{\"base\": \"volume-c4d37f21-a692-4fd8-a5cf-3ec6f97372f0.backup.c40b7f0c-d291-4bae-8eec-85700357c139\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,'c40b7f0c-d291-4bae-8eec-85700357c139',NULL,NULL,NULL,NULL,'2025-12-05 10:18:16',NULL,NULL),('2025-12-05 10:18:57','2025-12-05 10:19:13','2025-12-05 10:19:15',1,'45bf8ff1-767c-48bc-a935-cefd0f6c1727','bd924392-bd2a-4d46-a0f2-d1997d25543c','2150e2e9985942e98ecd4ba9bf2f7997','a6e8880ab10e4b26b0074c6f9b06aca3','cinder-backup-0',NULL,'tempest-VolumesSnapshotTestJSON-Backup-585023104',NULL,'backups','deleted',NULL,NULL,'cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,'825c3468-fdb7-49ee-aa42-4df403a2ae8b','2025-12-05 10:18:54',NULL,NULL),('2025-12-05 10:12:49','2025-12-05 10:12:54','2025-12-05 10:12:56',1,'7b2eb924-f6af-4e55-b2a1-ad7e8c9736ca','9830bc83-4267-4807-9688-39f0c0bc41c4','82400d0afa4a43378786350753954e62','02098318982046faa2136ab12b344eb1','cinder-backup-0',NULL,'tempest-VolumesBackupsAdminTest-Backup-1217902110',NULL,'backups','deleted',NULL,'{\"base\": \"volume-9830bc83-4267-4807-9688-39f0c0bc41c4.backup.7b2eb924-f6af-4e55-b2a1-ad7e8c9736ca\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:12:49',NULL,NULL),('2025-12-05 10:14:30','2025-12-05 10:14:34','2025-12-05 10:14:37',1,'9b6dbb86-483c-4a52-8e94-08bfaf20f2ce','e6a5ef5e-61b3-4e54-9555-ee1cbb276bf0','9bafdb3b1fe74143a7d72b48cf0e4403','794eae12144d44b683392db77e4b46a0','cinder-backup-0',NULL,'tempest-VolumesBackupsV39Test-Backup-73870456','tempest-volume-backup-description-639754222','backups','deleted',NULL,'{\"base\": \"volume-e6a5ef5e-61b3-4e54-9555-ee1cbb276bf0.backup.9b6dbb86-483c-4a52-8e94-08bfaf20f2ce\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:14:30',NULL,NULL),('2025-12-05 10:18:10','2025-12-05 10:18:14','2025-12-05 10:18:15',1,'b683ea36-1e71-4804-8bfa-44c5856dd2ef','c4d37f21-a692-4fd8-a5cf-3ec6f97372f0','0b795e7702e342d9821a3667644be5b0','3554a89b305c449f9fd292eca5647512','cinder-backup-0',NULL,NULL,NULL,'backups','deleted',NULL,'{\"base\": \"volume-c4d37f21-a692-4fd8-a5cf-3ec6f97372f0.backup.c40b7f0c-d291-4bae-8eec-85700357c139\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,'c40b7f0c-d291-4bae-8eec-85700357c139',NULL,NULL,NULL,NULL,'2025-12-05 10:18:10',NULL,NULL),('2025-12-05 10:18:05','2025-12-05 10:18:23','2025-12-05 10:18:24',1,'c40b7f0c-d291-4bae-8eec-85700357c139','c4d37f21-a692-4fd8-a5cf-3ec6f97372f0','0b795e7702e342d9821a3667644be5b0','3554a89b305c449f9fd292eca5647512','cinder-backup-0',NULL,'tempest-VolumesBackupsTest-Backup-857591587',NULL,'backups','deleted',NULL,'{\"base\": \"volume-c4d37f21-a692-4fd8-a5cf-3ec6f97372f0.backup.c40b7f0c-d291-4bae-8eec-85700357c139\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,0,NULL,'2025-12-05 10:18:05',NULL,NULL),('2025-12-05 10:12:26','2025-12-05 10:12:42','2025-12-05 10:12:44',1,'fb2b310c-a127-4cb1-8176-8e0f63a4f16e','e0807f46-fd36-4bd4-bad7-9e310ec0d261','82400d0afa4a43378786350753954e62','02098318982046faa2136ab12b344eb1','cinder-backup-0',NULL,'tempest-VolumesBackupsAdminTest-Backup-507536680',NULL,'backups','deleted',NULL,'{\"base\": \"volume-e0807f46-fd36-4bd4-bad7-9e310ec0d261.backup.fb2b310c-a127-4cb1-8176-8e0f63a4f16e\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:12:26','37411969-9d03-4177-b129-4f96f57802bf',NULL);
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cgsnapshots`
--

DROP TABLE IF EXISTS `cgsnapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cgsnapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `consistencygroup_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_cgsnapshots_consistencygroup_id` (`consistencygroup_id`),
  CONSTRAINT `cgsnapshots_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cgsnapshots`
--

LOCK TABLES `cgsnapshots` WRITE;
/*!40000 ALTER TABLE `cgsnapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `cgsnapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clusters`
--

DROP TABLE IF EXISTS `clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clusters` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`binary`,`race_preventer`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`disabled` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`frozen` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clusters`
--

LOCK TABLES `clusters` WRITE;
/*!40000 ALTER TABLE `clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consistencygroups`
--

DROP TABLE IF EXISTS `consistencygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consistencygroups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `volume_type_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `source_cgid` varchar(36) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consistencygroups`
--

LOCK TABLES `consistencygroups` WRITE;
/*!40000 ALTER TABLE `consistencygroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `consistencygroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_volume_types`
--

DROP TABLE IF EXISTS `default_volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `default_volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  KEY `ix_default_volume_types_volume_type_id` (`volume_type_id`),
  CONSTRAINT `default_volume_types_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_volume_types`
--

LOCK TABLES `default_volume_types` WRITE;
/*!40000 ALTER TABLE `default_volume_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver_initiator_data`
--

DROP TABLE IF EXISTS `driver_initiator_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `driver_initiator_data` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `initiator` (`initiator`,`namespace`,`key`),
  KEY `ix_driver_initiator_data_initiator` (`initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver_initiator_data`
--

LOCK TABLES `driver_initiator_data` WRITE;
/*!40000 ALTER TABLE `driver_initiator_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `driver_initiator_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encryption`
--

DROP TABLE IF EXISTS `encryption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encryption` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `cipher` varchar(255) DEFAULT NULL,
  `control_location` varchar(255) NOT NULL,
  `key_size` int(11) DEFAULT NULL,
  `provider` varchar(255) NOT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `encryption_id` varchar(36) NOT NULL,
  PRIMARY KEY (`encryption_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encryption`
--

LOCK TABLES `encryption` WRITE;
/*!40000 ALTER TABLE `encryption` DISABLE KEYS */;
INSERT INTO `encryption` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `cipher`, `control_location`, `key_size`, `provider`, `volume_type_id`, `encryption_id`) VALUES ('2025-12-05 10:13:41','2025-12-05 10:13:41','2025-12-05 10:13:41',1,'aes-xts-plain64','back-end',128,'SomeProvider','91d167cb-e763-4d84-b94d-94743c339368','63cb7f7c-5107-418b-b071-bc968a6a7910');
/*!40000 ALTER TABLE `encryption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_snapshots`
--

DROP TABLE IF EXISTS `group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_snapshots_group_id` (`group_id`),
  KEY `group_snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `group_snapshots_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_snapshots`
--

LOCK TABLES `group_snapshots` WRITE;
/*!40000 ALTER TABLE `group_snapshots` DISABLE KEYS */;
INSERT INTO `group_snapshots` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `group_id`, `user_id`, `project_id`, `name`, `description`, `status`, `group_type_id`) VALUES ('2025-12-05 10:16:22','2025-12-05 10:16:24','2025-12-05 10:16:25',1,'1e77e3ac-cbd0-4a0a-8cea-1dde02dc345a','33b7f5c2-9f50-4bd9-bddd-e079de9fbb05','0ab0e0dead37412ebd73c839224d4687','ebf51e9cd741494484f25cc0c15bc318','tempest-group_snapshot-1784444075',NULL,'deleted','d104f802-91ee-4ab4-9b76-210fddc57931'),('2025-12-05 10:15:54','2025-12-05 10:16:01','2025-12-05 10:16:02',1,'6f71053d-fe01-44f5-a2aa-e643e7725a0d','78c3eea0-6920-4ee3-a6bc-26417e1ea579','0ab0e0dead37412ebd73c839224d4687','ebf51e9cd741494484f25cc0c15bc318','tempest-group_snapshot-2009358491',NULL,'deleted','ea5376ba-15cf-4a5a-a8b4-b32bc71a842c'),('2025-12-05 10:16:14','2025-12-05 10:16:16','2025-12-05 10:16:18',1,'7b3d1430-4aff-4541-83d0-31770b3122c6','22ef08d1-97ff-480a-8183-dd197e12f3d4','0ab0e0dead37412ebd73c839224d4687','ebf51e9cd741494484f25cc0c15bc318','tempest-GroupSnapshotsTest-Group_Snapshot-656961793',NULL,'deleted','44465d72-753f-47da-8c54-ddd88d4b3f64'),('2025-12-05 10:10:11','2025-12-05 10:10:14','2025-12-05 10:10:14',1,'d9dbcd53-d637-4b7d-a457-f4c6d104a40d','acaed39e-6a84-4939-afff-282d3bbcbfb3','0b6b4749f27a4147ae07b8cb40737288','3e1f2363f1af446095b256c4564bb0fe','tempest-GroupSnapshotsV319Test-Group_Snapshot-757351754',NULL,'deleted','41ab35d2-83b5-464d-a885-42ce1e8a8880');
/*!40000 ALTER TABLE `group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_projects`
--

DROP TABLE IF EXISTS `group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_type_id` (`group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `group_type_projects_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_projects`
--

LOCK TABLES `group_type_projects` WRITE;
/*!40000 ALTER TABLE `group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_specs`
--

DROP TABLE IF EXISTS `group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_type_specs_group_type_id` (`group_type_id`),
  CONSTRAINT `group_type_specs_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_specs`
--

LOCK TABLES `group_type_specs` WRITE;
/*!40000 ALTER TABLE `group_type_specs` DISABLE KEYS */;
INSERT INTO `group_type_specs` (`id`, `key`, `value`, `group_type_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (2,'consistent_group_snapshot_enabled','<is> True','efe1bbaa-9069-4ac9-a498-b701c434dd9a','2025-12-05 08:17:41','2025-12-05 08:17:41',NULL,0),(5,'key1','value1','572ba64d-aeda-4136-994b-786582126dd8','2025-12-05 10:09:42',NULL,'2025-12-05 10:09:42',1),(6,'key2','value2-updated','572ba64d-aeda-4136-994b-786582126dd8','2025-12-05 10:09:42','2025-12-05 10:09:42','2025-12-05 10:09:42',1),(7,'key3','value3-updated','572ba64d-aeda-4136-994b-786582126dd8','2025-12-05 10:09:42','2025-12-05 10:09:42','2025-12-05 10:09:42',1),(8,'consistent_group_snapshot_enabled','<is> False','f74e48df-068b-4976-9b76-6ddf0bf1bdb4','2025-12-05 10:09:53',NULL,'2025-12-05 10:09:53',1);
/*!40000 ALTER TABLE `group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_types`
--

DROP TABLE IF EXISTS `group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_types` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`is_public` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_types`
--

LOCK TABLES `group_types` WRITE;
/*!40000 ALTER TABLE `group_types` DISABLE KEYS */;
INSERT INTO `group_types` (`id`, `name`, `description`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `is_public`) VALUES ('3561e5c5-1bd1-47b9-841c-ca4eb8bc1319','tempest-GroupsV314Test-group-type-917134222',NULL,'2025-12-05 10:12:33',NULL,'2025-12-05 10:12:43',1,1),('3bb52089-f654-4f9d-ab40-9a76b3bd434c','b_tempest-group-type-489809539',NULL,'2025-12-05 10:09:53',NULL,'2025-12-05 10:09:53',1,0),('41ab35d2-83b5-464d-a885-42ce1e8a8880','tempest-GroupSnapshotsV319Test-group-type-1779949411',NULL,'2025-12-05 10:10:08',NULL,'2025-12-05 10:10:17',1,1),('44465d72-753f-47da-8c54-ddd88d4b3f64','tempest-GroupSnapshotsTest-group-type-1225709597',NULL,'2025-12-05 10:16:04',NULL,'2025-12-05 10:16:20',1,1),('572ba64d-aeda-4136-994b-786582126dd8','tempest-GroupTypeSpecsTest-group-type-1091294412',NULL,'2025-12-05 10:09:42',NULL,'2025-12-05 10:09:42',1,1),('a3e93fa2-487c-49ac-8351-26035f35ded3','tempest-GroupsTest-group-type-1938026634',NULL,'2025-12-05 10:15:17',NULL,'2025-12-05 10:15:24',1,1),('c148579a-167a-418e-af18-6d710c4678ca','tempest-GroupsTest-group-type-217061572',NULL,'2025-12-05 10:15:25',NULL,'2025-12-05 10:15:34',1,1),('d104f802-91ee-4ab4-9b76-210fddc57931','tempest-GroupSnapshotsTest-group-type-951219645',NULL,'2025-12-05 10:16:20',NULL,'2025-12-05 10:16:27',1,1),('ea5376ba-15cf-4a5a-a8b4-b32bc71a842c','tempest-GroupSnapshotsTest-group-type-1112380752',NULL,'2025-12-05 10:15:51',NULL,'2025-12-05 10:16:04',1,1),('efe1bbaa-9069-4ac9-a498-b701c434dd9a','default_cgsnapshot_type','Default group type for migrating cgsnapshot','2025-12-05 08:17:41','2025-12-05 08:17:41',NULL,0,1),('f74e48df-068b-4976-9b76-6ddf0bf1bdb4','tempest-GroupTypesTest-updated-group-type-1426007623','updated-group-type-desc','2025-12-05 10:09:53','2025-12-05 10:09:53','2025-12-05 10:09:53',1,1),('fe2ab134-f8c3-4257-b451-5bcf82d58c9b','tempest-GroupsV320Test-group-type-1988468298',NULL,'2025-12-05 10:10:24',NULL,'2025-12-05 10:10:27',1,1),('fe4e2fdd-e139-4c4a-9f66-25177e06dae2','a_tempest-group-type-767198969',NULL,'2025-12-05 10:09:53',NULL,'2025-12-05 10:09:53',1,1);
/*!40000 ALTER TABLE `group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_volume_type_mapping`
--

DROP TABLE IF EXISTS `group_volume_type_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_volume_type_mapping` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_volume_type_mapping_volume_type_id` (`volume_type_id`),
  KEY `ix_group_volume_type_mapping_group_id` (`group_id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_volume_type_mapping`
--

LOCK TABLES `group_volume_type_mapping` WRITE;
/*!40000 ALTER TABLE `group_volume_type_mapping` DISABLE KEYS */;
INSERT INTO `group_volume_type_mapping` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_type_id`, `group_id`) VALUES ('2025-12-05 10:10:08',NULL,'2025-12-05 10:10:16',1,1,'bd320a63-3f97-42bf-ac48-f50309021fde','acaed39e-6a84-4939-afff-282d3bbcbfb3'),('2025-12-05 10:10:25',NULL,'2025-12-05 10:10:26',1,2,'93bf1143-c0ad-4825-b9ce-276674d8c9f2','2b1badb8-6c7c-4427-923e-420ff7e5602c'),('2025-12-05 10:12:33',NULL,'2025-12-05 10:12:43',1,3,'7055fc2e-8543-4138-8cec-14be1b270c4e','fda263fb-81d7-4609-83e2-48ddc0e82dd5'),('2025-12-05 10:12:36',NULL,'2025-12-05 10:12:41',1,4,'7055fc2e-8543-4138-8cec-14be1b270c4e','7b6177b4-b209-4556-9d40-09adf5710b51'),('2025-12-05 10:15:18',NULL,'2025-12-05 10:15:23',1,5,'40b6621d-eb24-4e0d-8dae-814d8a2373cc','b8899b75-c142-41c4-91c7-2e74ddb7a80b'),('2025-12-05 10:15:19',NULL,'2025-12-05 10:15:23',1,6,'40b6621d-eb24-4e0d-8dae-814d8a2373cc','3a6bf360-d592-401d-bb7d-87222909a58e'),('2025-12-05 10:15:25',NULL,'2025-12-05 10:15:34',1,7,'8625fbc3-6d52-4e8a-b238-786ecb766a1a','54312233-8459-4ec4-942b-fa65d622f0ba'),('2025-12-05 10:15:51',NULL,'2025-12-05 10:16:04',1,8,'6e8addcf-37df-4d11-81e1-5968791dd1b8','78c3eea0-6920-4ee3-a6bc-26417e1ea579'),('2025-12-05 10:15:57',NULL,'2025-12-05 10:16:00',1,9,'6e8addcf-37df-4d11-81e1-5968791dd1b8','749cb853-0471-4d0a-806c-4795bc33c18e'),('2025-12-05 10:16:05',NULL,'2025-12-05 10:16:20',1,10,'18d2d611-0b44-4c06-b445-cb3ed9593cbd','22ef08d1-97ff-480a-8183-dd197e12f3d4'),('2025-12-05 10:16:20',NULL,'2025-12-05 10:16:27',1,11,'76db33c3-6505-45eb-b8c1-5b9f9af11b08','33b7f5c2-9f50-4bd9-bddd-e079de9fbb05');
/*!40000 ALTER TABLE `group_volume_type_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `groups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `source_group_id` varchar(36) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
INSERT INTO `groups` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `cluster_name`, `host`, `availability_zone`, `name`, `description`, `group_type_id`, `status`, `group_snapshot_id`, `source_group_id`, `replication_status`) VALUES ('2025-12-05 10:16:05','2025-12-05 10:16:19','2025-12-05 10:16:20',1,'22ef08d1-97ff-480a-8183-dd197e12f3d4','0ab0e0dead37412ebd73c839224d4687','ebf51e9cd741494484f25cc0c15bc318',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupSnapshotsTest-Group-10428843',NULL,'44465d72-753f-47da-8c54-ddd88d4b3f64','deleted',NULL,NULL,'disabled'),('2025-12-05 10:10:25','2025-12-05 10:10:26','2025-12-05 10:10:26',1,'2b1badb8-6c7c-4427-923e-420ff7e5602c','22abec853ab749be848c79b0ad032aeb','f22e077193c5438f8057ad89a3e18cb5',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupsV320Test-Group-1594870845',NULL,'fe2ab134-f8c3-4257-b451-5bcf82d58c9b','deleted',NULL,NULL,'disabled'),('2025-12-05 10:16:20','2025-12-05 10:16:27','2025-12-05 10:16:27',1,'33b7f5c2-9f50-4bd9-bddd-e079de9fbb05','0ab0e0dead37412ebd73c839224d4687','ebf51e9cd741494484f25cc0c15bc318',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupSnapshotsTest-Group-1349216310',NULL,'d104f802-91ee-4ab4-9b76-210fddc57931','deleted',NULL,NULL,'disabled'),('2025-12-05 10:15:19','2025-12-05 10:15:23','2025-12-05 10:15:23',1,'3a6bf360-d592-401d-bb7d-87222909a58e','6545929ffeb5432789d89cea4047c0d5','adb319e7a5f345eeabc757f1c6532ff0',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-Group2-1450871696',NULL,'a3e93fa2-487c-49ac-8351-26035f35ded3','deleted',NULL,NULL,'disabled'),('2025-12-05 10:15:25','2025-12-05 10:15:34','2025-12-05 10:15:34',1,'54312233-8459-4ec4-942b-fa65d622f0ba','6545929ffeb5432789d89cea4047c0d5','adb319e7a5f345eeabc757f1c6532ff0',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','new_group','This is a new group','c148579a-167a-418e-af18-6d710c4678ca','deleted',NULL,NULL,'disabled'),('2025-12-05 10:15:59','2025-12-05 10:16:00','2025-12-05 10:16:00',1,'749cb853-0471-4d0a-806c-4795bc33c18e','0ab0e0dead37412ebd73c839224d4687','ebf51e9cd741494484f25cc0c15bc318',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-Group_from_snap-496666051',NULL,'ea5376ba-15cf-4a5a-a8b4-b32bc71a842c','deleted','6f71053d-fe01-44f5-a2aa-e643e7725a0d',NULL,'disabled'),('2025-12-05 10:15:51','2025-12-05 10:16:04','2025-12-05 10:16:04',1,'78c3eea0-6920-4ee3-a6bc-26417e1ea579','0ab0e0dead37412ebd73c839224d4687','ebf51e9cd741494484f25cc0c15bc318',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupSnapshotsTest-Group-1958656951',NULL,'ea5376ba-15cf-4a5a-a8b4-b32bc71a842c','deleted',NULL,NULL,'disabled'),('2025-12-05 10:12:37','2025-12-05 10:12:41','2025-12-05 10:12:41',1,'7b6177b4-b209-4556-9d40-09adf5710b51','21e1309d538d4062b4e570e9adf457c6','b3bc4618821f4f30856e76f4b3843b68',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-Group_from_grp-2031338919',NULL,'3561e5c5-1bd1-47b9-841c-ca4eb8bc1319','deleted',NULL,'fda263fb-81d7-4609-83e2-48ddc0e82dd5','disabled'),('2025-12-05 10:10:09','2025-12-05 10:10:16','2025-12-05 10:10:16',1,'acaed39e-6a84-4939-afff-282d3bbcbfb3','0b6b4749f27a4147ae07b8cb40737288','3e1f2363f1af446095b256c4564bb0fe',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupSnapshotsV319Test-Group-943310641',NULL,'41ab35d2-83b5-464d-a885-42ce1e8a8880','deleted',NULL,NULL,'disabled'),('2025-12-05 10:15:18','2025-12-05 10:15:23','2025-12-05 10:15:23',1,'b8899b75-c142-41c4-91c7-2e74ddb7a80b','6545929ffeb5432789d89cea4047c0d5','adb319e7a5f345eeabc757f1c6532ff0',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-Group1-1121233061',NULL,'a3e93fa2-487c-49ac-8351-26035f35ded3','deleted',NULL,NULL,'disabled'),('2025-12-05 10:12:33','2025-12-05 10:12:43','2025-12-05 10:12:43',1,'fda263fb-81d7-4609-83e2-48ddc0e82dd5','21e1309d538d4062b4e570e9adf457c6','b3bc4618821f4f30856e76f4b3843b68',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupsV314Test-Group-1368826021',NULL,'3561e5c5-1bd1-47b9-841c-ca4eb8bc1319','deleted',NULL,NULL,'disabled');
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_volume_cache_entries`
--

DROP TABLE IF EXISTS `image_volume_cache_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_volume_cache_entries` (
  `image_updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `image_id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `size` int(11) NOT NULL,
  `last_used` datetime NOT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_volume_cache_entries_image_id` (`image_id`),
  KEY `ix_image_volume_cache_entries_host` (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_volume_cache_entries`
--

LOCK TABLES `image_volume_cache_entries` WRITE;
/*!40000 ALTER TABLE `image_volume_cache_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_volume_cache_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(36) DEFAULT NULL,
  `resource_uuid` varchar(255) DEFAULT NULL,
  `event_id` varchar(255) NOT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `action_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_messages_expires_at` (`expires_at`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
INSERT INTO `messages` (`id`, `project_id`, `request_id`, `resource_type`, `resource_uuid`, `event_id`, `message_level`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `expires_at`, `detail_id`, `action_id`) VALUES ('871b74a4-b0a0-4401-aa64-29a429dfd0ba','870ab348edaf49d180b54cf5daaaacd1','req-db8c7732-1999-4a34-a8da-fbfa665074b1','VOLUME','e24f1921-6f99-470b-9b90-900e76007bf3','VOLUME_VOLUME_001_003','ERROR','2025-12-05 10:12:53',NULL,'2025-12-05 10:12:54',1,'2026-01-04 10:12:53','003','001'),('dbed6abe-0562-45ee-9bd9-4b6d973f554f','870ab348edaf49d180b54cf5daaaacd1','req-81ce21e7-87e9-4eb5-8a31-92557bc5cb1d','VOLUME','fbab6d24-0be5-4f76-8d0f-249a147d9abf','VOLUME_VOLUME_001_003','ERROR','2025-12-05 10:12:55',NULL,'2025-12-05 10:12:56',1,'2026-01-04 10:12:55','003','001');
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrate_version`
--

DROP TABLE IF EXISTS `migrate_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrate_version` (
  `repository_id` varchar(250) NOT NULL,
  `repository_path` text DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`repository_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrate_version`
--

LOCK TABLES `migrate_version` WRITE;
/*!40000 ALTER TABLE `migrate_version` DISABLE KEYS */;
INSERT INTO `migrate_version` (`repository_id`, `repository_path`, `version`) VALUES ('cinder','/usr/lib/python3.9/site-packages/cinder/db/sqlalchemy/migrate_repo',145);
/*!40000 ALTER TABLE `migrate_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quality_of_service_specs`
--

DROP TABLE IF EXISTS `quality_of_service_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quality_of_service_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `specs_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quality_of_service_specs_specs_id` (`specs_id`),
  CONSTRAINT `quality_of_service_specs_ibfk_1` FOREIGN KEY (`specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quality_of_service_specs`
--

LOCK TABLES `quality_of_service_specs` WRITE;
/*!40000 ALTER TABLE `quality_of_service_specs` DISABLE KEYS */;
INSERT INTO `quality_of_service_specs` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `specs_id`, `key`, `value`) VALUES ('2025-12-05 10:15:41',NULL,'2025-12-05 10:15:44',1,'073e2f4a-bcfd-41b2-9082-ff6c5e23d8df','fced0d48-54d9-4b8c-b707-34e01f5d71f8','consumer','front-end'),('2025-12-05 10:15:44',NULL,'2025-12-05 10:15:44',1,'1700aec5-3291-4212-bccc-536a3da97e4f','fced0d48-54d9-4b8c-b707-34e01f5d71f8','iops_bytes','500'),('2025-12-05 10:15:44',NULL,'2025-12-05 10:15:44',1,'1f95a32a-fbf7-417e-815d-3030569fb15e',NULL,'QoS_Specs_Name','tempest-QosSpecsTestJSON-qos-202667223'),('2025-12-05 10:15:44',NULL,'2025-12-05 10:15:44',1,'4043fb73-d00c-4ee2-8e88-6a0580f27dfc','1f95a32a-fbf7-417e-815d-3030569fb15e','consumer','back-end'),('2025-12-05 10:15:41',NULL,'2025-12-05 10:15:44',1,'6ab6df68-07e5-462e-90ab-874aad6e2afb','fced0d48-54d9-4b8c-b707-34e01f5d71f8','read_iops_sec','2000'),('2025-12-05 10:15:44',NULL,'2025-12-05 10:15:44',1,'9540d8b7-d4f9-46d8-a263-af3f7dca3bc0',NULL,'QoS_Specs_Name','tempest-QosSpecsTestJSON-qos-1403372148'),('2025-12-05 10:15:44',NULL,'2025-12-05 10:15:44',1,'99db7dbb-9e0a-4972-a1be-d7cee3580886','9540d8b7-d4f9-46d8-a263-af3f7dca3bc0','consumer','front-end'),('2025-12-05 10:15:44',NULL,'2025-12-05 10:15:44',1,'b8898a25-111b-4b4e-9e0b-0cbc0151787c',NULL,'QoS_Specs_Name','tempest-QosSpecsTestJSON-qos-844436770'),('2025-12-05 10:15:44',NULL,'2025-12-05 10:15:44',1,'eee7abc1-ade9-483f-8851-99b7d1f11ba8','b8898a25-111b-4b4e-9e0b-0cbc0151787c','consumer','both'),('2025-12-05 10:15:41',NULL,'2025-12-05 10:15:44',1,'fced0d48-54d9-4b8c-b707-34e01f5d71f8',NULL,'QoS_Specs_Name','tempest-QosSpecsTestJSON-QoS-406188258');
/*!40000 ALTER TABLE `quality_of_service_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
INSERT INTO `quota_classes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `class_name`, `resource`, `hard_limit`) VALUES ('2025-12-05 08:17:36','2025-12-05 10:13:14',NULL,0,2,'default','volumes',10),('2025-12-05 08:17:36','2025-12-05 10:13:14',NULL,0,5,'default','snapshots',10),('2025-12-05 08:17:36','2025-12-05 10:13:14',NULL,0,8,'default','gigabytes',1000),('2025-12-05 08:17:36',NULL,NULL,0,11,'default','consistencygroups',10),('2025-12-05 08:17:36',NULL,NULL,0,14,'default','per_volume_gigabytes',-1),('2025-12-05 08:17:36',NULL,NULL,0,17,'default','groups',10),('2025-12-05 10:13:13','2025-12-05 10:13:14',NULL,0,20,'default','backups',10),('2025-12-05 10:13:13','2025-12-05 10:13:14',NULL,0,21,'default','backup_gigabytes',1000),('2025-12-05 10:13:13',NULL,NULL,0,22,'default','volumes_tempest-VolumeQuotaClassesTest-volume-type-1281975390',10),('2025-12-05 10:13:13',NULL,NULL,0,23,'default','snapshots_tempest-VolumeQuotaClassesTest-volume-type-1281975390',8),('2025-12-05 10:13:13',NULL,NULL,0,24,'default','gigabytes_tempest-VolumeQuotaClassesTest-volume-type-1281975390',1);
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(300) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `race_preventer` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `quota_usages_project_id_key` (`project_id`,`resource`,`race_preventer`),
  KEY `quota_usage_project_resource_idx` (`project_id`,`resource`),
  KEY `ix_quota_usages_project_id` (`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=224 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
INSERT INTO `quota_usages` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `project_id`, `resource`, `in_use`, `reserved`, `until_refresh`, `race_preventer`) VALUES ('2025-12-05 10:08:15','2025-12-05 10:08:32',NULL,0,1,'6225d95e0a924813958256bdb79de31f','volumes',0,0,NULL,1),('2025-12-05 10:08:15','2025-12-05 10:08:32',NULL,0,2,'6225d95e0a924813958256bdb79de31f','gigabytes',0,0,NULL,1),('2025-12-05 10:08:16','2025-12-05 10:08:32',NULL,0,3,'6225d95e0a924813958256bdb79de31f','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:08:16','2025-12-05 10:08:32',NULL,0,4,'6225d95e0a924813958256bdb79de31f','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:09:07','2025-12-05 10:09:19',NULL,0,5,'49be837e62ee480f80076382c098e61f','volumes',0,0,NULL,1),('2025-12-05 10:09:07','2025-12-05 10:09:19',NULL,0,6,'49be837e62ee480f80076382c098e61f','gigabytes',0,0,NULL,1),('2025-12-05 10:09:07','2025-12-05 10:09:19',NULL,0,7,'49be837e62ee480f80076382c098e61f','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:09:07','2025-12-05 10:09:19',NULL,0,8,'49be837e62ee480f80076382c098e61f','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:09:23','2025-12-05 10:09:25',NULL,0,9,'eb581b3986ff44adaf0d86d376d9c83a','volumes',0,0,NULL,1),('2025-12-05 10:09:23','2025-12-05 10:09:25',NULL,0,10,'eb581b3986ff44adaf0d86d376d9c83a','gigabytes',0,0,NULL,1),('2025-12-05 10:09:23','2025-12-05 10:09:25',NULL,0,11,'eb581b3986ff44adaf0d86d376d9c83a','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:09:23','2025-12-05 10:09:25',NULL,0,12,'eb581b3986ff44adaf0d86d376d9c83a','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:09:29','2025-12-05 10:09:38',NULL,0,13,'2eb8cf0d784b4d188f16c04a39a755a9','volumes',0,0,NULL,1),('2025-12-05 10:09:29','2025-12-05 10:09:38',NULL,0,14,'2eb8cf0d784b4d188f16c04a39a755a9','gigabytes',0,0,NULL,1),('2025-12-05 10:09:29','2025-12-05 10:09:38',NULL,0,15,'2eb8cf0d784b4d188f16c04a39a755a9','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:09:29','2025-12-05 10:09:38',NULL,0,16,'2eb8cf0d784b4d188f16c04a39a755a9','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:10:08','2025-12-05 10:10:16',NULL,0,17,'3e1f2363f1af446095b256c4564bb0fe','groups',0,0,NULL,1),('2025-12-05 10:10:10','2025-12-05 10:10:16',NULL,0,18,'3e1f2363f1af446095b256c4564bb0fe','volumes',0,0,NULL,1),('2025-12-05 10:10:10','2025-12-05 10:10:16',NULL,0,19,'3e1f2363f1af446095b256c4564bb0fe','gigabytes',0,0,NULL,1),('2025-12-05 10:10:10','2025-12-05 10:10:16',NULL,0,20,'3e1f2363f1af446095b256c4564bb0fe','volumes_tempest-GroupSnapshotsV319Test-volume-type-2075304691',0,0,NULL,1),('2025-12-05 10:10:10','2025-12-05 10:10:16',NULL,0,21,'3e1f2363f1af446095b256c4564bb0fe','gigabytes_tempest-GroupSnapshotsV319Test-volume-type-2075304691',0,0,NULL,1),('2025-12-05 10:10:11','2025-12-05 10:10:14',NULL,0,22,'3e1f2363f1af446095b256c4564bb0fe','snapshots',0,0,NULL,1),('2025-12-05 10:10:11','2025-12-05 10:10:14',NULL,0,23,'3e1f2363f1af446095b256c4564bb0fe','snapshots_tempest-GroupSnapshotsV319Test-volume-type-2075304691',0,0,NULL,1),('2025-12-05 10:10:15','2025-12-05 10:10:20',NULL,0,24,'584e347c69994bcbb195242db0534134','volumes',0,0,NULL,1),('2025-12-05 10:10:15','2025-12-05 10:10:20',NULL,0,25,'584e347c69994bcbb195242db0534134','gigabytes',0,0,NULL,1),('2025-12-05 10:10:15','2025-12-05 10:10:20',NULL,0,26,'584e347c69994bcbb195242db0534134','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:10:15','2025-12-05 10:10:20',NULL,0,27,'584e347c69994bcbb195242db0534134','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:10:20','2025-12-05 10:10:21',NULL,0,28,'7864fe2bcb66461095dedc4deed01501','volumes',0,0,NULL,1),('2025-12-05 10:10:20','2025-12-05 10:10:21',NULL,0,29,'7864fe2bcb66461095dedc4deed01501','gigabytes',0,0,NULL,1),('2025-12-05 10:10:20','2025-12-05 10:10:21',NULL,0,30,'7864fe2bcb66461095dedc4deed01501','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:10:20','2025-12-05 10:10:21',NULL,0,31,'7864fe2bcb66461095dedc4deed01501','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:10:20',NULL,NULL,0,32,'7864fe2bcb66461095dedc4deed01501','snapshots',0,0,NULL,1),('2025-12-05 10:10:20',NULL,NULL,0,33,'7864fe2bcb66461095dedc4deed01501','snapshots_tripleo',0,0,NULL,1),('2025-12-05 10:10:20',NULL,NULL,0,34,'584e347c69994bcbb195242db0534134','snapshots',0,0,NULL,1),('2025-12-05 10:10:20',NULL,NULL,0,35,'584e347c69994bcbb195242db0534134','snapshots_tripleo',0,0,NULL,1),('2025-12-05 10:10:25','2025-12-05 10:10:26',NULL,0,36,'f22e077193c5438f8057ad89a3e18cb5','groups',0,0,NULL,1),('2025-12-05 10:10:40','2025-12-05 10:10:44',NULL,0,37,'e3199c4c895043739e357008afbe83c8','volumes',0,0,NULL,1),('2025-12-05 10:10:40','2025-12-05 10:10:44',NULL,0,38,'e3199c4c895043739e357008afbe83c8','gigabytes',0,0,NULL,1),('2025-12-05 10:10:40','2025-12-05 10:10:44',NULL,0,39,'e3199c4c895043739e357008afbe83c8','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:10:40','2025-12-05 10:10:44',NULL,0,40,'e3199c4c895043739e357008afbe83c8','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:10:49','2025-12-05 10:10:57',NULL,0,41,'b984bc032821439da9e14438f496b701','volumes',0,0,NULL,1),('2025-12-05 10:10:49','2025-12-05 10:10:57',NULL,0,42,'b984bc032821439da9e14438f496b701','gigabytes',0,0,NULL,1),('2025-12-05 10:10:49','2025-12-05 10:10:57',NULL,0,43,'b984bc032821439da9e14438f496b701','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:10:49','2025-12-05 10:10:57',NULL,0,44,'b984bc032821439da9e14438f496b701','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:10:50','2025-12-05 10:10:52',NULL,0,45,'b0b9e4dc414946c097d558d4b89e8947','volumes',0,0,NULL,1),('2025-12-05 10:10:50','2025-12-05 10:10:52',NULL,0,46,'b0b9e4dc414946c097d558d4b89e8947','gigabytes',0,0,NULL,1),('2025-12-05 10:10:50','2025-12-05 10:10:52',NULL,0,47,'b0b9e4dc414946c097d558d4b89e8947','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:10:50','2025-12-05 10:10:52',NULL,0,48,'b0b9e4dc414946c097d558d4b89e8947','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:10:51',NULL,NULL,0,49,'b0b9e4dc414946c097d558d4b89e8947','snapshots',0,0,NULL,1),('2025-12-05 10:10:51',NULL,NULL,0,50,'b0b9e4dc414946c097d558d4b89e8947','snapshots_tripleo',0,0,NULL,1),('2025-12-05 10:10:51',NULL,NULL,0,51,'b984bc032821439da9e14438f496b701','snapshots',0,0,NULL,1),('2025-12-05 10:10:51',NULL,NULL,0,52,'b984bc032821439da9e14438f496b701','snapshots_tripleo',0,0,NULL,1),('2025-12-05 10:11:29','2025-12-05 10:11:49',NULL,0,53,'2238ffb217584686904f563705640aa4','volumes',0,0,NULL,1),('2025-12-05 10:11:29','2025-12-05 10:11:49',NULL,0,54,'2238ffb217584686904f563705640aa4','gigabytes',0,0,NULL,1),('2025-12-05 10:11:29','2025-12-05 10:11:49',NULL,0,55,'2238ffb217584686904f563705640aa4','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:11:29','2025-12-05 10:11:49',NULL,0,56,'2238ffb217584686904f563705640aa4','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:11:58','2025-12-05 10:12:00',NULL,0,57,'07ccd9396684429596646bded13e438a','volumes',0,0,NULL,1),('2025-12-05 10:11:58','2025-12-05 10:12:00',NULL,0,58,'07ccd9396684429596646bded13e438a','gigabytes',0,0,NULL,1),('2025-12-05 10:11:58','2025-12-05 10:12:00',NULL,0,59,'07ccd9396684429596646bded13e438a','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:11:58','2025-12-05 10:12:00',NULL,0,60,'07ccd9396684429596646bded13e438a','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:12:05','2025-12-05 10:12:21',NULL,0,61,'9e3d3287162a4caabf625f0490cbd91d','volumes',0,0,NULL,1),('2025-12-05 10:12:05','2025-12-05 10:12:21',NULL,0,62,'9e3d3287162a4caabf625f0490cbd91d','gigabytes',0,0,NULL,1),('2025-12-05 10:12:05','2025-12-05 10:12:21',NULL,0,63,'9e3d3287162a4caabf625f0490cbd91d','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:12:05','2025-12-05 10:12:21',NULL,0,64,'9e3d3287162a4caabf625f0490cbd91d','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:12:06','2025-12-05 10:12:19',NULL,0,65,'9e3d3287162a4caabf625f0490cbd91d','snapshots',0,0,NULL,1),('2025-12-05 10:12:07','2025-12-05 10:12:19',NULL,0,66,'9e3d3287162a4caabf625f0490cbd91d','snapshots_tripleo',0,0,NULL,1),('2025-12-05 10:12:07','2025-12-05 10:12:14',NULL,0,67,'9b06ebc1eb5f4622b3198559907b39ec','volumes',0,0,NULL,1),('2025-12-05 10:12:07','2025-12-05 10:12:14',NULL,0,68,'9b06ebc1eb5f4622b3198559907b39ec','gigabytes',0,0,NULL,1),('2025-12-05 10:12:07','2025-12-05 10:12:14',NULL,0,69,'9b06ebc1eb5f4622b3198559907b39ec','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:12:07','2025-12-05 10:12:14',NULL,0,70,'9b06ebc1eb5f4622b3198559907b39ec','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:12:09','2025-12-05 10:12:13',NULL,0,71,'9b06ebc1eb5f4622b3198559907b39ec','snapshots',0,0,NULL,1),('2025-12-05 10:12:09','2025-12-05 10:12:13',NULL,0,72,'9b06ebc1eb5f4622b3198559907b39ec','snapshots_tripleo',0,0,NULL,1),('2025-12-05 10:12:24','2025-12-05 10:12:59',NULL,0,73,'02098318982046faa2136ab12b344eb1','volumes',0,0,NULL,1),('2025-12-05 10:12:24','2025-12-05 10:12:59',NULL,0,74,'02098318982046faa2136ab12b344eb1','gigabytes',0,0,NULL,1),('2025-12-05 10:12:24','2025-12-05 10:12:59',NULL,0,75,'02098318982046faa2136ab12b344eb1','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:12:24','2025-12-05 10:12:59',NULL,0,76,'02098318982046faa2136ab12b344eb1','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:12:26','2025-12-05 10:12:57',NULL,0,77,'02098318982046faa2136ab12b344eb1','backups',0,0,NULL,1),('2025-12-05 10:12:26','2025-12-05 10:12:57',NULL,0,78,'02098318982046faa2136ab12b344eb1','backup_gigabytes',0,0,NULL,1),('2025-12-05 10:12:27','2025-12-05 10:12:31',NULL,0,79,'ef76e1242a6d41498f75478c52cab8e4','volumes',0,0,NULL,1),('2025-12-05 10:12:27','2025-12-05 10:12:31',NULL,0,80,'ef76e1242a6d41498f75478c52cab8e4','gigabytes',0,0,NULL,1),('2025-12-05 10:12:27','2025-12-05 10:12:31',NULL,0,81,'ef76e1242a6d41498f75478c52cab8e4','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:12:27','2025-12-05 10:12:31',NULL,0,82,'ef76e1242a6d41498f75478c52cab8e4','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:12:28','2025-12-05 10:12:30',NULL,0,83,'ef76e1242a6d41498f75478c52cab8e4','snapshots',0,0,NULL,1),('2025-12-05 10:12:28','2025-12-05 10:12:30',NULL,0,84,'ef76e1242a6d41498f75478c52cab8e4','snapshots_tripleo',0,0,NULL,1),('2025-12-05 10:12:33','2025-12-05 10:12:43',NULL,0,85,'b3bc4618821f4f30856e76f4b3843b68','groups',0,0,NULL,1),('2025-12-05 10:12:33','2025-12-05 10:12:42',NULL,0,86,'c70f526bca874e278b9e8fa9cbae7937','backups',0,0,NULL,1),('2025-12-05 10:12:33','2025-12-05 10:12:42',NULL,0,87,'c70f526bca874e278b9e8fa9cbae7937','backup_gigabytes',0,0,NULL,1),('2025-12-05 10:12:34','2025-12-05 10:12:43',NULL,0,88,'b3bc4618821f4f30856e76f4b3843b68','volumes',0,0,NULL,1),('2025-12-05 10:12:34','2025-12-05 10:12:43',NULL,0,89,'b3bc4618821f4f30856e76f4b3843b68','gigabytes',0,0,NULL,1),('2025-12-05 10:12:34','2025-12-05 10:12:43',NULL,0,90,'b3bc4618821f4f30856e76f4b3843b68','volumes_tempest-GroupsV314Test-volume-type-2079195531',0,0,NULL,1),('2025-12-05 10:12:34','2025-12-05 10:12:43',NULL,0,91,'b3bc4618821f4f30856e76f4b3843b68','gigabytes_tempest-GroupsV314Test-volume-type-2079195531',0,0,NULL,1),('2025-12-05 10:12:52','2025-12-05 10:12:57',NULL,0,92,'870ab348edaf49d180b54cf5daaaacd1','volumes',0,0,NULL,1),('2025-12-05 10:12:52','2025-12-05 10:12:57',NULL,0,93,'870ab348edaf49d180b54cf5daaaacd1','gigabytes',0,0,NULL,1),('2025-12-05 10:12:52','2025-12-05 10:12:54',NULL,0,94,'870ab348edaf49d180b54cf5daaaacd1','volumes_tempest-UserMessagesTest-volume-type-447267446',0,0,NULL,1),('2025-12-05 10:12:52','2025-12-05 10:12:54',NULL,0,95,'870ab348edaf49d180b54cf5daaaacd1','gigabytes_tempest-UserMessagesTest-volume-type-447267446',0,0,NULL,1),('2025-12-05 10:12:55','2025-12-05 10:12:57',NULL,0,96,'870ab348edaf49d180b54cf5daaaacd1','volumes_tempest-UserMessagesTest-volume-type-1380476665',0,0,NULL,1),('2025-12-05 10:12:55','2025-12-05 10:12:57',NULL,0,97,'870ab348edaf49d180b54cf5daaaacd1','gigabytes_tempest-UserMessagesTest-volume-type-1380476665',0,0,NULL,1),('2025-12-05 10:13:15','2025-12-05 10:13:26',NULL,0,98,'e230ba0d257c46a2bc100d033851d6b1','volumes',0,0,NULL,1),('2025-12-05 10:13:15','2025-12-05 10:13:26',NULL,0,99,'e230ba0d257c46a2bc100d033851d6b1','gigabytes',0,0,NULL,1),('2025-12-05 10:13:15','2025-12-05 10:13:26',NULL,0,100,'e230ba0d257c46a2bc100d033851d6b1','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:13:15','2025-12-05 10:13:26',NULL,0,101,'e230ba0d257c46a2bc100d033851d6b1','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:13:20','2025-12-05 10:13:24',NULL,0,102,'7fb1a3e2a7114f43b78f20d94b35a6b0','volumes',0,0,NULL,1),('2025-12-05 10:13:20','2025-12-05 10:13:24',NULL,0,103,'7fb1a3e2a7114f43b78f20d94b35a6b0','gigabytes',0,0,NULL,1),('2025-12-05 10:13:20','2025-12-05 10:13:24',NULL,0,104,'7fb1a3e2a7114f43b78f20d94b35a6b0','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:13:20','2025-12-05 10:13:24',NULL,0,105,'7fb1a3e2a7114f43b78f20d94b35a6b0','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:13:25','2025-12-05 10:13:30',NULL,0,106,'f67828d1e0ec494fbab56cc9be72430e','volumes',0,0,NULL,1),('2025-12-05 10:13:25','2025-12-05 10:13:30',NULL,0,107,'f67828d1e0ec494fbab56cc9be72430e','gigabytes',0,0,NULL,1),('2025-12-05 10:13:25','2025-12-05 10:13:30',NULL,0,108,'f67828d1e0ec494fbab56cc9be72430e','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:13:25','2025-12-05 10:13:30',NULL,0,109,'f67828d1e0ec494fbab56cc9be72430e','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:13:42','2025-12-05 10:13:51',NULL,0,110,'a5cc8e8a222a4340a4dc0e0a353a820c','volumes',0,0,NULL,1),('2025-12-05 10:13:42','2025-12-05 10:13:51',NULL,0,111,'a5cc8e8a222a4340a4dc0e0a353a820c','gigabytes',0,0,NULL,1),('2025-12-05 10:13:42','2025-12-05 10:13:51',NULL,0,112,'a5cc8e8a222a4340a4dc0e0a353a820c','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:13:42','2025-12-05 10:13:51',NULL,0,113,'a5cc8e8a222a4340a4dc0e0a353a820c','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:13:43','2025-12-05 10:13:46',NULL,0,114,'11c68ad07fe34e07ad5a591f23d30263','volumes',0,0,NULL,1),('2025-12-05 10:13:43','2025-12-05 10:13:46',NULL,0,115,'11c68ad07fe34e07ad5a591f23d30263','gigabytes',0,0,NULL,1),('2025-12-05 10:13:43','2025-12-05 10:13:46',NULL,0,116,'11c68ad07fe34e07ad5a591f23d30263','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:13:43','2025-12-05 10:13:46',NULL,0,117,'11c68ad07fe34e07ad5a591f23d30263','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:13:44',NULL,NULL,0,118,'11c68ad07fe34e07ad5a591f23d30263','snapshots',0,0,NULL,1),('2025-12-05 10:13:44',NULL,NULL,0,119,'11c68ad07fe34e07ad5a591f23d30263','snapshots_tripleo',0,0,NULL,1),('2025-12-05 10:13:44',NULL,NULL,0,120,'a5cc8e8a222a4340a4dc0e0a353a820c','snapshots',0,0,NULL,1),('2025-12-05 10:13:44',NULL,NULL,0,121,'a5cc8e8a222a4340a4dc0e0a353a820c','snapshots_tripleo',0,0,NULL,1),('2025-12-05 10:13:53','2025-12-05 10:14:17',NULL,0,122,'cc5978fe065b4f80b1bc25ce32164997','volumes',0,0,NULL,1),('2025-12-05 10:13:53','2025-12-05 10:14:17',NULL,0,123,'cc5978fe065b4f80b1bc25ce32164997','gigabytes',0,0,NULL,1),('2025-12-05 10:13:53','2025-12-05 10:14:17',NULL,0,124,'cc5978fe065b4f80b1bc25ce32164997','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:13:53','2025-12-05 10:14:17',NULL,0,125,'cc5978fe065b4f80b1bc25ce32164997','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:13:54','2025-12-05 10:14:14',NULL,0,126,'cc5978fe065b4f80b1bc25ce32164997','snapshots',0,0,NULL,1),('2025-12-05 10:13:54','2025-12-05 10:14:14',NULL,0,127,'cc5978fe065b4f80b1bc25ce32164997','snapshots_tripleo',0,0,NULL,1),('2025-12-05 10:14:17','2025-12-05 10:15:18',NULL,0,128,'8730b222fadf4a249823e59d8b326dde','volumes',0,0,NULL,1),('2025-12-05 10:14:17','2025-12-05 10:15:18',NULL,0,129,'8730b222fadf4a249823e59d8b326dde','gigabytes',0,0,NULL,1),('2025-12-05 10:14:17','2025-12-05 10:15:18',NULL,0,130,'8730b222fadf4a249823e59d8b326dde','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:14:17','2025-12-05 10:15:18',NULL,0,131,'8730b222fadf4a249823e59d8b326dde','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:14:26','2025-12-05 10:15:06',NULL,0,132,'828c13ab111f4c1d9f4fe33b1ba5f907','volumes',0,0,NULL,1),('2025-12-05 10:14:26','2025-12-05 10:15:06',NULL,0,133,'828c13ab111f4c1d9f4fe33b1ba5f907','gigabytes',0,0,NULL,1),('2025-12-05 10:14:26','2025-12-05 10:15:06',NULL,0,134,'828c13ab111f4c1d9f4fe33b1ba5f907','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:14:26','2025-12-05 10:15:06',NULL,0,135,'828c13ab111f4c1d9f4fe33b1ba5f907','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:14:28','2025-12-05 10:14:42',NULL,0,136,'794eae12144d44b683392db77e4b46a0','volumes',0,0,NULL,1),('2025-12-05 10:14:28','2025-12-05 10:14:42',NULL,0,137,'794eae12144d44b683392db77e4b46a0','gigabytes',0,0,NULL,1),('2025-12-05 10:14:28','2025-12-05 10:14:42',NULL,0,138,'794eae12144d44b683392db77e4b46a0','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:14:28','2025-12-05 10:14:42',NULL,0,139,'794eae12144d44b683392db77e4b46a0','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:14:30','2025-12-05 10:14:37',NULL,0,140,'794eae12144d44b683392db77e4b46a0','backups',0,0,NULL,1),('2025-12-05 10:14:30','2025-12-05 10:14:37',NULL,0,141,'794eae12144d44b683392db77e4b46a0','backup_gigabytes',0,0,NULL,1),('2025-12-05 10:14:47','2025-12-05 10:15:12',NULL,0,142,'c8125d7d8c2c4e869c6cf854824ed1f9','volumes',0,0,NULL,1),('2025-12-05 10:14:47','2025-12-05 10:15:12',NULL,0,143,'c8125d7d8c2c4e869c6cf854824ed1f9','gigabytes',0,0,NULL,1),('2025-12-05 10:14:47','2025-12-05 10:15:12',NULL,0,144,'c8125d7d8c2c4e869c6cf854824ed1f9','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:14:47','2025-12-05 10:15:12',NULL,0,145,'c8125d7d8c2c4e869c6cf854824ed1f9','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:15:05','2025-12-05 10:15:09',NULL,0,146,'c8125d7d8c2c4e869c6cf854824ed1f9','snapshots',0,0,NULL,1),('2025-12-05 10:15:05','2025-12-05 10:15:09',NULL,0,147,'c8125d7d8c2c4e869c6cf854824ed1f9','snapshots_tripleo',0,0,NULL,1),('2025-12-05 10:15:12','2025-12-05 10:15:23',NULL,0,148,'1a4ef1e0bdbf479f861daafd49015589','volumes',0,0,NULL,1),('2025-12-05 10:15:12','2025-12-05 10:15:23',NULL,0,149,'1a4ef1e0bdbf479f861daafd49015589','gigabytes',0,0,NULL,1),('2025-12-05 10:15:12','2025-12-05 10:15:23',NULL,0,150,'1a4ef1e0bdbf479f861daafd49015589','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:15:12','2025-12-05 10:15:23',NULL,0,151,'1a4ef1e0bdbf479f861daafd49015589','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:15:18','2025-12-05 10:15:34',NULL,0,152,'adb319e7a5f345eeabc757f1c6532ff0','groups',0,0,NULL,1),('2025-12-05 10:15:20','2025-12-05 10:15:34',NULL,0,153,'adb319e7a5f345eeabc757f1c6532ff0','volumes',0,0,NULL,1),('2025-12-05 10:15:20','2025-12-05 10:15:34',NULL,0,154,'adb319e7a5f345eeabc757f1c6532ff0','gigabytes',0,0,NULL,1),('2025-12-05 10:15:20','2025-12-05 10:15:23',NULL,0,155,'adb319e7a5f345eeabc757f1c6532ff0','volumes_tempest-GroupsTest-volume-type-1339094509',0,0,NULL,1),('2025-12-05 10:15:20','2025-12-05 10:15:23',NULL,0,156,'adb319e7a5f345eeabc757f1c6532ff0','gigabytes_tempest-GroupsTest-volume-type-1339094509',0,0,NULL,1),('2025-12-05 10:15:26','2025-12-05 10:15:34',NULL,0,157,'adb319e7a5f345eeabc757f1c6532ff0','volumes_tempest-GroupsTest-volume-type-211870054',0,0,NULL,1),('2025-12-05 10:15:26','2025-12-05 10:15:34',NULL,0,158,'adb319e7a5f345eeabc757f1c6532ff0','gigabytes_tempest-GroupsTest-volume-type-211870054',0,0,NULL,1),('2025-12-05 10:15:51','2025-12-05 10:16:27',NULL,0,159,'ebf51e9cd741494484f25cc0c15bc318','groups',0,0,NULL,1),('2025-12-05 10:15:52','2025-12-05 10:16:27',NULL,0,160,'ebf51e9cd741494484f25cc0c15bc318','volumes',0,0,NULL,1),('2025-12-05 10:15:52','2025-12-05 10:16:27',NULL,0,161,'ebf51e9cd741494484f25cc0c15bc318','gigabytes',0,0,NULL,1),('2025-12-05 10:15:52','2025-12-05 10:16:04',NULL,0,162,'ebf51e9cd741494484f25cc0c15bc318','volumes_tempest-GroupSnapshotsTest-volume-type-742511643',0,0,NULL,1),('2025-12-05 10:15:52','2025-12-05 10:16:02',NULL,0,163,'ebf51e9cd741494484f25cc0c15bc318','gigabytes_tempest-GroupSnapshotsTest-volume-type-742511643',0,0,NULL,1),('2025-12-05 10:15:53','2025-12-05 10:16:15',NULL,0,164,'ee708d36384c422aad0ff42f0242e9cf','volumes',0,0,NULL,1),('2025-12-05 10:15:53','2025-12-05 10:16:15',NULL,0,165,'ee708d36384c422aad0ff42f0242e9cf','gigabytes',0,0,NULL,1),('2025-12-05 10:15:55','2025-12-05 10:16:15',NULL,0,166,'ee708d36384c422aad0ff42f0242e9cf','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:15:55','2025-12-05 10:16:15',NULL,0,167,'ee708d36384c422aad0ff42f0242e9cf','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:15:55','2025-12-05 10:16:25',NULL,0,168,'ebf51e9cd741494484f25cc0c15bc318','snapshots',0,0,NULL,1),('2025-12-05 10:15:55','2025-12-05 10:16:02',NULL,0,169,'ebf51e9cd741494484f25cc0c15bc318','snapshots_tempest-GroupSnapshotsTest-volume-type-742511643',0,0,NULL,1),('2025-12-05 10:15:56','2025-12-05 10:16:14',NULL,0,170,'ee708d36384c422aad0ff42f0242e9cf','snapshots',0,0,NULL,1),('2025-12-05 10:15:56','2025-12-05 10:16:14',NULL,0,171,'ee708d36384c422aad0ff42f0242e9cf','snapshots_tripleo',0,0,NULL,1),('2025-12-05 10:16:06','2025-12-05 10:16:19',NULL,0,172,'ebf51e9cd741494484f25cc0c15bc318','volumes_tempest-GroupSnapshotsTest-volume-type-2140127089',0,0,NULL,1),('2025-12-05 10:16:06','2025-12-05 10:16:19',NULL,0,173,'ebf51e9cd741494484f25cc0c15bc318','gigabytes_tempest-GroupSnapshotsTest-volume-type-2140127089',0,0,NULL,1),('2025-12-05 10:16:14','2025-12-05 10:16:18',NULL,0,174,'ebf51e9cd741494484f25cc0c15bc318','snapshots_tempest-GroupSnapshotsTest-volume-type-2140127089',0,0,NULL,1),('2025-12-05 10:16:20','2025-12-05 10:16:23',NULL,0,175,'86adc92ecf4e492cbe37cc410ae29e2f','volumes',0,0,NULL,1),('2025-12-05 10:16:20','2025-12-05 10:16:23',NULL,0,176,'86adc92ecf4e492cbe37cc410ae29e2f','gigabytes',0,0,NULL,1),('2025-12-05 10:16:20','2025-12-05 10:16:21',NULL,0,177,'86adc92ecf4e492cbe37cc410ae29e2f','volumes_volume-type-1',0,0,NULL,1),('2025-12-05 10:16:20','2025-12-05 10:16:21',NULL,0,178,'86adc92ecf4e492cbe37cc410ae29e2f','gigabytes_volume-type-1',0,0,NULL,1),('2025-12-05 10:16:21','2025-12-05 10:16:23',NULL,0,179,'86adc92ecf4e492cbe37cc410ae29e2f','volumes_volume-type-2',0,0,NULL,1),('2025-12-05 10:16:21','2025-12-05 10:16:23',NULL,0,180,'86adc92ecf4e492cbe37cc410ae29e2f','gigabytes_volume-type-2',0,0,NULL,1),('2025-12-05 10:16:21','2025-12-05 10:16:27',NULL,0,181,'ebf51e9cd741494484f25cc0c15bc318','volumes_tempest-GroupSnapshotsTest-volume-type-1934963370',0,0,NULL,1),('2025-12-05 10:16:21','2025-12-05 10:16:27',NULL,0,182,'ebf51e9cd741494484f25cc0c15bc318','gigabytes_tempest-GroupSnapshotsTest-volume-type-1934963370',0,0,NULL,1),('2025-12-05 10:16:22','2025-12-05 10:16:25',NULL,0,183,'ebf51e9cd741494484f25cc0c15bc318','snapshots_tempest-GroupSnapshotsTest-volume-type-1934963370',0,0,NULL,1),('2025-12-05 10:16:30','2025-12-05 10:16:31',NULL,0,184,'ca51bf8141824cad9d5dcaf468d3909b','volumes',0,0,NULL,1),('2025-12-05 10:16:30','2025-12-05 10:16:31',NULL,0,185,'ca51bf8141824cad9d5dcaf468d3909b','gigabytes',0,0,NULL,1),('2025-12-05 10:16:30','2025-12-05 10:16:31',NULL,0,186,'ca51bf8141824cad9d5dcaf468d3909b','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:16:30','2025-12-05 10:16:31',NULL,0,187,'ca51bf8141824cad9d5dcaf468d3909b','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:16:34','2025-12-05 10:16:36',NULL,0,188,'86ef6c5dc1f040a8b67b31bc6f6dc5dd','volumes',0,0,NULL,1),('2025-12-05 10:16:34','2025-12-05 10:16:36',NULL,0,189,'86ef6c5dc1f040a8b67b31bc6f6dc5dd','gigabytes',0,0,NULL,1),('2025-12-05 10:16:34','2025-12-05 10:16:36',NULL,0,190,'86ef6c5dc1f040a8b67b31bc6f6dc5dd','volumes_tempest-VolumeTypesAccessTest-volume-type-1193441138',0,0,NULL,1),('2025-12-05 10:16:34','2025-12-05 10:16:36',NULL,0,191,'86ef6c5dc1f040a8b67b31bc6f6dc5dd','gigabytes_tempest-VolumeTypesAccessTest-volume-type-1193441138',0,0,NULL,1),('2025-12-05 10:16:45','2025-12-05 10:16:50',NULL,0,192,'b0b002e8666a4d4c8dd3481cd357bc82','volumes',0,0,NULL,1),('2025-12-05 10:16:45','2025-12-05 10:16:50',NULL,0,193,'b0b002e8666a4d4c8dd3481cd357bc82','gigabytes',0,0,NULL,1),('2025-12-05 10:16:45','2025-12-05 10:16:50',NULL,0,194,'b0b002e8666a4d4c8dd3481cd357bc82','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:16:45','2025-12-05 10:16:50',NULL,0,195,'b0b002e8666a4d4c8dd3481cd357bc82','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:16:46','2025-12-05 10:16:49',NULL,0,196,'b0b002e8666a4d4c8dd3481cd357bc82','snapshots',0,0,NULL,1),('2025-12-05 10:16:46','2025-12-05 10:16:49',NULL,0,197,'b0b002e8666a4d4c8dd3481cd357bc82','snapshots_tripleo',0,0,NULL,1),('2025-12-05 10:16:53','2025-12-05 10:18:34',NULL,0,198,'3554a89b305c449f9fd292eca5647512','volumes',0,0,NULL,1),('2025-12-05 10:16:53','2025-12-05 10:18:34',NULL,0,199,'3554a89b305c449f9fd292eca5647512','gigabytes',0,0,NULL,1),('2025-12-05 10:16:53','2025-12-05 10:18:34',NULL,0,200,'3554a89b305c449f9fd292eca5647512','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:16:53','2025-12-05 10:18:34',NULL,0,201,'3554a89b305c449f9fd292eca5647512','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:16:57','2025-12-05 10:17:02',NULL,0,202,'d088e308e3994594b72dd5ba899ec7e3','volumes',0,0,NULL,1),('2025-12-05 10:16:57','2025-12-05 10:17:02',NULL,0,203,'d088e308e3994594b72dd5ba899ec7e3','gigabytes',0,0,NULL,1),('2025-12-05 10:16:57','2025-12-05 10:17:02',NULL,0,204,'d088e308e3994594b72dd5ba899ec7e3','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:16:57','2025-12-05 10:17:02',NULL,0,205,'d088e308e3994594b72dd5ba899ec7e3','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:16:58','2025-12-05 10:17:00',NULL,0,206,'5e9a7e52b379438eab65d860aa70af42','volumes',0,0,NULL,1),('2025-12-05 10:16:58','2025-12-05 10:17:00',NULL,0,207,'5e9a7e52b379438eab65d860aa70af42','gigabytes',0,0,NULL,1),('2025-12-05 10:16:58','2025-12-05 10:17:00',NULL,0,208,'5e9a7e52b379438eab65d860aa70af42','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:16:58','2025-12-05 10:17:00',NULL,0,209,'5e9a7e52b379438eab65d860aa70af42','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:16:58',NULL,NULL,0,210,'5e9a7e52b379438eab65d860aa70af42','snapshots',0,0,NULL,1),('2025-12-05 10:16:58',NULL,NULL,0,211,'5e9a7e52b379438eab65d860aa70af42','snapshots_tripleo',0,0,NULL,1),('2025-12-05 10:16:59',NULL,NULL,0,212,'d088e308e3994594b72dd5ba899ec7e3','snapshots',0,0,NULL,1),('2025-12-05 10:16:59',NULL,NULL,0,213,'d088e308e3994594b72dd5ba899ec7e3','snapshots_tripleo',0,0,NULL,1),('2025-12-05 10:17:00','2025-12-05 10:18:24',NULL,0,214,'3554a89b305c449f9fd292eca5647512','backups',0,0,NULL,1),('2025-12-05 10:17:00','2025-12-05 10:18:24',NULL,0,215,'3554a89b305c449f9fd292eca5647512','backup_gigabytes',0,0,NULL,1),('2025-12-05 10:18:53','2025-12-05 10:19:38',NULL,0,216,'a6e8880ab10e4b26b0074c6f9b06aca3','volumes',0,0,NULL,1),('2025-12-05 10:18:53','2025-12-05 10:19:38',NULL,0,217,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes',0,0,NULL,1),('2025-12-05 10:18:53','2025-12-05 10:19:38',NULL,0,218,'a6e8880ab10e4b26b0074c6f9b06aca3','volumes_tripleo',0,0,NULL,1),('2025-12-05 10:18:53','2025-12-05 10:19:38',NULL,0,219,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes_tripleo',0,0,NULL,1),('2025-12-05 10:18:54','2025-12-05 10:19:36',NULL,0,220,'a6e8880ab10e4b26b0074c6f9b06aca3','snapshots',0,0,NULL,1),('2025-12-05 10:18:54','2025-12-05 10:19:36',NULL,0,221,'a6e8880ab10e4b26b0074c6f9b06aca3','snapshots_tripleo',0,0,NULL,1),('2025-12-05 10:18:56','2025-12-05 10:19:15',NULL,0,222,'a6e8880ab10e4b26b0074c6f9b06aca3','backups',0,0,NULL,1),('2025-12-05 10:18:56','2025-12-05 10:19:15',NULL,0,223,'a6e8880ab10e4b26b0074c6f9b06aca3','backup_gigabytes',0,0,NULL,1);
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `allocated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
INSERT INTO `quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `project_id`, `resource`, `hard_limit`, `allocated`) VALUES (1,'2025-12-05 10:10:15','2025-12-05 10:10:15','2025-12-05 10:10:15',1,'584e347c69994bcbb195242db0534134','volumes',15,0),(2,'2025-12-05 10:10:15','2025-12-05 10:10:21',NULL,0,'584e347c69994bcbb195242db0534134','volumes',10,0),(3,'2025-12-05 10:10:15','2025-12-05 10:10:22',NULL,0,'584e347c69994bcbb195242db0534134','per_volume_gigabytes',-1,0),(4,'2025-12-05 10:10:15','2025-12-05 10:10:22',NULL,0,'584e347c69994bcbb195242db0534134','snapshots',10,0),(5,'2025-12-05 10:10:15','2025-12-05 10:10:22',NULL,0,'584e347c69994bcbb195242db0534134','gigabytes',1000,0),(6,'2025-12-05 10:10:15','2025-12-05 10:10:22',NULL,0,'584e347c69994bcbb195242db0534134','backups',10,0),(7,'2025-12-05 10:10:15','2025-12-05 10:10:22',NULL,0,'584e347c69994bcbb195242db0534134','backup_gigabytes',1000,0),(8,'2025-12-05 10:12:07','2025-12-05 10:12:15',NULL,0,'9b06ebc1eb5f4622b3198559907b39ec','gigabytes',1000,0),(9,'2025-12-05 10:12:07','2025-12-05 10:12:15',NULL,0,'9b06ebc1eb5f4622b3198559907b39ec','volumes',10,0),(10,'2025-12-05 10:12:07','2025-12-05 10:12:15',NULL,0,'9b06ebc1eb5f4622b3198559907b39ec','snapshots',10,0),(11,'2025-12-05 10:12:15',NULL,NULL,0,'9b06ebc1eb5f4622b3198559907b39ec','per_volume_gigabytes',-1,0),(12,'2025-12-05 10:12:15',NULL,NULL,0,'9b06ebc1eb5f4622b3198559907b39ec','backups',10,0),(13,'2025-12-05 10:12:15',NULL,NULL,0,'9b06ebc1eb5f4622b3198559907b39ec','backup_gigabytes',1000,0),(14,'2025-12-05 10:13:26','2025-12-05 10:13:30',NULL,0,'f67828d1e0ec494fbab56cc9be72430e','gigabytes',1000,0),(15,'2025-12-05 10:13:26','2025-12-05 10:13:30',NULL,0,'f67828d1e0ec494fbab56cc9be72430e','volumes',10,0),(16,'2025-12-05 10:13:30',NULL,NULL,0,'f67828d1e0ec494fbab56cc9be72430e','per_volume_gigabytes',-1,0),(17,'2025-12-05 10:13:30',NULL,NULL,0,'f67828d1e0ec494fbab56cc9be72430e','snapshots',10,0),(18,'2025-12-05 10:13:30',NULL,NULL,0,'f67828d1e0ec494fbab56cc9be72430e','backups',10,0),(19,'2025-12-05 10:13:30',NULL,NULL,0,'f67828d1e0ec494fbab56cc9be72430e','backup_gigabytes',1000,0);
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `allocated_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  KEY `ix_reservations_usage_id` (`usage_id`),
  KEY `reservations_deleted_uuid_idx` (`deleted`,`uuid`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `ix_reservations_allocated_id` (`allocated_id`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`),
  CONSTRAINT `reservations_ibfk_2` FOREIGN KEY (`allocated_id`) REFERENCES `quotas` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=925 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
INSERT INTO `reservations` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `uuid`, `usage_id`, `project_id`, `resource`, `delta`, `expire`, `allocated_id`) VALUES ('2025-12-05 10:08:16','2025-12-05 10:08:16','2025-12-05 10:08:16',1,1,'1e2e3b21-95af-4c2b-8ec8-ec90b82a45da',1,'6225d95e0a924813958256bdb79de31f','volumes',1,'2025-12-06 10:08:15',NULL),('2025-12-05 10:08:16','2025-12-05 10:08:16','2025-12-05 10:08:16',1,2,'0a1040b4-3576-4622-9ef3-83606bbc7183',2,'6225d95e0a924813958256bdb79de31f','gigabytes',1,'2025-12-06 10:08:15',NULL),('2025-12-05 10:08:16','2025-12-05 10:08:16','2025-12-05 10:08:16',1,3,'0884859a-6c3a-4e33-af38-7222ca308363',3,'6225d95e0a924813958256bdb79de31f','volumes_tripleo',1,'2025-12-06 10:08:15',NULL),('2025-12-05 10:08:16','2025-12-05 10:08:16','2025-12-05 10:08:16',1,4,'166e54f1-570c-4598-8d53-f208432d94af',4,'6225d95e0a924813958256bdb79de31f','gigabytes_tripleo',1,'2025-12-06 10:08:15',NULL),('2025-12-05 10:08:20','2025-12-05 10:08:20','2025-12-05 10:08:20',1,5,'ff2be57d-d2fd-4358-a4dc-e4ed8528f7b6',1,'6225d95e0a924813958256bdb79de31f','volumes',-1,'2025-12-06 10:08:20',NULL),('2025-12-05 10:08:20','2025-12-05 10:08:20','2025-12-05 10:08:20',1,6,'2309c01d-3a2e-438e-a0cb-727f496c4f38',2,'6225d95e0a924813958256bdb79de31f','gigabytes',-1,'2025-12-06 10:08:20',NULL),('2025-12-05 10:08:20','2025-12-05 10:08:20','2025-12-05 10:08:20',1,7,'00183f0b-4679-467a-8c92-5e19c2333667',3,'6225d95e0a924813958256bdb79de31f','volumes_tripleo',-1,'2025-12-06 10:08:20',NULL),('2025-12-05 10:08:20','2025-12-05 10:08:20','2025-12-05 10:08:20',1,8,'87d2ef1c-857b-41e9-89ee-6810a1c9631d',4,'6225d95e0a924813958256bdb79de31f','gigabytes_tripleo',-1,'2025-12-06 10:08:20',NULL),('2025-12-05 10:08:21','2025-12-05 10:08:21','2025-12-05 10:08:21',1,9,'0b22331d-ea88-4b0e-9d7b-5b7760f6d068',1,'6225d95e0a924813958256bdb79de31f','volumes',1,'2025-12-06 10:08:21',NULL),('2025-12-05 10:08:21','2025-12-05 10:08:21','2025-12-05 10:08:21',1,10,'9781142d-bffa-4956-b157-bc48198d917d',2,'6225d95e0a924813958256bdb79de31f','gigabytes',1,'2025-12-06 10:08:21',NULL),('2025-12-05 10:08:21','2025-12-05 10:08:21','2025-12-05 10:08:21',1,11,'f013b248-feba-41a3-9508-b4b4fb6ab95f',3,'6225d95e0a924813958256bdb79de31f','volumes_tripleo',1,'2025-12-06 10:08:21',NULL),('2025-12-05 10:08:21','2025-12-05 10:08:21','2025-12-05 10:08:21',1,12,'7e9d8ef7-832b-483e-8f92-1bb2b67dc4cf',4,'6225d95e0a924813958256bdb79de31f','gigabytes_tripleo',1,'2025-12-06 10:08:21',NULL),('2025-12-05 10:08:22','2025-12-05 10:08:22','2025-12-05 10:08:22',1,13,'bf942875-5937-4cc8-bffd-cce614fa7b13',1,'6225d95e0a924813958256bdb79de31f','volumes',-1,'2025-12-06 10:08:22',NULL),('2025-12-05 10:08:22','2025-12-05 10:08:22','2025-12-05 10:08:22',1,14,'0dc5a6a7-1d1e-4cec-ba53-2333cd0e7c2c',2,'6225d95e0a924813958256bdb79de31f','gigabytes',-1,'2025-12-06 10:08:22',NULL),('2025-12-05 10:08:22','2025-12-05 10:08:22','2025-12-05 10:08:22',1,15,'3930adab-6a18-4b59-b3fb-095e77737315',3,'6225d95e0a924813958256bdb79de31f','volumes_tripleo',-1,'2025-12-06 10:08:22',NULL),('2025-12-05 10:08:22','2025-12-05 10:08:22','2025-12-05 10:08:22',1,16,'219eecd5-611a-4bf3-9aa4-955326fd7b09',4,'6225d95e0a924813958256bdb79de31f','gigabytes_tripleo',-1,'2025-12-06 10:08:22',NULL),('2025-12-05 10:08:23','2025-12-05 10:08:23','2025-12-05 10:08:23',1,17,'313a0a0d-583a-43ac-92de-316247b8ad17',1,'6225d95e0a924813958256bdb79de31f','volumes',1,'2025-12-06 10:08:23',NULL),('2025-12-05 10:08:23','2025-12-05 10:08:23','2025-12-05 10:08:23',1,18,'0896af73-ae62-4891-804f-b55bd5ab831b',2,'6225d95e0a924813958256bdb79de31f','gigabytes',1,'2025-12-06 10:08:23',NULL),('2025-12-05 10:08:23','2025-12-05 10:08:23','2025-12-05 10:08:23',1,19,'c030ec6f-3cef-4da3-856a-41a986711426',3,'6225d95e0a924813958256bdb79de31f','volumes_tripleo',1,'2025-12-06 10:08:23',NULL),('2025-12-05 10:08:23','2025-12-05 10:08:23','2025-12-05 10:08:23',1,20,'d2411707-8c39-48cf-8920-c577e50fd8c0',4,'6225d95e0a924813958256bdb79de31f','gigabytes_tripleo',1,'2025-12-06 10:08:23',NULL),('2025-12-05 10:08:25','2025-12-05 10:08:25','2025-12-05 10:08:25',1,21,'c3e3e1c3-46b6-4b90-93e7-9181286fff14',1,'6225d95e0a924813958256bdb79de31f','volumes',-1,'2025-12-06 10:08:25',NULL),('2025-12-05 10:08:25','2025-12-05 10:08:25','2025-12-05 10:08:25',1,22,'ca9a9275-11dc-468c-85a5-3de45750cf81',2,'6225d95e0a924813958256bdb79de31f','gigabytes',-1,'2025-12-06 10:08:25',NULL),('2025-12-05 10:08:25','2025-12-05 10:08:25','2025-12-05 10:08:25',1,23,'3a4f14a4-ffb3-4771-92ff-e027fd616fa0',3,'6225d95e0a924813958256bdb79de31f','volumes_tripleo',-1,'2025-12-06 10:08:25',NULL),('2025-12-05 10:08:25','2025-12-05 10:08:25','2025-12-05 10:08:25',1,24,'eb89b5b6-de29-497a-a59f-d16430eb811b',4,'6225d95e0a924813958256bdb79de31f','gigabytes_tripleo',-1,'2025-12-06 10:08:25',NULL),('2025-12-05 10:08:26','2025-12-05 10:08:27','2025-12-05 10:08:27',1,25,'c679602c-e8f7-4b7a-9389-8107fb5fc226',1,'6225d95e0a924813958256bdb79de31f','volumes',1,'2025-12-06 10:08:26',NULL),('2025-12-05 10:08:26','2025-12-05 10:08:27','2025-12-05 10:08:27',1,26,'a82e72f4-5409-414c-9ffe-2e9b7ad25924',2,'6225d95e0a924813958256bdb79de31f','gigabytes',1,'2025-12-06 10:08:26',NULL),('2025-12-05 10:08:26','2025-12-05 10:08:27','2025-12-05 10:08:27',1,27,'e9ec449d-8e4c-496d-b91f-dc22ab1e4076',3,'6225d95e0a924813958256bdb79de31f','volumes_tripleo',1,'2025-12-06 10:08:26',NULL),('2025-12-05 10:08:26','2025-12-05 10:08:27','2025-12-05 10:08:27',1,28,'e85a7607-0ace-4b82-aece-65c8207f502f',4,'6225d95e0a924813958256bdb79de31f','gigabytes_tripleo',1,'2025-12-06 10:08:26',NULL),('2025-12-05 10:08:29','2025-12-05 10:08:29','2025-12-05 10:08:29',1,29,'21a2a597-969a-47cc-a338-f9c49270b263',1,'6225d95e0a924813958256bdb79de31f','volumes',-1,'2025-12-06 10:08:29',NULL),('2025-12-05 10:08:29','2025-12-05 10:08:29','2025-12-05 10:08:29',1,30,'d2c10690-f924-4cae-ae62-4a130f355f66',2,'6225d95e0a924813958256bdb79de31f','gigabytes',-1,'2025-12-06 10:08:29',NULL),('2025-12-05 10:08:29','2025-12-05 10:08:29','2025-12-05 10:08:29',1,31,'292769d2-3822-4550-93e4-837019237818',3,'6225d95e0a924813958256bdb79de31f','volumes_tripleo',-1,'2025-12-06 10:08:29',NULL),('2025-12-05 10:08:29','2025-12-05 10:08:29','2025-12-05 10:08:29',1,32,'4aebf842-2972-49de-92dc-70ca5c28dcd2',4,'6225d95e0a924813958256bdb79de31f','gigabytes_tripleo',-1,'2025-12-06 10:08:29',NULL),('2025-12-05 10:08:29','2025-12-05 10:08:30','2025-12-05 10:08:30',1,33,'9c20a249-8434-4d0e-adcd-a6b8e00b9b4b',1,'6225d95e0a924813958256bdb79de31f','volumes',1,'2025-12-06 10:08:29',NULL),('2025-12-05 10:08:29','2025-12-05 10:08:30','2025-12-05 10:08:30',1,34,'dbd3c7e6-1080-4273-ba2b-74d17109406c',2,'6225d95e0a924813958256bdb79de31f','gigabytes',1,'2025-12-06 10:08:29',NULL),('2025-12-05 10:08:30','2025-12-05 10:08:30','2025-12-05 10:08:30',1,35,'182557f2-cec7-4bb0-aca0-db5f784a65ba',3,'6225d95e0a924813958256bdb79de31f','volumes_tripleo',1,'2025-12-06 10:08:29',NULL),('2025-12-05 10:08:30','2025-12-05 10:08:30','2025-12-05 10:08:30',1,36,'58bf31d1-4be9-4537-8239-5295838f23ea',4,'6225d95e0a924813958256bdb79de31f','gigabytes_tripleo',1,'2025-12-06 10:08:29',NULL),('2025-12-05 10:08:32','2025-12-05 10:08:32','2025-12-05 10:08:32',1,37,'526ecca6-4657-47c5-8e5c-72a9098b3157',1,'6225d95e0a924813958256bdb79de31f','volumes',-1,'2025-12-06 10:08:32',NULL),('2025-12-05 10:08:32','2025-12-05 10:08:32','2025-12-05 10:08:32',1,38,'3744af22-25fa-482a-aa4b-a157649301d3',2,'6225d95e0a924813958256bdb79de31f','gigabytes',-1,'2025-12-06 10:08:32',NULL),('2025-12-05 10:08:32','2025-12-05 10:08:32','2025-12-05 10:08:32',1,39,'7a5dcd05-6e1b-440e-98d9-6e27fd436a40',3,'6225d95e0a924813958256bdb79de31f','volumes_tripleo',-1,'2025-12-06 10:08:32',NULL),('2025-12-05 10:08:32','2025-12-05 10:08:32','2025-12-05 10:08:32',1,40,'e8fd5e75-3e0a-428b-8011-9f719ebde1ee',4,'6225d95e0a924813958256bdb79de31f','gigabytes_tripleo',-1,'2025-12-06 10:08:32',NULL),('2025-12-05 10:09:07','2025-12-05 10:09:07','2025-12-05 10:09:07',1,41,'7d1e83bc-7891-4b23-80bd-91e839c3ff2f',5,'49be837e62ee480f80076382c098e61f','volumes',1,'2025-12-06 10:09:07',NULL),('2025-12-05 10:09:07','2025-12-05 10:09:07','2025-12-05 10:09:07',1,42,'38ea8657-d15f-4e98-817f-a09bf4e5aae6',6,'49be837e62ee480f80076382c098e61f','gigabytes',1,'2025-12-06 10:09:07',NULL),('2025-12-05 10:09:07','2025-12-05 10:09:07','2025-12-05 10:09:07',1,43,'3dbdfe49-d25f-4ec2-a1df-9fc41f50b5d7',7,'49be837e62ee480f80076382c098e61f','volumes_tripleo',1,'2025-12-06 10:09:07',NULL),('2025-12-05 10:09:07','2025-12-05 10:09:07','2025-12-05 10:09:07',1,44,'32894959-483f-4ed4-991a-42f55936e4d5',8,'49be837e62ee480f80076382c098e61f','gigabytes_tripleo',1,'2025-12-06 10:09:07',NULL),('2025-12-05 10:09:19','2025-12-05 10:09:19','2025-12-05 10:09:19',1,45,'3a049b9a-a1fe-4914-8ae1-4ba0e415b620',5,'49be837e62ee480f80076382c098e61f','volumes',-1,'2025-12-06 10:09:19',NULL),('2025-12-05 10:09:19','2025-12-05 10:09:19','2025-12-05 10:09:19',1,46,'5a4dd582-ca10-4cec-aa71-85f752cf5382',6,'49be837e62ee480f80076382c098e61f','gigabytes',-1,'2025-12-06 10:09:19',NULL),('2025-12-05 10:09:19','2025-12-05 10:09:19','2025-12-05 10:09:19',1,47,'be4451f2-b19e-43a4-8e10-387fe1ce4380',7,'49be837e62ee480f80076382c098e61f','volumes_tripleo',-1,'2025-12-06 10:09:19',NULL),('2025-12-05 10:09:19','2025-12-05 10:09:19','2025-12-05 10:09:19',1,48,'ccda9283-2714-4698-88b2-c54c061598d7',8,'49be837e62ee480f80076382c098e61f','gigabytes_tripleo',-1,'2025-12-06 10:09:19',NULL),('2025-12-05 10:09:23','2025-12-05 10:09:23','2025-12-05 10:09:23',1,49,'4766cd81-deb7-42c5-b452-fa78080b1536',9,'eb581b3986ff44adaf0d86d376d9c83a','volumes',1,'2025-12-06 10:09:23',NULL),('2025-12-05 10:09:23','2025-12-05 10:09:23','2025-12-05 10:09:23',1,50,'2bd7409d-1ff8-4b60-84f9-58a8a37a6712',10,'eb581b3986ff44adaf0d86d376d9c83a','gigabytes',1,'2025-12-06 10:09:23',NULL),('2025-12-05 10:09:23','2025-12-05 10:09:23','2025-12-05 10:09:23',1,51,'8e47ce19-4511-44c7-a65f-fb4a1e260692',11,'eb581b3986ff44adaf0d86d376d9c83a','volumes_tripleo',1,'2025-12-06 10:09:23',NULL),('2025-12-05 10:09:23','2025-12-05 10:09:23','2025-12-05 10:09:23',1,52,'edd97cf5-7786-45da-aa09-82ca849d399f',12,'eb581b3986ff44adaf0d86d376d9c83a','gigabytes_tripleo',1,'2025-12-06 10:09:23',NULL),('2025-12-05 10:09:25','2025-12-05 10:09:25','2025-12-05 10:09:25',1,53,'ee0a70f4-0e2e-44d1-9022-9092fff506b6',9,'eb581b3986ff44adaf0d86d376d9c83a','volumes',-1,'2025-12-06 10:09:25',NULL),('2025-12-05 10:09:25','2025-12-05 10:09:25','2025-12-05 10:09:25',1,54,'073d598c-3e07-424d-b4a1-8a0f7b6c58b8',10,'eb581b3986ff44adaf0d86d376d9c83a','gigabytes',-1,'2025-12-06 10:09:25',NULL),('2025-12-05 10:09:25','2025-12-05 10:09:25','2025-12-05 10:09:25',1,55,'bbe72483-0d25-4c10-9022-f9328261b93d',11,'eb581b3986ff44adaf0d86d376d9c83a','volumes_tripleo',-1,'2025-12-06 10:09:25',NULL),('2025-12-05 10:09:25','2025-12-05 10:09:25','2025-12-05 10:09:25',1,56,'9c202ca5-e492-4944-acb9-ffcf17b2bbb5',12,'eb581b3986ff44adaf0d86d376d9c83a','gigabytes_tripleo',-1,'2025-12-06 10:09:25',NULL),('2025-12-05 10:09:29','2025-12-05 10:09:29','2025-12-05 10:09:29',1,57,'23c5d230-972e-4739-850c-ac7b413ba63f',13,'2eb8cf0d784b4d188f16c04a39a755a9','volumes',1,'2025-12-06 10:09:29',NULL),('2025-12-05 10:09:29','2025-12-05 10:09:29','2025-12-05 10:09:29',1,58,'3a921606-89ae-48de-b434-786301fd140f',14,'2eb8cf0d784b4d188f16c04a39a755a9','gigabytes',1,'2025-12-06 10:09:29',NULL),('2025-12-05 10:09:29','2025-12-05 10:09:29','2025-12-05 10:09:29',1,59,'e240b52d-dde1-4403-a97f-9461fae8acf1',15,'2eb8cf0d784b4d188f16c04a39a755a9','volumes_tripleo',1,'2025-12-06 10:09:29',NULL),('2025-12-05 10:09:29','2025-12-05 10:09:29','2025-12-05 10:09:29',1,60,'0c605af2-e4c5-4976-a091-4b1f6ae88a2d',16,'2eb8cf0d784b4d188f16c04a39a755a9','gigabytes_tripleo',1,'2025-12-06 10:09:29',NULL),('2025-12-05 10:09:38','2025-12-05 10:09:38','2025-12-05 10:09:38',1,61,'9c965ea4-26bb-42d1-aafc-ff2a034c7ef7',13,'2eb8cf0d784b4d188f16c04a39a755a9','volumes',-1,'2025-12-06 10:09:38',NULL),('2025-12-05 10:09:38','2025-12-05 10:09:38','2025-12-05 10:09:38',1,62,'e9eba848-adca-4cb2-aa0e-4df3d67b6d45',14,'2eb8cf0d784b4d188f16c04a39a755a9','gigabytes',-1,'2025-12-06 10:09:38',NULL),('2025-12-05 10:09:38','2025-12-05 10:09:38','2025-12-05 10:09:38',1,63,'0e2d41fb-35e0-4365-b1bd-e3ff82740af3',15,'2eb8cf0d784b4d188f16c04a39a755a9','volumes_tripleo',-1,'2025-12-06 10:09:38',NULL),('2025-12-05 10:09:38','2025-12-05 10:09:38','2025-12-05 10:09:38',1,64,'a7b9c0b7-a36d-4b38-9a62-8aeead63b4fc',16,'2eb8cf0d784b4d188f16c04a39a755a9','gigabytes_tripleo',-1,'2025-12-06 10:09:38',NULL),('2025-12-05 10:10:08','2025-12-05 10:10:08','2025-12-05 10:10:08',1,65,'a3dece9c-02f8-4e9a-b9f0-45ac5a07cad5',17,'3e1f2363f1af446095b256c4564bb0fe','groups',1,'2025-12-06 10:10:08',NULL),('2025-12-05 10:10:10','2025-12-05 10:10:10','2025-12-05 10:10:10',1,66,'beb4c29c-3278-4cdb-9214-9868952cf1d0',18,'3e1f2363f1af446095b256c4564bb0fe','volumes',1,'2025-12-06 10:10:10',NULL),('2025-12-05 10:10:10','2025-12-05 10:10:10','2025-12-05 10:10:10',1,67,'e75b336b-12b4-4013-bc4a-db8f62afe4c2',19,'3e1f2363f1af446095b256c4564bb0fe','gigabytes',1,'2025-12-06 10:10:10',NULL),('2025-12-05 10:10:10','2025-12-05 10:10:10','2025-12-05 10:10:10',1,68,'8c758aef-ad56-4f06-94f4-d921ac1a6191',20,'3e1f2363f1af446095b256c4564bb0fe','volumes_tempest-GroupSnapshotsV319Test-volume-type-2075304691',1,'2025-12-06 10:10:10',NULL),('2025-12-05 10:10:10','2025-12-05 10:10:10','2025-12-05 10:10:10',1,69,'7a2586cb-9b0b-487c-b60a-0adaa6f1f238',21,'3e1f2363f1af446095b256c4564bb0fe','gigabytes_tempest-GroupSnapshotsV319Test-volume-type-2075304691',1,'2025-12-06 10:10:10',NULL),('2025-12-05 10:10:11','2025-12-05 10:10:11','2025-12-05 10:10:11',1,70,'b687cd42-e3b9-45a8-8213-7971d910865d',22,'3e1f2363f1af446095b256c4564bb0fe','snapshots',1,'2025-12-06 10:10:11',NULL),('2025-12-05 10:10:11','2025-12-05 10:10:11','2025-12-05 10:10:11',1,71,'097e62ba-e92c-444f-87dd-dbd3883dc893',19,'3e1f2363f1af446095b256c4564bb0fe','gigabytes',1,'2025-12-06 10:10:11',NULL),('2025-12-05 10:10:11','2025-12-05 10:10:11','2025-12-05 10:10:11',1,72,'a07dbf94-0b49-4133-b407-da7aa0962337',21,'3e1f2363f1af446095b256c4564bb0fe','gigabytes_tempest-GroupSnapshotsV319Test-volume-type-2075304691',1,'2025-12-06 10:10:11',NULL),('2025-12-05 10:10:11','2025-12-05 10:10:11','2025-12-05 10:10:11',1,73,'f1b653e3-e35a-4fd1-af02-48ee717dd926',23,'3e1f2363f1af446095b256c4564bb0fe','snapshots_tempest-GroupSnapshotsV319Test-volume-type-2075304691',1,'2025-12-06 10:10:11',NULL),('2025-12-05 10:10:14','2025-12-05 10:10:14','2025-12-05 10:10:14',1,74,'05e624cd-195b-40f4-8540-d96c1cf2d596',22,'3e1f2363f1af446095b256c4564bb0fe','snapshots',-1,'2025-12-06 10:10:14',NULL),('2025-12-05 10:10:14','2025-12-05 10:10:14','2025-12-05 10:10:14',1,75,'8b17d08e-6be7-4b08-bbfb-47f22878cbcc',19,'3e1f2363f1af446095b256c4564bb0fe','gigabytes',-1,'2025-12-06 10:10:14',NULL),('2025-12-05 10:10:14','2025-12-05 10:10:14','2025-12-05 10:10:14',1,76,'7346a7a7-3922-4aab-a22f-72132901552d',21,'3e1f2363f1af446095b256c4564bb0fe','gigabytes_tempest-GroupSnapshotsV319Test-volume-type-2075304691',-1,'2025-12-06 10:10:14',NULL),('2025-12-05 10:10:14','2025-12-05 10:10:14','2025-12-05 10:10:14',1,77,'fe8c6ee9-d0d4-4b19-bc86-e326883fa6c9',23,'3e1f2363f1af446095b256c4564bb0fe','snapshots_tempest-GroupSnapshotsV319Test-volume-type-2075304691',-1,'2025-12-06 10:10:14',NULL),('2025-12-05 10:10:16','2025-12-05 10:10:16','2025-12-05 10:10:16',1,78,'6d300d12-98be-4ac9-8754-71af31dc5cf4',24,'584e347c69994bcbb195242db0534134','volumes',1,'2025-12-06 10:10:15',NULL),('2025-12-05 10:10:16','2025-12-05 10:10:16','2025-12-05 10:10:16',1,79,'690c1e07-6691-48db-8ca2-c53aa6986d8b',25,'584e347c69994bcbb195242db0534134','gigabytes',1,'2025-12-06 10:10:15',NULL),('2025-12-05 10:10:16','2025-12-05 10:10:16','2025-12-05 10:10:16',1,80,'deccbaf9-91c1-42ff-9245-ccb74a3208fc',26,'584e347c69994bcbb195242db0534134','volumes_tripleo',1,'2025-12-06 10:10:15',NULL),('2025-12-05 10:10:16','2025-12-05 10:10:16','2025-12-05 10:10:16',1,81,'cc6396b3-7f1b-493e-a642-7180d95d6f3d',27,'584e347c69994bcbb195242db0534134','gigabytes_tripleo',1,'2025-12-06 10:10:15',NULL),('2025-12-05 10:10:16','2025-12-05 10:10:16','2025-12-05 10:10:16',1,82,'f76fe9d1-66e4-4c10-8a55-aa4c78d84a7e',17,'3e1f2363f1af446095b256c4564bb0fe','groups',-1,'2025-12-06 10:10:16',NULL),('2025-12-05 10:10:16','2025-12-05 10:10:16','2025-12-05 10:10:16',1,83,'df48c4f3-9da6-4954-b99a-55ae87ba8d9b',18,'3e1f2363f1af446095b256c4564bb0fe','volumes',-1,'2025-12-06 10:10:16',NULL),('2025-12-05 10:10:16','2025-12-05 10:10:16','2025-12-05 10:10:16',1,84,'435af2cb-1dec-47f0-a320-f3fbd91d8fb3',19,'3e1f2363f1af446095b256c4564bb0fe','gigabytes',-1,'2025-12-06 10:10:16',NULL),('2025-12-05 10:10:16','2025-12-05 10:10:16','2025-12-05 10:10:16',1,85,'46c65c9c-7aa3-43ae-9e26-50fe88a2b6bc',20,'3e1f2363f1af446095b256c4564bb0fe','volumes_tempest-GroupSnapshotsV319Test-volume-type-2075304691',-1,'2025-12-06 10:10:16',NULL),('2025-12-05 10:10:16','2025-12-05 10:10:16','2025-12-05 10:10:16',1,86,'0b13a631-1747-43a6-80e5-b1302ee09ad2',21,'3e1f2363f1af446095b256c4564bb0fe','gigabytes_tempest-GroupSnapshotsV319Test-volume-type-2075304691',-1,'2025-12-06 10:10:16',NULL),('2025-12-05 10:10:17','2025-12-05 10:10:18','2025-12-05 10:10:18',1,87,'35c98cc1-881c-43aa-9bd0-6f60d081c5af',24,'584e347c69994bcbb195242db0534134','volumes',-1,'2025-12-06 10:10:17',NULL),('2025-12-05 10:10:17','2025-12-05 10:10:18','2025-12-05 10:10:18',1,88,'3089b11b-172e-4fe0-998a-a6e634064e48',25,'584e347c69994bcbb195242db0534134','gigabytes',-1,'2025-12-06 10:10:17',NULL),('2025-12-05 10:10:17','2025-12-05 10:10:18','2025-12-05 10:10:18',1,89,'500f4c77-7b15-4fa4-9cee-2f489dfb724b',26,'584e347c69994bcbb195242db0534134','volumes_tripleo',-1,'2025-12-06 10:10:17',NULL),('2025-12-05 10:10:17','2025-12-05 10:10:18','2025-12-05 10:10:18',1,90,'338ba2f5-0097-4ef6-abc0-abcf55fc7c94',27,'584e347c69994bcbb195242db0534134','gigabytes_tripleo',-1,'2025-12-06 10:10:17',NULL),('2025-12-05 10:10:18','2025-12-05 10:10:18','2025-12-05 10:10:18',1,91,'6d903910-8f9e-4a1b-9bb2-ee5f8e7098fb',24,'584e347c69994bcbb195242db0534134','volumes',1,'2025-12-06 10:10:18',NULL),('2025-12-05 10:10:18','2025-12-05 10:10:18','2025-12-05 10:10:18',1,92,'c50e966e-8c94-4a2f-9af8-31be00ab4c4c',25,'584e347c69994bcbb195242db0534134','gigabytes',1,'2025-12-06 10:10:18',NULL),('2025-12-05 10:10:18','2025-12-05 10:10:18','2025-12-05 10:10:18',1,93,'3a6ae280-7040-4b8e-adaa-eb777bb0d4d4',26,'584e347c69994bcbb195242db0534134','volumes_tripleo',1,'2025-12-06 10:10:18',NULL),('2025-12-05 10:10:18','2025-12-05 10:10:18','2025-12-05 10:10:18',1,94,'638d0927-227b-4d62-a0e7-663e672b2418',27,'584e347c69994bcbb195242db0534134','gigabytes_tripleo',1,'2025-12-06 10:10:18',NULL),('2025-12-05 10:10:20','2025-12-05 10:10:20','2025-12-05 10:10:20',1,95,'2c6c236c-4a5e-49f1-8d73-0af45725b750',28,'7864fe2bcb66461095dedc4deed01501','volumes',1,'2025-12-06 10:10:20',NULL),('2025-12-05 10:10:20','2025-12-05 10:10:20','2025-12-05 10:10:20',1,96,'94e285c0-dd9c-4d70-b68d-2b881878164e',29,'7864fe2bcb66461095dedc4deed01501','gigabytes',1,'2025-12-06 10:10:20',NULL),('2025-12-05 10:10:20','2025-12-05 10:10:20','2025-12-05 10:10:20',1,97,'5b6045a4-85fd-4854-8845-523f30bca74e',30,'7864fe2bcb66461095dedc4deed01501','volumes_tripleo',1,'2025-12-06 10:10:20',NULL),('2025-12-05 10:10:20','2025-12-05 10:10:20','2025-12-05 10:10:20',1,98,'11206140-3f10-4ae0-8e3a-12336b21dfa6',31,'7864fe2bcb66461095dedc4deed01501','gigabytes_tripleo',1,'2025-12-06 10:10:20',NULL),('2025-12-05 10:10:20','2025-12-05 10:10:20','2025-12-05 10:10:20',1,99,'6528c444-a7fc-4d94-b63d-ada09d3c2c11',24,'584e347c69994bcbb195242db0534134','volumes',-1,'2025-12-06 10:10:20',NULL),('2025-12-05 10:10:20','2025-12-05 10:10:20','2025-12-05 10:10:20',1,100,'6a2122cf-3a9e-42e9-8ce0-7c10c04a712c',25,'584e347c69994bcbb195242db0534134','gigabytes',-1,'2025-12-06 10:10:20',NULL),('2025-12-05 10:10:20','2025-12-05 10:10:20','2025-12-05 10:10:20',1,101,'672cc145-53e8-4361-8409-6a294606deb9',26,'584e347c69994bcbb195242db0534134','volumes_tripleo',-1,'2025-12-06 10:10:20',NULL),('2025-12-05 10:10:20','2025-12-05 10:10:20','2025-12-05 10:10:20',1,102,'b0e207e1-a8da-4566-aeba-196d823b8834',27,'584e347c69994bcbb195242db0534134','gigabytes_tripleo',-1,'2025-12-06 10:10:20',NULL),('2025-12-05 10:10:20','2025-12-05 10:10:20','2025-12-05 10:10:20',1,103,'6a6c1bdb-e6c1-4bc2-a37f-65ae8b5e4615',32,'7864fe2bcb66461095dedc4deed01501','snapshots',0,'2025-12-06 10:10:20',NULL),('2025-12-05 10:10:20','2025-12-05 10:10:20','2025-12-05 10:10:20',1,104,'b93c592f-ec5a-4260-a4a9-955a998f4d81',29,'7864fe2bcb66461095dedc4deed01501','gigabytes',0,'2025-12-06 10:10:20',NULL),('2025-12-05 10:10:20','2025-12-05 10:10:20','2025-12-05 10:10:20',1,105,'aa6b1657-ac82-4564-802a-00c69655a549',31,'7864fe2bcb66461095dedc4deed01501','gigabytes_tripleo',0,'2025-12-06 10:10:20',NULL),('2025-12-05 10:10:20','2025-12-05 10:10:20','2025-12-05 10:10:20',1,106,'9a6978bd-bc2b-49aa-b02e-ac75281f74ec',33,'7864fe2bcb66461095dedc4deed01501','snapshots_tripleo',0,'2025-12-06 10:10:20',NULL),('2025-12-05 10:10:20','2025-12-05 10:10:20','2025-12-05 10:10:20',1,107,'38037512-17ec-49f4-9ced-f3c17a0d2149',34,'584e347c69994bcbb195242db0534134','snapshots',0,'2025-12-06 10:10:20',NULL),('2025-12-05 10:10:20','2025-12-05 10:10:20','2025-12-05 10:10:20',1,108,'d6dd9bcd-5065-416d-b0f0-541269a65e2a',25,'584e347c69994bcbb195242db0534134','gigabytes',0,'2025-12-06 10:10:20',NULL),('2025-12-05 10:10:20','2025-12-05 10:10:20','2025-12-05 10:10:20',1,109,'35b954d5-1743-48d4-93d0-43debe4223c2',27,'584e347c69994bcbb195242db0534134','gigabytes_tripleo',0,'2025-12-06 10:10:20',NULL),('2025-12-05 10:10:20','2025-12-05 10:10:20','2025-12-05 10:10:20',1,110,'761556cf-8254-4e7b-9901-0b7c28def4a9',35,'584e347c69994bcbb195242db0534134','snapshots_tripleo',0,'2025-12-06 10:10:20',NULL),('2025-12-05 10:10:21','2025-12-05 10:10:21','2025-12-05 10:10:21',1,111,'298bbf73-2749-4903-8774-ba184f3137c4',28,'7864fe2bcb66461095dedc4deed01501','volumes',-1,'2025-12-06 10:10:21',NULL),('2025-12-05 10:10:21','2025-12-05 10:10:21','2025-12-05 10:10:21',1,112,'65cbf38b-894b-4023-ac06-274af65da586',29,'7864fe2bcb66461095dedc4deed01501','gigabytes',-1,'2025-12-06 10:10:21',NULL),('2025-12-05 10:10:21','2025-12-05 10:10:21','2025-12-05 10:10:21',1,113,'c61fbe80-a869-4f6f-80fb-885f114bfaf2',30,'7864fe2bcb66461095dedc4deed01501','volumes_tripleo',-1,'2025-12-06 10:10:21',NULL),('2025-12-05 10:10:21','2025-12-05 10:10:21','2025-12-05 10:10:21',1,114,'7f86c717-4277-46e7-8a2e-29e96800f822',31,'7864fe2bcb66461095dedc4deed01501','gigabytes_tripleo',-1,'2025-12-06 10:10:21',NULL),('2025-12-05 10:10:25','2025-12-05 10:10:25','2025-12-05 10:10:25',1,115,'48304162-f9cb-46da-aaca-a4a9cf046178',36,'f22e077193c5438f8057ad89a3e18cb5','groups',1,'2025-12-06 10:10:25',NULL),('2025-12-05 10:10:26','2025-12-05 10:10:26','2025-12-05 10:10:26',1,116,'0c4d7f32-ab63-429a-a57a-27a1c5334b2e',36,'f22e077193c5438f8057ad89a3e18cb5','groups',-1,'2025-12-06 10:10:26',NULL),('2025-12-05 10:10:41','2025-12-05 10:10:41','2025-12-05 10:10:41',1,117,'f681a20b-77c0-4997-b2e6-3c7d529c7d2c',37,'e3199c4c895043739e357008afbe83c8','volumes',1,'2025-12-06 10:10:40',NULL),('2025-12-05 10:10:41','2025-12-05 10:10:41','2025-12-05 10:10:41',1,118,'a4025c97-50a6-4720-b21e-11ab16cb5699',38,'e3199c4c895043739e357008afbe83c8','gigabytes',1,'2025-12-06 10:10:40',NULL),('2025-12-05 10:10:41','2025-12-05 10:10:41','2025-12-05 10:10:41',1,119,'c32c2621-a9fa-4566-9b29-f93c9f7914e2',39,'e3199c4c895043739e357008afbe83c8','volumes_tripleo',1,'2025-12-06 10:10:40',NULL),('2025-12-05 10:10:41','2025-12-05 10:10:41','2025-12-05 10:10:41',1,120,'0e47a5e1-2ee6-414e-884b-f4084bbd8b16',40,'e3199c4c895043739e357008afbe83c8','gigabytes_tripleo',1,'2025-12-06 10:10:40',NULL),('2025-12-05 10:10:44','2025-12-05 10:10:44','2025-12-05 10:10:44',1,121,'e1465a2f-ccfd-472a-a933-cbd36c245136',37,'e3199c4c895043739e357008afbe83c8','volumes',-1,'2025-12-06 10:10:44',NULL),('2025-12-05 10:10:44','2025-12-05 10:10:44','2025-12-05 10:10:44',1,122,'01ac2e13-4c18-4663-9626-2380f0657ce4',38,'e3199c4c895043739e357008afbe83c8','gigabytes',-1,'2025-12-06 10:10:44',NULL),('2025-12-05 10:10:44','2025-12-05 10:10:44','2025-12-05 10:10:44',1,123,'187ae1d3-38a2-4d5d-896b-547227e8646d',39,'e3199c4c895043739e357008afbe83c8','volumes_tripleo',-1,'2025-12-06 10:10:44',NULL),('2025-12-05 10:10:44','2025-12-05 10:10:44','2025-12-05 10:10:44',1,124,'805aae53-c038-4177-8524-0ef4623e39f6',40,'e3199c4c895043739e357008afbe83c8','gigabytes_tripleo',-1,'2025-12-06 10:10:44',NULL),('2025-12-05 10:10:49','2025-12-05 10:10:49','2025-12-05 10:10:49',1,125,'e5bc76c4-204b-423d-a9f9-91226f2c8d0f',41,'b984bc032821439da9e14438f496b701','volumes',1,'2025-12-06 10:10:49',NULL),('2025-12-05 10:10:49','2025-12-05 10:10:49','2025-12-05 10:10:49',1,126,'e86fe901-8645-4a5a-bb0d-fb32dae2379a',42,'b984bc032821439da9e14438f496b701','gigabytes',1,'2025-12-06 10:10:49',NULL),('2025-12-05 10:10:49','2025-12-05 10:10:49','2025-12-05 10:10:49',1,127,'f4dc4193-c442-457d-83f3-5ea706455da1',43,'b984bc032821439da9e14438f496b701','volumes_tripleo',1,'2025-12-06 10:10:49',NULL),('2025-12-05 10:10:49','2025-12-05 10:10:49','2025-12-05 10:10:49',1,128,'ad8c27be-d094-4faa-9861-feb2d6555829',44,'b984bc032821439da9e14438f496b701','gigabytes_tripleo',1,'2025-12-06 10:10:49',NULL),('2025-12-05 10:10:50','2025-12-05 10:10:51','2025-12-05 10:10:51',1,129,'0d879bc9-5ffb-4870-86c1-1e80f324fd10',45,'b0b9e4dc414946c097d558d4b89e8947','volumes',1,'2025-12-06 10:10:50',NULL),('2025-12-05 10:10:50','2025-12-05 10:10:51','2025-12-05 10:10:51',1,130,'0752b858-f4fa-43bd-a14d-0f748b1e1e6d',46,'b0b9e4dc414946c097d558d4b89e8947','gigabytes',1,'2025-12-06 10:10:50',NULL),('2025-12-05 10:10:50','2025-12-05 10:10:51','2025-12-05 10:10:51',1,131,'a1b06d0a-4a2e-4104-ba0d-5a6d34622616',47,'b0b9e4dc414946c097d558d4b89e8947','volumes_tripleo',1,'2025-12-06 10:10:50',NULL),('2025-12-05 10:10:50','2025-12-05 10:10:51','2025-12-05 10:10:51',1,132,'c1069aad-aff0-4d9b-9e2e-22653d387569',48,'b0b9e4dc414946c097d558d4b89e8947','gigabytes_tripleo',1,'2025-12-06 10:10:50',NULL),('2025-12-05 10:10:50','2025-12-05 10:10:51','2025-12-05 10:10:51',1,133,'580d0bcd-0c90-46d8-8097-fa39fade2891',41,'b984bc032821439da9e14438f496b701','volumes',-1,'2025-12-06 10:10:50',NULL),('2025-12-05 10:10:50','2025-12-05 10:10:51','2025-12-05 10:10:51',1,134,'7384d6f2-d4f6-4121-9c75-e09943272d97',42,'b984bc032821439da9e14438f496b701','gigabytes',-1,'2025-12-06 10:10:50',NULL),('2025-12-05 10:10:50','2025-12-05 10:10:51','2025-12-05 10:10:51',1,135,'3550ffb1-3202-45b9-b5ea-b5e9d76fd009',43,'b984bc032821439da9e14438f496b701','volumes_tripleo',-1,'2025-12-06 10:10:50',NULL),('2025-12-05 10:10:50','2025-12-05 10:10:51','2025-12-05 10:10:51',1,136,'a99d1679-c0c0-47a1-bc53-572bd6043007',44,'b984bc032821439da9e14438f496b701','gigabytes_tripleo',-1,'2025-12-06 10:10:50',NULL),('2025-12-05 10:10:51','2025-12-05 10:10:51','2025-12-05 10:10:51',1,137,'309d2fe9-3af3-4e25-ac3b-dc2e48ea132c',49,'b0b9e4dc414946c097d558d4b89e8947','snapshots',0,'2025-12-06 10:10:50',NULL),('2025-12-05 10:10:51','2025-12-05 10:10:51','2025-12-05 10:10:51',1,138,'ef78dbc4-08d5-48ce-8098-da71220a0d09',46,'b0b9e4dc414946c097d558d4b89e8947','gigabytes',0,'2025-12-06 10:10:50',NULL),('2025-12-05 10:10:51','2025-12-05 10:10:51','2025-12-05 10:10:51',1,139,'e9ce319d-e367-4b7c-bdca-3e19267cfa94',48,'b0b9e4dc414946c097d558d4b89e8947','gigabytes_tripleo',0,'2025-12-06 10:10:50',NULL),('2025-12-05 10:10:51','2025-12-05 10:10:51','2025-12-05 10:10:51',1,140,'81710cda-db52-4b71-8fed-45abbb7f65cc',50,'b0b9e4dc414946c097d558d4b89e8947','snapshots_tripleo',0,'2025-12-06 10:10:50',NULL),('2025-12-05 10:10:51','2025-12-05 10:10:51','2025-12-05 10:10:51',1,141,'95872fa7-e725-4d3e-84e2-deff2d79557c',51,'b984bc032821439da9e14438f496b701','snapshots',0,'2025-12-06 10:10:51',NULL),('2025-12-05 10:10:51','2025-12-05 10:10:51','2025-12-05 10:10:51',1,142,'e4ed7098-5562-42ea-a6f3-48a9761216e7',42,'b984bc032821439da9e14438f496b701','gigabytes',0,'2025-12-06 10:10:51',NULL),('2025-12-05 10:10:51','2025-12-05 10:10:51','2025-12-05 10:10:51',1,143,'4da9ca38-8c48-45d5-9d70-4e7280aad271',44,'b984bc032821439da9e14438f496b701','gigabytes_tripleo',0,'2025-12-06 10:10:51',NULL),('2025-12-05 10:10:51','2025-12-05 10:10:51','2025-12-05 10:10:51',1,144,'bc5ae254-ee3f-45f6-88fa-ce6754b79917',52,'b984bc032821439da9e14438f496b701','snapshots_tripleo',0,'2025-12-06 10:10:51',NULL),('2025-12-05 10:10:52','2025-12-05 10:10:52','2025-12-05 10:10:52',1,145,'d27d83ad-bd9a-47ab-b5c3-cf63e64f40b6',45,'b0b9e4dc414946c097d558d4b89e8947','volumes',-1,'2025-12-06 10:10:52',NULL),('2025-12-05 10:10:52','2025-12-05 10:10:52','2025-12-05 10:10:52',1,146,'debdf848-dbbf-44ad-ae24-3bf4a40a53ea',46,'b0b9e4dc414946c097d558d4b89e8947','gigabytes',-1,'2025-12-06 10:10:52',NULL),('2025-12-05 10:10:52','2025-12-05 10:10:52','2025-12-05 10:10:52',1,147,'0108f951-8e0d-4b10-945f-6b7fc0c82e2c',47,'b0b9e4dc414946c097d558d4b89e8947','volumes_tripleo',-1,'2025-12-06 10:10:52',NULL),('2025-12-05 10:10:52','2025-12-05 10:10:52','2025-12-05 10:10:52',1,148,'8e965308-5ea3-44c8-9cf8-467dea047b81',48,'b0b9e4dc414946c097d558d4b89e8947','gigabytes_tripleo',-1,'2025-12-06 10:10:52',NULL),('2025-12-05 10:10:52','2025-12-05 10:10:52','2025-12-05 10:10:52',1,149,'470ebc7d-dd40-47b7-87ce-05a79535841f',41,'b984bc032821439da9e14438f496b701','volumes',1,'2025-12-06 10:10:52',NULL),('2025-12-05 10:10:52','2025-12-05 10:10:52','2025-12-05 10:10:52',1,150,'406dca52-a6e3-4a6e-8176-35c18ef1cae3',42,'b984bc032821439da9e14438f496b701','gigabytes',1,'2025-12-06 10:10:52',NULL),('2025-12-05 10:10:52','2025-12-05 10:10:52','2025-12-05 10:10:52',1,151,'de49bb63-8013-45d9-b4de-1df5a6e8a1cc',43,'b984bc032821439da9e14438f496b701','volumes_tripleo',1,'2025-12-06 10:10:52',NULL),('2025-12-05 10:10:52','2025-12-05 10:10:52','2025-12-05 10:10:52',1,152,'28c86cd6-73b3-41e5-9210-f0eee7181252',44,'b984bc032821439da9e14438f496b701','gigabytes_tripleo',1,'2025-12-06 10:10:52',NULL),('2025-12-05 10:10:56','2025-12-05 10:10:57','2025-12-05 10:10:57',1,153,'7b8da122-bed5-4781-967e-c77c818f16a0',41,'b984bc032821439da9e14438f496b701','volumes',-1,'2025-12-06 10:10:56',NULL),('2025-12-05 10:10:56','2025-12-05 10:10:57','2025-12-05 10:10:57',1,154,'4afd6056-a70b-4bdb-a157-88f24bca9011',42,'b984bc032821439da9e14438f496b701','gigabytes',-1,'2025-12-06 10:10:56',NULL),('2025-12-05 10:10:56','2025-12-05 10:10:57','2025-12-05 10:10:57',1,155,'7745b325-06ad-49ac-87b1-f041ac7fbf2f',43,'b984bc032821439da9e14438f496b701','volumes_tripleo',-1,'2025-12-06 10:10:56',NULL),('2025-12-05 10:10:56','2025-12-05 10:10:57','2025-12-05 10:10:57',1,156,'fa36774b-4dd8-497b-b762-2796d5ec516f',44,'b984bc032821439da9e14438f496b701','gigabytes_tripleo',-1,'2025-12-06 10:10:56',NULL),('2025-12-05 10:11:29','2025-12-05 10:11:29','2025-12-05 10:11:29',1,157,'5f1c0a2c-9652-4d4a-9349-36a89f8a24b3',53,'2238ffb217584686904f563705640aa4','volumes',1,'2025-12-06 10:11:29',NULL),('2025-12-05 10:11:29','2025-12-05 10:11:29','2025-12-05 10:11:29',1,158,'6534c011-66e4-4411-8221-e3ef92f2b40c',54,'2238ffb217584686904f563705640aa4','gigabytes',1,'2025-12-06 10:11:29',NULL),('2025-12-05 10:11:29','2025-12-05 10:11:29','2025-12-05 10:11:29',1,159,'637cc9b0-14c8-42a7-8728-d741cd3cc883',55,'2238ffb217584686904f563705640aa4','volumes_tripleo',1,'2025-12-06 10:11:29',NULL),('2025-12-05 10:11:29','2025-12-05 10:11:29','2025-12-05 10:11:29',1,160,'ef7eb5c7-17e3-48aa-9d26-56abce632305',56,'2238ffb217584686904f563705640aa4','gigabytes_tripleo',1,'2025-12-06 10:11:29',NULL),('2025-12-05 10:11:37','2025-12-05 10:11:37','2025-12-05 10:11:37',1,161,'c42fb0de-16c7-4aee-ad11-e4511643c478',53,'2238ffb217584686904f563705640aa4','volumes',1,'2025-12-06 10:11:37',NULL),('2025-12-05 10:11:37','2025-12-05 10:11:37','2025-12-05 10:11:37',1,162,'dabc8591-af61-4b7c-9c81-18d594f1ed92',54,'2238ffb217584686904f563705640aa4','gigabytes',1,'2025-12-06 10:11:37',NULL),('2025-12-05 10:11:37','2025-12-05 10:11:37','2025-12-05 10:11:37',1,163,'50ae78c5-0a75-4861-a349-31fc3bcd2d1a',55,'2238ffb217584686904f563705640aa4','volumes_tripleo',1,'2025-12-06 10:11:37',NULL),('2025-12-05 10:11:37','2025-12-05 10:11:37','2025-12-05 10:11:37',1,164,'8da24def-f658-47c2-8571-4617589adb91',56,'2238ffb217584686904f563705640aa4','gigabytes_tripleo',1,'2025-12-06 10:11:37',NULL),('2025-12-05 10:11:40','2025-12-05 10:11:40','2025-12-05 10:11:40',1,165,'1f4693ac-804f-4edd-996a-9567e6b0bb83',53,'2238ffb217584686904f563705640aa4','volumes',-1,'2025-12-06 10:11:40',NULL),('2025-12-05 10:11:40','2025-12-05 10:11:40','2025-12-05 10:11:40',1,166,'61f22364-fd33-4361-ba4e-3676fca51c50',54,'2238ffb217584686904f563705640aa4','gigabytes',-1,'2025-12-06 10:11:40',NULL),('2025-12-05 10:11:40','2025-12-05 10:11:40','2025-12-05 10:11:40',1,167,'b6636e68-5f6c-45e2-ab09-574712a14369',55,'2238ffb217584686904f563705640aa4','volumes_tripleo',-1,'2025-12-06 10:11:40',NULL),('2025-12-05 10:11:40','2025-12-05 10:11:40','2025-12-05 10:11:40',1,168,'8a1017e1-ea27-4c41-808d-bd6bd46f5ac8',56,'2238ffb217584686904f563705640aa4','gigabytes_tripleo',-1,'2025-12-06 10:11:40',NULL),('2025-12-05 10:11:41','2025-12-05 10:11:41','2025-12-05 10:11:41',1,169,'bab34b8c-e5a1-4080-b58e-c36e08eeaa39',53,'2238ffb217584686904f563705640aa4','volumes',-1,'2025-12-06 10:11:41',NULL),('2025-12-05 10:11:41','2025-12-05 10:11:41','2025-12-05 10:11:41',1,170,'12768076-e0cb-4856-bebb-0e5012db1cbc',54,'2238ffb217584686904f563705640aa4','gigabytes',-1,'2025-12-06 10:11:41',NULL),('2025-12-05 10:11:41','2025-12-05 10:11:41','2025-12-05 10:11:41',1,171,'c2e8f3a9-d6d0-45cf-91f6-b8726623c63c',55,'2238ffb217584686904f563705640aa4','volumes_tripleo',-1,'2025-12-06 10:11:41',NULL),('2025-12-05 10:11:41','2025-12-05 10:11:41','2025-12-05 10:11:41',1,172,'744dc9d5-436a-4211-a7fa-f9da10b0cca5',56,'2238ffb217584686904f563705640aa4','gigabytes_tripleo',-1,'2025-12-06 10:11:41',NULL),('2025-12-05 10:11:42','2025-12-05 10:11:42','2025-12-05 10:11:42',1,173,'2c94c901-ce21-4b6e-9ab7-3b8c8774eccf',53,'2238ffb217584686904f563705640aa4','volumes',1,'2025-12-06 10:11:42',NULL),('2025-12-05 10:11:42','2025-12-05 10:11:42','2025-12-05 10:11:42',1,174,'f2c968eb-6154-4afd-807b-f09e44088133',54,'2238ffb217584686904f563705640aa4','gigabytes',1,'2025-12-06 10:11:42',NULL),('2025-12-05 10:11:42','2025-12-05 10:11:42','2025-12-05 10:11:42',1,175,'b8820982-f4ed-4a49-8034-193e279ea19e',55,'2238ffb217584686904f563705640aa4','volumes_tripleo',1,'2025-12-06 10:11:42',NULL),('2025-12-05 10:11:42','2025-12-05 10:11:42','2025-12-05 10:11:42',1,176,'72d21de5-304a-4f86-a5ff-a62f8f7add5d',56,'2238ffb217584686904f563705640aa4','gigabytes_tripleo',1,'2025-12-06 10:11:42',NULL),('2025-12-05 10:11:43','2025-12-05 10:11:43','2025-12-05 10:11:43',1,177,'980729c8-e0e1-4bd6-888a-f2aa52f59e94',53,'2238ffb217584686904f563705640aa4','volumes',1,'2025-12-06 10:11:43',NULL),('2025-12-05 10:11:43','2025-12-05 10:11:43','2025-12-05 10:11:43',1,178,'8f8e9f17-f8aa-4f69-8d56-81ac1ecf22ae',54,'2238ffb217584686904f563705640aa4','gigabytes',2,'2025-12-06 10:11:43',NULL),('2025-12-05 10:11:43','2025-12-05 10:11:43','2025-12-05 10:11:43',1,179,'c6ab256c-617d-46de-9031-53a9e1511bba',55,'2238ffb217584686904f563705640aa4','volumes_tripleo',1,'2025-12-06 10:11:43',NULL),('2025-12-05 10:11:43','2025-12-05 10:11:43','2025-12-05 10:11:43',1,180,'9857216f-e7cf-443b-96d2-638ca904a8b6',56,'2238ffb217584686904f563705640aa4','gigabytes_tripleo',2,'2025-12-06 10:11:43',NULL),('2025-12-05 10:11:46','2025-12-05 10:11:48','2025-12-05 10:11:48',1,181,'6395f29c-4f85-4624-8dbf-d4be064118fa',53,'2238ffb217584686904f563705640aa4','volumes',-1,'2025-12-06 10:11:46',NULL),('2025-12-05 10:11:46','2025-12-05 10:11:48','2025-12-05 10:11:48',1,182,'9561ae3e-d4c5-48a3-8c62-20ea24c9a799',54,'2238ffb217584686904f563705640aa4','gigabytes',-2,'2025-12-06 10:11:46',NULL),('2025-12-05 10:11:46','2025-12-05 10:11:48','2025-12-05 10:11:48',1,183,'0c72e410-2574-46f0-a6ed-673dfef1f1f6',55,'2238ffb217584686904f563705640aa4','volumes_tripleo',-1,'2025-12-06 10:11:46',NULL),('2025-12-05 10:11:46','2025-12-05 10:11:48','2025-12-05 10:11:48',1,184,'1009be6d-60de-4ebf-8022-db981d10f564',56,'2238ffb217584686904f563705640aa4','gigabytes_tripleo',-2,'2025-12-06 10:11:46',NULL),('2025-12-05 10:11:49','2025-12-05 10:11:49','2025-12-05 10:11:49',1,185,'2ccaf05b-8dd0-45f2-8a68-112f61352557',53,'2238ffb217584686904f563705640aa4','volumes',-1,'2025-12-06 10:11:49',NULL),('2025-12-05 10:11:49','2025-12-05 10:11:49','2025-12-05 10:11:49',1,186,'fe9981e7-6618-42b2-9166-c2e0f5f0be40',54,'2238ffb217584686904f563705640aa4','gigabytes',-1,'2025-12-06 10:11:49',NULL),('2025-12-05 10:11:49','2025-12-05 10:11:49','2025-12-05 10:11:49',1,187,'1b6b5da3-5a7b-4b9b-a6a2-d3a96f5e4c16',55,'2238ffb217584686904f563705640aa4','volumes_tripleo',-1,'2025-12-06 10:11:49',NULL),('2025-12-05 10:11:49','2025-12-05 10:11:49','2025-12-05 10:11:49',1,188,'4e95ceb3-1e26-4f99-bfa6-cae38947b65f',56,'2238ffb217584686904f563705640aa4','gigabytes_tripleo',-1,'2025-12-06 10:11:49',NULL),('2025-12-05 10:11:58','2025-12-05 10:11:58','2025-12-05 10:11:58',1,189,'dabc9a79-2c9d-41c3-b1d8-257b259bbe86',57,'07ccd9396684429596646bded13e438a','volumes',1,'2025-12-06 10:11:58',NULL),('2025-12-05 10:11:58','2025-12-05 10:11:58','2025-12-05 10:11:58',1,190,'c9d09ef7-d49c-4d59-a8bd-cf525f034d7a',58,'07ccd9396684429596646bded13e438a','gigabytes',2,'2025-12-06 10:11:58',NULL),('2025-12-05 10:11:58','2025-12-05 10:11:58','2025-12-05 10:11:58',1,191,'5b6d0ad3-5998-4f24-aa04-be26c360b1fe',59,'07ccd9396684429596646bded13e438a','volumes_tripleo',1,'2025-12-06 10:11:58',NULL),('2025-12-05 10:11:58','2025-12-05 10:11:58','2025-12-05 10:11:58',1,192,'b03ca8ea-0fac-438d-a98c-f09a668e2c4a',60,'07ccd9396684429596646bded13e438a','gigabytes_tripleo',2,'2025-12-06 10:11:58',NULL),('2025-12-05 10:11:59','2025-12-05 10:12:00','2025-12-05 10:12:00',1,193,'96e17621-4973-46de-92a7-923e1e35c65c',57,'07ccd9396684429596646bded13e438a','volumes',-1,'2025-12-06 10:11:59',NULL),('2025-12-05 10:11:59','2025-12-05 10:12:00','2025-12-05 10:12:00',1,194,'e50cbd19-3d5e-454b-88d8-26343adc15e5',58,'07ccd9396684429596646bded13e438a','gigabytes',-2,'2025-12-06 10:11:59',NULL),('2025-12-05 10:11:59','2025-12-05 10:12:00','2025-12-05 10:12:00',1,195,'02a93712-55a2-4a12-98d2-5772d01d5ae4',59,'07ccd9396684429596646bded13e438a','volumes_tripleo',-1,'2025-12-06 10:11:59',NULL),('2025-12-05 10:11:59','2025-12-05 10:12:00','2025-12-05 10:12:00',1,196,'7b55b1e2-6e97-4c84-acfd-c12b61b5e37d',60,'07ccd9396684429596646bded13e438a','gigabytes_tripleo',-2,'2025-12-06 10:11:59',NULL),('2025-12-05 10:12:05','2025-12-05 10:12:05','2025-12-05 10:12:05',1,197,'59087b3c-b4ef-4e6b-b16e-1a8accb5e492',61,'9e3d3287162a4caabf625f0490cbd91d','volumes',1,'2025-12-06 10:12:05',NULL),('2025-12-05 10:12:05','2025-12-05 10:12:05','2025-12-05 10:12:05',1,198,'0648c56b-92e0-42d8-bdec-52ebe4da96bc',62,'9e3d3287162a4caabf625f0490cbd91d','gigabytes',1,'2025-12-06 10:12:05',NULL),('2025-12-05 10:12:05','2025-12-05 10:12:05','2025-12-05 10:12:05',1,199,'fcecd6c9-b29b-4ad1-89da-52cddeebf1ff',63,'9e3d3287162a4caabf625f0490cbd91d','volumes_tripleo',1,'2025-12-06 10:12:05',NULL),('2025-12-05 10:12:05','2025-12-05 10:12:05','2025-12-05 10:12:05',1,200,'cb2ca35f-a7e7-49e3-918a-b8a3a9960a42',64,'9e3d3287162a4caabf625f0490cbd91d','gigabytes_tripleo',1,'2025-12-06 10:12:05',NULL),('2025-12-05 10:12:07','2025-12-05 10:12:07','2025-12-05 10:12:07',1,201,'d12a9b8d-9bb4-4011-b223-53f2363137c8',65,'9e3d3287162a4caabf625f0490cbd91d','snapshots',1,'2025-12-06 10:12:06',NULL),('2025-12-05 10:12:07','2025-12-05 10:12:07','2025-12-05 10:12:07',1,202,'e6806fcb-a151-4f02-ac7c-461ac96b5617',62,'9e3d3287162a4caabf625f0490cbd91d','gigabytes',1,'2025-12-06 10:12:06',NULL),('2025-12-05 10:12:07','2025-12-05 10:12:07','2025-12-05 10:12:07',1,203,'5c8a1e0c-144d-4ce3-94d3-3a4108d5841a',64,'9e3d3287162a4caabf625f0490cbd91d','gigabytes_tripleo',1,'2025-12-06 10:12:06',NULL),('2025-12-05 10:12:07','2025-12-05 10:12:07','2025-12-05 10:12:07',1,204,'47eb9058-3253-4cdc-8d06-ddcfca8c0ede',66,'9e3d3287162a4caabf625f0490cbd91d','snapshots_tripleo',1,'2025-12-06 10:12:06',NULL),('2025-12-05 10:12:07','2025-12-05 10:12:07','2025-12-05 10:12:07',1,205,'3b1ec14b-0d58-48cb-842c-0def12f08ab1',67,'9b06ebc1eb5f4622b3198559907b39ec','volumes',1,'2025-12-06 10:12:07',NULL),('2025-12-05 10:12:07','2025-12-05 10:12:07','2025-12-05 10:12:07',1,206,'41aa88c0-9002-4336-9cfa-05869e744d3c',68,'9b06ebc1eb5f4622b3198559907b39ec','gigabytes',1,'2025-12-06 10:12:07',NULL),('2025-12-05 10:12:07','2025-12-05 10:12:07','2025-12-05 10:12:07',1,207,'9731a9ca-f41d-46ef-b0d1-f24ff0bbdb38',69,'9b06ebc1eb5f4622b3198559907b39ec','volumes_tripleo',1,'2025-12-06 10:12:07',NULL),('2025-12-05 10:12:07','2025-12-05 10:12:07','2025-12-05 10:12:07',1,208,'3588f6b3-bc5b-4eab-a4af-f3a62c1c5f05',70,'9b06ebc1eb5f4622b3198559907b39ec','gigabytes_tripleo',1,'2025-12-06 10:12:07',NULL),('2025-12-05 10:12:09','2025-12-05 10:12:09','2025-12-05 10:12:09',1,209,'d55803a9-2edb-4f63-aeed-ae96f4c2cd58',71,'9b06ebc1eb5f4622b3198559907b39ec','snapshots',1,'2025-12-06 10:12:09',NULL),('2025-12-05 10:12:09','2025-12-05 10:12:09','2025-12-05 10:12:09',1,210,'c43aa823-df47-4101-8c5b-bf4570ef8cab',68,'9b06ebc1eb5f4622b3198559907b39ec','gigabytes',1,'2025-12-06 10:12:09',NULL),('2025-12-05 10:12:09','2025-12-05 10:12:09','2025-12-05 10:12:09',1,211,'76421023-f9ca-4f6b-b6ea-a8f1d40e999b',70,'9b06ebc1eb5f4622b3198559907b39ec','gigabytes_tripleo',1,'2025-12-06 10:12:09',NULL),('2025-12-05 10:12:09','2025-12-05 10:12:09','2025-12-05 10:12:09',1,212,'e29f71f9-cdba-4b2b-9691-d1b35223c092',72,'9b06ebc1eb5f4622b3198559907b39ec','snapshots_tripleo',1,'2025-12-06 10:12:09',NULL),('2025-12-05 10:12:09','2025-12-05 10:12:09','2025-12-05 10:12:09',1,213,'cfa70103-54ce-46ff-98e2-17197e762895',65,'9e3d3287162a4caabf625f0490cbd91d','snapshots',1,'2025-12-06 10:12:09',NULL),('2025-12-05 10:12:09','2025-12-05 10:12:09','2025-12-05 10:12:09',1,214,'5aa67bfd-df7d-4390-b6ff-26fb50eb528a',62,'9e3d3287162a4caabf625f0490cbd91d','gigabytes',1,'2025-12-06 10:12:09',NULL),('2025-12-05 10:12:09','2025-12-05 10:12:09','2025-12-05 10:12:09',1,215,'0f969987-cbc3-43ab-9152-f1cfdf29064e',64,'9e3d3287162a4caabf625f0490cbd91d','gigabytes_tripleo',1,'2025-12-06 10:12:09',NULL),('2025-12-05 10:12:09','2025-12-05 10:12:09','2025-12-05 10:12:09',1,216,'a6240919-dd72-48ae-a4eb-d8aac826b354',66,'9e3d3287162a4caabf625f0490cbd91d','snapshots_tripleo',1,'2025-12-06 10:12:09',NULL),('2025-12-05 10:12:10','2025-12-05 10:12:10','2025-12-05 10:12:10',1,217,'ac650d9e-0d16-4e81-b374-e5b63dbd9cd4',65,'9e3d3287162a4caabf625f0490cbd91d','snapshots',1,'2025-12-06 10:12:10',NULL),('2025-12-05 10:12:10','2025-12-05 10:12:10','2025-12-05 10:12:10',1,218,'0cbd0992-3b57-4681-a62a-bef0fde78304',62,'9e3d3287162a4caabf625f0490cbd91d','gigabytes',1,'2025-12-06 10:12:10',NULL),('2025-12-05 10:12:10','2025-12-05 10:12:10','2025-12-05 10:12:10',1,219,'78b7e58e-7672-4ea2-b756-a98ce0a6bb4a',64,'9e3d3287162a4caabf625f0490cbd91d','gigabytes_tripleo',1,'2025-12-06 10:12:10',NULL),('2025-12-05 10:12:10','2025-12-05 10:12:10','2025-12-05 10:12:10',1,220,'f36f6011-5a61-4430-a60d-71d93a29737a',66,'9e3d3287162a4caabf625f0490cbd91d','snapshots_tripleo',1,'2025-12-06 10:12:10',NULL),('2025-12-05 10:12:13','2025-12-05 10:12:13','2025-12-05 10:12:13',1,221,'769c772d-3525-4f4d-9bff-0b61e0d7baf4',71,'9b06ebc1eb5f4622b3198559907b39ec','snapshots',-1,'2025-12-06 10:12:13',NULL),('2025-12-05 10:12:13','2025-12-05 10:12:13','2025-12-05 10:12:13',1,222,'3cc1d839-0de2-43e3-9e92-8429b34e8938',68,'9b06ebc1eb5f4622b3198559907b39ec','gigabytes',-1,'2025-12-06 10:12:13',NULL),('2025-12-05 10:12:13','2025-12-05 10:12:13','2025-12-05 10:12:13',1,223,'8effa3a7-23cc-46bd-8293-fb9b24f5378b',70,'9b06ebc1eb5f4622b3198559907b39ec','gigabytes_tripleo',-1,'2025-12-06 10:12:13',NULL),('2025-12-05 10:12:13','2025-12-05 10:12:13','2025-12-05 10:12:13',1,224,'7a4ab3c2-8844-4ff9-9ffd-a61b996eee8b',72,'9b06ebc1eb5f4622b3198559907b39ec','snapshots_tripleo',-1,'2025-12-06 10:12:13',NULL),('2025-12-05 10:12:14','2025-12-05 10:12:14','2025-12-05 10:12:14',1,225,'e61d7880-dae3-4bc8-a159-0a08684eb319',67,'9b06ebc1eb5f4622b3198559907b39ec','volumes',-1,'2025-12-06 10:12:14',NULL),('2025-12-05 10:12:14','2025-12-05 10:12:14','2025-12-05 10:12:14',1,226,'e7131731-9c11-449f-b78c-11eeb30da1e0',68,'9b06ebc1eb5f4622b3198559907b39ec','gigabytes',-1,'2025-12-06 10:12:14',NULL),('2025-12-05 10:12:14','2025-12-05 10:12:14','2025-12-05 10:12:14',1,227,'9a28cab4-2e09-4441-a804-c9676bf89012',69,'9b06ebc1eb5f4622b3198559907b39ec','volumes_tripleo',-1,'2025-12-06 10:12:14',NULL),('2025-12-05 10:12:14','2025-12-05 10:12:14','2025-12-05 10:12:14',1,228,'a84463d7-18fa-4acc-bc37-e0c745c18c1b',70,'9b06ebc1eb5f4622b3198559907b39ec','gigabytes_tripleo',-1,'2025-12-06 10:12:14',NULL),('2025-12-05 10:12:15','2025-12-05 10:12:15','2025-12-05 10:12:15',1,229,'7063d638-a9b3-4480-b8e7-a540ff6d9336',65,'9e3d3287162a4caabf625f0490cbd91d','snapshots',-1,'2025-12-06 10:12:15',NULL),('2025-12-05 10:12:15','2025-12-05 10:12:15','2025-12-05 10:12:15',1,230,'3fab6f1c-cc93-4f6b-9b21-c0a479061e93',62,'9e3d3287162a4caabf625f0490cbd91d','gigabytes',-1,'2025-12-06 10:12:15',NULL),('2025-12-05 10:12:15','2025-12-05 10:12:15','2025-12-05 10:12:15',1,231,'a2f15b86-9f06-4aee-a80f-8af839332864',64,'9e3d3287162a4caabf625f0490cbd91d','gigabytes_tripleo',-1,'2025-12-06 10:12:15',NULL),('2025-12-05 10:12:15','2025-12-05 10:12:15','2025-12-05 10:12:15',1,232,'800d8ca5-365f-4bb2-8a6f-ce3229bb113e',66,'9e3d3287162a4caabf625f0490cbd91d','snapshots_tripleo',-1,'2025-12-06 10:12:15',NULL),('2025-12-05 10:12:17','2025-12-05 10:12:17','2025-12-05 10:12:17',1,233,'30347593-7d78-46ab-be1b-dab5045a23ae',65,'9e3d3287162a4caabf625f0490cbd91d','snapshots',-1,'2025-12-06 10:12:17',NULL),('2025-12-05 10:12:17','2025-12-05 10:12:17','2025-12-05 10:12:17',1,234,'fa116859-a5a2-4daa-8395-b00a68e51e48',62,'9e3d3287162a4caabf625f0490cbd91d','gigabytes',-1,'2025-12-06 10:12:17',NULL),('2025-12-05 10:12:17','2025-12-05 10:12:17','2025-12-05 10:12:17',1,235,'5648d190-bbc5-4a3d-8bc4-55b7de7479ab',64,'9e3d3287162a4caabf625f0490cbd91d','gigabytes_tripleo',-1,'2025-12-06 10:12:17',NULL),('2025-12-05 10:12:17','2025-12-05 10:12:17','2025-12-05 10:12:17',1,236,'726cf0a8-f981-4a1a-b6f3-6ad61e961e0b',66,'9e3d3287162a4caabf625f0490cbd91d','snapshots_tripleo',-1,'2025-12-06 10:12:17',NULL),('2025-12-05 10:12:19','2025-12-05 10:12:19','2025-12-05 10:12:19',1,237,'25555b10-9b4c-4b29-b5a6-7ebc1821f422',65,'9e3d3287162a4caabf625f0490cbd91d','snapshots',-1,'2025-12-06 10:12:19',NULL),('2025-12-05 10:12:19','2025-12-05 10:12:19','2025-12-05 10:12:19',1,238,'e529e894-7d0a-40ba-adb3-51b68ac72fc4',62,'9e3d3287162a4caabf625f0490cbd91d','gigabytes',-1,'2025-12-06 10:12:19',NULL),('2025-12-05 10:12:19','2025-12-05 10:12:19','2025-12-05 10:12:19',1,239,'f41ea8fe-eaef-4ea1-9f6a-c900ed6cda84',64,'9e3d3287162a4caabf625f0490cbd91d','gigabytes_tripleo',-1,'2025-12-06 10:12:19',NULL),('2025-12-05 10:12:19','2025-12-05 10:12:19','2025-12-05 10:12:19',1,240,'85d7dc1e-7e63-47c8-84bb-2696fe8fc80e',66,'9e3d3287162a4caabf625f0490cbd91d','snapshots_tripleo',-1,'2025-12-06 10:12:19',NULL),('2025-12-05 10:12:20','2025-12-05 10:12:21','2025-12-05 10:12:21',1,241,'288ff9a3-401d-4bce-9f95-66c9a86cbe73',61,'9e3d3287162a4caabf625f0490cbd91d','volumes',-1,'2025-12-06 10:12:20',NULL),('2025-12-05 10:12:20','2025-12-05 10:12:21','2025-12-05 10:12:21',1,242,'89184cab-a463-4e9c-b786-72247ee84ea6',62,'9e3d3287162a4caabf625f0490cbd91d','gigabytes',-1,'2025-12-06 10:12:20',NULL),('2025-12-05 10:12:20','2025-12-05 10:12:21','2025-12-05 10:12:21',1,243,'8e539c57-37e0-468e-9c75-568ec46d10e4',63,'9e3d3287162a4caabf625f0490cbd91d','volumes_tripleo',-1,'2025-12-06 10:12:20',NULL),('2025-12-05 10:12:21','2025-12-05 10:12:21','2025-12-05 10:12:21',1,244,'53b1bb6d-db74-4120-828a-8fdd7f4b797c',64,'9e3d3287162a4caabf625f0490cbd91d','gigabytes_tripleo',-1,'2025-12-06 10:12:20',NULL),('2025-12-05 10:12:24','2025-12-05 10:12:24','2025-12-05 10:12:24',1,245,'e86641b0-20f1-47eb-8951-ec981141fb21',73,'02098318982046faa2136ab12b344eb1','volumes',1,'2025-12-06 10:12:24',NULL),('2025-12-05 10:12:24','2025-12-05 10:12:24','2025-12-05 10:12:24',1,246,'735850bd-b8a2-4b54-9c9e-50f6eb51e43a',74,'02098318982046faa2136ab12b344eb1','gigabytes',1,'2025-12-06 10:12:24',NULL),('2025-12-05 10:12:24','2025-12-05 10:12:24','2025-12-05 10:12:24',1,247,'48cbe569-b254-44d9-a3ed-b59bbff60b1f',75,'02098318982046faa2136ab12b344eb1','volumes_tripleo',1,'2025-12-06 10:12:24',NULL),('2025-12-05 10:12:24','2025-12-05 10:12:24','2025-12-05 10:12:24',1,248,'d6616d28-04bd-4998-bcea-5a2513ebd760',76,'02098318982046faa2136ab12b344eb1','gigabytes_tripleo',1,'2025-12-06 10:12:24',NULL),('2025-12-05 10:12:26','2025-12-05 10:12:26','2025-12-05 10:12:26',1,249,'caaae77c-79ef-464f-ae8b-b3999d574f47',77,'02098318982046faa2136ab12b344eb1','backups',1,'2025-12-06 10:12:26',NULL),('2025-12-05 10:12:26','2025-12-05 10:12:26','2025-12-05 10:12:26',1,250,'8409ca47-f007-4034-9632-a3ae5df6a86e',78,'02098318982046faa2136ab12b344eb1','backup_gigabytes',1,'2025-12-06 10:12:26',NULL),('2025-12-05 10:12:27','2025-12-05 10:12:27','2025-12-05 10:12:27',1,251,'e82d8ce9-aaef-4b73-9f41-f62b0d831485',79,'ef76e1242a6d41498f75478c52cab8e4','volumes',1,'2025-12-06 10:12:27',NULL),('2025-12-05 10:12:27','2025-12-05 10:12:27','2025-12-05 10:12:27',1,252,'0a9bf265-dbaa-4d12-ae60-c4d3cbe58a05',80,'ef76e1242a6d41498f75478c52cab8e4','gigabytes',2,'2025-12-06 10:12:27',NULL),('2025-12-05 10:12:27','2025-12-05 10:12:27','2025-12-05 10:12:27',1,253,'24b5fa7e-67cc-463d-be32-ab80e29e507d',81,'ef76e1242a6d41498f75478c52cab8e4','volumes_tripleo',1,'2025-12-06 10:12:27',NULL),('2025-12-05 10:12:27','2025-12-05 10:12:27','2025-12-05 10:12:27',1,254,'e6cfef99-ab7f-4a73-8a7f-770f7259c43e',82,'ef76e1242a6d41498f75478c52cab8e4','gigabytes_tripleo',2,'2025-12-06 10:12:27',NULL),('2025-12-05 10:12:28','2025-12-05 10:12:28','2025-12-05 10:12:28',1,255,'10b3ae8b-6aeb-415d-9159-c36c7b6ee3f6',83,'ef76e1242a6d41498f75478c52cab8e4','snapshots',1,'2025-12-06 10:12:28',NULL),('2025-12-05 10:12:28','2025-12-05 10:12:28','2025-12-05 10:12:28',1,256,'2811259e-e4de-4b85-ac57-0bbe80b29004',80,'ef76e1242a6d41498f75478c52cab8e4','gigabytes',2,'2025-12-06 10:12:28',NULL),('2025-12-05 10:12:28','2025-12-05 10:12:28','2025-12-05 10:12:28',1,257,'ea251922-31c0-42cf-8627-cd477ead61cf',82,'ef76e1242a6d41498f75478c52cab8e4','gigabytes_tripleo',2,'2025-12-06 10:12:28',NULL),('2025-12-05 10:12:28','2025-12-05 10:12:28','2025-12-05 10:12:28',1,258,'b8e0c5ff-fc71-40a1-8664-94293630db11',84,'ef76e1242a6d41498f75478c52cab8e4','snapshots_tripleo',1,'2025-12-06 10:12:28',NULL),('2025-12-05 10:12:30','2025-12-05 10:12:30','2025-12-05 10:12:30',1,259,'9a7125f8-3345-44e7-af30-d4be010746e5',83,'ef76e1242a6d41498f75478c52cab8e4','snapshots',-1,'2025-12-06 10:12:30',NULL),('2025-12-05 10:12:30','2025-12-05 10:12:30','2025-12-05 10:12:30',1,260,'2c18eccc-f83f-4867-b9fd-a16fc38ca2ba',80,'ef76e1242a6d41498f75478c52cab8e4','gigabytes',-2,'2025-12-06 10:12:30',NULL),('2025-12-05 10:12:30','2025-12-05 10:12:30','2025-12-05 10:12:30',1,261,'f8653eb7-1697-4e7c-afa6-537a9c0795b8',82,'ef76e1242a6d41498f75478c52cab8e4','gigabytes_tripleo',-2,'2025-12-06 10:12:30',NULL),('2025-12-05 10:12:30','2025-12-05 10:12:30','2025-12-05 10:12:30',1,262,'f8259952-43e8-4805-bce4-ec86ab1c66f2',84,'ef76e1242a6d41498f75478c52cab8e4','snapshots_tripleo',-1,'2025-12-06 10:12:30',NULL),('2025-12-05 10:12:31','2025-12-05 10:12:31','2025-12-05 10:12:31',1,263,'090aaf5e-710d-4232-9790-f0f8fe4e4877',79,'ef76e1242a6d41498f75478c52cab8e4','volumes',-1,'2025-12-06 10:12:31',NULL),('2025-12-05 10:12:31','2025-12-05 10:12:31','2025-12-05 10:12:31',1,264,'6f74cdaf-041d-4fb1-8270-3879d91afec0',80,'ef76e1242a6d41498f75478c52cab8e4','gigabytes',-2,'2025-12-06 10:12:31',NULL),('2025-12-05 10:12:31','2025-12-05 10:12:31','2025-12-05 10:12:31',1,265,'051e43de-01ca-4cbd-9634-ce7c9faef1f0',81,'ef76e1242a6d41498f75478c52cab8e4','volumes_tripleo',-1,'2025-12-06 10:12:31',NULL),('2025-12-05 10:12:31','2025-12-05 10:12:31','2025-12-05 10:12:31',1,266,'ebbecbdf-488b-4160-b009-d419d24d52d0',82,'ef76e1242a6d41498f75478c52cab8e4','gigabytes_tripleo',-2,'2025-12-06 10:12:31',NULL),('2025-12-05 10:12:33','2025-12-05 10:12:33','2025-12-05 10:12:33',1,267,'f2aa0e6e-2e66-4a47-9bae-82e169d5b991',85,'b3bc4618821f4f30856e76f4b3843b68','groups',1,'2025-12-06 10:12:33',NULL),('2025-12-05 10:12:33','2025-12-05 10:12:33','2025-12-05 10:12:33',1,268,'b10624bd-ee20-4665-b2a8-06b98c1eb914',86,'c70f526bca874e278b9e8fa9cbae7937','backups',1,'2025-12-06 10:12:33',NULL),('2025-12-05 10:12:33','2025-12-05 10:12:33','2025-12-05 10:12:33',1,269,'d2e9631e-c843-42b2-91e8-8290f9092675',87,'c70f526bca874e278b9e8fa9cbae7937','backup_gigabytes',1,'2025-12-06 10:12:33',NULL),('2025-12-05 10:12:34','2025-12-05 10:12:34','2025-12-05 10:12:34',1,270,'3be929c1-2fed-4e13-ad4e-aefc637eb61f',88,'b3bc4618821f4f30856e76f4b3843b68','volumes',1,'2025-12-06 10:12:34',NULL),('2025-12-05 10:12:34','2025-12-05 10:12:34','2025-12-05 10:12:34',1,271,'42066ed3-85e8-42f7-b006-ac7a3fe03d42',89,'b3bc4618821f4f30856e76f4b3843b68','gigabytes',1,'2025-12-06 10:12:34',NULL),('2025-12-05 10:12:34','2025-12-05 10:12:34','2025-12-05 10:12:34',1,272,'61698b0b-b226-41e4-9c2a-e86ce5919bb6',90,'b3bc4618821f4f30856e76f4b3843b68','volumes_tempest-GroupsV314Test-volume-type-2079195531',1,'2025-12-06 10:12:34',NULL),('2025-12-05 10:12:34','2025-12-05 10:12:34','2025-12-05 10:12:34',1,273,'e1a662b0-8f6c-433a-8790-b0f7ddb52455',91,'b3bc4618821f4f30856e76f4b3843b68','gigabytes_tempest-GroupsV314Test-volume-type-2079195531',1,'2025-12-06 10:12:34',NULL),('2025-12-05 10:12:35','2025-12-05 10:12:35','2025-12-05 10:12:35',1,274,'727f41a7-558a-4af5-98ac-ab33cf1d1797',73,'02098318982046faa2136ab12b344eb1','volumes',1,'2025-12-06 10:12:35',NULL),('2025-12-05 10:12:35','2025-12-05 10:12:35','2025-12-05 10:12:35',1,275,'ae107aa4-bf60-43cc-8211-b1bdf710c486',74,'02098318982046faa2136ab12b344eb1','gigabytes',1,'2025-12-06 10:12:35',NULL),('2025-12-05 10:12:35','2025-12-05 10:12:35','2025-12-05 10:12:35',1,276,'01c76312-b267-43eb-be22-c33d687b0314',75,'02098318982046faa2136ab12b344eb1','volumes_tripleo',1,'2025-12-06 10:12:35',NULL),('2025-12-05 10:12:35','2025-12-05 10:12:35','2025-12-05 10:12:35',1,277,'586c69b4-b2c1-4d45-a9af-1e5c92d60041',76,'02098318982046faa2136ab12b344eb1','gigabytes_tripleo',1,'2025-12-06 10:12:35',NULL),('2025-12-05 10:12:36','2025-12-05 10:12:36','2025-12-05 10:12:36',1,278,'5909d71c-b644-4af3-aadc-280c10baf475',85,'b3bc4618821f4f30856e76f4b3843b68','groups',1,'2025-12-06 10:12:36',NULL),('2025-12-05 10:12:36','2025-12-05 10:12:37','2025-12-05 10:12:37',1,279,'aa706bba-70a0-4c58-bb0b-fb4df8001414',88,'b3bc4618821f4f30856e76f4b3843b68','volumes',1,'2025-12-06 10:12:36',NULL),('2025-12-05 10:12:37','2025-12-05 10:12:37','2025-12-05 10:12:37',1,280,'ecac810c-cb40-43e1-be40-751c03bdc30b',89,'b3bc4618821f4f30856e76f4b3843b68','gigabytes',1,'2025-12-06 10:12:36',NULL),('2025-12-05 10:12:37','2025-12-05 10:12:37','2025-12-05 10:12:37',1,281,'b427bd4d-ebef-4abb-bbde-f3b56615456d',90,'b3bc4618821f4f30856e76f4b3843b68','volumes_tempest-GroupsV314Test-volume-type-2079195531',1,'2025-12-06 10:12:36',NULL),('2025-12-05 10:12:37','2025-12-05 10:12:37','2025-12-05 10:12:37',1,282,'33c0d655-d1a8-41e0-91a9-c34f17d76075',91,'b3bc4618821f4f30856e76f4b3843b68','gigabytes_tempest-GroupsV314Test-volume-type-2079195531',1,'2025-12-06 10:12:36',NULL),('2025-12-05 10:12:41','2025-12-05 10:12:41','2025-12-05 10:12:41',1,283,'ba6b82e0-1934-4bc0-a071-b824cfa56a74',85,'b3bc4618821f4f30856e76f4b3843b68','groups',-1,'2025-12-06 10:12:41',NULL),('2025-12-05 10:12:41','2025-12-05 10:12:41','2025-12-05 10:12:41',1,284,'ef8a77b0-8b13-4e3c-83e4-4dcf09e1b205',88,'b3bc4618821f4f30856e76f4b3843b68','volumes',-1,'2025-12-06 10:12:41',NULL),('2025-12-05 10:12:41','2025-12-05 10:12:41','2025-12-05 10:12:41',1,285,'47a8879a-daae-45c3-88af-cae11c5a727e',89,'b3bc4618821f4f30856e76f4b3843b68','gigabytes',-1,'2025-12-06 10:12:41',NULL),('2025-12-05 10:12:41','2025-12-05 10:12:41','2025-12-05 10:12:41',1,286,'caaabfef-5e59-423d-929e-816092e4e082',90,'b3bc4618821f4f30856e76f4b3843b68','volumes_tempest-GroupsV314Test-volume-type-2079195531',-1,'2025-12-06 10:12:41',NULL),('2025-12-05 10:12:41','2025-12-05 10:12:41','2025-12-05 10:12:41',1,287,'7a75a6de-f7d0-45da-91eb-75152d50ebc2',91,'b3bc4618821f4f30856e76f4b3843b68','gigabytes_tempest-GroupsV314Test-volume-type-2079195531',-1,'2025-12-06 10:12:41',NULL),('2025-12-05 10:12:41','2025-12-05 10:12:42','2025-12-05 10:12:42',1,288,'3bdf488a-99d1-4d83-81ff-508e9585d1ba',86,'c70f526bca874e278b9e8fa9cbae7937','backups',-1,'2025-12-06 10:12:41',NULL),('2025-12-05 10:12:41','2025-12-05 10:12:42','2025-12-05 10:12:42',1,289,'29073ca2-f1f4-47cf-b82a-38df52c72a89',87,'c70f526bca874e278b9e8fa9cbae7937','backup_gigabytes',-1,'2025-12-06 10:12:41',NULL),('2025-12-05 10:12:42','2025-12-05 10:12:42','2025-12-05 10:12:42',1,290,'0e25e99a-f8cf-4c98-aaf5-ed6bff4d1a90',73,'02098318982046faa2136ab12b344eb1','volumes',-1,'2025-12-06 10:12:42',NULL),('2025-12-05 10:12:42','2025-12-05 10:12:42','2025-12-05 10:12:42',1,291,'53fcbf67-d086-4a8e-a737-f559bc006dba',74,'02098318982046faa2136ab12b344eb1','gigabytes',-1,'2025-12-06 10:12:42',NULL),('2025-12-05 10:12:42','2025-12-05 10:12:42','2025-12-05 10:12:42',1,292,'e1084d21-cdf6-464f-b371-3d8e5f5d1f18',75,'02098318982046faa2136ab12b344eb1','volumes_tripleo',-1,'2025-12-06 10:12:42',NULL),('2025-12-05 10:12:42','2025-12-05 10:12:42','2025-12-05 10:12:42',1,293,'5a30e413-69a3-4f57-8e9a-3c45a3c15e7a',76,'02098318982046faa2136ab12b344eb1','gigabytes_tripleo',-1,'2025-12-06 10:12:42',NULL),('2025-12-05 10:12:43','2025-12-05 10:12:43','2025-12-05 10:12:43',1,294,'c10fb1c8-8cde-4428-9c00-b8385874b1a6',85,'b3bc4618821f4f30856e76f4b3843b68','groups',-1,'2025-12-06 10:12:43',NULL),('2025-12-05 10:12:43','2025-12-05 10:12:43','2025-12-05 10:12:43',1,295,'a5f0c586-694b-49c9-9b12-097b10298247',88,'b3bc4618821f4f30856e76f4b3843b68','volumes',-1,'2025-12-06 10:12:43',NULL),('2025-12-05 10:12:43','2025-12-05 10:12:43','2025-12-05 10:12:43',1,296,'6c64985c-8952-4b40-8bf3-7f581cd5f980',89,'b3bc4618821f4f30856e76f4b3843b68','gigabytes',-1,'2025-12-06 10:12:43',NULL),('2025-12-05 10:12:43','2025-12-05 10:12:43','2025-12-05 10:12:43',1,297,'8789c96d-6a2a-4ea9-861d-b4fbbed3f038',90,'b3bc4618821f4f30856e76f4b3843b68','volumes_tempest-GroupsV314Test-volume-type-2079195531',-1,'2025-12-06 10:12:43',NULL),('2025-12-05 10:12:43','2025-12-05 10:12:43','2025-12-05 10:12:43',1,298,'25cfc119-39c2-43c3-bd7a-30912326431c',91,'b3bc4618821f4f30856e76f4b3843b68','gigabytes_tempest-GroupsV314Test-volume-type-2079195531',-1,'2025-12-06 10:12:43',NULL),('2025-12-05 10:12:44','2025-12-05 10:12:44','2025-12-05 10:12:44',1,299,'0c8299c1-cd0b-4b85-b9d9-f692cb800f22',77,'02098318982046faa2136ab12b344eb1','backups',-1,'2025-12-06 10:12:44',NULL),('2025-12-05 10:12:44','2025-12-05 10:12:44','2025-12-05 10:12:44',1,300,'b3e67c95-f6ac-4bec-9b79-85b43d4168cc',78,'02098318982046faa2136ab12b344eb1','backup_gigabytes',-1,'2025-12-06 10:12:44',NULL),('2025-12-05 10:12:47','2025-12-05 10:12:47','2025-12-05 10:12:47',1,301,'85cd59ff-cfc0-4ac0-b4b6-95c9b55e9bce',73,'02098318982046faa2136ab12b344eb1','volumes',-1,'2025-12-06 10:12:47',NULL),('2025-12-05 10:12:47','2025-12-05 10:12:47','2025-12-05 10:12:47',1,302,'b6f030bb-2f6d-4207-b570-733a5c078d7f',74,'02098318982046faa2136ab12b344eb1','gigabytes',-1,'2025-12-06 10:12:47',NULL),('2025-12-05 10:12:47','2025-12-05 10:12:47','2025-12-05 10:12:47',1,303,'5732e514-7e94-46cd-b022-38804f2d5fcf',75,'02098318982046faa2136ab12b344eb1','volumes_tripleo',-1,'2025-12-06 10:12:47',NULL),('2025-12-05 10:12:47','2025-12-05 10:12:47','2025-12-05 10:12:47',1,304,'705ad8a7-926b-4624-84a7-c8236a70457c',76,'02098318982046faa2136ab12b344eb1','gigabytes_tripleo',-1,'2025-12-06 10:12:47',NULL),('2025-12-05 10:12:48','2025-12-05 10:12:48','2025-12-05 10:12:48',1,305,'51fb24f5-7ffe-4178-b53e-26f9c2973669',73,'02098318982046faa2136ab12b344eb1','volumes',1,'2025-12-06 10:12:48',NULL),('2025-12-05 10:12:48','2025-12-05 10:12:48','2025-12-05 10:12:48',1,306,'cbb3f7d0-e769-400d-adec-5e083ed93671',74,'02098318982046faa2136ab12b344eb1','gigabytes',1,'2025-12-06 10:12:48',NULL),('2025-12-05 10:12:48','2025-12-05 10:12:48','2025-12-05 10:12:48',1,307,'16fdde59-42d8-4480-82fa-14ef42aeccf7',75,'02098318982046faa2136ab12b344eb1','volumes_tripleo',1,'2025-12-06 10:12:48',NULL),('2025-12-05 10:12:48','2025-12-05 10:12:48','2025-12-05 10:12:48',1,308,'61173e29-1f44-4d84-afc0-5e1a8c384a15',76,'02098318982046faa2136ab12b344eb1','gigabytes_tripleo',1,'2025-12-06 10:12:48',NULL),('2025-12-05 10:12:49','2025-12-05 10:12:49','2025-12-05 10:12:49',1,309,'1bf42201-bfff-477b-98de-a9db9b994338',77,'02098318982046faa2136ab12b344eb1','backups',1,'2025-12-06 10:12:49',NULL),('2025-12-05 10:12:49','2025-12-05 10:12:49','2025-12-05 10:12:49',1,310,'42840d86-bb2b-49fa-8c29-bdf96826bc9d',78,'02098318982046faa2136ab12b344eb1','backup_gigabytes',1,'2025-12-06 10:12:49',NULL),('2025-12-05 10:12:52','2025-12-05 10:12:52','2025-12-05 10:12:52',1,311,'86a84511-2a84-4ca7-b281-aa9f0c062e98',92,'870ab348edaf49d180b54cf5daaaacd1','volumes',1,'2025-12-06 10:12:52',NULL),('2025-12-05 10:12:52','2025-12-05 10:12:52','2025-12-05 10:12:52',1,312,'669ffd71-9d35-4464-b549-fa87b8f32985',93,'870ab348edaf49d180b54cf5daaaacd1','gigabytes',1,'2025-12-06 10:12:52',NULL),('2025-12-05 10:12:52','2025-12-05 10:12:52','2025-12-05 10:12:52',1,313,'933d58cf-002f-427f-b58f-2a9e056028de',94,'870ab348edaf49d180b54cf5daaaacd1','volumes_tempest-UserMessagesTest-volume-type-447267446',1,'2025-12-06 10:12:52',NULL),('2025-12-05 10:12:52','2025-12-05 10:12:52','2025-12-05 10:12:52',1,314,'dd43e585-2691-4ad0-889b-72a2c1802dd3',95,'870ab348edaf49d180b54cf5daaaacd1','gigabytes_tempest-UserMessagesTest-volume-type-447267446',1,'2025-12-06 10:12:52',NULL),('2025-12-05 10:12:54','2025-12-05 10:12:54','2025-12-05 10:12:54',1,315,'0c9a18b0-7133-4030-b654-4e1b0d3ece6a',92,'870ab348edaf49d180b54cf5daaaacd1','volumes',-1,'2025-12-06 10:12:54',NULL),('2025-12-05 10:12:54','2025-12-05 10:12:54','2025-12-05 10:12:54',1,316,'eced484e-c525-4e2b-9f56-f187866c8d0b',93,'870ab348edaf49d180b54cf5daaaacd1','gigabytes',-1,'2025-12-06 10:12:54',NULL),('2025-12-05 10:12:54','2025-12-05 10:12:54','2025-12-05 10:12:54',1,317,'05e1c7a4-5a4f-448b-a099-26643ae8ddc1',94,'870ab348edaf49d180b54cf5daaaacd1','volumes_tempest-UserMessagesTest-volume-type-447267446',-1,'2025-12-06 10:12:54',NULL),('2025-12-05 10:12:54','2025-12-05 10:12:54','2025-12-05 10:12:54',1,318,'c096d3fb-6c52-45c6-bcce-c42af94edf21',95,'870ab348edaf49d180b54cf5daaaacd1','gigabytes_tempest-UserMessagesTest-volume-type-447267446',-1,'2025-12-06 10:12:54',NULL),('2025-12-05 10:12:55','2025-12-05 10:12:55','2025-12-05 10:12:55',1,319,'318905ca-eeab-4cc0-b26f-64f64083de36',92,'870ab348edaf49d180b54cf5daaaacd1','volumes',1,'2025-12-06 10:12:55',NULL),('2025-12-05 10:12:55','2025-12-05 10:12:55','2025-12-05 10:12:55',1,320,'5525d1ab-2a7a-4655-9dcf-3370b19daa9b',93,'870ab348edaf49d180b54cf5daaaacd1','gigabytes',1,'2025-12-06 10:12:55',NULL),('2025-12-05 10:12:55','2025-12-05 10:12:55','2025-12-05 10:12:55',1,321,'2498f91b-a43c-4909-bc59-a0d0d3629a55',96,'870ab348edaf49d180b54cf5daaaacd1','volumes_tempest-UserMessagesTest-volume-type-1380476665',1,'2025-12-06 10:12:55',NULL),('2025-12-05 10:12:55','2025-12-05 10:12:55','2025-12-05 10:12:55',1,322,'ab98bbf2-90d2-4d91-bc58-845c3193bee5',97,'870ab348edaf49d180b54cf5daaaacd1','gigabytes_tempest-UserMessagesTest-volume-type-1380476665',1,'2025-12-06 10:12:55',NULL),('2025-12-05 10:12:55','2025-12-05 10:12:57','2025-12-05 10:12:57',1,323,'0932c307-8b8b-45f8-8729-80f45ef264f3',77,'02098318982046faa2136ab12b344eb1','backups',-1,'2025-12-06 10:12:55',NULL),('2025-12-05 10:12:55','2025-12-05 10:12:57','2025-12-05 10:12:57',1,324,'146bae95-4c2b-4454-a5a6-5429598db446',78,'02098318982046faa2136ab12b344eb1','backup_gigabytes',-1,'2025-12-06 10:12:55',NULL),('2025-12-05 10:12:57','2025-12-05 10:12:57','2025-12-05 10:12:57',1,325,'62807d4d-e6b1-48ea-8a1f-caa004b900b7',92,'870ab348edaf49d180b54cf5daaaacd1','volumes',-1,'2025-12-06 10:12:57',NULL),('2025-12-05 10:12:57','2025-12-05 10:12:57','2025-12-05 10:12:57',1,326,'a0c42de8-a6d9-4983-a58a-b771f09170c3',93,'870ab348edaf49d180b54cf5daaaacd1','gigabytes',-1,'2025-12-06 10:12:57',NULL),('2025-12-05 10:12:57','2025-12-05 10:12:57','2025-12-05 10:12:57',1,327,'04e64509-f4b2-43bf-9260-4c128f700833',96,'870ab348edaf49d180b54cf5daaaacd1','volumes_tempest-UserMessagesTest-volume-type-1380476665',-1,'2025-12-06 10:12:57',NULL),('2025-12-05 10:12:57','2025-12-05 10:12:57','2025-12-05 10:12:57',1,328,'d0462d90-539f-47e3-9c23-be8726221165',97,'870ab348edaf49d180b54cf5daaaacd1','gigabytes_tempest-UserMessagesTest-volume-type-1380476665',-1,'2025-12-06 10:12:57',NULL),('2025-12-05 10:12:58','2025-12-05 10:12:59','2025-12-05 10:12:59',1,329,'8bb62a80-fff7-4cbc-8a0c-e1dd2ddb9a97',73,'02098318982046faa2136ab12b344eb1','volumes',-1,'2025-12-06 10:12:58',NULL),('2025-12-05 10:12:58','2025-12-05 10:12:59','2025-12-05 10:12:59',1,330,'58e9ce39-dea0-4cf4-a261-5676c4b3ddf0',74,'02098318982046faa2136ab12b344eb1','gigabytes',-1,'2025-12-06 10:12:58',NULL),('2025-12-05 10:12:58','2025-12-05 10:12:59','2025-12-05 10:12:59',1,331,'51699a64-31ab-473f-ade2-dd96e6868857',75,'02098318982046faa2136ab12b344eb1','volumes_tripleo',-1,'2025-12-06 10:12:58',NULL),('2025-12-05 10:12:58','2025-12-05 10:12:59','2025-12-05 10:12:59',1,332,'e0b63105-c61f-4e60-841e-10e8e3f36352',76,'02098318982046faa2136ab12b344eb1','gigabytes_tripleo',-1,'2025-12-06 10:12:58',NULL),('2025-12-05 10:13:15','2025-12-05 10:13:15','2025-12-05 10:13:15',1,333,'adf4b6db-955f-47a2-8bec-6b4e7450e24e',98,'e230ba0d257c46a2bc100d033851d6b1','volumes',1,'2025-12-06 10:13:14',NULL),('2025-12-05 10:13:15','2025-12-05 10:13:15','2025-12-05 10:13:15',1,334,'70925c32-2e30-43a6-bcbd-ed355855d968',99,'e230ba0d257c46a2bc100d033851d6b1','gigabytes',1,'2025-12-06 10:13:14',NULL),('2025-12-05 10:13:15','2025-12-05 10:13:15','2025-12-05 10:13:15',1,335,'d36dbafd-bca8-4050-92af-888aa83efdfc',100,'e230ba0d257c46a2bc100d033851d6b1','volumes_tripleo',1,'2025-12-06 10:13:14',NULL),('2025-12-05 10:13:15','2025-12-05 10:13:15','2025-12-05 10:13:15',1,336,'20aa855c-2f9a-49f8-8572-c55276d9ee9f',101,'e230ba0d257c46a2bc100d033851d6b1','gigabytes_tripleo',1,'2025-12-06 10:13:14',NULL),('2025-12-05 10:13:16','2025-12-05 10:13:16','2025-12-05 10:13:16',1,337,'70da6a5f-3d0e-4c3e-bbaf-cfd60414d46a',98,'e230ba0d257c46a2bc100d033851d6b1','volumes',1,'2025-12-06 10:13:16',NULL),('2025-12-05 10:13:16','2025-12-05 10:13:16','2025-12-05 10:13:16',1,338,'7f851bba-e40c-4bf6-ac66-bab87fcf990a',99,'e230ba0d257c46a2bc100d033851d6b1','gigabytes',1,'2025-12-06 10:13:16',NULL),('2025-12-05 10:13:16','2025-12-05 10:13:16','2025-12-05 10:13:16',1,339,'280adfd4-353e-4b87-aa75-4d894ca8ac68',100,'e230ba0d257c46a2bc100d033851d6b1','volumes_tripleo',1,'2025-12-06 10:13:16',NULL),('2025-12-05 10:13:16','2025-12-05 10:13:16','2025-12-05 10:13:16',1,340,'d360d2f6-4c8d-4835-8655-23db3e4322b3',101,'e230ba0d257c46a2bc100d033851d6b1','gigabytes_tripleo',1,'2025-12-06 10:13:16',NULL),('2025-12-05 10:13:17','2025-12-05 10:13:18','2025-12-05 10:13:18',1,341,'be460b2d-c54f-4a08-b353-ddc36c053905',98,'e230ba0d257c46a2bc100d033851d6b1','volumes',1,'2025-12-06 10:13:17',NULL),('2025-12-05 10:13:17','2025-12-05 10:13:18','2025-12-05 10:13:18',1,342,'37a9cc07-33f6-4f31-a0d5-f3adf37b140d',99,'e230ba0d257c46a2bc100d033851d6b1','gigabytes',1,'2025-12-06 10:13:17',NULL),('2025-12-05 10:13:17','2025-12-05 10:13:18','2025-12-05 10:13:18',1,343,'da7b2558-7e5c-4fc5-be41-74814abb0984',100,'e230ba0d257c46a2bc100d033851d6b1','volumes_tripleo',1,'2025-12-06 10:13:17',NULL),('2025-12-05 10:13:17','2025-12-05 10:13:18','2025-12-05 10:13:18',1,344,'2bac7166-fb20-42d0-bee2-fb46ce299ce7',101,'e230ba0d257c46a2bc100d033851d6b1','gigabytes_tripleo',1,'2025-12-06 10:13:17',NULL),('2025-12-05 10:13:20','2025-12-05 10:13:20','2025-12-05 10:13:20',1,345,'2037c029-b03f-4e91-b428-0b366918766a',102,'7fb1a3e2a7114f43b78f20d94b35a6b0','volumes',1,'2025-12-06 10:13:20',NULL),('2025-12-05 10:13:20','2025-12-05 10:13:20','2025-12-05 10:13:20',1,346,'08b4685a-8473-440f-87e5-67e9c9018c62',103,'7fb1a3e2a7114f43b78f20d94b35a6b0','gigabytes',1,'2025-12-06 10:13:20',NULL),('2025-12-05 10:13:20','2025-12-05 10:13:20','2025-12-05 10:13:20',1,347,'016f78d9-5386-418d-a5b7-ffa690d45c32',104,'7fb1a3e2a7114f43b78f20d94b35a6b0','volumes_tripleo',1,'2025-12-06 10:13:20',NULL),('2025-12-05 10:13:20','2025-12-05 10:13:20','2025-12-05 10:13:20',1,348,'819be999-f8fd-4347-9fa0-1887b33b55ea',105,'7fb1a3e2a7114f43b78f20d94b35a6b0','gigabytes_tripleo',1,'2025-12-06 10:13:20',NULL),('2025-12-05 10:13:24','2025-12-05 10:13:24','2025-12-05 10:13:24',1,349,'294f49ec-1f5f-4082-a87d-7052d4b0df95',102,'7fb1a3e2a7114f43b78f20d94b35a6b0','volumes',-1,'2025-12-06 10:13:24',NULL),('2025-12-05 10:13:24','2025-12-05 10:13:24','2025-12-05 10:13:24',1,350,'532f8f78-d82b-4b5f-9645-cba62ce88373',103,'7fb1a3e2a7114f43b78f20d94b35a6b0','gigabytes',-1,'2025-12-06 10:13:24',NULL),('2025-12-05 10:13:24','2025-12-05 10:13:24','2025-12-05 10:13:24',1,351,'1443a76f-7e69-4bf4-b34d-1f6635937153',104,'7fb1a3e2a7114f43b78f20d94b35a6b0','volumes_tripleo',-1,'2025-12-06 10:13:24',NULL),('2025-12-05 10:13:24','2025-12-05 10:13:24','2025-12-05 10:13:24',1,352,'930ff9ac-4b4a-4cb1-8bb1-98b2acbef8d0',105,'7fb1a3e2a7114f43b78f20d94b35a6b0','gigabytes_tripleo',-1,'2025-12-06 10:13:24',NULL),('2025-12-05 10:13:24','2025-12-05 10:13:24','2025-12-05 10:13:24',1,353,'745f5d11-ad51-4490-966a-f81b914a2b3a',98,'e230ba0d257c46a2bc100d033851d6b1','volumes',-1,'2025-12-06 10:13:24',NULL),('2025-12-05 10:13:24','2025-12-05 10:13:24','2025-12-05 10:13:24',1,354,'85534139-c879-40b8-b467-66f60fb46a59',99,'e230ba0d257c46a2bc100d033851d6b1','gigabytes',-1,'2025-12-06 10:13:24',NULL),('2025-12-05 10:13:24','2025-12-05 10:13:24','2025-12-05 10:13:24',1,355,'2bd8f720-aefe-4952-aef6-c6eb5361ac10',100,'e230ba0d257c46a2bc100d033851d6b1','volumes_tripleo',-1,'2025-12-06 10:13:24',NULL),('2025-12-05 10:13:24','2025-12-05 10:13:24','2025-12-05 10:13:24',1,356,'5f53d4cf-3118-4cac-bd82-b7c9a517be9a',101,'e230ba0d257c46a2bc100d033851d6b1','gigabytes_tripleo',-1,'2025-12-06 10:13:24',NULL),('2025-12-05 10:13:25','2025-12-05 10:13:25','2025-12-05 10:13:25',1,357,'93353517-a65d-47fc-b962-953bd0498a7b',98,'e230ba0d257c46a2bc100d033851d6b1','volumes',-1,'2025-12-06 10:13:25',NULL),('2025-12-05 10:13:25','2025-12-05 10:13:25','2025-12-05 10:13:25',1,358,'6b7d2d2c-3ce7-49eb-8aa0-db34ee0e95e7',99,'e230ba0d257c46a2bc100d033851d6b1','gigabytes',-1,'2025-12-06 10:13:25',NULL),('2025-12-05 10:13:25','2025-12-05 10:13:25','2025-12-05 10:13:25',1,359,'1c755798-dff7-4659-91cd-8439c996cd58',100,'e230ba0d257c46a2bc100d033851d6b1','volumes_tripleo',-1,'2025-12-06 10:13:25',NULL),('2025-12-05 10:13:25','2025-12-05 10:13:25','2025-12-05 10:13:25',1,360,'8e4fb199-e18d-4cb5-8246-5de9bc8afe6e',101,'e230ba0d257c46a2bc100d033851d6b1','gigabytes_tripleo',-1,'2025-12-06 10:13:25',NULL),('2025-12-05 10:13:25','2025-12-05 10:13:25','2025-12-05 10:13:25',1,361,'86df93e4-b80c-47dc-8d5f-a73d3b5b7ea3',106,'f67828d1e0ec494fbab56cc9be72430e','volumes',1,'2025-12-06 10:13:25',NULL),('2025-12-05 10:13:25','2025-12-05 10:13:25','2025-12-05 10:13:25',1,362,'087a881d-c6ae-462b-a4df-c51795c2b9f0',107,'f67828d1e0ec494fbab56cc9be72430e','gigabytes',1,'2025-12-06 10:13:25',NULL),('2025-12-05 10:13:25','2025-12-05 10:13:25','2025-12-05 10:13:25',1,363,'2800dfef-1acc-4575-99b3-d17cb6454cd2',108,'f67828d1e0ec494fbab56cc9be72430e','volumes_tripleo',1,'2025-12-06 10:13:25',NULL),('2025-12-05 10:13:25','2025-12-05 10:13:25','2025-12-05 10:13:25',1,364,'1ffe4a3b-be24-4aff-bad9-7a9653007996',109,'f67828d1e0ec494fbab56cc9be72430e','gigabytes_tripleo',1,'2025-12-06 10:13:25',NULL),('2025-12-05 10:13:26','2025-12-05 10:13:26','2025-12-05 10:13:26',1,365,'7fb41d4a-4f5f-4ed6-b875-c3007996e7e5',98,'e230ba0d257c46a2bc100d033851d6b1','volumes',-1,'2025-12-06 10:13:26',NULL),('2025-12-05 10:13:26','2025-12-05 10:13:26','2025-12-05 10:13:26',1,366,'6fd57046-dacc-4934-9a4c-64962fd9373c',99,'e230ba0d257c46a2bc100d033851d6b1','gigabytes',-1,'2025-12-06 10:13:26',NULL),('2025-12-05 10:13:26','2025-12-05 10:13:26','2025-12-05 10:13:26',1,367,'4145b1b3-d8e6-49a8-8b3f-2f6793f5568b',100,'e230ba0d257c46a2bc100d033851d6b1','volumes_tripleo',-1,'2025-12-06 10:13:26',NULL),('2025-12-05 10:13:26','2025-12-05 10:13:26','2025-12-05 10:13:26',1,368,'20c5409d-9c62-4a5b-8f59-65c56ab8845a',101,'e230ba0d257c46a2bc100d033851d6b1','gigabytes_tripleo',-1,'2025-12-06 10:13:26',NULL),('2025-12-05 10:13:29','2025-12-05 10:13:30','2025-12-05 10:13:30',1,369,'49142d09-c0ba-401e-8ce4-598dcbdb5c38',106,'f67828d1e0ec494fbab56cc9be72430e','volumes',-1,'2025-12-06 10:13:29',NULL),('2025-12-05 10:13:29','2025-12-05 10:13:30','2025-12-05 10:13:30',1,370,'c3d33222-0357-4c45-8578-87e4f3a558d0',107,'f67828d1e0ec494fbab56cc9be72430e','gigabytes',-1,'2025-12-06 10:13:29',NULL),('2025-12-05 10:13:29','2025-12-05 10:13:30','2025-12-05 10:13:30',1,371,'b4d5493c-4f01-4f52-87f8-8b432b60e166',108,'f67828d1e0ec494fbab56cc9be72430e','volumes_tripleo',-1,'2025-12-06 10:13:29',NULL),('2025-12-05 10:13:29','2025-12-05 10:13:30','2025-12-05 10:13:30',1,372,'f68512a4-8ea1-4879-bf84-386b5d9083a3',109,'f67828d1e0ec494fbab56cc9be72430e','gigabytes_tripleo',-1,'2025-12-06 10:13:29',NULL),('2025-12-05 10:13:42','2025-12-05 10:13:42','2025-12-05 10:13:42',1,373,'41dc1e8a-934d-40e8-99c7-9eeee6dd305e',110,'a5cc8e8a222a4340a4dc0e0a353a820c','volumes',1,'2025-12-06 10:13:42',NULL),('2025-12-05 10:13:42','2025-12-05 10:13:42','2025-12-05 10:13:42',1,374,'c54c1bb7-fe42-41bc-a6f6-aa1fac77128e',111,'a5cc8e8a222a4340a4dc0e0a353a820c','gigabytes',1,'2025-12-06 10:13:42',NULL),('2025-12-05 10:13:42','2025-12-05 10:13:42','2025-12-05 10:13:42',1,375,'0ebbcaa3-39cb-43af-b1be-fd219bdc5731',112,'a5cc8e8a222a4340a4dc0e0a353a820c','volumes_tripleo',1,'2025-12-06 10:13:42',NULL),('2025-12-05 10:13:42','2025-12-05 10:13:42','2025-12-05 10:13:42',1,376,'21880e27-9da8-402f-a7f3-0db7709661a5',113,'a5cc8e8a222a4340a4dc0e0a353a820c','gigabytes_tripleo',1,'2025-12-06 10:13:42',NULL),('2025-12-05 10:13:44','2025-12-05 10:13:44','2025-12-05 10:13:44',1,377,'4ccfc85c-09ee-4910-869d-438279b44962',114,'11c68ad07fe34e07ad5a591f23d30263','volumes',1,'2025-12-06 10:13:43',NULL),('2025-12-05 10:13:44','2025-12-05 10:13:44','2025-12-05 10:13:44',1,378,'0b7ac956-de4d-495f-88dd-a5677edcf2a6',115,'11c68ad07fe34e07ad5a591f23d30263','gigabytes',1,'2025-12-06 10:13:43',NULL),('2025-12-05 10:13:44','2025-12-05 10:13:44','2025-12-05 10:13:44',1,379,'ae6e81e6-c5f9-4a37-868a-44326195f955',116,'11c68ad07fe34e07ad5a591f23d30263','volumes_tripleo',1,'2025-12-06 10:13:43',NULL),('2025-12-05 10:13:44','2025-12-05 10:13:44','2025-12-05 10:13:44',1,380,'e1097a00-28d5-4092-a2f3-d44b3d80d2a9',117,'11c68ad07fe34e07ad5a591f23d30263','gigabytes_tripleo',1,'2025-12-06 10:13:43',NULL),('2025-12-05 10:13:44','2025-12-05 10:13:44','2025-12-05 10:13:44',1,381,'ab5fedf6-88e0-49e6-afa1-a76c3b5f52d4',110,'a5cc8e8a222a4340a4dc0e0a353a820c','volumes',-1,'2025-12-06 10:13:44',NULL),('2025-12-05 10:13:44','2025-12-05 10:13:44','2025-12-05 10:13:44',1,382,'a9109653-f72c-4691-a6df-0ddbb0042ca7',111,'a5cc8e8a222a4340a4dc0e0a353a820c','gigabytes',-1,'2025-12-06 10:13:44',NULL),('2025-12-05 10:13:44','2025-12-05 10:13:44','2025-12-05 10:13:44',1,383,'1e819627-8262-4bf0-ab7c-5eabaa8f6d2b',112,'a5cc8e8a222a4340a4dc0e0a353a820c','volumes_tripleo',-1,'2025-12-06 10:13:44',NULL),('2025-12-05 10:13:44','2025-12-05 10:13:44','2025-12-05 10:13:44',1,384,'f6d57590-681b-4388-ab2d-44f60798bd1c',113,'a5cc8e8a222a4340a4dc0e0a353a820c','gigabytes_tripleo',-1,'2025-12-06 10:13:44',NULL),('2025-12-05 10:13:44','2025-12-05 10:13:44','2025-12-05 10:13:44',1,385,'6cc0100b-4f5e-4f96-9f8f-399f322db928',118,'11c68ad07fe34e07ad5a591f23d30263','snapshots',0,'2025-12-06 10:13:44',NULL),('2025-12-05 10:13:44','2025-12-05 10:13:44','2025-12-05 10:13:44',1,386,'0bf50059-c89e-43df-a7c2-6499fc5cfc33',115,'11c68ad07fe34e07ad5a591f23d30263','gigabytes',0,'2025-12-06 10:13:44',NULL),('2025-12-05 10:13:44','2025-12-05 10:13:44','2025-12-05 10:13:44',1,387,'397c00f4-8ac3-48fc-8b8b-870dec482207',117,'11c68ad07fe34e07ad5a591f23d30263','gigabytes_tripleo',0,'2025-12-06 10:13:44',NULL),('2025-12-05 10:13:44','2025-12-05 10:13:44','2025-12-05 10:13:44',1,388,'31a29def-3339-477e-8784-8c5867cc3530',119,'11c68ad07fe34e07ad5a591f23d30263','snapshots_tripleo',0,'2025-12-06 10:13:44',NULL),('2025-12-05 10:13:44','2025-12-05 10:13:44','2025-12-05 10:13:44',1,389,'fc2224ad-e94b-45f3-9e1b-3f373e025293',120,'a5cc8e8a222a4340a4dc0e0a353a820c','snapshots',0,'2025-12-06 10:13:44',NULL),('2025-12-05 10:13:44','2025-12-05 10:13:44','2025-12-05 10:13:44',1,390,'d3d3138e-85c3-48e0-b293-552b4e18df39',111,'a5cc8e8a222a4340a4dc0e0a353a820c','gigabytes',0,'2025-12-06 10:13:44',NULL),('2025-12-05 10:13:44','2025-12-05 10:13:44','2025-12-05 10:13:44',1,391,'3ce344c0-302a-4948-b277-00caed4a3b01',113,'a5cc8e8a222a4340a4dc0e0a353a820c','gigabytes_tripleo',0,'2025-12-06 10:13:44',NULL),('2025-12-05 10:13:44','2025-12-05 10:13:44','2025-12-05 10:13:44',1,392,'6a65b134-a7c1-4eeb-82d1-d5ee127036d5',121,'a5cc8e8a222a4340a4dc0e0a353a820c','snapshots_tripleo',0,'2025-12-06 10:13:44',NULL),('2025-12-05 10:13:46','2025-12-05 10:13:46','2025-12-05 10:13:46',1,393,'acf76f7d-3a06-47d3-a5d2-ac3cbbbfd378',114,'11c68ad07fe34e07ad5a591f23d30263','volumes',-1,'2025-12-06 10:13:46',NULL),('2025-12-05 10:13:46','2025-12-05 10:13:46','2025-12-05 10:13:46',1,394,'3a29c2e5-6e5c-47c2-af11-6f3b66a1d729',115,'11c68ad07fe34e07ad5a591f23d30263','gigabytes',-1,'2025-12-06 10:13:46',NULL),('2025-12-05 10:13:46','2025-12-05 10:13:46','2025-12-05 10:13:46',1,395,'1c8ce212-af6e-44dd-b293-9f2d9c058fa1',116,'11c68ad07fe34e07ad5a591f23d30263','volumes_tripleo',-1,'2025-12-06 10:13:46',NULL),('2025-12-05 10:13:46','2025-12-05 10:13:46','2025-12-05 10:13:46',1,396,'a22ecf62-68db-4176-a13c-ceb7535c1b70',117,'11c68ad07fe34e07ad5a591f23d30263','gigabytes_tripleo',-1,'2025-12-06 10:13:46',NULL),('2025-12-05 10:13:47','2025-12-05 10:13:47','2025-12-05 10:13:47',1,397,'472de79a-cb4f-4e14-81c3-d806c5748b18',110,'a5cc8e8a222a4340a4dc0e0a353a820c','volumes',1,'2025-12-06 10:13:47',NULL),('2025-12-05 10:13:47','2025-12-05 10:13:47','2025-12-05 10:13:47',1,398,'bfb79852-ec12-4b9d-abb6-5563d010abda',111,'a5cc8e8a222a4340a4dc0e0a353a820c','gigabytes',1,'2025-12-06 10:13:47',NULL),('2025-12-05 10:13:47','2025-12-05 10:13:47','2025-12-05 10:13:47',1,399,'8f83a248-0959-4958-aebf-84d0b9418ffb',112,'a5cc8e8a222a4340a4dc0e0a353a820c','volumes_tripleo',1,'2025-12-06 10:13:47',NULL),('2025-12-05 10:13:47','2025-12-05 10:13:47','2025-12-05 10:13:47',1,400,'e0e594e2-1cb9-4866-9b4a-f977f9e5d502',113,'a5cc8e8a222a4340a4dc0e0a353a820c','gigabytes_tripleo',1,'2025-12-06 10:13:47',NULL),('2025-12-05 10:13:50','2025-12-05 10:13:51','2025-12-05 10:13:51',1,401,'ca52bdb4-9c56-47e8-b43d-463336f56209',110,'a5cc8e8a222a4340a4dc0e0a353a820c','volumes',-1,'2025-12-06 10:13:50',NULL),('2025-12-05 10:13:50','2025-12-05 10:13:51','2025-12-05 10:13:51',1,402,'7670ea5c-360e-4e07-8691-80aa617b705f',111,'a5cc8e8a222a4340a4dc0e0a353a820c','gigabytes',-1,'2025-12-06 10:13:50',NULL),('2025-12-05 10:13:50','2025-12-05 10:13:51','2025-12-05 10:13:51',1,403,'6f7eedf1-c34c-40a1-b4b7-fb52a6e53914',112,'a5cc8e8a222a4340a4dc0e0a353a820c','volumes_tripleo',-1,'2025-12-06 10:13:50',NULL),('2025-12-05 10:13:50','2025-12-05 10:13:51','2025-12-05 10:13:51',1,404,'bed12f96-251e-49b2-b952-c21abccdc127',113,'a5cc8e8a222a4340a4dc0e0a353a820c','gigabytes_tripleo',-1,'2025-12-06 10:13:50',NULL),('2025-12-05 10:13:53','2025-12-05 10:13:53','2025-12-05 10:13:53',1,405,'ad0703b4-f067-4574-8d43-89df19314af4',122,'cc5978fe065b4f80b1bc25ce32164997','volumes',1,'2025-12-06 10:13:53',NULL),('2025-12-05 10:13:53','2025-12-05 10:13:53','2025-12-05 10:13:53',1,406,'0e5c58fd-aa22-4f3f-b23e-1237a74de19a',123,'cc5978fe065b4f80b1bc25ce32164997','gigabytes',1,'2025-12-06 10:13:53',NULL),('2025-12-05 10:13:53','2025-12-05 10:13:53','2025-12-05 10:13:53',1,407,'41879088-f6e0-4430-bde4-2d29c540f0fa',124,'cc5978fe065b4f80b1bc25ce32164997','volumes_tripleo',1,'2025-12-06 10:13:53',NULL),('2025-12-05 10:13:53','2025-12-05 10:13:53','2025-12-05 10:13:53',1,408,'51ee4744-8801-4d50-9da4-1b10d3829c42',125,'cc5978fe065b4f80b1bc25ce32164997','gigabytes_tripleo',1,'2025-12-06 10:13:53',NULL),('2025-12-05 10:13:54','2025-12-05 10:13:54','2025-12-05 10:13:54',1,409,'be6c5be2-2787-4b64-8a81-ff6959a9d003',126,'cc5978fe065b4f80b1bc25ce32164997','snapshots',1,'2025-12-06 10:13:54',NULL),('2025-12-05 10:13:54','2025-12-05 10:13:54','2025-12-05 10:13:54',1,410,'3458d3e6-81eb-45f5-860d-29b6f0821e7e',123,'cc5978fe065b4f80b1bc25ce32164997','gigabytes',1,'2025-12-06 10:13:54',NULL),('2025-12-05 10:13:54','2025-12-05 10:13:54','2025-12-05 10:13:54',1,411,'2933cfa8-67ef-40f4-b184-89ccce9a440f',125,'cc5978fe065b4f80b1bc25ce32164997','gigabytes_tripleo',1,'2025-12-06 10:13:54',NULL),('2025-12-05 10:13:54','2025-12-05 10:13:54','2025-12-05 10:13:54',1,412,'6158d8b1-f5b1-4b64-800a-c1ea8ffe5cb4',127,'cc5978fe065b4f80b1bc25ce32164997','snapshots_tripleo',1,'2025-12-06 10:13:54',NULL),('2025-12-05 10:13:56','2025-12-05 10:13:56','2025-12-05 10:13:56',1,413,'7a078a0d-2178-457c-81c4-9d23b983dd21',126,'cc5978fe065b4f80b1bc25ce32164997','snapshots',1,'2025-12-06 10:13:56',NULL),('2025-12-05 10:13:56','2025-12-05 10:13:56','2025-12-05 10:13:56',1,414,'2ea0be77-94cb-46e6-9b2b-10c9065b4c37',123,'cc5978fe065b4f80b1bc25ce32164997','gigabytes',1,'2025-12-06 10:13:56',NULL),('2025-12-05 10:13:56','2025-12-05 10:13:56','2025-12-05 10:13:56',1,415,'efb8384e-482e-4455-a00a-d332a787472e',125,'cc5978fe065b4f80b1bc25ce32164997','gigabytes_tripleo',1,'2025-12-06 10:13:56',NULL),('2025-12-05 10:13:56','2025-12-05 10:13:56','2025-12-05 10:13:56',1,416,'99c7eeaf-f240-4aa3-aa9f-47ee100cf9ec',127,'cc5978fe065b4f80b1bc25ce32164997','snapshots_tripleo',1,'2025-12-06 10:13:56',NULL),('2025-12-05 10:13:59','2025-12-05 10:13:59','2025-12-05 10:13:59',1,417,'450405c1-1879-49bc-9756-a65f44d8eb55',126,'cc5978fe065b4f80b1bc25ce32164997','snapshots',-1,'2025-12-06 10:13:59',NULL),('2025-12-05 10:13:59','2025-12-05 10:13:59','2025-12-05 10:13:59',1,418,'a6a941f5-55d4-4978-8ae2-b104917514d6',123,'cc5978fe065b4f80b1bc25ce32164997','gigabytes',-1,'2025-12-06 10:13:59',NULL),('2025-12-05 10:13:59','2025-12-05 10:13:59','2025-12-05 10:13:59',1,419,'c8d86cdc-ec48-4ef4-ab84-97fec4ef52dc',125,'cc5978fe065b4f80b1bc25ce32164997','gigabytes_tripleo',-1,'2025-12-06 10:13:59',NULL),('2025-12-05 10:13:59','2025-12-05 10:13:59','2025-12-05 10:13:59',1,420,'11599e10-b3bd-48ca-8309-f165d9b84c97',127,'cc5978fe065b4f80b1bc25ce32164997','snapshots_tripleo',-1,'2025-12-06 10:13:59',NULL),('2025-12-05 10:14:00','2025-12-05 10:14:00','2025-12-05 10:14:00',1,421,'38344f05-4d91-45ab-945c-dfad725859c9',126,'cc5978fe065b4f80b1bc25ce32164997','snapshots',-1,'2025-12-06 10:14:00',NULL),('2025-12-05 10:14:00','2025-12-05 10:14:00','2025-12-05 10:14:00',1,422,'0ec037d0-5a60-4d9e-910e-e3068d492723',123,'cc5978fe065b4f80b1bc25ce32164997','gigabytes',-1,'2025-12-06 10:14:00',NULL),('2025-12-05 10:14:00','2025-12-05 10:14:00','2025-12-05 10:14:00',1,423,'88e5ef3f-e1ec-40bc-8863-6814018ad3f2',125,'cc5978fe065b4f80b1bc25ce32164997','gigabytes_tripleo',-1,'2025-12-06 10:14:00',NULL),('2025-12-05 10:14:00','2025-12-05 10:14:00','2025-12-05 10:14:00',1,424,'066f3daa-9a64-4d55-bb88-53413ce3103e',127,'cc5978fe065b4f80b1bc25ce32164997','snapshots_tripleo',-1,'2025-12-06 10:14:00',NULL),('2025-12-05 10:14:01','2025-12-05 10:14:01','2025-12-05 10:14:01',1,425,'ed95cabf-3bd3-4426-ab66-73a604866e60',122,'cc5978fe065b4f80b1bc25ce32164997','volumes',-1,'2025-12-06 10:14:01',NULL),('2025-12-05 10:14:01','2025-12-05 10:14:01','2025-12-05 10:14:01',1,426,'4eeba626-010c-4df8-9213-d64e84e18171',123,'cc5978fe065b4f80b1bc25ce32164997','gigabytes',-1,'2025-12-06 10:14:01',NULL),('2025-12-05 10:14:01','2025-12-05 10:14:01','2025-12-05 10:14:01',1,427,'157de402-47d7-4e14-831d-365b81f7555f',124,'cc5978fe065b4f80b1bc25ce32164997','volumes_tripleo',-1,'2025-12-06 10:14:01',NULL),('2025-12-05 10:14:01','2025-12-05 10:14:01','2025-12-05 10:14:01',1,428,'a735dab9-5caf-4157-a282-35f70866b6ac',125,'cc5978fe065b4f80b1bc25ce32164997','gigabytes_tripleo',-1,'2025-12-06 10:14:01',NULL),('2025-12-05 10:14:02','2025-12-05 10:14:02','2025-12-05 10:14:02',1,429,'c086cd50-ad54-4327-867f-e61408a51da5',122,'cc5978fe065b4f80b1bc25ce32164997','volumes',1,'2025-12-06 10:14:02',NULL),('2025-12-05 10:14:02','2025-12-05 10:14:02','2025-12-05 10:14:02',1,430,'492155f4-528c-444d-b539-010e7b60aa7f',123,'cc5978fe065b4f80b1bc25ce32164997','gigabytes',1,'2025-12-06 10:14:02',NULL),('2025-12-05 10:14:02','2025-12-05 10:14:02','2025-12-05 10:14:02',1,431,'e06ff942-95c9-4ce2-ba21-6d30749a9819',124,'cc5978fe065b4f80b1bc25ce32164997','volumes_tripleo',1,'2025-12-06 10:14:02',NULL),('2025-12-05 10:14:02','2025-12-05 10:14:02','2025-12-05 10:14:02',1,432,'a6c454bb-3814-46d2-b479-7efa0a9167ec',125,'cc5978fe065b4f80b1bc25ce32164997','gigabytes_tripleo',1,'2025-12-06 10:14:02',NULL),('2025-12-05 10:14:04','2025-12-05 10:14:04','2025-12-05 10:14:04',1,433,'baff67bb-2b9d-4802-a7a3-3bdc617fa783',126,'cc5978fe065b4f80b1bc25ce32164997','snapshots',1,'2025-12-06 10:14:04',NULL),('2025-12-05 10:14:04','2025-12-05 10:14:04','2025-12-05 10:14:04',1,434,'bd59914c-f8f3-4eda-af65-32a707d07daa',123,'cc5978fe065b4f80b1bc25ce32164997','gigabytes',1,'2025-12-06 10:14:04',NULL),('2025-12-05 10:14:04','2025-12-05 10:14:04','2025-12-05 10:14:04',1,435,'efb44839-409e-43ea-aca9-4ac99f5c352d',125,'cc5978fe065b4f80b1bc25ce32164997','gigabytes_tripleo',1,'2025-12-06 10:14:04',NULL),('2025-12-05 10:14:04','2025-12-05 10:14:04','2025-12-05 10:14:04',1,436,'87ad675f-3e1a-4663-b1d6-f98f5a23c8ae',127,'cc5978fe065b4f80b1bc25ce32164997','snapshots_tripleo',1,'2025-12-06 10:14:04',NULL),('2025-12-05 10:14:05','2025-12-05 10:14:05','2025-12-05 10:14:05',1,437,'1df7b474-bc8b-4e11-8631-104faa739176',122,'cc5978fe065b4f80b1bc25ce32164997','volumes',1,'2025-12-06 10:14:05',NULL),('2025-12-05 10:14:05','2025-12-05 10:14:05','2025-12-05 10:14:05',1,438,'36578160-a44a-41b2-ae0d-72d91c841b4c',123,'cc5978fe065b4f80b1bc25ce32164997','gigabytes',1,'2025-12-06 10:14:05',NULL),('2025-12-05 10:14:05','2025-12-05 10:14:05','2025-12-05 10:14:05',1,439,'fbc6a08d-4d71-4328-965e-bcf014e6df70',124,'cc5978fe065b4f80b1bc25ce32164997','volumes_tripleo',1,'2025-12-06 10:14:05',NULL),('2025-12-05 10:14:05','2025-12-05 10:14:05','2025-12-05 10:14:05',1,440,'8f7e875d-1741-4214-adc7-e81624d1f439',125,'cc5978fe065b4f80b1bc25ce32164997','gigabytes_tripleo',1,'2025-12-06 10:14:05',NULL),('2025-12-05 10:14:14','2025-12-05 10:14:14','2025-12-05 10:14:14',1,441,'cfebd287-14e8-4e64-a26c-9b4c948abd78',126,'cc5978fe065b4f80b1bc25ce32164997','snapshots',-1,'2025-12-06 10:14:14',NULL),('2025-12-05 10:14:14','2025-12-05 10:14:14','2025-12-05 10:14:14',1,442,'4f984a35-4ab6-4cfd-b20f-1046a413cbc5',123,'cc5978fe065b4f80b1bc25ce32164997','gigabytes',-1,'2025-12-06 10:14:14',NULL),('2025-12-05 10:14:14','2025-12-05 10:14:14','2025-12-05 10:14:14',1,443,'c9b19828-3e51-41dc-82cf-c745c5dcac98',125,'cc5978fe065b4f80b1bc25ce32164997','gigabytes_tripleo',-1,'2025-12-06 10:14:14',NULL),('2025-12-05 10:14:14','2025-12-05 10:14:14','2025-12-05 10:14:14',1,444,'c7be251c-2434-465d-8c52-419987b44b30',127,'cc5978fe065b4f80b1bc25ce32164997','snapshots_tripleo',-1,'2025-12-06 10:14:14',NULL),('2025-12-05 10:14:15','2025-12-05 10:14:15','2025-12-05 10:14:15',1,445,'13ae9c94-706c-4062-a89b-915e1ee00129',122,'cc5978fe065b4f80b1bc25ce32164997','volumes',-1,'2025-12-06 10:14:15',NULL),('2025-12-05 10:14:15','2025-12-05 10:14:15','2025-12-05 10:14:15',1,446,'6ce352c6-5b52-496e-82a5-81cfbf112e45',123,'cc5978fe065b4f80b1bc25ce32164997','gigabytes',-1,'2025-12-06 10:14:15',NULL),('2025-12-05 10:14:15','2025-12-05 10:14:15','2025-12-05 10:14:15',1,447,'9e77a1e0-aab3-4d6f-b56f-58519c0fd661',124,'cc5978fe065b4f80b1bc25ce32164997','volumes_tripleo',-1,'2025-12-06 10:14:15',NULL),('2025-12-05 10:14:15','2025-12-05 10:14:15','2025-12-05 10:14:15',1,448,'3cdaee99-1d5a-4901-8ee6-fa23471ecee2',125,'cc5978fe065b4f80b1bc25ce32164997','gigabytes_tripleo',-1,'2025-12-06 10:14:15',NULL),('2025-12-05 10:14:17','2025-12-05 10:14:17','2025-12-05 10:14:17',1,449,'0517de06-3c4e-4994-9fa0-430483cd5466',122,'cc5978fe065b4f80b1bc25ce32164997','volumes',-1,'2025-12-06 10:14:17',NULL),('2025-12-05 10:14:17','2025-12-05 10:14:17','2025-12-05 10:14:17',1,450,'57459f8b-bbc1-4366-ba86-b1ecefd316b9',123,'cc5978fe065b4f80b1bc25ce32164997','gigabytes',-1,'2025-12-06 10:14:17',NULL),('2025-12-05 10:14:17','2025-12-05 10:14:17','2025-12-05 10:14:17',1,451,'8b8e8bf6-489e-43c3-958c-b24b0506b436',124,'cc5978fe065b4f80b1bc25ce32164997','volumes_tripleo',-1,'2025-12-06 10:14:17',NULL),('2025-12-05 10:14:17','2025-12-05 10:14:17','2025-12-05 10:14:17',1,452,'f513f842-3e20-47e5-a0c6-6dc5ba455598',125,'cc5978fe065b4f80b1bc25ce32164997','gigabytes_tripleo',-1,'2025-12-06 10:14:17',NULL),('2025-12-05 10:14:17','2025-12-05 10:14:17','2025-12-05 10:14:17',1,453,'f5488c94-de99-4fac-b2d7-ef58f0497676',128,'8730b222fadf4a249823e59d8b326dde','volumes',1,'2025-12-06 10:14:17',NULL),('2025-12-05 10:14:17','2025-12-05 10:14:17','2025-12-05 10:14:17',1,454,'60dd85e7-8c4b-4587-ab07-715a691d236b',129,'8730b222fadf4a249823e59d8b326dde','gigabytes',1,'2025-12-06 10:14:17',NULL),('2025-12-05 10:14:17','2025-12-05 10:14:17','2025-12-05 10:14:17',1,455,'b61c3f13-0a96-4eda-b35f-fc9da53ffa69',130,'8730b222fadf4a249823e59d8b326dde','volumes_tripleo',1,'2025-12-06 10:14:17',NULL),('2025-12-05 10:14:17','2025-12-05 10:14:17','2025-12-05 10:14:17',1,456,'6822323c-6a89-4490-80b6-fad1f492c25b',131,'8730b222fadf4a249823e59d8b326dde','gigabytes_tripleo',1,'2025-12-06 10:14:17',NULL),('2025-12-05 10:14:26','2025-12-05 10:14:26','2025-12-05 10:14:26',1,457,'b54d1452-fa72-4ae7-9537-77ba5335f33a',132,'828c13ab111f4c1d9f4fe33b1ba5f907','volumes',1,'2025-12-06 10:14:26',NULL),('2025-12-05 10:14:26','2025-12-05 10:14:26','2025-12-05 10:14:26',1,458,'5ecf8bdf-e33c-45c6-a901-5f0293bd052e',133,'828c13ab111f4c1d9f4fe33b1ba5f907','gigabytes',1,'2025-12-06 10:14:26',NULL),('2025-12-05 10:14:26','2025-12-05 10:14:26','2025-12-05 10:14:26',1,459,'f626c678-7c4a-40fa-bbf3-68a4e03121e0',134,'828c13ab111f4c1d9f4fe33b1ba5f907','volumes_tripleo',1,'2025-12-06 10:14:26',NULL),('2025-12-05 10:14:26','2025-12-05 10:14:26','2025-12-05 10:14:26',1,460,'5fe58861-a75d-4ce3-b8ea-32dc2bde6522',135,'828c13ab111f4c1d9f4fe33b1ba5f907','gigabytes_tripleo',1,'2025-12-06 10:14:26',NULL),('2025-12-05 10:14:28','2025-12-05 10:14:28','2025-12-05 10:14:28',1,461,'8c6cc060-1bc4-4e18-954b-d833904fc64f',132,'828c13ab111f4c1d9f4fe33b1ba5f907','volumes',1,'2025-12-06 10:14:27',NULL),('2025-12-05 10:14:28','2025-12-05 10:14:28','2025-12-05 10:14:28',1,462,'ca81c8f1-c9a2-4d7c-b203-34b3535d5ab6',133,'828c13ab111f4c1d9f4fe33b1ba5f907','gigabytes',1,'2025-12-06 10:14:27',NULL),('2025-12-05 10:14:28','2025-12-05 10:14:28','2025-12-05 10:14:28',1,463,'e3b0184d-0711-4ab6-8917-a084d276fb47',134,'828c13ab111f4c1d9f4fe33b1ba5f907','volumes_tripleo',1,'2025-12-06 10:14:27',NULL),('2025-12-05 10:14:28','2025-12-05 10:14:28','2025-12-05 10:14:28',1,464,'2ec9c038-f574-4fb7-b10e-674ef4b0f895',135,'828c13ab111f4c1d9f4fe33b1ba5f907','gigabytes_tripleo',1,'2025-12-06 10:14:27',NULL),('2025-12-05 10:14:29','2025-12-05 10:14:29','2025-12-05 10:14:29',1,465,'9099b290-98f1-44e3-99bc-ea4cbf61f204',136,'794eae12144d44b683392db77e4b46a0','volumes',1,'2025-12-06 10:14:28',NULL),('2025-12-05 10:14:29','2025-12-05 10:14:29','2025-12-05 10:14:29',1,466,'0266239f-3f01-4b10-96b8-43457fe663a7',137,'794eae12144d44b683392db77e4b46a0','gigabytes',1,'2025-12-06 10:14:28',NULL),('2025-12-05 10:14:29','2025-12-05 10:14:29','2025-12-05 10:14:29',1,467,'ee06a953-f1fd-41d7-a7d0-8b94e067c0cd',138,'794eae12144d44b683392db77e4b46a0','volumes_tripleo',1,'2025-12-06 10:14:28',NULL),('2025-12-05 10:14:29','2025-12-05 10:14:29','2025-12-05 10:14:29',1,468,'9d0f6f91-f24f-463c-8a37-bb182c9b7225',139,'794eae12144d44b683392db77e4b46a0','gigabytes_tripleo',1,'2025-12-06 10:14:28',NULL),('2025-12-05 10:14:30','2025-12-05 10:14:30','2025-12-05 10:14:30',1,469,'bfda4b6c-f4f0-49bf-80e9-5bef710b5ad4',140,'794eae12144d44b683392db77e4b46a0','backups',1,'2025-12-06 10:14:30',NULL),('2025-12-05 10:14:30','2025-12-05 10:14:30','2025-12-05 10:14:30',1,470,'4a80ea88-af9a-4c6a-ac41-6f02f33415f3',141,'794eae12144d44b683392db77e4b46a0','backup_gigabytes',1,'2025-12-06 10:14:30',NULL),('2025-12-05 10:14:30','2025-12-05 10:14:30','2025-12-05 10:14:30',1,471,'738e8e4b-e8a6-43ca-abf4-1386a20b5b09',132,'828c13ab111f4c1d9f4fe33b1ba5f907','volumes',-1,'2025-12-06 10:14:30',NULL),('2025-12-05 10:14:30','2025-12-05 10:14:30','2025-12-05 10:14:30',1,472,'46f7783f-aafc-40a7-9421-afaa30fb9703',133,'828c13ab111f4c1d9f4fe33b1ba5f907','gigabytes',-1,'2025-12-06 10:14:30',NULL),('2025-12-05 10:14:30','2025-12-05 10:14:30','2025-12-05 10:14:30',1,473,'65ba98c4-782d-4b14-b769-b0f00396f498',134,'828c13ab111f4c1d9f4fe33b1ba5f907','volumes_tripleo',-1,'2025-12-06 10:14:30',NULL),('2025-12-05 10:14:30','2025-12-05 10:14:30','2025-12-05 10:14:30',1,474,'d59e95cd-d52e-4aed-9529-957ca756d1f8',135,'828c13ab111f4c1d9f4fe33b1ba5f907','gigabytes_tripleo',-1,'2025-12-06 10:14:30',NULL),('2025-12-05 10:14:32','2025-12-05 10:14:32','2025-12-05 10:14:32',1,475,'3de7a142-fd93-4201-afa8-463895b1f07b',132,'828c13ab111f4c1d9f4fe33b1ba5f907','volumes',-1,'2025-12-06 10:14:32',NULL),('2025-12-05 10:14:32','2025-12-05 10:14:32','2025-12-05 10:14:32',1,476,'6ddc56bf-0aba-4e3a-be13-88e2906d757b',133,'828c13ab111f4c1d9f4fe33b1ba5f907','gigabytes',-1,'2025-12-06 10:14:32',NULL),('2025-12-05 10:14:32','2025-12-05 10:14:32','2025-12-05 10:14:32',1,477,'56014748-6d06-4c46-b98f-dbba7de6a8b8',134,'828c13ab111f4c1d9f4fe33b1ba5f907','volumes_tripleo',-1,'2025-12-06 10:14:32',NULL),('2025-12-05 10:14:32','2025-12-05 10:14:32','2025-12-05 10:14:32',1,478,'48ccad6a-2827-497b-87db-210f595ca68c',135,'828c13ab111f4c1d9f4fe33b1ba5f907','gigabytes_tripleo',-1,'2025-12-06 10:14:32',NULL),('2025-12-05 10:14:32','2025-12-05 10:14:32','2025-12-05 10:14:32',1,479,'38cbbabb-a217-484a-a158-d3e39c5de59e',132,'828c13ab111f4c1d9f4fe33b1ba5f907','volumes',1,'2025-12-06 10:14:32',NULL),('2025-12-05 10:14:32','2025-12-05 10:14:32','2025-12-05 10:14:32',1,480,'de6092f6-74ad-42e0-9fef-51bb8dc96475',133,'828c13ab111f4c1d9f4fe33b1ba5f907','gigabytes',1,'2025-12-06 10:14:32',NULL),('2025-12-05 10:14:32','2025-12-05 10:14:32','2025-12-05 10:14:32',1,481,'da284fff-a44a-4051-8540-e865f9f15e87',134,'828c13ab111f4c1d9f4fe33b1ba5f907','volumes_tripleo',1,'2025-12-06 10:14:32',NULL),('2025-12-05 10:14:32','2025-12-05 10:14:32','2025-12-05 10:14:32',1,482,'4065099f-238a-4086-a9b1-b73d742466cd',135,'828c13ab111f4c1d9f4fe33b1ba5f907','gigabytes_tripleo',1,'2025-12-06 10:14:32',NULL),('2025-12-05 10:14:34','2025-12-05 10:14:34','2025-12-05 10:14:34',1,483,'e88f094a-9daa-467e-9cd8-5de02a32da59',132,'828c13ab111f4c1d9f4fe33b1ba5f907','volumes',1,'2025-12-06 10:14:34',NULL),('2025-12-05 10:14:34','2025-12-05 10:14:34','2025-12-05 10:14:34',1,484,'ca90a205-77de-4785-934a-421aac54eb32',133,'828c13ab111f4c1d9f4fe33b1ba5f907','gigabytes',1,'2025-12-06 10:14:34',NULL),('2025-12-05 10:14:34','2025-12-05 10:14:34','2025-12-05 10:14:34',1,485,'fbf7bb82-6dce-466c-9edc-d21d78872ab0',134,'828c13ab111f4c1d9f4fe33b1ba5f907','volumes_tripleo',1,'2025-12-06 10:14:34',NULL),('2025-12-05 10:14:34','2025-12-05 10:14:34','2025-12-05 10:14:34',1,486,'ad0d431b-8c27-41c3-a9c1-2dcd094fb590',135,'828c13ab111f4c1d9f4fe33b1ba5f907','gigabytes_tripleo',1,'2025-12-06 10:14:34',NULL),('2025-12-05 10:14:37','2025-12-05 10:14:37','2025-12-05 10:14:37',1,487,'b9bbff0b-0923-4c36-9b94-c5fbc09df3b0',140,'794eae12144d44b683392db77e4b46a0','backups',-1,'2025-12-06 10:14:37',NULL),('2025-12-05 10:14:37','2025-12-05 10:14:37','2025-12-05 10:14:37',1,488,'2203ec13-68fd-4b42-ab24-a54150763d52',141,'794eae12144d44b683392db77e4b46a0','backup_gigabytes',-1,'2025-12-06 10:14:37',NULL),('2025-12-05 10:14:38','2025-12-05 10:14:38','2025-12-05 10:14:38',1,489,'4a5c4375-e65c-45df-bece-8dbb8ce451dc',132,'828c13ab111f4c1d9f4fe33b1ba5f907','volumes',1,'2025-12-06 10:14:38',NULL),('2025-12-05 10:14:38','2025-12-05 10:14:38','2025-12-05 10:14:38',1,490,'525df661-45fc-4a6f-96b4-908145b5491f',133,'828c13ab111f4c1d9f4fe33b1ba5f907','gigabytes',1,'2025-12-06 10:14:38',NULL),('2025-12-05 10:14:38','2025-12-05 10:14:38','2025-12-05 10:14:38',1,491,'825e0cc0-0cb0-46cf-9804-1d8781eefcff',134,'828c13ab111f4c1d9f4fe33b1ba5f907','volumes_tripleo',1,'2025-12-06 10:14:38',NULL),('2025-12-05 10:14:38','2025-12-05 10:14:38','2025-12-05 10:14:38',1,492,'7b68c746-3b51-4b1c-999c-80f8e840e0e6',135,'828c13ab111f4c1d9f4fe33b1ba5f907','gigabytes_tripleo',1,'2025-12-06 10:14:38',NULL),('2025-12-05 10:14:40','2025-12-05 10:14:42','2025-12-05 10:14:42',1,493,'ea382898-445c-4538-8647-4f3d9802c4a4',136,'794eae12144d44b683392db77e4b46a0','volumes',-1,'2025-12-06 10:14:40',NULL),('2025-12-05 10:14:40','2025-12-05 10:14:42','2025-12-05 10:14:42',1,494,'f7dc1b95-e0fb-4a66-bbff-e7391e05102f',137,'794eae12144d44b683392db77e4b46a0','gigabytes',-1,'2025-12-06 10:14:40',NULL),('2025-12-05 10:14:40','2025-12-05 10:14:42','2025-12-05 10:14:42',1,495,'8ed3b4d3-6b49-4966-8855-b3052be238bd',138,'794eae12144d44b683392db77e4b46a0','volumes_tripleo',-1,'2025-12-06 10:14:40',NULL),('2025-12-05 10:14:40','2025-12-05 10:14:42','2025-12-05 10:14:42',1,496,'a9aeac18-e729-4449-8618-343836b5faff',139,'794eae12144d44b683392db77e4b46a0','gigabytes_tripleo',-1,'2025-12-06 10:14:40',NULL),('2025-12-05 10:14:44','2025-12-05 10:14:44','2025-12-05 10:14:44',1,497,'80ef7517-68b2-4c79-9824-3d66b92d26ce',132,'828c13ab111f4c1d9f4fe33b1ba5f907','volumes',-1,'2025-12-06 10:14:44',NULL),('2025-12-05 10:14:44','2025-12-05 10:14:44','2025-12-05 10:14:44',1,498,'96866120-50d9-466b-b359-3a9fc561e309',133,'828c13ab111f4c1d9f4fe33b1ba5f907','gigabytes',-1,'2025-12-06 10:14:44',NULL),('2025-12-05 10:14:44','2025-12-05 10:14:44','2025-12-05 10:14:44',1,499,'821938e3-b470-4f72-8284-dc3e3b3e2bf7',134,'828c13ab111f4c1d9f4fe33b1ba5f907','volumes_tripleo',-1,'2025-12-06 10:14:44',NULL),('2025-12-05 10:14:44','2025-12-05 10:14:44','2025-12-05 10:14:44',1,500,'8d3c8a88-210c-49d6-af67-23845514ac6a',135,'828c13ab111f4c1d9f4fe33b1ba5f907','gigabytes_tripleo',-1,'2025-12-06 10:14:44',NULL),('2025-12-05 10:14:46','2025-12-05 10:14:46','2025-12-05 10:14:46',1,501,'9d37af4f-d2b4-434f-a435-cb87108c84e1',132,'828c13ab111f4c1d9f4fe33b1ba5f907','volumes',-1,'2025-12-06 10:14:46',NULL),('2025-12-05 10:14:46','2025-12-05 10:14:46','2025-12-05 10:14:46',1,502,'7df64847-feeb-4fda-a120-39a93f2b3921',133,'828c13ab111f4c1d9f4fe33b1ba5f907','gigabytes',-1,'2025-12-06 10:14:46',NULL),('2025-12-05 10:14:46','2025-12-05 10:14:46','2025-12-05 10:14:46',1,503,'7029028c-8687-4407-b08c-db580ee3d532',134,'828c13ab111f4c1d9f4fe33b1ba5f907','volumes_tripleo',-1,'2025-12-06 10:14:46',NULL),('2025-12-05 10:14:46','2025-12-05 10:14:46','2025-12-05 10:14:46',1,504,'432a32d8-c9af-4c39-be5e-2e49fef6945a',135,'828c13ab111f4c1d9f4fe33b1ba5f907','gigabytes_tripleo',-1,'2025-12-06 10:14:46',NULL),('2025-12-05 10:14:47','2025-12-05 10:14:47','2025-12-05 10:14:47',1,505,'0e0bd47f-a48a-4903-a2ce-e0800483d21f',142,'c8125d7d8c2c4e869c6cf854824ed1f9','volumes',1,'2025-12-06 10:14:47',NULL),('2025-12-05 10:14:47','2025-12-05 10:14:47','2025-12-05 10:14:47',1,506,'19ddcd68-8af8-40dd-8073-46eb3cf90ffa',143,'c8125d7d8c2c4e869c6cf854824ed1f9','gigabytes',1,'2025-12-06 10:14:47',NULL),('2025-12-05 10:14:47','2025-12-05 10:14:47','2025-12-05 10:14:47',1,507,'8de68752-024f-4fb8-8f09-d87a5baddbd5',144,'c8125d7d8c2c4e869c6cf854824ed1f9','volumes_tripleo',1,'2025-12-06 10:14:47',NULL),('2025-12-05 10:14:47','2025-12-05 10:14:47','2025-12-05 10:14:47',1,508,'e296025e-e4db-4f7f-a421-1b1888ed4899',145,'c8125d7d8c2c4e869c6cf854824ed1f9','gigabytes_tripleo',1,'2025-12-06 10:14:47',NULL),('2025-12-05 10:14:48','2025-12-05 10:14:48','2025-12-05 10:14:48',1,509,'8efb24ce-cceb-45c9-8420-ca64fe3d9143',132,'828c13ab111f4c1d9f4fe33b1ba5f907','volumes',-1,'2025-12-06 10:14:48',NULL),('2025-12-05 10:14:48','2025-12-05 10:14:48','2025-12-05 10:14:48',1,510,'8861b46f-b91b-4018-a79b-ef69ac5e2c3d',133,'828c13ab111f4c1d9f4fe33b1ba5f907','gigabytes',-1,'2025-12-06 10:14:48',NULL),('2025-12-05 10:14:48','2025-12-05 10:14:48','2025-12-05 10:14:48',1,511,'451715a1-8c72-4f00-b901-b44aaa2a9ad2',134,'828c13ab111f4c1d9f4fe33b1ba5f907','volumes_tripleo',-1,'2025-12-06 10:14:48',NULL),('2025-12-05 10:14:48','2025-12-05 10:14:48','2025-12-05 10:14:48',1,512,'7e2de229-609e-4966-a3ca-59a5e8ff03d3',135,'828c13ab111f4c1d9f4fe33b1ba5f907','gigabytes_tripleo',-1,'2025-12-06 10:14:48',NULL),('2025-12-05 10:14:49','2025-12-05 10:14:49','2025-12-05 10:14:49',1,513,'43568baf-1cc4-49f4-aa52-baa2a118e5be',132,'828c13ab111f4c1d9f4fe33b1ba5f907','volumes',1,'2025-12-06 10:14:49',NULL),('2025-12-05 10:14:49','2025-12-05 10:14:49','2025-12-05 10:14:49',1,514,'3ac58520-e212-4bc9-8f21-f34798421939',133,'828c13ab111f4c1d9f4fe33b1ba5f907','gigabytes',1,'2025-12-06 10:14:49',NULL),('2025-12-05 10:14:49','2025-12-05 10:14:49','2025-12-05 10:14:49',1,515,'70c2c56a-8687-4500-9323-4bfe5e8547fe',134,'828c13ab111f4c1d9f4fe33b1ba5f907','volumes_tripleo',1,'2025-12-06 10:14:49',NULL),('2025-12-05 10:14:49','2025-12-05 10:14:49','2025-12-05 10:14:49',1,516,'e110cfcf-d4f6-4740-b0cb-4fd57c71c384',135,'828c13ab111f4c1d9f4fe33b1ba5f907','gigabytes_tripleo',1,'2025-12-06 10:14:49',NULL),('2025-12-05 10:14:58','2025-12-05 10:14:58','2025-12-05 10:14:58',1,517,'8ef66ad8-ad4d-41d9-8dde-9496768d15e6',143,'c8125d7d8c2c4e869c6cf854824ed1f9','gigabytes',1,'2025-12-06 10:14:58',NULL),('2025-12-05 10:14:58','2025-12-05 10:14:58','2025-12-05 10:14:58',1,518,'ce8af6b9-217d-47c3-a3a1-eb886dedddc5',145,'c8125d7d8c2c4e869c6cf854824ed1f9','gigabytes_tripleo',1,'2025-12-06 10:14:58',NULL),('2025-12-05 10:14:59','2025-12-05 10:15:00','2025-12-05 10:15:00',1,519,'294e74d3-1c69-406e-8f1e-57727ab2a303',132,'828c13ab111f4c1d9f4fe33b1ba5f907','volumes',1,'2025-12-06 10:14:59',NULL),('2025-12-05 10:14:59','2025-12-05 10:15:00','2025-12-05 10:15:00',1,520,'2f74ed90-af7f-460a-a71c-804dae54c7c6',133,'828c13ab111f4c1d9f4fe33b1ba5f907','gigabytes',1,'2025-12-06 10:14:59',NULL),('2025-12-05 10:14:59','2025-12-05 10:15:00','2025-12-05 10:15:00',1,521,'42673dcf-f0ee-4126-ae48-729b380fd33e',134,'828c13ab111f4c1d9f4fe33b1ba5f907','volumes_tripleo',1,'2025-12-06 10:14:59',NULL),('2025-12-05 10:14:59','2025-12-05 10:15:00','2025-12-05 10:15:00',1,522,'8f4f9ef5-3d5f-4c41-888d-0e6bd8b12a00',135,'828c13ab111f4c1d9f4fe33b1ba5f907','gigabytes_tripleo',1,'2025-12-06 10:14:59',NULL),('2025-12-05 10:15:01','2025-12-05 10:15:01','2025-12-05 10:15:01',1,523,'a56c91f9-c6a4-41b9-8f77-0762d3b9d828',142,'c8125d7d8c2c4e869c6cf854824ed1f9','volumes',-1,'2025-12-06 10:15:01',NULL),('2025-12-05 10:15:01','2025-12-05 10:15:01','2025-12-05 10:15:01',1,524,'e4a1f577-3164-4ca8-b878-c5d993ab9451',143,'c8125d7d8c2c4e869c6cf854824ed1f9','gigabytes',-2,'2025-12-06 10:15:01',NULL),('2025-12-05 10:15:01','2025-12-05 10:15:01','2025-12-05 10:15:01',1,525,'34e3a267-9159-47f1-bbf2-f0bad1555c1d',144,'c8125d7d8c2c4e869c6cf854824ed1f9','volumes_tripleo',-1,'2025-12-06 10:15:01',NULL),('2025-12-05 10:15:01','2025-12-05 10:15:01','2025-12-05 10:15:01',1,526,'4e37625d-7ae3-4f7c-a5e9-4b97b31c9906',145,'c8125d7d8c2c4e869c6cf854824ed1f9','gigabytes_tripleo',-2,'2025-12-06 10:15:01',NULL),('2025-12-05 10:15:02','2025-12-05 10:15:04','2025-12-05 10:15:04',1,527,'4748b700-6192-4165-baae-30f560d6b5e7',142,'c8125d7d8c2c4e869c6cf854824ed1f9','volumes',1,'2025-12-06 10:15:02',NULL),('2025-12-05 10:15:02','2025-12-05 10:15:04','2025-12-05 10:15:04',1,528,'309094ee-6552-4c5e-9ea2-5aaac8e4c549',143,'c8125d7d8c2c4e869c6cf854824ed1f9','gigabytes',1,'2025-12-06 10:15:02',NULL),('2025-12-05 10:15:02','2025-12-05 10:15:04','2025-12-05 10:15:04',1,529,'0b033fc3-cf4a-4a62-b301-224965d6e9fb',144,'c8125d7d8c2c4e869c6cf854824ed1f9','volumes_tripleo',1,'2025-12-06 10:15:02',NULL),('2025-12-05 10:15:02','2025-12-05 10:15:04','2025-12-05 10:15:04',1,530,'585afc1a-fc7d-45aa-9b57-e0b0d84c3423',145,'c8125d7d8c2c4e869c6cf854824ed1f9','gigabytes_tripleo',1,'2025-12-06 10:15:02',NULL),('2025-12-05 10:15:03','2025-12-05 10:15:04','2025-12-05 10:15:04',1,531,'8c7c381d-8b1e-4fbc-a1e7-fbd229827f5a',132,'828c13ab111f4c1d9f4fe33b1ba5f907','volumes',-1,'2025-12-06 10:15:03',NULL),('2025-12-05 10:15:03','2025-12-05 10:15:04','2025-12-05 10:15:04',1,532,'d460529d-8a74-4997-adf4-bb73560960f1',133,'828c13ab111f4c1d9f4fe33b1ba5f907','gigabytes',-1,'2025-12-06 10:15:03',NULL),('2025-12-05 10:15:03','2025-12-05 10:15:04','2025-12-05 10:15:04',1,533,'9b2fdf02-ae2a-4a1e-a18f-91682ffe84ba',134,'828c13ab111f4c1d9f4fe33b1ba5f907','volumes_tripleo',-1,'2025-12-06 10:15:03',NULL),('2025-12-05 10:15:03','2025-12-05 10:15:04','2025-12-05 10:15:04',1,534,'412eb174-43cc-4615-b102-96a62c1e474b',135,'828c13ab111f4c1d9f4fe33b1ba5f907','gigabytes_tripleo',-1,'2025-12-06 10:15:03',NULL),('2025-12-05 10:15:05','2025-12-05 10:15:05','2025-12-05 10:15:05',1,535,'a61190d7-65cb-4e8b-9e67-628c95556957',146,'c8125d7d8c2c4e869c6cf854824ed1f9','snapshots',1,'2025-12-06 10:15:05',NULL),('2025-12-05 10:15:05','2025-12-05 10:15:05','2025-12-05 10:15:05',1,536,'2e2e285a-46c2-458f-a724-b1705c26ac08',143,'c8125d7d8c2c4e869c6cf854824ed1f9','gigabytes',1,'2025-12-06 10:15:05',NULL),('2025-12-05 10:15:05','2025-12-05 10:15:05','2025-12-05 10:15:05',1,537,'42684b73-9d1e-400a-8d6a-7ae9d5ad9b33',145,'c8125d7d8c2c4e869c6cf854824ed1f9','gigabytes_tripleo',1,'2025-12-06 10:15:05',NULL),('2025-12-05 10:15:05','2025-12-05 10:15:05','2025-12-05 10:15:05',1,538,'7748c087-63f6-45d8-8109-3b0586b4794c',147,'c8125d7d8c2c4e869c6cf854824ed1f9','snapshots_tripleo',1,'2025-12-06 10:15:05',NULL),('2025-12-05 10:15:06','2025-12-05 10:15:06','2025-12-05 10:15:06',1,539,'18088206-8f34-4d39-8b10-0f14cdc42520',132,'828c13ab111f4c1d9f4fe33b1ba5f907','volumes',-1,'2025-12-06 10:15:06',NULL),('2025-12-05 10:15:06','2025-12-05 10:15:06','2025-12-05 10:15:06',1,540,'d57e05ce-f160-4064-a5e5-3c5c482a33e2',133,'828c13ab111f4c1d9f4fe33b1ba5f907','gigabytes',-1,'2025-12-06 10:15:06',NULL),('2025-12-05 10:15:06','2025-12-05 10:15:06','2025-12-05 10:15:06',1,541,'16636739-4e42-467b-b8d4-c72403335576',134,'828c13ab111f4c1d9f4fe33b1ba5f907','volumes_tripleo',-1,'2025-12-06 10:15:06',NULL),('2025-12-05 10:15:06','2025-12-05 10:15:06','2025-12-05 10:15:06',1,542,'4f9a521c-3e40-4fa0-95df-63811368b2e6',135,'828c13ab111f4c1d9f4fe33b1ba5f907','gigabytes_tripleo',-1,'2025-12-06 10:15:06',NULL),('2025-12-05 10:15:06','2025-12-05 10:15:06','2025-12-05 10:15:06',1,543,'8acc99b1-8f5b-4f07-bf74-eaa0269f1fd7',143,'c8125d7d8c2c4e869c6cf854824ed1f9','gigabytes',1,'2025-12-06 10:15:06',NULL),('2025-12-05 10:15:06','2025-12-05 10:15:06','2025-12-05 10:15:06',1,544,'f3192cf9-74c7-4feb-9d26-ee8b705495b8',145,'c8125d7d8c2c4e869c6cf854824ed1f9','gigabytes_tripleo',1,'2025-12-06 10:15:06',NULL),('2025-12-05 10:15:09','2025-12-05 10:15:09','2025-12-05 10:15:09',1,545,'9845ffc2-fc08-44a8-91c2-2a292e6b66b8',146,'c8125d7d8c2c4e869c6cf854824ed1f9','snapshots',-1,'2025-12-06 10:15:09',NULL),('2025-12-05 10:15:09','2025-12-05 10:15:09','2025-12-05 10:15:09',1,546,'9079ee91-e5bc-445e-8dd9-1d23019f5526',143,'c8125d7d8c2c4e869c6cf854824ed1f9','gigabytes',-1,'2025-12-06 10:15:09',NULL),('2025-12-05 10:15:09','2025-12-05 10:15:09','2025-12-05 10:15:09',1,547,'23f4322c-1ff0-436d-804f-5b37f36730f8',145,'c8125d7d8c2c4e869c6cf854824ed1f9','gigabytes_tripleo',-1,'2025-12-06 10:15:09',NULL),('2025-12-05 10:15:09','2025-12-05 10:15:09','2025-12-05 10:15:09',1,548,'b9b8ddd5-4395-4a98-9377-c4b5dbe91787',147,'c8125d7d8c2c4e869c6cf854824ed1f9','snapshots_tripleo',-1,'2025-12-06 10:15:09',NULL),('2025-12-05 10:15:12','2025-12-05 10:15:12','2025-12-05 10:15:12',1,549,'6bfa8a2c-a60b-404c-9ebe-f5d288a17872',142,'c8125d7d8c2c4e869c6cf854824ed1f9','volumes',-1,'2025-12-06 10:15:12',NULL),('2025-12-05 10:15:12','2025-12-05 10:15:12','2025-12-05 10:15:12',1,550,'94b8b66b-07a4-4641-8be5-4b9be1d985c3',143,'c8125d7d8c2c4e869c6cf854824ed1f9','gigabytes',-2,'2025-12-06 10:15:12',NULL),('2025-12-05 10:15:12','2025-12-05 10:15:12','2025-12-05 10:15:12',1,551,'f41ebd35-bc25-47f4-8371-7ca0242faae2',144,'c8125d7d8c2c4e869c6cf854824ed1f9','volumes_tripleo',-1,'2025-12-06 10:15:12',NULL),('2025-12-05 10:15:12','2025-12-05 10:15:12','2025-12-05 10:15:12',1,552,'12699f25-0125-4a0e-8607-0201f7689c5d',145,'c8125d7d8c2c4e869c6cf854824ed1f9','gigabytes_tripleo',-2,'2025-12-06 10:15:12',NULL),('2025-12-05 10:15:12','2025-12-05 10:15:12','2025-12-05 10:15:12',1,553,'5a91a0a6-bf5f-46f8-9f45-17c68822ce27',148,'1a4ef1e0bdbf479f861daafd49015589','volumes',1,'2025-12-06 10:15:12',NULL),('2025-12-05 10:15:12','2025-12-05 10:15:12','2025-12-05 10:15:12',1,554,'72cb90d8-16a2-44a3-860a-edf79f6eb97e',149,'1a4ef1e0bdbf479f861daafd49015589','gigabytes',1,'2025-12-06 10:15:12',NULL),('2025-12-05 10:15:12','2025-12-05 10:15:12','2025-12-05 10:15:12',1,555,'0806e4f8-059a-43c1-b592-04e2cff95d74',150,'1a4ef1e0bdbf479f861daafd49015589','volumes_tripleo',1,'2025-12-06 10:15:12',NULL),('2025-12-05 10:15:12','2025-12-05 10:15:12','2025-12-05 10:15:12',1,556,'ed4f3c27-323c-4fa4-a29b-4e81e0bf5812',151,'1a4ef1e0bdbf479f861daafd49015589','gigabytes_tripleo',1,'2025-12-06 10:15:12',NULL),('2025-12-05 10:15:14','2025-12-05 10:15:14','2025-12-05 10:15:14',1,557,'1bb5c3ed-3690-4935-9119-b469acfa7371',148,'1a4ef1e0bdbf479f861daafd49015589','volumes',1,'2025-12-06 10:15:14',NULL),('2025-12-05 10:15:14','2025-12-05 10:15:14','2025-12-05 10:15:14',1,558,'6e48170b-7c2b-46c2-9e1f-5dc6ac5127c1',149,'1a4ef1e0bdbf479f861daafd49015589','gigabytes',1,'2025-12-06 10:15:14',NULL),('2025-12-05 10:15:14','2025-12-05 10:15:14','2025-12-05 10:15:14',1,559,'179378c6-0d63-444a-ba41-6848050fd7f5',150,'1a4ef1e0bdbf479f861daafd49015589','volumes_tripleo',1,'2025-12-06 10:15:14',NULL),('2025-12-05 10:15:14','2025-12-05 10:15:14','2025-12-05 10:15:14',1,560,'bd6d4a58-c28f-4e00-a05c-26414922b510',151,'1a4ef1e0bdbf479f861daafd49015589','gigabytes_tripleo',1,'2025-12-06 10:15:14',NULL),('2025-12-05 10:15:15','2025-12-05 10:15:16','2025-12-05 10:15:16',1,561,'24f69bd5-2162-4e68-80a8-6d70c3e8798b',148,'1a4ef1e0bdbf479f861daafd49015589','volumes',1,'2025-12-06 10:15:15',NULL),('2025-12-05 10:15:15','2025-12-05 10:15:16','2025-12-05 10:15:16',1,562,'87226a07-0550-4182-88e2-5163b0767661',149,'1a4ef1e0bdbf479f861daafd49015589','gigabytes',1,'2025-12-06 10:15:15',NULL),('2025-12-05 10:15:15','2025-12-05 10:15:16','2025-12-05 10:15:16',1,563,'084f3929-58a7-4657-be23-d856e2fbd199',150,'1a4ef1e0bdbf479f861daafd49015589','volumes_tripleo',1,'2025-12-06 10:15:15',NULL),('2025-12-05 10:15:15','2025-12-05 10:15:16','2025-12-05 10:15:16',1,564,'d77565b8-b6a2-49f2-9866-6920c6d60024',151,'1a4ef1e0bdbf479f861daafd49015589','gigabytes_tripleo',1,'2025-12-06 10:15:15',NULL),('2025-12-05 10:15:18','2025-12-05 10:15:18','2025-12-05 10:15:18',1,565,'1acd6968-3cfb-4b55-b2ce-efa69374a6af',152,'adb319e7a5f345eeabc757f1c6532ff0','groups',1,'2025-12-06 10:15:18',NULL),('2025-12-05 10:15:18','2025-12-05 10:15:18','2025-12-05 10:15:18',1,566,'d1cfc505-2bbf-4830-bdf8-7bfcefb69cca',128,'8730b222fadf4a249823e59d8b326dde','volumes',-1,'2025-12-06 10:15:18',NULL),('2025-12-05 10:15:18','2025-12-05 10:15:18','2025-12-05 10:15:18',1,567,'67a448c9-410f-44ff-b63c-c1c32efe2422',129,'8730b222fadf4a249823e59d8b326dde','gigabytes',-1,'2025-12-06 10:15:18',NULL),('2025-12-05 10:15:18','2025-12-05 10:15:18','2025-12-05 10:15:18',1,568,'a986c3ba-a483-44a6-9161-43efb0020a0e',130,'8730b222fadf4a249823e59d8b326dde','volumes_tripleo',-1,'2025-12-06 10:15:18',NULL),('2025-12-05 10:15:18','2025-12-05 10:15:18','2025-12-05 10:15:18',1,569,'fe21130a-4e2a-4028-aad3-85e1a9266dca',131,'8730b222fadf4a249823e59d8b326dde','gigabytes_tripleo',-1,'2025-12-06 10:15:18',NULL),('2025-12-05 10:15:19','2025-12-05 10:15:19','2025-12-05 10:15:19',1,570,'c57d8d02-6cce-4823-a454-5aa50a48c04f',152,'adb319e7a5f345eeabc757f1c6532ff0','groups',1,'2025-12-06 10:15:19',NULL),('2025-12-05 10:15:19','2025-12-05 10:15:19','2025-12-05 10:15:19',1,571,'5534e433-e4b0-41d4-8230-327ca6f2da9c',148,'1a4ef1e0bdbf479f861daafd49015589','volumes',-1,'2025-12-06 10:15:19',NULL),('2025-12-05 10:15:19','2025-12-05 10:15:19','2025-12-05 10:15:19',1,572,'4705e10b-0e9c-4821-885d-07b4f4f08099',149,'1a4ef1e0bdbf479f861daafd49015589','gigabytes',-1,'2025-12-06 10:15:19',NULL),('2025-12-05 10:15:19','2025-12-05 10:15:19','2025-12-05 10:15:19',1,573,'1e374687-2fd3-4925-8aa6-aff2db530536',150,'1a4ef1e0bdbf479f861daafd49015589','volumes_tripleo',-1,'2025-12-06 10:15:19',NULL),('2025-12-05 10:15:19','2025-12-05 10:15:19','2025-12-05 10:15:19',1,574,'818f719c-005a-4a19-bd70-d78995007418',151,'1a4ef1e0bdbf479f861daafd49015589','gigabytes_tripleo',-1,'2025-12-06 10:15:19',NULL),('2025-12-05 10:15:20','2025-12-05 10:15:20','2025-12-05 10:15:20',1,575,'2e780463-11a7-4bdf-b2fc-57ef23fab94a',153,'adb319e7a5f345eeabc757f1c6532ff0','volumes',1,'2025-12-06 10:15:20',NULL),('2025-12-05 10:15:20','2025-12-05 10:15:20','2025-12-05 10:15:20',1,576,'8cea1ac1-c50d-4bd0-8934-e12e0127f7b7',154,'adb319e7a5f345eeabc757f1c6532ff0','gigabytes',1,'2025-12-06 10:15:20',NULL),('2025-12-05 10:15:20','2025-12-05 10:15:20','2025-12-05 10:15:20',1,577,'dad804ab-475d-4ef5-bbaf-0012ec25899b',155,'adb319e7a5f345eeabc757f1c6532ff0','volumes_tempest-GroupsTest-volume-type-1339094509',1,'2025-12-06 10:15:20',NULL),('2025-12-05 10:15:20','2025-12-05 10:15:20','2025-12-05 10:15:20',1,578,'508fd9a2-11a9-42dd-b2a6-f61ca1e7639c',156,'adb319e7a5f345eeabc757f1c6532ff0','gigabytes_tempest-GroupsTest-volume-type-1339094509',1,'2025-12-06 10:15:20',NULL),('2025-12-05 10:15:20','2025-12-05 10:15:20','2025-12-05 10:15:20',1,579,'36e3def4-b1d4-4151-bf9c-7fa485339d81',148,'1a4ef1e0bdbf479f861daafd49015589','volumes',-1,'2025-12-06 10:15:20',NULL),('2025-12-05 10:15:20','2025-12-05 10:15:20','2025-12-05 10:15:20',1,580,'8b466968-5941-460b-b311-6aa1fd7933d8',149,'1a4ef1e0bdbf479f861daafd49015589','gigabytes',-1,'2025-12-06 10:15:20',NULL),('2025-12-05 10:15:20','2025-12-05 10:15:20','2025-12-05 10:15:20',1,581,'db3a7048-9299-43f9-9f7d-bc48ce3abcb6',150,'1a4ef1e0bdbf479f861daafd49015589','volumes_tripleo',-1,'2025-12-06 10:15:20',NULL),('2025-12-05 10:15:20','2025-12-05 10:15:20','2025-12-05 10:15:20',1,582,'21cf826d-6439-4cd7-954f-966948c50243',151,'1a4ef1e0bdbf479f861daafd49015589','gigabytes_tripleo',-1,'2025-12-06 10:15:20',NULL),('2025-12-05 10:15:23','2025-12-05 10:15:23','2025-12-05 10:15:23',1,583,'ae482593-12f5-42f4-878b-be2e6fc64f8d',152,'adb319e7a5f345eeabc757f1c6532ff0','groups',-1,'2025-12-06 10:15:23',NULL),('2025-12-05 10:15:23','2025-12-05 10:15:23','2025-12-05 10:15:23',1,584,'02e4b645-6ace-4d74-a983-3c11a7e93d22',148,'1a4ef1e0bdbf479f861daafd49015589','volumes',-1,'2025-12-06 10:15:23',NULL),('2025-12-05 10:15:23','2025-12-05 10:15:23','2025-12-05 10:15:23',1,585,'0eb6d6e4-4a41-4d26-8979-226a6ff0ff50',149,'1a4ef1e0bdbf479f861daafd49015589','gigabytes',-1,'2025-12-06 10:15:23',NULL),('2025-12-05 10:15:23','2025-12-05 10:15:23','2025-12-05 10:15:23',1,586,'849d40d3-51d2-4160-a6a6-a16f9834db6c',150,'1a4ef1e0bdbf479f861daafd49015589','volumes_tripleo',-1,'2025-12-06 10:15:23',NULL),('2025-12-05 10:15:23','2025-12-05 10:15:23','2025-12-05 10:15:23',1,587,'5dbb98a0-5f71-4c2f-9a99-715945bf987b',151,'1a4ef1e0bdbf479f861daafd49015589','gigabytes_tripleo',-1,'2025-12-06 10:15:23',NULL),('2025-12-05 10:15:23','2025-12-05 10:15:23','2025-12-05 10:15:23',1,588,'65a7abb9-9910-4d6f-891e-9698048ed588',153,'adb319e7a5f345eeabc757f1c6532ff0','volumes',-1,'2025-12-06 10:15:23',NULL),('2025-12-05 10:15:23','2025-12-05 10:15:23','2025-12-05 10:15:23',1,589,'abc4460f-2a0b-4f7e-8d10-93728bb32b0e',154,'adb319e7a5f345eeabc757f1c6532ff0','gigabytes',-1,'2025-12-06 10:15:23',NULL),('2025-12-05 10:15:23','2025-12-05 10:15:23','2025-12-05 10:15:23',1,590,'a3ce7e44-00e2-4938-afc6-30c06bf00d99',155,'adb319e7a5f345eeabc757f1c6532ff0','volumes_tempest-GroupsTest-volume-type-1339094509',-1,'2025-12-06 10:15:23',NULL),('2025-12-05 10:15:23','2025-12-05 10:15:23','2025-12-05 10:15:23',1,591,'c0eb35e9-fc77-41bb-931b-ce39b7a6d0df',156,'adb319e7a5f345eeabc757f1c6532ff0','gigabytes_tempest-GroupsTest-volume-type-1339094509',-1,'2025-12-06 10:15:23',NULL),('2025-12-05 10:15:23','2025-12-05 10:15:23','2025-12-05 10:15:23',1,592,'145fcd16-f7ee-4959-882f-a57d98f858c9',152,'adb319e7a5f345eeabc757f1c6532ff0','groups',-1,'2025-12-06 10:15:23',NULL),('2025-12-05 10:15:25','2025-12-05 10:15:25','2025-12-05 10:15:25',1,593,'d7295535-65dd-40f4-bcd1-2bef81173cb8',152,'adb319e7a5f345eeabc757f1c6532ff0','groups',1,'2025-12-06 10:15:25',NULL),('2025-12-05 10:15:26','2025-12-05 10:15:26','2025-12-05 10:15:26',1,594,'052dd8d2-8b26-4b22-8db2-e7ee1cfc334f',153,'adb319e7a5f345eeabc757f1c6532ff0','volumes',1,'2025-12-06 10:15:26',NULL),('2025-12-05 10:15:26','2025-12-05 10:15:26','2025-12-05 10:15:26',1,595,'ae47f7d3-6bfd-4c5e-855f-40d232aa943c',154,'adb319e7a5f345eeabc757f1c6532ff0','gigabytes',1,'2025-12-06 10:15:26',NULL),('2025-12-05 10:15:26','2025-12-05 10:15:26','2025-12-05 10:15:26',1,596,'9ff9bdfd-bc25-43f1-97cb-7a3b4082019c',157,'adb319e7a5f345eeabc757f1c6532ff0','volumes_tempest-GroupsTest-volume-type-211870054',1,'2025-12-06 10:15:26',NULL),('2025-12-05 10:15:26','2025-12-05 10:15:26','2025-12-05 10:15:26',1,597,'ea57747f-8eb3-441f-9198-026f950caf8d',158,'adb319e7a5f345eeabc757f1c6532ff0','gigabytes_tempest-GroupsTest-volume-type-211870054',1,'2025-12-06 10:15:26',NULL),('2025-12-05 10:15:28','2025-12-05 10:15:28','2025-12-05 10:15:28',1,598,'4762ea49-f126-4551-b2b6-1135582d058f',153,'adb319e7a5f345eeabc757f1c6532ff0','volumes',1,'2025-12-06 10:15:28',NULL),('2025-12-05 10:15:28','2025-12-05 10:15:28','2025-12-05 10:15:28',1,599,'806aa12e-74ac-484a-8c3b-fd0b589cc677',154,'adb319e7a5f345eeabc757f1c6532ff0','gigabytes',1,'2025-12-06 10:15:28',NULL),('2025-12-05 10:15:28','2025-12-05 10:15:28','2025-12-05 10:15:28',1,600,'09d99416-5219-4638-b021-31b33513ddbe',157,'adb319e7a5f345eeabc757f1c6532ff0','volumes_tempest-GroupsTest-volume-type-211870054',1,'2025-12-06 10:15:28',NULL),('2025-12-05 10:15:28','2025-12-05 10:15:28','2025-12-05 10:15:28',1,601,'4156803d-0fe9-4717-b53d-75b1862430c6',158,'adb319e7a5f345eeabc757f1c6532ff0','gigabytes_tempest-GroupsTest-volume-type-211870054',1,'2025-12-06 10:15:28',NULL),('2025-12-05 10:15:34','2025-12-05 10:15:34','2025-12-05 10:15:34',1,602,'01f2b7cb-0a6c-420a-8eb6-0a76a3f88672',152,'adb319e7a5f345eeabc757f1c6532ff0','groups',-1,'2025-12-06 10:15:34',NULL),('2025-12-05 10:15:34','2025-12-05 10:15:34','2025-12-05 10:15:34',1,603,'e2754812-7272-4555-bbc9-c0f2aae8977d',153,'adb319e7a5f345eeabc757f1c6532ff0','volumes',-1,'2025-12-06 10:15:34',NULL),('2025-12-05 10:15:34','2025-12-05 10:15:34','2025-12-05 10:15:34',1,604,'358fa9a5-7a6f-40e7-9f3b-bcff573fb4ca',154,'adb319e7a5f345eeabc757f1c6532ff0','gigabytes',-1,'2025-12-06 10:15:34',NULL),('2025-12-05 10:15:34','2025-12-05 10:15:34','2025-12-05 10:15:34',1,605,'ac57ceb7-b9d4-4c11-89eb-8abcf722473d',157,'adb319e7a5f345eeabc757f1c6532ff0','volumes_tempest-GroupsTest-volume-type-211870054',-1,'2025-12-06 10:15:34',NULL),('2025-12-05 10:15:34','2025-12-05 10:15:34','2025-12-05 10:15:34',1,606,'97be2e77-68fc-41fb-b521-2809a3556d58',158,'adb319e7a5f345eeabc757f1c6532ff0','gigabytes_tempest-GroupsTest-volume-type-211870054',-1,'2025-12-06 10:15:34',NULL),('2025-12-05 10:15:34','2025-12-05 10:15:34','2025-12-05 10:15:34',1,607,'b76dc614-fe0e-4d2e-ac94-8e65482d7c09',153,'adb319e7a5f345eeabc757f1c6532ff0','volumes',-1,'2025-12-06 10:15:34',NULL),('2025-12-05 10:15:34','2025-12-05 10:15:34','2025-12-05 10:15:34',1,608,'82f249a4-77cd-4fb3-b9c1-c6e40990062e',154,'adb319e7a5f345eeabc757f1c6532ff0','gigabytes',-1,'2025-12-06 10:15:34',NULL),('2025-12-05 10:15:34','2025-12-05 10:15:34','2025-12-05 10:15:34',1,609,'a3c59e73-83c3-42cb-97de-1b002e522a7a',157,'adb319e7a5f345eeabc757f1c6532ff0','volumes_tempest-GroupsTest-volume-type-211870054',-1,'2025-12-06 10:15:34',NULL),('2025-12-05 10:15:34','2025-12-05 10:15:34','2025-12-05 10:15:34',1,610,'3e7ea401-080a-4424-9522-20627f9b7a8c',158,'adb319e7a5f345eeabc757f1c6532ff0','gigabytes_tempest-GroupsTest-volume-type-211870054',-1,'2025-12-06 10:15:34',NULL),('2025-12-05 10:15:51','2025-12-05 10:15:51','2025-12-05 10:15:51',1,611,'825481e4-079c-43bd-a56f-d2a77c4e3d36',159,'ebf51e9cd741494484f25cc0c15bc318','groups',1,'2025-12-06 10:15:51',NULL),('2025-12-05 10:15:52','2025-12-05 10:15:52','2025-12-05 10:15:52',1,612,'d29c1ee2-bd4e-4086-8d13-46a462416f16',160,'ebf51e9cd741494484f25cc0c15bc318','volumes',1,'2025-12-06 10:15:52',NULL),('2025-12-05 10:15:52','2025-12-05 10:15:52','2025-12-05 10:15:52',1,613,'4d87b129-3e9d-4872-9363-f76443239580',161,'ebf51e9cd741494484f25cc0c15bc318','gigabytes',1,'2025-12-06 10:15:52',NULL),('2025-12-05 10:15:52','2025-12-05 10:15:52','2025-12-05 10:15:52',1,614,'7f4a6460-0d03-42c6-a081-af4ddd8b75ec',162,'ebf51e9cd741494484f25cc0c15bc318','volumes_tempest-GroupSnapshotsTest-volume-type-742511643',1,'2025-12-06 10:15:52',NULL),('2025-12-05 10:15:52','2025-12-05 10:15:52','2025-12-05 10:15:52',1,615,'fb6b6196-bb07-4d38-92a1-ec30bc78dfa2',163,'ebf51e9cd741494484f25cc0c15bc318','gigabytes_tempest-GroupSnapshotsTest-volume-type-742511643',1,'2025-12-06 10:15:52',NULL),('2025-12-05 10:15:55','2025-12-05 10:15:55','2025-12-05 10:15:55',1,616,'56e443f4-58b8-4c3b-b738-83d769578f9f',164,'ee708d36384c422aad0ff42f0242e9cf','volumes',1,'2025-12-06 10:15:53',NULL),('2025-12-05 10:15:55','2025-12-05 10:15:55','2025-12-05 10:15:55',1,617,'7d99ef5b-7bbb-4b02-906e-6ded4d7ed595',165,'ee708d36384c422aad0ff42f0242e9cf','gigabytes',1,'2025-12-06 10:15:53',NULL),('2025-12-05 10:15:55','2025-12-05 10:15:55','2025-12-05 10:15:55',1,618,'b723c2c5-1c89-4661-b8f2-0ac363e1acec',166,'ee708d36384c422aad0ff42f0242e9cf','volumes_tripleo',1,'2025-12-06 10:15:53',NULL),('2025-12-05 10:15:55','2025-12-05 10:15:55','2025-12-05 10:15:55',1,619,'3d17dfc9-e39f-40cf-8832-eb0fe11238cf',167,'ee708d36384c422aad0ff42f0242e9cf','gigabytes_tripleo',1,'2025-12-06 10:15:53',NULL),('2025-12-05 10:15:55','2025-12-05 10:15:55','2025-12-05 10:15:55',1,620,'56c28e06-08fa-441a-b5aa-0125f622d0c3',168,'ebf51e9cd741494484f25cc0c15bc318','snapshots',1,'2025-12-06 10:15:55',NULL),('2025-12-05 10:15:55','2025-12-05 10:15:55','2025-12-05 10:15:55',1,621,'c1cd4fc4-c24e-46ff-b80b-1d6c62057c1d',161,'ebf51e9cd741494484f25cc0c15bc318','gigabytes',1,'2025-12-06 10:15:55',NULL),('2025-12-05 10:15:55','2025-12-05 10:15:55','2025-12-05 10:15:55',1,622,'57d90187-3b6f-4816-94ea-0e05b44c3a48',163,'ebf51e9cd741494484f25cc0c15bc318','gigabytes_tempest-GroupSnapshotsTest-volume-type-742511643',1,'2025-12-06 10:15:55',NULL),('2025-12-05 10:15:55','2025-12-05 10:15:55','2025-12-05 10:15:55',1,623,'01ac8ddf-813d-4262-b16e-65e60d08f926',169,'ebf51e9cd741494484f25cc0c15bc318','snapshots_tempest-GroupSnapshotsTest-volume-type-742511643',1,'2025-12-06 10:15:55',NULL),('2025-12-05 10:15:56','2025-12-05 10:15:57','2025-12-05 10:15:57',1,624,'cf0a55ca-f4a0-4d65-88e2-13148f7abeb3',159,'ebf51e9cd741494484f25cc0c15bc318','groups',1,'2025-12-06 10:15:56',NULL),('2025-12-05 10:15:57','2025-12-05 10:15:57','2025-12-05 10:15:57',1,625,'a45ca136-3983-46c9-afe7-6d3fdbd11718',170,'ee708d36384c422aad0ff42f0242e9cf','snapshots',1,'2025-12-06 10:15:56',NULL),('2025-12-05 10:15:57','2025-12-05 10:15:57','2025-12-05 10:15:57',1,626,'ab3b905c-3f5d-419c-823e-8967b61d5a16',165,'ee708d36384c422aad0ff42f0242e9cf','gigabytes',1,'2025-12-06 10:15:56',NULL),('2025-12-05 10:15:57','2025-12-05 10:15:57','2025-12-05 10:15:57',1,627,'a7c1d663-4e89-41cd-9cf4-dcd5cd7197a1',167,'ee708d36384c422aad0ff42f0242e9cf','gigabytes_tripleo',1,'2025-12-06 10:15:56',NULL),('2025-12-05 10:15:57','2025-12-05 10:15:57','2025-12-05 10:15:57',1,628,'42f6947b-be66-4f04-a9bf-4649954e3633',171,'ee708d36384c422aad0ff42f0242e9cf','snapshots_tripleo',1,'2025-12-06 10:15:56',NULL),('2025-12-05 10:15:57','2025-12-05 10:15:58','2025-12-05 10:15:58',1,629,'d2637155-6351-4259-8559-027078ec85c2',160,'ebf51e9cd741494484f25cc0c15bc318','volumes',1,'2025-12-06 10:15:57',NULL),('2025-12-05 10:15:57','2025-12-05 10:15:58','2025-12-05 10:15:58',1,630,'e4f76ecd-b978-436e-9e58-46c17fabd511',162,'ebf51e9cd741494484f25cc0c15bc318','volumes_tempest-GroupSnapshotsTest-volume-type-742511643',1,'2025-12-06 10:15:57',NULL),('2025-12-05 10:15:58','2025-12-05 10:15:59','2025-12-05 10:15:59',1,631,'14e82185-300c-4a4f-b5b7-7660ed55ca22',170,'ee708d36384c422aad0ff42f0242e9cf','snapshots',1,'2025-12-06 10:15:58',NULL),('2025-12-05 10:15:58','2025-12-05 10:15:59','2025-12-05 10:15:59',1,632,'b27ee211-7fcf-41dd-8efa-a3d58ca01258',165,'ee708d36384c422aad0ff42f0242e9cf','gigabytes',1,'2025-12-06 10:15:58',NULL),('2025-12-05 10:15:58','2025-12-05 10:15:59','2025-12-05 10:15:59',1,633,'cd4993de-f05a-47b5-89c0-22154334b507',167,'ee708d36384c422aad0ff42f0242e9cf','gigabytes_tripleo',1,'2025-12-06 10:15:58',NULL),('2025-12-05 10:15:58','2025-12-05 10:15:59','2025-12-05 10:15:59',1,634,'22e14257-ac22-4105-8a88-5caf128bc938',171,'ee708d36384c422aad0ff42f0242e9cf','snapshots_tripleo',1,'2025-12-06 10:15:58',NULL),('2025-12-05 10:16:00','2025-12-05 10:16:00','2025-12-05 10:16:00',1,635,'424017f9-7cec-4dfe-b14f-ce66ccd1ca50',159,'ebf51e9cd741494484f25cc0c15bc318','groups',-1,'2025-12-06 10:16:00',NULL),('2025-12-05 10:16:00','2025-12-05 10:16:00','2025-12-05 10:16:00',1,636,'24341b21-992e-40ac-b709-cfe17aa9a299',160,'ebf51e9cd741494484f25cc0c15bc318','volumes',-1,'2025-12-06 10:16:00',NULL),('2025-12-05 10:16:00','2025-12-05 10:16:00','2025-12-05 10:16:00',1,637,'31c446fd-c676-4d5c-987b-317ab4a3df7a',161,'ebf51e9cd741494484f25cc0c15bc318','gigabytes',-1,'2025-12-06 10:16:00',NULL),('2025-12-05 10:16:00','2025-12-05 10:16:00','2025-12-05 10:16:00',1,638,'2cf08606-faef-4627-bca8-709d6e918f57',162,'ebf51e9cd741494484f25cc0c15bc318','volumes_tempest-GroupSnapshotsTest-volume-type-742511643',-1,'2025-12-06 10:16:00',NULL),('2025-12-05 10:16:00','2025-12-05 10:16:00','2025-12-05 10:16:00',1,639,'2259c3fa-b6e7-4304-9607-f26b12d045d8',163,'ebf51e9cd741494484f25cc0c15bc318','gigabytes_tempest-GroupSnapshotsTest-volume-type-742511643',-1,'2025-12-06 10:16:00',NULL),('2025-12-05 10:16:01','2025-12-05 10:16:01','2025-12-05 10:16:01',1,640,'691603f2-5f4f-4a89-9505-9e5b4c012aee',170,'ee708d36384c422aad0ff42f0242e9cf','snapshots',-1,'2025-12-06 10:16:01',NULL),('2025-12-05 10:16:01','2025-12-05 10:16:01','2025-12-05 10:16:01',1,641,'d353a78e-57a7-48cd-8d40-bb10f095b3c3',165,'ee708d36384c422aad0ff42f0242e9cf','gigabytes',-1,'2025-12-06 10:16:01',NULL),('2025-12-05 10:16:01','2025-12-05 10:16:01','2025-12-05 10:16:01',1,642,'7ae2c414-88fb-4c8d-b54a-75d9fb2b2032',167,'ee708d36384c422aad0ff42f0242e9cf','gigabytes_tripleo',-1,'2025-12-06 10:16:01',NULL),('2025-12-05 10:16:01','2025-12-05 10:16:01','2025-12-05 10:16:01',1,643,'5f04fbce-5811-4679-a850-958c3d3ac1b0',171,'ee708d36384c422aad0ff42f0242e9cf','snapshots_tripleo',-1,'2025-12-06 10:16:01',NULL),('2025-12-05 10:16:02','2025-12-05 10:16:02','2025-12-05 10:16:02',1,644,'3c433061-ac3a-4321-82dd-d0fbdbd281e7',170,'ee708d36384c422aad0ff42f0242e9cf','snapshots',1,'2025-12-06 10:16:02',NULL),('2025-12-05 10:16:02','2025-12-05 10:16:02','2025-12-05 10:16:02',1,645,'7a0ce508-6e74-4430-b408-384232ebec82',165,'ee708d36384c422aad0ff42f0242e9cf','gigabytes',1,'2025-12-06 10:16:02',NULL),('2025-12-05 10:16:02','2025-12-05 10:16:02','2025-12-05 10:16:02',1,646,'7e97808d-efeb-46a5-8fa8-41523a203684',167,'ee708d36384c422aad0ff42f0242e9cf','gigabytes_tripleo',1,'2025-12-06 10:16:02',NULL),('2025-12-05 10:16:02','2025-12-05 10:16:02','2025-12-05 10:16:02',1,647,'3f4375f3-5d32-4c7c-b7c6-e39e0b32803b',171,'ee708d36384c422aad0ff42f0242e9cf','snapshots_tripleo',1,'2025-12-06 10:16:02',NULL),('2025-12-05 10:16:02','2025-12-05 10:16:02','2025-12-05 10:16:02',1,648,'7678dea9-1ac3-4cc5-9328-972ba54eda80',168,'ebf51e9cd741494484f25cc0c15bc318','snapshots',-1,'2025-12-06 10:16:02',NULL),('2025-12-05 10:16:02','2025-12-05 10:16:02','2025-12-05 10:16:02',1,649,'4c971e85-97d2-41ca-ad6e-af9ee0cabca8',161,'ebf51e9cd741494484f25cc0c15bc318','gigabytes',-1,'2025-12-06 10:16:02',NULL),('2025-12-05 10:16:02','2025-12-05 10:16:02','2025-12-05 10:16:02',1,650,'e7ef3d63-c538-4ce7-bc41-ad9b6d1bf056',163,'ebf51e9cd741494484f25cc0c15bc318','gigabytes_tempest-GroupSnapshotsTest-volume-type-742511643',-1,'2025-12-06 10:16:02',NULL),('2025-12-05 10:16:02','2025-12-05 10:16:02','2025-12-05 10:16:02',1,651,'7330818c-d01b-4aac-9c9d-1f766ece0271',169,'ebf51e9cd741494484f25cc0c15bc318','snapshots_tempest-GroupSnapshotsTest-volume-type-742511643',-1,'2025-12-06 10:16:02',NULL),('2025-12-05 10:16:04','2025-12-05 10:16:04','2025-12-05 10:16:04',1,652,'dc545eea-38a1-4b32-9ac4-dcf7a1914820',159,'ebf51e9cd741494484f25cc0c15bc318','groups',-1,'2025-12-06 10:16:04',NULL),('2025-12-05 10:16:04','2025-12-05 10:16:04','2025-12-05 10:16:04',1,653,'91c7a557-fed7-4699-ac51-7b0283e0db8c',160,'ebf51e9cd741494484f25cc0c15bc318','volumes',-1,'2025-12-06 10:16:04',NULL),('2025-12-05 10:16:04','2025-12-05 10:16:04','2025-12-05 10:16:04',1,654,'c04fe8cd-42c7-44e9-840d-e1d660cd65bc',161,'ebf51e9cd741494484f25cc0c15bc318','gigabytes',-1,'2025-12-06 10:16:04',NULL),('2025-12-05 10:16:04','2025-12-05 10:16:04','2025-12-05 10:16:04',1,655,'5fd387e7-4ce9-4a90-b6e8-b1cbd9fa6415',162,'ebf51e9cd741494484f25cc0c15bc318','volumes_tempest-GroupSnapshotsTest-volume-type-742511643',-1,'2025-12-06 10:16:04',NULL),('2025-12-05 10:16:04','2025-12-05 10:16:04','2025-12-05 10:16:04',1,656,'760c6363-af4d-4364-bf71-d5e6f7ce5003',163,'ebf51e9cd741494484f25cc0c15bc318','gigabytes_tempest-GroupSnapshotsTest-volume-type-742511643',-1,'2025-12-06 10:16:04',NULL),('2025-12-05 10:16:05','2025-12-05 10:16:05','2025-12-05 10:16:05',1,657,'deff29d1-7220-4aa4-9c66-e9e9c7d25279',159,'ebf51e9cd741494484f25cc0c15bc318','groups',1,'2025-12-06 10:16:05',NULL),('2025-12-05 10:16:05','2025-12-05 10:16:05','2025-12-05 10:16:05',1,658,'f13e9733-ba12-4888-8d84-9b515ed6c7a1',170,'ee708d36384c422aad0ff42f0242e9cf','snapshots',-1,'2025-12-06 10:16:05',NULL),('2025-12-05 10:16:05','2025-12-05 10:16:05','2025-12-05 10:16:05',1,659,'4633c40b-0aaa-41d7-b727-567ca091605e',165,'ee708d36384c422aad0ff42f0242e9cf','gigabytes',-1,'2025-12-06 10:16:05',NULL),('2025-12-05 10:16:05','2025-12-05 10:16:05','2025-12-05 10:16:05',1,660,'cc99344f-2b46-4c7f-8730-1f9582d8084f',167,'ee708d36384c422aad0ff42f0242e9cf','gigabytes_tripleo',-1,'2025-12-06 10:16:05',NULL),('2025-12-05 10:16:05','2025-12-05 10:16:05','2025-12-05 10:16:05',1,661,'6e9cf358-2985-42d0-b2c6-03c195c24ed1',171,'ee708d36384c422aad0ff42f0242e9cf','snapshots_tripleo',-1,'2025-12-06 10:16:05',NULL),('2025-12-05 10:16:06','2025-12-05 10:16:06','2025-12-05 10:16:06',1,662,'1ee9865b-4954-4698-a537-f69c8a5a9513',170,'ee708d36384c422aad0ff42f0242e9cf','snapshots',1,'2025-12-06 10:16:06',NULL),('2025-12-05 10:16:06','2025-12-05 10:16:06','2025-12-05 10:16:06',1,663,'9f971f62-d616-4f64-a53b-eb9f537770a4',165,'ee708d36384c422aad0ff42f0242e9cf','gigabytes',1,'2025-12-06 10:16:06',NULL),('2025-12-05 10:16:06','2025-12-05 10:16:06','2025-12-05 10:16:06',1,664,'2e5b4688-9294-4916-bb9d-b6046f1f7aa7',167,'ee708d36384c422aad0ff42f0242e9cf','gigabytes_tripleo',1,'2025-12-06 10:16:06',NULL),('2025-12-05 10:16:06','2025-12-05 10:16:06','2025-12-05 10:16:06',1,665,'1d699457-89a5-4ace-b461-ba3c8643232e',171,'ee708d36384c422aad0ff42f0242e9cf','snapshots_tripleo',1,'2025-12-06 10:16:06',NULL),('2025-12-05 10:16:06','2025-12-05 10:16:06','2025-12-05 10:16:06',1,666,'8a430a37-83da-452c-be1d-6bff2baa8f6b',160,'ebf51e9cd741494484f25cc0c15bc318','volumes',1,'2025-12-06 10:16:06',NULL),('2025-12-05 10:16:06','2025-12-05 10:16:06','2025-12-05 10:16:06',1,667,'59d52613-6916-40d9-ac97-f1d82f1a6a45',161,'ebf51e9cd741494484f25cc0c15bc318','gigabytes',1,'2025-12-06 10:16:06',NULL),('2025-12-05 10:16:06','2025-12-05 10:16:06','2025-12-05 10:16:06',1,668,'7e8c7fec-6912-4929-bb81-aec8a4503bde',172,'ebf51e9cd741494484f25cc0c15bc318','volumes_tempest-GroupSnapshotsTest-volume-type-2140127089',1,'2025-12-06 10:16:06',NULL),('2025-12-05 10:16:06','2025-12-05 10:16:06','2025-12-05 10:16:06',1,669,'468038a6-1b62-4436-9612-e14e5e1d1d86',173,'ebf51e9cd741494484f25cc0c15bc318','gigabytes_tempest-GroupSnapshotsTest-volume-type-2140127089',1,'2025-12-06 10:16:06',NULL),('2025-12-05 10:16:07','2025-12-05 10:16:07','2025-12-05 10:16:07',1,670,'4510b68b-d166-421b-a8e9-b17b0fc1fc01',160,'ebf51e9cd741494484f25cc0c15bc318','volumes',1,'2025-12-06 10:16:07',NULL),('2025-12-05 10:16:07','2025-12-05 10:16:07','2025-12-05 10:16:07',1,671,'be394c70-d9dc-4dce-b926-5952c1f45f41',161,'ebf51e9cd741494484f25cc0c15bc318','gigabytes',1,'2025-12-06 10:16:07',NULL),('2025-12-05 10:16:07','2025-12-05 10:16:07','2025-12-05 10:16:07',1,672,'18d38ea5-9b93-4ec9-97cd-7fe2f1601837',172,'ebf51e9cd741494484f25cc0c15bc318','volumes_tempest-GroupSnapshotsTest-volume-type-2140127089',1,'2025-12-06 10:16:07',NULL),('2025-12-05 10:16:07','2025-12-05 10:16:07','2025-12-05 10:16:07',1,673,'82649854-66e6-4fec-8c23-b06798c8ab8d',173,'ebf51e9cd741494484f25cc0c15bc318','gigabytes_tempest-GroupSnapshotsTest-volume-type-2140127089',1,'2025-12-06 10:16:07',NULL),('2025-12-05 10:16:08','2025-12-05 10:16:09','2025-12-05 10:16:09',1,674,'4a9d2315-3ec4-4005-8f52-c3173f495b19',170,'ee708d36384c422aad0ff42f0242e9cf','snapshots',-1,'2025-12-06 10:16:08',NULL),('2025-12-05 10:16:08','2025-12-05 10:16:09','2025-12-05 10:16:09',1,675,'d866da9e-8dbf-4463-83eb-3fb99c03f031',165,'ee708d36384c422aad0ff42f0242e9cf','gigabytes',-1,'2025-12-06 10:16:08',NULL),('2025-12-05 10:16:08','2025-12-05 10:16:09','2025-12-05 10:16:09',1,676,'2ecba383-0d39-41ba-b7a9-b16031a61154',167,'ee708d36384c422aad0ff42f0242e9cf','gigabytes_tripleo',-1,'2025-12-06 10:16:08',NULL),('2025-12-05 10:16:08','2025-12-05 10:16:09','2025-12-05 10:16:09',1,677,'6571a238-fe64-4131-b0d3-890d867dc5f2',171,'ee708d36384c422aad0ff42f0242e9cf','snapshots_tripleo',-1,'2025-12-06 10:16:08',NULL),('2025-12-05 10:16:09','2025-12-05 10:16:09','2025-12-05 10:16:09',1,678,'d03eef34-a9d5-4633-ad55-47d6d57a2de3',170,'ee708d36384c422aad0ff42f0242e9cf','snapshots',1,'2025-12-06 10:16:09',NULL),('2025-12-05 10:16:09','2025-12-05 10:16:09','2025-12-05 10:16:09',1,679,'b1ac4066-8546-47f5-bda0-25c74afa8186',165,'ee708d36384c422aad0ff42f0242e9cf','gigabytes',1,'2025-12-06 10:16:09',NULL),('2025-12-05 10:16:09','2025-12-05 10:16:09','2025-12-05 10:16:09',1,680,'e85fcbab-d26e-44d2-b39b-5e0a60aacd93',167,'ee708d36384c422aad0ff42f0242e9cf','gigabytes_tripleo',1,'2025-12-06 10:16:09',NULL),('2025-12-05 10:16:09','2025-12-05 10:16:09','2025-12-05 10:16:09',1,681,'66268472-e32b-4e84-b0fe-d786bbcf3375',171,'ee708d36384c422aad0ff42f0242e9cf','snapshots_tripleo',1,'2025-12-06 10:16:09',NULL),('2025-12-05 10:16:12','2025-12-05 10:16:13','2025-12-05 10:16:13',1,682,'1adc14de-ec1b-4059-aeaa-226f7c04d90e',170,'ee708d36384c422aad0ff42f0242e9cf','snapshots',-1,'2025-12-06 10:16:12',NULL),('2025-12-05 10:16:12','2025-12-05 10:16:13','2025-12-05 10:16:13',1,683,'e0bdb283-a197-4319-98e3-31ebb3f275da',165,'ee708d36384c422aad0ff42f0242e9cf','gigabytes',-1,'2025-12-06 10:16:12',NULL),('2025-12-05 10:16:12','2025-12-05 10:16:13','2025-12-05 10:16:13',1,684,'8e071bb4-4e21-4944-8a9b-5d081cd5fb8d',167,'ee708d36384c422aad0ff42f0242e9cf','gigabytes_tripleo',-1,'2025-12-06 10:16:12',NULL),('2025-12-05 10:16:12','2025-12-05 10:16:13','2025-12-05 10:16:13',1,685,'f7da1d15-c151-4b80-b91b-f03545507231',171,'ee708d36384c422aad0ff42f0242e9cf','snapshots_tripleo',-1,'2025-12-06 10:16:12',NULL),('2025-12-05 10:16:14','2025-12-05 10:16:14','2025-12-05 10:16:14',1,686,'93425767-2864-4ad3-aa55-4c83ca04d801',170,'ee708d36384c422aad0ff42f0242e9cf','snapshots',-1,'2025-12-06 10:16:13',NULL),('2025-12-05 10:16:14','2025-12-05 10:16:14','2025-12-05 10:16:14',1,687,'11aedf5a-589b-4765-b4bc-ac761f52a0fa',165,'ee708d36384c422aad0ff42f0242e9cf','gigabytes',-1,'2025-12-06 10:16:13',NULL),('2025-12-05 10:16:14','2025-12-05 10:16:14','2025-12-05 10:16:14',1,688,'ad93b4d6-50c1-4c0a-b590-a19e8bbe7423',167,'ee708d36384c422aad0ff42f0242e9cf','gigabytes_tripleo',-1,'2025-12-06 10:16:13',NULL),('2025-12-05 10:16:14','2025-12-05 10:16:14','2025-12-05 10:16:14',1,689,'500ad5f5-9929-47e4-81a2-5f70c080eefe',171,'ee708d36384c422aad0ff42f0242e9cf','snapshots_tripleo',-1,'2025-12-06 10:16:13',NULL),('2025-12-05 10:16:14','2025-12-05 10:16:14','2025-12-05 10:16:14',1,690,'0003dd07-806e-4dd6-b88b-84b7e3192007',168,'ebf51e9cd741494484f25cc0c15bc318','snapshots',2,'2025-12-06 10:16:14',NULL),('2025-12-05 10:16:14','2025-12-05 10:16:14','2025-12-05 10:16:14',1,691,'eb76b10e-d36d-496c-9702-ba6abab9fab4',161,'ebf51e9cd741494484f25cc0c15bc318','gigabytes',2,'2025-12-06 10:16:14',NULL),('2025-12-05 10:16:14','2025-12-05 10:16:14','2025-12-05 10:16:14',1,692,'9cb0986c-b456-4e27-9f0a-64a22bc07ada',173,'ebf51e9cd741494484f25cc0c15bc318','gigabytes_tempest-GroupSnapshotsTest-volume-type-2140127089',2,'2025-12-06 10:16:14',NULL),('2025-12-05 10:16:14','2025-12-05 10:16:14','2025-12-05 10:16:14',1,693,'458d951c-e382-411b-8311-821ed5e57dc1',174,'ebf51e9cd741494484f25cc0c15bc318','snapshots_tempest-GroupSnapshotsTest-volume-type-2140127089',2,'2025-12-06 10:16:14',NULL),('2025-12-05 10:16:14','2025-12-05 10:16:15','2025-12-05 10:16:15',1,694,'9cd21fc3-fe1e-4eaa-b111-c6784cb364b2',164,'ee708d36384c422aad0ff42f0242e9cf','volumes',-1,'2025-12-06 10:16:14',NULL),('2025-12-05 10:16:14','2025-12-05 10:16:15','2025-12-05 10:16:15',1,695,'3f1c48e0-c05f-4d6f-9c24-bf9b28c7cb18',165,'ee708d36384c422aad0ff42f0242e9cf','gigabytes',-1,'2025-12-06 10:16:14',NULL),('2025-12-05 10:16:14','2025-12-05 10:16:15','2025-12-05 10:16:15',1,696,'c8b29c5e-d41a-45a5-bed5-e7451d071310',166,'ee708d36384c422aad0ff42f0242e9cf','volumes_tripleo',-1,'2025-12-06 10:16:14',NULL),('2025-12-05 10:16:14','2025-12-05 10:16:15','2025-12-05 10:16:15',1,697,'5b7f3822-164f-4224-a484-d1564f29fb07',167,'ee708d36384c422aad0ff42f0242e9cf','gigabytes_tripleo',-1,'2025-12-06 10:16:14',NULL),('2025-12-05 10:16:18','2025-12-05 10:16:18','2025-12-05 10:16:18',1,698,'fd5a0023-3055-42cd-a485-065ae594d544',168,'ebf51e9cd741494484f25cc0c15bc318','snapshots',-1,'2025-12-06 10:16:18',NULL),('2025-12-05 10:16:18','2025-12-05 10:16:18','2025-12-05 10:16:18',1,699,'193e4666-47cf-4ce8-8430-4821acd27137',161,'ebf51e9cd741494484f25cc0c15bc318','gigabytes',-1,'2025-12-06 10:16:18',NULL),('2025-12-05 10:16:18','2025-12-05 10:16:18','2025-12-05 10:16:18',1,700,'bcff8139-adfc-4c33-b755-71d3bc04cd24',173,'ebf51e9cd741494484f25cc0c15bc318','gigabytes_tempest-GroupSnapshotsTest-volume-type-2140127089',-1,'2025-12-06 10:16:18',NULL),('2025-12-05 10:16:18','2025-12-05 10:16:18','2025-12-05 10:16:18',1,701,'d10b9672-382b-4139-ab89-8dff9c1f53fc',174,'ebf51e9cd741494484f25cc0c15bc318','snapshots_tempest-GroupSnapshotsTest-volume-type-2140127089',-1,'2025-12-06 10:16:18',NULL),('2025-12-05 10:16:18','2025-12-05 10:16:18','2025-12-05 10:16:18',1,702,'5f20a3ed-6cb9-4e62-b79c-2c8870a8b0a5',168,'ebf51e9cd741494484f25cc0c15bc318','snapshots',-1,'2025-12-06 10:16:18',NULL),('2025-12-05 10:16:18','2025-12-05 10:16:18','2025-12-05 10:16:18',1,703,'3b3d9d17-1675-4b36-bca0-45f5a6002cc3',161,'ebf51e9cd741494484f25cc0c15bc318','gigabytes',-1,'2025-12-06 10:16:18',NULL),('2025-12-05 10:16:18','2025-12-05 10:16:18','2025-12-05 10:16:18',1,704,'f2d8d089-cba9-45e2-92a0-80aedffc02a7',173,'ebf51e9cd741494484f25cc0c15bc318','gigabytes_tempest-GroupSnapshotsTest-volume-type-2140127089',-1,'2025-12-06 10:16:18',NULL),('2025-12-05 10:16:18','2025-12-05 10:16:18','2025-12-05 10:16:18',1,705,'74a8ba35-5ecc-4e5f-b718-c1f14b05585b',174,'ebf51e9cd741494484f25cc0c15bc318','snapshots_tempest-GroupSnapshotsTest-volume-type-2140127089',-1,'2025-12-06 10:16:18',NULL),('2025-12-05 10:16:19','2025-12-05 10:16:19','2025-12-05 10:16:19',1,706,'48e15cb4-d29e-45cb-8fd8-60db099568b2',159,'ebf51e9cd741494484f25cc0c15bc318','groups',-1,'2025-12-06 10:16:19',NULL),('2025-12-05 10:16:19','2025-12-05 10:16:19','2025-12-05 10:16:19',1,707,'88291c56-9440-45cb-b73a-94cb2aeb8257',160,'ebf51e9cd741494484f25cc0c15bc318','volumes',-1,'2025-12-06 10:16:19',NULL),('2025-12-05 10:16:19','2025-12-05 10:16:19','2025-12-05 10:16:19',1,708,'19dbf34e-b92c-40a9-9ee5-621e18d42359',161,'ebf51e9cd741494484f25cc0c15bc318','gigabytes',-1,'2025-12-06 10:16:19',NULL),('2025-12-05 10:16:19','2025-12-05 10:16:19','2025-12-05 10:16:19',1,709,'2cbf1d8c-a480-41be-b7bc-d4d0e8a903cd',172,'ebf51e9cd741494484f25cc0c15bc318','volumes_tempest-GroupSnapshotsTest-volume-type-2140127089',-1,'2025-12-06 10:16:19',NULL),('2025-12-05 10:16:19','2025-12-05 10:16:19','2025-12-05 10:16:19',1,710,'7ac9956c-adf1-40c7-855f-a3cb0c7829b0',173,'ebf51e9cd741494484f25cc0c15bc318','gigabytes_tempest-GroupSnapshotsTest-volume-type-2140127089',-1,'2025-12-06 10:16:19',NULL),('2025-12-05 10:16:19','2025-12-05 10:16:19','2025-12-05 10:16:19',1,711,'a78c5dec-5ac9-4987-b90d-076b1a247452',160,'ebf51e9cd741494484f25cc0c15bc318','volumes',-1,'2025-12-06 10:16:19',NULL),('2025-12-05 10:16:19','2025-12-05 10:16:19','2025-12-05 10:16:19',1,712,'5f67ac1c-c058-450a-8d0b-fe000641a747',161,'ebf51e9cd741494484f25cc0c15bc318','gigabytes',-1,'2025-12-06 10:16:19',NULL),('2025-12-05 10:16:19','2025-12-05 10:16:19','2025-12-05 10:16:19',1,713,'da80d269-1de0-4c6c-904d-728b846e2c9d',172,'ebf51e9cd741494484f25cc0c15bc318','volumes_tempest-GroupSnapshotsTest-volume-type-2140127089',-1,'2025-12-06 10:16:19',NULL),('2025-12-05 10:16:19','2025-12-05 10:16:19','2025-12-05 10:16:19',1,714,'70f1ecac-1006-4444-ac59-e8d4770028fe',173,'ebf51e9cd741494484f25cc0c15bc318','gigabytes_tempest-GroupSnapshotsTest-volume-type-2140127089',-1,'2025-12-06 10:16:19',NULL),('2025-12-05 10:16:20','2025-12-05 10:16:20','2025-12-05 10:16:20',1,715,'80a827d5-15e3-42eb-80fd-778b6be88cd2',175,'86adc92ecf4e492cbe37cc410ae29e2f','volumes',1,'2025-12-06 10:16:20',NULL),('2025-12-05 10:16:20','2025-12-05 10:16:20','2025-12-05 10:16:20',1,716,'f333e0e4-6cde-4909-9567-3162013d6a25',176,'86adc92ecf4e492cbe37cc410ae29e2f','gigabytes',1,'2025-12-06 10:16:20',NULL),('2025-12-05 10:16:20','2025-12-05 10:16:20','2025-12-05 10:16:20',1,717,'a9cd1c98-a319-4feb-bb2b-7af446611527',177,'86adc92ecf4e492cbe37cc410ae29e2f','volumes_volume-type-1',1,'2025-12-06 10:16:20',NULL),('2025-12-05 10:16:20','2025-12-05 10:16:20','2025-12-05 10:16:20',1,718,'4e097b9b-a62a-41b1-a8fc-a67cee98d7e6',178,'86adc92ecf4e492cbe37cc410ae29e2f','gigabytes_volume-type-1',1,'2025-12-06 10:16:20',NULL),('2025-12-05 10:16:20','2025-12-05 10:16:20','2025-12-05 10:16:20',1,719,'6478dc3a-9ed9-41e5-9a7d-8788167b569a',159,'ebf51e9cd741494484f25cc0c15bc318','groups',1,'2025-12-06 10:16:20',NULL),('2025-12-05 10:16:21','2025-12-05 10:16:21','2025-12-05 10:16:21',1,720,'d56e71e6-4378-404e-8c2e-6904d6532ace',179,'86adc92ecf4e492cbe37cc410ae29e2f','volumes_volume-type-2',1,'2025-12-06 10:16:21',NULL),('2025-12-05 10:16:21','2025-12-05 10:16:21','2025-12-05 10:16:21',1,721,'c1aa1ed9-1b97-418c-9659-9e7c20ed9e62',180,'86adc92ecf4e492cbe37cc410ae29e2f','gigabytes_volume-type-2',1,'2025-12-06 10:16:21',NULL),('2025-12-05 10:16:21','2025-12-05 10:16:21','2025-12-05 10:16:21',1,722,'b6691fc1-687c-4032-b78f-146da056853d',177,'86adc92ecf4e492cbe37cc410ae29e2f','volumes_volume-type-1',-1,'2025-12-06 10:16:21',NULL),('2025-12-05 10:16:21','2025-12-05 10:16:21','2025-12-05 10:16:21',1,723,'96453336-360c-40bf-8cdd-298f6c178f06',178,'86adc92ecf4e492cbe37cc410ae29e2f','gigabytes_volume-type-1',-1,'2025-12-06 10:16:21',NULL),('2025-12-05 10:16:21','2025-12-05 10:16:21','2025-12-05 10:16:21',1,724,'2fe810ed-6062-4d3f-a469-ff216a0e82b9',160,'ebf51e9cd741494484f25cc0c15bc318','volumes',1,'2025-12-06 10:16:21',NULL),('2025-12-05 10:16:21','2025-12-05 10:16:21','2025-12-05 10:16:21',1,725,'a6e21a69-2e56-446b-bad1-e1ab9be4719d',161,'ebf51e9cd741494484f25cc0c15bc318','gigabytes',1,'2025-12-06 10:16:21',NULL),('2025-12-05 10:16:21','2025-12-05 10:16:21','2025-12-05 10:16:21',1,726,'5d82f2f1-f117-416f-be25-73d06ebd96c7',181,'ebf51e9cd741494484f25cc0c15bc318','volumes_tempest-GroupSnapshotsTest-volume-type-1934963370',1,'2025-12-06 10:16:21',NULL),('2025-12-05 10:16:21','2025-12-05 10:16:21','2025-12-05 10:16:21',1,727,'fe9e21ae-6a4d-427e-bcb0-535434c54046',182,'ebf51e9cd741494484f25cc0c15bc318','gigabytes_tempest-GroupSnapshotsTest-volume-type-1934963370',1,'2025-12-06 10:16:21',NULL),('2025-12-05 10:16:22','2025-12-05 10:16:22','2025-12-05 10:16:22',1,728,'00e1366d-59fe-4742-8c09-4cb8043af71c',168,'ebf51e9cd741494484f25cc0c15bc318','snapshots',1,'2025-12-06 10:16:22',NULL),('2025-12-05 10:16:22','2025-12-05 10:16:22','2025-12-05 10:16:22',1,729,'693fe12e-8a06-4145-9d60-527845e4f6c3',161,'ebf51e9cd741494484f25cc0c15bc318','gigabytes',1,'2025-12-06 10:16:22',NULL),('2025-12-05 10:16:22','2025-12-05 10:16:22','2025-12-05 10:16:22',1,730,'bb4fd893-2c8c-4dc7-ac87-c1403734a916',182,'ebf51e9cd741494484f25cc0c15bc318','gigabytes_tempest-GroupSnapshotsTest-volume-type-1934963370',1,'2025-12-06 10:16:22',NULL),('2025-12-05 10:16:22','2025-12-05 10:16:22','2025-12-05 10:16:22',1,731,'6296a949-f2a7-4639-a2cf-792cbedb1c2c',183,'ebf51e9cd741494484f25cc0c15bc318','snapshots_tempest-GroupSnapshotsTest-volume-type-1934963370',1,'2025-12-06 10:16:22',NULL),('2025-12-05 10:16:23','2025-12-05 10:16:23','2025-12-05 10:16:23',1,732,'adf8690d-77b3-479a-bf2a-f94cfd7e2baf',175,'86adc92ecf4e492cbe37cc410ae29e2f','volumes',-1,'2025-12-06 10:16:23',NULL),('2025-12-05 10:16:23','2025-12-05 10:16:23','2025-12-05 10:16:23',1,733,'2f5cb18d-8f96-4e1e-ad01-2d079e9ebe54',176,'86adc92ecf4e492cbe37cc410ae29e2f','gigabytes',-1,'2025-12-06 10:16:23',NULL),('2025-12-05 10:16:23','2025-12-05 10:16:23','2025-12-05 10:16:23',1,734,'2b55d548-c484-4c27-bb6a-598031e5122d',179,'86adc92ecf4e492cbe37cc410ae29e2f','volumes_volume-type-2',-1,'2025-12-06 10:16:23',NULL),('2025-12-05 10:16:23','2025-12-05 10:16:23','2025-12-05 10:16:23',1,735,'6fe8115e-3596-426c-bc48-267fef034acd',180,'86adc92ecf4e492cbe37cc410ae29e2f','gigabytes_volume-type-2',-1,'2025-12-06 10:16:23',NULL),('2025-12-05 10:16:25','2025-12-05 10:16:25','2025-12-05 10:16:25',1,736,'15270fe4-fd72-4499-8acd-28cbbbe428b9',168,'ebf51e9cd741494484f25cc0c15bc318','snapshots',-1,'2025-12-06 10:16:25',NULL),('2025-12-05 10:16:25','2025-12-05 10:16:25','2025-12-05 10:16:25',1,737,'e412aef3-23f6-47e2-a19f-5024a1df44da',161,'ebf51e9cd741494484f25cc0c15bc318','gigabytes',-1,'2025-12-06 10:16:25',NULL),('2025-12-05 10:16:25','2025-12-05 10:16:25','2025-12-05 10:16:25',1,738,'151eaed9-a4a4-48d4-8219-625c0ee86f0f',182,'ebf51e9cd741494484f25cc0c15bc318','gigabytes_tempest-GroupSnapshotsTest-volume-type-1934963370',-1,'2025-12-06 10:16:25',NULL),('2025-12-05 10:16:25','2025-12-05 10:16:25','2025-12-05 10:16:25',1,739,'1f22e122-7a3e-4dcf-a800-4a52e22353ad',183,'ebf51e9cd741494484f25cc0c15bc318','snapshots_tempest-GroupSnapshotsTest-volume-type-1934963370',-1,'2025-12-06 10:16:25',NULL),('2025-12-05 10:16:27','2025-12-05 10:16:27','2025-12-05 10:16:27',1,740,'56d4dcc1-3035-448a-b88c-e98ac034f4a2',159,'ebf51e9cd741494484f25cc0c15bc318','groups',-1,'2025-12-06 10:16:27',NULL),('2025-12-05 10:16:27','2025-12-05 10:16:27','2025-12-05 10:16:27',1,741,'23d1fada-0083-4f1d-a732-2eea988e74d6',160,'ebf51e9cd741494484f25cc0c15bc318','volumes',-1,'2025-12-06 10:16:27',NULL),('2025-12-05 10:16:27','2025-12-05 10:16:27','2025-12-05 10:16:27',1,742,'c33723a1-a870-4bb6-a69c-a8c41f0a9bdd',161,'ebf51e9cd741494484f25cc0c15bc318','gigabytes',-1,'2025-12-06 10:16:27',NULL),('2025-12-05 10:16:27','2025-12-05 10:16:27','2025-12-05 10:16:27',1,743,'97ef1af7-d692-43bc-bc3a-83762986243d',181,'ebf51e9cd741494484f25cc0c15bc318','volumes_tempest-GroupSnapshotsTest-volume-type-1934963370',-1,'2025-12-06 10:16:27',NULL),('2025-12-05 10:16:27','2025-12-05 10:16:27','2025-12-05 10:16:27',1,744,'c75a6537-ff06-4363-a266-f8f0bd2c3c2e',182,'ebf51e9cd741494484f25cc0c15bc318','gigabytes_tempest-GroupSnapshotsTest-volume-type-1934963370',-1,'2025-12-06 10:16:27',NULL),('2025-12-05 10:16:30','2025-12-05 10:16:30','2025-12-05 10:16:30',1,745,'5a112e4f-c515-417a-b186-628ef7432a94',184,'ca51bf8141824cad9d5dcaf468d3909b','volumes',1,'2025-12-06 10:16:30',NULL),('2025-12-05 10:16:30','2025-12-05 10:16:30','2025-12-05 10:16:30',1,746,'e8d83a57-8eb0-49fc-9675-f6a5355afb54',185,'ca51bf8141824cad9d5dcaf468d3909b','gigabytes',1,'2025-12-06 10:16:30',NULL),('2025-12-05 10:16:30','2025-12-05 10:16:30','2025-12-05 10:16:30',1,747,'5d645c18-6b2d-4cce-848a-4d81fb916228',186,'ca51bf8141824cad9d5dcaf468d3909b','volumes_tripleo',1,'2025-12-06 10:16:30',NULL),('2025-12-05 10:16:30','2025-12-05 10:16:30','2025-12-05 10:16:30',1,748,'968c820d-693a-429a-b699-16d60d84e905',187,'ca51bf8141824cad9d5dcaf468d3909b','gigabytes_tripleo',1,'2025-12-06 10:16:30',NULL),('2025-12-05 10:16:31','2025-12-05 10:16:31','2025-12-05 10:16:31',1,749,'3dc14792-06c2-4a7e-81ea-d5ac5d98ba90',184,'ca51bf8141824cad9d5dcaf468d3909b','volumes',-1,'2025-12-06 10:16:31',NULL),('2025-12-05 10:16:31','2025-12-05 10:16:31','2025-12-05 10:16:31',1,750,'9e7a3f0e-9487-460a-bfff-fe3b0a742fdf',185,'ca51bf8141824cad9d5dcaf468d3909b','gigabytes',-1,'2025-12-06 10:16:31',NULL),('2025-12-05 10:16:31','2025-12-05 10:16:31','2025-12-05 10:16:31',1,751,'f34e8efd-5294-4ab7-aa58-92e2aae220eb',186,'ca51bf8141824cad9d5dcaf468d3909b','volumes_tripleo',-1,'2025-12-06 10:16:31',NULL),('2025-12-05 10:16:31','2025-12-05 10:16:31','2025-12-05 10:16:31',1,752,'68c36efe-6996-4b50-9c62-6f0ecd2322be',187,'ca51bf8141824cad9d5dcaf468d3909b','gigabytes_tripleo',-1,'2025-12-06 10:16:31',NULL),('2025-12-05 10:16:34','2025-12-05 10:16:34','2025-12-05 10:16:34',1,753,'40ab8037-ca97-4165-8a10-3b9a3e7c2ca2',188,'86ef6c5dc1f040a8b67b31bc6f6dc5dd','volumes',1,'2025-12-06 10:16:34',NULL),('2025-12-05 10:16:34','2025-12-05 10:16:34','2025-12-05 10:16:34',1,754,'9bcdfab3-c404-4f9d-bff9-e8b5ff739498',189,'86ef6c5dc1f040a8b67b31bc6f6dc5dd','gigabytes',1,'2025-12-06 10:16:34',NULL),('2025-12-05 10:16:34','2025-12-05 10:16:34','2025-12-05 10:16:34',1,755,'4e83a9be-6ed0-476f-bdd0-3d0aada8eca6',190,'86ef6c5dc1f040a8b67b31bc6f6dc5dd','volumes_tempest-VolumeTypesAccessTest-volume-type-1193441138',1,'2025-12-06 10:16:34',NULL),('2025-12-05 10:16:34','2025-12-05 10:16:34','2025-12-05 10:16:34',1,756,'3f0da333-6b28-41cb-81b7-7259dcb7134f',191,'86ef6c5dc1f040a8b67b31bc6f6dc5dd','gigabytes_tempest-VolumeTypesAccessTest-volume-type-1193441138',1,'2025-12-06 10:16:34',NULL),('2025-12-05 10:16:36','2025-12-05 10:16:36','2025-12-05 10:16:36',1,757,'29a526e4-8ca2-403c-8d3a-93d36f8b3623',188,'86ef6c5dc1f040a8b67b31bc6f6dc5dd','volumes',-1,'2025-12-06 10:16:36',NULL),('2025-12-05 10:16:36','2025-12-05 10:16:36','2025-12-05 10:16:36',1,758,'251a8a91-8743-4a2f-a51c-69fa7920717f',189,'86ef6c5dc1f040a8b67b31bc6f6dc5dd','gigabytes',-1,'2025-12-06 10:16:36',NULL),('2025-12-05 10:16:36','2025-12-05 10:16:36','2025-12-05 10:16:36',1,759,'55a74cfb-ab5e-4553-b00d-5adaf843ea98',190,'86ef6c5dc1f040a8b67b31bc6f6dc5dd','volumes_tempest-VolumeTypesAccessTest-volume-type-1193441138',-1,'2025-12-06 10:16:36',NULL),('2025-12-05 10:16:36','2025-12-05 10:16:36','2025-12-05 10:16:36',1,760,'09216a35-d0f7-44a5-8de6-60bd220b5206',191,'86ef6c5dc1f040a8b67b31bc6f6dc5dd','gigabytes_tempest-VolumeTypesAccessTest-volume-type-1193441138',-1,'2025-12-06 10:16:36',NULL),('2025-12-05 10:16:45','2025-12-05 10:16:45','2025-12-05 10:16:45',1,761,'99cce07f-8696-4527-a99c-5e1119332e2f',192,'b0b002e8666a4d4c8dd3481cd357bc82','volumes',1,'2025-12-06 10:16:45',NULL),('2025-12-05 10:16:45','2025-12-05 10:16:45','2025-12-05 10:16:45',1,762,'b3c32c15-2f21-4aaf-8f71-3fb0b5fca9ff',193,'b0b002e8666a4d4c8dd3481cd357bc82','gigabytes',1,'2025-12-06 10:16:45',NULL),('2025-12-05 10:16:45','2025-12-05 10:16:45','2025-12-05 10:16:45',1,763,'019d8566-5601-4b2f-b9fa-bc034f978866',194,'b0b002e8666a4d4c8dd3481cd357bc82','volumes_tripleo',1,'2025-12-06 10:16:45',NULL),('2025-12-05 10:16:45','2025-12-05 10:16:45','2025-12-05 10:16:45',1,764,'e9d66205-ca26-4d64-a882-33c2a9e8c21c',195,'b0b002e8666a4d4c8dd3481cd357bc82','gigabytes_tripleo',1,'2025-12-06 10:16:45',NULL),('2025-12-05 10:16:46','2025-12-05 10:16:46','2025-12-05 10:16:46',1,765,'7ec1269e-a5b6-4b66-8fa8-c967e8c10f45',196,'b0b002e8666a4d4c8dd3481cd357bc82','snapshots',1,'2025-12-06 10:16:46',NULL),('2025-12-05 10:16:46','2025-12-05 10:16:46','2025-12-05 10:16:46',1,766,'87893ade-a840-4623-b079-5299832a8f45',193,'b0b002e8666a4d4c8dd3481cd357bc82','gigabytes',1,'2025-12-06 10:16:46',NULL),('2025-12-05 10:16:46','2025-12-05 10:16:46','2025-12-05 10:16:46',1,767,'8266373c-f881-4aa9-abf4-c716229826eb',195,'b0b002e8666a4d4c8dd3481cd357bc82','gigabytes_tripleo',1,'2025-12-06 10:16:46',NULL),('2025-12-05 10:16:46','2025-12-05 10:16:46','2025-12-05 10:16:46',1,768,'a9791007-176d-4e80-81de-f40bd7a7a977',197,'b0b002e8666a4d4c8dd3481cd357bc82','snapshots_tripleo',1,'2025-12-06 10:16:46',NULL),('2025-12-05 10:16:49','2025-12-05 10:16:49','2025-12-05 10:16:49',1,769,'d7ea2ec2-5acd-4c73-925b-5a6618579388',196,'b0b002e8666a4d4c8dd3481cd357bc82','snapshots',-1,'2025-12-06 10:16:49',NULL),('2025-12-05 10:16:49','2025-12-05 10:16:49','2025-12-05 10:16:49',1,770,'38b77056-6b00-4780-8c5a-45d93fa7180f',193,'b0b002e8666a4d4c8dd3481cd357bc82','gigabytes',-1,'2025-12-06 10:16:49',NULL),('2025-12-05 10:16:49','2025-12-05 10:16:49','2025-12-05 10:16:49',1,771,'c4c79894-616b-406e-90df-da249dd14c44',195,'b0b002e8666a4d4c8dd3481cd357bc82','gigabytes_tripleo',-1,'2025-12-06 10:16:49',NULL),('2025-12-05 10:16:49','2025-12-05 10:16:49','2025-12-05 10:16:49',1,772,'472c3af0-b4c3-4f92-8556-64dec69e1229',197,'b0b002e8666a4d4c8dd3481cd357bc82','snapshots_tripleo',-1,'2025-12-06 10:16:49',NULL),('2025-12-05 10:16:50','2025-12-05 10:16:50','2025-12-05 10:16:50',1,773,'cf277a47-439b-45f3-b98c-26d5dce8cc4d',192,'b0b002e8666a4d4c8dd3481cd357bc82','volumes',-1,'2025-12-06 10:16:50',NULL),('2025-12-05 10:16:50','2025-12-05 10:16:50','2025-12-05 10:16:50',1,774,'cabe0afa-7653-4a02-af84-fccb5545449c',193,'b0b002e8666a4d4c8dd3481cd357bc82','gigabytes',-1,'2025-12-06 10:16:50',NULL),('2025-12-05 10:16:50','2025-12-05 10:16:50','2025-12-05 10:16:50',1,775,'b677dc52-6af0-4b65-afbc-17d64356475a',194,'b0b002e8666a4d4c8dd3481cd357bc82','volumes_tripleo',-1,'2025-12-06 10:16:50',NULL),('2025-12-05 10:16:50','2025-12-05 10:16:50','2025-12-05 10:16:50',1,776,'81e3493f-b902-432b-a29e-29dc31e7860f',195,'b0b002e8666a4d4c8dd3481cd357bc82','gigabytes_tripleo',-1,'2025-12-06 10:16:50',NULL),('2025-12-05 10:16:54','2025-12-05 10:16:54','2025-12-05 10:16:54',1,777,'490998f5-ce15-4565-91aa-a0ee710ef15b',198,'3554a89b305c449f9fd292eca5647512','volumes',1,'2025-12-06 10:16:53',NULL),('2025-12-05 10:16:54','2025-12-05 10:16:54','2025-12-05 10:16:54',1,778,'7e759ca2-1d3b-4f2e-a168-4b32e0c9369a',199,'3554a89b305c449f9fd292eca5647512','gigabytes',1,'2025-12-06 10:16:53',NULL),('2025-12-05 10:16:54','2025-12-05 10:16:54','2025-12-05 10:16:54',1,779,'c6421bba-c0c0-4846-ab9f-141dd39eaa2d',200,'3554a89b305c449f9fd292eca5647512','volumes_tripleo',1,'2025-12-06 10:16:53',NULL),('2025-12-05 10:16:54','2025-12-05 10:16:54','2025-12-05 10:16:54',1,780,'d18e3e91-97a0-4704-bbdd-91b77a1c1cc9',201,'3554a89b305c449f9fd292eca5647512','gigabytes_tripleo',1,'2025-12-06 10:16:53',NULL),('2025-12-05 10:16:57','2025-12-05 10:16:57','2025-12-05 10:16:57',1,781,'23f7d03c-8e23-45db-bc9a-bcdee8b7f9d2',202,'d088e308e3994594b72dd5ba899ec7e3','volumes',1,'2025-12-06 10:16:57',NULL),('2025-12-05 10:16:57','2025-12-05 10:16:57','2025-12-05 10:16:57',1,782,'1ce4d26e-f38d-4be5-9e47-1a29bb3b1c37',203,'d088e308e3994594b72dd5ba899ec7e3','gigabytes',1,'2025-12-06 10:16:57',NULL),('2025-12-05 10:16:57','2025-12-05 10:16:57','2025-12-05 10:16:57',1,783,'053460f0-905d-4432-b44a-e97b43665c9f',204,'d088e308e3994594b72dd5ba899ec7e3','volumes_tripleo',1,'2025-12-06 10:16:57',NULL),('2025-12-05 10:16:57','2025-12-05 10:16:57','2025-12-05 10:16:57',1,784,'e5f71abd-5cb4-41ac-bc12-96c9d0f3a7ad',205,'d088e308e3994594b72dd5ba899ec7e3','gigabytes_tripleo',1,'2025-12-06 10:16:57',NULL),('2025-12-05 10:16:58','2025-12-05 10:16:59','2025-12-05 10:16:59',1,785,'1bcfaf49-de98-4517-885a-6adca23ee683',206,'5e9a7e52b379438eab65d860aa70af42','volumes',1,'2025-12-06 10:16:58',NULL),('2025-12-05 10:16:58','2025-12-05 10:16:59','2025-12-05 10:16:59',1,786,'41c0d822-7de6-4822-ace4-96b96ae5085a',207,'5e9a7e52b379438eab65d860aa70af42','gigabytes',1,'2025-12-06 10:16:58',NULL),('2025-12-05 10:16:58','2025-12-05 10:16:59','2025-12-05 10:16:59',1,787,'8dcfb619-c99f-4d63-8acf-eab921ef99d0',208,'5e9a7e52b379438eab65d860aa70af42','volumes_tripleo',1,'2025-12-06 10:16:58',NULL),('2025-12-05 10:16:58','2025-12-05 10:16:59','2025-12-05 10:16:59',1,788,'0e8b16b9-5a88-4cfd-838f-98f24d2a87fd',209,'5e9a7e52b379438eab65d860aa70af42','gigabytes_tripleo',1,'2025-12-06 10:16:58',NULL),('2025-12-05 10:16:58','2025-12-05 10:16:59','2025-12-05 10:16:59',1,789,'21753f6e-a424-47e7-b492-cf784a70ec6f',202,'d088e308e3994594b72dd5ba899ec7e3','volumes',-1,'2025-12-06 10:16:58',NULL),('2025-12-05 10:16:58','2025-12-05 10:16:59','2025-12-05 10:16:59',1,790,'68e88237-8664-4bc7-aa6a-91b5a340638f',203,'d088e308e3994594b72dd5ba899ec7e3','gigabytes',-1,'2025-12-06 10:16:58',NULL),('2025-12-05 10:16:58','2025-12-05 10:16:59','2025-12-05 10:16:59',1,791,'990ac1d4-892a-489f-a87a-0a36bb65a701',204,'d088e308e3994594b72dd5ba899ec7e3','volumes_tripleo',-1,'2025-12-06 10:16:58',NULL),('2025-12-05 10:16:58','2025-12-05 10:16:59','2025-12-05 10:16:59',1,792,'bf029657-d7e0-41cf-a34a-981c734da07e',205,'d088e308e3994594b72dd5ba899ec7e3','gigabytes_tripleo',-1,'2025-12-06 10:16:58',NULL),('2025-12-05 10:16:58','2025-12-05 10:16:59','2025-12-05 10:16:59',1,793,'682635d0-d0ab-4e9c-8ba8-36d88e1c9819',210,'5e9a7e52b379438eab65d860aa70af42','snapshots',0,'2025-12-06 10:16:58',NULL),('2025-12-05 10:16:58','2025-12-05 10:16:59','2025-12-05 10:16:59',1,794,'ef2cd1e5-9d43-4d35-bb7b-03dae1a6da4d',207,'5e9a7e52b379438eab65d860aa70af42','gigabytes',0,'2025-12-06 10:16:58',NULL),('2025-12-05 10:16:58','2025-12-05 10:16:59','2025-12-05 10:16:59',1,795,'44528e3d-585e-44e7-9ae0-52eea2eff476',209,'5e9a7e52b379438eab65d860aa70af42','gigabytes_tripleo',0,'2025-12-06 10:16:58',NULL),('2025-12-05 10:16:59','2025-12-05 10:16:59','2025-12-05 10:16:59',1,796,'1a7b7278-2dc7-42ad-92e3-bf47e0c81a4f',211,'5e9a7e52b379438eab65d860aa70af42','snapshots_tripleo',0,'2025-12-06 10:16:58',NULL),('2025-12-05 10:16:59','2025-12-05 10:16:59','2025-12-05 10:16:59',1,797,'c1a37897-5d24-4357-a7b0-cdb78fbe85c2',212,'d088e308e3994594b72dd5ba899ec7e3','snapshots',0,'2025-12-06 10:16:59',NULL),('2025-12-05 10:16:59','2025-12-05 10:16:59','2025-12-05 10:16:59',1,798,'95a12258-caae-471a-9497-190a8e5f4471',203,'d088e308e3994594b72dd5ba899ec7e3','gigabytes',0,'2025-12-06 10:16:59',NULL),('2025-12-05 10:16:59','2025-12-05 10:16:59','2025-12-05 10:16:59',1,799,'9d48e957-6d9f-464b-8335-11d125ec6816',205,'d088e308e3994594b72dd5ba899ec7e3','gigabytes_tripleo',0,'2025-12-06 10:16:59',NULL),('2025-12-05 10:16:59','2025-12-05 10:16:59','2025-12-05 10:16:59',1,800,'2a32f126-d1fe-49de-9597-8b466346e6ea',213,'d088e308e3994594b72dd5ba899ec7e3','snapshots_tripleo',0,'2025-12-06 10:16:59',NULL),('2025-12-05 10:17:00','2025-12-05 10:17:00','2025-12-05 10:17:00',1,801,'7d915e9f-b47d-4e08-baaf-a455e7baeff8',206,'5e9a7e52b379438eab65d860aa70af42','volumes',-1,'2025-12-06 10:17:00',NULL),('2025-12-05 10:17:00','2025-12-05 10:17:00','2025-12-05 10:17:00',1,802,'dab6cd3e-4374-444e-a00b-641f1d71f23f',207,'5e9a7e52b379438eab65d860aa70af42','gigabytes',-1,'2025-12-06 10:17:00',NULL),('2025-12-05 10:17:00','2025-12-05 10:17:00','2025-12-05 10:17:00',1,803,'01b13cc6-4bf7-484c-b5e1-2f24d3cca7c2',208,'5e9a7e52b379438eab65d860aa70af42','volumes_tripleo',-1,'2025-12-06 10:17:00',NULL),('2025-12-05 10:17:00','2025-12-05 10:17:00','2025-12-05 10:17:00',1,804,'dc613ba2-cb3f-4524-889c-299cde0eabc3',209,'5e9a7e52b379438eab65d860aa70af42','gigabytes_tripleo',-1,'2025-12-06 10:17:00',NULL),('2025-12-05 10:17:00','2025-12-05 10:17:00','2025-12-05 10:17:00',1,805,'a3cbbb20-bf4f-4c45-9151-b566ad7dec38',214,'3554a89b305c449f9fd292eca5647512','backups',1,'2025-12-06 10:17:00',NULL),('2025-12-05 10:17:00','2025-12-05 10:17:00','2025-12-05 10:17:00',1,806,'ce407f4c-0c8c-4dea-9cf4-cc41a6a8213c',215,'3554a89b305c449f9fd292eca5647512','backup_gigabytes',1,'2025-12-06 10:17:00',NULL),('2025-12-05 10:17:00','2025-12-05 10:17:00','2025-12-05 10:17:00',1,807,'6f634591-cb59-43a8-a4d9-447f10aacf19',202,'d088e308e3994594b72dd5ba899ec7e3','volumes',1,'2025-12-06 10:17:00',NULL),('2025-12-05 10:17:00','2025-12-05 10:17:00','2025-12-05 10:17:00',1,808,'8f598b9c-459b-49f5-9447-86b18829143a',203,'d088e308e3994594b72dd5ba899ec7e3','gigabytes',1,'2025-12-06 10:17:00',NULL),('2025-12-05 10:17:00','2025-12-05 10:17:00','2025-12-05 10:17:00',1,809,'25d858d1-acae-465b-a011-91184e7090de',204,'d088e308e3994594b72dd5ba899ec7e3','volumes_tripleo',1,'2025-12-06 10:17:00',NULL),('2025-12-05 10:17:00','2025-12-05 10:17:00','2025-12-05 10:17:00',1,810,'2d2eff18-a74e-4884-9414-262007ddb0fd',205,'d088e308e3994594b72dd5ba899ec7e3','gigabytes_tripleo',1,'2025-12-06 10:17:00',NULL),('2025-12-05 10:17:02','2025-12-05 10:17:02','2025-12-05 10:17:02',1,811,'78262911-6f50-4526-a0dd-e406f7c295b2',202,'d088e308e3994594b72dd5ba899ec7e3','volumes',-1,'2025-12-06 10:17:02',NULL),('2025-12-05 10:17:02','2025-12-05 10:17:02','2025-12-05 10:17:02',1,812,'4faf3957-aa05-4037-8659-8ae85c3bbf1b',203,'d088e308e3994594b72dd5ba899ec7e3','gigabytes',-1,'2025-12-06 10:17:02',NULL),('2025-12-05 10:17:02','2025-12-05 10:17:02','2025-12-05 10:17:02',1,813,'cd6d75b3-26cf-4a68-b2dc-16cf9849723b',204,'d088e308e3994594b72dd5ba899ec7e3','volumes_tripleo',-1,'2025-12-06 10:17:02',NULL),('2025-12-05 10:17:02','2025-12-05 10:17:02','2025-12-05 10:17:02',1,814,'04d168e9-f111-4eea-a344-7275343286a8',205,'d088e308e3994594b72dd5ba899ec7e3','gigabytes_tripleo',-1,'2025-12-06 10:17:02',NULL),('2025-12-05 10:17:04','2025-12-05 10:17:04','2025-12-05 10:17:04',1,815,'6b869725-aff9-49a1-b1e7-fb71a3716c2e',198,'3554a89b305c449f9fd292eca5647512','volumes',1,'2025-12-06 10:17:04',NULL),('2025-12-05 10:17:04','2025-12-05 10:17:04','2025-12-05 10:17:04',1,816,'a282ff58-7f51-48e5-93e3-15e0d2ef3060',199,'3554a89b305c449f9fd292eca5647512','gigabytes',1,'2025-12-06 10:17:04',NULL),('2025-12-05 10:17:04','2025-12-05 10:17:04','2025-12-05 10:17:04',1,817,'9661d934-671b-4b9d-a7db-8d9d3f4eaf0b',200,'3554a89b305c449f9fd292eca5647512','volumes_tripleo',1,'2025-12-06 10:17:04',NULL),('2025-12-05 10:17:04','2025-12-05 10:17:04','2025-12-05 10:17:04',1,818,'fba1b581-63ef-4bda-8a4f-cba1b1e24f33',201,'3554a89b305c449f9fd292eca5647512','gigabytes_tripleo',1,'2025-12-06 10:17:04',NULL),('2025-12-05 10:17:10','2025-12-05 10:17:10','2025-12-05 10:17:10',1,819,'9e97fd3f-19cd-4bc9-99ba-60603a6a1837',198,'3554a89b305c449f9fd292eca5647512','volumes',-1,'2025-12-06 10:17:10',NULL),('2025-12-05 10:17:10','2025-12-05 10:17:10','2025-12-05 10:17:10',1,820,'06d5e2ef-c8c4-433f-bc77-2403311b1abf',199,'3554a89b305c449f9fd292eca5647512','gigabytes',-1,'2025-12-06 10:17:10',NULL),('2025-12-05 10:17:10','2025-12-05 10:17:10','2025-12-05 10:17:10',1,821,'e15ddd20-3708-44d7-9de5-294fc5369e91',200,'3554a89b305c449f9fd292eca5647512','volumes_tripleo',-1,'2025-12-06 10:17:10',NULL),('2025-12-05 10:17:10','2025-12-05 10:17:10','2025-12-05 10:17:10',1,822,'3fa5e8b9-0876-4cb5-a3c5-d0280425a62b',201,'3554a89b305c449f9fd292eca5647512','gigabytes_tripleo',-1,'2025-12-06 10:17:10',NULL),('2025-12-05 10:17:12','2025-12-05 10:17:12','2025-12-05 10:17:12',1,823,'1879ef22-0765-4402-8768-5d370bdc7011',214,'3554a89b305c449f9fd292eca5647512','backups',-1,'2025-12-06 10:17:12',NULL),('2025-12-05 10:17:12','2025-12-05 10:17:12','2025-12-05 10:17:12',1,824,'72b76f72-1b25-4343-8fd4-ce2c341e3933',215,'3554a89b305c449f9fd292eca5647512','backup_gigabytes',-1,'2025-12-06 10:17:12',NULL),('2025-12-05 10:17:14','2025-12-05 10:17:14','2025-12-05 10:17:14',1,825,'58d2f857-3818-407f-ab9c-1b87c6f9c29b',198,'3554a89b305c449f9fd292eca5647512','volumes',-1,'2025-12-06 10:17:14',NULL),('2025-12-05 10:17:14','2025-12-05 10:17:14','2025-12-05 10:17:14',1,826,'54aeb332-b60b-480d-b36e-b70cef159f04',199,'3554a89b305c449f9fd292eca5647512','gigabytes',-1,'2025-12-06 10:17:14',NULL),('2025-12-05 10:17:14','2025-12-05 10:17:14','2025-12-05 10:17:14',1,827,'4c295daf-8ef2-45a8-9a2f-017141961969',200,'3554a89b305c449f9fd292eca5647512','volumes_tripleo',-1,'2025-12-06 10:17:14',NULL),('2025-12-05 10:17:14','2025-12-05 10:17:14','2025-12-05 10:17:14',1,828,'4e26e124-b76e-48c9-bf79-cb5d29c96fa5',201,'3554a89b305c449f9fd292eca5647512','gigabytes_tripleo',-1,'2025-12-06 10:17:14',NULL),('2025-12-05 10:17:15','2025-12-05 10:17:15','2025-12-05 10:17:15',1,829,'a82c232f-91ab-4a43-aedd-e58d73ed48ff',198,'3554a89b305c449f9fd292eca5647512','volumes',1,'2025-12-06 10:17:15',NULL),('2025-12-05 10:17:15','2025-12-05 10:17:15','2025-12-05 10:17:15',1,830,'4043fdbf-59cc-45d4-8d95-347b9513ed98',199,'3554a89b305c449f9fd292eca5647512','gigabytes',1,'2025-12-06 10:17:15',NULL),('2025-12-05 10:17:15','2025-12-05 10:17:15','2025-12-05 10:17:15',1,831,'f59f8313-cdce-4b38-ab54-2afd99fe02b4',200,'3554a89b305c449f9fd292eca5647512','volumes_tripleo',1,'2025-12-06 10:17:15',NULL),('2025-12-05 10:17:15','2025-12-05 10:17:15','2025-12-05 10:17:15',1,832,'0e410c5d-0312-4a0e-abb8-34df0407e0a2',201,'3554a89b305c449f9fd292eca5647512','gigabytes_tripleo',1,'2025-12-06 10:17:15',NULL),('2025-12-05 10:18:05','2025-12-05 10:18:05','2025-12-05 10:18:05',1,833,'729e84ec-d4a8-4460-8871-dce32878db17',214,'3554a89b305c449f9fd292eca5647512','backups',1,'2025-12-06 10:18:05',NULL),('2025-12-05 10:18:05','2025-12-05 10:18:05','2025-12-05 10:18:05',1,834,'d6b29627-5e35-48a5-838f-a9d5ebdbfb14',215,'3554a89b305c449f9fd292eca5647512','backup_gigabytes',1,'2025-12-06 10:18:05',NULL),('2025-12-05 10:18:10','2025-12-05 10:18:10','2025-12-05 10:18:10',1,835,'5870f0df-3809-43c3-8c60-24d91c82d8d0',214,'3554a89b305c449f9fd292eca5647512','backups',1,'2025-12-06 10:18:10',NULL),('2025-12-05 10:18:10','2025-12-05 10:18:10','2025-12-05 10:18:10',1,836,'bd7c968a-d4e8-4315-9098-b501cb187c50',215,'3554a89b305c449f9fd292eca5647512','backup_gigabytes',1,'2025-12-06 10:18:10',NULL),('2025-12-05 10:18:15','2025-12-05 10:18:15','2025-12-05 10:18:15',1,837,'ded49d7b-9228-4e70-b390-22fc424a0fbf',214,'3554a89b305c449f9fd292eca5647512','backups',-1,'2025-12-06 10:18:15',NULL),('2025-12-05 10:18:15','2025-12-05 10:18:15','2025-12-05 10:18:15',1,838,'4379aeb6-da20-455b-9e98-86992fa203e6',215,'3554a89b305c449f9fd292eca5647512','backup_gigabytes',-1,'2025-12-06 10:18:15',NULL),('2025-12-05 10:18:16','2025-12-05 10:18:16','2025-12-05 10:18:16',1,839,'a341568f-d980-42f8-b913-2c2f81452cd2',214,'3554a89b305c449f9fd292eca5647512','backups',1,'2025-12-06 10:18:16',NULL),('2025-12-05 10:18:16','2025-12-05 10:18:16','2025-12-05 10:18:16',1,840,'b35cc9e9-78e1-41a4-9f30-77e8af8ed74d',215,'3554a89b305c449f9fd292eca5647512','backup_gigabytes',1,'2025-12-06 10:18:16',NULL),('2025-12-05 10:18:22','2025-12-05 10:18:22','2025-12-05 10:18:22',1,841,'206c2bea-5042-4bde-aea9-80c92a869ce4',214,'3554a89b305c449f9fd292eca5647512','backups',-1,'2025-12-06 10:18:22',NULL),('2025-12-05 10:18:22','2025-12-05 10:18:22','2025-12-05 10:18:22',1,842,'578413f2-e11b-4c9c-aff6-483de0a75cfd',215,'3554a89b305c449f9fd292eca5647512','backup_gigabytes',-1,'2025-12-06 10:18:22',NULL),('2025-12-05 10:18:24','2025-12-05 10:18:24','2025-12-05 10:18:24',1,843,'4f94691c-b472-4da6-bbe3-4b50da52daaf',214,'3554a89b305c449f9fd292eca5647512','backups',-1,'2025-12-06 10:18:24',NULL),('2025-12-05 10:18:24','2025-12-05 10:18:24','2025-12-05 10:18:24',1,844,'da8461cc-f5ab-453e-ad4d-e36321f2d003',215,'3554a89b305c449f9fd292eca5647512','backup_gigabytes',-1,'2025-12-06 10:18:24',NULL),('2025-12-05 10:18:34','2025-12-05 10:18:34','2025-12-05 10:18:34',1,845,'6738a55a-1271-4933-8d37-ab4e3f0e9295',198,'3554a89b305c449f9fd292eca5647512','volumes',-1,'2025-12-06 10:18:34',NULL),('2025-12-05 10:18:34','2025-12-05 10:18:34','2025-12-05 10:18:34',1,846,'72708f23-e9f5-4dd7-a3a1-49c764957b51',199,'3554a89b305c449f9fd292eca5647512','gigabytes',-1,'2025-12-06 10:18:34',NULL),('2025-12-05 10:18:34','2025-12-05 10:18:34','2025-12-05 10:18:34',1,847,'564eabaf-98f5-48bc-8f27-fc91f76d5f90',200,'3554a89b305c449f9fd292eca5647512','volumes_tripleo',-1,'2025-12-06 10:18:34',NULL),('2025-12-05 10:18:34','2025-12-05 10:18:34','2025-12-05 10:18:34',1,848,'061168c5-bfa6-49a2-92d0-9fbd395bfed9',201,'3554a89b305c449f9fd292eca5647512','gigabytes_tripleo',-1,'2025-12-06 10:18:34',NULL),('2025-12-05 10:18:53','2025-12-05 10:18:53','2025-12-05 10:18:53',1,849,'8577cfe6-2f79-404f-adbb-97be21d06fef',216,'a6e8880ab10e4b26b0074c6f9b06aca3','volumes',1,'2025-12-06 10:18:53',NULL),('2025-12-05 10:18:53','2025-12-05 10:18:53','2025-12-05 10:18:53',1,850,'ad6ffdbf-31e5-464a-92cf-8a88a437bd42',217,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes',1,'2025-12-06 10:18:53',NULL),('2025-12-05 10:18:53','2025-12-05 10:18:53','2025-12-05 10:18:53',1,851,'08eebc6c-4e9c-4cbd-8d53-8d00d571eef4',218,'a6e8880ab10e4b26b0074c6f9b06aca3','volumes_tripleo',1,'2025-12-06 10:18:53',NULL),('2025-12-05 10:18:53','2025-12-05 10:18:53','2025-12-05 10:18:53',1,852,'f17dc51e-ebc6-4d34-b362-19437ddb1d92',219,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes_tripleo',1,'2025-12-06 10:18:53',NULL),('2025-12-05 10:18:54','2025-12-05 10:18:54','2025-12-05 10:18:54',1,853,'334efe29-8c01-4286-8d63-17be41d3c7ed',220,'a6e8880ab10e4b26b0074c6f9b06aca3','snapshots',1,'2025-12-06 10:18:54',NULL),('2025-12-05 10:18:54','2025-12-05 10:18:54','2025-12-05 10:18:54',1,854,'d1baba1e-fd6d-47c2-82d3-6b7e1d0269c5',217,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes',1,'2025-12-06 10:18:54',NULL),('2025-12-05 10:18:54','2025-12-05 10:18:54','2025-12-05 10:18:54',1,855,'28369916-58d6-4e4e-b4c0-8564f9c04dc6',219,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes_tripleo',1,'2025-12-06 10:18:54',NULL),('2025-12-05 10:18:54','2025-12-05 10:18:54','2025-12-05 10:18:54',1,856,'f289a18a-fca8-44de-ae53-054ad77c56ba',221,'a6e8880ab10e4b26b0074c6f9b06aca3','snapshots_tripleo',1,'2025-12-06 10:18:54',NULL),('2025-12-05 10:18:56','2025-12-05 10:18:57','2025-12-05 10:18:57',1,857,'3b38aa3d-6f1b-42bb-a323-d7e13a389009',222,'a6e8880ab10e4b26b0074c6f9b06aca3','backups',1,'2025-12-06 10:18:56',NULL),('2025-12-05 10:18:56','2025-12-05 10:18:57','2025-12-05 10:18:57',1,858,'a0ccc871-a1cd-414d-9a35-ea375b491096',223,'a6e8880ab10e4b26b0074c6f9b06aca3','backup_gigabytes',1,'2025-12-06 10:18:56',NULL),('2025-12-05 10:19:15','2025-12-05 10:19:15','2025-12-05 10:19:15',1,859,'d5b81d97-0591-48c8-a5b9-8f9f02104b7c',222,'a6e8880ab10e4b26b0074c6f9b06aca3','backups',-1,'2025-12-06 10:19:15',NULL),('2025-12-05 10:19:15','2025-12-05 10:19:15','2025-12-05 10:19:15',1,860,'311e1f8f-5c6d-4e21-8367-9d29ca0c7103',223,'a6e8880ab10e4b26b0074c6f9b06aca3','backup_gigabytes',-1,'2025-12-06 10:19:15',NULL),('2025-12-05 10:19:17','2025-12-05 10:19:17','2025-12-05 10:19:17',1,861,'9672aa4c-88b4-4259-a2d2-5d33a6e6aef3',220,'a6e8880ab10e4b26b0074c6f9b06aca3','snapshots',-1,'2025-12-06 10:19:17',NULL),('2025-12-05 10:19:17','2025-12-05 10:19:17','2025-12-05 10:19:17',1,862,'0c61bbca-7d33-4001-af95-2e025d18299c',217,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes',-1,'2025-12-06 10:19:17',NULL),('2025-12-05 10:19:17','2025-12-05 10:19:17','2025-12-05 10:19:17',1,863,'62c93d6f-8898-47d1-9786-174533edebe0',219,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes_tripleo',-1,'2025-12-06 10:19:17',NULL),('2025-12-05 10:19:17','2025-12-05 10:19:17','2025-12-05 10:19:17',1,864,'5d3b5ad2-cd6e-4223-9e52-de0ff7507620',221,'a6e8880ab10e4b26b0074c6f9b06aca3','snapshots_tripleo',-1,'2025-12-06 10:19:17',NULL),('2025-12-05 10:19:18','2025-12-05 10:19:18','2025-12-05 10:19:18',1,865,'36d3bc74-08ad-4704-b62e-ef59c8872740',220,'a6e8880ab10e4b26b0074c6f9b06aca3','snapshots',1,'2025-12-06 10:19:18',NULL),('2025-12-05 10:19:18','2025-12-05 10:19:18','2025-12-05 10:19:18',1,866,'b3854ad5-3c3c-4251-be77-143fac83774f',217,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes',1,'2025-12-06 10:19:18',NULL),('2025-12-05 10:19:18','2025-12-05 10:19:18','2025-12-05 10:19:18',1,867,'6de95d73-238f-492c-841d-8598fafa5856',219,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes_tripleo',1,'2025-12-06 10:19:18',NULL),('2025-12-05 10:19:18','2025-12-05 10:19:18','2025-12-05 10:19:18',1,868,'a186a9ae-24f9-4b28-a241-68e700c3df72',221,'a6e8880ab10e4b26b0074c6f9b06aca3','snapshots_tripleo',1,'2025-12-06 10:19:18',NULL),('2025-12-05 10:19:21','2025-12-05 10:19:21','2025-12-05 10:19:21',1,869,'08d26a18-d56d-45c0-a127-37c1b5830650',220,'a6e8880ab10e4b26b0074c6f9b06aca3','snapshots',-1,'2025-12-06 10:19:21',NULL),('2025-12-05 10:19:21','2025-12-05 10:19:21','2025-12-05 10:19:21',1,870,'4e62042d-81c0-4472-a57d-afd03be4c5e6',217,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes',-1,'2025-12-06 10:19:21',NULL),('2025-12-05 10:19:21','2025-12-05 10:19:21','2025-12-05 10:19:21',1,871,'d306cfcc-d18f-4ccd-a685-b0d8b572e79b',219,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes_tripleo',-1,'2025-12-06 10:19:21',NULL),('2025-12-05 10:19:21','2025-12-05 10:19:21','2025-12-05 10:19:21',1,872,'f908c07b-8af3-441c-90f5-164706e8f2c2',221,'a6e8880ab10e4b26b0074c6f9b06aca3','snapshots_tripleo',-1,'2025-12-06 10:19:21',NULL),('2025-12-05 10:19:22','2025-12-05 10:19:22','2025-12-05 10:19:22',1,873,'2a135f4e-c132-4bee-ba8f-d9e76db30d8f',216,'a6e8880ab10e4b26b0074c6f9b06aca3','volumes',1,'2025-12-06 10:19:22',NULL),('2025-12-05 10:19:22','2025-12-05 10:19:22','2025-12-05 10:19:22',1,874,'87fb3627-3d2f-4b97-be96-7166f5796065',217,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes',1,'2025-12-06 10:19:22',NULL),('2025-12-05 10:19:22','2025-12-05 10:19:22','2025-12-05 10:19:22',1,875,'dac6227d-64c0-4784-b0e0-d7516261fe16',218,'a6e8880ab10e4b26b0074c6f9b06aca3','volumes_tripleo',1,'2025-12-06 10:19:22',NULL),('2025-12-05 10:19:22','2025-12-05 10:19:22','2025-12-05 10:19:22',1,876,'b08fed5a-d550-40c7-b5eb-65ec9936361e',219,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes_tripleo',1,'2025-12-06 10:19:22',NULL),('2025-12-05 10:19:24','2025-12-05 10:19:24','2025-12-05 10:19:24',1,877,'cbd9057e-56de-4866-a266-c437c9b7dcdb',220,'a6e8880ab10e4b26b0074c6f9b06aca3','snapshots',1,'2025-12-06 10:19:24',NULL),('2025-12-05 10:19:24','2025-12-05 10:19:24','2025-12-05 10:19:24',1,878,'d3a6d974-645d-4680-8263-3c538dd6d658',217,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes',1,'2025-12-06 10:19:24',NULL),('2025-12-05 10:19:24','2025-12-05 10:19:24','2025-12-05 10:19:24',1,879,'f176497d-1583-4738-8beb-d4514d9a096f',219,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes_tripleo',1,'2025-12-06 10:19:24',NULL),('2025-12-05 10:19:24','2025-12-05 10:19:24','2025-12-05 10:19:24',1,880,'daecaa23-ab2d-4143-bb12-c06167fc4207',221,'a6e8880ab10e4b26b0074c6f9b06aca3','snapshots_tripleo',1,'2025-12-06 10:19:24',NULL),('2025-12-05 10:19:25','2025-12-05 10:19:25','2025-12-05 10:19:25',1,881,'1ca3ff41-cb56-4ee6-bfc2-a4ea64b161d4',216,'a6e8880ab10e4b26b0074c6f9b06aca3','volumes',1,'2025-12-06 10:19:25',NULL),('2025-12-05 10:19:25','2025-12-05 10:19:25','2025-12-05 10:19:25',1,882,'6be4e122-a947-4163-ac06-649faf815ca6',217,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes',2,'2025-12-06 10:19:25',NULL),('2025-12-05 10:19:25','2025-12-05 10:19:25','2025-12-05 10:19:25',1,883,'c5b5ac74-ca72-47fa-99cb-38d73d4d2ac6',218,'a6e8880ab10e4b26b0074c6f9b06aca3','volumes_tripleo',1,'2025-12-06 10:19:25',NULL),('2025-12-05 10:19:25','2025-12-05 10:19:25','2025-12-05 10:19:25',1,884,'0a580557-7523-4671-b0ba-70f6560329f9',219,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes_tripleo',2,'2025-12-06 10:19:25',NULL),('2025-12-05 10:19:27','2025-12-05 10:19:27','2025-12-05 10:19:27',1,885,'89c65461-4c48-4a8c-9265-06d8217143f5',216,'a6e8880ab10e4b26b0074c6f9b06aca3','volumes',-1,'2025-12-06 10:19:27',NULL),('2025-12-05 10:19:27','2025-12-05 10:19:27','2025-12-05 10:19:27',1,886,'69efc750-443d-47b8-9197-a0a4f553fdd9',217,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes',-2,'2025-12-06 10:19:27',NULL),('2025-12-05 10:19:27','2025-12-05 10:19:27','2025-12-05 10:19:27',1,887,'76bf1c1c-b498-473a-bc16-ed80613c17a1',218,'a6e8880ab10e4b26b0074c6f9b06aca3','volumes_tripleo',-1,'2025-12-06 10:19:27',NULL),('2025-12-05 10:19:27','2025-12-05 10:19:27','2025-12-05 10:19:27',1,888,'4b69597a-4172-4e7f-9480-064b35cdda2f',219,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes_tripleo',-2,'2025-12-06 10:19:27',NULL),('2025-12-05 10:19:28','2025-12-05 10:19:28','2025-12-05 10:19:28',1,889,'6b55c8b0-1528-452f-bd64-a69359aa6a6c',220,'a6e8880ab10e4b26b0074c6f9b06aca3','snapshots',-1,'2025-12-06 10:19:28',NULL),('2025-12-05 10:19:28','2025-12-05 10:19:28','2025-12-05 10:19:28',1,890,'e73e60ee-d995-4040-b0f7-113cef87e5cf',217,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes',-1,'2025-12-06 10:19:28',NULL),('2025-12-05 10:19:28','2025-12-05 10:19:28','2025-12-05 10:19:28',1,891,'74685069-cb5d-4919-8176-1c630e4f205d',219,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes_tripleo',-1,'2025-12-06 10:19:28',NULL),('2025-12-05 10:19:28','2025-12-05 10:19:28','2025-12-05 10:19:28',1,892,'1f93415c-6219-4d40-bfbf-6a6e742436f3',221,'a6e8880ab10e4b26b0074c6f9b06aca3','snapshots_tripleo',-1,'2025-12-06 10:19:28',NULL),('2025-12-05 10:19:29','2025-12-05 10:19:29','2025-12-05 10:19:29',1,893,'b84a3107-f5e6-4d85-ad39-49f11fc60e77',216,'a6e8880ab10e4b26b0074c6f9b06aca3','volumes',-1,'2025-12-06 10:19:29',NULL),('2025-12-05 10:19:29','2025-12-05 10:19:29','2025-12-05 10:19:29',1,894,'30d87021-fd00-4f77-84a6-e991e72bcebd',217,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes',-1,'2025-12-06 10:19:29',NULL),('2025-12-05 10:19:29','2025-12-05 10:19:29','2025-12-05 10:19:29',1,895,'4519cdb6-0db8-424f-8e18-598dac8bac77',218,'a6e8880ab10e4b26b0074c6f9b06aca3','volumes_tripleo',-1,'2025-12-06 10:19:29',NULL),('2025-12-05 10:19:29','2025-12-05 10:19:29','2025-12-05 10:19:29',1,896,'497353bd-f705-4852-b4cc-c601b737206e',219,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes_tripleo',-1,'2025-12-06 10:19:29',NULL),('2025-12-05 10:19:30','2025-12-05 10:19:30','2025-12-05 10:19:30',1,897,'6de4042e-30df-4618-87f3-d1ed92421376',216,'a6e8880ab10e4b26b0074c6f9b06aca3','volumes',1,'2025-12-06 10:19:30',NULL),('2025-12-05 10:19:30','2025-12-05 10:19:30','2025-12-05 10:19:30',1,898,'c981a3c4-365a-45c6-95d2-f552c52047f9',217,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes',1,'2025-12-06 10:19:30',NULL),('2025-12-05 10:19:30','2025-12-05 10:19:30','2025-12-05 10:19:30',1,899,'e61a8e11-60cf-42dd-8d71-153a836a0bf5',218,'a6e8880ab10e4b26b0074c6f9b06aca3','volumes_tripleo',1,'2025-12-06 10:19:30',NULL),('2025-12-05 10:19:30','2025-12-05 10:19:30','2025-12-05 10:19:30',1,900,'cf0c9e28-7d26-4cda-988e-d677e1572e85',219,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes_tripleo',1,'2025-12-06 10:19:30',NULL),('2025-12-05 10:19:31','2025-12-05 10:19:31','2025-12-05 10:19:31',1,901,'dbdd5dcc-615c-40ec-9cea-83806ed2f757',220,'a6e8880ab10e4b26b0074c6f9b06aca3','snapshots',1,'2025-12-06 10:19:31',NULL),('2025-12-05 10:19:31','2025-12-05 10:19:31','2025-12-05 10:19:31',1,902,'05b21276-ae70-487b-9981-9c8ed6ad4712',217,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes',1,'2025-12-06 10:19:31',NULL),('2025-12-05 10:19:31','2025-12-05 10:19:31','2025-12-05 10:19:31',1,903,'40c4a84e-b293-41eb-b1b2-92621fd71956',219,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes_tripleo',1,'2025-12-06 10:19:31',NULL),('2025-12-05 10:19:31','2025-12-05 10:19:31','2025-12-05 10:19:31',1,904,'36fce95d-aa40-4634-84d8-058038d07c11',221,'a6e8880ab10e4b26b0074c6f9b06aca3','snapshots_tripleo',1,'2025-12-06 10:19:31',NULL),('2025-12-05 10:19:32','2025-12-05 10:19:32','2025-12-05 10:19:32',1,905,'635d68cf-9767-4852-bf95-b0966552073a',216,'a6e8880ab10e4b26b0074c6f9b06aca3','volumes',1,'2025-12-06 10:19:32',NULL),('2025-12-05 10:19:32','2025-12-05 10:19:32','2025-12-05 10:19:32',1,906,'ee1de246-110f-41c4-b774-cf0e133ef163',217,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes',1,'2025-12-06 10:19:32',NULL),('2025-12-05 10:19:32','2025-12-05 10:19:32','2025-12-05 10:19:32',1,907,'864181c1-8f7c-42d8-8af5-9cd1ce4ebb43',218,'a6e8880ab10e4b26b0074c6f9b06aca3','volumes_tripleo',1,'2025-12-06 10:19:32',NULL),('2025-12-05 10:19:32','2025-12-05 10:19:32','2025-12-05 10:19:32',1,908,'6af10a0f-34bc-4b2e-92cb-69348b73d334',219,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes_tripleo',1,'2025-12-06 10:19:32',NULL),('2025-12-05 10:19:34','2025-12-05 10:19:34','2025-12-05 10:19:34',1,909,'30748fc4-6785-479c-801e-1ac7b2dfc47c',216,'a6e8880ab10e4b26b0074c6f9b06aca3','volumes',-1,'2025-12-06 10:19:34',NULL),('2025-12-05 10:19:34','2025-12-05 10:19:34','2025-12-05 10:19:34',1,910,'f6369283-5024-4751-8d4c-106bb7b8d063',217,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes',-1,'2025-12-06 10:19:34',NULL),('2025-12-05 10:19:34','2025-12-05 10:19:34','2025-12-05 10:19:34',1,911,'ea3df040-514e-4bcd-989e-d53fb1b224f2',218,'a6e8880ab10e4b26b0074c6f9b06aca3','volumes_tripleo',-1,'2025-12-06 10:19:34',NULL),('2025-12-05 10:19:34','2025-12-05 10:19:34','2025-12-05 10:19:34',1,912,'041f3b5d-c382-49aa-891b-0d22b9241494',219,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes_tripleo',-1,'2025-12-06 10:19:34',NULL),('2025-12-05 10:19:36','2025-12-05 10:19:36','2025-12-05 10:19:36',1,913,'966e391c-b5f4-4192-a89e-31ca3314e4d7',220,'a6e8880ab10e4b26b0074c6f9b06aca3','snapshots',-1,'2025-12-06 10:19:36',NULL),('2025-12-05 10:19:36','2025-12-05 10:19:36','2025-12-05 10:19:36',1,914,'6f9a64c9-1178-4356-a012-b3f48999a3ac',217,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes',-1,'2025-12-06 10:19:36',NULL),('2025-12-05 10:19:36','2025-12-05 10:19:36','2025-12-05 10:19:36',1,915,'2bf6cc42-8b0c-433b-9b8b-98d783fd6580',219,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes_tripleo',-1,'2025-12-06 10:19:36',NULL),('2025-12-05 10:19:36','2025-12-05 10:19:36','2025-12-05 10:19:36',1,916,'a5c02f8e-6c45-492a-a0b2-c8c0f90bba3e',221,'a6e8880ab10e4b26b0074c6f9b06aca3','snapshots_tripleo',-1,'2025-12-06 10:19:36',NULL),('2025-12-05 10:19:37','2025-12-05 10:19:37','2025-12-05 10:19:37',1,917,'be4ba46b-a60a-4d40-9303-4f8567d098cd',216,'a6e8880ab10e4b26b0074c6f9b06aca3','volumes',-1,'2025-12-06 10:19:37',NULL),('2025-12-05 10:19:37','2025-12-05 10:19:37','2025-12-05 10:19:37',1,918,'03cb41f1-ccd8-4f0e-b2f0-ef58ce7220cd',217,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes',-1,'2025-12-06 10:19:37',NULL),('2025-12-05 10:19:37','2025-12-05 10:19:37','2025-12-05 10:19:37',1,919,'ab773360-9c0e-4f26-8583-dfcc828409b9',218,'a6e8880ab10e4b26b0074c6f9b06aca3','volumes_tripleo',-1,'2025-12-06 10:19:37',NULL),('2025-12-05 10:19:37','2025-12-05 10:19:37','2025-12-05 10:19:37',1,920,'2bff2a9d-3bf7-40ff-8049-01b6e066971c',219,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes_tripleo',-1,'2025-12-06 10:19:37',NULL),('2025-12-05 10:19:38','2025-12-05 10:19:38','2025-12-05 10:19:38',1,921,'52f67fc9-fd0c-4184-8d9c-de39261c2e46',216,'a6e8880ab10e4b26b0074c6f9b06aca3','volumes',-1,'2025-12-06 10:19:38',NULL),('2025-12-05 10:19:38','2025-12-05 10:19:38','2025-12-05 10:19:38',1,922,'9c723ed2-a36b-44a9-9458-c71fd016339b',217,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes',-1,'2025-12-06 10:19:38',NULL),('2025-12-05 10:19:38','2025-12-05 10:19:38','2025-12-05 10:19:38',1,923,'91750b01-2d71-4050-8500-b3e5f4706948',218,'a6e8880ab10e4b26b0074c6f9b06aca3','volumes_tripleo',-1,'2025-12-06 10:19:38',NULL),('2025-12-05 10:19:38','2025-12-05 10:19:38','2025-12-05 10:19:38',1,924,'f26cad3c-e1b3-479f-af9b-96c61047e7fa',219,'a6e8880ab10e4b26b0074c6f9b06aca3','gigabytes_tripleo',-1,'2025-12-06 10:19:38',NULL);
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `rpc_current_version` varchar(36) DEFAULT NULL,
  `object_current_version` varchar(36) DEFAULT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `frozen` tinyint(1) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `services_uuid_idx` (`uuid`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`disabled` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`frozen` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone`, `disabled_reason`, `modified_at`, `rpc_current_version`, `object_current_version`, `replication_status`, `frozen`, `active_backend_id`, `cluster_name`, `uuid`) VALUES ('2025-12-05 08:22:11','2025-12-05 08:59:46','2025-12-05 08:59:46',1,2,'np0005546415.localdomain','cinder-scheduler','cinder-scheduler',119,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'33a2de62-9247-44fa-95d9-bb37819a57a3'),('2025-12-05 08:22:28','2025-12-05 08:59:48','2025-12-05 08:59:48',1,5,'np0005546418.localdomain','cinder-scheduler','cinder-scheduler',118,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'07a8cc30-64e0-4253-811d-6f5df8e01352'),('2025-12-05 08:22:30','2025-12-05 08:59:51','2025-12-05 08:59:51',1,8,'np0005546416.localdomain','cinder-scheduler','cinder-scheduler',117,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'a50b0113-2434-4722-99ad-20e627006021'),('2025-12-05 08:25:42','2025-12-05 08:59:40','2025-12-05 08:59:40',1,11,'np0005546415.localdomain','cinder-backup','cinder-backup',141,0,'nova',NULL,NULL,'2.4','1.39','not-capable',0,NULL,NULL,'2ff8ca3c-609b-4dc5-b445-1dfb773c09f1'),('2025-12-05 08:26:17','2025-12-05 10:36:32',NULL,0,14,'hostgroup@tripleo_ceph','cinder-volume','cinder-volume',715,0,'nova',NULL,NULL,'3.18','1.39','disabled',0,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f'),('2025-12-05 08:59:56','2025-12-05 10:36:31',NULL,0,17,'cinder-scheduler-0','cinder-scheduler','cinder-scheduler',578,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'02eb7675-1b47-498c-9892-91a6219bf5d8'),('2025-12-05 09:00:00','2025-12-05 10:36:31',NULL,0,18,'cinder-backup-0','cinder-backup','cinder-backup',579,0,'nova',NULL,NULL,'2.4','1.39','not-capable',0,NULL,NULL,'3dfd7894-64d5-4961-aee4-49fc6cca0d98');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot_metadata`
--

DROP TABLE IF EXISTS `snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshot_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `snapshot_metadata_ibfk_1` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot_metadata`
--

LOCK TABLES `snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `snapshot_metadata` DISABLE KEYS */;
INSERT INTO `snapshot_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `snapshot_id`, `key`, `value`) VALUES ('2025-12-05 10:16:48','2025-12-05 10:16:48','2025-12-05 10:16:48',1,1,'2eb9021b-8a44-4cf4-9c2b-b530bf077364','key1','value1'),('2025-12-05 10:16:48','2025-12-05 10:16:48','2025-12-05 10:16:48',1,2,'2eb9021b-8a44-4cf4-9c2b-b530bf077364','key2','value2'),('2025-12-05 10:16:48','2025-12-05 10:16:48','2025-12-05 10:16:48',1,3,'2eb9021b-8a44-4cf4-9c2b-b530bf077364','key3','value3_update'),('2025-12-05 10:16:48','2025-12-05 10:16:48','2025-12-05 10:16:48',1,4,'2eb9021b-8a44-4cf4-9c2b-b530bf077364','key4','value4'),('2025-12-05 10:16:48','2025-12-05 10:16:49','2025-12-05 10:16:49',1,5,'2eb9021b-8a44-4cf4-9c2b-b530bf077364','key1','value1'),('2025-12-05 10:16:48','2025-12-05 10:16:49','2025-12-05 10:16:49',1,6,'2eb9021b-8a44-4cf4-9c2b-b530bf077364','key2','value2'),('2025-12-05 10:16:48','2025-12-05 10:16:49','2025-12-05 10:16:49',1,7,'2eb9021b-8a44-4cf4-9c2b-b530bf077364','key3','value3_update'),('2025-12-05 10:19:18',NULL,'2025-12-05 10:19:21',1,8,'54ff9893-eafc-488f-bfc2-b281a227a120','snap-meta1','value1'),('2025-12-05 10:19:18',NULL,'2025-12-05 10:19:21',1,9,'54ff9893-eafc-488f-bfc2-b281a227a120','snap-meta2','value2'),('2025-12-05 10:19:18',NULL,'2025-12-05 10:19:21',1,10,'54ff9893-eafc-488f-bfc2-b281a227a120','snap-meta3','value3');
/*!40000 ALTER TABLE `snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshots`
--

DROP TABLE IF EXISTS `snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `volume_size` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `provider_auth` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshots_cgsnapshot_id` (`cgsnapshot_id`),
  KEY `ix_snapshots_group_snapshot_id` (`group_snapshot_id`),
  KEY `ix_snapshots_volume_id` (`volume_id`),
  KEY `snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `snapshots_ibfk_1` FOREIGN KEY (`cgsnapshot_id`) REFERENCES `cgsnapshots` (`id`),
  CONSTRAINT `snapshots_ibfk_2` FOREIGN KEY (`group_snapshot_id`) REFERENCES `group_snapshots` (`id`),
  CONSTRAINT `snapshots_volume_id_fkey` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshots`
--

LOCK TABLES `snapshots` WRITE;
/*!40000 ALTER TABLE `snapshots` DISABLE KEYS */;
INSERT INTO `snapshots` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `status`, `progress`, `volume_size`, `scheduled_at`, `display_name`, `display_description`, `provider_location`, `encryption_key_id`, `volume_type_id`, `cgsnapshot_id`, `provider_id`, `provider_auth`, `group_snapshot_id`, `use_quota`) VALUES ('2025-12-05 10:15:55','2025-12-05 10:16:02','2025-12-05 10:16:02',1,'00db2d01-9354-4956-8805-c904dfca90d9','9e90e54d-88b4-4fe1-ac0f-6f92dda2b118','0ab0e0dead37412ebd73c839224d4687','ebf51e9cd741494484f25cc0c15bc318','deleted','100%',1,NULL,'tempest-group_snapshot-2009358491',NULL,NULL,NULL,'6e8addcf-37df-4d11-81e1-5968791dd1b8',NULL,NULL,NULL,'6f71053d-fe01-44f5-a2aa-e643e7725a0d',1),('2025-12-05 10:15:59','2025-12-05 10:16:00','2025-12-05 10:16:01',1,'0e4800ce-d944-43c5-8849-032e524bbc55','1a46f21f-48ca-4b71-88f2-f5de462fc26b','b36dfd3363184111af20acb3ebaee28a','ee708d36384c422aad0ff42f0242e9cf','deleted','100%',1,NULL,'tempest-SnapshotsActionsTest-Snapshot-800241657',NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,NULL,NULL,NULL,1),('2025-12-05 10:12:07','2025-12-05 10:12:18','2025-12-05 10:12:19',1,'1516cf1e-4b18-4047-83e0-a569c4ee0cbe','3a64d4f9-8506-4b6e-bfad-e6d16b962a09','04505938eab74d378aaf8b4824feba84','9e3d3287162a4caabf625f0490cbd91d','deleted','100%',1,NULL,'tempest-VolumesSnapshotListTestJSON-Snapshot-1918032815',NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,NULL,NULL,NULL,1),('2025-12-05 10:13:56','2025-12-05 10:13:58','2025-12-05 10:13:59',1,'1a19e4fb-fc07-4a3a-8cf9-5abe0add9010','e998f2d9-820c-4bc8-a8f0-66c10734f807','07ea79a3d5b740eeb0cd19d5221ddaa0','cc5978fe065b4f80b1bc25ce32164997','deleted','100%',1,NULL,'tempest-VolumesDeleteCascade-Snapshot-1724999967',NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,NULL,NULL,NULL,1),('2025-12-05 10:16:14','2025-12-05 10:16:18','2025-12-05 10:16:18',1,'1c29d288-ace3-462b-97ea-b4c0cd98497a','7f24d3b5-3a5f-4832-ae9f-95b7986c3514','0ab0e0dead37412ebd73c839224d4687','ebf51e9cd741494484f25cc0c15bc318','deleted','100%',1,NULL,'tempest-GroupSnapshotsTest-Group_Snapshot-656961793',NULL,NULL,NULL,'18d2d611-0b44-4c06-b445-cb3ed9593cbd',NULL,NULL,NULL,'7b3d1430-4aff-4541-83d0-31770b3122c6',1),('2025-12-05 10:16:02','2025-12-05 10:16:04','2025-12-05 10:16:05',1,'1c96dba5-ecf8-4c49-836e-f1d7f6bff7ad','1a46f21f-48ca-4b71-88f2-f5de462fc26b','b36dfd3363184111af20acb3ebaee28a','ee708d36384c422aad0ff42f0242e9cf','deleted','100%',1,NULL,'tempest-SnapshotsActionsTest-Snapshot-1218947541',NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,NULL,NULL,NULL,1),('2025-12-05 10:12:28','2025-12-05 10:12:29','2025-12-05 10:12:30',1,'24624464-8245-4a40-b537-0e36d55680ca','9d073713-de38-46b1-8cc6-2ce7c373d49b','d74a7ea03b864e4e88aee448fd739242','ef76e1242a6d41498f75478c52cab8e4','deleted','100%',2,NULL,'tempest-VolumesSnapshotNegativeTestJSON-Snapshot-907871606',NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,NULL,NULL,NULL,1),('2025-12-05 10:16:46','2025-12-05 10:16:49','2025-12-05 10:16:49',1,'2eb9021b-8a44-4cf4-9c2b-b530bf077364','fae1fc43-a1c4-4329-ad87-8fa74187de0d','54ea334b025445379af9833a9c219695','b0b002e8666a4d4c8dd3481cd357bc82','deleted','100%',1,NULL,'tempest-SnapshotMetadataTestJSON-Snapshot-2059512558',NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,NULL,NULL,NULL,1),('2025-12-05 10:12:09','2025-12-05 10:12:12','2025-12-05 10:12:13',1,'2faea1d7-baff-402a-800a-1fbd1c7b23f4','92de1783-7991-497e-af1c-086bc93c3569','38cd917d57ba40a4bbbdcb831652dbb8','9b06ebc1eb5f4622b3198559907b39ec','deleted','100%',1,NULL,'tempest-VolumeSnapshotQuotasNegativeTestJSON-Snapshot-764593465',NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,NULL,NULL,NULL,1),('2025-12-05 10:19:31','2025-12-05 10:19:35','2025-12-05 10:19:36',1,'2fe03c61-7425-4700-941d-2b1d8aa6e8d7','4a3b1124-b529-47be-869a-28a48b62b0a5','2150e2e9985942e98ecd4ba9bf2f7997','a6e8880ab10e4b26b0074c6f9b06aca3','deleted','100%',1,NULL,'tempest-VolumesSnapshotTestJSON-Snapshot-1020045945',NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,NULL,NULL,NULL,1),('2025-12-05 10:16:22','2025-12-05 10:16:25','2025-12-05 10:16:25',1,'39468b3e-471b-459f-bbfc-405aec3d0812','782a1680-7250-4cba-bcd6-d808521961f6','0ab0e0dead37412ebd73c839224d4687','ebf51e9cd741494484f25cc0c15bc318','deleted','100%',1,NULL,'tempest-group_snapshot-1784444075',NULL,NULL,NULL,'76db33c3-6505-45eb-b8c1-5b9f9af11b08',NULL,NULL,NULL,'1e77e3ac-cbd0-4a0a-8cea-1dde02dc345a',1),('2025-12-05 10:14:04','2025-12-05 10:14:07','2025-12-05 10:14:14',1,'486125e6-dfe6-456e-ae90-97058b3a6f8f','9a689893-f0c7-4426-9371-d80bb45296b4','07ea79a3d5b740eeb0cd19d5221ddaa0','cc5978fe065b4f80b1bc25ce32164997','deleted','100%',1,NULL,'tempest-VolumesDeleteCascade-Snapshot-1400127',NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,NULL,NULL,NULL,1),('2025-12-05 10:13:54','2025-12-05 10:13:58','2025-12-05 10:14:00',1,'4be0eb36-17d1-4278-9bd7-8c27ce5e6be0','e998f2d9-820c-4bc8-a8f0-66c10734f807','07ea79a3d5b740eeb0cd19d5221ddaa0','cc5978fe065b4f80b1bc25ce32164997','deleted','100%',1,NULL,'tempest-VolumesDeleteCascade-Snapshot-550126726',NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,NULL,NULL,NULL,1),('2025-12-05 10:16:09','2025-12-05 10:16:12','2025-12-05 10:16:12',1,'5319417e-351e-4c6c-88e8-2b567340dc91','1a46f21f-48ca-4b71-88f2-f5de462fc26b','b36dfd3363184111af20acb3ebaee28a','ee708d36384c422aad0ff42f0242e9cf','deleted','100%',1,NULL,'tempest-SnapshotsActionsTest-Snapshot-1734303414',NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,NULL,NULL,NULL,1),('2025-12-05 10:19:18','2025-12-05 10:19:20','2025-12-05 10:19:21',1,'54ff9893-eafc-488f-bfc2-b281a227a120','bd924392-bd2a-4d46-a0f2-d1997d25543c','2150e2e9985942e98ecd4ba9bf2f7997','a6e8880ab10e4b26b0074c6f9b06aca3','deleted','100%',1,NULL,'tempest-VolumesSnapshotTestJSON-new-snap-274863023','This is the new description of snapshot.',NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,NULL,NULL,NULL,1),('2025-12-05 10:19:24','2025-12-05 10:19:28','2025-12-05 10:19:28',1,'7d7263a5-5e68-4537-89e1-f70cc435ff34','210dd159-3640-4f6e-8ca4-cc9db6915395','2150e2e9985942e98ecd4ba9bf2f7997','a6e8880ab10e4b26b0074c6f9b06aca3','deleted','100%',1,NULL,'tempest-VolumesSnapshotTestJSON-Snapshot-1813239250',NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,NULL,NULL,NULL,1),('2025-12-05 10:18:54','2025-12-05 10:19:15','2025-12-05 10:19:17',1,'825c3468-fdb7-49ee-aa42-4df403a2ae8b','bd924392-bd2a-4d46-a0f2-d1997d25543c','2150e2e9985942e98ecd4ba9bf2f7997','a6e8880ab10e4b26b0074c6f9b06aca3','deleted','100%',1,NULL,'tempest-VolumesSnapshotTestJSON-Snapshot-1212870530',NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,NULL,NULL,NULL,1),('2025-12-05 10:15:05','2025-12-05 10:15:08','2025-12-05 10:15:09',1,'88b5b801-3396-41a1-ac2e-479f5320ad2a','e22ad6a9-4871-4381-bdd9-9f116dc63da5','fd04e228d1eb408a9a73c48142a34a70','c8125d7d8c2c4e869c6cf854824ed1f9','deleted','100%',1,NULL,'tempest-VolumesExtendTest-Snapshot-1613245733',NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,NULL,NULL,NULL,1),('2025-12-05 10:16:14','2025-12-05 10:16:18','2025-12-05 10:16:18',1,'8a4a7e5b-b24b-41ad-8fe3-230cadc4d1ff','322e4bc1-9be4-471f-a5ab-a8285cad9e99','0ab0e0dead37412ebd73c839224d4687','ebf51e9cd741494484f25cc0c15bc318','deleted','100%',1,NULL,'tempest-GroupSnapshotsTest-Group_Snapshot-656961793',NULL,NULL,NULL,'18d2d611-0b44-4c06-b445-cb3ed9593cbd',NULL,NULL,NULL,'7b3d1430-4aff-4541-83d0-31770b3122c6',1),('2025-12-05 10:10:11','2025-12-05 10:10:14','2025-12-05 10:10:14',1,'9165682d-6520-4720-b88c-85b7d334eae5','3e0b70c8-8e7a-43f5-973d-025d560b1f28','0b6b4749f27a4147ae07b8cb40737288','3e1f2363f1af446095b256c4564bb0fe','deleted','100%',1,NULL,'tempest-GroupSnapshotsV319Test-Group_Snapshot-757351754',NULL,NULL,NULL,'bd320a63-3f97-42bf-ac48-f50309021fde',NULL,NULL,NULL,'d9dbcd53-d637-4b7d-a457-f4c6d104a40d',1),('2025-12-05 10:12:10','2025-12-05 10:12:13','2025-12-05 10:12:15',1,'d4fb4bbc-430c-485a-b547-137298f0c09f','3a64d4f9-8506-4b6e-bfad-e6d16b962a09','04505938eab74d378aaf8b4824feba84','9e3d3287162a4caabf625f0490cbd91d','deleted','100%',1,NULL,'tempest-VolumesSnapshotListTestJSON-Snapshot-362433991',NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,NULL,NULL,NULL,1),('2025-12-05 10:15:57','2025-12-05 10:16:13','2025-12-05 10:16:14',1,'e2291a3e-d29d-4264-81ed-f71c111e70a9','1a46f21f-48ca-4b71-88f2-f5de462fc26b','b36dfd3363184111af20acb3ebaee28a','ee708d36384c422aad0ff42f0242e9cf','deleted','80%',1,NULL,'tempest-SnapshotsActionsTest-Snapshot-603986801',NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,NULL,NULL,NULL,1),('2025-12-05 10:12:09','2025-12-05 10:12:15','2025-12-05 10:12:17',1,'eee63fcf-1703-4b16-a506-4c196deeab60','3a64d4f9-8506-4b6e-bfad-e6d16b962a09','04505938eab74d378aaf8b4824feba84','9e3d3287162a4caabf625f0490cbd91d','deleted','100%',1,NULL,'tempest-VolumesSnapshotListTestJSON-Snapshot-2011920391',NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,NULL,NULL,NULL,1),('2025-12-05 10:16:06','2025-12-05 10:16:07','2025-12-05 10:16:09',1,'f442e905-db84-4bec-950e-e4b8ebb11a3c','1a46f21f-48ca-4b71-88f2-f5de462fc26b','b36dfd3363184111af20acb3ebaee28a','ee708d36384c422aad0ff42f0242e9cf','deleted','100%',1,NULL,'tempest-SnapshotsActionsTest-Snapshot-941750019',NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,NULL,NULL,NULL,1);
/*!40000 ALTER TABLE `snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `no_snapshots` tinyint(1) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_transfers_volume_id` (`volume_id`),
  CONSTRAINT `transfers_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`no_snapshots` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
INSERT INTO `transfers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `display_name`, `salt`, `crypt_hash`, `expires_at`, `no_snapshots`, `source_project_id`, `destination_project_id`, `accepted`) VALUES ('2025-12-05 10:16:58',NULL,'2025-12-05 10:16:59',1,'052687a1-0b98-4891-932d-fed19559b69a','a1eec010-2ac9-4203-a61b-9d5dd7c207c7',NULL,'799e43d5','6c3b135866f5193e14ab1add37a834b297c092dc',NULL,0,'d088e308e3994594b72dd5ba899ec7e3','5e9a7e52b379438eab65d860aa70af42',1),('2025-12-05 10:13:48',NULL,'2025-12-05 10:13:49',1,'387f98fa-fc51-4e9e-b51e-8b2833b5e43e','f3138902-71b2-421d-b3f1-e59ccc62b5c6',NULL,'79b8dc24','e9746e766a5903f264968a2c6212ad5786d8ecf6',NULL,0,'a5cc8e8a222a4340a4dc0e0a353a820c',NULL,0),('2025-12-05 10:10:19',NULL,'2025-12-05 10:10:20',1,'6eb3c397-8a4e-4ae7-a64c-dd636e95000b','0d507bf1-ee18-49cb-998a-70e7b2e85f4f',NULL,'8b579de9','fa7409caa10c90bf8aa1cd99a1732fc78aa1be6b',NULL,0,'584e347c69994bcbb195242db0534134','7864fe2bcb66461095dedc4deed01501',1),('2025-12-05 10:13:43',NULL,'2025-12-05 10:13:44',1,'8f7d9daa-448b-4136-b6ad-f5ce38701523','a2d4706a-b272-4936-b628-0b994ead16f6',NULL,'5c58b843','846bba2cdcc93aecf73aa408b356bd53ebed6842',NULL,0,'a5cc8e8a222a4340a4dc0e0a353a820c','11c68ad07fe34e07ad5a591f23d30263',1),('2025-12-05 10:10:54',NULL,'2025-12-05 10:10:54',1,'ba837695-89f2-4ef0-b96b-972071a06921','b8c5244e-6312-435e-b860-6ac3912c02a0',NULL,'d6f36256','4555d0b678a7dc0c0f0af1e353cb5d533af15f26',NULL,0,'b984bc032821439da9e14438f496b701',NULL,0),('2025-12-05 10:17:01',NULL,'2025-12-05 10:17:01',1,'c6215c55-d745-4756-b67c-fe90fdaf2490','689ae24d-869e-49ba-b3e9-2ec842129f85',NULL,'94499a4d','08414cb72e292009cf24291e75b32ae47bff7a9e',NULL,0,'d088e308e3994594b72dd5ba899ec7e3',NULL,0),('2025-12-05 10:10:50',NULL,'2025-12-05 10:10:51',1,'ec8550a1-64e2-4271-9ca3-79142991d149','26e220d6-214a-40e6-adb0-1022000eac07',NULL,'f6a4f79e','c07bcdee7c347e66b1c9e3eb01e834821b50a2d1',NULL,0,'b984bc032821439da9e14438f496b701','b0b9e4dc414946c097d558d4b89e8947',1);
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_admin_metadata`
--

DROP TABLE IF EXISTS `volume_admin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_admin_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_admin_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_admin_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_admin_metadata`
--

LOCK TABLES `volume_admin_metadata` WRITE;
/*!40000 ALTER TABLE `volume_admin_metadata` DISABLE KEYS */;
INSERT INTO `volume_admin_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `key`, `value`) VALUES ('2025-12-05 10:14:26','2025-12-05 10:14:26','2025-12-05 10:15:18',1,1,'535812c8-a387-4348-b655-5e810207ac5a','readonly','False'),('2025-12-05 10:18:57',NULL,'2025-12-05 10:19:13',1,2,'1086f8e3-66e7-4f76-a93d-9da9597c1c53','temporary','True');
/*!40000 ALTER TABLE `volume_admin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_attachment`
--

DROP TABLE IF EXISTS `volume_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_attachment` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `attached_host` varchar(255) DEFAULT NULL,
  `instance_uuid` varchar(36) DEFAULT NULL,
  `mountpoint` varchar(255) DEFAULT NULL,
  `attach_time` datetime DEFAULT NULL,
  `detach_time` datetime DEFAULT NULL,
  `attach_mode` varchar(36) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `connection_info` text DEFAULT NULL,
  `connector` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_attachment_volume_id` (`volume_id`),
  CONSTRAINT `volume_attachment_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_attachment`
--

LOCK TABLES `volume_attachment` WRITE;
/*!40000 ALTER TABLE `volume_attachment` DISABLE KEYS */;
INSERT INTO `volume_attachment` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `attached_host`, `instance_uuid`, `mountpoint`, `attach_time`, `detach_time`, `attach_mode`, `attach_status`, `connection_info`, `connector`) VALUES ('2025-12-05 10:18:02','2025-12-05 10:18:25','2025-12-05 10:18:25',1,'700f71d7-2eb6-4023-9419-e493904847e4','c4d37f21-a692-4fd8-a5cf-3ec6f97372f0','np0005546420.localdomain','be3af3e0-e77e-4be9-9458-b874e91bdd42','/dev/vdb','2025-12-05 10:18:04','2025-12-05 10:18:25','rw','detached','{\"name\": \"volumes/volume-c4d37f21-a692-4fd8-a5cf-3ec6f97372f0\", \"hosts\": [\"172.18.0.103\", \"172.18.0.104\", \"172.18.0.105\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"79feddb1-4bfc-557f-83b9-0d57c9f66c1b\", \"volume_id\": \"c4d37f21-a692-4fd8-a5cf-3ec6f97372f0\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"700f71d7-2eb6-4023-9419-e493904847e4\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.107\", \"host\": \"np0005546420.localdomain\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:4f5bb6fc28b8\", \"do_local_attach\": false, \"nvme_hostid\": \"38a014e5-f211-4fa1-8868-c362af7c3bc6\", \"system uuid\": \"38a014e5-f211-4fa1-8868-c362af7c3bc6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:38a014e5-f211-4fa1-8868-c362af7c3bc6\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}');
/*!40000 ALTER TABLE `volume_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_glance_metadata`
--

DROP TABLE IF EXISTS `volume_glance_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_glance_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_glance_metadata_snapshot_id` (`snapshot_id`),
  KEY `ix_volume_glance_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_glance_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `volume_glance_metadata_ibfk_2` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_glance_metadata`
--

LOCK TABLES `volume_glance_metadata` WRITE;
/*!40000 ALTER TABLE `volume_glance_metadata` DISABLE KEYS */;
INSERT INTO `volume_glance_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `snapshot_id`, `key`, `value`) VALUES ('2025-12-05 10:09:12',NULL,'2025-12-05 10:09:19',1,1,'08740d7c-bac5-4ea7-8645-79d12e42d273',NULL,'signature_verified','False'),('2025-12-05 10:09:16',NULL,'2025-12-05 10:09:19',1,2,'08740d7c-bac5-4ea7-8645-79d12e42d273',NULL,'hw_rng_model','virtio'),('2025-12-05 10:09:16','2025-12-05 10:09:17','2025-12-05 10:09:19',1,3,'08740d7c-bac5-4ea7-8645-79d12e42d273',NULL,'image_id','5137a025-3c5f-43c1-bc64-5f41270040a5'),('2025-12-05 10:09:16','2025-12-05 10:09:17','2025-12-05 10:09:19',1,4,'08740d7c-bac5-4ea7-8645-79d12e42d273',NULL,'image_name','image'),('2025-12-05 10:09:16',NULL,'2025-12-05 10:09:19',1,5,'08740d7c-bac5-4ea7-8645-79d12e42d273',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-05 10:09:16',NULL,'2025-12-05 10:09:19',1,6,'08740d7c-bac5-4ea7-8645-79d12e42d273',NULL,'container_format','bare'),('2025-12-05 10:09:16',NULL,'2025-12-05 10:09:19',1,7,'08740d7c-bac5-4ea7-8645-79d12e42d273',NULL,'disk_format','qcow2'),('2025-12-05 10:09:16',NULL,'2025-12-05 10:09:19',1,8,'08740d7c-bac5-4ea7-8645-79d12e42d273',NULL,'min_disk','0'),('2025-12-05 10:09:16',NULL,'2025-12-05 10:09:19',1,9,'08740d7c-bac5-4ea7-8645-79d12e42d273',NULL,'min_ram','0'),('2025-12-05 10:09:16',NULL,'2025-12-05 10:09:19',1,10,'08740d7c-bac5-4ea7-8645-79d12e42d273',NULL,'size','21430272'),('2025-12-05 10:09:17',NULL,'2025-12-05 10:09:19',1,11,'08740d7c-bac5-4ea7-8645-79d12e42d273',NULL,'kernel_id','6ff710d2-942b-4d6b-9168-8c9cc2404ab1'),('2025-12-05 10:09:17',NULL,'2025-12-05 10:09:18',1,12,'08740d7c-bac5-4ea7-8645-79d12e42d273',NULL,'ramdisk_id','somedisk'),('2025-12-05 10:11:31',NULL,'2025-12-05 10:11:41',1,13,'721746dc-0ac3-4e82-9920-8a7945c95b08',NULL,'signature_verified','False'),('2025-12-05 10:11:36',NULL,'2025-12-05 10:11:41',1,14,'721746dc-0ac3-4e82-9920-8a7945c95b08',NULL,'hw_rng_model','virtio'),('2025-12-05 10:11:36',NULL,'2025-12-05 10:11:41',1,15,'721746dc-0ac3-4e82-9920-8a7945c95b08',NULL,'image_id','3647d20f-5e09-41b2-a6f3-f320b9e4e343'),('2025-12-05 10:11:36',NULL,'2025-12-05 10:11:41',1,16,'721746dc-0ac3-4e82-9920-8a7945c95b08',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-05 10:11:36',NULL,'2025-12-05 10:11:41',1,17,'721746dc-0ac3-4e82-9920-8a7945c95b08',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-05 10:11:36',NULL,'2025-12-05 10:11:41',1,18,'721746dc-0ac3-4e82-9920-8a7945c95b08',NULL,'container_format','bare'),('2025-12-05 10:11:36',NULL,'2025-12-05 10:11:41',1,19,'721746dc-0ac3-4e82-9920-8a7945c95b08',NULL,'disk_format','qcow2'),('2025-12-05 10:11:36',NULL,'2025-12-05 10:11:41',1,20,'721746dc-0ac3-4e82-9920-8a7945c95b08',NULL,'min_disk','0'),('2025-12-05 10:11:36',NULL,'2025-12-05 10:11:41',1,21,'721746dc-0ac3-4e82-9920-8a7945c95b08',NULL,'min_ram','0'),('2025-12-05 10:11:36',NULL,'2025-12-05 10:11:41',1,22,'721746dc-0ac3-4e82-9920-8a7945c95b08',NULL,'size','21430272'),('2025-12-05 10:11:38',NULL,'2025-12-05 10:11:40',1,23,'1e9e94b5-5fb5-4f0c-990f-5a092753398a',NULL,'signature_verified','False'),('2025-12-05 10:11:38',NULL,'2025-12-05 10:11:40',1,24,'1e9e94b5-5fb5-4f0c-990f-5a092753398a',NULL,'hw_rng_model','virtio'),('2025-12-05 10:11:38',NULL,'2025-12-05 10:11:40',1,25,'1e9e94b5-5fb5-4f0c-990f-5a092753398a',NULL,'image_id','3647d20f-5e09-41b2-a6f3-f320b9e4e343'),('2025-12-05 10:11:38',NULL,'2025-12-05 10:11:40',1,26,'1e9e94b5-5fb5-4f0c-990f-5a092753398a',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-05 10:11:38',NULL,'2025-12-05 10:11:40',1,27,'1e9e94b5-5fb5-4f0c-990f-5a092753398a',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-05 10:11:38',NULL,'2025-12-05 10:11:40',1,28,'1e9e94b5-5fb5-4f0c-990f-5a092753398a',NULL,'container_format','bare'),('2025-12-05 10:11:38',NULL,'2025-12-05 10:11:40',1,29,'1e9e94b5-5fb5-4f0c-990f-5a092753398a',NULL,'disk_format','qcow2'),('2025-12-05 10:11:38',NULL,'2025-12-05 10:11:40',1,30,'1e9e94b5-5fb5-4f0c-990f-5a092753398a',NULL,'min_disk','0'),('2025-12-05 10:11:38',NULL,'2025-12-05 10:11:40',1,31,'1e9e94b5-5fb5-4f0c-990f-5a092753398a',NULL,'min_ram','0'),('2025-12-05 10:11:38',NULL,'2025-12-05 10:11:40',1,32,'1e9e94b5-5fb5-4f0c-990f-5a092753398a',NULL,'size','21430272'),('2025-12-05 10:14:49',NULL,'2025-12-05 10:15:01',1,33,'83b6b251-1465-47bd-8e31-77cbf8c06287',NULL,'signature_verified','False'),('2025-12-05 10:14:51',NULL,'2025-12-05 10:15:06',1,34,'a107e9ae-d949-421b-b349-b441d42f2f9b',NULL,'signature_verified','False'),('2025-12-05 10:14:56',NULL,'2025-12-05 10:15:01',1,35,'83b6b251-1465-47bd-8e31-77cbf8c06287',NULL,'hw_rng_model','virtio'),('2025-12-05 10:14:56',NULL,'2025-12-05 10:15:01',1,36,'83b6b251-1465-47bd-8e31-77cbf8c06287',NULL,'image_id','3647d20f-5e09-41b2-a6f3-f320b9e4e343'),('2025-12-05 10:14:56',NULL,'2025-12-05 10:15:01',1,37,'83b6b251-1465-47bd-8e31-77cbf8c06287',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-05 10:14:56',NULL,'2025-12-05 10:15:01',1,38,'83b6b251-1465-47bd-8e31-77cbf8c06287',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-05 10:14:56',NULL,'2025-12-05 10:15:01',1,39,'83b6b251-1465-47bd-8e31-77cbf8c06287',NULL,'container_format','bare'),('2025-12-05 10:14:56',NULL,'2025-12-05 10:15:01',1,40,'83b6b251-1465-47bd-8e31-77cbf8c06287',NULL,'disk_format','qcow2'),('2025-12-05 10:14:56',NULL,'2025-12-05 10:15:01',1,41,'83b6b251-1465-47bd-8e31-77cbf8c06287',NULL,'min_disk','0'),('2025-12-05 10:14:56',NULL,'2025-12-05 10:15:01',1,42,'83b6b251-1465-47bd-8e31-77cbf8c06287',NULL,'min_ram','0'),('2025-12-05 10:14:56',NULL,'2025-12-05 10:15:01',1,43,'83b6b251-1465-47bd-8e31-77cbf8c06287',NULL,'size','21430272'),('2025-12-05 10:14:58',NULL,'2025-12-05 10:15:06',1,44,'a107e9ae-d949-421b-b349-b441d42f2f9b',NULL,'hw_rng_model','virtio'),('2025-12-05 10:14:58',NULL,'2025-12-05 10:15:06',1,45,'a107e9ae-d949-421b-b349-b441d42f2f9b',NULL,'image_id','3647d20f-5e09-41b2-a6f3-f320b9e4e343'),('2025-12-05 10:14:58',NULL,'2025-12-05 10:15:06',1,46,'a107e9ae-d949-421b-b349-b441d42f2f9b',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-05 10:14:58',NULL,'2025-12-05 10:15:06',1,47,'a107e9ae-d949-421b-b349-b441d42f2f9b',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-05 10:14:58',NULL,'2025-12-05 10:15:06',1,48,'a107e9ae-d949-421b-b349-b441d42f2f9b',NULL,'container_format','bare'),('2025-12-05 10:14:58',NULL,'2025-12-05 10:15:06',1,49,'a107e9ae-d949-421b-b349-b441d42f2f9b',NULL,'disk_format','qcow2'),('2025-12-05 10:14:58',NULL,'2025-12-05 10:15:06',1,50,'a107e9ae-d949-421b-b349-b441d42f2f9b',NULL,'min_disk','0'),('2025-12-05 10:14:58',NULL,'2025-12-05 10:15:06',1,51,'a107e9ae-d949-421b-b349-b441d42f2f9b',NULL,'min_ram','0'),('2025-12-05 10:14:58',NULL,'2025-12-05 10:15:06',1,52,'a107e9ae-d949-421b-b349-b441d42f2f9b',NULL,'size','21430272'),('2025-12-05 10:16:56',NULL,'2025-12-05 10:17:14',1,53,'4fbacb38-5f3a-4696-a23a-bc0346bd5477',NULL,'signature_verified','False'),('2025-12-05 10:16:59',NULL,'2025-12-05 10:17:14',1,54,'4fbacb38-5f3a-4696-a23a-bc0346bd5477',NULL,'hw_rng_model','virtio'),('2025-12-05 10:16:59',NULL,'2025-12-05 10:17:14',1,55,'4fbacb38-5f3a-4696-a23a-bc0346bd5477',NULL,'image_id','3647d20f-5e09-41b2-a6f3-f320b9e4e343'),('2025-12-05 10:16:59',NULL,'2025-12-05 10:17:14',1,56,'4fbacb38-5f3a-4696-a23a-bc0346bd5477',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-05 10:16:59',NULL,'2025-12-05 10:17:14',1,57,'4fbacb38-5f3a-4696-a23a-bc0346bd5477',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-05 10:16:59',NULL,'2025-12-05 10:17:14',1,58,'4fbacb38-5f3a-4696-a23a-bc0346bd5477',NULL,'container_format','bare'),('2025-12-05 10:16:59',NULL,'2025-12-05 10:17:14',1,59,'4fbacb38-5f3a-4696-a23a-bc0346bd5477',NULL,'disk_format','qcow2'),('2025-12-05 10:16:59',NULL,'2025-12-05 10:17:14',1,60,'4fbacb38-5f3a-4696-a23a-bc0346bd5477',NULL,'min_disk','0'),('2025-12-05 10:16:59',NULL,'2025-12-05 10:17:14',1,61,'4fbacb38-5f3a-4696-a23a-bc0346bd5477',NULL,'min_ram','0'),('2025-12-05 10:16:59',NULL,'2025-12-05 10:17:14',1,62,'4fbacb38-5f3a-4696-a23a-bc0346bd5477',NULL,'size','21430272'),('2025-12-05 10:17:08',NULL,'2025-12-05 10:17:10',1,63,'0acaddf6-99c4-4b5c-b931-29c7c402f0f5',NULL,'signature_verified','False'),('2025-12-05 10:17:08',NULL,'2025-12-05 10:17:10',1,64,'0acaddf6-99c4-4b5c-b931-29c7c402f0f5',NULL,'hw_rng_model','virtio'),('2025-12-05 10:17:08',NULL,'2025-12-05 10:17:10',1,65,'0acaddf6-99c4-4b5c-b931-29c7c402f0f5',NULL,'image_id','3647d20f-5e09-41b2-a6f3-f320b9e4e343'),('2025-12-05 10:17:08',NULL,'2025-12-05 10:17:10',1,66,'0acaddf6-99c4-4b5c-b931-29c7c402f0f5',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-05 10:17:08',NULL,'2025-12-05 10:17:10',1,67,'0acaddf6-99c4-4b5c-b931-29c7c402f0f5',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-05 10:17:08',NULL,'2025-12-05 10:17:10',1,68,'0acaddf6-99c4-4b5c-b931-29c7c402f0f5',NULL,'container_format','bare'),('2025-12-05 10:17:08',NULL,'2025-12-05 10:17:10',1,69,'0acaddf6-99c4-4b5c-b931-29c7c402f0f5',NULL,'disk_format','qcow2'),('2025-12-05 10:17:08',NULL,'2025-12-05 10:17:10',1,70,'0acaddf6-99c4-4b5c-b931-29c7c402f0f5',NULL,'min_disk','0'),('2025-12-05 10:17:08',NULL,'2025-12-05 10:17:10',1,71,'0acaddf6-99c4-4b5c-b931-29c7c402f0f5',NULL,'min_ram','0'),('2025-12-05 10:17:08',NULL,'2025-12-05 10:17:10',1,72,'0acaddf6-99c4-4b5c-b931-29c7c402f0f5',NULL,'size','21430272');
/*!40000 ALTER TABLE `volume_glance_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_metadata`
--

DROP TABLE IF EXISTS `volume_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_metadata`
--

LOCK TABLES `volume_metadata` WRITE;
/*!40000 ALTER TABLE `volume_metadata` DISABLE KEYS */;
INSERT INTO `volume_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `key`, `value`) VALUES ('2025-12-05 10:09:24','2025-12-05 10:09:24','2025-12-05 10:09:24',1,1,'b1d95890-88f3-4860-aebf-52eec4a985a0','key1','value1_update'),('2025-12-05 10:09:24','2025-12-05 10:09:24','2025-12-05 10:09:24',1,2,'b1d95890-88f3-4860-aebf-52eec4a985a0','key2','value2'),('2025-12-05 10:09:24','2025-12-05 10:09:24','2025-12-05 10:09:24',1,3,'b1d95890-88f3-4860-aebf-52eec4a985a0','key3','value3'),('2025-12-05 10:09:24','2025-12-05 10:09:24','2025-12-05 10:09:24',1,4,'b1d95890-88f3-4860-aebf-52eec4a985a0','key4','value4'),('2025-12-05 10:09:24','2025-12-05 10:09:25','2025-12-05 10:09:25',1,5,'b1d95890-88f3-4860-aebf-52eec4a985a0','key1','value1'),('2025-12-05 10:09:24','2025-12-05 10:09:25','2025-12-05 10:09:25',1,6,'b1d95890-88f3-4860-aebf-52eec4a985a0','key2','value2'),('2025-12-05 10:09:24','2025-12-05 10:09:25','2025-12-05 10:09:25',1,7,'b1d95890-88f3-4860-aebf-52eec4a985a0','key3','value3_update'),('2025-12-05 10:12:40',NULL,'2025-12-05 10:12:42',1,8,'37411969-9d03-4177-b129-4f96f57802bf','src_backup_id','fb2b310c-a127-4cb1-8176-8e0f63a4f16e'),('2025-12-05 10:14:26',NULL,'2025-12-05 10:14:32',1,9,'3727da3c-32a5-4aaf-9764-56458c75be02','Type','Test'),('2025-12-05 10:14:34',NULL,'2025-12-05 10:14:46',1,10,'60a63fd4-a640-43cf-8a38-d05c7a16678d','Type','Test'),('2025-12-05 10:14:49',NULL,'2025-12-05 10:15:06',1,11,'a107e9ae-d949-421b-b349-b441d42f2f9b','Type','Test'),('2025-12-05 10:15:12',NULL,'2025-12-05 10:15:23',1,12,'4fe425de-0fea-4eda-8ffa-d61a1a910038','Type','work'),('2025-12-05 10:15:14',NULL,'2025-12-05 10:15:20',1,13,'03c054c9-12a3-4df5-a2d8-bb077677a2a0','Type','work'),('2025-12-05 10:15:16',NULL,'2025-12-05 10:15:19',1,14,'64fd9579-0ea3-44d7-ae9e-03df3f072f97','Type','work'),('2025-12-05 10:17:08',NULL,'2025-12-05 10:17:10',1,15,'0acaddf6-99c4-4b5c-b931-29c7c402f0f5','src_backup_id','1744acaa-9e34-49c1-8031-dbeeec87ecfe');
/*!40000 ALTER TABLE `volume_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_extra_specs`
--

DROP TABLE IF EXISTS `volume_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_extra_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_type_extra_specs_volume_type_id` (`volume_type_id`),
  CONSTRAINT `volume_type_extra_specs_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_extra_specs`
--

LOCK TABLES `volume_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `volume_type_extra_specs` DISABLE KEYS */;
INSERT INTO `volume_type_extra_specs` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_type_id`, `key`, `value`) VALUES ('2025-12-05 10:10:31',NULL,'2025-12-05 10:10:32',1,1,'fd6b4535-011c-42b3-8d77-24245000d218','spec1','val1'),('2025-12-05 10:12:52',NULL,'2025-12-05 10:12:54',1,2,'56d42343-925f-4e9a-a12c-83f788849536','storage_protocol','tempest-storage_protocol-878466770'),('2025-12-05 10:12:52',NULL,'2025-12-05 10:12:54',1,3,'56d42343-925f-4e9a-a12c-83f788849536','vendor_name','tempest-vendor_name-1241341677'),('2025-12-05 10:12:54',NULL,'2025-12-05 10:12:57',1,4,'03b5cfd8-2964-401d-8ce7-049ee88d39c4','storage_protocol','tempest-storage_protocol-728802553'),('2025-12-05 10:12:54',NULL,'2025-12-05 10:12:57',1,5,'03b5cfd8-2964-401d-8ce7-049ee88d39c4','vendor_name','tempest-vendor_name-1958728677'),('2025-12-05 10:13:40',NULL,'2025-12-05 10:13:41',1,6,'a0fbfb79-bb71-4579-a86b-4df33b092405','storage_protocol','iSCSI'),('2025-12-05 10:13:40',NULL,'2025-12-05 10:13:41',1,7,'a0fbfb79-bb71-4579-a86b-4df33b092405','vendor_name','Open Source'),('2025-12-05 10:16:37',NULL,'2025-12-05 10:16:37',1,8,'ccca26dd-596a-4c19-8320-a9353a87dc14','spec3','val1'),('2025-12-05 10:16:37',NULL,'2025-12-05 10:16:38',1,9,'ccca26dd-596a-4c19-8320-a9353a87dc14','spec1','val1'),('2025-12-05 10:16:38','2025-12-05 10:16:38','2025-12-05 10:16:38',1,10,'ccca26dd-596a-4c19-8320-a9353a87dc14','spec2','val3'),('2025-12-05 10:16:38',NULL,'2025-12-05 10:16:38',1,11,'ccca26dd-596a-4c19-8320-a9353a87dc14','spec4','val4');
/*!40000 ALTER TABLE `volume_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_projects`
--

DROP TABLE IF EXISTS `volume_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `volume_type_id` (`volume_type_id`,`project_id`,`deleted`),
  CONSTRAINT `volume_type_projects_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_projects`
--

LOCK TABLES `volume_type_projects` WRITE;
/*!40000 ALTER TABLE `volume_type_projects` DISABLE KEYS */;
INSERT INTO `volume_type_projects` (`id`, `created_at`, `updated_at`, `deleted_at`, `volume_type_id`, `project_id`, `deleted`) VALUES (1,'2025-12-05 10:16:34',NULL,'2025-12-05 10:16:37','02263f1c-1117-4769-b0ef-9e4a9e69f85d','86ef6c5dc1f040a8b67b31bc6f6dc5dd',1),(2,'2025-12-05 10:16:37',NULL,'2025-12-05 10:16:37','f4d05d71-2f30-443b-9d89-fd929f81c6df','86ef6c5dc1f040a8b67b31bc6f6dc5dd',2),(3,'2025-12-05 10:16:37',NULL,'2025-12-05 10:16:37','f4d05d71-2f30-443b-9d89-fd929f81c6df','56caa18f7b6e4db394f385a2e76c009a',3);
/*!40000 ALTER TABLE `volume_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_types`
--

DROP TABLE IF EXISTS `volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `qos_specs_id` varchar(36) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_types_qos_specs_id` (`qos_specs_id`),
  CONSTRAINT `volume_types_ibfk_1` FOREIGN KEY (`qos_specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`is_public` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_types`
--

LOCK TABLES `volume_types` WRITE;
/*!40000 ALTER TABLE `volume_types` DISABLE KEYS */;
INSERT INTO `volume_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `qos_specs_id`, `is_public`, `description`) VALUES ('2025-12-05 10:16:33',NULL,'2025-12-05 10:16:37',1,'02263f1c-1117-4769-b0ef-9e4a9e69f85d','tempest-VolumeTypesAccessTest-volume-type-1193441138',NULL,0,NULL),('2025-12-05 10:12:54',NULL,'2025-12-05 10:12:57',1,'03b5cfd8-2964-401d-8ce7-049ee88d39c4','tempest-UserMessagesTest-volume-type-1380476665',NULL,1,NULL),('2025-12-05 10:15:41','2025-12-05 10:15:42','2025-12-05 10:15:44',1,'0f46f4ed-04d9-476d-854c-e2c66267bba2','tempest-QosSpecsTestJSON-volume-type-803133472',NULL,1,NULL),('2025-12-05 10:16:04',NULL,'2025-12-05 10:16:20',1,'18d2d611-0b44-4c06-b445-cb3ed9593cbd','tempest-GroupSnapshotsTest-volume-type-2140127089',NULL,1,NULL),('2025-12-05 10:15:41','2025-12-05 10:15:42','2025-12-05 10:15:44',1,'20dd2c8e-c2da-4d90-9f3d-9579d118f64a','tempest-QosSpecsTestJSON-volume-type-755777512',NULL,1,NULL),('2025-12-05 10:14:06',NULL,'2025-12-05 10:14:06',1,'237eb5fd-3311-4313-87d5-e4e968fd9c40','tempest-VolumeTypesNegativeTest-volume-type-720613461',NULL,0,NULL),('2025-12-05 10:13:13',NULL,'2025-12-05 10:13:14',1,'266335b2-8752-4c9c-b6f0-fe5c5d2ef4f4','tempest-VolumeQuotaClassesTest-volume-type-1281975390',NULL,1,NULL),('2025-12-05 10:15:17',NULL,'2025-12-05 10:15:24',1,'40b6621d-eb24-4e0d-8dae-814d8a2373cc','tempest-GroupsTest-volume-type-1339094509',NULL,1,NULL),('2025-12-05 10:16:19',NULL,'2025-12-05 10:16:23',1,'497fe0fa-b5eb-4f6d-90a3-3dfb8a2728ba','volume-type-1',NULL,1,NULL),('2025-12-05 10:14:07',NULL,'2025-12-05 10:14:07',1,'4f505881-2e3d-4fe6-9cba-fe3e80279fa3','tempest-VolumeTypesNegativeTest-volume-type-1002901494',NULL,1,NULL),('2025-12-05 10:12:52',NULL,'2025-12-05 10:12:54',1,'56d42343-925f-4e9a-a12c-83f788849536','tempest-UserMessagesTest-volume-type-447267446',NULL,1,NULL),('2025-12-05 10:15:51',NULL,'2025-12-05 10:16:04',1,'6e8addcf-37df-4d11-81e1-5968791dd1b8','tempest-GroupSnapshotsTest-volume-type-742511643',NULL,1,NULL),('2025-12-05 10:12:33',NULL,'2025-12-05 10:12:44',1,'7055fc2e-8543-4138-8cec-14be1b270c4e','tempest-GroupsV314Test-volume-type-2079195531',NULL,1,NULL),('2025-12-05 10:16:20',NULL,'2025-12-05 10:16:27',1,'76db33c3-6505-45eb-b8c1-5b9f9af11b08','tempest-GroupSnapshotsTest-volume-type-1934963370',NULL,1,NULL),('2025-12-05 08:17:41','2025-12-05 08:17:41','2025-12-05 08:25:06',1,'7a0977ea-4c21-4a05-ad70-7f9add36a65a','__DEFAULT__',NULL,1,'Default Volume Type'),('2025-12-05 10:15:25',NULL,'2025-12-05 10:15:35',1,'8625fbc3-6d52-4e8a-b238-786ecb766a1a','tempest-GroupsTest-volume-type-211870054',NULL,1,NULL),('2025-12-05 10:16:19',NULL,'2025-12-05 10:16:23',1,'8fb48954-7931-4cfc-987d-20989b51b245','volume-type-2',NULL,1,NULL),('2025-12-05 10:13:41','2025-12-05 10:13:41','2025-12-05 10:13:41',1,'8ffb1345-0463-4fa4-906c-5b03d343f9a9','tempest-volume-type-15190684',NULL,0,'tempest-volume-type-description-2012306759'),('2025-12-05 10:13:41',NULL,'2025-12-05 10:13:41',1,'91d167cb-e763-4d84-b94d-94743c339368','tempest-VolumeTypesTest-volume-type-1696737400',NULL,1,NULL),('2025-12-05 10:10:24',NULL,'2025-12-05 10:10:27',1,'93bf1143-c0ad-4825-b9ce-276674d8c9f2','tempest-GroupsV320Test-volume-type-851984110',NULL,1,NULL),('2025-12-05 10:13:40',NULL,'2025-12-05 10:13:41',1,'a0fbfb79-bb71-4579-a86b-4df33b092405','tempest-VolumeTypesTest-volume-type-441059514',NULL,1,'tempest-volume-type-description-110166276'),('2025-12-05 10:10:08',NULL,'2025-12-05 10:10:17',1,'bd320a63-3f97-42bf-ac48-f50309021fde','tempest-GroupSnapshotsV319Test-volume-type-2075304691',NULL,1,NULL),('2025-12-05 10:16:37',NULL,'2025-12-05 10:16:38',1,'ccca26dd-596a-4c19-8320-a9353a87dc14','tempest-VolumeTypesExtraSpecsTest-volume-type-978802476',NULL,1,NULL),('2025-12-05 10:15:41','2025-12-05 10:15:42','2025-12-05 10:15:44',1,'db01db14-3770-4ed7-b740-821008c2e607','tempest-QosSpecsTestJSON-volume-type-2111161341',NULL,1,NULL),('2025-12-05 08:25:01',NULL,NULL,0,'f0807258-48a3-4cd5-aa87-cc62735457c6','tripleo',NULL,1,NULL),('2025-12-05 10:16:37',NULL,'2025-12-05 10:16:37',1,'f4d05d71-2f30-443b-9d89-fd929f81c6df','tempest-VolumeTypesAccessTest-volume-type-1894522671',NULL,0,NULL),('2025-12-05 10:10:31',NULL,'2025-12-05 10:10:32',1,'fd6b4535-011c-42b3-8d77-24245000d218','tempest-ExtraSpecsNegativeTest-volume-type-1021991438',NULL,1,NULL);
/*!40000 ALTER TABLE `volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ec2_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(256) DEFAULT NULL,
  `provider_auth` varchar(256) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `source_volid` varchar(36) DEFAULT NULL,
  `bootable` tinyint(1) DEFAULT NULL,
  `provider_geometry` varchar(255) DEFAULT NULL,
  `_name_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `migration_status` varchar(255) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  `replication_extended_status` varchar(255) DEFAULT NULL,
  `replication_driver_data` varchar(255) DEFAULT NULL,
  `consistencygroup_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `multiattach` tinyint(1) DEFAULT NULL,
  `previous_status` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `group_id` varchar(36) DEFAULT NULL,
  `service_uuid` varchar(36) DEFAULT NULL,
  `shared_targets` tinyint(1) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volumes_group_id` (`group_id`),
  KEY `ix_volumes_consistencygroup_id` (`consistencygroup_id`),
  KEY `volumes_service_uuid_idx` (`service_uuid`,`deleted`),
  KEY `volumes_deleted_project_id_idx` (`deleted`,`project_id`),
  KEY `volumes_deleted_host_idx` (`deleted`,`host`),
  CONSTRAINT `volumes_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `volumes_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `volumes_ibfk_3` FOREIGN KEY (`service_uuid`) REFERENCES `services` (`uuid`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`bootable` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`multiattach` in (0,1)),
  CONSTRAINT `CONSTRAINT_4` CHECK (`shared_targets` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
INSERT INTO `volumes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `ec2_id`, `user_id`, `project_id`, `host`, `size`, `availability_zone`, `status`, `attach_status`, `scheduled_at`, `launched_at`, `terminated_at`, `display_name`, `display_description`, `provider_location`, `provider_auth`, `snapshot_id`, `volume_type_id`, `source_volid`, `bootable`, `provider_geometry`, `_name_id`, `encryption_key_id`, `migration_status`, `replication_status`, `replication_extended_status`, `replication_driver_data`, `consistencygroup_id`, `provider_id`, `multiattach`, `previous_status`, `cluster_name`, `group_id`, `service_uuid`, `shared_targets`, `use_quota`) VALUES ('2025-12-05 10:14:38','2025-12-05 10:14:40','2025-12-05 10:14:44',1,'00a41234-ec96-4bda-9073-6b5d48ccb4bc',NULL,'dc656680286544cfbe1d69eef0002975','828c13ab111f4c1d9f4fe33b1ba5f907','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:14:38','2025-12-05 10:14:38','2025-12-05 10:14:40','tempest-VolumesGetTest-Volume-282241628',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:11:58','2025-12-05 10:11:59','2025-12-05 10:12:00',1,'017087b9-fa4c-4e26-969f-71068521272b',NULL,'c86f5a4c0d2f4d4b810c0974d0d1101f','07ccd9396684429596646bded13e438a','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2025-12-05 10:11:58','2025-12-05 10:11:58','2025-12-05 10:11:59','tempest-VolumesCloneNegativeTest-Volume-405625657',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:14:32','2025-12-05 10:14:47','2025-12-05 10:14:48',1,'03009ae9-1f40-4d35-8222-19c879f7c6b4',NULL,'dc656680286544cfbe1d69eef0002975','828c13ab111f4c1d9f4fe33b1ba5f907','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:14:33','2025-12-05 10:14:33','2025-12-05 10:14:47','tempest-VolumesGetTest-Volume-759094009',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:15:14','2025-12-05 10:15:20','2025-12-05 10:15:20',1,'03c054c9-12a3-4df5-a2d8-bb077677a2a0',NULL,'eda10b935c07465ead0909a1c82f0b4c','1a4ef1e0bdbf479f861daafd49015589','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:15:14','2025-12-05 10:15:14','2025-12-05 10:15:20','tempest-VolumesListTestJSON-Volume-1251132262',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:16:20','2025-12-05 10:16:22','2025-12-05 10:16:23',1,'07be6fe1-74a5-4902-95a5-0cc80901ec3c',NULL,'c836cf20c2c14810865813e55508c27f','86adc92ecf4e492cbe37cc410ae29e2f','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:16:20','2025-12-05 10:16:20','2025-12-05 10:16:22','tempest-VolumeRetypeWithoutMigrationTest-Volume-1189409422',NULL,NULL,NULL,NULL,'8fb48954-7931-4cfc-987d-20989b51b245',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'available',NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:09:07','2025-12-05 10:09:18','2025-12-05 10:09:19',1,'08740d7c-bac5-4ea7-8645-79d12e42d273',NULL,'b32fc226e983460f8c7bf7d33b0dc4c6','49be837e62ee480f80076382c098e61f','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:09:07','2025-12-05 10:09:16','2025-12-05 10:09:18','tempest-VolumesImageMetadata-Volume-1001886869',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:19:25','2025-12-05 10:19:26','2025-12-05 10:19:27',1,'088917b5-1f83-4bfb-a370-c54c8a6be1bc',NULL,'2150e2e9985942e98ecd4ba9bf2f7997','a6e8880ab10e4b26b0074c6f9b06aca3','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2025-12-05 10:19:25','2025-12-05 10:19:26','2025-12-05 10:19:26','tempest-VolumesSnapshotTestJSON-Volume-372642163',NULL,NULL,NULL,'7d7263a5-5e68-4537-89e1-f70cc435ff34','f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:17:04','2025-12-05 10:17:08','2025-12-05 10:17:10',1,'0acaddf6-99c4-4b5c-b931-29c7c402f0f5',NULL,'0b795e7702e342d9821a3667644be5b0','3554a89b305c449f9fd292eca5647512','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:17:04','2025-12-05 10:17:04','2025-12-05 10:17:08','tempest-VolumesBackupsTest-Volume-171425256',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:11:42','2025-12-05 10:11:48','2025-12-05 10:11:49',1,'0d20d6f7-eb45-4592-afbf-001613866392',NULL,'1828a78b09d1416a8142070cf0ffda3d','2238ffb217584686904f563705640aa4','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:11:42','2025-12-05 10:11:42','2025-12-05 10:11:48','tempest-VolumesCloneTest-Volume-2027412206',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:10:16','2025-12-05 10:10:17','2025-12-05 10:10:17',1,'0d37bb55-7030-4b9a-839e-bd9d2dee1b8d',NULL,'850de70224c74e0f8fa95e10b2773e45','584e347c69994bcbb195242db0534134','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:10:16','2025-12-05 10:10:16','2025-12-05 10:10:17','tempest-VolumeQuotasAdminTestJSON-Volume-998232201',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:10:18','2025-12-05 10:10:20','2025-12-05 10:10:21',1,'0d507bf1-ee18-49cb-998a-70e7b2e85f4f',NULL,'f830ec09ed634dccb75485414633c371','7864fe2bcb66461095dedc4deed01501','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:10:18','2025-12-05 10:10:18','2025-12-05 10:10:20','tempest-VolumeQuotasAdminTestJSON-Volume-1689012713',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:18:57','2025-12-05 10:18:57','2025-12-05 10:19:13',1,'1086f8e3-66e7-4f76-a93d-9da9597c1c53',NULL,'2150e2e9985942e98ecd4ba9bf2f7997','a6e8880ab10e4b26b0074c6f9b06aca3','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached',NULL,NULL,NULL,'backup-vol-bd924392-bd2a-4d46-a0f2-d1997d25543c',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,1,0),('2025-12-05 10:15:55','2025-12-05 10:16:14','2025-12-05 10:16:14',1,'1a46f21f-48ca-4b71-88f2-f5de462fc26b',NULL,'b36dfd3363184111af20acb3ebaee28a','ee708d36384c422aad0ff42f0242e9cf','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:15:55','2025-12-05 10:15:56','2025-12-05 10:16:14','tempest-SnapshotsActionsTest-Volume-1016647184',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:11:37','2025-12-05 10:11:39','2025-12-05 10:11:40',1,'1e9e94b5-5fb5-4f0c-990f-5a092753398a',NULL,'1828a78b09d1416a8142070cf0ffda3d','2238ffb217584686904f563705640aa4','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:11:37','2025-12-05 10:11:38','2025-12-05 10:11:39','tempest-VolumesCloneTest-Volume-908017599',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6','721746dc-0ac3-4e82-9920-8a7945c95b08',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:15:28','2025-12-05 10:15:34','2025-12-05 10:15:34',1,'20ec4860-a3b1-43e7-94fb-8426890bf9e7',NULL,'6545929ffeb5432789d89cea4047c0d5','adb319e7a5f345eeabc757f1c6532ff0','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:15:29','2025-12-05 10:15:29',NULL,'tempest-volume-1597346629',NULL,NULL,NULL,NULL,'8625fbc3-6d52-4e8a-b238-786ecb766a1a',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'54312233-8459-4ec4-942b-fa65d622f0ba','e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:19:22','2025-12-05 10:19:29','2025-12-05 10:19:29',1,'210dd159-3640-4f6e-8ca4-cc9db6915395',NULL,'2150e2e9985942e98ecd4ba9bf2f7997','a6e8880ab10e4b26b0074c6f9b06aca3','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:19:22','2025-12-05 10:19:23','2025-12-05 10:19:29','tempest-VolumesSnapshotTestJSON-Volume-1456489130',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:10:49','2025-12-05 10:10:51','2025-12-05 10:10:52',1,'26e220d6-214a-40e6-adb0-1022000eac07',NULL,'403db31a3fa141538ae12d97f89b9c55','b0b9e4dc414946c097d558d4b89e8947','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:10:49','2025-12-05 10:10:49','2025-12-05 10:10:51','tempest-VolumesTransfersV355Test-Volume-349340061',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:13:20','2025-12-05 10:13:22','2025-12-05 10:13:24',1,'27dcf6fc-bb48-48f1-afdd-661042761702',NULL,'6111072c8292403393a078546c8a54f6','7fb1a3e2a7114f43b78f20d94b35a6b0','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:13:20','2025-12-05 10:13:21','2025-12-05 10:13:22',NULL,NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:08:21','2025-12-05 10:08:22','2025-12-05 10:08:22',1,'300b3acd-19bc-4121-88f3-b56c7394e13d',NULL,'c2f418e692494b02babe78253e2e4d98','6225d95e0a924813958256bdb79de31f','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:08:21','2025-12-05 10:08:21','2025-12-05 10:08:22','tempest-VolumesActionsTest-Volume-802254801',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:16:07','2025-12-05 10:16:19','2025-12-05 10:16:19',1,'322e4bc1-9be4-471f-a5ab-a8285cad9e99',NULL,'0ab0e0dead37412ebd73c839224d4687','ebf51e9cd741494484f25cc0c15bc318','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:16:07','2025-12-05 10:16:07',NULL,'tempest-volume-869210774',NULL,NULL,NULL,NULL,'18d2d611-0b44-4c06-b445-cb3ed9593cbd',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'22ef08d1-97ff-480a-8183-dd197e12f3d4','e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:13:15','2025-12-05 10:13:25','2025-12-05 10:13:26',1,'3469c232-2515-4852-8a9a-a58acbee1d8d',NULL,'dd28487edb064b76be5e30c00312c61b','e230ba0d257c46a2bc100d033851d6b1','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:13:15','2025-12-05 10:13:15','2025-12-05 10:13:25','tempest-VolumesListAdminTestJSON-Volume-1905975452',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:14:05','2025-12-05 10:14:16','2025-12-05 10:14:17',1,'361c4c7d-17ec-4ee7-96bd-e4ee9486523d',NULL,'07ea79a3d5b740eeb0cd19d5221ddaa0','cc5978fe065b4f80b1bc25ce32164997','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:14:06','2025-12-05 10:14:06','2025-12-05 10:14:16','tempest-VolumesDeleteCascade-Volume-1539270786',NULL,NULL,NULL,'486125e6-dfe6-456e-ae90-97058b3a6f8f','f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:14:26','2025-12-05 10:14:31','2025-12-05 10:14:32',1,'3727da3c-32a5-4aaf-9764-56458c75be02',NULL,'dc656680286544cfbe1d69eef0002975','828c13ab111f4c1d9f4fe33b1ba5f907','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:14:26','2025-12-05 10:14:26','2025-12-05 10:14:31','tempest-VolumesGetTest-new-Volume-543141216','This is the new description of volume',NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:12:35','2025-12-05 10:12:41','2025-12-05 10:12:42',1,'37411969-9d03-4177-b129-4f96f57802bf',NULL,'82400d0afa4a43378786350753954e62','02098318982046faa2136ab12b344eb1','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:12:35','2025-12-05 10:12:35','2025-12-05 10:12:41','tempest-VolumesBackupsAdminTest-Volume-1032731716',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:12:05','2025-12-05 10:12:20','2025-12-05 10:12:21',1,'3a64d4f9-8506-4b6e-bfad-e6d16b962a09',NULL,'04505938eab74d378aaf8b4824feba84','9e3d3287162a4caabf625f0490cbd91d','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:12:05','2025-12-05 10:12:06','2025-12-05 10:12:20','tempest-VolumesSnapshotListTestJSON-Volume-1650239636',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:10:10','2025-12-05 10:10:16','2025-12-05 10:10:16',1,'3e0b70c8-8e7a-43f5-973d-025d560b1f28',NULL,'0b6b4749f27a4147ae07b8cb40737288','3e1f2363f1af446095b256c4564bb0fe','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:10:10','2025-12-05 10:10:10',NULL,'tempest-volume-1515927276',NULL,NULL,NULL,NULL,'bd320a63-3f97-42bf-ac48-f50309021fde',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'acaed39e-6a84-4939-afff-282d3bbcbfb3','e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:15:26','2025-12-05 10:15:34','2025-12-05 10:15:34',1,'4029b388-fdcc-406c-a182-559d05efb7ab',NULL,'6545929ffeb5432789d89cea4047c0d5','adb319e7a5f345eeabc757f1c6532ff0','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:15:26','2025-12-05 10:15:27',NULL,'tempest-volume-1276524952',NULL,NULL,NULL,NULL,'8625fbc3-6d52-4e8a-b238-786ecb766a1a',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'54312233-8459-4ec4-942b-fa65d622f0ba','e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:13:16','2025-12-05 10:13:24','2025-12-05 10:13:25',1,'40339d9b-9f4e-4428-bd1e-2c6e7cfa25d6',NULL,'dd28487edb064b76be5e30c00312c61b','e230ba0d257c46a2bc100d033851d6b1','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:13:16','2025-12-05 10:13:16','2025-12-05 10:13:24','tempest-VolumesListAdminTestJSON-Volume-834934753',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:19:30','2025-12-05 10:19:36','2025-12-05 10:19:37',1,'4a3b1124-b529-47be-869a-28a48b62b0a5',NULL,'2150e2e9985942e98ecd4ba9bf2f7997','a6e8880ab10e4b26b0074c6f9b06aca3','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:19:30','2025-12-05 10:19:30','2025-12-05 10:19:36','tempest-VolumesSnapshotTestJSON-Volume-926702528',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:16:54','2025-12-05 10:17:13','2025-12-05 10:17:14',1,'4fbacb38-5f3a-4696-a23a-bc0346bd5477',NULL,'0b795e7702e342d9821a3667644be5b0','3554a89b305c449f9fd292eca5647512','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:16:54','2025-12-05 10:17:00','2025-12-05 10:17:13','tempest-VolumesBackupsTest-Volume-171425256',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:15:12','2025-12-05 10:15:21','2025-12-05 10:15:23',1,'4fe425de-0fea-4eda-8ffa-d61a1a910038',NULL,'eda10b935c07465ead0909a1c82f0b4c','1a4ef1e0bdbf479f861daafd49015589','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:15:12','2025-12-05 10:15:13','2025-12-05 10:15:21','tempest-VolumesListTestJSON-Volume-808825433',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:14:17','2025-12-05 10:15:17','2025-12-05 10:15:18',1,'535812c8-a387-4348-b655-5e810207ac5a',NULL,'846b850f31e94ecc99fd03ac6469acc1','8730b222fadf4a249823e59d8b326dde','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:14:18','2025-12-05 10:14:18','2025-12-05 10:15:17','tempest-VolumesActionsTest-Volume-1533148918',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'available',NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:19:32','2025-12-05 10:19:34','2025-12-05 10:19:34',1,'575ba5a4-4012-4c0d-9445-f54fa2b8b273',NULL,'2150e2e9985942e98ecd4ba9bf2f7997','a6e8880ab10e4b26b0074c6f9b06aca3','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:19:33','2025-12-05 10:19:33','2025-12-05 10:19:34','tempest-VolumesSnapshotTestJSON-Volume-19991974',NULL,NULL,NULL,'2fe03c61-7425-4700-941d-2b1d8aa6e8d7','f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:14:28','2025-12-05 10:14:29','2025-12-05 10:14:30',1,'59a4cbc1-35d2-4883-b300-2f44b3dc66b0',NULL,'dc656680286544cfbe1d69eef0002975','828c13ab111f4c1d9f4fe33b1ba5f907','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:14:28','2025-12-05 10:14:28','2025-12-05 10:14:29','tempest-VolumesGetTest-Volume-1963706649',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:14:34','2025-12-05 10:14:45','2025-12-05 10:14:46',1,'60a63fd4-a640-43cf-8a38-d05c7a16678d',NULL,'dc656680286544cfbe1d69eef0002975','828c13ab111f4c1d9f4fe33b1ba5f907','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:14:34','2025-12-05 10:14:36','2025-12-05 10:14:45','tempest-VolumesGetTest-new-Volume-1802472439','This is the new description of volume',NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6','03009ae9-1f40-4d35-8222-19c879f7c6b4',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:15:16','2025-12-05 10:15:19','2025-12-05 10:15:19',1,'64fd9579-0ea3-44d7-ae9e-03df3f072f97',NULL,'eda10b935c07465ead0909a1c82f0b4c','1a4ef1e0bdbf479f861daafd49015589','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:15:16','2025-12-05 10:15:16','2025-12-05 10:15:19','tempest-VolumesListTestJSON-Volume-443292810',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:17:00','2025-12-05 10:17:02','2025-12-05 10:17:02',1,'689ae24d-869e-49ba-b3e9-2ec842129f85',NULL,'e5e8e9612f364064a6174ec28a4ee206','d088e308e3994594b72dd5ba899ec7e3','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:17:00','2025-12-05 10:17:00','2025-12-05 10:17:02','tempest-VolumesTransfersV357Test-Volume-640574648',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:11:29','2025-12-05 10:11:41','2025-12-05 10:11:41',1,'721746dc-0ac3-4e82-9920-8a7945c95b08',NULL,'1828a78b09d1416a8142070cf0ffda3d','2238ffb217584686904f563705640aa4','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:11:29','2025-12-05 10:11:36','2025-12-05 10:11:41','tempest-VolumesCloneTest-Volume-126444915',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:16:21','2025-12-05 10:16:27','2025-12-05 10:16:27',1,'782a1680-7250-4cba-bcd6-d808521961f6',NULL,'0ab0e0dead37412ebd73c839224d4687','ebf51e9cd741494484f25cc0c15bc318','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:16:21','2025-12-05 10:16:21',NULL,'tempest-volume-1222033626',NULL,NULL,NULL,NULL,'76db33c3-6505-45eb-b8c1-5b9f9af11b08',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'33b7f5c2-9f50-4bd9-bddd-e079de9fbb05','e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:16:06','2025-12-05 10:16:19','2025-12-05 10:16:19',1,'7f24d3b5-3a5f-4832-ae9f-95b7986c3514',NULL,'0ab0e0dead37412ebd73c839224d4687','ebf51e9cd741494484f25cc0c15bc318','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:16:06','2025-12-05 10:16:06',NULL,'tempest-volume-1649728323',NULL,NULL,NULL,NULL,'18d2d611-0b44-4c06-b445-cb3ed9593cbd',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'22ef08d1-97ff-480a-8183-dd197e12f3d4','e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:14:47','2025-12-05 10:14:59','2025-12-05 10:15:01',1,'83b6b251-1465-47bd-8e31-77cbf8c06287',NULL,'fd04e228d1eb408a9a73c48142a34a70','c8125d7d8c2c4e869c6cf854824ed1f9','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2025-12-05 10:14:47','2025-12-05 10:14:57','2025-12-05 10:14:59','tempest-VolumesExtendTest-Volume-1496124906',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'available',NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:09:29','2025-12-05 10:09:38','2025-12-05 10:09:38',1,'88aedac7-fa61-4086-8707-fa1ed4b1195b',NULL,'4cf298dbc85740a9aa682a77067b7864','2eb8cf0d784b4d188f16c04a39a755a9','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:09:29','2025-12-05 10:09:29','2025-12-05 10:09:38','tempest-VolumesNegativeTest-Volume-1739221325',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:12:07','2025-12-05 10:12:14','2025-12-05 10:12:14',1,'92de1783-7991-497e-af1c-086bc93c3569',NULL,'38cd917d57ba40a4bbbdcb831652dbb8','9b06ebc1eb5f4622b3198559907b39ec','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:12:08','2025-12-05 10:12:08','2025-12-05 10:12:14','tempest-VolumeSnapshotQuotasNegativeTestJSON-Volume-2127855086',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:14:59','2025-12-05 10:15:02','2025-12-05 10:15:04',1,'948df2bf-2632-499d-b84a-8d1d02cbe50d',NULL,'dc656680286544cfbe1d69eef0002975','828c13ab111f4c1d9f4fe33b1ba5f907','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:15:01','2025-12-05 10:15:02','2025-12-05 10:15:02','tempest-VolumesGetTest-Volume-562289203',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:12:34','2025-12-05 10:12:43','2025-12-05 10:12:43',1,'95d96a98-06eb-4bea-992c-ece3d15b10d5',NULL,'21e1309d538d4062b4e570e9adf457c6','b3bc4618821f4f30856e76f4b3843b68','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:12:34','2025-12-05 10:12:35',NULL,'tempest-volume-1107629482',NULL,NULL,NULL,NULL,'7055fc2e-8543-4138-8cec-14be1b270c4e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'fda263fb-81d7-4609-83e2-48ddc0e82dd5','e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:13:18','2025-12-05 10:13:22','2025-12-05 10:13:24',1,'97f5f00e-df7f-4434-a048-e192efa4f3e1',NULL,'dd28487edb064b76be5e30c00312c61b','e230ba0d257c46a2bc100d033851d6b1','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:13:18','2025-12-05 10:13:19','2025-12-05 10:13:22','tempest-VolumesListAdminTestJSON-Volume-1843666953',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:12:48','2025-12-05 10:12:56','2025-12-05 10:12:59',1,'9830bc83-4267-4807-9688-39f0c0bc41c4',NULL,'82400d0afa4a43378786350753954e62','02098318982046faa2136ab12b344eb1','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:12:48','2025-12-05 10:12:49','2025-12-05 10:12:56','tempest-VolumesBackupsAdminTest-Volume-2124537332',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:16:30','2025-12-05 10:16:31','2025-12-05 10:16:31',1,'998c6b61-a7e4-4c5f-92d6-b8a8c1b1bde9',NULL,'2a880b5455b140f49e94b72fa40e1fa4','ca51bf8141824cad9d5dcaf468d3909b','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:16:30','2025-12-05 10:16:30','2025-12-05 10:16:31','tempest-VolumesServicesTestJSON-Volume-347039258',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:14:02','2025-12-05 10:14:07','2025-12-05 10:14:15',1,'9a689893-f0c7-4426-9371-d80bb45296b4',NULL,'07ea79a3d5b740eeb0cd19d5221ddaa0','cc5978fe065b4f80b1bc25ce32164997','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:14:03','2025-12-05 10:14:03','2025-12-05 10:14:07','tempest-VolumesDeleteCascade-Volume-2052517490',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:12:27','2025-12-05 10:12:30','2025-12-05 10:12:31',1,'9d073713-de38-46b1-8cc6-2ce7c373d49b',NULL,'d74a7ea03b864e4e88aee448fd739242','ef76e1242a6d41498f75478c52cab8e4','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2025-12-05 10:12:27','2025-12-05 10:12:27','2025-12-05 10:12:30','tempest-VolumesSnapshotNegativeTestJSON-Volume-1144740745',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:15:52','2025-12-05 10:16:04','2025-12-05 10:16:04',1,'9e90e54d-88b4-4fe1-ac0f-6f92dda2b118',NULL,'0ab0e0dead37412ebd73c839224d4687','ebf51e9cd741494484f25cc0c15bc318','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:15:52','2025-12-05 10:15:53',NULL,'tempest-volume-222887058',NULL,NULL,NULL,NULL,'6e8addcf-37df-4d11-81e1-5968791dd1b8',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'78c3eea0-6920-4ee3-a6bc-26417e1ea579','e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:10:41','2025-12-05 10:10:44','2025-12-05 10:10:44',1,'9ecc340f-10b1-485a-a186-09bcfb3f77ac',NULL,'f2ece8800e024bdaa1f8a8c92189b426','e3199c4c895043739e357008afbe83c8','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:10:42','2025-12-05 10:10:43','2025-12-05 10:10:44','tempest-AbsoluteLimitsTests-Volume-1243118576',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:14:49','2025-12-05 10:15:04','2025-12-05 10:15:06',1,'a107e9ae-d949-421b-b349-b441d42f2f9b',NULL,'dc656680286544cfbe1d69eef0002975','828c13ab111f4c1d9f4fe33b1ba5f907','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:14:49','2025-12-05 10:14:58','2025-12-05 10:15:04','tempest-VolumesGetTest-new-Volume-626656070','This is the new description of volume',NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:16:57','2025-12-05 10:16:59','2025-12-05 10:17:00',1,'a1eec010-2ac9-4203-a61b-9d5dd7c207c7',NULL,'a7ac0e41db7a42cbb54f9c62db62f6c4','5e9a7e52b379438eab65d860aa70af42','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:16:57','2025-12-05 10:16:57','2025-12-05 10:16:59','tempest-VolumesTransfersV357Test-Volume-1566589857',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:13:42','2025-12-05 10:13:45','2025-12-05 10:13:46',1,'a2d4706a-b272-4936-b628-0b994ead16f6',NULL,'d35a82592ebd4bcfaa68325260d4853e','11c68ad07fe34e07ad5a591f23d30263','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:13:42','2025-12-05 10:13:42','2025-12-05 10:13:45','tempest-VolumesTransfersTest-Volume-725170746',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:13:25','2025-12-05 10:13:28','2025-12-05 10:13:29',1,'a68abcdf-9846-4b60-bad9-9f580bb6eed9',NULL,'055e2afff9af4c64bd541b695d9c06bc','f67828d1e0ec494fbab56cc9be72430e','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:13:25','2025-12-05 10:13:25','2025-12-05 10:13:28','tempest-VolumeQuotasNegativeTestJSON-Volume-1421211102',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'available',NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:12:37','2025-12-05 10:12:41','2025-12-05 10:12:41',1,'ab57dfb5-31f6-4c74-b566-59917065b1cd',NULL,'21e1309d538d4062b4e570e9adf457c6','b3bc4618821f4f30856e76f4b3843b68','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'7055fc2e-8543-4138-8cec-14be1b270c4e','95d96a98-06eb-4bea-992c-ece3d15b10d5',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'7b6177b4-b209-4556-9d40-09adf5710b51',NULL,1,1),('2025-12-05 10:15:20','2025-12-05 10:15:23','2025-12-05 10:15:23',1,'ac9b2ca8-c810-4560-a50a-e68d8e8410fc',NULL,'6545929ffeb5432789d89cea4047c0d5','adb319e7a5f345eeabc757f1c6532ff0','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:15:20','2025-12-05 10:15:20',NULL,'tempest-volume-1602775649',NULL,NULL,NULL,NULL,'40b6621d-eb24-4e0d-8dae-814d8a2373cc',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'b8899b75-c142-41c4-91c7-2e74ddb7a80b','e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:08:16','2025-12-05 10:08:19','2025-12-05 10:08:20',1,'ae9f3e04-dc92-4976-ab25-45d59bbbe787',NULL,'c2f418e692494b02babe78253e2e4d98','6225d95e0a924813958256bdb79de31f','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:08:16','2025-12-05 10:08:18','2025-12-05 10:08:19','tempest-VolumesActionsTest-Volume-293077908',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:09:23','2025-12-05 10:09:25','2025-12-05 10:09:25',1,'b1d95890-88f3-4860-aebf-52eec4a985a0',NULL,'4b515ad5b8f6457fa2c73b4b47bf1655','eb581b3986ff44adaf0d86d376d9c83a','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:09:23','2025-12-05 10:09:23','2025-12-05 10:09:25','tempest-VolumesMetadataTest-Volume-1306672788',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:10:52','2025-12-05 10:10:56','2025-12-05 10:10:57',1,'b8c5244e-6312-435e-b860-6ac3912c02a0',NULL,'e18ec969e7974e399d570aed064ac229','b984bc032821439da9e14438f496b701','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:10:53','2025-12-05 10:10:53','2025-12-05 10:10:56','tempest-VolumesTransfersV355Test-Volume-843554596',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:11:43','2025-12-05 10:11:46','2025-12-05 10:11:47',1,'bb0b1705-cbf7-4a61-9ab9-1a363ed3102a',NULL,'1828a78b09d1416a8142070cf0ffda3d','2238ffb217584686904f563705640aa4','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2025-12-05 10:11:44','2025-12-05 10:11:45','2025-12-05 10:11:46','tempest-VolumesCloneTest-Volume-109104941',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6','0d20d6f7-eb45-4592-afbf-001613866392',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:16:34','2025-12-05 10:16:36','2025-12-05 10:16:36',1,'bbcccb5f-d90b-4559-b6e1-c1a2b417997d',NULL,'b40e6bc592b2454baf9276a67d2c0a4c','86ef6c5dc1f040a8b67b31bc6f6dc5dd','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:16:34','2025-12-05 10:16:35','2025-12-05 10:16:36','tempest-VolumeTypesAccessTest-Volume-557456288',NULL,NULL,NULL,NULL,'02263f1c-1117-4769-b0ef-9e4a9e69f85d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:18:53','2025-12-05 10:19:37','2025-12-05 10:19:38',1,'bd924392-bd2a-4d46-a0f2-d1997d25543c',NULL,'2150e2e9985942e98ecd4ba9bf2f7997','a6e8880ab10e4b26b0074c6f9b06aca3','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:18:53','2025-12-05 10:18:53','2025-12-05 10:19:37','tempest-VolumesSnapshotTestJSON-Volume-1654652041',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:17:15','2025-12-05 10:18:31','2025-12-05 10:18:34',1,'c4d37f21-a692-4fd8-a5cf-3ec6f97372f0',NULL,'0b795e7702e342d9821a3667644be5b0','3554a89b305c449f9fd292eca5647512','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:17:15','2025-12-05 10:17:15','2025-12-05 10:18:31','tempest-VolumesBackupsTest-Volume-1042491261',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:08:30','2025-12-05 10:08:31','2025-12-05 10:08:32',1,'cd0eae27-6ad2-48b1-a856-53de604b9b5a',NULL,'c2f418e692494b02babe78253e2e4d98','6225d95e0a924813958256bdb79de31f','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:08:30','2025-12-05 10:08:30','2025-12-05 10:08:31','tempest-VolumesActionsTest-Volume-1331530736',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:15:59','2025-12-05 10:16:00','2025-12-05 10:16:00',1,'dc01d8f0-cc5d-44a3-a1fc-7b9e2d880f2e',NULL,'0ab0e0dead37412ebd73c839224d4687','ebf51e9cd741494484f25cc0c15bc318','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'00db2d01-9354-4956-8805-c904dfca90d9','6e8addcf-37df-4d11-81e1-5968791dd1b8',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'749cb853-0471-4d0a-806c-4795bc33c18e',NULL,1,1),('2025-12-05 10:12:24','2025-12-05 10:12:44','2025-12-05 10:12:47',1,'e0807f46-fd36-4bd4-bad7-9e310ec0d261',NULL,'82400d0afa4a43378786350753954e62','02098318982046faa2136ab12b344eb1','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:12:25','2025-12-05 10:12:25','2025-12-05 10:12:44','tempest-VolumesBackupsAdminTest-Volume-1032731716',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:15:04','2025-12-05 10:15:10','2025-12-05 10:15:12',1,'e22ad6a9-4871-4381-bdd9-9f116dc63da5',NULL,'fd04e228d1eb408a9a73c48142a34a70','c8125d7d8c2c4e869c6cf854824ed1f9','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2025-12-05 10:15:04','2025-12-05 10:15:04','2025-12-05 10:15:10','tempest-VolumesExtendTest-Volume-19039836',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'available',NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:12:52','2025-12-05 10:12:53','2025-12-05 10:12:54',1,'e24f1921-6f99-470b-9b90-900e76007bf3',NULL,'d2f2f827112e4b1e93fad9eb478f3294','870ab348edaf49d180b54cf5daaaacd1',NULL,1,'nova','deleted','detached',NULL,NULL,NULL,'tempest-UserMessagesTest-Volume-1603842916',NULL,NULL,NULL,NULL,'56d42343-925f-4e9a-a12c-83f788849536',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,1,1),('2025-12-05 10:14:29','2025-12-05 10:14:38','2025-12-05 10:14:40',1,'e6a5ef5e-61b3-4e54-9555-ee1cbb276bf0',NULL,'9bafdb3b1fe74143a7d72b48cf0e4403','794eae12144d44b683392db77e4b46a0','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:14:29','2025-12-05 10:14:29','2025-12-05 10:14:38','tempest-VolumesBackupsV39Test-Volume-816248865',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:08:23','2025-12-05 10:08:25','2025-12-05 10:08:25',1,'e942eaf6-d0d1-4b8e-b3de-df06e5ef6ba9',NULL,'c2f418e692494b02babe78253e2e4d98','6225d95e0a924813958256bdb79de31f','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:08:23','2025-12-05 10:08:24','2025-12-05 10:08:25','tempest-VolumesActionsTest-Volume-2124603072',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:13:53','2025-12-05 10:13:58','2025-12-05 10:14:01',1,'e998f2d9-820c-4bc8-a8f0-66c10734f807',NULL,'07ea79a3d5b740eeb0cd19d5221ddaa0','cc5978fe065b4f80b1bc25ce32164997','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:13:53','2025-12-05 10:13:53','2025-12-05 10:13:58','tempest-VolumesDeleteCascade-Volume-328644426',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:08:26','2025-12-05 10:08:28','2025-12-05 10:08:29',1,'ea031c12-f742-4ca5-93d3-06a952d58bc7',NULL,'c2f418e692494b02babe78253e2e4d98','6225d95e0a924813958256bdb79de31f','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:08:27','2025-12-05 10:08:28','2025-12-05 10:08:28','tempest-VolumesActionsTest-Volume-1151089439',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:13:47','2025-12-05 10:13:49','2025-12-05 10:13:50',1,'f3138902-71b2-421d-b3f1-e59ccc62b5c6',NULL,'95e284be82e145f3824262c97cf683f6','a5cc8e8a222a4340a4dc0e0a353a820c','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:13:47','2025-12-05 10:13:48','2025-12-05 10:13:49','tempest-VolumesTransfersTest-Volume-630612683',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:16:45','2025-12-05 10:16:50','2025-12-05 10:16:50',1,'fae1fc43-a1c4-4329-ad87-8fa74187de0d',NULL,'54ea334b025445379af9833a9c219695','b0b002e8666a4d4c8dd3481cd357bc82','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-05 10:16:45','2025-12-05 10:16:45','2025-12-05 10:16:50','tempest-SnapshotMetadataTestJSON-Volume-801328355',NULL,NULL,NULL,NULL,'f0807258-48a3-4cd5-aa87-cc62735457c6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'e71bc949-5928-40e6-8443-b54237aa9b5f',0,1),('2025-12-05 10:12:55','2025-12-05 10:12:55','2025-12-05 10:12:57',1,'fbab6d24-0be5-4f76-8d0f-249a147d9abf',NULL,'d2f2f827112e4b1e93fad9eb478f3294','870ab348edaf49d180b54cf5daaaacd1',NULL,1,'nova','deleted','detached',NULL,NULL,NULL,'tempest-UserMessagesTest-Volume-944406422',NULL,NULL,NULL,NULL,'03b5cfd8-2964-401d-8ce7-049ee88d39c4',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,1,1);
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workers`
--

DROP TABLE IF EXISTS `workers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `workers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(40) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  `status` varchar(255) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_type` (`resource_type`,`resource_id`),
  KEY `ix_workers_service_id` (`service_id`),
  CONSTRAINT `workers_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=161 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workers`
--

LOCK TABLES `workers` WRITE;
/*!40000 ALTER TABLE `workers` DISABLE KEYS */;
INSERT INTO `workers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `resource_type`, `resource_id`, `status`, `service_id`, `race_preventer`) VALUES ('2025-12-05 08:17:41','2025-12-05 08:17:41.000123',NULL,0,2,'SENTINEL','SUB-SECOND','OK',NULL,0);
/*!40000 ALTER TABLE `workers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `glance`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `glance` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `glance`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('2023_1_contract01');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_locations`
--

DROP TABLE IF EXISTS `image_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `meta_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `ix_image_locations_deleted` (`deleted`),
  KEY `ix_image_locations_image_id` (`image_id`),
  CONSTRAINT `image_locations_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_locations`
--

LOCK TABLES `image_locations` WRITE;
/*!40000 ALTER TABLE `image_locations` DISABLE KEYS */;
INSERT INTO `image_locations` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `meta_data`, `status`) VALUES (2,'e7469c27-9043-4bd0-b0a4-5b489dcf3ae2','rbd://79feddb1-4bfc-557f-83b9-0d57c9f66c1b/images/e7469c27-9043-4bd0-b0a4-5b489dcf3ae2/snap','2025-12-05 08:34:28','2025-12-05 08:34:28',NULL,0,'{\"store\": \"default_backend\"}','active'),(5,'3647d20f-5e09-41b2-a6f3-f320b9e4e343','rbd://79feddb1-4bfc-557f-83b9-0d57c9f66c1b/images/3647d20f-5e09-41b2-a6f3-f320b9e4e343/snap','2025-12-05 10:03:26','2025-12-05 10:03:26',NULL,0,'{\"store\": \"default_backend\"}','active'),(6,'d3e02861-a64a-4cdb-8324-ba63c5aaf4cd','rbd://79feddb1-4bfc-557f-83b9-0d57c9f66c1b/images/d3e02861-a64a-4cdb-8324-ba63c5aaf4cd/snap','2025-12-05 10:03:28','2025-12-05 10:03:28',NULL,0,'{\"store\": \"default_backend\"}','active'),(7,'65f82087-1764-4120-88d1-c15c3cb7a5f8','rbd://79feddb1-4bfc-557f-83b9-0d57c9f66c1b/images/65f82087-1764-4120-88d1-c15c3cb7a5f8/snap','2025-12-05 10:04:54','2025-12-05 10:05:03','2025-12-05 10:05:03',1,'{\"store\": \"default_backend\"}','deleted'),(8,'e71bdfda-2761-42b5-9ef0-d82a332c5424','rbd://79feddb1-4bfc-557f-83b9-0d57c9f66c1b/images/e71bdfda-2761-42b5-9ef0-d82a332c5424/snap','2025-12-05 10:04:58','2025-12-05 10:05:09','2025-12-05 10:05:09',1,'{\"store\": \"default_backend\"}','deleted'),(9,'f67023e2-353d-4de8-b5e5-7921df600775','rbd://79feddb1-4bfc-557f-83b9-0d57c9f66c1b/images/f67023e2-353d-4de8-b5e5-7921df600775/snap','2025-12-05 10:05:40','2025-12-05 10:05:50','2025-12-05 10:05:50',1,'{\"store\": \"default_backend\"}','deleted'),(10,'58505671-6568-4c69-af5f-de42266d75b4','rbd://79feddb1-4bfc-557f-83b9-0d57c9f66c1b/images/58505671-6568-4c69-af5f-de42266d75b4/snap','2025-12-05 10:06:08','2025-12-05 10:06:26','2025-12-05 10:06:26',1,'{\"store\": \"default_backend\"}','deleted'),(11,'905e760c-9c3a-4ba0-996d-49a7ed4af834','rbd://79feddb1-4bfc-557f-83b9-0d57c9f66c1b/images/905e760c-9c3a-4ba0-996d-49a7ed4af834/snap','2025-12-05 10:06:10','2025-12-05 10:06:24','2025-12-05 10:06:24',1,'{\"store\": \"default_backend\"}','deleted'),(12,'d525d7ed-af91-42b5-9c1f-bbf96cc9ac72','rbd://79feddb1-4bfc-557f-83b9-0d57c9f66c1b/images/d525d7ed-af91-42b5-9c1f-bbf96cc9ac72/snap','2025-12-05 10:06:11','2025-12-05 10:06:23','2025-12-05 10:06:23',1,'{\"store\": \"default_backend\"}','deleted'),(13,'6bb3f142-d936-4f04-b847-e57349887bef','rbd://79feddb1-4bfc-557f-83b9-0d57c9f66c1b/images/6bb3f142-d936-4f04-b847-e57349887bef/snap','2025-12-05 10:06:12','2025-12-05 10:06:21','2025-12-05 10:06:21',1,'{\"store\": \"default_backend\"}','deleted'),(14,'10919570-f00e-4ee3-84d5-61461e1dbd66','rbd://79feddb1-4bfc-557f-83b9-0d57c9f66c1b/images/10919570-f00e-4ee3-84d5-61461e1dbd66/snap','2025-12-05 10:06:13','2025-12-05 10:06:20','2025-12-05 10:06:20',1,'{\"store\": \"default_backend\"}','deleted'),(15,'3ad7fd0a-fbdf-45a5-ac82-fbdf38165692','rbd://79feddb1-4bfc-557f-83b9-0d57c9f66c1b/images/3ad7fd0a-fbdf-45a5-ac82-fbdf38165692/snap','2025-12-05 10:06:14','2025-12-05 10:06:16','2025-12-05 10:06:16',1,'{\"store\": \"default_backend\"}','deleted'),(16,'45bd6cf1-808e-4900-af38-84bb12160f4c','rbd://79feddb1-4bfc-557f-83b9-0d57c9f66c1b/images/45bd6cf1-808e-4900-af38-84bb12160f4c/snap','2025-12-05 10:06:14','2025-12-05 10:06:16','2025-12-05 10:06:16',1,'{\"store\": \"default_backend\"}','deleted'),(17,'8dfe98b2-e445-4709-97df-ec9c7bfae719','rbd://79feddb1-4bfc-557f-83b9-0d57c9f66c1b/images/8dfe98b2-e445-4709-97df-ec9c7bfae719/snap','2025-12-05 10:06:16','2025-12-05 10:06:30','2025-12-05 10:06:30',1,'{\"store\": \"default_backend\"}','deleted'),(18,'edd71fb4-5152-41d2-b83c-91ae600e1685','rbd://79feddb1-4bfc-557f-83b9-0d57c9f66c1b/images/edd71fb4-5152-41d2-b83c-91ae600e1685/snap','2025-12-05 10:06:27','2025-12-05 10:06:29','2025-12-05 10:06:29',1,'{\"store\": \"default_backend\"}','deleted'),(19,'5800ee4b-a95f-4b23-ad92-54d799839cac','rbd://79feddb1-4bfc-557f-83b9-0d57c9f66c1b/images/5800ee4b-a95f-4b23-ad92-54d799839cac/snap','2025-12-05 10:07:53','2025-12-05 10:07:55','2025-12-05 10:07:55',1,'{\"store\": \"default_backend\"}','deleted'),(20,'fa60b228-b906-49ef-8f98-14891efbdebf','rbd://79feddb1-4bfc-557f-83b9-0d57c9f66c1b/images/fa60b228-b906-49ef-8f98-14891efbdebf/snap','2025-12-05 10:09:08','2025-12-05 10:09:15','2025-12-05 10:09:15',1,'{\"store\": \"default_backend\"}','deleted'),(21,'ca497423-5de9-4d32-967f-3253f68ba338','rbd://79feddb1-4bfc-557f-83b9-0d57c9f66c1b/images/ca497423-5de9-4d32-967f-3253f68ba338/snap','2025-12-05 10:09:10','2025-12-05 10:09:13','2025-12-05 10:09:13',1,'{\"store\": \"default_backend\"}','deleted'),(22,'ee5ddc3f-3b95-49c0-98bd-f98089cf180c','rbd://79feddb1-4bfc-557f-83b9-0d57c9f66c1b/images/ee5ddc3f-3b95-49c0-98bd-f98089cf180c/snap','2025-12-05 10:09:31','2025-12-05 10:09:34','2025-12-05 10:09:34',1,'{\"store\": \"default_backend\"}','deleted'),(23,'09b66b13-deb1-4951-a250-42efc7e8ca5f','rbd://79feddb1-4bfc-557f-83b9-0d57c9f66c1b/images/09b66b13-deb1-4951-a250-42efc7e8ca5f/snap','2025-12-05 10:09:34','2025-12-05 10:09:37','2025-12-05 10:09:37',1,'{\"store\": \"default_backend\"}','deleted'),(24,'daad7a7d-00a1-449e-af30-bc504832c3bf','rbd://79feddb1-4bfc-557f-83b9-0d57c9f66c1b/images/daad7a7d-00a1-449e-af30-bc504832c3bf/snap','2025-12-05 10:15:14','2025-12-05 10:15:17','2025-12-05 10:15:17',1,'{\"store\": \"default_backend\"}','deleted'),(25,'4cae38d5-808a-4427-ac25-3b2d53ac11a8','rbd://79feddb1-4bfc-557f-83b9-0d57c9f66c1b/images/4cae38d5-808a-4427-ac25-3b2d53ac11a8/snap','2025-12-05 10:27:05','2025-12-05 10:27:06','2025-12-05 10:27:06',1,'{\"store\": \"default_backend\"}','deleted');
/*!40000 ALTER TABLE `image_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_members`
--

DROP TABLE IF EXISTS `image_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `member` varchar(255) NOT NULL,
  `can_share` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image_members_image_id_member_deleted_at_key` (`image_id`,`member`,`deleted_at`),
  KEY `ix_image_members_deleted` (`deleted`),
  KEY `ix_image_members_image_id` (`image_id`),
  KEY `ix_image_members_image_id_member` (`image_id`,`member`),
  CONSTRAINT `image_members_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`can_share` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_members`
--

LOCK TABLES `image_members` WRITE;
/*!40000 ALTER TABLE `image_members` DISABLE KEYS */;
INSERT INTO `image_members` (`id`, `image_id`, `member`, `can_share`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`) VALUES (1,'3282268e-7ee4-452b-bd73-6ffb1b11d428','5137c0925bf447fc90b9f14d68e1a877',0,'2025-12-05 10:06:32','2025-12-05 10:06:32','2025-12-05 10:06:32',1,'accepted'),(2,'0607c89a-3fb6-4c1c-af10-de146b75d37b','5137c0925bf447fc90b9f14d68e1a877',0,'2025-12-05 10:06:32','2025-12-05 10:06:33','2025-12-05 10:06:33',1,'accepted'),(3,'fc7040be-262c-459e-b785-40b8a1176929','5137c0925bf447fc90b9f14d68e1a877',0,'2025-12-05 10:06:33','2025-12-05 10:06:33','2025-12-05 10:06:33',1,'rejected'),(4,'2935e38a-1a70-4a4e-aab6-de9040d0c90a','5137c0925bf447fc90b9f14d68e1a877',0,'2025-12-05 10:06:33','2025-12-05 10:06:34','2025-12-05 10:06:34',1,'accepted'),(5,'5800ee4b-a95f-4b23-ad92-54d799839cac','44be45e025ad4b70a9c5ef7596a6d3d3',0,'2025-12-05 10:07:53','2025-12-05 10:07:55','2025-12-05 10:07:55',1,'pending'),(6,'8f8b0daa-2df3-4d79-ab29-aaacc80c749a','ad5ef68ea71942e1b884625f99120c1d',0,'2025-12-05 10:09:25','2025-12-05 10:09:25','2025-12-05 10:09:25',1,'pending'),(7,'8d4bab39-e49f-43c9-aea2-a252f22fdea8','ad5ef68ea71942e1b884625f99120c1d',0,'2025-12-05 10:09:25','2025-12-05 10:09:26','2025-12-05 10:09:26',1,'pending');
/*!40000 ALTER TABLE `image_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_properties`
--

DROP TABLE IF EXISTS `image_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_image_properties_image_id_name` (`image_id`,`name`),
  KEY `ix_image_properties_deleted` (`deleted`),
  KEY `ix_image_properties_image_id` (`image_id`),
  CONSTRAINT `image_properties_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_properties`
--

LOCK TABLES `image_properties` WRITE;
/*!40000 ALTER TABLE `image_properties` DISABLE KEYS */;
INSERT INTO `image_properties` (`id`, `image_id`, `name`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (2,'e7469c27-9043-4bd0-b0a4-5b489dcf3ae2','owner_specified.openstack.md5','','2025-12-05 08:34:23','2025-12-05 08:34:23',NULL,0),(5,'e7469c27-9043-4bd0-b0a4-5b489dcf3ae2','owner_specified.openstack.sha256','','2025-12-05 08:34:23','2025-12-05 08:34:23',NULL,0),(8,'e7469c27-9043-4bd0-b0a4-5b489dcf3ae2','owner_specified.openstack.object','images/cirros','2025-12-05 08:34:23','2025-12-05 08:34:23',NULL,0),(11,'3647d20f-5e09-41b2-a6f3-f320b9e4e343','hw_rng_model','virtio','2025-12-05 10:03:24','2025-12-05 10:03:24',NULL,0),(12,'d3e02861-a64a-4cdb-8324-ba63c5aaf4cd','hw_rng_model','virtio','2025-12-05 10:03:26','2025-12-05 10:03:26',NULL,0),(13,'e71bdfda-2761-42b5-9ef0-d82a332c5424','hw_rng_model','virtio','2025-12-05 10:04:40','2025-12-05 10:05:09','2025-12-05 10:05:09',1),(14,'e71bdfda-2761-42b5-9ef0-d82a332c5424','base_image_ref','3647d20f-5e09-41b2-a6f3-f320b9e4e343','2025-12-05 10:04:40','2025-12-05 10:05:09','2025-12-05 10:05:09',1),(15,'e71bdfda-2761-42b5-9ef0-d82a332c5424','owner_user_name','tempest-UnshelveToHostMultiNodesTest-1519933804-project-member','2025-12-05 10:04:40','2025-12-05 10:05:09','2025-12-05 10:05:09',1),(16,'e71bdfda-2761-42b5-9ef0-d82a332c5424','owner_project_name','tempest-UnshelveToHostMultiNodesTest-1519933804','2025-12-05 10:04:40','2025-12-05 10:05:09','2025-12-05 10:05:09',1),(17,'e71bdfda-2761-42b5-9ef0-d82a332c5424','boot_roles','member,reader','2025-12-05 10:04:40','2025-12-05 10:05:09','2025-12-05 10:05:09',1),(18,'e71bdfda-2761-42b5-9ef0-d82a332c5424','hw_machine_type','q35','2025-12-05 10:04:40','2025-12-05 10:05:09','2025-12-05 10:05:09',1),(19,'e71bdfda-2761-42b5-9ef0-d82a332c5424','hw_cdrom_bus','sata','2025-12-05 10:04:40','2025-12-05 10:05:09','2025-12-05 10:05:09',1),(20,'e71bdfda-2761-42b5-9ef0-d82a332c5424','hw_disk_bus','virtio','2025-12-05 10:04:40','2025-12-05 10:05:09','2025-12-05 10:05:09',1),(21,'e71bdfda-2761-42b5-9ef0-d82a332c5424','hw_input_bus','usb','2025-12-05 10:04:40','2025-12-05 10:05:09','2025-12-05 10:05:09',1),(22,'e71bdfda-2761-42b5-9ef0-d82a332c5424','hw_pointer_model','usbtablet','2025-12-05 10:04:40','2025-12-05 10:05:09','2025-12-05 10:05:09',1),(23,'e71bdfda-2761-42b5-9ef0-d82a332c5424','hw_video_model','virtio','2025-12-05 10:04:40','2025-12-05 10:05:09','2025-12-05 10:05:09',1),(24,'e71bdfda-2761-42b5-9ef0-d82a332c5424','hw_vif_model','virtio','2025-12-05 10:04:40','2025-12-05 10:05:09','2025-12-05 10:05:09',1),(25,'e71bdfda-2761-42b5-9ef0-d82a332c5424','instance_uuid','46a0f7d8-3474-49a0-9e40-e9ee2de6864c','2025-12-05 10:04:40','2025-12-05 10:05:09','2025-12-05 10:05:09',1),(26,'e71bdfda-2761-42b5-9ef0-d82a332c5424','user_id','9f7345c9119f469e9da2826f2afea07b','2025-12-05 10:04:40','2025-12-05 10:05:09','2025-12-05 10:05:09',1),(27,'e71bdfda-2761-42b5-9ef0-d82a332c5424','image_type','snapshot','2025-12-05 10:04:40','2025-12-05 10:05:09','2025-12-05 10:05:09',1),(28,'65f82087-1764-4120-88d1-c15c3cb7a5f8','os_distro','value2','2025-12-05 10:04:55','2025-12-05 10:05:04','2025-12-05 10:05:04',1),(29,'65f82087-1764-4120-88d1-c15c3cb7a5f8','os_version','alt1','2025-12-05 10:04:55','2025-12-05 10:05:04','2025-12-05 10:05:04',1),(30,'e71bdfda-2761-42b5-9ef0-d82a332c5424','image_location','snapshot','2025-12-05 10:04:57','2025-12-05 10:05:09','2025-12-05 10:05:09',1),(31,'e71bdfda-2761-42b5-9ef0-d82a332c5424','owner_id','c5f7af554c09472ab3fd27dd1c35c543','2025-12-05 10:04:57','2025-12-05 10:05:09','2025-12-05 10:05:09',1),(32,'e71bdfda-2761-42b5-9ef0-d82a332c5424','image_state','available','2025-12-05 10:04:57','2025-12-05 10:05:09','2025-12-05 10:05:09',1),(33,'65f82087-1764-4120-88d1-c15c3cb7a5f8','architecture','value3','2025-12-05 10:04:58','2025-12-05 10:05:04','2025-12-05 10:05:04',1),(34,'f67023e2-353d-4de8-b5e5-7921df600775','hw_rng_model','virtio','2025-12-05 10:05:11','2025-12-05 10:05:50','2025-12-05 10:05:50',1),(35,'f67023e2-353d-4de8-b5e5-7921df600775','base_image_ref','3647d20f-5e09-41b2-a6f3-f320b9e4e343','2025-12-05 10:05:11','2025-12-05 10:05:50','2025-12-05 10:05:50',1),(36,'f67023e2-353d-4de8-b5e5-7921df600775','owner_user_name','tempest-UnshelveToHostMultiNodesTest-1519933804-project-member','2025-12-05 10:05:11','2025-12-05 10:05:50','2025-12-05 10:05:50',1),(37,'f67023e2-353d-4de8-b5e5-7921df600775','owner_project_name','tempest-UnshelveToHostMultiNodesTest-1519933804','2025-12-05 10:05:11','2025-12-05 10:05:50','2025-12-05 10:05:50',1),(38,'f67023e2-353d-4de8-b5e5-7921df600775','boot_roles','member,reader','2025-12-05 10:05:11','2025-12-05 10:05:50','2025-12-05 10:05:50',1),(39,'f67023e2-353d-4de8-b5e5-7921df600775','hw_machine_type','q35','2025-12-05 10:05:11','2025-12-05 10:05:50','2025-12-05 10:05:50',1),(40,'f67023e2-353d-4de8-b5e5-7921df600775','hw_cdrom_bus','sata','2025-12-05 10:05:11','2025-12-05 10:05:50','2025-12-05 10:05:50',1),(41,'f67023e2-353d-4de8-b5e5-7921df600775','hw_disk_bus','virtio','2025-12-05 10:05:11','2025-12-05 10:05:50','2025-12-05 10:05:50',1),(42,'f67023e2-353d-4de8-b5e5-7921df600775','hw_input_bus','usb','2025-12-05 10:05:11','2025-12-05 10:05:50','2025-12-05 10:05:50',1),(43,'f67023e2-353d-4de8-b5e5-7921df600775','hw_pointer_model','usbtablet','2025-12-05 10:05:11','2025-12-05 10:05:50','2025-12-05 10:05:50',1),(44,'f67023e2-353d-4de8-b5e5-7921df600775','hw_video_model','virtio','2025-12-05 10:05:11','2025-12-05 10:05:50','2025-12-05 10:05:50',1),(45,'f67023e2-353d-4de8-b5e5-7921df600775','hw_vif_model','virtio','2025-12-05 10:05:11','2025-12-05 10:05:50','2025-12-05 10:05:50',1),(46,'f67023e2-353d-4de8-b5e5-7921df600775','clean_attempts','1','2025-12-05 10:05:11','2025-12-05 10:05:50','2025-12-05 10:05:50',1),(47,'f67023e2-353d-4de8-b5e5-7921df600775','instance_uuid','46a0f7d8-3474-49a0-9e40-e9ee2de6864c','2025-12-05 10:05:11','2025-12-05 10:05:50','2025-12-05 10:05:50',1),(48,'f67023e2-353d-4de8-b5e5-7921df600775','user_id','9f7345c9119f469e9da2826f2afea07b','2025-12-05 10:05:11','2025-12-05 10:05:50','2025-12-05 10:05:50',1),(49,'f67023e2-353d-4de8-b5e5-7921df600775','image_type','snapshot','2025-12-05 10:05:11','2025-12-05 10:05:50','2025-12-05 10:05:50',1),(50,'f67023e2-353d-4de8-b5e5-7921df600775','image_location','snapshot','2025-12-05 10:05:39','2025-12-05 10:05:50','2025-12-05 10:05:50',1),(51,'f67023e2-353d-4de8-b5e5-7921df600775','owner_id','c5f7af554c09472ab3fd27dd1c35c543','2025-12-05 10:05:39','2025-12-05 10:05:50','2025-12-05 10:05:50',1),(52,'f67023e2-353d-4de8-b5e5-7921df600775','image_state','available','2025-12-05 10:05:39','2025-12-05 10:05:50','2025-12-05 10:05:50',1),(53,'8dfe98b2-e445-4709-97df-ec9c7bfae719','ramdisk_id','00000000-1111-2222-3333-444455556666','2025-12-05 10:06:14','2025-12-05 10:06:30','2025-12-05 10:06:30',1),(54,'8dfe98b2-e445-4709-97df-ec9c7bfae719','os_glance_stage_host','http://glance-default-external-api-0.glance-default-external-api.openstack.svc:9292','2025-12-05 10:06:14','2025-12-05 10:06:30','2025-12-05 10:06:30',1),(56,'8dfe98b2-e445-4709-97df-ec9c7bfae719','os_glance_importing_to_stores','','2025-12-05 10:06:15','2025-12-05 10:06:30','2025-12-05 10:06:30',1),(57,'8dfe98b2-e445-4709-97df-ec9c7bfae719','os_glance_failed_import','','2025-12-05 10:06:15','2025-12-05 10:06:30','2025-12-05 10:06:30',1),(58,'edd71fb4-5152-41d2-b83c-91ae600e1685','ramdisk_id','00000000-1111-2222-3333-444455556666','2025-12-05 10:06:20','2025-12-05 10:06:29','2025-12-05 10:06:29',1),(60,'edd71fb4-5152-41d2-b83c-91ae600e1685','os_glance_importing_to_stores','','2025-12-05 10:06:20','2025-12-05 10:06:29','2025-12-05 10:06:29',1),(61,'edd71fb4-5152-41d2-b83c-91ae600e1685','os_glance_failed_import','','2025-12-05 10:06:20','2025-12-05 10:06:29','2025-12-05 10:06:29',1),(63,'b8475579-bb4f-4b05-9b6b-0240c593dbb7','os_glance_importing_to_stores','','2025-12-05 10:08:01','2025-12-05 10:08:01',NULL,0),(64,'b8475579-bb4f-4b05-9b6b-0240c593dbb7','os_glance_failed_import','default_backend','2025-12-05 10:08:01','2025-12-05 10:08:01',NULL,0),(65,'ca497423-5de9-4d32-967f-3253f68ba338','ramdisk_id','00000000-1111-2222-3333-444455556666','2025-12-05 10:09:09','2025-12-05 10:09:13','2025-12-05 10:09:13',1);
/*!40000 ALTER TABLE `image_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_tags`
--

DROP TABLE IF EXISTS `image_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_tags_image_id` (`image_id`),
  KEY `ix_image_tags_image_id_tag_value` (`image_id`,`value`),
  CONSTRAINT `image_tags_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_tags`
--

LOCK TABLES `image_tags` WRITE;
/*!40000 ALTER TABLE `image_tags` DISABLE KEYS */;
INSERT INTO `image_tags` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'58505671-6568-4c69-af5f-de42266d75b4','tempest-tag-151611865','2025-12-05 10:06:08','2025-12-05 10:06:26','2025-12-05 10:06:26',1),(2,'58505671-6568-4c69-af5f-de42266d75b4','tempest-tag-1827311712','2025-12-05 10:06:08','2025-12-05 10:06:26','2025-12-05 10:06:26',1),(3,'905e760c-9c3a-4ba0-996d-49a7ed4af834','tempest-tag-1962836754','2025-12-05 10:06:09','2025-12-05 10:06:25','2025-12-05 10:06:25',1),(4,'905e760c-9c3a-4ba0-996d-49a7ed4af834','tempest-tag-1470022172','2025-12-05 10:06:09','2025-12-05 10:06:25','2025-12-05 10:06:25',1),(5,'d525d7ed-af91-42b5-9c1f-bbf96cc9ac72','tempest-tag-47620873','2025-12-05 10:06:10','2025-12-05 10:06:23','2025-12-05 10:06:23',1),(6,'d525d7ed-af91-42b5-9c1f-bbf96cc9ac72','tempest-tag-2108324158','2025-12-05 10:06:10','2025-12-05 10:06:23','2025-12-05 10:06:23',1),(7,'6bb3f142-d936-4f04-b847-e57349887bef','tempest-tag-1204954968','2025-12-05 10:06:11','2025-12-05 10:06:21','2025-12-05 10:06:21',1),(8,'6bb3f142-d936-4f04-b847-e57349887bef','tempest-tag-2002101881','2025-12-05 10:06:11','2025-12-05 10:06:21','2025-12-05 10:06:21',1),(9,'10919570-f00e-4ee3-84d5-61461e1dbd66','tempest-tag-2119784532','2025-12-05 10:06:12','2025-12-05 10:06:20','2025-12-05 10:06:20',1),(10,'10919570-f00e-4ee3-84d5-61461e1dbd66','tempest-tag-1458764088','2025-12-05 10:06:12','2025-12-05 10:06:20','2025-12-05 10:06:20',1),(11,'3ad7fd0a-fbdf-45a5-ac82-fbdf38165692','tempest-tag-1877463867','2025-12-05 10:06:13','2025-12-05 10:06:18','2025-12-05 10:06:18',1),(12,'3ad7fd0a-fbdf-45a5-ac82-fbdf38165692','tempest-tag-1664904412','2025-12-05 10:06:13','2025-12-05 10:06:18','2025-12-05 10:06:18',1),(13,'11543d68-d688-4326-96a0-a83bc60a5641','tempest-tag-989248005','2025-12-05 10:08:59','2025-12-05 10:08:59','2025-12-05 10:08:59',1);
/*!40000 ALTER TABLE `image_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `disk_format` varchar(20) DEFAULT NULL,
  `container_format` varchar(20) DEFAULT NULL,
  `checksum` varchar(32) DEFAULT NULL,
  `owner` varchar(255) DEFAULT NULL,
  `min_disk` int(11) NOT NULL,
  `min_ram` int(11) NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT 0,
  `virtual_size` bigint(20) DEFAULT NULL,
  `visibility` enum('private','public','shared','community') NOT NULL DEFAULT 'shared',
  `os_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `os_hash_algo` varchar(64) DEFAULT NULL,
  `os_hash_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checksum_image_idx` (`checksum`),
  KEY `ix_images_deleted` (`deleted`),
  KEY `owner_image_idx` (`owner`),
  KEY `created_at_image_idx` (`created_at`),
  KEY `updated_at_image_idx` (`updated_at`),
  KEY `visibility_image_idx` (`visibility`),
  KEY `os_hidden_image_idx` (`os_hidden`),
  KEY `os_hash_value_image_idx` (`os_hash_value`),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`protected` in (0,1)),
  CONSTRAINT `CONSTRAINT_4` CHECK (`os_hidden` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` (`id`, `name`, `size`, `status`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `disk_format`, `container_format`, `checksum`, `owner`, `min_disk`, `min_ram`, `protected`, `virtual_size`, `visibility`, `os_hidden`, `os_hash_algo`, `os_hash_value`) VALUES ('0607c89a-3fb6-4c1c-af10-de146b75d37b','tempest-ImagesMemberTest-image-758653042',NULL,'deleted','2025-12-05 10:06:32','2025-12-05 10:06:33','2025-12-05 10:06:33',1,'raw','bare',NULL,'9b0fff2630ba47b5a0dab782a82c2214',0,0,0,NULL,'shared',0,NULL,NULL),('09b66b13-deb1-4951-a250-42efc7e8ca5f','tempest-VolumesNegativeTest-image-1626779616',1024,'deleted','2025-12-05 10:09:34','2025-12-05 10:09:37','2025-12-05 10:09:37',1,'qcow2','bare','e84b225b9d432de716434663f273187c','2eb8cf0d784b4d188f16c04a39a755a9',2,0,0,NULL,'private',0,'sha512','66be1ccd38756a82463c5d7c4a245400125d5bec38092dc1624afda60b9c233fc28fdb960f2d035d7cf003bdfa4d7e874b025a3802a32e4b041e01792c4b2ed9'),('10919570-f00e-4ee3-84d5-61461e1dbd66','tempest-ListUserImagesTest-image-1928382155',2095,'deleted','2025-12-05 10:06:12','2025-12-05 10:06:20','2025-12-05 10:06:20',1,'aki','bare','71d4c84e3e511e59f9c8be03c69c371e','a5e423e05eb84045a5d63179380884e6',0,0,0,NULL,'private',0,'sha512','5b2b59d362d04641fe8b8936e3f9c3eacd3492bbd178367daf542d20efa24e0fbd0ec79284733673f33b6f6a2ac4d4e8fa1b7fd3956fa135c5df6beeaa0039b9'),('11543d68-d688-4326-96a0-a83bc60a5641','tempest-ImagesTagsTest-image-1793929845',NULL,'deleted','2025-12-05 10:08:59','2025-12-05 10:09:00','2025-12-05 10:09:00',1,'raw','bare',NULL,'4d6070f41e144742a7c429de41459c77',0,0,0,NULL,'private',0,NULL,NULL),('173893a4-317a-45f7-891a-f1d43a638334','tempest-new-image-1965591329',NULL,'deleted','2025-12-05 10:09:10','2025-12-05 10:09:11','2025-12-05 10:09:11',1,'qcow2','bare',NULL,'c7dbee2ced7147429311c1ce1cf2a939',0,0,0,NULL,'private',0,NULL,NULL),('26148602-4a7c-4e5e-b7b9-83a78a514623','tempest-test-1256904556',NULL,'deleted','2025-12-05 10:07:50','2025-12-05 10:07:50','2025-12-05 10:07:50',1,'raw','bare',NULL,'7ddc5c7d7fbc42c7b4c97bd7b3656bf3',0,0,0,NULL,'shared',0,NULL,NULL),('2820fde4-35db-4d4d-83b6-92d8708a46db','tempest-image-2360367',NULL,'deleted','2025-12-05 10:09:09','2025-12-05 10:09:09','2025-12-05 10:09:09',1,'qcow2','bare',NULL,'c7dbee2ced7147429311c1ce1cf2a939',0,0,0,NULL,'private',0,NULL,NULL),('2935e38a-1a70-4a4e-aab6-de9040d0c90a','tempest-ImagesMemberTest-image-1822432432',NULL,'deleted','2025-12-05 10:06:33','2025-12-05 10:06:34','2025-12-05 10:06:34',1,'raw','bare',NULL,'9b0fff2630ba47b5a0dab782a82c2214',0,0,0,NULL,'shared',0,NULL,NULL),('3282268e-7ee4-452b-bd73-6ffb1b11d428','tempest-ImagesMemberTest-image-2027729885',NULL,'deleted','2025-12-05 10:06:32','2025-12-05 10:06:32','2025-12-05 10:06:32',1,'raw','bare',NULL,'9b0fff2630ba47b5a0dab782a82c2214',0,0,0,NULL,'shared',0,NULL,NULL),('3647d20f-5e09-41b2-a6f3-f320b9e4e343','cirros-0.6.2-x86_64-disk.img',21430272,'active','2025-12-05 10:03:24','2025-12-05 10:03:26',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','e6ca8a92050741d3a93772e6c1b0d704',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('3ad7fd0a-fbdf-45a5-ac82-fbdf38165692','tempest-ListUserImagesTest-image-461990912',3804,'deleted','2025-12-05 10:06:13','2025-12-05 10:06:18','2025-12-05 10:06:18',1,'vhd','bare','c47c44953dc70d85f6eaa9f1acefac2b','a5e423e05eb84045a5d63179380884e6',0,0,0,NULL,'private',0,'sha512','2ca9aec53ccaab0bcfe0e9683581d5986c01f2242865c47778334c3134fda6488066c5c586d1ee6d8d18c12457382ef673aae304260a1e7a565b90a0b9b299bd'),('45bd6cf1-808e-4900-af38-84bb12160f4c','tempest-image-157796099',3452,'deleted','2025-12-05 10:06:12','2025-12-05 10:06:18','2025-12-05 10:06:18',1,'qcow2','bare','efa3f99a0d34e34dce544b907c459f65','a52ef89bc3d84dd59d2ec5f9a16a62f8',0,129,0,NULL,'private',0,'sha512','e4b03f1aba6fca5cb5c1f2028fa7af842b1ccbb5cd9f1c79f9104c726c5b62e19e41c8e6175bc98f109efae46e0e2f357a2a5f7d116507fe62c1e9ce0db14dac'),('4b50cd91-e715-4039-ba17-9d49ec3cd519',NULL,NULL,'deleted','2025-12-05 10:06:14','2025-12-05 10:06:14','2025-12-05 10:06:14',1,NULL,NULL,NULL,'a5e423e05eb84045a5d63179380884e6',0,0,0,NULL,'shared',1,NULL,NULL),('4cae38d5-808a-4427-ac25-3b2d53ac11a8','tempest-scenario-img--114839982',21430272,'deleted','2025-12-05 10:27:03','2025-12-05 10:27:06','2025-12-05 10:27:06',1,'qcow2','bare','c8fc807773e5354afe61636071771906','0be5dd7ec9b24465a8f2ecd5c831c9a3',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('571ad791-c36d-45d9-bd79-b4b5102f9800',NULL,NULL,'deleted','2025-12-05 10:08:43','2025-12-05 10:08:44','2025-12-05 10:08:44',1,'raw','bare',NULL,'0f6133f202fb4ec595b92b61aa3a2f88',0,0,0,NULL,'shared',0,NULL,NULL),('5800ee4b-a95f-4b23-ad92-54d799839cac','tempest-ListSharedImagesTest-image-47412501',2048,'deleted','2025-12-05 10:07:52','2025-12-05 10:07:55','2025-12-05 10:07:55',1,'qcow2','bare','1c7f596725d49ede29931fd6ea6ce891','8a50663b2e204a8aad46985abfebcb86',0,0,0,NULL,'shared',0,'sha512','be1be7caa2eb4b49cb262848919ed79a93f9084fd165609725378255f6267348b1101ac269f80c65ab2603b90bfb5961b956747c27a4a555d9329ec43b663433'),('58505671-6568-4c69-af5f-de42266d75b4','tempest-ListUserImagesTest-image-1751466581',1269,'deleted','2025-12-05 10:06:08','2025-12-05 10:06:26','2025-12-05 10:06:26',1,'qcow2','bare','c71cbff85d06b935e20366731a3db002','a5e423e05eb84045a5d63179380884e6',0,0,0,NULL,'private',0,'sha512','42b6ab9c5f16a4942863a142259dcad50555fb8080ff7451cef95373b8eea277dc8ca0483117ae7bd60fa6c05e4dc29fab04a26da16d764de4d63b9bc997a87f'),('65f82087-1764-4120-88d1-c15c3cb7a5f8','tempest-image-61684949',1024,'deleted','2025-12-05 10:04:53','2025-12-05 10:05:04','2025-12-05 10:05:04',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','8c786ab49bfb47da817da4418860f39f',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('6bb3f142-d936-4f04-b847-e57349887bef','tempest-ListUserImagesTest-image-490107056',4005,'deleted','2025-12-05 10:06:11','2025-12-05 10:06:21','2025-12-05 10:06:21',1,'ari','bare','a3273a411e5358cab838055d63a8dc85','a5e423e05eb84045a5d63179380884e6',0,0,0,NULL,'private',0,'sha512','b5e107767a551ad2ceed679e52279ea4e31b76b585c095492591005f6e1e9cd84eaf7451d2a3667da91450f5647e40df982ce7c1d30da83aa02fc4d11e2f0f06'),('87597fee-adba-49aa-b7a4-fae464edabf9','tempest-task_image-2049570070',NULL,'deleted','2025-12-05 10:05:58','2025-12-05 10:05:58','2025-12-05 10:05:58',1,'qcow2','bare',NULL,NULL,0,0,0,NULL,'public',0,NULL,NULL),('8d4bab39-e49f-43c9-aea2-a252f22fdea8','tempest-ImagesMemberNegativeTest-image-1127333607',NULL,'deleted','2025-12-05 10:09:25','2025-12-05 10:09:26','2025-12-05 10:09:26',1,'raw','bare',NULL,'204296e252124e5b80d3c3ac433581bf',0,0,0,NULL,'shared',0,NULL,NULL),('8dfe98b2-e445-4709-97df-ec9c7bfae719','tempest-image-1931500145',1024,'deleted','2025-12-05 10:06:14','2025-12-05 10:06:30','2025-12-05 10:06:30',1,'raw','bare','bc76a9995d6ec946f8be6d01d43670c0','b8acd29b55e34e8ea4c7e1f26e3cb6da',0,0,0,1024,'private',0,'sha512','697dc4b90cf0ac3d8577ef7418fa90cfe9ad6ce7cfaf1daf39566a1f13e9415734dfe8ee7d05c9d787ba5490675deed31e41811098e6112d12fd713d36aeed9b'),('8f8b0daa-2df3-4d79-ab29-aaacc80c749a','tempest-ImagesMemberNegativeTest-image-1954130883',NULL,'deleted','2025-12-05 10:09:25','2025-12-05 10:09:25','2025-12-05 10:09:25',1,'raw','bare',NULL,'204296e252124e5b80d3c3ac433581bf',0,0,0,NULL,'shared',0,NULL,NULL),('905e760c-9c3a-4ba0-996d-49a7ed4af834','tempest-ListUserImagesTest-image-590414650',2218,'deleted','2025-12-05 10:06:09','2025-12-05 10:06:25','2025-12-05 10:06:25',1,'raw','bare','b94bcf02fa66206505265bfdea6c4323','a5e423e05eb84045a5d63179380884e6',0,0,0,2218,'private',0,'sha512','4e27f3862f9520c6956286471a66c507e4ca2895b598ed690b5f2743a53926d52e224e8d43f250e468b1e9df45372f0836a0b47f23eece389e2338174857b78b'),('92c71611-5cc1-4593-9125-784e182bbb51','tempest-test-471209943',NULL,'deleted','2025-12-05 10:07:50','2025-12-05 10:07:51','2025-12-05 10:07:51',1,NULL,NULL,NULL,'7ddc5c7d7fbc42c7b4c97bd7b3656bf3',0,0,0,NULL,'shared',0,NULL,NULL),('b8475579-bb4f-4b05-9b6b-0240c593dbb7','tempest-test-1890168659',NULL,'queued','2025-12-05 10:08:00','2025-12-05 10:08:01',NULL,0,'raw','bare',NULL,'7b26144fb495438c9666bbff7479f0c0',0,0,0,NULL,'shared',0,NULL,NULL),('bf4bf184-8386-4ca2-a541-7ba890031cca','tempest-test-1752105274',NULL,'deleted','2025-12-05 10:07:51','2025-12-05 10:07:51','2025-12-05 10:07:51',1,'raw','bare',NULL,'7ddc5c7d7fbc42c7b4c97bd7b3656bf3',0,0,0,NULL,'shared',0,NULL,NULL),('c4b02245-b9f3-4d80-98cf-93f9299b712f','tempest-BasicOperationsImagesAdminTest-Image-1602894089',NULL,'deleted','2025-12-05 10:08:43','2025-12-05 10:08:43','2025-12-05 10:08:43',1,'raw','bare',NULL,'9eecf8c5969842e7a2ec15e4784de2bb',0,0,0,NULL,'public',0,NULL,NULL),('ca497423-5de9-4d32-967f-3253f68ba338','tempest-image-690765182',1024,'deleted','2025-12-05 10:09:09','2025-12-05 10:09:13','2025-12-05 10:09:13',1,'qcow2','bare','a8146cf0d853e5474ec465843c835574','c7dbee2ced7147429311c1ce1cf2a939',0,0,0,NULL,'private',0,'sha512','0536c9002b2c657860694d2ea755c8da0a381c9c64a0b79ee8cd64631b12b9339c0b1b01dd2279ca3f614b88a7354b98495b6fadbc06cfb8bf1156f33f84be5a'),('cfd5b7bd-97a1-4256-9728-e0ca1a84b65b',NULL,NULL,'deleted','2025-12-05 10:08:43','2025-12-05 10:08:43','2025-12-05 10:08:43',1,'raw','bare',NULL,'55223900e0ee45fb828ff0d37afadf74',0,0,0,NULL,'shared',0,NULL,NULL),('d3e02861-a64a-4cdb-8324-ba63c5aaf4cd','cirros-0.6.2-x86_64-disk.img_alt',21430272,'active','2025-12-05 10:03:26','2025-12-05 10:03:28',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','e6ca8a92050741d3a93772e6c1b0d704',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('d525d7ed-af91-42b5-9c1f-bbf96cc9ac72','tempest-ListUserImagesTest-image-53114070',3432,'deleted','2025-12-05 10:06:10','2025-12-05 10:06:23','2025-12-05 10:06:23',1,'ami','bare','74349e776a1c4d058b175019b493e6ea','a5e423e05eb84045a5d63179380884e6',0,0,0,NULL,'private',0,'sha512','f9a2a89c2633c2b7ba61835540357482f3207d8d8b435d52ec2268fdf52a0a2657ee899cb3d5bf739b53806470e41a4f5d1583691997735a27c7c109b6d2a840'),('d5f5a291-6ead-4941-8630-39b40b0aa747','tempest-ListUserImagesTest-image-2006349220',NULL,'deleted','2025-12-05 10:06:15','2025-12-05 10:06:15','2025-12-05 10:06:15',1,NULL,NULL,NULL,'a5e423e05eb84045a5d63179380884e6',0,0,0,NULL,'shared',1,NULL,NULL),('daad7a7d-00a1-449e-af30-bc504832c3bf','tempest-VolumesActionsTest-Image-934847656',1073741824,'deleted','2025-12-05 10:14:26','2025-12-05 10:15:17','2025-12-05 10:15:17',1,'raw','bare','cd573cfaace07e7949bc0c46028904ff','8730b222fadf4a249823e59d8b326dde',0,0,0,1073741824,'shared',0,'sha512','c5041ae163cf0f65600acfe7f6a63f212101687d41a57a4e18ffd2a07a452cd8175b8f5a4868dd2330bfe5ae123f18216bdbc9e0f80d131e64b94913a7b40bb5'),('e4caba08-8947-42db-ac72-1072bf67b7f4','tempest-ImagesTagsNegativeTest-image-620376026',NULL,'deleted','2025-12-05 10:06:43','2025-12-05 10:06:43','2025-12-05 10:06:43',1,'raw','bare',NULL,'0159563ba25d406a8b9b7b69482bd4df',0,0,0,NULL,'private',0,NULL,NULL),('e71bdfda-2761-42b5-9ef0-d82a332c5424','tempest-UnshelveToHostMultiNodesTest-server-1049485283-shelved',1073741824,'deleted','2025-12-05 10:04:40','2025-12-05 10:05:09','2025-12-05 10:05:09',1,'raw','bare',NULL,'c5f7af554c09472ab3fd27dd1c35c543',1,0,0,NULL,'private',0,NULL,NULL),('e7469c27-9043-4bd0-b0a4-5b489dcf3ae2','cirros',21692416,'active','2025-12-05 08:34:23','2025-12-05 08:34:28',NULL,0,'qcow2','bare','87617e24a5e30cb3b87fda8c0764838f','e6ca8a92050741d3a93772e6c1b0d704',0,0,0,117440512,'shared',0,'sha512','9a9bce0083a00939ec17c11febbfc767aa211aaa54f51e75c5a8b271a9b5637c77205a518b7a2007cb391d23cceb01e0e4e8d64832317151bc85b734b92a7be0'),('edd71fb4-5152-41d2-b83c-91ae600e1685','tempest-image-181973252',117440512,'deleted','2025-12-05 10:06:20','2025-12-05 10:06:29','2025-12-05 10:06:29',1,'raw','bare','4245576e3df99ea1211871b8b9514d3b','b8acd29b55e34e8ea4c7e1f26e3cb6da',0,0,0,117440512,'private',0,'sha512','dbb480bdc4f13ead7e00b62766df2815ddc8d4775af8a82ec40f8afd433d4cb95a109a58fbe7e0a661be86e0a06321c00362bc881f58c61c40bd2d1486954594'),('ee5ddc3f-3b95-49c0-98bd-f98089cf180c','tempest-VolumesNegativeTest-image-749386422',1024,'deleted','2025-12-05 10:09:30','2025-12-05 10:09:34','2025-12-05 10:09:34',1,'qcow2','bare','b8a2bf2ba7b7e95817267599bc6c02d5','2eb8cf0d784b4d188f16c04a39a755a9',2,0,0,NULL,'private',0,'sha512','8f777c3a101a2b41ceed0405a8fa60fdbf04e2b001618fe056842c840c88d8f1b2d345b9e138f1a57ea9941c1501972afcb7dd09a5f976232ec9550162f716c1'),('f67023e2-353d-4de8-b5e5-7921df600775','tempest-UnshelveToHostMultiNodesTest-server-1049485283-shelved',1073741824,'deleted','2025-12-05 10:05:11','2025-12-05 10:05:50','2025-12-05 10:05:50',1,'raw','bare',NULL,'c5f7af554c09472ab3fd27dd1c35c543',1,0,0,NULL,'private',0,NULL,NULL),('fa60b228-b906-49ef-8f98-14891efbdebf','tempest-image-1398840529',1024,'deleted','2025-12-05 10:09:07','2025-12-05 10:09:15','2025-12-05 10:09:15',1,'raw','bare','40315355725e39cd77c79fbfd5c99b8b','c7dbee2ced7147429311c1ce1cf2a939',0,0,0,1024,'private',0,'sha512','ea5c13d2532fb1784e190f69819815f4c68619f1792820796e27255f6c8f5d115e4bce012cb1c1ce92cb28a5441fa1d19f32e62c5cb28146a0f4f9d13566ecfc'),('fc7040be-262c-459e-b785-40b8a1176929','tempest-ImagesMemberTest-image-686597328',NULL,'deleted','2025-12-05 10:06:33','2025-12-05 10:06:33','2025-12-05 10:06:33',1,'raw','bare',NULL,'9b0fff2630ba47b5a0dab782a82c2214',0,0,0,NULL,'shared',0,NULL,NULL);
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespace_resource_types`
--

DROP TABLE IF EXISTS `metadef_namespace_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespace_resource_types` (
  `resource_type_id` int(11) NOT NULL,
  `namespace_id` int(11) NOT NULL,
  `properties_target` varchar(80) DEFAULT NULL,
  `prefix` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`resource_type_id`,`namespace_id`),
  KEY `ix_metadef_ns_res_types_namespace_id` (`namespace_id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_2` FOREIGN KEY (`resource_type_id`) REFERENCES `metadef_resource_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespace_resource_types`
--

LOCK TABLES `metadef_namespace_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_namespace_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_namespace_resource_types` (`resource_type_id`, `namespace_id`, `properties_target`, `prefix`, `created_at`, `updated_at`) VALUES (2,2,'image','CIM_PASD_','2025-12-05 08:17:42',NULL),(2,5,'image','CIM_RASD_','2025-12-05 08:17:43',NULL),(2,8,NULL,'CIM_SASD_','2025-12-05 08:17:43',NULL),(2,23,'image','hw_','2025-12-05 08:17:44',NULL),(2,26,'image','hw_','2025-12-05 08:17:45',NULL),(2,38,'image',NULL,'2025-12-05 08:17:46',NULL),(2,53,'image','hw_','2025-12-05 08:17:48',NULL),(2,65,'image','hw_','2025-12-05 08:17:49',NULL),(2,77,'image',NULL,'2025-12-05 08:17:50',NULL),(2,80,'image',NULL,'2025-12-05 08:17:50',NULL),(2,83,'image',NULL,'2025-12-05 08:17:51',NULL),(2,86,'image',NULL,'2025-12-05 08:17:51',NULL),(5,2,NULL,'CIM_PASD_','2025-12-05 08:17:42',NULL),(5,23,NULL,'hw_','2025-12-05 08:17:44',NULL),(5,26,NULL,'hw_','2025-12-05 08:17:45',NULL),(5,29,NULL,NULL,'2025-12-05 08:17:45',NULL),(5,35,NULL,NULL,'2025-12-05 08:17:46',NULL),(5,38,NULL,NULL,'2025-12-05 08:17:46',NULL),(5,41,NULL,NULL,'2025-12-05 08:17:46',NULL),(5,44,NULL,'hw_','2025-12-05 08:17:47',NULL),(5,53,NULL,'hw_','2025-12-05 08:17:48',NULL),(5,62,NULL,NULL,'2025-12-05 08:17:48',NULL),(5,65,NULL,'hw_','2025-12-05 08:17:49',NULL),(5,68,NULL,NULL,'2025-12-05 08:17:49',NULL),(5,74,NULL,NULL,'2025-12-05 08:17:50',NULL),(5,77,NULL,NULL,'2025-12-05 08:17:50',NULL),(5,80,NULL,NULL,'2025-12-05 08:17:50',NULL),(5,83,NULL,NULL,'2025-12-05 08:17:51',NULL),(5,86,NULL,NULL,'2025-12-05 08:17:51',NULL),(5,89,NULL,'cinder_','2025-12-05 08:17:52',NULL),(5,92,NULL,'hw_','2025-12-05 08:55:18',NULL),(5,93,NULL,'hw_','2025-12-05 08:55:18',NULL),(5,94,NULL,'traits:','2025-12-05 08:55:18',NULL),(8,2,NULL,'CIM_PASD_','2025-12-05 08:17:42',NULL),(8,5,NULL,'CIM_RASD_','2025-12-05 08:17:43',NULL),(8,8,NULL,'CIM_SASD_','2025-12-05 08:17:43',NULL),(8,11,NULL,'CIM_VSSD_','2025-12-05 08:17:44',NULL),(8,14,NULL,NULL,'2025-12-05 08:17:44',NULL),(8,17,NULL,NULL,'2025-12-05 08:17:44',NULL),(8,20,NULL,NULL,'2025-12-05 08:17:44',NULL),(8,32,NULL,'aggregate_instance_extra_specs:','2025-12-05 08:17:45',NULL),(11,2,NULL,'CIM_PASD_','2025-12-05 08:17:42',NULL),(11,5,NULL,'CIM_RASD_','2025-12-05 08:17:43',NULL),(11,8,NULL,'CIM_SASD_','2025-12-05 08:17:43',NULL),(11,11,NULL,'CIM_VSSD_','2025-12-05 08:17:44',NULL),(11,23,NULL,'hw:','2025-12-05 08:17:44',NULL),(11,26,NULL,'hw:','2025-12-05 08:17:45',NULL),(11,32,NULL,'capabilities:','2025-12-05 08:17:45',NULL),(11,44,NULL,'hw:','2025-12-05 08:17:47',NULL),(11,47,NULL,NULL,'2025-12-05 08:17:47',NULL),(11,50,NULL,NULL,'2025-12-05 08:17:47',NULL),(11,53,NULL,'hw:','2025-12-05 08:17:48',NULL),(11,56,NULL,NULL,'2025-12-05 08:17:48',NULL),(11,59,NULL,NULL,'2025-12-05 08:17:48',NULL),(11,65,NULL,'hw:','2025-12-05 08:17:49',NULL),(11,92,NULL,'hw:','2025-12-05 08:55:18',NULL),(11,93,NULL,'hw:','2025-12-05 08:55:18',NULL),(11,94,NULL,'traits:','2025-12-05 08:55:18',NULL),(14,2,'scheduler_hints',NULL,'2025-12-05 08:17:43',NULL),(14,80,'metadata',NULL,'2025-12-05 08:17:50',NULL),(14,83,'metadata',NULL,'2025-12-05 08:17:51',NULL),(14,86,'metadata',NULL,'2025-12-05 08:17:51',NULL),(17,80,NULL,NULL,'2025-12-05 08:17:50',NULL);
/*!40000 ALTER TABLE `metadef_namespace_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespaces`
--

DROP TABLE IF EXISTS `metadef_namespaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespaces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace` varchar(80) NOT NULL,
  `display_name` varchar(80) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `visibility` varchar(32) DEFAULT NULL,
  `protected` tinyint(1) DEFAULT NULL,
  `owner` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_namespaces_namespace` (`namespace`),
  KEY `ix_metadef_namespaces_owner` (`owner`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=103 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespaces`
--

LOCK TABLES `metadef_namespaces` WRITE;
/*!40000 ALTER TABLE `metadef_namespaces` DISABLE KEYS */;
INSERT INTO `metadef_namespaces` (`id`, `namespace`, `display_name`, `description`, `visibility`, `protected`, `owner`, `created_at`, `updated_at`) VALUES (2,'CIM::ProcessorAllocationSettingData','CIM Processor Allocation Setting','Properties related to the resource allocation settings of a processor (CPU) from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These are properties that identify processor setting data and may be specified to volume, image, host aggregate, flavor and Nova server as scheduler hint. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ProcessorAllocationSettingData.html.','public',1,'admin','2025-12-05 08:17:42',NULL),(5,'CIM::ResourceAllocationSettingData','CIM Resource Allocation Setting Data','Properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim) that represent settings specifically related to an allocated resource that are outside the scope of the CIM class typically used to represent the resource itself. These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ResourceAllocationSettingData.html.','public',1,'admin','2025-12-05 08:17:43',NULL),(8,'CIM::StorageAllocationSettingData','CIM Storage Allocation Setting Data','Properties related to the allocation of virtual storage from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_StorageAllocationSettingData.html.','public',1,'admin','2025-12-05 08:17:43',NULL),(11,'CIM::VirtualSystemSettingData','CIM Virtual System Setting Data','A set of virtualization specific properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim), which define the virtual aspects of a virtual system. These properties may be specified to host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_VirtualSystemSettingData.html.','public',1,'admin','2025-12-05 08:17:43',NULL),(14,'OS::Compute::AggregateDiskFilter','Disk Allocation per Host','Properties related to the Nova scheduler filter AggregateDiskFilter. Filters aggregate hosts based on the available disk space compared to the requested disk space. Hosts in the aggregate with not enough usable disk will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-12-05 08:17:44',NULL),(17,'OS::Compute::AggregateIoOpsFilter','IO Ops per Host','Properties related to the Nova scheduler filter AggregateIoOpsFilter. Filters aggregate hosts based on the number of instances currently changing state. Hosts in the aggregate with too many instances changing state will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-12-05 08:17:44',NULL),(20,'OS::Compute::AggregateNumInstancesFilter','Instances per Host','Properties related to the Nova scheduler filter AggregateNumInstancesFilter. Filters aggregate hosts by the number of running instances on it. Hosts in the aggregate with too many instances will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',0,'admin','2025-12-05 08:17:44',NULL),(23,'OS::Compute::CPUPinning','CPU Pinning','This provides the preferred CPU pinning and CPU thread pinning policy to be used when pinning vCPU of the guest to pCPU of the host. See http://docs.openstack.org/admin-guide/compute-numa-cpu-pinning.html','public',1,'admin','2025-12-05 08:17:44',NULL),(26,'OS::Compute::GuestMemoryBacking','Guest Memory Backing','This provides the preferred backing option for guest RAM. Guest\'s memory can be backed by hugepages to limit TLB lookups. See also: https://wiki.openstack.org/wiki/VirtDriverGuestCPUMemoryPlacement','public',1,'admin','2025-12-05 08:17:45',NULL),(29,'OS::Compute::GuestShutdownBehavior','Shutdown Behavior','These properties allow modifying the shutdown behavior for stop, rescue, resize, and shelve operations.','public',1,'admin','2025-12-05 08:17:45',NULL),(32,'OS::Compute::HostCapabilities','Compute Host Capabilities','Hardware capabilities provided by the compute host. This provides the ability to fine tune the hardware specification required when an instance is requested. The ComputeCapabilitiesFilter should be enabled in the Nova scheduler to use these properties. When enabled, this filter checks that the capabilities provided by the compute host satisfy any extra specifications requested. Only hosts that can provide the requested capabilities will be eligible for hosting the instance.','public',1,'admin','2025-12-05 08:17:45',NULL),(35,'OS::Compute::Hypervisor','Hypervisor Selection','OpenStack Compute supports many hypervisors, although most installations use only one hypervisor. For installations with multiple supported hypervisors, you can schedule different hypervisors using the ImagePropertiesFilter. This filters compute nodes that satisfy any architecture, hypervisor type, or virtual machine mode properties specified on the instance\'s image properties.','public',1,'admin','2025-12-05 08:17:46',NULL),(38,'OS::Compute::InstanceData','Instance Config Data','Instances can perform self-configuration based on data made available to the running instance. These properties affect instance configuration.','public',1,'admin','2025-12-05 08:17:46',NULL),(41,'OS::Compute::LibvirtImage','libvirt Driver Options for Images','The libvirt Compute Driver Options for Glance Images.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-05 08:17:46',NULL),(44,'OS::Compute::Libvirt','libvirt Driver Options','The libvirt compute driver options.  \n\nThese are properties that affect the libvirt compute driver and may be specified on flavors and images.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-05 08:17:47',NULL),(47,'OS::Compute::Quota','Flavor Quota','Compute drivers may enable quotas on CPUs available to a VM, disk tuning, bandwidth I/O, and instance VIF traffic control.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-05 08:17:47',NULL),(50,'OS::Compute::RandomNumberGenerator','Random Number Generator','If a random-number generator device has been added to the instance through its image properties, the device can be enabled and configured.','public',1,'admin','2025-12-05 08:17:47',NULL),(53,'OS::Compute::VirtCPUTopology','Virtual CPU Topology','This provides the preferred socket/core/thread counts for the virtual CPU instance exposed to guests. This enables the ability to avoid hitting limitations on vCPU topologies that OS vendors place on their products. See also: https://opendev.org/openstack/nova-specs/src/branch/master/specs/juno/implemented/virt-driver-vcpu-topology.rst','public',1,'admin','2025-12-05 08:17:48',NULL),(56,'OS::Compute::VMwareFlavor','VMware Driver Options for Flavors','VMware Driver Options for Flavors may be used to customize and manage Nova Flavors. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-05 08:17:48',NULL),(59,'OS::Compute::VMwareQuotaFlavor','VMware Quota for Flavors','The VMware compute driver allows various compute quotas to be specified on flavors. When specified, the VMWare driver will ensure that the quota is enforced. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. For a list of hypervisors, see: https://wiki.openstack.org/wiki/HypervisorSupportMatrix. For flavor customization, see: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-05 08:17:48',NULL),(62,'OS::Compute::VMware','VMware Driver Options','The VMware compute driver options.  \n\nThese are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-05 08:17:48',NULL),(65,'OS::Compute::Watchdog','Watchdog Behavior','Compute drivers may enable watchdog behavior over instances.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-05 08:17:49',NULL),(68,'OS::Compute::XenAPI','XenAPI Driver Options','The XenAPI compute driver options.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-05 08:17:49',NULL),(71,'OS::Glance::CommonImageProperties','Common Image Properties','When adding an image to Glance, you may specify some common image properties that may prove useful to consumers of your image.',NULL,1,'admin','2025-12-05 08:17:49',NULL),(74,'OS::Glance::Signatures','Image Signature Verification','Image signature verification allows the user to verify that an image has not been modified prior to booting the image.','public',0,'admin','2025-12-05 08:17:49',NULL),(77,'OS::OperatingSystem','Common Operating System Properties','Details of the operating system contained within this image as well as common operating system properties that can be set on a VM instance created from this image.',NULL,1,'admin','2025-12-05 08:17:50',NULL),(80,'OS::Software::DBMS','Database Software','A database is an organized collection of data. The data is typically organized to model aspects of reality in a way that supports processes requiring information. Database management systems are computer software applications that interact with the user, other applications, and the database itself to capture and analyze data. (http://en.wikipedia.org/wiki/Database)','public',1,'admin','2025-12-05 08:17:50',NULL),(83,'OS::Software::Runtimes','Runtime Environment','Software is written in a specific programming language and the language must execute within a runtime environment. The runtime environment provides an abstraction to utilizing a computer\'s processor, memory (RAM), and other system resources.','public',1,'admin','2025-12-05 08:17:51',NULL),(86,'OS::Software::WebServers','Web Servers','A web server is a computer system that processes requests via HTTP, the basic network protocol used to distribute information on the World Wide Web. The most common use of web servers is to host websites, but there are other uses such as gaming, data storage, running enterprise applications, handling email, FTP, or other web uses. (http://en.wikipedia.org/wiki/Web_server)','public',1,'admin','2025-12-05 08:17:51',NULL),(89,'OS::Cinder::Volumetype','Cinder Volume Type','The Cinder volume type configuration option. Volume type assignment provides a mechanism not only to provide scheduling to a specific storage back-end, but also can be used to specify specific information for a back-end storage device to act upon.','public',1,'admin','2025-12-05 08:17:52',NULL),(92,'OS::Compute::CPUMode','CPU Mode','This provides the preferred CPU Model to be used when booting up a guest VM.','public',NULL,'admin','2025-12-05 08:55:18',NULL),(93,'OS::Compute::TPM','TPM Options','Configuration options for TPM','public',1,'admin','2025-12-05 08:55:18',NULL),(94,'OS::Compute::VTPM','Emulated Virtual TPM','Configuration options for Emulated Virtual TPM','public',1,'admin','2025-12-05 08:55:18',NULL);
/*!40000 ALTER TABLE `metadef_namespaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_objects`
--

DROP TABLE IF EXISTS `metadef_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `description` text DEFAULT NULL,
  `required` text DEFAULT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_objects_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_objects_name` (`name`),
  CONSTRAINT `metadef_objects_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_objects`
--

LOCK TABLES `metadef_objects` WRITE;
/*!40000 ALTER TABLE `metadef_objects` DISABLE KEYS */;
INSERT INTO `metadef_objects` (`id`, `namespace_id`, `name`, `description`, `required`, `json_schema`, `created_at`, `updated_at`) VALUES (2,47,'CPU Limits','You can configure the CPU limits with control parameters.',NULL,'{\"quota:cpu_shares\": {\"title\": \"Quota: CPU Shares\", \"description\": \"Specifies the proportional weighted share for the domain. If this element is omitted, the service defaults to the OS provided defaults. There is no unit for the value; it is a relative measure based on the setting of other VMs. For example, a VM configured with value 2048 gets twice as much CPU time as a VM configured with value 1024.\", \"type\": \"integer\"}, \"quota:cpu_period\": {\"title\": \"Quota: CPU Period\", \"description\": \"Specifies the enforcement interval (unit: microseconds) for QEMU and LXC hypervisors. Within a period, each VCPU of the domain is not allowed to consume more than the quota worth of runtime. The value should be in range [1000, 1000000]. A period with value 0 means no value.\", \"type\": \"integer\", \"minimum\": 1000, \"maximum\": 1000000}, \"quota:cpu_quota\": {\"title\": \"Quota: CPU Quota\", \"description\": \"Specifies the maximum allowed bandwidth (unit: microseconds). A domain with a negative-value quota indicates that the domain has infinite bandwidth, which means that it is not bandwidth controlled. The value should be in range [1000, 18446744073709551] or less than 0. A quota with value 0 means no value. You can use this feature to ensure that all vCPUs run at the same speed.\", \"type\": \"integer\"}}','2025-12-05 08:17:47',NULL),(5,47,'Disk QoS','Using disk I/O quotas, you can set maximum disk write to 10 MB per second for a VM user.',NULL,'{\"quota:disk_read_bytes_sec\": {\"title\": \"Quota: Disk read bytes / sec\", \"description\": \"Sets disk I/O quota for disk read bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_read_iops_sec\": {\"title\": \"Quota: Disk read IOPS / sec\", \"description\": \"Sets disk I/O quota for disk read IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_write_bytes_sec\": {\"title\": \"Quota: Disk Write Bytes / sec\", \"description\": \"Sets disk I/O quota for disk write bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_write_iops_sec\": {\"title\": \"Quota: Disk Write IOPS / sec\", \"description\": \"Sets disk I/O quota for disk write IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_total_bytes_sec\": {\"title\": \"Quota: Disk Total Bytes / sec\", \"description\": \"Sets disk I/O quota for total disk bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_total_iops_sec\": {\"title\": \"Quota: Disk Total IOPS / sec\", \"description\": \"Sets disk I/O quota for disk total IOPS / sec.\", \"type\": \"integer\"}}','2025-12-05 08:17:47',NULL),(8,47,'Virtual Interface QoS','Bandwidth QoS tuning for instance virtual interfaces (VIFs) may be specified with these properties. Incoming and outgoing traffic can be shaped independently. If not specified, no quality of service (QoS) is applied on that traffic direction. So, if you want to shape only the network\'s incoming traffic, use inbound only (and vice versa). The OpenStack Networking service abstracts the physical implementation of the network, allowing plugins to configure and manage physical resources. Virtual Interfaces (VIF) in the logical model are analogous to physical network interface cards (NICs). VIFs are typically owned a managed by an external service; for instance when OpenStack Networking is used for building OpenStack networks, VIFs would be created, owned, and managed in Nova. VIFs are connected to OpenStack Networking networks via ports. A port is analogous to a port on a network switch, and it has an administrative state. When a VIF is attached to a port the OpenStack Networking API creates an attachment object, which specifies the fact that a VIF with a given identifier is plugged into the port.',NULL,'{\"quota:vif_inbound_average\": {\"title\": \"Quota: VIF Inbound Average\", \"description\": \"Network Virtual Interface (VIF) inbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_inbound_burst\": {\"title\": \"Quota: VIF Inbound Burst\", \"description\": \"Network Virtual Interface (VIF) inbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_inbound_peak\": {\"title\": \"Quota: VIF Inbound Peak\", \"description\": \"Network Virtual Interface (VIF) inbound peak in kilobytes per second. Specifies maximum rate at which an interface can receive data.\", \"type\": \"integer\"}, \"quota:vif_outbound_average\": {\"title\": \"Quota: VIF Outbound Average\", \"description\": \"Network Virtual Interface (VIF) outbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_outbound_burst\": {\"title\": \"Quota: VIF Outbound Burst\", \"description\": \"Network Virtual Interface (VIF) outbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_outbound_peak\": {\"title\": \"Quota: VIF Outbound Peak\", \"description\": \"Network Virtual Interface (VIF) outbound peak in kilobytes per second. Specifies maximum rate at which an interface can send data.\", \"type\": \"integer\"}}','2025-12-05 08:17:47',NULL),(11,80,'MySQL','MySQL is an object-relational database management system (ORDBMS). The MySQL development project has made its source code available under the terms of the GNU General Public License, as well as under a variety of proprietary agreements. MySQL was owned and sponsored by a single for-profit firm, the Swedish company MySQL AB, now owned by Oracle Corporation. MySQL is a popular choice of database for use in web applications, and is a central component of the widely used LAMP open source web application software stack (and other \'AMP\' stacks). (http://en.wikipedia.org/wiki/MySQL)',NULL,'{\"sw_database_mysql_version\": {\"title\": \"Version\", \"description\": \"The specific version of MySQL.\", \"type\": \"string\"}, \"sw_database_mysql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"The configured TCP/IP port which MySQL listens for incoming connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 3606}, \"sw_database_mysql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"root\"}}','2025-12-05 08:17:50',NULL),(14,80,'PostgreSQL','PostgreSQL, often simply \'Postgres\', is an object-relational database management system (ORDBMS) with an emphasis on extensibility and standards-compliance. PostgreSQL is cross-platform and runs on many operating systems. (http://en.wikipedia.org/wiki/PostgreSQL)',NULL,'{\"sw_database_postgresql_version\": {\"title\": \"Version\", \"description\": \"The specific version of PostgreSQL.\", \"type\": \"string\"}, \"sw_database_postgresql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which PostgreSQL is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_postgresql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"postgres\"}}','2025-12-05 08:17:50',NULL),(17,80,'SQL Server','Microsoft SQL Server is a relational database management system developed by Microsoft. There are at least a dozen different editions of Microsoft SQL Server aimed at different audiences and for workloads ranging from small single-machine applications to large Internet-facing applications with many concurrent users. Its primary query languages are T-SQL and ANSI SQL. (http://en.wikipedia.org/wiki/Microsoft_SQL_Server)',NULL,'{\"sw_database_sqlserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Microsoft SQL Server.\", \"type\": \"string\"}, \"sw_database_sqlserver_edition\": {\"title\": \"Edition\", \"description\": \"SQL Server is available in multiple editions, with different feature sets and targeting different users.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Datacenter\", \"Enterprise\", \"Standard\", \"Web\", \"Business Intelligence\", \"Workgroup\", \"Express\", \"Compact (SQL CE)\", \"Developer\", \"Embedded (SSEE)\", \"Express\", \"Fast Track\", \"LocalDB\", \"Parallel Data Warehouse (PDW)\", \"Business Intelligence\", \"Datawarehouse Appliance Edition\"]}, \"sw_database_sqlserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which SQL Server is to listen for connections from client applications. The default SQL Server port is 1433, and client ports are assigned a random value between 1024 and 5000.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1433}, \"sw_database_postsqlserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"sa\"}}','2025-12-05 08:17:50',NULL),(20,80,'Oracle','Oracle Database (commonly referred to as Oracle RDBMS or simply as Oracle) is an object-relational database management system produced and marketed by Oracle Corporation. (http://en.wikipedia.org/wiki/Oracle_Database)',NULL,'{\"sw_database_oracle_version\": {\"title\": \"Version\", \"description\": \"The specific version of Oracle.\", \"type\": \"string\"}, \"sw_database_oracle_edition\": {\"title\": \"Edition\", \"description\": \"Over and above the different versions of the Oracle database management software developed over time, Oracle Corporation subdivides its product into varying editions.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Enterprise\", \"Standard\", \"Standard Edition One\", \"Express (XE)\", \"Workgroup\", \"Lite\"]}, \"sw_database_oracle_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Oracle is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1521}}','2025-12-05 08:17:50',NULL),(23,80,'DB2','IBM DB2 is a family of database server products developed by IBM. These products all support the relational model, but in recent years some products have been extended to support object-relational features and non-relational structures, in particular XML. (http://en.wikipedia.org/wiki/IBM_DB2)',NULL,'{\"sw_database_db2_version\": {\"title\": \"Version\", \"description\": \"The specific version of DB2.\", \"type\": \"string\"}, \"sw_database_db2_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which DB2 is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_db2_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-12-05 08:17:51',NULL),(26,80,'MongoDB','MongoDB is a cross-platform document-oriented database. Classified as a NoSQL database, MongoDB uses JSON-like documents with dynamic schemas (MongoDB calls the format BSON), making the integration of data in certain types of applications easier and faster. Released under a combination of the GNU Affero General Public License and the Apache License, MongoDB is free and open-source software. (http://en.wikipedia.org/wiki/MongoDB)',NULL,'{\"sw_database_mongodb_version\": {\"title\": \"Version\", \"description\": \"The specific version of MongoDB.\", \"type\": \"string\"}, \"sw_database_mongodb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which MongoDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 27017}, \"sw_database_mongodb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-12-05 08:17:51',NULL),(29,80,'Couchbase Server','Couchbase Server, originally known as Membase, is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications. These applications must serve many concurrent users by creating, storing, retrieving, aggregating, manipulating and presenting data. In support of these kinds of application needs, Couchbase is designed to provide easy-to-scale key-value or document access with low latency and high sustained throughput. (http://en.wikipedia.org/wiki/Couchbase_Server)',NULL,'{\"sw_database_couchbaseserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Couchbase Server.\", \"type\": \"string\"}, \"sw_database_couchbaseserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Couchbase is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 11211}, \"sw_database_couchbaseserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-12-05 08:17:51',NULL),(32,80,'Redis','Redis is a data structure server (NoSQL). It is open-source, networked, in-memory, and stores keys with optional durability. The development of Redis has been sponsored by Pivotal Software since May 2013; before that, it was sponsored by VMware. The name Redis means REmote DIctionary Server. (http://en.wikipedia.org/wiki/Redis)',NULL,'{\"sw_database_redis_version\": {\"title\": \"Version\", \"description\": \"The specific version of Redis.\", \"type\": \"string\"}, \"sw_database_redis_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Redis is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 6379}, \"sw_database_redis_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-12-05 08:17:51',NULL),(35,80,'CouchDB','Apache CouchDB, commonly referred to as CouchDB, is an open source NoSQL database. It is a NoSQL database that uses JSON to store data, JavaScript as its query language using MapReduce, and HTTP for an API. One of its distinguishing features is multi-master replication. CouchDB was first released in 2005 and later became an Apache project in 2008. (http://en.wikipedia.org/wiki/CouchDB)',NULL,'{\"sw_database_couchdb_version\": {\"title\": \"Version\", \"description\": \"The specific version of CouchDB.\", \"type\": \"string\"}, \"sw_database_couchdb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which CouchDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5984}, \"sw_database_couchdb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-12-05 08:17:51',NULL),(38,80,'Apache Cassandra','Apache Cassandra is an open source distributed NoSQL database management system designed to handle large amounts of data across many commodity servers, providing high availability with no single point of failure. (http://en.wikipedia.org/wiki/Apache_Cassandra)',NULL,'{\"sw_database_cassandra_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache Cassandra.\", \"type\": \"string\"}, \"sw_database_cassandra_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Cassandra is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 9160}, \"sw_database_cassandra_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"cassandra\"}}','2025-12-05 08:17:51',NULL),(41,80,'HBase','HBase is an open source, non-relational (NoSQL), distributed database modeled after Google\'s BigTable and written in Java. It is developed as part of Apache Software Foundation\'s Apache Hadoop project and runs on top of HDFS (Hadoop Distributed Filesystem), providing BigTable-like capabilities for Hadoop. (http://en.wikipedia.org/wiki/Apache_HBase)',NULL,'{\"sw_database_hbase_version\": {\"title\": \"Version\", \"description\": \"The specific version of HBase.\", \"type\": \"string\"}}','2025-12-05 08:17:51',NULL),(44,80,'Hazlecast','In computing, Hazelcast is an in-memory open source software data grid based on Java. By having multiple nodes form a cluster, data is evenly distributed among the nodes. This allows for horizontal scaling both in terms of available storage space and processing power. Backups are also distributed in a similar fashion to other nodes, based on configuration, thereby protecting against single node failure. (http://en.wikipedia.org/wiki/Hazelcast)',NULL,'{\"sw_database_hazlecast_version\": {\"title\": \"Version\", \"description\": \"The specific version of Hazlecast.\", \"type\": \"string\"}, \"sw_database_hazlecast_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Hazlecast is to listen for connections between members.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5701}}','2025-12-05 08:17:51',NULL),(47,83,'PHP','PHP is a server-side scripting language designed for web development but also used as a general-purpose programming language. PHP code can be simply mixed with HTML code, or it can be used in combination with various templating engines and web frameworks. PHP code is usually processed by a PHP interpreter, which is usually implemented as a web server\'s native module or a Common Gateway Interface (CGI) executable. After the PHP code is interpreted and executed, the web server sends resulting output to its client, usually in form of a part of the generated web page – for example, PHP code can generate a web page\'s HTML code, an image, or some other data. PHP has also evolved to include a command-line interface (CLI) capability and can be used in standalone graphical applications. (http://en.wikipedia.org/wiki/PHP)',NULL,'{\"sw_runtime_php_version\": {\"title\": \"Version\", \"description\": \"The specific version of PHP.\", \"type\": \"string\"}}','2025-12-05 08:17:51',NULL),(50,83,'Python','Python is a widely used general-purpose, high-level programming language. Its design philosophy emphasizes code readability, and its syntax allows programmers to express concepts in fewer lines of code than would be possible in languages such as C++ or Java. The language provides constructs intended to enable clear programs on both a small and large scale. Python supports multiple programming paradigms, including object-oriented, imperative and functional programming or procedural styles. It features a dynamic type system and automatic memory management and has a large and comprehensive standard library. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_python_version\": {\"title\": \"Version\", \"description\": \"The specific version of python.\", \"type\": \"string\"}}','2025-12-05 08:17:51',NULL),(53,83,'Java','Java is a functional computer programming language that is concurrent, class-based, object-oriented, and specifically designed to have as few implementation dependencies as possible. It is intended to let application developers write once, run anywhere (WORA), meaning that code that runs on one platform does not need to be recompiled to run on another. Java applications are typically compiled to bytecode that can run on any Java virtual machine (JVM) regardless of computer architecture. (http://en.wikipedia.org/wiki/Java_(programming_language))',NULL,'{\"sw_runtime_java_version\": {\"title\": \"Version\", \"description\": \"The specific version of Java.\", \"type\": \"string\"}}','2025-12-05 08:17:51',NULL),(56,83,'Ruby','Ruby is a dynamic, reflective, object-oriented, general-purpose programming language. It was designed and developed in the mid-1990s by Yukihiro Matsumoto in Japan. According to its authors, Ruby was influenced by Perl, Smalltalk, Eiffel, Ada, and Lisp. It supports multiple programming paradigms, including functional, object-oriented, and imperative. It also has a dynamic type system and automatic memory management. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_ruby_version\": {\"title\": \"Version\", \"description\": \"The specific version of Ruby.\", \"type\": \"string\"}}','2025-12-05 08:17:51',NULL),(59,83,'Perl','Perl is a family of high-level, general-purpose, interpreted, dynamic programming languages. The languages in this family include Perl 5 and Perl 6. Though Perl is not officially an acronym, there are various backronyms in use, the most well-known being Practical Extraction and Reporting Language (http://en.wikipedia.org/wiki/Perl)',NULL,'{\"sw_runtime_perl_version\": {\"title\": \"Version\", \"description\": \"The specific version of Perl.\", \"type\": \"string\"}}','2025-12-05 08:17:51',NULL),(62,86,'Apache HTTP Server','The Apache HTTP Server, colloquially called Apache, is a Web server application notable for playing a key role in the initial growth of the World Wide Web. Apache is developed and maintained by an open community of developers under the auspices of the Apache Software Foundation. Most commonly used on a Unix-like system, the software is available for a wide variety of operating systems, including Unix, FreeBSD, Linux, Solaris, Novell NetWare, OS X, Microsoft Windows, OS/2, TPF, OpenVMS and eComStation. Released under the Apache License, Apache is open-source software. (http://en.wikipedia.org/wiki/Apache_HTTP_Server)',NULL,'{\"sw_webserver_apache_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache.\", \"type\": \"string\"}, \"sw_webserver_apache_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_apache_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-12-05 08:17:52',NULL),(65,86,'Nginx','Nginx (pronounced \'engine-x\') is an open source reverse proxy server for HTTP, HTTPS, SMTP, POP3, and IMAP protocols, as well as a load balancer, HTTP cache, and a web server (origin server). The nginx project started with a strong focus on high concurrency, high performance and low memory usage. It is licensed under the 2-clause BSD-like license and it runs on Linux, BSD variants, Mac OS X, Solaris, AIX, HP-UX, as well as on other *nix flavors. It also has a proof of concept port for Microsoft Windows. (http://en.wikipedia.org/wiki/Nginx)',NULL,'{\"sw_webserver_nginx_version\": {\"title\": \"Version\", \"description\": \"The specific version of Nginx.\", \"type\": \"string\"}, \"sw_webserver_nginx_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_nginx_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-12-05 08:17:52',NULL),(68,86,'IIS','Internet Information Services (IIS, formerly Internet Information Server) is an extensible web server created by Microsoft. IIS supports HTTP, HTTPS, FTP, FTPS, SMTP and NNTP. IIS is not turned on by default when Windows is installed. The IIS Manager is accessed through the Microsoft Management Console or Administrative Tools in the Control Panel. (http://en.wikipedia.org/wiki/Internet_Information_Services)',NULL,'{\"sw_webserver_iis_version\": {\"title\": \"Version\", \"description\": \"The specific version of IIS.\", \"type\": \"string\"}, \"sw_webserver_iis_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_iis_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-12-05 08:17:52',NULL);
/*!40000 ALTER TABLE `metadef_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_properties`
--

DROP TABLE IF EXISTS `metadef_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_properties_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_properties_name` (`name`),
  CONSTRAINT `metadef_properties_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=388 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_properties`
--

LOCK TABLES `metadef_properties` WRITE;
/*!40000 ALTER TABLE `metadef_properties` DISABLE KEYS */;
INSERT INTO `metadef_properties` (`id`, `namespace_id`, `name`, `json_schema`, `created_at`, `updated_at`) VALUES (2,2,'InstructionSet','{\"title\": \"Instruction Set\", \"description\": \"Identifies the instruction set of the processor within a processor architecture.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86:i386\", \"x86:i486\", \"x86:i586\", \"x86:i686\", \"x86:64\", \"IA-64:IA-64\", \"AS/400:TIMI\", \"Power:Power_2.03\", \"Power:Power_2.04\", \"Power:Power_2.05\", \"Power:Power_2.06\", \"S/390:ESA/390\", \"S/390:z/Architecture\", \"S/390:z/Architecture_2\", \"PA-RISC:PA-RISC_1.0\", \"PA-RISC:PA-RISC_2.0\", \"ARM:A32\", \"ARM:A64\", \"MIPS:MIPS_I\", \"MIPS:MIPS_II\", \"MIPS:MIPS_III\", \"MIPS:MIPS_IV\", \"MIPS:MIPS_V\", \"MIPS:MIPS32\", \"MIPS64:MIPS64\", \"Alpha:Alpha\", \"SPARC:SPARC_V7\", \"SPARC:SPARC_V8\", \"SPARC:SPARC_V9\", \"SPARC:SPARC_JPS1\", \"SPARC:UltraSPARC2005\", \"SPARC:UltraSPARC2007\", \"68k:68000\", \"68k:68010\", \"68k:68020\", \"68k:68030\", \"68k:68040\", \"68k:68060\"]}','2025-12-05 08:17:43',NULL),(5,2,'ProcessorArchitecture','{\"title\": \"Processor Architecture\", \"description\": \"Identifies the processor architecture of the processor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"IA-64\", \"AS/400\", \"Power\", \"S/390\", \"PA-RISC\", \"ARM\", \"MIPS\", \"Alpha\", \"SPARC\", \"68k\"]}','2025-12-05 08:17:43',NULL),(8,2,'InstructionSetExtensionName','{\"title\": \"Instruction Set Extension\", \"description\": \"Identifies the instruction set extensions of the processor within a processor architecture.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"x86:3DNow\", \"x86:3DNowExt\", \"x86:ABM\", \"x86:AES\", \"x86:AVX\", \"x86:AVX2\", \"x86:BMI\", \"x86:CX16\", \"x86:F16C\", \"x86:FSGSBASE\", \"x86:LWP\", \"x86:MMX\", \"x86:PCLMUL\", \"x86:RDRND\", \"x86:SSE2\", \"x86:SSE3\", \"x86:SSSE3\", \"x86:SSE4A\", \"x86:SSE41\", \"x86:SSE42\", \"x86:FMA3\", \"x86:FMA4\", \"x86:XOP\", \"x86:TBM\", \"x86:VT-d\", \"x86:VT-x\", \"x86:EPT\", \"x86:SVM\", \"PA-RISC:MAX\", \"PA-RISC:MAX2\", \"ARM:DSP\", \"ARM:Jazelle-DBX\", \"ARM:Thumb\", \"ARM:Thumb-2\", \"ARM:ThumbEE)\", \"ARM:VFP\", \"ARM:NEON\", \"ARM:TrustZone\", \"MIPS:MDMX\", \"MIPS:MIPS-3D\", \"Alpha:BWX\", \"Alpha:FIX\", \"Alpha:CIX\", \"Alpha:MVI\"]}}','2025-12-05 08:17:43',NULL),(11,5,'Address','{\"title\": \"Address\", \"description\": \"The address of the resource.\", \"type\": \"string\"}','2025-12-05 08:17:43',NULL),(14,5,'AddressOnParent','{\"title\": \"Address On Parent\", \"description\": \"Describes the address of this resource in the context of the Parent.\", \"type\": \"string\"}','2025-12-05 08:17:43',NULL),(17,5,'AllocationUnits','{\"title\": \"Allocation Units\", \"description\": \"This property specifies the units of allocation used by the Reservation and Limit properties.\", \"type\": \"string\"}','2025-12-05 08:17:43',NULL),(20,5,'AutomaticAllocation','{\"title\": \"Automatic Allocation\", \"description\": \"This property specifies if the resource will be automatically allocated.\", \"type\": \"boolean\"}','2025-12-05 08:17:43',NULL),(23,5,'AutomaticDeallocation','{\"title\": \"Automatic Deallocation\", \"description\": \"This property specifies if the resource will be automatically de-allocated.\", \"type\": \"boolean\"}','2025-12-05 08:17:43',NULL),(26,5,'ConsumerVisibility','{\"title\": \"Consumer Visibility\", \"description\": \"Describes the consumers visibility to the allocated resource.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Passed-Through\", \"Virtualized\", \"Not represented\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-12-05 08:17:43',NULL),(29,5,'Limit','{\"title\": \"Limit\", \"description\": \"This property specifies the upper bound, or maximum amount of resource that will be granted for this allocation.\", \"type\": \"string\"}','2025-12-05 08:17:43',NULL),(32,5,'MappingBehavior','{\"title\": \"Mapping Behavior\", \"description\": \"Specifies how this resource maps to underlying resources. If the HostResource array contains any entries, this property reflects how the resource maps to those specific resources.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Not Supported\", \"Dedicated\", \"Soft Affinity\", \"Hard Affinity\", \"DMTF Reserved\", \"Vendor Reserved\"]}','2025-12-05 08:17:43',NULL),(35,5,'OtherResourceType','{\"title\": \"Other Resource Type\", \"description\": \"A string that describes the resource type when a well defined value is not available and ResourceType has the value \'Other\'.\", \"type\": \"string\"}','2025-12-05 08:17:43',NULL),(38,5,'Parent','{\"title\": \"Parent\", \"description\": \"The Parent of the resource.\", \"type\": \"string\"}','2025-12-05 08:17:43',NULL),(41,5,'PoolID','{\"title\": \"Pool ID\", \"description\": \"This property specifies which ResourcePool the resource is currently allocated from, or which ResourcePool the resource will be allocated from when the allocation occurs.\", \"type\": \"string\"}','2025-12-05 08:17:43',NULL),(44,5,'Reservation','{\"title\": \"Reservation\", \"description\": \"This property specifies the amount of resource guaranteed to be available for this allocation.\", \"type\": \"string\"}','2025-12-05 08:17:43',NULL),(47,5,'ResourceSubType','{\"title\": \"Resource Sub Type\", \"description\": \"A string describing an implementation specific sub-type for this resource.\", \"type\": \"string\"}','2025-12-05 08:17:43',NULL),(50,5,'ResourceType','{\"title\": \"Resource Type\", \"description\": \"The type of resource this allocation setting represents.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Other\", \"Computer System\", \"Processor\", \"Memory\", \"IDE Controller\", \"Parallel SCSI HBA\", \"FC HBA\", \"iSCSI HBA\", \"IB HCA\", \"Ethernet Adapter\", \"Other Network Adapter\", \"I/O Slot\", \"I/O Device\", \"Floppy Drive\", \"CD Drive\", \"DVD drive\", \"Disk Drive\", \"Tape Drive\", \"Storage Extent\", \"Other storage device\", \"Serial port\", \"Parallel port\", \"USB Controller\", \"Graphics controller\", \"IEEE 1394 Controller\", \"Partitionable Unit\", \"Base Partitionable Unit\", \"Power\", \"Cooling Capacity\", \"Ethernet Switch Port\", \"Logical Disk\", \"Storage Volume\", \"Ethernet Connection\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-12-05 08:17:43',NULL),(53,5,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"This property specifies the quantity of resources presented to the consumer.\", \"type\": \"string\"}','2025-12-05 08:17:43',NULL),(56,5,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-12-05 08:17:43',NULL),(59,5,'Weight','{\"title\": \"Weight\", \"description\": \"This property specifies a relative priority for this allocation in relation to other allocations from the same ResourcePool.\", \"type\": \"string\"}','2025-12-05 08:17:43',NULL),(62,5,'Connection','{\"title\": \"Connection\", \"description\": \"The thing to which this resource is connected.\", \"type\": \"string\"}','2025-12-05 08:17:43',NULL),(65,5,'HostResource','{\"title\": \"Host Resource\", \"description\": \"This property exposes specific assignment of resources.\", \"type\": \"string\"}','2025-12-05 08:17:43',NULL),(68,8,'Access','{\"title\": \"Access\", \"description\": \"Access describes whether the allocated storage extent is 1 (readable), 2 (writeable), or 3 (both).\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Readable\", \"Writeable\", \"Read/Write Supported\", \"DMTF Reserved\"]}','2025-12-05 08:17:43',NULL),(71,8,'HostExtentName','{\"title\": \"Host Extent Name\", \"description\": \"A unique identifier for the host extent.\", \"type\": \"string\"}','2025-12-05 08:17:43',NULL),(74,8,'HostExtentNameFormat','{\"title\": \"Host Extent Name Format\", \"description\": \"The HostExtentNameFormat property identifies the format that is used for the value of the HostExtentName property.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"SNVM\", \"NAA\", \"EUI64\", \"T10VID\", \"OS Device Name\", \"DMTF Reserved\"]}','2025-12-05 08:17:43',NULL),(77,8,'HostExtentNameNamespace','{\"title\": \"Host Extent Name Namespace\", \"description\": \"If the host extent is a SCSI volume, then the preferred source for SCSI volume names is SCSI VPD Page 83 responses.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"VPD83Type3\", \"VPD83Type2\", \"VPD83Type1\", \"VPD80\", \"NodeWWN\", \"SNVM\", \"OS Device Namespace\", \"DMTF Reserved\"]}','2025-12-05 08:17:43',NULL),(80,8,'HostExtentStartingAddress','{\"title\": \"Host Extent Starting Address\", \"description\": \"The HostExtentStartingAddress property identifies the starting address on the host storage extent identified by the value of the HostExtentName property that is used for the allocation of the virtual storage extent.\", \"type\": \"string\"}','2025-12-05 08:17:43',NULL),(83,8,'HostResourceBlockSize','{\"title\": \"Host Resource Block Size\", \"description\": \"Size in bytes of the blocks that are allocated at the host as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-12-05 08:17:43',NULL),(86,8,'Limit','{\"title\": \"Limit\", \"description\": \"The maximum amount of blocks that will be granted for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-12-05 08:17:43',NULL),(89,8,'OtherHostExtentNameFormat','{\"title\": \"Other Host Extent Name Format\", \"description\": \"A string describing the format of the HostExtentName property if the value of the HostExtentNameFormat property is 1 (Other).\", \"type\": \"string\"}','2025-12-05 08:17:43',NULL),(92,8,'OtherHostExtentNameNamespace','{\"title\": \"Other Host Extent Name Namespace\", \"description\": \"A string describing the namespace of the HostExtentName property if the value of the HostExtentNameNamespace matches 1 (Other).\", \"type\": \"string\"}','2025-12-05 08:17:43',NULL),(95,8,'Reservation','{\"title\": \"Reservation\", \"description\": \"The amount of blocks that are guaranteed to be available for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-12-05 08:17:43',NULL),(98,8,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"Number of blocks that are presented to the consumer.\", \"type\": \"string\"}','2025-12-05 08:17:43',NULL),(101,8,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-12-05 08:17:43',NULL),(104,8,'VirtualResourceBlockSize','{\"title\": \"Virtual Resource Block Size\", \"description\": \"Size in bytes of the blocks that are presented to the consumer as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-12-05 08:17:43',NULL),(107,11,'AutomaticRecoveryAction','{\"title\": \"Automatic Recovery Action\", \"description\": \"Action to take for the virtual system when the software executed by the virtual system fails.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart\", \"Revert to snapshot\", \"DMTF Reserved\"]}','2025-12-05 08:17:44',NULL),(110,11,'AutomaticShutdownAction','{\"title\": \"Automatic Shutdown Action\", \"description\": \"Action to take for the virtual system when the host is shut down.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Turn Off\", \"Save state\", \"Shutdown\", \"DMTF Reserved\"]}','2025-12-05 08:17:44',NULL),(113,11,'AutomaticStartupAction','{\"title\": \"Automatic Startup Action\", \"description\": \"Action to take for the virtual system when the host is started.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart if previously active\", \"Always startup\", \"DMTF Reserved\"]}','2025-12-05 08:17:44',NULL),(116,11,'AutomaticStartupActionDelay','{\"title\": \"Automatic Startup Action Delay\", \"description\": \"Delay applicable to startup action.\", \"type\": \"string\"}','2025-12-05 08:17:44',NULL),(119,11,'AutomaticStartupActionSequenceNumber','{\"title\": \"Automatic Startup Action Sequence Number\", \"description\": \"Number indicating the relative sequence of virtual system activation when the host system is started.\", \"type\": \"string\"}','2025-12-05 08:17:44',NULL),(122,11,'ConfigurationDataRoot','{\"title\": \"Configuration Data Root\", \"description\": \"Filepath of a directory where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-12-05 08:17:44',NULL),(125,11,'ConfigurationFile','{\"title\": \"Configuration File\", \"description\": \"Filepath of a file where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-12-05 08:17:44',NULL),(128,11,'ConfigurationID','{\"title\": \"Configuration ID\", \"description\": \"Unique id of the virtual system configuration.\", \"type\": \"string\"}','2025-12-05 08:17:44',NULL),(131,11,'CreationTime','{\"title\": \"Creation Time\", \"description\": \"Time when the virtual system configuration was created.\", \"type\": \"string\"}','2025-12-05 08:17:44',NULL),(134,11,'LogDataRoot','{\"title\": \"Log Data Root\", \"description\": \"Filepath of a directory where log information about the virtual system is stored.\", \"type\": \"string\"}','2025-12-05 08:17:44',NULL),(137,11,'RecoveryFile','{\"title\": \"Recovery File\", \"description\": \"Filepath of a file where recovery relateded information of the virtual system is stored.\", \"type\": \"string\"}','2025-12-05 08:17:44',NULL),(140,11,'SnapshotDataRoot','{\"title\": \"Snapshot Data Root\", \"description\": \"Filepath of a directory where information about virtual system snapshots is stored.\", \"type\": \"string\"}','2025-12-05 08:17:44',NULL),(143,11,'SuspendDataRoot','{\"title\": \"Suspend Data Root\", \"description\": \"Filepath of a directory where suspend related information about the virtual system is stored.\", \"type\": \"string\"}','2025-12-05 08:17:44',NULL),(146,11,'SwapFileDataRoot','{\"title\": \"Swap File Data Root\", \"description\": \"Filepath of a directory where swapfiles of the virtual system are stored.\", \"type\": \"string\"}','2025-12-05 08:17:44',NULL),(149,11,'VirtualSystemIdentifier','{\"title\": \"Virtual System Identifier\", \"description\": \"VirtualSystemIdentifier shall reflect a unique name for the system as it is used within the virtualization platform.\", \"type\": \"string\"}','2025-12-05 08:17:44',NULL),(152,11,'VirtualSystemType','{\"title\": \"Virtual System Type\", \"description\": \"VirtualSystemType shall reflect a particular type of virtual system.\", \"type\": \"string\"}','2025-12-05 08:17:44',NULL),(155,11,'Notes','{\"title\": \"Notes\", \"description\": \"End-user supplied notes that are related to the virtual system.\", \"type\": \"string\"}','2025-12-05 08:17:44',NULL),(158,14,'disk_allocation_ratio','{\"title\": \"Disk Subscription Ratio\", \"description\": \"Allows the host to be under and over subscribed for the amount of disk space requested for an instance. A ratio greater than 1.0 allows for over subscription (hosts may have less usable disk space than requested). A ratio less than 1.0 allows for under subscription.\", \"type\": \"number\", \"readonly\": false}','2025-12-05 08:17:44',NULL),(161,17,'max_io_ops_per_host','{\"title\": \"Maximum IO Operations per Host\", \"description\": \"Prevents hosts in the aggregate that have this many or more instances currently in build, resize, snapshot, migrate, rescue or unshelve to be scheduled for new instances.\", \"type\": \"integer\", \"readonly\": false, \"default\": 8, \"minimum\": 1}','2025-12-05 08:17:44',NULL),(164,20,'max_instances_per_host','{\"title\": \"Max Instances Per Host\", \"description\": \"Maximum number of instances allowed to run on a host in the aggregate.\", \"type\": \"integer\", \"readonly\": false, \"minimum\": 0}','2025-12-05 08:17:44',NULL),(167,23,'cpu_policy','{\"title\": \"CPU Pinning policy\", \"description\": \"Type of CPU pinning policy.\", \"type\": \"string\", \"enum\": [\"shared\", \"dedicated\"]}','2025-12-05 08:17:45',NULL),(170,23,'cpu_thread_policy','{\"title\": \"CPU Thread Pinning Policy.\", \"description\": \"Type of CPU thread pinning policy.\", \"type\": \"string\", \"enum\": [\"isolate\", \"prefer\", \"require\"]}','2025-12-05 08:17:45',NULL),(173,26,'mem_page_size','{\"title\": \"Size of memory page\", \"description\": \"Page size to be used for Guest memory backing. Value can be specified as <number><unit> (i.e.: 2MB, 1GB) or \'any\', \'small\', \'large\'. If this property is set in Image metadata then only \'any\' and \'large\' values are accepted in Flavor metadata by Nova API.\", \"type\": \"string\"}','2025-12-05 08:17:45',NULL),(176,29,'os_shutdown_timeout','{\"title\": \"Shutdown timeout\", \"description\": \"By default, guests will be given 60 seconds to perform a graceful shutdown. After that, the VM is powered off.  This property allows overriding the amount of time (unit: seconds) to allow a guest OS to cleanly shut down before power off. A value of 0 (zero) means the guest will be powered off immediately with no opportunity for guest OS clean-up.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-05 08:17:45',NULL),(179,32,'cpu_info:vendor','{\"title\": \"Vendor\", \"description\": \"Specifies the CPU manufacturer.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Intel\", \"AMD\"]}','2025-12-05 08:17:45',NULL),(182,32,'cpu_info:model','{\"title\": \"Model\", \"description\": \"Specifies the CPU model. Use this property to ensure that your vm runs on a specific cpu model.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Conroe\", \"Core2Duo\", \"Penryn\", \"Nehalem\", \"Westmere\", \"SandyBridge\", \"IvyBridge\", \"Haswell\", \"Broadwell\", \"Delhi\", \"Seoul\", \"Abu Dhabi\", \"Interlagos\", \"Kabini\", \"Valencia\", \"Zurich\", \"Budapest\", \"Barcelona\", \"Suzuka\", \"Shanghai\", \"Istanbul\", \"Lisbon\", \"Magny-Cours\", \"Valencia\", \"Cortex-A57\", \"Cortex-A53\", \"Cortex-A12\", \"Cortex-A17\", \"Cortex-A15\", \"Coretx-A7\", \"X-Gene\"]}','2025-12-05 08:17:45',NULL),(185,32,'cpu_info:arch','{\"title\": \"Architecture\", \"description\": \"Specifies the CPU architecture. Use this property to specify the architecture supported by the hypervisor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"x86_64\", \"i686\", \"ia64\", \"ARMv8-A\", \"ARMv7-A\"]}','2025-12-05 08:17:45',NULL),(188,32,'cpu_info:topology:cores','{\"title\": \"cores\", \"description\": \"Number of cores.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-12-05 08:17:45',NULL),(191,32,'cpu_info:topology:threads','{\"title\": \"threads\", \"description\": \"Number of threads.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-12-05 08:17:45',NULL),(194,32,'cpu_info:topology:sockets','{\"title\": \"sockets\", \"description\": \"Number of sockets.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-12-05 08:17:46',NULL),(197,32,'cpu_info:features','{\"title\": \"Features\", \"description\": \"Specifies CPU flags/features. Using this property you can specify the required set of instructions supported by a vm.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"fpu\", \"vme\", \"de\", \"pse\", \"tsc\", \"msr\", \"pae\", \"mce\", \"cx8\", \"apic\", \"sep\", \"mtrr\", \"pge\", \"mca\", \"cmov\", \"pat\", \"pse36\", \"pn\", \"clflush\", \"dts\", \"acpi\", \"mmx\", \"fxsr\", \"sse\", \"sse2\", \"ss\", \"ht\", \"tm\", \"ia64\", \"pbe\", \"syscall\", \"mp\", \"nx\", \"mmxext\", \"fxsr_opt\", \"pdpe1gb\", \"rdtscp\", \"lm\", \"3dnowext\", \"3dnow\", \"arch_perfmon\", \"pebs\", \"bts\", \"rep_good\", \"nopl\", \"xtopology\", \"tsc_reliable\", \"nonstop_tsc\", \"extd_apicid\", \"amd_dcm\", \"aperfmperf\", \"eagerfpu\", \"nonstop_tsc_s3\", \"pni\", \"pclmulqdq\", \"dtes64\", \"monitor\", \"ds_cpl\", \"vmx\", \"smx\", \"est\", \"tm2\", \"ssse3\", \"cid\", \"fma\", \"cx16\", \"xtpr\", \"pdcm\", \"pcid\", \"dca\", \"sse4_1\", \"sse4_2\", \"x2apic\", \"movbe\", \"popcnt\", \"tsc_deadline_timer\", \"aes\", \"xsave\", \"avx\", \"f16c\", \"rdrand\", \"hypervisor\", \"rng\", \"rng_en\", \"ace\", \"ace_en\", \"ace2\", \"ace2_en\", \"phe\", \"phe_en\", \"pmm\", \"pmm_en\", \"lahf_lm\", \"cmp_legacy\", \"svm\", \"extapic\", \"cr8_legacy\", \"abm\", \"sse4a\", \"misalignsse\", \"3dnowprefetch\", \"osvw\", \"ibs\", \"xop\", \"skinit\", \"wdt\", \"lwp\", \"fma4\", \"tce\", \"nodeid_msr\", \"tbm\", \"topoext\", \"perfctr_core\", \"perfctr_nb\", \"bpext\", \"perfctr_l2\", \"mwaitx\", \"ida\", \"arat\", \"cpb\", \"epb\", \"pln\", \"pts\", \"dtherm\", \"hw_pstate\", \"proc_feedback\", \"hwp\", \"hwp_notify\", \"hwp_act_window\", \"hwp_epp\", \"hwp_pkg_req\", \"intel_pt\", \"tpr_shadow\", \"vnmi\", \"flexpriority\", \"ept\", \"vpid\", \"npt\", \"lbrv\", \"svm_lock\", \"nrip_save\", \"tsc_scale\", \"vmcb_clean\", \"flushbyasid\", \"decodeassists\", \"pausefilter\", \"pfthreshold\", \"vmmcall\", \"fsgsbase\", \"tsc_adjust\", \"bmi1\", \"hle\", \"avx2\", \"smep\", \"bmi2\", \"erms\", \"invpcid\", \"rtm\", \"cqm\", \"mpx\", \"avx512f\", \"rdseed\", \"adx\", \"smap\", \"pcommit\", \"clflushopt\", \"clwb\", \"avx512pf\", \"avx512er\", \"avx512cd\", \"sha_ni\", \"xsaveopt\", \"xsavec\", \"xgetbv1\", \"xsaves\", \"cqm_llc\", \"cqm_occup_llc\", \"clzero\"]}}','2025-12-05 08:17:46',NULL),(200,35,'hypervisor_type','{\"title\": \"Hypervisor Type\", \"description\": \"Hypervisor type required by the image. Used with the ImagePropertiesFilter. \\n\\n Baremetal - physical provisioning. hyperv - Microsoft\\u00ae hyperv. KVM - Kernel-based Virtual Machine. LXC - Linux Containers (through libvirt). powervm - IBM\\u00ae PowerVM\\u00ae. QEMU - Quick EMUlator. UML - User Mode Linux. vmware - VMware\\u00ae vsphere. VZ - Virtuozzo OS Containers and Virtual Machines (through libvirt). For more information, see: https://docs.openstack.org/nova/latest/admin/configuration/hypervisors.html\", \"type\": \"string\", \"enum\": [\"baremetal\", \"hyperv\", \"kvm\", \"lxc\", \"powervm\", \"qemu\", \"uml\", \"vmware\", \"vz\", \"xen\"]}','2025-12-05 08:17:46',NULL),(203,35,'vm_mode','{\"title\": \"VM Mode\", \"description\": \"The virtual machine mode. This represents the host/guest ABI (application binary interface) used for the virtual machine. Used with the ImagePropertiesFilter. \\n\\n hvm \\u2014 Fully virtualized - This is the virtual machine mode (vm_mode) used by QEMU and KVM. \\n\\n xen - Xen 3.0 paravirtualized. \\n\\n uml \\u2014 User Mode Linux paravirtualized. \\n\\n exe \\u2014 Executables in containers. This is the mode used by LXC.\", \"type\": \"string\", \"enum\": [\"hvm\", \"xen\", \"uml\", \"exe\"]}','2025-12-05 08:17:46',NULL),(206,38,'img_config_drive','{\"title\": \"Config Drive\", \"description\": \"This property specifies whether or not Nova should use a config drive when booting the image. Mandatory means that Nova will always use a config drive when booting the image. OpenStack can be configured to write metadata to a special configuration drive that will be attached to the instance when it boots. The instance can retrieve any information from the config drive. One use case for the config drive is to pass network configuration information to the instance. See also: http://docs.openstack.org/user-guide/cli_config_drive.html\", \"type\": \"string\", \"enum\": [\"optional\", \"mandatory\"]}','2025-12-05 08:17:46',NULL),(209,38,'os_require_quiesce','{\"title\": \"Require Quiescent File system\", \"description\": \"This property specifies whether or not the filesystem must be quiesced during snapshot processing. For volume backed and image backed snapshots, yes means that snapshotting is aborted when quiescing fails, whereas, no means quiescing will be skipped and snapshot processing will continue after the quiesce failure.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-12-05 08:17:46',NULL),(212,41,'hw_cdrom_bus','{\"title\": \"CD-ROM Bus\", \"description\": \"Specifies the type of disk controller to attach CD-ROM devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-12-05 08:17:46',NULL),(215,41,'hw_disk_bus','{\"title\": \"Disk Bus\", \"description\": \"Specifies the type of disk controller to attach disk devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-12-05 08:17:46',NULL),(218,41,'hw_firmware_type','{\"title\": \"Firmware Type\", \"description\": \"Specifies whether the image should be booted with a legacy BIOS or with UEFI.\", \"type\": \"string\", \"enum\": [\"bios\", \"uefi\"]}','2025-12-05 08:17:46',NULL),(221,41,'hw_rng_model','{\"title\": \"Random Number Generator Device\", \"description\": \"Adds a random-number generator device to the image\'s instances. The cloud administrator can enable and control device behavior by configuring the instance\'s flavor. By default: The generator device is disabled. /dev/random is used as the default entropy source. To specify a physical HW RNG device, use the following option in the nova.conf file: rng_dev_path=/dev/hwrng\", \"type\": \"string\", \"default\": \"virtio\"}','2025-12-05 08:17:46',NULL),(224,41,'hw_machine_type','{\"title\": \"Machine Type\", \"description\": \"Enables booting an ARM system using the specified machine type. By default, if an ARM image is used and its type is not specified, Compute uses vexpress-a15 (for ARMv7) or virt (for AArch64) machine types. Valid types can be viewed by using the virsh capabilities command (machine types are displayed in the machine tag).\", \"type\": \"string\"}','2025-12-05 08:17:46',NULL),(227,41,'hw_scsi_model','{\"title\": \"SCSI Model\", \"description\": \"Enables the use of VirtIO SCSI (virtio-scsi) to provide block device access for compute instances; by default, instances use VirtIO Block (virtio-blk). VirtIO SCSI is a para-virtualized SCSI controller device that provides improved scalability and performance, and supports advanced SCSI hardware.\", \"type\": \"string\", \"default\": \"virtio-scsi\"}','2025-12-05 08:17:46',NULL),(230,41,'hw_video_model','{\"title\": \"Video Model\", \"description\": \"The graphic device model presented to the guest. hw_video_model=none disables the graphics device in the guest and should generally be used when using gpu passthrough.\", \"type\": \"string\", \"enum\": [\"vga\", \"cirrus\", \"vmvga\", \"xen\", \"qxl\", \"virtio\", \"gop\", \"none\"]}','2025-12-05 08:17:46',NULL),(233,41,'hw_video_ram','{\"title\": \"Max Video Ram\", \"description\": \"Maximum RAM (unit: MB) for the video image. Used only if a hw_video:ram_max_mb value has been set in the flavor\'s extra_specs and that value is higher than the value set in hw_video_ram.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-05 08:17:47',NULL),(236,41,'os_command_line','{\"title\": \"Kernel Command Line\", \"description\": \"The kernel command line to be used by the libvirt driver, instead of the default. For linux containers (LXC), the value is used as arguments for initialization. This key is valid only for Amazon kernel, ramdisk, or machine images (aki, ari, or ami).\", \"type\": \"string\"}','2025-12-05 08:17:47',NULL),(239,41,'os_type','{\"title\": \"OS Type\", \"description\": \"The operating system installed on the image. The libvirt driver contains logic that takes different actions depending on the value of the os_type parameter of the image. For example, for os_type=windows images, it creates a FAT32-based swap partition instead of a Linux swap partition, and it limits the injected host name to less than 16 characters.\", \"type\": \"string\", \"enum\": [\"linux\", \"windows\"]}','2025-12-05 08:17:47',NULL),(242,41,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor configuration. libvirt driver options: KVM and QEMU: e1000, ne2k_pci, pcnet, rtl8139, spapr-vlan, and virtio. Xen: e1000, netfront, ne2k_pci, pcnet, and rtl8139.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"ne2k_pci\", \"netfront\", \"pcnet\", \"rtl8139\", \"spapr-vlan\", \"virtio\"]}','2025-12-05 08:17:47',NULL),(245,41,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-05 08:17:47',NULL),(248,41,'hw_pmu','{\"title\": \"Virtual Performance Monitoring Unit\", \"description\": \"Controls emulation of a vPMU in the guest. To reduce latency in realtime workloads disable the vPMU by setting hw_pmu=false\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-05 08:17:47',NULL),(251,41,'hw_qemu_guest_agent','{\"title\": \"QEMU Guest Agent\", \"description\": \"This is a background process which helps management applications execute guest OS level commands. For example, freezing and thawing filesystems, entering suspend. However, guest agent (GA) is not bullet proof, and hostile guest OS can send spurious replies.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-12-05 08:17:47',NULL),(254,41,'hw_pointer_model','{\"title\": \"Pointer Model\", \"description\": \"Input devices allow interaction with a graphical framebuffer. For example to provide a graphic tablet for absolute cursor movement. Currently only supported by the KVM/QEMU hypervisor configuration and VNC or SPICE consoles must be enabled.\", \"type\": \"string\", \"enum\": [\"usbtablet\"]}','2025-12-05 08:17:47',NULL),(257,41,'img_hide_hypervisor_id','{\"title\": \"Hide hypervisor id\", \"description\": \"Enables hiding the host hypervisor signature in the guest OS.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-12-05 08:17:47',NULL),(260,44,'serial_port_count','{\"title\": \"Serial Port Count\", \"description\": \"Specifies the count of serial ports that should be provided. If hw:serial_port_count is not set in the flavor\'s extra_specs, then any count is permitted. If hw:serial_port_count is set, then this provides the default serial port count. It is permitted to override the default serial port count, but only with a lower value.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-05 08:17:47',NULL),(263,44,'boot_menu','{\"title\": \"Boot Menu\", \"description\": \"If true, enables the BIOS bootmenu. In cases where both the image metadata and Extra Spec are set, the Extra Spec setting is used. This allows for flexibility in setting/overriding the default behavior as needed.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-05 08:17:47',NULL),(266,44,'mem_encryption','{\"title\": \"Hardware Memory Encryption\", \"description\": \"Enables encryption of guest memory at the hardware level, if there are compute hosts available which support this. See https://docs.openstack.org/nova/latest/admin/configuration/hypervisor-kvm.html#amd-sev-secure-encrypted-virtualization for details.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-05 08:17:47',NULL),(269,50,'hw_rng:allowed','{\"title\": \"Random Number Generator Allowed\", \"description\": \"\", \"type\": \"boolean\"}','2025-12-05 08:17:48',NULL),(272,50,'hw_rng:rate_bytes','{\"title\": \"Random number generator limits.\", \"description\": \"Allowed amount of bytes that the guest can read from the host\'s entropy per period.\", \"type\": \"integer\"}','2025-12-05 08:17:48',NULL),(275,50,'hw_rng:rate_period','{\"title\": \"Random number generator read period.\", \"description\": \"Duration of the read period in milliseconds.\", \"type\": \"integer\"}','2025-12-05 08:17:48',NULL),(278,53,'cpu_sockets','{\"title\": \"vCPU Sockets\", \"description\": \"Preferred number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-12-05 08:17:48',NULL),(281,53,'cpu_cores','{\"title\": \"vCPU Cores\", \"description\": \"Preferred number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-12-05 08:17:48',NULL),(284,53,'cpu_threads','{\"title\": \" vCPU Threads\", \"description\": \"Preferred number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-12-05 08:17:48',NULL),(287,53,'cpu_max_sockets','{\"title\": \"Max vCPU Sockets\", \"description\": \"Maximum number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-12-05 08:17:48',NULL),(290,53,'cpu_max_cores','{\"title\": \"Max vCPU Cores\", \"description\": \"Maximum number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-12-05 08:17:48',NULL),(293,53,'cpu_max_threads','{\"title\": \"Max vCPU Threads\", \"description\": \"Maximum number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-12-05 08:17:48',NULL),(296,56,'vmware:hw_version','{\"title\": \"VMware Hardware Version\", \"description\": \"Specifies the hardware version VMware uses to create images. If the hardware version needs to be compatible with a cluster version, for backward compatibility or other circumstances, the vmware:hw_version key specifies a virtual machine hardware version. In the event that a cluster has mixed host version types, the key will enable the vCenter to place the cluster on the correct host.\", \"type\": \"string\", \"enum\": [\"vmx-13\", \"vmx-11\", \"vmx-10\", \"vmx-09\", \"vmx-08\", \"vmx-07\", \"vmx-04\", \"vmx-03\"]}','2025-12-05 08:17:48',NULL),(299,56,'vmware:storage_policy','{\"title\": \"VMware Storage Policy\", \"description\": \"Specifies the storage policy to be applied for newly created instance. If not provided, the default storage policy specified in config file will be used. If Storage Policy Based Management (SPBM) is not enabled in config file, this value won\'t be used.\", \"type\": \"string\"}','2025-12-05 08:17:48',NULL),(302,59,'quota:cpu_limit','{\"title\": \"Quota: CPU Limit\", \"description\": \"Specifies the upper limit for CPU allocation in MHz. This parameter ensures that a machine never uses more than the defined amount of CPU time. It can be used to enforce a limit on the machine\'s CPU performance. The value should be a numerical value in MHz. If zero is supplied then the cpu_limit is unlimited.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-05 08:17:48',NULL),(305,59,'quota:cpu_reservation','{\"title\": \"Quota: CPU Reservation Limit\", \"description\": \"Specifies the guaranteed minimum CPU reservation in MHz. This means that if needed, the machine will definitely get allocated the reserved amount of CPU cycles. The value should be a numerical value in MHz.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-05 08:17:48',NULL),(308,62,'img_linked_clone','{\"title\": \"Linked Clone\", \"description\": \"By default, the VMware compute driver creates linked clones when possible (though this can be turned off by the operator). You can use this image property on a per-image basis to control whether virtual machines booted from the image are treated as full clones (value: false) or linked clones (value: true). Please refer to VMware documentation for information about full vs. linked clones.\", \"type\": \"boolean\"}','2025-12-05 08:17:48',NULL),(311,62,'vmware_adaptertype','{\"title\": \"Disk Adapter Type\", \"description\": \"The virtual SCSI or IDE controller used by the hypervisor.\", \"type\": \"string\", \"enum\": [\"lsiLogic\", \"lsiLogicsas\", \"paraVirtual\", \"busLogic\", \"ide\"], \"default\": \"lsiLogic\"}','2025-12-05 08:17:48',NULL),(314,62,'vmware_disktype','{\"title\": \"Disk Provisioning Type\", \"description\": \"When performing operations such as creating a virtual disk, cloning, or migrating, the disk provisioning type may be specified. Please refer to VMware documentation for more.\", \"type\": \"string\", \"enum\": [\"streamOptimized\", \"sparse\", \"preallocated\"], \"default\": \"preallocated\"}','2025-12-05 08:17:49',NULL),(317,62,'vmware_ostype','{\"title\": \"OS Type\", \"description\": \"A VMware GuestID which describes the operating system installed in the image. This value is passed to the hypervisor when creating a virtual machine. If not specified, the key defaults to otherGuest. See thinkvirt.com.\", \"type\": \"string\", \"enum\": [\"asianux3_64Guest\", \"asianux3Guest\", \"asianux4_64Guest\", \"asianux4Guest\", \"asianux5_64Guest\", \"asianux7_64Guest\", \"centos64Guest\", \"centosGuest\", \"centos6Guest\", \"centos6_64Guest\", \"centos7_64Guest\", \"coreos64Guest\", \"darwin10_64Guest\", \"darwin10Guest\", \"darwin11_64Guest\", \"darwin11Guest\", \"darwin12_64Guest\", \"darwin13_64Guest\", \"darwin14_64Guest\", \"darwin15_64Guest\", \"darwin16_64Guest\", \"darwin64Guest\", \"darwinGuest\", \"debian4_64Guest\", \"debian4Guest\", \"debian5_64Guest\", \"debian5Guest\", \"debian6_64Guest\", \"debian6Guest\", \"debian7_64Guest\", \"debian7Guest\", \"debian8_64Guest\", \"debian8Guest\", \"debian9_64Guest\", \"debian9Guest\", \"debian10_64Guest\", \"debian10Guest\", \"dosGuest\", \"eComStation2Guest\", \"eComStationGuest\", \"fedora64Guest\", \"fedoraGuest\", \"freebsd64Guest\", \"freebsdGuest\", \"genericLinuxGuest\", \"mandrakeGuest\", \"mandriva64Guest\", \"mandrivaGuest\", \"netware4Guest\", \"netware5Guest\", \"netware6Guest\", \"nld9Guest\", \"oesGuest\", \"openServer5Guest\", \"openServer6Guest\", \"opensuse64Guest\", \"opensuseGuest\", \"oracleLinux64Guest\", \"oracleLinuxGuest\", \"oracleLinux6Guest\", \"oracleLinux6_64Guest\", \"oracleLinux7_64Guest\", \"os2Guest\", \"other24xLinux64Guest\", \"other24xLinuxGuest\", \"other26xLinux64Guest\", \"other26xLinuxGuest\", \"other3xLinux64Guest\", \"other3xLinuxGuest\", \"otherGuest\", \"otherGuest64\", \"otherLinux64Guest\", \"otherLinuxGuest\", \"redhatGuest\", \"rhel2Guest\", \"rhel3_64Guest\", \"rhel3Guest\", \"rhel4_64Guest\", \"rhel4Guest\", \"rhel5_64Guest\", \"rhel5Guest\", \"rhel6_64Guest\", \"rhel6Guest\", \"rhel7_64Guest\", \"rhel7Guest\", \"sjdsGuest\", \"sles10_64Guest\", \"sles10Guest\", \"sles11_64Guest\", \"sles11Guest\", \"sles12_64Guest\", \"sles12Guest\", \"sles64Guest\", \"slesGuest\", \"solaris10_64Guest\", \"solaris10Guest\", \"solaris11_64Guest\", \"solaris6Guest\", \"solaris7Guest\", \"solaris8Guest\", \"solaris9Guest\", \"turboLinux64Guest\", \"turboLinuxGuest\", \"ubuntu64Guest\", \"ubuntuGuest\", \"unixWare7Guest\", \"vmkernel5Guest\", \"vmkernel6Guest\", \"vmkernel65Guest\", \"vmkernelGuest\", \"vmwarePhoton64Guest\", \"win2000AdvServGuest\", \"win2000ProGuest\", \"win2000ServGuest\", \"win31Guest\", \"win95Guest\", \"win98Guest\", \"windows7_64Guest\", \"windows7Guest\", \"windows7Server64Guest\", \"windows8_64Guest\", \"windows8Guest\", \"windows8Server64Guest\", \"windows9_64Guest\", \"windows9Guest\", \"windows9Server64Guest\", \"windowsHyperVGuest\", \"winLonghorn64Guest\", \"winLonghornGuest\", \"winMeGuest\", \"winNetBusinessGuest\", \"winNetDatacenter64Guest\", \"winNetDatacenterGuest\", \"winNetEnterprise64Guest\", \"winNetEnterpriseGuest\", \"winNetStandard64Guest\", \"winNetStandardGuest\", \"winNetWebGuest\", \"winNTGuest\", \"winVista64Guest\", \"winVistaGuest\", \"winXPHomeGuest\", \"winXPPro64Guest\", \"winXPProGuest\"], \"default\": \"otherGuest\"}','2025-12-05 08:17:49',NULL),(320,62,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor. VMware driver supported options: e1000, e1000e, VirtualE1000, VirtualE1000e, VirtualPCNet32, VirtualSriovEthernetCard, and VirtualVmxnet.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"VirtualE1000\", \"VirtualE1000e\", \"VirtualPCNet32\", \"VirtualSriovEthernetCard\", \"VirtualVmxnet\", \"VirtualVmxnet3\"], \"default\": \"e1000\"}','2025-12-05 08:17:49',NULL),(323,62,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-05 08:17:49',NULL),(326,65,'watchdog_action','{\"title\": \"Watchdog Action\", \"description\": \"For the libvirt driver, you can enable and set the behavior of a virtual hardware watchdog device for each flavor. Watchdog devices keep an eye on the guest server, and carry out the configured action, if the server hangs. The watchdog uses the i6300esb device (emulating a PCI Intel 6300ESB). If hw_watchdog_action is not specified, the watchdog is disabled. Watchdog behavior set using a specific image\'s properties will override behavior set using flavors.\", \"type\": \"string\", \"enum\": [\"disabled\", \"reset\", \"poweroff\", \"pause\", \"none\"]}','2025-12-05 08:17:49',NULL),(329,68,'auto_disk_config','{\"title\": \"Disk Adapter Type\", \"description\": \"If true, the root partition on the disk is automatically resized before the instance boots. This value is only taken into account by the Compute service when using a Xen-based hypervisor with the XenAPI driver. The Compute service will only attempt to resize if there is a single partition on the image, and only if the partition is in ext3 or ext4 format.\", \"type\": \"boolean\"}','2025-12-05 08:17:49',NULL),(332,71,'kernel_id','{\"title\": \"Kernel ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the kernel when booting an AMI-style image.\"}','2025-12-05 08:17:49',NULL),(335,71,'ramdisk_id','{\"title\": \"Ramdisk ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the ramdisk when booting an AMI-style image.\"}','2025-12-05 08:17:49',NULL),(338,71,'instance_uuid','{\"title\": \"Instance ID\", \"type\": \"string\", \"description\": \"Metadata which can be used to record which instance this image is associated with. (Informational only, does not create an instance snapshot.)\"}','2025-12-05 08:17:49',NULL),(341,71,'architecture','{\"title\": \"CPU Architecture\", \"description\": \"The CPU architecture that must be supported by the hypervisor. For example, x86_64, arm, or ppc64. Run uname -m to get the architecture of a machine. We strongly recommend using the architecture data vocabulary defined by the libosinfo project for this purpose.\", \"type\": \"string\"}','2025-12-05 08:17:49',NULL),(344,71,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-12-05 08:17:49',NULL),(347,71,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-12-05 08:17:49',NULL),(350,71,'description','{\"title\": \"Image description\", \"description\": \"A human-readable string describing this image.\", \"type\": \"string\"}','2025-12-05 08:17:49',NULL),(353,71,'cinder_encryption_key_id','{\"title\": \"Cinder Encryption Key ID\", \"description\": \"Identifier in the OpenStack Key Management Service for the encryption key for the Block Storage Service to use when mounting a volume created from this image\", \"type\": \"string\"}','2025-12-05 08:17:49',NULL),(356,71,'cinder_encryption_key_deletion_policy','{\"title\": \"Cinder Encryption Key Deletion Policy\", \"description\": \"States the condition under which the Image Service will delete the object associated with the \'cinder_encryption_key_id\' image property.  If this property is missing, the Image Service will take no action\", \"type\": \"string\", \"enum\": [\"on_image_deletion\", \"do_not_delete\"]}','2025-12-05 08:17:49',NULL),(359,74,'img_signature','{\"title\": \"Image Signature\", \"description\": \"The signature of the image data encoded in base64 format.\", \"type\": \"string\"}','2025-12-05 08:17:50',NULL),(362,74,'img_signature_certificate_uuid','{\"title\": \"Image Signature Certificate UUID\", \"description\": \"The UUID used to retrieve the certificate from the key manager.\", \"type\": \"string\"}','2025-12-05 08:17:50',NULL),(365,74,'img_signature_hash_method','{\"title\": \"Image Signature Hash Method\", \"description\": \"The hash method used in creating the signature.\", \"type\": \"string\", \"enum\": [\"SHA-224\", \"SHA-256\", \"SHA-384\", \"SHA-512\"]}','2025-12-05 08:17:50',NULL),(368,74,'img_signature_key_type','{\"title\": \"Image Signature Key Type\", \"description\": \"The key type used in creating the signature.\", \"type\": \"string\", \"enum\": [\"RSA-PSS\", \"DSA\", \"ECC_SECT571K1\", \"ECC_SECT409K1\", \"ECC_SECT571R1\", \"ECC_SECT409R1\", \"ECC_SECP521R1\", \"ECC_SECP384R1\"]}','2025-12-05 08:17:50',NULL),(371,77,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-12-05 08:17:50',NULL),(374,77,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-12-05 08:17:50',NULL),(377,77,'os_admin_user','{\"title\": \"OS Admin User\", \"description\": \"The name of the user with admin privileges.\", \"type\": \"string\"}','2025-12-05 08:17:50',NULL),(380,89,'img_volume_type','{\"title\": \"Image Volume Type\", \"description\": \"Specifies the volume type that should be applied during new volume creation with a image. This value is passed to Cinder when creating a new volume. Priority of volume type related parameters are 1.volume_type(via API or CLI), 2.cinder_img_volume_type, 3.default_volume_type(via cinder.conf). If not specified, volume_type or default_volume_type will be referred based on their priority.\", \"type\": \"string\"}','2025-12-05 08:17:52',NULL),(383,92,'cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"Type of CPU Mode.\", \"type\": \"string\", \"enum\": [\"none\", \"host-model\", \"host-passthrough\", \"custom\"]}','2025-12-05 08:55:18',NULL),(384,93,'tpm_model','{\"title\": \"TPM model\", \"description\": \"TPM model to use. Option CRB is only valid for TPM version 2.0. Defaults to TIS.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"TIS\", \"CRB\"], \"default\": \"TIS\"}','2025-12-05 08:55:18',NULL),(385,94,'COMPUTE_SECURITY_TPM_1_2','{\"title\": \"Virtual TPM Version 1.2 Support\", \"description\": \"Enables virtual TPM version 1.2.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-12-05 08:55:18',NULL),(386,94,'COMPUTE_SECURITY_TPM_2_0','{\"title\": \"Virtual TPM Version 2.0 Support\", \"description\": \"Enables virtual TPM version 2.0.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-12-05 08:55:18',NULL);
/*!40000 ALTER TABLE `metadef_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_resource_types`
--

DROP TABLE IF EXISTS `metadef_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_resource_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `protected` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_resource_types_name` (`name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_resource_types`
--

LOCK TABLES `metadef_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_resource_types` (`id`, `name`, `protected`, `created_at`, `updated_at`) VALUES (2,'OS::Cinder::Volume',1,'2025-12-05 08:17:42',NULL),(5,'OS::Glance::Image',1,'2025-12-05 08:17:42',NULL),(8,'OS::Nova::Aggregate',1,'2025-12-05 08:17:42',NULL),(11,'OS::Nova::Flavor',1,'2025-12-05 08:17:42',NULL),(14,'OS::Nova::Server',1,'2025-12-05 08:17:42',NULL),(17,'OS::Trove::Instance',1,'2025-12-05 08:17:50',NULL);
/*!40000 ALTER TABLE `metadef_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_tags`
--

DROP TABLE IF EXISTS `metadef_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_tags_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_tags_name` (`name`),
  CONSTRAINT `metadef_tags_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_tags`
--

LOCK TABLES `metadef_tags` WRITE;
/*!40000 ALTER TABLE `metadef_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadef_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrate_version`
--

DROP TABLE IF EXISTS `migrate_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrate_version` (
  `repository_id` varchar(250) NOT NULL,
  `repository_path` text DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`repository_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrate_version`
--

LOCK TABLES `migrate_version` WRITE;
/*!40000 ALTER TABLE `migrate_version` DISABLE KEYS */;
INSERT INTO `migrate_version` (`repository_id`, `repository_path`, `version`) VALUES ('Glance Migrations','/usr/lib/python3.9/site-packages/glance/db/sqlalchemy/migrate_repo',0);
/*!40000 ALTER TABLE `migrate_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_info`
--

DROP TABLE IF EXISTS `task_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_info` (
  `task_id` varchar(36) NOT NULL,
  `input` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  CONSTRAINT `task_info_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_info`
--

LOCK TABLES `task_info` WRITE;
/*!40000 ALTER TABLE `task_info` DISABLE KEYS */;
INSERT INTO `task_info` (`task_id`, `input`, `result`, `message`) VALUES ('4568f176-4bbb-42b9-b15b-6be587f3359d','{\"image_id\": \"b8475579-bb4f-4b05-9b6b-0240c593dbb7\", \"import_req\": {\"method\": {\"name\": \"web-download\", \"uri\": \"http://does-not.exist/no/possible/way\"}, \"stores\": [\"default_backend\"]}, \"backend\": [\"default_backend\"]}',NULL,'Task failed due to Internal Error'),('df3b6d9d-0b89-4142-8937-09260bfd5028','{\"image_properties\": {\"container_format\": \"bare\", \"disk_format\": \"qcow2\", \"visibility\": \"public\", \"name\": \"tempest-task_image-2049570070\"}, \"import_from_format\": \"qcow2\", \"import_from\": \"http://tempest-dummy-img-file-447028352.qcow2\"}',NULL,'Task failed due to Internal Error'),('ea2f00f2-1868-4cef-8354-406c6438ba2a','{\"image_id\": \"8dfe98b2-e445-4709-97df-ec9c7bfae719\", \"import_req\": {\"method\": {\"name\": \"glance-direct\"}, \"all_stores\": true}, \"backend\": [\"default_backend\"]}','{\"image_id\": \"8dfe98b2-e445-4709-97df-ec9c7bfae719\"}','Copied 0 MiB'),('f3a556ea-b533-44c8-bd8d-61503eab78f3','{\"image_id\": \"edd71fb4-5152-41d2-b83c-91ae600e1685\", \"import_req\": {\"method\": {\"name\": \"web-download\", \"uri\": \"https://download.cirros-cloud.net/0.6.2/cirros-0.6.2-x86_64-disk.img\"}, \"all_stores\": true}, \"backend\": [\"default_backend\"]}','{\"image_id\": \"edd71fb4-5152-41d2-b83c-91ae600e1685\"}','Copied 112 MiB');
/*!40000 ALTER TABLE `task_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` varchar(36) NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `image_id` varchar(36) DEFAULT NULL,
  `request_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_tasks_deleted` (`deleted`),
  KEY `ix_tasks_owner` (`owner`),
  KEY `ix_tasks_status` (`status`),
  KEY `ix_tasks_type` (`type`),
  KEY `ix_tasks_updated_at` (`updated_at`),
  KEY `ix_tasks_image_id` (`image_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
INSERT INTO `tasks` (`id`, `type`, `status`, `owner`, `expires_at`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `image_id`, `request_id`, `user_id`) VALUES ('4568f176-4bbb-42b9-b15b-6be587f3359d','api_image_import','failure','7b26144fb495438c9666bbff7479f0c0','2025-12-07 10:08:01','2025-12-05 10:08:00','2025-12-05 10:08:01',NULL,0,'b8475579-bb4f-4b05-9b6b-0240c593dbb7','req-6c9e7f92-e6dd-4c7e-b450-33298fbcd741','73543ea6fe184a8ea8395ddd0c46da63'),('df3b6d9d-0b89-4142-8937-09260bfd5028','import','failure','d244e8d01e53413a9bb1e968b77f3506','2025-12-07 10:05:58','2025-12-05 10:05:58','2025-12-05 10:05:58',NULL,0,NULL,'req-72009d14-fece-4838-a485-feabd5fb8a19','e1db1dfe7f944849b497c261491855d1'),('ea2f00f2-1868-4cef-8354-406c6438ba2a','api_image_import','success','b8acd29b55e34e8ea4c7e1f26e3cb6da','2025-12-07 10:06:19','2025-12-05 10:06:15','2025-12-05 10:06:19',NULL,0,'8dfe98b2-e445-4709-97df-ec9c7bfae719','req-01769f78-e343-434c-bedf-bca91e6c25b3','335cd8deb01a4308a051ee65d987d7d5'),('f3a556ea-b533-44c8-bd8d-61503eab78f3','api_image_import','success','b8acd29b55e34e8ea4c7e1f26e3cb6da','2025-12-07 10:06:27','2025-12-05 10:06:20','2025-12-05 10:06:27',NULL,0,'edd71fb4-5152-41d2-b83c-91ae600e1685','req-a2ce6e28-da5f-464e-a674-7140792421f7','335cd8deb01a4308a051ee65d987d7d5');
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `heat`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `heat` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `heat`;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `resource_action` varchar(255) DEFAULT NULL,
  `resource_status` varchar(255) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `physical_resource_id` varchar(255) DEFAULT NULL,
  `resource_status_reason` varchar(255) DEFAULT NULL,
  `resource_type` varchar(255) DEFAULT NULL,
  `resource_properties` blob DEFAULT NULL,
  `rsrc_prop_data_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `stack_id` (`stack_id`),
  KEY `ev_rsrc_prop_data_ref` (`rsrc_prop_data_id`),
  CONSTRAINT `ev_rsrc_prop_data_ref` FOREIGN KEY (`rsrc_prop_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `event_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `event`
--

LOCK TABLES `event` WRITE;
/*!40000 ALTER TABLE `event` DISABLE KEYS */;
/*!40000 ALTER TABLE `event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrate_version`
--

DROP TABLE IF EXISTS `migrate_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrate_version` (
  `repository_id` varchar(250) NOT NULL,
  `repository_path` text DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`repository_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrate_version`
--

LOCK TABLES `migrate_version` WRITE;
/*!40000 ALTER TABLE `migrate_version` DISABLE KEYS */;
INSERT INTO `migrate_version` (`repository_id`, `repository_path`, `version`) VALUES ('heat','/usr/lib/python3.9/site-packages/heat/db/sqlalchemy/migrate_repo',86);
/*!40000 ALTER TABLE `migrate_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raw_template`
--

DROP TABLE IF EXISTS `raw_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `raw_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `template` longtext DEFAULT NULL,
  `files` longtext DEFAULT NULL,
  `environment` longtext DEFAULT NULL,
  `files_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `raw_tmpl_files_fkey_ref` (`files_id`),
  CONSTRAINT `raw_tmpl_files_fkey_ref` FOREIGN KEY (`files_id`) REFERENCES `raw_template_files` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raw_template`
--

LOCK TABLES `raw_template` WRITE;
/*!40000 ALTER TABLE `raw_template` DISABLE KEYS */;
/*!40000 ALTER TABLE `raw_template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raw_template_files`
--

DROP TABLE IF EXISTS `raw_template_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `raw_template_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `files` longtext DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raw_template_files`
--

LOCK TABLES `raw_template_files` WRITE;
/*!40000 ALTER TABLE `raw_template_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `raw_template_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource`
--

DROP TABLE IF EXISTS `resource`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) DEFAULT NULL,
  `nova_instance` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  `rsrc_metadata` longtext DEFAULT NULL,
  `properties_data` longtext DEFAULT NULL,
  `engine_id` varchar(36) DEFAULT NULL,
  `atomic_key` int(11) DEFAULT NULL,
  `needed_by` longtext DEFAULT NULL,
  `requires` longtext DEFAULT NULL,
  `replaces` int(11) DEFAULT NULL,
  `replaced_by` int(11) DEFAULT NULL,
  `current_template_id` int(11) DEFAULT NULL,
  `properties_data_encrypted` tinyint(1) DEFAULT NULL,
  `root_stack_id` varchar(36) DEFAULT NULL,
  `rsrc_prop_data_id` int(11) DEFAULT NULL,
  `attr_data_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `stack_id` (`stack_id`),
  KEY `current_template_id` (`current_template_id`),
  KEY `ix_resource_root_stack_id` (`root_stack_id`),
  KEY `rsrc_rsrc_prop_data_ref` (`rsrc_prop_data_id`),
  KEY `rsrc_attr_data_ref` (`attr_data_id`),
  CONSTRAINT `resource_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`),
  CONSTRAINT `resource_ibfk_2` FOREIGN KEY (`current_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `rsrc_attr_data_ref` FOREIGN KEY (`attr_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `rsrc_rsrc_prop_data_ref` FOREIGN KEY (`rsrc_prop_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`properties_data_encrypted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource`
--

LOCK TABLES `resource` WRITE;
/*!40000 ALTER TABLE `resource` DISABLE KEYS */;
/*!40000 ALTER TABLE `resource` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_data`
--

DROP TABLE IF EXISTS `resource_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  `redact` tinyint(1) DEFAULT NULL,
  `decrypt_method` varchar(64) DEFAULT NULL,
  `resource_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_resource_id` (`resource_id`),
  CONSTRAINT `fk_resource_id` FOREIGN KEY (`resource_id`) REFERENCES `resource` (`id`) ON DELETE CASCADE,
  CONSTRAINT `CONSTRAINT_1` CHECK (`redact` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource_data`
--

LOCK TABLES `resource_data` WRITE;
/*!40000 ALTER TABLE `resource_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `resource_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_properties_data`
--

DROP TABLE IF EXISTS `resource_properties_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource_properties_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `data` longtext DEFAULT NULL,
  `encrypted` tinyint(1) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`encrypted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource_properties_data`
--

LOCK TABLES `resource_properties_data` WRITE;
/*!40000 ALTER TABLE `resource_properties_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `resource_properties_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(36) NOT NULL,
  `engine_id` varchar(36) NOT NULL,
  `host` varchar(255) NOT NULL,
  `hostname` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `topic` varchar(255) NOT NULL,
  `report_interval` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `engine_id`, `host`, `hostname`, `binary`, `topic`, `report_interval`, `created_at`, `updated_at`, `deleted_at`) VALUES ('081b303b-aff9-446c-80b7-41c98a794df8','1fbab4ab-adae-4140-8dd7-975f1c8c351f','heat-engine-54f49697fd-pwnb8','heat-engine-54f49697fd-pwnb8','heat-engine','engine',60,'2025-12-05 09:03:31','2025-12-05 10:36:32',NULL),('3b089923-a638-4b49-9126-c4f814a4f2f6','620f34ca-b346-4463-9f07-f5a026809641','np0005546416.localdomain','np0005546416.localdomain','heat-engine','engine',60,'2025-12-05 08:22:33','2025-12-05 08:48:33',NULL),('4620d4e4-e6ef-4f90-9f19-447922cdd94a','eb8a4929-bc8c-407c-adf8-a1dee469c450','np0005546415.localdomain','np0005546415.localdomain','heat-engine','engine',60,'2025-12-05 08:22:14','2025-12-05 08:49:14',NULL),('7531e24d-e12c-43f6-9815-228d5cd4a22e','4bb9499f-8626-4919-b8c8-a6226a2808a5','heat-engine-54f49697fd-pwnb8','heat-engine-54f49697fd-pwnb8','heat-engine','engine',60,'2025-12-05 09:03:31','2025-12-05 10:36:32',NULL),('92f9a1a7-367d-4245-9118-11fb7e2e6ee5','a03dbebb-4b63-48e7-acb5-c997a4430378','heat-engine-54f49697fd-pwnb8','heat-engine-54f49697fd-pwnb8','heat-engine','engine',60,'2025-12-05 09:03:31','2025-12-05 10:36:32',NULL),('dbd6ff95-d263-4f82-87b0-1973f1d3e16b','1e10bc8f-8d5d-4f76-bf19-8a01ad730551','heat-engine-54f49697fd-pwnb8','heat-engine-54f49697fd-pwnb8','heat-engine','engine',60,'2025-12-05 09:03:31','2025-12-05 10:36:32',NULL),('f6bbfea9-68cc-4e8f-9165-b29c8c9a564d','5b99f64e-f0e0-4d46-8ad5-e187d0942a28','np0005546418.localdomain','np0005546418.localdomain','heat-engine','engine',60,'2025-12-05 08:22:32','2025-12-05 08:48:32',NULL);
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot`
--

DROP TABLE IF EXISTS `snapshot`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot` (
  `id` varchar(36) NOT NULL,
  `stack_id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` varchar(255) DEFAULT NULL,
  `data` longtext DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `stack_id` (`stack_id`),
  KEY `ix_snapshot_tenant` (`tenant`),
  CONSTRAINT `snapshot_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot`
--

LOCK TABLES `snapshot` WRITE;
/*!40000 ALTER TABLE `snapshot` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `software_config`
--

DROP TABLE IF EXISTS `software_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `software_config` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `group` varchar(255) DEFAULT NULL,
  `config` longtext DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_software_config_tenant` (`tenant`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `software_config`
--

LOCK TABLES `software_config` WRITE;
/*!40000 ALTER TABLE `software_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `software_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `software_deployment`
--

DROP TABLE IF EXISTS `software_deployment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `software_deployment` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `server_id` varchar(36) NOT NULL,
  `config_id` varchar(36) NOT NULL,
  `input_values` longtext DEFAULT NULL,
  `output_values` longtext DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  `stack_user_project_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `config_id` (`config_id`),
  KEY `ix_software_deployment_server_id` (`server_id`),
  KEY `ix_software_deployment_tenant` (`tenant`),
  KEY `ix_software_deployment_created_at` (`created_at`),
  CONSTRAINT `software_deployment_ibfk_1` FOREIGN KEY (`config_id`) REFERENCES `software_config` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `software_deployment`
--

LOCK TABLES `software_deployment` WRITE;
/*!40000 ALTER TABLE `software_deployment` DISABLE KEYS */;
/*!40000 ALTER TABLE `software_deployment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack`
--

DROP TABLE IF EXISTS `stack`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `raw_template_id` int(11) NOT NULL,
  `prev_raw_template_id` int(11) DEFAULT NULL,
  `user_creds_id` int(11) DEFAULT NULL,
  `username` varchar(256) DEFAULT NULL,
  `owner_id` varchar(36) DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `timeout` int(11) DEFAULT NULL,
  `tenant` varchar(256) DEFAULT NULL,
  `disable_rollback` tinyint(1) NOT NULL,
  `stack_user_project_id` varchar(64) DEFAULT NULL,
  `backup` tinyint(1) DEFAULT NULL,
  `nested_depth` int(11) DEFAULT NULL,
  `convergence` tinyint(1) DEFAULT NULL,
  `current_traversal` varchar(36) DEFAULT NULL,
  `current_deps` longtext DEFAULT NULL,
  `parent_resource_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `raw_template_id` (`raw_template_id`),
  KEY `prev_raw_template_id` (`prev_raw_template_id`),
  KEY `user_creds_id` (`user_creds_id`),
  KEY `ix_stack_owner_id` (`owner_id`),
  KEY `ix_stack_tenant` (`tenant`(255)),
  KEY `ix_stack_name` (`name`),
  CONSTRAINT `stack_ibfk_1` FOREIGN KEY (`raw_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `stack_ibfk_2` FOREIGN KEY (`prev_raw_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `stack_ibfk_3` FOREIGN KEY (`user_creds_id`) REFERENCES `user_creds` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`disable_rollback` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`backup` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`convergence` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack`
--

LOCK TABLES `stack` WRITE;
/*!40000 ALTER TABLE `stack` DISABLE KEYS */;
/*!40000 ALTER TABLE `stack` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack_lock`
--

DROP TABLE IF EXISTS `stack_lock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack_lock` (
  `stack_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `engine_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`stack_id`),
  CONSTRAINT `stack_lock_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack_lock`
--

LOCK TABLES `stack_lock` WRITE;
/*!40000 ALTER TABLE `stack_lock` DISABLE KEYS */;
/*!40000 ALTER TABLE `stack_lock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack_tag`
--

DROP TABLE IF EXISTS `stack_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `tag` varchar(80) DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `stack_id` (`stack_id`),
  CONSTRAINT `stack_tag_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack_tag`
--

LOCK TABLES `stack_tag` WRITE;
/*!40000 ALTER TABLE `stack_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `stack_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_point`
--

DROP TABLE IF EXISTS `sync_point`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sync_point` (
  `entity_id` varchar(36) NOT NULL,
  `traversal_id` varchar(36) NOT NULL,
  `is_update` tinyint(1) NOT NULL,
  `atomic_key` int(11) NOT NULL,
  `stack_id` varchar(36) NOT NULL,
  `input_data` longtext DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`traversal_id`,`is_update`),
  KEY `fk_stack_id` (`stack_id`),
  CONSTRAINT `fk_stack_id` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`is_update` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_point`
--

LOCK TABLES `sync_point` WRITE;
/*!40000 ALTER TABLE `sync_point` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_point` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_creds`
--

DROP TABLE IF EXISTS `user_creds`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_creds` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `username` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `region_name` varchar(255) DEFAULT NULL,
  `decrypt_method` varchar(64) DEFAULT NULL,
  `tenant` varchar(1024) DEFAULT NULL,
  `auth_url` text DEFAULT NULL,
  `tenant_id` varchar(256) DEFAULT NULL,
  `trust_id` varchar(255) DEFAULT NULL,
  `trustor_user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_creds`
--

LOCK TABLES `user_creds` WRITE;
/*!40000 ALTER TABLE `user_creds` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_creds` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `keystone`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `keystone` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `keystone`;

--
-- Table structure for table `access_rule`
--

DROP TABLE IF EXISTS `access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(64) DEFAULT NULL,
  `path` varchar(128) DEFAULT NULL,
  `method` varchar(16) DEFAULT NULL,
  `external_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_rule_external_id_key` (`external_id`),
  UNIQUE KEY `duplicate_access_rule_for_user_constraint` (`user_id`,`service`,`path`,`method`),
  KEY `external_id` (`external_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_rule`
--

LOCK TABLES `access_rule` WRITE;
/*!40000 ALTER TABLE `access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_token`
--

DROP TABLE IF EXISTS `access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_token` (
  `id` varchar(64) NOT NULL,
  `access_secret` varchar(64) NOT NULL,
  `authorizing_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  `role_ids` text NOT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_access_token_consumer_id` (`consumer_id`),
  KEY `ix_access_token_authorizing_user_id` (`authorizing_user_id`),
  CONSTRAINT `access_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_token`
--

LOCK TABLES `access_token` WRITE;
/*!40000 ALTER TABLE `access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('29e87d24a316'),('e25ffa003242');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential`
--

DROP TABLE IF EXISTS `application_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential` (
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `secret_hash` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `system` varchar(64) DEFAULT NULL,
  `unrestricted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `duplicate_app_cred_constraint` (`user_id`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential`
--

LOCK TABLES `application_credential` WRITE;
/*!40000 ALTER TABLE `application_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_access_rule`
--

DROP TABLE IF EXISTS `application_credential_access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_access_rule` (
  `application_credential_id` int(11) NOT NULL,
  `access_rule_id` int(11) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`access_rule_id`),
  KEY `access_rule_id` (`access_rule_id`),
  CONSTRAINT `application_credential_access_rule_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE,
  CONSTRAINT `application_credential_access_rule_ibfk_2` FOREIGN KEY (`access_rule_id`) REFERENCES `access_rule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_access_rule`
--

LOCK TABLES `application_credential_access_rule` WRITE;
/*!40000 ALTER TABLE `application_credential_access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_role`
--

DROP TABLE IF EXISTS `application_credential_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_role` (
  `application_credential_id` int(11) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`role_id`),
  CONSTRAINT `application_credential_role_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_role`
--

LOCK TABLES `application_credential_role` WRITE;
/*!40000 ALTER TABLE `application_credential_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assignment` (
  `type` enum('UserProject','GroupProject','UserDomain','GroupDomain') NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  KEY `ix_actor_id` (`actor_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`inherited` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserProject','1008d93aa8e5428d9ae7863f6801bc28','d98f9ffaeb7346169078ece01c85312d','78622b7bbc8f46b7b0a9596c4a004541',0),('UserProject','1008d93aa8e5428d9ae7863f6801bc28','d98f9ffaeb7346169078ece01c85312d','df759038f40d48b3be7f96de8bbe7ce2',0),('UserProject','1789cb75c8f44c539966d084bb392cb1','d98f9ffaeb7346169078ece01c85312d','78622b7bbc8f46b7b0a9596c4a004541',0),('UserProject','1789cb75c8f44c539966d084bb392cb1','d98f9ffaeb7346169078ece01c85312d','df759038f40d48b3be7f96de8bbe7ce2',0),('UserProject','24fbdd67d1a2407797e942da6f8af7b2','d98f9ffaeb7346169078ece01c85312d','78622b7bbc8f46b7b0a9596c4a004541',0),('UserProject','24fbdd67d1a2407797e942da6f8af7b2','d98f9ffaeb7346169078ece01c85312d','df759038f40d48b3be7f96de8bbe7ce2',0),('UserProject','3e3a327ce1e742268657f8c677b2e8a7','d98f9ffaeb7346169078ece01c85312d','78622b7bbc8f46b7b0a9596c4a004541',0),('UserProject','3e3a327ce1e742268657f8c677b2e8a7','d98f9ffaeb7346169078ece01c85312d','df759038f40d48b3be7f96de8bbe7ce2',0),('UserProject','442d3397f2c048d7b9064f5b951ba2b0','d98f9ffaeb7346169078ece01c85312d','78622b7bbc8f46b7b0a9596c4a004541',0),('UserProject','442d3397f2c048d7b9064f5b951ba2b0','d98f9ffaeb7346169078ece01c85312d','df759038f40d48b3be7f96de8bbe7ce2',0),('UserProject','52d0a54dc45b4c4caaba721ba3202150','b38a1d46818e4f37b442152341646ff0','df759038f40d48b3be7f96de8bbe7ce2',0),('UserProject','52d0a54dc45b4c4caaba721ba3202150','e6ca8a92050741d3a93772e6c1b0d704','df759038f40d48b3be7f96de8bbe7ce2',0),('UserProject','5d9e23101adb47c8a382d2ba6db3edaa','d98f9ffaeb7346169078ece01c85312d','78622b7bbc8f46b7b0a9596c4a004541',0),('UserProject','5d9e23101adb47c8a382d2ba6db3edaa','d98f9ffaeb7346169078ece01c85312d','df759038f40d48b3be7f96de8bbe7ce2',0),('UserProject','5f941ee4287e4dd1af0beb25dc9578ad','d98f9ffaeb7346169078ece01c85312d','df759038f40d48b3be7f96de8bbe7ce2',0),('UserProject','6eb10c949fe8439fb951786c0b398fcc','d98f9ffaeb7346169078ece01c85312d','df759038f40d48b3be7f96de8bbe7ce2',0),('UserProject','7e80b340e85f42e39c1385c6d8b66381','d98f9ffaeb7346169078ece01c85312d','78622b7bbc8f46b7b0a9596c4a004541',0),('UserProject','7e80b340e85f42e39c1385c6d8b66381','d98f9ffaeb7346169078ece01c85312d','b208df568e2841389a4c6b7f2dd8d0ac',0),('UserProject','7e80b340e85f42e39c1385c6d8b66381','d98f9ffaeb7346169078ece01c85312d','df759038f40d48b3be7f96de8bbe7ce2',0),('UserProject','824f3fa2f50c4abd95554aa63e00939a','b38a1d46818e4f37b442152341646ff0','be54ca0e2dad4a50b717b5923253282e',0),('UserProject','8f5b595a91b24c01a0669328ec534e31','d98f9ffaeb7346169078ece01c85312d','78622b7bbc8f46b7b0a9596c4a004541',0),('UserProject','8f5b595a91b24c01a0669328ec534e31','d98f9ffaeb7346169078ece01c85312d','df759038f40d48b3be7f96de8bbe7ce2',0),('UserProject','aebc3fa07a254e76886e329e7e811fb2','d98f9ffaeb7346169078ece01c85312d','78622b7bbc8f46b7b0a9596c4a004541',0),('UserProject','aebc3fa07a254e76886e329e7e811fb2','d98f9ffaeb7346169078ece01c85312d','df759038f40d48b3be7f96de8bbe7ce2',0),('UserProject','c09787ff15134c9896057a29fefbe933','d98f9ffaeb7346169078ece01c85312d','78622b7bbc8f46b7b0a9596c4a004541',0),('UserProject','c09787ff15134c9896057a29fefbe933','d98f9ffaeb7346169078ece01c85312d','df759038f40d48b3be7f96de8bbe7ce2',0),('UserProject','e0b4238c063b43b4a06600840a571eec','d98f9ffaeb7346169078ece01c85312d','df759038f40d48b3be7f96de8bbe7ce2',0),('UserProject','f0c6f4464f324894b645e2b08b47171d','d98f9ffaeb7346169078ece01c85312d','78622b7bbc8f46b7b0a9596c4a004541',0),('UserProject','f0c6f4464f324894b645e2b08b47171d','d98f9ffaeb7346169078ece01c85312d','df759038f40d48b3be7f96de8bbe7ce2',0),('UserProject','fbd71b80bbe24eed9360343f4642ca6d','d98f9ffaeb7346169078ece01c85312d','df759038f40d48b3be7f96de8bbe7ce2',0),('UserDomain','6741e6cd4bee46c5ad024e6e59d0c98d','8312986afb0648b9899cce6e584a2d21','df759038f40d48b3be7f96de8bbe7ce2',0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_register`
--

DROP TABLE IF EXISTS `config_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_register` (
  `type` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_register`
--

LOCK TABLES `config_register` WRITE;
/*!40000 ALTER TABLE `config_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `config_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumer`
--

DROP TABLE IF EXISTS `consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumer` (
  `id` varchar(64) NOT NULL,
  `description` varchar(64) DEFAULT NULL,
  `secret` varchar(64) NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumer`
--

LOCK TABLES `consumer` WRITE;
/*!40000 ALTER TABLE `consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credential` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `key_hash` varchar(64) NOT NULL,
  `encrypted_blob` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
INSERT INTO `credential` (`id`, `user_id`, `project_id`, `type`, `extra`, `key_hash`, `encrypted_blob`) VALUES ('6239129c03644c4d8dd219a850b3b394','52d0a54dc45b4c4caaba721ba3202150',NULL,'cert','{}','4a0dc58ad6ba907da219ed54de96642f70375114','gAAAAABpMpl4wSbNVofwlKs5WdM0joSz_aXsRDV-B_cBjktxSMS2bpQoWn5fPepn2WIgdtE27c4rfR4MWPtkhEfVL7UlHxkrUQ==');
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint` (
  `id` varchar(64) NOT NULL,
  `legacy_endpoint_id` varchar(64) DEFAULT NULL,
  `interface` varchar(8) NOT NULL,
  `service_id` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `region_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `service_id` (`service_id`),
  KEY `fk_endpoint_region_id` (`region_id`),
  CONSTRAINT `endpoint_service_id_fkey` FOREIGN KEY (`service_id`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_endpoint_region_id` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
INSERT INTO `endpoint` (`id`, `legacy_endpoint_id`, `interface`, `service_id`, `url`, `extra`, `enabled`, `region_id`) VALUES ('1201a45903ec46758e388fa266a29b25',NULL,'public','181b92abad9b470ca3313135478c10c0','http://heat-api-public-openstack.apps-crc.testing/v1/%(tenant_id)s','{\"name\": \"heat\"}',1,'regionOne'),('1631e28b88474a7c9689a5c86c3f814e',NULL,'public','4922d58dda33436386801373647b7932','http://heat-cfnapi-public-openstack.apps-crc.testing/v1','{\"name\": \"heat-cfn\"}',1,'regionOne'),('312e323bd86446bda47b5360416c698c',NULL,'internal','cc05d015e74042adbe4281b27c963cf8','http://barbican-internal.openstack.svc:9311','{\"name\": \"barbican\"}',1,'regionOne'),('3736501068a946659a182f41d11b64e2',NULL,'public','1a4486e1802b4976b31f5b7af5591bc6','http://aodh-public-openstack.apps-crc.testing','{\"name\": \"aodh\"}',1,'regionOne'),('3d9284dedb6d488fbd7415714710891c',NULL,'internal','34c74b3d81a34484bd5b4ee2857b5e3d','http://nova-internal.openstack.svc:8774/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('4608051a02984139a91612a406c40536',NULL,'public','89334965953845ef9c42ac6a49d48cda','http://keystone-public-openstack.apps-crc.testing','{}',1,'regionOne'),('53a5144711d14f9a9c1d9fc03621478c',NULL,'public','fb0fb29385ba4a0f8b242fbc3ba096b2','http://neutron-public-openstack.apps-crc.testing','{\"name\": \"neutron\"}',1,'regionOne'),('5fa2716e2b904d7ba64867dbd11069d4',NULL,'internal','df803d9bf7594244a01aefd5189d7901','http://cinder-internal.openstack.svc:8776/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('64c9cdffeca44e8c8258ec1b616b3c92',NULL,'public','1b5477ba46f94a87bfaa9c76d47046e8','http://glance-default-public-openstack.apps-crc.testing','{\"name\": \"glance\"}',1,'regionOne'),('6ed9c472e222406982560b1dc3cdf15e',NULL,'public','b431fb91ad1c4a61b30a97ea23bbc6b1','http://manila-public-openstack.apps-crc.testing/v1/%(project_id)s','{\"name\": \"manila\"}',1,'regionOne'),('77e58170a4c646f584e4d9910092aaaa',NULL,'public','02ebdc8511e642ce9753c3f60955e546','http://placement-public-openstack.apps-crc.testing','{\"name\": \"placement\"}',1,'regionOne'),('915157431a264723abe50a65d92f9a32',NULL,'internal','f154f6d0d4b84d73abfceb7c68c2243d','http://manila-internal.openstack.svc:8786/v2','{\"name\": \"manilav2\"}',1,'regionOne'),('a2ed936f6b7a4066b0cf1619da8397a5',NULL,'internal','fb0fb29385ba4a0f8b242fbc3ba096b2','http://neutron-internal.openstack.svc:9696','{\"name\": \"neutron\"}',1,'regionOne'),('ae3e961e197f47bba4c0cad2ea52e1fb',NULL,'public','f154f6d0d4b84d73abfceb7c68c2243d','http://manila-public-openstack.apps-crc.testing/v2','{\"name\": \"manilav2\"}',1,'regionOne'),('b10246edca994f0e9cf0db3508822af6',NULL,'internal','4922d58dda33436386801373647b7932','http://heat-cfnapi-internal.openstack.svc:8000/v1','{\"name\": \"heat-cfn\"}',1,'regionOne'),('bcf8d4cf73fd4a27936be59322285927',NULL,'internal','89334965953845ef9c42ac6a49d48cda','http://keystone-internal.openstack.svc:5000','{}',1,'regionOne'),('cac0459c04ab4532ae93841fd1a433b7',NULL,'public','cc05d015e74042adbe4281b27c963cf8','http://barbican-public-openstack.apps-crc.testing','{\"name\": \"barbican\"}',1,'regionOne'),('cb8f5c5b29934af28dcf16138a4457c9',NULL,'internal','02ebdc8511e642ce9753c3f60955e546','http://placement-internal.openstack.svc:8778','{\"name\": \"placement\"}',1,'regionOne'),('cdf63636873e49d3bd2f987cf1bd0b87',NULL,'internal','b431fb91ad1c4a61b30a97ea23bbc6b1','http://manila-internal.openstack.svc:8786/v1/%(project_id)s','{\"name\": \"manila\"}',1,'regionOne'),('e71b12ca2d06458190549d07745fc807',NULL,'public','34c74b3d81a34484bd5b4ee2857b5e3d','http://nova-public-openstack.apps-crc.testing/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('e7ba4b7e8ab54c438f8d21d05acca154',NULL,'internal','1a4486e1802b4976b31f5b7af5591bc6','http://aodh-internal.openstack.svc:8042','{\"name\": \"aodh\"}',1,'regionOne'),('f3d5f59a86cc4d7ca011a8c8038be4b9',NULL,'internal','181b92abad9b470ca3313135478c10c0','http://heat-api-internal.openstack.svc:8004/v1/%(tenant_id)s','{\"name\": \"heat\"}',1,'regionOne'),('f96f3dbff56a4652864117a1bdf1754d',NULL,'internal','1b5477ba46f94a87bfaa9c76d47046e8','http://glance-default-internal.openstack.svc:9292','{\"name\": \"glance\"}',1,'regionOne'),('ffbbef33f7ef459ca79a8158fb50a795',NULL,'public','df803d9bf7594244a01aefd5189d7901','http://cinder-public-openstack.apps-crc.testing/v3','{\"name\": \"cinderv3\"}',1,'regionOne');
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint_group`
--

DROP TABLE IF EXISTS `endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint_group` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `filters` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint_group`
--

LOCK TABLES `endpoint_group` WRITE;
/*!40000 ALTER TABLE `endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expiring_user_group_membership`
--

DROP TABLE IF EXISTS `expiring_user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expiring_user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `last_verified` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`,`idp_id`),
  KEY `group_id` (`group_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_3` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expiring_user_group_membership`
--

LOCK TABLES `expiring_user_group_membership` WRITE;
/*!40000 ALTER TABLE `expiring_user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `expiring_user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federated_user`
--

DROP TABLE IF EXISTS `federated_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federated_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `protocol_id` varchar(64) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idp_id` (`idp_id`,`protocol_id`,`unique_id`),
  KEY `user_id` (`user_id`),
  KEY `federated_user_protocol_id_fkey` (`protocol_id`,`idp_id`),
  CONSTRAINT `federated_user_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_ibfk_2` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_protocol_id_fkey` FOREIGN KEY (`protocol_id`, `idp_id`) REFERENCES `federation_protocol` (`id`, `idp_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federated_user`
--

LOCK TABLES `federated_user` WRITE;
/*!40000 ALTER TABLE `federated_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `federated_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federation_protocol`
--

DROP TABLE IF EXISTS `federation_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federation_protocol` (
  `id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `mapping_id` varchar(64) NOT NULL,
  `remote_id_attribute` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`,`idp_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `federation_protocol_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federation_protocol`
--

LOCK TABLES `federation_protocol` WRITE;
/*!40000 ALTER TABLE `federation_protocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `federation_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group`
--

DROP TABLE IF EXISTS `group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group` (
  `id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_group_name_domain_id` (`domain_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group`
--

LOCK TABLES `group` WRITE;
/*!40000 ALTER TABLE `group` DISABLE KEYS */;
/*!40000 ALTER TABLE `group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `id_mapping`
--

DROP TABLE IF EXISTS `id_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `id_mapping` (
  `public_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `local_id` varchar(255) NOT NULL,
  `entity_type` enum('user','group') NOT NULL,
  PRIMARY KEY (`public_id`),
  UNIQUE KEY `domain_id` (`domain_id`,`local_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `id_mapping`
--

LOCK TABLES `id_mapping` WRITE;
/*!40000 ALTER TABLE `id_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `id_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `identity_provider`
--

DROP TABLE IF EXISTS `identity_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `identity_provider` (
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `authorization_ttl` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_id` (`domain_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `identity_provider`
--

LOCK TABLES `identity_provider` WRITE;
/*!40000 ALTER TABLE `identity_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `identity_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `idp_remote_ids`
--

DROP TABLE IF EXISTS `idp_remote_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `idp_remote_ids` (
  `idp_id` varchar(64) DEFAULT NULL,
  `remote_id` varchar(255) NOT NULL,
  PRIMARY KEY (`remote_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `idp_remote_ids_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `idp_remote_ids`
--

LOCK TABLES `idp_remote_ids` WRITE;
/*!40000 ALTER TABLE `idp_remote_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `idp_remote_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `implied_role`
--

DROP TABLE IF EXISTS `implied_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `implied_role` (
  `prior_role_id` varchar(64) NOT NULL,
  `implied_role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`prior_role_id`,`implied_role_id`),
  KEY `implied_role_implied_role_id_fkey` (`implied_role_id`),
  CONSTRAINT `implied_role_implied_role_id_fkey` FOREIGN KEY (`implied_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE,
  CONSTRAINT `implied_role_prior_role_id_fkey` FOREIGN KEY (`prior_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `implied_role`
--

LOCK TABLES `implied_role` WRITE;
/*!40000 ALTER TABLE `implied_role` DISABLE KEYS */;
INSERT INTO `implied_role` (`prior_role_id`, `implied_role_id`) VALUES ('be54ca0e2dad4a50b717b5923253282e','d5a08343f01848eebeaab396b47858fc'),('df759038f40d48b3be7f96de8bbe7ce2','be54ca0e2dad4a50b717b5923253282e');
/*!40000 ALTER TABLE `implied_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `limit`
--

DROP TABLE IF EXISTS `limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `limit` (
  `id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `resource_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `registered_limit_id` varchar(64) DEFAULT NULL,
  `domain_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `limit_id_key` (`id`),
  KEY `registered_limit_id` (`registered_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `limit`
--

LOCK TABLES `limit` WRITE;
/*!40000 ALTER TABLE `limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_user`
--

DROP TABLE IF EXISTS `local_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `local_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `failed_auth_count` int(11) DEFAULT NULL,
  `failed_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_id` (`domain_id`,`name`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `local_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `local_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=644 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `local_user`
--

LOCK TABLES `local_user` WRITE;
/*!40000 ALTER TABLE `local_user` DISABLE KEYS */;
INSERT INTO `local_user` (`id`, `user_id`, `domain_id`, `name`, `failed_auth_count`, `failed_auth_at`) VALUES (2,'52d0a54dc45b4c4caaba721ba3202150','default','admin',0,NULL),(5,'24fbdd67d1a2407797e942da6f8af7b2','default','aodh',0,NULL),(8,'7e80b340e85f42e39c1385c6d8b66381','default','ceilometer',0,NULL),(11,'5d9e23101adb47c8a382d2ba6db3edaa','default','cinder',0,NULL),(14,'aebc3fa07a254e76886e329e7e811fb2','default','cinderv3',0,NULL),(17,'6eb10c949fe8439fb951786c0b398fcc','default','gnocchi',0,NULL),(20,'1008d93aa8e5428d9ae7863f6801bc28','default','glance',0,NULL),(23,'442d3397f2c048d7b9064f5b951ba2b0','default','heat',0,NULL),(26,'6741e6cd4bee46c5ad024e6e59d0c98d','8312986afb0648b9899cce6e584a2d21','heat_stack_domain_admin',0,NULL),(29,'e0b4238c063b43b4a06600840a571eec','default','heat-cfn',0,NULL),(32,'f0c6f4464f324894b645e2b08b47171d','default','manila',0,NULL),(35,'5f941ee4287e4dd1af0beb25dc9578ad','default','manilav2',0,NULL),(38,'c09787ff15134c9896057a29fefbe933','default','neutron',0,NULL),(41,'1789cb75c8f44c539966d084bb392cb1','default','nova',0,NULL),(44,'3e3a327ce1e742268657f8c677b2e8a7','default','placement',0,NULL),(47,'fbd71b80bbe24eed9360343f4642ca6d','default','swift',0,NULL),(50,'8f5b595a91b24c01a0669328ec534e31','default','barbican',0,NULL),(51,'824f3fa2f50c4abd95554aa63e00939a','default','demo_tempestconf',0,NULL),(52,'82349838b9764648b21be888e6cf01eb','default','alt_demo_tempestconf',0,NULL);
/*!40000 ALTER TABLE `local_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mapping`
--

DROP TABLE IF EXISTS `mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mapping` (
  `id` varchar(64) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mapping`
--

LOCK TABLES `mapping` WRITE;
/*!40000 ALTER TABLE `mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrate_version`
--

DROP TABLE IF EXISTS `migrate_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrate_version` (
  `repository_id` varchar(250) NOT NULL,
  `repository_path` text DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`repository_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrate_version`
--

LOCK TABLES `migrate_version` WRITE;
/*!40000 ALTER TABLE `migrate_version` DISABLE KEYS */;
INSERT INTO `migrate_version` (`repository_id`, `repository_path`, `version`) VALUES ('keystone','/usr/lib/python3.9/site-packages/keystone/common/sql/migrate_repo',109),('keystone_contract','/usr/lib/python3.9/site-packages/keystone/common/sql/contract_repo',79),('keystone_data_migrate','/usr/lib/python3.9/site-packages/keystone/common/sql/data_migration_repo',79),('keystone_expand','/usr/lib/python3.9/site-packages/keystone/common/sql/expand_repo',79);
/*!40000 ALTER TABLE `migrate_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nonlocal_user`
--

DROP TABLE IF EXISTS `nonlocal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nonlocal_user` (
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  PRIMARY KEY (`domain_id`,`name`),
  UNIQUE KEY `ixu_nonlocal_user_user_id` (`user_id`),
  KEY `nonlocal_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `nonlocal_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nonlocal_user`
--

LOCK TABLES `nonlocal_user` WRITE;
/*!40000 ALTER TABLE `nonlocal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `nonlocal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password`
--

DROP TABLE IF EXISTS `password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_user_id` int(11) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `self_service` tinyint(1) NOT NULL DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `created_at_int` bigint(20) NOT NULL DEFAULT 0,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `local_user_id` (`local_user_id`),
  CONSTRAINT `password_ibfk_1` FOREIGN KEY (`local_user_id`) REFERENCES `local_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=646 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password`
--

LOCK TABLES `password` WRITE;
/*!40000 ALTER TABLE `password` DISABLE KEYS */;
INSERT INTO `password` (`id`, `local_user_id`, `expires_at`, `self_service`, `password_hash`, `created_at_int`, `expires_at_int`, `created_at`) VALUES (2,2,'2025-12-05 08:51:06',0,'$2b$12$blm.P2CKVu/uf2eJqjEDV.BsXMYlsEBwmYAxFDScBSk4fWJdGa4bW',1764922690650035,1764924666177057,'2025-12-05 08:18:10'),(5,5,NULL,0,'$2b$12$bT/gyzAOB7LqXKx3JVfmv.6/AuQX1RbsG5TV4F6acyw01vtkIJrPu',1764922829460776,NULL,'2025-12-05 08:20:29'),(8,8,NULL,0,'$2b$12$tIIV7x9T/3T8uCCnTB91H.YjscIVcqhYnK8zDnk4Bx9DIhF5wR0ie',1764922829766167,NULL,'2025-12-05 08:20:29'),(11,11,NULL,0,'$2b$12$x6agMJxK24LiL2pTmOQvRehnfRzUXfydPEzaDHDztijnA7CJlfvXu',1764922830052903,NULL,'2025-12-05 08:20:30'),(14,14,NULL,0,'$2b$12$iZan9ZYWWUxOXv3XsnLjnezgTxN/BBi3oApgv4RwbYiJKebEwuWya',1764922830628451,NULL,'2025-12-05 08:20:30'),(17,17,NULL,0,'$2b$12$TyToZQNdNhORPLUuSuLGSuC3ZqyLKym9/60h22YIBLYt..NYhIvVi',1764922830983829,NULL,'2025-12-05 08:20:30'),(20,20,NULL,0,'$2b$12$b/tUwFH/BtyqT/1/P3/haue1rQ2jmF3D6zfVf.P3jp4RWuaezqQt2',1764922831232256,NULL,'2025-12-05 08:20:31'),(23,23,NULL,0,'$2b$12$PX2wcg2g7DIKtz55CutRTObAsEOvWUDIID.vuXDBb7iN1SsCXkxWC',1764922831348989,NULL,'2025-12-05 08:20:31'),(26,26,NULL,0,'$2b$12$nQfiEmDsA59whinvX2LI3uQfO9SlxpUjDiXQ1FlOWqPLSTUrAphLS',1764922832042140,NULL,'2025-12-05 08:20:32'),(29,29,NULL,0,'$2b$12$UfcnbfZNPbdwQyIIaDKC1uTTkLHLDNdErTpGzlf0IFwza.G0Hl/Wa',1764922832353800,NULL,'2025-12-05 08:20:32'),(32,32,NULL,0,'$2b$12$I54EX0edOmAgFDxMmnnjuObVUcFwBJLjPgVnQs3HX/rioA1vfNe1.',1764922832676474,NULL,'2025-12-05 08:20:32'),(35,35,NULL,0,'$2b$12$/iXu87uhpK7ZwG4Oz2a.YuqmSO/gkid9E8owP3TXECBqUlDCNlPl6',1764922840892446,NULL,'2025-12-05 08:20:40'),(38,38,NULL,0,'$2b$12$wm7LoeVoEwlmGBhdwvxA2u4bVg3Lk9GbD45t4.sWRDBESxU.LENw2',1764922841471585,NULL,'2025-12-05 08:20:41'),(41,41,NULL,0,'$2b$12$BgFRNRYngw02Jt4clug/NueuK70AaxT2Y4SsgJzK6gCuHUEWA9Wo.',1764922841584317,NULL,'2025-12-05 08:20:41'),(44,44,NULL,0,'$2b$12$fu6EMJlFBhliK4m4tHwQ3u9n4VeGmkqZIEKGksLsNsjj5MG6qz1n6',1764922842343545,NULL,'2025-12-05 08:20:42'),(47,47,NULL,0,'$2b$12$NJdneCjbvkkk/8pB3Ni6J.BPpLhc5gLCJnHQLfTdmSgfKRzNLyCI6',1764922842644237,NULL,'2025-12-05 08:20:42'),(50,2,NULL,0,'$2b$12$5913i6KQaUNmUh3e5Qr0q.FQqZtm0NswHhM84ATpnhI5cXpYxgaHS',1764924666177057,NULL,'2025-12-05 08:51:06'),(51,50,NULL,0,'$2b$12$Sm1/.FdQGetI7Jz1/xPOx.BrXgouqPGEb3emvKJR4daxyRUNLXwOu',1764924813295086,NULL,'2025-12-05 08:53:33'),(52,51,NULL,0,'$2b$12$.ShzSKCHufQU8lmdcAnWu.5dGpmZTHadRIsXW1dC1x4jPxGhl2Nza',1764928996924965,NULL,'2025-12-05 10:03:16'),(53,52,NULL,0,'$2b$12$sC4hTKNFMANjT3n46AkoX.53/b0XGmzAJc3GgyQ1.tZTAIeElEQcO',1764928997357358,NULL,'2025-12-05 10:03:17');
/*!40000 ALTER TABLE `password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `blob` text NOT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_association`
--

DROP TABLE IF EXISTS `policy_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy_association` (
  `id` varchar(64) NOT NULL,
  `policy_id` varchar(64) NOT NULL,
  `endpoint_id` varchar(64) DEFAULT NULL,
  `service_id` varchar(64) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `endpoint_id` (`endpoint_id`,`service_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_association`
--

LOCK TABLES `policy_association` WRITE;
/*!40000 ALTER TABLE `policy_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project` (
  `id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL,
  `is_domain` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_project_name_domain_id` (`domain_id`,`name`),
  KEY `project_parent_id_fkey` (`parent_id`),
  CONSTRAINT `project_domain_id_fkey` FOREIGN KEY (`domain_id`) REFERENCES `project` (`id`),
  CONSTRAINT `project_parent_id_fkey` FOREIGN KEY (`parent_id`) REFERENCES `project` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
INSERT INTO `project` (`id`, `name`, `extra`, `description`, `enabled`, `domain_id`, `parent_id`, `is_domain`) VALUES ('440faaea58384fd181042ac4bee82b37','alt_demo','{}','Project for Tempest alt_demo_tempestconf user',1,'default','default',0),('8312986afb0648b9899cce6e584a2d21','heat_stack','{}','',1,'<<keystone.domain.root>>',NULL,1),('<<keystone.domain.root>>','<<keystone.domain.root>>','{}','',0,'<<keystone.domain.root>>',NULL,1),('b38a1d46818e4f37b442152341646ff0','demo','{}','Project for Tempest demo_tempestconf user',1,'default','default',0),('d98f9ffaeb7346169078ece01c85312d','service','{}',NULL,1,'default','default',0),('default','Default','{}','The default domain',1,'<<keystone.domain.root>>',NULL,1),('e6ca8a92050741d3a93772e6c1b0d704','admin','{}','Bootstrap project for initializing the cloud.',1,'default','default',0);
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint`
--

DROP TABLE IF EXISTS `project_endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint` (
  `endpoint_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint`
--

LOCK TABLES `project_endpoint` WRITE;
/*!40000 ALTER TABLE `project_endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint_group`
--

DROP TABLE IF EXISTS `project_endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint_group` (
  `endpoint_group_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_group_id`,`project_id`),
  CONSTRAINT `project_endpoint_group_ibfk_1` FOREIGN KEY (`endpoint_group_id`) REFERENCES `endpoint_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint_group`
--

LOCK TABLES `project_endpoint_group` WRITE;
/*!40000 ALTER TABLE `project_endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_option`
--

DROP TABLE IF EXISTS `project_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_option` (
  `project_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`project_id`,`option_id`),
  CONSTRAINT `project_option_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_option`
--

LOCK TABLES `project_option` WRITE;
/*!40000 ALTER TABLE `project_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_tag`
--

DROP TABLE IF EXISTS `project_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_tag` (
  `project_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`project_id`,`name`),
  UNIQUE KEY `project_id` (`project_id`,`name`),
  CONSTRAINT `project_tag_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_tag`
--

LOCK TABLES `project_tag` WRITE;
/*!40000 ALTER TABLE `project_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `parent_region_id` varchar(255) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` (`id`, `description`, `parent_region_id`, `extra`) VALUES ('regionOne','',NULL,'{}');
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registered_limit`
--

DROP TABLE IF EXISTS `registered_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `registered_limit` (
  `id` varchar(64) NOT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `default_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `registered_limit_id_key` (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `registered_limit`
--

LOCK TABLES `registered_limit` WRITE;
/*!40000 ALTER TABLE `registered_limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `registered_limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_token`
--

DROP TABLE IF EXISTS `request_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_token` (
  `id` varchar(64) NOT NULL,
  `request_secret` varchar(64) NOT NULL,
  `verifier` varchar(64) DEFAULT NULL,
  `authorizing_user_id` varchar(64) DEFAULT NULL,
  `requested_project_id` varchar(64) NOT NULL,
  `role_ids` text DEFAULT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_request_token_consumer_id` (`consumer_id`),
  CONSTRAINT `request_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_token`
--

LOCK TABLES `request_token` WRITE;
/*!40000 ALTER TABLE `request_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revocation_event`
--

DROP TABLE IF EXISTS `revocation_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revocation_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` varchar(64) DEFAULT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  `role_id` varchar(64) DEFAULT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `consumer_id` varchar(64) DEFAULT NULL,
  `access_token_id` varchar(64) DEFAULT NULL,
  `issued_before` datetime NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `revoked_at` datetime NOT NULL,
  `audit_id` varchar(32) DEFAULT NULL,
  `audit_chain_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_revocation_event_new_revoked_at` (`revoked_at`),
  KEY `ix_revocation_event_issued_before` (`issued_before`),
  KEY `ix_revocation_event_project_id_issued_before` (`project_id`,`issued_before`),
  KEY `ix_revocation_event_user_id_issued_before` (`user_id`,`issued_before`),
  KEY `ix_revocation_event_audit_id_issued_before` (`audit_id`,`issued_before`)
) ENGINE=InnoDB AUTO_INCREMENT=1201 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revocation_event`
--

LOCK TABLES `revocation_event` WRITE;
/*!40000 ALTER TABLE `revocation_event` DISABLE KEYS */;
INSERT INTO `revocation_event` (`id`, `domain_id`, `project_id`, `user_id`, `role_id`, `trust_id`, `consumer_id`, `access_token_id`, `issued_before`, `expires_at`, `revoked_at`, `audit_id`, `audit_chain_id`) VALUES (1,NULL,NULL,'52d0a54dc45b4c4caaba721ba3202150',NULL,NULL,NULL,NULL,'2025-12-05 08:51:07',NULL,'2025-12-05 08:51:07',NULL,NULL),(2,NULL,NULL,'bb93c1d8acd94eb382d328db5e3abbb8',NULL,NULL,NULL,NULL,'2025-12-05 10:03:52',NULL,'2025-12-05 10:03:52',NULL,NULL),(3,NULL,NULL,'809edff4f8124b3d8ef7dbbdb3a970f0',NULL,NULL,NULL,NULL,'2025-12-05 10:03:55',NULL,'2025-12-05 10:03:55',NULL,NULL),(4,NULL,NULL,'3a01b89a353549d18d808d9638508dee',NULL,NULL,NULL,NULL,'2025-12-05 10:03:55',NULL,'2025-12-05 10:03:55',NULL,NULL),(5,NULL,NULL,'1638003e1ba941e5b8ac9a9443db4583',NULL,NULL,NULL,NULL,'2025-12-05 10:03:55',NULL,'2025-12-05 10:03:55',NULL,NULL),(6,NULL,NULL,'309d91a281a0416dbd776ccd78a6dc86',NULL,NULL,NULL,NULL,'2025-12-05 10:03:56',NULL,'2025-12-05 10:03:56',NULL,NULL),(7,NULL,'71e676804a9f4c0d9b75a5dd90b1051c',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:03:56',NULL,'2025-12-05 10:03:56',NULL,NULL),(8,NULL,NULL,'b1461f6f3ae541deab9993146a10e9b9',NULL,NULL,NULL,NULL,'2025-12-05 10:03:57',NULL,'2025-12-05 10:03:57',NULL,NULL),(9,NULL,NULL,'c3005158dfb340c3acc07c4179ab59e2',NULL,NULL,NULL,NULL,'2025-12-05 10:03:57',NULL,'2025-12-05 10:03:57',NULL,NULL),(10,NULL,NULL,'1e742ea2128e4fe2bb0ffa8ad98008c0',NULL,NULL,NULL,NULL,'2025-12-05 10:03:57',NULL,'2025-12-05 10:03:57',NULL,NULL),(11,NULL,'5a234116ff934d20b55323301a7ffdf0',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:03:57',NULL,'2025-12-05 10:03:57',NULL,NULL),(12,NULL,'448f1bfa16b6450489c9ca9213196754',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:03:57',NULL,'2025-12-05 10:03:57',NULL,NULL),(13,NULL,NULL,'58f22dc64e5840c0a96e8f88d9df1cd0',NULL,NULL,NULL,NULL,'2025-12-05 10:03:57',NULL,'2025-12-05 10:03:57',NULL,NULL),(14,NULL,NULL,'0593e8806f504d34afbf5fe9f69fd3c1',NULL,NULL,NULL,NULL,'2025-12-05 10:03:57',NULL,'2025-12-05 10:03:57',NULL,NULL),(15,NULL,NULL,'bd236eee560546fdaf4245a9e0a5eab6',NULL,NULL,NULL,NULL,'2025-12-05 10:03:57',NULL,'2025-12-05 10:03:57',NULL,NULL),(16,NULL,NULL,'87550728d6154accb26f6c2d099bd9b0',NULL,NULL,NULL,NULL,'2025-12-05 10:03:57',NULL,'2025-12-05 10:03:57',NULL,NULL),(17,NULL,NULL,'b074572fcaf04e6da51cd61e9d847e64',NULL,NULL,NULL,NULL,'2025-12-05 10:03:58',NULL,'2025-12-05 10:03:58',NULL,NULL),(18,NULL,NULL,'8c9052b4d8254e65bfd541993182bfd1',NULL,NULL,NULL,NULL,'2025-12-05 10:03:58',NULL,'2025-12-05 10:03:58',NULL,NULL),(19,NULL,NULL,'ebc90c5332764037b63a3721e79aed4d',NULL,NULL,NULL,NULL,'2025-12-05 10:03:58',NULL,'2025-12-05 10:03:58',NULL,NULL),(20,NULL,'77506f1a596647cb98db3b6de82334fa',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:03:58',NULL,'2025-12-05 10:03:58',NULL,NULL),(21,NULL,'b776c067d1494ddabdac904ca92559e3',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:03:58',NULL,'2025-12-05 10:03:58',NULL,NULL),(22,NULL,'ebf9daa122a047b7b003e19fa221be82',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:03:58',NULL,'2025-12-05 10:03:58',NULL,NULL),(23,NULL,'5b3b12c6dae14f4d9c60044df5b8197d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:03:59',NULL,'2025-12-05 10:03:59',NULL,NULL),(24,NULL,'f4016f5921354963af0e2ec1a456e182',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:03:59',NULL,'2025-12-05 10:03:59',NULL,NULL),(25,NULL,'20434b2af33d4e4fa8ef7a764ffee959',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:00',NULL,'2025-12-05 10:04:00',NULL,NULL),(26,NULL,'90193c04335c4f938339af3e2e6df03b',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:00',NULL,'2025-12-05 10:04:00',NULL,NULL),(27,NULL,'948c5d6b0c9f4a88a1b5438cc6a1621e',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:00',NULL,'2025-12-05 10:04:00',NULL,NULL),(28,NULL,'1ac93e1a1c8a4b65a1843bbd6093004d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:00',NULL,'2025-12-05 10:04:00',NULL,NULL),(29,NULL,'283142e28e2a43faab9673e2fdf710ec',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:00',NULL,'2025-12-05 10:04:00',NULL,NULL),(30,NULL,'dbe088fc121841a4910497b6a309af8f',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:01',NULL,'2025-12-05 10:04:01',NULL,NULL),(31,NULL,'547e472234c44afaae24d0477b45bf3b',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:01',NULL,'2025-12-05 10:04:01',NULL,NULL),(32,NULL,NULL,'92b24da7f6434478ba701775b6ff9eb3',NULL,NULL,NULL,NULL,'2025-12-05 10:04:01',NULL,'2025-12-05 10:04:01',NULL,NULL),(33,NULL,NULL,'f9750fcd0f824f5b936990d6e01b3246',NULL,NULL,NULL,NULL,'2025-12-05 10:04:02',NULL,'2025-12-05 10:04:02',NULL,NULL),(34,NULL,'9fb1999fb0aa4eebaa7830e57b729742',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:03',NULL,'2025-12-05 10:04:03',NULL,NULL),(35,NULL,NULL,'6aa5c112c0884882ad561d49efc2deb7',NULL,NULL,NULL,NULL,'2025-12-05 10:04:03',NULL,'2025-12-05 10:04:03',NULL,NULL),(36,NULL,NULL,'fde0d242b6bd42ecbc3fb6cf3e9bc432',NULL,NULL,NULL,NULL,'2025-12-05 10:04:04',NULL,'2025-12-05 10:04:04',NULL,NULL),(37,NULL,'0d62d415b8104f048d9943c6ebe39f4f',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:04',NULL,'2025-12-05 10:04:04',NULL,NULL),(38,NULL,'b8a5a37417b54b8fa81fb0b9580ecc33',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:05',NULL,'2025-12-05 10:04:05',NULL,NULL),(39,NULL,NULL,'b13fa02f466f4c7a923cfa5dbecdd14e',NULL,NULL,NULL,NULL,'2025-12-05 10:04:06',NULL,'2025-12-05 10:04:06',NULL,NULL),(40,NULL,NULL,'f560f8c9d6d14d17890216a7fcfffacd',NULL,NULL,NULL,NULL,'2025-12-05 10:04:06',NULL,'2025-12-05 10:04:06',NULL,NULL),(41,NULL,NULL,'2b7d63ae1fdb44419e6583a0f7e7fbc5',NULL,NULL,NULL,NULL,'2025-12-05 10:04:06',NULL,'2025-12-05 10:04:06',NULL,NULL),(42,NULL,NULL,'8a187218b64844ada704f75f41de1441',NULL,NULL,NULL,NULL,'2025-12-05 10:04:06',NULL,'2025-12-05 10:04:06',NULL,NULL),(43,NULL,'8a8050965e9c4ee4b9d3862173d9e8cd',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:07',NULL,'2025-12-05 10:04:07',NULL,NULL),(44,NULL,NULL,'4097fc9d66334971a20a3ce2a2a833ae',NULL,NULL,NULL,NULL,'2025-12-05 10:04:08',NULL,'2025-12-05 10:04:08',NULL,NULL),(45,NULL,'da84ba39d69d4f529b60d4290c55e1b1',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:08',NULL,'2025-12-05 10:04:08',NULL,NULL),(46,NULL,'a1558ad140444ae48b8fb7b77f877a4c',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:08',NULL,'2025-12-05 10:04:08',NULL,NULL),(47,NULL,'0bc4662adf3849c382b362646459d925',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:08',NULL,'2025-12-05 10:04:08',NULL,NULL),(48,NULL,NULL,'2c6f1401ddfc47149cf73d0c12601902',NULL,NULL,NULL,NULL,'2025-12-05 10:04:08',NULL,'2025-12-05 10:04:08',NULL,NULL),(49,NULL,NULL,'224b9eac631f4e5fae2fa2b303fe4b82',NULL,NULL,NULL,NULL,'2025-12-05 10:04:09',NULL,'2025-12-05 10:04:09',NULL,NULL),(50,NULL,NULL,'f4e387d9289c4cbbb9f60bc8a0bfef5f',NULL,NULL,NULL,NULL,'2025-12-05 10:04:09',NULL,'2025-12-05 10:04:09',NULL,NULL),(51,NULL,NULL,'7b57593a3b494752aab63a9813fd49c3',NULL,NULL,NULL,NULL,'2025-12-05 10:04:09',NULL,'2025-12-05 10:04:09',NULL,NULL),(52,NULL,'9f060fa3607042ca984753cffcea33ff',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:09',NULL,'2025-12-05 10:04:09',NULL,NULL),(53,NULL,'e583c8357a6a4629a18a38119a3eef61',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:09',NULL,'2025-12-05 10:04:09',NULL,NULL),(54,NULL,'2c9a8637aedf4baa815a21c9e4c39749',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:10',NULL,'2025-12-05 10:04:10',NULL,NULL),(55,NULL,'6e541cf698904abba327209fc41468f6',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:10',NULL,'2025-12-05 10:04:10',NULL,NULL),(56,NULL,'36b70deee8fe46d688d090f9b89f9bbc',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:11',NULL,'2025-12-05 10:04:11',NULL,NULL),(57,NULL,'eb2a21013c9d4249af9763f11ecfa48b',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:11',NULL,'2025-12-05 10:04:11',NULL,NULL),(58,NULL,NULL,'90e754cfb9fc45ca8280ed8b0108c6b6',NULL,NULL,NULL,NULL,'2025-12-05 10:04:12',NULL,'2025-12-05 10:04:12',NULL,NULL),(59,NULL,NULL,'37c44594c70f4a1faf5563d805a302ed',NULL,NULL,NULL,NULL,'2025-12-05 10:04:12',NULL,'2025-12-05 10:04:12',NULL,NULL),(60,NULL,NULL,'1f5c8dcf10f44da98261e293763719c3',NULL,NULL,NULL,NULL,'2025-12-05 10:04:12',NULL,'2025-12-05 10:04:12',NULL,NULL),(61,NULL,NULL,'b14023c557644f589f2ac7dc7dd9d629',NULL,NULL,NULL,NULL,'2025-12-05 10:04:12',NULL,'2025-12-05 10:04:12',NULL,NULL),(62,NULL,NULL,'948099b5b0484000b76e61b4ad4bd942',NULL,NULL,NULL,NULL,'2025-12-05 10:04:13',NULL,'2025-12-05 10:04:13',NULL,NULL),(63,NULL,NULL,'c678363575204f1fa49e601f4ee25303',NULL,NULL,NULL,NULL,'2025-12-05 10:04:14',NULL,'2025-12-05 10:04:14',NULL,NULL),(64,NULL,'40505b57c8124311818edbe412f34595',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:14',NULL,'2025-12-05 10:04:14',NULL,NULL),(65,NULL,'f477ea3e503348f587ea0179aa8332f9',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:14',NULL,'2025-12-05 10:04:14',NULL,NULL),(66,NULL,'f84850cad56449c387f9dc658aa59a97',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:15',NULL,'2025-12-05 10:04:15',NULL,NULL),(67,NULL,'fa0e5c4bf61c492b86ba2f97db8c53f3',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:15',NULL,'2025-12-05 10:04:15',NULL,NULL),(68,NULL,'6eb7c020f5464f2182471341c945d24d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:15',NULL,'2025-12-05 10:04:15',NULL,NULL),(69,NULL,NULL,'36b7ed2b62cd4316971ea1f3060e13a2',NULL,NULL,NULL,NULL,'2025-12-05 10:04:16',NULL,'2025-12-05 10:04:16',NULL,NULL),(70,NULL,NULL,'e267a2db57bc421f93081d82160e9843',NULL,NULL,NULL,NULL,'2025-12-05 10:04:16',NULL,'2025-12-05 10:04:16',NULL,NULL),(71,NULL,NULL,'25ba95494c074cac8353d4797a10da7f',NULL,NULL,NULL,NULL,'2025-12-05 10:04:16',NULL,'2025-12-05 10:04:16',NULL,NULL),(72,NULL,NULL,'6bda774d59174583bc7cef916815e8eb',NULL,NULL,NULL,NULL,'2025-12-05 10:04:16',NULL,'2025-12-05 10:04:16',NULL,NULL),(73,NULL,'f23d3d36ddfb4c638196d738be1cd113',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:17',NULL,'2025-12-05 10:04:17',NULL,NULL),(74,NULL,'fc77ab9178cc4398a57563138592113f',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:18',NULL,'2025-12-05 10:04:18',NULL,NULL),(75,NULL,'431537df6f4842b6b9ae83e244296b32',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:18',NULL,'2025-12-05 10:04:18',NULL,NULL),(76,NULL,NULL,'1f4b7ef5de6f483b9cf737d807cb1a04',NULL,NULL,NULL,NULL,'2025-12-05 10:04:19',NULL,'2025-12-05 10:04:19',NULL,NULL),(77,NULL,NULL,'af221455170f42fbb66b37d7b57049e4',NULL,NULL,NULL,NULL,'2025-12-05 10:04:19',NULL,'2025-12-05 10:04:19',NULL,NULL),(78,NULL,'7aeb439f5e524ddba354214bcfc4b174',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:19',NULL,'2025-12-05 10:04:19',NULL,NULL),(79,NULL,'29f3aaf87b7142e5a34d42bfff697113',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:20',NULL,'2025-12-05 10:04:20',NULL,NULL),(80,NULL,'90924d72587f476b8756d8ce9fa4cdc3',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:21',NULL,'2025-12-05 10:04:21',NULL,NULL),(81,NULL,NULL,'d066b407726845a889ed56be176ac50e',NULL,NULL,NULL,NULL,'2025-12-05 10:04:21',NULL,'2025-12-05 10:04:21',NULL,NULL),(82,NULL,NULL,'5d0bd9867c724f6cbafa2fdb303b2792',NULL,NULL,NULL,NULL,'2025-12-05 10:04:22',NULL,'2025-12-05 10:04:22',NULL,NULL),(83,NULL,NULL,'8d3d1391dd124473a12e7b4966886bc3',NULL,NULL,NULL,NULL,'2025-12-05 10:04:22',NULL,'2025-12-05 10:04:22',NULL,NULL),(84,NULL,'c91ad1dc6fc6411eb44a8ceef643895a',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:22',NULL,'2025-12-05 10:04:22',NULL,NULL),(85,NULL,NULL,'8542c233ac4e44dfb795096e131942e3',NULL,NULL,NULL,NULL,'2025-12-05 10:04:22',NULL,'2025-12-05 10:04:22',NULL,NULL),(86,NULL,NULL,'82ad0258cf6f45c2a192343e31ec91e2',NULL,NULL,NULL,NULL,'2025-12-05 10:04:22',NULL,'2025-12-05 10:04:22',NULL,NULL),(87,NULL,NULL,'e90c01d00f37438183ba879fa4c3f2c4',NULL,NULL,NULL,NULL,'2025-12-05 10:04:22',NULL,'2025-12-05 10:04:22',NULL,NULL),(88,NULL,'a60b0a0da373432aa4ddf26acf291bff',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:23',NULL,'2025-12-05 10:04:23',NULL,NULL),(89,NULL,'e823e38451734f2682465bd48e4a7e88',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:24',NULL,'2025-12-05 10:04:24',NULL,NULL),(90,NULL,'d351c8b4db084a8f8b09c1cee02c5abe',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:24',NULL,'2025-12-05 10:04:24',NULL,NULL),(91,NULL,'0c55d2b746474f15943a3a55f98ed060',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:24',NULL,'2025-12-05 10:04:24',NULL,NULL),(92,NULL,'a78f13927a0945809589a30cd90644db',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:25',NULL,'2025-12-05 10:04:25',NULL,NULL),(93,NULL,'92bcc28f02be4f009ae01b65aa9fde6b',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:25',NULL,'2025-12-05 10:04:25',NULL,NULL),(94,NULL,NULL,'e703ddf39af24756a7aedec3eaf7b7bd',NULL,NULL,NULL,NULL,'2025-12-05 10:04:28',NULL,'2025-12-05 10:04:28',NULL,NULL),(95,NULL,NULL,'f682095f2f9b41db9a6da4820bdb4c90',NULL,NULL,NULL,NULL,'2025-12-05 10:04:28',NULL,'2025-12-05 10:04:28',NULL,NULL),(96,NULL,NULL,'fe1a8c73104241d098df4d96fb10c21b',NULL,NULL,NULL,NULL,'2025-12-05 10:04:28',NULL,'2025-12-05 10:04:28',NULL,NULL),(97,NULL,NULL,'729db7ae90aa46b4b55a695c61829657',NULL,NULL,NULL,NULL,'2025-12-05 10:04:28',NULL,'2025-12-05 10:04:28',NULL,NULL),(98,NULL,'2492793a77894d2b9edd23f26cbebb8f',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:30',NULL,'2025-12-05 10:04:30',NULL,NULL),(99,NULL,'c75e259a61c849c485234bd7bbd88f5d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:30',NULL,'2025-12-05 10:04:30',NULL,NULL),(100,NULL,'e57ab303668445fc9e1fbbe0e24d7589',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:30',NULL,'2025-12-05 10:04:30',NULL,NULL),(101,NULL,'cec9388621b141b999273cf5779c8d2f',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:31',NULL,'2025-12-05 10:04:31',NULL,NULL),(102,NULL,NULL,'b9c1a8fe3b5b401fb85fdf1ca8009037',NULL,NULL,NULL,NULL,'2025-12-05 10:04:35',NULL,'2025-12-05 10:04:35',NULL,NULL),(103,NULL,NULL,'65298a950b264a1ab3982c460bfe22dc',NULL,NULL,NULL,NULL,'2025-12-05 10:04:35',NULL,'2025-12-05 10:04:35',NULL,NULL),(104,NULL,NULL,'a4c52161fc7544fd93a0eabe720a548b',NULL,NULL,NULL,NULL,'2025-12-05 10:04:36',NULL,'2025-12-05 10:04:36',NULL,NULL),(105,NULL,NULL,'2a91e3d3334045ce92af09e35ad0423e',NULL,NULL,NULL,NULL,'2025-12-05 10:04:37',NULL,'2025-12-05 10:04:37',NULL,NULL),(106,NULL,'a48c4abbb9df4e3eb57f7ff549c80030',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:41',NULL,'2025-12-05 10:04:41',NULL,NULL),(107,NULL,'38dd6866966e43c5a13993b02d9a69b8',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:41',NULL,'2025-12-05 10:04:41',NULL,NULL),(108,NULL,'8dc90b12f7fc48c88758be6057c2c8f2',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:43',NULL,'2025-12-05 10:04:43',NULL,NULL),(109,NULL,'5a0dedf7653a468b9c2a18edc01474b5',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:44',NULL,'2025-12-05 10:04:44',NULL,NULL),(110,NULL,'17df5e6092984643be01a40debd99f98',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:47',NULL,'2025-12-05 10:04:47',NULL,NULL),(111,NULL,'a2c33ad2a4ab4f05bf3971edfc2b81ad',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:48',NULL,'2025-12-05 10:04:48',NULL,NULL),(112,NULL,'f97fd971440148e782490c2f601e3963',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:48',NULL,'2025-12-05 10:04:48',NULL,NULL),(113,NULL,NULL,'5a35653f27514b91ac97fafed73955cf',NULL,NULL,NULL,NULL,'2025-12-05 10:04:48',NULL,'2025-12-05 10:04:48',NULL,NULL),(114,NULL,'f8464c89453d477ea3650d80049b1c1e',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:49',NULL,'2025-12-05 10:04:49',NULL,NULL),(115,NULL,NULL,'61ee62b8d12949b687713c9a7e87ad55',NULL,NULL,NULL,NULL,'2025-12-05 10:04:49',NULL,'2025-12-05 10:04:49',NULL,NULL),(116,NULL,NULL,'3507ca54398e4160bc037aef21ae6495',NULL,NULL,NULL,NULL,'2025-12-05 10:04:49',NULL,'2025-12-05 10:04:49',NULL,NULL),(117,NULL,NULL,'530ef3720163491da30409bd770d5e7b',NULL,NULL,NULL,NULL,'2025-12-05 10:04:51',NULL,'2025-12-05 10:04:51',NULL,NULL),(118,NULL,'ef5ed654cd7b4f96b8295c2e76d3b3e2',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:51',NULL,'2025-12-05 10:04:51',NULL,NULL),(119,NULL,NULL,'05c9c87f29ac45ceb242e319d4eebceb',NULL,NULL,NULL,NULL,'2025-12-05 10:04:51',NULL,'2025-12-05 10:04:51',NULL,NULL),(120,NULL,NULL,'69bb148bb04f4d448f73830131bab155',NULL,NULL,NULL,NULL,'2025-12-05 10:04:51',NULL,'2025-12-05 10:04:51',NULL,NULL),(121,NULL,'96bbd5b75a6740caa6b4fe4f3e411f59',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:51',NULL,'2025-12-05 10:04:51',NULL,NULL),(122,NULL,'6f96d6a5e3e7491dab179f44b3373166',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:53',NULL,'2025-12-05 10:04:53',NULL,NULL),(123,NULL,'b0652216e59d43b7922181061dbd3038',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:54',NULL,'2025-12-05 10:04:54',NULL,NULL),(124,NULL,'94d733ceaa744d3a8ab76da583edf9a2',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:04:54',NULL,'2025-12-05 10:04:54',NULL,NULL),(125,NULL,NULL,'8123db36e5c0431c8889d98354ce6a77',NULL,NULL,NULL,NULL,'2025-12-05 10:04:58',NULL,'2025-12-05 10:04:58',NULL,NULL),(126,NULL,NULL,'f5194c4751fc40bda2a02deac61f3539',NULL,NULL,NULL,NULL,'2025-12-05 10:04:59',NULL,'2025-12-05 10:04:59',NULL,NULL),(127,NULL,'a1e098340275469c9b1f25f0ab00ce27',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:00',NULL,'2025-12-05 10:05:00',NULL,NULL),(128,NULL,NULL,'1609f2dba1144b1c91295eec36e1a2c6',NULL,NULL,NULL,NULL,'2025-12-05 10:05:02',NULL,'2025-12-05 10:05:02',NULL,NULL),(129,NULL,NULL,'ccaf6dcc13d0443183190744ec47eb2e',NULL,NULL,NULL,NULL,'2025-12-05 10:05:02',NULL,'2025-12-05 10:05:02',NULL,NULL),(130,NULL,'ec6924637dd04ffea8583f16ee82aa5d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:02',NULL,'2025-12-05 10:05:02',NULL,NULL),(131,NULL,'386dbaaf39f7443d9b1281b41244505b',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:04',NULL,'2025-12-05 10:05:04',NULL,NULL),(132,NULL,NULL,'d8aa692fcb7347c19d009fa0315c11d2',NULL,NULL,NULL,NULL,'2025-12-05 10:05:04',NULL,'2025-12-05 10:05:04',NULL,NULL),(133,NULL,NULL,'332193d57d0f40b4a4331c53909cd01e',NULL,NULL,NULL,NULL,'2025-12-05 10:05:04',NULL,'2025-12-05 10:05:04',NULL,NULL),(134,NULL,'ce7126fd50064118bc1bd44a9cf7cb38',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:05',NULL,'2025-12-05 10:05:05',NULL,NULL),(135,NULL,'38ca44ea29964cdc953c4acef5715d76',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:05',NULL,'2025-12-05 10:05:05',NULL,NULL),(136,NULL,'8c786ab49bfb47da817da4418860f39f',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:05',NULL,'2025-12-05 10:05:05',NULL,NULL),(137,NULL,NULL,'b79d9802058b4c389d24fbf2f02effa1',NULL,NULL,NULL,NULL,'2025-12-05 10:05:09',NULL,'2025-12-05 10:05:09',NULL,NULL),(138,NULL,NULL,'28857b10cac0465589e8db5f5a528b00',NULL,NULL,NULL,NULL,'2025-12-05 10:05:09',NULL,'2025-12-05 10:05:09',NULL,NULL),(139,NULL,NULL,'638c3e0d0fac4cffab190485b18e610b',NULL,NULL,NULL,NULL,'2025-12-05 10:05:09',NULL,'2025-12-05 10:05:09',NULL,NULL),(140,NULL,NULL,'812ffdac974e4f92887febb15738ae44',NULL,NULL,NULL,NULL,'2025-12-05 10:05:09',NULL,'2025-12-05 10:05:09',NULL,NULL),(141,NULL,NULL,'812ffdac974e4f92887febb15738ae44',NULL,NULL,NULL,NULL,'2025-12-05 10:05:09',NULL,'2025-12-05 10:05:09',NULL,NULL),(142,NULL,NULL,'638c3e0d0fac4cffab190485b18e610b',NULL,NULL,NULL,NULL,'2025-12-05 10:05:10',NULL,'2025-12-05 10:05:10',NULL,NULL),(143,NULL,NULL,'b79d9802058b4c389d24fbf2f02effa1',NULL,NULL,NULL,NULL,'2025-12-05 10:05:10',NULL,'2025-12-05 10:05:10',NULL,NULL),(144,NULL,'15fa4640f931434988fe20e30b6ef873',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:10',NULL,'2025-12-05 10:05:10',NULL,NULL),(145,NULL,NULL,'ed20e667263f47778f076e0c9210ed65',NULL,NULL,NULL,NULL,'2025-12-05 10:05:12',NULL,'2025-12-05 10:05:12',NULL,NULL),(146,NULL,'33df53defd284ddbb7d43c57b588de8a',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:13',NULL,'2025-12-05 10:05:13',NULL,NULL),(147,NULL,NULL,'c2f9bd1b9f83427784bb6f20f4912087',NULL,NULL,NULL,NULL,'2025-12-05 10:05:13',NULL,'2025-12-05 10:05:13',NULL,NULL),(148,NULL,NULL,'391861de4abb4ae88ec4969b5cc06c4b',NULL,NULL,NULL,NULL,'2025-12-05 10:05:13',NULL,'2025-12-05 10:05:13',NULL,NULL),(149,NULL,NULL,'60697df46a7c4bf886e13efcc190abcb',NULL,NULL,NULL,NULL,'2025-12-05 10:05:14',NULL,'2025-12-05 10:05:14',NULL,NULL),(150,NULL,'1cfb50f369034d55be399f91566a2008',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:15',NULL,'2025-12-05 10:05:15',NULL,NULL),(151,NULL,'379fa07a966548cd8f7b3b1e15e85c3a',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:16',NULL,'2025-12-05 10:05:16',NULL,NULL),(152,NULL,'a2407a62f9d04fd2b3c7078f3e71112f',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:17',NULL,'2025-12-05 10:05:17',NULL,NULL),(153,NULL,NULL,'9f1f0c341d2748c8b9609a69dbdcb244',NULL,NULL,NULL,NULL,'2025-12-05 10:05:20',NULL,'2025-12-05 10:05:20',NULL,NULL),(154,NULL,'b3095cb2ad0541e09b0f786f7841a318',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:20',NULL,'2025-12-05 10:05:20',NULL,NULL),(155,NULL,NULL,'7722146b4ddd41d5a95c781941ed317a',NULL,NULL,NULL,NULL,'2025-12-05 10:05:20',NULL,'2025-12-05 10:05:20',NULL,NULL),(156,NULL,NULL,'d19cd3343698424081ce01d3dad6495c',NULL,NULL,NULL,NULL,'2025-12-05 10:05:20',NULL,'2025-12-05 10:05:20',NULL,NULL),(157,NULL,'754961899f0144f69f99e88ab21ea45b',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:21',NULL,'2025-12-05 10:05:21',NULL,NULL),(158,NULL,'c242ee34d3034190be149f78c5b693c7',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:23',NULL,'2025-12-05 10:05:23',NULL,NULL),(159,NULL,NULL,'07124b92d1374afca2e3b9d931ece1ab',NULL,NULL,NULL,NULL,'2025-12-05 10:05:24',NULL,'2025-12-05 10:05:24',NULL,NULL),(160,NULL,'2bb3e20d1c5d44cbbf60cf9e2ed422ec',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:25',NULL,'2025-12-05 10:05:25',NULL,NULL),(161,NULL,'88b8d58668d74ae6be23cf8c5a74b379',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:25',NULL,'2025-12-05 10:05:25',NULL,NULL),(162,NULL,NULL,'367eda9ce66347018a9bfbda32acf776',NULL,NULL,NULL,NULL,'2025-12-05 10:05:28',NULL,'2025-12-05 10:05:28',NULL,NULL),(163,NULL,'4197b45088fc48e1af1c0a8978c1662a',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:28',NULL,'2025-12-05 10:05:28',NULL,NULL),(164,NULL,'1ecc315e97c3404bbf0f5dc621e8f2fc',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:30',NULL,'2025-12-05 10:05:30',NULL,NULL),(165,NULL,'04eb1a02f2d648ac92831cd66b1d4ba8',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:30',NULL,'2025-12-05 10:05:30',NULL,NULL),(166,NULL,NULL,'44b829599cd0414f9c8a8364a333fdb2',NULL,NULL,NULL,NULL,'2025-12-05 10:05:30',NULL,'2025-12-05 10:05:30',NULL,NULL),(167,NULL,'5f8b54aeeb86449f85ff5ccb7b162ce7',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:30',NULL,'2025-12-05 10:05:30',NULL,NULL),(168,NULL,NULL,'ddd0705424f049f189088aa4bd5fb4c3',NULL,NULL,NULL,NULL,'2025-12-05 10:05:31',NULL,'2025-12-05 10:05:31',NULL,NULL),(169,NULL,NULL,'ddd0705424f049f189088aa4bd5fb4c3',NULL,NULL,NULL,NULL,'2025-12-05 10:05:33',NULL,'2025-12-05 10:05:33',NULL,NULL),(170,NULL,'a7de0cbdddd443679fe18d9e32d57d1a',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:34',NULL,'2025-12-05 10:05:34',NULL,NULL),(171,NULL,NULL,'b5ee3f32d11e4724a50738e68be898c1',NULL,NULL,NULL,NULL,'2025-12-05 10:05:34',NULL,'2025-12-05 10:05:34',NULL,NULL),(172,NULL,NULL,'7b8a52e487244ac7b587984563030944',NULL,NULL,NULL,NULL,'2025-12-05 10:05:35',NULL,'2025-12-05 10:05:35',NULL,NULL),(173,NULL,NULL,'c1c2604c528248518817794596fec0e1',NULL,NULL,NULL,NULL,'2025-12-05 10:05:35',NULL,'2025-12-05 10:05:35',NULL,NULL),(174,NULL,NULL,'21c29f3a56e54486b61ecc72cb35cc3e',NULL,NULL,NULL,NULL,'2025-12-05 10:05:36',NULL,'2025-12-05 10:05:36',NULL,NULL),(175,NULL,NULL,'731bf35b065f4cfeb76a2066c3055e96',NULL,NULL,NULL,NULL,'2025-12-05 10:05:36',NULL,'2025-12-05 10:05:36',NULL,NULL),(176,NULL,'20962142d2e746b787bc5ad447228e26',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:38',NULL,'2025-12-05 10:05:38',NULL,NULL),(177,NULL,'1b63f7777dfa40c1bfc42162c9fd676f',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:39',NULL,'2025-12-05 10:05:39',NULL,NULL),(178,NULL,'a92114432e9e4607b371a9691b9f898d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:40',NULL,'2025-12-05 10:05:40',NULL,NULL),(179,NULL,'86cb8d3b471543839983316ef2de7b3f',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:41',NULL,'2025-12-05 10:05:41',NULL,NULL),(180,NULL,NULL,'afc59c7134554d9a9a33b534d5a24913',NULL,NULL,NULL,NULL,'2025-12-05 10:05:41',NULL,'2025-12-05 10:05:41',NULL,NULL),(181,NULL,'70b1a86dcef64e6ebbe96bd40de85c61',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:41',NULL,'2025-12-05 10:05:41',NULL,NULL),(182,NULL,NULL,'bf3cec97ca1a4da8affa971dee7dfb88',NULL,NULL,NULL,NULL,'2025-12-05 10:05:42',NULL,'2025-12-05 10:05:42',NULL,NULL),(183,NULL,NULL,'8ffd2abb265d4004bb9d07e2aa7d1938',NULL,NULL,NULL,NULL,'2025-12-05 10:05:43',NULL,'2025-12-05 10:05:43',NULL,NULL),(184,NULL,'22077dbb8c5b49be9a826212b0ae2b96',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:44',NULL,'2025-12-05 10:05:44',NULL,NULL),(185,NULL,NULL,'7ebece06eef748d5bb5faadcff039907',NULL,NULL,NULL,NULL,'2025-12-05 10:05:44',NULL,'2025-12-05 10:05:44',NULL,NULL),(186,NULL,NULL,'6efe8e77fd6545a5be3b37e563a7fa76',NULL,NULL,NULL,NULL,'2025-12-05 10:05:45',NULL,'2025-12-05 10:05:45',NULL,NULL),(187,NULL,'24c8c81238cc4428a12edd18ad90af3d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:46',NULL,'2025-12-05 10:05:46',NULL,NULL),(188,NULL,NULL,'a2c4edfb1bcf45edae646b564beed354',NULL,NULL,NULL,NULL,'2025-12-05 10:05:46',NULL,'2025-12-05 10:05:46',NULL,NULL),(189,NULL,NULL,'b4dbb02c460346b7a94858a3c61807d2',NULL,NULL,NULL,NULL,'2025-12-05 10:05:47',NULL,'2025-12-05 10:05:47',NULL,NULL),(190,NULL,'f05dc3e5cc8f492e8ef53df892250a01',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:47',NULL,'2025-12-05 10:05:47',NULL,NULL),(191,NULL,NULL,'bd07e165b17b4f429d4e982a8f898590',NULL,NULL,NULL,NULL,'2025-12-05 10:05:47',NULL,'2025-12-05 10:05:47',NULL,NULL),(192,NULL,'ea5f55728e054cc3a00ccdfa66531a2e',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:48',NULL,'2025-12-05 10:05:48',NULL,NULL),(193,NULL,'b713d586a6e5430583fc1d9da5dbdcad',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:49',NULL,'2025-12-05 10:05:49',NULL,NULL),(194,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:49',NULL,'2025-12-05 10:05:49','u2_bYJm3RMyossmfHNe1-A',NULL),(195,NULL,'7403a34a16334f73a5f09e4af0ddb8af',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:49',NULL,'2025-12-05 10:05:49',NULL,NULL),(196,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:49',NULL,'2025-12-05 10:05:49','YkPSoDnJTciHRuZ8TLaenA',NULL),(197,NULL,'aedae07ea6264f4eae2c933bab033469',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:49',NULL,'2025-12-05 10:05:49',NULL,NULL),(198,NULL,NULL,'f68aa1391a744a7d94a710fee0ca382e',NULL,NULL,NULL,NULL,'2025-12-05 10:05:50',NULL,'2025-12-05 10:05:50',NULL,NULL),(199,NULL,NULL,'7ee4999d08044f63bf075e92f0ca5d11',NULL,NULL,NULL,NULL,'2025-12-05 10:05:51',NULL,'2025-12-05 10:05:51',NULL,NULL),(200,NULL,'41095831ac6247b0a5ea030490af998f',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:51',NULL,'2025-12-05 10:05:51',NULL,NULL),(201,NULL,'a0b785fbbd7747b79900cd67174918f1',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:52',NULL,'2025-12-05 10:05:52',NULL,NULL),(202,NULL,NULL,'1323f6711d7e4ee9a4e0cb181ce6cc12',NULL,NULL,NULL,NULL,'2025-12-05 10:05:54',NULL,'2025-12-05 10:05:54',NULL,NULL),(203,NULL,NULL,'9f7345c9119f469e9da2826f2afea07b',NULL,NULL,NULL,NULL,'2025-12-05 10:05:54',NULL,'2025-12-05 10:05:54',NULL,NULL),(204,NULL,NULL,'f69a7538f6724dfdb189ab5970366432',NULL,NULL,NULL,NULL,'2025-12-05 10:05:54',NULL,'2025-12-05 10:05:54',NULL,NULL),(205,NULL,NULL,'df522977521b495a9d83fb0fc75c609d',NULL,NULL,NULL,NULL,'2025-12-05 10:05:54',NULL,'2025-12-05 10:05:54',NULL,NULL),(206,NULL,'13cfc29793094d7f9f7d9b430f684eb5',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:55',NULL,'2025-12-05 10:05:55',NULL,NULL),(207,NULL,NULL,'ada795101f10475cb06edb0246186fe6',NULL,NULL,NULL,NULL,'2025-12-05 10:05:55',NULL,'2025-12-05 10:05:55',NULL,NULL),(208,NULL,'768e82425be14388882c73abe888ea7a',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:55',NULL,'2025-12-05 10:05:55',NULL,NULL),(209,NULL,'37a156b14833479c93701f68cad7fadb',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:55',NULL,'2025-12-05 10:05:55',NULL,NULL),(210,NULL,NULL,'2056b572a20e4d3599165d978ce3e18f',NULL,NULL,NULL,NULL,'2025-12-05 10:05:55',NULL,'2025-12-05 10:05:55',NULL,NULL),(211,NULL,NULL,'84baa5beb45a488499c7628e5fd84911',NULL,NULL,NULL,NULL,'2025-12-05 10:05:56',NULL,'2025-12-05 10:05:56',NULL,NULL),(212,NULL,'04ea809f7bf84355ad0b761be5bcf717',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:56',NULL,'2025-12-05 10:05:56',NULL,NULL),(213,NULL,NULL,'2c3804d65b904456b1615255e646a353',NULL,NULL,NULL,NULL,'2025-12-05 10:05:57',NULL,'2025-12-05 10:05:57',NULL,NULL),(214,NULL,NULL,'7cfac292f5a44ba4bfa537479c6a2cc5',NULL,NULL,NULL,NULL,'2025-12-05 10:05:57',NULL,'2025-12-05 10:05:57',NULL,NULL),(215,NULL,'adaef8e413724b23a22c75fedcac99ee',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:57',NULL,'2025-12-05 10:05:57',NULL,NULL),(216,NULL,NULL,'7dbd84753cc34311a16ba30887be4b38',NULL,NULL,NULL,NULL,'2025-12-05 10:05:57',NULL,'2025-12-05 10:05:57',NULL,NULL),(217,NULL,'1e1bf710e3e34f87981e7550f3cb899f',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:57',NULL,'2025-12-05 10:05:57',NULL,NULL),(218,NULL,NULL,'3ebfd48d17714e29bb9d74731f7e5b38',NULL,NULL,NULL,NULL,'2025-12-05 10:05:57',NULL,'2025-12-05 10:05:57',NULL,NULL),(219,NULL,'656870644d424f7f85eb780b23efae15',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:58',NULL,'2025-12-05 10:05:58',NULL,NULL),(220,NULL,'9cf693f68af84b1c914eb01a35a9f072',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:58',NULL,'2025-12-05 10:05:58',NULL,NULL),(221,NULL,'8021425a1d1244788317e3a62639660b',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:59',NULL,'2025-12-05 10:05:59',NULL,NULL),(222,NULL,'6eb2c4a90c6e43ed9d82a9d380be4278',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:59',NULL,'2025-12-05 10:05:59',NULL,NULL),(223,NULL,'c5f7af554c09472ab3fd27dd1c35c543',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:59',NULL,'2025-12-05 10:05:59',NULL,NULL),(224,NULL,'d1285e7faf88409cbd39df0510bc1ac7',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:59',NULL,'2025-12-05 10:05:59',NULL,NULL),(225,NULL,NULL,'e1db1dfe7f944849b497c261491855d1',NULL,NULL,NULL,NULL,'2025-12-05 10:05:59',NULL,'2025-12-05 10:05:59',NULL,NULL),(226,NULL,'a9b8ae2ff8fc42959dc64d209d5490df',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:05:59',NULL,'2025-12-05 10:05:59',NULL,NULL),(227,NULL,NULL,'7de5200ccbd14ec7979d5b3e50147403',NULL,NULL,NULL,NULL,'2025-12-05 10:05:59',NULL,'2025-12-05 10:05:59',NULL,NULL),(228,NULL,'e02cb21bdf34412da9c9eb4e7e56a59b',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:00',NULL,'2025-12-05 10:06:00',NULL,NULL),(229,NULL,'6bd37ed3c8af43ca9b57df9e35d6f453',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:00',NULL,'2025-12-05 10:06:00',NULL,NULL),(230,NULL,'0d4809e883fa4372ab9dc6a954eb84bb',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:02',NULL,'2025-12-05 10:06:02',NULL,NULL),(231,NULL,'d244e8d01e53413a9bb1e968b77f3506',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:03',NULL,'2025-12-05 10:06:03',NULL,NULL),(232,NULL,NULL,'631dd2c0d11840bdbd27f1582d85d8f8',NULL,NULL,NULL,NULL,'2025-12-05 10:06:06',NULL,'2025-12-05 10:06:06',NULL,NULL),(233,NULL,NULL,'58e4db885b184f0587c2696ad279f865',NULL,NULL,NULL,NULL,'2025-12-05 10:06:06',NULL,'2025-12-05 10:06:06',NULL,NULL),(234,NULL,'784b8d7dafc84eb8ac5fe2c56cc5f693',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:07',NULL,'2025-12-05 10:06:07',NULL,NULL),(235,NULL,NULL,'117d4e4bd51148f98eb2d73157680411',NULL,NULL,NULL,NULL,'2025-12-05 10:06:07',NULL,'2025-12-05 10:06:07',NULL,NULL),(236,NULL,NULL,'aacb85b866964aa8b745264699aba9a6',NULL,NULL,NULL,NULL,'2025-12-05 10:06:07',NULL,'2025-12-05 10:06:07',NULL,NULL),(237,NULL,NULL,'9147a311b2c14af2b42a6de04db832ce',NULL,NULL,NULL,NULL,'2025-12-05 10:06:07',NULL,'2025-12-05 10:06:07',NULL,NULL),(238,NULL,'a19cc3191a00459596b6ae58c9b4f76e',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:08',NULL,'2025-12-05 10:06:08',NULL,NULL),(239,NULL,'1842e82ad0bc419583ce1bc66959ef18',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:09',NULL,'2025-12-05 10:06:09',NULL,NULL),(240,NULL,'0850324310d445cab884ce65c4cba575',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:09',NULL,'2025-12-05 10:06:09',NULL,NULL),(241,NULL,'22e1d0b7244b45e5b9b4ac184230456a',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:09',NULL,'2025-12-05 10:06:09',NULL,NULL),(242,NULL,NULL,'f8e67e3d452d43ec861c86614d051150',NULL,NULL,NULL,NULL,'2025-12-05 10:06:09',NULL,'2025-12-05 10:06:09',NULL,NULL),(243,NULL,NULL,'88019d7097f94ae892b47e2911b122c7',NULL,NULL,NULL,NULL,'2025-12-05 10:06:09',NULL,'2025-12-05 10:06:09',NULL,NULL),(244,NULL,'49921cb0eca64d96a7cca27e97c6d6d2',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:09',NULL,'2025-12-05 10:06:09',NULL,NULL),(245,NULL,NULL,'800c613a9392489a984d07b1d2f81d95',NULL,NULL,NULL,NULL,'2025-12-05 10:06:09',NULL,'2025-12-05 10:06:09',NULL,NULL),(246,NULL,NULL,'2f4b7f7a28b140c7bd3da6d12a8c57c4',NULL,NULL,NULL,NULL,'2025-12-05 10:06:09',NULL,'2025-12-05 10:06:09',NULL,NULL),(247,NULL,'c2265bc61c0b4a498c8e7680009a11d4',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:09',NULL,'2025-12-05 10:06:09',NULL,NULL),(248,NULL,'7111f959394f491dadc8fd1b07a8f235',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:10',NULL,'2025-12-05 10:06:10',NULL,NULL),(249,NULL,NULL,'a6738a9fc91847dd8f06082cede2ca95',NULL,NULL,NULL,NULL,'2025-12-05 10:06:10',NULL,'2025-12-05 10:06:10',NULL,NULL),(250,NULL,NULL,'3baab61d9dc74c51905b6e2b86ed08c4',NULL,NULL,NULL,NULL,'2025-12-05 10:06:10',NULL,'2025-12-05 10:06:10',NULL,NULL),(251,NULL,'56b197f4727a458a91ad7eaa87b0f418',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:11',NULL,'2025-12-05 10:06:11',NULL,NULL),(252,NULL,'c9ccd24c3bb344bdb2c0cdb6cad899f7',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:11',NULL,'2025-12-05 10:06:11',NULL,NULL),(253,NULL,NULL,'9f8aa1838ca64d868d3b2452d5977f64',NULL,NULL,NULL,NULL,'2025-12-05 10:06:11',NULL,'2025-12-05 10:06:11',NULL,NULL),(254,NULL,'76b4705f3a574ced8e3e1a74ccd1aea5',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:12',NULL,'2025-12-05 10:06:12',NULL,NULL),(255,NULL,'d35db7d5eb834c73946c19730749ac0d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:12',NULL,'2025-12-05 10:06:12',NULL,NULL),(256,NULL,'a06939069794496aa1dc89e35a71433d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:12',NULL,'2025-12-05 10:06:12',NULL,NULL),(257,NULL,'7dcf7b05a8e047119257fad756d162d3',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:12',NULL,'2025-12-05 10:06:12',NULL,NULL),(258,NULL,'0fcfb955a4eb4be0b4823729839618cf',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:13',NULL,'2025-12-05 10:06:13',NULL,NULL),(259,NULL,NULL,'77e963b75cf046b3b9f22c9f173db6a9',NULL,NULL,NULL,NULL,'2025-12-05 10:06:13',NULL,'2025-12-05 10:06:13',NULL,NULL),(260,NULL,NULL,'30fcce209a9247438a53796e60eccd5c',NULL,NULL,NULL,NULL,'2025-12-05 10:06:14',NULL,'2025-12-05 10:06:14',NULL,NULL),(261,NULL,NULL,'53a8a39be4e44a42ba2e88ad1444d0e8',NULL,NULL,NULL,NULL,'2025-12-05 10:06:14',NULL,'2025-12-05 10:06:14',NULL,NULL),(262,NULL,NULL,'4e7660619fe54b10a106d40c2a4380e8',NULL,NULL,NULL,NULL,'2025-12-05 10:06:15',NULL,'2025-12-05 10:06:15',NULL,NULL),(263,NULL,'6ce13953cb1d456b9b8bbb97ea8544cf',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:18',NULL,'2025-12-05 10:06:18',NULL,NULL),(264,NULL,NULL,'3a7cfbfa5d1a48768135519c95476235',NULL,NULL,NULL,NULL,'2025-12-05 10:06:19',NULL,'2025-12-05 10:06:19',NULL,NULL),(265,NULL,'1000691bdafa4cc88de0c7f6413cbb74',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:19',NULL,'2025-12-05 10:06:19',NULL,NULL),(266,NULL,NULL,'961e8286338a4bcd9ab6a79700719709',NULL,NULL,NULL,NULL,'2025-12-05 10:06:20',NULL,'2025-12-05 10:06:20',NULL,NULL),(267,NULL,'cc2ea120e002489fbce17ff19dda8bd3',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:20',NULL,'2025-12-05 10:06:20',NULL,NULL),(268,NULL,'ae87873711ec429abf13eaf56655672d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:20',NULL,'2025-12-05 10:06:20',NULL,NULL),(269,NULL,'32c9c681bb634a8fb7b52e6389adef3a',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:20',NULL,'2025-12-05 10:06:20',NULL,NULL),(270,NULL,NULL,'1c829a4a6db548ae8a6bd8ed5983a4f6',NULL,NULL,NULL,NULL,'2025-12-05 10:06:21',NULL,'2025-12-05 10:06:21',NULL,NULL),(271,NULL,NULL,'fc26939b53d044dc9be695ea23170f09',NULL,NULL,NULL,NULL,'2025-12-05 10:06:21',NULL,'2025-12-05 10:06:21',NULL,NULL),(272,NULL,NULL,'b9fef98ac7d949c09f3e0350788aead7',NULL,NULL,NULL,NULL,'2025-12-05 10:06:22',NULL,'2025-12-05 10:06:22',NULL,NULL),(273,NULL,NULL,'d03de64b5bf7406daaa0953afda4398f',NULL,NULL,NULL,NULL,'2025-12-05 10:06:22',NULL,'2025-12-05 10:06:22',NULL,NULL),(274,NULL,'62497d9edfb44cabb400792e4617d52d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:22',NULL,'2025-12-05 10:06:22',NULL,NULL),(275,NULL,'a52ef89bc3d84dd59d2ec5f9a16a62f8',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:23',NULL,'2025-12-05 10:06:23',NULL,NULL),(276,NULL,'a33163e66f404afcb363d3e43eca4ed0',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:24',NULL,'2025-12-05 10:06:24',NULL,NULL),(277,NULL,'13b89973b31f4a89a50bced53e0910fd',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:24',NULL,'2025-12-05 10:06:24',NULL,NULL),(278,NULL,'64ce110bc2604b84a8a0b95686a2ee40',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:24',NULL,'2025-12-05 10:06:24',NULL,NULL),(279,NULL,NULL,'83aebaf21dda489f98de1a34d484d648',NULL,NULL,NULL,NULL,'2025-12-05 10:06:25',NULL,'2025-12-05 10:06:25',NULL,NULL),(280,NULL,'0e67c68ab4ea4930b0967c6e83fe21c9',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:25',NULL,'2025-12-05 10:06:25',NULL,NULL),(281,NULL,NULL,'caadfe819a3c400f82f1e5150660182c',NULL,NULL,NULL,NULL,'2025-12-05 10:06:26',NULL,'2025-12-05 10:06:26',NULL,NULL),(282,NULL,'dafb7aa586e54a6fb766f294b7cada34',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:27',NULL,'2025-12-05 10:06:27',NULL,NULL),(283,NULL,NULL,'8821aa9bd22f4c6e993323f9f64d31a1',NULL,NULL,NULL,NULL,'2025-12-05 10:06:27',NULL,'2025-12-05 10:06:27',NULL,NULL),(284,NULL,'a5e423e05eb84045a5d63179380884e6',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:27',NULL,'2025-12-05 10:06:27',NULL,NULL),(285,NULL,NULL,'23460fb968794dbaa377533c8f983cb0',NULL,NULL,NULL,NULL,'2025-12-05 10:06:28',NULL,'2025-12-05 10:06:28',NULL,NULL),(286,NULL,NULL,'1d88dfc36c274fec9b8c09ad75d824ed',NULL,NULL,NULL,NULL,'2025-12-05 10:06:28',NULL,'2025-12-05 10:06:28',NULL,NULL),(287,NULL,'a0588d317f184bd5b4c00fddf19c9c64',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:29',NULL,'2025-12-05 10:06:29',NULL,NULL),(288,NULL,'cc618f14b8c24c2390b9f8842855b691',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:30',NULL,'2025-12-05 10:06:30',NULL,NULL),(289,NULL,NULL,'d991f245fb064f1da1cd9e87c753de6c',NULL,NULL,NULL,NULL,'2025-12-05 10:06:30',NULL,'2025-12-05 10:06:30',NULL,NULL),(290,NULL,NULL,'335cd8deb01a4308a051ee65d987d7d5',NULL,NULL,NULL,NULL,'2025-12-05 10:06:30',NULL,'2025-12-05 10:06:30',NULL,NULL),(291,NULL,NULL,'4eb51097bb71447eac5a41e7591d714e',NULL,NULL,NULL,NULL,'2025-12-05 10:06:30',NULL,'2025-12-05 10:06:30',NULL,NULL),(292,NULL,'e749dcbe13964d069b40045e4002702e',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:32',NULL,'2025-12-05 10:06:32',NULL,NULL),(293,NULL,'b8acd29b55e34e8ea4c7e1f26e3cb6da',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:32',NULL,'2025-12-05 10:06:32',NULL,NULL),(294,NULL,NULL,'73dc30d0b7324a259ad9ced6868f5dca',NULL,NULL,NULL,NULL,'2025-12-05 10:06:32',NULL,'2025-12-05 10:06:32',NULL,NULL),(295,NULL,'251390d850b04341841292c4cade14c3',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:33',NULL,'2025-12-05 10:06:33',NULL,NULL),(296,NULL,NULL,'e58c8cb09e9a47bead8173d7e24e77d8',NULL,NULL,NULL,NULL,'2025-12-05 10:06:33',NULL,'2025-12-05 10:06:33',NULL,NULL),(297,NULL,NULL,'32c024ab2c954f8eab4242906932fc6d',NULL,NULL,NULL,NULL,'2025-12-05 10:06:34',NULL,'2025-12-05 10:06:34',NULL,NULL),(298,NULL,'b2380a26793d4925b5f5ab5cb3cb6951',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:34',NULL,'2025-12-05 10:06:34',NULL,NULL),(299,NULL,NULL,'5140bffb29da4048833ce1af2bc171bf',NULL,NULL,NULL,NULL,'2025-12-05 10:06:34',NULL,'2025-12-05 10:06:34',NULL,NULL),(300,NULL,NULL,'e4b9374626fb4c438f997665b7ba750a',NULL,NULL,NULL,NULL,'2025-12-05 10:06:35',NULL,'2025-12-05 10:06:35',NULL,NULL),(301,NULL,'b1d45d641901417d892ebd1fdf9b4f5f',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:35',NULL,'2025-12-05 10:06:35',NULL,NULL),(302,NULL,NULL,'73dc30d0b7324a259ad9ced6868f5dca',NULL,NULL,NULL,NULL,'2025-12-05 10:06:36',NULL,'2025-12-05 10:06:36',NULL,NULL),(303,NULL,NULL,'36b411565af540eeb10f3f484b87d948',NULL,NULL,NULL,NULL,'2025-12-05 10:06:37',NULL,'2025-12-05 10:06:37',NULL,NULL),(304,NULL,'6db8a21df3ce427fbfa3526ad8197c2b',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:37',NULL,'2025-12-05 10:06:37',NULL,NULL),(305,NULL,'5137c0925bf447fc90b9f14d68e1a877',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:39',NULL,'2025-12-05 10:06:39',NULL,NULL),(306,NULL,'48b95300e5a743358425135ffcc09f85',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:39',NULL,'2025-12-05 10:06:39',NULL,NULL),(307,NULL,'3393afdb373d48098b30addc792c4f96',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:39',NULL,'2025-12-05 10:06:39',NULL,NULL),(308,NULL,'540e96fa53a842c5a5285d412dbb117f',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:39',NULL,'2025-12-05 10:06:39',NULL,NULL),(309,NULL,'9b0fff2630ba47b5a0dab782a82c2214',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:40',NULL,'2025-12-05 10:06:40',NULL,NULL),(310,NULL,NULL,'d5a3e4458eb848de92db391482767dfd',NULL,NULL,NULL,NULL,'2025-12-05 10:06:40',NULL,'2025-12-05 10:06:40',NULL,NULL),(311,NULL,NULL,'c29aa2fc8533414b8a760b6189537d24',NULL,NULL,NULL,NULL,'2025-12-05 10:06:41',NULL,'2025-12-05 10:06:41',NULL,NULL),(312,NULL,NULL,'047e1e4235d24580a9e21d766be9d799',NULL,NULL,NULL,NULL,'2025-12-05 10:06:41',NULL,'2025-12-05 10:06:41',NULL,NULL),(313,NULL,'ed35fb6322cc47b68a879fefc1aa5169',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:42',NULL,'2025-12-05 10:06:42',NULL,NULL),(314,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:42',NULL,'2025-12-05 10:06:42','cECJAHyhS2epVjYSEvQvBg',NULL),(315,NULL,'91bca44f990746a3ab7b33d297a0ee36',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:43',NULL,'2025-12-05 10:06:43',NULL,NULL),(316,NULL,'ed82f6c4b9004446bdfe294513f42715',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:43',NULL,'2025-12-05 10:06:43',NULL,NULL),(317,NULL,NULL,'1ec0bcea750a437598ccaf7755704924',NULL,NULL,NULL,NULL,'2025-12-05 10:06:44',NULL,'2025-12-05 10:06:44',NULL,NULL),(318,NULL,NULL,'40de614617bf41459f03a76409833f07',NULL,NULL,NULL,NULL,'2025-12-05 10:06:44',NULL,'2025-12-05 10:06:44',NULL,NULL),(319,NULL,NULL,'7f79d8772d554ea6b89fe8e8bb25efeb',NULL,NULL,NULL,NULL,'2025-12-05 10:06:44',NULL,'2025-12-05 10:06:44',NULL,NULL),(320,NULL,NULL,'1fec65dd9c6e4525ad87a68db4430919',NULL,NULL,NULL,NULL,'2025-12-05 10:06:45',NULL,'2025-12-05 10:06:45',NULL,NULL),(321,NULL,NULL,'73dc30d0b7324a259ad9ced6868f5dca',NULL,NULL,NULL,NULL,'2025-12-05 10:06:45',NULL,'2025-12-05 10:06:45',NULL,NULL),(322,NULL,'d09b04de19f84619845f87fd54bda50c',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:45',NULL,'2025-12-05 10:06:45',NULL,NULL),(323,NULL,'6a093c468f2e4906ac7742fa1a1152e5',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:46',NULL,'2025-12-05 10:06:46',NULL,NULL),(324,NULL,'0159563ba25d406a8b9b7b69482bd4df',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:47',NULL,'2025-12-05 10:06:47',NULL,NULL),(325,NULL,'b769cb1a593c4758a05183ed61e7c8d8',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:48',NULL,'2025-12-05 10:06:48',NULL,NULL),(326,NULL,'4bac7ad240f148f1bdd389c735f14da6',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:48',NULL,'2025-12-05 10:06:48',NULL,NULL),(327,NULL,'cf4f2b7191d148ab8c68d23f50cb4433',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:48',NULL,'2025-12-05 10:06:48',NULL,NULL),(328,NULL,NULL,'348a5cf0fec341fd8d673a2fe64a855a',NULL,NULL,NULL,NULL,'2025-12-05 10:06:48',NULL,'2025-12-05 10:06:48',NULL,NULL),(329,NULL,NULL,'85066bce78184a15ba955fbce317fc4d',NULL,NULL,NULL,NULL,'2025-12-05 10:06:48',NULL,'2025-12-05 10:06:48',NULL,NULL),(330,NULL,NULL,'ade19739a55c459180a2245d2aa837cf',NULL,NULL,NULL,NULL,'2025-12-05 10:06:48',NULL,'2025-12-05 10:06:48',NULL,NULL),(331,NULL,'b56bb63fac1149dd90331f94de840152',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:50',NULL,'2025-12-05 10:06:50',NULL,NULL),(332,NULL,'2d24085c7cc84058a1938572d9fee471',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:51',NULL,'2025-12-05 10:06:51',NULL,NULL),(333,NULL,'6de33bd5009e4d89a6e303cf685142f7',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:52',NULL,'2025-12-05 10:06:52',NULL,NULL),(334,NULL,'7463e247d82e4d8e93c9e1b5efc121e7',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:53',NULL,'2025-12-05 10:06:53',NULL,NULL),(335,NULL,'0dd25f8f1d274600bc7d4382b2bb2d13',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:06:54',NULL,'2025-12-05 10:06:54',NULL,NULL),(336,NULL,NULL,NULL,NULL,'ce627c75d8414cf7b599bc3e67c755be',NULL,NULL,'2025-12-05 10:06:59',NULL,'2025-12-05 10:06:59',NULL,NULL),(337,NULL,NULL,'62b64af6245e4bb88369ce642bfc10a2',NULL,NULL,NULL,NULL,'2025-12-05 10:07:00',NULL,'2025-12-05 10:07:00',NULL,NULL),(338,NULL,NULL,'ba802a00bb2e4b0c938a577df963a212',NULL,NULL,NULL,NULL,'2025-12-05 10:07:00',NULL,'2025-12-05 10:07:00',NULL,NULL),(339,NULL,'6d6626d603d34312b9aff4024f13d27c',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:01',NULL,'2025-12-05 10:07:01',NULL,NULL),(340,NULL,'923729c253424d61ae3e38f2b3b261a3',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:02',NULL,'2025-12-05 10:07:02',NULL,NULL),(341,NULL,'b538546819704c7ca2d1f8febd60abde',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:03',NULL,'2025-12-05 10:07:03',NULL,NULL),(342,NULL,NULL,NULL,NULL,'1930a47253ce4c8c88636663d1b59032',NULL,NULL,'2025-12-05 10:07:04',NULL,'2025-12-05 10:07:04',NULL,NULL),(343,NULL,'9ec2fbe21e1a45e5b2398679c8fcef89',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:04',NULL,'2025-12-05 10:07:04',NULL,NULL),(344,NULL,NULL,'f7b3f5ce48a04f94848332a15fcacfc3',NULL,NULL,NULL,NULL,'2025-12-05 10:07:04',NULL,'2025-12-05 10:07:04',NULL,NULL),(345,NULL,NULL,'e8d707afae0c473b8671387652b0ee14',NULL,NULL,NULL,NULL,'2025-12-05 10:07:05',NULL,'2025-12-05 10:07:05',NULL,NULL),(346,NULL,'e7dacf78bb63448fab0a63b13e3cbee5',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:05',NULL,'2025-12-05 10:07:05',NULL,NULL),(347,NULL,NULL,'1ac77399695145f4b401c88ed4229925',NULL,NULL,NULL,NULL,'2025-12-05 10:07:05',NULL,'2025-12-05 10:07:05',NULL,NULL),(348,NULL,'ae79bc62d86a492e8cda59f6b8938e47',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:05',NULL,'2025-12-05 10:07:05',NULL,NULL),(349,NULL,'dc4792a057da442a9eb5fce391fca25b',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:05',NULL,'2025-12-05 10:07:05',NULL,NULL),(350,NULL,NULL,'26066a119835466db353fbd62ae080ed',NULL,NULL,NULL,NULL,'2025-12-05 10:07:05',NULL,'2025-12-05 10:07:05',NULL,NULL),(351,NULL,NULL,'73a2e1174d0c4af38858d0c771d39825',NULL,NULL,NULL,NULL,'2025-12-05 10:07:06',NULL,'2025-12-05 10:07:06',NULL,NULL),(352,NULL,'03610b24fd9e462dbeaccd31f4832396',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:07',NULL,'2025-12-05 10:07:07',NULL,NULL),(353,NULL,NULL,NULL,NULL,'39c19c345aea42dbb16831ecff4aec54',NULL,NULL,'2025-12-05 10:07:08',NULL,'2025-12-05 10:07:08',NULL,NULL),(354,NULL,NULL,'086354ea74af4fcab0c9697cd30e01cc',NULL,NULL,NULL,NULL,'2025-12-05 10:07:09',NULL,'2025-12-05 10:07:09',NULL,NULL),(355,NULL,'b8245ba92a3b487abd797418e5023607',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:09',NULL,'2025-12-05 10:07:09',NULL,NULL),(356,NULL,NULL,'f39bfddf8790404981c1af94ba973d23',NULL,NULL,NULL,NULL,'2025-12-05 10:07:10',NULL,'2025-12-05 10:07:10',NULL,NULL),(357,NULL,'5a494907e6bd43baaa3e8994da4afef3',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:11',NULL,'2025-12-05 10:07:11',NULL,NULL),(358,NULL,NULL,'7ac7e3bc12a74298805028816ed3ad74',NULL,NULL,NULL,NULL,'2025-12-05 10:07:12',NULL,'2025-12-05 10:07:12',NULL,NULL),(359,NULL,'e37ff76c2e5e483fa95aaf009b5ff369',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:12',NULL,'2025-12-05 10:07:12',NULL,NULL),(360,NULL,'7bd96403b22346488780c759c8f2502c',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:14',NULL,'2025-12-05 10:07:14',NULL,NULL),(361,NULL,'a1e6af9d4a2142b6be591f0d16ea5c48',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:15',NULL,'2025-12-05 10:07:15',NULL,NULL),(362,NULL,NULL,NULL,NULL,'f5a6b65001f8445089ceeaec1334a036',NULL,NULL,'2025-12-05 10:07:16',NULL,'2025-12-05 10:07:16',NULL,NULL),(363,NULL,NULL,'b15f01cc62224b2892e28815472d6656',NULL,NULL,NULL,NULL,'2025-12-05 10:07:17',NULL,'2025-12-05 10:07:17',NULL,NULL),(364,NULL,NULL,'6ec08a2f37fc480a9f10f119483c1a9a',NULL,NULL,NULL,NULL,'2025-12-05 10:07:17',NULL,'2025-12-05 10:07:17',NULL,NULL),(365,NULL,NULL,'34e7706dca004916b4dc21ee97b92721',NULL,NULL,NULL,NULL,'2025-12-05 10:07:17',NULL,'2025-12-05 10:07:17',NULL,NULL),(366,NULL,'fb01f3dbe6b64117994493a61e528801',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:17',NULL,'2025-12-05 10:07:17',NULL,NULL),(367,NULL,'1d32e87601df423a8cce9cd945df205b',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:18',NULL,'2025-12-05 10:07:18',NULL,NULL),(368,NULL,NULL,'5c9c6e67d9f84c0fb4a51231511c60d6',NULL,NULL,NULL,NULL,'2025-12-05 10:07:18',NULL,'2025-12-05 10:07:18',NULL,NULL),(369,NULL,NULL,'3a4f54c3edad41ffa04c74df7db229c3',NULL,NULL,NULL,NULL,'2025-12-05 10:07:19',NULL,'2025-12-05 10:07:19',NULL,NULL),(370,NULL,'50771b4c128443a3b2365dd014698bb5',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:19',NULL,'2025-12-05 10:07:19',NULL,NULL),(371,NULL,NULL,'31292519fcae4f609099abad5313bb44',NULL,NULL,NULL,NULL,'2025-12-05 10:07:19',NULL,'2025-12-05 10:07:19',NULL,NULL),(372,NULL,NULL,NULL,NULL,'5df0e7baba2545a4a9f43a2980ab50fa',NULL,NULL,'2025-12-05 10:07:20',NULL,'2025-12-05 10:07:20',NULL,NULL),(373,NULL,'3442959191c74cf7aa3246302698f1be',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:21',NULL,'2025-12-05 10:07:21',NULL,NULL),(374,NULL,NULL,'39a285ce132b4bf787c6ae32146984b0',NULL,NULL,NULL,NULL,'2025-12-05 10:07:21',NULL,'2025-12-05 10:07:21',NULL,NULL),(375,NULL,'c92e0c9361a0481ebbe32cdeb6733c32',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:22',NULL,'2025-12-05 10:07:22',NULL,NULL),(376,NULL,NULL,'3fe10f4071aa4da9b901c4d77885d555',NULL,NULL,NULL,NULL,'2025-12-05 10:07:22',NULL,'2025-12-05 10:07:22',NULL,NULL),(377,NULL,'85613fbd174149f5827c25286d2e5c3d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:23',NULL,'2025-12-05 10:07:23',NULL,NULL),(378,NULL,NULL,'9431d220037c4b8ca095f6ca8de499c3',NULL,NULL,NULL,NULL,'2025-12-05 10:07:23',NULL,'2025-12-05 10:07:23',NULL,NULL),(379,NULL,NULL,NULL,NULL,NULL,'d03569e2e0314a0fa0a4e7cc27001216',NULL,'2025-12-05 10:07:24',NULL,'2025-12-05 10:07:24',NULL,NULL),(380,NULL,NULL,'43338753bf714dfa9a3bc2fff3640de1',NULL,NULL,NULL,NULL,'2025-12-05 10:07:24',NULL,'2025-12-05 10:07:24',NULL,NULL),(381,NULL,NULL,NULL,NULL,NULL,'66489538854c41f98e691c11d18f84cb',NULL,'2025-12-05 10:07:25',NULL,'2025-12-05 10:07:25',NULL,NULL),(382,NULL,NULL,'d793baf7e35c4490ac819ac7d8934693',NULL,NULL,NULL,NULL,'2025-12-05 10:07:25',NULL,'2025-12-05 10:07:25',NULL,NULL),(383,NULL,'8699ae616f714634bfb10f1859f11b96',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:25',NULL,'2025-12-05 10:07:25',NULL,NULL),(384,NULL,NULL,NULL,NULL,NULL,'8b7dac430b37411cbeb2200b8ffb5c7e',NULL,'2025-12-05 10:07:25',NULL,'2025-12-05 10:07:25',NULL,NULL),(385,NULL,NULL,NULL,NULL,NULL,'c45c7d0f2a384ff99a62253bacf69ec8',NULL,'2025-12-05 10:07:25',NULL,'2025-12-05 10:07:25',NULL,NULL),(386,NULL,NULL,NULL,NULL,NULL,'07edc16108374a12be8b8c780cad5364',NULL,'2025-12-05 10:07:25',NULL,'2025-12-05 10:07:25',NULL,NULL),(387,NULL,NULL,'7b9cba11369e4e37b4f4d2bfcf571180',NULL,NULL,NULL,NULL,'2025-12-05 10:07:26',NULL,'2025-12-05 10:07:26',NULL,NULL),(388,NULL,NULL,'3cbfff239dd8422ca246d69eb3775616',NULL,NULL,NULL,NULL,'2025-12-05 10:07:26',NULL,'2025-12-05 10:07:26',NULL,NULL),(389,NULL,'fb70512ba05e41a385adde38ada18f0d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:26',NULL,'2025-12-05 10:07:26',NULL,NULL),(390,NULL,'6b1ece0a97124ddfa8e078e11844fdc0',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:26',NULL,'2025-12-05 10:07:26',NULL,NULL),(391,NULL,NULL,'096de93086854e3cbb569b667f7e01d0',NULL,NULL,NULL,NULL,'2025-12-05 10:07:26',NULL,'2025-12-05 10:07:26',NULL,NULL),(392,NULL,'d7cdbf6b6f334c678d12e58e7e4bbb0d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:27',NULL,'2025-12-05 10:07:27',NULL,NULL),(393,NULL,'0cefdb91314945d68df9707c371a6860',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:27',NULL,'2025-12-05 10:07:27',NULL,NULL),(394,NULL,'bc5d113bc39e4d9b9f34d966a52332a4',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:28',NULL,'2025-12-05 10:07:28',NULL,NULL),(395,NULL,NULL,'ca8697ed6d3c45cfa1907082b4014530',NULL,NULL,NULL,NULL,'2025-12-05 10:07:29',NULL,'2025-12-05 10:07:29',NULL,NULL),(396,NULL,'5fe81df385ee443a84393675841090d3',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:30',NULL,'2025-12-05 10:07:30',NULL,NULL),(397,NULL,NULL,'d17d37d1ec46435f8ead9bc55e2844e5',NULL,NULL,NULL,NULL,'2025-12-05 10:07:31',NULL,'2025-12-05 10:07:31',NULL,NULL),(398,NULL,NULL,'bbea34a376c34d2c903b021a6573a96e',NULL,NULL,NULL,NULL,'2025-12-05 10:07:32',NULL,'2025-12-05 10:07:32',NULL,NULL),(399,NULL,'d59bd012b3594d9e8cde0b90707a900b',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:32',NULL,'2025-12-05 10:07:32',NULL,NULL),(400,NULL,'79252f535d43420fab3d1c5eddd3b8c3',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:34',NULL,'2025-12-05 10:07:34',NULL,NULL),(401,NULL,NULL,'691db712d75b41c68027f6e8577ac5b6',NULL,NULL,NULL,NULL,'2025-12-05 10:07:35',NULL,'2025-12-05 10:07:35',NULL,NULL),(402,NULL,'8132c5d1a47d4ef8bd84b98231330aa7',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:35',NULL,'2025-12-05 10:07:35',NULL,NULL),(403,NULL,'6d0dc32ceedc4912b94cf117306382f7',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:38',NULL,'2025-12-05 10:07:38',NULL,NULL),(404,NULL,NULL,'82cc091c5f7542e7b2984b470fa3bd79',NULL,NULL,NULL,NULL,'2025-12-05 10:07:38',NULL,'2025-12-05 10:07:38',NULL,NULL),(405,NULL,NULL,'e2225adab7b04ec6a92c7b4ca7f846a5',NULL,NULL,NULL,NULL,'2025-12-05 10:07:39',NULL,'2025-12-05 10:07:39',NULL,NULL),(406,NULL,NULL,'4482c5f661dc49b7a2b1e5db03420e42',NULL,NULL,NULL,NULL,'2025-12-05 10:07:39',NULL,'2025-12-05 10:07:39',NULL,NULL),(407,NULL,NULL,'238d6b68ed4e4855a97e75aa6cdc60ec',NULL,NULL,NULL,NULL,'2025-12-05 10:07:40',NULL,'2025-12-05 10:07:40',NULL,NULL),(408,NULL,'c27ae7f63e12428d815f11130bcb0aaf',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:43',NULL,'2025-12-05 10:07:43',NULL,NULL),(409,NULL,NULL,'92e431ee09214c5db669ff3ab171b4c7',NULL,NULL,NULL,NULL,'2025-12-05 10:07:43',NULL,'2025-12-05 10:07:43',NULL,NULL),(410,NULL,'2f018c7c46ff44789c49a6c2c93560a4',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:43',NULL,'2025-12-05 10:07:43',NULL,NULL),(411,NULL,NULL,'bac458c8241f486fb3440da08cf19f83',NULL,NULL,NULL,NULL,'2025-12-05 10:07:43',NULL,'2025-12-05 10:07:43',NULL,NULL),(412,NULL,'54e1b7c3b3c149cf9e52153b7a0eca19',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:43',NULL,'2025-12-05 10:07:43',NULL,NULL),(413,NULL,'be84a9e81c034b0ea4bca1b283fa6ad5',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:48',NULL,'2025-12-05 10:07:48',NULL,NULL),(414,NULL,'932a4e3df2b946028fcbc72883cde3a5',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:48',NULL,'2025-12-05 10:07:48',NULL,NULL),(415,NULL,NULL,'238d6b68ed4e4855a97e75aa6cdc60ec',NULL,NULL,NULL,NULL,'2025-12-05 10:07:48',NULL,'2025-12-05 10:07:48',NULL,NULL),(416,NULL,'261120ee820e406c8320e4406cbe5357',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:49',NULL,'2025-12-05 10:07:49',NULL,NULL),(417,NULL,'f664a60f4ef647eab06f6e8ca42506f5',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:49',NULL,'2025-12-05 10:07:49',NULL,NULL),(418,NULL,'6922ccbe11e24c128e6a6c8892a24d01',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:49',NULL,'2025-12-05 10:07:49',NULL,NULL),(419,NULL,NULL,'be8aee3e354249d4b776c63af2663f6f',NULL,NULL,NULL,NULL,'2025-12-05 10:07:50',NULL,'2025-12-05 10:07:50',NULL,NULL),(420,NULL,NULL,'621c22f152f1467f8b1710acac45bfae',NULL,NULL,NULL,NULL,'2025-12-05 10:07:50',NULL,'2025-12-05 10:07:50',NULL,NULL),(421,NULL,NULL,'34f9264f95504119a72e62fd79e1752a',NULL,NULL,NULL,NULL,'2025-12-05 10:07:50',NULL,'2025-12-05 10:07:50',NULL,NULL),(422,NULL,'86ac9f57d40442a890e06143be6f8d02',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:50',NULL,'2025-12-05 10:07:50',NULL,NULL),(423,NULL,NULL,'59c371efc1d74d51aeccaefb2b07d9b2',NULL,NULL,NULL,NULL,'2025-12-05 10:07:51',NULL,'2025-12-05 10:07:51',NULL,NULL),(424,NULL,'66d239f897344e32a45021afe789a344',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:51',NULL,'2025-12-05 10:07:51',NULL,NULL),(425,NULL,'ef9f13859bbf47a4a06c7f53a43a59ce',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:51',NULL,'2025-12-05 10:07:51',NULL,NULL),(426,NULL,NULL,'b0c050429eb341b7906aa9720ecbafb5',NULL,NULL,NULL,NULL,'2025-12-05 10:07:53',NULL,'2025-12-05 10:07:53',NULL,NULL),(427,NULL,'7ddc5c7d7fbc42c7b4c97bd7b3656bf3',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:53',NULL,'2025-12-05 10:07:53',NULL,NULL),(428,NULL,'43bb6837493c44d1b0194597cd1dfa97',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:54',NULL,'2025-12-05 10:07:54',NULL,NULL),(429,NULL,'ecd7e3be7b2b4f8c94aad5be3d61ccad',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:54',NULL,'2025-12-05 10:07:54',NULL,NULL),(430,NULL,NULL,'1398b2fb7a95476ea98d2c593381dcd7',NULL,NULL,NULL,NULL,'2025-12-05 10:07:54',NULL,'2025-12-05 10:07:54',NULL,NULL),(431,NULL,NULL,'3595c113c69d4f1e8815539b0fb497bc',NULL,NULL,NULL,NULL,'2025-12-05 10:07:55',NULL,'2025-12-05 10:07:55',NULL,NULL),(432,NULL,NULL,'9ebed44a56b34ad5ac2cb0877ee399ba',NULL,NULL,NULL,NULL,'2025-12-05 10:07:55',NULL,'2025-12-05 10:07:55',NULL,NULL),(433,NULL,'8a50663b2e204a8aad46985abfebcb86',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:56',NULL,'2025-12-05 10:07:56',NULL,NULL),(434,NULL,NULL,'c55a6251a89544ad9346cfa2047decc7',NULL,NULL,NULL,NULL,'2025-12-05 10:07:56',NULL,'2025-12-05 10:07:56',NULL,NULL),(435,NULL,'a76b01c088e84340bcd882d799933319',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:57',NULL,'2025-12-05 10:07:57',NULL,NULL),(436,NULL,'44be45e025ad4b70a9c5ef7596a6d3d3',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:58',NULL,'2025-12-05 10:07:58',NULL,NULL),(437,NULL,NULL,'b92556fce153412eb40f4ab3fd04ab04',NULL,NULL,NULL,NULL,'2025-12-05 10:07:58',NULL,'2025-12-05 10:07:58',NULL,NULL),(438,NULL,NULL,'08febb12941346809d6181cb1468d70a',NULL,NULL,NULL,NULL,'2025-12-05 10:07:58',NULL,'2025-12-05 10:07:58',NULL,NULL),(439,NULL,'eb29c00255a140139568c2b79c4649e5',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:07:58',NULL,'2025-12-05 10:07:58',NULL,NULL),(440,NULL,'289e786458e04306bd2a58284b8a0570',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:01',NULL,'2025-12-05 10:08:01',NULL,NULL),(441,NULL,NULL,'08a010ebac2648f7b3dbeae6cc788491',NULL,NULL,NULL,NULL,'2025-12-05 10:08:01',NULL,'2025-12-05 10:08:01',NULL,NULL),(442,NULL,NULL,'96c339437d3d40ac88d75813ec478143',NULL,NULL,NULL,NULL,'2025-12-05 10:08:01',NULL,'2025-12-05 10:08:01',NULL,NULL),(443,NULL,'fc752c8494054a9a8cfc6e1ca093077d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:02',NULL,'2025-12-05 10:08:02',NULL,NULL),(444,NULL,NULL,'a456cc4ed092442084a62df773ffb96f',NULL,NULL,NULL,NULL,'2025-12-05 10:08:02',NULL,'2025-12-05 10:08:02',NULL,NULL),(445,NULL,NULL,'73543ea6fe184a8ea8395ddd0c46da63',NULL,NULL,NULL,NULL,'2025-12-05 10:08:02',NULL,'2025-12-05 10:08:02',NULL,NULL),(446,NULL,NULL,'d245746203b34c36a62d69afb045738e',NULL,NULL,NULL,NULL,'2025-12-05 10:08:02',NULL,'2025-12-05 10:08:02',NULL,NULL),(447,NULL,'1fad10530dcd45ac84c7a77dfbcdc8b6',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:02',NULL,'2025-12-05 10:08:02',NULL,NULL),(448,NULL,NULL,'cf666bbdd02a434785a22d1f72c3b592',NULL,NULL,NULL,NULL,'2025-12-05 10:08:02',NULL,'2025-12-05 10:08:02',NULL,NULL),(449,NULL,'d7051ad5877a4a83971fe887836117c9',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:03',NULL,'2025-12-05 10:08:03',NULL,NULL),(450,NULL,NULL,'aa5c05ef703b4c5c829b56913fd95190',NULL,NULL,NULL,NULL,'2025-12-05 10:08:03',NULL,'2025-12-05 10:08:03',NULL,NULL),(451,NULL,'348e4bb45bd94e3e8efd185134e767d7',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:03',NULL,'2025-12-05 10:08:03',NULL,NULL),(452,NULL,'164c659aaf8745d8be8bb64c185980d2',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:03',NULL,'2025-12-05 10:08:03',NULL,NULL),(453,NULL,'4371da76dd2a4628a58e02eb9c21b61a',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:03',NULL,'2025-12-05 10:08:03',NULL,NULL),(454,NULL,'7b26144fb495438c9666bbff7479f0c0',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:04',NULL,'2025-12-05 10:08:04',NULL,NULL),(455,NULL,NULL,'8f03348d2ce34746881321a57254e294',NULL,NULL,NULL,NULL,'2025-12-05 10:08:05',NULL,'2025-12-05 10:08:05',NULL,NULL),(456,NULL,'92d7344352274d97ae4e4582ee2e40c8',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:05',NULL,'2025-12-05 10:08:05',NULL,NULL),(457,NULL,'4b28cfa3b851441a981f2fa213cf5388',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:05',NULL,'2025-12-05 10:08:05',NULL,NULL),(458,NULL,'6a952d891ee34602bd8b35abeb9d2514',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:05',NULL,'2025-12-05 10:08:05',NULL,NULL),(459,NULL,'543affdea1e64b2abcacf40a1652556d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:06',NULL,'2025-12-05 10:08:06',NULL,NULL),(460,NULL,'f1d928e553a84e38af1d554adfbb2f70',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:07',NULL,'2025-12-05 10:08:07',NULL,NULL),(461,NULL,'512235a67e57460d87bab1b75edd3d68',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:07',NULL,'2025-12-05 10:08:07',NULL,NULL),(462,NULL,NULL,'531acaaeb16b41578b9e5aaedc796834',NULL,NULL,NULL,NULL,'2025-12-05 10:08:08',NULL,'2025-12-05 10:08:08',NULL,NULL),(463,NULL,NULL,'810c4ef774c047a1ae6044b1d00b4480',NULL,NULL,NULL,NULL,'2025-12-05 10:08:08',NULL,'2025-12-05 10:08:08',NULL,NULL),(464,NULL,'540b368c2c21445786b0ec891c86edee',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:08',NULL,'2025-12-05 10:08:08',NULL,NULL),(465,NULL,'2d11b254caa34b679ccae3ec63d06078',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:09',NULL,'2025-12-05 10:08:09',NULL,NULL),(466,NULL,NULL,'892d200a3bae4d259e899301081344d3',NULL,NULL,NULL,NULL,'2025-12-05 10:08:10',NULL,'2025-12-05 10:08:10',NULL,NULL),(467,NULL,NULL,'d48d7c6452b84225b1995245644fe14d',NULL,NULL,NULL,NULL,'2025-12-05 10:08:10',NULL,'2025-12-05 10:08:10',NULL,NULL),(468,NULL,NULL,'1b259a6dffa44d89aaa9751e690603ce',NULL,NULL,NULL,NULL,'2025-12-05 10:08:10',NULL,'2025-12-05 10:08:10',NULL,NULL),(469,NULL,'51420f3f5a8f47ccbd9c0d60c77f0c4b',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:11',NULL,'2025-12-05 10:08:11',NULL,NULL),(470,NULL,'4b715fd82ad84602b746525ec3d571ce',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:12',NULL,'2025-12-05 10:08:12',NULL,NULL),(471,NULL,'c5e9b64a39874c2d92eda39576fb8d3a',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:13',NULL,'2025-12-05 10:08:13',NULL,NULL),(472,NULL,NULL,'79ffa23e6a0140bb8bd599ff6aa98796',NULL,NULL,NULL,NULL,'2025-12-05 10:08:15',NULL,'2025-12-05 10:08:15',NULL,NULL),(473,NULL,NULL,'b790c6f808774574a557a56942d07ba9',NULL,NULL,NULL,NULL,'2025-12-05 10:08:15',NULL,'2025-12-05 10:08:15',NULL,NULL),(474,NULL,'123abcd5a9cd4df387cd982bf1deac30',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:16',NULL,'2025-12-05 10:08:16',NULL,NULL),(475,NULL,'667a021b605049058761179f39c48df7',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:17',NULL,'2025-12-05 10:08:17',NULL,NULL),(476,NULL,'cafaa55b4b0343d5bb2ae7d28756244c',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:19',NULL,'2025-12-05 10:08:19',NULL,NULL),(477,NULL,NULL,'6d4e483820aa41bda0388276c54f11a7',NULL,NULL,NULL,NULL,'2025-12-05 10:08:19',NULL,'2025-12-05 10:08:19',NULL,NULL),(478,NULL,NULL,'6d4e483820aa41bda0388276c54f11a7',NULL,NULL,NULL,NULL,'2025-12-05 10:08:20',NULL,'2025-12-05 10:08:20',NULL,NULL),(479,NULL,'6235c4390981436386c09013159c1576',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:20',NULL,'2025-12-05 10:08:20',NULL,NULL),(480,NULL,NULL,'9d0436c975f1406c88d357e9229c871a',NULL,NULL,NULL,NULL,'2025-12-05 10:08:20',NULL,'2025-12-05 10:08:20',NULL,NULL),(481,NULL,NULL,'4a40805922c84b17bc40aebe10bb6100',NULL,NULL,NULL,NULL,'2025-12-05 10:08:20',NULL,'2025-12-05 10:08:20',NULL,NULL),(482,NULL,'6015e0f0a10a480cab8a436c79b5aad8',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:21',NULL,'2025-12-05 10:08:21',NULL,NULL),(483,NULL,'32f58a2a19e94351b90b5894001f6f35',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:22',NULL,'2025-12-05 10:08:22',NULL,NULL),(484,NULL,NULL,'74742f73f9fe497886070f2a2baf095f',NULL,NULL,NULL,NULL,'2025-12-05 10:08:23',NULL,'2025-12-05 10:08:23',NULL,NULL),(485,NULL,NULL,'c1b05cb51c4249af93226388da8dfd0d',NULL,NULL,NULL,NULL,'2025-12-05 10:08:23',NULL,'2025-12-05 10:08:23',NULL,NULL),(486,NULL,'8d73a794512b485db8c8e8bb64bb36c4',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:24',NULL,'2025-12-05 10:08:24',NULL,NULL),(487,NULL,'b41a0af915814ae4a765ab5339d92fbf',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:25',NULL,'2025-12-05 10:08:25',NULL,NULL),(488,NULL,NULL,'282932f3cc6a4594a4922d5ee7d0a462',NULL,NULL,NULL,NULL,'2025-12-05 10:08:28',NULL,'2025-12-05 10:08:28',NULL,NULL),(489,NULL,'dbf92fe077784723a151c610928d037c',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:29',NULL,'2025-12-05 10:08:29',NULL,NULL),(490,NULL,'8e142cb28f7f4b66a6c82483223a096d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:29',NULL,'2025-12-05 10:08:29',NULL,NULL),(491,NULL,NULL,'32fcff3ac6e14950b94cc12b16cabdf0',NULL,NULL,NULL,NULL,'2025-12-05 10:08:30',NULL,'2025-12-05 10:08:30',NULL,NULL),(492,NULL,'d675cefa63e14882bc0ebe68b22ac36a',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:31',NULL,'2025-12-05 10:08:31',NULL,NULL),(493,NULL,'faba9c4173bb44f48b9adbfe5e5f92b1',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:32',NULL,'2025-12-05 10:08:32',NULL,NULL),(494,NULL,NULL,'2dacb844872c4dc28ef56dfedba07558',NULL,NULL,NULL,NULL,'2025-12-05 10:08:32',NULL,'2025-12-05 10:08:32',NULL,NULL),(495,NULL,NULL,'9ac1388bb3a640e49ddcd651b208ee92',NULL,NULL,NULL,NULL,'2025-12-05 10:08:33',NULL,'2025-12-05 10:08:33',NULL,NULL),(496,NULL,NULL,'ffeb161af45c433084c97683ee36262f',NULL,NULL,NULL,NULL,'2025-12-05 10:08:33',NULL,'2025-12-05 10:08:33',NULL,NULL),(497,NULL,NULL,'6bab39ce7128463691a76ac88a4f25cc',NULL,NULL,NULL,NULL,'2025-12-05 10:08:33',NULL,'2025-12-05 10:08:33',NULL,NULL),(498,NULL,NULL,'63c7e0a2b6b047c5a11a4b8fe602f835',NULL,NULL,NULL,NULL,'2025-12-05 10:08:34',NULL,'2025-12-05 10:08:34',NULL,NULL),(499,NULL,'e2c154859caa41ce9fdcff3aa2718f01',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:36',NULL,'2025-12-05 10:08:36',NULL,NULL),(500,NULL,'32436b9c05154eecae8384271036b300',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:37',NULL,'2025-12-05 10:08:37',NULL,NULL),(501,NULL,'6e781c00d7d24d498b34991ce140ee15',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:38',NULL,'2025-12-05 10:08:38',NULL,NULL),(502,NULL,'31394b1e02ba4225badb28cfedcb4e8f',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:39',NULL,'2025-12-05 10:08:39',NULL,NULL),(503,NULL,'61dfe751c6984ae9b035e7b44d171fbf',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:40',NULL,'2025-12-05 10:08:40',NULL,NULL),(504,NULL,NULL,'5047d53021994409afa6340af067cbfd',NULL,NULL,NULL,NULL,'2025-12-05 10:08:42',NULL,'2025-12-05 10:08:42',NULL,NULL),(505,NULL,'adb7a99336874cdeaa31430eddf77460',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:42',NULL,'2025-12-05 10:08:42',NULL,NULL),(506,NULL,'7e2e566cc7034056837dff51c6610d47',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:43',NULL,'2025-12-05 10:08:43',NULL,NULL),(507,NULL,'cc078bc833a04d078d749ea285a15018',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:43',NULL,'2025-12-05 10:08:43',NULL,NULL),(508,NULL,'2171455eec8b42cf8be3e316c4816c3f',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:44',NULL,'2025-12-05 10:08:44',NULL,NULL),(509,NULL,NULL,'4926e929992b4f78b918f34a39701b0c',NULL,NULL,NULL,NULL,'2025-12-05 10:08:44',NULL,'2025-12-05 10:08:44',NULL,NULL),(510,NULL,'4d04b8d670b84b8980f58b2a66135457',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:44',NULL,'2025-12-05 10:08:44',NULL,NULL),(511,NULL,NULL,'a91114d5a0c74b6189677107a4d2d190',NULL,NULL,NULL,NULL,'2025-12-05 10:08:44',NULL,'2025-12-05 10:08:44',NULL,NULL),(512,NULL,'ea65d41fe6644b33a975ccbb96a6e6b5',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:44',NULL,'2025-12-05 10:08:44',NULL,NULL),(513,NULL,'74e2cce7c5b747de9c30806977bd8b3e',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:45',NULL,'2025-12-05 10:08:45',NULL,NULL),(514,NULL,'6f29bedd2e7e4eae9449b07c13eeacd4',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:45',NULL,'2025-12-05 10:08:45',NULL,NULL),(515,NULL,'f9ca76388e1e4258ae7631dd13c1d5ba',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:45',NULL,'2025-12-05 10:08:45',NULL,NULL),(516,NULL,'b59fd345b3634253803428c54ec7526b',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:45',NULL,'2025-12-05 10:08:45',NULL,NULL),(517,NULL,'0e769fe1303145b18fbaecad0d76c401',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:46',NULL,'2025-12-05 10:08:46',NULL,NULL),(518,NULL,'5c70aa62cdac4c90957fc22f84c7abb8',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:46',NULL,'2025-12-05 10:08:46',NULL,NULL),(519,NULL,'9eecf8c5969842e7a2ec15e4784de2bb',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:46',NULL,'2025-12-05 10:08:46',NULL,NULL),(520,NULL,'f48fd231d61f4fe08ce1def571150274',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:47',NULL,'2025-12-05 10:08:47',NULL,NULL),(521,NULL,'0e5af6cb98e343d0955140ff666373be',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:47',NULL,'2025-12-05 10:08:47',NULL,NULL),(522,NULL,NULL,'4ef1b6d9768a474b91cb4cd539f76f5b',NULL,NULL,NULL,NULL,'2025-12-05 10:08:47',NULL,'2025-12-05 10:08:47',NULL,NULL),(523,NULL,NULL,'7477c32c21644b1294a1db680be7d197',NULL,NULL,NULL,NULL,'2025-12-05 10:08:47',NULL,'2025-12-05 10:08:47',NULL,NULL),(524,NULL,'e80c61db951a4dd2a370e12acfc5f9dc',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:48',NULL,'2025-12-05 10:08:48',NULL,NULL),(525,NULL,NULL,'a052c73754704caaa399378c7e50192a',NULL,NULL,NULL,NULL,'2025-12-05 10:08:49',NULL,'2025-12-05 10:08:49',NULL,NULL),(526,NULL,'de4f1e3820a64f0c946fbe994694d226',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:50',NULL,'2025-12-05 10:08:50',NULL,NULL),(527,NULL,NULL,'119d10cec218444dba4a94c06ddeca8d',NULL,NULL,NULL,NULL,'2025-12-05 10:08:50',NULL,'2025-12-05 10:08:50',NULL,NULL),(528,NULL,NULL,'b19c7bf5b71f4a459f30ddf0f792db92',NULL,NULL,NULL,NULL,'2025-12-05 10:08:52',NULL,'2025-12-05 10:08:52',NULL,NULL),(529,NULL,NULL,'2f90c5186cc14a0a8a8f7faf3454b78f',NULL,NULL,NULL,NULL,'2025-12-05 10:08:52',NULL,'2025-12-05 10:08:52',NULL,NULL),(530,NULL,'f8da57e2736240a0ac7055e85adea6da',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:53',NULL,'2025-12-05 10:08:53',NULL,NULL),(531,NULL,'6f92022fc2c9424589d3e5c5289d1a7d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:53',NULL,'2025-12-05 10:08:53',NULL,NULL),(532,NULL,'45321edb2660477c8f30c01b2956e5b6',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:54',NULL,'2025-12-05 10:08:54',NULL,NULL),(533,NULL,NULL,'c2f418e692494b02babe78253e2e4d98',NULL,NULL,NULL,NULL,'2025-12-05 10:08:56',NULL,'2025-12-05 10:08:56',NULL,NULL),(534,NULL,'1c4b3bae599a4efda0cafd79186ec5d1',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:57',NULL,'2025-12-05 10:08:57',NULL,NULL),(535,NULL,NULL,'57696a75692e4f448df292725bcff9a0',NULL,NULL,NULL,NULL,'2025-12-05 10:08:57',NULL,'2025-12-05 10:08:57',NULL,NULL),(536,NULL,'0b296e0ab4b6447982bcfc680b8ba396',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:57',NULL,'2025-12-05 10:08:57',NULL,NULL),(537,NULL,'a5ef46d05d244daf96d3aa9aa856932c',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:59',NULL,'2025-12-05 10:08:59',NULL,NULL),(538,NULL,'6225d95e0a924813958256bdb79de31f',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:08:59',NULL,'2025-12-05 10:08:59',NULL,NULL),(539,NULL,NULL,'d95c32efd5b0416393dd5585c0572a81',NULL,NULL,NULL,NULL,'2025-12-05 10:08:59',NULL,'2025-12-05 10:08:59',NULL,NULL),(540,NULL,NULL,'c1499ef438574d678c1fd67b43f4e182',NULL,NULL,NULL,NULL,'2025-12-05 10:08:59',NULL,'2025-12-05 10:08:59',NULL,NULL),(541,NULL,NULL,'54d2da4387cf4b09ade2fa5ac14b6b88',NULL,NULL,NULL,NULL,'2025-12-05 10:09:00',NULL,'2025-12-05 10:09:00',NULL,NULL),(542,NULL,'e5c1d3be695d4b14816e6ea97315cd6f',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:09:00',NULL,'2025-12-05 10:09:00',NULL,NULL),(543,NULL,NULL,'75adce02812f41f28f2002bf3e654abe',NULL,NULL,NULL,NULL,'2025-12-05 10:09:02',NULL,'2025-12-05 10:09:02',NULL,NULL),(544,NULL,'4d6070f41e144742a7c429de41459c77',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:09:02',NULL,'2025-12-05 10:09:02',NULL,NULL),(545,NULL,'d1cbc260352e47059abde0b0b3278b51',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:09:02',NULL,'2025-12-05 10:09:02',NULL,NULL),(546,NULL,'6fe55e92893a41c6a842d43198425d5a',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:09:04',NULL,'2025-12-05 10:09:04',NULL,NULL),(547,NULL,'9255cd3a723344d4939f59b38ff02e45',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:09:05',NULL,'2025-12-05 10:09:05',NULL,NULL),(548,NULL,NULL,'749859ca8a034a6bb53f5db128cbe15b',NULL,NULL,NULL,NULL,'2025-12-05 10:09:15',NULL,'2025-12-05 10:09:15',NULL,NULL),(549,NULL,'c7dbee2ced7147429311c1ce1cf2a939',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:09:18',NULL,'2025-12-05 10:09:18',NULL,NULL),(550,NULL,NULL,'b32fc226e983460f8c7bf7d33b0dc4c6',NULL,NULL,NULL,NULL,'2025-12-05 10:09:19',NULL,'2025-12-05 10:09:19',NULL,NULL),(551,NULL,NULL,'039e61a6e4894ef5ae2db0d530fc20d4',NULL,NULL,NULL,NULL,'2025-12-05 10:09:20',NULL,'2025-12-05 10:09:20',NULL,NULL),(552,NULL,NULL,'866ff8446ba1414ca637bc2541e2b20c',NULL,NULL,NULL,NULL,'2025-12-05 10:09:20',NULL,'2025-12-05 10:09:20',NULL,NULL),(553,NULL,NULL,'576647c910e440109c8fa6a1f21037a8',NULL,NULL,NULL,NULL,'2025-12-05 10:09:20',NULL,'2025-12-05 10:09:20',NULL,NULL),(554,NULL,'49be837e62ee480f80076382c098e61f',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:09:21',NULL,'2025-12-05 10:09:21',NULL,NULL),(555,NULL,'1e403462f5fd4d6cbcd026f0f727dd2a',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:09:21',NULL,'2025-12-05 10:09:21',NULL,NULL),(556,NULL,'c16aa2022f0d47ccae3f2f6b3c665194',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:09:22',NULL,'2025-12-05 10:09:22',NULL,NULL),(557,NULL,'6a4c846f47c54b2daa656a81ff2db5e4',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:09:23',NULL,'2025-12-05 10:09:23',NULL,NULL),(558,NULL,NULL,'fe869cc822a94676b5168f20a34bcd2f',NULL,NULL,NULL,NULL,'2025-12-05 10:09:26',NULL,'2025-12-05 10:09:26',NULL,NULL),(559,NULL,NULL,'f2e76db4fa0745828571ea6b87b6b09c',NULL,NULL,NULL,NULL,'2025-12-05 10:09:26',NULL,'2025-12-05 10:09:26',NULL,NULL),(560,NULL,NULL,'4b515ad5b8f6457fa2c73b4b47bf1655',NULL,NULL,NULL,NULL,'2025-12-05 10:09:26',NULL,'2025-12-05 10:09:26',NULL,NULL),(561,NULL,'eb581b3986ff44adaf0d86d376d9c83a',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:09:27',NULL,'2025-12-05 10:09:27',NULL,NULL),(562,NULL,'204296e252124e5b80d3c3ac433581bf',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:09:29',NULL,'2025-12-05 10:09:29',NULL,NULL),(563,NULL,'ad5ef68ea71942e1b884625f99120c1d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:09:30',NULL,'2025-12-05 10:09:30',NULL,NULL),(564,NULL,NULL,'10a49399418745bf9b2ecbdc509cce2e',NULL,NULL,NULL,NULL,'2025-12-05 10:09:31',NULL,'2025-12-05 10:09:31',NULL,NULL),(565,NULL,NULL,'5eec71af41824815ba824bf807f8179b',NULL,NULL,NULL,NULL,'2025-12-05 10:09:31',NULL,'2025-12-05 10:09:31',NULL,NULL),(566,NULL,NULL,'6cc3a7e9b1614bb8bd6dd7f5659d79b5',NULL,NULL,NULL,NULL,'2025-12-05 10:09:31',NULL,'2025-12-05 10:09:31',NULL,NULL),(567,NULL,NULL,'21dbd87eb92a43039b74833e2bc9b054',NULL,NULL,NULL,NULL,'2025-12-05 10:09:32',NULL,'2025-12-05 10:09:32',NULL,NULL),(568,NULL,NULL,'8371e0b5d5f449bda031da03f24f2a02',NULL,NULL,NULL,NULL,'2025-12-05 10:09:32',NULL,'2025-12-05 10:09:32',NULL,NULL),(569,NULL,'9911350e2d5148098ee9d947cc452035',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:09:33',NULL,'2025-12-05 10:09:33',NULL,NULL),(570,NULL,'70f3c241260c4833846cef3d99a05e88',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:09:33',NULL,'2025-12-05 10:09:33',NULL,NULL),(571,NULL,'b042ca58df6348e1a29311c5a517d4d4',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:09:33',NULL,'2025-12-05 10:09:33',NULL,NULL),(572,NULL,'facf14762ade4f009091ab8a495e5cec',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:09:34',NULL,'2025-12-05 10:09:34',NULL,NULL),(573,NULL,'c8ccd65ea147440ead35b44c3db742cd',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:09:34',NULL,'2025-12-05 10:09:34',NULL,NULL),(574,NULL,NULL,'b84a2c64c68d46e79b15d8ef03d73b26',NULL,NULL,NULL,NULL,'2025-12-05 10:09:34',NULL,'2025-12-05 10:09:34',NULL,NULL),(575,NULL,NULL,'7cdff101595b4454a2c7604fd353f764',NULL,NULL,NULL,NULL,'2025-12-05 10:09:36',NULL,'2025-12-05 10:09:36',NULL,NULL),(576,NULL,'012f487dbd0649d78abde870bf15da89',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:09:36',NULL,'2025-12-05 10:09:36',NULL,NULL),(577,NULL,'4c80f90acce64473ba7397cbbc5cd26f',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:09:37',NULL,'2025-12-05 10:09:37',NULL,NULL),(578,NULL,NULL,'4cf298dbc85740a9aa682a77067b7864',NULL,NULL,NULL,NULL,'2025-12-05 10:09:39',NULL,'2025-12-05 10:09:39',NULL,NULL),(579,NULL,NULL,'b5a0561422df44dc8e5d6ea948ede046',NULL,NULL,NULL,NULL,'2025-12-05 10:09:43',NULL,'2025-12-05 10:09:43',NULL,NULL),(580,NULL,NULL,'6aa30efb5a6c40d0b5129080d08f7cf0',NULL,NULL,NULL,NULL,'2025-12-05 10:09:43',NULL,'2025-12-05 10:09:43',NULL,NULL),(581,NULL,NULL,'a914be7b6330495b81fb0c335b67fbab',NULL,NULL,NULL,NULL,'2025-12-05 10:09:44',NULL,'2025-12-05 10:09:44',NULL,NULL),(582,NULL,NULL,'fbca4bcf05fc46d9a0bcc4ef8a7c42b6',NULL,NULL,NULL,NULL,'2025-12-05 10:09:44',NULL,'2025-12-05 10:09:44',NULL,NULL),(583,NULL,'2eb8cf0d784b4d188f16c04a39a755a9',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:09:44',NULL,'2025-12-05 10:09:44',NULL,NULL),(584,NULL,'0b5890d7a3cd4700a466ea11b7ec964e',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:09:46',NULL,'2025-12-05 10:09:46',NULL,NULL),(585,NULL,'2a75755511724e1490eadaf4acc7671f',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:09:47',NULL,'2025-12-05 10:09:47',NULL,NULL),(586,NULL,'cbc85803d6684277b7ae1db51d3047c7',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:09:48',NULL,'2025-12-05 10:09:48',NULL,NULL),(587,NULL,'0577e92542694802a51ab64526d6d905',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:09:48',NULL,'2025-12-05 10:09:48',NULL,NULL),(588,NULL,NULL,'8ce4f74fa6ae4ecb88b07885aa5c1106',NULL,NULL,NULL,NULL,'2025-12-05 10:09:53',NULL,'2025-12-05 10:09:53',NULL,NULL),(589,NULL,NULL,'14930b4086bd4a259ebac2a9a1aae95f',NULL,NULL,NULL,NULL,'2025-12-05 10:09:54',NULL,'2025-12-05 10:09:54',NULL,NULL),(590,NULL,'49a03d7fbc1a4c938c9dce38346a9a7b',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:09:59',NULL,'2025-12-05 10:09:59',NULL,NULL),(591,NULL,'d47504cf025e4eb3a6a5a1b9966b0389',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:10:02',NULL,'2025-12-05 10:10:02',NULL,NULL),(592,NULL,NULL,'71a1dc47c8964743be7069896a3eb55e',NULL,NULL,NULL,NULL,'2025-12-05 10:10:02',NULL,'2025-12-05 10:10:02',NULL,NULL),(593,NULL,'f6db8cbac53645ef9430332056699027',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:10:04',NULL,'2025-12-05 10:10:04',NULL,NULL),(594,NULL,NULL,'f30242cd52e24b7992dc01c832ad62f6',NULL,NULL,NULL,NULL,'2025-12-05 10:10:05',NULL,'2025-12-05 10:10:05',NULL,NULL),(595,NULL,NULL,'604f7df4a8ed42ed9f33785bc35c336b',NULL,NULL,NULL,NULL,'2025-12-05 10:10:05',NULL,'2025-12-05 10:10:05',NULL,NULL),(596,NULL,NULL,'8a3f4832b77f4073b7e63315b5f40083',NULL,NULL,NULL,NULL,'2025-12-05 10:10:05',NULL,'2025-12-05 10:10:05',NULL,NULL),(597,NULL,NULL,'b1808a8aad0b4360880c390bd8362a00',NULL,NULL,NULL,NULL,'2025-12-05 10:10:06',NULL,'2025-12-05 10:10:06',NULL,NULL),(598,NULL,'e4fe9762324442459e16cd8ca78e7d20',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:10:08',NULL,'2025-12-05 10:10:08',NULL,NULL),(599,NULL,'74a17deba84b470ebe240fab8c99b64c',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:10:09',NULL,'2025-12-05 10:10:09',NULL,NULL),(600,NULL,'8f4b03bb43a344a881ee8f194219733e',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:10:09',NULL,'2025-12-05 10:10:09',NULL,NULL),(601,NULL,'7033021fa28e49e2a59a5f700e12488d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:10:11',NULL,'2025-12-05 10:10:11',NULL,NULL),(602,NULL,NULL,'0b6b4749f27a4147ae07b8cb40737288',NULL,NULL,NULL,NULL,'2025-12-05 10:10:17',NULL,'2025-12-05 10:10:17',NULL,NULL),(603,NULL,NULL,'613c0958b9a44ef1bb901c4375872a76',NULL,NULL,NULL,NULL,'2025-12-05 10:10:17',NULL,'2025-12-05 10:10:17',NULL,NULL),(604,NULL,'3e1f2363f1af446095b256c4564bb0fe',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:10:19',NULL,'2025-12-05 10:10:19',NULL,NULL),(605,NULL,'9993ea002f004514af187703321b5ea8',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:10:21',NULL,'2025-12-05 10:10:21',NULL,NULL),(606,NULL,NULL,'850de70224c74e0f8fa95e10b2773e45',NULL,NULL,NULL,NULL,'2025-12-05 10:10:22',NULL,'2025-12-05 10:10:22',NULL,NULL),(607,NULL,NULL,'f830ec09ed634dccb75485414633c371',NULL,NULL,NULL,NULL,'2025-12-05 10:10:22',NULL,'2025-12-05 10:10:22',NULL,NULL),(608,NULL,NULL,'ac6d64969864437c939a53a728526e56',NULL,NULL,NULL,NULL,'2025-12-05 10:10:22',NULL,'2025-12-05 10:10:22',NULL,NULL),(609,NULL,'7864fe2bcb66461095dedc4deed01501',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:10:25',NULL,'2025-12-05 10:10:25',NULL,NULL),(610,NULL,'4e8e00ac799b49f398771b10f4cbaeee',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:10:26',NULL,'2025-12-05 10:10:26',NULL,NULL),(611,NULL,'584e347c69994bcbb195242db0534134',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:10:27',NULL,'2025-12-05 10:10:27',NULL,NULL),(612,NULL,NULL,'22abec853ab749be848c79b0ad032aeb',NULL,NULL,NULL,NULL,'2025-12-05 10:10:28',NULL,'2025-12-05 10:10:28',NULL,NULL),(613,NULL,NULL,'e61ad730c0b3472ca0cb385257f9d2ec',NULL,NULL,NULL,NULL,'2025-12-05 10:10:28',NULL,'2025-12-05 10:10:28',NULL,NULL),(614,NULL,NULL,'9ad212ec28c94cd483f6945e5dc23284',NULL,NULL,NULL,NULL,'2025-12-05 10:10:28',NULL,'2025-12-05 10:10:28',NULL,NULL),(615,NULL,NULL,'2d4d251c64d64062a02f26736610b5f7',NULL,NULL,NULL,NULL,'2025-12-05 10:10:29',NULL,'2025-12-05 10:10:29',NULL,NULL),(616,NULL,NULL,'0f4137e965aa4c87a3126c6699afb24f',NULL,NULL,NULL,NULL,'2025-12-05 10:10:29',NULL,'2025-12-05 10:10:29',NULL,NULL),(617,NULL,'0808cc9f173842a9bd781ea011b6425e',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:10:31',NULL,'2025-12-05 10:10:31',NULL,NULL),(618,NULL,'eb60294ee4f34b18a2ed20a26c39cd32',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:10:31',NULL,'2025-12-05 10:10:31',NULL,NULL),(619,NULL,NULL,'0be8a570b6cd4650b91a6f94ff153b69',NULL,NULL,NULL,NULL,'2025-12-05 10:10:32',NULL,'2025-12-05 10:10:32',NULL,NULL),(620,NULL,NULL,'2ed2375621f64dbc9e17a24309fe0374',NULL,NULL,NULL,NULL,'2025-12-05 10:10:32',NULL,'2025-12-05 10:10:32',NULL,NULL),(621,NULL,'b0ebdf5f32df4c2586aaaef64b02a0b5',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:10:32',NULL,'2025-12-05 10:10:32',NULL,NULL),(622,NULL,'f22e077193c5438f8057ad89a3e18cb5',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:10:35',NULL,'2025-12-05 10:10:35',NULL,NULL),(623,NULL,'74c887d855ec446cbdeb81d1edf2225e',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:10:36',NULL,'2025-12-05 10:10:36',NULL,NULL),(624,NULL,'da3d4c9e3ccd4aa38b7fe9f2de8c5344',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:10:36',NULL,'2025-12-05 10:10:36',NULL,NULL),(625,NULL,'1910037d54e44da48375fb8eba96a55d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:10:42',NULL,'2025-12-05 10:10:42',NULL,NULL),(626,NULL,NULL,'f2ece8800e024bdaa1f8a8c92189b426',NULL,NULL,NULL,NULL,'2025-12-05 10:10:45',NULL,'2025-12-05 10:10:45',NULL,NULL),(627,NULL,NULL,'ef8a53cb377d49c9a5d1ce8b3a465546',NULL,NULL,NULL,NULL,'2025-12-05 10:10:45',NULL,'2025-12-05 10:10:45',NULL,NULL),(628,NULL,NULL,'71e3fab65ffb4bc788d27178ac1efd8e',NULL,NULL,NULL,NULL,'2025-12-05 10:10:48',NULL,'2025-12-05 10:10:48',NULL,NULL),(629,NULL,'61a42a692eb34cfeb3f7ee734308cec7',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:10:50',NULL,'2025-12-05 10:10:50',NULL,NULL),(630,NULL,'285f12c8420045f3a7f55b60a915ce1e',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:10:50',NULL,'2025-12-05 10:10:50',NULL,NULL),(631,NULL,'e3199c4c895043739e357008afbe83c8',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:10:52',NULL,'2025-12-05 10:10:52',NULL,NULL),(632,NULL,NULL,'8fb81b2532894cadb47815b7d8fd0137',NULL,NULL,NULL,NULL,'2025-12-05 10:10:58',NULL,'2025-12-05 10:10:58',NULL,NULL),(633,NULL,NULL,'e18ec969e7974e399d570aed064ac229',NULL,NULL,NULL,NULL,'2025-12-05 10:10:59',NULL,'2025-12-05 10:10:59',NULL,NULL),(634,NULL,NULL,'403db31a3fa141538ae12d97f89b9c55',NULL,NULL,NULL,NULL,'2025-12-05 10:11:04',NULL,'2025-12-05 10:11:04',NULL,NULL),(635,NULL,NULL,'0659ad01cef24d4f968c4c4f56f87412',NULL,NULL,NULL,NULL,'2025-12-05 10:11:05',NULL,'2025-12-05 10:11:05',NULL,NULL),(636,NULL,'43a61ecd5c524cdab48b7eeb9454b8ff',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:11:16',NULL,'2025-12-05 10:11:16',NULL,NULL),(637,NULL,'b0b9e4dc414946c097d558d4b89e8947',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:11:17',NULL,'2025-12-05 10:11:17',NULL,NULL),(638,NULL,'80f44e40444842f48082b55ebf0b4d5d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:11:21',NULL,'2025-12-05 10:11:21',NULL,NULL),(639,NULL,NULL,'fa1455203c8f45df919302ad291a76ff',NULL,NULL,NULL,NULL,'2025-12-05 10:11:23',NULL,'2025-12-05 10:11:23',NULL,NULL),(640,NULL,NULL,'2ea873f665ba41948906baac5e68b7c6',NULL,NULL,NULL,NULL,'2025-12-05 10:11:25',NULL,'2025-12-05 10:11:25',NULL,NULL),(641,NULL,NULL,'c841ee2099f04054a53be883c2db6e62',NULL,NULL,NULL,NULL,'2025-12-05 10:11:25',NULL,'2025-12-05 10:11:25',NULL,NULL),(642,NULL,'b984bc032821439da9e14438f496b701',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:11:26',NULL,'2025-12-05 10:11:26',NULL,NULL),(643,NULL,NULL,'c9b8bf9d3c3845489585e91ce303dd97',NULL,NULL,NULL,NULL,'2025-12-05 10:11:26',NULL,'2025-12-05 10:11:26',NULL,NULL),(644,NULL,NULL,'352a4d4152dc440ca94c20dd37a9bbd9',NULL,NULL,NULL,NULL,'2025-12-05 10:11:26',NULL,'2025-12-05 10:11:26',NULL,NULL),(645,NULL,NULL,'2c33b8c3808c4d2fb486611901223652',NULL,NULL,NULL,NULL,'2025-12-05 10:11:29',NULL,'2025-12-05 10:11:29',NULL,NULL),(646,NULL,'1220f950d9bb436099f84f4762bc2e27',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:11:30',NULL,'2025-12-05 10:11:30',NULL,NULL),(647,NULL,'e414e3f4550e4190921cb0a45b93e1a8',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:11:30',NULL,'2025-12-05 10:11:30',NULL,NULL),(648,NULL,'936331162fd849b28da8e38e2db0598a',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:11:31',NULL,'2025-12-05 10:11:31',NULL,NULL),(649,NULL,'3731c665d25f4d9f8b1a419b8c87e909',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:11:35',NULL,'2025-12-05 10:11:35',NULL,NULL),(650,NULL,'2728206f91a84affa7ae6ec24bf45f52',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:11:37',NULL,'2025-12-05 10:11:37',NULL,NULL),(651,NULL,NULL,'6453145ee998467c9ec05e62f8e927f2',NULL,NULL,NULL,NULL,'2025-12-05 10:11:37',NULL,'2025-12-05 10:11:37',NULL,NULL),(652,NULL,'8eebb9e73adb4a259afe086ebdfad16e',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:11:39',NULL,'2025-12-05 10:11:39',NULL,NULL),(653,NULL,NULL,'b5463ede5a3144738c05f450e0687e8f',NULL,NULL,NULL,NULL,'2025-12-05 10:11:40',NULL,'2025-12-05 10:11:40',NULL,NULL),(654,NULL,NULL,'b81d12b2b37449029012266558aeea45',NULL,NULL,NULL,NULL,'2025-12-05 10:11:43',NULL,'2025-12-05 10:11:43',NULL,NULL),(655,NULL,'47620115819f4b4284ffa7b1f203da4f',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:11:43',NULL,'2025-12-05 10:11:43',NULL,NULL),(656,NULL,NULL,'a8098c65f55e40c2b947ef336f6dc9f7',NULL,NULL,NULL,NULL,'2025-12-05 10:11:49',NULL,'2025-12-05 10:11:49',NULL,NULL),(657,NULL,NULL,'36c8675d159f4df5bac35a996466a235',NULL,NULL,NULL,NULL,'2025-12-05 10:11:49',NULL,'2025-12-05 10:11:49',NULL,NULL),(658,NULL,NULL,'35818db97a7f48bba64f2172c36bcd92',NULL,NULL,NULL,NULL,'2025-12-05 10:11:49',NULL,'2025-12-05 10:11:49',NULL,NULL),(659,NULL,NULL,'1828a78b09d1416a8142070cf0ffda3d',NULL,NULL,NULL,NULL,'2025-12-05 10:11:50',NULL,'2025-12-05 10:11:50',NULL,NULL),(660,NULL,NULL,'3bf116b8d9ba48c49fc0ffd65e2e4fda',NULL,NULL,NULL,NULL,'2025-12-05 10:11:51',NULL,'2025-12-05 10:11:51',NULL,NULL),(661,NULL,'742c47288c43466fb15b8bc5e64971af',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:11:53',NULL,'2025-12-05 10:11:53',NULL,NULL),(662,NULL,'8cb09bff88504c818b275bb285c1a663',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:11:53',NULL,'2025-12-05 10:11:53',NULL,NULL),(663,NULL,'2238ffb217584686904f563705640aa4',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:11:53',NULL,'2025-12-05 10:11:53',NULL,NULL),(664,NULL,'2da20b723fa04eb6932b4cec2fb78230',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:11:54',NULL,'2025-12-05 10:11:54',NULL,NULL),(665,NULL,'a98fd83b9a644df1ab00e685abc16c8d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:11:58',NULL,'2025-12-05 10:11:58',NULL,NULL),(666,NULL,NULL,'6c11a521d46d447c86d6c5f7e9603e8e',NULL,NULL,NULL,NULL,'2025-12-05 10:11:59',NULL,'2025-12-05 10:11:59',NULL,NULL),(667,NULL,NULL,'9824361c4b744f5e80b411d99db1824a',NULL,NULL,NULL,NULL,'2025-12-05 10:11:59',NULL,'2025-12-05 10:11:59',NULL,NULL),(668,NULL,NULL,'b94dfc56e5a54e56b0dbbbd2cbde9644',NULL,NULL,NULL,NULL,'2025-12-05 10:12:00',NULL,'2025-12-05 10:12:00',NULL,NULL),(669,NULL,NULL,'c86f5a4c0d2f4d4b810c0974d0d1101f',NULL,NULL,NULL,NULL,'2025-12-05 10:12:00',NULL,'2025-12-05 10:12:00',NULL,NULL),(670,NULL,'1452e2ce96524c0b872bc0301513bae6',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:12:01',NULL,'2025-12-05 10:12:01',NULL,NULL),(671,NULL,'d6c713b21513456faa025c54fc9ffca6',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:12:01',NULL,'2025-12-05 10:12:01',NULL,NULL),(672,NULL,'07ccd9396684429596646bded13e438a',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:12:03',NULL,'2025-12-05 10:12:03',NULL,NULL),(673,NULL,'6beea127ce8f4d998afcabcc6a56507f',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:12:04',NULL,'2025-12-05 10:12:04',NULL,NULL),(674,NULL,NULL,'38cd917d57ba40a4bbbdcb831652dbb8',NULL,NULL,NULL,NULL,'2025-12-05 10:12:15',NULL,'2025-12-05 10:12:15',NULL,NULL),(675,NULL,NULL,'ec8eb8025a444d418bc565de5ad889c2',NULL,NULL,NULL,NULL,'2025-12-05 10:12:15',NULL,'2025-12-05 10:12:15',NULL,NULL),(676,NULL,'9b06ebc1eb5f4622b3198559907b39ec',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:12:18',NULL,'2025-12-05 10:12:18',NULL,NULL),(677,NULL,'0d9a9535e29c4ea5aa656ee174be21ef',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:12:20',NULL,'2025-12-05 10:12:20',NULL,NULL),(678,NULL,NULL,'7f85372395674a60a5c7817569330e07',NULL,NULL,NULL,NULL,'2025-12-05 10:12:21',NULL,'2025-12-05 10:12:21',NULL,NULL),(679,NULL,NULL,'04505938eab74d378aaf8b4824feba84',NULL,NULL,NULL,NULL,'2025-12-05 10:12:21',NULL,'2025-12-05 10:12:21',NULL,NULL),(680,NULL,'cd75aa877d484a7090a001691a2a520b',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:12:24',NULL,'2025-12-05 10:12:24',NULL,NULL),(681,NULL,'9e3d3287162a4caabf625f0490cbd91d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:12:24',NULL,'2025-12-05 10:12:24',NULL,NULL),(682,NULL,NULL,'c0d2fb180fd44dfebeb2ff0738cc7d88',NULL,NULL,NULL,NULL,'2025-12-05 10:12:27',NULL,'2025-12-05 10:12:27',NULL,NULL),(683,NULL,'a6cda6a273a84b45bb8bc9ed74bb9415',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:12:29',NULL,'2025-12-05 10:12:29',NULL,NULL),(684,NULL,NULL,'9d3385b7b45145bdb1032d3a6efc7d1f',NULL,NULL,NULL,NULL,'2025-12-05 10:12:30',NULL,'2025-12-05 10:12:30',NULL,NULL),(685,NULL,NULL,'d74a7ea03b864e4e88aee448fd739242',NULL,NULL,NULL,NULL,'2025-12-05 10:12:32',NULL,'2025-12-05 10:12:32',NULL,NULL),(686,NULL,'d34a70d4c87b4bccbac035ee2005a967',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:12:32',NULL,'2025-12-05 10:12:32',NULL,NULL),(687,NULL,'ef76e1242a6d41498f75478c52cab8e4',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:12:33',NULL,'2025-12-05 10:12:33',NULL,NULL),(688,NULL,NULL,'6e3c2192f79f4d3191a5f35d43e2d4f7',NULL,NULL,NULL,NULL,'2025-12-05 10:12:35',NULL,'2025-12-05 10:12:35',NULL,NULL),(689,NULL,NULL,'81e951dffd754a2fa243820acddeb12f',NULL,NULL,NULL,NULL,'2025-12-05 10:12:36',NULL,'2025-12-05 10:12:36',NULL,NULL),(690,NULL,'0d6c9392a40c4bcc824eba6a30de937f',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:12:38',NULL,'2025-12-05 10:12:38',NULL,NULL),(691,NULL,'9e010ce4f2c24bc2bad0174833aad773',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:12:38',NULL,'2025-12-05 10:12:38',NULL,NULL),(692,NULL,NULL,'8ed2850ffc594b2b8efbec4dcaeeaf97',NULL,NULL,NULL,NULL,'2025-12-05 10:12:41',NULL,'2025-12-05 10:12:41',NULL,NULL),(693,NULL,NULL,'e5f9daaf2fca47fdbcfbe5abd262e860',NULL,NULL,NULL,NULL,'2025-12-05 10:12:42',NULL,'2025-12-05 10:12:42',NULL,NULL),(694,NULL,NULL,'21e1309d538d4062b4e570e9adf457c6',NULL,NULL,NULL,NULL,'2025-12-05 10:12:44',NULL,'2025-12-05 10:12:44',NULL,NULL),(695,NULL,NULL,'77927a2b46b34bc0aa86e01eccefae86',NULL,NULL,NULL,NULL,'2025-12-05 10:12:44',NULL,'2025-12-05 10:12:44',NULL,NULL),(696,NULL,'d651189589484812ac7e974e2c86bc9a',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:12:46',NULL,'2025-12-05 10:12:46',NULL,NULL),(697,NULL,'b3bc4618821f4f30856e76f4b3843b68',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:12:47',NULL,'2025-12-05 10:12:47',NULL,NULL),(698,NULL,NULL,'5ebad41b91364fc7b58823d72e34a845',NULL,NULL,NULL,NULL,'2025-12-05 10:12:48',NULL,'2025-12-05 10:12:48',NULL,NULL),(699,NULL,'f793809ff8d548fdadb88d1a17f4a017',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:12:49',NULL,'2025-12-05 10:12:49',NULL,NULL),(700,NULL,NULL,'d59f59d0e8cf40e8b15d79772c65521a',NULL,NULL,NULL,NULL,'2025-12-05 10:12:50',NULL,'2025-12-05 10:12:50',NULL,NULL),(701,NULL,'a934fa0246d84a7588cf9bcb5c763aad',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:12:51',NULL,'2025-12-05 10:12:51',NULL,NULL),(702,NULL,NULL,'6261facab26b4ea2801a990bb51e1745',NULL,NULL,NULL,NULL,'2025-12-05 10:12:51',NULL,'2025-12-05 10:12:51',NULL,NULL),(703,NULL,'ebe30874eba14cd5bd352ff97cc61ddf',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:12:52',NULL,'2025-12-05 10:12:52',NULL,NULL),(704,NULL,NULL,'14a89074968e40cbb69c8c73a9492d34',NULL,NULL,NULL,NULL,'2025-12-05 10:12:52',NULL,'2025-12-05 10:12:52',NULL,NULL),(705,NULL,'dba761eb9482439aa79c2d9ffe5c0dfa',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:12:52',NULL,'2025-12-05 10:12:52',NULL,NULL),(706,NULL,'66efd68a4ed34b1a976a072e82fd9b38',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:12:54',NULL,'2025-12-05 10:12:54',NULL,NULL),(707,NULL,NULL,'4829299e77264cf8aa72d1a64a183d22',NULL,NULL,NULL,NULL,'2025-12-05 10:12:56',NULL,'2025-12-05 10:12:56',NULL,NULL),(708,NULL,NULL,'348d267ee53941bbbb6824e764d06b33',NULL,NULL,NULL,NULL,'2025-12-05 10:12:57',NULL,'2025-12-05 10:12:57',NULL,NULL),(709,NULL,NULL,'b576720ad2bb46dca8593baa5187080f',NULL,NULL,NULL,NULL,'2025-12-05 10:12:58',NULL,'2025-12-05 10:12:58',NULL,NULL),(710,NULL,NULL,'d2f2f827112e4b1e93fad9eb478f3294',NULL,NULL,NULL,NULL,'2025-12-05 10:12:58',NULL,'2025-12-05 10:12:58',NULL,NULL),(711,NULL,NULL,'ec07f6d521124ef683bacd50c094040c',NULL,NULL,NULL,NULL,'2025-12-05 10:12:58',NULL,'2025-12-05 10:12:58',NULL,NULL),(712,NULL,NULL,'932473ae096d4dc38e1176fe8efefe52',NULL,NULL,NULL,NULL,'2025-12-05 10:12:58',NULL,'2025-12-05 10:12:58',NULL,NULL),(713,NULL,'2c5670979c404e73ac4ce28eb4a373cc',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:12:59',NULL,'2025-12-05 10:12:59',NULL,NULL),(714,NULL,NULL,'82400d0afa4a43378786350753954e62',NULL,NULL,NULL,NULL,'2025-12-05 10:12:59',NULL,'2025-12-05 10:12:59',NULL,NULL),(715,NULL,NULL,'8a838ca5d9b94c4dbba789e07c71cbdf',NULL,NULL,NULL,NULL,'2025-12-05 10:13:00',NULL,'2025-12-05 10:13:00',NULL,NULL),(716,NULL,'870ab348edaf49d180b54cf5daaaacd1',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:04',NULL,'2025-12-05 10:13:04',NULL,NULL),(717,NULL,'d309749bb39244b781d723dd8622762c',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:04',NULL,'2025-12-05 10:13:04',NULL,NULL),(718,NULL,'c70f526bca874e278b9e8fa9cbae7937',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:06',NULL,'2025-12-05 10:13:06',NULL,NULL),(719,NULL,'b522d75174974450b2a93e831a625ae2',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:07',NULL,'2025-12-05 10:13:07',NULL,NULL),(720,NULL,'f4c34f38ddb048808ef72391bdda40b5',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:07',NULL,'2025-12-05 10:13:07',NULL,NULL),(721,NULL,'02098318982046faa2136ab12b344eb1',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:09',NULL,'2025-12-05 10:13:09',NULL,NULL),(722,NULL,'a1984fed702d4461879e97dd7c6fc401',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:11',NULL,'2025-12-05 10:13:11',NULL,NULL),(723,NULL,NULL,'266c7fc6073e499b80d4dc81edef5756',NULL,NULL,NULL,NULL,'2025-12-05 10:13:12',NULL,'2025-12-05 10:13:12',NULL,NULL),(724,NULL,NULL,'4fabd10c56794a2ebffcd9f6bdbd761f',NULL,NULL,NULL,NULL,'2025-12-05 10:13:13',NULL,'2025-12-05 10:13:13',NULL,NULL),(725,NULL,NULL,'161249ca2d1c4a32aa2e401161c8b316',NULL,NULL,NULL,NULL,'2025-12-05 10:13:13',NULL,'2025-12-05 10:13:13',NULL,NULL),(726,NULL,NULL,'8ec784f202a847df8f44ae832dfa0e96',NULL,NULL,NULL,NULL,'2025-12-05 10:13:13',NULL,'2025-12-05 10:13:13',NULL,NULL),(727,NULL,'8836b5d47df94f798d6d3133bb573972',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:14',NULL,'2025-12-05 10:13:14',NULL,NULL),(728,NULL,NULL,'9b5d98d984254565b43966665cc18803',NULL,NULL,NULL,NULL,'2025-12-05 10:13:14',NULL,'2025-12-05 10:13:14',NULL,NULL),(729,NULL,NULL,'840535cc98b849f99e8c1202bfe13e8f',NULL,NULL,NULL,NULL,'2025-12-05 10:13:14',NULL,'2025-12-05 10:13:14',NULL,NULL),(730,NULL,'a9c1d3467c214b88baae2b80598b7911',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:15',NULL,'2025-12-05 10:13:15',NULL,NULL),(731,NULL,'ae4a242539fe402abfc169fbe1fcd503',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:19',NULL,'2025-12-05 10:13:19',NULL,NULL),(732,NULL,'6ce4e8f49c6f47edb5c76db15766f5b6',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:19',NULL,'2025-12-05 10:13:19',NULL,NULL),(733,NULL,'23902f7010a04d848faa9643cd5ccd58',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:20',NULL,'2025-12-05 10:13:20',NULL,NULL),(734,NULL,'5aafe979a5eb43d3834b4d465c80bb59',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:20',NULL,'2025-12-05 10:13:20',NULL,NULL),(735,NULL,NULL,'670fcc39f5f842b1b971aafdfb055d69',NULL,NULL,NULL,NULL,'2025-12-05 10:13:24',NULL,'2025-12-05 10:13:24',NULL,NULL),(736,NULL,NULL,'7029332df14e44eb8554fb21ecce63d9',NULL,NULL,NULL,NULL,'2025-12-05 10:13:25',NULL,'2025-12-05 10:13:25',NULL,NULL),(737,NULL,'2883942e7099489585d65233752d361b',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:26',NULL,'2025-12-05 10:13:26',NULL,NULL),(738,NULL,NULL,'dd28487edb064b76be5e30c00312c61b',NULL,NULL,NULL,NULL,'2025-12-05 10:13:26',NULL,'2025-12-05 10:13:26',NULL,NULL),(739,NULL,NULL,'6111072c8292403393a078546c8a54f6',NULL,NULL,NULL,NULL,'2025-12-05 10:13:28',NULL,'2025-12-05 10:13:28',NULL,NULL),(740,NULL,NULL,'58780d3c27244579b4d28bead95bd945',NULL,NULL,NULL,NULL,'2025-12-05 10:13:28',NULL,'2025-12-05 10:13:28',NULL,NULL),(741,NULL,'7ed90e6d1b7c4872853af83191db9808',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:28',NULL,'2025-12-05 10:13:28',NULL,NULL),(742,NULL,NULL,'055e2afff9af4c64bd541b695d9c06bc',NULL,NULL,NULL,NULL,'2025-12-05 10:13:31',NULL,'2025-12-05 10:13:31',NULL,NULL),(743,NULL,NULL,'d31165c5470b4cbbb5f094c79ab12bf2',NULL,NULL,NULL,NULL,'2025-12-05 10:13:31',NULL,'2025-12-05 10:13:31',NULL,NULL),(744,NULL,'7fb1a3e2a7114f43b78f20d94b35a6b0',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:32',NULL,'2025-12-05 10:13:32',NULL,NULL),(745,NULL,'d172f7f451a3447f93053ce7e3b892e4',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:36',NULL,'2025-12-05 10:13:36',NULL,NULL),(746,NULL,NULL,'d69249cd05f14764b756127bbf1b1722',NULL,NULL,NULL,NULL,'2025-12-05 10:13:36',NULL,'2025-12-05 10:13:36',NULL,NULL),(747,NULL,NULL,'545e844e7e2d422a90cde5b0df89688b',NULL,NULL,NULL,NULL,'2025-12-05 10:13:36',NULL,'2025-12-05 10:13:36',NULL,NULL),(748,NULL,'e230ba0d257c46a2bc100d033851d6b1',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:36',NULL,'2025-12-05 10:13:36',NULL,NULL),(749,NULL,NULL,'807362560db940f7a47bceba32ab43ae',NULL,NULL,NULL,NULL,'2025-12-05 10:13:36',NULL,'2025-12-05 10:13:36',NULL,NULL),(750,NULL,NULL,'d8797dc5b44e4ad7a44d63d7699d463a',NULL,NULL,NULL,NULL,'2025-12-05 10:13:37',NULL,'2025-12-05 10:13:37',NULL,NULL),(751,NULL,NULL,'7662d0597bd948dab3f3b75ff05ff6c8',NULL,NULL,NULL,NULL,'2025-12-05 10:13:37',NULL,'2025-12-05 10:13:37',NULL,NULL),(752,NULL,'f67828d1e0ec494fbab56cc9be72430e',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:37',NULL,'2025-12-05 10:13:37',NULL,NULL),(753,NULL,NULL,'2c3c60fdbd5b4c5a87277ae7f258c80c',NULL,NULL,NULL,NULL,'2025-12-05 10:13:37',NULL,'2025-12-05 10:13:37',NULL,NULL),(754,NULL,NULL,'68c2b3f551614fdab0733d14ea838c1e',NULL,NULL,NULL,NULL,'2025-12-05 10:13:38',NULL,'2025-12-05 10:13:38',NULL,NULL),(755,NULL,'d1467f2d2dc147aa86d50ea68c6d2cb6',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:38',NULL,'2025-12-05 10:13:38',NULL,NULL),(756,NULL,NULL,'9d972c557bac460788722cbb72a5063b',NULL,NULL,NULL,NULL,'2025-12-05 10:13:39',NULL,'2025-12-05 10:13:39',NULL,NULL),(757,NULL,'4ee80ed690b748c494b807757f6e976e',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:39',NULL,'2025-12-05 10:13:39',NULL,NULL),(758,NULL,'4c561d1c6e584a9089b9e15f2f4357c8',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:39',NULL,'2025-12-05 10:13:39',NULL,NULL),(759,NULL,'1a3d7fc340f84c5699757971056327c6',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:41',NULL,'2025-12-05 10:13:41',NULL,NULL),(760,NULL,'d90e9fb6dda44d3d8ad1348645f23ac3',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:41',NULL,'2025-12-05 10:13:41',NULL,NULL),(761,NULL,NULL,'0ea4cc8ba6164d548c05a425e349004d',NULL,NULL,NULL,NULL,'2025-12-05 10:13:42',NULL,'2025-12-05 10:13:42',NULL,NULL),(762,NULL,'b1c69ad45d724b549598cb501edd48c1',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:42',NULL,'2025-12-05 10:13:42',NULL,NULL),(763,NULL,NULL,'10e3e03419094e55a70bdfb56fc50235',NULL,NULL,NULL,NULL,'2025-12-05 10:13:42',NULL,'2025-12-05 10:13:42',NULL,NULL),(764,NULL,'2fd563d743b74883ba627ca280a56ed0',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:43',NULL,'2025-12-05 10:13:43',NULL,NULL),(765,NULL,'92a4abdda216429b88886a4f95cbe2c9',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:45',NULL,'2025-12-05 10:13:45',NULL,NULL),(766,NULL,NULL,'663f12e4ac2a4bc5920588282cb91531',NULL,NULL,NULL,NULL,'2025-12-05 10:13:45',NULL,'2025-12-05 10:13:45',NULL,NULL),(767,NULL,NULL,'b8f143214ba845d5932d6732b694f5a2',NULL,NULL,NULL,NULL,'2025-12-05 10:13:46',NULL,'2025-12-05 10:13:46',NULL,NULL),(768,NULL,'d0b9547d7a05493f99d4d1894fdfe695',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:48',NULL,'2025-12-05 10:13:48',NULL,NULL),(769,NULL,'9ebf01715b344bd09f6958658f84445d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:49',NULL,'2025-12-05 10:13:49',NULL,NULL),(770,NULL,NULL,'95e284be82e145f3824262c97cf683f6',NULL,NULL,NULL,NULL,'2025-12-05 10:13:52',NULL,'2025-12-05 10:13:52',NULL,NULL),(771,NULL,NULL,'d35a82592ebd4bcfaa68325260d4853e',NULL,NULL,NULL,NULL,'2025-12-05 10:13:52',NULL,'2025-12-05 10:13:52',NULL,NULL),(772,NULL,NULL,'3b2a4211205e44e6b6bbcd0c407d8ac2',NULL,NULL,NULL,NULL,'2025-12-05 10:13:53',NULL,'2025-12-05 10:13:53',NULL,NULL),(773,NULL,'ccfd3f3427414c7f8a3d0542ae46791d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:53',NULL,'2025-12-05 10:13:53',NULL,NULL),(774,NULL,NULL,'c4ada150f5484d898f4537817e263dd1',NULL,NULL,NULL,NULL,'2025-12-05 10:13:54',NULL,'2025-12-05 10:13:54',NULL,NULL),(775,NULL,NULL,'69b8aff476fc43d1a9779493ad95325f',NULL,NULL,NULL,NULL,'2025-12-05 10:13:54',NULL,'2025-12-05 10:13:54',NULL,NULL),(776,NULL,'a5cc8e8a222a4340a4dc0e0a353a820c',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:54',NULL,'2025-12-05 10:13:54',NULL,NULL),(777,NULL,NULL,'c843ca36735c49ae8ffc69e6cd4a059d',NULL,NULL,NULL,NULL,'2025-12-05 10:13:54',NULL,'2025-12-05 10:13:54',NULL,NULL),(778,NULL,NULL,'9f81dfcd326e45478ad2e5f96ed50719',NULL,NULL,NULL,NULL,'2025-12-05 10:13:55',NULL,'2025-12-05 10:13:55',NULL,NULL),(779,NULL,'ad5bd28a707b4b8bbb146743acff6e9d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:55',NULL,'2025-12-05 10:13:55',NULL,NULL),(780,NULL,'11c68ad07fe34e07ad5a591f23d30263',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:56',NULL,'2025-12-05 10:13:56',NULL,NULL),(781,NULL,'cf4e1a69a7dc455c84735fbe39aa1717',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:56',NULL,'2025-12-05 10:13:56',NULL,NULL),(782,NULL,NULL,'4b2dede3c3644b528d36ff4975491267',NULL,NULL,NULL,NULL,'2025-12-05 10:13:57',NULL,'2025-12-05 10:13:57',NULL,NULL),(783,NULL,NULL,'b97d40ebbdee4e99b8ec71c8a34a77b2',NULL,NULL,NULL,NULL,'2025-12-05 10:13:57',NULL,'2025-12-05 10:13:57',NULL,NULL),(784,NULL,'6a3b4e4448894fb4b9dd73f5fb147066',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:58',NULL,'2025-12-05 10:13:58',NULL,NULL),(785,NULL,NULL,'7004bad281364dc6aa01a640af1f61a0',NULL,NULL,NULL,NULL,'2025-12-05 10:13:58',NULL,'2025-12-05 10:13:58',NULL,NULL),(786,NULL,'98f425b53b984a70842a8462782d8374',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:59',NULL,'2025-12-05 10:13:59',NULL,NULL),(787,NULL,NULL,'1717459cd58f495ca4e1b6ad9cd48d71',NULL,NULL,NULL,NULL,'2025-12-05 10:13:59',NULL,'2025-12-05 10:13:59',NULL,NULL),(788,NULL,NULL,'62d95604848b425d8f375397c3259405',NULL,NULL,NULL,NULL,'2025-12-05 10:13:59',NULL,'2025-12-05 10:13:59',NULL,NULL),(789,NULL,'d812ebe2a802424a8dd9d8d619c2f55a',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:13:59',NULL,'2025-12-05 10:13:59',NULL,NULL),(790,NULL,NULL,'706389e6ba60477a9ffba1402cb706f2',NULL,NULL,NULL,NULL,'2025-12-05 10:13:59',NULL,'2025-12-05 10:13:59',NULL,NULL),(791,NULL,NULL,'859f234eba4c442983333d06bc12b112',NULL,NULL,NULL,NULL,'2025-12-05 10:13:59',NULL,'2025-12-05 10:13:59',NULL,NULL),(792,NULL,'c065ac4f543d464c874b398c0079b6c2',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:14:02',NULL,'2025-12-05 10:14:02',NULL,NULL),(793,NULL,'0d15dccf4c864d558d055b0c7cd1cccc',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:14:02',NULL,'2025-12-05 10:14:02',NULL,NULL),(794,NULL,'893139ce82db4c8e9ada2a77c70752be',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:14:02',NULL,'2025-12-05 10:14:02',NULL,NULL),(795,NULL,'f664c71837fd4542885812183157a725',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:14:04',NULL,'2025-12-05 10:14:04',NULL,NULL),(796,NULL,'300b55ed0a6e4475bbabe40331abc536',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:14:06',NULL,'2025-12-05 10:14:06',NULL,NULL),(797,NULL,NULL,'8decbd3f45f34fe9940fa55d8398cd72',NULL,NULL,NULL,NULL,'2025-12-05 10:14:07',NULL,'2025-12-05 10:14:07',NULL,NULL),(798,NULL,NULL,'bfe720b194c949b8afb2fd54bab1a913',NULL,NULL,NULL,NULL,'2025-12-05 10:14:07',NULL,'2025-12-05 10:14:07',NULL,NULL),(799,NULL,NULL,'e3d69a69ad4b45469299d1089bf6b8a8',NULL,NULL,NULL,NULL,'2025-12-05 10:14:10',NULL,'2025-12-05 10:14:10',NULL,NULL),(800,NULL,'e71d3354769b40e3b68ffc1a0c753a46',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:14:11',NULL,'2025-12-05 10:14:11',NULL,NULL),(801,NULL,NULL,'a5a9ade96ddd4e5a8db72fe6f68fae59',NULL,NULL,NULL,NULL,'2025-12-05 10:14:11',NULL,'2025-12-05 10:14:11',NULL,NULL),(802,NULL,NULL,'c139691182194818afa5e150f743366b',NULL,NULL,NULL,NULL,'2025-12-05 10:14:12',NULL,'2025-12-05 10:14:12',NULL,NULL),(803,NULL,NULL,'1cf62d9873644081a5fb4745968676f6',NULL,NULL,NULL,NULL,'2025-12-05 10:14:12',NULL,'2025-12-05 10:14:12',NULL,NULL),(804,NULL,'d1b0a526e9554b979591560312c20008',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:14:12',NULL,'2025-12-05 10:14:12',NULL,NULL),(805,NULL,NULL,'2b9a0f0150304d189881e932619a3877',NULL,NULL,NULL,NULL,'2025-12-05 10:14:12',NULL,'2025-12-05 10:14:12',NULL,NULL),(806,NULL,'99a6df84d1504c33b200f7c6a254c378',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:14:13',NULL,'2025-12-05 10:14:13',NULL,NULL),(807,NULL,NULL,'794f069dba9749c3bf86866f2e725964',NULL,NULL,NULL,NULL,'2025-12-05 10:14:14',NULL,'2025-12-05 10:14:14',NULL,NULL),(808,NULL,'60007896896f4d60b8a23af4b792dcbf',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:14:15',NULL,'2025-12-05 10:14:15',NULL,NULL),(809,NULL,NULL,'8eb89d2810424dca9b976ce7bbdd928e',NULL,NULL,NULL,NULL,'2025-12-05 10:14:16',NULL,'2025-12-05 10:14:16',NULL,NULL),(810,NULL,'2fcd71efa3ce421e9e37827502621877',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:14:16',NULL,'2025-12-05 10:14:16',NULL,NULL),(811,NULL,'6a39da4c7ef247288800d24db92c81fa',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:14:17',NULL,'2025-12-05 10:14:17',NULL,NULL),(812,NULL,NULL,'07ea79a3d5b740eeb0cd19d5221ddaa0',NULL,NULL,NULL,NULL,'2025-12-05 10:14:18',NULL,'2025-12-05 10:14:18',NULL,NULL),(813,NULL,'d7beb72de9524536896541252af97cc3',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:14:18',NULL,'2025-12-05 10:14:18',NULL,NULL),(814,NULL,'594dd6d1193a428491f26732e684d8f4',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:14:26',NULL,'2025-12-05 10:14:26',NULL,NULL),(815,NULL,'cc5978fe065b4f80b1bc25ce32164997',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:14:26',NULL,'2025-12-05 10:14:26',NULL,NULL),(816,NULL,NULL,'cae073cb3f694d5d90600da4340e7272',NULL,NULL,NULL,NULL,'2025-12-05 10:14:31',NULL,'2025-12-05 10:14:31',NULL,NULL),(817,NULL,NULL,'9b744378226e4ab7a1e61805b422d97b',NULL,NULL,NULL,NULL,'2025-12-05 10:14:31',NULL,'2025-12-05 10:14:31',NULL,NULL),(818,NULL,NULL,'dbf3d5ffd4cc4a6fbd7e528451f7b7c6',NULL,NULL,NULL,NULL,'2025-12-05 10:14:31',NULL,'2025-12-05 10:14:31',NULL,NULL),(819,NULL,NULL,'86c8718a985749318e72839b9e947432',NULL,NULL,NULL,NULL,'2025-12-05 10:14:31',NULL,'2025-12-05 10:14:31',NULL,NULL),(820,NULL,NULL,'a2cea9e9f09340b392f892a9e50a81de',NULL,NULL,NULL,NULL,'2025-12-05 10:14:32',NULL,'2025-12-05 10:14:32',NULL,NULL),(821,NULL,NULL,'b7fa2ce38b4e48f7a890e36831560ee8',NULL,NULL,NULL,NULL,'2025-12-05 10:14:32',NULL,'2025-12-05 10:14:32',NULL,NULL),(822,NULL,'b0f31187a0654bfd9acade1d245b5027',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:14:33',NULL,'2025-12-05 10:14:33',NULL,NULL),(823,NULL,NULL,'1b768f7106754d3a8583ea4b52f02b54',NULL,NULL,NULL,NULL,'2025-12-05 10:14:33',NULL,'2025-12-05 10:14:33',NULL,NULL),(824,NULL,NULL,'cad5b18b2cad4beb82734c2c87ffc171',NULL,NULL,NULL,NULL,'2025-12-05 10:14:33',NULL,'2025-12-05 10:14:33',NULL,NULL),(825,NULL,'db670b71c69f432fbd42147c010399fe',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:14:34',NULL,'2025-12-05 10:14:34',NULL,NULL),(826,NULL,'948f4cc2a4cc4a368391037e336cf95c',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:14:35',NULL,'2025-12-05 10:14:35',NULL,NULL),(827,NULL,'873654f3a80143ba8e06be5e1b1d73c6',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:14:35',NULL,'2025-12-05 10:14:35',NULL,NULL),(828,NULL,'05e2c43f6e094cd78822507560372d62',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:14:37',NULL,'2025-12-05 10:14:37',NULL,NULL),(829,NULL,'40e1bd948bdb4f01851408e900510a3a',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:14:38',NULL,'2025-12-05 10:14:38',NULL,NULL),(830,NULL,NULL,'335c6eeff0b441d4a6bbd10482f48faf',NULL,NULL,NULL,NULL,'2025-12-05 10:14:43',NULL,'2025-12-05 10:14:43',NULL,NULL),(831,NULL,NULL,'9bafdb3b1fe74143a7d72b48cf0e4403',NULL,NULL,NULL,NULL,'2025-12-05 10:14:43',NULL,'2025-12-05 10:14:43',NULL,NULL),(832,NULL,NULL,'ab7b10145f344792a61697e135cec8c2',NULL,NULL,NULL,NULL,'2025-12-05 10:14:43',NULL,'2025-12-05 10:14:43',NULL,NULL),(833,NULL,'73f19c8f07954c5087b5a203e29474d9',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:14:44',NULL,'2025-12-05 10:14:44',NULL,NULL),(834,NULL,'794eae12144d44b683392db77e4b46a0',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:14:44',NULL,'2025-12-05 10:14:44',NULL,NULL),(835,NULL,NULL,'dc607a8fb4974085b29b5b37328dc83a',NULL,NULL,NULL,NULL,'2025-12-05 10:14:46',NULL,'2025-12-05 10:14:46',NULL,NULL),(836,NULL,NULL,'ac638a2a7c764f40974e739b908a93f1',NULL,NULL,NULL,NULL,'2025-12-05 10:14:47',NULL,'2025-12-05 10:14:47',NULL,NULL),(837,NULL,NULL,'0a220109ec3f455f9a4146e2ffcb204a',NULL,NULL,NULL,NULL,'2025-12-05 10:14:47',NULL,'2025-12-05 10:14:47',NULL,NULL),(838,NULL,NULL,'de109ac1205e47e585b74187d9ef9580',NULL,NULL,NULL,NULL,'2025-12-05 10:14:48',NULL,'2025-12-05 10:14:48',NULL,NULL),(839,NULL,NULL,'539fcc6276154e72ad5135c92e8004d6',NULL,NULL,NULL,NULL,'2025-12-05 10:14:48',NULL,'2025-12-05 10:14:48',NULL,NULL),(840,NULL,NULL,'8e1571491ee444128bbb2bba90317816',NULL,NULL,NULL,NULL,'2025-12-05 10:14:48',NULL,'2025-12-05 10:14:48',NULL,NULL),(841,NULL,'fb88a523f48e4990b7617051dc3491c9',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:14:49',NULL,'2025-12-05 10:14:49',NULL,NULL),(842,NULL,NULL,'417302b82a9e46e49a926841adf6ed86',NULL,NULL,NULL,NULL,'2025-12-05 10:14:49',NULL,'2025-12-05 10:14:49',NULL,NULL),(843,NULL,'1054c53c448c42f28e8e93f96384c0af',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:14:50',NULL,'2025-12-05 10:14:50',NULL,NULL),(844,NULL,'f9e2239f7b62413b97d5a4397bf9513a',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:14:50',NULL,'2025-12-05 10:14:50',NULL,NULL),(845,NULL,'96830a09587a406b831b638b22122edb',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:14:51',NULL,'2025-12-05 10:14:51',NULL,NULL),(846,NULL,'b811ef02c5ac401e9bd61dc19e516ae5',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:14:51',NULL,'2025-12-05 10:14:51',NULL,NULL),(847,NULL,'ea32398e9c294c75883ee00b0993a1e2',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:14:52',NULL,'2025-12-05 10:14:52',NULL,NULL),(848,NULL,NULL,'1494080e9f5d4e47b4bc3d3c1abf9ac3',NULL,NULL,NULL,NULL,'2025-12-05 10:14:53',NULL,'2025-12-05 10:14:53',NULL,NULL),(849,NULL,'cc402c0bcd2d46bc9b4f903d5cf4a406',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:14:58',NULL,'2025-12-05 10:14:58',NULL,NULL),(850,NULL,NULL,'6ad02c9d235547ccb4eae30fc99fd209',NULL,NULL,NULL,NULL,'2025-12-05 10:15:02',NULL,'2025-12-05 10:15:02',NULL,NULL),(851,NULL,'7ce4f8516de34d85977210f2bfca8d89',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:15:05',NULL,'2025-12-05 10:15:05',NULL,NULL),(852,NULL,NULL,'dc656680286544cfbe1d69eef0002975',NULL,NULL,NULL,NULL,'2025-12-05 10:15:08',NULL,'2025-12-05 10:15:08',NULL,NULL),(853,NULL,'828c13ab111f4c1d9f4fe33b1ba5f907',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:15:10',NULL,'2025-12-05 10:15:10',NULL,NULL),(854,NULL,NULL,'7675612818bb4a849dd9b183cc24c445',NULL,NULL,NULL,NULL,'2025-12-05 10:15:12',NULL,'2025-12-05 10:15:12',NULL,NULL),(855,NULL,NULL,'fd04e228d1eb408a9a73c48142a34a70',NULL,NULL,NULL,NULL,'2025-12-05 10:15:12',NULL,'2025-12-05 10:15:12',NULL,NULL),(856,NULL,'ab84998c5444416ba79d0d8022ce1320',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:15:13',NULL,'2025-12-05 10:15:13',NULL,NULL),(857,NULL,'c8125d7d8c2c4e869c6cf854824ed1f9',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:15:14',NULL,'2025-12-05 10:15:14',NULL,NULL),(858,NULL,NULL,'eda10b935c07465ead0909a1c82f0b4c',NULL,NULL,NULL,NULL,'2025-12-05 10:15:23',NULL,'2025-12-05 10:15:23',NULL,NULL),(859,NULL,NULL,'133c84ac2d2e49e89dad697588f566ff',NULL,NULL,NULL,NULL,'2025-12-05 10:15:24',NULL,'2025-12-05 10:15:24',NULL,NULL),(860,NULL,'1a4ef1e0bdbf479f861daafd49015589',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:15:24',NULL,'2025-12-05 10:15:24',NULL,NULL),(861,NULL,NULL,'846b850f31e94ecc99fd03ac6469acc1',NULL,NULL,NULL,NULL,'2025-12-05 10:15:25',NULL,'2025-12-05 10:15:25',NULL,NULL),(862,NULL,'8730b222fadf4a249823e59d8b326dde',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:15:25',NULL,'2025-12-05 10:15:25',NULL,NULL),(863,NULL,NULL,'9f2a6b0a4d6e49e882b2a353327f7c89',NULL,NULL,NULL,NULL,'2025-12-05 10:15:27',NULL,'2025-12-05 10:15:27',NULL,NULL),(864,NULL,NULL,'686c0fefa8fa41e489b1b4360fb66a13',NULL,NULL,NULL,NULL,'2025-12-05 10:15:28',NULL,'2025-12-05 10:15:28',NULL,NULL),(865,NULL,NULL,'bec9a7c0eb17422b9c22009c0b669d85',NULL,NULL,NULL,NULL,'2025-12-05 10:15:28',NULL,'2025-12-05 10:15:28',NULL,NULL),(866,NULL,NULL,'11c2ab36aee0493b829a4e5c9a648b33',NULL,NULL,NULL,NULL,'2025-12-05 10:15:28',NULL,'2025-12-05 10:15:28',NULL,NULL),(867,NULL,'d9ecfd3b522f49d0af3f986588ac20ec',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:15:28',NULL,'2025-12-05 10:15:28',NULL,NULL),(868,NULL,NULL,'05bea8a2829448b5ae9bbf9fea0de669',NULL,NULL,NULL,NULL,'2025-12-05 10:15:28',NULL,'2025-12-05 10:15:28',NULL,NULL),(869,NULL,'ff986ace9e434ef4858a7489b5f639d2',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:15:29',NULL,'2025-12-05 10:15:29',NULL,NULL),(870,NULL,'4e2c853cab1b45b28a9e0a95d80c438d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:15:29',NULL,'2025-12-05 10:15:29',NULL,NULL),(871,NULL,NULL,'44355f1bf7d041b79ae4db9ce4fe218d',NULL,NULL,NULL,NULL,'2025-12-05 10:15:30',NULL,'2025-12-05 10:15:30',NULL,NULL),(872,NULL,'697949cb96644dfeb8be31be03b2a3ac',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:15:30',NULL,'2025-12-05 10:15:30',NULL,NULL),(873,NULL,'addb02967ac94e01acc60341bf1062bc',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:15:31',NULL,'2025-12-05 10:15:31',NULL,NULL),(874,NULL,'ecb85ff3c88d49d6b771a6e34a36ee4c',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:15:31',NULL,'2025-12-05 10:15:31',NULL,NULL),(875,NULL,NULL,'e49f2433cca4480eb70e8b07c0b6042c',NULL,NULL,NULL,NULL,'2025-12-05 10:15:31',NULL,'2025-12-05 10:15:31',NULL,NULL),(876,NULL,NULL,'6fba3b6e03de4b7b894583e2546737d8',NULL,NULL,NULL,NULL,'2025-12-05 10:15:33',NULL,'2025-12-05 10:15:33',NULL,NULL),(877,NULL,'3ab4371f09b14d7a90f915a30e1df5a0',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:15:34',NULL,'2025-12-05 10:15:34',NULL,NULL),(878,NULL,NULL,'d369cec12ec04e22bdfa6abddaf9b93b',NULL,NULL,NULL,NULL,'2025-12-05 10:15:34',NULL,'2025-12-05 10:15:34',NULL,NULL),(879,NULL,NULL,'7675185f41de47ffb5517061c5f1c0f7',NULL,NULL,NULL,NULL,'2025-12-05 10:15:34',NULL,'2025-12-05 10:15:34',NULL,NULL),(880,NULL,NULL,'b92de181a7ba4f11a7e8cf47535f620e',NULL,NULL,NULL,NULL,'2025-12-05 10:15:34',NULL,'2025-12-05 10:15:34',NULL,NULL),(881,NULL,NULL,'fea2f4dc928446098e87059e080acd9b',NULL,NULL,NULL,NULL,'2025-12-05 10:15:34',NULL,'2025-12-05 10:15:34',NULL,NULL),(882,NULL,NULL,'6545929ffeb5432789d89cea4047c0d5',NULL,NULL,NULL,NULL,'2025-12-05 10:15:35',NULL,'2025-12-05 10:15:35',NULL,NULL),(883,NULL,NULL,'3aa78da2c3064e70a3ab5324f7b7f7ee',NULL,NULL,NULL,NULL,'2025-12-05 10:15:35',NULL,'2025-12-05 10:15:35',NULL,NULL),(884,NULL,'79f3281d6e6d4d5d83a280d0dfd5e85d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:15:35',NULL,'2025-12-05 10:15:35',NULL,NULL),(885,NULL,'367f4ef5cb8d453880af7bff7ce2ad0b',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:15:35',NULL,'2025-12-05 10:15:35',NULL,NULL),(886,NULL,'adb319e7a5f345eeabc757f1c6532ff0',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:15:36',NULL,'2025-12-05 10:15:36',NULL,NULL),(887,NULL,'6d94bc7509b24568a2640a3b256f7ca9',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:15:36',NULL,'2025-12-05 10:15:36',NULL,NULL),(888,NULL,'9d30aef9a1a4449f82832ccd3ce2ff79',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:15:38',NULL,'2025-12-05 10:15:38',NULL,NULL),(889,NULL,'24fb8ea1707e4b159768856358a2abe3',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:15:38',NULL,'2025-12-05 10:15:38',NULL,NULL),(890,NULL,NULL,'5f82d1656fa54475b75328f6966b5ff9',NULL,NULL,NULL,NULL,'2025-12-05 10:15:38',NULL,'2025-12-05 10:15:38',NULL,NULL),(891,NULL,NULL,'de4f72688a1d4351a2a8bd889ac81b72',NULL,NULL,NULL,NULL,'2025-12-05 10:15:38',NULL,'2025-12-05 10:15:38',NULL,NULL),(892,NULL,NULL,'e334235ca6ae4ca494906db53e96c057',NULL,NULL,NULL,NULL,'2025-12-05 10:15:40',NULL,'2025-12-05 10:15:40',NULL,NULL),(893,NULL,'6751cc99a8e24a7c9ee32cec7b9fd8fa',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:15:40',NULL,'2025-12-05 10:15:40',NULL,NULL),(894,NULL,'77eedf2155d948abbea44c8aa454c38f',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:15:41',NULL,'2025-12-05 10:15:41',NULL,NULL),(895,NULL,NULL,'8c95b42a11ae4b2ca59be36067b7e35c',NULL,NULL,NULL,NULL,'2025-12-05 10:15:44',NULL,'2025-12-05 10:15:44',NULL,NULL),(896,NULL,NULL,'46124856c8364323aa59de391520aa73',NULL,NULL,NULL,NULL,'2025-12-05 10:15:44',NULL,'2025-12-05 10:15:44',NULL,NULL),(897,NULL,NULL,'b0599b274457424d92abb17130bd8521',NULL,NULL,NULL,NULL,'2025-12-05 10:15:45',NULL,'2025-12-05 10:15:45',NULL,NULL),(898,NULL,'c2c66bea319748f696485854e7041763',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:15:45',NULL,'2025-12-05 10:15:45',NULL,NULL),(899,NULL,'a38e5b15f93c49e59ce8c975359be2e3',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:15:46',NULL,'2025-12-05 10:15:46',NULL,NULL),(900,NULL,'cdac11f493eb4468a33360efeb72f1a9',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:15:46',NULL,'2025-12-05 10:15:46',NULL,NULL),(901,NULL,NULL,'bdf78d29c91e4e688ca128f908d1ac94',NULL,NULL,NULL,NULL,'2025-12-05 10:15:47',NULL,'2025-12-05 10:15:47',NULL,NULL),(902,NULL,NULL,'cfea40fc33b94f25b36bdb3392ed794f',NULL,NULL,NULL,NULL,'2025-12-05 10:15:47',NULL,'2025-12-05 10:15:47',NULL,NULL),(903,NULL,NULL,'d81b90efc7534e8cbfc59c39b640f7c0',NULL,NULL,NULL,NULL,'2025-12-05 10:15:47',NULL,'2025-12-05 10:15:47',NULL,NULL),(904,NULL,NULL,'f8bfe046188245baa31e7d032ddcba95',NULL,NULL,NULL,NULL,'2025-12-05 10:15:51',NULL,'2025-12-05 10:15:51',NULL,NULL),(905,NULL,NULL,'4edb9e162596465d85f22c925f1ba5d2',NULL,NULL,NULL,NULL,'2025-12-05 10:15:51',NULL,'2025-12-05 10:15:51',NULL,NULL),(906,NULL,NULL,'7cbff371b9e243ea8583439ab3b11bfa',NULL,NULL,NULL,NULL,'2025-12-05 10:15:51',NULL,'2025-12-05 10:15:51',NULL,NULL),(907,NULL,NULL,'511e3103be1b46e09a3e7a3953fc36a7',NULL,NULL,NULL,NULL,'2025-12-05 10:15:52',NULL,'2025-12-05 10:15:52',NULL,NULL),(908,NULL,'9e9673896b4c45879e7be92aa54d651c',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:15:52',NULL,'2025-12-05 10:15:52',NULL,NULL),(909,NULL,NULL,'ae23d780cb6649c0ab7c884a0d711e81',NULL,NULL,NULL,NULL,'2025-12-05 10:15:55',NULL,'2025-12-05 10:15:55',NULL,NULL),(910,NULL,'da51670c86b34de2bdf5d104b5fd688c',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:15:55',NULL,'2025-12-05 10:15:55',NULL,NULL),(911,NULL,'7fc281a5c6444d42ab0654732948ba9d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:15:56',NULL,'2025-12-05 10:15:56',NULL,NULL),(912,NULL,'5f8762be426b4881a7606bac0cdf0790',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:15:59',NULL,'2025-12-05 10:15:59',NULL,NULL),(913,NULL,'8687dc3eee0040e79eeca2d91dd79941',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:16:00',NULL,'2025-12-05 10:16:00',NULL,NULL),(914,NULL,'03c6de342ca54bbe8809c2d180c4f2e3',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:16:00',NULL,'2025-12-05 10:16:00',NULL,NULL),(915,NULL,'e4d1ac40f3a5418da57b6c9aae443366',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:16:00',NULL,'2025-12-05 10:16:00',NULL,NULL),(916,NULL,NULL,'05c17479e802415a96fd4349edca80f5',NULL,NULL,NULL,NULL,'2025-12-05 10:16:02',NULL,'2025-12-05 10:16:02',NULL,NULL),(917,NULL,'8b109165230e44c1b7f681c3125d68eb',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:16:03',NULL,'2025-12-05 10:16:03',NULL,NULL),(918,NULL,NULL,'80e7c8127f6d421d9de1713e7fc7ca8a',NULL,NULL,NULL,NULL,'2025-12-05 10:16:05',NULL,'2025-12-05 10:16:05',NULL,NULL),(919,NULL,'065f130be98144c1bcf5da58b9d50dba',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:16:06',NULL,'2025-12-05 10:16:06',NULL,NULL),(920,NULL,NULL,'108cca3d6b42436c8dfa7346f0e2a7e1',NULL,NULL,NULL,NULL,'2025-12-05 10:16:06',NULL,'2025-12-05 10:16:06',NULL,NULL),(921,NULL,NULL,'56e13a6e5136430c91e8af8760aa2ef4',NULL,NULL,NULL,NULL,'2025-12-05 10:16:06',NULL,'2025-12-05 10:16:06',NULL,NULL),(922,NULL,NULL,'4f9847eafc834176b52e5c274757a634',NULL,NULL,NULL,NULL,'2025-12-05 10:16:06',NULL,'2025-12-05 10:16:06',NULL,NULL),(923,NULL,NULL,'06e155545dd1477fb8fc5814477485a2',NULL,NULL,NULL,NULL,'2025-12-05 10:16:06',NULL,'2025-12-05 10:16:06',NULL,NULL),(924,NULL,'f83026a05cd94543bc2cfa196e903342',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:16:08',NULL,'2025-12-05 10:16:08',NULL,NULL),(925,NULL,'a6c2386f78e14952b1fbd20f25c1343a',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:16:09',NULL,'2025-12-05 10:16:09',NULL,NULL),(926,NULL,'21f8c5a5071f4b0da11d0e8d9105e144',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:16:10',NULL,'2025-12-05 10:16:10',NULL,NULL),(927,NULL,NULL,'b36dfd3363184111af20acb3ebaee28a',NULL,NULL,NULL,NULL,'2025-12-05 10:16:15',NULL,'2025-12-05 10:16:15',NULL,NULL),(928,NULL,NULL,'fedb79f7f8c145758ff2ac290b215f07',NULL,NULL,NULL,NULL,'2025-12-05 10:16:15',NULL,'2025-12-05 10:16:15',NULL,NULL),(929,NULL,'ee708d36384c422aad0ff42f0242e9cf',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:16:16',NULL,'2025-12-05 10:16:16',NULL,NULL),(930,NULL,'690e4eb239f74a63b6e3912f76a7c695',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:16:17',NULL,'2025-12-05 10:16:17',NULL,NULL),(931,NULL,NULL,'21e510ca5b77470a984d7e72db0e6d6d',NULL,NULL,NULL,NULL,'2025-12-05 10:16:21',NULL,'2025-12-05 10:16:21',NULL,NULL),(932,NULL,NULL,'c836cf20c2c14810865813e55508c27f',NULL,NULL,NULL,NULL,'2025-12-05 10:16:24',NULL,'2025-12-05 10:16:24',NULL,NULL),(933,NULL,NULL,'c9f23a27327c4baca2fddcfeb92d238d',NULL,NULL,NULL,NULL,'2025-12-05 10:16:24',NULL,'2025-12-05 10:16:24',NULL,NULL),(934,NULL,'1efe543e7dd140a68379ac9297f6766e',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:16:25',NULL,'2025-12-05 10:16:25',NULL,NULL),(935,NULL,'86adc92ecf4e492cbe37cc410ae29e2f',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:16:26',NULL,'2025-12-05 10:16:26',NULL,NULL),(936,NULL,NULL,'0ab0e0dead37412ebd73c839224d4687',NULL,NULL,NULL,NULL,'2025-12-05 10:16:27',NULL,'2025-12-05 10:16:27',NULL,NULL),(937,NULL,NULL,'da5f9f401e724974994df75a1fa437c9',NULL,NULL,NULL,NULL,'2025-12-05 10:16:28',NULL,'2025-12-05 10:16:28',NULL,NULL),(938,NULL,NULL,'70a48536be5e446bac33e55a6381f3a7',NULL,NULL,NULL,NULL,'2025-12-05 10:16:28',NULL,'2025-12-05 10:16:28',NULL,NULL),(939,NULL,NULL,'2cfd0c3d17c04617a1ecad3139d80b84',NULL,NULL,NULL,NULL,'2025-12-05 10:16:28',NULL,'2025-12-05 10:16:28',NULL,NULL),(940,NULL,NULL,'de2f844b04bf40cb837ae11647ae92f5',NULL,NULL,NULL,NULL,'2025-12-05 10:16:28',NULL,'2025-12-05 10:16:28',NULL,NULL),(941,NULL,'ebf51e9cd741494484f25cc0c15bc318',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:16:28',NULL,'2025-12-05 10:16:28',NULL,NULL),(942,NULL,'7e41dd64e87040b78808ceec2922943a',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:16:29',NULL,'2025-12-05 10:16:29',NULL,NULL),(943,NULL,'f7b8edf748474f229021023aa6b8e28a',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:16:30',NULL,'2025-12-05 10:16:30',NULL,NULL),(944,NULL,'e7033a26c5f24acbbb25cfa856732f7c',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:16:30',NULL,'2025-12-05 10:16:30',NULL,NULL),(945,NULL,'8da1c784fc4b4ebda25d83b31a62a8b2',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:16:31',NULL,'2025-12-05 10:16:31',NULL,NULL),(946,NULL,NULL,'2a880b5455b140f49e94b72fa40e1fa4',NULL,NULL,NULL,NULL,'2025-12-05 10:16:32',NULL,'2025-12-05 10:16:32',NULL,NULL),(947,NULL,NULL,'c0c1389a544d4e9eb4d3328951cb6ffe',NULL,NULL,NULL,NULL,'2025-12-05 10:16:32',NULL,'2025-12-05 10:16:32',NULL,NULL),(948,NULL,NULL,'2439d74261074d5b97a90ff52a050203',NULL,NULL,NULL,NULL,'2025-12-05 10:16:33',NULL,'2025-12-05 10:16:33',NULL,NULL),(949,NULL,'ca51bf8141824cad9d5dcaf468d3909b',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:16:33',NULL,'2025-12-05 10:16:33',NULL,NULL),(950,NULL,'3812183b01fd466ca3aa8527c7d03dfc',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:16:35',NULL,'2025-12-05 10:16:35',NULL,NULL),(951,NULL,'544a0b6087e144d99b839586e216dd9a',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:16:35',NULL,'2025-12-05 10:16:35',NULL,NULL),(952,NULL,NULL,'11adfe5af13245a6a0b9936038a6ad75',NULL,NULL,NULL,NULL,'2025-12-05 10:16:36',NULL,'2025-12-05 10:16:36',NULL,NULL),(953,NULL,NULL,'b40e6bc592b2454baf9276a67d2c0a4c',NULL,NULL,NULL,NULL,'2025-12-05 10:16:37',NULL,'2025-12-05 10:16:37',NULL,NULL),(954,NULL,NULL,'beec874770db49c196e6e704fe7211d9',NULL,NULL,NULL,NULL,'2025-12-05 10:16:37',NULL,'2025-12-05 10:16:37',NULL,NULL),(955,NULL,'6e13bd6588024fceb061c7b89f32e81d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:16:37',NULL,'2025-12-05 10:16:37',NULL,NULL),(956,NULL,NULL,'eae4a363dc954be2a90e7be5f4afe5ba',NULL,NULL,NULL,NULL,'2025-12-05 10:16:37',NULL,'2025-12-05 10:16:37',NULL,NULL),(957,NULL,NULL,'be0348f2bfeb48c195bdd0a35b847ead',NULL,NULL,NULL,NULL,'2025-12-05 10:16:38',NULL,'2025-12-05 10:16:38',NULL,NULL),(958,NULL,NULL,'5ef20e23df6445fd9823c353393892de',NULL,NULL,NULL,NULL,'2025-12-05 10:16:38',NULL,'2025-12-05 10:16:38',NULL,NULL),(959,NULL,'9aa7567c848947bcb5ea460cd1164308',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:16:39',NULL,'2025-12-05 10:16:39',NULL,NULL),(960,NULL,'4f03132c2d4147d985cf1094acbca5ea',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:16:39',NULL,'2025-12-05 10:16:39',NULL,NULL),(961,NULL,'86ef6c5dc1f040a8b67b31bc6f6dc5dd',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:16:39',NULL,'2025-12-05 10:16:39',NULL,NULL),(962,NULL,NULL,'7b5373df4cff4082a66ba510ec5c035b',NULL,NULL,NULL,NULL,'2025-12-05 10:16:39',NULL,'2025-12-05 10:16:39',NULL,NULL),(963,NULL,'8ad5635b186d42959828cd464792ed74',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:16:43',NULL,'2025-12-05 10:16:43',NULL,NULL),(964,NULL,'56caa18f7b6e4db394f385a2e76c009a',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:16:43',NULL,'2025-12-05 10:16:43',NULL,NULL),(965,NULL,'771387297cb444958fe2202a60906940',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:16:43',NULL,'2025-12-05 10:16:43',NULL,NULL),(966,NULL,NULL,'38aaa3385ceb4283b13ec17e73a872e8',NULL,NULL,NULL,NULL,'2025-12-05 10:16:45',NULL,'2025-12-05 10:16:45',NULL,NULL),(967,NULL,'0871903283e143cb94fa7e166e389f92',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:16:46',NULL,'2025-12-05 10:16:46',NULL,NULL),(968,NULL,NULL,'54ea334b025445379af9833a9c219695',NULL,NULL,NULL,NULL,'2025-12-05 10:16:51',NULL,'2025-12-05 10:16:51',NULL,NULL),(969,NULL,'b0b002e8666a4d4c8dd3481cd357bc82',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:16:52',NULL,'2025-12-05 10:16:52',NULL,NULL),(970,NULL,NULL,'f8d6871f2fcd42028f91d192a8c40bb5',NULL,NULL,NULL,NULL,'2025-12-05 10:16:55',NULL,'2025-12-05 10:16:55',NULL,NULL),(971,NULL,NULL,'1cbac882b1644084a19927eef4c7b1b7',NULL,NULL,NULL,NULL,'2025-12-05 10:16:59',NULL,'2025-12-05 10:16:59',NULL,NULL),(972,NULL,NULL,'e5307a17cb1a443bb1ad0ff24f0e6636',NULL,NULL,NULL,NULL,'2025-12-05 10:16:59',NULL,'2025-12-05 10:16:59',NULL,NULL),(973,NULL,NULL,'17c2bb95441046da97cf36012b57fcca',NULL,NULL,NULL,NULL,'2025-12-05 10:16:59',NULL,'2025-12-05 10:16:59',NULL,NULL),(974,NULL,'f25750db06134f8aacceb278328fb8fe',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:17:00',NULL,'2025-12-05 10:17:00',NULL,NULL),(975,NULL,'ce38d31c75764d08b9ff383a5b08c451',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:17:01',NULL,'2025-12-05 10:17:01',NULL,NULL),(976,NULL,'332890acf0b74cbdb2c168d4e718fa79',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:17:01',NULL,'2025-12-05 10:17:01',NULL,NULL),(977,NULL,NULL,'e5e8e9612f364064a6174ec28a4ee206',NULL,NULL,NULL,NULL,'2025-12-05 10:17:03',NULL,'2025-12-05 10:17:03',NULL,NULL),(978,NULL,NULL,'da392b272b0346d4a13b76abc12277ca',NULL,NULL,NULL,NULL,'2025-12-05 10:17:03',NULL,'2025-12-05 10:17:03',NULL,NULL),(979,NULL,NULL,'a7ac0e41db7a42cbb54f9c62db62f6c4',NULL,NULL,NULL,NULL,'2025-12-05 10:17:03',NULL,'2025-12-05 10:17:03',NULL,NULL),(980,NULL,NULL,'2c095ca2f57a4194b6a3df6f6a056fc2',NULL,NULL,NULL,NULL,'2025-12-05 10:17:03',NULL,'2025-12-05 10:17:03',NULL,NULL),(981,NULL,'d088e308e3994594b72dd5ba899ec7e3',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:17:05',NULL,'2025-12-05 10:17:05',NULL,NULL),(982,NULL,'b700789cc0e949dc8ed0dac73d798a9f',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:17:05',NULL,'2025-12-05 10:17:05',NULL,NULL),(983,NULL,'5e9a7e52b379438eab65d860aa70af42',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:17:06',NULL,'2025-12-05 10:17:06',NULL,NULL),(984,NULL,'269e1fd30a1a41628cf4a5beda6d6241',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:17:08',NULL,'2025-12-05 10:17:08',NULL,NULL),(985,NULL,NULL,'cf09659585aa4e2595600e517f2851c8',NULL,NULL,NULL,NULL,'2025-12-05 10:17:13',NULL,'2025-12-05 10:17:13',NULL,NULL),(986,NULL,NULL,'b03c3ae2207f436988f4484be2681293',NULL,NULL,NULL,NULL,'2025-12-05 10:17:13',NULL,'2025-12-05 10:17:13',NULL,NULL),(987,NULL,NULL,'ca81838811e947b399918a02121ace5d',NULL,NULL,NULL,NULL,'2025-12-05 10:17:13',NULL,'2025-12-05 10:17:13',NULL,NULL),(988,NULL,NULL,'1837aa795236434caed8a8c45562761a',NULL,NULL,NULL,NULL,'2025-12-05 10:17:13',NULL,'2025-12-05 10:17:13',NULL,NULL),(989,NULL,NULL,'ad18d3493be9434a849a1d8089e49230',NULL,NULL,NULL,NULL,'2025-12-05 10:17:14',NULL,'2025-12-05 10:17:14',NULL,NULL),(990,NULL,'26fbbb6f1f704464a375d21a411f0a11',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:17:14',NULL,'2025-12-05 10:17:14',NULL,NULL),(991,NULL,'e11aaf40e8a94062a1a39889867f457e',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:17:15',NULL,'2025-12-05 10:17:15',NULL,NULL),(992,NULL,'e77e6d24b9a747f0b1c65c8147cd0689',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:17:15',NULL,'2025-12-05 10:17:15',NULL,NULL),(993,NULL,NULL,'200ee8c18ff6435daa9c445d3fbba22c',NULL,NULL,NULL,NULL,'2025-12-05 10:17:17',NULL,'2025-12-05 10:17:17',NULL,NULL),(994,NULL,NULL,'5ca2b35e07f3497d9b1d7b059c9af8bb',NULL,NULL,NULL,NULL,'2025-12-05 10:17:18',NULL,'2025-12-05 10:17:18',NULL,NULL),(995,NULL,NULL,'3865f05f3e23430a93570d762672ddd6',NULL,NULL,NULL,NULL,'2025-12-05 10:17:18',NULL,'2025-12-05 10:17:18',NULL,NULL),(996,NULL,NULL,'a2074ac299fc4eebb364da9f4323590b',NULL,NULL,NULL,NULL,'2025-12-05 10:17:18',NULL,'2025-12-05 10:17:18',NULL,NULL),(997,NULL,'5c5c3f8b021942ef9bcd418fa56c9c5a',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:17:19',NULL,'2025-12-05 10:17:19',NULL,NULL),(998,NULL,'e050ba2712f04bd3acdd2e831e7705fc',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:17:19',NULL,'2025-12-05 10:17:19',NULL,NULL),(999,NULL,'175210be70e14bda86d1bac3778b7f23',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:17:20',NULL,'2025-12-05 10:17:20',NULL,NULL),(1000,NULL,'a3eea4a6622c48f09ff188191a5042a0',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:17:21',NULL,'2025-12-05 10:17:21',NULL,NULL),(1001,NULL,NULL,'68cc5a352dac44af8c5cec5e0c4f7cd3',NULL,NULL,NULL,NULL,'2025-12-05 10:17:21',NULL,'2025-12-05 10:17:21',NULL,NULL),(1002,NULL,'013cfae2f98141bb887d3eacee237767',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:17:23',NULL,'2025-12-05 10:17:23',NULL,NULL),(1003,NULL,NULL,'eb4ed35b656a42be92961194a72a1762',NULL,NULL,NULL,NULL,'2025-12-05 10:17:26',NULL,'2025-12-05 10:17:26',NULL,NULL),(1004,NULL,'ab53dfd170eb4e43846d9daa13797aa7',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:17:28',NULL,'2025-12-05 10:17:28',NULL,NULL),(1005,NULL,NULL,'7c359e7731404377b73acb33379be5ef',NULL,NULL,NULL,NULL,'2025-12-05 10:17:31',NULL,'2025-12-05 10:17:31',NULL,NULL),(1006,NULL,'d02a2354251b4d57ba03f6fafee08b9b',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:17:32',NULL,'2025-12-05 10:17:32',NULL,NULL),(1007,NULL,NULL,'d007e182323c4166ae32d211a322934d',NULL,NULL,NULL,NULL,'2025-12-05 10:17:34',NULL,'2025-12-05 10:17:34',NULL,NULL),(1008,NULL,'b35afd5775844fc18e8198ef45a8eb5d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:17:35',NULL,'2025-12-05 10:17:35',NULL,NULL),(1009,NULL,NULL,'df5801c0743a4bee946697903fb243d2',NULL,NULL,NULL,NULL,'2025-12-05 10:17:48',NULL,'2025-12-05 10:17:48',NULL,NULL),(1010,NULL,NULL,'9e2c189f05ce404b944c41a78d754674',NULL,NULL,NULL,NULL,'2025-12-05 10:17:48',NULL,'2025-12-05 10:17:48',NULL,NULL),(1011,NULL,NULL,'c1c1850b8e6d4f43aa6fe0276225946d',NULL,NULL,NULL,NULL,'2025-12-05 10:17:51',NULL,'2025-12-05 10:17:51',NULL,NULL),(1012,NULL,NULL,'0ff92d5a0a37444d8985d7ebb998fac5',NULL,NULL,NULL,NULL,'2025-12-05 10:17:51',NULL,'2025-12-05 10:17:51',NULL,NULL),(1013,NULL,NULL,'7379b91b514e401ebca891980151c71f',NULL,NULL,NULL,NULL,'2025-12-05 10:17:52',NULL,'2025-12-05 10:17:52',NULL,NULL),(1014,NULL,'e84757d2e0654c10bccbcccc63871bb4',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:17:53',NULL,'2025-12-05 10:17:53',NULL,NULL),(1015,NULL,'702f5d76a7514945a7e621e4e93fb7f0',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:17:53',NULL,'2025-12-05 10:17:53',NULL,NULL),(1016,NULL,'b8c7ad1a5ade4b1eba46a714be024931',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:17:55',NULL,'2025-12-05 10:17:55',NULL,NULL),(1017,NULL,NULL,'26fe7579bfdb46f489eb7a9a7dba3ea8',NULL,NULL,NULL,NULL,'2025-12-05 10:17:58',NULL,'2025-12-05 10:17:58',NULL,NULL),(1018,NULL,'654f7d6340ba4106be8189aa6b713316',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:17:59',NULL,'2025-12-05 10:17:59',NULL,NULL),(1019,NULL,NULL,'07df57f2247a47d4bd454007daad7cb2',NULL,NULL,NULL,NULL,'2025-12-05 10:18:01',NULL,'2025-12-05 10:18:01',NULL,NULL),(1020,NULL,'b33bb860f67d445e985f6ff2d7af55b8',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:18:02',NULL,'2025-12-05 10:18:02',NULL,NULL),(1021,NULL,NULL,'f34e9001817644028ed7f6c7d26688fd',NULL,NULL,NULL,NULL,'2025-12-05 10:18:04',NULL,'2025-12-05 10:18:04',NULL,NULL),(1022,NULL,'52723d3b051e4562b5179b91adfd4771',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:18:05',NULL,'2025-12-05 10:18:05',NULL,NULL),(1023,NULL,NULL,'804f72ea352749e6b14b7de833c51099',NULL,NULL,NULL,NULL,'2025-12-05 10:18:07',NULL,'2025-12-05 10:18:07',NULL,NULL),(1024,NULL,'6f333acb3a1e475cb4cbc151a7b441f2',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:18:09',NULL,'2025-12-05 10:18:09',NULL,NULL),(1025,NULL,NULL,'8c637ff67ef640d19beab3c57f8fd94d',NULL,NULL,NULL,NULL,'2025-12-05 10:18:18',NULL,'2025-12-05 10:18:18',NULL,NULL),(1026,NULL,NULL,'0ff687168bfe48e9a0ff2725af5ddd2c',NULL,NULL,NULL,NULL,'2025-12-05 10:18:21',NULL,'2025-12-05 10:18:21',NULL,NULL),(1027,NULL,NULL,'5f9d9c0fd96348e1a99d9f96b59450fc',NULL,NULL,NULL,NULL,'2025-12-05 10:18:21',NULL,'2025-12-05 10:18:21',NULL,NULL),(1028,NULL,NULL,'2bc981ccf16e42389cb3f33cc8e9f52f',NULL,NULL,NULL,NULL,'2025-12-05 10:18:21',NULL,'2025-12-05 10:18:21',NULL,NULL),(1029,NULL,'035acd1808a24d3ba5107c79cf2b51c5',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:18:23',NULL,'2025-12-05 10:18:23',NULL,NULL),(1030,NULL,NULL,'675a6cc004734cfeaac8e670fa288294',NULL,NULL,NULL,NULL,'2025-12-05 10:18:23',NULL,'2025-12-05 10:18:23',NULL,NULL),(1031,NULL,'76cdaf6292524bbba2e673b2f99b0c1b',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:18:24',NULL,'2025-12-05 10:18:24',NULL,NULL),(1032,NULL,'1f21e7e53d6347d5b4115944db13e5b3',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:18:25',NULL,'2025-12-05 10:18:25',NULL,NULL),(1033,NULL,'499b14cd90ca42a0aa6c88165774ed5f',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:18:25',NULL,'2025-12-05 10:18:25',NULL,NULL),(1034,NULL,NULL,'169a8491334f43a298cc04facc7d3b2e',NULL,NULL,NULL,NULL,'2025-12-05 10:18:29',NULL,'2025-12-05 10:18:29',NULL,NULL),(1035,NULL,NULL,'3d07b0daf6bf4b87a2ce945c0c6aa589',NULL,NULL,NULL,NULL,'2025-12-05 10:18:29',NULL,'2025-12-05 10:18:29',NULL,NULL),(1036,NULL,'af5a639003e24f09b8489ea02f308e0f',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:18:30',NULL,'2025-12-05 10:18:30',NULL,NULL),(1037,NULL,NULL,'1907dec059304958ad047313a5707dcc',NULL,NULL,NULL,NULL,'2025-12-05 10:18:30',NULL,'2025-12-05 10:18:30',NULL,NULL),(1038,NULL,NULL,'3fcc4f528dea4a69ab99736b79b4e0a6',NULL,NULL,NULL,NULL,'2025-12-05 10:18:30',NULL,'2025-12-05 10:18:30',NULL,NULL),(1039,NULL,'080c7340f1314c6a8594ab191f7cd011',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:18:31',NULL,'2025-12-05 10:18:31',NULL,NULL),(1040,NULL,NULL,'b28e36a0969a47248ee7cb3e469c187b',NULL,NULL,NULL,NULL,'2025-12-05 10:18:31',NULL,'2025-12-05 10:18:31',NULL,NULL),(1041,NULL,NULL,'9328fb0b73eb47f48b66dba0e6d19193',NULL,NULL,NULL,NULL,'2025-12-05 10:18:31',NULL,'2025-12-05 10:18:31',NULL,NULL),(1042,NULL,'d8a3533c444645e48bdbe6d56415a88a',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:18:32',NULL,'2025-12-05 10:18:32',NULL,NULL),(1043,NULL,'3f13af0d327f495a8306bcf770e6f893',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:18:33',NULL,'2025-12-05 10:18:33',NULL,NULL),(1044,NULL,NULL,'2021de136acc44d6a68274d1f6a9eccc',NULL,NULL,NULL,NULL,'2025-12-05 10:18:33',NULL,'2025-12-05 10:18:33',NULL,NULL),(1045,NULL,'a20b5eb8f4d3473796d73939a2c0288f',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:18:34',NULL,'2025-12-05 10:18:34',NULL,NULL),(1046,NULL,NULL,'0a892d7a0540429ba23646d4a938bfe8',NULL,NULL,NULL,NULL,'2025-12-05 10:18:37',NULL,'2025-12-05 10:18:37',NULL,NULL),(1047,NULL,NULL,'ca37362520ec4be4b2c5c0d6215c7e54',NULL,NULL,NULL,NULL,'2025-12-05 10:18:37',NULL,'2025-12-05 10:18:37',NULL,NULL),(1048,NULL,NULL,'00a0a8781d234949af1eadac1c886a6d',NULL,NULL,NULL,NULL,'2025-12-05 10:18:37',NULL,'2025-12-05 10:18:37',NULL,NULL),(1049,NULL,'936526e0386a47f8bccf10fdfea00f57',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:18:39',NULL,'2025-12-05 10:18:39',NULL,NULL),(1050,NULL,'cb07feed0f09452a9e2089165e2d0474',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:18:40',NULL,'2025-12-05 10:18:40',NULL,NULL),(1051,NULL,NULL,'0b795e7702e342d9821a3667644be5b0',NULL,NULL,NULL,NULL,'2025-12-05 10:18:40',NULL,'2025-12-05 10:18:40',NULL,NULL),(1052,NULL,'713485f6825d4fbb96a3a6dfd0cac4e0',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:18:41',NULL,'2025-12-05 10:18:41',NULL,NULL),(1053,NULL,'3554a89b305c449f9fd292eca5647512',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:18:41',NULL,'2025-12-05 10:18:41',NULL,NULL),(1054,NULL,NULL,'e267d2189f9b4ac68e7e89d73b1fb972',NULL,NULL,NULL,NULL,'2025-12-05 10:18:43',NULL,'2025-12-05 10:18:43',NULL,NULL),(1055,NULL,'acab1432361c4f4bac2a9e74d82af43c',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:18:45',NULL,'2025-12-05 10:18:45',NULL,NULL),(1056,NULL,NULL,'3489c3e2b0cf4c2885444e78fcd573c5',NULL,NULL,NULL,NULL,'2025-12-05 10:18:47',NULL,'2025-12-05 10:18:47',NULL,NULL),(1057,NULL,NULL,'37e38e02429644e7997f0e5306d51d6c',NULL,NULL,NULL,NULL,'2025-12-05 10:18:47',NULL,'2025-12-05 10:18:47',NULL,NULL),(1058,NULL,'479b844250bd442fbc27325400fc3e10',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:18:48',NULL,'2025-12-05 10:18:48',NULL,NULL),(1059,NULL,'022061b9c7ab41728d780aed0d6cf2ae',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:18:49',NULL,'2025-12-05 10:18:49',NULL,NULL),(1060,NULL,NULL,'5fd1a631b8a345b2b49c864c21c57503',NULL,NULL,NULL,NULL,'2025-12-05 10:18:57',NULL,'2025-12-05 10:18:57',NULL,NULL),(1061,NULL,NULL,'50a9638631304c4081afc56769d0cda7',NULL,NULL,NULL,NULL,'2025-12-05 10:18:57',NULL,'2025-12-05 10:18:57',NULL,NULL),(1062,NULL,NULL,'1d470b129f164636a516b8fa4a0518ab',NULL,NULL,NULL,NULL,'2025-12-05 10:18:57',NULL,'2025-12-05 10:18:57',NULL,NULL),(1063,NULL,NULL,'3414669a87724d09b807b578e82f441a',NULL,NULL,NULL,NULL,'2025-12-05 10:18:58',NULL,'2025-12-05 10:18:58',NULL,NULL),(1064,NULL,'4c7b0facc285420ca7d8d6571d699978',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:18:59',NULL,'2025-12-05 10:18:59',NULL,NULL),(1065,NULL,'43c99e00d6374e98868e8b8ead703200',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:19:00',NULL,'2025-12-05 10:19:00',NULL,NULL),(1066,NULL,'900dd785fb2f4798a767a49535f46801',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:19:01',NULL,'2025-12-05 10:19:01',NULL,NULL),(1067,NULL,NULL,'d6551741e4194f5f8646c7b6e321b4ed',NULL,NULL,NULL,NULL,'2025-12-05 10:19:03',NULL,'2025-12-05 10:19:03',NULL,NULL),(1068,NULL,'081feba9dde642f4af5966ca072a782c',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:19:03',NULL,'2025-12-05 10:19:03',NULL,NULL),(1069,NULL,NULL,'a919c62139a04af6b41e759c3cff355d',NULL,NULL,NULL,NULL,'2025-12-05 10:19:17',NULL,'2025-12-05 10:19:17',NULL,NULL),(1070,NULL,NULL,'0cae89584b954da8bbeb73eca8518688',NULL,NULL,NULL,NULL,'2025-12-05 10:19:18',NULL,'2025-12-05 10:19:18',NULL,NULL),(1071,NULL,NULL,'688857a6058f4da98af54f1d05a199a0',NULL,NULL,NULL,NULL,'2025-12-05 10:19:18',NULL,'2025-12-05 10:19:18',NULL,NULL),(1072,NULL,NULL,'5a10004599a341b2af30dbc53d405ad3',NULL,NULL,NULL,NULL,'2025-12-05 10:19:18',NULL,'2025-12-05 10:19:18',NULL,NULL),(1073,NULL,'b99bdfc04b17402d9e9657b2d127764a',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:19:20',NULL,'2025-12-05 10:19:20',NULL,NULL),(1074,NULL,'0d97e7eb0cd3414b977f0074a00f3d71',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:19:20',NULL,'2025-12-05 10:19:20',NULL,NULL),(1075,NULL,'0324648a65a343649c4079ef816ceb9e',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:19:21',NULL,'2025-12-05 10:19:21',NULL,NULL),(1076,NULL,NULL,'99b84712a8ab47a29d9f3b43ea8ee992',NULL,NULL,NULL,NULL,'2025-12-05 10:19:33',NULL,'2025-12-05 10:19:33',NULL,NULL),(1077,NULL,NULL,'4b78495b66f74849aa4036e9963317b5',NULL,NULL,NULL,NULL,'2025-12-05 10:19:39',NULL,'2025-12-05 10:19:39',NULL,NULL),(1078,NULL,NULL,'6ecf71f844db4e2a9f78b7e6ac47e932',NULL,NULL,NULL,NULL,'2025-12-05 10:19:40',NULL,'2025-12-05 10:19:40',NULL,NULL),(1079,NULL,NULL,'f2a2f80640e548e9bf2861fe2340dea7',NULL,NULL,NULL,NULL,'2025-12-05 10:19:40',NULL,'2025-12-05 10:19:40',NULL,NULL),(1080,NULL,'5cfc1fc534d14037bb409353e3cc74a6',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:19:41',NULL,'2025-12-05 10:19:41',NULL,NULL),(1081,NULL,'0c49dd29b8614b2eaf9fceb202e68003',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:19:41',NULL,'2025-12-05 10:19:41',NULL,NULL),(1082,NULL,NULL,'2150e2e9985942e98ecd4ba9bf2f7997',NULL,NULL,NULL,NULL,'2025-12-05 10:19:41',NULL,'2025-12-05 10:19:41',NULL,NULL),(1083,NULL,'a6e8880ab10e4b26b0074c6f9b06aca3',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:19:42',NULL,'2025-12-05 10:19:42',NULL,NULL),(1084,NULL,'36845157f5fd45bbabab2ab7b1c6f643',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:19:42',NULL,'2025-12-05 10:19:42',NULL,NULL),(1085,NULL,NULL,'5b3c02910af24b6899a39a579cd1aa61',NULL,NULL,NULL,NULL,'2025-12-05 10:19:44',NULL,'2025-12-05 10:19:44',NULL,NULL),(1086,NULL,'0c38696d93824dddb5be06ba2bf0b06a',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:19:46',NULL,'2025-12-05 10:19:46',NULL,NULL),(1087,NULL,NULL,'d0186e704225499c8ebb62a422c7481b',NULL,NULL,NULL,NULL,'2025-12-05 10:19:52',NULL,'2025-12-05 10:19:52',NULL,NULL),(1088,NULL,NULL,'a3cbf4bf3f5448d9b87b413ba3bb65ce',NULL,NULL,NULL,NULL,'2025-12-05 10:19:55',NULL,'2025-12-05 10:19:55',NULL,NULL),(1089,NULL,'9fcf3ede86ab43049896ebebf70bf286',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:19:57',NULL,'2025-12-05 10:19:57',NULL,NULL),(1090,NULL,NULL,'48c071afb6b4441dbadeb32daa6f0611',NULL,NULL,NULL,NULL,'2025-12-05 10:19:58',NULL,'2025-12-05 10:19:58',NULL,NULL),(1091,NULL,NULL,'4e8a3457d2334195bdb194ba45067da6',NULL,NULL,NULL,NULL,'2025-12-05 10:19:59',NULL,'2025-12-05 10:19:59',NULL,NULL),(1092,NULL,NULL,'63c9a1b44fa44f4aac63637d97e30184',NULL,NULL,NULL,NULL,'2025-12-05 10:19:59',NULL,'2025-12-05 10:19:59',NULL,NULL),(1093,NULL,'c1ecc993dd0d4bd78005db93dca023b4',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:20:01',NULL,'2025-12-05 10:20:01',NULL,NULL),(1094,NULL,'b90b5af65ed14863b39a3b50fe7f8212',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:20:01',NULL,'2025-12-05 10:20:01',NULL,NULL),(1095,NULL,'16559cfa326348a5a3bc11fcd235a33d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:20:02',NULL,'2025-12-05 10:20:02',NULL,NULL),(1096,NULL,NULL,'046422ab73e34edfb3be52f83593f4e2',NULL,NULL,NULL,NULL,'2025-12-05 10:20:02',NULL,'2025-12-05 10:20:02',NULL,NULL),(1097,NULL,NULL,'f291569ff6be472299b8dea4c99a5591',NULL,NULL,NULL,NULL,'2025-12-05 10:20:03',NULL,'2025-12-05 10:20:03',NULL,NULL),(1098,NULL,NULL,'3cd92f50798246a79d2283a4f7018c8e',NULL,NULL,NULL,NULL,'2025-12-05 10:20:03',NULL,'2025-12-05 10:20:03',NULL,NULL),(1099,NULL,NULL,'1e379b60026d4873bfd8c84e159f4274',NULL,NULL,NULL,NULL,'2025-12-05 10:20:03',NULL,'2025-12-05 10:20:03',NULL,NULL),(1100,NULL,'57a0dd3400c748d09a55e1237d92104f',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:20:06',NULL,'2025-12-05 10:20:06',NULL,NULL),(1101,NULL,'79d06f9838b34c83a6fcb2137a484684',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:20:08',NULL,'2025-12-05 10:20:08',NULL,NULL),(1102,NULL,'59e349b17eab43769a466a8f473d4e11',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:20:09',NULL,'2025-12-05 10:20:09',NULL,NULL),(1103,NULL,NULL,'14d519ef4ff8470e97b485645c34f74a',NULL,NULL,NULL,NULL,'2025-12-05 10:20:14',NULL,'2025-12-05 10:20:14',NULL,NULL),(1104,NULL,NULL,'f28e0347159b47fcb8fed2b53f9fc85f',NULL,NULL,NULL,NULL,'2025-12-05 10:20:14',NULL,'2025-12-05 10:20:14',NULL,NULL),(1105,NULL,NULL,'b595e50847534056921b345fcbf6a4df',NULL,NULL,NULL,NULL,'2025-12-05 10:20:14',NULL,'2025-12-05 10:20:14',NULL,NULL),(1106,NULL,NULL,'05d78d1fe1e4445f945b74259bde6da0',NULL,NULL,NULL,NULL,'2025-12-05 10:20:14',NULL,'2025-12-05 10:20:14',NULL,NULL),(1107,NULL,'ea4cd0e44bc84f26a8affa6c73fe3674',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:20:17',NULL,'2025-12-05 10:20:17',NULL,NULL),(1108,NULL,'921f918c0282432980adab3ae44e62b8',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:20:17',NULL,'2025-12-05 10:20:17',NULL,NULL),(1109,NULL,'bd8557ff2790440a9da6c5eb843ede47',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:20:18',NULL,'2025-12-05 10:20:18',NULL,NULL),(1110,NULL,NULL,'51afabf9c9384af6b7f7722cd6dcb72e',NULL,NULL,NULL,NULL,'2025-12-05 10:20:23',NULL,'2025-12-05 10:20:23',NULL,NULL),(1111,NULL,NULL,'d9fb981f169d4a6586e7bcf77c01b3b1',NULL,NULL,NULL,NULL,'2025-12-05 10:20:23',NULL,'2025-12-05 10:20:23',NULL,NULL),(1112,NULL,NULL,'9a42408940084b86970011d178ba626b',NULL,NULL,NULL,NULL,'2025-12-05 10:20:23',NULL,'2025-12-05 10:20:23',NULL,NULL),(1113,NULL,NULL,'8c8ab64f42724b299abc0fd3859fb4ea',NULL,NULL,NULL,NULL,'2025-12-05 10:20:23',NULL,'2025-12-05 10:20:23',NULL,NULL),(1114,NULL,'a67e460d3c4a42648dd18ce2fd92a2dd',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:20:24',NULL,'2025-12-05 10:20:24',NULL,NULL),(1115,NULL,'323232b1ef774516bb9835d61a10039d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:20:25',NULL,'2025-12-05 10:20:25',NULL,NULL),(1116,NULL,'8b9229591efb499dbbaf2bd447bd2c4a',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:20:25',NULL,'2025-12-05 10:20:25',NULL,NULL),(1117,NULL,NULL,'a0ee5b26b8b54891b86684ceee48d8b2',NULL,NULL,NULL,NULL,'2025-12-05 10:20:27',NULL,'2025-12-05 10:20:27',NULL,NULL),(1118,NULL,NULL,'1a427475854141e7928911c644a3e8dc',NULL,NULL,NULL,NULL,'2025-12-05 10:20:27',NULL,'2025-12-05 10:20:27',NULL,NULL),(1119,NULL,NULL,'97412b14aa6e43a0bb611f58485bcdae',NULL,NULL,NULL,NULL,'2025-12-05 10:20:28',NULL,'2025-12-05 10:20:28',NULL,NULL),(1120,NULL,'6a6515f8ed454214adcd4a8b77e529f7',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:20:31',NULL,'2025-12-05 10:20:31',NULL,NULL),(1121,NULL,NULL,'ba3df4d4a04d48799dbe5857afbc06c9',NULL,NULL,NULL,NULL,'2025-12-05 10:20:34',NULL,'2025-12-05 10:20:34',NULL,NULL),(1122,NULL,NULL,'9b51b8b266214665bebc6aeb7d5ae049',NULL,NULL,NULL,NULL,'2025-12-05 10:20:34',NULL,'2025-12-05 10:20:34',NULL,NULL),(1123,NULL,NULL,'160c920634b54a61a99247a2e666b370',NULL,NULL,NULL,NULL,'2025-12-05 10:20:35',NULL,'2025-12-05 10:20:35',NULL,NULL),(1124,NULL,'c455436f0b224432b343daa073ce8103',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:20:36',NULL,'2025-12-05 10:20:36',NULL,NULL),(1125,NULL,'29a9b4bcb11046fd9363a18f47a98311',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:20:37',NULL,'2025-12-05 10:20:37',NULL,NULL),(1126,NULL,'362b693fa42f4124be6d6249e2b9052d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:20:38',NULL,'2025-12-05 10:20:38',NULL,NULL),(1127,NULL,NULL,'0c7b8cb3192840b8ac99c14299b00f03',NULL,NULL,NULL,NULL,'2025-12-05 10:20:43',NULL,'2025-12-05 10:20:43',NULL,NULL),(1128,NULL,NULL,'b3e7d6b3509a4d04abdca47a67ec6d23',NULL,NULL,NULL,NULL,'2025-12-05 10:20:43',NULL,'2025-12-05 10:20:43',NULL,NULL),(1129,NULL,NULL,'7b9dfb8217b24607882ae367073ac971',NULL,NULL,NULL,NULL,'2025-12-05 10:20:43',NULL,'2025-12-05 10:20:43',NULL,NULL),(1130,NULL,NULL,'c0f4a7abdf7c4cd48c02d6dc81c5ee45',NULL,NULL,NULL,NULL,'2025-12-05 10:20:43',NULL,'2025-12-05 10:20:43',NULL,NULL),(1131,NULL,'715784d51e004d80b37f9df74e8d8bbd',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:20:45',NULL,'2025-12-05 10:20:45',NULL,NULL),(1132,NULL,'fc8708b435ac498486b3a387c7cfac02',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:20:45',NULL,'2025-12-05 10:20:45',NULL,NULL),(1133,NULL,'63dc79f6c8874af99dd82ed2e4f9f001',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:20:47',NULL,'2025-12-05 10:20:47',NULL,NULL),(1134,NULL,NULL,'7be893eee967467685e34554c175f051',NULL,NULL,NULL,NULL,'2025-12-05 10:20:52',NULL,'2025-12-05 10:20:52',NULL,NULL),(1135,NULL,NULL,'291dd4805ac146169da2a25d1b0dde38',NULL,NULL,NULL,NULL,'2025-12-05 10:20:52',NULL,'2025-12-05 10:20:52',NULL,NULL),(1136,NULL,NULL,'d28849030314469d8dc6f69a604ddc77',NULL,NULL,NULL,NULL,'2025-12-05 10:20:52',NULL,'2025-12-05 10:20:52',NULL,NULL),(1137,NULL,NULL,'63b37186fb404f6b8d19ed707482e1c8',NULL,NULL,NULL,NULL,'2025-12-05 10:20:52',NULL,'2025-12-05 10:20:52',NULL,NULL),(1138,NULL,NULL,'49f885e23bb14414a4ec149709305042',NULL,NULL,NULL,NULL,'2025-12-05 10:20:53',NULL,'2025-12-05 10:20:53',NULL,NULL),(1139,NULL,NULL,'4698fca8037c4b40b2bf78c3bede664f',NULL,NULL,NULL,NULL,'2025-12-05 10:20:53',NULL,'2025-12-05 10:20:53',NULL,NULL),(1140,NULL,NULL,'6c1fae775eaa4aa68b5b22781fd7e1f4',NULL,NULL,NULL,NULL,'2025-12-05 10:20:53',NULL,'2025-12-05 10:20:53',NULL,NULL),(1141,NULL,'e27281ec227f4bdb979d86bbbcf368c6',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:20:54',NULL,'2025-12-05 10:20:54',NULL,NULL),(1142,NULL,NULL,'b8dd703029a345569f6d6dd4d5338d17',NULL,NULL,NULL,NULL,'2025-12-05 10:20:54',NULL,'2025-12-05 10:20:54',NULL,NULL),(1143,NULL,'beb500b1ccbc45ecb181246b3bcaced4',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:20:55',NULL,'2025-12-05 10:20:55',NULL,NULL),(1144,NULL,'62a839cbd28b4d4c9718df6c5ca52772',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:20:56',NULL,'2025-12-05 10:20:56',NULL,NULL),(1145,NULL,'534780b7ce734a5f8f37f88d88a9c904',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:20:56',NULL,'2025-12-05 10:20:56',NULL,NULL),(1146,NULL,'d647dfc905dd4e75a1953ab710082839',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:20:57',NULL,'2025-12-05 10:20:57',NULL,NULL),(1147,NULL,'8ed1cd86022e4a84893c0b31beb17753',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:20:58',NULL,'2025-12-05 10:20:58',NULL,NULL),(1148,NULL,NULL,'b0e6daa2bafb47eb9011f6e1f3e6d875',NULL,NULL,NULL,NULL,'2025-12-05 10:21:03',NULL,'2025-12-05 10:21:03',NULL,NULL),(1149,NULL,NULL,'a092cf37b8e944d09171c8b9fa5fefe7',NULL,NULL,NULL,NULL,'2025-12-05 10:21:03',NULL,'2025-12-05 10:21:03',NULL,NULL),(1150,NULL,NULL,'eaa16ec98a1b484e99e544071f82f629',NULL,NULL,NULL,NULL,'2025-12-05 10:21:03',NULL,'2025-12-05 10:21:03',NULL,NULL),(1151,NULL,NULL,'1b9e16806d6646e285bb5585c24a4262',NULL,NULL,NULL,NULL,'2025-12-05 10:21:03',NULL,'2025-12-05 10:21:03',NULL,NULL),(1152,NULL,'910371658800428388557bb9d9498518',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:21:04',NULL,'2025-12-05 10:21:04',NULL,NULL),(1153,NULL,'36a7c661e4ff4960b042bffd55f623ca',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:21:05',NULL,'2025-12-05 10:21:05',NULL,NULL),(1154,NULL,'cdbb4fddaa1e445ba7e889a9b491f37b',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:21:07',NULL,'2025-12-05 10:21:07',NULL,NULL),(1155,NULL,NULL,'afd4f6ecc1224d90973dcf922a08d9f0',NULL,NULL,NULL,NULL,'2025-12-05 10:21:15',NULL,'2025-12-05 10:21:15',NULL,NULL),(1156,NULL,NULL,'bf8217e37d4d4f2a8ea60c020d0155e5',NULL,NULL,NULL,NULL,'2025-12-05 10:21:18',NULL,'2025-12-05 10:21:18',NULL,NULL),(1157,NULL,NULL,'20307d45ecf04a21b65383ef4ce32d62',NULL,NULL,NULL,NULL,'2025-12-05 10:21:26',NULL,'2025-12-05 10:21:26',NULL,NULL),(1158,NULL,NULL,'73bb7afab3ec49bc86f448fe79cc58c0',NULL,NULL,NULL,NULL,'2025-12-05 10:21:32',NULL,'2025-12-05 10:21:32',NULL,NULL),(1159,NULL,NULL,'caf786b25c984bba8c42aaf23a65d35a',NULL,NULL,NULL,NULL,'2025-12-05 10:21:37',NULL,'2025-12-05 10:21:37',NULL,NULL),(1160,NULL,NULL,'f9f1f0b395c744abbc0941121b23414f',NULL,NULL,NULL,NULL,'2025-12-05 10:21:37',NULL,'2025-12-05 10:21:37',NULL,NULL),(1161,NULL,NULL,'5db88f48d0ce4d14a42411e6cbb4ff21',NULL,NULL,NULL,NULL,'2025-12-05 10:21:37',NULL,'2025-12-05 10:21:37',NULL,NULL),(1162,NULL,NULL,'83d43470bc454edcb1136038d5a24ba3',NULL,NULL,NULL,NULL,'2025-12-05 10:21:38',NULL,'2025-12-05 10:21:38',NULL,NULL),(1163,NULL,'c56e614b7c264987be360f3e3f41d258',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:21:43',NULL,'2025-12-05 10:21:43',NULL,NULL),(1164,NULL,'ddd149290d0d43acaceda0e214199ffc',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:21:43',NULL,'2025-12-05 10:21:43',NULL,NULL),(1165,NULL,'ff01b1fb8854411888962fb65304795e',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:21:44',NULL,'2025-12-05 10:21:44',NULL,NULL),(1166,NULL,'2b038a8ecbdf404492d891ee8c35362a',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:21:44',NULL,'2025-12-05 10:21:44',NULL,NULL),(1167,NULL,'0117b15a2d1b47a4a57983d2ac3e17a4',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:21:44',NULL,'2025-12-05 10:21:44',NULL,NULL),(1168,NULL,'98a351ccfaf84f89a20dd4e677bd4cca',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:21:44',NULL,'2025-12-05 10:21:44',NULL,NULL),(1169,NULL,NULL,'e2b7e8de49384638870a7d8b6b6a222b',NULL,NULL,NULL,NULL,'2025-12-05 10:23:03',NULL,'2025-12-05 10:23:03',NULL,NULL),(1170,NULL,NULL,'b546e386e67a402faab37db407ed0840',NULL,NULL,NULL,NULL,'2025-12-05 10:23:03',NULL,'2025-12-05 10:23:03',NULL,NULL),(1171,NULL,NULL,'e8fdb18df19f48589034c5e8a27dd576',NULL,NULL,NULL,NULL,'2025-12-05 10:23:04',NULL,'2025-12-05 10:23:04',NULL,NULL),(1172,NULL,NULL,'87773ba183b647f6acb6f853c0c02596',NULL,NULL,NULL,NULL,'2025-12-05 10:23:04',NULL,'2025-12-05 10:23:04',NULL,NULL),(1173,NULL,'3d0d3d09a9b047f89d4da743c48c5277',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:23:05',NULL,'2025-12-05 10:23:05',NULL,NULL),(1174,NULL,'e188fd721aac47a28104704da7cec32d',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:23:06',NULL,'2025-12-05 10:23:06',NULL,NULL),(1175,NULL,'cbabb735305c4928a591373165dbbc6e',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:23:06',NULL,'2025-12-05 10:23:06',NULL,NULL),(1176,NULL,NULL,'44c45d14395442c3b54e3f006846e518',NULL,NULL,NULL,NULL,'2025-12-05 10:24:24',NULL,'2025-12-05 10:24:24',NULL,NULL),(1177,NULL,NULL,'40927528a3a44526a3d3553d7c3ce0de',NULL,NULL,NULL,NULL,'2025-12-05 10:24:41',NULL,'2025-12-05 10:24:41',NULL,NULL),(1178,NULL,NULL,'3939ebdf3e7044fca1f8a57f762ad218',NULL,NULL,NULL,NULL,'2025-12-05 10:24:42',NULL,'2025-12-05 10:24:42',NULL,NULL),(1179,NULL,NULL,'b7e18b69b99b4a89b9257100db73806b',NULL,NULL,NULL,NULL,'2025-12-05 10:24:42',NULL,'2025-12-05 10:24:42',NULL,NULL),(1180,NULL,'19467570f0874da2a60c18ecff7bda2e',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:24:43',NULL,'2025-12-05 10:24:43',NULL,NULL),(1181,NULL,'c9211fc4da2444a0a88e6dc6c5178a23',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:24:44',NULL,'2025-12-05 10:24:44',NULL,NULL),(1182,NULL,'596b7e671c35403f99de02e5c49f77e2',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:24:44',NULL,'2025-12-05 10:24:44',NULL,NULL),(1183,NULL,NULL,'bee3e9f8c6e649c99c9479b4a384f5d9',NULL,NULL,NULL,NULL,'2025-12-05 10:25:40',NULL,'2025-12-05 10:25:40',NULL,NULL),(1184,NULL,NULL,'74265aa1d78a4e7b88e6d5a3f456ee7f',NULL,NULL,NULL,NULL,'2025-12-05 10:25:47',NULL,'2025-12-05 10:25:47',NULL,NULL),(1185,NULL,NULL,'0738e086fa904ad1a1a607eeab8bdbf3',NULL,NULL,NULL,NULL,'2025-12-05 10:25:47',NULL,'2025-12-05 10:25:47',NULL,NULL),(1186,NULL,NULL,'9d7f464fb4954467af88e531b0b6f93d',NULL,NULL,NULL,NULL,'2025-12-05 10:25:47',NULL,'2025-12-05 10:25:47',NULL,NULL),(1187,NULL,'a93d1077167f40f596118bcee919f6d6',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:25:50',NULL,'2025-12-05 10:25:50',NULL,NULL),(1188,NULL,'36912d7f29d447c599e209c5c44b5e67',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:25:51',NULL,'2025-12-05 10:25:51',NULL,NULL),(1189,NULL,'e4cb8c5b886d45bbb78a2a71333bef38',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:25:51',NULL,'2025-12-05 10:25:51',NULL,NULL),(1190,NULL,NULL,'4002749d527c4a598681017d30696f88',NULL,NULL,NULL,NULL,'2025-12-05 10:26:16',NULL,'2025-12-05 10:26:16',NULL,NULL),(1191,NULL,NULL,'9162904f23a24ab7af89d7341508e1af',NULL,NULL,NULL,NULL,'2025-12-05 10:26:23',NULL,'2025-12-05 10:26:23',NULL,NULL),(1192,NULL,NULL,'fe8d75ea691e4bcd837d57c702b2d067',NULL,NULL,NULL,NULL,'2025-12-05 10:26:23',NULL,'2025-12-05 10:26:23',NULL,NULL),(1193,NULL,NULL,'c21d52158f1a42b4b36eb914851918d1',NULL,NULL,NULL,NULL,'2025-12-05 10:26:24',NULL,'2025-12-05 10:26:24',NULL,NULL),(1194,NULL,'628e72969b2d419882e3fc9d2f3b79bd',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:26:31',NULL,'2025-12-05 10:26:31',NULL,NULL),(1195,NULL,'1b1027ddb74e491bafa6159b7271fc19',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:26:33',NULL,'2025-12-05 10:26:33',NULL,NULL),(1196,NULL,'4449f83142e34bd587691a836b6932e6',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:26:37',NULL,'2025-12-05 10:26:37',NULL,NULL),(1197,NULL,NULL,'678646a7ca884a08b448e1d21acd9de0',NULL,NULL,NULL,NULL,'2025-12-05 10:27:19',NULL,'2025-12-05 10:27:19',NULL,NULL),(1198,NULL,NULL,'f7f2d21195f54f85b695a8c8a5d77cbb',NULL,NULL,NULL,NULL,'2025-12-05 10:27:19',NULL,'2025-12-05 10:27:19',NULL,NULL),(1199,NULL,'315f092d02d9417ea7002196e3bc5e51',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:27:20',NULL,'2025-12-05 10:27:20',NULL,NULL),(1200,NULL,'0be5dd7ec9b24465a8f2ecd5c831c9a3',NULL,NULL,NULL,NULL,NULL,'2025-12-05 10:27:20',NULL,'2025-12-05 10:27:20',NULL,NULL);
/*!40000 ALTER TABLE `revocation_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL DEFAULT '<<null>>',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_role_name_domain_id` (`name`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` (`id`, `name`, `extra`, `domain_id`, `description`) VALUES ('78622b7bbc8f46b7b0a9596c4a004541','service','{}','<<null>>',NULL),('7916e044bcf34487a9b74f7f04815821','heat_stack_user','{}','<<null>>',NULL),('b208df568e2841389a4c6b7f2dd8d0ac','ResellerAdmin','{}','<<null>>',NULL),('be54ca0e2dad4a50b717b5923253282e','member','{}','<<null>>',NULL),('d5a08343f01848eebeaab396b47858fc','reader','{}','<<null>>',NULL),('df759038f40d48b3be7f96de8bbe7ce2','admin','{}','<<null>>',NULL),('e7195513afd14f3589bb5b7e39607914','swiftoperator','{}','<<null>>',NULL);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_option`
--

DROP TABLE IF EXISTS `role_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_option` (
  `role_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`role_id`,`option_id`),
  CONSTRAINT `role_option_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_option`
--

LOCK TABLES `role_option` WRITE;
/*!40000 ALTER TABLE `role_option` DISABLE KEYS */;
INSERT INTO `role_option` (`role_id`, `option_id`, `option_value`) VALUES ('be54ca0e2dad4a50b717b5923253282e','IMMU','true'),('d5a08343f01848eebeaab396b47858fc','IMMU','true'),('df759038f40d48b3be7f96de8bbe7ce2','IMMU','true');
/*!40000 ALTER TABLE `role_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sensitive_config`
--

DROP TABLE IF EXISTS `sensitive_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sensitive_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sensitive_config`
--

LOCK TABLES `sensitive_config` WRITE;
/*!40000 ALTER TABLE `sensitive_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sensitive_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `type`, `enabled`, `extra`) VALUES ('02ebdc8511e642ce9753c3f60955e546','placement',1,'{\"description\": \"Placement Service\", \"name\": \"placement\"}'),('181b92abad9b470ca3313135478c10c0','orchestration',1,'{\"description\": \"Heat API service\", \"name\": \"heat\"}'),('1a4486e1802b4976b31f5b7af5591bc6','alarming',1,'{\"description\": \"Aodh for autoscaling Service\", \"name\": \"aodh\"}'),('1b5477ba46f94a87bfaa9c76d47046e8','image',1,'{\"description\": \"Glance Service\", \"name\": \"glance\"}'),('1be4ee5d3cbf4e6ab9185f63ddd9d31e','Ceilometer',1,'{\"description\": \"Ceilometer Service\", \"name\": \"ceilometer\"}'),('34c74b3d81a34484bd5b4ee2857b5e3d','compute',1,'{\"description\": \"Nova Compute Service\", \"name\": \"nova\"}'),('4922d58dda33436386801373647b7932','cloudformation',1,'{\"description\": \"Heat Cloudformation API service\", \"name\": \"heat-cfn\"}'),('89334965953845ef9c42ac6a49d48cda','identity',1,'{\"name\": \"keystone\"}'),('b431fb91ad1c4a61b30a97ea23bbc6b1','share',1,'{\"description\": \"Manila V1 Service\", \"name\": \"manila\"}'),('cc05d015e74042adbe4281b27c963cf8','key-manager',1,'{\"description\": \"Barbican Service\", \"name\": \"barbican\"}'),('df803d9bf7594244a01aefd5189d7901','volumev3',1,'{\"description\": \"Cinder V3 Service\", \"name\": \"cinderv3\"}'),('f154f6d0d4b84d73abfceb7c68c2243d','sharev2',1,'{\"description\": \"Manila V2 Service\", \"name\": \"manilav2\"}'),('fb0fb29385ba4a0f8b242fbc3ba096b2','network',1,'{\"description\": \"Openstack Networking\", \"name\": \"neutron\"}');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_provider`
--

DROP TABLE IF EXISTS `service_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_provider` (
  `auth_url` varchar(256) NOT NULL,
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `sp_url` varchar(256) NOT NULL,
  `relay_state_prefix` varchar(256) NOT NULL DEFAULT 'ss:mem:',
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_provider`
--

LOCK TABLES `service_provider` WRITE;
/*!40000 ALTER TABLE `service_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `service_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_assignment`
--

DROP TABLE IF EXISTS `system_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_assignment` (
  `type` varchar(64) NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`inherited` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_assignment`
--

LOCK TABLES `system_assignment` WRITE;
/*!40000 ALTER TABLE `system_assignment` DISABLE KEYS */;
INSERT INTO `system_assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserSystem','52d0a54dc45b4c4caaba721ba3202150','system','df759038f40d48b3be7f96de8bbe7ce2',0);
/*!40000 ALTER TABLE `system_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `token`
--

DROP TABLE IF EXISTS `token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `token` (
  `id` varchar(64) NOT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_token_expires` (`expires`),
  KEY `ix_token_expires_valid` (`expires`,`valid`),
  KEY `ix_token_user_id` (`user_id`),
  KEY `ix_token_trust_id` (`trust_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`valid` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `token`
--

LOCK TABLES `token` WRITE;
/*!40000 ALTER TABLE `token` DISABLE KEYS */;
/*!40000 ALTER TABLE `token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust`
--

DROP TABLE IF EXISTS `trust`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust` (
  `id` varchar(64) NOT NULL,
  `trustor_user_id` varchar(64) NOT NULL,
  `trustee_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `impersonation` tinyint(1) NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `remaining_uses` int(11) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `redelegated_trust_id` varchar(64) DEFAULT NULL,
  `redelegation_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `duplicate_trust_constraint_expanded` (`trustor_user_id`,`trustee_user_id`,`project_id`,`impersonation`,`expires_at`,`expires_at_int`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`impersonation` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust`
--

LOCK TABLES `trust` WRITE;
/*!40000 ALTER TABLE `trust` DISABLE KEYS */;
INSERT INTO `trust` (`id`, `trustor_user_id`, `trustee_user_id`, `project_id`, `impersonation`, `deleted_at`, `expires_at`, `remaining_uses`, `extra`, `expires_at_int`, `redelegated_trust_id`, `redelegation_count`) VALUES ('1930a47253ce4c8c88636663d1b59032','1ac77399695145f4b401c88ed4229925','3fe10f4071aa4da9b901c4d77885d555','ae79bc62d86a492e8cda59f6b8938e47',1,'2025-12-05 10:07:05',NULL,NULL,'{\"roles\": [{\"id\": \"3b045af7563842fa8f63e14027a426cd\"}]}',NULL,NULL,0),('39c19c345aea42dbb16831ecff4aec54','086354ea74af4fcab0c9697cd30e01cc','3fe10f4071aa4da9b901c4d77885d555','b8245ba92a3b487abd797418e5023607',1,'2025-12-05 10:07:09','2025-12-05 11:07:07',NULL,'{\"roles\": [{\"id\": \"6353693a086042db9992830d625c65d0\"}]}',1764932827000000,NULL,0),('5df0e7baba2545a4a9f43a2980ab50fa','39a285ce132b4bf787c6ae32146984b0','3fe10f4071aa4da9b901c4d77885d555','c92e0c9361a0481ebbe32cdeb6733c32',0,'2025-12-05 10:07:22',NULL,NULL,'{\"roles\": [{\"id\": \"53ee7a9f11ff49f28c2e01acbd42147a\"}]}',NULL,NULL,0),('ce627c75d8414cf7b599bc3e67c755be','ba802a00bb2e4b0c938a577df963a212','3fe10f4071aa4da9b901c4d77885d555','6d6626d603d34312b9aff4024f13d27c',1,'2025-12-05 10:07:01',NULL,NULL,'{\"roles\": [{\"id\": \"de5b3ebaddc74ddba0c43f007331477d\"}]}',NULL,NULL,0),('f5a6b65001f8445089ceeaec1334a036','6ec08a2f37fc480a9f10f119483c1a9a','3fe10f4071aa4da9b901c4d77885d555','fb01f3dbe6b64117994493a61e528801',1,'2025-12-05 10:07:17',NULL,NULL,'{\"roles\": [{\"id\": \"40f5e231a46a4b8b89ed536b9ffe06f6\"}]}',NULL,NULL,0);
/*!40000 ALTER TABLE `trust` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust_role`
--

DROP TABLE IF EXISTS `trust_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust_role` (
  `trust_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`trust_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust_role`
--

LOCK TABLES `trust_role` WRITE;
/*!40000 ALTER TABLE `trust_role` DISABLE KEYS */;
INSERT INTO `trust_role` (`trust_id`, `role_id`) VALUES ('1930a47253ce4c8c88636663d1b59032','3b045af7563842fa8f63e14027a426cd'),('39c19c345aea42dbb16831ecff4aec54','6353693a086042db9992830d625c65d0'),('5df0e7baba2545a4a9f43a2980ab50fa','53ee7a9f11ff49f28c2e01acbd42147a'),('ce627c75d8414cf7b599bc3e67c755be','de5b3ebaddc74ddba0c43f007331477d'),('f5a6b65001f8445089ceeaec1334a036','40f5e231a46a4b8b89ed536b9ffe06f6');
/*!40000 ALTER TABLE `trust_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `default_project_id` varchar(64) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_active_at` date DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_user_id_domain_id` (`id`,`domain_id`),
  KEY `domain_id` (`domain_id`),
  KEY `ix_default_project_id` (`default_project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `extra`, `enabled`, `default_project_id`, `created_at`, `last_active_at`, `domain_id`) VALUES ('1008d93aa8e5428d9ae7863f6801bc28','{\"email\": \"glance@localhost\", \"description\": null}',1,NULL,'2025-12-05 08:20:31','2025-12-05','default'),('1789cb75c8f44c539966d084bb392cb1','{\"email\": \"nova@localhost\", \"description\": null}',1,NULL,'2025-12-05 08:20:41','2025-12-05','default'),('24fbdd67d1a2407797e942da6f8af7b2','{\"email\": \"aodh@localhost\", \"description\": null}',1,NULL,'2025-12-05 08:20:29','2025-12-05','default'),('3e3a327ce1e742268657f8c677b2e8a7','{\"email\": \"placement@localhost\", \"description\": null}',1,NULL,'2025-12-05 08:20:42','2025-12-05','default'),('442d3397f2c048d7b9064f5b951ba2b0','{\"email\": \"heat@localhost\", \"description\": null}',1,NULL,'2025-12-05 08:20:31','2025-12-05','default'),('52d0a54dc45b4c4caaba721ba3202150','{\"email\": \"admin@localhost\"}',1,NULL,'2025-12-05 08:18:10','2025-12-05','default'),('5d9e23101adb47c8a382d2ba6db3edaa','{\"email\": \"cinder@localhost\", \"description\": null}',1,NULL,'2025-12-05 08:20:30','2025-12-05','default'),('5f941ee4287e4dd1af0beb25dc9578ad','{\"email\": \"manilav2@localhost\", \"description\": null}',1,NULL,'2025-12-05 08:20:41',NULL,'default'),('6741e6cd4bee46c5ad024e6e59d0c98d','{\"email\": \"heat_stack_domain_admin@localhost\", \"description\": null}',1,NULL,'2025-12-05 08:20:32',NULL,'8312986afb0648b9899cce6e584a2d21'),('6eb10c949fe8439fb951786c0b398fcc','{\"email\": \"gnocchi@localhost\", \"description\": null}',1,NULL,'2025-12-05 08:20:31','2025-12-05','default'),('7e80b340e85f42e39c1385c6d8b66381','{\"email\": \"ceilometer@localhost\", \"description\": null}',1,NULL,'2025-12-05 08:20:30','2025-12-05','default'),('82349838b9764648b21be888e6cf01eb','{\"tenantId\": \"440faaea58384fd181042ac4bee82b37\", \"email\": \"alt_demo_tempestconf@test.com\"}',1,NULL,'2025-12-05 10:03:17',NULL,'default'),('824f3fa2f50c4abd95554aa63e00939a','{\"tenantId\": \"b38a1d46818e4f37b442152341646ff0\", \"email\": \"demo_tempestconf@test.com\"}',1,NULL,'2025-12-05 10:03:17','2025-12-05','default'),('8f5b595a91b24c01a0669328ec534e31','{}',1,'d98f9ffaeb7346169078ece01c85312d','2025-12-05 08:53:33','2025-12-05','default'),('aebc3fa07a254e76886e329e7e811fb2','{\"email\": \"cinderv3@localhost\", \"description\": null}',1,NULL,'2025-12-05 08:20:30',NULL,'default'),('c09787ff15134c9896057a29fefbe933','{\"email\": \"neutron@localhost\", \"description\": null}',1,NULL,'2025-12-05 08:20:41','2025-12-05','default'),('e0b4238c063b43b4a06600840a571eec','{\"email\": \"heat-cfn@localhost\", \"description\": null}',1,NULL,'2025-12-05 08:20:32',NULL,'default'),('f0c6f4464f324894b645e2b08b47171d','{\"email\": \"manila@localhost\", \"description\": null}',1,NULL,'2025-12-05 08:20:32','2025-12-05','default'),('fbd71b80bbe24eed9360343f4642ca6d','{\"email\": \"swift@localhost\", \"description\": null}',1,NULL,'2025-12-05 08:20:42','2025-12-05','default');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_group_membership`
--

DROP TABLE IF EXISTS `user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `fk_user_group_membership_group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `fk_user_group_membership_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_group_membership`
--

LOCK TABLES `user_group_membership` WRITE;
/*!40000 ALTER TABLE `user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_option`
--

DROP TABLE IF EXISTS `user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_option` (
  `user_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`user_id`,`option_id`),
  CONSTRAINT `user_option_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_option`
--

LOCK TABLES `user_option` WRITE;
/*!40000 ALTER TABLE `user_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whitelisted_config`
--

DROP TABLE IF EXISTS `whitelisted_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whitelisted_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whitelisted_config`
--

LOCK TABLES `whitelisted_config` WRITE;
/*!40000 ALTER TABLE `whitelisted_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `whitelisted_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `manila`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `manila` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `manila`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('aebe2a413e13');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `async_operation_data`
--

DROP TABLE IF EXISTS `async_operation_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `async_operation_data` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `entity_uuid` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`entity_uuid`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `async_operation_data`
--

LOCK TABLES `async_operation_data` WRITE;
/*!40000 ALTER TABLE `async_operation_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `async_operation_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `availability_zones`
--

DROP TABLE IF EXISTS `availability_zones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `availability_zones` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `az_name_uc` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `availability_zones`
--

LOCK TABLES `availability_zones` WRITE;
/*!40000 ALTER TABLE `availability_zones` DISABLE KEYS */;
INSERT INTO `availability_zones` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`) VALUES ('2025-12-05 08:22:14.269888',NULL,NULL,'False','968af5c9-1556-4ca3-a1f7-c78938b65996','nova');
/*!40000 ALTER TABLE `availability_zones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backend_info`
--

DROP TABLE IF EXISTS `backend_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backend_info` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `host` varchar(255) NOT NULL,
  `info_hash` varchar(255) NOT NULL,
  PRIMARY KEY (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backend_info`
--

LOCK TABLES `backend_info` WRITE;
/*!40000 ALTER TABLE `backend_info` DISABLE KEYS */;
INSERT INTO `backend_info` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `host`, `info_hash`) VALUES ('2025-12-05 09:06:38.673725',NULL,NULL,0,'hostgroup@cephfs','e66c0dfc0d422efa26af62f5a81dd60603e2d39a');
/*!40000 ALTER TABLE `backend_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `drivers_private_data`
--

DROP TABLE IF EXISTS `drivers_private_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `drivers_private_data` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `entity_uuid` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`entity_uuid`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `drivers_private_data`
--

LOCK TABLES `drivers_private_data` WRITE;
/*!40000 ALTER TABLE `drivers_private_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `drivers_private_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(255) DEFAULT NULL,
  `resource_id` varchar(36) DEFAULT NULL,
  `action_id` varchar(10) NOT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
INSERT INTO `messages` (`id`, `project_id`, `request_id`, `resource_type`, `resource_id`, `action_id`, `detail_id`, `message_level`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `expires_at`) VALUES ('04c90231-c110-4cd6-ba20-86cb0ed6fd47','f664c71837fd4542885812183157a725','req-9f5c9118-884a-4d46-bc0e-13f8bc947c97','SHARE','4455510e-3717-4b32-8559-5fcae4215039','001','008','ERROR','2025-12-05 10:13:46.083611',NULL,NULL,'False','2026-01-04 10:13:46'),('2b9aee1c-18a1-4ce1-bed9-d216097dc9b8','1f21e7e53d6347d5b4115944db13e5b3','req-b2743d1e-5747-480d-9a0b-928d0922bb23','SHARE','44ab8f5d-e15a-4cde-8b1e-152cb429d177','001','008','ERROR','2025-12-05 10:17:41.638582',NULL,NULL,'False','2026-01-04 10:17:41'),('42e19830-d731-4777-9938-78aaf413d7f3','f664c71837fd4542885812183157a725','req-a9b03a49-7813-43a1-9824-05799ff1b892','SHARE','4373290c-62b1-4920-a2e2-bc460bcab6a3','001','008','ERROR','2025-12-05 10:13:54.700521',NULL,NULL,'False','2026-01-04 10:13:54'),('6ae0acc6-4849-4f47-9221-263c2a51553e','1f21e7e53d6347d5b4115944db13e5b3','req-7c16585b-e0e3-4a28-86ed-667020d77311','SHARE','72bbcd05-7a7b-4e42-8ddd-53b71b80c63b','001','008','ERROR','2025-12-05 10:17:51.380388',NULL,NULL,'False','2026-01-04 10:17:51'),('6f40e6e8-f750-4c1a-aa27-2383df7de270','1f21e7e53d6347d5b4115944db13e5b3','req-7ec01533-2e47-4646-ae4e-dd7af838f3e0','SHARE','6d57ff6a-b088-4d4e-bdb0-42ee27ffca08','001','008','ERROR','2025-12-05 10:18:19.408435',NULL,'2025-12-05 10:18:22.489055','6f40e6e8-f750-4c1a-aa27-2383df7de270','2026-01-04 10:18:19'),('9ae1bac7-5fef-4ca4-8e86-60b2b9e1334f','1f21e7e53d6347d5b4115944db13e5b3','req-ebadb951-ac2b-4278-ab60-988913141eb3','SHARE','8cd2f826-e57e-4d28-97f3-98a8abeb77e1','001','008','ERROR','2025-12-05 10:17:58.087181',NULL,NULL,'False','2026-01-04 10:17:58'),('9d7e588e-90ae-4583-8ebc-98b808cb68e7','1f21e7e53d6347d5b4115944db13e5b3','req-389829f5-6f7e-476c-a164-6e2195f198e6','SHARE','7df0c307-34ab-48fc-b546-db74c012195c','001','008','ERROR','2025-12-05 10:18:15.425791',NULL,NULL,'False','2026-01-04 10:18:15'),('a5ad1aea-cda2-4097-89be-09078e7e38e8','1f21e7e53d6347d5b4115944db13e5b3','req-a66fcb87-53e9-4d5c-af7f-d1536cff1751','SHARE','40d861c9-0ea1-4b5a-8906-ba41a3f946a5','001','008','ERROR','2025-12-05 10:17:45.051813',NULL,NULL,'False','2026-01-04 10:17:45'),('b6a94c74-028f-4cc4-9fc3-af2a61e09578','1f21e7e53d6347d5b4115944db13e5b3','req-a4f19631-bdfb-4fb9-9b74-449a3c562790','SHARE','93f6d461-5b84-4539-8ae3-798c23b1f6d6','001','008','ERROR','2025-12-05 10:18:01.576718',NULL,NULL,'False','2026-01-04 10:18:01'),('be9ab720-af3c-45b2-a277-e128f5b66c55','f4c34f38ddb048808ef72391bdda40b5','req-9ccf2dea-0615-4ac1-9ee9-3f0b851994d5','SHARE','e94901d6-0dcb-4a6c-a305-a2991f9b32d6','010','020','ERROR','2025-12-05 10:12:21.959512',NULL,NULL,'False','2026-01-04 10:12:21'),('ca0dff5a-fba2-40ee-9587-bade484d0a29','1f21e7e53d6347d5b4115944db13e5b3','req-77311de6-1117-4503-96d4-2147880b0263','SHARE','1870da17-b2cf-4e1e-80f1-98166b37f168','001','008','ERROR','2025-12-05 10:17:38.011794',NULL,'2025-12-05 10:17:41.081109','ca0dff5a-fba2-40ee-9587-bade484d0a29','2026-01-04 10:17:38'),('cca7e215-d3bd-490f-864d-9a77f28c1527','f664c71837fd4542885812183157a725','req-bccce921-8cea-4f7b-ac78-f1013b2b742b','SHARE','bf9b06da-d73c-45e6-84a0-daec2a3f74b2','001','008','ERROR','2025-12-05 10:13:35.846540',NULL,NULL,'False','2026-01-04 10:13:35'),('ccf02176-ca39-438a-8a98-9611e8b97129','1f21e7e53d6347d5b4115944db13e5b3','req-4ea6d32c-8bde-41c5-9995-d55b26fd5706','SHARE','74eb4f24-46a1-49d3-ae25-70ba184779dc','001','008','ERROR','2025-12-05 10:18:12.114224',NULL,NULL,'False','2026-01-04 10:18:12'),('d980a650-2345-4561-82c7-2403443d5233','f664c71837fd4542885812183157a725','req-800ee858-9124-4ede-b004-d72211071f34','SHARE','289e9cf0-419f-445e-8c3a-1cb2d437b68e','001','008','ERROR','2025-12-05 10:13:41.887021',NULL,NULL,'False','2026-01-04 10:13:41'),('fe9bb735-76d7-49ce-b304-d26de9d4ea3f','f664c71837fd4542885812183157a725','req-ebfab6fa-a72f-44cc-a149-4ed5c30ed38d','SHARE','996aa9a1-463c-4b75-b6b8-bf3246b62503','001','008','ERROR','2025-12-05 10:13:51.349491',NULL,NULL,'False','2026-01-04 10:13:51'),('ffdbae23-93e7-41a8-a9b5-8fa16aa22fc7','1f21e7e53d6347d5b4115944db13e5b3','req-538d6e7c-5307-4c55-9ab5-faecee160246','SHARE','a21e7bdd-3ea7-4b43-bd4e-a9f9078c730a','001','008','ERROR','2025-12-05 10:18:07.894711',NULL,NULL,'False','2026-01-04 10:18:07');
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `network_allocations`
--

DROP TABLE IF EXISTS `network_allocations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `network_allocations` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ip_address` varchar(64) DEFAULT NULL,
  `mac_address` varchar(32) DEFAULT NULL,
  `share_server_id` varchar(36) NOT NULL,
  `label` varchar(255) DEFAULT 'user',
  `network_type` varchar(32) DEFAULT NULL,
  `segmentation_id` int(11) DEFAULT NULL,
  `ip_version` int(11) DEFAULT NULL,
  `cidr` varchar(64) DEFAULT NULL,
  `gateway` varchar(64) DEFAULT NULL,
  `mtu` int(11) DEFAULT NULL,
  `share_network_subnet_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `share_server_id` (`share_server_id`),
  KEY `fk_network_allocation_subnet_id_share_network_subnets` (`share_network_subnet_id`),
  CONSTRAINT `fk_network_allocation_subnet_id_share_network_subnets` FOREIGN KEY (`share_network_subnet_id`) REFERENCES `share_network_subnets` (`id`),
  CONSTRAINT `network_allocations_ibfk_1` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `network_allocations`
--

LOCK TABLES `network_allocations` WRITE;
/*!40000 ALTER TABLE `network_allocations` DISABLE KEYS */;
/*!40000 ALTER TABLE `network_allocations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_share_type_quotas`
--

DROP TABLE IF EXISTS `project_share_type_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_share_type_quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `share_type_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uc_quotas_per_share_types` (`share_type_id`,`resource`,`deleted`,`project_id`),
  CONSTRAINT `share_type_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_share_type_quotas`
--

LOCK TABLES `project_share_type_quotas` WRITE;
/*!40000 ALTER TABLE `project_share_type_quotas` DISABLE KEYS */;
INSERT INTO `project_share_type_quotas` (`id`, `project_id`, `resource`, `hard_limit`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `share_type_id`) VALUES (1,'d34a70d4c87b4bccbac035ee2005a967','shares',2,'2025-12-05 10:12:05.187696',NULL,'2025-12-05 10:12:30.402929',1,'65a4580f-4899-4c8b-b13f-366c633ab545'),(2,'d34a70d4c87b4bccbac035ee2005a967','gigabytes',4,'2025-12-05 10:12:05.192518',NULL,'2025-12-05 10:12:30.402929',2,'65a4580f-4899-4c8b-b13f-366c633ab545'),(3,'d34a70d4c87b4bccbac035ee2005a967','shares',2,'2025-12-05 10:12:05.277682',NULL,'2025-12-05 10:12:30.334448',3,'5ac8752e-ddb6-490b-9cb8-5388b9eaca33'),(4,'d34a70d4c87b4bccbac035ee2005a967','gigabytes',4,'2025-12-05 10:12:05.288750',NULL,'2025-12-05 10:12:30.334448',4,'5ac8752e-ddb6-490b-9cb8-5388b9eaca33'),(5,'d34a70d4c87b4bccbac035ee2005a967','shares',53,'2025-12-05 10:12:20.238463',NULL,'2025-12-05 10:12:20.323295',5,'029c381a-429f-4e1f-a3b2-414ae87c6a5b'),(6,'d34a70d4c87b4bccbac035ee2005a967','snapshots',53,'2025-12-05 10:12:20.245449',NULL,'2025-12-05 10:12:20.323295',6,'029c381a-429f-4e1f-a3b2-414ae87c6a5b'),(7,'d34a70d4c87b4bccbac035ee2005a967','gigabytes',1003,'2025-12-05 10:12:20.256857',NULL,'2025-12-05 10:12:20.323295',7,'029c381a-429f-4e1f-a3b2-414ae87c6a5b'),(8,'d34a70d4c87b4bccbac035ee2005a967','snapshot_gigabytes',1003,'2025-12-05 10:12:20.265387',NULL,'2025-12-05 10:12:20.323295',8,'029c381a-429f-4e1f-a3b2-414ae87c6a5b'),(9,'d34a70d4c87b4bccbac035ee2005a967','share_replicas',103,'2025-12-05 10:12:20.274488',NULL,'2025-12-05 10:12:20.323295',9,'029c381a-429f-4e1f-a3b2-414ae87c6a5b'),(10,'d34a70d4c87b4bccbac035ee2005a967','replica_gigabytes',1003,'2025-12-05 10:12:20.280470',NULL,'2025-12-05 10:12:20.323295',10,'029c381a-429f-4e1f-a3b2-414ae87c6a5b'),(11,'d34a70d4c87b4bccbac035ee2005a967','shares',53,'2025-12-05 10:12:20.691348',NULL,'2025-12-05 10:12:20.745145',11,'1c76bbee-0c52-47d1-816e-9fb22ba338dd'),(12,'d34a70d4c87b4bccbac035ee2005a967','snapshots',53,'2025-12-05 10:12:20.696218',NULL,'2025-12-05 10:12:20.745145',12,'1c76bbee-0c52-47d1-816e-9fb22ba338dd'),(13,'d34a70d4c87b4bccbac035ee2005a967','gigabytes',1003,'2025-12-05 10:12:20.702264',NULL,'2025-12-05 10:12:20.745145',13,'1c76bbee-0c52-47d1-816e-9fb22ba338dd'),(14,'d34a70d4c87b4bccbac035ee2005a967','snapshot_gigabytes',1003,'2025-12-05 10:12:20.707128',NULL,'2025-12-05 10:12:20.745145',14,'1c76bbee-0c52-47d1-816e-9fb22ba338dd'),(15,'d34a70d4c87b4bccbac035ee2005a967','share_replicas',103,'2025-12-05 10:12:20.713366',NULL,'2025-12-05 10:12:20.745145',15,'1c76bbee-0c52-47d1-816e-9fb22ba338dd'),(16,'d34a70d4c87b4bccbac035ee2005a967','replica_gigabytes',1003,'2025-12-05 10:12:20.716945',NULL,'2025-12-05 10:12:20.745145',16,'1c76bbee-0c52-47d1-816e-9fb22ba338dd'),(17,'d34a70d4c87b4bccbac035ee2005a967','shares',12,'2025-12-05 10:12:21.870103',NULL,'2025-12-05 10:12:29.858963',17,'1aef117f-6806-4786-96a7-2335d71ca5cb'),(18,'d34a70d4c87b4bccbac035ee2005a967','shares',49,'2025-12-05 10:12:25.311181',NULL,'2025-12-05 10:12:29.770996',18,'51f619c0-f1e7-4f93-a3c9-ea7705830e73'),(19,'d34a70d4c87b4bccbac035ee2005a967','gigabytes',999,'2025-12-05 10:12:25.391784',NULL,'2025-12-05 10:12:29.770996',19,'51f619c0-f1e7-4f93-a3c9-ea7705830e73'),(20,'d34a70d4c87b4bccbac035ee2005a967','snapshots',49,'2025-12-05 10:12:25.451747',NULL,'2025-12-05 10:12:29.770996',20,'51f619c0-f1e7-4f93-a3c9-ea7705830e73'),(21,'d34a70d4c87b4bccbac035ee2005a967','snapshot_gigabytes',999,'2025-12-05 10:12:25.501002',NULL,'2025-12-05 10:12:29.770996',21,'51f619c0-f1e7-4f93-a3c9-ea7705830e73'),(22,'d34a70d4c87b4bccbac035ee2005a967','share_replicas',99,'2025-12-05 10:12:25.558005',NULL,'2025-12-05 10:12:29.770996',22,'51f619c0-f1e7-4f93-a3c9-ea7705830e73'),(23,'d34a70d4c87b4bccbac035ee2005a967','replica_gigabytes',999,'2025-12-05 10:12:25.634052',NULL,'2025-12-05 10:12:29.770996',23,'51f619c0-f1e7-4f93-a3c9-ea7705830e73'),(24,'d34a70d4c87b4bccbac035ee2005a967','shares',49,'2025-12-05 10:12:25.778704',NULL,'2025-12-05 10:12:29.702792',24,'85b10043-8415-4a42-9c8e-b4fab5ec9805'),(25,'d34a70d4c87b4bccbac035ee2005a967','gigabytes',999,'2025-12-05 10:12:25.847599',NULL,'2025-12-05 10:12:29.702792',25,'85b10043-8415-4a42-9c8e-b4fab5ec9805'),(26,'d34a70d4c87b4bccbac035ee2005a967','snapshots',49,'2025-12-05 10:12:25.899830',NULL,'2025-12-05 10:12:29.702792',26,'85b10043-8415-4a42-9c8e-b4fab5ec9805'),(27,'d34a70d4c87b4bccbac035ee2005a967','snapshot_gigabytes',999,'2025-12-05 10:12:25.980087',NULL,'2025-12-05 10:12:29.702792',27,'85b10043-8415-4a42-9c8e-b4fab5ec9805'),(28,'d34a70d4c87b4bccbac035ee2005a967','share_replicas',99,'2025-12-05 10:12:26.047416',NULL,'2025-12-05 10:12:29.702792',28,'85b10043-8415-4a42-9c8e-b4fab5ec9805'),(29,'d34a70d4c87b4bccbac035ee2005a967','replica_gigabytes',999,'2025-12-05 10:12:26.110405',NULL,'2025-12-05 10:12:29.702792',29,'85b10043-8415-4a42-9c8e-b4fab5ec9805'),(30,'d34a70d4c87b4bccbac035ee2005a967','shares',11,'2025-12-05 10:12:26.397206',NULL,'2025-12-05 10:12:29.595440',30,'5a34e11e-4d78-4420-bf86-cac6c2f21a08'),(31,'d34a70d4c87b4bccbac035ee2005a967','shares',-1,'2025-12-05 10:12:26.718159',NULL,'2025-12-05 10:12:29.504432',31,'0a08d744-a795-46f0-b18e-bdc295743d77');
/*!40000 ALTER TABLE `project_share_type_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_user_quotas`
--

DROP TABLE IF EXISTS `project_user_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_user_quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `user_id` varchar(255) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `resource` varchar(25) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_user_quotas`
--

LOCK TABLES `project_user_quotas` WRITE;
/*!40000 ALTER TABLE `project_user_quotas` DISABLE KEYS */;
INSERT INTO `project_user_quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `user_id`, `project_id`, `resource`, `hard_limit`) VALUES (1,'2025-12-05 10:12:05.108288',NULL,'2025-12-05 10:12:19.467082',1,'9d3385b7b45145bdb1032d3a6efc7d1f','d34a70d4c87b4bccbac035ee2005a967','shares',2),(2,'2025-12-05 10:12:05.114642',NULL,'2025-12-05 10:12:19.467082',2,'9d3385b7b45145bdb1032d3a6efc7d1f','d34a70d4c87b4bccbac035ee2005a967','gigabytes',7),(3,'2025-12-05 10:12:21.470136',NULL,'2025-12-05 10:12:21.920865',3,'9d3385b7b45145bdb1032d3a6efc7d1f','d34a70d4c87b4bccbac035ee2005a967','shares',11),(4,'2025-12-05 10:12:23.706873',NULL,'2025-12-05 10:12:23.758734',4,'9d3385b7b45145bdb1032d3a6efc7d1f','d34a70d4c87b4bccbac035ee2005a967','gigabytes',-1),(5,'2025-12-05 10:12:24.062604',NULL,'2025-12-05 10:12:24.120303',5,'9d3385b7b45145bdb1032d3a6efc7d1f','d34a70d4c87b4bccbac035ee2005a967','share_replicas',-1),(6,'2025-12-05 10:12:24.219005',NULL,'2025-12-05 10:12:24.531952',6,'9d3385b7b45145bdb1032d3a6efc7d1f','d34a70d4c87b4bccbac035ee2005a967','replica_gigabytes',-1),(7,'2025-12-05 10:12:24.614080',NULL,'2025-12-05 10:12:24.710480',7,'9d3385b7b45145bdb1032d3a6efc7d1f','d34a70d4c87b4bccbac035ee2005a967','share_networks',-1),(8,'2025-12-05 10:12:24.794769',NULL,'2025-12-05 10:12:24.869289',8,'9d3385b7b45145bdb1032d3a6efc7d1f','d34a70d4c87b4bccbac035ee2005a967','shares',-1),(9,'2025-12-05 10:12:24.965009',NULL,'2025-12-05 10:12:25.016407',9,'9d3385b7b45145bdb1032d3a6efc7d1f','d34a70d4c87b4bccbac035ee2005a967','snapshot_gigabytes',-1),(10,'2025-12-05 10:12:25.107502',NULL,'2025-12-05 10:12:25.153181',10,'9d3385b7b45145bdb1032d3a6efc7d1f','d34a70d4c87b4bccbac035ee2005a967','snapshots',-1),(11,'2025-12-05 10:12:27.694788',NULL,'2025-12-05 10:12:27.988960',11,'9d3385b7b45145bdb1032d3a6efc7d1f','d34a70d4c87b4bccbac035ee2005a967','gigabytes',999),(12,'2025-12-05 10:12:28.277270',NULL,'2025-12-05 10:12:28.310019',12,'9d3385b7b45145bdb1032d3a6efc7d1f','d34a70d4c87b4bccbac035ee2005a967','share_replicas',99),(13,'2025-12-05 10:12:28.490448',NULL,'2025-12-05 10:12:28.536938',13,'9d3385b7b45145bdb1032d3a6efc7d1f','d34a70d4c87b4bccbac035ee2005a967','replica_gigabytes',999),(14,'2025-12-05 10:12:28.664551',NULL,'2025-12-05 10:12:28.704528',14,'9d3385b7b45145bdb1032d3a6efc7d1f','d34a70d4c87b4bccbac035ee2005a967','share_networks',9),(15,'2025-12-05 10:12:28.821150',NULL,'2025-12-05 10:12:28.842084',15,'9d3385b7b45145bdb1032d3a6efc7d1f','d34a70d4c87b4bccbac035ee2005a967','shares',49),(16,'2025-12-05 10:12:28.927426',NULL,'2025-12-05 10:12:28.965749',16,'9d3385b7b45145bdb1032d3a6efc7d1f','d34a70d4c87b4bccbac035ee2005a967','snapshot_gigabytes',999),(17,'2025-12-05 10:12:29.059340',NULL,'2025-12-05 10:12:29.087016',17,'9d3385b7b45145bdb1032d3a6efc7d1f','d34a70d4c87b4bccbac035ee2005a967','snapshots',49),(18,'2025-12-05 10:12:29.222933',NULL,'2025-12-05 10:12:29.261702',18,'9d3385b7b45145bdb1032d3a6efc7d1f','d34a70d4c87b4bccbac035ee2005a967','shares',11),(19,'2025-12-05 10:12:29.393167',NULL,'2025-12-05 10:12:29.415252',19,'9d3385b7b45145bdb1032d3a6efc7d1f','d34a70d4c87b4bccbac035ee2005a967','shares',-1);
/*!40000 ALTER TABLE `project_user_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_usages_project_id` (`project_id`)
) ENGINE=InnoDB AUTO_INCREMENT=270 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
INSERT INTO `quota_usages` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `resource`, `in_use`, `reserved`, `until_refresh`, `share_type_id`) VALUES ('2025-12-05 10:09:47.388779','2025-12-05 10:11:22.324420',NULL,0,1,'2ea873f665ba41948906baac5e68b7c6','1220f950d9bb436099f84f4762bc2e27','shares',0,0,NULL,NULL),('2025-12-05 10:09:47.392331','2025-12-05 10:11:22.324423',NULL,0,2,'2ea873f665ba41948906baac5e68b7c6','1220f950d9bb436099f84f4762bc2e27','gigabytes',0,0,NULL,NULL),('2025-12-05 10:09:47.408245','2025-12-05 10:11:22.324425','2025-12-05 10:11:25.137002',3,3,NULL,'1220f950d9bb436099f84f4762bc2e27','shares',0,0,NULL,'c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:09:47.411814','2025-12-05 10:11:22.324427','2025-12-05 10:11:25.137002',4,4,NULL,'1220f950d9bb436099f84f4762bc2e27','gigabytes',0,0,NULL,'c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:10:24.129928','2025-12-05 10:11:18.947529',NULL,0,5,'2ea873f665ba41948906baac5e68b7c6','1220f950d9bb436099f84f4762bc2e27','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-05 10:10:24.133407','2025-12-05 10:11:18.947532',NULL,0,6,'2ea873f665ba41948906baac5e68b7c6','1220f950d9bb436099f84f4762bc2e27','snapshots',0,0,NULL,NULL),('2025-12-05 10:10:24.261788','2025-12-05 10:11:18.947533','2025-12-05 10:11:25.137002',7,7,NULL,'1220f950d9bb436099f84f4762bc2e27','snapshot_gigabytes',0,0,NULL,'c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:10:24.267316','2025-12-05 10:11:18.947535','2025-12-05 10:11:25.137002',8,8,NULL,'1220f950d9bb436099f84f4762bc2e27','snapshots',0,0,NULL,'c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:11:37.739391','2025-12-05 10:11:44.444334',NULL,0,9,'35818db97a7f48bba64f2172c36bcd92','742c47288c43466fb15b8bc5e64971af','shares',0,0,NULL,NULL),('2025-12-05 10:11:37.746107','2025-12-05 10:11:44.444337',NULL,0,10,'35818db97a7f48bba64f2172c36bcd92','742c47288c43466fb15b8bc5e64971af','gigabytes',0,0,NULL,NULL),('2025-12-05 10:11:37.773566','2025-12-05 10:11:44.444338','2025-12-05 10:11:48.735349',11,11,NULL,'742c47288c43466fb15b8bc5e64971af','shares',0,0,NULL,'cf069f76-8f1e-439e-a467-0ee5ba9aa528'),('2025-12-05 10:11:37.780721','2025-12-05 10:11:44.444340','2025-12-05 10:11:48.735349',12,12,NULL,'742c47288c43466fb15b8bc5e64971af','gigabytes',0,0,NULL,'cf069f76-8f1e-439e-a467-0ee5ba9aa528'),('2025-12-05 10:11:50.415889','2025-12-05 10:12:53.176901',NULL,0,13,'348d267ee53941bbbb6824e764d06b33','f4c34f38ddb048808ef72391bdda40b5','shares',0,0,NULL,NULL),('2025-12-05 10:11:50.417942','2025-12-05 10:12:53.176904',NULL,0,14,'348d267ee53941bbbb6824e764d06b33','f4c34f38ddb048808ef72391bdda40b5','gigabytes',0,0,NULL,NULL),('2025-12-05 10:11:50.430478','2025-12-05 10:12:53.176905','2025-12-05 10:12:56.175527',15,15,NULL,'f4c34f38ddb048808ef72391bdda40b5','shares',0,0,NULL,'e8182e37-1b64-46cf-939e-d811c66cd270'),('2025-12-05 10:11:50.432911','2025-12-05 10:12:53.176906','2025-12-05 10:12:56.175527',16,16,NULL,'f4c34f38ddb048808ef72391bdda40b5','gigabytes',0,0,NULL,'e8182e37-1b64-46cf-939e-d811c66cd270'),('2025-12-05 10:11:54.118685','2025-12-05 10:12:49.790767',NULL,0,17,NULL,'f4c34f38ddb048808ef72391bdda40b5','shares',0,0,NULL,'449c8c2d-0435-4e20-be7a-0426a7732edb'),('2025-12-05 10:11:54.123824','2025-12-05 10:12:49.790769',NULL,0,18,NULL,'f4c34f38ddb048808ef72391bdda40b5','gigabytes',0,0,NULL,'449c8c2d-0435-4e20-be7a-0426a7732edb'),('2025-12-05 10:12:00.927496','2025-12-05 10:12:46.486536',NULL,0,19,'b576720ad2bb46dca8593baa5187080f','a1984fed702d4461879e97dd7c6fc401','shares',0,0,NULL,NULL),('2025-12-05 10:12:00.930516','2025-12-05 10:12:46.486539',NULL,0,20,'b576720ad2bb46dca8593baa5187080f','a1984fed702d4461879e97dd7c6fc401','gigabytes',0,0,NULL,NULL),('2025-12-05 10:12:00.943476','2025-12-05 10:12:46.486541',NULL,0,21,NULL,'a1984fed702d4461879e97dd7c6fc401','shares',0,0,NULL,'449c8c2d-0435-4e20-be7a-0426a7732edb'),('2025-12-05 10:12:00.945304','2025-12-05 10:12:46.486543',NULL,0,22,NULL,'a1984fed702d4461879e97dd7c6fc401','gigabytes',0,0,NULL,'449c8c2d-0435-4e20-be7a-0426a7732edb'),('2025-12-05 10:12:05.382944','2025-12-05 10:12:16.445540','2025-12-05 10:12:19.470008',23,23,'9d3385b7b45145bdb1032d3a6efc7d1f','d34a70d4c87b4bccbac035ee2005a967','gigabytes',0,0,NULL,NULL),('2025-12-05 10:12:05.388347','2025-12-05 10:12:16.445543','2025-12-05 10:12:19.470008',24,24,'9d3385b7b45145bdb1032d3a6efc7d1f','d34a70d4c87b4bccbac035ee2005a967','shares',0,0,NULL,NULL),('2025-12-05 10:12:05.413998','2025-12-05 10:12:13.340363','2025-12-05 10:12:19.663341',25,25,NULL,'d34a70d4c87b4bccbac035ee2005a967','gigabytes',0,0,NULL,'65a4580f-4899-4c8b-b13f-366c633ab545'),('2025-12-05 10:12:05.417821','2025-12-05 10:12:13.340365','2025-12-05 10:12:19.663341',26,26,NULL,'d34a70d4c87b4bccbac035ee2005a967','shares',0,0,NULL,'65a4580f-4899-4c8b-b13f-366c633ab545'),('2025-12-05 10:12:08.895906','2025-12-05 10:12:16.445545','2025-12-05 10:12:19.663341',27,27,NULL,'d34a70d4c87b4bccbac035ee2005a967','shares',0,0,NULL,'5ac8752e-ddb6-490b-9cb8-5388b9eaca33'),('2025-12-05 10:12:08.898371','2025-12-05 10:12:16.445547','2025-12-05 10:12:19.663341',28,28,NULL,'d34a70d4c87b4bccbac035ee2005a967','gigabytes',0,0,NULL,'5ac8752e-ddb6-490b-9cb8-5388b9eaca33'),('2025-12-05 10:12:28.020561','2025-12-05 10:12:43.219469','2025-12-05 10:12:56.175527',29,29,NULL,'a1984fed702d4461879e97dd7c6fc401','shares',0,0,NULL,'e8182e37-1b64-46cf-939e-d811c66cd270'),('2025-12-05 10:12:28.026697','2025-12-05 10:12:43.219471','2025-12-05 10:12:56.175527',30,30,NULL,'a1984fed702d4461879e97dd7c6fc401','gigabytes',0,0,NULL,'e8182e37-1b64-46cf-939e-d811c66cd270'),('2025-12-05 10:12:34.840969','2025-12-05 10:12:47.399000',NULL,0,31,'d59f59d0e8cf40e8b15d79772c65521a','ebe30874eba14cd5bd352ff97cc61ddf','gigabytes',0,0,NULL,NULL),('2025-12-05 10:12:34.842986','2025-12-05 10:12:47.399004',NULL,0,32,'d59f59d0e8cf40e8b15d79772c65521a','ebe30874eba14cd5bd352ff97cc61ddf','shares',0,0,NULL,NULL),('2025-12-05 10:12:34.856445','2025-12-05 10:12:47.399005','2025-12-05 10:12:50.140079',33,33,NULL,'ebe30874eba14cd5bd352ff97cc61ddf','gigabytes',0,0,NULL,'3555d51c-f13b-4628-8bd2-5dd0bf96d69d'),('2025-12-05 10:12:34.858422','2025-12-05 10:12:47.399006','2025-12-05 10:12:50.140079',34,34,NULL,'ebe30874eba14cd5bd352ff97cc61ddf','shares',0,0,NULL,'3555d51c-f13b-4628-8bd2-5dd0bf96d69d'),('2025-12-05 10:12:53.932857','2025-12-05 10:12:54.626064','2025-12-05 10:12:58.138907',35,35,'7029332df14e44eb8554fb21ecce63d9','7ed90e6d1b7c4872853af83191db9808','shares',1,0,NULL,NULL),('2025-12-05 10:12:53.934972','2025-12-05 10:12:54.626068','2025-12-05 10:12:58.138907',36,36,'7029332df14e44eb8554fb21ecce63d9','7ed90e6d1b7c4872853af83191db9808','gigabytes',1,0,NULL,NULL),('2025-12-05 10:12:54.528586','2025-12-05 10:12:54.626070','2025-12-05 10:12:58.138907',37,37,NULL,'7ed90e6d1b7c4872853af83191db9808','shares',1,0,NULL,'632c113b-9b12-4c58-a04a-7eaeb0d12655'),('2025-12-05 10:12:54.531866','2025-12-05 10:12:54.626072','2025-12-05 10:12:58.138907',38,38,NULL,'7ed90e6d1b7c4872853af83191db9808','gigabytes',1,0,NULL,'632c113b-9b12-4c58-a04a-7eaeb0d12655'),('2025-12-05 10:12:58.222469','2025-12-05 10:12:58.362599','2025-12-05 10:13:08.099141',39,39,'7029332df14e44eb8554fb21ecce63d9','7ed90e6d1b7c4872853af83191db9808','shares',2,0,NULL,NULL),('2025-12-05 10:12:58.228257','2025-12-05 10:12:58.362602','2025-12-05 10:13:08.099141',40,40,'7029332df14e44eb8554fb21ecce63d9','7ed90e6d1b7c4872853af83191db9808','gigabytes',2,0,NULL,NULL),('2025-12-05 10:12:58.332355','2025-12-05 10:12:58.362603','2025-12-05 10:13:08.099141',41,41,NULL,'7ed90e6d1b7c4872853af83191db9808','shares',1,0,NULL,'2d4b5a4d-5ba9-4704-8683-44def0c314de'),('2025-12-05 10:12:58.337064','2025-12-05 10:12:58.362604','2025-12-05 10:13:08.099141',42,42,NULL,'7ed90e6d1b7c4872853af83191db9808','gigabytes',1,0,NULL,'2d4b5a4d-5ba9-4704-8683-44def0c314de'),('2025-12-05 10:13:04.196188','2025-12-05 10:13:04.673446','2025-12-05 10:13:08.099141',43,43,'7029332df14e44eb8554fb21ecce63d9','7ed90e6d1b7c4872853af83191db9808','snapshot_gigabytes',1,0,NULL,NULL),('2025-12-05 10:13:04.199579','2025-12-05 10:13:04.673449','2025-12-05 10:13:08.099141',44,44,'7029332df14e44eb8554fb21ecce63d9','7ed90e6d1b7c4872853af83191db9808','snapshots',1,0,NULL,NULL),('2025-12-05 10:13:04.553460','2025-12-05 10:13:04.673450','2025-12-05 10:13:08.099141',45,45,NULL,'7ed90e6d1b7c4872853af83191db9808','snapshot_gigabytes',1,0,NULL,'2d4b5a4d-5ba9-4704-8683-44def0c314de'),('2025-12-05 10:13:04.556994','2025-12-05 10:13:04.673451','2025-12-05 10:13:08.099141',46,46,NULL,'7ed90e6d1b7c4872853af83191db9808','snapshots',1,0,NULL,'2d4b5a4d-5ba9-4704-8683-44def0c314de'),('2025-12-05 10:13:14.693319','2025-12-05 10:13:14.732969',NULL,0,47,'7029332df14e44eb8554fb21ecce63d9','7ed90e6d1b7c4872853af83191db9808','snapshots',-1,0,NULL,NULL),('2025-12-05 10:13:14.697567','2025-12-05 10:13:14.732972',NULL,0,48,'7029332df14e44eb8554fb21ecce63d9','7ed90e6d1b7c4872853af83191db9808','snapshot_gigabytes',-1,0,NULL,NULL),('2025-12-05 10:13:14.706551','2025-12-05 10:13:14.732973','2025-12-05 10:13:21.879926',49,49,NULL,'7ed90e6d1b7c4872853af83191db9808','snapshots',-1,0,NULL,'2d4b5a4d-5ba9-4704-8683-44def0c314de'),('2025-12-05 10:13:14.717771','2025-12-05 10:13:14.732974','2025-12-05 10:13:21.879926',50,50,NULL,'7ed90e6d1b7c4872853af83191db9808','snapshot_gigabytes',-1,0,NULL,'2d4b5a4d-5ba9-4704-8683-44def0c314de'),('2025-12-05 10:13:19.061831','2025-12-05 10:13:23.169002',NULL,0,51,'7029332df14e44eb8554fb21ecce63d9','7ed90e6d1b7c4872853af83191db9808','gigabytes',0,0,NULL,NULL),('2025-12-05 10:13:19.069926','2025-12-05 10:13:23.169004',NULL,0,52,'7029332df14e44eb8554fb21ecce63d9','7ed90e6d1b7c4872853af83191db9808','shares',0,0,NULL,NULL),('2025-12-05 10:13:19.094343','2025-12-05 10:13:19.120984','2025-12-05 10:13:21.879926',53,53,NULL,'7ed90e6d1b7c4872853af83191db9808','gigabytes',0,0,NULL,'2d4b5a4d-5ba9-4704-8683-44def0c314de'),('2025-12-05 10:13:19.100367','2025-12-05 10:13:19.120985','2025-12-05 10:13:21.879926',54,54,NULL,'7ed90e6d1b7c4872853af83191db9808','shares',0,0,NULL,'2d4b5a4d-5ba9-4704-8683-44def0c314de'),('2025-12-05 10:13:19.540948','2025-12-05 10:13:32.027039',NULL,0,55,'d69249cd05f14764b756127bbf1b1722','4c561d1c6e584a9089b9e15f2f4357c8','shares',0,0,NULL,NULL),('2025-12-05 10:13:19.543357','2025-12-05 10:13:32.027041',NULL,0,56,'d69249cd05f14764b756127bbf1b1722','4c561d1c6e584a9089b9e15f2f4357c8','gigabytes',0,0,NULL,NULL),('2025-12-05 10:13:19.554454','2025-12-05 10:13:32.027043','2025-12-05 10:13:35.846842',57,57,NULL,'4c561d1c6e584a9089b9e15f2f4357c8','shares',0,0,NULL,'8ac53a92-cde8-4dfa-8750-87dea15a0661'),('2025-12-05 10:13:19.556729','2025-12-05 10:13:32.027044','2025-12-05 10:13:35.846842',58,58,NULL,'4c561d1c6e584a9089b9e15f2f4357c8','gigabytes',0,0,NULL,'8ac53a92-cde8-4dfa-8750-87dea15a0661'),('2025-12-05 10:13:22.836588','2025-12-05 10:13:23.169006','2025-12-05 10:13:25.344810',59,59,NULL,'7ed90e6d1b7c4872853af83191db9808','gigabytes',0,0,NULL,'632c113b-9b12-4c58-a04a-7eaeb0d12655'),('2025-12-05 10:13:22.839594','2025-12-05 10:13:23.169007','2025-12-05 10:13:25.344810',60,60,NULL,'7ed90e6d1b7c4872853af83191db9808','shares',0,0,NULL,'632c113b-9b12-4c58-a04a-7eaeb0d12655'),('2025-12-05 10:13:22.882207','2025-12-05 10:13:29.225253',NULL,0,61,'d69249cd05f14764b756127bbf1b1722','4c561d1c6e584a9089b9e15f2f4357c8','snapshots',0,0,NULL,NULL),('2025-12-05 10:13:22.888502','2025-12-05 10:13:29.225258',NULL,0,62,'d69249cd05f14764b756127bbf1b1722','4c561d1c6e584a9089b9e15f2f4357c8','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-05 10:13:23.152904','2025-12-05 10:13:29.225260','2025-12-05 10:13:35.846842',63,63,NULL,'4c561d1c6e584a9089b9e15f2f4357c8','snapshots',0,0,NULL,'8ac53a92-cde8-4dfa-8750-87dea15a0661'),('2025-12-05 10:13:23.156638','2025-12-05 10:13:29.225261','2025-12-05 10:13:35.846842',64,64,NULL,'4c561d1c6e584a9089b9e15f2f4357c8','snapshot_gigabytes',0,0,NULL,'8ac53a92-cde8-4dfa-8750-87dea15a0661'),('2025-12-05 10:13:33.411473','2025-12-05 10:13:58.260881',NULL,0,65,'1717459cd58f495ca4e1b6ad9cd48d71','f664c71837fd4542885812183157a725','shares',0,0,NULL,NULL),('2025-12-05 10:13:33.413164','2025-12-05 10:13:58.260885',NULL,0,66,'1717459cd58f495ca4e1b6ad9cd48d71','f664c71837fd4542885812183157a725','gigabytes',0,0,NULL,NULL),('2025-12-05 10:13:34.348908','2025-12-05 10:13:41.444864','2025-12-05 10:13:59.225884',67,67,NULL,'f664c71837fd4542885812183157a725','shares',0,0,NULL,'3a0d44c5-216e-4725-8f6f-11decb7b7356'),('2025-12-05 10:13:34.353779','2025-12-05 10:13:41.444865','2025-12-05 10:13:59.225884',68,68,NULL,'f664c71837fd4542885812183157a725','gigabytes',0,0,NULL,'3a0d44c5-216e-4725-8f6f-11decb7b7356'),('2025-12-05 10:13:41.671911','2025-12-05 10:13:45.118439','2025-12-05 10:13:59.134240',69,69,NULL,'f664c71837fd4542885812183157a725','shares',0,0,NULL,'56a69d99-6552-49e6-8f2e-be9b93e17b0f'),('2025-12-05 10:13:41.675152','2025-12-05 10:13:45.118441','2025-12-05 10:13:59.134240',70,70,NULL,'f664c71837fd4542885812183157a725','gigabytes',0,0,NULL,'56a69d99-6552-49e6-8f2e-be9b93e17b0f'),('2025-12-05 10:13:45.841470','2025-12-05 10:13:49.323031','2025-12-05 10:13:59.065681',71,71,NULL,'f664c71837fd4542885812183157a725','shares',0,0,NULL,'1fd60b46-31a6-44af-a399-72e33821aac3'),('2025-12-05 10:13:45.843836','2025-12-05 10:13:49.323032','2025-12-05 10:13:59.065681',72,72,NULL,'f664c71837fd4542885812183157a725','gigabytes',0,0,NULL,'1fd60b46-31a6-44af-a399-72e33821aac3'),('2025-12-05 10:13:46.911476','2025-12-05 10:14:07.703830',NULL,0,73,'e3d69a69ad4b45469299d1089bf6b8a8','99a6df84d1504c33b200f7c6a254c378','gigabytes',0,0,NULL,NULL),('2025-12-05 10:13:46.914234','2025-12-05 10:14:07.703835',NULL,0,74,'e3d69a69ad4b45469299d1089bf6b8a8','99a6df84d1504c33b200f7c6a254c378','shares',0,0,NULL,NULL),('2025-12-05 10:13:47.022092','2025-12-05 10:14:07.703837','2025-12-05 10:14:10.429962',75,75,NULL,'99a6df84d1504c33b200f7c6a254c378','gigabytes',0,0,NULL,'7ce735c8-f067-4b35-99c6-033e895e272c'),('2025-12-05 10:13:47.027462','2025-12-05 10:14:07.703839','2025-12-05 10:14:10.429962',76,76,NULL,'99a6df84d1504c33b200f7c6a254c378','shares',0,0,NULL,'7ce735c8-f067-4b35-99c6-033e895e272c'),('2025-12-05 10:13:49.258550','2025-12-05 10:13:54.444306',NULL,0,77,'69b8aff476fc43d1a9779493ad95325f','d812ebe2a802424a8dd9d8d619c2f55a','share_networks',0,0,NULL,NULL),('2025-12-05 10:13:49.571887','2025-12-05 10:13:54.421906','2025-12-05 10:13:59.009357',78,78,NULL,'f664c71837fd4542885812183157a725','shares',0,0,NULL,'3673ad3c-54ef-41db-979b-88e9de5caed2'),('2025-12-05 10:13:49.574382','2025-12-05 10:13:54.421907','2025-12-05 10:13:59.009357',79,79,NULL,'f664c71837fd4542885812183157a725','gigabytes',0,0,NULL,'3673ad3c-54ef-41db-979b-88e9de5caed2'),('2025-12-05 10:13:50.875105','2025-12-05 10:14:04.355233',NULL,0,80,'e3d69a69ad4b45469299d1089bf6b8a8','99a6df84d1504c33b200f7c6a254c378','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-05 10:13:50.877116','2025-12-05 10:14:04.355236',NULL,0,81,'e3d69a69ad4b45469299d1089bf6b8a8','99a6df84d1504c33b200f7c6a254c378','snapshots',0,0,NULL,NULL),('2025-12-05 10:13:51.083665','2025-12-05 10:14:04.355237','2025-12-05 10:14:10.429962',82,82,NULL,'99a6df84d1504c33b200f7c6a254c378','snapshot_gigabytes',0,0,NULL,'7ce735c8-f067-4b35-99c6-033e895e272c'),('2025-12-05 10:13:51.090315','2025-12-05 10:14:04.355238','2025-12-05 10:14:10.429962',83,83,NULL,'99a6df84d1504c33b200f7c6a254c378','snapshots',0,0,NULL,'7ce735c8-f067-4b35-99c6-033e895e272c'),('2025-12-05 10:13:54.559537','2025-12-05 10:13:58.260887','2025-12-05 10:13:58.927861',84,84,NULL,'f664c71837fd4542885812183157a725','gigabytes',0,0,NULL,'be084e42-05f4-4652-aaae-737f831d0d2a'),('2025-12-05 10:13:54.561661','2025-12-05 10:13:58.260889','2025-12-05 10:13:58.927861',85,85,NULL,'f664c71837fd4542885812183157a725','shares',0,0,NULL,'be084e42-05f4-4652-aaae-737f831d0d2a'),('2025-12-05 10:14:06.708078','2025-12-05 10:14:12.042867',NULL,0,86,'c139691182194818afa5e150f743366b','d7beb72de9524536896541252af97cc3','share_networks',0,0,NULL,NULL),('2025-12-05 10:14:13.651487','2025-12-05 10:14:44.431806',NULL,0,87,'dc607a8fb4974085b29b5b37328dc83a','fb88a523f48e4990b7617051dc3491c9','shares',0,0,NULL,NULL),('2025-12-05 10:14:13.654310','2025-12-05 10:14:44.431810',NULL,0,88,'dc607a8fb4974085b29b5b37328dc83a','fb88a523f48e4990b7617051dc3491c9','gigabytes',0,0,NULL,NULL),('2025-12-05 10:14:13.675804','2025-12-05 10:14:44.431812','2025-12-05 10:14:46.539329',89,89,NULL,'fb88a523f48e4990b7617051dc3491c9','shares',0,0,NULL,'925f92eb-4755-4dec-9fb7-7aaa82d1d7ed'),('2025-12-05 10:14:13.678928','2025-12-05 10:14:44.431814','2025-12-05 10:14:46.539329',90,90,NULL,'fb88a523f48e4990b7617051dc3491c9','gigabytes',0,0,NULL,'925f92eb-4755-4dec-9fb7-7aaa82d1d7ed'),('2025-12-05 10:14:30.577867','2025-12-05 10:14:31.958877',NULL,0,91,'b7fa2ce38b4e48f7a890e36831560ee8','40e1bd948bdb4f01851408e900510a3a','share_networks',0,0,NULL,NULL),('2025-12-05 10:15:11.160631','2025-12-05 10:15:23.197905',NULL,0,92,'b92de181a7ba4f11a7e8cf47535f620e','79f3281d6e6d4d5d83a280d0dfd5e85d','shares',0,0,NULL,NULL),('2025-12-05 10:15:11.162593','2025-12-05 10:15:23.197908',NULL,0,93,'b92de181a7ba4f11a7e8cf47535f620e','79f3281d6e6d4d5d83a280d0dfd5e85d','gigabytes',0,0,NULL,NULL),('2025-12-05 10:15:11.172602','2025-12-05 10:15:23.197910','2025-12-05 10:15:33.864935',94,94,NULL,'79f3281d6e6d4d5d83a280d0dfd5e85d','shares',0,0,NULL,'b364e671-4d05-4a07-bbb6-f63562594053'),('2025-12-05 10:15:11.174769','2025-12-05 10:15:23.197911','2025-12-05 10:15:33.864935',95,95,NULL,'79f3281d6e6d4d5d83a280d0dfd5e85d','gigabytes',0,0,NULL,'b364e671-4d05-4a07-bbb6-f63562594053'),('2025-12-05 10:15:14.740425','2025-12-05 10:15:29.755723',NULL,0,96,'d369cec12ec04e22bdfa6abddaf9b93b','9d30aef9a1a4449f82832ccd3ce2ff79','gigabytes',0,0,NULL,NULL),('2025-12-05 10:15:14.742894','2025-12-05 10:15:29.755726',NULL,0,97,'d369cec12ec04e22bdfa6abddaf9b93b','9d30aef9a1a4449f82832ccd3ce2ff79','shares',0,0,NULL,NULL),('2025-12-05 10:15:15.263252','2025-12-05 10:15:29.755727','2025-12-05 10:15:33.864935',98,98,NULL,'9d30aef9a1a4449f82832ccd3ce2ff79','gigabytes',0,0,NULL,'b364e671-4d05-4a07-bbb6-f63562594053'),('2025-12-05 10:15:15.266722','2025-12-05 10:15:29.755728','2025-12-05 10:15:33.864935',99,99,NULL,'9d30aef9a1a4449f82832ccd3ce2ff79','shares',0,0,NULL,'b364e671-4d05-4a07-bbb6-f63562594053'),('2025-12-05 10:15:19.790309','2025-12-05 10:15:24.823206',NULL,0,100,'05bea8a2829448b5ae9bbf9fea0de669','697949cb96644dfeb8be31be03b2a3ac','shares',0,0,NULL,NULL),('2025-12-05 10:15:19.792932','2025-12-05 10:15:24.823210',NULL,0,101,'05bea8a2829448b5ae9bbf9fea0de669','697949cb96644dfeb8be31be03b2a3ac','gigabytes',0,0,NULL,NULL),('2025-12-05 10:15:19.803985','2025-12-05 10:15:24.823212','2025-12-05 10:15:27.781990',102,102,NULL,'697949cb96644dfeb8be31be03b2a3ac','shares',0,0,NULL,'3803e2e0-24da-4c86-bc94-d28949e34165'),('2025-12-05 10:15:19.806846','2025-12-05 10:15:24.823214','2025-12-05 10:15:27.781990',103,103,NULL,'697949cb96644dfeb8be31be03b2a3ac','gigabytes',0,0,NULL,'3803e2e0-24da-4c86-bc94-d28949e34165'),('2025-12-05 10:15:31.525782','2025-12-05 10:15:44.346394',NULL,0,104,'d81b90efc7534e8cbfc59c39b640f7c0','8687dc3eee0040e79eeca2d91dd79941','shares',0,0,NULL,NULL),('2025-12-05 10:15:31.529308','2025-12-05 10:15:44.346398',NULL,0,105,'d81b90efc7534e8cbfc59c39b640f7c0','8687dc3eee0040e79eeca2d91dd79941','gigabytes',0,0,NULL,NULL),('2025-12-05 10:15:31.552653','2025-12-05 10:15:44.346400','2025-12-05 10:15:47.126963',106,106,NULL,'8687dc3eee0040e79eeca2d91dd79941','shares',0,0,NULL,'a78584c0-d87e-4496-90ad-f0ee4ded2040'),('2025-12-05 10:15:31.555010','2025-12-05 10:15:44.346402','2025-12-05 10:15:47.126963',107,107,NULL,'8687dc3eee0040e79eeca2d91dd79941','gigabytes',0,0,NULL,'a78584c0-d87e-4496-90ad-f0ee4ded2040'),('2025-12-05 10:15:34.817745','2025-12-05 10:15:39.233095',NULL,0,108,'d81b90efc7534e8cbfc59c39b640f7c0','8687dc3eee0040e79eeca2d91dd79941','snapshots',0,0,NULL,NULL),('2025-12-05 10:15:34.820285','2025-12-05 10:15:39.233098',NULL,0,109,'d81b90efc7534e8cbfc59c39b640f7c0','8687dc3eee0040e79eeca2d91dd79941','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-05 10:15:34.833040','2025-12-05 10:15:39.233099','2025-12-05 10:15:47.126963',110,110,NULL,'8687dc3eee0040e79eeca2d91dd79941','snapshots',0,0,NULL,'a78584c0-d87e-4496-90ad-f0ee4ded2040'),('2025-12-05 10:15:34.837945','2025-12-05 10:15:39.233100','2025-12-05 10:15:47.126963',111,111,NULL,'8687dc3eee0040e79eeca2d91dd79941','snapshot_gigabytes',0,0,NULL,'a78584c0-d87e-4496-90ad-f0ee4ded2040'),('2025-12-05 10:15:44.805999','2025-12-05 10:15:51.408945',NULL,0,112,'ae23d780cb6649c0ab7c884a0d711e81','03c6de342ca54bbe8809c2d180c4f2e3','shares',0,0,NULL,NULL),('2025-12-05 10:15:44.808112','2025-12-05 10:15:51.408948',NULL,0,113,'ae23d780cb6649c0ab7c884a0d711e81','03c6de342ca54bbe8809c2d180c4f2e3','gigabytes',0,0,NULL,NULL),('2025-12-05 10:15:44.819465','2025-12-05 10:15:51.408950','2025-12-05 10:15:55.071243',114,114,NULL,'03c6de342ca54bbe8809c2d180c4f2e3','shares',0,0,NULL,'5ae3fc02-bd9b-43cc-8cd1-9ccd8fdd4d7c'),('2025-12-05 10:15:44.821830','2025-12-05 10:15:51.408952','2025-12-05 10:15:55.071243',115,115,NULL,'03c6de342ca54bbe8809c2d180c4f2e3','gigabytes',0,0,NULL,'5ae3fc02-bd9b-43cc-8cd1-9ccd8fdd4d7c'),('2025-12-05 10:16:02.287319','2025-12-05 10:17:58.872713',NULL,0,116,'07df57f2247a47d4bd454007daad7cb2','b33bb860f67d445e985f6ff2d7af55b8','shares',0,0,NULL,NULL),('2025-12-05 10:16:02.291317','2025-12-05 10:17:58.872716',NULL,0,117,'07df57f2247a47d4bd454007daad7cb2','b33bb860f67d445e985f6ff2d7af55b8','gigabytes',0,0,NULL,NULL),('2025-12-05 10:16:02.304009','2025-12-05 10:17:58.872718','2025-12-05 10:18:01.669671',118,118,NULL,'b33bb860f67d445e985f6ff2d7af55b8','shares',0,0,NULL,'7d2e45dc-69f9-4275-9fed-cd397eb62d04'),('2025-12-05 10:16:02.306127','2025-12-05 10:17:58.872719','2025-12-05 10:18:01.669671',119,119,NULL,'b33bb860f67d445e985f6ff2d7af55b8','gigabytes',0,0,NULL,'7d2e45dc-69f9-4275-9fed-cd397eb62d04'),('2025-12-05 10:16:05.250432','2025-12-05 10:16:06.617399',NULL,0,120,'56e13a6e5136430c91e8af8760aa2ef4','21f8c5a5071f4b0da11d0e8d9105e144','share_networks',0,0,NULL,NULL),('2025-12-05 10:16:05.588937','2025-12-05 10:17:55.610023',NULL,0,121,'07df57f2247a47d4bd454007daad7cb2','b33bb860f67d445e985f6ff2d7af55b8','snapshots',0,0,NULL,NULL),('2025-12-05 10:16:05.597134','2025-12-05 10:17:55.610026',NULL,0,122,'07df57f2247a47d4bd454007daad7cb2','b33bb860f67d445e985f6ff2d7af55b8','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-05 10:16:05.608149','2025-12-05 10:16:05.646925',NULL,0,123,'4f9847eafc834176b52e5c274757a634','f83026a05cd94543bc2cfa196e903342','share_networks',1,0,NULL,NULL),('2025-12-05 10:16:05.612416','2025-12-05 10:17:55.610028','2025-12-05 10:18:01.669671',124,124,NULL,'b33bb860f67d445e985f6ff2d7af55b8','snapshots',0,0,NULL,'7d2e45dc-69f9-4275-9fed-cd397eb62d04'),('2025-12-05 10:16:05.617661','2025-12-05 10:17:55.610029','2025-12-05 10:18:01.669671',125,125,NULL,'b33bb860f67d445e985f6ff2d7af55b8','snapshot_gigabytes',0,0,NULL,'7d2e45dc-69f9-4275-9fed-cd397eb62d04'),('2025-12-05 10:16:11.365341','2025-12-05 10:16:56.343965',NULL,0,126,'1cbac882b1644084a19927eef4c7b1b7','ce38d31c75764d08b9ff383a5b08c451','shares',0,0,NULL,NULL),('2025-12-05 10:16:11.367375','2025-12-05 10:16:56.343970',NULL,0,127,'1cbac882b1644084a19927eef4c7b1b7','ce38d31c75764d08b9ff383a5b08c451','gigabytes',0,0,NULL,NULL),('2025-12-05 10:16:11.376449','2025-12-05 10:16:56.343972','2025-12-05 10:16:59.090949',128,128,NULL,'ce38d31c75764d08b9ff383a5b08c451','shares',0,0,NULL,'c1f9eccc-7d94-4eff-a11d-f32d3dbccf72'),('2025-12-05 10:16:11.378452','2025-12-05 10:16:56.343973','2025-12-05 10:16:59.090949',129,129,NULL,'ce38d31c75764d08b9ff383a5b08c451','gigabytes',0,0,NULL,'c1f9eccc-7d94-4eff-a11d-f32d3dbccf72'),('2025-12-05 10:16:14.816078','2025-12-05 10:16:25.435876',NULL,0,130,'de2f844b04bf40cb837ae11647ae92f5','e7033a26c5f24acbbb25cfa856732f7c','gigabytes',0,0,NULL,NULL),('2025-12-05 10:16:14.817882','2025-12-05 10:16:25.435879',NULL,0,131,'de2f844b04bf40cb837ae11647ae92f5','e7033a26c5f24acbbb25cfa856732f7c','shares',0,0,NULL,NULL),('2025-12-05 10:16:14.826351','2025-12-05 10:16:25.435880','2025-12-05 10:16:28.348371',132,132,NULL,'e7033a26c5f24acbbb25cfa856732f7c','gigabytes',0,0,NULL,'cd1ce3bc-1c70-4466-a11f-4cd3f1044779'),('2025-12-05 10:16:14.828173','2025-12-05 10:16:25.435881','2025-12-05 10:16:28.348371',133,133,NULL,'e7033a26c5f24acbbb25cfa856732f7c','shares',0,0,NULL,'cd1ce3bc-1c70-4466-a11f-4cd3f1044779'),('2025-12-05 10:16:18.039380','2025-12-05 10:16:22.331938',NULL,0,134,'de2f844b04bf40cb837ae11647ae92f5','e7033a26c5f24acbbb25cfa856732f7c','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-05 10:16:18.041540','2025-12-05 10:16:22.331941',NULL,0,135,'de2f844b04bf40cb837ae11647ae92f5','e7033a26c5f24acbbb25cfa856732f7c','snapshots',0,0,NULL,NULL),('2025-12-05 10:16:18.051867','2025-12-05 10:16:22.331942','2025-12-05 10:16:28.348371',136,136,NULL,'e7033a26c5f24acbbb25cfa856732f7c','snapshot_gigabytes',0,0,NULL,'cd1ce3bc-1c70-4466-a11f-4cd3f1044779'),('2025-12-05 10:16:18.054912','2025-12-05 10:16:22.331944','2025-12-05 10:16:28.348371',137,137,NULL,'e7033a26c5f24acbbb25cfa856732f7c','snapshots',0,0,NULL,'cd1ce3bc-1c70-4466-a11f-4cd3f1044779'),('2025-12-05 10:16:47.946606','2025-12-05 10:17:48.705768',NULL,0,138,'c1c1850b8e6d4f43aa6fe0276225946d','702f5d76a7514945a7e621e4e93fb7f0','shares',0,0,NULL,NULL),('2025-12-05 10:16:47.949046','2025-12-05 10:17:48.705770',NULL,0,139,'c1c1850b8e6d4f43aa6fe0276225946d','702f5d76a7514945a7e621e4e93fb7f0','gigabytes',0,0,NULL,NULL),('2025-12-05 10:16:47.961075','2025-12-05 10:17:48.705772','2025-12-05 10:17:51.523763',140,140,NULL,'702f5d76a7514945a7e621e4e93fb7f0','shares',0,0,NULL,'f1bac668-7d97-4e82-8ff1-b0d3f4fdb84f'),('2025-12-05 10:16:47.963440','2025-12-05 10:17:48.705773','2025-12-05 10:17:51.523763',141,141,NULL,'702f5d76a7514945a7e621e4e93fb7f0','gigabytes',0,0,NULL,'f1bac668-7d97-4e82-8ff1-b0d3f4fdb84f'),('2025-12-05 10:17:10.580437','2025-12-05 10:17:15.130013',NULL,0,142,'a2074ac299fc4eebb364da9f4323590b','175210be70e14bda86d1bac3778b7f23','shares',0,0,NULL,NULL),('2025-12-05 10:17:10.584602','2025-12-05 10:17:15.130016',NULL,0,143,'a2074ac299fc4eebb364da9f4323590b','175210be70e14bda86d1bac3778b7f23','gigabytes',0,0,NULL,NULL),('2025-12-05 10:17:10.710401','2025-12-05 10:17:15.130017','2025-12-05 10:17:17.808712',144,144,NULL,'175210be70e14bda86d1bac3778b7f23','shares',0,0,NULL,'890f2e8e-b696-4432-8e1a-169f51e91e95'),('2025-12-05 10:17:10.715052','2025-12-05 10:17:15.130018','2025-12-05 10:17:17.808712',145,145,NULL,'175210be70e14bda86d1bac3778b7f23','gigabytes',0,0,NULL,'890f2e8e-b696-4432-8e1a-169f51e91e95'),('2025-12-05 10:17:26.293776','2025-12-05 10:20:31.219360',NULL,0,146,'ba3df4d4a04d48799dbe5857afbc06c9','362b693fa42f4124be6d6249e2b9052d','shares',0,0,NULL,NULL),('2025-12-05 10:17:26.295783','2025-12-05 10:20:31.219362',NULL,0,147,'ba3df4d4a04d48799dbe5857afbc06c9','362b693fa42f4124be6d6249e2b9052d','gigabytes',0,0,NULL,NULL),('2025-12-05 10:17:26.307936','2025-12-05 10:20:31.219364','2025-12-05 10:20:34.305551',148,148,NULL,'362b693fa42f4124be6d6249e2b9052d','shares',0,0,NULL,'af694064-af12-4441-ba1c-ff5d81133112'),('2025-12-05 10:17:26.310791','2025-12-05 10:20:31.219365','2025-12-05 10:20:34.305551',149,149,NULL,'362b693fa42f4124be6d6249e2b9052d','gigabytes',0,0,NULL,'af694064-af12-4441-ba1c-ff5d81133112'),('2025-12-05 10:17:37.902713','2025-12-05 10:18:22.710601',NULL,0,150,'675a6cc004734cfeaac8e670fa288294','1f21e7e53d6347d5b4115944db13e5b3','shares',0,0,NULL,NULL),('2025-12-05 10:17:37.905085','2025-12-05 10:18:22.710604',NULL,0,151,'675a6cc004734cfeaac8e670fa288294','1f21e7e53d6347d5b4115944db13e5b3','gigabytes',0,0,NULL,NULL),('2025-12-05 10:17:37.916234','2025-12-05 10:17:41.423876','2025-12-05 10:18:23.427991',152,152,NULL,'1f21e7e53d6347d5b4115944db13e5b3','shares',0,0,NULL,'51ebc14f-c4fe-4f50-9d9a-3dd032cdb29e'),('2025-12-05 10:17:37.918388','2025-12-05 10:17:41.423878','2025-12-05 10:18:23.427991',153,153,NULL,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',0,0,NULL,'51ebc14f-c4fe-4f50-9d9a-3dd032cdb29e'),('2025-12-05 10:17:41.504723','2025-12-05 10:17:44.873156','2025-12-05 10:18:23.372953',154,154,NULL,'1f21e7e53d6347d5b4115944db13e5b3','shares',0,0,NULL,'76313173-bf9d-46b7-93c5-5f2e0a01c06f'),('2025-12-05 10:17:41.507537','2025-12-05 10:17:44.873157','2025-12-05 10:18:23.372953',155,155,NULL,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',0,0,NULL,'76313173-bf9d-46b7-93c5-5f2e0a01c06f'),('2025-12-05 10:17:44.947582','2025-12-05 10:17:57.837743','2025-12-05 10:18:23.310508',156,156,NULL,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',0,0,NULL,'4fddb165-bdf0-44a8-924c-92236ede9d77'),('2025-12-05 10:17:44.949923','2025-12-05 10:17:57.837744','2025-12-05 10:18:23.310508',157,157,NULL,'1f21e7e53d6347d5b4115944db13e5b3','shares',0,0,NULL,'4fddb165-bdf0-44a8-924c-92236ede9d77'),('2025-12-05 10:17:51.217474','2025-12-05 10:17:57.669961','2025-12-05 10:18:23.242383',158,158,NULL,'1f21e7e53d6347d5b4115944db13e5b3','shares',0,0,NULL,'eb919c66-4d19-4ee9-b484-9a8623ca1089'),('2025-12-05 10:17:51.220041','2025-12-05 10:17:57.669962','2025-12-05 10:18:23.242383',159,159,NULL,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',0,0,NULL,'eb919c66-4d19-4ee9-b484-9a8623ca1089'),('2025-12-05 10:17:57.583887','2025-12-05 10:17:58.681950',NULL,0,160,'26fe7579bfdb46f489eb7a9a7dba3ea8','654f7d6340ba4106be8189aa6b713316','share_networks',0,0,NULL,NULL),('2025-12-05 10:17:57.948025','2025-12-05 10:18:11.838381','2025-12-05 10:18:23.136429',161,161,NULL,'1f21e7e53d6347d5b4115944db13e5b3','shares',0,0,NULL,'1bbe8daf-2394-4f63-bb09-bf68e9fe33b2'),('2025-12-05 10:17:57.951897','2025-12-05 10:18:11.838382','2025-12-05 10:18:23.136429',162,162,NULL,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',0,0,NULL,'1bbe8daf-2394-4f63-bb09-bf68e9fe33b2'),('2025-12-05 10:18:01.455930','2025-12-05 10:18:11.604793','2025-12-05 10:18:23.050204',163,163,NULL,'1f21e7e53d6347d5b4115944db13e5b3','shares',0,0,NULL,'36bef84a-ca13-4549-88f1-18c7c3743e47'),('2025-12-05 10:18:01.457943','2025-12-05 10:18:11.604795','2025-12-05 10:18:23.050204',164,164,NULL,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',0,0,NULL,'36bef84a-ca13-4549-88f1-18c7c3743e47'),('2025-12-05 10:18:07.762053','2025-12-05 10:18:11.395361','2025-12-05 10:18:22.973179',165,165,NULL,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',0,0,NULL,'e5398329-2e27-4645-892f-ae6a5ad70dfd'),('2025-12-05 10:18:07.770478','2025-12-05 10:18:11.395363','2025-12-05 10:18:22.973179',166,166,NULL,'1f21e7e53d6347d5b4115944db13e5b3','shares',0,0,NULL,'e5398329-2e27-4645-892f-ae6a5ad70dfd'),('2025-12-05 10:18:11.967980','2025-12-05 10:18:19.155650','2025-12-05 10:18:22.918388',167,167,NULL,'1f21e7e53d6347d5b4115944db13e5b3','shares',0,0,NULL,'27bab3c2-3c67-4a33-b303-25f7e777e628'),('2025-12-05 10:18:11.970932','2025-12-05 10:18:19.155652','2025-12-05 10:18:22.918388',168,168,NULL,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',0,0,NULL,'27bab3c2-3c67-4a33-b303-25f7e777e628'),('2025-12-05 10:18:14.256771','2025-12-05 10:18:18.450884',NULL,0,169,'0ff687168bfe48e9a0ff2725af5ddd2c','499b14cd90ca42a0aa6c88165774ed5f','shares',0,0,NULL,NULL),('2025-12-05 10:18:14.261721','2025-12-05 10:18:18.450887',NULL,0,170,'0ff687168bfe48e9a0ff2725af5ddd2c','499b14cd90ca42a0aa6c88165774ed5f','gigabytes',0,0,NULL,NULL),('2025-12-05 10:18:14.280380','2025-12-05 10:18:18.450889','2025-12-05 10:18:21.247604',171,171,NULL,'499b14cd90ca42a0aa6c88165774ed5f','shares',0,0,NULL,'fb81430e-c719-4e13-bf36-a80bcaa1407c'),('2025-12-05 10:18:14.283215','2025-12-05 10:18:18.450891','2025-12-05 10:18:21.247604',172,172,NULL,'499b14cd90ca42a0aa6c88165774ed5f','gigabytes',0,0,NULL,'fb81430e-c719-4e13-bf36-a80bcaa1407c'),('2025-12-05 10:18:15.281836','2025-12-05 10:18:18.957982','2025-12-05 10:18:22.857491',173,173,NULL,'1f21e7e53d6347d5b4115944db13e5b3','shares',0,0,NULL,'f142faf7-cf55-4cba-aa55-5c89912f5385'),('2025-12-05 10:18:15.283950','2025-12-05 10:18:18.957983','2025-12-05 10:18:22.857491',174,174,NULL,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',0,0,NULL,'f142faf7-cf55-4cba-aa55-5c89912f5385'),('2025-12-05 10:18:19.256478','2025-12-05 10:18:22.710605','2025-12-05 10:18:22.772569',175,175,NULL,'1f21e7e53d6347d5b4115944db13e5b3','shares',0,0,NULL,'dbeffb0b-e0b5-4cc0-9234-89458f4ebb71'),('2025-12-05 10:18:19.259229','2025-12-05 10:18:22.710606','2025-12-05 10:18:22.772569',176,176,NULL,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',0,0,NULL,'dbeffb0b-e0b5-4cc0-9234-89458f4ebb71'),('2025-12-05 10:18:29.741205','2025-12-05 10:18:34.610395',NULL,0,177,'0a892d7a0540429ba23646d4a938bfe8','713485f6825d4fbb96a3a6dfd0cac4e0','shares',0,0,NULL,NULL),('2025-12-05 10:18:29.743770','2025-12-05 10:18:34.610398',NULL,0,178,'0a892d7a0540429ba23646d4a938bfe8','713485f6825d4fbb96a3a6dfd0cac4e0','gigabytes',0,0,NULL,NULL),('2025-12-05 10:18:29.779737','2025-12-05 10:18:34.610399','2025-12-05 10:18:37.103232',179,179,NULL,'713485f6825d4fbb96a3a6dfd0cac4e0','shares',0,0,NULL,'a463f1e0-8246-4ffe-b810-f2359c6971ef'),('2025-12-05 10:18:29.781868','2025-12-05 10:18:34.610400','2025-12-05 10:18:37.103232',180,180,NULL,'713485f6825d4fbb96a3a6dfd0cac4e0','gigabytes',0,0,NULL,'a463f1e0-8246-4ffe-b810-f2359c6971ef'),('2025-12-05 10:18:41.144106','2025-12-05 10:19:14.525240',NULL,0,181,'0cae89584b954da8bbeb73eca8518688','0324648a65a343649c4079ef816ceb9e','gigabytes',0,0,NULL,NULL),('2025-12-05 10:18:41.148608','2025-12-05 10:19:14.525243',NULL,0,182,'0cae89584b954da8bbeb73eca8518688','0324648a65a343649c4079ef816ceb9e','shares',0,0,NULL,NULL),('2025-12-05 10:18:41.159403','2025-12-05 10:19:14.525245','2025-12-05 10:19:17.795906',183,183,NULL,'0324648a65a343649c4079ef816ceb9e','gigabytes',0,0,NULL,'c454d92d-8a8d-4636-8e70-a1b4aa0713ad'),('2025-12-05 10:18:41.162500','2025-12-05 10:19:14.525247','2025-12-05 10:19:17.795906',184,184,NULL,'0324648a65a343649c4079ef816ceb9e','shares',0,0,NULL,'c454d92d-8a8d-4636-8e70-a1b4aa0713ad'),('2025-12-05 10:18:54.450684','2025-12-05 10:19:01.074834',NULL,0,185,'0cae89584b954da8bbeb73eca8518688','0324648a65a343649c4079ef816ceb9e','share_groups',0,0,NULL,NULL),('2025-12-05 10:19:05.883361','2025-12-05 10:19:55.675833',NULL,0,186,'48c071afb6b4441dbadeb32daa6f0611','c1ecc993dd0d4bd78005db93dca023b4','gigabytes',0,0,NULL,NULL),('2025-12-05 10:19:05.885343','2025-12-05 10:19:55.675836',NULL,0,187,'48c071afb6b4441dbadeb32daa6f0611','c1ecc993dd0d4bd78005db93dca023b4','shares',0,0,NULL,NULL),('2025-12-05 10:19:05.947422','2025-12-05 10:19:55.675837','2025-12-05 10:19:58.566570',188,188,NULL,'c1ecc993dd0d4bd78005db93dca023b4','gigabytes',0,0,NULL,'2d70a5b8-ca33-4d4b-9189-ead462ee5261'),('2025-12-05 10:19:05.949637','2025-12-05 10:19:55.675838','2025-12-05 10:19:58.566570',189,189,NULL,'c1ecc993dd0d4bd78005db93dca023b4','shares',0,0,NULL,'2d70a5b8-ca33-4d4b-9189-ead462ee5261'),('2025-12-05 10:19:09.401823','2025-12-05 10:19:52.606994',NULL,0,190,'48c071afb6b4441dbadeb32daa6f0611','c1ecc993dd0d4bd78005db93dca023b4','snapshots',0,0,NULL,NULL),('2025-12-05 10:19:09.403931','2025-12-05 10:19:52.606998',NULL,0,191,'48c071afb6b4441dbadeb32daa6f0611','c1ecc993dd0d4bd78005db93dca023b4','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-05 10:19:09.537489','2025-12-05 10:19:52.607000','2025-12-05 10:19:58.566570',192,192,NULL,'c1ecc993dd0d4bd78005db93dca023b4','snapshots',0,0,NULL,'2d70a5b8-ca33-4d4b-9189-ead462ee5261'),('2025-12-05 10:19:09.540753','2025-12-05 10:19:52.607002','2025-12-05 10:19:58.566570',193,193,NULL,'c1ecc993dd0d4bd78005db93dca023b4','snapshot_gigabytes',0,0,NULL,'2d70a5b8-ca33-4d4b-9189-ead462ee5261'),('2025-12-05 10:19:26.171202','2025-12-05 10:19:36.881861',NULL,0,194,'4b78495b66f74849aa4036e9963317b5','36845157f5fd45bbabab2ab7b1c6f643','shares',0,0,NULL,NULL),('2025-12-05 10:19:26.173791','2025-12-05 10:19:36.881865',NULL,0,195,'4b78495b66f74849aa4036e9963317b5','36845157f5fd45bbabab2ab7b1c6f643','gigabytes',0,0,NULL,NULL),('2025-12-05 10:19:26.184193','2025-12-05 10:19:36.881866','2025-12-05 10:19:39.754065',196,196,NULL,'36845157f5fd45bbabab2ab7b1c6f643','shares',0,0,NULL,'8c824ac1-8692-473d-9bde-4e6250dfb431'),('2025-12-05 10:19:26.189833','2025-12-05 10:19:36.881868','2025-12-05 10:19:39.754065',197,197,NULL,'36845157f5fd45bbabab2ab7b1c6f643','gigabytes',0,0,NULL,'8c824ac1-8692-473d-9bde-4e6250dfb431'),('2025-12-05 10:19:29.422280','2025-12-05 10:19:33.634096',NULL,0,198,'4b78495b66f74849aa4036e9963317b5','36845157f5fd45bbabab2ab7b1c6f643','snapshots',0,0,NULL,NULL),('2025-12-05 10:19:29.424236','2025-12-05 10:19:33.634099',NULL,0,199,'4b78495b66f74849aa4036e9963317b5','36845157f5fd45bbabab2ab7b1c6f643','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-05 10:19:29.442269','2025-12-05 10:19:33.634101','2025-12-05 10:19:39.754065',200,200,NULL,'36845157f5fd45bbabab2ab7b1c6f643','snapshots',0,0,NULL,'8c824ac1-8692-473d-9bde-4e6250dfb431'),('2025-12-05 10:19:29.444716','2025-12-05 10:19:33.634103','2025-12-05 10:19:39.754065',201,201,NULL,'36845157f5fd45bbabab2ab7b1c6f643','snapshot_gigabytes',0,0,NULL,'8c824ac1-8692-473d-9bde-4e6250dfb431'),('2025-12-05 10:19:48.117902','2025-12-05 10:19:52.964721',NULL,0,202,'a3cbf4bf3f5448d9b87b413ba3bb65ce','9fcf3ede86ab43049896ebebf70bf286','shares',0,0,NULL,NULL),('2025-12-05 10:19:48.119853','2025-12-05 10:19:52.964726',NULL,0,203,'a3cbf4bf3f5448d9b87b413ba3bb65ce','9fcf3ede86ab43049896ebebf70bf286','gigabytes',0,0,NULL,NULL),('2025-12-05 10:19:48.131871','2025-12-05 10:19:52.964728','2025-12-05 10:19:55.453105',204,204,NULL,'9fcf3ede86ab43049896ebebf70bf286','shares',0,0,NULL,'36fabf19-1a00-45c6-af80-0833edc688ee'),('2025-12-05 10:19:48.133818','2025-12-05 10:19:52.964729','2025-12-05 10:19:55.453105',205,205,NULL,'9fcf3ede86ab43049896ebebf70bf286','gigabytes',0,0,NULL,'36fabf19-1a00-45c6-af80-0833edc688ee'),('2025-12-05 10:20:13.794570','2025-12-05 10:20:27.989565',NULL,0,206,'1a427475854141e7928911c644a3e8dc','362b693fa42f4124be6d6249e2b9052d','shares',0,0,NULL,NULL),('2025-12-05 10:20:13.798580','2025-12-05 10:20:27.989567',NULL,0,207,'1a427475854141e7928911c644a3e8dc','362b693fa42f4124be6d6249e2b9052d','gigabytes',0,0,NULL,NULL),('2025-12-05 10:20:22.548465','2025-12-05 10:20:23.107319',NULL,0,208,'d9fb981f169d4a6586e7bcf77c01b3b1','a67e460d3c4a42648dd18ce2fd92a2dd','share_networks',0,0,NULL,NULL),('2025-12-05 10:20:27.783282','2025-12-05 10:20:27.830943',NULL,0,209,'97412b14aa6e43a0bb611f58485bcdae','6a6515f8ed454214adcd4a8b77e529f7','share_networks',1,0,NULL,NULL),('2025-12-05 10:20:38.031193','2025-12-05 10:20:49.134508',NULL,0,210,'291dd4805ac146169da2a25d1b0dde38','beb500b1ccbc45ecb181246b3bcaced4','gigabytes',1,0,NULL,NULL),('2025-12-05 10:20:38.032893','2025-12-05 10:20:49.134511',NULL,0,211,'291dd4805ac146169da2a25d1b0dde38','beb500b1ccbc45ecb181246b3bcaced4','shares',1,0,NULL,NULL),('2025-12-05 10:20:38.052256','2025-12-05 10:20:49.134512','2025-12-05 10:20:52.323102',212,212,NULL,'beb500b1ccbc45ecb181246b3bcaced4','gigabytes',1,0,NULL,'32a7d72a-4c13-450f-b335-3c4a6726e3fa'),('2025-12-05 10:20:38.054370','2025-12-05 10:20:49.134513','2025-12-05 10:20:52.323102',213,213,NULL,'beb500b1ccbc45ecb181246b3bcaced4','shares',1,0,NULL,'32a7d72a-4c13-450f-b335-3c4a6726e3fa'),('2025-12-05 10:20:41.752161','2025-12-05 10:20:42.343449',NULL,0,214,'d28849030314469d8dc6f69a604ddc77','e27281ec227f4bdb979d86bbbcf368c6','shares',0,0,NULL,NULL),('2025-12-05 10:20:41.756113','2025-12-05 10:20:42.343451',NULL,0,215,'d28849030314469d8dc6f69a604ddc77','e27281ec227f4bdb979d86bbbcf368c6','gigabytes',0,0,NULL,NULL),('2025-12-05 10:20:41.779886','2025-12-05 10:20:41.925263',NULL,0,216,'d28849030314469d8dc6f69a604ddc77','beb500b1ccbc45ecb181246b3bcaced4','shares',-1,0,NULL,NULL),('2025-12-05 10:20:41.782122','2025-12-05 10:20:41.925267',NULL,0,217,'d28849030314469d8dc6f69a604ddc77','beb500b1ccbc45ecb181246b3bcaced4','gigabytes',-1,0,NULL,NULL),('2025-12-05 10:20:42.323231','2025-12-05 10:20:42.343453','2025-12-05 10:20:52.323102',218,218,NULL,'e27281ec227f4bdb979d86bbbcf368c6','gigabytes',0,0,NULL,'32a7d72a-4c13-450f-b335-3c4a6726e3fa'),('2025-12-05 10:20:42.325733','2025-12-05 10:20:42.343454','2025-12-05 10:20:52.323102',219,219,NULL,'e27281ec227f4bdb979d86bbbcf368c6','shares',0,0,NULL,'32a7d72a-4c13-450f-b335-3c4a6726e3fa'),('2025-12-05 10:21:01.136127','2025-12-05 10:21:27.079093',NULL,0,220,'caf786b25c984bba8c42aaf23a65d35a','ddd149290d0d43acaceda0e214199ffc','shares',0,0,NULL,NULL),('2025-12-05 10:21:01.138082','2025-12-05 10:21:27.079103',NULL,0,221,'caf786b25c984bba8c42aaf23a65d35a','ddd149290d0d43acaceda0e214199ffc','gigabytes',0,0,NULL,NULL),('2025-12-05 10:21:01.148102','2025-12-05 10:21:27.079105','2025-12-05 10:21:33.996319',222,222,NULL,'ddd149290d0d43acaceda0e214199ffc','shares',0,0,NULL,'0bf4eb18-3b5a-411a-91ea-6a5a956c9985'),('2025-12-05 10:21:01.150191','2025-12-05 10:21:27.079107','2025-12-05 10:21:33.996319',223,223,NULL,'ddd149290d0d43acaceda0e214199ffc','gigabytes',0,0,NULL,'0bf4eb18-3b5a-411a-91ea-6a5a956c9985'),('2025-12-05 10:21:11.147677','2025-12-05 10:21:23.587765',NULL,0,224,'20307d45ecf04a21b65383ef4ce32d62','0117b15a2d1b47a4a57983d2ac3e17a4','shares',0,0,NULL,NULL),('2025-12-05 10:21:11.149995','2025-12-05 10:21:23.587768',NULL,0,225,'20307d45ecf04a21b65383ef4ce32d62','0117b15a2d1b47a4a57983d2ac3e17a4','gigabytes',0,0,NULL,NULL),('2025-12-05 10:21:11.159350','2025-12-05 10:21:23.587769','2025-12-05 10:21:26.358093',226,226,NULL,'0117b15a2d1b47a4a57983d2ac3e17a4','shares',0,0,NULL,'6d5d593a-24c3-4681-89bb-07ee8750036b'),('2025-12-05 10:21:11.164241','2025-12-05 10:21:23.587771','2025-12-05 10:21:26.358093',227,227,NULL,'0117b15a2d1b47a4a57983d2ac3e17a4','gigabytes',0,0,NULL,'6d5d593a-24c3-4681-89bb-07ee8750036b'),('2025-12-05 10:21:14.442140','2025-12-05 10:21:19.863840',NULL,0,228,'20307d45ecf04a21b65383ef4ce32d62','0117b15a2d1b47a4a57983d2ac3e17a4','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-05 10:21:14.444859','2025-12-05 10:21:19.863845',NULL,0,229,'20307d45ecf04a21b65383ef4ce32d62','0117b15a2d1b47a4a57983d2ac3e17a4','snapshots',0,0,NULL,NULL),('2025-12-05 10:21:14.786117','2025-12-05 10:21:19.863847','2025-12-05 10:21:26.358093',230,230,NULL,'0117b15a2d1b47a4a57983d2ac3e17a4','snapshot_gigabytes',0,0,NULL,'6d5d593a-24c3-4681-89bb-07ee8750036b'),('2025-12-05 10:21:14.788384','2025-12-05 10:21:19.863849','2025-12-05 10:21:26.358093',231,231,NULL,'0117b15a2d1b47a4a57983d2ac3e17a4','snapshots',0,0,NULL,'6d5d593a-24c3-4681-89bb-07ee8750036b'),('2025-12-05 10:21:51.651531','2025-12-05 10:23:00.521734',NULL,0,232,'b546e386e67a402faab37db407ed0840','e188fd721aac47a28104704da7cec32d','gigabytes',0,0,NULL,NULL),('2025-12-05 10:21:51.656645','2025-12-05 10:23:00.521737',NULL,0,233,'b546e386e67a402faab37db407ed0840','e188fd721aac47a28104704da7cec32d','shares',0,0,NULL,NULL),('2025-12-05 10:21:51.669818','2025-12-05 10:22:02.281637','2025-12-05 10:22:05.120083',234,234,NULL,'e188fd721aac47a28104704da7cec32d','gigabytes',0,0,NULL,'1a77b381-9919-45f9-9e81-ee5db4e0728b'),('2025-12-05 10:21:51.672261','2025-12-05 10:22:02.281638','2025-12-05 10:22:05.120083',235,235,NULL,'e188fd721aac47a28104704da7cec32d','shares',0,0,NULL,'1a77b381-9919-45f9-9e81-ee5db4e0728b'),('2025-12-05 10:21:54.888801','2025-12-05 10:22:57.418376',NULL,0,236,'b546e386e67a402faab37db407ed0840','e188fd721aac47a28104704da7cec32d','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-05 10:21:54.891381','2025-12-05 10:22:57.418379',NULL,0,237,'b546e386e67a402faab37db407ed0840','e188fd721aac47a28104704da7cec32d','snapshots',0,0,NULL,NULL),('2025-12-05 10:21:54.903340','2025-12-05 10:21:58.495438','2025-12-05 10:22:05.120083',238,238,NULL,'e188fd721aac47a28104704da7cec32d','snapshot_gigabytes',0,0,NULL,'1a77b381-9919-45f9-9e81-ee5db4e0728b'),('2025-12-05 10:21:54.905875','2025-12-05 10:21:58.495439','2025-12-05 10:22:05.120083',239,239,NULL,'e188fd721aac47a28104704da7cec32d','snapshots',0,0,NULL,'1a77b381-9919-45f9-9e81-ee5db4e0728b'),('2025-12-05 10:22:05.192854','2025-12-05 10:22:08.803271','2025-12-05 10:23:03.774783',240,240,NULL,'e188fd721aac47a28104704da7cec32d','shares',0,0,NULL,'3bb56ffc-e476-4783-96cb-4f69a4eb604b'),('2025-12-05 10:22:05.197482','2025-12-05 10:22:08.803273','2025-12-05 10:23:03.774783',241,241,NULL,'e188fd721aac47a28104704da7cec32d','gigabytes',0,0,NULL,'3bb56ffc-e476-4783-96cb-4f69a4eb604b'),('2025-12-05 10:22:11.741140','2025-12-05 10:23:00.521739','2025-12-05 10:23:03.377492',242,242,NULL,'e188fd721aac47a28104704da7cec32d','shares',0,0,NULL,'fcc0b735-17d2-423d-89f5-4a395988683b'),('2025-12-05 10:22:11.743894','2025-12-05 10:23:00.521740','2025-12-05 10:23:03.377492',243,243,NULL,'e188fd721aac47a28104704da7cec32d','gigabytes',0,0,NULL,'fcc0b735-17d2-423d-89f5-4a395988683b'),('2025-12-05 10:22:15.011576','2025-12-05 10:22:57.418381','2025-12-05 10:23:03.377492',244,244,NULL,'e188fd721aac47a28104704da7cec32d','snapshot_gigabytes',0,0,NULL,'fcc0b735-17d2-423d-89f5-4a395988683b'),('2025-12-05 10:22:15.013375','2025-12-05 10:22:57.418383','2025-12-05 10:23:03.377492',245,245,NULL,'e188fd721aac47a28104704da7cec32d','snapshots',0,0,NULL,'fcc0b735-17d2-423d-89f5-4a395988683b'),('2025-12-05 10:23:11.640378','2025-12-05 10:24:38.954537',NULL,0,246,'40927528a3a44526a3d3553d7c3ce0de','19467570f0874da2a60c18ecff7bda2e','shares',0,0,NULL,NULL),('2025-12-05 10:23:11.645026','2025-12-05 10:24:38.954540',NULL,0,247,'40927528a3a44526a3d3553d7c3ce0de','19467570f0874da2a60c18ecff7bda2e','gigabytes',0,0,NULL,NULL),('2025-12-05 10:23:11.662707','2025-12-05 10:24:38.954542','2025-12-05 10:24:41.805699',248,248,NULL,'19467570f0874da2a60c18ecff7bda2e','shares',0,0,NULL,'9d3aaaf2-22be-46a2-9517-bdd58aaf148a'),('2025-12-05 10:23:11.665053','2025-12-05 10:24:38.954543','2025-12-05 10:24:41.805699',249,249,NULL,'19467570f0874da2a60c18ecff7bda2e','gigabytes',0,0,NULL,'9d3aaaf2-22be-46a2-9517-bdd58aaf148a'),('2025-12-05 10:23:14.926837','2025-12-05 10:24:31.794097',NULL,0,250,'40927528a3a44526a3d3553d7c3ce0de','19467570f0874da2a60c18ecff7bda2e','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-05 10:23:14.929584','2025-12-05 10:24:31.794100',NULL,0,251,'40927528a3a44526a3d3553d7c3ce0de','19467570f0874da2a60c18ecff7bda2e','snapshots',0,0,NULL,NULL),('2025-12-05 10:23:14.943067','2025-12-05 10:24:31.794101','2025-12-05 10:24:41.805699',252,252,NULL,'19467570f0874da2a60c18ecff7bda2e','snapshot_gigabytes',0,0,NULL,'9d3aaaf2-22be-46a2-9517-bdd58aaf148a'),('2025-12-05 10:23:14.945358','2025-12-05 10:24:31.794102','2025-12-05 10:24:41.805699',253,253,NULL,'19467570f0874da2a60c18ecff7bda2e','snapshots',0,0,NULL,'9d3aaaf2-22be-46a2-9517-bdd58aaf148a'),('2025-12-05 10:24:58.614335','2025-12-05 10:25:44.224894',NULL,0,254,'74265aa1d78a4e7b88e6d5a3f456ee7f','36912d7f29d447c599e209c5c44b5e67','shares',0,0,NULL,NULL),('2025-12-05 10:24:58.619500','2025-12-05 10:25:44.224897',NULL,0,255,'74265aa1d78a4e7b88e6d5a3f456ee7f','36912d7f29d447c599e209c5c44b5e67','gigabytes',0,0,NULL,NULL),('2025-12-05 10:24:58.627836','2025-12-05 10:25:44.224898','2025-12-05 10:25:47.115253',256,256,NULL,'36912d7f29d447c599e209c5c44b5e67','shares',0,0,NULL,'0dff1eca-99a2-46e2-baf4-1d68cc8f73d0'),('2025-12-05 10:24:58.629748','2025-12-05 10:25:44.224899','2025-12-05 10:25:47.115253',257,257,NULL,'36912d7f29d447c599e209c5c44b5e67','gigabytes',0,0,NULL,'0dff1eca-99a2-46e2-baf4-1d68cc8f73d0'),('2025-12-05 10:25:01.936895','2025-12-05 10:25:40.599288',NULL,0,258,'74265aa1d78a4e7b88e6d5a3f456ee7f','36912d7f29d447c599e209c5c44b5e67','snapshots',0,0,NULL,NULL),('2025-12-05 10:25:01.939154','2025-12-05 10:25:40.599292',NULL,0,259,'74265aa1d78a4e7b88e6d5a3f456ee7f','36912d7f29d447c599e209c5c44b5e67','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-05 10:25:01.950317','2025-12-05 10:25:40.599295','2025-12-05 10:25:47.115253',260,260,NULL,'36912d7f29d447c599e209c5c44b5e67','snapshots',0,0,NULL,'0dff1eca-99a2-46e2-baf4-1d68cc8f73d0'),('2025-12-05 10:25:01.952586','2025-12-05 10:25:40.599297','2025-12-05 10:25:47.115253',261,261,NULL,'36912d7f29d447c599e209c5c44b5e67','snapshot_gigabytes',0,0,NULL,'0dff1eca-99a2-46e2-baf4-1d68cc8f73d0'),('2025-12-05 10:25:56.017566','2025-12-05 10:26:20.247711',NULL,0,262,'9162904f23a24ab7af89d7341508e1af','4449f83142e34bd587691a836b6932e6','shares',0,0,NULL,NULL),('2025-12-05 10:25:56.020003','2025-12-05 10:26:20.247715',NULL,0,263,'9162904f23a24ab7af89d7341508e1af','4449f83142e34bd587691a836b6932e6','gigabytes',0,0,NULL,NULL),('2025-12-05 10:25:56.031352','2025-12-05 10:26:20.247717','2025-12-05 10:26:23.115275',264,264,NULL,'4449f83142e34bd587691a836b6932e6','shares',0,0,NULL,'0e16d78c-807b-44d3-8c5d-9e246527f3b7'),('2025-12-05 10:25:56.033821','2025-12-05 10:26:20.247719','2025-12-05 10:26:23.115275',265,265,NULL,'4449f83142e34bd587691a836b6932e6','gigabytes',0,0,NULL,'0e16d78c-807b-44d3-8c5d-9e246527f3b7'),('2025-12-05 10:25:59.275258','2025-12-05 10:26:17.407226',NULL,0,266,'9162904f23a24ab7af89d7341508e1af','4449f83142e34bd587691a836b6932e6','snapshots',0,0,NULL,NULL),('2025-12-05 10:25:59.278705','2025-12-05 10:26:17.407228',NULL,0,267,'9162904f23a24ab7af89d7341508e1af','4449f83142e34bd587691a836b6932e6','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-05 10:25:59.291387','2025-12-05 10:26:17.407230','2025-12-05 10:26:23.115275',268,268,NULL,'4449f83142e34bd587691a836b6932e6','snapshots',0,0,NULL,'0e16d78c-807b-44d3-8c5d-9e246527f3b7'),('2025-12-05 10:25:59.294053','2025-12-05 10:26:17.407231','2025-12-05 10:26:23.115275',269,269,NULL,'4449f83142e34bd587691a836b6932e6','snapshot_gigabytes',0,0,NULL,'0e16d78c-807b-44d3-8c5d-9e246527f3b7');
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
INSERT INTO `quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `project_id`, `resource`, `hard_limit`) VALUES (1,'2025-12-05 10:12:05.016678',NULL,'2025-12-05 10:12:19.656650',1,'d34a70d4c87b4bccbac035ee2005a967','shares',3),(2,'2025-12-05 10:12:05.022654',NULL,'2025-12-05 10:12:19.656650',2,'d34a70d4c87b4bccbac035ee2005a967','gigabytes',10),(3,'2025-12-05 10:12:19.929332',NULL,'2025-12-05 10:12:20.408457',3,'d34a70d4c87b4bccbac035ee2005a967','shares',55),(4,'2025-12-05 10:12:20.085605',NULL,'2025-12-05 10:12:20.408457',4,'d34a70d4c87b4bccbac035ee2005a967','snapshots',55),(5,'2025-12-05 10:12:20.096508',NULL,'2025-12-05 10:12:20.408457',5,'d34a70d4c87b4bccbac035ee2005a967','gigabytes',1005),(6,'2025-12-05 10:12:20.105121',NULL,'2025-12-05 10:12:20.408457',6,'d34a70d4c87b4bccbac035ee2005a967','snapshot_gigabytes',1005),(7,'2025-12-05 10:12:20.118821',NULL,'2025-12-05 10:12:20.408457',7,'d34a70d4c87b4bccbac035ee2005a967','share_replicas',105),(8,'2025-12-05 10:12:20.151556',NULL,'2025-12-05 10:12:20.408457',8,'d34a70d4c87b4bccbac035ee2005a967','replica_gigabytes',1005),(9,'2025-12-05 10:12:20.540537',NULL,'2025-12-05 10:12:20.978109',9,'d34a70d4c87b4bccbac035ee2005a967','shares',55),(10,'2025-12-05 10:12:20.596350',NULL,'2025-12-05 10:12:20.978109',10,'d34a70d4c87b4bccbac035ee2005a967','snapshots',55),(11,'2025-12-05 10:12:20.607737',NULL,'2025-12-05 10:12:20.978109',11,'d34a70d4c87b4bccbac035ee2005a967','gigabytes',1005),(12,'2025-12-05 10:12:20.617078',NULL,'2025-12-05 10:12:20.978109',12,'d34a70d4c87b4bccbac035ee2005a967','snapshot_gigabytes',1005),(13,'2025-12-05 10:12:20.621642',NULL,'2025-12-05 10:12:20.978109',13,'d34a70d4c87b4bccbac035ee2005a967','share_replicas',105),(14,'2025-12-05 10:12:20.627874',NULL,'2025-12-05 10:12:20.978109',14,'d34a70d4c87b4bccbac035ee2005a967','replica_gigabytes',1005),(15,'2025-12-05 10:12:21.111546',NULL,'2025-12-05 10:12:21.229257',15,'d34a70d4c87b4bccbac035ee2005a967','shares',52),(16,'2025-12-05 10:12:21.116312',NULL,'2025-12-05 10:12:21.229257',16,'d34a70d4c87b4bccbac035ee2005a967','snapshots',52),(17,'2025-12-05 10:12:21.130230',NULL,'2025-12-05 10:12:21.229257',17,'d34a70d4c87b4bccbac035ee2005a967','gigabytes',1002),(18,'2025-12-05 10:12:21.139328',NULL,'2025-12-05 10:12:21.229257',18,'d34a70d4c87b4bccbac035ee2005a967','snapshot_gigabytes',1002),(19,'2025-12-05 10:12:21.147969',NULL,'2025-12-05 10:12:21.229257',19,'d34a70d4c87b4bccbac035ee2005a967','share_networks',12),(20,'2025-12-05 10:12:21.158708',NULL,'2025-12-05 10:12:21.229257',20,'d34a70d4c87b4bccbac035ee2005a967','share_replicas',102),(21,'2025-12-05 10:12:21.165040',NULL,'2025-12-05 10:12:21.229257',21,'d34a70d4c87b4bccbac035ee2005a967','replica_gigabytes',1002),(22,'2025-12-05 10:12:21.364261',NULL,'2025-12-05 10:12:21.955747',22,'d34a70d4c87b4bccbac035ee2005a967','shares',13),(23,'2025-12-05 10:12:22.022573',NULL,'2025-12-05 10:12:22.075360',23,'d34a70d4c87b4bccbac035ee2005a967','gigabytes',-1),(24,'2025-12-05 10:12:22.251248',NULL,'2025-12-05 10:12:22.303361',24,'d34a70d4c87b4bccbac035ee2005a967','share_replicas',-1),(25,'2025-12-05 10:12:22.370463',NULL,'2025-12-05 10:12:22.508827',25,'d34a70d4c87b4bccbac035ee2005a967','replica_gigabytes',-1),(26,'2025-12-05 10:12:22.621559',NULL,'2025-12-05 10:12:22.779205',26,'d34a70d4c87b4bccbac035ee2005a967','share_networks',-1),(27,'2025-12-05 10:12:22.916898',NULL,'2025-12-05 10:12:22.987950',27,'d34a70d4c87b4bccbac035ee2005a967','shares',-1),(28,'2025-12-05 10:12:23.397182',NULL,'2025-12-05 10:12:23.454641',28,'d34a70d4c87b4bccbac035ee2005a967','snapshot_gigabytes',-1),(29,'2025-12-05 10:12:23.574519',NULL,'2025-12-05 10:12:23.626273',29,'d34a70d4c87b4bccbac035ee2005a967','snapshots',-1),(30,'2025-12-05 10:12:26.246277',NULL,'2025-12-05 10:12:26.463708',30,'d34a70d4c87b4bccbac035ee2005a967','shares',10),(31,'2025-12-05 10:12:26.592222',NULL,'2025-12-05 10:12:26.763202',31,'d34a70d4c87b4bccbac035ee2005a967','shares',10),(32,'2025-12-05 10:12:26.859407',NULL,'2025-12-05 10:12:26.880968',32,'d34a70d4c87b4bccbac035ee2005a967','gigabytes',1002),(33,'2025-12-05 10:12:26.974794',NULL,'2025-12-05 10:12:27.006459',33,'d34a70d4c87b4bccbac035ee2005a967','share_networks',12),(34,'2025-12-05 10:12:27.119485',NULL,'2025-12-05 10:12:27.165976',34,'d34a70d4c87b4bccbac035ee2005a967','shares',52),(35,'2025-12-05 10:12:27.269773',NULL,'2025-12-05 10:12:27.304833',35,'d34a70d4c87b4bccbac035ee2005a967','snapshot_gigabytes',1002),(36,'2025-12-05 10:12:27.504717',NULL,'2025-12-05 10:12:27.555344',36,'d34a70d4c87b4bccbac035ee2005a967','snapshots',52),(37,'2025-12-05 10:12:28.097385',NULL,'2025-12-05 10:12:28.159082',37,'d34a70d4c87b4bccbac035ee2005a967','share_replicas',99),(38,'2025-12-05 10:12:28.392395',NULL,'2025-12-05 10:12:28.413804',38,'d34a70d4c87b4bccbac035ee2005a967','replica_gigabytes',999),(39,'2025-12-05 10:12:29.148757',NULL,'2025-12-05 10:12:29.281761',39,'d34a70d4c87b4bccbac035ee2005a967','shares',10),(40,'2025-12-05 10:12:29.331617',NULL,'2025-12-05 10:12:29.456137',40,'d34a70d4c87b4bccbac035ee2005a967','shares',10),(41,'2025-12-05 10:12:57.891208',NULL,'2025-12-05 10:12:58.130278',41,'7ed90e6d1b7c4872853af83191db9808','shares',1),(42,'2025-12-05 10:13:03.346448',NULL,'2025-12-05 10:13:08.064127',42,'7ed90e6d1b7c4872853af83191db9808','snapshots',1),(43,'2025-12-05 10:13:13.126784',NULL,'2025-12-05 10:13:13.214879',43,'7ed90e6d1b7c4872853af83191db9808','shares',10),(44,'2025-12-05 10:13:13.281659',NULL,'2025-12-05 10:13:13.386265',44,'7ed90e6d1b7c4872853af83191db9808','shares',10);
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) NOT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `usage_id` (`usage_id`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=979 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
INSERT INTO `reservations` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `uuid`, `usage_id`, `project_id`, `resource`, `delta`, `expire`, `share_type_id`) VALUES ('2025-12-05 10:09:47.394711',NULL,'2025-12-05 10:09:47.465487',1,1,'2ea873f665ba41948906baac5e68b7c6','7748e832-66fa-45c6-b70e-cc81a2075eee',1,'1220f950d9bb436099f84f4762bc2e27','shares',1,'2025-12-06 10:09:47',NULL),('2025-12-05 10:09:47.396728',NULL,'2025-12-05 10:09:47.465487',2,2,'2ea873f665ba41948906baac5e68b7c6','b43caf72-3129-44f4-8264-b5168586dbb3',2,'1220f950d9bb436099f84f4762bc2e27','gigabytes',1,'2025-12-06 10:09:47',NULL),('2025-12-05 10:09:47.413860',NULL,'2025-12-05 10:09:47.465487',3,3,NULL,'e869d6f4-273b-42f9-bb42-11148a5ca373',3,'1220f950d9bb436099f84f4762bc2e27','shares',1,'2025-12-06 10:09:47','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:09:47.414941',NULL,'2025-12-05 10:09:47.465487',4,4,NULL,'b04bc5a8-7691-4254-b11f-4f11887318a9',4,'1220f950d9bb436099f84f4762bc2e27','gigabytes',1,'2025-12-06 10:09:47','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:09:52.191759',NULL,'2025-12-05 10:09:52.235156',5,5,'2ea873f665ba41948906baac5e68b7c6','630ffec9-61a8-418c-9ee4-caa0762ae14c',1,'1220f950d9bb436099f84f4762bc2e27','shares',1,'2025-12-06 10:09:52',NULL),('2025-12-05 10:09:52.193396',NULL,'2025-12-05 10:09:52.235156',6,6,'2ea873f665ba41948906baac5e68b7c6','9e7130e2-8150-4a71-a326-035ff3396106',2,'1220f950d9bb436099f84f4762bc2e27','gigabytes',1,'2025-12-06 10:09:52',NULL),('2025-12-05 10:09:52.200981',NULL,'2025-12-05 10:09:52.235156',7,7,NULL,'94aa581e-bd02-4cc8-808c-a0d0dc166b93',3,'1220f950d9bb436099f84f4762bc2e27','shares',1,'2025-12-06 10:09:52','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:09:52.202952',NULL,'2025-12-05 10:09:52.235156',8,8,NULL,'0bbe6189-ce92-4109-aed0-6008cb329759',4,'1220f950d9bb436099f84f4762bc2e27','gigabytes',1,'2025-12-06 10:09:52','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:09:55.527462',NULL,'2025-12-05 10:09:56.567202',9,9,'2ea873f665ba41948906baac5e68b7c6','dccabea5-af0a-4ccd-b060-9bf89e29f745',2,'1220f950d9bb436099f84f4762bc2e27','gigabytes',1,'2025-12-06 10:09:55',NULL),('2025-12-05 10:09:56.420421',NULL,'2025-12-05 10:09:56.567202',10,10,NULL,'0d5894d7-fea4-4957-9211-1ac462068e39',4,'1220f950d9bb436099f84f4762bc2e27','gigabytes',1,'2025-12-06 10:09:55','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:09:57.608336',NULL,'2025-12-05 10:09:57.627965',11,11,'2ea873f665ba41948906baac5e68b7c6','ea182972-03cd-4569-8913-1b9f1a85e26c',1,'1220f950d9bb436099f84f4762bc2e27','shares',-1,'2025-12-06 10:09:57',NULL),('2025-12-05 10:09:57.610059',NULL,'2025-12-05 10:09:57.627965',12,12,'2ea873f665ba41948906baac5e68b7c6','7c4b2122-689e-4c72-bd42-0e787444d7b3',2,'1220f950d9bb436099f84f4762bc2e27','gigabytes',-2,'2025-12-06 10:09:57',NULL),('2025-12-05 10:09:57.617566',NULL,'2025-12-05 10:09:57.627965',13,13,NULL,'82381815-2754-4782-9aec-f78f25b370b6',3,'1220f950d9bb436099f84f4762bc2e27','shares',-1,'2025-12-06 10:09:57','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:09:57.618524',NULL,'2025-12-05 10:09:57.627965',14,14,NULL,'40fa3c1a-2f95-4ca1-852d-b0304170192f',4,'1220f950d9bb436099f84f4762bc2e27','gigabytes',-2,'2025-12-06 10:09:57','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:10:00.341686',NULL,'2025-12-05 10:10:00.370465',15,15,'2ea873f665ba41948906baac5e68b7c6','087fdbca-07e8-44b3-9368-783ea5cb722c',1,'1220f950d9bb436099f84f4762bc2e27','shares',1,'2025-12-06 10:10:00',NULL),('2025-12-05 10:10:00.343725',NULL,'2025-12-05 10:10:00.370465',16,16,'2ea873f665ba41948906baac5e68b7c6','57466d25-a9be-46a5-9c55-e40ea1cc07fb',2,'1220f950d9bb436099f84f4762bc2e27','gigabytes',1,'2025-12-06 10:10:00',NULL),('2025-12-05 10:10:00.350353',NULL,'2025-12-05 10:10:00.370465',17,17,NULL,'7815a696-aac5-4320-8eb8-594575e9931b',3,'1220f950d9bb436099f84f4762bc2e27','shares',1,'2025-12-06 10:10:00','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:10:00.351404',NULL,'2025-12-05 10:10:00.370465',18,18,NULL,'f819f77a-f296-42db-aa68-6527551595ad',4,'1220f950d9bb436099f84f4762bc2e27','gigabytes',1,'2025-12-06 10:10:00','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:10:03.682565',NULL,'2025-12-05 10:10:04.382554',19,19,'2ea873f665ba41948906baac5e68b7c6','a5c4d967-c932-42b2-9ac8-f015e425ec98',2,'1220f950d9bb436099f84f4762bc2e27','gigabytes',1,'2025-12-06 10:10:03',NULL),('2025-12-05 10:10:03.903107',NULL,'2025-12-05 10:10:04.382554',20,20,NULL,'1bba1cce-00b3-4141-8b3d-48291d53160d',4,'1220f950d9bb436099f84f4762bc2e27','gigabytes',1,'2025-12-06 10:10:03','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:10:07.882806',NULL,'2025-12-05 10:10:07.905748',21,21,'2ea873f665ba41948906baac5e68b7c6','66545e07-0e7f-4ac4-8eb2-7fb1f00e35fd',1,'1220f950d9bb436099f84f4762bc2e27','shares',-1,'2025-12-06 10:10:07',NULL),('2025-12-05 10:10:07.883655',NULL,'2025-12-05 10:10:07.905748',22,22,'2ea873f665ba41948906baac5e68b7c6','8c5b5205-f232-49bf-89fc-d31a89fdaad0',2,'1220f950d9bb436099f84f4762bc2e27','gigabytes',-2,'2025-12-06 10:10:07',NULL),('2025-12-05 10:10:07.896424',NULL,'2025-12-05 10:10:07.905748',23,23,NULL,'aafd4e69-4cab-4bf4-b297-df7ce3d91096',3,'1220f950d9bb436099f84f4762bc2e27','shares',-1,'2025-12-06 10:10:07','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:10:07.897425',NULL,'2025-12-05 10:10:07.905748',24,24,NULL,'b12af4fd-e6f7-4289-a6a9-61eb2fb061f3',4,'1220f950d9bb436099f84f4762bc2e27','gigabytes',-2,'2025-12-06 10:10:07','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:10:10.788549',NULL,'2025-12-05 10:10:10.826780',25,25,'2ea873f665ba41948906baac5e68b7c6','0f96af52-bb24-4996-ad28-2893065afadf',1,'1220f950d9bb436099f84f4762bc2e27','shares',1,'2025-12-06 10:10:10',NULL),('2025-12-05 10:10:10.790576',NULL,'2025-12-05 10:10:10.826780',26,26,'2ea873f665ba41948906baac5e68b7c6','ccff776c-f4b8-4e03-9abe-4a4d60a07dce',2,'1220f950d9bb436099f84f4762bc2e27','gigabytes',1,'2025-12-06 10:10:10',NULL),('2025-12-05 10:10:10.802115',NULL,'2025-12-05 10:10:10.826780',27,27,NULL,'cc8c1b21-34a4-48f9-8a0d-cb8c05b957c8',3,'1220f950d9bb436099f84f4762bc2e27','shares',1,'2025-12-06 10:10:10','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:10:10.803737',NULL,'2025-12-05 10:10:10.826780',28,28,NULL,'cdcf6082-e1b6-4f69-8605-b4eb2814ff2a',4,'1220f950d9bb436099f84f4762bc2e27','gigabytes',1,'2025-12-06 10:10:10','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:10:14.489979',NULL,'2025-12-05 10:10:14.507216',29,29,'2ea873f665ba41948906baac5e68b7c6','c65c8a36-aa9e-4c13-a539-f7ea898a4ca9',1,'1220f950d9bb436099f84f4762bc2e27','shares',-1,'2025-12-06 10:10:14',NULL),('2025-12-05 10:10:14.490833',NULL,'2025-12-05 10:10:14.507216',30,30,'2ea873f665ba41948906baac5e68b7c6','9fe85201-f1d2-40aa-9d56-770fa2a0a07d',2,'1220f950d9bb436099f84f4762bc2e27','gigabytes',-1,'2025-12-06 10:10:14',NULL),('2025-12-05 10:10:14.496833',NULL,'2025-12-05 10:10:14.507216',31,31,NULL,'545a2977-a1ac-430f-ae1d-19de8764e616',3,'1220f950d9bb436099f84f4762bc2e27','shares',-1,'2025-12-06 10:10:14','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:10:14.497956',NULL,'2025-12-05 10:10:14.507216',32,32,NULL,'b88df68b-9e2d-41fc-a26f-b9375d69672e',4,'1220f950d9bb436099f84f4762bc2e27','gigabytes',-1,'2025-12-06 10:10:14','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:10:17.425421',NULL,'2025-12-05 10:10:17.474580',33,33,'2ea873f665ba41948906baac5e68b7c6','2fcbc524-95e0-4c96-b04c-5722171e1cd7',1,'1220f950d9bb436099f84f4762bc2e27','shares',1,'2025-12-06 10:10:17',NULL),('2025-12-05 10:10:17.428921',NULL,'2025-12-05 10:10:17.474580',34,34,'2ea873f665ba41948906baac5e68b7c6','a435fefd-3d65-43d4-8df1-b3382e2cd1cd',2,'1220f950d9bb436099f84f4762bc2e27','gigabytes',1,'2025-12-06 10:10:17',NULL),('2025-12-05 10:10:17.441382',NULL,'2025-12-05 10:10:17.474580',35,35,NULL,'2ce92660-f4d8-4dcc-88b1-b940528f8d74',3,'1220f950d9bb436099f84f4762bc2e27','shares',1,'2025-12-06 10:10:17','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:10:17.442927',NULL,'2025-12-05 10:10:17.474580',36,36,NULL,'31c1ef16-69fc-415d-988b-cb25a809110c',4,'1220f950d9bb436099f84f4762bc2e27','gigabytes',1,'2025-12-06 10:10:17','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:10:21.239710',NULL,'2025-12-05 10:10:21.253259',37,37,'2ea873f665ba41948906baac5e68b7c6','01c19f3b-8621-43c3-835a-616c64bb891f',1,'1220f950d9bb436099f84f4762bc2e27','shares',-1,'2025-12-06 10:10:21',NULL),('2025-12-05 10:10:21.240388',NULL,'2025-12-05 10:10:21.253259',38,38,'2ea873f665ba41948906baac5e68b7c6','97452878-92a0-4d61-ae03-6eeba695e5a1',2,'1220f950d9bb436099f84f4762bc2e27','gigabytes',-1,'2025-12-06 10:10:21',NULL),('2025-12-05 10:10:21.245236',NULL,'2025-12-05 10:10:21.253259',39,39,NULL,'b04cbbf0-03cd-4480-bfcf-fa9e3df6b031',3,'1220f950d9bb436099f84f4762bc2e27','shares',-1,'2025-12-06 10:10:21','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:10:21.246165',NULL,'2025-12-05 10:10:21.253259',40,40,NULL,'34ff1c4f-ca4c-4394-b945-cf9042c773a1',4,'1220f950d9bb436099f84f4762bc2e27','gigabytes',-1,'2025-12-06 10:10:21','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:10:24.135155',NULL,'2025-12-05 10:10:24.409811',41,41,'2ea873f665ba41948906baac5e68b7c6','9171cc4b-c274-4089-87b1-d340b928e4d4',6,'1220f950d9bb436099f84f4762bc2e27','snapshots',1,'2025-12-06 10:10:24',NULL),('2025-12-05 10:10:24.136460',NULL,'2025-12-05 10:10:24.409811',42,42,'2ea873f665ba41948906baac5e68b7c6','d70e7968-16be-4d3a-aaa8-03ce505a6add',5,'1220f950d9bb436099f84f4762bc2e27','snapshot_gigabytes',1,'2025-12-06 10:10:24',NULL),('2025-12-05 10:10:24.271805',NULL,'2025-12-05 10:10:24.409811',43,43,NULL,'b0cb02b1-582a-49a0-b270-806b3b6140ad',8,'1220f950d9bb436099f84f4762bc2e27','snapshots',1,'2025-12-06 10:10:24','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:10:24.276602',NULL,'2025-12-05 10:10:24.409811',44,44,NULL,'bce63674-173e-4197-8296-bf5f04ae8814',7,'1220f950d9bb436099f84f4762bc2e27','snapshot_gigabytes',1,'2025-12-06 10:10:24','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:10:28.344349',NULL,'2025-12-05 10:10:28.366395',45,45,'2ea873f665ba41948906baac5e68b7c6','436a30a6-06eb-4805-a3cb-e77af843b49d',6,'1220f950d9bb436099f84f4762bc2e27','snapshots',-1,'2025-12-06 10:10:28',NULL),('2025-12-05 10:10:28.345381',NULL,'2025-12-05 10:10:28.366395',46,46,'2ea873f665ba41948906baac5e68b7c6','0d9033d1-b07a-490d-862f-997090b3b98a',5,'1220f950d9bb436099f84f4762bc2e27','snapshot_gigabytes',-1,'2025-12-06 10:10:28',NULL),('2025-12-05 10:10:28.357256',NULL,'2025-12-05 10:10:28.366395',47,47,NULL,'ce8e2588-b26e-4cb9-9aa1-84f69a707337',8,'1220f950d9bb436099f84f4762bc2e27','snapshots',-1,'2025-12-06 10:10:28','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:10:28.358107',NULL,'2025-12-05 10:10:28.366395',48,48,NULL,'c1365f69-9677-442c-947b-88ca34bd4abb',7,'1220f950d9bb436099f84f4762bc2e27','snapshot_gigabytes',-1,'2025-12-06 10:10:28','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:10:35.847379',NULL,'2025-12-05 10:10:36.448408',49,49,'2ea873f665ba41948906baac5e68b7c6','7a6d0ed6-0266-4e03-9c2e-c442f3f0ae44',6,'1220f950d9bb436099f84f4762bc2e27','snapshots',1,'2025-12-06 10:10:35',NULL),('2025-12-05 10:10:35.848684',NULL,'2025-12-05 10:10:36.448408',50,50,'2ea873f665ba41948906baac5e68b7c6','159c1e85-b990-4ebc-b171-56e2d1ed70c7',5,'1220f950d9bb436099f84f4762bc2e27','snapshot_gigabytes',1,'2025-12-06 10:10:35',NULL),('2025-12-05 10:10:36.300015',NULL,'2025-12-05 10:10:36.448408',51,51,NULL,'cebefdb0-f565-4508-8a74-c77f6ef41bd9',8,'1220f950d9bb436099f84f4762bc2e27','snapshots',1,'2025-12-06 10:10:35','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:10:36.301697',NULL,'2025-12-05 10:10:36.448408',52,52,NULL,'1bd5582a-6dd5-464e-bf27-335f0e0bc136',7,'1220f950d9bb436099f84f4762bc2e27','snapshot_gigabytes',1,'2025-12-06 10:10:35','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:10:40.236633',NULL,'2025-12-05 10:10:40.432337',53,53,'2ea873f665ba41948906baac5e68b7c6','5559b9bb-8dac-4f51-97b3-601ee300ff37',6,'1220f950d9bb436099f84f4762bc2e27','snapshots',1,'2025-12-06 10:10:40',NULL),('2025-12-05 10:10:40.238537',NULL,'2025-12-05 10:10:40.432337',54,54,'2ea873f665ba41948906baac5e68b7c6','5458b672-bb36-4c03-a8bf-d5adf64dd671',5,'1220f950d9bb436099f84f4762bc2e27','snapshot_gigabytes',1,'2025-12-06 10:10:40',NULL),('2025-12-05 10:10:40.250724',NULL,'2025-12-05 10:10:40.432337',55,55,NULL,'fa79979e-be86-432d-9a71-ae1aeb5b0cf5',8,'1220f950d9bb436099f84f4762bc2e27','snapshots',1,'2025-12-06 10:10:40','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:10:40.253155',NULL,'2025-12-05 10:10:40.432337',56,56,NULL,'783849c3-7f18-4dee-a782-5f7e2c5c3a69',7,'1220f950d9bb436099f84f4762bc2e27','snapshot_gigabytes',1,'2025-12-06 10:10:40','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:10:43.942310',NULL,'2025-12-05 10:10:44.143197',57,57,'2ea873f665ba41948906baac5e68b7c6','92d21b7e-0f36-4fc7-88d7-0bb0ca3551fb',6,'1220f950d9bb436099f84f4762bc2e27','snapshots',1,'2025-12-06 10:10:43',NULL),('2025-12-05 10:10:43.943603',NULL,'2025-12-05 10:10:44.143197',58,58,'2ea873f665ba41948906baac5e68b7c6','338ad224-038f-4db7-8aaf-40675f992f58',5,'1220f950d9bb436099f84f4762bc2e27','snapshot_gigabytes',1,'2025-12-06 10:10:43',NULL),('2025-12-05 10:10:44.001881',NULL,'2025-12-05 10:10:44.143197',59,59,NULL,'70a76fdf-271a-4506-9ba3-fe9a528ae075',8,'1220f950d9bb436099f84f4762bc2e27','snapshots',1,'2025-12-06 10:10:43','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:10:44.003961',NULL,'2025-12-05 10:10:44.143197',60,60,NULL,'5c20d29c-95d9-4644-9f28-694882cdba4f',7,'1220f950d9bb436099f84f4762bc2e27','snapshot_gigabytes',1,'2025-12-06 10:10:43','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:10:48.532063',NULL,'2025-12-05 10:10:48.642220',61,61,'2ea873f665ba41948906baac5e68b7c6','59c180e1-785e-4547-8fec-1c4102b8546b',6,'1220f950d9bb436099f84f4762bc2e27','snapshots',1,'2025-12-06 10:10:48',NULL),('2025-12-05 10:10:48.534056',NULL,'2025-12-05 10:10:48.642220',62,62,'2ea873f665ba41948906baac5e68b7c6','1e4ac6aa-1c49-4626-bd2c-63d98f0999dd',5,'1220f950d9bb436099f84f4762bc2e27','snapshot_gigabytes',1,'2025-12-06 10:10:48',NULL),('2025-12-05 10:10:48.540463',NULL,'2025-12-05 10:10:48.642220',63,63,NULL,'b527c3bc-d802-4de8-8c9e-f81e5046517d',8,'1220f950d9bb436099f84f4762bc2e27','snapshots',1,'2025-12-06 10:10:48','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:10:48.541524',NULL,'2025-12-05 10:10:48.642220',64,64,NULL,'cca85bcf-4ad8-4e5e-9d7e-3457d9e5beb2',7,'1220f950d9bb436099f84f4762bc2e27','snapshot_gigabytes',1,'2025-12-06 10:10:48','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:10:52.131904',NULL,'2025-12-05 10:10:52.234431',65,65,'2ea873f665ba41948906baac5e68b7c6','acaa39d3-f8a0-4345-9857-92b141dea4df',6,'1220f950d9bb436099f84f4762bc2e27','snapshots',1,'2025-12-06 10:10:52',NULL),('2025-12-05 10:10:52.133858',NULL,'2025-12-05 10:10:52.234431',66,66,'2ea873f665ba41948906baac5e68b7c6','63d5aa72-f502-4b92-8ada-31eaba161ab8',5,'1220f950d9bb436099f84f4762bc2e27','snapshot_gigabytes',1,'2025-12-06 10:10:52',NULL),('2025-12-05 10:10:52.141131',NULL,'2025-12-05 10:10:52.234431',67,67,NULL,'1ebe29a2-f82a-4161-8a5b-c74bcb64212a',8,'1220f950d9bb436099f84f4762bc2e27','snapshots',1,'2025-12-06 10:10:52','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:10:52.142321',NULL,'2025-12-05 10:10:52.234431',68,68,NULL,'2a9f1c95-2f17-487b-b77d-b15a62457f88',7,'1220f950d9bb436099f84f4762bc2e27','snapshot_gigabytes',1,'2025-12-06 10:10:52','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:10:58.662777',NULL,'2025-12-05 10:10:59.640405',69,69,'2ea873f665ba41948906baac5e68b7c6','2fc18eba-9ad9-4452-953b-1550d9844af7',6,'1220f950d9bb436099f84f4762bc2e27','snapshots',-1,'2025-12-06 10:10:58',NULL),('2025-12-05 10:10:58.664413',NULL,'2025-12-05 10:10:59.640405',70,70,'2ea873f665ba41948906baac5e68b7c6','3868a6d7-bf2c-4511-924b-01df72b6ffe1',5,'1220f950d9bb436099f84f4762bc2e27','snapshot_gigabytes',-1,'2025-12-06 10:10:58',NULL),('2025-12-05 10:10:59.245392',NULL,'2025-12-05 10:10:59.640405',71,71,NULL,'cc9237fb-c2aa-4d62-b33e-94a25270a69e',8,'1220f950d9bb436099f84f4762bc2e27','snapshots',-1,'2025-12-06 10:10:58','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:10:59.246428',NULL,'2025-12-05 10:10:59.640405',72,72,NULL,'91dd7ac1-e52e-4ca4-8cd8-858912dcfee8',7,'1220f950d9bb436099f84f4762bc2e27','snapshot_gigabytes',-1,'2025-12-06 10:10:58','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:11:04.863316',NULL,'2025-12-05 10:11:05.085926',73,73,'2ea873f665ba41948906baac5e68b7c6','0bf1fc49-5847-41f6-8495-c6546ec2bfc2',6,'1220f950d9bb436099f84f4762bc2e27','snapshots',-1,'2025-12-06 10:11:04',NULL),('2025-12-05 10:11:04.864026',NULL,'2025-12-05 10:11:05.085926',74,74,'2ea873f665ba41948906baac5e68b7c6','28057c9f-d45b-440f-b35d-84830aa5f2ad',5,'1220f950d9bb436099f84f4762bc2e27','snapshot_gigabytes',-1,'2025-12-06 10:11:04',NULL),('2025-12-05 10:11:04.955194',NULL,'2025-12-05 10:11:05.085926',75,75,NULL,'1088d787-44a8-45bc-b802-99b224f905b1',8,'1220f950d9bb436099f84f4762bc2e27','snapshots',-1,'2025-12-06 10:11:04','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:11:04.956080',NULL,'2025-12-05 10:11:05.085926',76,76,NULL,'48784198-b432-4a32-9459-680b34d12a81',7,'1220f950d9bb436099f84f4762bc2e27','snapshot_gigabytes',-1,'2025-12-06 10:11:04','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:11:10.874004',NULL,'2025-12-05 10:11:15.465693',77,77,'2ea873f665ba41948906baac5e68b7c6','213fac55-a3f9-4d72-9998-8d80edc27132',6,'1220f950d9bb436099f84f4762bc2e27','snapshots',-1,'2025-12-06 10:11:10',NULL),('2025-12-05 10:11:10.875712',NULL,'2025-12-05 10:11:15.465693',78,78,'2ea873f665ba41948906baac5e68b7c6','fa722c08-5914-47e7-919d-ab71cf15d682',5,'1220f950d9bb436099f84f4762bc2e27','snapshot_gigabytes',-1,'2025-12-06 10:11:10',NULL),('2025-12-05 10:11:12.631422',NULL,'2025-12-05 10:11:15.465693',79,79,NULL,'7b90b27f-1c1f-4d40-8328-6c365c4b950b',8,'1220f950d9bb436099f84f4762bc2e27','snapshots',-1,'2025-12-06 10:11:10','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:11:12.635811',NULL,'2025-12-05 10:11:15.465693',80,80,NULL,'10714c9e-eac6-4d93-ad3a-037bd9ae673b',7,'1220f950d9bb436099f84f4762bc2e27','snapshot_gigabytes',-1,'2025-12-06 10:11:10','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:11:15.728308',NULL,'2025-12-05 10:11:15.768263',81,81,'2ea873f665ba41948906baac5e68b7c6','10bd531c-9365-4415-b178-9f1c2596831b',6,'1220f950d9bb436099f84f4762bc2e27','snapshots',-1,'2025-12-06 10:11:15',NULL),('2025-12-05 10:11:15.729334',NULL,'2025-12-05 10:11:15.768263',82,82,'2ea873f665ba41948906baac5e68b7c6','c38a56ad-23e9-4d91-bb00-015f6877944b',5,'1220f950d9bb436099f84f4762bc2e27','snapshot_gigabytes',-1,'2025-12-06 10:11:15',NULL),('2025-12-05 10:11:15.760607',NULL,'2025-12-05 10:11:15.768263',83,83,NULL,'a0bebd95-ffcc-4931-bcc5-054ce22e7bf6',8,'1220f950d9bb436099f84f4762bc2e27','snapshots',-1,'2025-12-06 10:11:15','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:11:15.761480',NULL,'2025-12-05 10:11:15.768263',84,84,NULL,'8759d1b4-f07a-48b4-a09a-53627f35f2b6',7,'1220f950d9bb436099f84f4762bc2e27','snapshot_gigabytes',-1,'2025-12-06 10:11:15','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:11:18.927881',NULL,'2025-12-05 10:11:18.946811',85,85,'2ea873f665ba41948906baac5e68b7c6','d4fa0cab-307d-4036-ba9b-a9637a1202dc',6,'1220f950d9bb436099f84f4762bc2e27','snapshots',-1,'2025-12-06 10:11:18',NULL),('2025-12-05 10:11:18.928548',NULL,'2025-12-05 10:11:18.946811',86,86,'2ea873f665ba41948906baac5e68b7c6','69b47ee4-5232-4324-8e9a-ef5022c3fe96',5,'1220f950d9bb436099f84f4762bc2e27','snapshot_gigabytes',-1,'2025-12-06 10:11:18',NULL),('2025-12-05 10:11:18.933208',NULL,'2025-12-05 10:11:18.946811',87,87,NULL,'325ce774-c904-47e9-966b-9e8299d5db60',8,'1220f950d9bb436099f84f4762bc2e27','snapshots',-1,'2025-12-06 10:11:18','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:11:18.933842',NULL,'2025-12-05 10:11:18.946811',88,88,NULL,'7fa60258-c9e9-48b4-817f-fcff51d8f698',7,'1220f950d9bb436099f84f4762bc2e27','snapshot_gigabytes',-1,'2025-12-06 10:11:18','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:11:22.303317',NULL,'2025-12-05 10:11:22.323871',89,89,'2ea873f665ba41948906baac5e68b7c6','762c649f-1933-41ed-8b1b-f29cbde83073',1,'1220f950d9bb436099f84f4762bc2e27','shares',-1,'2025-12-06 10:11:22',NULL),('2025-12-05 10:11:22.307683',NULL,'2025-12-05 10:11:22.323871',90,90,'2ea873f665ba41948906baac5e68b7c6','3b6e44b1-f10a-4b52-a64d-94b170f5a05d',2,'1220f950d9bb436099f84f4762bc2e27','gigabytes',-1,'2025-12-06 10:11:22',NULL),('2025-12-05 10:11:22.313599',NULL,'2025-12-05 10:11:22.323871',91,91,NULL,'bc2bdefd-867d-4769-a47d-02cf01b09b84',3,'1220f950d9bb436099f84f4762bc2e27','shares',-1,'2025-12-06 10:11:22','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:11:22.314480',NULL,'2025-12-05 10:11:22.323871',92,92,NULL,'04c39a04-4df3-414b-8f62-05553024e65d',4,'1220f950d9bb436099f84f4762bc2e27','gigabytes',-1,'2025-12-06 10:11:22','c1ed5400-96ca-4915-b983-09de75ae2b3c'),('2025-12-05 10:11:37.749573',NULL,'2025-12-05 10:11:37.831145',93,93,'35818db97a7f48bba64f2172c36bcd92','8e1d8483-08e0-4944-83e3-95b445035800',9,'742c47288c43466fb15b8bc5e64971af','shares',1,'2025-12-06 10:11:37',NULL),('2025-12-05 10:11:37.751236',NULL,'2025-12-05 10:11:37.831145',94,94,'35818db97a7f48bba64f2172c36bcd92','c42b709c-5245-42c1-8d9f-3d95109f24a6',10,'742c47288c43466fb15b8bc5e64971af','gigabytes',1,'2025-12-06 10:11:37',NULL),('2025-12-05 10:11:37.787065',NULL,'2025-12-05 10:11:37.831145',95,95,NULL,'7ceb03a0-5c0c-4184-968d-049f7f8575f0',11,'742c47288c43466fb15b8bc5e64971af','shares',1,'2025-12-06 10:11:37','cf069f76-8f1e-439e-a467-0ee5ba9aa528'),('2025-12-05 10:11:37.789337',NULL,'2025-12-05 10:11:37.831145',96,96,NULL,'39c03a1f-82fa-44ec-97c8-936ff82d7a61',12,'742c47288c43466fb15b8bc5e64971af','gigabytes',1,'2025-12-06 10:11:37','cf069f76-8f1e-439e-a467-0ee5ba9aa528'),('2025-12-05 10:11:44.428470',NULL,'2025-12-05 10:11:44.443961',97,97,'35818db97a7f48bba64f2172c36bcd92','ed40b7a8-1638-44c3-80d1-cfc6df0d47bf',9,'742c47288c43466fb15b8bc5e64971af','shares',-1,'2025-12-06 10:11:44',NULL),('2025-12-05 10:11:44.429272',NULL,'2025-12-05 10:11:44.443961',98,98,'35818db97a7f48bba64f2172c36bcd92','73cf2437-90cc-425a-8f54-beb0238dd8a1',10,'742c47288c43466fb15b8bc5e64971af','gigabytes',-1,'2025-12-06 10:11:44',NULL),('2025-12-05 10:11:44.434702',NULL,'2025-12-05 10:11:44.443961',99,99,NULL,'67a92b89-c44f-40bd-b71d-854cce714558',11,'742c47288c43466fb15b8bc5e64971af','shares',-1,'2025-12-06 10:11:44','cf069f76-8f1e-439e-a467-0ee5ba9aa528'),('2025-12-05 10:11:44.435357',NULL,'2025-12-05 10:11:44.443961',100,100,NULL,'4779040d-e75b-4bd3-a53c-44c21dc1388b',12,'742c47288c43466fb15b8bc5e64971af','gigabytes',-1,'2025-12-06 10:11:44','cf069f76-8f1e-439e-a467-0ee5ba9aa528'),('2025-12-05 10:11:50.419766',NULL,'2025-12-05 10:11:50.464033',101,101,'348d267ee53941bbbb6824e764d06b33','de9e4dc3-81f9-4390-b557-7c4444e5be04',13,'f4c34f38ddb048808ef72391bdda40b5','shares',1,'2025-12-06 10:11:50',NULL),('2025-12-05 10:11:50.421190',NULL,'2025-12-05 10:11:50.464033',102,102,'348d267ee53941bbbb6824e764d06b33','c8700ab2-fc82-4094-9e1a-e286774404b9',14,'f4c34f38ddb048808ef72391bdda40b5','gigabytes',1,'2025-12-06 10:11:50',NULL),('2025-12-05 10:11:50.435069',NULL,'2025-12-05 10:11:50.464033',103,103,NULL,'b6156f6b-7fce-44ff-accb-90ec70977969',15,'f4c34f38ddb048808ef72391bdda40b5','shares',1,'2025-12-06 10:11:50','e8182e37-1b64-46cf-939e-d811c66cd270'),('2025-12-05 10:11:50.436352',NULL,'2025-12-05 10:11:50.464033',104,104,NULL,'adbb3b3a-49b7-4b3d-ad64-16cac2d09d84',16,'f4c34f38ddb048808ef72391bdda40b5','gigabytes',1,'2025-12-06 10:11:50','e8182e37-1b64-46cf-939e-d811c66cd270'),('2025-12-05 10:11:54.104918',NULL,'2025-12-05 10:11:54.160156',105,105,'348d267ee53941bbbb6824e764d06b33','e60d2a4f-61a8-4642-a5d6-be2c9388342e',13,'f4c34f38ddb048808ef72391bdda40b5','shares',1,'2025-12-06 10:11:54',NULL),('2025-12-05 10:11:54.107132',NULL,'2025-12-05 10:11:54.160156',106,106,'348d267ee53941bbbb6824e764d06b33','4023f013-2c6f-491e-b875-44556471d63d',14,'f4c34f38ddb048808ef72391bdda40b5','gigabytes',1,'2025-12-06 10:11:54',NULL),('2025-12-05 10:11:54.126469',NULL,'2025-12-05 10:11:54.160156',107,107,NULL,'14c57ef3-4c86-425c-b3b2-dfc11a520c01',17,'f4c34f38ddb048808ef72391bdda40b5','shares',1,'2025-12-06 10:11:54','449c8c2d-0435-4e20-be7a-0426a7732edb'),('2025-12-05 10:11:54.127983',NULL,'2025-12-05 10:11:54.160156',108,108,NULL,'1adbbd15-a172-44c7-9792-0eb3ef19f62c',18,'f4c34f38ddb048808ef72391bdda40b5','gigabytes',1,'2025-12-06 10:11:54','449c8c2d-0435-4e20-be7a-0426a7732edb'),('2025-12-05 10:12:00.933103',NULL,'2025-12-05 10:12:00.969362',109,109,'b576720ad2bb46dca8593baa5187080f','f71f5c67-d864-428e-9700-418cd6b103f1',19,'a1984fed702d4461879e97dd7c6fc401','shares',1,'2025-12-06 10:12:00',NULL),('2025-12-05 10:12:00.935196',NULL,'2025-12-05 10:12:00.969362',110,110,'b576720ad2bb46dca8593baa5187080f','d4e4bf6a-5093-4e16-80c5-981b714e11bb',20,'a1984fed702d4461879e97dd7c6fc401','gigabytes',1,'2025-12-06 10:12:00',NULL),('2025-12-05 10:12:00.947273',NULL,'2025-12-05 10:12:00.969362',111,111,NULL,'223db25f-41e5-44c7-b264-0e32039f1e0e',21,'a1984fed702d4461879e97dd7c6fc401','shares',1,'2025-12-06 10:12:00','449c8c2d-0435-4e20-be7a-0426a7732edb'),('2025-12-05 10:12:00.948349',NULL,'2025-12-05 10:12:00.969362',112,112,NULL,'25c9928b-3171-4718-9e11-91af2977075a',22,'a1984fed702d4461879e97dd7c6fc401','gigabytes',1,'2025-12-06 10:12:00','449c8c2d-0435-4e20-be7a-0426a7732edb'),('2025-12-05 10:12:05.395199',NULL,'2025-12-05 10:12:05.458557',113,113,'9d3385b7b45145bdb1032d3a6efc7d1f','634acd8d-1913-4a2c-8242-a7016c1f9a99',24,'d34a70d4c87b4bccbac035ee2005a967','shares',1,'2025-12-06 10:12:05',NULL),('2025-12-05 10:12:05.405374',NULL,'2025-12-05 10:12:05.458557',114,114,'9d3385b7b45145bdb1032d3a6efc7d1f','d372df5d-27ce-4c78-b642-44c27c1d67c6',23,'d34a70d4c87b4bccbac035ee2005a967','gigabytes',4,'2025-12-06 10:12:05',NULL),('2025-12-05 10:12:05.422884',NULL,'2025-12-05 10:12:05.458557',115,115,NULL,'5c55f5ee-979a-4fbd-9a62-404a0baebf6d',26,'d34a70d4c87b4bccbac035ee2005a967','shares',1,'2025-12-06 10:12:05','65a4580f-4899-4c8b-b13f-366c633ab545'),('2025-12-05 10:12:05.425190',NULL,'2025-12-05 10:12:05.458557',116,116,NULL,'4ae43888-adda-4e4a-8125-999050bbcd65',25,'d34a70d4c87b4bccbac035ee2005a967','gigabytes',4,'2025-12-06 10:12:05','65a4580f-4899-4c8b-b13f-366c633ab545'),('2025-12-05 10:12:08.670725',NULL,'2025-12-05 10:12:08.681464',117,117,'9d3385b7b45145bdb1032d3a6efc7d1f','7130fe60-80af-49bc-bb8e-bff561f71192',24,'d34a70d4c87b4bccbac035ee2005a967','shares',1,'2025-12-06 10:12:08',NULL),('2025-12-05 10:12:08.672006',NULL,'2025-12-05 10:12:08.681464',118,118,'9d3385b7b45145bdb1032d3a6efc7d1f','8430d19a-49de-42a7-87ae-1f6696182024',23,'d34a70d4c87b4bccbac035ee2005a967','gigabytes',3,'2025-12-06 10:12:08',NULL),('2025-12-05 10:12:08.809887',NULL,'2025-12-05 10:12:09.117692',119,119,'9d3385b7b45145bdb1032d3a6efc7d1f','a99eb1f1-c9dc-478d-9352-8dcc9565acdd',24,'d34a70d4c87b4bccbac035ee2005a967','shares',1,'2025-12-06 10:12:08',NULL),('2025-12-05 10:12:08.811175',NULL,'2025-12-05 10:12:09.117692',120,120,'9d3385b7b45145bdb1032d3a6efc7d1f','05133763-384f-4e5b-ba57-7e2c043fd0ff',23,'d34a70d4c87b4bccbac035ee2005a967','gigabytes',3,'2025-12-06 10:12:08',NULL),('2025-12-05 10:12:08.902491',NULL,'2025-12-05 10:12:09.117692',121,121,NULL,'89c8b393-4cdd-4f7d-ad67-fcc143c3d6f2',27,'d34a70d4c87b4bccbac035ee2005a967','shares',1,'2025-12-06 10:12:08','5ac8752e-ddb6-490b-9cb8-5388b9eaca33'),('2025-12-05 10:12:08.903768',NULL,'2025-12-05 10:12:09.117692',122,122,NULL,'ef117540-d182-4433-87ea-9507b05f9fd0',28,'d34a70d4c87b4bccbac035ee2005a967','gigabytes',3,'2025-12-06 10:12:08','5ac8752e-ddb6-490b-9cb8-5388b9eaca33'),('2025-12-05 10:12:13.297276',NULL,'2025-12-05 10:12:13.339158',123,123,'9d3385b7b45145bdb1032d3a6efc7d1f','6e409cf4-ccce-4225-a3be-c69c7d75854b',24,'d34a70d4c87b4bccbac035ee2005a967','shares',-1,'2025-12-06 10:12:13',NULL),('2025-12-05 10:12:13.298632',NULL,'2025-12-05 10:12:13.339158',124,124,'9d3385b7b45145bdb1032d3a6efc7d1f','98086cdb-dca2-43fa-a331-7bb1331ac190',23,'d34a70d4c87b4bccbac035ee2005a967','gigabytes',-4,'2025-12-06 10:12:13',NULL),('2025-12-05 10:12:13.326574',NULL,'2025-12-05 10:12:13.339158',125,125,NULL,'c1591167-2337-443d-a179-fc7e9d3599af',26,'d34a70d4c87b4bccbac035ee2005a967','shares',-1,'2025-12-06 10:12:13','65a4580f-4899-4c8b-b13f-366c633ab545'),('2025-12-05 10:12:13.327847',NULL,'2025-12-05 10:12:13.339158',126,126,NULL,'1421cf14-4aa3-463f-be24-55b14c708c52',25,'d34a70d4c87b4bccbac035ee2005a967','gigabytes',-4,'2025-12-06 10:12:13','65a4580f-4899-4c8b-b13f-366c633ab545'),('2025-12-05 10:12:16.429028',NULL,'2025-12-05 10:12:16.445010',127,127,'9d3385b7b45145bdb1032d3a6efc7d1f','5c1d29fd-5366-461d-bb99-99b48e2fcbf4',24,'d34a70d4c87b4bccbac035ee2005a967','shares',-1,'2025-12-06 10:12:16',NULL),('2025-12-05 10:12:16.430184',NULL,'2025-12-05 10:12:16.445010',128,128,'9d3385b7b45145bdb1032d3a6efc7d1f','ab9a4b76-14b6-4daf-b77d-a096d2f65980',23,'d34a70d4c87b4bccbac035ee2005a967','gigabytes',-3,'2025-12-06 10:12:16',NULL),('2025-12-05 10:12:16.437177',NULL,'2025-12-05 10:12:16.445010',129,129,NULL,'e89bf08f-5d66-4cb5-b1b0-9bba20cd3528',27,'d34a70d4c87b4bccbac035ee2005a967','shares',-1,'2025-12-06 10:12:16','5ac8752e-ddb6-490b-9cb8-5388b9eaca33'),('2025-12-05 10:12:16.437851',NULL,'2025-12-05 10:12:16.445010',130,130,NULL,'71210525-346a-45e7-8ce2-f854f1de1b19',28,'d34a70d4c87b4bccbac035ee2005a967','gigabytes',-3,'2025-12-06 10:12:16','5ac8752e-ddb6-490b-9cb8-5388b9eaca33'),('2025-12-05 10:12:28.011366',NULL,'2025-12-05 10:12:28.067815',131,131,'b576720ad2bb46dca8593baa5187080f','bc0c8baa-f70f-4cb7-997d-aec868ea16a5',19,'a1984fed702d4461879e97dd7c6fc401','shares',1,'2025-12-06 10:12:27',NULL),('2025-12-05 10:12:28.012770',NULL,'2025-12-05 10:12:28.067815',132,132,'b576720ad2bb46dca8593baa5187080f','689b4cc1-6421-4c96-9dac-de2f67b8065f',20,'a1984fed702d4461879e97dd7c6fc401','gigabytes',1,'2025-12-06 10:12:27',NULL),('2025-12-05 10:12:28.032524',NULL,'2025-12-05 10:12:28.067815',133,133,NULL,'1cf5d0fe-0788-4c0d-bd39-5e92b22b8bc5',29,'a1984fed702d4461879e97dd7c6fc401','shares',1,'2025-12-06 10:12:27','e8182e37-1b64-46cf-939e-d811c66cd270'),('2025-12-05 10:12:28.034723',NULL,'2025-12-05 10:12:28.067815',134,134,NULL,'8f5b089c-bd83-472f-abcb-b35ddd2ae56d',30,'a1984fed702d4461879e97dd7c6fc401','gigabytes',1,'2025-12-06 10:12:27','e8182e37-1b64-46cf-939e-d811c66cd270'),('2025-12-05 10:12:34.844432',NULL,'2025-12-05 10:12:34.894259',135,135,'d59f59d0e8cf40e8b15d79772c65521a','035d6ae4-3eab-4dd3-ad85-315f5b41abf4',32,'ebe30874eba14cd5bd352ff97cc61ddf','shares',1,'2025-12-06 10:12:34',NULL),('2025-12-05 10:12:34.848207',NULL,'2025-12-05 10:12:34.894259',136,136,'d59f59d0e8cf40e8b15d79772c65521a','4b1ddda8-bd60-4fbb-a38e-12635b39232f',31,'ebe30874eba14cd5bd352ff97cc61ddf','gigabytes',1,'2025-12-06 10:12:34',NULL),('2025-12-05 10:12:34.860235',NULL,'2025-12-05 10:12:34.894259',137,137,NULL,'3130d3b8-2438-4b1a-b6a6-de4bb3314102',34,'ebe30874eba14cd5bd352ff97cc61ddf','shares',1,'2025-12-06 10:12:34','3555d51c-f13b-4628-8bd2-5dd0bf96d69d'),('2025-12-05 10:12:34.861361',NULL,'2025-12-05 10:12:34.894259',138,138,NULL,'db773d27-6df3-45cb-ba1b-317bc1302dc5',33,'ebe30874eba14cd5bd352ff97cc61ddf','gigabytes',1,'2025-12-06 10:12:34','3555d51c-f13b-4628-8bd2-5dd0bf96d69d'),('2025-12-05 10:12:43.199224',NULL,'2025-12-05 10:12:43.218850',139,139,'b576720ad2bb46dca8593baa5187080f','07c3f269-ede0-4c6c-8ab1-340d57ec9d11',19,'a1984fed702d4461879e97dd7c6fc401','shares',-1,'2025-12-06 10:12:43',NULL),('2025-12-05 10:12:43.200265',NULL,'2025-12-05 10:12:43.218850',140,140,'b576720ad2bb46dca8593baa5187080f','b9cede0a-f7ed-40a0-93f3-f5324a8d9094',20,'a1984fed702d4461879e97dd7c6fc401','gigabytes',-1,'2025-12-06 10:12:43',NULL),('2025-12-05 10:12:43.208549',NULL,'2025-12-05 10:12:43.218850',141,141,NULL,'021e99b3-13a1-4438-adc7-94a9330ff2cb',29,'a1984fed702d4461879e97dd7c6fc401','shares',-1,'2025-12-06 10:12:43','e8182e37-1b64-46cf-939e-d811c66cd270'),('2025-12-05 10:12:43.209652',NULL,'2025-12-05 10:12:43.218850',142,142,NULL,'90dcd51f-3d2d-44b9-85b7-280ff91532e6',30,'a1984fed702d4461879e97dd7c6fc401','gigabytes',-1,'2025-12-06 10:12:43','e8182e37-1b64-46cf-939e-d811c66cd270'),('2025-12-05 10:12:46.452091',NULL,'2025-12-05 10:12:46.485924',143,143,'b576720ad2bb46dca8593baa5187080f','02c07af8-cb68-4ff1-8402-899970e554f5',19,'a1984fed702d4461879e97dd7c6fc401','shares',-1,'2025-12-06 10:12:46',NULL),('2025-12-05 10:12:46.453032',NULL,'2025-12-05 10:12:46.485924',144,144,'b576720ad2bb46dca8593baa5187080f','c8b0819e-ed41-4377-8974-baaa05199efe',20,'a1984fed702d4461879e97dd7c6fc401','gigabytes',-1,'2025-12-06 10:12:46',NULL),('2025-12-05 10:12:46.459305',NULL,'2025-12-05 10:12:46.485924',145,145,NULL,'4664a6c7-76ca-4895-8207-66b3d25ff1ff',21,'a1984fed702d4461879e97dd7c6fc401','shares',-1,'2025-12-06 10:12:46','449c8c2d-0435-4e20-be7a-0426a7732edb'),('2025-12-05 10:12:46.460353',NULL,'2025-12-05 10:12:46.485924',146,146,NULL,'ce28d9fd-61b5-456a-845f-ec990475fbba',22,'a1984fed702d4461879e97dd7c6fc401','gigabytes',-1,'2025-12-06 10:12:46','449c8c2d-0435-4e20-be7a-0426a7732edb'),('2025-12-05 10:12:47.357809',NULL,'2025-12-05 10:12:47.398455',147,147,'d59f59d0e8cf40e8b15d79772c65521a','b41c7401-7473-47ab-81d4-00051f8d7982',32,'ebe30874eba14cd5bd352ff97cc61ddf','shares',-1,'2025-12-06 10:12:47',NULL),('2025-12-05 10:12:47.361020',NULL,'2025-12-05 10:12:47.398455',148,148,'d59f59d0e8cf40e8b15d79772c65521a','c9e11c89-7152-42a0-ac9c-e221688cb9c4',31,'ebe30874eba14cd5bd352ff97cc61ddf','gigabytes',-1,'2025-12-06 10:12:47',NULL),('2025-12-05 10:12:47.382936',NULL,'2025-12-05 10:12:47.398455',149,149,NULL,'1b945e91-fdec-454e-b502-71465d3a5da6',34,'ebe30874eba14cd5bd352ff97cc61ddf','shares',-1,'2025-12-06 10:12:47','3555d51c-f13b-4628-8bd2-5dd0bf96d69d'),('2025-12-05 10:12:47.383964',NULL,'2025-12-05 10:12:47.398455',150,150,NULL,'01ab30d5-1f42-4e94-8271-4b925d624400',33,'ebe30874eba14cd5bd352ff97cc61ddf','gigabytes',-1,'2025-12-06 10:12:47','3555d51c-f13b-4628-8bd2-5dd0bf96d69d'),('2025-12-05 10:12:49.758986',NULL,'2025-12-05 10:12:49.790286',151,151,'348d267ee53941bbbb6824e764d06b33','4064565a-804e-4f07-b2c8-c61ff14f7f98',13,'f4c34f38ddb048808ef72391bdda40b5','shares',-1,'2025-12-06 10:12:49',NULL),('2025-12-05 10:12:49.759880',NULL,'2025-12-05 10:12:49.790286',152,152,'348d267ee53941bbbb6824e764d06b33','77a99b5e-8b1b-4a7a-b4d5-175a7e2ecd90',14,'f4c34f38ddb048808ef72391bdda40b5','gigabytes',-1,'2025-12-06 10:12:49',NULL),('2025-12-05 10:12:49.772096',NULL,'2025-12-05 10:12:49.790286',153,153,NULL,'19593360-c874-4fc5-a657-dd583e3732bb',17,'f4c34f38ddb048808ef72391bdda40b5','shares',-1,'2025-12-06 10:12:49','449c8c2d-0435-4e20-be7a-0426a7732edb'),('2025-12-05 10:12:49.773476',NULL,'2025-12-05 10:12:49.790286',154,154,NULL,'d15bacc3-f2f0-4482-a492-9e19170b83e2',18,'f4c34f38ddb048808ef72391bdda40b5','gigabytes',-1,'2025-12-06 10:12:49','449c8c2d-0435-4e20-be7a-0426a7732edb'),('2025-12-05 10:12:53.163139',NULL,'2025-12-05 10:12:53.176493',155,155,'348d267ee53941bbbb6824e764d06b33','fef3be25-3116-442d-a828-8f94c23cceda',13,'f4c34f38ddb048808ef72391bdda40b5','shares',-1,'2025-12-06 10:12:53',NULL),('2025-12-05 10:12:53.163897',NULL,'2025-12-05 10:12:53.176493',156,156,'348d267ee53941bbbb6824e764d06b33','a3631317-5156-425a-b180-a90f02b5bf42',14,'f4c34f38ddb048808ef72391bdda40b5','gigabytes',-1,'2025-12-06 10:12:53',NULL),('2025-12-05 10:12:53.169759',NULL,'2025-12-05 10:12:53.176493',157,157,NULL,'6e43d4e8-0c86-49bc-b1d8-2a66f3a25b61',15,'f4c34f38ddb048808ef72391bdda40b5','shares',-1,'2025-12-06 10:12:53','e8182e37-1b64-46cf-939e-d811c66cd270'),('2025-12-05 10:12:53.170451',NULL,'2025-12-05 10:12:53.176493',158,158,NULL,'c26d8f58-bcbd-43c1-ad8c-9080c42a09bd',16,'f4c34f38ddb048808ef72391bdda40b5','gigabytes',-1,'2025-12-06 10:12:53','e8182e37-1b64-46cf-939e-d811c66cd270'),('2025-12-05 10:12:53.936564',NULL,'2025-12-05 10:12:54.625502',159,159,'7029332df14e44eb8554fb21ecce63d9','20fac61c-301e-4cbc-a07f-0d28e6e38794',35,'7ed90e6d1b7c4872853af83191db9808','shares',1,'2025-12-06 10:12:53',NULL),('2025-12-05 10:12:53.937768',NULL,'2025-12-05 10:12:54.625502',160,160,'7029332df14e44eb8554fb21ecce63d9','d44f3f03-796e-4a5b-838a-6c67806920e5',36,'7ed90e6d1b7c4872853af83191db9808','gigabytes',1,'2025-12-06 10:12:53',NULL),('2025-12-05 10:12:54.536326',NULL,'2025-12-05 10:12:54.625502',161,161,NULL,'b9ae47bb-cac4-485b-b318-a84ca4df1bc7',37,'7ed90e6d1b7c4872853af83191db9808','shares',1,'2025-12-06 10:12:53','632c113b-9b12-4c58-a04a-7eaeb0d12655'),('2025-12-05 10:12:54.556594',NULL,'2025-12-05 10:12:54.625502',162,162,NULL,'2f220781-06f5-4460-8a0e-7e772bf75952',38,'7ed90e6d1b7c4872853af83191db9808','gigabytes',1,'2025-12-06 10:12:53','632c113b-9b12-4c58-a04a-7eaeb0d12655'),('2025-12-05 10:12:58.321882',NULL,'2025-12-05 10:12:58.362156',163,163,'7029332df14e44eb8554fb21ecce63d9','033c716f-e6f7-4ffd-8dcd-fce67ea4a80f',39,'7ed90e6d1b7c4872853af83191db9808','shares',1,'2025-12-06 10:12:58',NULL),('2025-12-05 10:12:58.323174',NULL,'2025-12-05 10:12:58.362156',164,164,'7029332df14e44eb8554fb21ecce63d9','ffa7b6f2-a5d6-4ed6-8837-7fddf8b41c10',40,'7ed90e6d1b7c4872853af83191db9808','gigabytes',1,'2025-12-06 10:12:58',NULL),('2025-12-05 10:12:58.341038',NULL,'2025-12-05 10:12:58.362156',165,165,NULL,'5d7ef8ac-d4eb-4b1f-b6b9-cc7030052e21',41,'7ed90e6d1b7c4872853af83191db9808','shares',1,'2025-12-06 10:12:58','2d4b5a4d-5ba9-4704-8683-44def0c314de'),('2025-12-05 10:12:58.342479',NULL,'2025-12-05 10:12:58.362156',166,166,NULL,'d6839010-8978-4fba-8acb-3545ff2493a5',42,'7ed90e6d1b7c4872853af83191db9808','gigabytes',1,'2025-12-06 10:12:58','2d4b5a4d-5ba9-4704-8683-44def0c314de'),('2025-12-05 10:13:04.202438',NULL,'2025-12-05 10:13:04.672961',167,167,'7029332df14e44eb8554fb21ecce63d9','3d1d55b9-f378-4818-a0d3-b360b40bb548',44,'7ed90e6d1b7c4872853af83191db9808','snapshots',1,'2025-12-06 10:13:04',NULL),('2025-12-05 10:13:04.203930',NULL,'2025-12-05 10:13:04.672961',168,168,'7029332df14e44eb8554fb21ecce63d9','94d44a4d-d299-4ecc-8bb5-3ad8f6f1e0ae',43,'7ed90e6d1b7c4872853af83191db9808','snapshot_gigabytes',1,'2025-12-06 10:13:04',NULL),('2025-12-05 10:13:04.559655',NULL,'2025-12-05 10:13:04.672961',169,169,NULL,'d7941a68-46b3-4508-b606-fab511fc0b6d',46,'7ed90e6d1b7c4872853af83191db9808','snapshots',1,'2025-12-06 10:13:04','2d4b5a4d-5ba9-4704-8683-44def0c314de'),('2025-12-05 10:13:04.560885',NULL,'2025-12-05 10:13:04.672961',170,170,NULL,'1f95545e-9437-418f-af70-fb4d8fed827d',45,'7ed90e6d1b7c4872853af83191db9808','snapshot_gigabytes',1,'2025-12-06 10:13:04','2d4b5a4d-5ba9-4704-8683-44def0c314de'),('2025-12-05 10:13:14.699713',NULL,'2025-12-05 10:13:14.732386',171,171,'7029332df14e44eb8554fb21ecce63d9','9330015b-eff6-43e4-9483-c9ac5cfde6bc',47,'7ed90e6d1b7c4872853af83191db9808','snapshots',-1,'2025-12-06 10:13:14',NULL),('2025-12-05 10:13:14.700376',NULL,'2025-12-05 10:13:14.732386',172,172,'7029332df14e44eb8554fb21ecce63d9','c563d58f-8ed2-465a-b719-3322a8677991',48,'7ed90e6d1b7c4872853af83191db9808','snapshot_gigabytes',-1,'2025-12-06 10:13:14',NULL),('2025-12-05 10:13:14.721241',NULL,'2025-12-05 10:13:14.732386',173,173,NULL,'793aa9e7-a5a7-4605-a606-bc6daa8fded1',49,'7ed90e6d1b7c4872853af83191db9808','snapshots',-1,'2025-12-06 10:13:14','2d4b5a4d-5ba9-4704-8683-44def0c314de'),('2025-12-05 10:13:14.722374',NULL,'2025-12-05 10:13:14.732386',174,174,NULL,'40f1b68c-4674-4189-84d1-e2cd7a8363e2',50,'7ed90e6d1b7c4872853af83191db9808','snapshot_gigabytes',-1,'2025-12-06 10:13:14','2d4b5a4d-5ba9-4704-8683-44def0c314de'),('2025-12-05 10:13:19.075469',NULL,'2025-12-05 10:13:19.120225',175,175,'7029332df14e44eb8554fb21ecce63d9','c53423ef-7a08-4f48-8f00-f7c41a6c9ec8',52,'7ed90e6d1b7c4872853af83191db9808','shares',-1,'2025-12-06 10:13:18',NULL),('2025-12-05 10:13:19.078039',NULL,'2025-12-05 10:13:19.120225',176,176,'7029332df14e44eb8554fb21ecce63d9','59d0c6eb-545b-4497-9ab7-20edd340e7cc',51,'7ed90e6d1b7c4872853af83191db9808','gigabytes',-1,'2025-12-06 10:13:18',NULL),('2025-12-05 10:13:19.104997',NULL,'2025-12-05 10:13:19.120225',177,177,NULL,'6364c70a-13ff-4763-b97c-a8d16dbb231b',54,'7ed90e6d1b7c4872853af83191db9808','shares',-1,'2025-12-06 10:13:18','2d4b5a4d-5ba9-4704-8683-44def0c314de'),('2025-12-05 10:13:19.105818',NULL,'2025-12-05 10:13:19.120225',178,178,NULL,'5e7ecde5-a216-47b4-9fae-dc78c0a7e82f',53,'7ed90e6d1b7c4872853af83191db9808','gigabytes',-1,'2025-12-06 10:13:18','2d4b5a4d-5ba9-4704-8683-44def0c314de'),('2025-12-05 10:13:19.545092',NULL,'2025-12-05 10:13:19.587018',179,179,'d69249cd05f14764b756127bbf1b1722','9162692c-f5f8-42d7-9fa1-828bca5e1d0f',55,'4c561d1c6e584a9089b9e15f2f4357c8','shares',1,'2025-12-06 10:13:19',NULL),('2025-12-05 10:13:19.546390',NULL,'2025-12-05 10:13:19.587018',180,180,'d69249cd05f14764b756127bbf1b1722','559035a4-d1b8-4f0c-bc77-4bffd1d445cc',56,'4c561d1c6e584a9089b9e15f2f4357c8','gigabytes',1,'2025-12-06 10:13:19',NULL),('2025-12-05 10:13:19.558306',NULL,'2025-12-05 10:13:19.587018',181,181,NULL,'2c34a314-0873-4dd2-a9fb-e4126733d1fc',57,'4c561d1c6e584a9089b9e15f2f4357c8','shares',1,'2025-12-06 10:13:19','8ac53a92-cde8-4dfa-8750-87dea15a0661'),('2025-12-05 10:13:19.559454',NULL,'2025-12-05 10:13:19.587018',182,182,NULL,'171d5f85-33d1-49f2-8ac4-54ae74c287a6',58,'4c561d1c6e584a9089b9e15f2f4357c8','gigabytes',1,'2025-12-06 10:13:19','8ac53a92-cde8-4dfa-8750-87dea15a0661'),('2025-12-05 10:13:22.487329',NULL,'2025-12-05 10:13:23.168548',183,183,'7029332df14e44eb8554fb21ecce63d9','1ec2b158-2022-4bc7-8092-8e8bc8f292f2',52,'7ed90e6d1b7c4872853af83191db9808','shares',-1,'2025-12-06 10:13:22',NULL),('2025-12-05 10:13:22.488145',NULL,'2025-12-05 10:13:23.168548',184,184,'7029332df14e44eb8554fb21ecce63d9','63ce0c5e-84da-4889-aeda-bb11536c073b',51,'7ed90e6d1b7c4872853af83191db9808','gigabytes',-1,'2025-12-06 10:13:22',NULL),('2025-12-05 10:13:22.842800',NULL,'2025-12-05 10:13:23.168548',185,185,NULL,'a308cf2e-2682-47e2-a9f5-732650612d27',60,'7ed90e6d1b7c4872853af83191db9808','shares',-1,'2025-12-06 10:13:22','632c113b-9b12-4c58-a04a-7eaeb0d12655'),('2025-12-05 10:13:22.843464',NULL,'2025-12-05 10:13:23.168548',186,186,NULL,'fa67e4be-1891-4d1c-8bab-ebca6b73e830',59,'7ed90e6d1b7c4872853af83191db9808','gigabytes',-1,'2025-12-06 10:13:22','632c113b-9b12-4c58-a04a-7eaeb0d12655'),('2025-12-05 10:13:22.891070',NULL,'2025-12-05 10:13:23.506871',187,187,'d69249cd05f14764b756127bbf1b1722','82f56fc7-5ea1-4a78-a8db-47d356ac1bfa',61,'4c561d1c6e584a9089b9e15f2f4357c8','snapshots',1,'2025-12-06 10:13:22',NULL),('2025-12-05 10:13:22.892946',NULL,'2025-12-05 10:13:23.506871',188,188,'d69249cd05f14764b756127bbf1b1722','f443bb16-8232-45e9-984c-7fa29cc5d606',62,'4c561d1c6e584a9089b9e15f2f4357c8','snapshot_gigabytes',1,'2025-12-06 10:13:22',NULL),('2025-12-05 10:13:23.159382',NULL,'2025-12-05 10:13:23.506871',189,189,NULL,'c4b376f2-0d5f-485f-b7a7-c5d04fe0b826',63,'4c561d1c6e584a9089b9e15f2f4357c8','snapshots',1,'2025-12-06 10:13:22','8ac53a92-cde8-4dfa-8750-87dea15a0661'),('2025-12-05 10:13:23.161371',NULL,'2025-12-05 10:13:23.506871',190,190,NULL,'4392149d-2cda-41b3-b4b2-a2eaccf6157b',64,'4c561d1c6e584a9089b9e15f2f4357c8','snapshot_gigabytes',1,'2025-12-06 10:13:22','8ac53a92-cde8-4dfa-8750-87dea15a0661'),('2025-12-05 10:13:29.155385',NULL,'2025-12-05 10:13:29.224370',191,191,'d69249cd05f14764b756127bbf1b1722','74899ee8-d16d-4179-99b8-4e96a7faad9d',61,'4c561d1c6e584a9089b9e15f2f4357c8','snapshots',-1,'2025-12-06 10:13:29',NULL),('2025-12-05 10:13:29.156281',NULL,'2025-12-05 10:13:29.224370',192,192,'d69249cd05f14764b756127bbf1b1722','dd1e8e3f-3466-4c53-82c4-485614e9c902',62,'4c561d1c6e584a9089b9e15f2f4357c8','snapshot_gigabytes',-1,'2025-12-06 10:13:29',NULL),('2025-12-05 10:13:29.164619',NULL,'2025-12-05 10:13:29.224370',193,193,NULL,'6fb4a975-a6d9-402e-b9e9-7c9581d2a9c3',63,'4c561d1c6e584a9089b9e15f2f4357c8','snapshots',-1,'2025-12-06 10:13:29','8ac53a92-cde8-4dfa-8750-87dea15a0661'),('2025-12-05 10:13:29.165883',NULL,'2025-12-05 10:13:29.224370',194,194,NULL,'c16ed6d4-2389-45f6-b8b0-a72ed895b0f8',64,'4c561d1c6e584a9089b9e15f2f4357c8','snapshot_gigabytes',-1,'2025-12-06 10:13:29','8ac53a92-cde8-4dfa-8750-87dea15a0661'),('2025-12-05 10:13:32.011931',NULL,'2025-12-05 10:13:32.026568',195,195,'d69249cd05f14764b756127bbf1b1722','0d8681e8-808f-44c5-b53d-ba825607b390',55,'4c561d1c6e584a9089b9e15f2f4357c8','shares',-1,'2025-12-06 10:13:31',NULL),('2025-12-05 10:13:32.012755',NULL,'2025-12-05 10:13:32.026568',196,196,'d69249cd05f14764b756127bbf1b1722','771ac39e-d096-44b8-853b-3ab61b558244',56,'4c561d1c6e584a9089b9e15f2f4357c8','gigabytes',-1,'2025-12-06 10:13:31',NULL),('2025-12-05 10:13:32.017615',NULL,'2025-12-05 10:13:32.026568',197,197,NULL,'8b481d5c-151f-4fe5-b863-e676d6523c1b',57,'4c561d1c6e584a9089b9e15f2f4357c8','shares',-1,'2025-12-06 10:13:31','8ac53a92-cde8-4dfa-8750-87dea15a0661'),('2025-12-05 10:13:32.018357',NULL,'2025-12-05 10:13:32.026568',198,198,NULL,'3b0e46ff-e8af-4e07-95ad-45ef91877361',58,'4c561d1c6e584a9089b9e15f2f4357c8','gigabytes',-1,'2025-12-06 10:13:31','8ac53a92-cde8-4dfa-8750-87dea15a0661'),('2025-12-05 10:13:33.414571',NULL,'2025-12-05 10:13:34.469051',199,199,'1717459cd58f495ca4e1b6ad9cd48d71','689a4f20-acf9-4a7b-a343-e0a28228e4b7',65,'f664c71837fd4542885812183157a725','shares',1,'2025-12-06 10:13:33',NULL),('2025-12-05 10:13:33.415596',NULL,'2025-12-05 10:13:34.469051',200,200,'1717459cd58f495ca4e1b6ad9cd48d71','085f357e-173c-4ed7-bbbb-32ab28df8560',66,'f664c71837fd4542885812183157a725','gigabytes',1,'2025-12-06 10:13:33',NULL),('2025-12-05 10:13:34.356564',NULL,'2025-12-05 10:13:34.469051',201,201,NULL,'8ff1970f-5ffc-4e78-b312-363154e1ba32',67,'f664c71837fd4542885812183157a725','shares',1,'2025-12-06 10:13:33','3a0d44c5-216e-4725-8f6f-11decb7b7356'),('2025-12-05 10:13:34.358686',NULL,'2025-12-05 10:13:34.469051',202,202,NULL,'ba2ea212-ee08-4625-b5be-078e27bb2c4c',68,'f664c71837fd4542885812183157a725','gigabytes',1,'2025-12-06 10:13:33','3a0d44c5-216e-4725-8f6f-11decb7b7356'),('2025-12-05 10:13:41.393534',NULL,'2025-12-05 10:13:41.441712',203,203,'1717459cd58f495ca4e1b6ad9cd48d71','f42e1828-a132-4f1f-aa6f-d96bac0aa151',65,'f664c71837fd4542885812183157a725','shares',-1,'2025-12-06 10:13:41',NULL),('2025-12-05 10:13:41.394395',NULL,'2025-12-05 10:13:41.441712',204,204,'1717459cd58f495ca4e1b6ad9cd48d71','3e1b7e87-e1d2-49e7-a2a9-3ed53bf48e6a',66,'f664c71837fd4542885812183157a725','gigabytes',-1,'2025-12-06 10:13:41',NULL),('2025-12-05 10:13:41.418163',NULL,'2025-12-05 10:13:41.441712',205,205,NULL,'98200fe2-2e9d-4e79-aac2-01603e88e8e7',67,'f664c71837fd4542885812183157a725','shares',-1,'2025-12-06 10:13:41','3a0d44c5-216e-4725-8f6f-11decb7b7356'),('2025-12-05 10:13:41.422343',NULL,'2025-12-05 10:13:41.441712',206,206,NULL,'6d531435-513b-41b0-9bcc-eba95361b22c',68,'f664c71837fd4542885812183157a725','gigabytes',-1,'2025-12-06 10:13:41','3a0d44c5-216e-4725-8f6f-11decb7b7356'),('2025-12-05 10:13:41.660941',NULL,'2025-12-05 10:13:41.702035',207,207,'1717459cd58f495ca4e1b6ad9cd48d71','32a51868-d3f8-41d4-a78c-d93060bb6869',65,'f664c71837fd4542885812183157a725','shares',1,'2025-12-06 10:13:41',NULL),('2025-12-05 10:13:41.663074',NULL,'2025-12-05 10:13:41.702035',208,208,'1717459cd58f495ca4e1b6ad9cd48d71','4bb9bc2d-e28b-4499-8966-158fac4db165',66,'f664c71837fd4542885812183157a725','gigabytes',1,'2025-12-06 10:13:41',NULL),('2025-12-05 10:13:41.677793',NULL,'2025-12-05 10:13:41.702035',209,209,NULL,'7603737e-7118-4400-95b7-8077b6bc326b',69,'f664c71837fd4542885812183157a725','shares',1,'2025-12-06 10:13:41','56a69d99-6552-49e6-8f2e-be9b93e17b0f'),('2025-12-05 10:13:41.679562',NULL,'2025-12-05 10:13:41.702035',210,210,NULL,'34111edd-3b9d-4df4-beaf-c86593b9f306',70,'f664c71837fd4542885812183157a725','gigabytes',1,'2025-12-06 10:13:41','56a69d99-6552-49e6-8f2e-be9b93e17b0f'),('2025-12-05 10:13:45.098342',NULL,'2025-12-05 10:13:45.117027',211,211,'1717459cd58f495ca4e1b6ad9cd48d71','5d2c9202-0a5f-46ed-93bc-966cade08d31',65,'f664c71837fd4542885812183157a725','shares',-1,'2025-12-06 10:13:45',NULL),('2025-12-05 10:13:45.099241',NULL,'2025-12-05 10:13:45.117027',212,212,'1717459cd58f495ca4e1b6ad9cd48d71','67959741-94d4-48c7-9268-844e0d7f2337',66,'f664c71837fd4542885812183157a725','gigabytes',-1,'2025-12-06 10:13:45',NULL),('2025-12-05 10:13:45.106687',NULL,'2025-12-05 10:13:45.117027',213,213,NULL,'82ec155d-c456-4cec-ae24-a73c4cefb296',69,'f664c71837fd4542885812183157a725','shares',-1,'2025-12-06 10:13:45','56a69d99-6552-49e6-8f2e-be9b93e17b0f'),('2025-12-05 10:13:45.107480',NULL,'2025-12-05 10:13:45.117027',214,214,NULL,'08147400-4738-43c6-bcc1-ad0d038746e6',70,'f664c71837fd4542885812183157a725','gigabytes',-1,'2025-12-06 10:13:45','56a69d99-6552-49e6-8f2e-be9b93e17b0f'),('2025-12-05 10:13:45.219220',NULL,'2025-12-05 10:13:45.902321',215,215,'1717459cd58f495ca4e1b6ad9cd48d71','e4320627-a6e1-4ee0-a1d3-ab8c1f1c7507',65,'f664c71837fd4542885812183157a725','shares',1,'2025-12-06 10:13:45',NULL),('2025-12-05 10:13:45.220433',NULL,'2025-12-05 10:13:45.902321',216,216,'1717459cd58f495ca4e1b6ad9cd48d71','6d2a06a8-af8e-4ca7-825f-009f8dd377ba',66,'f664c71837fd4542885812183157a725','gigabytes',1,'2025-12-06 10:13:45',NULL),('2025-12-05 10:13:45.845703',NULL,'2025-12-05 10:13:45.902321',217,217,NULL,'a7e11717-750d-4629-a109-4daf71fb5074',71,'f664c71837fd4542885812183157a725','shares',1,'2025-12-06 10:13:45','1fd60b46-31a6-44af-a399-72e33821aac3'),('2025-12-05 10:13:45.846940',NULL,'2025-12-05 10:13:45.902321',218,218,NULL,'2862590e-615b-41e0-90e4-3ac72fb0d2cd',72,'f664c71837fd4542885812183157a725','gigabytes',1,'2025-12-06 10:13:45','1fd60b46-31a6-44af-a399-72e33821aac3'),('2025-12-05 10:13:46.916570',NULL,'2025-12-05 10:13:47.291429',219,219,'e3d69a69ad4b45469299d1089bf6b8a8','b7825155-ef1a-4c97-9fa6-eaf144e4859a',74,'99a6df84d1504c33b200f7c6a254c378','shares',1,'2025-12-06 10:13:46',NULL),('2025-12-05 10:13:46.918410',NULL,'2025-12-05 10:13:47.291429',220,220,'e3d69a69ad4b45469299d1089bf6b8a8','315c0a65-5468-4b0d-922e-83e6350d4062',73,'99a6df84d1504c33b200f7c6a254c378','gigabytes',1,'2025-12-06 10:13:46',NULL),('2025-12-05 10:13:47.034406',NULL,'2025-12-05 10:13:47.291429',221,221,NULL,'c30341ab-992f-4aad-8c19-0dd521800202',76,'99a6df84d1504c33b200f7c6a254c378','shares',1,'2025-12-06 10:13:46','7ce735c8-f067-4b35-99c6-033e895e272c'),('2025-12-05 10:13:47.037298',NULL,'2025-12-05 10:13:47.291429',222,222,NULL,'4885cca2-e790-4b29-bb23-d1b4bb8463b3',75,'99a6df84d1504c33b200f7c6a254c378','gigabytes',1,'2025-12-06 10:13:46','7ce735c8-f067-4b35-99c6-033e895e272c'),('2025-12-05 10:13:49.259427',NULL,'2025-12-05 10:13:49.321846',223,223,'1717459cd58f495ca4e1b6ad9cd48d71','2413779e-4e0f-47db-bf2c-bb27b3f6f8fb',65,'f664c71837fd4542885812183157a725','shares',-1,'2025-12-06 10:13:49',NULL),('2025-12-05 10:13:49.260114',NULL,'2025-12-05 10:13:49.321846',224,224,'1717459cd58f495ca4e1b6ad9cd48d71','46af548c-82b0-48fb-80a5-94912bd3044d',66,'f664c71837fd4542885812183157a725','gigabytes',-1,'2025-12-06 10:13:49',NULL),('2025-12-05 10:13:49.261276',NULL,'2025-12-05 10:13:49.406960',225,225,'69b8aff476fc43d1a9779493ad95325f','03ae0b65-2a82-4d24-95e6-60d83ab589ca',77,'d812ebe2a802424a8dd9d8d619c2f55a','share_networks',1,'2025-12-06 10:13:49',NULL),('2025-12-05 10:13:49.297530',NULL,'2025-12-05 10:13:49.321846',226,226,NULL,'dd07e445-663d-4eb1-bd7a-8c8d5d93396d',71,'f664c71837fd4542885812183157a725','shares',-1,'2025-12-06 10:13:49','1fd60b46-31a6-44af-a399-72e33821aac3'),('2025-12-05 10:13:49.302646',NULL,'2025-12-05 10:13:49.321846',227,227,NULL,'6c02932e-7261-4dfa-b8e4-979bd4b2d364',72,'f664c71837fd4542885812183157a725','gigabytes',-1,'2025-12-06 10:13:49','1fd60b46-31a6-44af-a399-72e33821aac3'),('2025-12-05 10:13:49.502938',NULL,'2025-12-05 10:13:49.940020',228,228,'1717459cd58f495ca4e1b6ad9cd48d71','6cf80f5d-e74f-4a10-8b98-8b1ac6958e47',65,'f664c71837fd4542885812183157a725','shares',1,'2025-12-06 10:13:49',NULL),('2025-12-05 10:13:49.504132',NULL,'2025-12-05 10:13:49.940020',229,229,'1717459cd58f495ca4e1b6ad9cd48d71','a58f264a-457b-4a5a-8367-4961af8f938b',66,'f664c71837fd4542885812183157a725','gigabytes',1,'2025-12-06 10:13:49',NULL),('2025-12-05 10:13:49.576967',NULL,'2025-12-05 10:13:49.940020',230,230,NULL,'554f7806-0756-4f4b-9f94-bf85fcba869f',78,'f664c71837fd4542885812183157a725','shares',1,'2025-12-06 10:13:49','3673ad3c-54ef-41db-979b-88e9de5caed2'),('2025-12-05 10:13:49.579455',NULL,'2025-12-05 10:13:49.940020',231,231,NULL,'8572840e-7d2a-4ba7-bbb7-37ca1c8d8f53',79,'f664c71837fd4542885812183157a725','gigabytes',1,'2025-12-06 10:13:49','3673ad3c-54ef-41db-979b-88e9de5caed2'),('2025-12-05 10:13:50.880066',NULL,'2025-12-05 10:13:52.545530',232,232,'e3d69a69ad4b45469299d1089bf6b8a8','08787ee5-53e7-497b-ae0c-b17c4bfdfa34',81,'99a6df84d1504c33b200f7c6a254c378','snapshots',1,'2025-12-06 10:13:50',NULL),('2025-12-05 10:13:50.881603',NULL,'2025-12-05 10:13:52.545530',233,233,'e3d69a69ad4b45469299d1089bf6b8a8','91820470-7252-4194-8feb-09c8ba2aaf33',80,'99a6df84d1504c33b200f7c6a254c378','snapshot_gigabytes',1,'2025-12-06 10:13:50',NULL),('2025-12-05 10:13:50.910235',NULL,'2025-12-05 10:13:52.323117',234,234,'69b8aff476fc43d1a9779493ad95325f','1a76d40b-4a23-4e68-9419-e0ca27fe9784',77,'d812ebe2a802424a8dd9d8d619c2f55a','share_networks',1,'2025-12-06 10:13:50',NULL),('2025-12-05 10:13:51.100196',NULL,'2025-12-05 10:13:52.545530',235,235,NULL,'70eccc4e-8c90-4dc3-bf61-0c03fb212235',83,'99a6df84d1504c33b200f7c6a254c378','snapshots',1,'2025-12-06 10:13:50','7ce735c8-f067-4b35-99c6-033e895e272c'),('2025-12-05 10:13:51.105018',NULL,'2025-12-05 10:13:52.545530',236,236,NULL,'b1f62126-f805-485b-b715-ba8cea303682',82,'99a6df84d1504c33b200f7c6a254c378','snapshot_gigabytes',1,'2025-12-06 10:13:50','7ce735c8-f067-4b35-99c6-033e895e272c'),('2025-12-05 10:13:52.978292',NULL,'2025-12-05 10:13:53.000574',237,237,'69b8aff476fc43d1a9779493ad95325f','57966eca-b3ae-4e38-ac74-51b70a20f7c3',77,'d812ebe2a802424a8dd9d8d619c2f55a','share_networks',-1,'2025-12-06 10:13:52',NULL),('2025-12-05 10:13:53.059867',NULL,'2025-12-05 10:13:53.167832',238,238,'69b8aff476fc43d1a9779493ad95325f','80706ef8-b095-4947-8661-f7af49ff99dd',77,'d812ebe2a802424a8dd9d8d619c2f55a','share_networks',1,'2025-12-06 10:13:53',NULL),('2025-12-05 10:13:53.801158',NULL,'2025-12-05 10:13:53.817082',239,239,'69b8aff476fc43d1a9779493ad95325f','9f862f91-3bb7-4e5e-8d0c-74a3124365ba',77,'d812ebe2a802424a8dd9d8d619c2f55a','share_networks',-1,'2025-12-06 10:13:53',NULL),('2025-12-05 10:13:54.398225',NULL,'2025-12-05 10:13:54.420821',240,240,'1717459cd58f495ca4e1b6ad9cd48d71','064f280d-7a1b-480f-8d04-fe440bd27d31',65,'f664c71837fd4542885812183157a725','shares',-1,'2025-12-06 10:13:54',NULL),('2025-12-05 10:13:54.399445',NULL,'2025-12-05 10:13:54.420821',241,241,'1717459cd58f495ca4e1b6ad9cd48d71','d5e3076b-acbe-4e35-819b-32eb85425b83',66,'f664c71837fd4542885812183157a725','gigabytes',-1,'2025-12-06 10:13:54',NULL),('2025-12-05 10:13:54.411015',NULL,'2025-12-05 10:13:54.420821',242,242,NULL,'93c29dc9-a363-477d-8151-f74369bbf674',78,'f664c71837fd4542885812183157a725','shares',-1,'2025-12-06 10:13:54','3673ad3c-54ef-41db-979b-88e9de5caed2'),('2025-12-05 10:13:54.413103',NULL,'2025-12-05 10:13:54.420821',243,243,NULL,'16af3006-694e-4e8b-b15d-5d1c4878b6e1',79,'f664c71837fd4542885812183157a725','gigabytes',-1,'2025-12-06 10:13:54','3673ad3c-54ef-41db-979b-88e9de5caed2'),('2025-12-05 10:13:54.435351',NULL,'2025-12-05 10:13:54.443527',244,244,'69b8aff476fc43d1a9779493ad95325f','f4c38e7a-f737-44b3-88ea-d70b7d4394d3',77,'d812ebe2a802424a8dd9d8d619c2f55a','share_networks',-1,'2025-12-06 10:13:54',NULL),('2025-12-05 10:13:54.547764',NULL,'2025-12-05 10:13:54.592144',245,245,'1717459cd58f495ca4e1b6ad9cd48d71','84cc73d7-468b-4877-8883-9bf61b43260a',65,'f664c71837fd4542885812183157a725','shares',1,'2025-12-06 10:13:54',NULL),('2025-12-05 10:13:54.549631',NULL,'2025-12-05 10:13:54.592144',246,246,'1717459cd58f495ca4e1b6ad9cd48d71','54c2283b-30c1-4461-b65d-4fe84f91c1c1',66,'f664c71837fd4542885812183157a725','gigabytes',1,'2025-12-06 10:13:54',NULL),('2025-12-05 10:13:54.563485',NULL,'2025-12-05 10:13:54.592144',247,247,NULL,'1fade369-edc1-4f38-bb7b-04b04e239cec',85,'f664c71837fd4542885812183157a725','shares',1,'2025-12-06 10:13:54','be084e42-05f4-4652-aaae-737f831d0d2a'),('2025-12-05 10:13:54.564704',NULL,'2025-12-05 10:13:54.592144',248,248,NULL,'ef389f86-e047-4d72-b11c-c100dd86d391',84,'f664c71837fd4542885812183157a725','gigabytes',1,'2025-12-06 10:13:54','be084e42-05f4-4652-aaae-737f831d0d2a'),('2025-12-05 10:13:56.126385',NULL,'2025-12-05 10:13:56.431530',249,249,'e3d69a69ad4b45469299d1089bf6b8a8','d3c40d23-4815-431b-a6ca-686d60e4e28d',81,'99a6df84d1504c33b200f7c6a254c378','snapshots',1,'2025-12-06 10:13:56',NULL),('2025-12-05 10:13:56.127787',NULL,'2025-12-05 10:13:56.431530',250,250,'e3d69a69ad4b45469299d1089bf6b8a8','dd7ddc07-fb96-4e48-a4cd-208d2da481ca',80,'99a6df84d1504c33b200f7c6a254c378','snapshot_gigabytes',1,'2025-12-06 10:13:56',NULL),('2025-12-05 10:13:56.304088',NULL,'2025-12-05 10:13:56.431530',251,251,NULL,'7295b91f-af8b-4541-a5c9-27ac4f104940',83,'99a6df84d1504c33b200f7c6a254c378','snapshots',1,'2025-12-06 10:13:56','7ce735c8-f067-4b35-99c6-033e895e272c'),('2025-12-05 10:13:56.305971',NULL,'2025-12-05 10:13:56.431530',252,252,NULL,'deb4b28f-b114-4d48-b26e-8918ec615e18',82,'99a6df84d1504c33b200f7c6a254c378','snapshot_gigabytes',1,'2025-12-06 10:13:56','7ce735c8-f067-4b35-99c6-033e895e272c'),('2025-12-05 10:13:58.238189',NULL,'2025-12-05 10:13:58.260298',253,253,'1717459cd58f495ca4e1b6ad9cd48d71','728f4918-d0a7-47ac-a1c3-66b638350c16',65,'f664c71837fd4542885812183157a725','shares',-1,'2025-12-06 10:13:58',NULL),('2025-12-05 10:13:58.239131',NULL,'2025-12-05 10:13:58.260298',254,254,'1717459cd58f495ca4e1b6ad9cd48d71','4c48e20e-2256-4e4e-ad91-f35561883bc3',66,'f664c71837fd4542885812183157a725','gigabytes',-1,'2025-12-06 10:13:58',NULL),('2025-12-05 10:13:58.248128',NULL,'2025-12-05 10:13:58.260298',255,255,NULL,'b697a774-84f1-40e0-b17d-8af015900b5e',85,'f664c71837fd4542885812183157a725','shares',-1,'2025-12-06 10:13:58','be084e42-05f4-4652-aaae-737f831d0d2a'),('2025-12-05 10:13:58.249348',NULL,'2025-12-05 10:13:58.260298',256,256,NULL,'c6ad30b2-4efc-47f9-bc3b-aaff961decd8',84,'f664c71837fd4542885812183157a725','gigabytes',-1,'2025-12-06 10:13:58','be084e42-05f4-4652-aaae-737f831d0d2a'),('2025-12-05 10:14:01.315889',NULL,'2025-12-05 10:14:01.360539',257,257,'e3d69a69ad4b45469299d1089bf6b8a8','ced7ebf2-205b-4441-8ff9-03e55262033b',81,'99a6df84d1504c33b200f7c6a254c378','snapshots',-1,'2025-12-06 10:14:01',NULL),('2025-12-05 10:14:01.316918',NULL,'2025-12-05 10:14:01.360539',258,258,'e3d69a69ad4b45469299d1089bf6b8a8','fefb650a-777b-45bf-af49-9c201ec8128d',80,'99a6df84d1504c33b200f7c6a254c378','snapshot_gigabytes',-1,'2025-12-06 10:14:01',NULL),('2025-12-05 10:14:01.346172',NULL,'2025-12-05 10:14:01.360539',259,259,NULL,'40e7ea69-2d1c-4e8d-a463-d7f8859c34cb',83,'99a6df84d1504c33b200f7c6a254c378','snapshots',-1,'2025-12-06 10:14:01','7ce735c8-f067-4b35-99c6-033e895e272c'),('2025-12-05 10:14:01.347250',NULL,'2025-12-05 10:14:01.360539',260,260,NULL,'dfb38585-01c9-4500-9986-3faa1069302f',82,'99a6df84d1504c33b200f7c6a254c378','snapshot_gigabytes',-1,'2025-12-06 10:14:01','7ce735c8-f067-4b35-99c6-033e895e272c'),('2025-12-05 10:14:04.328057',NULL,'2025-12-05 10:14:04.354796',261,261,'e3d69a69ad4b45469299d1089bf6b8a8','dc385808-a60f-4a20-9725-5cd208ca0f1a',81,'99a6df84d1504c33b200f7c6a254c378','snapshots',-1,'2025-12-06 10:14:04',NULL),('2025-12-05 10:14:04.329486',NULL,'2025-12-05 10:14:04.354796',262,262,'e3d69a69ad4b45469299d1089bf6b8a8','756d08c6-e85a-4513-9db5-8a5a9ffe9ad4',80,'99a6df84d1504c33b200f7c6a254c378','snapshot_gigabytes',-1,'2025-12-06 10:14:04',NULL),('2025-12-05 10:14:04.340033',NULL,'2025-12-05 10:14:04.354796',263,263,NULL,'1b6d16d7-6b4e-41b9-9e8d-e7454f193c17',83,'99a6df84d1504c33b200f7c6a254c378','snapshots',-1,'2025-12-06 10:14:04','7ce735c8-f067-4b35-99c6-033e895e272c'),('2025-12-05 10:14:04.340927',NULL,'2025-12-05 10:14:04.354796',264,264,NULL,'a0dcaf0e-1ca9-4dff-8a77-0d41b740de05',82,'99a6df84d1504c33b200f7c6a254c378','snapshot_gigabytes',-1,'2025-12-06 10:14:04','7ce735c8-f067-4b35-99c6-033e895e272c'),('2025-12-05 10:14:06.712524',NULL,'2025-12-05 10:14:06.761896',265,265,'c139691182194818afa5e150f743366b','7de9b904-f8ee-4c0b-aad5-88d7a3c6d24e',86,'d7beb72de9524536896541252af97cc3','share_networks',1,'2025-12-06 10:14:06',NULL),('2025-12-05 10:14:06.963128',NULL,'2025-12-05 10:14:07.089250',266,266,'c139691182194818afa5e150f743366b','b758d466-f5fe-4997-9e7f-81b09d6f4c40',86,'d7beb72de9524536896541252af97cc3','share_networks',1,'2025-12-06 10:14:06',NULL),('2025-12-05 10:14:07.283659',NULL,'2025-12-05 10:14:07.321032',267,267,'c139691182194818afa5e150f743366b','ef1ab525-1b22-4ec6-82c3-e5463e133f23',86,'d7beb72de9524536896541252af97cc3','share_networks',1,'2025-12-06 10:14:07',NULL),('2025-12-05 10:14:07.511395',NULL,'2025-12-05 10:14:07.517334',268,268,'c139691182194818afa5e150f743366b','0b237cd4-da05-4a04-a481-3960e9bb832f',86,'d7beb72de9524536896541252af97cc3','share_networks',-1,'2025-12-06 10:14:07',NULL),('2025-12-05 10:14:07.670738',NULL,'2025-12-05 10:14:07.702583',269,269,'e3d69a69ad4b45469299d1089bf6b8a8','ed706589-864e-4794-a1f8-83a6c819d276',74,'99a6df84d1504c33b200f7c6a254c378','shares',-1,'2025-12-06 10:14:07',NULL),('2025-12-05 10:14:07.671960',NULL,'2025-12-05 10:14:07.702583',270,270,'e3d69a69ad4b45469299d1089bf6b8a8','35f73e4d-884f-48ee-928a-025c2ab1f359',73,'99a6df84d1504c33b200f7c6a254c378','gigabytes',-1,'2025-12-06 10:14:07',NULL),('2025-12-05 10:14:07.677869',NULL,'2025-12-05 10:14:07.702583',271,271,NULL,'1ffad27b-f93e-4264-9487-2262794eeefe',76,'99a6df84d1504c33b200f7c6a254c378','shares',-1,'2025-12-06 10:14:07','7ce735c8-f067-4b35-99c6-033e895e272c'),('2025-12-05 10:14:07.678585',NULL,'2025-12-05 10:14:07.702583',272,272,NULL,'e3791e5c-379e-4000-8515-03288417c002',75,'99a6df84d1504c33b200f7c6a254c378','gigabytes',-1,'2025-12-06 10:14:07','7ce735c8-f067-4b35-99c6-033e895e272c'),('2025-12-05 10:14:07.750704',NULL,'2025-12-05 10:14:07.796155',273,273,'c139691182194818afa5e150f743366b','333f35eb-7548-4bd7-8f51-f15a8cc15a90',86,'d7beb72de9524536896541252af97cc3','share_networks',1,'2025-12-06 10:14:07',NULL),('2025-12-05 10:14:07.875984',NULL,'2025-12-05 10:14:09.387568',274,274,'c139691182194818afa5e150f743366b','193dd413-a4b2-46de-83ed-145c6f5a117e',86,'d7beb72de9524536896541252af97cc3','share_networks',1,'2025-12-06 10:14:07',NULL),('2025-12-05 10:14:09.590955',NULL,'2025-12-05 10:14:09.604576',275,275,'c139691182194818afa5e150f743366b','0dfdb652-3501-4147-a99b-d3f463b14810',86,'d7beb72de9524536896541252af97cc3','share_networks',-1,'2025-12-06 10:14:09',NULL),('2025-12-05 10:14:09.775380',NULL,'2025-12-05 10:14:09.789232',276,276,'c139691182194818afa5e150f743366b','71f68546-6d74-4c42-8577-a4e5748b6452',86,'d7beb72de9524536896541252af97cc3','share_networks',-1,'2025-12-06 10:14:09',NULL),('2025-12-05 10:14:10.214318',NULL,'2025-12-05 10:14:10.250554',277,277,'c139691182194818afa5e150f743366b','29f739e2-8e80-46d8-b96a-35c6551c2cc5',86,'d7beb72de9524536896541252af97cc3','share_networks',1,'2025-12-06 10:14:10',NULL),('2025-12-05 10:14:10.383283',NULL,'2025-12-05 10:14:10.392307',278,278,'c139691182194818afa5e150f743366b','1e53045e-1fc8-4019-bc85-978338ef2bdf',86,'d7beb72de9524536896541252af97cc3','share_networks',-1,'2025-12-06 10:14:10',NULL),('2025-12-05 10:14:10.448363',NULL,'2025-12-05 10:14:10.495819',279,279,'c139691182194818afa5e150f743366b','06c54650-54ef-44ba-bad7-0b64cb2a7b94',86,'d7beb72de9524536896541252af97cc3','share_networks',1,'2025-12-06 10:14:10',NULL),('2025-12-05 10:14:10.604116',NULL,'2025-12-05 10:14:10.614945',280,280,'c139691182194818afa5e150f743366b','d0812b2b-7652-44b9-bc6f-752afd08a7ed',86,'d7beb72de9524536896541252af97cc3','share_networks',-1,'2025-12-06 10:14:10',NULL),('2025-12-05 10:14:11.870462',NULL,'2025-12-05 10:14:11.883808',281,281,'c139691182194818afa5e150f743366b','3044ea09-8c17-4784-8d7f-2975b8410154',86,'d7beb72de9524536896541252af97cc3','share_networks',-1,'2025-12-06 10:14:11',NULL),('2025-12-05 10:14:12.034604',NULL,'2025-12-05 10:14:12.042437',282,282,'c139691182194818afa5e150f743366b','577e90b4-7861-48a7-9ff7-75fcd6bfeadb',86,'d7beb72de9524536896541252af97cc3','share_networks',-1,'2025-12-06 10:14:12',NULL),('2025-12-05 10:14:13.655879',NULL,'2025-12-05 10:14:13.721038',283,283,'dc607a8fb4974085b29b5b37328dc83a','6c44dbc1-8647-4185-931b-9cf9008e43ad',87,'fb88a523f48e4990b7617051dc3491c9','shares',1,'2025-12-06 10:14:13',NULL),('2025-12-05 10:14:13.660708',NULL,'2025-12-05 10:14:13.721038',284,284,'dc607a8fb4974085b29b5b37328dc83a','a3348029-3351-4a2d-9398-49d4dee5c0a4',88,'fb88a523f48e4990b7617051dc3491c9','gigabytes',1,'2025-12-06 10:14:13',NULL),('2025-12-05 10:14:13.681482',NULL,'2025-12-05 10:14:13.721038',285,285,NULL,'3bb9b58c-a661-4214-a8e0-4281842fc171',89,'fb88a523f48e4990b7617051dc3491c9','shares',1,'2025-12-06 10:14:13','925f92eb-4755-4dec-9fb7-7aaa82d1d7ed'),('2025-12-05 10:14:13.683146',NULL,'2025-12-05 10:14:13.721038',286,286,NULL,'62c4b462-2e3d-4b55-b970-689b51d38bf6',90,'fb88a523f48e4990b7617051dc3491c9','gigabytes',1,'2025-12-06 10:14:13','925f92eb-4755-4dec-9fb7-7aaa82d1d7ed'),('2025-12-05 10:14:30.592036',NULL,'2025-12-05 10:14:30.675507',287,287,'b7fa2ce38b4e48f7a890e36831560ee8','47860af2-e2ea-4cfd-be3a-8783572cd98e',91,'40e1bd948bdb4f01851408e900510a3a','share_networks',1,'2025-12-06 10:14:30',NULL),('2025-12-05 10:14:30.838365',NULL,'2025-12-05 10:14:30.845776',288,288,'b7fa2ce38b4e48f7a890e36831560ee8','415676bf-81bc-4405-8c8d-0ca6edba0478',91,'40e1bd948bdb4f01851408e900510a3a','share_networks',-1,'2025-12-06 10:14:30',NULL),('2025-12-05 10:14:30.980597',NULL,'2025-12-05 10:14:31.018181',289,289,'b7fa2ce38b4e48f7a890e36831560ee8','f3962b7e-82c2-494a-bed0-212eb8fe2fb6',91,'40e1bd948bdb4f01851408e900510a3a','share_networks',1,'2025-12-06 10:14:30',NULL),('2025-12-05 10:14:31.612266',NULL,'2025-12-05 10:14:31.617436',290,290,'b7fa2ce38b4e48f7a890e36831560ee8','cbefadd0-fbad-43ac-a16d-08e9e85e5056',91,'40e1bd948bdb4f01851408e900510a3a','share_networks',-1,'2025-12-06 10:14:31',NULL),('2025-12-05 10:14:31.783747',NULL,'2025-12-05 10:14:31.818787',291,291,'b7fa2ce38b4e48f7a890e36831560ee8','0c145b19-8dc0-4d7c-a0b1-35e0d10d6708',91,'40e1bd948bdb4f01851408e900510a3a','share_networks',1,'2025-12-06 10:14:31',NULL),('2025-12-05 10:14:31.950103',NULL,'2025-12-05 10:14:31.958375',292,292,'b7fa2ce38b4e48f7a890e36831560ee8','79dfd7bd-f1bd-4aa2-a5b8-65be750f7cef',91,'40e1bd948bdb4f01851408e900510a3a','share_networks',-1,'2025-12-06 10:14:31',NULL),('2025-12-05 10:14:44.403838',NULL,'2025-12-05 10:14:44.431141',293,293,'dc607a8fb4974085b29b5b37328dc83a','7eb7a1d2-b1a6-4807-8285-7f2f5b023ddb',87,'fb88a523f48e4990b7617051dc3491c9','shares',-1,'2025-12-06 10:14:44',NULL),('2025-12-05 10:14:44.404820',NULL,'2025-12-05 10:14:44.431141',294,294,'dc607a8fb4974085b29b5b37328dc83a','e75034ef-8235-4f85-97e3-ab70be5ac362',88,'fb88a523f48e4990b7617051dc3491c9','gigabytes',-1,'2025-12-06 10:14:44',NULL),('2025-12-05 10:14:44.412864',NULL,'2025-12-05 10:14:44.431141',295,295,NULL,'6eb8fa3a-9eed-440a-bd08-37856b569a2f',89,'fb88a523f48e4990b7617051dc3491c9','shares',-1,'2025-12-06 10:14:44','925f92eb-4755-4dec-9fb7-7aaa82d1d7ed'),('2025-12-05 10:14:44.413889',NULL,'2025-12-05 10:14:44.431141',296,296,NULL,'bdea16df-44bb-4ec5-bdcd-1dc267e8f053',90,'fb88a523f48e4990b7617051dc3491c9','gigabytes',-1,'2025-12-06 10:14:44','925f92eb-4755-4dec-9fb7-7aaa82d1d7ed'),('2025-12-05 10:15:11.164316',NULL,'2025-12-05 10:15:11.197723',297,297,'b92de181a7ba4f11a7e8cf47535f620e','ae5b1beb-4977-4081-b72b-cf1623547fe7',92,'79f3281d6e6d4d5d83a280d0dfd5e85d','shares',1,'2025-12-06 10:15:11',NULL),('2025-12-05 10:15:11.165568',NULL,'2025-12-05 10:15:11.197723',298,298,'b92de181a7ba4f11a7e8cf47535f620e','81f76412-0750-484a-a478-13182438c396',93,'79f3281d6e6d4d5d83a280d0dfd5e85d','gigabytes',1,'2025-12-06 10:15:11',NULL),('2025-12-05 10:15:11.176385',NULL,'2025-12-05 10:15:11.197723',299,299,NULL,'c3f7f0d3-a80b-471b-bc6d-91bbab4854f0',94,'79f3281d6e6d4d5d83a280d0dfd5e85d','shares',1,'2025-12-06 10:15:11','b364e671-4d05-4a07-bbb6-f63562594053'),('2025-12-05 10:15:11.177437',NULL,'2025-12-05 10:15:11.197723',300,300,NULL,'335d10f6-f806-476c-990e-99f6b4dbdc0d',95,'79f3281d6e6d4d5d83a280d0dfd5e85d','gigabytes',1,'2025-12-06 10:15:11','b364e671-4d05-4a07-bbb6-f63562594053'),('2025-12-05 10:15:14.744716',NULL,'2025-12-05 10:15:16.091895',301,301,'d369cec12ec04e22bdfa6abddaf9b93b','981474c4-f63b-463d-87c2-4964ad99642e',97,'9d30aef9a1a4449f82832ccd3ce2ff79','shares',1,'2025-12-06 10:15:14',NULL),('2025-12-05 10:15:14.746138',NULL,'2025-12-05 10:15:16.091895',302,302,'d369cec12ec04e22bdfa6abddaf9b93b','4b2220ea-57db-4b6c-909a-18e90e1443b5',96,'9d30aef9a1a4449f82832ccd3ce2ff79','gigabytes',1,'2025-12-06 10:15:14',NULL),('2025-12-05 10:15:15.271812',NULL,'2025-12-05 10:15:16.091895',303,303,NULL,'d568c109-b6ee-44f0-a8a9-ce6dda9668b2',99,'9d30aef9a1a4449f82832ccd3ce2ff79','shares',1,'2025-12-06 10:15:14','b364e671-4d05-4a07-bbb6-f63562594053'),('2025-12-05 10:15:15.273745',NULL,'2025-12-05 10:15:16.091895',304,304,NULL,'02adbb39-a3cd-424c-9656-d58843c727cc',98,'9d30aef9a1a4449f82832ccd3ce2ff79','gigabytes',1,'2025-12-06 10:15:14','b364e671-4d05-4a07-bbb6-f63562594053'),('2025-12-05 10:15:19.794465',NULL,'2025-12-05 10:15:19.862316',305,305,'05bea8a2829448b5ae9bbf9fea0de669','89e7b8ce-8dd0-4ba9-86f8-264da5ad1298',100,'697949cb96644dfeb8be31be03b2a3ac','shares',1,'2025-12-06 10:15:19',NULL),('2025-12-05 10:15:19.795977',NULL,'2025-12-05 10:15:19.862316',306,306,'05bea8a2829448b5ae9bbf9fea0de669','9becfff6-880f-4f9b-8bd6-9e7bd4895e1b',101,'697949cb96644dfeb8be31be03b2a3ac','gigabytes',1,'2025-12-06 10:15:19',NULL),('2025-12-05 10:15:19.808783',NULL,'2025-12-05 10:15:19.862316',307,307,NULL,'0c939c5e-252a-43ba-a863-35a675b849f0',102,'697949cb96644dfeb8be31be03b2a3ac','shares',1,'2025-12-06 10:15:19','3803e2e0-24da-4c86-bc94-d28949e34165'),('2025-12-05 10:15:19.810402',NULL,'2025-12-05 10:15:19.862316',308,308,NULL,'248f539d-2ed8-4eb5-827a-f83ea0925879',103,'697949cb96644dfeb8be31be03b2a3ac','gigabytes',1,'2025-12-06 10:15:19','3803e2e0-24da-4c86-bc94-d28949e34165'),('2025-12-05 10:15:19.906918',NULL,'2025-12-05 10:15:19.934892',309,309,'d369cec12ec04e22bdfa6abddaf9b93b','37f1f3e1-868b-4a9f-b836-0875a7737fea',97,'9d30aef9a1a4449f82832ccd3ce2ff79','shares',-1,'2025-12-06 10:15:19',NULL),('2025-12-05 10:15:19.907821',NULL,'2025-12-05 10:15:19.934892',310,310,'d369cec12ec04e22bdfa6abddaf9b93b','f6409b23-381c-4758-bcff-ac30f9b287f7',96,'9d30aef9a1a4449f82832ccd3ce2ff79','gigabytes',-1,'2025-12-06 10:15:19',NULL),('2025-12-05 10:15:19.919899',NULL,'2025-12-05 10:15:19.934892',311,311,NULL,'60583df9-3b0d-40f2-b148-8ff7a4bcb505',99,'9d30aef9a1a4449f82832ccd3ce2ff79','shares',-1,'2025-12-06 10:15:19','b364e671-4d05-4a07-bbb6-f63562594053'),('2025-12-05 10:15:19.921174',NULL,'2025-12-05 10:15:19.934892',312,312,NULL,'f4c9f0af-1e31-4051-90c5-d98cc09ff3f4',98,'9d30aef9a1a4449f82832ccd3ce2ff79','gigabytes',-1,'2025-12-06 10:15:19','b364e671-4d05-4a07-bbb6-f63562594053'),('2025-12-05 10:15:23.151319',NULL,'2025-12-05 10:15:23.197186',313,313,'b92de181a7ba4f11a7e8cf47535f620e','565a09ef-f262-4b4b-8f17-1037a5609a09',92,'79f3281d6e6d4d5d83a280d0dfd5e85d','shares',-1,'2025-12-06 10:15:23',NULL),('2025-12-05 10:15:23.152841',NULL,'2025-12-05 10:15:23.197186',314,314,'b92de181a7ba4f11a7e8cf47535f620e','056176e4-b4ea-4867-b16c-39c11409441a',93,'79f3281d6e6d4d5d83a280d0dfd5e85d','gigabytes',-1,'2025-12-06 10:15:23',NULL),('2025-12-05 10:15:23.171043',NULL,'2025-12-05 10:15:23.197186',315,315,NULL,'e6673d71-5400-4bd6-9f4a-671e5ee6a25d',94,'79f3281d6e6d4d5d83a280d0dfd5e85d','shares',-1,'2025-12-06 10:15:23','b364e671-4d05-4a07-bbb6-f63562594053'),('2025-12-05 10:15:23.172359',NULL,'2025-12-05 10:15:23.197186',316,316,NULL,'842f869b-1a95-49bd-8d8e-857840860a04',95,'79f3281d6e6d4d5d83a280d0dfd5e85d','gigabytes',-1,'2025-12-06 10:15:23','b364e671-4d05-4a07-bbb6-f63562594053'),('2025-12-05 10:15:24.797800',NULL,'2025-12-05 10:15:24.822516',317,317,'05bea8a2829448b5ae9bbf9fea0de669','5be00b83-65f5-4004-9dd5-fa565e91d2b6',100,'697949cb96644dfeb8be31be03b2a3ac','shares',-1,'2025-12-06 10:15:24',NULL),('2025-12-05 10:15:24.801685',NULL,'2025-12-05 10:15:24.822516',318,318,'05bea8a2829448b5ae9bbf9fea0de669','f68f640e-47ab-473b-95ef-02b27bc0bb2b',101,'697949cb96644dfeb8be31be03b2a3ac','gigabytes',-1,'2025-12-06 10:15:24',NULL),('2025-12-05 10:15:24.813503',NULL,'2025-12-05 10:15:24.822516',319,319,NULL,'8de357fd-e447-4a6f-b3fc-bdb8aa4e7fc2',102,'697949cb96644dfeb8be31be03b2a3ac','shares',-1,'2025-12-06 10:15:24','3803e2e0-24da-4c86-bc94-d28949e34165'),('2025-12-05 10:15:24.815395',NULL,'2025-12-05 10:15:24.822516',320,320,NULL,'7c12b07e-c4ca-481d-87cd-736a85d4c260',103,'697949cb96644dfeb8be31be03b2a3ac','gigabytes',-1,'2025-12-06 10:15:24','3803e2e0-24da-4c86-bc94-d28949e34165'),('2025-12-05 10:15:26.043180',NULL,'2025-12-05 10:15:26.082571',321,321,'d369cec12ec04e22bdfa6abddaf9b93b','05f526d8-1d4e-4e9e-9c48-d95d47e473d2',97,'9d30aef9a1a4449f82832ccd3ce2ff79','shares',1,'2025-12-06 10:15:26',NULL),('2025-12-05 10:15:26.045082',NULL,'2025-12-05 10:15:26.082571',322,322,'d369cec12ec04e22bdfa6abddaf9b93b','b96eed2a-acd8-4131-aea6-3cdfbc1a0388',96,'9d30aef9a1a4449f82832ccd3ce2ff79','gigabytes',1,'2025-12-06 10:15:26',NULL),('2025-12-05 10:15:26.053655',NULL,'2025-12-05 10:15:26.082571',323,323,NULL,'80a62bc3-a170-4f75-92d6-a3769ea000a6',99,'9d30aef9a1a4449f82832ccd3ce2ff79','shares',1,'2025-12-06 10:15:26','b364e671-4d05-4a07-bbb6-f63562594053'),('2025-12-05 10:15:26.055380',NULL,'2025-12-05 10:15:26.082571',324,324,NULL,'67e77f7e-ece0-464d-a218-875a3c4bc630',98,'9d30aef9a1a4449f82832ccd3ce2ff79','gigabytes',1,'2025-12-06 10:15:26','b364e671-4d05-4a07-bbb6-f63562594053'),('2025-12-05 10:15:29.736776',NULL,'2025-12-05 10:15:29.755229',325,325,'d369cec12ec04e22bdfa6abddaf9b93b','c28caeaf-77c9-4eb9-841c-e80a2a74a500',97,'9d30aef9a1a4449f82832ccd3ce2ff79','shares',-1,'2025-12-06 10:15:29',NULL),('2025-12-05 10:15:29.737689',NULL,'2025-12-05 10:15:29.755229',326,326,'d369cec12ec04e22bdfa6abddaf9b93b','8460efb8-3782-4fe7-93ce-0affd6c76a7c',96,'9d30aef9a1a4449f82832ccd3ce2ff79','gigabytes',-1,'2025-12-06 10:15:29',NULL),('2025-12-05 10:15:29.743772',NULL,'2025-12-05 10:15:29.755229',327,327,NULL,'2917b3f4-1fe1-44d0-89f6-6dade7d290ad',99,'9d30aef9a1a4449f82832ccd3ce2ff79','shares',-1,'2025-12-06 10:15:29','b364e671-4d05-4a07-bbb6-f63562594053'),('2025-12-05 10:15:29.745099',NULL,'2025-12-05 10:15:29.755229',328,328,NULL,'c634d141-32bb-4432-a9f5-6fd8fdd0e3ce',98,'9d30aef9a1a4449f82832ccd3ce2ff79','gigabytes',-1,'2025-12-06 10:15:29','b364e671-4d05-4a07-bbb6-f63562594053'),('2025-12-05 10:15:31.535264',NULL,'2025-12-05 10:15:31.581972',329,329,'d81b90efc7534e8cbfc59c39b640f7c0','685d764a-7834-428b-9a64-7e1b0b2eebf3',104,'8687dc3eee0040e79eeca2d91dd79941','shares',1,'2025-12-06 10:15:31',NULL),('2025-12-05 10:15:31.537752',NULL,'2025-12-05 10:15:31.581972',330,330,'d81b90efc7534e8cbfc59c39b640f7c0','9d91df3f-1005-44a1-89b3-f4482251f54c',105,'8687dc3eee0040e79eeca2d91dd79941','gigabytes',1,'2025-12-06 10:15:31',NULL),('2025-12-05 10:15:31.556878',NULL,'2025-12-05 10:15:31.581972',331,331,NULL,'45e39cba-a0e3-4a62-b862-c9951077ef74',106,'8687dc3eee0040e79eeca2d91dd79941','shares',1,'2025-12-06 10:15:31','a78584c0-d87e-4496-90ad-f0ee4ded2040'),('2025-12-05 10:15:31.558070',NULL,'2025-12-05 10:15:31.581972',332,332,NULL,'5cae55e0-67ab-4ad4-aba7-18b6e0d05d70',107,'8687dc3eee0040e79eeca2d91dd79941','gigabytes',1,'2025-12-06 10:15:31','a78584c0-d87e-4496-90ad-f0ee4ded2040'),('2025-12-05 10:15:34.823081',NULL,'2025-12-05 10:15:34.908301',333,333,'d81b90efc7534e8cbfc59c39b640f7c0','1dec3ce3-04b2-4230-9dd5-329fa458898b',108,'8687dc3eee0040e79eeca2d91dd79941','snapshots',1,'2025-12-06 10:15:34',NULL),('2025-12-05 10:15:34.824782',NULL,'2025-12-05 10:15:34.908301',334,334,'d81b90efc7534e8cbfc59c39b640f7c0','f6ec2e16-09a6-4da4-ab74-dc7237851585',109,'8687dc3eee0040e79eeca2d91dd79941','snapshot_gigabytes',1,'2025-12-06 10:15:34',NULL),('2025-12-05 10:15:34.843065',NULL,'2025-12-05 10:15:34.908301',335,335,NULL,'4487b090-bf48-45ef-8df3-f92182b37a45',110,'8687dc3eee0040e79eeca2d91dd79941','snapshots',1,'2025-12-06 10:15:34','a78584c0-d87e-4496-90ad-f0ee4ded2040'),('2025-12-05 10:15:34.844261',NULL,'2025-12-05 10:15:34.908301',336,336,NULL,'051c3da0-2ff0-43b1-bdea-460ad5895249',111,'8687dc3eee0040e79eeca2d91dd79941','snapshot_gigabytes',1,'2025-12-06 10:15:34','a78584c0-d87e-4496-90ad-f0ee4ded2040'),('2025-12-05 10:15:39.207923',NULL,'2025-12-05 10:15:39.232660',337,337,'d81b90efc7534e8cbfc59c39b640f7c0','799d146c-97c7-46dc-a6ed-6a40d304c0d2',108,'8687dc3eee0040e79eeca2d91dd79941','snapshots',-1,'2025-12-06 10:15:39',NULL),('2025-12-05 10:15:39.208956',NULL,'2025-12-05 10:15:39.232660',338,338,'d81b90efc7534e8cbfc59c39b640f7c0','7db9aad1-20a7-421b-9600-1c55d0da67de',109,'8687dc3eee0040e79eeca2d91dd79941','snapshot_gigabytes',-1,'2025-12-06 10:15:39',NULL),('2025-12-05 10:15:39.216035',NULL,'2025-12-05 10:15:39.232660',339,339,NULL,'2e81c631-6f18-49ca-94dd-129bb0b78604',110,'8687dc3eee0040e79eeca2d91dd79941','snapshots',-1,'2025-12-06 10:15:39','a78584c0-d87e-4496-90ad-f0ee4ded2040'),('2025-12-05 10:15:39.217848',NULL,'2025-12-05 10:15:39.232660',340,340,NULL,'97a3882c-faac-40f4-b401-52ca3596a74f',111,'8687dc3eee0040e79eeca2d91dd79941','snapshot_gigabytes',-1,'2025-12-06 10:15:39','a78584c0-d87e-4496-90ad-f0ee4ded2040'),('2025-12-05 10:15:44.317993',NULL,'2025-12-05 10:15:44.345759',341,341,'d81b90efc7534e8cbfc59c39b640f7c0','9845f53d-cf02-41eb-9de7-a7838fcc2eac',104,'8687dc3eee0040e79eeca2d91dd79941','shares',-1,'2025-12-06 10:15:44',NULL),('2025-12-05 10:15:44.320178',NULL,'2025-12-05 10:15:44.345759',342,342,'d81b90efc7534e8cbfc59c39b640f7c0','6132b06a-e9b7-4ae7-918d-2ade85d4e9ba',105,'8687dc3eee0040e79eeca2d91dd79941','gigabytes',-1,'2025-12-06 10:15:44',NULL),('2025-12-05 10:15:44.332725',NULL,'2025-12-05 10:15:44.345759',343,343,NULL,'97114a72-0696-43eb-b611-5654c2055660',106,'8687dc3eee0040e79eeca2d91dd79941','shares',-1,'2025-12-06 10:15:44','a78584c0-d87e-4496-90ad-f0ee4ded2040'),('2025-12-05 10:15:44.335206',NULL,'2025-12-05 10:15:44.345759',344,344,NULL,'4372faa6-9855-4157-a9e8-0af39d093468',107,'8687dc3eee0040e79eeca2d91dd79941','gigabytes',-1,'2025-12-06 10:15:44','a78584c0-d87e-4496-90ad-f0ee4ded2040'),('2025-12-05 10:15:44.811225',NULL,'2025-12-05 10:15:44.852330',345,345,'ae23d780cb6649c0ab7c884a0d711e81','f4b09eb6-2bc2-46ee-9dd7-0b4b69284fb1',112,'03c6de342ca54bbe8809c2d180c4f2e3','shares',1,'2025-12-06 10:15:44',NULL),('2025-12-05 10:15:44.812823',NULL,'2025-12-05 10:15:44.852330',346,346,'ae23d780cb6649c0ab7c884a0d711e81','0306c936-1c5a-40aa-b2c9-061e6ef27cb0',113,'03c6de342ca54bbe8809c2d180c4f2e3','gigabytes',1,'2025-12-06 10:15:44',NULL),('2025-12-05 10:15:44.824340',NULL,'2025-12-05 10:15:44.852330',347,347,NULL,'ac1217ba-671a-44cd-a46e-8c4839684788',114,'03c6de342ca54bbe8809c2d180c4f2e3','shares',1,'2025-12-06 10:15:44','5ae3fc02-bd9b-43cc-8cd1-9ccd8fdd4d7c'),('2025-12-05 10:15:44.826239',NULL,'2025-12-05 10:15:44.852330',348,348,NULL,'c3221dec-f78d-48d2-8e55-d63250c6a908',115,'03c6de342ca54bbe8809c2d180c4f2e3','gigabytes',1,'2025-12-06 10:15:44','5ae3fc02-bd9b-43cc-8cd1-9ccd8fdd4d7c'),('2025-12-05 10:15:51.229154',NULL,'2025-12-05 10:15:51.408472',349,349,'ae23d780cb6649c0ab7c884a0d711e81','dfc4efbd-d500-4045-a029-9df39e2e4314',112,'03c6de342ca54bbe8809c2d180c4f2e3','shares',-1,'2025-12-06 10:15:51',NULL),('2025-12-05 10:15:51.229836',NULL,'2025-12-05 10:15:51.408472',350,350,'ae23d780cb6649c0ab7c884a0d711e81','9f749b3b-1672-4afd-bfd8-526be8b3c046',113,'03c6de342ca54bbe8809c2d180c4f2e3','gigabytes',-1,'2025-12-06 10:15:51',NULL),('2025-12-05 10:15:51.398703',NULL,'2025-12-05 10:15:51.408472',351,351,NULL,'82709e8f-a6c8-4c8d-8c12-c4adcca4d2b0',114,'03c6de342ca54bbe8809c2d180c4f2e3','shares',-1,'2025-12-06 10:15:51','5ae3fc02-bd9b-43cc-8cd1-9ccd8fdd4d7c'),('2025-12-05 10:15:51.399409',NULL,'2025-12-05 10:15:51.408472',352,352,NULL,'10664bec-9f65-4bb6-9477-3afd7d52a223',115,'03c6de342ca54bbe8809c2d180c4f2e3','gigabytes',-1,'2025-12-06 10:15:51','5ae3fc02-bd9b-43cc-8cd1-9ccd8fdd4d7c'),('2025-12-05 10:16:02.295145',NULL,'2025-12-05 10:16:02.338046',353,353,'07df57f2247a47d4bd454007daad7cb2','ec4d9801-e601-4faa-ab19-5e389d8e2bed',116,'b33bb860f67d445e985f6ff2d7af55b8','shares',1,'2025-12-06 10:16:02',NULL),('2025-12-05 10:16:02.296469',NULL,'2025-12-05 10:16:02.338046',354,354,'07df57f2247a47d4bd454007daad7cb2','45325300-d5da-496a-bb47-4d2d32b4bee2',117,'b33bb860f67d445e985f6ff2d7af55b8','gigabytes',1,'2025-12-06 10:16:02',NULL),('2025-12-05 10:16:02.308029',NULL,'2025-12-05 10:16:02.338046',355,355,NULL,'9865d5e1-a82c-4355-a8f2-6074e61276c6',118,'b33bb860f67d445e985f6ff2d7af55b8','shares',1,'2025-12-06 10:16:02','7d2e45dc-69f9-4275-9fed-cd397eb62d04'),('2025-12-05 10:16:02.309327',NULL,'2025-12-05 10:16:02.338046',356,356,NULL,'84bd0e9e-89e3-4517-a8ef-c692f7a050f1',119,'b33bb860f67d445e985f6ff2d7af55b8','gigabytes',1,'2025-12-06 10:16:02','7d2e45dc-69f9-4275-9fed-cd397eb62d04'),('2025-12-05 10:16:05.257145',NULL,'2025-12-05 10:16:05.328745',357,357,'56e13a6e5136430c91e8af8760aa2ef4','8bd1307d-569d-4136-8af3-1cca00f617b3',120,'21f8c5a5071f4b0da11d0e8d9105e144','share_networks',1,'2025-12-06 10:16:05',NULL),('2025-12-05 10:16:05.600711',NULL,'2025-12-05 10:16:05.688246',358,358,'07df57f2247a47d4bd454007daad7cb2','463a8ffb-9022-4b6d-8b79-8d5a34b68647',121,'b33bb860f67d445e985f6ff2d7af55b8','snapshots',1,'2025-12-06 10:16:05',NULL),('2025-12-05 10:16:05.602554',NULL,'2025-12-05 10:16:05.688246',359,359,'07df57f2247a47d4bd454007daad7cb2','35f39692-e8f4-484d-9ffb-8fa8dc394fd9',122,'b33bb860f67d445e985f6ff2d7af55b8','snapshot_gigabytes',1,'2025-12-06 10:16:05',NULL),('2025-12-05 10:16:05.610505',NULL,'2025-12-05 10:16:05.646439',360,360,'4f9847eafc834176b52e5c274757a634','93cf3cf4-cfc0-4f2e-86f3-e059b2ac20b5',123,'f83026a05cd94543bc2cfa196e903342','share_networks',1,'2025-12-06 10:16:05',NULL),('2025-12-05 10:16:05.620119',NULL,'2025-12-05 10:16:05.688246',361,361,NULL,'a912aec7-bffc-4237-a07b-10b512263538',124,'b33bb860f67d445e985f6ff2d7af55b8','snapshots',1,'2025-12-06 10:16:05','7d2e45dc-69f9-4275-9fed-cd397eb62d04'),('2025-12-05 10:16:05.621792',NULL,'2025-12-05 10:16:05.688246',362,362,NULL,'3ad37c47-6316-4509-92be-275020a9187f',125,'b33bb860f67d445e985f6ff2d7af55b8','snapshot_gigabytes',1,'2025-12-06 10:16:05','7d2e45dc-69f9-4275-9fed-cd397eb62d04'),('2025-12-05 10:16:06.604269',NULL,'2025-12-05 10:16:06.616956',363,363,'56e13a6e5136430c91e8af8760aa2ef4','c05d69d7-1ae2-4b2b-a231-4cca79706b58',120,'21f8c5a5071f4b0da11d0e8d9105e144','share_networks',-1,'2025-12-06 10:16:06',NULL),('2025-12-05 10:16:09.072787',NULL,'2025-12-05 10:16:09.606782',364,364,'07df57f2247a47d4bd454007daad7cb2','ff79a864-15e1-4e1a-ad05-6ed0c96c2336',116,'b33bb860f67d445e985f6ff2d7af55b8','shares',1,'2025-12-06 10:16:09',NULL),('2025-12-05 10:16:09.073946',NULL,'2025-12-05 10:16:09.606782',365,365,'07df57f2247a47d4bd454007daad7cb2','1951e963-e47f-4570-bfdf-90b9488e18ca',117,'b33bb860f67d445e985f6ff2d7af55b8','gigabytes',1,'2025-12-06 10:16:09',NULL),('2025-12-05 10:16:09.548008',NULL,'2025-12-05 10:16:09.606782',366,366,NULL,'79e261e5-68ed-4b69-85d8-bc967d1fa14a',118,'b33bb860f67d445e985f6ff2d7af55b8','shares',1,'2025-12-06 10:16:09','7d2e45dc-69f9-4275-9fed-cd397eb62d04'),('2025-12-05 10:16:09.553162',NULL,'2025-12-05 10:16:09.606782',367,367,NULL,'a3c76e29-19e2-4358-95ef-6adf6e48fe50',119,'b33bb860f67d445e985f6ff2d7af55b8','gigabytes',1,'2025-12-06 10:16:09','7d2e45dc-69f9-4275-9fed-cd397eb62d04'),('2025-12-05 10:16:11.368989',NULL,'2025-12-05 10:16:11.401039',368,368,'1cbac882b1644084a19927eef4c7b1b7','e4493c28-5c9e-4fe0-bb92-4b1fc443c7a5',126,'ce38d31c75764d08b9ff383a5b08c451','shares',1,'2025-12-06 10:16:11',NULL),('2025-12-05 10:16:11.370270',NULL,'2025-12-05 10:16:11.401039',369,369,'1cbac882b1644084a19927eef4c7b1b7','0b14747e-79e9-4fb3-a696-f3f2f654b974',127,'ce38d31c75764d08b9ff383a5b08c451','gigabytes',1,'2025-12-06 10:16:11',NULL),('2025-12-05 10:16:11.379891',NULL,'2025-12-05 10:16:11.401039',370,370,NULL,'46db19b2-2244-4612-9dc8-90d2d55f781e',128,'ce38d31c75764d08b9ff383a5b08c451','shares',1,'2025-12-06 10:16:11','c1f9eccc-7d94-4eff-a11d-f32d3dbccf72'),('2025-12-05 10:16:11.380909',NULL,'2025-12-05 10:16:11.401039',371,371,NULL,'5d0e03b5-0b4c-44ed-9a30-90393c48d2c8',129,'ce38d31c75764d08b9ff383a5b08c451','gigabytes',1,'2025-12-06 10:16:11','c1f9eccc-7d94-4eff-a11d-f32d3dbccf72'),('2025-12-05 10:16:14.610150',NULL,'2025-12-05 10:16:14.647536',372,372,'1cbac882b1644084a19927eef4c7b1b7','3fc3fb22-48e3-45a4-acd8-14a536daba05',126,'ce38d31c75764d08b9ff383a5b08c451','shares',1,'2025-12-06 10:16:14',NULL),('2025-12-05 10:16:14.611257',NULL,'2025-12-05 10:16:14.647536',373,373,'1cbac882b1644084a19927eef4c7b1b7','718b6d4d-6e38-47f9-bb46-9c2c10521a38',127,'ce38d31c75764d08b9ff383a5b08c451','gigabytes',1,'2025-12-06 10:16:14',NULL),('2025-12-05 10:16:14.618191',NULL,'2025-12-05 10:16:14.647536',374,374,NULL,'33e53edf-04cb-4831-9427-d5e6e95bce96',128,'ce38d31c75764d08b9ff383a5b08c451','shares',1,'2025-12-06 10:16:14','c1f9eccc-7d94-4eff-a11d-f32d3dbccf72'),('2025-12-05 10:16:14.620731',NULL,'2025-12-05 10:16:14.647536',375,375,NULL,'d2e03367-0cb6-4ec5-a4f3-c3a5a8ddb5e2',129,'ce38d31c75764d08b9ff383a5b08c451','gigabytes',1,'2025-12-06 10:16:14','c1f9eccc-7d94-4eff-a11d-f32d3dbccf72'),('2025-12-05 10:16:14.820274',NULL,'2025-12-05 10:16:14.853959',376,376,'de2f844b04bf40cb837ae11647ae92f5','241b1bac-5113-42ac-a938-1f579cd32bd6',131,'e7033a26c5f24acbbb25cfa856732f7c','shares',1,'2025-12-06 10:16:14',NULL),('2025-12-05 10:16:14.821351',NULL,'2025-12-05 10:16:14.853959',377,377,'de2f844b04bf40cb837ae11647ae92f5','8cf410b7-3510-48cb-9578-ed05a6a313fc',130,'e7033a26c5f24acbbb25cfa856732f7c','gigabytes',1,'2025-12-06 10:16:14',NULL),('2025-12-05 10:16:14.829700',NULL,'2025-12-05 10:16:14.853959',378,378,NULL,'04ac6278-f848-472d-aa38-3948ceea137c',133,'e7033a26c5f24acbbb25cfa856732f7c','shares',1,'2025-12-06 10:16:14','cd1ce3bc-1c70-4466-a11f-4cd3f1044779'),('2025-12-05 10:16:14.832060',NULL,'2025-12-05 10:16:14.853959',379,379,NULL,'5cb6c4c6-26dd-4a3e-adce-44a2cb6a8619',132,'e7033a26c5f24acbbb25cfa856732f7c','gigabytes',1,'2025-12-06 10:16:14','cd1ce3bc-1c70-4466-a11f-4cd3f1044779'),('2025-12-05 10:16:18.043167',NULL,'2025-12-05 10:16:18.129197',380,380,'de2f844b04bf40cb837ae11647ae92f5','bd6a1047-a492-4111-ab1c-256ca2f10982',135,'e7033a26c5f24acbbb25cfa856732f7c','snapshots',1,'2025-12-06 10:16:18',NULL),('2025-12-05 10:16:18.044917',NULL,'2025-12-05 10:16:18.129197',381,381,'de2f844b04bf40cb837ae11647ae92f5','32257fe6-764c-44ea-8614-a821aa854b0b',134,'e7033a26c5f24acbbb25cfa856732f7c','snapshot_gigabytes',1,'2025-12-06 10:16:18',NULL),('2025-12-05 10:16:18.058236',NULL,'2025-12-05 10:16:18.129197',382,382,NULL,'dae8ee44-d41b-45bb-82cb-735b96e624ee',137,'e7033a26c5f24acbbb25cfa856732f7c','snapshots',1,'2025-12-06 10:16:18','cd1ce3bc-1c70-4466-a11f-4cd3f1044779'),('2025-12-05 10:16:18.060478',NULL,'2025-12-05 10:16:18.129197',383,383,NULL,'75264c74-3fe8-4b44-a92d-9b9f008e8493',136,'e7033a26c5f24acbbb25cfa856732f7c','snapshot_gigabytes',1,'2025-12-06 10:16:18','cd1ce3bc-1c70-4466-a11f-4cd3f1044779'),('2025-12-05 10:16:18.867380',NULL,'2025-12-05 10:16:18.894192',384,384,'1cbac882b1644084a19927eef4c7b1b7','77b0dfe3-2969-462e-a83c-d88fdbbca0e3',126,'ce38d31c75764d08b9ff383a5b08c451','shares',-1,'2025-12-06 10:16:18',NULL),('2025-12-05 10:16:18.868207',NULL,'2025-12-05 10:16:18.894192',385,385,'1cbac882b1644084a19927eef4c7b1b7','ffcfa053-67d0-4956-9ccd-354e162f94a0',127,'ce38d31c75764d08b9ff383a5b08c451','gigabytes',-1,'2025-12-06 10:16:18',NULL),('2025-12-05 10:16:18.884743',NULL,'2025-12-05 10:16:18.894192',386,386,NULL,'62efadb2-7d32-4432-855f-446479133216',128,'ce38d31c75764d08b9ff383a5b08c451','shares',-1,'2025-12-06 10:16:18','c1f9eccc-7d94-4eff-a11d-f32d3dbccf72'),('2025-12-05 10:16:18.885729',NULL,'2025-12-05 10:16:18.894192',387,387,NULL,'e9883aca-6cbd-443c-99d1-9704a981eff0',129,'ce38d31c75764d08b9ff383a5b08c451','gigabytes',-1,'2025-12-06 10:16:18','c1f9eccc-7d94-4eff-a11d-f32d3dbccf72'),('2025-12-05 10:16:21.760331',NULL,'2025-12-05 10:16:21.789247',388,388,'1cbac882b1644084a19927eef4c7b1b7','566bf94a-3c5c-4c7f-bc36-0bd3c36fa950',126,'ce38d31c75764d08b9ff383a5b08c451','shares',1,'2025-12-06 10:16:21',NULL),('2025-12-05 10:16:21.762284',NULL,'2025-12-05 10:16:21.789247',389,389,'1cbac882b1644084a19927eef4c7b1b7','5af86260-ab02-4d03-b940-90cff5455fea',127,'ce38d31c75764d08b9ff383a5b08c451','gigabytes',1,'2025-12-06 10:16:21',NULL),('2025-12-05 10:16:21.769596',NULL,'2025-12-05 10:16:21.789247',390,390,NULL,'a7a59f57-f4f7-41b2-9438-9a51c6757cd9',128,'ce38d31c75764d08b9ff383a5b08c451','shares',1,'2025-12-06 10:16:21','c1f9eccc-7d94-4eff-a11d-f32d3dbccf72'),('2025-12-05 10:16:21.770735',NULL,'2025-12-05 10:16:21.789247',391,391,NULL,'d1d4a0c6-2f44-4b1a-9457-344171149bb7',129,'ce38d31c75764d08b9ff383a5b08c451','gigabytes',1,'2025-12-06 10:16:21','c1f9eccc-7d94-4eff-a11d-f32d3dbccf72'),('2025-12-05 10:16:22.312009',NULL,'2025-12-05 10:16:22.331535',392,392,'de2f844b04bf40cb837ae11647ae92f5','d38be434-1074-4df3-94a6-b4efc66c4c85',135,'e7033a26c5f24acbbb25cfa856732f7c','snapshots',-1,'2025-12-06 10:16:22',NULL),('2025-12-05 10:16:22.313252',NULL,'2025-12-05 10:16:22.331535',393,393,'de2f844b04bf40cb837ae11647ae92f5','8c241435-5763-4604-9b86-6051b402b14b',134,'e7033a26c5f24acbbb25cfa856732f7c','snapshot_gigabytes',-1,'2025-12-06 10:16:22',NULL),('2025-12-05 10:16:22.319242',NULL,'2025-12-05 10:16:22.331535',394,394,NULL,'72797b6a-b859-413c-a981-e0294d06b3f4',137,'e7033a26c5f24acbbb25cfa856732f7c','snapshots',-1,'2025-12-06 10:16:22','cd1ce3bc-1c70-4466-a11f-4cd3f1044779'),('2025-12-05 10:16:22.322921',NULL,'2025-12-05 10:16:22.331535',395,395,NULL,'2ac67a5b-8fff-4e3f-b5af-e0b4398ea2ef',136,'e7033a26c5f24acbbb25cfa856732f7c','snapshot_gigabytes',-1,'2025-12-06 10:16:22','cd1ce3bc-1c70-4466-a11f-4cd3f1044779'),('2025-12-05 10:16:25.421314',NULL,'2025-12-05 10:16:25.435468',396,396,'de2f844b04bf40cb837ae11647ae92f5','2aee017a-ddfa-4199-96a7-9069ca4296a8',131,'e7033a26c5f24acbbb25cfa856732f7c','shares',-1,'2025-12-06 10:16:25',NULL),('2025-12-05 10:16:25.422113',NULL,'2025-12-05 10:16:25.435468',397,397,'de2f844b04bf40cb837ae11647ae92f5','527f4686-ecae-4fad-9cf8-7b4f2b73bfba',130,'e7033a26c5f24acbbb25cfa856732f7c','gigabytes',-1,'2025-12-06 10:16:25',NULL),('2025-12-05 10:16:25.428665',NULL,'2025-12-05 10:16:25.435468',398,398,NULL,'d8a487cd-fb18-474c-88f4-7fabb5da0aad',133,'e7033a26c5f24acbbb25cfa856732f7c','shares',-1,'2025-12-06 10:16:25','cd1ce3bc-1c70-4466-a11f-4cd3f1044779'),('2025-12-05 10:16:25.429382',NULL,'2025-12-05 10:16:25.435468',399,399,NULL,'0c1591e4-8cfb-4c6e-a898-0a4de2bc061f',132,'e7033a26c5f24acbbb25cfa856732f7c','gigabytes',-1,'2025-12-06 10:16:25','cd1ce3bc-1c70-4466-a11f-4cd3f1044779'),('2025-12-05 10:16:26.110392',NULL,'2025-12-05 10:16:26.128687',400,400,'1cbac882b1644084a19927eef4c7b1b7','0b143dc8-014a-4738-872b-0ee21269a31c',126,'ce38d31c75764d08b9ff383a5b08c451','shares',-1,'2025-12-06 10:16:26',NULL),('2025-12-05 10:16:26.111430',NULL,'2025-12-05 10:16:26.128687',401,401,'1cbac882b1644084a19927eef4c7b1b7','d3bd7274-7594-4ee2-b589-1d6af2835e1b',127,'ce38d31c75764d08b9ff383a5b08c451','gigabytes',-1,'2025-12-06 10:16:26',NULL),('2025-12-05 10:16:26.118898',NULL,'2025-12-05 10:16:26.128687',402,402,NULL,'c053641e-3a52-44d1-8f9d-5972c7e8fa27',128,'ce38d31c75764d08b9ff383a5b08c451','shares',-1,'2025-12-06 10:16:26','c1f9eccc-7d94-4eff-a11d-f32d3dbccf72'),('2025-12-05 10:16:26.119910',NULL,'2025-12-05 10:16:26.128687',403,403,NULL,'cd9804b1-12aa-4bbf-8ced-61cf97665b86',129,'ce38d31c75764d08b9ff383a5b08c451','gigabytes',-1,'2025-12-06 10:16:26','c1f9eccc-7d94-4eff-a11d-f32d3dbccf72'),('2025-12-05 10:16:28.999011',NULL,'2025-12-05 10:16:29.089303',404,404,'1cbac882b1644084a19927eef4c7b1b7','93aac8d2-cb48-43b4-9016-687b855ce976',126,'ce38d31c75764d08b9ff383a5b08c451','shares',1,'2025-12-06 10:16:28',NULL),('2025-12-05 10:16:29.000295',NULL,'2025-12-05 10:16:29.089303',405,405,'1cbac882b1644084a19927eef4c7b1b7','f61ff29a-337b-41c6-8040-0ad5b21d920a',127,'ce38d31c75764d08b9ff383a5b08c451','gigabytes',1,'2025-12-06 10:16:28',NULL),('2025-12-05 10:16:29.008012',NULL,'2025-12-05 10:16:29.089303',406,406,NULL,'b096b463-8e42-4e57-af42-bb204bd043c9',128,'ce38d31c75764d08b9ff383a5b08c451','shares',1,'2025-12-06 10:16:28','c1f9eccc-7d94-4eff-a11d-f32d3dbccf72'),('2025-12-05 10:16:29.009440',NULL,'2025-12-05 10:16:29.089303',407,407,NULL,'fa2a26c4-4fb6-414a-b44c-9b63c502170f',129,'ce38d31c75764d08b9ff383a5b08c451','gigabytes',1,'2025-12-06 10:16:28','c1f9eccc-7d94-4eff-a11d-f32d3dbccf72'),('2025-12-05 10:16:32.841289',NULL,'2025-12-05 10:16:32.860095',408,408,'1cbac882b1644084a19927eef4c7b1b7','5c850ab6-5a4f-46bd-add9-1a44b73caf74',126,'ce38d31c75764d08b9ff383a5b08c451','shares',-1,'2025-12-06 10:16:32',NULL),('2025-12-05 10:16:32.842225',NULL,'2025-12-05 10:16:32.860095',409,409,'1cbac882b1644084a19927eef4c7b1b7','b42331f7-25f7-4343-b82d-071624936ed9',127,'ce38d31c75764d08b9ff383a5b08c451','gigabytes',-1,'2025-12-06 10:16:32',NULL),('2025-12-05 10:16:32.851449',NULL,'2025-12-05 10:16:32.860095',410,410,NULL,'9a7f8872-ec4d-49b6-b866-7e41b86680ec',128,'ce38d31c75764d08b9ff383a5b08c451','shares',-1,'2025-12-06 10:16:32','c1f9eccc-7d94-4eff-a11d-f32d3dbccf72'),('2025-12-05 10:16:32.852379',NULL,'2025-12-05 10:16:32.860095',411,411,NULL,'d9c9241f-11e5-4ffb-b66e-645e473e31bc',129,'ce38d31c75764d08b9ff383a5b08c451','gigabytes',-1,'2025-12-06 10:16:32','c1f9eccc-7d94-4eff-a11d-f32d3dbccf72'),('2025-12-05 10:16:35.746379',NULL,'2025-12-05 10:16:35.800836',412,412,'1cbac882b1644084a19927eef4c7b1b7','20adbd68-5b3d-4f27-b171-8b66d57a6ec0',126,'ce38d31c75764d08b9ff383a5b08c451','shares',1,'2025-12-06 10:16:35',NULL),('2025-12-05 10:16:35.753893',NULL,'2025-12-05 10:16:35.800836',413,413,'1cbac882b1644084a19927eef4c7b1b7','38ab76be-321e-4135-9caa-6284b70a2472',127,'ce38d31c75764d08b9ff383a5b08c451','gigabytes',1,'2025-12-06 10:16:35',NULL),('2025-12-05 10:16:35.766694',NULL,'2025-12-05 10:16:35.800836',414,414,NULL,'bde306e4-0c51-4db0-a2ce-15250990fdad',128,'ce38d31c75764d08b9ff383a5b08c451','shares',1,'2025-12-06 10:16:35','c1f9eccc-7d94-4eff-a11d-f32d3dbccf72'),('2025-12-05 10:16:35.769990',NULL,'2025-12-05 10:16:35.800836',415,415,NULL,'c2eac0c4-d5ed-4cd8-8089-e92d4b3786cd',129,'ce38d31c75764d08b9ff383a5b08c451','gigabytes',1,'2025-12-06 10:16:35','c1f9eccc-7d94-4eff-a11d-f32d3dbccf72'),('2025-12-05 10:16:42.229096',NULL,'2025-12-05 10:16:42.930395',416,416,'1cbac882b1644084a19927eef4c7b1b7','95b4c8ea-1084-4a0c-96b6-b4578d83e415',126,'ce38d31c75764d08b9ff383a5b08c451','shares',-1,'2025-12-06 10:16:42',NULL),('2025-12-05 10:16:42.229944',NULL,'2025-12-05 10:16:42.930395',417,417,'1cbac882b1644084a19927eef4c7b1b7','6ffd3545-c60d-42b5-a828-01e112e44ce2',127,'ce38d31c75764d08b9ff383a5b08c451','gigabytes',-1,'2025-12-06 10:16:42',NULL),('2025-12-05 10:16:42.914153',NULL,'2025-12-05 10:16:42.930395',418,418,NULL,'6bcf4442-85fa-4dd6-ac0b-655badeff090',128,'ce38d31c75764d08b9ff383a5b08c451','shares',-1,'2025-12-06 10:16:42','c1f9eccc-7d94-4eff-a11d-f32d3dbccf72'),('2025-12-05 10:16:42.915592',NULL,'2025-12-05 10:16:42.930395',419,419,NULL,'266cf2e7-2ba2-4107-87f0-d55272be388f',129,'ce38d31c75764d08b9ff383a5b08c451','gigabytes',-1,'2025-12-06 10:16:42','c1f9eccc-7d94-4eff-a11d-f32d3dbccf72'),('2025-12-05 10:16:45.451817',NULL,'2025-12-05 10:16:45.478163',420,420,'1cbac882b1644084a19927eef4c7b1b7','101bb287-7663-4106-a7c0-3ef9a8a2786a',126,'ce38d31c75764d08b9ff383a5b08c451','shares',1,'2025-12-06 10:16:45',NULL),('2025-12-05 10:16:45.453223',NULL,'2025-12-05 10:16:45.478163',421,421,'1cbac882b1644084a19927eef4c7b1b7','b2324aad-a427-4ef3-ae73-9a14c7def311',127,'ce38d31c75764d08b9ff383a5b08c451','gigabytes',1,'2025-12-06 10:16:45',NULL),('2025-12-05 10:16:45.458512',NULL,'2025-12-05 10:16:45.478163',422,422,NULL,'b850ed5b-cfcc-46fd-8a90-ad5a0de39a4f',128,'ce38d31c75764d08b9ff383a5b08c451','shares',1,'2025-12-06 10:16:45','c1f9eccc-7d94-4eff-a11d-f32d3dbccf72'),('2025-12-05 10:16:45.459496',NULL,'2025-12-05 10:16:45.478163',423,423,NULL,'2aea9003-2331-41ae-af5c-9b2b3200402a',129,'ce38d31c75764d08b9ff383a5b08c451','gigabytes',1,'2025-12-06 10:16:45','c1f9eccc-7d94-4eff-a11d-f32d3dbccf72'),('2025-12-05 10:16:47.950673',NULL,'2025-12-05 10:16:47.991414',424,424,'c1c1850b8e6d4f43aa6fe0276225946d','0eb30434-3811-40db-935b-2a6499dbb9fa',138,'702f5d76a7514945a7e621e4e93fb7f0','shares',1,'2025-12-06 10:16:47',NULL),('2025-12-05 10:16:47.951972',NULL,'2025-12-05 10:16:47.991414',425,425,'c1c1850b8e6d4f43aa6fe0276225946d','887c3b74-587c-4264-b929-cf0042aa51c2',139,'702f5d76a7514945a7e621e4e93fb7f0','gigabytes',1,'2025-12-06 10:16:47',NULL),('2025-12-05 10:16:47.965283',NULL,'2025-12-05 10:16:47.991414',426,426,NULL,'4f9a6d75-6872-4a06-bfce-53bdb39c0b77',140,'702f5d76a7514945a7e621e4e93fb7f0','shares',1,'2025-12-06 10:16:47','f1bac668-7d97-4e82-8ff1-b0d3f4fdb84f'),('2025-12-05 10:16:47.966405',NULL,'2025-12-05 10:16:47.991414',427,427,NULL,'01b5d80e-1c23-4a44-ae50-3f95d6b0e4d9',141,'702f5d76a7514945a7e621e4e93fb7f0','gigabytes',1,'2025-12-06 10:16:47','f1bac668-7d97-4e82-8ff1-b0d3f4fdb84f'),('2025-12-05 10:16:50.231881',NULL,'2025-12-05 10:16:50.248926',428,428,'1cbac882b1644084a19927eef4c7b1b7','9851ff90-434a-4d04-83d6-5e3301424fb1',126,'ce38d31c75764d08b9ff383a5b08c451','shares',-1,'2025-12-06 10:16:50',NULL),('2025-12-05 10:16:50.232789',NULL,'2025-12-05 10:16:50.248926',429,429,'1cbac882b1644084a19927eef4c7b1b7','19ea7540-1865-478a-9109-82d66e646e8c',127,'ce38d31c75764d08b9ff383a5b08c451','gigabytes',-1,'2025-12-06 10:16:50',NULL),('2025-12-05 10:16:50.239488',NULL,'2025-12-05 10:16:50.248926',430,430,NULL,'d80f62ab-426d-4f69-bc0d-e1c3732e0c7b',128,'ce38d31c75764d08b9ff383a5b08c451','shares',-1,'2025-12-06 10:16:50','c1f9eccc-7d94-4eff-a11d-f32d3dbccf72'),('2025-12-05 10:16:50.240487',NULL,'2025-12-05 10:16:50.248926',431,431,NULL,'2768209c-81fa-48dc-939d-f3e41c8968de',129,'ce38d31c75764d08b9ff383a5b08c451','gigabytes',-1,'2025-12-06 10:16:50','c1f9eccc-7d94-4eff-a11d-f32d3dbccf72'),('2025-12-05 10:16:51.793436',NULL,'2025-12-05 10:16:51.828884',432,432,'c1c1850b8e6d4f43aa6fe0276225946d','13fe92a2-8d30-468c-a247-474115e836a3',138,'702f5d76a7514945a7e621e4e93fb7f0','shares',1,'2025-12-06 10:16:51',NULL),('2025-12-05 10:16:51.795184',NULL,'2025-12-05 10:16:51.828884',433,433,'c1c1850b8e6d4f43aa6fe0276225946d','10252921-f9f8-47ab-a013-1c63b2f0d2d8',139,'702f5d76a7514945a7e621e4e93fb7f0','gigabytes',1,'2025-12-06 10:16:51',NULL),('2025-12-05 10:16:51.804337',NULL,'2025-12-05 10:16:51.828884',434,434,NULL,'9aa69182-5bcc-4346-9c36-5f628421be75',140,'702f5d76a7514945a7e621e4e93fb7f0','shares',1,'2025-12-06 10:16:51','f1bac668-7d97-4e82-8ff1-b0d3f4fdb84f'),('2025-12-05 10:16:51.806481',NULL,'2025-12-05 10:16:51.828884',435,435,NULL,'61640d01-9f43-4f88-a44e-6cb37184f451',141,'702f5d76a7514945a7e621e4e93fb7f0','gigabytes',1,'2025-12-06 10:16:51','f1bac668-7d97-4e82-8ff1-b0d3f4fdb84f'),('2025-12-05 10:16:56.324098',NULL,'2025-12-05 10:16:56.343226',436,436,'1cbac882b1644084a19927eef4c7b1b7','ec237e9d-105d-4cce-ad08-d62be0eaf0d8',126,'ce38d31c75764d08b9ff383a5b08c451','shares',-1,'2025-12-06 10:16:56',NULL),('2025-12-05 10:16:56.325691',NULL,'2025-12-05 10:16:56.343226',437,437,'1cbac882b1644084a19927eef4c7b1b7','dc58a8d2-5afc-446b-87c1-f51d7437d77c',127,'ce38d31c75764d08b9ff383a5b08c451','gigabytes',-1,'2025-12-06 10:16:56',NULL),('2025-12-05 10:16:56.333429',NULL,'2025-12-05 10:16:56.343226',438,438,NULL,'7167c34b-2278-417e-96a8-a5d865e7ec19',128,'ce38d31c75764d08b9ff383a5b08c451','shares',-1,'2025-12-06 10:16:56','c1f9eccc-7d94-4eff-a11d-f32d3dbccf72'),('2025-12-05 10:16:56.334429',NULL,'2025-12-05 10:16:56.343226',439,439,NULL,'ce53896f-a794-431f-8812-2893daa1a0d8',129,'ce38d31c75764d08b9ff383a5b08c451','gigabytes',-1,'2025-12-06 10:16:56','c1f9eccc-7d94-4eff-a11d-f32d3dbccf72'),('2025-12-05 10:16:59.086080',NULL,'2025-12-05 10:16:59.101575',440,440,'c1c1850b8e6d4f43aa6fe0276225946d','1d56653a-6832-46ce-b906-edf487e72ce4',138,'702f5d76a7514945a7e621e4e93fb7f0','shares',-1,'2025-12-06 10:16:59',NULL),('2025-12-05 10:16:59.087882',NULL,'2025-12-05 10:16:59.101575',441,441,'c1c1850b8e6d4f43aa6fe0276225946d','11093c96-c67a-43a2-98d2-15bd59e7f189',139,'702f5d76a7514945a7e621e4e93fb7f0','gigabytes',-1,'2025-12-06 10:16:59',NULL),('2025-12-05 10:16:59.093198',NULL,'2025-12-05 10:16:59.101575',442,442,NULL,'9231e394-044f-4b6a-bd11-b9c1612498fa',140,'702f5d76a7514945a7e621e4e93fb7f0','shares',-1,'2025-12-06 10:16:59','f1bac668-7d97-4e82-8ff1-b0d3f4fdb84f'),('2025-12-05 10:16:59.093870',NULL,'2025-12-05 10:16:59.101575',443,443,NULL,'0b26921d-551b-4a18-90f3-29767be45261',141,'702f5d76a7514945a7e621e4e93fb7f0','gigabytes',-1,'2025-12-06 10:16:59','f1bac668-7d97-4e82-8ff1-b0d3f4fdb84f'),('2025-12-05 10:17:01.617811',NULL,'2025-12-05 10:17:01.646228',444,444,'c1c1850b8e6d4f43aa6fe0276225946d','8a28dcae-40a9-43fd-99f4-ed84b56ecf16',138,'702f5d76a7514945a7e621e4e93fb7f0','shares',1,'2025-12-06 10:17:01',NULL),('2025-12-05 10:17:01.619238',NULL,'2025-12-05 10:17:01.646228',445,445,'c1c1850b8e6d4f43aa6fe0276225946d','81f83007-6a52-4f8d-ba22-7c05877cb30b',139,'702f5d76a7514945a7e621e4e93fb7f0','gigabytes',1,'2025-12-06 10:17:01',NULL),('2025-12-05 10:17:01.626170',NULL,'2025-12-05 10:17:01.646228',446,446,NULL,'3e08b37a-4d1e-447f-9d8b-7a5d722a9ae2',140,'702f5d76a7514945a7e621e4e93fb7f0','shares',1,'2025-12-06 10:17:01','f1bac668-7d97-4e82-8ff1-b0d3f4fdb84f'),('2025-12-05 10:17:01.627344',NULL,'2025-12-05 10:17:01.646228',447,447,NULL,'e83d48ef-0502-46ff-b59a-4dcf38494295',141,'702f5d76a7514945a7e621e4e93fb7f0','gigabytes',1,'2025-12-06 10:17:01','f1bac668-7d97-4e82-8ff1-b0d3f4fdb84f'),('2025-12-05 10:17:08.962013',NULL,'2025-12-05 10:17:08.989297',448,448,'c1c1850b8e6d4f43aa6fe0276225946d','aa75b28e-f14a-47e4-8669-ca2af29702bc',138,'702f5d76a7514945a7e621e4e93fb7f0','shares',-1,'2025-12-06 10:17:08',NULL),('2025-12-05 10:17:08.962862',NULL,'2025-12-05 10:17:08.989297',449,449,'c1c1850b8e6d4f43aa6fe0276225946d','b4bd9991-29c9-420a-a213-10f350b663ca',139,'702f5d76a7514945a7e621e4e93fb7f0','gigabytes',-1,'2025-12-06 10:17:08',NULL),('2025-12-05 10:17:08.973814',NULL,'2025-12-05 10:17:08.989297',450,450,NULL,'567c707d-608f-4843-b9d0-881a6182c868',140,'702f5d76a7514945a7e621e4e93fb7f0','shares',-1,'2025-12-06 10:17:08','f1bac668-7d97-4e82-8ff1-b0d3f4fdb84f'),('2025-12-05 10:17:08.977678',NULL,'2025-12-05 10:17:08.989297',451,451,NULL,'da715ce7-6fc0-493b-bc54-060b53fe7ce2',141,'702f5d76a7514945a7e621e4e93fb7f0','gigabytes',-1,'2025-12-06 10:17:08','f1bac668-7d97-4e82-8ff1-b0d3f4fdb84f'),('2025-12-05 10:17:10.588178',NULL,'2025-12-05 10:17:10.737464',452,452,'a2074ac299fc4eebb364da9f4323590b','42c9491a-20b7-433a-a328-46147d969f5d',142,'175210be70e14bda86d1bac3778b7f23','shares',1,'2025-12-06 10:17:10',NULL),('2025-12-05 10:17:10.590337',NULL,'2025-12-05 10:17:10.737464',453,453,'a2074ac299fc4eebb364da9f4323590b','362c666a-58da-4659-9256-54e7ab067d0e',143,'175210be70e14bda86d1bac3778b7f23','gigabytes',1,'2025-12-06 10:17:10',NULL),('2025-12-05 10:17:10.717418',NULL,'2025-12-05 10:17:10.737464',454,454,NULL,'d759cb59-1d35-493c-98d4-6fbd2ed4c37e',144,'175210be70e14bda86d1bac3778b7f23','shares',1,'2025-12-06 10:17:10','890f2e8e-b696-4432-8e1a-169f51e91e95'),('2025-12-05 10:17:10.718741',NULL,'2025-12-05 10:17:10.737464',455,455,NULL,'49b99902-0c69-4695-8a65-40c21343073a',145,'175210be70e14bda86d1bac3778b7f23','gigabytes',1,'2025-12-06 10:17:10','890f2e8e-b696-4432-8e1a-169f51e91e95'),('2025-12-05 10:17:11.339919',NULL,'2025-12-05 10:17:11.370084',456,456,'c1c1850b8e6d4f43aa6fe0276225946d','d3222d1b-ac43-4f1c-a06c-cc48f6e2a2e1',138,'702f5d76a7514945a7e621e4e93fb7f0','shares',1,'2025-12-06 10:17:11',NULL),('2025-12-05 10:17:11.341535',NULL,'2025-12-05 10:17:11.370084',457,457,'c1c1850b8e6d4f43aa6fe0276225946d','97460f9e-d821-47ce-9344-5af49f4fdb09',139,'702f5d76a7514945a7e621e4e93fb7f0','gigabytes',1,'2025-12-06 10:17:11',NULL),('2025-12-05 10:17:11.348169',NULL,'2025-12-05 10:17:11.370084',458,458,NULL,'2b28231a-d6b1-40ba-86aa-9325470d8397',140,'702f5d76a7514945a7e621e4e93fb7f0','shares',1,'2025-12-06 10:17:11','f1bac668-7d97-4e82-8ff1-b0d3f4fdb84f'),('2025-12-05 10:17:11.349774',NULL,'2025-12-05 10:17:11.370084',459,459,NULL,'9d0842be-d27a-4c17-a87a-2aaa9405aef3',141,'702f5d76a7514945a7e621e4e93fb7f0','gigabytes',1,'2025-12-06 10:17:11','f1bac668-7d97-4e82-8ff1-b0d3f4fdb84f'),('2025-12-05 10:17:15.100497',NULL,'2025-12-05 10:17:15.129584',460,460,'a2074ac299fc4eebb364da9f4323590b','e0dc92ef-6d5c-4272-8f8b-c72291bc85c5',142,'175210be70e14bda86d1bac3778b7f23','shares',-1,'2025-12-06 10:17:15',NULL),('2025-12-05 10:17:15.101860',NULL,'2025-12-05 10:17:15.129584',461,461,'a2074ac299fc4eebb364da9f4323590b','39c7a802-17a5-466d-8dc7-d9eb27d38264',143,'175210be70e14bda86d1bac3778b7f23','gigabytes',-1,'2025-12-06 10:17:15',NULL),('2025-12-05 10:17:15.111893',NULL,'2025-12-05 10:17:15.129584',462,462,NULL,'2a4209a8-e45d-4e9e-b3d2-f117323cf7a7',144,'175210be70e14bda86d1bac3778b7f23','shares',-1,'2025-12-06 10:17:15','890f2e8e-b696-4432-8e1a-169f51e91e95'),('2025-12-05 10:17:15.112978',NULL,'2025-12-05 10:17:15.129584',463,463,NULL,'967b41d1-604e-4354-be80-fbcd28f628f8',145,'175210be70e14bda86d1bac3778b7f23','gigabytes',-1,'2025-12-06 10:17:15','890f2e8e-b696-4432-8e1a-169f51e91e95'),('2025-12-05 10:17:18.688729',NULL,'2025-12-05 10:17:18.706869',464,464,'c1c1850b8e6d4f43aa6fe0276225946d','c4351ac1-e869-42a4-b5fb-d7cb0ee61000',138,'702f5d76a7514945a7e621e4e93fb7f0','shares',-1,'2025-12-06 10:17:18',NULL),('2025-12-05 10:17:18.689732',NULL,'2025-12-05 10:17:18.706869',465,465,'c1c1850b8e6d4f43aa6fe0276225946d','9af2a205-8e74-45f9-ac0b-49344451ce45',139,'702f5d76a7514945a7e621e4e93fb7f0','gigabytes',-1,'2025-12-06 10:17:18',NULL),('2025-12-05 10:17:18.697469',NULL,'2025-12-05 10:17:18.706869',466,466,NULL,'1e694838-2041-4f64-bff2-a9beec9eeb26',140,'702f5d76a7514945a7e621e4e93fb7f0','shares',-1,'2025-12-06 10:17:18','f1bac668-7d97-4e82-8ff1-b0d3f4fdb84f'),('2025-12-05 10:17:18.698556',NULL,'2025-12-05 10:17:18.706869',467,467,NULL,'2a8a9bd8-defa-48a6-ad14-0ab039cce5fa',141,'702f5d76a7514945a7e621e4e93fb7f0','gigabytes',-1,'2025-12-06 10:17:18','f1bac668-7d97-4e82-8ff1-b0d3f4fdb84f'),('2025-12-05 10:17:26.297339',NULL,'2025-12-05 10:17:26.344199',468,468,'ba3df4d4a04d48799dbe5857afbc06c9','d1d92a4c-1daa-4659-aa09-ac04677d6e99',146,'362b693fa42f4124be6d6249e2b9052d','shares',1,'2025-12-06 10:17:26',NULL),('2025-12-05 10:17:26.298504',NULL,'2025-12-05 10:17:26.344199',469,469,'ba3df4d4a04d48799dbe5857afbc06c9','08c0819e-edaa-4f16-bcbf-f0b3ede7fb22',147,'362b693fa42f4124be6d6249e2b9052d','gigabytes',1,'2025-12-06 10:17:26',NULL),('2025-12-05 10:17:26.312981',NULL,'2025-12-05 10:17:26.344199',470,470,NULL,'c3ab3101-4f2e-425c-a4c9-7192d14bf0dd',148,'362b693fa42f4124be6d6249e2b9052d','shares',1,'2025-12-06 10:17:26','af694064-af12-4441-ba1c-ff5d81133112'),('2025-12-05 10:17:26.318200',NULL,'2025-12-05 10:17:26.344199',471,471,NULL,'fcb536e7-2e4e-4a3a-ab87-71ab654179fb',149,'362b693fa42f4124be6d6249e2b9052d','gigabytes',1,'2025-12-06 10:17:26','af694064-af12-4441-ba1c-ff5d81133112'),('2025-12-05 10:17:37.907682',NULL,'2025-12-05 10:17:37.941104',472,472,'675a6cc004734cfeaac8e670fa288294','696592bc-e3ef-4c09-b1cf-95bdf5b4c366',150,'1f21e7e53d6347d5b4115944db13e5b3','shares',1,'2025-12-06 10:17:37',NULL),('2025-12-05 10:17:37.909154',NULL,'2025-12-05 10:17:37.941104',473,473,'675a6cc004734cfeaac8e670fa288294','23bd6573-4089-431d-8714-986bec411b50',151,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',1,'2025-12-06 10:17:37',NULL),('2025-12-05 10:17:37.920170',NULL,'2025-12-05 10:17:37.941104',474,474,NULL,'8ee446a4-e8da-42b7-935f-8b2cce358954',152,'1f21e7e53d6347d5b4115944db13e5b3','shares',1,'2025-12-06 10:17:37','51ebc14f-c4fe-4f50-9d9a-3dd032cdb29e'),('2025-12-05 10:17:37.921381',NULL,'2025-12-05 10:17:37.941104',475,475,NULL,'617b3d6a-f832-4792-8ca4-bf4d69db293e',153,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',1,'2025-12-06 10:17:37','51ebc14f-c4fe-4f50-9d9a-3dd032cdb29e'),('2025-12-05 10:17:41.410559',NULL,'2025-12-05 10:17:41.423248',476,476,'675a6cc004734cfeaac8e670fa288294','0bc74892-564c-4216-ad7e-8c8206091cdf',150,'1f21e7e53d6347d5b4115944db13e5b3','shares',-1,'2025-12-06 10:17:41',NULL),('2025-12-05 10:17:41.411250',NULL,'2025-12-05 10:17:41.423248',477,477,'675a6cc004734cfeaac8e670fa288294','aa01bd08-f958-4a79-8ec0-5d49635495b0',151,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',-1,'2025-12-06 10:17:41',NULL),('2025-12-05 10:17:41.416601',NULL,'2025-12-05 10:17:41.423248',478,478,NULL,'bee069a1-8ae8-4375-b1ee-6d9c91e042d1',152,'1f21e7e53d6347d5b4115944db13e5b3','shares',-1,'2025-12-06 10:17:41','51ebc14f-c4fe-4f50-9d9a-3dd032cdb29e'),('2025-12-05 10:17:41.417204',NULL,'2025-12-05 10:17:41.423248',479,479,NULL,'3923a33a-c169-4a1a-bf20-8e7a71f6dcc4',153,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',-1,'2025-12-06 10:17:41','51ebc14f-c4fe-4f50-9d9a-3dd032cdb29e'),('2025-12-05 10:17:41.495225',NULL,'2025-12-05 10:17:41.537275',480,480,'675a6cc004734cfeaac8e670fa288294','a384189f-7078-4521-b684-abb45980e5d1',150,'1f21e7e53d6347d5b4115944db13e5b3','shares',1,'2025-12-06 10:17:41',NULL),('2025-12-05 10:17:41.496288',NULL,'2025-12-05 10:17:41.537275',481,481,'675a6cc004734cfeaac8e670fa288294','5bd0efe8-675e-4e3b-84fc-4e11b34858c3',151,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',1,'2025-12-06 10:17:41',NULL),('2025-12-05 10:17:41.509660',NULL,'2025-12-05 10:17:41.537275',482,482,NULL,'fa1337ac-1cc3-437c-9db2-769b4f84d82c',154,'1f21e7e53d6347d5b4115944db13e5b3','shares',1,'2025-12-06 10:17:41','76313173-bf9d-46b7-93c5-5f2e0a01c06f'),('2025-12-05 10:17:41.511325',NULL,'2025-12-05 10:17:41.537275',483,483,NULL,'ac49e753-572b-42b1-84b9-4ef609dfc96c',155,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',1,'2025-12-06 10:17:41','76313173-bf9d-46b7-93c5-5f2e0a01c06f'),('2025-12-05 10:17:44.857577',NULL,'2025-12-05 10:17:44.872773',484,484,'675a6cc004734cfeaac8e670fa288294','e787011c-760e-43f1-8ef3-96c304c67529',150,'1f21e7e53d6347d5b4115944db13e5b3','shares',-1,'2025-12-06 10:17:44',NULL),('2025-12-05 10:17:44.858381',NULL,'2025-12-05 10:17:44.872773',485,485,'675a6cc004734cfeaac8e670fa288294','48d14e25-224f-47d7-bc95-1d8e71820a51',151,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',-1,'2025-12-06 10:17:44',NULL),('2025-12-05 10:17:44.865996',NULL,'2025-12-05 10:17:44.872773',486,486,NULL,'adfc0e01-70e6-47d3-af55-cd29afe3f5f2',154,'1f21e7e53d6347d5b4115944db13e5b3','shares',-1,'2025-12-06 10:17:44','76313173-bf9d-46b7-93c5-5f2e0a01c06f'),('2025-12-05 10:17:44.866686',NULL,'2025-12-05 10:17:44.872773',487,487,NULL,'49f565bb-6f6c-4a1b-bd7b-834f065b8e75',155,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',-1,'2025-12-06 10:17:44','76313173-bf9d-46b7-93c5-5f2e0a01c06f'),('2025-12-05 10:17:44.940878',NULL,'2025-12-05 10:17:44.970256',488,488,'675a6cc004734cfeaac8e670fa288294','28b59463-12a3-42f8-99a2-c05de587d311',150,'1f21e7e53d6347d5b4115944db13e5b3','shares',1,'2025-12-06 10:17:44',NULL),('2025-12-05 10:17:44.942092',NULL,'2025-12-05 10:17:44.970256',489,489,'675a6cc004734cfeaac8e670fa288294','174908ba-d04c-4b76-849e-2c7756973ee3',151,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',1,'2025-12-06 10:17:44',NULL),('2025-12-05 10:17:44.951438',NULL,'2025-12-05 10:17:44.970256',490,490,NULL,'e8ca9016-8a4b-4134-8d8a-fb566544187d',157,'1f21e7e53d6347d5b4115944db13e5b3','shares',1,'2025-12-06 10:17:44','4fddb165-bdf0-44a8-924c-92236ede9d77'),('2025-12-05 10:17:44.952656',NULL,'2025-12-05 10:17:44.970256',491,491,NULL,'3490ca1f-ce3d-4c54-85ad-7ea5e5115a7b',156,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',1,'2025-12-06 10:17:44','4fddb165-bdf0-44a8-924c-92236ede9d77'),('2025-12-05 10:17:48.688570',NULL,'2025-12-05 10:17:48.705338',492,492,'c1c1850b8e6d4f43aa6fe0276225946d','147ec943-0b63-4bcd-b20f-02b8ea6e5286',138,'702f5d76a7514945a7e621e4e93fb7f0','shares',-1,'2025-12-06 10:17:48',NULL),('2025-12-05 10:17:48.689689',NULL,'2025-12-05 10:17:48.705338',493,493,'c1c1850b8e6d4f43aa6fe0276225946d','006777bc-6d58-4e2f-8d3f-1a7723518519',139,'702f5d76a7514945a7e621e4e93fb7f0','gigabytes',-1,'2025-12-06 10:17:48',NULL),('2025-12-05 10:17:48.695881',NULL,'2025-12-05 10:17:48.705338',494,494,NULL,'85a1caa9-8129-497f-98ac-e0b4805ea737',140,'702f5d76a7514945a7e621e4e93fb7f0','shares',-1,'2025-12-06 10:17:48','f1bac668-7d97-4e82-8ff1-b0d3f4fdb84f'),('2025-12-05 10:17:48.696880',NULL,'2025-12-05 10:17:48.705338',495,495,NULL,'5a4a5500-0aa1-4ca4-9b87-ef9b4b3483f1',141,'702f5d76a7514945a7e621e4e93fb7f0','gigabytes',-1,'2025-12-06 10:17:48','f1bac668-7d97-4e82-8ff1-b0d3f4fdb84f'),('2025-12-05 10:17:51.209246',NULL,'2025-12-05 10:17:51.267821',496,496,'675a6cc004734cfeaac8e670fa288294','d38ccd02-9409-4bfb-9a01-8ab77666392f',150,'1f21e7e53d6347d5b4115944db13e5b3','shares',1,'2025-12-06 10:17:51',NULL),('2025-12-05 10:17:51.210821',NULL,'2025-12-05 10:17:51.267821',497,497,'675a6cc004734cfeaac8e670fa288294','48dd0270-da85-46c1-a10e-a5fd87baf9bb',151,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',1,'2025-12-06 10:17:51',NULL),('2025-12-05 10:17:51.222517',NULL,'2025-12-05 10:17:51.267821',498,498,NULL,'976e1bb5-ad4e-4aa9-91bd-3e14e5c82c9d',158,'1f21e7e53d6347d5b4115944db13e5b3','shares',1,'2025-12-06 10:17:51','eb919c66-4d19-4ee9-b484-9a8623ca1089'),('2025-12-05 10:17:51.224055',NULL,'2025-12-05 10:17:51.267821',499,499,NULL,'b8d65e4a-65b8-4049-a3d9-c6ec477e4503',159,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',1,'2025-12-06 10:17:51','eb919c66-4d19-4ee9-b484-9a8623ca1089'),('2025-12-05 10:17:52.254942',NULL,'2025-12-05 10:17:52.270462',500,500,'07df57f2247a47d4bd454007daad7cb2','5c5aca9b-754d-4e5b-bbd0-05304e7f1b03',116,'b33bb860f67d445e985f6ff2d7af55b8','shares',-1,'2025-12-06 10:17:52',NULL),('2025-12-05 10:17:52.255759',NULL,'2025-12-05 10:17:52.270462',501,501,'07df57f2247a47d4bd454007daad7cb2','243922aa-6a74-4568-a0ba-8619be31d93d',117,'b33bb860f67d445e985f6ff2d7af55b8','gigabytes',-1,'2025-12-06 10:17:52',NULL),('2025-12-05 10:17:52.261012',NULL,'2025-12-05 10:17:52.270462',502,502,NULL,'9a7c3a63-b59a-44fd-adb1-2b69a96120a3',118,'b33bb860f67d445e985f6ff2d7af55b8','shares',-1,'2025-12-06 10:17:52','7d2e45dc-69f9-4275-9fed-cd397eb62d04'),('2025-12-05 10:17:52.261752',NULL,'2025-12-05 10:17:52.270462',503,503,NULL,'0ee95ef1-d0db-404c-8fa0-34914567e02c',119,'b33bb860f67d445e985f6ff2d7af55b8','gigabytes',-1,'2025-12-06 10:17:52','7d2e45dc-69f9-4275-9fed-cd397eb62d04'),('2025-12-05 10:17:55.584641',NULL,'2025-12-05 10:17:55.609581',504,504,'07df57f2247a47d4bd454007daad7cb2','c37ce95f-f775-4a47-8a64-74ac61d88478',121,'b33bb860f67d445e985f6ff2d7af55b8','snapshots',-1,'2025-12-06 10:17:55',NULL),('2025-12-05 10:17:55.585427',NULL,'2025-12-05 10:17:55.609581',505,505,'07df57f2247a47d4bd454007daad7cb2','4c273cb1-aadb-4512-adc9-ce52f6e02246',122,'b33bb860f67d445e985f6ff2d7af55b8','snapshot_gigabytes',-1,'2025-12-06 10:17:55',NULL),('2025-12-05 10:17:55.595303',NULL,'2025-12-05 10:17:55.609581',506,506,NULL,'32bc5cb1-a86f-434f-b8be-f927a5ca5b9b',124,'b33bb860f67d445e985f6ff2d7af55b8','snapshots',-1,'2025-12-06 10:17:55','7d2e45dc-69f9-4275-9fed-cd397eb62d04'),('2025-12-05 10:17:55.596218',NULL,'2025-12-05 10:17:55.609581',507,507,NULL,'68c14755-d8ed-4899-9b0c-956024cb72a7',125,'b33bb860f67d445e985f6ff2d7af55b8','snapshot_gigabytes',-1,'2025-12-06 10:17:55','7d2e45dc-69f9-4275-9fed-cd397eb62d04'),('2025-12-05 10:17:57.585917',NULL,'2025-12-05 10:17:57.623926',508,508,'26fe7579bfdb46f489eb7a9a7dba3ea8','70e1a50c-8e33-4fd8-9208-45b671dc715b',160,'654f7d6340ba4106be8189aa6b713316','share_networks',1,'2025-12-06 10:17:57',NULL),('2025-12-05 10:17:57.654450',NULL,'2025-12-05 10:17:57.669406',509,509,'675a6cc004734cfeaac8e670fa288294','6e180688-3b18-4818-87da-28ef60ad2351',150,'1f21e7e53d6347d5b4115944db13e5b3','shares',-1,'2025-12-06 10:17:57',NULL),('2025-12-05 10:17:57.655257',NULL,'2025-12-05 10:17:57.669406',510,510,'675a6cc004734cfeaac8e670fa288294','e485cb6a-08df-46da-9175-8c691c8bf1d8',151,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',-1,'2025-12-06 10:17:57',NULL),('2025-12-05 10:17:57.661693',NULL,'2025-12-05 10:17:57.669406',511,511,NULL,'7a883747-3032-4bdb-ab0f-c22825c8d7ab',158,'1f21e7e53d6347d5b4115944db13e5b3','shares',-1,'2025-12-06 10:17:57','eb919c66-4d19-4ee9-b484-9a8623ca1089'),('2025-12-05 10:17:57.662462',NULL,'2025-12-05 10:17:57.669406',512,512,NULL,'f5a8753e-a67b-4bc5-a804-967d86e6aed1',159,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',-1,'2025-12-06 10:17:57','eb919c66-4d19-4ee9-b484-9a8623ca1089'),('2025-12-05 10:17:57.823699',NULL,'2025-12-05 10:17:57.837272',513,513,'675a6cc004734cfeaac8e670fa288294','255487ea-3572-4372-a254-0be5e2c59e24',150,'1f21e7e53d6347d5b4115944db13e5b3','shares',-1,'2025-12-06 10:17:57',NULL),('2025-12-05 10:17:57.824375',NULL,'2025-12-05 10:17:57.837272',514,514,'675a6cc004734cfeaac8e670fa288294','f338ddaa-9074-48c8-9b5d-44d56a4f8a3b',151,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',-1,'2025-12-06 10:17:57',NULL),('2025-12-05 10:17:57.829755',NULL,'2025-12-05 10:17:57.837272',515,515,NULL,'7d2f1d5f-343c-48d5-9cb6-c9b36e1599f3',157,'1f21e7e53d6347d5b4115944db13e5b3','shares',-1,'2025-12-06 10:17:57','4fddb165-bdf0-44a8-924c-92236ede9d77'),('2025-12-05 10:17:57.830407',NULL,'2025-12-05 10:17:57.837272',516,516,NULL,'84aa1bb5-3065-49c2-8d9e-e15583a3a36d',156,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',-1,'2025-12-06 10:17:57','4fddb165-bdf0-44a8-924c-92236ede9d77'),('2025-12-05 10:17:57.926456',NULL,'2025-12-05 10:17:57.939423',517,517,'26fe7579bfdb46f489eb7a9a7dba3ea8','d97251f1-e426-4bf5-9eee-42c88891d26f',160,'654f7d6340ba4106be8189aa6b713316','share_networks',-1,'2025-12-06 10:17:57',NULL),('2025-12-05 10:17:57.933245',NULL,'2025-12-05 10:17:57.976573',518,518,'675a6cc004734cfeaac8e670fa288294','0deffc36-ac22-40f1-8194-6af449ec24f3',150,'1f21e7e53d6347d5b4115944db13e5b3','shares',1,'2025-12-06 10:17:57',NULL),('2025-12-05 10:17:57.935333',NULL,'2025-12-05 10:17:57.976573',519,519,'675a6cc004734cfeaac8e670fa288294','39825c76-b060-4082-9e1f-bb275470def4',151,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',1,'2025-12-06 10:17:57',NULL),('2025-12-05 10:17:57.953376',NULL,'2025-12-05 10:17:57.976573',520,520,NULL,'bac2c4d3-a3ee-4df8-9490-77612f68364f',161,'1f21e7e53d6347d5b4115944db13e5b3','shares',1,'2025-12-06 10:17:57','1bbe8daf-2394-4f63-bb09-bf68e9fe33b2'),('2025-12-05 10:17:57.954488',NULL,'2025-12-05 10:17:57.976573',521,521,NULL,'919936ce-5dad-4b9b-b794-2bff2368d174',162,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',1,'2025-12-06 10:17:57','1bbe8daf-2394-4f63-bb09-bf68e9fe33b2'),('2025-12-05 10:17:58.005902',NULL,'2025-12-05 10:17:58.031221',522,522,'26fe7579bfdb46f489eb7a9a7dba3ea8','815644fa-175e-4203-9d15-1370b371adcf',160,'654f7d6340ba4106be8189aa6b713316','share_networks',1,'2025-12-06 10:17:57',NULL),('2025-12-05 10:17:58.274394',NULL,'2025-12-05 10:17:58.279720',523,523,'26fe7579bfdb46f489eb7a9a7dba3ea8','86a4cce5-7435-4808-a5f7-f8203cf3ee92',160,'654f7d6340ba4106be8189aa6b713316','share_networks',-1,'2025-12-06 10:17:58',NULL),('2025-12-05 10:17:58.339715',NULL,'2025-12-05 10:17:58.369442',524,524,'26fe7579bfdb46f489eb7a9a7dba3ea8','d8b23c4e-a7c3-4281-a611-e5c2090c03e0',160,'654f7d6340ba4106be8189aa6b713316','share_networks',1,'2025-12-06 10:17:58',NULL),('2025-12-05 10:17:58.674642',NULL,'2025-12-05 10:17:58.679802',525,525,'26fe7579bfdb46f489eb7a9a7dba3ea8','4dac57e9-c5c0-4ad1-bff7-d5a2a160cfb0',160,'654f7d6340ba4106be8189aa6b713316','share_networks',-1,'2025-12-06 10:17:58',NULL),('2025-12-05 10:17:58.844243',NULL,'2025-12-05 10:17:58.872188',526,526,'07df57f2247a47d4bd454007daad7cb2','874eef57-81a1-459b-9110-845d33de4847',116,'b33bb860f67d445e985f6ff2d7af55b8','shares',-1,'2025-12-06 10:17:58',NULL),('2025-12-05 10:17:58.845840',NULL,'2025-12-05 10:17:58.872188',527,527,'07df57f2247a47d4bd454007daad7cb2','0bdc2c53-a1b1-4e14-a521-61ee5adb4c9c',117,'b33bb860f67d445e985f6ff2d7af55b8','gigabytes',-1,'2025-12-06 10:17:58',NULL),('2025-12-05 10:17:58.861364',NULL,'2025-12-05 10:17:58.872188',528,528,NULL,'ed8ac483-1e61-4814-ae38-015cc687aaf5',118,'b33bb860f67d445e985f6ff2d7af55b8','shares',-1,'2025-12-06 10:17:58','7d2e45dc-69f9-4275-9fed-cd397eb62d04'),('2025-12-05 10:17:58.862300',NULL,'2025-12-05 10:17:58.872188',529,529,NULL,'e91fe8d1-efd3-452f-bcd9-ed8dcc327514',119,'b33bb860f67d445e985f6ff2d7af55b8','gigabytes',-1,'2025-12-06 10:17:58','7d2e45dc-69f9-4275-9fed-cd397eb62d04'),('2025-12-05 10:18:01.442465',NULL,'2025-12-05 10:18:01.493140',530,530,'675a6cc004734cfeaac8e670fa288294','38272d69-d9c5-4093-b2fb-56f8b1e11eb1',150,'1f21e7e53d6347d5b4115944db13e5b3','shares',1,'2025-12-06 10:18:01',NULL),('2025-12-05 10:18:01.443549',NULL,'2025-12-05 10:18:01.493140',531,531,'675a6cc004734cfeaac8e670fa288294','c0fe16d1-0267-49d7-91a2-999100f28b9f',151,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',1,'2025-12-06 10:18:01',NULL),('2025-12-05 10:18:01.459461',NULL,'2025-12-05 10:18:01.493140',532,532,NULL,'6fd45855-b302-4629-89fd-813aa8159628',163,'1f21e7e53d6347d5b4115944db13e5b3','shares',1,'2025-12-06 10:18:01','36bef84a-ca13-4549-88f1-18c7c3743e47'),('2025-12-05 10:18:01.460588',NULL,'2025-12-05 10:18:01.493140',533,533,NULL,'1642c323-5919-4893-ae61-d3a0ac3932ae',164,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',1,'2025-12-06 10:18:01','36bef84a-ca13-4549-88f1-18c7c3743e47'),('2025-12-05 10:18:07.739110',NULL,'2025-12-05 10:18:07.802756',534,534,'675a6cc004734cfeaac8e670fa288294','cb0f7915-eb72-4923-baee-d823c6b3549b',150,'1f21e7e53d6347d5b4115944db13e5b3','shares',1,'2025-12-06 10:18:07',NULL),('2025-12-05 10:18:07.741501',NULL,'2025-12-05 10:18:07.802756',535,535,'675a6cc004734cfeaac8e670fa288294','23090e30-5a2b-429b-8794-f1fc841cc1c5',151,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',1,'2025-12-06 10:18:07',NULL),('2025-12-05 10:18:07.774742',NULL,'2025-12-05 10:18:07.802756',536,536,NULL,'b65a6de4-0deb-4cc4-b63d-7604318f3d74',166,'1f21e7e53d6347d5b4115944db13e5b3','shares',1,'2025-12-06 10:18:07','e5398329-2e27-4645-892f-ae6a5ad70dfd'),('2025-12-05 10:18:07.776675',NULL,'2025-12-05 10:18:07.802756',537,537,NULL,'75a5ca82-0f69-4d7f-b65f-b3bd518cb1d9',165,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',1,'2025-12-06 10:18:07','e5398329-2e27-4645-892f-ae6a5ad70dfd'),('2025-12-05 10:18:11.335599',NULL,'2025-12-05 10:18:11.394833',538,538,'675a6cc004734cfeaac8e670fa288294','4e6eb0f5-4ce0-4de5-a357-0e0528f627b4',150,'1f21e7e53d6347d5b4115944db13e5b3','shares',-1,'2025-12-06 10:18:11',NULL),('2025-12-05 10:18:11.336422',NULL,'2025-12-05 10:18:11.394833',539,539,'675a6cc004734cfeaac8e670fa288294','b3ba8d38-7b8c-4ad8-9cbe-25f94a89b2a1',151,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',-1,'2025-12-06 10:18:11',NULL),('2025-12-05 10:18:11.378398',NULL,'2025-12-05 10:18:11.394833',540,540,NULL,'9ad2042a-5aa2-4c9c-b128-1ea181ca4282',166,'1f21e7e53d6347d5b4115944db13e5b3','shares',-1,'2025-12-06 10:18:11','e5398329-2e27-4645-892f-ae6a5ad70dfd'),('2025-12-05 10:18:11.383496',NULL,'2025-12-05 10:18:11.394833',541,541,NULL,'00c6708e-cc0d-4743-9bd7-7fc296ccbc86',165,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',-1,'2025-12-06 10:18:11','e5398329-2e27-4645-892f-ae6a5ad70dfd'),('2025-12-05 10:18:11.576756',NULL,'2025-12-05 10:18:11.604102',542,542,'675a6cc004734cfeaac8e670fa288294','4669db79-b2b5-46ee-8bc5-96669cb849d1',150,'1f21e7e53d6347d5b4115944db13e5b3','shares',-1,'2025-12-06 10:18:11',NULL),('2025-12-05 10:18:11.577469',NULL,'2025-12-05 10:18:11.604102',543,543,'675a6cc004734cfeaac8e670fa288294','417f53f4-af36-4a66-a354-c8881ecdd0ee',151,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',-1,'2025-12-06 10:18:11',NULL),('2025-12-05 10:18:11.588060',NULL,'2025-12-05 10:18:11.604102',544,544,NULL,'39b84959-17d3-4db7-a637-9dce48acec55',163,'1f21e7e53d6347d5b4115944db13e5b3','shares',-1,'2025-12-06 10:18:11','36bef84a-ca13-4549-88f1-18c7c3743e47'),('2025-12-05 10:18:11.588813',NULL,'2025-12-05 10:18:11.604102',545,545,NULL,'957589c7-6d54-46d3-b40d-ba51d5d2025c',164,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',-1,'2025-12-06 10:18:11','36bef84a-ca13-4549-88f1-18c7c3743e47'),('2025-12-05 10:18:11.807205',NULL,'2025-12-05 10:18:11.837893',546,546,'675a6cc004734cfeaac8e670fa288294','9ef142aa-b137-43ae-93af-383640be09da',150,'1f21e7e53d6347d5b4115944db13e5b3','shares',-1,'2025-12-06 10:18:11',NULL),('2025-12-05 10:18:11.807994',NULL,'2025-12-05 10:18:11.837893',547,547,'675a6cc004734cfeaac8e670fa288294','c0c59762-b9fe-4903-b8d3-a6c2e57561c3',151,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',-1,'2025-12-06 10:18:11',NULL),('2025-12-05 10:18:11.822458',NULL,'2025-12-05 10:18:11.837893',548,548,NULL,'f9623325-6a58-4068-bd4d-d277595a4304',161,'1f21e7e53d6347d5b4115944db13e5b3','shares',-1,'2025-12-06 10:18:11','1bbe8daf-2394-4f63-bb09-bf68e9fe33b2'),('2025-12-05 10:18:11.825855',NULL,'2025-12-05 10:18:11.837893',549,549,NULL,'88c874c1-d4b3-4739-a18d-902b2bdabcb8',162,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',-1,'2025-12-06 10:18:11','1bbe8daf-2394-4f63-bb09-bf68e9fe33b2'),('2025-12-05 10:18:11.956905',NULL,'2025-12-05 10:18:12.007362',550,550,'675a6cc004734cfeaac8e670fa288294','198dac6e-c689-4e28-b525-cca371b38fa8',150,'1f21e7e53d6347d5b4115944db13e5b3','shares',1,'2025-12-06 10:18:11',NULL),('2025-12-05 10:18:11.958709',NULL,'2025-12-05 10:18:12.007362',551,551,'675a6cc004734cfeaac8e670fa288294','170c75ed-a41b-4629-8d09-caa91e146182',151,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',1,'2025-12-06 10:18:11',NULL),('2025-12-05 10:18:11.974247',NULL,'2025-12-05 10:18:12.007362',552,552,NULL,'14b6eac2-9e65-4d52-bbcc-cbe641c120b1',167,'1f21e7e53d6347d5b4115944db13e5b3','shares',1,'2025-12-06 10:18:11','27bab3c2-3c67-4a33-b303-25f7e777e628'),('2025-12-05 10:18:11.976321',NULL,'2025-12-05 10:18:12.007362',553,553,NULL,'9999833b-64b2-4efc-9f4d-bc8feb53bc54',168,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',1,'2025-12-06 10:18:11','27bab3c2-3c67-4a33-b303-25f7e777e628'),('2025-12-05 10:18:14.267847',NULL,'2025-12-05 10:18:14.320047',554,554,'0ff687168bfe48e9a0ff2725af5ddd2c','a1fbe309-30a4-4fce-8fb5-370c74b660de',169,'499b14cd90ca42a0aa6c88165774ed5f','shares',1,'2025-12-06 10:18:14',NULL),('2025-12-05 10:18:14.270211',NULL,'2025-12-05 10:18:14.320047',555,555,'0ff687168bfe48e9a0ff2725af5ddd2c','7a511262-8afe-422c-a81d-a7b68a83ccbf',170,'499b14cd90ca42a0aa6c88165774ed5f','gigabytes',1,'2025-12-06 10:18:14',NULL),('2025-12-05 10:18:14.285424',NULL,'2025-12-05 10:18:14.320047',556,556,NULL,'723c144a-5827-4a0b-91c3-1148b36d915b',171,'499b14cd90ca42a0aa6c88165774ed5f','shares',1,'2025-12-06 10:18:14','fb81430e-c719-4e13-bf36-a80bcaa1407c'),('2025-12-05 10:18:14.286788',NULL,'2025-12-05 10:18:14.320047',557,557,NULL,'1176a7eb-c6a3-477a-8b7e-1be66d824f47',172,'499b14cd90ca42a0aa6c88165774ed5f','gigabytes',1,'2025-12-06 10:18:14','fb81430e-c719-4e13-bf36-a80bcaa1407c'),('2025-12-05 10:18:15.272337',NULL,'2025-12-05 10:18:15.325298',558,558,'675a6cc004734cfeaac8e670fa288294','0d640d97-57a0-437a-94ee-a6b2335ffcb0',150,'1f21e7e53d6347d5b4115944db13e5b3','shares',1,'2025-12-06 10:18:15',NULL),('2025-12-05 10:18:15.274191',NULL,'2025-12-05 10:18:15.325298',559,559,'675a6cc004734cfeaac8e670fa288294','10605c2e-ed48-428e-97c7-9c7606ddda90',151,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',1,'2025-12-06 10:18:15',NULL),('2025-12-05 10:18:15.285478',NULL,'2025-12-05 10:18:15.325298',560,560,NULL,'54338c2e-61c5-40ac-9be1-16ed72cd2e10',173,'1f21e7e53d6347d5b4115944db13e5b3','shares',1,'2025-12-06 10:18:15','f142faf7-cf55-4cba-aa55-5c89912f5385'),('2025-12-05 10:18:15.287099',NULL,'2025-12-05 10:18:15.325298',561,561,NULL,'d3860afd-896b-4733-8c46-1448bef110e3',174,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',1,'2025-12-06 10:18:15','f142faf7-cf55-4cba-aa55-5c89912f5385'),('2025-12-05 10:18:18.434490',NULL,'2025-12-05 10:18:18.450382',562,562,'0ff687168bfe48e9a0ff2725af5ddd2c','a189d2d7-b12f-49e7-83c6-daee2163f070',169,'499b14cd90ca42a0aa6c88165774ed5f','shares',-1,'2025-12-06 10:18:18',NULL),('2025-12-05 10:18:18.435250',NULL,'2025-12-05 10:18:18.450382',563,563,'0ff687168bfe48e9a0ff2725af5ddd2c','8b3981f6-ad12-48ca-803a-9f73cfc97b14',170,'499b14cd90ca42a0aa6c88165774ed5f','gigabytes',-1,'2025-12-06 10:18:18',NULL),('2025-12-05 10:18:18.441404',NULL,'2025-12-05 10:18:18.450382',564,564,NULL,'76f31bf4-f03c-4543-b6dc-911843fa25ea',171,'499b14cd90ca42a0aa6c88165774ed5f','shares',-1,'2025-12-06 10:18:18','fb81430e-c719-4e13-bf36-a80bcaa1407c'),('2025-12-05 10:18:18.442464',NULL,'2025-12-05 10:18:18.450382',565,565,NULL,'9fc7aae2-081f-42df-9be7-71d2e62bbbe1',172,'499b14cd90ca42a0aa6c88165774ed5f','gigabytes',-1,'2025-12-06 10:18:18','fb81430e-c719-4e13-bf36-a80bcaa1407c'),('2025-12-05 10:18:18.938936',NULL,'2025-12-05 10:18:18.957029',566,566,'675a6cc004734cfeaac8e670fa288294','a9c907ce-e8ea-483b-9d1d-cf7a9e33e432',150,'1f21e7e53d6347d5b4115944db13e5b3','shares',-1,'2025-12-06 10:18:18',NULL),('2025-12-05 10:18:18.939953',NULL,'2025-12-05 10:18:18.957029',567,567,'675a6cc004734cfeaac8e670fa288294','f6e34b9e-b4a1-4080-bf2e-b8fa5f8e85c7',151,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',-1,'2025-12-06 10:18:18',NULL),('2025-12-05 10:18:18.945825',NULL,'2025-12-05 10:18:18.957029',568,568,NULL,'c46d30b9-2815-4f5d-90e6-01f7dd88cbd1',173,'1f21e7e53d6347d5b4115944db13e5b3','shares',-1,'2025-12-06 10:18:18','f142faf7-cf55-4cba-aa55-5c89912f5385'),('2025-12-05 10:18:18.946506',NULL,'2025-12-05 10:18:18.957029',569,569,NULL,'f7bd772a-ae60-4ea0-96c8-4515b03eb7b6',174,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',-1,'2025-12-06 10:18:18','f142faf7-cf55-4cba-aa55-5c89912f5385'),('2025-12-05 10:18:19.131271',NULL,'2025-12-05 10:18:19.155236',570,570,'675a6cc004734cfeaac8e670fa288294','fa3457f4-d676-43d3-97a6-a9ddfeddcd5c',150,'1f21e7e53d6347d5b4115944db13e5b3','shares',-1,'2025-12-06 10:18:19',NULL),('2025-12-05 10:18:19.132165',NULL,'2025-12-05 10:18:19.155236',571,571,'675a6cc004734cfeaac8e670fa288294','b2651ace-19d4-4263-a077-7059a33bab04',151,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',-1,'2025-12-06 10:18:19',NULL),('2025-12-05 10:18:19.138943',NULL,'2025-12-05 10:18:19.155236',572,572,NULL,'32792028-ff90-45dc-a24f-a75c1d60f3f9',167,'1f21e7e53d6347d5b4115944db13e5b3','shares',-1,'2025-12-06 10:18:19','27bab3c2-3c67-4a33-b303-25f7e777e628'),('2025-12-05 10:18:19.139603',NULL,'2025-12-05 10:18:19.155236',573,573,NULL,'5b12213e-982c-4444-8449-c3a84327d41a',168,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',-1,'2025-12-06 10:18:19','27bab3c2-3c67-4a33-b303-25f7e777e628'),('2025-12-05 10:18:19.247537',NULL,'2025-12-05 10:18:19.288855',574,574,'675a6cc004734cfeaac8e670fa288294','ae47dd95-0717-4649-88d5-b3c6c08adcd5',150,'1f21e7e53d6347d5b4115944db13e5b3','shares',1,'2025-12-06 10:18:19',NULL),('2025-12-05 10:18:19.249345',NULL,'2025-12-05 10:18:19.288855',575,575,'675a6cc004734cfeaac8e670fa288294','d019f37c-d6e5-4f27-b8ea-cf8a92a40218',151,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',1,'2025-12-06 10:18:19',NULL),('2025-12-05 10:18:19.261670',NULL,'2025-12-05 10:18:19.288855',576,576,NULL,'b56f7e52-417d-41e7-9d5b-ae28cb537261',175,'1f21e7e53d6347d5b4115944db13e5b3','shares',1,'2025-12-06 10:18:19','dbeffb0b-e0b5-4cc0-9234-89458f4ebb71'),('2025-12-05 10:18:19.263359',NULL,'2025-12-05 10:18:19.288855',577,577,NULL,'caefa026-da43-47b7-9d17-97aa359ca6a6',176,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',1,'2025-12-06 10:18:19','dbeffb0b-e0b5-4cc0-9234-89458f4ebb71'),('2025-12-05 10:18:22.696712',NULL,'2025-12-05 10:18:22.710252',578,578,'675a6cc004734cfeaac8e670fa288294','dc57983e-4162-400d-93f5-747eaf1e1e0b',150,'1f21e7e53d6347d5b4115944db13e5b3','shares',-1,'2025-12-06 10:18:22',NULL),('2025-12-05 10:18:22.697701',NULL,'2025-12-05 10:18:22.710252',579,579,'675a6cc004734cfeaac8e670fa288294','bfa91b3a-cbed-46ed-9595-b878383dd7d5',151,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',-1,'2025-12-06 10:18:22',NULL),('2025-12-05 10:18:22.703406',NULL,'2025-12-05 10:18:22.710252',580,580,NULL,'969acde8-d561-4fda-80b7-a7988046852d',175,'1f21e7e53d6347d5b4115944db13e5b3','shares',-1,'2025-12-06 10:18:22','dbeffb0b-e0b5-4cc0-9234-89458f4ebb71'),('2025-12-05 10:18:22.704018',NULL,'2025-12-05 10:18:22.710252',581,581,NULL,'dcfd3b42-b01f-4d2d-9a92-879c4aaaddc5',176,'1f21e7e53d6347d5b4115944db13e5b3','gigabytes',-1,'2025-12-06 10:18:22','dbeffb0b-e0b5-4cc0-9234-89458f4ebb71'),('2025-12-05 10:18:29.747706',NULL,'2025-12-05 10:18:29.816974',582,582,'0a892d7a0540429ba23646d4a938bfe8','939276fd-2432-4bd2-a718-a2914f8626a1',177,'713485f6825d4fbb96a3a6dfd0cac4e0','shares',1,'2025-12-06 10:18:29',NULL),('2025-12-05 10:18:29.760086',NULL,'2025-12-05 10:18:29.816974',583,583,'0a892d7a0540429ba23646d4a938bfe8','7f3775e0-bf06-4045-b13d-3a3a88c2e3f6',178,'713485f6825d4fbb96a3a6dfd0cac4e0','gigabytes',1,'2025-12-06 10:18:29',NULL),('2025-12-05 10:18:29.785047',NULL,'2025-12-05 10:18:29.816974',584,584,NULL,'996370d1-361d-4cac-b534-e9ca281bdb6f',179,'713485f6825d4fbb96a3a6dfd0cac4e0','shares',1,'2025-12-06 10:18:29','a463f1e0-8246-4ffe-b810-f2359c6971ef'),('2025-12-05 10:18:29.787135',NULL,'2025-12-05 10:18:29.816974',585,585,NULL,'75dc5472-65ca-4ed0-a5da-eb6d1aed05a3',180,'713485f6825d4fbb96a3a6dfd0cac4e0','gigabytes',1,'2025-12-06 10:18:29','a463f1e0-8246-4ffe-b810-f2359c6971ef'),('2025-12-05 10:18:34.593557',NULL,'2025-12-05 10:18:34.609953',586,586,'0a892d7a0540429ba23646d4a938bfe8','3ffb1763-57ae-4fbb-8a0e-8a5a714b492a',177,'713485f6825d4fbb96a3a6dfd0cac4e0','shares',-1,'2025-12-06 10:18:34',NULL),('2025-12-05 10:18:34.594239',NULL,'2025-12-05 10:18:34.609953',587,587,'0a892d7a0540429ba23646d4a938bfe8','db25ff00-ea51-4fe2-8009-ff34adcbe823',178,'713485f6825d4fbb96a3a6dfd0cac4e0','gigabytes',-1,'2025-12-06 10:18:34',NULL),('2025-12-05 10:18:34.599023',NULL,'2025-12-05 10:18:34.609953',588,588,NULL,'18a4cf21-529d-4e1b-8129-e658def96673',179,'713485f6825d4fbb96a3a6dfd0cac4e0','shares',-1,'2025-12-06 10:18:34','a463f1e0-8246-4ffe-b810-f2359c6971ef'),('2025-12-05 10:18:34.601923',NULL,'2025-12-05 10:18:34.609953',589,589,NULL,'bff26986-4e01-45b5-b977-98025d61273d',180,'713485f6825d4fbb96a3a6dfd0cac4e0','gigabytes',-1,'2025-12-06 10:18:34','a463f1e0-8246-4ffe-b810-f2359c6971ef'),('2025-12-05 10:18:41.150762',NULL,'2025-12-05 10:18:41.205006',590,590,'0cae89584b954da8bbeb73eca8518688','5fd54547-1c39-4986-95b0-ede3643da88a',182,'0324648a65a343649c4079ef816ceb9e','shares',1,'2025-12-06 10:18:41',NULL),('2025-12-05 10:18:41.152116',NULL,'2025-12-05 10:18:41.205006',591,591,'0cae89584b954da8bbeb73eca8518688','587f077a-3675-4ba6-bf7c-d8b3593ac1f1',181,'0324648a65a343649c4079ef816ceb9e','gigabytes',1,'2025-12-06 10:18:41',NULL),('2025-12-05 10:18:41.164843',NULL,'2025-12-05 10:18:41.205006',592,592,NULL,'63029387-1ee2-4511-9b43-3b45bb2c74ea',184,'0324648a65a343649c4079ef816ceb9e','shares',1,'2025-12-06 10:18:41','c454d92d-8a8d-4636-8e70-a1b4aa0713ad'),('2025-12-05 10:18:41.166391',NULL,'2025-12-05 10:18:41.205006',593,593,NULL,'f74ec0e6-5a89-4666-92dc-a7bcaf8e366b',183,'0324648a65a343649c4079ef816ceb9e','gigabytes',1,'2025-12-06 10:18:41','c454d92d-8a8d-4636-8e70-a1b4aa0713ad'),('2025-12-05 10:18:44.491357',NULL,'2025-12-05 10:18:44.523545',594,594,'0cae89584b954da8bbeb73eca8518688','9d55d34b-4f3b-4147-bc4f-0acca5997383',182,'0324648a65a343649c4079ef816ceb9e','shares',1,'2025-12-06 10:18:44',NULL),('2025-12-05 10:18:44.492905',NULL,'2025-12-05 10:18:44.523545',595,595,'0cae89584b954da8bbeb73eca8518688','41c12625-78bd-4d4e-a466-3936a2d169cc',181,'0324648a65a343649c4079ef816ceb9e','gigabytes',1,'2025-12-06 10:18:44',NULL),('2025-12-05 10:18:44.498997',NULL,'2025-12-05 10:18:44.523545',596,596,NULL,'4c3409b4-630f-45bd-934f-f7421e883637',184,'0324648a65a343649c4079ef816ceb9e','shares',1,'2025-12-06 10:18:44','c454d92d-8a8d-4636-8e70-a1b4aa0713ad'),('2025-12-05 10:18:44.500178',NULL,'2025-12-05 10:18:44.523545',597,597,NULL,'30eee2c5-fb32-4dd2-a3ff-65b96e2528e5',183,'0324648a65a343649c4079ef816ceb9e','gigabytes',1,'2025-12-06 10:18:44','c454d92d-8a8d-4636-8e70-a1b4aa0713ad'),('2025-12-05 10:18:48.144865',NULL,'2025-12-05 10:18:48.408177',598,598,'0cae89584b954da8bbeb73eca8518688','dca7b6fa-c739-4c44-8721-6a85e89e37b1',182,'0324648a65a343649c4079ef816ceb9e','shares',-1,'2025-12-06 10:18:48',NULL),('2025-12-05 10:18:48.148222',NULL,'2025-12-05 10:18:48.408177',599,599,'0cae89584b954da8bbeb73eca8518688','f3da91c4-69f6-4160-92e8-ccf46571f714',181,'0324648a65a343649c4079ef816ceb9e','gigabytes',-1,'2025-12-06 10:18:48',NULL),('2025-12-05 10:18:48.194795',NULL,'2025-12-05 10:18:48.408177',600,600,NULL,'1f7172cf-956a-45d4-aaa9-8d55efde1a99',184,'0324648a65a343649c4079ef816ceb9e','shares',-1,'2025-12-06 10:18:48','c454d92d-8a8d-4636-8e70-a1b4aa0713ad'),('2025-12-05 10:18:48.343834',NULL,'2025-12-05 10:18:48.408177',601,601,NULL,'3bafba47-db65-440c-9295-a69a9596916a',183,'0324648a65a343649c4079ef816ceb9e','gigabytes',-1,'2025-12-06 10:18:48','c454d92d-8a8d-4636-8e70-a1b4aa0713ad'),('2025-12-05 10:18:51.472108',NULL,'2025-12-05 10:18:51.487071',602,602,'0cae89584b954da8bbeb73eca8518688','ecdd761e-59e7-4d93-9909-c6bade99a881',182,'0324648a65a343649c4079ef816ceb9e','shares',-1,'2025-12-06 10:18:51',NULL),('2025-12-05 10:18:51.472898',NULL,'2025-12-05 10:18:51.487071',603,603,'0cae89584b954da8bbeb73eca8518688','2dceb4ce-fc88-4d53-8fdb-b2d98ec300e6',181,'0324648a65a343649c4079ef816ceb9e','gigabytes',-1,'2025-12-06 10:18:51',NULL),('2025-12-05 10:18:51.480443',NULL,'2025-12-05 10:18:51.487071',604,604,NULL,'df93be27-badf-40b8-9000-d48b8ca9293a',184,'0324648a65a343649c4079ef816ceb9e','shares',-1,'2025-12-06 10:18:51','c454d92d-8a8d-4636-8e70-a1b4aa0713ad'),('2025-12-05 10:18:51.481141',NULL,'2025-12-05 10:18:51.487071',605,605,NULL,'5d2c34f8-132f-49b4-b6c1-0d35613c6491',183,'0324648a65a343649c4079ef816ceb9e','gigabytes',-1,'2025-12-06 10:18:51','c454d92d-8a8d-4636-8e70-a1b4aa0713ad'),('2025-12-05 10:18:54.454439',NULL,'2025-12-05 10:18:54.506012',606,606,'0cae89584b954da8bbeb73eca8518688','c956fe4f-c939-4dc3-af04-d89c77656b89',185,'0324648a65a343649c4079ef816ceb9e','share_groups',1,'2025-12-06 10:18:54',NULL),('2025-12-05 10:18:57.729365',NULL,'2025-12-05 10:18:57.744701',607,607,'0cae89584b954da8bbeb73eca8518688','eacd1b87-b87f-458f-acb8-8a9b9cf58b36',185,'0324648a65a343649c4079ef816ceb9e','share_groups',-1,'2025-12-06 10:18:57',NULL),('2025-12-05 10:18:57.860259',NULL,'2025-12-05 10:18:57.882632',608,608,'0cae89584b954da8bbeb73eca8518688','0cd00019-ca8f-463d-88c3-8c10885e3423',185,'0324648a65a343649c4079ef816ceb9e','share_groups',1,'2025-12-06 10:18:57',NULL),('2025-12-05 10:19:01.063410',NULL,'2025-12-05 10:19:01.074334',609,609,'0cae89584b954da8bbeb73eca8518688','8c46f0a2-f4d8-425c-8ebd-36d313b24708',185,'0324648a65a343649c4079ef816ceb9e','share_groups',-1,'2025-12-06 10:19:01',NULL),('2025-12-05 10:19:04.210186',NULL,'2025-12-05 10:19:04.260758',610,610,'0cae89584b954da8bbeb73eca8518688','19c8e69c-7aed-4a80-8a16-7e6297f8b380',182,'0324648a65a343649c4079ef816ceb9e','shares',1,'2025-12-06 10:19:04',NULL),('2025-12-05 10:19:04.211570',NULL,'2025-12-05 10:19:04.260758',611,611,'0cae89584b954da8bbeb73eca8518688','ed8c5f80-3800-4c24-827a-6a2c2c758650',181,'0324648a65a343649c4079ef816ceb9e','gigabytes',1,'2025-12-06 10:19:04',NULL),('2025-12-05 10:19:04.221362',NULL,'2025-12-05 10:19:04.260758',612,612,NULL,'5bae1321-0797-4ac4-ac88-87d87f60cef2',184,'0324648a65a343649c4079ef816ceb9e','shares',1,'2025-12-06 10:19:04','c454d92d-8a8d-4636-8e70-a1b4aa0713ad'),('2025-12-05 10:19:04.222771',NULL,'2025-12-05 10:19:04.260758',613,613,NULL,'92beabf5-0fa1-40c1-9be7-dd37abeafcac',183,'0324648a65a343649c4079ef816ceb9e','gigabytes',1,'2025-12-06 10:19:04','c454d92d-8a8d-4636-8e70-a1b4aa0713ad'),('2025-12-05 10:19:05.887089',NULL,'2025-12-05 10:19:06.131660',614,614,'48c071afb6b4441dbadeb32daa6f0611','22dfe8bb-6bb3-449e-9700-0c2b5fb116ef',187,'c1ecc993dd0d4bd78005db93dca023b4','shares',1,'2025-12-06 10:19:05',NULL),('2025-12-05 10:19:05.888837',NULL,'2025-12-05 10:19:06.131660',615,615,'48c071afb6b4441dbadeb32daa6f0611','38e2eaff-9e9d-4e80-81bf-b8851cbae825',186,'c1ecc993dd0d4bd78005db93dca023b4','gigabytes',1,'2025-12-06 10:19:05',NULL),('2025-12-05 10:19:05.951462',NULL,'2025-12-05 10: