/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `barbican`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `barbican` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `barbican`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('8c74e2d7f1ff');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authorities`
--

DROP TABLE IF EXISTS `certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `plugin_ca_id` text NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cas_project_fk` (`project_id`),
  CONSTRAINT `cas_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authorities`
--

LOCK TABLES `certificate_authorities` WRITE;
/*!40000 ALTER TABLE `certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authority_metadata`
--

DROP TABLE IF EXISTS `certificate_authority_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authority_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_certificate_authority_metadatum_uc` (`ca_id`,`key`),
  KEY `ix_certificate_authority_metadata_ca_id` (`ca_id`),
  KEY `ix_certificate_authority_metadata_key` (`key`),
  CONSTRAINT `certificate_authority_metadata_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authority_metadata`
--

LOCK TABLES `certificate_authority_metadata` WRITE;
/*!40000 ALTER TABLE `certificate_authority_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authority_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acl_users`
--

DROP TABLE IF EXISTS `container_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_container_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `container_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `container_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acl_users`
--

LOCK TABLES `container_acl_users` WRITE;
/*!40000 ALTER TABLE `container_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acls`
--

DROP TABLE IF EXISTS `container_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_operation_uc` (`container_id`,`operation`),
  KEY `ix_container_acls_container_id` (`container_id`),
  CONSTRAINT `container_acls_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acls`
--

LOCK TABLES `container_acls` WRITE;
/*!40000 ALTER TABLE `container_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_consumer_metadata`
--

DROP TABLE IF EXISTS `container_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `name` varchar(36) DEFAULT NULL,
  `URL` varchar(255) DEFAULT NULL,
  `data_hash` char(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_consumer_hashed_container_name_url_uc` (`data_hash`),
  KEY `ix_container_consumer_metadata_container_id` (`container_id`),
  KEY `ix_container_consumer_metadata_project_id` (`project_id`),
  KEY `values_index` (`container_id`,`name`,`URL`),
  CONSTRAINT `container_consumer_metadata_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_consumer_metadata_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_consumer_metadata`
--

LOCK TABLES `container_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `container_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_secret`
--

DROP TABLE IF EXISTS `container_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_secret` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `container_id` varchar(36) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_secret_name_uc` (`container_id`,`secret_id`,`name`),
  KEY `ix_container_secret_container_id` (`container_id`),
  KEY `ix_container_secret_secret_id` (`secret_id`),
  CONSTRAINT `container_secret_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_secret_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_secret`
--

LOCK TABLES `container_secret` WRITE;
/*!40000 ALTER TABLE `container_secret` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `containers`
--

DROP TABLE IF EXISTS `containers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `containers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('generic','rsa','dsa','certificate') DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_containers_project_id` (`project_id`),
  CONSTRAINT `containers_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `containers`
--

LOCK TABLES `containers` WRITE;
/*!40000 ALTER TABLE `containers` DISABLE KEYS */;
/*!40000 ALTER TABLE `containers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encrypted_data`
--

DROP TABLE IF EXISTS `encrypted_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encrypted_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `secret_id` varchar(36) NOT NULL,
  `kek_id` varchar(36) NOT NULL,
  `cypher_text` text DEFAULT NULL,
  `kek_meta_extended` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_encrypted_data_kek_id` (`kek_id`),
  KEY `ix_encrypted_data_secret_id` (`secret_id`),
  CONSTRAINT `encrypted_data_ibfk_1` FOREIGN KEY (`kek_id`) REFERENCES `kek_data` (`id`),
  CONSTRAINT `encrypted_data_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encrypted_data`
--

LOCK TABLES `encrypted_data` WRITE;
/*!40000 ALTER TABLE `encrypted_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `encrypted_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kek_data`
--

DROP TABLE IF EXISTS `kek_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kek_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `kek_label` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `bind_completed` tinyint(1) NOT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `plugin_meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_kek_data_project_id` (`project_id`),
  CONSTRAINT `kek_data_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kek_data`
--

LOCK TABLES `kek_data` WRITE;
/*!40000 ALTER TABLE `kek_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `kek_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_barbican_metadata`
--

DROP TABLE IF EXISTS `order_barbican_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_barbican_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_barbican_metadata_order_id` (`order_id`),
  CONSTRAINT `order_barbican_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_barbican_metadata`
--

LOCK TABLES `order_barbican_metadata` WRITE;
/*!40000 ALTER TABLE `order_barbican_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_barbican_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_plugin_metadata`
--

DROP TABLE IF EXISTS `order_plugin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_plugin_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_plugin_metadata_order_id` (`order_id`),
  CONSTRAINT `order_plugin_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_plugin_metadata`
--

LOCK TABLES `order_plugin_metadata` WRITE;
/*!40000 ALTER TABLE `order_plugin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_plugin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_retry_tasks`
--

DROP TABLE IF EXISTS `order_retry_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_retry_tasks` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `id` varchar(36) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `retry_task` text NOT NULL,
  `retry_at` datetime NOT NULL,
  `retry_args` text NOT NULL,
  `retry_kwargs` text NOT NULL,
  `retry_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_retry_tasks_order_id` (`order_id`),
  CONSTRAINT `order_retry_tasks_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_retry_tasks`
--

LOCK TABLES `order_retry_tasks` WRITE;
/*!40000 ALTER TABLE `order_retry_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_retry_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `error_status_code` varchar(16) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  `secret_id` varchar(36) DEFAULT NULL,
  `container_id` varchar(36) DEFAULT NULL,
  `sub_status` varchar(36) DEFAULT NULL,
  `sub_status_message` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_orders_container_id` (`container_id`),
  KEY `ix_orders_project_id` (`project_id`),
  KEY `ix_orders_secret_id` (`secret_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`),
  CONSTRAINT `orders_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preferred_certificate_authorities`
--

DROP TABLE IF EXISTS `preferred_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `preferred_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_preferred_certificate_authorities_project_id` (`project_id`),
  KEY `ix_preferred_certificate_authorities_ca_id` (`ca_id`),
  CONSTRAINT `preferred_certificate_authorities_fk` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `preferred_certificate_authorities_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preferred_certificate_authorities`
--

LOCK TABLES `preferred_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `preferred_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `preferred_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_certificate_authorities`
--

DROP TABLE IF EXISTS `project_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_certificate_authority_uc` (`project_id`,`ca_id`),
  KEY `ix_project_certificate_authorities_ca_id` (`ca_id`),
  KEY `ix_project_certificate_authorities_project_id` (`project_id`),
  CONSTRAINT `project_certificate_authorities_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `project_certificate_authorities_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_certificate_authorities`
--

LOCK TABLES `project_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `project_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_quotas`
--

DROP TABLE IF EXISTS `project_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_quotas` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `secrets` int(11) DEFAULT NULL,
  `orders` int(11) DEFAULT NULL,
  `containers` int(11) DEFAULT NULL,
  `consumers` int(11) DEFAULT NULL,
  `cas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_project_quotas_project_id` (`project_id`),
  CONSTRAINT `project_quotas_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_quotas`
--

LOCK TABLES `project_quotas` WRITE;
/*!40000 ALTER TABLE `project_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_secret_store`
--

DROP TABLE IF EXISTS `project_secret_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_secret_store` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_store_id` varchar(36) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_secret_store_project_uc` (`project_id`),
  KEY `ix_project_secret_store_project_id` (`project_id`),
  KEY `ix_project_secret_store_secret_store_id` (`secret_store_id`),
  CONSTRAINT `project_secret_store_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `project_secret_store_ibfk_2` FOREIGN KEY (`secret_store_id`) REFERENCES `secret_stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_secret_store`
--

LOCK TABLES `project_secret_store` WRITE;
/*!40000 ALTER TABLE `project_secret_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_secret_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `external_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acl_users`
--

DROP TABLE IF EXISTS `secret_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_secret_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `secret_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `secret_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acl_users`
--

LOCK TABLES `secret_acl_users` WRITE;
/*!40000 ALTER TABLE `secret_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acls`
--

DROP TABLE IF EXISTS `secret_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_operation_uc` (`secret_id`,`operation`),
  KEY `ix_secret_acls_secret_id` (`secret_id`),
  CONSTRAINT `secret_acls_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acls`
--

LOCK TABLES `secret_acls` WRITE;
/*!40000 ALTER TABLE `secret_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_consumer_metadata`
--

DROP TABLE IF EXISTS `secret_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `service` varchar(255) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_consumer_resource_uc` (`secret_id`,`service`,`resource_type`,`resource_id`),
  KEY `ix_secret_consumer_metadata_secret_id` (`secret_id`),
  KEY `ix_secret_consumer_metadata_resource_id` (`resource_id`),
  KEY `ix_secret_consumer_metadata_project_id` (`project_id`),
  CONSTRAINT `fk_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `secret_consumer_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_consumer_metadata`
--

LOCK TABLES `secret_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `secret_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_store_metadata`
--

DROP TABLE IF EXISTS `secret_store_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_store_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secret_store_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_store_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_store_metadata`
--

LOCK TABLES `secret_store_metadata` WRITE;
/*!40000 ALTER TABLE `secret_store_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_store_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_stores`
--

DROP TABLE IF EXISTS `secret_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_stores` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `store_plugin` varchar(255) NOT NULL,
  `crypto_plugin` varchar(255) DEFAULT NULL,
  `global_default` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_stores_name_uc` (`name`),
  UNIQUE KEY `_secret_stores_plugin_names_uc` (`store_plugin`,`crypto_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_stores`
--

LOCK TABLES `secret_stores` WRITE;
/*!40000 ALTER TABLE `secret_stores` DISABLE KEYS */;
INSERT INTO `secret_stores` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `store_plugin`, `crypto_plugin`, `global_default`, `name`) VALUES ('6f98c93f-9c57-4c6e-a921-dc40216c455f','2025-11-29 04:55:59','2025-11-29 04:55:59',NULL,0,'ACTIVE','store_crypto','simple_crypto',1,'Software Only Crypto');
/*!40000 ALTER TABLE `secret_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_user_metadata`
--

DROP TABLE IF EXISTS `secret_user_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_user_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_key_uc` (`secret_id`,`key`),
  KEY `ix_secret_user_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_user_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_user_metadata`
--

LOCK TABLES `secret_user_metadata` WRITE;
/*!40000 ALTER TABLE `secret_user_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_user_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secrets`
--

DROP TABLE IF EXISTS `secrets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secrets` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `secret_type` varchar(255) DEFAULT 'opaque',
  `expiration` datetime DEFAULT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secrets_project_id` (`project_id`),
  CONSTRAINT `secrets_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secrets`
--

LOCK TABLES `secrets` WRITE;
/*!40000 ALTER TABLE `secrets` DISABLE KEYS */;
/*!40000 ALTER TABLE `secrets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_keys`
--

DROP TABLE IF EXISTS `transport_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transport_keys` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `transport_key` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_keys`
--

LOCK TABLES `transport_keys` WRITE;
/*!40000 ALTER TABLE `transport_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `cinder`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `cinder` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `cinder`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('daa98075b90d');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment_specs`
--

DROP TABLE IF EXISTS `attachment_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_attachment_specs_attachment_id` (`attachment_id`),
  CONSTRAINT `attachment_specs_ibfk_1` FOREIGN KEY (`attachment_id`) REFERENCES `volume_attachment` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment_specs`
--

LOCK TABLES `attachment_specs` WRITE;
/*!40000 ALTER TABLE `attachment_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_metadata`
--

DROP TABLE IF EXISTS `backup_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_backup_metadata_backup_id` (`backup_id`),
  CONSTRAINT `backup_metadata_ibfk_1` FOREIGN KEY (`backup_id`) REFERENCES `backups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_metadata`
--

LOCK TABLES `backup_metadata` WRITE;
/*!40000 ALTER TABLE `backup_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `container` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fail_reason` varchar(255) DEFAULT NULL,
  `service_metadata` varchar(255) DEFAULT NULL,
  `service` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `object_count` int(11) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `temp_volume_id` varchar(36) DEFAULT NULL,
  `temp_snapshot_id` varchar(36) DEFAULT NULL,
  `num_dependent_backups` int(11) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `data_timestamp` datetime DEFAULT NULL,
  `restore_volume_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cgsnapshots`
--

DROP TABLE IF EXISTS `cgsnapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cgsnapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `consistencygroup_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_cgsnapshots_consistencygroup_id` (`consistencygroup_id`),
  CONSTRAINT `cgsnapshots_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cgsnapshots`
--

LOCK TABLES `cgsnapshots` WRITE;
/*!40000 ALTER TABLE `cgsnapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `cgsnapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clusters`
--

DROP TABLE IF EXISTS `clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clusters` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`binary`,`race_preventer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clusters`
--

LOCK TABLES `clusters` WRITE;
/*!40000 ALTER TABLE `clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consistencygroups`
--

DROP TABLE IF EXISTS `consistencygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consistencygroups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `volume_type_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `source_cgid` varchar(36) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consistencygroups`
--

LOCK TABLES `consistencygroups` WRITE;
/*!40000 ALTER TABLE `consistencygroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `consistencygroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_volume_types`
--

DROP TABLE IF EXISTS `default_volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `default_volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  KEY `ix_default_volume_types_volume_type_id` (`volume_type_id`),
  CONSTRAINT `default_volume_types_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_volume_types`
--

LOCK TABLES `default_volume_types` WRITE;
/*!40000 ALTER TABLE `default_volume_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver_initiator_data`
--

DROP TABLE IF EXISTS `driver_initiator_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `driver_initiator_data` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `initiator` (`initiator`,`namespace`,`key`),
  KEY `ix_driver_initiator_data_initiator` (`initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver_initiator_data`
--

LOCK TABLES `driver_initiator_data` WRITE;
/*!40000 ALTER TABLE `driver_initiator_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `driver_initiator_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encryption`
--

DROP TABLE IF EXISTS `encryption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encryption` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `cipher` varchar(255) DEFAULT NULL,
  `control_location` varchar(255) NOT NULL,
  `key_size` int(11) DEFAULT NULL,
  `provider` varchar(255) NOT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `encryption_id` varchar(36) NOT NULL,
  PRIMARY KEY (`encryption_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encryption`
--

LOCK TABLES `encryption` WRITE;
/*!40000 ALTER TABLE `encryption` DISABLE KEYS */;
/*!40000 ALTER TABLE `encryption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_snapshots`
--

DROP TABLE IF EXISTS `group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_snapshots_group_id` (`group_id`),
  KEY `group_snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `group_snapshots_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_snapshots`
--

LOCK TABLES `group_snapshots` WRITE;
/*!40000 ALTER TABLE `group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_projects`
--

DROP TABLE IF EXISTS `group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_type_id` (`group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `group_type_projects_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_projects`
--

LOCK TABLES `group_type_projects` WRITE;
/*!40000 ALTER TABLE `group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_specs`
--

DROP TABLE IF EXISTS `group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_type_specs_group_type_id` (`group_type_id`),
  CONSTRAINT `group_type_specs_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_specs`
--

LOCK TABLES `group_type_specs` WRITE;
/*!40000 ALTER TABLE `group_type_specs` DISABLE KEYS */;
INSERT INTO `group_type_specs` (`id`, `key`, `value`, `group_type_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'consistent_group_snapshot_enabled','<is> True','545da779-6fb6-4943-bba4-cda86252a3b3','2025-11-29 04:55:55','2025-11-29 04:55:55',NULL,0);
/*!40000 ALTER TABLE `group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_types`
--

DROP TABLE IF EXISTS `group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_types` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_types`
--

LOCK TABLES `group_types` WRITE;
/*!40000 ALTER TABLE `group_types` DISABLE KEYS */;
INSERT INTO `group_types` (`id`, `name`, `description`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `is_public`) VALUES ('545da779-6fb6-4943-bba4-cda86252a3b3','default_cgsnapshot_type','Default group type for migrating cgsnapshot','2025-11-29 04:55:55','2025-11-29 04:55:55',NULL,0,1);
/*!40000 ALTER TABLE `group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_volume_type_mapping`
--

DROP TABLE IF EXISTS `group_volume_type_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_volume_type_mapping` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_volume_type_mapping_volume_type_id` (`volume_type_id`),
  KEY `ix_group_volume_type_mapping_group_id` (`group_id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_volume_type_mapping`
--

LOCK TABLES `group_volume_type_mapping` WRITE;
/*!40000 ALTER TABLE `group_volume_type_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_volume_type_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `groups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `source_group_id` varchar(36) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groups_deleted_project_id_idx` (`deleted`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_volume_cache_entries`
--

DROP TABLE IF EXISTS `image_volume_cache_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_volume_cache_entries` (
  `image_updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `image_id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `size` int(11) NOT NULL,
  `last_used` datetime NOT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_volume_cache_entries_image_id` (`image_id`),
  KEY `ix_image_volume_cache_entries_host` (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_volume_cache_entries`
--

LOCK TABLES `image_volume_cache_entries` WRITE;
/*!40000 ALTER TABLE `image_volume_cache_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_volume_cache_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(36) DEFAULT NULL,
  `resource_uuid` varchar(255) DEFAULT NULL,
  `event_id` varchar(255) NOT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `action_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_messages_expires_at` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quality_of_service_specs`
--

DROP TABLE IF EXISTS `quality_of_service_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quality_of_service_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `specs_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quality_of_service_specs_specs_id` (`specs_id`),
  CONSTRAINT `quality_of_service_specs_ibfk_1` FOREIGN KEY (`specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quality_of_service_specs`
--

LOCK TABLES `quality_of_service_specs` WRITE;
/*!40000 ALTER TABLE `quality_of_service_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `quality_of_service_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
INSERT INTO `quota_classes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `class_name`, `resource`, `hard_limit`) VALUES ('2025-11-29 04:55:52',NULL,NULL,0,1,'default','volumes',10),('2025-11-29 04:55:52',NULL,NULL,0,2,'default','snapshots',10),('2025-11-29 04:55:52',NULL,NULL,0,3,'default','gigabytes',1000),('2025-11-29 04:55:52',NULL,NULL,0,4,'default','consistencygroups',10),('2025-11-29 04:55:52',NULL,NULL,0,5,'default','per_volume_gigabytes',-1),('2025-11-29 04:55:52',NULL,NULL,0,6,'default','groups',10);
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(300) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `race_preventer` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`,`race_preventer`),
  KEY `ix_quota_usages_project_id` (`project_id`),
  KEY `quota_usage_project_resource_idx` (`project_id`,`resource`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `allocated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `allocated_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  KEY `ix_reservations_usage_id` (`usage_id`),
  KEY `reservations_deleted_uuid_idx` (`deleted`,`uuid`),
  KEY `ix_reservations_allocated_id` (`allocated_id`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`),
  CONSTRAINT `reservations_ibfk_2` FOREIGN KEY (`allocated_id`) REFERENCES `quotas` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `rpc_current_version` varchar(36) DEFAULT NULL,
  `object_current_version` varchar(36) DEFAULT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `frozen` tinyint(1) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `services_uuid_idx` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone`, `disabled_reason`, `modified_at`, `rpc_current_version`, `object_current_version`, `replication_status`, `frozen`, `active_backend_id`, `cluster_name`, `uuid`) VALUES ('2025-11-29 04:56:04','2025-11-29 05:57:59',NULL,0,1,'cinder-scheduler-0','cinder-scheduler','cinder-scheduler',367,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'8a8ba550-fb3f-48b5-bd53-ae5e1ff74c1b'),('2025-11-29 05:28:50','2025-11-29 05:58:01',NULL,0,2,'cinder-backup-0','cinder-backup','cinder-backup',175,0,'nova',NULL,NULL,'2.4','1.39','not-capable',0,NULL,NULL,'0a922d93-bd2a-4822-838e-f8a5c9f89f16'),('2025-11-29 05:28:50','2025-11-29 05:58:02',NULL,0,3,'hostgroup@ceph','cinder-volume','cinder-volume',175,0,'nova',NULL,NULL,'3.18','1.39','disabled',0,NULL,NULL,'af53977c-663c-4800-bde5-61835592b1eb');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot_metadata`
--

DROP TABLE IF EXISTS `snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshot_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `snapshot_metadata_ibfk_1` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot_metadata`
--

LOCK TABLES `snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `snapshot_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshots`
--

DROP TABLE IF EXISTS `snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `volume_size` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `provider_auth` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshots_cgsnapshot_id` (`cgsnapshot_id`),
  KEY `ix_snapshots_volume_id` (`volume_id`),
  KEY `ix_snapshots_group_snapshot_id` (`group_snapshot_id`),
  KEY `snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `snapshots_ibfk_1` FOREIGN KEY (`cgsnapshot_id`) REFERENCES `cgsnapshots` (`id`),
  CONSTRAINT `snapshots_ibfk_2` FOREIGN KEY (`group_snapshot_id`) REFERENCES `group_snapshots` (`id`),
  CONSTRAINT `snapshots_volume_id_fkey` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshots`
--

LOCK TABLES `snapshots` WRITE;
/*!40000 ALTER TABLE `snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `no_snapshots` tinyint(1) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_transfers_volume_id` (`volume_id`),
  CONSTRAINT `transfers_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_admin_metadata`
--

DROP TABLE IF EXISTS `volume_admin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_admin_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_admin_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_admin_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_admin_metadata`
--

LOCK TABLES `volume_admin_metadata` WRITE;
/*!40000 ALTER TABLE `volume_admin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_admin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_attachment`
--

DROP TABLE IF EXISTS `volume_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_attachment` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `attached_host` varchar(255) DEFAULT NULL,
  `instance_uuid` varchar(36) DEFAULT NULL,
  `mountpoint` varchar(255) DEFAULT NULL,
  `attach_time` datetime DEFAULT NULL,
  `detach_time` datetime DEFAULT NULL,
  `attach_mode` varchar(36) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `connection_info` text DEFAULT NULL,
  `connector` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_attachment_volume_id` (`volume_id`),
  CONSTRAINT `volume_attachment_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_attachment`
--

LOCK TABLES `volume_attachment` WRITE;
/*!40000 ALTER TABLE `volume_attachment` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_glance_metadata`
--

DROP TABLE IF EXISTS `volume_glance_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_glance_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_glance_metadata_snapshot_id` (`snapshot_id`),
  KEY `ix_volume_glance_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_glance_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `volume_glance_metadata_ibfk_2` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_glance_metadata`
--

LOCK TABLES `volume_glance_metadata` WRITE;
/*!40000 ALTER TABLE `volume_glance_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_glance_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_metadata`
--

DROP TABLE IF EXISTS `volume_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_metadata`
--

LOCK TABLES `volume_metadata` WRITE;
/*!40000 ALTER TABLE `volume_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_extra_specs`
--

DROP TABLE IF EXISTS `volume_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_extra_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_type_extra_specs_volume_type_id` (`volume_type_id`),
  CONSTRAINT `volume_type_extra_specs_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_extra_specs`
--

LOCK TABLES `volume_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `volume_type_extra_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_projects`
--

DROP TABLE IF EXISTS `volume_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `volume_type_id` (`volume_type_id`,`project_id`,`deleted`),
  CONSTRAINT `volume_type_projects_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_projects`
--

LOCK TABLES `volume_type_projects` WRITE;
/*!40000 ALTER TABLE `volume_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_types`
--

DROP TABLE IF EXISTS `volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `qos_specs_id` varchar(36) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_types_qos_specs_id` (`qos_specs_id`),
  CONSTRAINT `volume_types_ibfk_1` FOREIGN KEY (`qos_specs_id`) REFERENCES `quality_of_service_specs` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_types`
--

LOCK TABLES `volume_types` WRITE;
/*!40000 ALTER TABLE `volume_types` DISABLE KEYS */;
INSERT INTO `volume_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `qos_specs_id`, `is_public`, `description`) VALUES ('2025-11-29 04:55:55','2025-11-29 04:55:55',NULL,0,'52097158-7168-4638-9e13-30c5edb324a2','__DEFAULT__',NULL,1,'Default Volume Type');
/*!40000 ALTER TABLE `volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ec2_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(256) DEFAULT NULL,
  `provider_auth` varchar(256) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `source_volid` varchar(36) DEFAULT NULL,
  `bootable` tinyint(1) DEFAULT NULL,
  `provider_geometry` varchar(255) DEFAULT NULL,
  `_name_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `migration_status` varchar(255) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  `replication_extended_status` varchar(255) DEFAULT NULL,
  `replication_driver_data` varchar(255) DEFAULT NULL,
  `consistencygroup_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `multiattach` tinyint(1) DEFAULT NULL,
  `previous_status` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `group_id` varchar(36) DEFAULT NULL,
  `service_uuid` varchar(36) DEFAULT NULL,
  `shared_targets` tinyint(1) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volumes_consistencygroup_id` (`consistencygroup_id`),
  KEY `volumes_service_uuid_idx` (`service_uuid`,`deleted`),
  KEY `ix_volumes_group_id` (`group_id`),
  KEY `volumes_deleted_project_id_idx` (`deleted`,`project_id`),
  KEY `volumes_deleted_host_idx` (`deleted`,`host`),
  CONSTRAINT `volumes_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `volumes_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `volumes_ibfk_3` FOREIGN KEY (`service_uuid`) REFERENCES `services` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workers`
--

DROP TABLE IF EXISTS `workers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `workers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(40) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  `status` varchar(255) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_type` (`resource_type`,`resource_id`),
  KEY `ix_workers_service_id` (`service_id`),
  CONSTRAINT `workers_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workers`
--

LOCK TABLES `workers` WRITE;
/*!40000 ALTER TABLE `workers` DISABLE KEYS */;
INSERT INTO `workers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `resource_type`, `resource_id`, `status`, `service_id`, `race_preventer`) VALUES ('2025-11-29 04:55:55','2025-11-29 04:55:55.000123',NULL,0,1,'SENTINEL','SUB-SECOND','OK',NULL,0);
/*!40000 ALTER TABLE `workers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `glance`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `glance` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `glance`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('2023_1_contract01');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_locations`
--

DROP TABLE IF EXISTS `image_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `meta_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `ix_image_locations_deleted` (`deleted`),
  KEY `ix_image_locations_image_id` (`image_id`),
  CONSTRAINT `image_locations_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_locations`
--

LOCK TABLES `image_locations` WRITE;
/*!40000 ALTER TABLE `image_locations` DISABLE KEYS */;
INSERT INTO `image_locations` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `meta_data`, `status`) VALUES (1,'c62e9c5a-6a26-4e13-8fc7-5c707bbbf0ea','rbd://93f82912-647c-5e78-b081-707d0a2966d8/images/c62e9c5a-6a26-4e13-8fc7-5c707bbbf0ea/snap','2025-11-29 05:34:03','2025-11-29 05:34:03',NULL,0,'{\"store\": \"default_backend\"}','active'),(2,'18473368-1d7e-4e8f-8c02-8e3acff1f9d9','rbd://93f82912-647c-5e78-b081-707d0a2966d8/images/18473368-1d7e-4e8f-8c02-8e3acff1f9d9/snap','2025-11-29 05:34:05','2025-11-29 05:34:05',NULL,0,'{\"store\": \"default_backend\"}','active');
/*!40000 ALTER TABLE `image_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_members`
--

DROP TABLE IF EXISTS `image_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `member` varchar(255) NOT NULL,
  `can_share` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image_members_image_id_member_deleted_at_key` (`image_id`,`member`,`deleted_at`),
  KEY `ix_image_members_deleted` (`deleted`),
  KEY `ix_image_members_image_id` (`image_id`),
  KEY `ix_image_members_image_id_member` (`image_id`,`member`),
  CONSTRAINT `image_members_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`can_share` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_members`
--

LOCK TABLES `image_members` WRITE;
/*!40000 ALTER TABLE `image_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_properties`
--

DROP TABLE IF EXISTS `image_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_image_properties_image_id_name` (`image_id`,`name`),
  KEY `ix_image_properties_deleted` (`deleted`),
  KEY `ix_image_properties_image_id` (`image_id`),
  CONSTRAINT `image_properties_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_properties`
--

LOCK TABLES `image_properties` WRITE;
/*!40000 ALTER TABLE `image_properties` DISABLE KEYS */;
INSERT INTO `image_properties` (`id`, `image_id`, `name`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'c62e9c5a-6a26-4e13-8fc7-5c707bbbf0ea','hw_rng_model','virtio','2025-11-29 05:33:59','2025-11-29 05:33:59',NULL,0),(2,'18473368-1d7e-4e8f-8c02-8e3acff1f9d9','hw_rng_model','virtio','2025-11-29 05:34:03','2025-11-29 05:34:03',NULL,0);
/*!40000 ALTER TABLE `image_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_tags`
--

DROP TABLE IF EXISTS `image_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_tags_image_id` (`image_id`),
  KEY `ix_image_tags_image_id_tag_value` (`image_id`,`value`),
  CONSTRAINT `image_tags_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_tags`
--

LOCK TABLES `image_tags` WRITE;
/*!40000 ALTER TABLE `image_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `disk_format` varchar(20) DEFAULT NULL,
  `container_format` varchar(20) DEFAULT NULL,
  `checksum` varchar(32) DEFAULT NULL,
  `owner` varchar(255) DEFAULT NULL,
  `min_disk` int(11) NOT NULL,
  `min_ram` int(11) NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT 0,
  `virtual_size` bigint(20) DEFAULT NULL,
  `visibility` enum('private','public','shared','community') NOT NULL DEFAULT 'shared',
  `os_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `os_hash_algo` varchar(64) DEFAULT NULL,
  `os_hash_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checksum_image_idx` (`checksum`),
  KEY `ix_images_deleted` (`deleted`),
  KEY `owner_image_idx` (`owner`),
  KEY `created_at_image_idx` (`created_at`),
  KEY `updated_at_image_idx` (`updated_at`),
  KEY `visibility_image_idx` (`visibility`),
  KEY `os_hidden_image_idx` (`os_hidden`),
  KEY `os_hash_value_image_idx` (`os_hash_value`),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`protected` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` (`id`, `name`, `size`, `status`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `disk_format`, `container_format`, `checksum`, `owner`, `min_disk`, `min_ram`, `protected`, `virtual_size`, `visibility`, `os_hidden`, `os_hash_algo`, `os_hash_value`) VALUES ('18473368-1d7e-4e8f-8c02-8e3acff1f9d9','cirros-0.6.2-x86_64-disk.img_alt',21430272,'active','2025-11-29 05:34:03','2025-11-29 05:34:05',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','389b14b74e3c4a1184dca228ba013067',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('c62e9c5a-6a26-4e13-8fc7-5c707bbbf0ea','cirros-0.6.2-x86_64-disk.img',21430272,'active','2025-11-29 05:33:59','2025-11-29 05:34:03',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','389b14b74e3c4a1184dca228ba013067',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b');
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespace_resource_types`
--

DROP TABLE IF EXISTS `metadef_namespace_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespace_resource_types` (
  `resource_type_id` int(11) NOT NULL,
  `namespace_id` int(11) NOT NULL,
  `properties_target` varchar(80) DEFAULT NULL,
  `prefix` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`resource_type_id`,`namespace_id`),
  KEY `ix_metadef_ns_res_types_namespace_id` (`namespace_id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_2` FOREIGN KEY (`resource_type_id`) REFERENCES `metadef_resource_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespace_resource_types`
--

LOCK TABLES `metadef_namespace_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_namespace_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_namespace_resource_types` (`resource_type_id`, `namespace_id`, `properties_target`, `prefix`, `created_at`, `updated_at`) VALUES (1,1,'image','CIM_PASD_','2025-11-29 04:54:51',NULL),(1,2,'image','CIM_RASD_','2025-11-29 04:54:51',NULL),(1,3,NULL,'CIM_SASD_','2025-11-29 04:54:51',NULL),(1,9,'image','hw_','2025-11-29 04:54:51',NULL),(1,10,'image','hw_','2025-11-29 04:54:51',NULL),(1,14,'image',NULL,'2025-11-29 04:54:51',NULL),(1,19,'image','hw_','2025-11-29 04:54:51',NULL),(1,25,'image','hw_','2025-11-29 04:54:51',NULL),(1,29,'image',NULL,'2025-11-29 04:54:52',NULL),(1,30,'image',NULL,'2025-11-29 04:54:52',NULL),(1,31,'image',NULL,'2025-11-29 04:54:52',NULL),(1,32,'image',NULL,'2025-11-29 04:54:52',NULL),(2,1,NULL,'CIM_PASD_','2025-11-29 04:54:51',NULL),(2,8,NULL,'hw_','2025-11-29 04:54:51',NULL),(2,9,NULL,'hw_','2025-11-29 04:54:51',NULL),(2,10,NULL,'hw_','2025-11-29 04:54:51',NULL),(2,11,NULL,NULL,'2025-11-29 04:54:51',NULL),(2,13,NULL,NULL,'2025-11-29 04:54:51',NULL),(2,14,NULL,NULL,'2025-11-29 04:54:51',NULL),(2,15,NULL,NULL,'2025-11-29 04:54:51',NULL),(2,16,NULL,'hw_','2025-11-29 04:54:51',NULL),(2,19,NULL,'hw_','2025-11-29 04:54:51',NULL),(2,22,NULL,NULL,'2025-11-29 04:54:51',NULL),(2,23,NULL,'hw_','2025-11-29 04:54:51',NULL),(2,24,NULL,'traits:','2025-11-29 04:54:51',NULL),(2,25,NULL,'hw_','2025-11-29 04:54:51',NULL),(2,26,NULL,NULL,'2025-11-29 04:54:52',NULL),(2,28,NULL,NULL,'2025-11-29 04:54:52',NULL),(2,29,NULL,NULL,'2025-11-29 04:54:52',NULL),(2,30,NULL,NULL,'2025-11-29 04:54:52',NULL),(2,31,NULL,NULL,'2025-11-29 04:54:52',NULL),(2,32,NULL,NULL,'2025-11-29 04:54:52',NULL),(2,33,NULL,'cinder_','2025-11-29 04:54:52',NULL),(3,1,NULL,'CIM_PASD_','2025-11-29 04:54:51',NULL),(3,2,NULL,'CIM_RASD_','2025-11-29 04:54:51',NULL),(3,3,NULL,'CIM_SASD_','2025-11-29 04:54:51',NULL),(3,4,NULL,'CIM_VSSD_','2025-11-29 04:54:51',NULL),(3,5,NULL,NULL,'2025-11-29 04:54:51',NULL),(3,6,NULL,NULL,'2025-11-29 04:54:51',NULL),(3,7,NULL,NULL,'2025-11-29 04:54:51',NULL),(3,12,NULL,'aggregate_instance_extra_specs:','2025-11-29 04:54:51',NULL),(4,1,NULL,'CIM_PASD_','2025-11-29 04:54:51',NULL),(4,2,NULL,'CIM_RASD_','2025-11-29 04:54:51',NULL),(4,3,NULL,'CIM_SASD_','2025-11-29 04:54:51',NULL),(4,4,NULL,'CIM_VSSD_','2025-11-29 04:54:51',NULL),(4,8,NULL,'hw:','2025-11-29 04:54:51',NULL),(4,9,NULL,'hw:','2025-11-29 04:54:51',NULL),(4,10,NULL,'hw:','2025-11-29 04:54:51',NULL),(4,12,NULL,'capabilities:','2025-11-29 04:54:51',NULL),(4,16,NULL,'hw:','2025-11-29 04:54:51',NULL),(4,17,NULL,NULL,'2025-11-29 04:54:51',NULL),(4,18,NULL,NULL,'2025-11-29 04:54:51',NULL),(4,19,NULL,'hw:','2025-11-29 04:54:51',NULL),(4,20,NULL,NULL,'2025-11-29 04:54:51',NULL),(4,21,NULL,NULL,'2025-11-29 04:54:51',NULL),(4,23,NULL,'hw:','2025-11-29 04:54:51',NULL),(4,24,NULL,'traits:','2025-11-29 04:54:51',NULL),(4,25,NULL,'hw:','2025-11-29 04:54:52',NULL),(5,1,'scheduler_hints',NULL,'2025-11-29 04:54:51',NULL),(5,30,'metadata',NULL,'2025-11-29 04:54:52',NULL),(5,31,'metadata',NULL,'2025-11-29 04:54:52',NULL),(5,32,'metadata',NULL,'2025-11-29 04:54:52',NULL),(6,30,NULL,NULL,'2025-11-29 04:54:52',NULL);
/*!40000 ALTER TABLE `metadef_namespace_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespaces`
--

DROP TABLE IF EXISTS `metadef_namespaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespaces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace` varchar(80) NOT NULL,
  `display_name` varchar(80) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `visibility` varchar(32) DEFAULT NULL,
  `protected` tinyint(1) DEFAULT NULL,
  `owner` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_namespaces_namespace` (`namespace`),
  KEY `ix_metadef_namespaces_owner` (`owner`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespaces`
--

LOCK TABLES `metadef_namespaces` WRITE;
/*!40000 ALTER TABLE `metadef_namespaces` DISABLE KEYS */;
INSERT INTO `metadef_namespaces` (`id`, `namespace`, `display_name`, `description`, `visibility`, `protected`, `owner`, `created_at`, `updated_at`) VALUES (1,'CIM::ProcessorAllocationSettingData','CIM Processor Allocation Setting','Properties related to the resource allocation settings of a processor (CPU) from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These are properties that identify processor setting data and may be specified to volume, image, host aggregate, flavor and Nova server as scheduler hint. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ProcessorAllocationSettingData.html.','public',1,'admin','2025-11-29 04:54:51',NULL),(2,'CIM::ResourceAllocationSettingData','CIM Resource Allocation Setting Data','Properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim) that represent settings specifically related to an allocated resource that are outside the scope of the CIM class typically used to represent the resource itself. These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ResourceAllocationSettingData.html.','public',1,'admin','2025-11-29 04:54:51',NULL),(3,'CIM::StorageAllocationSettingData','CIM Storage Allocation Setting Data','Properties related to the allocation of virtual storage from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_StorageAllocationSettingData.html.','public',1,'admin','2025-11-29 04:54:51',NULL),(4,'CIM::VirtualSystemSettingData','CIM Virtual System Setting Data','A set of virtualization specific properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim), which define the virtual aspects of a virtual system. These properties may be specified to host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_VirtualSystemSettingData.html.','public',1,'admin','2025-11-29 04:54:51',NULL),(5,'OS::Compute::AggregateDiskFilter','Disk Allocation per Host','Properties related to the Nova scheduler filter AggregateDiskFilter. Filters aggregate hosts based on the available disk space compared to the requested disk space. Hosts in the aggregate with not enough usable disk will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-11-29 04:54:51',NULL),(6,'OS::Compute::AggregateIoOpsFilter','IO Ops per Host','Properties related to the Nova scheduler filter AggregateIoOpsFilter. Filters aggregate hosts based on the number of instances currently changing state. Hosts in the aggregate with too many instances changing state will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-11-29 04:54:51',NULL),(7,'OS::Compute::AggregateNumInstancesFilter','Instances per Host','Properties related to the Nova scheduler filter AggregateNumInstancesFilter. Filters aggregate hosts by the number of running instances on it. Hosts in the aggregate with too many instances will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',0,'admin','2025-11-29 04:54:51',NULL),(8,'OS::Compute::CPUMode','CPU Mode','This provides the preferred CPU Model to be used when booting up a guest VM.','public',NULL,'admin','2025-11-29 04:54:51',NULL),(9,'OS::Compute::CPUPinning','CPU Pinning','This provides the preferred CPU pinning and CPU thread pinning policy to be used when pinning vCPU of the guest to pCPU of the host. See http://docs.openstack.org/admin-guide/compute-numa-cpu-pinning.html','public',1,'admin','2025-11-29 04:54:51',NULL),(10,'OS::Compute::GuestMemoryBacking','Guest Memory Backing','This provides the preferred backing option for guest RAM. Guest\'s memory can be backed by hugepages to limit TLB lookups. See also: https://wiki.openstack.org/wiki/VirtDriverGuestCPUMemoryPlacement','public',1,'admin','2025-11-29 04:54:51',NULL),(11,'OS::Compute::GuestShutdownBehavior','Shutdown Behavior','These properties allow modifying the shutdown behavior for stop, rescue, resize, and shelve operations.','public',1,'admin','2025-11-29 04:54:51',NULL),(12,'OS::Compute::HostCapabilities','Compute Host Capabilities','Hardware capabilities provided by the compute host. This provides the ability to fine tune the hardware specification required when an instance is requested. The ComputeCapabilitiesFilter should be enabled in the Nova scheduler to use these properties. When enabled, this filter checks that the capabilities provided by the compute host satisfy any extra specifications requested. Only hosts that can provide the requested capabilities will be eligible for hosting the instance.','public',1,'admin','2025-11-29 04:54:51',NULL),(13,'OS::Compute::Hypervisor','Hypervisor Selection','OpenStack Compute supports many hypervisors, although most installations use only one hypervisor. For installations with multiple supported hypervisors, you can schedule different hypervisors using the ImagePropertiesFilter. This filters compute nodes that satisfy any architecture, hypervisor type, or virtual machine mode properties specified on the instance\'s image properties.','public',1,'admin','2025-11-29 04:54:51',NULL),(14,'OS::Compute::InstanceData','Instance Config Data','Instances can perform self-configuration based on data made available to the running instance. These properties affect instance configuration.','public',1,'admin','2025-11-29 04:54:51',NULL),(15,'OS::Compute::LibvirtImage','libvirt Driver Options for Images','The libvirt Compute Driver Options for Glance Images.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-11-29 04:54:51',NULL),(16,'OS::Compute::Libvirt','libvirt Driver Options','The libvirt compute driver options.  \n\nThese are properties that affect the libvirt compute driver and may be specified on flavors and images.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-11-29 04:54:51',NULL),(17,'OS::Compute::Quota','Flavor Quota','Compute drivers may enable quotas on CPUs available to a VM, disk tuning, bandwidth I/O, and instance VIF traffic control.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-11-29 04:54:51',NULL),(18,'OS::Compute::RandomNumberGenerator','Random Number Generator','If a random-number generator device has been added to the instance through its image properties, the device can be enabled and configured.','public',1,'admin','2025-11-29 04:54:51',NULL),(19,'OS::Compute::VirtCPUTopology','Virtual CPU Topology','This provides the preferred socket/core/thread counts for the virtual CPU instance exposed to guests. This enables the ability to avoid hitting limitations on vCPU topologies that OS vendors place on their products. See also: https://opendev.org/openstack/nova-specs/src/branch/master/specs/juno/implemented/virt-driver-vcpu-topology.rst','public',1,'admin','2025-11-29 04:54:51',NULL),(20,'OS::Compute::VMwareFlavor','VMware Driver Options for Flavors','VMware Driver Options for Flavors may be used to customize and manage Nova Flavors. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-11-29 04:54:51',NULL),(21,'OS::Compute::VMwareQuotaFlavor','VMware Quota for Flavors','The VMware compute driver allows various compute quotas to be specified on flavors. When specified, the VMWare driver will ensure that the quota is enforced. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. For a list of hypervisors, see: https://wiki.openstack.org/wiki/HypervisorSupportMatrix. For flavor customization, see: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-11-29 04:54:51',NULL),(22,'OS::Compute::VMware','VMware Driver Options','The VMware compute driver options.  \n\nThese are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-11-29 04:54:51',NULL),(23,'OS::Compute::TPM','TPM Options','Configuration options for TPM','public',1,'admin','2025-11-29 04:54:51',NULL),(24,'OS::Compute::VTPM','Emulated Virtual TPM','Configuration options for Emulated Virtual TPM','public',1,'admin','2025-11-29 04:54:51',NULL),(25,'OS::Compute::Watchdog','Watchdog Behavior','Compute drivers may enable watchdog behavior over instances.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-11-29 04:54:51',NULL),(26,'OS::Compute::XenAPI','XenAPI Driver Options','The XenAPI compute driver options.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-11-29 04:54:52',NULL),(27,'OS::Glance::CommonImageProperties','Common Image Properties','When adding an image to Glance, you may specify some common image properties that may prove useful to consumers of your image.',NULL,1,'admin','2025-11-29 04:54:52',NULL),(28,'OS::Glance::Signatures','Image Signature Verification','Image signature verification allows the user to verify that an image has not been modified prior to booting the image.','public',0,'admin','2025-11-29 04:54:52',NULL),(29,'OS::OperatingSystem','Common Operating System Properties','Details of the operating system contained within this image as well as common operating system properties that can be set on a VM instance created from this image.',NULL,1,'admin','2025-11-29 04:54:52',NULL),(30,'OS::Software::DBMS','Database Software','A database is an organized collection of data. The data is typically organized to model aspects of reality in a way that supports processes requiring information. Database management systems are computer software applications that interact with the user, other applications, and the database itself to capture and analyze data. (http://en.wikipedia.org/wiki/Database)','public',1,'admin','2025-11-29 04:54:52',NULL),(31,'OS::Software::Runtimes','Runtime Environment','Software is written in a specific programming language and the language must execute within a runtime environment. The runtime environment provides an abstraction to utilizing a computer\'s processor, memory (RAM), and other system resources.','public',1,'admin','2025-11-29 04:54:52',NULL),(32,'OS::Software::WebServers','Web Servers','A web server is a computer system that processes requests via HTTP, the basic network protocol used to distribute information on the World Wide Web. The most common use of web servers is to host websites, but there are other uses such as gaming, data storage, running enterprise applications, handling email, FTP, or other web uses. (http://en.wikipedia.org/wiki/Web_server)','public',1,'admin','2025-11-29 04:54:52',NULL),(33,'OS::Cinder::Volumetype','Cinder Volume Type','The Cinder volume type configuration option. Volume type assignment provides a mechanism not only to provide scheduling to a specific storage back-end, but also can be used to specify specific information for a back-end storage device to act upon.','public',1,'admin','2025-11-29 04:54:52',NULL);
/*!40000 ALTER TABLE `metadef_namespaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_objects`
--

DROP TABLE IF EXISTS `metadef_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `description` text DEFAULT NULL,
  `required` text DEFAULT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_objects_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_objects_name` (`name`),
  CONSTRAINT `metadef_objects_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_objects`
--

LOCK TABLES `metadef_objects` WRITE;
/*!40000 ALTER TABLE `metadef_objects` DISABLE KEYS */;
INSERT INTO `metadef_objects` (`id`, `namespace_id`, `name`, `description`, `required`, `json_schema`, `created_at`, `updated_at`) VALUES (1,17,'CPU Limits','You can configure the CPU limits with control parameters.',NULL,'{\"quota:cpu_shares\": {\"title\": \"Quota: CPU Shares\", \"description\": \"Specifies the proportional weighted share for the domain. If this element is omitted, the service defaults to the OS provided defaults. There is no unit for the value; it is a relative measure based on the setting of other VMs. For example, a VM configured with value 2048 gets twice as much CPU time as a VM configured with value 1024.\", \"type\": \"integer\"}, \"quota:cpu_period\": {\"title\": \"Quota: CPU Period\", \"description\": \"Specifies the enforcement interval (unit: microseconds) for QEMU and LXC hypervisors. Within a period, each VCPU of the domain is not allowed to consume more than the quota worth of runtime. The value should be in range [1000, 1000000]. A period with value 0 means no value.\", \"type\": \"integer\", \"minimum\": 1000, \"maximum\": 1000000}, \"quota:cpu_quota\": {\"title\": \"Quota: CPU Quota\", \"description\": \"Specifies the maximum allowed bandwidth (unit: microseconds). A domain with a negative-value quota indicates that the domain has infinite bandwidth, which means that it is not bandwidth controlled. The value should be in range [1000, 18446744073709551] or less than 0. A quota with value 0 means no value. You can use this feature to ensure that all vCPUs run at the same speed.\", \"type\": \"integer\"}}','2025-11-29 04:54:51',NULL),(2,17,'Disk QoS','Using disk I/O quotas, you can set maximum disk write to 10 MB per second for a VM user.',NULL,'{\"quota:disk_read_bytes_sec\": {\"title\": \"Quota: Disk read bytes / sec\", \"description\": \"Sets disk I/O quota for disk read bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_read_iops_sec\": {\"title\": \"Quota: Disk read IOPS / sec\", \"description\": \"Sets disk I/O quota for disk read IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_write_bytes_sec\": {\"title\": \"Quota: Disk Write Bytes / sec\", \"description\": \"Sets disk I/O quota for disk write bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_write_iops_sec\": {\"title\": \"Quota: Disk Write IOPS / sec\", \"description\": \"Sets disk I/O quota for disk write IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_total_bytes_sec\": {\"title\": \"Quota: Disk Total Bytes / sec\", \"description\": \"Sets disk I/O quota for total disk bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_total_iops_sec\": {\"title\": \"Quota: Disk Total IOPS / sec\", \"description\": \"Sets disk I/O quota for disk total IOPS / sec.\", \"type\": \"integer\"}}','2025-11-29 04:54:51',NULL),(3,17,'Virtual Interface QoS','Bandwidth QoS tuning for instance virtual interfaces (VIFs) may be specified with these properties. Incoming and outgoing traffic can be shaped independently. If not specified, no quality of service (QoS) is applied on that traffic direction. So, if you want to shape only the network\'s incoming traffic, use inbound only (and vice versa). The OpenStack Networking service abstracts the physical implementation of the network, allowing plugins to configure and manage physical resources. Virtual Interfaces (VIF) in the logical model are analogous to physical network interface cards (NICs). VIFs are typically owned a managed by an external service; for instance when OpenStack Networking is used for building OpenStack networks, VIFs would be created, owned, and managed in Nova. VIFs are connected to OpenStack Networking networks via ports. A port is analogous to a port on a network switch, and it has an administrative state. When a VIF is attached to a port the OpenStack Networking API creates an attachment object, which specifies the fact that a VIF with a given identifier is plugged into the port.',NULL,'{\"quota:vif_inbound_average\": {\"title\": \"Quota: VIF Inbound Average\", \"description\": \"Network Virtual Interface (VIF) inbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_inbound_burst\": {\"title\": \"Quota: VIF Inbound Burst\", \"description\": \"Network Virtual Interface (VIF) inbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_inbound_peak\": {\"title\": \"Quota: VIF Inbound Peak\", \"description\": \"Network Virtual Interface (VIF) inbound peak in kilobytes per second. Specifies maximum rate at which an interface can receive data.\", \"type\": \"integer\"}, \"quota:vif_outbound_average\": {\"title\": \"Quota: VIF Outbound Average\", \"description\": \"Network Virtual Interface (VIF) outbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_outbound_burst\": {\"title\": \"Quota: VIF Outbound Burst\", \"description\": \"Network Virtual Interface (VIF) outbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_outbound_peak\": {\"title\": \"Quota: VIF Outbound Peak\", \"description\": \"Network Virtual Interface (VIF) outbound peak in kilobytes per second. Specifies maximum rate at which an interface can send data.\", \"type\": \"integer\"}}','2025-11-29 04:54:51',NULL),(4,30,'MySQL','MySQL is an object-relational database management system (ORDBMS). The MySQL development project has made its source code available under the terms of the GNU General Public License, as well as under a variety of proprietary agreements. MySQL was owned and sponsored by a single for-profit firm, the Swedish company MySQL AB, now owned by Oracle Corporation. MySQL is a popular choice of database for use in web applications, and is a central component of the widely used LAMP open source web application software stack (and other \'AMP\' stacks). (http://en.wikipedia.org/wiki/MySQL)',NULL,'{\"sw_database_mysql_version\": {\"title\": \"Version\", \"description\": \"The specific version of MySQL.\", \"type\": \"string\"}, \"sw_database_mysql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"The configured TCP/IP port which MySQL listens for incoming connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 3606}, \"sw_database_mysql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"root\"}}','2025-11-29 04:54:52',NULL),(5,30,'PostgreSQL','PostgreSQL, often simply \'Postgres\', is an object-relational database management system (ORDBMS) with an emphasis on extensibility and standards-compliance. PostgreSQL is cross-platform and runs on many operating systems. (http://en.wikipedia.org/wiki/PostgreSQL)',NULL,'{\"sw_database_postgresql_version\": {\"title\": \"Version\", \"description\": \"The specific version of PostgreSQL.\", \"type\": \"string\"}, \"sw_database_postgresql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which PostgreSQL is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_postgresql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"postgres\"}}','2025-11-29 04:54:52',NULL),(6,30,'SQL Server','Microsoft SQL Server is a relational database management system developed by Microsoft. There are at least a dozen different editions of Microsoft SQL Server aimed at different audiences and for workloads ranging from small single-machine applications to large Internet-facing applications with many concurrent users. Its primary query languages are T-SQL and ANSI SQL. (http://en.wikipedia.org/wiki/Microsoft_SQL_Server)',NULL,'{\"sw_database_sqlserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Microsoft SQL Server.\", \"type\": \"string\"}, \"sw_database_sqlserver_edition\": {\"title\": \"Edition\", \"description\": \"SQL Server is available in multiple editions, with different feature sets and targeting different users.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Datacenter\", \"Enterprise\", \"Standard\", \"Web\", \"Business Intelligence\", \"Workgroup\", \"Express\", \"Compact (SQL CE)\", \"Developer\", \"Embedded (SSEE)\", \"Express\", \"Fast Track\", \"LocalDB\", \"Parallel Data Warehouse (PDW)\", \"Business Intelligence\", \"Datawarehouse Appliance Edition\"]}, \"sw_database_sqlserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which SQL Server is to listen for connections from client applications. The default SQL Server port is 1433, and client ports are assigned a random value between 1024 and 5000.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1433}, \"sw_database_postsqlserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"sa\"}}','2025-11-29 04:54:52',NULL),(7,30,'Oracle','Oracle Database (commonly referred to as Oracle RDBMS or simply as Oracle) is an object-relational database management system produced and marketed by Oracle Corporation. (http://en.wikipedia.org/wiki/Oracle_Database)',NULL,'{\"sw_database_oracle_version\": {\"title\": \"Version\", \"description\": \"The specific version of Oracle.\", \"type\": \"string\"}, \"sw_database_oracle_edition\": {\"title\": \"Edition\", \"description\": \"Over and above the different versions of the Oracle database management software developed over time, Oracle Corporation subdivides its product into varying editions.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Enterprise\", \"Standard\", \"Standard Edition One\", \"Express (XE)\", \"Workgroup\", \"Lite\"]}, \"sw_database_oracle_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Oracle is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1521}}','2025-11-29 04:54:52',NULL),(8,30,'DB2','IBM DB2 is a family of database server products developed by IBM. These products all support the relational model, but in recent years some products have been extended to support object-relational features and non-relational structures, in particular XML. (http://en.wikipedia.org/wiki/IBM_DB2)',NULL,'{\"sw_database_db2_version\": {\"title\": \"Version\", \"description\": \"The specific version of DB2.\", \"type\": \"string\"}, \"sw_database_db2_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which DB2 is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_db2_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-11-29 04:54:52',NULL),(9,30,'MongoDB','MongoDB is a cross-platform document-oriented database. Classified as a NoSQL database, MongoDB uses JSON-like documents with dynamic schemas (MongoDB calls the format BSON), making the integration of data in certain types of applications easier and faster. Released under a combination of the GNU Affero General Public License and the Apache License, MongoDB is free and open-source software. (http://en.wikipedia.org/wiki/MongoDB)',NULL,'{\"sw_database_mongodb_version\": {\"title\": \"Version\", \"description\": \"The specific version of MongoDB.\", \"type\": \"string\"}, \"sw_database_mongodb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which MongoDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 27017}, \"sw_database_mongodb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-11-29 04:54:52',NULL),(10,30,'Couchbase Server','Couchbase Server, originally known as Membase, is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications. These applications must serve many concurrent users by creating, storing, retrieving, aggregating, manipulating and presenting data. In support of these kinds of application needs, Couchbase is designed to provide easy-to-scale key-value or document access with low latency and high sustained throughput. (http://en.wikipedia.org/wiki/Couchbase_Server)',NULL,'{\"sw_database_couchbaseserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Couchbase Server.\", \"type\": \"string\"}, \"sw_database_couchbaseserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Couchbase is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 11211}, \"sw_database_couchbaseserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-11-29 04:54:52',NULL),(11,30,'Redis','Redis is a data structure server (NoSQL). It is open-source, networked, in-memory, and stores keys with optional durability. The development of Redis has been sponsored by Pivotal Software since May 2013; before that, it was sponsored by VMware. The name Redis means REmote DIctionary Server. (http://en.wikipedia.org/wiki/Redis)',NULL,'{\"sw_database_redis_version\": {\"title\": \"Version\", \"description\": \"The specific version of Redis.\", \"type\": \"string\"}, \"sw_database_redis_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Redis is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 6379}, \"sw_database_redis_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-11-29 04:54:52',NULL),(12,30,'CouchDB','Apache CouchDB, commonly referred to as CouchDB, is an open source NoSQL database. It is a NoSQL database that uses JSON to store data, JavaScript as its query language using MapReduce, and HTTP for an API. One of its distinguishing features is multi-master replication. CouchDB was first released in 2005 and later became an Apache project in 2008. (http://en.wikipedia.org/wiki/CouchDB)',NULL,'{\"sw_database_couchdb_version\": {\"title\": \"Version\", \"description\": \"The specific version of CouchDB.\", \"type\": \"string\"}, \"sw_database_couchdb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which CouchDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5984}, \"sw_database_couchdb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-11-29 04:54:52',NULL),(13,30,'Apache Cassandra','Apache Cassandra is an open source distributed NoSQL database management system designed to handle large amounts of data across many commodity servers, providing high availability with no single point of failure. (http://en.wikipedia.org/wiki/Apache_Cassandra)',NULL,'{\"sw_database_cassandra_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache Cassandra.\", \"type\": \"string\"}, \"sw_database_cassandra_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Cassandra is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 9160}, \"sw_database_cassandra_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"cassandra\"}}','2025-11-29 04:54:52',NULL),(14,30,'HBase','HBase is an open source, non-relational (NoSQL), distributed database modeled after Google\'s BigTable and written in Java. It is developed as part of Apache Software Foundation\'s Apache Hadoop project and runs on top of HDFS (Hadoop Distributed Filesystem), providing BigTable-like capabilities for Hadoop. (http://en.wikipedia.org/wiki/Apache_HBase)',NULL,'{\"sw_database_hbase_version\": {\"title\": \"Version\", \"description\": \"The specific version of HBase.\", \"type\": \"string\"}}','2025-11-29 04:54:52',NULL),(15,30,'Hazlecast','In computing, Hazelcast is an in-memory open source software data grid based on Java. By having multiple nodes form a cluster, data is evenly distributed among the nodes. This allows for horizontal scaling both in terms of available storage space and processing power. Backups are also distributed in a similar fashion to other nodes, based on configuration, thereby protecting against single node failure. (http://en.wikipedia.org/wiki/Hazelcast)',NULL,'{\"sw_database_hazlecast_version\": {\"title\": \"Version\", \"description\": \"The specific version of Hazlecast.\", \"type\": \"string\"}, \"sw_database_hazlecast_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Hazlecast is to listen for connections between members.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5701}}','2025-11-29 04:54:52',NULL),(16,31,'PHP','PHP is a server-side scripting language designed for web development but also used as a general-purpose programming language. PHP code can be simply mixed with HTML code, or it can be used in combination with various templating engines and web frameworks. PHP code is usually processed by a PHP interpreter, which is usually implemented as a web server\'s native module or a Common Gateway Interface (CGI) executable. After the PHP code is interpreted and executed, the web server sends resulting output to its client, usually in form of a part of the generated web page – for example, PHP code can generate a web page\'s HTML code, an image, or some other data. PHP has also evolved to include a command-line interface (CLI) capability and can be used in standalone graphical applications. (http://en.wikipedia.org/wiki/PHP)',NULL,'{\"sw_runtime_php_version\": {\"title\": \"Version\", \"description\": \"The specific version of PHP.\", \"type\": \"string\"}}','2025-11-29 04:54:52',NULL),(17,31,'Python','Python is a widely used general-purpose, high-level programming language. Its design philosophy emphasizes code readability, and its syntax allows programmers to express concepts in fewer lines of code than would be possible in languages such as C++ or Java. The language provides constructs intended to enable clear programs on both a small and large scale. Python supports multiple programming paradigms, including object-oriented, imperative and functional programming or procedural styles. It features a dynamic type system and automatic memory management and has a large and comprehensive standard library. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_python_version\": {\"title\": \"Version\", \"description\": \"The specific version of python.\", \"type\": \"string\"}}','2025-11-29 04:54:52',NULL),(18,31,'Java','Java is a functional computer programming language that is concurrent, class-based, object-oriented, and specifically designed to have as few implementation dependencies as possible. It is intended to let application developers write once, run anywhere (WORA), meaning that code that runs on one platform does not need to be recompiled to run on another. Java applications are typically compiled to bytecode that can run on any Java virtual machine (JVM) regardless of computer architecture. (http://en.wikipedia.org/wiki/Java_(programming_language))',NULL,'{\"sw_runtime_java_version\": {\"title\": \"Version\", \"description\": \"The specific version of Java.\", \"type\": \"string\"}}','2025-11-29 04:54:52',NULL),(19,31,'Ruby','Ruby is a dynamic, reflective, object-oriented, general-purpose programming language. It was designed and developed in the mid-1990s by Yukihiro Matsumoto in Japan. According to its authors, Ruby was influenced by Perl, Smalltalk, Eiffel, Ada, and Lisp. It supports multiple programming paradigms, including functional, object-oriented, and imperative. It also has a dynamic type system and automatic memory management. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_ruby_version\": {\"title\": \"Version\", \"description\": \"The specific version of Ruby.\", \"type\": \"string\"}}','2025-11-29 04:54:52',NULL),(20,31,'Perl','Perl is a family of high-level, general-purpose, interpreted, dynamic programming languages. The languages in this family include Perl 5 and Perl 6. Though Perl is not officially an acronym, there are various backronyms in use, the most well-known being Practical Extraction and Reporting Language (http://en.wikipedia.org/wiki/Perl)',NULL,'{\"sw_runtime_perl_version\": {\"title\": \"Version\", \"description\": \"The specific version of Perl.\", \"type\": \"string\"}}','2025-11-29 04:54:52',NULL),(21,32,'Apache HTTP Server','The Apache HTTP Server, colloquially called Apache, is a Web server application notable for playing a key role in the initial growth of the World Wide Web. Apache is developed and maintained by an open community of developers under the auspices of the Apache Software Foundation. Most commonly used on a Unix-like system, the software is available for a wide variety of operating systems, including Unix, FreeBSD, Linux, Solaris, Novell NetWare, OS X, Microsoft Windows, OS/2, TPF, OpenVMS and eComStation. Released under the Apache License, Apache is open-source software. (http://en.wikipedia.org/wiki/Apache_HTTP_Server)',NULL,'{\"sw_webserver_apache_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache.\", \"type\": \"string\"}, \"sw_webserver_apache_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_apache_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-11-29 04:54:52',NULL),(22,32,'Nginx','Nginx (pronounced \'engine-x\') is an open source reverse proxy server for HTTP, HTTPS, SMTP, POP3, and IMAP protocols, as well as a load balancer, HTTP cache, and a web server (origin server). The nginx project started with a strong focus on high concurrency, high performance and low memory usage. It is licensed under the 2-clause BSD-like license and it runs on Linux, BSD variants, Mac OS X, Solaris, AIX, HP-UX, as well as on other *nix flavors. It also has a proof of concept port for Microsoft Windows. (http://en.wikipedia.org/wiki/Nginx)',NULL,'{\"sw_webserver_nginx_version\": {\"title\": \"Version\", \"description\": \"The specific version of Nginx.\", \"type\": \"string\"}, \"sw_webserver_nginx_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_nginx_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-11-29 04:54:52',NULL),(23,32,'IIS','Internet Information Services (IIS, formerly Internet Information Server) is an extensible web server created by Microsoft. IIS supports HTTP, HTTPS, FTP, FTPS, SMTP and NNTP. IIS is not turned on by default when Windows is installed. The IIS Manager is accessed through the Microsoft Management Console or Administrative Tools in the Control Panel. (http://en.wikipedia.org/wiki/Internet_Information_Services)',NULL,'{\"sw_webserver_iis_version\": {\"title\": \"Version\", \"description\": \"The specific version of IIS.\", \"type\": \"string\"}, \"sw_webserver_iis_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_iis_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-11-29 04:54:52',NULL);
/*!40000 ALTER TABLE `metadef_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_properties`
--

DROP TABLE IF EXISTS `metadef_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_properties_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_properties_name` (`name`),
  CONSTRAINT `metadef_properties_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_properties`
--

LOCK TABLES `metadef_properties` WRITE;
/*!40000 ALTER TABLE `metadef_properties` DISABLE KEYS */;
INSERT INTO `metadef_properties` (`id`, `namespace_id`, `name`, `json_schema`, `created_at`, `updated_at`) VALUES (1,1,'InstructionSet','{\"title\": \"Instruction Set\", \"description\": \"Identifies the instruction set of the processor within a processor architecture.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86:i386\", \"x86:i486\", \"x86:i586\", \"x86:i686\", \"x86:64\", \"IA-64:IA-64\", \"AS/400:TIMI\", \"Power:Power_2.03\", \"Power:Power_2.04\", \"Power:Power_2.05\", \"Power:Power_2.06\", \"S/390:ESA/390\", \"S/390:z/Architecture\", \"S/390:z/Architecture_2\", \"PA-RISC:PA-RISC_1.0\", \"PA-RISC:PA-RISC_2.0\", \"ARM:A32\", \"ARM:A64\", \"MIPS:MIPS_I\", \"MIPS:MIPS_II\", \"MIPS:MIPS_III\", \"MIPS:MIPS_IV\", \"MIPS:MIPS_V\", \"MIPS:MIPS32\", \"MIPS64:MIPS64\", \"Alpha:Alpha\", \"SPARC:SPARC_V7\", \"SPARC:SPARC_V8\", \"SPARC:SPARC_V9\", \"SPARC:SPARC_JPS1\", \"SPARC:UltraSPARC2005\", \"SPARC:UltraSPARC2007\", \"68k:68000\", \"68k:68010\", \"68k:68020\", \"68k:68030\", \"68k:68040\", \"68k:68060\"]}','2025-11-29 04:54:51',NULL),(2,1,'ProcessorArchitecture','{\"title\": \"Processor Architecture\", \"description\": \"Identifies the processor architecture of the processor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"IA-64\", \"AS/400\", \"Power\", \"S/390\", \"PA-RISC\", \"ARM\", \"MIPS\", \"Alpha\", \"SPARC\", \"68k\"]}','2025-11-29 04:54:51',NULL),(3,1,'InstructionSetExtensionName','{\"title\": \"Instruction Set Extension\", \"description\": \"Identifies the instruction set extensions of the processor within a processor architecture.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"x86:3DNow\", \"x86:3DNowExt\", \"x86:ABM\", \"x86:AES\", \"x86:AVX\", \"x86:AVX2\", \"x86:BMI\", \"x86:CX16\", \"x86:F16C\", \"x86:FSGSBASE\", \"x86:LWP\", \"x86:MMX\", \"x86:PCLMUL\", \"x86:RDRND\", \"x86:SSE2\", \"x86:SSE3\", \"x86:SSSE3\", \"x86:SSE4A\", \"x86:SSE41\", \"x86:SSE42\", \"x86:FMA3\", \"x86:FMA4\", \"x86:XOP\", \"x86:TBM\", \"x86:VT-d\", \"x86:VT-x\", \"x86:EPT\", \"x86:SVM\", \"PA-RISC:MAX\", \"PA-RISC:MAX2\", \"ARM:DSP\", \"ARM:Jazelle-DBX\", \"ARM:Thumb\", \"ARM:Thumb-2\", \"ARM:ThumbEE)\", \"ARM:VFP\", \"ARM:NEON\", \"ARM:TrustZone\", \"MIPS:MDMX\", \"MIPS:MIPS-3D\", \"Alpha:BWX\", \"Alpha:FIX\", \"Alpha:CIX\", \"Alpha:MVI\"]}}','2025-11-29 04:54:51',NULL),(4,2,'Address','{\"title\": \"Address\", \"description\": \"The address of the resource.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(5,2,'AddressOnParent','{\"title\": \"Address On Parent\", \"description\": \"Describes the address of this resource in the context of the Parent.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(6,2,'AllocationUnits','{\"title\": \"Allocation Units\", \"description\": \"This property specifies the units of allocation used by the Reservation and Limit properties.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(7,2,'AutomaticAllocation','{\"title\": \"Automatic Allocation\", \"description\": \"This property specifies if the resource will be automatically allocated.\", \"type\": \"boolean\"}','2025-11-29 04:54:51',NULL),(8,2,'AutomaticDeallocation','{\"title\": \"Automatic Deallocation\", \"description\": \"This property specifies if the resource will be automatically de-allocated.\", \"type\": \"boolean\"}','2025-11-29 04:54:51',NULL),(9,2,'ConsumerVisibility','{\"title\": \"Consumer Visibility\", \"description\": \"Describes the consumers visibility to the allocated resource.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Passed-Through\", \"Virtualized\", \"Not represented\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-11-29 04:54:51',NULL),(10,2,'Limit','{\"title\": \"Limit\", \"description\": \"This property specifies the upper bound, or maximum amount of resource that will be granted for this allocation.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(11,2,'MappingBehavior','{\"title\": \"Mapping Behavior\", \"description\": \"Specifies how this resource maps to underlying resources. If the HostResource array contains any entries, this property reflects how the resource maps to those specific resources.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Not Supported\", \"Dedicated\", \"Soft Affinity\", \"Hard Affinity\", \"DMTF Reserved\", \"Vendor Reserved\"]}','2025-11-29 04:54:51',NULL),(12,2,'OtherResourceType','{\"title\": \"Other Resource Type\", \"description\": \"A string that describes the resource type when a well defined value is not available and ResourceType has the value \'Other\'.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(13,2,'Parent','{\"title\": \"Parent\", \"description\": \"The Parent of the resource.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(14,2,'PoolID','{\"title\": \"Pool ID\", \"description\": \"This property specifies which ResourcePool the resource is currently allocated from, or which ResourcePool the resource will be allocated from when the allocation occurs.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(15,2,'Reservation','{\"title\": \"Reservation\", \"description\": \"This property specifies the amount of resource guaranteed to be available for this allocation.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(16,2,'ResourceSubType','{\"title\": \"Resource Sub Type\", \"description\": \"A string describing an implementation specific sub-type for this resource.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(17,2,'ResourceType','{\"title\": \"Resource Type\", \"description\": \"The type of resource this allocation setting represents.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Other\", \"Computer System\", \"Processor\", \"Memory\", \"IDE Controller\", \"Parallel SCSI HBA\", \"FC HBA\", \"iSCSI HBA\", \"IB HCA\", \"Ethernet Adapter\", \"Other Network Adapter\", \"I/O Slot\", \"I/O Device\", \"Floppy Drive\", \"CD Drive\", \"DVD drive\", \"Disk Drive\", \"Tape Drive\", \"Storage Extent\", \"Other storage device\", \"Serial port\", \"Parallel port\", \"USB Controller\", \"Graphics controller\", \"IEEE 1394 Controller\", \"Partitionable Unit\", \"Base Partitionable Unit\", \"Power\", \"Cooling Capacity\", \"Ethernet Switch Port\", \"Logical Disk\", \"Storage Volume\", \"Ethernet Connection\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-11-29 04:54:51',NULL),(18,2,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"This property specifies the quantity of resources presented to the consumer.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(19,2,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(20,2,'Weight','{\"title\": \"Weight\", \"description\": \"This property specifies a relative priority for this allocation in relation to other allocations from the same ResourcePool.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(21,2,'Connection','{\"title\": \"Connection\", \"description\": \"The thing to which this resource is connected.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(22,2,'HostResource','{\"title\": \"Host Resource\", \"description\": \"This property exposes specific assignment of resources.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(23,3,'Access','{\"title\": \"Access\", \"description\": \"Access describes whether the allocated storage extent is 1 (readable), 2 (writeable), or 3 (both).\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Readable\", \"Writeable\", \"Read/Write Supported\", \"DMTF Reserved\"]}','2025-11-29 04:54:51',NULL),(24,3,'HostExtentName','{\"title\": \"Host Extent Name\", \"description\": \"A unique identifier for the host extent.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(25,3,'HostExtentNameFormat','{\"title\": \"Host Extent Name Format\", \"description\": \"The HostExtentNameFormat property identifies the format that is used for the value of the HostExtentName property.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"SNVM\", \"NAA\", \"EUI64\", \"T10VID\", \"OS Device Name\", \"DMTF Reserved\"]}','2025-11-29 04:54:51',NULL),(26,3,'HostExtentNameNamespace','{\"title\": \"Host Extent Name Namespace\", \"description\": \"If the host extent is a SCSI volume, then the preferred source for SCSI volume names is SCSI VPD Page 83 responses.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"VPD83Type3\", \"VPD83Type2\", \"VPD83Type1\", \"VPD80\", \"NodeWWN\", \"SNVM\", \"OS Device Namespace\", \"DMTF Reserved\"]}','2025-11-29 04:54:51',NULL),(27,3,'HostExtentStartingAddress','{\"title\": \"Host Extent Starting Address\", \"description\": \"The HostExtentStartingAddress property identifies the starting address on the host storage extent identified by the value of the HostExtentName property that is used for the allocation of the virtual storage extent.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(28,3,'HostResourceBlockSize','{\"title\": \"Host Resource Block Size\", \"description\": \"Size in bytes of the blocks that are allocated at the host as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(29,3,'Limit','{\"title\": \"Limit\", \"description\": \"The maximum amount of blocks that will be granted for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(30,3,'OtherHostExtentNameFormat','{\"title\": \"Other Host Extent Name Format\", \"description\": \"A string describing the format of the HostExtentName property if the value of the HostExtentNameFormat property is 1 (Other).\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(31,3,'OtherHostExtentNameNamespace','{\"title\": \"Other Host Extent Name Namespace\", \"description\": \"A string describing the namespace of the HostExtentName property if the value of the HostExtentNameNamespace matches 1 (Other).\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(32,3,'Reservation','{\"title\": \"Reservation\", \"description\": \"The amount of blocks that are guaranteed to be available for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(33,3,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"Number of blocks that are presented to the consumer.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(34,3,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(35,3,'VirtualResourceBlockSize','{\"title\": \"Virtual Resource Block Size\", \"description\": \"Size in bytes of the blocks that are presented to the consumer as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(36,4,'AutomaticRecoveryAction','{\"title\": \"Automatic Recovery Action\", \"description\": \"Action to take for the virtual system when the software executed by the virtual system fails.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart\", \"Revert to snapshot\", \"DMTF Reserved\"]}','2025-11-29 04:54:51',NULL),(37,4,'AutomaticShutdownAction','{\"title\": \"Automatic Shutdown Action\", \"description\": \"Action to take for the virtual system when the host is shut down.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Turn Off\", \"Save state\", \"Shutdown\", \"DMTF Reserved\"]}','2025-11-29 04:54:51',NULL),(38,4,'AutomaticStartupAction','{\"title\": \"Automatic Startup Action\", \"description\": \"Action to take for the virtual system when the host is started.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart if previously active\", \"Always startup\", \"DMTF Reserved\"]}','2025-11-29 04:54:51',NULL),(39,4,'AutomaticStartupActionDelay','{\"title\": \"Automatic Startup Action Delay\", \"description\": \"Delay applicable to startup action.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(40,4,'AutomaticStartupActionSequenceNumber','{\"title\": \"Automatic Startup Action Sequence Number\", \"description\": \"Number indicating the relative sequence of virtual system activation when the host system is started.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(41,4,'ConfigurationDataRoot','{\"title\": \"Configuration Data Root\", \"description\": \"Filepath of a directory where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(42,4,'ConfigurationFile','{\"title\": \"Configuration File\", \"description\": \"Filepath of a file where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(43,4,'ConfigurationID','{\"title\": \"Configuration ID\", \"description\": \"Unique id of the virtual system configuration.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(44,4,'CreationTime','{\"title\": \"Creation Time\", \"description\": \"Time when the virtual system configuration was created.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(45,4,'LogDataRoot','{\"title\": \"Log Data Root\", \"description\": \"Filepath of a directory where log information about the virtual system is stored.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(46,4,'RecoveryFile','{\"title\": \"Recovery File\", \"description\": \"Filepath of a file where recovery relateded information of the virtual system is stored.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(47,4,'SnapshotDataRoot','{\"title\": \"Snapshot Data Root\", \"description\": \"Filepath of a directory where information about virtual system snapshots is stored.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(48,4,'SuspendDataRoot','{\"title\": \"Suspend Data Root\", \"description\": \"Filepath of a directory where suspend related information about the virtual system is stored.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(49,4,'SwapFileDataRoot','{\"title\": \"Swap File Data Root\", \"description\": \"Filepath of a directory where swapfiles of the virtual system are stored.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(50,4,'VirtualSystemIdentifier','{\"title\": \"Virtual System Identifier\", \"description\": \"VirtualSystemIdentifier shall reflect a unique name for the system as it is used within the virtualization platform.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(51,4,'VirtualSystemType','{\"title\": \"Virtual System Type\", \"description\": \"VirtualSystemType shall reflect a particular type of virtual system.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(52,4,'Notes','{\"title\": \"Notes\", \"description\": \"End-user supplied notes that are related to the virtual system.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(53,5,'disk_allocation_ratio','{\"title\": \"Disk Subscription Ratio\", \"description\": \"Allows the host to be under and over subscribed for the amount of disk space requested for an instance. A ratio greater than 1.0 allows for over subscription (hosts may have less usable disk space than requested). A ratio less than 1.0 allows for under subscription.\", \"type\": \"number\", \"readonly\": false}','2025-11-29 04:54:51',NULL),(54,6,'max_io_ops_per_host','{\"title\": \"Maximum IO Operations per Host\", \"description\": \"Prevents hosts in the aggregate that have this many or more instances currently in build, resize, snapshot, migrate, rescue or unshelve to be scheduled for new instances.\", \"type\": \"integer\", \"readonly\": false, \"default\": 8, \"minimum\": 1}','2025-11-29 04:54:51',NULL),(55,7,'max_instances_per_host','{\"title\": \"Max Instances Per Host\", \"description\": \"Maximum number of instances allowed to run on a host in the aggregate.\", \"type\": \"integer\", \"readonly\": false, \"minimum\": 0}','2025-11-29 04:54:51',NULL),(56,8,'cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"Type of CPU Mode.\", \"type\": \"string\", \"enum\": [\"none\", \"host-model\", \"host-passthrough\", \"custom\"]}','2025-11-29 04:54:51',NULL),(57,9,'cpu_policy','{\"title\": \"CPU Pinning policy\", \"description\": \"Type of CPU pinning policy.\", \"type\": \"string\", \"enum\": [\"shared\", \"dedicated\"]}','2025-11-29 04:54:51',NULL),(58,9,'cpu_thread_policy','{\"title\": \"CPU Thread Pinning Policy.\", \"description\": \"Type of CPU thread pinning policy.\", \"type\": \"string\", \"enum\": [\"isolate\", \"prefer\", \"require\"]}','2025-11-29 04:54:51',NULL),(59,10,'mem_page_size','{\"title\": \"Size of memory page\", \"description\": \"Page size to be used for Guest memory backing. Value can be specified as <number><unit> (i.e.: 2MB, 1GB) or \'any\', \'small\', \'large\'. If this property is set in Image metadata then only \'any\' and \'large\' values are accepted in Flavor metadata by Nova API.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(60,11,'os_shutdown_timeout','{\"title\": \"Shutdown timeout\", \"description\": \"By default, guests will be given 60 seconds to perform a graceful shutdown. After that, the VM is powered off.  This property allows overriding the amount of time (unit: seconds) to allow a guest OS to cleanly shut down before power off. A value of 0 (zero) means the guest will be powered off immediately with no opportunity for guest OS clean-up.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-29 04:54:51',NULL),(61,12,'cpu_info:vendor','{\"title\": \"Vendor\", \"description\": \"Specifies the CPU manufacturer.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Intel\", \"AMD\"]}','2025-11-29 04:54:51',NULL),(62,12,'cpu_info:model','{\"title\": \"Model\", \"description\": \"Specifies the CPU model. Use this property to ensure that your vm runs on a specific cpu model.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Conroe\", \"Core2Duo\", \"Penryn\", \"Nehalem\", \"Westmere\", \"SandyBridge\", \"IvyBridge\", \"Haswell\", \"Broadwell\", \"Delhi\", \"Seoul\", \"Abu Dhabi\", \"Interlagos\", \"Kabini\", \"Valencia\", \"Zurich\", \"Budapest\", \"Barcelona\", \"Suzuka\", \"Shanghai\", \"Istanbul\", \"Lisbon\", \"Magny-Cours\", \"Valencia\", \"Cortex-A57\", \"Cortex-A53\", \"Cortex-A12\", \"Cortex-A17\", \"Cortex-A15\", \"Coretx-A7\", \"X-Gene\"]}','2025-11-29 04:54:51',NULL),(63,12,'cpu_info:arch','{\"title\": \"Architecture\", \"description\": \"Specifies the CPU architecture. Use this property to specify the architecture supported by the hypervisor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"x86_64\", \"i686\", \"ia64\", \"ARMv8-A\", \"ARMv7-A\"]}','2025-11-29 04:54:51',NULL),(64,12,'cpu_info:topology:cores','{\"title\": \"cores\", \"description\": \"Number of cores.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-11-29 04:54:51',NULL),(65,12,'cpu_info:topology:threads','{\"title\": \"threads\", \"description\": \"Number of threads.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-11-29 04:54:51',NULL),(66,12,'cpu_info:topology:sockets','{\"title\": \"sockets\", \"description\": \"Number of sockets.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-11-29 04:54:51',NULL),(67,12,'cpu_info:features','{\"title\": \"Features\", \"description\": \"Specifies CPU flags/features. Using this property you can specify the required set of instructions supported by a vm.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"fpu\", \"vme\", \"de\", \"pse\", \"tsc\", \"msr\", \"pae\", \"mce\", \"cx8\", \"apic\", \"sep\", \"mtrr\", \"pge\", \"mca\", \"cmov\", \"pat\", \"pse36\", \"pn\", \"clflush\", \"dts\", \"acpi\", \"mmx\", \"fxsr\", \"sse\", \"sse2\", \"ss\", \"ht\", \"tm\", \"ia64\", \"pbe\", \"syscall\", \"mp\", \"nx\", \"mmxext\", \"fxsr_opt\", \"pdpe1gb\", \"rdtscp\", \"lm\", \"3dnowext\", \"3dnow\", \"arch_perfmon\", \"pebs\", \"bts\", \"rep_good\", \"nopl\", \"xtopology\", \"tsc_reliable\", \"nonstop_tsc\", \"extd_apicid\", \"amd_dcm\", \"aperfmperf\", \"eagerfpu\", \"nonstop_tsc_s3\", \"pni\", \"pclmulqdq\", \"dtes64\", \"monitor\", \"ds_cpl\", \"vmx\", \"smx\", \"est\", \"tm2\", \"ssse3\", \"cid\", \"fma\", \"cx16\", \"xtpr\", \"pdcm\", \"pcid\", \"dca\", \"sse4_1\", \"sse4_2\", \"x2apic\", \"movbe\", \"popcnt\", \"tsc_deadline_timer\", \"aes\", \"xsave\", \"avx\", \"f16c\", \"rdrand\", \"hypervisor\", \"rng\", \"rng_en\", \"ace\", \"ace_en\", \"ace2\", \"ace2_en\", \"phe\", \"phe_en\", \"pmm\", \"pmm_en\", \"lahf_lm\", \"cmp_legacy\", \"svm\", \"extapic\", \"cr8_legacy\", \"abm\", \"sse4a\", \"misalignsse\", \"3dnowprefetch\", \"osvw\", \"ibs\", \"xop\", \"skinit\", \"wdt\", \"lwp\", \"fma4\", \"tce\", \"nodeid_msr\", \"tbm\", \"topoext\", \"perfctr_core\", \"perfctr_nb\", \"bpext\", \"perfctr_l2\", \"mwaitx\", \"ida\", \"arat\", \"cpb\", \"epb\", \"pln\", \"pts\", \"dtherm\", \"hw_pstate\", \"proc_feedback\", \"hwp\", \"hwp_notify\", \"hwp_act_window\", \"hwp_epp\", \"hwp_pkg_req\", \"intel_pt\", \"tpr_shadow\", \"vnmi\", \"flexpriority\", \"ept\", \"vpid\", \"npt\", \"lbrv\", \"svm_lock\", \"nrip_save\", \"tsc_scale\", \"vmcb_clean\", \"flushbyasid\", \"decodeassists\", \"pausefilter\", \"pfthreshold\", \"vmmcall\", \"fsgsbase\", \"tsc_adjust\", \"bmi1\", \"hle\", \"avx2\", \"smep\", \"bmi2\", \"erms\", \"invpcid\", \"rtm\", \"cqm\", \"mpx\", \"avx512f\", \"rdseed\", \"adx\", \"smap\", \"pcommit\", \"clflushopt\", \"clwb\", \"avx512pf\", \"avx512er\", \"avx512cd\", \"sha_ni\", \"xsaveopt\", \"xsavec\", \"xgetbv1\", \"xsaves\", \"cqm_llc\", \"cqm_occup_llc\", \"clzero\"]}}','2025-11-29 04:54:51',NULL),(68,13,'hypervisor_type','{\"title\": \"Hypervisor Type\", \"description\": \"Hypervisor type required by the image. Used with the ImagePropertiesFilter. \\n\\n Baremetal - physical provisioning. hyperv - Microsoft\\u00ae hyperv. KVM - Kernel-based Virtual Machine. LXC - Linux Containers (through libvirt). powervm - IBM\\u00ae PowerVM\\u00ae. QEMU - Quick EMUlator. UML - User Mode Linux. vmware - VMware\\u00ae vsphere. VZ - Virtuozzo OS Containers and Virtual Machines (through libvirt). For more information, see: https://docs.openstack.org/nova/latest/admin/configuration/hypervisors.html\", \"type\": \"string\", \"enum\": [\"baremetal\", \"hyperv\", \"kvm\", \"lxc\", \"powervm\", \"qemu\", \"uml\", \"vmware\", \"vz\", \"xen\"]}','2025-11-29 04:54:51',NULL),(69,13,'vm_mode','{\"title\": \"VM Mode\", \"description\": \"The virtual machine mode. This represents the host/guest ABI (application binary interface) used for the virtual machine. Used with the ImagePropertiesFilter. \\n\\n hvm \\u2014 Fully virtualized - This is the virtual machine mode (vm_mode) used by QEMU and KVM. \\n\\n xen - Xen 3.0 paravirtualized. \\n\\n uml \\u2014 User Mode Linux paravirtualized. \\n\\n exe \\u2014 Executables in containers. This is the mode used by LXC.\", \"type\": \"string\", \"enum\": [\"hvm\", \"xen\", \"uml\", \"exe\"]}','2025-11-29 04:54:51',NULL),(70,14,'img_config_drive','{\"title\": \"Config Drive\", \"description\": \"This property specifies whether or not Nova should use a config drive when booting the image. Mandatory means that Nova will always use a config drive when booting the image. OpenStack can be configured to write metadata to a special configuration drive that will be attached to the instance when it boots. The instance can retrieve any information from the config drive. One use case for the config drive is to pass network configuration information to the instance. See also: http://docs.openstack.org/user-guide/cli_config_drive.html\", \"type\": \"string\", \"enum\": [\"optional\", \"mandatory\"]}','2025-11-29 04:54:51',NULL),(71,14,'os_require_quiesce','{\"title\": \"Require Quiescent File system\", \"description\": \"This property specifies whether or not the filesystem must be quiesced during snapshot processing. For volume backed and image backed snapshots, yes means that snapshotting is aborted when quiescing fails, whereas, no means quiescing will be skipped and snapshot processing will continue after the quiesce failure.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-11-29 04:54:51',NULL),(72,15,'hw_cdrom_bus','{\"title\": \"CD-ROM Bus\", \"description\": \"Specifies the type of disk controller to attach CD-ROM devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-11-29 04:54:51',NULL),(73,15,'hw_disk_bus','{\"title\": \"Disk Bus\", \"description\": \"Specifies the type of disk controller to attach disk devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-11-29 04:54:51',NULL),(74,15,'hw_firmware_type','{\"title\": \"Firmware Type\", \"description\": \"Specifies whether the image should be booted with a legacy BIOS or with UEFI.\", \"type\": \"string\", \"enum\": [\"bios\", \"uefi\"]}','2025-11-29 04:54:51',NULL),(75,15,'hw_rng_model','{\"title\": \"Random Number Generator Device\", \"description\": \"Adds a random-number generator device to the image\'s instances. The cloud administrator can enable and control device behavior by configuring the instance\'s flavor. By default: The generator device is disabled. /dev/random is used as the default entropy source. To specify a physical HW RNG device, use the following option in the nova.conf file: rng_dev_path=/dev/hwrng\", \"type\": \"string\", \"default\": \"virtio\"}','2025-11-29 04:54:51',NULL),(76,15,'hw_machine_type','{\"title\": \"Machine Type\", \"description\": \"Enables booting an ARM system using the specified machine type. By default, if an ARM image is used and its type is not specified, Compute uses vexpress-a15 (for ARMv7) or virt (for AArch64) machine types. Valid types can be viewed by using the virsh capabilities command (machine types are displayed in the machine tag).\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(77,15,'hw_scsi_model','{\"title\": \"SCSI Model\", \"description\": \"Enables the use of VirtIO SCSI (virtio-scsi) to provide block device access for compute instances; by default, instances use VirtIO Block (virtio-blk). VirtIO SCSI is a para-virtualized SCSI controller device that provides improved scalability and performance, and supports advanced SCSI hardware.\", \"type\": \"string\", \"default\": \"virtio-scsi\"}','2025-11-29 04:54:51',NULL),(78,15,'hw_video_model','{\"title\": \"Video Model\", \"description\": \"The graphic device model presented to the guest. hw_video_model=none disables the graphics device in the guest and should generally be used when using gpu passthrough.\", \"type\": \"string\", \"enum\": [\"vga\", \"cirrus\", \"vmvga\", \"xen\", \"qxl\", \"virtio\", \"gop\", \"none\", \"bochs\"]}','2025-11-29 04:54:51',NULL),(79,15,'hw_video_ram','{\"title\": \"Max Video Ram\", \"description\": \"Maximum RAM (unit: MB) for the video image. Used only if a hw_video:ram_max_mb value has been set in the flavor\'s extra_specs and that value is higher than the value set in hw_video_ram.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-29 04:54:51',NULL),(80,15,'os_command_line','{\"title\": \"Kernel Command Line\", \"description\": \"The kernel command line to be used by the libvirt driver, instead of the default. For linux containers (LXC), the value is used as arguments for initialization. This key is valid only for Amazon kernel, ramdisk, or machine images (aki, ari, or ami).\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(81,15,'os_type','{\"title\": \"OS Type\", \"description\": \"The operating system installed on the image. The libvirt driver contains logic that takes different actions depending on the value of the os_type parameter of the image. For example, for os_type=windows images, it creates a FAT32-based swap partition instead of a Linux swap partition, and it limits the injected host name to less than 16 characters.\", \"type\": \"string\", \"enum\": [\"linux\", \"windows\"]}','2025-11-29 04:54:51',NULL),(82,15,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor configuration. libvirt driver options: KVM and QEMU: e1000, ne2k_pci, pcnet, rtl8139, spapr-vlan, virtio, e1000e and vmxnet3. Xen: e1000, netfront, ne2k_pci, pcnet, and rtl8139.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"ne2k_pci\", \"netfront\", \"pcnet\", \"rtl8139\", \"spapr-vlan\", \"virtio\", \"vmxnet3\"]}','2025-11-29 04:54:51',NULL),(83,15,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-29 04:54:51',NULL),(84,15,'hw_pmu','{\"title\": \"Virtual Performance Monitoring Unit\", \"description\": \"Controls emulation of a vPMU in the guest. To reduce latency in realtime workloads disable the vPMU by setting hw_pmu=false\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-29 04:54:51',NULL),(85,15,'hw_qemu_guest_agent','{\"title\": \"QEMU Guest Agent\", \"description\": \"This is a background process which helps management applications execute guest OS level commands. For example, freezing and thawing filesystems, entering suspend. However, guest agent (GA) is not bullet proof, and hostile guest OS can send spurious replies.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-11-29 04:54:51',NULL),(86,15,'hw_pointer_model','{\"title\": \"Pointer Model\", \"description\": \"Input devices allow interaction with a graphical framebuffer. For example to provide a graphic tablet for absolute cursor movement. Currently only supported by the KVM/QEMU hypervisor configuration and VNC or SPICE consoles must be enabled.\", \"type\": \"string\", \"enum\": [\"usbtablet\"]}','2025-11-29 04:54:51',NULL),(87,15,'img_hide_hypervisor_id','{\"title\": \"Hide hypervisor id\", \"description\": \"Enables hiding the host hypervisor signature in the guest OS.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-11-29 04:54:51',NULL),(88,16,'serial_port_count','{\"title\": \"Serial Port Count\", \"description\": \"Specifies the count of serial ports that should be provided. If hw:serial_port_count is not set in the flavor\'s extra_specs, then any count is permitted. If hw:serial_port_count is set, then this provides the default serial port count. It is permitted to override the default serial port count, but only with a lower value.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-29 04:54:51',NULL),(89,16,'boot_menu','{\"title\": \"Boot Menu\", \"description\": \"If true, enables the BIOS bootmenu. In cases where both the image metadata and Extra Spec are set, the Extra Spec setting is used. This allows for flexibility in setting/overriding the default behavior as needed.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-29 04:54:51',NULL),(90,16,'mem_encryption','{\"title\": \"Hardware Memory Encryption\", \"description\": \"Enables encryption of guest memory at the hardware level, if there are compute hosts available which support this. See https://docs.openstack.org/nova/latest/admin/configuration/hypervisor-kvm.html#amd-sev-secure-encrypted-virtualization for details.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-29 04:54:51',NULL),(91,18,'hw_rng:allowed','{\"title\": \"Random Number Generator Allowed\", \"description\": \"\", \"type\": \"boolean\"}','2025-11-29 04:54:51',NULL),(92,18,'hw_rng:rate_bytes','{\"title\": \"Random number generator limits.\", \"description\": \"Allowed amount of bytes that the guest can read from the host\'s entropy per period.\", \"type\": \"integer\"}','2025-11-29 04:54:51',NULL),(93,18,'hw_rng:rate_period','{\"title\": \"Random number generator read period.\", \"description\": \"Duration of the read period in milliseconds.\", \"type\": \"integer\"}','2025-11-29 04:54:51',NULL),(94,19,'cpu_sockets','{\"title\": \"vCPU Sockets\", \"description\": \"Preferred number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-11-29 04:54:51',NULL),(95,19,'cpu_cores','{\"title\": \"vCPU Cores\", \"description\": \"Preferred number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-11-29 04:54:51',NULL),(96,19,'cpu_threads','{\"title\": \" vCPU Threads\", \"description\": \"Preferred number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-11-29 04:54:51',NULL),(97,19,'cpu_max_sockets','{\"title\": \"Max vCPU Sockets\", \"description\": \"Maximum number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-11-29 04:54:51',NULL),(98,19,'cpu_max_cores','{\"title\": \"Max vCPU Cores\", \"description\": \"Maximum number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-11-29 04:54:51',NULL),(99,19,'cpu_max_threads','{\"title\": \"Max vCPU Threads\", \"description\": \"Maximum number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-11-29 04:54:51',NULL),(100,20,'vmware:hw_version','{\"title\": \"VMware Hardware Version\", \"description\": \"Specifies the hardware version VMware uses to create images. If the hardware version needs to be compatible with a cluster version, for backward compatibility or other circumstances, the vmware:hw_version key specifies a virtual machine hardware version. In the event that a cluster has mixed host version types, the key will enable the vCenter to place the cluster on the correct host.\", \"type\": \"string\", \"enum\": [\"vmx-13\", \"vmx-11\", \"vmx-10\", \"vmx-09\", \"vmx-08\", \"vmx-07\", \"vmx-04\", \"vmx-03\"]}','2025-11-29 04:54:51',NULL),(101,20,'vmware:storage_policy','{\"title\": \"VMware Storage Policy\", \"description\": \"Specifies the storage policy to be applied for newly created instance. If not provided, the default storage policy specified in config file will be used. If Storage Policy Based Management (SPBM) is not enabled in config file, this value won\'t be used.\", \"type\": \"string\"}','2025-11-29 04:54:51',NULL),(102,21,'quota:cpu_limit','{\"title\": \"Quota: CPU Limit\", \"description\": \"Specifies the upper limit for CPU allocation in MHz. This parameter ensures that a machine never uses more than the defined amount of CPU time. It can be used to enforce a limit on the machine\'s CPU performance. The value should be a numerical value in MHz. If zero is supplied then the cpu_limit is unlimited.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-29 04:54:51',NULL),(103,21,'quota:cpu_reservation','{\"title\": \"Quota: CPU Reservation Limit\", \"description\": \"Specifies the guaranteed minimum CPU reservation in MHz. This means that if needed, the machine will definitely get allocated the reserved amount of CPU cycles. The value should be a numerical value in MHz.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-29 04:54:51',NULL),(104,22,'img_linked_clone','{\"title\": \"Linked Clone\", \"description\": \"By default, the VMware compute driver creates linked clones when possible (though this can be turned off by the operator). You can use this image property on a per-image basis to control whether virtual machines booted from the image are treated as full clones (value: false) or linked clones (value: true). Please refer to VMware documentation for information about full vs. linked clones.\", \"type\": \"boolean\"}','2025-11-29 04:54:51',NULL),(105,22,'vmware_adaptertype','{\"title\": \"Disk Adapter Type\", \"description\": \"The virtual SCSI or IDE controller used by the hypervisor.\", \"type\": \"string\", \"enum\": [\"lsiLogic\", \"lsiLogicsas\", \"paraVirtual\", \"busLogic\", \"ide\"], \"default\": \"lsiLogic\"}','2025-11-29 04:54:51',NULL),(106,22,'vmware_disktype','{\"title\": \"Disk Provisioning Type\", \"description\": \"When performing operations such as creating a virtual disk, cloning, or migrating, the disk provisioning type may be specified. Please refer to VMware documentation for more.\", \"type\": \"string\", \"enum\": [\"streamOptimized\", \"sparse\", \"preallocated\"], \"default\": \"preallocated\"}','2025-11-29 04:54:51',NULL),(107,22,'vmware_ostype','{\"title\": \"OS Type\", \"description\": \"A VMware GuestID which describes the operating system installed in the image. This value is passed to the hypervisor when creating a virtual machine. If not specified, the key defaults to otherGuest. See thinkvirt.com.\", \"type\": \"string\", \"enum\": [\"asianux3_64Guest\", \"asianux3Guest\", \"asianux4_64Guest\", \"asianux4Guest\", \"asianux5_64Guest\", \"asianux7_64Guest\", \"centos64Guest\", \"centosGuest\", \"centos6Guest\", \"centos6_64Guest\", \"centos7_64Guest\", \"coreos64Guest\", \"darwin10_64Guest\", \"darwin10Guest\", \"darwin11_64Guest\", \"darwin11Guest\", \"darwin12_64Guest\", \"darwin13_64Guest\", \"darwin14_64Guest\", \"darwin15_64Guest\", \"darwin16_64Guest\", \"darwin64Guest\", \"darwinGuest\", \"debian4_64Guest\", \"debian4Guest\", \"debian5_64Guest\", \"debian5Guest\", \"debian6_64Guest\", \"debian6Guest\", \"debian7_64Guest\", \"debian7Guest\", \"debian8_64Guest\", \"debian8Guest\", \"debian9_64Guest\", \"debian9Guest\", \"debian10_64Guest\", \"debian10Guest\", \"dosGuest\", \"eComStation2Guest\", \"eComStationGuest\", \"fedora64Guest\", \"fedoraGuest\", \"freebsd64Guest\", \"freebsdGuest\", \"genericLinuxGuest\", \"mandrakeGuest\", \"mandriva64Guest\", \"mandrivaGuest\", \"netware4Guest\", \"netware5Guest\", \"netware6Guest\", \"nld9Guest\", \"oesGuest\", \"openServer5Guest\", \"openServer6Guest\", \"opensuse64Guest\", \"opensuseGuest\", \"oracleLinux64Guest\", \"oracleLinuxGuest\", \"oracleLinux6Guest\", \"oracleLinux6_64Guest\", \"oracleLinux7_64Guest\", \"os2Guest\", \"other24xLinux64Guest\", \"other24xLinuxGuest\", \"other26xLinux64Guest\", \"other26xLinuxGuest\", \"other3xLinux64Guest\", \"other3xLinuxGuest\", \"otherGuest\", \"otherGuest64\", \"otherLinux64Guest\", \"otherLinuxGuest\", \"redhatGuest\", \"rhel2Guest\", \"rhel3_64Guest\", \"rhel3Guest\", \"rhel4_64Guest\", \"rhel4Guest\", \"rhel5_64Guest\", \"rhel5Guest\", \"rhel6_64Guest\", \"rhel6Guest\", \"rhel7_64Guest\", \"rhel7Guest\", \"sjdsGuest\", \"sles10_64Guest\", \"sles10Guest\", \"sles11_64Guest\", \"sles11Guest\", \"sles12_64Guest\", \"sles12Guest\", \"sles64Guest\", \"slesGuest\", \"solaris10_64Guest\", \"solaris10Guest\", \"solaris11_64Guest\", \"solaris6Guest\", \"solaris7Guest\", \"solaris8Guest\", \"solaris9Guest\", \"turboLinux64Guest\", \"turboLinuxGuest\", \"ubuntu64Guest\", \"ubuntuGuest\", \"unixWare7Guest\", \"vmkernel5Guest\", \"vmkernel6Guest\", \"vmkernel65Guest\", \"vmkernelGuest\", \"vmwarePhoton64Guest\", \"win2000AdvServGuest\", \"win2000ProGuest\", \"win2000ServGuest\", \"win31Guest\", \"win95Guest\", \"win98Guest\", \"windows7_64Guest\", \"windows7Guest\", \"windows7Server64Guest\", \"windows8_64Guest\", \"windows8Guest\", \"windows8Server64Guest\", \"windows9_64Guest\", \"windows9Guest\", \"windows9Server64Guest\", \"windowsHyperVGuest\", \"winLonghorn64Guest\", \"winLonghornGuest\", \"winMeGuest\", \"winNetBusinessGuest\", \"winNetDatacenter64Guest\", \"winNetDatacenterGuest\", \"winNetEnterprise64Guest\", \"winNetEnterpriseGuest\", \"winNetStandard64Guest\", \"winNetStandardGuest\", \"winNetWebGuest\", \"winNTGuest\", \"winVista64Guest\", \"winVistaGuest\", \"winXPHomeGuest\", \"winXPPro64Guest\", \"winXPProGuest\"], \"default\": \"otherGuest\"}','2025-11-29 04:54:51',NULL),(108,22,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor. VMware driver supported options: e1000, e1000e, VirtualE1000, VirtualE1000e, VirtualPCNet32, and VirtualVmxnet.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"VirtualE1000\", \"VirtualE1000e\", \"VirtualPCNet32\", \"VirtualVmxnet\", \"VirtualVmxnet3\"], \"default\": \"e1000\"}','2025-11-29 04:54:51',NULL),(109,22,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-29 04:54:51',NULL),(110,23,'tpm_model','{\"title\": \"TPM model\", \"description\": \"TPM model to use. Option CRB is only valid for TPM version 2.0. Defaults to TIS.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"TIS\", \"CRB\"], \"default\": \"TIS\"}','2025-11-29 04:54:51',NULL),(111,24,'COMPUTE_SECURITY_TPM_1_2','{\"title\": \"Virtual TPM Version 1.2 Support\", \"description\": \"Enables virtual TPM version 1.2.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-11-29 04:54:51',NULL),(112,24,'COMPUTE_SECURITY_TPM_2_0','{\"title\": \"Virtual TPM Version 2.0 Support\", \"description\": \"Enables virtual TPM version 2.0.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-11-29 04:54:51',NULL),(113,25,'watchdog_action','{\"title\": \"Watchdog Action\", \"description\": \"For the libvirt driver, you can enable and set the behavior of a virtual hardware watchdog device for each flavor. Watchdog devices keep an eye on the guest server, and carry out the configured action, if the server hangs. The watchdog uses the i6300esb device (emulating a PCI Intel 6300ESB). If hw_watchdog_action is not specified, the watchdog is disabled. Watchdog behavior set using a specific image\'s properties will override behavior set using flavors.\", \"type\": \"string\", \"enum\": [\"disabled\", \"reset\", \"poweroff\", \"pause\", \"none\"]}','2025-11-29 04:54:52',NULL),(114,26,'auto_disk_config','{\"title\": \"Disk Adapter Type\", \"description\": \"If true, the root partition on the disk is automatically resized before the instance boots. This value is only taken into account by the Compute service when using a Xen-based hypervisor with the XenAPI driver. The Compute service will only attempt to resize if there is a single partition on the image, and only if the partition is in ext3 or ext4 format.\", \"type\": \"boolean\"}','2025-11-29 04:54:52',NULL),(115,27,'kernel_id','{\"title\": \"Kernel ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the kernel when booting an AMI-style image.\"}','2025-11-29 04:54:52',NULL),(116,27,'ramdisk_id','{\"title\": \"Ramdisk ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the ramdisk when booting an AMI-style image.\"}','2025-11-29 04:54:52',NULL),(117,27,'instance_uuid','{\"title\": \"Instance ID\", \"type\": \"string\", \"description\": \"Metadata which can be used to record which instance this image is associated with. (Informational only, does not create an instance snapshot.)\"}','2025-11-29 04:54:52',NULL),(118,27,'architecture','{\"title\": \"CPU Architecture\", \"description\": \"The CPU architecture that must be supported by the hypervisor. For example, x86_64, arm, or ppc64. Run uname -m to get the architecture of a machine. We strongly recommend using the architecture data vocabulary defined by the libosinfo project for this purpose.\", \"type\": \"string\"}','2025-11-29 04:54:52',NULL),(119,27,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-11-29 04:54:52',NULL),(120,27,'hw_cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"This specifies the CPU Mode for the guest vm\", \"type\": \"string\"}','2025-11-29 04:54:52',NULL),(121,27,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-11-29 04:54:52',NULL),(122,27,'description','{\"title\": \"Image description\", \"description\": \"A human-readable string describing this image.\", \"type\": \"string\"}','2025-11-29 04:54:52',NULL),(123,27,'cinder_encryption_key_id','{\"title\": \"Cinder Encryption Key ID\", \"description\": \"Identifier in the OpenStack Key Management Service for the encryption key for the Block Storage Service to use when mounting a volume created from this image\", \"type\": \"string\"}','2025-11-29 04:54:52',NULL),(124,27,'cinder_encryption_key_deletion_policy','{\"title\": \"Cinder Encryption Key Deletion Policy\", \"description\": \"States the condition under which the Image Service will delete the object associated with the \'cinder_encryption_key_id\' image property.  If this property is missing, the Image Service will take no action\", \"type\": \"string\", \"enum\": [\"on_image_deletion\", \"do_not_delete\"]}','2025-11-29 04:54:52',NULL),(125,28,'img_signature','{\"title\": \"Image Signature\", \"description\": \"The signature of the image data encoded in base64 format.\", \"type\": \"string\"}','2025-11-29 04:54:52',NULL),(126,28,'img_signature_certificate_uuid','{\"title\": \"Image Signature Certificate UUID\", \"description\": \"The UUID used to retrieve the certificate from the key manager.\", \"type\": \"string\"}','2025-11-29 04:54:52',NULL),(127,28,'img_signature_hash_method','{\"title\": \"Image Signature Hash Method\", \"description\": \"The hash method used in creating the signature.\", \"type\": \"string\", \"enum\": [\"SHA-224\", \"SHA-256\", \"SHA-384\", \"SHA-512\"]}','2025-11-29 04:54:52',NULL),(128,28,'img_signature_key_type','{\"title\": \"Image Signature Key Type\", \"description\": \"The key type used in creating the signature.\", \"type\": \"string\", \"enum\": [\"RSA-PSS\", \"DSA\", \"ECC_SECT571K1\", \"ECC_SECT409K1\", \"ECC_SECT571R1\", \"ECC_SECT409R1\", \"ECC_SECP521R1\", \"ECC_SECP384R1\"]}','2025-11-29 04:54:52',NULL),(129,29,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-11-29 04:54:52',NULL),(130,29,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-11-29 04:54:52',NULL),(131,29,'os_admin_user','{\"title\": \"OS Admin User\", \"description\": \"The name of the user with admin privileges.\", \"type\": \"string\"}','2025-11-29 04:54:52',NULL),(132,33,'img_volume_type','{\"title\": \"Image Volume Type\", \"description\": \"Specifies the volume type that should be applied during new volume creation with a image. This value is passed to Cinder when creating a new volume. Priority of volume type related parameters are 1.volume_type(via API or CLI), 2.cinder_img_volume_type, 3.default_volume_type(via cinder.conf). If not specified, volume_type or default_volume_type will be referred based on their priority.\", \"type\": \"string\"}','2025-11-29 04:54:52',NULL);
/*!40000 ALTER TABLE `metadef_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_resource_types`
--

DROP TABLE IF EXISTS `metadef_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_resource_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `protected` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_resource_types_name` (`name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_resource_types`
--

LOCK TABLES `metadef_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_resource_types` (`id`, `name`, `protected`, `created_at`, `updated_at`) VALUES (1,'OS::Cinder::Volume',1,'2025-11-29 04:54:51',NULL),(2,'OS::Glance::Image',1,'2025-11-29 04:54:51',NULL),(3,'OS::Nova::Aggregate',1,'2025-11-29 04:54:51',NULL),(4,'OS::Nova::Flavor',1,'2025-11-29 04:54:51',NULL),(5,'OS::Nova::Server',1,'2025-11-29 04:54:51',NULL),(6,'OS::Trove::Instance',1,'2025-11-29 04:54:52',NULL);
/*!40000 ALTER TABLE `metadef_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_tags`
--

DROP TABLE IF EXISTS `metadef_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_tags_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_tags_name` (`name`),
  CONSTRAINT `metadef_tags_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_tags`
--

LOCK TABLES `metadef_tags` WRITE;
/*!40000 ALTER TABLE `metadef_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadef_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_info`
--

DROP TABLE IF EXISTS `task_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_info` (
  `task_id` varchar(36) NOT NULL,
  `input` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  CONSTRAINT `task_info_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_info`
--

LOCK TABLES `task_info` WRITE;
/*!40000 ALTER TABLE `task_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` varchar(36) NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `image_id` varchar(36) DEFAULT NULL,
  `request_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_tasks_deleted` (`deleted`),
  KEY `ix_tasks_owner` (`owner`),
  KEY `ix_tasks_status` (`status`),
  KEY `ix_tasks_type` (`type`),
  KEY `ix_tasks_updated_at` (`updated_at`),
  KEY `ix_tasks_image_id` (`image_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `keystone`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `keystone` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `keystone`;

--
-- Table structure for table `access_rule`
--

DROP TABLE IF EXISTS `access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(64) DEFAULT NULL,
  `path` varchar(128) DEFAULT NULL,
  `method` varchar(16) DEFAULT NULL,
  `external_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_rule_external_id_key` (`external_id`),
  UNIQUE KEY `duplicate_access_rule_for_user_constraint` (`user_id`,`service`,`path`,`method`),
  KEY `user_id` (`user_id`),
  KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_rule`
--

LOCK TABLES `access_rule` WRITE;
/*!40000 ALTER TABLE `access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_token`
--

DROP TABLE IF EXISTS `access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_token` (
  `id` varchar(64) NOT NULL,
  `access_secret` varchar(64) NOT NULL,
  `authorizing_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  `role_ids` text NOT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_access_token_authorizing_user_id` (`authorizing_user_id`),
  KEY `ix_access_token_consumer_id` (`consumer_id`),
  CONSTRAINT `access_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_token`
--

LOCK TABLES `access_token` WRITE;
/*!40000 ALTER TABLE `access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('29e87d24a316'),('e25ffa003242');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential`
--

DROP TABLE IF EXISTS `application_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential` (
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `secret_hash` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `system` varchar(64) DEFAULT NULL,
  `unrestricted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `duplicate_app_cred_constraint` (`user_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential`
--

LOCK TABLES `application_credential` WRITE;
/*!40000 ALTER TABLE `application_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_access_rule`
--

DROP TABLE IF EXISTS `application_credential_access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_access_rule` (
  `application_credential_id` int(11) NOT NULL,
  `access_rule_id` int(11) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`access_rule_id`),
  KEY `access_rule_id` (`access_rule_id`),
  CONSTRAINT `application_credential_access_rule_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE,
  CONSTRAINT `application_credential_access_rule_ibfk_2` FOREIGN KEY (`access_rule_id`) REFERENCES `access_rule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_access_rule`
--

LOCK TABLES `application_credential_access_rule` WRITE;
/*!40000 ALTER TABLE `application_credential_access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_role`
--

DROP TABLE IF EXISTS `application_credential_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_role` (
  `application_credential_id` int(11) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`role_id`),
  CONSTRAINT `application_credential_role_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_role`
--

LOCK TABLES `application_credential_role` WRITE;
/*!40000 ALTER TABLE `application_credential_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assignment` (
  `type` enum('UserProject','GroupProject','UserDomain','GroupDomain') NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  KEY `ix_actor_id` (`actor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserProject','032b6b592a214ec7a5eba078e1abe4d6','3f8e46ff816a4d8a90bfa4b396b35aaf','44abaf4ea9c1440382f1d995f42e7926',0),('UserProject','032b6b592a214ec7a5eba078e1abe4d6','3f8e46ff816a4d8a90bfa4b396b35aaf','eaf49411c8e94ce9954baa2063538d27',0),('UserProject','04b5bf8225a04cd1bb1be73757e80ca2','3f8e46ff816a4d8a90bfa4b396b35aaf','44abaf4ea9c1440382f1d995f42e7926',0),('UserProject','04b5bf8225a04cd1bb1be73757e80ca2','3f8e46ff816a4d8a90bfa4b396b35aaf','eaf49411c8e94ce9954baa2063538d27',0),('UserProject','32c33e44159f4ccfa6e2fd4f81a8ad4f','3f8e46ff816a4d8a90bfa4b396b35aaf','44abaf4ea9c1440382f1d995f42e7926',0),('UserProject','32c33e44159f4ccfa6e2fd4f81a8ad4f','3f8e46ff816a4d8a90bfa4b396b35aaf','eaf49411c8e94ce9954baa2063538d27',0),('UserProject','6f2298292b104ff58856a40039289e85','3f8e46ff816a4d8a90bfa4b396b35aaf','44abaf4ea9c1440382f1d995f42e7926',0),('UserProject','6f2298292b104ff58856a40039289e85','3f8e46ff816a4d8a90bfa4b396b35aaf','eaf49411c8e94ce9954baa2063538d27',0),('UserProject','767285b605aa44dbbd3cd889c1cbfdd3','3f8e46ff816a4d8a90bfa4b396b35aaf','44abaf4ea9c1440382f1d995f42e7926',0),('UserProject','767285b605aa44dbbd3cd889c1cbfdd3','3f8e46ff816a4d8a90bfa4b396b35aaf','eaf49411c8e94ce9954baa2063538d27',0),('UserProject','8f59cc412ff44a13a0e77a17c47b7815','3f8e46ff816a4d8a90bfa4b396b35aaf','44abaf4ea9c1440382f1d995f42e7926',0),('UserProject','8f59cc412ff44a13a0e77a17c47b7815','3f8e46ff816a4d8a90bfa4b396b35aaf','eaf49411c8e94ce9954baa2063538d27',0),('UserProject','bebcae54c3b640c4bae666c40d95c5f8','3f8e46ff816a4d8a90bfa4b396b35aaf','25d3eb68b6004924a409a7b0aafff112',0),('UserProject','bebcae54c3b640c4bae666c40d95c5f8','3f8e46ff816a4d8a90bfa4b396b35aaf','eaf49411c8e94ce9954baa2063538d27',0),('UserProject','da42e74ed6d04223b9f1be411e89508b','389b14b74e3c4a1184dca228ba013067','eaf49411c8e94ce9954baa2063538d27',0),('UserProject','da42e74ed6d04223b9f1be411e89508b','389b14b74e3c4a1184dca228ba013067','eb2d5d6ae10d4b7d931400510112d430',0),('UserProject','da42e74ed6d04223b9f1be411e89508b','cec69ecdc21e48bcb26757a96bef3fdc','eaf49411c8e94ce9954baa2063538d27',0),('UserProject','e21ade2dfdf54a9bbdbf2d31f14c738c','3f8e46ff816a4d8a90bfa4b396b35aaf','44abaf4ea9c1440382f1d995f42e7926',0),('UserProject','e21ade2dfdf54a9bbdbf2d31f14c738c','3f8e46ff816a4d8a90bfa4b396b35aaf','eaf49411c8e94ce9954baa2063538d27',0),('UserProject','ea591be1497d41ec8a8129de91669cc4','3f8e46ff816a4d8a90bfa4b396b35aaf','44abaf4ea9c1440382f1d995f42e7926',0),('UserProject','ea591be1497d41ec8a8129de91669cc4','3f8e46ff816a4d8a90bfa4b396b35aaf','eaf49411c8e94ce9954baa2063538d27',0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_register`
--

DROP TABLE IF EXISTS `config_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_register` (
  `type` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_register`
--

LOCK TABLES `config_register` WRITE;
/*!40000 ALTER TABLE `config_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `config_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumer`
--

DROP TABLE IF EXISTS `consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumer` (
  `id` varchar(64) NOT NULL,
  `description` varchar(64) DEFAULT NULL,
  `secret` varchar(64) NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumer`
--

LOCK TABLES `consumer` WRITE;
/*!40000 ALTER TABLE `consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credential` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `key_hash` varchar(64) NOT NULL,
  `encrypted_blob` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint` (
  `id` varchar(64) NOT NULL,
  `legacy_endpoint_id` varchar(64) DEFAULT NULL,
  `interface` varchar(8) NOT NULL,
  `service_id` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `region_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_endpoint_region_id` (`region_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `endpoint_service_id_fkey` FOREIGN KEY (`service_id`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_endpoint_region_id` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
INSERT INTO `endpoint` (`id`, `legacy_endpoint_id`, `interface`, `service_id`, `url`, `extra`, `enabled`, `region_id`) VALUES ('00ad463ed55f4fad84644ea6179be7a4',NULL,'public','fca5cd71603a47988c84cffca6d293da','https://neutron-public-openstack.apps-crc.testing','{\"name\": \"neutron\"}',1,'regionOne'),('203abbf353ce4a7981d3f7aeca67cd51',NULL,'internal','88536fd423fc451fa7cd5034c6a3faa4','https://barbican-internal.openstack.svc:9311','{\"name\": \"barbican\"}',1,'regionOne'),('31271a43eb214c289d21661cfb0a8edc',NULL,'internal','32633c25ec034a2d95a4463e4ed8f258','https://manila-internal.openstack.svc:8786/v2','{\"name\": \"manilav2\"}',1,'regionOne'),('3dfdd93d72ab4ab7a8a7c3783a604fde',NULL,'public','4388c15aa6e848dc89a9c4b07bcc0e14','https://cinder-public-openstack.apps-crc.testing/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('464fc394bc11461185e1f81b860912bd',NULL,'public','1cc78f051fec4f1197ad77cc7e579dd4','https://manila-public-openstack.apps-crc.testing/v1/%(project_id)s','{\"name\": \"manila\"}',1,'regionOne'),('5f7702b379834b648cee4f3e8bf85809',NULL,'public','32633c25ec034a2d95a4463e4ed8f258','https://manila-public-openstack.apps-crc.testing/v2','{\"name\": \"manilav2\"}',1,'regionOne'),('6147fda3156848d395a38b359fc51fbf',NULL,'public','798b6e220bb94d82adb051410ed4ed91','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne'),('74d5116874ca4f0781f0db1a999f905d',NULL,'internal','4388c15aa6e848dc89a9c4b07bcc0e14','https://cinder-internal.openstack.svc:8776/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('7614e6f1faeb4ee6a315eb1e30f55fbc',NULL,'public','95a4b039323642fc8a715917ee4367e2','https://keystone-public-openstack.apps-crc.testing','{}',1,'regionOne'),('7da4964c36bf4d5785ff40e853a03835',NULL,'internal','cc6f60e92ac542e7b4a4f6196d17c981','https://glance-default-internal.openstack.svc:9292','{\"name\": \"glance\"}',1,'regionOne'),('a22dd11dd3d342709c2e872d19add2e6',NULL,'internal','1cc78f051fec4f1197ad77cc7e579dd4','https://manila-internal.openstack.svc:8786/v1/%(project_id)s','{\"name\": \"manila\"}',1,'regionOne'),('a9930e5c8724402096215dc8de0f8dd0',NULL,'internal','fca5cd71603a47988c84cffca6d293da','https://neutron-internal.openstack.svc:9696','{\"name\": \"neutron\"}',1,'regionOne'),('af0d898fcb7243688906ee7c69425d79',NULL,'public','cc6f60e92ac542e7b4a4f6196d17c981','https://glance-default-public-openstack.apps-crc.testing','{\"name\": \"glance\"}',1,'regionOne'),('b27b7ca220e64cc9ba9e1a72b275b640',NULL,'public','88536fd423fc451fa7cd5034c6a3faa4','https://barbican-public-openstack.apps-crc.testing','{\"name\": \"barbican\"}',1,'regionOne'),('bc8bd559c3814e8eb59150084325c00d',NULL,'public','1cca587de99249cd8ce492f0db47622a','https://nova-public-openstack.apps-crc.testing/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('c9b2a482032b48af8e08b1b7fdbe007e',NULL,'internal','798b6e220bb94d82adb051410ed4ed91','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne'),('f26d8bd0b4ab47b29c19493d1ce27cd6',NULL,'internal','95a4b039323642fc8a715917ee4367e2','https://keystone-internal.openstack.svc:5000','{}',1,'regionOne'),('f3375c9b1afe45debcaa8d3da4c6df70',NULL,'internal','0e7f3c97db614da5aef6e9cba6c6d978','https://placement-internal.openstack.svc:8778','{\"name\": \"placement\"}',1,'regionOne'),('f6b65065f14e4401a5badccdb983d890',NULL,'public','0e7f3c97db614da5aef6e9cba6c6d978','https://placement-public-openstack.apps-crc.testing','{\"name\": \"placement\"}',1,'regionOne'),('f961979bbb9347f8aa06d125aff01567',NULL,'internal','1cca587de99249cd8ce492f0db47622a','https://nova-internal.openstack.svc:8774/v2.1','{\"name\": \"nova\"}',1,'regionOne');
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint_group`
--

DROP TABLE IF EXISTS `endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint_group` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `filters` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint_group`
--

LOCK TABLES `endpoint_group` WRITE;
/*!40000 ALTER TABLE `endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expiring_user_group_membership`
--

DROP TABLE IF EXISTS `expiring_user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expiring_user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `last_verified` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`,`idp_id`),
  KEY `group_id` (`group_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_3` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expiring_user_group_membership`
--

LOCK TABLES `expiring_user_group_membership` WRITE;
/*!40000 ALTER TABLE `expiring_user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `expiring_user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federated_user`
--

DROP TABLE IF EXISTS `federated_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federated_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `protocol_id` varchar(64) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idp_id` (`idp_id`,`protocol_id`,`unique_id`),
  KEY `federated_user_protocol_id_fkey` (`protocol_id`,`idp_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `federated_user_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_ibfk_2` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_protocol_id_fkey` FOREIGN KEY (`protocol_id`, `idp_id`) REFERENCES `federation_protocol` (`id`, `idp_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federated_user`
--

LOCK TABLES `federated_user` WRITE;
/*!40000 ALTER TABLE `federated_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `federated_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federation_protocol`
--

DROP TABLE IF EXISTS `federation_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federation_protocol` (
  `id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `mapping_id` varchar(64) NOT NULL,
  `remote_id_attribute` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`,`idp_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `federation_protocol_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federation_protocol`
--

LOCK TABLES `federation_protocol` WRITE;
/*!40000 ALTER TABLE `federation_protocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `federation_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group`
--

DROP TABLE IF EXISTS `group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group` (
  `id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_group_name_domain_id` (`domain_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group`
--

LOCK TABLES `group` WRITE;
/*!40000 ALTER TABLE `group` DISABLE KEYS */;
/*!40000 ALTER TABLE `group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `id_mapping`
--

DROP TABLE IF EXISTS `id_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `id_mapping` (
  `public_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `local_id` varchar(255) NOT NULL,
  `entity_type` enum('user','group') NOT NULL,
  PRIMARY KEY (`public_id`),
  UNIQUE KEY `domain_id` (`domain_id`,`local_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `id_mapping`
--

LOCK TABLES `id_mapping` WRITE;
/*!40000 ALTER TABLE `id_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `id_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `identity_provider`
--

DROP TABLE IF EXISTS `identity_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `identity_provider` (
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `authorization_ttl` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `identity_provider`
--

LOCK TABLES `identity_provider` WRITE;
/*!40000 ALTER TABLE `identity_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `identity_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `idp_remote_ids`
--

DROP TABLE IF EXISTS `idp_remote_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `idp_remote_ids` (
  `idp_id` varchar(64) DEFAULT NULL,
  `remote_id` varchar(255) NOT NULL,
  PRIMARY KEY (`remote_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `idp_remote_ids_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `idp_remote_ids`
--

LOCK TABLES `idp_remote_ids` WRITE;
/*!40000 ALTER TABLE `idp_remote_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `idp_remote_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `implied_role`
--

DROP TABLE IF EXISTS `implied_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `implied_role` (
  `prior_role_id` varchar(64) NOT NULL,
  `implied_role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`prior_role_id`,`implied_role_id`),
  KEY `implied_role_implied_role_id_fkey` (`implied_role_id`),
  CONSTRAINT `implied_role_implied_role_id_fkey` FOREIGN KEY (`implied_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE,
  CONSTRAINT `implied_role_prior_role_id_fkey` FOREIGN KEY (`prior_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `implied_role`
--

LOCK TABLES `implied_role` WRITE;
/*!40000 ALTER TABLE `implied_role` DISABLE KEYS */;
INSERT INTO `implied_role` (`prior_role_id`, `implied_role_id`) VALUES ('25d3eb68b6004924a409a7b0aafff112','7bdb57a1fbde47c7ac0c5511d2f9c3e6'),('eaf49411c8e94ce9954baa2063538d27','25d3eb68b6004924a409a7b0aafff112');
/*!40000 ALTER TABLE `implied_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `limit`
--

DROP TABLE IF EXISTS `limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `limit` (
  `id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `resource_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `registered_limit_id` varchar(64) DEFAULT NULL,
  `domain_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `limit_id_key` (`id`),
  KEY `registered_limit_id` (`registered_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `limit`
--

LOCK TABLES `limit` WRITE;
/*!40000 ALTER TABLE `limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_user`
--

DROP TABLE IF EXISTS `local_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `local_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `failed_auth_count` int(11) DEFAULT NULL,
  `failed_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_id` (`domain_id`,`name`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `local_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `local_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=233 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `local_user`
--

LOCK TABLES `local_user` WRITE;
/*!40000 ALTER TABLE `local_user` DISABLE KEYS */;
INSERT INTO `local_user` (`id`, `user_id`, `domain_id`, `name`, `failed_auth_count`, `failed_auth_at`) VALUES (1,'da42e74ed6d04223b9f1be411e89508b','default','admin',0,NULL),(2,'04b5bf8225a04cd1bb1be73757e80ca2','default','cinder',0,NULL),(3,'6f2298292b104ff58856a40039289e85','default','glance',0,NULL),(4,'ea591be1497d41ec8a8129de91669cc4','default','placement',0,NULL),(5,'32c33e44159f4ccfa6e2fd4f81a8ad4f','default','nova',0,NULL),(6,'767285b605aa44dbbd3cd889c1cbfdd3','default','ceilometer',0,NULL),(7,'e21ade2dfdf54a9bbdbf2d31f14c738c','default','barbican',0,NULL),(8,'8f59cc412ff44a13a0e77a17c47b7815','default','neutron',0,NULL),(9,'bebcae54c3b640c4bae666c40d95c5f8','default','swift',0,NULL),(10,'032b6b592a214ec7a5eba078e1abe4d6','default','manila',0,NULL),(11,'9148c83efc474b8b80eb81c2090d5435','default','demo_tempestconf',0,NULL),(12,'f4bb8f450f734df5b0e4972dc06e2dd5','default','alt_demo_tempestconf',0,NULL);
/*!40000 ALTER TABLE `local_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mapping`
--

DROP TABLE IF EXISTS `mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mapping` (
  `id` varchar(64) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mapping`
--

LOCK TABLES `mapping` WRITE;
/*!40000 ALTER TABLE `mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nonlocal_user`
--

DROP TABLE IF EXISTS `nonlocal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nonlocal_user` (
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  PRIMARY KEY (`domain_id`,`name`),
  UNIQUE KEY `ixu_nonlocal_user_user_id` (`user_id`),
  KEY `nonlocal_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `nonlocal_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nonlocal_user`
--

LOCK TABLES `nonlocal_user` WRITE;
/*!40000 ALTER TABLE `nonlocal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `nonlocal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password`
--

DROP TABLE IF EXISTS `password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_user_id` int(11) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `self_service` tinyint(1) NOT NULL DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `created_at_int` bigint(20) NOT NULL DEFAULT 0,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `local_user_id` (`local_user_id`),
  CONSTRAINT `password_ibfk_1` FOREIGN KEY (`local_user_id`) REFERENCES `local_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=233 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password`
--

LOCK TABLES `password` WRITE;
/*!40000 ALTER TABLE `password` DISABLE KEYS */;
INSERT INTO `password` (`id`, `local_user_id`, `expires_at`, `self_service`, `password_hash`, `created_at_int`, `expires_at_int`, `created_at`) VALUES (1,1,NULL,0,'$2b$12$8tchsngy6FgeeHyNWeFhO.WoXTUV7qYNYbqaNr3WWtcCgOu9oLAjO',1764392100792244,NULL,'2025-11-29 04:55:00'),(2,2,NULL,0,'$2b$12$lxXXJ1JFM4PC7G6mKhOXoe5Wt1svid8MUsP8H.6mi0BEak5UHzipW',1764392171618299,NULL,'2025-11-29 04:56:11'),(3,3,NULL,0,'$2b$12$4WXInTJPC0f1q897WxrlnOCXWtkPCH54mOPPhjTuERgL/56DyuSCW',1764392174718826,NULL,'2025-11-29 04:56:14'),(4,4,NULL,0,'$2b$12$asBqueq2/LN1.2HrN97OUefsL0tsE9.kBuD9yb7fpdJvyYn/OKcxy',1764392178149380,NULL,'2025-11-29 04:56:18'),(5,5,NULL,0,'$2b$12$dovwizp1o8iq8rr9EnV50u.MBEOMOkEJ1WzoLp392tAkMSTD0ibPi',1764392182393763,NULL,'2025-11-29 04:56:22'),(6,6,NULL,0,'$2b$12$oi2j11t1hhQmH2fhYA10AuZMRdvngK4v9GOKFNeCSJQibd0T2F8MK',1764392187581784,NULL,'2025-11-29 04:56:27'),(7,7,NULL,0,'$2b$12$K7q1iEUKYW.354sj5I84PencuVJK5etEg/sGUxD1awXu6r7wURwf.',1764392191117708,NULL,'2025-11-29 04:56:31'),(8,8,NULL,0,'$2b$12$6uWMs3M5twDy9M0f45ZTr.jntuLtcZYjEUuMa0EauAfZE1r7bgOsa',1764392194652667,NULL,'2025-11-29 04:56:34'),(9,9,NULL,0,'$2b$12$K1qfS3SKcIe21P1IAgn8JeEN.FVKDglwXTdKx6Hdm2o/FsrhKu5MS',1764393053771540,NULL,'2025-11-29 05:10:53'),(10,10,NULL,0,'$2b$12$jybLKRzBQXqVcGzc49vshOTNB2.gpsHh9scQV9l/EMM/.2k8bbQiW',1764394162245734,NULL,'2025-11-29 05:29:22'),(11,11,NULL,0,'$2b$12$ytO7Jfz.I6/A6KPsKztwJOIek7SyellHP7W7zVpfUYQFx6tqSjY5S',1764394326602614,NULL,'2025-11-29 05:32:06'),(12,12,NULL,0,'$2b$12$2.VwOuQbfblpyfP9/OUMWeRexi3WscVSr0S2areV2QJyDZGCH2kw2',1764394327049621,NULL,'2025-11-29 05:32:07');
/*!40000 ALTER TABLE `password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `blob` text NOT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_association`
--

DROP TABLE IF EXISTS `policy_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy_association` (
  `id` varchar(64) NOT NULL,
  `policy_id` varchar(64) NOT NULL,
  `endpoint_id` varchar(64) DEFAULT NULL,
  `service_id` varchar(64) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `endpoint_id` (`endpoint_id`,`service_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_association`
--

LOCK TABLES `policy_association` WRITE;
/*!40000 ALTER TABLE `policy_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project` (
  `id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL,
  `is_domain` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_project_name_domain_id` (`domain_id`,`name`),
  KEY `project_parent_id_fkey` (`parent_id`),
  CONSTRAINT `project_domain_id_fkey` FOREIGN KEY (`domain_id`) REFERENCES `project` (`id`),
  CONSTRAINT `project_parent_id_fkey` FOREIGN KEY (`parent_id`) REFERENCES `project` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
INSERT INTO `project` (`id`, `name`, `extra`, `description`, `enabled`, `domain_id`, `parent_id`, `is_domain`) VALUES ('389b14b74e3c4a1184dca228ba013067','admin','{}','Bootstrap project for initializing the cloud.',1,'default','default',0),('3f8e46ff816a4d8a90bfa4b396b35aaf','service','{}','service',1,'default','default',0),('<<keystone.domain.root>>','<<keystone.domain.root>>','{}','',0,'<<keystone.domain.root>>',NULL,1),('cec69ecdc21e48bcb26757a96bef3fdc','demo','{}','Project for Tempest demo_tempestconf user',1,'default','default',0),('default','Default','{}','The default domain',1,'<<keystone.domain.root>>',NULL,1),('ebe86517524a4fddade08d85ffb69e00','alt_demo','{}','Project for Tempest alt_demo_tempestconf user',1,'default','default',0);
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint`
--

DROP TABLE IF EXISTS `project_endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint` (
  `endpoint_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint`
--

LOCK TABLES `project_endpoint` WRITE;
/*!40000 ALTER TABLE `project_endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint_group`
--

DROP TABLE IF EXISTS `project_endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint_group` (
  `endpoint_group_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_group_id`,`project_id`),
  CONSTRAINT `project_endpoint_group_ibfk_1` FOREIGN KEY (`endpoint_group_id`) REFERENCES `endpoint_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint_group`
--

LOCK TABLES `project_endpoint_group` WRITE;
/*!40000 ALTER TABLE `project_endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_option`
--

DROP TABLE IF EXISTS `project_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_option` (
  `project_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`project_id`,`option_id`),
  CONSTRAINT `project_option_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_option`
--

LOCK TABLES `project_option` WRITE;
/*!40000 ALTER TABLE `project_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_tag`
--

DROP TABLE IF EXISTS `project_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_tag` (
  `project_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`project_id`,`name`),
  UNIQUE KEY `project_id` (`project_id`,`name`),
  CONSTRAINT `project_tag_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_tag`
--

LOCK TABLES `project_tag` WRITE;
/*!40000 ALTER TABLE `project_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `parent_region_id` varchar(255) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` (`id`, `description`, `parent_region_id`, `extra`) VALUES ('regionOne','',NULL,'{}');
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registered_limit`
--

DROP TABLE IF EXISTS `registered_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `registered_limit` (
  `id` varchar(64) NOT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `default_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `registered_limit_id_key` (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `registered_limit`
--

LOCK TABLES `registered_limit` WRITE;
/*!40000 ALTER TABLE `registered_limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `registered_limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_token`
--

DROP TABLE IF EXISTS `request_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_token` (
  `id` varchar(64) NOT NULL,
  `request_secret` varchar(64) NOT NULL,
  `verifier` varchar(64) DEFAULT NULL,
  `authorizing_user_id` varchar(64) DEFAULT NULL,
  `requested_project_id` varchar(64) NOT NULL,
  `role_ids` text DEFAULT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_request_token_consumer_id` (`consumer_id`),
  CONSTRAINT `request_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_token`
--

LOCK TABLES `request_token` WRITE;
/*!40000 ALTER TABLE `request_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revocation_event`
--

DROP TABLE IF EXISTS `revocation_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revocation_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` varchar(64) DEFAULT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  `role_id` varchar(64) DEFAULT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `consumer_id` varchar(64) DEFAULT NULL,
  `access_token_id` varchar(64) DEFAULT NULL,
  `issued_before` datetime NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `revoked_at` datetime NOT NULL,
  `audit_id` varchar(32) DEFAULT NULL,
  `audit_chain_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_revocation_event_audit_id_issued_before` (`audit_id`,`issued_before`),
  KEY `ix_revocation_event_new_revoked_at` (`revoked_at`),
  KEY `ix_revocation_event_issued_before` (`issued_before`),
  KEY `ix_revocation_event_project_id_issued_before` (`project_id`,`issued_before`),
  KEY `ix_revocation_event_user_id_issued_before` (`user_id`,`issued_before`)
) ENGINE=InnoDB AUTO_INCREMENT=395 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revocation_event`
--

LOCK TABLES `revocation_event` WRITE;
/*!40000 ALTER TABLE `revocation_event` DISABLE KEYS */;
INSERT INTO `revocation_event` (`id`, `domain_id`, `project_id`, `user_id`, `role_id`, `trust_id`, `consumer_id`, `access_token_id`, `issued_before`, `expires_at`, `revoked_at`, `audit_id`, `audit_chain_id`) VALUES (1,NULL,NULL,'b9015972668b4b2e8fb615c9b127681c',NULL,NULL,NULL,NULL,'2025-11-29 05:34:26',NULL,'2025-11-29 05:34:26',NULL,NULL),(2,NULL,NULL,'707ccacb220f4ca3976e7e82ef03228d',NULL,NULL,NULL,NULL,'2025-11-29 05:34:26',NULL,'2025-11-29 05:34:26',NULL,NULL),(3,NULL,NULL,'777cb79a301d4b4e88ce6b187e0c0566',NULL,NULL,NULL,NULL,'2025-11-29 05:34:26',NULL,'2025-11-29 05:34:26',NULL,NULL),(4,NULL,NULL,'622ec01184c7412a84054946bbe859ff',NULL,NULL,NULL,NULL,'2025-11-29 05:34:26',NULL,'2025-11-29 05:34:26',NULL,NULL),(5,NULL,NULL,'764e0951bc5a40a1ae8a60f324275ec5',NULL,NULL,NULL,NULL,'2025-11-29 05:34:26',NULL,'2025-11-29 05:34:26',NULL,NULL),(6,NULL,'36efd59df9a0429788d40efb53af9964',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:34:28',NULL,'2025-11-29 05:34:28',NULL,NULL),(7,NULL,'4c591c6fd8074752be1ef6f703db78c0',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:34:28',NULL,'2025-11-29 05:34:28',NULL,NULL),(8,NULL,'7b025add66b64d3981239735e2e63e78',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:34:29',NULL,'2025-11-29 05:34:29',NULL,NULL),(9,NULL,'699ad7bebc3f42c1ba6a21e827325219',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:34:30',NULL,'2025-11-29 05:34:30',NULL,NULL),(10,NULL,NULL,'11f7306e409d44659a5814fb78a152b5',NULL,NULL,NULL,NULL,'2025-11-29 05:34:31',NULL,'2025-11-29 05:34:31',NULL,NULL),(11,NULL,NULL,'a514ba25f4d343268aec5f3e8bb54d9a',NULL,NULL,NULL,NULL,'2025-11-29 05:34:34',NULL,'2025-11-29 05:34:34',NULL,NULL),(12,NULL,NULL,'fded47ffda314fee82693c39187f7b8e',NULL,NULL,NULL,NULL,'2025-11-29 05:34:35',NULL,'2025-11-29 05:34:35',NULL,NULL),(13,NULL,NULL,'3d2c67cb42384d59b798439cb5a91aa5',NULL,NULL,NULL,NULL,'2025-11-29 05:34:35',NULL,'2025-11-29 05:34:35',NULL,NULL),(14,NULL,NULL,'6c4440716b3448648f0ed88447702fad',NULL,NULL,NULL,NULL,'2025-11-29 05:34:35',NULL,'2025-11-29 05:34:35',NULL,NULL),(15,NULL,NULL,'a4405020e19e4f6fadac355d366a4640',NULL,NULL,NULL,NULL,'2025-11-29 05:34:35',NULL,'2025-11-29 05:34:35',NULL,NULL),(16,NULL,NULL,'abe5798ea7e34716869e877ac748a4d4',NULL,NULL,NULL,NULL,'2025-11-29 05:34:35',NULL,'2025-11-29 05:34:35',NULL,NULL),(17,NULL,NULL,'6bebd43b2c7c48209f1030ff92d31dc2',NULL,NULL,NULL,NULL,'2025-11-29 05:34:35',NULL,'2025-11-29 05:34:35',NULL,NULL),(18,NULL,'2b9b1b31eca345d985efe6fd236f019e',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:34:37',NULL,'2025-11-29 05:34:37',NULL,NULL),(19,NULL,'35fca249d2fe4b499e58ae322257ed19',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:34:37',NULL,'2025-11-29 05:34:37',NULL,NULL),(20,NULL,'517e7853ad9547fc8f1ef2b0a5f8bee4',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:34:38',NULL,'2025-11-29 05:34:38',NULL,NULL),(21,NULL,'bdb001d6ae1146899285fea0cc57db66',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:34:38',NULL,'2025-11-29 05:34:38',NULL,NULL),(22,NULL,'b2c2519726774be0bef5062f782af587',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:34:39',NULL,'2025-11-29 05:34:39',NULL,NULL),(23,NULL,'ea22629860024d26a2beeea0d3151161',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:34:39',NULL,'2025-11-29 05:34:39',NULL,NULL),(24,NULL,NULL,'00dce5e1882b43988c27a410f374ac0e',NULL,NULL,NULL,NULL,'2025-11-29 05:34:41',NULL,'2025-11-29 05:34:41',NULL,NULL),(25,NULL,'7ddf836419e64654a808777b391890f6',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:34:43',NULL,'2025-11-29 05:34:43',NULL,NULL),(26,NULL,NULL,'0b2995b782b0420780add3eb92342bac',NULL,NULL,NULL,NULL,'2025-11-29 05:34:43',NULL,'2025-11-29 05:34:43',NULL,NULL),(27,NULL,NULL,'90a41e8d68074a8eac1215cc82dcdd45',NULL,NULL,NULL,NULL,'2025-11-29 05:34:45',NULL,'2025-11-29 05:34:45',NULL,NULL),(28,NULL,NULL,'18a47c1a02154001b3e8e95b6b9dd070',NULL,NULL,NULL,NULL,'2025-11-29 05:34:45',NULL,'2025-11-29 05:34:45',NULL,NULL),(29,NULL,'d047def3687e445d880dbf8fa6cb8163',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:34:46',NULL,'2025-11-29 05:34:46',NULL,NULL),(30,NULL,'866c1e4713044c38883b5b1a09ba412e',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:34:47',NULL,'2025-11-29 05:34:47',NULL,NULL),(31,NULL,NULL,'2e3b380a4a994b9ea9aa9dcbfb970807',NULL,NULL,NULL,NULL,'2025-11-29 05:34:48',NULL,'2025-11-29 05:34:48',NULL,NULL),(32,NULL,NULL,'f18e89eb5a984a98bf3f34b4c670e5f3',NULL,NULL,NULL,NULL,'2025-11-29 05:34:49',NULL,'2025-11-29 05:34:49',NULL,NULL),(33,NULL,NULL,'cb1b305ee4f94aa68f250be4f43ef913',NULL,NULL,NULL,NULL,'2025-11-29 05:34:49',NULL,'2025-11-29 05:34:49',NULL,NULL),(34,NULL,NULL,'fe5e9c62934245ad9aefde7a5c0512f3',NULL,NULL,NULL,NULL,'2025-11-29 05:34:49',NULL,'2025-11-29 05:34:49',NULL,NULL),(35,NULL,'049c3d38228f4e3e9c392f5f88dbc238',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:34:50',NULL,'2025-11-29 05:34:50',NULL,NULL),(36,NULL,'e82f448a08794706ba35298faa93bdf1',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:34:51',NULL,'2025-11-29 05:34:51',NULL,NULL),(37,NULL,'125230e78a164a608237849bfe8f5856',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:34:51',NULL,'2025-11-29 05:34:51',NULL,NULL),(38,NULL,'e7f18545ba4443e5b9d745c075020128',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:34:52',NULL,'2025-11-29 05:34:52',NULL,NULL),(39,NULL,NULL,'51c18a1410ec477da36600729ce5a6f4',NULL,NULL,NULL,NULL,'2025-11-29 05:34:53',NULL,'2025-11-29 05:34:53',NULL,NULL),(40,NULL,NULL,'6bf4fd2499444d1aa0721372fb2d334c',NULL,NULL,NULL,NULL,'2025-11-29 05:34:55',NULL,'2025-11-29 05:34:55',NULL,NULL),(41,NULL,'d2396bde8f7147c1b4319b9e0bc503aa',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:34:55',NULL,'2025-11-29 05:34:55',NULL,NULL),(42,NULL,NULL,'7218b68d283b43fa867dff07e8f83ea1',NULL,NULL,NULL,NULL,'2025-11-29 05:34:56',NULL,'2025-11-29 05:34:56',NULL,NULL),(43,NULL,'899789aeecf24f5187c15dc2e8613467',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:34:56',NULL,'2025-11-29 05:34:56',NULL,NULL),(44,NULL,NULL,'a8bd1c5f28f14ea1be69275bd7d399e8',NULL,NULL,NULL,NULL,'2025-11-29 05:34:57',NULL,'2025-11-29 05:34:57',NULL,NULL),(45,NULL,NULL,'c3109090499f414a90a48ff00871d84a',NULL,NULL,NULL,NULL,'2025-11-29 05:34:57',NULL,'2025-11-29 05:34:57',NULL,NULL),(46,NULL,NULL,'7054b1944b214e87b433f036b7f14c49',NULL,NULL,NULL,NULL,'2025-11-29 05:34:57',NULL,'2025-11-29 05:34:57',NULL,NULL),(47,NULL,NULL,'73b0ee20dbd84d63827e4fb2ae68aaae',NULL,NULL,NULL,NULL,'2025-11-29 05:34:58',NULL,'2025-11-29 05:34:58',NULL,NULL),(48,NULL,'390309da8ffe4d11a56c04309c1e4f37',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:34:59',NULL,'2025-11-29 05:34:59',NULL,NULL),(49,NULL,NULL,'a73f6391ef3141cdaaadff74490d5852',NULL,NULL,NULL,NULL,'2025-11-29 05:34:59',NULL,'2025-11-29 05:34:59',NULL,NULL),(50,NULL,'baae159964dc407a916934ab9fb94658',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:35:00',NULL,'2025-11-29 05:35:00',NULL,NULL),(51,NULL,'af259d797e064c71aaec8ca0bb3d65c6',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:35:00',NULL,'2025-11-29 05:35:00',NULL,NULL),(52,NULL,'e519867373924d5c9d136e39c52f05e5',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:35:01',NULL,'2025-11-29 05:35:01',NULL,NULL),(53,NULL,'b606f16a3f434bf791adaad14e9b8b69',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:35:01',NULL,'2025-11-29 05:35:01',NULL,NULL),(54,NULL,NULL,'fa9c55bf5bba4852b4681117456f7acd',NULL,NULL,NULL,NULL,'2025-11-29 05:35:06',NULL,'2025-11-29 05:35:06',NULL,NULL),(55,NULL,'6328961d3c9f439fa06f6e5b9e3d9abe',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:35:08',NULL,'2025-11-29 05:35:08',NULL,NULL),(56,NULL,NULL,'bae166e1fe9a49c1b1f4ac5b2f611c31',NULL,NULL,NULL,NULL,'2025-11-29 05:35:14',NULL,'2025-11-29 05:35:14',NULL,NULL),(57,NULL,'a92741ddf81e4fb0b94452559f4f986f',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:35:16',NULL,'2025-11-29 05:35:16',NULL,NULL),(58,NULL,NULL,'b567377e16614fe4adbfde1feaa12f8f',NULL,NULL,NULL,NULL,'2025-11-29 05:35:21',NULL,'2025-11-29 05:35:21',NULL,NULL),(59,NULL,NULL,'3d99a1d8da904802b9ffa7db078e4dbc',NULL,NULL,NULL,NULL,'2025-11-29 05:35:21',NULL,'2025-11-29 05:35:21',NULL,NULL),(60,NULL,NULL,'93c3d1d919a646ddbe918a88acd818d5',NULL,NULL,NULL,NULL,'2025-11-29 05:35:21',NULL,'2025-11-29 05:35:21',NULL,NULL),(61,NULL,NULL,'4181a1273fd7471e8254783a3b7d2148',NULL,NULL,NULL,NULL,'2025-11-29 05:35:21',NULL,'2025-11-29 05:35:21',NULL,NULL),(62,NULL,'923699261271421a81c524b545eea529',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:35:23',NULL,'2025-11-29 05:35:23',NULL,NULL),(63,NULL,'84900bf0f299413cbd72f819f150e723',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:35:24',NULL,'2025-11-29 05:35:24',NULL,NULL),(64,NULL,'4ac361c229944fe1898da5b3e8ea970a',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:35:24',NULL,'2025-11-29 05:35:24',NULL,NULL),(65,NULL,NULL,'d4f347bf757f4b63a2b5a0911ea57701',NULL,NULL,NULL,NULL,'2025-11-29 05:35:27',NULL,'2025-11-29 05:35:27',NULL,NULL),(66,NULL,'8c2d9ada2f8941c1ae74fceac314f501',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:35:28',NULL,'2025-11-29 05:35:28',NULL,NULL),(67,NULL,NULL,'a26f72c070b744c9bf2251e8d4e0b968',NULL,NULL,NULL,NULL,'2025-11-29 05:35:30',NULL,'2025-11-29 05:35:30',NULL,NULL),(68,NULL,'4bb30e646ab144a880da8710cfe02738',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:35:31',NULL,'2025-11-29 05:35:31',NULL,NULL),(69,NULL,NULL,'e180e354136948e891ecc3d23d7c9b2c',NULL,NULL,NULL,NULL,'2025-11-29 05:35:33',NULL,'2025-11-29 05:35:33',NULL,NULL),(70,NULL,'9bb7cdca24784e1f9d64ee7aa962ec5d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:35:35',NULL,'2025-11-29 05:35:35',NULL,NULL),(71,NULL,NULL,'417cb9ae9b2a43429cd5d1781ad57fd9',NULL,NULL,NULL,NULL,'2025-11-29 05:35:39',NULL,'2025-11-29 05:35:39',NULL,NULL),(72,NULL,'c272c8175ff843ca8dc572501529b10b',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:35:41',NULL,'2025-11-29 05:35:41',NULL,NULL),(73,NULL,NULL,'b8130e5f53044901811193aed6fcff4b',NULL,NULL,NULL,NULL,'2025-11-29 05:35:43',NULL,'2025-11-29 05:35:43',NULL,NULL),(74,NULL,NULL,'23469d4601454621a798588dbcc97218',NULL,NULL,NULL,NULL,'2025-11-29 05:35:44',NULL,'2025-11-29 05:35:44',NULL,NULL),(75,NULL,'ed65c65316404adb92ee2d392f3989a6',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:35:44',NULL,'2025-11-29 05:35:44',NULL,NULL),(76,NULL,'b4f2479ae0d643afbae53bb92525282e',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:35:46',NULL,'2025-11-29 05:35:46',NULL,NULL),(77,NULL,NULL,'a8bb9a2c0ed24b2c9e82462438aa50e1',NULL,NULL,NULL,NULL,'2025-11-29 05:35:47',NULL,'2025-11-29 05:35:47',NULL,NULL),(78,NULL,NULL,'4544ba66fc044b5a8d3aa9deb5249384',NULL,NULL,NULL,NULL,'2025-11-29 05:35:47',NULL,'2025-11-29 05:35:47',NULL,NULL),(79,NULL,'96db438b5227434496a6dd0026e44ed2',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:35:48',NULL,'2025-11-29 05:35:48',NULL,NULL),(80,NULL,'3e18b41001c440e0a7d05f7f98059230',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:35:49',NULL,'2025-11-29 05:35:49',NULL,NULL),(81,NULL,NULL,'bdf4d0d2221a430c9b1a1199b31687d0',NULL,NULL,NULL,NULL,'2025-11-29 05:35:54',NULL,'2025-11-29 05:35:54',NULL,NULL),(82,NULL,'5611933d70e148b1aa79e29dc5a5b334',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:35:55',NULL,'2025-11-29 05:35:55',NULL,NULL),(83,NULL,NULL,'5337269830c042c3b445e0f3410b8e56',NULL,NULL,NULL,NULL,'2025-11-29 05:35:59',NULL,'2025-11-29 05:35:59',NULL,NULL),(84,NULL,NULL,'7f22750ff269480ea2ef15ccea8f7689',NULL,NULL,NULL,NULL,'2025-11-29 05:36:06',NULL,'2025-11-29 05:36:06',NULL,NULL),(85,NULL,NULL,'b05695659a244b0999eccfed65868fdb',NULL,NULL,NULL,NULL,'2025-11-29 05:36:06',NULL,'2025-11-29 05:36:06',NULL,NULL),(86,NULL,NULL,'8ccc86dd3b0145e69c3ef9219a114af3',NULL,NULL,NULL,NULL,'2025-11-29 05:36:06',NULL,'2025-11-29 05:36:06',NULL,NULL),(87,NULL,NULL,'ae00d95f95bb4ec8b2178598e348be7a',NULL,NULL,NULL,NULL,'2025-11-29 05:36:06',NULL,'2025-11-29 05:36:06',NULL,NULL),(88,NULL,'98fe5191e55f4f689dfe66e587ac3ee6',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:36:07',NULL,'2025-11-29 05:36:07',NULL,NULL),(89,NULL,'4453ce436b30425fba6f22e4043ef796',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:36:07',NULL,'2025-11-29 05:36:07',NULL,NULL),(90,NULL,'1b0e3dfeb7174b5485c5d74f4be5ea5d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:36:08',NULL,'2025-11-29 05:36:08',NULL,NULL),(91,NULL,'878afd71353c4521b8126d23d87c9ca0',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:36:09',NULL,'2025-11-29 05:36:09',NULL,NULL),(92,NULL,NULL,'473e981a12b646d18a199762a9b61a91',NULL,NULL,NULL,NULL,'2025-11-29 05:36:12',NULL,'2025-11-29 05:36:12',NULL,NULL),(93,NULL,'f37b22b2fcc142abacd47297bd44306d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:36:13',NULL,'2025-11-29 05:36:13',NULL,NULL),(94,NULL,NULL,'1df8523f0e40441eb91a4e6e80a48aa5',NULL,NULL,NULL,NULL,'2025-11-29 05:36:14',NULL,'2025-11-29 05:36:14',NULL,NULL),(95,NULL,NULL,'e834d9d8dc83417ea6c9ba3e6be16616',NULL,NULL,NULL,NULL,'2025-11-29 05:36:15',NULL,'2025-11-29 05:36:15',NULL,NULL),(96,NULL,NULL,'a482e699f6dc4efba8a01a70832bb439',NULL,NULL,NULL,NULL,'2025-11-29 05:36:15',NULL,'2025-11-29 05:36:15',NULL,NULL),(97,NULL,NULL,'27caf49ccb4c4cda9711cd1d1dd033ca',NULL,NULL,NULL,NULL,'2025-11-29 05:36:15',NULL,'2025-11-29 05:36:15',NULL,NULL),(98,NULL,NULL,'2b921aaa87ed436b86e4e995d75e8657',NULL,NULL,NULL,NULL,'2025-11-29 05:36:15',NULL,'2025-11-29 05:36:15',NULL,NULL),(99,NULL,'061705ddc30c4a188ae026c064f1a2b8',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:36:17',NULL,'2025-11-29 05:36:17',NULL,NULL),(100,NULL,'ff82c82a8d9b4376a1a0007b84f6bdf0',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:36:17',NULL,'2025-11-29 05:36:17',NULL,NULL),(101,NULL,'0448e6e78f8747efb1e6a68338df9866',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:36:19',NULL,'2025-11-29 05:36:19',NULL,NULL),(102,NULL,NULL,'1eeb787407f64a84a0001c62a56ccfe8',NULL,NULL,NULL,NULL,'2025-11-29 05:36:20',NULL,'2025-11-29 05:36:20',NULL,NULL),(103,NULL,'197c921914574684839f4c0dd963c8c2',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:36:20',NULL,'2025-11-29 05:36:20',NULL,NULL),(104,NULL,'07c3b1a68d9840069b7630b20bac3616',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:36:21',NULL,'2025-11-29 05:36:21',NULL,NULL),(105,NULL,NULL,'692206a8bbca43cbad00a936fe16463d',NULL,NULL,NULL,NULL,'2025-11-29 05:36:26',NULL,'2025-11-29 05:36:26',NULL,NULL),(106,NULL,NULL,'60cdf09563994bd6a4fd597367acae22',NULL,NULL,NULL,NULL,'2025-11-29 05:36:26',NULL,'2025-11-29 05:36:26',NULL,NULL),(107,NULL,NULL,'acf8bdc40afb413699bda11cb3183338',NULL,NULL,NULL,NULL,'2025-11-29 05:36:26',NULL,'2025-11-29 05:36:26',NULL,NULL),(108,NULL,NULL,'0061a90ccf654342b69ac443131b4b0a',NULL,NULL,NULL,NULL,'2025-11-29 05:36:26',NULL,'2025-11-29 05:36:26',NULL,NULL),(109,NULL,'3d750fa0be4347a682e4b5a14d7864c0',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:36:27',NULL,'2025-11-29 05:36:27',NULL,NULL),(110,NULL,'4a379228399c41b0a6838b9be31628f6',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:36:28',NULL,'2025-11-29 05:36:28',NULL,NULL),(111,NULL,NULL,'757d6cf391f04fef97e19053474b3c98',NULL,NULL,NULL,NULL,'2025-11-29 05:36:28',NULL,'2025-11-29 05:36:28',NULL,NULL),(112,NULL,'099f0e0fb240472097d3f387414f8ee0',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:36:29',NULL,'2025-11-29 05:36:29',NULL,NULL),(113,NULL,NULL,'07455b147f224a5e9b6756f05d6a11b2',NULL,NULL,NULL,NULL,'2025-11-29 05:36:33',NULL,'2025-11-29 05:36:33',NULL,NULL),(114,NULL,NULL,'6ce0878495ef4b9b9f72764d89440837',NULL,NULL,NULL,NULL,'2025-11-29 05:36:33',NULL,'2025-11-29 05:36:33',NULL,NULL),(115,NULL,NULL,'93bc4eff55124b0197184b702d90dbb8',NULL,NULL,NULL,NULL,'2025-11-29 05:36:33',NULL,'2025-11-29 05:36:33',NULL,NULL),(116,NULL,NULL,'b5459c3e7d4643048572257a42a70281',NULL,NULL,NULL,NULL,'2025-11-29 05:36:35',NULL,'2025-11-29 05:36:35',NULL,NULL),(117,NULL,'49eca1f18a0d4dc09f7f8c5a1cc1be68',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:36:35',NULL,'2025-11-29 05:36:35',NULL,NULL),(118,NULL,'c6b8afea074442b2b9cd8ed762e06d27',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:36:36',NULL,'2025-11-29 05:36:36',NULL,NULL),(119,NULL,'ecaf95a6814b43d29d6ea72249a3081b',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:36:37',NULL,'2025-11-29 05:36:37',NULL,NULL),(120,NULL,'81a95c19e7f04f9388e5b6cb015dc8bf',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:36:38',NULL,'2025-11-29 05:36:38',NULL,NULL),(121,NULL,NULL,'63f0ed8e259a425f9e69dd0916e0e6a1',NULL,NULL,NULL,NULL,'2025-11-29 05:36:38',NULL,'2025-11-29 05:36:38',NULL,NULL),(122,NULL,'fcd78121f2c0471dbb5e3889691bc1b2',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:36:40',NULL,'2025-11-29 05:36:40',NULL,NULL),(123,NULL,NULL,'56e6491f64ef49fcb67db8a3291c3759',NULL,NULL,NULL,NULL,'2025-11-29 05:36:43',NULL,'2025-11-29 05:36:43',NULL,NULL),(124,NULL,NULL,'11f3c4c0cfa34033906598ef2baba8c3',NULL,NULL,NULL,NULL,'2025-11-29 05:36:43',NULL,'2025-11-29 05:36:43',NULL,NULL),(125,NULL,NULL,'d438ce96cc5a46a8b0763688b1c82f28',NULL,NULL,NULL,NULL,'2025-11-29 05:36:43',NULL,'2025-11-29 05:36:43',NULL,NULL),(126,NULL,NULL,'c02cf47730ed41768f58e7d58f847a3d',NULL,NULL,NULL,NULL,'2025-11-29 05:36:43',NULL,'2025-11-29 05:36:43',NULL,NULL),(127,NULL,NULL,'bc771205a6f24e9091b6883a871c1f26',NULL,NULL,NULL,NULL,'2025-11-29 05:36:44',NULL,'2025-11-29 05:36:44',NULL,NULL),(128,NULL,'7ddb030785ea46f0943c6bf5646a4f96',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:36:44',NULL,'2025-11-29 05:36:44',NULL,NULL),(129,NULL,'6fbfd21c93534c38bdc7cb6ad1900f4e',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:36:45',NULL,'2025-11-29 05:36:45',NULL,NULL),(130,NULL,'ddfba209f22b4ff4aaf57886b3bb4fd9',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:36:46',NULL,'2025-11-29 05:36:46',NULL,NULL),(131,NULL,NULL,'a4424c7045fc406f952e2f3e8c8d08cc',NULL,NULL,NULL,NULL,'2025-11-29 05:36:49',NULL,'2025-11-29 05:36:49',NULL,NULL),(132,NULL,'01470bf5e5fb4dcd871c9ba5f92f3860',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:36:50',NULL,'2025-11-29 05:36:50',NULL,NULL),(133,NULL,NULL,'1bd54386e718410d8fcc49da24f416ec',NULL,NULL,NULL,NULL,'2025-11-29 05:36:50',NULL,'2025-11-29 05:36:50',NULL,NULL),(134,NULL,NULL,'067e0d98a1ff4ad18ded8705f40cc5b7',NULL,NULL,NULL,NULL,'2025-11-29 05:36:52',NULL,'2025-11-29 05:36:52',NULL,NULL),(135,NULL,NULL,'71571d45a40d42c99b35f833fb40a0d0',NULL,NULL,NULL,NULL,'2025-11-29 05:36:52',NULL,'2025-11-29 05:36:52',NULL,NULL),(136,NULL,NULL,'9b2862373bbf44779eeacbfbcfe988ee',NULL,NULL,NULL,NULL,'2025-11-29 05:36:52',NULL,'2025-11-29 05:36:52',NULL,NULL),(137,NULL,'6e38d1b8c5b94dd38c2f79ac4f21459a',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:36:53',NULL,'2025-11-29 05:36:53',NULL,NULL),(138,NULL,NULL,'6c79efccd5e949dba16681088657b988',NULL,NULL,NULL,NULL,'2025-11-29 05:36:54',NULL,'2025-11-29 05:36:54',NULL,NULL),(139,NULL,NULL,'ba5551cc65b449f09ab1e21e5fa47748',NULL,NULL,NULL,NULL,'2025-11-29 05:36:54',NULL,'2025-11-29 05:36:54',NULL,NULL),(140,NULL,NULL,'4cefe435125f4a5582446b22a53ac79f',NULL,NULL,NULL,NULL,'2025-11-29 05:36:54',NULL,'2025-11-29 05:36:54',NULL,NULL),(141,NULL,'e71115dd6a34462ea449d45b4f5536b3',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:36:54',NULL,'2025-11-29 05:36:54',NULL,NULL),(142,NULL,'0c1d652029574d0fa397d5399235f790',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:36:56',NULL,'2025-11-29 05:36:56',NULL,NULL),(143,NULL,'8bcf4a76f07043a3b8b0706b8395b281',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:36:56',NULL,'2025-11-29 05:36:56',NULL,NULL),(144,NULL,'4ebe049df4f04fa2a5f37dadb54a1497',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:36:57',NULL,'2025-11-29 05:36:57',NULL,NULL),(145,NULL,'7e9f4963df0f4f278d5f4df67e6d667c',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:36:58',NULL,'2025-11-29 05:36:58',NULL,NULL),(146,NULL,NULL,'df986af3d0c84127a1e3fbaab7aaf38b',NULL,NULL,NULL,NULL,'2025-11-29 05:36:58',NULL,'2025-11-29 05:36:58',NULL,NULL),(147,NULL,'c48d0a2145674172882133c87bb61929',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:37:00',NULL,'2025-11-29 05:37:00',NULL,NULL),(148,NULL,NULL,'c3c3d2ec20f74ac7bdf82f3630bd79b5',NULL,NULL,NULL,NULL,'2025-11-29 05:37:00',NULL,'2025-11-29 05:37:00',NULL,NULL),(149,NULL,'731b7b23986d414991eca6ecc8f4f152',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:37:02',NULL,'2025-11-29 05:37:02',NULL,NULL),(150,NULL,NULL,'9f3eed2f08e4483cb1a8ae072e43e945',NULL,NULL,NULL,NULL,'2025-11-29 05:37:05',NULL,'2025-11-29 05:37:05',NULL,NULL),(151,NULL,'82dc592181b041859bf6a68cf286fc82',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:37:07',NULL,'2025-11-29 05:37:07',NULL,NULL),(152,NULL,NULL,'f8bd98b8280e4d2f99f12a94439c37cb',NULL,NULL,NULL,NULL,'2025-11-29 05:37:09',NULL,'2025-11-29 05:37:09',NULL,NULL),(153,NULL,NULL,'db5d648f1f4f48ae9f4217e943e2c5b2',NULL,NULL,NULL,NULL,'2025-11-29 05:37:10',NULL,'2025-11-29 05:37:10',NULL,NULL),(154,NULL,NULL,'9b47a3a384fd4c5f8527513dd6e95192',NULL,NULL,NULL,NULL,'2025-11-29 05:37:10',NULL,'2025-11-29 05:37:10',NULL,NULL),(155,NULL,NULL,'40983da03a784eaebe6e91f65f05c898',NULL,NULL,NULL,NULL,'2025-11-29 05:37:10',NULL,'2025-11-29 05:37:10',NULL,NULL),(156,NULL,NULL,'4eb35b6c0db24e069782d0b4fed3e2fe',NULL,NULL,NULL,NULL,'2025-11-29 05:37:10',NULL,'2025-11-29 05:37:10',NULL,NULL),(157,NULL,'f5dc6779251d425fa9b08a8c923ecaac',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:37:12',NULL,'2025-11-29 05:37:12',NULL,NULL),(158,NULL,NULL,'26c05bae74e84e93a6448d0d1c0e707e',NULL,NULL,NULL,NULL,'2025-11-29 05:37:12',NULL,'2025-11-29 05:37:12',NULL,NULL),(159,NULL,'dc20355c213b47fd8cc6abcb1dec8e69',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:37:13',NULL,'2025-11-29 05:37:13',NULL,NULL),(160,NULL,'4debc14b81164a5e91028657eb7e2f9d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:37:14',NULL,'2025-11-29 05:37:14',NULL,NULL),(161,NULL,'883530c38e954d818c0c7e7a75eaf2e2',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:37:14',NULL,'2025-11-29 05:37:14',NULL,NULL),(162,NULL,'44cbf199e9234250a1814295aa8cca3e',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:37:15',NULL,'2025-11-29 05:37:15',NULL,NULL),(163,NULL,NULL,'c137c6e1ac7f469f9c4483dd53883c2d',NULL,NULL,NULL,NULL,'2025-11-29 05:37:22',NULL,'2025-11-29 05:37:22',NULL,NULL),(164,NULL,'f5d6fcc020694561b091889318c2561b',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:37:23',NULL,'2025-11-29 05:37:23',NULL,NULL),(165,NULL,NULL,'161e6fcaf5cd40eb9f668c66c7f013f1',NULL,NULL,NULL,NULL,'2025-11-29 05:37:25',NULL,'2025-11-29 05:37:25',NULL,NULL),(166,NULL,NULL,'d77f33e5f83b46d0a66fd3d5f2a35ad0',NULL,NULL,NULL,NULL,'2025-11-29 05:37:25',NULL,'2025-11-29 05:37:25',NULL,NULL),(167,NULL,NULL,'47fc325afb2945808a210699c6ba049b',NULL,NULL,NULL,NULL,'2025-11-29 05:37:25',NULL,'2025-11-29 05:37:25',NULL,NULL),(168,NULL,NULL,'e4decfc8b6a44b6595c222233cc926f6',NULL,NULL,NULL,NULL,'2025-11-29 05:37:25',NULL,'2025-11-29 05:37:25',NULL,NULL),(169,NULL,'cfd4cf9893fc4ba387943fea5a9a56b8',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:37:27',NULL,'2025-11-29 05:37:27',NULL,NULL),(170,NULL,'18a45827d98a489a902f5dbcfb422b2d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:37:27',NULL,'2025-11-29 05:37:27',NULL,NULL),(171,NULL,'035cd80a573a4f3aafc93864a5491c13',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:37:30',NULL,'2025-11-29 05:37:30',NULL,NULL),(172,NULL,NULL,'47d4a351853e4f78aa399cd756110c41',NULL,NULL,NULL,NULL,'2025-11-29 05:37:35',NULL,'2025-11-29 05:37:35',NULL,NULL),(173,NULL,NULL,'4522755852d94dd7bbf637007ec21bf0',NULL,NULL,NULL,NULL,'2025-11-29 05:37:37',NULL,'2025-11-29 05:37:37',NULL,NULL),(174,NULL,'ecd2e5916bab4f7cb242a87ec782ffda',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:37:38',NULL,'2025-11-29 05:37:38',NULL,NULL),(175,NULL,NULL,'51b1ed57b3f7481c9aaa9c25bfee08c0',NULL,NULL,NULL,NULL,'2025-11-29 05:37:39',NULL,'2025-11-29 05:37:39',NULL,NULL),(176,NULL,NULL,'6f302d8b2ce6432d88104176766df360',NULL,NULL,NULL,NULL,'2025-11-29 05:37:39',NULL,'2025-11-29 05:37:39',NULL,NULL),(177,NULL,NULL,'50666b86734d49c5af44592381ccea21',NULL,NULL,NULL,NULL,'2025-11-29 05:37:39',NULL,'2025-11-29 05:37:39',NULL,NULL),(178,NULL,'d9e36e5977a74ec7b8f35b8697922a84',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:37:40',NULL,'2025-11-29 05:37:40',NULL,NULL),(179,NULL,NULL,'208e0a9985e34ac9bd2c8938ecdf69ee',NULL,NULL,NULL,NULL,'2025-11-29 05:37:41',NULL,'2025-11-29 05:37:41',NULL,NULL),(180,NULL,'bdf7fbdfb1744abcbd2d8b79bee5379b',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:37:41',NULL,'2025-11-29 05:37:41',NULL,NULL),(181,NULL,'26849b20660d4aea93717218b3be6cf0',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:37:42',NULL,'2025-11-29 05:37:42',NULL,NULL),(182,NULL,'bf0a414ac8f0488ba36c1cda2d6db15a',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:37:42',NULL,'2025-11-29 05:37:42',NULL,NULL),(183,NULL,NULL,'ab5746996d1249ca886518aa2a1f746a',NULL,NULL,NULL,NULL,'2025-11-29 05:37:44',NULL,'2025-11-29 05:37:44',NULL,NULL),(184,NULL,'c00cb6990f5f4356a802559594b4dc0f',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:37:46',NULL,'2025-11-29 05:37:46',NULL,NULL),(185,NULL,NULL,'8c22bf551bb64cf1b8720b968f252dfb',NULL,NULL,NULL,NULL,'2025-11-29 05:37:49',NULL,'2025-11-29 05:37:49',NULL,NULL),(186,NULL,'0f089e7b99514feb863b57182b00b8d2',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:37:50',NULL,'2025-11-29 05:37:50',NULL,NULL),(187,NULL,NULL,'4d75a7c3d41f4b0696693d05fb82daf2',NULL,NULL,NULL,NULL,'2025-11-29 05:37:52',NULL,'2025-11-29 05:37:52',NULL,NULL),(188,NULL,NULL,'ae0d2a4b8f3d478e8235b9dbe2b26c6b',NULL,NULL,NULL,NULL,'2025-11-29 05:37:53',NULL,'2025-11-29 05:37:53',NULL,NULL),(189,NULL,NULL,'5420544d13be4310a8a32043f9b7ab4d',NULL,NULL,NULL,NULL,'2025-11-29 05:37:53',NULL,'2025-11-29 05:37:53',NULL,NULL),(190,NULL,NULL,'92bbf8c09e7b4e21b35990d159d8bd83',NULL,NULL,NULL,NULL,'2025-11-29 05:37:53',NULL,'2025-11-29 05:37:53',NULL,NULL),(191,NULL,'88ea41f1eaaf4ed9b8f5335cd407f038',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:37:54',NULL,'2025-11-29 05:37:54',NULL,NULL),(192,NULL,'b5a6317600ac42ba9ed43da11fa18fa0',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:37:56',NULL,'2025-11-29 05:37:56',NULL,NULL),(193,NULL,'f6fcbad6247d48c28eb3ae887b3704b3',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:37:56',NULL,'2025-11-29 05:37:56',NULL,NULL),(194,NULL,NULL,'cb8386278a674ff7b9a9aed487bc6c8c',NULL,NULL,NULL,NULL,'2025-11-29 05:38:08',NULL,'2025-11-29 05:38:08',NULL,NULL),(195,NULL,NULL,'3e0f252f8cc84922a46c637bf75d9b12',NULL,NULL,NULL,NULL,'2025-11-29 05:38:10',NULL,'2025-11-29 05:38:10',NULL,NULL),(196,NULL,NULL,'483896f04b624632801669988fdce919',NULL,NULL,NULL,NULL,'2025-11-29 05:38:10',NULL,'2025-11-29 05:38:10',NULL,NULL),(197,NULL,NULL,'da8e5ead89f04198a235f632cc45e8c3',NULL,NULL,NULL,NULL,'2025-11-29 05:38:10',NULL,'2025-11-29 05:38:10',NULL,NULL),(198,NULL,'bf7ea2709c674f5da87071b7a3ab3ac1',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:38:13',NULL,'2025-11-29 05:38:13',NULL,NULL),(199,NULL,'48e204138f29480bbf6cf7b821766401',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:38:13',NULL,'2025-11-29 05:38:13',NULL,NULL),(200,NULL,'96b0010861f44328909e95cf77da2a62',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:38:14',NULL,'2025-11-29 05:38:14',NULL,NULL),(201,NULL,NULL,'7df88cc22a564c95884510c8f66852a3',NULL,NULL,NULL,NULL,'2025-11-29 05:38:16',NULL,'2025-11-29 05:38:16',NULL,NULL),(202,NULL,NULL,'ccdb283e70d7404484aebbf933741632',NULL,NULL,NULL,NULL,'2025-11-29 05:38:17',NULL,'2025-11-29 05:38:17',NULL,NULL),(203,NULL,'85c901553ffa498396c7efe639bd4583',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:38:18',NULL,'2025-11-29 05:38:18',NULL,NULL),(204,NULL,NULL,'22223c42f07244b596d44f9ca16e006c',NULL,NULL,NULL,NULL,'2025-11-29 05:38:20',NULL,'2025-11-29 05:38:20',NULL,NULL),(205,NULL,NULL,'6de51f96bd584575956b19290f27af8f',NULL,NULL,NULL,NULL,'2025-11-29 05:38:21',NULL,'2025-11-29 05:38:21',NULL,NULL),(206,NULL,NULL,'b05da9eb3070496ea93a646548c5f060',NULL,NULL,NULL,NULL,'2025-11-29 05:38:22',NULL,'2025-11-29 05:38:22',NULL,NULL),(207,NULL,NULL,'fc0f6040bbee43ad909feb84c7a2fe71',NULL,NULL,NULL,NULL,'2025-11-29 05:38:22',NULL,'2025-11-29 05:38:22',NULL,NULL),(208,NULL,'7bad657fb48b4b6aac16eee6fc117e08',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:38:22',NULL,'2025-11-29 05:38:22',NULL,NULL),(209,NULL,'e16c063834b240ad948fe16465cb4e51',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:38:23',NULL,'2025-11-29 05:38:23',NULL,NULL),(210,NULL,'c20204f479724214bcb381e37a62d684',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:38:25',NULL,'2025-11-29 05:38:25',NULL,NULL),(211,NULL,'e577c04bfe1b459f9aebd0f826827833',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:38:26',NULL,'2025-11-29 05:38:26',NULL,NULL),(212,NULL,NULL,'9c9e0bb48f5e46d5951e33b126915405',NULL,NULL,NULL,NULL,'2025-11-29 05:38:36',NULL,'2025-11-29 05:38:36',NULL,NULL),(213,NULL,NULL,'32a388e3f3e241ffb7aa37e8bb62baba',NULL,NULL,NULL,NULL,'2025-11-29 05:38:40',NULL,'2025-11-29 05:38:40',NULL,NULL),(214,NULL,NULL,'bbe7e41305824befac1f947febcf6e8d',NULL,NULL,NULL,NULL,'2025-11-29 05:38:41',NULL,'2025-11-29 05:38:41',NULL,NULL),(215,NULL,NULL,'b3280f330ffc41bda59f2ec341e447c0',NULL,NULL,NULL,NULL,'2025-11-29 05:38:41',NULL,'2025-11-29 05:38:41',NULL,NULL),(216,NULL,'c6f40581eb744cef98cff1a872843b14',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:38:42',NULL,'2025-11-29 05:38:42',NULL,NULL),(217,NULL,NULL,'0b8147950f014f008c36df54d8368019',NULL,NULL,NULL,NULL,'2025-11-29 05:38:43',NULL,'2025-11-29 05:38:43',NULL,NULL),(218,NULL,'59e233625b344189ba60f616992e512b',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:38:43',NULL,'2025-11-29 05:38:43',NULL,NULL),(219,NULL,NULL,'40461bcceb79486685576e03cd6143f7',NULL,NULL,NULL,NULL,'2025-11-29 05:38:44',NULL,'2025-11-29 05:38:44',NULL,NULL),(220,NULL,NULL,'4d862b24a33c4b82b608866944b1e2e5',NULL,NULL,NULL,NULL,'2025-11-29 05:38:44',NULL,'2025-11-29 05:38:44',NULL,NULL),(221,NULL,NULL,'ed9acc29a3e3496d84f38aa615c16e30',NULL,NULL,NULL,NULL,'2025-11-29 05:38:44',NULL,'2025-11-29 05:38:44',NULL,NULL),(222,NULL,'ae2a6e9fbea0426ebacf2fe56abb903e',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:38:44',NULL,'2025-11-29 05:38:44',NULL,NULL),(223,NULL,'bde0f89de7a5405e8d086a6415adbc5c',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:38:46',NULL,'2025-11-29 05:38:46',NULL,NULL),(224,NULL,'56ca6438a1ce444b9a0068149a96fba7',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:38:47',NULL,'2025-11-29 05:38:47',NULL,NULL),(225,NULL,'d6d702b9257640e9ae95d3b78ac1e623',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:38:48',NULL,'2025-11-29 05:38:48',NULL,NULL),(226,NULL,NULL,'0225635bc04140d1b82069f9d38cdc27',NULL,NULL,NULL,NULL,'2025-11-29 05:38:50',NULL,'2025-11-29 05:38:50',NULL,NULL),(227,NULL,NULL,'116774de87694898ba2a8d06c7ac7069',NULL,NULL,NULL,NULL,'2025-11-29 05:38:51',NULL,'2025-11-29 05:38:51',NULL,NULL),(228,NULL,NULL,'042b1e3b64c1444aaaf258abf6993865',NULL,NULL,NULL,NULL,'2025-11-29 05:38:51',NULL,'2025-11-29 05:38:51',NULL,NULL),(229,NULL,NULL,'9a169c12e24a428eb9de96579b83c947',NULL,NULL,NULL,NULL,'2025-11-29 05:38:51',NULL,'2025-11-29 05:38:51',NULL,NULL),(230,NULL,'352a7d8defe34a3486f41ba56e48d88e',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:38:53',NULL,'2025-11-29 05:38:53',NULL,NULL),(231,NULL,'f961834cbc3e439f931aa34e9b1bfb5d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:38:54',NULL,'2025-11-29 05:38:54',NULL,NULL),(232,NULL,'0729e4f41a8346198e8cb057eba4c265',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:38:56',NULL,'2025-11-29 05:38:56',NULL,NULL),(233,NULL,NULL,'8c948d7068bc4b79a613309ed29f2263',NULL,NULL,NULL,NULL,'2025-11-29 05:38:57',NULL,'2025-11-29 05:38:57',NULL,NULL),(234,NULL,NULL,'fdacab77e0dd484ebecce8006e9ec2e6',NULL,NULL,NULL,NULL,'2025-11-29 05:38:58',NULL,'2025-11-29 05:38:58',NULL,NULL),(235,NULL,NULL,'4c570bb0056a4ec187c232aefa3dac00',NULL,NULL,NULL,NULL,'2025-11-29 05:38:58',NULL,'2025-11-29 05:38:58',NULL,NULL),(236,NULL,NULL,'f187c2e670a64659b201af106a8e3cf6',NULL,NULL,NULL,NULL,'2025-11-29 05:38:58',NULL,'2025-11-29 05:38:58',NULL,NULL),(237,NULL,NULL,'75ba96bc120e43c7bdebafea744cb884',NULL,NULL,NULL,NULL,'2025-11-29 05:38:58',NULL,'2025-11-29 05:38:58',NULL,NULL),(238,NULL,'6090d862fcf74b499396021840a27e4d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:39:00',NULL,'2025-11-29 05:39:00',NULL,NULL),(239,NULL,'64811d72946649cda025931c7f3e39be',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:39:01',NULL,'2025-11-29 05:39:01',NULL,NULL),(240,NULL,'ccfd45bf10274d96ab66524bcb6beaae',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:39:02',NULL,'2025-11-29 05:39:02',NULL,NULL),(241,NULL,NULL,'18ebde6642cb44c1bd4ab1e5fa932abd',NULL,NULL,NULL,NULL,'2025-11-29 05:39:05',NULL,'2025-11-29 05:39:05',NULL,NULL),(242,NULL,NULL,'7cc322ad7e4f4a5e9672c26961df480c',NULL,NULL,NULL,NULL,'2025-11-29 05:39:05',NULL,'2025-11-29 05:39:05',NULL,NULL),(243,NULL,NULL,'15ba52188baf48119fe9785b384310b6',NULL,NULL,NULL,NULL,'2025-11-29 05:39:06',NULL,'2025-11-29 05:39:06',NULL,NULL),(244,NULL,NULL,'d1f706f5078d4b75941c1d3ccc4d7ea4',NULL,NULL,NULL,NULL,'2025-11-29 05:39:07',NULL,'2025-11-29 05:39:07',NULL,NULL),(245,NULL,'177e0fe42e604553bd3b076a784b5e9d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:39:10',NULL,'2025-11-29 05:39:10',NULL,NULL),(246,NULL,'8ff7203fef7a4234b1f99a3ef6c3fa5c',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:39:11',NULL,'2025-11-29 05:39:11',NULL,NULL),(247,NULL,'515b5fd3d00a4a9b97744fb3c209962d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:39:12',NULL,'2025-11-29 05:39:12',NULL,NULL),(248,NULL,NULL,'d74866c97043438a81b4351427ff09ec',NULL,NULL,NULL,NULL,'2025-11-29 05:39:13',NULL,'2025-11-29 05:39:13',NULL,NULL),(249,NULL,NULL,'a01d19301da54be1a36bb915552346a7',NULL,NULL,NULL,NULL,'2025-11-29 05:39:13',NULL,'2025-11-29 05:39:13',NULL,NULL),(250,NULL,NULL,'6bb380b85f054d16ac066ab6ea1e4f89',NULL,NULL,NULL,NULL,'2025-11-29 05:39:13',NULL,'2025-11-29 05:39:13',NULL,NULL),(251,NULL,'96790676f7be41c7bf96036d7e07ffb2',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:39:15',NULL,'2025-11-29 05:39:15',NULL,NULL),(252,NULL,'01550072094c4ef2a079888472eb2ead',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:39:16',NULL,'2025-11-29 05:39:16',NULL,NULL),(253,NULL,NULL,'ca6fb06240aa43399e15d8661b210c08',NULL,NULL,NULL,NULL,'2025-11-29 05:39:17',NULL,'2025-11-29 05:39:17',NULL,NULL),(254,NULL,NULL,'7c3d8833d05d4bf390d26a0d13474f8e',NULL,NULL,NULL,NULL,'2025-11-29 05:39:17',NULL,'2025-11-29 05:39:17',NULL,NULL),(255,NULL,NULL,'f36deeaaf2fc4d309d5f75f790441b49',NULL,NULL,NULL,NULL,'2025-11-29 05:39:17',NULL,'2025-11-29 05:39:17',NULL,NULL),(256,NULL,'c15f7da5fa794f70899175141d3efb07',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:39:17',NULL,'2025-11-29 05:39:17',NULL,NULL),(257,NULL,NULL,'be3bdcc842004e6fb1c837c92e2c1864',NULL,NULL,NULL,NULL,'2025-11-29 05:39:17',NULL,'2025-11-29 05:39:17',NULL,NULL),(258,NULL,'c88b1d1a85f2487caf539f9b55034005',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:39:19',NULL,'2025-11-29 05:39:19',NULL,NULL),(259,NULL,'6338783eb5264394b9c58c47036a551f',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:39:20',NULL,'2025-11-29 05:39:20',NULL,NULL),(260,NULL,'256307353f574552b3e817697d3124dd',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:39:21',NULL,'2025-11-29 05:39:21',NULL,NULL),(261,NULL,NULL,'99c4b856c6fa452b8782cfb49f32d4f9',NULL,NULL,NULL,NULL,'2025-11-29 05:39:25',NULL,'2025-11-29 05:39:25',NULL,NULL),(262,NULL,'423449a1e9f94864bc4aa1e26a05fb40',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:39:27',NULL,'2025-11-29 05:39:27',NULL,NULL),(263,NULL,NULL,'0489b8a14f1e429798fc0e1e475508a5',NULL,NULL,NULL,NULL,'2025-11-29 05:39:51',NULL,'2025-11-29 05:39:51',NULL,NULL),(264,NULL,NULL,'0cb50441bd6144cda55fbe51a4e87bce',NULL,NULL,NULL,NULL,'2025-11-29 05:40:05',NULL,'2025-11-29 05:40:05',NULL,NULL),(265,NULL,NULL,'0c6e9b2461674033bb2bc78333ea80e6',NULL,NULL,NULL,NULL,'2025-11-29 05:40:06',NULL,'2025-11-29 05:40:06',NULL,NULL),(266,NULL,NULL,'380b62a07e7f41659a63b3ac48a4d4e0',NULL,NULL,NULL,NULL,'2025-11-29 05:40:06',NULL,'2025-11-29 05:40:06',NULL,NULL),(267,NULL,'49f85bf88a7641b492d9ed0e3cbb7c9c',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:40:09',NULL,'2025-11-29 05:40:09',NULL,NULL),(268,NULL,'66cf92c8ed6341ae8c50e42096ef2baa',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:40:10',NULL,'2025-11-29 05:40:10',NULL,NULL),(269,NULL,'9bbed9ba793046af868fc18679f55687',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:40:11',NULL,'2025-11-29 05:40:11',NULL,NULL),(270,NULL,NULL,'c695b2d2e4cb4f1885cf11b85217da9f',NULL,NULL,NULL,NULL,'2025-11-29 05:40:18',NULL,'2025-11-29 05:40:18',NULL,NULL),(271,NULL,NULL,'7b99e4a240a9489d9a1c6b3dd9e23df1',NULL,NULL,NULL,NULL,'2025-11-29 05:40:19',NULL,'2025-11-29 05:40:19',NULL,NULL),(272,NULL,NULL,'0c595ae0376942a2b367414fb89855fe',NULL,NULL,NULL,NULL,'2025-11-29 05:40:19',NULL,'2025-11-29 05:40:19',NULL,NULL),(273,NULL,NULL,'8fa945af4d3a462c8618df791ee08253',NULL,NULL,NULL,NULL,'2025-11-29 05:40:19',NULL,'2025-11-29 05:40:19',NULL,NULL),(274,NULL,'089ea8368e4142af9119ff70fa57db2b',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:40:21',NULL,'2025-11-29 05:40:21',NULL,NULL),(275,NULL,'56f82e0d278b4d36a881fcc79e372e79',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:40:22',NULL,'2025-11-29 05:40:22',NULL,NULL),(276,NULL,'2432c157c67347af9cc60b83d194cc92',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:40:23',NULL,'2025-11-29 05:40:23',NULL,NULL),(277,NULL,NULL,'6b3921bb991747e8902fe5f1fe503f38',NULL,NULL,NULL,NULL,'2025-11-29 05:40:28',NULL,'2025-11-29 05:40:28',NULL,NULL),(278,NULL,NULL,'fdf84162375e43c1882496810cb69f6d',NULL,NULL,NULL,NULL,'2025-11-29 05:40:28',NULL,'2025-11-29 05:40:28',NULL,NULL),(279,NULL,NULL,'d03f7b23a91648fc985ffb356cc04f1d',NULL,NULL,NULL,NULL,'2025-11-29 05:40:32',NULL,'2025-11-29 05:40:32',NULL,NULL),(280,NULL,NULL,'314ebe0d4a1d4ff0ac8a28c0c7b4c6c6',NULL,NULL,NULL,NULL,'2025-11-29 05:40:32',NULL,'2025-11-29 05:40:32',NULL,NULL),(281,NULL,NULL,'4232a6137a5148fcaa305b10f15ee4ab',NULL,NULL,NULL,NULL,'2025-11-29 05:40:32',NULL,'2025-11-29 05:40:32',NULL,NULL),(282,NULL,'04692037f3ec40ceb506c0e84fe73829',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:40:34',NULL,'2025-11-29 05:40:34',NULL,NULL),(283,NULL,NULL,'f8d1f724766f47c0a9a150c6e3fb1c83',NULL,NULL,NULL,NULL,'2025-11-29 05:40:34',NULL,'2025-11-29 05:40:34',NULL,NULL),(284,NULL,'14efe644b68c404d9a8c9684f0a3a126',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:40:35',NULL,'2025-11-29 05:40:35',NULL,NULL),(285,NULL,NULL,'6b29bd6ef300472cad86c5c5a7341f17',NULL,NULL,NULL,NULL,'2025-11-29 05:40:35',NULL,'2025-11-29 05:40:35',NULL,NULL),(286,NULL,NULL,'00d2f2383f7640baa06d69fbdc6c4ae8',NULL,NULL,NULL,NULL,'2025-11-29 05:40:35',NULL,'2025-11-29 05:40:35',NULL,NULL),(287,NULL,NULL,'0c5af7c454b446cd89b667fa1fa15029',NULL,NULL,NULL,NULL,'2025-11-29 05:40:35',NULL,'2025-11-29 05:40:35',NULL,NULL),(288,NULL,NULL,'09ece357bc62430da4edc84fceaa0020',NULL,NULL,NULL,NULL,'2025-11-29 05:40:35',NULL,'2025-11-29 05:40:35',NULL,NULL),(289,NULL,NULL,'f0f48ede370b4632ab7b21cc94cfb7ff',NULL,NULL,NULL,NULL,'2025-11-29 05:40:35',NULL,'2025-11-29 05:40:35',NULL,NULL),(290,NULL,'a05f740db7b94303aac90d6f217f853a',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:40:36',NULL,'2025-11-29 05:40:36',NULL,NULL),(291,NULL,NULL,'c85de262cfc247da8105b2532c2985b9',NULL,NULL,NULL,NULL,'2025-11-29 05:40:36',NULL,'2025-11-29 05:40:36',NULL,NULL),(292,NULL,'56f0daef777140feb25a7899d796ea6f',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:40:36',NULL,'2025-11-29 05:40:36',NULL,NULL),(293,NULL,'51a89acabcf7441285c9e682bbf1a54c',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:40:38',NULL,'2025-11-29 05:40:38',NULL,NULL),(294,NULL,'96857e43ebcb4e019650999b54e535a1',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:40:38',NULL,'2025-11-29 05:40:38',NULL,NULL),(295,NULL,NULL,'a0f1e714fbec450395a7fdccce008b46',NULL,NULL,NULL,NULL,'2025-11-29 05:40:39',NULL,'2025-11-29 05:40:39',NULL,NULL),(296,NULL,NULL,'378104e860b74324bf96c1b6fb6c9c38',NULL,NULL,NULL,NULL,'2025-11-29 05:40:39',NULL,'2025-11-29 05:40:39',NULL,NULL),(297,NULL,NULL,'9c3bea64b4f24e82b046ce22acf1b2d5',NULL,NULL,NULL,NULL,'2025-11-29 05:40:40',NULL,'2025-11-29 05:40:40',NULL,NULL),(298,NULL,'9dfe067956144a80b55506e36be6b896',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:40:41',NULL,'2025-11-29 05:40:41',NULL,NULL),(299,NULL,'29b9721837294cd39d8b4e52bbe18196',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:40:41',NULL,'2025-11-29 05:40:41',NULL,NULL),(300,NULL,'5dd620782ecb48b9af309e8bc536acb2',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:40:43',NULL,'2025-11-29 05:40:43',NULL,NULL),(301,NULL,NULL,'ac0b18a898c7459da335489d13ce6891',NULL,NULL,NULL,NULL,'2025-11-29 05:40:44',NULL,'2025-11-29 05:40:44',NULL,NULL),(302,NULL,NULL,'005e1425ac15494985399cc2e9e6b0be',NULL,NULL,NULL,NULL,'2025-11-29 05:40:44',NULL,'2025-11-29 05:40:44',NULL,NULL),(303,NULL,NULL,'03a01eac59d041cbac695a98de7446af',NULL,NULL,NULL,NULL,'2025-11-29 05:40:44',NULL,'2025-11-29 05:40:44',NULL,NULL),(304,NULL,'b6fbd26e87a649ef8a1685512e46f501',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:40:45',NULL,'2025-11-29 05:40:45',NULL,NULL),(305,NULL,'ed4193e9f6ac419dbc7724186fe340ce',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:40:46',NULL,'2025-11-29 05:40:46',NULL,NULL),(306,NULL,'18b9c5d42fe44b0bb55db0fe5468430c',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:40:47',NULL,'2025-11-29 05:40:47',NULL,NULL),(307,NULL,NULL,'6544e1bd3e6f4499bcb323e4cb91c0ea',NULL,NULL,NULL,NULL,'2025-11-29 05:40:48',NULL,'2025-11-29 05:40:48',NULL,NULL),(308,NULL,NULL,'4c38bc7696b64adc89192b4d1d95e7a6',NULL,NULL,NULL,NULL,'2025-11-29 05:40:49',NULL,'2025-11-29 05:40:49',NULL,NULL),(309,NULL,NULL,'39b539fc8f6747a796340835f32e2728',NULL,NULL,NULL,NULL,'2025-11-29 05:40:49',NULL,'2025-11-29 05:40:49',NULL,NULL),(310,NULL,NULL,'598ecf67009143288ef62c864afda846',NULL,NULL,NULL,NULL,'2025-11-29 05:40:49',NULL,'2025-11-29 05:40:49',NULL,NULL),(311,NULL,'5d4e7782d4324d9996f85cc9d1ed8e57',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:40:51',NULL,'2025-11-29 05:40:51',NULL,NULL),(312,NULL,'6658c898d3034b88bf28bd346f41dc08',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:40:52',NULL,'2025-11-29 05:40:52',NULL,NULL),(313,NULL,'5340986d20d2467d9a13f704de933665',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:40:52',NULL,'2025-11-29 05:40:52',NULL,NULL),(314,NULL,NULL,'cfc5e388f22b4a239b91588843bff0dc',NULL,NULL,NULL,NULL,'2025-11-29 05:41:00',NULL,'2025-11-29 05:41:00',NULL,NULL),(315,NULL,NULL,'d398b490db83489591c69a3c596fa374',NULL,NULL,NULL,NULL,'2025-11-29 05:41:02',NULL,'2025-11-29 05:41:02',NULL,NULL),(316,NULL,NULL,'182943692d4145818799bbfad53c744e',NULL,NULL,NULL,NULL,'2025-11-29 05:41:02',NULL,'2025-11-29 05:41:02',NULL,NULL),(317,NULL,NULL,'142d3f0d6e1344889a2501ad3d71408d',NULL,NULL,NULL,NULL,'2025-11-29 05:41:02',NULL,'2025-11-29 05:41:02',NULL,NULL),(318,NULL,'9874b59670af413eabb2bba650c69242',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:41:03',NULL,'2025-11-29 05:41:03',NULL,NULL),(319,NULL,'5906dcffa10f4d31a5181fa39c48aadf',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:41:05',NULL,'2025-11-29 05:41:05',NULL,NULL),(320,NULL,'1cc9a205893945af9032a184f9f2d2b1',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:41:06',NULL,'2025-11-29 05:41:06',NULL,NULL),(321,NULL,NULL,'1aa3d76554be40109673e3660afdcef9',NULL,NULL,NULL,NULL,'2025-11-29 05:41:13',NULL,'2025-11-29 05:41:13',NULL,NULL),(322,NULL,NULL,'e56807404f594d2397401f8e0e2c9fbc',NULL,NULL,NULL,NULL,'2025-11-29 05:41:14',NULL,'2025-11-29 05:41:14',NULL,NULL),(323,NULL,NULL,'7eb0eac56c2b42ad9dd47ebfe79cbc30',NULL,NULL,NULL,NULL,'2025-11-29 05:41:14',NULL,'2025-11-29 05:41:14',NULL,NULL),(324,NULL,NULL,'effdae7be0d44208a5be8f46e78b1f00',NULL,NULL,NULL,NULL,'2025-11-29 05:41:14',NULL,'2025-11-29 05:41:14',NULL,NULL),(325,NULL,NULL,'e12090a6defa45dc829719ea46d44d4e',NULL,NULL,NULL,NULL,'2025-11-29 05:41:14',NULL,'2025-11-29 05:41:14',NULL,NULL),(326,NULL,'4d3c4eb0bcce4aec9fe2bc88309fe6bc',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:41:15',NULL,'2025-11-29 05:41:15',NULL,NULL),(327,NULL,'6241e4020661498bbc375b6e0c2b6bf6',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:41:16',NULL,'2025-11-29 05:41:16',NULL,NULL),(328,NULL,'a52eb78913924667ade285ea7abcbf95',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:41:16',NULL,'2025-11-29 05:41:16',NULL,NULL),(329,NULL,NULL,'ea27d7612aa34955a6fb1f29750c8921',NULL,NULL,NULL,NULL,'2025-11-29 05:41:21',NULL,'2025-11-29 05:41:21',NULL,NULL),(330,NULL,NULL,'ca185ad443b1461abddd5a1efc9bbc88',NULL,NULL,NULL,NULL,'2025-11-29 05:41:22',NULL,'2025-11-29 05:41:22',NULL,NULL),(331,NULL,NULL,'c6f05effc87e4cc1a0cd7feeb4d32ce3',NULL,NULL,NULL,NULL,'2025-11-29 05:41:22',NULL,'2025-11-29 05:41:22',NULL,NULL),(332,NULL,'accfdbad1bd249cb8b08137faead87a9',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:41:23',NULL,'2025-11-29 05:41:23',NULL,NULL),(333,NULL,'837f2bfa5aab4fdabd09b7661c70b7dd',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:41:24',NULL,'2025-11-29 05:41:24',NULL,NULL),(334,NULL,'337194ba1a9f4bb1af137163fc36c29e',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:41:24',NULL,'2025-11-29 05:41:24',NULL,NULL),(335,NULL,NULL,'8e2f733a2b9a48f2a4f50890c50b54ac',NULL,NULL,NULL,NULL,'2025-11-29 05:41:31',NULL,'2025-11-29 05:41:31',NULL,NULL),(336,NULL,NULL,'bbb58696bf9443cd871fef255f50b012',NULL,NULL,NULL,NULL,'2025-11-29 05:41:32',NULL,'2025-11-29 05:41:32',NULL,NULL),(337,NULL,NULL,'e4d2d18fdb14465eacc082349a6e10a9',NULL,NULL,NULL,NULL,'2025-11-29 05:41:39',NULL,'2025-11-29 05:41:39',NULL,NULL),(338,NULL,NULL,'a1518de8242240fcadd7e2518e3c18d4',NULL,NULL,NULL,NULL,'2025-11-29 05:41:39',NULL,'2025-11-29 05:41:39',NULL,NULL),(339,NULL,NULL,'7871b8088a2b4ac7979625fb04752a30',NULL,NULL,NULL,NULL,'2025-11-29 05:41:39',NULL,'2025-11-29 05:41:39',NULL,NULL),(340,NULL,'e8fd949fb8c145f986f31201d845273d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:41:41',NULL,'2025-11-29 05:41:41',NULL,NULL),(341,NULL,'9a52123ce76f4b22901c3b230e84c1c0',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:41:42',NULL,'2025-11-29 05:41:42',NULL,NULL),(342,NULL,'d26079c7d6c8427193b3786b26cb5b7e',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:41:43',NULL,'2025-11-29 05:41:43',NULL,NULL),(343,NULL,NULL,'f33c8cd93bfb451cb06212731cbb3a46',NULL,NULL,NULL,NULL,'2025-11-29 05:41:46',NULL,'2025-11-29 05:41:46',NULL,NULL),(344,NULL,NULL,'ee35284df12f4f4fad5f92cf5c9ec4e2',NULL,NULL,NULL,NULL,'2025-11-29 05:41:46',NULL,'2025-11-29 05:41:46',NULL,NULL),(345,NULL,NULL,'48349903bcb54b78bfbbb59453a664f7',NULL,NULL,NULL,NULL,'2025-11-29 05:41:47',NULL,'2025-11-29 05:41:47',NULL,NULL),(346,NULL,'4e135fffa1e64bf8b2e43bd33b51cf15',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:41:49',NULL,'2025-11-29 05:41:49',NULL,NULL),(347,NULL,'e97b8963e55a4094b1cb702d19d887ba',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:41:51',NULL,'2025-11-29 05:41:51',NULL,NULL),(348,NULL,'88dd2ed0a66c4f19864235643129f3ec',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:41:52',NULL,'2025-11-29 05:41:52',NULL,NULL),(349,NULL,NULL,'8e913291cb294e5bb001b6c370918915',NULL,NULL,NULL,NULL,'2025-11-29 05:41:54',NULL,'2025-11-29 05:41:54',NULL,NULL),(350,NULL,'2f537475fe3d4f59af3dea376be3501d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:41:59',NULL,'2025-11-29 05:41:59',NULL,NULL),(351,NULL,NULL,'ed4f3e8dfd6147fab0406f423cc172c3',NULL,NULL,NULL,NULL,'2025-11-29 05:42:03',NULL,'2025-11-29 05:42:03',NULL,NULL),(352,NULL,NULL,'cb9af56dd4164f8eab87377e910fc6ba',NULL,NULL,NULL,NULL,'2025-11-29 05:42:03',NULL,'2025-11-29 05:42:03',NULL,NULL),(353,NULL,NULL,'fc8581368c174ec6b77aa38b1151d7ad',NULL,NULL,NULL,NULL,'2025-11-29 05:42:03',NULL,'2025-11-29 05:42:03',NULL,NULL),(354,NULL,NULL,'82ed7c8dc2c3461c87b2122ee81ce915',NULL,NULL,NULL,NULL,'2025-11-29 05:42:03',NULL,'2025-11-29 05:42:03',NULL,NULL),(355,NULL,'548be38e33c2460e90240223647d530b',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:42:05',NULL,'2025-11-29 05:42:05',NULL,NULL),(356,NULL,'f46e29a48368451dbc43396bf6d5e004',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:42:06',NULL,'2025-11-29 05:42:06',NULL,NULL),(357,NULL,'fb6c9ada7fba4033ad1ffa704372e6c9',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:42:07',NULL,'2025-11-29 05:42:07',NULL,NULL),(358,NULL,NULL,'131f8c13a9c0429c9d0d2b322dac8ea8',NULL,NULL,NULL,NULL,'2025-11-29 05:42:16',NULL,'2025-11-29 05:42:16',NULL,NULL),(359,NULL,NULL,'cb8d9fe9ac8c4751bb6ac40883cce87b',NULL,NULL,NULL,NULL,'2025-11-29 05:42:17',NULL,'2025-11-29 05:42:17',NULL,NULL),(360,NULL,NULL,'3ef6956d5d144bd0b92bb29da49164cf',NULL,NULL,NULL,NULL,'2025-11-29 05:42:17',NULL,'2025-11-29 05:42:17',NULL,NULL),(361,NULL,NULL,'22d06ab428bc436284339b1a50b85e19',NULL,NULL,NULL,NULL,'2025-11-29 05:42:17',NULL,'2025-11-29 05:42:17',NULL,NULL),(362,NULL,'3fad71d060c7494aa7d4e367bd06b881',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:42:19',NULL,'2025-11-29 05:42:19',NULL,NULL),(363,NULL,'eeaea5e509ca49be9d6a48ac7d8668b4',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:42:21',NULL,'2025-11-29 05:42:21',NULL,NULL),(364,NULL,'e8c0eddc6a314a73bd3d6b6c22ea01c7',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:42:22',NULL,'2025-11-29 05:42:22',NULL,NULL),(365,NULL,NULL,'af91f2be0ad34dd795af321a91ed6e47',NULL,NULL,NULL,NULL,'2025-11-29 05:42:25',NULL,'2025-11-29 05:42:25',NULL,NULL),(366,NULL,'d8ec1959e8bb450793ca093172af99e3',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:42:26',NULL,'2025-11-29 05:42:26',NULL,NULL),(367,NULL,NULL,'8f91cf3f1df54db9a44dac791b57cacf',NULL,NULL,NULL,NULL,'2025-11-29 05:42:33',NULL,'2025-11-29 05:42:33',NULL,NULL),(368,NULL,NULL,'14f0fd18dbcb453388dee74588ff2bbe',NULL,NULL,NULL,NULL,'2025-11-29 05:42:33',NULL,'2025-11-29 05:42:33',NULL,NULL),(369,NULL,NULL,'2cffd7bf1c854f97b1dc52c7c5e45db3',NULL,NULL,NULL,NULL,'2025-11-29 05:42:33',NULL,'2025-11-29 05:42:33',NULL,NULL),(370,NULL,NULL,'9cf0ebd9b30740298c600b59177ab532',NULL,NULL,NULL,NULL,'2025-11-29 05:42:34',NULL,'2025-11-29 05:42:34',NULL,NULL),(371,NULL,'4f6620ca7bfe443da08dacd3f001400a',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:42:35',NULL,'2025-11-29 05:42:35',NULL,NULL),(372,NULL,'b92ffefa9af04ef0b79dfd7d72f376f9',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:42:36',NULL,'2025-11-29 05:42:36',NULL,NULL),(373,NULL,'969ad9c9fc1f4aec9c2cdd4ee4b8c745',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:42:37',NULL,'2025-11-29 05:42:37',NULL,NULL),(374,NULL,NULL,'e92da42c257f41d2a5cdcf2b40c1fc0f',NULL,NULL,NULL,NULL,'2025-11-29 05:42:50',NULL,'2025-11-29 05:42:50',NULL,NULL),(375,NULL,NULL,'57d43127ec324b2ab57d0bae7114c0b6',NULL,NULL,NULL,NULL,'2025-11-29 05:42:56',NULL,'2025-11-29 05:42:56',NULL,NULL),(376,NULL,NULL,'89edac5a76e841118f3aa700b37de873',NULL,NULL,NULL,NULL,'2025-11-29 05:42:57',NULL,'2025-11-29 05:42:57',NULL,NULL),(377,NULL,NULL,'c8b5dcbaa80e459fa4ec26cf7fc124cc',NULL,NULL,NULL,NULL,'2025-11-29 05:42:57',NULL,'2025-11-29 05:42:57',NULL,NULL),(378,NULL,NULL,'1e35f17db4a141ccbdd0e2e0650e7133',NULL,NULL,NULL,NULL,'2025-11-29 05:42:57',NULL,'2025-11-29 05:42:57',NULL,NULL),(379,NULL,'c7ee1a8e18ad41a799fde2c11e190257',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:43:00',NULL,'2025-11-29 05:43:00',NULL,NULL),(380,NULL,'763ee5d3450f427ca1081cea0f991adc',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:43:00',NULL,'2025-11-29 05:43:00',NULL,NULL),(381,NULL,'9ed8b5e2fb7342e093587b9c9c7b2858',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:43:07',NULL,'2025-11-29 05:43:07',NULL,NULL),(382,NULL,NULL,'c8055d8ebb36432196034de4894bbc3b',NULL,NULL,NULL,NULL,'2025-11-29 05:43:13',NULL,'2025-11-29 05:43:13',NULL,NULL),(383,NULL,NULL,'22e9348439d441e88ab21c89a448b99a',NULL,NULL,NULL,NULL,'2025-11-29 05:43:13',NULL,'2025-11-29 05:43:13',NULL,NULL),(384,NULL,NULL,'5fcc6b5e821e4d3aa85042923c59b9b8',NULL,NULL,NULL,NULL,'2025-11-29 05:43:13',NULL,'2025-11-29 05:43:13',NULL,NULL),(385,NULL,'185ccfad30ca49d1adcf0d47cfc02aa5',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:43:19',NULL,'2025-11-29 05:43:19',NULL,NULL),(386,NULL,'388000b055144e48b6827e9f35029a82',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:43:21',NULL,'2025-11-29 05:43:21',NULL,NULL),(387,NULL,'1c5bac6663ef43ef88948e97c050ef52',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:43:23',NULL,'2025-11-29 05:43:23',NULL,NULL),(388,NULL,NULL,'821cacaaae25477094b60ec377fac3f9',NULL,NULL,NULL,NULL,'2025-11-29 05:44:14',NULL,'2025-11-29 05:44:14',NULL,NULL),(389,NULL,NULL,'6f7f9251bec644a5bf819843dcf464f5',NULL,NULL,NULL,NULL,'2025-11-29 05:44:21',NULL,'2025-11-29 05:44:21',NULL,NULL),(390,NULL,NULL,'0577aff181ec4069b08f8bf5990288a6',NULL,NULL,NULL,NULL,'2025-11-29 05:44:21',NULL,'2025-11-29 05:44:21',NULL,NULL),(391,NULL,NULL,'27734e52226045ccbdafe12e646a68d1',NULL,NULL,NULL,NULL,'2025-11-29 05:44:21',NULL,'2025-11-29 05:44:21',NULL,NULL),(392,NULL,'c99fc00d52094735a655d8053fa24ab4',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:44:22',NULL,'2025-11-29 05:44:22',NULL,NULL),(393,NULL,'491986b013f84981acd0b6233ccb4cc4',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:44:24',NULL,'2025-11-29 05:44:24',NULL,NULL),(394,NULL,'bfa506cc517a4cf1bb6dc4bca76155a6',NULL,NULL,NULL,NULL,NULL,'2025-11-29 05:44:26',NULL,'2025-11-29 05:44:26',NULL,NULL);
/*!40000 ALTER TABLE `revocation_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL DEFAULT '<<null>>',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_role_name_domain_id` (`name`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` (`id`, `name`, `extra`, `domain_id`, `description`) VALUES ('25d3eb68b6004924a409a7b0aafff112','member','{}','<<null>>',NULL),('44abaf4ea9c1440382f1d995f42e7926','service','{}','<<null>>',NULL),('7bdb57a1fbde47c7ac0c5511d2f9c3e6','reader','{}','<<null>>',NULL),('eaf49411c8e94ce9954baa2063538d27','admin','{}','<<null>>',NULL),('eb2d5d6ae10d4b7d931400510112d430','swiftoperator','{}','<<null>>',NULL),('f2a199e954604b0397c09fab568e3f3a','ResellerAdmin','{}','<<null>>',NULL);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_option`
--

DROP TABLE IF EXISTS `role_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_option` (
  `role_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`role_id`,`option_id`),
  CONSTRAINT `role_option_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_option`
--

LOCK TABLES `role_option` WRITE;
/*!40000 ALTER TABLE `role_option` DISABLE KEYS */;
INSERT INTO `role_option` (`role_id`, `option_id`, `option_value`) VALUES ('25d3eb68b6004924a409a7b0aafff112','IMMU','true'),('7bdb57a1fbde47c7ac0c5511d2f9c3e6','IMMU','true'),('eaf49411c8e94ce9954baa2063538d27','IMMU','true');
/*!40000 ALTER TABLE `role_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sensitive_config`
--

DROP TABLE IF EXISTS `sensitive_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sensitive_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sensitive_config`
--

LOCK TABLES `sensitive_config` WRITE;
/*!40000 ALTER TABLE `sensitive_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sensitive_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `type`, `enabled`, `extra`) VALUES ('0e7f3c97db614da5aef6e9cba6c6d978','placement',1,'{\"description\": \"Placement Service\", \"name\": \"placement\"}'),('1cc78f051fec4f1197ad77cc7e579dd4','share',1,'{\"description\": \"Manila V1 Service\", \"name\": \"manila\"}'),('1cca587de99249cd8ce492f0db47622a','compute',1,'{\"description\": \"Nova Compute Service\", \"name\": \"nova\"}'),('32633c25ec034a2d95a4463e4ed8f258','sharev2',1,'{\"description\": \"Manila V2 Service\", \"name\": \"manilav2\"}'),('4388c15aa6e848dc89a9c4b07bcc0e14','volumev3',1,'{\"description\": \"Cinder V3 Service\", \"name\": \"cinderv3\"}'),('798b6e220bb94d82adb051410ed4ed91','object-store',1,'{\"name\": \"swift\", \"description\": \"OpenStack Object Storage\"}'),('88536fd423fc451fa7cd5034c6a3faa4','key-manager',1,'{\"description\": \"Barbican Service\", \"name\": \"barbican\"}'),('8cb51e0113104c9abeb9f2695eceb110','Ceilometer',1,'{\"description\": \"Ceilometer Service\", \"name\": \"ceilometer\"}'),('95a4b039323642fc8a715917ee4367e2','identity',1,'{\"name\": \"keystone\"}'),('cc6f60e92ac542e7b4a4f6196d17c981','image',1,'{\"description\": \"Glance Service\", \"name\": \"glance\"}'),('fca5cd71603a47988c84cffca6d293da','network',1,'{\"description\": \"Openstack Networking\", \"name\": \"neutron\"}');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_provider`
--

DROP TABLE IF EXISTS `service_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_provider` (
  `auth_url` varchar(256) NOT NULL,
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `sp_url` varchar(256) NOT NULL,
  `relay_state_prefix` varchar(256) NOT NULL DEFAULT 'ss:mem:',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_provider`
--

LOCK TABLES `service_provider` WRITE;
/*!40000 ALTER TABLE `service_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `service_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_assignment`
--

DROP TABLE IF EXISTS `system_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_assignment` (
  `type` varchar(64) NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_assignment`
--

LOCK TABLES `system_assignment` WRITE;
/*!40000 ALTER TABLE `system_assignment` DISABLE KEYS */;
INSERT INTO `system_assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserSystem','da42e74ed6d04223b9f1be411e89508b','system','eaf49411c8e94ce9954baa2063538d27',0);
/*!40000 ALTER TABLE `system_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `token`
--

DROP TABLE IF EXISTS `token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `token` (
  `id` varchar(64) NOT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_token_user_id` (`user_id`),
  KEY `ix_token_expires` (`expires`),
  KEY `ix_token_expires_valid` (`expires`,`valid`),
  KEY `ix_token_trust_id` (`trust_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `token`
--

LOCK TABLES `token` WRITE;
/*!40000 ALTER TABLE `token` DISABLE KEYS */;
/*!40000 ALTER TABLE `token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust`
--

DROP TABLE IF EXISTS `trust`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust` (
  `id` varchar(64) NOT NULL,
  `trustor_user_id` varchar(64) NOT NULL,
  `trustee_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `impersonation` tinyint(1) NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `remaining_uses` int(11) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `redelegated_trust_id` varchar(64) DEFAULT NULL,
  `redelegation_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `duplicate_trust_constraint_expanded` (`trustor_user_id`,`trustee_user_id`,`project_id`,`impersonation`,`expires_at`,`expires_at_int`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust`
--

LOCK TABLES `trust` WRITE;
/*!40000 ALTER TABLE `trust` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust_role`
--

DROP TABLE IF EXISTS `trust_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust_role` (
  `trust_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`trust_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust_role`
--

LOCK TABLES `trust_role` WRITE;
/*!40000 ALTER TABLE `trust_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `default_project_id` varchar(64) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_active_at` date DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_user_id_domain_id` (`id`,`domain_id`),
  KEY `ix_default_project_id` (`default_project_id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `extra`, `enabled`, `default_project_id`, `created_at`, `last_active_at`, `domain_id`) VALUES ('032b6b592a214ec7a5eba078e1abe4d6','{}',1,'3f8e46ff816a4d8a90bfa4b396b35aaf','2025-11-29 05:29:22','2025-11-29','default'),('04b5bf8225a04cd1bb1be73757e80ca2','{}',1,'3f8e46ff816a4d8a90bfa4b396b35aaf','2025-11-29 04:56:11','2025-11-29','default'),('32c33e44159f4ccfa6e2fd4f81a8ad4f','{}',1,'3f8e46ff816a4d8a90bfa4b396b35aaf','2025-11-29 04:56:22','2025-11-29','default'),('6f2298292b104ff58856a40039289e85','{}',1,'3f8e46ff816a4d8a90bfa4b396b35aaf','2025-11-29 04:56:15','2025-11-29','default'),('767285b605aa44dbbd3cd889c1cbfdd3','{}',1,'3f8e46ff816a4d8a90bfa4b396b35aaf','2025-11-29 04:56:27','2025-11-29','default'),('8f59cc412ff44a13a0e77a17c47b7815','{}',1,'3f8e46ff816a4d8a90bfa4b396b35aaf','2025-11-29 04:56:34','2025-11-29','default'),('9148c83efc474b8b80eb81c2090d5435','{\"tenantId\": \"cec69ecdc21e48bcb26757a96bef3fdc\", \"email\": \"demo_tempestconf@test.com\"}',1,NULL,'2025-11-29 05:32:06',NULL,'default'),('bebcae54c3b640c4bae666c40d95c5f8','{}',1,'3f8e46ff816a4d8a90bfa4b396b35aaf','2025-11-29 05:10:54',NULL,'default'),('da42e74ed6d04223b9f1be411e89508b','{}',1,NULL,'2025-11-29 04:55:01','2025-11-29','default'),('e21ade2dfdf54a9bbdbf2d31f14c738c','{}',1,'3f8e46ff816a4d8a90bfa4b396b35aaf','2025-11-29 04:56:31',NULL,'default'),('ea591be1497d41ec8a8129de91669cc4','{}',1,'3f8e46ff816a4d8a90bfa4b396b35aaf','2025-11-29 04:56:18','2025-11-29','default'),('f4bb8f450f734df5b0e4972dc06e2dd5','{\"tenantId\": \"ebe86517524a4fddade08d85ffb69e00\", \"email\": \"alt_demo_tempestconf@test.com\"}',1,NULL,'2025-11-29 05:32:07',NULL,'default');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_group_membership`
--

DROP TABLE IF EXISTS `user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `fk_user_group_membership_group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `fk_user_group_membership_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_group_membership`
--

LOCK TABLES `user_group_membership` WRITE;
/*!40000 ALTER TABLE `user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_option`
--

DROP TABLE IF EXISTS `user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_option` (
  `user_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`user_id`,`option_id`),
  CONSTRAINT `user_option_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_option`
--

LOCK TABLES `user_option` WRITE;
/*!40000 ALTER TABLE `user_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whitelisted_config`
--

DROP TABLE IF EXISTS `whitelisted_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whitelisted_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whitelisted_config`
--

LOCK TABLES `whitelisted_config` WRITE;
/*!40000 ALTER TABLE `whitelisted_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `whitelisted_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `manila`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `manila` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `manila`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('aebe2a413e13');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `async_operation_data`
--

DROP TABLE IF EXISTS `async_operation_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `async_operation_data` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `entity_uuid` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`entity_uuid`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `async_operation_data`
--

LOCK TABLES `async_operation_data` WRITE;
/*!40000 ALTER TABLE `async_operation_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `async_operation_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `availability_zones`
--

DROP TABLE IF EXISTS `availability_zones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `availability_zones` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `az_name_uc` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `availability_zones`
--

LOCK TABLES `availability_zones` WRITE;
/*!40000 ALTER TABLE `availability_zones` DISABLE KEYS */;
INSERT INTO `availability_zones` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`) VALUES ('2025-11-29 05:29:24.774155',NULL,NULL,'False','98d086e9-d171-462d-b7c9-f85ca4e71bd0','nova');
/*!40000 ALTER TABLE `availability_zones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backend_info`
--

DROP TABLE IF EXISTS `backend_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backend_info` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `host` varchar(255) NOT NULL,
  `info_hash` varchar(255) NOT NULL,
  PRIMARY KEY (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backend_info`
--

LOCK TABLES `backend_info` WRITE;
/*!40000 ALTER TABLE `backend_info` DISABLE KEYS */;
INSERT INTO `backend_info` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `host`, `info_hash`) VALUES ('2025-11-29 05:29:33.088943',NULL,NULL,0,'hostgroup@cephfs','e66c0dfc0d422efa26af62f5a81dd60603e2d39a');
/*!40000 ALTER TABLE `backend_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `drivers_private_data`
--

DROP TABLE IF EXISTS `drivers_private_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `drivers_private_data` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `entity_uuid` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`entity_uuid`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `drivers_private_data`
--

LOCK TABLES `drivers_private_data` WRITE;
/*!40000 ALTER TABLE `drivers_private_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `drivers_private_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(255) DEFAULT NULL,
  `resource_id` varchar(36) DEFAULT NULL,
  `action_id` varchar(10) NOT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
INSERT INTO `messages` (`id`, `project_id`, `request_id`, `resource_type`, `resource_id`, `action_id`, `detail_id`, `message_level`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `expires_at`) VALUES ('008a2e7d-faee-4c43-9bd4-f593811fcd60','bf7ea2709c674f5da87071b7a3ab3ac1','req-0de8c00b-104a-4659-9759-6005aa4a1e55','SHARE','177748b2-71b4-434c-9c07-250bb252552d','001','008','ERROR','2025-11-29 05:38:05.044666',NULL,NULL,'False','2025-12-29 05:38:05'),('1e128392-f6b6-4485-9e70-0eb11e03cd17','c6b8afea074442b2b9cd8ed762e06d27','req-afd423e1-b0b8-49ff-8b93-3856216e6082','SHARE','c77b407c-e863-41eb-ac34-17923aaa7053','001','008','ERROR','2025-11-29 05:36:10.804121',NULL,NULL,'False','2025-12-29 05:36:10'),('2780c58c-35a4-4520-be4d-ce47cf3ce074','c6b8afea074442b2b9cd8ed762e06d27','req-8edbcf5f-0d60-4947-97d0-50d3ca4c92fb','SHARE','a4719e97-03da-4127-8147-ec08a86a6bb3','001','008','ERROR','2025-11-29 05:36:14.520735',NULL,NULL,'False','2025-12-29 05:36:14'),('4178ca8d-2290-4510-9a76-cbe222c84da3','c6b8afea074442b2b9cd8ed762e06d27','req-c474dbb5-0f9f-4921-9924-140cf23f6bba','SHARE','56d4f245-aad6-4afa-a1ec-3689faa4e66c','001','008','ERROR','2025-11-29 05:35:59.080400',NULL,NULL,'False','2025-12-29 05:35:59'),('4cce368e-d9da-4da2-a5e6-4913dc8b0852','c6b8afea074442b2b9cd8ed762e06d27','req-c087a8fd-3835-42fd-a6dc-7f35580a2443','SHARE','befa686b-6239-457b-9216-72e72413f7e5','001','008','ERROR','2025-11-29 05:36:02.612579',NULL,NULL,'False','2025-12-29 05:36:02'),('5b9dd419-eb79-4d1d-b27f-3b160534db84','c6b8afea074442b2b9cd8ed762e06d27','req-212a122a-980c-4378-a7fd-d9ebfa79e495','SHARE','d63b5112-aadb-407c-bec4-97c81b47af5b','001','008','ERROR','2025-11-29 05:35:50.989219',NULL,'2025-11-29 05:35:54.346649','5b9dd419-eb79-4d1d-b27f-3b160534db84','2025-12-29 05:35:50'),('7106dccc-c617-40a3-add5-2936c6a9ec84','c6b8afea074442b2b9cd8ed762e06d27','req-d3e8a9c9-b1b2-41a0-bdfc-55426a6dc867','SHARE','e16e1ecc-c8d2-4e64-b3f6-d2d9870fa17d','001','008','ERROR','2025-11-29 05:36:06.915662',NULL,NULL,'False','2025-12-29 05:36:06'),('7202ba83-8ad0-4ec7-aca5-33922622ca49','c6b8afea074442b2b9cd8ed762e06d27','req-e337b27d-6f30-44e8-8db7-36d978e48f3b','SHARE','bf0cb974-5bd9-4569-af3d-06e6cb5919af','001','008','ERROR','2025-11-29 05:36:27.781077',NULL,'2025-11-29 05:36:31.347663','7202ba83-8ad0-4ec7-aca5-33922622ca49','2025-12-29 05:36:27'),('8e663bf8-4eb5-4d38-969a-4412ec793d93','c6b8afea074442b2b9cd8ed762e06d27','req-0b4b9574-14e4-4505-aab8-8870d41bf78e','SHARE','be39336e-f884-45a4-b50c-d8ee1803bc79','001','008','ERROR','2025-11-29 05:36:19.339452',NULL,NULL,'False','2025-12-29 05:36:19'),('acc433c4-86ec-43da-9d3f-f3b00a684eed','c6b8afea074442b2b9cd8ed762e06d27','req-15014c73-0a52-4a3d-a5e4-de0837f50ae9','SHARE','f0561e75-9a83-48e9-9d98-de66e0b6b547','001','008','ERROR','2025-11-29 05:35:55.208855',NULL,NULL,'False','2025-12-29 05:35:55'),('b8fadd0a-22f1-4691-a196-5f93ee7039ef','4e135fffa1e64bf8b2e43bd33b51cf15','req-d293804b-99cb-4b4e-a7f2-242788ec863e','SHARE','b21dc5b7-b92a-4537-a1e9-9593006a005c','010','020','ERROR','2025-11-29 05:41:10.585135',NULL,NULL,'False','2025-12-29 05:41:10'),('c3c6c961-a47d-4d6c-80b7-bd25b64935c9','bf7ea2709c674f5da87071b7a3ab3ac1','req-c457ce68-ea55-4cb5-8537-db78aab65f88','SHARE','6c7e4dab-ae52-4e96-adf9-a016c8ede2b3','001','008','ERROR','2025-11-29 05:37:48.558585',NULL,NULL,'False','2025-12-29 05:37:48'),('d0841b9d-37e3-4b29-b9ed-70b6a520be4d','bf7ea2709c674f5da87071b7a3ab3ac1','req-c6453028-3d38-4358-bde9-2176c1cee2cc','SHARE','3cecb700-a400-400a-be98-c6df0ec19bf4','001','008','ERROR','2025-11-29 05:37:56.859044',NULL,NULL,'False','2025-12-29 05:37:56'),('dd0fd08d-8f45-42c6-97bf-6a2511acac80','c6b8afea074442b2b9cd8ed762e06d27','req-83000eb6-00c9-44f8-b077-ff99ca9e5ed0','SHARE','b358407f-b6af-44a4-9b96-bb8737f4a0ad','001','008','ERROR','2025-11-29 05:36:23.121936',NULL,NULL,'False','2025-12-29 05:36:23'),('e53b899a-33db-4c3e-ac90-279ebf85c6d3','bf7ea2709c674f5da87071b7a3ab3ac1','req-e47cf154-3ec2-43f8-9711-be6f4b88b106','SHARE','62d5650f-e0da-4b7c-a132-3a85b7f0a4c8','001','008','ERROR','2025-11-29 05:37:52.625132',NULL,NULL,'False','2025-12-29 05:37:52'),('f25b4381-f771-4965-9f21-d0c1a20e9356','bf7ea2709c674f5da87071b7a3ab3ac1','req-f8d861be-4568-4af6-a006-0e0c870bc491','SHARE','3cc24ec6-7260-40a2-aa54-0fb231b3fa43','001','008','ERROR','2025-11-29 05:38:01.075467',NULL,NULL,'False','2025-12-29 05:38:01');
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `network_allocations`
--

DROP TABLE IF EXISTS `network_allocations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `network_allocations` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ip_address` varchar(64) DEFAULT NULL,
  `mac_address` varchar(32) DEFAULT NULL,
  `share_server_id` varchar(36) NOT NULL,
  `label` varchar(255) DEFAULT 'user',
  `network_type` varchar(32) DEFAULT NULL,
  `segmentation_id` int(11) DEFAULT NULL,
  `ip_version` int(11) DEFAULT NULL,
  `cidr` varchar(64) DEFAULT NULL,
  `gateway` varchar(64) DEFAULT NULL,
  `mtu` int(11) DEFAULT NULL,
  `share_network_subnet_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `share_server_id` (`share_server_id`),
  KEY `fk_network_allocation_subnet_id_share_network_subnets` (`share_network_subnet_id`),
  CONSTRAINT `fk_network_allocation_subnet_id_share_network_subnets` FOREIGN KEY (`share_network_subnet_id`) REFERENCES `share_network_subnets` (`id`),
  CONSTRAINT `network_allocations_ibfk_1` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `network_allocations`
--

LOCK TABLES `network_allocations` WRITE;
/*!40000 ALTER TABLE `network_allocations` DISABLE KEYS */;
/*!40000 ALTER TABLE `network_allocations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_share_type_quotas`
--

DROP TABLE IF EXISTS `project_share_type_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_share_type_quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `share_type_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uc_quotas_per_share_types` (`share_type_id`,`resource`,`deleted`,`project_id`),
  CONSTRAINT `share_type_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_share_type_quotas`
--

LOCK TABLES `project_share_type_quotas` WRITE;
/*!40000 ALTER TABLE `project_share_type_quotas` DISABLE KEYS */;
INSERT INTO `project_share_type_quotas` (`id`, `project_id`, `resource`, `hard_limit`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `share_type_id`) VALUES (1,'b4f2479ae0d643afbae53bb92525282e','shares',2,'2025-11-29 05:35:08.357912',NULL,'2025-11-29 05:35:43.958816',1,'078baedb-e7c7-47ca-9eae-f6d4445bee40'),(2,'b4f2479ae0d643afbae53bb92525282e','gigabytes',4,'2025-11-29 05:35:08.363441',NULL,'2025-11-29 05:35:43.958816',2,'078baedb-e7c7-47ca-9eae-f6d4445bee40'),(3,'b4f2479ae0d643afbae53bb92525282e','shares',2,'2025-11-29 05:35:08.586574',NULL,'2025-11-29 05:35:43.772044',3,'ddc6389e-dda9-47b0-85a7-6ad509ba0f38'),(4,'b4f2479ae0d643afbae53bb92525282e','gigabytes',4,'2025-11-29 05:35:08.591274',NULL,'2025-11-29 05:35:43.772044',4,'ddc6389e-dda9-47b0-85a7-6ad509ba0f38'),(5,'b4f2479ae0d643afbae53bb92525282e','shares',53,'2025-11-29 05:35:25.706593',NULL,'2025-11-29 05:35:25.834460',5,'f67bd588-143f-43fa-afb1-11534eb30af9'),(6,'b4f2479ae0d643afbae53bb92525282e','snapshots',53,'2025-11-29 05:35:25.715537',NULL,'2025-11-29 05:35:25.834460',6,'f67bd588-143f-43fa-afb1-11534eb30af9'),(7,'b4f2479ae0d643afbae53bb92525282e','gigabytes',1003,'2025-11-29 05:35:25.722876',NULL,'2025-11-29 05:35:25.834460',7,'f67bd588-143f-43fa-afb1-11534eb30af9'),(8,'b4f2479ae0d643afbae53bb92525282e','snapshot_gigabytes',1003,'2025-11-29 05:35:25.726859',NULL,'2025-11-29 05:35:25.834460',8,'f67bd588-143f-43fa-afb1-11534eb30af9'),(9,'b4f2479ae0d643afbae53bb92525282e','share_replicas',103,'2025-11-29 05:35:25.730317',NULL,'2025-11-29 05:35:25.834460',9,'f67bd588-143f-43fa-afb1-11534eb30af9'),(10,'b4f2479ae0d643afbae53bb92525282e','replica_gigabytes',1003,'2025-11-29 05:35:25.733683',NULL,'2025-11-29 05:35:25.834460',10,'f67bd588-143f-43fa-afb1-11534eb30af9'),(11,'b4f2479ae0d643afbae53bb92525282e','shares',53,'2025-11-29 05:35:26.844914',NULL,'2025-11-29 05:35:26.954951',11,'57140e21-36a1-4c7c-919e-55548c6b7f73'),(12,'b4f2479ae0d643afbae53bb92525282e','snapshots',53,'2025-11-29 05:35:26.850989',NULL,'2025-11-29 05:35:26.954951',12,'57140e21-36a1-4c7c-919e-55548c6b7f73'),(13,'b4f2479ae0d643afbae53bb92525282e','gigabytes',1003,'2025-11-29 05:35:26.855944',NULL,'2025-11-29 05:35:26.954951',13,'57140e21-36a1-4c7c-919e-55548c6b7f73'),(14,'b4f2479ae0d643afbae53bb92525282e','snapshot_gigabytes',1003,'2025-11-29 05:35:26.860137',NULL,'2025-11-29 05:35:26.954951',14,'57140e21-36a1-4c7c-919e-55548c6b7f73'),(15,'b4f2479ae0d643afbae53bb92525282e','share_replicas',103,'2025-11-29 05:35:26.864784',NULL,'2025-11-29 05:35:26.954951',15,'57140e21-36a1-4c7c-919e-55548c6b7f73'),(16,'b4f2479ae0d643afbae53bb92525282e','replica_gigabytes',1003,'2025-11-29 05:35:26.870478',NULL,'2025-11-29 05:35:26.954951',16,'57140e21-36a1-4c7c-919e-55548c6b7f73'),(17,'b4f2479ae0d643afbae53bb92525282e','shares',12,'2025-11-29 05:35:28.213010',NULL,'2025-11-29 05:35:43.148301',17,'da0820f0-008b-47f7-acdd-4f4acff2c7e9'),(18,'b4f2479ae0d643afbae53bb92525282e','shares',49,'2025-11-29 05:35:33.325121',NULL,'2025-11-29 05:35:42.929037',18,'634aa3ee-1b2b-440c-89ae-4360075d13d4'),(19,'b4f2479ae0d643afbae53bb92525282e','gigabytes',999,'2025-11-29 05:35:33.452508',NULL,'2025-11-29 05:35:42.929037',19,'634aa3ee-1b2b-440c-89ae-4360075d13d4'),(20,'b4f2479ae0d643afbae53bb92525282e','snapshots',49,'2025-11-29 05:35:33.544283',NULL,'2025-11-29 05:35:42.929037',20,'634aa3ee-1b2b-440c-89ae-4360075d13d4'),(21,'b4f2479ae0d643afbae53bb92525282e','snapshot_gigabytes',999,'2025-11-29 05:35:33.836272',NULL,'2025-11-29 05:35:42.929037',21,'634aa3ee-1b2b-440c-89ae-4360075d13d4'),(22,'b4f2479ae0d643afbae53bb92525282e','share_replicas',99,'2025-11-29 05:35:34.146662',NULL,'2025-11-29 05:35:42.929037',22,'634aa3ee-1b2b-440c-89ae-4360075d13d4'),(23,'b4f2479ae0d643afbae53bb92525282e','replica_gigabytes',999,'2025-11-29 05:35:34.302429',NULL,'2025-11-29 05:35:42.929037',23,'634aa3ee-1b2b-440c-89ae-4360075d13d4'),(24,'b4f2479ae0d643afbae53bb92525282e','shares',49,'2025-11-29 05:35:34.720951',NULL,'2025-11-29 05:35:42.701661',24,'73518200-bf68-4245-825c-570887a53b76'),(25,'b4f2479ae0d643afbae53bb92525282e','gigabytes',999,'2025-11-29 05:35:34.836519',NULL,'2025-11-29 05:35:42.701661',25,'73518200-bf68-4245-825c-570887a53b76'),(26,'b4f2479ae0d643afbae53bb92525282e','snapshots',49,'2025-11-29 05:35:34.941885',NULL,'2025-11-29 05:35:42.701661',26,'73518200-bf68-4245-825c-570887a53b76'),(27,'b4f2479ae0d643afbae53bb92525282e','snapshot_gigabytes',999,'2025-11-29 05:35:35.065568',NULL,'2025-11-29 05:35:42.701661',27,'73518200-bf68-4245-825c-570887a53b76'),(28,'b4f2479ae0d643afbae53bb92525282e','share_replicas',99,'2025-11-29 05:35:35.174782',NULL,'2025-11-29 05:35:42.701661',28,'73518200-bf68-4245-825c-570887a53b76'),(29,'b4f2479ae0d643afbae53bb92525282e','replica_gigabytes',999,'2025-11-29 05:35:35.320648',NULL,'2025-11-29 05:35:42.701661',29,'73518200-bf68-4245-825c-570887a53b76'),(30,'b4f2479ae0d643afbae53bb92525282e','shares',11,'2025-11-29 05:35:35.764656',NULL,'2025-11-29 05:35:42.533503',30,'50662731-2f67-4824-83cd-c8da89fb4e2c'),(31,'b4f2479ae0d643afbae53bb92525282e','shares',-1,'2025-11-29 05:35:36.138375',NULL,'2025-11-29 05:35:42.252767',31,'f29d90ca-7366-41b1-9029-74f9055a75bd');
/*!40000 ALTER TABLE `project_share_type_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_user_quotas`
--

DROP TABLE IF EXISTS `project_user_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_user_quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `user_id` varchar(255) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `resource` varchar(25) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_user_quotas`
--

LOCK TABLES `project_user_quotas` WRITE;
/*!40000 ALTER TABLE `project_user_quotas` DISABLE KEYS */;
INSERT INTO `project_user_quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `user_id`, `project_id`, `resource`, `hard_limit`) VALUES (1,'2025-11-29 05:35:08.226187',NULL,'2025-11-29 05:35:25.186268',1,'23469d4601454621a798588dbcc97218','b4f2479ae0d643afbae53bb92525282e','shares',2),(2,'2025-11-29 05:35:08.240909',NULL,'2025-11-29 05:35:25.186268',2,'23469d4601454621a798588dbcc97218','b4f2479ae0d643afbae53bb92525282e','gigabytes',7),(3,'2025-11-29 05:35:28.112664',NULL,'2025-11-29 05:35:28.282132',3,'23469d4601454621a798588dbcc97218','b4f2479ae0d643afbae53bb92525282e','shares',11),(4,'2025-11-29 05:35:30.762808',NULL,'2025-11-29 05:35:30.937073',4,'23469d4601454621a798588dbcc97218','b4f2479ae0d643afbae53bb92525282e','gigabytes',-1),(5,'2025-11-29 05:35:31.047195',NULL,'2025-11-29 05:35:31.208136',5,'23469d4601454621a798588dbcc97218','b4f2479ae0d643afbae53bb92525282e','share_replicas',-1),(6,'2025-11-29 05:35:31.348844',NULL,'2025-11-29 05:35:31.634043',6,'23469d4601454621a798588dbcc97218','b4f2479ae0d643afbae53bb92525282e','replica_gigabytes',-1),(7,'2025-11-29 05:35:31.765977',NULL,'2025-11-29 05:35:31.938700',7,'23469d4601454621a798588dbcc97218','b4f2479ae0d643afbae53bb92525282e','share_networks',-1),(8,'2025-11-29 05:35:32.067701',NULL,'2025-11-29 05:35:32.275932',8,'23469d4601454621a798588dbcc97218','b4f2479ae0d643afbae53bb92525282e','shares',-1),(9,'2025-11-29 05:35:32.394980',NULL,'2025-11-29 05:35:32.691297',9,'23469d4601454621a798588dbcc97218','b4f2479ae0d643afbae53bb92525282e','snapshot_gigabytes',-1),(10,'2025-11-29 05:35:32.841339',NULL,'2025-11-29 05:35:33.041569',10,'23469d4601454621a798588dbcc97218','b4f2479ae0d643afbae53bb92525282e','snapshots',-1),(11,'2025-11-29 05:35:38.319652',NULL,'2025-11-29 05:35:38.387570',11,'23469d4601454621a798588dbcc97218','b4f2479ae0d643afbae53bb92525282e','gigabytes',999),(12,'2025-11-29 05:35:38.952419',NULL,'2025-11-29 05:35:39.100372',12,'23469d4601454621a798588dbcc97218','b4f2479ae0d643afbae53bb92525282e','share_replicas',99),(13,'2025-11-29 05:35:39.703051',NULL,'2025-11-29 05:35:39.786934',13,'23469d4601454621a798588dbcc97218','b4f2479ae0d643afbae53bb92525282e','replica_gigabytes',999),(14,'2025-11-29 05:35:40.129634',NULL,'2025-11-29 05:35:40.236449',14,'23469d4601454621a798588dbcc97218','b4f2479ae0d643afbae53bb92525282e','share_networks',9),(15,'2025-11-29 05:35:40.471628',NULL,'2025-11-29 05:35:40.559158',15,'23469d4601454621a798588dbcc97218','b4f2479ae0d643afbae53bb92525282e','shares',49),(16,'2025-11-29 05:35:40.744411',NULL,'2025-11-29 05:35:40.841912',16,'23469d4601454621a798588dbcc97218','b4f2479ae0d643afbae53bb92525282e','snapshot_gigabytes',999),(17,'2025-11-29 05:35:41.035647',NULL,'2025-11-29 05:35:41.119205',17,'23469d4601454621a798588dbcc97218','b4f2479ae0d643afbae53bb92525282e','snapshots',49),(18,'2025-11-29 05:35:41.347426',NULL,'2025-11-29 05:35:41.585715',18,'23469d4601454621a798588dbcc97218','b4f2479ae0d643afbae53bb92525282e','shares',11),(19,'2025-11-29 05:35:41.904426',NULL,'2025-11-29 05:35:42.053367',19,'23469d4601454621a798588dbcc97218','b4f2479ae0d643afbae53bb92525282e','shares',-1);
/*!40000 ALTER TABLE `project_user_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_usages_project_id` (`project_id`)
) ENGINE=InnoDB AUTO_INCREMENT=270 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
INSERT INTO `quota_usages` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `resource`, `in_use`, `reserved`, `until_refresh`, `share_type_id`) VALUES ('2025-11-29 05:34:23.131210','2025-11-29 05:35:44.566584',NULL,0,1,'4544ba66fc044b5a8d3aa9deb5249384','3e18b41001c440e0a7d05f7f98059230','shares',0,0,NULL,NULL),('2025-11-29 05:34:23.136265','2025-11-29 05:35:44.566588',NULL,0,2,'4544ba66fc044b5a8d3aa9deb5249384','3e18b41001c440e0a7d05f7f98059230','gigabytes',0,0,NULL,NULL),('2025-11-29 05:34:23.151015','2025-11-29 05:35:44.566589','2025-11-29 05:35:47.700043',3,3,NULL,'3e18b41001c440e0a7d05f7f98059230','shares',0,0,NULL,'03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:34:23.155143','2025-11-29 05:35:44.566590','2025-11-29 05:35:47.700043',4,4,NULL,'3e18b41001c440e0a7d05f7f98059230','gigabytes',0,0,NULL,'03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:34:24.782702','2025-11-29 05:34:31.893527',NULL,0,5,'6bebd43b2c7c48209f1030ff92d31dc2','35fca249d2fe4b499e58ae322257ed19','shares',0,0,NULL,NULL),('2025-11-29 05:34:24.785416','2025-11-29 05:34:31.893532',NULL,0,6,'6bebd43b2c7c48209f1030ff92d31dc2','35fca249d2fe4b499e58ae322257ed19','gigabytes',0,0,NULL,NULL),('2025-11-29 05:34:24.856031','2025-11-29 05:34:31.893534','2025-11-29 05:34:34.965092',7,7,NULL,'35fca249d2fe4b499e58ae322257ed19','shares',0,0,NULL,'235d3753-6144-4b29-b569-50b44a6b7188'),('2025-11-29 05:34:24.861389','2025-11-29 05:34:31.893536','2025-11-29 05:34:34.965092',8,8,NULL,'35fca249d2fe4b499e58ae322257ed19','gigabytes',0,0,NULL,'235d3753-6144-4b29-b569-50b44a6b7188'),('2025-11-29 05:34:36.198971','2025-11-29 05:34:44.373378',NULL,0,9,'cb1b305ee4f94aa68f250be4f43ef913','049c3d38228f4e3e9c392f5f88dbc238','gigabytes',0,0,NULL,NULL),('2025-11-29 05:34:36.201968','2025-11-29 05:34:44.373380',NULL,0,10,'cb1b305ee4f94aa68f250be4f43ef913','049c3d38228f4e3e9c392f5f88dbc238','shares',0,0,NULL,NULL),('2025-11-29 05:34:36.218933','2025-11-29 05:34:44.373382','2025-11-29 05:34:48.066346',11,11,NULL,'049c3d38228f4e3e9c392f5f88dbc238','gigabytes',0,0,NULL,'7e5bc69e-c8de-413a-a484-248ded56b5e3'),('2025-11-29 05:34:36.221991','2025-11-29 05:34:44.373383','2025-11-29 05:34:48.066346',12,12,NULL,'049c3d38228f4e3e9c392f5f88dbc238','shares',0,0,NULL,'7e5bc69e-c8de-413a-a484-248ded56b5e3'),('2025-11-29 05:34:54.363572','2025-11-29 05:35:40.893663',NULL,0,13,'4544ba66fc044b5a8d3aa9deb5249384','3e18b41001c440e0a7d05f7f98059230','snapshots',0,0,NULL,NULL),('2025-11-29 05:34:54.367239','2025-11-29 05:35:40.893666',NULL,0,14,'4544ba66fc044b5a8d3aa9deb5249384','3e18b41001c440e0a7d05f7f98059230','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-29 05:34:54.380031','2025-11-29 05:35:40.893668','2025-11-29 05:35:47.700043',15,15,NULL,'3e18b41001c440e0a7d05f7f98059230','snapshots',0,0,NULL,'03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:34:54.383430','2025-11-29 05:35:40.893669','2025-11-29 05:35:47.700043',16,16,NULL,'3e18b41001c440e0a7d05f7f98059230','snapshot_gigabytes',0,0,NULL,'03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:35:07.228297','2025-11-29 05:35:36.545266',NULL,0,17,'417cb9ae9b2a43429cd5d1781ad57fd9','c272c8175ff843ca8dc572501529b10b','gigabytes',0,0,NULL,NULL),('2025-11-29 05:35:07.231890','2025-11-29 05:35:36.545269',NULL,0,18,'417cb9ae9b2a43429cd5d1781ad57fd9','c272c8175ff843ca8dc572501529b10b','shares',0,0,NULL,NULL),('2025-11-29 05:35:07.246573','2025-11-29 05:35:36.545271','2025-11-29 05:35:39.713373',19,19,NULL,'c272c8175ff843ca8dc572501529b10b','gigabytes',0,0,NULL,'897b7777-bc91-41a3-a0ae-0cc41ffc72f9'),('2025-11-29 05:35:07.251735','2025-11-29 05:35:36.545272','2025-11-29 05:35:39.713373',20,20,NULL,'c272c8175ff843ca8dc572501529b10b','shares',0,0,NULL,'897b7777-bc91-41a3-a0ae-0cc41ffc72f9'),('2025-11-29 05:35:08.743663','2025-11-29 05:35:23.186270','2025-11-29 05:35:25.188941',21,21,'23469d4601454621a798588dbcc97218','b4f2479ae0d643afbae53bb92525282e','shares',0,0,NULL,NULL),('2025-11-29 05:35:08.745605','2025-11-29 05:35:23.186273','2025-11-29 05:35:25.188941',22,22,'23469d4601454621a798588dbcc97218','b4f2479ae0d643afbae53bb92525282e','gigabytes',0,0,NULL,NULL),('2025-11-29 05:35:08.755129','2025-11-29 05:35:18.309198','2025-11-29 05:35:25.292741',23,23,NULL,'b4f2479ae0d643afbae53bb92525282e','shares',0,0,NULL,'078baedb-e7c7-47ca-9eae-f6d4445bee40'),('2025-11-29 05:35:08.756886','2025-11-29 05:35:18.309199','2025-11-29 05:35:25.292741',24,24,NULL,'b4f2479ae0d643afbae53bb92525282e','gigabytes',0,0,NULL,'078baedb-e7c7-47ca-9eae-f6d4445bee40'),('2025-11-29 05:35:11.577297','2025-11-29 05:35:33.030731',NULL,0,25,'417cb9ae9b2a43429cd5d1781ad57fd9','c272c8175ff843ca8dc572501529b10b','snapshots',0,0,NULL,NULL),('2025-11-29 05:35:11.582295','2025-11-29 05:35:33.030733',NULL,0,26,'417cb9ae9b2a43429cd5d1781ad57fd9','c272c8175ff843ca8dc572501529b10b','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-29 05:35:11.617348','2025-11-29 05:35:33.030735','2025-11-29 05:35:39.713373',27,27,NULL,'c272c8175ff843ca8dc572501529b10b','snapshots',0,0,NULL,'897b7777-bc91-41a3-a0ae-0cc41ffc72f9'),('2025-11-29 05:35:11.622938','2025-11-29 05:35:33.030736','2025-11-29 05:35:39.713373',28,28,NULL,'c272c8175ff843ca8dc572501529b10b','snapshot_gigabytes',0,0,NULL,'897b7777-bc91-41a3-a0ae-0cc41ffc72f9'),('2025-11-29 05:35:13.402102','2025-11-29 05:35:23.186274','2025-11-29 05:35:25.292741',29,29,NULL,'b4f2479ae0d643afbae53bb92525282e','gigabytes',0,0,NULL,'ddc6389e-dda9-47b0-85a7-6ad509ba0f38'),('2025-11-29 05:35:13.403952','2025-11-29 05:35:23.186275','2025-11-29 05:35:25.292741',30,30,NULL,'b4f2479ae0d643afbae53bb92525282e','shares',0,0,NULL,'ddc6389e-dda9-47b0-85a7-6ad509ba0f38'),('2025-11-29 05:35:40.209392','2025-11-29 05:36:29.489365',NULL,0,31,'07455b147f224a5e9b6756f05d6a11b2','81a95c19e7f04f9388e5b6cb015dc8bf','gigabytes',0,0,NULL,NULL),('2025-11-29 05:35:40.212658','2025-11-29 05:36:29.489368',NULL,0,32,'07455b147f224a5e9b6756f05d6a11b2','81a95c19e7f04f9388e5b6cb015dc8bf','shares',0,0,NULL,NULL),('2025-11-29 05:35:40.226263','2025-11-29 05:36:29.489369','2025-11-29 05:36:32.944617',33,33,NULL,'81a95c19e7f04f9388e5b6cb015dc8bf','gigabytes',0,0,NULL,'205bf72e-a1ad-4135-9618-25977b47af59'),('2025-11-29 05:35:40.230398','2025-11-29 05:36:29.489370','2025-11-29 05:36:32.944617',34,34,NULL,'81a95c19e7f04f9388e5b6cb015dc8bf','shares',0,0,NULL,'205bf72e-a1ad-4135-9618-25977b47af59'),('2025-11-29 05:35:50.858371','2025-11-29 05:36:31.660947',NULL,0,35,'b5459c3e7d4643048572257a42a70281','c6b8afea074442b2b9cd8ed762e06d27','gigabytes',0,0,NULL,NULL),('2025-11-29 05:35:50.861391','2025-11-29 05:36:31.660949',NULL,0,36,'b5459c3e7d4643048572257a42a70281','c6b8afea074442b2b9cd8ed762e06d27','shares',0,0,NULL,NULL),('2025-11-29 05:35:50.870875','2025-11-29 05:35:54.742906','2025-11-29 05:36:34.813271',37,37,NULL,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',0,0,NULL,'d8457b4e-8e27-45f2-9628-fa0bc63046d3'),('2025-11-29 05:35:50.872772','2025-11-29 05:35:54.742907','2025-11-29 05:36:34.813271',38,38,NULL,'c6b8afea074442b2b9cd8ed762e06d27','shares',0,0,NULL,'d8457b4e-8e27-45f2-9628-fa0bc63046d3'),('2025-11-29 05:35:54.035846','2025-11-29 05:36:03.091123',NULL,0,39,'ae00d95f95bb4ec8b2178598e348be7a','4453ce436b30425fba6f22e4043ef796','shares',0,0,NULL,NULL),('2025-11-29 05:35:54.038621','2025-11-29 05:36:03.091126',NULL,0,40,'ae00d95f95bb4ec8b2178598e348be7a','4453ce436b30425fba6f22e4043ef796','gigabytes',0,0,NULL,NULL),('2025-11-29 05:35:54.051451','2025-11-29 05:36:03.091127','2025-11-29 05:36:06.062204',41,41,NULL,'4453ce436b30425fba6f22e4043ef796','shares',0,0,NULL,'57502de6-1e0c-41d0-84e3-fe1b0b8839c8'),('2025-11-29 05:35:54.053596','2025-11-29 05:36:03.091129','2025-11-29 05:36:06.062204',42,42,NULL,'4453ce436b30425fba6f22e4043ef796','gigabytes',0,0,NULL,'57502de6-1e0c-41d0-84e3-fe1b0b8839c8'),('2025-11-29 05:35:54.621783','2025-11-29 05:35:59.669947',NULL,0,43,'ae00d95f95bb4ec8b2178598e348be7a','4453ce436b30425fba6f22e4043ef796','snapshots',0,0,NULL,NULL),('2025-11-29 05:35:54.628159','2025-11-29 05:35:59.669951',NULL,0,44,'ae00d95f95bb4ec8b2178598e348be7a','4453ce436b30425fba6f22e4043ef796','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-29 05:35:54.640549','2025-11-29 05:35:59.669953','2025-11-29 05:36:06.062204',45,45,NULL,'4453ce436b30425fba6f22e4043ef796','snapshots',0,0,NULL,'57502de6-1e0c-41d0-84e3-fe1b0b8839c8'),('2025-11-29 05:35:54.644431','2025-11-29 05:35:59.669954','2025-11-29 05:36:06.062204',46,46,NULL,'4453ce436b30425fba6f22e4043ef796','snapshot_gigabytes',0,0,NULL,'57502de6-1e0c-41d0-84e3-fe1b0b8839c8'),('2025-11-29 05:35:54.929465','2025-11-29 05:35:58.778591','2025-11-29 05:36:34.555372',47,47,NULL,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',0,0,NULL,'77e59b2f-3ee6-4ed4-b09e-dedd3f47a51b'),('2025-11-29 05:35:54.931209','2025-11-29 05:35:58.778592','2025-11-29 05:36:34.555372',48,48,NULL,'c6b8afea074442b2b9cd8ed762e06d27','shares',0,0,NULL,'77e59b2f-3ee6-4ed4-b09e-dedd3f47a51b'),('2025-11-29 05:35:58.765458','2025-11-29 05:36:03.076436',NULL,0,49,'b05695659a244b0999eccfed65868fdb','98fe5191e55f4f689dfe66e587ac3ee6','gigabytes',0,0,NULL,NULL),('2025-11-29 05:35:58.767486','2025-11-29 05:36:03.076438',NULL,0,50,'b05695659a244b0999eccfed65868fdb','98fe5191e55f4f689dfe66e587ac3ee6','shares',0,0,NULL,NULL),('2025-11-29 05:35:58.778213','2025-11-29 05:36:03.076440','2025-11-29 05:36:06.062326',51,51,NULL,'98fe5191e55f4f689dfe66e587ac3ee6','gigabytes',0,0,NULL,'80792ca9-8a81-49c4-baba-8e68998249cb'),('2025-11-29 05:35:58.780411','2025-11-29 05:36:03.076441','2025-11-29 05:36:06.062326',52,52,NULL,'98fe5191e55f4f689dfe66e587ac3ee6','shares',0,0,NULL,'80792ca9-8a81-49c4-baba-8e68998249cb'),('2025-11-29 05:35:58.971556','2025-11-29 05:36:06.409991','2025-11-29 05:36:34.367348',53,53,NULL,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',0,0,NULL,'62dda89e-c74f-4ef4-9255-9731f4924d04'),('2025-11-29 05:35:58.974041','2025-11-29 05:36:06.409993','2025-11-29 05:36:34.367348',54,54,NULL,'c6b8afea074442b2b9cd8ed762e06d27','shares',0,0,NULL,'62dda89e-c74f-4ef4-9255-9731f4924d04'),('2025-11-29 05:36:02.494545','2025-11-29 05:36:06.114227','2025-11-29 05:36:34.018654',55,55,NULL,'c6b8afea074442b2b9cd8ed762e06d27','shares',0,0,NULL,'03e2ced0-98dd-40d4-ad9e-7539269b2b2c'),('2025-11-29 05:36:02.496998','2025-11-29 05:36:06.114229','2025-11-29 05:36:34.018654',56,56,NULL,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',0,0,NULL,'03e2ced0-98dd-40d4-ad9e-7539269b2b2c'),('2025-11-29 05:36:06.798143','2025-11-29 05:36:18.921520','2025-11-29 05:36:33.721596',57,57,NULL,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',0,0,NULL,'e5dc9337-9d3d-486c-9f20-360499be97a6'),('2025-11-29 05:36:06.800634','2025-11-29 05:36:18.921521','2025-11-29 05:36:33.721596',58,58,NULL,'c6b8afea074442b2b9cd8ed762e06d27','shares',0,0,NULL,'e5dc9337-9d3d-486c-9f20-360499be97a6'),('2025-11-29 05:36:10.678697','2025-11-29 05:36:18.650564','2025-11-29 05:36:33.271464',59,59,NULL,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',0,0,NULL,'bb4c2cdc-b39c-4d8f-a756-4b5a9da20637'),('2025-11-29 05:36:10.680766','2025-11-29 05:36:18.650565','2025-11-29 05:36:33.271464',60,60,NULL,'c6b8afea074442b2b9cd8ed762e06d27','shares',0,0,NULL,'bb4c2cdc-b39c-4d8f-a756-4b5a9da20637'),('2025-11-29 05:36:12.199967','2025-11-29 05:36:15.040519',NULL,0,61,'e834d9d8dc83417ea6c9ba3e6be16616','0448e6e78f8747efb1e6a68338df9866','share_networks',0,0,NULL,NULL),('2025-11-29 05:36:12.884636','2025-11-29 05:36:12.931723',NULL,0,62,'a482e699f6dc4efba8a01a70832bb439','061705ddc30c4a188ae026c064f1a2b8','share_networks',1,0,NULL,NULL),('2025-11-29 05:36:14.393046','2025-11-29 05:36:18.340089','2025-11-29 05:36:32.942771',63,63,NULL,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',0,0,NULL,'644aee24-dced-4b70-b164-4e0bd00ebe5c'),('2025-11-29 05:36:14.394850','2025-11-29 05:36:18.340090','2025-11-29 05:36:32.942771',64,64,NULL,'c6b8afea074442b2b9cd8ed762e06d27','shares',0,0,NULL,'644aee24-dced-4b70-b164-4e0bd00ebe5c'),('2025-11-29 05:36:19.201668','2025-11-29 05:36:27.390611','2025-11-29 05:36:32.190097',65,65,NULL,'c6b8afea074442b2b9cd8ed762e06d27','shares',0,0,NULL,'a681e9d5-0cbf-4919-9306-45c3663a2e71'),('2025-11-29 05:36:19.204445','2025-11-29 05:36:27.390612','2025-11-29 05:36:32.190097',66,66,NULL,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',0,0,NULL,'a681e9d5-0cbf-4919-9306-45c3663a2e71'),('2025-11-29 05:36:23.001749','2025-11-29 05:36:27.141894','2025-11-29 05:36:31.915653',67,67,NULL,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',0,0,NULL,'83704507-2af4-41ec-bd6a-c7c15772addd'),('2025-11-29 05:36:23.005437','2025-11-29 05:36:27.141895','2025-11-29 05:36:31.915653',68,68,NULL,'c6b8afea074442b2b9cd8ed762e06d27','shares',0,0,NULL,'83704507-2af4-41ec-bd6a-c7c15772addd'),('2025-11-29 05:36:23.484856','2025-11-29 05:36:23.529387','2025-11-29 05:36:27.202363',69,69,'df986af3d0c84127a1e3fbaab7aaf38b','c48d0a2145674172882133c87bb61929','shares',1,0,NULL,NULL),('2025-11-29 05:36:23.487255','2025-11-29 05:36:23.529390','2025-11-29 05:36:27.202363',70,70,'df986af3d0c84127a1e3fbaab7aaf38b','c48d0a2145674172882133c87bb61929','gigabytes',1,0,NULL,NULL),('2025-11-29 05:36:23.496525','2025-11-29 05:36:23.529391','2025-11-29 05:36:27.202363',71,71,NULL,'c48d0a2145674172882133c87bb61929','shares',1,0,NULL,'f0da18b9-ba8c-41ec-8938-860c87e4760c'),('2025-11-29 05:36:23.498381','2025-11-29 05:36:23.529392','2025-11-29 05:36:27.202363',72,72,NULL,'c48d0a2145674172882133c87bb61929','gigabytes',1,0,NULL,'f0da18b9-ba8c-41ec-8938-860c87e4760c'),('2025-11-29 05:36:27.380505','2025-11-29 05:36:27.688431','2025-11-29 05:36:35.397294',73,73,'df986af3d0c84127a1e3fbaab7aaf38b','c48d0a2145674172882133c87bb61929','gigabytes',2,0,NULL,NULL),('2025-11-29 05:36:27.383476','2025-11-29 05:36:27.688434','2025-11-29 05:36:35.397294',74,74,'df986af3d0c84127a1e3fbaab7aaf38b','c48d0a2145674172882133c87bb61929','shares',2,0,NULL,NULL),('2025-11-29 05:36:27.602941','2025-11-29 05:36:31.660951','2025-11-29 05:36:31.785492',75,75,NULL,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',0,0,NULL,'7d4fb520-be4b-4ab9-a6cf-8d815f406791'),('2025-11-29 05:36:27.606598','2025-11-29 05:36:31.660952','2025-11-29 05:36:31.785492',76,76,NULL,'c6b8afea074442b2b9cd8ed762e06d27','shares',0,0,NULL,'7d4fb520-be4b-4ab9-a6cf-8d815f406791'),('2025-11-29 05:36:27.650827','2025-11-29 05:36:27.688435','2025-11-29 05:36:35.397294',77,77,NULL,'c48d0a2145674172882133c87bb61929','gigabytes',1,0,NULL,'1f1645da-a938-4300-adbc-b0962ae574cd'),('2025-11-29 05:36:27.655021','2025-11-29 05:36:27.688437','2025-11-29 05:36:35.397294',78,78,NULL,'c48d0a2145674172882133c87bb61929','shares',1,0,NULL,'1f1645da-a938-4300-adbc-b0962ae574cd'),('2025-11-29 05:36:31.441378','2025-11-29 05:36:31.547386','2025-11-29 05:36:35.397294',79,79,'df986af3d0c84127a1e3fbaab7aaf38b','c48d0a2145674172882133c87bb61929','snapshots',1,0,NULL,NULL),('2025-11-29 05:36:31.444214','2025-11-29 05:36:31.547389','2025-11-29 05:36:35.397294',80,80,'df986af3d0c84127a1e3fbaab7aaf38b','c48d0a2145674172882133c87bb61929','snapshot_gigabytes',1,0,NULL,NULL),('2025-11-29 05:36:31.464734','2025-11-29 05:36:31.547390','2025-11-29 05:36:35.397294',81,81,NULL,'c48d0a2145674172882133c87bb61929','snapshots',1,0,NULL,'1f1645da-a938-4300-adbc-b0962ae574cd'),('2025-11-29 05:36:31.466917','2025-11-29 05:36:31.547391','2025-11-29 05:36:35.397294',82,82,NULL,'c48d0a2145674172882133c87bb61929','snapshot_gigabytes',1,0,NULL,'1f1645da-a938-4300-adbc-b0962ae574cd'),('2025-11-29 05:36:35.492829','2025-11-29 05:36:48.456077',NULL,0,83,'9b2862373bbf44779eeacbfbcfe988ee','0c1d652029574d0fa397d5399235f790','gigabytes',0,0,NULL,NULL),('2025-11-29 05:36:35.494834','2025-11-29 05:36:48.456080',NULL,0,84,'9b2862373bbf44779eeacbfbcfe988ee','0c1d652029574d0fa397d5399235f790','shares',0,0,NULL,NULL),('2025-11-29 05:36:35.504772','2025-11-29 05:36:48.456082','2025-11-29 05:36:51.823116',85,85,NULL,'0c1d652029574d0fa397d5399235f790','gigabytes',0,0,NULL,'7f2792d4-06d9-4366-b057-6d917cc2fefa'),('2025-11-29 05:36:35.507660','2025-11-29 05:36:48.456084','2025-11-29 05:36:51.823116',86,86,NULL,'0c1d652029574d0fa397d5399235f790','shares',0,0,NULL,'7f2792d4-06d9-4366-b057-6d917cc2fefa'),('2025-11-29 05:36:39.248520','2025-11-29 05:36:44.797019',NULL,0,87,'9b2862373bbf44779eeacbfbcfe988ee','0c1d652029574d0fa397d5399235f790','snapshots',0,0,NULL,NULL),('2025-11-29 05:36:39.250540','2025-11-29 05:36:44.797022',NULL,0,88,'9b2862373bbf44779eeacbfbcfe988ee','0c1d652029574d0fa397d5399235f790','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-29 05:36:39.282232','2025-11-29 05:36:44.797023','2025-11-29 05:36:51.823116',89,89,NULL,'0c1d652029574d0fa397d5399235f790','snapshots',0,0,NULL,'7f2792d4-06d9-4366-b057-6d917cc2fefa'),('2025-11-29 05:36:39.284552','2025-11-29 05:36:44.797025','2025-11-29 05:36:51.823116',90,90,NULL,'0c1d652029574d0fa397d5399235f790','snapshot_gigabytes',0,0,NULL,'7f2792d4-06d9-4366-b057-6d917cc2fefa'),('2025-11-29 05:36:45.744237','2025-11-29 05:36:51.031218',NULL,0,91,'6c79efccd5e949dba16681088657b988','4ebe049df4f04fa2a5f37dadb54a1497','gigabytes',0,0,NULL,NULL),('2025-11-29 05:36:45.746265','2025-11-29 05:36:51.031221',NULL,0,92,'6c79efccd5e949dba16681088657b988','4ebe049df4f04fa2a5f37dadb54a1497','shares',0,0,NULL,NULL),('2025-11-29 05:36:45.756067','2025-11-29 05:36:51.031222','2025-11-29 05:36:54.194868',93,93,NULL,'4ebe049df4f04fa2a5f37dadb54a1497','gigabytes',0,0,NULL,'eb844929-18ba-4d18-8fc0-5ba67aa3721e'),('2025-11-29 05:36:45.759234','2025-11-29 05:36:51.031223','2025-11-29 05:36:54.194868',94,94,NULL,'4ebe049df4f04fa2a5f37dadb54a1497','shares',0,0,NULL,'eb844929-18ba-4d18-8fc0-5ba67aa3721e'),('2025-11-29 05:36:47.596101','2025-11-29 05:36:47.635144',NULL,0,95,'df986af3d0c84127a1e3fbaab7aaf38b','c48d0a2145674172882133c87bb61929','snapshots',-1,0,NULL,NULL),('2025-11-29 05:36:47.600697','2025-11-29 05:36:47.635148',NULL,0,96,'df986af3d0c84127a1e3fbaab7aaf38b','c48d0a2145674172882133c87bb61929','snapshot_gigabytes',-1,0,NULL,NULL),('2025-11-29 05:36:47.617703','2025-11-29 05:36:47.635150','2025-11-29 05:36:54.392075',97,97,NULL,'c48d0a2145674172882133c87bb61929','snapshots',-1,0,NULL,'1f1645da-a938-4300-adbc-b0962ae574cd'),('2025-11-29 05:36:47.621709','2025-11-29 05:36:47.635152','2025-11-29 05:36:54.392075',98,98,NULL,'c48d0a2145674172882133c87bb61929','snapshot_gigabytes',-1,0,NULL,'1f1645da-a938-4300-adbc-b0962ae574cd'),('2025-11-29 05:36:51.108371','2025-11-29 05:36:55.341887',NULL,0,99,'df986af3d0c84127a1e3fbaab7aaf38b','c48d0a2145674172882133c87bb61929','gigabytes',0,0,NULL,NULL),('2025-11-29 05:36:51.112448','2025-11-29 05:36:55.341890',NULL,0,100,'df986af3d0c84127a1e3fbaab7aaf38b','c48d0a2145674172882133c87bb61929','shares',0,0,NULL,NULL),('2025-11-29 05:36:51.121723','2025-11-29 05:36:51.137505','2025-11-29 05:36:54.392075',101,101,NULL,'c48d0a2145674172882133c87bb61929','gigabytes',0,0,NULL,'1f1645da-a938-4300-adbc-b0962ae574cd'),('2025-11-29 05:36:51.126322','2025-11-29 05:36:51.137507','2025-11-29 05:36:54.392075',102,102,NULL,'c48d0a2145674172882133c87bb61929','shares',0,0,NULL,'1f1645da-a938-4300-adbc-b0962ae574cd'),('2025-11-29 05:36:55.297892','2025-11-29 05:36:55.341892','2025-11-29 05:36:58.763695',103,103,NULL,'c48d0a2145674172882133c87bb61929','gigabytes',0,0,NULL,'f0da18b9-ba8c-41ec-8938-860c87e4760c'),('2025-11-29 05:36:55.315392','2025-11-29 05:36:55.341893','2025-11-29 05:36:58.763695',104,104,NULL,'c48d0a2145674172882133c87bb61929','shares',0,0,NULL,'f0da18b9-ba8c-41ec-8938-860c87e4760c'),('2025-11-29 05:36:58.612622','2025-11-29 05:37:18.662483',NULL,0,105,'c137c6e1ac7f469f9c4483dd53883c2d','f5d6fcc020694561b091889318c2561b','shares',0,0,NULL,NULL),('2025-11-29 05:36:58.617405','2025-11-29 05:37:18.662486',NULL,0,106,'c137c6e1ac7f469f9c4483dd53883c2d','f5d6fcc020694561b091889318c2561b','gigabytes',0,0,NULL,NULL),('2025-11-29 05:36:58.630389','2025-11-29 05:37:18.662487','2025-11-29 05:37:21.767848',107,107,NULL,'f5d6fcc020694561b091889318c2561b','shares',0,0,NULL,'819b63e0-5000-4547-bb28-596952ee3776'),('2025-11-29 05:36:58.632325','2025-11-29 05:37:18.662488','2025-11-29 05:37:21.767848',108,108,NULL,'f5d6fcc020694561b091889318c2561b','gigabytes',0,0,NULL,'819b63e0-5000-4547-bb28-596952ee3776'),('2025-11-29 05:37:02.771163','2025-11-29 05:37:09.303941',NULL,0,109,'26c05bae74e84e93a6448d0d1c0e707e','883530c38e954d818c0c7e7a75eaf2e2','shares',0,0,NULL,NULL),('2025-11-29 05:37:02.773143','2025-11-29 05:37:09.303944',NULL,0,110,'26c05bae74e84e93a6448d0d1c0e707e','883530c38e954d818c0c7e7a75eaf2e2','gigabytes',0,0,NULL,NULL),('2025-11-29 05:37:02.790265','2025-11-29 05:37:09.303945','2025-11-29 05:37:12.679651',111,111,NULL,'883530c38e954d818c0c7e7a75eaf2e2','shares',0,0,NULL,'12e06c28-78cd-4240-8800-3060cf711953'),('2025-11-29 05:37:02.792819','2025-11-29 05:37:09.303946','2025-11-29 05:37:12.679651',112,112,NULL,'883530c38e954d818c0c7e7a75eaf2e2','gigabytes',0,0,NULL,'12e06c28-78cd-4240-8800-3060cf711953'),('2025-11-29 05:37:17.234403','2025-11-29 05:37:34.114095',NULL,0,113,'4522755852d94dd7bbf637007ec21bf0','ecd2e5916bab4f7cb242a87ec782ffda','shares',0,0,NULL,NULL),('2025-11-29 05:37:17.238864','2025-11-29 05:37:34.114098',NULL,0,114,'4522755852d94dd7bbf637007ec21bf0','ecd2e5916bab4f7cb242a87ec782ffda','gigabytes',0,0,NULL,NULL),('2025-11-29 05:37:17.251661','2025-11-29 05:37:34.114099','2025-11-29 05:37:37.250386',115,115,NULL,'ecd2e5916bab4f7cb242a87ec782ffda','shares',0,0,NULL,'3cde5f7b-914b-4874-be2f-d7385fe4a149'),('2025-11-29 05:37:17.254195','2025-11-29 05:37:34.114100','2025-11-29 05:37:37.250386',116,116,NULL,'ecd2e5916bab4f7cb242a87ec782ffda','gigabytes',0,0,NULL,'3cde5f7b-914b-4874-be2f-d7385fe4a149'),('2025-11-29 05:37:19.058154','2025-11-29 05:40:36.438352',NULL,0,117,'a0f1e714fbec450395a7fdccce008b46','5dd620782ecb48b9af309e8bc536acb2','shares',0,0,NULL,NULL),('2025-11-29 05:37:19.061928','2025-11-29 05:40:36.438355',NULL,0,118,'a0f1e714fbec450395a7fdccce008b46','5dd620782ecb48b9af309e8bc536acb2','gigabytes',0,0,NULL,NULL),('2025-11-29 05:37:19.076174','2025-11-29 05:40:36.438357',NULL,0,119,NULL,'5dd620782ecb48b9af309e8bc536acb2','shares',1,0,NULL,'27ce7e9e-5dd7-42c3-997a-123357081bf4'),('2025-11-29 05:37:19.077972','2025-11-29 05:40:36.438359',NULL,0,120,NULL,'5dd620782ecb48b9af309e8bc536acb2','gigabytes',1,0,NULL,'27ce7e9e-5dd7-42c3-997a-123357081bf4'),('2025-11-29 05:37:21.020006','2025-11-29 05:37:30.846616',NULL,0,121,'4522755852d94dd7bbf637007ec21bf0','ecd2e5916bab4f7cb242a87ec782ffda','snapshots',0,0,NULL,NULL),('2025-11-29 05:37:21.022435','2025-11-29 05:37:30.846620',NULL,0,122,'4522755852d94dd7bbf637007ec21bf0','ecd2e5916bab4f7cb242a87ec782ffda','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-29 05:37:21.032633','2025-11-29 05:37:30.846622','2025-11-29 05:37:37.250386',123,123,NULL,'ecd2e5916bab4f7cb242a87ec782ffda','snapshots',0,0,NULL,'3cde5f7b-914b-4874-be2f-d7385fe4a149'),('2025-11-29 05:37:21.034872','2025-11-29 05:37:30.846624','2025-11-29 05:37:37.250386',124,124,NULL,'ecd2e5916bab4f7cb242a87ec782ffda','snapshot_gigabytes',0,0,NULL,'3cde5f7b-914b-4874-be2f-d7385fe4a149'),('2025-11-29 05:37:21.472382','2025-11-29 05:37:24.225469',NULL,0,125,'d77f33e5f83b46d0a66fd3d5f2a35ad0','18a45827d98a489a902f5dbcfb422b2d','share_networks',1,0,NULL,NULL),('2025-11-29 05:37:35.660334','2025-11-29 05:37:49.171387',NULL,0,126,'ae0d2a4b8f3d478e8235b9dbe2b26c6b','f6fcbad6247d48c28eb3ae887b3704b3','gigabytes',1,0,NULL,NULL),('2025-11-29 05:37:35.663191','2025-11-29 05:37:49.171390',NULL,0,127,'ae0d2a4b8f3d478e8235b9dbe2b26c6b','f6fcbad6247d48c28eb3ae887b3704b3','shares',1,0,NULL,NULL),('2025-11-29 05:37:35.671860','2025-11-29 05:37:49.171391','2025-11-29 05:37:53.053602',128,128,NULL,'f6fcbad6247d48c28eb3ae887b3704b3','gigabytes',1,0,NULL,'15c7aea3-577a-4acc-8a07-1d147dd95e25'),('2025-11-29 05:37:35.674470','2025-11-29 05:37:49.171392','2025-11-29 05:37:53.053602',129,129,NULL,'f6fcbad6247d48c28eb3ae887b3704b3','shares',1,0,NULL,'15c7aea3-577a-4acc-8a07-1d147dd95e25'),('2025-11-29 05:37:39.484921','2025-11-29 05:37:40.454277',NULL,0,130,'5420544d13be4310a8a32043f9b7ab4d','88ea41f1eaaf4ed9b8f5335cd407f038','gigabytes',0,0,NULL,NULL),('2025-11-29 05:37:39.487499','2025-11-29 05:37:40.454280',NULL,0,131,'5420544d13be4310a8a32043f9b7ab4d','88ea41f1eaaf4ed9b8f5335cd407f038','shares',0,0,NULL,NULL),('2025-11-29 05:37:39.527204','2025-11-29 05:37:39.662991',NULL,0,132,'5420544d13be4310a8a32043f9b7ab4d','f6fcbad6247d48c28eb3ae887b3704b3','gigabytes',-1,0,NULL,NULL),('2025-11-29 05:37:39.530575','2025-11-29 05:37:39.662993',NULL,0,133,'5420544d13be4310a8a32043f9b7ab4d','f6fcbad6247d48c28eb3ae887b3704b3','shares',-1,0,NULL,NULL),('2025-11-29 05:37:40.435845','2025-11-29 05:37:40.454281','2025-11-29 05:37:53.053602',134,134,NULL,'88ea41f1eaaf4ed9b8f5335cd407f038','gigabytes',0,0,NULL,'15c7aea3-577a-4acc-8a07-1d147dd95e25'),('2025-11-29 05:37:40.441804','2025-11-29 05:37:40.454283','2025-11-29 05:37:53.053602',135,135,NULL,'88ea41f1eaaf4ed9b8f5335cd407f038','shares',0,0,NULL,'15c7aea3-577a-4acc-8a07-1d147dd95e25'),('2025-11-29 05:37:48.407397','2025-11-29 05:38:08.653595',NULL,0,136,'3e0f252f8cc84922a46c637bf75d9b12','bf7ea2709c674f5da87071b7a3ab3ac1','shares',0,0,NULL,NULL),('2025-11-29 05:37:48.409351','2025-11-29 05:38:08.653602',NULL,0,137,'3e0f252f8cc84922a46c637bf75d9b12','bf7ea2709c674f5da87071b7a3ab3ac1','gigabytes',0,0,NULL,NULL),('2025-11-29 05:37:48.419662','2025-11-29 05:37:52.248643','2025-11-29 05:38:09.779501',138,138,NULL,'bf7ea2709c674f5da87071b7a3ab3ac1','shares',0,0,NULL,'1d21dac2-ed08-46ff-8c64-215bda949560'),('2025-11-29 05:37:48.421835','2025-11-29 05:37:52.248644','2025-11-29 05:38:09.779501',139,139,NULL,'bf7ea2709c674f5da87071b7a3ab3ac1','gigabytes',0,0,NULL,'1d21dac2-ed08-46ff-8c64-215bda949560'),('2025-11-29 05:37:52.517102','2025-11-29 05:37:56.528607','2025-11-29 05:38:09.588700',140,140,NULL,'bf7ea2709c674f5da87071b7a3ab3ac1','gigabytes',0,0,NULL,'407c3566-cec9-4eac-baeb-e009fd1528f3'),('2025-11-29 05:37:52.519026','2025-11-29 05:37:56.528608','2025-11-29 05:38:09.588700',141,141,NULL,'bf7ea2709c674f5da87071b7a3ab3ac1','shares',0,0,NULL,'407c3566-cec9-4eac-baeb-e009fd1528f3'),('2025-11-29 05:37:55.103311','2025-11-29 05:38:19.127004',NULL,0,142,'6de51f96bd584575956b19290f27af8f','e577c04bfe1b459f9aebd0f826827833','gigabytes',0,0,NULL,NULL),('2025-11-29 05:37:55.105255','2025-11-29 05:38:19.127007',NULL,0,143,'6de51f96bd584575956b19290f27af8f','e577c04bfe1b459f9aebd0f826827833','shares',0,0,NULL,NULL),('2025-11-29 05:37:55.113610','2025-11-29 05:38:19.127008','2025-11-29 05:38:21.215398',144,144,NULL,'e577c04bfe1b459f9aebd0f826827833','gigabytes',0,0,NULL,'9d07efed-6109-49c2-afdb-237feef528bc'),('2025-11-29 05:37:55.116028','2025-11-29 05:38:19.127009','2025-11-29 05:38:21.215398',145,145,NULL,'e577c04bfe1b459f9aebd0f826827833','shares',0,0,NULL,'9d07efed-6109-49c2-afdb-237feef528bc'),('2025-11-29 05:37:56.762644','2025-11-29 05:38:00.716315','2025-11-29 05:38:09.384717',146,146,NULL,'bf7ea2709c674f5da87071b7a3ab3ac1','gigabytes',0,0,NULL,'3e7b666b-a9bd-4c69-8060-6813139fdc67'),('2025-11-29 05:37:56.764581','2025-11-29 05:38:00.716316','2025-11-29 05:38:09.384717',147,147,NULL,'bf7ea2709c674f5da87071b7a3ab3ac1','shares',0,0,NULL,'3e7b666b-a9bd-4c69-8060-6813139fdc67'),('2025-11-29 05:38:00.964896','2025-11-29 05:38:04.702760','2025-11-29 05:38:09.151613',148,148,NULL,'bf7ea2709c674f5da87071b7a3ab3ac1','gigabytes',0,0,NULL,'bfcc714f-2a94-4cb0-9045-624924898779'),('2025-11-29 05:38:00.967175','2025-11-29 05:38:04.702762','2025-11-29 05:38:09.151613',149,149,NULL,'bf7ea2709c674f5da87071b7a3ab3ac1','shares',0,0,NULL,'bfcc714f-2a94-4cb0-9045-624924898779'),('2025-11-29 05:38:04.954188','2025-11-29 05:38:08.653604','2025-11-29 05:38:08.995405',150,150,NULL,'bf7ea2709c674f5da87071b7a3ab3ac1','gigabytes',0,0,NULL,'3b823b97-f6b7-4e10-a49b-8c78cf594d17'),('2025-11-29 05:38:04.956056','2025-11-29 05:38:08.653606','2025-11-29 05:38:08.995405',151,151,NULL,'bf7ea2709c674f5da87071b7a3ab3ac1','shares',0,0,NULL,'3b823b97-f6b7-4e10-a49b-8c78cf594d17'),('2025-11-29 05:38:06.769812','2025-11-29 05:38:39.623497',NULL,0,152,'40461bcceb79486685576e03cd6143f7','bde0f89de7a5405e8d086a6415adbc5c','gigabytes',0,0,NULL,NULL),('2025-11-29 05:38:06.771504','2025-11-29 05:38:39.623500',NULL,0,153,'40461bcceb79486685576e03cd6143f7','bde0f89de7a5405e8d086a6415adbc5c','shares',0,0,NULL,NULL),('2025-11-29 05:38:06.778986','2025-11-29 05:38:39.623501','2025-11-29 05:38:43.778115',154,154,NULL,'bde0f89de7a5405e8d086a6415adbc5c','gigabytes',0,0,NULL,'7c6b9483-7c46-438e-a204-efa953929f7b'),('2025-11-29 05:38:06.780557','2025-11-29 05:38:39.623502','2025-11-29 05:38:43.778115',155,155,NULL,'bde0f89de7a5405e8d086a6415adbc5c','shares',0,0,NULL,'7c6b9483-7c46-438e-a204-efa953929f7b'),('2025-11-29 05:38:22.105297','2025-11-29 05:38:27.049149',NULL,0,156,'40461bcceb79486685576e03cd6143f7','bde0f89de7a5405e8d086a6415adbc5c','share_groups',0,0,NULL,NULL),('2025-11-29 05:38:27.949828','2025-11-29 05:38:39.558488',NULL,0,157,'9a169c12e24a428eb9de96579b83c947','0729e4f41a8346198e8cb057eba4c265','gigabytes',0,0,NULL,NULL),('2025-11-29 05:38:27.951930','2025-11-29 05:38:39.558491',NULL,0,158,'9a169c12e24a428eb9de96579b83c947','0729e4f41a8346198e8cb057eba4c265','shares',0,0,NULL,NULL),('2025-11-29 05:38:27.961860','2025-11-29 05:38:39.558492','2025-11-29 05:38:51.102637',159,159,NULL,'0729e4f41a8346198e8cb057eba4c265','gigabytes',0,0,NULL,'45b75960-3761-478e-bd9e-8a81899d6aa5'),('2025-11-29 05:38:27.964316','2025-11-29 05:38:39.558493','2025-11-29 05:38:51.102637',160,160,NULL,'0729e4f41a8346198e8cb057eba4c265','shares',0,0,NULL,'45b75960-3761-478e-bd9e-8a81899d6aa5'),('2025-11-29 05:38:31.550334','2025-11-29 05:38:47.268604',NULL,0,161,'116774de87694898ba2a8d06c7ac7069','352a7d8defe34a3486f41ba56e48d88e','gigabytes',0,0,NULL,NULL),('2025-11-29 05:38:31.552123','2025-11-29 05:38:47.268607',NULL,0,162,'116774de87694898ba2a8d06c7ac7069','352a7d8defe34a3486f41ba56e48d88e','shares',0,0,NULL,NULL),('2025-11-29 05:38:31.603659','2025-11-29 05:38:47.268608','2025-11-29 05:38:51.102637',163,163,NULL,'352a7d8defe34a3486f41ba56e48d88e','gigabytes',0,0,NULL,'45b75960-3761-478e-bd9e-8a81899d6aa5'),('2025-11-29 05:38:31.606914','2025-11-29 05:38:47.268609','2025-11-29 05:38:51.102637',164,164,NULL,'352a7d8defe34a3486f41ba56e48d88e','shares',0,0,NULL,'45b75960-3761-478e-bd9e-8a81899d6aa5'),('2025-11-29 05:38:32.042414','2025-11-29 05:38:37.978439',NULL,0,165,'32a388e3f3e241ffb7aa37e8bb62baba','ae2a6e9fbea0426ebacf2fe56abb903e','gigabytes',0,0,NULL,NULL),('2025-11-29 05:38:32.046012','2025-11-29 05:38:37.978445',NULL,0,166,'32a388e3f3e241ffb7aa37e8bb62baba','ae2a6e9fbea0426ebacf2fe56abb903e','shares',0,0,NULL,NULL),('2025-11-29 05:38:32.236458','2025-11-29 05:38:37.978447','2025-11-29 05:38:40.662169',167,167,NULL,'ae2a6e9fbea0426ebacf2fe56abb903e','gigabytes',0,0,NULL,'52f50bf6-cbc7-4a08-9f56-cebb024fa773'),('2025-11-29 05:38:32.238995','2025-11-29 05:38:37.978450','2025-11-29 05:38:40.662169',168,168,NULL,'ae2a6e9fbea0426ebacf2fe56abb903e','shares',0,0,NULL,'52f50bf6-cbc7-4a08-9f56-cebb024fa773'),('2025-11-29 05:38:49.830315','2025-11-29 05:39:02.270434',NULL,0,169,'18ebde6642cb44c1bd4ab1e5fa932abd','177e0fe42e604553bd3b076a784b5e9d','gigabytes',0,0,NULL,NULL),('2025-11-29 05:38:49.832140','2025-11-29 05:39:02.270437',NULL,0,170,'18ebde6642cb44c1bd4ab1e5fa932abd','177e0fe42e604553bd3b076a784b5e9d','shares',0,0,NULL,NULL),('2025-11-29 05:38:49.841705','2025-11-29 05:39:02.270438','2025-11-29 05:39:05.425138',171,171,NULL,'177e0fe42e604553bd3b076a784b5e9d','gigabytes',0,0,NULL,'3715bc74-5c5d-42b9-996c-80000d22afc6'),('2025-11-29 05:38:49.844100','2025-11-29 05:39:02.270439','2025-11-29 05:39:05.425138',172,172,NULL,'177e0fe42e604553bd3b076a784b5e9d','shares',0,0,NULL,'3715bc74-5c5d-42b9-996c-80000d22afc6'),('2025-11-29 05:38:53.400304','2025-11-29 05:38:58.743814',NULL,0,173,'18ebde6642cb44c1bd4ab1e5fa932abd','177e0fe42e604553bd3b076a784b5e9d','snapshots',0,0,NULL,NULL),('2025-11-29 05:38:53.402928','2025-11-29 05:38:58.743820',NULL,0,174,'18ebde6642cb44c1bd4ab1e5fa932abd','177e0fe42e604553bd3b076a784b5e9d','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-29 05:38:53.415097','2025-11-29 05:38:58.743822','2025-11-29 05:39:05.425138',175,175,NULL,'177e0fe42e604553bd3b076a784b5e9d','snapshots',0,0,NULL,'3715bc74-5c5d-42b9-996c-80000d22afc6'),('2025-11-29 05:38:53.417878','2025-11-29 05:38:58.743825','2025-11-29 05:39:05.425138',176,176,NULL,'177e0fe42e604553bd3b076a784b5e9d','snapshot_gigabytes',0,0,NULL,'3715bc74-5c5d-42b9-996c-80000d22afc6'),('2025-11-29 05:39:01.705187','2025-11-29 05:39:10.375150',NULL,0,177,'6bb380b85f054d16ac066ab6ea1e4f89','96790676f7be41c7bf96036d7e07ffb2','shares',0,0,NULL,NULL),('2025-11-29 05:39:01.707916','2025-11-29 05:39:10.375154',NULL,0,178,'6bb380b85f054d16ac066ab6ea1e4f89','96790676f7be41c7bf96036d7e07ffb2','gigabytes',0,0,NULL,NULL),('2025-11-29 05:39:01.719252','2025-11-29 05:39:10.375155','2025-11-29 05:39:13.344828',179,179,NULL,'96790676f7be41c7bf96036d7e07ffb2','shares',0,0,NULL,'85b2d88e-0dba-4f04-9990-9dd773d71543'),('2025-11-29 05:39:01.721763','2025-11-29 05:39:10.375157','2025-11-29 05:39:13.344828',180,180,NULL,'96790676f7be41c7bf96036d7e07ffb2','gigabytes',0,0,NULL,'85b2d88e-0dba-4f04-9990-9dd773d71543'),('2025-11-29 05:39:09.796888','2025-11-29 05:40:30.879733',NULL,0,181,'6b29bd6ef300472cad86c5c5a7341f17','96857e43ebcb4e019650999b54e535a1','gigabytes',0,0,NULL,NULL),('2025-11-29 05:39:09.803886','2025-11-29 05:40:30.879735',NULL,0,182,'6b29bd6ef300472cad86c5c5a7341f17','96857e43ebcb4e019650999b54e535a1','shares',0,0,NULL,NULL),('2025-11-29 05:39:09.819240','2025-11-29 05:39:21.287295','2025-11-29 05:39:24.490305',183,183,NULL,'96857e43ebcb4e019650999b54e535a1','gigabytes',0,0,NULL,'7a4d5f0d-6975-4e09-abb0-f0f03a3782cc'),('2025-11-29 05:39:09.822253','2025-11-29 05:39:21.287297','2025-11-29 05:39:24.490305',184,184,NULL,'96857e43ebcb4e019650999b54e535a1','shares',0,0,NULL,'7a4d5f0d-6975-4e09-abb0-f0f03a3782cc'),('2025-11-29 05:39:13.293369','2025-11-29 05:40:27.439814',NULL,0,185,'6b29bd6ef300472cad86c5c5a7341f17','96857e43ebcb4e019650999b54e535a1','snapshots',0,0,NULL,NULL),('2025-11-29 05:39:13.296212','2025-11-29 05:40:27.439817',NULL,0,186,'6b29bd6ef300472cad86c5c5a7341f17','96857e43ebcb4e019650999b54e535a1','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-29 05:39:13.314330','2025-11-29 05:39:17.853966','2025-11-29 05:39:24.490305',187,187,NULL,'96857e43ebcb4e019650999b54e535a1','snapshots',0,0,NULL,'7a4d5f0d-6975-4e09-abb0-f0f03a3782cc'),('2025-11-29 05:39:13.317037','2025-11-29 05:39:17.853968','2025-11-29 05:39:24.490305',188,188,NULL,'96857e43ebcb4e019650999b54e535a1','snapshot_gigabytes',0,0,NULL,'7a4d5f0d-6975-4e09-abb0-f0f03a3782cc'),('2025-11-29 05:39:22.555388','2025-11-29 05:40:29.353726',NULL,0,189,'d03f7b23a91648fc985ffb356cc04f1d','a05f740db7b94303aac90d6f217f853a','gigabytes',0,0,NULL,NULL),('2025-11-29 05:39:22.560848','2025-11-29 05:40:29.353729',NULL,0,190,'d03f7b23a91648fc985ffb356cc04f1d','a05f740db7b94303aac90d6f217f853a','shares',0,0,NULL,NULL),('2025-11-29 05:39:22.580776','2025-11-29 05:40:29.353730','2025-11-29 05:40:32.432241',191,191,NULL,'a05f740db7b94303aac90d6f217f853a','gigabytes',0,0,NULL,'f8c8a67f-7464-472c-90a6-c0d7c3ba1b5d'),('2025-11-29 05:39:22.587906','2025-11-29 05:40:29.353731','2025-11-29 05:40:32.432241',192,192,NULL,'a05f740db7b94303aac90d6f217f853a','shares',0,0,NULL,'f8c8a67f-7464-472c-90a6-c0d7c3ba1b5d'),('2025-11-29 05:39:23.157882','2025-11-29 05:39:25.622768',NULL,0,193,'99c4b856c6fa452b8782cfb49f32d4f9','423449a1e9f94864bc4aa1e26a05fb40','share_networks',0,0,NULL,NULL),('2025-11-29 05:39:24.692968','2025-11-29 05:39:28.727224','2025-11-29 05:40:35.156143',194,194,NULL,'96857e43ebcb4e019650999b54e535a1','gigabytes',0,0,NULL,'c2ed6f66-a14c-4a73-8308-2de1b36a4619'),('2025-11-29 05:39:24.695154','2025-11-29 05:39:28.727226','2025-11-29 05:40:35.156143',195,195,NULL,'96857e43ebcb4e019650999b54e535a1','shares',0,0,NULL,'c2ed6f66-a14c-4a73-8308-2de1b36a4619'),('2025-11-29 05:39:31.856280','2025-11-29 05:40:02.551655',NULL,0,196,'0cb50441bd6144cda55fbe51a4e87bce','49f85bf88a7641b492d9ed0e3cbb7c9c','gigabytes',0,0,NULL,NULL),('2025-11-29 05:39:31.858080','2025-11-29 05:40:02.551659',NULL,0,197,'0cb50441bd6144cda55fbe51a4e87bce','49f85bf88a7641b492d9ed0e3cbb7c9c','shares',0,0,NULL,NULL),('2025-11-29 05:39:31.868010','2025-11-29 05:40:02.551661','2025-11-29 05:40:05.697291',198,198,NULL,'49f85bf88a7641b492d9ed0e3cbb7c9c','gigabytes',0,0,NULL,'3ea6a207-e62f-4ff8-86d8-a7bd7b74ca3e'),('2025-11-29 05:39:31.870188','2025-11-29 05:40:02.551663','2025-11-29 05:40:05.697291',199,199,NULL,'49f85bf88a7641b492d9ed0e3cbb7c9c','shares',0,0,NULL,'3ea6a207-e62f-4ff8-86d8-a7bd7b74ca3e'),('2025-11-29 05:39:32.098022','2025-11-29 05:40:30.879736','2025-11-29 05:40:34.043153',200,200,NULL,'96857e43ebcb4e019650999b54e535a1','shares',0,0,NULL,'8cad685b-b732-4948-9276-cd3f373c0107'),('2025-11-29 05:39:32.099892','2025-11-29 05:40:30.879738','2025-11-29 05:40:34.043153',201,201,NULL,'96857e43ebcb4e019650999b54e535a1','gigabytes',0,0,NULL,'8cad685b-b732-4948-9276-cd3f373c0107'),('2025-11-29 05:39:35.484427','2025-11-29 05:40:27.439818','2025-11-29 05:40:34.043153',202,202,NULL,'96857e43ebcb4e019650999b54e535a1','snapshots',0,0,NULL,'8cad685b-b732-4948-9276-cd3f373c0107'),('2025-11-29 05:39:35.487485','2025-11-29 05:40:27.439819','2025-11-29 05:40:34.043153',203,203,NULL,'96857e43ebcb4e019650999b54e535a1','snapshot_gigabytes',0,0,NULL,'8cad685b-b732-4948-9276-cd3f373c0107'),('2025-11-29 05:40:21.705623','2025-11-29 05:40:21.742643',NULL,0,204,'f0f48ede370b4632ab7b21cc94cfb7ff','5dd620782ecb48b9af309e8bc536acb2','shares',1,0,NULL,NULL),('2025-11-29 05:40:21.707996','2025-11-29 05:40:21.742644',NULL,0,205,'f0f48ede370b4632ab7b21cc94cfb7ff','5dd620782ecb48b9af309e8bc536acb2','gigabytes',1,0,NULL,NULL),('2025-11-29 05:40:28.259455','2025-11-29 05:40:41.110706',NULL,0,206,'ac0b18a898c7459da335489d13ce6891','b6fbd26e87a649ef8a1685512e46f501','gigabytes',0,0,NULL,NULL),('2025-11-29 05:40:28.261654','2025-11-29 05:40:41.110708',NULL,0,207,'ac0b18a898c7459da335489d13ce6891','b6fbd26e87a649ef8a1685512e46f501','shares',0,0,NULL,NULL),('2025-11-29 05:40:28.272529','2025-11-29 05:40:41.110710','2025-11-29 05:40:44.233644',208,208,NULL,'b6fbd26e87a649ef8a1685512e46f501','gigabytes',0,0,NULL,'4bfe934f-b148-473c-af17-6b60d08583bb'),('2025-11-29 05:40:28.274757','2025-11-29 05:40:41.110711','2025-11-29 05:40:44.233644',209,209,NULL,'b6fbd26e87a649ef8a1685512e46f501','shares',0,0,NULL,'4bfe934f-b148-473c-af17-6b60d08583bb'),('2025-11-29 05:40:31.697677','2025-11-29 05:40:37.473563',NULL,0,210,'ac0b18a898c7459da335489d13ce6891','b6fbd26e87a649ef8a1685512e46f501','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-29 05:40:31.701034','2025-11-29 05:40:37.473568',NULL,0,211,'ac0b18a898c7459da335489d13ce6891','b6fbd26e87a649ef8a1685512e46f501','snapshots',0,0,NULL,NULL),('2025-11-29 05:40:31.712618','2025-11-29 05:40:37.473570','2025-11-29 05:40:44.233644',212,212,NULL,'b6fbd26e87a649ef8a1685512e46f501','snapshot_gigabytes',0,0,NULL,'4bfe934f-b148-473c-af17-6b60d08583bb'),('2025-11-29 05:40:31.716904','2025-11-29 05:40:37.473571','2025-11-29 05:40:44.233644',213,213,NULL,'b6fbd26e87a649ef8a1685512e46f501','snapshots',0,0,NULL,'4bfe934f-b148-473c-af17-6b60d08583bb'),('2025-11-29 05:40:40.917723','2025-11-29 05:41:43.323437',NULL,0,214,'f33c8cd93bfb451cb06212731cbb3a46','4e135fffa1e64bf8b2e43bd33b51cf15','shares',0,0,NULL,NULL),('2025-11-29 05:40:40.919493','2025-11-29 05:41:43.323439',NULL,0,215,'f33c8cd93bfb451cb06212731cbb3a46','4e135fffa1e64bf8b2e43bd33b51cf15','gigabytes',0,0,NULL,NULL),('2025-11-29 05:40:40.929734','2025-11-29 05:41:43.323440','2025-11-29 05:41:46.296424',216,216,NULL,'4e135fffa1e64bf8b2e43bd33b51cf15','shares',0,0,NULL,'5dcffc4d-5ae1-4806-beb0-c80557d3ef41'),('2025-11-29 05:40:40.931533','2025-11-29 05:41:43.323441','2025-11-29 05:41:46.296424',217,217,NULL,'4e135fffa1e64bf8b2e43bd33b51cf15','gigabytes',0,0,NULL,'5dcffc4d-5ae1-4806-beb0-c80557d3ef41'),('2025-11-29 05:40:43.547996','2025-11-29 05:41:35.848116',NULL,0,218,'e4d2d18fdb14465eacc082349a6e10a9','d26079c7d6c8427193b3786b26cb5b7e','gigabytes',0,0,NULL,NULL),('2025-11-29 05:40:43.550409','2025-11-29 05:41:35.848119',NULL,0,219,'e4d2d18fdb14465eacc082349a6e10a9','d26079c7d6c8427193b3786b26cb5b7e','shares',0,0,NULL,NULL),('2025-11-29 05:40:43.562153','2025-11-29 05:41:35.848120','2025-11-29 05:41:39.017722',220,220,NULL,'d26079c7d6c8427193b3786b26cb5b7e','gigabytes',0,0,NULL,'a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:40:43.565540','2025-11-29 05:41:35.848121','2025-11-29 05:41:39.017722',221,221,NULL,'d26079c7d6c8427193b3786b26cb5b7e','shares',0,0,NULL,'a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:40:44.603704','2025-11-29 05:41:39.499537',NULL,0,222,NULL,'4e135fffa1e64bf8b2e43bd33b51cf15','gigabytes',0,0,NULL,'dd081b42-5cd7-4c7c-8a9b-8db684f71e20'),('2025-11-29 05:40:44.605972','2025-11-29 05:41:39.499539',NULL,0,223,NULL,'4e135fffa1e64bf8b2e43bd33b51cf15','shares',0,0,NULL,'dd081b42-5cd7-4c7c-8a9b-8db684f71e20'),('2025-11-29 05:40:47.009756','2025-11-29 05:41:33.054663',NULL,0,224,'e4d2d18fdb14465eacc082349a6e10a9','d26079c7d6c8427193b3786b26cb5b7e','snapshots',0,0,NULL,NULL),('2025-11-29 05:40:47.013606','2025-11-29 05:41:33.054666',NULL,0,225,'e4d2d18fdb14465eacc082349a6e10a9','d26079c7d6c8427193b3786b26cb5b7e','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-29 05:40:47.033846','2025-11-29 05:41:33.054668','2025-11-29 05:41:39.017722',226,226,NULL,'d26079c7d6c8427193b3786b26cb5b7e','snapshots',0,0,NULL,'a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:40:47.036736','2025-11-29 05:41:33.054670','2025-11-29 05:41:39.017722',227,227,NULL,'d26079c7d6c8427193b3786b26cb5b7e','snapshot_gigabytes',0,0,NULL,'a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:40:48.707919','2025-11-29 05:41:35.990761',NULL,0,228,'ee35284df12f4f4fad5f92cf5c9ec4e2','e97b8963e55a4094b1cb702d19d887ba','gigabytes',0,0,NULL,NULL),('2025-11-29 05:40:48.710409','2025-11-29 05:41:35.990764',NULL,0,229,'ee35284df12f4f4fad5f92cf5c9ec4e2','e97b8963e55a4094b1cb702d19d887ba','shares',0,0,NULL,NULL),('2025-11-29 05:40:48.740953','2025-11-29 05:41:35.990766',NULL,0,230,NULL,'e97b8963e55a4094b1cb702d19d887ba','gigabytes',0,0,NULL,'dd081b42-5cd7-4c7c-8a9b-8db684f71e20'),('2025-11-29 05:40:48.744576','2025-11-29 05:41:35.990767',NULL,0,231,NULL,'e97b8963e55a4094b1cb702d19d887ba','shares',0,0,NULL,'dd081b42-5cd7-4c7c-8a9b-8db684f71e20'),('2025-11-29 05:40:52.144367','2025-11-29 05:41:18.400346',NULL,0,232,'ea27d7612aa34955a6fb1f29750c8921','837f2bfa5aab4fdabd09b7661c70b7dd','gigabytes',0,0,NULL,NULL),('2025-11-29 05:40:52.146779','2025-11-29 05:41:18.400349',NULL,0,233,'ea27d7612aa34955a6fb1f29750c8921','837f2bfa5aab4fdabd09b7661c70b7dd','shares',0,0,NULL,NULL),('2025-11-29 05:40:52.155113','2025-11-29 05:41:18.400350','2025-11-29 05:41:21.605710',234,234,NULL,'837f2bfa5aab4fdabd09b7661c70b7dd','gigabytes',0,0,NULL,'deb5e28d-c187-482e-a13e-e6b5c6d26fe5'),('2025-11-29 05:40:52.156987','2025-11-29 05:41:18.400351','2025-11-29 05:41:21.605710',235,235,NULL,'837f2bfa5aab4fdabd09b7661c70b7dd','shares',0,0,NULL,'deb5e28d-c187-482e-a13e-e6b5c6d26fe5'),('2025-11-29 05:40:55.688081','2025-11-29 05:41:15.063674',NULL,0,236,'ea27d7612aa34955a6fb1f29750c8921','837f2bfa5aab4fdabd09b7661c70b7dd','snapshots',0,0,NULL,NULL),('2025-11-29 05:40:55.690232','2025-11-29 05:41:15.063678',NULL,0,237,'ea27d7612aa34955a6fb1f29750c8921','837f2bfa5aab4fdabd09b7661c70b7dd','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-29 05:40:55.730674','2025-11-29 05:41:15.063680','2025-11-29 05:41:21.605710',238,238,NULL,'837f2bfa5aab4fdabd09b7661c70b7dd','snapshots',0,0,NULL,'deb5e28d-c187-482e-a13e-e6b5c6d26fe5'),('2025-11-29 05:40:55.732842','2025-11-29 05:41:15.063681','2025-11-29 05:41:21.605710',239,239,NULL,'837f2bfa5aab4fdabd09b7661c70b7dd','snapshot_gigabytes',0,0,NULL,'deb5e28d-c187-482e-a13e-e6b5c6d26fe5'),('2025-11-29 05:40:57.483097','2025-11-29 05:41:01.427396',NULL,0,240,'d398b490db83489591c69a3c596fa374','9874b59670af413eabb2bba650c69242','share_networks',0,0,NULL,NULL),('2025-11-29 05:41:10.839039','2025-11-29 05:41:12.784538',NULL,0,241,'e56807404f594d2397401f8e0e2c9fbc','4d3c4eb0bcce4aec9fe2bc88309fe6bc','share_networks',0,0,NULL,NULL),('2025-11-29 05:41:17.715424','2025-11-29 05:41:33.140917','2025-11-29 05:41:46.296424',242,242,NULL,'e97b8963e55a4094b1cb702d19d887ba','gigabytes',0,0,NULL,'5dcffc4d-5ae1-4806-beb0-c80557d3ef41'),('2025-11-29 05:41:17.717259','2025-11-29 05:41:33.140919','2025-11-29 05:41:46.296424',243,243,NULL,'e97b8963e55a4094b1cb702d19d887ba','shares',0,0,NULL,'5dcffc4d-5ae1-4806-beb0-c80557d3ef41'),('2025-11-29 05:41:21.462038','2025-11-29 05:43:09.923464',NULL,0,244,'c8055d8ebb36432196034de4894bbc3b','388000b055144e48b6827e9f35029a82','gigabytes',0,0,NULL,NULL),('2025-11-29 05:41:21.465378','2025-11-29 05:43:09.923467',NULL,0,245,'c8055d8ebb36432196034de4894bbc3b','388000b055144e48b6827e9f35029a82','shares',0,0,NULL,NULL),('2025-11-29 05:41:21.480536','2025-11-29 05:43:09.923468','2025-11-29 05:43:12.981447',246,246,NULL,'388000b055144e48b6827e9f35029a82','gigabytes',0,0,NULL,'b66b9d87-f8e3-4b31-946b-971c6c719cad'),('2025-11-29 05:41:21.483629','2025-11-29 05:43:09.923470','2025-11-29 05:43:12.981447',247,247,NULL,'388000b055144e48b6827e9f35029a82','shares',0,0,NULL,'b66b9d87-f8e3-4b31-946b-971c6c719cad'),('2025-11-29 05:41:25.236618','2025-11-29 05:43:07.359162',NULL,0,248,'c8055d8ebb36432196034de4894bbc3b','388000b055144e48b6827e9f35029a82','snapshots',0,0,NULL,NULL),('2025-11-29 05:41:25.238612','2025-11-29 05:43:07.359165',NULL,0,249,'c8055d8ebb36432196034de4894bbc3b','388000b055144e48b6827e9f35029a82','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-29 05:41:25.246748','2025-11-29 05:43:07.359166','2025-11-29 05:43:12.981447',250,250,NULL,'388000b055144e48b6827e9f35029a82','snapshots',0,0,NULL,'b66b9d87-f8e3-4b31-946b-971c6c719cad'),('2025-11-29 05:41:25.249465','2025-11-29 05:43:07.359167','2025-11-29 05:43:12.981447',251,251,NULL,'388000b055144e48b6827e9f35029a82','snapshot_gigabytes',0,0,NULL,'b66b9d87-f8e3-4b31-946b-971c6c719cad'),('2025-11-29 05:42:12.408889','2025-11-29 05:42:17.062366',NULL,0,252,'cb8d9fe9ac8c4751bb6ac40883cce87b','eeaea5e509ca49be9d6a48ac7d8668b4','share_networks',0,0,NULL,NULL),('2025-11-29 05:42:24.048168','2025-11-29 05:42:24.309611',NULL,0,253,'af91f2be0ad34dd795af321a91ed6e47','d8ec1959e8bb450793ca093172af99e3','share_networks',1,0,NULL,NULL),('2025-11-29 05:42:41.995261','2025-11-29 05:42:54.063130',NULL,0,254,'89edac5a76e841118f3aa700b37de873','763ee5d3450f427ca1081cea0f991adc','gigabytes',0,0,NULL,NULL),('2025-11-29 05:42:41.998050','2025-11-29 05:42:54.063133',NULL,0,255,'89edac5a76e841118f3aa700b37de873','763ee5d3450f427ca1081cea0f991adc','shares',0,0,NULL,NULL),('2025-11-29 05:42:42.006392','2025-11-29 05:42:54.063134','2025-11-29 05:42:57.014725',256,256,NULL,'763ee5d3450f427ca1081cea0f991adc','gigabytes',0,0,NULL,'2aa1bdf2-4191-465c-96d1-d1331c081762'),('2025-11-29 05:42:42.009564','2025-11-29 05:42:54.063135','2025-11-29 05:42:57.014725',257,257,NULL,'763ee5d3450f427ca1081cea0f991adc','shares',0,0,NULL,'2aa1bdf2-4191-465c-96d1-d1331c081762'),('2025-11-29 05:42:45.319936','2025-11-29 05:42:50.546699',NULL,0,258,'89edac5a76e841118f3aa700b37de873','763ee5d3450f427ca1081cea0f991adc','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-29 05:42:45.322351','2025-11-29 05:42:50.546702',NULL,0,259,'89edac5a76e841118f3aa700b37de873','763ee5d3450f427ca1081cea0f991adc','snapshots',0,0,NULL,NULL),('2025-11-29 05:42:45.342341','2025-11-29 05:42:50.546703','2025-11-29 05:42:57.014725',260,260,NULL,'763ee5d3450f427ca1081cea0f991adc','snapshot_gigabytes',0,0,NULL,'2aa1bdf2-4191-465c-96d1-d1331c081762'),('2025-11-29 05:42:45.344862','2025-11-29 05:42:50.546704','2025-11-29 05:42:57.014725',261,261,NULL,'763ee5d3450f427ca1081cea0f991adc','snapshots',0,0,NULL,'2aa1bdf2-4191-465c-96d1-d1331c081762'),('2025-11-29 05:43:28.092704','2025-11-29 05:44:18.034127',NULL,0,262,'6f7f9251bec644a5bf819843dcf464f5','bfa506cc517a4cf1bb6dc4bca76155a6','gigabytes',0,0,NULL,NULL),('2025-11-29 05:43:28.094416','2025-11-29 05:44:18.034129',NULL,0,263,'6f7f9251bec644a5bf819843dcf464f5','bfa506cc517a4cf1bb6dc4bca76155a6','shares',0,0,NULL,NULL),('2025-11-29 05:43:28.101678','2025-11-29 05:44:18.034131','2025-11-29 05:44:21.207438',264,264,NULL,'bfa506cc517a4cf1bb6dc4bca76155a6','gigabytes',0,0,NULL,'1c8161b4-ab6a-46c9-8c73-44780c20ec7e'),('2025-11-29 05:43:28.103486','2025-11-29 05:44:18.034132','2025-11-29 05:44:21.207438',265,265,NULL,'bfa506cc517a4cf1bb6dc4bca76155a6','shares',0,0,NULL,'1c8161b4-ab6a-46c9-8c73-44780c20ec7e'),('2025-11-29 05:43:31.498440','2025-11-29 05:44:15.002057',NULL,0,266,'6f7f9251bec644a5bf819843dcf464f5','bfa506cc517a4cf1bb6dc4bca76155a6','snapshots',0,0,NULL,NULL),('2025-11-29 05:43:31.501226','2025-11-29 05:44:15.002061',NULL,0,267,'6f7f9251bec644a5bf819843dcf464f5','bfa506cc517a4cf1bb6dc4bca76155a6','snapshot_gigabytes',0,0,NULL,NULL),('2025-11-29 05:43:31.629152','2025-11-29 05:44:15.002063','2025-11-29 05:44:21.207438',268,268,NULL,'bfa506cc517a4cf1bb6dc4bca76155a6','snapshots',0,0,NULL,'1c8161b4-ab6a-46c9-8c73-44780c20ec7e'),('2025-11-29 05:43:31.635011','2025-11-29 05:44:15.002065','2025-11-29 05:44:21.207438',269,269,NULL,'bfa506cc517a4cf1bb6dc4bca76155a6','snapshot_gigabytes',0,0,NULL,'1c8161b4-ab6a-46c9-8c73-44780c20ec7e');
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
INSERT INTO `quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `project_id`, `resource`, `hard_limit`) VALUES (1,'2025-11-29 05:35:07.886209',NULL,'2025-11-29 05:35:25.287775',1,'b4f2479ae0d643afbae53bb92525282e','shares',3),(2,'2025-11-29 05:35:08.041590',NULL,'2025-11-29 05:35:25.287775',2,'b4f2479ae0d643afbae53bb92525282e','gigabytes',10),(3,'2025-11-29 05:35:25.541618',NULL,'2025-11-29 05:35:26.232961',3,'b4f2479ae0d643afbae53bb92525282e','shares',55),(4,'2025-11-29 05:35:25.545847',NULL,'2025-11-29 05:35:26.232961',4,'b4f2479ae0d643afbae53bb92525282e','snapshots',55),(5,'2025-11-29 05:35:25.549304',NULL,'2025-11-29 05:35:26.232961',5,'b4f2479ae0d643afbae53bb92525282e','gigabytes',1005),(6,'2025-11-29 05:35:25.552442',NULL,'2025-11-29 05:35:26.232961',6,'b4f2479ae0d643afbae53bb92525282e','snapshot_gigabytes',1005),(7,'2025-11-29 05:35:25.555374',NULL,'2025-11-29 05:35:26.232961',7,'b4f2479ae0d643afbae53bb92525282e','share_replicas',105),(8,'2025-11-29 05:35:25.559783',NULL,'2025-11-29 05:35:26.232961',8,'b4f2479ae0d643afbae53bb92525282e','replica_gigabytes',1005),(9,'2025-11-29 05:35:26.609124',NULL,'2025-11-29 05:35:27.245175',9,'b4f2479ae0d643afbae53bb92525282e','shares',55),(10,'2025-11-29 05:35:26.616171',NULL,'2025-11-29 05:35:27.245175',10,'b4f2479ae0d643afbae53bb92525282e','snapshots',55),(11,'2025-11-29 05:35:26.630868',NULL,'2025-11-29 05:35:27.245175',11,'b4f2479ae0d643afbae53bb92525282e','gigabytes',1005),(12,'2025-11-29 05:35:26.637699',NULL,'2025-11-29 05:35:27.245175',12,'b4f2479ae0d643afbae53bb92525282e','snapshot_gigabytes',1005),(13,'2025-11-29 05:35:26.642114',NULL,'2025-11-29 05:35:27.245175',13,'b4f2479ae0d643afbae53bb92525282e','share_replicas',105),(14,'2025-11-29 05:35:26.648839',NULL,'2025-11-29 05:35:27.245175',14,'b4f2479ae0d643afbae53bb92525282e','replica_gigabytes',1005),(15,'2025-11-29 05:35:27.533174',NULL,'2025-11-29 05:35:27.659281',15,'b4f2479ae0d643afbae53bb92525282e','shares',52),(16,'2025-11-29 05:35:27.539996',NULL,'2025-11-29 05:35:27.659281',16,'b4f2479ae0d643afbae53bb92525282e','snapshots',52),(17,'2025-11-29 05:35:27.545146',NULL,'2025-11-29 05:35:27.659281',17,'b4f2479ae0d643afbae53bb92525282e','gigabytes',1002),(18,'2025-11-29 05:35:27.551437',NULL,'2025-11-29 05:35:27.659281',18,'b4f2479ae0d643afbae53bb92525282e','snapshot_gigabytes',1002),(19,'2025-11-29 05:35:27.557296',NULL,'2025-11-29 05:35:27.659281',19,'b4f2479ae0d643afbae53bb92525282e','share_networks',12),(20,'2025-11-29 05:35:27.576312',NULL,'2025-11-29 05:35:27.659281',20,'b4f2479ae0d643afbae53bb92525282e','share_replicas',102),(21,'2025-11-29 05:35:27.586427',NULL,'2025-11-29 05:35:27.659281',21,'b4f2479ae0d643afbae53bb92525282e','replica_gigabytes',1002),(22,'2025-11-29 05:35:27.987882',NULL,'2025-11-29 05:35:28.341937',22,'b4f2479ae0d643afbae53bb92525282e','shares',13),(23,'2025-11-29 05:35:28.522237',NULL,'2025-11-29 05:35:28.710475',23,'b4f2479ae0d643afbae53bb92525282e','gigabytes',-1),(24,'2025-11-29 05:35:28.825842',NULL,'2025-11-29 05:35:29.022422',24,'b4f2479ae0d643afbae53bb92525282e','share_replicas',-1),(25,'2025-11-29 05:35:29.152159',NULL,'2025-11-29 05:35:29.413456',25,'b4f2479ae0d643afbae53bb92525282e','replica_gigabytes',-1),(26,'2025-11-29 05:35:29.591934',NULL,'2025-11-29 05:35:29.761178',26,'b4f2479ae0d643afbae53bb92525282e','share_networks',-1),(27,'2025-11-29 05:35:29.935991',NULL,'2025-11-29 05:35:30.078932',27,'b4f2479ae0d643afbae53bb92525282e','shares',-1),(28,'2025-11-29 05:35:30.167428',NULL,'2025-11-29 05:35:30.289208',28,'b4f2479ae0d643afbae53bb92525282e','snapshot_gigabytes',-1),(29,'2025-11-29 05:35:30.370628',NULL,'2025-11-29 05:35:30.610524',29,'b4f2479ae0d643afbae53bb92525282e','snapshots',-1),(30,'2025-11-29 05:35:35.677398',NULL,'2025-11-29 05:35:35.830003',30,'b4f2479ae0d643afbae53bb92525282e','shares',10),(31,'2025-11-29 05:35:36.021463',NULL,'2025-11-29 05:35:36.231726',31,'b4f2479ae0d643afbae53bb92525282e','shares',10),(32,'2025-11-29 05:35:36.455688',NULL,'2025-11-29 05:35:36.536044',32,'b4f2479ae0d643afbae53bb92525282e','gigabytes',1002),(33,'2025-11-29 05:35:36.769661',NULL,'2025-11-29 05:35:36.934090',33,'b4f2479ae0d643afbae53bb92525282e','share_networks',12),(34,'2025-11-29 05:35:37.159852',NULL,'2025-11-29 05:35:37.444399',34,'b4f2479ae0d643afbae53bb92525282e','shares',52),(35,'2025-11-29 05:35:37.604197',NULL,'2025-11-29 05:35:37.680078',35,'b4f2479ae0d643afbae53bb92525282e','snapshot_gigabytes',1002),(36,'2025-11-29 05:35:38.008370',NULL,'2025-11-29 05:35:38.099664',36,'b4f2479ae0d643afbae53bb92525282e','snapshots',52),(37,'2025-11-29 05:35:38.608255',NULL,'2025-11-29 05:35:38.680314',37,'b4f2479ae0d643afbae53bb92525282e','share_replicas',99),(38,'2025-11-29 05:35:39.345623',NULL,'2025-11-29 05:35:39.431594',38,'b4f2479ae0d643afbae53bb92525282e','replica_gigabytes',999),(39,'2025-11-29 05:35:41.241114',NULL,'2025-11-29 05:35:41.672915',39,'b4f2479ae0d643afbae53bb92525282e','shares',10),(40,'2025-11-29 05:35:41.773902',NULL,'2025-11-29 05:35:42.130514',40,'b4f2479ae0d643afbae53bb92525282e','shares',10),(41,'2025-11-29 05:36:27.012206',NULL,'2025-11-29 05:36:27.199345',41,'c48d0a2145674172882133c87bb61929','shares',1),(42,'2025-11-29 05:36:31.312207',NULL,'2025-11-29 05:36:35.381775',42,'c48d0a2145674172882133c87bb61929','snapshots',1),(43,'2025-11-29 05:36:43.548159',NULL,'2025-11-29 05:36:44.001949',43,'c48d0a2145674172882133c87bb61929','shares',10),(44,'2025-11-29 05:36:44.242456',NULL,'2025-11-29 05:36:44.556579',44,'c48d0a2145674172882133c87bb61929','shares',10);
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) NOT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `usage_id` (`usage_id`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=976 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
INSERT INTO `reservations` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `uuid`, `usage_id`, `project_id`, `resource`, `delta`, `expire`, `share_type_id`) VALUES ('2025-11-29 05:34:23.139936',NULL,'2025-11-29 05:34:23.284061',1,1,'4544ba66fc044b5a8d3aa9deb5249384','c6956db8-f2ed-4cd9-bde3-015efca8b938',1,'3e18b41001c440e0a7d05f7f98059230','shares',1,'2025-11-30 05:34:23',NULL),('2025-11-29 05:34:23.142578',NULL,'2025-11-29 05:34:23.284061',2,2,'4544ba66fc044b5a8d3aa9deb5249384','3afdcfbd-1362-445e-b4da-24a4fc1cc387',2,'3e18b41001c440e0a7d05f7f98059230','gigabytes',1,'2025-11-30 05:34:23',NULL),('2025-11-29 05:34:23.157326',NULL,'2025-11-29 05:34:23.284061',3,3,NULL,'985c146a-4559-4dc3-a160-90956545d533',3,'3e18b41001c440e0a7d05f7f98059230','shares',1,'2025-11-30 05:34:23','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:34:23.158435',NULL,'2025-11-29 05:34:23.284061',4,4,NULL,'6a9833e7-bdb0-40ed-9101-cec3f0db4d35',4,'3e18b41001c440e0a7d05f7f98059230','gigabytes',1,'2025-11-30 05:34:23','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:34:24.789298',NULL,'2025-11-29 05:34:24.912044',5,5,'6bebd43b2c7c48209f1030ff92d31dc2','897e31ec-9e3d-40c4-8911-70b00c8e691c',5,'35fca249d2fe4b499e58ae322257ed19','shares',1,'2025-11-30 05:34:24',NULL),('2025-11-29 05:34:24.791291',NULL,'2025-11-29 05:34:24.912044',6,6,'6bebd43b2c7c48209f1030ff92d31dc2','418b5183-bddd-4287-b7f5-65b8b9de2bd0',6,'35fca249d2fe4b499e58ae322257ed19','gigabytes',1,'2025-11-30 05:34:24',NULL),('2025-11-29 05:34:24.865390',NULL,'2025-11-29 05:34:24.912044',7,7,NULL,'61bf6228-abea-4995-aa9d-3184fe220407',7,'35fca249d2fe4b499e58ae322257ed19','shares',1,'2025-11-30 05:34:24','235d3753-6144-4b29-b569-50b44a6b7188'),('2025-11-29 05:34:24.867670',NULL,'2025-11-29 05:34:24.912044',8,8,NULL,'04e19f75-644e-4c78-bf03-8d2294a0ae84',8,'35fca249d2fe4b499e58ae322257ed19','gigabytes',1,'2025-11-30 05:34:24','235d3753-6144-4b29-b569-50b44a6b7188'),('2025-11-29 05:34:27.178446',NULL,'2025-11-29 05:34:27.232926',9,9,'4544ba66fc044b5a8d3aa9deb5249384','678517f2-ca8a-42e5-9a2d-240889ab62ea',1,'3e18b41001c440e0a7d05f7f98059230','shares',1,'2025-11-30 05:34:27',NULL),('2025-11-29 05:34:27.182347',NULL,'2025-11-29 05:34:27.232926',10,10,'4544ba66fc044b5a8d3aa9deb5249384','11de27a0-e296-4e76-86f4-90d2b991a2c6',2,'3e18b41001c440e0a7d05f7f98059230','gigabytes',1,'2025-11-30 05:34:27',NULL),('2025-11-29 05:34:27.195146',NULL,'2025-11-29 05:34:27.232926',11,11,NULL,'40350105-2a02-48f4-899e-e630909714c5',3,'3e18b41001c440e0a7d05f7f98059230','shares',1,'2025-11-30 05:34:27','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:34:27.196544',NULL,'2025-11-29 05:34:27.232926',12,12,NULL,'7a2af2cb-ee7d-4a5a-961c-c84c04ef9da3',4,'3e18b41001c440e0a7d05f7f98059230','gigabytes',1,'2025-11-30 05:34:27','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:34:30.781225',NULL,'2025-11-29 05:34:30.957568',13,13,'4544ba66fc044b5a8d3aa9deb5249384','eb7d947c-1664-4c85-9b15-2f7a5adff934',2,'3e18b41001c440e0a7d05f7f98059230','gigabytes',1,'2025-11-30 05:34:30',NULL),('2025-11-29 05:34:30.789321',NULL,'2025-11-29 05:34:30.957568',14,14,NULL,'73607978-e8d3-49dd-85d2-c875fc858a62',4,'3e18b41001c440e0a7d05f7f98059230','gigabytes',1,'2025-11-30 05:34:30','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:34:31.860597',NULL,'2025-11-29 05:34:31.892488',15,15,'6bebd43b2c7c48209f1030ff92d31dc2','2f5ea57a-fd49-4d0c-a682-78a5c4907d72',5,'35fca249d2fe4b499e58ae322257ed19','shares',-1,'2025-11-30 05:34:31',NULL),('2025-11-29 05:34:31.861869',NULL,'2025-11-29 05:34:31.892488',16,16,'6bebd43b2c7c48209f1030ff92d31dc2','4bba6a4d-e0ab-406f-9192-cc09969833a0',6,'35fca249d2fe4b499e58ae322257ed19','gigabytes',-1,'2025-11-30 05:34:31',NULL),('2025-11-29 05:34:31.878563',NULL,'2025-11-29 05:34:31.892488',17,17,NULL,'197f3d39-021c-47c1-8308-99c9a60a96ad',7,'35fca249d2fe4b499e58ae322257ed19','shares',-1,'2025-11-30 05:34:31','235d3753-6144-4b29-b569-50b44a6b7188'),('2025-11-29 05:34:31.879595',NULL,'2025-11-29 05:34:31.892488',18,18,NULL,'9016da57-3c6b-463f-8d6d-24c88f068c54',8,'35fca249d2fe4b499e58ae322257ed19','gigabytes',-1,'2025-11-30 05:34:31','235d3753-6144-4b29-b569-50b44a6b7188'),('2025-11-29 05:34:32.017136',NULL,'2025-11-29 05:34:32.033863',19,19,'4544ba66fc044b5a8d3aa9deb5249384','7a37caa2-991a-4ce4-924c-2bb7d8af10d7',1,'3e18b41001c440e0a7d05f7f98059230','shares',-1,'2025-11-30 05:34:31',NULL),('2025-11-29 05:34:32.018295',NULL,'2025-11-29 05:34:32.033863',20,20,'4544ba66fc044b5a8d3aa9deb5249384','3cef7600-316f-4e08-82aa-de924c08215f',2,'3e18b41001c440e0a7d05f7f98059230','gigabytes',-2,'2025-11-30 05:34:31',NULL),('2025-11-29 05:34:32.023677',NULL,'2025-11-29 05:34:32.033863',21,21,NULL,'dc53036c-4c81-4a70-baf9-38989d1a3b5f',3,'3e18b41001c440e0a7d05f7f98059230','shares',-1,'2025-11-30 05:34:31','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:34:32.024424',NULL,'2025-11-29 05:34:32.033863',22,22,NULL,'2a3329fd-f845-489e-94fd-78dd67345a5f',4,'3e18b41001c440e0a7d05f7f98059230','gigabytes',-2,'2025-11-30 05:34:31','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:34:35.311866',NULL,'2025-11-29 05:34:35.356128',23,23,'4544ba66fc044b5a8d3aa9deb5249384','598f8255-7e10-4cdb-89e2-2362da1a7fe7',1,'3e18b41001c440e0a7d05f7f98059230','shares',1,'2025-11-30 05:34:35',NULL),('2025-11-29 05:34:35.313869',NULL,'2025-11-29 05:34:35.356128',24,24,'4544ba66fc044b5a8d3aa9deb5249384','84424815-9a4c-476c-93a1-696333944ce0',2,'3e18b41001c440e0a7d05f7f98059230','gigabytes',1,'2025-11-30 05:34:35',NULL),('2025-11-29 05:34:35.326755',NULL,'2025-11-29 05:34:35.356128',25,25,NULL,'6c41f7cd-e4fd-411b-a922-76046ffc5b61',3,'3e18b41001c440e0a7d05f7f98059230','shares',1,'2025-11-30 05:34:35','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:34:35.328243',NULL,'2025-11-29 05:34:35.356128',26,26,NULL,'b0b141d9-a268-4225-8724-aa18cabf4e85',4,'3e18b41001c440e0a7d05f7f98059230','gigabytes',1,'2025-11-30 05:34:35','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:34:36.012387',NULL,'2025-11-29 05:34:36.240546',27,27,'4544ba66fc044b5a8d3aa9deb5249384','d418bb62-0486-4ed0-8d0f-45a5c015523a',2,'3e18b41001c440e0a7d05f7f98059230','gigabytes',1,'2025-11-30 05:34:35',NULL),('2025-11-29 05:34:36.021699',NULL,'2025-11-29 05:34:36.240546',28,28,NULL,'0272b99f-473e-42e0-a2f9-e1455659f7a9',4,'3e18b41001c440e0a7d05f7f98059230','gigabytes',1,'2025-11-30 05:34:35','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:34:36.203647',NULL,'2025-11-29 05:34:36.250634',29,29,'cb1b305ee4f94aa68f250be4f43ef913','6eb44802-924b-44c4-ba75-0cf2cbf1fc8c',10,'049c3d38228f4e3e9c392f5f88dbc238','shares',1,'2025-11-30 05:34:36',NULL),('2025-11-29 05:34:36.208231',NULL,'2025-11-29 05:34:36.250634',30,30,'cb1b305ee4f94aa68f250be4f43ef913','af057d8f-a929-43de-a4fa-74f6515a6b9c',9,'049c3d38228f4e3e9c392f5f88dbc238','gigabytes',1,'2025-11-30 05:34:36',NULL),('2025-11-29 05:34:36.224369',NULL,'2025-11-29 05:34:36.250634',31,31,NULL,'91ac8c28-83e8-4335-8c4a-4fcdbb03ac2e',12,'049c3d38228f4e3e9c392f5f88dbc238','shares',1,'2025-11-30 05:34:36','7e5bc69e-c8de-413a-a484-248ded56b5e3'),('2025-11-29 05:34:36.225496',NULL,'2025-11-29 05:34:36.250634',32,32,NULL,'706f876c-f626-4311-baee-5d1cd64ef21f',11,'049c3d38228f4e3e9c392f5f88dbc238','gigabytes',1,'2025-11-30 05:34:36','7e5bc69e-c8de-413a-a484-248ded56b5e3'),('2025-11-29 05:34:40.143083',NULL,'2025-11-29 05:34:40.158269',33,33,'4544ba66fc044b5a8d3aa9deb5249384','a757ae1b-1a75-4ab3-8b13-f1d02e57a03d',1,'3e18b41001c440e0a7d05f7f98059230','shares',-1,'2025-11-30 05:34:40',NULL),('2025-11-29 05:34:40.143960',NULL,'2025-11-29 05:34:40.158269',34,34,'4544ba66fc044b5a8d3aa9deb5249384','5707956b-b326-4c97-a123-5510bf1f189d',2,'3e18b41001c440e0a7d05f7f98059230','gigabytes',-2,'2025-11-30 05:34:40',NULL),('2025-11-29 05:34:40.149894',NULL,'2025-11-29 05:34:40.158269',35,35,NULL,'bd848f06-a36c-4833-bf9d-3781654a3a55',3,'3e18b41001c440e0a7d05f7f98059230','shares',-1,'2025-11-30 05:34:40','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:34:40.150645',NULL,'2025-11-29 05:34:40.158269',36,36,NULL,'41e03f99-e3cc-4e54-8bed-c621eca304fe',4,'3e18b41001c440e0a7d05f7f98059230','gigabytes',-2,'2025-11-30 05:34:40','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:34:43.429011',NULL,'2025-11-29 05:34:43.461157',37,37,'4544ba66fc044b5a8d3aa9deb5249384','97f54c86-17e6-443f-b866-c8ab450da9c2',1,'3e18b41001c440e0a7d05f7f98059230','shares',1,'2025-11-30 05:34:43',NULL),('2025-11-29 05:34:43.430366',NULL,'2025-11-29 05:34:43.461157',38,38,'4544ba66fc044b5a8d3aa9deb5249384','eb194d95-0980-4425-9422-aa1f6dc45280',2,'3e18b41001c440e0a7d05f7f98059230','gigabytes',1,'2025-11-30 05:34:43',NULL),('2025-11-29 05:34:43.436204',NULL,'2025-11-29 05:34:43.461157',39,39,NULL,'0dbc94f7-6a75-4be4-9d8d-73ce8f039d81',3,'3e18b41001c440e0a7d05f7f98059230','shares',1,'2025-11-30 05:34:43','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:34:43.437939',NULL,'2025-11-29 05:34:43.461157',40,40,NULL,'100ecd66-5d22-4d17-b28e-dc3d824ce256',4,'3e18b41001c440e0a7d05f7f98059230','gigabytes',1,'2025-11-30 05:34:43','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:34:44.354853',NULL,'2025-11-29 05:34:44.372890',41,41,'cb1b305ee4f94aa68f250be4f43ef913','722e67de-3cd2-4c4f-8a85-1694393c71e1',10,'049c3d38228f4e3e9c392f5f88dbc238','shares',-1,'2025-11-30 05:34:44',NULL),('2025-11-29 05:34:44.355744',NULL,'2025-11-29 05:34:44.372890',42,42,'cb1b305ee4f94aa68f250be4f43ef913','2f20ac9c-8d6a-420f-ae5f-71fe9e594d93',9,'049c3d38228f4e3e9c392f5f88dbc238','gigabytes',-1,'2025-11-30 05:34:44',NULL),('2025-11-29 05:34:44.363444',NULL,'2025-11-29 05:34:44.372890',43,43,NULL,'4114faa5-510e-4268-a9ce-52e1c6fa2443',12,'049c3d38228f4e3e9c392f5f88dbc238','shares',-1,'2025-11-30 05:34:44','7e5bc69e-c8de-413a-a484-248ded56b5e3'),('2025-11-29 05:34:44.364724',NULL,'2025-11-29 05:34:44.372890',44,44,NULL,'8b3e6834-b45e-4efa-803e-f4ad490fbc71',11,'049c3d38228f4e3e9c392f5f88dbc238','gigabytes',-1,'2025-11-30 05:34:44','7e5bc69e-c8de-413a-a484-248ded56b5e3'),('2025-11-29 05:34:44.684404',NULL,'2025-11-29 05:34:44.703719',45,45,'4544ba66fc044b5a8d3aa9deb5249384','09b9a0e2-793e-492a-8f1d-854e5b04b644',1,'3e18b41001c440e0a7d05f7f98059230','shares',-1,'2025-11-30 05:34:44',NULL),('2025-11-29 05:34:44.685325',NULL,'2025-11-29 05:34:44.703719',46,46,'4544ba66fc044b5a8d3aa9deb5249384','616a46de-127f-4035-aa3e-fd7043761452',2,'3e18b41001c440e0a7d05f7f98059230','gigabytes',-1,'2025-11-30 05:34:44',NULL),('2025-11-29 05:34:44.693845',NULL,'2025-11-29 05:34:44.703719',47,47,NULL,'86bc0f0c-3c4d-4a69-b5dd-6d8806f0bac4',3,'3e18b41001c440e0a7d05f7f98059230','shares',-1,'2025-11-30 05:34:44','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:34:44.694550',NULL,'2025-11-29 05:34:44.703719',48,48,NULL,'0c0e584f-67db-4c24-853e-8222fb3d9ac2',4,'3e18b41001c440e0a7d05f7f98059230','gigabytes',-1,'2025-11-30 05:34:44','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:34:47.894162',NULL,'2025-11-29 05:34:48.810160',49,49,'4544ba66fc044b5a8d3aa9deb5249384','309c5351-7f4b-4212-8b86-815d7fd5afc0',1,'3e18b41001c440e0a7d05f7f98059230','shares',1,'2025-11-30 05:34:47',NULL),('2025-11-29 05:34:47.895964',NULL,'2025-11-29 05:34:48.810160',50,50,'4544ba66fc044b5a8d3aa9deb5249384','f2999a0c-6e7b-461d-add5-b4be4c74e6d6',2,'3e18b41001c440e0a7d05f7f98059230','gigabytes',1,'2025-11-30 05:34:47',NULL),('2025-11-29 05:34:48.069783',NULL,'2025-11-29 05:34:48.810160',51,51,NULL,'7ad67337-5e2f-49a9-857a-15aad7dd0f5c',3,'3e18b41001c440e0a7d05f7f98059230','shares',1,'2025-11-30 05:34:47','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:34:48.072316',NULL,'2025-11-29 05:34:48.810160',52,52,NULL,'d5647161-54a4-40f0-b0ff-4e4cdc535028',4,'3e18b41001c440e0a7d05f7f98059230','gigabytes',1,'2025-11-30 05:34:47','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:34:50.404175',NULL,'2025-11-29 05:34:50.423929',53,53,'4544ba66fc044b5a8d3aa9deb5249384','0f84ed32-1b8f-442a-a688-1db0f725cdcf',1,'3e18b41001c440e0a7d05f7f98059230','shares',-1,'2025-11-30 05:34:50',NULL),('2025-11-29 05:34:50.405051',NULL,'2025-11-29 05:34:50.423929',54,54,'4544ba66fc044b5a8d3aa9deb5249384','9df0c299-003d-4f04-8f69-57799ba25f22',2,'3e18b41001c440e0a7d05f7f98059230','gigabytes',-1,'2025-11-30 05:34:50',NULL),('2025-11-29 05:34:50.411169',NULL,'2025-11-29 05:34:50.423929',55,55,NULL,'97465e92-db25-4bf3-a3d7-20a8e1fd5a81',3,'3e18b41001c440e0a7d05f7f98059230','shares',-1,'2025-11-30 05:34:50','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:34:50.412853',NULL,'2025-11-29 05:34:50.423929',56,56,NULL,'0be4abae-ef8e-424a-89fd-f5e3eed727d5',4,'3e18b41001c440e0a7d05f7f98059230','gigabytes',-1,'2025-11-30 05:34:50','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:34:54.371106',NULL,'2025-11-29 05:34:54.621550',57,57,'4544ba66fc044b5a8d3aa9deb5249384','cf758328-eab0-4ad6-a27f-5269ad9f2781',13,'3e18b41001c440e0a7d05f7f98059230','snapshots',1,'2025-11-30 05:34:54',NULL),('2025-11-29 05:34:54.372438',NULL,'2025-11-29 05:34:54.621550',58,58,'4544ba66fc044b5a8d3aa9deb5249384','fa9a2669-1fa9-473d-954a-f5be60d2c030',14,'3e18b41001c440e0a7d05f7f98059230','snapshot_gigabytes',1,'2025-11-30 05:34:54',NULL),('2025-11-29 05:34:54.395885',NULL,'2025-11-29 05:34:54.621550',59,59,NULL,'94541e05-aee1-4114-9787-7a7845c76818',15,'3e18b41001c440e0a7d05f7f98059230','snapshots',1,'2025-11-30 05:34:54','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:34:54.397309',NULL,'2025-11-29 05:34:54.621550',60,60,NULL,'9c60a014-7dbe-4d61-a0e7-183469237c62',16,'3e18b41001c440e0a7d05f7f98059230','snapshot_gigabytes',1,'2025-11-30 05:34:54','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:34:56.157760',NULL,'2025-11-29 05:34:56.188182',61,61,'4544ba66fc044b5a8d3aa9deb5249384','426b336d-f808-4330-b234-0fc9605e74cf',13,'3e18b41001c440e0a7d05f7f98059230','snapshots',-1,'2025-11-30 05:34:56',NULL),('2025-11-29 05:34:56.159186',NULL,'2025-11-29 05:34:56.188182',62,62,'4544ba66fc044b5a8d3aa9deb5249384','73cba7cc-cc7d-4263-9107-af7f05a17d76',14,'3e18b41001c440e0a7d05f7f98059230','snapshot_gigabytes',-1,'2025-11-30 05:34:56',NULL),('2025-11-29 05:34:56.165415',NULL,'2025-11-29 05:34:56.188182',63,63,NULL,'4ce8dda2-09bd-4e3a-807c-d90efef9bf8e',15,'3e18b41001c440e0a7d05f7f98059230','snapshots',-1,'2025-11-30 05:34:56','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:34:56.171400',NULL,'2025-11-29 05:34:56.188182',64,64,NULL,'2c4fcf55-3060-4b92-8bd0-12240d64127e',16,'3e18b41001c440e0a7d05f7f98059230','snapshot_gigabytes',-1,'2025-11-30 05:34:56','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:35:07.233736',NULL,'2025-11-29 05:35:07.288379',65,65,'417cb9ae9b2a43429cd5d1781ad57fd9','1e4ad8af-31e7-4287-b8b3-e00f1542e865',18,'c272c8175ff843ca8dc572501529b10b','shares',1,'2025-11-30 05:35:07',NULL),('2025-11-29 05:35:07.234896',NULL,'2025-11-29 05:35:07.288379',66,66,'417cb9ae9b2a43429cd5d1781ad57fd9','ef8b0474-d54f-435b-84a2-2b8d9c549de5',17,'c272c8175ff843ca8dc572501529b10b','gigabytes',1,'2025-11-30 05:35:07',NULL),('2025-11-29 05:35:07.253957',NULL,'2025-11-29 05:35:07.288379',67,67,NULL,'a210ba97-1555-4de7-a6a0-cf9c79b3f033',20,'c272c8175ff843ca8dc572501529b10b','shares',1,'2025-11-30 05:35:07','897b7777-bc91-41a3-a0ae-0cc41ffc72f9'),('2025-11-29 05:35:07.255203',NULL,'2025-11-29 05:35:07.288379',68,68,NULL,'4a37d4af-0207-4733-a864-d40adb19efee',19,'c272c8175ff843ca8dc572501529b10b','gigabytes',1,'2025-11-30 05:35:07','897b7777-bc91-41a3-a0ae-0cc41ffc72f9'),('2025-11-29 05:35:08.747328',NULL,'2025-11-29 05:35:08.781335',69,69,'23469d4601454621a798588dbcc97218','e9071ed5-4dfd-4111-918d-52bbdcf39173',21,'b4f2479ae0d643afbae53bb92525282e','shares',1,'2025-11-30 05:35:08',NULL),('2025-11-29 05:35:08.748471',NULL,'2025-11-29 05:35:08.781335',70,70,'23469d4601454621a798588dbcc97218','18e59ac7-c468-4bc3-b886-d8bb9c6711b9',22,'b4f2479ae0d643afbae53bb92525282e','gigabytes',4,'2025-11-30 05:35:08',NULL),('2025-11-29 05:35:08.758266',NULL,'2025-11-29 05:35:08.781335',71,71,NULL,'7cd97fc1-7476-4926-8a82-bf4fc2e21281',23,'b4f2479ae0d643afbae53bb92525282e','shares',1,'2025-11-30 05:35:08','078baedb-e7c7-47ca-9eae-f6d4445bee40'),('2025-11-29 05:35:08.759525',NULL,'2025-11-29 05:35:08.781335',72,72,NULL,'6c728123-f8cd-4124-8c2d-f297c86d802f',24,'b4f2479ae0d643afbae53bb92525282e','gigabytes',4,'2025-11-30 05:35:08','078baedb-e7c7-47ca-9eae-f6d4445bee40'),('2025-11-29 05:35:11.585278',NULL,'2025-11-29 05:35:11.747089',73,73,'417cb9ae9b2a43429cd5d1781ad57fd9','c088a140-2f62-46a4-8a63-38b05217a9bc',25,'c272c8175ff843ca8dc572501529b10b','snapshots',1,'2025-11-30 05:35:11',NULL),('2025-11-29 05:35:11.590807',NULL,'2025-11-29 05:35:11.747089',74,74,'417cb9ae9b2a43429cd5d1781ad57fd9','0938534d-1747-4ec7-8350-e98dbab9a18c',26,'c272c8175ff843ca8dc572501529b10b','snapshot_gigabytes',1,'2025-11-30 05:35:11',NULL),('2025-11-29 05:35:11.626718',NULL,'2025-11-29 05:35:11.747089',75,75,NULL,'5014105c-5ca5-4f93-becd-4fcb170c0029',27,'c272c8175ff843ca8dc572501529b10b','snapshots',1,'2025-11-30 05:35:11','897b7777-bc91-41a3-a0ae-0cc41ffc72f9'),('2025-11-29 05:35:11.629287',NULL,'2025-11-29 05:35:11.747089',76,76,NULL,'770b78bc-8b17-4489-97ad-a1b4d175cbc4',28,'c272c8175ff843ca8dc572501529b10b','snapshot_gigabytes',1,'2025-11-30 05:35:11','897b7777-bc91-41a3-a0ae-0cc41ffc72f9'),('2025-11-29 05:35:11.672630',NULL,'2025-11-29 05:35:11.754897',77,77,'4544ba66fc044b5a8d3aa9deb5249384','99514f5e-4c0f-4af7-9f76-814f54a90c7b',13,'3e18b41001c440e0a7d05f7f98059230','snapshots',1,'2025-11-30 05:35:11',NULL),('2025-11-29 05:35:11.673919',NULL,'2025-11-29 05:35:11.754897',78,78,'4544ba66fc044b5a8d3aa9deb5249384','9dba46bb-8a8e-4bc6-99c0-b925d52d72e4',14,'3e18b41001c440e0a7d05f7f98059230','snapshot_gigabytes',1,'2025-11-30 05:35:11',NULL),('2025-11-29 05:35:11.679954',NULL,'2025-11-29 05:35:11.754897',79,79,NULL,'df653321-8112-4f01-bbdd-b1760beeeb6a',15,'3e18b41001c440e0a7d05f7f98059230','snapshots',1,'2025-11-30 05:35:11','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:35:11.681246',NULL,'2025-11-29 05:35:11.754897',80,80,NULL,'45ccfbab-c1b6-4fb9-b6fb-9d2f246b649f',16,'3e18b41001c440e0a7d05f7f98059230','snapshot_gigabytes',1,'2025-11-30 05:35:11','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:35:13.171253',NULL,'2025-11-29 05:35:13.185143',81,81,'23469d4601454621a798588dbcc97218','410686ff-8749-4868-b184-804cbda15812',21,'b4f2479ae0d643afbae53bb92525282e','shares',1,'2025-11-30 05:35:13',NULL),('2025-11-29 05:35:13.173045',NULL,'2025-11-29 05:35:13.185143',82,82,'23469d4601454621a798588dbcc97218','005e3a5a-ca4b-42a1-ab5c-85eb3121a6bb',22,'b4f2479ae0d643afbae53bb92525282e','gigabytes',3,'2025-11-30 05:35:13',NULL),('2025-11-29 05:35:13.393854',NULL,'2025-11-29 05:35:13.428594',83,83,'23469d4601454621a798588dbcc97218','5cad0454-9b7e-4c96-b6e8-89bfea06b091',21,'b4f2479ae0d643afbae53bb92525282e','shares',1,'2025-11-30 05:35:13',NULL),('2025-11-29 05:35:13.395524',NULL,'2025-11-29 05:35:13.428594',84,84,'23469d4601454621a798588dbcc97218','949db787-a9d9-4cb6-abd4-177285236881',22,'b4f2479ae0d643afbae53bb92525282e','gigabytes',3,'2025-11-30 05:35:13',NULL),('2025-11-29 05:35:13.406029',NULL,'2025-11-29 05:35:13.428594',85,85,NULL,'930d040d-084a-4e8d-9c71-e7759acbbde3',30,'b4f2479ae0d643afbae53bb92525282e','shares',1,'2025-11-30 05:35:13','ddc6389e-dda9-47b0-85a7-6ad509ba0f38'),('2025-11-29 05:35:13.407518',NULL,'2025-11-29 05:35:13.428594',86,86,NULL,'bd84726b-d1da-41a2-85ac-873b4b208509',29,'b4f2479ae0d643afbae53bb92525282e','gigabytes',3,'2025-11-30 05:35:13','ddc6389e-dda9-47b0-85a7-6ad509ba0f38'),('2025-11-29 05:35:15.308727',NULL,'2025-11-29 05:35:15.353568',87,87,'417cb9ae9b2a43429cd5d1781ad57fd9','ffdef598-4172-4a76-b0b1-83f9c0c3081a',18,'c272c8175ff843ca8dc572501529b10b','shares',1,'2025-11-30 05:35:15',NULL),('2025-11-29 05:35:15.310147',NULL,'2025-11-29 05:35:15.353568',88,88,'417cb9ae9b2a43429cd5d1781ad57fd9','a329ea47-6bca-4f4a-b4e5-25c926d73987',17,'c272c8175ff843ca8dc572501529b10b','gigabytes',1,'2025-11-30 05:35:15',NULL),('2025-11-29 05:35:15.317136',NULL,'2025-11-29 05:35:15.353568',89,89,NULL,'93c1d9fe-f692-4b99-8890-45e844367d80',20,'c272c8175ff843ca8dc572501529b10b','shares',1,'2025-11-30 05:35:15','897b7777-bc91-41a3-a0ae-0cc41ffc72f9'),('2025-11-29 05:35:15.320737',NULL,'2025-11-29 05:35:15.353568',90,90,NULL,'b3b05f11-5f55-4065-916e-c2cbafcf3a86',19,'c272c8175ff843ca8dc572501529b10b','gigabytes',1,'2025-11-30 05:35:15','897b7777-bc91-41a3-a0ae-0cc41ffc72f9'),('2025-11-29 05:35:15.785128',NULL,'2025-11-29 05:35:15.922153',91,91,'4544ba66fc044b5a8d3aa9deb5249384','ce7eb60e-3d88-41a4-ae23-fa7fae7d5d5c',13,'3e18b41001c440e0a7d05f7f98059230','snapshots',1,'2025-11-30 05:35:15',NULL),('2025-11-29 05:35:15.789820',NULL,'2025-11-29 05:35:15.922153',92,92,'4544ba66fc044b5a8d3aa9deb5249384','1fa1bb28-ffee-4b41-ac60-553aedfa7944',14,'3e18b41001c440e0a7d05f7f98059230','snapshot_gigabytes',1,'2025-11-30 05:35:15',NULL),('2025-11-29 05:35:15.796316',NULL,'2025-11-29 05:35:15.922153',93,93,NULL,'ff58e2fe-013a-47ba-8159-6d7d1ac62262',15,'3e18b41001c440e0a7d05f7f98059230','snapshots',1,'2025-11-30 05:35:15','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:35:15.798858',NULL,'2025-11-29 05:35:15.922153',94,94,NULL,'86316a8c-2943-4028-8023-0697431b4ddc',16,'3e18b41001c440e0a7d05f7f98059230','snapshot_gigabytes',1,'2025-11-30 05:35:15','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:35:18.275769',NULL,'2025-11-29 05:35:18.308627',95,95,'23469d4601454621a798588dbcc97218','ee2001b8-4d79-4def-9942-279cfe1261a0',21,'b4f2479ae0d643afbae53bb92525282e','shares',-1,'2025-11-30 05:35:18',NULL),('2025-11-29 05:35:18.276650',NULL,'2025-11-29 05:35:18.308627',96,96,'23469d4601454621a798588dbcc97218','6dcc0914-ef5c-4627-a4d9-38083b82e5c3',22,'b4f2479ae0d643afbae53bb92525282e','gigabytes',-4,'2025-11-30 05:35:18',NULL),('2025-11-29 05:35:18.289254',NULL,'2025-11-29 05:35:18.308627',97,97,NULL,'24e33476-521f-4ad7-ac76-1462a733c979',23,'b4f2479ae0d643afbae53bb92525282e','shares',-1,'2025-11-30 05:35:18','078baedb-e7c7-47ca-9eae-f6d4445bee40'),('2025-11-29 05:35:18.290246',NULL,'2025-11-29 05:35:18.308627',98,98,NULL,'2a8406a8-335d-4867-932d-e0ce8803c9f3',24,'b4f2479ae0d643afbae53bb92525282e','gigabytes',-4,'2025-11-30 05:35:18','078baedb-e7c7-47ca-9eae-f6d4445bee40'),('2025-11-29 05:35:19.956433',NULL,'2025-11-29 05:35:20.042709',99,99,'4544ba66fc044b5a8d3aa9deb5249384','f9680e41-2846-4384-b810-d3054e1365a5',13,'3e18b41001c440e0a7d05f7f98059230','snapshots',1,'2025-11-30 05:35:19',NULL),('2025-11-29 05:35:19.957859',NULL,'2025-11-29 05:35:20.042709',100,100,'4544ba66fc044b5a8d3aa9deb5249384','4b426ddb-4439-4d04-9da7-66ba7d5d9204',14,'3e18b41001c440e0a7d05f7f98059230','snapshot_gigabytes',1,'2025-11-30 05:35:19',NULL),('2025-11-29 05:35:19.964491',NULL,'2025-11-29 05:35:20.042709',101,101,NULL,'aec34d7e-f673-4bf4-9b28-3b70e930fdcc',15,'3e18b41001c440e0a7d05f7f98059230','snapshots',1,'2025-11-30 05:35:19','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:35:19.965623',NULL,'2025-11-29 05:35:20.042709',102,102,NULL,'257fc3bb-4168-4660-b4e0-b2a9f17eb2ec',16,'3e18b41001c440e0a7d05f7f98059230','snapshot_gigabytes',1,'2025-11-30 05:35:19','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:35:23.165394',NULL,'2025-11-29 05:35:23.185829',103,103,'23469d4601454621a798588dbcc97218','c26c485f-807c-4794-8ca3-11f38d845976',21,'b4f2479ae0d643afbae53bb92525282e','shares',-1,'2025-11-30 05:35:23',NULL),('2025-11-29 05:35:23.166898',NULL,'2025-11-29 05:35:23.185829',104,104,'23469d4601454621a798588dbcc97218','edf00f43-7d04-49f6-b4d8-eae8377bd63c',22,'b4f2479ae0d643afbae53bb92525282e','gigabytes',-3,'2025-11-30 05:35:23',NULL),('2025-11-29 05:35:23.176139',NULL,'2025-11-29 05:35:23.185829',105,105,NULL,'12b307b6-3fa6-4633-b42e-ed2098f09e87',30,'b4f2479ae0d643afbae53bb92525282e','shares',-1,'2025-11-30 05:35:23','ddc6389e-dda9-47b0-85a7-6ad509ba0f38'),('2025-11-29 05:35:23.176949',NULL,'2025-11-29 05:35:23.185829',106,106,NULL,'672b4639-1ea1-44b9-9d00-217a4495f9e2',29,'b4f2479ae0d643afbae53bb92525282e','gigabytes',-3,'2025-11-30 05:35:23','ddc6389e-dda9-47b0-85a7-6ad509ba0f38'),('2025-11-29 05:35:24.132058',NULL,'2025-11-29 05:35:24.205865',107,107,'4544ba66fc044b5a8d3aa9deb5249384','da83446d-7a0f-4c1e-aa30-ee76f07faf7e',13,'3e18b41001c440e0a7d05f7f98059230','snapshots',1,'2025-11-30 05:35:24',NULL),('2025-11-29 05:35:24.133457',NULL,'2025-11-29 05:35:24.205865',108,108,'4544ba66fc044b5a8d3aa9deb5249384','ceb14bbb-74d9-4f64-9a19-d65e7371b1da',14,'3e18b41001c440e0a7d05f7f98059230','snapshot_gigabytes',1,'2025-11-30 05:35:24',NULL),('2025-11-29 05:35:24.142976',NULL,'2025-11-29 05:35:24.205865',109,109,NULL,'8eabbd5d-b575-42b7-b650-0c40137ff6a6',15,'3e18b41001c440e0a7d05f7f98059230','snapshots',1,'2025-11-30 05:35:24','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:35:24.144638',NULL,'2025-11-29 05:35:24.205865',110,110,NULL,'d137d5b1-91b9-405b-8f1b-0e014188ba14',16,'3e18b41001c440e0a7d05f7f98059230','snapshot_gigabytes',1,'2025-11-30 05:35:24','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:35:24.922886',NULL,'2025-11-29 05:35:25.041339',111,111,'4544ba66fc044b5a8d3aa9deb5249384','3aeed101-554f-4bff-80ea-54921fd984ca',13,'3e18b41001c440e0a7d05f7f98059230','snapshots',1,'2025-11-30 05:35:24',NULL),('2025-11-29 05:35:24.924088',NULL,'2025-11-29 05:35:25.041339',112,112,'4544ba66fc044b5a8d3aa9deb5249384','7eb405df-975c-419e-9694-dcc52d9cd48e',14,'3e18b41001c440e0a7d05f7f98059230','snapshot_gigabytes',1,'2025-11-30 05:35:24',NULL),('2025-11-29 05:35:24.929324',NULL,'2025-11-29 05:35:25.041339',113,113,NULL,'435932d3-e58c-4f75-ae74-443dbbe7765c',15,'3e18b41001c440e0a7d05f7f98059230','snapshots',1,'2025-11-30 05:35:24','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:35:24.930357',NULL,'2025-11-29 05:35:25.041339',114,114,NULL,'419d7d84-7a4a-4920-a87c-53b4e0a4aa4e',16,'3e18b41001c440e0a7d05f7f98059230','snapshot_gigabytes',1,'2025-11-30 05:35:24','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:35:26.329906',NULL,'2025-11-29 05:35:26.348115',115,115,'4544ba66fc044b5a8d3aa9deb5249384','9bc96935-749a-4ad6-b585-a0d0095a2585',13,'3e18b41001c440e0a7d05f7f98059230','snapshots',-1,'2025-11-30 05:35:26',NULL),('2025-11-29 05:35:26.330999',NULL,'2025-11-29 05:35:26.348115',116,116,'4544ba66fc044b5a8d3aa9deb5249384','452c15dd-a577-43da-abe7-7a0c9b795e69',14,'3e18b41001c440e0a7d05f7f98059230','snapshot_gigabytes',-1,'2025-11-30 05:35:26',NULL),('2025-11-29 05:35:26.337049',NULL,'2025-11-29 05:35:26.348115',117,117,NULL,'c4f9f1ca-76d2-456c-a0fc-14a7bd133822',15,'3e18b41001c440e0a7d05f7f98059230','snapshots',-1,'2025-11-30 05:35:26','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:35:26.337859',NULL,'2025-11-29 05:35:26.348115',118,118,NULL,'45a23d01-c6d6-4bff-8f42-a573b350f480',16,'3e18b41001c440e0a7d05f7f98059230','snapshot_gigabytes',-1,'2025-11-30 05:35:26','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:35:29.288874',NULL,'2025-11-29 05:35:29.302561',119,119,'417cb9ae9b2a43429cd5d1781ad57fd9','223a25bc-680c-4505-ada9-765ce72c9e7a',18,'c272c8175ff843ca8dc572501529b10b','shares',-1,'2025-11-30 05:35:29',NULL),('2025-11-29 05:35:29.289692',NULL,'2025-11-29 05:35:29.302561',120,120,'417cb9ae9b2a43429cd5d1781ad57fd9','0f5b5322-730e-413f-a784-7e72e5cdd8a8',17,'c272c8175ff843ca8dc572501529b10b','gigabytes',-1,'2025-11-30 05:35:29',NULL),('2025-11-29 05:35:29.294725',NULL,'2025-11-29 05:35:29.302561',121,121,NULL,'eb34310c-ff45-416d-bffb-90525337a3c6',20,'c272c8175ff843ca8dc572501529b10b','shares',-1,'2025-11-30 05:35:29','897b7777-bc91-41a3-a0ae-0cc41ffc72f9'),('2025-11-29 05:35:29.295495',NULL,'2025-11-29 05:35:29.302561',122,122,NULL,'0ccd4d43-b68b-482d-9d92-f7db6fcb55a5',19,'c272c8175ff843ca8dc572501529b10b','gigabytes',-1,'2025-11-30 05:35:29','897b7777-bc91-41a3-a0ae-0cc41ffc72f9'),('2025-11-29 05:35:30.020748',NULL,'2025-11-29 05:35:30.041212',123,123,'4544ba66fc044b5a8d3aa9deb5249384','4d33feb9-c3c0-4e73-b30e-06e9da96f626',13,'3e18b41001c440e0a7d05f7f98059230','snapshots',-1,'2025-11-30 05:35:29',NULL),('2025-11-29 05:35:30.021847',NULL,'2025-11-29 05:35:30.041212',124,124,'4544ba66fc044b5a8d3aa9deb5249384','c6c74122-aa67-4717-b8d8-ab6476bf151f',14,'3e18b41001c440e0a7d05f7f98059230','snapshot_gigabytes',-1,'2025-11-30 05:35:29',NULL),('2025-11-29 05:35:30.030013',NULL,'2025-11-29 05:35:30.041212',125,125,NULL,'24c55740-813f-4b51-91c1-491f6b0dee72',15,'3e18b41001c440e0a7d05f7f98059230','snapshots',-1,'2025-11-30 05:35:29','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:35:30.030928',NULL,'2025-11-29 05:35:30.041212',126,126,NULL,'67db6457-2877-4cb2-89db-550514bfe957',16,'3e18b41001c440e0a7d05f7f98059230','snapshot_gigabytes',-1,'2025-11-30 05:35:29','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:35:33.004023',NULL,'2025-11-29 05:35:33.030323',127,127,'417cb9ae9b2a43429cd5d1781ad57fd9','e3fe36cd-8ddb-442a-8038-80ee34aca54c',25,'c272c8175ff843ca8dc572501529b10b','snapshots',-1,'2025-11-30 05:35:32',NULL),('2025-11-29 05:35:33.005010',NULL,'2025-11-29 05:35:33.030323',128,128,'417cb9ae9b2a43429cd5d1781ad57fd9','b6f5c034-2a46-4ce5-84a3-c5bfeddc4290',26,'c272c8175ff843ca8dc572501529b10b','snapshot_gigabytes',-1,'2025-11-30 05:35:32',NULL),('2025-11-29 05:35:33.020881',NULL,'2025-11-29 05:35:33.030323',129,129,NULL,'f14e5604-6557-437a-b38e-72fd60136d64',27,'c272c8175ff843ca8dc572501529b10b','snapshots',-1,'2025-11-30 05:35:32','897b7777-bc91-41a3-a0ae-0cc41ffc72f9'),('2025-11-29 05:35:33.021975',NULL,'2025-11-29 05:35:33.030323',130,130,NULL,'77cb8f0b-5854-449c-99e5-9736966bf072',28,'c272c8175ff843ca8dc572501529b10b','snapshot_gigabytes',-1,'2025-11-30 05:35:32','897b7777-bc91-41a3-a0ae-0cc41ffc72f9'),('2025-11-29 05:35:33.613115',NULL,'2025-11-29 05:35:33.835877',131,131,'4544ba66fc044b5a8d3aa9deb5249384','ef817f30-d4aa-459e-8cf7-fe3dbaffe9aa',13,'3e18b41001c440e0a7d05f7f98059230','snapshots',-1,'2025-11-30 05:35:33',NULL),('2025-11-29 05:35:33.613943',NULL,'2025-11-29 05:35:33.835877',132,132,'4544ba66fc044b5a8d3aa9deb5249384','b346c374-1f12-48c7-8da6-86e9a58406d9',14,'3e18b41001c440e0a7d05f7f98059230','snapshot_gigabytes',-1,'2025-11-30 05:35:33',NULL),('2025-11-29 05:35:33.791975',NULL,'2025-11-29 05:35:33.835877',133,133,NULL,'ce89b86d-46d9-41ca-9ed9-2597a20ebf30',15,'3e18b41001c440e0a7d05f7f98059230','snapshots',-1,'2025-11-30 05:35:33','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:35:33.792855',NULL,'2025-11-29 05:35:33.835877',134,134,NULL,'2f5ea63c-cb21-4bb9-a8a4-2100a45e9d60',16,'3e18b41001c440e0a7d05f7f98059230','snapshot_gigabytes',-1,'2025-11-30 05:35:33','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:35:36.518007',NULL,'2025-11-29 05:35:36.544829',135,135,'417cb9ae9b2a43429cd5d1781ad57fd9','90f94d8a-6186-4064-9dcc-4451504a8e49',18,'c272c8175ff843ca8dc572501529b10b','shares',-1,'2025-11-30 05:35:36',NULL),('2025-11-29 05:35:36.520315',NULL,'2025-11-29 05:35:36.544829',136,136,'417cb9ae9b2a43429cd5d1781ad57fd9','c609f09b-d50c-4c4e-bd03-20ba37babf6a',17,'c272c8175ff843ca8dc572501529b10b','gigabytes',-1,'2025-11-30 05:35:36',NULL),('2025-11-29 05:35:36.532950',NULL,'2025-11-29 05:35:36.544829',137,137,NULL,'a2e3b9b6-5734-4d3c-a713-8da72c92c505',20,'c272c8175ff843ca8dc572501529b10b','shares',-1,'2025-11-30 05:35:36','897b7777-bc91-41a3-a0ae-0cc41ffc72f9'),('2025-11-29 05:35:36.533830',NULL,'2025-11-29 05:35:36.544829',138,138,NULL,'91f15756-95d8-45a2-9350-35cd477359db',19,'c272c8175ff843ca8dc572501529b10b','gigabytes',-1,'2025-11-30 05:35:36','897b7777-bc91-41a3-a0ae-0cc41ffc72f9'),('2025-11-29 05:35:37.053408',NULL,'2025-11-29 05:35:37.082455',139,139,'4544ba66fc044b5a8d3aa9deb5249384','17118ee2-6d95-40b7-bcc8-cf746af658f3',13,'3e18b41001c440e0a7d05f7f98059230','snapshots',-1,'2025-11-30 05:35:37',NULL),('2025-11-29 05:35:37.054326',NULL,'2025-11-29 05:35:37.082455',140,140,'4544ba66fc044b5a8d3aa9deb5249384','b2c668aa-72d5-4008-b8eb-2c9d8335d596',14,'3e18b41001c440e0a7d05f7f98059230','snapshot_gigabytes',-1,'2025-11-30 05:35:37',NULL),('2025-11-29 05:35:37.067834',NULL,'2025-11-29 05:35:37.082455',141,141,NULL,'c3a1804a-c6fe-4397-98b8-e6041315d5fc',15,'3e18b41001c440e0a7d05f7f98059230','snapshots',-1,'2025-11-30 05:35:37','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:35:37.074834',NULL,'2025-11-29 05:35:37.082455',142,142,NULL,'85a8eb96-a6ec-43d5-8f5e-6f89f97a2c89',16,'3e18b41001c440e0a7d05f7f98059230','snapshot_gigabytes',-1,'2025-11-30 05:35:37','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:35:40.214552',NULL,'2025-11-29 05:35:40.263843',143,143,'07455b147f224a5e9b6756f05d6a11b2','3746dad7-4396-42d1-adf3-ef8b247432c6',32,'81a95c19e7f04f9388e5b6cb015dc8bf','shares',1,'2025-11-30 05:35:40',NULL),('2025-11-29 05:35:40.219690',NULL,'2025-11-29 05:35:40.263843',144,144,'07455b147f224a5e9b6756f05d6a11b2','7b43c97e-1a71-4b4b-ba2c-07add910a576',31,'81a95c19e7f04f9388e5b6cb015dc8bf','gigabytes',1,'2025-11-30 05:35:40',NULL),('2025-11-29 05:35:40.232442',NULL,'2025-11-29 05:35:40.263843',145,145,NULL,'6229ef41-99a5-4765-afa0-51b08addc86d',34,'81a95c19e7f04f9388e5b6cb015dc8bf','shares',1,'2025-11-30 05:35:40','205bf72e-a1ad-4135-9618-25977b47af59'),('2025-11-29 05:35:40.233767',NULL,'2025-11-29 05:35:40.263843',146,146,NULL,'cf5a2f10-a96c-4e52-a035-70b46ebcca96',33,'81a95c19e7f04f9388e5b6cb015dc8bf','gigabytes',1,'2025-11-30 05:35:40','205bf72e-a1ad-4135-9618-25977b47af59'),('2025-11-29 05:35:40.875411',NULL,'2025-11-29 05:35:40.893095',147,147,'4544ba66fc044b5a8d3aa9deb5249384','732c0dc1-00c4-4a1f-bf3a-972560b72767',13,'3e18b41001c440e0a7d05f7f98059230','snapshots',-1,'2025-11-30 05:35:40',NULL),('2025-11-29 05:35:40.876923',NULL,'2025-11-29 05:35:40.893095',148,148,'4544ba66fc044b5a8d3aa9deb5249384','107f21f6-2bfb-40f0-823d-676c8f4f4df1',14,'3e18b41001c440e0a7d05f7f98059230','snapshot_gigabytes',-1,'2025-11-30 05:35:40',NULL),('2025-11-29 05:35:40.883125',NULL,'2025-11-29 05:35:40.893095',149,149,NULL,'2d2730c3-9d01-4f29-8eb6-9114bdbac0a9',15,'3e18b41001c440e0a7d05f7f98059230','snapshots',-1,'2025-11-30 05:35:40','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:35:40.883889',NULL,'2025-11-29 05:35:40.893095',150,150,NULL,'5c1de506-03c6-49ce-980a-ca8d8f9c273a',16,'3e18b41001c440e0a7d05f7f98059230','snapshot_gigabytes',-1,'2025-11-30 05:35:40','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:35:43.855253',NULL,'2025-11-29 05:35:43.924451',151,151,'07455b147f224a5e9b6756f05d6a11b2','f08d984d-0e73-45c4-927a-dd6271d120c0',32,'81a95c19e7f04f9388e5b6cb015dc8bf','shares',1,'2025-11-30 05:35:43',NULL),('2025-11-29 05:35:43.860250',NULL,'2025-11-29 05:35:43.924451',152,152,'07455b147f224a5e9b6756f05d6a11b2','0cab88fc-d5cb-4adb-82db-aa2e7a99920f',31,'81a95c19e7f04f9388e5b6cb015dc8bf','gigabytes',1,'2025-11-30 05:35:43',NULL),('2025-11-29 05:35:43.887027',NULL,'2025-11-29 05:35:43.924451',153,153,NULL,'f5d314a0-fd93-42c8-b4a9-1577de0449ab',34,'81a95c19e7f04f9388e5b6cb015dc8bf','shares',1,'2025-11-30 05:35:43','205bf72e-a1ad-4135-9618-25977b47af59'),('2025-11-29 05:35:43.892757',NULL,'2025-11-29 05:35:43.924451',154,154,NULL,'8b21e5bb-c9a9-4f69-acaa-0cd1001ddfbf',33,'81a95c19e7f04f9388e5b6cb015dc8bf','gigabytes',1,'2025-11-30 05:35:43','205bf72e-a1ad-4135-9618-25977b47af59'),('2025-11-29 05:35:44.548276',NULL,'2025-11-29 05:35:44.565992',155,155,'4544ba66fc044b5a8d3aa9deb5249384','023c1e76-e0a4-4297-ab13-0d1aa8f7a3a8',1,'3e18b41001c440e0a7d05f7f98059230','shares',-1,'2025-11-30 05:35:44',NULL),('2025-11-29 05:35:44.549114',NULL,'2025-11-29 05:35:44.565992',156,156,'4544ba66fc044b5a8d3aa9deb5249384','694c1442-8b2d-4504-945a-7c6c26d237ce',2,'3e18b41001c440e0a7d05f7f98059230','gigabytes',-1,'2025-11-30 05:35:44',NULL),('2025-11-29 05:35:44.556841',NULL,'2025-11-29 05:35:44.565992',157,157,NULL,'9f5ef485-b7e0-46d1-ba80-5db6e260ee1f',3,'3e18b41001c440e0a7d05f7f98059230','shares',-1,'2025-11-30 05:35:44','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:35:44.557743',NULL,'2025-11-29 05:35:44.565992',158,158,NULL,'71455e4b-603a-475d-8522-ba1a0cec8029',4,'3e18b41001c440e0a7d05f7f98059230','gigabytes',-1,'2025-11-30 05:35:44','03041fd8-9b14-4a66-8c4c-4377210067b9'),('2025-11-29 05:35:49.086769',NULL,'2025-11-29 05:35:49.101514',159,159,'07455b147f224a5e9b6756f05d6a11b2','d3e9e9f7-6cfc-40cd-abe8-fdbbb971ac6f',32,'81a95c19e7f04f9388e5b6cb015dc8bf','shares',-1,'2025-11-30 05:35:49',NULL),('2025-11-29 05:35:49.087447',NULL,'2025-11-29 05:35:49.101514',160,160,'07455b147f224a5e9b6756f05d6a11b2','e296d2b9-1165-4c40-99cd-b054bcca3f86',31,'81a95c19e7f04f9388e5b6cb015dc8bf','gigabytes',-1,'2025-11-30 05:35:49',NULL),('2025-11-29 05:35:49.094379',NULL,'2025-11-29 05:35:49.101514',161,161,NULL,'8583b2d5-a2c1-4548-9167-5c9842de1bc3',34,'81a95c19e7f04f9388e5b6cb015dc8bf','shares',-1,'2025-11-30 05:35:49','205bf72e-a1ad-4135-9618-25977b47af59'),('2025-11-29 05:35:49.094936',NULL,'2025-11-29 05:35:49.101514',162,162,NULL,'ec225625-257b-494c-9222-fc71b597fce8',33,'81a95c19e7f04f9388e5b6cb015dc8bf','gigabytes',-1,'2025-11-30 05:35:49','205bf72e-a1ad-4135-9618-25977b47af59'),('2025-11-29 05:35:50.862904',NULL,'2025-11-29 05:35:50.902108',163,163,'b5459c3e7d4643048572257a42a70281','ee37ccff-aa05-4bbf-8f76-b5d51acddebc',36,'c6b8afea074442b2b9cd8ed762e06d27','shares',1,'2025-11-30 05:35:50',NULL),('2025-11-29 05:35:50.864339',NULL,'2025-11-29 05:35:50.902108',164,164,'b5459c3e7d4643048572257a42a70281','e0742347-b889-4f33-b704-4a772273e570',35,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',1,'2025-11-30 05:35:50',NULL),('2025-11-29 05:35:50.879188',NULL,'2025-11-29 05:35:50.902108',165,165,NULL,'f9e55125-2807-4154-aaee-2c0427602874',38,'c6b8afea074442b2b9cd8ed762e06d27','shares',1,'2025-11-30 05:35:50','d8457b4e-8e27-45f2-9628-fa0bc63046d3'),('2025-11-29 05:35:50.880297',NULL,'2025-11-29 05:35:50.902108',166,166,NULL,'e325990b-7d7b-4333-a3a2-c82f217fce04',37,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',1,'2025-11-30 05:35:50','d8457b4e-8e27-45f2-9628-fa0bc63046d3'),('2025-11-29 05:35:52.253093',NULL,'2025-11-29 05:35:52.287130',167,167,'07455b147f224a5e9b6756f05d6a11b2','304c1b43-d193-4b1e-a8a4-e729a48ed0d1',32,'81a95c19e7f04f9388e5b6cb015dc8bf','shares',1,'2025-11-30 05:35:52',NULL),('2025-11-29 05:35:52.254357',NULL,'2025-11-29 05:35:52.287130',168,168,'07455b147f224a5e9b6756f05d6a11b2','0fbbe2f5-55a7-4092-9528-65edaaaa3db9',31,'81a95c19e7f04f9388e5b6cb015dc8bf','gigabytes',1,'2025-11-30 05:35:52',NULL),('2025-11-29 05:35:52.260038',NULL,'2025-11-29 05:35:52.287130',169,169,NULL,'1cdb70f0-5380-433c-b558-de3bc4fa4c12',34,'81a95c19e7f04f9388e5b6cb015dc8bf','shares',1,'2025-11-30 05:35:52','205bf72e-a1ad-4135-9618-25977b47af59'),('2025-11-29 05:35:52.261268',NULL,'2025-11-29 05:35:52.287130',170,170,NULL,'d7ee76c3-fcd8-430a-909e-779da1a81952',33,'81a95c19e7f04f9388e5b6cb015dc8bf','gigabytes',1,'2025-11-30 05:35:52','205bf72e-a1ad-4135-9618-25977b47af59'),('2025-11-29 05:35:54.040743',NULL,'2025-11-29 05:35:54.088906',171,171,'ae00d95f95bb4ec8b2178598e348be7a','4f521266-8c6d-4db6-ad3e-eb06cf140092',39,'4453ce436b30425fba6f22e4043ef796','shares',1,'2025-11-30 05:35:54',NULL),('2025-11-29 05:35:54.042262',NULL,'2025-11-29 05:35:54.088906',172,172,'ae00d95f95bb4ec8b2178598e348be7a','75da2c22-2cb1-470d-91f2-f20e5e2f8ec7',40,'4453ce436b30425fba6f22e4043ef796','gigabytes',1,'2025-11-30 05:35:54',NULL),('2025-11-29 05:35:54.058661',NULL,'2025-11-29 05:35:54.088906',173,173,NULL,'806a3536-60fa-4f6a-9015-ad62d03c9629',41,'4453ce436b30425fba6f22e4043ef796','shares',1,'2025-11-30 05:35:54','57502de6-1e0c-41d0-84e3-fe1b0b8839c8'),('2025-11-29 05:35:54.060491',NULL,'2025-11-29 05:35:54.088906',174,174,NULL,'b6c016c7-a9a0-4763-9947-b3f0468ca341',42,'4453ce436b30425fba6f22e4043ef796','gigabytes',1,'2025-11-30 05:35:54','57502de6-1e0c-41d0-84e3-fe1b0b8839c8'),('2025-11-29 05:35:54.630996',NULL,'2025-11-29 05:35:54.705083',175,175,'ae00d95f95bb4ec8b2178598e348be7a','f161be14-5f34-4c83-87b1-265aedc42989',43,'4453ce436b30425fba6f22e4043ef796','snapshots',1,'2025-11-30 05:35:54',NULL),('2025-11-29 05:35:54.632705',NULL,'2025-11-29 05:35:54.705083',176,176,'ae00d95f95bb4ec8b2178598e348be7a','b2ed8eda-851b-47c6-b8a4-9dcb087f70a6',44,'4453ce436b30425fba6f22e4043ef796','snapshot_gigabytes',1,'2025-11-30 05:35:54',NULL),('2025-11-29 05:35:54.647019',NULL,'2025-11-29 05:35:54.705083',177,177,NULL,'569eb63c-a9a5-4a97-9259-674ad371c7ba',45,'4453ce436b30425fba6f22e4043ef796','snapshots',1,'2025-11-30 05:35:54','57502de6-1e0c-41d0-84e3-fe1b0b8839c8'),('2025-11-29 05:35:54.648488',NULL,'2025-11-29 05:35:54.705083',178,178,NULL,'17c404e3-1df4-40fa-9b75-29cb9582fda7',46,'4453ce436b30425fba6f22e4043ef796','snapshot_gigabytes',1,'2025-11-30 05:35:54','57502de6-1e0c-41d0-84e3-fe1b0b8839c8'),('2025-11-29 05:35:54.729999',NULL,'2025-11-29 05:35:54.742219',179,179,'b5459c3e7d4643048572257a42a70281','36939ed9-0f7f-438a-81b5-3d58d4767053',36,'c6b8afea074442b2b9cd8ed762e06d27','shares',-1,'2025-11-30 05:35:54',NULL),('2025-11-29 05:35:54.730752',NULL,'2025-11-29 05:35:54.742219',180,180,'b5459c3e7d4643048572257a42a70281','4855a5f8-cc42-463f-99eb-6f22b784178a',35,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',-1,'2025-11-30 05:35:54',NULL),('2025-11-29 05:35:54.735390',NULL,'2025-11-29 05:35:54.742219',181,181,NULL,'f144bb77-8642-4341-9a08-0ac72a9db21b',38,'c6b8afea074442b2b9cd8ed762e06d27','shares',-1,'2025-11-30 05:35:54','d8457b4e-8e27-45f2-9628-fa0bc63046d3'),('2025-11-29 05:35:54.735999',NULL,'2025-11-29 05:35:54.742219',182,182,NULL,'a83df6f0-99da-4c72-93ea-2bd13076b72f',37,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',-1,'2025-11-30 05:35:54','d8457b4e-8e27-45f2-9628-fa0bc63046d3'),('2025-11-29 05:35:54.923509',NULL,'2025-11-29 05:35:55.123328',183,183,'b5459c3e7d4643048572257a42a70281','4d30f2e3-0dad-46db-892c-c6fc8be4262c',36,'c6b8afea074442b2b9cd8ed762e06d27','shares',1,'2025-11-30 05:35:54',NULL),('2025-11-29 05:35:54.924920',NULL,'2025-11-29 05:35:55.123328',184,184,'b5459c3e7d4643048572257a42a70281','325d2c46-bd9d-48ab-8c3d-73a0a9bba2c7',35,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',1,'2025-11-30 05:35:54',NULL),('2025-11-29 05:35:54.932896',NULL,'2025-11-29 05:35:55.123328',185,185,NULL,'f5581bd8-25b7-44fc-ae12-035ff8e132f9',48,'c6b8afea074442b2b9cd8ed762e06d27','shares',1,'2025-11-30 05:35:54','77e59b2f-3ee6-4ed4-b09e-dedd3f47a51b'),('2025-11-29 05:35:54.933894',NULL,'2025-11-29 05:35:55.123328',186,186,NULL,'87f69dc6-82fe-4e5c-840e-815da83fb749',47,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',1,'2025-11-30 05:35:54','77e59b2f-3ee6-4ed4-b09e-dedd3f47a51b'),('2025-11-29 05:35:58.759600',NULL,'2025-11-29 05:35:58.777421',187,187,'b5459c3e7d4643048572257a42a70281','17d08021-0b5a-4bc9-8934-d886c42b1682',36,'c6b8afea074442b2b9cd8ed762e06d27','shares',-1,'2025-11-30 05:35:58',NULL),('2025-11-29 05:35:58.760610',NULL,'2025-11-29 05:35:58.777421',188,188,'b5459c3e7d4643048572257a42a70281','5dfca337-3206-419f-95ec-a5fec87da2e5',35,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',-1,'2025-11-30 05:35:58',NULL),('2025-11-29 05:35:58.766009',NULL,'2025-11-29 05:35:58.777421',189,189,NULL,'37e1520a-f26e-43ba-8329-3a6bf4af7941',48,'c6b8afea074442b2b9cd8ed762e06d27','shares',-1,'2025-11-30 05:35:58','77e59b2f-3ee6-4ed4-b09e-dedd3f47a51b'),('2025-11-29 05:35:58.766671',NULL,'2025-11-29 05:35:58.777421',190,190,NULL,'f6187558-2338-4ff8-9586-7d9e0e8d12a2',47,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',-1,'2025-11-30 05:35:58','77e59b2f-3ee6-4ed4-b09e-dedd3f47a51b'),('2025-11-29 05:35:58.770047',NULL,'2025-11-29 05:35:58.808609',191,191,'b05695659a244b0999eccfed65868fdb','8bfed811-a471-407e-a338-44f301fc2bad',50,'98fe5191e55f4f689dfe66e587ac3ee6','shares',1,'2025-11-30 05:35:58',NULL),('2025-11-29 05:35:58.771839',NULL,'2025-11-29 05:35:58.808609',192,192,'b05695659a244b0999eccfed65868fdb','22ec6fad-e147-4fd5-8ed1-5b795ed0f0d9',49,'98fe5191e55f4f689dfe66e587ac3ee6','gigabytes',1,'2025-11-30 05:35:58',NULL),('2025-11-29 05:35:58.782617',NULL,'2025-11-29 05:35:58.808609',193,193,NULL,'df25cb80-5efd-4cff-b3a2-4e979b34bf44',52,'98fe5191e55f4f689dfe66e587ac3ee6','shares',1,'2025-11-30 05:35:58','80792ca9-8a81-49c4-baba-8e68998249cb'),('2025-11-29 05:35:58.784664',NULL,'2025-11-29 05:35:58.808609',194,194,NULL,'9d27d767-cc95-4f0f-a5d3-0cf97993032d',51,'98fe5191e55f4f689dfe66e587ac3ee6','gigabytes',1,'2025-11-30 05:35:58','80792ca9-8a81-49c4-baba-8e68998249cb'),('2025-11-29 05:35:58.963211',NULL,'2025-11-29 05:35:59.000190',195,195,'b5459c3e7d4643048572257a42a70281','846e0944-89ba-49df-bd42-0db525f54d0f',36,'c6b8afea074442b2b9cd8ed762e06d27','shares',1,'2025-11-30 05:35:58',NULL),('2025-11-29 05:35:58.964778',NULL,'2025-11-29 05:35:59.000190',196,196,'b5459c3e7d4643048572257a42a70281','adb369ad-56dc-4dad-9356-bbe47d28540c',35,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',1,'2025-11-30 05:35:58',NULL),('2025-11-29 05:35:58.976117',NULL,'2025-11-29 05:35:59.000190',197,197,NULL,'2734e209-e312-4323-bdd4-2e4d0f6c333a',54,'c6b8afea074442b2b9cd8ed762e06d27','shares',1,'2025-11-30 05:35:58','62dda89e-c74f-4ef4-9255-9731f4924d04'),('2025-11-29 05:35:58.977339',NULL,'2025-11-29 05:35:59.000190',198,198,NULL,'ea5cca67-0885-4c6c-b322-51e87d242384',53,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',1,'2025-11-30 05:35:58','62dda89e-c74f-4ef4-9255-9731f4924d04'),('2025-11-29 05:35:59.011718',NULL,'2025-11-29 05:35:59.101592',199,199,'07455b147f224a5e9b6756f05d6a11b2','6aad5509-ef30-438c-98c7-d173dcef0234',32,'81a95c19e7f04f9388e5b6cb015dc8bf','shares',-1,'2025-11-30 05:35:58',NULL),('2025-11-29 05:35:59.014389',NULL,'2025-11-29 05:35:59.101592',200,200,'07455b147f224a5e9b6756f05d6a11b2','f9ebe0a5-dc58-4151-99f2-08a0b81d4cf2',31,'81a95c19e7f04f9388e5b6cb015dc8bf','gigabytes',-1,'2025-11-30 05:35:58',NULL),('2025-11-29 05:35:59.077024',NULL,'2025-11-29 05:35:59.101592',201,201,NULL,'01051615-9678-45ee-9d19-8dbb9c988ed7',34,'81a95c19e7f04f9388e5b6cb015dc8bf','shares',-1,'2025-11-30 05:35:58','205bf72e-a1ad-4135-9618-25977b47af59'),('2025-11-29 05:35:59.078686',NULL,'2025-11-29 05:35:59.101592',202,202,NULL,'7509c933-16c3-42c7-817d-0d7482796f7e',33,'81a95c19e7f04f9388e5b6cb015dc8bf','gigabytes',-1,'2025-11-30 05:35:58','205bf72e-a1ad-4135-9618-25977b47af59'),('2025-11-29 05:35:59.649346',NULL,'2025-11-29 05:35:59.669352',203,203,'ae00d95f95bb4ec8b2178598e348be7a','f67680cc-6829-4856-b3a1-b746102f5497',43,'4453ce436b30425fba6f22e4043ef796','snapshots',-1,'2025-11-30 05:35:59',NULL),('2025-11-29 05:35:59.650243',NULL,'2025-11-29 05:35:59.669352',204,204,'ae00d95f95bb4ec8b2178598e348be7a','c6dc73f4-587c-4205-8970-4318478af4cd',44,'4453ce436b30425fba6f22e4043ef796','snapshot_gigabytes',-1,'2025-11-30 05:35:59',NULL),('2025-11-29 05:35:59.656176',NULL,'2025-11-29 05:35:59.669352',205,205,NULL,'c89fe52a-72c4-4765-bf32-7eb6463489bc',45,'4453ce436b30425fba6f22e4043ef796','snapshots',-1,'2025-11-30 05:35:59','57502de6-1e0c-41d0-84e3-fe1b0b8839c8'),('2025-11-29 05:35:59.657454',NULL,'2025-11-29 05:35:59.669352',206,206,NULL,'497cfaa5-75e3-49b4-8394-e565a2aeaadb',46,'4453ce436b30425fba6f22e4043ef796','snapshot_gigabytes',-1,'2025-11-30 05:35:59','57502de6-1e0c-41d0-84e3-fe1b0b8839c8'),('2025-11-29 05:36:02.129423',NULL,'2025-11-29 05:36:02.178897',207,207,'07455b147f224a5e9b6756f05d6a11b2','f4e2ccb8-70e6-4bc1-b46e-e39a09b51ae9',32,'81a95c19e7f04f9388e5b6cb015dc8bf','shares',1,'2025-11-30 05:36:02',NULL),('2025-11-29 05:36:02.131091',NULL,'2025-11-29 05:36:02.178897',208,208,'07455b147f224a5e9b6756f05d6a11b2','43c43572-4a5b-47ff-a705-008636053405',31,'81a95c19e7f04f9388e5b6cb015dc8bf','gigabytes',1,'2025-11-30 05:36:02',NULL),('2025-11-29 05:36:02.145218',NULL,'2025-11-29 05:36:02.178897',209,209,NULL,'a61e78cc-e71f-4d52-aa83-70d2ebd3c340',34,'81a95c19e7f04f9388e5b6cb015dc8bf','shares',1,'2025-11-30 05:36:02','205bf72e-a1ad-4135-9618-25977b47af59'),('2025-11-29 05:36:02.148328',NULL,'2025-11-29 05:36:02.178897',210,210,NULL,'4abffaae-c5b5-408b-9390-d96a6cb5ce18',33,'81a95c19e7f04f9388e5b6cb015dc8bf','gigabytes',1,'2025-11-30 05:36:02','205bf72e-a1ad-4135-9618-25977b47af59'),('2025-11-29 05:36:02.487462',NULL,'2025-11-29 05:36:02.523540',211,211,'b5459c3e7d4643048572257a42a70281','75564336-5a38-42bf-8b1b-b02924bf0e9c',36,'c6b8afea074442b2b9cd8ed762e06d27','shares',1,'2025-11-30 05:36:02',NULL),('2025-11-29 05:36:02.488934',NULL,'2025-11-29 05:36:02.523540',212,212,'b5459c3e7d4643048572257a42a70281','319e9727-be3d-481b-a33c-c06ec1b3a5bd',35,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',1,'2025-11-30 05:36:02',NULL),('2025-11-29 05:36:02.498709',NULL,'2025-11-29 05:36:02.523540',213,213,NULL,'1e2f5f3e-d32a-4bc4-a3ea-b72a22aecb90',55,'c6b8afea074442b2b9cd8ed762e06d27','shares',1,'2025-11-30 05:36:02','03e2ced0-98dd-40d4-ad9e-7539269b2b2c'),('2025-11-29 05:36:02.499912',NULL,'2025-11-29 05:36:02.523540',214,214,NULL,'e53fd5a3-21dd-4c4b-ae46-ab1198b58066',56,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',1,'2025-11-30 05:36:02','03e2ced0-98dd-40d4-ad9e-7539269b2b2c'),('2025-11-29 05:36:03.059157',NULL,'2025-11-29 05:36:03.076082',215,215,'b05695659a244b0999eccfed65868fdb','7a3103b4-a9dc-48cb-9e1f-96f760bcac14',50,'98fe5191e55f4f689dfe66e587ac3ee6','shares',-1,'2025-11-30 05:36:03',NULL),('2025-11-29 05:36:03.059985',NULL,'2025-11-29 05:36:03.076082',216,216,'b05695659a244b0999eccfed65868fdb','f4213b2e-2de0-48bc-9d75-dedffcec9d2b',49,'98fe5191e55f4f689dfe66e587ac3ee6','gigabytes',-1,'2025-11-30 05:36:03',NULL),('2025-11-29 05:36:03.065860',NULL,'2025-11-29 05:36:03.076082',217,217,NULL,'3c4386b8-2e1d-4471-a717-37fc6d9374c5',52,'98fe5191e55f4f689dfe66e587ac3ee6','shares',-1,'2025-11-30 05:36:03','80792ca9-8a81-49c4-baba-8e68998249cb'),('2025-11-29 05:36:03.066640',NULL,'2025-11-29 05:36:03.076082',218,218,NULL,'7f67bd1f-f500-4738-ae98-59eaa8739111',51,'98fe5191e55f4f689dfe66e587ac3ee6','gigabytes',-1,'2025-11-30 05:36:03','80792ca9-8a81-49c4-baba-8e68998249cb'),('2025-11-29 05:36:03.073311',NULL,'2025-11-29 05:36:03.090545',219,219,'ae00d95f95bb4ec8b2178598e348be7a','8b8f4b1b-d24c-4d6d-943e-240ab7167e35',39,'4453ce436b30425fba6f22e4043ef796','shares',-1,'2025-11-30 05:36:03',NULL),('2025-11-29 05:36:03.074640',NULL,'2025-11-29 05:36:03.090545',220,220,'ae00d95f95bb4ec8b2178598e348be7a','293a9cba-0d69-472a-85f9-45996d3839d0',40,'4453ce436b30425fba6f22e4043ef796','gigabytes',-1,'2025-11-30 05:36:03',NULL),('2025-11-29 05:36:03.080210',NULL,'2025-11-29 05:36:03.090545',221,221,NULL,'737a79cd-4cb3-4421-b68f-a81c036f35ef',41,'4453ce436b30425fba6f22e4043ef796','shares',-1,'2025-11-30 05:36:03','57502de6-1e0c-41d0-84e3-fe1b0b8839c8'),('2025-11-29 05:36:03.081203',NULL,'2025-11-29 05:36:03.090545',222,222,NULL,'7d224b4d-fc8a-4c23-b414-ebd7c81bbcab',42,'4453ce436b30425fba6f22e4043ef796','gigabytes',-1,'2025-11-30 05:36:03','57502de6-1e0c-41d0-84e3-fe1b0b8839c8'),('2025-11-29 05:36:06.099586',NULL,'2025-11-29 05:36:06.113654',223,223,'b5459c3e7d4643048572257a42a70281','a7fbeb9a-b4cc-4c89-b25a-b90469b0ac9d',36,'c6b8afea074442b2b9cd8ed762e06d27','shares',-1,'2025-11-30 05:36:06',NULL),('2025-11-29 05:36:06.100593',NULL,'2025-11-29 05:36:06.113654',224,224,'b5459c3e7d4643048572257a42a70281','4665f811-9ab6-4a68-9b3f-c6d30b31aa72',35,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',-1,'2025-11-30 05:36:06',NULL),('2025-11-29 05:36:06.105977',NULL,'2025-11-29 05:36:06.113654',225,225,NULL,'38f71625-62d4-4879-b950-b1ddf29a18c1',55,'c6b8afea074442b2b9cd8ed762e06d27','shares',-1,'2025-11-30 05:36:06','03e2ced0-98dd-40d4-ad9e-7539269b2b2c'),('2025-11-29 05:36:06.106702',NULL,'2025-11-29 05:36:06.113654',226,226,NULL,'5ef0c643-fe85-4c88-abde-6d65ade09aad',56,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',-1,'2025-11-30 05:36:06','03e2ced0-98dd-40d4-ad9e-7539269b2b2c'),('2025-11-29 05:36:06.220520',NULL,'2025-11-29 05:36:06.236661',227,227,'07455b147f224a5e9b6756f05d6a11b2','3e6ea77a-44ea-46ac-b3f9-e9b557a3972f',32,'81a95c19e7f04f9388e5b6cb015dc8bf','shares',-1,'2025-11-30 05:36:06',NULL),('2025-11-29 05:36:06.222431',NULL,'2025-11-29 05:36:06.236661',228,228,'07455b147f224a5e9b6756f05d6a11b2','251a2283-c61a-4ed1-9a5e-b1e746ca61b0',31,'81a95c19e7f04f9388e5b6cb015dc8bf','gigabytes',-1,'2025-11-30 05:36:06',NULL),('2025-11-29 05:36:06.227585',NULL,'2025-11-29 05:36:06.236661',229,229,NULL,'671dba41-3ec7-4919-b556-1a636e7b2fe8',34,'81a95c19e7f04f9388e5b6cb015dc8bf','shares',-1,'2025-11-30 05:36:06','205bf72e-a1ad-4135-9618-25977b47af59'),('2025-11-29 05:36:06.228250',NULL,'2025-11-29 05:36:06.236661',230,230,NULL,'7cbb3da8-57db-42a5-8324-a502a672825f',33,'81a95c19e7f04f9388e5b6cb015dc8bf','gigabytes',-1,'2025-11-30 05:36:06','205bf72e-a1ad-4135-9618-25977b47af59'),('2025-11-29 05:36:06.387435',NULL,'2025-11-29 05:36:06.407886',231,231,'b5459c3e7d4643048572257a42a70281','554637cd-6df0-4250-bba8-31e892a6e349',36,'c6b8afea074442b2b9cd8ed762e06d27','shares',-1,'2025-11-30 05:36:06',NULL),('2025-11-29 05:36:06.388239',NULL,'2025-11-29 05:36:06.407886',232,232,'b5459c3e7d4643048572257a42a70281','83f4a1c1-f619-4150-90ce-f5644da131e3',35,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',-1,'2025-11-30 05:36:06',NULL),('2025-11-29 05:36:06.393742',NULL,'2025-11-29 05:36:06.407886',233,233,NULL,'9caa6861-0518-434f-8230-f4ef08e617ab',54,'c6b8afea074442b2b9cd8ed762e06d27','shares',-1,'2025-11-30 05:36:06','62dda89e-c74f-4ef4-9255-9731f4924d04'),('2025-11-29 05:36:06.394367',NULL,'2025-11-29 05:36:06.407886',234,234,NULL,'6fab2218-fea1-42e5-906a-25836f8c8c58',53,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',-1,'2025-11-30 05:36:06','62dda89e-c74f-4ef4-9255-9731f4924d04'),('2025-11-29 05:36:06.790670',NULL,'2025-11-29 05:36:06.827872',235,235,'b5459c3e7d4643048572257a42a70281','60e3160b-b24d-4d65-8685-321c59a60be7',36,'c6b8afea074442b2b9cd8ed762e06d27','shares',1,'2025-11-30 05:36:06',NULL),('2025-11-29 05:36:06.792253',NULL,'2025-11-29 05:36:06.827872',236,236,'b5459c3e7d4643048572257a42a70281','5f76c536-277a-45e5-bbcc-729d2f76ad50',35,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',1,'2025-11-30 05:36:06',NULL),('2025-11-29 05:36:06.802601',NULL,'2025-11-29 05:36:06.827872',237,237,NULL,'f460e5f2-c921-47cd-8c36-9974de1de657',58,'c6b8afea074442b2b9cd8ed762e06d27','shares',1,'2025-11-30 05:36:06','e5dc9337-9d3d-486c-9f20-360499be97a6'),('2025-11-29 05:36:06.804022',NULL,'2025-11-29 05:36:06.827872',238,238,NULL,'f597c588-ca00-4ef0-a3db-de43248249b8',57,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',1,'2025-11-30 05:36:06','e5dc9337-9d3d-486c-9f20-360499be97a6'),('2025-11-29 05:36:09.414067',NULL,'2025-11-29 05:36:09.465808',239,239,'07455b147f224a5e9b6756f05d6a11b2','e96cd94d-49f4-4d17-a5dc-869a513eaadb',32,'81a95c19e7f04f9388e5b6cb015dc8bf','shares',1,'2025-11-30 05:36:09',NULL),('2025-11-29 05:36:09.415807',NULL,'2025-11-29 05:36:09.465808',240,240,'07455b147f224a5e9b6756f05d6a11b2','df693945-7f19-4544-a1d6-1541299d8b58',31,'81a95c19e7f04f9388e5b6cb015dc8bf','gigabytes',1,'2025-11-30 05:36:09',NULL),('2025-11-29 05:36:09.422928',NULL,'2025-11-29 05:36:09.465808',241,241,NULL,'0de4a6cd-ac19-4f16-8725-1575afe63c3b',34,'81a95c19e7f04f9388e5b6cb015dc8bf','shares',1,'2025-11-30 05:36:09','205bf72e-a1ad-4135-9618-25977b47af59'),('2025-11-29 05:36:09.424098',NULL,'2025-11-29 05:36:09.465808',242,242,NULL,'bfd08056-71d8-41f3-a484-c407ecf33e87',33,'81a95c19e7f04f9388e5b6cb015dc8bf','gigabytes',1,'2025-11-30 05:36:09','205bf72e-a1ad-4135-9618-25977b47af59'),('2025-11-29 05:36:10.669915',NULL,'2025-11-29 05:36:10.703746',243,243,'b5459c3e7d4643048572257a42a70281','cf0c70a7-ede4-4b67-8bf5-7381178c7474',36,'c6b8afea074442b2b9cd8ed762e06d27','shares',1,'2025-11-30 05:36:10',NULL),('2025-11-29 05:36:10.671782',NULL,'2025-11-29 05:36:10.703746',244,244,'b5459c3e7d4643048572257a42a70281','827ad835-8755-40ad-b561-aefed8d3cbc5',35,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',1,'2025-11-30 05:36:10',NULL),('2025-11-29 05:36:10.682683',NULL,'2025-11-29 05:36:10.703746',245,245,NULL,'d40cf382-0724-4737-95c7-97bd0d33fdca',60,'c6b8afea074442b2b9cd8ed762e06d27','shares',1,'2025-11-30 05:36:10','bb4c2cdc-b39c-4d8f-a756-4b5a9da20637'),('2025-11-29 05:36:10.683821',NULL,'2025-11-29 05:36:10.703746',246,246,NULL,'b5cedbdd-5975-45a4-b347-f24a433c940c',59,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',1,'2025-11-30 05:36:10','bb4c2cdc-b39c-4d8f-a756-4b5a9da20637'),('2025-11-29 05:36:12.203426',NULL,'2025-11-29 05:36:12.271129',247,247,'e834d9d8dc83417ea6c9ba3e6be16616','6eda1ba6-8bac-4f8b-bc42-f9eda0ab0c5a',61,'0448e6e78f8747efb1e6a68338df9866','share_networks',1,'2025-11-30 05:36:12',NULL),('2025-11-29 05:36:12.888076',NULL,'2025-11-29 05:36:12.931239',248,248,'a482e699f6dc4efba8a01a70832bb439','a70dc255-822b-4036-b57f-2f3ff24101bf',62,'061705ddc30c4a188ae026c064f1a2b8','share_networks',1,'2025-11-30 05:36:12',NULL),('2025-11-29 05:36:14.384674',NULL,'2025-11-29 05:36:14.417925',249,249,'b5459c3e7d4643048572257a42a70281','979e2c07-d644-49e6-b5ad-a4b2fd670a85',36,'c6b8afea074442b2b9cd8ed762e06d27','shares',1,'2025-11-30 05:36:14',NULL),('2025-11-29 05:36:14.385956',NULL,'2025-11-29 05:36:14.417925',250,250,'b5459c3e7d4643048572257a42a70281','a4bf1525-f7ea-400c-bcb3-f9963d7332bc',35,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',1,'2025-11-30 05:36:14',NULL),('2025-11-29 05:36:14.396646',NULL,'2025-11-29 05:36:14.417925',251,251,NULL,'4b8ac053-ce76-45ad-95f5-aa2b4eb417dd',64,'c6b8afea074442b2b9cd8ed762e06d27','shares',1,'2025-11-30 05:36:14','644aee24-dced-4b70-b164-4e0bd00ebe5c'),('2025-11-29 05:36:14.397868',NULL,'2025-11-29 05:36:14.417925',252,252,NULL,'d1dafe04-c65f-4aa8-97b5-1f6c4df9e566',63,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',1,'2025-11-30 05:36:14','644aee24-dced-4b70-b164-4e0bd00ebe5c'),('2025-11-29 05:36:14.967909',NULL,'2025-11-29 05:36:14.992668',253,253,'07455b147f224a5e9b6756f05d6a11b2','667c84e4-6c10-4e87-ad72-484d87208923',32,'81a95c19e7f04f9388e5b6cb015dc8bf','shares',-1,'2025-11-30 05:36:14',NULL),('2025-11-29 05:36:14.969020',NULL,'2025-11-29 05:36:14.992668',254,254,'07455b147f224a5e9b6756f05d6a11b2','1ec85ee9-3a88-4bf2-bd71-908318a4ad48',31,'81a95c19e7f04f9388e5b6cb015dc8bf','gigabytes',-1,'2025-11-30 05:36:14',NULL),('2025-11-29 05:36:14.977050',NULL,'2025-11-29 05:36:14.992668',255,255,NULL,'3585ac3f-2b5b-459e-90eb-ada72d4e6e54',34,'81a95c19e7f04f9388e5b6cb015dc8bf','shares',-1,'2025-11-30 05:36:14','205bf72e-a1ad-4135-9618-25977b47af59'),('2025-11-29 05:36:14.978454',NULL,'2025-11-29 05:36:14.992668',256,256,NULL,'bd56a8f4-2878-4a1f-8004-83e114128239',33,'81a95c19e7f04f9388e5b6cb015dc8bf','gigabytes',-1,'2025-11-30 05:36:14','205bf72e-a1ad-4135-9618-25977b47af59'),('2025-11-29 05:36:15.034919',NULL,'2025-11-29 05:36:15.039956',257,257,'e834d9d8dc83417ea6c9ba3e6be16616','bff9faa6-3ad8-4f9a-9dd9-53b930b86cb0',61,'0448e6e78f8747efb1e6a68338df9866','share_networks',-1,'2025-11-30 05:36:15',NULL),('2025-11-29 05:36:18.313573',NULL,'2025-11-29 05:36:18.339046',258,258,'b5459c3e7d4643048572257a42a70281','ac38da7e-3bd5-4065-98dd-884d330015ca',36,'c6b8afea074442b2b9cd8ed762e06d27','shares',-1,'2025-11-30 05:36:18',NULL),('2025-11-29 05:36:18.314652',NULL,'2025-11-29 05:36:18.339046',259,259,'b5459c3e7d4643048572257a42a70281','21adda6d-4f7e-40ca-9faf-488f288b5816',35,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',-1,'2025-11-30 05:36:18',NULL),('2025-11-29 05:36:18.326078',NULL,'2025-11-29 05:36:18.339046',260,260,NULL,'5e2ed157-0b7b-4536-be8e-e3b17023a044',64,'c6b8afea074442b2b9cd8ed762e06d27','shares',-1,'2025-11-30 05:36:18','644aee24-dced-4b70-b164-4e0bd00ebe5c'),('2025-11-29 05:36:18.327634',NULL,'2025-11-29 05:36:18.339046',261,261,NULL,'7d9b30b4-fe3a-4082-9991-cafcfed6b034',63,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',-1,'2025-11-30 05:36:18','644aee24-dced-4b70-b164-4e0bd00ebe5c'),('2025-11-29 05:36:18.627896',NULL,'2025-11-29 05:36:18.649871',262,262,'b5459c3e7d4643048572257a42a70281','e01e2410-ed0d-44e6-a383-b725306bec83',36,'c6b8afea074442b2b9cd8ed762e06d27','shares',-1,'2025-11-30 05:36:18',NULL),('2025-11-29 05:36:18.628848',NULL,'2025-11-29 05:36:18.649871',263,263,'b5459c3e7d4643048572257a42a70281','5921865d-ab21-40ee-9e80-f29ca7b85d40',35,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',-1,'2025-11-30 05:36:18',NULL),('2025-11-29 05:36:18.636588',NULL,'2025-11-29 05:36:18.649871',264,264,NULL,'c6b5640c-290e-4b77-857a-86ad89b13b12',60,'c6b8afea074442b2b9cd8ed762e06d27','shares',-1,'2025-11-30 05:36:18','bb4c2cdc-b39c-4d8f-a756-4b5a9da20637'),('2025-11-29 05:36:18.637521',NULL,'2025-11-29 05:36:18.649871',265,265,NULL,'7dfbc341-9eb0-4637-96b9-8b16f7f014c6',59,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',-1,'2025-11-30 05:36:18','bb4c2cdc-b39c-4d8f-a756-4b5a9da20637'),('2025-11-29 05:36:18.906306',NULL,'2025-11-29 05:36:18.921048',266,266,'b5459c3e7d4643048572257a42a70281','c5957348-2ba3-4db5-a015-984cc7d11551',36,'c6b8afea074442b2b9cd8ed762e06d27','shares',-1,'2025-11-30 05:36:18',NULL),('2025-11-29 05:36:18.907499',NULL,'2025-11-29 05:36:18.921048',267,267,'b5459c3e7d4643048572257a42a70281','27af7449-e6bc-4de3-8602-d85275c33e64',35,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',-1,'2025-11-30 05:36:18',NULL),('2025-11-29 05:36:18.912544',NULL,'2025-11-29 05:36:18.921048',268,268,NULL,'3a11b3ec-fdab-47a8-84cc-e2f95ee01ea0',58,'c6b8afea074442b2b9cd8ed762e06d27','shares',-1,'2025-11-30 05:36:18','e5dc9337-9d3d-486c-9f20-360499be97a6'),('2025-11-29 05:36:18.913377',NULL,'2025-11-29 05:36:18.921048',269,269,NULL,'461d35b1-0d61-46e7-8577-ea63094cb924',57,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',-1,'2025-11-30 05:36:18','e5dc9337-9d3d-486c-9f20-360499be97a6'),('2025-11-29 05:36:19.191450',NULL,'2025-11-29 05:36:19.238268',270,270,'b5459c3e7d4643048572257a42a70281','07482e8a-6075-4478-9f39-af3a45ac977c',36,'c6b8afea074442b2b9cd8ed762e06d27','shares',1,'2025-11-30 05:36:19',NULL),('2025-11-29 05:36:19.193834',NULL,'2025-11-29 05:36:19.238268',271,271,'b5459c3e7d4643048572257a42a70281','115aa37f-8098-45d3-ae1a-5213a3dbcbff',35,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',1,'2025-11-30 05:36:19',NULL),('2025-11-29 05:36:19.206520',NULL,'2025-11-29 05:36:19.238268',272,272,NULL,'475d79d5-bd02-4792-b45b-93aa6d07b929',65,'c6b8afea074442b2b9cd8ed762e06d27','shares',1,'2025-11-30 05:36:19','a681e9d5-0cbf-4919-9306-45c3663a2e71'),('2025-11-29 05:36:19.208183',NULL,'2025-11-29 05:36:19.238268',273,273,NULL,'08a81304-ab25-4c8d-837e-c066012cf7ab',66,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',1,'2025-11-30 05:36:19','a681e9d5-0cbf-4919-9306-45c3663a2e71'),('2025-11-29 05:36:20.082732',NULL,'2025-11-29 05:36:20.142771',274,274,'07455b147f224a5e9b6756f05d6a11b2','b7e84f03-1039-43b8-9363-69d2573a9d19',32,'81a95c19e7f04f9388e5b6cb015dc8bf','shares',1,'2025-11-30 05:36:20',NULL),('2025-11-29 05:36:20.084041',NULL,'2025-11-29 05:36:20.142771',275,275,'07455b147f224a5e9b6756f05d6a11b2','514180cc-b8b2-4c44-8f89-e8343e87bdfb',31,'81a95c19e7f04f9388e5b6cb015dc8bf','gigabytes',1,'2025-11-30 05:36:20',NULL),('2025-11-29 05:36:20.097228',NULL,'2025-11-29 05:36:20.142771',276,276,NULL,'96401345-1864-47b7-8773-8815bdb64815',34,'81a95c19e7f04f9388e5b6cb015dc8bf','shares',1,'2025-11-30 05:36:20','205bf72e-a1ad-4135-9618-25977b47af59'),('2025-11-29 05:36:20.099401',NULL,'2025-11-29 05:36:20.142771',277,277,NULL,'f5366d18-4404-40df-8ed5-f34460b0486a',33,'81a95c19e7f04f9388e5b6cb015dc8bf','gigabytes',1,'2025-11-30 05:36:20','205bf72e-a1ad-4135-9618-25977b47af59'),('2025-11-29 05:36:22.988959',NULL,'2025-11-29 05:36:23.038626',278,278,'b5459c3e7d4643048572257a42a70281','477409f3-84d7-48cf-b5cf-c396c5199e5c',36,'c6b8afea074442b2b9cd8ed762e06d27','shares',1,'2025-11-30 05:36:22',NULL),('2025-11-29 05:36:22.992362',NULL,'2025-11-29 05:36:23.038626',279,279,'b5459c3e7d4643048572257a42a70281','9f12616f-bf4a-4526-ae9b-52efdd01c191',35,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',1,'2025-11-30 05:36:22',NULL),('2025-11-29 05:36:23.007820',NULL,'2025-11-29 05:36:23.038626',280,280,NULL,'b319f734-aa39-4dfb-8c88-faf60f6bdf47',68,'c6b8afea074442b2b9cd8ed762e06d27','shares',1,'2025-11-30 05:36:22','83704507-2af4-41ec-bd6a-c7c15772addd'),('2025-11-29 05:36:23.009459',NULL,'2025-11-29 05:36:23.038626',281,281,NULL,'3a43a0ec-0909-4a1f-a901-a38ad13c9531',67,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',1,'2025-11-30 05:36:22','83704507-2af4-41ec-bd6a-c7c15772addd'),('2025-11-29 05:36:23.436519',NULL,'2025-11-29 05:36:23.468035',282,282,'07455b147f224a5e9b6756f05d6a11b2','6af012d3-3e25-462a-9d4b-5c5c91f8f828',32,'81a95c19e7f04f9388e5b6cb015dc8bf','shares',-1,'2025-11-30 05:36:23',NULL),('2025-11-29 05:36:23.437636',NULL,'2025-11-29 05:36:23.468035',283,283,'07455b147f224a5e9b6756f05d6a11b2','dc532a56-112f-41fa-a7bc-5765b87c537e',31,'81a95c19e7f04f9388e5b6cb015dc8bf','gigabytes',-1,'2025-11-30 05:36:23',NULL),('2025-11-29 05:36:23.456322',NULL,'2025-11-29 05:36:23.468035',284,284,NULL,'303c08f1-896f-417a-a8d8-100ccdb8cc93',34,'81a95c19e7f04f9388e5b6cb015dc8bf','shares',-1,'2025-11-30 05:36:23','205bf72e-a1ad-4135-9618-25977b47af59'),('2025-11-29 05:36:23.457319',NULL,'2025-11-29 05:36:23.468035',285,285,NULL,'a1bb9852-7a9c-4d5a-9952-57ffb0e3e5e4',33,'81a95c19e7f04f9388e5b6cb015dc8bf','gigabytes',-1,'2025-11-30 05:36:23','205bf72e-a1ad-4135-9618-25977b47af59'),('2025-11-29 05:36:23.489071',NULL,'2025-11-29 05:36:23.528902',286,286,'df986af3d0c84127a1e3fbaab7aaf38b','71af0f72-fdd9-47d1-a163-4d6a343238f5',69,'c48d0a2145674172882133c87bb61929','shares',1,'2025-11-30 05:36:23',NULL),('2025-11-29 05:36:23.490472',NULL,'2025-11-29 05:36:23.528902',287,287,'df986af3d0c84127a1e3fbaab7aaf38b','b1257c5e-5817-4f44-9901-ada5ccec04d8',70,'c48d0a2145674172882133c87bb61929','gigabytes',1,'2025-11-30 05:36:23',NULL),('2025-11-29 05:36:23.499978',NULL,'2025-11-29 05:36:23.528902',288,288,NULL,'50555aa7-1678-49d8-a011-410813b2eef9',71,'c48d0a2145674172882133c87bb61929','shares',1,'2025-11-30 05:36:23','f0da18b9-ba8c-41ec-8938-860c87e4760c'),('2025-11-29 05:36:23.501245',NULL,'2025-11-29 05:36:23.528902',289,289,NULL,'59fffd50-9c72-4edc-a357-e2778bee822d',72,'c48d0a2145674172882133c87bb61929','gigabytes',1,'2025-11-30 05:36:23','f0da18b9-ba8c-41ec-8938-860c87e4760c'),('2025-11-29 05:36:27.122010',NULL,'2025-11-29 05:36:27.141419',290,290,'b5459c3e7d4643048572257a42a70281','2b6cfa9a-0384-40b5-b2f0-9db6f24ca85c',36,'c6b8afea074442b2b9cd8ed762e06d27','shares',-1,'2025-11-30 05:36:27',NULL),('2025-11-29 05:36:27.122706',NULL,'2025-11-29 05:36:27.141419',291,291,'b5459c3e7d4643048572257a42a70281','ad67552e-d25d-4e3f-9d26-99b431579657',35,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',-1,'2025-11-30 05:36:27',NULL),('2025-11-29 05:36:27.132278',NULL,'2025-11-29 05:36:27.141419',292,292,NULL,'787e9106-9e54-4685-ae87-1d0179a011f5',68,'c6b8afea074442b2b9cd8ed762e06d27','shares',-1,'2025-11-30 05:36:27','83704507-2af4-41ec-bd6a-c7c15772addd'),('2025-11-29 05:36:27.133168',NULL,'2025-11-29 05:36:27.141419',293,293,NULL,'d1e4ee06-9feb-4d5a-9a2f-0b3e56da2666',67,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',-1,'2025-11-30 05:36:27','83704507-2af4-41ec-bd6a-c7c15772addd'),('2025-11-29 05:36:27.366842',NULL,'2025-11-29 05:36:27.390158',294,294,'b5459c3e7d4643048572257a42a70281','6a6094af-f19a-4778-ab81-00b5fa4cdc7b',36,'c6b8afea074442b2b9cd8ed762e06d27','shares',-1,'2025-11-30 05:36:27',NULL),('2025-11-29 05:36:27.368009',NULL,'2025-11-29 05:36:27.390158',295,295,'b5459c3e7d4643048572257a42a70281','d4715c97-25a2-4c9b-bdd2-0ce6bb922a35',35,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',-1,'2025-11-30 05:36:27',NULL),('2025-11-29 05:36:27.374480',NULL,'2025-11-29 05:36:27.390158',296,296,NULL,'af6cafa2-bd1d-49ce-a75f-f21aa12d80cf',65,'c6b8afea074442b2b9cd8ed762e06d27','shares',-1,'2025-11-30 05:36:27','a681e9d5-0cbf-4919-9306-45c3663a2e71'),('2025-11-29 05:36:27.375183',NULL,'2025-11-29 05:36:27.390158',297,297,NULL,'7a5d4985-2150-4c3a-8487-b012718d3d0b',66,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',-1,'2025-11-30 05:36:27','a681e9d5-0cbf-4919-9306-45c3663a2e71'),('2025-11-29 05:36:27.590268',NULL,'2025-11-29 05:36:27.675770',298,298,'b5459c3e7d4643048572257a42a70281','f39def42-32a8-42bd-91ce-e0d326823d6a',36,'c6b8afea074442b2b9cd8ed762e06d27','shares',1,'2025-11-30 05:36:27',NULL),('2025-11-29 05:36:27.591775',NULL,'2025-11-29 05:36:27.675770',299,299,'b5459c3e7d4643048572257a42a70281','4d1e70e4-cf6c-414e-863c-dc353392243a',35,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',1,'2025-11-30 05:36:27',NULL),('2025-11-29 05:36:27.597890',NULL,'2025-11-29 05:36:27.688014',300,300,'df986af3d0c84127a1e3fbaab7aaf38b','d4f26bc3-7c89-402c-84c9-8730fa91b06f',74,'c48d0a2145674172882133c87bb61929','shares',1,'2025-11-30 05:36:27',NULL),('2025-11-29 05:36:27.599321',NULL,'2025-11-29 05:36:27.688014',301,301,'df986af3d0c84127a1e3fbaab7aaf38b','e1566b92-1bab-425f-8768-cbbf95a210aa',73,'c48d0a2145674172882133c87bb61929','gigabytes',1,'2025-11-30 05:36:27',NULL),('2025-11-29 05:36:27.609394',NULL,'2025-11-29 05:36:27.675770',302,302,NULL,'af437cd6-1d24-4889-ae96-ac604a3e74aa',76,'c6b8afea074442b2b9cd8ed762e06d27','shares',1,'2025-11-30 05:36:27','7d4fb520-be4b-4ab9-a6cf-8d815f406791'),('2025-11-29 05:36:27.610555',NULL,'2025-11-29 05:36:27.675770',303,303,NULL,'402d69ac-f516-4541-afde-3394d3aefd7c',75,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',1,'2025-11-30 05:36:27','7d4fb520-be4b-4ab9-a6cf-8d815f406791'),('2025-11-29 05:36:27.659688',NULL,'2025-11-29 05:36:27.688014',304,304,NULL,'672d9044-55d9-4883-8464-9aab33a7e164',78,'c48d0a2145674172882133c87bb61929','shares',1,'2025-11-30 05:36:27','1f1645da-a938-4300-adbc-b0962ae574cd'),('2025-11-29 05:36:27.664357',NULL,'2025-11-29 05:36:27.688014',305,305,NULL,'2c7b9311-44b4-49b4-90b3-751829d3d3df',77,'c48d0a2145674172882133c87bb61929','gigabytes',1,'2025-11-30 05:36:27','1f1645da-a938-4300-adbc-b0962ae574cd'),('2025-11-29 05:36:29.444937',NULL,'2025-11-29 05:36:29.488825',306,306,'07455b147f224a5e9b6756f05d6a11b2','05ad75cd-9b5f-49c2-a7a6-b577c10af809',32,'81a95c19e7f04f9388e5b6cb015dc8bf','shares',-1,'2025-11-30 05:36:29',NULL),('2025-11-29 05:36:29.446883',NULL,'2025-11-29 05:36:29.488825',307,307,'07455b147f224a5e9b6756f05d6a11b2','a349e241-cd92-4337-b92a-c309f46a95bc',31,'81a95c19e7f04f9388e5b6cb015dc8bf','gigabytes',-1,'2025-11-30 05:36:29',NULL),('2025-11-29 05:36:29.461560',NULL,'2025-11-29 05:36:29.488825',308,308,NULL,'1ac93661-aa67-411e-8d95-1af318095fc0',34,'81a95c19e7f04f9388e5b6cb015dc8bf','shares',-1,'2025-11-30 05:36:29','205bf72e-a1ad-4135-9618-25977b47af59'),('2025-11-29 05:36:29.469713',NULL,'2025-11-29 05:36:29.488825',309,309,NULL,'e20d66cb-99ae-491f-bb92-558fe2686df7',33,'81a95c19e7f04f9388e5b6cb015dc8bf','gigabytes',-1,'2025-11-30 05:36:29','205bf72e-a1ad-4135-9618-25977b47af59'),('2025-11-29 05:36:31.452233',NULL,'2025-11-29 05:36:31.546844',310,310,'df986af3d0c84127a1e3fbaab7aaf38b','e32b5cac-f737-4658-95e5-269e03b1da3f',79,'c48d0a2145674172882133c87bb61929','snapshots',1,'2025-11-30 05:36:31',NULL),('2025-11-29 05:36:31.454509',NULL,'2025-11-29 05:36:31.546844',311,311,'df986af3d0c84127a1e3fbaab7aaf38b','c2d05564-f63f-4ce8-be66-ef61b17fb863',80,'c48d0a2145674172882133c87bb61929','snapshot_gigabytes',1,'2025-11-30 05:36:31',NULL),('2025-11-29 05:36:31.468854',NULL,'2025-11-29 05:36:31.546844',312,312,NULL,'e406c7dc-6905-4db4-9bea-4c98d3e46161',81,'c48d0a2145674172882133c87bb61929','snapshots',1,'2025-11-30 05:36:31','1f1645da-a938-4300-adbc-b0962ae574cd'),('2025-11-29 05:36:31.469926',NULL,'2025-11-29 05:36:31.546844',313,313,NULL,'43f12d63-ca7e-4327-b460-1b3a09b72952',82,'c48d0a2145674172882133c87bb61929','snapshot_gigabytes',1,'2025-11-30 05:36:31','1f1645da-a938-4300-adbc-b0962ae574cd'),('2025-11-29 05:36:31.648521',NULL,'2025-11-29 05:36:31.660541',314,314,'b5459c3e7d4643048572257a42a70281','2dfaaf09-0853-47d5-8dd0-a6fb751c953a',36,'c6b8afea074442b2b9cd8ed762e06d27','shares',-1,'2025-11-30 05:36:31',NULL),('2025-11-29 05:36:31.649259',NULL,'2025-11-29 05:36:31.660541',315,315,'b5459c3e7d4643048572257a42a70281','93d8dbdc-311f-49d5-bb7c-c09b4e256927',35,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',-1,'2025-11-30 05:36:31',NULL),('2025-11-29 05:36:31.654182',NULL,'2025-11-29 05:36:31.660541',316,316,NULL,'5746ff59-e040-4e5d-ae31-4b25479a71e7',76,'c6b8afea074442b2b9cd8ed762e06d27','shares',-1,'2025-11-30 05:36:31','7d4fb520-be4b-4ab9-a6cf-8d815f406791'),('2025-11-29 05:36:31.654758',NULL,'2025-11-29 05:36:31.660541',317,317,NULL,'1ddd928f-5c3f-450c-a229-9f879cc5e8bf',75,'c6b8afea074442b2b9cd8ed762e06d27','gigabytes',-1,'2025-11-30 05:36:31','7d4fb520-be4b-4ab9-a6cf-8d815f406791'),('2025-11-29 05:36:35.496324',NULL,'2025-11-29 05:36:35.542850',318,318,'9b2862373bbf44779eeacbfbcfe988ee','b6e6abaa-c29a-49ce-ba96-b9524d3e9716',84,'0c1d652029574d0fa397d5399235f790','shares',1,'2025-11-30 05:36:35',NULL),('2025-11-29 05:36:35.497543',NULL,'2025-11-29 05:36:35.542850',319,319,'9b2862373bbf44779eeacbfbcfe988ee','5be8777a-f34a-4b14-8eec-864a625aadf0',83,'0c1d652029574d0fa397d5399235f790','gigabytes',1,'2025-11-30 05:36:35',NULL),('2025-11-29 05:36:35.510331',NULL,'2025-11-29 05:36:35.542850',320,320,NULL,'b768e579-91f1-4fde-8ca4-71a1bd61c812',86,'0c1d652029574d0fa397d5399235f790','shares',1,'2025-11-30 05:36:35','7f2792d4-06d9-4366-b057-6d917cc2fefa'),('2025-11-29 05:36:35.512209',NULL,'2025-11-29 05:36:35.542850',321,321,NULL,'fa62be07-5aa9-4724-80a5-0c066d060317',85,'0c1d652029574d0fa397d5399235f790','gigabytes',1,'2025-11-30 05:36:35','7f2792d4-06d9-4366-b057-6d917cc2fefa'),('2025-11-29 05:36:39.252300',NULL,'2025-11-29 05:36:39.422085',322,322,'9b2862373bbf44779eeacbfbcfe988ee','1befa04d-4139-40cb-9a62-6c651416afb9',87,'0c1d652029574d0fa397d5399235f790','snapshots',1,'2025-11-30 05:36:39',NULL),('2025-11-29 05:36:39.253658',NULL,'2025-11-29 05:36:39.422085',323,323,'9b2862373bbf44779eeacbfbcfe988ee','a09e23e3-3266-474f-8b8f-0ff9a63c2425',88,'0c1d652029574d0fa397d5399235f790','snapshot_gigabytes',1,'2025-11-30 05:36:39',NULL),('2025-11-29 05:36:39.286167',NULL,'2025-11-29 05:36:39.422085',324,324,NULL,'8bbcad66-283a-42ce-8587-3712927f5cac',89,'0c1d652029574d0fa397d5399235f790','snapshots',1,'2025-11-30 05:36:39','7f2792d4-06d9-4366-b057-6d917cc2fefa'),('2025-11-29 05:36:39.287342',NULL,'2025-11-29 05:36:39.422085',325,325,NULL,'a5caf2cc-c860-43e3-babc-f1d12bfdcb03',90,'0c1d652029574d0fa397d5399235f790','snapshot_gigabytes',1,'2025-11-30 05:36:39','7f2792d4-06d9-4366-b057-6d917cc2fefa'),('2025-11-29 05:36:44.759671',NULL,'2025-11-29 05:36:44.796410',326,326,'9b2862373bbf44779eeacbfbcfe988ee','36217f2a-ed42-47b7-832d-7fd1bed2b819',87,'0c1d652029574d0fa397d5399235f790','snapshots',-1,'2025-11-30 05:36:44',NULL),('2025-11-29 05:36:44.761003',NULL,'2025-11-29 05:36:44.796410',327,327,'9b2862373bbf44779eeacbfbcfe988ee','76789cc4-bc07-40b1-bcfe-a0698e5166e3',88,'0c1d652029574d0fa397d5399235f790','snapshot_gigabytes',-1,'2025-11-30 05:36:44',NULL),('2025-11-29 05:36:44.774357',NULL,'2025-11-29 05:36:44.796410',328,328,NULL,'518b3cd1-5329-494d-9360-49db6eefd68b',89,'0c1d652029574d0fa397d5399235f790','snapshots',-1,'2025-11-30 05:36:44','7f2792d4-06d9-4366-b057-6d917cc2fefa'),('2025-11-29 05:36:44.775334',NULL,'2025-11-29 05:36:44.796410',329,329,NULL,'ec31e9d7-ad4a-4e3e-b38a-85f697fd09ea',90,'0c1d652029574d0fa397d5399235f790','snapshot_gigabytes',-1,'2025-11-30 05:36:44','7f2792d4-06d9-4366-b057-6d917cc2fefa'),('2025-11-29 05:36:45.747724',NULL,'2025-11-29 05:36:45.792906',330,330,'6c79efccd5e949dba16681088657b988','000a62f7-8a0c-4bc0-a1c7-f48bad4078ad',92,'4ebe049df4f04fa2a5f37dadb54a1497','shares',1,'2025-11-30 05:36:45',NULL),('2025-11-29 05:36:45.748779',NULL,'2025-11-29 05:36:45.792906',331,331,'6c79efccd5e949dba16681088657b988','1acf473f-2605-4708-a0f8-229d819c037e',91,'4ebe049df4f04fa2a5f37dadb54a1497','gigabytes',1,'2025-11-30 05:36:45',NULL),('2025-11-29 05:36:45.762891',NULL,'2025-11-29 05:36:45.792906',332,332,NULL,'bb5702b4-fd10-459e-9b77-f5687b4a9617',94,'4ebe049df4f04fa2a5f37dadb54a1497','shares',1,'2025-11-30 05:36:45','eb844929-18ba-4d18-8fc0-5ba67aa3721e'),('2025-11-29 05:36:45.764356',NULL,'2025-11-29 05:36:45.792906',333,333,NULL,'6e9afd53-3da5-4968-9bad-0038cf7e3819',93,'4ebe049df4f04fa2a5f37dadb54a1497','gigabytes',1,'2025-11-30 05:36:45','eb844929-18ba-4d18-8fc0-5ba67aa3721e'),('2025-11-29 05:36:47.602642',NULL,'2025-11-29 05:36:47.634571',334,334,'df986af3d0c84127a1e3fbaab7aaf38b','274f6ab5-5ec4-4c85-bfd7-d6de57fe2cb7',95,'c48d0a2145674172882133c87bb61929','snapshots',-1,'2025-11-30 05:36:47',NULL),('2025-11-29 05:36:47.603327',NULL,'2025-11-29 05:36:47.634571',335,335,'df986af3d0c84127a1e3fbaab7aaf38b','f88eb9d9-b320-4427-b753-cf93f33e27b2',96,'c48d0a2145674172882133c87bb61929','snapshot_gigabytes',-1,'2025-11-30 05:36:47',NULL),('2025-11-29 05:36:47.623842',NULL,'2025-11-29 05:36:47.634571',336,336,NULL,'c1931f37-787d-4268-8f78-70880ab23257',97,'c48d0a2145674172882133c87bb61929','snapshots',-1,'2025-11-30 05:36:47','1f1645da-a938-4300-adbc-b0962ae574cd'),('2025-11-29 05:36:47.624731',NULL,'2025-11-29 05:36:47.634571',337,337,NULL,'d6399b0e-77df-4a13-b152-5b05331ebbfd',98,'c48d0a2145674172882133c87bb61929','snapshot_gigabytes',-1,'2025-11-30 05:36:47','1f1645da-a938-4300-adbc-b0962ae574cd'),('2025-11-29 05:36:48.443046',NULL,'2025-11-29 05:36:48.455686',338,338,'9b2862373bbf44779eeacbfbcfe988ee','f262009f-ccf2-4ab6-9543-9a15d943bae1',84,'0c1d652029574d0fa397d5399235f790','shares',-1,'2025-11-30 05:36:48',NULL),('2025-11-29 05:36:48.443760',NULL,'2025-11-29 05:36:48.455686',339,339,'9b2862373bbf44779eeacbfbcfe988ee','4278fcad-7441-4d1b-9ffc-e7ed4255cf3c',83,'0c1d652029574d0fa397d5399235f790','gigabytes',-1,'2025-11-30 05:36:48',NULL),('2025-11-29 05:36:48.448966',NULL,'2025-11-29 05:36:48.455686',340,340,NULL,'dbf3f22c-8300-4fbc-bdcd-2ceaea907f66',86,'0c1d652029574d0fa397d5399235f790','shares',-1,'2025-11-30 05:36:48','7f2792d4-06d9-4366-b057-6d917cc2fefa'),('2025-11-29 05:36:48.449508',NULL,'2025-11-29 05:36:48.455686',341,341,NULL,'036515f1-9c4f-4e0c-b91f-89fe4753bce6',85,'0c1d652029574d0fa397d5399235f790','gigabytes',-1,'2025-11-30 05:36:48','7f2792d4-06d9-4366-b057-6d917cc2fefa'),('2025-11-29 05:36:50.972333',NULL,'2025-11-29 05:36:51.030425',342,342,'6c79efccd5e949dba16681088657b988','ba840d46-7b17-49b9-a42d-373ab81de501',92,'4ebe049df4f04fa2a5f37dadb54a1497','shares',-1,'2025-11-30 05:36:50',NULL),('2025-11-29 05:36:50.976152',NULL,'2025-11-29 05:36:51.030425',343,343,'6c79efccd5e949dba16681088657b988','e8ee0aac-4f7c-4822-9e7c-04aaaddd1c29',91,'4ebe049df4f04fa2a5f37dadb54a1497','gigabytes',-1,'2025-11-30 05:36:50',NULL),('2025-11-29 05:36:50.990005',NULL,'2025-11-29 05:36:51.030425',344,344,NULL,'563c3105-7bb4-45e2-923e-1f37a7f93d58',94,'4ebe049df4f04fa2a5f37dadb54a1497','shares',-1,'2025-11-30 05:36:50','eb844929-18ba-4d18-8fc0-5ba67aa3721e'),('2025-11-29 05:36:50.991873',NULL,'2025-11-29 05:36:51.030425',345,345,NULL,'9a30eaa8-3429-4fa3-be2f-8f7f24f6ce04',93,'4ebe049df4f04fa2a5f37dadb54a1497','gigabytes',-1,'2025-11-30 05:36:50','eb844929-18ba-4d18-8fc0-5ba67aa3721e'),('2025-11-29 05:36:51.114932',NULL,'2025-11-29 05:36:51.137118',346,346,'df986af3d0c84127a1e3fbaab7aaf38b','e6f9c547-83ec-4be8-bd94-602d430c7df0',100,'c48d0a2145674172882133c87bb61929','shares',-1,'2025-11-30 05:36:51',NULL),('2025-11-29 05:36:51.115502',NULL,'2025-11-29 05:36:51.137118',347,347,'df986af3d0c84127a1e3fbaab7aaf38b','0cf483ca-ae4c-4e0f-834c-6d508e67fd92',99,'c48d0a2145674172882133c87bb61929','gigabytes',-1,'2025-11-30 05:36:51',NULL),('2025-11-29 05:36:51.129359',NULL,'2025-11-29 05:36:51.137118',348,348,NULL,'492f3a9b-c165-44c7-899a-b698a81d3d5e',102,'c48d0a2145674172882133c87bb61929','shares',-1,'2025-11-30 05:36:51','1f1645da-a938-4300-adbc-b0962ae574cd'),('2025-11-29 05:36:51.130052',NULL,'2025-11-29 05:36:51.137118',349,349,NULL,'f27f2b48-f601-48c4-8368-d304301b60c1',101,'c48d0a2145674172882133c87bb61929','gigabytes',-1,'2025-11-30 05:36:51','1f1645da-a938-4300-adbc-b0962ae574cd'),('2025-11-29 05:36:55.287162',NULL,'2025-11-29 05:36:55.341408',350,350,'df986af3d0c84127a1e3fbaab7aaf38b','19b0f948-76e0-4e93-95cd-cca90611408f',100,'c48d0a2145674172882133c87bb61929','shares',-1,'2025-11-30 05:36:55',NULL),('2025-11-29 05:36:55.288367',NULL,'2025-11-29 05:36:55.341408',351,351,'df986af3d0c84127a1e3fbaab7aaf38b','2061416f-3f39-4b6f-82dc-548340ec72e1',99,'c48d0a2145674172882133c87bb61929','gigabytes',-1,'2025-11-30 05:36:55',NULL),('2025-11-29 05:36:55.328203',NULL,'2025-11-29 05:36:55.341408',352,352,NULL,'ba559f5f-442d-48d1-bdf6-7393d40d758c',104,'c48d0a2145674172882133c87bb61929','shares',-1,'2025-11-30 05:36:55','f0da18b9-ba8c-41ec-8938-860c87e4760c'),('2025-11-29 05:36:55.329044',NULL,'2025-11-29 05:36:55.341408',353,353,NULL,'690f6189-083e-47fe-9d92-6bf7fe7aef1f',103,'c48d0a2145674172882133c87bb61929','gigabytes',-1,'2025-11-30 05:36:55','f0da18b9-ba8c-41ec-8938-860c87e4760c'),('2025-11-29 05:36:58.619215',NULL,'2025-11-29 05:36:58.659011',354,354,'c137c6e1ac7f469f9c4483dd53883c2d','15814d36-28db-4a61-8348-5b5dc0f34c74',105,'f5d6fcc020694561b091889318c2561b','shares',1,'2025-11-30 05:36:58',NULL),('2025-11-29 05:36:58.620810',NULL,'2025-11-29 05:36:58.659011',355,355,'c137c6e1ac7f469f9c4483dd53883c2d','b70a38c5-88ef-44f6-b271-5f820c8fa362',106,'f5d6fcc020694561b091889318c2561b','gigabytes',1,'2025-11-30 05:36:58',NULL),('2025-11-29 05:36:58.633772',NULL,'2025-11-29 05:36:58.659011',356,356,NULL,'aad19a55-b31e-4988-af41-692ecf90fdcd',107,'f5d6fcc020694561b091889318c2561b','shares',1,'2025-11-30 05:36:58','819b63e0-5000-4547-bb28-596952ee3776'),('2025-11-29 05:36:58.635359',NULL,'2025-11-29 05:36:58.659011',357,357,NULL,'a62ee271-ca37-4beb-9e57-0673ca1a5dc4',108,'f5d6fcc020694561b091889318c2561b','gigabytes',1,'2025-11-30 05:36:58','819b63e0-5000-4547-bb28-596952ee3776'),('2025-11-29 05:37:02.776434',NULL,'2025-11-29 05:37:02.862504',358,358,'26c05bae74e84e93a6448d0d1c0e707e','7defea4f-eb28-4d07-acf5-b092e0733855',109,'883530c38e954d818c0c7e7a75eaf2e2','shares',1,'2025-11-30 05:37:02',NULL),('2025-11-29 05:37:02.777594',NULL,'2025-11-29 05:37:02.862504',359,359,'26c05bae74e84e93a6448d0d1c0e707e','8989c3d1-dffe-4aa3-aad5-f4eeb26073e5',110,'883530c38e954d818c0c7e7a75eaf2e2','gigabytes',1,'2025-11-30 05:37:02',NULL),('2025-11-29 05:37:02.794512',NULL,'2025-11-29 05:37:02.862504',360,360,NULL,'07174880-cd00-4f6e-907c-42d41eb1851e',111,'883530c38e954d818c0c7e7a75eaf2e2','shares',1,'2025-11-30 05:37:02','12e06c28-78cd-4240-8800-3060cf711953'),('2025-11-29 05:37:02.796127',NULL,'2025-11-29 05:37:02.862504',361,361,NULL,'62bd9487-93f2-4322-aca3-b02aef13f6a5',112,'883530c38e954d818c0c7e7a75eaf2e2','gigabytes',1,'2025-11-30 05:37:02','12e06c28-78cd-4240-8800-3060cf711953'),('2025-11-29 05:37:09.231662',NULL,'2025-11-29 05:37:09.303330',362,362,'26c05bae74e84e93a6448d0d1c0e707e','3a5d615d-20df-4089-a952-46fe2fb8d9eb',109,'883530c38e954d818c0c7e7a75eaf2e2','shares',-1,'2025-11-30 05:37:09',NULL),('2025-11-29 05:37:09.232455',NULL,'2025-11-29 05:37:09.303330',363,363,'26c05bae74e84e93a6448d0d1c0e707e','0bba9ddb-f6af-41e2-ba6d-1f97e6124537',110,'883530c38e954d818c0c7e7a75eaf2e2','gigabytes',-1,'2025-11-30 05:37:09',NULL),('2025-11-29 05:37:09.255417',NULL,'2025-11-29 05:37:09.303330',364,364,NULL,'da6996b6-64ad-416c-af52-cf6c7a155895',111,'883530c38e954d818c0c7e7a75eaf2e2','shares',-1,'2025-11-30 05:37:09','12e06c28-78cd-4240-8800-3060cf711953'),('2025-11-29 05:37:09.262053',NULL,'2025-11-29 05:37:09.303330',365,365,NULL,'96f467ec-3417-4360-9caf-52fde45781ac',112,'883530c38e954d818c0c7e7a75eaf2e2','gigabytes',-1,'2025-11-30 05:37:09','12e06c28-78cd-4240-8800-3060cf711953'),('2025-11-29 05:37:17.241552',NULL,'2025-11-29 05:37:17.290077',366,366,'4522755852d94dd7bbf637007ec21bf0','0d0ca300-4413-4583-9a59-5be86847e503',113,'ecd2e5916bab4f7cb242a87ec782ffda','shares',1,'2025-11-30 05:37:17',NULL),('2025-11-29 05:37:17.243042',NULL,'2025-11-29 05:37:17.290077',367,367,'4522755852d94dd7bbf637007ec21bf0','ffa466e7-e9d5-4b68-80fc-8f0f3caecfee',114,'ecd2e5916bab4f7cb242a87ec782ffda','gigabytes',1,'2025-11-30 05:37:17',NULL),('2025-11-29 05:37:17.256980',NULL,'2025-11-29 05:37:17.290077',368,368,NULL,'dcea3c3a-6d6c-490f-833f-d03aa457b9f5',115,'ecd2e5916bab4f7cb242a87ec782ffda','shares',1,'2025-11-30 05:37:17','3cde5f7b-914b-4874-be2f-d7385fe4a149'),('2025-11-29 05:37:17.258639',NULL,'2025-11-29 05:37:17.290077',369,369,NULL,'403813fc-2c2a-467c-ba70-6a009226b75b',116,'ecd2e5916bab4f7cb242a87ec782ffda','gigabytes',1,'2025-11-30 05:37:17','3cde5f7b-914b-4874-be2f-d7385fe4a149'),('2025-11-29 05:37:18.639652',NULL,'2025-11-29 05:37:18.662035',370,370,'c137c6e1ac7f469f9c4483dd53883c2d','dfc202b2-a4b1-4262-8e8b-f6abd25e3d34',105,'f5d6fcc020694561b091889318c2561b','shares',-1,'2025-11-30 05:37:18',NULL),('2025-11-29 05:37:18.640605',NULL,'2025-11-29 05:37:18.662035',371,371,'c137c6e1ac7f469f9c4483dd53883c2d','4df9a5f3-65d3-4faa-a30b-8a5c9f44c8ad',106,'f5d6fcc020694561b091889318c2561b','gigabytes',-1,'2025-11-30 05:37:18',NULL),('2025-11-29 05:37:18.649439',NULL,'2025-11-29 05:37:18.662035',372,372,NULL,'d1cb0d51-0e92-4a66-ba3f-054fba438d7c',107,'f5d6fcc020694561b091889318c2561b','shares',-1,'2025-11-30 05:37:18','819b63e0-5000-4547-bb28-596952ee3776'),('2025-11-29 05:37:18.650447',NULL,'2025-11-29 05:37:18.662035',373,373,NULL,'6dae938f-d1bc-4106-bd6d-ec0c7ca4708e',108,'f5d6fcc020694561b091889318c2561b','gigabytes',-1,'2025-11-30 05:37:18','819b63e0-5000-4547-bb28-596952ee3776'),('2025-11-29 05:37:19.063398',NULL,'2025-11-29 05:37:19.107870',374,374,'a0f1e714fbec450395a7fdccce008b46','36b17849-b30a-41b7-a46c-10b681561b94',117,'5dd620782ecb48b9af309e8bc536acb2','shares',1,'2025-11-30 05:37:19',NULL),('2025-11-29 05:37:19.065963',NULL,'2025-11-29 05:37:19.107870',375,375,'a0f1e714fbec450395a7fdccce008b46','6442dc21-1b09-468b-9d21-9dc6992f334b',118,'5dd620782ecb48b9af309e8bc536acb2','gigabytes',1,'2025-11-30 05:37:19',NULL),('2025-11-29 05:37:19.079416',NULL,'2025-11-29 05:37:19.107870',376,376,NULL,'ac3f5c60-fb49-4a7a-bef0-0c9feca258f2',119,'5dd620782ecb48b9af309e8bc536acb2','shares',1,'2025-11-30 05:37:19','27ce7e9e-5dd7-42c3-997a-123357081bf4'),('2025-11-29 05:37:19.080835',NULL,'2025-11-29 05:37:19.107870',377,377,NULL,'6f4d0429-be92-43c3-a5db-9772fcdf4650',120,'5dd620782ecb48b9af309e8bc536acb2','gigabytes',1,'2025-11-30 05:37:19','27ce7e9e-5dd7-42c3-997a-123357081bf4'),('2025-11-29 05:37:21.024409',NULL,'2025-11-29 05:37:21.127454',378,378,'4522755852d94dd7bbf637007ec21bf0','a27e1b81-02af-485f-a795-40040b3ac743',121,'ecd2e5916bab4f7cb242a87ec782ffda','snapshots',1,'2025-11-30 05:37:20',NULL),('2025-11-29 05:37:21.025862',NULL,'2025-11-29 05:37:21.127454',379,379,'4522755852d94dd7bbf637007ec21bf0','826a9694-385e-4334-9b0d-2ba27a9dac55',122,'ecd2e5916bab4f7cb242a87ec782ffda','snapshot_gigabytes',1,'2025-11-30 05:37:20',NULL),('2025-11-29 05:37:21.037773',NULL,'2025-11-29 05:37:21.127454',380,380,NULL,'dc6be766-e361-4db6-86e1-c157a9cdc3f8',123,'ecd2e5916bab4f7cb242a87ec782ffda','snapshots',1,'2025-11-30 05:37:20','3cde5f7b-914b-4874-be2f-d7385fe4a149'),('2025-11-29 05:37:21.039175',NULL,'2025-11-29 05:37:21.127454',381,381,NULL,'cf1b09ab-0f37-4005-96b3-6eacf18c5c6b',124,'ecd2e5916bab4f7cb242a87ec782ffda','snapshot_gigabytes',1,'2025-11-30 05:37:20','3cde5f7b-914b-4874-be2f-d7385fe4a149'),('2025-11-29 05:37:21.476413',NULL,'2025-11-29 05:37:21.562211',382,382,'d77f33e5f83b46d0a66fd3d5f2a35ad0','4ee6e2d6-b5ce-4602-8c5e-31967b2da377',125,'18a45827d98a489a902f5dbcfb422b2d','share_networks',1,'2025-11-30 05:37:21',NULL),('2025-11-29 05:37:21.733823',NULL,'2025-11-29 05:37:21.781817',383,383,'d77f33e5f83b46d0a66fd3d5f2a35ad0','378df8e4-3ab7-483d-889e-b3dd4d302573',125,'18a45827d98a489a902f5dbcfb422b2d','share_networks',1,'2025-11-30 05:37:21',NULL),('2025-11-29 05:37:22.210219',NULL,'2025-11-29 05:37:22.295477',384,384,'4522755852d94dd7bbf637007ec21bf0','7cf32a9e-fcab-42e1-9511-00d8b6345f04',121,'ecd2e5916bab4f7cb242a87ec782ffda','snapshots',1,'2025-11-30 05:37:22',NULL),('2025-11-29 05:37:22.211459',NULL,'2025-11-29 05:37:22.295477',385,385,'4522755852d94dd7bbf637007ec21bf0','05ec5bbb-32d6-4135-b3fe-1ae0b2761f29',122,'ecd2e5916bab4f7cb242a87ec782ffda','snapshot_gigabytes',1,'2025-11-30 05:37:22',NULL),('2025-11-29 05:37:22.221030',NULL,'2025-11-29 05:37:22.295477',386,386,NULL,'5ab45a4c-2d40-4afb-942e-0a1ef7600b85',123,'ecd2e5916bab4f7cb242a87ec782ffda','snapshots',1,'2025-11-30 05:37:22','3cde5f7b-914b-4874-be2f-d7385fe4a149'),('2025-11-29 05:37:22.224253',NULL,'2025-11-29 05:37:22.295477',387,387,NULL,'3795c011-e29a-4cd0-9d67-519ca90324b0',124,'ecd2e5916bab4f7cb242a87ec782ffda','snapshot_gigabytes',1,'2025-11-30 05:37:22','3cde5f7b-914b-4874-be2f-d7385fe4a149'),('2025-11-29 05:37:22.748623',NULL,'2025-11-29 05:37:22.759684',388,388,'d77f33e5f83b46d0a66fd3d5f2a35ad0','cf1529bb-68f4-4657-9a56-da2df84356f5',125,'18a45827d98a489a902f5dbcfb422b2d','share_networks',-1,'2025-11-30 05:37:22',NULL),('2025-11-29 05:37:23.023720',NULL,'2025-11-29 05:37:23.062675',389,389,'d77f33e5f83b46d0a66fd3d5f2a35ad0','e785c6dc-d7c2-4e63-b042-dc6d5bdbaeec',125,'18a45827d98a489a902f5dbcfb422b2d','share_networks',1,'2025-11-30 05:37:22',NULL),('2025-11-29 05:37:24.219455',NULL,'2025-11-29 05:37:24.224874',390,390,'d77f33e5f83b46d0a66fd3d5f2a35ad0','80adb732-b8a2-464b-b2f5-9ce8995822a8',125,'18a45827d98a489a902f5dbcfb422b2d','share_networks',-1,'2025-11-30 05:37:24',NULL),('2025-11-29 05:37:27.069133',NULL,'2025-11-29 05:37:27.092191',391,391,'4522755852d94dd7bbf637007ec21bf0','3a14eb8f-826e-4d48-a95f-b41fc6fe8c43',121,'ecd2e5916bab4f7cb242a87ec782ffda','snapshots',-1,'2025-11-30 05:37:27',NULL),('2025-11-29 05:37:27.070100',NULL,'2025-11-29 05:37:27.092191',392,392,'4522755852d94dd7bbf637007ec21bf0','0b291362-5ba5-4677-93ad-f9dbe03051dc',122,'ecd2e5916bab4f7cb242a87ec782ffda','snapshot_gigabytes',-1,'2025-11-30 05:37:27',NULL),('2025-11-29 05:37:27.078111',NULL,'2025-11-29 05:37:27.092191',393,393,NULL,'5adf4a17-06ed-4081-87cc-d2fb51866c03',123,'ecd2e5916bab4f7cb242a87ec782ffda','snapshots',-1,'2025-11-30 05:37:27','3cde5f7b-914b-4874-be2f-d7385fe4a149'),('2025-11-29 05:37:27.079109',NULL,'2025-11-29 05:37:27.092191',394,394,NULL,'e0a2ad7d-d046-4d44-9a9e-26fcec251962',124,'ecd2e5916bab4f7cb242a87ec782ffda','snapshot_gigabytes',-1,'2025-11-30 05:37:27','3cde5f7b-914b-4874-be2f-d7385fe4a149'),('2025-11-29 05:37:30.780376',NULL,'2025-11-29 05:37:30.846109',395,395,'4522755852d94dd7bbf637007ec21bf0','325da8f5-876e-4464-b6c3-878d134624cb',121,'ecd2e5916bab4f7cb242a87ec782ffda','snapshots',-1,'2025-11-30 05:37:30',NULL),('2025-11-29 05:37:30.781162',NULL,'2025-11-29 05:37:30.846109',396,396,'4522755852d94dd7bbf637007ec21bf0','b49f2d22-7463-496d-80b5-b118b89c7e21',122,'ecd2e5916bab4f7cb242a87ec782ffda','snapshot_gigabytes',-1,'2025-11-30 05:37:30',NULL),('2025-11-29 05:37:30.809815',NULL,'2025-11-29 05:37:30.846109',397,397,NULL,'caed773a-5447-4c30-be8a-65979cf25561',123,'ecd2e5916bab4f7cb242a87ec782ffda','snapshots',-1,'2025-11-30 05:37:30','3cde5f7b-914b-4874-be2f-d7385fe4a149'),('2025-11-29 05:37:30.810757',NULL,'2025-11-29 05:37:30.846109',398,398,NULL,'7a634c2e-60dc-4f0c-9c85-d95d830d15db',124,'ecd2e5916bab4f7cb242a87ec782ffda','snapshot_gigabytes',-1,'2025-11-30 05:37:30','3cde5f7b-914b-4874-be2f-d7385fe4a149'),('2025-11-29 05:37:34.097289',NULL,'2025-11-29 05:37:34.113589',399,399,'4522755852d94dd7bbf637007ec21bf0','0cc5082f-4654-4389-a5ad-dc7f0020f5d4',113,'ecd2e5916bab4f7cb242a87ec782ffda','shares',-1,'2025-11-30 05:37:34',NULL),('2025-11-29 05:37:34.099332',NULL,'2025-11-29 05:37:34.113589',400,400,'4522755852d94dd7bbf637007ec21bf0','e022cf31-6d99-45d3-8a70-08564a354e41',114,'ecd2e5916bab4f7cb242a87ec782ffda','gigabytes',-1,'2025-11-30 05:37:34',NULL),('2025-11-29 05:37:34.104952',NULL,'2025-11-29 05:37:34.113589',401,401,NULL,'e129c158-7594-4fa9-9ee2-86da4395ccf6',115,'ecd2e5916bab4f7cb242a87ec782ffda','shares',-1,'2025-11-30 05:37:34','3cde5f7b-914b-4874-be2f-d7385fe4a149'),('2025-11-29 05:37:34.105535',NULL,'2025-11-29 05:37:34.113589',402,402,NULL,'7f91f0d8-ba32-40bb-8d1f-13011c1395cc',116,'ecd2e5916bab4f7cb242a87ec782ffda','gigabytes',-1,'2025-11-30 05:37:34','3cde5f7b-914b-4874-be2f-d7385fe4a149'),('2025-11-29 05:37:35.665094',NULL,'2025-11-29 05:37:35.710270',403,403,'ae0d2a4b8f3d478e8235b9dbe2b26c6b','efa3dfbc-7d80-4835-836c-6791ec794468',127,'f6fcbad6247d48c28eb3ae887b3704b3','shares',1,'2025-11-30 05:37:35',NULL),('2025-11-29 05:37:35.666519',NULL,'2025-11-29 05:37:35.710270',404,404,'ae0d2a4b8f3d478e8235b9dbe2b26c6b','087d6ca1-3e09-4c56-a314-43646655c1eb',126,'f6fcbad6247d48c28eb3ae887b3704b3','gigabytes',1,'2025-11-30 05:37:35',NULL),('2025-11-29 05:37:35.676015',NULL,'2025-11-29 05:37:35.710270',405,405,NULL,'1112ba5d-cca7-427d-b072-1add65b2cee1',129,'f6fcbad6247d48c28eb3ae887b3704b3','shares',1,'2025-11-30 05:37:35','15c7aea3-577a-4acc-8a07-1d147dd95e25'),('2025-11-29 05:37:35.677022',NULL,'2025-11-29 05:37:35.710270',406,406,NULL,'9a701316-64ab-457d-8190-a16318d7bb86',128,'f6fcbad6247d48c28eb3ae887b3704b3','gigabytes',1,'2025-11-30 05:37:35','15c7aea3-577a-4acc-8a07-1d147dd95e25'),('2025-11-29 05:37:39.494966',NULL,'2025-11-29 05:37:39.653982',407,407,'5420544d13be4310a8a32043f9b7ab4d','a866232c-bf1c-405f-855f-fb2a97f9ce5b',131,'88ea41f1eaaf4ed9b8f5335cd407f038','shares',1,'2025-11-30 05:37:39',NULL),('2025-11-29 05:37:39.497974',NULL,'2025-11-29 05:37:39.653982',408,408,'5420544d13be4310a8a32043f9b7ab4d','94010ce1-3ffd-4fc7-8dc7-09216f7f86cd',130,'88ea41f1eaaf4ed9b8f5335cd407f038','gigabytes',1,'2025-11-30 05:37:39',NULL),('2025-11-29 05:37:39.533150',NULL,'2025-11-29 05:37:39.662593',409,409,'5420544d13be4310a8a32043f9b7ab4d','dad6a056-345a-4609-bd4d-346e38601ed0',133,'f6fcbad6247d48c28eb3ae887b3704b3','shares',-1,'2025-11-30 05:37:39',NULL),('2025-11-29 05:37:39.534107',NULL,'2025-11-29 05:37:39.662593',410,410,'5420544d13be4310a8a32043f9b7ab4d','07700e9b-0bac-4a7d-b35e-99241b17ed20',132,'f6fcbad6247d48c28eb3ae887b3704b3','gigabytes',-1,'2025-11-30 05:37:39',NULL),('2025-11-29 05:37:40.429316',NULL,'2025-11-29 05:37:40.453714',411,411,'5420544d13be4310a8a32043f9b7ab4d','bb9844c4-6c1e-4803-9d86-cbef68582dfd',131,'88ea41f1eaaf4ed9b8f5335cd407f038','shares',-1,'2025-11-30 05:37:40',NULL),('2025-11-29 05:37:40.430314',NULL,'2025-11-29 05:37:40.453714',412,412,'5420544d13be4310a8a32043f9b7ab4d','bcc18fe8-eae2-406c-ad9c-10efe2d7ea81',130,'88ea41f1eaaf4ed9b8f5335cd407f038','gigabytes',-1,'2025-11-30 05:37:40',NULL),('2025-11-29 05:37:40.444941',NULL,'2025-11-29 05:37:40.453714',413,413,NULL,'f091b897-fd6d-474e-90a2-18df73bf6595',135,'88ea41f1eaaf4ed9b8f5335cd407f038','shares',-1,'2025-11-30 05:37:40','15c7aea3-577a-4acc-8a07-1d147dd95e25'),('2025-11-29 05:37:40.445732',NULL,'2025-11-29 05:37:40.453714',414,414,NULL,'7a09d7b3-0fc5-48c4-ad1b-73d34e505f3f',134,'88ea41f1eaaf4ed9b8f5335cd407f038','gigabytes',-1,'2025-11-30 05:37:40','15c7aea3-577a-4acc-8a07-1d147dd95e25'),('2025-11-29 05:37:43.661872',NULL,'2025-11-29 05:37:43.717369',415,415,'ae0d2a4b8f3d478e8235b9dbe2b26c6b','f74c6c74-25d4-4f11-922a-bd65794d9a76',127,'f6fcbad6247d48c28eb3ae887b3704b3','shares',1,'2025-11-30 05:37:43',NULL),('2025-11-29 05:37:43.664473',NULL,'2025-11-29 05:37:43.717369',416,416,'ae0d2a4b8f3d478e8235b9dbe2b26c6b','260e6cb1-fa63-4c93-9802-d1f5f0d01b82',126,'f6fcbad6247d48c28eb3ae887b3704b3','gigabytes',1,'2025-11-30 05:37:43',NULL),('2025-11-29 05:37:43.683739',NULL,'2025-11-29 05:37:43.717369',417,417,NULL,'b9ff10e6-3aed-4286-a8bb-b0d800aac566',129,'f6fcbad6247d48c28eb3ae887b3704b3','shares',1,'2025-11-30 05:37:43','15c7aea3-577a-4acc-8a07-1d147dd95e25'),('2025-11-29 05:37:43.685813',NULL,'2025-11-29 05:37:43.717369',418,418,NULL,'19136812-35d4-4480-aea9-f0115ec31a5d',128,'f6fcbad6247d48c28eb3ae887b3704b3','gigabytes',1,'2025-11-30 05:37:43','15c7aea3-577a-4acc-8a07-1d147dd95e25'),('2025-11-29 05:37:48.412372',NULL,'2025-11-29 05:37:48.451924',419,419,'3e0f252f8cc84922a46c637bf75d9b12','0277c266-02c3-46f8-aadf-178c93109514',136,'bf7ea2709c674f5da87071b7a3ab3ac1','shares',1,'2025-11-30 05:37:48',NULL),('2025-11-29 05:37:48.413497',NULL,'2025-11-29 05:37:48.451924',420,420,'3e0f252f8cc84922a46c637bf75d9b12','7629020e-d4bc-4978-8e64-c4680e2214e9',137,'bf7ea2709c674f5da87071b7a3ab3ac1','gigabytes',1,'2025-11-30 05:37:48',NULL),('2025-11-29 05:37:48.423575',NULL,'2025-11-29 05:37:48.451924',421,421,NULL,'5d23c215-4ff7-4ca2-ac4b-bd9eb42ffb17',138,'bf7ea2709c674f5da87071b7a3ab3ac1','shares',1,'2025-11-30 05:37:48','1d21dac2-ed08-46ff-8c64-215bda949560'),('2025-11-29 05:37:48.424903',NULL,'2025-11-29 05:37:48.451924',422,422,NULL,'c000240b-b58c-4b38-a2d3-6ad1a837ae03',139,'bf7ea2709c674f5da87071b7a3ab3ac1','gigabytes',1,'2025-11-30 05:37:48','1d21dac2-ed08-46ff-8c64-215bda949560'),('2025-11-29 05:37:49.156683',NULL,'2025-11-29 05:37:49.171027',423,423,'ae0d2a4b8f3d478e8235b9dbe2b26c6b','42338daf-c8b0-4999-9f42-802c55893a96',127,'f6fcbad6247d48c28eb3ae887b3704b3','shares',-1,'2025-11-30 05:37:49',NULL),('2025-11-29 05:37:49.157576',NULL,'2025-11-29 05:37:49.171027',424,424,'ae0d2a4b8f3d478e8235b9dbe2b26c6b','8011c5a1-94e5-4bba-a760-e433a0c1cd31',126,'f6fcbad6247d48c28eb3ae887b3704b3','gigabytes',-1,'2025-11-30 05:37:49',NULL),('2025-11-29 05:37:49.163262',NULL,'2025-11-29 05:37:49.171027',425,425,NULL,'e1693c43-2383-48ac-a1a5-5d07b6f5e600',129,'f6fcbad6247d48c28eb3ae887b3704b3','shares',-1,'2025-11-30 05:37:49','15c7aea3-577a-4acc-8a07-1d147dd95e25'),('2025-11-29 05:37:49.163952',NULL,'2025-11-29 05:37:49.171027',426,426,NULL,'f3fa1de4-67a8-49b3-8a91-ad3ac641c6d4',128,'f6fcbad6247d48c28eb3ae887b3704b3','gigabytes',-1,'2025-11-30 05:37:49','15c7aea3-577a-4acc-8a07-1d147dd95e25'),('2025-11-29 05:37:52.227704',NULL,'2025-11-29 05:37:52.248102',427,427,'3e0f252f8cc84922a46c637bf75d9b12','8275a69c-a3ef-4395-a4d7-5f7b2b3a9c86',136,'bf7ea2709c674f5da87071b7a3ab3ac1','shares',-1,'2025-11-30 05:37:52',NULL),('2025-11-29 05:37:52.228777',NULL,'2025-11-29 05:37:52.248102',428,428,'3e0f252f8cc84922a46c637bf75d9b12','a1a38226-cca4-45e3-9f82-e20a2db4c30e',137,'bf7ea2709c674f5da87071b7a3ab3ac1','gigabytes',-1,'2025-11-30 05:37:52',NULL),('2025-11-29 05:37:52.235773',NULL,'2025-11-29 05:37:52.248102',429,429,NULL,'fa6ae3a7-8b45-41bf-854c-f5cb42d24f01',138,'bf7ea2709c674f5da87071b7a3ab3ac1','shares',-1,'2025-11-30 05:37:52','1d21dac2-ed08-46ff-8c64-215bda949560'),('2025-11-29 05:37:52.236931',NULL,'2025-11-29 05:37:52.248102',430,430,NULL,'0816977f-8d07-48c8-901c-5f6aea0b930c',139,'bf7ea2709c674f5da87071b7a3ab3ac1','gigabytes',-1,'2025-11-30 05:37:52','1d21dac2-ed08-46ff-8c64-215bda949560'),('2025-11-29 05:37:52.509462',NULL,'2025-11-29 05:37:52.544977',431,431,'3e0f252f8cc84922a46c637bf75d9b12','86104dc6-2d8d-41de-9b6b-bd49c20e1fa0',136,'bf7ea2709c674f5da87071b7a3ab3ac1','shares',1,'2025-11-30 05:37:52',NULL),('2025-11-29 05:37:52.510968',NULL,'2025-11-29 05:37:52.544977',432,432,'3e0f252f8cc84922a46c637bf75d9b12','cd916e93-92d2-4982-bd1e-384028b538bc',137,'bf7ea2709c674f5da87071b7a3ab3ac1','gigabytes',1,'2025-11-30 05:37:52',NULL),('2025-11-29 05:37:52.521640',NULL,'2025-11-29 05:37:52.544977',433,433,NULL,'967f5f8c-88c3-465d-a28d-4405f8744b9f',141,'bf7ea2709c674f5da87071b7a3ab3ac1','shares',1,'2025-11-30 05:37:52','407c3566-cec9-4eac-baeb-e009fd1528f3'),('2025-11-29 05:37:52.522962',NULL,'2025-11-29 05:37:52.544977',434,434,NULL,'11378d0e-8c13-40eb-9bdd-bc499c794573',140,'bf7ea2709c674f5da87071b7a3ab3ac1','gigabytes',1,'2025-11-30 05:37:52','407c3566-cec9-4eac-baeb-e009fd1528f3'),('2025-11-29 05:37:55.107174',NULL,'2025-11-29 05:37:55.137454',435,435,'6de51f96bd584575956b19290f27af8f','a89add9f-0d52-48ea-9903-8470226dc197',143,'e577c04bfe1b459f9aebd0f826827833','shares',1,'2025-11-30 05:37:55',NULL),('2025-11-29 05:37:55.108312',NULL,'2025-11-29 05:37:55.137454',436,436,'6de51f96bd584575956b19290f27af8f','8a88854c-70e1-4b94-8677-4c4169c3b0f8',142,'e577c04bfe1b459f9aebd0f826827833','gigabytes',1,'2025-11-30 05:37:55',NULL),('2025-11-29 05:37:55.118125',NULL,'2025-11-29 05:37:55.137454',437,437,NULL,'8af16d27-f19d-4f90-8dbc-dec690d7afb9',145,'e577c04bfe1b459f9aebd0f826827833','shares',1,'2025-11-30 05:37:55','9d07efed-6109-49c2-afdb-237feef528bc'),('2025-11-29 05:37:55.119284',NULL,'2025-11-29 05:37:55.137454',438,438,NULL,'63ddcedc-20ac-426b-8a03-1357ead8600e',144,'e577c04bfe1b459f9aebd0f826827833','gigabytes',1,'2025-11-30 05:37:55','9d07efed-6109-49c2-afdb-237feef528bc'),('2025-11-29 05:37:56.509775',NULL,'2025-11-29 05:37:56.528011',439,439,'3e0f252f8cc84922a46c637bf75d9b12','77882488-0d13-4fcc-9aa8-4b3cc4c49e52',136,'bf7ea2709c674f5da87071b7a3ab3ac1','shares',-1,'2025-11-30 05:37:56',NULL),('2025-11-29 05:37:56.510567',NULL,'2025-11-29 05:37:56.528011',440,440,'3e0f252f8cc84922a46c637bf75d9b12','ee0e64f7-1fe5-4c43-884c-9cb33947bb62',137,'bf7ea2709c674f5da87071b7a3ab3ac1','gigabytes',-1,'2025-11-30 05:37:56',NULL),('2025-11-29 05:37:56.518910',NULL,'2025-11-29 05:37:56.528011',441,441,NULL,'b7307937-069e-4632-b9b5-a13cb63da604',141,'bf7ea2709c674f5da87071b7a3ab3ac1','shares',-1,'2025-11-30 05:37:56','407c3566-cec9-4eac-baeb-e009fd1528f3'),('2025-11-29 05:37:56.520328',NULL,'2025-11-29 05:37:56.528011',442,442,NULL,'32ab0df0-0cc6-48c6-8712-b4663a74ae7c',140,'bf7ea2709c674f5da87071b7a3ab3ac1','gigabytes',-1,'2025-11-30 05:37:56','407c3566-cec9-4eac-baeb-e009fd1528f3'),('2025-11-29 05:37:56.756063',NULL,'2025-11-29 05:37:56.784871',443,443,'3e0f252f8cc84922a46c637bf75d9b12','ce86c712-c9a2-46f1-912a-3bd09393bd4c',136,'bf7ea2709c674f5da87071b7a3ab3ac1','shares',1,'2025-11-30 05:37:56',NULL),('2025-11-29 05:37:56.757256',NULL,'2025-11-29 05:37:56.784871',444,444,'3e0f252f8cc84922a46c637bf75d9b12','6c124a0b-e5d9-4c22-928e-b22639ade11c',137,'bf7ea2709c674f5da87071b7a3ab3ac1','gigabytes',1,'2025-11-30 05:37:56',NULL),('2025-11-29 05:37:56.766299',NULL,'2025-11-29 05:37:56.784871',445,445,NULL,'e3a2b032-0fa5-4337-98c9-0d1212e105b5',147,'bf7ea2709c674f5da87071b7a3ab3ac1','shares',1,'2025-11-30 05:37:56','3e7b666b-a9bd-4c69-8060-6813139fdc67'),('2025-11-29 05:37:56.767467',NULL,'2025-11-29 05:37:56.784871',446,446,NULL,'ab943271-288c-4232-8e2b-7b20d7dbc452',146,'bf7ea2709c674f5da87071b7a3ab3ac1','gigabytes',1,'2025-11-30 05:37:56','3e7b666b-a9bd-4c69-8060-6813139fdc67'),('2025-11-29 05:38:00.701587',NULL,'2025-11-29 05:38:00.715902',447,447,'3e0f252f8cc84922a46c637bf75d9b12','3cbb5de7-4508-4fdb-b817-82e096b16e13',136,'bf7ea2709c674f5da87071b7a3ab3ac1','shares',-1,'2025-11-30 05:38:00',NULL),('2025-11-29 05:38:00.702392',NULL,'2025-11-29 05:38:00.715902',448,448,'3e0f252f8cc84922a46c637bf75d9b12','4917d247-150a-46c6-9a05-9e31664b1d43',137,'bf7ea2709c674f5da87071b7a3ab3ac1','gigabytes',-1,'2025-11-30 05:38:00',NULL),('2025-11-29 05:38:00.707936',NULL,'2025-11-29 05:38:00.715902',449,449,NULL,'2686a0a6-5514-40fa-89e2-42199b55989b',147,'bf7ea2709c674f5da87071b7a3ab3ac1','shares',-1,'2025-11-30 05:38:00','3e7b666b-a9bd-4c69-8060-6813139fdc67'),('2025-11-29 05:38:00.708631',NULL,'2025-11-29 05:38:00.715902',450,450,NULL,'ac765047-2493-4389-ae99-c1a6773ee1ce',146,'bf7ea2709c674f5da87071b7a3ab3ac1','gigabytes',-1,'2025-11-30 05:38:00','3e7b666b-a9bd-4c69-8060-6813139fdc67'),('2025-11-29 05:38:00.954398',NULL,'2025-11-29 05:38:00.989898',451,451,'3e0f252f8cc84922a46c637bf75d9b12','2a30d323-fa45-4637-8ded-476534cfe9ca',136,'bf7ea2709c674f5da87071b7a3ab3ac1','shares',1,'2025-11-30 05:38:00',NULL),('2025-11-29 05:38:00.956217',NULL,'2025-11-29 05:38:00.989898',452,452,'3e0f252f8cc84922a46c637bf75d9b12','c4879bd7-0dd1-4899-bcab-c302499d4945',137,'bf7ea2709c674f5da87071b7a3ab3ac1','gigabytes',1,'2025-11-30 05:38:00',NULL),('2025-11-29 05:38:00.969167',NULL,'2025-11-29 05:38:00.989898',453,453,NULL,'2d47f567-9911-4ec7-ac8a-3764405dca6c',149,'bf7ea2709c674f5da87071b7a3ab3ac1','shares',1,'2025-11-30 05:38:00','bfcc714f-2a94-4cb0-9045-624924898779'),('2025-11-29 05:38:00.970922',NULL,'2025-11-29 05:38:00.989898',454,454,NULL,'be9341e5-3591-4df7-9339-22029d040728',148,'bf7ea2709c674f5da87071b7a3ab3ac1','gigabytes',1,'2025-11-30 05:38:00','bfcc714f-2a94-4cb0-9045-624924898779'),('2025-11-29 05:38:04.683818',NULL,'2025-11-29 05:38:04.702355',455,455,'3e0f252f8cc84922a46c637bf75d9b12','f8d2a438-a302-4076-ac4f-bb4be66b1b56',136,'bf7ea2709c674f5da87071b7a3ab3ac1','shares',-1,'2025-11-30 05:38:04',NULL),('2025-11-29 05:38:04.685317',NULL,'2025-11-29 05:38:04.702355',456,456,'3e0f252f8cc84922a46c637bf75d9b12','5ae2d2ed-b64e-40e4-bdd6-79b8e045a873',137,'bf7ea2709c674f5da87071b7a3ab3ac1','gigabytes',-1,'2025-11-30 05:38:04',NULL),('2025-11-29 05:38:04.692997',NULL,'2025-11-29 05:38:04.702355',457,457,NULL,'68232082-fbe8-4a87-8851-3e7cacf815d2',149,'bf7ea2709c674f5da87071b7a3ab3ac1','shares',-1,'2025-11-30 05:38:04','bfcc714f-2a94-4cb0-9045-624924898779'),('2025-11-29 05:38:04.693828',NULL,'2025-11-29 05:38:04.702355',458,458,NULL,'ee4f28fb-f839-45e2-805e-44a5b5235908',148,'bf7ea2709c674f5da87071b7a3ab3ac1','gigabytes',-1,'2025-11-30 05:38:04','bfcc714f-2a94-4cb0-9045-624924898779'),('2025-11-29 05:38:04.943717',NULL,'2025-11-29 05:38:04.976433',459,459,'3e0f252f8cc84922a46c637bf75d9b12','e3896937-dc8a-40fa-82d1-fe55b068d237',136,'bf7ea2709c674f5da87071b7a3ab3ac1','shares',1,'2025-11-30 05:38:04',NULL),('2025-11-29 05:38:04.946398',NULL,'2025-11-29 05:38:04.976433',460,460,'3e0f252f8cc84922a46c637bf75d9b12','6083dd98-5f6a-424b-8b6e-9687f6f3d23d',137,'bf7ea2709c674f5da87071b7a3ab3ac1','gigabytes',1,'2025-11-30 05:38:04',NULL),('2025-11-29 05:38:04.957673',NULL,'2025-11-29 05:38:04.976433',461,461,NULL,'8a9e2182-0044-4d68-bfef-5c8fe2c43c7e',151,'bf7ea2709c674f5da87071b7a3ab3ac1','shares',1,'2025-11-30 05:38:04','3b823b97-f6b7-4e10-a49b-8c78cf594d17'),('2025-11-29 05:38:04.958702',NULL,'2025-11-29 05:38:04.976433',462,462,NULL,'a89cc223-7742-45b7-b415-cdaaf1460b8b',150,'bf7ea2709c674f5da87071b7a3ab3ac1','gigabytes',1,'2025-11-30 05:38:04','3b823b97-f6b7-4e10-a49b-8c78cf594d17'),('2025-11-29 05:38:06.772894',NULL,'2025-11-29 05:38:06.799949',463,463,'40461bcceb79486685576e03cd6143f7','c3ebd562-6f8b-4ffc-8c4a-167c785d7901',153,'bde0f89de7a5405e8d086a6415adbc5c','shares',1,'2025-11-30 05:38:06',NULL),('2025-11-29 05:38:06.773930',NULL,'2025-11-29 05:38:06.799949',464,464,'40461bcceb79486685576e03cd6143f7','b876c52a-95c8-4da1-b2a8-aadc75498380',152,'bde0f89de7a5405e8d086a6415adbc5c','gigabytes',1,'2025-11-30 05:38:06',NULL),('2025-11-29 05:38:06.782391',NULL,'2025-11-29 05:38:06.799949',465,465,NULL,'1862e296-e4aa-4c1b-9508-38369560298e',155,'bde0f89de7a5405e8d086a6415adbc5c','shares',1,'2025-11-30 05:38:06','7c6b9483-7c46-438e-a204-efa953929f7b'),('2025-11-29 05:38:06.783378',NULL,'2025-11-29 05:38:06.799949',466,466,NULL,'e9bcdb09-8912-441d-9aaa-c4b7a0198867',154,'bde0f89de7a5405e8d086a6415adbc5c','gigabytes',1,'2025-11-30 05:38:06','7c6b9483-7c46-438e-a204-efa953929f7b'),('2025-11-29 05:38:08.614975',NULL,'2025-11-29 05:38:08.650855',467,467,'3e0f252f8cc84922a46c637bf75d9b12','d5f9a9f1-a830-422b-9c18-9f64e0b836d7',136,'bf7ea2709c674f5da87071b7a3ab3ac1','shares',-1,'2025-11-30 05:38:08',NULL),('2025-11-29 05:38:08.616777',NULL,'2025-11-29 05:38:08.650855',468,468,'3e0f252f8cc84922a46c637bf75d9b12','5a245ff1-140d-4442-b82e-3c582e096b7b',137,'bf7ea2709c674f5da87071b7a3ab3ac1','gigabytes',-1,'2025-11-30 05:38:08',NULL),('2025-11-29 05:38:08.634146',NULL,'2025-11-29 05:38:08.650855',469,469,NULL,'cd15c798-3c34-4b52-bba1-980ef20f3305',151,'bf7ea2709c674f5da87071b7a3ab3ac1','shares',-1,'2025-11-30 05:38:08','3b823b97-f6b7-4e10-a49b-8c78cf594d17'),('2025-11-29 05:38:08.635449',NULL,'2025-11-29 05:38:08.650855',470,470,NULL,'c3c8e729-3e8f-4994-b266-785c55aa101e',150,'bf7ea2709c674f5da87071b7a3ab3ac1','gigabytes',-1,'2025-11-30 05:38:08','3b823b97-f6b7-4e10-a49b-8c78cf594d17'),('2025-11-29 05:38:10.421001',NULL,'2025-11-29 05:38:10.711712',471,471,'40461bcceb79486685576e03cd6143f7','a704d391-e6dc-4600-8ed4-1b70d39cddbf',153,'bde0f89de7a5405e8d086a6415adbc5c','shares',1,'2025-11-30 05:38:10',NULL),('2025-11-29 05:38:10.422171',NULL,'2025-11-29 05:38:10.711712',472,472,'40461bcceb79486685576e03cd6143f7','86d3393b-73a6-4113-8205-d094a35df05a',152,'bde0f89de7a5405e8d086a6415adbc5c','gigabytes',1,'2025-11-30 05:38:10',NULL),('2025-11-29 05:38:10.503403',NULL,'2025-11-29 05:38:10.711712',473,473,NULL,'89f55802-261b-44a5-9174-004d6790bd55',155,'bde0f89de7a5405e8d086a6415adbc5c','shares',1,'2025-11-30 05:38:10','7c6b9483-7c46-438e-a204-efa953929f7b'),('2025-11-29 05:38:10.504848',NULL,'2025-11-29 05:38:10.711712',474,474,NULL,'1564711b-01f5-435f-b2e6-d59228ed8f71',154,'bde0f89de7a5405e8d086a6415adbc5c','gigabytes',1,'2025-11-30 05:38:10','7c6b9483-7c46-438e-a204-efa953929f7b'),('2025-11-29 05:38:14.743582',NULL,'2025-11-29 05:38:14.758661',475,475,'40461bcceb79486685576e03cd6143f7','2dd45b83-47c4-4d65-8d3e-37dde4dcc12f',153,'bde0f89de7a5405e8d086a6415adbc5c','shares',-1,'2025-11-30 05:38:14',NULL),('2025-11-29 05:38:14.744428',NULL,'2025-11-29 05:38:14.758661',476,476,'40461bcceb79486685576e03cd6143f7','8c092be2-4bad-425a-8dfe-fc09f8f41563',152,'bde0f89de7a5405e8d086a6415adbc5c','gigabytes',-1,'2025-11-30 05:38:14',NULL),('2025-11-29 05:38:14.749554',NULL,'2025-11-29 05:38:14.758661',477,477,NULL,'9647706f-daed-4f99-b1e9-b73309802636',155,'bde0f89de7a5405e8d086a6415adbc5c','shares',-1,'2025-11-30 05:38:14','7c6b9483-7c46-438e-a204-efa953929f7b'),('2025-11-29 05:38:14.750344',NULL,'2025-11-29 05:38:14.758661',478,478,NULL,'19f5f0dd-dee3-4281-bde8-a56316840f7a',154,'bde0f89de7a5405e8d086a6415adbc5c','gigabytes',-1,'2025-11-30 05:38:14','7c6b9483-7c46-438e-a204-efa953929f7b'),('2025-11-29 05:38:18.434979',NULL,'2025-11-29 05:38:18.463230',479,479,'40461bcceb79486685576e03cd6143f7','1b62137d-499a-4801-8307-dddd09e1c6e0',153,'bde0f89de7a5405e8d086a6415adbc5c','shares',-1,'2025-11-30 05:38:18',NULL),('2025-11-29 05:38:18.436109',NULL,'2025-11-29 05:38:18.463230',480,480,'40461bcceb79486685576e03cd6143f7','b64ce8b3-2848-47a6-bc7d-af4353380694',152,'bde0f89de7a5405e8d086a6415adbc5c','gigabytes',-1,'2025-11-30 05:38:18',NULL),('2025-11-29 05:38:18.443561',NULL,'2025-11-29 05:38:18.463230',481,481,NULL,'a08a5b87-28ec-485c-b946-12ef7d966b86',155,'bde0f89de7a5405e8d086a6415adbc5c','shares',-1,'2025-11-30 05:38:18','7c6b9483-7c46-438e-a204-efa953929f7b'),('2025-11-29 05:38:18.444449',NULL,'2025-11-29 05:38:18.463230',482,482,NULL,'eae91641-9c80-47ad-a2c7-121d11498252',154,'bde0f89de7a5405e8d086a6415adbc5c','gigabytes',-1,'2025-11-30 05:38:18','7c6b9483-7c46-438e-a204-efa953929f7b'),('2025-11-29 05:38:18.825410',NULL,'2025-11-29 05:38:19.126350',483,483,'6de51f96bd584575956b19290f27af8f','4e2c5c87-08a5-4fce-9468-235bbb4dc5e6',143,'e577c04bfe1b459f9aebd0f826827833','shares',-1,'2025-11-30 05:38:18',NULL),('2025-11-29 05:38:18.826181',NULL,'2025-11-29 05:38:19.126350',484,484,'6de51f96bd584575956b19290f27af8f','f1f83f78-c51b-44f0-abfc-e993e38773bd',142,'e577c04bfe1b459f9aebd0f826827833','gigabytes',-1,'2025-11-30 05:38:18',NULL),('2025-11-29 05:38:19.006522',NULL,'2025-11-29 05:38:19.126350',485,485,NULL,'89138b1a-48b1-4eb4-97ea-dfb585aff98d',145,'e577c04bfe1b459f9aebd0f826827833','shares',-1,'2025-11-30 05:38:18','9d07efed-6109-49c2-afdb-237feef528bc'),('2025-11-29 05:38:19.008120',NULL,'2025-11-29 05:38:19.126350',486,486,NULL,'6df7478a-9ded-44ee-941a-39b04290b6eb',144,'e577c04bfe1b459f9aebd0f826827833','gigabytes',-1,'2025-11-30 05:38:18','9d07efed-6109-49c2-afdb-237feef528bc'),('2025-11-29 05:38:22.109096',NULL,'2025-11-29 05:38:22.135472',487,487,'40461bcceb79486685576e03cd6143f7','3beb20f6-0ee1-4955-a320-9a8e825c7af7',156,'bde0f89de7a5405e8d086a6415adbc5c','share_groups',1,'2025-11-30 05:38:22',NULL),('2025-11-29 05:38:26.130147',NULL,'2025-11-29 05:38:26.146163',488,488,'40461bcceb79486685576e03cd6143f7','e641aa54-b506-4bf9-bc3f-d9cf1fb6b52b',156,'bde0f89de7a5405e8d086a6415adbc5c','share_groups',-1,'2025-11-30 05:38:26',NULL),('2025-11-29 05:38:26.475537',NULL,'2025-11-29 05:38:26.532953',489,489,'40461bcceb79486685576e03cd6143f7','5677ff25-e5b4-4ac1-a0ba-cceec75041cb',156,'bde0f89de7a5405e8d086a6415adbc5c','share_groups',1,'2025-11-30 05:38:26',NULL),('2025-11-29 05:38:27.013225',NULL,'2025-11-29 05:38:27.048335',490,490,'40461bcceb79486685576e03cd6143f7','65303742-0f0a-49b2-adef-072442ed5686',156,'bde0f89de7a5405e8d086a6415adbc5c','share_groups',-1,'2025-11-30 05:38:26',NULL),('2025-11-29 05:38:27.396736',NULL,'2025-11-29 05:38:27.434056',491,491,'40461bcceb79486685576e03cd6143f7','f0a5544b-0982-40f4-b8a5-58e581fe8a8b',153,'bde0f89de7a5405e8d086a6415adbc5c','shares',1,'2025-11-30 05:38:27',NULL),('2025-11-29 05:38:27.397978',NULL,'2025-11-29 05:38:27.434056',492,492,'40461bcceb79486685576e03cd6143f7','683fd269-9523-4d82-9e6b-06ceebf5f3a4',152,'bde0f89de7a5405e8d086a6415adbc5c','gigabytes',1,'2025-11-30 05:38:27',NULL),('2025-11-29 05:38:27.403333',NULL,'2025-11-29 05:38:27.434056',493,493,NULL,'8fdb3267-576e-43e1-b339-6bc75f25f221',155,'bde0f89de7a5405e8d086a6415adbc5c','shares',1,'2025-11-30 05:38:27','7c6b9483-7c46-438e-a204-efa953929f7b'),('2025-11-29 05:38:27.404360',NULL,'2025-11-29 05:38:27.434056',494,494,NULL,'f8401e94-31df-4ba4-84c9-b664494e49ec',154,'bde0f89de7a5405e8d086a6415adbc5c','gigabytes',1,'2025-11-30 05:38:27','7c6b9483-7c46-438e-a204-efa953929f7b'),('2025-11-29 05:38:27.953594',NULL,'2025-11-29 05:38:27.999108',495,495,'9a169c12e24a428eb9de96579b83c947','0f5b574b-4da4-44f4-a6b0-09575a83b304',158,'0729e4f41a8346198e8cb057eba4c265','shares',1,'2025-11-30 05:38:27',NULL),('2025-11-29 05:38:27.954747',NULL,'2025-11-29 05:38:27.999108',496,496,'9a169c12e24a428eb9de96579b83c947','4c0af492-be29-4ae2-beb0-ab9f8f68d6d5',157,'0729e4f41a8346198e8cb057eba4c265','gigabytes',1,'2025-11-30 05:38:27',NULL),('2025-11-29 05:38:27.966537',NULL,'2025-11-29 05:38:27.999108',497,497,NULL,'dbb179ce-17b9-4278-a5ca-78e232392e81',160,'0729e4f41a8346198e8cb057eba4c265','shares',1,'2025-11-30 05:38:27','45b75960-3761-478e-bd9e-8a81899d6aa5'),('2025-11-29 05:38:27.968038',NULL,'2025-11-29 05:38:27.999108',498,498,NULL,'dc131af3-40de-46c7-93df-e535172549db',159,'0729e4f41a8346198e8cb057eba4c265','gigabytes',1,'2025-11-30 05:38:27','45b75960-3761-478e-bd9e-8a81899d6aa5'),('2025-11-29 05:38:31.553580',NULL,'2025-11-29 05:38:31.633846',499,499,'116774de87694898ba2a8d06c7ac7069','27a75494-e14f-4cd1-b90f-cf64aa7653ba',162,'352a7d8defe34a3486f41ba56e48d88e','shares',1,'2025-11-30 05:38:31',NULL),('2025-11-29 05:38:31.554686',NULL,'2025-11-29 05:38:31.633846',500,500,'116774de87694898ba2a8d06c7ac7069','02d3eed0-6ecb-4ad5-bfc9-2a78c0c2519d',161,'352a7d8defe34a3486f41ba56e48d88e','gigabytes',1,'2025-11-30 05:38:31',NULL),('2025-11-29 05:38:31.608703',NULL,'2025-11-29 05:38:31.633846',501,501,NULL,'9e67ca59-82bd-4cf8-ac21-9d484f575b5a',164,'352a7d8defe34a3486f41ba56e48d88e','shares',1,'2025-11-30 05:38:31','45b75960-3761-478e-bd9e-8a81899d6aa5'),('2025-11-29 05:38:31.610378',NULL,'2025-11-29 05:38:31.633846',502,502,NULL,'dbd5a44f-48e2-4f26-99b0-a5b51bfdb663',163,'352a7d8defe34a3486f41ba56e48d88e','gigabytes',1,'2025-11-30 05:38:31','45b75960-3761-478e-bd9e-8a81899d6aa5'),('2025-11-29 05:38:32.048469',NULL,'2025-11-29 05:38:32.298299',503,503,'32a388e3f3e241ffb7aa37e8bb62baba','39264ac5-99fe-44de-9a41-992e83808da2',166,'ae2a6e9fbea0426ebacf2fe56abb903e','shares',1,'2025-11-30 05:38:32',NULL),('2025-11-29 05:38:32.050149',NULL,'2025-11-29 05:38:32.298299',504,504,'32a388e3f3e241ffb7aa37e8bb62baba','99d6fd40-e846-4bbb-b724-7291f0bd2c9d',165,'ae2a6e9fbea0426ebacf2fe56abb903e','gigabytes',1,'2025-11-30 05:38:32',NULL),('2025-11-29 05:38:32.073360',NULL,'2025-11-29 05:38:32.414644',505,505,'40461bcceb79486685576e03cd6143f7','bc029aa3-2930-489c-a95d-ebf0aa0167d8',153,'bde0f89de7a5405e8d086a6415adbc5c','shares',-1,'2025-11-30 05:38:32',NULL),('2025-11-29 05:38:32.225058',NULL,'2025-11-29 05:38:32.414644',506,506,'40461bcceb79486685576e03cd6143f7','30a8dc50-c9d9-4009-b657-edd7bac40ccf',152,'bde0f89de7a5405e8d086a6415adbc5c','gigabytes',-1,'2025-11-30 05:38:32',NULL),('2025-11-29 05:38:32.241209',NULL,'2025-11-29 05:38:32.298299',507,507,NULL,'10a7c6ca-b87e-442e-9e96-620611852886',168,'ae2a6e9fbea0426ebacf2fe56abb903e','shares',1,'2025-11-30 05:38:32','52f50bf6-cbc7-4a08-9f56-cebb024fa773'),('2025-11-29 05:38:32.242638',NULL,'2025-11-29 05:38:32.298299',508,508,NULL,'843ac478-8688-4fa5-bf54-9d628b18efe7',167,'ae2a6e9fbea0426ebacf2fe56abb903e','gigabytes',1,'2025-11-30 05:38:32','52f50bf6-cbc7-4a08-9f56-cebb024fa773'),('2025-11-29 05:38:32.321444',NULL,'2025-11-29 05:38:32.414644',509,509,NULL,'cfe2eaaf-4a9d-463d-9d15-9927fefac1ff',155,'bde0f89de7a5405e8d086a6415adbc5c','shares',-1,'2025-11-30 05:38:32','7c6b9483-7c46-438e-a204-efa953929f7b'),('2025-11-29 05:38:32.324133',NULL,'2025-11-29 05:38:32.414644',510,510,NULL,'eb7d2436-6acc-40fb-8b99-cfac325886ee',154,'bde0f89de7a5405e8d086a6415adbc5c','gigabytes',-1,'2025-11-30 05:38:32','7c6b9483-7c46-438e-a204-efa953929f7b'),('2025-11-29 05:38:35.111260',NULL,'2025-11-29 05:38:35.223945',511,511,'40461bcceb79486685576e03cd6143f7','a3d0da84-b24c-4780-90c5-f4a1c6065ca6',153,'bde0f89de7a5405e8d086a6415adbc5c','shares',1,'2025-11-30 05:38:35',NULL),('2025-11-29 05:38:35.113213',NULL,'2025-11-29 05:38:35.223945',512,512,'40461bcceb79486685576e03cd6143f7','1408dfa4-78c7-4768-97c8-075646ecfa85',152,'bde0f89de7a5405e8d086a6415adbc5c','gigabytes',1,'2025-11-30 05:38:35',NULL),('2025-11-29 05:38:35.149649',NULL,'2025-11-29 05:38:35.223945',513,513,NULL,'9350889a-afb8-4df1-a62f-998b5e188329',155,'bde0f89de7a5405e8d086a6415adbc5c','shares',1,'2025-11-30 05:38:35','7c6b9483-7c46-438e-a204-efa953929f7b'),('2025-11-29 05:38:35.150926',NULL,'2025-11-29 05:38:35.223945',514,514,NULL,'b32ddb18-5bbf-41c6-b350-7afc9c496a71',154,'bde0f89de7a5405e8d086a6415adbc5c','gigabytes',1,'2025-11-30 05:38:35','7c6b9483-7c46-438e-a204-efa953929f7b'),('2025-11-29 05:38:36.647483',NULL,'2025-11-29 05:38:36.704582',515,515,'116774de87694898ba2a8d06c7ac7069','c65038b5-957b-4e7c-8a27-b35df835cfa7',162,'352a7d8defe34a3486f41ba56e48d88e','shares',-1,'2025-11-30 05:38:36',NULL),('2025-11-29 05:38:36.655899',NULL,'2025-11-29 05:38:36.704582',516,516,'116774de87694898ba2a8d06c7ac7069','b91a59f4-c653-4d15-ab40-b945d317d87e',161,'352a7d8defe34a3486f41ba56e48d88e','gigabytes',-1,'2025-11-30 05:38:36',NULL),('2025-11-29 05:38:36.680676',NULL,'2025-11-29 05:38:36.704582',517,517,NULL,'13a224a9-77f1-4f9f-bdaa-59b0416b96a9',164,'352a7d8defe34a3486f41ba56e48d88e','shares',-1,'2025-11-30 05:38:36','45b75960-3761-478e-bd9e-8a81899d6aa5'),('2025-11-29 05:38:36.685121',NULL,'2025-11-29 05:38:36.704582',518,518,NULL,'54788dbd-5c22-4c6d-ba42-58ba2308ea72',163,'352a7d8defe34a3486f41ba56e48d88e','gigabytes',-1,'2025-11-30 05:38:36','45b75960-3761-478e-bd9e-8a81899d6aa5'),('2025-11-29 05:38:37.955725',NULL,'2025-11-29 05:38:37.977678',519,519,'32a388e3f3e241ffb7aa37e8bb62baba','2314c179-d7b5-4b8e-9fac-97c1ad79a1af',166,'ae2a6e9fbea0426ebacf2fe56abb903e','shares',-1,'2025-11-30 05:38:37',NULL),('2025-11-29 05:38:37.957835',NULL,'2025-11-29 05:38:37.977678',520,520,'32a388e3f3e241ffb7aa37e8bb62baba','d1faa1e0-d51b-4b24-8053-ae3487ca0b6a',165,'ae2a6e9fbea0426ebacf2fe56abb903e','gigabytes',-1,'2025-11-30 05:38:37',NULL),('2025-11-29 05:38:37.965303',NULL,'2025-11-29 05:38:37.977678',521,521,NULL,'b069cb46-a5dc-412b-b14f-1c3655612a14',168,'ae2a6e9fbea0426ebacf2fe56abb903e','shares',-1,'2025-11-30 05:38:37','52f50bf6-cbc7-4a08-9f56-cebb024fa773'),('2025-11-29 05:38:37.966493',NULL,'2025-11-29 05:38:37.977678',522,522,NULL,'5c03a0db-df77-4f08-a93b-8f1307e63ffb',167,'ae2a6e9fbea0426ebacf2fe56abb903e','gigabytes',-1,'2025-11-30 05:38:37','52f50bf6-cbc7-4a08-9f56-cebb024fa773'),('2025-11-29 05:38:39.479712',NULL,'2025-11-29 05:38:39.558111',523,523,'9a169c12e24a428eb9de96579b83c947','bf972fe6-1377-454c-b486-f04d3bceb796',158,'0729e4f41a8346198e8cb057eba4c265','shares',-1,'2025-11-30 05:38:39',NULL),('2025-11-29 05:38:39.480654',NULL,'2025-11-29 05:38:39.558111',524,524,'9a169c12e24a428eb9de96579b83c947','4d8c1515-4f7a-45c3-81df-7f1a6b236e37',157,'0729e4f41a8346198e8cb057eba4c265','gigabytes',-1,'2025-11-30 05:38:39',NULL),('2025-11-29 05:38:39.541470',NULL,'2025-11-29 05:38:39.558111',525,525,NULL,'b28d8191-ee14-423a-8c32-478220932288',160,'0729e4f41a8346198e8cb057eba4c265','shares',-1,'2025-11-30 05:38:39','45b75960-3761-478e-bd9e-8a81899d6aa5'),('2025-11-29 05:38:39.543139',NULL,'2025-11-29 05:38:39.558111',526,526,NULL,'70c4ac06-42de-4b64-ac68-c2e00244f6c2',159,'0729e4f41a8346198e8cb057eba4c265','gigabytes',-1,'2025-11-30 05:38:39','45b75960-3761-478e-bd9e-8a81899d6aa5'),('2025-11-29 05:38:39.604891',NULL,'2025-11-29 05:38:39.623102',527,527,'40461bcceb79486685576e03cd6143f7','5035e41d-e8a2-4055-ac80-763ed30c72cf',153,'bde0f89de7a5405e8d086a6415adbc5c','shares',-1,'2025-11-30 05:38:39',NULL),('2025-11-29 05:38:39.605697',NULL,'2025-11-29 05:38:39.623102',528,528,'40461bcceb79486685576e03cd6143f7','92e219cb-6603-4939-9007-12af90c940b1',152,'bde0f89de7a5405e8d086a6415adbc5c','gigabytes',-1,'2025-11-30 05:38:39',NULL),('2025-11-29 05:38:39.614767',NULL,'2025-11-29 05:38:39.623102',529,529,NULL,'59c409ba-bff2-400a-8ed4-dc4706ea392d',155,'bde0f89de7a5405e8d086a6415adbc5c','shares',-1,'2025-11-30 05:38:39','7c6b9483-7c46-438e-a204-efa953929f7b'),('2025-11-29 05:38:39.615503',NULL,'2025-11-29 05:38:39.623102',530,530,NULL,'c52cfb76-326e-4a0d-b0f9-3e53a78bcf49',154,'bde0f89de7a5405e8d086a6415adbc5c','gigabytes',-1,'2025-11-30 05:38:39','7c6b9483-7c46-438e-a204-efa953929f7b'),('2025-11-29 05:38:42.688095',NULL,'2025-11-29 05:38:42.718060',531,531,'116774de87694898ba2a8d06c7ac7069','e7182ac2-e4f0-4f01-ab18-36ca6f55ec05',162,'352a7d8defe34a3486f41ba56e48d88e','shares',1,'2025-11-30 05:38:42',NULL),('2025-11-29 05:38:42.689280',NULL,'2025-11-29 05:38:42.718060',532,532,'116774de87694898ba2a8d06c7ac7069','e35f0d32-9914-43d6-84c2-115ca9e9a5c7',161,'352a7d8defe34a3486f41ba56e48d88e','gigabytes',1,'2025-11-30 05:38:42',NULL),('2025-11-29 05:38:42.697762',NULL,'2025-11-29 05:38:42.718060',533,533,NULL,'e104c4b8-45e8-4b12-a102-25906ce22f17',164,'352a7d8defe34a3486f41ba56e48d88e','shares',1,'2025-11-30 05:38:42','45b75960-3761-478e-bd9e-8a81899d6aa5'),('2025-11-29 05:38:42.698912',NULL,'2025-11-29 05:38:42.718060',534,534,NULL,'9ed39b2d-782f-429e-bb65-d4850865f66d',163,'352a7d8defe34a3486f41ba56e48d88e','gigabytes',1,'2025-11-30 05:38:42','45b75960-3761-478e-bd9e-8a81899d6aa5'),('2025-11-29 05:38:47.252534',NULL,'2025-11-29 05:38:47.268206',535,535,'116774de87694898ba2a8d06c7ac7069','bc3a67c4-3fc0-4c7d-bf4e-1a46e3682857',162,'352a7d8defe34a3486f41ba56e48d88e','shares',-1,'2025-11-30 05:38:47',NULL),('2025-11-29 05:38:47.253352',NULL,'2025-11-29 05:38:47.268206',536,536,'116774de87694898ba2a8d06c7ac7069','f6ebfd7a-b9b5-404b-9b37-4dbcd84defd3',161,'352a7d8defe34a3486f41ba56e48d88e','gigabytes',-1,'2025-11-30 05:38:47',NULL),('2025-11-29 05:38:47.260630',NULL,'2025-11-29 05:38:47.268206',537,537,NULL,'db84a680-27c1-4a68-982e-7d369d27abfc',164,'352a7d8defe34a3486f41ba56e48d88e','shares',-1,'2025-11-30 05:38:47','45b75960-3761-478e-bd9e-8a81899d6aa5'),('2025-11-29 05:38:47.261357',NULL,'2025-11-29 05:38:47.268206',538,538,NULL,'80b6a728-f490-42ed-96da-3aa50a98b6fd',163,'352a7d8defe34a3486f41ba56e48d88e','gigabytes',-1,'2025-11-30 05:38:47','45b75960-3761-478e-bd9e-8a81899d6aa5'),('2025-11-29 05:38:49.834681',NULL,'2025-11-29 05:38:49.875093',539,539,'18ebde6642cb44c1bd4ab1e5fa932abd','4f4dba3b-aabf-4540-b760-1f66d7d34884',170,'177e0fe42e604553bd3b076a784b5e9d','shares',1,'2025-11-30 05:38:49',NULL),('2025-11-29 05:38:49.835729',NULL,'2025-11-29 05:38:49.875093',540,540,'18ebde6642cb44c1bd4ab1e5fa932abd','653cafdb-cc31-4c16-914c-bf44b5c89455',169,'177e0fe42e604553bd3b076a784b5e9d','gigabytes',1,'2025-11-30 05:38:49',NULL),('2025-11-29 05:38:49.845847',NULL,'2025-11-29 05:38:49.875093',541,541,NULL,'d677c56a-8b0c-47aa-b970-2c553c79f7cf',172,'177e0fe42e604553bd3b076a784b5e9d','shares',1,'2025-11-30 05:38:49','3715bc74-5c5d-42b9-996c-80000d22afc6'),('2025-11-29 05:38:49.847060',NULL,'2025-11-29 05:38:49.875093',542,542,NULL,'431a70f2-9ad2-43db-a9dc-e60f7c5c5c13',171,'177e0fe42e604553bd3b076a784b5e9d','gigabytes',1,'2025-11-30 05:38:49','3715bc74-5c5d-42b9-996c-80000d22afc6'),('2025-11-29 05:38:53.405143',NULL,'2025-11-29 05:38:53.496692',543,543,'18ebde6642cb44c1bd4ab1e5fa932abd','de39413a-454b-4ba4-a4ea-2dd5b1d0d8f4',173,'177e0fe42e604553bd3b076a784b5e9d','snapshots',1,'2025-11-30 05:38:53',NULL),('2025-11-29 05:38:53.406504',NULL,'2025-11-29 05:38:53.496692',544,544,'18ebde6642cb44c1bd4ab1e5fa932abd','6f9b4ce8-053c-4c9b-8e5d-79dc3ce1a4ab',174,'177e0fe42e604553bd3b076a784b5e9d','snapshot_gigabytes',1,'2025-11-30 05:38:53',NULL),('2025-11-29 05:38:53.420649',NULL,'2025-11-29 05:38:53.496692',545,545,NULL,'1678a01a-5d83-4e98-9374-622ff3538988',175,'177e0fe42e604553bd3b076a784b5e9d','snapshots',1,'2025-11-30 05:38:53','3715bc74-5c5d-42b9-996c-80000d22afc6'),('2025-11-29 05:38:53.422151',NULL,'2025-11-29 05:38:53.496692',546,546,NULL,'a8ffac20-6cfc-47c0-b6f2-fc4b714f6de7',176,'177e0fe42e604553bd3b076a784b5e9d','snapshot_gigabytes',1,'2025-11-30 05:38:53','3715bc74-5c5d-42b9-996c-80000d22afc6'),('2025-11-29 05:38:58.703989',NULL,'2025-11-29 05:38:58.743292',547,547,'18ebde6642cb44c1bd4ab1e5fa932abd','bb1357c5-2702-4648-8850-90b6872c3414',173,'177e0fe42e604553bd3b076a784b5e9d','snapshots',-1,'2025-11-30 05:38:58',NULL),('2025-11-29 05:38:58.704865',NULL,'2025-11-29 05:38:58.743292',548,548,'18ebde6642cb44c1bd4ab1e5fa932abd','fce4a101-f39e-4554-942e-85540203fb7a',174,'177e0fe42e604553bd3b076a784b5e9d','snapshot_gigabytes',-1,'2025-11-30 05:38:58',NULL),('2025-11-29 05:38:58.713648',NULL,'2025-11-29 05:38:58.743292',549,549,NULL,'94f114bc-3373-41a1-8ac8-1c614cb21124',175,'177e0fe42e604553bd3b076a784b5e9d','snapshots',-1,'2025-11-30 05:38:58','3715bc74-5c5d-42b9-996c-80000d22afc6'),('2025-11-29 05:38:58.728127',NULL,'2025-11-29 05:38:58.743292',550,550,NULL,'6164dbaf-8b2b-43b9-87c5-a48d531ac382',176,'177e0fe42e604553bd3b076a784b5e9d','snapshot_gigabytes',-1,'2025-11-30 05:38:58','3715bc74-5c5d-42b9-996c-80000d22afc6'),('2025-11-29 05:39:01.710057',NULL,'2025-11-29 05:39:01.764327',551,551,'6bb380b85f054d16ac066ab6ea1e4f89','30042cdd-410a-475f-bd89-dcfbc2ffb456',177,'96790676f7be41c7bf96036d7e07ffb2','shares',1,'2025-11-30 05:39:01',NULL),('2025-11-29 05:39:01.711577',NULL,'2025-11-29 05:39:01.764327',552,552,'6bb380b85f054d16ac066ab6ea1e4f89','c01cda74-fc8a-4fd8-a69d-08c7c71fb2d0',178,'96790676f7be41c7bf96036d7e07ffb2','gigabytes',1,'2025-11-30 05:39:01',NULL),('2025-11-29 05:39:01.724003',NULL,'2025-11-29 05:39:01.764327',553,553,NULL,'78a2febe-c223-4b9d-91b7-30c8dbe70938',179,'96790676f7be41c7bf96036d7e07ffb2','shares',1,'2025-11-30 05:39:01','85b2d88e-0dba-4f04-9990-9dd773d71543'),('2025-11-29 05:39:01.730925',NULL,'2025-11-29 05:39:01.764327',554,554,NULL,'b0da5d51-b455-47b8-acd3-816261bd61c2',180,'96790676f7be41c7bf96036d7e07ffb2','gigabytes',1,'2025-11-30 05:39:01','85b2d88e-0dba-4f04-9990-9dd773d71543'),('2025-11-29 05:39:02.255216',NULL,'2025-11-29 05:39:02.270046',555,555,'18ebde6642cb44c1bd4ab1e5fa932abd','b767c0dd-3c3b-4c26-ab26-392fb09af12f',170,'177e0fe42e604553bd3b076a784b5e9d','shares',-1,'2025-11-30 05:39:02',NULL),('2025-11-29 05:39:02.256283',NULL,'2025-11-29 05:39:02.270046',556,556,'18ebde6642cb44c1bd4ab1e5fa932abd','3062d7b6-6e0a-4dfb-99f9-1deb769b2ad6',169,'177e0fe42e604553bd3b076a784b5e9d','gigabytes',-1,'2025-11-30 05:39:02',NULL),('2025-11-29 05:39:02.261883',NULL,'2025-11-29 05:39:02.270046',557,557,NULL,'9642db23-4293-404d-a794-38ee6be6c7b9',172,'177e0fe42e604553bd3b076a784b5e9d','shares',-1,'2025-11-30 05:39:02','3715bc74-5c5d-42b9-996c-80000d22afc6'),('2025-11-29 05:39:02.262632',NULL,'2025-11-29 05:39:02.270046',558,558,NULL,'969fa142-c97e-4fa6-af87-762125cfcaa6',171,'177e0fe42e604553bd3b076a784b5e9d','gigabytes',-1,'2025-11-30 05:39:02','3715bc74-5c5d-42b9-996c-80000d22afc6'),('2025-11-29 05:39:09.807018',NULL,'2025-11-29 05:39:09.857230',559,559,'6b29bd6ef300472cad86c5c5a7341f17','ac65888e-a98d-4c42-a0b9-82d631c9fb56',182,'96857e43ebcb4e019650999b54e535a1','shares',1,'2025-11-30 05:39:09',NULL),('2025-11-29 05:39:09.808436',NULL,'2025-11-29 05:39:09.857230',560,560,'6b29bd6ef300472cad86c5c5a7341f17','7a78d170-7203-467f-843d-3e4ac14878a9',181,'96857e43ebcb4e019650999b54e535a1','gigabytes',1,'2025-11-30 05:39:09',NULL),('2025-11-29 05:39:09.824620',NULL,'2025-11-29 05:39:09.857230',561,561,NULL,'bd15bd47-1538-4f2b-a23c-d630d4d34bb4',184,'96857e43ebcb4e019650999b54e535a1','shares',1,'2025-11-30 05:39:09','7a4d5f0d-6975-4e09-abb0-f0f03a3782cc'),('2025-11-29 05:39:09.826099',NULL,'2025-11-29 05:39:09.857230',562,562,NULL,'37ea3745-6894-45b5-b635-3ee93d92803a',183,'96857e43ebcb4e019650999b54e535a1','gigabytes',1,'2025-11-30 05:39:09','7a4d5f0d-6975-4e09-abb0-f0f03a3782cc'),('2025-11-29 05:39:10.358091',NULL,'2025-11-29 05:39:10.374761',563,563,'6bb380b85f054d16ac066ab6ea1e4f89','6f8792e1-0767-4c54-b5c0-465f72d19d28',177,'96790676f7be41c7bf96036d7e07ffb2','shares',-1,'2025-11-30 05:39:10',NULL),('2025-11-29 05:39:10.359150',NULL,'2025-11-29 05:39:10.374761',564,564,'6bb380b85f054d16ac066ab6ea1e4f89','47129322-2314-4410-baed-ba0c68c5543c',178,'96790676f7be41c7bf96036d7e07ffb2','gigabytes',-1,'2025-11-30 05:39:10',NULL),('2025-11-29 05:39:10.366560',NULL,'2025-11-29 05:39:10.374761',565,565,NULL,'fc04920a-79cd-4c66-baf9-1aca7051f825',179,'96790676f7be41c7bf96036d7e07ffb2','shares',-1,'2025-11-30 05:39:10','85b2d88e-0dba-4f04-9990-9dd773d71543'),('2025-11-29 05:39:10.367346',NULL,'2025-11-29 05:39:10.374761',566,566,NULL,'2f90742f-9d7c-45a4-aa67-443e6310fccd',180,'96790676f7be41c7bf96036d7e07ffb2','gigabytes',-1,'2025-11-30 05:39:10','85b2d88e-0dba-4f04-9990-9dd773d71543'),('2025-11-29 05:39:13.298538',NULL,'2025-11-29 05:39:13.411124',567,567,'6b29bd6ef300472cad86c5c5a7341f17','a3450e48-4010-4ebe-bc76-fa6eef8a3856',185,'96857e43ebcb4e019650999b54e535a1','snapshots',1,'2025-11-30 05:39:13',NULL),('2025-11-29 05:39:13.300779',NULL,'2025-11-29 05:39:13.411124',568,568,'6b29bd6ef300472cad86c5c5a7341f17','03c8a9ed-73e8-4648-855a-a50c1ea34349',186,'96857e43ebcb4e019650999b54e535a1','snapshot_gigabytes',1,'2025-11-30 05:39:13',NULL),('2025-11-29 05:39:13.319221',NULL,'2025-11-29 05:39:13.411124',569,569,NULL,'99a92481-0a5f-4ce4-b1d1-a44e0549a41d',187,'96857e43ebcb4e019650999b54e535a1','snapshots',1,'2025-11-30 05:39:13','7a4d5f0d-6975-4e09-abb0-f0f03a3782cc'),('2025-11-29 05:39:13.320610',NULL,'2025-11-29 05:39:13.411124',570,570,NULL,'2ba90853-bb41-42ff-ac9d-fe56a24d3b08',188,'96857e43ebcb4e019650999b54e535a1','snapshot_gigabytes',1,'2025-11-30 05:39:13','7a4d5f0d-6975-4e09-abb0-f0f03a3782cc'),('2025-11-29 05:39:17.832774',NULL,'2025-11-29 05:39:17.853410',571,571,'6b29bd6ef300472cad86c5c5a7341f17','4a9fd2c6-b451-4222-bc1b-194ba13392d0',185,'96857e43ebcb4e019650999b54e535a1','snapshots',-1,'2025-11-30 05:39:17',NULL),('2025-11-29 05:39:17.833601',NULL,'2025-11-29 05:39:17.853410',572,572,'6b29bd6ef300472cad86c5c5a7341f17','bc2e5588-54e9-4e5d-96da-549a1543fcc2',186,'96857e43ebcb4e019650999b54e535a1','snapshot_gigabytes',-1,'2025-11-30 05:39:17',NULL),('2025-11-29 05:39:17.842838',NULL,'2025-11-29 05:39:17.853410',573,573,NULL,'b116c946-2bb3-4dec-8c3f-2e2e21d56289',187,'96857e43ebcb4e019650999b54e535a1','snapshots',-1,'2025-11-30 05:39:17','7a4d5f0d-6975-4e09-abb0-f0f03a3782cc'),('2025-11-29 05:39:17.843620',NULL,'2025-11-29 05:39:17.853410',574,574,NULL,'63fa83fa-ae95-470e-8d47-dc70315507f7',188,'96857e43ebcb4e019650999b54e535a1','snapshot_gigabytes',-1,'2025-11-30 05:39:17','7a4d5f0d-6975-4e09-abb0-f0f03a3782cc'),('2025-11-29 05:39:21.270975',NULL,'2025-11-29 05:39:21.286864',575,575,'6b29bd6ef300472cad86c5c5a7341f17','fd016669-ae04-406d-84c4-12ff286d4c40',182,'96857e43ebcb4e019650999b54e535a1','shares',-1,'2025-11-30 05:39:21',NULL),('2025-11-29 05:39:21.271738',NULL,'2025-11-29 05:39:21.286864',576,576,'6b29bd6ef300472cad86c5c5a7341f17','fa3446f3-159f-4841-93d3-6c287f276311',181,'96857e43ebcb4e019650999b54e535a1','gigabytes',-1,'2025-11-30 05:39:21',NULL),('2025-11-29 05:39:21.278097',NULL,'2025-11-29 05:39:21.286864',577,577,NULL,'a0cff788-a550-4dc4-b0d1-0d6c9aac689c',184,'96857e43ebcb4e019650999b54e535a1','shares',-1,'2025-11-30 05:39:21','7a4d5f0d-6975-4e09-abb0-f0f03a3782cc'),('2025-11-29 05:39:21.278762',NULL,'2025-11-29 05:39:21.286864',578,578,NULL,'aecc7acf-41df-4fe5-a2bf-da909e1219e7',183,'96857e43ebcb4e019650999b54e535a1','gigabytes',-1,'2025-11-30 05:39:21','7a4d5f0d-6975-4e09-abb0-f0f03a3782cc'),('2025-11-29 05:39:22.564665',NULL,'2025-11-29 05:39:22.635808',579,579,'d03f7b23a91648fc985ffb356cc04f1d','af444215-72a3-4537-8bc6-f0152a5bd8b5',190,'a05f740db7b94303aac90d6f217f853a','shares',1,'2025-11-30 05:39:22',NULL),('2025-11-29 05:39:22.567498',NULL,'2025-11-29 05:39:22.635808',580,580,'d03f7b23a91648fc985ffb356cc04f1d','c9a081cf-725b-4f6f-a6a4-a622aafc6b8d',189,'a05f740db7b94303aac90d6f217f853a','gigabytes',1,'2025-11-30 05:39:22',NULL),('2025-11-29 05:39:22.592835',NULL,'2025-11-29 05:39:22.635808',581,581,NULL,'e7e175d5-d1e0-4af4-8952-8d35d48a5f5e',192,'a05f740db7b94303aac90d6f217f853a','shares',1,'2025-11-30 05:39:22','f8c8a67f-7464-472c-90a6-c0d7c3ba1b5d'),('2025-11-29 05:39:22.595310',NULL,'2025-11-29 05:39:22.635808',582,582,NULL,'9df4c3c0-4c04-492e-b2fe-29f32cafc075',191,'a05f740db7b94303aac90d6f217f853a','gigabytes',1,'2025-11-30 05:39:22','f8c8a67f-7464-472c-90a6-c0d7c3ba1b5d'),('2025-11-29 05:39:23.163581',NULL,'2025-11-29 05:39:23.222551',583,583,'99c4b856c6fa452b8782cfb49f32d4f9','7461a1fc-e1b4-4ff5-b71d-ddf4036e6b0c',193,'423449a1e9f94864bc4aa1e26a05fb40','share_networks',1,'2025-11-30 05:39:23',NULL),('2025-11-29 05:39:23.854280',NULL,'2025-11-29 05:39:23.863938',584,584,'99c4b856c6fa452b8782cfb49f32d4f9','c28484b4-d218-4e52-a07c-03d3f4f0f5de',193,'423449a1e9f94864bc4aa1e26a05fb40','share_networks',-1,'2025-11-30 05:39:23',NULL),('2025-11-29 05:39:24.064564',NULL,'2025-11-29 05:39:24.116364',585,585,'99c4b856c6fa452b8782cfb49f32d4f9','298cf883-d1db-42ff-ba52-4e3aa8cf3ed7',193,'423449a1e9f94864bc4aa1e26a05fb40','share_networks',1,'2025-11-30 05:39:24',NULL),('2025-11-29 05:39:24.685768',NULL,'2025-11-29 05:39:24.718777',586,586,'6b29bd6ef300472cad86c5c5a7341f17','b4bdf0c0-1e49-4b52-8404-27c8d521123f',182,'96857e43ebcb4e019650999b54e535a1','shares',1,'2025-11-30 05:39:24',NULL),('2025-11-29 05:39:24.687019',NULL,'2025-11-29 05:39:24.718777',587,587,'6b29bd6ef300472cad86c5c5a7341f17','6e9279a8-d22a-4f6e-8b28-2de669b15dbc',181,'96857e43ebcb4e019650999b54e535a1','gigabytes',1,'2025-11-30 05:39:24',NULL),('2025-11-29 05:39:24.696920',NULL,'2025-11-29 05:39:24.718777',588,588,NULL,'f1c947a0-8077-4798-a8cf-2dc8d7ef9613',195,'96857e43ebcb4e019650999b54e535a1','shares',1,'2025-11-30 05:39:24','c2ed6f66-a14c-4a73-8308-2de1b36a4619'),('2025-11-29 05:39:24.697993',NULL,'2025-11-29 05:39:24.718777',589,589,NULL,'21847bcc-3756-42b3-98da-306cf994aedc',194,'96857e43ebcb4e019650999b54e535a1','gigabytes',1,'2025-11-30 05:39:24','c2ed6f66-a14c-4a73-8308-2de1b36a4619'),('2025-11-29 05:39:24.753283',NULL,'2025-11-29 05:39:24.762145',590,590,'99c4b856c6fa452b8782cfb49f32d4f9','1257c225-77ba-48b0-9f88-bec7a6e6fb31',193,'423449a1e9f94864bc4aa1e26a05fb40','share_networks',-1,'2025-11-30 05:39:24',NULL),('2025-11-29 05:39:24.900684',NULL,'2025-11-29 05:39:24.944430',591,591,'99c4b856c6fa452b8782cfb49f32d4f9','b3b8b0a0-87bb-4cec-a8a8-b126ff323910',193,'423449a1e9f94864bc4aa1e26a05fb40','share_networks',1,'2025-11-30 05:39:24',NULL),('2025-11-29 05:39:25.617384',NULL,'2025-11-29 05:39:25.622374',592,592,'99c4b856c6fa452b8782cfb49f32d4f9','469a8c29-a10e-40c5-bcc8-fd6954d044d3',193,'423449a1e9f94864bc4aa1e26a05fb40','share_networks',-1,'2025-11-30 05:39:25',NULL),('2025-11-29 05:39:26.821255',NULL,'2025-11-29 05:39:26.850522',593,593,'d03f7b23a91648fc985ffb356cc04f1d','5e8643e7-1850-43df-863b-a519a44a925f',190,'a05f740db7b94303aac90d6f217f853a','shares',1,'2025-11-30 05:39:26',NULL),('2025-11-29 05:39:26.822505',NULL,'2025-11-29 05:39:26.850522',594,594,'d03f7b23a91648fc985ffb356cc04f1d','40f73b94-8434-440c-b443-eaf2321618ff',189,'a05f740db7b94303aac90d6f217f853a','gigabytes',1,'2025-11-30 05:39:26',NULL),('2025-11-29 05:39:26.827745',NULL,'2025-11-29 05:39:26.850522',595,595,NULL,'d1b5cd52-0fea-4acd-914d-4698e00a4cba',192,'a05f740db7b94303aac90d6f217f853a','shares',1,'2025-11-30 05:39:26','f8c8a67f-7464-472c-90a6-c0d7c3ba1b5d'),('2025-11-29 05:39:26.828952',NULL,'2025-11-29 05:39:26.850522',596,596,NULL,'e82521d7-1f20-455b-89a9-e97a3712a6bc',191,'a05f740db7b94303aac90d6f217f853a','gigabytes',1,'2025-11-30 05:39:26','f8c8a67f-7464-472c-90a6-c0d7c3ba1b5d'),('2025-11-29 05:39:28.700015',NULL,'2025-11-29 05:39:28.726663',597,597,'6b29bd6ef300472cad86c5c5a7341f17','95fefbb2-96da-44e7-baf6-6cfe811709c1',182,'96857e43ebcb4e019650999b54e535a1','shares',-1,'2025-11-30 05:39:28',NULL),('2025-11-29 05:39:28.700770',NULL,'2025-11-29 05:39:28.726663',598,598,'6b29bd6ef300472cad86c5c5a7341f17','d1cb1c7f-a0a5-468a-bb5c-da42481b29c1',181,'96857e43ebcb4e019650999b54e535a1','gigabytes',-1,'2025-11-30 05:39:28',NULL),('2025-11-29 05:39:28.706215',NULL,'2025-11-29 05:39:28.726663',599,599,NULL,'15f5e5cb-df85-4363-8b18-ba8511594de6',195,'96857e43ebcb4e019650999b54e535a1','shares',-1,'2025-11-30 05:39:28','c2ed6f66-a14c-4a73-8308-2de1b36a4619'),('2025-11-29 05:39:28.708278',NULL,'2025-11-29 05:39:28.726663',600,600,NULL,'f3d9e802-b9a3-48dc-9615-aab0af6e6ba6',194,'96857e43ebcb4e019650999b54e535a1','gigabytes',-1,'2025-11-30 05:39:28','c2ed6f66-a14c-4a73-8308-2de1b36a4619'),('2025-11-29 05:39:31.860214',NULL,'2025-11-29 05:39:31.896143',601,601,'0cb50441bd6144cda55fbe51a4e87bce','58db79a6-0a79-454f-a399-3e70716c1916',197,'49f85bf88a7641b492d9ed0e3cbb7c9c','shares',1,'2025-11-30 05:39:31',NULL),('2025-11-29 05:39:31.861734',NULL,'2025-11-29 05:39:31.896143',602,602,'0cb50441bd6144cda55fbe51a4e87bce','2639056a-cdb9-4df0-bc09-99ea4f028cd1',196,'49f85bf88a7641b492d9ed0e3cbb7c9c','gigabytes',1,'2025-11-30 05:39:31',NULL),('2025-11-29 05:39:31.872551',NULL,'2025-11-29 05:39:31.896143',603,603,NULL,'f3dbf5d7-7bab-40af-ad97-fa48f49d0341',199,'49f85bf88a7641b492d9ed0e3cbb7c9c','shares',1,'2025-11-30 05:39:31','3ea6a207-e62f-4ff8-86d8-a7bd7b74ca3e'),('2025-11-29 05:39:31.873711',NULL,'2025-11-29 05:39:31.896143',604,604,NULL,'2fe1ebcb-e276-42df-a8c1-0e0d737545fd',198,'49f85bf88a7641b492d9ed0e3cbb7c9c','gigabytes',1,'2025-11-30 05:39:31','3ea6a207-e62f-4ff8-86d8-a7bd7b74ca3e'),('2025-11-29 05:39:32.091166',NULL,'2025-11-29 05:39:32.123645',605,605,'6b29bd6ef300472cad86c5c5a7341f17','cce9af5e-aa86-43bf-bafc-1060d08389b1',182,'96857e43ebcb4e019650999b54e535a1','shares',1,'2025-11-30 05:39:32',NULL),('2025-11-29 05:39:32.092676',NULL,'2025-11-29 05:39:32.123645',606,606,'6b29bd6ef300472cad86c5c5a7341f17','c493d4d1-7286-442f-81fc-ecc5a98506be',181,'96857e43ebcb4e019650999b54e535a1','gigabytes',1,'2025-11-30 05:39:32',NULL),('2025-11-29 05:39:32.101949',NULL,'2025-11-29 05:39:32.123645',607,607,NULL,'5c8be8fb-e33d-42a4-bd8f-34fca1de2d56',200,'96857e43ebcb4e019650999b54e535a1','shares',1,'2025-11-30 05:39:32','8cad685b-b732-4948-9276-cd3f373c0107'),('2025-11-29 05:39:32.103357',NULL,'2025-11-29 05:39:32.123645',608,608,NULL,'16ab7c38-cf8e-4838-98f3-e195db3e069a',201,'96857e43ebcb4e019650999b54e535a1','gigabytes',1,'2025-11-30 05:39:32','8cad685b-b732-4948-9276-cd3f373c0107'),('2025-11-29 05:39:34.476866',NULL,'2025-11-29 05:39:34.496855',609,609,'d03f7b23a91648fc985ffb356cc04f1d','254b931b-f9da-41f1-b2d5-1dc6d650ddb9',190,'a05f740db7b94303aac90d6f217f853a','shares',-1,'2025-11-30 05:39:34',NULL),('2025-11-29 05:39:34.479152',NULL,'2025-11-29 05:39:34.496855',610,610,'d03f7b23a91648fc985ffb356cc04f1d','40c7f722-6530-4716-8f3c-37218a42eed9',189,'a05f740db7b94303aac90d6f217f853a','gigabytes',-1,'2025-11-30 05:39:34',NULL),('2025-11-29 05:39:34.489691',NULL,'2025-11-29 05:39:34.496855',611,611,NULL,'10c29975-ade9-4b1b-8d1a-e1cf8e6aafd8',192,'a05f740db7b94303aac90d6f217f853a','shares',-1,'2025-11-30 05:39:34','f8c8a67f-7464-472c-90a6-c0d7c3ba1b5d'),('2025-11-29 05:39:34.490345',NULL,'2025-11-29 05:39:34.496855',612,612,NULL,'392f1aa8-7902-408f-bf28-73006a02ed4b',191,'a05f740db7b94303aac90d6f217f853a','gigabytes',-1,'2025-11-30 05:39:34','f8c8a67f-7464-472c-90a6-c0d7c3ba1b5d'),('2025-11-29 05:39:35.475211',NULL,'2025-11-29 05:39:35.537735',613,613,'6b29bd6ef300472cad86c5c5a7341f17','15c2294d-e738-4ddb-bfe0-ee8ceee07646',185,'96857e43ebcb4e019650999b54e535a1','snapshots',1,'2025-11-30 05:39:35',NULL),('2025-11-29 05:39:35.476478',NULL,'2025-11-29 05:39:35.537735',614,614,'6b29bd6ef300472cad86c5c5a7341f17','fefe3548-eee9-447d-8c5c-e84dacaaa27d',186,'96857e43ebcb4e019650999b54e535a1','snapshot_gigabytes',1,'2025-11-30 05:39:35',NULL),('2025-11-29 05:39:35.489568',NULL,'2025-11-29 05:39:35.537735',615,615,NULL,'576ad774-fecc-43ed-809f-c54bba2035f1',202,'96857e43ebcb4e019650999b54e535a1','snapshots',1,'2025-11-30 05:39:35','8cad685b-b732-4948-9276-cd3f373c0107'),('2025-11-29 05:39:35.490913',NULL,'2025-11-29 05:39:35.537735',616,616,NULL,'b3a40e0e-8053-4c6f-ac11-0aaf7e05ad60',203,'96857e43ebcb4e019650999b54e535a1','snapshot_gigabytes',1,'2025-11-30 05:39:35','8cad685b-b732-4948-9276-cd3f373c0107'),('2025-11-29 05:39:35.768865',NULL,'2025-11-29 05:39:35.795841',617,617,'0cb50441bd6144cda55fbe51a4e87bce','e1d9d1e4-af35-425c-bed3-c187ed1a0d9d',197,'49f85bf88a7641b492d9ed0e3cbb7c9c','shares',1,'2025-11-30 05:39:35',NULL),('2025-11-29 05:39:35.770334',NULL,'2025-11-29 05:39:35.795841',618,618,'0cb50441bd6144cda55fbe51a4e87bce','e7c3752d-c391-4e23-81f4-09ef5818989b',196,'49f85bf88a7641b492d9ed0e3cbb7c9c','gigabytes',1,'2025-11-30 05:39:35',NULL),('2025-11-29 05:39:35.775616',NULL,'2025-11-29 05:39:35.795841',619,619,NULL,'ea6c6408-31e3-47eb-b4f7-8fe035554e09',199,'49f85bf88a7641b492d9ed0e3cbb7c9c','shares',1,'2025-11-30 05:39:35','3ea6a207-e62f-4ff8-86d8-a7bd7b74ca3e'),('2025-11-29 05:39:35.776634',NULL,'2025-11-29 05:39:35.795841',620,620,NULL,'5f74e571-97e0-49c9-ab1a-5f11104e4720',198,'49f85bf88a7641b492d9ed0e3cbb7c9c','gigabytes',1,'2025-11-30 05:39:35','3ea6a207-e62f-4ff8-86d8-a7bd7b74ca3e'),('2025-11-29 05:39:37.385713',NULL,'2025-11-29 05:39:37.436570',621,621,'d03f7b23a91648fc985ffb356cc04f1d','185457ec-12a4-48bd-a84a-2d5854ff8054',190,'a05f740db7b94303aac90d6f217f853a','shares',1,'2025-11-30 05:39:37',NULL),('2025-11-29 05:39:37.388215',NULL,'2025-11-29 05:39:37.436570',622,622,'d03f7b23a91648fc985ffb356cc04f1d','1cccaca9-e952-47cd-b8e7-545c8e533251',189,'a05f740db7b94303aac90d6f217f853a','gigabytes',1,'2025-11-30 05:39:37',NULL),('2025-11-29 05:39:37.401520',NULL,'2025-11-29 05:39:37.436570',623,623,NULL,'8e541b90-e65c-43cd-bd3b-7b0504ab1ccc',192,'a05f740db7b94303aac90d6f217f853a','shares',1,'2025-11-30 05:39:37','f8c8a67f-7464-472c-90a6-c0d7c3ba1b5d'),('2025-11-29 05:39:37.404744',NULL,'2025-11-29 05:39:37.436570',624,624,NULL,'0855575c-b8cb-41ed-a2dc-03c80a9c4c8b',191,'a05f740db7b94303aac90d6f217f853a','gigabytes',1,'2025-11-30 05:39:37','f8c8a67f-7464-472c-90a6-c0d7c3ba1b5d'),('2025-11-29 05:39:38.900695',NULL,'2025-11-29 05:39:38.930507',625,625,'6b29bd6ef300472cad86c5c5a7341f17','63ba9d2b-8c7d-4524-bb59-a98b33cd29eb',182,'96857e43ebcb4e019650999b54e535a1','shares',1,'2025-11-30 05:39:38',NULL),('2025-11-29 05:39:38.902147',NULL,'2025-11-29 05:39:38.930507',626,626,'6b29bd6ef300472cad86c5c5a7341f17','92787f99-2ded-4f88-89c6-9ed40655e81a',181,'96857e43ebcb4e019650999b54e535a1','gigabytes',1,'2025-11-30 05:39:38',NULL),('2025-11-29 05:39:38.910150',NULL,'2025-11-29 05:39:38.930507',627,627,NULL,'4276e436-ca18-48c4-9bf2-7eda01940899',200,'96857e43ebcb4e019650999b54e535a1','shares',1,'2025-11-30 05:39:38','8cad685b-b732-4948-9276-cd3f373c0107'),('2025-11-29 05:39:38.911304',NULL,'2025-11-29 05:39:38.930507',628,628,NULL,'d7ea77b0-4f29-47ff-82ca-58dbc31197be',201,'96857e43ebcb4e019650999b54e535a1','gigabytes',1,'2025-11-30 05:39:38','8cad685b-b732-4948-9276-cd3f373c0107'),('2025-11-29 05:39:39.627157',NULL,'2025-11-29 05:39:39.650701',629,629,'0cb50441bd6144cda55fbe51a4e87bce','321545b8-d117-4714-a01f-0f619590949e',197,'49f85bf88a7641b492d9ed0e3cbb7c9c','shares',1,'2025-11-30 05:39:39',NULL),('2025-11-29 05:39:39.628404',NULL,'2025-11-29 05:39:39.650701',630,630,'0cb50441bd6144cda55fbe51a4e87bce','12b572c5-e8b4-458e-aa82-adfb31012849',196,'49f85bf88a7641b492d9ed0e3cbb7c9c','gigabytes',1,'2025-11-30 05:39:39',NULL),('2025-11-29 05:39:39.633694',NULL,'2025-11-29 05:39:39.650701',631,631,NULL,'bf89d420-8b30-4d87-8f08-239840820797',199,'49f85bf88a7641b492d9ed0e3cbb7c9c','shares',1,'2025-11-30 05:39:39','3ea6a207-e62f-4ff8-86d8-a7bd7b74ca3e'),('2025-11-29 05:39:39.634682',NULL,'2025-11-29 05:39:39.650701',632,632,NULL,'e5108570-e032-4358-a681-6d85fc6efcff',198,'49f85bf88a7641b492d9ed0e3cbb7c9c','gigabytes',1,'2025-11-30 05:39:39','3ea6a207-e62f-4ff8-86d8-a7bd7b74ca3e'),('2025-11-29 05:39:44.748999',NULL,'2025-11-29 05:39:44.764966',633,633,'d03f7b23a91648fc985ffb356cc04f1d','a6920db1-fcc1-411a-a392-d150c5d6fdd7',190,'a05f740db7b94303aac90d6f217f853a','shares',-1,'2025-11-30 05:39:44',NULL),('2025-11-29 05:39:44.750029',NULL,'2025-11-29 05:39:44.764966',634,634,'d03f7b23a91648fc985ffb356cc04f1d','f01ff90b-de58-44c2-8a0b-5c9d5e8b4d91',189,'a05f740db7b94303aac90d6f217f853a','gigabytes',-1,'2025-11-30 05:39:44',NULL),('2025-11-29 05:39:44.756713',NULL,'2025-11-29 05:39:44.764966',635,635,NULL,'07803487-1051-4e1d-bc4f-e19da7fcf5e7',192,'a05f740db7b94303aac90d6f217f853a','shares',-1,'2025-11-30 05:39:44','f8c8a67f-7464-472c-90a6-c0d7c3ba1b5d'),('2025-11-29 05:39:44.757459',NULL,'2025-11-29 05:39:44.764966',636,636,NULL,'e96056d1-0a29-4ea5-b351-fced66e88e37',191,'a05f740db7b94303aac90d6f217f853a','gigabytes',-1,'2025-11-30 05:39:44','f8c8a67f-7464-472c-90a6-c0d7c3ba1b5d'),('2025-11-29 05:39:46.841657',NULL,'2025-11-29 05:39:46.883287',637,637,'0cb50441bd6144cda55fbe51a4e87bce','356889ee-c83c-4203-9c20-09885f352367',197,'49f85bf88a7641b492d9ed0e3cbb7c9c','shares',1,'2025-11-30 05:39:46',NULL),('2025-11-29 05:39:46.842745',NULL,'2025-11-29 05:39:46.883287',638,638,'0cb50441bd6144cda55fbe51a4e87bce','15cf7326-b005-46a8-a3c3-851b09da5818',196,'49f85bf88a7641b492d9ed0e3cbb7c9c','gigabytes',1,'2025-11-30 05:39:46',NULL),('2025-11-29 05:39:46.848236',NULL,'2025-11-29 05:39:46.883287',639,639,NULL,'7bda9a3f-00b0-409e-9454-625ed18e2d61',199,'49f85bf88a7641b492d9ed0e3cbb7c9c','shares',1,'2025-11-30 05:39:46','3ea6a207-e62f-4ff8-86d8-a7bd7b74ca3e'),('2025-11-29 05:39:46.860213',NULL,'2025-11-29 05:39:46.883287',640,640,NULL,'26a28dd6-6cd3-4432-8e0d-00fe949f5709',198,'49f85bf88a7641b492d9ed0e3cbb7c9c','gigabytes',1,'2025-11-30 05:39:46','3ea6a207-e62f-4ff8-86d8-a7bd7b74ca3e'),('2025-11-29 05:39:47.450892',NULL,'2025-11-29 05:39:47.487139',641,641,'d03f7b23a91648fc985ffb356cc04f1d','08508bcf-264b-4b51-addb-dce490fe40d6',190,'a05f740db7b94303aac90d6f217f853a','shares',1,'2025-11-30 05:39:47',NULL),('2025-11-29 05:39:47.452322',NULL,'2025-11-29 05:39:47.487139',642,642,'d03f7b23a91648fc985ffb356cc04f1d','44592f19-4120-4e05-96ae-80168d23bf46',189,'a05f740db7b94303aac90d6f217f853a','gigabytes',1,'2025-11-30 05:39:47',NULL),('2025-11-29 05:39:47.458603',NULL,'2025-11-29 05:39:47.487139',643,643,NULL,'d468009c-5cdc-424b-8315-753f10705578',192,'a05f740db7b94303aac90d6f217f853a','shares',1,'2025-11-30 05:39:47','f8c8a67f-7464-472c-90a6-c0d7c3ba1b5d'),('2025-11-29 05:39:47.461103',NULL,'2025-11-29 05:39:47.487139',644,644,NULL,'84a27033-9323-4f06-9f24-926ba30c104f',191,'a05f740db7b94303aac90d6f217f853a','gigabytes',1,'2025-11-30 05:39:47','f8c8a67f-7464-472c-90a6-c0d7c3ba1b5d'),('2025-11-29 05:39:51.709272',NULL,'2025-11-29 05:39:51.748147',645,645,'0cb50441bd6144cda55fbe51a4e87bce','c6f19881-22c2-4c67-9a5b-816a754df4f0',197,'49f85bf88a7641b492d9ed0e3cbb7c9c','shares',-1,'2025-11-30 05:39:51',NULL),('2025-11-29 05:39:51.713352',NULL,'2025-11-29 05:39:51.748147',646,646,'0cb50441bd6144cda55fbe51a4e87bce','4dd34ed1-f8ad-4900-9f81-a58b1c8b85a0',196,'49f85bf88a7641b492d9ed0e3cbb7c9c','gigabytes',-1,'2025-11-30 05:39:51',NULL),('2025-11-29 05:39:51.728525',NULL,'2025-11-29 05:39:51.748147',647,647,NULL,'3db7f3ef-20f1-4d3b-993b-46f7c6933c94',199,'49f85bf88a7641b492d9ed0e3cbb7c9c','shares',-1,'2025-11-30 05:39:51','3ea6a207-e62f-4ff8-86d8-a7bd7b74ca3e'),('2025-11-29 05:39:51.729432',NULL,'2025-11-29 05:39:51.748147',648,648,NULL,'7a768c0f-6408-45f6-ba8b-716a5e0090fa',198,'49f85bf88a7641b492d9ed0e3cbb7c9c','gigabytes',-1,'2025-11-30 05:39:51','3ea6a207-e62f-4ff8-86d8-a7bd7b74ca3e'),('2025-11-29 05:39:55.910107',NULL,'2025-11-29 05:39:55.937486',649,649,'0cb50441bd6144cda55fbe51a4e87bce','53193a4f-06ac-46e8-b642-d3f1a9cf58ac',197,'49f85bf88a7641b492d9ed0e3cbb7c9c','shares',-1,'2025-11-30 05:39:55',NULL),('2025-11-29 05:39:55.911389',NULL,'2025-11-29 05:39:55.937486',650,650,'0cb50441bd6144cda55fbe51a4e87bce','54b5c328-d2f8-4433-b451-ca91f3795428',196,'49f85bf88a7641b492d9ed0e3cbb7c9c','gigabytes',-1,'2025-11-30 05:39:55',NULL),('2025-11-29 05:39:55.923429',NULL,'2025-11-29 05:39:55.937486',651,651,NULL,'ec549cc6-5af5-478d-adb6-941b28f8b112',199,'49f85bf88a7641b492d9ed0e3cbb7c9c','shares',-1,'2025-11-30 05:39:55','3ea6a207-e62f-4ff8-86d8-a7bd7b74ca3e'),('2025-11-29 05:39:55.924879',NULL,'2025-11-29 05:39:55.937486',652,652,NULL,'c1fe666d-3088-44b8-881d-0f4d45efe0f9',198,'49f85bf88a7641b492d9ed0e3cbb7c9c','gigabytes',-1,'2025-11-30 05:39:55','3ea6a207-e62f-4ff8-86d8-a7bd7b74ca3e'),('2025-11-29 05:39:55.939109',NULL,'2025-11-29 05:39:55.965601',653,653,'d03f7b23a91648fc985ffb356cc04f1d','ce6cf98b-2bd0-4279-b8d3-13704a689080',190,'a05f740db7b94303aac90d6f217f853a','shares',-1,'2025-11-30 05:39:55',NULL),('2025-11-29 05:39:55.943079',NULL,'2025-11-29 05:39:55.965601',654,654,'d03f7b23a91648fc985ffb356cc04f1d','bb6d59fe-041d-4434-995b-d469ac569933',189,'a05f740db7b94303aac90d6f217f853a','gigabytes',-1,'2025-11-30 05:39:55',NULL),('2025-11-29 05:39:55.954549',NULL,'2025-11-29 05:39:55.965601',655,655,NULL,'0a40f4b1-e38a-4f90-9ce4-ddc89092179d',192,'a05f740db7b94303aac90d6f217f853a','shares',-1,'2025-11-30 05:39:55','f8c8a67f-7464-472c-90a6-c0d7c3ba1b5d'),('2025-11-29 05:39:55.955647',NULL,'2025-11-29 05:39:55.965601',656,656,NULL,'8f0866fd-3390-4912-8a89-b3b672fd4601',191,'a05f740db7b94303aac90d6f217f853a','gigabytes',-1,'2025-11-30 05:39:55','f8c8a67f-7464-472c-90a6-c0d7c3ba1b5d'),('2025-11-29 05:39:58.806841',NULL,'2025-11-29 05:39:58.832328',657,657,'0cb50441bd6144cda55fbe51a4e87bce','7cfd2f00-4c70-428f-a5c2-30de658fec0a',197,'49f85bf88a7641b492d9ed0e3cbb7c9c','shares',-1,'2025-11-30 05:39:58',NULL),('2025-11-29 05:39:58.807708',NULL,'2025-11-29 05:39:58.832328',658,658,'0cb50441bd6144cda55fbe51a4e87bce','60ea46d3-cc2a-4403-ae3f-e22d72d21489',196,'49f85bf88a7641b492d9ed0e3cbb7c9c','gigabytes',-1,'2025-11-30 05:39:58',NULL),('2025-11-29 05:39:58.819184',NULL,'2025-11-29 05:39:58.832328',659,659,NULL,'7fbc2305-8cda-46a2-a448-6782c3804bf7',199,'49f85bf88a7641b492d9ed0e3cbb7c9c','shares',-1,'2025-11-30 05:39:58','3ea6a207-e62f-4ff8-86d8-a7bd7b74ca3e'),('2025-11-29 05:39:58.820169',NULL,'2025-11-29 05:39:58.832328',660,660,NULL,'cd0889cb-cd6c-494d-b300-e1053f7d4c37',198,'49f85bf88a7641b492d9ed0e3cbb7c9c','gigabytes',-1,'2025-11-30 05:39:58','3ea6a207-e62f-4ff8-86d8-a7bd7b74ca3e'),('2025-11-29 05:40:02.522936',NULL,'2025-11-29 05:40:02.551232',661,661,'0cb50441bd6144cda55fbe51a4e87bce','c7d9fe52-6c33-46ab-9d98-1e82ab75c056',197,'49f85bf88a7641b492d9ed0e3cbb7c9c','shares',-1,'2025-11-30 05:40:02',NULL),('2025-11-29 05:40:02.525832',NULL,'2025-11-29 05:40:02.551232',662,662,'0cb50441bd6144cda55fbe51a4e87bce','1ad0e247-e9cb-4560-af15-7710400ff66d',196,'49f85bf88a7641b492d9ed0e3cbb7c9c','gigabytes',-1,'2025-11-30 05:40:02',NULL),('2025-11-29 05:40:02.536285',NULL,'2025-11-29 05:40:02.551232',663,663,NULL,'cbcd7b7b-364f-48c7-9634-e1ad5fee74e9',199,'49f85bf88a7641b492d9ed0e3cbb7c9c','shares',-1,'2025-11-30 05:40:02','3ea6a207-e62f-4ff8-86d8-a7bd7b74ca3e'),('2025-11-29 05:40:02.537885',NULL,'2025-11-29 05:40:02.551232',664,664,NULL,'c48abea3-398d-48a1-9b1a-d61a18abbb93',198,'49f85bf88a7641b492d9ed0e3cbb7c9c','gigabytes',-1,'2025-11-30 05:40:02','3ea6a207-e62f-4ff8-86d8-a7bd7b74ca3e'),('2025-11-29 05:40:21.709705',NULL,'2025-11-29 05:40:21.742188',665,665,'f0f48ede370b4632ab7b21cc94cfb7ff','9260c3eb-2b09-4d93-8e24-e19da7d91e0c',204,'5dd620782ecb48b9af309e8bc536acb2','shares',1,'2025-11-30 05:40:21',NULL),('2025-11-29 05:40:21.711258',NULL,'2025-11-29 05:40:21.742188',666,666,'f0f48ede370b4632ab7b21cc94cfb7ff','9ac50c77-7242-4837-8def-a32d9caf930f',205,'5dd620782ecb48b9af309e8bc536acb2','gigabytes',1,'2025-11-30 05:40:21',NULL),('2025-11-29 05:40:21.717807',NULL,'2025-11-29 05:40:21.742188',667,667,NULL,'2f303e51-0056-458c-bd42-955cf707a46e',119,'5dd620782ecb48b9af309e8bc536acb2','shares',1,'2025-11-30 05:40:21','27ce7e9e-5dd7-42c3-997a-123357081bf4'),('2025-11-29 05:40:21.719118',NULL,'2025-11-29 05:40:21.742188',668,668,NULL,'451d14e2-8901-4fd2-b536-d042edb0bc7f',120,'5dd620782ecb48b9af309e8bc536acb2','gigabytes',1,'2025-11-30 05:40:21','27ce7e9e-5dd7-42c3-997a-123357081bf4'),('2025-11-29 05:40:23.824852',NULL,'2025-11-29 05:40:23.839582',669,669,'6b29bd6ef300472cad86c5c5a7341f17','f1f893e7-8c29-4b3e-89ed-3eef68c556eb',182,'96857e43ebcb4e019650999b54e535a1','shares',-1,'2025-11-30 05:40:23',NULL),('2025-11-29 05:40:23.825556',NULL,'2025-11-29 05:40:23.839582',670,670,'6b29bd6ef300472cad86c5c5a7341f17','8fdb7354-bf71-4008-98c9-b793b431ae96',181,'96857e43ebcb4e019650999b54e535a1','gigabytes',-1,'2025-11-30 05:40:23',NULL),('2025-11-29 05:40:23.831323',NULL,'2025-11-29 05:40:23.839582',671,671,NULL,'137511dd-7fd5-4f08-8284-16203b873b5e',200,'96857e43ebcb4e019650999b54e535a1','shares',-1,'2025-11-30 05:40:23','8cad685b-b732-4948-9276-cd3f373c0107'),('2025-11-29 05:40:23.832005',NULL,'2025-11-29 05:40:23.839582',672,672,NULL,'fcd7d800-fa5c-4fa4-9010-6ccfade7f674',201,'96857e43ebcb4e019650999b54e535a1','gigabytes',-1,'2025-11-30 05:40:23','8cad685b-b732-4948-9276-cd3f373c0107'),('2025-11-29 05:40:27.424306',NULL,'2025-11-29 05:40:27.439409',673,673,'6b29bd6ef300472cad86c5c5a7341f17','2f0d59bb-a77c-4772-92c6-6558000b8e9c',185,'96857e43ebcb4e019650999b54e535a1','snapshots',-1,'2025-11-30 05:40:27',NULL),('2025-11-29 05:40:27.425046',NULL,'2025-11-29 05:40:27.439409',674,674,'6b29bd6ef300472cad86c5c5a7341f17','93652b5a-b3ac-4887-878c-0c55e777c88f',186,'96857e43ebcb4e019650999b54e535a1','snapshot_gigabytes',-1,'2025-11-30 05:40:27',NULL),('2025-11-29 05:40:27.431067',NULL,'2025-11-29 05:40:27.439409',675,675,NULL,'90562330-0c85-4023-9379-66fa810e7f02',202,'96857e43ebcb4e019650999b54e535a1','snapshots',-1,'2025-11-30 05:40:27','8cad685b-b732-4948-9276-cd3f373c0107'),('2025-11-29 05:40:27.431942',NULL,'2025-11-29 05:40:27.439409',676,676,NULL,'e22e796f-3fe1-423f-9e26-e55c89a88c4f',203,'96857e43ebcb4e019650999b54e535a1','snapshot_gigabytes',-1,'2025-11-30 05:40:27','8cad685b-b732-4948-9276-cd3f373c0107'),('2025-11-29 05:40:28.263771',NULL,'2025-11-29 05:40:28.297407',677,677,'ac0b18a898c7459da335489d13ce6891','acf7915f-2659-4d04-9f1a-25a6969f609f',207,'b6fbd26e87a649ef8a1685512e46f501','shares',1,'2025-11-30 05:40:28',NULL),('2025-11-29 05:40:28.265628',NULL,'2025-11-29 05:40:28.297407',678,678,'ac0b18a898c7459da335489d13ce6891','ba06f687-9cba-4ed2-a5ea-2ad17a2aaa38',206,'b6fbd26e87a649ef8a1685512e46f501','gigabytes',1,'2025-11-30 05:40:28',NULL),('2025-11-29 05:40:28.277118',NULL,'2025-11-29 05:40:28.297407',679,679,NULL,'2993f428-cafe-40b3-83a5-24d98c6334b5',209,'b6fbd26e87a649ef8a1685512e46f501','shares',1,'2025-11-30 05:40:28','4bfe934f-b148-473c-af17-6b60d08583bb'),('2025-11-29 05:40:28.279617',NULL,'2025-11-29 05:40:28.297407',680,680,NULL,'8e04a4f0-a6b1-4c0c-a62e-98bb0a0cf5e4',208,'b6fbd26e87a649ef8a1685512e46f501','gigabytes',1,'2025-11-30 05:40:28','4bfe934f-b148-473c-af17-6b60d08583bb'),('2025-11-29 05:40:29.336500',NULL,'2025-11-29 05:40:29.353322',681,681,'d03f7b23a91648fc985ffb356cc04f1d','9d8474d8-735a-4589-9cfd-71d009ef374c',190,'a05f740db7b94303aac90d6f217f853a','shares',-1,'2025-11-30 05:40:29',NULL),('2025-11-29 05:40:29.337570',NULL,'2025-11-29 05:40:29.353322',682,682,'d03f7b23a91648fc985ffb356cc04f1d','655e18c5-60e1-4b87-b401-7566ff486bbe',189,'a05f740db7b94303aac90d6f217f853a','gigabytes',-1,'2025-11-30 05:40:29',NULL),('2025-11-29 05:40:29.344480',NULL,'2025-11-29 05:40:29.353322',683,683,NULL,'a62c25e1-9920-46a0-86ca-2904349edab5',192,'a05f740db7b94303aac90d6f217f853a','shares',-1,'2025-11-30 05:40:29','f8c8a67f-7464-472c-90a6-c0d7c3ba1b5d'),('2025-11-29 05:40:29.345213',NULL,'2025-11-29 05:40:29.353322',684,684,NULL,'1f9dd4ba-76bc-478d-b8ce-3e168c453690',191,'a05f740db7b94303aac90d6f217f853a','gigabytes',-1,'2025-11-30 05:40:29','f8c8a67f-7464-472c-90a6-c0d7c3ba1b5d'),('2025-11-29 05:40:30.864293',NULL,'2025-11-29 05:40:30.879362',685,685,'6b29bd6ef300472cad86c5c5a7341f17','24c94aef-6a3a-4d40-bbde-4b7a8c35b802',182,'96857e43ebcb4e019650999b54e535a1','shares',-1,'2025-11-30 05:40:30',NULL),('2025-11-29 05:40:30.865016',NULL,'2025-11-29 05:40:30.879362',686,686,'6b29bd6ef300472cad86c5c5a7341f17','4b341265-24d7-4ea6-8037-ae1fb6217e60',181,'96857e43ebcb4e019650999b54e535a1','gigabytes',-1,'2025-11-30 05:40:30',NULL),('2025-11-29 05:40:30.869677',NULL,'2025-11-29 05:40:30.879362',687,687,NULL,'7392d37a-087a-4b48-9f32-7a5840a5d355',200,'96857e43ebcb4e019650999b54e535a1','shares',-1,'2025-11-30 05:40:30','8cad685b-b732-4948-9276-cd3f373c0107'),('2025-11-29 05:40:30.870366',NULL,'2025-11-29 05:40:30.879362',688,688,NULL,'019e589c-3f0f-4b69-8bdb-ffc0397dd756',201,'96857e43ebcb4e019650999b54e535a1','gigabytes',-1,'2025-11-30 05:40:30','8cad685b-b732-4948-9276-cd3f373c0107'),('2025-11-29 05:40:31.703081',NULL,'2025-11-29 05:40:31.780616',689,689,'ac0b18a898c7459da335489d13ce6891','e7930943-641e-43ec-a209-21b4b4d6fe69',211,'b6fbd26e87a649ef8a1685512e46f501','snapshots',1,'2025-11-30 05:40:31',NULL),('2025-11-29 05:40:31.705524',NULL,'2025-11-29 05:40:31.780616',690,690,'ac0b18a898c7459da335489d13ce6891','cfbef15a-1ed2-410c-838e-35a09e26702b',210,'b6fbd26e87a649ef8a1685512e46f501','snapshot_gigabytes',1,'2025-11-30 05:40:31',NULL),('2025-11-29 05:40:31.719920',NULL,'2025-11-29 05:40:31.780616',691,691,NULL,'dc0ea4a1-47ef-4ff2-b4db-4af7d4c7956b',213,'b6fbd26e87a649ef8a1685512e46f501','snapshots',1,'2025-11-30 05:40:31','4bfe934f-b148-473c-af17-6b60d08583bb'),('2025-11-29 05:40:31.721366',NULL,'2025-11-29 05:40:31.780616',692,692,NULL,'c54bc992-f7f5-4603-bd80-1ae8f4268bae',212,'b6fbd26e87a649ef8a1685512e46f501','snapshot_gigabytes',1,'2025-11-30 05:40:31','4bfe934f-b148-473c-af17-6b60d08583bb'),('2025-11-29 05:40:36.422723',NULL,'2025-11-29 05:40:36.437996',693,693,'a0f1e714fbec450395a7fdccce008b46','1be86299-4b3c-4c91-8dbb-ed8e3fb9133d',117,'5dd620782ecb48b9af309e8bc536acb2','shares',-1,'2025-11-30 05:40:36',NULL),('2025-11-29 05:40:36.423534',NULL,'2025-11-29 05:40:36.437996',694,694,'a0f1e714fbec450395a7fdccce008b46','6a2c3e84-9fea-4f59-97b8-e5241ce37a97',118,'5dd620782ecb48b9af309e8bc536acb2','gigabytes',-1,'2025-11-30 05:40:36',NULL),('2025-11-29 05:40:36.428829',NULL,'2025-11-29 05:40:36.437996',695,695,NULL,'c9760237-f621-4d29-8c0e-8a417da16bb2',119,'5dd620782ecb48b9af309e8bc536acb2','shares',-1,'2025-11-30 05:40:36','27ce7e9e-5dd7-42c3-997a-123357081bf4'),('2025-11-29 05:40:36.429467',NULL,'2025-11-29 05:40:36.437996',696,696,NULL,'24e5886e-3901-40b9-ac32-0096d8edd998',120,'5dd620782ecb48b9af309e8bc536acb2','gigabytes',-1,'2025-11-30 05:40:36','27ce7e9e-5dd7-42c3-997a-123357081bf4'),('2025-11-29 05:40:37.455554',NULL,'2025-11-29 05:40:37.472327',697,697,'ac0b18a898c7459da335489d13ce6891','6aa1a9ca-8247-417c-9220-3392d5189781',211,'b6fbd26e87a649ef8a1685512e46f501','snapshots',-1,'2025-11-30 05:40:37',NULL),('2025-11-29 05:40:37.456287',NULL,'2025-11-29 05:40:37.472327',698,698,'ac0b18a898c7459da335489d13ce6891','fe694157-670f-4c20-966a-92a938f2775c',210,'b6fbd26e87a649ef8a1685512e46f501','snapshot_gigabytes',-1,'2025-11-30 05:40:37',NULL),('2025-11-29 05:40:37.462482',NULL,'2025-11-29 05:40:37.472327',699,699,NULL,'53280681-5580-4f01-8fd0-e81b1966d2d1',213,'b6fbd26e87a649ef8a1685512e46f501','snapshots',-1,'2025-11-30 05:40:37','4bfe934f-b148-473c-af17-6b60d08583bb'),('2025-11-29 05:40:37.463351',NULL,'2025-11-29 05:40:37.472327',700,700,NULL,'2b804187-cdb1-4b3e-841c-8c95e1e9816a',212,'b6fbd26e87a649ef8a1685512e46f501','snapshot_gigabytes',-1,'2025-11-30 05:40:37','4bfe934f-b148-473c-af17-6b60d08583bb'),('2025-11-29 05:40:40.921155',NULL,'2025-11-29 05:40:40.965660',701,701,'f33c8cd93bfb451cb06212731cbb3a46','d352754e-3a50-433c-896e-0fc6aaaa58a9',214,'4e135fffa1e64bf8b2e43bd33b51cf15','shares',1,'2025-11-30 05:40:40',NULL),('2025-11-29 05:40:40.924012',NULL,'2025-11-29 05:40:40.965660',702,702,'f33c8cd93bfb451cb06212731cbb3a46','388a9ed0-fb03-4df3-8c4e-9687e91404e8',215,'4e135fffa1e64bf8b2e43bd33b51cf15','gigabytes',1,'2025-11-30 05:40:40',NULL),('2025-11-29 05:40:40.933224',NULL,'2025-11-29 05:40:40.965660',703,703,NULL,'615ae2df-dcb3-4c86-bc38-fab6d87ea995',216,'4e135fffa1e64bf8b2e43bd33b51cf15','shares',1,'2025-11-30 05:40:40','5dcffc4d-5ae1-4806-beb0-c80557d3ef41'),('2025-11-29 05:40:40.935204',NULL,'2025-11-29 05:40:40.965660',704,704,NULL,'1375c683-e07b-47c7-93ed-8e3191997408',217,'4e135fffa1e64bf8b2e43bd33b51cf15','gigabytes',1,'2025-11-30 05:40:40','5dcffc4d-5ae1-4806-beb0-c80557d3ef41'),('2025-11-29 05:40:41.081753',NULL,'2025-11-29 05:40:41.110314',705,705,'ac0b18a898c7459da335489d13ce6891','74416672-1bec-4b41-8c82-c697a5764999',207,'b6fbd26e87a649ef8a1685512e46f501','shares',-1,'2025-11-30 05:40:41',NULL),('2025-11-29 05:40:41.083097',NULL,'2025-11-29 05:40:41.110314',706,706,'ac0b18a898c7459da335489d13ce6891','85249195-7f69-4932-ab2e-3910e03adff7',206,'b6fbd26e87a649ef8a1685512e46f501','gigabytes',-1,'2025-11-30 05:40:41',NULL),('2025-11-29 05:40:41.099688',NULL,'2025-11-29 05:40:41.110314',707,707,NULL,'e2a23bfd-9762-4fd1-8d69-d1fabdb4a85d',209,'b6fbd26e87a649ef8a1685512e46f501','shares',-1,'2025-11-30 05:40:41','4bfe934f-b148-473c-af17-6b60d08583bb'),('2025-11-29 05:40:41.100640',NULL,'2025-11-29 05:40:41.110314',708,708,NULL,'6e8dbbe6-7a71-4e4d-9577-f905898bc6c7',208,'b6fbd26e87a649ef8a1685512e46f501','gigabytes',-1,'2025-11-30 05:40:41','4bfe934f-b148-473c-af17-6b60d08583bb'),('2025-11-29 05:40:43.552609',NULL,'2025-11-29 05:40:43.590390',709,709,'e4d2d18fdb14465eacc082349a6e10a9','27ee9eca-3ad3-4d67-a838-9c8d98816079',219,'d26079c7d6c8427193b3786b26cb5b7e','shares',1,'2025-11-30 05:40:43',NULL),('2025-11-29 05:40:43.554311',NULL,'2025-11-29 05:40:43.590390',710,710,'e4d2d18fdb14465eacc082349a6e10a9','c836fd41-d6c5-447d-911b-74bfabb200bf',218,'d26079c7d6c8427193b3786b26cb5b7e','gigabytes',1,'2025-11-30 05:40:43',NULL),('2025-11-29 05:40:43.567759',NULL,'2025-11-29 05:40:43.590390',711,711,NULL,'5659a97c-1892-455d-9bfc-e3982ac2d585',221,'d26079c7d6c8427193b3786b26cb5b7e','shares',1,'2025-11-30 05:40:43','a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:40:43.569132',NULL,'2025-11-29 05:40:43.590390',712,712,NULL,'d44209e2-6d2d-4663-8804-93caf250de38',220,'d26079c7d6c8427193b3786b26cb5b7e','gigabytes',1,'2025-11-30 05:40:43','a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:40:44.595102',NULL,'2025-11-29 05:40:44.630190',713,713,'f33c8cd93bfb451cb06212731cbb3a46','348913d9-9288-43b3-b735-477545b1a344',214,'4e135fffa1e64bf8b2e43bd33b51cf15','shares',1,'2025-11-30 05:40:44',NULL),('2025-11-29 05:40:44.596343',NULL,'2025-11-29 05:40:44.630190',714,714,'f33c8cd93bfb451cb06212731cbb3a46','980f7e50-d295-44d5-a898-a4dadd4ad696',215,'4e135fffa1e64bf8b2e43bd33b51cf15','gigabytes',1,'2025-11-30 05:40:44',NULL),('2025-11-29 05:40:44.608163',NULL,'2025-11-29 05:40:44.630190',715,715,NULL,'68ce7ad7-a01a-4ab8-ab47-83576ab663e8',223,'4e135fffa1e64bf8b2e43bd33b51cf15','shares',1,'2025-11-30 05:40:44','dd081b42-5cd7-4c7c-8a9b-8db684f71e20'),('2025-11-29 05:40:44.609337',NULL,'2025-11-29 05:40:44.630190',716,716,NULL,'b0786d2b-1b1b-4747-b298-52e37b84f768',222,'4e135fffa1e64bf8b2e43bd33b51cf15','gigabytes',1,'2025-11-30 05:40:44','dd081b42-5cd7-4c7c-8a9b-8db684f71e20'),('2025-11-29 05:40:47.016708',NULL,'2025-11-29 05:40:47.108522',717,717,'e4d2d18fdb14465eacc082349a6e10a9','9629ab9a-9b2e-4b5d-9d84-28a677bb82b3',224,'d26079c7d6c8427193b3786b26cb5b7e','snapshots',1,'2025-11-30 05:40:46',NULL),('2025-11-29 05:40:47.018699',NULL,'2025-11-29 05:40:47.108522',718,718,'e4d2d18fdb14465eacc082349a6e10a9','4417413f-83b4-4c35-8b3a-cd77a95c4e82',225,'d26079c7d6c8427193b3786b26cb5b7e','snapshot_gigabytes',1,'2025-11-30 05:40:46',NULL),('2025-11-29 05:40:47.039213',NULL,'2025-11-29 05:40:47.108522',719,719,NULL,'d59ee9c2-ef0e-4a5e-900f-b6685e555281',226,'d26079c7d6c8427193b3786b26cb5b7e','snapshots',1,'2025-11-30 05:40:46','a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:40:47.041092',NULL,'2025-11-29 05:40:47.108522',720,720,NULL,'58b7f98b-ce2f-49a7-b357-db67ca0f6df0',227,'d26079c7d6c8427193b3786b26cb5b7e','snapshot_gigabytes',1,'2025-11-30 05:40:46','a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:40:48.712771',NULL,'2025-11-29 05:40:48.871982',721,721,'ee35284df12f4f4fad5f92cf5c9ec4e2','105eb921-c2cb-49e7-ab4f-208b99d431ee',229,'e97b8963e55a4094b1cb702d19d887ba','shares',1,'2025-11-30 05:40:48',NULL),('2025-11-29 05:40:48.714763',NULL,'2025-11-29 05:40:48.871982',722,722,'ee35284df12f4f4fad5f92cf5c9ec4e2','40898909-2cd7-425d-aa98-2c9893f098b5',228,'e97b8963e55a4094b1cb702d19d887ba','gigabytes',1,'2025-11-30 05:40:48',NULL),('2025-11-29 05:40:48.746200',NULL,'2025-11-29 05:40:48.871982',723,723,NULL,'4f4118f7-55eb-4200-a68b-2a0a27bd1d95',231,'e97b8963e55a4094b1cb702d19d887ba','shares',1,'2025-11-30 05:40:48','dd081b42-5cd7-4c7c-8a9b-8db684f71e20'),('2025-11-29 05:40:48.747608',NULL,'2025-11-29 05:40:48.871982',724,724,NULL,'98e787e5-d0a3-4a86-b165-c3d722d32da5',230,'e97b8963e55a4094b1cb702d19d887ba','gigabytes',1,'2025-11-30 05:40:48','dd081b42-5cd7-4c7c-8a9b-8db684f71e20'),('2025-11-29 05:40:50.585349',NULL,'2025-11-29 05:40:50.733986',725,725,'e4d2d18fdb14465eacc082349a6e10a9','14059314-5c45-43b0-a70e-079aa543785e',224,'d26079c7d6c8427193b3786b26cb5b7e','snapshots',1,'2025-11-30 05:40:50',NULL),('2025-11-29 05:40:50.586598',NULL,'2025-11-29 05:40:50.733986',726,726,'e4d2d18fdb14465eacc082349a6e10a9','47581075-9674-4b5a-ac56-40ca3ba29115',225,'d26079c7d6c8427193b3786b26cb5b7e','snapshot_gigabytes',1,'2025-11-30 05:40:50',NULL),('2025-11-29 05:40:50.654081',NULL,'2025-11-29 05:40:50.733986',727,727,NULL,'5f02e5a6-7146-4fdb-badf-5f444fd7c929',226,'d26079c7d6c8427193b3786b26cb5b7e','snapshots',1,'2025-11-30 05:40:50','a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:40:50.656313',NULL,'2025-11-29 05:40:50.733986',728,728,NULL,'cf1ba946-f925-4b82-810c-855c90bd817a',227,'d26079c7d6c8427193b3786b26cb5b7e','snapshot_gigabytes',1,'2025-11-30 05:40:50','a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:40:52.148301',NULL,'2025-11-29 05:40:52.183283',729,729,'ea27d7612aa34955a6fb1f29750c8921','73094ed9-019b-41ae-a75a-55e542c03671',233,'837f2bfa5aab4fdabd09b7661c70b7dd','shares',1,'2025-11-30 05:40:52',NULL),('2025-11-29 05:40:52.149468',NULL,'2025-11-29 05:40:52.183283',730,730,'ea27d7612aa34955a6fb1f29750c8921','367048f2-2ce2-4531-94b5-fb75e204b6c1',232,'837f2bfa5aab4fdabd09b7661c70b7dd','gigabytes',2,'2025-11-30 05:40:52',NULL),('2025-11-29 05:40:52.158410',NULL,'2025-11-29 05:40:52.183283',731,731,NULL,'ed884d9d-2bb1-40e5-9adb-50cd6995ee96',235,'837f2bfa5aab4fdabd09b7661c70b7dd','shares',1,'2025-11-30 05:40:52','deb5e28d-c187-482e-a13e-e6b5c6d26fe5'),('2025-11-29 05:40:52.160783',NULL,'2025-11-29 05:40:52.183283',732,732,NULL,'478fa99a-5542-4af5-93bc-e5a995090df3',234,'837f2bfa5aab4fdabd09b7661c70b7dd','gigabytes',2,'2025-11-30 05:40:52','deb5e28d-c187-482e-a13e-e6b5c6d26fe5'),('2025-11-29 05:40:55.555761',NULL,'2025-11-29 05:40:55.666115',733,733,'e4d2d18fdb14465eacc082349a6e10a9','8a5558d9-a181-439e-b9db-90c63bc01c78',224,'d26079c7d6c8427193b3786b26cb5b7e','snapshots',-1,'2025-11-30 05:40:55',NULL),('2025-11-29 05:40:55.556673',NULL,'2025-11-29 05:40:55.666115',734,734,'e4d2d18fdb14465eacc082349a6e10a9','e440389b-3e90-4d5e-b98e-1c5746b0ead6',225,'d26079c7d6c8427193b3786b26cb5b7e','snapshot_gigabytes',-1,'2025-11-30 05:40:55',NULL),('2025-11-29 05:40:55.619494',NULL,'2025-11-29 05:40:55.666115',735,735,NULL,'e8e0be4b-4bde-46ea-9f03-ce07b407437d',226,'d26079c7d6c8427193b3786b26cb5b7e','snapshots',-1,'2025-11-30 05:40:55','a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:40:55.620526',NULL,'2025-11-29 05:40:55.666115',736,736,NULL,'d9efc967-b555-4401-a0b6-65f6c4f2776c',227,'d26079c7d6c8427193b3786b26cb5b7e','snapshot_gigabytes',-1,'2025-11-30 05:40:55','a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:40:55.692253',NULL,'2025-11-29 05:40:55.799603',737,737,'ea27d7612aa34955a6fb1f29750c8921','3c7d1285-f429-419f-9a86-cface0091164',236,'837f2bfa5aab4fdabd09b7661c70b7dd','snapshots',1,'2025-11-30 05:40:55',NULL),('2025-11-29 05:40:55.693520',NULL,'2025-11-29 05:40:55.799603',738,738,'ea27d7612aa34955a6fb1f29750c8921','053cedad-06c5-4148-a001-f133dab895ea',237,'837f2bfa5aab4fdabd09b7661c70b7dd','snapshot_gigabytes',2,'2025-11-30 05:40:55',NULL),('2025-11-29 05:40:55.734635',NULL,'2025-11-29 05:40:55.799603',739,739,NULL,'79ca32c2-00c7-4392-ab73-feed565038d9',238,'837f2bfa5aab4fdabd09b7661c70b7dd','snapshots',1,'2025-11-30 05:40:55','deb5e28d-c187-482e-a13e-e6b5c6d26fe5'),('2025-11-29 05:40:55.736167',NULL,'2025-11-29 05:40:55.799603',740,740,NULL,'d0ae80ef-5e5a-40ff-ac17-5dc472b6bea2',239,'837f2bfa5aab4fdabd09b7661c70b7dd','snapshot_gigabytes',2,'2025-11-30 05:40:55','deb5e28d-c187-482e-a13e-e6b5c6d26fe5'),('2025-11-29 05:40:57.485526',NULL,'2025-11-29 05:40:57.517062',741,741,'d398b490db83489591c69a3c596fa374','c368a916-1641-4dac-9f2e-a81d74adbf8a',240,'9874b59670af413eabb2bba650c69242','share_networks',1,'2025-11-30 05:40:57',NULL),('2025-11-29 05:40:57.806231',NULL,'2025-11-29 05:40:57.841040',742,742,'d398b490db83489591c69a3c596fa374','ea800483-0299-4d87-91bf-c13b4a61c083',240,'9874b59670af413eabb2bba650c69242','share_networks',1,'2025-11-30 05:40:57',NULL),('2025-11-29 05:40:58.077618',NULL,'2025-11-29 05:40:58.109717',743,743,'d398b490db83489591c69a3c596fa374','9bcd03ae-939b-4ff1-85f5-15af1c669b42',240,'9874b59670af413eabb2bba650c69242','share_networks',1,'2025-11-30 05:40:58',NULL),('2025-11-29 05:40:58.299667',NULL,'2025-11-29 05:40:58.307704',744,744,'d398b490db83489591c69a3c596fa374','4c064f68-855e-4732-9bc9-c990be5fc097',240,'9874b59670af413eabb2bba650c69242','share_networks',-1,'2025-11-30 05:40:58',NULL),('2025-11-29 05:40:58.492606',NULL,'2025-11-29 05:40:58.575031',745,745,'e4d2d18fdb14465eacc082349a6e10a9','14ab398b-8d4b-4168-8c89-a12acc0dbd8b',224,'d26079c7d6c8427193b3786b26cb5b7e','snapshots',1,'2025-11-30 05:40:58',NULL),('2025-11-29 05:40:58.495193',NULL,'2025-11-29 05:40:58.575031',746,746,'e4d2d18fdb14465eacc082349a6e10a9','650a1412-42d1-4adc-9b1c-4a854a5a264e',225,'d26079c7d6c8427193b3786b26cb5b7e','snapshot_gigabytes',1,'2025-11-30 05:40:58',NULL),('2025-11-29 05:40:58.501871',NULL,'2025-11-29 05:40:58.575031',747,747,NULL,'27ea2592-d8bc-4051-b83f-76fb3c5758f8',226,'d26079c7d6c8427193b3786b26cb5b7e','snapshots',1,'2025-11-30 05:40:58','a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:40:58.503559',NULL,'2025-11-29 05:40:58.575031',748,748,NULL,'96d8b5ce-53f3-410f-a756-7fb5cdf3175d',227,'d26079c7d6c8427193b3786b26cb5b7e','snapshot_gigabytes',1,'2025-11-30 05:40:58','a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:40:58.531042',NULL,'2025-11-29 05:40:58.570906',749,749,'d398b490db83489591c69a3c596fa374','d7ea79a5-6ffd-4552-8267-e565408743ec',240,'9874b59670af413eabb2bba650c69242','share_networks',1,'2025-11-30 05:40:58',NULL),('2025-11-29 05:40:58.675695',NULL,'2025-11-29 05:40:58.723944',750,750,'d398b490db83489591c69a3c596fa374','105d33d6-7a2e-40df-b159-1d66f6b81eb3',240,'9874b59670af413eabb2bba650c69242','share_networks',1,'2025-11-30 05:40:58',NULL),('2025-11-29 05:40:58.891811',NULL,'2025-11-29 05:40:58.898893',751,751,'d398b490db83489591c69a3c596fa374','54770976-0f27-432c-9021-c3cdcac5520f',240,'9874b59670af413eabb2bba650c69242','share_networks',-1,'2025-11-30 05:40:58',NULL),('2025-11-29 05:40:59.079709',NULL,'2025-11-29 05:40:59.085233',752,752,'d398b490db83489591c69a3c596fa374','49ab03d4-a9b4-4da3-b128-2e3cf853bf32',240,'9874b59670af413eabb2bba650c69242','share_networks',-1,'2025-11-30 05:40:59',NULL),('2025-11-29 05:40:59.753240',NULL,'2025-11-29 05:40:59.781342',753,753,'d398b490db83489591c69a3c596fa374','0334bc61-1bd2-4a02-aa73-0e704bafdab6',240,'9874b59670af413eabb2bba650c69242','share_networks',1,'2025-11-30 05:40:59',NULL),('2025-11-29 05:40:59.857345',NULL,'2025-11-29 05:40:59.881301',754,754,'ea27d7612aa34955a6fb1f29750c8921','ee5e668d-47a6-4c64-bb7a-822129c4342d',236,'837f2bfa5aab4fdabd09b7661c70b7dd','snapshots',-1,'2025-11-30 05:40:59',NULL),('2025-11-29 05:40:59.858048',NULL,'2025-11-29 05:40:59.881301',755,755,'ea27d7612aa34955a6fb1f29750c8921','ed6f96b1-014c-4c69-ae91-8e83e9d24532',237,'837f2bfa5aab4fdabd09b7661c70b7dd','snapshot_gigabytes',-2,'2025-11-30 05:40:59',NULL),('2025-11-29 05:40:59.867441',NULL,'2025-11-29 05:40:59.881301',756,756,NULL,'73040ca2-e9c0-43d0-be4e-e662be631bd5',238,'837f2bfa5aab4fdabd09b7661c70b7dd','snapshots',-1,'2025-11-30 05:40:59','deb5e28d-c187-482e-a13e-e6b5c6d26fe5'),('2025-11-29 05:40:59.868414',NULL,'2025-11-29 05:40:59.881301',757,757,NULL,'f571f195-a5f9-41e4-8161-547552a1aff8',239,'837f2bfa5aab4fdabd09b7661c70b7dd','snapshot_gigabytes',-2,'2025-11-30 05:40:59','deb5e28d-c187-482e-a13e-e6b5c6d26fe5'),('2025-11-29 05:40:59.935650',NULL,'2025-11-29 05:40:59.942948',758,758,'d398b490db83489591c69a3c596fa374','f1780e45-79cf-4f51-a78b-62e62de8b257',240,'9874b59670af413eabb2bba650c69242','share_networks',-1,'2025-11-30 05:40:59',NULL),('2025-11-29 05:41:00.011383',NULL,'2025-11-29 05:41:00.037849',759,759,'d398b490db83489591c69a3c596fa374','fdadf8ef-bb08-4baf-a21c-2e474e2171ef',240,'9874b59670af413eabb2bba650c69242','share_networks',1,'2025-11-30 05:40:59',NULL),('2025-11-29 05:41:00.166860',NULL,'2025-11-29 05:41:00.174478',760,760,'d398b490db83489591c69a3c596fa374','f5f67158-a24a-4142-9b7e-a86fab7ecc32',240,'9874b59670af413eabb2bba650c69242','share_networks',-1,'2025-11-30 05:41:00',NULL),('2025-11-29 05:41:01.022298',NULL,'2025-11-29 05:41:01.091396',761,761,'d398b490db83489591c69a3c596fa374','5589ab72-724d-45cf-8b4d-71c7a1ebecbb',240,'9874b59670af413eabb2bba650c69242','share_networks',-1,'2025-11-30 05:41:01',NULL),('2025-11-29 05:41:01.412346',NULL,'2025-11-29 05:41:01.426448',762,762,'d398b490db83489591c69a3c596fa374','a1959f1c-12cc-4091-b2ca-4d7c7dbf94c1',240,'9874b59670af413eabb2bba650c69242','share_networks',-1,'2025-11-30 05:41:01',NULL),('2025-11-29 05:41:03.480723',NULL,'2025-11-29 05:41:03.503316',763,763,'ea27d7612aa34955a6fb1f29750c8921','a421c60d-c44b-44ff-8932-91520b6f5081',233,'837f2bfa5aab4fdabd09b7661c70b7dd','shares',-1,'2025-11-30 05:41:03',NULL),('2025-11-29 05:41:03.481401',NULL,'2025-11-29 05:41:03.503316',764,764,'ea27d7612aa34955a6fb1f29750c8921','93520a1e-bc72-4b6a-ab47-8a477d4ee099',232,'837f2bfa5aab4fdabd09b7661c70b7dd','gigabytes',-2,'2025-11-30 05:41:03',NULL),('2025-11-29 05:41:03.493363',NULL,'2025-11-29 05:41:03.503316',765,765,NULL,'1ce4f0d2-fd95-4c37-8d2b-2595d47d6bbd',235,'837f2bfa5aab4fdabd09b7661c70b7dd','shares',-1,'2025-11-30 05:41:03','deb5e28d-c187-482e-a13e-e6b5c6d26fe5'),('2025-11-29 05:41:03.494400',NULL,'2025-11-29 05:41:03.503316',766,766,NULL,'0611100a-df56-4d33-8f87-99c7edba3db1',234,'837f2bfa5aab4fdabd09b7661c70b7dd','gigabytes',-2,'2025-11-30 05:41:03','deb5e28d-c187-482e-a13e-e6b5c6d26fe5'),('2025-11-29 05:41:03.890826',NULL,'2025-11-29 05:41:03.905841',767,767,'e4d2d18fdb14465eacc082349a6e10a9','9bf311dd-3640-4164-a17e-2edf9cad972d',224,'d26079c7d6c8427193b3786b26cb5b7e','snapshots',-1,'2025-11-30 05:41:03',NULL),('2025-11-29 05:41:03.891570',NULL,'2025-11-29 05:41:03.905841',768,768,'e4d2d18fdb14465eacc082349a6e10a9','94f0b37a-a540-4372-9d90-7d1ce134cd8b',225,'d26079c7d6c8427193b3786b26cb5b7e','snapshot_gigabytes',-1,'2025-11-30 05:41:03',NULL),('2025-11-29 05:41:03.897040',NULL,'2025-11-29 05:41:03.905841',769,769,NULL,'15b355f0-171e-4328-a9e1-f4da441b5c28',226,'d26079c7d6c8427193b3786b26cb5b7e','snapshots',-1,'2025-11-30 05:41:03','a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:41:03.897874',NULL,'2025-11-29 05:41:03.905841',770,770,NULL,'ae6931c8-f796-4bdf-a4dc-0c868657871d',227,'d26079c7d6c8427193b3786b26cb5b7e','snapshot_gigabytes',-1,'2025-11-30 05:41:03','a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:41:06.510243',NULL,'2025-11-29 05:41:06.566660',771,771,'ea27d7612aa34955a6fb1f29750c8921','18573b51-2c4b-400a-8c0e-7ddb68a1b041',233,'837f2bfa5aab4fdabd09b7661c70b7dd','shares',1,'2025-11-30 05:41:06',NULL),('2025-11-29 05:41:06.513275',NULL,'2025-11-29 05:41:06.566660',772,772,'ea27d7612aa34955a6fb1f29750c8921','c6769504-22d9-4f23-91f0-c55963a7de3b',232,'837f2bfa5aab4fdabd09b7661c70b7dd','gigabytes',1,'2025-11-30 05:41:06',NULL),('2025-11-29 05:41:06.544008',NULL,'2025-11-29 05:41:06.566660',773,773,NULL,'cf80acd3-e4b7-4a56-aa1e-20c52e044b97',235,'837f2bfa5aab4fdabd09b7661c70b7dd','shares',1,'2025-11-30 05:41:06','deb5e28d-c187-482e-a13e-e6b5c6d26fe5'),('2025-11-29 05:41:06.545810',NULL,'2025-11-29 05:41:06.566660',774,774,NULL,'99745a05-17c5-4f10-95f9-b0dd15d6d689',234,'837f2bfa5aab4fdabd09b7661c70b7dd','gigabytes',1,'2025-11-30 05:41:06','deb5e28d-c187-482e-a13e-e6b5c6d26fe5'),('2025-11-29 05:41:06.993960',NULL,'2025-11-29 05:41:07.075067',775,775,'e4d2d18fdb14465eacc082349a6e10a9','6b0b2ee0-3f71-4050-9f4b-ffb5e1aa158c',224,'d26079c7d6c8427193b3786b26cb5b7e','snapshots',1,'2025-11-30 05:41:06',NULL),('2025-11-29 05:41:06.996990',NULL,'2025-11-29 05:41:07.075067',776,776,'e4d2d18fdb14465eacc082349a6e10a9','0f691631-f78d-44ba-8b94-1741e4b51b50',225,'d26079c7d6c8427193b3786b26cb5b7e','snapshot_gigabytes',1,'2025-11-30 05:41:06',NULL),('2025-11-29 05:41:07.007551',NULL,'2025-11-29 05:41:07.075067',777,777,NULL,'d0840409-cacf-443d-a4f8-6cc85153e641',226,'d26079c7d6c8427193b3786b26cb5b7e','snapshots',1,'2025-11-30 05:41:06','a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:41:07.009643',NULL,'2025-11-29 05:41:07.075067',778,778,NULL,'b0aa9fd9-4b1c-40b7-a870-7c6572fc4e05',227,'d26079c7d6c8427193b3786b26cb5b7e','snapshot_gigabytes',1,'2025-11-30 05:41:06','a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:41:10.211360',NULL,'2025-11-29 05:41:10.271595',779,779,'ea27d7612aa34955a6fb1f29750c8921','7c888935-e6bf-4d4d-9425-ec263fc78a5a',236,'837f2bfa5aab4fdabd09b7661c70b7dd','snapshots',1,'2025-11-30 05:41:10',NULL),('2025-11-29 05:41:10.212519',NULL,'2025-11-29 05:41:10.271595',780,780,'ea27d7612aa34955a6fb1f29750c8921','cc5e2e1c-7761-4de0-bcbf-75a10a50f92c',237,'837f2bfa5aab4fdabd09b7661c70b7dd','snapshot_gigabytes',1,'2025-11-30 05:41:10',NULL),('2025-11-29 05:41:10.220240',NULL,'2025-11-29 05:41:10.271595',781,781,NULL,'3313a686-025f-4eff-ace3-157a599c45ff',238,'837f2bfa5aab4fdabd09b7661c70b7dd','snapshots',1,'2025-11-30 05:41:10','deb5e28d-c187-482e-a13e-e6b5c6d26fe5'),('2025-11-29 05:41:10.221771',NULL,'2025-11-29 05:41:10.271595',782,782,NULL,'9cca495a-e41d-4125-82b7-0030e8607db3',239,'837f2bfa5aab4fdabd09b7661c70b7dd','snapshot_gigabytes',1,'2025-11-30 05:41:10','deb5e28d-c187-482e-a13e-e6b5c6d26fe5'),('2025-11-29 05:41:10.841965',NULL,'2025-11-29 05:41:10.871517',783,783,'e56807404f594d2397401f8e0e2c9fbc','3b6db0bb-9fad-48c2-8323-3344a3482ed6',241,'4d3c4eb0bcce4aec9fe2bc88309fe6bc','share_networks',1,'2025-11-30 05:41:10',NULL),('2025-11-29 05:41:11.085743',NULL,'2025-11-29 05:41:11.100696',784,784,'e4d2d18fdb14465eacc082349a6e10a9','802f827e-2f8a-401c-803e-340bf2b9dac5',224,'d26079c7d6c8427193b3786b26cb5b7e','snapshots',-1,'2025-11-30 05:41:11',NULL),('2025-11-29 05:41:11.086680',NULL,'2025-11-29 05:41:11.100696',785,785,'e4d2d18fdb14465eacc082349a6e10a9','9687eeb7-da5f-4f5d-a268-9574dada5d14',225,'d26079c7d6c8427193b3786b26cb5b7e','snapshot_gigabytes',-1,'2025-11-30 05:41:11',NULL),('2025-11-29 05:41:11.089073',NULL,'2025-11-29 05:41:11.094697',786,786,'e56807404f594d2397401f8e0e2c9fbc','39517f3d-8c8e-43df-802c-3604d269a371',241,'4d3c4eb0bcce4aec9fe2bc88309fe6bc','share_networks',-1,'2025-11-30 05:41:11',NULL),('2025-11-29 05:41:11.091377',NULL,'2025-11-29 05:41:11.100696',787,787,NULL,'a46b9ee7-984a-4e43-801c-5d4b51ccae51',226,'d26079c7d6c8427193b3786b26cb5b7e','snapshots',-1,'2025-11-30 05:41:11','a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:41:11.093433',NULL,'2025-11-29 05:41:11.100696',788,788,NULL,'4067dec1-cef0-4fc4-865e-1cb69e83a7b7',227,'d26079c7d6c8427193b3786b26cb5b7e','snapshot_gigabytes',-1,'2025-11-30 05:41:11','a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:41:11.345048',NULL,'2025-11-29 05:41:11.423390',789,789,'e56807404f594d2397401f8e0e2c9fbc','c427f737-eab7-4fb1-a85d-2e5554f8c282',241,'4d3c4eb0bcce4aec9fe2bc88309fe6bc','share_networks',1,'2025-11-30 05:41:11',NULL),('2025-11-29 05:41:12.187984',NULL,'2025-11-29 05:41:12.194318',790,790,'e56807404f594d2397401f8e0e2c9fbc','6afa8500-70b3-49ce-8b88-75a94532562c',241,'4d3c4eb0bcce4aec9fe2bc88309fe6bc','share_networks',-1,'2025-11-30 05:41:12',NULL),('2025-11-29 05:41:12.562343',NULL,'2025-11-29 05:41:12.608046',791,791,'e56807404f594d2397401f8e0e2c9fbc','92c5c9de-3fa3-494d-a69d-3a73b52a9e96',241,'4d3c4eb0bcce4aec9fe2bc88309fe6bc','share_networks',1,'2025-11-30 05:41:12',NULL),('2025-11-29 05:41:12.777248',NULL,'2025-11-29 05:41:12.784065',792,792,'e56807404f594d2397401f8e0e2c9fbc','de056bfd-cbe6-41d2-b49c-7e5ebb11d3b8',241,'4d3c4eb0bcce4aec9fe2bc88309fe6bc','share_networks',-1,'2025-11-30 05:41:12',NULL),('2025-11-29 05:41:14.326549',NULL,'2025-11-29 05:41:14.410831',793,793,'e4d2d18fdb14465eacc082349a6e10a9','fb31dc8e-65dd-4931-b347-a21f1cfb6ac6',224,'d26079c7d6c8427193b3786b26cb5b7e','snapshots',1,'2025-11-30 05:41:14',NULL),('2025-11-29 05:41:14.327869',NULL,'2025-11-29 05:41:14.410831',794,794,'e4d2d18fdb14465eacc082349a6e10a9','84c8b0f3-6508-4ee0-aea1-b5339b0537e9',225,'d26079c7d6c8427193b3786b26cb5b7e','snapshot_gigabytes',1,'2025-11-30 05:41:14',NULL),('2025-11-29 05:41:14.334638',NULL,'2025-11-29 05:41:14.410831',795,795,NULL,'915494c1-0a57-4cc2-a1a8-9e349a51cfe3',226,'d26079c7d6c8427193b3786b26cb5b7e','snapshots',1,'2025-11-30 05:41:14','a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:41:14.336711',NULL,'2025-11-29 05:41:14.410831',796,796,NULL,'f1a37b35-c025-4733-975f-ad8683aa5733',227,'d26079c7d6c8427193b3786b26cb5b7e','snapshot_gigabytes',1,'2025-11-30 05:41:14','a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:41:15.041550',NULL,'2025-11-29 05:41:15.063146',797,797,'ea27d7612aa34955a6fb1f29750c8921','fd808e18-8422-485b-b191-787b2d9da5f1',236,'837f2bfa5aab4fdabd09b7661c70b7dd','snapshots',-1,'2025-11-30 05:41:14',NULL),('2025-11-29 05:41:15.042453',NULL,'2025-11-29 05:41:15.063146',798,798,'ea27d7612aa34955a6fb1f29750c8921','4fdd65e3-c2c4-49ad-8583-59b7bfc6ddaa',237,'837f2bfa5aab4fdabd09b7661c70b7dd','snapshot_gigabytes',-1,'2025-11-30 05:41:14',NULL),('2025-11-29 05:41:15.050068',NULL,'2025-11-29 05:41:15.063146',799,799,NULL,'417bd8de-6cd9-4853-911f-d1cbc2ae00e5',238,'837f2bfa5aab4fdabd09b7661c70b7dd','snapshots',-1,'2025-11-30 05:41:14','deb5e28d-c187-482e-a13e-e6b5c6d26fe5'),('2025-11-29 05:41:15.053099',NULL,'2025-11-29 05:41:15.063146',800,800,NULL,'1666020e-794a-4a46-8278-fd9858664954',239,'837f2bfa5aab4fdabd09b7661c70b7dd','snapshot_gigabytes',-1,'2025-11-30 05:41:14','deb5e28d-c187-482e-a13e-e6b5c6d26fe5'),('2025-11-29 05:41:16.653827',NULL,'2025-11-29 05:41:16.678980',801,801,'e4d2d18fdb14465eacc082349a6e10a9','4db1ea0d-144a-46b5-acaf-b4d723035c0c',224,'d26079c7d6c8427193b3786b26cb5b7e','snapshots',-1,'2025-11-30 05:41:16',NULL),('2025-11-29 05:41:16.655425',NULL,'2025-11-29 05:41:16.678980',802,802,'e4d2d18fdb14465eacc082349a6e10a9','66f2c0bd-666e-40a8-af09-80764e7fc68f',225,'d26079c7d6c8427193b3786b26cb5b7e','snapshot_gigabytes',-1,'2025-11-30 05:41:16',NULL),('2025-11-29 05:41:16.667805',NULL,'2025-11-29 05:41:16.678980',803,803,NULL,'53bb9334-3808-487c-a1d6-2099a6cbb84c',226,'d26079c7d6c8427193b3786b26cb5b7e','snapshots',-1,'2025-11-30 05:41:16','a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:41:16.668645',NULL,'2025-11-29 05:41:16.678980',804,804,NULL,'30b5c0fc-7025-468f-b624-c860edf9df0f',227,'d26079c7d6c8427193b3786b26cb5b7e','snapshot_gigabytes',-1,'2025-11-30 05:41:16','a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:41:17.708463',NULL,'2025-11-29 05:41:17.741171',805,805,'ee35284df12f4f4fad5f92cf5c9ec4e2','dae62030-bff5-41dc-a843-39f3d8138726',229,'e97b8963e55a4094b1cb702d19d887ba','shares',1,'2025-11-30 05:41:17',NULL),('2025-11-29 05:41:17.709634',NULL,'2025-11-29 05:41:17.741171',806,806,'ee35284df12f4f4fad5f92cf5c9ec4e2','03dac5cb-ba9a-489d-8899-0bff84fff331',228,'e97b8963e55a4094b1cb702d19d887ba','gigabytes',1,'2025-11-30 05:41:17',NULL),('2025-11-29 05:41:17.718666',NULL,'2025-11-29 05:41:17.741171',807,807,NULL,'45f2de11-e996-4fa0-bb56-bf0e3f1a39c1',243,'e97b8963e55a4094b1cb702d19d887ba','shares',1,'2025-11-30 05:41:17','5dcffc4d-5ae1-4806-beb0-c80557d3ef41'),('2025-11-29 05:41:17.719643',NULL,'2025-11-29 05:41:17.741171',808,808,NULL,'8aaa45dc-4187-4aab-bff7-da44a0234a52',242,'e97b8963e55a4094b1cb702d19d887ba','gigabytes',1,'2025-11-30 05:41:17','5dcffc4d-5ae1-4806-beb0-c80557d3ef41'),('2025-11-29 05:41:18.387851',NULL,'2025-11-29 05:41:18.400011',809,809,'ea27d7612aa34955a6fb1f29750c8921','06fa4568-90eb-4b79-a958-2d12e70a8254',233,'837f2bfa5aab4fdabd09b7661c70b7dd','shares',-1,'2025-11-30 05:41:18',NULL),('2025-11-29 05:41:18.388504',NULL,'2025-11-29 05:41:18.400011',810,810,'ea27d7612aa34955a6fb1f29750c8921','8e526055-6e16-4332-b35d-447589eba054',232,'837f2bfa5aab4fdabd09b7661c70b7dd','gigabytes',-1,'2025-11-30 05:41:18',NULL),('2025-11-29 05:41:18.393169',NULL,'2025-11-29 05:41:18.400011',811,811,NULL,'c93327d7-f863-410a-9db2-62048181302d',235,'837f2bfa5aab4fdabd09b7661c70b7dd','shares',-1,'2025-11-30 05:41:18','deb5e28d-c187-482e-a13e-e6b5c6d26fe5'),('2025-11-29 05:41:18.393887',NULL,'2025-11-29 05:41:18.400011',812,812,NULL,'7e3df5b5-10a7-45f8-9033-011c3774e3a8',234,'837f2bfa5aab4fdabd09b7661c70b7dd','gigabytes',-1,'2025-11-30 05:41:18','deb5e28d-c187-482e-a13e-e6b5c6d26fe5'),('2025-11-29 05:41:21.244682',NULL,'2025-11-29 05:41:21.337842',813,813,'e4d2d18fdb14465eacc082349a6e10a9','62d4a5ee-a441-49dc-9745-7c29d6103b36',224,'d26079c7d6c8427193b3786b26cb5b7e','snapshots',1,'2025-11-30 05:41:21',NULL),('2025-11-29 05:41:21.246267',NULL,'2025-11-29 05:41:21.337842',814,814,'e4d2d18fdb14465eacc082349a6e10a9','1f127430-6963-4091-a92b-d7c062795c6d',225,'d26079c7d6c8427193b3786b26cb5b7e','snapshot_gigabytes',1,'2025-11-30 05:41:21',NULL),('2025-11-29 05:41:21.253205',NULL,'2025-11-29 05:41:21.337842',815,815,NULL,'a39d584d-285c-4ee1-bc07-da37b3e55ea3',226,'d26079c7d6c8427193b3786b26cb5b7e','snapshots',1,'2025-11-30 05:41:21','a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:41:21.254364',NULL,'2025-11-29 05:41:21.337842',816,816,NULL,'16b4a72c-cacf-4589-8b17-5ba899092d1d',227,'d26079c7d6c8427193b3786b26cb5b7e','snapshot_gigabytes',1,'2025-11-30 05:41:21','a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:41:21.468636',NULL,'2025-11-29 05:41:21.524676',817,817,'c8055d8ebb36432196034de4894bbc3b','6ebe055b-43cd-47db-a950-9bb9cafdd9dd',245,'388000b055144e48b6827e9f35029a82','shares',1,'2025-11-30 05:41:21',NULL),('2025-11-29 05:41:21.470270',NULL,'2025-11-29 05:41:21.524676',818,818,'c8055d8ebb36432196034de4894bbc3b','cccf02b5-983d-4189-a66b-d5942e00663c',244,'388000b055144e48b6827e9f35029a82','gigabytes',1,'2025-11-30 05:41:21',NULL),('2025-11-29 05:41:21.485877',NULL,'2025-11-29 05:41:21.524676',819,819,NULL,'7deca1be-a234-4d4b-9b0f-465586795798',247,'388000b055144e48b6827e9f35029a82','shares',1,'2025-11-30 05:41:21','b66b9d87-f8e3-4b31-946b-971c6c719cad'),('2025-11-29 05:41:21.487635',NULL,'2025-11-29 05:41:21.524676',820,820,NULL,'87b7c2d2-06eb-4a8a-87bc-41d73316c8c8',246,'388000b055144e48b6827e9f35029a82','gigabytes',1,'2025-11-30 05:41:21','b66b9d87-f8e3-4b31-946b-971c6c719cad'),('2025-11-29 05:41:25.240236',NULL,'2025-11-29 05:41:25.311561',821,821,'c8055d8ebb36432196034de4894bbc3b','5e09349e-0bda-432c-8c37-30022dbafe75',248,'388000b055144e48b6827e9f35029a82','snapshots',1,'2025-11-30 05:41:25',NULL),('2025-11-29 05:41:25.241417',NULL,'2025-11-29 05:41:25.311561',822,822,'c8055d8ebb36432196034de4894bbc3b','f14304b6-d7e2-4c3e-a24c-cf58300eb0fe',249,'388000b055144e48b6827e9f35029a82','snapshot_gigabytes',1,'2025-11-30 05:41:25',NULL),('2025-11-29 05:41:25.250957',NULL,'2025-11-29 05:41:25.311561',823,823,NULL,'f0b2d696-45de-4693-beb0-f66f8654b3af',250,'388000b055144e48b6827e9f35029a82','snapshots',1,'2025-11-30 05:41:25','b66b9d87-f8e3-4b31-946b-971c6c719cad'),('2025-11-29 05:41:25.251950',NULL,'2025-11-29 05:41:25.311561',824,824,NULL,'bda3a8d4-ff24-4a4b-a221-a202f0278d21',251,'388000b055144e48b6827e9f35029a82','snapshot_gigabytes',1,'2025-11-30 05:41:25','b66b9d87-f8e3-4b31-946b-971c6c719cad'),('2025-11-29 05:41:28.222424',NULL,'2025-11-29 05:41:28.259306',825,825,'e4d2d18fdb14465eacc082349a6e10a9','b327411b-ddd3-4e08-8ef1-e2b461d5d722',224,'d26079c7d6c8427193b3786b26cb5b7e','snapshots',-1,'2025-11-30 05:41:28',NULL),('2025-11-29 05:41:28.223227',NULL,'2025-11-29 05:41:28.259306',826,826,'e4d2d18fdb14465eacc082349a6e10a9','cb540aeb-3fbe-4746-b013-3ab49d551168',225,'d26079c7d6c8427193b3786b26cb5b7e','snapshot_gigabytes',-1,'2025-11-30 05:41:28',NULL),('2025-11-29 05:41:28.244972',NULL,'2025-11-29 05:41:28.259306',827,827,NULL,'ebf231d6-54be-44a5-b7f1-a42349a05632',226,'d26079c7d6c8427193b3786b26cb5b7e','snapshots',-1,'2025-11-30 05:41:28','a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:41:28.245693',NULL,'2025-11-29 05:41:28.259306',828,828,NULL,'b1e9f0f5-3dc5-4496-82e5-c78a1c5d6114',227,'d26079c7d6c8427193b3786b26cb5b7e','snapshot_gigabytes',-1,'2025-11-30 05:41:28','a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:41:28.690990',NULL,'2025-11-29 05:41:28.726917',829,829,'c8055d8ebb36432196034de4894bbc3b','5d8d9f45-65c2-414a-ad77-2b788b95caa6',245,'388000b055144e48b6827e9f35029a82','shares',1,'2025-11-30 05:41:28',NULL),('2025-11-29 05:41:28.692430',NULL,'2025-11-29 05:41:28.726917',830,830,'c8055d8ebb36432196034de4894bbc3b','9e505ab7-b3a4-4108-9917-9a0a39d15cf7',244,'388000b055144e48b6827e9f35029a82','gigabytes',1,'2025-11-30 05:41:28',NULL),('2025-11-29 05:41:28.699807',NULL,'2025-11-29 05:41:28.726917',831,831,NULL,'0f0daa73-de6c-4364-a2f5-f985492425ff',247,'388000b055144e48b6827e9f35029a82','shares',1,'2025-11-30 05:41:28','b66b9d87-f8e3-4b31-946b-971c6c719cad'),('2025-11-29 05:41:28.701954',NULL,'2025-11-29 05:41:28.726917',832,832,NULL,'33108c3e-bd2a-4672-b680-2bdfd453b580',246,'388000b055144e48b6827e9f35029a82','gigabytes',1,'2025-11-30 05:41:28','b66b9d87-f8e3-4b31-946b-971c6c719cad'),('2025-11-29 05:41:33.012627',NULL,'2025-11-29 05:41:33.054115',833,833,'e4d2d18fdb14465eacc082349a6e10a9','d3804375-25d2-4b6e-8ad5-49f657d9657d',224,'d26079c7d6c8427193b3786b26cb5b7e','snapshots',-1,'2025-11-30 05:41:32',NULL),('2025-11-29 05:41:33.013617',NULL,'2025-11-29 05:41:33.054115',834,834,'e4d2d18fdb14465eacc082349a6e10a9','3c9d02bb-5278-4466-b44f-ded29c097a04',225,'d26079c7d6c8427193b3786b26cb5b7e','snapshot_gigabytes',-1,'2025-11-30 05:41:32',NULL),('2025-11-29 05:41:33.026184',NULL,'2025-11-29 05:41:33.054115',835,835,NULL,'33db1e17-8eee-4e50-bdd0-50a9f9c3a492',226,'d26079c7d6c8427193b3786b26cb5b7e','snapshots',-1,'2025-11-30 05:41:32','a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:41:33.027270',NULL,'2025-11-29 05:41:33.054115',836,836,NULL,'be3adf1a-5934-4f6a-ab18-da946f68486d',227,'d26079c7d6c8427193b3786b26cb5b7e','snapshot_gigabytes',-1,'2025-11-30 05:41:32','a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:41:33.127368',NULL,'2025-11-29 05:41:33.140497',837,837,'ee35284df12f4f4fad5f92cf5c9ec4e2','4c25f681-219e-48c5-a11f-c3afe434d74d',229,'e97b8963e55a4094b1cb702d19d887ba','shares',-1,'2025-11-30 05:41:33',NULL),('2025-11-29 05:41:33.128248',NULL,'2025-11-29 05:41:33.140497',838,838,'ee35284df12f4f4fad5f92cf5c9ec4e2','9f847066-6065-40e6-ba68-75e41fce94a6',228,'e97b8963e55a4094b1cb702d19d887ba','gigabytes',-1,'2025-11-30 05:41:33',NULL),('2025-11-29 05:41:33.132847',NULL,'2025-11-29 05:41:33.140497',839,839,NULL,'b2c9f900-220f-43e6-aff0-a7c80e3424f6',243,'e97b8963e55a4094b1cb702d19d887ba','shares',-1,'2025-11-30 05:41:33','5dcffc4d-5ae1-4806-beb0-c80557d3ef41'),('2025-11-29 05:41:33.133439',NULL,'2025-11-29 05:41:33.140497',840,840,NULL,'c3f5153c-9eff-42c4-a681-4a8a985fa822',242,'e97b8963e55a4094b1cb702d19d887ba','gigabytes',-1,'2025-11-30 05:41:33','5dcffc4d-5ae1-4806-beb0-c80557d3ef41'),('2025-11-29 05:41:35.822121',NULL,'2025-11-29 05:41:35.847618',841,841,'e4d2d18fdb14465eacc082349a6e10a9','d399a797-6542-474a-b938-4a2c09c09ec2',219,'d26079c7d6c8427193b3786b26cb5b7e','shares',-1,'2025-11-30 05:41:35',NULL),('2025-11-29 05:41:35.823044',NULL,'2025-11-29 05:41:35.847618',842,842,'e4d2d18fdb14465eacc082349a6e10a9','5d1c2c37-85b1-4565-9bf7-a07609e7ee99',218,'d26079c7d6c8427193b3786b26cb5b7e','gigabytes',-1,'2025-11-30 05:41:35',NULL),('2025-11-29 05:41:35.831766',NULL,'2025-11-29 05:41:35.847618',843,843,NULL,'39b9d040-4f28-4190-80e5-9c9b7a709a94',221,'d26079c7d6c8427193b3786b26cb5b7e','shares',-1,'2025-11-30 05:41:35','a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:41:35.833013',NULL,'2025-11-29 05:41:35.847618',844,844,NULL,'d853daaf-87bd-40b1-9713-0c973090a5b5',220,'d26079c7d6c8427193b3786b26cb5b7e','gigabytes',-1,'2025-11-30 05:41:35','a00ca480-cd9e-41b3-86ae-7b6a6e1f8033'),('2025-11-29 05:41:35.978313',NULL,'2025-11-29 05:41:35.990417',845,845,'ee35284df12f4f4fad5f92cf5c9ec4e2','25225467-aba6-4c92-ad35-f424573cea47',229,'e97b8963e55a4094b1cb702d19d887ba','shares',-1,'2025-11-30 05:41:35',NULL),('2025-11-29 05:41:35.979026',NULL,'2025-11-29 05:41:35.990417',846,846,'ee35284df12f4f4fad5f92cf5c9ec4e2','e7c4f076-1c79-43a0-99ce-6da0c5b81152',228,'e97b8963e55a4094b1cb702d19d887ba','gigabytes',-1,'2025-11-30 05:41:35',NULL),('2025-11-29 05:41:35.983881',NULL,'2025-11-29 05:41:35.990417',847,847,NULL,'2a817c92-32f0-45bb-898d-79929947cea0',231,'e97b8963e55a4094b1cb702d19d887ba','shares',-1,'2025-11-30 05:41:35','dd081b42-5cd7-4c7c-8a9b-8db684f71e20'),('2025-11-29 05:41:35.984518',NULL,'2025-11-29 05:41:35.990417',848,848,NULL,'fbc13d53-655c-45e7-bc68-f91ba5bbb093',230,'e97b8963e55a4094b1cb702d19d887ba','gigabytes',-1,'2025-11-30 05:41:35','dd081b42-5cd7-4c7c-8a9b-8db684f71e20'),('2025-11-29 05:41:39.478556',NULL,'2025-11-29 05:41:39.498733',849,849,'f33c8cd93bfb451cb06212731cbb3a46','6f7e6750-89dd-47c1-b077-5f0fecf6d18c',214,'4e135fffa1e64bf8b2e43bd33b51cf15','shares',-1,'2025-11-30 05:41:39',NULL),('2025-11-29 05:41:39.479334',NULL,'2025-11-29 05:41:39.498733',850,850,'f33c8cd93bfb451cb06212731cbb3a46','bb3e8951-d571-4a81-baee-b3598706ef61',215,'4e135fffa1e64bf8b2e43bd33b51cf15','gigabytes',-1,'2025-11-30 05:41:39',NULL),('2025-11-29 05:41:39.485117',NULL,'2025-11-29 05:41:39.498733',851,851,NULL,'15dbf224-f65d-4537-91e1-cefdbad8b60b',223,'4e135fffa1e64bf8b2e43bd33b51cf15','shares',-1,'2025-11-30 05:41:39','dd081b42-5cd7-4c7c-8a9b-8db684f71e20'),('2025-11-29 05:41:39.489516',NULL,'2025-11-29 05:41:39.498733',852,852,NULL,'8484aedb-9874-4e6e-b973-2c41e7998db5',222,'4e135fffa1e64bf8b2e43bd33b51cf15','gigabytes',-1,'2025-11-30 05:41:39','dd081b42-5cd7-4c7c-8a9b-8db684f71e20'),('2025-11-29 05:41:43.311154',NULL,'2025-11-29 05:41:43.323114',853,853,'f33c8cd93bfb451cb06212731cbb3a46','424590c7-63c6-4bf5-bd8b-bdfdb016b4fa',214,'4e135fffa1e64bf8b2e43bd33b51cf15','shares',-1,'2025-11-30 05:41:43',NULL),('2025-11-29 05:41:43.311819',NULL,'2025-11-29 05:41:43.323114',854,854,'f33c8cd93bfb451cb06212731cbb3a46','35ca71ce-05f1-4e3b-8a7b-462ec7b85f0b',215,'4e135fffa1e64bf8b2e43bd33b51cf15','gigabytes',-1,'2025-11-30 05:41:43',NULL),('2025-11-29 05:41:43.316274',NULL,'2025-11-29 05:41:43.323114',855,855,NULL,'6f9276ee-9c58-4efe-89ad-b6456aa16d27',216,'4e135fffa1e64bf8b2e43bd33b51cf15','shares',-1,'2025-11-30 05:41:43','5dcffc4d-5ae1-4806-beb0-c80557d3ef41'),('2025-11-29 05:41:43.316943',NULL,'2025-11-29 05:41:43.323114',856,856,NULL,'3c37f887-4365-4f46-a5c2-fca4b924b85f',217,'4e135fffa1e64bf8b2e43bd33b51cf15','gigabytes',-1,'2025-11-30 05:41:43','5dcffc4d-5ae1-4806-beb0-c80557d3ef41'),('2025-11-29 05:42:12.413687',NULL,'2025-11-29 05:42:12.457380',857,857,'cb8d9fe9ac8c4751bb6ac40883cce87b','efe84956-185f-4bf7-a9e9-aa64f44c7cf0',252,'eeaea5e509ca49be9d6a48ac7d8668b4','share_networks',1,'2025-11-30 05:42:12',NULL),('2025-11-29 05:42:13.673853',NULL,'2025-11-29 05:42:13.707475',858,858,'cb8d9fe9ac8c4751bb6ac40883cce87b','52827026-1922-43cc-8697-b2bcc4f46125',252,'eeaea5e509ca49be9d6a48ac7d8668b4','share_networks',1,'2025-11-30 05:42:13',NULL),('2025-11-29 05:42:14.451972',NULL,'2025-11-29 05:42:14.459916',859,859,'cb8d9fe9ac8c4751bb6ac40883cce87b','a4033e4e-bb28-417d-b7ee-91a2ac8ab0f5',252,'eeaea5e509ca49be9d6a48ac7d8668b4','share_networks',-1,'2025-11-30 05:42:14',NULL),('2025-11-29 05:42:14.610105',NULL,'2025-11-29 05:42:14.648298',860,860,'cb8d9fe9ac8c4751bb6ac40883cce87b','4b56f6ab-8a80-47f2-8d30-2cecc0ffcc33',252,'eeaea5e509ca49be9d6a48ac7d8668b4','share_networks',1,'2025-11-30 05:42:14',NULL),('2025-11-29 05:42:15.429113',NULL,'2025-11-29 05:42:15.447560',861,861,'cb8d9fe9ac8c4751bb6ac40883cce87b','5978218f-616c-419f-bab3-da726271bcaa',252,'eeaea5e509ca49be9d6a48ac7d8668b4','share_networks',-1,'2025-11-30 05:42:15',NULL),('2025-11-29 05:42:17.050980',NULL,'2025-11-29 05:42:17.062027',862,862,'cb8d9fe9ac8c4751bb6ac40883cce87b','42fbf9f6-4188-4853-b0d2-bc315e820657',252,'eeaea5e509ca49be9d6a48ac7d8668b4','share_networks',-1,'2025-11-30 05:42:17',NULL),('2025-11-29 05:42:24.050414',NULL,'2025-11-29 05:42:24.309145',863,863,'af91f2be0ad34dd795af321a91ed6e47','bdfe0e65-f9a5-4955-a5dd-382f2e0591dd',253,'d8ec1959e8bb450793ca093172af99e3','share_networks',1,'2025-11-30 05:42:24',NULL),('2025-11-29 05:42:26.202492',NULL,'2025-11-29 05:42:26.257859',864,864,'c8055d8ebb36432196034de4894bbc3b','40c5f78a-3061-4154-8fd9-ffd5a5041896',245,'388000b055144e48b6827e9f35029a82','shares',1,'2025-11-30 05:42:26',NULL),('2025-11-29 05:42:26.203826',NULL,'2025-11-29 05:42:26.257859',865,865,'c8055d8ebb36432196034de4894bbc3b','cf99b671-5d7d-45ad-888b-b0b579e08c2c',244,'388000b055144e48b6827e9f35029a82','gigabytes',1,'2025-11-30 05:42:26',NULL),('2025-11-29 05:42:26.210601',NULL,'2025-11-29 05:42:26.257859',866,866,NULL,'cb02e61d-5689-47f9-8471-c6df03de61b8',247,'388000b055144e48b6827e9f35029a82','shares',1,'2025-11-30 05:42:26','b66b9d87-f8e3-4b31-946b-971c6c719cad'),('2025-11-29 05:42:26.212208',NULL,'2025-11-29 05:42:26.257859',867,867,NULL,'daeefe7e-f8ef-4884-862d-3c6ceb3f0ede',246,'388000b055144e48b6827e9f35029a82','gigabytes',1,'2025-11-30 05:42:26','b66b9d87-f8e3-4b31-946b-971c6c719cad'),('2025-11-29 05:42:29.739918',NULL,'2025-11-29 05:42:30.249112',868,868,'c8055d8ebb36432196034de4894bbc3b','f0574717-72ae-4de9-a6f4-0287b89b4c18',244,'388000b055144e48b6827e9f35029a82','gigabytes',1,'2025-11-30 05:42:29',NULL),('2025-11-29 05:42:29.749539',NULL,'2025-11-29 05:42:30.249112',869,869,NULL,'015e57f4-90b0-4d49-84a5-5c545b0b7112',246,'388000b055144e48b6827e9f35029a82','gigabytes',1,'2025-11-30 05:42:29','b66b9d87-f8e3-4b31-946b-971c6c719cad'),('2025-11-29 05:42:33.826655',NULL,'2025-11-29 05:42:33.842542',870,870,'c8055d8ebb36432196034de4894bbc3b','a92536d3-0677-4198-af3d-968959531bb4',245,'388000b055144e48b6827e9f35029a82','shares',-1,'2025-11-30 05:42:33',NULL),('2025-11-29 05:42:33.827523',NULL,'2025-11-29 05:42:33.842542',871,871,'c8055d8ebb36432196034de4894bbc3b','1618cfe1-f951-4a1a-9d7a-29a2198a7fbb',244,'388000b055144e48b6827e9f35029a82','gigabytes',-2,'2025-11-30 05:42:33',NULL),('2025-11-29 05:42:33.833374',NULL,'2025-11-29 05:42:33.842542',872,872,NULL,'d56ce064-2341-4e03-a93d-9b1128fcd288',247,'388000b055144e48b6827e9f35029a82','shares',-1,'2025-11-30 05:42:33','b66b9d87-f8e3-4b31-946b-971c6c719cad'),('2025-11-29 05:42:33.834150',NULL,'2025-11-29 05:42:33.842542',873,873,NULL,'070acdf0-298a-4581-a937-2165214bc399',246,'388000b055144e48b6827e9f35029a82','gigabytes',-2,'2025-11-30 05:42:33','b66b9d87-f8e3-4b31-946b-971c6c719cad'),('2025-11-29 05:42:41.636488',NULL,'2025-11-29 05:42:41.667260',874,874,'c8055d8ebb36432196034de4894bbc3b','1ba50989-6418-4943-8c44-a1e2c4ec0c8d',245,'388000b055144e48b6827e9f35029a82','shares',1,'2025-11-30 05:42:41',NULL),('2025-11-29 05:42:41.637642',NULL,'2025-11-29 05:42:41.667260',875,875,'c8055d8ebb36432196034de4894bbc3b','3c3fcc43-b89d-428b-bc46-30c54973f2f5',244,'388000b055144e48b6827e9f35029a82','gigabytes',2,'2025-11-30 05:42:41',NULL),('2025-11-29 05:42:41.646583',NULL,'2025-11-29 05:42:41.667260',876,876,NULL,'1ec5ce09-1871-4d79-950b-3e906f00912e',247,'388000b055144e48b6827e9f35029a82','shares',1,'2025-11-30 05:42:41','b66b9d87-f8e3-4b31-946b-971c6c719cad'),('2025-11-29 05:42:41.647703',NULL,'2025-11-29 05:42:41.667260',877,877,NULL,'ff2365d8-ba91-4ee4-a5b5-a0f925491fcc',246,'388000b055144e48b6827e9f35029a82','gigabytes',2,'2025-11-30 05:42:41','b66b9d87-f8e3-4b31-946b-971c6c719cad'),('2025-11-29 05:42:41.999646',NULL,'2025-11-29 05:42:42.034312',878,878,'89edac5a76e841118f3aa700b37de873','ba3faa15-5412-4f8a-9b17-ff702396ce1f',255,'763ee5d3450f427ca1081cea0f991adc','shares',1,'2025-11-30 05:42:41',NULL),('2025-11-29 05:42:42.000710',NULL,'2025-11-29 05:42:42.034312',879,879,'89edac5a76e841118f3aa700b37de873','e8f0456f-3438-4118-abc9-6f4c33f39a78',254,'763ee5d3450f427ca1081cea0f991adc','gigabytes',1,'2025-11-30 05:42:41',NULL),('2025-11-29 05:42:42.011463',NULL,'2025-11-29 05:42:42.034312',880,880,NULL,'d39548d3-6b53-4c7b-a1a6-3be66f1bb810',257,'763ee5d3450f427ca1081cea0f991adc','shares',1,'2025-11-30 05:42:41','2aa1bdf2-4191-465c-96d1-d1331c081762'),('2025-11-29 05:42:42.012941',NULL,'2025-11-29 05:42:42.034312',881,881,NULL,'d30e2298-f809-4f15-8a1d-f59904ff5a22',256,'763ee5d3450f427ca1081cea0f991adc','gigabytes',1,'2025-11-30 05:42:41','2aa1bdf2-4191-465c-96d1-d1331c081762'),('2025-11-29 05:42:45.098401',NULL,'2025-11-29 05:42:45.130401',882,882,'c8055d8ebb36432196034de4894bbc3b','6781f117-4c7b-49d6-bc12-1850f003a236',244,'388000b055144e48b6827e9f35029a82','gigabytes',-1,'2025-11-30 05:42:45',NULL),('2025-11-29 05:42:45.104125',NULL,'2025-11-29 05:42:45.130401',883,883,NULL,'acd0344c-1808-42fe-b915-b6b01d39fdb8',246,'388000b055144e48b6827e9f35029a82','gigabytes',-1,'2025-11-30 05:42:45','b66b9d87-f8e3-4b31-946b-971c6c719cad'),('2025-11-29 05:42:45.324583',NULL,'2025-11-29 05:42:45.540158',884,884,'89edac5a76e841118f3aa700b37de873','b7a603b4-d9ca-41c9-8417-0b0b88e48271',259,'763ee5d3450f427ca1081cea0f991adc','snapshots',1,'2025-11-30 05:42:45',NULL),('2025-11-29 05:42:45.326200',NULL,'2025-11-29 05:42:45.540158',885,885,'89edac5a76e841118f3aa700b37de873','1fb2a947-4671-473d-8bc1-4612c24aa93a',258,'763ee5d3450f427ca1081cea0f991adc','snapshot_gigabytes',1,'2025-11-30 05:42:45',NULL),('2025-11-29 05:42:45.347068',NULL,'2025-11-29 05:42:45.540158',886,886,NULL,'9965c9ba-8658-47d0-85eb-f9f2f1145c3b',261,'763ee5d3450f427ca1081cea0f991adc','snapshots',1,'2025-11-30 05:42:45','2aa1bdf2-4191-465c-96d1-d1331c081762'),('2025-11-29 05:42:45.348448',NULL,'2025-11-29 05:42:45.540158',887,887,NULL,'b1afc2da-d2e4-4669-8639-a8a32cb2c4cf',260,'763ee5d3450f427ca1081cea0f991adc','snapshot_gigabytes',1,'2025-11-30 05:42:45','2aa1bdf2-4191-465c-96d1-d1331c081762'),('2025-11-29 05:42:48.732422',NULL,'2025-11-29 05:42:48.749410',888,888,'c8055d8ebb36432196034de4894bbc3b','dafc6550-1d08-4ee4-bf01-86811a02af25',245,'388000b055144e48b6827e9f35029a82','shares',-1,'2025-11-30 05:42:48',NULL),('2025-11-29 05:42:48.733524',NULL,'2025-11-29 05:42:48.749410',889,889,'c8055d8ebb36432196034de4894bbc3b','f0230e21-c0f8-48d4-8a6d-d014687c14d1',244,'388000b055144e48b6827e9f35029a82','gigabytes',-1,'2025-11-30 05:42:48',NULL),('2025-11-29 05:42:48.741498',NULL,'2025-11-29 05:42:48.749410',890,890,NULL,'bc8bbc56-af57-417f-92a1-9a969d05fb06',247,'388000b055144e48b6827e9f35029a82','shares',-1,'2025-11-30 05:42:48','b66b9d87-f8e3-4b31-946b-971c6c719cad'),('2025-11-29 05:42:48.742335',NULL,'2025-11-29 05:42:48.749410',891,891,NULL,'fc757102-d8b0-4380-81df-c091d242e7b4',246,'388000b055144e48b6827e9f35029a82','gigabytes',-1,'2025-11-30 05:42:48','b66b9d87-f8e3-4b31-946b-971c6c719cad'),('2025-11-29 05:42:50.532980',NULL,'2025-11-29 05:42:50.546357',892,892,'89edac5a76e841118f3aa700b37de873','81c61656-8934-4a34-b476-69915d35ccb9',259,'763ee5d3450f427ca1081cea0f991adc','snapshots',-1,'2025-11-30 05:42:50',NULL),('2025-11-29 05:42:50.533781',NULL,'2025-11-29 05:42:50.546357',893,893,'89edac5a76e841118f3aa700b37de873','305d6202-7251-4b87-a0ed-148e70ed8c70',258,'763ee5d3450f427ca1081cea0f991adc','snapshot_gigabytes',-1,'2025-11-30 05:42:50',NULL),('2025-11-29 05:42:50.539203',NULL,'2025-11-29 05:42:50.546357',894,894,NULL,'4d34a36a-a75f-4601-a111-c2a15649581f',261,'763ee5d3450f427ca1081cea0f991adc','snapshots',-1,'2025-11-30 05:42:50','2aa1bdf2-4191-465c-96d1-d1331c081762'),('2025-11-29 05:42:50.539975',NULL,'2025-11-29 05:42:50.546357',895,895,NULL,'f08fab93-5df6-436f-b1c9-d928f84dbdb8',260,'763ee5d3450f427ca1081cea0f991adc','snapshot_gigabytes',-1,'2025-11-30 05:42:50','2aa1bdf2-4191-465c-96d1-d1331c081762'),('2025-11-29 05:42:51.828755',NULL,'2025-11-29 05:42:51.945109',896,896,'c8055d8ebb36432196034de4894bbc3b','48705b71-8faf-4f44-b573-2e5907909711',245,'388000b055144e48b6827e9f35029a82','shares',1,'2025-11-30 05:42:51',NULL),('2025-11-29 05:42:51.829898',NULL,'2025-11-29 05:42:51.945109',897,897,'c8055d8ebb36432196034de4894bbc3b','61c3f4c6-98a3-409c-a595-7512f967ba59',244,'388000b055144e48b6827e9f35029a82','gigabytes',1,'2025-11-30 05:42:51',NULL),('2025-11-29 05:42:51.906923',NULL,'2025-11-29 05:42:51.945109',898,898,NULL,'4e8ea4b8-9086-47bf-8d13-f87a9ada24c0',247,'388000b055144e48b6827e9f35029a82','shares',1,'2025-11-30 05:42:51','b66b9d87-f8e3-4b31-946b-971c6c719cad'),('2025-11-29 05:42:51.909271',NULL,'2025-11-29 05:42:51.945109',899,899,NULL,'812d4068-70bd-417a-8d2f-b8addd591b70',246,'388000b055144e48b6827e9f35029a82','gigabytes',1,'2025-11-30 05:42:51','b66b9d87-f8e3-4b31-946b-971c6c719cad'),('2025-11-29 05:42:54.045381',NULL,'2025-11-29 05:42:54.062763',900,900,'89edac5a76e841118f3aa700b37de873','0ef60eed-d42b-4bb3-9e2f-79b95af82e3e',255,'763ee5d3450f427ca1081cea0f991adc','shares',-1,'2025-11-30 05:42:53',NULL),('2025-11-29 05:42:54.046174',NULL,'2025-11-29 05:42:54.062763',901,901,'89edac5a76e841118f3aa700b37de873','b81fb612-3420-41e2-a7e3-72c9c219a09a',254,'763ee5d3450f427ca1081cea0f991adc','gigabytes',-1,'2025-11-30 05:42:53',NULL),('2025-11-29 05:42:54.055376',NULL,'2025-11-29 05:42:54.062763',902,902,NULL,'7c5bafb3-f060-4b56-930c-0bf97c002106',257,'763ee5d3450f427ca1081cea0f991adc','shares',-1,'2025-11-30 05:42:53','2aa1bdf2-4191-465c-96d1-d1331c081762'),('2025-11-29 05:42:54.056167',NULL,'2025-11-29 05:42:54.062763',903,903,NULL,'a3ab9d24-e8e3-4b19-82c5-d99f2ac98a8b',256,'763ee5d3450f427ca1081cea0f991adc','gigabytes',-1,'2025-11-30 05:42:53','2aa1bdf2-4191-465c-96d1-d1331c081762'),('2025-11-29 05:42:56.972502',NULL,'2025-11-29 05:42:56.986484',904,904,'c8055d8ebb36432196034de4894bbc3b','e2b51ed4-8015-4780-b631-3e3d79593d87',245,'388000b055144e48b6827e9f35029a82','shares',-1,'2025-11-30 05:42:56',NULL),('2025-11-29 05:42:56.973314',NULL,'2025-11-29 05:42:56.986484',905,905,'c8055d8ebb36432196034de4894bbc3b','ac7a19b5-3a57-4d54-9eb6-3b247b49a530',244,'388000b055144e48b6827e9f35029a82','gigabytes',-1,'2025-11-30 05:42:56',NULL),('2025-11-29 05:42:56.978235',NULL,'2025-11-29 05:42:56.986484',906,906,NULL,'14ef3ade-6a8f-4ae2-af01-3a2876b47835',247,'388000b055144e48b6827e9f35029a82','shares',-1,'2025-11-30 05:42:56','b66b9d87-f8e3-4b31-946b-971c6c719cad'),('2025-11-29 05:42:56.979485',NULL,'2025-11-29 05:42:56.986484',907,907,NULL,'45b1db2f-4d90-4c05-9482-6b8a17c94588',246,'388000b055144e48b6827e9f35029a82','gigabytes',-1,'2025-11-30 05:42:56','b66b9d87-f8e3-4b31-946b-971c6c719cad'),('2025-11-29 05:43:00.612346',NULL,'2025-11-29 05:43:00.633199',908,908,'c8055d8ebb36432196034de4894bbc3b','2c95d1f6-ba5f-48f8-9321-dfea97266899',245,'388000b055144e48b6827e9f35029a82','shares',-1,'2025-11-30 05:43:00',NULL),('2025-11-29 05:43:00.614273',NULL,'2025-11-29 05:43:00.633199',909,909,'c8055d8ebb36432196034de4894bbc3b','baefd90a-7a30-45c2-b0a9-ba425fb0f5bf',244,'388000b055144e48b6827e9f35029a82','gigabytes',-1,'2025-11-30 05:43:00',NULL),('2025-11-29 05:43:00.621579',NULL,'2025-11-29 05:43:00.633199',910,910,NULL,'6c906a67-a096-4685-9126-4fc99d92beec',247,'388000b055144e48b6827e9f35029a82','shares',-1,'2025-11-30 05:43:00','b66b9d87-f8e3-4b31-946b-971c6c719cad'),('2025-11-29 05:43:00.624768',NULL,'2025-11-29 05:43:00.633199',911,911,NULL,'ea2de6b8-690d-4d54-98bc-84e189da6e3d',246,'388000b055144e48b6827e9f35029a82','gigabytes',-1,'2025-11-30 05:43:00','b66b9d87-f8e3-4b31-946b-971c6c719cad'),('2025-11-29 05:43:07.344568',NULL,'2025-11-29 05:43:07.358776',912,912,'c8055d8ebb36432196034de4894bbc3b','90688bbc-2485-4d87-8f0d-5036a28768de',248,'388000b055144e48b6827e9f35029a82','snapshots',-1,'2025-11-30 05:43:07',NULL),('2025-11-29 05:43:07.345320',NULL,'2025-11-29 05:43:07.358776',913,913,'c8055d8ebb36432196034de4894bbc3b','59bf0d9e-dc86-40de-abe8-ce89c4b7aa3c',249,'388000b055144e48b6827e9f35029a82','snapshot_gigabytes',-1,'2025-11-30 05:43:07',NULL),('2025-11-29 05:43:07.350515',NULL,'2025-11-29 05:43:07.358776',914,914,NULL,'a1a4100a-8469-4f10-85c5-098252ccab85',250,'388000b055144e48b6827e9f35029a82','snapshots',-1,'2025-11-30 05:43:07','b66b9d87-f8e3-4b31-946b-971c6c719cad'),('2025-11-29 05:43:07.351479',NULL,'2025-11-29 05:43:07.358776',915,915,NULL,'2de9e80d-0bd2-4a66-9ef2-1c7db1bca594',251,'388000b055144e48b6827e9f35029a82','snapshot_gigabytes',-1,'2025-11-30 05:43:07','b66b9d87-f8e3-4b31-946b-971c6c719cad'),('2025-11-29 05:43:09.904249',NULL,'2025-11-29 05:43:09.923044',916,916,'c8055d8ebb36432196034de4894bbc3b','04872ded-d8ef-4ada-86c6-1eb9a81a1362',245,'388000b055144e48b6827e9f35029a82','shares',-1,'2025-11-30 05:43:09',NULL),('2025-11-29 05:43:09.905105',NULL,'2025-11-29 05:43:09.923044',917,917,'c8055d8ebb36432196034de4894bbc3b','35c900e9-9060-4372-8294-22cc9277e53f',244,'388000b055144e48b6827e9f35029a82','gigabytes',-1,'2025-11-30 05:43:09',NULL),('2025-11-29 05:43:09.915120',NULL,'2025-11-29 05:43:09.923044',918,918,NULL,'f4a817f2-f145-4d18-9bfa-85117a49c707',247,'388000b055144e48b6827e9f35029a82','shares',-1,'2025-11-30 05:43:09','b66b9d87-f8e3-4b31-946b-971c6c719cad'),('2025-11-29 05:43:09.915941',NULL,'2025-11-29 05:43:09.923044',919,919,NULL,'7d0ffef7-4748-420d-9f2d-3f71af6b5e6a',246,'388000b055144e48b6827e9f35029a82','gigabytes',-1,'2025-11-30 05:43:09','b66b9d87-f8e3-4b31-946b-971c6c719cad'),('2025-11-29 05:43:28.095834',NULL,'2025-11-29 05:43:28.122555',920,920,'6f7f9251bec644a5bf819843dcf464f5','35eaacdc-1027-4385-adab-357cc450a672',263,'bfa506cc517a4cf1bb6dc4bca76155a6','shares',1,'2025-11-30 05:43:28',NULL),('2025-11-29 05:43:28.096864',NULL,'2025-11-29 05:43:28.122555',921,921,'6f7f9251bec644a5bf819843dcf464f5','0ee2af55-17d0-4d44-947e-25119653c10f',262,'bfa506cc517a4cf1bb6dc4bca76155a6','gigabytes',1,'2025-11-30 05:43:28',NULL),('2025-11-29 05:43:28.105024',NULL,'2025-11-29 05:43:28.122555',922,922,NULL,'154bbe4d-ce68-4e8e-a585-8b1af4dc9603',265,'bfa506cc517a4cf1bb6dc4bca76155a6','shares',1,'2025-11-30 05:43:28','1c8161b4-ab6a-46c9-8c73-44780c20ec7e'),('2025-11-29 05:43:28.106160',NULL,'2025-11-29 05:43:28.122555',923,923,NULL,'10d31f1e-ff1f-4425-b888-37b86e7d2db2',264,'bfa506cc517a4cf1bb6dc4bca76155a6','gigabytes',1,'2025-11-30 05:43:28','1c8161b4-ab6a-46c9-8c73-44780c20ec7e'),('2025-11-29 05:43:31.504239',NULL,'2025-11-29 05:43:31.739469',924,924,'6f7f9251bec644a5bf819843dcf464f5','276fcf26-953d-4b09-8f44-57c9d17bfdaa',266,'bfa506cc517a4cf1bb6dc4bca76155a6','snapshots',1,'2025-11-30 05:43:31',NULL),('2025-11-29 05:43:31.505898',NULL,'2025-11-29 05:43:31.739469',925,925,'6f7f9251bec644a5bf819843dcf464f5','2bdd019a-b561-4b38-878a-aeb7f7d671d1',267,'bfa506cc517a4cf1bb6dc4bca76155a6','snapshot_gigabytes',1,'2025-11-30 05:43:31',NULL),('2025-11-29 05:43:31.640602',NULL,'2025-11-29 05:43:31.739469',926,926,NULL,'b065fec6-253d-495e-9910-93aa3632757f',268,'bfa506cc517a4cf1bb6dc4bca76155a6','snapshots',1,'2025-11-30 05:43:31','1c8161b4-ab6a-46c9-8c73-44780c20ec7e'),('2025-11-29 05:43:31.642014',NULL,'2025-11-29 05:43:31.739469',927,927,NULL,'fcc91fdc-b351-4b82-8eec-1690487d9602',269,'bfa506cc517a4cf1bb6dc4bca76155a6','snapshot_gigabytes',1,'2025-11-30 05:43:31','1c8161b4-ab6a-46c9-8c73-44780c20ec7e'),('2025-11-29 05:43:37.161103',NULL,'2025-11-29 05:43:37.421602',928,928,'6f7f9251bec644a5bf819843dcf464f5','9fb7abfa-696b-4675-a046-c037e746dfa5',263,'bfa506cc517a4cf1bb6dc4bca76155a6','shares',1,'2025-11-30 05:43:37',NULL),('2025-11-29 05:43:37.162241',NULL,'2025-11-29 05:43:37.421602',929,929,'6f7f9251bec644a5bf819843dcf464f5','d1f79952-c2e8-4b9a-ba37-a7ec9a21a4e5',262,'bfa506cc517a4cf1bb6dc4bca76155a6','gigabytes',1,'2025-11-30 05:43:37',NULL),('2025-11-29 05:43:37.214494',NULL,'2025-11-29 05:43:37.421602',930,930,NULL,'bcf56bee-2373-4fc3-9508-579e015b8cc0',265,'bfa506cc517a4cf1bb6dc4bca76155a6','shares',1,'2025-11-30 05:43:37','1c8161b4-ab6a-46c9-8c73-44780c20ec7e'),('2025-11-29 05:43:37.216179',NULL,'2025-11-29 05:43:37.421602',931,931,NULL,'8a1d2491-14aa-4dd2-be49-fa7e2f50319b',264,'bfa506cc517a4cf1bb6dc4bca76155a6','gigabytes',1,'2025-11-30 05:43:37','1c8161b4-ab6a-46c9-8c73-44780c20ec7e'),('2025-11-29 05:43:41.574000',NULL,'2025-11-29 05:43:41.609193',932,932,'6f7f9251bec644a5bf819843dcf464f5','93873688-3750-4f2b-aa84-3207d50c4d6e',263,'bfa506cc517a4cf1bb6dc4bca76155a6','shares',-1,'2025-11-30 05:43:41',NULL),('2025-11-29 05:43:41.574825',NULL,'2025-11-29 05:43:41.609193',933,933,'6f7f9251bec644a5bf819843dcf464f5','9558615b-bc83-4697-b35f-8904d7b19278',262,'bfa506cc517a4cf1bb6dc4bca76155a6','gigabytes',-1,'2025-11-30 05:43:41',NULL),('2025-11-29 05:43:41.589133',NULL,'2025-11-29 05:43:41.609193',934,934,NULL,'7fae1d23-8b91-4725-829c-893d2786d8f3',265,'bfa506cc517a4cf1bb6dc4bca76155a6','shares',-1,'2025-11-30 05:43:41','1c8161b4-ab6a-46c9-8c73-44780c20ec7e'),('2025-11-29 05:43:41.589992',NULL,'2025-11-29 05:43:41.609193',935,935,NULL,'0fd98261-ad57-423d-8521-aa07c07b9d75',264,'bfa506cc517a4cf1bb6dc4bca76155a6','gigabytes',-1,'2025-11-30 05:43:41','1c8161b4-ab6a-46c9-8c73-44780c20ec7e'),('2025-11-29 05:43:45.126603',NULL,'2025-11-29 05:43:45.186481',936,936,'6f7f9251bec644a5bf819843dcf464f5','9553fb21-dc8c-4974-a6a1-3bbd2183979c',263,'bfa506cc517a4cf1bb6dc4bca76155a6','shares',1,'2025-11-30 05:43:45',NULL),('2025-11-29 05:43:45.131214',NULL,'2025-11-29 05:43:45.186481',937,937,'6f7f9251bec644a5bf819843dcf464f5','fecd5182-578b-42be-acf2-3bdfde958860',262,'bfa506cc517a4cf1bb6dc4bca76155a6','gigabytes',2,'2025-11-30 05:43:45',NULL),('2025-11-29 05:43:45.148249',NULL,'2025-11-29 05:43:45.186481',938,938,NULL,'48fbf9fe-60a3-4471-8772-60dde8232ea8',265,'bfa506cc517a4cf1bb6dc4bca76155a6','shares',1,'2025-11-30 05:43:45','1c8161b4-ab6a-46c9-8c73-44780c20ec7e'),('2025-11-29 05:43:45.151341',NULL,'2025-11-29 05:43:45.186481',939,939,NULL,'baa7dc12-abb9-4c36-80a5-cb36445fb226',264,'bfa506cc517a4cf1bb6dc4bca76155a6','gigabytes',2,'2025-11-30 05:43:45','1c8161b4-ab6a-46c9-8c73-44780c20ec7e'),('2025-11-29 05:43:49.051455',NULL,'2025-11-29 05:43:49.076508',940,940,'6f7f9251bec644a5bf819843dcf464f5','5498d0df-746c-46d4-a15b-a308b0e74a81',263,'bfa506cc517a4cf1bb6dc4bca76155a6','shares',-1,'2025-11-30 05:43:49',NULL),('2025-11-29 05:43:49.052262',NULL,'2025-11-29 05:43:49.076508',941,941,'6f7f9251bec644a5bf819843dcf464f5','04e75ab9-6d0d-479e-a9a8-7898fe96afc1',262,'bfa506cc517a4cf1bb6dc4bca76155a6','gigabytes',-2,'2025-11-30 05:43:49',NULL),('2025-11-29 05:43:49.067563',NULL,'2025-11-29 05:43:49.076508',942,942,NULL,'3ed1b55a-29e6-4bba-afa7-f4fafadfc6ce',265,'bfa506cc517a4cf1bb6dc4bca76155a6','shares',-1,'2025-11-30 05:43:49','1c8161b4-ab6a-46c9-8c73-44780c20ec7e'),('2025-11-29 05:43:49.068507',NULL,'2025-11-29 05:43:49.076508',943,943,NULL,'38d03127-0500-4c2b-a8ee-97bbf4112fcd',264,'bfa506cc517a4cf1bb6dc4bca76155a6','gigabytes',-2,'2025-11-30 05:43:49','1c8161b4-ab6a-46c9-8c73-44780c20ec7e'),('2025-11-29 05:43:52.199915',NULL,'2025-11-29 05:43:52.235306',944,944,'6f7f9251bec644a5bf819843dcf464f5','7668745e-a35f-4de7-a71e-6bbe0204d69a',263,'bfa506cc517a4cf1bb6dc4bca76155a6','shares',1,'2025-11-30 05:43:52',NULL),('2025-11-29 05:43:52.201778',NULL,'2025-11-29 05:43:52.235306',945,945,'6f7f9251bec644a5bf819843dcf464f5','7c8135a3-15fc-4def-8955-201f9b22e1f7',262,'bfa506cc517a4cf1bb6dc4bca76155a6','gigabytes',1,'2025-11-30 05:43:52',NULL),('2025-11-29 05:43:52.211954',NULL,'2025-11-29 05:43:52.235306',946,946,NULL,'51150aaa-60ca-4f6e-a9d7-9ed32d4349ee',265,'bfa506cc517a4cf1bb6dc4bca76155a6','shares',1,'2025-11-30 05:43:52','1c8161b4-ab6a-46c9-8c73-44780c20ec7e'),('2025-11-29 05:43:52.213857',NULL,'2025-11-29 05:43:52.235306',947,947,NULL,'251d6b2a-836e-4746-87b3-c5023c751208',264,'bfa506cc517a4cf1bb6dc4bca76155a6','gigabytes',1,'2025-11-30 05:43:52','1c8161b4-ab6a-46c9-8c73-44780c20ec7e'),('2025-11-29 05:43:55.975204',NULL,'2025-11-29 05:43:55.989202',948,948,'6f7f9251bec644a5bf819843dcf464f5','aa097302-229c-4e32-86c0-68ee83f829f8',263,'bfa506cc517a4cf1bb6dc4bca76155a6','shares',-1,'2025-11-30 05:43:55',NULL),('2025-11-29 05:43:55.975838',NULL,'2025-11-29 05:43:55.989202',949,949,'6f7f9251bec644a5bf819843dcf464f5','2ced6405-5f1f-4d37-952e-3fed577ee0cb',262,'bfa506cc517a4cf1bb6dc4bca76155a6','gigabytes',-1,'2025-11-30 05:43:55',NULL),('2025-11-29 05:43:55.981536',NULL,'2025-11-29 05:43:55.989202',950,950,NULL,'255f52dc-7e9a-43d3-82e4-662b4598cf9f',265,'bfa506cc517a4cf1bb6dc4bca76155a6','shares',-1,'2025-11-30 05:43:55','1c8161b4-ab6a-46c9-8c73-44780c20ec7e'),('2025-11-29 05:43:55.982191',NULL,'2025-11-29 05:43:55.989202',951,951,NULL,'36c7f296-97d1-4ffa-8ac8-a7fedf5538c2',264,'bfa506cc517a4cf1bb6dc4bca76155a6','gigabytes',-1,'2025-11-30 05:43:55','1c8161b4-ab6a-46c9-8c73-44780c20ec7e'),('2025-11-29 05:43:59.311634',NULL,'2025-11-29 05:43:59.336950',952,952,'6f7f9251bec644a5bf819843dcf464f5','d446eb02-512c-4709-ba4c-f3b215918555',263,'bfa506cc517a4cf1bb6dc4bca76155a6','shares',1,'2025-11-30 05:43:59',NULL),('2025-11-29 05:43:59.312687',NULL,'2025-11-29 05:43:59.336950',953,953,'6f7f9251bec644a5bf819843dcf464f5','25070d15-646b-42c8-b5c7-9662fcc0b02b',262,'bfa506cc517a4cf1bb6dc4bca76155a6','gigabytes',1,'2025-11-30 05:43:59',NULL),('2025-11-29 05:43:59.318117',NULL,'2025-11-29 05:43:59.336950',954,954,NULL,'9afb8d0e-5a45-4657-9bca-ec60845edc2a',265,'bfa506cc517a4cf1bb6dc4bca76155a6','shares',1,'2025-11-30 05:43:59','1c8161b4-ab6a-46c9-8c73-44780c20ec7e'),('2025-11-29 05:43:59.319068',NULL,'2025-11-29 05:43:59.336950',955,955,NULL,'f4177a92-1c35-470e-b362-8e015e37d491',264,'bfa506cc517a4cf1bb6dc4bca76155a6','gigabytes',1,'2025-11-30 05:43:59','1c8161b4-ab6a-46c9-8c73-44780c20ec7e'),('2025-11-29 05:44:03.481391',NULL,'2025-11-29 05:44:03.503186',956,956,'6f7f9251bec644a5bf819843dcf464f5','2b88ff49-61bd-40f4-918d-5c7c0c39ba78',263,'bfa506cc517a4cf1bb6dc4bca76155a6','shares',-1,'2025-11-30 05:44:03',NULL),('2025-11-29 05:44:03.482218',NULL,'2025-11-29 05:44:03.503186',957,957,'6f7f9251bec644a5bf819843dcf464f5','af252939-fc1b-4836-bcd6-00a98b7728e6',262,'bfa506cc517a4cf1bb6dc4bca76155a6','gigabytes',-1,'2025-11-30 05:44:03',NULL),('2025-11-29 05:44:03.492325',NULL,'2025-11-29 05:44:03.503186',958,958,NULL,'aadf0ac5-e947-4e71-b7c4-0061feab880b',265,'bfa506cc517a4cf1bb6dc4bca76155a6','shares',-1,'2025-11-30 05:44:03','1c8161b4-ab6a-46c9-8c73-44780c20ec7e'),('2025-11-29 05:44:03.493220',NULL,'2025-11-29 05:44:03.503186',959,959,NULL,'591c439b-4d10-4816-93be-d282ef072093',264,'bfa506cc517a4cf1bb6dc4bca76155a6','gigabytes',-1,'2025-11-30 05:44:03','1c8161b4-ab6a-46c9-8c73-44780c20ec7e'),('2025-11-29 05:44:06.551552',NULL,'2025-11-29 05:44:06.603413',960,960,'6f7f9251bec644a5bf819843dcf464f5','02944225-79b7-43cb-b0c3-f372660bebd0',263,'bfa506cc517a4cf1bb6dc4bca76155a6','shares',1,'2025-11-30 05:44:06',NULL),('2025-11-29 05:44:06.552720',NULL,'2025-11-29 05:44:06.603413',961,961,'6f7f9251bec644a5bf819843dcf464f5','19139f33-0a9b-4886-b01f-4132a324091d',262,'bfa506cc517a4cf1bb6dc4bca76155a6','gigabytes',1,'2025-11-30 05:44:06',NULL),('2025-11-29 05:44:06.562029',NULL,'2025-11-29 05:44:06.603413',962,962,NULL,'72593735-c0cc-4d80-afdb-6bad5c335df3',265,'bfa506cc517a4cf1bb6dc4bca76155a6','shares',1,'2025-11-30 05:44:06','1c8161b4-ab6a-46c9-8c73-44780c20ec7e'),('2025-11-29 05:44:06.563543',NULL,'2025-11-29 05:44:06.603413',963,963,NULL,'9cc7d283-86d2-4356-a4da-ed4814117b8d',264,'bfa506cc517a4cf1bb6dc4bca76155a6','gigabytes',1,'2025-11-30 05:44:06','1c8161b4-ab6a-46c9-8c73-44780c20ec7e'),('2025-11-29 05:44:10.979742',NULL,'2025-11-29 05:44:11.004729',964,964,'6f7f9251bec644a5bf819843dcf464f5','b594777f-a63c-4edb-918c-dc84828e288b',263,'bfa506cc517a4cf1bb6dc4bca76155a6','shares',-1,'2025-11-30 05:44:10',NULL),('2025-11-29 05:44:10.980441',NULL,'2025-11-29 05:44:11.004729',965,965,'6f7f9251bec644a5bf819843dcf464f5','1784ae52-8e16-4f03-b188-c2573b277ddc',262,'bfa506cc517a4cf1bb6dc4bca76155a6','gigabytes',-1,'2025-11-30 05:44:10',NULL),('2025-11-29 05:44:10.988181',NULL,'2025-11-29 05:44:11.004729',966,966,NULL,'05eb4a78-721e-46c0-9579-bd9be6c23676',265,'bfa506cc517a4cf1bb6dc4bca76155a6','shares',-1,'2025-11-30 05:44:10','1c8161b4-ab6a-46c9-8c73-44780c20ec7e'),('2025-11-29 05:44:10.988967',NULL,'2025-11-29 05:44:11.004729',967,967,NULL,'3bc0c9c7-b23e-4abb-b374-ce2b2a3fa8f8',264,'bfa506cc517a4cf1bb6dc4bca76155a6','gigabytes',-1,'2025-11-30 05:44:10','1c8161b4-ab6a-46c9-8c73-44780c20ec7e'),('2025-11-29 05:44:14.913636',NULL,'2025-11-29 05:44:15.001509',968,968,'6f7f9251bec644a5bf819843dcf464f5','b55f57ff-fc40-40bd-8b53-d8846d2fe81e',266,'bfa506cc517a4cf1bb6dc4bca76155a6','snapshots',-1,'2025-11-30 05:44:14',NULL),('2025-11-29 05:44:14.914562',NULL,'2025-11-29 05:44:15.001509',969,969,'6f7f9251bec644a5bf819843dcf464f5','ff033c0c-081f-41f0-ba70-bd159e68b30c',267,'bfa506cc517a4cf1bb6dc4bca76155a6','snapshot_gigabytes',-1,'2025-11-30 05:44:14',NULL),('2025-11-29 05:44:14.989559',NULL,'2025-11-29 05:44:15.001509',970,970,NULL,'f1fe694b-6885-4fcf-b199-22699e08c1e0',268,'bfa506cc517a4cf1bb6dc4bca76155a6','snapshots',-1,'2025-11-30 05:44:14','1c8161b4-ab6a-46c9-8c73-44780c20ec7e'),('2025-11-29 05:44:14.990781',NULL,'2025-11-29 05:44:15.001509',971,971,NULL,'905945c2-38f6-43f2-a958-2693ad560a72',269,'bfa506cc517a4cf1bb6dc4bca76155a6','snapshot_gigabytes',-1,'2025-11-30 05:44:14','1c8161b4-ab6a-46c9-8c73-44780c20ec7e'),('2025-11-29 05:44:18.019394',NULL,'2025-11-29 05:44:18.033739',972,972,'6f7f9251bec644a5bf819843dcf464f5','8122120a-f18c-4deb-9cf6-fe8e89599f04',263,'bfa506cc517a4cf1bb6dc4bca76155a6','shares',-1,'2025-11-30 05:44:17',NULL),('2025-11-29 05:44:18.020227',NULL,'2025-11-29 05:44:18.033739',973,973,'6f7f9251bec644a5bf819843dcf464f5','85bd7342-a7fc-49bb-883a-29e4d507d7e2',262,'bfa506cc517a4cf1bb6dc4bca76155a6','gigabytes',-1,'2025-11-30 05:44:17',NULL),('2025-11-29 05:44:18.026173',NULL,'2025-11-29 05:44:18.033739',974,974,NULL,'99e0e8a8-3299-4955-8d2f-e79e97cecc8d',265,'bfa506cc517a4cf1bb6dc4bca76155a6','shares',-1,'2025-11-30 05:44:17','1c8161b4-ab6a-46c9-8c73-44780c20ec7e'),('2025-11-29 05:44:18.026965',NULL,'2025-11-29 05:44:18.033739',975,975,NULL,'b666d456-91b0-44fb-a39a-444580768e6e',264,'bfa506cc517a4cf1bb6dc4bca76155a6','gigabytes',-1,'2025-11-30 05:44:17','1c8161b4-ab6a-46c9-8c73-44780c20ec7e');
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `security_services`
--

DROP TABLE IF EXISTS `security_services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `security_services` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `type` varchar(32) NOT NULL,
  `dns_ip` varchar(64) DEFAULT NULL,
  `server` varchar(255) DEFAULT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `user` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `ou` varchar(255) DEFAULT NULL,
  `default_ad_site` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `security_services`
--

LOCK TABLES `security_services` WRITE;
/*!40000 ALTER TABLE `security_services` DISABLE KEYS */;
INSERT INTO `security_services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `project_id`, `type`, `dns_ip`, `server`, `domain`, `user`, `password`, `name`, `description`, `ou`, `default_ad_site`) VALUES ('2025-11-29 05:37:06.634671','2025-11-29 05:37:06.876101','2025-11-29 05:37:06.875688','075d5b99-9d0f-418c-b88f-248a3822e74f','075d5b99-9d0f-418c-b88f-248a3822e74f','44cbf199e9234250a1814295aa8cca3e','ldap','203.0.113.117','203.0.113.223','tempest-ss-domain-122955987','tempest-ss-user-1677947420','tempest-ss-password-1603654939','tempest-ss-name-442361478','tempest-ss-desc-2075099187',NULL,NULL),('2025-11-29 05:35:52.808471','2025-11-29 05:35:53.130725','2025-11-29 05:35:53.129703','0a7f9464-0b23-4e6a-aa5f-8f76bab16b4a','0a7f9464-0b23-4e6a-aa5f-8f76bab16b4a','5611933d70e148b1aa79e29dc5a5b334','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2025-11-29 05:35:51.018225','2025-11-29 05:35:51.170346','2025-11-29 05:35:51.169941','1256c99c-5253-4e0e-b1cd-7f1076bd8812','1256c99c-5253-4e0e-b1cd-7f1076bd8812','5611933d70e148b1aa79e29dc5a5b334','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2025-11-29 05:35:50.403221','2025-11-29 05:35:50.549331','2025-11-29 05:35:50.549008','1301ef7c-080b-4924-98ec-3a10de852475','1301ef7c-080b-4924-98ec-3a10de852475','5611933d70e148b1aa79e29dc5a5b334','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2025-11-29 05:36:55.508772','2025-11-29 05:36:55.588755','2025-11-29 05:36:55.588187','14323a11-7b02-4c86-9519-e8b9581f3e91','14323a11-7b02-4c86-9519-e8b9581f3e91','4debc14b81164a5e91028657eb7e2f9d','active_directory','203.0.113.226','203.0.113.154','tempest-ss-domain-1567026762','tempest-ss-user-1636691262','tempest-ss-password-1058293543','tempest-ss-name-1101855502','tempest-ss-desc-524384811',NULL,NULL),('2025-11-29 05:35:52.213972','2025-11-29 05:35:52.367322','2025-11-29 05:35:52.367027','186864fd-908c-4073-834b-bd16248504b2','186864fd-908c-4073-834b-bd16248504b2','5611933d70e148b1aa79e29dc5a5b334','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2025-11-29 05:36:56.770131','2025-11-29 05:36:57.142421','2025-11-29 05:36:57.141976','1cab052d-0eeb-4d0b-b06f-ff86aa523e10','1cab052d-0eeb-4d0b-b06f-ff86aa523e10','4debc14b81164a5e91028657eb7e2f9d','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-11-29 05:37:01.348637','2025-11-29 05:37:01.493370','2025-11-29 05:37:01.493055','214b8ab2-953c-4e32-bebc-101e3684e3c6','214b8ab2-953c-4e32-bebc-101e3684e3c6','4debc14b81164a5e91028657eb7e2f9d','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-11-29 05:37:03.575198','2025-11-29 05:37:04.071745','2025-11-29 05:37:04.071349','2aa0a250-5a48-4461-a506-f6339506a50f','2aa0a250-5a48-4461-a506-f6339506a50f','4debc14b81164a5e91028657eb7e2f9d','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-11-29 05:40:47.866826','2025-11-29 05:40:47.927116','2025-11-29 05:40:47.926764','2c37f62c-94bd-4340-9bb2-5fff3341ca3a','2c37f62c-94bd-4340-9bb2-5fff3341ca3a','5d4e7782d4324d9996f85cc9d1ed8e57','ldap','203.0.113.44','203.0.113.16','tempest-ss-domain-38210606','tempest-ss-user-1885989116','tempest-ss-password-982723980','tempest-ss-name-44940301','tempest-ss-desc-1291007743',NULL,NULL),('2025-11-29 05:36:56.844571','2025-11-29 05:36:56.934830','2025-11-29 05:36:56.934298','2cc0d858-82cc-41e2-a27c-02dd2f25b4a3','2cc0d858-82cc-41e2-a27c-02dd2f25b4a3','4debc14b81164a5e91028657eb7e2f9d','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-11-29 05:37:05.683468','2025-11-29 05:37:05.895383','2025-11-29 05:37:05.894545','2f093330-5fe6-4def-acfc-968bb64a9cfe','2f093330-5fe6-4def-acfc-968bb64a9cfe','4debc14b81164a5e91028657eb7e2f9d','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-11-29 05:35:52.866435','2025-11-29 05:35:52.993393','2025-11-29 05:35:52.992714','2fdb8564-2c45-4b99-816d-e0081103af07','2fdb8564-2c45-4b99-816d-e0081103af07','5611933d70e148b1aa79e29dc5a5b334','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2025-11-29 05:36:12.087552',NULL,NULL,'False','32e44af5-820e-454d-8a6b-bda2f4821cc0','0448e6e78f8747efb1e6a68338df9866','ldap','203.0.113.210','203.0.113.241','tempest-ss-domain-792135355','tempest-ss-user-2126499133','tempest-ss-password-444706214','tempest-ss-name-1940015984','tempest-ss-desc-451329504',NULL,NULL),('2025-11-29 05:36:55.063959','2025-11-29 05:36:56.331050','2025-11-29 05:36:56.330596','33cb1270-3c3d-4b2d-90a8-e12f179bb3d5','33cb1270-3c3d-4b2d-90a8-e12f179bb3d5','4debc14b81164a5e91028657eb7e2f9d','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-11-29 05:36:58.734912','2025-11-29 05:36:58.884007','2025-11-29 05:36:58.883519','353789e1-9f04-43d2-8ede-7e375bc814be','353789e1-9f04-43d2-8ede-7e375bc814be','4debc14b81164a5e91028657eb7e2f9d','ldap','203.0.113.229','203.0.113.101','tempest-ss-domain-2000305738','tempest-ss-user-1052040451','tempest-ss-password-697827276','tempest-ss-name-2022670653','tempest-ss-desc-141255757','tempest-ss-ou-262294772',NULL),('2025-11-29 05:36:55.336419','2025-11-29 05:36:55.425930','2025-11-29 05:36:55.425623','355c1b24-dd9a-4d2b-9ab4-1089a6bc3626','355c1b24-dd9a-4d2b-9ab4-1089a6bc3626','4debc14b81164a5e91028657eb7e2f9d','kerberos','203.0.113.226','203.0.113.154','tempest-ss-domain-1567026762','tempest-ss-user-1636691262','tempest-ss-password-1058293543','tempest-ss-name-1101855502','tempest-ss-desc-524384811',NULL,NULL),('2025-11-29 05:42:13.812722','2025-11-29 05:42:14.212265','2025-11-29 05:42:14.211905','3824d793-9cfe-4882-8bac-225ba572846f','3824d793-9cfe-4882-8bac-225ba572846f','eeaea5e509ca49be9d6a48ac7d8668b4','ldap','203.0.113.215','203.0.113.87','tempest-ss-domain-2007290010','tempest-ss-user-461304876','tempest-ss-password-2098946104','tempest-ss-name-446648167','tempest-ss-desc-1685639490',NULL,NULL),('2025-11-29 05:40:57.387987',NULL,NULL,'False','38e7fb5c-7172-46dc-9274-dbc11b1221fe','9874b59670af413eabb2bba650c69242','ldap','203.0.113.80','203.0.113.141','tempest-ss-domain-547385769','tempest-ss-user-1947841590','tempest-ss-password-1278690562','tempest-ss-name-208201667','tempest-ss-desc-569994049',NULL,NULL),('2025-11-29 05:42:14.819199','2025-11-29 05:42:15.063730','2025-11-29 05:42:15.063248','428c71d6-6cca-47fe-b00c-b0d0e3abbcfb','428c71d6-6cca-47fe-b00c-b0d0e3abbcfb','eeaea5e509ca49be9d6a48ac7d8668b4','ldap','203.0.113.106','203.0.113.192','tempest-ss-domain-1726852775','tempest-ss-user-1895724282','tempest-ss-password-1628166783','tempest-ss-name-2112622126','tempest-ss-desc-760705071',NULL,NULL),('2025-11-29 05:37:03.673838','2025-11-29 05:37:03.925093','2025-11-29 05:37:03.924610','4a44eb32-dfb6-4ac6-a258-4509f7733b59','4a44eb32-dfb6-4ac6-a258-4509f7733b59','4debc14b81164a5e91028657eb7e2f9d','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-11-29 05:36:57.259318','2025-11-29 05:36:58.231260','2025-11-29 05:36:58.230252','4e2cb818-ebec-4eb2-b7c1-7d991e569a2c','4e2cb818-ebec-4eb2-b7c1-7d991e569a2c','4debc14b81164a5e91028657eb7e2f9d','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-11-29 05:37:04.332030','2025-11-29 05:37:04.510063','2025-11-29 05:37:04.509719','4eb95d9f-03b9-4d32-8c34-eb8ca35e53cd','4eb95d9f-03b9-4d32-8c34-eb8ca35e53cd','4debc14b81164a5e91028657eb7e2f9d','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-11-29 05:37:05.626615','2025-11-29 05:37:06.198400','2025-11-29 05:37:06.197980','5408e637-134e-4638-81ba-062fba055f5d','5408e637-134e-4638-81ba-062fba055f5d','4debc14b81164a5e91028657eb7e2f9d','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-11-29 05:37:01.198498','2025-11-29 05:37:01.908264','2025-11-29 05:37:01.907882','5d9281f7-6118-4b2b-9dfa-d9dadd37f67c','5d9281f7-6118-4b2b-9dfa-d9dadd37f67c','4debc14b81164a5e91028657eb7e2f9d','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-11-29 05:36:58.602936','2025-11-29 05:36:59.453878','2025-11-29 05:36:59.453549','5fb0e4df-2187-417b-942b-39bc219e00dd','5fb0e4df-2187-417b-942b-39bc219e00dd','4debc14b81164a5e91028657eb7e2f9d','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-11-29 05:36:59.790463','2025-11-29 05:37:00.404511','2025-11-29 05:37:00.404136','62a2b39c-65ee-45e2-883c-e3081b25bb59','62a2b39c-65ee-45e2-883c-e3081b25bb59','4debc14b81164a5e91028657eb7e2f9d','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-11-29 05:37:06.446487','2025-11-29 05:37:07.128163','2025-11-29 05:37:07.127722','63cacb6e-2a6e-46bc-a6a3-fbe99be8764d','63cacb6e-2a6e-46bc-a6a3-fbe99be8764d','4debc14b81164a5e91028657eb7e2f9d','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-11-29 05:35:52.149108','2025-11-29 05:35:52.542453','2025-11-29 05:35:52.542131','7c2b45b1-45e6-4c95-8f63-2561448b81f6','7c2b45b1-45e6-4c95-8f63-2561448b81f6','5611933d70e148b1aa79e29dc5a5b334','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2025-11-29 05:39:24.196599',NULL,NULL,'False','7db487bf-52b0-4728-854a-0a3965da721c','423449a1e9f94864bc4aa1e26a05fb40','ldap','203.0.113.246','203.0.113.73','tempest-ss-domain-1925481786','tempest-ss-user-469486001','tempest-ss-password-1393091530','tempest-ss-name-1864577702','tempest-ss-desc-154203071',NULL,NULL),('2025-11-29 05:35:51.716633','2025-11-29 05:35:51.785278','2025-11-29 05:35:51.784909','7dee42c6-0ea7-4b3e-9f84-51423ea3e37d','7dee42c6-0ea7-4b3e-9f84-51423ea3e37d','5611933d70e148b1aa79e29dc5a5b334','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2025-11-29 05:39:23.356246','2025-11-29 05:39:23.605297','2025-11-29 05:39:23.604909','7e2ead46-45f0-49c1-8c92-cd6b5f5b4931','7e2ead46-45f0-49c1-8c92-cd6b5f5b4931','423449a1e9f94864bc4aa1e26a05fb40','ldap','203.0.113.225','203.0.113.162','tempest-ss-domain-1326477198','tempest-ss-user-1784772352','tempest-ss-password-1770449403','tempest-ss-name-460159982','tempest-ss-desc-1080464716',NULL,NULL),('2025-11-29 05:35:48.742147','2025-11-29 05:35:48.941020','2025-11-29 05:35:48.939840','81acb751-b7d6-4d83-8ee1-fd58f7e1570a','81acb751-b7d6-4d83-8ee1-fd58f7e1570a','5611933d70e148b1aa79e29dc5a5b334','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2025-11-29 05:37:04.873165','2025-11-29 05:37:05.499446','2025-11-29 05:37:05.499153','8afadb22-612c-4c29-b725-2c7d65acee89','8afadb22-612c-4c29-b725-2c7d65acee89','4debc14b81164a5e91028657eb7e2f9d','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-11-29 05:37:02.981875','2025-11-29 05:37:03.160415','2025-11-29 05:37:03.159830','9211e783-ea75-4186-b542-d340dd2e0c0a','9211e783-ea75-4186-b542-d340dd2e0c0a','4debc14b81164a5e91028657eb7e2f9d','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-11-29 05:42:14.753158',NULL,NULL,'False','960832bd-8f66-4854-9ab8-2d3ae0918964','eeaea5e509ca49be9d6a48ac7d8668b4','ldap','203.0.113.207','203.0.113.209','tempest-ss-domain-1896878712','tempest-ss-user-320957304','tempest-ss-password-19818526','tempest-ss-name-1409082646','tempest-ss-desc-50210621',NULL,NULL),('2025-11-29 05:42:12.579276',NULL,NULL,'False','9c2815f1-fde0-4314-8565-743215baf771','eeaea5e509ca49be9d6a48ac7d8668b4','ldap',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-29 05:35:53.246764','2025-11-29 05:35:53.684762','2025-11-29 05:35:53.684422','9cd6c8a4-e8e1-4a93-a92f-dbff3b9f12ae','9cd6c8a4-e8e1-4a93-a92f-dbff3b9f12ae','5611933d70e148b1aa79e29dc5a5b334','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2025-11-29 05:37:07.986725','2025-11-29 05:37:08.516096','2025-11-29 05:37:08.515752','9e71bc20-7a7a-4814-8d22-0d7a1fd70f7d','9e71bc20-7a7a-4814-8d22-0d7a1fd70f7d','4debc14b81164a5e91028657eb7e2f9d','ldap','203.0.113.65','203.0.113.153','tempest-ss-domain-1511698549','tempest-ss-user-1642398821','tempest-ss-password-1290622843','tempest-ss-name-1637375509','tempest-ss-desc-1079705144','tempest-ss-ou-1150885342',NULL),('2025-11-29 05:39:25.022719',NULL,NULL,'False','a68243e1-45fa-4857-8a7a-bef62873bdb8','423449a1e9f94864bc4aa1e26a05fb40','ldap','203.0.113.217','203.0.113.71','tempest-ss-domain-430108302','tempest-ss-user-626965298','tempest-ss-password-1273252956','tempest-ss-name-1695408796','tempest-ss-desc-1369356890',NULL,NULL),('2025-11-29 05:36:55.142958','2025-11-29 05:36:55.238349','2025-11-29 05:36:55.237935','a8b791ce-3b3e-4d8c-9b19-fff72cb6325b','a8b791ce-3b3e-4d8c-9b19-fff72cb6325b','4debc14b81164a5e91028657eb7e2f9d','ldap','203.0.113.226','203.0.113.154','tempest-ss-domain-1567026762','tempest-ss-user-1636691262','tempest-ss-password-1058293543','tempest-ss-name-1101855502','tempest-ss-desc-524384811',NULL,NULL),('2025-11-29 05:37:02.307578','2025-11-29 05:37:02.447381','2025-11-29 05:37:02.446982','ab3b2716-5148-4051-a637-23a3b581d864','ab3b2716-5148-4051-a637-23a3b581d864','4debc14b81164a5e91028657eb7e2f9d','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-11-29 05:35:53.298697','2025-11-29 05:35:53.423936','2025-11-29 05:35:53.423519','aba23fd3-4db5-467a-abbc-1d8ad37d7e88','aba23fd3-4db5-467a-abbc-1d8ad37d7e88','5611933d70e148b1aa79e29dc5a5b334','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2002-02-02 00:00:00.000000',NULL,NULL,'False','add841a3-f305-4710-88de-7bed736a1c54','061705ddc30c4a188ae026c064f1a2b8','kerberos',NULL,NULL,NULL,NULL,NULL,'sn_with_ldap_ss','fake description',NULL,NULL),('2025-11-29 05:36:57.334726','2025-11-29 05:36:57.936448','2025-11-29 05:36:57.936139','b264abed-fb71-4847-b9f8-5d57d618f753','b264abed-fb71-4847-b9f8-5d57d618f753','4debc14b81164a5e91028657eb7e2f9d','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-11-29 05:37:07.838072','2025-11-29 05:37:08.828253','2025-11-29 05:37:08.827942','b3bc232c-6763-49f0-b4a3-70d665fcc6b6','b3bc232c-6763-49f0-b4a3-70d665fcc6b6','4debc14b81164a5e91028657eb7e2f9d','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-11-29 05:37:06.361725','2025-11-29 05:37:07.553134','2025-11-29 05:37:07.552655','b4bd6af4-a664-4fcb-829e-3e42b135423b','b4bd6af4-a664-4fcb-829e-3e42b135423b','4debc14b81164a5e91028657eb7e2f9d','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2002-02-02 00:00:00.000000',NULL,NULL,'False','b8cbd9d3-c944-4a40-aefb-04c6694ee8b9','9874b59670af413eabb2bba650c69242','kerberos',NULL,NULL,NULL,NULL,NULL,'sn_with_ldap_ss','fake description',NULL,NULL),('2025-11-29 05:36:57.485614','2025-11-29 05:36:57.712755','2025-11-29 05:36:57.712420','ba9490ea-56dc-4daf-8dcc-f481407d84ac','ba9490ea-56dc-4daf-8dcc-f481407d84ac','4debc14b81164a5e91028657eb7e2f9d','ldap','203.0.113.131','203.0.113.16','tempest-ss-domain-1620232474','tempest-ss-user-2113563390','tempest-ss-password-833020632','tempest-ss-name-805029899','tempest-ss-desc-1681711780',NULL,NULL),('2025-11-29 05:37:05.004675','2025-11-29 05:37:05.329224','2025-11-29 05:37:05.328909','bbd3ffa5-aabd-4c7a-8c31-00bd192c2370','bbd3ffa5-aabd-4c7a-8c31-00bd192c2370','4debc14b81164a5e91028657eb7e2f9d','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-11-29 05:37:02.802403','2025-11-29 05:37:03.327679','2025-11-29 05:37:03.327296','be0863d8-cef7-46ce-ac2b-7cdb37955925','be0863d8-cef7-46ce-ac2b-7cdb37955925','4debc14b81164a5e91028657eb7e2f9d','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-11-29 05:35:49.379900','2025-11-29 05:35:49.963282','2025-11-29 05:35:49.958590','c0251079-af0a-4998-8c2a-07668edd1ff3','c0251079-af0a-4998-8c2a-07668edd1ff3','5611933d70e148b1aa79e29dc5a5b334','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2025-11-29 05:35:49.466468','2025-11-29 05:35:49.798681','2025-11-29 05:35:49.798337','cb8f43e7-804d-4ed5-aed7-5b99c3145ddd','cb8f43e7-804d-4ed5-aed7-5b99c3145ddd','5611933d70e148b1aa79e29dc5a5b334','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2025-11-29 05:36:59.893397','2025-11-29 05:37:00.111692','2025-11-29 05:37:00.111133','d0137ba7-18f8-44d5-af87-436abeafa4a2','d0137ba7-18f8-44d5-af87-436abeafa4a2','4debc14b81164a5e91028657eb7e2f9d','ldap','203.0.113.115','203.0.113.189','tempest-ss-domain-1798444523','tempest-ss-user-1590323067','tempest-ss-password-1735153501','tempest-ss-name-1169292917','tempest-ss-desc-2040331003','tempest-ss-ou-1643028595',NULL),('2025-11-29 05:35:50.933102','2025-11-29 05:35:51.432035','2025-11-29 05:35:51.431503','d0693148-449d-4808-b880-6959289153f7','d0693148-449d-4808-b880-6959289153f7','5611933d70e148b1aa79e29dc5a5b334','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2025-11-29 05:35:51.567782','2025-11-29 05:35:51.929622','2025-11-29 05:35:51.929176','da43e395-3fbf-4fe6-8d7e-56158ca4d687','da43e395-3fbf-4fe6-8d7e-56158ca4d687','5611933d70e148b1aa79e29dc5a5b334','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2025-11-29 05:36:54.905716','2025-11-29 05:36:56.446327','2025-11-29 05:36:56.446017','de3ffe2b-dad2-41aa-a3f3-668bc25a90df','de3ffe2b-dad2-41aa-a3f3-668bc25a90df','4debc14b81164a5e91028657eb7e2f9d','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-11-29 05:35:48.639956','2025-11-29 05:35:49.130029','2025-11-29 05:35:49.129052','e2ee28d0-f52a-469e-b126-4489c317688d','e2ee28d0-f52a-469e-b126-4489c317688d','5611933d70e148b1aa79e29dc5a5b334','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2025-11-29 05:36:58.663773','2025-11-29 05:36:59.203383','2025-11-29 05:36:59.202976','e4ada3f1-695e-4432-821a-6623a41c8523','e4ada3f1-695e-4432-821a-6623a41c8523','4debc14b81164a5e91028657eb7e2f9d','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-11-29 05:35:50.207350','2025-11-29 05:35:50.808452','2025-11-29 05:35:50.808143','ec88e3cf-9a12-47bf-9708-e2537c665f6c','ec88e3cf-9a12-47bf-9708-e2537c665f6c','5611933d70e148b1aa79e29dc5a5b334','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2025-11-29 05:37:04.197304','2025-11-29 05:37:04.680214','2025-11-29 05:37:04.679748','f3fb5791-7201-4448-b649-97ad1fd24f66','f3fb5791-7201-4448-b649-97ad1fd24f66','4debc14b81164a5e91028657eb7e2f9d','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-11-29 05:37:02.128859','2025-11-29 05:37:02.625731','2025-11-29 05:37:02.625410','fdc9836f-f1b8-4318-872b-725f644c8ceb','fdc9836f-f1b8-4318-872b-725f644c8ceb','4debc14b81164a5e91028657eb7e2f9d','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-11-29 05:36:59.651427','2025-11-29 05:37:00.587198','2025-11-29 05:37:00.586732','feb8c7ef-3a84-4445-ada2-5245dd096c41','feb8c7ef-3a84-4445-ada2-5245dd096c41','4debc14b81164a5e91028657eb7e2f9d','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-11-29 05:37:07.926299','2025-11-29 05:37:08.694866','2025-11-29 05:37:08.694432','ff34bcdf-1b29-47b4-86ca-c55ee85e4364','ff34bcdf-1b29-47b4-86ca-c55ee85e4364','4debc14b81164a5e91028657eb7e2f9d','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL);
/*!40000 ALTER TABLE `security_services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  `state` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `service_az_id_fk` (`availability_zone_id`),
  CONSTRAINT `service_az_id_fk` FOREIGN KEY (`availability_zone_id`) REFERENCES `availability_zones` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone_id`, `state`) VALUES ('2025-11-29 05:29:24.775730','2025-11-29 05:58:01.866332',NULL,0,1,'hostgroup','manila-scheduler','manila-scheduler',171,0,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','up'),('2025-11-29 05:29:33.021244','2025-11-29 05:58:03.257260',NULL,0,2,'hostgroup@cephfs','manila-share','manila-share',170,0,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','up');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_access_map`
--

DROP TABLE IF EXISTS `share_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_access_map` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `share_id` varchar(36) NOT NULL,
  `access_type` varchar(255) DEFAULT NULL,
  `access_to` varchar(255) DEFAULT NULL,
  `access_level` varchar(2) DEFAULT NULL,
  `access_key` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `share_id` (`share_id`),
  CONSTRAINT `share_access_map_ibfk_1` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_access_map`
--

LOCK TABLES `share_access_map` WRITE;
/*!40000 ALTER TABLE `share_access_map` DISABLE KEYS */;
INSERT INTO `share_access_map` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_id`, `access_type`, `access_to`, `access_level`, `access_key`) VALUES ('2025-11-29 05:39:58.083998','2025-11-29 05:40:02.327329','2025-11-29 05:40:29.309263','05829d2f-e322-477b-8aea-7c582f79d184','05829d2f-e322-477b-8aea-7c582f79d184','ac81ac86-8832-44a3-9ddf-a1f9548b23ff','cephx','tempest-cephx-id-887052356','rw','AQAuhyppAI0UGhAAfs5ZHLQSTkmYH+jlK9tV1Q=='),('2025-11-29 05:39:30.368092','2025-11-29 05:39:34.139272','2025-11-29 05:39:34.440923','0d48533d-0ef0-43d3-8c13-59b7bf8b3f3f','0d48533d-0ef0-43d3-8c13-59b7bf8b3f3f','072f020d-2708-48db-82b6-eb693c43a81c','cephx','tempest-cephx-id-887052356','rw','AQAShypp1nMtLBAAwMc/HjMXzhxO8uOKt+s9yQ=='),('2025-11-29 05:40:52.555348','2025-11-29 05:40:59.892463','2025-11-29 05:41:35.952224','11f59548-5d58-4b5c-8a75-a224dc65dcbb','11f59548-5d58-4b5c-8a75-a224dc65dcbb','60a27966-8e4b-44f9-8615-a66683748b87','cephx','Joe','rw',NULL),('2025-11-29 05:39:55.113690','2025-11-29 05:39:59.374868','2025-11-29 05:40:36.398995','1a9bd3ee-2e6e-4baa-be02-4412dc53d324','1a9bd3ee-2e6e-4baa-be02-4412dc53d324','d912f612-c8b0-4a4b-8ff9-2bb505956267','cephx','alice_bob','ro','AQAshyppMeU+BBAAPJcVAl661605LdFwj2/eqQ=='),('2025-11-29 05:40:05.685467','2025-11-29 05:40:09.684870','2025-11-29 05:40:29.309263','1eadbcb4-634e-40b3-a81b-dc8c00c0405b','1eadbcb4-634e-40b3-a81b-dc8c00c0405b','ac81ac86-8832-44a3-9ddf-a1f9548b23ff','cephx','tempest-cephx-id-887052356','rw','AQA2hypp3vXKBBAAxJrHfah+Qx3KUk9bxih0UQ=='),('2025-11-29 05:39:40.771674','2025-11-29 05:39:44.320969','2025-11-29 05:39:44.722929','1ed75037-c229-4073-bd95-59c05f32ce0e','1ed75037-c229-4073-bd95-59c05f32ce0e','66a749f8-4cee-4a3e-8e40-a020973a1d4e','cephx','tempest-cephx-id-887052356','rw','AQAfhypp3oK/DxAAh1ANTuDq7n3QZkAGsWxEkA=='),('2025-11-29 05:37:22.704847','2025-11-29 05:37:26.566510','2025-11-29 05:40:36.398995','2151a973-209b-4632-8a89-bb6281fa263d','2151a973-209b-4632-8a89-bb6281fa263d','d912f612-c8b0-4a4b-8ff9-2bb505956267','cephx','alice','rw','AQCThippNQs1BRAAt/iUsiCl9PkxCVUkBNGuuQ=='),('2025-11-29 05:38:09.381534','2025-11-29 05:38:13.752645','2025-11-29 05:38:18.651510','26d1c21b-c729-467d-a349-44baa7667fdd','26d1c21b-c729-467d-a349-44baa7667fdd','1cd9a707-7d70-4c62-ba13-512b8025fb75','cephx','eve47','rw','AQDChippy0HdBBAA0emp/6foP8+Dw64cQ4za4A=='),('2025-11-29 05:38:56.965471','2025-11-29 05:39:00.990575','2025-11-29 05:40:36.398995','2bb3af8f-3fbf-43b8-a73e-32e520b26188','2bb3af8f-3fbf-43b8-a73e-32e520b26188','d912f612-c8b0-4a4b-8ff9-2bb505956267','cephx','alice','ro','AQDxhippbx5BEhAAhocYiP3xfoSsz/tO0cDHFA=='),('2025-11-29 05:39:41.458570','2025-11-29 05:39:45.022846','2025-11-29 05:40:36.398995','35d66830-fe56-4dd5-a557-6cd9604981f2','35d66830-fe56-4dd5-a557-6cd9604981f2','d912f612-c8b0-4a4b-8ff9-2bb505956267','cephx','alice','ro','AQAfhypp0UuHFRAAh9wAURIJuGKopJnun6dnXg=='),('2025-11-29 05:38:27.576208','2025-11-29 05:38:31.723398','2025-11-29 05:40:36.398995','3a1fb528-cf19-43ca-bcdf-a209e9bc8995','3a1fb528-cf19-43ca-bcdf-a209e9bc8995','d912f612-c8b0-4a4b-8ff9-2bb505956267','cephx','alice_bob','ro','AQDThipp8j5QNxAAVf/NaZJWmqCuqG+FBtp7EQ=='),('2025-11-29 05:39:20.620471','2025-11-29 05:39:24.442302','2025-11-29 05:40:36.398995','3d4545b1-468c-43b5-8a1c-513e2add120e','3d4545b1-468c-43b5-8a1c-513e2add120e','d912f612-c8b0-4a4b-8ff9-2bb505956267','cephx','alice bob','rw','AQAIhypposfqORAAJs7CsB0xDRNNuUrD/5lOPw=='),('2025-11-29 05:38:35.626041','2025-11-29 05:38:37.490478','2025-11-29 05:38:37.926332','4578fc0a-e603-4fa6-8bc1-969e949cf674','4578fc0a-e603-4fa6-8bc1-969e949cf674','32b3bd55-f887-4c7b-abf3-c0e58448cfc0','cephx','tempest-cephx-id-2083182201','rw','AQDchippaejELhAAMjO+BhKtqoEvbFljvyuU8w=='),('2025-11-29 05:39:34.535466','2025-11-29 05:39:38.275277','2025-11-29 05:40:36.398995','52c3d83d-ff52-44ce-b493-1bf41790a63d','52c3d83d-ff52-44ce-b493-1bf41790a63d','d912f612-c8b0-4a4b-8ff9-2bb505956267','cephx','alice','rw','AQAWhyppFyF7LhAAzysEg9m1UFIq2ljBLyanYg=='),('2025-11-29 05:40:09.891476','2025-11-29 05:40:13.828007','2025-11-29 05:40:36.398995','54a9a42c-e70b-4f81-ad6f-2f5c6ad9397b','54a9a42c-e70b-4f81-ad6f-2f5c6ad9397b','d912f612-c8b0-4a4b-8ff9-2bb505956267','cephx','alice bob','ro','AQA6hyppPGrVGBAAzT3NKqiG9qWqaP441Yh63Q=='),('2025-11-29 05:41:10.231871','2025-11-29 05:41:43.010866','2025-11-29 05:41:43.289206','655035ad-6967-43e2-9507-c55e9c8d9567','655035ad-6967-43e2-9507-c55e9c8d9567','b21dc5b7-b92a-4537-a1e9-9593006a005c','cephx','admin','rw',NULL),('2025-11-29 05:37:58.620983','2025-11-29 05:38:18.055294','2025-11-29 05:38:18.651510','683384a4-150b-4e1a-afd1-2d18e025b5ec','683384a4-150b-4e1a-afd1-2d18e025b5ec','1cd9a707-7d70-4c62-ba13-512b8025fb75','cephx','eve49','rw','AQC3hippXvk+ABAACd5cGfWN3vO1Ts8+Z2W6Rw=='),('2025-11-29 05:41:21.105409','2025-11-29 05:41:24.973289','2025-11-29 05:41:33.102227','72eadd53-1128-4512-ac26-4cb4ea626ad8','72eadd53-1128-4512-ac26-4cb4ea626ad8','61d56d6b-329f-4294-9bd8-fc4c72035af0','cephx','david','rw',NULL),('2025-11-29 05:38:02.082485','2025-11-29 05:38:06.105499','2025-11-29 05:38:18.651510','7cd4880d-cec6-4fa5-86ab-55029e2557a5','7cd4880d-cec6-4fa5-86ab-55029e2557a5','1cd9a707-7d70-4c62-ba13-512b8025fb75','cephx','eve48','rw','AQC6hippBwfwFxAAgFq2WAm8RwIbJ61nDeXsnA=='),('2025-11-29 05:37:58.783786','2025-11-29 05:38:02.621745','2025-11-29 05:40:36.398995','8108ab18-8798-4d85-8a83-3f1467ecae8b','8108ab18-8798-4d85-8a83-3f1467ecae8b','d912f612-c8b0-4a4b-8ff9-2bb505956267','cephx','alice bob','ro','AQC3hippUWGAChAAgaSBTMogMliAOM8JuT3b5g=='),('2025-11-29 05:40:45.112123','2025-11-29 05:41:06.956922','2025-11-29 05:41:39.443814','835edcae-d7d8-4727-9159-f3332fe6a638','835edcae-d7d8-4727-9159-f3332fe6a638','fb8bde6a-ba22-4cf8-9b0e-5314b29c6a6c','cephx','Joe','rw','AQBdhyppyT8aGxAABQIezi5pAcr0N91iBKSZ5Q=='),('2025-11-29 05:38:49.916096','2025-11-29 05:38:53.724988','2025-11-29 05:40:36.398995','85ba7916-7733-411a-87f5-7ed780267488','85ba7916-7733-411a-87f5-7ed780267488','d912f612-c8b0-4a4b-8ff9-2bb505956267','cephx','alice','rw','AQDqhipposfpNxAA/XGzwz8bXWkcPJ2xY3FOJg=='),('2025-11-29 05:39:13.190564','2025-11-29 05:39:17.049059','2025-11-29 05:40:36.398995','8851b15b-ced1-4c35-9fca-7e1326f35d67','8851b15b-ced1-4c35-9fca-7e1326f35d67','d912f612-c8b0-4a4b-8ff9-2bb505956267','cephx','alice_bob','ro','AQABhyppjwGQIRAA9x1L5kbIHmG+4Nn2ACiF8w=='),('2025-11-29 05:40:20.637497','2025-11-29 05:40:24.564115','2025-11-29 05:40:29.309263','8bff3ada-1614-4535-a17f-24926ceb641c','8bff3ada-1614-4535-a17f-24926ceb641c','ac81ac86-8832-44a3-9ddf-a1f9548b23ff','cephx','tempest-cephx-id-887052356','rw','AQBHhypp0qLfGhAA9l49aohhZ/GSj6UbAD6svw=='),('2025-11-29 05:39:04.383166','2025-11-29 05:39:09.749377','2025-11-29 05:40:36.398995','9047c430-b33a-40db-934c-076fb9410fa9','9047c430-b33a-40db-934c-076fb9410fa9','d912f612-c8b0-4a4b-8ff9-2bb505956267','cephx','alice_bob','rw','AQD4hippJVLjKRAANBEaiIS1MQslwrwyGv11PA=='),('2025-11-29 05:41:14.077299','2025-11-29 05:41:28.339308','2025-11-29 05:41:43.289206','97346405-2f91-4bac-9082-2fb29f0230ac','97346405-2f91-4bac-9082-2fb29f0230ac','b21dc5b7-b92a-4537-a1e9-9593006a005c','cephx','david','rw','AQB6hyppAh6/FBAARhphJwVKnm5bIiDPtwpCUA=='),('2025-11-29 05:37:29.872971','2025-11-29 05:37:33.682710','2025-11-29 05:40:36.398995','97cf6d2c-e6cb-4c1c-9607-5c44795d0e43','97cf6d2c-e6cb-4c1c-9607-5c44795d0e43','d912f612-c8b0-4a4b-8ff9-2bb505956267','cephx','alice','ro','AQCahippWdrYEBAATI0WQ3muJutT4m3hG/bx+w=='),('2025-11-29 05:37:44.142401','2025-11-29 05:37:48.383159','2025-11-29 05:40:36.398995','aff2062b-997f-4d8e-bf68-1db221b0ef58','aff2062b-997f-4d8e-bf68-1db221b0ef58','d912f612-c8b0-4a4b-8ff9-2bb505956267','cephx','alice_bob','ro','AQCohippIAutFhAAjDUuDfKodSSDNFo8+MgAzg=='),('2025-11-29 05:39:51.022903','2025-11-29 05:39:54.793535','2025-11-29 05:39:55.872715','b87c4b01-93a8-4b04-8990-9505df9470b6','b87c4b01-93a8-4b04-8990-9505df9470b6','b5867587-3de3-43e0-8f9e-a5b7de6bde54','cephx','tempest-cephx-id-887052356','rw','AQAnhyppJWcZEhAABYiJuloTjwMsogpqwN3Bxg=='),('2025-11-29 05:38:12.980648','2025-11-29 05:38:16.875632','2025-11-29 05:40:36.398995','b91a8a46-8b89-4b97-9458-e49eef3084ce','b91a8a46-8b89-4b97-9458-e49eef3084ce','d912f612-c8b0-4a4b-8ff9-2bb505956267','cephx','alice','ro','AQDFhippTnc4GhAAk+7OxHesIgrJVFXrKy19hQ=='),('2025-11-29 05:38:42.285536','2025-11-29 05:38:46.464469','2025-11-29 05:40:36.398995','bef8e005-dafd-4127-8a05-69df48542250','bef8e005-dafd-4127-8a05-69df48542250','d912f612-c8b0-4a4b-8ff9-2bb505956267','cephx','alice bob','ro','AQDihipp8DbkKRAA0vwj1U3nCt/mLQraZKuHFw=='),('2025-11-29 05:40:56.182304','2025-11-29 05:41:03.379805','2025-11-29 05:41:35.952224','c500c339-d533-4fc1-ad10-6bfcb1a441fb','c500c339-d533-4fc1-ad10-6bfcb1a441fb','60a27966-8e4b-44f9-8615-a66683748b87','cephx','tempest-cephx-id-2011883581','rw','AQBohyppEoanNRAAzOMhI7yuS/KxPn/mH8vyIA=='),('2025-11-29 05:40:25.153697','2025-11-29 05:40:28.748192','2025-11-29 05:40:29.209951','c58c1388-b10f-4b98-8b3b-0640ba3eb2bc','c58c1388-b10f-4b98-8b3b-0640ba3eb2bc','7bbfdea3-8114-4f5d-b029-3762625f5bc7','cephx','bob','rw','AQBBhypp5ZnrIBAAUhdasktedh4MqwGsDhVFhA=='),('2025-11-29 05:40:17.192686','2025-11-29 05:40:32.170223','2025-11-29 05:40:36.398995','d4b00d6e-807a-42e6-bd8b-df99d6421cb1','d4b00d6e-807a-42e6-bd8b-df99d6421cb1','d912f612-c8b0-4a4b-8ff9-2bb505956267','cephx','bob','rw','AQBBhypp5ZnrIBAAUhdasktedh4MqwGsDhVFhA=='),('2025-11-29 05:40:13.322435','2025-11-29 05:40:17.419962','2025-11-29 05:40:29.309263','df40c5dd-2e98-4a4f-9502-83c919293907','df40c5dd-2e98-4a4f-9502-83c919293907','ac81ac86-8832-44a3-9ddf-a1f9548b23ff','cephx','tempest-cephx-id-887052356','rw','AQA9hypp45HIKxAAcPuYIt3B2bMIXGHQMELuJA=='),('2025-11-29 05:37:36.970534','2025-11-29 05:37:40.776521','2025-11-29 05:40:36.398995','e479b3cf-d76b-436d-bf72-03ba66f10462','e479b3cf-d76b-436d-bf72-03ba66f10462','d912f612-c8b0-4a4b-8ff9-2bb505956267','cephx','alice_bob','rw','AQChhippL6wWExAAEdIFuzd56uhProQumZTw5Q=='),('2025-11-29 05:38:05.831650','2025-11-29 05:38:09.743206','2025-11-29 05:40:36.398995','e9aa152a-7f3e-4340-9fb6-adc99e532641','e9aa152a-7f3e-4340-9fb6-adc99e532641','d912f612-c8b0-4a4b-8ff9-2bb505956267','cephx','alice','rw','AQC+hipp/OmrDxAAQ40fJ/pJgqrQ0RS4+wpJyQ=='),('2025-11-29 05:40:02.558304','2025-11-29 05:40:06.397026','2025-11-29 05:40:36.398995','eb8ac43e-b65f-4b25-bccd-9765cc5865ab','eb8ac43e-b65f-4b25-bccd-9765cc5865ab','d912f612-c8b0-4a4b-8ff9-2bb505956267','cephx','alice bob','rw','AQAyhypp7trfMxAAlKozUVxEZlKyfLus8PSQ1w=='),('2025-11-29 05:38:20.256702','2025-11-29 05:38:24.171899','2025-11-29 05:40:36.398995','f079399f-2f0b-41b5-8481-a615768e7f84','f079399f-2f0b-41b5-8481-a615768e7f84','d912f612-c8b0-4a4b-8ff9-2bb505956267','cephx','alice_bob','rw','AQDMhipp7agrIBAA6bPg+RcNOIxTySOjJYRtaQ=='),('2025-11-29 05:39:27.684809','2025-11-29 05:39:31.327034','2025-11-29 05:40:36.398995','f66af744-3107-4f23-9d2d-8aa81b5bbfe1','f66af744-3107-4f23-9d2d-8aa81b5bbfe1','d912f612-c8b0-4a4b-8ff9-2bb505956267','cephx','alice bob','ro','AQAPhyppGPglOhAARBNL+98RINqLarHwsM7nJw=='),('2025-11-29 05:37:51.788545','2025-11-29 05:37:55.519874','2025-11-29 05:40:36.398995','fc3a89b4-9d85-429b-8fb2-1bab0746216b','fc3a89b4-9d85-429b-8fb2-1bab0746216b','d912f612-c8b0-4a4b-8ff9-2bb505956267','cephx','alice bob','rw','AQCwhippIRQ/BhAA+ApOkMqerqS4iPGPqCww1w=='),('2025-11-29 05:38:35.049720','2025-11-29 05:38:38.975907','2025-11-29 05:40:36.398995','fef0cf00-ab9b-4909-9426-8bfcac7cda08','fef0cf00-ab9b-4909-9426-8bfcac7cda08','d912f612-c8b0-4a4b-8ff9-2bb505956267','cephx','alice bob','rw','AQDchippvtNXAxAACLdsgmH8yQqJgYfGahfDsg=='),('2025-11-29 05:39:48.167103','2025-11-29 05:39:51.786867','2025-11-29 05:40:36.398995','ffb2afef-9699-4e08-aa9b-dbf5cc830679','ffb2afef-9699-4e08-aa9b-dbf5cc830679','d912f612-c8b0-4a4b-8ff9-2bb505956267','cephx','alice_bob','rw','AQAkhyppGSoZGhAAn50X/GXVQ/jHxbI9E5zS7Q==');
/*!40000 ALTER TABLE `share_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_access_rules_metadata`
--

DROP TABLE IF EXISTS `share_access_rules_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_access_rules_metadata` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `access_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `access_id` (`access_id`),
  CONSTRAINT `share_access_rules_metadata_ibfk_1` FOREIGN KEY (`access_id`) REFERENCES `share_access_map` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_access_rules_metadata`
--

LOCK TABLES `share_access_rules_metadata` WRITE;
/*!40000 ALTER TABLE `share_access_rules_metadata` DISABLE KEYS */;
INSERT INTO `share_access_rules_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `access_id`, `key`, `value`, `id`) VALUES ('2025-11-29 05:37:58.622459',NULL,'2025-11-29 05:38:18.464288','1','683384a4-150b-4e1a-afd1-2d18e025b5ec','key1','value1',1),('2025-11-29 05:37:58.623016','2025-11-29 05:38:17.131589','2025-11-29 05:38:18.464288','2','683384a4-150b-4e1a-afd1-2d18e025b5ec','key2','value6_new',2),('2025-11-29 05:38:02.085323',NULL,'2025-11-29 05:38:06.549504','3','7cd4880d-cec6-4fa5-86ab-55029e2557a5','key3','v3',3),('2025-11-29 05:38:02.085969',NULL,'2025-11-29 05:38:06.549504','4','7cd4880d-cec6-4fa5-86ab-55029e2557a5','key4','value4',4),('2025-11-29 05:38:09.382437','2025-11-29 05:38:13.110539','2025-11-29 05:38:13.979184','5','26d1c21b-c729-467d-a349-44baa7667fdd','key1','vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv',5),('2025-11-29 05:38:09.382904','2025-11-29 05:38:13.332470','2025-11-29 05:38:13.979184','6','26d1c21b-c729-467d-a349-44baa7667fdd','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value2',6),('2025-11-29 05:38:17.117385',NULL,'2025-11-29 05:38:18.464288','7','683384a4-150b-4e1a-afd1-2d18e025b5ec','key7','value7',7),('2025-11-29 05:38:35.627711',NULL,'2025-11-29 05:38:37.803842','8','4578fc0a-e603-4fa6-8bc1-969e949cf674','key1','value1',8),('2025-11-29 05:40:13.323758',NULL,'2025-11-29 05:40:17.836769','9','df40c5dd-2e98-4a4f-9502-83c919293907','key1','v1',9),('2025-11-29 05:40:13.324637',NULL,'2025-11-29 05:40:17.836769','10','df40c5dd-2e98-4a4f-9502-83c919293907','key2','v2',10),('2025-11-29 05:40:20.638496',NULL,'2025-11-29 05:40:24.826733','11','8bff3ada-1614-4535-a17f-24926ceb641c','key1','v1',11),('2025-11-29 05:40:20.639028',NULL,'2025-11-29 05:40:24.826733','12','8bff3ada-1614-4535-a17f-24926ceb641c','key2','v2',12);
/*!40000 ALTER TABLE `share_access_rules_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_share_type_mappings`
--

DROP TABLE IF EXISTS `share_group_share_type_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_share_type_mappings` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_group_id` varchar(36) DEFAULT NULL,
  `share_type_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_sgstm_share_group_id` (`share_group_id`),
  KEY `fk_sgstm_share_type_id` (`share_type_id`),
  CONSTRAINT `fk_sgstm_share_group_id` FOREIGN KEY (`share_group_id`) REFERENCES `share_groups` (`id`),
  CONSTRAINT `fk_sgstm_share_type_id` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_share_type_mappings`
--

LOCK TABLES `share_group_share_type_mappings` WRITE;
/*!40000 ALTER TABLE `share_group_share_type_mappings` DISABLE KEYS */;
INSERT INTO `share_group_share_type_mappings` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `share_group_id`, `share_type_id`) VALUES ('452f409c-e096-4590-8a8e-0f5f33f5c712','2025-11-29 05:38:26.483558',NULL,'2025-11-29 05:38:27.068163','452f409c-e096-4590-8a8e-0f5f33f5c712','e90efdb1-518e-4a19-a290-0fbf105b6f6d','7c6b9483-7c46-438e-a204-efa953929f7b'),('bb3e0cba-ecf6-4448-bf45-fc12510c5bd6','2025-11-29 05:38:22.117023',NULL,'2025-11-29 05:38:26.176450','bb3e0cba-ecf6-4448-bf45-fc12510c5bd6','a00c7ebd-01d8-4358-9f97-04e4aa820623','7c6b9483-7c46-438e-a204-efa953929f7b');
/*!40000 ALTER TABLE `share_group_share_type_mappings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_snapshots`
--

DROP TABLE IF EXISTS `share_group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_snapshots` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `user_id` varchar(255) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `share_group_id` varchar(36) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_share_group_snapshots_share_group_id` (`share_group_id`),
  CONSTRAINT `fk_share_group_snapshots_share_group_id` FOREIGN KEY (`share_group_id`) REFERENCES `share_groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_snapshots`
--

LOCK TABLES `share_group_snapshots` WRITE;
/*!40000 ALTER TABLE `share_group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_type_projects`
--

DROP TABLE IF EXISTS `share_group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sgtp_project_id_uc` (`share_group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `sgtp_id_fk` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_type_projects`
--

LOCK TABLES `share_group_type_projects` WRITE;
/*!40000 ALTER TABLE `share_group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_type_share_type_mappings`
--

DROP TABLE IF EXISTS `share_group_type_share_type_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_type_share_type_mappings` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_group_type_id` varchar(36) NOT NULL,
  `share_type_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sgtp_id_sgt_id_uc` (`share_group_type_id`),
  KEY `sgtp_id_st_id_uc` (`share_type_id`),
  CONSTRAINT `sgtp_id_sgt_id_uc` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`),
  CONSTRAINT `sgtp_id_st_id_uc` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_type_share_type_mappings`
--

LOCK TABLES `share_group_type_share_type_mappings` WRITE;
/*!40000 ALTER TABLE `share_group_type_share_type_mappings` DISABLE KEYS */;
INSERT INTO `share_group_type_share_type_mappings` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `share_group_type_id`, `share_type_id`) VALUES ('092b362a-2c8f-4ff4-a28b-1b0e2a3fb3d0','2025-11-29 05:36:23.310244',NULL,'2025-11-29 05:36:58.594135','092b362a-2c8f-4ff4-a28b-1b0e2a3fb3d0','2ea80482-bc50-408a-b1aa-82bb3a7c8b9b','f0da18b9-ba8c-41ec-8938-860c87e4760c'),('28fa455d-91a3-451b-b7f8-22472002563a','2025-11-29 05:38:54.149193',NULL,'2025-11-29 05:38:57.883696','28fa455d-91a3-451b-b7f8-22472002563a','fe6ce610-128f-4049-931f-a586609b001d','d6d71f4f-03e4-4782-9e86-8f9adabdb6a0'),('2b888d08-c6d8-42fc-b2eb-f1eb8a56c2d5','2025-11-29 05:38:01.369403',NULL,'2025-11-29 05:38:43.520036','2b888d08-c6d8-42fc-b2eb-f1eb8a56c2d5','2afae692-fc35-4cf4-8fda-6753568ec52f','7c6b9483-7c46-438e-a204-efa953929f7b'),('5773feb4-d736-4d45-94bf-ae1e8141f7e2','2025-11-29 05:35:07.125612',NULL,'2025-11-29 05:35:44.127168','5773feb4-d736-4d45-94bf-ae1e8141f7e2','21a55033-3dff-4615-8ead-50f41a746660','78a90e40-d5c8-4771-9de6-c085b16e4fa4');
/*!40000 ALTER TABLE `share_group_type_share_type_mappings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_type_specs`
--

DROP TABLE IF EXISTS `share_group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `spec_key` varchar(255) DEFAULT NULL,
  `spec_value` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `share_group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sgtp_id_extra_specs_fk` (`share_group_type_id`),
  CONSTRAINT `sgtp_id_extra_specs_fk` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_type_specs`
--

LOCK TABLES `share_group_type_specs` WRITE;
/*!40000 ALTER TABLE `share_group_type_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_types`
--

DROP TABLE IF EXISTS `share_group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_types` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_share_group_type_name` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_types`
--

LOCK TABLES `share_group_types` WRITE;
/*!40000 ALTER TABLE `share_group_types` DISABLE KEYS */;
INSERT INTO `share_group_types` (`id`, `created_at`, `updated_at`, `deleted_at`, `is_public`, `name`, `deleted`) VALUES ('21a55033-3dff-4615-8ead-50f41a746660','2025-11-29 05:35:07.123654',NULL,'2025-11-29 05:35:44.133066',1,'tempest-unique_sgtype_name-350498888','21a55033-3dff-4615-8ead-50f41a746660'),('2afae692-fc35-4cf4-8fda-6753568ec52f','2025-11-29 05:38:01.368584',NULL,'2025-11-29 05:38:43.524709',1,'tempest-unique_sgtype_name-784584654','2afae692-fc35-4cf4-8fda-6753568ec52f'),('2ea80482-bc50-408a-b1aa-82bb3a7c8b9b','2025-11-29 05:36:23.308935',NULL,'2025-11-29 05:36:58.599049',1,'tempest-unique_sgtype_name-597399505','2ea80482-bc50-408a-b1aa-82bb3a7c8b9b'),('fe6ce610-128f-4049-931f-a586609b001d','2025-11-29 05:38:54.148488',NULL,'2025-11-29 05:38:57.886410',1,'tempest-unique_sgtype_name-2027071792','fe6ce610-128f-4049-931f-a586609b001d');
/*!40000 ALTER TABLE `share_group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_groups`
--

DROP TABLE IF EXISTS `share_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_groups` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `user_id` varchar(255) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `host` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `source_share_group_snapshot_id` varchar(36) DEFAULT NULL,
  `share_network_id` varchar(36) DEFAULT NULL,
  `share_server_id` varchar(36) DEFAULT NULL,
  `share_group_type_id` varchar(36) DEFAULT NULL,
  `consistent_snapshot_support` enum('pool','host') DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_share_group_share_network_id` (`share_network_id`),
  KEY `fk_share_group_share_server_id` (`share_server_id`),
  KEY `sgt_id_sg_id_uc` (`share_group_type_id`),
  CONSTRAINT `fk_share_group_share_network_id` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`),
  CONSTRAINT `fk_share_group_share_server_id` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`),
  CONSTRAINT `sgt_id_sg_id_uc` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_groups`
--

LOCK TABLES `share_groups` WRITE;
/*!40000 ALTER TABLE `share_groups` DISABLE KEYS */;
INSERT INTO `share_groups` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `user_id`, `project_id`, `host`, `name`, `description`, `status`, `source_share_group_snapshot_id`, `share_network_id`, `share_server_id`, `share_group_type_id`, `consistent_snapshot_support`, `availability_zone_id`) VALUES ('a00c7ebd-01d8-4358-9f97-04e4aa820623','2025-11-29 05:38:22.382660','2025-11-29 05:38:26.175572','2025-11-29 05:38:26.174727','a00c7ebd-01d8-4358-9f97-04e4aa820623','40461bcceb79486685576e03cd6143f7','bde0f89de7a5405e8d086a6415adbc5c','hostgroup@cephfs#cephfs',NULL,NULL,'deleting',NULL,NULL,NULL,'2afae692-fc35-4cf4-8fda-6753568ec52f',NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0'),('e90efdb1-518e-4a19-a290-0fbf105b6f6d','2025-11-29 05:38:26.631753','2025-11-29 05:38:27.067005','2025-11-29 05:38:27.066319','e90efdb1-518e-4a19-a290-0fbf105b6f6d','40461bcceb79486685576e03cd6143f7','bde0f89de7a5405e8d086a6415adbc5c','hostgroup@cephfs#cephfs',NULL,NULL,'deleting',NULL,NULL,NULL,'2afae692-fc35-4cf4-8fda-6753568ec52f',NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0');
/*!40000 ALTER TABLE `share_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instance_access_map`
--

DROP TABLE IF EXISTS `share_instance_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instance_access_map` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `share_instance_id` varchar(36) DEFAULT NULL,
  `access_id` varchar(36) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `siam_instance_fk` (`share_instance_id`),
  KEY `siam_access_fk` (`access_id`),
  CONSTRAINT `siam_access_fk` FOREIGN KEY (`access_id`) REFERENCES `share_access_map` (`id`),
  CONSTRAINT `siam_instance_fk` FOREIGN KEY (`share_instance_id`) REFERENCES `share_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instance_access_map`
--

LOCK TABLES `share_instance_access_map` WRITE;
/*!40000 ALTER TABLE `share_instance_access_map` DISABLE KEYS */;
INSERT INTO `share_instance_access_map` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_instance_id`, `access_id`, `state`) VALUES ('2025-11-29 05:38:20.278294','2025-11-29 05:38:24.582468','2025-11-29 05:38:24.582091','0edc7ca0-10ed-470f-996e-6f2a2ff6b1ab','0edc7ca0-10ed-470f-996e-6f2a2ff6b1ab','848ba3c8-c30f-497b-9372-9c6fce9360b1','f079399f-2f0b-41b5-8481-a615768e7f84','deleted'),('2025-11-29 05:37:36.981959','2025-11-29 05:37:41.012613','2025-11-29 05:37:41.012239','108c5990-6cd9-41ae-a4c4-dddb49a2daf6','108c5990-6cd9-41ae-a4c4-dddb49a2daf6','848ba3c8-c30f-497b-9372-9c6fce9360b1','e479b3cf-d76b-436d-bf72-03ba66f10462','deleted'),('2025-11-29 05:40:20.647865','2025-11-29 05:40:24.824977','2025-11-29 05:40:24.824558','1a4f3670-2fcf-4c57-ba58-0425f872aa5b','1a4f3670-2fcf-4c57-ba58-0425f872aa5b','a98b9fa5-d939-4fac-9215-346a94abca4f','8bff3ada-1614-4535-a17f-24926ceb641c','deleted'),('2025-11-29 05:38:35.070052','2025-11-29 05:38:39.206517','2025-11-29 05:38:39.205936','2229fe96-73ea-468e-a488-d242fa60646f','2229fe96-73ea-468e-a488-d242fa60646f','848ba3c8-c30f-497b-9372-9c6fce9360b1','fef0cf00-ab9b-4909-9426-8bfcac7cda08','deleted'),('2025-11-29 05:40:52.564499','2025-11-29 05:41:00.056143','2025-11-29 05:41:00.055727','23a53bb0-f16b-4e98-9025-4a04f67a3197','23a53bb0-f16b-4e98-9025-4a04f67a3197','fb7c7b44-2af1-44fc-8694-006120ff8320','11f59548-5d58-4b5c-8a75-a224dc65dcbb','deleted'),('2025-11-29 05:37:58.805614','2025-11-29 05:38:03.019326','2025-11-29 05:38:03.018828','24c4ee37-8701-4619-ab52-749a1bff2763','24c4ee37-8701-4619-ab52-749a1bff2763','848ba3c8-c30f-497b-9372-9c6fce9360b1','8108ab18-8798-4d85-8a83-3f1467ecae8b','deleted'),('2025-11-29 05:39:13.216297','2025-11-29 05:39:17.423110','2025-11-29 05:39:17.422271','256870fe-fc1e-4a1c-b34c-665c1318dc08','256870fe-fc1e-4a1c-b34c-665c1318dc08','848ba3c8-c30f-497b-9372-9c6fce9360b1','8851b15b-ced1-4c35-9fca-7e1326f35d67','deleted'),('2025-11-29 05:40:25.169869','2025-11-29 05:40:29.205450','2025-11-29 05:40:29.205012','29e895eb-f224-4b5e-b502-c4f7f9847e63','29e895eb-f224-4b5e-b502-c4f7f9847e63','e71bf388-0320-44c7-80f4-31f36b232ca1','c58c1388-b10f-4b98-8b3b-0640ba3eb2bc','deleted'),('2025-11-29 05:38:42.320617','2025-11-29 05:38:46.734320','2025-11-29 05:38:46.733837','2d9e30be-d4d8-4a9a-83c4-c11c2f31d57c','2d9e30be-d4d8-4a9a-83c4-c11c2f31d57c','848ba3c8-c30f-497b-9372-9c6fce9360b1','bef8e005-dafd-4127-8a05-69df48542250','deleted'),('2025-11-29 05:39:04.411033','2025-11-29 05:39:10.025224','2025-11-29 05:39:10.024866','34ba972e-13be-4e25-8205-7cbf23681d47','34ba972e-13be-4e25-8205-7cbf23681d47','848ba3c8-c30f-497b-9372-9c6fce9360b1','9047c430-b33a-40db-934c-076fb9410fa9','deleted'),('2025-11-29 05:40:45.121830','2025-11-29 05:41:07.237065','2025-11-29 05:41:07.236565','36d581c2-2172-4603-a27a-e19628e893f7','36d581c2-2172-4603-a27a-e19628e893f7','a0e01f60-977a-4212-be2c-851b3318eb22','835edcae-d7d8-4727-9159-f3332fe6a638','deleted'),('2025-11-29 05:41:21.119032','2025-11-29 05:41:25.129945','2025-11-29 05:41:25.129485','3d9c1e6a-2ae7-4959-ac46-e2931632c5c6','3d9c1e6a-2ae7-4959-ac46-e2931632c5c6','28265ef5-ca45-4354-be2b-4e281fa424cd','72eadd53-1128-4512-ac26-4cb4ea626ad8','deleted'),('2025-11-29 05:37:44.153249','2025-11-29 05:37:48.624393','2025-11-29 05:37:48.623979','3e29fe99-c4fc-4254-adc7-f50e32b4d28c','3e29fe99-c4fc-4254-adc7-f50e32b4d28c','848ba3c8-c30f-497b-9372-9c6fce9360b1','aff2062b-997f-4d8e-bf68-1db221b0ef58','deleted'),('2025-11-29 05:41:14.097957','2025-11-29 05:41:28.570967','2025-11-29 05:41:28.570593','4225c07c-1955-4b69-90f8-48199a60ec99','4225c07c-1955-4b69-90f8-48199a60ec99','873c8599-1b6c-425f-8c5c-0a211fc50713','97346405-2f91-4bac-9082-2fb29f0230ac','deleted'),('2025-11-29 05:39:27.693397','2025-11-29 05:39:31.597073','2025-11-29 05:39:31.596502','47d70512-a98a-4223-b2d9-26fc00d41329','47d70512-a98a-4223-b2d9-26fc00d41329','848ba3c8-c30f-497b-9372-9c6fce9360b1','f66af744-3107-4f23-9d2d-8aa81b5bbfe1','deleted'),('2025-11-29 05:39:51.036976','2025-11-29 05:39:55.255611','2025-11-29 05:39:55.255032','5c88fa4c-64f3-4bd9-b8d4-f0b365b4cc65','5c88fa4c-64f3-4bd9-b8d4-f0b365b4cc65','dddb87ae-5fcb-4c01-90f6-c57d130f8474','b87c4b01-93a8-4b04-8990-9505df9470b6','deleted'),('2025-11-29 05:39:30.380319','2025-11-29 05:39:34.326084','2025-11-29 05:39:34.325712','6e9acb07-daec-420c-83d8-73e324342334','6e9acb07-daec-420c-83d8-73e324342334','c7cad0a5-6ce4-4ca6-994f-ac3363a79f14','0d48533d-0ef0-43d3-8c13-59b7bf8b3f3f','deleted'),('2025-11-29 05:38:35.812862','2025-11-29 05:38:37.801124','2025-11-29 05:38:37.800628','709e30ae-b8d2-4c29-9a3b-e0a9f019ceb4','709e30ae-b8d2-4c29-9a3b-e0a9f019ceb4','c5ccc350-84d0-463a-8142-2450838c9e41','4578fc0a-e603-4fa6-8bc1-969e949cf674','deleted'),('2025-11-29 05:38:12.990142','2025-11-29 05:38:17.108898','2025-11-29 05:38:17.108511','74bfaa7a-89df-4974-859d-96447d8c311b','74bfaa7a-89df-4974-859d-96447d8c311b','848ba3c8-c30f-497b-9372-9c6fce9360b1','b91a8a46-8b89-4b97-9458-e49eef3084ce','deleted'),('2025-11-29 05:38:27.597009','2025-11-29 05:38:32.077623','2025-11-29 05:38:32.077198','7c5376ff-48ee-4437-a13a-9be9e18190f4','7c5376ff-48ee-4437-a13a-9be9e18190f4','848ba3c8-c30f-497b-9372-9c6fce9360b1','3a1fb528-cf19-43ca-bcdf-a209e9bc8995','deleted'),('2025-11-29 05:41:10.243988','2025-11-29 05:41:43.173635','2025-11-29 05:41:43.173022','84e2eb25-01ab-4c6d-b769-afa64fbb5b1b','84e2eb25-01ab-4c6d-b769-afa64fbb5b1b','873c8599-1b6c-425f-8c5c-0a211fc50713','655035ad-6967-43e2-9507-c55e9c8d9567','deleted'),('2025-11-29 05:38:05.848507','2025-11-29 05:38:10.829862','2025-11-29 05:38:10.829368','8793e7ea-11cf-455d-89e5-77027c313e41','8793e7ea-11cf-455d-89e5-77027c313e41','848ba3c8-c30f-497b-9372-9c6fce9360b1','e9aa152a-7f3e-4340-9fb6-adc99e532641','deleted'),('2025-11-29 05:40:02.568547','2025-11-29 05:40:06.617720','2025-11-29 05:40:06.617338','8c8bcaab-14c7-4c4e-b2fb-c09b5591e65a','8c8bcaab-14c7-4c4e-b2fb-c09b5591e65a','848ba3c8-c30f-497b-9372-9c6fce9360b1','eb8ac43e-b65f-4b25-bccd-9765cc5865ab','deleted'),('2025-11-29 05:37:22.721101','2025-11-29 05:37:26.876271','2025-11-29 05:37:26.875613','92563b5b-9255-419b-8f6f-65c263716611','92563b5b-9255-419b-8f6f-65c263716611','848ba3c8-c30f-497b-9372-9c6fce9360b1','2151a973-209b-4632-8a89-bb6281fa263d','deleted'),('2025-11-29 05:38:09.400427','2025-11-29 05:38:13.977367','2025-11-29 05:38:13.977017','9959e270-a31a-43f0-916d-c739a96902e2','9959e270-a31a-43f0-916d-c739a96902e2','0065e446-d05c-42f4-b14d-c32152b4c886','26d1c21b-c729-467d-a349-44baa7667fdd','deleted'),('2025-11-29 05:39:58.096356','2025-11-29 05:40:02.585076','2025-11-29 05:40:02.584480','a84c43eb-fdb7-4c03-be09-10d2c79eb0f4','a84c43eb-fdb7-4c03-be09-10d2c79eb0f4','a98b9fa5-d939-4fac-9215-346a94abca4f','05829d2f-e322-477b-8aea-7c582f79d184','deleted'),('2025-11-29 05:38:56.977102','2025-11-29 05:39:01.266682','2025-11-29 05:39:01.266024','b9635b78-b304-4ec0-b20e-3c01bb03b895','b9635b78-b304-4ec0-b20e-3c01bb03b895','848ba3c8-c30f-497b-9372-9c6fce9360b1','2bb3af8f-3fbf-43b8-a73e-32e520b26188','deleted'),('2025-11-29 05:40:05.695933','2025-11-29 05:40:10.281884','2025-11-29 05:40:10.281375','ba58e096-1de1-4460-b2a4-f4dc06e21f8d','ba58e096-1de1-4460-b2a4-f4dc06e21f8d','a98b9fa5-d939-4fac-9215-346a94abca4f','1eadbcb4-634e-40b3-a81b-dc8c00c0405b','deleted'),('2025-11-29 05:37:29.884983','2025-11-29 05:37:33.954098','2025-11-29 05:37:33.953709','be5b6142-9bf2-40ef-a17b-c569be3c2316','be5b6142-9bf2-40ef-a17b-c569be3c2316','848ba3c8-c30f-497b-9372-9c6fce9360b1','97cf6d2c-e6cb-4c1c-9607-5c44795d0e43','deleted'),('2025-11-29 05:39:48.186860','2025-11-29 05:39:52.014059','2025-11-29 05:39:52.013354','c20d01fb-864f-4989-aeb6-d42af430eb72','c20d01fb-864f-4989-aeb6-d42af430eb72','848ba3c8-c30f-497b-9372-9c6fce9360b1','ffb2afef-9699-4e08-aa9b-dbf5cc830679','deleted'),('2025-11-29 05:38:49.926607','2025-11-29 05:38:54.099475','2025-11-29 05:38:54.099045','c231dc10-b5c7-4f1a-b2be-9ba7a937ebe5','c231dc10-b5c7-4f1a-b2be-9ba7a937ebe5','848ba3c8-c30f-497b-9372-9c6fce9360b1','85ba7916-7733-411a-87f5-7ed780267488','deleted'),('2025-11-29 05:39:55.130415','2025-11-29 05:39:59.579344','2025-11-29 05:39:59.578979','c2aff350-b60d-4130-b973-6d213575a384','c2aff350-b60d-4130-b973-6d213575a384','848ba3c8-c30f-497b-9372-9c6fce9360b1','1a9bd3ee-2e6e-4baa-be02-4412dc53d324','deleted'),('2025-11-29 05:38:02.100580','2025-11-29 05:38:06.547978','2025-11-29 05:38:06.547587','c7b1a854-5f2b-4a4e-8d14-6b8b84ed1cd1','c7b1a854-5f2b-4a4e-8d14-6b8b84ed1cd1','0065e446-d05c-42f4-b14d-c32152b4c886','7cd4880d-cec6-4fa5-86ab-55029e2557a5','deleted'),('2025-11-29 05:39:41.468104','2025-11-29 05:39:45.225166','2025-11-29 05:39:45.224698','c9c38435-de4c-4f59-bd1a-6190f0790c53','c9c38435-de4c-4f59-bd1a-6190f0790c53','848ba3c8-c30f-497b-9372-9c6fce9360b1','35d66830-fe56-4dd5-a557-6cd9604981f2','deleted'),('2025-11-29 05:39:20.643420','2025-11-29 05:39:24.674226','2025-11-29 05:39:24.673836','cbfd1d75-2c2e-4f9c-8bf3-b251c7a9735f','cbfd1d75-2c2e-4f9c-8bf3-b251c7a9735f','848ba3c8-c30f-497b-9372-9c6fce9360b1','3d4545b1-468c-43b5-8a1c-513e2add120e','deleted'),('2025-11-29 05:40:13.336416','2025-11-29 05:40:17.832360','2025-11-29 05:40:17.831922','d105f78e-b10f-45e5-8015-2c73ea4a2804','d105f78e-b10f-45e5-8015-2c73ea4a2804','a98b9fa5-d939-4fac-9215-346a94abca4f','df40c5dd-2e98-4a4f-9502-83c919293907','deleted'),('2025-11-29 05:40:09.902998','2025-11-29 05:40:14.155880','2025-11-29 05:40:14.154777','d6758464-183b-4ab3-853c-1bc2b34832f9','d6758464-183b-4ab3-853c-1bc2b34832f9','848ba3c8-c30f-497b-9372-9c6fce9360b1','54a9a42c-e70b-4f81-ad6f-2f5c6ad9397b','deleted'),('2025-11-29 05:40:17.204290','2025-11-29 05:40:32.377016','2025-11-29 05:40:32.376611','ddce3a7e-7d0e-4839-969e-0d3949a7b0d2','ddce3a7e-7d0e-4839-969e-0d3949a7b0d2','848ba3c8-c30f-497b-9372-9c6fce9360b1','d4b00d6e-807a-42e6-bd8b-df99d6421cb1','deleted'),('2025-11-29 05:39:40.782434','2025-11-29 05:39:44.583709','2025-11-29 05:39:44.583219','df0ca891-f9fc-4757-8f8b-bcc1048713b5','df0ca891-f9fc-4757-8f8b-bcc1048713b5','06420fd0-e9c0-463d-9475-8429a0c8fd0d','1ed75037-c229-4073-bd95-59c05f32ce0e','deleted'),('2025-11-29 05:40:56.191433','2025-11-29 05:41:03.715218','2025-11-29 05:41:03.714726','f12c5c97-96c9-452b-b8ad-80de50829c87','f12c5c97-96c9-452b-b8ad-80de50829c87','fb7c7b44-2af1-44fc-8694-006120ff8320','c500c339-d533-4fc1-ad10-6bfcb1a441fb','deleted'),('2025-11-29 05:39:34.548937','2025-11-29 05:39:38.460069','2025-11-29 05:39:38.459659','f616893f-56c2-41b8-93ec-1074ad8cd9a9','f616893f-56c2-41b8-93ec-1074ad8cd9a9','848ba3c8-c30f-497b-9372-9c6fce9360b1','52c3d83d-ff52-44ce-b493-1bf41790a63d','deleted'),('2025-11-29 05:37:58.645160','2025-11-29 05:38:18.460816','2025-11-29 05:38:18.460396','f6c5f6ee-607f-44f4-998f-be22a05596f4','f6c5f6ee-607f-44f4-998f-be22a05596f4','0065e446-d05c-42f4-b14d-c32152b4c886','683384a4-150b-4e1a-afd1-2d18e025b5ec','deleted'),('2025-11-29 05:37:51.802450','2025-11-29 05:37:56.203739','2025-11-29 05:37:56.203288','f7e438a6-190e-4816-8c83-b2256ab0af95','f7e438a6-190e-4816-8c83-b2256ab0af95','848ba3c8-c30f-497b-9372-9c6fce9360b1','fc3a89b4-9d85-429b-8fb2-1bab0746216b','deleted');
/*!40000 ALTER TABLE `share_instance_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instance_export_locations`
--

DROP TABLE IF EXISTS `share_instance_export_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instance_export_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `path` varchar(2000) DEFAULT NULL,
  `share_instance_id` varchar(36) DEFAULT NULL,
  `is_admin_only` tinyint(1) DEFAULT NULL,
  `uuid` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `sel_instance_id_fk` (`share_instance_id`),
  CONSTRAINT `sel_instance_id_fk` FOREIGN KEY (`share_instance_id`) REFERENCES `share_instances` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instance_export_locations`
--

LOCK TABLES `share_instance_export_locations` WRITE;
/*!40000 ALTER TABLE `share_instance_export_locations` DISABLE KEYS */;
INSERT INTO `share_instance_export_locations` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `path`, `share_instance_id`, `is_admin_only`, `uuid`) VALUES (1,'2025-11-29 05:34:23.745828','2025-11-29 05:35:44.468886','2025-11-29 05:35:44.467509',1,'192.168.122.100:6789:/volumes/_nogroup/e887b8f7-1920-4aa9-a22b-586da6843031/5702daa4-7cda-4ca8-a017-085335a58412','e887b8f7-1920-4aa9-a22b-586da6843031',0,'d40da81d-6d3c-4f86-9171-fd13b5ca0b59'),(2,'2025-11-29 05:34:25.159305','2025-11-29 05:34:31.684070','2025-11-29 05:34:31.680614',2,'192.168.122.100:6789:/volumes/_nogroup/86dc64fd-e983-41fb-88c2-0ca9782c4406/0bbf4478-d45c-4aa0-b351-bf57350e61d6','86dc64fd-e983-41fb-88c2-0ca9782c4406',0,'543d7f1d-0681-4545-96e7-b726a22196a8'),(3,'2025-11-29 05:34:27.585773','2025-11-29 05:34:31.955274','2025-11-29 05:34:31.951750',3,'192.168.122.100:6789:/volumes/_nogroup/139756d1-c4a7-4d9e-860e-88e58c898640/1f1d0784-51af-4394-8e9b-a5b0668d6194','139756d1-c4a7-4d9e-860e-88e58c898640',0,'61b62b01-57c4-4933-a4f1-ace5411b3d20'),(4,'2025-11-29 05:34:35.623070','2025-11-29 05:34:40.086034','2025-11-29 05:34:40.085066',4,'192.168.122.100:6789:/volumes/_nogroup/18c23ac3-9de1-4499-a61d-bb17aaae0f7d/58589d5c-842f-435b-b29d-2fe6d993eba3','18c23ac3-9de1-4499-a61d-bb17aaae0f7d',0,'0143636e-d3da-4a5b-a6fc-0747d31421c3'),(5,'2025-11-29 05:34:36.786818','2025-11-29 05:34:44.294108','2025-11-29 05:34:44.293015',5,'192.168.122.100:6789:/volumes/_nogroup/00bcce59-7712-4975-bf1e-f275f12b7d66/8c8ea4cd-fc92-4ad1-b006-8078180129d4','00bcce59-7712-4975-bf1e-f275f12b7d66',0,'236979d5-7237-4261-a067-40816745e963'),(6,'2025-11-29 05:34:43.745122','2025-11-29 05:34:44.627633','2025-11-29 05:34:44.626566',6,'192.168.122.100:6789:/volumes/_nogroup/58d0834c-039f-43fa-9037-b2e41fbfffb3/dc65505a-ec24-47b0-8ca5-8e93b73f5576','58d0834c-039f-43fa-9037-b2e41fbfffb3',0,'b1cee341-bcf7-44c2-8920-b8f8a69c4853'),(7,'2025-11-29 05:34:49.264493','2025-11-29 05:34:50.324608','2025-11-29 05:34:50.323569',7,'192.168.122.100:6789:/volumes/_nogroup/c849ef50-3cb1-498e-ae97-f5cb56db1715/1cb986b7-24ad-4267-968b-a44e72854b5a','c849ef50-3cb1-498e-ae97-f5cb56db1715',0,'78f20505-0e6a-49e3-a353-1a5a1ad146be'),(8,'2025-11-29 05:35:08.338749','2025-11-29 05:35:36.437186','2025-11-29 05:35:36.434325',8,'192.168.122.100:6789:/volumes/_nogroup/cfa53e30-aa5d-48db-9775-60686b039ee1/36319a29-1977-4032-8a77-761ad8f11f63','cfa53e30-aa5d-48db-9775-60686b039ee1',0,'2b7af200-4174-4c94-a6b7-4591d0a074a1'),(9,'2025-11-29 05:35:10.431596','2025-11-29 05:35:18.041438','2025-11-29 05:35:18.040405',9,'192.168.122.100:6789:/volumes/_nogroup/0626d330-257a-411d-9af3-ea14cd2279db/a3bbfba0-ad08-4496-9c72-5b11670ce716','0626d330-257a-411d-9af3-ea14cd2279db',0,'7086b9b8-eea6-461f-8f52-4401ebbb8e69'),(10,'2025-11-29 05:35:13.677931','2025-11-29 05:35:23.105466','2025-11-29 05:35:23.104210',10,'192.168.122.100:6789:/volumes/_nogroup/c22e2d86-7063-410a-82af-ad809d954609/04c70ca6-3405-47c5-959b-b336e45c9f4c','c22e2d86-7063-410a-82af-ad809d954609',0,'8c78957f-75e3-4527-8df6-3a3ecc11f8cb'),(11,'2025-11-29 05:35:22.925883','2025-11-29 05:35:29.232064','2025-11-29 05:35:29.230716',11,'192.168.122.100:6789:/volumes/_nogroup/08ff9271-7e61-496e-a296-8bfe1694c401/861fda5e-e27f-4bc2-b355-4d8a0c58fc51','08ff9271-7e61-496e-a296-8bfe1694c401',0,'955c807c-3ea2-4982-b827-51118e25a358'),(12,'2025-11-29 05:35:40.665102','2025-11-29 05:36:29.364673','2025-11-29 05:36:29.363352',12,'192.168.122.100:6789:/volumes/_nogroup/48601f02-9051-4603-a049-8748d3e87534/986b6e03-e449-4a2f-8488-2c3a2b91db6b','48601f02-9051-4603-a049-8748d3e87534',0,'59e62269-68a6-48fd-8478-d9bce74e7fba'),(13,'2025-11-29 05:35:44.193918','2025-11-29 05:35:49.040055','2025-11-29 05:35:49.038994',13,'192.168.122.100:6789:/volumes/_nogroup/8f9a66be-c929-4519-9b84-590a248b55ea/8e45a363-481a-4a4c-94e5-10959d8a65b8','8f9a66be-c929-4519-9b84-590a248b55ea',0,'3585631e-df0e-4503-9cda-32f32f246982'),(14,'2025-11-29 05:35:52.611693','2025-11-29 05:35:58.883442','2025-11-29 05:35:58.882402',14,'192.168.122.100:6789:/volumes/_nogroup/0e332c7f-e0d3-46ad-9a13-7cf0840fc484/9d75af52-c77c-4bca-b350-4fdc9c8471ad','0e332c7f-e0d3-46ad-9a13-7cf0840fc484',0,'da6a032a-459d-4220-97ad-2bc33483def0'),(15,'2025-11-29 05:35:54.333995','2025-11-29 05:36:03.017972','2025-11-29 05:36:03.016713',15,'192.168.122.100:6789:/volumes/_nogroup/09990eae-c6d2-4985-ad1a-d7539b5b0a71/f09c4012-64d7-4e98-bbde-249c5a9caa39','09990eae-c6d2-4985-ad1a-d7539b5b0a71',0,'48940cf5-e580-48a0-977f-6d430d580537'),(16,'2025-11-29 05:35:59.142192','2025-11-29 05:36:02.990618','2025-11-29 05:36:02.989390',16,'192.168.122.100:6789:/volumes/_nogroup/c8cd1abe-2662-4481-9c2f-01f70ea291ce/1a2c0c6f-8303-4faf-b6e6-a9ce0bf9dcf3','c8cd1abe-2662-4481-9c2f-01f70ea291ce',0,'745da91b-9d24-48b5-8679-409481476f77'),(17,'2025-11-29 05:36:02.536040','2025-11-29 05:36:06.170723','2025-11-29 05:36:06.168309',17,'192.168.122.100:6789:/volumes/_nogroup/fb79334f-5107-432b-91aa-57c8d02f46a2/b234054a-5e7f-4bcc-9741-9ca0bc77651d','fb79334f-5107-432b-91aa-57c8d02f46a2',0,'c2df1276-e705-4a80-9933-532f66838124'),(18,'2025-11-29 05:36:09.713410','2025-11-29 05:36:14.886812','2025-11-29 05:36:14.885646',18,'192.168.122.100:6789:/volumes/_nogroup/969d69e3-5179-4284-9d56-4ddf6b5b95ef/bc581e9f-2998-4c3f-aef4-4cfb36c5e07b','969d69e3-5179-4284-9d56-4ddf6b5b95ef',0,'23e1c3a9-cfdc-44c4-9b68-285fb7ed0bfe'),(19,'2025-11-29 05:36:20.433111','2025-11-29 05:36:23.368374','2025-11-29 05:36:23.367393',19,'192.168.122.100:6789:/volumes/_nogroup/9f9bf0ea-9f71-4161-881f-1c5e81eea943/55947e0e-657e-4c98-a295-350303344328','9f9bf0ea-9f71-4161-881f-1c5e81eea943',0,'b90e5313-d5ac-4325-80d9-c3248c166d76'),(20,'2025-11-29 05:36:23.791515','2025-11-29 05:36:55.196765','2025-11-29 05:36:55.195764',20,'192.168.122.100:6789:/volumes/_nogroup/70f1f9a5-b960-4859-afd1-e8403dcbe455/5193d1b1-5d8e-4f74-94b5-4b83bcde1eb0','70f1f9a5-b960-4859-afd1-e8403dcbe455',0,'ff2507b2-e80c-479a-bb10-1878b391ed1f'),(21,'2025-11-29 05:36:27.960188','2025-11-29 05:36:51.055619','2025-11-29 05:36:51.054099',21,'192.168.122.100:6789:/volumes/_nogroup/ff968508-e63c-4125-8d0a-ffeca3c4312c/a4fea0b7-aa4c-48da-9366-71d2d11a3ebc','ff968508-e63c-4125-8d0a-ffeca3c4312c',0,'dd51c6d6-5741-49a2-bc06-060fdba74387'),(22,'2025-11-29 05:36:35.798163','2025-11-29 05:36:48.381123','2025-11-29 05:36:48.380096',22,'192.168.122.100:6789:/volumes/_nogroup/740417e2-7402-40fb-a24e-d743db894fa4/6ca6e25d-13e2-4fc0-a2b4-bf221a4d77f6','740417e2-7402-40fb-a24e-d743db894fa4',0,'1368791d-fecc-4cb7-b2d0-0e283b942c46'),(23,'2025-11-29 05:36:46.067133','2025-11-29 05:36:50.864488','2025-11-29 05:36:50.863603',23,'192.168.122.100:6789:/volumes/_nogroup/63e32269-5cd1-4b91-be8c-8e96abc0fca0/20dda76b-74d0-431a-baf2-fd4229414786','63e32269-5cd1-4b91-be8c-8e96abc0fca0',0,'7f5b40aa-1330-48be-8622-99a79d12e6e0'),(24,'2025-11-29 05:36:58.960265','2025-11-29 05:37:18.575034','2025-11-29 05:37:18.574102',24,'192.168.122.100:6789:/volumes/_nogroup/bf9ab1fa-bd1c-475a-9ef3-389a03e28e9c/94365ead-f288-43e0-bb8c-ff1aed702300','bf9ab1fa-bd1c-475a-9ef3-389a03e28e9c',0,'5e3381cb-ad22-4af6-92d6-c6d1dbfddb6a'),(25,'2025-11-29 05:37:03.151922','2025-11-29 05:37:09.162129','2025-11-29 05:37:09.155533',25,'192.168.122.100:6789:/volumes/_nogroup/25c968fa-209f-495f-aace-23679fada541/88a18826-2d48-4680-bdb0-51a6aed9c426','25c968fa-209f-495f-aace-23679fada541',0,'8aa6d9b5-963d-43e9-9ffc-412310ff7ecc'),(26,'2025-11-29 05:37:17.622466','2025-11-29 05:37:34.048159','2025-11-29 05:37:34.047250',26,'192.168.122.100:6789:/volumes/_nogroup/a9634de1-2230-40f8-a094-82f46777a70c/136eca0f-b87d-419b-9e85-68f33adf29c2','a9634de1-2230-40f8-a094-82f46777a70c',0,'98a292e9-722a-4590-88e1-738a4973a3b0'),(27,'2025-11-29 05:37:19.412165','2025-11-29 05:40:36.375804','2025-11-29 05:40:36.374908',27,'192.168.122.100:6789:/volumes/_nogroup/848ba3c8-c30f-497b-9372-9c6fce9360b1/b9af2a18-fc04-4d96-ba1b-197da2f0632f','848ba3c8-c30f-497b-9372-9c6fce9360b1',0,'836b2664-ba6a-4e24-aa21-225b2dbb94b1'),(28,'2025-11-29 05:37:36.004232','2025-11-29 05:37:40.371860','2025-11-29 05:37:40.370861',28,'192.168.122.100:6789:/volumes/_nogroup/040becac-51dc-4867-bf68-cd9d237d5891/031f208b-0e89-4e30-b084-980c7d1371a1','040becac-51dc-4867-bf68-cd9d237d5891',0,'fa60a1aa-1913-49a3-9e84-d7b26ee04520'),(29,'2025-11-29 05:37:43.997173','2025-11-29 05:37:49.104181','2025-11-29 05:37:49.102911',29,'192.168.122.100:6789:/volumes/_nogroup/201b4694-8935-45ce-9803-6d0546c82ba7/d2d0ef3b-ac6f-4fec-b2e0-4da42697304f','201b4694-8935-45ce-9803-6d0546c82ba7',0,'286d7727-a746-428d-a086-50a5fd8b9756'),(30,'2025-11-29 05:37:55.420921','2025-11-29 05:38:18.598661','2025-11-29 05:38:18.597570',30,'192.168.122.100:6789:/volumes/_nogroup/0065e446-d05c-42f4-b14d-c32152b4c886/9abefe74-5963-497e-9f27-35334ccad4d0','0065e446-d05c-42f4-b14d-c32152b4c886',0,'66979157-35c8-49c8-8b96-2e98905f9bdd'),(31,'2025-11-29 05:38:07.055488','2025-11-29 05:38:18.281928','2025-11-29 05:38:18.278649',31,'192.168.122.100:6789:/volumes/_nogroup/79586ddb-9940-4101-a183-8795d6ac1e84/bf4b7a0b-dde3-40af-8a36-386b38a1b03e','79586ddb-9940-4101-a183-8795d6ac1e84',0,'84970262-4beb-4c93-801c-301dd8f5ee7a'),(32,'2025-11-29 05:38:11.307364','2025-11-29 05:38:14.691270','2025-11-29 05:38:14.690156',32,'192.168.122.100:6789:/volumes/_nogroup/faeaf227-675c-42df-9bf7-248fca8b7753/3b78d612-88c6-42f3-9ca9-ceb763d1e3e7','faeaf227-675c-42df-9bf7-248fca8b7753',0,'3f87f45b-502c-49ce-9a5b-7ec2e0a7fb2f'),(33,'2025-11-29 05:38:27.726536','2025-11-29 05:38:31.795172','2025-11-29 05:38:31.793738',33,'192.168.122.100:6789:/volumes/_nogroup/1d9d275b-9d0b-4256-9071-300779a207f4/3c56520c-3540-4cf1-bf30-713c9b38da99','1d9d275b-9d0b-4256-9071-300779a207f4',0,'9417ae20-adce-44d5-b56e-447ecc9de24e'),(34,'2025-11-29 05:38:28.284311','2025-11-29 05:38:39.376395','2025-11-29 05:38:39.375214',34,'192.168.122.100:6789:/volumes/_nogroup/6c79e8b2-8385-4693-a845-3fe4aa3849bb/5809c89f-13c2-474b-b79f-57bb9b0ead21','6c79e8b2-8385-4693-a845-3fe4aa3849bb',0,'a42d304b-8588-4586-bb2b-daf7450b0fe6'),(35,'2025-11-29 05:38:32.814314','2025-11-29 05:38:36.470104','2025-11-29 05:38:36.462892',35,'192.168.122.100:6789:/volumes/_nogroup/6565f80a-02f8-4a73-b996-bca74f45d589/8fbbfbfd-f464-49c3-84ac-581bf1fe858d','6565f80a-02f8-4a73-b996-bca74f45d589',0,'4272482f-3a04-44c6-85b2-90ae3189c1c5'),(36,'2025-11-29 05:38:32.860545','2025-11-29 05:38:37.905271','2025-11-29 05:38:37.904305',36,'192.168.122.100:6789:/volumes/_nogroup/c5ccc350-84d0-463a-8142-2450838c9e41/9f7bf8da-4ed9-41a3-8ae3-ce8081d668f3','c5ccc350-84d0-463a-8142-2450838c9e41',0,'5c08e24b-c669-4188-b2b3-3b839d0a0dba'),(37,'2025-11-29 05:38:36.538218','2025-11-29 05:38:39.548902','2025-11-29 05:38:39.548061',37,'192.168.122.100:6789:/volumes/_nogroup/0940c3a8-0a26-4b45-8cd5-2278d86a8159/b7fbb455-7f91-4507-98e9-dd44382cea6a','0940c3a8-0a26-4b45-8cd5-2278d86a8159',0,'8496fd6f-961d-4e96-b653-221ba3f6bce1'),(38,'2025-11-29 05:38:43.020133','2025-11-29 05:38:47.199002','2025-11-29 05:38:47.197775',38,'192.168.122.100:6789:/volumes/_nogroup/2efbb8e6-d3d3-430b-8165-2af4490ffea0/72a4ac6d-f530-435b-8d4f-51b28805b3d4','2efbb8e6-d3d3-430b-8165-2af4490ffea0',0,'912be797-bfa1-4634-a8cf-7052aaa4ac0f'),(39,'2025-11-29 05:38:50.156595','2025-11-29 05:39:02.193606','2025-11-29 05:39:02.192520',39,'192.168.122.100:6789:/volumes/_nogroup/46ac263c-91aa-4770-862a-dd35f490382b/fe857737-02f1-4119-bbba-4ab408cb6c8c','46ac263c-91aa-4770-862a-dd35f490382b',0,'8c7a9b20-a86b-48a0-a09c-99785984a963'),(40,'2025-11-29 05:39:02.058634','2025-11-29 05:39:10.305316','2025-11-29 05:39:10.303751',40,'192.168.122.100:6789:/volumes/_nogroup/651b4bb8-257f-4b27-8e91-4460977c10fa/cc8a70c5-26af-403b-8f64-419833385251','651b4bb8-257f-4b27-8e91-4460977c10fa',0,'1fbdd2bd-da6e-4f92-8ca5-3d8b51c87df2'),(41,'2025-11-29 05:39:10.204975','2025-11-29 05:39:21.208403','2025-11-29 05:39:21.205832',41,'192.168.122.100:6789:/volumes/_nogroup/adc37617-82af-4ff2-b1ff-41acd332035e/63dbe025-b027-4146-a27a-5dfc241e8bcf','adc37617-82af-4ff2-b1ff-41acd332035e',0,'325d6e16-d636-4a06-b99e-024cc5580bba'),(42,'2025-11-29 05:39:22.916975','2025-11-29 05:40:29.288869','2025-11-29 05:40:29.287733',42,'192.168.122.100:6789:/volumes/_nogroup/a98b9fa5-d939-4fac-9215-346a94abca4f/1ddd10c5-e064-4e1d-82bc-8b2f4ca83ca6','a98b9fa5-d939-4fac-9215-346a94abca4f',0,'92a143bb-bf4b-4a14-9f8f-43ac5ff85d19'),(43,'2025-11-29 05:39:24.916161','2025-11-29 05:39:28.652827','2025-11-29 05:39:28.651898',43,'192.168.122.100:6789:/volumes/_nogroup/5ebeea41-cd85-43e6-b90c-d40733412d03/14058cfd-a78c-454e-96bd-a91dc8e1d3e3','5ebeea41-cd85-43e6-b90c-d40733412d03',0,'9d7d640a-49b3-4e12-9135-a85ebabfb26c'),(44,'2025-11-29 05:39:27.076556','2025-11-29 05:39:34.419500','2025-11-29 05:39:34.418044',44,'192.168.122.100:6789:/volumes/_nogroup/c7cad0a5-6ce4-4ca6-994f-ac3363a79f14/887c3b4c-9944-468a-a71d-7c57e0e4aba3','c7cad0a5-6ce4-4ca6-994f-ac3363a79f14',0,'79f1b9f2-0e33-4d4e-943d-4a3761151b33'),(45,'2025-11-29 05:39:32.186675','2025-11-29 05:40:02.383081','2025-11-29 05:40:02.381688',45,'192.168.122.100:6789:/volumes/_nogroup/ee8187c1-56b3-4603-8456-6c0a4e9f03fd/bd414a8e-b636-47b7-8586-3dbbbb567e66','ee8187c1-56b3-4603-8456-6c0a4e9f03fd',0,'d2a9728b-3b59-4311-a216-ce460ba4d6a9'),(46,'2025-11-29 05:39:32.400661','2025-11-29 05:40:30.814985','2025-11-29 05:40:30.813896',46,'192.168.122.100:6789:/volumes/_nogroup/779d5f7d-4b59-47d7-ae31-6662b5ea257d/54e69477-7697-43a2-9122-006fb641f43b','779d5f7d-4b59-47d7-ae31-6662b5ea257d',0,'7651f29b-5072-4a10-8218-dda8c9e96a46'),(47,'2025-11-29 05:39:35.990188','2025-11-29 05:39:58.725287','2025-11-29 05:39:58.723686',47,'192.168.122.100:6789:/volumes/_nogroup/4fc216c7-7565-440e-ba91-0a6f65473f45/ff906be0-0f97-4566-a624-2d1796676995','4fc216c7-7565-440e-ba91-0a6f65473f45',0,'530a370e-1d54-4dbf-a64b-ab9424314bef'),(48,'2025-11-29 05:39:37.726340','2025-11-29 05:39:44.704167','2025-11-29 05:39:44.703062',48,'192.168.122.100:6789:/volumes/_nogroup/06420fd0-e9c0-463d-9475-8429a0c8fd0d/e125f618-e0d3-4201-8eee-2d8020e28da7','06420fd0-e9c0-463d-9475-8429a0c8fd0d',0,'140ccd9b-6949-4988-a219-2a3ef77f0a6a'),(49,'2025-11-29 05:39:43.044824','2025-11-29 05:39:55.782781','2025-11-29 05:39:55.774402',49,'192.168.122.100:6789:/volumes/_nogroup/5b16d258-3e4e-4612-860f-4a4dc4e6aef6/7996470e-ab13-4df0-b527-040509a9a24a','5b16d258-3e4e-4612-860f-4a4dc4e6aef6',0,'15f6b66d-9979-4bea-80c1-159722f01587'),(50,'2025-11-29 05:39:47.150317','2025-11-29 05:39:51.649439','2025-11-29 05:39:51.648233',50,'192.168.122.100:6789:/volumes/_nogroup/adec6cb7-3928-4a56-9d48-76b4d10cc25a/635ad804-dcb1-4777-ae1d-f0b66a9736b7','adec6cb7-3928-4a56-9d48-76b4d10cc25a',0,'1c65e1b5-826e-4eb1-ba7c-73b9b3e41395'),(51,'2025-11-29 05:39:47.905010','2025-11-29 05:39:55.843005','2025-11-29 05:39:55.840138',51,'192.168.122.100:6789:/volumes/_nogroup/dddb87ae-5fcb-4c01-90f6-c57d130f8474/4b5f69bf-e0e1-4618-a5c9-3013324a337d','dddb87ae-5fcb-4c01-90f6-c57d130f8474',0,'e6fb477d-8da3-4322-83e0-ad1c1d21d6a4'),(52,'2025-11-29 05:40:23.054049','2025-11-29 05:40:23.765726','2025-11-29 05:40:23.764356',52,'192.168.122.100:6789:/volumes/_nogroup/70cb9e84-4e7b-4e83-b5ff-872d8a0e3944/75c755e3-5ba3-4412-8578-c62be99c7fab','70cb9e84-4e7b-4e83-b5ff-872d8a0e3944',0,'8f29f7ce-eff2-45ff-a353-e06b8203087e'),(53,'2025-11-29 05:40:23.268531','2025-11-29 05:40:23.267014',NULL,0,'192.168.122.100:6789:/volumes/_nogroup/e71bf388-0320-44c7-80f4-31f36b232ca1/7339c488-5326-4f67-ad2f-b921ebea9d49','e71bf388-0320-44c7-80f4-31f36b232ca1',0,'031970e5-b83b-4a11-8c25-2147b9459bb1'),(54,'2025-11-29 05:40:28.514205','2025-11-29 05:40:40.996511','2025-11-29 05:40:40.994689',54,'192.168.122.100:6789:/volumes/_nogroup/163fafb9-e2a0-4bac-af62-6ce4faca289f/90f52b09-bb8f-47eb-ad58-5054b86d7b35','163fafb9-e2a0-4bac-af62-6ce4faca289f',0,'4213470f-af18-4a81-a96f-e4ff06b55d0d'),(55,'2025-11-29 05:40:41.193712','2025-11-29 05:41:43.261099','2025-11-29 05:41:43.260117',55,'192.168.122.100:6789:/volumes/_nogroup/873c8599-1b6c-425f-8c5c-0a211fc50713/e4553e4d-304b-4c6d-85d9-c62092dcad25','873c8599-1b6c-425f-8c5c-0a211fc50713',0,'34a676d2-cb2d-4df6-bbc7-a54f4690ad21'),(56,'2025-11-29 05:40:43.831006','2025-11-29 05:41:35.773365','2025-11-29 05:41:35.772201',56,'192.168.122.100:6789:/volumes/_nogroup/07a65cd4-2777-43ad-b684-b3508a87dd10/c8d2661c-1803-4dda-9155-79cab369a656','07a65cd4-2777-43ad-b684-b3508a87dd10',0,'0fefdc21-7646-45cf-b390-0652b535e537'),(57,'2025-11-29 05:40:44.870244','2025-11-29 05:41:39.415738','2025-11-29 05:41:39.414103',57,'192.168.122.100:6789:/volumes/_nogroup/a0e01f60-977a-4212-be2c-851b3318eb22/cc5b8b78-4068-4d1a-9a26-90493fe411f5','a0e01f60-977a-4212-be2c-851b3318eb22',0,'49267251-7160-4f03-b875-ac9919fcb11b'),(58,'2025-11-29 05:40:49.446369','2025-11-29 05:41:35.934387','2025-11-29 05:41:35.933484',58,'192.168.122.100:6789:/volumes/_nogroup/fb7c7b44-2af1-44fc-8694-006120ff8320/4c1cf698-c200-41d2-ac17-97d695ba9a84','fb7c7b44-2af1-44fc-8694-006120ff8320',0,'036a829f-5f79-46b8-969c-709fc6f7b40f'),(59,'2025-11-29 05:40:52.435001','2025-11-29 05:41:03.371973','2025-11-29 05:41:03.370484',59,'192.168.122.100:6789:/volumes/_nogroup/0ff274bb-e3ac-4d57-8489-1cecf428692d/12d4fc6a-f535-4bf4-882d-c3b587116083','0ff274bb-e3ac-4d57-8489-1cecf428692d',0,'daa1492e-dccd-4efe-bfa5-9753a2447d73'),(60,'2025-11-29 05:41:06.888767','2025-11-29 05:41:18.345850','2025-11-29 05:41:18.344863',60,'192.168.122.100:6789:/volumes/_nogroup/9378b5f8-f3c7-4db4-98d1-4cf3955df852/33dc8892-0c70-46a8-ae06-d71322858225','9378b5f8-f3c7-4db4-98d1-4cf3955df852',0,'5f952464-36a1-4153-831c-fe48f1a1269e'),(61,'2025-11-29 05:41:17.964294','2025-11-29 05:41:33.076575','2025-11-29 05:41:33.075584',61,'192.168.122.100:6789:/volumes/_nogroup/28265ef5-ca45-4354-be2b-4e281fa424cd/b0384108-1904-48a8-a8b3-3bb88d8155ec','28265ef5-ca45-4354-be2b-4e281fa424cd',0,'6251b02c-8767-41fb-b93e-48c48c081a1b'),(62,'2025-11-29 05:41:21.970624','2025-11-29 05:43:09.816900','2025-11-29 05:43:09.815969',62,'192.168.122.100:6789:/volumes/_nogroup/dca14011-a433-40d4-8754-3eaafbae5faa/0b15d7c5-c29f-491e-8e79-ff980dbb8d2d','dca14011-a433-40d4-8754-3eaafbae5faa',0,'bbee4fe4-ceee-4160-ba88-fd7941360a65'),(63,'2025-11-29 05:42:22.929094','2025-11-29 05:43:00.543379','2025-11-29 05:43:00.542417',63,'192.168.122.100:6789:/volumes/_nogroup/a4fbeb19-4b4a-408e-8a0f-278794e0aaab/a159fbfa-75c1-4d65-9295-73f51ae6b10d','a4fbeb19-4b4a-408e-8a0f-278794e0aaab',0,'2d10170c-4392-4275-b8bb-58c856e34e86'),(64,'2025-11-29 05:42:26.534222','2025-11-29 05:42:33.722852','2025-11-29 05:42:33.721889',64,'192.168.122.100:6789:/volumes/_nogroup/4d6476ad-1951-44f5-839b-0b3b554d9116/c6e7ac6b-bc86-4fbc-8e82-cf9db559c311','4d6476ad-1951-44f5-839b-0b3b554d9116',0,'c47abc31-e632-4ab6-9ddd-8b6f5e973342'),(65,'2025-11-29 05:42:41.961860','2025-11-29 05:42:48.664615','2025-11-29 05:42:48.663515',65,'192.168.122.100:6789:/volumes/_nogroup/98efc0d9-c20a-4e7b-a016-a71069116a97/c30251ed-0f22-415c-b858-24bbe0aa7334','98efc0d9-c20a-4e7b-a016-a71069116a97',0,'4dc828a0-fd50-481a-a970-02f98b715716'),(66,'2025-11-29 05:42:42.251760','2025-11-29 05:42:53.854864','2025-11-29 05:42:53.853823',66,'192.168.122.100:6789:/volumes/_nogroup/fb848b69-a318-4691-8a4b-5a72fc808dc6/ea03b63f-0575-49d0-a109-d0b77faafea5','fb848b69-a318-4691-8a4b-5a72fc808dc6',0,'cdd4d2be-8234-450a-bd96-f53b5d11f875'),(67,'2025-11-29 05:42:52.187622','2025-11-29 05:42:56.925373','2025-11-29 05:42:56.923962',67,'192.168.122.100:6789:/volumes/_nogroup/d1e617bb-f4ed-4cc8-b966-2d95665d32f0/815337a0-8703-48c1-a91a-865eb64ab569','d1e617bb-f4ed-4cc8-b966-2d95665d32f0',0,'843a8fd7-b58a-4f19-8db9-24b60660866b'),(68,'2025-11-29 05:43:28.401487','2025-11-29 05:44:17.972245','2025-11-29 05:44:17.971318',68,'192.168.122.100:6789:/volumes/_nogroup/212fdd6d-2482-42c2-82e5-a1ecfd70ce27/d778921d-59a4-4fc2-859c-88676678105d','212fdd6d-2482-42c2-82e5-a1ecfd70ce27',0,'6e9786ca-ce63-4363-92ec-7ae656ed4fd9'),(69,'2025-11-29 05:43:37.861838','2025-11-29 05:43:41.514364','2025-11-29 05:43:41.512904',69,'192.168.122.100:6789:/volumes/_nogroup/7a2d6206-4f8b-4475-a6b1-28b365cca976/2c13b452-206f-439f-9aea-6a64868a5e5c','7a2d6206-4f8b-4475-a6b1-28b365cca976',0,'be3ff2cb-e014-4987-b5ee-26d2a4f67569'),(70,'2025-11-29 05:43:45.515120','2025-11-29 05:43:49.001513','2025-11-29 05:43:49.000403',70,'192.168.122.100:6789:/volumes/_nogroup/19b69edf-a49a-4027-a0e5-36e1c4984bfa/20aadc5c-a02f-41c4-98d0-45fa839d9cb6','19b69edf-a49a-4027-a0e5-36e1c4984bfa',0,'3535a06d-f5e7-4da7-b993-a56037860525'),(71,'2025-11-29 05:43:52.492453','2025-11-29 05:43:55.928722','2025-11-29 05:43:55.927841',71,'192.168.122.100:6789:/volumes/_nogroup/16246e8b-77e5-4422-a8a4-1522b5502edf/ae5d58ec-c55e-4535-9166-05e600cd33ad','16246e8b-77e5-4422-a8a4-1522b5502edf',0,'a0bad299-5701-4977-8b64-6fcb012b39ff'),(72,'2025-11-29 05:43:59.583390','2025-11-29 05:44:03.433979','2025-11-29 05:44:03.432564',72,'192.168.122.100:6789:/volumes/_nogroup/fa3cb891-f31e-45d1-aaa6-1610fdda8845/a6b2c776-146d-48c7-95c9-3c86df2edea5','fa3cb891-f31e-45d1-aaa6-1610fdda8845',0,'ae2fad80-6107-47ac-af35-4a1b33ebd7e1'),(73,'2025-11-29 05:44:06.939595','2025-11-29 05:44:10.935969','2025-11-29 05:44:10.934901',73,'192.168.122.100:6789:/volumes/_nogroup/479a8e74-0da9-4e81-a8a6-b7eb56d43c48/033f78cd-981f-4048-ab6b-5355aac2e5e3','479a8e74-0da9-4e81-a8a6-b7eb56d43c48',0,'b74a33f9-384e-4148-b324-f2713b44c08c');
/*!40000 ALTER TABLE `share_instance_export_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instance_export_locations_metadata`
--

DROP TABLE IF EXISTS `share_instance_export_locations_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instance_export_locations_metadata` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `export_location_id` int(11) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `elm_el_id_uc` (`export_location_id`,`key`,`deleted`),
  CONSTRAINT `elm_id_fk` FOREIGN KEY (`export_location_id`) REFERENCES `share_instance_export_locations` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instance_export_locations_metadata`
--

LOCK TABLES `share_instance_export_locations_metadata` WRITE;
/*!40000 ALTER TABLE `share_instance_export_locations_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_instance_export_locations_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instances`
--

DROP TABLE IF EXISTS `share_instances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instances` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `share_id` varchar(36) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `share_network_id` varchar(36) DEFAULT NULL,
  `share_server_id` varchar(36) DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  `access_rules_status` varchar(255) DEFAULT NULL,
  `replica_state` varchar(255) DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  `cast_rules_to_readonly` tinyint(1) NOT NULL,
  `progress` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `si_share_network_fk` (`share_network_id`),
  KEY `si_share_server_fk` (`share_server_id`),
  KEY `si_az_id_fk` (`availability_zone_id`),
  KEY `si_st_id_fk` (`share_type_id`),
  KEY `share_instances_share_id_idx` (`share_id`),
  CONSTRAINT `si_az_id_fk` FOREIGN KEY (`availability_zone_id`) REFERENCES `availability_zones` (`id`),
  CONSTRAINT `si_share_fk` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`),
  CONSTRAINT `si_share_network_fk` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`),
  CONSTRAINT `si_share_server_fk` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`),
  CONSTRAINT `si_st_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instances`
--

LOCK TABLES `share_instances` WRITE;
/*!40000 ALTER TABLE `share_instances` DISABLE KEYS */;
INSERT INTO `share_instances` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_id`, `host`, `status`, `scheduled_at`, `launched_at`, `terminated_at`, `share_network_id`, `share_server_id`, `availability_zone_id`, `access_rules_status`, `replica_state`, `share_type_id`, `cast_rules_to_readonly`, `progress`) VALUES ('2025-11-29 05:37:55.143402','2025-11-29 05:38:18.645641','2025-11-29 05:38:18.645036','0065e446-d05c-42f4-b14d-c32152b4c886','0065e446-d05c-42f4-b14d-c32152b4c886','1cd9a707-7d70-4c62-ba13-512b8025fb75','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:37:55','2025-11-29 05:37:55','2025-11-29 05:38:17',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'9d07efed-6109-49c2-afdb-237feef528bc',0,'100%'),('2025-11-29 05:34:36.259742','2025-11-29 05:34:44.311830','2025-11-29 05:34:44.311203','00bcce59-7712-4975-bf1e-f275f12b7d66','00bcce59-7712-4975-bf1e-f275f12b7d66','6b83ef1c-3572-49d6-a817-e57d3dbc62c9','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:34:36','2025-11-29 05:34:36','2025-11-29 05:34:44',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'7e5bc69e-c8de-413a-a484-248ded56b5e3',0,'100%'),('2025-11-29 05:37:35.718678','2025-11-29 05:37:40.386632','2025-11-29 05:37:40.386089','040becac-51dc-4867-bf68-cd9d237d5891','040becac-51dc-4867-bf68-cd9d237d5891','407283f6-7e71-4b3e-b4e6-abcfb3fd68be','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:37:35','2025-11-29 05:37:36','2025-11-29 05:37:40',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'15c7aea3-577a-4acc-8a07-1d147dd95e25',0,'100%'),('2025-11-29 05:35:08.789733','2025-11-29 05:35:18.233703','2025-11-29 05:35:18.232936','0626d330-257a-411d-9af3-ea14cd2279db','0626d330-257a-411d-9af3-ea14cd2279db','7a0eb625-aa27-409c-b778-2fc0d1a82ac0','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:35:09','2025-11-29 05:35:10','2025-11-29 05:35:17',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'078baedb-e7c7-47ca-9eae-f6d4445bee40',0,'100%'),('2025-11-29 05:39:37.445922','2025-11-29 05:39:44.716664','2025-11-29 05:39:44.716121','06420fd0-e9c0-463d-9475-8429a0c8fd0d','06420fd0-e9c0-463d-9475-8429a0c8fd0d','66a749f8-4cee-4a3e-8e40-a020973a1d4e','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:39:37','2025-11-29 05:39:37','2025-11-29 05:39:44',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'f8c8a67f-7464-472c-90a6-c0d7c3ba1b5d',0,'100%'),('2025-11-29 05:36:27.684377','2025-11-29 05:36:31.600363','2025-11-29 05:36:31.599700','071780a8-5727-4dfa-957f-74992074586b','071780a8-5727-4dfa-957f-74992074586b','bf0cb974-5bd9-4569-af3d-06e6cb5919af','','deleted','2025-11-29 05:36:27',NULL,NULL,NULL,NULL,NULL,'active',NULL,'7d4fb520-be4b-4ab9-a6cf-8d815f406791',0,NULL),('2025-11-29 05:40:43.595452','2025-11-29 05:41:35.785870','2025-11-29 05:41:35.785329','07a65cd4-2777-43ad-b684-b3508a87dd10','07a65cd4-2777-43ad-b684-b3508a87dd10','217acc03-b4a2-4cc6-b7f3-39aeb7e3d87e','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:40:43','2025-11-29 05:40:43','2025-11-29 05:41:35',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'a00ca480-cd9e-41b3-86ae-7b6a6e1f8033',0,'100%'),('2025-11-29 05:35:15.365698','2025-11-29 05:35:29.248977','2025-11-29 05:35:29.248225','08ff9271-7e61-496e-a296-8bfe1694c401','08ff9271-7e61-496e-a296-8bfe1694c401','b0a3c929-fe9e-45a1-8799-1aad57220f40','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:35:15','2025-11-29 05:35:15','2025-11-29 05:35:29',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'897b7777-bc91-41a3-a0ae-0cc41ffc72f9',0,'100%'),('2025-11-29 05:38:35.250850','2025-11-29 05:38:39.570308','2025-11-29 05:38:39.569735','0940c3a8-0a26-4b45-8cd5-2278d86a8159','0940c3a8-0a26-4b45-8cd5-2278d86a8159','12ebdbf1-f425-424d-9182-926c9f706b81','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:38:35','2025-11-29 05:38:36','2025-11-29 05:38:39',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'7c6b9483-7c46-438e-a204-efa953929f7b',0,'100%'),('2025-11-29 05:35:54.114671','2025-11-29 05:36:03.031526','2025-11-29 05:36:03.031004','09990eae-c6d2-4985-ad1a-d7539b5b0a71','09990eae-c6d2-4985-ad1a-d7539b5b0a71','c306547a-5139-4a85-935d-1f059e2e5a00','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:35:54','2025-11-29 05:35:54','2025-11-29 05:36:02',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'57502de6-1e0c-41d0-84e3-fe1b0b8839c8',0,'100%'),('2025-11-29 05:35:52.293084','2025-11-29 05:35:58.911402','2025-11-29 05:35:58.910420','0e332c7f-e0d3-46ad-9a13-7cf0840fc484','0e332c7f-e0d3-46ad-9a13-7cf0840fc484','7ad6d86a-1f98-465f-9724-374ac602131e','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:35:52','2025-11-29 05:35:52','2025-11-29 05:35:58',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'205bf72e-a1ad-4135-9618-25977b47af59',0,'100%'),('2025-11-29 05:40:52.192400','2025-11-29 05:41:03.449284','2025-11-29 05:41:03.448777','0ff274bb-e3ac-4d57-8489-1cecf428692d','0ff274bb-e3ac-4d57-8489-1cecf428692d','57846cd1-c190-4de4-9fa1-0159e8b2a7b8','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:40:52','2025-11-29 05:40:52','2025-11-29 05:41:03',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'deb5e28d-c187-482e-a13e-e6b5c6d26fe5',0,'100%'),('2025-11-29 05:34:27.245991','2025-11-29 05:34:31.972396','2025-11-29 05:34:31.971718','139756d1-c4a7-4d9e-860e-88e58c898640','139756d1-c4a7-4d9e-860e-88e58c898640','820c0659-0a9a-4f59-8e23-14e523dbf0fb','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:34:27','2025-11-29 05:34:27','2025-11-29 05:34:31',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'03041fd8-9b14-4a66-8c4c-4377210067b9',0,'100%'),('2025-11-29 05:43:52.242965','2025-11-29 05:43:55.944767','2025-11-29 05:43:55.944283','16246e8b-77e5-4422-a8a4-1522b5502edf','16246e8b-77e5-4422-a8a4-1522b5502edf','ef51f7d3-59b3-40e3-968a-ed03282d6e31','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:43:52','2025-11-29 05:43:52','2025-11-29 05:43:55',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'1c8161b4-ab6a-46c9-8c73-44780c20ec7e',0,'100%'),('2025-11-29 05:40:28.303223','2025-11-29 05:40:41.015254','2025-11-29 05:40:41.014493','163fafb9-e2a0-4bac-af62-6ce4faca289f','163fafb9-e2a0-4bac-af62-6ce4faca289f','d057cfa3-47b2-42be-8fcc-f0d7f7c8d87b','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:40:28','2025-11-29 05:40:28','2025-11-29 05:40:40',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'4bfe934f-b148-473c-af17-6b60d08583bb',0,'100%'),('2025-11-29 05:34:35.370440','2025-11-29 05:34:40.103699','2025-11-29 05:34:40.103039','18c23ac3-9de1-4499-a61d-bb17aaae0f7d','18c23ac3-9de1-4499-a61d-bb17aaae0f7d','a84fab06-0a2f-4cd4-a314-673cae274168','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:34:35','2025-11-29 05:34:35','2025-11-29 05:34:39',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'03041fd8-9b14-4a66-8c4c-4377210067b9',0,'100%'),('2025-11-29 05:43:45.193852','2025-11-29 05:43:49.016124','2025-11-29 05:43:49.015585','19b69edf-a49a-4027-a0e5-36e1c4984bfa','19b69edf-a49a-4027-a0e5-36e1c4984bfa','e0d41be5-4a19-4076-adbc-60e838484353','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:43:45','2025-11-29 05:43:45','2025-11-29 05:43:48',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'1c8161b4-ab6a-46c9-8c73-44780c20ec7e',0,'100%'),('2025-11-29 05:35:50.911068','2025-11-29 05:35:54.671558','2025-11-29 05:35:54.670559','1c978be0-f4c2-489e-bee2-5b79fc85b567','1c978be0-f4c2-489e-bee2-5b79fc85b567','d63b5112-aadb-407c-bec4-97c81b47af5b','','deleted','2025-11-29 05:35:50',NULL,NULL,NULL,NULL,NULL,'active',NULL,'d8457b4e-8e27-45f2-9628-fa0bc63046d3',0,NULL),('2025-11-29 05:38:27.453224','2025-11-29 05:38:31.970083','2025-11-29 05:38:31.966662','1d9d275b-9d0b-4256-9071-300779a207f4','1d9d275b-9d0b-4256-9071-300779a207f4','79a54e91-4fbe-4cd5-8b8d-544df0ba1f9e','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:38:27','2025-11-29 05:38:27','2025-11-29 05:38:31',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'7c6b9483-7c46-438e-a204-efa953929f7b',0,'100%'),('2025-11-29 05:37:43.726748','2025-11-29 05:37:49.121497','2025-11-29 05:37:49.120644','201b4694-8935-45ce-9803-6d0546c82ba7','201b4694-8935-45ce-9803-6d0546c82ba7','f32fbc4d-096b-4741-8c10-29c7bbfc8729','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:37:43','2025-11-29 05:37:44','2025-11-29 05:37:48',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'15c7aea3-577a-4acc-8a07-1d147dd95e25',0,'100%'),('2025-11-29 05:43:28.128897','2025-11-29 05:44:17.984590','2025-11-29 05:44:17.984086','212fdd6d-2482-42c2-82e5-a1ecfd70ce27','212fdd6d-2482-42c2-82e5-a1ecfd70ce27','dbd3da03-d3e4-4c33-93a8-95413e7575a1','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:43:28','2025-11-29 05:43:28','2025-11-29 05:44:17',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'1c8161b4-ab6a-46c9-8c73-44780c20ec7e',0,'100%'),('2025-11-29 05:37:02.878627','2025-11-29 05:37:09.189575','2025-11-29 05:37:09.188754','25c968fa-209f-495f-aace-23679fada541','25c968fa-209f-495f-aace-23679fada541','ebf707dc-21e8-4228-9f51-e71fcdfe6ff6','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:37:02','2025-11-29 05:37:03','2025-11-29 05:37:08',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'12e06c28-78cd-4240-8800-3060cf711953',0,'100%'),('2025-11-29 05:41:17.746584','2025-11-29 05:41:33.093628','2025-11-29 05:41:33.093081','28265ef5-ca45-4354-be2b-4e281fa424cd','28265ef5-ca45-4354-be2b-4e281fa424cd','61d56d6b-329f-4294-9bd8-fc4c72035af0','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:41:17','2025-11-29 05:41:17','2025-11-29 05:41:32',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'5dcffc4d-5ae1-4806-beb0-c80557d3ef41',0,'100%'),('2025-11-29 05:38:42.723914','2025-11-29 05:38:47.213136','2025-11-29 05:38:47.212462','2efbb8e6-d3d3-430b-8165-2af4490ffea0','2efbb8e6-d3d3-430b-8165-2af4490ffea0','afac464d-78fe-4919-adb9-f7d1119366fb','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:38:42','2025-11-29 05:38:43','2025-11-29 05:38:46',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'45b75960-3761-478e-bd9e-8a81899d6aa5',0,'100%'),('2025-11-29 05:36:10.712021','2025-11-29 05:36:18.587542','2025-11-29 05:36:18.586652','33d7ae2c-d7bb-41d9-8199-fe8f30f0d87e','33d7ae2c-d7bb-41d9-8199-fe8f30f0d87e','c77b407c-e863-41eb-ac34-17923aaa7053','','deleted','2025-11-29 05:36:10',NULL,NULL,NULL,NULL,NULL,'active',NULL,'bb4c2cdc-b39c-4d8f-a756-4b5a9da20637',0,NULL),('2025-11-29 05:38:04.981396','2025-11-29 05:38:08.572281','2025-11-29 05:38:08.571580','415ee1ee-37c5-49ea-9ecc-3aa40bc25402','415ee1ee-37c5-49ea-9ecc-3aa40bc25402','177748b2-71b4-434c-9c07-250bb252552d','','deleted','2025-11-29 05:38:04',NULL,NULL,NULL,NULL,NULL,'active',NULL,'3b823b97-f6b7-4e10-a49b-8c78cf594d17',0,NULL),('2025-11-29 05:38:49.887052','2025-11-29 05:39:02.215614','2025-11-29 05:39:02.215035','46ac263c-91aa-4770-862a-dd35f490382b','46ac263c-91aa-4770-862a-dd35f490382b','9a9718aa-cdac-400b-92ad-2d69eabfb34a','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:38:49','2025-11-29 05:38:50','2025-11-29 05:39:02',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'3715bc74-5c5d-42b9-996c-80000d22afc6',0,'100%'),('2025-11-29 05:44:06.609130','2025-11-29 05:44:10.950546','2025-11-29 05:44:10.950034','479a8e74-0da9-4e81-a8a6-b7eb56d43c48','479a8e74-0da9-4e81-a8a6-b7eb56d43c48','f8f6072d-5215-4606-b32a-f6cddf7569f1','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:44:06','2025-11-29 05:44:06','2025-11-29 05:44:10',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'1c8161b4-ab6a-46c9-8c73-44780c20ec7e',0,'100%'),('2025-11-29 05:35:40.278988','2025-11-29 05:36:29.380187','2025-11-29 05:36:29.379592','48601f02-9051-4603-a049-8748d3e87534','48601f02-9051-4603-a049-8748d3e87534','2af0b441-c8d2-4e9d-8906-65df11a5ea13','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:35:40','2025-11-29 05:35:40','2025-11-29 05:36:29',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'205bf72e-a1ad-4135-9618-25977b47af59',0,'100%'),('2025-11-29 05:42:26.266662','2025-11-29 05:42:33.746087','2025-11-29 05:42:33.745500','4d6476ad-1951-44f5-839b-0b3b554d9116','4d6476ad-1951-44f5-839b-0b3b554d9116','8e54542b-a2a5-45c9-85c3-3fefc8c82e34','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:42:26','2025-11-29 05:42:26','2025-11-29 05:42:33',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'b66b9d87-f8e3-4b31-946b-971c6c719cad',0,'100%'),('2025-11-29 05:39:35.800975','2025-11-29 05:39:58.751737','2025-11-29 05:39:58.751080','4fc216c7-7565-440e-ba91-0a6f65473f45','4fc216c7-7565-440e-ba91-0a6f65473f45','a48dc6cd-ba46-42ca-a17d-bcb8b85f2165','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:39:35','2025-11-29 05:39:36','2025-11-29 05:39:58',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'3ea6a207-e62f-4ff8-86d8-a7bd7b74ca3e',0,'100%'),('2025-11-29 05:34:43.467273','2025-11-29 05:34:44.645155','2025-11-29 05:34:44.644504','58d0834c-039f-43fa-9037-b2e41fbfffb3','58d0834c-039f-43fa-9037-b2e41fbfffb3','d3644a76-34c8-4895-a693-7991975adeb1','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:34:43','2025-11-29 05:34:43','2025-11-29 05:34:44',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'03041fd8-9b14-4a66-8c4c-4377210067b9',0,'100%'),('2025-11-29 05:39:39.655595','2025-11-29 05:39:55.819321','2025-11-29 05:39:55.818591','5b16d258-3e4e-4612-860f-4a4dc4e6aef6','5b16d258-3e4e-4612-860f-4a4dc4e6aef6','983ef5f8-b163-46cc-8069-4c6593961527','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:39:39','2025-11-29 05:39:43','2025-11-29 05:39:54',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'3ea6a207-e62f-4ff8-86d8-a7bd7b74ca3e',0,'100%'),('2025-11-29 05:39:24.724113','2025-11-29 05:39:28.665727','2025-11-29 05:39:28.664932','5ebeea41-cd85-43e6-b90c-d40733412d03','5ebeea41-cd85-43e6-b90c-d40733412d03','536723d5-2c13-4069-b56d-46bcda068e2d','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:39:24','2025-11-29 05:39:24','2025-11-29 05:39:28',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'c2ed6f66-a14c-4a73-8308-2de1b36a4619',0,'100%'),('2025-11-29 05:36:45.798688','2025-11-29 05:36:50.884160','2025-11-29 05:36:50.883475','63e32269-5cd1-4b91-be8c-8e96abc0fca0','63e32269-5cd1-4b91-be8c-8e96abc0fca0','8310bf7d-d76e-400d-b99f-6ef2581d15aa','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:36:45','2025-11-29 05:36:46','2025-11-29 05:36:50',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'eb844929-18ba-4d18-8fc0-5ba67aa3721e',0,'100%'),('2025-11-29 05:37:48.460329','2025-11-29 05:37:52.190713','2025-11-29 05:37:52.190112','64008006-d13d-4e5e-ab55-3a13f1ca4afa','64008006-d13d-4e5e-ab55-3a13f1ca4afa','6c7e4dab-ae52-4e96-adf9-a016c8ede2b3','','deleted','2025-11-29 05:37:48',NULL,NULL,NULL,NULL,NULL,'active',NULL,'1d21dac2-ed08-46ff-8c64-215bda949560',0,NULL),('2025-11-29 05:39:01.780959','2025-11-29 05:39:10.320783','2025-11-29 05:39:10.320094','651b4bb8-257f-4b27-8e91-4460977c10fa','651b4bb8-257f-4b27-8e91-4460977c10fa','bd641c8b-006a-42b6-8390-64c7bbd02a0b','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:39:01','2025-11-29 05:39:02','2025-11-29 05:39:09',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'85b2d88e-0dba-4f04-9990-9dd773d71543',0,'100%'),('2025-11-29 05:38:31.640087','2025-11-29 05:38:36.557638','2025-11-29 05:38:36.557051','6565f80a-02f8-4a73-b996-bca74f45d589','6565f80a-02f8-4a73-b996-bca74f45d589','42aa1a88-52cf-40d6-adfe-82a3d3291fa5','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:38:31','2025-11-29 05:38:32','2025-11-29 05:38:35',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'45b75960-3761-478e-bd9e-8a81899d6aa5',0,'100%'),('2025-11-29 05:35:59.007736','2025-11-29 05:36:06.323885','2025-11-29 05:36:06.321520','675a5330-66ec-4310-b213-10440aca090e','675a5330-66ec-4310-b213-10440aca090e','56d4f245-aad6-4afa-a1ec-3689faa4e66c','','deleted','2025-11-29 05:35:59',NULL,NULL,NULL,NULL,NULL,'active',NULL,'62dda89e-c74f-4ef4-9255-9731f4924d04',0,NULL),('2025-11-29 05:38:28.004517','2025-11-29 05:38:39.394838','2025-11-29 05:38:39.394274','6c79e8b2-8385-4693-a845-3fe4aa3849bb','6c79e8b2-8385-4693-a845-3fe4aa3849bb','fef80ee9-8f20-4491-a2df-e7d9e3f1ccfd','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:38:28','2025-11-29 05:38:28','2025-11-29 05:38:39',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'45b75960-3761-478e-bd9e-8a81899d6aa5',0,'100%'),('2025-11-29 05:39:38.941972','2025-11-29 05:40:23.787070','2025-11-29 05:40:23.786556','70cb9e84-4e7b-4e83-b5ff-872d8a0e3944','70cb9e84-4e7b-4e83-b5ff-872d8a0e3944','d15dc34f-8dd3-4087-95cc-e7788d546082','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:39:38','2025-11-29 05:39:39','2025-11-29 05:40:23',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'8cad685b-b732-4948-9276-cd3f373c0107',0,'100%'),('2025-11-29 05:36:23.537427','2025-11-29 05:36:55.225518','2025-11-29 05:36:55.224777','70f1f9a5-b960-4859-afd1-e8403dcbe455','70f1f9a5-b960-4859-afd1-e8403dcbe455','950d39d8-f939-4da1-9271-c5747d3cf4c8','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:36:23','2025-11-29 05:36:23','2025-11-29 05:36:54',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'f0da18b9-ba8c-41ec-8938-860c87e4760c',0,'100%'),('2025-11-29 05:36:35.555660','2025-11-29 05:36:48.403259','2025-11-29 05:36:48.402047','740417e2-7402-40fb-a24e-d743db894fa4','740417e2-7402-40fb-a24e-d743db894fa4','f6495022-cf62-4e63-92d8-438c96f9cb74','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:36:35','2025-11-29 05:36:35','2025-11-29 05:36:48',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'7f2792d4-06d9-4366-b057-6d917cc2fefa',0,'100%'),('2025-11-29 05:37:56.789975','2025-11-29 05:38:00.669675','2025-11-29 05:38:00.668871','7550695a-af09-463c-83a0-6f08c3e0a6b4','7550695a-af09-463c-83a0-6f08c3e0a6b4','3cecb700-a400-400a-be98-c6df0ec19bf4','','deleted','2025-11-29 05:37:56',NULL,NULL,NULL,NULL,NULL,'active',NULL,'3e7b666b-a9bd-4c69-8060-6813139fdc67',0,NULL),('2025-11-29 05:39:32.129066','2025-11-29 05:40:30.835194','2025-11-29 05:40:30.834479','779d5f7d-4b59-47d7-ae31-6662b5ea257d','779d5f7d-4b59-47d7-ae31-6662b5ea257d','d455a5e3-5638-439e-885b-3efb579e23f1','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:39:32','2025-11-29 05:39:32','2025-11-29 05:40:30',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'8cad685b-b732-4948-9276-cd3f373c0107',0,'100%'),('2025-11-29 05:38:06.804306','2025-11-29 05:38:18.382205','2025-11-29 05:38:18.381459','79586ddb-9940-4101-a183-8795d6ac1e84','79586ddb-9940-4101-a183-8795d6ac1e84','d130feab-d067-40a5-9960-d1bc564e2cc6','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:38:06','2025-11-29 05:38:07','2025-11-29 05:38:18',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'7c6b9483-7c46-438e-a204-efa953929f7b',0,'100%'),('2025-11-29 05:43:37.444741','2025-11-29 05:43:41.541933','2025-11-29 05:43:41.541193','7a2d6206-4f8b-4475-a6b1-28b365cca976','7a2d6206-4f8b-4475-a6b1-28b365cca976','928d0bd6-1e14-4ec9-8e20-61c818ace145','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:43:37','2025-11-29 05:43:37','2025-11-29 05:43:41',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'1c8161b4-ab6a-46c9-8c73-44780c20ec7e',0,'100%'),('2025-11-29 05:37:19.117428','2025-11-29 05:40:36.391705','2025-11-29 05:40:36.391243','848ba3c8-c30f-497b-9372-9c6fce9360b1','848ba3c8-c30f-497b-9372-9c6fce9360b1','d912f612-c8b0-4a4b-8ff9-2bb505956267','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:37:19','2025-11-29 05:37:19','2025-11-29 05:40:36',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'27ce7e9e-5dd7-42c3-997a-123357081bf4',0,'100%'),('2025-11-29 05:34:24.931199','2025-11-29 05:34:31.704217','2025-11-29 05:34:31.703194','86dc64fd-e983-41fb-88c2-0ca9782c4406','86dc64fd-e983-41fb-88c2-0ca9782c4406','8d46b7a0-c152-44f3-b3da-49c77bd2c58d','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:34:24','2025-11-29 05:34:25','2025-11-29 05:34:31',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'235d3753-6144-4b29-b569-50b44a6b7188',0,'100%'),('2025-11-29 05:40:40.972380','2025-11-29 05:41:43.281579','2025-11-29 05:41:43.280949','873c8599-1b6c-425f-8c5c-0a211fc50713','873c8599-1b6c-425f-8c5c-0a211fc50713','b21dc5b7-b92a-4537-a1e9-9593006a005c','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:40:41','2025-11-29 05:40:41','2025-11-29 05:41:42',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'5dcffc4d-5ae1-4806-beb0-c80557d3ef41',0,'100%'),('2025-11-29 05:35:43.930681','2025-11-29 05:35:49.056519','2025-11-29 05:35:49.056015','8f9a66be-c929-4519-9b84-590a248b55ea','8f9a66be-c929-4519-9b84-590a248b55ea','0dff3548-f4f7-4b80-9811-9a9168307144','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:35:43','2025-11-29 05:35:44','2025-11-29 05:35:48',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'205bf72e-a1ad-4135-9618-25977b47af59',0,'100%'),('2025-11-29 05:41:06.571475','2025-11-29 05:41:18.358312','2025-11-29 05:41:18.357827','9378b5f8-f3c7-4db4-98d1-4cf3955df852','9378b5f8-f3c7-4db4-98d1-4cf3955df852','1f0746c5-ce51-4a65-98e3-f72e5530a929','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:41:06','2025-11-29 05:41:06','2025-11-29 05:41:18',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'deb5e28d-c187-482e-a13e-e6b5c6d26fe5',0,'100%'),('2025-11-29 05:36:09.471643','2025-11-29 05:36:14.906402','2025-11-29 05:36:14.903840','969d69e3-5179-4284-9d56-4ddf6b5b95ef','969d69e3-5179-4284-9d56-4ddf6b5b95ef','71336145-ee0e-48b9-8ec3-eb037c4d1576','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:36:09','2025-11-29 05:36:09','2025-11-29 05:36:14',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'205bf72e-a1ad-4135-9618-25977b47af59',0,'100%'),('2025-11-29 05:42:41.673060','2025-11-29 05:42:48.691856','2025-11-29 05:42:48.691082','98efc0d9-c20a-4e7b-a016-a71069116a97','98efc0d9-c20a-4e7b-a016-a71069116a97','706ae3a3-b631-40be-bd6a-145f050623dc','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:42:41','2025-11-29 05:42:41','2025-11-29 05:42:48',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'b66b9d87-f8e3-4b31-946b-971c6c719cad',0,'100%'),('2025-11-29 05:36:20.150916','2025-11-29 05:36:23.390652','2025-11-29 05:36:23.390064','9f9bf0ea-9f71-4161-881f-1c5e81eea943','9f9bf0ea-9f71-4161-881f-1c5e81eea943','a862d85b-0423-409d-a586-753fa8e32d81','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:36:20','2025-11-29 05:36:20','2025-11-29 05:36:23',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'205bf72e-a1ad-4135-9618-25977b47af59',0,'100%'),('2025-11-29 05:36:23.047401','2025-11-29 05:36:27.094956','2025-11-29 05:36:27.094393','a0cfd12e-f59b-483b-b1e5-c1a77ffb4c09','a0cfd12e-f59b-483b-b1e5-c1a77ffb4c09','b358407f-b6af-44a4-9b96-bb8737f4a0ad','','deleted','2025-11-29 05:36:23',NULL,NULL,NULL,NULL,NULL,'active',NULL,'83704507-2af4-41ec-bd6a-c7c15772addd',0,NULL),('2025-11-29 05:40:44.638008','2025-11-29 05:41:39.433748','2025-11-29 05:41:39.432776','a0e01f60-977a-4212-be2c-851b3318eb22','a0e01f60-977a-4212-be2c-851b3318eb22','fb8bde6a-ba22-4cf8-9b0e-5314b29c6a6c','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:40:44','2025-11-29 05:40:44','2025-11-29 05:41:39',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'dd081b42-5cd7-4c7c-8a9b-8db684f71e20',0,'100%'),('2025-11-29 05:41:28.739453','2025-11-29 05:43:00.564137','2025-11-29 05:43:00.563583','a4fbeb19-4b4a-408e-8a0f-278794e0aaab','a4fbeb19-4b4a-408e-8a0f-278794e0aaab','4498b4b5-3a5f-43b2-8a0c-c035954ff1b7','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:41:28','2025-11-29 05:41:29','2025-11-29 05:43:00',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'b66b9d87-f8e3-4b31-946b-971c6c719cad',0,'100%'),('2025-11-29 05:37:17.305446','2025-11-29 05:37:34.061971','2025-11-29 05:37:34.061405','a9634de1-2230-40f8-a094-82f46777a70c','a9634de1-2230-40f8-a094-82f46777a70c','aaf64f7d-a6da-42d5-b6c4-1101918983fc','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:37:17','2025-11-29 05:37:17','2025-11-29 05:37:33',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'3cde5f7b-914b-4874-be2f-d7385fe4a149',0,'100%'),('2025-11-29 05:39:22.643580','2025-11-29 05:40:29.301362','2025-11-29 05:40:29.300808','a98b9fa5-d939-4fac-9215-346a94abca4f','a98b9fa5-d939-4fac-9215-346a94abca4f','ac81ac86-8832-44a3-9ddf-a1f9548b23ff','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:39:22','2025-11-29 05:39:22','2025-11-29 05:40:29',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'f8c8a67f-7464-472c-90a6-c0d7c3ba1b5d',0,'100%'),('2025-11-29 05:39:09.870568','2025-11-29 05:39:21.234180','2025-11-29 05:39:21.233738','adc37617-82af-4ff2-b1ff-41acd332035e','adc37617-82af-4ff2-b1ff-41acd332035e','9a6f70c7-49e7-4bfc-8dfe-7d8aa66f411a','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:39:09','2025-11-29 05:39:10','2025-11-29 05:39:21',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'7a4d5f0d-6975-4e09-abb0-f0f03a3782cc',0,'100%'),('2025-11-29 05:38:00.996069','2025-11-29 05:38:04.644148','2025-11-29 05:38:04.643521','add5bc54-0642-4545-9b0e-343f712445e6','add5bc54-0642-4545-9b0e-343f712445e6','3cc24ec6-7260-40a2-aa54-0fb231b3fa43','','deleted','2025-11-29 05:38:00',NULL,NULL,NULL,NULL,NULL,'active',NULL,'bfcc714f-2a94-4cb0-9045-624924898779',0,NULL),('2025-11-29 05:36:14.424910','2025-11-29 05:36:18.236363','2025-11-29 05:36:18.234668','add73258-2f41-4eff-969d-43860513b1f9','add73258-2f41-4eff-969d-43860513b1f9','a4719e97-03da-4127-8147-ec08a86a6bb3','','deleted','2025-11-29 05:36:14',NULL,NULL,NULL,NULL,NULL,'active',NULL,'644aee24-dced-4b70-b164-4e0bd00ebe5c',0,NULL),('2025-11-29 05:39:46.888505','2025-11-29 05:39:51.664314','2025-11-29 05:39:51.663535','adec6cb7-3928-4a56-9d48-76b4d10cc25a','adec6cb7-3928-4a56-9d48-76b4d10cc25a','275051e4-50a6-4dcd-b3f9-4e6781bc9228','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:39:46','2025-11-29 05:39:47','2025-11-29 05:39:51',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'3ea6a207-e62f-4ff8-86d8-a7bd7b74ca3e',0,'100%'),('2025-11-29 05:36:02.530104','2025-11-29 05:36:06.052496','2025-11-29 05:36:06.051863','b27217e7-cf50-4689-8a9c-ab02d8c63ada','b27217e7-cf50-4689-8a9c-ab02d8c63ada','befa686b-6239-457b-9216-72e72413f7e5','','deleted','2025-11-29 05:36:02',NULL,NULL,NULL,NULL,NULL,'active',NULL,'03e2ced0-98dd-40d4-ad9e-7539269b2b2c',0,NULL),('2025-11-29 05:35:55.139060','2025-11-29 05:35:58.705829','2025-11-29 05:35:58.704902','b8833fb9-1d77-48d3-b900-478c9bd4d150','b8833fb9-1d77-48d3-b900-478c9bd4d150','f0561e75-9a83-48e9-9d98-de66e0b6b547','','deleted','2025-11-29 05:35:55',NULL,NULL,NULL,NULL,NULL,'active',NULL,'77e59b2f-3ee6-4ed4-b09e-dedd3f47a51b',0,NULL),('2025-11-29 05:36:58.666058','2025-11-29 05:37:18.599860','2025-11-29 05:37:18.599027','bf9ab1fa-bd1c-475a-9ef3-389a03e28e9c','bf9ab1fa-bd1c-475a-9ef3-389a03e28e9c','45d34c7e-ddfe-479f-9e11-5ea1423144f0','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:36:58','2025-11-29 05:36:58','2025-11-29 05:37:18',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'819b63e0-5000-4547-bb28-596952ee3776',0,'100%'),('2025-11-29 05:35:13.435293','2025-11-29 05:35:23.125296','2025-11-29 05:35:23.124683','c22e2d86-7063-410a-82af-ad809d954609','c22e2d86-7063-410a-82af-ad809d954609','7c048789-8103-4100-b49c-67197de310c9','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:35:13','2025-11-29 05:35:13','2025-11-29 05:35:21',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'ddc6389e-dda9-47b0-85a7-6ad509ba0f38',0,'100%'),('2025-11-29 05:38:32.308578','2025-11-29 05:38:37.920130','2025-11-29 05:38:37.919511','c5ccc350-84d0-463a-8142-2450838c9e41','c5ccc350-84d0-463a-8142-2450838c9e41','32b3bd55-f887-4c7b-abf3-c0e58448cfc0','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:38:32','2025-11-29 05:38:32','2025-11-29 05:38:37',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'52f50bf6-cbc7-4a08-9f56-cebb024fa773',0,'100%'),('2025-11-29 05:39:26.859186','2025-11-29 05:39:34.434272','2025-11-29 05:39:34.433713','c7cad0a5-6ce4-4ca6-994f-ac3363a79f14','c7cad0a5-6ce4-4ca6-994f-ac3363a79f14','072f020d-2708-48db-82b6-eb693c43a81c','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:39:26','2025-11-29 05:39:27','2025-11-29 05:39:33',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'f8c8a67f-7464-472c-90a6-c0d7c3ba1b5d',0,'100%'),('2025-11-29 05:34:48.909887','2025-11-29 05:34:50.341528','2025-11-29 05:34:50.340680','c849ef50-3cb1-498e-ae97-f5cb56db1715','c849ef50-3cb1-498e-ae97-f5cb56db1715','2bab3e99-62f0-4af2-8df3-5f4fc80d6100','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:34:49','2025-11-29 05:34:49','2025-11-29 05:34:50',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'03041fd8-9b14-4a66-8c4c-4377210067b9',0,'100%'),('2025-11-29 05:35:58.817922','2025-11-29 05:36:03.008147','2025-11-29 05:36:03.007480','c8cd1abe-2662-4481-9c2f-01f70ea291ce','c8cd1abe-2662-4481-9c2f-01f70ea291ce','d311ffc6-efc2-45ab-a2ff-86e8bf6b1342','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:35:58','2025-11-29 05:35:59','2025-11-29 05:36:02',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'80792ca9-8a81-49c4-baba-8e68998249cb',0,'100%'),('2025-11-29 05:35:07.299814','2025-11-29 05:35:36.457050','2025-11-29 05:35:36.456401','cfa53e30-aa5d-48db-9775-60686b039ee1','cfa53e30-aa5d-48db-9775-60686b039ee1','f4322b3a-3450-4238-980c-d18815850d7d','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:35:08','2025-11-29 05:35:08','2025-11-29 05:35:36',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'897b7777-bc91-41a3-a0ae-0cc41ffc72f9',0,'100%'),('2025-11-29 05:42:51.951966','2025-11-29 05:42:56.939478','2025-11-29 05:42:56.938967','d1e617bb-f4ed-4cc8-b966-2d95665d32f0','d1e617bb-f4ed-4cc8-b966-2d95665d32f0','3bb9d2b2-8a58-41ba-b295-f8c5206246ea','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:42:52','2025-11-29 05:42:52','2025-11-29 05:42:56',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'b66b9d87-f8e3-4b31-946b-971c6c719cad',0,'100%'),('2025-11-29 05:41:21.535349','2025-11-29 05:43:09.841007','2025-11-29 05:43:09.840378','dca14011-a433-40d4-8754-3eaafbae5faa','dca14011-a433-40d4-8754-3eaafbae5faa','72b3c978-5d97-46cd-a8ea-f38c1eaf9039','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:41:21','2025-11-29 05:41:21','2025-11-29 05:43:09',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'b66b9d87-f8e3-4b31-946b-971c6c719cad',0,'100%'),('2025-11-29 05:39:47.493693','2025-11-29 05:39:55.863760','2025-11-29 05:39:55.862981','dddb87ae-5fcb-4c01-90f6-c57d130f8474','dddb87ae-5fcb-4c01-90f6-c57d130f8474','b5867587-3de3-43e0-8f9e-a5b7de6bde54','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:39:47','2025-11-29 05:39:47','2025-11-29 05:39:54',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'f8c8a67f-7464-472c-90a6-c0d7c3ba1b5d',0,'100%'),('2025-11-29 05:40:21.747855','2025-11-29 05:40:29.239320',NULL,'False','e71bf388-0320-44c7-80f4-31f36b232ca1','7bbfdea3-8114-4f5d-b029-3762625f5bc7','hostgroup@cephfs#cephfs','available','2025-11-29 05:40:21','2025-11-29 05:40:23',NULL,NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'27ce7e9e-5dd7-42c3-997a-123357081bf4',0,'100%'),('2025-11-29 05:34:23.295194','2025-11-29 05:35:44.495748','2025-11-29 05:35:44.490960','e887b8f7-1920-4aa9-a22b-586da6843031','e887b8f7-1920-4aa9-a22b-586da6843031','b8319b08-a988-4842-8476-2b1128958f34','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:34:23','2025-11-29 05:34:23','2025-11-29 05:35:44',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'03041fd8-9b14-4a66-8c4c-4377210067b9',0,'100%'),('2025-11-29 05:39:31.902659','2025-11-29 05:40:02.403192','2025-11-29 05:40:02.402394','ee8187c1-56b3-4603-8456-6c0a4e9f03fd','ee8187c1-56b3-4603-8456-6c0a4e9f03fd','9ce48378-5393-4d33-bcc2-afdeb6c4c2fe','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:39:31','2025-11-29 05:39:32','2025-11-29 05:40:01',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'3ea6a207-e62f-4ff8-86d8-a7bd7b74ca3e',0,'100%'),('2025-11-29 05:36:19.250705','2025-11-29 05:36:27.333836','2025-11-29 05:36:27.333094','f2a0c6ed-b772-46cc-bbea-9f7ab1c865d0','f2a0c6ed-b772-46cc-bbea-9f7ab1c865d0','be39336e-f884-45a4-b50c-d8ee1803bc79','','deleted','2025-11-29 05:36:19',NULL,NULL,NULL,NULL,NULL,'active',NULL,'a681e9d5-0cbf-4919-9306-45c3663a2e71',0,NULL),('2025-11-29 05:37:52.551834','2025-11-29 05:37:56.472831','2025-11-29 05:37:56.472262','f5bbf9c3-7329-440d-afa9-883dae761cd4','f5bbf9c3-7329-440d-afa9-883dae761cd4','62d5650f-e0da-4b7c-a132-3a85b7f0a4c8','','deleted','2025-11-29 05:37:52',NULL,NULL,NULL,NULL,NULL,'active',NULL,'407c3566-cec9-4eac-baeb-e009fd1528f3',0,NULL),('2025-11-29 05:43:59.343475','2025-11-29 05:44:03.450466','2025-11-29 05:44:03.449656','fa3cb891-f31e-45d1-aaa6-1610fdda8845','fa3cb891-f31e-45d1-aaa6-1610fdda8845','902d0c9f-7a57-4149-a230-c09dc7d9bdea','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:43:59','2025-11-29 05:43:59','2025-11-29 05:44:03',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'1c8161b4-ab6a-46c9-8c73-44780c20ec7e',0,'100%'),('2025-11-29 05:38:10.720972','2025-11-29 05:38:14.704703','2025-11-29 05:38:14.704152','faeaf227-675c-42df-9bf7-248fca8b7753','faeaf227-675c-42df-9bf7-248fca8b7753','28a8252f-ba0e-4938-9c9b-5f86d49b5f6a','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:38:10','2025-11-29 05:38:11','2025-11-29 05:38:14',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'7c6b9483-7c46-438e-a204-efa953929f7b',0,'100%'),('2025-11-29 05:36:02.185390','2025-11-29 05:36:06.186702','2025-11-29 05:36:06.186127','fb79334f-5107-432b-91aa-57c8d02f46a2','fb79334f-5107-432b-91aa-57c8d02f46a2','5c055a16-0c09-4ca8-b8c9-7c5826eecc33','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:36:02','2025-11-29 05:36:02','2025-11-29 05:36:05',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'205bf72e-a1ad-4135-9618-25977b47af59',0,'100%'),('2025-11-29 05:40:48.883625','2025-11-29 05:41:35.946389','2025-11-29 05:41:35.945907','fb7c7b44-2af1-44fc-8694-006120ff8320','fb7c7b44-2af1-44fc-8694-006120ff8320','60a27966-8e4b-44f9-8615-a66683748b87','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:40:49','2025-11-29 05:40:49','2025-11-29 05:41:35',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'dd081b42-5cd7-4c7c-8a9b-8db684f71e20',0,'100%'),('2025-11-29 05:42:42.040147','2025-11-29 05:42:53.868024','2025-11-29 05:42:53.867397','fb848b69-a318-4691-8a4b-5a72fc808dc6','fb848b69-a318-4691-8a4b-5a72fc808dc6','87225f6c-bfcc-41c4-9ef8-2ba0142f8320','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:42:42','2025-11-29 05:42:42','2025-11-29 05:42:53',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'2aa1bdf2-4191-465c-96d1-d1331c081762',0,'100%'),('2025-11-29 05:36:06.834952','2025-11-29 05:36:18.858848','2025-11-29 05:36:18.858075','fdd4123f-1c0c-4975-a2d1-6348bc331d91','fdd4123f-1c0c-4975-a2d1-6348bc331d91','e16e1ecc-c8d2-4e64-b3f6-d2d9870fa17d','','deleted','2025-11-29 05:36:06',NULL,NULL,NULL,NULL,NULL,'active',NULL,'e5dc9337-9d3d-486c-9f20-360499be97a6',0,NULL),('2025-11-29 05:36:27.700611','2025-11-29 05:36:51.070748','2025-11-29 05:36:51.070164','ff968508-e63c-4125-8d0a-ffeca3c4312c','ff968508-e63c-4125-8d0a-ffeca3c4312c','8c3cf27c-29e2-41bd-bd85-e08342a32955','hostgroup@cephfs#cephfs','deleted','2025-11-29 05:36:27','2025-11-29 05:36:27','2025-11-29 05:36:50',NULL,NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','active',NULL,'1f1645da-a938-4300-adbc-b0962ae574cd',0,'100%');
/*!40000 ALTER TABLE `share_instances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_metadata`
--

DROP TABLE IF EXISTS `share_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_metadata` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `share_id` (`share_id`),
  CONSTRAINT `share_metadata_ibfk_1` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=108 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_metadata`
--

LOCK TABLES `share_metadata` WRITE;
/*!40000 ALTER TABLE `share_metadata` DISABLE KEYS */;
INSERT INTO `share_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_id`, `key`, `value`) VALUES ('2025-11-29 05:34:23.720912',NULL,'2025-11-29 05:35:44.521218',1,1,'b8319b08-a988-4842-8476-2b1128958f34','__mount_options','fs=cephfs'),('2025-11-29 05:34:25.151451',NULL,'2025-11-29 05:34:31.741130',2,2,'8d46b7a0-c152-44f3-b3da-49c77bd2c58d','__mount_options','fs=cephfs'),('2025-11-29 05:34:27.562663',NULL,'2025-11-29 05:34:31.982067',3,3,'820c0659-0a9a-4f59-8e23-14e523dbf0fb','__mount_options','fs=cephfs'),('2025-11-29 05:34:35.613768',NULL,'2025-11-29 05:34:40.115753',4,4,'a84fab06-0a2f-4cd4-a314-673cae274168','__mount_options','fs=cephfs'),('2025-11-29 05:34:36.770331',NULL,'2025-11-29 05:34:44.322296',5,5,'6b83ef1c-3572-49d6-a817-e57d3dbc62c9','__mount_options','fs=cephfs'),('2025-11-29 05:34:43.719926',NULL,'2025-11-29 05:34:44.655028',6,6,'d3644a76-34c8-4895-a693-7991975adeb1','__mount_options','fs=cephfs'),('2025-11-29 05:34:49.246363',NULL,'2025-11-29 05:34:50.357541',7,7,'2bab3e99-62f0-4af2-8df3-5f4fc80d6100','__mount_options','fs=cephfs'),('2025-11-29 05:35:07.265782',NULL,'2025-11-29 05:35:36.469197',8,8,'f4322b3a-3450-4238-980c-d18815850d7d','foo_key_share_1','foo_value_share_1'),('2025-11-29 05:35:07.266490',NULL,'2025-11-29 05:35:36.469197',9,9,'f4322b3a-3450-4238-980c-d18815850d7d','bar_key_share_1','foo_value_share_1'),('2025-11-29 05:35:08.323660',NULL,'2025-11-29 05:35:36.469197',10,10,'f4322b3a-3450-4238-980c-d18815850d7d','__mount_options','fs=cephfs'),('2025-11-29 05:35:10.415972',NULL,'2025-11-29 05:35:18.243128',11,11,'7a0eb625-aa27-409c-b778-2fc0d1a82ac0','__mount_options','fs=cephfs'),('2025-11-29 05:35:13.654622',NULL,'2025-11-29 05:35:23.135862',12,12,'7c048789-8103-4100-b49c-67197de310c9','__mount_options','fs=cephfs'),('2025-11-29 05:35:15.329998',NULL,'2025-11-29 05:35:29.262633',13,13,'b0a3c929-fe9e-45a1-8799-1aad57220f40','foo_key_share_2','foo_value_share_2'),('2025-11-29 05:35:15.330687',NULL,'2025-11-29 05:35:29.262633',14,14,'b0a3c929-fe9e-45a1-8799-1aad57220f40','bar_key_share_2','foo_value_share_2'),('2025-11-29 05:35:15.657104',NULL,'2025-11-29 05:35:29.262633',15,15,'b0a3c929-fe9e-45a1-8799-1aad57220f40','__mount_options','fs=cephfs'),('2025-11-29 05:35:40.638603',NULL,'2025-11-29 05:36:29.402307',16,16,'2af0b441-c8d2-4e9d-8906-65df11a5ea13','__mount_options','fs=cephfs'),('2025-11-29 05:35:44.183378',NULL,'2025-11-29 05:35:49.066528',17,17,'0dff3548-f4f7-4b80-9811-9a9168307144','__mount_options','fs=cephfs'),('2025-11-29 05:35:47.584522',NULL,'2025-11-29 05:35:49.066528',18,18,'0dff3548-f4f7-4b80-9811-9a9168307144','key5','value5'),('2025-11-29 05:35:47.588922',NULL,'2025-11-29 05:35:49.066528',19,19,'0dff3548-f4f7-4b80-9811-9a9168307144','key6','value6'),('2025-11-29 05:35:47.913392',NULL,'2025-11-29 05:35:49.066528',20,20,'0dff3548-f4f7-4b80-9811-9a9168307144','key7','value7'),('2025-11-29 05:35:47.916370',NULL,'2025-11-29 05:35:49.066528',21,21,'0dff3548-f4f7-4b80-9811-9a9168307144','key8','value8'),('2025-11-29 05:35:52.597223',NULL,'2025-11-29 05:35:58.969280',22,22,'7ad6d86a-1f98-465f-9724-374ac602131e','__mount_options','fs=cephfs'),('2025-11-29 05:35:54.323499',NULL,'2025-11-29 05:36:03.043186',23,23,'c306547a-5139-4a85-935d-1f059e2e5a00','__mount_options','fs=cephfs'),('2025-11-29 05:35:55.892064',NULL,'2025-11-29 05:35:58.969280',24,24,'7ad6d86a-1f98-465f-9724-374ac602131e','key3','value3'),('2025-11-29 05:35:55.895679',NULL,'2025-11-29 05:35:58.969280',25,25,'7ad6d86a-1f98-465f-9724-374ac602131e','key4','value4'),('2025-11-29 05:35:55.899931',NULL,'2025-11-29 05:35:58.969280',26,26,'7ad6d86a-1f98-465f-9724-374ac602131e','key.5.1','value.5'),('2025-11-29 05:35:59.122679',NULL,'2025-11-29 05:36:03.019017',27,27,'d311ffc6-efc2-45ab-a2ff-86e8bf6b1342','__mount_options','fs=cephfs'),('2025-11-29 05:36:02.157991',NULL,'2025-11-29 05:36:06.197300',28,28,'5c055a16-0c09-4ca8-b8c9-7c5826eecc33','key1','value1'),('2025-11-29 05:36:02.158554',NULL,'2025-11-29 05:36:06.197300',29,29,'5c055a16-0c09-4ca8-b8c9-7c5826eecc33','key2','value2'),('2025-11-29 05:36:02.521717',NULL,'2025-11-29 05:36:06.197300',30,30,'5c055a16-0c09-4ca8-b8c9-7c5826eecc33','__mount_options','fs=cephfs'),('2025-11-29 05:36:09.704320',NULL,'2025-11-29 05:36:14.918283',31,31,'71336145-ee0e-48b9-8ec3-eb037c4d1576','__mount_options','fs=cephfs'),('2025-11-29 05:36:12.980051','2025-11-29 05:36:13.356034','2025-11-29 05:36:14.918283',32,32,'71336145-ee0e-48b9-8ec3-eb037c4d1576','key9','value13'),('2025-11-29 05:36:12.985153',NULL,'2025-11-29 05:36:14.918283',33,33,'71336145-ee0e-48b9-8ec3-eb037c4d1576','key10','value10'),('2025-11-29 05:36:13.373345',NULL,'2025-11-29 05:36:14.918283',34,34,'71336145-ee0e-48b9-8ec3-eb037c4d1576','key11','value11'),('2025-11-29 05:36:18.349816',NULL,'2025-11-29 05:36:29.402307',35,35,'2af0b441-c8d2-4e9d-8906-65df11a5ea13','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value'),('2025-11-29 05:36:18.772494','2025-11-29 05:36:19.781026','2025-11-29 05:36:29.402307',36,36,'2af0b441-c8d2-4e9d-8906-65df11a5ea13','key','v'),('2025-11-29 05:36:19.162777',NULL,'2025-11-29 05:36:29.402307',37,37,'2af0b441-c8d2-4e9d-8906-65df11a5ea13','k','value'),('2025-11-29 05:36:20.423360',NULL,'2025-11-29 05:36:23.401198',38,38,'a862d85b-0423-409d-a586-753fa8e32d81','__mount_options','fs=cephfs'),('2025-11-29 05:36:20.697845',NULL,'2025-11-29 05:36:23.401198',39,39,'a862d85b-0423-409d-a586-753fa8e32d81','key9','value9'),('2025-11-29 05:36:20.702040',NULL,'2025-11-29 05:36:23.401198',40,40,'a862d85b-0423-409d-a586-753fa8e32d81','key10','value10'),('2025-11-29 05:36:21.154538',NULL,'2025-11-29 05:36:23.401198',41,41,'a862d85b-0423-409d-a586-753fa8e32d81','key11','value11'),('2025-11-29 05:36:21.159518',NULL,'2025-11-29 05:36:23.401198',42,42,'a862d85b-0423-409d-a586-753fa8e32d81','key12','value12'),('2025-11-29 05:36:23.780954',NULL,'2025-11-29 05:36:55.243468',43,43,'950d39d8-f939-4da1-9271-c5747d3cf4c8','__mount_options','fs=cephfs'),('2025-11-29 05:36:26.981170',NULL,'2025-11-29 05:36:29.402307',44,44,'2af0b441-c8d2-4e9d-8906-65df11a5ea13','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value'),('2025-11-29 05:36:27.491804',NULL,'2025-11-29 05:36:29.402307',45,45,'2af0b441-c8d2-4e9d-8906-65df11a5ea13','key','vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv'),('2025-11-29 05:36:27.931722',NULL,'2025-11-29 05:36:29.402307',46,46,'2af0b441-c8d2-4e9d-8906-65df11a5ea13','k','value'),('2025-11-29 05:36:27.947739',NULL,'2025-11-29 05:36:51.084161',47,47,'8c3cf27c-29e2-41bd-bd85-e08342a32955','__mount_options','fs=cephfs'),('2025-11-29 05:36:28.243967',NULL,'2025-11-29 05:36:29.402307',48,48,'2af0b441-c8d2-4e9d-8906-65df11a5ea13','key','v'),('2025-11-29 05:36:35.782741',NULL,'2025-11-29 05:36:48.418027',49,49,'f6495022-cf62-4e63-92d8-438c96f9cb74','__mount_options','fs=cephfs'),('2025-11-29 05:36:46.055768',NULL,'2025-11-29 05:36:50.903750',50,50,'8310bf7d-d76e-400d-b99f-6ef2581d15aa','__mount_options','fs=cephfs'),('2025-11-29 05:36:58.945184',NULL,'2025-11-29 05:37:18.613023',51,51,'45d34c7e-ddfe-479f-9e11-5ea1423144f0','__mount_options','fs=cephfs'),('2025-11-29 05:37:03.141006',NULL,'2025-11-29 05:37:09.198761',52,52,'ebf707dc-21e8-4228-9f51-e71fcdfe6ff6','__mount_options','fs=cephfs'),('2025-11-29 05:37:17.601869',NULL,'2025-11-29 05:37:34.070976',53,53,'aaf64f7d-a6da-42d5-b6c4-1101918983fc','__mount_options','fs=cephfs'),('2025-11-29 05:37:19.401918',NULL,'2025-11-29 05:40:36.402765',54,54,'d912f612-c8b0-4a4b-8ff9-2bb505956267','__mount_options','fs=cephfs'),('2025-11-29 05:37:35.990333',NULL,'2025-11-29 05:37:40.396118',55,55,'407283f6-7e71-4b3e-b4e6-abcfb3fd68be','__mount_options','fs=cephfs'),('2025-11-29 05:37:43.981539',NULL,'2025-11-29 05:37:49.132519',56,56,'f32fbc4d-096b-4741-8c10-29c7bbfc8729','__mount_options','fs=cephfs'),('2025-11-29 05:37:55.407684',NULL,'2025-11-29 05:38:18.803168',57,57,'1cd9a707-7d70-4c62-ba13-512b8025fb75','__mount_options','fs=cephfs'),('2025-11-29 05:38:07.039141',NULL,'2025-11-29 05:38:18.397478',58,58,'d130feab-d067-40a5-9960-d1bc564e2cc6','__mount_options','fs=cephfs'),('2025-11-29 05:38:11.242461',NULL,'2025-11-29 05:38:14.713679',59,59,'28a8252f-ba0e-4938-9c9b-5f86d49b5f6a','__mount_options','fs=cephfs'),('2025-11-29 05:38:27.716691',NULL,'2025-11-29 05:38:32.002010',60,60,'79a54e91-4fbe-4cd5-8b8d-544df0ba1f9e','__mount_options','fs=cephfs'),('2025-11-29 05:38:28.272775',NULL,'2025-11-29 05:38:39.408679',61,61,'fef80ee9-8f20-4491-a2df-e7d9e3f1ccfd','__mount_options','fs=cephfs'),('2025-11-29 05:38:32.445043',NULL,'2025-11-29 05:38:36.569948',62,62,'42aa1a88-52cf-40d6-adfe-82a3d3291fa5','__mount_options','fs=cephfs'),('2025-11-29 05:38:32.846685',NULL,'2025-11-29 05:38:37.931474',63,63,'32b3bd55-f887-4c7b-abf3-c0e58448cfc0','__mount_options','fs=cephfs'),('2025-11-29 05:38:36.466393',NULL,'2025-11-29 05:38:39.580421',64,64,'12ebdbf1-f425-424d-9182-926c9f706b81','__mount_options','fs=cephfs'),('2025-11-29 05:38:43.002582',NULL,'2025-11-29 05:38:47.224345',65,65,'afac464d-78fe-4919-adb9-f7d1119366fb','__mount_options','fs=cephfs'),('2025-11-29 05:38:50.138910',NULL,'2025-11-29 05:39:02.230365',66,66,'9a9718aa-cdac-400b-92ad-2d69eabfb34a','__mount_options','fs=cephfs'),('2025-11-29 05:39:01.738437',NULL,'2025-11-29 05:39:10.333960',67,67,'bd641c8b-006a-42b6-8390-64c7bbd02a0b','key','value'),('2025-11-29 05:39:02.042577',NULL,'2025-11-29 05:39:10.333960',68,68,'bd641c8b-006a-42b6-8390-64c7bbd02a0b','__mount_options','fs=cephfs'),('2025-11-29 05:39:10.179983',NULL,'2025-11-29 05:39:21.247078',69,69,'9a6f70c7-49e7-4bfc-8dfe-7d8aa66f411a','__mount_options','fs=cephfs'),('2025-11-29 05:39:22.908125',NULL,'2025-11-29 05:40:29.313375',70,70,'ac81ac86-8832-44a3-9ddf-a1f9548b23ff','__mount_options','fs=cephfs'),('2025-11-29 05:39:24.906015',NULL,'2025-11-29 05:39:28.676325',71,71,'536723d5-2c13-4069-b56d-46bcda068e2d','__mount_options','fs=cephfs'),('2025-11-29 05:39:27.066430',NULL,'2025-11-29 05:39:34.444602',72,72,'072f020d-2708-48db-82b6-eb693c43a81c','__mount_options','fs=cephfs'),('2025-11-29 05:39:32.175242',NULL,'2025-11-29 05:40:02.423261',73,73,'9ce48378-5393-4d33-bcc2-afdeb6c4c2fe','__mount_options','fs=cephfs'),('2025-11-29 05:39:32.384905',NULL,'2025-11-29 05:40:30.844639',74,74,'d455a5e3-5638-439e-885b-3efb579e23f1','__mount_options','fs=cephfs'),('2025-11-29 05:39:35.981980',NULL,'2025-11-29 05:39:58.766329',75,75,'a48dc6cd-ba46-42ca-a17d-bcb8b85f2165','__mount_options','fs=cephfs'),('2025-11-29 05:39:37.714740',NULL,'2025-11-29 05:39:44.726034',76,76,'66a749f8-4cee-4a3e-8e40-a020973a1d4e','__mount_options','fs=cephfs'),('2025-11-29 05:39:39.209866',NULL,'2025-11-29 05:40:23.802336',77,77,'d15dc34f-8dd3-4087-95cc-e7788d546082','__mount_options','fs=cephfs'),('2025-11-29 05:39:43.020479',NULL,'2025-11-29 05:39:55.837393',78,78,'983ef5f8-b163-46cc-8069-4c6593961527','__mount_options','fs=cephfs'),('2025-11-29 05:39:47.134321',NULL,'2025-11-29 05:39:51.675663',79,79,'275051e4-50a6-4dcd-b3f9-4e6781bc9228','__mount_options','fs=cephfs'),('2025-11-29 05:39:47.894964',NULL,'2025-11-29 05:39:55.882060',80,80,'b5867587-3de3-43e0-8f9e-a5b7de6bde54','__mount_options','fs=cephfs'),('2025-11-29 05:40:23.254151',NULL,NULL,0,81,'7bbfdea3-8114-4f5d-b029-3762625f5bc7','__mount_options','fs=cephfs'),('2025-11-29 05:40:28.503374',NULL,'2025-11-29 05:40:41.026805',82,82,'d057cfa3-47b2-42be-8fcc-f0d7f7c8d87b','__mount_options','fs=cephfs'),('2025-11-29 05:40:41.184578',NULL,'2025-11-29 05:41:43.292226',83,83,'b21dc5b7-b92a-4537-a1e9-9593006a005c','__mount_options','fs=cephfs'),('2025-11-29 05:40:43.820179',NULL,'2025-11-29 05:41:35.797426',84,84,'217acc03-b4a2-4cc6-b7f3-39aeb7e3d87e','__mount_options','fs=cephfs'),('2025-11-29 05:40:44.860158',NULL,'2025-11-29 05:41:39.448813',85,85,'fb8bde6a-ba22-4cf8-9b0e-5314b29c6a6c','__mount_options','fs=cephfs'),('2025-11-29 05:40:49.387151',NULL,'2025-11-29 05:41:35.954738',86,86,'60a27966-8e4b-44f9-8615-a66683748b87','__mount_options','fs=cephfs'),('2025-11-29 05:40:52.424780',NULL,'2025-11-29 05:41:03.460667',87,87,'57846cd1-c190-4de4-9fa1-0159e8b2a7b8','__mount_options','fs=cephfs'),('2025-11-29 05:41:06.875747',NULL,'2025-11-29 05:41:18.367189',88,88,'1f0746c5-ce51-4a65-98e3-f72e5530a929','__mount_options','fs=cephfs'),('2025-11-29 05:41:17.951845',NULL,'2025-11-29 05:41:33.106323',89,89,'61d56d6b-329f-4294-9bd8-fc4c72035af0','__mount_options','fs=cephfs'),('2025-11-29 05:41:21.495971',NULL,'2025-11-29 05:43:09.862079',90,90,'72b3c978-5d97-46cd-a8ea-f38c1eaf9039','foo_key_share_1','foo_value_share_1'),('2025-11-29 05:41:21.496480',NULL,'2025-11-29 05:43:09.862079',91,91,'72b3c978-5d97-46cd-a8ea-f38c1eaf9039','bar_key_share_1','foo_value_share_1'),('2025-11-29 05:41:21.952451',NULL,'2025-11-29 05:43:09.862079',92,92,'72b3c978-5d97-46cd-a8ea-f38c1eaf9039','__mount_options','fs=cephfs'),('2025-11-29 05:41:28.709605',NULL,'2025-11-29 05:43:00.581899',93,93,'4498b4b5-3a5f-43b2-8a0c-c035954ff1b7','foo_key_share_2','foo_value_share_2'),('2025-11-29 05:41:28.710176',NULL,'2025-11-29 05:43:00.581899',94,94,'4498b4b5-3a5f-43b2-8a0c-c035954ff1b7','bar_key_share_2','foo_value_share_2'),('2025-11-29 05:41:29.016883',NULL,'2025-11-29 05:43:00.581899',95,95,'4498b4b5-3a5f-43b2-8a0c-c035954ff1b7','__mount_options','fs=cephfs'),('2025-11-29 05:42:26.522371',NULL,'2025-11-29 05:42:33.755294',96,96,'8e54542b-a2a5-45c9-85c3-3fefc8c82e34','__mount_options','fs=cephfs'),('2025-11-29 05:42:41.940317',NULL,'2025-11-29 05:42:48.703537',97,97,'706ae3a3-b631-40be-bd6a-145f050623dc','__mount_options','fs=cephfs'),('2025-11-29 05:42:42.018431',NULL,'2025-11-29 05:42:53.881711',98,98,'87225f6c-bfcc-41c4-9ef8-2ba0142f8320','foo_key_share_1','foo_value_share_1'),('2025-11-29 05:42:42.018758',NULL,'2025-11-29 05:42:53.881711',99,99,'87225f6c-bfcc-41c4-9ef8-2ba0142f8320','bar_key_share_1','foo_value_share_1'),('2025-11-29 05:42:42.240852',NULL,'2025-11-29 05:42:53.881711',100,100,'87225f6c-bfcc-41c4-9ef8-2ba0142f8320','__mount_options','fs=cephfs'),('2025-11-29 05:42:52.177918',NULL,'2025-11-29 05:42:56.951916',101,101,'3bb9d2b2-8a58-41ba-b295-f8c5206246ea','__mount_options','fs=cephfs'),('2025-11-29 05:43:28.350024',NULL,'2025-11-29 05:44:17.995873',102,102,'dbd3da03-d3e4-4c33-93a8-95413e7575a1','__mount_options','fs=cephfs'),('2025-11-29 05:43:37.853818',NULL,'2025-11-29 05:43:41.552162',103,103,'928d0bd6-1e14-4ec9-8e20-61c818ace145','__mount_options','fs=cephfs'),('2025-11-29 05:43:45.503077',NULL,'2025-11-29 05:43:49.024495',104,104,'e0d41be5-4a19-4076-adbc-60e838484353','__mount_options','fs=cephfs'),('2025-11-29 05:43:52.480884',NULL,'2025-11-29 05:43:55.953498',105,105,'ef51f7d3-59b3-40e3-968a-ed03282d6e31','__mount_options','fs=cephfs'),('2025-11-29 05:43:59.566400',NULL,'2025-11-29 05:44:03.459640',106,106,'902d0c9f-7a57-4149-a230-c09dc7d9bdea','__mount_options','fs=cephfs'),('2025-11-29 05:44:06.914985',NULL,'2025-11-29 05:44:10.958705',107,107,'f8f6072d-5215-4606-b32a-f6cddf7569f1','__mount_options','fs=cephfs');
/*!40000 ALTER TABLE `share_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_network_security_service_association`
--

DROP TABLE IF EXISTS `share_network_security_service_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_network_security_service_association` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_network_id` varchar(36) NOT NULL,
  `security_service_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `share_network_id` (`share_network_id`),
  KEY `security_service_id` (`security_service_id`),
  CONSTRAINT `share_network_security_service_association_ibfk_1` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`),
  CONSTRAINT `share_network_security_service_association_ibfk_2` FOREIGN KEY (`security_service_id`) REFERENCES `security_services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_network_security_service_association`
--

LOCK TABLES `share_network_security_service_association` WRITE;
/*!40000 ALTER TABLE `share_network_security_service_association` DISABLE KEYS */;
INSERT INTO `share_network_security_service_association` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_network_id`, `security_service_id`) VALUES ('2025-11-29 05:36:12.577089','2025-11-29 05:36:15.002657','2025-11-29 05:36:15.001857',1,1,'9f9768ec-057d-4e9b-bbb3-cfc88c707c5c','32e44af5-820e-454d-8a6b-bda2f4821cc0'),('2025-11-29 05:36:13.142120',NULL,NULL,0,2,'7076c8f1-72d8-4009-82c9-71f634d26f76','add841a3-f305-4710-88de-7bed736a1c54'),('2025-11-29 05:39:23.453160','2025-11-29 05:39:23.548860','2025-11-29 05:39:23.548022',3,3,'1c4aece8-f27e-43a8-ad31-1a0f9e43f22c','7e2ead46-45f0-49c1-8c92-cd6b5f5b4931'),('2025-11-29 05:39:24.330258','2025-11-29 05:39:24.714119','2025-11-29 05:39:24.713022',4,4,'73eb66eb-183f-4313-a6de-6134145ec486','7db487bf-52b0-4728-854a-0a3965da721c'),('2025-11-29 05:39:25.135747','2025-11-29 05:39:25.268230','2025-11-29 05:39:25.267759',5,5,'3c717263-1af0-4d6c-a65c-9b92655539ce','a68243e1-45fa-4857-8a7a-bef62873bdb8'),('2025-11-29 05:39:25.425066','2025-11-29 05:39:25.585466','2025-11-29 05:39:25.585150',6,6,'3c717263-1af0-4d6c-a65c-9b92655539ce','a68243e1-45fa-4857-8a7a-bef62873bdb8'),('2025-11-29 05:40:57.653178','2025-11-29 05:41:01.277361','2025-11-29 05:41:01.276975',7,7,'066eadcc-302c-467d-ab3d-10f535629782','38e7fb5c-7172-46dc-9274-dbc11b1221fe'),('2025-11-29 05:40:57.974010','2025-11-29 05:41:00.979070','2025-11-29 05:41:00.978702',8,8,'b5e11d5e-2232-49b2-b757-e64c07846443','b8cbd9d3-c944-4a40-aefb-04c6694ee8b9'),('2025-11-29 05:42:13.201920','2025-11-29 05:42:17.016536','2025-11-29 05:42:17.016201',9,9,'f8b6b6b8-3dbc-41b1-827e-fa7206a74159','9c2815f1-fde0-4314-8565-743215baf771'),('2025-11-29 05:42:13.928592','2025-11-29 05:42:14.141116','2025-11-29 05:42:14.140855',10,10,'0df8c6a0-8fc7-448f-ad1c-aa1db29818f7','3824d793-9cfe-4882-8bac-225ba572846f'),('2025-11-29 05:42:14.905933','2025-11-29 05:42:15.394563','2025-11-29 05:42:15.393353',11,11,'fbb650d7-3f79-4f40-99fb-542fb6a36517','960832bd-8f66-4854-9ab8-2d3ae0918964');
/*!40000 ALTER TABLE `share_network_security_service_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_network_subnet_metadata`
--

DROP TABLE IF EXISTS `share_network_subnet_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_network_subnet_metadata` (
  `deleted` varchar(36) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_network_subnet_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `share_network_subnet_id` (`share_network_subnet_id`),
  CONSTRAINT `share_network_subnet_metadata_ibfk_1` FOREIGN KEY (`share_network_subnet_id`) REFERENCES `share_network_subnets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_network_subnet_metadata`
--

LOCK TABLES `share_network_subnet_metadata` WRITE;
/*!40000 ALTER TABLE `share_network_subnet_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_network_subnet_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_network_subnets`
--

DROP TABLE IF EXISTS `share_network_subnets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_network_subnets` (
  `id` varchar(36) NOT NULL,
  `neutron_net_id` varchar(36) DEFAULT NULL,
  `neutron_subnet_id` varchar(36) DEFAULT NULL,
  `network_type` varchar(32) DEFAULT NULL,
  `cidr` varchar(64) DEFAULT NULL,
  `segmentation_id` int(11) DEFAULT NULL,
  `gateway` varchar(64) DEFAULT NULL,
  `mtu` int(11) DEFAULT NULL,
  `share_network_id` varchar(36) DEFAULT NULL,
  `ip_version` int(11) DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_share_network_subnets_share_network_id_share_networks` (`share_network_id`),
  KEY `fk_share_network_subnets_availaility_zone_id_availability_zones` (`availability_zone_id`),
  CONSTRAINT `fk_share_network_subnets_availaility_zone_id_availability_zones` FOREIGN KEY (`availability_zone_id`) REFERENCES `availability_zones` (`id`),
  CONSTRAINT `fk_share_network_subnets_share_network_id_share_networks` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_network_subnets`
--

LOCK TABLES `share_network_subnets` WRITE;
/*!40000 ALTER TABLE `share_network_subnets` DISABLE KEYS */;
INSERT INTO `share_network_subnets` (`id`, `neutron_net_id`, `neutron_subnet_id`, `network_type`, `cidr`, `segmentation_id`, `gateway`, `mtu`, `share_network_id`, `ip_version`, `availability_zone_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES ('0bd7a25a-0791-422a-9e9f-f35fc4b262fd','tempest-net-id-740320580','tempest-subnet-id-334049605',NULL,NULL,NULL,NULL,NULL,'73eb66eb-183f-4313-a6de-6134145ec486',NULL,NULL,'2025-11-29 05:39:24.095969',NULL,NULL,'False'),('0cba8c2f-844f-4c2b-9372-7613d588b65d',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'e3bd9542-3aac-4879-ad05-039330916f5b',NULL,NULL,'2025-11-29 05:37:21.516950',NULL,NULL,'False'),('13a888e3-ee70-4bc1-ac32-eb3e08ca84d9','tempest-net-id-1880279944','tempest-subnet-id-650163544',NULL,NULL,NULL,NULL,NULL,'b83fff57-8ec2-4ea0-8f86-a431bc777cfd',NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','2025-11-29 05:37:23.251872','2025-11-29 05:37:23.566565','2025-11-29 05:37:23.565807','13a888e3-ee70-4bc1-ac32-eb3e08ca84d9'),('223def9e-266e-4690-a92a-a4dd5daa8d31','tempest-net-id-913296073','tempest-subnet-id-230882348',NULL,NULL,NULL,NULL,NULL,'1c4aece8-f27e-43a8-ad31-1a0f9e43f22c',NULL,NULL,'2025-11-29 05:39:23.208615',NULL,NULL,'False'),('3593e610-d280-4f6f-ac9f-91399a537981',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'4aa4a24c-30d6-4a12-8cb0-e4f4e9c196d1',NULL,NULL,'2025-11-29 05:41:10.862667',NULL,NULL,'False'),('3854d78e-7354-401c-b8cd-11f94e22d039','tempest-net-id-953036663','tempest-subnet-id-1304683497',NULL,NULL,NULL,NULL,NULL,'4559b4c0-4418-46d3-afec-d5a5cd88f814',NULL,NULL,'2025-11-29 05:40:59.773481',NULL,NULL,'False'),('3ab4fd4c-12a7-4f57-9673-f9402599a879','tempest-net-id-1332674760','tempest-subnet-id-609019697','vlan','10.0.0.0/24',1000,NULL,NULL,'066eadcc-302c-467d-ab3d-10f535629782',4,NULL,'2002-02-02 00:00:00.000000','2025-11-29 05:41:00.439191',NULL,'False'),('50e4f7ef-8b9b-4315-ba67-a696ee767240',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'f360d69e-d8d4-4257-8974-605c07741c55',NULL,NULL,'2025-11-29 05:42:24.300347',NULL,NULL,'False'),('594792d5-7524-412f-aec7-b41e0a408340',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'9aa0876a-c708-43f0-8d46-709912cdc3f4',NULL,NULL,'2025-11-29 05:37:21.762219',NULL,NULL,'False'),('60ef04e3-d56e-4b5b-9d2b-86fde54f5e54','tempest-net-id-832168187','tempest-subnet-id-1536068999',NULL,NULL,NULL,NULL,NULL,'0df8c6a0-8fc7-448f-ad1c-aa1db29818f7',NULL,NULL,'2025-11-29 05:42:13.692703',NULL,NULL,'False'),('63391da6-c154-42c5-b660-275085551b5f','1111','2222','vlan','10.0.0.0/24',1000,NULL,NULL,'9f9768ec-057d-4e9b-bbb3-cfc88c707c5c',4,NULL,'2002-02-02 00:00:00.000000',NULL,NULL,'False'),('723c3933-c279-4e27-8f46-119610827b57','tempest-net-id-355593442','tempest-subnet-id-1776390501',NULL,NULL,NULL,NULL,NULL,'3c717263-1af0-4d6c-a65c-9b92655539ce',NULL,NULL,'2025-11-29 05:39:24.927397',NULL,NULL,'False'),('844c54b1-4ebc-43e1-b165-182a6eca5e38','tempest-net-id-704731366','tempest-subnet-id-1587287824',NULL,NULL,NULL,NULL,NULL,'acc47b7e-2d20-4916-930a-dfde51f88d0c',NULL,NULL,'2025-11-29 05:40:58.702298',NULL,NULL,'False'),('94b24727-fe64-41e0-a2c3-708db090beb0','tempest-net-id-295918806','tempest-subnet-id-274600971',NULL,NULL,NULL,NULL,NULL,'9aa0876a-c708-43f0-8d46-709912cdc3f4',NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','2025-11-29 05:37:22.178030','2025-11-29 05:37:22.430559','2025-11-29 05:37:22.429324','94b24727-fe64-41e0-a2c3-708db090beb0'),('9807502e-7bf4-47d3-ac84-5163fbad45a2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'b83fff57-8ec2-4ea0-8f86-a431bc777cfd',NULL,NULL,'2025-11-29 05:37:23.049710',NULL,NULL,'False'),('a290e2be-036d-4d62-8b20-2a895fb462fa','tempest-net-id-145433956','tempest-subnet-id-1298186305',NULL,NULL,NULL,NULL,NULL,'be8c8539-78dd-4968-940f-c5dd5e484d0f',NULL,NULL,'2025-11-29 05:40:58.099259',NULL,NULL,'False'),('aa0ab4fa-79c1-49ea-9a48-91e06ce2b651','tempest-net-id-206595097','tempest-subnet-id-415576798',NULL,NULL,NULL,NULL,NULL,'fbb650d7-3f79-4f40-99fb-542fb6a36517',NULL,NULL,'2025-11-29 05:42:14.635604',NULL,NULL,'False'),('bbe8f7fe-e09e-4cd6-a814-4b519e7c615e','test net id','test subnet id','local','10.0.0.0/13',2000,NULL,NULL,'7076c8f1-72d8-4009-82c9-71f634d26f76',6,NULL,'2003-03-03 00:00:00.000000',NULL,NULL,'False'),('c1ec659e-6079-46f3-bd68-2c5a0ec6597c','tempest-net-id-1382834242','tempest-subnet-id-2083867143',NULL,NULL,NULL,NULL,NULL,'f360d69e-d8d4-4257-8974-605c07741c55',NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','2025-11-29 05:42:25.051380','2025-11-29 05:42:25.162235','2025-11-29 05:42:25.161443','c1ec659e-6079-46f3-bd68-2c5a0ec6597c'),('c854e34e-411f-4731-9d9d-3b39f45c28e2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'f8b6b6b8-3dbc-41b1-827e-fa7206a74159',NULL,NULL,'2025-11-29 05:42:12.445253',NULL,NULL,'False'),('d17c9fb3-2d67-4bf0-8f35-7ccf4362de98','tempest-net-id-953036663','tempest-subnet-id-1304683497',NULL,NULL,NULL,NULL,NULL,'8ede153a-a58b-4e0e-b639-56791a0a3e9c',NULL,NULL,'2025-11-29 05:41:00.029203',NULL,NULL,'False'),('d9a4ffe4-f5d5-4f72-89d8-305677ef8c29','test net id','test subnet id','local','10.0.0.0/13',2000,NULL,NULL,'b5e11d5e-2232-49b2-b757-e64c07846443',6,NULL,'2003-03-03 00:00:00.000000',NULL,NULL,'False'),('db4be369-a87a-4622-8d75-d184003ed8e6','tempest-net-id-690203319','tempest-subnet-id-1070896146',NULL,NULL,NULL,NULL,NULL,'93f34c79-c801-4185-a979-f65a862f5409',NULL,NULL,'2025-11-29 05:41:12.594946',NULL,NULL,'False'),('e4382024-abf4-4137-a311-9f441e551a55','tempest-net-id-1466854842','tempest-subnet-id-878715218',NULL,NULL,NULL,NULL,NULL,'5990b933-f751-494c-9264-b419ad2a11a3',NULL,'98d086e9-d171-462d-b7c9-f85ca4e71bd0','2025-11-29 05:41:11.652399','2025-11-29 05:41:11.903689','2025-11-29 05:41:11.902900','e4382024-abf4-4137-a311-9f441e551a55'),('ee51ad57-cd68-45f4-89da-11290d0d7629',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'5990b933-f751-494c-9264-b419ad2a11a3',NULL,NULL,'2025-11-29 05:41:11.410639',NULL,NULL,'False'),('fe5136e4-33ac-4e31-bf1f-aec0e103b23a','tempest-net-id-704731366','tempest-subnet-id-1587287824',NULL,NULL,NULL,NULL,NULL,'db49862c-05ff-4df4-9e24-d1a8ed797724',NULL,NULL,'2025-11-29 05:40:58.559723',NULL,NULL,'False');
/*!40000 ALTER TABLE `share_network_subnets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_networks`
--

DROP TABLE IF EXISTS `share_networks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_networks` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(36) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_networks`
--

LOCK TABLES `share_networks` WRITE;
/*!40000 ALTER TABLE `share_networks` DISABLE KEYS */;
INSERT INTO `share_networks` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `project_id`, `user_id`, `name`, `description`, `status`) VALUES ('2002-02-02 00:00:00.000000','2025-11-29 05:41:01.372572','2025-11-29 05:41:01.372143','066eadcc-302c-467d-ab3d-10f535629782','066eadcc-302c-467d-ab3d-10f535629782','9874b59670af413eabb2bba650c69242','d398b490db83489591c69a3c596fa374','tempest-sn-name-850655705','tempest-sn-desc-1150582282','active'),('2025-11-29 05:42:13.678979','2025-11-29 05:42:14.430853','2025-11-29 05:42:14.430246','0df8c6a0-8fc7-448f-ad1c-aa1db29818f7','0df8c6a0-8fc7-448f-ad1c-aa1db29818f7','eeaea5e509ca49be9d6a48ac7d8668b4','cb8d9fe9ac8c4751bb6ac40883cce87b','tempest-sn-name-1625017996','tempest-sn-desc-1866744535','active'),('2025-11-29 05:39:23.178168','2025-11-29 05:39:23.828476','2025-11-29 05:39:23.827583','1c4aece8-f27e-43a8-ad31-1a0f9e43f22c','1c4aece8-f27e-43a8-ad31-1a0f9e43f22c','423449a1e9f94864bc4aa1e26a05fb40','99c4b856c6fa452b8782cfb49f32d4f9','tempest-sn-name-1205814855','tempest-sn-desc-1294559664','active'),('2025-11-29 05:39:24.906028','2025-11-29 05:39:25.598263','2025-11-29 05:39:25.597828','3c717263-1af0-4d6c-a65c-9b92655539ce','3c717263-1af0-4d6c-a65c-9b92655539ce','423449a1e9f94864bc4aa1e26a05fb40','99c4b856c6fa452b8782cfb49f32d4f9','tempest-sn-name-1875395755','tempest-sn-desc-1652930573','active'),('2025-11-29 05:40:59.759385','2025-11-29 05:40:59.910014','2025-11-29 05:40:59.909321','4559b4c0-4418-46d3-afec-d5a5cd88f814','4559b4c0-4418-46d3-afec-d5a5cd88f814','9874b59670af413eabb2bba650c69242','d398b490db83489591c69a3c596fa374','tempest-sn-name-27913691','tempest-sn-desc-1479511662','active'),('2025-11-29 05:41:10.847467','2025-11-29 05:41:11.074703','2025-11-29 05:41:11.074261','4aa4a24c-30d6-4a12-8cb0-e4f4e9c196d1','4aa4a24c-30d6-4a12-8cb0-e4f4e9c196d1','4d3c4eb0bcce4aec9fe2bc88309fe6bc','e56807404f594d2397401f8e0e2c9fbc',NULL,NULL,'active'),('2025-11-29 05:41:11.390503','2025-11-29 05:41:12.169357','2025-11-29 05:41:12.168352','5990b933-f751-494c-9264-b419ad2a11a3','5990b933-f751-494c-9264-b419ad2a11a3','4d3c4eb0bcce4aec9fe2bc88309fe6bc','e56807404f594d2397401f8e0e2c9fbc',NULL,NULL,'active'),('2003-03-03 00:00:00.000000',NULL,NULL,'False','7076c8f1-72d8-4009-82c9-71f634d26f76','061705ddc30c4a188ae026c064f1a2b8','a482e699f6dc4efba8a01a70832bb439','sn_with_kerberos_ss','fake description','active'),('2025-11-29 05:39:24.072263','2025-11-29 05:39:24.733820','2025-11-29 05:39:24.732768','73eb66eb-183f-4313-a6de-6134145ec486','73eb66eb-183f-4313-a6de-6134145ec486','423449a1e9f94864bc4aa1e26a05fb40','99c4b856c6fa452b8782cfb49f32d4f9','tempest-sn-name-266979947','tempest-sn-desc-1507573865','active'),('2025-11-29 05:41:00.016639','2025-11-29 05:41:00.151690','2025-11-29 05:41:00.151291','8ede153a-a58b-4e0e-b639-56791a0a3e9c','8ede153a-a58b-4e0e-b639-56791a0a3e9c','9874b59670af413eabb2bba650c69242','d398b490db83489591c69a3c596fa374','tempest-sn-name-27913691','tempest-sn-desc-1479511662','active'),('2025-11-29 05:41:12.572157','2025-11-29 05:41:12.758073','2025-11-29 05:41:12.757529','93f34c79-c801-4185-a979-f65a862f5409','93f34c79-c801-4185-a979-f65a862f5409','4d3c4eb0bcce4aec9fe2bc88309fe6bc','e56807404f594d2397401f8e0e2c9fbc','tempest-sn-name-1801330751','tempest-sn-desc-136580517','active'),('2025-11-29 05:37:21.740197',NULL,NULL,'False','9aa0876a-c708-43f0-8d46-709912cdc3f4','18a45827d98a489a902f5dbcfb422b2d','d77f33e5f83b46d0a66fd3d5f2a35ad0',NULL,NULL,'active'),('2002-02-02 00:00:00.000000','2025-11-29 05:36:15.018613','2025-11-29 05:36:15.017806','9f9768ec-057d-4e9b-bbb3-cfc88c707c5c','9f9768ec-057d-4e9b-bbb3-cfc88c707c5c','0448e6e78f8747efb1e6a68338df9866','e834d9d8dc83417ea6c9ba3e6be16616','sn_with_ldap_ss','fake description','active'),('2025-11-29 05:40:58.681660','2025-11-29 05:40:58.871265','2025-11-29 05:40:58.870587','acc47b7e-2d20-4916-930a-dfde51f88d0c','acc47b7e-2d20-4916-930a-dfde51f88d0c','9874b59670af413eabb2bba650c69242','d398b490db83489591c69a3c596fa374','tempest-sn-name-1138865161','tempest-sn-desc-874944828','active'),('2003-03-03 00:00:00.000000','2025-11-29 05:41:01.000239','2025-11-29 05:41:00.999631','b5e11d5e-2232-49b2-b757-e64c07846443','b5e11d5e-2232-49b2-b757-e64c07846443','9874b59670af413eabb2bba650c69242','d398b490db83489591c69a3c596fa374','sn_with_kerberos_ss','fake description','active'),('2025-11-29 05:37:23.030716','2025-11-29 05:37:24.198916','2025-11-29 05:37:24.198051','b83fff57-8ec2-4ea0-8f86-a431bc777cfd','b83fff57-8ec2-4ea0-8f86-a431bc777cfd','18a45827d98a489a902f5dbcfb422b2d','d77f33e5f83b46d0a66fd3d5f2a35ad0',NULL,NULL,'active'),('2025-11-29 05:40:58.084537','2025-11-29 05:40:58.270348','2025-11-29 05:40:58.269823','be8c8539-78dd-4968-940f-c5dd5e484d0f','be8c8539-78dd-4968-940f-c5dd5e484d0f','9874b59670af413eabb2bba650c69242','d398b490db83489591c69a3c596fa374','tempest-sn-name-1215116512','tempest-sn-desc-952775333','active'),('2025-11-29 05:40:58.537161','2025-11-29 05:40:59.059920','2025-11-29 05:40:59.059425','db49862c-05ff-4df4-9e24-d1a8ed797724','db49862c-05ff-4df4-9e24-d1a8ed797724','9874b59670af413eabb2bba650c69242','d398b490db83489591c69a3c596fa374','tempest-sn-name-1138865161','tempest-sn-desc-874944828','active'),('2025-11-29 05:37:21.485413','2025-11-29 05:37:22.716982','2025-11-29 05:37:22.716367','e3bd9542-3aac-4879-ad05-039330916f5b','e3bd9542-3aac-4879-ad05-039330916f5b','18a45827d98a489a902f5dbcfb422b2d','d77f33e5f83b46d0a66fd3d5f2a35ad0',NULL,NULL,'active'),('2025-11-29 05:42:24.228496',NULL,NULL,'False','f360d69e-d8d4-4257-8974-605c07741c55','d8ec1959e8bb450793ca093172af99e3','af91f2be0ad34dd795af321a91ed6e47',NULL,NULL,'active'),('2025-11-29 05:42:12.420004','2025-11-29 05:42:17.034143','2025-11-29 05:42:17.033617','f8b6b6b8-3dbc-41b1-827e-fa7206a74159','f8b6b6b8-3dbc-41b1-827e-fa7206a74159','eeaea5e509ca49be9d6a48ac7d8668b4','cb8d9fe9ac8c4751bb6ac40883cce87b',NULL,NULL,'active'),('2025-11-29 05:42:14.614960','2025-11-29 05:42:15.408649','2025-11-29 05:42:15.408210','fbb650d7-3f79-4f40-99fb-542fb6a36517','fbb650d7-3f79-4f40-99fb-542fb6a36517','eeaea5e509ca49be9d6a48ac7d8668b4','cb8d9fe9ac8c4751bb6ac40883cce87b','tempest-sn-name-273399606','tempest-sn-desc-912427509','active');
/*!40000 ALTER TABLE `share_networks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_server_backend_details`
--

DROP TABLE IF EXISTS `share_server_backend_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_server_backend_details` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_server_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `share_server_id` (`share_server_id`),
  CONSTRAINT `share_server_backend_details_ibfk_1` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_server_backend_details`
--

LOCK TABLES `share_server_backend_details` WRITE;
/*!40000 ALTER TABLE `share_server_backend_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_server_backend_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_server_share_network_subnet_mappings`
--

DROP TABLE IF EXISTS `share_server_share_network_subnet_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_server_share_network_subnet_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `share_server_id` varchar(36) NOT NULL,
  `share_network_subnet_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_ss_sns_m_share_server_id_share_servers` (`share_server_id`),
  KEY `fk_ss_sns_m_share_network_subnet_id_share_network_subnets` (`share_network_subnet_id`),
  CONSTRAINT `fk_ss_sns_m_share_network_subnet_id_share_network_subnets` FOREIGN KEY (`share_network_subnet_id`) REFERENCES `share_network_subnets` (`id`),
  CONSTRAINT `fk_ss_sns_m_share_server_id_share_servers` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_server_share_network_subnet_mappings`
--

LOCK TABLES `share_server_share_network_subnet_mappings` WRITE;
/*!40000 ALTER TABLE `share_server_share_network_subnet_mappings` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_server_share_network_subnet_mappings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_servers`
--

DROP TABLE IF EXISTS `share_servers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_servers` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `host` varchar(255) DEFAULT NULL,
  `status` varchar(32) DEFAULT NULL,
  `is_auto_deletable` tinyint(1) DEFAULT NULL,
  `identifier` varchar(255) DEFAULT NULL,
  `task_state` varchar(255) DEFAULT NULL,
  `source_share_server_id` varchar(36) DEFAULT NULL,
  `security_service_update_support` tinyint(1) NOT NULL DEFAULT 0,
  `network_allocation_update_support` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `fk_share_servers_source_share_server_id` (`source_share_server_id`),
  CONSTRAINT `fk_share_servers_source_share_server_id` FOREIGN KEY (`source_share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_servers`
--

LOCK TABLES `share_servers` WRITE;
/*!40000 ALTER TABLE `share_servers` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_servers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_access_map`
--

DROP TABLE IF EXISTS `share_snapshot_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_access_map` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_snapshot_id` varchar(36) DEFAULT NULL,
  `access_type` varchar(255) DEFAULT NULL,
  `access_to` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ssam_snapshot_fk` (`share_snapshot_id`),
  CONSTRAINT `ssam_snapshot_fk` FOREIGN KEY (`share_snapshot_id`) REFERENCES `share_snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_access_map`
--

LOCK TABLES `share_snapshot_access_map` WRITE;
/*!40000 ALTER TABLE `share_snapshot_access_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_snapshot_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_instance_access_map`
--

DROP TABLE IF EXISTS `share_snapshot_instance_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_instance_access_map` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_snapshot_instance_id` varchar(36) DEFAULT NULL,
  `access_id` varchar(36) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ssiam_snapshot_instance_fk` (`share_snapshot_instance_id`),
  KEY `ssam_access_fk` (`access_id`),
  CONSTRAINT `ssam_access_fk` FOREIGN KEY (`access_id`) REFERENCES `share_snapshot_access_map` (`id`),
  CONSTRAINT `ssiam_snapshot_instance_fk` FOREIGN KEY (`share_snapshot_instance_id`) REFERENCES `share_snapshot_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_instance_access_map`
--

LOCK TABLES `share_snapshot_instance_access_map` WRITE;
/*!40000 ALTER TABLE `share_snapshot_instance_access_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_snapshot_instance_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_instance_export_locations`
--

DROP TABLE IF EXISTS `share_snapshot_instance_export_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_instance_export_locations` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_snapshot_instance_id` varchar(36) DEFAULT NULL,
  `path` varchar(2000) DEFAULT NULL,
  `is_admin_only` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ssiel_snapshot_instance_fk` (`share_snapshot_instance_id`),
  CONSTRAINT `ssiel_snapshot_instance_fk` FOREIGN KEY (`share_snapshot_instance_id`) REFERENCES `share_snapshot_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_instance_export_locations`
--

LOCK TABLES `share_snapshot_instance_export_locations` WRITE;
/*!40000 ALTER TABLE `share_snapshot_instance_export_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_snapshot_instance_export_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_instances`
--

DROP TABLE IF EXISTS `share_snapshot_instances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_instances` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `share_instance_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `share_proto` varchar(255) DEFAULT NULL,
  `share_group_snapshot_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ssi_snapshot_fk` (`snapshot_id`),
  KEY `ssi_share_instance_fk` (`share_instance_id`),
  CONSTRAINT `ssi_share_instance_fk` FOREIGN KEY (`share_instance_id`) REFERENCES `share_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_instances`
--

LOCK TABLES `share_snapshot_instances` WRITE;
/*!40000 ALTER TABLE `share_snapshot_instances` DISABLE KEYS */;
INSERT INTO `share_snapshot_instances` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `snapshot_id`, `share_instance_id`, `status`, `progress`, `provider_location`, `user_id`, `project_id`, `size`, `share_proto`, `share_group_snapshot_id`) VALUES ('2025-11-29 05:37:22.259095','2025-11-29 05:37:27.007330','2025-11-29 05:37:27.005082','052f518b-49ad-41ce-af4d-007b0f475cae','052f518b-49ad-41ce-af4d-007b0f475cae','c5bea340-145f-4db4-98d1-96c3624358f6','a9634de1-2230-40f8-a094-82f46777a70c','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-29 05:35:11.660546','2025-11-29 05:35:32.970124','2025-11-29 05:35:32.969656','1d37acde-d071-4205-8f1d-460ac18d4e24','1d37acde-d071-4205-8f1d-460ac18d4e24','8cf4c283-b297-4eb5-902b-efa757c8775f','cfa53e30-aa5d-48db-9775-60686b039ee1','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-29 05:35:24.171302','2025-11-29 05:35:29.977248','2025-11-29 05:35:29.976492','33f581df-12c0-4550-9aaa-8aaaa30382e3','33f581df-12c0-4550-9aaa-8aaaa30382e3','cbba1f8e-b6b8-4e8f-8d36-18abb0c9ac72','e887b8f7-1920-4aa9-a22b-586da6843031','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-29 05:37:21.078266','2025-11-29 05:37:30.712450','2025-11-29 05:37:30.711974','348a3764-7ba4-4077-85c8-2f2a979915c1','348a3764-7ba4-4077-85c8-2f2a979915c1','53de9ce2-17a6-4f82-8906-ba34ad0ed34d','a9634de1-2230-40f8-a094-82f46777a70c','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-29 05:41:14.365861','2025-11-29 05:41:16.603923','2025-11-29 05:41:16.603248','40d5debf-b44f-4de6-940d-1c9aafb1724f','40d5debf-b44f-4de6-940d-1c9aafb1724f','5c579ca3-9ef8-4a71-8a77-4ef6bcc0fab2','07a65cd4-2777-43ad-b684-b3508a87dd10','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-29 05:40:58.534412','2025-11-29 05:41:03.834346','2025-11-29 05:41:03.833894','49b59679-70ca-40e8-b8a9-078b9d51d09b','49b59679-70ca-40e8-b8a9-078b9d51d09b','e835c72c-a635-4c4e-baef-8e8d67cd9fec','07a65cd4-2777-43ad-b684-b3508a87dd10','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-29 05:34:54.563870','2025-11-29 05:34:56.093039','2025-11-29 05:34:56.091331','4bb539df-e3c9-4ce9-845d-0ec16051653c','4bb539df-e3c9-4ce9-845d-0ec16051653c','9f4ca2d4-2a6d-40ec-a151-65908d28e8e3','e887b8f7-1920-4aa9-a22b-586da6843031','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-29 05:40:55.758840','2025-11-29 05:40:59.790531','2025-11-29 05:40:59.790041','5fc56f62-3563-4637-98c4-f1c64fe4cf32','5fc56f62-3563-4637-98c4-f1c64fe4cf32','4bc7ae62-8f19-489c-ab78-f250246cad8c','0ff274bb-e3ac-4d57-8489-1cecf428692d','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-29 05:40:47.066860','2025-11-29 05:41:32.947355','2025-11-29 05:41:32.946902','70eab419-f284-47c7-b0cd-6e257fe57f1d','70eab419-f284-47c7-b0cd-6e257fe57f1d','22583c21-c0dc-4991-a17b-a735e6d7c9f4','07a65cd4-2777-43ad-b684-b3508a87dd10','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-29 05:41:10.238939','2025-11-29 05:41:14.960518','2025-11-29 05:41:14.959859','74a96009-fd82-4ae6-b743-29ffffe9710a','74a96009-fd82-4ae6-b743-29ffffe9710a','006bb014-977b-4c9c-b290-16a1b0c02828','9378b5f8-f3c7-4db4-98d1-4cf3955df852','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-29 05:41:07.031323','2025-11-29 05:41:11.044636','2025-11-29 05:41:11.044239','771e373d-f46c-4323-b1c4-c8472b9b21b1','771e373d-f46c-4323-b1c4-c8472b9b21b1','bfb2e2f5-a7fe-4303-8582-2fb7923d4276','07a65cd4-2777-43ad-b684-b3508a87dd10','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-29 05:35:15.884370','2025-11-29 05:35:36.919474','2025-11-29 05:35:36.919006','7af15242-6172-4c61-ab43-69a053d2a208','7af15242-6172-4c61-ab43-69a053d2a208','5fbba3e6-4a9f-416a-b875-dbe87783ac9f','e887b8f7-1920-4aa9-a22b-586da6843031','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-29 05:40:31.742471','2025-11-29 05:40:37.185406','2025-11-29 05:40:37.184979','88f00d98-7609-4a65-a545-d92208fb556e','88f00d98-7609-4a65-a545-d92208fb556e','da8025e3-cf4f-466c-b32d-deea84c459c8','163fafb9-e2a0-4bac-af62-6ce4faca289f','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-29 05:35:19.995277','2025-11-29 05:35:33.496652','2025-11-29 05:35:33.496110','99b797bd-23c6-46a2-8353-545c9d1d20ad','99b797bd-23c6-46a2-8353-545c9d1d20ad','466ffbf3-2e61-457d-9a83-066aa5755061','e887b8f7-1920-4aa9-a22b-586da6843031','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-29 05:35:24.953975','2025-11-29 05:35:26.241059','2025-11-29 05:35:26.240459','9bce4af4-714b-4d64-be4c-d1a28b6fa5f6','9bce4af4-714b-4d64-be4c-d1a28b6fa5f6','a8afb0bd-caae-4e09-b7fc-59c77a02ac82','e887b8f7-1920-4aa9-a22b-586da6843031','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-29 05:39:35.507975','2025-11-29 05:40:27.385383','2025-11-29 05:40:27.384195','9d58da62-529e-4378-9a77-682165217cf5','9d58da62-529e-4378-9a77-682165217cf5','54db2b9e-cb54-440e-8afd-6c23560987db','779d5f7d-4b59-47d7-ae31-6662b5ea257d','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-29 05:36:31.503259','2025-11-29 05:36:47.537044','2025-11-29 05:36:47.535579','a1b607a0-ec1d-4d0c-aa68-b82ad11908c2','a1b607a0-ec1d-4d0c-aa68-b82ad11908c2','28e850ab-7085-4183-b727-8c2173bcd1fc','ff968508-e63c-4125-8d0a-ffeca3c4312c','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-29 05:40:50.687928','2025-11-29 05:40:55.497776','2025-11-29 05:40:55.497065','b15f858e-3e57-4b58-8d27-5b096ba3f743','b15f858e-3e57-4b58-8d27-5b096ba3f743','da42dd29-b8ca-4a89-a34f-b140d81e7bf9','07a65cd4-2777-43ad-b684-b3508a87dd10','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-29 05:42:45.374166','2025-11-29 05:42:50.496086','2025-11-29 05:42:50.495624','b2c2a3a9-6ca2-47e7-866b-066e22d44cab','b2c2a3a9-6ca2-47e7-866b-066e22d44cab','05eea654-051b-4823-b7e8-43654092acb8','fb848b69-a318-4691-8a4b-5a72fc808dc6','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-29 05:39:13.342426','2025-11-29 05:39:17.488508','2025-11-29 05:39:17.487723','bdaf9ec6-4ab8-492f-a30a-f313b38f5d36','bdaf9ec6-4ab8-492f-a30a-f313b38f5d36','eb1bc411-f674-4652-a897-abf914faeef2','adc37617-82af-4ff2-b1ff-41acd332035e','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-29 05:35:11.701131','2025-11-29 05:35:40.801931','2025-11-29 05:35:40.801544','c98a0dcd-284d-49d3-9ea2-a80ce4ec6e6e','c98a0dcd-284d-49d3-9ea2-a80ce4ec6e6e','aac92040-d3b9-4ca6-8113-38a011a7589d','e887b8f7-1920-4aa9-a22b-586da6843031','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-29 05:41:21.293165','2025-11-29 05:41:28.185531','2025-11-29 05:41:28.185069','dea690a8-7401-442a-8d5e-63a333d20ef8','dea690a8-7401-442a-8d5e-63a333d20ef8','2df5bdeb-2a6a-41fb-86c0-a340aafa411f','07a65cd4-2777-43ad-b684-b3508a87dd10','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-29 05:41:25.273331','2025-11-29 05:43:07.165080','2025-11-29 05:43:07.163636','dff066e4-ae85-4050-9c93-143b245e669b','dff066e4-ae85-4050-9c93-143b245e669b','f919bca8-f41c-47b0-8fca-f8f7988969c2','dca14011-a433-40d4-8754-3eaafbae5faa','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-29 05:36:39.339497','2025-11-29 05:36:44.696094','2025-11-29 05:36:44.695360','ee139701-4c1f-4617-b59a-7c6029149324','ee139701-4c1f-4617-b59a-7c6029149324','0abd9e26-18ae-42cb-9460-0ccd7be51363','740417e2-7402-40fb-a24e-d743db894fa4','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-29 05:38:53.442553','2025-11-29 05:38:58.639982','2025-11-29 05:38:58.639405','ef38678e-a0e9-4751-9f3b-809b04461abf','ef38678e-a0e9-4751-9f3b-809b04461abf','3393ee82-df40-40bd-8c8e-22fcc53b34d2','46ac263c-91aa-4770-862a-dd35f490382b','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-29 05:35:54.671202','2025-11-29 05:35:59.589693','2025-11-29 05:35:59.588437','f6acc0be-448f-4c63-b32e-428b3a708389','f6acc0be-448f-4c63-b32e-428b3a708389','3ce803d6-55ed-4b2e-b9f1-fdf345652692','09990eae-c6d2-4985-ad1a-d7539b5b0a71','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-11-29 05:43:31.666148','2025-11-29 05:44:14.792762','2025-11-29 05:44:14.792032','ffd2f7d1-d553-4c4c-ad2a-79c702a633bc','ffd2f7d1-d553-4c4c-ad2a-79c702a633bc','521373cc-7b10-441e-9ad4-a9f2f13df341','212fdd6d-2482-42c2-82e5-a1ecfd70ce27','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `share_snapshot_instances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_metadata`
--

DROP TABLE IF EXISTS `share_snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_metadata` (
  `deleted` varchar(36) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `share_snapshot_id` (`share_snapshot_id`),
  CONSTRAINT `share_snapshot_metadata_ibfk_1` FOREIGN KEY (`share_snapshot_id`) REFERENCES `share_snapshots` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_metadata`
--

LOCK TABLES `share_snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `share_snapshot_metadata` DISABLE KEYS */;
INSERT INTO `share_snapshot_metadata` (`deleted`, `created_at`, `updated_at`, `deleted_at`, `share_snapshot_id`, `key`, `value`, `id`) VALUES ('1','2025-11-29 05:40:54.287974','2025-11-29 05:40:54.443447','2025-11-29 05:40:55.522285','da42dd29-b8ca-4a89-a34f-b140d81e7bf9','key5','value5',1),('2','2025-11-29 05:40:54.290164','2025-11-29 05:40:54.471932','2025-11-29 05:40:55.522285','da42dd29-b8ca-4a89-a34f-b140d81e7bf9','key6','value6',2),('3','2025-11-29 05:40:54.497475',NULL,'2025-11-29 05:40:55.522285','da42dd29-b8ca-4a89-a34f-b140d81e7bf9','key7','value7',3),('4','2025-11-29 05:40:54.499595',NULL,'2025-11-29 05:40:55.522285','da42dd29-b8ca-4a89-a34f-b140d81e7bf9','key8','value8',4),('5','2025-11-29 05:41:01.912949','2025-11-29 05:41:02.944282','2025-11-29 05:41:03.848047','e835c72c-a635-4c4e-baef-8e8d67cd9fec','key3','value3',5),('6','2025-11-29 05:41:01.915744','2025-11-29 05:41:03.133047','2025-11-29 05:41:03.848047','e835c72c-a635-4c4e-baef-8e8d67cd9fec','key4','value4',6),('7','2025-11-29 05:41:01.917672','2025-11-29 05:41:03.275674','2025-11-29 05:41:03.848047','e835c72c-a635-4c4e-baef-8e8d67cd9fec','key.5.1','value.5',7),('8','2025-11-29 05:41:07.030049',NULL,'2025-11-29 05:41:11.058647','bfb2e2f5-a7fe-4303-8582-2fb7923d4276','key1','value1',8),('9','2025-11-29 05:41:07.030529',NULL,'2025-11-29 05:41:11.058647','bfb2e2f5-a7fe-4303-8582-2fb7923d4276','key2','value2',9),('10','2025-11-29 05:41:14.785448','2025-11-29 05:41:15.809441','2025-11-29 05:41:16.619273','5c579ca3-9ef8-4a71-8a77-4ef6bcc0fab2','key9','value13',10),('11','2025-11-29 05:41:14.787443','2025-11-29 05:41:15.943599','2025-11-29 05:41:16.619273','5c579ca3-9ef8-4a71-8a77-4ef6bcc0fab2','key10','value10',11),('12','2025-11-29 05:41:15.261470','2025-11-29 05:41:16.086960','2025-11-29 05:41:16.619273','5c579ca3-9ef8-4a71-8a77-4ef6bcc0fab2','key11','value11',12),('13','2025-11-29 05:41:19.822296','2025-11-29 05:41:30.162301','2025-11-29 05:41:32.965871','22583c21-c0dc-4991-a17b-a735e6d7c9f4','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value',13),('14','2025-11-29 05:41:20.064056','2025-11-29 05:41:30.193543','2025-11-29 05:41:32.965871','22583c21-c0dc-4991-a17b-a735e6d7c9f4','key','v',14),('15','2025-11-29 05:41:20.587916','2025-11-29 05:41:30.223112','2025-11-29 05:41:32.965871','22583c21-c0dc-4991-a17b-a735e6d7c9f4','k','value',15),('16','2025-11-29 05:41:24.774555','2025-11-29 05:41:25.901228','2025-11-29 05:41:28.196405','2df5bdeb-2a6a-41fb-86c0-a340aafa411f','key9','value9',16),('17','2025-11-29 05:41:24.776603','2025-11-29 05:41:26.094999','2025-11-29 05:41:28.196405','2df5bdeb-2a6a-41fb-86c0-a340aafa411f','key10','value10',17),('18','2025-11-29 05:41:25.276328','2025-11-29 05:41:26.293186','2025-11-29 05:41:28.196405','2df5bdeb-2a6a-41fb-86c0-a340aafa411f','key11','value11',18),('19','2025-11-29 05:41:25.278534','2025-11-29 05:41:26.428398','2025-11-29 05:41:28.196405','2df5bdeb-2a6a-41fb-86c0-a340aafa411f','key12','value12',19),('20','2025-11-29 05:41:30.256004','2025-11-29 05:41:30.529809','2025-11-29 05:41:32.965871','22583c21-c0dc-4991-a17b-a735e6d7c9f4','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value',20),('21','2025-11-29 05:41:30.561307','2025-11-29 05:41:30.824606','2025-11-29 05:41:32.965871','22583c21-c0dc-4991-a17b-a735e6d7c9f4','key','vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv',21),('22','2025-11-29 05:41:30.849781','2025-11-29 05:41:31.141299','2025-11-29 05:41:32.965871','22583c21-c0dc-4991-a17b-a735e6d7c9f4','k','value',22),('23','2025-11-29 05:41:31.171393',NULL,'2025-11-29 05:41:32.965871','22583c21-c0dc-4991-a17b-a735e6d7c9f4','key','v',23);
/*!40000 ALTER TABLE `share_snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshots`
--

DROP TABLE IF EXISTS `share_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshots` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `share_id` varchar(36) NOT NULL,
  `size` int(11) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `share_size` int(11) DEFAULT NULL,
  `share_proto` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `share_id` (`share_id`),
  CONSTRAINT `share_snapshots_ibfk_1` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshots`
--

LOCK TABLES `share_snapshots` WRITE;
/*!40000 ALTER TABLE `share_snapshots` DISABLE KEYS */;
INSERT INTO `share_snapshots` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `share_id`, `size`, `display_name`, `display_description`, `share_size`, `share_proto`) VALUES ('2025-11-29 05:41:10.238030','2025-11-29 05:41:14.982431','2025-11-29 05:41:14.981354','006bb014-977b-4c9c-b290-16a1b0c02828','006bb014-977b-4c9c-b290-16a1b0c02828','ea27d7612aa34955a6fb1f29750c8921','837f2bfa5aab4fdabd09b7661c70b7dd','1f0746c5-ce51-4a65-98e3-f72e5530a929',1,'tempest-tempest-created-share-snap-323113402','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-29 05:42:45.372786','2025-11-29 05:42:50.508080','2025-11-29 05:42:50.507683','05eea654-051b-4823-b7e8-43654092acb8','05eea654-051b-4823-b7e8-43654092acb8','89edac5a76e841118f3aa700b37de873','763ee5d3450f427ca1081cea0f991adc','87225f6c-bfcc-41c4-9ef8-2ba0142f8320',1,'tempest-tempest-snapshot-name-376966555','tempest-tempest-snapshot-description-332517712',1,'CEPHFS'),('2025-11-29 05:36:39.333367','2025-11-29 05:36:44.712052','2025-11-29 05:36:44.711456','0abd9e26-18ae-42cb-9460-0ccd7be51363','0abd9e26-18ae-42cb-9460-0ccd7be51363','9b2862373bbf44779eeacbfbcfe988ee','0c1d652029574d0fa397d5399235f790','f6495022-cf62-4e63-92d8-438c96f9cb74',1,'tempest-tempest-created-share-snap-2136457296','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-29 05:40:47.065752','2025-11-29 05:41:32.967629','2025-11-29 05:41:32.967173','22583c21-c0dc-4991-a17b-a735e6d7c9f4','22583c21-c0dc-4991-a17b-a735e6d7c9f4','e4d2d18fdb14465eacc082349a6e10a9','d26079c7d6c8427193b3786b26cb5b7e','217acc03-b4a2-4cc6-b7f3-39aeb7e3d87e',1,'tempest-tempest-snapshot-name-788913645','tempest-tempest-snapshot-description-1009625573',1,'CEPHFS'),('2025-11-29 05:36:31.501750','2025-11-29 05:36:47.569194','2025-11-29 05:36:47.568356','28e850ab-7085-4183-b727-8c2173bcd1fc','28e850ab-7085-4183-b727-8c2173bcd1fc','df986af3d0c84127a1e3fbaab7aaf38b','c48d0a2145674172882133c87bb61929','8c3cf27c-29e2-41bd-bd85-e08342a32955',1,'tempest-tempest-created-share-snap-1837584622','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-29 05:41:21.289274','2025-11-29 05:41:28.198012','2025-11-29 05:41:28.197592','2df5bdeb-2a6a-41fb-86c0-a340aafa411f','2df5bdeb-2a6a-41fb-86c0-a340aafa411f','e4d2d18fdb14465eacc082349a6e10a9','d26079c7d6c8427193b3786b26cb5b7e','217acc03-b4a2-4cc6-b7f3-39aeb7e3d87e',1,'tempest-tempest-created-share-snap-1465625494','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-29 05:38:53.441566','2025-11-29 05:38:58.656197','2025-11-29 05:38:58.655760','3393ee82-df40-40bd-8c8e-22fcc53b34d2','3393ee82-df40-40bd-8c8e-22fcc53b34d2','18ebde6642cb44c1bd4ab1e5fa932abd','177e0fe42e604553bd3b076a784b5e9d','9a9718aa-cdac-400b-92ad-2d69eabfb34a',1,'tempest-tempest-created-share-snap-652499064','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-29 05:35:54.669588','2025-11-29 05:35:59.614536','2025-11-29 05:35:59.613578','3ce803d6-55ed-4b2e-b9f1-fdf345652692','3ce803d6-55ed-4b2e-b9f1-fdf345652692','ae00d95f95bb4ec8b2178598e348be7a','4453ce436b30425fba6f22e4043ef796','c306547a-5139-4a85-935d-1f059e2e5a00',1,'tempest-tempest-created-share-snap-301348178','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-29 05:35:19.993740','2025-11-29 05:35:33.513173','2025-11-29 05:35:33.512562','466ffbf3-2e61-457d-9a83-066aa5755061','466ffbf3-2e61-457d-9a83-066aa5755061','4544ba66fc044b5a8d3aa9deb5249384','3e18b41001c440e0a7d05f7f98059230','b8319b08-a988-4842-8476-2b1128958f34',1,'tempest-tempest-created-share-snap-522453907','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-29 05:40:55.757657','2025-11-29 05:40:59.808537','2025-11-29 05:40:59.808011','4bc7ae62-8f19-489c-ab78-f250246cad8c','4bc7ae62-8f19-489c-ab78-f250246cad8c','ea27d7612aa34955a6fb1f29750c8921','837f2bfa5aab4fdabd09b7661c70b7dd','57846cd1-c190-4de4-9fa1-0159e8b2a7b8',2,'tempest-tempest-created-share-snap-1657555860','Tempest\'s snapshot',2,'CEPHFS'),('2025-11-29 05:43:31.664323','2025-11-29 05:44:14.811001','2025-11-29 05:44:14.810418','521373cc-7b10-441e-9ad4-a9f2f13df341','521373cc-7b10-441e-9ad4-a9f2f13df341','6f7f9251bec644a5bf819843dcf464f5','bfa506cc517a4cf1bb6dc4bca76155a6','dbd3da03-d3e4-4c33-93a8-95413e7575a1',1,'tempest-tempest-snapshot-name-1250888600','tempest-tempest-snapshot-description-82878129',1,'CEPHFS'),('2025-11-29 05:37:21.076627','2025-11-29 05:37:30.733607','2025-11-29 05:37:30.733182','53de9ce2-17a6-4f82-8906-ba34ad0ed34d','53de9ce2-17a6-4f82-8906-ba34ad0ed34d','4522755852d94dd7bbf637007ec21bf0','ecd2e5916bab4f7cb242a87ec782ffda','aaf64f7d-a6da-42d5-b6c4-1101918983fc',1,'tempest-tempest-created-share-snap-274002299','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-29 05:39:35.507156','2025-11-29 05:40:27.401419','2025-11-29 05:40:27.400937','54db2b9e-cb54-440e-8afd-6c23560987db','54db2b9e-cb54-440e-8afd-6c23560987db','6b29bd6ef300472cad86c5c5a7341f17','96857e43ebcb4e019650999b54e535a1','d455a5e3-5638-439e-885b-3efb579e23f1',1,'tempest-tempest-created-share-snap-19696474','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-29 05:41:14.364589','2025-11-29 05:41:16.621302','2025-11-29 05:41:16.620772','5c579ca3-9ef8-4a71-8a77-4ef6bcc0fab2','5c579ca3-9ef8-4a71-8a77-4ef6bcc0fab2','e4d2d18fdb14465eacc082349a6e10a9','d26079c7d6c8427193b3786b26cb5b7e','217acc03-b4a2-4cc6-b7f3-39aeb7e3d87e',1,'tempest-tempest-created-share-snap-1477996295','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-29 05:35:15.883268','2025-11-29 05:35:37.029279','2025-11-29 05:35:37.028715','5fbba3e6-4a9f-416a-b875-dbe87783ac9f','5fbba3e6-4a9f-416a-b875-dbe87783ac9f','4544ba66fc044b5a8d3aa9deb5249384','3e18b41001c440e0a7d05f7f98059230','b8319b08-a988-4842-8476-2b1128958f34',1,'tempest-tempest-created-share-snap-499618539','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-29 05:35:11.658382','2025-11-29 05:35:32.982781','2025-11-29 05:35:32.982327','8cf4c283-b297-4eb5-902b-efa757c8775f','8cf4c283-b297-4eb5-902b-efa757c8775f','417cb9ae9b2a43429cd5d1781ad57fd9','c272c8175ff843ca8dc572501529b10b','f4322b3a-3450-4238-980c-d18815850d7d',1,'tempest-tempest-snapshot-name-1904851249','tempest-tempest-snapshot-description-324189875',1,'CEPHFS'),('2025-11-29 05:34:54.562148','2025-11-29 05:34:56.109871','2025-11-29 05:34:56.109048','9f4ca2d4-2a6d-40ec-a151-65908d28e8e3','9f4ca2d4-2a6d-40ec-a151-65908d28e8e3','4544ba66fc044b5a8d3aa9deb5249384','3e18b41001c440e0a7d05f7f98059230','b8319b08-a988-4842-8476-2b1128958f34',1,'tempest-tempest-created-share-snap-235477302','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-29 05:35:24.952908','2025-11-29 05:35:26.266552','2025-11-29 05:35:26.265836','a8afb0bd-caae-4e09-b7fc-59c77a02ac82','a8afb0bd-caae-4e09-b7fc-59c77a02ac82','4544ba66fc044b5a8d3aa9deb5249384','3e18b41001c440e0a7d05f7f98059230','b8319b08-a988-4842-8476-2b1128958f34',1,'tempest-tempest-created-share-snap-1606794015','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-29 05:35:11.699717','2025-11-29 05:35:40.831315','2025-11-29 05:35:40.830510','aac92040-d3b9-4ca6-8113-38a011a7589d','aac92040-d3b9-4ca6-8113-38a011a7589d','4544ba66fc044b5a8d3aa9deb5249384','3e18b41001c440e0a7d05f7f98059230','b8319b08-a988-4842-8476-2b1128958f34',1,'tempest-tempest-created-share-snap-2021646621','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-29 05:41:07.029004','2025-11-29 05:41:11.060420','2025-11-29 05:41:11.059977','bfb2e2f5-a7fe-4303-8582-2fb7923d4276','bfb2e2f5-a7fe-4303-8582-2fb7923d4276','e4d2d18fdb14465eacc082349a6e10a9','d26079c7d6c8427193b3786b26cb5b7e','217acc03-b4a2-4cc6-b7f3-39aeb7e3d87e',1,'tempest-tempest-created-share-snap-745911126','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-29 05:37:22.257551','2025-11-29 05:37:27.039377','2025-11-29 05:37:27.038577','c5bea340-145f-4db4-98d1-96c3624358f6','c5bea340-145f-4db4-98d1-96c3624358f6','4522755852d94dd7bbf637007ec21bf0','ecd2e5916bab4f7cb242a87ec782ffda','aaf64f7d-a6da-42d5-b6c4-1101918983fc',1,'tempest-tempest-created-share-snap-1350271833','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-29 05:35:24.170297','2025-11-29 05:35:29.989481','2025-11-29 05:35:29.989019','cbba1f8e-b6b8-4e8f-8d36-18abb0c9ac72','cbba1f8e-b6b8-4e8f-8d36-18abb0c9ac72','4544ba66fc044b5a8d3aa9deb5249384','3e18b41001c440e0a7d05f7f98059230','b8319b08-a988-4842-8476-2b1128958f34',1,'tempest-tempest-created-share-snap-2136492097','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-29 05:40:50.686995','2025-11-29 05:40:55.525192','2025-11-29 05:40:55.524485','da42dd29-b8ca-4a89-a34f-b140d81e7bf9','da42dd29-b8ca-4a89-a34f-b140d81e7bf9','e4d2d18fdb14465eacc082349a6e10a9','d26079c7d6c8427193b3786b26cb5b7e','217acc03-b4a2-4cc6-b7f3-39aeb7e3d87e',1,'tempest-tempest-created-share-snap-440094347','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-29 05:40:31.741474','2025-11-29 05:40:37.198059','2025-11-29 05:40:37.197658','da8025e3-cf4f-466c-b32d-deea84c459c8','da8025e3-cf4f-466c-b32d-deea84c459c8','ac0b18a898c7459da335489d13ce6891','b6fbd26e87a649ef8a1685512e46f501','d057cfa3-47b2-42be-8fcc-f0d7f7c8d87b',1,'tempest-tempest-new-name-for-snapshot-114314043','tempest-tempest-new-description-for-snapshot-10629913',1,'CEPHFS'),('2025-11-29 05:40:58.532386','2025-11-29 05:41:03.849511','2025-11-29 05:41:03.849048','e835c72c-a635-4c4e-baef-8e8d67cd9fec','e835c72c-a635-4c4e-baef-8e8d67cd9fec','e4d2d18fdb14465eacc082349a6e10a9','d26079c7d6c8427193b3786b26cb5b7e','217acc03-b4a2-4cc6-b7f3-39aeb7e3d87e',1,'tempest-tempest-created-share-snap-1918342300','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-29 05:39:13.341589','2025-11-29 05:39:17.513959','2025-11-29 05:39:17.513022','eb1bc411-f674-4652-a897-abf914faeef2','eb1bc411-f674-4652-a897-abf914faeef2','6b29bd6ef300472cad86c5c5a7341f17','96857e43ebcb4e019650999b54e535a1','9a6f70c7-49e7-4bfc-8dfe-7d8aa66f411a',1,'tempest-tempest-created-share-snap-2022773120','Tempest\'s snapshot',1,'CEPHFS'),('2025-11-29 05:41:25.272416','2025-11-29 05:43:07.193961','2025-11-29 05:43:07.191372','f919bca8-f41c-47b0-8fca-f8f7988969c2','f919bca8-f41c-47b0-8fca-f8f7988969c2','c8055d8ebb36432196034de4894bbc3b','388000b055144e48b6827e9f35029a82','72b3c978-5d97-46cd-a8ea-f38c1eaf9039',1,'tempest-tempest-snapshot-name-1199689705','tempest-tempest-snapshot-description-978133855',1,'CEPHFS');
/*!40000 ALTER TABLE `share_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_type_extra_specs`
--

DROP TABLE IF EXISTS `share_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_type_extra_specs` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_type_id` varchar(36) NOT NULL,
  `spec_key` varchar(255) DEFAULT NULL,
  `spec_value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `st_id_fk` (`share_type_id`),
  CONSTRAINT `st_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=293 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_type_extra_specs`
--

LOCK TABLES `share_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `share_type_extra_specs` DISABLE KEYS */;
INSERT INTO `share_type_extra_specs` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_type_id`, `spec_key`, `spec_value`) VALUES ('2025-11-29 05:30:57.403985',NULL,NULL,0,1,'dd081b42-5cd7-4c7c-8a9b-8db684f71e20','driver_handles_share_servers','False'),('2025-11-29 05:31:02.135504',NULL,NULL,0,2,'dd081b42-5cd7-4c7c-8a9b-8db684f71e20','snapshot_support','True'),('2025-11-29 05:31:02.138391',NULL,NULL,0,3,'dd081b42-5cd7-4c7c-8a9b-8db684f71e20','create_share_from_snapshot_support','True'),('2025-11-29 05:34:21.972870',NULL,'2025-11-29 05:35:47.689996',4,4,'03041fd8-9b14-4a66-8c4c-4377210067b9','driver_handles_share_servers','False'),('2025-11-29 05:34:21.973335',NULL,'2025-11-29 05:35:47.689996',5,5,'03041fd8-9b14-4a66-8c4c-4377210067b9','snapshot_support','True'),('2025-11-29 05:34:24.631192',NULL,'2025-11-29 05:34:34.947973',6,6,'235d3753-6144-4b29-b569-50b44a6b7188','driver_handles_share_servers','False'),('2025-11-29 05:34:36.010858',NULL,'2025-11-29 05:34:47.861342',7,7,'7e5bc69e-c8de-413a-a484-248ded56b5e3','driver_handles_share_servers','False'),('2025-11-29 05:34:41.362687',NULL,'2025-11-29 05:34:45.756055',8,8,'9cfb531b-9501-41df-a9d8-ef94d64a878d','driver_handles_share_servers','False'),('2025-11-29 05:34:41.500700',NULL,'2025-11-29 05:34:41.673279',9,9,'9cfb531b-9501-41df-a9d8-ef94d64a878d','key1','value1'),('2025-11-29 05:34:41.503566',NULL,'2025-11-29 05:34:45.756055',10,10,'9cfb531b-9501-41df-a9d8-ef94d64a878d','key2','value2'),('2025-11-29 05:34:42.119303',NULL,'2025-11-29 05:34:45.611561',11,11,'88a7fedf-27a8-45d8-b511-c27a770050bb','driver_handles_share_servers','False'),('2025-11-29 05:34:42.202598',NULL,'2025-11-29 05:34:45.611561',12,12,'88a7fedf-27a8-45d8-b511-c27a770050bb','key1','value1'),('2025-11-29 05:34:42.204690',NULL,'2025-11-29 05:34:45.611561',13,13,'88a7fedf-27a8-45d8-b511-c27a770050bb','key2','value2'),('2025-11-29 05:34:42.274538',NULL,'2025-11-29 05:34:42.661856',14,14,'88a7fedf-27a8-45d8-b511-c27a770050bb','snapshot_support','True'),('2025-11-29 05:34:42.901015',NULL,'2025-11-29 05:34:45.424211',15,15,'4888d699-d3d0-4dce-9ab9-a3a7d244180b','driver_handles_share_servers','False'),('2025-11-29 05:34:42.980307',NULL,'2025-11-29 05:34:45.424211',16,16,'4888d699-d3d0-4dce-9ab9-a3a7d244180b','key1','value1'),('2025-11-29 05:34:42.984277',NULL,'2025-11-29 05:34:45.424211',17,17,'4888d699-d3d0-4dce-9ab9-a3a7d244180b','key2','value2'),('2025-11-29 05:34:43.202879',NULL,'2025-11-29 05:34:43.498825',18,18,'4888d699-d3d0-4dce-9ab9-a3a7d244180b','snapshot_support','True'),('2025-11-29 05:34:43.887599',NULL,'2025-11-29 05:34:45.138212',19,19,'d934b72f-5250-4fc0-9f20-8d2296785c1e','driver_handles_share_servers','False'),('2025-11-29 05:34:44.147612',NULL,'2025-11-29 05:34:45.138212',20,20,'d934b72f-5250-4fc0-9f20-8d2296785c1e','key1','value1'),('2025-11-29 05:34:44.151121','2025-11-29 05:34:44.238530','2025-11-29 05:34:45.138212',21,21,'d934b72f-5250-4fc0-9f20-8d2296785c1e','key2','value2_updated'),('2025-11-29 05:34:44.486317',NULL,'2025-11-29 05:34:45.017038',22,22,'0f35da37-2bfc-4e3e-aa33-b1633a22961d','driver_handles_share_servers','False'),('2025-11-29 05:34:44.567646','2025-11-29 05:34:44.734454','2025-11-29 05:34:45.017038',23,23,'0f35da37-2bfc-4e3e-aa33-b1633a22961d','key1','fake_value1_updated'),('2025-11-29 05:34:44.569794',NULL,'2025-11-29 05:34:45.017038',24,24,'0f35da37-2bfc-4e3e-aa33-b1633a22961d','key2','value2'),('2025-11-29 05:34:52.961934',NULL,'2025-11-29 05:34:57.229470',25,25,'8ada48ed-e577-42d6-b8f2-17192dd4a5c2','driver_handles_share_servers','False'),('2025-11-29 05:34:52.962316',NULL,'2025-11-29 05:34:57.229470',26,26,'8ada48ed-e577-42d6-b8f2-17192dd4a5c2','key','value'),('2025-11-29 05:34:54.215138',NULL,'2025-11-29 05:34:56.814583',27,27,'ad222399-2df4-48f7-8b9c-5a013a802232','driver_handles_share_servers','False'),('2025-11-29 05:34:55.470872',NULL,'2025-11-29 05:34:56.642008',28,28,'f27e11e4-531e-43c7-b293-ebb75a2d1599','driver_handles_share_servers','False'),('2025-11-29 05:34:55.471464',NULL,'2025-11-29 05:34:56.642008',29,29,'f27e11e4-531e-43c7-b293-ebb75a2d1599','key','value'),('2025-11-29 05:34:55.799386',NULL,'2025-11-29 05:34:56.368501',30,30,'2ecdef7c-7b16-4188-b6be-4acc493f1f4f','driver_handles_share_servers','False'),('2025-11-29 05:34:55.804297',NULL,'2025-11-29 05:34:56.368501',31,31,'2ecdef7c-7b16-4188-b6be-4acc493f1f4f','key','value'),('2025-11-29 05:34:57.513338',NULL,'2025-11-29 05:34:59.796754',32,32,'3d5e9db7-0995-4bae-bc97-f337b26e5da3','driver_handles_share_servers','False'),('2025-11-29 05:34:58.478323',NULL,'2025-11-29 05:34:58.920295',33,33,'70481861-20b5-40bf-a4cc-b220736dca32','driver_handles_share_servers','False'),('2025-11-29 05:34:59.094011',NULL,'2025-11-29 05:34:59.669354',34,34,'1e97fc20-9eb6-4ad3-b670-687d961d20e5','driver_handles_share_servers','False'),('2025-11-29 05:35:07.046997',NULL,'2025-11-29 05:35:44.292043',35,35,'78a90e40-d5c8-4771-9de6-c085b16e4fa4','driver_handles_share_servers','False'),('2025-11-29 05:35:07.047446',NULL,'2025-11-29 05:35:44.292043',36,36,'78a90e40-d5c8-4771-9de6-c085b16e4fa4','snapshot_support','True'),('2025-11-29 05:35:07.047750',NULL,'2025-11-29 05:35:44.292043',37,37,'78a90e40-d5c8-4771-9de6-c085b16e4fa4','create_share_from_snapshot_support','True'),('2025-11-29 05:35:07.091776',NULL,'2025-11-29 05:35:39.706248',38,38,'897b7777-bc91-41a3-a0ae-0cc41ffc72f9','driver_handles_share_servers','False'),('2025-11-29 05:35:07.092333',NULL,'2025-11-29 05:35:39.706248',39,39,'897b7777-bc91-41a3-a0ae-0cc41ffc72f9','storage_protocol','cephfs'),('2025-11-29 05:35:07.092710',NULL,'2025-11-29 05:35:39.706248',40,40,'897b7777-bc91-41a3-a0ae-0cc41ffc72f9','snapshot_support','True'),('2025-11-29 05:35:07.093126',NULL,'2025-11-29 05:35:39.706248',41,41,'897b7777-bc91-41a3-a0ae-0cc41ffc72f9','create_share_from_snapshot_support','True'),('2025-11-29 05:35:07.213643',NULL,'2025-11-29 05:35:43.953686',42,42,'078baedb-e7c7-47ca-9eae-f6d4445bee40','driver_handles_share_servers','False'),('2025-11-29 05:35:07.341418',NULL,'2025-11-29 05:35:43.765145',43,43,'ddc6389e-dda9-47b0-85a7-6ad509ba0f38','driver_handles_share_servers','False'),('2025-11-29 05:35:12.294556',NULL,'2025-11-29 05:35:14.638040',44,44,'1a1a3c92-2b1b-4bc0-9147-3c9cd48aa184','driver_handles_share_servers','False'),('2025-11-29 05:35:12.460898',NULL,'2025-11-29 05:35:14.480219',45,45,'c536263c-2a56-4348-843a-3f25566caf35','driver_handles_share_servers','False'),('2025-11-29 05:35:12.622923',NULL,'2025-11-29 05:35:14.329288',46,46,'92d00e41-03bf-4f17-b9b4-b17dc4c30a08','driver_handles_share_servers','False'),('2025-11-29 05:35:12.780297',NULL,'2025-11-29 05:35:14.197490',47,47,'d00d1dd8-87b1-416a-aa89-8dafbd1c2c64','driver_handles_share_servers','False'),('2025-11-29 05:35:12.969612',NULL,'2025-11-29 05:35:14.039415',48,48,'81b7be42-7b8b-456f-95d1-8a24415809e2','driver_handles_share_servers','False'),('2025-11-29 05:35:12.970864',NULL,'2025-11-29 05:35:14.039415',49,49,'81b7be42-7b8b-456f-95d1-8a24415809e2','share_backend_name','tempest-fake_name-2138489460'),('2025-11-29 05:35:13.154979',NULL,'2025-11-29 05:35:13.894475',50,50,'1891d124-55e3-4f6a-9827-e2d9c4231a7c','driver_handles_share_servers','False'),('2025-11-29 05:35:13.155463',NULL,'2025-11-29 05:35:13.894475',51,51,'1891d124-55e3-4f6a-9827-e2d9c4231a7c','share_backend_name','tempest-fake_name-1187261529'),('2025-11-29 05:35:13.286763',NULL,'2025-11-29 05:35:13.749981',52,52,'61828dc9-a0cc-42f7-a4c5-d6f6197e0e01','driver_handles_share_servers','False'),('2025-11-29 05:35:13.287423',NULL,'2025-11-29 05:35:13.749981',53,53,'61828dc9-a0cc-42f7-a4c5-d6f6197e0e01','share_backend_name','tempest-fake_name-1705673046'),('2025-11-29 05:35:13.464103',NULL,'2025-11-29 05:35:13.603628',54,54,'b652a17e-4afa-4a55-934d-3ad510cd71a0','driver_handles_share_servers','False'),('2025-11-29 05:35:13.464491',NULL,'2025-11-29 05:35:13.603628',55,55,'b652a17e-4afa-4a55-934d-3ad510cd71a0','share_backend_name','tempest-fake_name-1728322461'),('2025-11-29 05:35:25.388345',NULL,'2025-11-29 05:35:43.427658',56,56,'f67bd588-143f-43fa-afb1-11534eb30af9','driver_handles_share_servers','False'),('2025-11-29 05:35:26.340259',NULL,'2025-11-29 05:35:43.267872',57,57,'57140e21-36a1-4c7c-919e-55548c6b7f73','driver_handles_share_servers','False'),('2025-11-29 05:35:27.803070',NULL,'2025-11-29 05:35:43.141563',58,58,'da0820f0-008b-47f7-acdd-4f4acff2c7e9','driver_handles_share_servers','False'),('2025-11-29 05:35:33.120968',NULL,'2025-11-29 05:35:42.922661',59,59,'634aa3ee-1b2b-440c-89ae-4360075d13d4','driver_handles_share_servers','False'),('2025-11-29 05:35:34.480326',NULL,'2025-11-29 05:35:42.696655',60,60,'73518200-bf68-4245-825c-570887a53b76','driver_handles_share_servers','False'),('2025-11-29 05:35:35.591039',NULL,'2025-11-29 05:35:42.516579',61,61,'50662731-2f67-4824-83cd-c8da89fb4e2c','driver_handles_share_servers','False'),('2025-11-29 05:35:35.913773',NULL,'2025-11-29 05:35:42.241717',62,62,'f29d90ca-7366-41b1-9029-74f9055a75bd','driver_handles_share_servers','False'),('2025-11-29 05:35:39.991780',NULL,'2025-11-29 05:36:32.585025',63,63,'205bf72e-a1ad-4135-9618-25977b47af59','driver_handles_share_servers','False'),('2025-11-29 05:35:50.582537',NULL,'2025-11-29 05:36:34.799171',64,64,'d8457b4e-8e27-45f2-9628-fa0bc63046d3','driver_handles_share_servers','False'),('2025-11-29 05:35:50.582989',NULL,'2025-11-29 05:36:34.799171',65,65,'d8457b4e-8e27-45f2-9628-fa0bc63046d3','vendor_name','foobar'),('2025-11-29 05:35:53.661895',NULL,'2025-11-29 05:36:06.051111',66,66,'57502de6-1e0c-41d0-84e3-fe1b0b8839c8','driver_handles_share_servers','False'),('2025-11-29 05:35:53.662379',NULL,'2025-11-29 05:36:06.051111',67,67,'57502de6-1e0c-41d0-84e3-fe1b0b8839c8','snapshot_support','True'),('2025-11-29 05:35:54.828377',NULL,'2025-11-29 05:36:34.547987',68,68,'77e59b2f-3ee6-4ed4-b09e-dedd3f47a51b','driver_handles_share_servers','False'),('2025-11-29 05:35:54.828743',NULL,'2025-11-29 05:36:34.547987',69,69,'77e59b2f-3ee6-4ed4-b09e-dedd3f47a51b','vendor_name','foobar'),('2025-11-29 05:35:58.611535',NULL,'2025-11-29 05:36:06.054580',70,70,'80792ca9-8a81-49c4-baba-8e68998249cb','driver_handles_share_servers','False'),('2025-11-29 05:35:58.861225',NULL,'2025-11-29 05:36:34.353689',71,71,'62dda89e-c74f-4ef4-9255-9731f4924d04','driver_handles_share_servers','False'),('2025-11-29 05:35:58.861697',NULL,'2025-11-29 05:36:34.353689',72,72,'62dda89e-c74f-4ef4-9255-9731f4924d04','vendor_name','foobar'),('2025-11-29 05:36:02.370191',NULL,'2025-11-29 05:36:34.008802',73,73,'03e2ced0-98dd-40d4-ad9e-7539269b2b2c','driver_handles_share_servers','False'),('2025-11-29 05:36:02.373198',NULL,'2025-11-29 05:36:34.008802',74,74,'03e2ced0-98dd-40d4-ad9e-7539269b2b2c','vendor_name','foobar'),('2025-11-29 05:36:06.564215',NULL,'2025-11-29 05:36:33.714499',75,75,'e5dc9337-9d3d-486c-9f20-360499be97a6','driver_handles_share_servers','False'),('2025-11-29 05:36:06.565409',NULL,'2025-11-29 05:36:33.714499',76,76,'e5dc9337-9d3d-486c-9f20-360499be97a6','vendor_name','foobar'),('2025-11-29 05:36:10.563679',NULL,'2025-11-29 05:36:33.250350',77,77,'bb4c2cdc-b39c-4d8f-a756-4b5a9da20637','driver_handles_share_servers','False'),('2025-11-29 05:36:10.564131',NULL,'2025-11-29 05:36:33.250350',78,78,'bb4c2cdc-b39c-4d8f-a756-4b5a9da20637','vendor_name','foobar'),('2025-11-29 05:36:14.273317',NULL,'2025-11-29 05:36:32.352779',79,79,'644aee24-dced-4b70-b164-4e0bd00ebe5c','driver_handles_share_servers','False'),('2025-11-29 05:36:14.273722',NULL,'2025-11-29 05:36:32.352779',80,80,'644aee24-dced-4b70-b164-4e0bd00ebe5c','vendor_name','foobar'),('2025-11-29 05:36:19.065270',NULL,'2025-11-29 05:36:32.175618',81,81,'a681e9d5-0cbf-4919-9306-45c3663a2e71','driver_handles_share_servers','False'),('2025-11-29 05:36:19.065774',NULL,'2025-11-29 05:36:32.175618',82,82,'a681e9d5-0cbf-4919-9306-45c3663a2e71','vendor_name','foobar'),('2025-11-29 05:36:22.837242',NULL,'2025-11-29 05:36:31.908646',83,83,'83704507-2af4-41ec-bd6a-c7c15772addd','driver_handles_share_servers','False'),('2025-11-29 05:36:22.837963',NULL,'2025-11-29 05:36:31.908646',84,84,'83704507-2af4-41ec-bd6a-c7c15772addd','vendor_name','foobar'),('2025-11-29 05:36:23.241307',NULL,'2025-11-29 05:36:58.756537',85,85,'f0da18b9-ba8c-41ec-8938-860c87e4760c','driver_handles_share_servers','False'),('2025-11-29 05:36:27.465187',NULL,'2025-11-29 05:36:54.384224',86,86,'1f1645da-a938-4300-adbc-b0962ae574cd','driver_handles_share_servers','False'),('2025-11-29 05:36:27.465847',NULL,'2025-11-29 05:36:54.384224',87,87,'1f1645da-a938-4300-adbc-b0962ae574cd','snapshot_support','True'),('2025-11-29 05:36:27.476682',NULL,'2025-11-29 05:36:31.777697',88,88,'7d4fb520-be4b-4ab9-a6cf-8d815f406791','driver_handles_share_servers','False'),('2025-11-29 05:36:27.477482',NULL,'2025-11-29 05:36:31.777697',89,89,'7d4fb520-be4b-4ab9-a6cf-8d815f406791','vendor_name','foobar'),('2025-11-29 05:36:35.373557',NULL,'2025-11-29 05:36:51.815137',90,90,'7f2792d4-06d9-4366-b057-6d917cc2fefa','driver_handles_share_servers','False'),('2025-11-29 05:36:35.377594',NULL,'2025-11-29 05:36:51.815137',91,91,'7f2792d4-06d9-4366-b057-6d917cc2fefa','snapshot_support','True'),('2025-11-29 05:36:35.534555',NULL,'2025-11-29 05:36:47.150740',92,92,'676e0f63-bc7a-4538-a2e3-14bf97d2ac48','driver_handles_share_servers','False'),('2025-11-29 05:36:35.826350',NULL,'2025-11-29 05:36:46.933559',93,93,'b8bbc10e-bbfb-4007-ae24-0c9ba2e1639a','driver_handles_share_servers','False'),('2025-11-29 05:36:36.012154',NULL,'2025-11-29 05:36:46.676587',94,94,'70dc350e-c5fc-4249-8dc1-5e12fa9b8058','driver_handles_share_servers','False'),('2025-11-29 05:36:37.390062',NULL,'2025-11-29 05:36:46.467962',95,95,'aa3b563c-a35c-4a81-9bd2-51ec16a5751b','driver_handles_share_servers','False'),('2025-11-29 05:36:37.569760',NULL,'2025-11-29 05:36:46.265978',96,96,'b610f981-caae-442d-992f-d3070669256d','driver_handles_share_servers','False'),('2025-11-29 05:36:37.725821',NULL,'2025-11-29 05:36:45.961159',97,97,'3e606a05-b7bc-41c7-ae90-55a4b27d22df','driver_handles_share_servers','False'),('2025-11-29 05:36:41.020133',NULL,'2025-11-29 05:36:45.795197',98,98,'08417f79-12b9-443c-b0b1-2da4fb93c828','driver_handles_share_servers','False'),('2025-11-29 05:36:41.282408',NULL,'2025-11-29 05:36:45.660946',99,99,'beb732ef-f722-4528-ab93-98a32dedc8e2','driver_handles_share_servers','False'),('2025-11-29 05:36:41.638485',NULL,'2025-11-29 05:36:45.395539',100,100,'b5a23694-d3f1-44c1-b325-c0154d6a4d6f','driver_handles_share_servers','False'),('2025-11-29 05:36:42.000521',NULL,'2025-11-29 05:36:45.133845',101,101,'f9c8394e-7f23-4249-904b-0125fe8452da','driver_handles_share_servers','False'),('2025-11-29 05:36:43.299394',NULL,'2025-11-29 05:36:44.824928',102,102,'4ff0bf30-dcf1-4c70-80fa-1a9c2f842719','driver_handles_share_servers','False'),('2025-11-29 05:36:44.090958',NULL,'2025-11-29 05:36:44.641133',103,103,'afa96037-2144-4f7b-894f-287a77ed7458','driver_handles_share_servers','False'),('2025-11-29 05:36:45.594543',NULL,'2025-11-29 05:36:54.180164',104,104,'eb844929-18ba-4d18-8fc0-5ba67aa3721e','driver_handles_share_servers','False'),('2025-11-29 05:36:54.737666',NULL,'2025-11-29 05:37:09.792849',105,105,'31306647-5051-4d12-8b50-7a96c707889c','driver_handles_share_servers','False'),('2025-11-29 05:36:58.435252',NULL,'2025-11-29 05:37:21.760135',106,106,'819b63e0-5000-4547-bb28-596952ee3776','driver_handles_share_servers','False'),('2025-11-29 05:36:58.435649',NULL,'2025-11-29 05:37:21.760135',107,107,'819b63e0-5000-4547-bb28-596952ee3776','storage_protocol','cephfs'),('2025-11-29 05:37:02.545956',NULL,'2025-11-29 05:37:17.652073',108,108,'0a94ce00-6edf-4469-83e6-d6e3c0fbd8a2','driver_handles_share_servers','False'),('2025-11-29 05:37:02.546457',NULL,'2025-11-29 05:37:17.652073',109,109,'0a94ce00-6edf-4469-83e6-d6e3c0fbd8a2','key','value'),('2025-11-29 05:37:02.556711',NULL,'2025-11-29 05:37:12.550849',110,110,'12e06c28-78cd-4240-8800-3060cf711953','driver_handles_share_servers','False'),('2025-11-29 05:37:03.611168',NULL,'2025-11-29 05:37:03.694203',111,111,'3f8c5edd-6e80-409c-96a2-becf9dd5c296','driver_handles_share_servers','False'),('2025-11-29 05:37:04.043345',NULL,'2025-11-29 05:37:17.237065',112,112,'da877f40-3e66-4f6d-a3b7-6826e8fd999d','driver_handles_share_servers','False'),('2025-11-29 05:37:04.043825',NULL,'2025-11-29 05:37:17.237065',113,113,'da877f40-3e66-4f6d-a3b7-6826e8fd999d','key','value'),('2025-11-29 05:37:04.044276',NULL,'2025-11-29 05:37:17.237065',114,114,'da877f40-3e66-4f6d-a3b7-6826e8fd999d','snapshot_support','True'),('2025-11-29 05:37:04.200341',NULL,'2025-11-29 05:37:16.907944',115,115,'c2c0ada2-9e75-4f07-bd00-292376096739','driver_handles_share_servers','False'),('2025-11-29 05:37:04.200829',NULL,'2025-11-29 05:37:16.907944',116,116,'c2c0ada2-9e75-4f07-bd00-292376096739','key','value'),('2025-11-29 05:37:04.201152',NULL,'2025-11-29 05:37:16.907944',117,117,'c2c0ada2-9e75-4f07-bd00-292376096739','snapshot_support','True'),('2025-11-29 05:37:04.408441',NULL,'2025-11-29 05:37:16.637782',118,118,'959482fa-bb5c-4ff1-8485-d7be153c32c4','driver_handles_share_servers','False'),('2025-11-29 05:37:04.408782',NULL,'2025-11-29 05:37:16.637782',119,119,'959482fa-bb5c-4ff1-8485-d7be153c32c4','key','value'),('2025-11-29 05:37:04.409083',NULL,'2025-11-29 05:37:16.637782',120,120,'959482fa-bb5c-4ff1-8485-d7be153c32c4','snapshot_support','True'),('2025-11-29 05:37:04.585051',NULL,'2025-11-29 05:37:16.018883',121,121,'bb9a5358-bb7c-4ade-98f2-417d2eb33b1c','driver_handles_share_servers','False'),('2025-11-29 05:37:04.585604',NULL,'2025-11-29 05:37:16.018883',122,122,'bb9a5358-bb7c-4ade-98f2-417d2eb33b1c','key','value'),('2025-11-29 05:37:04.771854',NULL,'2025-11-29 05:37:15.639499',123,123,'ffe4fd1c-8f3d-4298-9eb8-f27c0dae3ab2','driver_handles_share_servers','False'),('2025-11-29 05:37:04.772306',NULL,'2025-11-29 05:37:15.639499',124,124,'ffe4fd1c-8f3d-4298-9eb8-f27c0dae3ab2','key','value'),('2025-11-29 05:37:04.979699',NULL,'2025-11-29 05:37:15.356532',125,125,'7c701cc2-0ef9-48eb-8377-20f751aec481','driver_handles_share_servers','False'),('2025-11-29 05:37:04.980107',NULL,'2025-11-29 05:37:15.356532',126,126,'7c701cc2-0ef9-48eb-8377-20f751aec481','snapshot_support','True'),('2025-11-29 05:37:05.278720',NULL,'2025-11-29 05:37:15.074155',127,127,'e65f70d4-c6c1-41ff-a1b8-3990320eac47','driver_handles_share_servers','False'),('2025-11-29 05:37:05.279562',NULL,'2025-11-29 05:37:15.074155',128,128,'e65f70d4-c6c1-41ff-a1b8-3990320eac47','snapshot_support','True'),('2025-11-29 05:37:05.454234',NULL,'2025-11-29 05:37:14.762750',129,129,'1bfeb996-28af-4078-aa59-0bf0ceb378e9','driver_handles_share_servers','False'),('2025-11-29 05:37:05.454621',NULL,'2025-11-29 05:37:14.762750',130,130,'1bfeb996-28af-4078-aa59-0bf0ceb378e9','snapshot_support','True'),('2025-11-29 05:37:05.608973',NULL,'2025-11-29 05:37:14.388859',131,131,'ad76df29-c304-44fd-836c-c11262b59753','driver_handles_share_servers','False'),('2025-11-29 05:37:05.760010',NULL,'2025-11-29 05:37:14.173753',132,132,'8b06e397-199b-4e6c-ac50-bf38614972d4','driver_handles_share_servers','False'),('2025-11-29 05:37:06.132194',NULL,'2025-11-29 05:37:13.962751',133,133,'66703129-7091-448f-af6c-18587b9a0a19','driver_handles_share_servers','False'),('2025-11-29 05:37:06.412063',NULL,'2025-11-29 05:37:13.541957',134,134,'41c22681-a9fb-48fa-af53-18deca6690dd','driver_handles_share_servers','False'),('2025-11-29 05:37:06.653464',NULL,'2025-11-29 05:37:13.227603',135,135,'c4983168-d9e2-4eb9-8d11-0d2417167825','driver_handles_share_servers','False'),('2025-11-29 05:37:06.974010',NULL,'2025-11-29 05:37:12.949691',136,136,'a0b3dd9c-fb15-4f80-acf1-c2f9063cdef2','driver_handles_share_servers','False'),('2025-11-29 05:37:06.975306',NULL,'2025-11-29 05:37:12.949691',137,137,'a0b3dd9c-fb15-4f80-acf1-c2f9063cdef2','key','value'),('2025-11-29 05:37:07.204617',NULL,'2025-11-29 05:37:12.656649',138,138,'45a44b28-407f-49e1-94b4-3aa806857a8f','driver_handles_share_servers','False'),('2025-11-29 05:37:07.205146',NULL,'2025-11-29 05:37:12.656649',139,139,'45a44b28-407f-49e1-94b4-3aa806857a8f','key','value'),('2025-11-29 05:37:07.746890',NULL,'2025-11-29 05:37:12.471265',140,140,'f0cafc49-6761-4502-848b-eb58ed369a28','driver_handles_share_servers','False'),('2025-11-29 05:37:07.747257',NULL,'2025-11-29 05:37:12.471265',141,141,'f0cafc49-6761-4502-848b-eb58ed369a28','key','value'),('2025-11-29 05:37:07.910609',NULL,'2025-11-29 05:37:12.309170',142,142,'f808eddd-f29d-40db-9e82-88aa9f36b799','driver_handles_share_servers','False'),('2025-11-29 05:37:07.912898',NULL,'2025-11-29 05:37:12.309170',143,143,'f808eddd-f29d-40db-9e82-88aa9f36b799','key','value'),('2025-11-29 05:37:08.087842',NULL,'2025-11-29 05:37:12.095450',144,144,'12f6fd42-008e-43a2-a67a-0eadebaaa635','driver_handles_share_servers','False'),('2025-11-29 05:37:08.088918',NULL,'2025-11-29 05:37:12.095450',145,145,'12f6fd42-008e-43a2-a67a-0eadebaaa635','key','value'),('2025-11-29 05:37:08.243677',NULL,'2025-11-29 05:37:11.854416',146,146,'3468c15b-11c1-49f4-9647-c8ccf5adbd98','driver_handles_share_servers','False'),('2025-11-29 05:37:08.245151',NULL,'2025-11-29 05:37:11.854416',147,147,'3468c15b-11c1-49f4-9647-c8ccf5adbd98','key','value'),('2025-11-29 05:37:08.559312',NULL,'2025-11-29 05:37:11.501615',148,148,'517c09d5-2c2f-4050-8078-855228d485ef','driver_handles_share_servers','False'),('2025-11-29 05:37:08.559740',NULL,'2025-11-29 05:37:11.501615',149,149,'517c09d5-2c2f-4050-8078-855228d485ef','key','value'),('2025-11-29 05:37:08.725809',NULL,'2025-11-29 05:37:11.290455',150,150,'eb7c2d6e-dc4c-41a8-8d84-bd0f993ec7da','driver_handles_share_servers','False'),('2025-11-29 05:37:08.726226',NULL,'2025-11-29 05:37:11.290455',151,151,'eb7c2d6e-dc4c-41a8-8d84-bd0f993ec7da','key','value'),('2025-11-29 05:37:08.900452',NULL,'2025-11-29 05:37:11.088270',152,152,'cd0b094d-bad5-4186-a8fc-49ed1935e0f1','driver_handles_share_servers','False'),('2025-11-29 05:37:08.900847',NULL,'2025-11-29 05:37:11.088270',153,153,'cd0b094d-bad5-4186-a8fc-49ed1935e0f1','key','value'),('2025-11-29 05:37:09.137280',NULL,'2025-11-29 05:37:10.780574',154,154,'51632af3-9236-44a1-b4b1-cccc135e79bc','driver_handles_share_servers','False'),('2025-11-29 05:37:09.138807',NULL,'2025-11-29 05:37:10.780574',155,155,'51632af3-9236-44a1-b4b1-cccc135e79bc','key','value'),('2025-11-29 05:37:09.387430',NULL,'2025-11-29 05:37:10.344889',156,156,'6fbb3f3f-2d4c-4525-b719-7de2e95abb5d','driver_handles_share_servers','False'),('2025-11-29 05:37:09.387889',NULL,'2025-11-29 05:37:10.344889',157,157,'6fbb3f3f-2d4c-4525-b719-7de2e95abb5d','key','value'),('2025-11-29 05:37:09.571293',NULL,'2025-11-29 05:37:10.136039',158,158,'a8fc1c49-566d-48eb-a223-6242c7f2de6e','driver_handles_share_servers','False'),('2025-11-29 05:37:09.571896',NULL,'2025-11-29 05:37:10.136039',159,159,'a8fc1c49-566d-48eb-a223-6242c7f2de6e','key','value'),('2025-11-29 05:37:17.054963',NULL,'2025-11-29 05:37:37.243211',160,160,'3cde5f7b-914b-4874-be2f-d7385fe4a149','driver_handles_share_servers','False'),('2025-11-29 05:37:17.055568',NULL,'2025-11-29 05:37:37.243211',161,161,'3cde5f7b-914b-4874-be2f-d7385fe4a149','snapshot_support','True'),('2025-11-29 05:37:18.920856',NULL,NULL,0,162,'27ce7e9e-5dd7-42c3-997a-123357081bf4','driver_handles_share_servers','False'),('2025-11-29 05:37:21.297047',NULL,'2025-11-29 05:37:25.236141',163,163,'cfdf202d-2b58-4af2-9d24-20184b232286','driver_handles_share_servers','False'),('2025-11-29 05:37:28.243978',NULL,'2025-11-29 05:37:39.079933',164,164,'e5d3b05b-5fb4-4fb7-886d-de31ce6345c4','driver_handles_share_servers','False'),('2025-11-29 05:37:28.244544',NULL,'2025-11-29 05:37:39.079933',165,165,'e5d3b05b-5fb4-4fb7-886d-de31ce6345c4','key','value'),('2025-11-29 05:37:29.431229',NULL,'2025-11-29 05:37:38.900072',166,166,'a19f58d0-cdad-496a-b25c-606ab0b556f8','driver_handles_share_servers','False'),('2025-11-29 05:37:29.432110',NULL,'2025-11-29 05:37:38.900072',167,167,'a19f58d0-cdad-496a-b25c-606ab0b556f8','key','value'),('2025-11-29 05:37:29.769715',NULL,'2025-11-29 05:37:38.775398',168,168,'33c57203-b161-4bdd-9d91-70c3c1341bbe','driver_handles_share_servers','False'),('2025-11-29 05:37:29.770144',NULL,'2025-11-29 05:37:38.775398',169,169,'33c57203-b161-4bdd-9d91-70c3c1341bbe','key','value'),('2025-11-29 05:37:30.128645',NULL,'2025-11-29 05:37:38.563107',170,170,'911db201-237b-4c1b-b02d-aa0ec6c9af33','driver_handles_share_servers','False'),('2025-11-29 05:37:30.129053',NULL,'2025-11-29 05:37:38.563107',171,171,'911db201-237b-4c1b-b02d-aa0ec6c9af33','key','value'),('2025-11-29 05:37:30.281188',NULL,'2025-11-29 05:37:38.420972',172,172,'b0c24e9e-99ec-4458-a7a2-f624fe298a78','driver_handles_share_servers','False'),('2025-11-29 05:37:30.281643',NULL,'2025-11-29 05:37:38.420972',173,173,'b0c24e9e-99ec-4458-a7a2-f624fe298a78','key','value'),('2025-11-29 05:37:30.412713',NULL,'2025-11-29 05:37:38.277601',174,174,'60811434-bd50-4e5c-98d4-3f78127c4ca8','driver_handles_share_servers','False'),('2025-11-29 05:37:30.413171',NULL,'2025-11-29 05:37:38.277601',175,175,'60811434-bd50-4e5c-98d4-3f78127c4ca8','key','value'),('2025-11-29 05:37:30.760922',NULL,'2025-11-29 05:37:38.103569',176,176,'68963864-0ad6-4f45-be82-9ace44a74d80','driver_handles_share_servers','False'),('2025-11-29 05:37:30.761385',NULL,'2025-11-29 05:37:38.103569',177,177,'68963864-0ad6-4f45-be82-9ace44a74d80','key','value'),('2025-11-29 05:37:31.033149',NULL,'2025-11-29 05:37:37.965072',178,178,'fda01a86-07fc-4d6c-9626-8a66177cf3f6','driver_handles_share_servers','False'),('2025-11-29 05:37:31.033636',NULL,'2025-11-29 05:37:37.965072',179,179,'fda01a86-07fc-4d6c-9626-8a66177cf3f6','key','value'),('2025-11-29 05:37:31.202045',NULL,'2025-11-29 05:37:37.806357',180,180,'07f9013e-e913-47bc-98db-7017fbb633f7','driver_handles_share_servers','False'),('2025-11-29 05:37:31.202673',NULL,'2025-11-29 05:37:37.806357',181,181,'07f9013e-e913-47bc-98db-7017fbb633f7','key','value'),('2025-11-29 05:37:31.310642',NULL,'2025-11-29 05:37:37.519262',182,182,'6bfbefe6-351a-403d-9283-7e85f26b8a0f','driver_handles_share_servers','False'),('2025-11-29 05:37:31.311087',NULL,'2025-11-29 05:37:37.519262',183,183,'6bfbefe6-351a-403d-9283-7e85f26b8a0f','key','value'),('2025-11-29 05:37:31.490238',NULL,'2025-11-29 05:37:37.391170',184,184,'db048fd6-3099-4879-ae15-e536099ed173','driver_handles_share_servers','False'),('2025-11-29 05:37:31.491522',NULL,'2025-11-29 05:37:37.391170',185,185,'db048fd6-3099-4879-ae15-e536099ed173','key','value'),('2025-11-29 05:37:31.937690',NULL,'2025-11-29 05:37:37.262716',186,186,'50d99d61-82c8-42c5-a349-6ee3a2bafba3','driver_handles_share_servers','False'),('2025-11-29 05:37:31.938074',NULL,'2025-11-29 05:37:37.262716',187,187,'50d99d61-82c8-42c5-a349-6ee3a2bafba3','key','value'),('2025-11-29 05:37:32.416054',NULL,'2025-11-29 05:37:37.104097',188,188,'9868fd9a-d2e8-437e-ba55-da7d374609d0','driver_handles_share_servers','False'),('2025-11-29 05:37:32.416484',NULL,'2025-11-29 05:37:37.104097',189,189,'9868fd9a-d2e8-437e-ba55-da7d374609d0','key','value'),('2025-11-29 05:37:32.612610',NULL,'2025-11-29 05:37:36.918704',190,190,'e32ae0f8-6e2a-45d7-b203-8c4ee8859287','driver_handles_share_servers','False'),('2025-11-29 05:37:32.613038',NULL,'2025-11-29 05:37:36.918704',191,191,'e32ae0f8-6e2a-45d7-b203-8c4ee8859287','key','value'),('2025-11-29 05:37:33.073486',NULL,'2025-11-29 05:37:36.733947',192,192,'cdc01aac-3c5d-4549-a04e-9a2ec886678b','driver_handles_share_servers','False'),('2025-11-29 05:37:33.073958',NULL,'2025-11-29 05:37:36.733947',193,193,'cdc01aac-3c5d-4549-a04e-9a2ec886678b','key','value'),('2025-11-29 05:37:33.365650',NULL,'2025-11-29 05:37:36.531037',194,194,'5229c382-a25d-4ac5-9d9e-543a5f776b1a','driver_handles_share_servers','False'),('2025-11-29 05:37:33.366074',NULL,'2025-11-29 05:37:36.531037',195,195,'5229c382-a25d-4ac5-9d9e-543a5f776b1a','key','value'),('2025-11-29 05:37:33.506399',NULL,'2025-11-29 05:37:36.388228',196,196,'26e0b4b9-ae7e-49f3-b396-cd7e53677219','driver_handles_share_servers','False'),('2025-11-29 05:37:33.506877',NULL,'2025-11-29 05:37:36.388228',197,197,'26e0b4b9-ae7e-49f3-b396-cd7e53677219','key','value'),('2025-11-29 05:37:33.738258',NULL,'2025-11-29 05:37:36.251714',198,198,'92060af6-afdc-4cef-801f-7698963773bd','driver_handles_share_servers','False'),('2025-11-29 05:37:33.738693',NULL,'2025-11-29 05:37:36.251714',199,199,'92060af6-afdc-4cef-801f-7698963773bd','key','value'),('2025-11-29 05:37:34.081511',NULL,'2025-11-29 05:37:35.999237',200,200,'7b82d01d-c515-46e2-b74e-df897634d2a8','driver_handles_share_servers','False'),('2025-11-29 05:37:34.081968',NULL,'2025-11-29 05:37:35.999237',201,201,'7b82d01d-c515-46e2-b74e-df897634d2a8','key','value'),('2025-11-29 05:37:34.228243',NULL,'2025-11-29 05:37:35.806386',202,202,'77179889-b2ec-42c9-bc48-393fc79ae3a1','driver_handles_share_servers','False'),('2025-11-29 05:37:34.229570',NULL,'2025-11-29 05:37:35.806386',203,203,'77179889-b2ec-42c9-bc48-393fc79ae3a1','key','value'),('2025-11-29 05:37:34.415513',NULL,'2025-11-29 05:37:35.654268',204,204,'1438be9d-b9dc-4616-97e2-fb540616d7b4','driver_handles_share_servers','False'),('2025-11-29 05:37:34.415970',NULL,'2025-11-29 05:37:35.654268',205,205,'1438be9d-b9dc-4616-97e2-fb540616d7b4','key','value'),('2025-11-29 05:37:34.760604',NULL,'2025-11-29 05:37:35.454812',206,206,'d1b6fdd3-2c14-4af6-b1fb-b555150c2a27','driver_handles_share_servers','False'),('2025-11-29 05:37:34.761051',NULL,'2025-11-29 05:37:35.454812',207,207,'d1b6fdd3-2c14-4af6-b1fb-b555150c2a27','key','value'),('2025-11-29 05:37:35.431564',NULL,'2025-11-29 05:37:53.044503',208,208,'15c7aea3-577a-4acc-8a07-1d147dd95e25','driver_handles_share_servers','False'),('2025-11-29 05:37:40.938750',NULL,'2025-11-29 05:37:41.262246',209,209,'3cab68ce-7acf-4a07-b1f9-2a83ccfa3131','driver_handles_share_servers','False'),('2025-11-29 05:37:41.027952',NULL,'2025-11-29 05:37:41.262246',210,210,'3cab68ce-7acf-4a07-b1f9-2a83ccfa3131','key1','value1'),('2025-11-29 05:37:41.031669',NULL,'2025-11-29 05:37:41.262246',211,211,'3cab68ce-7acf-4a07-b1f9-2a83ccfa3131','key2','value2'),('2025-11-29 05:37:47.799149',NULL,'2025-11-29 05:38:09.769416',212,212,'1d21dac2-ed08-46ff-8c64-215bda949560','driver_handles_share_servers','False'),('2025-11-29 05:37:47.799532',NULL,'2025-11-29 05:38:09.769416',213,213,'1d21dac2-ed08-46ff-8c64-215bda949560','vendor_name','foobar'),('2025-11-29 05:37:52.400342',NULL,'2025-11-29 05:38:09.578193',214,214,'407c3566-cec9-4eac-baeb-e009fd1528f3','driver_handles_share_servers','False'),('2025-11-29 05:37:52.404257',NULL,'2025-11-29 05:38:09.578193',215,215,'407c3566-cec9-4eac-baeb-e009fd1528f3','vendor_name','foobar'),('2025-11-29 05:37:54.966288',NULL,'2025-11-29 05:38:21.196133',216,216,'9d07efed-6109-49c2-afdb-237feef528bc','driver_handles_share_servers','False'),('2025-11-29 05:37:56.651201',NULL,'2025-11-29 05:38:09.372416',217,217,'3e7b666b-a9bd-4c69-8060-6813139fdc67','driver_handles_share_servers','False'),('2025-11-29 05:37:56.651565',NULL,'2025-11-29 05:38:09.372416',218,218,'3e7b666b-a9bd-4c69-8060-6813139fdc67','vendor_name','foobar'),('2025-11-29 05:38:00.830009',NULL,'2025-11-29 05:38:09.140832',219,219,'bfcc714f-2a94-4cb0-9045-624924898779','driver_handles_share_servers','False'),('2025-11-29 05:38:00.830715',NULL,'2025-11-29 05:38:09.140832',220,220,'bfcc714f-2a94-4cb0-9045-624924898779','vendor_name','foobar'),('2025-11-29 05:38:01.293061',NULL,'2025-11-29 05:38:43.714517',221,221,'7c6b9483-7c46-438e-a204-efa953929f7b','driver_handles_share_servers','False'),('2025-11-29 05:38:01.684390',NULL,'2025-11-29 05:38:01.816909',222,222,'a5274d0e-2afa-4865-98e4-857b30a4da0c','driver_handles_share_servers','False'),('2025-11-29 05:38:01.684805',NULL,'2025-11-29 05:38:01.816909',223,223,'a5274d0e-2afa-4865-98e4-857b30a4da0c','availability_zones','az1,az2,az 3'),('2025-11-29 05:38:02.031366',NULL,'2025-11-29 05:38:02.246852',224,224,'e49e1ec3-771b-4952-a465-3fed071cdec7','driver_handles_share_servers','False'),('2025-11-29 05:38:02.032183',NULL,'2025-11-29 05:38:02.246852',225,225,'e49e1ec3-771b-4952-a465-3fed071cdec7','availability_zones','az1,az2,az 3'),('2025-11-29 05:38:02.387358',NULL,'2025-11-29 05:38:02.525754',226,226,'ad3225f7-e126-4f33-8824-bfbc4602bebe','driver_handles_share_servers','False'),('2025-11-29 05:38:02.387728',NULL,'2025-11-29 05:38:02.525754',227,227,'ad3225f7-e126-4f33-8824-bfbc4602bebe','availability_zones','az1,az2,az 3'),('2025-11-29 05:38:02.678268',NULL,'2025-11-29 05:38:03.243781',228,228,'dc0222c0-c786-4aab-8322-4a9bf670d3fa','driver_handles_share_servers','False'),('2025-11-29 05:38:02.678675',NULL,'2025-11-29 05:38:03.243781',229,229,'dc0222c0-c786-4aab-8322-4a9bf670d3fa','availability_zones','az1,az2,az 3'),('2025-11-29 05:38:02.755497',NULL,'2025-11-29 05:38:03.036965',230,230,'b24628d5-2fc2-4bcc-99cf-36bb7fddb26e','driver_handles_share_servers','False'),('2025-11-29 05:38:03.469735',NULL,'2025-11-29 05:38:03.973693',231,231,'737a3d79-4bf6-4732-9515-9720936aa501','driver_handles_share_servers','False'),('2025-11-29 05:38:03.470262',NULL,'2025-11-29 05:38:03.973693',232,232,'737a3d79-4bf6-4732-9515-9720936aa501','availability_zones','az1,az2,az 3'),('2025-11-29 05:38:03.556430',NULL,'2025-11-29 05:38:03.769593',233,233,'c3151f22-dbee-41ae-9395-c74fbac49369','driver_handles_share_servers','False'),('2025-11-29 05:38:04.105488',NULL,'2025-11-29 05:38:04.579001',234,234,'1614f03b-ce81-4065-8c20-43bd8048dadd','driver_handles_share_servers','False'),('2025-11-29 05:38:04.106196',NULL,'2025-11-29 05:38:04.579001',235,235,'1614f03b-ce81-4065-8c20-43bd8048dadd','availability_zones','az1,az2,az 3'),('2025-11-29 05:38:04.217730',NULL,'2025-11-29 05:38:04.408075',236,236,'854cedb2-b700-4df2-bff4-b3ed781878b2','driver_handles_share_servers','False'),('2025-11-29 05:38:04.759297',NULL,'2025-11-29 05:38:05.207105',237,237,'953bdb9e-9fbd-4e08-a081-09f1c294d992','driver_handles_share_servers','False'),('2025-11-29 05:38:04.759962',NULL,'2025-11-29 05:38:05.207105',238,238,'953bdb9e-9fbd-4e08-a081-09f1c294d992','availability_zones','az1,az2,az 3'),('2025-11-29 05:38:04.836085',NULL,'2025-11-29 05:38:08.988399',239,239,'3b823b97-f6b7-4e10-a49b-8c78cf594d17','driver_handles_share_servers','False'),('2025-11-29 05:38:04.836469',NULL,'2025-11-29 05:38:08.988399',240,240,'3b823b97-f6b7-4e10-a49b-8c78cf594d17','vendor_name','foobar'),('2025-11-29 05:38:04.838209',NULL,'2025-11-29 05:38:05.041692',241,241,'ef516210-a004-4296-88aa-b83c77e83206','driver_handles_share_servers','False'),('2025-11-29 05:38:05.380737',NULL,'2025-11-29 05:38:05.821726',242,242,'18581132-9c30-4719-95b2-86ff81f212fc','driver_handles_share_servers','False'),('2025-11-29 05:38:05.381265',NULL,'2025-11-29 05:38:05.821726',243,243,'18581132-9c30-4719-95b2-86ff81f212fc','availability_zones','az1,az2,az 3'),('2025-11-29 05:38:05.456378',NULL,'2025-11-29 05:38:05.633128',244,244,'56abb87c-0417-4cce-a2fb-604db166cc44','driver_handles_share_servers','False'),('2025-11-29 05:38:06.051566',NULL,'2025-11-29 05:38:06.423776',245,245,'5bbb86a3-6805-4e6a-9b7b-ad62720bf39a','driver_handles_share_servers','False'),('2025-11-29 05:38:06.052270',NULL,'2025-11-29 05:38:06.423776',246,246,'5bbb86a3-6805-4e6a-9b7b-ad62720bf39a','availability_zones','az1,az2,az 3'),('2025-11-29 05:38:06.130046',NULL,'2025-11-29 05:38:06.279347',247,247,'e026fadd-4008-4932-8180-42f438b12eb0','driver_handles_share_servers','False'),('2025-11-29 05:38:06.611474','2025-11-29 05:38:21.411908','2025-11-29 05:38:43.714517',248,248,'7c6b9483-7c46-438e-a204-efa953929f7b','availability_zones','nova'),('2025-11-29 05:38:27.720195',NULL,'2025-11-29 05:38:51.092625',249,249,'45b75960-3761-478e-bd9e-8a81899d6aa5','driver_handles_share_servers','False'),('2025-11-29 05:38:31.808894',NULL,'2025-11-29 05:38:40.641326',250,250,'52f50bf6-cbc7-4a08-9f56-cebb024fa773','driver_handles_share_servers','False'),('2025-11-29 05:38:49.612748',NULL,'2025-11-29 05:39:05.413525',251,251,'3715bc74-5c5d-42b9-996c-80000d22afc6','driver_handles_share_servers','False'),('2025-11-29 05:38:49.613147',NULL,'2025-11-29 05:39:05.413525',252,252,'3715bc74-5c5d-42b9-996c-80000d22afc6','snapshot_support','True'),('2025-11-29 05:38:54.006697',NULL,'2025-11-29 05:38:58.144476',253,253,'d6d71f4f-03e4-4782-9e86-8f9adabdb6a0','driver_handles_share_servers','False'),('2025-11-29 05:38:56.094833','2025-11-29 05:38:56.729286','2025-11-29 05:38:58.144476',254,254,'d6d71f4f-03e4-4782-9e86-8f9adabdb6a0','availability_zones','az_that_doesnt_exist'),('2025-11-29 05:38:56.194879',NULL,'2025-11-29 05:38:56.392247',255,255,'e3611b8e-87d2-4007-aad2-ee0e15c28e6c','driver_handles_share_servers','False'),('2025-11-29 05:39:01.409945',NULL,'2025-11-29 05:39:13.337575',256,256,'85b2d88e-0dba-4f04-9990-9dd773d71543','driver_handles_share_servers','False'),('2025-11-29 05:39:07.452616',NULL,'2025-11-29 05:40:35.148969',257,257,'c2ed6f66-a14c-4a73-8308-2de1b36a4619','driver_handles_share_servers','False'),('2025-11-29 05:39:08.351832',NULL,'2025-11-29 05:39:24.474412',258,258,'7a4d5f0d-6975-4e09-abb0-f0f03a3782cc','driver_handles_share_servers','False'),('2025-11-29 05:39:08.352363',NULL,'2025-11-29 05:39:24.474412',259,259,'7a4d5f0d-6975-4e09-abb0-f0f03a3782cc','snapshot_support','True'),('2025-11-29 05:39:22.328053',NULL,'2025-11-29 05:40:32.421636',260,260,'f8c8a67f-7464-472c-90a6-c0d7c3ba1b5d','driver_handles_share_servers','False'),('2025-11-29 05:39:31.680614',NULL,'2025-11-29 05:40:05.681905',261,261,'3ea6a207-e62f-4ff8-86d8-a7bd7b74ca3e','driver_handles_share_servers','False'),('2025-11-29 05:39:31.979209',NULL,'2025-11-29 05:40:34.033686',262,262,'8cad685b-b732-4948-9276-cd3f373c0107','driver_handles_share_servers','False'),('2025-11-29 05:39:31.979652',NULL,'2025-11-29 05:40:34.033686',263,263,'8cad685b-b732-4948-9276-cd3f373c0107','snapshot_support','True'),('2025-11-29 05:39:31.980059',NULL,'2025-11-29 05:40:34.033686',264,264,'8cad685b-b732-4948-9276-cd3f373c0107','create_share_from_snapshot_support','True'),('2025-11-29 05:40:16.416317',NULL,'2025-11-29 05:40:18.944138',265,265,'ce6c4a24-575f-417b-994d-5c2e5b436c37','driver_handles_share_servers','False'),('2025-11-29 05:40:16.524528',NULL,'2025-11-29 05:40:18.746154',266,266,'dccf70f8-0d21-4f97-820b-d75252517898','driver_handles_share_servers','False'),('2025-11-29 05:40:28.074041',NULL,'2025-11-29 05:40:44.224558',267,267,'4bfe934f-b148-473c-af17-6b60d08583bb','driver_handles_share_servers','False'),('2025-11-29 05:40:28.074569',NULL,'2025-11-29 05:40:44.224558',268,268,'4bfe934f-b148-473c-af17-6b60d08583bb','snapshot_support','True'),('2025-11-29 05:40:40.748840',NULL,'2025-11-29 05:41:46.289353',269,269,'5dcffc4d-5ae1-4806-beb0-c80557d3ef41','driver_handles_share_servers','False'),('2025-11-29 05:40:43.334479',NULL,'2025-11-29 05:41:39.004007',270,270,'a00ca480-cd9e-41b3-86ae-7b6a6e1f8033','driver_handles_share_servers','False'),('2025-11-29 05:40:43.335081',NULL,'2025-11-29 05:41:39.004007',271,271,'a00ca480-cd9e-41b3-86ae-7b6a6e1f8033','snapshot_support','True'),('2025-11-29 05:40:43.335561',NULL,'2025-11-29 05:41:39.004007',272,272,'a00ca480-cd9e-41b3-86ae-7b6a6e1f8033','create_share_from_snapshot_support','True'),('2025-11-29 05:40:47.761233',NULL,'2025-11-29 05:40:49.137513',273,273,'7472f3d0-129e-49e5-ab4f-9847b049c9eb','driver_handles_share_servers','False'),('2025-11-29 05:40:51.963107',NULL,'2025-11-29 05:41:21.595695',274,274,'deb5e28d-c187-482e-a13e-e6b5c6d26fe5','driver_handles_share_servers','False'),('2025-11-29 05:40:51.963579',NULL,'2025-11-29 05:41:21.595695',275,275,'deb5e28d-c187-482e-a13e-e6b5c6d26fe5','snapshot_support','True'),('2025-11-29 05:40:51.964032',NULL,'2025-11-29 05:41:21.595695',276,276,'deb5e28d-c187-482e-a13e-e6b5c6d26fe5','create_share_from_snapshot_support','True'),('2025-11-29 05:40:57.218737',NULL,'2025-11-29 05:41:01.593924',277,277,'028cf6f9-8b27-4f8c-bedc-5cc3d20fbe1a','driver_handles_share_servers','False'),('2025-11-29 05:41:10.722518',NULL,'2025-11-29 05:41:13.836295',278,278,'a7aee343-48e5-4c3e-ac07-d65799e866cb','driver_handles_share_servers','False'),('2025-11-29 05:41:21.251479',NULL,'2025-11-29 05:43:12.975133',279,279,'b66b9d87-f8e3-4b31-946b-971c6c719cad','driver_handles_share_servers','False'),('2025-11-29 05:41:21.252730',NULL,'2025-11-29 05:43:12.975133',280,280,'b66b9d87-f8e3-4b31-946b-971c6c719cad','snapshot_support','True'),('2025-11-29 05:41:21.253834',NULL,'2025-11-29 05:43:12.975133',281,281,'b66b9d87-f8e3-4b31-946b-971c6c719cad','create_share_from_snapshot_support','True'),('2025-11-29 05:42:12.754884',NULL,'2025-11-29 05:42:16.655712',282,282,'669694ea-0d5e-4c37-8711-ad12b7a1689d','driver_handles_share_servers','False'),('2025-11-29 05:42:24.420479',NULL,'2025-11-29 05:42:25.666023',283,283,'9f35f2d2-ed09-42fe-bbe3-a1614ec55b73','driver_handles_share_servers','False'),('2025-11-29 05:42:31.376105',NULL,'2025-11-29 05:42:33.578238',284,284,'47b04841-cf3b-4b05-b3b1-5ecd31809b01','driver_handles_share_servers','False'),('2025-11-29 05:42:31.439775',NULL,'2025-11-29 05:42:33.452305',285,285,'b1e6b54a-e8d8-4024-a279-3a4a94011dc9','driver_handles_share_servers','False'),('2025-11-29 05:42:31.440178',NULL,'2025-11-29 05:42:33.452305',286,286,'b1e6b54a-e8d8-4024-a279-3a4a94011dc9','provisioning:max_share_size','5'),('2025-11-29 05:42:31.440460',NULL,'2025-11-29 05:42:33.452305',287,287,'b1e6b54a-e8d8-4024-a279-3a4a94011dc9','provisioning:min_share_size','2'),('2025-11-29 05:42:41.861197',NULL,'2025-11-29 05:42:57.008411',288,288,'2aa1bdf2-4191-465c-96d1-d1331c081762','driver_handles_share_servers','False'),('2025-11-29 05:42:41.861566',NULL,'2025-11-29 05:42:57.008411',289,289,'2aa1bdf2-4191-465c-96d1-d1331c081762','snapshot_support','True'),('2025-11-29 05:42:41.861930',NULL,'2025-11-29 05:42:57.008411',290,290,'2aa1bdf2-4191-465c-96d1-d1331c081762','create_share_from_snapshot_support','True'),('2025-11-29 05:43:27.925317',NULL,'2025-11-29 05:44:21.178380',291,291,'1c8161b4-ab6a-46c9-8c73-44780c20ec7e','driver_handles_share_servers','False'),('2025-11-29 05:43:27.925696',NULL,'2025-11-29 05:44:21.178380',292,292,'1c8161b4-ab6a-46c9-8c73-44780c20ec7e','snapshot_support','True');
/*!40000 ALTER TABLE `share_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_type_projects`
--

DROP TABLE IF EXISTS `share_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `stp_project_id_uc` (`share_type_id`,`project_id`,`deleted`),
  CONSTRAINT `stp_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_type_projects`
--

LOCK TABLES `share_type_projects` WRITE;
/*!40000 ALTER TABLE `share_type_projects` DISABLE KEYS */;
INSERT INTO `share_type_projects` (`id`, `created_at`, `updated_at`, `deleted_at`, `share_type_id`, `project_id`, `deleted`) VALUES (1,'2025-11-29 05:37:02.968880',NULL,'2025-11-29 05:37:03.209652','0a94ce00-6edf-4469-83e6-d6e3c0fbd8a2','f5d6fcc020694561b091889318c2561b',1);
/*!40000 ALTER TABLE `share_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_types`
--

DROP TABLE IF EXISTS `share_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_types` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `st_name_uc` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_types`
--

LOCK TABLES `share_types` WRITE;
/*!40000 ALTER TABLE `share_types` DISABLE KEYS */;
INSERT INTO `share_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `is_public`, `description`) VALUES ('2025-11-29 05:40:57.218025',NULL,'2025-11-29 05:41:01.597568','028cf6f9-8b27-4f8c-bedc-5cc3d20fbe1a','028cf6f9-8b27-4f8c-bedc-5cc3d20fbe1a','tempest-typeshare-type-281623889',1,NULL),('2025-11-29 05:34:21.972180',NULL,'2025-11-29 05:35:47.693995','03041fd8-9b14-4a66-8c4c-4377210067b9','03041fd8-9b14-4a66-8c4c-4377210067b9','tempest-typeshare-type-159397494',1,NULL),('2025-11-29 05:36:02.367726',NULL,'2025-11-29 05:36:34.011341','03e2ced0-98dd-40d4-ad9e-7539269b2b2c','03e2ced0-98dd-40d4-ad9e-7539269b2b2c','tempest-share-type-1309385856',1,NULL),('2025-11-29 05:35:07.212811',NULL,'2025-11-29 05:35:43.955937','078baedb-e7c7-47ca-9eae-f6d4445bee40','078baedb-e7c7-47ca-9eae-f6d4445bee40','tempest-typeshare-type-765458322',1,NULL),('2025-11-29 05:37:31.201077',NULL,'2025-11-29 05:37:37.809200','07f9013e-e913-47bc-98db-7017fbb633f7','07f9013e-e913-47bc-98db-7017fbb633f7','tempest-typeshare-type-1320759849',1,NULL),('2025-11-29 05:36:41.018714',NULL,'2025-11-29 05:36:45.798028','08417f79-12b9-443c-b0b1-2da4fb93c828','08417f79-12b9-443c-b0b1-2da4fb93c828','tempest-typeshare-type-312081834',1,NULL),('2025-11-29 05:37:02.545213',NULL,'2025-11-29 05:37:17.654331','0a94ce00-6edf-4469-83e6-d6e3c0fbd8a2','0a94ce00-6edf-4469-83e6-d6e3c0fbd8a2','tempest-tempest-manila-872118251',0,NULL),('2025-11-29 05:34:44.485572',NULL,'2025-11-29 05:34:45.020140','0f35da37-2bfc-4e3e-aa33-b1633a22961d','0f35da37-2bfc-4e3e-aa33-b1633a22961d','tempest-share-type-1297827018',1,NULL),('2025-11-29 05:37:02.555607',NULL,'2025-11-29 05:37:12.553767','12e06c28-78cd-4240-8800-3060cf711953','12e06c28-78cd-4240-8800-3060cf711953','tempest-typeshare-type-1927093258',1,NULL),('2025-11-29 05:37:08.087010','2025-11-29 05:37:08.169583','2025-11-29 05:37:12.101943','12f6fd42-008e-43a2-a67a-0eadebaaa635','12f6fd42-008e-43a2-a67a-0eadebaaa635','tempest-tempest-manila-1257261250',0,'Description for share type'),('2025-11-29 05:37:34.414828',NULL,'2025-11-29 05:37:35.657533','1438be9d-b9dc-4616-97e2-fb540616d7b4','1438be9d-b9dc-4616-97e2-fb540616d7b4','tempest-typeshare-type-1358622549',1,NULL),('2025-11-29 05:37:35.430832',NULL,'2025-11-29 05:37:53.048370','15c7aea3-577a-4acc-8a07-1d147dd95e25','15c7aea3-577a-4acc-8a07-1d147dd95e25','tempest-typeshare-type-973573645',1,NULL),('2025-11-29 05:38:04.104283',NULL,'2025-11-29 05:38:04.582087','1614f03b-ce81-4065-8c20-43bd8048dadd','1614f03b-ce81-4065-8c20-43bd8048dadd','tempest-support_some_azs_share_type-356221500',1,NULL),('2025-11-29 05:38:05.379763',NULL,'2025-11-29 05:38:05.825297','18581132-9c30-4719-95b2-86ff81f212fc','18581132-9c30-4719-95b2-86ff81f212fc','tempest-support_some_azs_share_type-504004576',1,NULL),('2025-11-29 05:35:13.154033',NULL,'2025-11-29 05:35:13.897510','1891d124-55e3-4f6a-9827-e2d9c4231a7c','1891d124-55e3-4f6a-9827-e2d9c4231a7c','tempest-unique_st_name-1658006616',1,NULL),('2025-11-29 05:35:12.293566',NULL,'2025-11-29 05:35:14.640260','1a1a3c92-2b1b-4bc0-9147-3c9cd48aa184','1a1a3c92-2b1b-4bc0-9147-3c9cd48aa184','tempest-typeshare-type-1752323907',1,NULL),('2025-11-29 05:37:05.453077',NULL,'2025-11-29 05:37:14.765117','1bfeb996-28af-4078-aa59-0bf0ceb378e9','1bfeb996-28af-4078-aa59-0bf0ceb378e9','tempest-tempest-manila-1222673746',1,NULL),('2025-11-29 05:43:27.924506',NULL,'2025-11-29 05:44:21.184374','1c8161b4-ab6a-46c9-8c73-44780c20ec7e','1c8161b4-ab6a-46c9-8c73-44780c20ec7e','tempest-typeshare-type-1605465302',1,NULL),('2025-11-29 05:37:47.798519',NULL,'2025-11-29 05:38:09.772708','1d21dac2-ed08-46ff-8c64-215bda949560','1d21dac2-ed08-46ff-8c64-215bda949560','tempest-share-type-897392759',1,NULL),('2025-11-29 05:34:59.092743',NULL,'2025-11-29 05:34:59.671893','1e97fc20-9eb6-4ad3-b670-687d961d20e5','1e97fc20-9eb6-4ad3-b670-687d961d20e5','tempest-tempest-manila-96882748',0,NULL),('2025-11-29 05:36:27.464009',NULL,'2025-11-29 05:36:54.386874','1f1645da-a938-4300-adbc-b0962ae574cd','1f1645da-a938-4300-adbc-b0962ae574cd','tempest-typeshare-type-709403708',1,NULL),('2025-11-29 05:35:39.990537',NULL,'2025-11-29 05:36:32.597623','205bf72e-a1ad-4135-9618-25977b47af59','205bf72e-a1ad-4135-9618-25977b47af59','tempest-typeshare-type-1992126535',1,NULL),('2025-11-29 05:34:24.630257',NULL,'2025-11-29 05:34:34.953263','235d3753-6144-4b29-b569-50b44a6b7188','235d3753-6144-4b29-b569-50b44a6b7188','tempest-typeshare-type-2028312299',1,NULL),('2025-11-29 05:37:33.505690',NULL,'2025-11-29 05:37:36.390411','26e0b4b9-ae7e-49f3-b396-cd7e53677219','26e0b4b9-ae7e-49f3-b396-cd7e53677219','tempest-typeshare-type-1443293393',1,NULL),('2025-11-29 05:37:18.920021',NULL,NULL,'False','27ce7e9e-5dd7-42c3-997a-123357081bf4','tempest-typeshare-type-1140042029',1,NULL),('2025-11-29 05:42:41.860353',NULL,'2025-11-29 05:42:57.010632','2aa1bdf2-4191-465c-96d1-d1331c081762','2aa1bdf2-4191-465c-96d1-d1331c081762','tempest-typeshare-type-37617521',1,NULL),('2025-11-29 05:34:55.797334',NULL,'2025-11-29 05:34:56.371296','2ecdef7c-7b16-4188-b6be-4acc493f1f4f','2ecdef7c-7b16-4188-b6be-4acc493f1f4f','tempest-typeshare-type-1810085840',1,NULL),('2025-11-29 05:36:54.736605',NULL,'2025-11-29 05:37:09.795115','31306647-5051-4d12-8b50-7a96c707889c','31306647-5051-4d12-8b50-7a96c707889c','tempest-typeshare-type-1459529589',1,NULL),('2025-11-29 05:37:29.768949',NULL,'2025-11-29 05:37:38.777461','33c57203-b161-4bdd-9d91-70c3c1341bbe','33c57203-b161-4bdd-9d91-70c3c1341bbe','tempest-typeshare-type-543915246',1,NULL),('2025-11-29 05:37:08.242771','2025-11-29 05:37:08.348699','2025-11-29 05:37:11.857954','3468c15b-11c1-49f4-9647-c8ccf5adbd98','3468c15b-11c1-49f4-9647-c8ccf5adbd98','tempest-type_updated-1698004844',1,'description_updated'),('2025-11-29 05:38:49.612030',NULL,'2025-11-29 05:39:05.416570','3715bc74-5c5d-42b9-996c-80000d22afc6','3715bc74-5c5d-42b9-996c-80000d22afc6','tempest-typeshare-type-685746920',1,NULL),('2025-11-29 05:38:04.835353',NULL,'2025-11-29 05:38:08.991005','3b823b97-f6b7-4e10-a49b-8c78cf594d17','3b823b97-f6b7-4e10-a49b-8c78cf594d17','tempest-share-type-1976402662',1,NULL),('2025-11-29 05:37:40.937669',NULL,'2025-11-29 05:37:41.265386','3cab68ce-7acf-4a07-b1f9-2a83ccfa3131','3cab68ce-7acf-4a07-b1f9-2a83ccfa3131','tempest-share-type-734056347',1,NULL),('2025-11-29 05:37:17.053882',NULL,'2025-11-29 05:37:37.245582','3cde5f7b-914b-4874-be2f-d7385fe4a149','3cde5f7b-914b-4874-be2f-d7385fe4a149','tempest-typeshare-type-1343285669',1,NULL),('2025-11-29 05:34:57.512648',NULL,'2025-11-29 05:34:59.807099','3d5e9db7-0995-4bae-bc97-f337b26e5da3','3d5e9db7-0995-4bae-bc97-f337b26e5da3','tempest-typeshare-type-1079725927',1,NULL),('2025-11-29 05:36:37.724941',NULL,'2025-11-29 05:36:45.963365','3e606a05-b7bc-41c7-ae90-55a4b27d22df','3e606a05-b7bc-41c7-ae90-55a4b27d22df','tempest-typeshare-type-1063440201',1,NULL),('2025-11-29 05:37:56.650310',NULL,'2025-11-29 05:38:09.377712','3e7b666b-a9bd-4c69-8060-6813139fdc67','3e7b666b-a9bd-4c69-8060-6813139fdc67','tempest-share-type-7502074',1,NULL),('2025-11-29 05:39:31.679570',NULL,'2025-11-29 05:40:05.689254','3ea6a207-e62f-4ff8-86d8-a7bd7b74ca3e','3ea6a207-e62f-4ff8-86d8-a7bd7b74ca3e','tempest-typeshare-type-511353815',1,NULL),('2025-11-29 05:37:03.610189',NULL,'2025-11-29 05:37:03.701244','3f8c5edd-6e80-409c-96a2-becf9dd5c296','3f8c5edd-6e80-409c-96a2-becf9dd5c296','tempest-tempest-manila-1593992346',1,NULL),('2025-11-29 05:37:52.399167',NULL,'2025-11-29 05:38:09.581842','407c3566-cec9-4eac-baeb-e009fd1528f3','407c3566-cec9-4eac-baeb-e009fd1528f3','tempest-share-type-800284630',1,NULL),('2025-11-29 05:37:06.410937',NULL,'2025-11-29 05:37:13.546516','41c22681-a9fb-48fa-af53-18deca6690dd','41c22681-a9fb-48fa-af53-18deca6690dd','tempest-tempest-manila-1018492195',1,NULL),('2025-11-29 05:37:07.203959','2025-11-29 05:37:07.531345','2025-11-29 05:37:12.662758','45a44b28-407f-49e1-94b4-3aa806857a8f','45a44b28-407f-49e1-94b4-3aa806857a8f','tempest-type_updated-1443039303',1,'Description for share type'),('2025-11-29 05:38:27.718487',NULL,'2025-11-29 05:38:51.095886','45b75960-3761-478e-bd9e-8a81899d6aa5','45b75960-3761-478e-bd9e-8a81899d6aa5','tempest-typeshare-type-710974732',1,NULL),('2025-11-29 05:42:31.375329',NULL,'2025-11-29 05:42:33.580456','47b04841-cf3b-4b05-b3b1-5ecd31809b01','47b04841-cf3b-4b05-b3b1-5ecd31809b01','tempest-typeshare-type-59419887',1,NULL),('2025-11-29 05:34:42.899920',NULL,'2025-11-29 05:34:45.428660','4888d699-d3d0-4dce-9ab9-a3a7d244180b','4888d699-d3d0-4dce-9ab9-a3a7d244180b','tempest-share-type-2092657217',1,NULL),('2025-11-29 05:40:28.072950',NULL,'2025-11-29 05:40:44.227923','4bfe934f-b148-473c-af17-6b60d08583bb','4bfe934f-b148-473c-af17-6b60d08583bb','tempest-typeshare-type-5414500',1,NULL),('2025-11-29 05:36:43.298370',NULL,'2025-11-29 05:36:44.830300','4ff0bf30-dcf1-4c70-80fa-1a9c2f842719','4ff0bf30-dcf1-4c70-80fa-1a9c2f842719','tempest-typeshare-type-1535371351',1,NULL),('2025-11-29 05:35:35.590045',NULL,'2025-11-29 05:35:42.521502','50662731-2f67-4824-83cd-c8da89fb4e2c','50662731-2f67-4824-83cd-c8da89fb4e2c','tempest-typeshare-type-281019841',1,NULL),('2025-11-29 05:37:31.936923',NULL,'2025-11-29 05:37:37.264832','50d99d61-82c8-42c5-a349-6ee3a2bafba3','50d99d61-82c8-42c5-a349-6ee3a2bafba3','tempest-typeshare-type-381126888',1,NULL),('2025-11-29 05:37:09.136304','2025-11-29 05:37:09.295668','2025-11-29 05:37:10.782923','51632af3-9236-44a1-b4b1-cccc135e79bc','51632af3-9236-44a1-b4b1-cccc135e79bc','tempest-tempest-manila-1332672081',0,'Description for share type'),('2025-11-29 05:37:08.558342','2025-11-29 05:37:08.649485','2025-11-29 05:37:11.504020','517c09d5-2c2f-4050-8078-855228d485ef','517c09d5-2c2f-4050-8078-855228d485ef','tempest-type_updated-1771292866',1,'Description for share type'),('2025-11-29 05:37:33.364480',NULL,'2025-11-29 05:37:36.533737','5229c382-a25d-4ac5-9d9e-543a5f776b1a','5229c382-a25d-4ac5-9d9e-543a5f776b1a','tempest-typeshare-type-1035134559',1,NULL),('2025-11-29 05:38:31.808178',NULL,'2025-11-29 05:38:40.647717','52f50bf6-cbc7-4a08-9f56-cebb024fa773','52f50bf6-cbc7-4a08-9f56-cebb024fa773','tempest-typeshare-type-978813514',1,NULL),('2025-11-29 05:38:05.455620',NULL,'2025-11-29 05:38:05.635985','56abb87c-0417-4cce-a2fb-604db166cc44','56abb87c-0417-4cce-a2fb-604db166cc44','tempest-support_any_az_share_type-144417095',1,NULL),('2025-11-29 05:35:26.339494',NULL,'2025-11-29 05:35:43.270346','57140e21-36a1-4c7c-919e-55548c6b7f73','57140e21-36a1-4c7c-919e-55548c6b7f73','tempest-typeshare-type-1294744714',0,NULL),('2025-11-29 05:35:53.657525',NULL,'2025-11-29 05:36:06.055956','57502de6-1e0c-41d0-84e3-fe1b0b8839c8','57502de6-1e0c-41d0-84e3-fe1b0b8839c8','tempest-typeshare-type-320475943',1,NULL),('2025-11-29 05:38:06.050592',NULL,'2025-11-29 05:38:06.425928','5bbb86a3-6805-4e6a-9b7b-ad62720bf39a','5bbb86a3-6805-4e6a-9b7b-ad62720bf39a','tempest-support_some_azs_share_type-246512291',1,NULL),('2025-11-29 05:40:40.748082',NULL,'2025-11-29 05:41:46.291453','5dcffc4d-5ae1-4806-beb0-c80557d3ef41','5dcffc4d-5ae1-4806-beb0-c80557d3ef41','tempest-typeshare-type-1089816538',1,NULL),('2025-11-29 05:37:30.411910',NULL,'2025-11-29 05:37:38.281772','60811434-bd50-4e5c-98d4-3f78127c4ca8','60811434-bd50-4e5c-98d4-3f78127c4ca8','tempest-typeshare-type-823249368',1,NULL),('2025-11-29 05:35:13.285931',NULL,'2025-11-29 05:35:13.752297','61828dc9-a0cc-42f7-a4c5-d6f6197e0e01','61828dc9-a0cc-42f7-a4c5-d6f6197e0e01','tempest-unique_st_name-1561172398',1,NULL),('2025-11-29 05:35:58.860485',NULL,'2025-11-29 05:36:34.357921','62dda89e-c74f-4ef4-9255-9731f4924d04','62dda89e-c74f-4ef4-9255-9731f4924d04','tempest-share-type-1751610554',1,NULL),('2025-11-29 05:35:33.120244',NULL,'2025-11-29 05:35:42.924873','634aa3ee-1b2b-440c-89ae-4360075d13d4','634aa3ee-1b2b-440c-89ae-4360075d13d4','tempest-typeshare-type-952843712',1,NULL),('2025-11-29 05:36:14.272455',NULL,'2025-11-29 05:36:32.356748','644aee24-dced-4b70-b164-4e0bd00ebe5c','644aee24-dced-4b70-b164-4e0bd00ebe5c','tempest-share-type-1937154806',1,NULL),('2025-11-29 05:37:06.130482',NULL,'2025-11-29 05:37:13.965220','66703129-7091-448f-af6c-18587b9a0a19','66703129-7091-448f-af6c-18587b9a0a19','tempest-tempest-manila-1148607097',1,NULL),('2025-11-29 05:42:12.753939',NULL,'2025-11-29 05:42:16.658519','669694ea-0d5e-4c37-8711-ad12b7a1689d','669694ea-0d5e-4c37-8711-ad12b7a1689d','tempest-typeshare-type-747214311',1,NULL),('2025-11-29 05:36:35.533410',NULL,'2025-11-29 05:36:47.153360','676e0f63-bc7a-4538-a2e3-14bf97d2ac48','676e0f63-bc7a-4538-a2e3-14bf97d2ac48','tempest-typeshare-type-1223334950',1,NULL),('2025-11-29 05:37:30.760071',NULL,'2025-11-29 05:37:38.106181','68963864-0ad6-4f45-be82-9ace44a74d80','68963864-0ad6-4f45-be82-9ace44a74d80','tempest-typeshare-type-1681538304',1,NULL),('2025-11-29 05:37:31.309865',NULL,'2025-11-29 05:37:37.522154','6bfbefe6-351a-403d-9283-7e85f26b8a0f','6bfbefe6-351a-403d-9283-7e85f26b8a0f','tempest-typeshare-type-581484896',1,NULL),('2025-11-29 05:37:09.386064','2025-11-29 05:37:09.473615','2025-11-29 05:37:10.347348','6fbb3f3f-2d4c-4525-b719-7de2e95abb5d','6fbb3f3f-2d4c-4525-b719-7de2e95abb5d','tempest-tempest-manila-1880206721',1,NULL),('2025-11-29 05:34:58.476480',NULL,'2025-11-29 05:34:58.924342','70481861-20b5-40bf-a4cc-b220736dca32','70481861-20b5-40bf-a4cc-b220736dca32','tempest-tempest-manila-1340072276',1,NULL),('2025-11-29 05:36:36.009202',NULL,'2025-11-29 05:36:46.679356','70dc350e-c5fc-4249-8dc1-5e12fa9b8058','70dc350e-c5fc-4249-8dc1-5e12fa9b8058','tempest-typeshare-type-1309634877',1,NULL),('2025-11-29 05:35:34.479560',NULL,'2025-11-29 05:35:42.698906','73518200-bf68-4245-825c-570887a53b76','73518200-bf68-4245-825c-570887a53b76','tempest-typeshare-type-263225448',0,NULL),('2025-11-29 05:38:03.468867',NULL,'2025-11-29 05:38:03.976676','737a3d79-4bf6-4732-9515-9720936aa501','737a3d79-4bf6-4732-9515-9720936aa501','tempest-support_some_azs_share_type-2014129862',1,NULL),('2025-11-29 05:40:47.760502',NULL,'2025-11-29 05:40:49.139592','7472f3d0-129e-49e5-ab4f-9847b049c9eb','7472f3d0-129e-49e5-ab4f-9847b049c9eb','tempest-typeshare-type-1662740639',1,NULL),('2025-11-29 05:37:34.225573',NULL,'2025-11-29 05:37:35.809193','77179889-b2ec-42c9-bc48-393fc79ae3a1','77179889-b2ec-42c9-bc48-393fc79ae3a1','tempest-typeshare-type-1490808135',1,NULL),('2025-11-29 05:35:54.827597',NULL,'2025-11-29 05:36:34.550662','77e59b2f-3ee6-4ed4-b09e-dedd3f47a51b','77e59b2f-3ee6-4ed4-b09e-dedd3f47a51b','tempest-share-type-1550249786',1,NULL),('2025-11-29 05:35:07.045014',NULL,'2025-11-29 05:35:44.296619','78a90e40-d5c8-4771-9de6-c085b16e4fa4','78a90e40-d5c8-4771-9de6-c085b16e4fa4','tempest-typeshare-type-1578480386',1,NULL),('2025-11-29 05:39:08.350746',NULL,'2025-11-29 05:39:24.478312','7a4d5f0d-6975-4e09-abb0-f0f03a3782cc','7a4d5f0d-6975-4e09-abb0-f0f03a3782cc','tempest-typeshare-type-1401770975',1,NULL),('2025-11-29 05:37:34.079438',NULL,'2025-11-29 05:37:36.007205','7b82d01d-c515-46e2-b74e-df897634d2a8','7b82d01d-c515-46e2-b74e-df897634d2a8','tempest-typeshare-type-1162466987',1,NULL),('2025-11-29 05:38:01.291986',NULL,'2025-11-29 05:38:43.719196','7c6b9483-7c46-438e-a204-efa953929f7b','7c6b9483-7c46-438e-a204-efa953929f7b','tempest-typeshare-type-863614516',1,NULL),('2025-11-29 05:37:04.978569',NULL,'2025-11-29 05:37:15.360267','7c701cc2-0ef9-48eb-8377-20f751aec481','7c701cc2-0ef9-48eb-8377-20f751aec481','tempest-tempest-manila-887433098',1,NULL),('2025-11-29 05:36:27.475899',NULL,'2025-11-29 05:36:31.780407','7d4fb520-be4b-4ab9-a6cf-8d815f406791','7d4fb520-be4b-4ab9-a6cf-8d815f406791','tempest-share-type-1061033795',1,NULL),('2025-11-29 05:34:36.008641',NULL,'2025-11-29 05:34:47.864696','7e5bc69e-c8de-413a-a484-248ded56b5e3','7e5bc69e-c8de-413a-a484-248ded56b5e3','tempest-typeshare-type-929904847',1,NULL),('2025-11-29 05:36:35.372593',NULL,'2025-11-29 05:36:51.817634','7f2792d4-06d9-4366-b057-6d917cc2fefa','7f2792d4-06d9-4366-b057-6d917cc2fefa','tempest-typeshare-type-1390845014',1,NULL),('2025-11-29 05:35:58.610651',NULL,'2025-11-29 05:36:06.057899','80792ca9-8a81-49c4-baba-8e68998249cb','80792ca9-8a81-49c4-baba-8e68998249cb','tempest-typeshare-type-1293505862',1,NULL),('2025-11-29 05:36:58.434553',NULL,'2025-11-29 05:37:21.762814','819b63e0-5000-4547-bb28-596952ee3776','819b63e0-5000-4547-bb28-596952ee3776','tempest-share-type-356207321',1,NULL),('2025-11-29 05:35:12.968004',NULL,'2025-11-29 05:35:14.041979','81b7be42-7b8b-456f-95d1-8a24415809e2','81b7be42-7b8b-456f-95d1-8a24415809e2','tempest-unique_st_name-683714647',1,NULL),('2025-11-29 05:36:22.835973',NULL,'2025-11-29 05:36:31.911326','83704507-2af4-41ec-bd6a-c7c15772addd','83704507-2af4-41ec-bd6a-c7c15772addd','tempest-share-type-1033830903',1,NULL),('2025-11-29 05:38:04.216360',NULL,'2025-11-29 05:38:04.411416','854cedb2-b700-4df2-bff4-b3ed781878b2','854cedb2-b700-4df2-bff4-b3ed781878b2','tempest-support_any_az_share_type-569384469',1,NULL),('2025-11-29 05:39:01.409259',NULL,'2025-11-29 05:39:13.339643','85b2d88e-0dba-4f04-9990-9dd773d71543','85b2d88e-0dba-4f04-9990-9dd773d71543','tempest-typeshare-type-1920890855',1,NULL),('2025-11-29 05:34:42.118628',NULL,'2025-11-29 05:34:45.613934','88a7fedf-27a8-45d8-b511-c27a770050bb','88a7fedf-27a8-45d8-b511-c27a770050bb','tempest-share-type-1466767525',1,NULL),('2025-11-29 05:35:07.091030',NULL,'2025-11-29 05:35:39.708722','897b7777-bc91-41a3-a0ae-0cc41ffc72f9','897b7777-bc91-41a3-a0ae-0cc41ffc72f9','tempest-typeshare-type-510538144',1,NULL),('2025-11-29 05:34:52.961210',NULL,'2025-11-29 05:34:57.235417','8ada48ed-e577-42d6-b8f2-17192dd4a5c2','8ada48ed-e577-42d6-b8f2-17192dd4a5c2','tempest-typeshare-type-555428165',1,NULL),('2025-11-29 05:37:05.757587',NULL,'2025-11-29 05:37:14.176187','8b06e397-199b-4e6c-ac50-bf38614972d4','8b06e397-199b-4e6c-ac50-bf38614972d4','tempest-tempest-manila-2008159903',1,'Description for share type'),('2025-11-29 05:39:31.978464',NULL,'2025-11-29 05:40:34.037615','8cad685b-b732-4948-9276-cd3f373c0107','8cad685b-b732-4948-9276-cd3f373c0107','tempest-typeshare-type-997952431',1,NULL),('2025-11-29 05:37:30.127897',NULL,'2025-11-29 05:37:38.565553','911db201-237b-4c1b-b02d-aa0ec6c9af33','911db201-237b-4c1b-b02d-aa0ec6c9af33','tempest-typeshare-type-633501412',1,NULL),('2025-11-29 05:37:33.737412',NULL,'2025-11-29 05:37:36.254326','92060af6-afdc-4cef-801f-7698963773bd','92060af6-afdc-4cef-801f-7698963773bd','tempest-typeshare-type-189679933',1,NULL),('2025-11-29 05:35:12.622017',NULL,'2025-11-29 05:35:14.332181','92d00e41-03bf-4f17-b9b4-b17dc4c30a08','92d00e41-03bf-4f17-b9b4-b17dc4c30a08','tempest-typeshare-type-901833647',1,NULL),('2025-11-29 05:38:04.758459',NULL,'2025-11-29 05:38:05.210175','953bdb9e-9fbd-4e08-a081-09f1c294d992','953bdb9e-9fbd-4e08-a081-09f1c294d992','tempest-support_some_azs_share_type-2048104822',1,NULL),('2025-11-29 05:37:04.407768',NULL,'2025-11-29 05:37:16.641028','959482fa-bb5c-4ff1-8485-d7be153c32c4','959482fa-bb5c-4ff1-8485-d7be153c32c4','tempest-tempest-manila-1967785023',1,NULL),('2025-11-29 05:37:32.415318',NULL,'2025-11-29 05:37:37.108806','9868fd9a-d2e8-437e-ba55-da7d374609d0','9868fd9a-d2e8-437e-ba55-da7d374609d0','tempest-typeshare-type-1970186114',1,NULL),('2025-11-29 05:34:41.361904',NULL,'2025-11-29 05:34:45.758529','9cfb531b-9501-41df-a9d8-ef94d64a878d','9cfb531b-9501-41df-a9d8-ef94d64a878d','tempest-share-type-782456179',1,NULL),('2025-11-29 05:37:54.965239',NULL,'2025-11-29 05:38:21.200923','9d07efed-6109-49c2-afdb-237feef528bc','9d07efed-6109-49c2-afdb-237feef528bc','tempest-typeshare-type-1608332127',1,NULL),('2025-11-29 05:42:24.419324',NULL,'2025-11-29 05:42:25.668959','9f35f2d2-ed09-42fe-bbe3-a1614ec55b73','9f35f2d2-ed09-42fe-bbe3-a1614ec55b73','tempest-typeshare-type-1981157526',1,NULL),('2025-11-29 05:40:43.333623',NULL,'2025-11-29 05:41:39.009375','a00ca480-cd9e-41b3-86ae-7b6a6e1f8033','a00ca480-cd9e-41b3-86ae-7b6a6e1f8033','tempest-typeshare-type-155774256',1,NULL),('2025-11-29 05:37:06.972783','2025-11-29 05:37:07.118293','2025-11-29 05:37:12.952156','a0b3dd9c-fb15-4f80-acf1-c2f9063cdef2','a0b3dd9c-fb15-4f80-acf1-c2f9063cdef2','tempest-type_updated-1793784426',1,'description_updated'),('2025-11-29 05:37:29.429777',NULL,'2025-11-29 05:37:38.904097','a19f58d0-cdad-496a-b25c-606ab0b556f8','a19f58d0-cdad-496a-b25c-606ab0b556f8','tempest-typeshare-type-1312668631',1,NULL),('2025-11-29 05:38:01.683547',NULL,'2025-11-29 05:38:01.820122','a5274d0e-2afa-4865-98e4-857b30a4da0c','a5274d0e-2afa-4865-98e4-857b30a4da0c','tempest-az_share_type-1615026590',1,NULL),('2025-11-29 05:36:19.064240',NULL,'2025-11-29 05:36:32.179111','a681e9d5-0cbf-4919-9306-45c3663a2e71','a681e9d5-0cbf-4919-9306-45c3663a2e71','tempest-share-type-483487429',1,NULL),('2025-11-29 05:41:10.721828',NULL,'2025-11-29 05:41:13.841005','a7aee343-48e5-4c3e-ac07-d65799e866cb','a7aee343-48e5-4c3e-ac07-d65799e866cb','tempest-typeshare-type-442305871',1,NULL),('2025-11-29 05:37:09.570126','2025-11-29 05:37:09.782027','2025-11-29 05:37:10.138846','a8fc1c49-566d-48eb-a223-6242c7f2de6e','a8fc1c49-566d-48eb-a223-6242c7f2de6e','tempest-tempest-manila-1779471627',1,NULL),('2025-11-29 05:36:37.388714',NULL,'2025-11-29 05:36:46.471380','aa3b563c-a35c-4a81-9bd2-51ec16a5751b','aa3b563c-a35c-4a81-9bd2-51ec16a5751b','tempest-typeshare-type-1666719404',1,NULL),('2025-11-29 05:34:54.213907',NULL,'2025-11-29 05:34:56.816881','ad222399-2df4-48f7-8b9c-5a013a802232','ad222399-2df4-48f7-8b9c-5a013a802232','tempest-share-type-1380431028',0,NULL),('2025-11-29 05:38:02.386490',NULL,'2025-11-29 05:38:02.528518','ad3225f7-e126-4f33-8824-bfbc4602bebe','ad3225f7-e126-4f33-8824-bfbc4602bebe','tempest-az_share_type-432228477',1,NULL),('2025-11-29 05:37:05.608334',NULL,'2025-11-29 05:37:14.392221','ad76df29-c304-44fd-836c-c11262b59753','ad76df29-c304-44fd-836c-c11262b59753','tempest-tempest-manila-134071128',1,NULL),('2025-11-29 05:36:44.089614',NULL,'2025-11-29 05:36:44.643356','afa96037-2144-4f7b-894f-287a77ed7458','afa96037-2144-4f7b-894f-287a77ed7458','tempest-typeshare-type-1495238334',1,NULL),('2025-11-29 05:37:30.280345',NULL,'2025-11-29 05:37:38.423461','b0c24e9e-99ec-4458-a7a2-f624fe298a78','b0c24e9e-99ec-4458-a7a2-f624fe298a78','tempest-typeshare-type-23821086',1,NULL),('2025-11-29 05:42:31.438963',NULL,'2025-11-29 05:42:33.455289','b1e6b54a-e8d8-4024-a279-3a4a94011dc9','b1e6b54a-e8d8-4024-a279-3a4a94011dc9','tempest-typeshare-type-1375892099',1,NULL),('2025-11-29 05:38:02.754710',NULL,'2025-11-29 05:38:03.041188','b24628d5-2fc2-4bcc-99cf-36bb7fddb26e','b24628d5-2fc2-4bcc-99cf-36bb7fddb26e','tempest-support_any_az_share_type-1766173883',1,NULL),('2025-11-29 05:36:41.637680',NULL,'2025-11-29 05:36:45.398112','b5a23694-d3f1-44c1-b325-c0154d6a4d6f','b5a23694-d3f1-44c1-b325-c0154d6a4d6f','tempest-typeshare-type-88224847',1,NULL),('2025-11-29 05:36:37.568602',NULL,'2025-11-29 05:36:46.269001','b610f981-caae-442d-992f-d3070669256d','b610f981-caae-442d-992f-d3070669256d','tempest-typeshare-type-665771241',1,NULL),('2025-11-29 05:35:13.463254',NULL,'2025-11-29 05:35:13.605898','b652a17e-4afa-4a55-934d-3ad510cd71a0','b652a17e-4afa-4a55-934d-3ad510cd71a0','tempest-unique_st_name-541098409',1,NULL),('2025-11-29 05:41:21.250564',NULL,'2025-11-29 05:43:12.977473','b66b9d87-f8e3-4b31-946b-971c6c719cad','b66b9d87-f8e3-4b31-946b-971c6c719cad','tempest-typeshare-type-1496480906',1,NULL),('2025-11-29 05:36:35.825502',NULL,'2025-11-29 05:36:46.939737','b8bbc10e-bbfb-4007-ae24-0c9ba2e1639a','b8bbc10e-bbfb-4007-ae24-0c9ba2e1639a','tempest-typeshare-type-1998842524',1,NULL),('2025-11-29 05:36:10.561770',NULL,'2025-11-29 05:36:33.257983','bb4c2cdc-b39c-4d8f-a756-4b5a9da20637','bb4c2cdc-b39c-4d8f-a756-4b5a9da20637','tempest-share-type-1415286575',1,NULL),('2025-11-29 05:37:04.584089',NULL,'2025-11-29 05:37:16.023746','bb9a5358-bb7c-4ade-98f2-417d2eb33b1c','bb9a5358-bb7c-4ade-98f2-417d2eb33b1c','tempest-tempest-manila-991058782',1,NULL),('2025-11-29 05:36:41.281484',NULL,'2025-11-29 05:36:45.663445','beb732ef-f722-4528-ab93-98a32dedc8e2','beb732ef-f722-4528-ab93-98a32dedc8e2','tempest-typeshare-type-968555883',1,NULL),('2025-11-29 05:38:00.829122',NULL,'2025-11-29 05:38:09.145094','bfcc714f-2a94-4cb0-9045-624924898779','bfcc714f-2a94-4cb0-9045-624924898779','tempest-share-type-2007254623',1,NULL),('2025-11-29 05:37:04.199562',NULL,'2025-11-29 05:37:16.911495','c2c0ada2-9e75-4f07-bd00-292376096739','c2c0ada2-9e75-4f07-bd00-292376096739','tempest-tempest-manila-584357006',1,NULL),('2025-11-29 05:39:07.451707',NULL,'2025-11-29 05:40:35.151038','c2ed6f66-a14c-4a73-8308-2de1b36a4619','c2ed6f66-a14c-4a73-8308-2de1b36a4619','tempest-typeshare-type-547910664',1,NULL),('2025-11-29 05:38:03.555354',NULL,'2025-11-29 05:38:03.772967','c3151f22-dbee-41ae-9395-c74fbac49369','c3151f22-dbee-41ae-9395-c74fbac49369','tempest-support_any_az_share_type-2131147055',1,NULL),('2025-11-29 05:37:06.652673',NULL,'2025-11-29 05:37:13.230161','c4983168-d9e2-4eb9-8d11-0d2417167825','c4983168-d9e2-4eb9-8d11-0d2417167825','tempest-tempest-manila-1911254079',1,NULL),('2025-11-29 05:35:12.459814',NULL,'2025-11-29 05:35:14.482343','c536263c-2a56-4348-843a-3f25566caf35','c536263c-2a56-4348-843a-3f25566caf35','tempest-typeshare-type-1080069779',1,NULL),('2025-11-29 05:37:08.899731','2025-11-29 05:37:08.973050','2025-11-29 05:37:11.098560','cd0b094d-bad5-4186-a8fc-49ed1935e0f1','cd0b094d-bad5-4186-a8fc-49ed1935e0f1','tempest-tempest-manila-189843714',1,'Description for share type'),('2025-11-29 05:37:33.072822',NULL,'2025-11-29 05:37:36.736255','cdc01aac-3c5d-4549-a04e-9a2ec886678b','cdc01aac-3c5d-4549-a04e-9a2ec886678b','tempest-typeshare-type-541819274',1,NULL),('2025-11-29 05:40:16.415029',NULL,'2025-11-29 05:40:18.948938','ce6c4a24-575f-417b-994d-5c2e5b436c37','ce6c4a24-575f-417b-994d-5c2e5b436c37','tempest-typeshare-type-332998025',1,NULL),('2025-11-29 05:37:21.296156',NULL,'2025-11-29 05:37:25.238547','cfdf202d-2b58-4af2-9d24-20184b232286','cfdf202d-2b58-4af2-9d24-20184b232286','tempest-typeshare-type-1494554881',1,NULL),('2025-11-29 05:35:12.779158',NULL,'2025-11-29 05:35:14.199915','d00d1dd8-87b1-416a-aa89-8dafbd1c2c64','d00d1dd8-87b1-416a-aa89-8dafbd1c2c64','tempest-typeshare-type-109218272',1,NULL),('2025-11-29 05:37:34.759629',NULL,'2025-11-29 05:37:35.457126','d1b6fdd3-2c14-4af6-b1fb-b555150c2a27','d1b6fdd3-2c14-4af6-b1fb-b555150c2a27','tempest-typeshare-type-291418832',1,NULL),('2025-11-29 05:38:53.948576',NULL,'2025-11-29 05:38:58.146671','d6d71f4f-03e4-4782-9e86-8f9adabdb6a0','d6d71f4f-03e4-4782-9e86-8f9adabdb6a0','tempest-typeshare-type-83579188',1,NULL),('2025-11-29 05:35:50.581772',NULL,'2025-11-29 05:36:34.802069','d8457b4e-8e27-45f2-9628-fa0bc63046d3','d8457b4e-8e27-45f2-9628-fa0bc63046d3','tempest-share-type-1445468974',1,NULL),('2025-11-29 05:34:43.885024',NULL,'2025-11-29 05:34:45.141626','d934b72f-5250-4fc0-9f20-8d2296785c1e','d934b72f-5250-4fc0-9f20-8d2296785c1e','tempest-share-type-957058633',1,NULL),('2025-11-29 05:35:27.801244',NULL,'2025-11-29 05:35:43.144690','da0820f0-008b-47f7-acdd-4f4acff2c7e9','da0820f0-008b-47f7-acdd-4f4acff2c7e9','tempest-typeshare-type-410327185',1,NULL),('2025-11-29 05:37:04.042520',NULL,'2025-11-29 05:37:17.240060','da877f40-3e66-4f6d-a3b7-6826e8fd999d','da877f40-3e66-4f6d-a3b7-6826e8fd999d','tempest-tempest-manila-1937567593',1,NULL),('2025-11-29 05:37:31.488498',NULL,'2025-11-29 05:37:37.393747','db048fd6-3099-4879-ae15-e536099ed173','db048fd6-3099-4879-ae15-e536099ed173','tempest-typeshare-type-2092347705',1,NULL),('2025-11-29 05:38:02.677414',NULL,'2025-11-29 05:38:03.246621','dc0222c0-c786-4aab-8322-4a9bf670d3fa','dc0222c0-c786-4aab-8322-4a9bf670d3fa','tempest-support_some_azs_share_type-1940304397',1,NULL),('2025-11-29 05:40:16.523519',NULL,'2025-11-29 05:40:18.749307','dccf70f8-0d21-4f97-820b-d75252517898','dccf70f8-0d21-4f97-820b-d75252517898','tempest-typeshare-type-1941003870',1,NULL),('2025-11-29 05:30:57.402292',NULL,NULL,'False','dd081b42-5cd7-4c7c-8a9b-8db684f71e20','default',1,NULL),('2025-11-29 05:35:07.340821',NULL,'2025-11-29 05:35:43.768423','ddc6389e-dda9-47b0-85a7-6ad509ba0f38','ddc6389e-dda9-47b0-85a7-6ad509ba0f38','tempest-typeshare-type-939320232',1,NULL),('2025-11-29 05:40:51.962235',NULL,'2025-11-29 05:41:21.598115','deb5e28d-c187-482e-a13e-e6b5c6d26fe5','deb5e28d-c187-482e-a13e-e6b5c6d26fe5','tempest-typeshare-type-1479808788',1,NULL),('2025-11-29 05:38:06.129253',NULL,'2025-11-29 05:38:06.283334','e026fadd-4008-4932-8180-42f438b12eb0','e026fadd-4008-4932-8180-42f438b12eb0','tempest-support_any_az_share_type-1029783899',1,NULL),('2025-11-29 05:37:32.610509',NULL,'2025-11-29 05:37:36.921065','e32ae0f8-6e2a-45d7-b203-8c4ee8859287','e32ae0f8-6e2a-45d7-b203-8c4ee8859287','tempest-typeshare-type-1007849234',1,NULL),('2025-11-29 05:38:56.193862',NULL,'2025-11-29 05:38:56.394550','e3611b8e-87d2-4007-aad2-ee0e15c28e6c','e3611b8e-87d2-4007-aad2-ee0e15c28e6c','tempest-support_any_az_share_type-344905017',1,NULL),('2025-11-29 05:38:02.030379',NULL,'2025-11-29 05:38:02.249431','e49e1ec3-771b-4952-a465-3fed071cdec7','e49e1ec3-771b-4952-a465-3fed071cdec7','tempest-az_share_type-1371574202',1,NULL),('2025-11-29 05:37:28.242935',NULL,'2025-11-29 05:37:39.084437','e5d3b05b-5fb4-4fb7-886d-de31ce6345c4','e5d3b05b-5fb4-4fb7-886d-de31ce6345c4','tempest-typeshare-type-1482244548',1,NULL),('2025-11-29 05:36:06.563189',NULL,'2025-11-29 05:36:33.716975','e5dc9337-9d3d-486c-9f20-360499be97a6','e5dc9337-9d3d-486c-9f20-360499be97a6','tempest-share-type-418290154',1,NULL),('2025-11-29 05:37:05.277821',NULL,'2025-11-29 05:37:15.076509','e65f70d4-c6c1-41ff-a1b8-3990320eac47','e65f70d4-c6c1-41ff-a1b8-3990320eac47','tempest-tempest-manila-493749763',1,NULL),('2025-11-29 05:37:08.725046','2025-11-29 05:37:08.808542','2025-11-29 05:37:11.292922','eb7c2d6e-dc4c-41a8-8d84-bd0f993ec7da','eb7c2d6e-dc4c-41a8-8d84-bd0f993ec7da','tempest-tempest-manila-75069251',1,'description_updated'),('2025-11-29 05:36:45.593867',NULL,'2025-11-29 05:36:54.183160','eb844929-18ba-4d18-8fc0-5ba67aa3721e','eb844929-18ba-4d18-8fc0-5ba67aa3721e','tempest-typeshare-type-1996212187',1,NULL),('2025-11-29 05:38:04.836495',NULL,'2025-11-29 05:38:05.044755','ef516210-a004-4296-88aa-b83c77e83206','ef516210-a004-4296-88aa-b83c77e83206','tempest-support_any_az_share_type-97566978',1,NULL),('2025-11-29 05:37:07.746138','2025-11-29 05:37:07.829354','2025-11-29 05:37:12.474496','f0cafc49-6761-4502-848b-eb58ed369a28','f0cafc49-6761-4502-848b-eb58ed369a28','tempest-tempest-manila-1355963603',1,'description_updated'),('2025-11-29 05:36:23.240500',NULL,'2025-11-29 05:36:58.758861','f0da18b9-ba8c-41ec-8938-860c87e4760c','f0da18b9-ba8c-41ec-8938-860c87e4760c','tempest-typeshare-type-504657133',1,NULL),('2025-11-29 05:34:55.469439',NULL,'2025-11-29 05:34:56.644632','f27e11e4-531e-43c7-b293-ebb75a2d1599','f27e11e4-531e-43c7-b293-ebb75a2d1599','tempest-typeshare-type-1371515738',1,NULL),('2025-11-29 05:35:35.912530',NULL,'2025-11-29 05:35:42.248173','f29d90ca-7366-41b1-9029-74f9055a75bd','f29d90ca-7366-41b1-9029-74f9055a75bd','tempest-typeshare-type-1740856910',1,NULL),('2025-11-29 05:35:25.386680',NULL,'2025-11-29 05:35:43.431133','f67bd588-143f-43fa-afb1-11534eb30af9','f67bd588-143f-43fa-afb1-11534eb30af9','tempest-typeshare-type-537492639',1,NULL),('2025-11-29 05:37:07.909575','2025-11-29 05:37:07.996393','2025-11-29 05:37:12.312299','f808eddd-f29d-40db-9e82-88aa9f36b799','f808eddd-f29d-40db-9e82-88aa9f36b799','tempest-tempest-manila-442407344',1,'Description for share type'),('2025-11-29 05:39:22.327293',NULL,'2025-11-29 05:40:32.425168','f8c8a67f-7464-472c-90a6-c0d7c3ba1b5d','f8c8a67f-7464-472c-90a6-c0d7c3ba1b5d','tempest-typeshare-type-1748153304',1,NULL),('2025-11-29 05:36:41.999928',NULL,'2025-11-29 05:36:45.136108','f9c8394e-7f23-4249-904b-0125fe8452da','f9c8394e-7f23-4249-904b-0125fe8452da','tempest-typeshare-type-520802949',1,NULL),('2025-11-29 05:37:31.032056',NULL,'2025-11-29 05:37:37.970215','fda01a86-07fc-4d6c-9626-8a66177cf3f6','fda01a86-07fc-4d6c-9626-8a66177cf3f6','tempest-typeshare-type-549325043',1,NULL),('2025-11-29 05:37:04.770909',NULL,'2025-11-29 05:37:15.642334','ffe4fd1c-8f3d-4298-9eb8-f27c0dae3ab2','ffe4fd1c-8f3d-4298-9eb8-f27c0dae3ab2','tempest-tempest-manila-2039444862',1,'Description for share type');
/*!40000 ALTER TABLE `share_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shares`
--

DROP TABLE IF EXISTS `shares`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `shares` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `share_proto` varchar(255) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `snapshot_support` tinyint(1) DEFAULT NULL,
  `share_group_id` varchar(36) DEFAULT NULL,
  `source_share_group_snapshot_member_id` varchar(36) DEFAULT NULL,
  `task_state` varchar(255) DEFAULT NULL,
  `replication_type` varchar(255) DEFAULT NULL,
  `create_share_from_snapshot_support` tinyint(1) DEFAULT NULL,
  `revert_to_snapshot_support` tinyint(1) DEFAULT NULL,
  `mount_snapshot_support` tinyint(1) DEFAULT NULL,
  `is_soft_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `scheduled_to_be_deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_shares_share_group_id` (`share_group_id`),
  CONSTRAINT `fk_shares_share_group_id` FOREIGN KEY (`share_group_id`) REFERENCES `share_groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shares`
--

LOCK TABLES `shares` WRITE;
/*!40000 ALTER TABLE `shares` DISABLE KEYS */;
INSERT INTO `shares` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `size`, `display_name`, `display_description`, `snapshot_id`, `share_proto`, `is_public`, `snapshot_support`, `share_group_id`, `source_share_group_snapshot_member_id`, `task_state`, `replication_type`, `create_share_from_snapshot_support`, `revert_to_snapshot_support`, `mount_snapshot_support`, `is_soft_deleted`, `scheduled_to_be_deleted_at`) VALUES ('2025-11-29 05:39:26.834689','2025-11-29 05:39:34.446236','2025-11-29 05:39:34.445753','072f020d-2708-48db-82b6-eb693c43a81c','072f020d-2708-48db-82b6-eb693c43a81c','d03f7b23a91648fc985ffb356cc04f1d','a05f740db7b94303aac90d6f217f853a',1,'tempest-tempest-created-share-1480645387','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:35:43.908388','2025-11-29 05:35:49.068277','2025-11-29 05:35:49.067970','0dff3548-f4f7-4b80-9811-9a9168307144','0dff3548-f4f7-4b80-9811-9a9168307144','07455b147f224a5e9b6756f05d6a11b2','81a95c19e7f04f9388e5b6cb015dc8bf',1,'tempest-tempest-created-share-1803598183','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:38:35.154839','2025-11-29 05:38:39.581866','2025-11-29 05:38:39.581385','12ebdbf1-f425-424d-9182-926c9f706b81','12ebdbf1-f425-424d-9182-926c9f706b81','40461bcceb79486685576e03cd6143f7','bde0f89de7a5405e8d086a6415adbc5c',1,'tempest-tempest-created-share-936886712','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:38:04.963164','2025-11-29 05:38:08.582088','2025-11-29 05:38:08.581779','177748b2-71b4-434c-9c07-250bb252552d','177748b2-71b4-434c-9c07-250bb252552d','3e0f252f8cc84922a46c637bf75d9b12','bf7ea2709c674f5da87071b7a3ab3ac1',1,'tempest-tempest-created-share-1163897837','tempest-tempest-created-share-desc-1332159045',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:37:55.123357','2025-11-29 05:38:18.805134','2025-11-29 05:38:18.804638','1cd9a707-7d70-4c62-ba13-512b8025fb75','1cd9a707-7d70-4c62-ba13-512b8025fb75','6de51f96bd584575956b19290f27af8f','e577c04bfe1b459f9aebd0f826827833',1,'tempest-tempest-created-share-231777687','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:41:06.551189','2025-11-29 05:41:18.368441','2025-11-29 05:41:18.368123','1f0746c5-ce51-4a65-98e3-f72e5530a929','1f0746c5-ce51-4a65-98e3-f72e5530a929','ea27d7612aa34955a6fb1f29750c8921','837f2bfa5aab4fdabd09b7661c70b7dd',1,'tempest-tempest-created-share-2083162802','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-11-29 05:40:43.573994','2025-11-29 05:41:35.799348','2025-11-29 05:41:35.798943','217acc03-b4a2-4cc6-b7f3-39aeb7e3d87e','217acc03-b4a2-4cc6-b7f3-39aeb7e3d87e','e4d2d18fdb14465eacc082349a6e10a9','d26079c7d6c8427193b3786b26cb5b7e',1,'tempest-tempest-share-name-983045580','tempest-tempest-share-description-1674636472',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-11-29 05:39:46.865355','2025-11-29 05:39:51.677539','2025-11-29 05:39:51.677092','275051e4-50a6-4dcd-b3f9-4e6781bc9228','275051e4-50a6-4dcd-b3f9-4e6781bc9228','0cb50441bd6144cda55fbe51a4e87bce','49f85bf88a7641b492d9ed0e3cbb7c9c',1,'tempest-tempest-share-name-1736276932','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:38:10.550049','2025-11-29 05:38:14.715367','2025-11-29 05:38:14.715005','28a8252f-ba0e-4938-9c9b-5f86d49b5f6a','28a8252f-ba0e-4938-9c9b-5f86d49b5f6a','40461bcceb79486685576e03cd6143f7','bde0f89de7a5405e8d086a6415adbc5c',1,'tempest-tempest-created-share-1103812568','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:35:40.241519','2025-11-29 05:36:29.406030','2025-11-29 05:36:29.405634','2af0b441-c8d2-4e9d-8906-65df11a5ea13','2af0b441-c8d2-4e9d-8906-65df11a5ea13','07455b147f224a5e9b6756f05d6a11b2','81a95c19e7f04f9388e5b6cb015dc8bf',1,'tempest-tempest-created-share-21720036','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:34:48.207331','2025-11-29 05:34:50.361312','2025-11-29 05:34:50.359210','2bab3e99-62f0-4af2-8df3-5f4fc80d6100','2bab3e99-62f0-4af2-8df3-5f4fc80d6100','4544ba66fc044b5a8d3aa9deb5249384','3e18b41001c440e0a7d05f7f98059230',1,'tempest-tempest-created-share-1815115781','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:38:32.277290','2025-11-29 05:38:37.932836','2025-11-29 05:38:37.932454','32b3bd55-f887-4c7b-abf3-c0e58448cfc0','32b3bd55-f887-4c7b-abf3-c0e58448cfc0','32a388e3f3e241ffb7aa37e8bb62baba','ae2a6e9fbea0426ebacf2fe56abb903e',1,'tempest-tempest-created-share-124857863','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:42:51.917207','2025-11-29 05:42:56.953481','2025-11-29 05:42:56.953111','3bb9d2b2-8a58-41ba-b295-f8c5206246ea','3bb9d2b2-8a58-41ba-b295-f8c5206246ea','c8055d8ebb36432196034de4894bbc3b','388000b055144e48b6827e9f35029a82',1,'tempest-tempest-created-share-838844230','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-11-29 05:38:00.975403','2025-11-29 05:38:04.653846','2025-11-29 05:38:04.653532','3cc24ec6-7260-40a2-aa54-0fb231b3fa43','3cc24ec6-7260-40a2-aa54-0fb231b3fa43','3e0f252f8cc84922a46c637bf75d9b12','bf7ea2709c674f5da87071b7a3ab3ac1',1,'tempest-tempest-created-share-1885095233','tempest-tempest-created-share-desc-2101159099',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:37:56.772004','2025-11-29 05:38:00.682724','2025-11-29 05:38:00.682322','3cecb700-a400-400a-be98-c6df0ec19bf4','3cecb700-a400-400a-be98-c6df0ec19bf4','3e0f252f8cc84922a46c637bf75d9b12','bf7ea2709c674f5da87071b7a3ab3ac1',1,'tempest-tempest-created-share-1849742147','tempest-tempest-created-share-desc-839143370',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:37:35.681283','2025-11-29 05:37:40.397779','2025-11-29 05:37:40.397365','407283f6-7e71-4b3e-b4e6-abcfb3fd68be','407283f6-7e71-4b3e-b4e6-abcfb3fd68be','5420544d13be4310a8a32043f9b7ab4d','88ea41f1eaaf4ed9b8f5335cd407f038',1,'tempest-tempest-share-name-1339586821','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:38:31.618225','2025-11-29 05:38:36.572500','2025-11-29 05:38:36.571907','42aa1a88-52cf-40d6-adfe-82a3d3291fa5','42aa1a88-52cf-40d6-adfe-82a3d3291fa5','116774de87694898ba2a8d06c7ac7069','352a7d8defe34a3486f41ba56e48d88e',1,'private_share','private share in the primary user project',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:41:28.708279','2025-11-29 05:43:00.584731','2025-11-29 05:43:00.584073','4498b4b5-3a5f-43b2-8a0c-c035954ff1b7','4498b4b5-3a5f-43b2-8a0c-c035954ff1b7','c8055d8ebb36432196034de4894bbc3b','388000b055144e48b6827e9f35029a82',1,'tempest-tempest-share-name-1652125990','tempest-tempest-share-description-1533899209','f919bca8-f41c-47b0-8fca-f8f7988969c2','CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-11-29 05:36:58.640928','2025-11-29 05:37:18.614615','2025-11-29 05:37:18.614190','45d34c7e-ddfe-479f-9e11-5ea1423144f0','45d34c7e-ddfe-479f-9e11-5ea1423144f0','c137c6e1ac7f469f9c4483dd53883c2d','f5d6fcc020694561b091889318c2561b',1,'tempest-share-1312049607','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:39:24.702241','2025-11-29 05:39:28.677717','2025-11-29 05:39:28.677323','536723d5-2c13-4069-b56d-46bcda068e2d','536723d5-2c13-4069-b56d-46bcda068e2d','6b29bd6ef300472cad86c5c5a7341f17','96857e43ebcb4e019650999b54e535a1',1,'tempest-tempest-created-share-1422039278','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:35:58.982026','2025-11-29 05:36:06.359963','2025-11-29 05:36:06.359165','56d4f245-aad6-4afa-a1ec-3689faa4e66c','56d4f245-aad6-4afa-a1ec-3689faa4e66c','b5459c3e7d4643048572257a42a70281','c6b8afea074442b2b9cd8ed762e06d27',1,'tempest-tempest-created-share-1372449608','tempest-tempest-created-share-desc-1043301075',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:40:52.167516','2025-11-29 05:41:03.462448','2025-11-29 05:41:03.462145','57846cd1-c190-4de4-9fa1-0159e8b2a7b8','57846cd1-c190-4de4-9fa1-0159e8b2a7b8','ea27d7612aa34955a6fb1f29750c8921','837f2bfa5aab4fdabd09b7661c70b7dd',2,'tempest-tempest-created-share-231742269','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-11-29 05:36:02.156260','2025-11-29 05:36:06.199101','2025-11-29 05:36:06.198542','5c055a16-0c09-4ca8-b8c9-7c5826eecc33','5c055a16-0c09-4ca8-b8c9-7c5826eecc33','07455b147f224a5e9b6756f05d6a11b2','81a95c19e7f04f9388e5b6cb015dc8bf',1,'tempest-tempest-created-share-183359046','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:40:48.756048','2025-11-29 05:41:35.956087','2025-11-29 05:41:35.955758','60a27966-8e4b-44f9-8615-a66683748b87','60a27966-8e4b-44f9-8615-a66683748b87','ee35284df12f4f4fad5f92cf5c9ec4e2','e97b8963e55a4094b1cb702d19d887ba',1,'tempest-tempest-created-share-1841226375','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-11-29 05:41:17.723570','2025-11-29 05:41:33.107810','2025-11-29 05:41:33.107397','61d56d6b-329f-4294-9bd8-fc4c72035af0','61d56d6b-329f-4294-9bd8-fc4c72035af0','ee35284df12f4f4fad5f92cf5c9ec4e2','e97b8963e55a4094b1cb702d19d887ba',1,'tempest-tempest-created-share-1578469509','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:37:52.527820','2025-11-29 05:37:56.491090','2025-11-29 05:37:56.490644','62d5650f-e0da-4b7c-a132-3a85b7f0a4c8','62d5650f-e0da-4b7c-a132-3a85b7f0a4c8','3e0f252f8cc84922a46c637bf75d9b12','bf7ea2709c674f5da87071b7a3ab3ac1',1,'tempest-tempest-created-share-2137676047','tempest-tempest-created-share-desc-317305691',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:39:37.411625','2025-11-29 05:39:44.730183','2025-11-29 05:39:44.729566','66a749f8-4cee-4a3e-8e40-a020973a1d4e','66a749f8-4cee-4a3e-8e40-a020973a1d4e','d03f7b23a91648fc985ffb356cc04f1d','a05f740db7b94303aac90d6f217f853a',1,'tempest-tempest-created-share-271574452','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:34:36.232175','2025-11-29 05:34:44.323729','2025-11-29 05:34:44.323356','6b83ef1c-3572-49d6-a817-e57d3dbc62c9','6b83ef1c-3572-49d6-a817-e57d3dbc62c9','cb1b305ee4f94aa68f250be4f43ef913','049c3d38228f4e3e9c392f5f88dbc238',1,'tempest-tempest-created-share-1406281020','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:37:48.429509','2025-11-29 05:37:52.201232','2025-11-29 05:37:52.200904','6c7e4dab-ae52-4e96-adf9-a016c8ede2b3','6c7e4dab-ae52-4e96-adf9-a016c8ede2b3','3e0f252f8cc84922a46c637bf75d9b12','bf7ea2709c674f5da87071b7a3ab3ac1',1,'tempest-tempest-created-share-2099999028','tempest-tempest-created-share-desc-1569123072',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:42:41.652294','2025-11-29 05:42:48.705130','2025-11-29 05:42:48.704696','706ae3a3-b631-40be-bd6a-145f050623dc','706ae3a3-b631-40be-bd6a-145f050623dc','c8055d8ebb36432196034de4894bbc3b','388000b055144e48b6827e9f35029a82',1,'tempest-tempest-created-share-1929859746','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-11-29 05:36:09.436445','2025-11-29 05:36:14.923073','2025-11-29 05:36:14.922197','71336145-ee0e-48b9-8ec3-eb037c4d1576','71336145-ee0e-48b9-8ec3-eb037c4d1576','07455b147f224a5e9b6756f05d6a11b2','81a95c19e7f04f9388e5b6cb015dc8bf',1,'tempest-tempest-created-share-1763114745','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:41:21.494367','2025-11-29 05:43:09.864421','2025-11-29 05:43:09.863912','72b3c978-5d97-46cd-a8ea-f38c1eaf9039','72b3c978-5d97-46cd-a8ea-f38c1eaf9039','c8055d8ebb36432196034de4894bbc3b','388000b055144e48b6827e9f35029a82',1,'tempest-tempest-share-name-1048010103','tempest-tempest-share-description-1330407828',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-11-29 05:38:27.408161','2025-11-29 05:38:32.005185','2025-11-29 05:38:32.004485','79a54e91-4fbe-4cd5-8b8d-544df0ba1f9e','79a54e91-4fbe-4cd5-8b8d-544df0ba1f9e','40461bcceb79486685576e03cd6143f7','bde0f89de7a5405e8d086a6415adbc5c',1,'tempest-tempest-created-share-828446080','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:35:08.766336','2025-11-29 05:35:18.244810','2025-11-29 05:35:18.244193','7a0eb625-aa27-409c-b778-2fc0d1a82ac0','7a0eb625-aa27-409c-b778-2fc0d1a82ac0','23469d4601454621a798588dbcc97218','b4f2479ae0d643afbae53bb92525282e',4,'tempest-tempest-created-share-1504143610','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:35:52.269083','2025-11-29 05:35:58.971301','2025-11-29 05:35:58.970855','7ad6d86a-1f98-465f-9724-374ac602131e','7ad6d86a-1f98-465f-9724-374ac602131e','07455b147f224a5e9b6756f05d6a11b2','81a95c19e7f04f9388e5b6cb015dc8bf',1,'tempest-tempest-created-share-1279462440','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:40:21.723235',NULL,NULL,'False','7bbfdea3-8114-4f5d-b029-3762625f5bc7','f0f48ede370b4632ab7b21cc94cfb7ff','5dd620782ecb48b9af309e8bc536acb2',1,'tempest-tempest-created-share-1122369471','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:35:13.412201','2025-11-29 05:35:23.137846','2025-11-29 05:35:23.137116','7c048789-8103-4100-b49c-67197de310c9','7c048789-8103-4100-b49c-67197de310c9','23469d4601454621a798588dbcc97218','b4f2479ae0d643afbae53bb92525282e',3,'tempest-tempest-created-share-1181078457','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:34:27.202875','2025-11-29 05:34:31.983622','2025-11-29 05:34:31.983235','820c0659-0a9a-4f59-8e23-14e523dbf0fb','820c0659-0a9a-4f59-8e23-14e523dbf0fb','4544ba66fc044b5a8d3aa9deb5249384','3e18b41001c440e0a7d05f7f98059230',2,'tempest-tempest-created-share-1873313362','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:36:45.775339','2025-11-29 05:36:50.905776','2025-11-29 05:36:50.905273','8310bf7d-d76e-400d-b99f-6ef2581d15aa','8310bf7d-d76e-400d-b99f-6ef2581d15aa','6c79efccd5e949dba16681088657b988','4ebe049df4f04fa2a5f37dadb54a1497',1,'tempest-tempest-created-share-225451337','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:42:42.017765','2025-11-29 05:42:53.884809','2025-11-29 05:42:53.884074','87225f6c-bfcc-41c4-9ef8-2ba0142f8320','87225f6c-bfcc-41c4-9ef8-2ba0142f8320','89edac5a76e841118f3aa700b37de873','763ee5d3450f427ca1081cea0f991adc',1,'tempest-tempest-share-name-1463990008','tempest-tempest-share-description-1952711235',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-11-29 05:36:27.672147','2025-11-29 05:36:51.085803','2025-11-29 05:36:51.085424','8c3cf27c-29e2-41bd-bd85-e08342a32955','8c3cf27c-29e2-41bd-bd85-e08342a32955','df986af3d0c84127a1e3fbaab7aaf38b','c48d0a2145674172882133c87bb61929',1,'tempest-tempest-created-share-9963966','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:34:24.885028','2025-11-29 05:34:31.744979','2025-11-29 05:34:31.744279','8d46b7a0-c152-44f3-b3da-49c77bd2c58d','8d46b7a0-c152-44f3-b3da-49c77bd2c58d','6bebd43b2c7c48209f1030ff92d31dc2','35fca249d2fe4b499e58ae322257ed19',1,'tempest-tempest-created-share-1501202260','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:42:26.217875','2025-11-29 05:42:33.756883','2025-11-29 05:42:33.756481','8e54542b-a2a5-45c9-85c3-3fefc8c82e34','8e54542b-a2a5-45c9-85c3-3fefc8c82e34','c8055d8ebb36432196034de4894bbc3b','388000b055144e48b6827e9f35029a82',2,'tempest-tempest-created-share-1712468149','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-11-29 05:43:59.322876','2025-11-29 05:44:03.461099','2025-11-29 05:44:03.460743','902d0c9f-7a57-4149-a230-c09dc7d9bdea','902d0c9f-7a57-4149-a230-c09dc7d9bdea','6f7f9251bec644a5bf819843dcf464f5','bfa506cc517a4cf1bb6dc4bca76155a6',1,'tempest-tempest-created-share-273604831','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:43:37.222348','2025-11-29 05:43:41.553700','2025-11-29 05:43:41.553323','928d0bd6-1e14-4ec9-8e20-61c818ace145','928d0bd6-1e14-4ec9-8e20-61c818ace145','6f7f9251bec644a5bf819843dcf464f5','bfa506cc517a4cf1bb6dc4bca76155a6',1,'tempest-tempest-created-share-35756076','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:36:23.506184','2025-11-29 05:36:55.247660','2025-11-29 05:36:55.247162','950d39d8-f939-4da1-9271-c5747d3cf4c8','950d39d8-f939-4da1-9271-c5747d3cf4c8','df986af3d0c84127a1e3fbaab7aaf38b','c48d0a2145674172882133c87bb61929',1,'tempest-tempest-created-share-969728360','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:39:39.638427','2025-11-29 05:39:55.839523','2025-11-29 05:39:55.839017','983ef5f8-b163-46cc-8069-4c6593961527','983ef5f8-b163-46cc-8069-4c6593961527','0cb50441bd6144cda55fbe51a4e87bce','49f85bf88a7641b492d9ed0e3cbb7c9c',1,'tempest-tempest-share-name-715425674','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:39:09.833236','2025-11-29 05:39:21.248933','2025-11-29 05:39:21.248580','9a6f70c7-49e7-4bfc-8dfe-7d8aa66f411a','9a6f70c7-49e7-4bfc-8dfe-7d8aa66f411a','6b29bd6ef300472cad86c5c5a7341f17','96857e43ebcb4e019650999b54e535a1',1,'tempest-tempest-created-share-1125001654','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:38:49.853367','2025-11-29 05:39:02.232290','2025-11-29 05:39:02.231857','9a9718aa-cdac-400b-92ad-2d69eabfb34a','9a9718aa-cdac-400b-92ad-2d69eabfb34a','18ebde6642cb44c1bd4ab1e5fa932abd','177e0fe42e604553bd3b076a784b5e9d',1,'tempest-tempest-created-share-418038086','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:39:31.878925','2025-11-29 05:40:02.426460','2025-11-29 05:40:02.426044','9ce48378-5393-4d33-bcc2-afdeb6c4c2fe','9ce48378-5393-4d33-bcc2-afdeb6c4c2fe','0cb50441bd6144cda55fbe51a4e87bce','49f85bf88a7641b492d9ed0e3cbb7c9c',1,'tempest-tempest-share-name-1193535135','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:36:14.403290','2025-11-29 05:36:18.286630','2025-11-29 05:36:18.285683','a4719e97-03da-4127-8147-ec08a86a6bb3','a4719e97-03da-4127-8147-ec08a86a6bb3','b5459c3e7d4643048572257a42a70281','c6b8afea074442b2b9cd8ed762e06d27',1,'tempest-tempest-created-share-1772841830','tempest-tempest-created-share-desc-949104264',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:39:35.780167','2025-11-29 05:39:58.768440','2025-11-29 05:39:58.768190','a48dc6cd-ba46-42ca-a17d-bcb8b85f2165','a48dc6cd-ba46-42ca-a17d-bcb8b85f2165','0cb50441bd6144cda55fbe51a4e87bce','49f85bf88a7641b492d9ed0e3cbb7c9c',1,'tempest-tempest-share-name-1169767597','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:34:35.335356','2025-11-29 05:34:40.117290','2025-11-29 05:34:40.116863','a84fab06-0a2f-4cd4-a314-673cae274168','a84fab06-0a2f-4cd4-a314-673cae274168','4544ba66fc044b5a8d3aa9deb5249384','3e18b41001c440e0a7d05f7f98059230',2,'tempest-tempest-created-share-1115644878','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:36:20.117186','2025-11-29 05:36:23.402994','2025-11-29 05:36:23.402600','a862d85b-0423-409d-a586-753fa8e32d81','a862d85b-0423-409d-a586-753fa8e32d81','07455b147f224a5e9b6756f05d6a11b2','81a95c19e7f04f9388e5b6cb015dc8bf',1,'tempest-tempest-created-share-1527529128','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:37:17.267959','2025-11-29 05:37:34.072589','2025-11-29 05:37:34.072135','aaf64f7d-a6da-42d5-b6c4-1101918983fc','aaf64f7d-a6da-42d5-b6c4-1101918983fc','4522755852d94dd7bbf637007ec21bf0','ecd2e5916bab4f7cb242a87ec782ffda',1,'tempest-tempest-created-share-1831140614','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:39:22.610120','2025-11-29 05:40:29.315130','2025-11-29 05:40:29.314560','ac81ac86-8832-44a3-9ddf-a1f9548b23ff','ac81ac86-8832-44a3-9ddf-a1f9548b23ff','d03f7b23a91648fc985ffb356cc04f1d','a05f740db7b94303aac90d6f217f853a',1,'tempest-tempest-created-share-946229410','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:38:42.703532','2025-11-29 05:38:47.225909','2025-11-29 05:38:47.225461','afac464d-78fe-4919-adb9-f7d1119366fb','afac464d-78fe-4919-adb9-f7d1119366fb','116774de87694898ba2a8d06c7ac7069','352a7d8defe34a3486f41ba56e48d88e',1,'tempest-tempest-new-share-name-1548051367','share is now updated',NULL,'CEPHFS',1,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:35:15.328371','2025-11-29 05:35:29.264350','2025-11-29 05:35:29.263946','b0a3c929-fe9e-45a1-8799-1aad57220f40','b0a3c929-fe9e-45a1-8799-1aad57220f40','417cb9ae9b2a43429cd5d1781ad57fd9','c272c8175ff843ca8dc572501529b10b',1,'tempest-tempest-share-name-1656430113','tempest-tempest-share-description-1514985706','8cf4c283-b297-4eb5-902b-efa757c8775f','CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-11-29 05:40:40.940360','2025-11-29 05:41:43.293484','2025-11-29 05:41:43.293172','b21dc5b7-b92a-4537-a1e9-9593006a005c','b21dc5b7-b92a-4537-a1e9-9593006a005c','f33c8cd93bfb451cb06212731cbb3a46','4e135fffa1e64bf8b2e43bd33b51cf15',1,'tempest-tempest-created-share-86866219','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:36:23.015032','2025-11-29 05:36:27.104523','2025-11-29 05:36:27.104246','b358407f-b6af-44a4-9b96-bb8737f4a0ad','b358407f-b6af-44a4-9b96-bb8737f4a0ad','b5459c3e7d4643048572257a42a70281','c6b8afea074442b2b9cd8ed762e06d27',1,'tempest-tempest-created-share-1153300851','tempest-tempest-created-share-desc-817459439',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:39:47.470087','2025-11-29 05:39:55.884435','2025-11-29 05:39:55.883859','b5867587-3de3-43e0-8f9e-a5b7de6bde54','b5867587-3de3-43e0-8f9e-a5b7de6bde54','d03f7b23a91648fc985ffb356cc04f1d','a05f740db7b94303aac90d6f217f853a',1,'tempest-tempest-created-share-589126238','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:34:23.166054','2025-11-29 05:35:44.523314','2025-11-29 05:35:44.522634','b8319b08-a988-4842-8476-2b1128958f34','b8319b08-a988-4842-8476-2b1128958f34','4544ba66fc044b5a8d3aa9deb5249384','3e18b41001c440e0a7d05f7f98059230',1,'tempest-tempest-created-share-532458609','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:39:01.737598','2025-11-29 05:39:10.335492','2025-11-29 05:39:10.335128','bd641c8b-006a-42b6-8390-64c7bbd02a0b','bd641c8b-006a-42b6-8390-64c7bbd02a0b','6bb380b85f054d16ac066ab6ea1e4f89','96790676f7be41c7bf96036d7e07ffb2',1,'public_share','public_share_desc',NULL,'CEPHFS',1,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:36:19.217225','2025-11-29 05:36:27.344727','2025-11-29 05:36:27.344350','be39336e-f884-45a4-b50c-d8ee1803bc79','be39336e-f884-45a4-b50c-d8ee1803bc79','b5459c3e7d4643048572257a42a70281','c6b8afea074442b2b9cd8ed762e06d27',1,'tempest-tempest-created-share-817225501','tempest-tempest-created-share-desc-499402835',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:36:02.506640','2025-11-29 05:36:06.064477','2025-11-29 05:36:06.064101','befa686b-6239-457b-9216-72e72413f7e5','befa686b-6239-457b-9216-72e72413f7e5','b5459c3e7d4643048572257a42a70281','c6b8afea074442b2b9cd8ed762e06d27',1,'tempest-tempest-created-share-1470568874','tempest-tempest-created-share-desc-990318953',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:36:27.652044','2025-11-29 05:36:31.620040','2025-11-29 05:36:31.619461','bf0cb974-5bd9-4569-af3d-06e6cb5919af','bf0cb974-5bd9-4569-af3d-06e6cb5919af','b5459c3e7d4643048572257a42a70281','c6b8afea074442b2b9cd8ed762e06d27',1,'tempest-tempest-created-share-499586150','tempest-tempest-created-share-desc-2137300134',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:35:54.067297','2025-11-29 05:36:03.044901','2025-11-29 05:36:03.044524','c306547a-5139-4a85-935d-1f059e2e5a00','c306547a-5139-4a85-935d-1f059e2e5a00','ae00d95f95bb4ec8b2178598e348be7a','4453ce436b30425fba6f22e4043ef796',1,'tempest-tempest-created-share-2055798422','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:36:10.688479','2025-11-29 05:36:18.602675','2025-11-29 05:36:18.602271','c77b407c-e863-41eb-ac34-17923aaa7053','c77b407c-e863-41eb-ac34-17923aaa7053','b5459c3e7d4643048572257a42a70281','c6b8afea074442b2b9cd8ed762e06d27',1,'tempest-tempest-created-share-1707246930','tempest-tempest-created-share-desc-365894413',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:40:28.283846','2025-11-29 05:40:41.029425','2025-11-29 05:40:41.028929','d057cfa3-47b2-42be-8fcc-f0d7f7c8d87b','d057cfa3-47b2-42be-8fcc-f0d7f7c8d87b','ac0b18a898c7459da335489d13ce6891','b6fbd26e87a649ef8a1685512e46f501',1,'tempest-tempest-new-name-270429029','tempest-tempest-new-description-442341249',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:38:06.788127','2025-11-29 05:38:18.399064','2025-11-29 05:38:18.398689','d130feab-d067-40a5-9960-d1bc564e2cc6','d130feab-d067-40a5-9960-d1bc564e2cc6','40461bcceb79486685576e03cd6143f7','bde0f89de7a5405e8d086a6415adbc5c',1,'tempest-tempest-created-share-1304835360','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:39:38.915298','2025-11-29 05:40:23.803943','2025-11-29 05:40:23.803528','d15dc34f-8dd3-4087-95cc-e7788d546082','d15dc34f-8dd3-4087-95cc-e7788d546082','6b29bd6ef300472cad86c5c5a7341f17','96857e43ebcb4e019650999b54e535a1',1,'tempest-tempest-created-share-1014813472','Tempest\'s share','54db2b9e-cb54-440e-8afd-6c23560987db','CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-11-29 05:35:58.790178','2025-11-29 05:36:03.021052','2025-11-29 05:36:03.020696','d311ffc6-efc2-45ab-a2ff-86e8bf6b1342','d311ffc6-efc2-45ab-a2ff-86e8bf6b1342','b05695659a244b0999eccfed65868fdb','98fe5191e55f4f689dfe66e587ac3ee6',1,'tempest-tempest-created-share-2060135346','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:34:43.442035','2025-11-29 05:34:44.656509','2025-11-29 05:34:44.656035','d3644a76-34c8-4895-a693-7991975adeb1','d3644a76-34c8-4895-a693-7991975adeb1','4544ba66fc044b5a8d3aa9deb5249384','3e18b41001c440e0a7d05f7f98059230',1,'tempest-tempest-created-share-591002606','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:39:32.108822','2025-11-29 05:40:30.846008','2025-11-29 05:40:30.845611','d455a5e3-5638-439e-885b-3efb579e23f1','d455a5e3-5638-439e-885b-3efb579e23f1','6b29bd6ef300472cad86c5c5a7341f17','96857e43ebcb4e019650999b54e535a1',1,'tempest-tempest-created-share-1912852427','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-11-29 05:35:50.885074','2025-11-29 05:35:54.707782','2025-11-29 05:35:54.707069','d63b5112-aadb-407c-bec4-97c81b47af5b','d63b5112-aadb-407c-bec4-97c81b47af5b','b5459c3e7d4643048572257a42a70281','c6b8afea074442b2b9cd8ed762e06d27',1,'tempest-tempest-created-share-1606178520','tempest-tempest-created-share-desc-841010980',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:37:19.090665','2025-11-29 05:40:36.404213','2025-11-29 05:40:36.403912','d912f612-c8b0-4a4b-8ff9-2bb505956267','d912f612-c8b0-4a4b-8ff9-2bb505956267','a0f1e714fbec450395a7fdccce008b46','5dd620782ecb48b9af309e8bc536acb2',1,'tempest-tempest-created-share-1319228932','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:43:28.109952','2025-11-29 05:44:17.997424','2025-11-29 05:44:17.997021','dbd3da03-d3e4-4c33-93a8-95413e7575a1','dbd3da03-d3e4-4c33-93a8-95413e7575a1','6f7f9251bec644a5bf819843dcf464f5','bfa506cc517a4cf1bb6dc4bca76155a6',1,'tempest-tempest-share-name-563780304','tempest-tempest-share-description-202416665',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:43:45.159960','2025-11-29 05:43:49.025820','2025-11-29 05:43:49.025448','e0d41be5-4a19-4076-adbc-60e838484353','e0d41be5-4a19-4076-adbc-60e838484353','6f7f9251bec644a5bf819843dcf464f5','bfa506cc517a4cf1bb6dc4bca76155a6',2,'tempest-tempest-created-share-568429406','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:36:06.809172','2025-11-29 05:36:18.875657','2025-11-29 05:36:18.875172','e16e1ecc-c8d2-4e64-b3f6-d2d9870fa17d','e16e1ecc-c8d2-4e64-b3f6-d2d9870fa17d','b5459c3e7d4643048572257a42a70281','c6b8afea074442b2b9cd8ed762e06d27',1,'tempest-tempest-created-share-671865928','tempest-tempest-created-share-desc-2077909039',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:37:02.801294','2025-11-29 05:37:09.200837','2025-11-29 05:37:09.200449','ebf707dc-21e8-4228-9f51-e71fcdfe6ff6','ebf707dc-21e8-4228-9f51-e71fcdfe6ff6','26c05bae74e84e93a6448d0d1c0e707e','883530c38e954d818c0c7e7a75eaf2e2',1,'tempest-tempest-created-share-1495853952','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:43:52.218877','2025-11-29 05:43:55.954915','2025-11-29 05:43:55.954560','ef51f7d3-59b3-40e3-968a-ed03282d6e31','ef51f7d3-59b3-40e3-968a-ed03282d6e31','6f7f9251bec644a5bf819843dcf464f5','bfa506cc517a4cf1bb6dc4bca76155a6',1,'tempest-tempest-created-share-175278010','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:35:54.937920','2025-11-29 05:35:58.737450','2025-11-29 05:35:58.736751','f0561e75-9a83-48e9-9d98-de66e0b6b547','f0561e75-9a83-48e9-9d98-de66e0b6b547','b5459c3e7d4643048572257a42a70281','c6b8afea074442b2b9cd8ed762e06d27',1,'tempest-tempest-created-share-1151317773','tempest-tempest-created-share-desc-1187697003',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:37:43.695448','2025-11-29 05:37:49.133955','2025-11-29 05:37:49.133601','f32fbc4d-096b-4741-8c10-29c7bbfc8729','f32fbc4d-096b-4741-8c10-29c7bbfc8729','ae0d2a4b8f3d478e8235b9dbe2b26c6b','f6fcbad6247d48c28eb3ae887b3704b3',1,'tempest-tempest-share-name-2097964255','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:35:07.263442','2025-11-29 05:35:36.471143','2025-11-29 05:35:36.470543','f4322b3a-3450-4238-980c-d18815850d7d','f4322b3a-3450-4238-980c-d18815850d7d','417cb9ae9b2a43429cd5d1781ad57fd9','c272c8175ff843ca8dc572501529b10b',1,'tempest-tempest-share-name-1360767745','tempest-tempest-share-description-276998895',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-11-29 05:36:35.521377','2025-11-29 05:36:48.419915','2025-11-29 05:36:48.419422','f6495022-cf62-4e63-92d8-438c96f9cb74','f6495022-cf62-4e63-92d8-438c96f9cb74','9b2862373bbf44779eeacbfbcfe988ee','0c1d652029574d0fa397d5399235f790',1,'tempest-tempest-created-share-709349691','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:44:06.569831','2025-11-29 05:44:10.960023','2025-11-29 05:44:10.959687','f8f6072d-5215-4606-b32a-f6cddf7569f1','f8f6072d-5215-4606-b32a-f6cddf7569f1','6f7f9251bec644a5bf819843dcf464f5','bfa506cc517a4cf1bb6dc4bca76155a6',1,'tempest-tempest-created-share-1584458884','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-11-29 05:40:44.614931','2025-11-29 05:41:39.451321','2025-11-29 05:41:39.450697','fb8bde6a-ba22-4cf8-9b0e-5314b29c6a6c','fb8bde6a-ba22-4cf8-9b0e-5314b29c6a6c','f33c8cd93bfb451cb06212731cbb3a46','4e135fffa1e64bf8b2e43bd33b51cf15',1,'tempest-tempest-created-share-1035939588','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-11-29 05:38:27.978492','2025-11-29 05:38:39.410433','2025-11-29 05:38:39.410051','fef80ee9-8f20-4491-a2df-e7d9e3f1ccfd','fef80ee9-8f20-4491-a2df-e7d9e3f1ccfd','9a169c12e24a428eb9de96579b83c947','0729e4f41a8346198e8cb057eba4c265',1,'public_share - must be visible to all projects in the cloud','public_share_desc',NULL,'CEPHFS',1,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL);
/*!40000 ALTER TABLE `shares` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `resource_id` varchar(36) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime(6) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
INSERT INTO `transfers` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `resource_id`, `resource_type`, `display_name`, `salt`, `crypt_hash`, `expires_at`, `source_project_id`, `destination_project_id`, `accepted`) VALUES ('040b305d-502b-43e5-8798-173cb4125220','2025-11-29 05:37:47.379077',NULL,'2025-11-29 05:37:48.347933','040b305d-502b-43e5-8798-173cb4125220','f32fbc4d-096b-4741-8c10-29c7bbfc8729','share','tempest_share_transfer','2633a274','0d70d355050e9fe5bb913ce5ec41cc6e3405d047bb8b8b21173c402117cec4fb','2025-11-29 05:42:47.378057','f6fcbad6247d48c28eb3ae887b3704b3',NULL,0),('2547d253-d849-463e-8eee-a80c8897bb85','2025-11-29 05:39:35.176002',NULL,'2025-11-29 05:39:35.609536','2547d253-d849-463e-8eee-a80c8897bb85','9ce48378-5393-4d33-bcc2-afdeb6c4c2fe','share','tempest-tempest-created-share-transfer-1053717318','7c941146','c12a056fd87555129fb181613e843b759b3cfd80ae4d9c09e941f87c734a43ff','2025-11-29 05:44:35.174378','49f85bf88a7641b492d9ed0e3cbb7c9c',NULL,0),('78ea1bb3-afe3-490a-aa7a-3377a1a1308f','2025-11-29 05:37:39.105681','2025-11-29 05:37:39.643666','2025-11-29 05:37:39.643663','1','407283f6-7e71-4b3e-b4e6-abcfb3fd68be','share','tempest-tempest-created-share-transfer-213325493','faeb96bd','aaf91768fb71a8654e5b9abdd6d0dccff331ac7999669ec51c6df934edec138a','2025-11-29 05:42:39.103429','f6fcbad6247d48c28eb3ae887b3704b3','88ea41f1eaaf4ed9b8f5335cd407f038',1),('961364df-44b3-4147-87fc-bd7df519c164','2025-11-29 05:39:46.089727',NULL,'2025-11-29 05:39:46.454836','961364df-44b3-4147-87fc-bd7df519c164','983ef5f8-b163-46cc-8069-4c6593961527','share','tempest-tempest-created-share-transfer-1715428658','d7c04a85','f32625b132faadbb26e7b0766c00f45c12fed103f81fc82821156a2fcc23878c','2025-11-29 05:44:46.088502','49f85bf88a7641b492d9ed0e3cbb7c9c',NULL,0),('b59252f6-bd0a-4ffe-9151-a82391f01880','2025-11-29 05:39:50.250728',NULL,'2025-11-29 05:39:50.530900','b59252f6-bd0a-4ffe-9151-a82391f01880','275051e4-50a6-4dcd-b3f9-4e6781bc9228','share','tempest-tempest-created-share-transfer-825858731','9434d0f5','5798f650e512346373d49f5f748048cfe5645bf0490ed9a74ac6dc751cb619ff','2025-11-29 05:44:50.249919','49f85bf88a7641b492d9ed0e3cbb7c9c',NULL,0),('b821f5f0-5bd3-49b8-9ce9-3e1bd3aa246a','2025-11-29 05:39:39.110411',NULL,'2025-11-29 05:39:39.342269','b821f5f0-5bd3-49b8-9ce9-3e1bd3aa246a','a48dc6cd-ba46-42ca-a17d-bcb8b85f2165','share','tempest-tempest-created-share-transfer-442734497','ac188887','35987f71a2eb26cff2f84a9bc4451504cb11e253736c912d3dcac3999c705498','2025-11-29 05:44:39.108164','49f85bf88a7641b492d9ed0e3cbb7c9c',NULL,0);
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `mysql`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `mysql` /*!40100 DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci */;

USE `mysql`;

--
-- Table structure for table `general_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `general_log` (
  `event_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `command_type` varchar(64) NOT NULL,
  `argument` mediumtext NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='General log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slow_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `slow_log` (
  `start_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `query_time` time(6) NOT NULL,
  `lock_time` time(6) NOT NULL,
  `rows_sent` bigint(20) unsigned NOT NULL,
  `rows_examined` bigint(20) unsigned NOT NULL,
  `db` varchar(512) NOT NULL,
  `last_insert_id` int(11) NOT NULL,
  `insert_id` int(11) NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `sql_text` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `rows_affected` bigint(20) unsigned NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Slow log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `column_stats`
--

DROP TABLE IF EXISTS `column_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `column_stats` (
  `db_name` varchar(64) NOT NULL,
  `table_name` varchar(64) NOT NULL,
  `column_name` varchar(64) NOT NULL,
  `min_value` varbinary(255) DEFAULT NULL,
  `max_value` varbinary(255) DEFAULT NULL,
  `nulls_ratio` decimal(12,4) DEFAULT NULL,
  `avg_length` decimal(12,4) DEFAULT NULL,
  `avg_frequency` decimal(12,4) DEFAULT NULL,
  `hist_size` tinyint(3) unsigned DEFAULT NULL,
  `hist_type` enum('SINGLE_PREC_HB','DOUBLE_PREC_HB') DEFAULT NULL,
  `histogram` varbinary(255) DEFAULT NULL,
  PRIMARY KEY (`db_name`,`table_name`,`column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='Statistics on Columns';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `column_stats`
--

LOCK TABLES `column_stats` WRITE;
/*!40000 ALTER TABLE `column_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `column_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `columns_priv`
--

DROP TABLE IF EXISTS `columns_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `columns_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Table_name` char(64) NOT NULL DEFAULT '',
  `Column_name` char(64) NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `Column_priv` set('Select','Insert','Update','References') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`Host`,`Db`,`User`,`Table_name`,`Column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Column privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `columns_priv`
--

LOCK TABLES `columns_priv` WRITE;
/*!40000 ALTER TABLE `columns_priv` DISABLE KEYS */;
/*!40000 ALTER TABLE `columns_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db`
--

DROP TABLE IF EXISTS `db`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `db` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Event_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_history_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Host`,`Db`,`User`),
  KEY `User` (`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Database privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `db`
--

LOCK TABLES `db` WRITE;
/*!40000 ALTER TABLE `db` DISABLE KEYS */;
INSERT INTO `db` (`Host`, `Db`, `User`, `Select_priv`, `Insert_priv`, `Update_priv`, `Delete_priv`, `Create_priv`, `Drop_priv`, `Grant_priv`, `References_priv`, `Index_priv`, `Alter_priv`, `Create_tmp_table_priv`, `Lock_tables_priv`, `Create_view_priv`, `Show_view_priv`, `Create_routine_priv`, `Alter_routine_priv`, `Execute_priv`, `Event_priv`, `Trigger_priv`, `Delete_history_priv`) VALUES ('localhost','glance','glance_5610','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','glance','glance_5610','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','keystone','keystone_53da','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','keystone','keystone_53da','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','placement','placement_66ef','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','placement','placement_66ef','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','cinder','cinder_2f96','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','barbican','barbican_7da7','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','neutron','neutron_7451','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','cinder','cinder_2f96','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','barbican','barbican_7da7','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','neutron','neutron_7451','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_api','nova_api_6872','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_api','nova_api_6872','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_cell0','nova_cell0_48c8','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_cell0','nova_cell0_48c8','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','manila','manila_787d','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','manila','manila_787d','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');
/*!40000 ALTER TABLE `db` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `db` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `name` char(64) NOT NULL DEFAULT '',
  `body` longblob NOT NULL,
  `definer` char(141) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `execute_at` datetime DEFAULT NULL,
  `interval_value` int(11) DEFAULT NULL,
  `interval_field` enum('YEAR','QUARTER','MONTH','DAY','HOUR','MINUTE','WEEK','SECOND','MICROSECOND','YEAR_MONTH','DAY_HOUR','DAY_MINUTE','DAY_SECOND','HOUR_MINUTE','HOUR_SECOND','MINUTE_SECOND','DAY_MICROSECOND','HOUR_MICROSECOND','MINUTE_MICROSECOND','SECOND_MICROSECOND') DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_executed` datetime DEFAULT NULL,
  `starts` datetime DEFAULT NULL,
  `ends` datetime DEFAULT NULL,
  `status` enum('ENABLED','DISABLED','SLAVESIDE_DISABLED') NOT NULL DEFAULT 'ENABLED',
  `on_completion` enum('DROP','PRESERVE') NOT NULL DEFAULT 'DROP',
  `sql_mode` set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','IGNORE_BAD_TABLE_OPTIONS','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH','EMPTY_STRING_IS_NULL','SIMULTANEOUS_ASSIGNMENT','TIME_ROUND_FRACTIONAL') NOT NULL DEFAULT '',
  `comment` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `originator` int(10) unsigned NOT NULL,
  `time_zone` char(64) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT 'SYSTEM',
  `character_set_client` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `collation_connection` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `db_collation` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `body_utf8` longblob DEFAULT NULL,
  PRIMARY KEY (`db`,`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Events';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `func`
--

DROP TABLE IF EXISTS `func`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `func` (
  `name` char(64) NOT NULL DEFAULT '',
  `ret` tinyint(1) NOT NULL DEFAULT 0,
  `dl` char(128) NOT NULL DEFAULT '',
  `type` enum('function','aggregate') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='User defined functions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `func`
--

LOCK TABLES `func` WRITE;
/*!40000 ALTER TABLE `func` DISABLE KEYS */;
/*!40000 ALTER TABLE `func` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `global_priv`
--

DROP TABLE IF EXISTS `global_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Priv` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '{}' CHECK (json_valid(`Priv`)),
  PRIMARY KEY (`Host`,`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Users and global privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `global_priv`
--

LOCK TABLES `global_priv` WRITE;
/*!40000 ALTER TABLE `global_priv` DISABLE KEYS */;
INSERT INTO `global_priv` (`Host`, `User`, `Priv`) VALUES ('localhost','mariadb.sys','{\"access\":0,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"\",\"account_locked\":true,\"password_last_changed\":0}'),('localhost','root','{\"access\": 549755813887, \"plugin\": \"mysql_native_password\", \"authentication_string\": \"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\", \"auth_or\": [{}],\"version_id\":100529,\"password_last_changed\":1764392027}'),('%','root','{\"access\":549755813887,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\",\"password_last_changed\":1764392028}'),('localhost','glance_5610','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B273906900DFBDE92017468550DDB668F5A925B3\",\"password_last_changed\":1764392062}'),('%','glance_5610','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B273906900DFBDE92017468550DDB668F5A925B3\",\"password_last_changed\":1764392062}'),('localhost','keystone_53da','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*D2ACDD512B2D737B6865E1F92E6345C7E7F0C7A7\",\"password_last_changed\":1764392066}'),('%','keystone_53da','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*D2ACDD512B2D737B6865E1F92E6345C7E7F0C7A7\",\"password_last_changed\":1764392066}'),('localhost','placement_66ef','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*2925F3925A344AED5AE774D4D36472538F775A0C\",\"password_last_changed\":1764392067}'),('%','placement_66ef','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*2925F3925A344AED5AE774D4D36472538F775A0C\",\"password_last_changed\":1764392067}'),('localhost','cinder_2f96','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*6F166DDC83CD17032ED8E6ACF27A9D6CB619FB25\",\"password_last_changed\":1764392084}'),('localhost','barbican_7da7','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*F1A42C965F587E02448B712C1BA6B95BB775C110\",\"password_last_changed\":1764392084}'),('localhost','neutron_7451','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*EAAE5CEFDC8ECFE33066A102CE01857F3FFF160D\",\"password_last_changed\":1764392084}'),('%','cinder_2f96','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*6F166DDC83CD17032ED8E6ACF27A9D6CB619FB25\",\"password_last_changed\":1764392084}'),('%','barbican_7da7','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*F1A42C965F587E02448B712C1BA6B95BB775C110\",\"password_last_changed\":1764392084}'),('%','neutron_7451','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*EAAE5CEFDC8ECFE33066A102CE01857F3FFF160D\",\"password_last_changed\":1764392084}'),('localhost','nova_api_6872','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B040FA3933AB04B2E4D06117B85004CE9F1179B0\",\"password_last_changed\":1764392188}'),('localhost','nova_cell0_48c8','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*D75FE4AE482C4D87C0824FBDCE0CDB7E08E79AD9\",\"password_last_changed\":1764392188}'),('%','nova_api_6872','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B040FA3933AB04B2E4D06117B85004CE9F1179B0\",\"password_last_changed\":1764392188}'),('%','nova_cell0_48c8','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*D75FE4AE482C4D87C0824FBDCE0CDB7E08E79AD9\",\"password_last_changed\":1764392188}'),('localhost','manila_787d','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*495B205553C48996F088B24F7646A64F6C6BDBF5\",\"password_last_changed\":1764394124}'),('%','manila_787d','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*495B205553C48996F088B24F7646A64F6C6BDBF5\",\"password_last_changed\":1764394124}');
/*!40000 ALTER TABLE `global_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gtid_slave_pos`
--

DROP TABLE IF EXISTS `gtid_slave_pos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gtid_slave_pos` (
  `domain_id` int(10) unsigned NOT NULL,
  `sub_id` bigint(20) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `seq_no` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`domain_id`,`sub_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci COMMENT='Replication slave GTID position';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gtid_slave_pos`
--

LOCK TABLES `gtid_slave_pos` WRITE;
/*!40000 ALTER TABLE `gtid_slave_pos` DISABLE KEYS */;
/*!40000 ALTER TABLE `gtid_slave_pos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_category`
--

DROP TABLE IF EXISTS `help_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_category` (
  `help_category_id` smallint(5) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `parent_category_id` smallint(5) unsigned DEFAULT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_category_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_category`
--

LOCK TABLES `help_category` WRITE;
/*!40000 ALTER TABLE `help_category` DISABLE KEYS */;
INSERT INTO `help_category` (`help_category_id`, `name`, `parent_category_id`, `url`) VALUES (1,'Contents',0,''),(2,'Polygon Properties',34,''),(3,'WKT',34,''),(4,'Numeric Functions',37,''),(5,'Plugins',1,''),(6,'MBR',34,''),(7,'Control Flow Functions',37,''),(8,'Transactions',1,''),(9,'Help Metadata',1,''),(10,'Account Management',1,''),(11,'Point Properties',34,''),(12,'Encryption Functions',37,''),(13,'LineString Properties',34,''),(14,'Miscellaneous Functions',37,''),(15,'Logical Operators',47,''),(16,'Functions and Modifiers for Use with GROUP BY',1,''),(17,'Information Functions',37,''),(18,'Assignment Operators',47,''),(19,'Comparison Operators',47,''),(20,'Bit Functions',37,''),(21,'Table Maintenance',1,''),(22,'User-Defined Functions',1,''),(23,'Data Types',1,''),(24,'Compound Statements',1,''),(25,'Geometry Constructors',34,''),(26,'Administration',1,''),(27,'Data Manipulation',1,''),(28,'Utility',1,''),(29,'Language Structure',1,''),(30,'Geometry Relations',34,''),(31,'Date and Time Functions',37,''),(32,'WKB',34,''),(33,'Procedures',1,''),(34,'Geographic Features',1,''),(35,'Geometry Properties',34,''),(36,'String Functions',37,''),(37,'Functions',1,''),(38,'Data Definition',1,''),(39,'Sequences',1,''),(40,'JSON Functions',37,''),(41,'Window Functions',37,''),(42,'Spider Functions',37,''),(43,'Dynamic Column Functions',37,''),(44,'Galera Functions',37,''),(45,'Temporal Tables',1,''),(46,'GeoJSON',34,''),(47,'Operators',1,''),(48,'Arithmetic Operators',47,''),(49,'Replication',1,''),(50,'Prepared Statements',1,'');
/*!40000 ALTER TABLE `help_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_keyword`
--

DROP TABLE IF EXISTS `help_keyword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_keyword` (
  `help_keyword_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  PRIMARY KEY (`help_keyword_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help keywords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_keyword`
--

LOCK TABLES `help_keyword` WRITE;
/*!40000 ALTER TABLE `help_keyword` DISABLE KEYS */;
INSERT INTO `help_keyword` (`help_keyword_id`, `name`) VALUES (1,'work'),(2,'locks'),(3,'locking'),(4,'drop'),(5,'super'),(6,'usage'),(7,'binlog admin'),(8,'binlog monitor'),(9,'binlog replay'),(10,'connection admin'),(11,'federated admin'),(12,'grant option'),(13,'read_only admin'),(14,'replica monitor'),(15,'replication replica'),(16,'roles'),(17,'values'),(18,'value'),(19,'not'),(20,'and'),(21,'or'),(22,':='),(23,'assignment operator'),(24,'='),(25,'!='),(26,'<>'),(27,'not equal'),(28,'less than'),(29,'less than or equal'),(30,'NULL-safe equal'),(31,'equal'),(32,'greater than'),(33,'greater than or equal'),(34,'bitwise and'),(35,'shift left'),(36,'shift right'),(37,'bitwise xor'),(38,'bitwise or'),(39,'bitwise not'),(40,'returns'),(41,'udfs'),(42,'udf calling sequences'),(43,'udf security'),(44,'int1'),(45,'int2'),(46,'int3'),(47,'integer'),(48,'int4'),(49,'int8'),(50,'dec'),(51,'numeric'),(52,'fixed'),(53,'number'),(54,'real'),(55,'double precision'),(56,'nchar'),(57,'long'),(58,'long varchar'),(59,'repeat'),(60,'declare'),(61,'cursor'),(62,'show'),(63,'columns'),(64,'kill connection'),(65,'kill query'),(66,'delete returning'),(67,'sql_big_result'),(68,'minus'),(69,'cte'),(70,'insert returning'),(71,'queries'),(72,'query'),(73,'explain format'),(74,'explain format json'),(75,'rlike'),(76,'character_length'),(77,'escape'),(78,'mode'),(79,'trim_oracle'),(80,'schedule'),(81,'row_format'),(82,'starts'),(83,'host'),(84,'generated columns'),(85,'virtual columns'),(86,'computed columns'),(87,'hidden columns'),(88,'nextval'),(89,'lastval'),(90,'+'),(91,'addition operator'),(92,'/'),(93,'division operator'),(94,'%'),(95,'modulo operator'),(96,'*'),(97,'multiplication operator'),(98,'-'),(99,'subtraction operator'),(100,'master_ssl_verify_cert'),(101,'start replica'),(102,'stop replica'),(103,'reset slave'),(104,'reset replica'),(105,'drop prepare'),(106,'deallocate prepare');
/*!40000 ALTER TABLE `help_keyword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_relation`
--

DROP TABLE IF EXISTS `help_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_relation` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `help_keyword_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`help_keyword_id`,`help_topic_id`),
  KEY `help_topic_id` (`help_topic_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='keyword-topic relation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_relation`
--

LOCK TABLES `help_relation` WRITE;
/*!40000 ALTER TABLE `help_relation` DISABLE KEYS */;
INSERT INTO `help_relation` (`help_topic_id`, `help_keyword_id`) VALUES (94,1),(97,2),(99,2),(101,2),(116,2),(147,2),(152,2),(157,2),(161,2),(162,2),(338,2),(438,2),(97,3),(99,3),(101,3),(116,3),(147,3),(152,3),(157,3),(161,3),(162,3),(338,3),(438,3),(106,4),(112,4),(250,4),(687,4),(697,4),(713,4),(714,4),(715,4),(716,4),(717,4),(718,4),(719,4),(720,4),(722,4),(723,4),(731,4),(107,5),(107,6),(107,7),(107,8),(107,9),(107,10),(107,11),(107,12),(107,13),(107,14),(107,15),(115,16),(166,17),(166,18),(167,19),(168,20),(170,21),(210,22),(210,23),(211,23),(211,24),(212,25),(212,26),(212,27),(213,28),(214,29),(215,30),(216,31),(217,32),(218,33),(232,34),(233,35),(234,36),(236,37),(237,38),(238,39),(249,40),(251,41),(252,42),(253,43),(255,44),(257,45),(258,46),(259,47),(259,48),(260,49),(261,50),(261,51),(261,52),(261,53),(263,54),(263,55),(269,56),(275,57),(275,58),(304,59),(664,59),(311,60),(311,61),(331,62),(332,62),(333,62),(334,62),(335,62),(342,62),(343,62),(344,62),(345,62),(346,62),(347,62),(354,62),(356,62),(357,62),(358,62),(359,62),(360,62),(361,62),(362,62),(363,62),(364,62),(365,62),(366,62),(367,62),(368,62),(369,62),(370,62),(371,62),(372,62),(373,62),(374,62),(375,62),(376,62),(377,62),(378,62),(379,62),(380,62),(381,62),(382,62),(383,62),(384,62),(385,62),(386,62),(387,62),(388,62),(389,62),(390,62),(391,62),(392,62),(393,62),(394,62),(395,62),(396,62),(397,62),(398,62),(408,62),(409,62),(333,63),(403,64),(403,65),(410,66),(414,67),(425,68),(431,69),(432,69),(433,69),(453,70),(460,71),(460,72),(466,73),(466,74),(622,75),(632,76),(651,77),(657,78),(678,79),(689,80),(696,81),(701,82),(707,83),(711,84),(711,85),(711,86),(712,87),(732,88),(733,89),(804,90),(804,91),(805,92),(805,93),(806,94),(806,95),(807,96),(807,97),(808,98),(808,99),(809,100),(810,101),(811,102),(812,103),(812,104),(816,105),(816,106);
/*!40000 ALTER TABLE `help_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_topic`
--

DROP TABLE IF EXISTS `help_topic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_topic` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `help_category_id` smallint(5) unsigned NOT NULL,
  `description` text NOT NULL,
  `example` text NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_topic_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help topics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_topic`
--

LOCK TABLES `help_topic` WRITE;
/*!40000 ALTER TABLE `help_topic` DISABLE KEYS */;
INSERT INTO `help_topic` (`help_topic_id`, `name`, `help_category_id`, `description`, `example`, `url`) VALUES (1,'HELP_DATE',9,'Help Contents generated from the MariaDB Knowledge Base on 23 January 2023.','',''),(2,'HELP_VERSION',9,'Help Contents generated for MariaDB 10.5 from the MariaDB Knowledge Base on 23 January 2023.','',''),(3,'AREA',2,'A synonym for ST_AREA.\n\nURL: https://mariadb.com/kb/en/polygon-properties-area/','','https://mariadb.com/kb/en/polygon-properties-area/'),(4,'CENTROID',2,'A synonym for ST_CENTROID.\n\nURL: https://mariadb.com/kb/en/centroid/','','https://mariadb.com/kb/en/centroid/'),(5,'ExteriorRing',2,'A synonym for ST_ExteriorRing.\n\nURL: https://mariadb.com/kb/en/polygon-properties-exteriorring/','','https://mariadb.com/kb/en/polygon-properties-exteriorring/'),(6,'InteriorRingN',2,'A synonym for ST_InteriorRingN.\n\nURL: https://mariadb.com/kb/en/polygon-properties-interiorringn/','','https://mariadb.com/kb/en/polygon-properties-interiorringn/'),(7,'NumInteriorRings',2,'A synonym for ST_NumInteriorRings.\n\nURL: https://mariadb.com/kb/en/polygon-properties-numinteriorrings/','','https://mariadb.com/kb/en/polygon-properties-numinteriorrings/'),(8,'ST_AREA',2,'Syntax\n------\n\nST_Area(poly)\nArea(poly)\n\nDescription\n-----------\n\nReturns as a double-precision number the area of the Polygon value poly, as\nmeasured in its spatial reference system.\n\nST_Area() and Area() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\n\nSELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+\n\nURL: https://mariadb.com/kb/en/st_area/','','https://mariadb.com/kb/en/st_area/'),(9,'ST_CENTROID',2,'Syntax\n------\n\nST_Centroid(mpoly)\nCentroid(mpoly)\n\nDescription\n-----------\n\nReturns a point reflecting the mathematical centroid (geometric center) for\nthe MultiPolygon mpoly. The resulting point will not necessarily be on the\nMultiPolygon.\n\nST_Centroid() and Centroid() are synonyms.\n\nExamples\n--------\n\nSET @poly = ST_GeomFromText(\'POLYGON((0 0,20 0,20 20,0 20,0 0))\');\nSELECT ST_AsText(ST_Centroid(@poly)) AS center;\n+--------------+\n| center       |\n+--------------+\n| POINT(10 10) |\n+--------------+\n\nURL: https://mariadb.com/kb/en/st_centroid/','','https://mariadb.com/kb/en/st_centroid/'),(10,'ST_ExteriorRing',2,'Syntax\n------\n\nST_ExteriorRing(poly)\nExteriorRing(poly)\n\nDescription\n-----------\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nST_ExteriorRing() and ExteriorRing() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_exteriorring/','','https://mariadb.com/kb/en/st_exteriorring/'),(11,'ST_InteriorRingN',2,'Syntax\n------\n\nST_InteriorRingN(poly,N)\nInteriorRingN(poly,N)\n\nDescription\n-----------\n\nReturns the N-th interior ring for the Polygon value poly as a LineString.\nRings are numbered beginning with 1.\n\nST_InteriorRingN() and InteriorRingN() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_interiorringn/','','https://mariadb.com/kb/en/st_interiorringn/'),(12,'ST_NumInteriorRings',2,'Syntax\n------\n\nST_NumInteriorRings(poly)\nNumInteriorRings(poly)\n\nDescription\n-----------\n\nReturns an integer containing the number of interior rings in the Polygon\nvalue poly.\n\nNote that according the the OpenGIS standard, a POLYGON should have exactly\none ExteriorRing and all other rings should lie within that ExteriorRing and\nthus be the InteriorRings. Practically, however, some systems, including\nMariaDB\'s, permit polygons to have several \'ExteriorRings\'. In the case of\nthere being multiple, non-overlapping exterior rings ST_NumInteriorRings()\nwill return 1.\n\nST_NumInteriorRings() and NumInteriorRings() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\n\nNon-overlapping \'polygon\':\n\nSELECT ST_NumInteriorRings(ST_PolyFromText(\'POLYGON((0 0,10 0,10 10,0 10,0 0),\n (-1 -1,-5 -1,-5 -5,-1 -5,-1 -1))\')) AS NumInteriorRings;\n+------------------+\n| NumInteriorRings |\n+------------------+\n|                1 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/st_numinteriorrings/','','https://mariadb.com/kb/en/st_numinteriorrings/'),(14,'AsText',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-astext/','','https://mariadb.com/kb/en/wkt-astext/'),(15,'AsWKT',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-aswkt/','','https://mariadb.com/kb/en/wkt-aswkt/'),(16,'GeomCollFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomcollfromtext/','','https://mariadb.com/kb/en/wkt-geomcollfromtext/'),(17,'GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/geometrycollectionfromtext/','','https://mariadb.com/kb/en/geometrycollectionfromtext/'),(18,'GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/geometryfromtext/','','https://mariadb.com/kb/en/geometryfromtext/'),(19,'GeomFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomfromtext/','','https://mariadb.com/kb/en/wkt-geomfromtext/'),(20,'LineFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/wkt-linefromtext/','','https://mariadb.com/kb/en/wkt-linefromtext/'),(21,'LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/linestringfromtext/','','https://mariadb.com/kb/en/linestringfromtext/'),(22,'MLineFromText',3,'Syntax\n------\n\nMLineFromText(wkt[,srid])\nMultiLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTILINESTRING value using its WKT representation and SRID.\n\nMLineFromText() and MultiLineStringFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nSHOW FIELDS FROM gis_multi_line;\nINSERT INTO gis_multi_line VALUES\n  (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16\n23,16 48))\')),\n  (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n  (MLineFromWKB(AsWKB(MultiLineString(\n   LineString(Point(1, 2), Point(3, 5)),\n   LineString(Point(2, 5), Point(5, 8), Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/mlinefromtext/','','https://mariadb.com/kb/en/mlinefromtext/'),(23,'MPointFromText',3,'Syntax\n------\n\nMPointFromText(wkt[,srid])\nMultiPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n\nMPointFromText() and MultiPointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nSHOW FIELDS FROM gis_multi_point;\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/mpointfromtext/','','https://mariadb.com/kb/en/mpointfromtext/'),(13,'WKT Definition',3,'Description\n-----------\n\nThe Well-Known Text (WKT) representation of Geometry is designed to exchange\ngeometry data in ASCII form. Examples of the basic geometry types include:\n\n+-----------------------------------------------------------------------------+\n| Geometry Types                                                              |\n+-----------------------------------------------------------------------------+\n| POINT                                                                       |\n+-----------------------------------------------------------------------------+\n| LINESTRING                                                                  |\n+-----------------------------------------------------------------------------+\n| POLYGON                                                                     |\n+-----------------------------------------------------------------------------+\n| MULTIPOINT                                                                  |\n+-----------------------------------------------------------------------------+\n| MULTILINESTRING                                                             |\n+-----------------------------------------------------------------------------+\n| MULTIPOLYGON                                                                |\n+-----------------------------------------------------------------------------+\n| GEOMETRYCOLLECTION                                                          |\n+-----------------------------------------------------------------------------+\n| GEOMETRY                                                                    |\n+-----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/wkt-definition/','','https://mariadb.com/kb/en/wkt-definition/'),(24,'MPolyFromText',3,'Syntax\n------\n\nMPolyFromText(wkt[,srid])\nMultiPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n\nMPolyFromText() and MultiPolygonFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_polygon  (g MULTIPOLYGON);\nSHOW FIELDS FROM gis_multi_polygon;\nINSERT INTO gis_multi_polygon VALUES\n  (MultiPolygonFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromWKB(AsWKB(MultiPolygon(Polygon(\n   LineString(Point(0, 3), Point(3, 3), Point(3, 0), Point(0, 3)))))));\n\nURL: https://mariadb.com/kb/en/mpolyfromtext/','','https://mariadb.com/kb/en/mpolyfromtext/'),(25,'MultiLineStringFromText',3,'A synonym for MLineFromText.\n\nURL: https://mariadb.com/kb/en/multilinestringfromtext/','','https://mariadb.com/kb/en/multilinestringfromtext/'),(26,'MultiPointFromText',3,'A synonym for MPointFromText.\n\nURL: https://mariadb.com/kb/en/multipointfromtext/','','https://mariadb.com/kb/en/multipointfromtext/'),(27,'MultiPolygonFromText',3,'A synonym for MPolyFromText.\n\nURL: https://mariadb.com/kb/en/multipolygonfromtext/','','https://mariadb.com/kb/en/multipolygonfromtext/'),(28,'PointFromText',3,'A synonym for ST_PointFromText.\n\nURL: https://mariadb.com/kb/en/wkt-pointfromtext/','','https://mariadb.com/kb/en/wkt-pointfromtext/'),(29,'PolyFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/wkt-polyfromtext/','','https://mariadb.com/kb/en/wkt-polyfromtext/'),(30,'PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/polygonfromtext/','','https://mariadb.com/kb/en/polygonfromtext/'),(31,'ST_AsText',3,'Syntax\n------\n\nST_AsText(g)\nAsText(g)\nST_AsWKT(g)\nAsWKT(g)\n\nDescription\n-----------\n\nConverts a value in internal geometry format to its WKT representation and\nreturns the string result.\n\nST_AsText(), AsText(), ST_AsWKT() and AsWKT() are all synonyms.\n\nExamples\n--------\n\nSET @g = \'LineString(1 1,4 4,6 6)\';\n\nSELECT ST_AsText(ST_GeomFromText(@g));\n+--------------------------------+\n| ST_AsText(ST_GeomFromText(@g)) |\n+--------------------------------+\n| LINESTRING(1 1,4 4,6 6)        |\n+--------------------------------+\n\nURL: https://mariadb.com/kb/en/st_astext/','','https://mariadb.com/kb/en/st_astext/'),(32,'ST_ASWKT',3,'A synonym for ST_ASTEXT().\n\nURL: https://mariadb.com/kb/en/st_aswkt/','','https://mariadb.com/kb/en/st_aswkt/'),(33,'ST_GeomCollFromText',3,'Syntax\n------\n\nST_GeomCollFromText(wkt[,srid])\nST_GeometryCollectionFromText(wkt[,srid])\nGeomCollFromText(wkt[,srid])\nGeometryCollectionFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and SRID.\n\nST_GeomCollFromText(), ST_GeometryCollectionFromText(), GeomCollFromText() and\nGeometryCollectionFromText() are all synonyms.\n\nExample\n-------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/st_geomcollfromtext/','','https://mariadb.com/kb/en/st_geomcollfromtext/'),(34,'ST_GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/st_geometrycollectionfromtext/','','https://mariadb.com/kb/en/st_geometrycollectionfromtext/'),(35,'ST_GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/st_geometryfromtext/','','https://mariadb.com/kb/en/st_geometryfromtext/'),(36,'ST_GeomFromText',3,'Syntax\n------\n\nST_GeomFromText(wkt[,srid])\nST_GeometryFromText(wkt[,srid])\nGeomFromText(wkt[,srid])\nGeometryFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a geometry value of any type using its WKT representation and SRID.\n\nGeomFromText(), GeometryFromText(), ST_GeomFromText() and\nST_GeometryFromText() are all synonyms.\n\nExample\n-------\n\nSET @g = ST_GEOMFROMTEXT(\'POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1 1))\');\n\nURL: https://mariadb.com/kb/en/st_geomfromtext/','','https://mariadb.com/kb/en/st_geomfromtext/'),(37,'ST_LineFromText',3,'Syntax\n------\n\nST_LineFromText(wkt[,srid])\nST_LineStringFromText(wkt[,srid])\nLineFromText(wkt[,srid])\nLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a LINESTRING value using its WKT representation and SRID.\n\nST_LineFromText(), ST_LineStringFromText(), ST_LineFromText() and\nST_LineStringFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_line  (g LINESTRING);\nSHOW FIELDS FROM gis_line;\nINSERT INTO gis_line VALUES\n  (LineFromText(\'LINESTRING(0 0,0 10,10 0)\')),\n  (LineStringFromText(\'LINESTRING(10 10,20 10,20 20,10 20,10 10)\')),\n  (LineStringFromWKB(AsWKB(LineString(Point(10, 10), Point(40, 10)))));\n\nURL: https://mariadb.com/kb/en/st_linefromtext/','','https://mariadb.com/kb/en/st_linefromtext/'),(38,'ST_LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/st_linestringfromtext/','','https://mariadb.com/kb/en/st_linestringfromtext/'),(39,'ST_PointFromText',3,'Syntax\n------\n\nST_PointFromText(wkt[,srid])\nPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POINT value using its WKT representation and SRID.\n\nST_PointFromText() and PointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_point  (g POINT);\nSHOW FIELDS FROM gis_point;\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/st_pointfromtext/','','https://mariadb.com/kb/en/st_pointfromtext/'),(40,'ST_PolyFromText',3,'Syntax\n------\n\nST_PolyFromText(wkt[,srid])\nST_PolygonFromText(wkt[,srid])\nPolyFromText(wkt[,srid])\nPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POLYGON value using its WKT representation and SRID.\n\nST_PolyFromText(), ST_PolygonFromText(), PolyFromText() and\nST_PolygonFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_polygon   (g POLYGON);\nINSERT INTO gis_polygon VALUES\n  (PolygonFromText(\'POLYGON((10 10,20 10,20 20,10 20,10 10))\')),\n  (PolyFromText(\'POLYGON((0 0,50 0,50 50,0 50,0 0), (10 10,20 10,20 20,10\n20,10 10))\'));\n\nURL: https://mariadb.com/kb/en/st_polyfromtext/','','https://mariadb.com/kb/en/st_polyfromtext/'),(41,'ST_PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/st_polygonfromtext/','','https://mariadb.com/kb/en/st_polygonfromtext/'),(42,'DIV',4,'Syntax\n------\n\nDIV\n\nDescription\n-----------\n\nInteger division. Similar to FLOOR(), but is safe with BIGINT values.\nIncorrect results may occur for non-integer operands that exceed BIGINT range.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, a division by zero produces\nan error. Otherwise, it returns NULL.\n\nThe remainder of a division can be obtained using the MOD operator.\n\nExamples\n--------\n\nSELECT 300 DIV 7;\n+-----------+\n| 300 DIV 7 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT 300 DIV 0;\n+-----------+\n| 300 DIV 0 |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/div/','','https://mariadb.com/kb/en/div/'),(43,'ABS',4,'Syntax\n------\n\nABS(X)\n\nDescription\n-----------\n\nReturns the absolute (non-negative) value of X. If X is not a number, it is\nconverted to a numeric type.\n\nExamples\n--------\n\nSELECT ABS(42);\n+---------+\n| ABS(42) |\n+---------+\n|      42 |\n+---------+\n\nSELECT ABS(-42);\n+----------+\n| ABS(-42) |\n+----------+\n|       42 |\n+----------+\n\nSELECT ABS(DATE \'1994-01-01\');\n+------------------------+\n| ABS(DATE \'1994-01-01\') |\n+------------------------+\n|               19940101 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/abs/','','https://mariadb.com/kb/en/abs/'),(44,'ACOS',4,'Syntax\n------\n\nACOS(X)\n\nDescription\n-----------\n\nReturns the arc cosine of X, that is, the value whose cosine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ACOS(1);\n+---------+\n| ACOS(1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ACOS(1.0001);\n+--------------+\n| ACOS(1.0001) |\n+--------------+\n|         NULL |\n+--------------+\n\nSELECT ACOS(0);\n+-----------------+\n| ACOS(0)         |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT ACOS(0.234);\n+------------------+\n| ACOS(0.234)      |\n+------------------+\n| 1.33460644244679 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/acos/','','https://mariadb.com/kb/en/acos/'),(45,'ASIN',4,'Syntax\n------\n\nASIN(X)\n\nDescription\n-----------\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns NULL if\nX is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ASIN(0.2);\n+--------------------+\n| ASIN(0.2)          |\n+--------------------+\n| 0.2013579207903308 |\n+--------------------+\n\nSELECT ASIN(\'foo\');\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n\nSHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n\nURL: https://mariadb.com/kb/en/asin/','','https://mariadb.com/kb/en/asin/'),(46,'ATAN',4,'Syntax\n------\n\nATAN(X)\n\nDescription\n-----------\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nExamples\n--------\n\nSELECT ATAN(2);\n+--------------------+\n| ATAN(2)            |\n+--------------------+\n| 1.1071487177940904 |\n+--------------------+\n\nSELECT ATAN(-2);\n+---------------------+\n| ATAN(-2)            |\n+---------------------+\n| -1.1071487177940904 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/atan/','','https://mariadb.com/kb/en/atan/'),(47,'ATAN2',4,'Syntax\n------\n\nATAN(Y,X), ATAN2(Y,X)\n\nDescription\n-----------\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both arguments\nare used to determine the quadrant of the result.\n\nExamples\n--------\n\nSELECT ATAN(-2,2);\n+---------------------+\n| ATAN(-2,2)          |\n+---------------------+\n| -0.7853981633974483 |\n+---------------------+\n\nSELECT ATAN2(PI(),0);\n+--------------------+\n| ATAN2(PI(),0)      |\n+--------------------+\n| 1.5707963267948966 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/atan2/','','https://mariadb.com/kb/en/atan2/'),(48,'CEIL',4,'Syntax\n------\n\nCEIL(X)\n\nDescription\n-----------\n\nCEIL() is a synonym for CEILING().\n\nURL: https://mariadb.com/kb/en/ceil/','','https://mariadb.com/kb/en/ceil/'),(49,'CEILING',4,'Syntax\n------\n\nCEILING(X)\n\nDescription\n-----------\n\nReturns the smallest integer value not less than X.\n\nExamples\n--------\n\nSELECT CEILING(1.23);\n+---------------+\n| CEILING(1.23) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT CEILING(-1.23);\n+----------------+\n| CEILING(-1.23) |\n+----------------+\n|             -1 |\n+----------------+\n\nURL: https://mariadb.com/kb/en/ceiling/','','https://mariadb.com/kb/en/ceiling/'),(51,'COS',4,'Syntax\n------\n\nCOS(X)\n\nDescription\n-----------\n\nReturns the cosine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT COS(PI());\n+-----------+\n| COS(PI()) |\n+-----------+\n|        -1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/cos/','','https://mariadb.com/kb/en/cos/'),(52,'COT',4,'Syntax\n------\n\nCOT(X)\n\nDescription\n-----------\n\nReturns the cotangent of X.\n\nExamples\n--------\n\nSELECT COT(42);\n+--------------------+\n| COT(42)            |\n+--------------------+\n| 0.4364167060752729 |\n+--------------------+\n\nSELECT COT(12);\n+---------------------+\n| COT(12)             |\n+---------------------+\n| -1.5726734063976893 |\n+---------------------+\n\nSELECT COT(0);\nERROR 1690 (22003): DOUBLE value is out of range in \'cot(0)\'\n\nURL: https://mariadb.com/kb/en/cot/','','https://mariadb.com/kb/en/cot/'),(54,'DEGREES',4,'Syntax\n------\n\nDEGREES(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from radians to degrees.\n\nThis is the converse of the RADIANS() function.\n\nExamples\n--------\n\nSELECT DEGREES(PI());\n+---------------+\n| DEGREES(PI()) |\n+---------------+\n|           180 |\n+---------------+\n\nSELECT DEGREES(PI() / 2);\n+-------------------+\n| DEGREES(PI() / 2) |\n+-------------------+\n|                90 |\n+-------------------+\n\nSELECT DEGREES(45);\n+-----------------+\n| DEGREES(45)     |\n+-----------------+\n| 2578.3100780887 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/degrees/','','https://mariadb.com/kb/en/degrees/'),(55,'EXP',4,'Syntax\n------\n\nEXP(X)\n\nDescription\n-----------\n\nReturns the value of e (the base of natural logarithms) raised to the power of\nX. The inverse of this function is LOG() (using a single argument only) or\nLN().\n\nIf X is NULL, this function returns NULL.\n\nExamples\n--------\n\nSELECT EXP(2);\n+------------------+\n| EXP(2)           |\n+------------------+\n| 7.38905609893065 |\n+------------------+\n\nSELECT EXP(-2);\n+--------------------+\n| EXP(-2)            |\n+--------------------+\n| 0.1353352832366127 |\n+--------------------+\n\nSELECT EXP(0);\n+--------+\n| EXP(0) |\n+--------+\n|      1 |\n+--------+\n\nSELECT EXP(NULL);\n+-----------+\n| EXP(NULL) |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/exp/','','https://mariadb.com/kb/en/exp/'),(50,'CONV',4,'Syntax\n------\n\nCONV(N,from_base,to_base)\n\nDescription\n-----------\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base to_base.\n\nReturns NULL if any argument is NULL, or if the second or third argument are\nnot in the allowed range.\n\nThe argument N is interpreted as an integer, but may be specified as an\ninteger or a string. The minimum base is 2 and the maximum base is 36. If\nto_base is a negative number, N is regarded as a signed number. Otherwise, N\nis treated as unsigned. CONV() works with 64-bit precision.\n\nSome shortcuts for this function are also available: BIN(), OCT(), HEX(),\nUNHEX(). Also, MariaDB allows binary literal values and hexadecimal literal\nvalues.\n\nExamples\n--------\n\nSELECT CONV(\'a\',16,2);\n+----------------+\n| CONV(\'a\',16,2) |\n+----------------+\n| 1010           |\n+----------------+\n\nSELECT CONV(\'6E\',18,8);\n+-----------------+\n| CONV(\'6E\',18,8) |\n+-----------------+\n| 172             |\n+-----------------+\n\nSELECT CONV(-17,10,-18);\n+------------------+\n| CONV(-17,10,-18) |\n+------------------+\n| -H               |\n+------------------+\n\nSELECT CONV(12+\'10\'+\'10\'+0xa,10,10);\n+------------------------------+\n| CONV(12+\'10\'+\'10\'+0xa,10,10) |\n+------------------------------+\n| 42                           |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/conv/','','https://mariadb.com/kb/en/conv/'),(53,'CRC32',4,'Syntax\n------\n\n<= MariaDB 10.7\n\nCRC32(expr)\n\nFrom MariaDB 10.8\n\nCRC32([par,]expr)\n\nDescription\n-----------\n\nComputes a cyclic redundancy check (CRC) value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is expected to\nbe a string and (if possible) is treated as one if it is not.\n\nUses the ISO 3309 polynomial that used by zlib and many others. MariaDB 10.8\nintroduced the CRC32C() function, which uses the alternate Castagnoli\npolynomia.\n\nMariaDB starting with 10.8\n--------------------------\nOften, CRC is computed in pieces. To facilitate this, MariaDB 10.8.0\nintroduced an optional parameter: CRC32(\'MariaDB\')=CRC32(CRC32(\'Maria\'),\'DB\').\n\nExamples\n--------\n\nSELECT CRC32(\'MariaDB\');\n+------------------+\n| CRC32(\'MariaDB\') |\n+------------------+\n|       4227209140 |\n+------------------+\n\nSELECT CRC32(\'mariadb\');\n+------------------+\n| CRC32(\'mariadb\') |\n+------------------+\n|       2594253378 |\n+------------------+\n\nFrom MariaDB 10.8.0\n\nSELECT CRC32(CRC32(\'Maria\'),\'DB\');\n+----------------------------+\n| CRC32(CRC32(\'Maria\'),\'DB\') |\n+----------------------------+\n|                 4227209140 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/crc32/','','https://mariadb.com/kb/en/crc32/'),(56,'FLOOR',4,'Syntax\n------\n\nFLOOR(X)\n\nDescription\n-----------\n\nReturns the largest integer value not greater than X.\n\nExamples\n--------\n\nSELECT FLOOR(1.23);\n+-------------+\n| FLOOR(1.23) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT FLOOR(-1.23);\n+--------------+\n| FLOOR(-1.23) |\n+--------------+\n|           -2 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/floor/','','https://mariadb.com/kb/en/floor/'),(57,'LN',4,'Syntax\n------\n\nLN(X)\n\nDescription\n-----------\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X. If X\nis less than or equal to 0, or NULL, then NULL is returned.\n\nThe inverse of this function is EXP().\n\nExamples\n--------\n\nSELECT LN(2);\n+-------------------+\n| LN(2)             |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LN(-2);\n+--------+\n| LN(-2) |\n+--------+\n|   NULL |\n+--------+\n\nURL: https://mariadb.com/kb/en/ln/','','https://mariadb.com/kb/en/ln/'),(58,'LOG',4,'Syntax\n------\n\nLOG(X), LOG(B,X)\n\nDescription\n-----------\n\nIf called with one parameter, this function returns the natural logarithm of\nX. If X is less than or equal to 0, then NULL is returned.\n\nIf called with two parameters, it returns the logarithm of X to the base B. If\nB is <= 1 or X <= 0, the function returns NULL.\n\nIf any argument is NULL, the function returns NULL.\n\nThe inverse of this function (when called with a single argument) is the EXP()\nfunction.\n\nExamples\n--------\n\nLOG(X):\n\nSELECT LOG(2);\n+-------------------+\n| LOG(2)            |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LOG(-2);\n+---------+\n| LOG(-2) |\n+---------+\n|    NULL |\n+---------+\n\nLOG(B,X)\n\nSELECT LOG(2,16);\n+-----------+\n| LOG(2,16) |\n+-----------+\n|         4 |\n+-----------+\n\nSELECT LOG(3,27);\n+-----------+\n| LOG(3,27) |\n+-----------+\n|         3 |\n+-----------+\n\nSELECT LOG(3,1);\n+----------+\n| LOG(3,1) |\n+----------+\n|        0 |\n+----------+\n\nSELECT LOG(3,0);\n+----------+\n| LOG(3,0) |\n+----------+\n|     NULL |\n+----------+\n\nURL: https://mariadb.com/kb/en/log/','','https://mariadb.com/kb/en/log/'),(59,'LOG10',4,'Syntax\n------\n\nLOG10(X)\n\nDescription\n-----------\n\nReturns the base-10 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG10(2);\n+-------------------+\n| LOG10(2)          |\n+-------------------+\n| 0.301029995663981 |\n+-------------------+\n\nSELECT LOG10(100);\n+------------+\n| LOG10(100) |\n+------------+\n|          2 |\n+------------+\n\nSELECT LOG10(-100);\n+-------------+\n| LOG10(-100) |\n+-------------+\n|        NULL |\n+-------------+\n\nURL: https://mariadb.com/kb/en/log10/','','https://mariadb.com/kb/en/log10/'),(60,'LOG2',4,'Syntax\n------\n\nLOG2(X)\n\nDescription\n-----------\n\nReturns the base-2 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG2(4398046511104);\n+---------------------+\n| LOG2(4398046511104) |\n+---------------------+\n|                  42 |\n+---------------------+\n\nSELECT LOG2(65536);\n+-------------+\n| LOG2(65536) |\n+-------------+\n|          16 |\n+-------------+\n\nSELECT LOG2(-100);\n+------------+\n| LOG2(-100) |\n+------------+\n|       NULL |\n+------------+\n\nURL: https://mariadb.com/kb/en/log2/','','https://mariadb.com/kb/en/log2/'),(62,'OCT',4,'Syntax\n------\n\nOCT(N)\n\nDescription\n-----------\n\nReturns a string representation of the octal value of N, where N is a longlong\n(BIGINT) number. This is equivalent to CONV(N,10,8). Returns NULL if N is NULL.\n\nExamples\n--------\n\nSELECT OCT(34);\n+---------+\n| OCT(34) |\n+---------+\n| 42      |\n+---------+\n\nSELECT OCT(12);\n+---------+\n| OCT(12) |\n+---------+\n| 14      |\n+---------+\n\nURL: https://mariadb.com/kb/en/oct/','','https://mariadb.com/kb/en/oct/'),(63,'PI',4,'Syntax\n------\n\nPI()\n\nDescription\n-----------\n\nReturns the value of π (pi). The default number of decimal places displayed is\nsix, but MariaDB uses the full double-precision value internally.\n\nExamples\n--------\n\nSELECT PI();\n+----------+\n| PI()     |\n+----------+\n| 3.141593 |\n+----------+\n\nSELECT PI()+0.0000000000000000000000;\n+-------------------------------+\n| PI()+0.0000000000000000000000 |\n+-------------------------------+\n|      3.1415926535897931159980 |\n+-------------------------------+\n\nURL: https://mariadb.com/kb/en/pi/','','https://mariadb.com/kb/en/pi/'),(64,'POW',4,'Syntax\n------\n\nPOW(X,Y)\n\nDescription\n-----------\n\nReturns the value of X raised to the power of Y.\n\nPOWER() is a synonym.\n\nExamples\n--------\n\nSELECT POW(2,3);\n+----------+\n| POW(2,3) |\n+----------+\n|        8 |\n+----------+\n\nSELECT POW(2,-2);\n+-----------+\n| POW(2,-2) |\n+-----------+\n|      0.25 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/pow/','','https://mariadb.com/kb/en/pow/'),(65,'POWER',4,'Syntax\n------\n\nPOWER(X,Y)\n\nDescription\n-----------\n\nThis is a synonym for POW(), which returns the value of X raised to the power\nof Y.\n\nURL: https://mariadb.com/kb/en/power/','','https://mariadb.com/kb/en/power/'),(61,'MOD',4,'Syntax\n------\n\nMOD(N,M), N % M, N MOD M\n\nDescription\n-----------\n\nModulo operation. Returns the remainder of N divided by M. See also Modulo\nOperator.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, any number modulus zero\nproduces an error. Otherwise, it returns NULL.\n\nThe integer part of a division can be obtained using DIV.\n\nExamples\n--------\n\nSELECT 1042 % 50;\n+-----------+\n| 1042 % 50 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT MOD(234, 10);\n+--------------+\n| MOD(234, 10) |\n+--------------+\n|            4 |\n+--------------+\n\nSELECT 253 % 7;\n+---------+\n| 253 % 7 |\n+---------+\n|       1 |\n+---------+\n\nSELECT MOD(29,9);\n+-----------+\n| MOD(29,9) |\n+-----------+\n|         2 |\n+-----------+\n\nSELECT 29 MOD 9;\n+----------+\n| 29 MOD 9 |\n+----------+\n|        2 |\n+----------+\n\nURL: https://mariadb.com/kb/en/mod/','','https://mariadb.com/kb/en/mod/'),(66,'RADIANS',4,'Syntax\n------\n\nRADIANS(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from degrees to radians. Note that π radians\nequals 180 degrees.\n\nThis is the converse of the DEGREES() function.\n\nExamples\n--------\n\nSELECT RADIANS(45);\n+-------------------+\n| RADIANS(45)       |\n+-------------------+\n| 0.785398163397448 |\n+-------------------+\n\nSELECT RADIANS(90);\n+-----------------+\n| RADIANS(90)     |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT RADIANS(PI());\n+--------------------+\n| RADIANS(PI())      |\n+--------------------+\n| 0.0548311355616075 |\n+--------------------+\n\nSELECT RADIANS(180);\n+------------------+\n| RADIANS(180)     |\n+------------------+\n| 3.14159265358979 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/radians/','','https://mariadb.com/kb/en/radians/'),(67,'RAND',4,'Syntax\n------\n\nRAND(), RAND(N)\n\nDescription\n-----------\n\nReturns a random DOUBLE precision floating point value v in the range 0 <= v <\n1.0. If a constant integer argument N is specified, it is used as the seed\nvalue, which produces a repeatable sequence of column values. In the example\nbelow, note that the sequences of values produced by RAND(3) is the same both\nplaces where it occurs.\n\nIn a WHERE clause, RAND() is evaluated each time the WHERE is executed.\n\nStatements using the RAND() function are not safe for statement-based\nreplication.\n\nPractical uses\n--------------\n\nThe expression to get a random integer from a given range is the following:\n\nFLOOR(min_value + RAND() * (max_value - min_value +1))\n\nRAND() is often used to read random rows from a table, as follows:\n\nSELECT * FROM my_table ORDER BY RAND() LIMIT 10;\n\nNote, however, that this technique should never be used on a large table as it\nwill be extremely slow. MariaDB will read all rows in the table, generate a\nrandom value for each of them, order them, and finally will apply the LIMIT\nclause.\n\nExamples\n--------\n\nCREATE TABLE t (i INT);\n\nINSERT INTO t VALUES(1),(2),(3);\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.255651095188829 |\n|    2 | 0.833920199269355 |\n|    3 |  0.40264774151393 |\n+------+-------------------+\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.511478140495232 |\n|    2 | 0.349447508668012 |\n|    3 | 0.212803152588013 |\n+------+-------------------+\n\nUsing the same seed, the same sequence will be returned:\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nGenerating a random number from 5 to 15:\n\nSELECT FLOOR(5 + (RAND() * 11));\n\nURL: https://mariadb.com/kb/en/rand/','','https://mariadb.com/kb/en/rand/'),(68,'ROUND',4,'Syntax\n------\n\nROUND(X), ROUND(X,D)\n\nDescription\n-----------\n\nRounds the argument X to D decimal places. D defaults to 0 if not specified. D\ncan be negative to cause D digits left of the decimal point of the value X to\nbecome zero.\n\nThe rounding algorithm depends on the data type of X:\n\n* for floating point types (FLOAT, DOUBLE) the C libraries rounding function\nis used, so the behavior *may* differ between operating systems\n* for fixed point types (DECIMAL, DEC/NUMBER/FIXED) the \"round half up\" rule\nis used, meaning that e.g. a value ending in exactly .5 is always rounded up.\n\nExamples\n--------\n\nSELECT ROUND(-1.23);\n+--------------+\n| ROUND(-1.23) |\n+--------------+\n|           -1 |\n+--------------+\n\nSELECT ROUND(-1.58);\n+--------------+\n| ROUND(-1.58) |\n+--------------+\n|           -2 |\n+--------------+\n\nSELECT ROUND(1.58); \n+-------------+\n| ROUND(1.58) |\n+-------------+\n|           2 |\n+-------------+\n\nSELECT ROUND(1.298, 1);\n+-----------------+\n| ROUND(1.298, 1) |\n+-----------------+\n|             1.3 |\n+-----------------+\n\nSELECT ROUND(1.298, 0);\n+-----------------+\n| ROUND(1.298, 0) |\n+-----------------+\n|               1 |\n+-----------------+\n\nSELECT ROUND(23.298, -1);\n+-------------------+\n| ROUND(23.298, -1) |\n+-------------------+\n|                20 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/round/','','https://mariadb.com/kb/en/round/'),(69,'SIGN',4,'Syntax\n------\n\nSIGN(X)\n\nDescription\n-----------\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X is\nnegative, zero, or positive.\n\nExamples\n--------\n\nSELECT SIGN(-32);\n+-----------+\n| SIGN(-32) |\n+-----------+\n|        -1 |\n+-----------+\n\nSELECT SIGN(0);\n+---------+\n| SIGN(0) |\n+---------+\n|       0 |\n+---------+\n\nSELECT SIGN(234);\n+-----------+\n| SIGN(234) |\n+-----------+\n|         1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/sign/','','https://mariadb.com/kb/en/sign/'),(70,'SIN',4,'Syntax\n------\n\nSIN(X)\n\nDescription\n-----------\n\nReturns the sine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT SIN(1.5707963267948966);\n+-------------------------+\n| SIN(1.5707963267948966) |\n+-------------------------+\n|                       1 |\n+-------------------------+\n\nSELECT SIN(PI());\n+----------------------+\n| SIN(PI())            |\n+----------------------+\n| 1.22460635382238e-16 |\n+----------------------+\n\nSELECT ROUND(SIN(PI()));\n+------------------+\n| ROUND(SIN(PI())) |\n+------------------+\n|                0 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/sin/','','https://mariadb.com/kb/en/sin/'),(71,'SQRT',4,'Syntax\n------\n\nSQRT(X)\n\nDescription\n-----------\n\nReturns the square root of X. If X is negative, NULL is returned.\n\nExamples\n--------\n\nSELECT SQRT(4);\n+---------+\n| SQRT(4) |\n+---------+\n|       2 |\n+---------+\n\nSELECT SQRT(20);\n+------------------+\n| SQRT(20)         |\n+------------------+\n| 4.47213595499958 |\n+------------------+\n\nSELECT SQRT(-16);\n+-----------+\n| SQRT(-16) |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT SQRT(1764);\n+------------+\n| SQRT(1764) |\n+------------+\n|         42 |\n+------------+\n\nURL: https://mariadb.com/kb/en/sqrt/','','https://mariadb.com/kb/en/sqrt/'),(72,'TAN',4,'Syntax\n------\n\nTAN(X)\n\nDescription\n-----------\n\nReturns the tangent of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT TAN(0.7853981633974483);\n+-------------------------+\n| TAN(0.7853981633974483) |\n+-------------------------+\n|      0.9999999999999999 |\n+-------------------------+\n\nSELECT TAN(PI());\n+-----------------------+\n| TAN(PI())             |\n+-----------------------+\n| -1.22460635382238e-16 |\n+-----------------------+\n\nSELECT TAN(PI()+1);\n+-----------------+\n| TAN(PI()+1)     |\n+-----------------+\n| 1.5574077246549 |\n+-----------------+\n\nSELECT TAN(RADIANS(PI()));\n+--------------------+\n| TAN(RADIANS(PI())) |\n+--------------------+\n| 0.0548861508080033 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/tan/','','https://mariadb.com/kb/en/tan/'),(73,'TRUNCATE',4,'This page documents the TRUNCATE function. See TRUNCATE TABLE for the DDL\nstatement.\n\nSyntax\n------\n\nTRUNCATE(X,D)\n\nDescription\n-----------\n\nReturns the number X, truncated to D decimal places. If D is 0, the result has\nno decimal point or fractional part. D can be negative to cause D digits left\nof the decimal point of the value X to become zero.\n\nExamples\n--------\n\nSELECT TRUNCATE(1.223,1);\n+-------------------+\n| TRUNCATE(1.223,1) |\n+-------------------+\n|               1.2 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,1);\n+-------------------+\n| TRUNCATE(1.999,1) |\n+-------------------+\n|               1.9 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,0); \n+-------------------+\n| TRUNCATE(1.999,0) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSELECT TRUNCATE(-1.999,1);\n+--------------------+\n| TRUNCATE(-1.999,1) |\n+--------------------+\n|               -1.9 |\n+--------------------+\n\nSELECT TRUNCATE(122,-2);\n+------------------+\n| TRUNCATE(122,-2) |\n+------------------+\n|              100 |\n+------------------+\n\nSELECT TRUNCATE(10.28*100,0);\n+-----------------------+\n| TRUNCATE(10.28*100,0) |\n+-----------------------+\n|                  1028 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/truncate/','','https://mariadb.com/kb/en/truncate/'),(74,'INSTALL PLUGIN',5,'Syntax\n------\n\nINSTALL PLUGIN [IF NOT EXISTS] plugin_name SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement installs an individual plugin from the specified library. To\ninstall the whole library (which could be required), use INSTALL SONAME. See\nalso Installing a Plugin.\n\nplugin_name is the name of the plugin as defined in the plugin declaration\nstructure contained in the library file. Plugin names are not case sensitive.\nFor maximal compatibility, plugin names should be limited to ASCII letters,\ndigits, and underscore, because they are used in C source files, shell command\nlines, M4 and Bourne shell scripts, and SQL environments.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension can be omitted (which makes the statement look\nthe same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL PLUGIN adds a line to the mysql.plugin table that describes the\nplugin. This table contains the plugin name and library file name.\n\nINSTALL PLUGIN causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL PLUGIN also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL PLUGIN, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nPLUGIN only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a note instead of\nan error if the specified plugin already exists. See SHOW WARNINGS.\n\nExamples\n--------\n\nINSTALL PLUGIN sphinx SONAME \'ha_sphinx.so\';\n\nThe extension can also be omitted:\n\nINSTALL PLUGIN innodb SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected (0.104 sec)\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+------------------------------------+\n| Level | Code | Message                            |\n+-------+------+------------------------------------+\n| Note  | 1968 | Plugin \'example\' already installed |\n+-------+------+------------------------------------+\n\nURL: https://mariadb.com/kb/en/install-plugin/','','https://mariadb.com/kb/en/install-plugin/'),(78,'Plugin Overview',5,'Plugins are server components that enhance MariaDB in some way. These can be\nanything from new storage engines, plugins for enhancing full-text parsing, or\neven small enhancements, such as a plugin to get a timestamp as an integer.\n\nQuerying Plugin Information\n---------------------------\n\nThere are a number of ways to see which plugins are currently active.\n\nA server almost always has a large number of active plugins, because the\nserver contains a large number of built-in plugins, which are active by\ndefault and cannot be uninstalled.\n\nQuerying Plugin Information with SHOW PLUGINS\n---------------------------------------------\n\nThe SHOW PLUGINS statement can be used to query information about all active\nplugins.\n\nFor example:\n\nSHOW PLUGINS\\G;\n********************** 1. row **********************\n Name: binlog\n Status: ACTIVE\n Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n********************** 2. row **********************\n Name: mysql_native_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n********************** 3. row **********************\n Name: mysql_old_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n...\n\nIf a plugin\'s Library column has a NULL value, then the plugin is built-in,\nand it cannot be uninstalled.\n\nQuerying Plugin Information with information_schema.PLUGINS\n-----------------------------------------------------------\n\nThe information_schema.PLUGINS table can be queried to get more detailed\ninformation about plugins.\n\nFor example:\n\nSELECT * FROM information_schema.PLUGINS\\G\n...\n*************************** 6. row ***************************\n     PLUGIN_NAME: CSV\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: Brian Aker, MySQL AB\n  PLUGIN_DESCRIPTION: CSV storage engine\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n*************************** 7. row ***************************\n     PLUGIN_NAME: MEMORY\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: MySQL AB\n  PLUGIN_DESCRIPTION: Hash based, stored in memory, useful for temporary\ntables\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n...\n\nIf a plugin\'s PLUGIN_LIBRARY column has the NULL value, then the plugin is\nbuilt-in, and it cannot be uninstalled.\n\nQuerying Plugin Information with mysql.plugin\n---------------------------------------------\n\nThe mysql.plugin table can be queried to get information about installed\nplugins.\n\nThis table only contains information about plugins that have been installed\nvia the following methods:\n\n* The INSTALL SONAME statement.\n* The INSTALL PLUGIN statement.\n* The mysql_plugin utility.\n\nThis table does not contain information about:\n\n* Built-in plugins.\n* Plugins loaded with the --plugin-load-add option.\n* Plugins loaded with the --plugin-load option.\n\nThis table only contains enough information to reload the plugin when the\nserver is restarted, which means it only contains the plugin name and the\nplugin library.\n\nFor example:\n\nSELECT * FROM mysql.plugin;\n\n+------+------------+\n| name | dl         |\n+------+------------+\n| PBXT | libpbxt.so |\n+------+------------+\n\nInstalling a Plugin\n-------------------\n\nThere are three primary ways to install a plugin:\n\n* A plugin can be installed dynamically with an SQL statement.\n* A plugin can be installed with a mysqld option, but it requires a server\nrestart.\n* A plugin can be installed with the mysql_plugin utility, while the server is\ncompletely offline.\n\nWhen you are installing a plugin, you also have to ensure that:\n\n* The server\'s plugin directory is properly configured, and the plugin\'s\nlibrary is in the plugin directory.\n* The server\'s minimum plugin maturity is properly configured, and the plugin\nis mature enough to be installed.\n\nInstalling a Plugin Dynamically\n-------------------------------\n\nA plugin can be installed dynamically by executing either the INSTALL SONAME\nor the INSTALL PLUGIN statement.\n\nIf a plugin is installed with one of these statements, then a record will be\nadded to the mysql.plugins table for the plugin. This means that the plugin\nwill automatically be loaded every time the server restarts, unless\nspecifically uninstalled or deactivated.\n\nInstalling a Plugin with INSTALL SONAME\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL SONAME\nstatement. INSTALL SONAME installs all plugins from the given plugin library.\nThis could be required for some plugin libraries.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin), you could execute the\nfollowing:\n\nINSTALL SONAME \'server_audit\';\n\nInstalling a Plugin with INSTALL PLUGIN\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL PLUGIN\nstatement. INSTALL PLUGIN installs a single plugin from the given plugin\nlibrary.\n\nFor example, to install the server_audit audit plugin from the server_audit\nplugin library, you could execute the following:\n\nINSTALL PLUGIN server_audit SONAME \'server_audit\';\n\nInstalling a Plugin with Plugin Load Options\n--------------------------------------------\n\nA plugin can be installed with a mysqld option by providing either the\n--plugin-load-add or the --plugin-load option.\n\nIf a plugin is installed with one of these options, then a record will not be\nadded to the mysql.plugins table for the plugin. This means that if the server\nis restarted without the same option set, then the plugin will not\nautomatically be loaded.\n\nInstalling a Plugin with --plugin-load-add\n------------------------------------------\n\nYou can install a plugin with the --plugin-load-add option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load-add option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load-add=\'server_audit\'\n--plugin-load-add=\'ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nSpecial care must be taken when specifying both the --plugin-load option and\nthe --plugin-load-add option together. The --plugin-load option resets the\nplugin load list, and this can cause unexpected problems if you are not aware.\nThe --plugin-load-add option does not reset the plugin load list, so it is\nmuch safer to use. See Specifying Multiple Plugin Load Options for more\ninformation.\n\nInstalling a Plugin with --plugin-load\n--------------------------------------\n\nYou can install a plugin with the --plugin-load option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load=\'server_audit;ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load = server_audit;ed25519=auth_ed25519\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option together. The --plugin-load option resets the plugin\nload list, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use. See Specifying Multiple Plugin Load Options for more information.\n\nSpecifying Multiple Plugin Load Options\n---------------------------------------\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option. The --plugin-load option resets the plugin load\nlist, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use.\n\nThis can have the following consequences:\n\n* If the --plugin-load option is specified multiple times, then only the last\ninstance will have any effect. For example, in the following case, the first\ninstance of the option is reset:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* If the --plugin-load option is specified after the --plugin-load-add option,\nthen it will also reset the changes made by that option. For example, in the\nfollowing case, the --plugin-load-add option does not do anything, because the\nsubsequent --plugin-load option resets the plugin load list:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* In contrast, if the --plugin-load option is specified before the\n--plugin-load-add option, then it will work fine, because the\n--plugin-load-add option does not reset the plugin load list. For example, in\nthe following case, both plugins are properly loaded:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nInstalling a Plugin with mysql_plugin\n----------------------