/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `barbican`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `barbican` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `barbican`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('8c74e2d7f1ff');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authorities`
--

DROP TABLE IF EXISTS `certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `plugin_ca_id` text NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cas_project_fk` (`project_id`),
  CONSTRAINT `cas_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authorities`
--

LOCK TABLES `certificate_authorities` WRITE;
/*!40000 ALTER TABLE `certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authority_metadata`
--

DROP TABLE IF EXISTS `certificate_authority_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authority_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_certificate_authority_metadatum_uc` (`ca_id`,`key`),
  KEY `ix_certificate_authority_metadata_ca_id` (`ca_id`),
  KEY `ix_certificate_authority_metadata_key` (`key`),
  CONSTRAINT `certificate_authority_metadata_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authority_metadata`
--

LOCK TABLES `certificate_authority_metadata` WRITE;
/*!40000 ALTER TABLE `certificate_authority_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authority_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acl_users`
--

DROP TABLE IF EXISTS `container_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_container_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `container_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `container_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acl_users`
--

LOCK TABLES `container_acl_users` WRITE;
/*!40000 ALTER TABLE `container_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acls`
--

DROP TABLE IF EXISTS `container_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_operation_uc` (`container_id`,`operation`),
  KEY `ix_container_acls_container_id` (`container_id`),
  CONSTRAINT `container_acls_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acls`
--

LOCK TABLES `container_acls` WRITE;
/*!40000 ALTER TABLE `container_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_consumer_metadata`
--

DROP TABLE IF EXISTS `container_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `name` varchar(36) DEFAULT NULL,
  `URL` varchar(255) DEFAULT NULL,
  `data_hash` char(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_consumer_hashed_container_name_url_uc` (`data_hash`),
  KEY `ix_container_consumer_metadata_container_id` (`container_id`),
  KEY `ix_container_consumer_metadata_project_id` (`project_id`),
  KEY `values_index` (`container_id`,`name`,`URL`),
  CONSTRAINT `container_consumer_metadata_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_consumer_metadata_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_consumer_metadata`
--

LOCK TABLES `container_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `container_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_secret`
--

DROP TABLE IF EXISTS `container_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_secret` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `container_id` varchar(36) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_secret_name_uc` (`container_id`,`secret_id`,`name`),
  KEY `ix_container_secret_container_id` (`container_id`),
  KEY `ix_container_secret_secret_id` (`secret_id`),
  CONSTRAINT `container_secret_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_secret_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_secret`
--

LOCK TABLES `container_secret` WRITE;
/*!40000 ALTER TABLE `container_secret` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `containers`
--

DROP TABLE IF EXISTS `containers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `containers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('generic','rsa','dsa','certificate') DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_containers_project_id` (`project_id`),
  CONSTRAINT `containers_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `containers`
--

LOCK TABLES `containers` WRITE;
/*!40000 ALTER TABLE `containers` DISABLE KEYS */;
/*!40000 ALTER TABLE `containers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encrypted_data`
--

DROP TABLE IF EXISTS `encrypted_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encrypted_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `secret_id` varchar(36) NOT NULL,
  `kek_id` varchar(36) NOT NULL,
  `cypher_text` text DEFAULT NULL,
  `kek_meta_extended` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_encrypted_data_kek_id` (`kek_id`),
  KEY `ix_encrypted_data_secret_id` (`secret_id`),
  CONSTRAINT `encrypted_data_ibfk_1` FOREIGN KEY (`kek_id`) REFERENCES `kek_data` (`id`),
  CONSTRAINT `encrypted_data_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encrypted_data`
--

LOCK TABLES `encrypted_data` WRITE;
/*!40000 ALTER TABLE `encrypted_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `encrypted_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kek_data`
--

DROP TABLE IF EXISTS `kek_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kek_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `kek_label` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `bind_completed` tinyint(1) NOT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `plugin_meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_kek_data_project_id` (`project_id`),
  CONSTRAINT `kek_data_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kek_data`
--

LOCK TABLES `kek_data` WRITE;
/*!40000 ALTER TABLE `kek_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `kek_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_barbican_metadata`
--

DROP TABLE IF EXISTS `order_barbican_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_barbican_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_barbican_metadata_order_id` (`order_id`),
  CONSTRAINT `order_barbican_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_barbican_metadata`
--

LOCK TABLES `order_barbican_metadata` WRITE;
/*!40000 ALTER TABLE `order_barbican_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_barbican_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_plugin_metadata`
--

DROP TABLE IF EXISTS `order_plugin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_plugin_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_plugin_metadata_order_id` (`order_id`),
  CONSTRAINT `order_plugin_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_plugin_metadata`
--

LOCK TABLES `order_plugin_metadata` WRITE;
/*!40000 ALTER TABLE `order_plugin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_plugin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_retry_tasks`
--

DROP TABLE IF EXISTS `order_retry_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_retry_tasks` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `id` varchar(36) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `retry_task` text NOT NULL,
  `retry_at` datetime NOT NULL,
  `retry_args` text NOT NULL,
  `retry_kwargs` text NOT NULL,
  `retry_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_retry_tasks_order_id` (`order_id`),
  CONSTRAINT `order_retry_tasks_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_retry_tasks`
--

LOCK TABLES `order_retry_tasks` WRITE;
/*!40000 ALTER TABLE `order_retry_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_retry_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `error_status_code` varchar(16) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  `secret_id` varchar(36) DEFAULT NULL,
  `container_id` varchar(36) DEFAULT NULL,
  `sub_status` varchar(36) DEFAULT NULL,
  `sub_status_message` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_orders_container_id` (`container_id`),
  KEY `ix_orders_project_id` (`project_id`),
  KEY `ix_orders_secret_id` (`secret_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`),
  CONSTRAINT `orders_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preferred_certificate_authorities`
--

DROP TABLE IF EXISTS `preferred_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `preferred_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_preferred_certificate_authorities_project_id` (`project_id`),
  KEY `ix_preferred_certificate_authorities_ca_id` (`ca_id`),
  CONSTRAINT `preferred_certificate_authorities_fk` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `preferred_certificate_authorities_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preferred_certificate_authorities`
--

LOCK TABLES `preferred_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `preferred_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `preferred_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_certificate_authorities`
--

DROP TABLE IF EXISTS `project_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_certificate_authority_uc` (`project_id`,`ca_id`),
  KEY `ix_project_certificate_authorities_ca_id` (`ca_id`),
  KEY `ix_project_certificate_authorities_project_id` (`project_id`),
  CONSTRAINT `project_certificate_authorities_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `project_certificate_authorities_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_certificate_authorities`
--

LOCK TABLES `project_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `project_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_quotas`
--

DROP TABLE IF EXISTS `project_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_quotas` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `secrets` int(11) DEFAULT NULL,
  `orders` int(11) DEFAULT NULL,
  `containers` int(11) DEFAULT NULL,
  `consumers` int(11) DEFAULT NULL,
  `cas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_project_quotas_project_id` (`project_id`),
  CONSTRAINT `project_quotas_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_quotas`
--

LOCK TABLES `project_quotas` WRITE;
/*!40000 ALTER TABLE `project_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_secret_store`
--

DROP TABLE IF EXISTS `project_secret_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_secret_store` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_store_id` varchar(36) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_secret_store_project_uc` (`project_id`),
  KEY `ix_project_secret_store_project_id` (`project_id`),
  KEY `ix_project_secret_store_secret_store_id` (`secret_store_id`),
  CONSTRAINT `project_secret_store_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `project_secret_store_ibfk_2` FOREIGN KEY (`secret_store_id`) REFERENCES `secret_stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_secret_store`
--

LOCK TABLES `project_secret_store` WRITE;
/*!40000 ALTER TABLE `project_secret_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_secret_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `external_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acl_users`
--

DROP TABLE IF EXISTS `secret_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_secret_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `secret_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `secret_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acl_users`
--

LOCK TABLES `secret_acl_users` WRITE;
/*!40000 ALTER TABLE `secret_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acls`
--

DROP TABLE IF EXISTS `secret_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_operation_uc` (`secret_id`,`operation`),
  KEY `ix_secret_acls_secret_id` (`secret_id`),
  CONSTRAINT `secret_acls_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acls`
--

LOCK TABLES `secret_acls` WRITE;
/*!40000 ALTER TABLE `secret_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_consumer_metadata`
--

DROP TABLE IF EXISTS `secret_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `service` varchar(255) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_consumer_resource_uc` (`secret_id`,`service`,`resource_type`,`resource_id`),
  KEY `ix_secret_consumer_metadata_secret_id` (`secret_id`),
  KEY `ix_secret_consumer_metadata_resource_id` (`resource_id`),
  KEY `ix_secret_consumer_metadata_project_id` (`project_id`),
  CONSTRAINT `fk_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `secret_consumer_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_consumer_metadata`
--

LOCK TABLES `secret_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `secret_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_store_metadata`
--

DROP TABLE IF EXISTS `secret_store_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_store_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secret_store_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_store_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_store_metadata`
--

LOCK TABLES `secret_store_metadata` WRITE;
/*!40000 ALTER TABLE `secret_store_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_store_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_stores`
--

DROP TABLE IF EXISTS `secret_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_stores` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `store_plugin` varchar(255) NOT NULL,
  `crypto_plugin` varchar(255) DEFAULT NULL,
  `global_default` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_stores_name_uc` (`name`),
  UNIQUE KEY `_secret_stores_plugin_names_uc` (`store_plugin`,`crypto_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_stores`
--

LOCK TABLES `secret_stores` WRITE;
/*!40000 ALTER TABLE `secret_stores` DISABLE KEYS */;
INSERT INTO `secret_stores` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `store_plugin`, `crypto_plugin`, `global_default`, `name`) VALUES ('dd9fda4a-2c35-463b-bed7-5003903c682b','2025-11-29 07:25:20','2025-11-29 07:25:20',NULL,0,'ACTIVE','store_crypto','simple_crypto',1,'Software Only Crypto');
/*!40000 ALTER TABLE `secret_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_user_metadata`
--

DROP TABLE IF EXISTS `secret_user_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_user_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_key_uc` (`secret_id`,`key`),
  KEY `ix_secret_user_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_user_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_user_metadata`
--

LOCK TABLES `secret_user_metadata` WRITE;
/*!40000 ALTER TABLE `secret_user_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_user_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secrets`
--

DROP TABLE IF EXISTS `secrets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secrets` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `secret_type` varchar(255) DEFAULT 'opaque',
  `expiration` datetime DEFAULT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secrets_project_id` (`project_id`),
  CONSTRAINT `secrets_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secrets`
--

LOCK TABLES `secrets` WRITE;
/*!40000 ALTER TABLE `secrets` DISABLE KEYS */;
/*!40000 ALTER TABLE `secrets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_keys`
--

DROP TABLE IF EXISTS `transport_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transport_keys` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `transport_key` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_keys`
--

LOCK TABLES `transport_keys` WRITE;
/*!40000 ALTER TABLE `transport_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `cinder`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `cinder` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `cinder`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('daa98075b90d');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment_specs`
--

DROP TABLE IF EXISTS `attachment_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_attachment_specs_attachment_id` (`attachment_id`),
  CONSTRAINT `attachment_specs_ibfk_1` FOREIGN KEY (`attachment_id`) REFERENCES `volume_attachment` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment_specs`
--

LOCK TABLES `attachment_specs` WRITE;
/*!40000 ALTER TABLE `attachment_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_metadata`
--

DROP TABLE IF EXISTS `backup_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_backup_metadata_backup_id` (`backup_id`),
  CONSTRAINT `backup_metadata_ibfk_1` FOREIGN KEY (`backup_id`) REFERENCES `backups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_metadata`
--

LOCK TABLES `backup_metadata` WRITE;
/*!40000 ALTER TABLE `backup_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `container` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fail_reason` varchar(255) DEFAULT NULL,
  `service_metadata` varchar(255) DEFAULT NULL,
  `service` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `object_count` int(11) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `temp_volume_id` varchar(36) DEFAULT NULL,
  `temp_snapshot_id` varchar(36) DEFAULT NULL,
  `num_dependent_backups` int(11) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `data_timestamp` datetime DEFAULT NULL,
  `restore_volume_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cgsnapshots`
--

DROP TABLE IF EXISTS `cgsnapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cgsnapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `consistencygroup_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_cgsnapshots_consistencygroup_id` (`consistencygroup_id`),
  CONSTRAINT `cgsnapshots_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cgsnapshots`
--

LOCK TABLES `cgsnapshots` WRITE;
/*!40000 ALTER TABLE `cgsnapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `cgsnapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clusters`
--

DROP TABLE IF EXISTS `clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clusters` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`binary`,`race_preventer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clusters`
--

LOCK TABLES `clusters` WRITE;
/*!40000 ALTER TABLE `clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consistencygroups`
--

DROP TABLE IF EXISTS `consistencygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consistencygroups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `volume_type_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `source_cgid` varchar(36) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consistencygroups`
--

LOCK TABLES `consistencygroups` WRITE;
/*!40000 ALTER TABLE `consistencygroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `consistencygroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_volume_types`
--

DROP TABLE IF EXISTS `default_volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `default_volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  KEY `ix_default_volume_types_volume_type_id` (`volume_type_id`),
  CONSTRAINT `default_volume_types_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_volume_types`
--

LOCK TABLES `default_volume_types` WRITE;
/*!40000 ALTER TABLE `default_volume_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver_initiator_data`
--

DROP TABLE IF EXISTS `driver_initiator_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `driver_initiator_data` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `initiator` (`initiator`,`namespace`,`key`),
  KEY `ix_driver_initiator_data_initiator` (`initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver_initiator_data`
--

LOCK TABLES `driver_initiator_data` WRITE;
/*!40000 ALTER TABLE `driver_initiator_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `driver_initiator_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encryption`
--

DROP TABLE IF EXISTS `encryption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encryption` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `cipher` varchar(255) DEFAULT NULL,
  `control_location` varchar(255) NOT NULL,
  `key_size` int(11) DEFAULT NULL,
  `provider` varchar(255) NOT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `encryption_id` varchar(36) NOT NULL,
  PRIMARY KEY (`encryption_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encryption`
--

LOCK TABLES `encryption` WRITE;
/*!40000 ALTER TABLE `encryption` DISABLE KEYS */;
INSERT INTO `encryption` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `cipher`, `control_location`, `key_size`, `provider`, `volume_type_id`, `encryption_id`) VALUES ('2025-11-29 07:57:00','2025-11-29 07:57:10','2025-11-29 07:57:10',1,'aes-cbc-essiv','front-end',256,'nova.volume.encryptors.luks.LuksEncryptor','80708cfd-e1ee-4e29-b100-8090d4d2d40f','ebb019f3-a506-4be0-8495-ba477ce9cee0');
/*!40000 ALTER TABLE `encryption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_snapshots`
--

DROP TABLE IF EXISTS `group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_snapshots_group_id` (`group_id`),
  KEY `group_snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `group_snapshots_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_snapshots`
--

LOCK TABLES `group_snapshots` WRITE;
/*!40000 ALTER TABLE `group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_projects`
--

DROP TABLE IF EXISTS `group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_type_id` (`group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `group_type_projects_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_projects`
--

LOCK TABLES `group_type_projects` WRITE;
/*!40000 ALTER TABLE `group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_specs`
--

DROP TABLE IF EXISTS `group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_type_specs_group_type_id` (`group_type_id`),
  CONSTRAINT `group_type_specs_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_specs`
--

LOCK TABLES `group_type_specs` WRITE;
/*!40000 ALTER TABLE `group_type_specs` DISABLE KEYS */;
INSERT INTO `group_type_specs` (`id`, `key`, `value`, `group_type_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'consistent_group_snapshot_enabled','<is> True','349fe5e4-8290-4f73-a2d7-5fbf5f2f327f','2025-11-29 07:24:59','2025-11-29 07:24:59',NULL,0);
/*!40000 ALTER TABLE `group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_types`
--

DROP TABLE IF EXISTS `group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_types` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_types`
--

LOCK TABLES `group_types` WRITE;
/*!40000 ALTER TABLE `group_types` DISABLE KEYS */;
INSERT INTO `group_types` (`id`, `name`, `description`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `is_public`) VALUES ('349fe5e4-8290-4f73-a2d7-5fbf5f2f327f','default_cgsnapshot_type','Default group type for migrating cgsnapshot','2025-11-29 07:24:59','2025-11-29 07:24:59',NULL,0,1);
/*!40000 ALTER TABLE `group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_volume_type_mapping`
--

DROP TABLE IF EXISTS `group_volume_type_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_volume_type_mapping` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_volume_type_mapping_volume_type_id` (`volume_type_id`),
  KEY `ix_group_volume_type_mapping_group_id` (`group_id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_volume_type_mapping`
--

LOCK TABLES `group_volume_type_mapping` WRITE;
/*!40000 ALTER TABLE `group_volume_type_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_volume_type_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `groups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `source_group_id` varchar(36) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groups_deleted_project_id_idx` (`deleted`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_volume_cache_entries`
--

DROP TABLE IF EXISTS `image_volume_cache_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_volume_cache_entries` (
  `image_updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `image_id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `size` int(11) NOT NULL,
  `last_used` datetime NOT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_volume_cache_entries_image_id` (`image_id`),
  KEY `ix_image_volume_cache_entries_host` (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_volume_cache_entries`
--

LOCK TABLES `image_volume_cache_entries` WRITE;
/*!40000 ALTER TABLE `image_volume_cache_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_volume_cache_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(36) DEFAULT NULL,
  `resource_uuid` varchar(255) DEFAULT NULL,
  `event_id` varchar(255) NOT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `action_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_messages_expires_at` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quality_of_service_specs`
--

DROP TABLE IF EXISTS `quality_of_service_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quality_of_service_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `specs_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quality_of_service_specs_specs_id` (`specs_id`),
  CONSTRAINT `quality_of_service_specs_ibfk_1` FOREIGN KEY (`specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quality_of_service_specs`
--

LOCK TABLES `quality_of_service_specs` WRITE;
/*!40000 ALTER TABLE `quality_of_service_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `quality_of_service_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
INSERT INTO `quota_classes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `class_name`, `resource`, `hard_limit`) VALUES ('2025-11-29 07:24:46',NULL,NULL,0,1,'default','volumes',10),('2025-11-29 07:24:46',NULL,NULL,0,2,'default','snapshots',10),('2025-11-29 07:24:46',NULL,NULL,0,3,'default','gigabytes',1000),('2025-11-29 07:24:46',NULL,NULL,0,4,'default','consistencygroups',10),('2025-11-29 07:24:46',NULL,NULL,0,5,'default','per_volume_gigabytes',-1),('2025-11-29 07:24:46',NULL,NULL,0,6,'default','groups',10);
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(300) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `race_preventer` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`,`race_preventer`),
  KEY `ix_quota_usages_project_id` (`project_id`),
  KEY `quota_usage_project_resource_idx` (`project_id`,`resource`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `allocated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `allocated_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  KEY `ix_reservations_allocated_id` (`allocated_id`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `reservations_deleted_uuid_idx` (`deleted`,`uuid`),
  KEY `ix_reservations_usage_id` (`usage_id`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`),
  CONSTRAINT `reservations_ibfk_2` FOREIGN KEY (`allocated_id`) REFERENCES `quotas` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `rpc_current_version` varchar(36) DEFAULT NULL,
  `object_current_version` varchar(36) DEFAULT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `frozen` tinyint(1) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `services_uuid_idx` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone`, `disabled_reason`, `modified_at`, `rpc_current_version`, `object_current_version`, `replication_status`, `frozen`, `active_backend_id`, `cluster_name`, `uuid`) VALUES ('2025-11-29 07:25:16','2025-11-29 08:15:56',NULL,0,1,'cinder-scheduler-0','cinder-scheduler','cinder-scheduler',298,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'8bd3c267-dd56-47ab-ade7-89bb85301fa5');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot_metadata`
--

DROP TABLE IF EXISTS `snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshot_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `snapshot_metadata_ibfk_1` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot_metadata`
--

LOCK TABLES `snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `snapshot_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshots`
--

DROP TABLE IF EXISTS `snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `volume_size` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `provider_auth` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshots_group_snapshot_id` (`group_snapshot_id`),
  KEY `ix_snapshots_cgsnapshot_id` (`cgsnapshot_id`),
  KEY `ix_snapshots_volume_id` (`volume_id`),
  KEY `snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `snapshots_ibfk_1` FOREIGN KEY (`cgsnapshot_id`) REFERENCES `cgsnapshots` (`id`),
  CONSTRAINT `snapshots_ibfk_2` FOREIGN KEY (`group_snapshot_id`) REFERENCES `group_snapshots` (`id`),
  CONSTRAINT `snapshots_volume_id_fkey` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshots`
--

LOCK TABLES `snapshots` WRITE;
/*!40000 ALTER TABLE `snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `no_snapshots` tinyint(1) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_transfers_volume_id` (`volume_id`),
  CONSTRAINT `transfers_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_admin_metadata`
--

DROP TABLE IF EXISTS `volume_admin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_admin_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_admin_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_admin_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_admin_metadata`
--

LOCK TABLES `volume_admin_metadata` WRITE;
/*!40000 ALTER TABLE `volume_admin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_admin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_attachment`
--

DROP TABLE IF EXISTS `volume_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_attachment` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `attached_host` varchar(255) DEFAULT NULL,
  `instance_uuid` varchar(36) DEFAULT NULL,
  `mountpoint` varchar(255) DEFAULT NULL,
  `attach_time` datetime DEFAULT NULL,
  `detach_time` datetime DEFAULT NULL,
  `attach_mode` varchar(36) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `connection_info` text DEFAULT NULL,
  `connector` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_attachment_volume_id` (`volume_id`),
  CONSTRAINT `volume_attachment_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_attachment`
--

LOCK TABLES `volume_attachment` WRITE;
/*!40000 ALTER TABLE `volume_attachment` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_glance_metadata`
--

DROP TABLE IF EXISTS `volume_glance_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_glance_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_glance_metadata_volume_id` (`volume_id`),
  KEY `ix_volume_glance_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `volume_glance_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `volume_glance_metadata_ibfk_2` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_glance_metadata`
--

LOCK TABLES `volume_glance_metadata` WRITE;
/*!40000 ALTER TABLE `volume_glance_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_glance_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_metadata`
--

DROP TABLE IF EXISTS `volume_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_metadata`
--

LOCK TABLES `volume_metadata` WRITE;
/*!40000 ALTER TABLE `volume_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_extra_specs`
--

DROP TABLE IF EXISTS `volume_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_extra_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_type_extra_specs_volume_type_id` (`volume_type_id`),
  CONSTRAINT `volume_type_extra_specs_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_extra_specs`
--

LOCK TABLES `volume_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `volume_type_extra_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_projects`
--

DROP TABLE IF EXISTS `volume_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `volume_type_id` (`volume_type_id`,`project_id`,`deleted`),
  CONSTRAINT `volume_type_projects_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_projects`
--

LOCK TABLES `volume_type_projects` WRITE;
/*!40000 ALTER TABLE `volume_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_types`
--

DROP TABLE IF EXISTS `volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `qos_specs_id` varchar(36) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_types_qos_specs_id` (`qos_specs_id`),
  CONSTRAINT `volume_types_ibfk_1` FOREIGN KEY (`qos_specs_id`) REFERENCES `quality_of_service_specs` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_types`
--

LOCK TABLES `volume_types` WRITE;
/*!40000 ALTER TABLE `volume_types` DISABLE KEYS */;
INSERT INTO `volume_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `qos_specs_id`, `is_public`, `description`) VALUES ('2025-11-29 07:56:59',NULL,'2025-11-29 07:57:10',1,'80708cfd-e1ee-4e29-b100-8090d4d2d40f','LUKS',NULL,1,NULL),('2025-11-29 07:24:59','2025-11-29 07:24:59',NULL,0,'fab39938-3e93-47fc-9841-1d1b2197d33e','__DEFAULT__',NULL,1,'Default Volume Type');
/*!40000 ALTER TABLE `volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ec2_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(256) DEFAULT NULL,
  `provider_auth` varchar(256) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `source_volid` varchar(36) DEFAULT NULL,
  `bootable` tinyint(1) DEFAULT NULL,
  `provider_geometry` varchar(255) DEFAULT NULL,
  `_name_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `migration_status` varchar(255) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  `replication_extended_status` varchar(255) DEFAULT NULL,
  `replication_driver_data` varchar(255) DEFAULT NULL,
  `consistencygroup_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `multiattach` tinyint(1) DEFAULT NULL,
  `previous_status` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `group_id` varchar(36) DEFAULT NULL,
  `service_uuid` varchar(36) DEFAULT NULL,
  `shared_targets` tinyint(1) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `volumes_service_uuid_idx` (`service_uuid`,`deleted`),
  KEY `ix_volumes_group_id` (`group_id`),
  KEY `ix_volumes_consistencygroup_id` (`consistencygroup_id`),
  KEY `volumes_deleted_project_id_idx` (`deleted`,`project_id`),
  KEY `volumes_deleted_host_idx` (`deleted`,`host`),
  CONSTRAINT `volumes_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `volumes_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `volumes_ibfk_3` FOREIGN KEY (`service_uuid`) REFERENCES `services` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workers`
--

DROP TABLE IF EXISTS `workers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `workers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(40) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  `status` varchar(255) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_type` (`resource_type`,`resource_id`),
  KEY `ix_workers_service_id` (`service_id`),
  CONSTRAINT `workers_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workers`
--

LOCK TABLES `workers` WRITE;
/*!40000 ALTER TABLE `workers` DISABLE KEYS */;
INSERT INTO `workers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `resource_type`, `resource_id`, `status`, `service_id`, `race_preventer`) VALUES ('2025-11-29 07:24:59','2025-11-29 07:24:59.000123',NULL,0,1,'SENTINEL','SUB-SECOND','OK',NULL,0);
/*!40000 ALTER TABLE `workers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `glance`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `glance` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `glance`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('2023_1_contract01');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_locations`
--

DROP TABLE IF EXISTS `image_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `meta_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `ix_image_locations_deleted` (`deleted`),
  KEY `ix_image_locations_image_id` (`image_id`),
  CONSTRAINT `image_locations_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_locations`
--

LOCK TABLES `image_locations` WRITE;
/*!40000 ALTER TABLE `image_locations` DISABLE KEYS */;
INSERT INTO `image_locations` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `meta_data`, `status`) VALUES (1,'7ec37605-769b-4c6b-8937-6193c69752c0','swift+https://service%3Aglance:12345678@keystone-internal.openstack.svc:5000/glance/7ec37605-769b-4c6b-8937-6193c69752c0','2025-11-29 07:56:14','2025-11-29 07:56:14',NULL,0,'{\"store\": \"default_backend\"}','active'),(2,'0b56f352-51fc-4bdc-9296-ad9545dd23ef','swift+https://service%3Aglance:12345678@keystone-internal.openstack.svc:5000/glance/0b56f352-51fc-4bdc-9296-ad9545dd23ef','2025-11-29 07:56:15','2025-11-29 07:56:15',NULL,0,'{\"store\": \"default_backend\"}','active');
/*!40000 ALTER TABLE `image_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_members`
--

DROP TABLE IF EXISTS `image_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `member` varchar(255) NOT NULL,
  `can_share` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image_members_image_id_member_deleted_at_key` (`image_id`,`member`,`deleted_at`),
  KEY `ix_image_members_deleted` (`deleted`),
  KEY `ix_image_members_image_id` (`image_id`),
  KEY `ix_image_members_image_id_member` (`image_id`,`member`),
  CONSTRAINT `image_members_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`can_share` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_members`
--

LOCK TABLES `image_members` WRITE;
/*!40000 ALTER TABLE `image_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_properties`
--

DROP TABLE IF EXISTS `image_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_image_properties_image_id_name` (`image_id`,`name`),
  KEY `ix_image_properties_deleted` (`deleted`),
  KEY `ix_image_properties_image_id` (`image_id`),
  CONSTRAINT `image_properties_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_properties`
--

LOCK TABLES `image_properties` WRITE;
/*!40000 ALTER TABLE `image_properties` DISABLE KEYS */;
INSERT INTO `image_properties` (`id`, `image_id`, `name`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'7ec37605-769b-4c6b-8937-6193c69752c0','hw_rng_model','virtio','2025-11-29 07:56:13','2025-11-29 07:56:13',NULL,0),(2,'0b56f352-51fc-4bdc-9296-ad9545dd23ef','hw_rng_model','virtio','2025-11-29 07:56:14','2025-11-29 07:56:14',NULL,0);
/*!40000 ALTER TABLE `image_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_tags`
--

DROP TABLE IF EXISTS `image_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_tags_image_id` (`image_id`),
  KEY `ix_image_tags_image_id_tag_value` (`image_id`,`value`),
  CONSTRAINT `image_tags_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_tags`
--

LOCK TABLES `image_tags` WRITE;
/*!40000 ALTER TABLE `image_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `disk_format` varchar(20) DEFAULT NULL,
  `container_format` varchar(20) DEFAULT NULL,
  `checksum` varchar(32) DEFAULT NULL,
  `owner` varchar(255) DEFAULT NULL,
  `min_disk` int(11) NOT NULL,
  `min_ram` int(11) NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT 0,
  `virtual_size` bigint(20) DEFAULT NULL,
  `visibility` enum('private','public','shared','community') NOT NULL DEFAULT 'shared',
  `os_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `os_hash_algo` varchar(64) DEFAULT NULL,
  `os_hash_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checksum_image_idx` (`checksum`),
  KEY `ix_images_deleted` (`deleted`),
  KEY `owner_image_idx` (`owner`),
  KEY `created_at_image_idx` (`created_at`),
  KEY `updated_at_image_idx` (`updated_at`),
  KEY `visibility_image_idx` (`visibility`),
  KEY `os_hidden_image_idx` (`os_hidden`),
  KEY `os_hash_value_image_idx` (`os_hash_value`),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`protected` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` (`id`, `name`, `size`, `status`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `disk_format`, `container_format`, `checksum`, `owner`, `min_disk`, `min_ram`, `protected`, `virtual_size`, `visibility`, `os_hidden`, `os_hash_algo`, `os_hash_value`) VALUES ('0b56f352-51fc-4bdc-9296-ad9545dd23ef','cirros-0.6.2-x86_64-disk.img_alt',21430272,'active','2025-11-29 07:56:14','2025-11-29 07:56:15',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','4708a15e28154d3189eded8da6108d55',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('7ec37605-769b-4c6b-8937-6193c69752c0','cirros-0.6.2-x86_64-disk.img',21430272,'active','2025-11-29 07:56:13','2025-11-29 07:56:14',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','4708a15e28154d3189eded8da6108d55',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b');
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespace_resource_types`
--

DROP TABLE IF EXISTS `metadef_namespace_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespace_resource_types` (
  `resource_type_id` int(11) NOT NULL,
  `namespace_id` int(11) NOT NULL,
  `properties_target` varchar(80) DEFAULT NULL,
  `prefix` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`resource_type_id`,`namespace_id`),
  KEY `ix_metadef_ns_res_types_namespace_id` (`namespace_id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_2` FOREIGN KEY (`resource_type_id`) REFERENCES `metadef_resource_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespace_resource_types`
--

LOCK TABLES `metadef_namespace_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_namespace_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_namespace_resource_types` (`resource_type_id`, `namespace_id`, `properties_target`, `prefix`, `created_at`, `updated_at`) VALUES (1,1,'image','CIM_PASD_','2025-11-29 07:23:09',NULL),(1,2,'image','CIM_RASD_','2025-11-29 07:23:09',NULL),(1,3,NULL,'CIM_SASD_','2025-11-29 07:23:09',NULL),(1,9,'image','hw_','2025-11-29 07:23:09',NULL),(1,10,'image','hw_','2025-11-29 07:23:10',NULL),(1,14,'image',NULL,'2025-11-29 07:23:10',NULL),(1,19,'image','hw_','2025-11-29 07:23:11',NULL),(1,25,'image','hw_','2025-11-29 07:23:13',NULL),(1,29,'image',NULL,'2025-11-29 07:23:17',NULL),(1,30,'image',NULL,'2025-11-29 07:23:17',NULL),(1,31,'image',NULL,'2025-11-29 07:23:29',NULL),(1,32,'image',NULL,'2025-11-29 07:23:45',NULL),(2,1,NULL,'CIM_PASD_','2025-11-29 07:23:09',NULL),(2,8,NULL,'hw_','2025-11-29 07:23:09',NULL),(2,9,NULL,'hw_','2025-11-29 07:23:09',NULL),(2,10,NULL,'hw_','2025-11-29 07:23:10',NULL),(2,11,NULL,NULL,'2025-11-29 07:23:10',NULL),(2,13,NULL,NULL,'2025-11-29 07:23:10',NULL),(2,14,NULL,NULL,'2025-11-29 07:23:10',NULL),(2,15,NULL,NULL,'2025-11-29 07:23:10',NULL),(2,16,NULL,'hw_','2025-11-29 07:23:10',NULL),(2,19,NULL,'hw_','2025-11-29 07:23:11',NULL),(2,22,NULL,NULL,'2025-11-29 07:23:12',NULL),(2,23,NULL,'hw_','2025-11-29 07:23:13',NULL),(2,24,NULL,'traits:','2025-11-29 07:23:13',NULL),(2,25,NULL,'hw_','2025-11-29 07:23:13',NULL),(2,26,NULL,NULL,'2025-11-29 07:23:14',NULL),(2,28,NULL,NULL,'2025-11-29 07:23:17',NULL),(2,29,NULL,NULL,'2025-11-29 07:23:17',NULL),(2,30,NULL,NULL,'2025-11-29 07:23:17',NULL),(2,31,NULL,NULL,'2025-11-29 07:23:23',NULL),(2,32,NULL,NULL,'2025-11-29 07:23:43',NULL),(2,33,NULL,'cinder_','2025-11-29 07:24:01',NULL),(3,1,NULL,'CIM_PASD_','2025-11-29 07:23:09',NULL),(3,2,NULL,'CIM_RASD_','2025-11-29 07:23:09',NULL),(3,3,NULL,'CIM_SASD_','2025-11-29 07:23:09',NULL),(3,4,NULL,'CIM_VSSD_','2025-11-29 07:23:09',NULL),(3,5,NULL,NULL,'2025-11-29 07:23:09',NULL),(3,6,NULL,NULL,'2025-11-29 07:23:09',NULL),(3,7,NULL,NULL,'2025-11-29 07:23:09',NULL),(3,12,NULL,'aggregate_instance_extra_specs:','2025-11-29 07:23:10',NULL),(4,1,NULL,'CIM_PASD_','2025-11-29 07:23:09',NULL),(4,2,NULL,'CIM_RASD_','2025-11-29 07:23:09',NULL),(4,3,NULL,'CIM_SASD_','2025-11-29 07:23:09',NULL),(4,4,NULL,'CIM_VSSD_','2025-11-29 07:23:09',NULL),(4,8,NULL,'hw:','2025-11-29 07:23:09',NULL),(4,9,NULL,'hw:','2025-11-29 07:23:09',NULL),(4,10,NULL,'hw:','2025-11-29 07:23:10',NULL),(4,12,NULL,'capabilities:','2025-11-29 07:23:10',NULL),(4,16,NULL,'hw:','2025-11-29 07:23:10',NULL),(4,17,NULL,NULL,'2025-11-29 07:23:10',NULL),(4,18,NULL,NULL,'2025-11-29 07:23:11',NULL),(4,19,NULL,'hw:','2025-11-29 07:23:11',NULL),(4,20,NULL,NULL,'2025-11-29 07:23:11',NULL),(4,21,NULL,NULL,'2025-11-29 07:23:11',NULL),(4,23,NULL,'hw:','2025-11-29 07:23:13',NULL),(4,24,NULL,'traits:','2025-11-29 07:23:13',NULL),(4,25,NULL,'hw:','2025-11-29 07:23:14',NULL),(5,1,'scheduler_hints',NULL,'2025-11-29 07:23:09',NULL),(5,30,'metadata',NULL,'2025-11-29 07:23:17',NULL),(5,31,'metadata',NULL,'2025-11-29 07:23:29',NULL),(5,32,'metadata',NULL,'2025-11-29 07:23:45',NULL),(6,30,NULL,NULL,'2025-11-29 07:23:17',NULL);
/*!40000 ALTER TABLE `metadef_namespace_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespaces`
--

DROP TABLE IF EXISTS `metadef_namespaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespaces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace` varchar(80) NOT NULL,
  `display_name` varchar(80) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `visibility` varchar(32) DEFAULT NULL,
  `protected` tinyint(1) DEFAULT NULL,
  `owner` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_namespaces_namespace` (`namespace`),
  KEY `ix_metadef_namespaces_owner` (`owner`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespaces`
--

LOCK TABLES `metadef_namespaces` WRITE;
/*!40000 ALTER TABLE `metadef_namespaces` DISABLE KEYS */;
INSERT INTO `metadef_namespaces` (`id`, `namespace`, `display_name`, `description`, `visibility`, `protected`, `owner`, `created_at`, `updated_at`) VALUES (1,'CIM::ProcessorAllocationSettingData','CIM Processor Allocation Setting','Properties related to the resource allocation settings of a processor (CPU) from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These are properties that identify processor setting data and may be specified to volume, image, host aggregate, flavor and Nova server as scheduler hint. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ProcessorAllocationSettingData.html.','public',1,'admin','2025-11-29 07:23:09',NULL),(2,'CIM::ResourceAllocationSettingData','CIM Resource Allocation Setting Data','Properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim) that represent settings specifically related to an allocated resource that are outside the scope of the CIM class typically used to represent the resource itself. These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ResourceAllocationSettingData.html.','public',1,'admin','2025-11-29 07:23:09',NULL),(3,'CIM::StorageAllocationSettingData','CIM Storage Allocation Setting Data','Properties related to the allocation of virtual storage from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_StorageAllocationSettingData.html.','public',1,'admin','2025-11-29 07:23:09',NULL),(4,'CIM::VirtualSystemSettingData','CIM Virtual System Setting Data','A set of virtualization specific properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim), which define the virtual aspects of a virtual system. These properties may be specified to host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_VirtualSystemSettingData.html.','public',1,'admin','2025-11-29 07:23:09',NULL),(5,'OS::Compute::AggregateDiskFilter','Disk Allocation per Host','Properties related to the Nova scheduler filter AggregateDiskFilter. Filters aggregate hosts based on the available disk space compared to the requested disk space. Hosts in the aggregate with not enough usable disk will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-11-29 07:23:09',NULL),(6,'OS::Compute::AggregateIoOpsFilter','IO Ops per Host','Properties related to the Nova scheduler filter AggregateIoOpsFilter. Filters aggregate hosts based on the number of instances currently changing state. Hosts in the aggregate with too many instances changing state will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-11-29 07:23:09',NULL),(7,'OS::Compute::AggregateNumInstancesFilter','Instances per Host','Properties related to the Nova scheduler filter AggregateNumInstancesFilter. Filters aggregate hosts by the number of running instances on it. Hosts in the aggregate with too many instances will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',0,'admin','2025-11-29 07:23:09',NULL),(8,'OS::Compute::CPUMode','CPU Mode','This provides the preferred CPU Model to be used when booting up a guest VM.','public',NULL,'admin','2025-11-29 07:23:09',NULL),(9,'OS::Compute::CPUPinning','CPU Pinning','This provides the preferred CPU pinning and CPU thread pinning policy to be used when pinning vCPU of the guest to pCPU of the host. See http://docs.openstack.org/admin-guide/compute-numa-cpu-pinning.html','public',1,'admin','2025-11-29 07:23:09',NULL),(10,'OS::Compute::GuestMemoryBacking','Guest Memory Backing','This provides the preferred backing option for guest RAM. Guest\'s memory can be backed by hugepages to limit TLB lookups. See also: https://wiki.openstack.org/wiki/VirtDriverGuestCPUMemoryPlacement','public',1,'admin','2025-11-29 07:23:09',NULL),(11,'OS::Compute::GuestShutdownBehavior','Shutdown Behavior','These properties allow modifying the shutdown behavior for stop, rescue, resize, and shelve operations.','public',1,'admin','2025-11-29 07:23:10',NULL),(12,'OS::Compute::HostCapabilities','Compute Host Capabilities','Hardware capabilities provided by the compute host. This provides the ability to fine tune the hardware specification required when an instance is requested. The ComputeCapabilitiesFilter should be enabled in the Nova scheduler to use these properties. When enabled, this filter checks that the capabilities provided by the compute host satisfy any extra specifications requested. Only hosts that can provide the requested capabilities will be eligible for hosting the instance.','public',1,'admin','2025-11-29 07:23:10',NULL),(13,'OS::Compute::Hypervisor','Hypervisor Selection','OpenStack Compute supports many hypervisors, although most installations use only one hypervisor. For installations with multiple supported hypervisors, you can schedule different hypervisors using the ImagePropertiesFilter. This filters compute nodes that satisfy any architecture, hypervisor type, or virtual machine mode properties specified on the instance\'s image properties.','public',1,'admin','2025-11-29 07:23:10',NULL),(14,'OS::Compute::InstanceData','Instance Config Data','Instances can perform self-configuration based on data made available to the running instance. These properties affect instance configuration.','public',1,'admin','2025-11-29 07:23:10',NULL),(15,'OS::Compute::LibvirtImage','libvirt Driver Options for Images','The libvirt Compute Driver Options for Glance Images.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-11-29 07:23:10',NULL),(16,'OS::Compute::Libvirt','libvirt Driver Options','The libvirt compute driver options.  \n\nThese are properties that affect the libvirt compute driver and may be specified on flavors and images.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-11-29 07:23:10',NULL),(17,'OS::Compute::Quota','Flavor Quota','Compute drivers may enable quotas on CPUs available to a VM, disk tuning, bandwidth I/O, and instance VIF traffic control.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-11-29 07:23:10',NULL),(18,'OS::Compute::RandomNumberGenerator','Random Number Generator','If a random-number generator device has been added to the instance through its image properties, the device can be enabled and configured.','public',1,'admin','2025-11-29 07:23:11',NULL),(19,'OS::Compute::VirtCPUTopology','Virtual CPU Topology','This provides the preferred socket/core/thread counts for the virtual CPU instance exposed to guests. This enables the ability to avoid hitting limitations on vCPU topologies that OS vendors place on their products. See also: https://opendev.org/openstack/nova-specs/src/branch/master/specs/juno/implemented/virt-driver-vcpu-topology.rst','public',1,'admin','2025-11-29 07:23:11',NULL),(20,'OS::Compute::VMwareFlavor','VMware Driver Options for Flavors','VMware Driver Options for Flavors may be used to customize and manage Nova Flavors. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-11-29 07:23:11',NULL),(21,'OS::Compute::VMwareQuotaFlavor','VMware Quota for Flavors','The VMware compute driver allows various compute quotas to be specified on flavors. When specified, the VMWare driver will ensure that the quota is enforced. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. For a list of hypervisors, see: https://wiki.openstack.org/wiki/HypervisorSupportMatrix. For flavor customization, see: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-11-29 07:23:11',NULL),(22,'OS::Compute::VMware','VMware Driver Options','The VMware compute driver options.  \n\nThese are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-11-29 07:23:12',NULL),(23,'OS::Compute::TPM','TPM Options','Configuration options for TPM','public',1,'admin','2025-11-29 07:23:13',NULL),(24,'OS::Compute::VTPM','Emulated Virtual TPM','Configuration options for Emulated Virtual TPM','public',1,'admin','2025-11-29 07:23:13',NULL),(25,'OS::Compute::Watchdog','Watchdog Behavior','Compute drivers may enable watchdog behavior over instances.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-11-29 07:23:13',NULL),(26,'OS::Compute::XenAPI','XenAPI Driver Options','The XenAPI compute driver options.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-11-29 07:23:14',NULL),(27,'OS::Glance::CommonImageProperties','Common Image Properties','When adding an image to Glance, you may specify some common image properties that may prove useful to consumers of your image.',NULL,1,'admin','2025-11-29 07:23:14',NULL),(28,'OS::Glance::Signatures','Image Signature Verification','Image signature verification allows the user to verify that an image has not been modified prior to booting the image.','public',0,'admin','2025-11-29 07:23:17',NULL),(29,'OS::OperatingSystem','Common Operating System Properties','Details of the operating system contained within this image as well as common operating system properties that can be set on a VM instance created from this image.',NULL,1,'admin','2025-11-29 07:23:17',NULL),(30,'OS::Software::DBMS','Database Software','A database is an organized collection of data. The data is typically organized to model aspects of reality in a way that supports processes requiring information. Database management systems are computer software applications that interact with the user, other applications, and the database itself to capture and analyze data. (http://en.wikipedia.org/wiki/Database)','public',1,'admin','2025-11-29 07:23:17',NULL),(31,'OS::Software::Runtimes','Runtime Environment','Software is written in a specific programming language and the language must execute within a runtime environment. The runtime environment provides an abstraction to utilizing a computer\'s processor, memory (RAM), and other system resources.','public',1,'admin','2025-11-29 07:23:22',NULL),(32,'OS::Software::WebServers','Web Servers','A web server is a computer system that processes requests via HTTP, the basic network protocol used to distribute information on the World Wide Web. The most common use of web servers is to host websites, but there are other uses such as gaming, data storage, running enterprise applications, handling email, FTP, or other web uses. (http://en.wikipedia.org/wiki/Web_server)','public',1,'admin','2025-11-29 07:23:43',NULL),(33,'OS::Cinder::Volumetype','Cinder Volume Type','The Cinder volume type configuration option. Volume type assignment provides a mechanism not only to provide scheduling to a specific storage back-end, but also can be used to specify specific information for a back-end storage device to act upon.','public',1,'admin','2025-11-29 07:24:01',NULL);
/*!40000 ALTER TABLE `metadef_namespaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_objects`
--

DROP TABLE IF EXISTS `metadef_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `description` text DEFAULT NULL,
  `required` text DEFAULT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_objects_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_objects_name` (`name`),
  CONSTRAINT `metadef_objects_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_objects`
--

LOCK TABLES `metadef_objects` WRITE;
/*!40000 ALTER TABLE `metadef_objects` DISABLE KEYS */;
INSERT INTO `metadef_objects` (`id`, `namespace_id`, `name`, `description`, `required`, `json_schema`, `created_at`, `updated_at`) VALUES (1,17,'CPU Limits','You can configure the CPU limits with control parameters.',NULL,'{\"quota:cpu_shares\": {\"title\": \"Quota: CPU Shares\", \"description\": \"Specifies the proportional weighted share for the domain. If this element is omitted, the service defaults to the OS provided defaults. There is no unit for the value; it is a relative measure based on the setting of other VMs. For example, a VM configured with value 2048 gets twice as much CPU time as a VM configured with value 1024.\", \"type\": \"integer\"}, \"quota:cpu_period\": {\"title\": \"Quota: CPU Period\", \"description\": \"Specifies the enforcement interval (unit: microseconds) for QEMU and LXC hypervisors. Within a period, each VCPU of the domain is not allowed to consume more than the quota worth of runtime. The value should be in range [1000, 1000000]. A period with value 0 means no value.\", \"type\": \"integer\", \"minimum\": 1000, \"maximum\": 1000000}, \"quota:cpu_quota\": {\"title\": \"Quota: CPU Quota\", \"description\": \"Specifies the maximum allowed bandwidth (unit: microseconds). A domain with a negative-value quota indicates that the domain has infinite bandwidth, which means that it is not bandwidth controlled. The value should be in range [1000, 18446744073709551] or less than 0. A quota with value 0 means no value. You can use this feature to ensure that all vCPUs run at the same speed.\", \"type\": \"integer\"}}','2025-11-29 07:23:10',NULL),(2,17,'Disk QoS','Using disk I/O quotas, you can set maximum disk write to 10 MB per second for a VM user.',NULL,'{\"quota:disk_read_bytes_sec\": {\"title\": \"Quota: Disk read bytes / sec\", \"description\": \"Sets disk I/O quota for disk read bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_read_iops_sec\": {\"title\": \"Quota: Disk read IOPS / sec\", \"description\": \"Sets disk I/O quota for disk read IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_write_bytes_sec\": {\"title\": \"Quota: Disk Write Bytes / sec\", \"description\": \"Sets disk I/O quota for disk write bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_write_iops_sec\": {\"title\": \"Quota: Disk Write IOPS / sec\", \"description\": \"Sets disk I/O quota for disk write IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_total_bytes_sec\": {\"title\": \"Quota: Disk Total Bytes / sec\", \"description\": \"Sets disk I/O quota for total disk bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_total_iops_sec\": {\"title\": \"Quota: Disk Total IOPS / sec\", \"description\": \"Sets disk I/O quota for disk total IOPS / sec.\", \"type\": \"integer\"}}','2025-11-29 07:23:10',NULL),(3,17,'Virtual Interface QoS','Bandwidth QoS tuning for instance virtual interfaces (VIFs) may be specified with these properties. Incoming and outgoing traffic can be shaped independently. If not specified, no quality of service (QoS) is applied on that traffic direction. So, if you want to shape only the network\'s incoming traffic, use inbound only (and vice versa). The OpenStack Networking service abstracts the physical implementation of the network, allowing plugins to configure and manage physical resources. Virtual Interfaces (VIF) in the logical model are analogous to physical network interface cards (NICs). VIFs are typically owned a managed by an external service; for instance when OpenStack Networking is used for building OpenStack networks, VIFs would be created, owned, and managed in Nova. VIFs are connected to OpenStack Networking networks via ports. A port is analogous to a port on a network switch, and it has an administrative state. When a VIF is attached to a port the OpenStack Networking API creates an attachment object, which specifies the fact that a VIF with a given identifier is plugged into the port.',NULL,'{\"quota:vif_inbound_average\": {\"title\": \"Quota: VIF Inbound Average\", \"description\": \"Network Virtual Interface (VIF) inbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_inbound_burst\": {\"title\": \"Quota: VIF Inbound Burst\", \"description\": \"Network Virtual Interface (VIF) inbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_inbound_peak\": {\"title\": \"Quota: VIF Inbound Peak\", \"description\": \"Network Virtual Interface (VIF) inbound peak in kilobytes per second. Specifies maximum rate at which an interface can receive data.\", \"type\": \"integer\"}, \"quota:vif_outbound_average\": {\"title\": \"Quota: VIF Outbound Average\", \"description\": \"Network Virtual Interface (VIF) outbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_outbound_burst\": {\"title\": \"Quota: VIF Outbound Burst\", \"description\": \"Network Virtual Interface (VIF) outbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_outbound_peak\": {\"title\": \"Quota: VIF Outbound Peak\", \"description\": \"Network Virtual Interface (VIF) outbound peak in kilobytes per second. Specifies maximum rate at which an interface can send data.\", \"type\": \"integer\"}}','2025-11-29 07:23:11',NULL),(4,30,'MySQL','MySQL is an object-relational database management system (ORDBMS). The MySQL development project has made its source code available under the terms of the GNU General Public License, as well as under a variety of proprietary agreements. MySQL was owned and sponsored by a single for-profit firm, the Swedish company MySQL AB, now owned by Oracle Corporation. MySQL is a popular choice of database for use in web applications, and is a central component of the widely used LAMP open source web application software stack (and other \'AMP\' stacks). (http://en.wikipedia.org/wiki/MySQL)',NULL,'{\"sw_database_mysql_version\": {\"title\": \"Version\", \"description\": \"The specific version of MySQL.\", \"type\": \"string\"}, \"sw_database_mysql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"The configured TCP/IP port which MySQL listens for incoming connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 3606}, \"sw_database_mysql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"root\"}}','2025-11-29 07:23:17',NULL),(5,30,'PostgreSQL','PostgreSQL, often simply \'Postgres\', is an object-relational database management system (ORDBMS) with an emphasis on extensibility and standards-compliance. PostgreSQL is cross-platform and runs on many operating systems. (http://en.wikipedia.org/wiki/PostgreSQL)',NULL,'{\"sw_database_postgresql_version\": {\"title\": \"Version\", \"description\": \"The specific version of PostgreSQL.\", \"type\": \"string\"}, \"sw_database_postgresql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which PostgreSQL is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_postgresql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"postgres\"}}','2025-11-29 07:23:17',NULL),(6,30,'SQL Server','Microsoft SQL Server is a relational database management system developed by Microsoft. There are at least a dozen different editions of Microsoft SQL Server aimed at different audiences and for workloads ranging from small single-machine applications to large Internet-facing applications with many concurrent users. Its primary query languages are T-SQL and ANSI SQL. (http://en.wikipedia.org/wiki/Microsoft_SQL_Server)',NULL,'{\"sw_database_sqlserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Microsoft SQL Server.\", \"type\": \"string\"}, \"sw_database_sqlserver_edition\": {\"title\": \"Edition\", \"description\": \"SQL Server is available in multiple editions, with different feature sets and targeting different users.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Datacenter\", \"Enterprise\", \"Standard\", \"Web\", \"Business Intelligence\", \"Workgroup\", \"Express\", \"Compact (SQL CE)\", \"Developer\", \"Embedded (SSEE)\", \"Express\", \"Fast Track\", \"LocalDB\", \"Parallel Data Warehouse (PDW)\", \"Business Intelligence\", \"Datawarehouse Appliance Edition\"]}, \"sw_database_sqlserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which SQL Server is to listen for connections from client applications. The default SQL Server port is 1433, and client ports are assigned a random value between 1024 and 5000.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1433}, \"sw_database_postsqlserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"sa\"}}','2025-11-29 07:23:17',NULL),(7,30,'Oracle','Oracle Database (commonly referred to as Oracle RDBMS or simply as Oracle) is an object-relational database management system produced and marketed by Oracle Corporation. (http://en.wikipedia.org/wiki/Oracle_Database)',NULL,'{\"sw_database_oracle_version\": {\"title\": \"Version\", \"description\": \"The specific version of Oracle.\", \"type\": \"string\"}, \"sw_database_oracle_edition\": {\"title\": \"Edition\", \"description\": \"Over and above the different versions of the Oracle database management software developed over time, Oracle Corporation subdivides its product into varying editions.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Enterprise\", \"Standard\", \"Standard Edition One\", \"Express (XE)\", \"Workgroup\", \"Lite\"]}, \"sw_database_oracle_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Oracle is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1521}}','2025-11-29 07:23:17',NULL),(8,30,'DB2','IBM DB2 is a family of database server products developed by IBM. These products all support the relational model, but in recent years some products have been extended to support object-relational features and non-relational structures, in particular XML. (http://en.wikipedia.org/wiki/IBM_DB2)',NULL,'{\"sw_database_db2_version\": {\"title\": \"Version\", \"description\": \"The specific version of DB2.\", \"type\": \"string\"}, \"sw_database_db2_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which DB2 is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_db2_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-11-29 07:23:18',NULL),(9,30,'MongoDB','MongoDB is a cross-platform document-oriented database. Classified as a NoSQL database, MongoDB uses JSON-like documents with dynamic schemas (MongoDB calls the format BSON), making the integration of data in certain types of applications easier and faster. Released under a combination of the GNU Affero General Public License and the Apache License, MongoDB is free and open-source software. (http://en.wikipedia.org/wiki/MongoDB)',NULL,'{\"sw_database_mongodb_version\": {\"title\": \"Version\", \"description\": \"The specific version of MongoDB.\", \"type\": \"string\"}, \"sw_database_mongodb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which MongoDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 27017}, \"sw_database_mongodb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-11-29 07:23:18',NULL),(10,30,'Couchbase Server','Couchbase Server, originally known as Membase, is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications. These applications must serve many concurrent users by creating, storing, retrieving, aggregating, manipulating and presenting data. In support of these kinds of application needs, Couchbase is designed to provide easy-to-scale key-value or document access with low latency and high sustained throughput. (http://en.wikipedia.org/wiki/Couchbase_Server)',NULL,'{\"sw_database_couchbaseserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Couchbase Server.\", \"type\": \"string\"}, \"sw_database_couchbaseserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Couchbase is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 11211}, \"sw_database_couchbaseserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-11-29 07:23:18',NULL),(11,30,'Redis','Redis is a data structure server (NoSQL). It is open-source, networked, in-memory, and stores keys with optional durability. The development of Redis has been sponsored by Pivotal Software since May 2013; before that, it was sponsored by VMware. The name Redis means REmote DIctionary Server. (http://en.wikipedia.org/wiki/Redis)',NULL,'{\"sw_database_redis_version\": {\"title\": \"Version\", \"description\": \"The specific version of Redis.\", \"type\": \"string\"}, \"sw_database_redis_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Redis is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 6379}, \"sw_database_redis_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-11-29 07:23:18',NULL),(12,30,'CouchDB','Apache CouchDB, commonly referred to as CouchDB, is an open source NoSQL database. It is a NoSQL database that uses JSON to store data, JavaScript as its query language using MapReduce, and HTTP for an API. One of its distinguishing features is multi-master replication. CouchDB was first released in 2005 and later became an Apache project in 2008. (http://en.wikipedia.org/wiki/CouchDB)',NULL,'{\"sw_database_couchdb_version\": {\"title\": \"Version\", \"description\": \"The specific version of CouchDB.\", \"type\": \"string\"}, \"sw_database_couchdb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which CouchDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5984}, \"sw_database_couchdb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-11-29 07:23:18',NULL),(13,30,'Apache Cassandra','Apache Cassandra is an open source distributed NoSQL database management system designed to handle large amounts of data across many commodity servers, providing high availability with no single point of failure. (http://en.wikipedia.org/wiki/Apache_Cassandra)',NULL,'{\"sw_database_cassandra_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache Cassandra.\", \"type\": \"string\"}, \"sw_database_cassandra_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Cassandra is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 9160}, \"sw_database_cassandra_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"cassandra\"}}','2025-11-29 07:23:18',NULL),(14,30,'HBase','HBase is an open source, non-relational (NoSQL), distributed database modeled after Google\'s BigTable and written in Java. It is developed as part of Apache Software Foundation\'s Apache Hadoop project and runs on top of HDFS (Hadoop Distributed Filesystem), providing BigTable-like capabilities for Hadoop. (http://en.wikipedia.org/wiki/Apache_HBase)',NULL,'{\"sw_database_hbase_version\": {\"title\": \"Version\", \"description\": \"The specific version of HBase.\", \"type\": \"string\"}}','2025-11-29 07:23:18',NULL),(15,30,'Hazlecast','In computing, Hazelcast is an in-memory open source software data grid based on Java. By having multiple nodes form a cluster, data is evenly distributed among the nodes. This allows for horizontal scaling both in terms of available storage space and processing power. Backups are also distributed in a similar fashion to other nodes, based on configuration, thereby protecting against single node failure. (http://en.wikipedia.org/wiki/Hazelcast)',NULL,'{\"sw_database_hazlecast_version\": {\"title\": \"Version\", \"description\": \"The specific version of Hazlecast.\", \"type\": \"string\"}, \"sw_database_hazlecast_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Hazlecast is to listen for connections between members.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5701}}','2025-11-29 07:23:18',NULL),(16,31,'PHP','PHP is a server-side scripting language designed for web development but also used as a general-purpose programming language. PHP code can be simply mixed with HTML code, or it can be used in combination with various templating engines and web frameworks. PHP code is usually processed by a PHP interpreter, which is usually implemented as a web server\'s native module or a Common Gateway Interface (CGI) executable. After the PHP code is interpreted and executed, the web server sends resulting output to its client, usually in form of a part of the generated web page – for example, PHP code can generate a web page\'s HTML code, an image, or some other data. PHP has also evolved to include a command-line interface (CLI) capability and can be used in standalone graphical applications. (http://en.wikipedia.org/wiki/PHP)',NULL,'{\"sw_runtime_php_version\": {\"title\": \"Version\", \"description\": \"The specific version of PHP.\", \"type\": \"string\"}}','2025-11-29 07:23:30',NULL),(17,31,'Python','Python is a widely used general-purpose, high-level programming language. Its design philosophy emphasizes code readability, and its syntax allows programmers to express concepts in fewer lines of code than would be possible in languages such as C++ or Java. The language provides constructs intended to enable clear programs on both a small and large scale. Python supports multiple programming paradigms, including object-oriented, imperative and functional programming or procedural styles. It features a dynamic type system and automatic memory management and has a large and comprehensive standard library. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_python_version\": {\"title\": \"Version\", \"description\": \"The specific version of python.\", \"type\": \"string\"}}','2025-11-29 07:23:30',NULL),(18,31,'Java','Java is a functional computer programming language that is concurrent, class-based, object-oriented, and specifically designed to have as few implementation dependencies as possible. It is intended to let application developers write once, run anywhere (WORA), meaning that code that runs on one platform does not need to be recompiled to run on another. Java applications are typically compiled to bytecode that can run on any Java virtual machine (JVM) regardless of computer architecture. (http://en.wikipedia.org/wiki/Java_(programming_language))',NULL,'{\"sw_runtime_java_version\": {\"title\": \"Version\", \"description\": \"The specific version of Java.\", \"type\": \"string\"}}','2025-11-29 07:23:41',NULL),(19,31,'Ruby','Ruby is a dynamic, reflective, object-oriented, general-purpose programming language. It was designed and developed in the mid-1990s by Yukihiro Matsumoto in Japan. According to its authors, Ruby was influenced by Perl, Smalltalk, Eiffel, Ada, and Lisp. It supports multiple programming paradigms, including functional, object-oriented, and imperative. It also has a dynamic type system and automatic memory management. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_ruby_version\": {\"title\": \"Version\", \"description\": \"The specific version of Ruby.\", \"type\": \"string\"}}','2025-11-29 07:23:42',NULL),(20,31,'Perl','Perl is a family of high-level, general-purpose, interpreted, dynamic programming languages. The languages in this family include Perl 5 and Perl 6. Though Perl is not officially an acronym, there are various backronyms in use, the most well-known being Practical Extraction and Reporting Language (http://en.wikipedia.org/wiki/Perl)',NULL,'{\"sw_runtime_perl_version\": {\"title\": \"Version\", \"description\": \"The specific version of Perl.\", \"type\": \"string\"}}','2025-11-29 07:23:42',NULL),(21,32,'Apache HTTP Server','The Apache HTTP Server, colloquially called Apache, is a Web server application notable for playing a key role in the initial growth of the World Wide Web. Apache is developed and maintained by an open community of developers under the auspices of the Apache Software Foundation. Most commonly used on a Unix-like system, the software is available for a wide variety of operating systems, including Unix, FreeBSD, Linux, Solaris, Novell NetWare, OS X, Microsoft Windows, OS/2, TPF, OpenVMS and eComStation. Released under the Apache License, Apache is open-source software. (http://en.wikipedia.org/wiki/Apache_HTTP_Server)',NULL,'{\"sw_webserver_apache_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache.\", \"type\": \"string\"}, \"sw_webserver_apache_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_apache_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-11-29 07:23:46',NULL),(22,32,'Nginx','Nginx (pronounced \'engine-x\') is an open source reverse proxy server for HTTP, HTTPS, SMTP, POP3, and IMAP protocols, as well as a load balancer, HTTP cache, and a web server (origin server). The nginx project started with a strong focus on high concurrency, high performance and low memory usage. It is licensed under the 2-clause BSD-like license and it runs on Linux, BSD variants, Mac OS X, Solaris, AIX, HP-UX, as well as on other *nix flavors. It also has a proof of concept port for Microsoft Windows. (http://en.wikipedia.org/wiki/Nginx)',NULL,'{\"sw_webserver_nginx_version\": {\"title\": \"Version\", \"description\": \"The specific version of Nginx.\", \"type\": \"string\"}, \"sw_webserver_nginx_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_nginx_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-11-29 07:23:46',NULL),(23,32,'IIS','Internet Information Services (IIS, formerly Internet Information Server) is an extensible web server created by Microsoft. IIS supports HTTP, HTTPS, FTP, FTPS, SMTP and NNTP. IIS is not turned on by default when Windows is installed. The IIS Manager is accessed through the Microsoft Management Console or Administrative Tools in the Control Panel. (http://en.wikipedia.org/wiki/Internet_Information_Services)',NULL,'{\"sw_webserver_iis_version\": {\"title\": \"Version\", \"description\": \"The specific version of IIS.\", \"type\": \"string\"}, \"sw_webserver_iis_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_iis_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-11-29 07:23:46',NULL);
/*!40000 ALTER TABLE `metadef_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_properties`
--

DROP TABLE IF EXISTS `metadef_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_properties_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_properties_name` (`name`),
  CONSTRAINT `metadef_properties_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_properties`
--

LOCK TABLES `metadef_properties` WRITE;
/*!40000 ALTER TABLE `metadef_properties` DISABLE KEYS */;
INSERT INTO `metadef_properties` (`id`, `namespace_id`, `name`, `json_schema`, `created_at`, `updated_at`) VALUES (1,1,'InstructionSet','{\"title\": \"Instruction Set\", \"description\": \"Identifies the instruction set of the processor within a processor architecture.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86:i386\", \"x86:i486\", \"x86:i586\", \"x86:i686\", \"x86:64\", \"IA-64:IA-64\", \"AS/400:TIMI\", \"Power:Power_2.03\", \"Power:Power_2.04\", \"Power:Power_2.05\", \"Power:Power_2.06\", \"S/390:ESA/390\", \"S/390:z/Architecture\", \"S/390:z/Architecture_2\", \"PA-RISC:PA-RISC_1.0\", \"PA-RISC:PA-RISC_2.0\", \"ARM:A32\", \"ARM:A64\", \"MIPS:MIPS_I\", \"MIPS:MIPS_II\", \"MIPS:MIPS_III\", \"MIPS:MIPS_IV\", \"MIPS:MIPS_V\", \"MIPS:MIPS32\", \"MIPS64:MIPS64\", \"Alpha:Alpha\", \"SPARC:SPARC_V7\", \"SPARC:SPARC_V8\", \"SPARC:SPARC_V9\", \"SPARC:SPARC_JPS1\", \"SPARC:UltraSPARC2005\", \"SPARC:UltraSPARC2007\", \"68k:68000\", \"68k:68010\", \"68k:68020\", \"68k:68030\", \"68k:68040\", \"68k:68060\"]}','2025-11-29 07:23:09',NULL),(2,1,'ProcessorArchitecture','{\"title\": \"Processor Architecture\", \"description\": \"Identifies the processor architecture of the processor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"IA-64\", \"AS/400\", \"Power\", \"S/390\", \"PA-RISC\", \"ARM\", \"MIPS\", \"Alpha\", \"SPARC\", \"68k\"]}','2025-11-29 07:23:09',NULL),(3,1,'InstructionSetExtensionName','{\"title\": \"Instruction Set Extension\", \"description\": \"Identifies the instruction set extensions of the processor within a processor architecture.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"x86:3DNow\", \"x86:3DNowExt\", \"x86:ABM\", \"x86:AES\", \"x86:AVX\", \"x86:AVX2\", \"x86:BMI\", \"x86:CX16\", \"x86:F16C\", \"x86:FSGSBASE\", \"x86:LWP\", \"x86:MMX\", \"x86:PCLMUL\", \"x86:RDRND\", \"x86:SSE2\", \"x86:SSE3\", \"x86:SSSE3\", \"x86:SSE4A\", \"x86:SSE41\", \"x86:SSE42\", \"x86:FMA3\", \"x86:FMA4\", \"x86:XOP\", \"x86:TBM\", \"x86:VT-d\", \"x86:VT-x\", \"x86:EPT\", \"x86:SVM\", \"PA-RISC:MAX\", \"PA-RISC:MAX2\", \"ARM:DSP\", \"ARM:Jazelle-DBX\", \"ARM:Thumb\", \"ARM:Thumb-2\", \"ARM:ThumbEE)\", \"ARM:VFP\", \"ARM:NEON\", \"ARM:TrustZone\", \"MIPS:MDMX\", \"MIPS:MIPS-3D\", \"Alpha:BWX\", \"Alpha:FIX\", \"Alpha:CIX\", \"Alpha:MVI\"]}}','2025-11-29 07:23:09',NULL),(4,2,'Address','{\"title\": \"Address\", \"description\": \"The address of the resource.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(5,2,'AddressOnParent','{\"title\": \"Address On Parent\", \"description\": \"Describes the address of this resource in the context of the Parent.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(6,2,'AllocationUnits','{\"title\": \"Allocation Units\", \"description\": \"This property specifies the units of allocation used by the Reservation and Limit properties.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(7,2,'AutomaticAllocation','{\"title\": \"Automatic Allocation\", \"description\": \"This property specifies if the resource will be automatically allocated.\", \"type\": \"boolean\"}','2025-11-29 07:23:09',NULL),(8,2,'AutomaticDeallocation','{\"title\": \"Automatic Deallocation\", \"description\": \"This property specifies if the resource will be automatically de-allocated.\", \"type\": \"boolean\"}','2025-11-29 07:23:09',NULL),(9,2,'ConsumerVisibility','{\"title\": \"Consumer Visibility\", \"description\": \"Describes the consumers visibility to the allocated resource.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Passed-Through\", \"Virtualized\", \"Not represented\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-11-29 07:23:09',NULL),(10,2,'Limit','{\"title\": \"Limit\", \"description\": \"This property specifies the upper bound, or maximum amount of resource that will be granted for this allocation.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(11,2,'MappingBehavior','{\"title\": \"Mapping Behavior\", \"description\": \"Specifies how this resource maps to underlying resources. If the HostResource array contains any entries, this property reflects how the resource maps to those specific resources.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Not Supported\", \"Dedicated\", \"Soft Affinity\", \"Hard Affinity\", \"DMTF Reserved\", \"Vendor Reserved\"]}','2025-11-29 07:23:09',NULL),(12,2,'OtherResourceType','{\"title\": \"Other Resource Type\", \"description\": \"A string that describes the resource type when a well defined value is not available and ResourceType has the value \'Other\'.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(13,2,'Parent','{\"title\": \"Parent\", \"description\": \"The Parent of the resource.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(14,2,'PoolID','{\"title\": \"Pool ID\", \"description\": \"This property specifies which ResourcePool the resource is currently allocated from, or which ResourcePool the resource will be allocated from when the allocation occurs.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(15,2,'Reservation','{\"title\": \"Reservation\", \"description\": \"This property specifies the amount of resource guaranteed to be available for this allocation.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(16,2,'ResourceSubType','{\"title\": \"Resource Sub Type\", \"description\": \"A string describing an implementation specific sub-type for this resource.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(17,2,'ResourceType','{\"title\": \"Resource Type\", \"description\": \"The type of resource this allocation setting represents.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Other\", \"Computer System\", \"Processor\", \"Memory\", \"IDE Controller\", \"Parallel SCSI HBA\", \"FC HBA\", \"iSCSI HBA\", \"IB HCA\", \"Ethernet Adapter\", \"Other Network Adapter\", \"I/O Slot\", \"I/O Device\", \"Floppy Drive\", \"CD Drive\", \"DVD drive\", \"Disk Drive\", \"Tape Drive\", \"Storage Extent\", \"Other storage device\", \"Serial port\", \"Parallel port\", \"USB Controller\", \"Graphics controller\", \"IEEE 1394 Controller\", \"Partitionable Unit\", \"Base Partitionable Unit\", \"Power\", \"Cooling Capacity\", \"Ethernet Switch Port\", \"Logical Disk\", \"Storage Volume\", \"Ethernet Connection\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-11-29 07:23:09',NULL),(18,2,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"This property specifies the quantity of resources presented to the consumer.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(19,2,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(20,2,'Weight','{\"title\": \"Weight\", \"description\": \"This property specifies a relative priority for this allocation in relation to other allocations from the same ResourcePool.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(21,2,'Connection','{\"title\": \"Connection\", \"description\": \"The thing to which this resource is connected.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(22,2,'HostResource','{\"title\": \"Host Resource\", \"description\": \"This property exposes specific assignment of resources.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(23,3,'Access','{\"title\": \"Access\", \"description\": \"Access describes whether the allocated storage extent is 1 (readable), 2 (writeable), or 3 (both).\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Readable\", \"Writeable\", \"Read/Write Supported\", \"DMTF Reserved\"]}','2025-11-29 07:23:09',NULL),(24,3,'HostExtentName','{\"title\": \"Host Extent Name\", \"description\": \"A unique identifier for the host extent.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(25,3,'HostExtentNameFormat','{\"title\": \"Host Extent Name Format\", \"description\": \"The HostExtentNameFormat property identifies the format that is used for the value of the HostExtentName property.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"SNVM\", \"NAA\", \"EUI64\", \"T10VID\", \"OS Device Name\", \"DMTF Reserved\"]}','2025-11-29 07:23:09',NULL),(26,3,'HostExtentNameNamespace','{\"title\": \"Host Extent Name Namespace\", \"description\": \"If the host extent is a SCSI volume, then the preferred source for SCSI volume names is SCSI VPD Page 83 responses.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"VPD83Type3\", \"VPD83Type2\", \"VPD83Type1\", \"VPD80\", \"NodeWWN\", \"SNVM\", \"OS Device Namespace\", \"DMTF Reserved\"]}','2025-11-29 07:23:09',NULL),(27,3,'HostExtentStartingAddress','{\"title\": \"Host Extent Starting Address\", \"description\": \"The HostExtentStartingAddress property identifies the starting address on the host storage extent identified by the value of the HostExtentName property that is used for the allocation of the virtual storage extent.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(28,3,'HostResourceBlockSize','{\"title\": \"Host Resource Block Size\", \"description\": \"Size in bytes of the blocks that are allocated at the host as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(29,3,'Limit','{\"title\": \"Limit\", \"description\": \"The maximum amount of blocks that will be granted for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(30,3,'OtherHostExtentNameFormat','{\"title\": \"Other Host Extent Name Format\", \"description\": \"A string describing the format of the HostExtentName property if the value of the HostExtentNameFormat property is 1 (Other).\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(31,3,'OtherHostExtentNameNamespace','{\"title\": \"Other Host Extent Name Namespace\", \"description\": \"A string describing the namespace of the HostExtentName property if the value of the HostExtentNameNamespace matches 1 (Other).\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(32,3,'Reservation','{\"title\": \"Reservation\", \"description\": \"The amount of blocks that are guaranteed to be available for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(33,3,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"Number of blocks that are presented to the consumer.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(34,3,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(35,3,'VirtualResourceBlockSize','{\"title\": \"Virtual Resource Block Size\", \"description\": \"Size in bytes of the blocks that are presented to the consumer as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(36,4,'AutomaticRecoveryAction','{\"title\": \"Automatic Recovery Action\", \"description\": \"Action to take for the virtual system when the software executed by the virtual system fails.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart\", \"Revert to snapshot\", \"DMTF Reserved\"]}','2025-11-29 07:23:09',NULL),(37,4,'AutomaticShutdownAction','{\"title\": \"Automatic Shutdown Action\", \"description\": \"Action to take for the virtual system when the host is shut down.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Turn Off\", \"Save state\", \"Shutdown\", \"DMTF Reserved\"]}','2025-11-29 07:23:09',NULL),(38,4,'AutomaticStartupAction','{\"title\": \"Automatic Startup Action\", \"description\": \"Action to take for the virtual system when the host is started.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart if previously active\", \"Always startup\", \"DMTF Reserved\"]}','2025-11-29 07:23:09',NULL),(39,4,'AutomaticStartupActionDelay','{\"title\": \"Automatic Startup Action Delay\", \"description\": \"Delay applicable to startup action.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(40,4,'AutomaticStartupActionSequenceNumber','{\"title\": \"Automatic Startup Action Sequence Number\", \"description\": \"Number indicating the relative sequence of virtual system activation when the host system is started.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(41,4,'ConfigurationDataRoot','{\"title\": \"Configuration Data Root\", \"description\": \"Filepath of a directory where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(42,4,'ConfigurationFile','{\"title\": \"Configuration File\", \"description\": \"Filepath of a file where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(43,4,'ConfigurationID','{\"title\": \"Configuration ID\", \"description\": \"Unique id of the virtual system configuration.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(44,4,'CreationTime','{\"title\": \"Creation Time\", \"description\": \"Time when the virtual system configuration was created.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(45,4,'LogDataRoot','{\"title\": \"Log Data Root\", \"description\": \"Filepath of a directory where log information about the virtual system is stored.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(46,4,'RecoveryFile','{\"title\": \"Recovery File\", \"description\": \"Filepath of a file where recovery relateded information of the virtual system is stored.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(47,4,'SnapshotDataRoot','{\"title\": \"Snapshot Data Root\", \"description\": \"Filepath of a directory where information about virtual system snapshots is stored.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(48,4,'SuspendDataRoot','{\"title\": \"Suspend Data Root\", \"description\": \"Filepath of a directory where suspend related information about the virtual system is stored.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(49,4,'SwapFileDataRoot','{\"title\": \"Swap File Data Root\", \"description\": \"Filepath of a directory where swapfiles of the virtual system are stored.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(50,4,'VirtualSystemIdentifier','{\"title\": \"Virtual System Identifier\", \"description\": \"VirtualSystemIdentifier shall reflect a unique name for the system as it is used within the virtualization platform.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(51,4,'VirtualSystemType','{\"title\": \"Virtual System Type\", \"description\": \"VirtualSystemType shall reflect a particular type of virtual system.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(52,4,'Notes','{\"title\": \"Notes\", \"description\": \"End-user supplied notes that are related to the virtual system.\", \"type\": \"string\"}','2025-11-29 07:23:09',NULL),(53,5,'disk_allocation_ratio','{\"title\": \"Disk Subscription Ratio\", \"description\": \"Allows the host to be under and over subscribed for the amount of disk space requested for an instance. A ratio greater than 1.0 allows for over subscription (hosts may have less usable disk space than requested). A ratio less than 1.0 allows for under subscription.\", \"type\": \"number\", \"readonly\": false}','2025-11-29 07:23:09',NULL),(54,6,'max_io_ops_per_host','{\"title\": \"Maximum IO Operations per Host\", \"description\": \"Prevents hosts in the aggregate that have this many or more instances currently in build, resize, snapshot, migrate, rescue or unshelve to be scheduled for new instances.\", \"type\": \"integer\", \"readonly\": false, \"default\": 8, \"minimum\": 1}','2025-11-29 07:23:09',NULL),(55,7,'max_instances_per_host','{\"title\": \"Max Instances Per Host\", \"description\": \"Maximum number of instances allowed to run on a host in the aggregate.\", \"type\": \"integer\", \"readonly\": false, \"minimum\": 0}','2025-11-29 07:23:09',NULL),(56,8,'cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"Type of CPU Mode.\", \"type\": \"string\", \"enum\": [\"none\", \"host-model\", \"host-passthrough\", \"custom\"]}','2025-11-29 07:23:09',NULL),(57,9,'cpu_policy','{\"title\": \"CPU Pinning policy\", \"description\": \"Type of CPU pinning policy.\", \"type\": \"string\", \"enum\": [\"shared\", \"dedicated\"]}','2025-11-29 07:23:09',NULL),(58,9,'cpu_thread_policy','{\"title\": \"CPU Thread Pinning Policy.\", \"description\": \"Type of CPU thread pinning policy.\", \"type\": \"string\", \"enum\": [\"isolate\", \"prefer\", \"require\"]}','2025-11-29 07:23:09',NULL),(59,10,'mem_page_size','{\"title\": \"Size of memory page\", \"description\": \"Page size to be used for Guest memory backing. Value can be specified as <number><unit> (i.e.: 2MB, 1GB) or \'any\', \'small\', \'large\'. If this property is set in Image metadata then only \'any\' and \'large\' values are accepted in Flavor metadata by Nova API.\", \"type\": \"string\"}','2025-11-29 07:23:10',NULL),(60,11,'os_shutdown_timeout','{\"title\": \"Shutdown timeout\", \"description\": \"By default, guests will be given 60 seconds to perform a graceful shutdown. After that, the VM is powered off.  This property allows overriding the amount of time (unit: seconds) to allow a guest OS to cleanly shut down before power off. A value of 0 (zero) means the guest will be powered off immediately with no opportunity for guest OS clean-up.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-29 07:23:10',NULL),(61,12,'cpu_info:vendor','{\"title\": \"Vendor\", \"description\": \"Specifies the CPU manufacturer.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Intel\", \"AMD\"]}','2025-11-29 07:23:10',NULL),(62,12,'cpu_info:model','{\"title\": \"Model\", \"description\": \"Specifies the CPU model. Use this property to ensure that your vm runs on a specific cpu model.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Conroe\", \"Core2Duo\", \"Penryn\", \"Nehalem\", \"Westmere\", \"SandyBridge\", \"IvyBridge\", \"Haswell\", \"Broadwell\", \"Delhi\", \"Seoul\", \"Abu Dhabi\", \"Interlagos\", \"Kabini\", \"Valencia\", \"Zurich\", \"Budapest\", \"Barcelona\", \"Suzuka\", \"Shanghai\", \"Istanbul\", \"Lisbon\", \"Magny-Cours\", \"Valencia\", \"Cortex-A57\", \"Cortex-A53\", \"Cortex-A12\", \"Cortex-A17\", \"Cortex-A15\", \"Coretx-A7\", \"X-Gene\"]}','2025-11-29 07:23:10',NULL),(63,12,'cpu_info:arch','{\"title\": \"Architecture\", \"description\": \"Specifies the CPU architecture. Use this property to specify the architecture supported by the hypervisor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"x86_64\", \"i686\", \"ia64\", \"ARMv8-A\", \"ARMv7-A\"]}','2025-11-29 07:23:10',NULL),(64,12,'cpu_info:topology:cores','{\"title\": \"cores\", \"description\": \"Number of cores.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-11-29 07:23:10',NULL),(65,12,'cpu_info:topology:threads','{\"title\": \"threads\", \"description\": \"Number of threads.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-11-29 07:23:10',NULL),(66,12,'cpu_info:topology:sockets','{\"title\": \"sockets\", \"description\": \"Number of sockets.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-11-29 07:23:10',NULL),(67,12,'cpu_info:features','{\"title\": \"Features\", \"description\": \"Specifies CPU flags/features. Using this property you can specify the required set of instructions supported by a vm.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"fpu\", \"vme\", \"de\", \"pse\", \"tsc\", \"msr\", \"pae\", \"mce\", \"cx8\", \"apic\", \"sep\", \"mtrr\", \"pge\", \"mca\", \"cmov\", \"pat\", \"pse36\", \"pn\", \"clflush\", \"dts\", \"acpi\", \"mmx\", \"fxsr\", \"sse\", \"sse2\", \"ss\", \"ht\", \"tm\", \"ia64\", \"pbe\", \"syscall\", \"mp\", \"nx\", \"mmxext\", \"fxsr_opt\", \"pdpe1gb\", \"rdtscp\", \"lm\", \"3dnowext\", \"3dnow\", \"arch_perfmon\", \"pebs\", \"bts\", \"rep_good\", \"nopl\", \"xtopology\", \"tsc_reliable\", \"nonstop_tsc\", \"extd_apicid\", \"amd_dcm\", \"aperfmperf\", \"eagerfpu\", \"nonstop_tsc_s3\", \"pni\", \"pclmulqdq\", \"dtes64\", \"monitor\", \"ds_cpl\", \"vmx\", \"smx\", \"est\", \"tm2\", \"ssse3\", \"cid\", \"fma\", \"cx16\", \"xtpr\", \"pdcm\", \"pcid\", \"dca\", \"sse4_1\", \"sse4_2\", \"x2apic\", \"movbe\", \"popcnt\", \"tsc_deadline_timer\", \"aes\", \"xsave\", \"avx\", \"f16c\", \"rdrand\", \"hypervisor\", \"rng\", \"rng_en\", \"ace\", \"ace_en\", \"ace2\", \"ace2_en\", \"phe\", \"phe_en\", \"pmm\", \"pmm_en\", \"lahf_lm\", \"cmp_legacy\", \"svm\", \"extapic\", \"cr8_legacy\", \"abm\", \"sse4a\", \"misalignsse\", \"3dnowprefetch\", \"osvw\", \"ibs\", \"xop\", \"skinit\", \"wdt\", \"lwp\", \"fma4\", \"tce\", \"nodeid_msr\", \"tbm\", \"topoext\", \"perfctr_core\", \"perfctr_nb\", \"bpext\", \"perfctr_l2\", \"mwaitx\", \"ida\", \"arat\", \"cpb\", \"epb\", \"pln\", \"pts\", \"dtherm\", \"hw_pstate\", \"proc_feedback\", \"hwp\", \"hwp_notify\", \"hwp_act_window\", \"hwp_epp\", \"hwp_pkg_req\", \"intel_pt\", \"tpr_shadow\", \"vnmi\", \"flexpriority\", \"ept\", \"vpid\", \"npt\", \"lbrv\", \"svm_lock\", \"nrip_save\", \"tsc_scale\", \"vmcb_clean\", \"flushbyasid\", \"decodeassists\", \"pausefilter\", \"pfthreshold\", \"vmmcall\", \"fsgsbase\", \"tsc_adjust\", \"bmi1\", \"hle\", \"avx2\", \"smep\", \"bmi2\", \"erms\", \"invpcid\", \"rtm\", \"cqm\", \"mpx\", \"avx512f\", \"rdseed\", \"adx\", \"smap\", \"pcommit\", \"clflushopt\", \"clwb\", \"avx512pf\", \"avx512er\", \"avx512cd\", \"sha_ni\", \"xsaveopt\", \"xsavec\", \"xgetbv1\", \"xsaves\", \"cqm_llc\", \"cqm_occup_llc\", \"clzero\"]}}','2025-11-29 07:23:10',NULL),(68,13,'hypervisor_type','{\"title\": \"Hypervisor Type\", \"description\": \"Hypervisor type required by the image. Used with the ImagePropertiesFilter. \\n\\n Baremetal - physical provisioning. hyperv - Microsoft\\u00ae hyperv. KVM - Kernel-based Virtual Machine. LXC - Linux Containers (through libvirt). powervm - IBM\\u00ae PowerVM\\u00ae. QEMU - Quick EMUlator. UML - User Mode Linux. vmware - VMware\\u00ae vsphere. VZ - Virtuozzo OS Containers and Virtual Machines (through libvirt). For more information, see: https://docs.openstack.org/nova/latest/admin/configuration/hypervisors.html\", \"type\": \"string\", \"enum\": [\"baremetal\", \"hyperv\", \"kvm\", \"lxc\", \"powervm\", \"qemu\", \"uml\", \"vmware\", \"vz\", \"xen\"]}','2025-11-29 07:23:10',NULL),(69,13,'vm_mode','{\"title\": \"VM Mode\", \"description\": \"The virtual machine mode. This represents the host/guest ABI (application binary interface) used for the virtual machine. Used with the ImagePropertiesFilter. \\n\\n hvm \\u2014 Fully virtualized - This is the virtual machine mode (vm_mode) used by QEMU and KVM. \\n\\n xen - Xen 3.0 paravirtualized. \\n\\n uml \\u2014 User Mode Linux paravirtualized. \\n\\n exe \\u2014 Executables in containers. This is the mode used by LXC.\", \"type\": \"string\", \"enum\": [\"hvm\", \"xen\", \"uml\", \"exe\"]}','2025-11-29 07:23:10',NULL),(70,14,'img_config_drive','{\"title\": \"Config Drive\", \"description\": \"This property specifies whether or not Nova should use a config drive when booting the image. Mandatory means that Nova will always use a config drive when booting the image. OpenStack can be configured to write metadata to a special configuration drive that will be attached to the instance when it boots. The instance can retrieve any information from the config drive. One use case for the config drive is to pass network configuration information to the instance. See also: http://docs.openstack.org/user-guide/cli_config_drive.html\", \"type\": \"string\", \"enum\": [\"optional\", \"mandatory\"]}','2025-11-29 07:23:10',NULL),(71,14,'os_require_quiesce','{\"title\": \"Require Quiescent File system\", \"description\": \"This property specifies whether or not the filesystem must be quiesced during snapshot processing. For volume backed and image backed snapshots, yes means that snapshotting is aborted when quiescing fails, whereas, no means quiescing will be skipped and snapshot processing will continue after the quiesce failure.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-11-29 07:23:10',NULL),(72,15,'hw_cdrom_bus','{\"title\": \"CD-ROM Bus\", \"description\": \"Specifies the type of disk controller to attach CD-ROM devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-11-29 07:23:10',NULL),(73,15,'hw_disk_bus','{\"title\": \"Disk Bus\", \"description\": \"Specifies the type of disk controller to attach disk devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-11-29 07:23:10',NULL),(74,15,'hw_firmware_type','{\"title\": \"Firmware Type\", \"description\": \"Specifies whether the image should be booted with a legacy BIOS or with UEFI.\", \"type\": \"string\", \"enum\": [\"bios\", \"uefi\"]}','2025-11-29 07:23:10',NULL),(75,15,'hw_rng_model','{\"title\": \"Random Number Generator Device\", \"description\": \"Adds a random-number generator device to the image\'s instances. The cloud administrator can enable and control device behavior by configuring the instance\'s flavor. By default: The generator device is disabled. /dev/random is used as the default entropy source. To specify a physical HW RNG device, use the following option in the nova.conf file: rng_dev_path=/dev/hwrng\", \"type\": \"string\", \"default\": \"virtio\"}','2025-11-29 07:23:10',NULL),(76,15,'hw_machine_type','{\"title\": \"Machine Type\", \"description\": \"Enables booting an ARM system using the specified machine type. By default, if an ARM image is used and its type is not specified, Compute uses vexpress-a15 (for ARMv7) or virt (for AArch64) machine types. Valid types can be viewed by using the virsh capabilities command (machine types are displayed in the machine tag).\", \"type\": \"string\"}','2025-11-29 07:23:10',NULL),(77,15,'hw_scsi_model','{\"title\": \"SCSI Model\", \"description\": \"Enables the use of VirtIO SCSI (virtio-scsi) to provide block device access for compute instances; by default, instances use VirtIO Block (virtio-blk). VirtIO SCSI is a para-virtualized SCSI controller device that provides improved scalability and performance, and supports advanced SCSI hardware.\", \"type\": \"string\", \"default\": \"virtio-scsi\"}','2025-11-29 07:23:10',NULL),(78,15,'hw_video_model','{\"title\": \"Video Model\", \"description\": \"The graphic device model presented to the guest. hw_video_model=none disables the graphics device in the guest and should generally be used when using gpu passthrough.\", \"type\": \"string\", \"enum\": [\"vga\", \"cirrus\", \"vmvga\", \"xen\", \"qxl\", \"virtio\", \"gop\", \"none\", \"bochs\"]}','2025-11-29 07:23:10',NULL),(79,15,'hw_video_ram','{\"title\": \"Max Video Ram\", \"description\": \"Maximum RAM (unit: MB) for the video image. Used only if a hw_video:ram_max_mb value has been set in the flavor\'s extra_specs and that value is higher than the value set in hw_video_ram.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-29 07:23:10',NULL),(80,15,'os_command_line','{\"title\": \"Kernel Command Line\", \"description\": \"The kernel command line to be used by the libvirt driver, instead of the default. For linux containers (LXC), the value is used as arguments for initialization. This key is valid only for Amazon kernel, ramdisk, or machine images (aki, ari, or ami).\", \"type\": \"string\"}','2025-11-29 07:23:10',NULL),(81,15,'os_type','{\"title\": \"OS Type\", \"description\": \"The operating system installed on the image. The libvirt driver contains logic that takes different actions depending on the value of the os_type parameter of the image. For example, for os_type=windows images, it creates a FAT32-based swap partition instead of a Linux swap partition, and it limits the injected host name to less than 16 characters.\", \"type\": \"string\", \"enum\": [\"linux\", \"windows\"]}','2025-11-29 07:23:10',NULL),(82,15,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor configuration. libvirt driver options: KVM and QEMU: e1000, ne2k_pci, pcnet, rtl8139, spapr-vlan, virtio, e1000e and vmxnet3. Xen: e1000, netfront, ne2k_pci, pcnet, and rtl8139.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"ne2k_pci\", \"netfront\", \"pcnet\", \"rtl8139\", \"spapr-vlan\", \"virtio\", \"vmxnet3\"]}','2025-11-29 07:23:10',NULL),(83,15,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-29 07:23:10',NULL),(84,15,'hw_pmu','{\"title\": \"Virtual Performance Monitoring Unit\", \"description\": \"Controls emulation of a vPMU in the guest. To reduce latency in realtime workloads disable the vPMU by setting hw_pmu=false\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-29 07:23:10',NULL),(85,15,'hw_qemu_guest_agent','{\"title\": \"QEMU Guest Agent\", \"description\": \"This is a background process which helps management applications execute guest OS level commands. For example, freezing and thawing filesystems, entering suspend. However, guest agent (GA) is not bullet proof, and hostile guest OS can send spurious replies.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-11-29 07:23:10',NULL),(86,15,'hw_pointer_model','{\"title\": \"Pointer Model\", \"description\": \"Input devices allow interaction with a graphical framebuffer. For example to provide a graphic tablet for absolute cursor movement. Currently only supported by the KVM/QEMU hypervisor configuration and VNC or SPICE consoles must be enabled.\", \"type\": \"string\", \"enum\": [\"usbtablet\"]}','2025-11-29 07:23:10',NULL),(87,15,'img_hide_hypervisor_id','{\"title\": \"Hide hypervisor id\", \"description\": \"Enables hiding the host hypervisor signature in the guest OS.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-11-29 07:23:10',NULL),(88,16,'serial_port_count','{\"title\": \"Serial Port Count\", \"description\": \"Specifies the count of serial ports that should be provided. If hw:serial_port_count is not set in the flavor\'s extra_specs, then any count is permitted. If hw:serial_port_count is set, then this provides the default serial port count. It is permitted to override the default serial port count, but only with a lower value.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-29 07:23:10',NULL),(89,16,'boot_menu','{\"title\": \"Boot Menu\", \"description\": \"If true, enables the BIOS bootmenu. In cases where both the image metadata and Extra Spec are set, the Extra Spec setting is used. This allows for flexibility in setting/overriding the default behavior as needed.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-29 07:23:10',NULL),(90,16,'mem_encryption','{\"title\": \"Hardware Memory Encryption\", \"description\": \"Enables encryption of guest memory at the hardware level, if there are compute hosts available which support this. See https://docs.openstack.org/nova/latest/admin/configuration/hypervisor-kvm.html#amd-sev-secure-encrypted-virtualization for details.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-29 07:23:10',NULL),(91,18,'hw_rng:allowed','{\"title\": \"Random Number Generator Allowed\", \"description\": \"\", \"type\": \"boolean\"}','2025-11-29 07:23:11',NULL),(92,18,'hw_rng:rate_bytes','{\"title\": \"Random number generator limits.\", \"description\": \"Allowed amount of bytes that the guest can read from the host\'s entropy per period.\", \"type\": \"integer\"}','2025-11-29 07:23:11',NULL),(93,18,'hw_rng:rate_period','{\"title\": \"Random number generator read period.\", \"description\": \"Duration of the read period in milliseconds.\", \"type\": \"integer\"}','2025-11-29 07:23:11',NULL),(94,19,'cpu_sockets','{\"title\": \"vCPU Sockets\", \"description\": \"Preferred number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-11-29 07:23:11',NULL),(95,19,'cpu_cores','{\"title\": \"vCPU Cores\", \"description\": \"Preferred number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-11-29 07:23:11',NULL),(96,19,'cpu_threads','{\"title\": \" vCPU Threads\", \"description\": \"Preferred number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-11-29 07:23:11',NULL),(97,19,'cpu_max_sockets','{\"title\": \"Max vCPU Sockets\", \"description\": \"Maximum number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-11-29 07:23:11',NULL),(98,19,'cpu_max_cores','{\"title\": \"Max vCPU Cores\", \"description\": \"Maximum number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-11-29 07:23:11',NULL),(99,19,'cpu_max_threads','{\"title\": \"Max vCPU Threads\", \"description\": \"Maximum number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-11-29 07:23:11',NULL),(100,20,'vmware:hw_version','{\"title\": \"VMware Hardware Version\", \"description\": \"Specifies the hardware version VMware uses to create images. If the hardware version needs to be compatible with a cluster version, for backward compatibility or other circumstances, the vmware:hw_version key specifies a virtual machine hardware version. In the event that a cluster has mixed host version types, the key will enable the vCenter to place the cluster on the correct host.\", \"type\": \"string\", \"enum\": [\"vmx-13\", \"vmx-11\", \"vmx-10\", \"vmx-09\", \"vmx-08\", \"vmx-07\", \"vmx-04\", \"vmx-03\"]}','2025-11-29 07:23:11',NULL),(101,20,'vmware:storage_policy','{\"title\": \"VMware Storage Policy\", \"description\": \"Specifies the storage policy to be applied for newly created instance. If not provided, the default storage policy specified in config file will be used. If Storage Policy Based Management (SPBM) is not enabled in config file, this value won\'t be used.\", \"type\": \"string\"}','2025-11-29 07:23:11',NULL),(102,21,'quota:cpu_limit','{\"title\": \"Quota: CPU Limit\", \"description\": \"Specifies the upper limit for CPU allocation in MHz. This parameter ensures that a machine never uses more than the defined amount of CPU time. It can be used to enforce a limit on the machine\'s CPU performance. The value should be a numerical value in MHz. If zero is supplied then the cpu_limit is unlimited.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-29 07:23:12',NULL),(103,21,'quota:cpu_reservation','{\"title\": \"Quota: CPU Reservation Limit\", \"description\": \"Specifies the guaranteed minimum CPU reservation in MHz. This means that if needed, the machine will definitely get allocated the reserved amount of CPU cycles. The value should be a numerical value in MHz.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-29 07:23:12',NULL),(104,22,'img_linked_clone','{\"title\": \"Linked Clone\", \"description\": \"By default, the VMware compute driver creates linked clones when possible (though this can be turned off by the operator). You can use this image property on a per-image basis to control whether virtual machines booted from the image are treated as full clones (value: false) or linked clones (value: true). Please refer to VMware documentation for information about full vs. linked clones.\", \"type\": \"boolean\"}','2025-11-29 07:23:12',NULL),(105,22,'vmware_adaptertype','{\"title\": \"Disk Adapter Type\", \"description\": \"The virtual SCSI or IDE controller used by the hypervisor.\", \"type\": \"string\", \"enum\": [\"lsiLogic\", \"lsiLogicsas\", \"paraVirtual\", \"busLogic\", \"ide\"], \"default\": \"lsiLogic\"}','2025-11-29 07:23:12',NULL),(106,22,'vmware_disktype','{\"title\": \"Disk Provisioning Type\", \"description\": \"When performing operations such as creating a virtual disk, cloning, or migrating, the disk provisioning type may be specified. Please refer to VMware documentation for more.\", \"type\": \"string\", \"enum\": [\"streamOptimized\", \"sparse\", \"preallocated\"], \"default\": \"preallocated\"}','2025-11-29 07:23:12',NULL),(107,22,'vmware_ostype','{\"title\": \"OS Type\", \"description\": \"A VMware GuestID which describes the operating system installed in the image. This value is passed to the hypervisor when creating a virtual machine. If not specified, the key defaults to otherGuest. See thinkvirt.com.\", \"type\": \"string\", \"enum\": [\"asianux3_64Guest\", \"asianux3Guest\", \"asianux4_64Guest\", \"asianux4Guest\", \"asianux5_64Guest\", \"asianux7_64Guest\", \"centos64Guest\", \"centosGuest\", \"centos6Guest\", \"centos6_64Guest\", \"centos7_64Guest\", \"coreos64Guest\", \"darwin10_64Guest\", \"darwin10Guest\", \"darwin11_64Guest\", \"darwin11Guest\", \"darwin12_64Guest\", \"darwin13_64Guest\", \"darwin14_64Guest\", \"darwin15_64Guest\", \"darwin16_64Guest\", \"darwin64Guest\", \"darwinGuest\", \"debian4_64Guest\", \"debian4Guest\", \"debian5_64Guest\", \"debian5Guest\", \"debian6_64Guest\", \"debian6Guest\", \"debian7_64Guest\", \"debian7Guest\", \"debian8_64Guest\", \"debian8Guest\", \"debian9_64Guest\", \"debian9Guest\", \"debian10_64Guest\", \"debian10Guest\", \"dosGuest\", \"eComStation2Guest\", \"eComStationGuest\", \"fedora64Guest\", \"fedoraGuest\", \"freebsd64Guest\", \"freebsdGuest\", \"genericLinuxGuest\", \"mandrakeGuest\", \"mandriva64Guest\", \"mandrivaGuest\", \"netware4Guest\", \"netware5Guest\", \"netware6Guest\", \"nld9Guest\", \"oesGuest\", \"openServer5Guest\", \"openServer6Guest\", \"opensuse64Guest\", \"opensuseGuest\", \"oracleLinux64Guest\", \"oracleLinuxGuest\", \"oracleLinux6Guest\", \"oracleLinux6_64Guest\", \"oracleLinux7_64Guest\", \"os2Guest\", \"other24xLinux64Guest\", \"other24xLinuxGuest\", \"other26xLinux64Guest\", \"other26xLinuxGuest\", \"other3xLinux64Guest\", \"other3xLinuxGuest\", \"otherGuest\", \"otherGuest64\", \"otherLinux64Guest\", \"otherLinuxGuest\", \"redhatGuest\", \"rhel2Guest\", \"rhel3_64Guest\", \"rhel3Guest\", \"rhel4_64Guest\", \"rhel4Guest\", \"rhel5_64Guest\", \"rhel5Guest\", \"rhel6_64Guest\", \"rhel6Guest\", \"rhel7_64Guest\", \"rhel7Guest\", \"sjdsGuest\", \"sles10_64Guest\", \"sles10Guest\", \"sles11_64Guest\", \"sles11Guest\", \"sles12_64Guest\", \"sles12Guest\", \"sles64Guest\", \"slesGuest\", \"solaris10_64Guest\", \"solaris10Guest\", \"solaris11_64Guest\", \"solaris6Guest\", \"solaris7Guest\", \"solaris8Guest\", \"solaris9Guest\", \"turboLinux64Guest\", \"turboLinuxGuest\", \"ubuntu64Guest\", \"ubuntuGuest\", \"unixWare7Guest\", \"vmkernel5Guest\", \"vmkernel6Guest\", \"vmkernel65Guest\", \"vmkernelGuest\", \"vmwarePhoton64Guest\", \"win2000AdvServGuest\", \"win2000ProGuest\", \"win2000ServGuest\", \"win31Guest\", \"win95Guest\", \"win98Guest\", \"windows7_64Guest\", \"windows7Guest\", \"windows7Server64Guest\", \"windows8_64Guest\", \"windows8Guest\", \"windows8Server64Guest\", \"windows9_64Guest\", \"windows9Guest\", \"windows9Server64Guest\", \"windowsHyperVGuest\", \"winLonghorn64Guest\", \"winLonghornGuest\", \"winMeGuest\", \"winNetBusinessGuest\", \"winNetDatacenter64Guest\", \"winNetDatacenterGuest\", \"winNetEnterprise64Guest\", \"winNetEnterpriseGuest\", \"winNetStandard64Guest\", \"winNetStandardGuest\", \"winNetWebGuest\", \"winNTGuest\", \"winVista64Guest\", \"winVistaGuest\", \"winXPHomeGuest\", \"winXPPro64Guest\", \"winXPProGuest\"], \"default\": \"otherGuest\"}','2025-11-29 07:23:13',NULL),(108,22,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor. VMware driver supported options: e1000, e1000e, VirtualE1000, VirtualE1000e, VirtualPCNet32, and VirtualVmxnet.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"VirtualE1000\", \"VirtualE1000e\", \"VirtualPCNet32\", \"VirtualVmxnet\", \"VirtualVmxnet3\"], \"default\": \"e1000\"}','2025-11-29 07:23:13',NULL),(109,22,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-29 07:23:13',NULL),(110,23,'tpm_model','{\"title\": \"TPM model\", \"description\": \"TPM model to use. Option CRB is only valid for TPM version 2.0. Defaults to TIS.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"TIS\", \"CRB\"], \"default\": \"TIS\"}','2025-11-29 07:23:13',NULL),(111,24,'COMPUTE_SECURITY_TPM_1_2','{\"title\": \"Virtual TPM Version 1.2 Support\", \"description\": \"Enables virtual TPM version 1.2.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-11-29 07:23:13',NULL),(112,24,'COMPUTE_SECURITY_TPM_2_0','{\"title\": \"Virtual TPM Version 2.0 Support\", \"description\": \"Enables virtual TPM version 2.0.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-11-29 07:23:13',NULL),(113,25,'watchdog_action','{\"title\": \"Watchdog Action\", \"description\": \"For the libvirt driver, you can enable and set the behavior of a virtual hardware watchdog device for each flavor. Watchdog devices keep an eye on the guest server, and carry out the configured action, if the server hangs. The watchdog uses the i6300esb device (emulating a PCI Intel 6300ESB). If hw_watchdog_action is not specified, the watchdog is disabled. Watchdog behavior set using a specific image\'s properties will override behavior set using flavors.\", \"type\": \"string\", \"enum\": [\"disabled\", \"reset\", \"poweroff\", \"pause\", \"none\"]}','2025-11-29 07:23:14',NULL),(114,26,'auto_disk_config','{\"title\": \"Disk Adapter Type\", \"description\": \"If true, the root partition on the disk is automatically resized before the instance boots. This value is only taken into account by the Compute service when using a Xen-based hypervisor with the XenAPI driver. The Compute service will only attempt to resize if there is a single partition on the image, and only if the partition is in ext3 or ext4 format.\", \"type\": \"boolean\"}','2025-11-29 07:23:14',NULL),(115,27,'kernel_id','{\"title\": \"Kernel ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the kernel when booting an AMI-style image.\"}','2025-11-29 07:23:14',NULL),(116,27,'ramdisk_id','{\"title\": \"Ramdisk ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the ramdisk when booting an AMI-style image.\"}','2025-11-29 07:23:14',NULL),(117,27,'instance_uuid','{\"title\": \"Instance ID\", \"type\": \"string\", \"description\": \"Metadata which can be used to record which instance this image is associated with. (Informational only, does not create an instance snapshot.)\"}','2025-11-29 07:23:14',NULL),(118,27,'architecture','{\"title\": \"CPU Architecture\", \"description\": \"The CPU architecture that must be supported by the hypervisor. For example, x86_64, arm, or ppc64. Run uname -m to get the architecture of a machine. We strongly recommend using the architecture data vocabulary defined by the libosinfo project for this purpose.\", \"type\": \"string\"}','2025-11-29 07:23:14',NULL),(119,27,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-11-29 07:23:15',NULL),(120,27,'hw_cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"This specifies the CPU Mode for the guest vm\", \"type\": \"string\"}','2025-11-29 07:23:15',NULL),(121,27,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-11-29 07:23:15',NULL),(122,27,'description','{\"title\": \"Image description\", \"description\": \"A human-readable string describing this image.\", \"type\": \"string\"}','2025-11-29 07:23:15',NULL),(123,27,'cinder_encryption_key_id','{\"title\": \"Cinder Encryption Key ID\", \"description\": \"Identifier in the OpenStack Key Management Service for the encryption key for the Block Storage Service to use when mounting a volume created from this image\", \"type\": \"string\"}','2025-11-29 07:23:15',NULL),(124,27,'cinder_encryption_key_deletion_policy','{\"title\": \"Cinder Encryption Key Deletion Policy\", \"description\": \"States the condition under which the Image Service will delete the object associated with the \'cinder_encryption_key_id\' image property.  If this property is missing, the Image Service will take no action\", \"type\": \"string\", \"enum\": [\"on_image_deletion\", \"do_not_delete\"]}','2025-11-29 07:23:15',NULL),(125,28,'img_signature','{\"title\": \"Image Signature\", \"description\": \"The signature of the image data encoded in base64 format.\", \"type\": \"string\"}','2025-11-29 07:23:17',NULL),(126,28,'img_signature_certificate_uuid','{\"title\": \"Image Signature Certificate UUID\", \"description\": \"The UUID used to retrieve the certificate from the key manager.\", \"type\": \"string\"}','2025-11-29 07:23:17',NULL),(127,28,'img_signature_hash_method','{\"title\": \"Image Signature Hash Method\", \"description\": \"The hash method used in creating the signature.\", \"type\": \"string\", \"enum\": [\"SHA-224\", \"SHA-256\", \"SHA-384\", \"SHA-512\"]}','2025-11-29 07:23:17',NULL),(128,28,'img_signature_key_type','{\"title\": \"Image Signature Key Type\", \"description\": \"The key type used in creating the signature.\", \"type\": \"string\", \"enum\": [\"RSA-PSS\", \"DSA\", \"ECC_SECT571K1\", \"ECC_SECT409K1\", \"ECC_SECT571R1\", \"ECC_SECT409R1\", \"ECC_SECP521R1\", \"ECC_SECP384R1\"]}','2025-11-29 07:23:17',NULL),(129,29,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-11-29 07:23:17',NULL),(130,29,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-11-29 07:23:17',NULL),(131,29,'os_admin_user','{\"title\": \"OS Admin User\", \"description\": \"The name of the user with admin privileges.\", \"type\": \"string\"}','2025-11-29 07:23:17',NULL),(132,33,'img_volume_type','{\"title\": \"Image Volume Type\", \"description\": \"Specifies the volume type that should be applied during new volume creation with a image. This value is passed to Cinder when creating a new volume. Priority of volume type related parameters are 1.volume_type(via API or CLI), 2.cinder_img_volume_type, 3.default_volume_type(via cinder.conf). If not specified, volume_type or default_volume_type will be referred based on their priority.\", \"type\": \"string\"}','2025-11-29 07:24:01',NULL);
/*!40000 ALTER TABLE `metadef_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_resource_types`
--

DROP TABLE IF EXISTS `metadef_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_resource_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `protected` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_resource_types_name` (`name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_resource_types`
--

LOCK TABLES `metadef_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_resource_types` (`id`, `name`, `protected`, `created_at`, `updated_at`) VALUES (1,'OS::Cinder::Volume',1,'2025-11-29 07:23:09',NULL),(2,'OS::Glance::Image',1,'2025-11-29 07:23:09',NULL),(3,'OS::Nova::Aggregate',1,'2025-11-29 07:23:09',NULL),(4,'OS::Nova::Flavor',1,'2025-11-29 07:23:09',NULL),(5,'OS::Nova::Server',1,'2025-11-29 07:23:09',NULL),(6,'OS::Trove::Instance',1,'2025-11-29 07:23:17',NULL);
/*!40000 ALTER TABLE `metadef_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_tags`
--

DROP TABLE IF EXISTS `metadef_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_tags_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_tags_name` (`name`),
  CONSTRAINT `metadef_tags_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_tags`
--

LOCK TABLES `metadef_tags` WRITE;
/*!40000 ALTER TABLE `metadef_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadef_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_info`
--

DROP TABLE IF EXISTS `task_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_info` (
  `task_id` varchar(36) NOT NULL,
  `input` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  CONSTRAINT `task_info_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_info`
--

LOCK TABLES `task_info` WRITE;
/*!40000 ALTER TABLE `task_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` varchar(36) NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `image_id` varchar(36) DEFAULT NULL,
  `request_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_tasks_deleted` (`deleted`),
  KEY `ix_tasks_owner` (`owner`),
  KEY `ix_tasks_status` (`status`),
  KEY `ix_tasks_type` (`type`),
  KEY `ix_tasks_updated_at` (`updated_at`),
  KEY `ix_tasks_image_id` (`image_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `heat`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `heat` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `heat`;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `resource_action` varchar(255) DEFAULT NULL,
  `resource_status` varchar(255) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `physical_resource_id` varchar(255) DEFAULT NULL,
  `resource_status_reason` varchar(255) DEFAULT NULL,
  `resource_type` varchar(255) DEFAULT NULL,
  `resource_properties` blob DEFAULT NULL,
  `rsrc_prop_data_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `stack_id` (`stack_id`),
  KEY `ev_rsrc_prop_data_ref` (`rsrc_prop_data_id`),
  CONSTRAINT `ev_rsrc_prop_data_ref` FOREIGN KEY (`rsrc_prop_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `event_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1507 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `event`
--

LOCK TABLES `event` WRITE;
/*!40000 ALTER TABLE `event` DISABLE KEYS */;
INSERT INTO `event` (`id`, `uuid`, `stack_id`, `created_at`, `updated_at`, `resource_action`, `resource_status`, `resource_name`, `physical_resource_id`, `resource_status_reason`, `resource_type`, `resource_properties`, `rsrc_prop_data_id`) VALUES (1,'9c5bb05a-1343-4055-9011-b27c446d36f3','73cbbbd3-2559-48d0-adeb-273aa21173f6','2025-11-29 07:56:38',NULL,'CREATE','IN_PROGRESS','api-1592030466-envstack','73cbbbd3-2559-48d0-adeb-273aa21173f6','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(2,'c84f6b73-8ede-4db8-886b-038175ed726c','39e3c4d0-31c3-472a-9429-e6d50903e0de','2025-11-29 07:56:38',NULL,'CREATE','IN_PROGRESS','api-1226968400-rsrcstack','39e3c4d0-31c3-472a-9429-e6d50903e0de','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(3,'75e14b6b-2a08-4817-a562-0bc5ada38d68','3379ec00-c2be-4662-a434-18d6494c7865','2025-11-29 07:56:39',NULL,'CREATE','IN_PROGRESS','api-1857042720-rsrcstack','3379ec00-c2be-4662-a434-18d6494c7865','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(4,'b6054485-98f6-4880-a607-0234e8cf6d98','39e3c4d0-31c3-472a-9429-e6d50903e0de','2025-11-29 07:56:39',NULL,'CREATE','IN_PROGRESS','test','api-1226968400-rsrcstack-test-7yz44p2b4sjy','state changed','OS::Heat::TestResource',NULL,1),(5,'7f6e93ab-14c9-4526-ad81-9608810f6bdc','73cbbbd3-2559-48d0-adeb-273aa21173f6','2025-11-29 07:56:39',NULL,'CREATE','IN_PROGRESS','test','api-1592030466-envstack-test-rqfctlidlfk5','state changed','OS::Heat::TestResource',NULL,2),(6,'7b793ba7-423a-41c6-814a-6f13a6bb9c70','3379ec00-c2be-4662-a434-18d6494c7865','2025-11-29 07:56:39',NULL,'CREATE','IN_PROGRESS','test','api-1857042720-rsrcstack-test-rbhryz3yzyrh','state changed','OS::Heat::TestResource',NULL,3),(7,'c6cf2472-dee9-4718-81fc-8c0e2459ce2e','39e3c4d0-31c3-472a-9429-e6d50903e0de','2025-11-29 07:56:39',NULL,'CREATE','COMPLETE','test','api-1226968400-rsrcstack-test-7yz44p2b4sjy','state changed','OS::Heat::TestResource',NULL,1),(8,'fb1ed487-7ff7-42ea-9068-491dfc6441b4','73cbbbd3-2559-48d0-adeb-273aa21173f6','2025-11-29 07:56:39',NULL,'CREATE','COMPLETE','test','api-1592030466-envstack-test-rqfctlidlfk5','state changed','OS::Heat::TestResource',NULL,2),(9,'fa85f0a2-9c52-457e-8390-84d8d6141525','39e3c4d0-31c3-472a-9429-e6d50903e0de','2025-11-29 07:56:39',NULL,'CREATE','COMPLETE','api-1226968400-rsrcstack','39e3c4d0-31c3-472a-9429-e6d50903e0de','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(10,'1d0f07f9-efa7-4640-b16a-e75eb8f338a7','73cbbbd3-2559-48d0-adeb-273aa21173f6','2025-11-29 07:56:39',NULL,'CREATE','COMPLETE','api-1592030466-envstack','73cbbbd3-2559-48d0-adeb-273aa21173f6','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(11,'97f07961-5156-44a2-8385-ee750eab040f','3379ec00-c2be-4662-a434-18d6494c7865','2025-11-29 07:56:39',NULL,'CREATE','COMPLETE','test','api-1857042720-rsrcstack-test-rbhryz3yzyrh','state changed','OS::Heat::TestResource',NULL,3),(12,'ce613c98-aeff-437f-982d-23c1b82354c5','3379ec00-c2be-4662-a434-18d6494c7865','2025-11-29 07:56:39',NULL,'CREATE','COMPLETE','api-1857042720-rsrcstack','3379ec00-c2be-4662-a434-18d6494c7865','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(13,'fd30cce6-769e-49b0-86a3-73f94ad11b3a','054684b9-132a-4198-b51f-08a6a1383c9d','2025-11-29 07:56:39',NULL,'CREATE','IN_PROGRESS','api-28086934-envstack','054684b9-132a-4198-b51f-08a6a1383c9d','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(14,'df91e443-d5bc-43e3-899e-0348525114a6','054684b9-132a-4198-b51f-08a6a1383c9d','2025-11-29 07:56:39',NULL,'CREATE','IN_PROGRESS','test','api-28086934-envstack-test-4b547m2ds4ju','state changed','OS::Heat::TestResource',NULL,4),(15,'68ba2976-3ef3-4ca9-a28a-5b4d4bb452e4','054684b9-132a-4198-b51f-08a6a1383c9d','2025-11-29 07:56:39',NULL,'CREATE','COMPLETE','test','api-28086934-envstack-test-4b547m2ds4ju','state changed','OS::Heat::TestResource',NULL,4),(16,'8d585c51-81c5-4a8c-9249-8390761452ad','054684b9-132a-4198-b51f-08a6a1383c9d','2025-11-29 07:56:39',NULL,'CREATE','COMPLETE','api-28086934-envstack','054684b9-132a-4198-b51f-08a6a1383c9d','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(17,'1d03df33-de9c-4d67-9cdf-7d5869ced2ee','054684b9-132a-4198-b51f-08a6a1383c9d','2025-11-29 07:56:41',NULL,'DELETE','IN_PROGRESS','api-28086934-envstack','054684b9-132a-4198-b51f-08a6a1383c9d','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(18,'d7f3c993-42b8-4944-bdf1-1ae2e423edf7','054684b9-132a-4198-b51f-08a6a1383c9d','2025-11-29 07:56:41',NULL,'DELETE','IN_PROGRESS','test','api-28086934-envstack-test-4b547m2ds4ju','state changed','OS::Heat::TestResource',NULL,4),(19,'68a524f7-2773-4909-81d6-7a0b081bd2f9','054684b9-132a-4198-b51f-08a6a1383c9d','2025-11-29 07:56:41',NULL,'DELETE','COMPLETE','test','api-28086934-envstack-test-4b547m2ds4ju','state changed','OS::Heat::TestResource',NULL,4),(20,'8b2bf027-d3d0-436a-8bac-b2849af77dea','054684b9-132a-4198-b51f-08a6a1383c9d','2025-11-29 07:56:41',NULL,'DELETE','COMPLETE','api-28086934-envstack','054684b9-132a-4198-b51f-08a6a1383c9d','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(21,'0121adb9-1f74-4fb6-ac6f-f32bbab331d2','3379ec00-c2be-4662-a434-18d6494c7865','2025-11-29 07:56:42',NULL,'CHECK','FAILED','test','api-1857042720-rsrcstack-test-rbhryz3yzyrh','resource deleted','OS::Heat::TestResource',NULL,3),(22,'7a234a1f-62ed-455d-ab9a-b839d6a4b744','eede8308-afc1-45ef-b05b-7d9d5c707cdb','2025-11-29 07:56:42',NULL,'CREATE','IN_PROGRESS','api-28086934-rsrcstack','eede8308-afc1-45ef-b05b-7d9d5c707cdb','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(23,'ae7106fb-57eb-4e81-a359-8528f225c3dd','eede8308-afc1-45ef-b05b-7d9d5c707cdb','2025-11-29 07:56:42',NULL,'CREATE','IN_PROGRESS','test','api-28086934-rsrcstack-test-ygme6vv5zewu','state changed','OS::Heat::TestResource',NULL,5),(24,'9cb1fdce-defe-474f-969f-a6e53dc7b669','eede8308-afc1-45ef-b05b-7d9d5c707cdb','2025-11-29 07:56:42',NULL,'CREATE','COMPLETE','test','api-28086934-rsrcstack-test-ygme6vv5zewu','state changed','OS::Heat::TestResource',NULL,5),(25,'c7ef0fae-5c92-4dd9-bcdc-eeb2523007b8','eede8308-afc1-45ef-b05b-7d9d5c707cdb','2025-11-29 07:56:42',NULL,'CREATE','COMPLETE','api-28086934-rsrcstack','eede8308-afc1-45ef-b05b-7d9d5c707cdb','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(26,'49a80ad8-3e86-4c14-8d21-022f8524571b','9f57d290-4c23-407f-9a7c-c5b53e74baf3','2025-11-29 07:56:43',NULL,'CREATE','IN_PROGRESS','api-1592030466-rsrcstack','9f57d290-4c23-407f-9a7c-c5b53e74baf3','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(27,'141547ac-bb4e-4c27-9e12-9ca343c6fcb7','9f57d290-4c23-407f-9a7c-c5b53e74baf3','2025-11-29 07:56:43',NULL,'CREATE','IN_PROGRESS','test','api-1592030466-rsrcstack-test-agbx65qsugzq','state changed','OS::Heat::TestResource',NULL,6),(28,'ad25fa57-1acc-4534-8ff6-56981eba02dc','9f57d290-4c23-407f-9a7c-c5b53e74baf3','2025-11-29 07:56:43',NULL,'CREATE','COMPLETE','test','api-1592030466-rsrcstack-test-agbx65qsugzq','state changed','OS::Heat::TestResource',NULL,6),(29,'281fae9e-10ab-4588-8e25-16bcc866aff7','9f57d290-4c23-407f-9a7c-c5b53e74baf3','2025-11-29 07:56:43',NULL,'CREATE','COMPLETE','api-1592030466-rsrcstack','9f57d290-4c23-407f-9a7c-c5b53e74baf3','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(30,'3d030792-081f-41a1-bf7b-676b932eaf7a','3379ec00-c2be-4662-a434-18d6494c7865','2025-11-29 07:56:43',NULL,'DELETE','IN_PROGRESS','api-1857042720-rsrcstack','3379ec00-c2be-4662-a434-18d6494c7865','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(31,'b5c62ca4-da43-4c78-80f2-a19739175b07','3379ec00-c2be-4662-a434-18d6494c7865','2025-11-29 07:56:43',NULL,'DELETE','IN_PROGRESS','test','api-1857042720-rsrcstack-test-rbhryz3yzyrh','state changed','OS::Heat::TestResource',NULL,3),(32,'2c57a7c3-28cc-41ca-addd-0493ce31fb67','3379ec00-c2be-4662-a434-18d6494c7865','2025-11-29 07:56:43',NULL,'DELETE','COMPLETE','test','api-1857042720-rsrcstack-test-rbhryz3yzyrh','state changed','OS::Heat::TestResource',NULL,3),(33,'6d9b8fec-e411-46a4-a322-600f48ff4cab','3379ec00-c2be-4662-a434-18d6494c7865','2025-11-29 07:56:43',NULL,'DELETE','COMPLETE','api-1857042720-rsrcstack','3379ec00-c2be-4662-a434-18d6494c7865','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(34,'3929deb9-edb0-4300-a624-a4ccc86089c8','9f57d290-4c23-407f-9a7c-c5b53e74baf3','2025-11-29 07:56:46',NULL,'CHECK','FAILED','test','api-1592030466-rsrcstack-test-agbx65qsugzq','resource deleted','OS::Heat::TestResource',NULL,6),(35,'20d82d60-1957-406b-aec9-fdbd293f639a','23ca706e-6410-4129-a111-456e959a3b34','2025-11-29 07:56:46',NULL,'CREATE','IN_PROGRESS','api-1226968400-empty','23ca706e-6410-4129-a111-456e959a3b34','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(36,'d0d4e8c5-66d3-41e9-97e3-9148642ab85f','23ca706e-6410-4129-a111-456e959a3b34','2025-11-29 07:56:46',NULL,'CREATE','COMPLETE','api-1226968400-empty','23ca706e-6410-4129-a111-456e959a3b34','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(37,'8c7172af-f45a-4f2a-b6b3-6b604252c71b','23ca706e-6410-4129-a111-456e959a3b34','2025-11-29 07:56:46',NULL,'DELETE','IN_PROGRESS','api-1226968400-empty','23ca706e-6410-4129-a111-456e959a3b34','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(38,'4310eb4b-8bdc-4bd8-855e-d91fe563a3c5','23ca706e-6410-4129-a111-456e959a3b34','2025-11-29 07:56:46',NULL,'DELETE','COMPLETE','api-1226968400-empty','23ca706e-6410-4129-a111-456e959a3b34','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(39,'a03a5255-7979-40d6-adbf-c7730f40b880','f8139037-997b-47b3-acc0-bba75fe5499c','2025-11-29 07:56:47',NULL,'CREATE','IN_PROGRESS','api-1857042720-empty','f8139037-997b-47b3-acc0-bba75fe5499c','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(40,'69bde89a-5070-4b68-beeb-457f9fc9ccf9','f8139037-997b-47b3-acc0-bba75fe5499c','2025-11-29 07:56:47',NULL,'CREATE','COMPLETE','api-1857042720-empty','f8139037-997b-47b3-acc0-bba75fe5499c','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(41,'2d375b7f-70b2-4fc6-bc31-d497eb1a7a94','94fd2bec-6a07-479e-a595-6fb1dc96594a','2025-11-29 07:56:48',NULL,'CREATE','IN_PROGRESS','api-28086934-empty','94fd2bec-6a07-479e-a595-6fb1dc96594a','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(42,'385d3a02-d82d-47eb-80da-f41d741dae86','94fd2bec-6a07-479e-a595-6fb1dc96594a','2025-11-29 07:56:48',NULL,'CREATE','COMPLETE','api-28086934-empty','94fd2bec-6a07-479e-a595-6fb1dc96594a','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(43,'dbfc536a-4877-4f0a-a851-2f2b1542370b','4ac64ef8-0fe2-479c-8365-5b13dd0dd5aa','2025-11-29 07:56:48',NULL,'CREATE','IN_PROGRESS','api-1226968400-stack','4ac64ef8-0fe2-479c-8365-5b13dd0dd5aa','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(44,'2f37522d-f559-4d8f-8642-1b5fb3364558','4ac64ef8-0fe2-479c-8365-5b13dd0dd5aa','2025-11-29 07:56:48',NULL,'CREATE','IN_PROGRESS','test','api-1226968400-stack-test-uunwijbz766w','state changed','OS::Heat::TestResource',NULL,7),(45,'9e0cbc2e-1d4b-46b2-9cf3-3120423efc88','4ac64ef8-0fe2-479c-8365-5b13dd0dd5aa','2025-11-29 07:56:48',NULL,'CREATE','COMPLETE','test','api-1226968400-stack-test-uunwijbz766w','state changed','OS::Heat::TestResource',NULL,7),(46,'1c170434-477d-4a5c-9ae4-aa2a88c28da5','4ac64ef8-0fe2-479c-8365-5b13dd0dd5aa','2025-11-29 07:56:48',NULL,'CREATE','COMPLETE','api-1226968400-stack','4ac64ef8-0fe2-479c-8365-5b13dd0dd5aa','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(47,'758ee967-adce-43af-aba6-5c95818c0af8','f8139037-997b-47b3-acc0-bba75fe5499c','2025-11-29 07:56:48',NULL,'DELETE','IN_PROGRESS','api-1857042720-empty','f8139037-997b-47b3-acc0-bba75fe5499c','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(48,'3c0ba280-1b00-48e3-a9c6-03381de4df7d','f8139037-997b-47b3-acc0-bba75fe5499c','2025-11-29 07:56:48',NULL,'DELETE','COMPLETE','api-1857042720-empty','f8139037-997b-47b3-acc0-bba75fe5499c','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(49,'4209bdac-7ef8-406f-9f21-968d73788450','94fd2bec-6a07-479e-a595-6fb1dc96594a','2025-11-29 07:56:48',NULL,'DELETE','IN_PROGRESS','api-28086934-empty','94fd2bec-6a07-479e-a595-6fb1dc96594a','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(50,'2dddcc18-29c0-4262-a18e-bc1812560cf0','94fd2bec-6a07-479e-a595-6fb1dc96594a','2025-11-29 07:56:48',NULL,'DELETE','COMPLETE','api-28086934-empty','94fd2bec-6a07-479e-a595-6fb1dc96594a','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(51,'332a87f7-40e2-46db-a701-3c41cb560a11','64a216bd-7cde-4251-8604-44a873e13dff','2025-11-29 07:56:49',NULL,'CREATE','IN_PROGRESS','api-1857042720-stack','64a216bd-7cde-4251-8604-44a873e13dff','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(52,'fedaaf68-9939-47d4-8b8c-6e12ba8867c2','64a216bd-7cde-4251-8604-44a873e13dff','2025-11-29 07:56:49',NULL,'CREATE','IN_PROGRESS','test','api-1857042720-stack-test-b63xuweruo45','state changed','OS::Heat::TestResource',NULL,8),(53,'b8b0dbc3-374d-4293-873b-d38378af8af9','64a216bd-7cde-4251-8604-44a873e13dff','2025-11-29 07:56:49',NULL,'CREATE','COMPLETE','test','api-1857042720-stack-test-b63xuweruo45','state changed','OS::Heat::TestResource',NULL,8),(54,'6bf4151b-9726-4f5d-b8a8-c00747cefa53','64a216bd-7cde-4251-8604-44a873e13dff','2025-11-29 07:56:50',NULL,'CREATE','COMPLETE','api-1857042720-stack','64a216bd-7cde-4251-8604-44a873e13dff','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(55,'f23ade20-769e-43d3-b536-91e460303870','00018af1-0bcd-47f5-b95e-1d4b9e14aa98','2025-11-29 07:56:50',NULL,'CREATE','IN_PROGRESS','api-28086934-stack','00018af1-0bcd-47f5-b95e-1d4b9e14aa98','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(56,'43b1bf41-9b8b-4d86-af21-fe89c430cc4f','00018af1-0bcd-47f5-b95e-1d4b9e14aa98','2025-11-29 07:56:50',NULL,'CREATE','IN_PROGRESS','test','api-28086934-stack-test-mdgqctxynmwn','state changed','OS::Heat::TestResource',NULL,9),(57,'4e3a6d3f-d2bf-458a-a7d9-a87389f68a00','00018af1-0bcd-47f5-b95e-1d4b9e14aa98','2025-11-29 07:56:50',NULL,'CREATE','COMPLETE','test','api-28086934-stack-test-mdgqctxynmwn','state changed','OS::Heat::TestResource',NULL,9),(58,'0bdb9092-f5d2-436b-8fdc-3bfb7665b15d','00018af1-0bcd-47f5-b95e-1d4b9e14aa98','2025-11-29 07:56:50',NULL,'CREATE','COMPLETE','api-28086934-stack','00018af1-0bcd-47f5-b95e-1d4b9e14aa98','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(59,'c1565e6d-46d6-4083-834e-a583157fc544','64a216bd-7cde-4251-8604-44a873e13dff','2025-11-29 07:56:50',NULL,'UPDATE','IN_PROGRESS','api-1857042720-stack','64a216bd-7cde-4251-8604-44a873e13dff','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(60,'22c90db5-e560-4966-a486-ad0fd2f98bd5','64a216bd-7cde-4251-8604-44a873e13dff','2025-11-29 07:56:51',NULL,'UPDATE','IN_PROGRESS','test','api-1857042720-stack-test-b63xuweruo45','state changed','OS::Heat::TestResource',NULL,8),(61,'e3fd54f8-148f-41d1-bddf-5531ec54a587','00018af1-0bcd-47f5-b95e-1d4b9e14aa98','2025-11-29 07:56:51',NULL,'UPDATE','IN_PROGRESS','api-28086934-stack','00018af1-0bcd-47f5-b95e-1d4b9e14aa98','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(62,'7af48bff-9a66-4472-94d6-1a48cd321f85','fece2f07-8916-4374-a2f4-ffdda334ad00','2025-11-29 07:56:51',NULL,'CREATE','IN_PROGRESS','api-1592030466-empty','fece2f07-8916-4374-a2f4-ffdda334ad00','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(63,'4d0c2f75-7b0c-4bcd-8b14-6c497da95e7b','fece2f07-8916-4374-a2f4-ffdda334ad00','2025-11-29 07:56:51',NULL,'CREATE','COMPLETE','api-1592030466-empty','fece2f07-8916-4374-a2f4-ffdda334ad00','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(64,'0c90059b-e7f5-488a-9220-a8f1efe34ee1','00018af1-0bcd-47f5-b95e-1d4b9e14aa98','2025-11-29 07:56:51',NULL,'UPDATE','IN_PROGRESS','test','api-28086934-stack-test-mdgqctxynmwn','state changed','OS::Heat::TestResource',NULL,9),(65,'c976f6ec-2deb-48c5-9dc3-d074422b576b','fece2f07-8916-4374-a2f4-ffdda334ad00','2025-11-29 07:56:51',NULL,'DELETE','IN_PROGRESS','api-1592030466-empty','fece2f07-8916-4374-a2f4-ffdda334ad00','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(66,'ab089722-e89e-4e8a-9226-231fe4b8e39d','fece2f07-8916-4374-a2f4-ffdda334ad00','2025-11-29 07:56:51',NULL,'DELETE','COMPLETE','api-1592030466-empty','fece2f07-8916-4374-a2f4-ffdda334ad00','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(67,'3c91a513-59d3-45f5-9f08-f26b0dd238fb','4a915ecb-a078-4c37-ae7d-1f59204f6d4e','2025-11-29 07:56:52',NULL,'CREATE','IN_PROGRESS','api-1592030466-stack','4a915ecb-a078-4c37-ae7d-1f59204f6d4e','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(68,'61b2447f-b8f6-4f20-be01-6be2f2771a5e','ecc7b267-89a8-485e-b7bb-52a583fc8411','2025-11-29 07:56:52',NULL,'CREATE','IN_PROGRESS','UpdatePortTest-1106060137','ecc7b267-89a8-485e-b7bb-52a583fc8411','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(69,'3eb5cc8f-e7f5-493e-bcd3-35bfa56848ff','4a915ecb-a078-4c37-ae7d-1f59204f6d4e','2025-11-29 07:56:52',NULL,'CREATE','IN_PROGRESS','test','api-1592030466-stack-test-yra5dbrkf2zc','state changed','OS::Heat::TestResource',NULL,10),(70,'028da6c3-567a-4839-bd02-a8be934ff1d7','4a915ecb-a078-4c37-ae7d-1f59204f6d4e','2025-11-29 07:56:52',NULL,'CREATE','COMPLETE','test','api-1592030466-stack-test-yra5dbrkf2zc','state changed','OS::Heat::TestResource',NULL,10),(71,'33ab99d1-a054-4591-a048-2c9387033e18','4a915ecb-a078-4c37-ae7d-1f59204f6d4e','2025-11-29 07:56:52',NULL,'CREATE','COMPLETE','api-1592030466-stack','4a915ecb-a078-4c37-ae7d-1f59204f6d4e','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(72,'f48b2929-8945-43d1-972a-5c8405a01604','ecc7b267-89a8-485e-b7bb-52a583fc8411','2025-11-29 07:56:52',NULL,'CREATE','IN_PROGRESS','net','UpdatePortTest-1106060137-net-xaatxaqb5wr6','state changed','OS::Neutron::Net',NULL,NULL),(73,'7a970a1c-b06a-4375-b2ee-2e17a2ddbb74','64a216bd-7cde-4251-8604-44a873e13dff','2025-11-29 07:56:53',NULL,'UPDATE','COMPLETE','test','api-1857042720-stack-test-b63xuweruo45','state changed','OS::Heat::TestResource',NULL,11),(74,'2b971206-1035-47bc-806e-1034db0b6681','64a216bd-7cde-4251-8604-44a873e13dff','2025-11-29 07:56:53',NULL,'UPDATE','COMPLETE','api-1857042720-stack','64a216bd-7cde-4251-8604-44a873e13dff','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(75,'4cd3e0b8-3993-4501-8c86-58b2f232a423','00018af1-0bcd-47f5-b95e-1d4b9e14aa98','2025-11-29 07:56:54',NULL,'UPDATE','COMPLETE','test','api-28086934-stack-test-mdgqctxynmwn','state changed','OS::Heat::TestResource',NULL,12),(76,'66ee4fa5-321d-4c45-b493-7942bd483f34','00018af1-0bcd-47f5-b95e-1d4b9e14aa98','2025-11-29 07:56:54',NULL,'UPDATE','COMPLETE','api-28086934-stack','00018af1-0bcd-47f5-b95e-1d4b9e14aa98','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(77,'93011f47-7b5c-4b1c-922b-d31911870677','4a915ecb-a078-4c37-ae7d-1f59204f6d4e','2025-11-29 07:56:55',NULL,'UPDATE','IN_PROGRESS','api-1592030466-stack','4a915ecb-a078-4c37-ae7d-1f59204f6d4e','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(78,'c5dfbdc4-264e-40f5-be03-924a9b7d7e57','64a216bd-7cde-4251-8604-44a873e13dff','2025-11-29 07:56:55',NULL,'UPDATE','IN_PROGRESS','api-1857042720-stack','64a216bd-7cde-4251-8604-44a873e13dff','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(79,'e3a71a92-79a7-4d13-b36a-f1134e36b3a5','4a915ecb-a078-4c37-ae7d-1f59204f6d4e','2025-11-29 07:56:55',NULL,'UPDATE','IN_PROGRESS','test','api-1592030466-stack-test-yra5dbrkf2zc','state changed','OS::Heat::TestResource',NULL,10),(80,'7120c709-15fc-4c6c-a8bb-357fceeb8de5','64a216bd-7cde-4251-8604-44a873e13dff','2025-11-29 07:56:55',NULL,'UPDATE','IN_PROGRESS','test','api-1857042720-stack-test-b63xuweruo45','state changed','OS::Heat::TestResource',NULL,11),(81,'2801ecde-be83-4e00-8369-e35cf0bf8093','ecc7b267-89a8-485e-b7bb-52a583fc8411','2025-11-29 07:56:55',NULL,'CREATE','COMPLETE','net','2ca42ab1-53e9-4912-a274-f87773210dfd','state changed','OS::Neutron::Net',NULL,NULL),(82,'ad4b7e35-b0d7-4876-b617-fbfb6eb6b1e4','ecc7b267-89a8-485e-b7bb-52a583fc8411','2025-11-29 07:56:55',NULL,'CREATE','IN_PROGRESS','subnet','UpdatePortTest-1106060137-subnet-plezjwikmkyl','state changed','OS::Neutron::Subnet',NULL,13),(83,'57abfc95-2d6b-40d2-8ade-c59de594b22e','4a915ecb-a078-4c37-ae7d-1f59204f6d4e','2025-11-29 07:56:57',NULL,'UPDATE','COMPLETE','test','api-1592030466-stack-test-yra5dbrkf2zc','state changed','OS::Heat::TestResource',NULL,14),(84,'5046defa-fbe7-408c-bbd2-dbe89904f8dc','64a216bd-7cde-4251-8604-44a873e13dff','2025-11-29 07:56:57',NULL,'UPDATE','COMPLETE','test','api-1857042720-stack-test-b63xuweruo45','state changed','OS::Heat::TestResource',NULL,15),(85,'33b89655-d265-4e55-a2b4-dd1f896230fd','4a915ecb-a078-4c37-ae7d-1f59204f6d4e','2025-11-29 07:56:57',NULL,'UPDATE','COMPLETE','api-1592030466-stack','4a915ecb-a078-4c37-ae7d-1f59204f6d4e','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(86,'374b99c4-cbfa-45b3-a1a7-663e10ba7956','64a216bd-7cde-4251-8604-44a873e13dff','2025-11-29 07:56:57',NULL,'UPDATE','COMPLETE','api-1857042720-stack','64a216bd-7cde-4251-8604-44a873e13dff','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(87,'4a730339-1fb8-4ccc-80cf-cf4a88ff0c60','ecc7b267-89a8-485e-b7bb-52a583fc8411','2025-11-29 07:56:58',NULL,'CREATE','COMPLETE','subnet','1d38483f-4579-43f1-aafd-6c2c5956219c','state changed','OS::Neutron::Subnet',NULL,13),(88,'1a75ef01-0004-47c1-b08f-eee3192eb82d','ecc7b267-89a8-485e-b7bb-52a583fc8411','2025-11-29 07:56:58',NULL,'CREATE','IN_PROGRESS','port','UpdatePortTest-1106060137-port-bim7xefwuf7r','state changed','OS::Neutron::Port',NULL,16),(89,'02a8feaa-eac8-4d6f-987c-dae4366af1b9','4a915ecb-a078-4c37-ae7d-1f59204f6d4e','2025-11-29 07:56:58',NULL,'UPDATE','IN_PROGRESS','api-1592030466-stack','4a915ecb-a078-4c37-ae7d-1f59204f6d4e','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(90,'a9070413-7044-4a2e-b671-10cff186b717','4a915ecb-a078-4c37-ae7d-1f59204f6d4e','2025-11-29 07:56:58',NULL,'UPDATE','IN_PROGRESS','test','api-1592030466-stack-test-yra5dbrkf2zc','state changed','OS::Heat::TestResource',NULL,14),(91,'c2ded90f-9d43-4407-b4f7-3548fdabf703','64a216bd-7cde-4251-8604-44a873e13dff','2025-11-29 07:56:58',NULL,'DELETE','IN_PROGRESS','api-1857042720-stack','64a216bd-7cde-4251-8604-44a873e13dff','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(92,'b45120c4-71e4-4647-8fe3-a9d37621fd3e','64a216bd-7cde-4251-8604-44a873e13dff','2025-11-29 07:56:58',NULL,'DELETE','IN_PROGRESS','test','api-1857042720-stack-test-b63xuweruo45','state changed','OS::Heat::TestResource',NULL,15),(93,'9bd35cd1-fabc-40e1-993a-54ef5ee2c193','64a216bd-7cde-4251-8604-44a873e13dff','2025-11-29 07:56:58',NULL,'DELETE','COMPLETE','test','api-1857042720-stack-test-b63xuweruo45','state changed','OS::Heat::TestResource',NULL,15),(94,'fd1f3c07-cc4e-4e1c-912c-1101f62eee2b','64a216bd-7cde-4251-8604-44a873e13dff','2025-11-29 07:56:58',NULL,'DELETE','COMPLETE','api-1857042720-stack','64a216bd-7cde-4251-8604-44a873e13dff','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(95,'b0311562-ef2a-489d-98da-3c9847e6a17e','f8053df6-7b93-4477-b9a8-f5463f418b78','2025-11-29 07:56:59',NULL,'CREATE','IN_PROGRESS','EncryptionVolTypeTest-396954832','f8053df6-7b93-4477-b9a8-f5463f418b78','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(96,'97394688-88c1-4dd0-8b0c-06508f93a47f','f8053df6-7b93-4477-b9a8-f5463f418b78','2025-11-29 07:56:59',NULL,'CREATE','IN_PROGRESS','my_volume_type','EncryptionVolTypeTest-396954832-my_volume_type-epnjj3xijqdm','state changed','OS::Cinder::VolumeType',NULL,17),(97,'9cfedbb1-7c76-4163-b4a1-fd2230accdf6','f8053df6-7b93-4477-b9a8-f5463f418b78','2025-11-29 07:56:59',NULL,'CREATE','COMPLETE','my_volume_type','80708cfd-e1ee-4e29-b100-8090d4d2d40f','state changed','OS::Cinder::VolumeType',NULL,17),(98,'a44383df-1bf7-4eb1-a4a2-b81630f56ef6','f8053df6-7b93-4477-b9a8-f5463f418b78','2025-11-29 07:56:59',NULL,'CREATE','IN_PROGRESS','my_encrypted_vol_type','EncryptionVolTypeTest-396954832-my_encrypted_vol_type-xt7ro2vjpn2v','state changed','OS::Cinder::EncryptedVolumeType',NULL,18),(99,'2ea57bf4-aa40-486a-8cea-3621a1b9f988','ecc7b267-89a8-485e-b7bb-52a583fc8411','2025-11-29 07:57:00',NULL,'CREATE','COMPLETE','port','b3f73e9e-aafe-4296-a564-7eea6804c7be','state changed','OS::Neutron::Port',NULL,16),(100,'e66947b8-e7ee-4e29-b227-19b99a893eef','f8053df6-7b93-4477-b9a8-f5463f418b78','2025-11-29 07:57:00',NULL,'CREATE','COMPLETE','my_encrypted_vol_type','80708cfd-e1ee-4e29-b100-8090d4d2d40f','state changed','OS::Cinder::EncryptedVolumeType',NULL,18),(101,'a645de08-e8de-403b-88f6-e435128f77f5','f8053df6-7b93-4477-b9a8-f5463f418b78','2025-11-29 07:57:00',NULL,'CREATE','COMPLETE','EncryptionVolTypeTest-396954832','f8053df6-7b93-4477-b9a8-f5463f418b78','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(102,'42af967b-bb30-46d4-8b73-01b5b294667c','ecc7b267-89a8-485e-b7bb-52a583fc8411','2025-11-29 07:57:00',NULL,'CREATE','IN_PROGRESS','test','UpdatePortTest-1106060137-test-ve2fewu7qnxu','state changed','OS::Heat::TestResource',NULL,20),(103,'866adb8e-5c3a-43a1-b876-dd2fd21bbc07','ecc7b267-89a8-485e-b7bb-52a583fc8411','2025-11-29 07:57:00',NULL,'CREATE','COMPLETE','test','UpdatePortTest-1106060137-test-ve2fewu7qnxu','state changed','OS::Heat::TestResource',NULL,20),(104,'f510a99f-d62b-4dae-a971-8e82419614f8','ecc7b267-89a8-485e-b7bb-52a583fc8411','2025-11-29 07:57:00',NULL,'CREATE','COMPLETE','UpdatePortTest-1106060137','ecc7b267-89a8-485e-b7bb-52a583fc8411','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(105,'4c98cef3-a822-43e6-9400-a9ca998f75a0','4a915ecb-a078-4c37-ae7d-1f59204f6d4e','2025-11-29 07:57:00',NULL,'UPDATE','COMPLETE','test','api-1592030466-stack-test-yra5dbrkf2zc','state changed','OS::Heat::TestResource',NULL,21),(106,'206309b4-7e99-45d2-8398-e953574ab58e','4a915ecb-a078-4c37-ae7d-1f59204f6d4e','2025-11-29 07:57:00',NULL,'UPDATE','COMPLETE','api-1592030466-stack','4a915ecb-a078-4c37-ae7d-1f59204f6d4e','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(107,'5b3bda0c-4ee3-4320-9337-161be79b6db3','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:01',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-2094757575','7628f113-095b-4912-9765-4429d35b43cd','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(108,'87e3f7bc-5abd-4b25-aa83-ffe8cf07c45a','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:01',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-2094757575-trunk_net_two-ndbbei4excci','state changed','OS::Neutron::Net',NULL,NULL),(109,'e6841a5c-8188-4167-842b-f5cf029e974b','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:02',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-2094757575-parent_net-ihaiiw65fdo6','state changed','OS::Neutron::Net',NULL,NULL),(110,'c7517a82-4cf0-48e9-b2ba-ad3786502f5e','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:02',NULL,'CREATE','COMPLETE','trunk_net_two','7cca3bf8-a5c0-44ad-b139-0689e7cf9637','state changed','OS::Neutron::Net',NULL,NULL),(111,'9219aeff-9b0e-4c33-88d6-e1ed180ed35e','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:02',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-2094757575-trunk_subnet_two-ni3iywrrgniu','state changed','OS::Neutron::Subnet',NULL,22),(112,'b16ecee7-6601-40e9-8ba3-b39ca0cd5a73','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:03',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-2094757575-trunk_net_one-oav4pm5cbtsm','state changed','OS::Neutron::Net',NULL,NULL),(113,'a260611f-1ceb-4d0f-a8e1-f074683a94b6','ecc7b267-89a8-485e-b7bb-52a583fc8411','2025-11-29 07:57:03',NULL,'UPDATE','IN_PROGRESS','UpdatePortTest-1106060137','ecc7b267-89a8-485e-b7bb-52a583fc8411','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(114,'21789a68-e17f-4c3b-aedc-6cc020aa2caa','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:03',NULL,'CREATE','COMPLETE','parent_net','fe9c61f0-6529-4d74-9bdd-352b3cfdc6ab','state changed','OS::Neutron::Net',NULL,NULL),(115,'cd840213-3084-4deb-8c83-f4bea39c64e1','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:03',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-2094757575-parent_subnet-5ydgxsrs43ck','state changed','OS::Neutron::Subnet',NULL,23),(116,'d411eb11-014e-4c6c-ab46-ca263e5ca4d6','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:04',NULL,'CREATE','COMPLETE','trunk_net_one','c6c622e7-c69d-4cf7-9127-8a1343663b15','state changed','OS::Neutron::Net',NULL,NULL),(117,'60d6b3e7-9ae6-4f3c-93a4-27547228cd20','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:04',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-2094757575-trunk_subnet_one-rczcp3aqyfhy','state changed','OS::Neutron::Subnet',NULL,24),(118,'be50b71d-8f79-440b-a353-bb04b0f06310','ecc7b267-89a8-485e-b7bb-52a583fc8411','2025-11-29 07:57:04',NULL,'UPDATE','IN_PROGRESS','port','b3f73e9e-aafe-4296-a564-7eea6804c7be','state changed','OS::Neutron::Port',NULL,16),(119,'82854629-6c7a-4f7a-8e4d-54d2165f84a9','759f3dcd-2b7e-4386-bc1c-f8b4ffb747b8','2025-11-29 07:57:04',NULL,'CREATE','IN_PROGRESS','add_network','759f3dcd-2b7e-4386-bc1c-f8b4ffb747b8','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(120,'81bfb0b2-57f4-4eb0-94a2-d65a8630f607','759f3dcd-2b7e-4386-bc1c-f8b4ffb747b8','2025-11-29 07:57:04',NULL,'CREATE','IN_PROGRESS','net','add_network-net-ml7ld5nb27ch','state changed','OS::Neutron::Net',NULL,25),(121,'5d710a61-b153-4679-9668-accaf459d706','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:05',NULL,'CREATE','COMPLETE','trunk_subnet_two','c2b200ae-6b17-4e03-bcea-992e3f2e1a61','state changed','OS::Neutron::Subnet',NULL,22),(122,'60d1d6e4-8646-47b5-a35e-4efddbe6f235','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:05',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-2094757575-sub_port_two-vtge5yqrsg6y','state changed','OS::Neutron::Port',NULL,26),(123,'78c619c8-5b48-416d-a885-2e52b5862f5a','f8053df6-7b93-4477-b9a8-f5463f418b78','2025-11-29 07:57:05',NULL,'UPDATE','IN_PROGRESS','EncryptionVolTypeTest-396954832','f8053df6-7b93-4477-b9a8-f5463f418b78','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(124,'a184107e-4586-40d1-8652-458fdd33d6fa','f8053df6-7b93-4477-b9a8-f5463f418b78','2025-11-29 07:57:05',NULL,'UPDATE','IN_PROGRESS','my_encrypted_vol_type','80708cfd-e1ee-4e29-b100-8090d4d2d40f','state changed','OS::Cinder::EncryptedVolumeType',NULL,18),(125,'fd4ec849-c869-43a4-8851-d79e8b480b21','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:05',NULL,'CREATE','COMPLETE','trunk_subnet_one','ef6f7a65-a509-49ae-9dc8-5399f46631c0','state changed','OS::Neutron::Subnet',NULL,24),(126,'78da5509-5e05-4df3-8df3-a73f126e1c39','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:05',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-2094757575-sub_port_one-oltljht76cgk','state changed','OS::Neutron::Port',NULL,27),(127,'a81504bd-a9d5-402f-a8fe-df6bf2f564a4','f8053df6-7b93-4477-b9a8-f5463f418b78','2025-11-29 07:57:05',NULL,'UPDATE','COMPLETE','my_encrypted_vol_type','80708cfd-e1ee-4e29-b100-8090d4d2d40f','state changed','OS::Cinder::EncryptedVolumeType',NULL,28),(128,'6eecf0ad-de35-42a8-bae2-043b9a6e4160','f8053df6-7b93-4477-b9a8-f5463f418b78','2025-11-29 07:57:05',NULL,'UPDATE','COMPLETE','EncryptionVolTypeTest-396954832','f8053df6-7b93-4477-b9a8-f5463f418b78','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(129,'2d1c750a-c6e5-4e42-afa3-c303335b4bc7','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:06',NULL,'CREATE','COMPLETE','sub_port_one','f78b19a0-ccc4-4a9d-bc89-e8a6abfe9e42','state changed','OS::Neutron::Port',NULL,27),(130,'52e5e5b4-8458-4b89-8e79-34e97b92ad7e','759f3dcd-2b7e-4386-bc1c-f8b4ffb747b8','2025-11-29 07:57:06',NULL,'CREATE','COMPLETE','net','324fac70-4472-4ec6-9f8d-a12293ae7bcc','state changed','OS::Neutron::Net',NULL,25),(131,'863a02aa-c7b5-4247-a4ca-50048f3441d6','759f3dcd-2b7e-4386-bc1c-f8b4ffb747b8','2025-11-29 07:57:06',NULL,'CREATE','IN_PROGRESS','subnet','add_network-subnet-u7x5hqekmi7f','state changed','OS::Neutron::Subnet',NULL,29),(132,'dfb7726e-89d6-4dad-9ee4-5531abe7385a','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:07',NULL,'CREATE','COMPLETE','parent_subnet','948ec39b-d83f-40a9-956c-a6083a444252','state changed','OS::Neutron::Subnet',NULL,23),(133,'4c72b232-d4f0-498c-ac0e-61cdc716730b','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:07',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-2094757575-parent_port-usgivwhwhuzx','state changed','OS::Neutron::Port',NULL,30),(134,'30a4b2f8-b869-49c6-9df3-ad1873d9c757','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:07',NULL,'CREATE','COMPLETE','sub_port_two','97c0da32-4a60-4a75-922b-8a5167941bff','state changed','OS::Neutron::Port',NULL,26),(135,'ef7a8812-840a-47a0-8e7f-8ccd9e905d25','ecc7b267-89a8-485e-b7bb-52a583fc8411','2025-11-29 07:57:07',NULL,'UPDATE','COMPLETE','port','b3f73e9e-aafe-4296-a564-7eea6804c7be','state changed','OS::Neutron::Port',NULL,31),(136,'c20f68cd-bde7-459a-b395-631e76d53bba','ecc7b267-89a8-485e-b7bb-52a583fc8411','2025-11-29 07:57:08',NULL,'UPDATE','COMPLETE','UpdatePortTest-1106060137','ecc7b267-89a8-485e-b7bb-52a583fc8411','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(137,'63b36eb1-1a2f-4611-af5a-6528e67d3391','759f3dcd-2b7e-4386-bc1c-f8b4ffb747b8','2025-11-29 07:57:10',NULL,'CREATE','COMPLETE','subnet','3bf3daea-a1df-4654-8e41-0b6ed87c6718','state changed','OS::Neutron::Subnet',NULL,29),(138,'836c0fdf-8794-401e-8d5c-28f4a34abfa0','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:10',NULL,'CREATE','COMPLETE','parent_port','41880895-0d10-4663-b2b8-b16c310c5fa2','state changed','OS::Neutron::Port',NULL,30),(139,'5a20171d-bd65-4dbb-97f6-353fba01e6a9','759f3dcd-2b7e-4386-bc1c-f8b4ffb747b8','2025-11-29 07:57:10',NULL,'CREATE','IN_PROGRESS','server','add_network-server-mykwke43p3qt','state changed','OS::Nova::Server',NULL,33),(140,'a5621636-2d49-4301-87fa-6d0d3956fb7e','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:10',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-2094757575-trunk-igfywsy3qel5','state changed','OS::Neutron::Trunk',NULL,34),(141,'86cbbba6-b903-4612-ac30-7616b5515fc2','f8053df6-7b93-4477-b9a8-f5463f418b78','2025-11-29 07:57:10',NULL,'DELETE','IN_PROGRESS','EncryptionVolTypeTest-396954832','f8053df6-7b93-4477-b9a8-f5463f418b78','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(142,'295792af-8f8e-4a3d-aa33-ed10d55d11dc','f8053df6-7b93-4477-b9a8-f5463f418b78','2025-11-29 07:57:10',NULL,'DELETE','IN_PROGRESS','my_encrypted_vol_type','80708cfd-e1ee-4e29-b100-8090d4d2d40f','state changed','OS::Cinder::EncryptedVolumeType',NULL,28),(143,'e75949e7-d5d1-478a-a0fc-4a99117be87e','f8053df6-7b93-4477-b9a8-f5463f418b78','2025-11-29 07:57:10',NULL,'DELETE','COMPLETE','my_encrypted_vol_type','80708cfd-e1ee-4e29-b100-8090d4d2d40f','state changed','OS::Cinder::EncryptedVolumeType',NULL,28),(144,'e808cae2-3f18-426c-bb5a-0b2c5d0a0722','f8053df6-7b93-4477-b9a8-f5463f418b78','2025-11-29 07:57:10',NULL,'DELETE','IN_PROGRESS','my_volume_type','80708cfd-e1ee-4e29-b100-8090d4d2d40f','state changed','OS::Cinder::VolumeType',NULL,17),(145,'f31a1ca2-1388-474e-a491-73b593648cfd','f8053df6-7b93-4477-b9a8-f5463f418b78','2025-11-29 07:57:10',NULL,'DELETE','COMPLETE','my_volume_type','80708cfd-e1ee-4e29-b100-8090d4d2d40f','state changed','OS::Cinder::VolumeType',NULL,17),(146,'93a02541-03be-45c8-b54d-2d421fb434a2','f8053df6-7b93-4477-b9a8-f5463f418b78','2025-11-29 07:57:10',NULL,'DELETE','COMPLETE','EncryptionVolTypeTest-396954832','f8053df6-7b93-4477-b9a8-f5463f418b78','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(147,'1e3e958b-695b-4039-93ae-1966ebfae44d','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:11',NULL,'CREATE','COMPLETE','trunk','70620cdb-3b52-4eaa-8069-6b7b91a84626','state changed','OS::Neutron::Trunk',NULL,34),(148,'4a9e2e82-55f6-4db3-b25f-410f962e09c5','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:11',NULL,'CREATE','COMPLETE','UpdateTrunkTest-2094757575','7628f113-095b-4912-9765-4429d35b43cd','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(149,'3427c461-33e4-4bfc-8567-bedb85983313','ecc7b267-89a8-485e-b7bb-52a583fc8411','2025-11-29 07:57:14',NULL,'DELETE','IN_PROGRESS','UpdatePortTest-1106060137','ecc7b267-89a8-485e-b7bb-52a583fc8411','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(150,'786034b8-f35e-4260-8f2e-6881cf7e94aa','ecc7b267-89a8-485e-b7bb-52a583fc8411','2025-11-29 07:57:14',NULL,'DELETE','IN_PROGRESS','test','UpdatePortTest-1106060137-test-ve2fewu7qnxu','state changed','OS::Heat::TestResource',NULL,20),(151,'cb0034fc-9f98-4155-8f66-bd97cb8d91fc','ecc7b267-89a8-485e-b7bb-52a583fc8411','2025-11-29 07:57:14',NULL,'DELETE','COMPLETE','test','UpdatePortTest-1106060137-test-ve2fewu7qnxu','state changed','OS::Heat::TestResource',NULL,20),(152,'7bb04acd-8b83-41db-9992-bf88ce1c800e','ecc7b267-89a8-485e-b7bb-52a583fc8411','2025-11-29 07:57:14',NULL,'DELETE','IN_PROGRESS','port','b3f73e9e-aafe-4296-a564-7eea6804c7be','state changed','OS::Neutron::Port',NULL,31),(153,'35a073ad-a4ae-43de-9c05-dee3c29f2a97','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:15',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-2094757575','7628f113-095b-4912-9765-4429d35b43cd','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(154,'c0059d5d-3efb-45ca-bf90-a495bc676ead','ecc7b267-89a8-485e-b7bb-52a583fc8411','2025-11-29 07:57:16',NULL,'DELETE','COMPLETE','port','b3f73e9e-aafe-4296-a564-7eea6804c7be','state changed','OS::Neutron::Port',NULL,31),(155,'7702b379-e4ae-49c9-9257-83faf0acceb0','ecc7b267-89a8-485e-b7bb-52a583fc8411','2025-11-29 07:57:17',NULL,'DELETE','IN_PROGRESS','subnet','1d38483f-4579-43f1-aafd-6c2c5956219c','state changed','OS::Neutron::Subnet',NULL,13),(156,'f754909c-6768-4c13-b98a-fb4b4989d6e3','637188bd-fbaf-43ce-85b0-5455580963f9','2025-11-29 07:57:17',NULL,'CREATE','IN_PROGRESS','server_with_port','637188bd-fbaf-43ce-85b0-5455580963f9','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(157,'b9cf993c-5708-45c0-a545-615a0bb4c7cd','637188bd-fbaf-43ce-85b0-5455580963f9','2025-11-29 07:57:17',NULL,'CREATE','IN_PROGRESS','net','server_with_port-net-jzh5uhgfdmbw','state changed','OS::Neutron::Net',NULL,35),(158,'5f47e4bc-0e98-49b1-8e88-5da5299b3edc','ecc7b267-89a8-485e-b7bb-52a583fc8411','2025-11-29 07:57:18',NULL,'DELETE','COMPLETE','subnet','1d38483f-4579-43f1-aafd-6c2c5956219c','state changed','OS::Neutron::Subnet',NULL,13),(159,'3e53d47d-3a7e-4ebe-87ae-87569b2e2e9b','ecc7b267-89a8-485e-b7bb-52a583fc8411','2025-11-29 07:57:18',NULL,'DELETE','IN_PROGRESS','net','2ca42ab1-53e9-4912-a274-f87773210dfd','state changed','OS::Neutron::Net',NULL,NULL),(160,'c9913a42-b89e-4266-9779-82a47f3bbab6','637188bd-fbaf-43ce-85b0-5455580963f9','2025-11-29 07:57:21',NULL,'CREATE','COMPLETE','net','f056f153-badf-4cf8-8989-4d48564077a6','state changed','OS::Neutron::Net',NULL,35),(161,'f7772319-3e96-4296-8a22-9ab1578e4d6d','637188bd-fbaf-43ce-85b0-5455580963f9','2025-11-29 07:57:21',NULL,'CREATE','IN_PROGRESS','subnet','server_with_port-subnet-k2nrz24p2yb3','state changed','OS::Neutron::Subnet',NULL,36),(162,'af46bf70-93c7-4740-860b-268a790650b8','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:21',NULL,'UPDATE','IN_PROGRESS','trunk','70620cdb-3b52-4eaa-8069-6b7b91a84626','state changed','OS::Neutron::Trunk',NULL,34),(163,'60683594-a286-4f03-8c98-cbe3fb82dd1a','ecc7b267-89a8-485e-b7bb-52a583fc8411','2025-11-29 07:57:21',NULL,'DELETE','COMPLETE','net','2ca42ab1-53e9-4912-a274-f87773210dfd','state changed','OS::Neutron::Net',NULL,NULL),(164,'919d445c-1156-4789-8a27-496142f97c9f','ecc7b267-89a8-485e-b7bb-52a583fc8411','2025-11-29 07:57:21',NULL,'DELETE','COMPLETE','UpdatePortTest-1106060137','ecc7b267-89a8-485e-b7bb-52a583fc8411','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(165,'dff5408a-a762-48f4-805a-124ce4e21d66','637188bd-fbaf-43ce-85b0-5455580963f9','2025-11-29 07:57:24',NULL,'CREATE','COMPLETE','subnet','61e6fe18-18b4-4185-9be0-8fe16c868b7c','state changed','OS::Neutron::Subnet',NULL,36),(166,'7e8ff867-2470-481b-ac1e-f487eaec4c24','637188bd-fbaf-43ce-85b0-5455580963f9','2025-11-29 07:57:24',NULL,'CREATE','IN_PROGRESS','port','server_with_port-port-2kvdff3qlbj3','state changed','OS::Neutron::Port',NULL,37),(167,'f775e1a0-1290-4585-8913-99f427f0c323','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:24',NULL,'UPDATE','COMPLETE','trunk','70620cdb-3b52-4eaa-8069-6b7b91a84626','state changed','OS::Neutron::Trunk',NULL,38),(168,'72f878ab-2751-4330-98f1-ab33256f79d4','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:24',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-2094757575','7628f113-095b-4912-9765-4429d35b43cd','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(169,'d7100497-3d0c-402c-b2dd-0bb9ef87c94e','f3692fc8-e860-4e43-8cde-f15cbd63afd2','2025-11-29 07:57:24',NULL,'CREATE','IN_PROGRESS','UpdatePortTest-2045562501','f3692fc8-e860-4e43-8cde-f15cbd63afd2','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(170,'7aa5b03a-2412-43a2-9998-128b33e7be03','f3692fc8-e860-4e43-8cde-f15cbd63afd2','2025-11-29 07:57:24',NULL,'CREATE','IN_PROGRESS','net','UpdatePortTest-2045562501-net-yjj3ekm7xjh6','state changed','OS::Neutron::Net',NULL,NULL),(171,'8e5bbe5d-2f99-40e0-8db5-7bf269adaa05','637188bd-fbaf-43ce-85b0-5455580963f9','2025-11-29 07:57:25',NULL,'CREATE','COMPLETE','port','63838e32-d696-42a3-9f2c-19aa82c4c46a','state changed','OS::Neutron::Port',NULL,37),(172,'20b00710-1845-442c-82f9-543d3cda3052','637188bd-fbaf-43ce-85b0-5455580963f9','2025-11-29 07:57:25',NULL,'CREATE','IN_PROGRESS','server','server_with_port-server-66tydbuyarp2','state changed','OS::Nova::Server',NULL,39),(173,'5542288a-9fa9-405b-b610-d34a2c245831','f3692fc8-e860-4e43-8cde-f15cbd63afd2','2025-11-29 07:57:26',NULL,'CREATE','COMPLETE','net','388713bc-4068-4ab0-ab6c-f836c0d67bcc','state changed','OS::Neutron::Net',NULL,NULL),(174,'4e15eefd-fbfa-40c8-9eb3-b8651207934f','f3692fc8-e860-4e43-8cde-f15cbd63afd2','2025-11-29 07:57:26',NULL,'CREATE','IN_PROGRESS','subnet','UpdatePortTest-2045562501-subnet-hwooduxovp3v','state changed','OS::Neutron::Subnet',NULL,40),(175,'88c31151-a541-4d37-ab80-4da5f47bdebe','f3692fc8-e860-4e43-8cde-f15cbd63afd2','2025-11-29 07:57:26',NULL,'CREATE','COMPLETE','subnet','ccb0264b-dcc8-41fb-9343-c5bbccdb143f','state changed','OS::Neutron::Subnet',NULL,40),(176,'b9cd268e-e3e5-4642-9420-195955ba8509','f3692fc8-e860-4e43-8cde-f15cbd63afd2','2025-11-29 07:57:27',NULL,'CREATE','IN_PROGRESS','port','UpdatePortTest-2045562501-port-wnrzxwvhhy34','state changed','OS::Neutron::Port',NULL,41),(177,'6c80f618-9f5b-43b2-b4a1-149e8c0cf540','f3692fc8-e860-4e43-8cde-f15cbd63afd2','2025-11-29 07:57:28',NULL,'CREATE','COMPLETE','port','b21b352e-fbaa-4f93-aea5-a501d6ae30de','state changed','OS::Neutron::Port',NULL,41),(178,'d6290c3a-3547-4b13-bf76-e20da249eb0f','f3692fc8-e860-4e43-8cde-f15cbd63afd2','2025-11-29 07:57:28',NULL,'CREATE','IN_PROGRESS','test','UpdatePortTest-2045562501-test-b7jfjn6zqld3','state changed','OS::Heat::TestResource',NULL,43),(179,'00ad51d1-6abb-4e27-b4bf-29d556ca49ad','f3692fc8-e860-4e43-8cde-f15cbd63afd2','2025-11-29 07:57:28',NULL,'CREATE','COMPLETE','test','UpdatePortTest-2045562501-test-b7jfjn6zqld3','state changed','OS::Heat::TestResource',NULL,43),(180,'18b6891f-ee4b-4040-bd49-8e746933f6b9','f3692fc8-e860-4e43-8cde-f15cbd63afd2','2025-11-29 07:57:28',NULL,'CREATE','COMPLETE','UpdatePortTest-2045562501','f3692fc8-e860-4e43-8cde-f15cbd63afd2','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(181,'f8c5091b-a580-4d79-81e0-64323ae1e1a2','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:29',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-2094757575','7628f113-095b-4912-9765-4429d35b43cd','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(182,'4fd28380-6c99-4caf-b3ce-a4eb07e3bab2','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:29',NULL,'DELETE','IN_PROGRESS','trunk','70620cdb-3b52-4eaa-8069-6b7b91a84626','state changed','OS::Neutron::Trunk',NULL,38),(183,'b6c8906c-c25d-48e6-9283-c8705aa372da','f3692fc8-e860-4e43-8cde-f15cbd63afd2','2025-11-29 07:57:30',NULL,'UPDATE','IN_PROGRESS','UpdatePortTest-2045562501','f3692fc8-e860-4e43-8cde-f15cbd63afd2','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(184,'9774ba58-8bb4-48b2-9dce-e493ac92c540','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:30',NULL,'DELETE','COMPLETE','trunk','70620cdb-3b52-4eaa-8069-6b7b91a84626','state changed','OS::Neutron::Trunk',NULL,38),(185,'3c597d65-25dd-45dc-9866-b987f5e125ca','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:30',NULL,'DELETE','IN_PROGRESS','sub_port_two','97c0da32-4a60-4a75-922b-8a5167941bff','state changed','OS::Neutron::Port',NULL,26),(186,'905edc92-2687-4f34-bf37-03e556ebb22b','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:30',NULL,'DELETE','IN_PROGRESS','sub_port_one','f78b19a0-ccc4-4a9d-bc89-e8a6abfe9e42','state changed','OS::Neutron::Port',NULL,27),(187,'3af05b2d-3786-4059-928c-9837ec7fc4bc','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:30',NULL,'DELETE','IN_PROGRESS','parent_port','41880895-0d10-4663-b2b8-b16c310c5fa2','state changed','OS::Neutron::Port',NULL,30),(188,'dd44053c-3cb6-4204-9ee3-d6392fe4f428','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:30',NULL,'DELETE','COMPLETE','parent_port','41880895-0d10-4663-b2b8-b16c310c5fa2','state changed','OS::Neutron::Port',NULL,30),(189,'cdcbab3d-c5a8-4f57-9e33-ff2202bc4072','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:30',NULL,'DELETE','IN_PROGRESS','parent_subnet','948ec39b-d83f-40a9-956c-a6083a444252','state changed','OS::Neutron::Subnet',NULL,23),(190,'16c21523-8b6d-48b5-91cf-456db9fb5226','f3692fc8-e860-4e43-8cde-f15cbd63afd2','2025-11-29 07:57:30',NULL,'UPDATE','IN_PROGRESS','port','b21b352e-fbaa-4f93-aea5-a501d6ae30de','state changed','OS::Neutron::Port',NULL,41),(191,'4ec8b07a-6823-462c-ab79-ad92749ebe15','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:31',NULL,'DELETE','COMPLETE','parent_subnet','948ec39b-d83f-40a9-956c-a6083a444252','state changed','OS::Neutron::Subnet',NULL,23),(192,'0e843496-136f-4070-9470-eca45dd08b7f','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:31',NULL,'DELETE','IN_PROGRESS','parent_net','fe9c61f0-6529-4d74-9bdd-352b3cfdc6ab','state changed','OS::Neutron::Net',NULL,NULL),(193,'508465ea-5187-4859-9e92-0ff94de9db70','759f3dcd-2b7e-4386-bc1c-f8b4ffb747b8','2025-11-29 07:57:31',NULL,'CREATE','COMPLETE','server','4f5e7f8f-1d5e-4499-9a61-c4e57a81bcc8','state changed','OS::Nova::Server',NULL,33),(194,'e34d7799-bc0f-4d87-8627-c0652c2e91a5','759f3dcd-2b7e-4386-bc1c-f8b4ffb747b8','2025-11-29 07:57:31',NULL,'CREATE','COMPLETE','add_network','759f3dcd-2b7e-4386-bc1c-f8b4ffb747b8','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(195,'85dd94db-e87f-46cb-b56b-a5487de956e7','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:31',NULL,'DELETE','COMPLETE','sub_port_one','f78b19a0-ccc4-4a9d-bc89-e8a6abfe9e42','state changed','OS::Neutron::Port',NULL,27),(196,'da7ab391-640f-4c46-961b-e6e5789b2ef7','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:31',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','ef6f7a65-a509-49ae-9dc8-5399f46631c0','state changed','OS::Neutron::Subnet',NULL,24),(197,'13b43e69-0321-4e0c-ba40-24ce36d40471','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:31',NULL,'DELETE','COMPLETE','parent_net','fe9c61f0-6529-4d74-9bdd-352b3cfdc6ab','state changed','OS::Neutron::Net',NULL,NULL),(198,'fdf7aa4a-96a3-461b-ae43-caf897febdd5','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:31',NULL,'DELETE','COMPLETE','sub_port_two','97c0da32-4a60-4a75-922b-8a5167941bff','state changed','OS::Neutron::Port',NULL,26),(199,'e3302313-09ce-4e26-8843-648f2cccad39','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:31',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','c2b200ae-6b17-4e03-bcea-992e3f2e1a61','state changed','OS::Neutron::Subnet',NULL,22),(200,'fce8b4c6-c5ae-4194-bedc-fdf920d46e82','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:32',NULL,'DELETE','COMPLETE','trunk_subnet_one','ef6f7a65-a509-49ae-9dc8-5399f46631c0','state changed','OS::Neutron::Subnet',NULL,24),(201,'6e5f160f-7741-4778-b3f4-80705f27f761','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:32',NULL,'DELETE','IN_PROGRESS','trunk_net_one','c6c622e7-c69d-4cf7-9127-8a1343663b15','state changed','OS::Neutron::Net',NULL,NULL),(202,'983446a7-5043-4255-80e4-03e7f1daaaac','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:32',NULL,'DELETE','COMPLETE','trunk_subnet_two','c2b200ae-6b17-4e03-bcea-992e3f2e1a61','state changed','OS::Neutron::Subnet',NULL,22),(203,'c40d532c-4504-4ba1-a4f5-2bf4f91a2242','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:32',NULL,'DELETE','IN_PROGRESS','trunk_net_two','7cca3bf8-a5c0-44ad-b139-0689e7cf9637','state changed','OS::Neutron::Net',NULL,NULL),(204,'51e64c0a-e070-4e45-906e-5dda2c4f5704','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:33',NULL,'DELETE','COMPLETE','trunk_net_one','c6c622e7-c69d-4cf7-9127-8a1343663b15','state changed','OS::Neutron::Net',NULL,NULL),(205,'8b01162e-9dca-44f4-8e72-35994a072833','f3692fc8-e860-4e43-8cde-f15cbd63afd2','2025-11-29 07:57:33',NULL,'UPDATE','COMPLETE','port','b21b352e-fbaa-4f93-aea5-a501d6ae30de','The Resource port requires replacement.','OS::Neutron::Port',NULL,41),(206,'79ce7d8a-8209-4995-8611-9d771fcdc8c9','f3692fc8-e860-4e43-8cde-f15cbd63afd2','2025-11-29 07:57:33',NULL,'CREATE','IN_PROGRESS','port','UpdatePortTest-2045562501-port-625vqm2tiphz','state changed','OS::Neutron::Port',NULL,45),(207,'d575f385-4d61-4663-96a2-3726029a373d','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:33',NULL,'DELETE','COMPLETE','trunk_net_two','7cca3bf8-a5c0-44ad-b139-0689e7cf9637','state changed','OS::Neutron::Net',NULL,NULL),(208,'662780f2-a0a1-49d3-ab3d-45f9077cbe11','7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:33',NULL,'DELETE','COMPLETE','UpdateTrunkTest-2094757575','7628f113-095b-4912-9765-4429d35b43cd','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(209,'8dcde941-8885-4d1e-8a9f-e09db7da5d90','f3692fc8-e860-4e43-8cde-f15cbd63afd2','2025-11-29 07:57:34',NULL,'CREATE','COMPLETE','port','2eff65b9-4149-44b2-8e9a-7a116565247d','state changed','OS::Neutron::Port',NULL,45),(210,'fc86fde7-27fd-49f5-9aa3-e1be8746338c','f3692fc8-e860-4e43-8cde-f15cbd63afd2','2025-11-29 07:57:35',NULL,'DELETE','IN_PROGRESS','port','b21b352e-fbaa-4f93-aea5-a501d6ae30de','state changed','OS::Neutron::Port',NULL,41),(211,'d0eb5c48-c29a-4b81-9510-11c79de8738e','f3692fc8-e860-4e43-8cde-f15cbd63afd2','2025-11-29 07:57:36',NULL,'DELETE','COMPLETE','port','b21b352e-fbaa-4f93-aea5-a501d6ae30de','state changed','OS::Neutron::Port',NULL,41),(212,'a10a8b0e-bf26-4da2-a9db-e9f7a6014ebf','f3692fc8-e860-4e43-8cde-f15cbd63afd2','2025-11-29 07:57:36',NULL,'UPDATE','COMPLETE','UpdatePortTest-2045562501','f3692fc8-e860-4e43-8cde-f15cbd63afd2','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(213,'3c3527d7-b3e6-4bd5-9a75-ac4ed3e518db','f3692fc8-e860-4e43-8cde-f15cbd63afd2','2025-11-29 07:57:38',NULL,'DELETE','IN_PROGRESS','UpdatePortTest-2045562501','f3692fc8-e860-4e43-8cde-f15cbd63afd2','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(214,'db93454e-d463-4ac5-b937-ce5a56ee2cbd','f3692fc8-e860-4e43-8cde-f15cbd63afd2','2025-11-29 07:57:39',NULL,'DELETE','IN_PROGRESS','test','UpdatePortTest-2045562501-test-b7jfjn6zqld3','state changed','OS::Heat::TestResource',NULL,43),(215,'09f51830-0975-4333-9ff1-5a4a7a2aef29','f3692fc8-e860-4e43-8cde-f15cbd63afd2','2025-11-29 07:57:39',NULL,'DELETE','COMPLETE','test','UpdatePortTest-2045562501-test-b7jfjn6zqld3','state changed','OS::Heat::TestResource',NULL,43),(216,'51b0f6f8-2cb5-4e80-a764-adf305b2495f','637188bd-fbaf-43ce-85b0-5455580963f9','2025-11-29 07:57:39',NULL,'CREATE','COMPLETE','server','4ad07a10-ba8e-40b9-9d84-b18b17f7090f','state changed','OS::Nova::Server',NULL,39),(217,'aa23cc01-dc80-4790-9447-a435d1d0f27b','637188bd-fbaf-43ce-85b0-5455580963f9','2025-11-29 07:57:39',NULL,'CREATE','COMPLETE','server_with_port','637188bd-fbaf-43ce-85b0-5455580963f9','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(218,'567ff31a-1492-4d6a-b7bb-8e368fa0b437','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:57:39',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-1059206779','3eae79ce-8217-409c-93a9-2829072bca2b','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(219,'684b46f2-4210-4e62-ba75-d8b31cae248a','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:57:39',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-1059206779-parent_net-keyyukhwfa25','state changed','OS::Neutron::Net',NULL,NULL),(220,'dfc1dd5f-9a45-4aaa-9cc2-a19fa6d0c495','759f3dcd-2b7e-4386-bc1c-f8b4ffb747b8','2025-11-29 07:57:40',NULL,'UPDATE','IN_PROGRESS','add_network','759f3dcd-2b7e-4386-bc1c-f8b4ffb747b8','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(221,'ba67c570-9c18-4571-8cf8-2a6edb2c51e9','f3692fc8-e860-4e43-8cde-f15cbd63afd2','2025-11-29 07:57:40',NULL,'DELETE','IN_PROGRESS','port','2eff65b9-4149-44b2-8e9a-7a116565247d','state changed','OS::Neutron::Port',NULL,45),(222,'645fe58d-d55c-492e-8aaa-32d44c595f3e','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:57:40',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-1059206779-trunk_net_two-62kznf3ybprv','state changed','OS::Neutron::Net',NULL,NULL),(223,'5860f867-cf2a-4133-88d3-b9f4bb435497','759f3dcd-2b7e-4386-bc1c-f8b4ffb747b8','2025-11-29 07:57:41',NULL,'UPDATE','IN_PROGRESS','server','4f5e7f8f-1d5e-4499-9a61-c4e57a81bcc8','state changed','OS::Nova::Server',NULL,33),(224,'21bc4c41-c164-4415-a822-f8cdf08e9206','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:57:41',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-1059206779-trunk_net_one-wazwxjeawiun','state changed','OS::Neutron::Net',NULL,NULL),(225,'dd7b2bf8-1594-4d44-b680-d0d90337122b','f3692fc8-e860-4e43-8cde-f15cbd63afd2','2025-11-29 07:57:41',NULL,'DELETE','COMPLETE','port','2eff65b9-4149-44b2-8e9a-7a116565247d','state changed','OS::Neutron::Port',NULL,45),(226,'58e5ba43-8cc1-4a05-812a-8ed720238f32','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:57:41',NULL,'CREATE','COMPLETE','parent_net','ede51b05-7227-4f2b-980a-7d9e32ec23a5','state changed','OS::Neutron::Net',NULL,NULL),(227,'d4eb7fb0-89f3-4561-ba63-80ead90b303e','f3692fc8-e860-4e43-8cde-f15cbd63afd2','2025-11-29 07:57:41',NULL,'DELETE','IN_PROGRESS','subnet','ccb0264b-dcc8-41fb-9343-c5bbccdb143f','state changed','OS::Neutron::Subnet',NULL,40),(228,'11ff7676-882e-4169-9709-a66645ed517a','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:57:41',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-1059206779-parent_subnet-wuhww2seb2sm','state changed','OS::Neutron::Subnet',NULL,48),(229,'a871bdde-9fe4-4b43-9d22-a6530769bdf3','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:57:41',NULL,'CREATE','COMPLETE','trunk_net_two','eb3501aa-2d73-47a3-a775-5715787dcea0','state changed','OS::Neutron::Net',NULL,NULL),(230,'8d97b4ec-a48b-4866-ba39-34c0437949aa','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:57:42',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-1059206779-trunk_subnet_two-d3nqxxqcpc5v','state changed','OS::Neutron::Subnet',NULL,49),(231,'42d606b4-77c6-40b1-a1ea-42f899a3fae3','f3692fc8-e860-4e43-8cde-f15cbd63afd2','2025-11-29 07:57:42',NULL,'DELETE','COMPLETE','subnet','ccb0264b-dcc8-41fb-9343-c5bbccdb143f','state changed','OS::Neutron::Subnet',NULL,40),(232,'6d52fe9d-8fe4-4d94-bd89-2a64978772c8','f3692fc8-e860-4e43-8cde-f15cbd63afd2','2025-11-29 07:57:42',NULL,'DELETE','IN_PROGRESS','net','388713bc-4068-4ab0-ab6c-f836c0d67bcc','state changed','OS::Neutron::Net',NULL,NULL),(233,'66cf0608-6f17-42fb-9a3f-2e6d81f22f82','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:57:42',NULL,'CREATE','COMPLETE','trunk_net_one','eed5566b-6330-4837-9ce5-adee7ae4efc3','state changed','OS::Neutron::Net',NULL,NULL),(234,'f4f6a7bd-807c-47b4-897b-cab0a619e630','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:57:42',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-1059206779-trunk_subnet_one-zi3dhbaj2zpz','state changed','OS::Neutron::Subnet',NULL,50),(235,'9b986b7e-eb2a-44c2-baf0-6aa4a9c3bfa7','f3692fc8-e860-4e43-8cde-f15cbd63afd2','2025-11-29 07:57:43',NULL,'DELETE','COMPLETE','net','388713bc-4068-4ab0-ab6c-f836c0d67bcc','state changed','OS::Neutron::Net',NULL,NULL),(236,'713b753d-cd3c-4b8f-af62-4c5453325f75','f3692fc8-e860-4e43-8cde-f15cbd63afd2','2025-11-29 07:57:43',NULL,'DELETE','COMPLETE','UpdatePortTest-2045562501','f3692fc8-e860-4e43-8cde-f15cbd63afd2','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(237,'9ef5235c-feba-4b07-8ea2-1a71e3fc87e2','637188bd-fbaf-43ce-85b0-5455580963f9','2025-11-29 07:57:43',NULL,'DELETE','IN_PROGRESS','server_with_port','637188bd-fbaf-43ce-85b0-5455580963f9','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(238,'30542f9f-1da4-433e-957c-c544005949fd','637188bd-fbaf-43ce-85b0-5455580963f9','2025-11-29 07:57:43',NULL,'DELETE','IN_PROGRESS','server','4ad07a10-ba8e-40b9-9d84-b18b17f7090f','state changed','OS::Nova::Server',NULL,39),(239,'9636b995-767e-4105-874e-27bcf7162fa0','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:57:45',NULL,'CREATE','COMPLETE','parent_subnet','0bfd7345-20e5-4707-b903-d6c03a1e95e8','state changed','OS::Neutron::Subnet',NULL,48),(240,'8e8192ce-4934-4e47-b2e9-74ac3fa2b441','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:57:45',NULL,'CREATE','COMPLETE','trunk_subnet_two','6d7eb289-8dfe-4c61-a153-424b428a18c9','state changed','OS::Neutron::Subnet',NULL,49),(241,'b0c0c795-18d8-477b-9109-f361a350d5fd','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:57:45',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-1059206779-parent_port-satunkeapic5','state changed','OS::Neutron::Port',NULL,51),(242,'538174a6-4ea2-4958-96c2-43ead6241983','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:57:45',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-1059206779-sub_port_two-cg3m3q7r57yw','state changed','OS::Neutron::Port',NULL,52),(243,'5d1100f2-0f8d-4fe4-90ad-810797fbe4c2','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:57:45',NULL,'CREATE','COMPLETE','trunk_subnet_one','9de88ff9-0a5a-49f6-ac67-f010b0b3b176','state changed','OS::Neutron::Subnet',NULL,50),(244,'0312b590-7357-46e6-bd6f-5c26ae5d25cb','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:57:46',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-1059206779-sub_port_one-hmrf7gxnecs5','state changed','OS::Neutron::Port',NULL,53),(245,'969649d7-7178-44cc-8d85-ab6ac92cef97','759f3dcd-2b7e-4386-bc1c-f8b4ffb747b8','2025-11-29 07:57:46',NULL,'UPDATE','COMPLETE','server','4f5e7f8f-1d5e-4499-9a61-c4e57a81bcc8','state changed','OS::Nova::Server',NULL,54),(246,'0064c2a0-5911-40af-9053-a9c2baa1345c','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:57:46',NULL,'CREATE','COMPLETE','sub_port_two','5f25da43-4bb8-458b-83fc-40cafd4ac136','state changed','OS::Neutron::Port',NULL,52),(247,'99f9573b-d509-4be6-8b70-3f68b92a6e94','759f3dcd-2b7e-4386-bc1c-f8b4ffb747b8','2025-11-29 07:57:46',NULL,'UPDATE','COMPLETE','add_network','759f3dcd-2b7e-4386-bc1c-f8b4ffb747b8','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(248,'ce2328b0-3cda-4cc1-9cd1-be4291c03945','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:57:47',NULL,'CREATE','COMPLETE','parent_port','559d69a7-8cfb-4182-a372-ab0d0f626603','state changed','OS::Neutron::Port',NULL,51),(249,'3ad0d968-ee0e-498f-accb-7d7e2c7e73ae','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:57:47',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-1059206779-trunk-66o2xd2xobtp','state changed','OS::Neutron::Trunk',NULL,55),(250,'bb9b09e9-0ee6-43ce-8a6f-d1e7e579532c','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:57:47',NULL,'CREATE','COMPLETE','sub_port_one','1145ac9d-c493-47e2-a564-f27e815f4dac','state changed','OS::Neutron::Port',NULL,53),(251,'a968c215-98ea-49f9-8f97-b3f7e03b8ce9','637188bd-fbaf-43ce-85b0-5455580963f9','2025-11-29 07:57:47',NULL,'DELETE','COMPLETE','server','4ad07a10-ba8e-40b9-9d84-b18b17f7090f','state changed','OS::Nova::Server',NULL,39),(252,'ee139cae-45cf-457a-81cf-a63894226028','637188bd-fbaf-43ce-85b0-5455580963f9','2025-11-29 07:57:47',NULL,'DELETE','IN_PROGRESS','port','63838e32-d696-42a3-9f2c-19aa82c4c46a','state changed','OS::Neutron::Port',NULL,37),(253,'9df9e9d3-78b6-415d-b3e1-1bbe45b8c306','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:57:47',NULL,'CREATE','COMPLETE','trunk','390c6728-e508-4c77-ada8-ebe1c0d3eaa6','state changed','OS::Neutron::Trunk',NULL,55),(254,'ce8203d7-1811-4698-b35d-18c22922481f','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:57:47',NULL,'CREATE','COMPLETE','UpdateTrunkTest-1059206779','3eae79ce-8217-409c-93a9-2829072bca2b','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(255,'5a919ba8-44ae-4fc3-8186-816e0a5910a1','637188bd-fbaf-43ce-85b0-5455580963f9','2025-11-29 07:57:48',NULL,'DELETE','COMPLETE','port','63838e32-d696-42a3-9f2c-19aa82c4c46a','state changed','OS::Neutron::Port',NULL,37),(256,'eb862b2d-1532-460f-807c-02ec6a963f26','637188bd-fbaf-43ce-85b0-5455580963f9','2025-11-29 07:57:48',NULL,'DELETE','IN_PROGRESS','subnet','61e6fe18-18b4-4185-9be0-8fe16c868b7c','state changed','OS::Neutron::Subnet',NULL,36),(257,'ded3f94a-cac7-4824-ae17-6259c1a57796','637188bd-fbaf-43ce-85b0-5455580963f9','2025-11-29 07:57:48',NULL,'DELETE','COMPLETE','subnet','61e6fe18-18b4-4185-9be0-8fe16c868b7c','state changed','OS::Neutron::Subnet',NULL,36),(258,'42be14f4-d0d1-4c52-a5d9-e71dfaf76810','637188bd-fbaf-43ce-85b0-5455580963f9','2025-11-29 07:57:48',NULL,'DELETE','IN_PROGRESS','net','f056f153-badf-4cf8-8989-4d48564077a6','state changed','OS::Neutron::Net',NULL,35),(259,'96f3714b-c14f-4dca-97e8-9777620db6b8','bc8bf960-2086-4056-acbb-e5ce1b3d7216','2025-11-29 07:57:49',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-699709118','bc8bf960-2086-4056-acbb-e5ce1b3d7216','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(260,'9999dda3-930d-43c5-bbcd-8b465edd07e1','bc8bf960-2086-4056-acbb-e5ce1b3d7216','2025-11-29 07:57:49',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-699709118-net-fwos5ootuzkp','state changed','OS::Neutron::Net',NULL,NULL),(261,'a838dada-2235-475c-a08c-7e2347429184','637188bd-fbaf-43ce-85b0-5455580963f9','2025-11-29 07:57:49',NULL,'DELETE','COMPLETE','net','f056f153-badf-4cf8-8989-4d48564077a6','state changed','OS::Neutron::Net',NULL,35),(262,'84ed5503-e66f-4e16-8e0d-c9aa30bf9694','637188bd-fbaf-43ce-85b0-5455580963f9','2025-11-29 07:57:49',NULL,'DELETE','COMPLETE','server_with_port','637188bd-fbaf-43ce-85b0-5455580963f9','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(263,'03a5f71c-d1e3-4011-bc37-0bf4efb821b6','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:57:49',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-1059206779','3eae79ce-8217-409c-93a9-2829072bca2b','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(264,'7908761e-872a-4641-9d94-1ef0e293241b','bc8bf960-2086-4056-acbb-e5ce1b3d7216','2025-11-29 07:57:50',NULL,'CREATE','COMPLETE','net','ff44d876-2ec7-48da-811f-df5c8ee9835b','state changed','OS::Neutron::Net',NULL,NULL),(265,'e2dcfb61-937b-483d-96b3-4abe253bd117','bc8bf960-2086-4056-acbb-e5ce1b3d7216','2025-11-29 07:57:50',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-699709118-subnet-5z2luhm5lo32','state changed','OS::Neutron::Subnet',NULL,56),(266,'e08d5451-e82d-4da1-8ebc-c2569d13fd8d','759f3dcd-2b7e-4386-bc1c-f8b4ffb747b8','2025-11-29 07:57:51',NULL,'DELETE','IN_PROGRESS','add_network','759f3dcd-2b7e-4386-bc1c-f8b4ffb747b8','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(267,'b0d94ddb-b6bc-488c-83aa-078ed87a4dc6','759f3dcd-2b7e-4386-bc1c-f8b4ffb747b8','2025-11-29 07:57:51',NULL,'DELETE','IN_PROGRESS','server','4f5e7f8f-1d5e-4499-9a61-c4e57a81bcc8','state changed','OS::Nova::Server',NULL,54),(268,'fe5520eb-2113-46c0-b263-aeed82976cc9','bc8bf960-2086-4056-acbb-e5ce1b3d7216','2025-11-29 07:57:51',NULL,'CREATE','COMPLETE','subnet','1dbfe15a-7dfb-4716-a721-72fba6bbd145','state changed','OS::Neutron::Subnet',NULL,56),(269,'87e6d4c0-104a-40d5-8489-97c3724dff06','bc8bf960-2086-4056-acbb-e5ce1b3d7216','2025-11-29 07:57:51',NULL,'CREATE','COMPLETE','UpdateSubnetTest-699709118','bc8bf960-2086-4056-acbb-e5ce1b3d7216','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(270,'21fb8bd2-a4e8-423b-a2d6-903ddb03c625','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:57:55',NULL,'UPDATE','IN_PROGRESS','trunk','390c6728-e508-4c77-ada8-ebe1c0d3eaa6','state changed','OS::Neutron::Trunk',NULL,55),(271,'40a3798c-4f7c-4e1f-9161-c446d9231e54','bc8bf960-2086-4056-acbb-e5ce1b3d7216','2025-11-29 07:57:55',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-699709118','bc8bf960-2086-4056-acbb-e5ce1b3d7216','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(272,'8bdd6587-38ef-45be-b4d4-844b8b200812','24bfb6a0-f795-416b-b467-d248aaf825e1','2025-11-29 07:57:55',NULL,'CREATE','IN_PROGRESS','server_with_sub_ip','24bfb6a0-f795-416b-b467-d248aaf825e1','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(273,'4de7fde1-dd8b-4558-8c99-8b5446b20cbf','24bfb6a0-f795-416b-b467-d248aaf825e1','2025-11-29 07:57:55',NULL,'CREATE','IN_PROGRESS','security_group','server_with_sub_ip-security_group-5pbo5dunplxg','state changed','OS::Neutron::SecurityGroup',NULL,59),(274,'7b77ef9e-0565-481d-b173-ac629dfad594','bc8bf960-2086-4056-acbb-e5ce1b3d7216','2025-11-29 07:57:55',NULL,'UPDATE','IN_PROGRESS','subnet','1dbfe15a-7dfb-4716-a721-72fba6bbd145','state changed','OS::Neutron::Subnet',NULL,56),(275,'84e67275-1213-4d37-ad76-bd4b21f18b28','759f3dcd-2b7e-4386-bc1c-f8b4ffb747b8','2025-11-29 07:57:56',NULL,'DELETE','COMPLETE','server','4f5e7f8f-1d5e-4499-9a61-c4e57a81bcc8','state changed','OS::Nova::Server',NULL,54),(276,'60705d88-2d68-4289-8364-24dae7973088','759f3dcd-2b7e-4386-bc1c-f8b4ffb747b8','2025-11-29 07:57:56',NULL,'DELETE','IN_PROGRESS','subnet','3bf3daea-a1df-4654-8e41-0b6ed87c6718','state changed','OS::Neutron::Subnet',NULL,29),(277,'fbf07d8d-6501-4242-a18d-95532648b296','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:57:56',NULL,'UPDATE','COMPLETE','trunk','390c6728-e508-4c77-ada8-ebe1c0d3eaa6','state changed','OS::Neutron::Trunk',NULL,60),(278,'94025171-ae73-4db1-a9e8-1e5061ab4070','bc8bf960-2086-4056-acbb-e5ce1b3d7216','2025-11-29 07:57:56',NULL,'UPDATE','COMPLETE','subnet','1dbfe15a-7dfb-4716-a721-72fba6bbd145','state changed','OS::Neutron::Subnet',NULL,61),(279,'d93257f2-32cb-4b0c-ae8c-eaa1c842b28b','759f3dcd-2b7e-4386-bc1c-f8b4ffb747b8','2025-11-29 07:57:56',NULL,'DELETE','COMPLETE','subnet','3bf3daea-a1df-4654-8e41-0b6ed87c6718','state changed','OS::Neutron::Subnet',NULL,29),(280,'40f05947-b88f-40d8-bfb5-ad9d1494c6ea','24bfb6a0-f795-416b-b467-d248aaf825e1','2025-11-29 07:57:56',NULL,'CREATE','COMPLETE','security_group','b43eef53-858f-4052-ba76-3d1b2dddc01b','state changed','OS::Neutron::SecurityGroup',NULL,59),(281,'da9eb058-4c6c-44dc-895b-dde628abb821','24bfb6a0-f795-416b-b467-d248aaf825e1','2025-11-29 07:57:56',NULL,'CREATE','IN_PROGRESS','net','server_with_sub_ip-net-4canlgje2dll','state changed','OS::Neutron::Net',NULL,62),(282,'bc1df56c-1f16-48a9-809f-e12138d2a69a','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:57:56',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-1059206779','3eae79ce-8217-409c-93a9-2829072bca2b','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(283,'23c976e8-5ec8-45cd-9105-df35860796fa','759f3dcd-2b7e-4386-bc1c-f8b4ffb747b8','2025-11-29 07:57:56',NULL,'DELETE','IN_PROGRESS','net','324fac70-4472-4ec6-9f8d-a12293ae7bcc','state changed','OS::Neutron::Net',NULL,25),(284,'fecb2548-8650-43c6-896e-4525642c845f','bc8bf960-2086-4056-acbb-e5ce1b3d7216','2025-11-29 07:57:56',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-699709118','bc8bf960-2086-4056-acbb-e5ce1b3d7216','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(285,'d42b8979-f83f-48f9-b347-62e70583764a','759f3dcd-2b7e-4386-bc1c-f8b4ffb747b8','2025-11-29 07:57:57',NULL,'DELETE','COMPLETE','net','324fac70-4472-4ec6-9f8d-a12293ae7bcc','state changed','OS::Neutron::Net',NULL,25),(286,'61fac726-c49a-4ed6-af01-2273c95b3f1e','24bfb6a0-f795-416b-b467-d248aaf825e1','2025-11-29 07:57:57',NULL,'CREATE','COMPLETE','net','86014e83-f5c8-453f-9cd3-d991b39b0d07','state changed','OS::Neutron::Net',NULL,62),(287,'68185685-ac46-4cac-b1a8-375a1db56262','759f3dcd-2b7e-4386-bc1c-f8b4ffb747b8','2025-11-29 07:57:57',NULL,'DELETE','COMPLETE','add_network','759f3dcd-2b7e-4386-bc1c-f8b4ffb747b8','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(288,'1b17a1b6-e390-4130-8ee2-085e7f030f39','24bfb6a0-f795-416b-b467-d248aaf825e1','2025-11-29 07:57:57',NULL,'CREATE','IN_PROGRESS','subnet','server_with_sub_ip-subnet-cpxxbfftxfjh','state changed','OS::Neutron::Subnet',NULL,63),(289,'ae30f055-ff6a-4da0-8595-d613bb105e72','24bfb6a0-f795-416b-b467-d248aaf825e1','2025-11-29 07:57:59',NULL,'CREATE','COMPLETE','subnet','dce54c29-0492-4d87-a69e-fa72bd73b07a','state changed','OS::Neutron::Subnet',NULL,63),(290,'de08a94a-cad2-49e8-b75c-aace90a8dd80','24bfb6a0-f795-416b-b467-d248aaf825e1','2025-11-29 07:57:59',NULL,'CREATE','IN_PROGRESS','server','server_with_sub_ip-server-4r2ixpql4rbw','state changed','OS::Nova::Server',NULL,64),(291,'b9a250b9-a78a-4f56-8f76-a5adf47a1f60','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:58:01',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-1059206779','3eae79ce-8217-409c-93a9-2829072bca2b','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(292,'e1bb0db8-6cb4-4fb2-82b5-e342fda66be9','bc8bf960-2086-4056-acbb-e5ce1b3d7216','2025-11-29 07:58:01',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-699709118','bc8bf960-2086-4056-acbb-e5ce1b3d7216','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(293,'fbafb693-aa95-42c1-9fdf-736d68e1010e','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:58:01',NULL,'DELETE','IN_PROGRESS','trunk','390c6728-e508-4c77-ada8-ebe1c0d3eaa6','state changed','OS::Neutron::Trunk',NULL,60),(294,'8856d8b8-9c35-4cd2-9ea4-35787830e96f','bc8bf960-2086-4056-acbb-e5ce1b3d7216','2025-11-29 07:58:01',NULL,'DELETE','IN_PROGRESS','subnet','1dbfe15a-7dfb-4716-a721-72fba6bbd145','state changed','OS::Neutron::Subnet',NULL,61),(295,'0cc83e6d-e5d3-4941-8a41-14af2203e25e','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:58:02',NULL,'DELETE','COMPLETE','trunk','390c6728-e508-4c77-ada8-ebe1c0d3eaa6','state changed','OS::Neutron::Trunk',NULL,60),(296,'803ca862-01a9-4e04-8be4-4d39e734f4de','093e7bb9-cb29-4329-af06-564e90895aaf','2025-11-29 07:58:02',NULL,'CREATE','IN_PROGRESS','same_fixed_ip','093e7bb9-cb29-4329-af06-564e90895aaf','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(297,'cb334656-dd91-458f-9394-dad4f6c3cb83','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:58:02',NULL,'DELETE','IN_PROGRESS','sub_port_one','1145ac9d-c493-47e2-a564-f27e815f4dac','state changed','OS::Neutron::Port',NULL,53),(298,'f8fc32dd-72bf-4588-bc2a-7105664e27f3','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:58:02',NULL,'DELETE','IN_PROGRESS','parent_port','559d69a7-8cfb-4182-a372-ab0d0f626603','state changed','OS::Neutron::Port',NULL,51),(299,'b942c233-7161-4df7-858d-0e4170123859','093e7bb9-cb29-4329-af06-564e90895aaf','2025-11-29 07:58:02',NULL,'CREATE','IN_PROGRESS','net','same_fixed_ip-net-enbebmhh5prn','state changed','OS::Neutron::Net',NULL,67),(300,'a9c06b67-a61d-4161-b399-5aa980fab0b6','bc8bf960-2086-4056-acbb-e5ce1b3d7216','2025-11-29 07:58:02',NULL,'DELETE','COMPLETE','subnet','1dbfe15a-7dfb-4716-a721-72fba6bbd145','state changed','OS::Neutron::Subnet',NULL,61),(301,'cd2d1839-eec2-45c7-a1ab-15b5022d4eaa','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:58:02',NULL,'DELETE','IN_PROGRESS','sub_port_two','5f25da43-4bb8-458b-83fc-40cafd4ac136','state changed','OS::Neutron::Port',NULL,52),(302,'506f91c7-12fd-4d29-8b53-4a9a5360acc2','bc8bf960-2086-4056-acbb-e5ce1b3d7216','2025-11-29 07:58:02',NULL,'DELETE','IN_PROGRESS','net','ff44d876-2ec7-48da-811f-df5c8ee9835b','state changed','OS::Neutron::Net',NULL,NULL),(303,'9d3d53f3-b8c9-4796-bf57-d148584478b0','093e7bb9-cb29-4329-af06-564e90895aaf','2025-11-29 07:58:03',NULL,'CREATE','COMPLETE','net','e8a31be0-97a2-4c4a-8bdc-e33e47d0a99d','state changed','OS::Neutron::Net',NULL,67),(304,'e1677db1-bcd2-4c64-9c1a-83cd921540c1','093e7bb9-cb29-4329-af06-564e90895aaf','2025-11-29 07:58:03',NULL,'CREATE','IN_PROGRESS','subnet','same_fixed_ip-subnet-hotuqzpi5hlo','state changed','OS::Neutron::Subnet',NULL,68),(305,'7a75f7ef-b12b-4f49-a2b9-2cd0686de64b','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:58:03',NULL,'DELETE','COMPLETE','parent_port','559d69a7-8cfb-4182-a372-ab0d0f626603','state changed','OS::Neutron::Port',NULL,51),(306,'a130d23e-4d8e-437e-a823-51dada56b575','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:58:03',NULL,'DELETE','COMPLETE','sub_port_one','1145ac9d-c493-47e2-a564-f27e815f4dac','state changed','OS::Neutron::Port',NULL,53),(307,'60bc7403-d0cd-4f89-8b0a-6680b09db04c','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:58:03',NULL,'DELETE','IN_PROGRESS','parent_subnet','0bfd7345-20e5-4707-b903-d6c03a1e95e8','state changed','OS::Neutron::Subnet',NULL,48),(308,'40ff32dd-89cb-4380-9f08-268391759102','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:58:04',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','9de88ff9-0a5a-49f6-ac67-f010b0b3b176','state changed','OS::Neutron::Subnet',NULL,50),(309,'c86d3847-7db2-4ed9-a2dd-f2fe53c91982','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:58:04',NULL,'DELETE','COMPLETE','sub_port_two','5f25da43-4bb8-458b-83fc-40cafd4ac136','state changed','OS::Neutron::Port',NULL,52),(310,'204f2dfe-4a51-41dc-89d6-89937026e359','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:58:04',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','6d7eb289-8dfe-4c61-a153-424b428a18c9','state changed','OS::Neutron::Subnet',NULL,49),(311,'bddaa5a5-4518-4c48-b059-d4a67f0acf9f','bc8bf960-2086-4056-acbb-e5ce1b3d7216','2025-11-29 07:58:04',NULL,'DELETE','COMPLETE','net','ff44d876-2ec7-48da-811f-df5c8ee9835b','state changed','OS::Neutron::Net',NULL,NULL),(312,'da050a6e-d6fc-44ad-81bd-f70d85bf24c1','bc8bf960-2086-4056-acbb-e5ce1b3d7216','2025-11-29 07:58:04',NULL,'DELETE','COMPLETE','UpdateSubnetTest-699709118','bc8bf960-2086-4056-acbb-e5ce1b3d7216','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(313,'09fd9e12-38f1-4262-acbc-9e192149a9aa','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:58:05',NULL,'DELETE','COMPLETE','parent_subnet','0bfd7345-20e5-4707-b903-d6c03a1e95e8','state changed','OS::Neutron::Subnet',NULL,48),(314,'c4ed48d0-dcdb-4e40-9cda-9f1696d141da','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:58:05',NULL,'DELETE','COMPLETE','trunk_subnet_one','9de88ff9-0a5a-49f6-ac67-f010b0b3b176','state changed','OS::Neutron::Subnet',NULL,50),(315,'d76fd02b-c560-404a-a901-4aedc12fa3db','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:58:05',NULL,'DELETE','IN_PROGRESS','trunk_net_one','eed5566b-6330-4837-9ce5-adee7ae4efc3','state changed','OS::Neutron::Net',NULL,NULL),(316,'df8e818f-413c-476e-a797-1a6207553546','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:58:05',NULL,'DELETE','IN_PROGRESS','parent_net','ede51b05-7227-4f2b-980a-7d9e32ec23a5','state changed','OS::Neutron::Net',NULL,NULL),(317,'ff8cf294-99d1-43e6-a799-9d0a5773ec49','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:58:05',NULL,'DELETE','COMPLETE','trunk_subnet_two','6d7eb289-8dfe-4c61-a153-424b428a18c9','state changed','OS::Neutron::Subnet',NULL,49),(318,'0e29467b-149a-4273-b513-3bbc6f32e641','093e7bb9-cb29-4329-af06-564e90895aaf','2025-11-29 07:58:05',NULL,'CREATE','COMPLETE','subnet','2828e4f2-ddb1-42c9-9b1f-ca7b97ee2d37','state changed','OS::Neutron::Subnet',NULL,68),(319,'1185df09-7a79-4001-88d6-529544fdd97e','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:58:05',NULL,'DELETE','IN_PROGRESS','trunk_net_two','eb3501aa-2d73-47a3-a775-5715787dcea0','state changed','OS::Neutron::Net',NULL,NULL),(320,'6d3027de-caf5-4a85-89f2-e65dfc78e5ff','093e7bb9-cb29-4329-af06-564e90895aaf','2025-11-29 07:58:06',NULL,'CREATE','IN_PROGRESS','server','same_fixed_ip-server-nht2a57liipi','state changed','OS::Nova::Server',NULL,69),(321,'b35eeec5-3799-4458-8409-cb529a128ea7','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:58:06',NULL,'DELETE','COMPLETE','trunk_net_two','eb3501aa-2d73-47a3-a775-5715787dcea0','state changed','OS::Neutron::Net',NULL,NULL),(322,'6bb3ed66-ba04-4f62-bfbe-7243b8199e53','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:58:06',NULL,'DELETE','COMPLETE','parent_net','ede51b05-7227-4f2b-980a-7d9e32ec23a5','state changed','OS::Neutron::Net',NULL,NULL),(323,'80f086bf-9c86-422a-9652-1c1d727b7e99','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:58:06',NULL,'DELETE','COMPLETE','trunk_net_one','eed5566b-6330-4837-9ce5-adee7ae4efc3','state changed','OS::Neutron::Net',NULL,NULL),(324,'10bd1e94-2469-4c4f-a04b-79673c7e259b','3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:58:06',NULL,'DELETE','COMPLETE','UpdateTrunkTest-1059206779','3eae79ce-8217-409c-93a9-2829072bca2b','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(325,'a0e6ec98-6c57-4309-b998-40b392df7cf0','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:58:13',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-1311242840','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(326,'21bad319-20a4-4be6-a7ff-ab4301778da1','62a8831d-5a95-48ae-ac01-bcd22bc3e72d','2025-11-29 07:58:14',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-363745674','62a8831d-5a95-48ae-ac01-bcd22bc3e72d','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(327,'7b65e594-ab7a-49eb-93a1-38004f77eab9','62a8831d-5a95-48ae-ac01-bcd22bc3e72d','2025-11-29 07:58:15',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-363745674-net-autmtxlpcyue','state changed','OS::Neutron::Net',NULL,NULL),(328,'9bfff36c-3005-420b-b8e5-ebdeeec3edb9','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:58:22',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-1311242840-parent_net-aza5aenak5ga','state changed','OS::Neutron::Net',NULL,NULL),(329,'3878cc0f-d231-4e8d-b350-050e7907f98a','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:58:23',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-1311242840-trunk_net_one-5z5cm6rbrx3v','state changed','OS::Neutron::Net',NULL,NULL),(330,'d5d3c3da-35ab-45ce-8c54-0e2e670aea30','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:58:27',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-1311242840-trunk_net_two-ast673wxgpny','state changed','OS::Neutron::Net',NULL,NULL),(331,'ed3fab30-3ff7-404b-8009-f775baeaf8fd','62a8831d-5a95-48ae-ac01-bcd22bc3e72d','2025-11-29 07:58:30',NULL,'CREATE','COMPLETE','net','b524b8a2-247a-413d-abfd-e8b9c8a09e08','state changed','OS::Neutron::Net',NULL,NULL),(332,'0484cf0e-52d6-483c-9d38-c93f67b521ac','62a8831d-5a95-48ae-ac01-bcd22bc3e72d','2025-11-29 07:58:30',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-363745674-subnet-jkvxwv6ryzkw','state changed','OS::Neutron::Subnet',NULL,70),(333,'b909391a-6556-4c8a-a3ca-be8abe658899','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:58:31',NULL,'CREATE','COMPLETE','trunk_net_one','ae969a25-dfed-469d-a39e-b02fda585390','state changed','OS::Neutron::Net',NULL,NULL),(334,'280a3563-bcde-4e84-aa2d-a6a2d0c50f92','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:58:31',NULL,'CREATE','COMPLETE','trunk_net_two','95973035-ddf5-44f9-bfc1-4a513fef4d85','state changed','OS::Neutron::Net',NULL,NULL),(335,'fdf13328-d8c3-4f03-bcdd-0cdc91e0f510','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:58:31',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-1311242840-trunk_subnet_one-hxu2rm46adrl','state changed','OS::Neutron::Subnet',NULL,71),(336,'f7116a1f-64fe-4647-9764-2a51c1299fd7','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:58:31',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-1311242840-trunk_subnet_two-u4orvooqtgmw','state changed','OS::Neutron::Subnet',NULL,72),(337,'1970968f-b2c8-4ad9-8ecc-ab99dbc5dff1','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:58:31',NULL,'CREATE','COMPLETE','parent_net','eee24d61-33f6-4879-8595-d20872aa9056','state changed','OS::Neutron::Net',NULL,NULL),(338,'cb6930c8-e077-4cda-9e47-9f2567e02245','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:58:31',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-1311242840-parent_subnet-b4otnqia7tx4','state changed','OS::Neutron::Subnet',NULL,73),(339,'f29b01e4-05ca-4c4e-a0ab-5c5db8e99426','24bfb6a0-f795-416b-b467-d248aaf825e1','2025-11-29 07:58:33',NULL,'CREATE','COMPLETE','server','aebf406f-fa1b-4f6e-b33a-45edd052bd16','state changed','OS::Nova::Server',NULL,64),(340,'ed40d156-ff60-4238-8d2c-cf6e06faec95','24bfb6a0-f795-416b-b467-d248aaf825e1','2025-11-29 07:58:33',NULL,'CREATE','COMPLETE','server_with_sub_ip','24bfb6a0-f795-416b-b467-d248aaf825e1','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(341,'9e83d3cd-18e5-4cb4-9abe-a30f17ab4850','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:58:34',NULL,'CREATE','COMPLETE','trunk_subnet_two','f65e5e40-b369-4193-b4d4-2c083e9f5717','state changed','OS::Neutron::Subnet',NULL,72),(342,'05040aef-fe24-490f-b881-91707cf38d78','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:58:34',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-1311242840-sub_port_two-s7mupdmy7usv','state changed','OS::Neutron::Port',NULL,74),(343,'d88e7027-ac9a-4ee0-b97e-6bc6237f55ad','62a8831d-5a95-48ae-ac01-bcd22bc3e72d','2025-11-29 07:58:35',NULL,'CREATE','COMPLETE','subnet','f82fd8f6-595a-473d-b198-d10e3759f439','state changed','OS::Neutron::Subnet',NULL,70),(344,'234ff918-8da3-46ee-856c-a86ee0ace2e4','62a8831d-5a95-48ae-ac01-bcd22bc3e72d','2025-11-29 07:58:35',NULL,'CREATE','COMPLETE','UpdateSubnetTest-363745674','62a8831d-5a95-48ae-ac01-bcd22bc3e72d','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(345,'897cebe3-c4ee-4948-8f52-135f947eaf0f','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:58:35',NULL,'CREATE','COMPLETE','trunk_subnet_one','ee24b7ba-e128-402b-82ca-9dd8bc47538c','state changed','OS::Neutron::Subnet',NULL,71),(346,'7880888e-bdea-476b-878e-fdf5ca71634b','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:58:36',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-1311242840-sub_port_one-odiz6kxbvgqi','state changed','OS::Neutron::Port',NULL,75),(347,'5923c07b-d231-44ae-b377-aa12f7f0d17c','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:58:36',NULL,'CREATE','COMPLETE','parent_subnet','017faf18-0147-4677-b7ca-c545b8615366','state changed','OS::Neutron::Subnet',NULL,73),(348,'e3905654-d44e-4410-8388-fcf0eff089d4','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:58:36',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-1311242840-parent_port-v266ygeeef6f','state changed','OS::Neutron::Port',NULL,76),(349,'605c5816-79fb-479b-9c90-16223ee412e0','093e7bb9-cb29-4329-af06-564e90895aaf','2025-11-29 07:58:37',NULL,'CREATE','COMPLETE','server','51d462df-3419-4058-a576-050d659d5eec','state changed','OS::Nova::Server',NULL,69),(350,'8f653a3b-8293-4f59-8bc4-eb5be67294dc','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:58:37',NULL,'CREATE','COMPLETE','sub_port_two','fc315947-36df-4e03-8f57-d9a21c38055f','state changed','OS::Neutron::Port',NULL,74),(351,'3647b371-969a-4847-8171-ec724bea5d59','093e7bb9-cb29-4329-af06-564e90895aaf','2025-11-29 07:58:37',NULL,'CREATE','COMPLETE','same_fixed_ip','093e7bb9-cb29-4329-af06-564e90895aaf','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(352,'e5cc2c54-0c16-48d3-ac54-339f2aadefce','62a8831d-5a95-48ae-ac01-bcd22bc3e72d','2025-11-29 07:58:38',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-363745674','62a8831d-5a95-48ae-ac01-bcd22bc3e72d','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(353,'35a5132c-647d-4ee4-8c8c-31ab761dd655','62a8831d-5a95-48ae-ac01-bcd22bc3e72d','2025-11-29 07:58:39',NULL,'UPDATE','IN_PROGRESS','subnet','f82fd8f6-595a-473d-b198-d10e3759f439','state changed','OS::Neutron::Subnet',NULL,70),(354,'58ec72b3-b83e-42cb-89a8-68fc71971697','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:58:39',NULL,'CREATE','COMPLETE','parent_port','398178a7-a033-4213-933a-7b4dfd33e12f','state changed','OS::Neutron::Port',NULL,76),(355,'869e3cb4-4192-4e34-a98a-851ef4aaa788','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:58:39',NULL,'CREATE','COMPLETE','sub_port_one','5c4b0e1d-0c14-46ae-985b-67b797475186','state changed','OS::Neutron::Port',NULL,75),(356,'87549db5-bfcd-4df4-9571-58c53c250e4d','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:58:39',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-1311242840-trunk-yawhumzijcam','state changed','OS::Neutron::Trunk',NULL,79),(357,'486bc6e0-e173-48ab-ab42-25d3fe4e8127','62a8831d-5a95-48ae-ac01-bcd22bc3e72d','2025-11-29 07:58:40',NULL,'UPDATE','COMPLETE','subnet','f82fd8f6-595a-473d-b198-d10e3759f439','state changed','OS::Neutron::Subnet',NULL,80),(358,'08fec1ff-2ecc-43e8-a0bc-aa16fbece04a','62a8831d-5a95-48ae-ac01-bcd22bc3e72d','2025-11-29 07:58:40',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-363745674','62a8831d-5a95-48ae-ac01-bcd22bc3e72d','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(359,'e7bfc07d-cc4a-4f03-a8bc-e8aa1970d369','24bfb6a0-f795-416b-b467-d248aaf825e1','2025-11-29 07:58:40',NULL,'DELETE','IN_PROGRESS','server_with_sub_ip','24bfb6a0-f795-416b-b467-d248aaf825e1','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(360,'13e87357-3557-47d4-a61a-e74f8ff6858e','24bfb6a0-f795-416b-b467-d248aaf825e1','2025-11-29 07:58:41',NULL,'DELETE','IN_PROGRESS','server','aebf406f-fa1b-4f6e-b33a-45edd052bd16','state changed','OS::Nova::Server',NULL,64),(361,'b53aa029-ee15-4559-b7bc-cdaa8a9d68a0','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:58:41',NULL,'CREATE','COMPLETE','trunk','0a90b687-8f99-4137-8b84-031f9216628a','state changed','OS::Neutron::Trunk',NULL,79),(362,'a26f246c-baf6-4b86-a965-d928fdfbcccb','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:58:41',NULL,'CREATE','COMPLETE','UpdateTrunkTest-1311242840','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(363,'460b3756-5b59-4a63-8610-19edd4839e9f','62a8831d-5a95-48ae-ac01-bcd22bc3e72d','2025-11-29 07:58:44',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-363745674','62a8831d-5a95-48ae-ac01-bcd22bc3e72d','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(364,'73b6dee5-0722-42c4-a205-f309f616d7c8','093e7bb9-cb29-4329-af06-564e90895aaf','2025-11-29 07:58:44',NULL,'UPDATE','IN_PROGRESS','same_fixed_ip','093e7bb9-cb29-4329-af06-564e90895aaf','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(365,'93b564c6-e682-4766-9274-87139cafc351','62a8831d-5a95-48ae-ac01-bcd22bc3e72d','2025-11-29 07:58:44',NULL,'DELETE','IN_PROGRESS','subnet','f82fd8f6-595a-473d-b198-d10e3759f439','state changed','OS::Neutron::Subnet',NULL,80),(366,'e52b73a4-c6fa-4757-821b-3b3ce969b817','62a8831d-5a95-48ae-ac01-bcd22bc3e72d','2025-11-29 07:58:44',NULL,'DELETE','COMPLETE','subnet','f82fd8f6-595a-473d-b198-d10e3759f439','state changed','OS::Neutron::Subnet',NULL,80),(367,'af30117c-ef96-46e2-ab66-601b39260813','24bfb6a0-f795-416b-b467-d248aaf825e1','2025-11-29 07:58:45',NULL,'DELETE','COMPLETE','server','aebf406f-fa1b-4f6e-b33a-45edd052bd16','state changed','OS::Nova::Server',NULL,64),(368,'90087b76-0d08-42ae-94f2-9a909443aca7','62a8831d-5a95-48ae-ac01-bcd22bc3e72d','2025-11-29 07:58:45',NULL,'DELETE','IN_PROGRESS','net','b524b8a2-247a-413d-abfd-e8b9c8a09e08','state changed','OS::Neutron::Net',NULL,NULL),(369,'3e4f4c81-7862-475a-8347-64037aec9081','093e7bb9-cb29-4329-af06-564e90895aaf','2025-11-29 07:58:46',NULL,'UPDATE','IN_PROGRESS','server','51d462df-3419-4058-a576-050d659d5eec','state changed','OS::Nova::Server',NULL,69),(370,'110852d1-ae3e-486a-aa15-0d58e13fb7ee','24bfb6a0-f795-416b-b467-d248aaf825e1','2025-11-29 07:58:46',NULL,'DELETE','IN_PROGRESS','subnet','dce54c29-0492-4d87-a69e-fa72bd73b07a','state changed','OS::Neutron::Subnet',NULL,63),(371,'944520ae-d692-40ab-935e-dfa7f49395eb','24bfb6a0-f795-416b-b467-d248aaf825e1','2025-11-29 07:58:46',NULL,'DELETE','IN_PROGRESS','security_group','b43eef53-858f-4052-ba76-3d1b2dddc01b','state changed','OS::Neutron::SecurityGroup',NULL,59),(372,'368d46ee-81ab-44cc-9d7a-2da633e01e1d','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:58:46',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-1311242840','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(373,'7d60005c-dcd8-4373-815f-90d18dc6f153','24bfb6a0-f795-416b-b467-d248aaf825e1','2025-11-29 07:58:47',NULL,'DELETE','COMPLETE','subnet','dce54c29-0492-4d87-a69e-fa72bd73b07a','state changed','OS::Neutron::Subnet',NULL,63),(374,'617a171c-073b-46fd-a5cf-2ccfe562aaf6','24bfb6a0-f795-416b-b467-d248aaf825e1','2025-11-29 07:58:47',NULL,'DELETE','IN_PROGRESS','net','86014e83-f5c8-453f-9cd3-d991b39b0d07','state changed','OS::Neutron::Net',NULL,62),(375,'f2a0bdc4-9f5b-47bb-9423-865f5eca3857','62a8831d-5a95-48ae-ac01-bcd22bc3e72d','2025-11-29 07:58:48',NULL,'DELETE','COMPLETE','net','b524b8a2-247a-413d-abfd-e8b9c8a09e08','state changed','OS::Neutron::Net',NULL,NULL),(376,'937aec34-f7ae-42d9-82d0-e1bfa3965b39','62a8831d-5a95-48ae-ac01-bcd22bc3e72d','2025-11-29 07:58:48',NULL,'DELETE','COMPLETE','UpdateSubnetTest-363745674','62a8831d-5a95-48ae-ac01-bcd22bc3e72d','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(377,'fe0c6fc4-32d7-4634-99f8-a910748dce47','24bfb6a0-f795-416b-b467-d248aaf825e1','2025-11-29 07:58:49',NULL,'DELETE','COMPLETE','net','86014e83-f5c8-453f-9cd3-d991b39b0d07','state changed','OS::Neutron::Net',NULL,62),(378,'ef20d6aa-c02e-434a-b73f-93dd122cebd8','24bfb6a0-f795-416b-b467-d248aaf825e1','2025-11-29 07:58:50',NULL,'DELETE','COMPLETE','security_group','b43eef53-858f-4052-ba76-3d1b2dddc01b','state changed','OS::Neutron::SecurityGroup',NULL,59),(379,'9023e8a2-d968-4156-9aa5-41f4749dec91','24bfb6a0-f795-416b-b467-d248aaf825e1','2025-11-29 07:58:50',NULL,'DELETE','COMPLETE','server_with_sub_ip','24bfb6a0-f795-416b-b467-d248aaf825e1','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(380,'e56deea9-4048-4bf7-bfed-6120c030343a','093e7bb9-cb29-4329-af06-564e90895aaf','2025-11-29 07:58:50',NULL,'UPDATE','COMPLETE','server','51d462df-3419-4058-a576-050d659d5eec','state changed','OS::Nova::Server',NULL,83),(381,'0c216cd2-ffa2-41dc-9123-4c15f3b328af','093e7bb9-cb29-4329-af06-564e90895aaf','2025-11-29 07:58:51',NULL,'UPDATE','COMPLETE','same_fixed_ip','093e7bb9-cb29-4329-af06-564e90895aaf','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(382,'1c381e9e-1299-423a-9aa5-92b8159d5080','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:58:52',NULL,'UPDATE','IN_PROGRESS','trunk','0a90b687-8f99-4137-8b84-031f9216628a','state changed','OS::Neutron::Trunk',NULL,79),(383,'3eb9e62a-71c0-42c1-b1a9-243bf843cbf5','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:58:54',NULL,'UPDATE','COMPLETE','trunk','0a90b687-8f99-4137-8b84-031f9216628a','state changed','OS::Neutron::Trunk',NULL,84),(384,'b8cc5d38-124e-46b2-b928-31d6f7fe7da7','1720f7a8-089a-4ce2-923f-a30c23acee53','2025-11-29 07:58:55',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-35781114','1720f7a8-089a-4ce2-923f-a30c23acee53','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(385,'0af742f7-4907-44cb-b306-214b666ceb45','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:58:55',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-1311242840','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(386,'43ac4f73-b73e-4f1e-8a8b-db44a66a2bee','1720f7a8-089a-4ce2-923f-a30c23acee53','2025-11-29 07:58:55',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-35781114-net-lih2l6ql2brg','state changed','OS::Neutron::Net',NULL,NULL),(387,'0189f5e2-716f-49d2-968d-3e82fbfc841a','093e7bb9-cb29-4329-af06-564e90895aaf','2025-11-29 07:58:55',NULL,'DELETE','IN_PROGRESS','same_fixed_ip','093e7bb9-cb29-4329-af06-564e90895aaf','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(388,'1490ac29-32d7-44aa-b2df-59715bb0155e','093e7bb9-cb29-4329-af06-564e90895aaf','2025-11-29 07:58:56',NULL,'DELETE','IN_PROGRESS','server','51d462df-3419-4058-a576-050d659d5eec','state changed','OS::Nova::Server',NULL,83),(389,'187a8ed7-29e7-4605-833d-418c9a6d4a3b','cd5db660-aa61-4e2d-8500-abc0b35f16e9','2025-11-29 07:58:57',NULL,'CREATE','IN_PROGRESS','create_server_with_sub_ip','cd5db660-aa61-4e2d-8500-abc0b35f16e9','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(390,'2fe31318-82ae-49ac-a4e9-8c60cf2e000d','1720f7a8-089a-4ce2-923f-a30c23acee53','2025-11-29 07:58:58',NULL,'CREATE','COMPLETE','net','0dd42ac1-019b-48ae-b76c-6e1fb166388b','state changed','OS::Neutron::Net',NULL,NULL),(391,'bfc56854-db91-4e1b-819b-e1c38bf872c5','1720f7a8-089a-4ce2-923f-a30c23acee53','2025-11-29 07:58:59',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-35781114-subnet-kg75adzzmo4c','state changed','OS::Neutron::Subnet',NULL,86),(392,'193206a2-76e1-421c-a158-cb7e3c42140a','cd5db660-aa61-4e2d-8500-abc0b35f16e9','2025-11-29 07:58:59',NULL,'CREATE','IN_PROGRESS','net','create_server_with_sub_ip-net-7deeyhx3jx4n','state changed','OS::Neutron::Net',NULL,87),(393,'ca127d91-782a-4bb9-8a15-6fd527bd7a60','cd5db660-aa61-4e2d-8500-abc0b35f16e9','2025-11-29 07:59:00',NULL,'CREATE','COMPLETE','net','eecd6003-fac5-419b-9548-542726bd10fc','state changed','OS::Neutron::Net',NULL,87),(394,'50f2e021-81ca-406f-b4b3-61afeae3819f','cd5db660-aa61-4e2d-8500-abc0b35f16e9','2025-11-29 07:59:00',NULL,'CREATE','IN_PROGRESS','subnet_b','create_server_with_sub_ip-subnet_b-cpechqnbfhh3','state changed','OS::Neutron::Subnet',NULL,89),(395,'2beba82b-46b9-4598-8ec8-31831dba8dda','093e7bb9-cb29-4329-af06-564e90895aaf','2025-11-29 07:59:00',NULL,'DELETE','COMPLETE','server','51d462df-3419-4058-a576-050d659d5eec','state changed','OS::Nova::Server',NULL,83),(396,'2c43e643-04ee-45b3-8ab0-e9ef1e2840c8','cd5db660-aa61-4e2d-8500-abc0b35f16e9','2025-11-29 07:59:00',NULL,'CREATE','IN_PROGRESS','subnet_a','create_server_with_sub_ip-subnet_a-ynp4xaacbitb','state changed','OS::Neutron::Subnet',NULL,90),(397,'4feaca1e-80f5-4c08-b80c-4c579354e6a2','093e7bb9-cb29-4329-af06-564e90895aaf','2025-11-29 07:59:00',NULL,'DELETE','IN_PROGRESS','subnet','2828e4f2-ddb1-42c9-9b1f-ca7b97ee2d37','state changed','OS::Neutron::Subnet',NULL,68),(398,'9d2b6b5d-c354-425e-bc2e-25cb32e4e6ca','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:59:01',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-1311242840','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(399,'7431b1df-1d3e-47ba-97fc-01570b494623','1720f7a8-089a-4ce2-923f-a30c23acee53','2025-11-29 07:59:01',NULL,'CREATE','COMPLETE','subnet','5919fc11-971d-4001-8b2f-3ff7631ca669','state changed','OS::Neutron::Subnet',NULL,86),(400,'39e5041a-8926-46c3-93b9-71b049be8c89','1720f7a8-089a-4ce2-923f-a30c23acee53','2025-11-29 07:59:01',NULL,'CREATE','COMPLETE','UpdateSubnetTest-35781114','1720f7a8-089a-4ce2-923f-a30c23acee53','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(401,'05c07d15-7fd6-44f5-8fd0-4f1a5c8d7f1b','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:59:01',NULL,'DELETE','IN_PROGRESS','sub_port_two','fc315947-36df-4e03-8f57-d9a21c38055f','state changed','OS::Neutron::Port',NULL,74),(402,'a3f6a92c-5d62-47fb-8312-80b5483c3cc3','093e7bb9-cb29-4329-af06-564e90895aaf','2025-11-29 07:59:01',NULL,'DELETE','COMPLETE','subnet','2828e4f2-ddb1-42c9-9b1f-ca7b97ee2d37','state changed','OS::Neutron::Subnet',NULL,68),(403,'aabcc287-84b7-4520-a85a-38351214c6cb','093e7bb9-cb29-4329-af06-564e90895aaf','2025-11-29 07:59:01',NULL,'DELETE','IN_PROGRESS','net','e8a31be0-97a2-4c4a-8bdc-e33e47d0a99d','state changed','OS::Neutron::Net',NULL,67),(404,'ca0cdeb3-330f-4b52-bb8a-c335f64c831f','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:59:02',NULL,'DELETE','COMPLETE','sub_port_two','fc315947-36df-4e03-8f57-d9a21c38055f','state changed','OS::Neutron::Port',NULL,74),(405,'a1c60ccb-5a7c-4b6c-95ea-f5504f34ebf6','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:59:02',NULL,'DELETE','IN_PROGRESS','sub_port_one','5c4b0e1d-0c14-46ae-985b-67b797475186','state changed','OS::Neutron::Port',NULL,75),(406,'c25a7717-a010-47af-b748-062c7dccc21f','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:59:02',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','f65e5e40-b369-4193-b4d4-2c083e9f5717','state changed','OS::Neutron::Subnet',NULL,72),(407,'25467a83-a640-45b6-891f-2d21f0cb58bf','cd5db660-aa61-4e2d-8500-abc0b35f16e9','2025-11-29 07:59:02',NULL,'CREATE','COMPLETE','subnet_a','6c3098e2-293f-43d0-b6a9-894ddb73c36c','state changed','OS::Neutron::Subnet',NULL,90),(408,'1051ba1e-159e-4f57-a70e-7f0243114533','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:59:03',NULL,'DELETE','COMPLETE','trunk_subnet_two','f65e5e40-b369-4193-b4d4-2c083e9f5717','state changed','OS::Neutron::Subnet',NULL,72),(409,'4ccf7890-243d-4350-9dce-ca7d664c9061','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:59:03',NULL,'DELETE','IN_PROGRESS','trunk_net_two','95973035-ddf5-44f9-bfc1-4a513fef4d85','state changed','OS::Neutron::Net',NULL,NULL),(410,'ea1a58a5-9311-4696-9cac-587dac55fa9d','093e7bb9-cb29-4329-af06-564e90895aaf','2025-11-29 07:59:03',NULL,'DELETE','COMPLETE','net','e8a31be0-97a2-4c4a-8bdc-e33e47d0a99d','state changed','OS::Neutron::Net',NULL,67),(411,'0587feda-12f7-4177-af93-a955acc7ff39','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:59:03',NULL,'DELETE','IN_PROGRESS','trunk','0a90b687-8f99-4137-8b84-031f9216628a','state changed','OS::Neutron::Trunk',NULL,84),(412,'1aa43827-2ea4-4687-8c09-75a75b51e472','093e7bb9-cb29-4329-af06-564e90895aaf','2025-11-29 07:59:03',NULL,'DELETE','COMPLETE','same_fixed_ip','093e7bb9-cb29-4329-af06-564e90895aaf','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(413,'91776d55-e7c2-41b2-8bb8-f3df655d6a7b','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:59:04',NULL,'DELETE','COMPLETE','trunk','0a90b687-8f99-4137-8b84-031f9216628a','state changed','OS::Neutron::Trunk',NULL,84),(414,'b6944280-92e0-4953-89ad-1b00e5ed461b','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:59:04',NULL,'DELETE','COMPLETE','sub_port_one','5c4b0e1d-0c14-46ae-985b-67b797475186','state changed','OS::Neutron::Port',NULL,75),(415,'e1294d06-4897-404c-b919-3e81c0da6d63','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:59:04',NULL,'DELETE','IN_PROGRESS','parent_port','398178a7-a033-4213-933a-7b4dfd33e12f','state changed','OS::Neutron::Port',NULL,76),(416,'c50525b5-7e6a-43e8-9c04-fc38fdc1f2d8','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:59:04',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','ee24b7ba-e128-402b-82ca-9dd8bc47538c','state changed','OS::Neutron::Subnet',NULL,71),(417,'9eeb0286-a6f7-46ff-b156-dda0d57577dd','cd5db660-aa61-4e2d-8500-abc0b35f16e9','2025-11-29 07:59:04',NULL,'CREATE','COMPLETE','subnet_b','164779e4-2bcb-4ec5-80a4-57a749b90764','state changed','OS::Neutron::Subnet',NULL,89),(418,'f20892b3-1fad-4a74-969f-44cc23de4c2c','cd5db660-aa61-4e2d-8500-abc0b35f16e9','2025-11-29 07:59:04',NULL,'CREATE','IN_PROGRESS','server','create_server_with_sub_ip-server-4woabc42fjsl','state changed','OS::Nova::Server',NULL,91),(419,'224b69d5-61f6-439c-88b7-d7b9f29b7913','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:59:04',NULL,'DELETE','COMPLETE','trunk_net_two','95973035-ddf5-44f9-bfc1-4a513fef4d85','state changed','OS::Neutron::Net',NULL,NULL),(420,'e6422165-37c4-45c2-93bb-4a372a6d3129','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:59:04',NULL,'DELETE','COMPLETE','parent_port','398178a7-a033-4213-933a-7b4dfd33e12f','state changed','OS::Neutron::Port',NULL,76),(421,'455276ae-880d-4636-b5ba-82d32c4aa571','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:59:04',NULL,'DELETE','COMPLETE','trunk_subnet_one','ee24b7ba-e128-402b-82ca-9dd8bc47538c','state changed','OS::Neutron::Subnet',NULL,71),(422,'d6828907-ffe7-4b5a-9b1b-493b8113a679','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:59:04',NULL,'DELETE','IN_PROGRESS','trunk_net_one','ae969a25-dfed-469d-a39e-b02fda585390','state changed','OS::Neutron::Net',NULL,NULL),(423,'3ec92e81-0a46-4853-b8ca-d5113b4f5701','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:59:04',NULL,'DELETE','IN_PROGRESS','parent_subnet','017faf18-0147-4677-b7ca-c545b8615366','state changed','OS::Neutron::Subnet',NULL,73),(424,'52546ec9-88bd-4990-ab5a-91df87b26499','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:59:05',NULL,'DELETE','COMPLETE','parent_subnet','017faf18-0147-4677-b7ca-c545b8615366','state changed','OS::Neutron::Subnet',NULL,73),(425,'acb40772-4bc5-468f-8664-86268a4210f5','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:59:05',NULL,'DELETE','IN_PROGRESS','parent_net','eee24d61-33f6-4879-8595-d20872aa9056','state changed','OS::Neutron::Net',NULL,NULL),(426,'52a51533-5af8-410a-adb1-474b9fa01b5f','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:59:05',NULL,'DELETE','COMPLETE','trunk_net_one','ae969a25-dfed-469d-a39e-b02fda585390','state changed','OS::Neutron::Net',NULL,NULL),(427,'3c819db7-68df-4768-845c-17ee837298c7','1720f7a8-089a-4ce2-923f-a30c23acee53','2025-11-29 07:59:05',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-35781114','1720f7a8-089a-4ce2-923f-a30c23acee53','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(428,'16ff9779-8e79-43c2-b836-f1382a6d76d5','1720f7a8-089a-4ce2-923f-a30c23acee53','2025-11-29 07:59:05',NULL,'UPDATE','IN_PROGRESS','subnet','5919fc11-971d-4001-8b2f-3ff7631ca669','state changed','OS::Neutron::Subnet',NULL,86),(429,'a2b0131b-c69a-4119-8a26-b5713b7bd95a','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:59:06',NULL,'DELETE','COMPLETE','parent_net','eee24d61-33f6-4879-8595-d20872aa9056','state changed','OS::Neutron::Net',NULL,NULL),(430,'6c97acd6-37df-4070-8d1f-2625b917a87f','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:59:06',NULL,'DELETE','COMPLETE','UpdateTrunkTest-1311242840','7496186f-e0d9-4600-92d1-24f7ffdcb5a5','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(431,'c3bcab9b-ab7d-4c3b-8799-fea285947a6f','ec08cf3b-4733-475f-81cb-90f8d2ab3380','2025-11-29 07:59:06',NULL,'CREATE','IN_PROGRESS','add_subnet','ec08cf3b-4733-475f-81cb-90f8d2ab3380','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(432,'51df3845-dc8c-45de-8b11-eaec0ffaa41f','ec08cf3b-4733-475f-81cb-90f8d2ab3380','2025-11-29 07:59:07',NULL,'CREATE','IN_PROGRESS','net','add_subnet-net-hh46vuq2atgc','state changed','OS::Neutron::Net',NULL,94),(433,'5f865f85-5a5f-4ff2-b52d-46ac1c48c76a','1720f7a8-089a-4ce2-923f-a30c23acee53','2025-11-29 07:59:07',NULL,'UPDATE','COMPLETE','subnet','5919fc11-971d-4001-8b2f-3ff7631ca669','state changed','OS::Neutron::Subnet',NULL,93),(434,'13b291b6-057b-405c-9c95-ec1a9991ff91','1720f7a8-089a-4ce2-923f-a30c23acee53','2025-11-29 07:59:07',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-35781114','1720f7a8-089a-4ce2-923f-a30c23acee53','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(435,'627bb587-6d2d-4f3a-b843-1a70a9960cfb','ec08cf3b-4733-475f-81cb-90f8d2ab3380','2025-11-29 07:59:08',NULL,'CREATE','COMPLETE','net','97cbc105-a076-4727-b663-f01e649bcbf7','state changed','OS::Neutron::Net',NULL,94),(436,'b7ebf413-d17e-48f6-9efc-0f89a0d241b0','ec08cf3b-4733-475f-81cb-90f8d2ab3380','2025-11-29 07:59:08',NULL,'CREATE','IN_PROGRESS','subnet','add_subnet-subnet-bk6enbtoegpd','state changed','OS::Neutron::Subnet',NULL,95),(437,'eb4a8bac-9bc7-4e9a-891f-a8b66d98906b','ec08cf3b-4733-475f-81cb-90f8d2ab3380','2025-11-29 07:59:10',NULL,'CREATE','COMPLETE','subnet','f9c21400-fbff-4123-864e-cf13206f2c00','state changed','OS::Neutron::Subnet',NULL,95),(438,'74b6e1cb-fb1c-43c4-b42a-e228e4c1dcdd','ec08cf3b-4733-475f-81cb-90f8d2ab3380','2025-11-29 07:59:10',NULL,'CREATE','IN_PROGRESS','server','add_subnet-server-etv2w3wop3ht','state changed','OS::Nova::Server',NULL,96),(439,'2c63710d-e02b-4143-bb2b-3fce85f591ea','1720f7a8-089a-4ce2-923f-a30c23acee53','2025-11-29 07:59:10',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-35781114','1720f7a8-089a-4ce2-923f-a30c23acee53','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(440,'317997e2-fd83-4a7e-a6ba-66362fe9f739','1720f7a8-089a-4ce2-923f-a30c23acee53','2025-11-29 07:59:10',NULL,'DELETE','IN_PROGRESS','subnet','5919fc11-971d-4001-8b2f-3ff7631ca669','state changed','OS::Neutron::Subnet',NULL,93),(441,'2af4728a-4489-4564-a342-5816c6723796','1720f7a8-089a-4ce2-923f-a30c23acee53','2025-11-29 07:59:11',NULL,'DELETE','COMPLETE','subnet','5919fc11-971d-4001-8b2f-3ff7631ca669','state changed','OS::Neutron::Subnet',NULL,93),(442,'64520a67-71f9-468b-bee1-6c9f2c3db814','1720f7a8-089a-4ce2-923f-a30c23acee53','2025-11-29 07:59:11',NULL,'DELETE','IN_PROGRESS','net','0dd42ac1-019b-48ae-b76c-6e1fb166388b','state changed','OS::Neutron::Net',NULL,NULL),(443,'0a4c1640-4584-4302-8f5c-3c9238b91808','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:11',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-1613110987','f744021c-6440-4773-8d90-91e1d6439dd5','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(444,'b9d5f73e-55b5-425b-a24a-ec7378d6d378','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:11',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-1613110987-trunk_net_two-qj4oniguwopm','state changed','OS::Neutron::Net',NULL,NULL),(445,'dd46fca8-71a5-418f-a85e-acac97f22a8d','1720f7a8-089a-4ce2-923f-a30c23acee53','2025-11-29 07:59:12',NULL,'DELETE','COMPLETE','net','0dd42ac1-019b-48ae-b76c-6e1fb166388b','state changed','OS::Neutron::Net',NULL,NULL),(446,'a843fd6a-4ce3-49b6-91c7-c852977afc9f','1720f7a8-089a-4ce2-923f-a30c23acee53','2025-11-29 07:59:12',NULL,'DELETE','COMPLETE','UpdateSubnetTest-35781114','1720f7a8-089a-4ce2-923f-a30c23acee53','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(447,'927076cb-fb5c-40e6-8f27-1ec0e27d6b69','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:12',NULL,'CREATE','COMPLETE','trunk_net_two','a3d3c3bd-060e-4ce2-96d2-fbffb0280374','state changed','OS::Neutron::Net',NULL,NULL),(448,'1f0ed40c-894c-48b5-9e2c-23fcc00e0dbb','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:12',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-1613110987-trunk_subnet_two-2cqnjw2uiup3','state changed','OS::Neutron::Subnet',NULL,98),(449,'aec74797-d9f8-4ffb-b2a5-32a7f10a9566','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:12',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-1613110987-parent_net-it3iltcvnn5q','state changed','OS::Neutron::Net',NULL,NULL),(450,'fbadf114-2288-4ef9-8536-97dcb64786ab','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:14',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-1613110987-trunk_net_one-snbb66rqa7e6','state changed','OS::Neutron::Net',NULL,NULL),(451,'c9d9d371-d94a-408d-9e59-644fa6169cca','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:16',NULL,'CREATE','COMPLETE','parent_net','c9d5a9eb-8646-4e05-bdbe-ffb37bdf6c1a','state changed','OS::Neutron::Net',NULL,NULL),(452,'6d456ad8-88e9-4ca9-bd8a-8793429c1edf','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:16',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-1613110987-parent_subnet-qs7u2dilhbbr','state changed','OS::Neutron::Subnet',NULL,99),(453,'2f2f776b-a01b-4c7b-a56f-54303dc85869','5f1ce0f6-ade7-4dc1-afb1-a43d8b9ff6f9','2025-11-29 07:59:17',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-1028229510','5f1ce0f6-ade7-4dc1-afb1-a43d8b9ff6f9','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(454,'abba6867-93bf-43c5-af4d-cf3a79da8c08','5f1ce0f6-ade7-4dc1-afb1-a43d8b9ff6f9','2025-11-29 07:59:17',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-1028229510-net-rceu3zvp67mx','state changed','OS::Neutron::Net',NULL,NULL),(455,'b592dc2b-badb-4d57-8fff-14e6af26b86d','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:17',NULL,'CREATE','COMPLETE','trunk_subnet_two','6741014b-c439-4645-bbb7-4b6a8e0337a3','state changed','OS::Neutron::Subnet',NULL,98),(456,'877ae5e1-0bcb-49f9-8ded-a3080042729e','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:17',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-1613110987-sub_port_two-c7muif3ftps2','state changed','OS::Neutron::Port',NULL,100),(457,'5840b750-32f6-4b90-8319-a3a1a9cbde8c','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:17',NULL,'CREATE','COMPLETE','trunk_net_one','74cdb224-52bb-4c29-b7d7-9ba65edf8284','state changed','OS::Neutron::Net',NULL,NULL),(458,'a43bacbe-f79c-4fb0-9cc1-f414f7ee3f4d','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:17',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-1613110987-trunk_subnet_one-63zimodwrjdr','state changed','OS::Neutron::Subnet',NULL,101),(459,'3b2a354d-43d6-4bb2-aa8f-d235e2f8d2b8','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:17',NULL,'CREATE','COMPLETE','parent_subnet','87ee0325-b623-4df8-9665-d175b773c806','state changed','OS::Neutron::Subnet',NULL,99),(460,'08b37416-2f8d-4ab1-9766-b7de806bac5c','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:17',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-1613110987-parent_port-lekzywesz7rf','state changed','OS::Neutron::Port',NULL,102),(461,'dd00c816-a874-478c-ac1c-8fd20149a0f3','5f1ce0f6-ade7-4dc1-afb1-a43d8b9ff6f9','2025-11-29 07:59:18',NULL,'CREATE','COMPLETE','net','5eea2e3a-bc23-4d8d-a1b7-8ac03906f286','state changed','OS::Neutron::Net',NULL,NULL),(462,'5a0c2400-625c-4862-9a2b-f22f58135e58','5f1ce0f6-ade7-4dc1-afb1-a43d8b9ff6f9','2025-11-29 07:59:19',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-1028229510-subnet-e3yie4vczqab','state changed','OS::Neutron::Subnet',NULL,103),(463,'d75bf25c-377a-4a10-94e7-17237e2a9828','cd5db660-aa61-4e2d-8500-abc0b35f16e9','2025-11-29 07:59:20',NULL,'CREATE','COMPLETE','server','f9ee05e7-b07f-43c2-9ce3-be5cbfcd62e5','state changed','OS::Nova::Server',NULL,91),(464,'c7c35125-ab5d-4e47-b814-86787effd9ba','cd5db660-aa61-4e2d-8500-abc0b35f16e9','2025-11-29 07:59:20',NULL,'CREATE','COMPLETE','create_server_with_sub_ip','cd5db660-aa61-4e2d-8500-abc0b35f16e9','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(465,'6e027c0b-5fad-4b91-9c87-d2424daa78ea','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:20',NULL,'CREATE','COMPLETE','trunk_subnet_one','fd61716d-a83f-483f-838c-1bb837b525bb','state changed','OS::Neutron::Subnet',NULL,101),(466,'b3ad36ab-5091-45c5-affa-fb5189b02158','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:20',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-1613110987-sub_port_one-ge3mjjxovvso','state changed','OS::Neutron::Port',NULL,104),(467,'3e427646-7a3e-474a-87a7-bd572cb8ff5f','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:20',NULL,'CREATE','COMPLETE','sub_port_two','854738c5-3f8b-4395-a4d4-64a2713a445f','state changed','OS::Neutron::Port',NULL,100),(468,'cba16715-187b-4a98-91ad-29433a09fd8c','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:21',NULL,'CREATE','COMPLETE','parent_port','49ba949a-4a3e-4df1-b33c-47c0bee2664a','state changed','OS::Neutron::Port',NULL,102),(469,'3650932b-eea1-45f5-bc3e-12d253219e8c','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:25',NULL,'CREATE','COMPLETE','sub_port_one','a8e02321-3a4b-4ac9-9b2b-dd77b8331132','state changed','OS::Neutron::Port',NULL,104),(470,'6694b532-cbd5-4279-9130-9daf47e34b28','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:25',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-1613110987-trunk-7qdvisq2irzc','state changed','OS::Neutron::Trunk',NULL,105),(471,'87b6bd24-f099-44ec-98ce-71aa1114c0d2','5f1ce0f6-ade7-4dc1-afb1-a43d8b9ff6f9','2025-11-29 07:59:25',NULL,'CREATE','COMPLETE','subnet','ff4ab5b9-1a4c-4b38-b153-71f4a7c375e5','state changed','OS::Neutron::Subnet',NULL,103),(472,'878ef77c-cd03-498f-9cb7-6957fc341c58','5f1ce0f6-ade7-4dc1-afb1-a43d8b9ff6f9','2025-11-29 07:59:25',NULL,'CREATE','COMPLETE','UpdateSubnetTest-1028229510','5f1ce0f6-ade7-4dc1-afb1-a43d8b9ff6f9','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(473,'a6706027-2baf-4db2-98f4-053265d35f29','cd5db660-aa61-4e2d-8500-abc0b35f16e9','2025-11-29 07:59:27',NULL,'UPDATE','IN_PROGRESS','create_server_with_sub_ip','cd5db660-aa61-4e2d-8500-abc0b35f16e9','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(474,'f99094c8-b08f-49f9-a575-6fa26e15a28c','ec08cf3b-4733-475f-81cb-90f8d2ab3380','2025-11-29 07:59:30',NULL,'CREATE','COMPLETE','server','6b1f57a0-6537-476f-85f5-715638dcc5ca','state changed','OS::Nova::Server',NULL,96),(475,'02b100f8-6008-48ac-8ac9-96186872e525','ec08cf3b-4733-475f-81cb-90f8d2ab3380','2025-11-29 07:59:31',NULL,'CREATE','COMPLETE','add_subnet','ec08cf3b-4733-475f-81cb-90f8d2ab3380','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(476,'979c9cc3-8a21-4639-a8d6-a35a3b276146','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:31',NULL,'CREATE','COMPLETE','trunk','2bdeb60b-4ec2-49b9-8002-cc86a13d909d','state changed','OS::Neutron::Trunk',NULL,105),(477,'9f9358c0-3439-40f4-a2ae-c3fcb90bf8ef','cd5db660-aa61-4e2d-8500-abc0b35f16e9','2025-11-29 07:59:31',NULL,'UPDATE','IN_PROGRESS','server','f9ee05e7-b07f-43c2-9ce3-be5cbfcd62e5','state changed','OS::Nova::Server',NULL,91),(478,'021fa163-395a-4fb0-9ae8-6bd532606942','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:31',NULL,'CREATE','COMPLETE','UpdateTrunkTest-1613110987','f744021c-6440-4773-8d90-91e1d6439dd5','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(479,'5ec3c073-569e-402a-b7ef-1e75c96cf406','5f1ce0f6-ade7-4dc1-afb1-a43d8b9ff6f9','2025-11-29 07:59:31',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-1028229510','5f1ce0f6-ade7-4dc1-afb1-a43d8b9ff6f9','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(480,'42f81595-a38b-41f5-af7a-adf59057d882','5f1ce0f6-ade7-4dc1-afb1-a43d8b9ff6f9','2025-11-29 07:59:32',NULL,'UPDATE','IN_PROGRESS','subnet','ff4ab5b9-1a4c-4b38-b153-71f4a7c375e5','state changed','OS::Neutron::Subnet',NULL,103),(481,'d3806cd5-798e-449e-bfe3-78b5b51ece7a','5f1ce0f6-ade7-4dc1-afb1-a43d8b9ff6f9','2025-11-29 07:59:34',NULL,'UPDATE','COMPLETE','subnet','ff4ab5b9-1a4c-4b38-b153-71f4a7c375e5','state changed','OS::Neutron::Subnet',NULL,108),(482,'04c59c4f-50a2-4334-b603-1abf7cce490d','5f1ce0f6-ade7-4dc1-afb1-a43d8b9ff6f9','2025-11-29 07:59:34',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-1028229510','5f1ce0f6-ade7-4dc1-afb1-a43d8b9ff6f9','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(483,'e8c85bf8-3f80-48bf-b569-fe51cbd1c525','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:34',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-1613110987','f744021c-6440-4773-8d90-91e1d6439dd5','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(484,'f346b5f1-8b34-47e5-8274-2e616fc0517e','ec08cf3b-4733-475f-81cb-90f8d2ab3380','2025-11-29 07:59:36',NULL,'UPDATE','IN_PROGRESS','add_subnet','ec08cf3b-4733-475f-81cb-90f8d2ab3380','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(485,'3108a02f-3684-497b-90c6-4f42369d4382','ec08cf3b-4733-475f-81cb-90f8d2ab3380','2025-11-29 07:59:36',NULL,'UPDATE','IN_PROGRESS','server','6b1f57a0-6537-476f-85f5-715638dcc5ca','state changed','OS::Nova::Server',NULL,96),(486,'d505cf5e-467a-4559-a6c9-a7fbc9366b41','5f1ce0f6-ade7-4dc1-afb1-a43d8b9ff6f9','2025-11-29 07:59:37',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-1028229510','5f1ce0f6-ade7-4dc1-afb1-a43d8b9ff6f9','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(487,'2b2f6f81-752c-4cc2-9b35-cb92673baa9d','5f1ce0f6-ade7-4dc1-afb1-a43d8b9ff6f9','2025-11-29 07:59:37',NULL,'DELETE','IN_PROGRESS','subnet','ff4ab5b9-1a4c-4b38-b153-71f4a7c375e5','state changed','OS::Neutron::Subnet',NULL,108),(488,'3594f202-2153-455b-90d9-1a10ddab2fb5','5f1ce0f6-ade7-4dc1-afb1-a43d8b9ff6f9','2025-11-29 07:59:38',NULL,'DELETE','COMPLETE','subnet','ff4ab5b9-1a4c-4b38-b153-71f4a7c375e5','state changed','OS::Neutron::Subnet',NULL,108),(489,'93eee129-10f9-42ca-8466-e7a946a9e0c7','5f1ce0f6-ade7-4dc1-afb1-a43d8b9ff6f9','2025-11-29 07:59:38',NULL,'DELETE','IN_PROGRESS','net','5eea2e3a-bc23-4d8d-a1b7-8ac03906f286','state changed','OS::Neutron::Net',NULL,NULL),(490,'9c17ef38-5f36-4bf8-b630-9a90dc589a0c','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:38',NULL,'UPDATE','IN_PROGRESS','trunk','2bdeb60b-4ec2-49b9-8002-cc86a13d909d','state changed','OS::Neutron::Trunk',NULL,105),(491,'ce1ad57b-885d-4b48-8a7d-e2108193c398','5f1ce0f6-ade7-4dc1-afb1-a43d8b9ff6f9','2025-11-29 07:59:38',NULL,'DELETE','COMPLETE','net','5eea2e3a-bc23-4d8d-a1b7-8ac03906f286','state changed','OS::Neutron::Net',NULL,NULL),(492,'ff069877-e25f-4683-b1a2-96378e448094','5f1ce0f6-ade7-4dc1-afb1-a43d8b9ff6f9','2025-11-29 07:59:38',NULL,'DELETE','COMPLETE','UpdateSubnetTest-1028229510','5f1ce0f6-ade7-4dc1-afb1-a43d8b9ff6f9','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(493,'fc751a59-f974-4454-8713-95d47cad13da','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:39',NULL,'UPDATE','COMPLETE','trunk','2bdeb60b-4ec2-49b9-8002-cc86a13d909d','state changed','OS::Neutron::Trunk',NULL,111),(494,'4b297e3e-d1f2-4752-955c-15d9df2802eb','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:39',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-1613110987','f744021c-6440-4773-8d90-91e1d6439dd5','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(495,'c4a856bd-33f9-4ded-ba02-10f69558c94c','ec08cf3b-4733-475f-81cb-90f8d2ab3380','2025-11-29 07:59:40',NULL,'UPDATE','COMPLETE','server','6b1f57a0-6537-476f-85f5-715638dcc5ca','state changed','OS::Nova::Server',NULL,112),(496,'5e7a6da9-6cfb-4e97-b70a-5a654de9d601','ec08cf3b-4733-475f-81cb-90f8d2ab3380','2025-11-29 07:59:40',NULL,'UPDATE','COMPLETE','add_subnet','ec08cf3b-4733-475f-81cb-90f8d2ab3380','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(497,'b528c240-170b-428f-a5db-936d421bd117','ec08cf3b-4733-475f-81cb-90f8d2ab3380','2025-11-29 07:59:42',NULL,'DELETE','IN_PROGRESS','add_subnet','ec08cf3b-4733-475f-81cb-90f8d2ab3380','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(498,'4f4fc155-b706-46f6-8deb-4de68c550639','ec08cf3b-4733-475f-81cb-90f8d2ab3380','2025-11-29 07:59:42',NULL,'DELETE','IN_PROGRESS','server','6b1f57a0-6537-476f-85f5-715638dcc5ca','state changed','OS::Nova::Server',NULL,112),(499,'b90c7bf1-f528-441d-86ae-e493aaefd632','458e4ad4-3e9f-49c1-ac15-c57e9c25cd71','2025-11-29 07:59:43',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-250818380','458e4ad4-3e9f-49c1-ac15-c57e9c25cd71','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(500,'4ba8675f-1f2a-475b-9c8d-f21390d5be1b','458e4ad4-3e9f-49c1-ac15-c57e9c25cd71','2025-11-29 07:59:43',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-250818380-net-s7xwhav727xh','state changed','OS::Neutron::Net',NULL,NULL),(501,'07cdf14e-88de-460a-b71c-5673bc428441','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:45',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-1613110987','f744021c-6440-4773-8d90-91e1d6439dd5','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(502,'df0b3d2d-4935-475e-abe9-57e0ddaa8a81','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:46',NULL,'DELETE','IN_PROGRESS','sub_port_two','854738c5-3f8b-4395-a4d4-64a2713a445f','state changed','OS::Neutron::Port',NULL,100),(503,'b2901c62-4cf1-4d6f-a231-a07acd0069b5','458e4ad4-3e9f-49c1-ac15-c57e9c25cd71','2025-11-29 07:59:47',NULL,'CREATE','COMPLETE','net','bcee4ba6-9b15-4254-82ef-3456258509bb','state changed','OS::Neutron::Net',NULL,NULL),(504,'37d16df4-2926-44c7-8b77-5bc29cfd30ab','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:47',NULL,'DELETE','COMPLETE','sub_port_two','854738c5-3f8b-4395-a4d4-64a2713a445f','state changed','OS::Neutron::Port',NULL,100),(505,'485ad8b7-cfc1-4c59-97ba-1be7bc5a1be1','458e4ad4-3e9f-49c1-ac15-c57e9c25cd71','2025-11-29 07:59:47',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-250818380-subnet-cr66gvazdzyz','state changed','OS::Neutron::Subnet',NULL,115),(506,'3914de9b-cf62-479a-836e-136be003b050','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:47',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','6741014b-c439-4645-bbb7-4b6a8e0337a3','state changed','OS::Neutron::Subnet',NULL,98),(507,'294e38a3-aa03-4833-9be4-9d067d83be28','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:47',NULL,'DELETE','COMPLETE','trunk_subnet_two','6741014b-c439-4645-bbb7-4b6a8e0337a3','state changed','OS::Neutron::Subnet',NULL,98),(508,'5c0fdbb7-5261-43ba-93f5-694f212d7366','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:47',NULL,'DELETE','IN_PROGRESS','trunk_net_two','a3d3c3bd-060e-4ce2-96d2-fbffb0280374','state changed','OS::Neutron::Net',NULL,NULL),(509,'60a73934-9e08-4094-81e5-e9a5663aedf1','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:47',NULL,'DELETE','IN_PROGRESS','trunk','2bdeb60b-4ec2-49b9-8002-cc86a13d909d','state changed','OS::Neutron::Trunk',NULL,111),(510,'a74c894e-e30a-4502-ace7-2ce9abf2a592','ec08cf3b-4733-475f-81cb-90f8d2ab3380','2025-11-29 07:59:47',NULL,'DELETE','COMPLETE','server','6b1f57a0-6537-476f-85f5-715638dcc5ca','state changed','OS::Nova::Server',NULL,112),(511,'26374b54-5680-4e27-8b34-0801590bc95e','ec08cf3b-4733-475f-81cb-90f8d2ab3380','2025-11-29 07:59:47',NULL,'DELETE','IN_PROGRESS','subnet','f9c21400-fbff-4123-864e-cf13206f2c00','state changed','OS::Neutron::Subnet',NULL,95),(512,'007b2c3e-2ada-4577-9416-11cb7c0612d5','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:48',NULL,'DELETE','COMPLETE','trunk','2bdeb60b-4ec2-49b9-8002-cc86a13d909d','state changed','OS::Neutron::Trunk',NULL,111),(513,'979aa5e2-34b1-401f-be9f-c9a091bcde91','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:48',NULL,'DELETE','IN_PROGRESS','parent_port','49ba949a-4a3e-4df1-b33c-47c0bee2664a','state changed','OS::Neutron::Port',NULL,102),(514,'46716fb9-3874-4586-b370-c91a5ba36ba1','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:48',NULL,'DELETE','IN_PROGRESS','sub_port_one','a8e02321-3a4b-4ac9-9b2b-dd77b8331132','state changed','OS::Neutron::Port',NULL,104),(515,'da80d639-9918-48b8-bd45-d74469b38c89','cd5db660-aa61-4e2d-8500-abc0b35f16e9','2025-11-29 07:59:48',NULL,'UPDATE','COMPLETE','server','f9ee05e7-b07f-43c2-9ce3-be5cbfcd62e5','state changed','OS::Nova::Server',NULL,116),(516,'ffa8c2f6-b075-4dd6-82e6-a3e9d57f292a','cd5db660-aa61-4e2d-8500-abc0b35f16e9','2025-11-29 07:59:48',NULL,'UPDATE','COMPLETE','create_server_with_sub_ip','cd5db660-aa61-4e2d-8500-abc0b35f16e9','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(517,'76570809-2623-4ebd-a36e-27cd7a83f4bd','ec08cf3b-4733-475f-81cb-90f8d2ab3380','2025-11-29 07:59:48',NULL,'DELETE','COMPLETE','subnet','f9c21400-fbff-4123-864e-cf13206f2c00','state changed','OS::Neutron::Subnet',NULL,95),(518,'daaeb237-a872-4902-91c3-c733119ceb6b','ec08cf3b-4733-475f-81cb-90f8d2ab3380','2025-11-29 07:59:48',NULL,'DELETE','IN_PROGRESS','net','97cbc105-a076-4727-b663-f01e649bcbf7','state changed','OS::Neutron::Net',NULL,94),(519,'47384118-2cd7-41cb-a4a1-32107c0f694f','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:49',NULL,'DELETE','COMPLETE','sub_port_one','a8e02321-3a4b-4ac9-9b2b-dd77b8331132','state changed','OS::Neutron::Port',NULL,104),(520,'313f9f00-9d87-446b-986d-305eb85a2549','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:49',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','fd61716d-a83f-483f-838c-1bb837b525bb','state changed','OS::Neutron::Subnet',NULL,101),(521,'8134b9c4-a883-4811-82d6-0a69097b0189','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:49',NULL,'DELETE','COMPLETE','trunk_net_two','a3d3c3bd-060e-4ce2-96d2-fbffb0280374','state changed','OS::Neutron::Net',NULL,NULL),(522,'e451183a-5694-4185-9d63-4a9eceff5e0c','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:49',NULL,'DELETE','COMPLETE','parent_port','49ba949a-4a3e-4df1-b33c-47c0bee2664a','state changed','OS::Neutron::Port',NULL,102),(523,'2838b77c-a92e-460a-b767-7a1b1c58bf41','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:49',NULL,'DELETE','IN_PROGRESS','parent_subnet','87ee0325-b623-4df8-9665-d175b773c806','state changed','OS::Neutron::Subnet',NULL,99),(524,'2cf4876c-e945-4e85-b7ba-5213f6e90cd7','ec08cf3b-4733-475f-81cb-90f8d2ab3380','2025-11-29 07:59:49',NULL,'DELETE','COMPLETE','net','97cbc105-a076-4727-b663-f01e649bcbf7','state changed','OS::Neutron::Net',NULL,94),(525,'5342b39a-08eb-43e1-aad7-a79ca4c6b350','ec08cf3b-4733-475f-81cb-90f8d2ab3380','2025-11-29 07:59:50',NULL,'DELETE','COMPLETE','add_subnet','ec08cf3b-4733-475f-81cb-90f8d2ab3380','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(526,'57799bcf-b2a6-4c48-b262-51b53d0fec00','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:50',NULL,'DELETE','COMPLETE','trunk_subnet_one','fd61716d-a83f-483f-838c-1bb837b525bb','state changed','OS::Neutron::Subnet',NULL,101),(527,'8bc42126-4485-468c-8b08-51cf87eb059a','458e4ad4-3e9f-49c1-ac15-c57e9c25cd71','2025-11-29 07:59:51',NULL,'CREATE','COMPLETE','subnet','91fd259d-b775-47a8-bcc6-f4d11b41b053','state changed','OS::Neutron::Subnet',NULL,115),(528,'05201925-edf2-440d-86f8-a5af79f6eb5f','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:51',NULL,'DELETE','IN_PROGRESS','trunk_net_one','74cdb224-52bb-4c29-b7d7-9ba65edf8284','state changed','OS::Neutron::Net',NULL,NULL),(529,'252e7391-1b55-476b-9073-5e2e94e947d4','458e4ad4-3e9f-49c1-ac15-c57e9c25cd71','2025-11-29 07:59:51',NULL,'CREATE','COMPLETE','UpdateSubnetTest-250818380','458e4ad4-3e9f-49c1-ac15-c57e9c25cd71','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(530,'48d0e61d-e65d-465d-ac2c-f156fed7c818','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:51',NULL,'DELETE','COMPLETE','parent_subnet','87ee0325-b623-4df8-9665-d175b773c806','state changed','OS::Neutron::Subnet',NULL,99),(531,'6412178b-fdca-4089-8807-ba3efb0dbb23','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:51',NULL,'DELETE','IN_PROGRESS','parent_net','c9d5a9eb-8646-4e05-bdbe-ffb37bdf6c1a','state changed','OS::Neutron::Net',NULL,NULL),(532,'67dabc79-ceab-4705-878f-1bb34a5fd153','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:52',NULL,'DELETE','COMPLETE','trunk_net_one','74cdb224-52bb-4c29-b7d7-9ba65edf8284','state changed','OS::Neutron::Net',NULL,NULL),(533,'5d823074-3421-485d-8060-3b709782ea57','cd5db660-aa61-4e2d-8500-abc0b35f16e9','2025-11-29 07:59:52',NULL,'DELETE','IN_PROGRESS','create_server_with_sub_ip','cd5db660-aa61-4e2d-8500-abc0b35f16e9','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(534,'a67b4eac-b011-400d-a8c6-632aa6b179c1','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:52',NULL,'DELETE','COMPLETE','parent_net','c9d5a9eb-8646-4e05-bdbe-ffb37bdf6c1a','state changed','OS::Neutron::Net',NULL,NULL),(535,'7f31b2a8-bff0-484c-92fa-252214daeec3','cd5db660-aa61-4e2d-8500-abc0b35f16e9','2025-11-29 07:59:52',NULL,'DELETE','IN_PROGRESS','server','f9ee05e7-b07f-43c2-9ce3-be5cbfcd62e5','state changed','OS::Nova::Server',NULL,116),(536,'b1ffb23b-5d63-494c-b5df-9d581039b717','f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:52',NULL,'DELETE','COMPLETE','UpdateTrunkTest-1613110987','f744021c-6440-4773-8d90-91e1d6439dd5','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(537,'c46f7380-a61d-4619-81a8-73b90b62f760','458e4ad4-3e9f-49c1-ac15-c57e9c25cd71','2025-11-29 07:59:54',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-250818380','458e4ad4-3e9f-49c1-ac15-c57e9c25cd71','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(538,'708b546b-34ef-4b06-b102-cae3d350123c','458e4ad4-3e9f-49c1-ac15-c57e9c25cd71','2025-11-29 07:59:54',NULL,'UPDATE','IN_PROGRESS','subnet','91fd259d-b775-47a8-bcc6-f4d11b41b053','state changed','OS::Neutron::Subnet',NULL,115),(539,'9cf109aa-3e68-4f4f-a7fd-63c3c3c1c5df','cd5db660-aa61-4e2d-8500-abc0b35f16e9','2025-11-29 07:59:55',NULL,'DELETE','COMPLETE','server','f9ee05e7-b07f-43c2-9ce3-be5cbfcd62e5','state changed','OS::Nova::Server',NULL,116),(540,'52007138-a78a-4ae9-ba4b-ad701d883ba6','cd5db660-aa61-4e2d-8500-abc0b35f16e9','2025-11-29 07:59:55',NULL,'DELETE','IN_PROGRESS','subnet_b','164779e4-2bcb-4ec5-80a4-57a749b90764','state changed','OS::Neutron::Subnet',NULL,89),(541,'4ebe7a5a-4414-4829-b1cb-b00e45c629c5','cd5db660-aa61-4e2d-8500-abc0b35f16e9','2025-11-29 07:59:55',NULL,'DELETE','IN_PROGRESS','subnet_a','6c3098e2-293f-43d0-b6a9-894ddb73c36c','state changed','OS::Neutron::Subnet',NULL,90),(542,'708442c3-5910-49fc-b7c8-d1bb8057a9fc','cd5db660-aa61-4e2d-8500-abc0b35f16e9','2025-11-29 07:59:55',NULL,'DELETE','COMPLETE','subnet_b','164779e4-2bcb-4ec5-80a4-57a749b90764','state changed','OS::Neutron::Subnet',NULL,89),(543,'ffbe4c19-2abe-4bf3-b851-696179aee369','cd5db660-aa61-4e2d-8500-abc0b35f16e9','2025-11-29 07:59:55',NULL,'DELETE','COMPLETE','subnet_a','6c3098e2-293f-43d0-b6a9-894ddb73c36c','state changed','OS::Neutron::Subnet',NULL,90),(544,'f792bf5a-21ed-46ee-8855-ca5e8e5a3bc8','cd5db660-aa61-4e2d-8500-abc0b35f16e9','2025-11-29 07:59:55',NULL,'DELETE','IN_PROGRESS','net','eecd6003-fac5-419b-9548-542726bd10fc','state changed','OS::Neutron::Net',NULL,87),(545,'18c2c371-963d-4180-9bb6-b6efe857910d','458e4ad4-3e9f-49c1-ac15-c57e9c25cd71','2025-11-29 07:59:56',NULL,'UPDATE','COMPLETE','subnet','91fd259d-b775-47a8-bcc6-f4d11b41b053','state changed','OS::Neutron::Subnet',NULL,119),(546,'1ed1f5e8-89d8-4c98-8fa8-9dfe6799cfb1','458e4ad4-3e9f-49c1-ac15-c57e9c25cd71','2025-11-29 07:59:56',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-250818380','458e4ad4-3e9f-49c1-ac15-c57e9c25cd71','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(547,'4d2889d4-51ee-4846-bd9c-dd81f82a1522','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 07:59:56',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-257617379','005aa58a-83a8-475d-b468-a4beaa77ca80','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(548,'76464433-5f28-4569-ba78-f91b4c6b4537','cd5db660-aa61-4e2d-8500-abc0b35f16e9','2025-11-29 07:59:56',NULL,'DELETE','COMPLETE','net','eecd6003-fac5-419b-9548-542726bd10fc','state changed','OS::Neutron::Net',NULL,87),(549,'d4487541-21aa-4ac3-8b77-142b707f55b0','cd5db660-aa61-4e2d-8500-abc0b35f16e9','2025-11-29 07:59:56',NULL,'DELETE','COMPLETE','create_server_with_sub_ip','cd5db660-aa61-4e2d-8500-abc0b35f16e9','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(550,'88910464-e545-4e0a-9c56-3475117dc1de','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 07:59:56',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-257617379-trunk_net_two-zekn77uhaqrp','state changed','OS::Neutron::Net',NULL,NULL),(551,'c8871f46-dada-4397-ad5b-89c3baa115ee','9cee4f59-6335-40cc-8093-c0eba2ae107d','2025-11-29 07:59:57',NULL,'CREATE','IN_PROGRESS','multi_networks_swaps','9cee4f59-6335-40cc-8093-c0eba2ae107d','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(552,'4e10d4ae-d974-4342-be2a-61973b5c60bf','9cee4f59-6335-40cc-8093-c0eba2ae107d','2025-11-29 07:59:57',NULL,'CREATE','IN_PROGRESS','net','multi_networks_swaps-net-7phgaijrh3sw','state changed','OS::Neutron::Net',NULL,120),(553,'87823a34-add4-48d7-becc-051dbcc06056','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 07:59:57',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-257617379-parent_net-vfujyzxsxrcp','state changed','OS::Neutron::Net',NULL,NULL),(554,'920a035f-82b3-45a6-9395-5995de70926c','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 07:59:57',NULL,'CREATE','COMPLETE','trunk_net_two','73924a76-f881-4f1d-9f07-4d37f076b63e','state changed','OS::Neutron::Net',NULL,NULL),(555,'04381ffb-214b-490d-8e34-79109993bbc5','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 07:59:57',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-257617379-trunk_subnet_two-xb2yatmqd73b','state changed','OS::Neutron::Subnet',NULL,121),(556,'62315dd0-e369-4bc7-86cd-b9239f7c3f3d','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 07:59:58',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-257617379-trunk_net_one-7xtvwzc4aucz','state changed','OS::Neutron::Net',NULL,NULL),(557,'46d9398d-f671-4f1b-96e8-0f8e3281f19a','9cee4f59-6335-40cc-8093-c0eba2ae107d','2025-11-29 07:59:58',NULL,'CREATE','COMPLETE','net','7d9230f5-9cad-4dd3-8785-36e7a0e4b56a','state changed','OS::Neutron::Net',NULL,120),(558,'8852ec83-03e1-49cf-ad5e-84e9270ff831','9cee4f59-6335-40cc-8093-c0eba2ae107d','2025-11-29 07:59:58',NULL,'CREATE','IN_PROGRESS','subnet','multi_networks_swaps-subnet-fopby3pvf5ab','state changed','OS::Neutron::Subnet',NULL,122),(559,'9afe3fdc-5935-445e-a3ee-61238feed26b','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 07:59:59',NULL,'CREATE','COMPLETE','parent_net','b0b40f24-465d-4777-b809-c36c792fffcf','state changed','OS::Neutron::Net',NULL,NULL),(560,'38a0e442-081d-4df2-9aeb-4af77e38158f','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 07:59:59',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-257617379-parent_subnet-msltpgivmpxp','state changed','OS::Neutron::Subnet',NULL,123),(561,'41868b69-095f-45eb-9a67-5cbee2614411','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 07:59:59',NULL,'CREATE','COMPLETE','trunk_subnet_two','794acd55-19bb-45d2-bd99-b77daf45f065','state changed','OS::Neutron::Subnet',NULL,121),(562,'b8b1d6a8-f28a-4a56-8a2a-b0b36cd998e8','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 07:59:59',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-257617379-sub_port_two-g2zrqbly7rgc','state changed','OS::Neutron::Port',NULL,125),(563,'54a7cedd-c6da-466d-8e24-40ba2fc72d2b','458e4ad4-3e9f-49c1-ac15-c57e9c25cd71','2025-11-29 07:59:59',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-250818380','458e4ad4-3e9f-49c1-ac15-c57e9c25cd71','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(564,'e57327ca-9750-40a0-baeb-f5ec884e351f','458e4ad4-3e9f-49c1-ac15-c57e9c25cd71','2025-11-29 07:59:59',NULL,'DELETE','IN_PROGRESS','subnet','91fd259d-b775-47a8-bcc6-f4d11b41b053','state changed','OS::Neutron::Subnet',NULL,119),(565,'8cb4b545-fbb5-47e3-ad2c-df51072eef34','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:00',NULL,'CREATE','COMPLETE','trunk_net_one','0e647a4d-759a-49ac-b761-9b398b8c5e5e','state changed','OS::Neutron::Net',NULL,NULL),(566,'f7bd4b93-441a-4a14-87c4-41bfc65ea07e','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:00',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-257617379-trunk_subnet_one-ydotxquubtdx','state changed','OS::Neutron::Subnet',NULL,126),(567,'58034668-ec66-4fe2-8c37-6654dd830972','458e4ad4-3e9f-49c1-ac15-c57e9c25cd71','2025-11-29 08:00:00',NULL,'DELETE','COMPLETE','subnet','91fd259d-b775-47a8-bcc6-f4d11b41b053','state changed','OS::Neutron::Subnet',NULL,119),(568,'c9490f4b-0b06-425b-8e55-3077df270914','458e4ad4-3e9f-49c1-ac15-c57e9c25cd71','2025-11-29 08:00:00',NULL,'DELETE','IN_PROGRESS','net','bcee4ba6-9b15-4254-82ef-3456258509bb','state changed','OS::Neutron::Net',NULL,NULL),(569,'897cacfd-7354-4d6f-b25b-5a35e41a3d63','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:00',NULL,'CREATE','COMPLETE','parent_subnet','8c2a02df-21f8-481a-99fc-a3765e082911','state changed','OS::Neutron::Subnet',NULL,123),(570,'de0932d4-5072-4710-a7f0-80cc6aca69a9','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:01',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-257617379-parent_port-mydqs4tt2vyu','state changed','OS::Neutron::Port',NULL,127),(571,'b6d2524e-f692-46aa-bfe2-4b3d86b12aa5','458e4ad4-3e9f-49c1-ac15-c57e9c25cd71','2025-11-29 08:00:01',NULL,'DELETE','COMPLETE','net','bcee4ba6-9b15-4254-82ef-3456258509bb','state changed','OS::Neutron::Net',NULL,NULL),(572,'e6792686-dc29-4b2d-ab89-ae47a36ad82a','458e4ad4-3e9f-49c1-ac15-c57e9c25cd71','2025-11-29 08:00:01',NULL,'DELETE','COMPLETE','UpdateSubnetTest-250818380','458e4ad4-3e9f-49c1-ac15-c57e9c25cd71','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(573,'b5012fb7-25f1-4384-ac94-52ea6664040c','9cee4f59-6335-40cc-8093-c0eba2ae107d','2025-11-29 08:00:01',NULL,'CREATE','COMPLETE','subnet','8ce9ffd4-75b0-4665-b518-5fc71c65397a','state changed','OS::Neutron::Subnet',NULL,122),(574,'e0ad2e9c-db11-478b-abeb-3bdb452a2bbb','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:01',NULL,'CREATE','COMPLETE','sub_port_two','9c901efe-9c59-4e9d-a1d1-25ae63beae30','state changed','OS::Neutron::Port',NULL,125),(575,'9e39bbb8-e47b-4a41-b15e-2f397be15b32','9cee4f59-6335-40cc-8093-c0eba2ae107d','2025-11-29 08:00:01',NULL,'CREATE','IN_PROGRESS','server','multi_networks_swaps-server-enh7hze6wuhn','state changed','OS::Nova::Server',NULL,128),(576,'a95282a0-8be5-4f08-9e0a-96dceafc6408','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:02',NULL,'CREATE','COMPLETE','trunk_subnet_one','008c6789-9495-4a77-81ac-2d00624fc3c4','state changed','OS::Neutron::Subnet',NULL,126),(577,'9f18d1c7-ab70-4489-93a0-8339130130e8','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:02',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-257617379-sub_port_one-jq57x6voim4h','state changed','OS::Neutron::Port',NULL,129),(578,'fa9e555c-e632-4c95-8708-3ba8eb99daac','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:03',NULL,'CREATE','COMPLETE','parent_port','b7766a31-7cbe-4794-bbe2-f91fa11450dd','state changed','OS::Neutron::Port',NULL,127),(579,'69f51e85-925e-4d53-a20d-a384e221737c','c7292c71-5ac2-4517-8ed0-62e5105c2b9a','2025-11-29 08:00:03',NULL,'CREATE','IN_PROGRESS','StackEventsTest-1197403554','c7292c71-5ac2-4517-8ed0-62e5105c2b9a','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(580,'b7098168-2781-4122-a740-315401f998cc','c7292c71-5ac2-4517-8ed0-62e5105c2b9a','2025-11-29 08:00:03',NULL,'CREATE','IN_PROGRESS','test_resource','StackEventsTest-1197403554-test_resource-zfhwlcnhbhej','state changed','OS::Heat::TestResource',NULL,130),(581,'648d27e2-029b-408e-a928-033159aa4664','c7292c71-5ac2-4517-8ed0-62e5105c2b9a','2025-11-29 08:00:03',NULL,'CREATE','COMPLETE','test_resource','StackEventsTest-1197403554-test_resource-zfhwlcnhbhej','state changed','OS::Heat::TestResource',NULL,130),(582,'23fd33bf-adf0-4755-b149-2345c0f653d5','c7292c71-5ac2-4517-8ed0-62e5105c2b9a','2025-11-29 08:00:03',NULL,'CREATE','COMPLETE','StackEventsTest-1197403554','c7292c71-5ac2-4517-8ed0-62e5105c2b9a','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(583,'478fa523-5f1e-4325-9f20-f3c91c1f4c52','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:04',NULL,'CREATE','COMPLETE','sub_port_one','42f4e448-3a15-47f1-a7c7-fb45931ec399','state changed','OS::Neutron::Port',NULL,129),(584,'d771d294-73db-479e-9b13-8b880ab55b44','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:04',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-257617379-trunk-fun4kwushzgb','state changed','OS::Neutron::Trunk',NULL,131),(585,'f467a5ec-118e-421a-94f0-595e7944558f','e2ac62a4-74a0-43d6-ae5a-5d53783fa1e9','2025-11-29 08:00:05',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-1636516923','e2ac62a4-74a0-43d6-ae5a-5d53783fa1e9','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(586,'254f8a44-3df1-4957-a129-e9ca829e14b1','e2ac62a4-74a0-43d6-ae5a-5d53783fa1e9','2025-11-29 08:00:05',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-1636516923-net-vzgvlpmydvau','state changed','OS::Neutron::Net',NULL,NULL),(587,'82eb3785-92e8-420d-b836-4b9cda1b767f','c7292c71-5ac2-4517-8ed0-62e5105c2b9a','2025-11-29 08:00:06',NULL,'DELETE','IN_PROGRESS','StackEventsTest-1197403554','c7292c71-5ac2-4517-8ed0-62e5105c2b9a','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(588,'aea11f32-13b9-4f47-aaf9-ca89f855f7d2','c7292c71-5ac2-4517-8ed0-62e5105c2b9a','2025-11-29 08:00:06',NULL,'DELETE','IN_PROGRESS','test_resource','StackEventsTest-1197403554-test_resource-zfhwlcnhbhej','state changed','OS::Heat::TestResource',NULL,130),(589,'563ea9b5-a149-47de-b77a-5307d8abafb5','c7292c71-5ac2-4517-8ed0-62e5105c2b9a','2025-11-29 08:00:06',NULL,'DELETE','COMPLETE','test_resource','StackEventsTest-1197403554-test_resource-zfhwlcnhbhej','state changed','OS::Heat::TestResource',NULL,130),(590,'993f38fb-c860-4ad4-81c8-e0641135f38f','c7292c71-5ac2-4517-8ed0-62e5105c2b9a','2025-11-29 08:00:06',NULL,'DELETE','COMPLETE','StackEventsTest-1197403554','c7292c71-5ac2-4517-8ed0-62e5105c2b9a','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(591,'0d76f01d-6721-4591-9bfa-4bfee50d51bf','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:06',NULL,'CREATE','COMPLETE','trunk','234bcf50-2104-4ab4-8e7e-83e0a7a1e493','state changed','OS::Neutron::Trunk',NULL,131),(592,'3a40a3d0-b7d9-4a86-841b-edab0a9135cd','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:06',NULL,'CREATE','COMPLETE','UpdateTrunkTest-257617379','005aa58a-83a8-475d-b468-a4beaa77ca80','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(593,'807b9bf7-6a8f-4965-bbcd-ec0ef2de4d0b','e2ac62a4-74a0-43d6-ae5a-5d53783fa1e9','2025-11-29 08:00:06',NULL,'CREATE','COMPLETE','net','a2186685-9d10-4908-b1eb-cdea67d90867','state changed','OS::Neutron::Net',NULL,NULL),(594,'fc0d9bd4-54bc-4cc6-aea3-545d15745d8f','e2ac62a4-74a0-43d6-ae5a-5d53783fa1e9','2025-11-29 08:00:06',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-1636516923-subnet-fmh6xuuzrr5m','state changed','OS::Neutron::Subnet',NULL,132),(595,'b936d156-fd0a-4da3-822e-1ee16f61a810','e2ac62a4-74a0-43d6-ae5a-5d53783fa1e9','2025-11-29 08:00:08',NULL,'CREATE','COMPLETE','subnet','1f4e0b6f-7988-4dd1-b451-d10e5b70759e','state changed','OS::Neutron::Subnet',NULL,132),(596,'ec264e09-cc2b-48fc-b626-238de5e13f18','e2ac62a4-74a0-43d6-ae5a-5d53783fa1e9','2025-11-29 08:00:08',NULL,'CREATE','COMPLETE','UpdateSubnetTest-1636516923','e2ac62a4-74a0-43d6-ae5a-5d53783fa1e9','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(597,'1d8f3ae5-4120-4269-95ab-8d37f5bbb5a1','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:11',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-257617379','005aa58a-83a8-475d-b468-a4beaa77ca80','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(598,'477b560e-7be8-4a44-9688-f296ef497e7e','e2ac62a4-74a0-43d6-ae5a-5d53783fa1e9','2025-11-29 08:00:12',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-1636516923','e2ac62a4-74a0-43d6-ae5a-5d53783fa1e9','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(599,'c64b1c04-a730-48be-9930-b2c610fefe52','e2ac62a4-74a0-43d6-ae5a-5d53783fa1e9','2025-11-29 08:00:12',NULL,'UPDATE','IN_PROGRESS','subnet','1f4e0b6f-7988-4dd1-b451-d10e5b70759e','state changed','OS::Neutron::Subnet',NULL,132),(600,'577db762-be0e-4524-8964-3589dd0491fd','0b2e59b1-173b-4a56-a882-9e4c4db3910b','2025-11-29 08:00:13',NULL,'CREATE','IN_PROGRESS','TemplateAPITest-787184066','0b2e59b1-173b-4a56-a882-9e4c4db3910b','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(601,'1b08997a-cd9b-48cb-ae02-b823485394c9','0b2e59b1-173b-4a56-a882-9e4c4db3910b','2025-11-29 08:00:13',NULL,'CREATE','IN_PROGRESS','test1','TemplateAPITest-787184066-test1-rjzy3a3yxduh','state changed','OS::Heat::TestResource',NULL,134),(602,'7236bd09-f89f-407c-892b-3b5431408dac','0b2e59b1-173b-4a56-a882-9e4c4db3910b','2025-11-29 08:00:13',NULL,'CREATE','COMPLETE','test1','TemplateAPITest-787184066-test1-rjzy3a3yxduh','state changed','OS::Heat::TestResource',NULL,134),(603,'57507525-17bf-4074-a96f-bce21001f892','0b2e59b1-173b-4a56-a882-9e4c4db3910b','2025-11-29 08:00:13',NULL,'CREATE','COMPLETE','TemplateAPITest-787184066','0b2e59b1-173b-4a56-a882-9e4c4db3910b','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(604,'c27e5101-c244-47dd-97df-ca6eb3e4b525','e2ac62a4-74a0-43d6-ae5a-5d53783fa1e9','2025-11-29 08:00:13',NULL,'UPDATE','COMPLETE','subnet','1f4e0b6f-7988-4dd1-b451-d10e5b70759e','state changed','OS::Neutron::Subnet',NULL,135),(605,'85fa0158-e8da-408f-97f5-d2b98a288174','e2ac62a4-74a0-43d6-ae5a-5d53783fa1e9','2025-11-29 08:00:13',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-1636516923','e2ac62a4-74a0-43d6-ae5a-5d53783fa1e9','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(606,'8e45880f-b747-42a0-bcc3-974b36b93b93','0b2e59b1-173b-4a56-a882-9e4c4db3910b','2025-11-29 08:00:13',NULL,'DELETE','IN_PROGRESS','TemplateAPITest-787184066','0b2e59b1-173b-4a56-a882-9e4c4db3910b','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(607,'d595a7f2-963d-47d7-b225-443cefea6b19','0b2e59b1-173b-4a56-a882-9e4c4db3910b','2025-11-29 08:00:13',NULL,'DELETE','IN_PROGRESS','test1','TemplateAPITest-787184066-test1-rjzy3a3yxduh','state changed','OS::Heat::TestResource',NULL,134),(608,'734fb0cb-f157-4f82-8108-a34856bc9117','0b2e59b1-173b-4a56-a882-9e4c4db3910b','2025-11-29 08:00:13',NULL,'DELETE','COMPLETE','test1','TemplateAPITest-787184066-test1-rjzy3a3yxduh','state changed','OS::Heat::TestResource',NULL,134),(609,'5dc7f676-1e16-49c4-9c84-aaa425d05c14','0b2e59b1-173b-4a56-a882-9e4c4db3910b','2025-11-29 08:00:13',NULL,'DELETE','COMPLETE','TemplateAPITest-787184066','0b2e59b1-173b-4a56-a882-9e4c4db3910b','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(610,'dab503e3-ee0c-4211-ba56-0fac75606b7c','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:15',NULL,'UPDATE','IN_PROGRESS','trunk','234bcf50-2104-4ab4-8e7e-83e0a7a1e493','state changed','OS::Neutron::Trunk',NULL,131),(611,'aadfe33c-0280-46b9-a080-9b335ce99bad','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:17',NULL,'UPDATE','COMPLETE','trunk','234bcf50-2104-4ab4-8e7e-83e0a7a1e493','state changed','OS::Neutron::Trunk',NULL,136),(612,'ee64f0a9-32a9-48c9-bce3-be2e733770d9','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:17',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-257617379','005aa58a-83a8-475d-b468-a4beaa77ca80','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(613,'270081a0-aa4b-47fa-a672-c2f8ba5840e7','e2ac62a4-74a0-43d6-ae5a-5d53783fa1e9','2025-11-29 08:00:17',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-1636516923','e2ac62a4-74a0-43d6-ae5a-5d53783fa1e9','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(614,'1c8d488f-e6cb-4184-a01b-21eebf37126c','e2ac62a4-74a0-43d6-ae5a-5d53783fa1e9','2025-11-29 08:00:17',NULL,'DELETE','IN_PROGRESS','subnet','1f4e0b6f-7988-4dd1-b451-d10e5b70759e','state changed','OS::Neutron::Subnet',NULL,135),(615,'07a4eceb-6529-4514-9e16-e11be9956b31','e2ac62a4-74a0-43d6-ae5a-5d53783fa1e9','2025-11-29 08:00:18',NULL,'DELETE','COMPLETE','subnet','1f4e0b6f-7988-4dd1-b451-d10e5b70759e','state changed','OS::Neutron::Subnet',NULL,135),(616,'253f714e-44e2-465f-9c6a-fb1999c33c6c','e2ac62a4-74a0-43d6-ae5a-5d53783fa1e9','2025-11-29 08:00:18',NULL,'DELETE','IN_PROGRESS','net','a2186685-9d10-4908-b1eb-cdea67d90867','state changed','OS::Neutron::Net',NULL,NULL),(617,'eef99289-5046-4cb0-a7e7-af63705b734c','e2ac62a4-74a0-43d6-ae5a-5d53783fa1e9','2025-11-29 08:00:19',NULL,'DELETE','COMPLETE','net','a2186685-9d10-4908-b1eb-cdea67d90867','state changed','OS::Neutron::Net',NULL,NULL),(618,'7ef3b419-ca17-4a84-a44b-db6747312f8c','e2ac62a4-74a0-43d6-ae5a-5d53783fa1e9','2025-11-29 08:00:19',NULL,'DELETE','COMPLETE','UpdateSubnetTest-1636516923','e2ac62a4-74a0-43d6-ae5a-5d53783fa1e9','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(619,'e37d7a4e-1740-418f-955b-2febc70ff92f','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:20',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-257617379','005aa58a-83a8-475d-b468-a4beaa77ca80','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(620,'036a86d2-6c31-4647-bbc3-c3549e6ebc44','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:21',NULL,'DELETE','IN_PROGRESS','sub_port_two','9c901efe-9c59-4e9d-a1d1-25ae63beae30','state changed','OS::Neutron::Port',NULL,125),(621,'92a34a6a-260d-4636-9c60-7a5e2a2c729c','7573bc9b-a079-43d5-acfa-c9aaca6b2af4','2025-11-29 08:00:21',NULL,'CREATE','IN_PROGRESS','RemoteDeeplyNestedStackTest-590817526','7573bc9b-a079-43d5-acfa-c9aaca6b2af4','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(622,'910de51a-8f74-4025-a115-b7b664094cd7','7573bc9b-a079-43d5-acfa-c9aaca6b2af4','2025-11-29 08:00:21',NULL,'CREATE','IN_PROGRESS','network_stack','RemoteDeeplyNestedStackTest-590817526-network_stack-h6cjldvbglxj','state changed','OS::Heat::Stack',NULL,139),(623,'00980bf7-7447-4b67-a2be-21f0950f5054','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:21',NULL,'DELETE','COMPLETE','sub_port_two','9c901efe-9c59-4e9d-a1d1-25ae63beae30','state changed','OS::Neutron::Port',NULL,125),(624,'7bf53a2b-fe3e-471e-a1ed-9571303a9e42','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:21',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','794acd55-19bb-45d2-bd99-b77daf45f065','state changed','OS::Neutron::Subnet',NULL,121),(625,'b674a322-6acc-4411-b469-84744b4df0b8','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:22',NULL,'DELETE','COMPLETE','trunk_subnet_two','794acd55-19bb-45d2-bd99-b77daf45f065','state changed','OS::Neutron::Subnet',NULL,121),(626,'e2a1b400-7902-4d25-ab69-957903ddea3c','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:22',NULL,'DELETE','IN_PROGRESS','trunk','234bcf50-2104-4ab4-8e7e-83e0a7a1e493','state changed','OS::Neutron::Trunk',NULL,136),(627,'a808d3ae-298f-4c6e-9e16-728a7984a933','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:22',NULL,'DELETE','IN_PROGRESS','trunk_net_two','73924a76-f881-4f1d-9f07-4d37f076b63e','state changed','OS::Neutron::Net',NULL,NULL),(628,'2e4457d7-d0dd-4115-881b-4424809f153b','a8489d3c-da0c-4695-94f0-89c1a5f1590d','2025-11-29 08:00:22',NULL,'CREATE','IN_PROGRESS','RemoteDeeplyNestedStackTest-590817526-network_stack-h6cjldvbglxj','a8489d3c-da0c-4695-94f0-89c1a5f1590d','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(629,'f00e9e93-3809-41c8-96d4-68f517f769e2','a8489d3c-da0c-4695-94f0-89c1a5f1590d','2025-11-29 08:00:22',NULL,'CREATE','IN_PROGRESS','network_stack_as_custom_type','RemoteDeeplyNestedStackTest-590817526-network_stack-h6cjldvbglxj-network_stack_as_custom_type-lo5ngz3peoma','state changed','file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml',NULL,140),(630,'d6bf43fe-882a-446c-adaa-ff64eccfb61c','2a51c847-a492-4d13-8a0c-c260b035c512','2025-11-29 08:00:22',NULL,'CREATE','IN_PROGRESS','RemoteDeeplyNestedStackTest-590817526-network_stack-h6cjldvbglxj-network_stack_as_custom_type-lo5ngz3peoma','2a51c847-a492-4d13-8a0c-c260b035c512','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(631,'775118f1-984b-43ca-b532-7f4c9d8c6d6d','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:22',NULL,'DELETE','COMPLETE','trunk','234bcf50-2104-4ab4-8e7e-83e0a7a1e493','state changed','OS::Neutron::Trunk',NULL,136),(632,'a30921ec-816c-49cf-90f4-85409bafea15','2a51c847-a492-4d13-8a0c-c260b035c512','2025-11-29 08:00:22',NULL,'CREATE','IN_PROGRESS','router','RemoteDeeplyNestedStackTest-590817526-network_stack-h6cjldvbglxj-network_stack_as_custom_type-lo5ngz3peoma-router-ik6ay4njic7t','state changed','OS::Neutron::Router',NULL,141),(633,'c12b2257-e192-44eb-8faa-3a887fd85d55','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:22',NULL,'DELETE','IN_PROGRESS','sub_port_one','42f4e448-3a15-47f1-a7c7-fb45931ec399','state changed','OS::Neutron::Port',NULL,129),(634,'417986b7-d63c-4d9f-93eb-c1affded99f8','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:22',NULL,'DELETE','IN_PROGRESS','parent_port','b7766a31-7cbe-4794-bbe2-f91fa11450dd','state changed','OS::Neutron::Port',NULL,127),(635,'a01ec520-1898-4241-a98a-51937119c02d','e15fb8cb-952a-4356-99c6-734790bc1027','2025-11-29 08:00:23',NULL,'CREATE','IN_PROGRESS','ExternalReferencesTest-1763834295','e15fb8cb-952a-4356-99c6-734790bc1027','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(636,'fee38361-1bfb-40a4-bd27-c21c7674409b','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:23',NULL,'DELETE','COMPLETE','trunk_net_two','73924a76-f881-4f1d-9f07-4d37f076b63e','state changed','OS::Neutron::Net',NULL,NULL),(637,'75518f07-c879-4aa0-90c5-a1d833782b58','e15fb8cb-952a-4356-99c6-734790bc1027','2025-11-29 08:00:23',NULL,'ADOPT','IN_PROGRESS','test1','ExternalReferencesTest-1763834295-test1-4d5hnflhhwfv','state changed','OS::Heat::TestResource',NULL,NULL),(638,'dceec23b-9129-4a2c-8c63-db70b0312714','e15fb8cb-952a-4356-99c6-734790bc1027','2025-11-29 08:00:23',NULL,'ADOPT','COMPLETE','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(639,'796e552c-50e7-4541-aef9-9c2e6d825d81','e15fb8cb-952a-4356-99c6-734790bc1027','2025-11-29 08:00:23',NULL,'CHECK','COMPLETE','test1','foobar','CHECK not supported for OS::Heat::TestResource','OS::Heat::TestResource',NULL,NULL),(640,'beba214f-609f-44e6-b018-31bee37e5ecc','e15fb8cb-952a-4356-99c6-734790bc1027','2025-11-29 08:00:23',NULL,'CREATE','COMPLETE','ExternalReferencesTest-1763834295','e15fb8cb-952a-4356-99c6-734790bc1027','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(641,'6aba1f19-02ed-4126-9daf-3e13a224711d','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:23',NULL,'DELETE','COMPLETE','parent_port','b7766a31-7cbe-4794-bbe2-f91fa11450dd','state changed','OS::Neutron::Port',NULL,127),(642,'91b03a57-085b-48f6-8338-536e41f538c3','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:23',NULL,'DELETE','IN_PROGRESS','parent_subnet','8c2a02df-21f8-481a-99fc-a3765e082911','state changed','OS::Neutron::Subnet',NULL,123),(643,'499c701c-4ad4-4c76-9a84-30c5302f418d','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:24',NULL,'DELETE','COMPLETE','sub_port_one','42f4e448-3a15-47f1-a7c7-fb45931ec399','state changed','OS::Neutron::Port',NULL,129),(644,'0c16becc-c3c9-4cb4-90d0-c9c9dc803b15','e15fb8cb-952a-4356-99c6-734790bc1027','2025-11-29 08:00:24',NULL,'DELETE','IN_PROGRESS','ExternalReferencesTest-1763834295','e15fb8cb-952a-4356-99c6-734790bc1027','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(645,'9ad68dc4-9f4b-45cd-9475-9e9d06a17cf4','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:24',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','008c6789-9495-4a77-81ac-2d00624fc3c4','state changed','OS::Neutron::Subnet',NULL,126),(646,'d158eeb3-a4d1-4f87-89c2-6f69fa5081f5','e15fb8cb-952a-4356-99c6-734790bc1027','2025-11-29 08:00:24',NULL,'DELETE','IN_PROGRESS','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(647,'9e91a5e1-2141-4f0b-b1c2-8ffaa38ef966','e15fb8cb-952a-4356-99c6-734790bc1027','2025-11-29 08:00:24',NULL,'DELETE','COMPLETE','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(648,'c57fad64-23a7-4101-a77b-14609d733435','e15fb8cb-952a-4356-99c6-734790bc1027','2025-11-29 08:00:24',NULL,'DELETE','COMPLETE','ExternalReferencesTest-1763834295','e15fb8cb-952a-4356-99c6-734790bc1027','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(649,'f1054278-6d7c-4452-aa46-4c233f53283c','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:24',NULL,'DELETE','COMPLETE','parent_subnet','8c2a02df-21f8-481a-99fc-a3765e082911','state changed','OS::Neutron::Subnet',NULL,123),(650,'939720b3-a355-4f36-9fac-bbcd5cff7635','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:25',NULL,'DELETE','IN_PROGRESS','parent_net','b0b40f24-465d-4777-b809-c36c792fffcf','state changed','OS::Neutron::Net',NULL,NULL),(651,'15ccbdfa-d4be-4c63-8dc7-6111a3f672d2','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:25',NULL,'DELETE','COMPLETE','trunk_subnet_one','008c6789-9495-4a77-81ac-2d00624fc3c4','state changed','OS::Neutron::Subnet',NULL,126),(652,'5d26e1ec-70b9-4e05-9da5-4dbf56d2b32b','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:25',NULL,'DELETE','IN_PROGRESS','trunk_net_one','0e647a4d-759a-49ac-b761-9b398b8c5e5e','state changed','OS::Neutron::Net',NULL,NULL),(653,'31661127-ceff-4f28-9843-841dd27ce552','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:26',NULL,'DELETE','COMPLETE','trunk_net_one','0e647a4d-759a-49ac-b761-9b398b8c5e5e','state changed','OS::Neutron::Net',NULL,NULL),(654,'c06f29bf-ffc7-48f5-99ac-9fb7f778f290','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:27',NULL,'DELETE','COMPLETE','parent_net','b0b40f24-465d-4777-b809-c36c792fffcf','state changed','OS::Neutron::Net',NULL,NULL),(655,'67094d6b-5c8a-4090-916e-5cfc2482859e','005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 08:00:27',NULL,'DELETE','COMPLETE','UpdateTrunkTest-257617379','005aa58a-83a8-475d-b468-a4beaa77ca80','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(656,'692e4c7e-f8ac-4395-a3e1-33413bbcad7f','2a51c847-a492-4d13-8a0c-c260b035c512','2025-11-29 08:00:27',NULL,'CREATE','COMPLETE','router','34d0aaa9-ff0c-4743-bab8-c60a9b5259ae','state changed','OS::Neutron::Router',NULL,141),(657,'2fdfaa39-0ed3-4e29-8633-542fb5b81854','2a51c847-a492-4d13-8a0c-c260b035c512','2025-11-29 08:00:27',NULL,'CREATE','COMPLETE','RemoteDeeplyNestedStackTest-590817526-network_stack-h6cjldvbglxj-network_stack_as_custom_type-lo5ngz3peoma','2a51c847-a492-4d13-8a0c-c260b035c512','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(658,'33690efe-0f75-45ce-8490-7efa8cd0cb12','a8489d3c-da0c-4695-94f0-89c1a5f1590d','2025-11-29 08:00:27',NULL,'CREATE','COMPLETE','network_stack_as_custom_type','2a51c847-a492-4d13-8a0c-c260b035c512','state changed','file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml',NULL,140),(659,'d4a50e9c-dcf6-47d1-a2a7-e33465f97dd2','a8489d3c-da0c-4695-94f0-89c1a5f1590d','2025-11-29 08:00:27',NULL,'CREATE','COMPLETE','RemoteDeeplyNestedStackTest-590817526-network_stack-h6cjldvbglxj','a8489d3c-da0c-4695-94f0-89c1a5f1590d','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(660,'651ff244-31a7-4b57-9054-f952d5b7ae1b','7573bc9b-a079-43d5-acfa-c9aaca6b2af4','2025-11-29 08:00:28',NULL,'CREATE','COMPLETE','network_stack','a8489d3c-da0c-4695-94f0-89c1a5f1590d','state changed','OS::Heat::Stack',NULL,139),(661,'a8d9ae3b-57ae-4ae6-9acd-f4917dd02a2a','7573bc9b-a079-43d5-acfa-c9aaca6b2af4','2025-11-29 08:00:29',NULL,'CREATE','COMPLETE','RemoteDeeplyNestedStackTest-590817526','7573bc9b-a079-43d5-acfa-c9aaca6b2af4','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(662,'4ce9359c-f6a1-4cc7-9aa9-110616bc317f','9cee4f59-6335-40cc-8093-c0eba2ae107d','2025-11-29 08:00:30',NULL,'CREATE','COMPLETE','server','612ba3af-21bf-4b06-bcbe-61eb4d9686d0','state changed','OS::Nova::Server',NULL,128),(663,'9129ee20-22af-4b9d-805d-dc651e91bd8a','9cee4f59-6335-40cc-8093-c0eba2ae107d','2025-11-29 08:00:30',NULL,'CREATE','COMPLETE','multi_networks_swaps','9cee4f59-6335-40cc-8093-c0eba2ae107d','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(664,'9c6c56ad-e341-4bb7-a80b-f7b0fb2f3016','7573bc9b-a079-43d5-acfa-c9aaca6b2af4','2025-11-29 08:00:30',NULL,'DELETE','IN_PROGRESS','RemoteDeeplyNestedStackTest-590817526','7573bc9b-a079-43d5-acfa-c9aaca6b2af4','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(665,'1329e1a4-6231-46f8-af39-5c86b74a7d91','7573bc9b-a079-43d5-acfa-c9aaca6b2af4','2025-11-29 08:00:30',NULL,'DELETE','IN_PROGRESS','network_stack','a8489d3c-da0c-4695-94f0-89c1a5f1590d','state changed','OS::Heat::Stack',NULL,139),(666,'4a43450d-3655-42f6-9043-ff6b23856166','7c917f8b-e89f-4e42-825a-4993a18791e1','2025-11-29 08:00:30',NULL,'CREATE','IN_PROGRESS','ExternalReferencesTest-1505818889','7c917f8b-e89f-4e42-825a-4993a18791e1','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(667,'5cf562e4-29b1-4fd0-be7a-f8071bd0b37b','7c917f8b-e89f-4e42-825a-4993a18791e1','2025-11-29 08:00:30',NULL,'ADOPT','IN_PROGRESS','test1','ExternalReferencesTest-1505818889-test1-bh5drr5eqfru','state changed','OS::Heat::TestResource',NULL,NULL),(668,'cbdcb00c-a594-4be8-99e0-fdbca8c41a28','7c917f8b-e89f-4e42-825a-4993a18791e1','2025-11-29 08:00:30',NULL,'ADOPT','COMPLETE','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(669,'557799eb-c912-4f89-b59c-52210a80f11c','7c917f8b-e89f-4e42-825a-4993a18791e1','2025-11-29 08:00:30',NULL,'CHECK','COMPLETE','test1','foobar','CHECK not supported for OS::Heat::TestResource','OS::Heat::TestResource',NULL,NULL),(670,'c4ac37b8-9118-4e27-a4a1-b601636ea66a','7c917f8b-e89f-4e42-825a-4993a18791e1','2025-11-29 08:00:30',NULL,'CREATE','COMPLETE','ExternalReferencesTest-1505818889','7c917f8b-e89f-4e42-825a-4993a18791e1','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(671,'71733155-c2b5-4210-8011-dcb000cac9c9','a8489d3c-da0c-4695-94f0-89c1a5f1590d','2025-11-29 08:00:30',NULL,'DELETE','IN_PROGRESS','RemoteDeeplyNestedStackTest-590817526-network_stack-h6cjldvbglxj','a8489d3c-da0c-4695-94f0-89c1a5f1590d','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(672,'ccf74960-c86f-43a1-a992-6b46f194d52b','a8489d3c-da0c-4695-94f0-89c1a5f1590d','2025-11-29 08:00:30',NULL,'DELETE','IN_PROGRESS','network_stack_as_custom_type','2a51c847-a492-4d13-8a0c-c260b035c512','state changed','file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml',NULL,140),(673,'5c9d254a-4ed2-4773-936c-71a6ad30a8ec','2a51c847-a492-4d13-8a0c-c260b035c512','2025-11-29 08:00:31',NULL,'DELETE','IN_PROGRESS','RemoteDeeplyNestedStackTest-590817526-network_stack-h6cjldvbglxj-network_stack_as_custom_type-lo5ngz3peoma','2a51c847-a492-4d13-8a0c-c260b035c512','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(674,'a9819dd4-e286-4530-96c7-eca700b4f546','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:31',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-1524320770','34b51a0f-aa59-4ac7-997e-84c19c3534c9','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(675,'ce9878a7-c8a4-4a75-abdf-5ce7b099b39d','2a51c847-a492-4d13-8a0c-c260b035c512','2025-11-29 08:00:31',NULL,'DELETE','IN_PROGRESS','router','34d0aaa9-ff0c-4743-bab8-c60a9b5259ae','state changed','OS::Neutron::Router',NULL,141),(676,'e46edd30-ae91-47a7-ae50-f9ccc6b75f85','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:31',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-1524320770-trunk_net_one-lzyz3o65m54t','state changed','OS::Neutron::Net',NULL,NULL),(677,'3c9d4648-e410-4387-a45b-12f5dd6a2527','7c917f8b-e89f-4e42-825a-4993a18791e1','2025-11-29 08:00:31',NULL,'UPDATE','IN_PROGRESS','ExternalReferencesTest-1505818889','7c917f8b-e89f-4e42-825a-4993a18791e1','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(678,'9ea79fd9-f9be-4450-87f9-7e2827e64ede','7c917f8b-e89f-4e42-825a-4993a18791e1','2025-11-29 08:00:32',NULL,'UPDATE','COMPLETE','ExternalReferencesTest-1505818889','7c917f8b-e89f-4e42-825a-4993a18791e1','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(679,'672cb5c7-db10-4ada-a642-e568f98c72ce','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:32',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-1524320770-parent_net-gql3ehnbw7t5','state changed','OS::Neutron::Net',NULL,NULL),(680,'0461d58f-9d2e-4a09-a0d1-1e032d21360e','2a51c847-a492-4d13-8a0c-c260b035c512','2025-11-29 08:00:33',NULL,'DELETE','COMPLETE','router','34d0aaa9-ff0c-4743-bab8-c60a9b5259ae','state changed','OS::Neutron::Router',NULL,141),(681,'621e29b7-e5ae-4d90-8e99-58ac1be73c49','2a51c847-a492-4d13-8a0c-c260b035c512','2025-11-29 08:00:33',NULL,'DELETE','COMPLETE','RemoteDeeplyNestedStackTest-590817526-network_stack-h6cjldvbglxj-network_stack_as_custom_type-lo5ngz3peoma','2a51c847-a492-4d13-8a0c-c260b035c512','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(682,'2410c7ba-07ba-442f-aad7-fbe00ccf07df','a8489d3c-da0c-4695-94f0-89c1a5f1590d','2025-11-29 08:00:34',NULL,'DELETE','COMPLETE','network_stack_as_custom_type','2a51c847-a492-4d13-8a0c-c260b035c512','state changed','file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml',NULL,140),(683,'e686f455-c49b-46c5-8f93-86019ed1f2f7','a8489d3c-da0c-4695-94f0-89c1a5f1590d','2025-11-29 08:00:35',NULL,'DELETE','COMPLETE','RemoteDeeplyNestedStackTest-590817526-network_stack-h6cjldvbglxj','a8489d3c-da0c-4695-94f0-89c1a5f1590d','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(684,'59be3811-2da3-4212-97ae-0d25d8451328','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:35',NULL,'CREATE','COMPLETE','trunk_net_one','6bbc9f83-8973-435b-ae39-482dd3c616c3','state changed','OS::Neutron::Net',NULL,NULL),(685,'4e8d0b7c-102a-4cd2-9046-bdfe5b358a9e','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:35',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-1524320770-trunk_net_two-yirbp5frlmze','state changed','OS::Neutron::Net',NULL,NULL),(686,'de8a7505-d8f6-4ea3-9f0a-7b8b72cf92eb','7573bc9b-a079-43d5-acfa-c9aaca6b2af4','2025-11-29 08:00:35',NULL,'DELETE','COMPLETE','network_stack','a8489d3c-da0c-4695-94f0-89c1a5f1590d','state changed','OS::Heat::Stack',NULL,139),(687,'1a25d916-0428-4f8f-9861-9276c71e27de','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:35',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-1524320770-trunk_subnet_one-joz7pibnalwr','state changed','OS::Neutron::Subnet',NULL,144),(688,'8f678919-b630-49f2-9607-00d870b59347','7573bc9b-a079-43d5-acfa-c9aaca6b2af4','2025-11-29 08:00:35',NULL,'DELETE','COMPLETE','RemoteDeeplyNestedStackTest-590817526','7573bc9b-a079-43d5-acfa-c9aaca6b2af4','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(689,'d3f56b8d-496a-40f8-9fe2-0e1fb6af387f','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:35',NULL,'CREATE','COMPLETE','parent_net','f67f2bde-04a1-468b-ba30-4801983f116a','state changed','OS::Neutron::Net',NULL,NULL),(690,'54a1b175-278e-417e-a6e1-9b9b69134a2e','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:35',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-1524320770-parent_subnet-4ay7scpoh3sj','state changed','OS::Neutron::Subnet',NULL,145),(691,'9e1bf038-dd76-41b9-95bd-aa61a504b7ba','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:36',NULL,'CREATE','COMPLETE','trunk_net_two','6c404bb7-55df-423f-9c18-256941fc490a','state changed','OS::Neutron::Net',NULL,NULL),(692,'03f31cce-fdd3-4412-91ca-baa18bdc7c44','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:36',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-1524320770-trunk_subnet_two-pnyh3dzyua24','state changed','OS::Neutron::Subnet',NULL,146),(693,'8f333efd-323f-4645-a380-20d26957f47d','7c917f8b-e89f-4e42-825a-4993a18791e1','2025-11-29 08:00:36',NULL,'DELETE','IN_PROGRESS','ExternalReferencesTest-1505818889','7c917f8b-e89f-4e42-825a-4993a18791e1','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(694,'545fb0f9-4b85-4a54-a297-ee4c19f409d0','7c917f8b-e89f-4e42-825a-4993a18791e1','2025-11-29 08:00:36',NULL,'DELETE','IN_PROGRESS','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(695,'e0ab2866-c3f5-4e76-ad76-bb7bd841801d','7c917f8b-e89f-4e42-825a-4993a18791e1','2025-11-29 08:00:36',NULL,'DELETE','COMPLETE','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(696,'fbe84d2c-4bd9-4e41-a9d1-733265760021','7c917f8b-e89f-4e42-825a-4993a18791e1','2025-11-29 08:00:37',NULL,'DELETE','COMPLETE','ExternalReferencesTest-1505818889','7c917f8b-e89f-4e42-825a-4993a18791e1','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(697,'4cf90a17-208f-4d2a-b20d-aa61f00b203a','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:37',NULL,'CREATE','COMPLETE','parent_subnet','7d63512f-527f-4f4e-9f65-8c16e065c861','state changed','OS::Neutron::Subnet',NULL,145),(698,'7f0b7ae8-25b2-4923-994d-7c55f308c0c9','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:37',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-1524320770-parent_port-lpnvdnae36wb','state changed','OS::Neutron::Port',NULL,147),(699,'406612b7-1a76-4502-871a-85cf7db2347f','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:37',NULL,'CREATE','COMPLETE','trunk_subnet_one','58877fb8-36fe-483e-b19d-069e9ba31a37','state changed','OS::Neutron::Subnet',NULL,144),(700,'8b887dac-8957-4c7d-9a87-0e954f5b5507','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:37',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-1524320770-sub_port_one-lnq4ukoiq4p4','state changed','OS::Neutron::Port',NULL,148),(701,'6588d146-bf9a-4ba2-9a1a-bd8f4cebcccc','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:39',NULL,'CREATE','COMPLETE','trunk_subnet_two','718ef02b-5bb2-4ef7-871b-63dc1ec39a4f','state changed','OS::Neutron::Subnet',NULL,146),(702,'3776c7e6-1c63-4972-9fbd-e83a69199ea7','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:39',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-1524320770-sub_port_two-ihm3vo56oeoc','state changed','OS::Neutron::Port',NULL,150),(703,'6e4c97d4-403d-46ec-8b11-c9f1eef54319','9cee4f59-6335-40cc-8093-c0eba2ae107d','2025-11-29 08:00:39',NULL,'UPDATE','IN_PROGRESS','multi_networks_swaps','9cee4f59-6335-40cc-8093-c0eba2ae107d','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(704,'98406460-efe5-4ca2-af8b-63881f36c49c','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:39',NULL,'CREATE','COMPLETE','parent_port','f87ed0d1-a82c-4e0f-a458-a35aed7b1849','state changed','OS::Neutron::Port',NULL,147),(705,'76f6401a-bd9f-40c1-8701-49a688b9758f','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:39',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-1524320770-trunk-ctwf4q7fvzpm','state changed','OS::Neutron::Trunk',NULL,151),(706,'a1b8d257-d3e6-40cf-bf06-6e6a0e642ec6','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:39',NULL,'CREATE','COMPLETE','sub_port_one','8cd767e0-1367-45de-a83a-42b196b547e3','state changed','OS::Neutron::Port',NULL,148),(707,'21513162-14da-40b7-a68e-3c008c3f6765','9cee4f59-6335-40cc-8093-c0eba2ae107d','2025-11-29 08:00:40',NULL,'UPDATE','IN_PROGRESS','server','612ba3af-21bf-4b06-bcbe-61eb4d9686d0','state changed','OS::Nova::Server',NULL,128),(708,'bbd08842-1de8-4e0c-a23b-7537bc034f2e','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:41',NULL,'CREATE','COMPLETE','trunk','1d89fc56-dd22-42b9-9690-a29e47054fc5','state changed','OS::Neutron::Trunk',NULL,151),(709,'85a9fb46-ebdb-49c3-bb04-d420c98f986a','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:41',NULL,'CREATE','COMPLETE','sub_port_two','5fed9303-0d66-46b0-a59b-d1a381221723','state changed','OS::Neutron::Port',NULL,150),(710,'131c838c-02e3-4464-a1e4-7f9ef6853491','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:41',NULL,'CREATE','COMPLETE','UpdateTrunkTest-1524320770','34b51a0f-aa59-4ac7-997e-84c19c3534c9','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(711,'a2368b87-55d6-47db-8efb-2df6bfd11fbf','28538b2e-fc2d-4892-9fdb-28f829b930fe','2025-11-29 08:00:43',NULL,'CREATE','IN_PROGRESS','ExternalReferencesTest-3189793','28538b2e-fc2d-4892-9fdb-28f829b930fe','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(712,'4ac100e6-a872-4b6a-8de7-50578bbe73d1','28538b2e-fc2d-4892-9fdb-28f829b930fe','2025-11-29 08:00:43',NULL,'CREATE','IN_PROGRESS','test1','ExternalReferencesTest-3189793-test1-eqvw74p752fp','state changed','OS::Heat::TestResource',NULL,NULL),(713,'4eaa4b18-0bff-49aa-9968-268b41507524','28538b2e-fc2d-4892-9fdb-28f829b930fe','2025-11-29 08:00:43',NULL,'CREATE','COMPLETE','test1','ExternalReferencesTest-3189793-test1-eqvw74p752fp','state changed','OS::Heat::TestResource',NULL,NULL),(714,'627c4a3a-3a53-4c11-8915-d2d05cf05337','28538b2e-fc2d-4892-9fdb-28f829b930fe','2025-11-29 08:00:43',NULL,'CREATE','COMPLETE','ExternalReferencesTest-3189793','28538b2e-fc2d-4892-9fdb-28f829b930fe','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(715,'b1002090-70da-4f18-b1a7-f49606ef55f0','28538b2e-fc2d-4892-9fdb-28f829b930fe','2025-11-29 08:00:45',NULL,'UPDATE','IN_PROGRESS','ExternalReferencesTest-3189793','28538b2e-fc2d-4892-9fdb-28f829b930fe','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(716,'6ae9f29b-52a8-4ed0-9f65-91a6ccbb6cb4','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:45',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-1524320770','34b51a0f-aa59-4ac7-997e-84c19c3534c9','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(717,'8f1a6be1-6fb3-4acc-ae64-640b570b9e8a','28538b2e-fc2d-4892-9fdb-28f829b930fe','2025-11-29 08:00:46',NULL,'UPDATE','FAILED','ExternalReferencesTest-3189793','28538b2e-fc2d-4892-9fdb-28f829b930fe','Resource UPDATE failed: NotSupported: resources.test1: Update to property external_id of test1 (OS::Heat::TestResource) is not supported.','OS::Heat::Stack',NULL,NULL),(718,'47193b9d-3eb5-457c-ae44-b5fc6602030d','9cee4f59-6335-40cc-8093-c0eba2ae107d','2025-11-29 08:00:49',NULL,'UPDATE','COMPLETE','server','612ba3af-21bf-4b06-bcbe-61eb4d9686d0','state changed','OS::Nova::Server',NULL,152),(719,'1f564c03-7277-4819-a2b3-4ac9bfa8222d','9cee4f59-6335-40cc-8093-c0eba2ae107d','2025-11-29 08:00:49',NULL,'UPDATE','COMPLETE','multi_networks_swaps','9cee4f59-6335-40cc-8093-c0eba2ae107d','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(720,'e9d6388b-8451-4712-9dc3-139bd52026e6','28538b2e-fc2d-4892-9fdb-28f829b930fe','2025-11-29 08:00:51',NULL,'DELETE','IN_PROGRESS','ExternalReferencesTest-3189793','28538b2e-fc2d-4892-9fdb-28f829b930fe','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(721,'edb5c82f-376e-41c9-ae53-ae5efcb90934','28538b2e-fc2d-4892-9fdb-28f829b930fe','2025-11-29 08:00:51',NULL,'DELETE','IN_PROGRESS','test1','ExternalReferencesTest-3189793-test1-eqvw74p752fp','state changed','OS::Heat::TestResource',NULL,NULL),(722,'4194dbc5-b3f3-4301-a394-af4d005fee7b','28538b2e-fc2d-4892-9fdb-28f829b930fe','2025-11-29 08:00:51',NULL,'DELETE','COMPLETE','test1','ExternalReferencesTest-3189793-test1-eqvw74p752fp','state changed','OS::Heat::TestResource',NULL,NULL),(723,'3d68fd9c-d8d7-4950-8eee-fd7e5b8e0e71','28538b2e-fc2d-4892-9fdb-28f829b930fe','2025-11-29 08:00:51',NULL,'DELETE','COMPLETE','ExternalReferencesTest-3189793','28538b2e-fc2d-4892-9fdb-28f829b930fe','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(724,'3a7d3cf4-ead1-40e8-b02d-c73695b85e4d','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:51',NULL,'UPDATE','IN_PROGRESS','trunk','1d89fc56-dd22-42b9-9690-a29e47054fc5','state changed','OS::Neutron::Trunk',NULL,151),(725,'3ccd4d08-145d-4b7a-b756-41174869a279','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:52',NULL,'UPDATE','COMPLETE','trunk','1d89fc56-dd22-42b9-9690-a29e47054fc5','state changed','OS::Neutron::Trunk',NULL,153),(726,'538d4357-3272-4b46-b92c-658134affe0c','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:53',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-1524320770','34b51a0f-aa59-4ac7-997e-84c19c3534c9','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(727,'f8bc14af-1bf7-424d-a918-2017378e8bfb','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:55',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-1524320770','34b51a0f-aa59-4ac7-997e-84c19c3534c9','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(728,'575bc4eb-7256-4c38-8d35-9640e4b95fc1','9cee4f59-6335-40cc-8093-c0eba2ae107d','2025-11-29 08:00:56',NULL,'DELETE','IN_PROGRESS','multi_networks_swaps','9cee4f59-6335-40cc-8093-c0eba2ae107d','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(729,'d4ca43ba-bc0c-4dcc-8e5c-c93120b07e39','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:56',NULL,'DELETE','IN_PROGRESS','sub_port_one','8cd767e0-1367-45de-a83a-42b196b547e3','state changed','OS::Neutron::Port',NULL,148),(730,'2ac098ae-f7de-4be5-ae5e-d7bc915ca3d6','9cee4f59-6335-40cc-8093-c0eba2ae107d','2025-11-29 08:00:56',NULL,'DELETE','IN_PROGRESS','server','612ba3af-21bf-4b06-bcbe-61eb4d9686d0','state changed','OS::Nova::Server',NULL,152),(731,'0a66780e-060f-4337-8305-42cd88640ad2','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:57',NULL,'DELETE','IN_PROGRESS','trunk','1d89fc56-dd22-42b9-9690-a29e47054fc5','state changed','OS::Neutron::Trunk',NULL,153),(732,'62cbcfd0-43c8-4648-8c4b-95a55c05d63e','aad9a5e1-c157-4fa7-9577-fda46dada9c7','2025-11-29 08:00:57',NULL,'CREATE','IN_PROGRESS','HooksTest-942067710','aad9a5e1-c157-4fa7-9577-fda46dada9c7','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(733,'a66904e4-239b-4744-93e0-0c4d626a06c0','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:57',NULL,'DELETE','COMPLETE','sub_port_one','8cd767e0-1367-45de-a83a-42b196b547e3','state changed','OS::Neutron::Port',NULL,148),(734,'19126abb-16fc-416f-9e31-3a2936a7eae3','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:57',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','58877fb8-36fe-483e-b19d-069e9ba31a37','state changed','OS::Neutron::Subnet',NULL,144),(735,'5a899ed3-9e94-42cb-b62e-1487a1ce5fa6','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:57',NULL,'DELETE','COMPLETE','trunk','1d89fc56-dd22-42b9-9690-a29e47054fc5','state changed','OS::Neutron::Trunk',NULL,153),(736,'d39b4a75-c83b-440e-8023-3b09064a15a8','aad9a5e1-c157-4fa7-9577-fda46dada9c7','2025-11-29 08:00:57',NULL,'CREATE','IN_PROGRESS','foo_step1','HooksTest-942067710-foo_step1-hrmimszpz7l3','state changed','OS::Heat::RandomString',NULL,NULL),(737,'d68c1972-587d-43e0-94cb-0b9af5925d6b','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:57',NULL,'DELETE','IN_PROGRESS','parent_port','f87ed0d1-a82c-4e0f-a458-a35aed7b1849','state changed','OS::Neutron::Port',NULL,147),(738,'8e246c3e-55af-400d-8cad-7ebfd3d7fcd6','aad9a5e1-c157-4fa7-9577-fda46dada9c7','2025-11-29 08:00:58',NULL,'CREATE','COMPLETE','foo_step1','HooksTest-942067710-foo_step1-hrmimszpz7l3','state changed','OS::Heat::RandomString',NULL,NULL),(739,'0451a11d-ce8a-486a-a221-e463915222b1','aad9a5e1-c157-4fa7-9577-fda46dada9c7','2025-11-29 08:00:58',NULL,'INIT','COMPLETE','foo_step2',NULL,'CREATE paused until Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(740,'d25c966c-9849-437d-a36d-4e0f498c59ca','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:58',NULL,'DELETE','IN_PROGRESS','sub_port_two','5fed9303-0d66-46b0-a59b-d1a381221723','state changed','OS::Neutron::Port',NULL,150),(741,'8f5113af-7e47-462d-87b8-c05cc1206826','aad9a5e1-c157-4fa7-9577-fda46dada9c7','2025-11-29 08:00:59',NULL,'INIT','COMPLETE','foo_step2',NULL,'Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(742,'944639a6-936e-4c81-9f7d-d59ef7abf6d0','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:59',NULL,'DELETE','COMPLETE','trunk_subnet_one','58877fb8-36fe-483e-b19d-069e9ba31a37','state changed','OS::Neutron::Subnet',NULL,144),(743,'bfe3234d-8ac8-42a0-a72b-429d9a6e680a','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:59',NULL,'DELETE','IN_PROGRESS','trunk_net_one','6bbc9f83-8973-435b-ae39-482dd3c616c3','state changed','OS::Neutron::Net',NULL,NULL),(744,'db8f9b35-69c2-4f2e-8e57-8d17b966d1d5','aad9a5e1-c157-4fa7-9577-fda46dada9c7','2025-11-29 08:00:59',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-942067710-foo_step2-24xjcbb6kgoh','state changed','OS::Heat::RandomString',NULL,NULL),(745,'ed6baf95-84eb-41c0-8571-199143b23e98','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:59',NULL,'DELETE','COMPLETE','parent_port','f87ed0d1-a82c-4e0f-a458-a35aed7b1849','state changed','OS::Neutron::Port',NULL,147),(746,'195c89b6-233f-4f2c-8b82-45b88ee62931','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:59',NULL,'DELETE','IN_PROGRESS','parent_subnet','7d63512f-527f-4f4e-9f65-8c16e065c861','state changed','OS::Neutron::Subnet',NULL,145),(747,'00092d81-07e9-4167-8e3c-92da019e9bdf','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:59',NULL,'DELETE','COMPLETE','sub_port_two','5fed9303-0d66-46b0-a59b-d1a381221723','state changed','OS::Neutron::Port',NULL,150),(748,'0d4c2c07-5b64-4cc5-aba6-30310d42e337','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:59',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','718ef02b-5bb2-4ef7-871b-63dc1ec39a4f','state changed','OS::Neutron::Subnet',NULL,146),(749,'01f366ee-f0b3-423f-8156-e9860a07a2e3','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:59',NULL,'DELETE','COMPLETE','parent_subnet','7d63512f-527f-4f4e-9f65-8c16e065c861','state changed','OS::Neutron::Subnet',NULL,145),(750,'5d9fa7cb-653b-49dc-8e89-9e0e38b7c41f','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:59',NULL,'DELETE','IN_PROGRESS','parent_net','f67f2bde-04a1-468b-ba30-4801983f116a','state changed','OS::Neutron::Net',NULL,NULL),(751,'aa930bc5-aeee-4abe-9bc8-7d77a19c52cf','aad9a5e1-c157-4fa7-9577-fda46dada9c7','2025-11-29 08:01:00',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-942067710-foo_step2-24xjcbb6kgoh','state changed','OS::Heat::RandomString',NULL,NULL),(752,'3edd6554-bddf-42ca-856e-43e001ab4745','aad9a5e1-c157-4fa7-9577-fda46dada9c7','2025-11-29 08:01:00',NULL,'CREATE','IN_PROGRESS','foo_step3','HooksTest-942067710-foo_step3-p7tecomnjl27','state changed','OS::Heat::RandomString',NULL,NULL),(753,'beebebf3-e280-4dd9-acfc-3da294906c56','aad9a5e1-c157-4fa7-9577-fda46dada9c7','2025-11-29 08:01:00',NULL,'CREATE','COMPLETE','foo_step3','HooksTest-942067710-foo_step3-p7tecomnjl27','state changed','OS::Heat::RandomString',NULL,NULL),(754,'db08b4f9-20e8-4d3d-a929-67874c27548f','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:01:00',NULL,'DELETE','COMPLETE','trunk_subnet_two','718ef02b-5bb2-4ef7-871b-63dc1ec39a4f','state changed','OS::Neutron::Subnet',NULL,146),(755,'60c851ee-7dd5-43bb-9928-62333ce6f0cf','aad9a5e1-c157-4fa7-9577-fda46dada9c7','2025-11-29 08:01:00',NULL,'CREATE','COMPLETE','HooksTest-942067710','aad9a5e1-c157-4fa7-9577-fda46dada9c7','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(756,'276998a0-1f21-4bb1-a933-6b67a8a71243','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:01:00',NULL,'DELETE','IN_PROGRESS','trunk_net_two','6c404bb7-55df-423f-9c18-256941fc490a','state changed','OS::Neutron::Net',NULL,NULL),(757,'261ff7b5-8440-4227-9c4e-1593a5555283','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:01:00',NULL,'DELETE','COMPLETE','parent_net','f67f2bde-04a1-468b-ba30-4801983f116a','state changed','OS::Neutron::Net',NULL,NULL),(758,'09ec4b58-0074-4dc9-9139-751c63be3040','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:01:00',NULL,'DELETE','COMPLETE','trunk_net_one','6bbc9f83-8973-435b-ae39-482dd3c616c3','state changed','OS::Neutron::Net',NULL,NULL),(759,'6859bebe-38a2-438e-bda9-0a6df97a7419','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:01:01',NULL,'DELETE','COMPLETE','trunk_net_two','6c404bb7-55df-423f-9c18-256941fc490a','state changed','OS::Neutron::Net',NULL,NULL),(760,'b8fc47cc-e950-46a6-9007-220dbaecdded','34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:01:01',NULL,'DELETE','COMPLETE','UpdateTrunkTest-1524320770','34b51a0f-aa59-4ac7-997e-84c19c3534c9','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(761,'3e3f4eb6-e3b4-4fdb-b9f9-f66cb81fdebb','9cee4f59-6335-40cc-8093-c0eba2ae107d','2025-11-29 08:01:02',NULL,'DELETE','COMPLETE','server','612ba3af-21bf-4b06-bcbe-61eb4d9686d0','state changed','OS::Nova::Server',NULL,152),(762,'0d46b96b-1731-4858-bb3a-c49976a1b58b','9cee4f59-6335-40cc-8093-c0eba2ae107d','2025-11-29 08:01:02',NULL,'DELETE','IN_PROGRESS','subnet','8ce9ffd4-75b0-4665-b518-5fc71c65397a','state changed','OS::Neutron::Subnet',NULL,122),(763,'46d07f41-3af2-4ff4-a3d6-b333cc16cb58','9cee4f59-6335-40cc-8093-c0eba2ae107d','2025-11-29 08:01:03',NULL,'DELETE','COMPLETE','subnet','8ce9ffd4-75b0-4665-b518-5fc71c65397a','state changed','OS::Neutron::Subnet',NULL,122),(764,'e594f5ea-5ccb-4efc-98a5-678b9c8d6e1d','9cee4f59-6335-40cc-8093-c0eba2ae107d','2025-11-29 08:01:03',NULL,'DELETE','IN_PROGRESS','net','7d9230f5-9cad-4dd3-8785-36e7a0e4b56a','state changed','OS::Neutron::Net',NULL,120),(765,'0ce7abc1-778f-4389-9c13-51724e457105','aad9a5e1-c157-4fa7-9577-fda46dada9c7','2025-11-29 08:01:03',NULL,'DELETE','IN_PROGRESS','HooksTest-942067710','aad9a5e1-c157-4fa7-9577-fda46dada9c7','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(766,'d736a4bd-0eba-40b8-89f0-b176295314db','aad9a5e1-c157-4fa7-9577-fda46dada9c7','2025-11-29 08:01:03',NULL,'DELETE','IN_PROGRESS','foo_step3','HooksTest-942067710-foo_step3-p7tecomnjl27','state changed','OS::Heat::RandomString',NULL,NULL),(767,'82f9ad49-d7b8-46cc-b706-acd351e6ae5d','aad9a5e1-c157-4fa7-9577-fda46dada9c7','2025-11-29 08:01:03',NULL,'DELETE','COMPLETE','foo_step3','HooksTest-942067710-foo_step3-p7tecomnjl27','state changed','OS::Heat::RandomString',NULL,NULL),(768,'1a29b507-f805-4ec0-af46-eaface9dd187','9cee4f59-6335-40cc-8093-c0eba2ae107d','2025-11-29 08:01:03',NULL,'DELETE','COMPLETE','net','7d9230f5-9cad-4dd3-8785-36e7a0e4b56a','state changed','OS::Neutron::Net',NULL,120),(769,'4100f373-e2df-40ec-b7e2-c291acba727f','9cee4f59-6335-40cc-8093-c0eba2ae107d','2025-11-29 08:01:04',NULL,'DELETE','COMPLETE','multi_networks_swaps','9cee4f59-6335-40cc-8093-c0eba2ae107d','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(770,'93681db5-cb68-418b-8ac0-4c6cf96a1574','aad9a5e1-c157-4fa7-9577-fda46dada9c7','2025-11-29 08:01:04',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-942067710-foo_step2-24xjcbb6kgoh','state changed','OS::Heat::RandomString',NULL,NULL),(771,'97fac995-c01a-4a3a-9aa2-12c07895968a','aad9a5e1-c157-4fa7-9577-fda46dada9c7','2025-11-29 08:01:04',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-942067710-foo_step2-24xjcbb6kgoh','state changed','OS::Heat::RandomString',NULL,NULL),(772,'2fda7154-91da-4852-a2c4-2d6f17486d48','aad9a5e1-c157-4fa7-9577-fda46dada9c7','2025-11-29 08:01:04',NULL,'DELETE','IN_PROGRESS','foo_step1','HooksTest-942067710-foo_step1-hrmimszpz7l3','state changed','OS::Heat::RandomString',NULL,NULL),(773,'31e4043a-53be-4de8-bb80-9db8213870ed','aad9a5e1-c157-4fa7-9577-fda46dada9c7','2025-11-29 08:01:04',NULL,'DELETE','COMPLETE','foo_step1','HooksTest-942067710-foo_step1-hrmimszpz7l3','state changed','OS::Heat::RandomString',NULL,NULL),(774,'7d0d5538-5b7a-4c44-8bc3-954e9b1fe575','aad9a5e1-c157-4fa7-9577-fda46dada9c7','2025-11-29 08:01:04',NULL,'DELETE','COMPLETE','HooksTest-942067710','aad9a5e1-c157-4fa7-9577-fda46dada9c7','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(775,'2116aafd-49a4-4e9e-9723-1e85ea170f64','6feca314-ec55-4854-a063-be3c6552dc5a','2025-11-29 08:01:08',NULL,'CREATE','IN_PROGRESS','EncryptedParametersTest-2023578631','6feca314-ec55-4854-a063-be3c6552dc5a','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(776,'c49f274b-f821-42a5-a500-b693d31d0de9','6feca314-ec55-4854-a063-be3c6552dc5a','2025-11-29 08:01:08',NULL,'CREATE','IN_PROGRESS','server_with_encrypted_property','En-578631-server_with_encrypted_property-4jm7gggvfu7f','state changed','OS::Nova::Server',NULL,156),(777,'89298838-d00d-4882-95ab-c544a64783bd','47110e56-7d1b-47ca-b283-659fa4ecfb42','2025-11-29 08:01:08',NULL,'CREATE','IN_PROGRESS','swap_network_port','47110e56-7d1b-47ca-b283-659fa4ecfb42','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(778,'856830a7-3d64-4928-81a3-9ae307e1772f','47110e56-7d1b-47ca-b283-659fa4ecfb42','2025-11-29 08:01:08',NULL,'CREATE','IN_PROGRESS','net','swap_network_port-net-2de7hosapo6u','state changed','OS::Neutron::Net',NULL,157),(779,'40d12248-d821-4c87-b529-cebff2395819','34a136a2-4dec-4c42-a2f4-7dab8a647c6a','2025-11-29 08:01:10',NULL,'CREATE','IN_PROGRESS','HooksTest-896880678','34a136a2-4dec-4c42-a2f4-7dab8a647c6a','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(780,'7f8c6ff6-4571-45dd-bd49-b119d78c7fa3','34a136a2-4dec-4c42-a2f4-7dab8a647c6a','2025-11-29 08:01:10',NULL,'CREATE','IN_PROGRESS','nested','HooksTest-896880678-nested-gcbypquwdphv','state changed','nested.yaml',NULL,NULL),(781,'66e37c5b-a303-40e9-8905-d40260b48f38','92d9fced-5a7d-4f8a-820c-edcd55826d81','2025-11-29 08:01:10',NULL,'CREATE','IN_PROGRESS','HooksTest-896880678-nested-gcbypquwdphv','92d9fced-5a7d-4f8a-820c-edcd55826d81','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(782,'1b52a1f8-5d42-464b-819a-6bc0d9691b8e','92d9fced-5a7d-4f8a-820c-edcd55826d81','2025-11-29 08:01:10',NULL,'CREATE','IN_PROGRESS','foo_step1','HooksTest-896880678-nested-gcbypquwdphv-foo_step1-7spgbnjlbs3e','state changed','OS::Heat::RandomString',NULL,NULL),(783,'650ea739-6a5e-45de-80d1-536b1f2345e9','92d9fced-5a7d-4f8a-820c-edcd55826d81','2025-11-29 08:01:10',NULL,'CREATE','COMPLETE','foo_step1','HooksTest-896880678-nested-gcbypquwdphv-foo_step1-7spgbnjlbs3e','state changed','OS::Heat::RandomString',NULL,NULL),(784,'be8b7e22-977e-407f-a03d-a4a1de7f2665','92d9fced-5a7d-4f8a-820c-edcd55826d81','2025-11-29 08:01:10',NULL,'INIT','COMPLETE','foo_step2',NULL,'CREATE paused until Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(785,'e6c0ffec-791a-48ff-b50f-43c9e35f404c','47110e56-7d1b-47ca-b283-659fa4ecfb42','2025-11-29 08:01:10',NULL,'CREATE','COMPLETE','net','66890a39-54ff-40bb-b39d-49fb504b2286','state changed','OS::Neutron::Net',NULL,157),(786,'1118dc49-d2ab-4b88-a2ed-af636bab6627','47110e56-7d1b-47ca-b283-659fa4ecfb42','2025-11-29 08:01:10',NULL,'CREATE','IN_PROGRESS','subnet','swap_network_port-subnet-uc2gmwwjwuzz','state changed','OS::Neutron::Subnet',NULL,158),(787,'101cfaf7-5dce-415d-9854-9c7d82de48d5','47110e56-7d1b-47ca-b283-659fa4ecfb42','2025-11-29 08:01:13',NULL,'CREATE','COMPLETE','subnet','5de8fe18-cfc0-4bf6-8cd5-9c71c919599b','state changed','OS::Neutron::Subnet',NULL,158),(788,'594d02fd-48c7-4319-8b07-1eaae9a99d30','47110e56-7d1b-47ca-b283-659fa4ecfb42','2025-11-29 08:01:13',NULL,'CREATE','IN_PROGRESS','server','swap_network_port-server-e2k4yyz5s2qi','state changed','OS::Nova::Server',NULL,159),(789,'d4a51bde-be1b-4963-a70e-4ff8f061db15','92d9fced-5a7d-4f8a-820c-edcd55826d81','2025-11-29 08:01:15',NULL,'INIT','COMPLETE','foo_step2',NULL,'Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(790,'11144111-cf09-44fd-accb-b6ddc4a53992','92d9fced-5a7d-4f8a-820c-edcd55826d81','2025-11-29 08:01:15',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-896880678-nested-gcbypquwdphv-foo_step2-peuxsrnukcq5','state changed','OS::Heat::RandomString',NULL,NULL),(791,'91f1a5ca-b7f0-4929-b4da-5ba99be98718','92d9fced-5a7d-4f8a-820c-edcd55826d81','2025-11-29 08:01:16',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-896880678-nested-gcbypquwdphv-foo_step2-peuxsrnukcq5','state changed','OS::Heat::RandomString',NULL,NULL),(792,'1a0dc945-d3a5-472a-9821-9e133ef1023a','92d9fced-5a7d-4f8a-820c-edcd55826d81','2025-11-29 08:01:17',NULL,'CREATE','IN_PROGRESS','foo_step3','HooksTest-896880678-nested-gcbypquwdphv-foo_step3-jywosjbqi3oe','state changed','OS::Heat::RandomString',NULL,NULL),(793,'9b20dd80-2281-4968-9c55-1cdcc1246e6b','92d9fced-5a7d-4f8a-820c-edcd55826d81','2025-11-29 08:01:17',NULL,'CREATE','COMPLETE','foo_step3','HooksTest-896880678-nested-gcbypquwdphv-foo_step3-jywosjbqi3oe','state changed','OS::Heat::RandomString',NULL,NULL),(794,'e0c25bb0-3765-4e25-9ff1-559139f53f16','92d9fced-5a7d-4f8a-820c-edcd55826d81','2025-11-29 08:01:17',NULL,'CREATE','COMPLETE','HooksTest-896880678-nested-gcbypquwdphv','92d9fced-5a7d-4f8a-820c-edcd55826d81','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(795,'600d1d0e-f5e9-4f81-a490-820a92dbf279','34a136a2-4dec-4c42-a2f4-7dab8a647c6a','2025-11-29 08:01:17',NULL,'CREATE','COMPLETE','nested','92d9fced-5a7d-4f8a-820c-edcd55826d81','state changed','nested.yaml',NULL,NULL),(796,'9947bc1b-cf70-4a00-a46b-2f8d4ec43d73','34a136a2-4dec-4c42-a2f4-7dab8a647c6a','2025-11-29 08:01:17',NULL,'CREATE','COMPLETE','HooksTest-896880678','34a136a2-4dec-4c42-a2f4-7dab8a647c6a','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(797,'9d89b12d-1975-408c-b234-e9247c976b34','34a136a2-4dec-4c42-a2f4-7dab8a647c6a','2025-11-29 08:01:20',NULL,'DELETE','IN_PROGRESS','HooksTest-896880678','34a136a2-4dec-4c42-a2f4-7dab8a647c6a','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(798,'c45f8fb2-773a-44fb-ad3d-e8e00e1c9e3b','34a136a2-4dec-4c42-a2f4-7dab8a647c6a','2025-11-29 08:01:20',NULL,'DELETE','IN_PROGRESS','nested','92d9fced-5a7d-4f8a-820c-edcd55826d81','state changed','nested.yaml',NULL,NULL),(799,'3c3fe0e0-f072-4ba8-ae40-8f6786a1f720','92d9fced-5a7d-4f8a-820c-edcd55826d81','2025-11-29 08:01:20',NULL,'DELETE','IN_PROGRESS','HooksTest-896880678-nested-gcbypquwdphv','92d9fced-5a7d-4f8a-820c-edcd55826d81','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(800,'73361764-1cf6-4359-82f9-9bdc58d4bc78','92d9fced-5a7d-4f8a-820c-edcd55826d81','2025-11-29 08:01:20',NULL,'DELETE','IN_PROGRESS','foo_step3','HooksTest-896880678-nested-gcbypquwdphv-foo_step3-jywosjbqi3oe','state changed','OS::Heat::RandomString',NULL,NULL),(801,'469bd293-4f53-47dd-a597-caf16ebe24dc','92d9fced-5a7d-4f8a-820c-edcd55826d81','2025-11-29 08:01:20',NULL,'DELETE','COMPLETE','foo_step3','HooksTest-896880678-nested-gcbypquwdphv-foo_step3-jywosjbqi3oe','state changed','OS::Heat::RandomString',NULL,NULL),(802,'6150e27c-5c54-4258-a1ed-163b89a8c52b','92d9fced-5a7d-4f8a-820c-edcd55826d81','2025-11-29 08:01:20',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-896880678-nested-gcbypquwdphv-foo_step2-peuxsrnukcq5','state changed','OS::Heat::RandomString',NULL,NULL),(803,'73192f08-0b9c-4046-a0cf-b815cdd937dd','92d9fced-5a7d-4f8a-820c-edcd55826d81','2025-11-29 08:01:20',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-896880678-nested-gcbypquwdphv-foo_step2-peuxsrnukcq5','state changed','OS::Heat::RandomString',NULL,NULL),(804,'76e62f25-f8fe-4e22-b238-fead1d250bce','92d9fced-5a7d-4f8a-820c-edcd55826d81','2025-11-29 08:01:20',NULL,'DELETE','IN_PROGRESS','foo_step1','HooksTest-896880678-nested-gcbypquwdphv-foo_step1-7spgbnjlbs3e','state changed','OS::Heat::RandomString',NULL,NULL),(805,'73b00d86-16ef-4026-9bb7-e54dc6d0ee10','92d9fced-5a7d-4f8a-820c-edcd55826d81','2025-11-29 08:01:21',NULL,'DELETE','COMPLETE','foo_step1','HooksTest-896880678-nested-gcbypquwdphv-foo_step1-7spgbnjlbs3e','state changed','OS::Heat::RandomString',NULL,NULL),(806,'f373fd2e-1acb-47f6-bc86-8ab3aa95d7ac','92d9fced-5a7d-4f8a-820c-edcd55826d81','2025-11-29 08:01:21',NULL,'DELETE','COMPLETE','HooksTest-896880678-nested-gcbypquwdphv','92d9fced-5a7d-4f8a-820c-edcd55826d81','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(807,'e7b9806a-60e3-4308-9557-c4995c498d48','34a136a2-4dec-4c42-a2f4-7dab8a647c6a','2025-11-29 08:01:21',NULL,'DELETE','COMPLETE','nested','92d9fced-5a7d-4f8a-820c-edcd55826d81','state changed','nested.yaml',NULL,NULL),(808,'e5f06122-e1f6-46a7-a86e-a55a9a4fef54','34a136a2-4dec-4c42-a2f4-7dab8a647c6a','2025-11-29 08:01:21',NULL,'DELETE','COMPLETE','HooksTest-896880678','34a136a2-4dec-4c42-a2f4-7dab8a647c6a','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(809,'73fbe0ba-1d31-4078-8cfd-8ce3b04a550f','6feca314-ec55-4854-a063-be3c6552dc5a','2025-11-29 08:01:22',NULL,'CREATE','COMPLETE','server_with_encrypted_property','91d97315-5335-4ffc-9220-9b7644493a50','state changed','OS::Nova::Server',NULL,156),(810,'32cf3bdd-f9ba-4a38-9391-147a222775b5','6feca314-ec55-4854-a063-be3c6552dc5a','2025-11-29 08:01:22',NULL,'CREATE','COMPLETE','EncryptedParametersTest-2023578631','6feca314-ec55-4854-a063-be3c6552dc5a','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(811,'bcc1d254-9077-4e3d-869a-c85e6f1f4f15','47110e56-7d1b-47ca-b283-659fa4ecfb42','2025-11-29 08:01:25',NULL,'CREATE','COMPLETE','server','039ee2b3-56b6-4415-88f8-e80b3d9118fd','state changed','OS::Nova::Server',NULL,159),(812,'385e7c94-f95e-498c-ae30-6c6df8d348cf','47110e56-7d1b-47ca-b283-659fa4ecfb42','2025-11-29 08:01:25',NULL,'CREATE','COMPLETE','swap_network_port','47110e56-7d1b-47ca-b283-659fa4ecfb42','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(813,'5d1013ae-8f61-482d-948a-0d6ff62edf39','f642a646-a9f0-4eb5-99de-fb59bc81ca00','2025-11-29 08:01:26',NULL,'CREATE','IN_PROGRESS','HooksTest-780960166','f642a646-a9f0-4eb5-99de-fb59bc81ca00','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(814,'b10faefa-1986-463d-a2f7-0e3ca715b62e','f642a646-a9f0-4eb5-99de-fb59bc81ca00','2025-11-29 08:01:26',NULL,'INIT','COMPLETE','foo_step1',NULL,'CREATE paused until Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(815,'ce241b7b-f59c-43f5-a8e5-62897932c407','6feca314-ec55-4854-a063-be3c6552dc5a','2025-11-29 08:01:26',NULL,'DELETE','IN_PROGRESS','EncryptedParametersTest-2023578631','6feca314-ec55-4854-a063-be3c6552dc5a','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(816,'d956a3d9-e087-4615-8b13-d8d4efc5c9fd','6feca314-ec55-4854-a063-be3c6552dc5a','2025-11-29 08:01:26',NULL,'DELETE','IN_PROGRESS','server_with_encrypted_property','91d97315-5335-4ffc-9220-9b7644493a50','state changed','OS::Nova::Server',NULL,156),(817,'23e149c8-1eb3-4ae2-a2f9-2bc2fe554918','f642a646-a9f0-4eb5-99de-fb59bc81ca00','2025-11-29 08:01:27',NULL,'INIT','COMPLETE','foo_step1',NULL,'Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(818,'1cbdcb2c-96d0-4955-95ee-35953e591270','f642a646-a9f0-4eb5-99de-fb59bc81ca00','2025-11-29 08:01:27',NULL,'CREATE','IN_PROGRESS','foo_step1','HooksTest-780960166-foo_step1-ndaqo6rnh4qa','state changed','OS::Heat::RandomString',NULL,NULL),(819,'d8ae3ca0-d3bb-4c94-9cef-e18143901be9','f642a646-a9f0-4eb5-99de-fb59bc81ca00','2025-11-29 08:01:28',NULL,'CREATE','COMPLETE','foo_step1','HooksTest-780960166-foo_step1-ndaqo6rnh4qa','state changed','OS::Heat::RandomString',NULL,NULL),(820,'77a22f05-2485-4044-a106-7102d9a4537a','f642a646-a9f0-4eb5-99de-fb59bc81ca00','2025-11-29 08:01:28',NULL,'INIT','COMPLETE','foo_step2',NULL,'CREATE paused until Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(821,'cdf9dab8-24fa-4b94-ae5b-27cf5426833a','6feca314-ec55-4854-a063-be3c6552dc5a','2025-11-29 08:01:28',NULL,'DELETE','COMPLETE','server_with_encrypted_property','91d97315-5335-4ffc-9220-9b7644493a50','state changed','OS::Nova::Server',NULL,156),(822,'cb5f9b26-e4bf-4da2-b66b-a64e8a805718','6feca314-ec55-4854-a063-be3c6552dc5a','2025-11-29 08:01:28',NULL,'DELETE','COMPLETE','EncryptedParametersTest-2023578631','6feca314-ec55-4854-a063-be3c6552dc5a','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(823,'aa5c2b18-b1ef-43fe-955e-099847be8206','47110e56-7d1b-47ca-b283-659fa4ecfb42','2025-11-29 08:01:29',NULL,'UPDATE','IN_PROGRESS','swap_network_port','47110e56-7d1b-47ca-b283-659fa4ecfb42','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(824,'567426ae-5635-4a6c-83c8-e9ab9c638b0b','47110e56-7d1b-47ca-b283-659fa4ecfb42','2025-11-29 08:01:29',NULL,'UPDATE','IN_PROGRESS','server','039ee2b3-56b6-4415-88f8-e80b3d9118fd','state changed','OS::Nova::Server',NULL,159),(825,'9a9a2889-c660-4673-bd59-b6f342f0275f','f642a646-a9f0-4eb5-99de-fb59bc81ca00','2025-11-29 08:01:33',NULL,'INIT','COMPLETE','foo_step2',NULL,'Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(826,'bfa5d998-c12a-4673-9e77-cd1a82b3e582','f642a646-a9f0-4eb5-99de-fb59bc81ca00','2025-11-29 08:01:33',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-780960166-foo_step2-goilm6bumec7','state changed','OS::Heat::RandomString',NULL,NULL),(827,'6dffacfe-7f15-4e69-a57f-18ac024e2c53','f642a646-a9f0-4eb5-99de-fb59bc81ca00','2025-11-29 08:01:34',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-780960166-foo_step2-goilm6bumec7','state changed','OS::Heat::RandomString',NULL,NULL),(828,'215e0f7f-13a0-4daa-b332-276116f5e228','f642a646-a9f0-4eb5-99de-fb59bc81ca00','2025-11-29 08:01:34',NULL,'INIT','COMPLETE','foo_step3',NULL,'CREATE paused until Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(829,'cbcb92ab-6373-4429-a265-c82b9ba4bab5','47110e56-7d1b-47ca-b283-659fa4ecfb42','2025-11-29 08:01:35',NULL,'UPDATE','COMPLETE','server','039ee2b3-56b6-4415-88f8-e80b3d9118fd','state changed','OS::Nova::Server',NULL,161),(830,'99969e19-3d07-4145-a418-a79b096389ae','47110e56-7d1b-47ca-b283-659fa4ecfb42','2025-11-29 08:01:35',NULL,'UPDATE','COMPLETE','swap_network_port','47110e56-7d1b-47ca-b283-659fa4ecfb42','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(831,'37ed2e70-3153-4211-be04-20b0ca0d8709','975a3b9a-54d6-4846-bb6a-e9b8cdf2777b','2025-11-29 08:01:37',NULL,'CREATE','IN_PROGRESS','StackOutputsTest-1240581169','975a3b9a-54d6-4846-bb6a-e9b8cdf2777b','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(832,'59189eb8-d8a2-4537-a290-3d837fe299cd','975a3b9a-54d6-4846-bb6a-e9b8cdf2777b','2025-11-29 08:01:37',NULL,'CREATE','IN_PROGRESS','parent','StackOutputsTest-1240581169-parent-4mtpuurlr5sy','state changed','1.yaml',NULL,NULL),(833,'c17adf0a-bd11-4559-a9c8-7d6ad13d72b8','05ed0658-e749-4335-9f09-b3af57105e89','2025-11-29 08:01:37',NULL,'CREATE','IN_PROGRESS','StackOutputsTest-1240581169-parent-4mtpuurlr5sy','05ed0658-e749-4335-9f09-b3af57105e89','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(834,'47e624cc-4bcc-4610-b3de-5ee41d5f9619','05ed0658-e749-4335-9f09-b3af57105e89','2025-11-29 08:01:37',NULL,'CREATE','IN_PROGRESS','test_resource_a','StackOutputsTest-1240581169-parent-4mtpuurlr5sy-test_resource_a-fn4cvoworgyg','state changed','OS::Heat::TestResource',NULL,162),(835,'e5d587f1-a1d9-4792-952a-1fa000858d0d','05ed0658-e749-4335-9f09-b3af57105e89','2025-11-29 08:01:37',NULL,'CREATE','COMPLETE','test_resource_a','StackOutputsTest-1240581169-parent-4mtpuurlr5sy-test_resource_a-fn4cvoworgyg','state changed','OS::Heat::TestResource',NULL,162),(836,'c6668ab6-d36c-423a-a77c-3f321bf7d465','05ed0658-e749-4335-9f09-b3af57105e89','2025-11-29 08:01:38',NULL,'CREATE','IN_PROGRESS','test_resource_b','StackOutputsTest-1240581169-parent-4mtpuurlr5sy-test_resource_b-llp4onooqpuh','state changed','OS::Heat::TestResource',NULL,163),(837,'6b2fac90-6d59-4324-809c-f196a4d2005c','f642a646-a9f0-4eb5-99de-fb59bc81ca00','2025-11-29 08:01:39',NULL,'INIT','COMPLETE','foo_step3',NULL,'Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(838,'d9c33449-94b9-4d48-8acb-59aa0dd0dde4','05ed0658-e749-4335-9f09-b3af57105e89','2025-11-29 08:01:39',NULL,'CREATE','COMPLETE','test_resource_b','StackOutputsTest-1240581169-parent-4mtpuurlr5sy-test_resource_b-llp4onooqpuh','state changed','OS::Heat::TestResource',NULL,163),(839,'36768448-8c99-48c7-88ef-5edd6689f7b8','05ed0658-e749-4335-9f09-b3af57105e89','2025-11-29 08:01:39',NULL,'CREATE','COMPLETE','StackOutputsTest-1240581169-parent-4mtpuurlr5sy','05ed0658-e749-4335-9f09-b3af57105e89','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(840,'37975026-24e3-41e3-9b82-a4bbe1f45ba8','975a3b9a-54d6-4846-bb6a-e9b8cdf2777b','2025-11-29 08:01:39',NULL,'CREATE','COMPLETE','parent','05ed0658-e749-4335-9f09-b3af57105e89','state changed','1.yaml',NULL,NULL),(841,'9967ac50-504a-44d1-aa09-6446d9b06c19','f642a646-a9f0-4eb5-99de-fb59bc81ca00','2025-11-29 08:01:39',NULL,'CREATE','IN_PROGRESS','foo_step3','HooksTest-780960166-foo_step3-2h7nt2k6tlb2','state changed','OS::Heat::RandomString',NULL,NULL),(842,'7611c625-598b-4e11-9aed-6cccc9f43b8f','975a3b9a-54d6-4846-bb6a-e9b8cdf2777b','2025-11-29 08:01:39',NULL,'CREATE','COMPLETE','StackOutputsTest-1240581169','975a3b9a-54d6-4846-bb6a-e9b8cdf2777b','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(843,'2e652d7c-1ebc-4b2e-a470-c0692b858134','47110e56-7d1b-47ca-b283-659fa4ecfb42','2025-11-29 08:01:40',NULL,'DELETE','IN_PROGRESS','swap_network_port','47110e56-7d1b-47ca-b283-659fa4ecfb42','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(844,'15d953d0-9cae-4519-80ea-4e17d435e209','47110e56-7d1b-47ca-b283-659fa4ecfb42','2025-11-29 08:01:40',NULL,'DELETE','IN_PROGRESS','server','039ee2b3-56b6-4415-88f8-e80b3d9118fd','state changed','OS::Nova::Server',NULL,161),(845,'bbb8f9d8-4374-4723-911e-cdce9307b230','f642a646-a9f0-4eb5-99de-fb59bc81ca00','2025-11-29 08:01:40',NULL,'CREATE','COMPLETE','foo_step3','HooksTest-780960166-foo_step3-2h7nt2k6tlb2','state changed','OS::Heat::RandomString',NULL,NULL),(846,'225fa90c-054c-425b-8fcd-151acb864224','f642a646-a9f0-4eb5-99de-fb59bc81ca00','2025-11-29 08:01:40',NULL,'CREATE','COMPLETE','HooksTest-780960166','f642a646-a9f0-4eb5-99de-fb59bc81ca00','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(847,'1ff01f47-c131-4bb3-a20d-bf720545bc0a','47110e56-7d1b-47ca-b283-659fa4ecfb42','2025-11-29 08:01:42',NULL,'DELETE','COMPLETE','server','039ee2b3-56b6-4415-88f8-e80b3d9118fd','state changed','OS::Nova::Server',NULL,161),(848,'da54b194-cd8b-417d-b6c1-dd1f10c0e2e5','975a3b9a-54d6-4846-bb6a-e9b8cdf2777b','2025-11-29 08:01:42',NULL,'UPDATE','IN_PROGRESS','StackOutputsTest-1240581169','975a3b9a-54d6-4846-bb6a-e9b8cdf2777b','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(849,'fefc9201-1ee1-41aa-92f0-87e3cd318172','47110e56-7d1b-47ca-b283-659fa4ecfb42','2025-11-29 08:01:42',NULL,'DELETE','IN_PROGRESS','subnet','5de8fe18-cfc0-4bf6-8cd5-9c71c919599b','state changed','OS::Neutron::Subnet',NULL,158),(850,'e3f61925-745a-4561-a6d2-a64880d71b98','975a3b9a-54d6-4846-bb6a-e9b8cdf2777b','2025-11-29 08:01:42',NULL,'UPDATE','IN_PROGRESS','parent','05ed0658-e749-4335-9f09-b3af57105e89','state changed','1.yaml',NULL,NULL),(851,'6ef800ea-d9cc-4b2a-9f36-19aee398ae35','47110e56-7d1b-47ca-b283-659fa4ecfb42','2025-11-29 08:01:42',NULL,'DELETE','COMPLETE','subnet','5de8fe18-cfc0-4bf6-8cd5-9c71c919599b','state changed','OS::Neutron::Subnet',NULL,158),(852,'38b63bc4-531f-4834-8127-a37868bda518','47110e56-7d1b-47ca-b283-659fa4ecfb42','2025-11-29 08:01:42',NULL,'DELETE','IN_PROGRESS','net','66890a39-54ff-40bb-b39d-49fb504b2286','state changed','OS::Neutron::Net',NULL,157),(853,'b4b7eb46-d1ac-4df8-b653-9ebd23471e08','05ed0658-e749-4335-9f09-b3af57105e89','2025-11-29 08:01:42',NULL,'UPDATE','IN_PROGRESS','StackOutputsTest-1240581169-parent-4mtpuurlr5sy','05ed0658-e749-4335-9f09-b3af57105e89','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(854,'56a8c8d3-dbde-4639-965c-473d3b16e79d','47110e56-7d1b-47ca-b283-659fa4ecfb42','2025-11-29 08:01:43',NULL,'DELETE','COMPLETE','net','66890a39-54ff-40bb-b39d-49fb504b2286','state changed','OS::Neutron::Net',NULL,157),(855,'2b80642f-9e02-4cdd-aaf9-dd7f4e2fd2f0','47110e56-7d1b-47ca-b283-659fa4ecfb42','2025-11-29 08:01:43',NULL,'DELETE','COMPLETE','swap_network_port','47110e56-7d1b-47ca-b283-659fa4ecfb42','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(856,'4fa36385-2f3a-40ba-b3c4-d38708468c34','05ed0658-e749-4335-9f09-b3af57105e89','2025-11-29 08:01:44',NULL,'UPDATE','COMPLETE','StackOutputsTest-1240581169-parent-4mtpuurlr5sy','05ed0658-e749-4335-9f09-b3af57105e89','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(857,'4bf0f45c-7c06-41b6-b6c5-02d0146281e2','f642a646-a9f0-4eb5-99de-fb59bc81ca00','2025-11-29 08:01:44',NULL,'DELETE','IN_PROGRESS','HooksTest-780960166','f642a646-a9f0-4eb5-99de-fb59bc81ca00','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(858,'8ca2493e-216d-4c04-be8e-c3591e2f3e0d','f642a646-a9f0-4eb5-99de-fb59bc81ca00','2025-11-29 08:01:44',NULL,'DELETE','IN_PROGRESS','foo_step3','HooksTest-780960166-foo_step3-2h7nt2k6tlb2','state changed','OS::Heat::RandomString',NULL,NULL),(859,'98d10820-0705-4374-b06d-3923a4cc5fe1','f642a646-a9f0-4eb5-99de-fb59bc81ca00','2025-11-29 08:01:44',NULL,'DELETE','COMPLETE','foo_step3','HooksTest-780960166-foo_step3-2h7nt2k6tlb2','state changed','OS::Heat::RandomString',NULL,NULL),(860,'26295003-bc88-4906-be83-f2c74e1f8618','f642a646-a9f0-4eb5-99de-fb59bc81ca00','2025-11-29 08:01:44',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-780960166-foo_step2-goilm6bumec7','state changed','OS::Heat::RandomString',NULL,NULL),(861,'e67adb11-0333-44ed-9a5d-c2bb5833a464','f642a646-a9f0-4eb5-99de-fb59bc81ca00','2025-11-29 08:01:44',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-780960166-foo_step2-goilm6bumec7','state changed','OS::Heat::RandomString',NULL,NULL),(862,'36f98a94-b1a3-4c0c-bfff-3d3fa6183cc5','f642a646-a9f0-4eb5-99de-fb59bc81ca00','2025-11-29 08:01:44',NULL,'DELETE','IN_PROGRESS','foo_step1','HooksTest-780960166-foo_step1-ndaqo6rnh4qa','state changed','OS::Heat::RandomString',NULL,NULL),(863,'c4ea0e45-f971-4c03-9b11-1afbf0e62cfb','f642a646-a9f0-4eb5-99de-fb59bc81ca00','2025-11-29 08:01:44',NULL,'DELETE','COMPLETE','foo_step1','HooksTest-780960166-foo_step1-ndaqo6rnh4qa','state changed','OS::Heat::RandomString',NULL,NULL),(864,'ba2e8e19-d19a-41fb-8135-4abc811e825d','f642a646-a9f0-4eb5-99de-fb59bc81ca00','2025-11-29 08:01:44',NULL,'DELETE','COMPLETE','HooksTest-780960166','f642a646-a9f0-4eb5-99de-fb59bc81ca00','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(865,'446141ea-1f94-428d-9e99-916fbacd7158','975a3b9a-54d6-4846-bb6a-e9b8cdf2777b','2025-11-29 08:01:45',NULL,'UPDATE','COMPLETE','parent','05ed0658-e749-4335-9f09-b3af57105e89','state changed','1.yaml',NULL,NULL),(866,'9e6108a8-5d08-4375-95b9-5d60f2c4b50a','975a3b9a-54d6-4846-bb6a-e9b8cdf2777b','2025-11-29 08:01:45',NULL,'UPDATE','COMPLETE','StackOutputsTest-1240581169','975a3b9a-54d6-4846-bb6a-e9b8cdf2777b','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(867,'3c755744-da52-42bb-bf61-32f0274efe5a','7f13ebe3-acc2-4edf-9399-e87b2b7f132b','2025-11-29 08:01:46',NULL,'CREATE','IN_PROGRESS','swap_network_subnet','7f13ebe3-acc2-4edf-9399-e87b2b7f132b','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(868,'a5a04e4d-b21a-4421-a89d-617e3bb79b79','7f13ebe3-acc2-4edf-9399-e87b2b7f132b','2025-11-29 08:01:46',NULL,'CREATE','IN_PROGRESS','net','swap_network_subnet-net-7su4nndguyjt','state changed','OS::Neutron::Net',NULL,165),(869,'d921b275-f034-40e6-b95e-ff8c9e5dd102','975a3b9a-54d6-4846-bb6a-e9b8cdf2777b','2025-11-29 08:01:47',NULL,'DELETE','IN_PROGRESS','StackOutputsTest-1240581169','975a3b9a-54d6-4846-bb6a-e9b8cdf2777b','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(870,'91c25e22-2d05-4fb5-96c9-9c534b7c59dd','975a3b9a-54d6-4846-bb6a-e9b8cdf2777b','2025-11-29 08:01:47',NULL,'DELETE','IN_PROGRESS','parent','05ed0658-e749-4335-9f09-b3af57105e89','state changed','1.yaml',NULL,NULL),(871,'3bc63c22-5652-4a1d-a2f8-c6f15ebcd504','05ed0658-e749-4335-9f09-b3af57105e89','2025-11-29 08:01:47',NULL,'DELETE','IN_PROGRESS','StackOutputsTest-1240581169-parent-4mtpuurlr5sy','05ed0658-e749-4335-9f09-b3af57105e89','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(872,'001cec29-c151-4906-821a-190e531e18f3','05ed0658-e749-4335-9f09-b3af57105e89','2025-11-29 08:01:47',NULL,'DELETE','IN_PROGRESS','test_resource_a','StackOutputsTest-1240581169-parent-4mtpuurlr5sy-test_resource_a-fn4cvoworgyg','state changed','OS::Heat::TestResource',NULL,162),(873,'90f5d8ff-ac4c-47d2-9fdd-b680931e4bad','05ed0658-e749-4335-9f09-b3af57105e89','2025-11-29 08:01:47',NULL,'DELETE','COMPLETE','test_resource_a','StackOutputsTest-1240581169-parent-4mtpuurlr5sy-test_resource_a-fn4cvoworgyg','state changed','OS::Heat::TestResource',NULL,162),(874,'8563b055-15ac-4e26-9855-78de8ad93b5c','7f13ebe3-acc2-4edf-9399-e87b2b7f132b','2025-11-29 08:01:47',NULL,'CREATE','COMPLETE','net','78106bbb-0777-483c-94c8-14e24cb421fc','state changed','OS::Neutron::Net',NULL,165),(875,'9645e07e-1e0d-4470-a1f9-2a3f8eb84f49','7f13ebe3-acc2-4edf-9399-e87b2b7f132b','2025-11-29 08:01:47',NULL,'CREATE','IN_PROGRESS','subnet','swap_network_subnet-subnet-2vitykhuczog','state changed','OS::Neutron::Subnet',NULL,167),(876,'e73f6cdf-afa7-4a5c-b541-0ec1948be2d2','05ed0658-e749-4335-9f09-b3af57105e89','2025-11-29 08:01:48',NULL,'DELETE','IN_PROGRESS','test_resource_b','StackOutputsTest-1240581169-parent-4mtpuurlr5sy-test_resource_b-llp4onooqpuh','state changed','OS::Heat::TestResource',NULL,163),(877,'6e3fad72-9533-4610-946e-a4f6896ca55c','05ed0658-e749-4335-9f09-b3af57105e89','2025-11-29 08:01:48',NULL,'DELETE','COMPLETE','test_resource_b','StackOutputsTest-1240581169-parent-4mtpuurlr5sy-test_resource_b-llp4onooqpuh','state changed','OS::Heat::TestResource',NULL,163),(878,'54b1f91b-60de-446c-a9bf-84755dffc1ac','05ed0658-e749-4335-9f09-b3af57105e89','2025-11-29 08:01:48',NULL,'DELETE','COMPLETE','StackOutputsTest-1240581169-parent-4mtpuurlr5sy','05ed0658-e749-4335-9f09-b3af57105e89','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(879,'211d9373-f284-4d5b-8243-9c89656ca580','7f13ebe3-acc2-4edf-9399-e87b2b7f132b','2025-11-29 08:01:48',NULL,'CREATE','COMPLETE','subnet','09e64cdc-d97b-4b61-bbfb-8d46b750f595','state changed','OS::Neutron::Subnet',NULL,167),(880,'20de6150-b548-4091-9370-4d067e984ad4','7f13ebe3-acc2-4edf-9399-e87b2b7f132b','2025-11-29 08:01:48',NULL,'CREATE','IN_PROGRESS','server','swap_network_subnet-server-ifqrrky2yysm','state changed','OS::Nova::Server',NULL,168),(881,'aad1bebe-4130-4314-85f0-c76ae535e1f7','975a3b9a-54d6-4846-bb6a-e9b8cdf2777b','2025-11-29 08:01:49',NULL,'DELETE','COMPLETE','parent','05ed0658-e749-4335-9f09-b3af57105e89','state changed','1.yaml',NULL,NULL),(882,'054dc2a8-fa6c-4280-91eb-59bc0ea32738','975a3b9a-54d6-4846-bb6a-e9b8cdf2777b','2025-11-29 08:01:49',NULL,'DELETE','COMPLETE','StackOutputsTest-1240581169','975a3b9a-54d6-4846-bb6a-e9b8cdf2777b','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(883,'a2cf37de-1136-4fd9-8517-d89c67aecd2d','99378704-0dba-4b64-8474-42e06567dd4e','2025-11-29 08:01:49',NULL,'CREATE','IN_PROGRESS','HooksTest-126905259','99378704-0dba-4b64-8474-42e06567dd4e','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(884,'ab83e618-6fcc-4d8f-a51f-d2cfd702452c','99378704-0dba-4b64-8474-42e06567dd4e','2025-11-29 08:01:49',NULL,'CREATE','IN_PROGRESS','rg','HooksTest-126905259-rg-upgc3i2awrcm','state changed','OS::Heat::ResourceGroup',NULL,169),(885,'a6d52cfb-98cc-4826-ac08-70359a5a8fc0','df2ab267-c8a3-4489-bcbf-7af01cc1bf36','2025-11-29 08:01:49',NULL,'CREATE','IN_PROGRESS','HooksTest-126905259-rg-upgc3i2awrcm','df2ab267-c8a3-4489-bcbf-7af01cc1bf36','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(886,'d5503f3e-dc43-4b04-b5e0-a9731c8435a0','df2ab267-c8a3-4489-bcbf-7af01cc1bf36','2025-11-29 08:01:49',NULL,'CREATE','IN_PROGRESS','0','HooksTest-126905259-rg-upgc3i2awrcm-0-tf34skcpquuy','state changed','OS::Heat::RandomString',NULL,NULL),(887,'df7fa808-5d7a-4cfe-85c1-4eef3fb339d6','df2ab267-c8a3-4489-bcbf-7af01cc1bf36','2025-11-29 08:01:50',NULL,'CREATE','COMPLETE','0','HooksTest-126905259-rg-upgc3i2awrcm-0-tf34skcpquuy','state changed','OS::Heat::RandomString',NULL,NULL),(888,'ce48a4d7-7f20-41ec-ad5b-8b0d1743a528','df2ab267-c8a3-4489-bcbf-7af01cc1bf36','2025-11-29 08:01:50',NULL,'CREATE','COMPLETE','HooksTest-126905259-rg-upgc3i2awrcm','df2ab267-c8a3-4489-bcbf-7af01cc1bf36','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(889,'d8989570-545e-48f1-adf9-bad24bc3d6a1','99378704-0dba-4b64-8474-42e06567dd4e','2025-11-29 08:01:50',NULL,'CREATE','COMPLETE','rg','df2ab267-c8a3-4489-bcbf-7af01cc1bf36','state changed','OS::Heat::ResourceGroup',NULL,169),(890,'91b1c48f-502c-47bf-8f0b-14fc9dd1ac26','99378704-0dba-4b64-8474-42e06567dd4e','2025-11-29 08:01:50',NULL,'CREATE','COMPLETE','HooksTest-126905259','99378704-0dba-4b64-8474-42e06567dd4e','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(891,'3aea7cd4-3d78-4dd9-bc4e-ee7e7f889654','86996ebc-96ab-4e82-9014-1fa7251ebbac','2025-11-29 08:01:53',NULL,'CREATE','IN_PROGRESS','StackOutputsTest-1052649082','86996ebc-96ab-4e82-9014-1fa7251ebbac','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(892,'8aac3328-a8dd-48ba-beea-c5ee8f039b64','86996ebc-96ab-4e82-9014-1fa7251ebbac','2025-11-29 08:01:54',NULL,'CREATE','IN_PROGRESS','test_resource_b','StackOutputsTest-1052649082-test_resource_b-ssfe23gdncm6','state changed','OS::Heat::TestResource',NULL,170),(893,'3fc4b063-b402-4969-b58d-562f2a556dfd','86996ebc-96ab-4e82-9014-1fa7251ebbac','2025-11-29 08:01:54',NULL,'CREATE','COMPLETE','test_resource_b','StackOutputsTest-1052649082-test_resource_b-ssfe23gdncm6','state changed','OS::Heat::TestResource',NULL,170),(894,'576e0ff7-c0b8-46ba-9360-b29a59ab4016','86996ebc-96ab-4e82-9014-1fa7251ebbac','2025-11-29 08:01:55',NULL,'CREATE','IN_PROGRESS','test_resource_a','StackOutputsTest-1052649082-test_resource_a-kumijditlx53','state changed','OS::Heat::TestResource',NULL,171),(895,'081a1b12-83fb-4c29-a39a-3f08617b7542','99378704-0dba-4b64-8474-42e06567dd4e','2025-11-29 08:01:55',NULL,'UPDATE','IN_PROGRESS','HooksTest-126905259','99378704-0dba-4b64-8474-42e06567dd4e','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(896,'697b5043-2fe2-49e9-83c0-1337a313ef60','86996ebc-96ab-4e82-9014-1fa7251ebbac','2025-11-29 08:01:56',NULL,'CREATE','COMPLETE','test_resource_a','StackOutputsTest-1052649082-test_resource_a-kumijditlx53','state changed','OS::Heat::TestResource',NULL,171),(897,'d44a180b-52af-42bf-a498-38c3b6906c81','99378704-0dba-4b64-8474-42e06567dd4e','2025-11-29 08:01:56',NULL,'CREATE','COMPLETE','rg','df2ab267-c8a3-4489-bcbf-7af01cc1bf36','UPDATE paused until Hook pre-update is cleared','OS::Heat::ResourceGroup',NULL,169),(898,'57d1c5f1-0967-403c-a67d-e7a8c1f1a820','86996ebc-96ab-4e82-9014-1fa7251ebbac','2025-11-29 08:01:56',NULL,'CREATE','COMPLETE','StackOutputsTest-1052649082','86996ebc-96ab-4e82-9014-1fa7251ebbac','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(899,'94dd6416-69a1-45f3-9174-38315057179a','99378704-0dba-4b64-8474-42e06567dd4e','2025-11-29 08:01:57',NULL,'CREATE','COMPLETE','rg','df2ab267-c8a3-4489-bcbf-7af01cc1bf36','Hook pre-update is cleared','OS::Heat::ResourceGroup',NULL,169),(900,'9b5b103f-076e-45eb-ab13-edcad7d2d5c3','99378704-0dba-4b64-8474-42e06567dd4e','2025-11-29 08:01:57',NULL,'UPDATE','IN_PROGRESS','rg','df2ab267-c8a3-4489-bcbf-7af01cc1bf36','state changed','OS::Heat::ResourceGroup',NULL,169),(901,'5b275082-b18b-483c-a577-defdc5094593','df2ab267-c8a3-4489-bcbf-7af01cc1bf36','2025-11-29 08:01:58',NULL,'UPDATE','IN_PROGRESS','HooksTest-126905259-rg-upgc3i2awrcm','df2ab267-c8a3-4489-bcbf-7af01cc1bf36','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(902,'fe78e079-9edb-47ca-a082-3936d1734fe6','df2ab267-c8a3-4489-bcbf-7af01cc1bf36','2025-11-29 08:02:00',NULL,'CREATE','IN_PROGRESS','1','HooksTest-126905259-rg-upgc3i2awrcm-1-ahg3qtifb5ci','state changed','OS::Heat::RandomString',NULL,NULL),(903,'78982e56-cd06-41df-8034-ae91849d4609','df2ab267-c8a3-4489-bcbf-7af01cc1bf36','2025-11-29 08:02:00',NULL,'CREATE','COMPLETE','1','HooksTest-126905259-rg-upgc3i2awrcm-1-ahg3qtifb5ci','state changed','OS::Heat::RandomString',NULL,NULL),(904,'ea751bb4-505e-46c9-9233-96a9934cb146','df2ab267-c8a3-4489-bcbf-7af01cc1bf36','2025-11-29 08:02:00',NULL,'UPDATE','COMPLETE','HooksTest-126905259-rg-upgc3i2awrcm','df2ab267-c8a3-4489-bcbf-7af01cc1bf36','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(905,'9a2f01e9-8af9-4f6c-b884-2d2dfbcb361b','86996ebc-96ab-4e82-9014-1fa7251ebbac','2025-11-29 08:02:01',NULL,'DELETE','IN_PROGRESS','StackOutputsTest-1052649082','86996ebc-96ab-4e82-9014-1fa7251ebbac','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(906,'cd03fa98-6d06-42cf-92f1-f29f478c56b1','86996ebc-96ab-4e82-9014-1fa7251ebbac','2025-11-29 08:02:01',NULL,'DELETE','IN_PROGRESS','test_resource_b','StackOutputsTest-1052649082-test_resource_b-ssfe23gdncm6','state changed','OS::Heat::TestResource',NULL,170),(907,'b72b0664-c4ba-4c07-b3cd-7c2a9f5e3b87','86996ebc-96ab-4e82-9014-1fa7251ebbac','2025-11-29 08:02:01',NULL,'DELETE','COMPLETE','test_resource_b','StackOutputsTest-1052649082-test_resource_b-ssfe23gdncm6','state changed','OS::Heat::TestResource',NULL,170),(908,'076afd71-c8dc-4173-9569-7410ce0fafeb','99378704-0dba-4b64-8474-42e06567dd4e','2025-11-29 08:02:02',NULL,'UPDATE','COMPLETE','rg','df2ab267-c8a3-4489-bcbf-7af01cc1bf36','state changed','OS::Heat::ResourceGroup',NULL,172),(909,'3e1fa741-a6c8-49be-aa6d-1f5653d42747','99378704-0dba-4b64-8474-42e06567dd4e','2025-11-29 08:02:02',NULL,'UPDATE','COMPLETE','HooksTest-126905259','99378704-0dba-4b64-8474-42e06567dd4e','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(910,'76d9f9be-9f62-4581-b299-1244370377b1','86996ebc-96ab-4e82-9014-1fa7251ebbac','2025-11-29 08:02:02',NULL,'DELETE','IN_PROGRESS','test_resource_a','StackOutputsTest-1052649082-test_resource_a-kumijditlx53','state changed','OS::Heat::TestResource',NULL,171),(911,'7cab675a-4e8e-471e-afd2-d8b8aa0c2a80','86996ebc-96ab-4e82-9014-1fa7251ebbac','2025-11-29 08:02:02',NULL,'DELETE','COMPLETE','test_resource_a','StackOutputsTest-1052649082-test_resource_a-kumijditlx53','state changed','OS::Heat::TestResource',NULL,171),(912,'928581e0-6e7b-49cc-86cf-7be3b5e5c05a','86996ebc-96ab-4e82-9014-1fa7251ebbac','2025-11-29 08:02:02',NULL,'DELETE','COMPLETE','StackOutputsTest-1052649082','86996ebc-96ab-4e82-9014-1fa7251ebbac','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(913,'2513e87f-958c-40e4-95ae-59c303e0767a','7f13ebe3-acc2-4edf-9399-e87b2b7f132b','2025-11-29 08:02:03',NULL,'CREATE','COMPLETE','server','5e9e4b2f-410e-45b6-9bd8-605eb6e92230','state changed','OS::Nova::Server',NULL,168),(914,'57ab474a-dba1-44ba-98dd-4b3b0e3edc4c','7f13ebe3-acc2-4edf-9399-e87b2b7f132b','2025-11-29 08:02:03',NULL,'CREATE','COMPLETE','swap_network_subnet','7f13ebe3-acc2-4edf-9399-e87b2b7f132b','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(915,'9cf07dd5-3627-4851-8f31-6647172a2c31','7f13ebe3-acc2-4edf-9399-e87b2b7f132b','2025-11-29 08:02:06',NULL,'UPDATE','IN_PROGRESS','swap_network_subnet','7f13ebe3-acc2-4edf-9399-e87b2b7f132b','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(916,'56ae3c3e-f1e5-42f6-95a6-b340b1635ea4','99378704-0dba-4b64-8474-42e06567dd4e','2025-11-29 08:02:07',NULL,'DELETE','IN_PROGRESS','HooksTest-126905259','99378704-0dba-4b64-8474-42e06567dd4e','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(917,'f5596e06-25b5-4d2e-88a3-23ff2749d57e','99378704-0dba-4b64-8474-42e06567dd4e','2025-11-29 08:02:07',NULL,'DELETE','IN_PROGRESS','rg','df2ab267-c8a3-4489-bcbf-7af01cc1bf36','state changed','OS::Heat::ResourceGroup',NULL,172),(918,'d7ff46d5-84b4-4def-97f9-d45c84c75d60','df2ab267-c8a3-4489-bcbf-7af01cc1bf36','2025-11-29 08:02:07',NULL,'DELETE','IN_PROGRESS','HooksTest-126905259-rg-upgc3i2awrcm','df2ab267-c8a3-4489-bcbf-7af01cc1bf36','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(919,'387d7bda-38a4-448f-a00d-fe7794e7e0b1','df2ab267-c8a3-4489-bcbf-7af01cc1bf36','2025-11-29 08:02:07',NULL,'DELETE','IN_PROGRESS','1','HooksTest-126905259-rg-upgc3i2awrcm-1-ahg3qtifb5ci','state changed','OS::Heat::RandomString',NULL,NULL),(920,'de61d786-e6ad-49fc-934b-ffb46f21b996','c4615851-66cd-4eed-ad47-c6036dfa3d06','2025-11-29 08:02:07',NULL,'CREATE','IN_PROGRESS','StackOutputsTest-1596412490','c4615851-66cd-4eed-ad47-c6036dfa3d06','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(921,'53dcb1d5-df93-4d36-a7fe-2d8b2e06a8c6','df2ab267-c8a3-4489-bcbf-7af01cc1bf36','2025-11-29 08:02:07',NULL,'DELETE','COMPLETE','1','HooksTest-126905259-rg-upgc3i2awrcm-1-ahg3qtifb5ci','state changed','OS::Heat::RandomString',NULL,NULL),(922,'4ceeb857-c567-4c5c-8e0e-e086b9b7fcc9','7f13ebe3-acc2-4edf-9399-e87b2b7f132b','2025-11-29 08:02:07',NULL,'UPDATE','IN_PROGRESS','server','5e9e4b2f-410e-45b6-9bd8-605eb6e92230','state changed','OS::Nova::Server',NULL,168),(923,'7c5da162-191c-4348-bd5d-fbf826dec264','c4615851-66cd-4eed-ad47-c6036dfa3d06','2025-11-29 08:02:08',NULL,'CREATE','IN_PROGRESS','test_resource_a','StackOutputsTest-1596412490-test_resource_a-dbwv6oe42q4o','state changed','OS::Heat::TestResource',NULL,174),(924,'107582b8-2792-4c75-a406-c22b649ecb7f','c4615851-66cd-4eed-ad47-c6036dfa3d06','2025-11-29 08:02:08',NULL,'CREATE','COMPLETE','test_resource_a','StackOutputsTest-1596412490-test_resource_a-dbwv6oe42q4o','state changed','OS::Heat::TestResource',NULL,174),(925,'31971f3c-d111-424d-9177-0eeef833a7af','c4615851-66cd-4eed-ad47-c6036dfa3d06','2025-11-29 08:02:08',NULL,'CREATE','COMPLETE','StackOutputsTest-1596412490','c4615851-66cd-4eed-ad47-c6036dfa3d06','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(926,'d1a51f30-ed1a-4e32-80bc-2635b0eefcff','df2ab267-c8a3-4489-bcbf-7af01cc1bf36','2025-11-29 08:02:08',NULL,'DELETE','IN_PROGRESS','0','HooksTest-126905259-rg-upgc3i2awrcm-0-tf34skcpquuy','state changed','OS::Heat::RandomString',NULL,NULL),(927,'39f1873b-9bc7-44e2-8312-03c880b36dba','df2ab267-c8a3-4489-bcbf-7af01cc1bf36','2025-11-29 08:02:08',NULL,'DELETE','COMPLETE','0','HooksTest-126905259-rg-upgc3i2awrcm-0-tf34skcpquuy','state changed','OS::Heat::RandomString',NULL,NULL),(928,'f1993b6f-f5b9-435e-a684-e96f57d2d8b2','df2ab267-c8a3-4489-bcbf-7af01cc1bf36','2025-11-29 08:02:08',NULL,'DELETE','COMPLETE','HooksTest-126905259-rg-upgc3i2awrcm','df2ab267-c8a3-4489-bcbf-7af01cc1bf36','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(929,'1691c4fa-47a4-437b-9aae-976d34622d19','c4615851-66cd-4eed-ad47-c6036dfa3d06','2025-11-29 08:02:09',NULL,'UPDATE','IN_PROGRESS','StackOutputsTest-1596412490','c4615851-66cd-4eed-ad47-c6036dfa3d06','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(930,'1a20e6bd-d61d-4999-bded-b08d6418fab1','c4615851-66cd-4eed-ad47-c6036dfa3d06','2025-11-29 08:02:09',NULL,'CREATE','IN_PROGRESS','test_resource_b','StackOutputsTest-1596412490-test_resource_b-x7zw564y4mrw','state changed','OS::Heat::TestResource',NULL,175),(931,'6b87b352-f21d-4744-a10d-1e550901345d','c4615851-66cd-4eed-ad47-c6036dfa3d06','2025-11-29 08:02:09',NULL,'CREATE','COMPLETE','test_resource_b','StackOutputsTest-1596412490-test_resource_b-x7zw564y4mrw','state changed','OS::Heat::TestResource',NULL,175),(932,'0b73c359-47db-4ae8-96bb-fbd0e65caed0','c4615851-66cd-4eed-ad47-c6036dfa3d06','2025-11-29 08:02:09',NULL,'UPDATE','COMPLETE','StackOutputsTest-1596412490','c4615851-66cd-4eed-ad47-c6036dfa3d06','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(933,'204fc6e7-db6c-4e9f-9e98-3bf08fdfcc64','99378704-0dba-4b64-8474-42e06567dd4e','2025-11-29 08:02:09',NULL,'DELETE','COMPLETE','rg','df2ab267-c8a3-4489-bcbf-7af01cc1bf36','state changed','OS::Heat::ResourceGroup',NULL,172),(934,'ece047cc-f52b-48f8-bc0e-0424e71e570a','99378704-0dba-4b64-8474-42e06567dd4e','2025-11-29 08:02:09',NULL,'DELETE','COMPLETE','HooksTest-126905259','99378704-0dba-4b64-8474-42e06567dd4e','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(935,'842bec59-caec-4301-af0f-a7d87c2ee52b','7f13ebe3-acc2-4edf-9399-e87b2b7f132b','2025-11-29 08:02:10',NULL,'UPDATE','COMPLETE','server','5e9e4b2f-410e-45b6-9bd8-605eb6e92230','state changed','OS::Nova::Server',NULL,176),(936,'b1a01a2e-28df-4da6-b496-7331088e1e5a','7f13ebe3-acc2-4edf-9399-e87b2b7f132b','2025-11-29 08:02:10',NULL,'UPDATE','COMPLETE','swap_network_subnet','7f13ebe3-acc2-4edf-9399-e87b2b7f132b','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(937,'e33bebb1-dc95-44a5-a5d6-bcd1bb4d6f64','c7c77e98-2bf9-4163-bd8d-3ffc018502af','2025-11-29 08:02:13',NULL,'CREATE','IN_PROGRESS','HooksTest-1713482985','c7c77e98-2bf9-4163-bd8d-3ffc018502af','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(938,'a009723c-82a6-4724-bd06-c927aafb7ab7','c7c77e98-2bf9-4163-bd8d-3ffc018502af','2025-11-29 08:02:13',NULL,'CREATE','IN_PROGRESS','foo_step1','HooksTest-1713482985-foo_step1-uf3ra7z3vvzx','state changed','OS::Heat::RandomString',NULL,NULL),(939,'714f9f66-4049-42a5-af47-f45679d952b9','c7c77e98-2bf9-4163-bd8d-3ffc018502af','2025-11-29 08:02:13',NULL,'CREATE','COMPLETE','foo_step1','HooksTest-1713482985-foo_step1-uf3ra7z3vvzx','state changed','OS::Heat::RandomString',NULL,NULL),(940,'ede34db6-bcf4-43fd-9ecd-cbfecc6f8e16','7f13ebe3-acc2-4edf-9399-e87b2b7f132b','2025-11-29 08:02:13',NULL,'DELETE','IN_PROGRESS','swap_network_subnet','7f13ebe3-acc2-4edf-9399-e87b2b7f132b','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(941,'ed85f67f-f31f-4d72-ab66-a0ec1ac2a01b','c7c77e98-2bf9-4163-bd8d-3ffc018502af','2025-11-29 08:02:13',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-1713482985-foo_step2-qsplgkjmbkgr','state changed','OS::Heat::RandomString',NULL,NULL),(942,'39684ff7-fefd-4fd1-ae8c-394b5ac2140b','c4615851-66cd-4eed-ad47-c6036dfa3d06','2025-11-29 08:02:13',NULL,'DELETE','IN_PROGRESS','StackOutputsTest-1596412490','c4615851-66cd-4eed-ad47-c6036dfa3d06','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(943,'b293db4a-f11a-4934-a04e-e94f46904764','c7c77e98-2bf9-4163-bd8d-3ffc018502af','2025-11-29 08:02:13',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1713482985-foo_step2-qsplgkjmbkgr','state changed','OS::Heat::RandomString',NULL,NULL),(944,'43c49cc3-eac0-4ee0-bbbe-ed7c01f48673','c4615851-66cd-4eed-ad47-c6036dfa3d06','2025-11-29 08:02:13',NULL,'DELETE','IN_PROGRESS','test_resource_b','StackOutputsTest-1596412490-test_resource_b-x7zw564y4mrw','state changed','OS::Heat::TestResource',NULL,175),(945,'7bfcb3f4-1836-4432-93a7-eebd965c3248','c7c77e98-2bf9-4163-bd8d-3ffc018502af','2025-11-29 08:02:13',NULL,'CREATE','IN_PROGRESS','foo_step3','HooksTest-1713482985-foo_step3-uat7aqtucm3o','state changed','OS::Heat::RandomString',NULL,NULL),(946,'78915b7e-53f7-4781-b27b-edf07509c88c','c4615851-66cd-4eed-ad47-c6036dfa3d06','2025-11-29 08:02:13',NULL,'DELETE','COMPLETE','test_resource_b','StackOutputsTest-1596412490-test_resource_b-x7zw564y4mrw','state changed','OS::Heat::TestResource',NULL,175),(947,'4912763a-b570-49ed-9384-d29fda9c291c','7f13ebe3-acc2-4edf-9399-e87b2b7f132b','2025-11-29 08:02:13',NULL,'DELETE','IN_PROGRESS','server','5e9e4b2f-410e-45b6-9bd8-605eb6e92230','state changed','OS::Nova::Server',NULL,176),(948,'4dce74f2-af7a-4a29-a3ff-060154321410','c4615851-66cd-4eed-ad47-c6036dfa3d06','2025-11-29 08:02:13',NULL,'DELETE','IN_PROGRESS','test_resource_a','StackOutputsTest-1596412490-test_resource_a-dbwv6oe42q4o','state changed','OS::Heat::TestResource',NULL,174),(949,'c2feaaa2-923d-4ff7-b388-69eab2567bc4','c7c77e98-2bf9-4163-bd8d-3ffc018502af','2025-11-29 08:02:14',NULL,'CREATE','COMPLETE','foo_step3','HooksTest-1713482985-foo_step3-uat7aqtucm3o','state changed','OS::Heat::RandomString',NULL,NULL),(950,'56560b2e-2d40-4ce9-b041-99222e245e4f','c4615851-66cd-4eed-ad47-c6036dfa3d06','2025-11-29 08:02:14',NULL,'DELETE','COMPLETE','test_resource_a','StackOutputsTest-1596412490-test_resource_a-dbwv6oe42q4o','state changed','OS::Heat::TestResource',NULL,174),(951,'74dc3cab-007a-48ad-9414-8395df5ae89e','c7c77e98-2bf9-4163-bd8d-3ffc018502af','2025-11-29 08:02:14',NULL,'CREATE','COMPLETE','HooksTest-1713482985','c7c77e98-2bf9-4163-bd8d-3ffc018502af','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(952,'cdd090e9-4dc5-4154-9300-94c1ec10db5f','c4615851-66cd-4eed-ad47-c6036dfa3d06','2025-11-29 08:02:14',NULL,'DELETE','COMPLETE','StackOutputsTest-1596412490','c4615851-66cd-4eed-ad47-c6036dfa3d06','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(953,'a3e30457-ae11-4331-8ca0-9751ecb23eec','7f13ebe3-acc2-4edf-9399-e87b2b7f132b','2025-11-29 08:02:17',NULL,'DELETE','COMPLETE','server','5e9e4b2f-410e-45b6-9bd8-605eb6e92230','state changed','OS::Nova::Server',NULL,176),(954,'1da90592-230e-46cf-b80c-afae08a95f55','7f13ebe3-acc2-4edf-9399-e87b2b7f132b','2025-11-29 08:02:17',NULL,'DELETE','IN_PROGRESS','subnet','09e64cdc-d97b-4b61-bbfb-8d46b750f595','state changed','OS::Neutron::Subnet',NULL,167),(955,'f51518bf-be59-4aaa-a1fc-8b225a2ccfc1','7f13ebe3-acc2-4edf-9399-e87b2b7f132b','2025-11-29 08:02:18',NULL,'DELETE','COMPLETE','subnet','09e64cdc-d97b-4b61-bbfb-8d46b750f595','state changed','OS::Neutron::Subnet',NULL,167),(956,'6f869eeb-795f-4c7f-baad-9f9dd9ca804a','7f13ebe3-acc2-4edf-9399-e87b2b7f132b','2025-11-29 08:02:18',NULL,'DELETE','IN_PROGRESS','net','78106bbb-0777-483c-94c8-14e24cb421fc','state changed','OS::Neutron::Net',NULL,165),(957,'250ed895-7102-4f6f-935a-e591460a529d','c7c77e98-2bf9-4163-bd8d-3ffc018502af','2025-11-29 08:02:19',NULL,'UPDATE','IN_PROGRESS','HooksTest-1713482985','c7c77e98-2bf9-4163-bd8d-3ffc018502af','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(958,'92851828-df03-4788-be79-581ab289788f','7f13ebe3-acc2-4edf-9399-e87b2b7f132b','2025-11-29 08:02:19',NULL,'DELETE','COMPLETE','net','78106bbb-0777-483c-94c8-14e24cb421fc','state changed','OS::Neutron::Net',NULL,165),(959,'cb1b2340-c7d8-4f96-baca-099beb34a202','7f13ebe3-acc2-4edf-9399-e87b2b7f132b','2025-11-29 08:02:19',NULL,'DELETE','COMPLETE','swap_network_subnet','7f13ebe3-acc2-4edf-9399-e87b2b7f132b','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(960,'d75c062e-c0b8-4770-bcca-fe0d44897e99','c7c77e98-2bf9-4163-bd8d-3ffc018502af','2025-11-29 08:02:19',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1713482985-foo_step2-qsplgkjmbkgr','UPDATE paused until Hook pre-update is cleared','OS::Heat::RandomString',NULL,NULL),(961,'2705fa64-97c6-4e64-bf81-bf1a5cf708ea','20e3a093-495d-4752-a6c0-625fe2c5e938','2025-11-29 08:02:19',NULL,'CREATE','IN_PROGRESS','StackUnicodeTemplateTest-889378100','20e3a093-495d-4752-a6c0-625fe2c5e938','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(962,'5a634033-3815-4bfd-9f91-55b27d6b73bc','20e3a093-495d-4752-a6c0-625fe2c5e938','2025-11-29 08:02:19',NULL,'CREATE','IN_PROGRESS','资源','StackUnicodeTemplateTest-889378100-资源-w47a7awkikr6','state changed','OS::Heat::RandomString',NULL,178),(963,'09f76267-fcf8-47d5-887c-01be0f77619d','20e3a093-495d-4752-a6c0-625fe2c5e938','2025-11-29 08:02:19',NULL,'CREATE','COMPLETE','资源','StackUnicodeTemplateTest-889378100-资源-w47a7awkikr6','state changed','OS::Heat::RandomString',NULL,178),(964,'07150151-3054-4dcc-98f5-a73029511933','20e3a093-495d-4752-a6c0-625fe2c5e938','2025-11-29 08:02:19',NULL,'CREATE','COMPLETE','StackUnicodeTemplateTest-889378100','20e3a093-495d-4752-a6c0-625fe2c5e938','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(965,'c135616b-1367-444d-83d7-0eec7b09ab72','c7c77e98-2bf9-4163-bd8d-3ffc018502af','2025-11-29 08:02:20',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1713482985-foo_step2-qsplgkjmbkgr','Hook pre-update is cleared','OS::Heat::RandomString',NULL,NULL),(966,'a40110fe-6f55-42b3-8fe0-48056c7d38b5','c7c77e98-2bf9-4163-bd8d-3ffc018502af','2025-11-29 08:02:20',NULL,'UPDATE','COMPLETE','HooksTest-1713482985','c7c77e98-2bf9-4163-bd8d-3ffc018502af','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(967,'962dc1a2-8123-475f-be0f-e2ba061c8ae1','20e3a093-495d-4752-a6c0-625fe2c5e938','2025-11-29 08:02:20',NULL,'DELETE','IN_PROGRESS','StackUnicodeTemplateTest-889378100','20e3a093-495d-4752-a6c0-625fe2c5e938','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(968,'9da2148c-dd6c-40ab-bf4c-40c92b2a04b8','20e3a093-495d-4752-a6c0-625fe2c5e938','2025-11-29 08:02:21',NULL,'DELETE','IN_PROGRESS','资源','StackUnicodeTemplateTest-889378100-资源-w47a7awkikr6','state changed','OS::Heat::RandomString',NULL,178),(969,'9c28ec64-cd35-45cb-ae24-d02d3c8d13f3','20e3a093-495d-4752-a6c0-625fe2c5e938','2025-11-29 08:02:21',NULL,'DELETE','COMPLETE','资源','StackUnicodeTemplateTest-889378100-资源-w47a7awkikr6','state changed','OS::Heat::RandomString',NULL,178),(970,'396766c5-be03-4bd5-ae66-61364e2567ae','20e3a093-495d-4752-a6c0-625fe2c5e938','2025-11-29 08:02:21',NULL,'DELETE','COMPLETE','StackUnicodeTemplateTest-889378100','20e3a093-495d-4752-a6c0-625fe2c5e938','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(971,'a24576f1-e081-438b-94c2-cad0661d7756','c7c77e98-2bf9-4163-bd8d-3ffc018502af','2025-11-29 08:02:25',NULL,'DELETE','IN_PROGRESS','HooksTest-1713482985','c7c77e98-2bf9-4163-bd8d-3ffc018502af','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(972,'0bd6915d-3f68-4d08-bc99-b656a71fb479','c7c77e98-2bf9-4163-bd8d-3ffc018502af','2025-11-29 08:02:25',NULL,'DELETE','IN_PROGRESS','foo_step3','HooksTest-1713482985-foo_step3-uat7aqtucm3o','state changed','OS::Heat::RandomString',NULL,NULL),(973,'6b5b2093-3262-4e78-8a66-54553385ee60','c7c77e98-2bf9-4163-bd8d-3ffc018502af','2025-11-29 08:02:25',NULL,'DELETE','COMPLETE','foo_step3','HooksTest-1713482985-foo_step3-uat7aqtucm3o','state changed','OS::Heat::RandomString',NULL,NULL),(974,'2ab9e690-8531-4b0d-8d11-2462a5f92c36','c7c77e98-2bf9-4163-bd8d-3ffc018502af','2025-11-29 08:02:25',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-1713482985-foo_step2-qsplgkjmbkgr','state changed','OS::Heat::RandomString',NULL,NULL),(975,'1f18a20a-c628-48c9-91d6-586b17178165','c7c77e98-2bf9-4163-bd8d-3ffc018502af','2025-11-29 08:02:25',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-1713482985-foo_step2-qsplgkjmbkgr','state changed','OS::Heat::RandomString',NULL,NULL),(976,'ce0463b3-bf8d-4803-9a6b-96c4cb4e0994','c7c77e98-2bf9-4163-bd8d-3ffc018502af','2025-11-29 08:02:25',NULL,'DELETE','IN_PROGRESS','foo_step1','HooksTest-1713482985-foo_step1-uf3ra7z3vvzx','state changed','OS::Heat::RandomString',NULL,NULL),(977,'69b7ec92-b88e-4e24-9f4f-d2b36b3a71cb','c7c77e98-2bf9-4163-bd8d-3ffc018502af','2025-11-29 08:02:25',NULL,'DELETE','COMPLETE','foo_step1','HooksTest-1713482985-foo_step1-uf3ra7z3vvzx','state changed','OS::Heat::RandomString',NULL,NULL),(978,'64518c3e-8dcc-4294-93d5-9ae77400be8c','c7c77e98-2bf9-4163-bd8d-3ffc018502af','2025-11-29 08:02:25',NULL,'DELETE','COMPLETE','HooksTest-1713482985','c7c77e98-2bf9-4163-bd8d-3ffc018502af','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(979,'b24afc82-a5d2-4392-b79f-af1814c8c119','fc8b6f5a-c10b-4428-990d-f5c2ce4d29c6','2025-11-29 08:02:25',NULL,'CREATE','IN_PROGRESS','swap_subnet_network','fc8b6f5a-c10b-4428-990d-f5c2ce4d29c6','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(980,'f5de0a6c-76d5-4650-80ad-60c2540a9cd7','fc8b6f5a-c10b-4428-990d-f5c2ce4d29c6','2025-11-29 08:02:26',NULL,'CREATE','IN_PROGRESS','net','swap_subnet_network-net-gxf4xttc3kf4','state changed','OS::Neutron::Net',NULL,179),(981,'e73a80b2-1e6d-4953-83e3-5b0369631a42','fc8b6f5a-c10b-4428-990d-f5c2ce4d29c6','2025-11-29 08:02:27',NULL,'CREATE','COMPLETE','net','7ddb4ea6-1e98-4edd-836e-6da2e5aefd3b','state changed','OS::Neutron::Net',NULL,179),(982,'30484e72-252c-4dd4-aa66-e637b8aa4eee','fc8b6f5a-c10b-4428-990d-f5c2ce4d29c6','2025-11-29 08:02:27',NULL,'CREATE','IN_PROGRESS','subnet','swap_subnet_network-subnet-w2auqyfp3jcq','state changed','OS::Neutron::Subnet',NULL,180),(983,'4f647cb4-71c3-441a-b757-33a7adac1d1b','fc8b6f5a-c10b-4428-990d-f5c2ce4d29c6','2025-11-29 08:02:29',NULL,'CREATE','COMPLETE','subnet','cdbcb4f0-49cf-40bd-a5ee-5048ef0e9a20','state changed','OS::Neutron::Subnet',NULL,180),(984,'ad58a465-9f4a-49d8-a37f-b4fafe4154da','fc8b6f5a-c10b-4428-990d-f5c2ce4d29c6','2025-11-29 08:02:30',NULL,'CREATE','IN_PROGRESS','server','swap_subnet_network-server-2evhvy2nb342','state changed','OS::Nova::Server',NULL,181),(985,'b6b59d83-7c34-4df5-a8da-23bc951d1b3a','12539f82-9960-4a0a-8635-fe8955575a40','2025-11-29 08:02:31',NULL,'CREATE','IN_PROGRESS','HooksTest-1771037649','12539f82-9960-4a0a-8635-fe8955575a40','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(986,'93d34ca9-c48a-43f7-a1e5-376c40c94cd9','12539f82-9960-4a0a-8635-fe8955575a40','2025-11-29 08:02:31',NULL,'CREATE','IN_PROGRESS','foo_step1','HooksTest-1771037649-foo_step1-3hqnow3sovm4','state changed','OS::Heat::RandomString',NULL,NULL),(987,'6a1adbe8-06a3-4676-8ef0-260149b4a4b2','12539f82-9960-4a0a-8635-fe8955575a40','2025-11-29 08:02:31',NULL,'CREATE','COMPLETE','foo_step1','HooksTest-1771037649-foo_step1-3hqnow3sovm4','state changed','OS::Heat::RandomString',NULL,NULL),(988,'09265db8-b50f-4ed0-a957-33cd4e93e02d','12539f82-9960-4a0a-8635-fe8955575a40','2025-11-29 08:02:31',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-1771037649-foo_step2-glki5ciwjt5u','state changed','OS::Heat::RandomString',NULL,NULL),(989,'30552c1c-f482-460e-b858-84b7feeca9f0','12539f82-9960-4a0a-8635-fe8955575a40','2025-11-29 08:02:31',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1771037649-foo_step2-glki5ciwjt5u','state changed','OS::Heat::RandomString',NULL,NULL),(990,'a5d6363a-a9f9-4e44-8354-3cadb9257a79','12539f82-9960-4a0a-8635-fe8955575a40','2025-11-29 08:02:31',NULL,'CREATE','IN_PROGRESS','foo_step3','HooksTest-1771037649-foo_step3-g3mtrocnxdyk','state changed','OS::Heat::RandomString',NULL,NULL),(991,'63e8715d-ade8-4d99-817c-a8e2f2a56efd','12539f82-9960-4a0a-8635-fe8955575a40','2025-11-29 08:02:31',NULL,'CREATE','COMPLETE','foo_step3','HooksTest-1771037649-foo_step3-g3mtrocnxdyk','state changed','OS::Heat::RandomString',NULL,NULL),(992,'c8950945-3d4e-42a8-8e74-5341c8efcd26','12539f82-9960-4a0a-8635-fe8955575a40','2025-11-29 08:02:31',NULL,'CREATE','COMPLETE','HooksTest-1771037649','12539f82-9960-4a0a-8635-fe8955575a40','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(993,'4e7064be-f7bc-4452-86f4-ba56bae4005a','12539f82-9960-4a0a-8635-fe8955575a40','2025-11-29 08:02:32',NULL,'UPDATE','IN_PROGRESS','HooksTest-1771037649','12539f82-9960-4a0a-8635-fe8955575a40','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(994,'71322ccc-8a30-4cb5-9766-78c2d455d02f','12539f82-9960-4a0a-8635-fe8955575a40','2025-11-29 08:02:32',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1771037649-foo_step2-glki5ciwjt5u','UPDATE paused until Hook pre-update is cleared','OS::Heat::RandomString',NULL,NULL),(995,'549e8de4-c479-486c-b86b-8df883ed02fc','12539f82-9960-4a0a-8635-fe8955575a40','2025-11-29 08:02:33',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1771037649-foo_step2-glki5ciwjt5u','Hook pre-update is cleared','OS::Heat::RandomString',NULL,NULL),(996,'d2230761-0767-48ab-8aa4-50c49a0054c8','12539f82-9960-4a0a-8635-fe8955575a40','2025-11-29 08:02:34',NULL,'UPDATE','IN_PROGRESS','foo_step2','HooksTest-1771037649-foo_step2-glki5ciwjt5u','state changed','OS::Heat::RandomString',NULL,NULL),(997,'b9cd000d-4145-404f-9a72-c7a145092ac7','12539f82-9960-4a0a-8635-fe8955575a40','2025-11-29 08:02:34',NULL,'UPDATE','COMPLETE','foo_step2','HooksTest-1771037649-foo_step2-glki5ciwjt5u','The Resource foo_step2 requires replacement.','OS::Heat::RandomString',NULL,NULL),(998,'19e08b8b-d641-4610-a1d7-421fb8ea4e3d','12539f82-9960-4a0a-8635-fe8955575a40','2025-11-29 08:02:34',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-1771037649-foo_step2-fp7ym6nay7l4','state changed','OS::Heat::RandomString',NULL,182),(999,'bf1a61da-b036-4458-9559-6b279c920a81','12539f82-9960-4a0a-8635-fe8955575a40','2025-11-29 08:02:34',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1771037649-foo_step2-fp7ym6nay7l4','state changed','OS::Heat::RandomString',NULL,182),(1000,'d138e336-9636-4601-a6ea-5964604924f5','12539f82-9960-4a0a-8635-fe8955575a40','2025-11-29 08:02:34',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-1771037649-foo_step2-glki5ciwjt5u','state changed','OS::Heat::RandomString',NULL,NULL),(1001,'95a1c9be-2f4e-468d-ac91-5375575a6a62','12539f82-9960-4a0a-8635-fe8955575a40','2025-11-29 08:02:34',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-1771037649-foo_step2-glki5ciwjt5u','state changed','OS::Heat::RandomString',NULL,NULL),(1002,'368963cf-6f30-4968-84de-bed0901e0bd0','12539f82-9960-4a0a-8635-fe8955575a40','2025-11-29 08:02:34',NULL,'UPDATE','COMPLETE','HooksTest-1771037649','12539f82-9960-4a0a-8635-fe8955575a40','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1003,'1a251bee-ed4e-4757-a105-23d4bb084bb2','12539f82-9960-4a0a-8635-fe8955575a40','2025-11-29 08:02:38',NULL,'DELETE','IN_PROGRESS','HooksTest-1771037649','12539f82-9960-4a0a-8635-fe8955575a40','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1004,'9c3051de-dcb6-4fff-a1fa-373f7964b7d3','12539f82-9960-4a0a-8635-fe8955575a40','2025-11-29 08:02:40',NULL,'DELETE','IN_PROGRESS','foo_step3','HooksTest-1771037649-foo_step3-g3mtrocnxdyk','state changed','OS::Heat::RandomString',NULL,NULL),(1005,'fbee4dea-5cfd-49d6-84e8-17907257a36e','12539f82-9960-4a0a-8635-fe8955575a40','2025-11-29 08:02:41',NULL,'DELETE','COMPLETE','foo_step3','HooksTest-1771037649-foo_step3-g3mtrocnxdyk','state changed','OS::Heat::RandomString',NULL,NULL),(1006,'b28cf194-e490-421c-b6a3-ad4f87159ceb','12539f82-9960-4a0a-8635-fe8955575a40','2025-11-29 08:02:41',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-1771037649-foo_step2-fp7ym6nay7l4','state changed','OS::Heat::RandomString',NULL,182),(1007,'f653612b-455e-4435-81fc-bdf89dd517fc','12539f82-9960-4a0a-8635-fe8955575a40','2025-11-29 08:02:41',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-1771037649-foo_step2-fp7ym6nay7l4','state changed','OS::Heat::RandomString',NULL,182),(1008,'33bb633d-34bf-4084-ac6e-33144ad96c4b','12539f82-9960-4a0a-8635-fe8955575a40','2025-11-29 08:02:41',NULL,'DELETE','IN_PROGRESS','foo_step1','HooksTest-1771037649-foo_step1-3hqnow3sovm4','state changed','OS::Heat::RandomString',NULL,NULL),(1009,'e7b2bc04-d820-4b2d-8f56-956a38e7136b','12539f82-9960-4a0a-8635-fe8955575a40','2025-11-29 08:02:41',NULL,'DELETE','COMPLETE','foo_step1','HooksTest-1771037649-foo_step1-3hqnow3sovm4','state changed','OS::Heat::RandomString',NULL,NULL),(1010,'1c10ddc5-488e-4a04-b6e0-ce0b93d5b4c2','12539f82-9960-4a0a-8635-fe8955575a40','2025-11-29 08:02:41',NULL,'DELETE','COMPLETE','HooksTest-1771037649','12539f82-9960-4a0a-8635-fe8955575a40','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1011,'180acf11-00ef-4747-beac-fad58caadce3','fc8b6f5a-c10b-4428-990d-f5c2ce4d29c6','2025-11-29 08:02:47',NULL,'CREATE','COMPLETE','server','402fb918-8566-4bb1-a3ff-b7ef64e2f3dc','state changed','OS::Nova::Server',NULL,181),(1012,'30c7e948-c3ad-469b-b685-83130575cacd','fc8b6f5a-c10b-4428-990d-f5c2ce4d29c6','2025-11-29 08:02:48',NULL,'CREATE','COMPLETE','swap_subnet_network','fc8b6f5a-c10b-4428-990d-f5c2ce4d29c6','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1013,'556cfbf9-3444-4097-8827-654aeee57b48','7f8db07d-54bf-4626-81e8-2cac67728e4b','2025-11-29 08:02:48',NULL,'CREATE','IN_PROGRESS','ResourcesList-970551472','7f8db07d-54bf-4626-81e8-2cac67728e4b','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1014,'dda4fbc0-9f74-430e-8282-9c6c62d7e060','7f8db07d-54bf-4626-81e8-2cac67728e4b','2025-11-29 08:02:50',NULL,'CREATE','IN_PROGRESS','test1','ResourcesList-970551472-test1-emgrvttybywi','state changed','OS::Heat::TestResource',NULL,183),(1015,'60b4d9be-5de3-492d-b268-883e68c286b4','7f8db07d-54bf-4626-81e8-2cac67728e4b','2025-11-29 08:02:50',NULL,'CREATE','COMPLETE','test1','ResourcesList-970551472-test1-emgrvttybywi','state changed','OS::Heat::TestResource',NULL,183),(1016,'b18b383b-2e0b-4949-9d11-2ceb0adc0ebc','7f8db07d-54bf-4626-81e8-2cac67728e4b','2025-11-29 08:02:50',NULL,'CREATE','IN_PROGRESS','test2','ResourcesList-970551472-test2-lzg6ksxph3wg','state changed','OS::Heat::TestResource',NULL,184),(1017,'bf546400-c8b4-4c69-93b7-c80584431541','7f8db07d-54bf-4626-81e8-2cac67728e4b','2025-11-29 08:02:50',NULL,'CREATE','COMPLETE','test2','ResourcesList-970551472-test2-lzg6ksxph3wg','state changed','OS::Heat::TestResource',NULL,184),(1018,'7b48dce0-cce4-44ce-95fd-bef0ab2da5b4','7f8db07d-54bf-4626-81e8-2cac67728e4b','2025-11-29 08:02:51',NULL,'CREATE','COMPLETE','ResourcesList-970551472','7f8db07d-54bf-4626-81e8-2cac67728e4b','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1019,'c669081a-e24a-4b32-b49c-ae0ddf5eacb7','fc8b6f5a-c10b-4428-990d-f5c2ce4d29c6','2025-11-29 08:02:53',NULL,'UPDATE','IN_PROGRESS','swap_subnet_network','fc8b6f5a-c10b-4428-990d-f5c2ce4d29c6','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1020,'aeda5edd-8ce2-44c0-ab25-b9c9808ee0ff','fc8b6f5a-c10b-4428-990d-f5c2ce4d29c6','2025-11-29 08:02:54',NULL,'UPDATE','IN_PROGRESS','server','402fb918-8566-4bb1-a3ff-b7ef64e2f3dc','state changed','OS::Nova::Server',NULL,181),(1021,'9eeef1ef-61e3-469d-9008-d631f6f94aa3','7f8db07d-54bf-4626-81e8-2cac67728e4b','2025-11-29 08:02:54',NULL,'DELETE','IN_PROGRESS','ResourcesList-970551472','7f8db07d-54bf-4626-81e8-2cac67728e4b','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1022,'571817e7-0157-42c6-aa66-fdcf077bb21d','7f8db07d-54bf-4626-81e8-2cac67728e4b','2025-11-29 08:02:55',NULL,'DELETE','IN_PROGRESS','test2','ResourcesList-970551472-test2-lzg6ksxph3wg','state changed','OS::Heat::TestResource',NULL,184),(1023,'7a02e704-74b7-4148-91ba-9ee04a459ead','7f8db07d-54bf-4626-81e8-2cac67728e4b','2025-11-29 08:02:55',NULL,'DELETE','COMPLETE','test2','ResourcesList-970551472-test2-lzg6ksxph3wg','state changed','OS::Heat::TestResource',NULL,184),(1024,'ab7d012c-8d01-4558-af42-67e9f8a88cea','7f8db07d-54bf-4626-81e8-2cac67728e4b','2025-11-29 08:02:55',NULL,'DELETE','IN_PROGRESS','test1','ResourcesList-970551472-test1-emgrvttybywi','state changed','OS::Heat::TestResource',NULL,183),(1025,'db8f6b55-7058-4f0c-a34c-7bea8b1e92b6','7f8db07d-54bf-4626-81e8-2cac67728e4b','2025-11-29 08:02:55',NULL,'DELETE','COMPLETE','test1','ResourcesList-970551472-test1-emgrvttybywi','state changed','OS::Heat::TestResource',NULL,183),(1026,'dc184671-9348-4373-9060-ee6943c3e095','7f8db07d-54bf-4626-81e8-2cac67728e4b','2025-11-29 08:02:55',NULL,'DELETE','COMPLETE','ResourcesList-970551472','7f8db07d-54bf-4626-81e8-2cac67728e4b','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1027,'b007c4bb-0c42-46d6-9be3-c283df4d0de3','fc8b6f5a-c10b-4428-990d-f5c2ce4d29c6','2025-11-29 08:02:57',NULL,'UPDATE','COMPLETE','server','402fb918-8566-4bb1-a3ff-b7ef64e2f3dc','state changed','OS::Nova::Server',NULL,186),(1028,'93236637-37eb-46e0-83bc-24ae7229194e','fc8b6f5a-c10b-4428-990d-f5c2ce4d29c6','2025-11-29 08:02:58',NULL,'UPDATE','COMPLETE','swap_subnet_network','fc8b6f5a-c10b-4428-990d-f5c2ce4d29c6','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1029,'d75bf70d-6be2-4774-9636-9cde2fc73ea3','fc8b6f5a-c10b-4428-990d-f5c2ce4d29c6','2025-11-29 08:03:01',NULL,'DELETE','IN_PROGRESS','swap_subnet_network','fc8b6f5a-c10b-4428-990d-f5c2ce4d29c6','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1030,'09677ec2-191a-4011-afd0-413f58e9bcc4','fc8b6f5a-c10b-4428-990d-f5c2ce4d29c6','2025-11-29 08:03:01',NULL,'DELETE','IN_PROGRESS','server','402fb918-8566-4bb1-a3ff-b7ef64e2f3dc','state changed','OS::Nova::Server',NULL,186),(1031,'e3a86435-3e24-4f22-bd7c-656c40a4969e','6e051623-2655-4cba-8bec-f1e408ffbc12','2025-11-29 08:03:01',NULL,'CREATE','IN_PROGRESS','ResourcesList-865981516','6e051623-2655-4cba-8bec-f1e408ffbc12','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1032,'0a08fb97-4f6c-4383-96c2-50feec56e797','6e051623-2655-4cba-8bec-f1e408ffbc12','2025-11-29 08:03:01',NULL,'CREATE','IN_PROGRESS','test1','ResourcesList-865981516-test1-ns6cpyf6gj6p','state changed','OS::Heat::TestResource',NULL,188),(1033,'6699d7b1-808a-4b37-b255-452d2084fa6d','6e051623-2655-4cba-8bec-f1e408ffbc12','2025-11-29 08:03:01',NULL,'CREATE','COMPLETE','test1','ResourcesList-865981516-test1-ns6cpyf6gj6p','state changed','OS::Heat::TestResource',NULL,188),(1034,'c6dc3b8f-35f5-4e24-9ef1-ae30041ab9de','6e051623-2655-4cba-8bec-f1e408ffbc12','2025-11-29 08:03:01',NULL,'CREATE','IN_PROGRESS','test2','ResourcesList-865981516-test2-44yevibymuwg','state changed','OS::Heat::TestResource',NULL,189),(1035,'990d5074-f318-4bda-bae1-f3b06656c941','6e051623-2655-4cba-8bec-f1e408ffbc12','2025-11-29 08:03:01',NULL,'CREATE','COMPLETE','test2','ResourcesList-865981516-test2-44yevibymuwg','state changed','OS::Heat::TestResource',NULL,189),(1036,'cf486c70-ba7e-4536-a92c-d32a1564b305','6e051623-2655-4cba-8bec-f1e408ffbc12','2025-11-29 08:03:01',NULL,'CREATE','COMPLETE','ResourcesList-865981516','6e051623-2655-4cba-8bec-f1e408ffbc12','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1037,'4a6ea999-2415-48c9-b7d1-2cb736918905','6e051623-2655-4cba-8bec-f1e408ffbc12','2025-11-29 08:03:02',NULL,'DELETE','IN_PROGRESS','ResourcesList-865981516','6e051623-2655-4cba-8bec-f1e408ffbc12','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1038,'1cbb5ebd-8ac8-401e-b7f9-6f57d9fa0ac4','6e051623-2655-4cba-8bec-f1e408ffbc12','2025-11-29 08:03:02',NULL,'DELETE','IN_PROGRESS','test2','ResourcesList-865981516-test2-44yevibymuwg','state changed','OS::Heat::TestResource',NULL,189),(1039,'7f67fa83-183b-425f-9229-2f595fa87e76','6e051623-2655-4cba-8bec-f1e408ffbc12','2025-11-29 08:03:02',NULL,'DELETE','COMPLETE','test2','ResourcesList-865981516-test2-44yevibymuwg','state changed','OS::Heat::TestResource',NULL,189),(1040,'f659998f-26d2-4d8c-9f07-b695a4b0f024','6e051623-2655-4cba-8bec-f1e408ffbc12','2025-11-29 08:03:02',NULL,'DELETE','IN_PROGRESS','test1','ResourcesList-865981516-test1-ns6cpyf6gj6p','state changed','OS::Heat::TestResource',NULL,188),(1041,'3695f24c-2063-4835-98e2-4a34883f005a','6e051623-2655-4cba-8bec-f1e408ffbc12','2025-11-29 08:03:02',NULL,'DELETE','COMPLETE','test1','ResourcesList-865981516-test1-ns6cpyf6gj6p','state changed','OS::Heat::TestResource',NULL,188),(1042,'4039ce6f-44fb-4b6d-830b-c7b429597d21','6e051623-2655-4cba-8bec-f1e408ffbc12','2025-11-29 08:03:02',NULL,'DELETE','COMPLETE','ResourcesList-865981516','6e051623-2655-4cba-8bec-f1e408ffbc12','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1043,'79f22188-f15c-4b65-88d9-b0f2192acd29','fc8b6f5a-c10b-4428-990d-f5c2ce4d29c6','2025-11-29 08:03:03',NULL,'DELETE','COMPLETE','server','402fb918-8566-4bb1-a3ff-b7ef64e2f3dc','state changed','OS::Nova::Server',NULL,186),(1044,'2e39fc00-e0c9-4360-850f-cdd1bbb3286d','fc8b6f5a-c10b-4428-990d-f5c2ce4d29c6','2025-11-29 08:03:04',NULL,'DELETE','IN_PROGRESS','subnet','cdbcb4f0-49cf-40bd-a5ee-5048ef0e9a20','state changed','OS::Neutron::Subnet',NULL,180),(1045,'27bae370-e0c6-41a4-ac07-c25dcd709570','fc8b6f5a-c10b-4428-990d-f5c2ce4d29c6','2025-11-29 08:03:05',NULL,'DELETE','COMPLETE','subnet','cdbcb4f0-49cf-40bd-a5ee-5048ef0e9a20','state changed','OS::Neutron::Subnet',NULL,180),(1046,'05145630-0b29-4a89-9aac-9af5be0d9066','fc8b6f5a-c10b-4428-990d-f5c2ce4d29c6','2025-11-29 08:03:06',NULL,'DELETE','IN_PROGRESS','net','7ddb4ea6-1e98-4edd-836e-6da2e5aefd3b','state changed','OS::Neutron::Net',NULL,179),(1047,'84d0e67b-684e-4962-9460-7dd509ec8888','fc8b6f5a-c10b-4428-990d-f5c2ce4d29c6','2025-11-29 08:03:06',NULL,'DELETE','COMPLETE','net','7ddb4ea6-1e98-4edd-836e-6da2e5aefd3b','state changed','OS::Neutron::Net',NULL,179),(1048,'f40530c2-e46e-46c9-a3e0-aa3ddb87dc8e','fc8b6f5a-c10b-4428-990d-f5c2ce4d29c6','2025-11-29 08:03:06',NULL,'DELETE','COMPLETE','swap_subnet_network','fc8b6f5a-c10b-4428-990d-f5c2ce4d29c6','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1049,'281c288f-ea1d-43c5-be9d-2e862b63ffca','506e5652-64a1-44f4-8d81-3b9a8b7a1e03','2025-11-29 08:03:09',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1927891276','506e5652-64a1-44f4-8d81-3b9a8b7a1e03','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1050,'cfd495ea-479c-4e6e-a397-9c713e942aa1','506e5652-64a1-44f4-8d81-3b9a8b7a1e03','2025-11-29 08:03:10',NULL,'CREATE','IN_PROGRESS','server','Pa-llelDeploymentsTest-1927891276-server-47vedvll5cob','state changed','OS::Nova::Server',NULL,190),(1051,'26c40c51-2b25-4436-9948-026323ad1551','98f33f41-4eea-4635-b777-87c5b16462f3','2025-11-29 08:03:14',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-1316777958','98f33f41-4eea-4635-b777-87c5b16462f3','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1052,'4f66cb0e-2fde-4836-8a3d-fbbc29bedc7d','98f33f41-4eea-4635-b777-87c5b16462f3','2025-11-29 08:03:17',NULL,'CREATE','IN_PROGRESS','random1','RemoteStackTest-1316777958-random1-ciouhph346kt','state changed','OS::Heat::RandomString',NULL,NULL),(1053,'6631687a-8d06-417c-a02c-743e7fe3168a','98f33f41-4eea-4635-b777-87c5b16462f3','2025-11-29 08:03:18',NULL,'CREATE','COMPLETE','random1','RemoteStackTest-1316777958-random1-ciouhph346kt','state changed','OS::Heat::RandomString',NULL,NULL),(1054,'a61ef4f2-063b-41d6-91fe-880fa13e2ddb','98f33f41-4eea-4635-b777-87c5b16462f3','2025-11-29 08:03:18',NULL,'CREATE','COMPLETE','RemoteStackTest-1316777958','98f33f41-4eea-4635-b777-87c5b16462f3','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1055,'8e029d30-7257-48f6-a299-7609314473a4','98f33f41-4eea-4635-b777-87c5b16462f3','2025-11-29 08:03:23',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-1316777958','98f33f41-4eea-4635-b777-87c5b16462f3','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1056,'4af09e44-402e-43fb-b9f1-2d50abd3f3f7','98f33f41-4eea-4635-b777-87c5b16462f3','2025-11-29 08:03:24',NULL,'DELETE','IN_PROGRESS','random1','RemoteStackTest-1316777958-random1-ciouhph346kt','state changed','OS::Heat::RandomString',NULL,NULL),(1057,'c83f2607-71d1-4272-8053-f021edbd7246','98f33f41-4eea-4635-b777-87c5b16462f3','2025-11-29 08:03:24',NULL,'DELETE','COMPLETE','random1','RemoteStackTest-1316777958-random1-ciouhph346kt','state changed','OS::Heat::RandomString',NULL,NULL),(1058,'874bd4ba-c5e6-474d-b5c8-be164473b59d','98f33f41-4eea-4635-b777-87c5b16462f3','2025-11-29 08:03:25',NULL,'DELETE','COMPLETE','RemoteStackTest-1316777958','98f33f41-4eea-4635-b777-87c5b16462f3','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1059,'a94f5978-cd2d-40ad-a7c1-619f79428c4e','698a4d18-52b3-4488-a9df-df538a65bd4e','2025-11-29 08:03:31',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-1685272545','698a4d18-52b3-4488-a9df-df538a65bd4e','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1060,'7cbda4a3-915d-4631-8c87-38481f59ecd1','698a4d18-52b3-4488-a9df-df538a65bd4e','2025-11-29 08:03:31',NULL,'CREATE','IN_PROGRESS','my_stack','RemoteStackTest-1685272545-my_stack-nbddbdzpg2yd','state changed','OS::Heat::Stack',NULL,191),(1061,'3a7594eb-99f1-41f1-86c8-c75f3ef4118b','cbe8d4ea-a3b3-4989-b2dd-3c025ae28cbb','2025-11-29 08:03:33',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-1685272545-my_stack-nbddbdzpg2yd','cbe8d4ea-a3b3-4989-b2dd-3c025ae28cbb','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1062,'c61e5b6b-40c3-47ad-ba93-daa35d66e4c2','506e5652-64a1-44f4-8d81-3b9a8b7a1e03','2025-11-29 08:03:33',NULL,'CREATE','COMPLETE','server','e3578395-b4af-44f6-9a44-4bba1e88898b','state changed','OS::Nova::Server',NULL,190),(1063,'be5d2249-c750-448e-bb18-3c92573fe2a0','506e5652-64a1-44f4-8d81-3b9a8b7a1e03','2025-11-29 08:03:34',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1927891276','506e5652-64a1-44f4-8d81-3b9a8b7a1e03','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1064,'8ea85194-4e07-4f7f-aff7-a189781fb127','cbe8d4ea-a3b3-4989-b2dd-3c025ae28cbb','2025-11-29 08:03:35',NULL,'CREATE','IN_PROGRESS','random1','RemoteStackTest-1685272545-my_stack-nbddbdzpg2yd-random1-vrviu4delwgn','state changed','OS::Heat::RandomString',NULL,NULL),(1065,'1ba5339c-56c1-4da2-8967-808e73e74749','cbe8d4ea-a3b3-4989-b2dd-3c025ae28cbb','2025-11-29 08:03:35',NULL,'CREATE','COMPLETE','random1','RemoteStackTest-1685272545-my_stack-nbddbdzpg2yd-random1-vrviu4delwgn','state changed','OS::Heat::RandomString',NULL,NULL),(1066,'46f5f9d3-cc4c-4a82-bea4-0c3884756f93','cbe8d4ea-a3b3-4989-b2dd-3c025ae28cbb','2025-11-29 08:03:35',NULL,'CREATE','COMPLETE','RemoteStackTest-1685272545-my_stack-nbddbdzpg2yd','cbe8d4ea-a3b3-4989-b2dd-3c025ae28cbb','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1067,'94c55312-e950-4c68-a898-763dc73e4633','698a4d18-52b3-4488-a9df-df538a65bd4e','2025-11-29 08:03:37',NULL,'CREATE','COMPLETE','my_stack','cbe8d4ea-a3b3-4989-b2dd-3c025ae28cbb','state changed','OS::Heat::Stack',NULL,191),(1068,'e818fcf7-67ed-4058-a5cd-28c4bf308c33','698a4d18-52b3-4488-a9df-df538a65bd4e','2025-11-29 08:03:37',NULL,'CREATE','COMPLETE','RemoteStackTest-1685272545','698a4d18-52b3-4488-a9df-df538a65bd4e','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1069,'d7bb76dc-3676-4961-93ee-a1addf23c885','0cb91f56-9f71-4cd3-8bfb-beee945b274d','2025-11-29 08:03:38',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-483475472','0cb91f56-9f71-4cd3-8bfb-beee945b274d','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1070,'90c90215-d157-40ef-97b8-4f080cb4dd99','0cb91f56-9f71-4cd3-8bfb-beee945b274d','2025-11-29 08:03:39',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-483475472-config-jfm5pcavbvjz','state changed','OS::Heat::SoftwareConfig',NULL,192),(1071,'073215b5-c57f-466f-9772-14a44369922c','0cb91f56-9f71-4cd3-8bfb-beee945b274d','2025-11-29 08:03:40',NULL,'CREATE','COMPLETE','config','d98b1bb2-4b78-403f-8c5d-9d9b031a087c','state changed','OS::Heat::SoftwareConfig',NULL,192),(1072,'d3a4601f-1c7a-4e62-a549-44d04542c3dc','0cb91f56-9f71-4cd3-8bfb-beee945b274d','2025-11-29 08:03:40',NULL,'CREATE','IN_PROGRESS','dep_3','ParallelDeploymentsTest-483475472-dep_3-ghivu5y2ntfz','state changed','OS::Heat::SoftwareDeployments',NULL,193),(1073,'269c8f6c-e5d4-4c9d-9b93-ef3f92434dbc','0cb91f56-9f71-4cd3-8bfb-beee945b274d','2025-11-29 08:03:40',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-483475472-dep_0-7afxyxhwrcmy','state changed','OS::Heat::SoftwareDeployments',NULL,195),(1074,'bca93b85-1be7-4e22-952a-44945ea8d74a','0cb91f56-9f71-4cd3-8bfb-beee945b274d','2025-11-29 08:03:40',NULL,'CREATE','IN_PROGRESS','dep_4','ParallelDeploymentsTest-483475472-dep_4-usf4vxnbwgkw','state changed','OS::Heat::SoftwareDeployments',NULL,194),(1075,'9c3db09c-19d3-46a4-8664-8b5e8375e3aa','d3c4e302-ce7c-4d43-ada7-5a133e77c465','2025-11-29 08:03:40',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-483475472-dep_3-ghivu5y2ntfz','d3c4e302-ce7c-4d43-ada7-5a133e77c465','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1076,'83c0862d-f58c-473a-9bc4-8e8e432f75d2','0cb91f56-9f71-4cd3-8bfb-beee945b274d','2025-11-29 08:03:40',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-483475472-dep_2-34jiaunhfhqp','state changed','OS::Heat::SoftwareDeployments',NULL,196),(1077,'06ef7c1b-eee9-4641-81fe-70f671672864','5b84b18f-a52e-4a03-b039-1827cf7f0eca','2025-11-29 08:03:40',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-483475472-dep_4-usf4vxnbwgkw','5b84b18f-a52e-4a03-b039-1827cf7f0eca','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1078,'e5dd36cc-80d9-4bcd-ad58-416f87aff205','0cb91f56-9f71-4cd3-8bfb-beee945b274d','2025-11-29 08:03:40',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-483475472-dep_1-w6gw36p5e5tm','state changed','OS::Heat::SoftwareDeployments',NULL,197),(1079,'cb3dc1d0-c60a-45ce-9df7-1babe4af15a1','a1242deb-ef90-41ed-8a55-7ca5d2e883f6','2025-11-29 08:03:40',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-483475472-dep_0-7afxyxhwrcmy','a1242deb-ef90-41ed-8a55-7ca5d2e883f6','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1080,'8ca80745-93d7-48ec-ac97-43f1de5e54d1','5db7721f-ff92-4146-b2f3-2cd63ad458b0','2025-11-29 08:03:41',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1812906045','5db7721f-ff92-4146-b2f3-2cd63ad458b0','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1081,'b149d90b-38a0-4887-90fd-e830486b9571','10294177-1248-471e-98a7-f30bdd51ed59','2025-11-29 08:03:41',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-483475472-dep_1-w6gw36p5e5tm','10294177-1248-471e-98a7-f30bdd51ed59','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1082,'be60a0d6-5820-4b43-af3f-37f7881c4da3','15fa1552-2ea1-4818-adc9-e24ace9a4f26','2025-11-29 08:03:41',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-483475472-dep_2-34jiaunhfhqp','15fa1552-2ea1-4818-adc9-e24ace9a4f26','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1083,'dd4f4e46-d38d-488f-a31e-cc2ca458ff8e','d3c4e302-ce7c-4d43-ada7-5a133e77c465','2025-11-29 08:03:41',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-483475472-dep_3-ghivu5y2ntfz-0-htzp4dt5gh6w','state changed','OS::Heat::SoftwareDeployment',NULL,198),(1084,'c0b934a8-67a8-4414-8911-48cd2ad55196','5b84b18f-a52e-4a03-b039-1827cf7f0eca','2025-11-29 08:03:41',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-483475472-dep_4-usf4vxnbwgkw-0-62sa4nxih7jr','state changed','OS::Heat::SoftwareDeployment',NULL,200),(1085,'45016e8c-8175-4132-85fd-66abff25a4d5','a1242deb-ef90-41ed-8a55-7ca5d2e883f6','2025-11-29 08:03:41',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-483475472-dep_0-7afxyxhwrcmy-0-7tkzmrykmtyv','state changed','OS::Heat::SoftwareDeployment',NULL,199),(1086,'94c62139-a532-4574-8364-4cc1da3db37c','10294177-1248-471e-98a7-f30bdd51ed59','2025-11-29 08:03:41',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-483475472-dep_1-w6gw36p5e5tm-0-ztah7b4b7k3c','state changed','OS::Heat::SoftwareDeployment',NULL,201),(1087,'20a2ad4c-2737-491a-a74d-1f67dec60221','15fa1552-2ea1-4818-adc9-e24ace9a4f26','2025-11-29 08:03:41',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-483475472-dep_2-34jiaunhfhqp-0-lgicknr7xxcf','state changed','OS::Heat::SoftwareDeployment',NULL,202),(1088,'3b154e15-949f-44a2-a986-446b88796a3e','5db7721f-ff92-4146-b2f3-2cd63ad458b0','2025-11-29 08:03:41',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-1812906045-config-bta623s4ztee','state changed','OS::Heat::SoftwareConfig',NULL,204),(1089,'7bfea013-fcc9-4a4f-9c1a-d422d66a8414','5db7721f-ff92-4146-b2f3-2cd63ad458b0','2025-11-29 08:03:42',NULL,'CREATE','COMPLETE','config','19a63e85-6980-4440-b52f-0726ad7cab45','state changed','OS::Heat::SoftwareConfig',NULL,204),(1090,'d9efd1ee-e770-40b0-919c-748bf970f86a','5db7721f-ff92-4146-b2f3-2cd63ad458b0','2025-11-29 08:03:42',NULL,'CREATE','IN_PROGRESS','dep_3','ParallelDeploymentsTest-1812906045-dep_3-lylj7p3chgsx','state changed','OS::Heat::SoftwareDeployments',NULL,205),(1091,'c2842f70-d401-49d8-82c4-5a4389a1a2c1','5db7721f-ff92-4146-b2f3-2cd63ad458b0','2025-11-29 08:03:42',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-1812906045-dep_0-mhxmhs24l5sk','state changed','OS::Heat::SoftwareDeployments',NULL,206),(1092,'e70e5b78-5e68-47cd-bb04-c3c8ed04f391','5db7721f-ff92-4146-b2f3-2cd63ad458b0','2025-11-29 08:03:42',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-1812906045-dep_2-qbirlrznoxom','state changed','OS::Heat::SoftwareDeployments',NULL,207),(1093,'817810a9-3063-4c43-b29d-f380dd7a719c','5db7721f-ff92-4146-b2f3-2cd63ad458b0','2025-11-29 08:03:42',NULL,'CREATE','IN_PROGRESS','dep_4','ParallelDeploymentsTest-1812906045-dep_4-aor4tw6nckth','state changed','OS::Heat::SoftwareDeployments',NULL,208),(1094,'9e707737-9bd0-4d7b-b683-8e59158745a5','bdcc5205-74e8-46cd-9202-9d582efbba8a','2025-11-29 08:03:42',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1812906045-dep_3-lylj7p3chgsx','bdcc5205-74e8-46cd-9202-9d582efbba8a','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1095,'d8e96f38-6e35-4d2c-9385-dea49c644d82','e610242b-2f0d-4066-b73a-b387588fc139','2025-11-29 08:03:42',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1812906045-dep_0-mhxmhs24l5sk','e610242b-2f0d-4066-b73a-b387588fc139','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1096,'4bcebb3a-381e-4421-86c8-d93993298a71','5db7721f-ff92-4146-b2f3-2cd63ad458b0','2025-11-29 08:03:43',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-1812906045-dep_1-soujsdl7qnpy','state changed','OS::Heat::SoftwareDeployments',NULL,209),(1097,'f8170ee0-400e-46f7-9b65-80b3f7f05a27','6195a7ad-12b9-4ace-b439-53011ad6d6fe','2025-11-29 08:03:43',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1812906045-dep_4-aor4tw6nckth','6195a7ad-12b9-4ace-b439-53011ad6d6fe','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1098,'747bc1cd-557f-4945-b74b-3e8ad3d20b68','43c98f02-b41d-4bfa-a1ce-6f71b8dc3fb7','2025-11-29 08:03:43',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1812906045-dep_2-qbirlrznoxom','43c98f02-b41d-4bfa-a1ce-6f71b8dc3fb7','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1099,'7ecaa1e5-7193-4c8b-8801-f00d6f3c1a4f','b23e6104-f9a1-4c0c-b568-750cf917ffea','2025-11-29 08:03:43',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1812906045-dep_1-soujsdl7qnpy','b23e6104-f9a1-4c0c-b568-750cf917ffea','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1100,'63f2e0a6-a677-4ae9-82eb-17cb5adc6a10','bdcc5205-74e8-46cd-9202-9d582efbba8a','2025-11-29 08:03:43',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1812906045-dep_3-lylj7p3chgsx-0-yjidxi632p3a','state changed','OS::Heat::SoftwareDeployment',NULL,210),(1101,'f951cacc-7451-497b-b2f4-beeb069d826f','e610242b-2f0d-4066-b73a-b387588fc139','2025-11-29 08:03:43',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1812906045-dep_0-mhxmhs24l5sk-0-fgkv2e6u6xlc','state changed','OS::Heat::SoftwareDeployment',NULL,211),(1102,'c76c3a40-ab74-43ea-8c0f-b9312f8eb078','43c98f02-b41d-4bfa-a1ce-6f71b8dc3fb7','2025-11-29 08:03:43',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1812906045-dep_2-qbirlrznoxom-0-4kum6vvicddw','state changed','OS::Heat::SoftwareDeployment',NULL,212),(1103,'c1db2260-2e20-4e33-ac91-1ae5e316d972','6195a7ad-12b9-4ace-b439-53011ad6d6fe','2025-11-29 08:03:43',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1812906045-dep_4-aor4tw6nckth-0-sgov3lj5jbjr','state changed','OS::Heat::SoftwareDeployment',NULL,213),(1104,'d8304d4b-eab9-4ea3-883d-92be76c74c3d','698a4d18-52b3-4488-a9df-df538a65bd4e','2025-11-29 08:03:43',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-1685272545','698a4d18-52b3-4488-a9df-df538a65bd4e','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1105,'485d9d7c-4093-4d36-9d6f-d8253a3421c2','b23e6104-f9a1-4c0c-b568-750cf917ffea','2025-11-29 08:03:43',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1812906045-dep_1-soujsdl7qnpy-0-5mkrxe7znx6p','state changed','OS::Heat::SoftwareDeployment',NULL,214),(1106,'79e65dd7-13da-4419-bc8c-132d1bc0cbb7','698a4d18-52b3-4488-a9df-df538a65bd4e','2025-11-29 08:03:44',NULL,'DELETE','IN_PROGRESS','my_stack','cbe8d4ea-a3b3-4989-b2dd-3c025ae28cbb','state changed','OS::Heat::Stack',NULL,191),(1107,'90fb25f7-e0b6-43ba-bead-d106d4d29b11','cbe8d4ea-a3b3-4989-b2dd-3c025ae28cbb','2025-11-29 08:03:44',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-1685272545-my_stack-nbddbdzpg2yd','cbe8d4ea-a3b3-4989-b2dd-3c025ae28cbb','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1108,'c0b3e026-2edc-45e6-83d0-023e6ee490ae','cbe8d4ea-a3b3-4989-b2dd-3c025ae28cbb','2025-11-29 08:03:45',NULL,'DELETE','IN_PROGRESS','random1','RemoteStackTest-1685272545-my_stack-nbddbdzpg2yd-random1-vrviu4delwgn','state changed','OS::Heat::RandomString',NULL,NULL),(1109,'94de48d7-ea36-4f9c-9458-d65a03969dc9','cbe8d4ea-a3b3-4989-b2dd-3c025ae28cbb','2025-11-29 08:03:45',NULL,'DELETE','COMPLETE','random1','RemoteStackTest-1685272545-my_stack-nbddbdzpg2yd-random1-vrviu4delwgn','state changed','OS::Heat::RandomString',NULL,NULL),(1110,'c5e20548-916b-4ec2-a9d8-528ec4ed810e','cbe8d4ea-a3b3-4989-b2dd-3c025ae28cbb','2025-11-29 08:03:45',NULL,'DELETE','COMPLETE','RemoteStackTest-1685272545-my_stack-nbddbdzpg2yd','cbe8d4ea-a3b3-4989-b2dd-3c025ae28cbb','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1111,'b2f5d060-0352-47a5-bb32-f333b1292366','698a4d18-52b3-4488-a9df-df538a65bd4e','2025-11-29 08:03:46',NULL,'DELETE','COMPLETE','my_stack','cbe8d4ea-a3b3-4989-b2dd-3c025ae28cbb','state changed','OS::Heat::Stack',NULL,191),(1112,'39ee3e5c-4ff4-484d-81e8-3d99859a5ba9','698a4d18-52b3-4488-a9df-df538a65bd4e','2025-11-29 08:03:47',NULL,'DELETE','COMPLETE','RemoteStackTest-1685272545','698a4d18-52b3-4488-a9df-df538a65bd4e','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1113,'d68d90f5-039c-4d1e-b21c-6bf6c63730ae','aea137db-5659-4d9c-80a7-f2321a093dfa','2025-11-29 08:03:52',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-245857673','aea137db-5659-4d9c-80a7-f2321a093dfa','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1114,'45a99f64-1cd6-4f51-9fd5-c485d63e5fbd','aea137db-5659-4d9c-80a7-f2321a093dfa','2025-11-29 08:03:59',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-245857673-config-kry55rqemw7x','state changed','OS::Heat::SoftwareConfig',NULL,215),(1115,'5f675507-5e4f-46fd-bb43-fdf32692e71d','73a6c620-ee95-4d5e-a4c2-86ec10991d07','2025-11-29 08:03:59',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-680695782','73a6c620-ee95-4d5e-a4c2-86ec10991d07','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1116,'28f9e7a4-0ff4-41d1-8217-623c1625e6ca','aea137db-5659-4d9c-80a7-f2321a093dfa','2025-11-29 08:04:00',NULL,'CREATE','COMPLETE','config','37f20d01-5fce-48b8-9805-538317e2cb07','state changed','OS::Heat::SoftwareConfig',NULL,215),(1117,'28dcd656-dec5-4fbc-9cd7-09522529373b','60f70945-fc34-4ddf-ba3a-6f4df6651301','2025-11-29 08:04:00',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-1393600846','60f70945-fc34-4ddf-ba3a-6f4df6651301','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1118,'79660e84-8373-4873-9db6-5d03c6a5a375','aea137db-5659-4d9c-80a7-f2321a093dfa','2025-11-29 08:04:00',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-245857673-dep_2-lsz6fxh4ue35','state changed','OS::Heat::SoftwareDeployments',NULL,216),(1119,'010b4c7e-f867-43a0-bf10-6d4347f75070','aea137db-5659-4d9c-80a7-f2321a093dfa','2025-11-29 08:04:00',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-245857673-dep_0-cj6coiutvkmw','state changed','OS::Heat::SoftwareDeployments',NULL,217),(1120,'baf61652-8e1c-4757-aefe-fd0cc419af02','aea137db-5659-4d9c-80a7-f2321a093dfa','2025-11-29 08:04:00',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-245857673-dep_1-hy56kypba6ug','state changed','OS::Heat::SoftwareDeployments',NULL,218),(1121,'da87d91d-0611-4874-a04c-034633b5ea65','73a6c620-ee95-4d5e-a4c2-86ec10991d07','2025-11-29 08:04:01',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-680695782-config-iy4uvwnjjweb','state changed','OS::Heat::SoftwareConfig',NULL,219),(1122,'13c797f4-c41a-4b01-9b89-0ec13cfed93a','9954bf70-5402-497d-b3cc-4a80f94af7da','2025-11-29 08:04:01',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-245857673-dep_2-lsz6fxh4ue35','9954bf70-5402-497d-b3cc-4a80f94af7da','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1123,'cad2ac96-89f0-436b-a784-5fb721fea3aa','45e4135c-30a1-46ab-b404-3086a3ed9150','2025-11-29 08:04:01',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-245857673-dep_0-cj6coiutvkmw','45e4135c-30a1-46ab-b404-3086a3ed9150','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1124,'1f3fbfb3-50a1-4ced-b68d-a06b3727f8d5','60f70945-fc34-4ddf-ba3a-6f4df6651301','2025-11-29 08:04:01',NULL,'CREATE','IN_PROGRESS','my_stack','RemoteStackTest-1393600846-my_stack-c7tltrj43yhk','state changed','OS::Heat::Stack',NULL,220),(1125,'5dcbf8c8-54ee-4165-9d6c-eb44be4feaae','73a6c620-ee95-4d5e-a4c2-86ec10991d07','2025-11-29 08:04:02',NULL,'CREATE','COMPLETE','config','646db66a-5ceb-4418-8336-f754e5e5cbeb','state changed','OS::Heat::SoftwareConfig',NULL,219),(1126,'f72247fc-e6e7-4947-83f1-bc040158c047','c33bff2c-2673-417a-8364-e01452b6c535','2025-11-29 08:04:02',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-245857673-dep_1-hy56kypba6ug','c33bff2c-2673-417a-8364-e01452b6c535','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1127,'bfe46355-e2f9-40d3-9b43-6dd875b81977','ab350b0e-eb44-40a7-aa50-d6ed0d0308cd','2025-11-29 08:04:02',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1562438676','ab350b0e-eb44-40a7-aa50-d6ed0d0308cd','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1128,'4e3a0cc7-6592-43ab-af53-9566ff55baa6','73a6c620-ee95-4d5e-a4c2-86ec10991d07','2025-11-29 08:04:02',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-680695782-dep_1-4u3o3v7oarfl','state changed','OS::Heat::SoftwareDeployments',NULL,222),(1129,'d99e878a-6059-4238-9ad2-0c67b22e0510','45e4135c-30a1-46ab-b404-3086a3ed9150','2025-11-29 08:04:03',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-245857673-dep_0-cj6coiutvkmw-0-hcy4id7zkfin','state changed','OS::Heat::SoftwareDeployment',NULL,221),(1130,'47ea6f5f-391b-4538-b0e9-79f8fcb4d927','9954bf70-5402-497d-b3cc-4a80f94af7da','2025-11-29 08:04:03',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-245857673-dep_2-lsz6fxh4ue35-0-y5fogtcewib7','state changed','OS::Heat::SoftwareDeployment',NULL,223),(1131,'a3fe5877-9104-44b9-b79d-2a7aec10c1b8','73a6c620-ee95-4d5e-a4c2-86ec10991d07','2025-11-29 08:04:03',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-680695782-dep_2-igespcbfcpqk','state changed','OS::Heat::SoftwareDeployments',NULL,224),(1132,'9f93a832-1b86-4145-89bb-df3f15f1df2a','73a6c620-ee95-4d5e-a4c2-86ec10991d07','2025-11-29 08:04:03',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-680695782-dep_0-6ftgcyagesa5','state changed','OS::Heat::SoftwareDeployments',NULL,225),(1133,'331bdfec-e796-4b74-baf4-a81cfb475588','c33bff2c-2673-417a-8364-e01452b6c535','2025-11-29 08:04:03',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-245857673-dep_1-hy56kypba6ug-0-7s6tz34tdlp6','state changed','OS::Heat::SoftwareDeployment',NULL,226),(1134,'78d43cff-1172-4f22-a957-0ccded72fe42','de771d75-1bfe-417e-b205-8990547089ca','2025-11-29 08:04:03',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-680695782-dep_1-4u3o3v7oarfl','de771d75-1bfe-417e-b205-8990547089ca','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1135,'265e18cf-c7dc-464a-a393-52f4f4add4b4','d1f33fb7-2f7f-45b6-ab3e-3e0d309ff8d8','2025-11-29 08:04:03',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-680695782-dep_0-6ftgcyagesa5','d1f33fb7-2f7f-45b6-ab3e-3e0d309ff8d8','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1136,'0502f2ec-9866-4b44-98df-695617898189','e4fa3010-e06b-4360-9335-0afa7b4cb6ad','2025-11-29 08:04:03',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-680695782-dep_2-igespcbfcpqk','e4fa3010-e06b-4360-9335-0afa7b4cb6ad','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1137,'dee6846c-7f1f-48a1-a506-e6aa0b709ab6','de771d75-1bfe-417e-b205-8990547089ca','2025-11-29 08:04:03',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-680695782-dep_1-4u3o3v7oarfl-0-2y5r67vv6f7p','state changed','OS::Heat::SoftwareDeployment',NULL,227),(1138,'975e2d31-bb16-4c0f-80d1-7350a8172404','ab350b0e-eb44-40a7-aa50-d6ed0d0308cd','2025-11-29 08:04:03',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-1562438676-config-eub743yx242q','state changed','OS::Heat::SoftwareConfig',NULL,228),(1139,'f3afd216-e677-438d-b822-a319a7e07dde','d1f33fb7-2f7f-45b6-ab3e-3e0d309ff8d8','2025-11-29 08:04:03',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-680695782-dep_0-6ftgcyagesa5-0-ggbhdpsqphwy','state changed','OS::Heat::SoftwareDeployment',NULL,229),(1140,'ef294be3-c72d-4c31-9b6b-de57d4a1a13c','e4fa3010-e06b-4360-9335-0afa7b4cb6ad','2025-11-29 08:04:03',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-680695782-dep_2-igespcbfcpqk-0-4uj2bydhp7kg','state changed','OS::Heat::SoftwareDeployment',NULL,230),(1141,'52fb3337-ec62-4127-8c4a-ef3cad607b83','ab350b0e-eb44-40a7-aa50-d6ed0d0308cd','2025-11-29 08:04:03',NULL,'CREATE','COMPLETE','config','e2fdc8b2-5424-4e7c-85a2-989e134c1407','state changed','OS::Heat::SoftwareConfig',NULL,228),(1142,'a558efd6-af10-4774-b3c5-739b17b00238','ab350b0e-eb44-40a7-aa50-d6ed0d0308cd','2025-11-29 08:04:03',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-1562438676-dep_1-yup4w47j35lv','state changed','OS::Heat::SoftwareDeployments',NULL,231),(1143,'3092d38f-c438-43c2-8374-1a16f9fbcf03','ab350b0e-eb44-40a7-aa50-d6ed0d0308cd','2025-11-29 08:04:04',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-1562438676-dep_2-czmur4d7m73n','state changed','OS::Heat::SoftwareDeployments',NULL,232),(1144,'f98edc94-3ace-48a8-8899-a8b624b3dd8f','ab350b0e-eb44-40a7-aa50-d6ed0d0308cd','2025-11-29 08:04:04',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-1562438676-dep_0-d4rtu4k5nihb','state changed','OS::Heat::SoftwareDeployments',NULL,233),(1145,'d9831b00-24c3-4c74-b311-5226abc6b94e','3376802c-710f-4d5d-9456-14991af9dd93','2025-11-29 08:04:04',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1562438676-dep_1-yup4w47j35lv','3376802c-710f-4d5d-9456-14991af9dd93','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1146,'601bc885-3d46-4b53-85c4-dccf71856631','46ac4298-6d0b-43ae-aff5-d73b8e6ab472','2025-11-29 08:04:04',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1562438676-dep_2-czmur4d7m73n','46ac4298-6d0b-43ae-aff5-d73b8e6ab472','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1147,'a7f4a5d1-7386-42b3-8f11-a8807f1810b8','fb5263ef-580a-4246-bce5-72b6941b9921','2025-11-29 08:04:04',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-1393600846-my_stack-c7tltrj43yhk','fb5263ef-580a-4246-bce5-72b6941b9921','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1148,'b197b866-b6f6-4380-b5cf-1eed60534be3','ea56a4a0-2140-4bc7-b725-1f1c485480de','2025-11-29 08:04:04',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1562438676-dep_0-d4rtu4k5nihb','ea56a4a0-2140-4bc7-b725-1f1c485480de','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1149,'896fd991-a498-4a34-ae97-ad10c1fd4635','3376802c-710f-4d5d-9456-14991af9dd93','2025-11-29 08:04:04',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1562438676-dep_1-yup4w47j35lv-0-kzykkhbvk4jw','state changed','OS::Heat::SoftwareDeployment',NULL,234),(1150,'0573911b-17f4-4bfd-812b-ad8685166334','46ac4298-6d0b-43ae-aff5-d73b8e6ab472','2025-11-29 08:04:04',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1562438676-dep_2-czmur4d7m73n-0-7ngdxudknlbq','state changed','OS::Heat::SoftwareDeployment',NULL,235),(1151,'a6aca4a9-8a73-4548-b3c7-b2227b69f012','fb5263ef-580a-4246-bce5-72b6941b9921','2025-11-29 08:04:04',NULL,'CREATE','IN_PROGRESS','random1','RemoteStackTest-1393600846-my_stack-c7tltrj43yhk-random1-a6ta33xebqt4','state changed','OS::Heat::RandomString',NULL,NULL),(1152,'264535d7-202a-49b8-8a47-2a08420e39a5','fb5263ef-580a-4246-bce5-72b6941b9921','2025-11-29 08:04:04',NULL,'CREATE','COMPLETE','random1','RemoteStackTest-1393600846-my_stack-c7tltrj43yhk-random1-a6ta33xebqt4','state changed','OS::Heat::RandomString',NULL,NULL),(1153,'62d63e46-4ce1-403d-aa60-bec6e8426b10','fb5263ef-580a-4246-bce5-72b6941b9921','2025-11-29 08:04:04',NULL,'CREATE','COMPLETE','RemoteStackTest-1393600846-my_stack-c7tltrj43yhk','fb5263ef-580a-4246-bce5-72b6941b9921','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1154,'2ead7fea-491f-47a7-9e2d-0ebfb12b2ffd','ea56a4a0-2140-4bc7-b725-1f1c485480de','2025-11-29 08:04:04',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1562438676-dep_0-d4rtu4k5nihb-0-bvh4itw6vtdz','state changed','OS::Heat::SoftwareDeployment',NULL,236),(1155,'839ec8e8-041a-4ca8-bcfd-80288492cfa7','60f70945-fc34-4ddf-ba3a-6f4df6651301','2025-11-29 08:04:05',NULL,'CREATE','COMPLETE','my_stack','fb5263ef-580a-4246-bce5-72b6941b9921','state changed','OS::Heat::Stack',NULL,220),(1156,'69fadd5a-2ee9-4c59-8c21-9468c93fbef0','60f70945-fc34-4ddf-ba3a-6f4df6651301','2025-11-29 08:04:05',NULL,'CREATE','COMPLETE','RemoteStackTest-1393600846','60f70945-fc34-4ddf-ba3a-6f4df6651301','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1157,'98031fbf-af7a-4bc1-8376-447f0b0dec8a','60f70945-fc34-4ddf-ba3a-6f4df6651301','2025-11-29 08:04:06',NULL,'SUSPEND','IN_PROGRESS','RemoteStackTest-1393600846','60f70945-fc34-4ddf-ba3a-6f4df6651301','Stack SUSPEND started','OS::Heat::Stack',NULL,NULL),(1158,'eedc7868-bb99-486e-a0c4-7628e5c2164c','60f70945-fc34-4ddf-ba3a-6f4df6651301','2025-11-29 08:04:06',NULL,'SUSPEND','IN_PROGRESS','my_stack','fb5263ef-580a-4246-bce5-72b6941b9921','state changed','OS::Heat::Stack',NULL,220),(1159,'17ae0476-c4dd-4ad4-a570-11f6e75d3e5a','fb5263ef-580a-4246-bce5-72b6941b9921','2025-11-29 08:04:06',NULL,'SUSPEND','IN_PROGRESS','RemoteStackTest-1393600846-my_stack-c7tltrj43yhk','fb5263ef-580a-4246-bce5-72b6941b9921','Stack SUSPEND started','OS::Heat::Stack',NULL,NULL),(1160,'2e47cb59-8884-436e-861b-2ab0b88acee3','fb5263ef-580a-4246-bce5-72b6941b9921','2025-11-29 08:04:06',NULL,'SUSPEND','IN_PROGRESS','random1','RemoteStackTest-1393600846-my_stack-c7tltrj43yhk-random1-a6ta33xebqt4','state changed','OS::Heat::RandomString',NULL,NULL),(1161,'fdcfe60b-4c6b-4a94-9c33-27f131ad3e3b','fb5263ef-580a-4246-bce5-72b6941b9921','2025-11-29 08:04:06',NULL,'SUSPEND','COMPLETE','random1','RemoteStackTest-1393600846-my_stack-c7tltrj43yhk-random1-a6ta33xebqt4','state changed','OS::Heat::RandomString',NULL,NULL),(1162,'302ead25-9b07-440d-9728-2b0a119234a4','fb5263ef-580a-4246-bce5-72b6941b9921','2025-11-29 08:04:06',NULL,'SUSPEND','COMPLETE','RemoteStackTest-1393600846-my_stack-c7tltrj43yhk','fb5263ef-580a-4246-bce5-72b6941b9921','Stack SUSPEND completed successfully','OS::Heat::Stack',NULL,NULL),(1163,'d6ecede7-a782-4ab3-9b4e-16294541817c','60f70945-fc34-4ddf-ba3a-6f4df6651301','2025-11-29 08:04:07',NULL,'SUSPEND','COMPLETE','my_stack','fb5263ef-580a-4246-bce5-72b6941b9921','state changed','OS::Heat::Stack',NULL,220),(1164,'bcf028cd-1db1-48ef-906a-eeb0bf1749d7','60f70945-fc34-4ddf-ba3a-6f4df6651301','2025-11-29 08:04:07',NULL,'SUSPEND','COMPLETE','RemoteStackTest-1393600846','60f70945-fc34-4ddf-ba3a-6f4df6651301','Stack SUSPEND completed successfully','OS::Heat::Stack',NULL,NULL),(1165,'52a211fb-69c0-4de8-9d81-087d43f2d73b','46ac4298-6d0b-43ae-aff5-d73b8e6ab472','2025-11-29 08:04:09',NULL,'SIGNAL','IN_PROGRESS','0','64b1363e-0262-4840-8605-dc6d363a28c2','Signal: deployment 64b1363e-0262-4840-8605-dc6d363a28c2 succeeded','OS::Heat::SoftwareDeployment',NULL,235),(1166,'eb10e5f1-910a-486f-af4c-1c3d13aa0958','46ac4298-6d0b-43ae-aff5-d73b8e6ab472','2025-11-29 08:04:10',NULL,'CREATE','COMPLETE','0','64b1363e-0262-4840-8605-dc6d363a28c2','state changed','OS::Heat::SoftwareDeployment',NULL,235),(1167,'2a68ee3c-0cdd-4434-938e-3ff82c6e59ca','46ac4298-6d0b-43ae-aff5-d73b8e6ab472','2025-11-29 08:04:10',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1562438676-dep_2-czmur4d7m73n','46ac4298-6d0b-43ae-aff5-d73b8e6ab472','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1168,'cc428632-f1eb-42bb-bcb2-4f482c61b027','3376802c-710f-4d5d-9456-14991af9dd93','2025-11-29 08:04:12',NULL,'SIGNAL','IN_PROGRESS','0','e645a287-f96b-462c-8e47-8714dfc922a3','Signal: deployment e645a287-f96b-462c-8e47-8714dfc922a3 succeeded','OS::Heat::SoftwareDeployment',NULL,234),(1169,'9d9d947c-b549-41b1-ab82-f335de3a8584','ab350b0e-eb44-40a7-aa50-d6ed0d0308cd','2025-11-29 08:04:12',NULL,'CREATE','COMPLETE','dep_2','46ac4298-6d0b-43ae-aff5-d73b8e6ab472','state changed','OS::Heat::SoftwareDeployments',NULL,232),(1170,'a962aa21-2459-4284-a5c0-32e64c506d14','ea56a4a0-2140-4bc7-b725-1f1c485480de','2025-11-29 08:04:12',NULL,'SIGNAL','IN_PROGRESS','0','f3dfa6aa-7cea-4821-ad18-79816b86835a','Signal: deployment f3dfa6aa-7cea-4821-ad18-79816b86835a succeeded','OS::Heat::SoftwareDeployment',NULL,236),(1171,'e5963986-b88a-484a-850d-4f25e98cabc7','3376802c-710f-4d5d-9456-14991af9dd93','2025-11-29 08:04:12',NULL,'CREATE','COMPLETE','0','e645a287-f96b-462c-8e47-8714dfc922a3','state changed','OS::Heat::SoftwareDeployment',NULL,234),(1172,'901d10b1-87ed-480d-94ff-a4564b8efe85','3376802c-710f-4d5d-9456-14991af9dd93','2025-11-29 08:04:13',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1562438676-dep_1-yup4w47j35lv','3376802c-710f-4d5d-9456-14991af9dd93','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1173,'aa9e1e60-c7fe-4867-afb9-37fed57c9aac','e610242b-2f0d-4066-b73a-b387588fc139','2025-11-29 08:04:13',NULL,'SIGNAL','IN_PROGRESS','0','37eb5f94-3c45-4e91-a17f-8899eba0d53d','Signal: deployment 37eb5f94-3c45-4e91-a17f-8899eba0d53d succeeded','OS::Heat::SoftwareDeployment',NULL,211),(1174,'f049a5cf-f6c3-43d7-8524-dd23810df690','ea56a4a0-2140-4bc7-b725-1f1c485480de','2025-11-29 08:04:14',NULL,'CREATE','COMPLETE','0','f3dfa6aa-7cea-4821-ad18-79816b86835a','state changed','OS::Heat::SoftwareDeployment',NULL,236),(1175,'ea3004e2-1d67-4f3a-8e98-52029eb94dd5','e610242b-2f0d-4066-b73a-b387588fc139','2025-11-29 08:04:14',NULL,'CREATE','COMPLETE','0','37eb5f94-3c45-4e91-a17f-8899eba0d53d','state changed','OS::Heat::SoftwareDeployment',NULL,211),(1176,'7ea23b27-7105-48d7-b2cf-7f1c56180663','60f70945-fc34-4ddf-ba3a-6f4df6651301','2025-11-29 08:04:14',NULL,'RESUME','IN_PROGRESS','RemoteStackTest-1393600846','60f70945-fc34-4ddf-ba3a-6f4df6651301','Stack RESUME started','OS::Heat::Stack',NULL,NULL),(1177,'ab7ff50b-6b1e-4c37-b7f5-bf4983525d6e','e610242b-2f0d-4066-b73a-b387588fc139','2025-11-29 08:04:14',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1812906045-dep_0-mhxmhs24l5sk','e610242b-2f0d-4066-b73a-b387588fc139','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1178,'130dbde9-1187-4e2c-b85e-84b57fedb36b','60f70945-fc34-4ddf-ba3a-6f4df6651301','2025-11-29 08:04:14',NULL,'RESUME','IN_PROGRESS','my_stack','fb5263ef-580a-4246-bce5-72b6941b9921','state changed','OS::Heat::Stack',NULL,220),(1179,'110fd896-b6fc-418f-a92b-76a4bc15be2c','ea56a4a0-2140-4bc7-b725-1f1c485480de','2025-11-29 08:04:14',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1562438676-dep_0-d4rtu4k5nihb','ea56a4a0-2140-4bc7-b725-1f1c485480de','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1180,'a17c398a-276c-43a5-be0f-1d72dca989c9','bdcc5205-74e8-46cd-9202-9d582efbba8a','2025-11-29 08:04:14',NULL,'SIGNAL','IN_PROGRESS','0','fad87c41-ae7e-40b7-8e78-6f989998588e','Signal: deployment fad87c41-ae7e-40b7-8e78-6f989998588e succeeded','OS::Heat::SoftwareDeployment',NULL,210),(1181,'4e32afe5-2392-4427-a416-1e411ba91e6e','fb5263ef-580a-4246-bce5-72b6941b9921','2025-11-29 08:04:14',NULL,'RESUME','IN_PROGRESS','RemoteStackTest-1393600846-my_stack-c7tltrj43yhk','fb5263ef-580a-4246-bce5-72b6941b9921','Stack RESUME started','OS::Heat::Stack',NULL,NULL),(1182,'230174ae-908b-49d8-9627-da57a4da214a','fb5263ef-580a-4246-bce5-72b6941b9921','2025-11-29 08:04:14',NULL,'RESUME','IN_PROGRESS','random1','RemoteStackTest-1393600846-my_stack-c7tltrj43yhk-random1-a6ta33xebqt4','state changed','OS::Heat::RandomString',NULL,NULL),(1183,'e1d2a8ed-0e36-4437-a2b8-0e4c924525c1','fb5263ef-580a-4246-bce5-72b6941b9921','2025-11-29 08:04:14',NULL,'RESUME','COMPLETE','random1','RemoteStackTest-1393600846-my_stack-c7tltrj43yhk-random1-a6ta33xebqt4','state changed','OS::Heat::RandomString',NULL,NULL),(1184,'31f9ca83-5d89-4d87-be78-4803ae3c6c17','fb5263ef-580a-4246-bce5-72b6941b9921','2025-11-29 08:04:14',NULL,'RESUME','COMPLETE','RemoteStackTest-1393600846-my_stack-c7tltrj43yhk','fb5263ef-580a-4246-bce5-72b6941b9921','Stack RESUME completed successfully','OS::Heat::Stack',NULL,NULL),(1185,'a6e76726-a97b-454e-9659-b93a4ac368c9','60f70945-fc34-4ddf-ba3a-6f4df6651301','2025-11-29 08:04:14',NULL,'RESUME','COMPLETE','my_stack','fb5263ef-580a-4246-bce5-72b6941b9921','state changed','OS::Heat::Stack',NULL,220),(1186,'0bffeb3a-da8e-43c9-8763-99708b2cbda3','60f70945-fc34-4ddf-ba3a-6f4df6651301','2025-11-29 08:04:14',NULL,'RESUME','COMPLETE','RemoteStackTest-1393600846','60f70945-fc34-4ddf-ba3a-6f4df6651301','Stack RESUME completed successfully','OS::Heat::Stack',NULL,NULL),(1187,'59a7eaa8-3941-4a3f-92d0-608a81716fa7','ab350b0e-eb44-40a7-aa50-d6ed0d0308cd','2025-11-29 08:04:14',NULL,'CREATE','COMPLETE','dep_1','3376802c-710f-4d5d-9456-14991af9dd93','state changed','OS::Heat::SoftwareDeployments',NULL,231),(1188,'24d33b38-b209-41f6-915d-3ec377ee1419','5db7721f-ff92-4146-b2f3-2cd63ad458b0','2025-11-29 08:04:14',NULL,'CREATE','COMPLETE','dep_0','e610242b-2f0d-4066-b73a-b387588fc139','state changed','OS::Heat::SoftwareDeployments',NULL,206),(1189,'753314ef-db51-44a2-8314-a3205eef964f','bdcc5205-74e8-46cd-9202-9d582efbba8a','2025-11-29 08:04:14',NULL,'CREATE','COMPLETE','0','fad87c41-ae7e-40b7-8e78-6f989998588e','state changed','OS::Heat::SoftwareDeployment',NULL,210),(1190,'5963d144-9577-4626-9a2c-484572056e59','bdcc5205-74e8-46cd-9202-9d582efbba8a','2025-11-29 08:04:14',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1812906045-dep_3-lylj7p3chgsx','bdcc5205-74e8-46cd-9202-9d582efbba8a','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1191,'23b2cea5-37c5-4278-a488-9d2a7314387f','ab350b0e-eb44-40a7-aa50-d6ed0d0308cd','2025-11-29 08:04:15',NULL,'CREATE','COMPLETE','dep_0','ea56a4a0-2140-4bc7-b725-1f1c485480de','state changed','OS::Heat::SoftwareDeployments',NULL,233),(1192,'a3853475-c939-44ff-b766-a8badbd7e28f','ab350b0e-eb44-40a7-aa50-d6ed0d0308cd','2025-11-29 08:04:15',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1562438676','ab350b0e-eb44-40a7-aa50-d6ed0d0308cd','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1193,'bdd8c073-a382-4133-88a4-e000a1221ef5','b23e6104-f9a1-4c0c-b568-750cf917ffea','2025-11-29 08:04:15',NULL,'SIGNAL','IN_PROGRESS','0','285cf42e-9cc0-4222-957f-0b245af7f5db','Signal: deployment 285cf42e-9cc0-4222-957f-0b245af7f5db succeeded','OS::Heat::SoftwareDeployment',NULL,214),(1194,'4fe0c483-91c9-44c3-b7fc-f1291a6bdaf0','5db7721f-ff92-4146-b2f3-2cd63ad458b0','2025-11-29 08:04:15',NULL,'CREATE','COMPLETE','dep_3','bdcc5205-74e8-46cd-9202-9d582efbba8a','state changed','OS::Heat::SoftwareDeployments',NULL,205),(1195,'3a5b38a4-7c97-4a9f-b15e-c625a1b941c9','43c98f02-b41d-4bfa-a1ce-6f71b8dc3fb7','2025-11-29 08:04:16',NULL,'SIGNAL','IN_PROGRESS','0','6a9dc6d1-cff3-49f3-a1c8-b60f78ef02bf','Signal: deployment 6a9dc6d1-cff3-49f3-a1c8-b60f78ef02bf succeeded','OS::Heat::SoftwareDeployment',NULL,212),(1196,'a5c26f05-f577-4848-bc67-e02c1e3fc0a2','6195a7ad-12b9-4ace-b439-53011ad6d6fe','2025-11-29 08:04:16',NULL,'SIGNAL','IN_PROGRESS','0','9799220f-671c-4681-a5c2-2864f7053941','Signal: deployment 9799220f-671c-4681-a5c2-2864f7053941 succeeded','OS::Heat::SoftwareDeployment',NULL,213),(1197,'239b4710-c672-48f6-b0d4-622229bce191','b23e6104-f9a1-4c0c-b568-750cf917ffea','2025-11-29 08:04:16',NULL,'CREATE','COMPLETE','0','285cf42e-9cc0-4222-957f-0b245af7f5db','state changed','OS::Heat::SoftwareDeployment',NULL,214),(1198,'d128edea-41bb-4658-867b-6065d47cf95d','b23e6104-f9a1-4c0c-b568-750cf917ffea','2025-11-29 08:04:16',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1812906045-dep_1-soujsdl7qnpy','b23e6104-f9a1-4c0c-b568-750cf917ffea','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1199,'962801f6-4d94-4ea4-b560-97c2f8da55ff','6195a7ad-12b9-4ace-b439-53011ad6d6fe','2025-11-29 08:04:17',NULL,'CREATE','COMPLETE','0','9799220f-671c-4681-a5c2-2864f7053941','state changed','OS::Heat::SoftwareDeployment',NULL,213),(1200,'e4ce349d-eac0-4a68-987e-25583082f6b0','43c98f02-b41d-4bfa-a1ce-6f71b8dc3fb7','2025-11-29 08:04:17',NULL,'CREATE','COMPLETE','0','6a9dc6d1-cff3-49f3-a1c8-b60f78ef02bf','state changed','OS::Heat::SoftwareDeployment',NULL,212),(1201,'33d12a83-9b2f-4b27-badb-a5c07beddf81','43c98f02-b41d-4bfa-a1ce-6f71b8dc3fb7','2025-11-29 08:04:17',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1812906045-dep_2-qbirlrznoxom','43c98f02-b41d-4bfa-a1ce-6f71b8dc3fb7','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1202,'18c70139-b287-4fa8-89ec-bd5c6803bcfc','6195a7ad-12b9-4ace-b439-53011ad6d6fe','2025-11-29 08:04:17',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1812906045-dep_4-aor4tw6nckth','6195a7ad-12b9-4ace-b439-53011ad6d6fe','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1203,'16baa930-ce1a-4116-aef4-e8c9b35a5ad0','c33bff2c-2673-417a-8364-e01452b6c535','2025-11-29 08:04:17',NULL,'SIGNAL','IN_PROGRESS','0','2aec4ab3-cf52-419a-8b1d-d0e34fdfa714','Signal: deployment 2aec4ab3-cf52-419a-8b1d-d0e34fdfa714 succeeded','OS::Heat::SoftwareDeployment',NULL,226),(1204,'c0e73d3c-7ca6-4752-8e82-f263bfe9efee','45e4135c-30a1-46ab-b404-3086a3ed9150','2025-11-29 08:04:17',NULL,'SIGNAL','IN_PROGRESS','0','8c6d79ca-0869-404c-8f89-cbfd5237953d','Signal: deployment 8c6d79ca-0869-404c-8f89-cbfd5237953d succeeded','OS::Heat::SoftwareDeployment',NULL,221),(1205,'949fd473-f9a4-4360-86e4-79a23b2c0722','c33bff2c-2673-417a-8364-e01452b6c535','2025-11-29 08:04:17',NULL,'CREATE','COMPLETE','0','2aec4ab3-cf52-419a-8b1d-d0e34fdfa714','state changed','OS::Heat::SoftwareDeployment',NULL,226),(1206,'2bb56240-7059-4ed8-9b85-324d1300dc89','45e4135c-30a1-46ab-b404-3086a3ed9150','2025-11-29 08:04:17',NULL,'CREATE','COMPLETE','0','8c6d79ca-0869-404c-8f89-cbfd5237953d','state changed','OS::Heat::SoftwareDeployment',NULL,221),(1207,'673bd65f-866a-443e-9421-c993e67e6205','c33bff2c-2673-417a-8364-e01452b6c535','2025-11-29 08:04:17',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-245857673-dep_1-hy56kypba6ug','c33bff2c-2673-417a-8364-e01452b6c535','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1208,'7571cc6f-9aed-4b04-9115-347e44cd82aa','45e4135c-30a1-46ab-b404-3086a3ed9150','2025-11-29 08:04:17',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-245857673-dep_0-cj6coiutvkmw','45e4135c-30a1-46ab-b404-3086a3ed9150','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1209,'b6db364c-4737-4c46-ab29-3f7b3b101d78','9954bf70-5402-497d-b3cc-4a80f94af7da','2025-11-29 08:04:17',NULL,'SIGNAL','IN_PROGRESS','0','e6263932-3807-429a-80f5-5c689b0127b7','Signal: deployment e6263932-3807-429a-80f5-5c689b0127b7 succeeded','OS::Heat::SoftwareDeployment',NULL,223),(1210,'b6ed7abd-a046-4273-bb4e-97c72410b5e5','a1242deb-ef90-41ed-8a55-7ca5d2e883f6','2025-11-29 08:04:17',NULL,'SIGNAL','IN_PROGRESS','0','78940cb9-d3dc-4448-a328-4c19d7026ab7','Signal: deployment 78940cb9-d3dc-4448-a328-4c19d7026ab7 succeeded','OS::Heat::SoftwareDeployment',NULL,199),(1211,'942c2aeb-d868-4924-b47e-bc6322845d47','5db7721f-ff92-4146-b2f3-2cd63ad458b0','2025-11-29 08:04:17',NULL,'CREATE','COMPLETE','dep_2','43c98f02-b41d-4bfa-a1ce-6f71b8dc3fb7','state changed','OS::Heat::SoftwareDeployments',NULL,207),(1212,'7be97f2c-8e5f-468c-a18f-418805c13f14','5b84b18f-a52e-4a03-b039-1827cf7f0eca','2025-11-29 08:04:17',NULL,'SIGNAL','IN_PROGRESS','0','82a48b29-c7b2-45d8-9ed4-8a9ec60b1ab1','Signal: deployment 82a48b29-c7b2-45d8-9ed4-8a9ec60b1ab1 succeeded','OS::Heat::SoftwareDeployment',NULL,200),(1213,'1cece868-77e8-4d2c-bb77-108e58bda27f','5db7721f-ff92-4146-b2f3-2cd63ad458b0','2025-11-29 08:04:17',NULL,'CREATE','COMPLETE','dep_4','6195a7ad-12b9-4ace-b439-53011ad6d6fe','state changed','OS::Heat::SoftwareDeployments',NULL,208),(1214,'ddd2fda7-ceda-4a84-a828-01ad43ede6d9','aea137db-5659-4d9c-80a7-f2321a093dfa','2025-11-29 08:04:17',NULL,'CREATE','COMPLETE','dep_1','c33bff2c-2673-417a-8364-e01452b6c535','state changed','OS::Heat::SoftwareDeployments',NULL,218),(1215,'b10bbc39-8561-4fb8-b7eb-d4d20fa8553c','5db7721f-ff92-4146-b2f3-2cd63ad458b0','2025-11-29 08:04:17',NULL,'CREATE','COMPLETE','dep_1','b23e6104-f9a1-4c0c-b568-750cf917ffea','state changed','OS::Heat::SoftwareDeployments',NULL,209),(1216,'84eb6e12-3c9b-46ff-a452-7df0868f5b4b','5db7721f-ff92-4146-b2f3-2cd63ad458b0','2025-11-29 08:04:18',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1812906045','5db7721f-ff92-4146-b2f3-2cd63ad458b0','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1217,'236c9daf-89b9-4b85-8c69-ed6fccc3dad0','9954bf70-5402-497d-b3cc-4a80f94af7da','2025-11-29 08:04:18',NULL,'CREATE','COMPLETE','0','e6263932-3807-429a-80f5-5c689b0127b7','state changed','OS::Heat::SoftwareDeployment',NULL,223),(1218,'09850122-d2bc-426f-8864-48c34a36fe13','9954bf70-5402-497d-b3cc-4a80f94af7da','2025-11-29 08:04:18',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-245857673-dep_2-lsz6fxh4ue35','9954bf70-5402-497d-b3cc-4a80f94af7da','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1219,'5aa2a941-413a-4b48-9250-306ab3b780b6','5b84b18f-a52e-4a03-b039-1827cf7f0eca','2025-11-29 08:04:18',NULL,'CREATE','COMPLETE','0','82a48b29-c7b2-45d8-9ed4-8a9ec60b1ab1','state changed','OS::Heat::SoftwareDeployment',NULL,200),(1220,'878d7190-fb64-4cd4-b5a3-0a89cd0695d2','a1242deb-ef90-41ed-8a55-7ca5d2e883f6','2025-11-29 08:04:18',NULL,'CREATE','COMPLETE','0','78940cb9-d3dc-4448-a328-4c19d7026ab7','state changed','OS::Heat::SoftwareDeployment',NULL,199),(1221,'ccdf4e3a-67f3-4869-a11b-5afc61856977','5b84b18f-a52e-4a03-b039-1827cf7f0eca','2025-11-29 08:04:18',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-483475472-dep_4-usf4vxnbwgkw','5b84b18f-a52e-4a03-b039-1827cf7f0eca','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1222,'e881cc66-b841-434b-b83d-a77512c9a9e5','a1242deb-ef90-41ed-8a55-7ca5d2e883f6','2025-11-29 08:04:18',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-483475472-dep_0-7afxyxhwrcmy','a1242deb-ef90-41ed-8a55-7ca5d2e883f6','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1223,'1690e98d-44b7-47eb-83c7-8a418710e6eb','10294177-1248-471e-98a7-f30bdd51ed59','2025-11-29 08:04:18',NULL,'SIGNAL','IN_PROGRESS','0','8c157e8a-05c1-4546-8154-a3e59d07ba89','Signal: deployment 8c157e8a-05c1-4546-8154-a3e59d07ba89 succeeded','OS::Heat::SoftwareDeployment',NULL,201),(1224,'aa5b7d29-e126-4bb0-bb38-2b4afae61809','aea137db-5659-4d9c-80a7-f2321a093dfa','2025-11-29 08:04:18',NULL,'CREATE','COMPLETE','dep_0','45e4135c-30a1-46ab-b404-3086a3ed9150','state changed','OS::Heat::SoftwareDeployments',NULL,217),(1225,'a50bb68c-37ad-4576-8fde-f227efaf8bc7','15fa1552-2ea1-4818-adc9-e24ace9a4f26','2025-11-29 08:04:18',NULL,'SIGNAL','IN_PROGRESS','0','af8d6ea3-9fd0-4a63-8bf8-59efb856cb1c','Signal: deployment af8d6ea3-9fd0-4a63-8bf8-59efb856cb1c succeeded','OS::Heat::SoftwareDeployment',NULL,202),(1226,'e5d3d03e-644d-4931-abab-347352e47911','d3c4e302-ce7c-4d43-ada7-5a133e77c465','2025-11-29 08:04:18',NULL,'SIGNAL','IN_PROGRESS','0','c4574913-ac78-4448-98db-b87c23e45adc','Signal: deployment c4574913-ac78-4448-98db-b87c23e45adc succeeded','OS::Heat::SoftwareDeployment',NULL,198),(1227,'068b8ab3-b982-45e4-9f7d-fb47e648e52a','0cb91f56-9f71-4cd3-8bfb-beee945b274d','2025-11-29 08:04:18',NULL,'CREATE','COMPLETE','dep_4','5b84b18f-a52e-4a03-b039-1827cf7f0eca','state changed','OS::Heat::SoftwareDeployments',NULL,194),(1228,'fff00ec2-00f2-4016-8902-92a4e8c6ccf1','de771d75-1bfe-417e-b205-8990547089ca','2025-11-29 08:04:18',NULL,'SIGNAL','IN_PROGRESS','0','4b2307ec-bc88-4438-bc33-87ce4e68fbfa','Signal: deployment 4b2307ec-bc88-4438-bc33-87ce4e68fbfa succeeded','OS::Heat::SoftwareDeployment',NULL,227),(1229,'b434d59b-a6bb-4b7f-801f-e7ffcd3b096b','aea137db-5659-4d9c-80a7-f2321a093dfa','2025-11-29 08:04:18',NULL,'CREATE','COMPLETE','dep_2','9954bf70-5402-497d-b3cc-4a80f94af7da','state changed','OS::Heat::SoftwareDeployments',NULL,216),(1230,'e3eaf446-293f-4f7e-8cce-1986d98ce075','0cb91f56-9f71-4cd3-8bfb-beee945b274d','2025-11-29 08:04:18',NULL,'CREATE','COMPLETE','dep_0','a1242deb-ef90-41ed-8a55-7ca5d2e883f6','state changed','OS::Heat::SoftwareDeployments',NULL,195),(1231,'be1cc547-737e-42d6-a3c2-1f9538915800','aea137db-5659-4d9c-80a7-f2321a093dfa','2025-11-29 08:04:19',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-245857673','aea137db-5659-4d9c-80a7-f2321a093dfa','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1232,'1a475a10-09e5-42f8-8e79-8cbfab167eec','d3c4e302-ce7c-4d43-ada7-5a133e77c465','2025-11-29 08:04:19',NULL,'CREATE','COMPLETE','0','c4574913-ac78-4448-98db-b87c23e45adc','state changed','OS::Heat::SoftwareDeployment',NULL,198),(1233,'1d4a1950-95dc-427c-ae9b-7d56ce1b4afe','10294177-1248-471e-98a7-f30bdd51ed59','2025-11-29 08:04:19',NULL,'CREATE','COMPLETE','0','8c157e8a-05c1-4546-8154-a3e59d07ba89','state changed','OS::Heat::SoftwareDeployment',NULL,201),(1234,'8186e949-b7cb-4ae1-bd83-13726b209d25','15fa1552-2ea1-4818-adc9-e24ace9a4f26','2025-11-29 08:04:19',NULL,'CREATE','COMPLETE','0','af8d6ea3-9fd0-4a63-8bf8-59efb856cb1c','state changed','OS::Heat::SoftwareDeployment',NULL,202),(1235,'b52d9e2f-1009-4da6-bf16-2db469a5bce1','de771d75-1bfe-417e-b205-8990547089ca','2025-11-29 08:04:19',NULL,'CREATE','COMPLETE','0','4b2307ec-bc88-4438-bc33-87ce4e68fbfa','state changed','OS::Heat::SoftwareDeployment',NULL,227),(1236,'82c86d00-9854-4966-b5fc-e5a624198e3d','e4fa3010-e06b-4360-9335-0afa7b4cb6ad','2025-11-29 08:04:19',NULL,'SIGNAL','IN_PROGRESS','0','86f9e72f-b1a7-447e-8398-7d973d6e2b43','Signal: deployment 86f9e72f-b1a7-447e-8398-7d973d6e2b43 succeeded','OS::Heat::SoftwareDeployment',NULL,230),(1237,'d59fc112-39f8-4c4e-8896-dfcc40a4b12d','d1f33fb7-2f7f-45b6-ab3e-3e0d309ff8d8','2025-11-29 08:04:19',NULL,'SIGNAL','IN_PROGRESS','0','6be7de64-172f-4321-a150-0a9a3293c758','Signal: deployment 6be7de64-172f-4321-a150-0a9a3293c758 succeeded','OS::Heat::SoftwareDeployment',NULL,229),(1238,'0bc189f7-4e99-4c6a-ba21-b9f9af43f048','d3c4e302-ce7c-4d43-ada7-5a133e77c465','2025-11-29 08:04:19',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-483475472-dep_3-ghivu5y2ntfz','d3c4e302-ce7c-4d43-ada7-5a133e77c465','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1239,'73972bd9-85ed-4495-aaf5-0836577be796','10294177-1248-471e-98a7-f30bdd51ed59','2025-11-29 08:04:19',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-483475472-dep_1-w6gw36p5e5tm','10294177-1248-471e-98a7-f30bdd51ed59','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1240,'e5b938ec-10c1-4fb0-bab5-7b343c3e0168','de771d75-1bfe-417e-b205-8990547089ca','2025-11-29 08:04:19',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-680695782-dep_1-4u3o3v7oarfl','de771d75-1bfe-417e-b205-8990547089ca','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1241,'daef17c3-2a9f-476e-bf90-88c06ac0c43a','15fa1552-2ea1-4818-adc9-e24ace9a4f26','2025-11-29 08:04:19',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-483475472-dep_2-34jiaunhfhqp','15fa1552-2ea1-4818-adc9-e24ace9a4f26','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1242,'de469fca-793a-410a-a59f-2873eeba3e71','0cb91f56-9f71-4cd3-8bfb-beee945b274d','2025-11-29 08:04:19',NULL,'CREATE','COMPLETE','dep_3','d3c4e302-ce7c-4d43-ada7-5a133e77c465','state changed','OS::Heat::SoftwareDeployments',NULL,193),(1243,'1d38a9aa-bd5d-4bea-bf68-35e021f27db6','73a6c620-ee95-4d5e-a4c2-86ec10991d07','2025-11-29 08:04:19',NULL,'CREATE','COMPLETE','dep_1','de771d75-1bfe-417e-b205-8990547089ca','state changed','OS::Heat::SoftwareDeployments',NULL,222),(1244,'58fd6f65-bcbe-4736-97f8-5ab64613bc01','0cb91f56-9f71-4cd3-8bfb-beee945b274d','2025-11-29 08:04:19',NULL,'CREATE','COMPLETE','dep_1','10294177-1248-471e-98a7-f30bdd51ed59','state changed','OS::Heat::SoftwareDeployments',NULL,197),(1245,'2990ad3a-75b2-46ac-925f-f919eef752d4','0cb91f56-9f71-4cd3-8bfb-beee945b274d','2025-11-29 08:04:19',NULL,'CREATE','COMPLETE','dep_2','15fa1552-2ea1-4818-adc9-e24ace9a4f26','state changed','OS::Heat::SoftwareDeployments',NULL,196),(1246,'57b1b6c1-7410-4b25-863f-434b8c2b3e78','0cb91f56-9f71-4cd3-8bfb-beee945b274d','2025-11-29 08:04:20',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-483475472','0cb91f56-9f71-4cd3-8bfb-beee945b274d','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1247,'0e1540e4-f204-407d-9ee6-ccc62392ab29','60f70945-fc34-4ddf-ba3a-6f4df6651301','2025-11-29 08:04:20',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-1393600846','60f70945-fc34-4ddf-ba3a-6f4df6651301','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1248,'3aaa819b-5ad7-4d29-81c5-a9d014f86e1d','e4fa3010-e06b-4360-9335-0afa7b4cb6ad','2025-11-29 08:04:20',NULL,'CREATE','COMPLETE','0','86f9e72f-b1a7-447e-8398-7d973d6e2b43','state changed','OS::Heat::SoftwareDeployment',NULL,230),(1249,'5410aa80-f7f7-44c7-a6b3-0fd3c48d58f1','d1f33fb7-2f7f-45b6-ab3e-3e0d309ff8d8','2025-11-29 08:04:20',NULL,'CREATE','COMPLETE','0','6be7de64-172f-4321-a150-0a9a3293c758','state changed','OS::Heat::SoftwareDeployment',NULL,229),(1250,'b4d38d4e-8af2-486b-8817-8a7d98bfb01f','e4fa3010-e06b-4360-9335-0afa7b4cb6ad','2025-11-29 08:04:20',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-680695782-dep_2-igespcbfcpqk','e4fa3010-e06b-4360-9335-0afa7b4cb6ad','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1251,'9fb2c8e9-e967-450b-ba16-facab2a152d5','d1f33fb7-2f7f-45b6-ab3e-3e0d309ff8d8','2025-11-29 08:04:20',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-680695782-dep_0-6ftgcyagesa5','d1f33fb7-2f7f-45b6-ab3e-3e0d309ff8d8','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1252,'a997c795-8eaa-493c-ab42-4aa81e7930d2','60f70945-fc34-4ddf-ba3a-6f4df6651301','2025-11-29 08:04:20',NULL,'DELETE','IN_PROGRESS','my_stack','fb5263ef-580a-4246-bce5-72b6941b9921','state changed','OS::Heat::Stack',NULL,220),(1253,'27aaafab-5e1a-40f5-86ec-528cea0dc7d9','73a6c620-ee95-4d5e-a4c2-86ec10991d07','2025-11-29 08:04:21',NULL,'CREATE','COMPLETE','dep_0','d1f33fb7-2f7f-45b6-ab3e-3e0d309ff8d8','state changed','OS::Heat::SoftwareDeployments',NULL,225),(1254,'38ebe706-533b-4e46-beae-92c2656b07fe','73a6c620-ee95-4d5e-a4c2-86ec10991d07','2025-11-29 08:04:21',NULL,'CREATE','COMPLETE','dep_2','e4fa3010-e06b-4360-9335-0afa7b4cb6ad','state changed','OS::Heat::SoftwareDeployments',NULL,224),(1255,'52112e74-188a-4725-ab56-c281a64640a2','fb5263ef-580a-4246-bce5-72b6941b9921','2025-11-29 08:04:21',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-1393600846-my_stack-c7tltrj43yhk','fb5263ef-580a-4246-bce5-72b6941b9921','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1256,'304a5e87-6cd6-489f-b76b-706be8fbec7d','73a6c620-ee95-4d5e-a4c2-86ec10991d07','2025-11-29 08:04:21',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-680695782','73a6c620-ee95-4d5e-a4c2-86ec10991d07','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1257,'cd96bea0-6af7-47f3-bfa0-e48185b8fe4f','fb5263ef-580a-4246-bce5-72b6941b9921','2025-11-29 08:04:22',NULL,'DELETE','IN_PROGRESS','random1','RemoteStackTest-1393600846-my_stack-c7tltrj43yhk-random1-a6ta33xebqt4','state changed','OS::Heat::RandomString',NULL,NULL),(1258,'8408ba15-1919-4c1d-a63d-ece414dba07a','fb5263ef-580a-4246-bce5-72b6941b9921','2025-11-29 08:04:22',NULL,'DELETE','COMPLETE','random1','RemoteStackTest-1393600846-my_stack-c7tltrj43yhk-random1-a6ta33xebqt4','state changed','OS::Heat::RandomString',NULL,NULL),(1259,'f9ade8d0-858b-4aad-ab5c-fe7efb18449e','fb5263ef-580a-4246-bce5-72b6941b9921','2025-11-29 08:04:22',NULL,'DELETE','COMPLETE','RemoteStackTest-1393600846-my_stack-c7tltrj43yhk','fb5263ef-580a-4246-bce5-72b6941b9921','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1260,'450efdd6-e265-457d-8240-09582c48f362','60f70945-fc34-4ddf-ba3a-6f4df6651301','2025-11-29 08:04:22',NULL,'DELETE','COMPLETE','my_stack','fb5263ef-580a-4246-bce5-72b6941b9921','state changed','OS::Heat::Stack',NULL,220),(1261,'b9e0c226-4f32-42cd-9462-f691ebf92afb','60f70945-fc34-4ddf-ba3a-6f4df6651301','2025-11-29 08:04:22',NULL,'DELETE','COMPLETE','RemoteStackTest-1393600846','60f70945-fc34-4ddf-ba3a-6f4df6651301','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1262,'4c3e93a0-0187-4a8a-b5d6-6f7874a56469','ab350b0e-eb44-40a7-aa50-d6ed0d0308cd','2025-11-29 08:04:24',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1562438676','ab350b0e-eb44-40a7-aa50-d6ed0d0308cd','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1263,'0252e6f4-73f8-41c5-a1af-0d91926270e3','ab350b0e-eb44-40a7-aa50-d6ed0d0308cd','2025-11-29 08:04:24',NULL,'DELETE','IN_PROGRESS','dep_1','3376802c-710f-4d5d-9456-14991af9dd93','state changed','OS::Heat::SoftwareDeployments',NULL,231),(1264,'678f775e-47cb-4a8a-9f7a-fd029e17b86a','3376802c-710f-4d5d-9456-14991af9dd93','2025-11-29 08:04:25',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1562438676-dep_1-yup4w47j35lv','3376802c-710f-4d5d-9456-14991af9dd93','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1265,'5fa82bb5-082d-4f0b-b44e-5fc6ff06684e','3376802c-710f-4d5d-9456-14991af9dd93','2025-11-29 08:04:25',NULL,'DELETE','IN_PROGRESS','0','e645a287-f96b-462c-8e47-8714dfc922a3','state changed','OS::Heat::SoftwareDeployment',NULL,234),(1266,'c7bc4dcd-495d-4253-9259-31ff76a3b184','ab350b0e-eb44-40a7-aa50-d6ed0d0308cd','2025-11-29 08:04:26',NULL,'DELETE','IN_PROGRESS','dep_2','46ac4298-6d0b-43ae-aff5-d73b8e6ab472','state changed','OS::Heat::SoftwareDeployments',NULL,232),(1267,'6e992b7b-ee06-4ec0-b4e9-8a9ecf4ede6a','46ac4298-6d0b-43ae-aff5-d73b8e6ab472','2025-11-29 08:04:26',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1562438676-dep_2-czmur4d7m73n','46ac4298-6d0b-43ae-aff5-d73b8e6ab472','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1268,'489934ed-0407-4dfc-886f-26b4d199e4a5','46ac4298-6d0b-43ae-aff5-d73b8e6ab472','2025-11-29 08:04:26',NULL,'DELETE','IN_PROGRESS','0','64b1363e-0262-4840-8605-dc6d363a28c2','state changed','OS::Heat::SoftwareDeployment',NULL,235),(1269,'c8bb2973-c328-40d7-b5af-38898b4c508a','3376802c-710f-4d5d-9456-14991af9dd93','2025-11-29 08:04:26',NULL,'DELETE','COMPLETE','0','e645a287-f96b-462c-8e47-8714dfc922a3','state changed','OS::Heat::SoftwareDeployment',NULL,234),(1270,'47377420-cc2e-419f-a51b-286fbcd79e1f','3376802c-710f-4d5d-9456-14991af9dd93','2025-11-29 08:04:26',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1562438676-dep_1-yup4w47j35lv','3376802c-710f-4d5d-9456-14991af9dd93','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1271,'83bc1642-16d7-4dde-a266-f16d29d352ae','ab350b0e-eb44-40a7-aa50-d6ed0d0308cd','2025-11-29 08:04:27',NULL,'DELETE','COMPLETE','dep_1','3376802c-710f-4d5d-9456-14991af9dd93','state changed','OS::Heat::SoftwareDeployments',NULL,231),(1272,'b3e24f88-3643-4a00-a039-462845d0ccec','ab350b0e-eb44-40a7-aa50-d6ed0d0308cd','2025-11-29 08:04:27',NULL,'DELETE','IN_PROGRESS','dep_0','ea56a4a0-2140-4bc7-b725-1f1c485480de','state changed','OS::Heat::SoftwareDeployments',NULL,233),(1273,'9f494b41-c57d-472d-8b17-acd788623f6b','ea56a4a0-2140-4bc7-b725-1f1c485480de','2025-11-29 08:04:27',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1562438676-dep_0-d4rtu4k5nihb','ea56a4a0-2140-4bc7-b725-1f1c485480de','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1274,'f3cbc497-b59d-4078-9f99-c0aa50866f6a','46ac4298-6d0b-43ae-aff5-d73b8e6ab472','2025-11-29 08:04:27',NULL,'DELETE','COMPLETE','0','64b1363e-0262-4840-8605-dc6d363a28c2','state changed','OS::Heat::SoftwareDeployment',NULL,235),(1275,'2c3829d8-189b-44cb-9502-a76709efffed','8775fc1e-3172-496a-8b10-c310403b6afc','2025-11-29 08:04:27',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-1238946260','8775fc1e-3172-496a-8b10-c310403b6afc','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1276,'5648d48c-d1be-48fd-8048-35b2a1479f95','46ac4298-6d0b-43ae-aff5-d73b8e6ab472','2025-11-29 08:04:27',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1562438676-dep_2-czmur4d7m73n','46ac4298-6d0b-43ae-aff5-d73b8e6ab472','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1277,'651d8a10-147a-48e3-aa99-4b019e17a56d','ea56a4a0-2140-4bc7-b725-1f1c485480de','2025-11-29 08:04:27',NULL,'DELETE','IN_PROGRESS','0','f3dfa6aa-7cea-4821-ad18-79816b86835a','state changed','OS::Heat::SoftwareDeployment',NULL,236),(1278,'026f8afb-a656-4414-b2d6-ed7c0da4673e','8775fc1e-3172-496a-8b10-c310403b6afc','2025-11-29 08:04:27',NULL,'CREATE','IN_PROGRESS','my_stack','RemoteStackTest-1238946260-my_stack-5bbuyx2xi3rh','state changed','OS::Heat::Stack',NULL,237),(1279,'bf4ffcc5-bbbd-4983-80ae-1b13a7b90ed1','ab350b0e-eb44-40a7-aa50-d6ed0d0308cd','2025-11-29 08:04:28',NULL,'DELETE','COMPLETE','dep_2','46ac4298-6d0b-43ae-aff5-d73b8e6ab472','state changed','OS::Heat::SoftwareDeployments',NULL,232),(1280,'972a331a-6c50-4890-85b5-fcf9025fbdbb','ea56a4a0-2140-4bc7-b725-1f1c485480de','2025-11-29 08:04:28',NULL,'DELETE','COMPLETE','0','f3dfa6aa-7cea-4821-ad18-79816b86835a','state changed','OS::Heat::SoftwareDeployment',NULL,236),(1281,'aaa8bf4f-ba2d-4883-a087-ff7982ff1562','ea56a4a0-2140-4bc7-b725-1f1c485480de','2025-11-29 08:04:28',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1562438676-dep_0-d4rtu4k5nihb','ea56a4a0-2140-4bc7-b725-1f1c485480de','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1282,'82831584-20c3-4bb2-bff9-0ba565335229','ab350b0e-eb44-40a7-aa50-d6ed0d0308cd','2025-11-29 08:04:28',NULL,'DELETE','COMPLETE','dep_0','ea56a4a0-2140-4bc7-b725-1f1c485480de','state changed','OS::Heat::SoftwareDeployments',NULL,233),(1283,'a230030c-84ad-4f2e-9821-7700ea6812d8','ab350b0e-eb44-40a7-aa50-d6ed0d0308cd','2025-11-29 08:04:28',NULL,'DELETE','IN_PROGRESS','config','e2fdc8b2-5424-4e7c-85a2-989e134c1407','state changed','OS::Heat::SoftwareConfig',NULL,228),(1284,'95410e27-1d29-47f4-8a74-bd5e70fe13b1','ab350b0e-eb44-40a7-aa50-d6ed0d0308cd','2025-11-29 08:04:28',NULL,'DELETE','COMPLETE','config','e2fdc8b2-5424-4e7c-85a2-989e134c1407','state changed','OS::Heat::SoftwareConfig',NULL,228),(1285,'52b533b0-2dba-45c6-b3f9-8de1c94a14b2','ab350b0e-eb44-40a7-aa50-d6ed0d0308cd','2025-11-29 08:04:28',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1562438676','ab350b0e-eb44-40a7-aa50-d6ed0d0308cd','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1286,'221e094c-c44b-4bd4-b63a-c9436b6eac96','23682f71-2e5b-4cbb-b25a-f3ebaddece4d','2025-11-29 08:04:28',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-1238946260-my_stack-5bbuyx2xi3rh','23682f71-2e5b-4cbb-b25a-f3ebaddece4d','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1287,'4cdff56b-e010-4340-bba4-fabfd183b7ed','23682f71-2e5b-4cbb-b25a-f3ebaddece4d','2025-11-29 08:04:28',NULL,'CREATE','IN_PROGRESS','random1','RemoteStackTest-1238946260-my_stack-5bbuyx2xi3rh-random1-42uiwrttj5oy','state changed','OS::Heat::RandomString',NULL,NULL),(1288,'7a22df06-f94e-4aec-84ac-4f3805ec0251','23682f71-2e5b-4cbb-b25a-f3ebaddece4d','2025-11-29 08:04:28',NULL,'CREATE','COMPLETE','random1','RemoteStackTest-1238946260-my_stack-5bbuyx2xi3rh-random1-42uiwrttj5oy','state changed','OS::Heat::RandomString',NULL,NULL),(1289,'abcdae9e-a955-4c8f-bd01-1b87efc66e5c','23682f71-2e5b-4cbb-b25a-f3ebaddece4d','2025-11-29 08:04:28',NULL,'CREATE','COMPLETE','RemoteStackTest-1238946260-my_stack-5bbuyx2xi3rh','23682f71-2e5b-4cbb-b25a-f3ebaddece4d','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1290,'ae88be0b-f4a9-456a-9986-e96875e8c8f9','8775fc1e-3172-496a-8b10-c310403b6afc','2025-11-29 08:04:29',NULL,'CREATE','COMPLETE','my_stack','23682f71-2e5b-4cbb-b25a-f3ebaddece4d','state changed','OS::Heat::Stack',NULL,237),(1291,'ab2ab534-940d-4b48-b33e-ee3e2f34ece8','8775fc1e-3172-496a-8b10-c310403b6afc','2025-11-29 08:04:29',NULL,'CREATE','COMPLETE','RemoteStackTest-1238946260','8775fc1e-3172-496a-8b10-c310403b6afc','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1292,'4961bdcd-46c5-4970-baea-168946e6b078','73a6c620-ee95-4d5e-a4c2-86ec10991d07','2025-11-29 08:04:34',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-680695782','73a6c620-ee95-4d5e-a4c2-86ec10991d07','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1293,'f13fdc65-da46-446b-ba15-6b9c83fc59cc','73a6c620-ee95-4d5e-a4c2-86ec10991d07','2025-11-29 08:04:34',NULL,'DELETE','IN_PROGRESS','dep_1','de771d75-1bfe-417e-b205-8990547089ca','state changed','OS::Heat::SoftwareDeployments',NULL,222),(1294,'50637b3b-d2e0-4d80-bd1b-3fd1cad5e12a','de771d75-1bfe-417e-b205-8990547089ca','2025-11-29 08:04:34',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-680695782-dep_1-4u3o3v7oarfl','de771d75-1bfe-417e-b205-8990547089ca','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1295,'07ae3de1-0876-4536-81e5-4f5074421a42','de771d75-1bfe-417e-b205-8990547089ca','2025-11-29 08:04:34',NULL,'DELETE','IN_PROGRESS','0','4b2307ec-bc88-4438-bc33-87ce4e68fbfa','state changed','OS::Heat::SoftwareDeployment',NULL,227),(1296,'0f9e0c7e-7ea7-46da-ae24-2d9273216262','8775fc1e-3172-496a-8b10-c310403b6afc','2025-11-29 08:04:35',NULL,'UPDATE','IN_PROGRESS','RemoteStackTest-1238946260','8775fc1e-3172-496a-8b10-c310403b6afc','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1297,'1d885254-2859-407f-b12d-0d1e1fe1df89','8775fc1e-3172-496a-8b10-c310403b6afc','2025-11-29 08:04:35',NULL,'UPDATE','IN_PROGRESS','my_stack','23682f71-2e5b-4cbb-b25a-f3ebaddece4d','state changed','OS::Heat::Stack',NULL,237),(1298,'320653a4-5195-4a52-bf96-d224b2b5221b','73a6c620-ee95-4d5e-a4c2-86ec10991d07','2025-11-29 08:04:35',NULL,'DELETE','IN_PROGRESS','dep_2','e4fa3010-e06b-4360-9335-0afa7b4cb6ad','state changed','OS::Heat::SoftwareDeployments',NULL,224),(1299,'1d665ac2-2b72-43fc-a4f8-796c85dcdbbf','e4fa3010-e06b-4360-9335-0afa7b4cb6ad','2025-11-29 08:04:35',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-680695782-dep_2-igespcbfcpqk','e4fa3010-e06b-4360-9335-0afa7b4cb6ad','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1300,'b42bdd89-3f39-4b95-9b13-41f93e7e87df','23682f71-2e5b-4cbb-b25a-f3ebaddece4d','2025-11-29 08:04:36',NULL,'UPDATE','IN_PROGRESS','RemoteStackTest-1238946260-my_stack-5bbuyx2xi3rh','23682f71-2e5b-4cbb-b25a-f3ebaddece4d','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1301,'ac3c8024-3227-43f1-96dc-cad1fe0db187','e4fa3010-e06b-4360-9335-0afa7b4cb6ad','2025-11-29 08:04:36',NULL,'DELETE','IN_PROGRESS','0','86f9e72f-b1a7-447e-8398-7d973d6e2b43','state changed','OS::Heat::SoftwareDeployment',NULL,230),(1302,'8caf36ad-20e9-41d2-a902-0173ede17b0d','73a6c620-ee95-4d5e-a4c2-86ec10991d07','2025-11-29 08:04:36',NULL,'DELETE','IN_PROGRESS','dep_0','d1f33fb7-2f7f-45b6-ab3e-3e0d309ff8d8','state changed','OS::Heat::SoftwareDeployments',NULL,225),(1303,'a672e491-b4af-456a-b730-07189d1b76bd','23682f71-2e5b-4cbb-b25a-f3ebaddece4d','2025-11-29 08:04:36',NULL,'DELETE','IN_PROGRESS','random1','RemoteStackTest-1238946260-my_stack-5bbuyx2xi3rh-random1-42uiwrttj5oy','state changed','OS::Heat::RandomString',NULL,NULL),(1304,'f457cae4-2d1a-4744-b76f-ad1799a23be9','23682f71-2e5b-4cbb-b25a-f3ebaddece4d','2025-11-29 08:04:36',NULL,'DELETE','COMPLETE','random1','RemoteStackTest-1238946260-my_stack-5bbuyx2xi3rh-random1-42uiwrttj5oy','state changed','OS::Heat::RandomString',NULL,NULL),(1305,'32a94e8d-8ce6-4e1e-9543-a6054bc2bfe4','d1f33fb7-2f7f-45b6-ab3e-3e0d309ff8d8','2025-11-29 08:04:36',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-680695782-dep_0-6ftgcyagesa5','d1f33fb7-2f7f-45b6-ab3e-3e0d309ff8d8','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1306,'f91ef9ff-92c3-47ea-84e3-0b7589c57078','de771d75-1bfe-417e-b205-8990547089ca','2025-11-29 08:04:36',NULL,'DELETE','COMPLETE','0','4b2307ec-bc88-4438-bc33-87ce4e68fbfa','state changed','OS::Heat::SoftwareDeployment',NULL,227),(1307,'e964e239-1fce-4e18-b3b7-2a8a8548800f','de771d75-1bfe-417e-b205-8990547089ca','2025-11-29 08:04:36',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-680695782-dep_1-4u3o3v7oarfl','de771d75-1bfe-417e-b205-8990547089ca','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1308,'b229f6ca-3f88-4004-ba1b-8df7cdd83804','d1f33fb7-2f7f-45b6-ab3e-3e0d309ff8d8','2025-11-29 08:04:37',NULL,'DELETE','IN_PROGRESS','0','6be7de64-172f-4321-a150-0a9a3293c758','state changed','OS::Heat::SoftwareDeployment',NULL,229),(1309,'7d78437f-c779-4ebd-9379-026838207e9a','23682f71-2e5b-4cbb-b25a-f3ebaddece4d','2025-11-29 08:04:37',NULL,'CREATE','IN_PROGRESS','random2','RemoteStackTest-1238946260-my_stack-5bbuyx2xi3rh-random2-76awgpkpautc','state changed','OS::Heat::RandomString',NULL,NULL),(1310,'0723ce24-be47-4340-940f-78018d565dd3','23682f71-2e5b-4cbb-b25a-f3ebaddece4d','2025-11-29 08:04:37',NULL,'CREATE','COMPLETE','random2','RemoteStackTest-1238946260-my_stack-5bbuyx2xi3rh-random2-76awgpkpautc','state changed','OS::Heat::RandomString',NULL,NULL),(1311,'2b347891-a099-4759-b9e7-7ddb3cfec6e3','23682f71-2e5b-4cbb-b25a-f3ebaddece4d','2025-11-29 08:04:37',NULL,'UPDATE','COMPLETE','RemoteStackTest-1238946260-my_stack-5bbuyx2xi3rh','23682f71-2e5b-4cbb-b25a-f3ebaddece4d','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1312,'6430980f-103c-4171-9ab9-e0e297d9df06','73a6c620-ee95-4d5e-a4c2-86ec10991d07','2025-11-29 08:04:37',NULL,'DELETE','COMPLETE','dep_1','de771d75-1bfe-417e-b205-8990547089ca','state changed','OS::Heat::SoftwareDeployments',NULL,222),(1313,'a5fb95b9-3ae4-4431-abca-66081ced22a5','e4fa3010-e06b-4360-9335-0afa7b4cb6ad','2025-11-29 08:04:37',NULL,'DELETE','COMPLETE','0','86f9e72f-b1a7-447e-8398-7d973d6e2b43','state changed','OS::Heat::SoftwareDeployment',NULL,230),(1314,'a9c58428-5852-4a87-a543-5cc7fe2be0ae','d1f33fb7-2f7f-45b6-ab3e-3e0d309ff8d8','2025-11-29 08:04:37',NULL,'DELETE','COMPLETE','0','6be7de64-172f-4321-a150-0a9a3293c758','state changed','OS::Heat::SoftwareDeployment',NULL,229),(1315,'086f0148-6127-4f2f-bd5f-1e27b8386b30','e4fa3010-e06b-4360-9335-0afa7b4cb6ad','2025-11-29 08:04:37',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-680695782-dep_2-igespcbfcpqk','e4fa3010-e06b-4360-9335-0afa7b4cb6ad','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1316,'701abe03-c308-45df-9cd6-e4e6c2f361b3','d1f33fb7-2f7f-45b6-ab3e-3e0d309ff8d8','2025-11-29 08:04:37',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-680695782-dep_0-6ftgcyagesa5','d1f33fb7-2f7f-45b6-ab3e-3e0d309ff8d8','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1317,'eece56a4-c952-4729-bf24-837b57e8f388','73a6c620-ee95-4d5e-a4c2-86ec10991d07','2025-11-29 08:04:37',NULL,'DELETE','COMPLETE','dep_0','d1f33fb7-2f7f-45b6-ab3e-3e0d309ff8d8','state changed','OS::Heat::SoftwareDeployments',NULL,225),(1318,'bf5a17d4-2424-4d25-9187-51d82d5de1ca','8775fc1e-3172-496a-8b10-c310403b6afc','2025-11-29 08:04:38',NULL,'UPDATE','COMPLETE','my_stack','23682f71-2e5b-4cbb-b25a-f3ebaddece4d','state changed','OS::Heat::Stack',NULL,238),(1319,'2c3c5b32-c7aa-4179-a70e-725ba940a315','8775fc1e-3172-496a-8b10-c310403b6afc','2025-11-29 08:04:38',NULL,'UPDATE','COMPLETE','RemoteStackTest-1238946260','8775fc1e-3172-496a-8b10-c310403b6afc','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1320,'cc7b7cb2-b6ab-4a32-bbf4-135022b0490a','73a6c620-ee95-4d5e-a4c2-86ec10991d07','2025-11-29 08:04:38',NULL,'DELETE','COMPLETE','dep_2','e4fa3010-e06b-4360-9335-0afa7b4cb6ad','state changed','OS::Heat::SoftwareDeployments',NULL,224),(1321,'14182eed-cb87-4dce-95ff-9acdd0680aea','73a6c620-ee95-4d5e-a4c2-86ec10991d07','2025-11-29 08:04:38',NULL,'DELETE','IN_PROGRESS','config','646db66a-5ceb-4418-8336-f754e5e5cbeb','state changed','OS::Heat::SoftwareConfig',NULL,219),(1322,'23181b85-c73e-4397-892d-94aa7e13ed89','73a6c620-ee95-4d5e-a4c2-86ec10991d07','2025-11-29 08:04:38',NULL,'DELETE','COMPLETE','config','646db66a-5ceb-4418-8336-f754e5e5cbeb','state changed','OS::Heat::SoftwareConfig',NULL,219),(1323,'66fe6f96-a5af-4447-8e4c-6463abe51a67','73a6c620-ee95-4d5e-a4c2-86ec10991d07','2025-11-29 08:04:38',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-680695782','73a6c620-ee95-4d5e-a4c2-86ec10991d07','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1324,'a239db5d-32cd-4f1c-81c5-193e807ecd26','8775fc1e-3172-496a-8b10-c310403b6afc','2025-11-29 08:04:40',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-1238946260','8775fc1e-3172-496a-8b10-c310403b6afc','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1325,'49fa53f4-7e6f-452b-be5a-cab5516fa841','8775fc1e-3172-496a-8b10-c310403b6afc','2025-11-29 08:04:40',NULL,'DELETE','IN_PROGRESS','my_stack','23682f71-2e5b-4cbb-b25a-f3ebaddece4d','state changed','OS::Heat::Stack',NULL,238),(1326,'95c0e3dd-7a9c-48c1-a911-756797d7085f','23682f71-2e5b-4cbb-b25a-f3ebaddece4d','2025-11-29 08:04:41',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-1238946260-my_stack-5bbuyx2xi3rh','23682f71-2e5b-4cbb-b25a-f3ebaddece4d','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1327,'91f086e1-6436-4470-a507-d20b48677390','23682f71-2e5b-4cbb-b25a-f3ebaddece4d','2025-11-29 08:04:41',NULL,'DELETE','IN_PROGRESS','random2','RemoteStackTest-1238946260-my_stack-5bbuyx2xi3rh-random2-76awgpkpautc','state changed','OS::Heat::RandomString',NULL,NULL),(1328,'b4470372-d027-452d-b386-5668cd0351de','23682f71-2e5b-4cbb-b25a-f3ebaddece4d','2025-11-29 08:04:41',NULL,'DELETE','COMPLETE','random2','RemoteStackTest-1238946260-my_stack-5bbuyx2xi3rh-random2-76awgpkpautc','state changed','OS::Heat::RandomString',NULL,NULL),(1329,'1f18b834-0184-474c-a038-979870fb4933','23682f71-2e5b-4cbb-b25a-f3ebaddece4d','2025-11-29 08:04:41',NULL,'DELETE','COMPLETE','RemoteStackTest-1238946260-my_stack-5bbuyx2xi3rh','23682f71-2e5b-4cbb-b25a-f3ebaddece4d','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1330,'ceb1bdd7-aeb5-4417-a9a7-2f07f9c329e3','8775fc1e-3172-496a-8b10-c310403b6afc','2025-11-29 08:04:41',NULL,'DELETE','COMPLETE','my_stack','23682f71-2e5b-4cbb-b25a-f3ebaddece4d','state changed','OS::Heat::Stack',NULL,238),(1331,'0320ccc7-d492-4a5a-b50b-62e71cf715ee','8775fc1e-3172-496a-8b10-c310403b6afc','2025-11-29 08:04:41',NULL,'DELETE','COMPLETE','RemoteStackTest-1238946260','8775fc1e-3172-496a-8b10-c310403b6afc','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1332,'ab69c38e-ff3a-432a-b7e6-d75a46b70dfe','aea137db-5659-4d9c-80a7-f2321a093dfa','2025-11-29 08:04:43',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-245857673','aea137db-5659-4d9c-80a7-f2321a093dfa','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1333,'581f93c1-091b-4a5b-9921-6ed228d8060c','aea137db-5659-4d9c-80a7-f2321a093dfa','2025-11-29 08:04:43',NULL,'DELETE','IN_PROGRESS','dep_2','9954bf70-5402-497d-b3cc-4a80f94af7da','state changed','OS::Heat::SoftwareDeployments',NULL,216),(1334,'755aec14-3402-4bc8-a2da-d1b46e4f3ba5','9954bf70-5402-497d-b3cc-4a80f94af7da','2025-11-29 08:04:43',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-245857673-dep_2-lsz6fxh4ue35','9954bf70-5402-497d-b3cc-4a80f94af7da','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1335,'1fda020c-f928-4999-846a-f805939d01b0','9954bf70-5402-497d-b3cc-4a80f94af7da','2025-11-29 08:04:43',NULL,'DELETE','IN_PROGRESS','0','e6263932-3807-429a-80f5-5c689b0127b7','state changed','OS::Heat::SoftwareDeployment',NULL,223),(1336,'05047768-1529-40f5-8356-1735559a4b2a','9954bf70-5402-497d-b3cc-4a80f94af7da','2025-11-29 08:04:44',NULL,'DELETE','COMPLETE','0','e6263932-3807-429a-80f5-5c689b0127b7','state changed','OS::Heat::SoftwareDeployment',NULL,223),(1337,'8d6d86bc-0750-415b-b661-7d0e9e23891a','9954bf70-5402-497d-b3cc-4a80f94af7da','2025-11-29 08:04:44',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-245857673-dep_2-lsz6fxh4ue35','9954bf70-5402-497d-b3cc-4a80f94af7da','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1338,'bcdc0c7c-843f-4d61-8f84-bd3993a916b1','aea137db-5659-4d9c-80a7-f2321a093dfa','2025-11-29 08:04:44',NULL,'DELETE','IN_PROGRESS','dep_0','45e4135c-30a1-46ab-b404-3086a3ed9150','state changed','OS::Heat::SoftwareDeployments',NULL,217),(1339,'85e2a2d5-d1ad-4fad-a8dc-8e11edbe7417','45e4135c-30a1-46ab-b404-3086a3ed9150','2025-11-29 08:04:44',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-245857673-dep_0-cj6coiutvkmw','45e4135c-30a1-46ab-b404-3086a3ed9150','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1340,'318d69b2-c288-4352-975c-3a6e305cea83','aea137db-5659-4d9c-80a7-f2321a093dfa','2025-11-29 08:04:44',NULL,'DELETE','COMPLETE','dep_2','9954bf70-5402-497d-b3cc-4a80f94af7da','state changed','OS::Heat::SoftwareDeployments',NULL,216),(1341,'5a6a5ace-93a2-4e6e-9a77-90458c83df22','45e4135c-30a1-46ab-b404-3086a3ed9150','2025-11-29 08:04:44',NULL,'DELETE','IN_PROGRESS','0','8c6d79ca-0869-404c-8f89-cbfd5237953d','state changed','OS::Heat::SoftwareDeployment',NULL,221),(1342,'67eefd50-9cc5-446e-9b0b-f488d0559aaf','45e4135c-30a1-46ab-b404-3086a3ed9150','2025-11-29 08:04:45',NULL,'DELETE','COMPLETE','0','8c6d79ca-0869-404c-8f89-cbfd5237953d','state changed','OS::Heat::SoftwareDeployment',NULL,221),(1343,'3b6993a1-d28a-46da-a6ee-b7826ed3fb7e','45e4135c-30a1-46ab-b404-3086a3ed9150','2025-11-29 08:04:45',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-245857673-dep_0-cj6coiutvkmw','45e4135c-30a1-46ab-b404-3086a3ed9150','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1344,'ab802e7a-2b33-4338-b1bb-652169fb3430','aea137db-5659-4d9c-80a7-f2321a093dfa','2025-11-29 08:04:45',NULL,'DELETE','IN_PROGRESS','dep_1','c33bff2c-2673-417a-8364-e01452b6c535','state changed','OS::Heat::SoftwareDeployments',NULL,218),(1345,'bda8c03c-78b8-44be-9496-6a5d4cf8966a','c33bff2c-2673-417a-8364-e01452b6c535','2025-11-29 08:04:45',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-245857673-dep_1-hy56kypba6ug','c33bff2c-2673-417a-8364-e01452b6c535','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1346,'72d5bf2f-899d-4b49-a9a1-0a084b634ffe','aea137db-5659-4d9c-80a7-f2321a093dfa','2025-11-29 08:04:45',NULL,'DELETE','COMPLETE','dep_0','45e4135c-30a1-46ab-b404-3086a3ed9150','state changed','OS::Heat::SoftwareDeployments',NULL,217),(1347,'935d8322-eb05-42c9-b994-f191f11ec48b','c33bff2c-2673-417a-8364-e01452b6c535','2025-11-29 08:04:45',NULL,'DELETE','IN_PROGRESS','0','2aec4ab3-cf52-419a-8b1d-d0e34fdfa714','state changed','OS::Heat::SoftwareDeployment',NULL,226),(1348,'9eb5504c-23eb-4d42-8175-bb8e78326ca3','c33bff2c-2673-417a-8364-e01452b6c535','2025-11-29 08:04:46',NULL,'DELETE','COMPLETE','0','2aec4ab3-cf52-419a-8b1d-d0e34fdfa714','state changed','OS::Heat::SoftwareDeployment',NULL,226),(1349,'6b8a033c-17da-4e9f-9d8b-c3675eb43a9c','c33bff2c-2673-417a-8364-e01452b6c535','2025-11-29 08:04:46',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-245857673-dep_1-hy56kypba6ug','c33bff2c-2673-417a-8364-e01452b6c535','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1350,'91af39ed-29a6-46f2-ad1f-e8f1a21bf8af','aea137db-5659-4d9c-80a7-f2321a093dfa','2025-11-29 08:04:47',NULL,'DELETE','COMPLETE','dep_1','c33bff2c-2673-417a-8364-e01452b6c535','state changed','OS::Heat::SoftwareDeployments',NULL,218),(1351,'4355490c-69a1-4436-92eb-cc835bb94574','aea137db-5659-4d9c-80a7-f2321a093dfa','2025-11-29 08:04:48',NULL,'DELETE','IN_PROGRESS','config','37f20d01-5fce-48b8-9805-538317e2cb07','state changed','OS::Heat::SoftwareConfig',NULL,215),(1352,'cdcb9c2a-1858-4c70-8e03-f2c7f2620368','aea137db-5659-4d9c-80a7-f2321a093dfa','2025-11-29 08:04:48',NULL,'DELETE','COMPLETE','config','37f20d01-5fce-48b8-9805-538317e2cb07','state changed','OS::Heat::SoftwareConfig',NULL,215),(1353,'6cdf6087-af06-49c0-aa3e-aeb36f761144','aea137db-5659-4d9c-80a7-f2321a093dfa','2025-11-29 08:04:48',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-245857673','aea137db-5659-4d9c-80a7-f2321a093dfa','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1354,'c65f71a5-6f47-43de-bf77-ef235b766f61','5db7721f-ff92-4146-b2f3-2cd63ad458b0','2025-11-29 08:04:53',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1812906045','5db7721f-ff92-4146-b2f3-2cd63ad458b0','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1355,'bef00e3b-6a7e-496a-817f-b4da29b94915','5db7721f-ff92-4146-b2f3-2cd63ad458b0','2025-11-29 08:04:53',NULL,'DELETE','IN_PROGRESS','dep_4','6195a7ad-12b9-4ace-b439-53011ad6d6fe','state changed','OS::Heat::SoftwareDeployments',NULL,208),(1356,'6e26169f-95d0-4905-81cc-325ba567d53e','6195a7ad-12b9-4ace-b439-53011ad6d6fe','2025-11-29 08:04:54',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1812906045-dep_4-aor4tw6nckth','6195a7ad-12b9-4ace-b439-53011ad6d6fe','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1357,'d1208f77-6982-4189-929e-febb2f08ab12','6195a7ad-12b9-4ace-b439-53011ad6d6fe','2025-11-29 08:04:54',NULL,'DELETE','IN_PROGRESS','0','9799220f-671c-4681-a5c2-2864f7053941','state changed','OS::Heat::SoftwareDeployment',NULL,213),(1358,'30bdab08-eb93-4124-85ff-77b036fc0d4d','5db7721f-ff92-4146-b2f3-2cd63ad458b0','2025-11-29 08:04:54',NULL,'DELETE','IN_PROGRESS','dep_3','bdcc5205-74e8-46cd-9202-9d582efbba8a','state changed','OS::Heat::SoftwareDeployments',NULL,205),(1359,'bde3551c-e589-483f-80ba-b270526cea9e','bdcc5205-74e8-46cd-9202-9d582efbba8a','2025-11-29 08:04:54',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1812906045-dep_3-lylj7p3chgsx','bdcc5205-74e8-46cd-9202-9d582efbba8a','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1360,'6e4874b7-0b44-4fcf-92dc-749fb4958575','bdcc5205-74e8-46cd-9202-9d582efbba8a','2025-11-29 08:04:55',NULL,'DELETE','IN_PROGRESS','0','fad87c41-ae7e-40b7-8e78-6f989998588e','state changed','OS::Heat::SoftwareDeployment',NULL,210),(1361,'79bc43c6-85d2-4e39-ad97-3bd2caafc84c','5db7721f-ff92-4146-b2f3-2cd63ad458b0','2025-11-29 08:04:55',NULL,'DELETE','IN_PROGRESS','dep_1','b23e6104-f9a1-4c0c-b568-750cf917ffea','state changed','OS::Heat::SoftwareDeployments',NULL,209),(1362,'e0d255c0-32f8-4878-bbe3-3f7ac0650f28','b23e6104-f9a1-4c0c-b568-750cf917ffea','2025-11-29 08:04:55',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1812906045-dep_1-soujsdl7qnpy','b23e6104-f9a1-4c0c-b568-750cf917ffea','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1363,'3f2b9e9b-350f-4d9a-85a4-f68e39762e1a','b23e6104-f9a1-4c0c-b568-750cf917ffea','2025-11-29 08:04:55',NULL,'DELETE','IN_PROGRESS','0','285cf42e-9cc0-4222-957f-0b245af7f5db','state changed','OS::Heat::SoftwareDeployment',NULL,214),(1364,'2eb64add-558d-4226-afc2-3b34de8ad20d','6195a7ad-12b9-4ace-b439-53011ad6d6fe','2025-11-29 08:04:55',NULL,'DELETE','COMPLETE','0','9799220f-671c-4681-a5c2-2864f7053941','state changed','OS::Heat::SoftwareDeployment',NULL,213),(1365,'e38279d4-c3d5-4b42-8fea-ae2add814579','6195a7ad-12b9-4ace-b439-53011ad6d6fe','2025-11-29 08:04:55',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1812906045-dep_4-aor4tw6nckth','6195a7ad-12b9-4ace-b439-53011ad6d6fe','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1366,'0d9f820b-3aea-43e3-a0bd-c6a780de82fd','bdcc5205-74e8-46cd-9202-9d582efbba8a','2025-11-29 08:04:55',NULL,'DELETE','COMPLETE','0','fad87c41-ae7e-40b7-8e78-6f989998588e','state changed','OS::Heat::SoftwareDeployment',NULL,210),(1367,'22a9dc40-ccb4-4fe8-bb4f-cba66c2db2aa','bdcc5205-74e8-46cd-9202-9d582efbba8a','2025-11-29 08:04:55',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1812906045-dep_3-lylj7p3chgsx','bdcc5205-74e8-46cd-9202-9d582efbba8a','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1368,'6d3c98a4-ad85-434a-915d-8b18610fd5d5','5db7721f-ff92-4146-b2f3-2cd63ad458b0','2025-11-29 08:04:56',NULL,'DELETE','COMPLETE','dep_3','bdcc5205-74e8-46cd-9202-9d582efbba8a','state changed','OS::Heat::SoftwareDeployments',NULL,205),(1369,'921e5533-6bdc-49a5-bd4c-e4f8a4c1d07d','5db7721f-ff92-4146-b2f3-2cd63ad458b0','2025-11-29 08:04:56',NULL,'DELETE','COMPLETE','dep_4','6195a7ad-12b9-4ace-b439-53011ad6d6fe','state changed','OS::Heat::SoftwareDeployments',NULL,208),(1370,'f2b8ae5a-93b8-41fe-bdfd-e0adc18087cf','5db7721f-ff92-4146-b2f3-2cd63ad458b0','2025-11-29 08:04:56',NULL,'DELETE','IN_PROGRESS','dep_0','e610242b-2f0d-4066-b73a-b387588fc139','state changed','OS::Heat::SoftwareDeployments',NULL,206),(1371,'d939c7a7-83d6-4c6c-83d1-6bae302e8998','e610242b-2f0d-4066-b73a-b387588fc139','2025-11-29 08:04:56',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1812906045-dep_0-mhxmhs24l5sk','e610242b-2f0d-4066-b73a-b387588fc139','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1372,'c8e67973-bd51-4df8-aabb-ff7489510114','e610242b-2f0d-4066-b73a-b387588fc139','2025-11-29 08:04:56',NULL,'DELETE','IN_PROGRESS','0','37eb5f94-3c45-4e91-a17f-8899eba0d53d','state changed','OS::Heat::SoftwareDeployment',NULL,211),(1373,'893b519e-8bda-4b48-bf48-426cc6ea0496','b23e6104-f9a1-4c0c-b568-750cf917ffea','2025-11-29 08:04:56',NULL,'DELETE','COMPLETE','0','285cf42e-9cc0-4222-957f-0b245af7f5db','state changed','OS::Heat::SoftwareDeployment',NULL,214),(1374,'fd64cb5d-a32f-4f64-a448-c89a9dd12e1d','b23e6104-f9a1-4c0c-b568-750cf917ffea','2025-11-29 08:04:56',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1812906045-dep_1-soujsdl7qnpy','b23e6104-f9a1-4c0c-b568-750cf917ffea','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1375,'4cb4e0da-d14c-4655-9aab-6eebe786d337','5db7721f-ff92-4146-b2f3-2cd63ad458b0','2025-11-29 08:04:56',NULL,'DELETE','COMPLETE','dep_1','b23e6104-f9a1-4c0c-b568-750cf917ffea','state changed','OS::Heat::SoftwareDeployments',NULL,209),(1376,'06fb281a-6ea9-4abc-addf-2a4d30dc47de','e610242b-2f0d-4066-b73a-b387588fc139','2025-11-29 08:04:57',NULL,'DELETE','COMPLETE','0','37eb5f94-3c45-4e91-a17f-8899eba0d53d','state changed','OS::Heat::SoftwareDeployment',NULL,211),(1377,'f2acf003-b6eb-4d3a-ad59-644a65e41831','e610242b-2f0d-4066-b73a-b387588fc139','2025-11-29 08:04:57',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1812906045-dep_0-mhxmhs24l5sk','e610242b-2f0d-4066-b73a-b387588fc139','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1378,'cf045f5a-ecda-42be-b670-5f226cde98d1','5db7721f-ff92-4146-b2f3-2cd63ad458b0','2025-11-29 08:04:57',NULL,'DELETE','COMPLETE','dep_0','e610242b-2f0d-4066-b73a-b387588fc139','state changed','OS::Heat::SoftwareDeployments',NULL,206),(1379,'b779713e-7ed1-4f53-92e9-cf9368bb3b6d','5db7721f-ff92-4146-b2f3-2cd63ad458b0','2025-11-29 08:04:57',NULL,'DELETE','IN_PROGRESS','dep_2','43c98f02-b41d-4bfa-a1ce-6f71b8dc3fb7','state changed','OS::Heat::SoftwareDeployments',NULL,207),(1380,'5170fff8-ca90-4785-aa28-fe88c82e5812','43c98f02-b41d-4bfa-a1ce-6f71b8dc3fb7','2025-11-29 08:04:58',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1812906045-dep_2-qbirlrznoxom','43c98f02-b41d-4bfa-a1ce-6f71b8dc3fb7','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1381,'e72cc559-df05-4576-8612-06021a9af120','43c98f02-b41d-4bfa-a1ce-6f71b8dc3fb7','2025-11-29 08:04:58',NULL,'DELETE','IN_PROGRESS','0','6a9dc6d1-cff3-49f3-a1c8-b60f78ef02bf','state changed','OS::Heat::SoftwareDeployment',NULL,212),(1382,'5851b9be-25ec-46da-b3a0-53d1e32ddbdd','43c98f02-b41d-4bfa-a1ce-6f71b8dc3fb7','2025-11-29 08:04:59',NULL,'DELETE','COMPLETE','0','6a9dc6d1-cff3-49f3-a1c8-b60f78ef02bf','state changed','OS::Heat::SoftwareDeployment',NULL,212),(1383,'323a9c0d-d3d1-41dd-9560-7c13a1fc8b57','43c98f02-b41d-4bfa-a1ce-6f71b8dc3fb7','2025-11-29 08:04:59',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1812906045-dep_2-qbirlrznoxom','43c98f02-b41d-4bfa-a1ce-6f71b8dc3fb7','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1384,'e8ab7676-afbc-42b4-a334-38b907fb1acd','5db7721f-ff92-4146-b2f3-2cd63ad458b0','2025-11-29 08:05:00',NULL,'DELETE','COMPLETE','dep_2','43c98f02-b41d-4bfa-a1ce-6f71b8dc3fb7','state changed','OS::Heat::SoftwareDeployments',NULL,207),(1385,'8bc90174-f4ab-490f-9755-b81dd237c062','5db7721f-ff92-4146-b2f3-2cd63ad458b0','2025-11-29 08:05:00',NULL,'DELETE','IN_PROGRESS','config','19a63e85-6980-4440-b52f-0726ad7cab45','state changed','OS::Heat::SoftwareConfig',NULL,204),(1386,'7d1b613e-c626-476c-97cd-2acc3b5d5dbd','5db7721f-ff92-4146-b2f3-2cd63ad458b0','2025-11-29 08:05:01',NULL,'DELETE','COMPLETE','config','19a63e85-6980-4440-b52f-0726ad7cab45','state changed','OS::Heat::SoftwareConfig',NULL,204),(1387,'1ea28b7d-9ca6-4c93-9ae3-85ffbeebc330','5db7721f-ff92-4146-b2f3-2cd63ad458b0','2025-11-29 08:05:01',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1812906045','5db7721f-ff92-4146-b2f3-2cd63ad458b0','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1388,'0a8824a7-59fc-47e7-8f27-4ac9c12d4744','0cb91f56-9f71-4cd3-8bfb-beee945b274d','2025-11-29 08:05:08',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-483475472','0cb91f56-9f71-4cd3-8bfb-beee945b274d','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1389,'a5386e10-d7c8-460a-a28f-93e15661d559','0cb91f56-9f71-4cd3-8bfb-beee945b274d','2025-11-29 08:05:08',NULL,'DELETE','IN_PROGRESS','dep_3','d3c4e302-ce7c-4d43-ada7-5a133e77c465','state changed','OS::Heat::SoftwareDeployments',NULL,193),(1390,'b7b6a91a-f8e6-4021-b934-a78868917e85','d3c4e302-ce7c-4d43-ada7-5a133e77c465','2025-11-29 08:05:08',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-483475472-dep_3-ghivu5y2ntfz','d3c4e302-ce7c-4d43-ada7-5a133e77c465','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1391,'d85ad996-3fb2-4cf1-bbf6-a232b335c8fd','d3c4e302-ce7c-4d43-ada7-5a133e77c465','2025-11-29 08:05:09',NULL,'DELETE','IN_PROGRESS','0','c4574913-ac78-4448-98db-b87c23e45adc','state changed','OS::Heat::SoftwareDeployment',NULL,198),(1392,'ccbb70f8-24a7-4405-849c-22b720aa71be','0cb91f56-9f71-4cd3-8bfb-beee945b274d','2025-11-29 08:05:09',NULL,'DELETE','IN_PROGRESS','dep_2','15fa1552-2ea1-4818-adc9-e24ace9a4f26','state changed','OS::Heat::SoftwareDeployments',NULL,196),(1393,'7ff0b649-b603-4b8f-8411-b2a81e459dee','15fa1552-2ea1-4818-adc9-e24ace9a4f26','2025-11-29 08:05:09',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-483475472-dep_2-34jiaunhfhqp','15fa1552-2ea1-4818-adc9-e24ace9a4f26','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1394,'18974677-769c-4a9a-b06d-7aa79c977bfb','15fa1552-2ea1-4818-adc9-e24ace9a4f26','2025-11-29 08:05:09',NULL,'DELETE','IN_PROGRESS','0','af8d6ea3-9fd0-4a63-8bf8-59efb856cb1c','state changed','OS::Heat::SoftwareDeployment',NULL,202),(1395,'e5bbdea8-3fc3-4f8e-b824-7e9df130990f','d3c4e302-ce7c-4d43-ada7-5a133e77c465','2025-11-29 08:05:09',NULL,'DELETE','COMPLETE','0','c4574913-ac78-4448-98db-b87c23e45adc','state changed','OS::Heat::SoftwareDeployment',NULL,198),(1396,'f363bcfb-cd32-432d-afc4-d500e7d5aee1','d3c4e302-ce7c-4d43-ada7-5a133e77c465','2025-11-29 08:05:09',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-483475472-dep_3-ghivu5y2ntfz','d3c4e302-ce7c-4d43-ada7-5a133e77c465','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1397,'3d6e2b05-3b74-4b3f-a6ed-6a8afdbe4071','0cb91f56-9f71-4cd3-8bfb-beee945b274d','2025-11-29 08:05:10',NULL,'DELETE','COMPLETE','dep_3','d3c4e302-ce7c-4d43-ada7-5a133e77c465','state changed','OS::Heat::SoftwareDeployments',NULL,193),(1398,'6f868f83-a706-434e-8676-8c54e6bc5e4b','0cb91f56-9f71-4cd3-8bfb-beee945b274d','2025-11-29 08:05:10',NULL,'DELETE','IN_PROGRESS','dep_4','5b84b18f-a52e-4a03-b039-1827cf7f0eca','state changed','OS::Heat::SoftwareDeployments',NULL,194),(1399,'d9c2da13-c09f-4d83-9858-89fc7f0a513b','5b84b18f-a52e-4a03-b039-1827cf7f0eca','2025-11-29 08:05:10',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-483475472-dep_4-usf4vxnbwgkw','5b84b18f-a52e-4a03-b039-1827cf7f0eca','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1400,'e5a376d1-e51e-4cc3-a87c-3f17d4e826f5','5b84b18f-a52e-4a03-b039-1827cf7f0eca','2025-11-29 08:05:10',NULL,'DELETE','IN_PROGRESS','0','82a48b29-c7b2-45d8-9ed4-8a9ec60b1ab1','state changed','OS::Heat::SoftwareDeployment',NULL,200),(1401,'e9001024-f5f3-42db-8ae8-0158e693ae4e','15fa1552-2ea1-4818-adc9-e24ace9a4f26','2025-11-29 08:05:10',NULL,'DELETE','COMPLETE','0','af8d6ea3-9fd0-4a63-8bf8-59efb856cb1c','state changed','OS::Heat::SoftwareDeployment',NULL,202),(1402,'3edcac80-af38-414a-bdf4-a34f2eaa3401','15fa1552-2ea1-4818-adc9-e24ace9a4f26','2025-11-29 08:05:10',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-483475472-dep_2-34jiaunhfhqp','15fa1552-2ea1-4818-adc9-e24ace9a4f26','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1403,'d589b154-a5bc-485c-8e69-32a7a67dd3a3','0cb91f56-9f71-4cd3-8bfb-beee945b274d','2025-11-29 08:05:10',NULL,'DELETE','COMPLETE','dep_2','15fa1552-2ea1-4818-adc9-e24ace9a4f26','state changed','OS::Heat::SoftwareDeployments',NULL,196),(1404,'d753fa3a-c224-46a8-94bb-1e41e5f63cec','5b84b18f-a52e-4a03-b039-1827cf7f0eca','2025-11-29 08:05:10',NULL,'DELETE','COMPLETE','0','82a48b29-c7b2-45d8-9ed4-8a9ec60b1ab1','state changed','OS::Heat::SoftwareDeployment',NULL,200),(1405,'b0dbcd79-918c-4252-aff0-feca5ab3e072','5b84b18f-a52e-4a03-b039-1827cf7f0eca','2025-11-29 08:05:10',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-483475472-dep_4-usf4vxnbwgkw','5b84b18f-a52e-4a03-b039-1827cf7f0eca','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1406,'e02550e2-07fa-4f24-8dad-8cfc6d41edb6','0cb91f56-9f71-4cd3-8bfb-beee945b274d','2025-11-29 08:05:12',NULL,'DELETE','COMPLETE','dep_4','5b84b18f-a52e-4a03-b039-1827cf7f0eca','state changed','OS::Heat::SoftwareDeployments',NULL,194),(1407,'9f870a5f-2eb5-4ff9-a1e0-a50873dcba25','0cb91f56-9f71-4cd3-8bfb-beee945b274d','2025-11-29 08:05:12',NULL,'DELETE','IN_PROGRESS','dep_1','10294177-1248-471e-98a7-f30bdd51ed59','state changed','OS::Heat::SoftwareDeployments',NULL,197),(1408,'8ac39c1a-d19d-49cd-9e38-d2a46fc46e34','0cb91f56-9f71-4cd3-8bfb-beee945b274d','2025-11-29 08:05:12',NULL,'DELETE','IN_PROGRESS','dep_0','a1242deb-ef90-41ed-8a55-7ca5d2e883f6','state changed','OS::Heat::SoftwareDeployments',NULL,195),(1409,'00fb9b23-412a-489c-b930-8f6dde2589e9','10294177-1248-471e-98a7-f30bdd51ed59','2025-11-29 08:05:12',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-483475472-dep_1-w6gw36p5e5tm','10294177-1248-471e-98a7-f30bdd51ed59','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1410,'7807d4ed-b3b0-41a6-9ae1-df11754acba1','a1242deb-ef90-41ed-8a55-7ca5d2e883f6','2025-11-29 08:05:12',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-483475472-dep_0-7afxyxhwrcmy','a1242deb-ef90-41ed-8a55-7ca5d2e883f6','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1411,'412473d9-bf28-4d9e-ab2d-e2cc0d0dde27','10294177-1248-471e-98a7-f30bdd51ed59','2025-11-29 08:05:13',NULL,'DELETE','IN_PROGRESS','0','8c157e8a-05c1-4546-8154-a3e59d07ba89','state changed','OS::Heat::SoftwareDeployment',NULL,201),(1412,'f898de1a-3403-46e6-801d-ef5b3af06c86','a1242deb-ef90-41ed-8a55-7ca5d2e883f6','2025-11-29 08:05:13',NULL,'DELETE','IN_PROGRESS','0','78940cb9-d3dc-4448-a328-4c19d7026ab7','state changed','OS::Heat::SoftwareDeployment',NULL,199),(1413,'d104d53e-ec82-4c60-a0b4-9d25766e1c98','10294177-1248-471e-98a7-f30bdd51ed59','2025-11-29 08:05:13',NULL,'DELETE','COMPLETE','0','8c157e8a-05c1-4546-8154-a3e59d07ba89','state changed','OS::Heat::SoftwareDeployment',NULL,201),(1414,'d81c377e-a44c-46d4-8301-9b9b0984ec46','10294177-1248-471e-98a7-f30bdd51ed59','2025-11-29 08:05:13',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-483475472-dep_1-w6gw36p5e5tm','10294177-1248-471e-98a7-f30bdd51ed59','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1415,'bfbececc-9579-40dc-ba6d-4cefbc7304fa','0cb91f56-9f71-4cd3-8bfb-beee945b274d','2025-11-29 08:05:13',NULL,'DELETE','COMPLETE','dep_1','10294177-1248-471e-98a7-f30bdd51ed59','state changed','OS::Heat::SoftwareDeployments',NULL,197),(1416,'f84a884b-355e-4634-acd8-47016a54a1a7','a1242deb-ef90-41ed-8a55-7ca5d2e883f6','2025-11-29 08:05:14',NULL,'DELETE','COMPLETE','0','78940cb9-d3dc-4448-a328-4c19d7026ab7','state changed','OS::Heat::SoftwareDeployment',NULL,199),(1417,'ae2dee36-8180-42d3-ad3e-a010083d0979','a1242deb-ef90-41ed-8a55-7ca5d2e883f6','2025-11-29 08:05:14',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-483475472-dep_0-7afxyxhwrcmy','a1242deb-ef90-41ed-8a55-7ca5d2e883f6','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1418,'e216e148-50d1-4b7d-9516-306a864e0346','0cb91f56-9f71-4cd3-8bfb-beee945b274d','2025-11-29 08:05:15',NULL,'DELETE','COMPLETE','dep_0','a1242deb-ef90-41ed-8a55-7ca5d2e883f6','state changed','OS::Heat::SoftwareDeployments',NULL,195),(1419,'d9eafee0-5bd2-4d28-84a3-d744b2e79389','0cb91f56-9f71-4cd3-8bfb-beee945b274d','2025-11-29 08:05:15',NULL,'DELETE','IN_PROGRESS','config','d98b1bb2-4b78-403f-8c5d-9d9b031a087c','state changed','OS::Heat::SoftwareConfig',NULL,192),(1420,'1d728555-f0ee-4fb4-822b-174e12cfb770','0cb91f56-9f71-4cd3-8bfb-beee945b274d','2025-11-29 08:05:15',NULL,'DELETE','COMPLETE','config','d98b1bb2-4b78-403f-8c5d-9d9b031a087c','state changed','OS::Heat::SoftwareConfig',NULL,192),(1421,'d5a1e5a5-2586-40a4-8a7f-12684e01e427','0cb91f56-9f71-4cd3-8bfb-beee945b274d','2025-11-29 08:05:15',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-483475472','0cb91f56-9f71-4cd3-8bfb-beee945b274d','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1422,'b2147003-a687-444f-b1e6-2be465a84cdc','506e5652-64a1-44f4-8d81-3b9a8b7a1e03','2025-11-29 08:05:18',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1927891276','506e5652-64a1-44f4-8d81-3b9a8b7a1e03','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1423,'411676aa-d3de-4c7e-b523-92b9d7d26187','506e5652-64a1-44f4-8d81-3b9a8b7a1e03','2025-11-29 08:05:18',NULL,'DELETE','IN_PROGRESS','server','e3578395-b4af-44f6-9a44-4bba1e88898b','state changed','OS::Nova::Server',NULL,190),(1424,'a873dbac-ca1b-4ce7-ba4a-f77cd25e7b9d','506e5652-64a1-44f4-8d81-3b9a8b7a1e03','2025-11-29 08:05:23',NULL,'DELETE','COMPLETE','server','e3578395-b4af-44f6-9a44-4bba1e88898b','state changed','OS::Nova::Server',NULL,190),(1425,'ec9b0e2b-5988-4e57-a0d7-561132bd60c2','506e5652-64a1-44f4-8d81-3b9a8b7a1e03','2025-11-29 08:05:23',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1927891276','506e5652-64a1-44f4-8d81-3b9a8b7a1e03','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1426,'3f3bbf4e-30e9-40ec-a5c4-ade4d5a6bab2','96c617d2-8371-4ad3-af7b-878231f849aa','2025-11-29 08:05:30',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-694325321','96c617d2-8371-4ad3-af7b-878231f849aa','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1427,'b2acdf65-1854-422b-8f43-06e3aa9cf4e6','96c617d2-8371-4ad3-af7b-878231f849aa','2025-11-29 08:05:31',NULL,'CREATE','IN_PROGRESS','server','ParallelDeploymentsTest-694325321-server-x732f6zfk26b','state changed','OS::Nova::Server',NULL,239),(1428,'cc510c10-2142-4466-9def-4b2fea156566','96c617d2-8371-4ad3-af7b-878231f849aa','2025-11-29 08:05:48',NULL,'CREATE','COMPLETE','server','361c41e7-0e30-45d3-b923-ccbb12956704','state changed','OS::Nova::Server',NULL,239),(1429,'a257dbf0-53fb-4ad3-b0ea-6c672d068427','96c617d2-8371-4ad3-af7b-878231f849aa','2025-11-29 08:05:49',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-694325321','96c617d2-8371-4ad3-af7b-878231f849aa','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1430,'9c5c469f-7888-411d-b8be-6cd0ead3bb0b','f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','2025-11-29 08:05:52',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-528172829','f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1431,'0200f4eb-3239-42c6-8c31-272f2ab51230','f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','2025-11-29 08:05:54',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-528172829-config-sfyndwzvdqq7','state changed','OS::Heat::SoftwareConfig',NULL,240),(1432,'4df23705-5a73-4803-a618-adec4411ba9b','f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','2025-11-29 08:05:54',NULL,'CREATE','COMPLETE','config','a85f0d31-f4d3-4dfd-b758-e14f20ec1e10','state changed','OS::Heat::SoftwareConfig',NULL,240),(1433,'a03003f7-23bb-495c-89f7-cf12b70ebb05','f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','2025-11-29 08:05:54',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-528172829-dep_2-xjihl7bp62ay','state changed','OS::Heat::SoftwareDeployments',NULL,241),(1434,'3f133e01-c52e-4e00-9529-df41cca9d1ff','f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','2025-11-29 08:05:54',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-528172829-dep_0-p3g6jl3z7ywg','state changed','OS::Heat::SoftwareDeployments',NULL,242),(1435,'7342167f-2004-4ad0-888d-31b627c7c8e6','f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','2025-11-29 08:05:54',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-528172829-dep_1-cuno5va26t46','state changed','OS::Heat::SoftwareDeployments',NULL,243),(1436,'06ad7023-fe7d-4217-9cad-2efc735f757f','d50d4a5e-914a-45a3-8798-ac8c4d6bd49d','2025-11-29 08:05:54',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-528172829-dep_2-xjihl7bp62ay','d50d4a5e-914a-45a3-8798-ac8c4d6bd49d','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1437,'691c87d6-2a35-464f-8099-e8fcfa2e3677','719c244c-5fb1-4e6d-a655-d34c62c57c15','2025-11-29 08:05:54',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-528172829-dep_0-p3g6jl3z7ywg','719c244c-5fb1-4e6d-a655-d34c62c57c15','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1438,'4a917a55-39f8-4a0b-be15-9e86b56046ff','f9568701-164d-4eaf-87f6-40eb8c69eb2c','2025-11-29 08:05:54',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-528172829-dep_1-cuno5va26t46','f9568701-164d-4eaf-87f6-40eb8c69eb2c','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1439,'d75fc41c-a778-4242-b0c0-2ff0758495ae','d50d4a5e-914a-45a3-8798-ac8c4d6bd49d','2025-11-29 08:05:55',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-528172829-dep_2-xjihl7bp62ay-0-bwebk2o6oqez','state changed','OS::Heat::SoftwareDeployment',NULL,244),(1440,'971cf4f2-2e1d-4dbe-9725-058e3d5ac0aa','719c244c-5fb1-4e6d-a655-d34c62c57c15','2025-11-29 08:05:55',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-528172829-dep_0-p3g6jl3z7ywg-0-2kzl6lth27fn','state changed','OS::Heat::SoftwareDeployment',NULL,245),(1441,'a7eb7be8-b7c2-441b-b10e-869de917b9d1','f9568701-164d-4eaf-87f6-40eb8c69eb2c','2025-11-29 08:05:55',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-528172829-dep_1-cuno5va26t46-0-hkgnpecirsan','state changed','OS::Heat::SoftwareDeployment',NULL,246),(1442,'e0d259bf-dcbe-4d37-bad0-ff8bf8bf7239','f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','2025-11-29 08:06:53',NULL,'CREATE','FAILED','dep_2','d50d4a5e-914a-45a3-8798-ac8c4d6bd49d','CREATE aborted (Task create from SoftwareDeployments \"dep_2\" Stack \"ParallelDeploymentsTest-528172829\" [f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8] Timed out)','OS::Heat::SoftwareDeployments',NULL,241),(1443,'cc58fb67-e241-4e59-a1bf-cc98524fc92c','f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','2025-11-29 08:06:53',NULL,'CREATE','FAILED','dep_0','719c244c-5fb1-4e6d-a655-d34c62c57c15','CREATE aborted (Task create from SoftwareDeployments \"dep_0\" Stack \"ParallelDeploymentsTest-528172829\" [f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8] Timed out)','OS::Heat::SoftwareDeployments',NULL,242),(1444,'0765fb83-aa54-4b3c-868d-e8223443dc14','f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','2025-11-29 08:06:53',NULL,'CREATE','FAILED','dep_1','f9568701-164d-4eaf-87f6-40eb8c69eb2c','CREATE aborted (Task create from SoftwareDeployments \"dep_1\" Stack \"ParallelDeploymentsTest-528172829\" [f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8] Timed out)','OS::Heat::SoftwareDeployments',NULL,243),(1445,'cb0c0454-7a48-4d2d-9796-5efb5b2db144','719c244c-5fb1-4e6d-a655-d34c62c57c15','2025-11-29 08:06:53',NULL,'CREATE','FAILED','ParallelDeploymentsTest-528172829-dep_0-p3g6jl3z7ywg','719c244c-5fb1-4e6d-a655-d34c62c57c15','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1446,'567be3b2-cfb6-4ed7-95c3-87966172c71c','f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','2025-11-29 08:06:53',NULL,'CREATE','FAILED','ParallelDeploymentsTest-528172829','f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','Timed out','OS::Heat::Stack',NULL,NULL),(1447,'3f2c20fd-c1d4-4de5-b86b-6bb36d6490a4','f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','2025-11-29 08:06:53',NULL,'CREATE','FAILED','ParallelDeploymentsTest-528172829','f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','Timed out','OS::Heat::Stack',NULL,NULL),(1448,'e2885648-fac1-4d3c-9ff6-24960934618e','f9568701-164d-4eaf-87f6-40eb8c69eb2c','2025-11-29 08:06:53',NULL,'CREATE','FAILED','ParallelDeploymentsTest-528172829-dep_1-cuno5va26t46','f9568701-164d-4eaf-87f6-40eb8c69eb2c','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1449,'9f8b261f-5ed4-4315-a164-fa5df0da3c2c','f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','2025-11-29 08:06:53',NULL,'CREATE','FAILED','ParallelDeploymentsTest-528172829','f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','Timed out','OS::Heat::Stack',NULL,NULL),(1450,'229f233d-0db1-45f6-a66a-ec37a7bd97ba','d50d4a5e-914a-45a3-8798-ac8c4d6bd49d','2025-11-29 08:06:54',NULL,'CREATE','FAILED','ParallelDeploymentsTest-528172829-dep_2-xjihl7bp62ay','d50d4a5e-914a-45a3-8798-ac8c4d6bd49d','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1451,'617d23ad-8818-4dcc-bc02-3bad9cb345c0','719c244c-5fb1-4e6d-a655-d34c62c57c15','2025-11-29 08:06:54',NULL,'CREATE','FAILED','0','eb9a0b0c-4352-4355-9563-54c39fc959af','CREATE aborted (Task create from SoftwareDeployment \"0\" Stack \"ParallelDeploymentsTest-528172829-dep_0-p3g6jl3z7ywg\" [719c244c-5fb1-4e6d-a655-d34c62c57c15] Timed out)','OS::Heat::SoftwareDeployment',NULL,245),(1452,'f2cdadcd-a16f-4cfc-8f45-cdfc0e44f387','719c244c-5fb1-4e6d-a655-d34c62c57c15','2025-11-29 08:06:55',NULL,'CREATE','FAILED','ParallelDeploymentsTest-528172829-dep_0-p3g6jl3z7ywg','719c244c-5fb1-4e6d-a655-d34c62c57c15','Timed out','OS::Heat::Stack',NULL,NULL),(1453,'35326e67-6b30-48cf-afe1-d2432c976bf9','f9568701-164d-4eaf-87f6-40eb8c69eb2c','2025-11-29 08:06:55',NULL,'CREATE','FAILED','0','9a77e974-3aca-46db-8f00-6a9ceca41a60','CREATE aborted (Task create from SoftwareDeployment \"0\" Stack \"ParallelDeploymentsTest-528172829-dep_1-cuno5va26t46\" [f9568701-164d-4eaf-87f6-40eb8c69eb2c] Timed out)','OS::Heat::SoftwareDeployment',NULL,246),(1454,'15f3bf5b-e726-490b-8391-0dd2dd007a9d','d50d4a5e-914a-45a3-8798-ac8c4d6bd49d','2025-11-29 08:06:55',NULL,'CREATE','FAILED','0','ce7b2146-a50d-4821-96d4-8fea0cd36e5c','CREATE aborted (Task create from SoftwareDeployment \"0\" Stack \"ParallelDeploymentsTest-528172829-dep_2-xjihl7bp62ay\" [d50d4a5e-914a-45a3-8798-ac8c4d6bd49d] Timed out)','OS::Heat::SoftwareDeployment',NULL,244),(1455,'0d2ea477-b4b0-467d-b7da-5e5d393bcd8b','f9568701-164d-4eaf-87f6-40eb8c69eb2c','2025-11-29 08:06:55',NULL,'CREATE','FAILED','ParallelDeploymentsTest-528172829-dep_1-cuno5va26t46','f9568701-164d-4eaf-87f6-40eb8c69eb2c','Timed out','OS::Heat::Stack',NULL,NULL),(1456,'ecdc8240-108a-4239-8619-f1df092bfb3e','d50d4a5e-914a-45a3-8798-ac8c4d6bd49d','2025-11-29 08:06:55',NULL,'CREATE','FAILED','ParallelDeploymentsTest-528172829-dep_2-xjihl7bp62ay','d50d4a5e-914a-45a3-8798-ac8c4d6bd49d','Timed out','OS::Heat::Stack',NULL,NULL),(1457,'a6ea0283-6414-4800-b0a6-1b59a74ccb7b','f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','2025-11-29 08:06:56',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-528172829','f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1458,'beba71cd-7187-49d2-a06a-6f303b448d49','f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','2025-11-29 08:06:58',NULL,'DELETE','IN_PROGRESS','dep_0','719c244c-5fb1-4e6d-a655-d34c62c57c15','state changed','OS::Heat::SoftwareDeployments',NULL,242),(1459,'6beafe44-c048-4113-8f06-23fa77d16333','719c244c-5fb1-4e6d-a655-d34c62c57c15','2025-11-29 08:06:58',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-528172829-dep_0-p3g6jl3z7ywg','719c244c-5fb1-4e6d-a655-d34c62c57c15','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1460,'302e2356-20e5-4349-9a79-96b48e6356b3','719c244c-5fb1-4e6d-a655-d34c62c57c15','2025-11-29 08:06:58',NULL,'DELETE','IN_PROGRESS','0','eb9a0b0c-4352-4355-9563-54c39fc959af','state changed','OS::Heat::SoftwareDeployment',NULL,245),(1461,'1ad1a7cf-2919-478b-ad25-a772dd6de9f0','f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','2025-11-29 08:06:59',NULL,'DELETE','IN_PROGRESS','dep_1','f9568701-164d-4eaf-87f6-40eb8c69eb2c','state changed','OS::Heat::SoftwareDeployments',NULL,243),(1462,'b9648efd-c764-4521-89c4-ce7160ba563f','f9568701-164d-4eaf-87f6-40eb8c69eb2c','2025-11-29 08:07:00',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-528172829-dep_1-cuno5va26t46','f9568701-164d-4eaf-87f6-40eb8c69eb2c','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1463,'4633336d-f7b9-4f82-baa4-7400369c3b69','f9568701-164d-4eaf-87f6-40eb8c69eb2c','2025-11-29 08:07:00',NULL,'DELETE','IN_PROGRESS','0','9a77e974-3aca-46db-8f00-6a9ceca41a60','state changed','OS::Heat::SoftwareDeployment',NULL,246),(1464,'d65c89c5-848c-4d7e-8b51-fc0ca3d86f95','719c244c-5fb1-4e6d-a655-d34c62c57c15','2025-11-29 08:07:00',NULL,'DELETE','COMPLETE','0','eb9a0b0c-4352-4355-9563-54c39fc959af','state changed','OS::Heat::SoftwareDeployment',NULL,245),(1465,'1e3bcd5c-7ef4-4c86-8f27-b3de529e8ae3','f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','2025-11-29 08:07:00',NULL,'DELETE','IN_PROGRESS','dep_2','d50d4a5e-914a-45a3-8798-ac8c4d6bd49d','state changed','OS::Heat::SoftwareDeployments',NULL,241),(1466,'46ec22c3-4f8e-4308-b1c2-5d5780181e64','719c244c-5fb1-4e6d-a655-d34c62c57c15','2025-11-29 08:07:00',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-528172829-dep_0-p3g6jl3z7ywg','719c244c-5fb1-4e6d-a655-d34c62c57c15','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1467,'a2f373a1-4a20-40d0-a9fd-7032d50be114','d50d4a5e-914a-45a3-8798-ac8c4d6bd49d','2025-11-29 08:07:00',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-528172829-dep_2-xjihl7bp62ay','d50d4a5e-914a-45a3-8798-ac8c4d6bd49d','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1468,'037f5a69-2cf1-4367-b083-7bd7ee7f2d3d','d50d4a5e-914a-45a3-8798-ac8c4d6bd49d','2025-11-29 08:07:00',NULL,'DELETE','IN_PROGRESS','0','ce7b2146-a50d-4821-96d4-8fea0cd36e5c','state changed','OS::Heat::SoftwareDeployment',NULL,244),(1469,'42360bd5-ab4e-4fba-b338-b266a85725f4','f9568701-164d-4eaf-87f6-40eb8c69eb2c','2025-11-29 08:07:01',NULL,'DELETE','COMPLETE','0','9a77e974-3aca-46db-8f00-6a9ceca41a60','state changed','OS::Heat::SoftwareDeployment',NULL,246),(1470,'c3d372c7-84b7-4885-ad3b-df6fcb462474','f9568701-164d-4eaf-87f6-40eb8c69eb2c','2025-11-29 08:07:01',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-528172829-dep_1-cuno5va26t46','f9568701-164d-4eaf-87f6-40eb8c69eb2c','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1471,'095a3384-41f8-48bd-9aac-88766e5819dd','d50d4a5e-914a-45a3-8798-ac8c4d6bd49d','2025-11-29 08:07:01',NULL,'DELETE','COMPLETE','0','ce7b2146-a50d-4821-96d4-8fea0cd36e5c','state changed','OS::Heat::SoftwareDeployment',NULL,244),(1472,'9a33405a-3bed-439f-ade9-f558bd157a27','d50d4a5e-914a-45a3-8798-ac8c4d6bd49d','2025-11-29 08:07:01',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-528172829-dep_2-xjihl7bp62ay','d50d4a5e-914a-45a3-8798-ac8c4d6bd49d','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1473,'1458ebcc-2db5-42df-8a60-b2c4db8533df','f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','2025-11-29 08:07:01',NULL,'DELETE','COMPLETE','dep_0','719c244c-5fb1-4e6d-a655-d34c62c57c15','state changed','OS::Heat::SoftwareDeployments',NULL,242),(1474,'5fab34aa-afdd-4584-923e-41bbdafa90ad','f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','2025-11-29 08:07:02',NULL,'DELETE','COMPLETE','dep_2','d50d4a5e-914a-45a3-8798-ac8c4d6bd49d','state changed','OS::Heat::SoftwareDeployments',NULL,241),(1475,'2d6aa26a-5e53-404e-85ac-13bd0730a5c0','f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','2025-11-29 08:07:02',NULL,'DELETE','COMPLETE','dep_1','f9568701-164d-4eaf-87f6-40eb8c69eb2c','state changed','OS::Heat::SoftwareDeployments',NULL,243),(1476,'24dbb66d-0f5d-4d6f-bb2c-279d7c95e8d3','f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','2025-11-29 08:07:03',NULL,'DELETE','IN_PROGRESS','config','a85f0d31-f4d3-4dfd-b758-e14f20ec1e10','state changed','OS::Heat::SoftwareConfig',NULL,240),(1477,'100230f5-1ff1-463b-97d3-b898b8cb35f8','f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','2025-11-29 08:07:05',NULL,'DELETE','COMPLETE','config','a85f0d31-f4d3-4dfd-b758-e14f20ec1e10','state changed','OS::Heat::SoftwareConfig',NULL,240),(1478,'111e1703-88fe-4776-9bde-aba0d2f7078e','f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','2025-11-29 08:07:05',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-528172829','f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1479,'92810e11-7aab-4b61-9fd6-9fb9ad046252','96c617d2-8371-4ad3-af7b-878231f849aa','2025-11-29 08:07:10',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-694325321','96c617d2-8371-4ad3-af7b-878231f849aa','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1480,'e789270a-797c-448c-9379-e016498b51c3','96c617d2-8371-4ad3-af7b-878231f849aa','2025-11-29 08:07:10',NULL,'DELETE','IN_PROGRESS','server','361c41e7-0e30-45d3-b923-ccbb12956704','state changed','OS::Nova::Server',NULL,239),(1481,'03f37abc-ec30-40a2-976e-fa70a14acfdf','96c617d2-8371-4ad3-af7b-878231f849aa','2025-11-29 08:07:16',NULL,'DELETE','COMPLETE','server','361c41e7-0e30-45d3-b923-ccbb12956704','state changed','OS::Nova::Server',NULL,239),(1482,'a958947d-474f-4ed2-8267-1ee1cba7f857','96c617d2-8371-4ad3-af7b-878231f849aa','2025-11-29 08:07:16',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-694325321','96c617d2-8371-4ad3-af7b-878231f849aa','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1483,'93b9c3a3-753e-41b1-80a9-f4dba2944cc8','705ab806-d900-46cd-8993-3d860855c41c','2025-11-29 08:07:23',NULL,'CREATE','IN_PROGRESS','StackTagTest-815859264','705ab806-d900-46cd-8993-3d860855c41c','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1484,'86024602-48fc-4ab4-8e9f-7ca9e9e16ece','705ab806-d900-46cd-8993-3d860855c41c','2025-11-29 08:07:24',NULL,'CREATE','IN_PROGRESS','not-used','StackTagTest-815859264-not-used-jgjo7i6feowu','state changed','OS::Heat::TestResource',NULL,247),(1485,'638212f4-5839-4b1a-bafe-e513100961db','705ab806-d900-46cd-8993-3d860855c41c','2025-11-29 08:07:26',NULL,'CREATE','COMPLETE','not-used','StackTagTest-815859264-not-used-jgjo7i6feowu','state changed','OS::Heat::TestResource',NULL,247),(1486,'35543b13-f215-4353-9b1b-e2ab06d17a6f','705ab806-d900-46cd-8993-3d860855c41c','2025-11-29 08:07:26',NULL,'CREATE','COMPLETE','StackTagTest-815859264','705ab806-d900-46cd-8993-3d860855c41c','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1487,'1dd71611-3b14-4009-b47b-ad6dea2150cd','705ab806-d900-46cd-8993-3d860855c41c','2025-11-29 08:07:30',NULL,'DELETE','IN_PROGRESS','StackTagTest-815859264','705ab806-d900-46cd-8993-3d860855c41c','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1488,'0b9eaaef-061a-4cee-a70e-d7bb7373eadb','705ab806-d900-46cd-8993-3d860855c41c','2025-11-29 08:07:30',NULL,'DELETE','IN_PROGRESS','not-used','StackTagTest-815859264-not-used-jgjo7i6feowu','state changed','OS::Heat::TestResource',NULL,247),(1489,'0976e7dd-d85d-458c-a66c-1bb6104dfe6d','705ab806-d900-46cd-8993-3d860855c41c','2025-11-29 08:07:34',NULL,'DELETE','COMPLETE','not-used','StackTagTest-815859264-not-used-jgjo7i6feowu','state changed','OS::Heat::TestResource',NULL,247),(1490,'9bec1298-f936-4b30-b637-1e90714e91cd','705ab806-d900-46cd-8993-3d860855c41c','2025-11-29 08:07:34',NULL,'DELETE','COMPLETE','StackTagTest-815859264','705ab806-d900-46cd-8993-3d860855c41c','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1491,'900ca833-66fa-4649-a0ab-42038d131e9f','c3dadc4e-5845-4782-9f57-9bfd3e3da617','2025-11-29 08:07:43',NULL,'CREATE','IN_PROGRESS','StackTagTest-1491496176','c3dadc4e-5845-4782-9f57-9bfd3e3da617','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1492,'037370a4-7cf5-4ef2-a28e-29be91222a42','c3dadc4e-5845-4782-9f57-9bfd3e3da617','2025-11-29 08:07:43',NULL,'CREATE','IN_PROGRESS','not-used','StackTagTest-1491496176-not-used-iuu4b4ryhmaq','state changed','OS::Heat::TestResource',NULL,248),(1493,'3caa8922-17da-4a02-a4d8-3bf6f7afdba7','c3dadc4e-5845-4782-9f57-9bfd3e3da617','2025-11-29 08:07:46',NULL,'CREATE','COMPLETE','not-used','StackTagTest-1491496176-not-used-iuu4b4ryhmaq','state changed','OS::Heat::TestResource',NULL,248),(1494,'226476a8-f1ad-4513-9819-7219afc1ce1d','c3dadc4e-5845-4782-9f57-9bfd3e3da617','2025-11-29 08:07:46',NULL,'CREATE','COMPLETE','StackTagTest-1491496176','c3dadc4e-5845-4782-9f57-9bfd3e3da617','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1495,'3b966f7f-ac94-4bea-b505-c86ce1d5efae','c3dadc4e-5845-4782-9f57-9bfd3e3da617','2025-11-29 08:07:49',NULL,'UPDATE','IN_PROGRESS','StackTagTest-1491496176','c3dadc4e-5845-4782-9f57-9bfd3e3da617','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1496,'96be8258-5911-4112-bc3d-26578e056843','c3dadc4e-5845-4782-9f57-9bfd3e3da617','2025-11-29 08:07:49',NULL,'UPDATE','IN_PROGRESS','not-used','StackTagTest-1491496176-not-used-iuu4b4ryhmaq','state changed','OS::Heat::TestResource',NULL,248),(1497,'0e062044-573f-4491-bfab-b3f3d026c0e3','c3dadc4e-5845-4782-9f57-9bfd3e3da617','2025-11-29 08:07:52',NULL,'UPDATE','COMPLETE','not-used','StackTagTest-1491496176-not-used-iuu4b4ryhmaq','state changed','OS::Heat::TestResource',NULL,249),(1498,'356779bd-aff9-4820-b7c1-5d6545bd9c96','c3dadc4e-5845-4782-9f57-9bfd3e3da617','2025-11-29 08:07:52',NULL,'UPDATE','COMPLETE','StackTagTest-1491496176','c3dadc4e-5845-4782-9f57-9bfd3e3da617','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1499,'4ecc632f-0426-4ccb-a14d-7dec5c27b477','c3dadc4e-5845-4782-9f57-9bfd3e3da617','2025-11-29 08:07:55',NULL,'UPDATE','IN_PROGRESS','StackTagTest-1491496176','c3dadc4e-5845-4782-9f57-9bfd3e3da617','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1500,'94497e7a-c3cc-498f-8624-9cbc3e9cf033','c3dadc4e-5845-4782-9f57-9bfd3e3da617','2025-11-29 08:07:55',NULL,'UPDATE','IN_PROGRESS','not-used','StackTagTest-1491496176-not-used-iuu4b4ryhmaq','state changed','OS::Heat::TestResource',NULL,249),(1501,'6ced0d1c-a8f2-4f07-89c5-476622311870','c3dadc4e-5845-4782-9f57-9bfd3e3da617','2025-11-29 08:07:58',NULL,'UPDATE','COMPLETE','not-used','StackTagTest-1491496176-not-used-iuu4b4ryhmaq','state changed','OS::Heat::TestResource',NULL,250),(1502,'685d5cc1-feae-4e56-b0b4-ae5a4e6e31bc','c3dadc4e-5845-4782-9f57-9bfd3e3da617','2025-11-29 08:07:58',NULL,'UPDATE','COMPLETE','StackTagTest-1491496176','c3dadc4e-5845-4782-9f57-9bfd3e3da617','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1503,'a6c98c15-1c53-428b-89e6-6f0570f2b289','c3dadc4e-5845-4782-9f57-9bfd3e3da617','2025-11-29 08:08:00',NULL,'DELETE','IN_PROGRESS','StackTagTest-1491496176','c3dadc4e-5845-4782-9f57-9bfd3e3da617','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1504,'3e59c671-a94b-4e5b-bff8-a08da09958bd','c3dadc4e-5845-4782-9f57-9bfd3e3da617','2025-11-29 08:08:00',NULL,'DELETE','IN_PROGRESS','not-used','StackTagTest-1491496176-not-used-iuu4b4ryhmaq','state changed','OS::Heat::TestResource',NULL,250),(1505,'19718164-acd6-4d28-a0ef-d8b046b48d13','c3dadc4e-5845-4782-9f57-9bfd3e3da617','2025-11-29 08:08:03',NULL,'DELETE','COMPLETE','not-used','StackTagTest-1491496176-not-used-iuu4b4ryhmaq','state changed','OS::Heat::TestResource',NULL,250),(1506,'db432959-dd7a-4a88-9ff0-ec0a010840c6','c3dadc4e-5845-4782-9f57-9bfd3e3da617','2025-11-29 08:08:03',NULL,'DELETE','COMPLETE','StackTagTest-1491496176','c3dadc4e-5845-4782-9f57-9bfd3e3da617','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL);
/*!40000 ALTER TABLE `event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrate_version`
--

DROP TABLE IF EXISTS `migrate_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrate_version` (
  `repository_id` varchar(250) NOT NULL,
  `repository_path` text DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`repository_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrate_version`
--

LOCK TABLES `migrate_version` WRITE;
/*!40000 ALTER TABLE `migrate_version` DISABLE KEYS */;
INSERT INTO `migrate_version` (`repository_id`, `repository_path`, `version`) VALUES ('heat','/usr/lib/python3.9/site-packages/heat/db/sqlalchemy/migrate_repo',86);
/*!40000 ALTER TABLE `migrate_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raw_template`
--

DROP TABLE IF EXISTS `raw_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `raw_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `template` longtext DEFAULT NULL,
  `files` longtext DEFAULT NULL,
  `environment` longtext DEFAULT NULL,
  `files_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `raw_tmpl_files_fkey_ref` (`files_id`),
  CONSTRAINT `raw_tmpl_files_fkey_ref` FOREIGN KEY (`files_id`) REFERENCES `raw_template_files` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=239 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raw_template`
--

LOCK TABLES `raw_template` WRITE;
/*!40000 ALTER TABLE `raw_template` DISABLE KEYS */;
INSERT INTO `raw_template` (`id`, `created_at`, `updated_at`, `template`, `files`, `environment`, `files_id`) VALUES (2,'2025-11-29 07:56:37',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}}}}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"test\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(4,'2025-11-29 07:56:38',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(5,'2025-11-29 07:56:40',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"test\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(6,'2025-11-29 07:56:41',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(7,'2025-11-29 07:56:42',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(8,'2025-11-29 07:56:43',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(12,'2025-11-29 07:56:46',NULL,'{\"heat_template_version\": \"2016-04-08\"}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(13,'2025-11-29 07:56:47',NULL,'{\"heat_template_version\": \"pike\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}}}}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"value\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(14,'2025-11-29 07:56:48',NULL,'{\"heat_template_version\": \"2016-04-08\"}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(16,'2025-11-29 07:56:48',NULL,'{\"heat_template_version\": \"2016-04-08\"}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(20,'2025-11-29 07:56:51',NULL,'{\"heat_template_version\": \"pike\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}, \"action_wait_secs\": {\"update\": 1}}}}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"new_value\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(21,'2025-11-29 07:56:51',NULL,'{\"heat_template_version\": \"2016-04-08\"}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(27,'2025-11-29 07:56:58',NULL,'{\"heat_template_version\": \"pike\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}, \"action_wait_secs\": {\"update\": 1}}}}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"new_patched_value\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(28,'2025-11-29 07:56:58',NULL,'{\"heat_template_version\": \"pike\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"new_patched_value\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(33,'2025-11-29 07:57:10',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create encryption volume type.\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(34,'2025-11-29 07:57:14',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create port wit ip_address.\", \"parameters\": {\"mac\": {\"type\": \"string\", \"default\": \"00-00-00-00-BB-BB\"}}, \"resources\": {}, \"outputs\": {\"port_ip\": {\"value\": {\"get_attr\": [\"port\", \"fixed_ips\", 0, \"ip_address\"]}}, \"mac_address\": {\"value\": {\"get_attr\": [\"port\", \"mac_address\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(38,'2025-11-29 07:57:29',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(41,'2025-11-29 07:57:38',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create port wit ip_address.\", \"parameters\": {\"mac\": {\"type\": \"string\", \"default\": \"00-00-00-00-BB-BB\"}}, \"resources\": {}, \"outputs\": {\"port_ip\": {\"value\": {\"get_attr\": [\"port\", \"fixed_ips\", 0, \"ip_address\"]}}, \"mac_address\": {\"value\": {\"get_attr\": [\"port\", \"mac_address\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"mac\": \"00-00-00-00-AA-AA\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(43,'2025-11-29 07:57:43',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server with port.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(46,'2025-11-29 07:57:51',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(50,'2025-11-29 07:58:01',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(51,'2025-11-29 07:58:01',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(55,'2025-11-29 07:58:40',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server with subnet and fixed_ip.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"networks\": {\"value\": {\"get_attr\": [\"server\", \"networks\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(56,'2025-11-29 07:58:44',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(60,'2025-11-29 07:58:55',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(62,'2025-11-29 07:59:01',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(66,'2025-11-29 07:59:10',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(72,'2025-11-29 07:59:37',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(74,'2025-11-29 07:59:42',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(75,'2025-11-29 07:59:45',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(76,'2025-11-29 07:59:52',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"networks\": {\"value\": {\"get_attr\": [\"server\", \"networks\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(80,'2025-11-29 07:59:59',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(83,'2025-11-29 08:00:06',NULL,'{\"heat_template_version\": \"2014-10-16\", \"parameters\": null, \"resources\": {}, \"outputs\": {\"resource_id\": {\"description\": \"ID of resource\", \"value\": {\"get_resource\": \"test_resource\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(87,'2025-11-29 08:00:13',NULL,'{\"heat_template_version\": \"2014-10-16\", \"description\": \"Test Template APIs\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(88,'2025-11-29 08:00:17',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(90,'2025-11-29 08:00:20',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(94,'2025-11-29 08:00:24',NULL,'{\"heat_template_version\": \"2016-10-14\", \"resources\": {}, \"outputs\": {\"str\": {\"value\": {\"get_resource\": \"test1\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(97,'2025-11-29 08:00:30',NULL,'{\"description\": \"The root stack (containing a remote stack) for the deeply-nested remote\\nstack test.\\n\", \"heat_template_version\": \"2015-10-15\", \"outputs\": {\"router\": {\"value\": {\"get_attr\": [\"network_stack\", \"outputs\", \"router\"]}}}, \"parameters\": {\"name\": {\"constraints\": [{\"allowed_pattern\": \"[a-z][a-z0-9-]{1,}\"}], \"description\": \"Name of the router\", \"type\": \"string\"}, \"network_name\": {\"constraints\": [{\"custom_constraint\": \"neutron.network\"}], \"description\": \"The public network to connect to\", \"type\": \"string\"}, \"region\": {\"default\": \"RegionOne\", \"description\": \"The region in which to create the remote stack\", \"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"name\": \"remote-nested\", \"network_name\": \"public\", \"region\": \"regionOne\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',1),(98,'2025-11-29 08:00:30',NULL,'{\"heat_template_version\": \"2015-10-15\", \"description\": \"The intermediate stack (containing a local nested stack) to be instantiated\\nremotely in the remote deeply-nested stack test.\\n\", \"parameters\": {\"name\": {\"type\": \"string\", \"description\": \"Name of the router\", \"constraints\": [{\"allowed_pattern\": \"[a-z][a-z0-9-]{1,}\"}]}, \"network_name\": {\"type\": \"string\", \"description\": \"The public network to connect to\", \"constraints\": [{\"custom_constraint\": \"neutron.network\"}]}}, \"resources\": {}, \"outputs\": {\"router\": {\"value\": {\"get_attr\": [\"network_stack_as_custom_type\", \"router\"]}}}}','null','{\"resource_registry\": {\"resources\": {}, \"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\": \"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\"}, \"parameters\": {\"name\": \"remote-nested\", \"network_name\": \"public\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',2),(99,'2025-11-29 08:00:31',NULL,'{\"heat_template_version\": \"2015-10-15\", \"description\": \"The base stack (containing an actual resource) for the remote deeply-nested\\nstack test.\\n\", \"parameters\": {\"name\": {\"type\": \"string\", \"description\": \"Name of the router\", \"constraints\": [{\"allowed_pattern\": \"[a-z][a-z0-9-]{1,}\"}]}, \"network_name\": {\"type\": \"string\", \"description\": \"The network to connect to\", \"constraints\": [{\"custom_constraint\": \"neutron.network\"}]}}, \"resources\": {}, \"outputs\": {\"router\": {\"value\": {\"get_resource\": \"router\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"name\": \"remote-nested\", \"network_name\": \"public\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',2),(101,'2025-11-29 08:00:36',NULL,'{\"heat_template_version\": \"2016-10-14\", \"resources\": {}, \"outputs\": {\"str\": {\"value\": {\"get_resource\": \"test1\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(103,'2025-11-29 08:00:42',NULL,'{\"heat_template_version\": \"2016-10-14\", \"resources\": {\"test1\": {\"type\": \"OS::Heat::TestResource\"}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(106,'2025-11-29 08:00:50',NULL,'{\"heat_template_version\": \"2016-10-14\", \"resources\": {}, \"outputs\": {\"str\": {\"value\": {\"get_resource\": \"test1\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(108,'2025-11-29 08:00:55',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(109,'2025-11-29 08:00:55',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(110,'2025-11-29 08:01:03',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"foo_step2\": {\"hooks\": \"pre-create\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(115,'2025-11-29 08:01:20',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"nested\": {\"foo_step2\": {\"hooks\": \"pre-create\"}}}, \"nested.yaml\": \"nested.yaml\"}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',3),(116,'2025-11-29 08:01:20',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"foo_step2\": {\"hooks\": \"pre-create\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',3),(118,'2025-11-29 08:01:26',NULL,'{\"heat_template_version\": \"2014-10-16\", \"parameters\": {\"image\": {\"type\": \"string\"}, \"flavor\": {\"type\": \"string\"}, \"network\": {\"type\": \"string\"}, \"foo\": {\"type\": \"string\", \"description\": \"parameter with encryption turned on\", \"hidden\": true, \"default\": \"secret\"}}, \"resources\": {}, \"outputs\": {\"encrypted_foo_param\": {\"description\": \"encrypted param\", \"value\": {\"get_param\": \"foo\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\", \"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"network\": \"heat_tempestconf_network\", \"foo\": \"my_encrypted_foo\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(122,'2025-11-29 08:01:40',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(125,'2025-11-29 08:01:44',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"foo_*\": {\"hooks\": \"pre-create\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(127,'2025-11-29 08:01:47',NULL,'{\"heat_template_version\": \"2015-10-15\", \"resources\": {}, \"outputs\": {\"resource_output_a\": {\"value\": {\"get_attr\": [\"parent\", \"resource_output_a\"]}, \"description\": \"parent a\"}, \"resource_output_b\": {\"value\": {\"get_attr\": [\"parent\", \"resource_output_b\"]}, \"description\": \"parent b\"}}}','null','{\"resource_registry\": {\"resources\": {}, \"1.yaml\": \"1.yaml\"}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',5),(128,'2025-11-29 08:01:47',NULL,'{\"heat_template_version\": \"2015-10-15\", \"resources\": {}, \"outputs\": {\"resource_output_a\": {\"description\": \"Output of resource a\", \"value\": {\"get_attr\": [\"test_resource_a\", \"output\"]}}, \"resource_output_b\": {\"description\": \"Output of resource b\", \"value\": {\"get_param\": \"foo\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',5),(134,'2025-11-29 08:02:01',NULL,'{\"heat_template_version\": \"2015-10-15\", \"resources\": {}, \"outputs\": {\"resource_output_a\": {\"description\": \"Output of resource a\", \"value\": {\"get_attr\": [\"test_resource_a\", \"output\"]}}, \"resource_output_b\": {\"description\": \"Output of resource b\", \"value\": {\"get_attr\": [\"test_resource_b\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(137,'2025-11-29 08:02:07',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"rg\": {\"hooks\": \"pre-update\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(138,'2025-11-29 08:02:07',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}, \"outputs\": {\"refs_map\": {\"value\": {\"0\": {\"get_resource\": \"0\"}, \"1\": {\"get_resource\": \"1\"}}}}}','null','{\"resource_registry\": {\"resources\": {\"hooks\": \"pre-update\"}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(141,'2025-11-29 08:02:13',NULL,'{\"heat_template_version\": \"2015-10-15\", \"resources\": {}, \"outputs\": {\"output_value\": {\"description\": \"Output of resource b\", \"value\": {\"get_attr\": [\"test_resource_b\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(142,'2025-11-29 08:02:13',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(145,'2025-11-29 08:02:20',NULL,'{\"heat_template_version\": \"2014-10-16\", \"description\": \"\\u8fd9\\u662f\\u4e00\\u4e2a\\u63cf\\u8ff0\", \"parameters\": {\"\\u53c2\\u6570\": {\"type\": \"number\", \"default\": 10, \"label\": \"\\u6807\\u7b7e\", \"description\": \"\\u8fd9\\u662f\\u4e00\\u4e2a\\u63cf\\u8ff0\"}}, \"resources\": {}, \"outputs\": {\"\\u8f93\\u51fa\": {\"description\": \"\\u8fd9\\u662f\\u4e00\\u4e2a\\u63cf\\u8ff0\", \"value\": {\"get_attr\": [\"\\u8d44\\u6e90\", \"value\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(147,'2025-11-29 08:02:25',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"foo_step2\": {\"hooks\": \"pre-update\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(150,'2025-11-29 08:02:38',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"foo_step2\": {\"hooks\": \"pre-update\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(153,'2025-11-29 08:02:54',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(155,'2025-11-29 08:03:01',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(156,'2025-11-29 08:03:02',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(159,'2025-11-29 08:03:23',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"remote_key\": {\"value\": {\"get_attr\": [\"random1\", \"value\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(174,'2025-11-29 08:03:43',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"key\": {\"value\": {\"get_attr\": [\"my_stack\", \"outputs\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',6),(175,'2025-11-29 08:03:44',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"remote_key\": {\"value\": {\"get_attr\": [\"random1\", \"value\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',7),(190,'2025-11-29 08:04:20',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"key\": {\"value\": {\"get_attr\": [\"my_stack\", \"outputs\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',8),(191,'2025-11-29 08:04:21',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"remote_key\": {\"value\": {\"get_attr\": [\"random1\", \"value\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',9),(192,'2025-11-29 08:04:24',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(193,'2025-11-29 08:04:25',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(194,'2025-11-29 08:04:26',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(196,'2025-11-29 08:04:27',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(198,'2025-11-29 08:04:34',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(199,'2025-11-29 08:04:34',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(201,'2025-11-29 08:04:35',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(203,'2025-11-29 08:04:36',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(204,'2025-11-29 08:04:40',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"key\": {\"value\": {\"get_attr\": [\"my_stack\", \"outputs\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',12),(205,'2025-11-29 08:04:41',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"remote_key\": {\"value\": {\"get_attr\": [\"random2\", \"value\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',13),(206,'2025-11-29 08:04:43',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(207,'2025-11-29 08:04:43',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(208,'2025-11-29 08:04:44',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(209,'2025-11-29 08:04:45',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(210,'2025-11-29 08:04:53',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(211,'2025-11-29 08:04:54',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(212,'2025-11-29 08:04:54',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(213,'2025-11-29 08:04:55',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(214,'2025-11-29 08:04:56',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(215,'2025-11-29 08:04:57',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(216,'2025-11-29 08:05:08',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(217,'2025-11-29 08:05:08',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(218,'2025-11-29 08:05:09',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(219,'2025-11-29 08:05:10',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(220,'2025-11-29 08:05:12',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(221,'2025-11-29 08:05:12',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(222,'2025-11-29 08:05:18',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}, \"network\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"server\": {\"value\": {\"get_resource\": \"server\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"network\": \"heat_tempestconf_network\", \"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(228,'2025-11-29 08:06:56',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"361c41e7-0e30-45d3-b923-ccbb12956704\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(229,'2025-11-29 08:06:58',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(230,'2025-11-29 08:06:59',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(231,'2025-11-29 08:07:00',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(232,'2025-11-29 08:07:10',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}, \"network\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"server\": {\"value\": {\"get_resource\": \"server\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"network\": \"heat_tempestconf_network\", \"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(234,'2025-11-29 08:07:30',NULL,'{\"heat_template_version\": \"2014-10-16\", \"description\": \"foo\", \"parameters\": {\"input\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(238,'2025-11-29 08:08:00',NULL,'{\"heat_template_version\": \"2014-10-16\", \"description\": \"foo\", \"parameters\": {\"input\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"input\": \"none\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL);
/*!40000 ALTER TABLE `raw_template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raw_template_files`
--

DROP TABLE IF EXISTS `raw_template_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `raw_template_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `files` longtext DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raw_template_files`
--

LOCK TABLES `raw_template_files` WRITE;
/*!40000 ALTER TABLE `raw_template_files` DISABLE KEYS */;
INSERT INTO `raw_template_files` (`id`, `files`, `created_at`, `updated_at`) VALUES (1,'{\"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\": \"{\\\"heat_template_version\\\": \\\"2015-10-15\\\", \\\"description\\\": \\\"The base stack (containing an actual resource) for the remote deeply-nested\\\\nstack test.\\\\n\\\", \\\"parameters\\\": {\\\"name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"Name of the router\\\", \\\"constraints\\\": [{\\\"allowed_pattern\\\": \\\"[a-z][a-z0-9-]{1,}\\\"}]}, \\\"network_name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"The network to connect to\\\", \\\"constraints\\\": [{\\\"custom_constraint\\\": \\\"neutron.network\\\"}]}}, \\\"resources\\\": {\\\"router\\\": {\\\"type\\\": \\\"OS::Neutron::Router\\\", \\\"properties\\\": {\\\"name\\\": {\\\"list_join\\\": [\\\"-\\\", [{\\\"get_param\\\": \\\"name\\\"}, \\\"router\\\"]]}, \\\"external_gateway_info\\\": {\\\"network\\\": {\\\"get_param\\\": \\\"network_name\\\"}}}}}, \\\"outputs\\\": {\\\"router\\\": {\\\"value\\\": {\\\"get_resource\\\": \\\"router\\\"}}}}\", \"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_intermediate.yaml\": \"{\\\"heat_template_version\\\": \\\"2015-10-15\\\", \\\"description\\\": \\\"The intermediate stack (containing a local nested stack) to be instantiated\\\\nremotely in the remote deeply-nested stack test.\\\\n\\\", \\\"parameters\\\": {\\\"name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"Name of the router\\\", \\\"constraints\\\": [{\\\"allowed_pattern\\\": \\\"[a-z][a-z0-9-]{1,}\\\"}]}, \\\"network_name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"The public network to connect to\\\", \\\"constraints\\\": [{\\\"custom_constraint\\\": \\\"neutron.network\\\"}]}}, \\\"resources\\\": {\\\"network_stack_as_custom_type\\\": {\\\"type\\\": \\\"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\\\", \\\"properties\\\": {\\\"name\\\": {\\\"get_param\\\": \\\"name\\\"}, \\\"network_name\\\": {\\\"get_param\\\": \\\"network_name\\\"}}}}, \\\"outputs\\\": {\\\"router\\\": {\\\"value\\\": {\\\"get_attr\\\": [\\\"network_stack_as_custom_type\\\", \\\"router\\\"]}}}}\"}','2025-11-29 08:00:20',NULL),(2,'{\"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\": \"{\\\"heat_template_version\\\": \\\"2015-10-15\\\", \\\"description\\\": \\\"The base stack (containing an actual resource) for the remote deeply-nested\\\\nstack test.\\\\n\\\", \\\"parameters\\\": {\\\"name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"Name of the router\\\", \\\"constraints\\\": [{\\\"allowed_pattern\\\": \\\"[a-z][a-z0-9-]{1,}\\\"}]}, \\\"network_name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"The network to connect to\\\", \\\"constraints\\\": [{\\\"custom_constraint\\\": \\\"neutron.network\\\"}]}}, \\\"resources\\\": {\\\"router\\\": {\\\"type\\\": \\\"OS::Neutron::Router\\\", \\\"properties\\\": {\\\"name\\\": {\\\"list_join\\\": [\\\"-\\\", [{\\\"get_param\\\": \\\"name\\\"}, \\\"router\\\"]]}, \\\"external_gateway_info\\\": {\\\"network\\\": {\\\"get_param\\\": \\\"network_name\\\"}}}}}, \\\"outputs\\\": {\\\"router\\\": {\\\"value\\\": {\\\"get_resource\\\": \\\"router\\\"}}}}\", \"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_intermediate.yaml\": \"{\\\"heat_template_version\\\": \\\"2015-10-15\\\", \\\"description\\\": \\\"The intermediate stack (containing a local nested stack) to be instantiated\\\\nremotely in the remote deeply-nested stack test.\\\\n\\\", \\\"parameters\\\": {\\\"name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"Name of the router\\\", \\\"constraints\\\": [{\\\"allowed_pattern\\\": \\\"[a-z][a-z0-9-]{1,}\\\"}]}, \\\"network_name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"The public network to connect to\\\", \\\"constraints\\\": [{\\\"custom_constraint\\\": \\\"neutron.network\\\"}]}}, \\\"resources\\\": {\\\"network_stack_as_custom_type\\\": {\\\"type\\\": \\\"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\\\", \\\"properties\\\": {\\\"name\\\": {\\\"get_param\\\": \\\"name\\\"}, \\\"network_name\\\": {\\\"get_param\\\": \\\"network_name\\\"}}}}, \\\"outputs\\\": {\\\"router\\\": {\\\"value\\\": {\\\"get_attr\\\": [\\\"network_stack_as_custom_type\\\", \\\"router\\\"]}}}}\"}','2025-11-29 08:00:21',NULL),(3,'{\"nested.yaml\": \"heat_template_version: \'2014-10-16\'\\nresources:\\n  foo_step1:\\n    type: OS::Heat::RandomString\\n  foo_step2:\\n    depends_on: foo_step1\\n    type: OS::Heat::RandomString\\n  foo_step3:\\n    depends_on: foo_step2\\n    type: OS::Heat::RandomString\\n\"}','2025-11-29 08:01:08',NULL),(5,'{\"1.yaml\": \"\\nheat_template_version: 2015-10-15\\nresources:\\n  test_resource_a:\\n    type: OS::Heat::TestResource\\n    properties:\\n      value: \'a\'\\n  test_resource_b:\\n    type: OS::Heat::TestResource\\n    properties:\\n      value: \'b\'\\noutputs:\\n  resource_output_a:\\n    description: \'Output of resource a\'\\n    value: { get_attr: [test_resource_a, output] }\\n  resource_output_b:\\n    description: \'Output of resource b\'\\n    value: { get_param: foo }\\n\"}','2025-11-29 08:01:42',NULL),(6,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}','2025-11-29 08:03:30',NULL),(7,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}','2025-11-29 08:03:31',NULL),(8,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}','2025-11-29 08:03:58',NULL),(9,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}','2025-11-29 08:04:02',NULL),(12,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random2:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random2, value]}\\n\"}','2025-11-29 08:04:34',NULL),(13,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random2:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random2, value]}\\n\"}','2025-11-29 08:04:35',NULL);
/*!40000 ALTER TABLE `raw_template_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource`
--

DROP TABLE IF EXISTS `resource`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) DEFAULT NULL,
  `nova_instance` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  `rsrc_metadata` longtext DEFAULT NULL,
  `properties_data` longtext DEFAULT NULL,
  `engine_id` varchar(36) DEFAULT NULL,
  `atomic_key` int(11) DEFAULT NULL,
  `needed_by` longtext DEFAULT NULL,
  `requires` longtext DEFAULT NULL,
  `replaces` int(11) DEFAULT NULL,
  `replaced_by` int(11) DEFAULT NULL,
  `current_template_id` int(11) DEFAULT NULL,
  `properties_data_encrypted` tinyint(1) DEFAULT NULL,
  `root_stack_id` varchar(36) DEFAULT NULL,
  `rsrc_prop_data_id` int(11) DEFAULT NULL,
  `attr_data_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `stack_id` (`stack_id`),
  KEY `current_template_id` (`current_template_id`),
  KEY `ix_resource_root_stack_id` (`root_stack_id`),
  KEY `rsrc_rsrc_prop_data_ref` (`rsrc_prop_data_id`),
  KEY `rsrc_attr_data_ref` (`attr_data_id`),
  CONSTRAINT `resource_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`),
  CONSTRAINT `resource_ibfk_2` FOREIGN KEY (`current_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `rsrc_attr_data_ref` FOREIGN KEY (`attr_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `rsrc_rsrc_prop_data_ref` FOREIGN KEY (`rsrc_prop_data_id`) REFERENCES `resource_properties_data` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=230 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource`
--

LOCK TABLES `resource` WRITE;
/*!40000 ALTER TABLE `resource` DISABLE KEYS */;
INSERT INTO `resource` (`id`, `uuid`, `nova_instance`, `name`, `created_at`, `updated_at`, `action`, `status`, `status_reason`, `stack_id`, `rsrc_metadata`, `properties_data`, `engine_id`, `atomic_key`, `needed_by`, `requires`, `replaces`, `replaced_by`, `current_template_id`, `properties_data_encrypted`, `root_stack_id`, `rsrc_prop_data_id`, `attr_data_id`) VALUES (1,'f41e4938-3ce3-4fe3-b51c-bb9a6a148fcb','api-1226968400-rsrcstack-test-7yz44p2b4sjy','test','2025-11-29 07:56:39',NULL,'CREATE','COMPLETE','state changed','39e3c4d0-31c3-472a-9429-e6d50903e0de','{}','null',NULL,2,'[]','[]',NULL,NULL,4,NULL,'39e3c4d0-31c3-472a-9429-e6d50903e0de',1,NULL),(2,'d035955d-a29a-48c0-ac62-f5dd544b29a7','api-1592030466-envstack-test-rqfctlidlfk5','test','2025-11-29 07:56:39',NULL,'CREATE','COMPLETE','state changed','73cbbbd3-2559-48d0-adeb-273aa21173f6','{}','null',NULL,2,'[]','[]',NULL,NULL,2,NULL,'73cbbbd3-2559-48d0-adeb-273aa21173f6',2,NULL),(5,'6bdc92d4-84f5-4c19-8350-fbe702d36efc','api-28086934-rsrcstack-test-ygme6vv5zewu','test','2025-11-29 07:56:42',NULL,'CREATE','COMPLETE','state changed','eede8308-afc1-45ef-b05b-7d9d5c707cdb','{}','null',NULL,2,'[]','[]',NULL,NULL,6,NULL,'eede8308-afc1-45ef-b05b-7d9d5c707cdb',5,NULL),(6,'612a1b30-37f7-4018-bdbd-32c842af6c41','api-1592030466-rsrcstack-test-agbx65qsugzq','test','2025-11-29 07:56:43',NULL,'CHECK','FAILED','resource deleted','9f57d290-4c23-407f-9a7c-c5b53e74baf3','{}','null',NULL,4,'[]','[]',NULL,NULL,7,NULL,'9f57d290-4c23-407f-9a7c-c5b53e74baf3',6,NULL),(7,'439ffbd6-b642-4a51-b8bb-a106b8632d02','api-1226968400-stack-test-uunwijbz766w','test','2025-11-29 07:56:48',NULL,'CREATE','COMPLETE','state changed','4ac64ef8-0fe2-479c-8365-5b13dd0dd5aa','{}','null',NULL,2,'[]','[]',NULL,NULL,13,NULL,'4ac64ef8-0fe2-479c-8365-5b13dd0dd5aa',7,NULL),(9,'ef86b2cd-d014-460c-b7e7-d3035bd2dc3f','api-28086934-stack-test-mdgqctxynmwn','test','2025-11-29 07:56:50','2025-11-29 07:56:51','UPDATE','COMPLETE','state changed','00018af1-0bcd-47f5-b95e-1d4b9e14aa98','{}','null',NULL,4,'[]','[]',NULL,NULL,20,NULL,'00018af1-0bcd-47f5-b95e-1d4b9e14aa98',12,NULL),(10,'62a2eb22-1d18-4c44-8da6-b33086e5ada3','api-1592030466-stack-test-yra5dbrkf2zc','test','2025-11-29 07:56:52','2025-11-29 07:56:58','UPDATE','COMPLETE','state changed','4a915ecb-a078-4c37-ae7d-1f59204f6d4e','{}','null',NULL,6,'[]','[]',NULL,NULL,27,NULL,'4a915ecb-a078-4c37-ae7d-1f59204f6d4e',21,NULL);
/*!40000 ALTER TABLE `resource` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_data`
--

DROP TABLE IF EXISTS `resource_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  `redact` tinyint(1) DEFAULT NULL,
  `decrypt_method` varchar(64) DEFAULT NULL,
  `resource_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_resource_id` (`resource_id`),
  CONSTRAINT `fk_resource_id` FOREIGN KEY (`resource_id`) REFERENCES `resource` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=251 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource_data`
--

LOCK TABLES `resource_data` WRITE;
/*!40000 ALTER TABLE `resource_data` DISABLE KEYS */;
INSERT INTO `resource_data` (`id`, `created_at`, `updated_at`, `key`, `value`, `redact`, `decrypt_method`, `resource_id`) VALUES (1,'2025-11-29 07:56:39',NULL,'value','test',0,'',1),(2,'2025-11-29 07:56:39',NULL,'value','test',0,'',2),(5,'2025-11-29 07:56:42',NULL,'value','test',0,'',5),(6,'2025-11-29 07:56:43',NULL,'value','test',0,'',6),(7,'2025-11-29 07:56:48',NULL,'value','value',0,'',7),(9,'2025-11-29 07:56:50','2025-11-29 07:56:51','value','new_value',0,'',9),(10,'2025-11-29 07:56:52','2025-11-29 07:56:58','value','new_patched_value',0,'',10);
/*!40000 ALTER TABLE `resource_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_properties_data`
--

DROP TABLE IF EXISTS `resource_properties_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource_properties_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `data` longtext DEFAULT NULL,
  `encrypted` tinyint(1) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=251 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource_properties_data`
--

LOCK TABLES `resource_properties_data` WRITE;
/*!40000 ALTER TABLE `resource_properties_data` DISABLE KEYS */;
INSERT INTO `resource_properties_data` (`id`, `data`, `encrypted`, `created_at`, `updated_at`) VALUES (1,'{\"value\": \"test\"}',0,'2025-11-29 07:56:39',NULL),(2,'{\"value\": \"test\"}',0,'2025-11-29 07:56:39',NULL),(3,'{\"value\": \"test\"}',0,'2025-11-29 07:56:39',NULL),(4,'{\"value\": \"test\"}',0,'2025-11-29 07:56:39',NULL),(5,'{\"value\": \"test\"}',0,'2025-11-29 07:56:42',NULL),(6,'{\"value\": \"test\"}',0,'2025-11-29 07:56:43',NULL),(7,'{\"value\": \"value\"}',0,'2025-11-29 07:56:48',NULL),(8,'{\"value\": \"value\"}',0,'2025-11-29 07:56:49',NULL),(9,'{\"value\": \"value\"}',0,'2025-11-29 07:56:50',NULL),(10,'{\"value\": \"value\"}',0,'2025-11-29 07:56:52',NULL),(11,'{\"value\": \"new_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2025-11-29 07:56:53',NULL),(12,'{\"value\": \"new_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2025-11-29 07:56:53',NULL),(13,'{\"enable_dhcp\": false, \"network\": \"2ca42ab1-53e9-4912-a274-f87773210dfd\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-11-29 07:56:55',NULL),(14,'{\"value\": \"new_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2025-11-29 07:56:57',NULL),(15,'{\"value\": \"new_patched_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2025-11-29 07:56:57',NULL),(16,'{\"network\": \"2ca42ab1-53e9-4912-a274-f87773210dfd\", \"mac_address\": \"00-00-00-00-BB-BB\", \"fixed_ips\": [{\"subnet\": \"1d38483f-4579-43f1-aafd-6c2c5956219c\", \"ip_address\": \"11.11.11.11\"}]}',0,'2025-11-29 07:56:58',NULL),(17,'{\"name\": \"LUKS\"}',0,'2025-11-29 07:56:59',NULL),(18,'{\"provider\": \"nova.volume.encryptors.luks.LuksEncryptor\", \"control_location\": \"front-end\", \"cipher\": \"aes-xts-plain64\", \"key_size\": 512, \"volume_type\": \"80708cfd-e1ee-4e29-b100-8090d4d2d40f\"}',0,'2025-11-29 07:56:59',NULL),(20,'{\"value\": \"Test1\", \"fail\": false}',0,'2025-11-29 07:57:00',NULL),(21,'{\"value\": \"new_patched_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2025-11-29 07:57:00',NULL),(22,'{\"cidr\": \"10.20.0.0/16\", \"network\": \"7cca3bf8-a5c0-44ad-b139-0689e7cf9637\"}',0,'2025-11-29 07:57:02',NULL),(23,'{\"cidr\": \"10.0.0.0/16\", \"network\": \"fe9c61f0-6529-4d74-9bdd-352b3cfdc6ab\"}',0,'2025-11-29 07:57:03',NULL),(24,'{\"cidr\": \"10.10.0.0/16\", \"network\": \"c6c622e7-c69d-4cf7-9127-8a1343663b15\"}',0,'2025-11-29 07:57:04',NULL),(25,'{\"name\": \"the_net\"}',0,'2025-11-29 07:57:04',NULL),(26,'{\"name\": \"trunk_sub_port_two\", \"network\": \"7cca3bf8-a5c0-44ad-b139-0689e7cf9637\"}',0,'2025-11-29 07:57:05',NULL),(27,'{\"name\": \"trunk_sub_port_one\", \"network\": \"c6c622e7-c69d-4cf7-9127-8a1343663b15\"}',0,'2025-11-29 07:57:05',NULL),(28,'{\"provider\": \"nova.volume.encryptors.luks.LuksEncryptor\", \"control_location\": \"front-end\", \"cipher\": \"aes-cbc-essiv\", \"key_size\": 256, \"volume_type\": \"80708cfd-e1ee-4e29-b100-8090d4d2d40f\"}',0,'2025-11-29 07:57:05',NULL),(29,'{\"name\": \"the_subnet\", \"network\": \"324fac70-4472-4ec6-9f8d-a12293ae7bcc\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-11-29 07:57:06',NULL),(30,'{\"name\": \"trunk_parent_port\", \"network\": \"fe9c61f0-6529-4d74-9bdd-352b3cfdc6ab\"}',0,'2025-11-29 07:57:07',NULL),(31,'{\"network\": \"2ca42ab1-53e9-4912-a274-f87773210dfd\", \"mac_address\": \"00-00-00-00-BB-BB\", \"fixed_ips\": [{\"subnet\": \"1d38483f-4579-43f1-aafd-6c2c5956219c\"}]}',0,'2025-11-29 07:57:07',NULL),(33,'{\"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\", \"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"networks\": [{\"subnet\": \"3bf3daea-a1df-4654-8e41-0b6ed87c6718\"}]}',0,'2025-11-29 07:57:10',NULL),(34,'{\"name\": \"test_trunk\", \"port\": \"41880895-0d10-4663-b2b8-b16c310c5fa2\", \"sub_ports\": [{\"port\": \"f78b19a0-ccc4-4a9d-bc89-e8a6abfe9e42\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}]}',0,'2025-11-29 07:57:10',NULL),(35,'{\"name\": \"server_with_port_net\"}',0,'2025-11-29 07:57:17',NULL),(36,'{\"network\": \"f056f153-badf-4cf8-8989-4d48564077a6\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-11-29 07:57:21',NULL),(37,'{\"network\": \"f056f153-badf-4cf8-8989-4d48564077a6\", \"fixed_ips\": [{\"subnet\": \"61e6fe18-18b4-4185-9be0-8fe16c868b7c\", \"ip_address\": \"11.11.11.11\"}]}',0,'2025-11-29 07:57:24',NULL),(38,'{\"name\": \"test_trunk\", \"port\": \"41880895-0d10-4663-b2b8-b16c310c5fa2\", \"sub_ports\": [{\"port\": \"f78b19a0-ccc4-4a9d-bc89-e8a6abfe9e42\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}, {\"port\": \"97c0da32-4a60-4a75-922b-8a5167941bff\", \"segmentation_id\": 20, \"segmentation_type\": \"vlan\"}]}',0,'2025-11-29 07:57:24',NULL),(39,'{\"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\", \"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"networks\": [{\"port\": \"63838e32-d696-42a3-9f2c-19aa82c4c46a\"}]}',0,'2025-11-29 07:57:25',NULL),(40,'{\"enable_dhcp\": false, \"network\": \"388713bc-4068-4ab0-ab6c-f836c0d67bcc\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-11-29 07:57:26',NULL),(41,'{\"network\": \"388713bc-4068-4ab0-ab6c-f836c0d67bcc\", \"mac_address\": \"00-00-00-00-BB-BB\", \"fixed_ips\": [{\"subnet\": \"ccb0264b-dcc8-41fb-9343-c5bbccdb143f\", \"ip_address\": \"11.11.11.11\"}]}',0,'2025-11-29 07:57:27',NULL),(43,'{\"value\": \"Test1\", \"fail\": false}',0,'2025-11-29 07:57:28',NULL),(45,'{\"network\": \"388713bc-4068-4ab0-ab6c-f836c0d67bcc\", \"mac_address\": \"00-00-00-00-AA-AA\", \"fixed_ips\": [{\"subnet\": \"ccb0264b-dcc8-41fb-9343-c5bbccdb143f\", \"ip_address\": \"11.11.11.11\"}]}',0,'2025-11-29 07:57:33',NULL),(48,'{\"network\": \"ede51b05-7227-4f2b-980a-7d9e32ec23a5\", \"cidr\": \"10.0.0.0/16\"}',0,'2025-11-29 07:57:41',NULL),(49,'{\"network\": \"eb3501aa-2d73-47a3-a775-5715787dcea0\", \"cidr\": \"10.20.0.0/16\"}',0,'2025-11-29 07:57:41',NULL),(50,'{\"network\": \"eed5566b-6330-4837-9ce5-adee7ae4efc3\", \"cidr\": \"10.10.0.0/16\"}',0,'2025-11-29 07:57:42',NULL),(51,'{\"network\": \"ede51b05-7227-4f2b-980a-7d9e32ec23a5\", \"name\": \"trunk_parent_port\"}',0,'2025-11-29 07:57:45',NULL),(52,'{\"network\": \"eb3501aa-2d73-47a3-a775-5715787dcea0\", \"name\": \"trunk_sub_port_two\"}',0,'2025-11-29 07:57:45',NULL),(53,'{\"network\": \"eed5566b-6330-4837-9ce5-adee7ae4efc3\", \"name\": \"trunk_sub_port_one\"}',0,'2025-11-29 07:57:46',NULL),(54,'{\"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\", \"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"networks\": [{\"network\": \"324fac70-4472-4ec6-9f8d-a12293ae7bcc\", \"subnet\": \"3bf3daea-a1df-4654-8e41-0b6ed87c6718\"}]}',0,'2025-11-29 07:57:46',NULL),(55,'{\"name\": \"test_trunk\", \"port\": \"559d69a7-8cfb-4182-a372-ab0d0f626603\", \"sub_ports\": null}',0,'2025-11-29 07:57:47',NULL),(56,'{\"network\": \"ff44d876-2ec7-48da-811f-df5c8ee9835b\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2025-11-29 07:57:50',NULL),(59,'{\"name\": \"the_sg\", \"description\": \"Ping and SSH\", \"rules\": [{\"protocol\": \"icmp\"}, {\"protocol\": \"tcp\", \"port_range_min\": 22, \"port_range_max\": 22}]}',0,'2025-11-29 07:57:55',NULL),(60,'{\"name\": \"test_trunk\", \"port\": \"559d69a7-8cfb-4182-a372-ab0d0f626603\", \"sub_ports\": [{\"port\": \"1145ac9d-c493-47e2-a564-f27e815f4dac\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}]}',0,'2025-11-29 07:57:56',NULL),(61,'{\"network\": \"ff44d876-2ec7-48da-811f-df5c8ee9835b\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.100\"}]}',0,'2025-11-29 07:57:56',NULL),(62,'{\"name\": \"my_net\"}',0,'2025-11-29 07:57:56',NULL),(63,'{\"network\": \"86014e83-f5c8-453f-9cd3-d991b39b0d07\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-11-29 07:57:57',NULL),(64,'{\"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\", \"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"networks\": [{\"subnet\": \"dce54c29-0492-4d87-a69e-fa72bd73b07a\", \"fixed_ip\": \"11.11.11.11\"}], \"security_groups\": [\"b43eef53-858f-4052-ba76-3d1b2dddc01b\"]}',0,'2025-11-29 07:57:59',NULL),(67,'{\"name\": \"the_net\"}',0,'2025-11-29 07:58:02',NULL),(68,'{\"name\": \"the_subnet\", \"network\": \"e8a31be0-97a2-4c4a-8bdc-e33e47d0a99d\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-11-29 07:58:03',NULL),(69,'{\"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\", \"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"networks\": [{\"network\": \"e8a31be0-97a2-4c4a-8bdc-e33e47d0a99d\"}]}',0,'2025-11-29 07:58:05',NULL),(70,'{\"network\": \"b524b8a2-247a-413d-abfd-e8b9c8a09e08\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2025-11-29 07:58:30',NULL),(71,'{\"cidr\": \"10.10.0.0/16\", \"network\": \"ae969a25-dfed-469d-a39e-b02fda585390\"}',0,'2025-11-29 07:58:31',NULL),(72,'{\"cidr\": \"10.20.0.0/16\", \"network\": \"95973035-ddf5-44f9-bfc1-4a513fef4d85\"}',0,'2025-11-29 07:58:31',NULL),(73,'{\"cidr\": \"10.0.0.0/16\", \"network\": \"eee24d61-33f6-4879-8595-d20872aa9056\"}',0,'2025-11-29 07:58:31',NULL),(74,'{\"name\": \"trunk_sub_port_two\", \"network\": \"95973035-ddf5-44f9-bfc1-4a513fef4d85\"}',0,'2025-11-29 07:58:34',NULL),(75,'{\"name\": \"trunk_sub_port_one\", \"network\": \"ae969a25-dfed-469d-a39e-b02fda585390\"}',0,'2025-11-29 07:58:36',NULL),(76,'{\"name\": \"trunk_parent_port\", \"network\": \"eee24d61-33f6-4879-8595-d20872aa9056\"}',0,'2025-11-29 07:58:36',NULL),(79,'{\"name\": \"test_trunk\", \"port\": \"398178a7-a033-4213-933a-7b4dfd33e12f\", \"sub_ports\": [{\"port\": \"5c4b0e1d-0c14-46ae-985b-67b797475186\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}]}',0,'2025-11-29 07:58:39',NULL),(80,'{\"network\": \"b524b8a2-247a-413d-abfd-e8b9c8a09e08\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": []}',0,'2025-11-29 07:58:40',NULL),(83,'{\"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\", \"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"networks\": [{\"network\": \"e8a31be0-97a2-4c4a-8bdc-e33e47d0a99d\", \"fixed_ip\": \"11.11.11.8\"}]}',0,'2025-11-29 07:58:50',NULL),(84,'{\"name\": \"test_trunk\", \"port\": \"398178a7-a033-4213-933a-7b4dfd33e12f\", \"sub_ports\": []}',0,'2025-11-29 07:58:54',NULL),(86,'{\"network\": \"0dd42ac1-019b-48ae-b76c-6e1fb166388b\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2025-11-29 07:58:59',NULL),(87,'{\"name\": \"the_net\"}',0,'2025-11-29 07:58:59',NULL),(89,'{\"network\": \"eecd6003-fac5-419b-9548-542726bd10fc\", \"cidr\": \"12.12.12.0/24\", \"name\": \"subnet_b\"}',0,'2025-11-29 07:59:00',NULL),(90,'{\"network\": \"eecd6003-fac5-419b-9548-542726bd10fc\", \"cidr\": \"11.11.11.0/24\", \"name\": \"subnet_a\"}',0,'2025-11-29 07:59:00',NULL),(91,'{\"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\", \"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"networks\": [{\"subnet\": \"6c3098e2-293f-43d0-b6a9-894ddb73c36c\"}]}',0,'2025-11-29 07:59:04',NULL),(93,'{\"network\": \"0dd42ac1-019b-48ae-b76c-6e1fb166388b\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.9\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2025-11-29 07:59:07',NULL),(94,'{\"name\": \"the_net\"}',0,'2025-11-29 07:59:07',NULL),(95,'{\"name\": \"the_subnet\", \"network\": \"97cbc105-a076-4727-b663-f01e649bcbf7\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-11-29 07:59:08',NULL),(96,'{\"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\", \"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"networks\": [{\"network\": \"97cbc105-a076-4727-b663-f01e649bcbf7\"}]}',0,'2025-11-29 07:59:10',NULL),(98,'{\"cidr\": \"10.20.0.0/16\", \"network\": \"a3d3c3bd-060e-4ce2-96d2-fbffb0280374\"}',0,'2025-11-29 07:59:12',NULL),(99,'{\"cidr\": \"10.0.0.0/16\", \"network\": \"c9d5a9eb-8646-4e05-bdbe-ffb37bdf6c1a\"}',0,'2025-11-29 07:59:16',NULL),(100,'{\"name\": \"trunk_sub_port_two\", \"network\": \"a3d3c3bd-060e-4ce2-96d2-fbffb0280374\"}',0,'2025-11-29 07:59:17',NULL),(101,'{\"cidr\": \"10.10.0.0/16\", \"network\": \"74cdb224-52bb-4c29-b7d7-9ba65edf8284\"}',0,'2025-11-29 07:59:17',NULL),(102,'{\"name\": \"trunk_parent_port\", \"network\": \"c9d5a9eb-8646-4e05-bdbe-ffb37bdf6c1a\"}',0,'2025-11-29 07:59:17',NULL),(103,'{\"network\": \"5eea2e3a-bc23-4d8d-a1b7-8ac03906f286\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2025-11-29 07:59:19',NULL),(104,'{\"name\": \"trunk_sub_port_one\", \"network\": \"74cdb224-52bb-4c29-b7d7-9ba65edf8284\"}',0,'2025-11-29 07:59:20',NULL),(105,'{\"name\": \"test_trunk\", \"port\": \"49ba949a-4a3e-4df1-b33c-47c0bee2664a\", \"sub_ports\": [{\"port\": \"a8e02321-3a4b-4ac9-9b2b-dd77b8331132\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}, {\"port\": \"854738c5-3f8b-4395-a4d4-64a2713a445f\", \"segmentation_id\": 20, \"segmentation_type\": \"vlan\"}]}',0,'2025-11-29 07:59:25',NULL),(108,'{\"network\": \"5eea2e3a-bc23-4d8d-a1b7-8ac03906f286\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": null, \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2025-11-29 07:59:34',NULL),(111,'{\"name\": \"test_trunk\", \"port\": \"49ba949a-4a3e-4df1-b33c-47c0bee2664a\", \"sub_ports\": [{\"port\": \"a8e02321-3a4b-4ac9-9b2b-dd77b8331132\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}]}',0,'2025-11-29 07:59:39',NULL),(112,'{\"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\", \"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"networks\": [{\"network\": \"97cbc105-a076-4727-b663-f01e649bcbf7\", \"subnet\": \"f9c21400-fbff-4123-864e-cf13206f2c00\"}]}',0,'2025-11-29 07:59:40',NULL),(115,'{\"network\": \"bcee4ba6-9b15-4254-82ef-3456258509bb\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2025-11-29 07:59:47',NULL),(116,'{\"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\", \"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"networks\": [{\"subnet\": \"164779e4-2bcb-4ec5-80a4-57a749b90764\"}]}',0,'2025-11-29 07:59:48',NULL),(119,'{\"network\": \"bcee4ba6-9b15-4254-82ef-3456258509bb\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\"}',0,'2025-11-29 07:59:56',NULL),(120,'{\"name\": \"the_net\"}',0,'2025-11-29 07:59:57',NULL),(121,'{\"cidr\": \"10.20.0.0/16\", \"network\": \"73924a76-f881-4f1d-9f07-4d37f076b63e\"}',0,'2025-11-29 07:59:57',NULL),(122,'{\"name\": \"the_subnet\", \"network\": \"7d9230f5-9cad-4dd3-8785-36e7a0e4b56a\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-11-29 07:59:58',NULL),(123,'{\"cidr\": \"10.0.0.0/16\", \"network\": \"b0b40f24-465d-4777-b809-c36c792fffcf\"}',0,'2025-11-29 07:59:59',NULL),(125,'{\"name\": \"trunk_sub_port_two\", \"network\": \"73924a76-f881-4f1d-9f07-4d37f076b63e\"}',0,'2025-11-29 07:59:59',NULL),(126,'{\"cidr\": \"10.10.0.0/16\", \"network\": \"0e647a4d-759a-49ac-b761-9b398b8c5e5e\"}',0,'2025-11-29 08:00:00',NULL),(127,'{\"name\": \"trunk_parent_port\", \"network\": \"b0b40f24-465d-4777-b809-c36c792fffcf\"}',0,'2025-11-29 08:00:01',NULL),(128,'{\"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\", \"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"networks\": [{\"network\": \"7d9230f5-9cad-4dd3-8785-36e7a0e4b56a\"}, {\"network\": \"7d9230f5-9cad-4dd3-8785-36e7a0e4b56a\", \"fixed_ip\": \"11.11.11.33\"}, {\"subnet\": \"8ce9ffd4-75b0-4665-b518-5fc71c65397a\"}]}',0,'2025-11-29 08:00:01',NULL),(129,'{\"name\": \"trunk_sub_port_one\", \"network\": \"0e647a4d-759a-49ac-b761-9b398b8c5e5e\"}',0,'2025-11-29 08:00:02',NULL),(130,'{\"value\": \"test1\", \"fail\": false, \"update_replace\": false, \"wait_secs\": 0}',0,'2025-11-29 08:00:03',NULL),(131,'{\"name\": \"test_trunk\", \"port\": \"b7766a31-7cbe-4794-bbe2-f91fa11450dd\", \"sub_ports\": [{\"port\": \"42f4e448-3a15-47f1-a7c7-fb45931ec399\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}]}',0,'2025-11-29 08:00:04',NULL),(132,'{\"network\": \"a2186685-9d10-4908-b1eb-cdea67d90867\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2025-11-29 08:00:06',NULL),(134,'{\"update_replace\": false, \"wait_secs\": 0, \"value\": \"Test1\", \"fail\": false}',0,'2025-11-29 08:00:13',NULL),(135,'{\"network\": \"a2186685-9d10-4908-b1eb-cdea67d90867\", \"cidr\": \"11.11.11.0/24\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2025-11-29 08:00:13',NULL),(136,'{\"name\": \"test_trunk\", \"port\": \"b7766a31-7cbe-4794-bbe2-f91fa11450dd\", \"sub_ports\": [{\"port\": \"42f4e448-3a15-47f1-a7c7-fb45931ec399\", \"segmentation_id\": 99, \"segmentation_type\": \"vlan\"}]}',0,'2025-11-29 08:00:16',NULL),(139,'{\"context\": {\"region_name\": \"regionOne\"}, \"parameters\": {\"name\": \"remote-nested\", \"network_name\": \"public\"}, \"template\": \"{\\\"heat_template_version\\\": \\\"2015-10-15\\\", \\\"description\\\": \\\"The intermediate stack (containing a local nested stack) to be instantiated\\\\nremotely in the remote deeply-nested stack test.\\\\n\\\", \\\"parameters\\\": {\\\"name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"Name of the router\\\", \\\"constraints\\\": [{\\\"allowed_pattern\\\": \\\"[a-z][a-z0-9-]{1,}\\\"}]}, \\\"network_name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"The public network to connect to\\\", \\\"constraints\\\": [{\\\"custom_constraint\\\": \\\"neutron.network\\\"}]}}, \\\"resources\\\": {\\\"network_stack_as_custom_type\\\": {\\\"type\\\": \\\"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\\\", \\\"properties\\\": {\\\"name\\\": {\\\"get_param\\\": \\\"name\\\"}, \\\"network_name\\\": {\\\"get_param\\\": \\\"network_name\\\"}}}}, \\\"outputs\\\": {\\\"router\\\": {\\\"value\\\": {\\\"get_attr\\\": [\\\"network_stack_as_custom_type\\\", \\\"router\\\"]}}}}\"}',0,'2025-11-29 08:00:21',NULL),(140,'{\"name\": \"remote-nested\", \"network_name\": \"public\"}',0,'2025-11-29 08:00:22',NULL),(141,'{\"name\": \"remote-nested-router\", \"external_gateway_info\": {\"network\": \"public\"}}',0,'2025-11-29 08:00:22',NULL),(144,'{\"network\": \"6bbc9f83-8973-435b-ae39-482dd3c616c3\", \"cidr\": \"10.10.0.0/16\"}',0,'2025-11-29 08:00:35',NULL),(145,'{\"network\": \"f67f2bde-04a1-468b-ba30-4801983f116a\", \"cidr\": \"10.0.0.0/16\"}',0,'2025-11-29 08:00:35',NULL),(146,'{\"network\": \"6c404bb7-55df-423f-9c18-256941fc490a\", \"cidr\": \"10.20.0.0/16\"}',0,'2025-11-29 08:00:36',NULL),(147,'{\"network\": \"f67f2bde-04a1-468b-ba30-4801983f116a\", \"name\": \"trunk_parent_port\"}',0,'2025-11-29 08:00:37',NULL),(148,'{\"network\": \"6bbc9f83-8973-435b-ae39-482dd3c616c3\", \"name\": \"trunk_sub_port_one\"}',0,'2025-11-29 08:00:37',NULL),(150,'{\"network\": \"6c404bb7-55df-423f-9c18-256941fc490a\", \"name\": \"trunk_sub_port_two\"}',0,'2025-11-29 08:00:39',NULL),(151,'{\"name\": \"test_trunk\", \"port\": \"f87ed0d1-a82c-4e0f-a458-a35aed7b1849\", \"sub_ports\": null}',0,'2025-11-29 08:00:39',NULL),(152,'{\"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\", \"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"networks\": [{\"subnet\": \"8ce9ffd4-75b0-4665-b518-5fc71c65397a\"}, {\"network\": \"7d9230f5-9cad-4dd3-8785-36e7a0e4b56a\"}, {\"network\": \"7d9230f5-9cad-4dd3-8785-36e7a0e4b56a\", \"subnet\": \"8ce9ffd4-75b0-4665-b518-5fc71c65397a\"}]}',0,'2025-11-29 08:00:49',NULL),(153,'{\"description\": \"This is a test trunk\", \"name\": \"pineapple\", \"port\": \"f87ed0d1-a82c-4e0f-a458-a35aed7b1849\", \"sub_ports\": null}',0,'2025-11-29 08:00:52',NULL),(156,'{\"name\": \"my_encrypted_foo\", \"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\", \"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"networks\": [{\"network\": \"heat_tempestconf_network\"}]}',0,'2025-11-29 08:01:08',NULL),(157,'{\"name\": \"the_net\"}',0,'2025-11-29 08:01:08',NULL),(158,'{\"name\": \"the_subnet\", \"network\": \"66890a39-54ff-40bb-b39d-49fb504b2286\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-11-29 08:01:10',NULL),(159,'{\"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\", \"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"networks\": [{\"network\": \"66890a39-54ff-40bb-b39d-49fb504b2286\"}]}',0,'2025-11-29 08:01:13',NULL),(161,'{\"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\", \"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"networks\": [{\"port\": \"52027c52-8a03-424d-8216-199ca77acdf5\"}]}',0,'2025-11-29 08:01:35',NULL),(162,'{\"value\": \"a\"}',0,'2025-11-29 08:01:37',NULL),(163,'{\"value\": \"b\"}',0,'2025-11-29 08:01:38',NULL),(165,'{\"name\": \"the_net\"}',0,'2025-11-29 08:01:46',NULL),(167,'{\"name\": \"the_subnet\", \"network\": \"78106bbb-0777-483c-94c8-14e24cb421fc\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-11-29 08:01:47',NULL),(168,'{\"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\", \"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"networks\": [{\"network\": \"78106bbb-0777-483c-94c8-14e24cb421fc\"}]}',0,'2025-11-29 08:01:48',NULL),(169,'{\"count\": 1, \"resource_def\": {\"type\": \"OS::Heat::RandomString\"}}',0,'2025-11-29 08:01:49',NULL),(170,'{\"value\": \"b\"}',0,'2025-11-29 08:01:54',NULL),(171,'{\"value\": \"a\"}',0,'2025-11-29 08:01:55',NULL),(172,'{\"count\": 2, \"resource_def\": {\"type\": \"OS::Heat::RandomString\"}}',0,'2025-11-29 08:02:01',NULL),(174,'{\"value\": \"foo\"}',0,'2025-11-29 08:02:07',NULL),(175,'{\"value\": \"foo\"}',0,'2025-11-29 08:02:09',NULL),(176,'{\"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\", \"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"networks\": [{\"subnet\": \"09e64cdc-d97b-4b61-bbfb-8d46b750f595\"}]}',0,'2025-11-29 08:02:10',NULL),(178,'{\"length\": 10}',0,'2025-11-29 08:02:19',NULL),(179,'{\"name\": \"the_net\"}',0,'2025-11-29 08:02:26',NULL),(180,'{\"name\": \"the_subnet\", \"network\": \"7ddb4ea6-1e98-4edd-836e-6da2e5aefd3b\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-11-29 08:02:27',NULL),(181,'{\"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\", \"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"networks\": [{\"subnet\": \"cdbcb4f0-49cf-40bd-a5ee-5048ef0e9a20\"}]}',0,'2025-11-29 08:02:29',NULL),(182,'{\"length\": 10}',0,'2025-11-29 08:02:34',NULL),(183,'{\"value\": \"Test1\"}',0,'2025-11-29 08:02:50',NULL),(184,'{\"value\": \"Test2\"}',0,'2025-11-29 08:02:50',NULL),(186,'{\"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\", \"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"networks\": [{\"network\": \"7ddb4ea6-1e98-4edd-836e-6da2e5aefd3b\"}]}',0,'2025-11-29 08:02:57',NULL),(188,'{\"value\": \"Test1\"}',0,'2025-11-29 08:03:01',NULL),(189,'{\"value\": \"Test2\"}',0,'2025-11-29 08:03:01',NULL),(190,'{\"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\", \"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"user_data_format\": \"SOFTWARE_CONFIG\", \"networks\": [{\"network\": \"heat_tempestconf_network\"}]}',0,'2025-11-29 08:03:10',NULL),(191,'{\"context\": {\"region_name\": \"regionOne\"}, \"template\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}',0,'2025-11-29 08:03:31',NULL),(192,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2025-11-29 08:03:39',NULL),(193,'{\"config\": \"d98b1bb2-4b78-403f-8c5d-9d9b031a087c\", \"servers\": {\"0\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}}',0,'2025-11-29 08:03:40',NULL),(194,'{\"config\": \"d98b1bb2-4b78-403f-8c5d-9d9b031a087c\", \"servers\": {\"0\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}}',0,'2025-11-29 08:03:40',NULL),(195,'{\"config\": \"d98b1bb2-4b78-403f-8c5d-9d9b031a087c\", \"servers\": {\"0\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}}',0,'2025-11-29 08:03:40',NULL),(196,'{\"config\": \"d98b1bb2-4b78-403f-8c5d-9d9b031a087c\", \"servers\": {\"0\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}}',0,'2025-11-29 08:03:40',NULL),(197,'{\"config\": \"d98b1bb2-4b78-403f-8c5d-9d9b031a087c\", \"servers\": {\"0\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}}',0,'2025-11-29 08:03:40',NULL),(198,'{\"config\": \"d98b1bb2-4b78-403f-8c5d-9d9b031a087c\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}',0,'2025-11-29 08:03:41',NULL),(199,'{\"config\": \"d98b1bb2-4b78-403f-8c5d-9d9b031a087c\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}',0,'2025-11-29 08:03:41',NULL),(200,'{\"config\": \"d98b1bb2-4b78-403f-8c5d-9d9b031a087c\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}',0,'2025-11-29 08:03:41',NULL),(201,'{\"config\": \"d98b1bb2-4b78-403f-8c5d-9d9b031a087c\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}',0,'2025-11-29 08:03:41',NULL),(202,'{\"config\": \"d98b1bb2-4b78-403f-8c5d-9d9b031a087c\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}',0,'2025-11-29 08:03:41',NULL),(204,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2025-11-29 08:03:41',NULL),(205,'{\"config\": \"19a63e85-6980-4440-b52f-0726ad7cab45\", \"servers\": {\"0\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}}',0,'2025-11-29 08:03:42',NULL),(206,'{\"config\": \"19a63e85-6980-4440-b52f-0726ad7cab45\", \"servers\": {\"0\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}}',0,'2025-11-29 08:03:42',NULL),(207,'{\"config\": \"19a63e85-6980-4440-b52f-0726ad7cab45\", \"servers\": {\"0\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}}',0,'2025-11-29 08:03:42',NULL),(208,'{\"config\": \"19a63e85-6980-4440-b52f-0726ad7cab45\", \"servers\": {\"0\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}}',0,'2025-11-29 08:03:42',NULL),(209,'{\"config\": \"19a63e85-6980-4440-b52f-0726ad7cab45\", \"servers\": {\"0\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}}',0,'2025-11-29 08:03:42',NULL),(210,'{\"config\": \"19a63e85-6980-4440-b52f-0726ad7cab45\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}',0,'2025-11-29 08:03:43',NULL),(211,'{\"config\": \"19a63e85-6980-4440-b52f-0726ad7cab45\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}',0,'2025-11-29 08:03:43',NULL),(212,'{\"config\": \"19a63e85-6980-4440-b52f-0726ad7cab45\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}',0,'2025-11-29 08:03:43',NULL),(213,'{\"config\": \"19a63e85-6980-4440-b52f-0726ad7cab45\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}',0,'2025-11-29 08:03:43',NULL),(214,'{\"config\": \"19a63e85-6980-4440-b52f-0726ad7cab45\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}',0,'2025-11-29 08:03:43',NULL),(215,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2025-11-29 08:03:58',NULL),(216,'{\"config\": \"37f20d01-5fce-48b8-9805-538317e2cb07\", \"servers\": {\"0\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}}',0,'2025-11-29 08:04:00',NULL),(217,'{\"config\": \"37f20d01-5fce-48b8-9805-538317e2cb07\", \"servers\": {\"0\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}}',0,'2025-11-29 08:04:00',NULL),(218,'{\"config\": \"37f20d01-5fce-48b8-9805-538317e2cb07\", \"servers\": {\"0\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}}',0,'2025-11-29 08:04:00',NULL),(219,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2025-11-29 08:04:00',NULL),(220,'{\"context\": {\"region_name\": \"regionOne\"}, \"template\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}',0,'2025-11-29 08:04:01',NULL),(221,'{\"config\": \"37f20d01-5fce-48b8-9805-538317e2cb07\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}',0,'2025-11-29 08:04:02',NULL),(222,'{\"config\": \"646db66a-5ceb-4418-8336-f754e5e5cbeb\", \"servers\": {\"0\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}}',0,'2025-11-29 08:04:02',NULL),(223,'{\"config\": \"37f20d01-5fce-48b8-9805-538317e2cb07\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}',0,'2025-11-29 08:04:02',NULL),(224,'{\"config\": \"646db66a-5ceb-4418-8336-f754e5e5cbeb\", \"servers\": {\"0\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}}',0,'2025-11-29 08:04:03',NULL),(225,'{\"config\": \"646db66a-5ceb-4418-8336-f754e5e5cbeb\", \"servers\": {\"0\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}}',0,'2025-11-29 08:04:03',NULL),(226,'{\"config\": \"37f20d01-5fce-48b8-9805-538317e2cb07\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}',0,'2025-11-29 08:04:03',NULL),(227,'{\"config\": \"646db66a-5ceb-4418-8336-f754e5e5cbeb\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}',0,'2025-11-29 08:04:03',NULL),(228,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2025-11-29 08:04:03',NULL),(229,'{\"config\": \"646db66a-5ceb-4418-8336-f754e5e5cbeb\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}',0,'2025-11-29 08:04:03',NULL),(230,'{\"config\": \"646db66a-5ceb-4418-8336-f754e5e5cbeb\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}',0,'2025-11-29 08:04:03',NULL),(231,'{\"config\": \"e2fdc8b2-5424-4e7c-85a2-989e134c1407\", \"servers\": {\"0\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}}',0,'2025-11-29 08:04:03',NULL),(232,'{\"config\": \"e2fdc8b2-5424-4e7c-85a2-989e134c1407\", \"servers\": {\"0\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}}',0,'2025-11-29 08:04:04',NULL),(233,'{\"config\": \"e2fdc8b2-5424-4e7c-85a2-989e134c1407\", \"servers\": {\"0\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}}',0,'2025-11-29 08:04:04',NULL),(234,'{\"config\": \"e2fdc8b2-5424-4e7c-85a2-989e134c1407\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}',0,'2025-11-29 08:04:04',NULL),(235,'{\"config\": \"e2fdc8b2-5424-4e7c-85a2-989e134c1407\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}',0,'2025-11-29 08:04:04',NULL),(236,'{\"config\": \"e2fdc8b2-5424-4e7c-85a2-989e134c1407\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"e3578395-b4af-44f6-9a44-4bba1e88898b\"}',0,'2025-11-29 08:04:04',NULL),(237,'{\"context\": {\"region_name\": \"regionOne\"}, \"template\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}',0,'2025-11-29 08:04:27',NULL),(238,'{\"context\": {\"region_name\": \"regionOne\"}, \"template\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random2:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random2, value]}\\n\"}',0,'2025-11-29 08:04:38',NULL),(239,'{\"image\": \"7ec37605-769b-4c6b-8937-6193c69752c0\", \"flavor\": \"f14a797a-1009-4bba-b4de-26eb6d95e944\", \"user_data_format\": \"SOFTWARE_CONFIG\", \"networks\": [{\"network\": \"heat_tempestconf_network\"}]}',0,'2025-11-29 08:05:31',NULL),(240,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2025-11-29 08:05:53',NULL),(241,'{\"config\": \"a85f0d31-f4d3-4dfd-b758-e14f20ec1e10\", \"servers\": {\"0\": \"361c41e7-0e30-45d3-b923-ccbb12956704\"}}',0,'2025-11-29 08:05:54',NULL),(242,'{\"config\": \"a85f0d31-f4d3-4dfd-b758-e14f20ec1e10\", \"servers\": {\"0\": \"361c41e7-0e30-45d3-b923-ccbb12956704\"}}',0,'2025-11-29 08:05:54',NULL),(243,'{\"config\": \"a85f0d31-f4d3-4dfd-b758-e14f20ec1e10\", \"servers\": {\"0\": \"361c41e7-0e30-45d3-b923-ccbb12956704\"}}',0,'2025-11-29 08:05:54',NULL),(244,'{\"config\": \"a85f0d31-f4d3-4dfd-b758-e14f20ec1e10\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"361c41e7-0e30-45d3-b923-ccbb12956704\"}',0,'2025-11-29 08:05:55',NULL),(245,'{\"config\": \"a85f0d31-f4d3-4dfd-b758-e14f20ec1e10\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"361c41e7-0e30-45d3-b923-ccbb12956704\"}',0,'2025-11-29 08:05:55',NULL),(246,'{\"config\": \"a85f0d31-f4d3-4dfd-b758-e14f20ec1e10\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"361c41e7-0e30-45d3-b923-ccbb12956704\"}',0,'2025-11-29 08:05:55',NULL),(247,'{\"wait_secs\": 1, \"value\": \"test\"}',0,'2025-11-29 08:07:23',NULL),(248,'{\"wait_secs\": 1, \"value\": \"test\"}',0,'2025-11-29 08:07:43',NULL),(249,'{\"wait_secs\": 1, \"value\": \"next\"}',0,'2025-11-29 08:07:52',NULL),(250,'{\"wait_secs\": 1, \"value\": \"none\"}',0,'2025-11-29 08:07:58',NULL);
/*!40000 ALTER TABLE `resource_properties_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(36) NOT NULL,
  `engine_id` varchar(36) NOT NULL,
  `host` varchar(255) NOT NULL,
  `hostname` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `topic` varchar(255) NOT NULL,
  `report_interval` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `engine_id`, `host`, `hostname`, `binary`, `topic`, `report_interval`, `created_at`, `updated_at`, `deleted_at`) VALUES ('2532eab8-6578-4472-bf17-8c3265ed8727','4725795e-0b2b-434c-80c9-7f2602001f80','heat-engine-999b4d64b-9brmm','heat-engine-999b4d64b-9brmm','heat-engine','engine',60,'2025-11-29 07:25:30','2025-11-29 07:25:57','2025-11-29 07:25:57'),('5cea7998-39bb-4624-ad34-43d804ca312e','d6fb8be6-3281-4564-8950-51d489b0c9c1','heat-engine-fd957fd8c-nfdrx','heat-engine-fd957fd8c-nfdrx','heat-engine','engine',60,'2025-11-29 07:25:39','2025-11-29 08:15:40',NULL),('6c565a3a-9187-4dc1-9f11-0dee303eac88','5b47b69f-e92d-4fc8-86e5-73fa6f761a2b','heat-engine-999b4d64b-9brmm','heat-engine-999b4d64b-9brmm','heat-engine','engine',60,'2025-11-29 07:25:29','2025-11-29 07:26:04','2025-11-29 07:26:04'),('9b362b33-e208-448b-a4a9-a4dad7adad9f','a538d801-7b5d-4e52-8310-ece4222007e9','heat-engine-fd957fd8c-nfdrx','heat-engine-fd957fd8c-nfdrx','heat-engine','engine',60,'2025-11-29 07:25:39','2025-11-29 08:15:40',NULL),('9cc73307-a182-4791-a3d6-2f82de0450d5','9d9d105b-72d4-4ef8-a1af-4ce6ab7604cc','heat-engine-fd957fd8c-nfdrx','heat-engine-fd957fd8c-nfdrx','heat-engine','engine',60,'2025-11-29 07:25:39','2025-11-29 08:15:40',NULL),('ac256cad-7d33-428a-aad6-76705f5caab0','04aa1d0b-c795-47ca-8361-8709bf1fbd6c','heat-engine-fd957fd8c-nfdrx','heat-engine-fd957fd8c-nfdrx','heat-engine','engine',60,'2025-11-29 07:25:39','2025-11-29 08:15:40',NULL),('dd62acaf-c1bf-4119-80af-e32d493ac422','faec3f8b-befb-4eeb-89e8-e366d51d9413','heat-engine-999b4d64b-9brmm','heat-engine-999b4d64b-9brmm','heat-engine','engine',60,'2025-11-29 07:25:30','2025-11-29 07:26:04','2025-11-29 07:26:04'),('dfb64dff-63f3-4c27-9788-633ef07ceba3','1e644d74-b9b5-4046-bf3b-8c31f387e0dc','heat-engine-999b4d64b-9brmm','heat-engine-999b4d64b-9brmm','heat-engine','engine',60,'2025-11-29 07:25:30','2025-11-29 07:25:58','2025-11-29 07:25:58');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot`
--

DROP TABLE IF EXISTS `snapshot`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot` (
  `id` varchar(36) NOT NULL,
  `stack_id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` varchar(255) DEFAULT NULL,
  `data` longtext DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `stack_id` (`stack_id`),
  KEY `ix_snapshot_tenant` (`tenant`),
  CONSTRAINT `snapshot_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot`
--

LOCK TABLES `snapshot` WRITE;
/*!40000 ALTER TABLE `snapshot` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `software_config`
--

DROP TABLE IF EXISTS `software_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `software_config` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `group` varchar(255) DEFAULT NULL,
  `config` longtext DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_software_config_tenant` (`tenant`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `software_config`
--

LOCK TABLES `software_config` WRITE;
/*!40000 ALTER TABLE `software_config` DISABLE KEYS */;
INSERT INTO `software_config` (`id`, `created_at`, `updated_at`, `name`, `group`, `config`, `tenant`) VALUES ('6d788d5f-ec51-4fae-b503-8729f4d2030c','2025-11-29 07:56:43',NULL,'api-1226968400-config','script','{\"inputs\": [], \"outputs\": [], \"options\": {}, \"config\": \"#!/bin/sh -x\\\\necho hello\"}','277df2fcdf24400b85eca72ae3be1c9c'),('d3befd03-49ef-41bf-a44a-10e0a7788038','2025-11-29 07:56:47',NULL,'api-1592030466-config','script','{\"inputs\": [], \"outputs\": [], \"options\": {}, \"config\": \"#!/bin/sh -x\\\\necho hello\"}','277df2fcdf24400b85eca72ae3be1c9c'),('fd044635-93c5-4546-be6c-8e2f44929154','2025-11-29 07:56:44',NULL,'api-28086934-config','script','{\"inputs\": [], \"outputs\": [], \"options\": {}, \"config\": \"#!/bin/sh -x\\\\necho hello\"}','277df2fcdf24400b85eca72ae3be1c9c');
/*!40000 ALTER TABLE `software_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `software_deployment`
--

DROP TABLE IF EXISTS `software_deployment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `software_deployment` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `server_id` varchar(36) NOT NULL,
  `config_id` varchar(36) NOT NULL,
  `input_values` longtext DEFAULT NULL,
  `output_values` longtext DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  `stack_user_project_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `config_id` (`config_id`),
  KEY `ix_software_deployment_server_id` (`server_id`),
  KEY `ix_software_deployment_tenant` (`tenant`),
  KEY `ix_software_deployment_created_at` (`created_at`),
  CONSTRAINT `software_deployment_ibfk_1` FOREIGN KEY (`config_id`) REFERENCES `software_config` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `software_deployment`
--

LOCK TABLES `software_deployment` WRITE;
/*!40000 ALTER TABLE `software_deployment` DISABLE KEYS */;
INSERT INTO `software_deployment` (`id`, `created_at`, `updated_at`, `server_id`, `config_id`, `input_values`, `output_values`, `action`, `status`, `status_reason`, `tenant`, `stack_user_project_id`) VALUES ('21942132-96f7-4a7b-b20b-8aab26c16d97','2025-11-29 07:56:43','2025-11-29 07:56:44','dummy_server','6d788d5f-ec51-4fae-b503-8729f4d2030c','{}','null','ACTION1','COMPLETE','completed','277df2fcdf24400b85eca72ae3be1c9c',NULL),('52e6d1f5-875e-48a9-965c-dd2aabb19979','2025-11-29 07:56:45','2025-11-29 07:56:45','dummy_server','fd044635-93c5-4546-be6c-8e2f44929154','{}','null','ACTION1','COMPLETE','completed','277df2fcdf24400b85eca72ae3be1c9c',NULL);
/*!40000 ALTER TABLE `software_deployment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack`
--

DROP TABLE IF EXISTS `stack`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `raw_template_id` int(11) NOT NULL,
  `prev_raw_template_id` int(11) DEFAULT NULL,
  `user_creds_id` int(11) DEFAULT NULL,
  `username` varchar(256) DEFAULT NULL,
  `owner_id` varchar(36) DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `timeout` int(11) DEFAULT NULL,
  `tenant` varchar(256) DEFAULT NULL,
  `disable_rollback` tinyint(1) NOT NULL,
  `stack_user_project_id` varchar(64) DEFAULT NULL,
  `backup` tinyint(1) DEFAULT NULL,
  `nested_depth` int(11) DEFAULT NULL,
  `convergence` tinyint(1) DEFAULT NULL,
  `current_traversal` varchar(36) DEFAULT NULL,
  `current_deps` longtext DEFAULT NULL,
  `parent_resource_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `raw_template_id` (`raw_template_id`),
  KEY `prev_raw_template_id` (`prev_raw_template_id`),
  KEY `user_creds_id` (`user_creds_id`),
  KEY `ix_stack_owner_id` (`owner_id`),
  KEY `ix_stack_name` (`name`),
  KEY `ix_stack_tenant` (`tenant`(255)),
  CONSTRAINT `stack_ibfk_1` FOREIGN KEY (`raw_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `stack_ibfk_2` FOREIGN KEY (`prev_raw_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `stack_ibfk_3` FOREIGN KEY (`user_creds_id`) REFERENCES `user_creds` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack`
--

LOCK TABLES `stack` WRITE;
/*!40000 ALTER TABLE `stack` DISABLE KEYS */;
INSERT INTO `stack` (`id`, `created_at`, `updated_at`, `deleted_at`, `name`, `raw_template_id`, `prev_raw_template_id`, `user_creds_id`, `username`, `owner_id`, `action`, `status`, `status_reason`, `timeout`, `tenant`, `disable_rollback`, `stack_user_project_id`, `backup`, `nested_depth`, `convergence`, `current_traversal`, `current_deps`, `parent_resource_name`) VALUES ('00018af1-0bcd-47f5-b95e-1d4b9e14aa98','2025-11-29 07:56:49','2025-11-29 07:56:51',NULL,'api-28086934-stack',20,NULL,12,'demo_tempestconf',NULL,'UPDATE','COMPLETE','Stack UPDATE completed successfully',NULL,'277df2fcdf24400b85eca72ae3be1c9c',1,'7b94c82152c643feb7a538d52cce0cc8',0,0,1,'4177a611-f1b1-4cf7-b04e-af12bd14205f','{\"edges\": [[[9, false], [9, true]]]}',NULL),('005aa58a-83a8-475d-b468-a4beaa77ca80','2025-11-29 07:59:55','2025-11-29 08:00:20','2025-11-29 08:00:27','UpdateTrunkTest-257617379',90,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'bd3871ba16a946c6ab0e4ffbe72160fc',0,0,1,'e635aaaf-7f34-4322-8d48-130c5c1ec682','{\"edges\": [[[95, false], [93, false]], [[94, false], [93, false]], [[100, false], [99, false]], [[100, false], [94, false]], [[99, false], [94, false]], [[102, false], [95, false]], [[102, false], [101, false]], [[101, false], [95, false]], [[98, false], [96, false]], [[98, false], [97, false]], [[97, false], [96, false]]]}',NULL),('054684b9-132a-4198-b51f-08a6a1383c9d','2025-11-29 07:56:38','2025-11-29 07:56:40','2025-11-29 07:56:42','api-28086934-envstack',5,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'277df2fcdf24400b85eca72ae3be1c9c',1,'25e7c895f94a4d97b723cc5f19a5209a',0,0,1,'0c269436-104a-4856-88fb-ce07c869f3dd','{\"edges\": [[[4, false], null]]}',NULL),('05ed0658-e749-4335-9f09-b3af57105e89','2025-11-29 08:01:37','2025-11-29 08:01:47','2025-11-29 08:01:48','StackOutputsTest-1240581169-parent-4mtpuurlr5sy',128,NULL,NULL,'demo_tempestconf','975a3b9a-54d6-4846-bb6a-e9b8cdf2777b','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'bf962faf8dd041108d3ab9ca65e207d7',0,1,1,'d4fd78a5-f1db-4474-8704-e2e2130e1d0b','{\"edges\": [[[142, false], null], [[141, false], null]]}','parent'),('093e7bb9-cb29-4329-af06-564e90895aaf','2025-11-29 07:58:01','2025-11-29 07:58:55','2025-11-29 07:59:04','same_fixed_ip',60,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'65eaf2a07d0545d2a3d78578c98f310c',0,0,1,'c1acef43-294f-45ae-8043-5af59d2d066f','{\"edges\": [[[57, false], [56, false]], [[57, false], [55, false]], [[56, false], [55, false]]]}',NULL),('0b2e59b1-173b-4a56-a882-9e4c4db3910b','2025-11-29 08:00:12','2025-11-29 08:00:13','2025-11-29 08:00:14','TemplateAPITest-787184066',87,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'12f9cde71ec440faa2314abc0a23a7bf',0,0,1,'4d982dce-bd2d-40b9-9006-809495a8f81a','{\"edges\": [[[109, false], null]]}',NULL),('0cb91f56-9f71-4cd3-8bfb-beee945b274d','2025-11-29 08:03:37','2025-11-29 08:05:08','2025-11-29 08:05:16','ParallelDeploymentsTest-483475472',216,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'395a42f54fe54d2ab61b3256d9a65313',0,0,1,'9f42002a-491b-4837-ad80-03eaabd8a545','{\"edges\": [[[177, false], [172, false]], [[177, false], [175, false]], [[177, false], [173, false]], [[177, false], [176, false]], [[177, false], [174, false]]]}',NULL),('10294177-1248-471e-98a7-f30bdd51ed59','2025-11-29 08:03:41','2025-11-29 08:05:12','2025-11-29 08:05:13','ParallelDeploymentsTest-483475472-dep_1-w6gw36p5e5tm',220,NULL,NULL,'demo_tempestconf','0cb91f56-9f71-4cd3-8bfb-beee945b274d','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'395a42f54fe54d2ab61b3256d9a65313',0,1,1,'67ec3053-539a-4356-badc-32765279024d','{\"edges\": [[[181, false], null]]}','dep_1'),('12539f82-9960-4a0a-8635-fe8955575a40','2025-11-29 08:02:31','2025-11-29 08:02:38','2025-11-29 08:02:42','HooksTest-1771037649',150,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'51a4a056ba384be58f40b9b7bd37a191',0,0,1,'5880ce15-c5d8-45da-90fc-87e369ce453a','{\"edges\": [[[162, false], [163, false]], [[160, false], null]]}',NULL),('15fa1552-2ea1-4818-adc9-e24ace9a4f26','2025-11-29 08:03:41','2025-11-29 08:05:09','2025-11-29 08:05:10','ParallelDeploymentsTest-483475472-dep_2-34jiaunhfhqp',218,NULL,NULL,'demo_tempestconf','0cb91f56-9f71-4cd3-8bfb-beee945b274d','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'395a42f54fe54d2ab61b3256d9a65313',0,1,1,'40f3f275-2e33-4523-a506-809375e68eb8','{\"edges\": [[[182, false], null]]}','dep_2'),('1720f7a8-089a-4ce2-923f-a30c23acee53','2025-11-29 07:58:54','2025-11-29 07:59:10','2025-11-29 07:59:12','UpdateSubnetTest-35781114',66,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'ddf18766058c447fadf098ebe4c07bef',0,0,1,'0370f23f-712c-41ea-8f30-de48e36d461d','{\"edges\": [[[71, false], [70, false]]]}',NULL),('20e3a093-495d-4752-a6c0-625fe2c5e938','2025-11-29 08:02:19','2025-11-29 08:02:20','2025-11-29 08:02:21','StackUnicodeTemplateTest-889378100',145,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'75ce9dd3b7ae4e809ccbddfae7e3d2e2',0,0,1,'b4c89ed5-2136-4257-9e12-d3b2cc8365c1','{\"edges\": [[[156, false], null]]}',NULL),('23682f71-2e5b-4cbb-b25a-f3ebaddece4d','2025-11-29 08:04:28','2025-11-29 08:04:41','2025-11-29 08:04:41','RemoteStackTest-1238946260-my_stack-5bbuyx2xi3rh',205,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'277df2fcdf24400b85eca72ae3be1c9c',1,'a896f8f2b6174b37ad2d3d23e0b2b045',0,0,1,'939c638f-c438-4b80-8c42-1e24e2ce0ee5','{\"edges\": [[[219, false], null]]}',NULL),('23ca706e-6410-4129-a111-456e959a3b34','2025-11-29 07:56:46','2025-11-29 07:56:46','2025-11-29 07:56:47','api-1226968400-empty',12,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'277df2fcdf24400b85eca72ae3be1c9c',1,'960620abbf5544be93e39a44cf1aca42',0,0,1,'0dbdda91-5a50-41cf-9516-13ee4c7e8801','{\"edges\": []}',NULL),('24bfb6a0-f795-416b-b467-d248aaf825e1','2025-11-29 07:57:55','2025-11-29 07:58:40','2025-11-29 07:58:51','server_with_sub_ip',55,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'e2961fa6cecd48e3aac8ab86662ff0bc',0,0,1,'0126f359-b652-425d-a748-97108d2fd16c','{\"edges\": [[[53, false], [51, false]], [[52, false], [51, false]], [[54, false], [53, false]]]}',NULL),('28538b2e-fc2d-4892-9fdb-28f829b930fe','2025-11-29 08:00:43','2025-11-29 08:00:50','2025-11-29 08:00:52','ExternalReferencesTest-3189793',106,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'1a704f689c1646a38020226f258a3abb',0,0,1,'a2d511d1-764c-415a-80c5-990fde5f78fe','{\"edges\": [[[125, false], null]]}',NULL),('2a51c847-a492-4d13-8a0c-c260b035c512','2025-11-29 08:00:22','2025-11-29 08:00:31','2025-11-29 08:00:33','RemoteDeeplyNestedStackTest-590817526-network_stack-h6cjldvbglxj-network_stack_as_custom_type-lo5ngz3peoma',99,NULL,NULL,'demo_tempestconf','a8489d3c-da0c-4695-94f0-89c1a5f1590d','DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'277df2fcdf24400b85eca72ae3be1c9c',1,'b1e7f0065a934e908c0f3c6a785d6133',0,1,1,'ae2d7cb1-89ef-478e-8247-9b2a82fe32e4','{\"edges\": [[[112, false], null]]}','network_stack_as_custom_type'),('3376802c-710f-4d5d-9456-14991af9dd93','2025-11-29 08:04:04','2025-11-29 08:04:25','2025-11-29 08:04:26','ParallelDeploymentsTest-1562438676-dep_1-yup4w47j35lv',193,NULL,NULL,'demo_tempestconf','ab350b0e-eb44-40a7-aa50-d6ed0d0308cd','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'c353808380d3412db6e87d5a5fd7926c',0,1,1,'bd0a76c0-8bb0-4488-b4f6-b5e98003897f','{\"edges\": [[[213, false], null]]}','dep_1'),('3379ec00-c2be-4662-a434-18d6494c7865','2025-11-29 07:56:38','2025-11-29 07:56:43','2025-11-29 07:56:44','api-1857042720-rsrcstack',8,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'277df2fcdf24400b85eca72ae3be1c9c',1,'541128ec90ad4ca4a90f32c3a170c9c0',0,0,1,'f67bd12b-d301-4d46-9f2b-474d7cb89263','{\"edges\": [[[3, false], null]]}',NULL),('34a136a2-4dec-4c42-a2f4-7dab8a647c6a','2025-11-29 08:01:09','2025-11-29 08:01:20','2025-11-29 08:01:22','HooksTest-896880678',115,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'ac8bb195086248e3a7f585b4d64f14e1',0,0,1,'6c38ac47-fee8-40f8-8a10-a3875381d5d3','{\"edges\": [[[133, false], null]]}',NULL),('34b51a0f-aa59-4ac7-997e-84c19c3534c9','2025-11-29 08:00:30','2025-11-29 08:00:55','2025-11-29 08:01:02','UpdateTrunkTest-1524320770',108,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'eb4a727af50e4cb48d0319d048820f2c',0,0,1,'0d858d60-97ee-4d22-88fc-f37ec9037400','{\"edges\": [[[116, false], [115, false]], [[124, false], [123, false]], [[124, false], [116, false]], [[123, false], [116, false]], [[119, false], [118, false]], [[119, false], [117, false]], [[118, false], [117, false]], [[122, false], [120, false]], [[122, false], [121, false]], [[121, false], [120, false]]]}',NULL),('39e3c4d0-31c3-472a-9429-e6d50903e0de','2025-11-29 07:56:38',NULL,NULL,'api-1226968400-rsrcstack',4,NULL,1,'demo_tempestconf',NULL,'CREATE','COMPLETE','Stack CREATE completed successfully',NULL,'277df2fcdf24400b85eca72ae3be1c9c',1,'5d704a8d05794b0db893da833f5a252c',0,0,1,'e8e30e6f-aee6-46a9-bff4-46a80b0b1ac6','{\"edges\": [[[1, true], null]]}',NULL),('3eae79ce-8217-409c-93a9-2829072bca2b','2025-11-29 07:57:38','2025-11-29 07:58:01','2025-11-29 07:58:07','UpdateTrunkTest-1059206779',50,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'b6ab5ac0f8584db3b28588c6699dbb66',0,0,1,'6b6902bc-4989-49ee-94b9-887fc79216ce','{\"edges\": [[[44, false], [39, false]], [[40, false], [39, false]], [[48, false], [47, false]], [[48, false], [40, false]], [[47, false], [40, false]], [[43, false], [42, false]], [[43, false], [41, false]], [[42, false], [41, false]], [[46, false], [44, false]], [[46, false], [45, false]], [[45, false], [44, false]]]}',NULL),('43c98f02-b41d-4bfa-a1ce-6f71b8dc3fb7','2025-11-29 08:03:42','2025-11-29 08:04:57','2025-11-29 08:04:59','ParallelDeploymentsTest-1812906045-dep_2-qbirlrznoxom',215,NULL,NULL,'demo_tempestconf','5db7721f-ff92-4146-b2f3-2cd63ad458b0','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'e2fe8e5837f042c28444dcc0d31179ab',0,1,1,'bdced33b-9ede-4eee-93b8-5b72ecd32217','{\"edges\": [[[191, false], null]]}','dep_2'),('458e4ad4-3e9f-49c1-ac15-c57e9c25cd71','2025-11-29 07:59:42','2025-11-29 07:59:59','2025-11-29 08:00:03','UpdateSubnetTest-250818380',80,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'c3d43bf2b52f4ee7bdb0e91f61820cc3',0,0,1,'bbca5533-e5fd-4755-ab8e-c73778c1cc89','{\"edges\": [[[92, false], [91, false]]]}',NULL),('45e4135c-30a1-46ab-b404-3086a3ed9150','2025-11-29 08:04:01','2025-11-29 08:04:44','2025-11-29 08:04:45','ParallelDeploymentsTest-245857673-dep_0-cj6coiutvkmw',208,NULL,NULL,'demo_tempestconf','aea137db-5659-4d9c-80a7-f2321a093dfa','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'f63faf9f7c88450a938a9d17285e3bc3',0,1,1,'d145b2c2-04c4-4424-b4c5-ee47296ced4c','{\"edges\": [[[204, false], null]]}','dep_0'),('46ac4298-6d0b-43ae-aff5-d73b8e6ab472','2025-11-29 08:04:04','2025-11-29 08:04:26','2025-11-29 08:04:27','ParallelDeploymentsTest-1562438676-dep_2-czmur4d7m73n',194,NULL,NULL,'demo_tempestconf','ab350b0e-eb44-40a7-aa50-d6ed0d0308cd','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'c353808380d3412db6e87d5a5fd7926c',0,1,1,'cad9c4cf-4e21-4086-b1b3-02f1b84b904c','{\"edges\": [[[214, false], null]]}','dep_2'),('47110e56-7d1b-47ca-b283-659fa4ecfb42','2025-11-29 08:01:08','2025-11-29 08:01:40','2025-11-29 08:01:44','swap_network_port',122,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'9323c04754cc49538f5fea474c64826a',0,0,1,'656ee3a5-2fb7-4035-b194-0b9846cb83ce','{\"edges\": [[[131, false], [130, false]], [[132, false], [131, false]]]}',NULL),('4a915ecb-a078-4c37-ae7d-1f59204f6d4e','2025-11-29 07:56:52','2025-11-29 07:56:58',NULL,'api-1592030466-stack',27,NULL,14,'demo_tempestconf',NULL,'UPDATE','COMPLETE','Stack UPDATE completed successfully',NULL,'277df2fcdf24400b85eca72ae3be1c9c',1,'3fca2f15e48c4f51b713aa34c86f3ed2',0,0,1,'f651c1e6-7b3b-4730-895d-7cf7674936d4','{\"edges\": [[[10, false], [10, true]]]}',NULL),('4ac64ef8-0fe2-479c-8365-5b13dd0dd5aa','2025-11-29 07:56:47',NULL,NULL,'api-1226968400-stack',13,NULL,10,'demo_tempestconf',NULL,'CREATE','COMPLETE','Stack CREATE completed successfully',NULL,'277df2fcdf24400b85eca72ae3be1c9c',1,'8d185dc67a2b4d0a9ff3c81f4d9930c5',0,0,1,'9ec01559-7de4-479d-966b-dc71185493fd','{\"edges\": [[[7, true], null]]}',NULL),('506e5652-64a1-44f4-8d81-3b9a8b7a1e03','2025-11-29 08:03:08','2025-11-29 08:05:18','2025-11-29 08:05:23','ParallelDeploymentsTest-1927891276',222,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'e6c3f469894749bebb6cad8f40ef1902',0,0,1,'dad42ba0-0c49-4135-81fc-8051af7908fc','{\"edges\": [[[168, false], null]]}',NULL),('5b84b18f-a52e-4a03-b039-1827cf7f0eca','2025-11-29 08:03:40','2025-11-29 08:05:10','2025-11-29 08:05:11','ParallelDeploymentsTest-483475472-dep_4-usf4vxnbwgkw',219,NULL,NULL,'demo_tempestconf','0cb91f56-9f71-4cd3-8bfb-beee945b274d','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'395a42f54fe54d2ab61b3256d9a65313',0,1,1,'b31ab928-76e5-46a7-9ddc-180ad9e99d02','{\"edges\": [[[179, false], null]]}','dep_4'),('5db7721f-ff92-4146-b2f3-2cd63ad458b0','2025-11-29 08:03:40','2025-11-29 08:04:53','2025-11-29 08:05:03','ParallelDeploymentsTest-1812906045',210,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'e2fe8e5837f042c28444dcc0d31179ab',0,0,1,'90f99f0c-a047-473d-941c-53b70a40a457','{\"edges\": [[[188, false], [186, false]], [[188, false], [184, false]], [[188, false], [183, false]], [[188, false], [187, false]], [[188, false], [185, false]]]}',NULL),('5f1ce0f6-ade7-4dc1-afb1-a43d8b9ff6f9','2025-11-29 07:59:16','2025-11-29 07:59:37','2025-11-29 07:59:39','UpdateSubnetTest-1028229510',72,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'f62e9d5aac114065ac87a65d59bc2eba',0,0,1,'03267680-dff5-4870-a010-ef25bb9dda63','{\"edges\": [[[90, false], [89, false]]]}',NULL),('60f70945-fc34-4ddf-ba3a-6f4df6651301','2025-11-29 08:04:00','2025-11-29 08:04:20','2025-11-29 08:04:23','RemoteStackTest-1393600846',190,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'3ab438fceb924f53a23750709733174c',0,0,1,'6735da8b-720b-4bc6-9f69-f22700278f3f','{\"edges\": [[[202, false], null]]}',NULL),('6195a7ad-12b9-4ace-b439-53011ad6d6fe','2025-11-29 08:03:42','2025-11-29 08:04:54','2025-11-29 08:04:55','ParallelDeploymentsTest-1812906045-dep_4-aor4tw6nckth',211,NULL,NULL,'demo_tempestconf','5db7721f-ff92-4146-b2f3-2cd63ad458b0','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'e2fe8e5837f042c28444dcc0d31179ab',0,1,1,'5477432e-801d-452c-a625-e2d7265ce440','{\"edges\": [[[192, false], null]]}','dep_4'),('62a8831d-5a95-48ae-ac01-bcd22bc3e72d','2025-11-29 07:58:12','2025-11-29 07:58:44','2025-11-29 07:58:49','UpdateSubnetTest-363745674',56,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'94e29764bd274791972c2cbb988a351e',0,0,1,'716fd494-94bf-4c2e-8f09-3c8ccef26a35','{\"edges\": [[[60, false], [58, false]]]}',NULL),('637188bd-fbaf-43ce-85b0-5455580963f9','2025-11-29 07:57:17','2025-11-29 07:57:43','2025-11-29 07:57:50','server_with_port',43,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'9e3bff820af543dfaae77727d7e9d8a6',0,0,1,'0baac31b-1ed0-4661-9ad1-684024aa5024','{\"edges\": [[[32, false], [31, false]], [[32, false], [30, false]], [[31, false], [30, false]], [[33, false], [31, false]], [[33, false], [32, false]]]}',NULL),('64a216bd-7cde-4251-8604-44a873e13dff','2025-11-29 07:56:49','2025-11-29 07:56:58','2025-11-29 07:56:59','api-1857042720-stack',28,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'277df2fcdf24400b85eca72ae3be1c9c',1,'d1c32807f2d64f92a0eee1322a5de313',0,0,1,'f92b63ec-44a6-4f81-bd4e-c6537cdbd322','{\"edges\": [[[8, false], null]]}',NULL),('698a4d18-52b3-4488-a9df-df538a65bd4e','2025-11-29 08:03:30','2025-11-29 08:03:43','2025-11-29 08:03:49','RemoteStackTest-1685272545',174,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'2051a886614c4f5597fefcc9a0a542d0',0,0,1,'e7fa528e-a66b-4ac1-b471-1e40721f87e5','{\"edges\": [[[170, false], null]]}',NULL),('6e051623-2655-4cba-8bec-f1e408ffbc12','2025-11-29 08:03:01','2025-11-29 08:03:02','2025-11-29 08:03:03','ResourcesList-865981516',156,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'5ba37e82e34f4c6990a2d0fe9483945d',0,0,1,'40f30ce6-3c3d-4b06-aee9-445fe74bd941','{\"edges\": [[[167, false], [166, false]]]}',NULL),('6feca314-ec55-4854-a063-be3c6552dc5a','2025-11-29 08:01:08','2025-11-29 08:01:26','2025-11-29 08:01:29','EncryptedParametersTest-2023578631',118,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'beb5a4335c40479c8c7aaab6246dee25',0,0,1,'d17f376b-6e22-4708-bc9d-918d98657dc0','{\"edges\": [[[129, false], null]]}',NULL),('705ab806-d900-46cd-8993-3d860855c41c','2025-11-29 08:07:22','2025-11-29 08:07:30','2025-11-29 08:07:36','StackTagTest-815859264',234,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'633a5a9f83c6445eb057905821e54d4c',0,0,1,'c5951d70-b03f-4963-b427-ea13857e7278','{\"edges\": [[[228, false], null]]}',NULL),('719c244c-5fb1-4e6d-a655-d34c62c57c15','2025-11-29 08:05:54','2025-11-29 08:06:58','2025-11-29 08:07:00','ParallelDeploymentsTest-528172829-dep_0-p3g6jl3z7ywg',229,NULL,NULL,'demo_tempestconf','f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','DELETE','COMPLETE','Stack DELETE completed successfully',1,'277df2fcdf24400b85eca72ae3be1c9c',1,'8b7ed15532cc468b84161bd31c07e543',0,1,1,'73cabcbe-f0c3-427e-926d-acee5947ea8f','{\"edges\": [[[226, false], null]]}','dep_0'),('73a6c620-ee95-4d5e-a4c2-86ec10991d07','2025-11-29 08:03:58','2025-11-29 08:04:34','2025-11-29 08:04:38','ParallelDeploymentsTest-680695782',198,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'db4fe81c16bd48fe8a478fcb25766918',0,0,1,'894c445c-bd59-4c50-97d7-e95b2e398055','{\"edges\": [[[201, false], [199, false]], [[201, false], [200, false]], [[201, false], [198, false]]]}',NULL),('73cbbbd3-2559-48d0-adeb-273aa21173f6','2025-11-29 07:56:38',NULL,NULL,'api-1592030466-envstack',2,NULL,2,'demo_tempestconf',NULL,'CREATE','COMPLETE','Stack CREATE completed successfully',NULL,'277df2fcdf24400b85eca72ae3be1c9c',1,'947db8bd6f144bac91c48d9798521321',0,0,1,'8eaaff10-9f8c-4cd2-8da2-669777046833','{\"edges\": [[[2, true], null]]}',NULL),('7496186f-e0d9-4600-92d1-24f7ffdcb5a5','2025-11-29 07:58:12','2025-11-29 07:59:01','2025-11-29 07:59:08','UpdateTrunkTest-1311242840',62,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'491e1041838249f18cdd712bb4531c62',0,0,1,'ca4cebdf-a46b-4ac2-a6a2-b9647d82a88a','{\"edges\": [[[62, false], [59, false]], [[67, false], [66, false]], [[67, false], [61, false]], [[66, false], [61, false]], [[69, false], [62, false]], [[69, false], [68, false]], [[68, false], [62, false]], [[65, false], [63, false]], [[65, false], [64, false]], [[64, false], [63, false]]]}',NULL),('7573bc9b-a079-43d5-acfa-c9aaca6b2af4','2025-11-29 08:00:20','2025-11-29 08:00:30','2025-11-29 08:00:36','RemoteDeeplyNestedStackTest-590817526',97,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'117278cc64ef43f7baf02fc37e9f8a45',0,0,1,'fece68d9-3768-4482-b9bf-d7131701d9d5','{\"edges\": [[[110, false], null]]}',NULL),('759f3dcd-2b7e-4386-bc1c-f8b4ffb747b8','2025-11-29 07:57:04','2025-11-29 07:57:51','2025-11-29 07:57:58','add_network',46,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'3677cc7bb0da4cea9f3203df0d2131eb',0,0,1,'59c1becb-756d-41db-81ea-77b9d38055c0','{\"edges\": [[[29, false], [28, false]], [[29, false], [27, false]], [[28, false], [27, false]]]}',NULL),('7628f113-095b-4912-9765-4429d35b43cd','2025-11-29 07:57:00','2025-11-29 07:57:29','2025-11-29 07:57:34','UpdateTrunkTest-2094757575',38,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'b785e68e409c40b8b956ead8b56b9687',0,0,1,'7d77dc87-7361-4631-9982-21b31640227d','{\"edges\": [[[20, false], [17, false]], [[19, false], [17, false]], [[18, false], [17, false]], [[24, false], [23, false]], [[24, false], [18, false]], [[23, false], [18, false]], [[26, false], [25, false]], [[26, false], [19, false]], [[25, false], [19, false]], [[22, false], [20, false]], [[22, false], [21, false]], [[21, false], [20, false]]]}',NULL),('7c917f8b-e89f-4e42-825a-4993a18791e1','2025-11-29 08:00:30','2025-11-29 08:00:36','2025-11-29 08:00:37','ExternalReferencesTest-1505818889',101,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'a5eee3bca36e46ee86f37bf5757002dd',0,0,1,'d331542a-b2e8-4a24-a4d9-17d5ba7f791e','{\"edges\": [[[114, false], null]]}',NULL),('7f13ebe3-acc2-4edf-9399-e87b2b7f132b','2025-11-29 08:01:46','2025-11-29 08:02:13','2025-11-29 08:02:20','swap_network_subnet',142,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'f693800b95d840ee9a231ed0ddef7d62',0,0,1,'c6e24a25-02cf-4217-97c5-e898db331691','{\"edges\": [[[145, false], [144, false]], [[144, false], [143, false]]]}',NULL),('7f8db07d-54bf-4626-81e8-2cac67728e4b','2025-11-29 08:02:47','2025-11-29 08:02:54','2025-11-29 08:02:56','ResourcesList-970551472',153,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'89f8f14f6dd5488d919ec899a4f54d48',0,0,1,'34d57fd4-527c-4740-bf3e-e4741523eef6','{\"edges\": [[[165, false], [164, false]]]}',NULL),('86996ebc-96ab-4e82-9014-1fa7251ebbac','2025-11-29 08:01:53','2025-11-29 08:02:01','2025-11-29 08:02:03','StackOutputsTest-1052649082',134,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'0afdb1e469c94cd6bd71095724ff439d',0,0,1,'523ea6de-c953-4c8b-92f4-ee5dc8dd0710','{\"edges\": [[[148, false], null], [[149, false], null]]}',NULL),('8775fc1e-3172-496a-8b10-c310403b6afc','2025-11-29 08:04:27','2025-11-29 08:04:40','2025-11-29 08:04:41','RemoteStackTest-1238946260',204,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'a4981bc073f44a53b9395d2fa39113d8',0,0,1,'73577076-2f44-4cb9-8113-f463fd44ff42','{\"edges\": [[[217, false], null]]}',NULL),('92d9fced-5a7d-4f8a-820c-edcd55826d81','2025-11-29 08:01:10','2025-11-29 08:01:20','2025-11-29 08:01:21','HooksTest-896880678-nested-gcbypquwdphv',116,NULL,NULL,'demo_tempestconf','34a136a2-4dec-4c42-a2f4-7dab8a647c6a','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'ac8bb195086248e3a7f585b4d64f14e1',0,1,1,'9b054498-0765-4a16-bb0e-af44301fdfa3','{\"edges\": [[[136, false], [135, false]], [[135, false], [134, false]]]}','nested'),('94fd2bec-6a07-479e-a595-6fb1dc96594a','2025-11-29 07:56:47','2025-11-29 07:56:48','2025-11-29 07:56:49','api-28086934-empty',16,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'277df2fcdf24400b85eca72ae3be1c9c',1,'52e88103f0314019a47e61ac5e861aea',0,0,1,'b4fa95cd-5d76-4bbf-9dfd-28cddb25e42e','{\"edges\": []}',NULL),('96c617d2-8371-4ad3-af7b-878231f849aa','2025-11-29 08:05:29','2025-11-29 08:07:10','2025-11-29 08:07:18','ParallelDeploymentsTest-694325321',232,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'96e1a3fac40d473fbbb7fc7eb9086301',0,0,1,'2bae5416-bf15-4f42-a598-4c47cc379570','{\"edges\": [[[220, false], null]]}',NULL),('975a3b9a-54d6-4846-bb6a-e9b8cdf2777b','2025-11-29 08:01:36','2025-11-29 08:01:47','2025-11-29 08:01:50','StackOutputsTest-1240581169',127,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'bf962faf8dd041108d3ab9ca65e207d7',0,0,1,'b7c58ed3-8a72-4801-b8a6-391de8acc326','{\"edges\": [[[140, false], null]]}',NULL),('98f33f41-4eea-4635-b777-87c5b16462f3','2025-11-29 08:03:11','2025-11-29 08:03:23','2025-11-29 08:03:27','RemoteStackTest-1316777958',159,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'a740d74d4ce44946b984b377a32dc4a1',0,0,1,'15f50927-359d-4bf6-8cc2-74461947fac9','{\"edges\": [[[169, false], null]]}',NULL),('99378704-0dba-4b64-8474-42e06567dd4e','2025-11-29 08:01:49','2025-11-29 08:02:07','2025-11-29 08:02:10','HooksTest-126905259',137,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'f00affffa6664dd68c62ef22c17cd4eb',0,0,1,'1cff2044-8d39-4855-a483-fb7733b6d99b','{\"edges\": [[[146, false], null]]}',NULL),('9954bf70-5402-497d-b3cc-4a80f94af7da','2025-11-29 08:04:00','2025-11-29 08:04:43','2025-11-29 08:04:44','ParallelDeploymentsTest-245857673-dep_2-lsz6fxh4ue35',207,NULL,NULL,'demo_tempestconf','aea137db-5659-4d9c-80a7-f2321a093dfa','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'f63faf9f7c88450a938a9d17285e3bc3',0,1,1,'1ddb17ee-7480-462e-8273-30826ba123ec','{\"edges\": [[[203, false], null]]}','dep_2'),('9cee4f59-6335-40cc-8093-c0eba2ae107d','2025-11-29 07:59:56','2025-11-29 08:00:55','2025-11-29 08:01:05','multi_networks_swaps',109,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'1c125efd60cb4576a52bb8efdcc02ff5',0,0,1,'47b211be-b7cd-4860-8d67-ef15fa3d7539','{\"edges\": [[[105, false], [104, false]], [[105, false], [103, false]], [[104, false], [103, false]]]}',NULL),('9f57d290-4c23-407f-9a7c-c5b53e74baf3','2025-11-29 07:56:42',NULL,NULL,'api-1592030466-rsrcstack',7,NULL,6,'demo_tempestconf',NULL,'CREATE','COMPLETE','Stack CREATE completed successfully',NULL,'277df2fcdf24400b85eca72ae3be1c9c',1,'aceee0257e7c4d0db263ed39a4aaa42d',0,0,1,'98e83ddf-47da-4047-b49e-6fcf91660d08','{\"edges\": [[[6, true], null]]}',NULL),('a1242deb-ef90-41ed-8a55-7ca5d2e883f6','2025-11-29 08:03:40','2025-11-29 08:05:12','2025-11-29 08:05:14','ParallelDeploymentsTest-483475472-dep_0-7afxyxhwrcmy',221,NULL,NULL,'demo_tempestconf','0cb91f56-9f71-4cd3-8bfb-beee945b274d','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'395a42f54fe54d2ab61b3256d9a65313',0,1,1,'0912c538-3238-44f7-bb02-f0c3ac0bd1b3','{\"edges\": [[[180, false], null]]}','dep_0'),('a8489d3c-da0c-4695-94f0-89c1a5f1590d','2025-11-29 08:00:22','2025-11-29 08:00:30','2025-11-29 08:00:36','RemoteDeeplyNestedStackTest-590817526-network_stack-h6cjldvbglxj',98,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'277df2fcdf24400b85eca72ae3be1c9c',1,'b1e7f0065a934e908c0f3c6a785d6133',0,0,1,'5d4d7f24-5ea7-4340-b6ec-b15c7f6b023a','{\"edges\": [[[111, false], null]]}',NULL),('aad9a5e1-c157-4fa7-9577-fda46dada9c7','2025-11-29 08:00:56','2025-11-29 08:01:03','2025-11-29 08:01:05','HooksTest-942067710',110,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'871aed30b58d4500ac1475182bbbf480',0,0,1,'f6c7e352-9451-4db5-9d2d-0ed5e299760b','{\"edges\": [[[128, false], [127, false]], [[127, false], [126, false]]]}',NULL),('ab350b0e-eb44-40a7-aa50-d6ed0d0308cd','2025-11-29 08:04:01','2025-11-29 08:04:24','2025-11-29 08:04:29','ParallelDeploymentsTest-1562438676',192,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'c353808380d3412db6e87d5a5fd7926c',0,0,1,'adbf7a0c-2049-43b8-9e1c-00f5be8ffefe','{\"edges\": [[[209, false], [207, false]], [[209, false], [208, false]], [[209, false], [206, false]]]}',NULL),('aea137db-5659-4d9c-80a7-f2321a093dfa','2025-11-29 08:03:51','2025-11-29 08:04:43','2025-11-29 08:04:49','ParallelDeploymentsTest-245857673',206,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'f63faf9f7c88450a938a9d17285e3bc3',0,0,1,'f478a9e7-c0b5-4074-916f-b88dfdfec5f0','{\"edges\": [[[197, false], [196, false]], [[197, false], [194, false]], [[197, false], [195, false]]]}',NULL),('b23e6104-f9a1-4c0c-b568-750cf917ffea','2025-11-29 08:03:43','2025-11-29 08:04:55','2025-11-29 08:04:56','ParallelDeploymentsTest-1812906045-dep_1-soujsdl7qnpy',213,NULL,NULL,'demo_tempestconf','5db7721f-ff92-4146-b2f3-2cd63ad458b0','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'e2fe8e5837f042c28444dcc0d31179ab',0,1,1,'74852da8-d9e7-4378-8135-5cdc5f5bddeb','{\"edges\": [[[193, false], null]]}','dep_1'),('bc8bf960-2086-4056-acbb-e5ce1b3d7216','2025-11-29 07:57:48','2025-11-29 07:58:01','2025-11-29 07:58:06','UpdateSubnetTest-699709118',51,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'c617be683c934208a2d6a4be2560bd32',0,0,1,'c3a21e31-d20b-4aa5-93cd-6d0dae965e14','{\"edges\": [[[50, false], [49, false]]]}',NULL),('bdcc5205-74e8-46cd-9202-9d582efbba8a','2025-11-29 08:03:42','2025-11-29 08:04:54','2025-11-29 08:04:55','ParallelDeploymentsTest-1812906045-dep_3-lylj7p3chgsx',212,NULL,NULL,'demo_tempestconf','5db7721f-ff92-4146-b2f3-2cd63ad458b0','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'e2fe8e5837f042c28444dcc0d31179ab',0,1,1,'4aa6e3f8-4f81-4a47-b930-74e234d35e7c','{\"edges\": [[[189, false], null]]}','dep_3'),('c33bff2c-2673-417a-8364-e01452b6c535','2025-11-29 08:04:01','2025-11-29 08:04:45','2025-11-29 08:04:46','ParallelDeploymentsTest-245857673-dep_1-hy56kypba6ug',209,NULL,NULL,'demo_tempestconf','aea137db-5659-4d9c-80a7-f2321a093dfa','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'f63faf9f7c88450a938a9d17285e3bc3',0,1,1,'91cfc81b-afcd-40ac-970b-946f6b5229d4','{\"edges\": [[[205, false], null]]}','dep_1'),('c3dadc4e-5845-4782-9f57-9bfd3e3da617','2025-11-29 08:07:42','2025-11-29 08:08:00','2025-11-29 08:08:04','StackTagTest-1491496176',238,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'2be1e32cc2e04c8fa45bec3bed5d0c63',0,0,1,'c5af0848-e656-4383-a50a-ce79c798f9b6','{\"edges\": [[[229, false], null]]}',NULL),('c4615851-66cd-4eed-ad47-c6036dfa3d06','2025-11-29 08:02:07','2025-11-29 08:02:13','2025-11-29 08:02:14','StackOutputsTest-1596412490',141,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'4320e40f773f49e9a4c7dd3057d215b9',0,0,1,'f69f6490-cd29-417b-9570-eddf1c24a994','{\"edges\": [[[151, false], [152, false]]]}',NULL),('c7292c71-5ac2-4517-8ed0-62e5105c2b9a','2025-11-29 08:00:01','2025-11-29 08:00:06','2025-11-29 08:00:06','StackEventsTest-1197403554',83,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'9f1fa83d59f24ef592395a4330be5a3b',0,0,1,'04aa9626-e93c-400f-b100-567752cf8aed','{\"edges\": [[[106, false], null]]}',NULL),('c7c77e98-2bf9-4163-bd8d-3ffc018502af','2025-11-29 08:02:13','2025-11-29 08:02:25','2025-11-29 08:02:26','HooksTest-1713482985',147,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'9275e0b7dcb24f4aa5aabaf33759f243',0,0,1,'b5092e44-9343-43a4-bb3e-1333c82579b1','{\"edges\": [[[155, false], [154, false]], [[154, false], [153, false]]]}',NULL),('cbe8d4ea-a3b3-4989-b2dd-3c025ae28cbb','2025-11-29 08:03:32','2025-11-29 08:03:44','2025-11-29 08:03:46','RemoteStackTest-1685272545-my_stack-nbddbdzpg2yd',175,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'277df2fcdf24400b85eca72ae3be1c9c',1,'3adb1789520b4073bc4f4ba9681408b9',0,0,1,'e5eb125d-d55e-4cc8-8098-1f2994ec25d4','{\"edges\": [[[171, false], null]]}',NULL),('cd5db660-aa61-4e2d-8500-abc0b35f16e9','2025-11-29 07:58:56','2025-11-29 07:59:52','2025-11-29 07:59:57','create_server_with_sub_ip',76,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'b49c806a50974eb8917449ba2005ef6d',0,0,1,'e1ac29cf-1f87-4cdf-8e71-c5db5d990523','{\"edges\": [[[74, false], [72, false]], [[73, false], [72, false]], [[75, false], [74, false]], [[75, false], [73, false]]]}',NULL),('d1f33fb7-2f7f-45b6-ab3e-3e0d309ff8d8','2025-11-29 08:04:03','2025-11-29 08:04:36','2025-11-29 08:04:37','ParallelDeploymentsTest-680695782-dep_0-6ftgcyagesa5',203,NULL,NULL,'demo_tempestconf','73a6c620-ee95-4d5e-a4c2-86ec10991d07','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'db4fe81c16bd48fe8a478fcb25766918',0,1,1,'af2b34ab-3b94-41fc-890d-25e052832897','{\"edges\": [[[211, false], null]]}','dep_0'),('d3c4e302-ce7c-4d43-ada7-5a133e77c465','2025-11-29 08:03:40','2025-11-29 08:05:08','2025-11-29 08:05:09','ParallelDeploymentsTest-483475472-dep_3-ghivu5y2ntfz',217,NULL,NULL,'demo_tempestconf','0cb91f56-9f71-4cd3-8bfb-beee945b274d','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'395a42f54fe54d2ab61b3256d9a65313',0,1,1,'f361e857-64b1-49eb-8882-2fc418f4d997','{\"edges\": [[[178, false], null]]}','dep_3'),('d50d4a5e-914a-45a3-8798-ac8c4d6bd49d','2025-11-29 08:05:54','2025-11-29 08:07:00','2025-11-29 08:07:01','ParallelDeploymentsTest-528172829-dep_2-xjihl7bp62ay',231,NULL,NULL,'demo_tempestconf','f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','DELETE','COMPLETE','Stack DELETE completed successfully',1,'277df2fcdf24400b85eca72ae3be1c9c',1,'8b7ed15532cc468b84161bd31c07e543',0,1,1,'c23c174f-6679-4d9b-9a90-0f423cef8c2e','{\"edges\": [[[225, false], null]]}','dep_2'),('de771d75-1bfe-417e-b205-8990547089ca','2025-11-29 08:04:03','2025-11-29 08:04:34','2025-11-29 08:04:37','ParallelDeploymentsTest-680695782-dep_1-4u3o3v7oarfl',199,NULL,NULL,'demo_tempestconf','73a6c620-ee95-4d5e-a4c2-86ec10991d07','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'db4fe81c16bd48fe8a478fcb25766918',0,1,1,'ae04458b-a8f7-4f7f-9ee9-f43399cbfe58','{\"edges\": [[[210, false], null]]}','dep_1'),('df2ab267-c8a3-4489-bcbf-7af01cc1bf36','2025-11-29 08:01:49','2025-11-29 08:02:07','2025-11-29 08:02:08','HooksTest-126905259-rg-upgc3i2awrcm',138,NULL,NULL,'demo_tempestconf','99378704-0dba-4b64-8474-42e06567dd4e','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'f00affffa6664dd68c62ef22c17cd4eb',0,1,1,'8ebf580b-fa3c-4283-a6aa-49d1aa9055d2','{\"edges\": [[[147, false], null], [[150, false], null]]}','rg'),('e15fb8cb-952a-4356-99c6-734790bc1027','2025-11-29 08:00:23','2025-11-29 08:00:24','2025-11-29 08:00:25','ExternalReferencesTest-1763834295',94,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'770c390acd474c2091a746ff51681c37',0,0,1,'60658ba0-8e4c-439c-8a51-558fd1b27909','{\"edges\": [[[113, false], null]]}',NULL),('e2ac62a4-74a0-43d6-ae5a-5d53783fa1e9','2025-11-29 08:00:05','2025-11-29 08:00:17','2025-11-29 08:00:20','UpdateSubnetTest-1636516923',88,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'ef678f085f8c42ba8acdb51adeaf9b38',0,0,1,'33decdb2-fdaf-4c90-9290-21e4732d7af1','{\"edges\": [[[108, false], [107, false]]]}',NULL),('e4fa3010-e06b-4360-9335-0afa7b4cb6ad','2025-11-29 08:04:03','2025-11-29 08:04:35','2025-11-29 08:04:37','ParallelDeploymentsTest-680695782-dep_2-igespcbfcpqk',201,NULL,NULL,'demo_tempestconf','73a6c620-ee95-4d5e-a4c2-86ec10991d07','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'db4fe81c16bd48fe8a478fcb25766918',0,1,1,'7be42d68-f9bb-4eb1-8d01-91606c0b22ac','{\"edges\": [[[212, false], null]]}','dep_2'),('e610242b-2f0d-4066-b73a-b387588fc139','2025-11-29 08:03:42','2025-11-29 08:04:56','2025-11-29 08:04:57','ParallelDeploymentsTest-1812906045-dep_0-mhxmhs24l5sk',214,NULL,NULL,'demo_tempestconf','5db7721f-ff92-4146-b2f3-2cd63ad458b0','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'e2fe8e5837f042c28444dcc0d31179ab',0,1,1,'9c32eaf4-b681-4b40-a583-1fc7115b9e87','{\"edges\": [[[190, false], null]]}','dep_0'),('ea56a4a0-2140-4bc7-b725-1f1c485480de','2025-11-29 08:04:04','2025-11-29 08:04:27','2025-11-29 08:04:28','ParallelDeploymentsTest-1562438676-dep_0-d4rtu4k5nihb',196,NULL,NULL,'demo_tempestconf','ab350b0e-eb44-40a7-aa50-d6ed0d0308cd','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'c353808380d3412db6e87d5a5fd7926c',0,1,1,'000b477f-4092-499a-b45c-9752e466dae7','{\"edges\": [[[216, false], null]]}','dep_0'),('ec08cf3b-4733-475f-81cb-90f8d2ab3380','2025-11-29 07:59:06','2025-11-29 07:59:42','2025-11-29 07:59:51','add_subnet',74,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'cdc7c157e23740f39ca49a431e4c6191',0,0,1,'de092dba-72b4-4e86-a266-fa125c7dd4aa','{\"edges\": [[[78, false], [77, false]], [[78, false], [76, false]], [[77, false], [76, false]]]}',NULL),('ecc7b267-89a8-485e-b7bb-52a583fc8411','2025-11-29 07:56:52','2025-11-29 07:57:14','2025-11-29 07:57:22','UpdatePortTest-1106060137',34,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'b949dc8ec0c746d7b7e6a6153903e21a',0,0,1,'9faea0ac-bc9c-47a7-a1f8-b1ad0e321aef','{\"edges\": [[[12, false], [11, false]], [[14, false], [12, false]], [[14, false], [13, false]], [[13, false], [12, false]]]}',NULL),('eede8308-afc1-45ef-b05b-7d9d5c707cdb','2025-11-29 07:56:42',NULL,NULL,'api-28086934-rsrcstack',6,NULL,5,'demo_tempestconf',NULL,'CREATE','COMPLETE','Stack CREATE completed successfully',NULL,'277df2fcdf24400b85eca72ae3be1c9c',1,'f7020fd3c081421c88901c71e9adb82b',0,0,1,'ddf8493f-07c5-4bb2-987d-32f203bb03b8','{\"edges\": [[[5, true], null]]}',NULL),('f3692fc8-e860-4e43-8cde-f15cbd63afd2','2025-11-29 07:57:24','2025-11-29 07:57:38','2025-11-29 07:57:44','UpdatePortTest-2045562501',41,NULL,NULL,'admin',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'4708a15e28154d3189eded8da6108d55',1,'8e28f9bcd28d4ddea77c77c96655a2dc',0,0,1,'6463e442-8060-4450-9ff5-e0bb23986353','{\"edges\": [[[34, false], null], [[36, false], [38, false]], [[37, false], [36, false]], [[37, false], [38, false]]]}',NULL),('f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','2025-11-29 08:05:51','2025-11-29 08:06:56','2025-11-29 08:07:06','ParallelDeploymentsTest-528172829',228,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1,'277df2fcdf24400b85eca72ae3be1c9c',1,'8b7ed15532cc468b84161bd31c07e543',0,0,1,'ff6b9689-a42f-49f7-9fd5-db107c8b87ff','{\"edges\": [[[224, false], [221, false]], [[224, false], [222, false]], [[224, false], [223, false]]]}',NULL),('f642a646-a9f0-4eb5-99de-fb59bc81ca00','2025-11-29 08:01:25','2025-11-29 08:01:44','2025-11-29 08:01:45','HooksTest-780960166',125,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'a9723c2a4bf74b62bc19e66dc9877a5d',0,0,1,'6b8366cc-1a59-47ca-976d-ba8c78899c42','{\"edges\": [[[139, false], [138, false]], [[138, false], [137, false]]]}',NULL),('f744021c-6440-4773-8d90-91e1d6439dd5','2025-11-29 07:59:11','2025-11-29 07:59:45','2025-11-29 07:59:52','UpdateTrunkTest-1613110987',75,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'e24b7ec0e14c447cbcd4c33234923bcb',0,0,1,'b439e5fe-c7eb-4bc1-a206-23bcde83bf68','{\"edges\": [[[82, false], [79, false]], [[80, false], [79, false]], [[86, false], [85, false]], [[86, false], [80, false]], [[85, false], [80, false]], [[84, false], [83, false]], [[84, false], [81, false]], [[83, false], [81, false]], [[88, false], [82, false]], [[88, false], [87, false]], [[87, false], [82, false]]]}',NULL),('f8053df6-7b93-4477-b9a8-f5463f418b78','2025-11-29 07:56:59','2025-11-29 07:57:10','2025-11-29 07:57:11','EncryptionVolTypeTest-396954832',33,NULL,NULL,'admin',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'4708a15e28154d3189eded8da6108d55',1,'da316c300f2045a78baeed0d835ea6c8',0,0,1,'31491e15-4649-493d-b856-308545928835','{\"edges\": [[[16, false], [15, false]]]}',NULL),('f8139037-997b-47b3-acc0-bba75fe5499c','2025-11-29 07:56:47','2025-11-29 07:56:48','2025-11-29 07:56:49','api-1857042720-empty',14,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'277df2fcdf24400b85eca72ae3be1c9c',1,'a1751a14d13f43009a39700e32bd8107',0,0,1,'8d644ee6-4f5f-4fc1-94d0-55d4363a74af','{\"edges\": []}',NULL),('f9568701-164d-4eaf-87f6-40eb8c69eb2c','2025-11-29 08:05:54','2025-11-29 08:06:59','2025-11-29 08:07:01','ParallelDeploymentsTest-528172829-dep_1-cuno5va26t46',230,NULL,NULL,'demo_tempestconf','f4eb80a9-b479-44f8-bdf3-d0ed0cac7af8','DELETE','COMPLETE','Stack DELETE completed successfully',1,'277df2fcdf24400b85eca72ae3be1c9c',1,'8b7ed15532cc468b84161bd31c07e543',0,1,1,'4caddec3-4c54-4087-828a-6b4f1728c591','{\"edges\": [[[227, false], null]]}','dep_1'),('fb5263ef-580a-4246-bce5-72b6941b9921','2025-11-29 08:04:03','2025-11-29 08:04:21','2025-11-29 08:04:23','RemoteStackTest-1393600846-my_stack-c7tltrj43yhk',191,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'277df2fcdf24400b85eca72ae3be1c9c',1,'89e4f43b067844afb0d08f0863cf5800',0,0,1,'62ad2fd7-8a00-4696-970b-80494f76e99f','{\"edges\": [[[215, false], null]]}',NULL),('fc8b6f5a-c10b-4428-990d-f5c2ce4d29c6','2025-11-29 08:02:25','2025-11-29 08:03:01','2025-11-29 08:03:08','swap_subnet_network',155,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'277df2fcdf24400b85eca72ae3be1c9c',1,'e56a96f0fdbc40a487b54b326cc9ad63',0,0,1,'1f255e3c-9cea-49d3-b868-86bb2919f0ab','{\"edges\": [[[159, false], [158, false]], [[159, false], [157, false]], [[158, false], [157, false]]]}',NULL),('fece2f07-8916-4374-a2f4-ffdda334ad00','2025-11-29 07:56:50','2025-11-29 07:56:51','2025-11-29 07:56:52','api-1592030466-empty',21,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'277df2fcdf24400b85eca72ae3be1c9c',1,'e66b5efb238b4cfeb3b752e67b402b5d',0,0,1,'a3a811f9-7214-4c58-9bcb-6c5cf144df13','{\"edges\": []}',NULL);
/*!40000 ALTER TABLE `stack` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack_lock`
--

DROP TABLE IF EXISTS `stack_lock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack_lock` (
  `stack_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `engine_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`stack_id`),
  CONSTRAINT `stack_lock_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack_lock`
--

LOCK TABLES `stack_lock` WRITE;
/*!40000 ALTER TABLE `stack_lock` DISABLE KEYS */;
/*!40000 ALTER TABLE `stack_lock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack_tag`
--

DROP TABLE IF EXISTS `stack_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `tag` varchar(80) DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `stack_id` (`stack_id`),
  CONSTRAINT `stack_tag_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack_tag`
--

LOCK TABLES `stack_tag` WRITE;
/*!40000 ALTER TABLE `stack_tag` DISABLE KEYS */;
INSERT INTO `stack_tag` (`id`, `created_at`, `updated_at`, `tag`, `stack_id`) VALUES (1,'2025-11-29 08:07:22',NULL,'foo','705ab806-d900-46cd-8993-3d860855c41c'),(2,'2025-11-29 08:07:22',NULL,'data-processing-cluster','705ab806-d900-46cd-8993-3d860855c41c');
/*!40000 ALTER TABLE `stack_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_point`
--

DROP TABLE IF EXISTS `sync_point`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sync_point` (
  `entity_id` varchar(36) NOT NULL,
  `traversal_id` varchar(36) NOT NULL,
  `is_update` tinyint(1) NOT NULL,
  `atomic_key` int(11) NOT NULL,
  `stack_id` varchar(36) NOT NULL,
  `input_data` longtext DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`traversal_id`,`is_update`),
  KEY `fk_stack_id` (`stack_id`),
  CONSTRAINT `fk_stack_id` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_point`
--

LOCK TABLES `sync_point` WRITE;
/*!40000 ALTER TABLE `sync_point` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_point` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_creds`
--

DROP TABLE IF EXISTS `user_creds`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_creds` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `username` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `region_name` varchar(255) DEFAULT NULL,
  `decrypt_method` varchar(64) DEFAULT NULL,
  `tenant` varchar(1024) DEFAULT NULL,
  `auth_url` text DEFAULT NULL,
  `tenant_id` varchar(256) DEFAULT NULL,
  `trust_id` varchar(255) DEFAULT NULL,
  `trustor_user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_creds`
--

LOCK TABLES `user_creds` WRITE;
/*!40000 ALTER TABLE `user_creds` DISABLE KEYS */;
INSERT INTO `user_creds` (`id`, `created_at`, `updated_at`, `username`, `password`, `region_name`, `decrypt_method`, `tenant`, `auth_url`, `tenant_id`, `trust_id`, `trustor_user_id`) VALUES (1,'2025-11-29 07:56:38',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','277df2fcdf24400b85eca72ae3be1c9c','gAAAAABpKqc2nLe9NfqiKIW3AMwXW6qG-iLJtKCTL6CVpHLUCghlp8XiGXKK83z5yuPxJ5vz8uvOv0DJFVLGTpduChUl2HDghwC1Oe_VuH2SZ3hGO4Z5nk-fLyMBMLR6BMlSbPal36_f','89037d9d7e65485d887783b84c589ed7'),(2,'2025-11-29 07:56:38',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','277df2fcdf24400b85eca72ae3be1c9c','gAAAAABpKqc2Hif-HztIN-O0-9FI-tMwLrnWY-gyfO6T0DbnAfLzJP2MaqRC42DRTfYBTwLzk66CFFPNZS4Nd5O0DS7V-1yGMNhGDLSU81EKj6NOO9jfZV18Q3iWn11WlvhXXWjrUupl','89037d9d7e65485d887783b84c589ed7'),(5,'2025-11-29 07:56:42',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','277df2fcdf24400b85eca72ae3be1c9c','gAAAAABpKqc6MlAq6RQycYHpVfYqvKCmwlZV0EueWyl3q95RnavDlsttUoL_UvsAdmXPx235CjyReUgBM49B1gurQHWdYtWb8ykHDuHrUN--HE5mPMSLCgyKyamjoCh2kjx659NNNZpT','89037d9d7e65485d887783b84c589ed7'),(6,'2025-11-29 07:56:42',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','277df2fcdf24400b85eca72ae3be1c9c','gAAAAABpKqc6hr8QOo3o4j72LoxHmHoZSG9Gi65hM-S1ndSzeBl63uyYqn0HAqWEQgMaIYKtyFcFci61VC62bu3j_1azeLIa5Ze9t3hQe6nGEX18NDfW-FjoP7kRGlFT942q5F4awifq','89037d9d7e65485d887783b84c589ed7'),(10,'2025-11-29 07:56:47',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','277df2fcdf24400b85eca72ae3be1c9c','gAAAAABpKqc_u116168UYy4GjmxKE-DeO2D1KEzDOfxuZM5MVd2pBSx2-DMu7CXGvgvYTNyhAo4Yr_UtXzzRJMHAjEdEz8RCS0Q523KWOaLfdBNSx7HQNjWANwuKXC8QJIRbMGvKiYvV','89037d9d7e65485d887783b84c589ed7'),(12,'2025-11-29 07:56:49',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','277df2fcdf24400b85eca72ae3be1c9c','gAAAAABpKqdBzzEBkMz6DVN17SHlh7TmNW7W_GHYwt-aiGdaJg2CGZrohux4KVM5QEDv8Ofzs0OZyirzYBrEECSS0-EYd70Bl6-oqHhPHNbTCXtH_0JEZrRqbMJIfK3L9tp8G8pV0jB7','89037d9d7e65485d887783b84c589ed7'),(14,'2025-11-29 07:56:52',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','277df2fcdf24400b85eca72ae3be1c9c','gAAAAABpKqdEbXYWsfy7dgryfiTlqecUjEwoRni0Jq1MWDzha_xsmBCupxd5oEVbUgv9DWONoTi0-OHXNa80WHBqEnCew_YkPBGFQPt1z4F3UGlj9L5whdzrHKLogLhQ5eCaqImLAXLF','89037d9d7e65485d887783b84c589ed7');
/*!40000 ALTER TABLE `user_creds` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `keystone`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `keystone` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `keystone`;

--
-- Table structure for table `access_rule`
--

DROP TABLE IF EXISTS `access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(64) DEFAULT NULL,
  `path` varchar(128) DEFAULT NULL,
  `method` varchar(16) DEFAULT NULL,
  `external_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_rule_external_id_key` (`external_id`),
  UNIQUE KEY `duplicate_access_rule_for_user_constraint` (`user_id`,`service`,`path`,`method`),
  KEY `external_id` (`external_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_rule`
--

LOCK TABLES `access_rule` WRITE;
/*!40000 ALTER TABLE `access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_token`
--

DROP TABLE IF EXISTS `access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_token` (
  `id` varchar(64) NOT NULL,
  `access_secret` varchar(64) NOT NULL,
  `authorizing_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  `role_ids` text NOT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_access_token_authorizing_user_id` (`authorizing_user_id`),
  KEY `ix_access_token_consumer_id` (`consumer_id`),
  CONSTRAINT `access_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_token`
--

LOCK TABLES `access_token` WRITE;
/*!40000 ALTER TABLE `access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('29e87d24a316'),('e25ffa003242');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential`
--

DROP TABLE IF EXISTS `application_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential` (
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `secret_hash` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `system` varchar(64) DEFAULT NULL,
  `unrestricted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `duplicate_app_cred_constraint` (`user_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential`
--

LOCK TABLES `application_credential` WRITE;
/*!40000 ALTER TABLE `application_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_access_rule`
--

DROP TABLE IF EXISTS `application_credential_access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_access_rule` (
  `application_credential_id` int(11) NOT NULL,
  `access_rule_id` int(11) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`access_rule_id`),
  KEY `access_rule_id` (`access_rule_id`),
  CONSTRAINT `application_credential_access_rule_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE,
  CONSTRAINT `application_credential_access_rule_ibfk_2` FOREIGN KEY (`access_rule_id`) REFERENCES `access_rule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_access_rule`
--

LOCK TABLES `application_credential_access_rule` WRITE;
/*!40000 ALTER TABLE `application_credential_access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_role`
--

DROP TABLE IF EXISTS `application_credential_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_role` (
  `application_credential_id` int(11) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`role_id`),
  CONSTRAINT `application_credential_role_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_role`
--

LOCK TABLES `application_credential_role` WRITE;
/*!40000 ALTER TABLE `application_credential_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assignment` (
  `type` enum('UserProject','GroupProject','UserDomain','GroupDomain') NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  KEY `ix_actor_id` (`actor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserProject','04a9d98013d04ae699c3065d87275a05','77fc494bab664d03873bd2631992e117','0005a6ef80d04b6fa46027889779bbcf',0),('UserProject','04a9d98013d04ae699c3065d87275a05','77fc494bab664d03873bd2631992e117','73fafa84d4a64c7ab14dbbb918166e64',0),('UserProject','565a100d281a4282a60ff8ff3cde3aa5','77fc494bab664d03873bd2631992e117','0005a6ef80d04b6fa46027889779bbcf',0),('UserProject','565a100d281a4282a60ff8ff3cde3aa5','77fc494bab664d03873bd2631992e117','73fafa84d4a64c7ab14dbbb918166e64',0),('UserProject','6480399a8f344eebac2e0fea958fe314','77fc494bab664d03873bd2631992e117','0005a6ef80d04b6fa46027889779bbcf',0),('UserProject','6480399a8f344eebac2e0fea958fe314','77fc494bab664d03873bd2631992e117','73fafa84d4a64c7ab14dbbb918166e64',0),('UserProject','8494d41166dd44efacbacac961b18f97','277df2fcdf24400b85eca72ae3be1c9c','73fafa84d4a64c7ab14dbbb918166e64',0),('UserProject','8494d41166dd44efacbacac961b18f97','4708a15e28154d3189eded8da6108d55','73fafa84d4a64c7ab14dbbb918166e64',0),('UserProject','89037d9d7e65485d887783b84c589ed7','277df2fcdf24400b85eca72ae3be1c9c','783e0ca5346649b8a76f2a1c657ce4b2',0),('UserProject','9f244f4ac94847669842e5162d1f76c6','77fc494bab664d03873bd2631992e117','0005a6ef80d04b6fa46027889779bbcf',0),('UserProject','9f244f4ac94847669842e5162d1f76c6','77fc494bab664d03873bd2631992e117','73fafa84d4a64c7ab14dbbb918166e64',0),('UserProject','bddce9e6823d4a4b937c4bd533c36894','77fc494bab664d03873bd2631992e117','0005a6ef80d04b6fa46027889779bbcf',0),('UserProject','bddce9e6823d4a4b937c4bd533c36894','77fc494bab664d03873bd2631992e117','73fafa84d4a64c7ab14dbbb918166e64',0),('UserProject','c5fc0aabf5c74e99b6c2fa74cb397344','77fc494bab664d03873bd2631992e117','0005a6ef80d04b6fa46027889779bbcf',0),('UserProject','c5fc0aabf5c74e99b6c2fa74cb397344','77fc494bab664d03873bd2631992e117','73fafa84d4a64c7ab14dbbb918166e64',0),('UserProject','ce5cf5c8bb8a472595a2e52809651c8c','77fc494bab664d03873bd2631992e117','0005a6ef80d04b6fa46027889779bbcf',0),('UserProject','ce5cf5c8bb8a472595a2e52809651c8c','77fc494bab664d03873bd2631992e117','73fafa84d4a64c7ab14dbbb918166e64',0),('UserProject','d5a7dda43bec4971a33c7eeba5c0693f','77fc494bab664d03873bd2631992e117','0005a6ef80d04b6fa46027889779bbcf',0),('UserProject','d5a7dda43bec4971a33c7eeba5c0693f','77fc494bab664d03873bd2631992e117','73fafa84d4a64c7ab14dbbb918166e64',0),('UserProject','d5a7dda43bec4971a33c7eeba5c0693f','77fc494bab664d03873bd2631992e117','8ce8d817c1624d849f075a0448bdb8fd',0),('UserProject','dae9de15a4ed4e4d9af31a9f998453f7','77fc494bab664d03873bd2631992e117','0005a6ef80d04b6fa46027889779bbcf',0),('UserProject','dae9de15a4ed4e4d9af31a9f998453f7','77fc494bab664d03873bd2631992e117','73fafa84d4a64c7ab14dbbb918166e64',0),('UserDomain','2872e0a2c27347ed8ca6bce93a367527','0e9e03d9fc1648479517a37f05154c53','73fafa84d4a64c7ab14dbbb918166e64',0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_register`
--

DROP TABLE IF EXISTS `config_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_register` (
  `type` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_register`
--

LOCK TABLES `config_register` WRITE;
/*!40000 ALTER TABLE `config_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `config_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumer`
--

DROP TABLE IF EXISTS `consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumer` (
  `id` varchar(64) NOT NULL,
  `description` varchar(64) DEFAULT NULL,
  `secret` varchar(64) NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumer`
--

LOCK TABLES `consumer` WRITE;
/*!40000 ALTER TABLE `consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credential` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `key_hash` varchar(64) NOT NULL,
  `encrypted_blob` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint` (
  `id` varchar(64) NOT NULL,
  `legacy_endpoint_id` varchar(64) DEFAULT NULL,
  `interface` varchar(8) NOT NULL,
  `service_id` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `region_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_endpoint_region_id` (`region_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `endpoint_service_id_fkey` FOREIGN KEY (`service_id`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_endpoint_region_id` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
INSERT INTO `endpoint` (`id`, `legacy_endpoint_id`, `interface`, `service_id`, `url`, `extra`, `enabled`, `region_id`) VALUES ('01701026233c435a822e2141f1941ebc',NULL,'public','e1c6b459c589490b9c260acada6ec03b','https://cinder-public-openstack.apps-crc.testing/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('06393de120644ae8ac300b034fc70bf6',NULL,'internal','11f97b0e51484cc19944335ecac43112','https://heat-cfnapi-internal.openstack.svc:8000/v1','{\"name\": \"heat-cfn\"}',1,'regionOne'),('1fd372a622c647bb8df6cefcee7bdaed',NULL,'public','2eca9498d702470ab2f571123bcf6bac','https://heat-api-public-openstack.apps-crc.testing/v1/%(tenant_id)s','{\"name\": \"heat\"}',1,'regionOne'),('1fed8ebf5a3949cebca179d7f56a3e91',NULL,'internal','169e8cfe0bff4ee59f6f790e1b299976','https://keystone-internal.openstack.svc:5000','{}',1,'regionOne'),('254542a3f1e047bd919e965332a7c4f2',NULL,'public','3ae585af780c46de93b4e0b5b54fe2fc','https://placement-public-openstack.apps-crc.testing','{\"name\": \"placement\"}',1,'regionOne'),('4757a1926d4f46f1a84211bdb8de0fb9',NULL,'internal','61d26759eb88484eace8a93229a31b27','https://glance-default-internal.openstack.svc:9292','{\"name\": \"glance\"}',1,'regionOne'),('7b32a725b8204b1da252786f9bd5c62f',NULL,'public','61d26759eb88484eace8a93229a31b27','https://glance-default-public-openstack.apps-crc.testing','{\"name\": \"glance\"}',1,'regionOne'),('7b6adbd695014809805e4cab5d5548dc',NULL,'public','169e8cfe0bff4ee59f6f790e1b299976','https://keystone-public-openstack.apps-crc.testing','{}',1,'regionOne'),('81ef623e14dc4ad88c450e1519a5274c',NULL,'internal','1c91af5d2519477682edf9d7eba56425','https://nova-internal.openstack.svc:8774/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('8853ab48a40d42f2869209fa9fbc88bc',NULL,'internal','c87c2ac268cc470796b9700e7ea21c39','https://swift-internal.openstack.svc:8080/v1/AUTH_%(tenant_id)s','{\"name\": \"swift\"}',1,'regionOne'),('95255cf8c73b4672bfb63513be506151',NULL,'public','26b9c291e2354e9e89416d0ff82e412b','https://barbican-public-openstack.apps-crc.testing','{\"name\": \"barbican\"}',1,'regionOne'),('a67c5be7a7ef4054a1669b9699c80c8b',NULL,'internal','2eca9498d702470ab2f571123bcf6bac','https://heat-api-internal.openstack.svc:8004/v1/%(tenant_id)s','{\"name\": \"heat\"}',1,'regionOne'),('ab561a58141e4a8b81569a16b3201b68',NULL,'internal','140c96bff7da483a9f8b2d74ad4c89dc','https://neutron-internal.openstack.svc:9696','{\"name\": \"neutron\"}',1,'regionOne'),('b7c3e6debbe24f4d89337cb53b9c0fa5',NULL,'public','c87c2ac268cc470796b9700e7ea21c39','https://swift-public-openstack.apps-crc.testing/v1/AUTH_%(tenant_id)s','{\"name\": \"swift\"}',1,'regionOne'),('bd7c550db2454477b5bfd3f5740e75ec',NULL,'public','140c96bff7da483a9f8b2d74ad4c89dc','https://neutron-public-openstack.apps-crc.testing','{\"name\": \"neutron\"}',1,'regionOne'),('c7867bf3d33d4b028cd00ccad89932db',NULL,'public','1c91af5d2519477682edf9d7eba56425','https://nova-public-openstack.apps-crc.testing/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('cb2cd8e1b741463cace11cdbb49591b6',NULL,'public','11f97b0e51484cc19944335ecac43112','https://heat-cfnapi-public-openstack.apps-crc.testing/v1','{\"name\": \"heat-cfn\"}',1,'regionOne'),('d23a997bb14b4a4d9eb723888e0d1ba6',NULL,'internal','3ae585af780c46de93b4e0b5b54fe2fc','https://placement-internal.openstack.svc:8778','{\"name\": \"placement\"}',1,'regionOne'),('dc0055f8021a49bf85d70ecf2fe7e7e9',NULL,'internal','e1c6b459c589490b9c260acada6ec03b','https://cinder-internal.openstack.svc:8776/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('f267e4e1dacf4b698472a6923f23da2d',NULL,'internal','26b9c291e2354e9e89416d0ff82e412b','https://barbican-internal.openstack.svc:9311','{\"name\": \"barbican\"}',1,'regionOne');
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint_group`
--

DROP TABLE IF EXISTS `endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint_group` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `filters` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint_group`
--

LOCK TABLES `endpoint_group` WRITE;
/*!40000 ALTER TABLE `endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expiring_user_group_membership`
--

DROP TABLE IF EXISTS `expiring_user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expiring_user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `last_verified` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`,`idp_id`),
  KEY `group_id` (`group_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_3` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expiring_user_group_membership`
--

LOCK TABLES `expiring_user_group_membership` WRITE;
/*!40000 ALTER TABLE `expiring_user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `expiring_user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federated_user`
--

DROP TABLE IF EXISTS `federated_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federated_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `protocol_id` varchar(64) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idp_id` (`idp_id`,`protocol_id`,`unique_id`),
  KEY `federated_user_protocol_id_fkey` (`protocol_id`,`idp_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `federated_user_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_ibfk_2` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_protocol_id_fkey` FOREIGN KEY (`protocol_id`, `idp_id`) REFERENCES `federation_protocol` (`id`, `idp_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federated_user`
--

LOCK TABLES `federated_user` WRITE;
/*!40000 ALTER TABLE `federated_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `federated_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federation_protocol`
--

DROP TABLE IF EXISTS `federation_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federation_protocol` (
  `id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `mapping_id` varchar(64) NOT NULL,
  `remote_id_attribute` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`,`idp_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `federation_protocol_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federation_protocol`
--

LOCK TABLES `federation_protocol` WRITE;
/*!40000 ALTER TABLE `federation_protocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `federation_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group`
--

DROP TABLE IF EXISTS `group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group` (
  `id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_group_name_domain_id` (`domain_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group`
--

LOCK TABLES `group` WRITE;
/*!40000 ALTER TABLE `group` DISABLE KEYS */;
/*!40000 ALTER TABLE `group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `id_mapping`
--

DROP TABLE IF EXISTS `id_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `id_mapping` (
  `public_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `local_id` varchar(255) NOT NULL,
  `entity_type` enum('user','group') NOT NULL,
  PRIMARY KEY (`public_id`),
  UNIQUE KEY `domain_id` (`domain_id`,`local_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `id_mapping`
--

LOCK TABLES `id_mapping` WRITE;
/*!40000 ALTER TABLE `id_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `id_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `identity_provider`
--

DROP TABLE IF EXISTS `identity_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `identity_provider` (
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `authorization_ttl` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `identity_provider`
--

LOCK TABLES `identity_provider` WRITE;
/*!40000 ALTER TABLE `identity_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `identity_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `idp_remote_ids`
--

DROP TABLE IF EXISTS `idp_remote_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `idp_remote_ids` (
  `idp_id` varchar(64) DEFAULT NULL,
  `remote_id` varchar(255) NOT NULL,
  PRIMARY KEY (`remote_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `idp_remote_ids_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `idp_remote_ids`
--

LOCK TABLES `idp_remote_ids` WRITE;
/*!40000 ALTER TABLE `idp_remote_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `idp_remote_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `implied_role`
--

DROP TABLE IF EXISTS `implied_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `implied_role` (
  `prior_role_id` varchar(64) NOT NULL,
  `implied_role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`prior_role_id`,`implied_role_id`),
  KEY `implied_role_implied_role_id_fkey` (`implied_role_id`),
  CONSTRAINT `implied_role_implied_role_id_fkey` FOREIGN KEY (`implied_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE,
  CONSTRAINT `implied_role_prior_role_id_fkey` FOREIGN KEY (`prior_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `implied_role`
--

LOCK TABLES `implied_role` WRITE;
/*!40000 ALTER TABLE `implied_role` DISABLE KEYS */;
INSERT INTO `implied_role` (`prior_role_id`, `implied_role_id`) VALUES ('73fafa84d4a64c7ab14dbbb918166e64','783e0ca5346649b8a76f2a1c657ce4b2'),('783e0ca5346649b8a76f2a1c657ce4b2','f790e80eb1f5434f86e8988e2ef43d94');
/*!40000 ALTER TABLE `implied_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `limit`
--

DROP TABLE IF EXISTS `limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `limit` (
  `id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `resource_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `registered_limit_id` varchar(64) DEFAULT NULL,
  `domain_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `limit_id_key` (`id`),
  KEY `registered_limit_id` (`registered_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `limit`
--

LOCK TABLES `limit` WRITE;
/*!40000 ALTER TABLE `limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_user`
--

DROP TABLE IF EXISTS `local_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `local_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `failed_auth_count` int(11) DEFAULT NULL,
  `failed_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_id` (`domain_id`,`name`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `local_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `local_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `local_user`
--

LOCK TABLES `local_user` WRITE;
/*!40000 ALTER TABLE `local_user` DISABLE KEYS */;
INSERT INTO `local_user` (`id`, `user_id`, `domain_id`, `name`, `failed_auth_count`, `failed_auth_at`) VALUES (1,'8494d41166dd44efacbacac961b18f97','default','admin',0,NULL),(2,'d5a7dda43bec4971a33c7eeba5c0693f','default','ceilometer',0,NULL),(3,'565a100d281a4282a60ff8ff3cde3aa5','default','barbican',0,NULL),(4,'2872e0a2c27347ed8ca6bce93a367527','0e9e03d9fc1648479517a37f05154c53','heat_stack_domain_admin',0,NULL),(5,'6480399a8f344eebac2e0fea958fe314','default','nova',0,NULL),(6,'04a9d98013d04ae699c3065d87275a05','default','placement',0,NULL),(7,'ce5cf5c8bb8a472595a2e52809651c8c','default','swift',0,NULL),(8,'bddce9e6823d4a4b937c4bd533c36894','default','glance',0,NULL),(9,'dae9de15a4ed4e4d9af31a9f998453f7','default','heat',0,NULL),(10,'9f244f4ac94847669842e5162d1f76c6','default','cinder',0,NULL),(11,'c5fc0aabf5c74e99b6c2fa74cb397344','default','neutron',0,NULL),(12,'89037d9d7e65485d887783b84c589ed7','default','demo_tempestconf',0,NULL),(13,'652182967968410ea0a193e13f857e23','default','alt_demo_tempestconf',0,NULL);
/*!40000 ALTER TABLE `local_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mapping`
--

DROP TABLE IF EXISTS `mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mapping` (
  `id` varchar(64) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mapping`
--

LOCK TABLES `mapping` WRITE;
/*!40000 ALTER TABLE `mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nonlocal_user`
--

DROP TABLE IF EXISTS `nonlocal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nonlocal_user` (
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  PRIMARY KEY (`domain_id`,`name`),
  UNIQUE KEY `ixu_nonlocal_user_user_id` (`user_id`),
  KEY `nonlocal_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `nonlocal_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nonlocal_user`
--

LOCK TABLES `nonlocal_user` WRITE;
/*!40000 ALTER TABLE `nonlocal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `nonlocal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password`
--

DROP TABLE IF EXISTS `password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_user_id` int(11) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `self_service` tinyint(1) NOT NULL DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `created_at_int` bigint(20) NOT NULL DEFAULT 0,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `local_user_id` (`local_user_id`),
  CONSTRAINT `password_ibfk_1` FOREIGN KEY (`local_user_id`) REFERENCES `local_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password`
--

LOCK TABLES `password` WRITE;
/*!40000 ALTER TABLE `password` DISABLE KEYS */;
INSERT INTO `password` (`id`, `local_user_id`, `expires_at`, `self_service`, `password_hash`, `created_at_int`, `expires_at_int`, `created_at`) VALUES (1,1,NULL,0,'$2b$12$ZbNKogJlFe0utk3w249gMOXA1x26BvHVUZGXzKcnt/5eVdphF95Zi',1764400997359334,NULL,'2025-11-29 07:23:17'),(2,2,NULL,0,'$2b$12$pLNMXMX.u3Z8vfSgXpysfenBbqaCtlzTleLrvwqBqeLnkzjSuSeIK',1764401094520574,NULL,'2025-11-29 07:24:54'),(3,3,NULL,0,'$2b$12$S3eAkeQ38Mv/9llJ0zIWCOPxk4EgMM7/mqFZWodWihT.Z4vt0dQFa',1764401101650597,NULL,'2025-11-29 07:25:01'),(4,4,NULL,0,'$2b$12$MYUQRrcFMU8Gtg5WK94X9.xuQ8wAx844I/ANHslrnSfICXhVEJ4Gi',1764401114926930,NULL,'2025-11-29 07:25:14'),(5,5,NULL,0,'$2b$12$OubJ14UU/pNdn05Y/028L.GNXM3HvxqPrbxwm44GPGZ92qpMWa.Oa',1764401122425023,NULL,'2025-11-29 07:25:22'),(6,6,NULL,0,'$2b$12$r9.R6Imb0bKytC4heyhiDOOl5PP7iM761ycP3ZT18xZwZhgoK29Y.',1764401143566930,NULL,'2025-11-29 07:25:43'),(7,7,NULL,0,'$2b$12$MzgX7Sr92t915cTIVxFim.6S6S6At9ajF4tdVLNoyQtuGK.knqd8S',1764401154413611,NULL,'2025-11-29 07:25:54'),(8,8,NULL,0,'$2b$12$jQzMtivgtSQgn2ExTTiS4uIDvXP2Ba5cpzQCRRC/CgtevXtfpS6iS',1764401164672376,NULL,'2025-11-29 07:26:04'),(9,9,NULL,0,'$2b$12$o6.mUVlmUdWjHcULiIkq8.0aiOKT/UzyIxCvLv9n3M1mG6PvRE496',1764401179255437,NULL,'2025-11-29 07:26:19'),(10,10,NULL,0,'$2b$12$iLvPaCA.7uCUn3S1yFQBIeApPFalgZVI0tCkQX7IfYWqOQ88Tv7JK',1764401190024478,NULL,'2025-11-29 07:26:30'),(11,11,NULL,0,'$2b$12$VpWbpfKC0Fyc7Cv8..uz9OON0f74ggxB.ZMREX/VS/LHkWdU7gVea',1764401196104963,NULL,'2025-11-29 07:26:36'),(12,12,NULL,0,'$2b$12$HdOWfq1BJL0Spum1ONP0SOorXxqy5xCW0pw.9ywwPXzOZ3/s1kACK',1764402960801174,NULL,'2025-11-29 07:56:00'),(13,13,NULL,0,'$2b$12$GepupQgGhPgUm2Fp7qrjfuNOQ8UQbt54C6JWwZlhfumEa7dDztxW2',1764402961321331,NULL,'2025-11-29 07:56:01');
/*!40000 ALTER TABLE `password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `blob` text NOT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_association`
--

DROP TABLE IF EXISTS `policy_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy_association` (
  `id` varchar(64) NOT NULL,
  `policy_id` varchar(64) NOT NULL,
  `endpoint_id` varchar(64) DEFAULT NULL,
  `service_id` varchar(64) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `endpoint_id` (`endpoint_id`,`service_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_association`
--

LOCK TABLES `policy_association` WRITE;
/*!40000 ALTER TABLE `policy_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project` (
  `id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL,
  `is_domain` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_project_name_domain_id` (`domain_id`,`name`),
  KEY `project_parent_id_fkey` (`parent_id`),
  CONSTRAINT `project_domain_id_fkey` FOREIGN KEY (`domain_id`) REFERENCES `project` (`id`),
  CONSTRAINT `project_parent_id_fkey` FOREIGN KEY (`parent_id`) REFERENCES `project` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
INSERT INTO `project` (`id`, `name`, `extra`, `description`, `enabled`, `domain_id`, `parent_id`, `is_domain`) VALUES ('0e9e03d9fc1648479517a37f05154c53','heat_stack','{}','Domain for Heat stacks',1,'<<keystone.domain.root>>',NULL,1),('277df2fcdf24400b85eca72ae3be1c9c','demo','{}','Project for Tempest demo_tempestconf user',1,'default','default',0),('3fca2f15e48c4f51b713aa34c86f3ed2','277df2fcdf24400b85eca72ae3be1c9c-4a915ecb-a078-4c37-ae7d-1f59204','{}','Heat stack user project',1,'0e9e03d9fc1648479517a37f05154c53','0e9e03d9fc1648479517a37f05154c53',0),('4708a15e28154d3189eded8da6108d55','admin','{}','Bootstrap project for initializing the cloud.',1,'default','default',0),('5d704a8d05794b0db893da833f5a252c','277df2fcdf24400b85eca72ae3be1c9c-39e3c4d0-31c3-472a-9429-e6d5090','{}','Heat stack user project',1,'0e9e03d9fc1648479517a37f05154c53','0e9e03d9fc1648479517a37f05154c53',0),('5ec669b41e544a1d9964ab3fcc79252d','alt_demo','{}','Project for Tempest alt_demo_tempestconf user',1,'default','default',0),('77fc494bab664d03873bd2631992e117','service','{}','service',1,'default','default',0),('7b94c82152c643feb7a538d52cce0cc8','277df2fcdf24400b85eca72ae3be1c9c-00018af1-0bcd-47f5-b95e-1d4b9e1','{}','Heat stack user project',1,'0e9e03d9fc1648479517a37f05154c53','0e9e03d9fc1648479517a37f05154c53',0),('8d185dc67a2b4d0a9ff3c81f4d9930c5','277df2fcdf24400b85eca72ae3be1c9c-4ac64ef8-0fe2-479c-8365-5b13dd0','{}','Heat stack user project',1,'0e9e03d9fc1648479517a37f05154c53','0e9e03d9fc1648479517a37f05154c53',0),('947db8bd6f144bac91c48d9798521321','277df2fcdf24400b85eca72ae3be1c9c-73cbbbd3-2559-48d0-adeb-273aa21','{}','Heat stack user project',1,'0e9e03d9fc1648479517a37f05154c53','0e9e03d9fc1648479517a37f05154c53',0),('<<keystone.domain.root>>','<<keystone.domain.root>>','{}','',0,'<<keystone.domain.root>>',NULL,1),('aceee0257e7c4d0db263ed39a4aaa42d','277df2fcdf24400b85eca72ae3be1c9c-9f57d290-4c23-407f-9a7c-c5b53e7','{}','Heat stack user project',1,'0e9e03d9fc1648479517a37f05154c53','0e9e03d9fc1648479517a37f05154c53',0),('default','Default','{}','The default domain',1,'<<keystone.domain.root>>',NULL,1),('f7020fd3c081421c88901c71e9adb82b','277df2fcdf24400b85eca72ae3be1c9c-eede8308-afc1-45ef-b05b-7d9d5c7','{}','Heat stack user project',1,'0e9e03d9fc1648479517a37f05154c53','0e9e03d9fc1648479517a37f05154c53',0);
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint`
--

DROP TABLE IF EXISTS `project_endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint` (
  `endpoint_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint`
--

LOCK TABLES `project_endpoint` WRITE;
/*!40000 ALTER TABLE `project_endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint_group`
--

DROP TABLE IF EXISTS `project_endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint_group` (
  `endpoint_group_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_group_id`,`project_id`),
  CONSTRAINT `project_endpoint_group_ibfk_1` FOREIGN KEY (`endpoint_group_id`) REFERENCES `endpoint_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint_group`
--

LOCK TABLES `project_endpoint_group` WRITE;
/*!40000 ALTER TABLE `project_endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_option`
--

DROP TABLE IF EXISTS `project_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_option` (
  `project_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`project_id`,`option_id`),
  CONSTRAINT `project_option_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_option`
--

LOCK TABLES `project_option` WRITE;
/*!40000 ALTER TABLE `project_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_tag`
--

DROP TABLE IF EXISTS `project_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_tag` (
  `project_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`project_id`,`name`),
  UNIQUE KEY `project_id` (`project_id`,`name`),
  CONSTRAINT `project_tag_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_tag`
--

LOCK TABLES `project_tag` WRITE;
/*!40000 ALTER TABLE `project_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `parent_region_id` varchar(255) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` (`id`, `description`, `parent_region_id`, `extra`) VALUES ('regionOne','',NULL,'{}');
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registered_limit`
--

DROP TABLE IF EXISTS `registered_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `registered_limit` (
  `id` varchar(64) NOT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `default_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `registered_limit_id_key` (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `registered_limit`
--

LOCK TABLES `registered_limit` WRITE;
/*!40000 ALTER TABLE `registered_limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `registered_limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_token`
--

DROP TABLE IF EXISTS `request_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_token` (
  `id` varchar(64) NOT NULL,
  `request_secret` varchar(64) NOT NULL,
  `verifier` varchar(64) DEFAULT NULL,
  `authorizing_user_id` varchar(64) DEFAULT NULL,
  `requested_project_id` varchar(64) NOT NULL,
  `role_ids` text DEFAULT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_request_token_consumer_id` (`consumer_id`),
  CONSTRAINT `request_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_token`
--

LOCK TABLES `request_token` WRITE;
/*!40000 ALTER TABLE `request_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revocation_event`
--

DROP TABLE IF EXISTS `revocation_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revocation_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` varchar(64) DEFAULT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  `role_id` varchar(64) DEFAULT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `consumer_id` varchar(64) DEFAULT NULL,
  `access_token_id` varchar(64) DEFAULT NULL,
  `issued_before` datetime NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `revoked_at` datetime NOT NULL,
  `audit_id` varchar(32) DEFAULT NULL,
  `audit_chain_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_revocation_event_audit_id_issued_before` (`audit_id`,`issued_before`),
  KEY `ix_revocation_event_new_revoked_at` (`revoked_at`),
  KEY `ix_revocation_event_issued_before` (`issued_before`),
  KEY `ix_revocation_event_project_id_issued_before` (`project_id`,`issued_before`),
  KEY `ix_revocation_event_user_id_issued_before` (`user_id`,`issued_before`)
) ENGINE=InnoDB AUTO_INCREMENT=163 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revocation_event`
--

LOCK TABLES `revocation_event` WRITE;
/*!40000 ALTER TABLE `revocation_event` DISABLE KEYS */;
INSERT INTO `revocation_event` (`id`, `domain_id`, `project_id`, `user_id`, `role_id`, `trust_id`, `consumer_id`, `access_token_id`, `issued_before`, `expires_at`, `revoked_at`, `audit_id`, `audit_chain_id`) VALUES (1,NULL,NULL,NULL,NULL,'ecb10211f75b436eb79e898d1a2f6fea',NULL,NULL,'2025-11-29 07:56:42',NULL,'2025-11-29 07:56:42',NULL,NULL),(2,NULL,'25e7c895f94a4d97b723cc5f19a5209a',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:56:42',NULL,'2025-11-29 07:56:42',NULL,NULL),(3,NULL,NULL,NULL,NULL,'cfbe8950e0ee45989aa45acdd96a0cf8',NULL,NULL,'2025-11-29 07:56:43',NULL,'2025-11-29 07:56:43',NULL,NULL),(4,NULL,'541128ec90ad4ca4a90f32c3a170c9c0',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:56:44',NULL,'2025-11-29 07:56:44',NULL,NULL),(5,NULL,NULL,NULL,NULL,'24f138865e3447d48fd653eda9d9243a',NULL,NULL,'2025-11-29 07:56:47',NULL,'2025-11-29 07:56:47',NULL,NULL),(6,NULL,'960620abbf5544be93e39a44cf1aca42',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:56:47',NULL,'2025-11-29 07:56:47',NULL,NULL),(7,NULL,NULL,NULL,NULL,'99d39bef535a4a76a3885aefb7cbf948',NULL,NULL,'2025-11-29 07:56:48',NULL,'2025-11-29 07:56:48',NULL,NULL),(8,NULL,NULL,NULL,NULL,'4358b81c0b0f4e75b3906f110e79b0fa',NULL,NULL,'2025-11-29 07:56:49',NULL,'2025-11-29 07:56:49',NULL,NULL),(9,NULL,'a1751a14d13f43009a39700e32bd8107',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:56:49',NULL,'2025-11-29 07:56:49',NULL,NULL),(10,NULL,'52e88103f0314019a47e61ac5e861aea',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:56:49',NULL,'2025-11-29 07:56:49',NULL,NULL),(11,NULL,NULL,NULL,NULL,'9b43323b49e24fb882087c347ec0e13b',NULL,NULL,'2025-11-29 07:56:51',NULL,'2025-11-29 07:56:51',NULL,NULL),(12,NULL,'e66b5efb238b4cfeb3b752e67b402b5d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:56:52',NULL,'2025-11-29 07:56:52',NULL,NULL),(13,NULL,NULL,NULL,NULL,'56b361c6e3544fcb862bc05e29601e40',NULL,NULL,'2025-11-29 07:56:59',NULL,'2025-11-29 07:56:59',NULL,NULL),(14,NULL,'d1c32807f2d64f92a0eee1322a5de313',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:56:59',NULL,'2025-11-29 07:56:59',NULL,NULL),(15,NULL,NULL,NULL,NULL,'82403420ef7649988271a20ab60d8072',NULL,NULL,'2025-11-29 07:57:10',NULL,'2025-11-29 07:57:10',NULL,NULL),(16,NULL,'da316c300f2045a78baeed0d835ea6c8',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:11',NULL,'2025-11-29 07:57:11',NULL,NULL),(17,NULL,NULL,NULL,NULL,'90894d3e5740478ab17ce798f0490115',NULL,NULL,'2025-11-29 07:57:21',NULL,'2025-11-29 07:57:21',NULL,NULL),(18,NULL,'b949dc8ec0c746d7b7e6a6153903e21a',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:22',NULL,'2025-11-29 07:57:22',NULL,NULL),(19,NULL,NULL,NULL,NULL,'5a7faace6cdc4b6da8ab771bca3cd478',NULL,NULL,'2025-11-29 07:57:34',NULL,'2025-11-29 07:57:34',NULL,NULL),(20,NULL,'b785e68e409c40b8b956ead8b56b9687',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:34',NULL,'2025-11-29 07:57:34',NULL,NULL),(21,NULL,NULL,NULL,NULL,'a95ba3eb498941498da8455ba258f0ff',NULL,NULL,'2025-11-29 07:57:43',NULL,'2025-11-29 07:57:43',NULL,NULL),(22,NULL,'8e28f9bcd28d4ddea77c77c96655a2dc',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:44',NULL,'2025-11-29 07:57:44',NULL,NULL),(23,NULL,NULL,NULL,NULL,'81ad00c85cef4dc389f1e324bd014325',NULL,NULL,'2025-11-29 07:57:49',NULL,'2025-11-29 07:57:49',NULL,NULL),(24,NULL,'9e3bff820af543dfaae77727d7e9d8a6',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:50',NULL,'2025-11-29 07:57:50',NULL,NULL),(25,NULL,NULL,NULL,NULL,'fad9c6a02e5d47f5b704116ee6c02f15',NULL,NULL,'2025-11-29 07:57:57',NULL,'2025-11-29 07:57:57',NULL,NULL),(26,NULL,'3677cc7bb0da4cea9f3203df0d2131eb',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:58',NULL,'2025-11-29 07:57:58',NULL,NULL),(27,NULL,NULL,NULL,NULL,'78b252ab1b444d5f94a72d85c5db7485',NULL,NULL,'2025-11-29 07:58:05',NULL,'2025-11-29 07:58:05',NULL,NULL),(28,NULL,'c617be683c934208a2d6a4be2560bd32',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:58:06',NULL,'2025-11-29 07:58:06',NULL,NULL),(29,NULL,NULL,NULL,NULL,'3de3cc94a1674f04bcbc0154a858d3b8',NULL,NULL,'2025-11-29 07:58:07',NULL,'2025-11-29 07:58:07',NULL,NULL),(30,NULL,'b6ab5ac0f8584db3b28588c6699dbb66',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:58:07',NULL,'2025-11-29 07:58:07',NULL,NULL),(31,NULL,NULL,NULL,NULL,'05003cc87f9b473b80fb78b2232ebc71',NULL,NULL,'2025-11-29 07:58:48',NULL,'2025-11-29 07:58:48',NULL,NULL),(32,NULL,'94e29764bd274791972c2cbb988a351e',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:58:49',NULL,'2025-11-29 07:58:49',NULL,NULL),(33,NULL,NULL,NULL,NULL,'c67ae499580947e186845285639b2e88',NULL,NULL,'2025-11-29 07:58:50',NULL,'2025-11-29 07:58:50',NULL,NULL),(34,NULL,'e2961fa6cecd48e3aac8ab86662ff0bc',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:58:51',NULL,'2025-11-29 07:58:51',NULL,NULL),(35,NULL,NULL,NULL,NULL,'f37cd683368c486c8cbbf1595db7adec',NULL,NULL,'2025-11-29 07:59:03',NULL,'2025-11-29 07:59:03',NULL,NULL),(36,NULL,'65eaf2a07d0545d2a3d78578c98f310c',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:59:04',NULL,'2025-11-29 07:59:04',NULL,NULL),(37,NULL,NULL,NULL,NULL,'d53fcfaf9e9445e48a6fa96fc1f20592',NULL,NULL,'2025-11-29 07:59:07',NULL,'2025-11-29 07:59:07',NULL,NULL),(38,NULL,'491e1041838249f18cdd712bb4531c62',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:59:07',NULL,'2025-11-29 07:59:07',NULL,NULL),(39,NULL,NULL,NULL,NULL,'23d92f991ceb47cb8a32cf99c237cd8c',NULL,NULL,'2025-11-29 07:59:12',NULL,'2025-11-29 07:59:12',NULL,NULL),(40,NULL,'ddf18766058c447fadf098ebe4c07bef',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:59:12',NULL,'2025-11-29 07:59:12',NULL,NULL),(41,NULL,NULL,NULL,NULL,'891c11a035be475aabef7c9155df7c77',NULL,NULL,'2025-11-29 07:59:38',NULL,'2025-11-29 07:59:38',NULL,NULL),(42,NULL,'f62e9d5aac114065ac87a65d59bc2eba',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:59:39',NULL,'2025-11-29 07:59:39',NULL,NULL),(43,NULL,NULL,NULL,NULL,'a12b0b4a799942d28cf23c281ff21432',NULL,NULL,'2025-11-29 07:59:51',NULL,'2025-11-29 07:59:51',NULL,NULL),(44,NULL,'cdc7c157e23740f39ca49a431e4c6191',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:59:51',NULL,'2025-11-29 07:59:51',NULL,NULL),(45,NULL,NULL,NULL,NULL,'2288f320545449bf919ddabce4cb9768',NULL,NULL,'2025-11-29 07:59:52',NULL,'2025-11-29 07:59:52',NULL,NULL),(46,NULL,'e24b7ec0e14c447cbcd4c33234923bcb',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:59:52',NULL,'2025-11-29 07:59:52',NULL,NULL),(47,NULL,NULL,NULL,NULL,'a3f4bfd096d547e1b3423adf036e9d44',NULL,NULL,'2025-11-29 07:59:56',NULL,'2025-11-29 07:59:56',NULL,NULL),(48,NULL,'b49c806a50974eb8917449ba2005ef6d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:59:57',NULL,'2025-11-29 07:59:57',NULL,NULL),(49,NULL,NULL,NULL,NULL,'0fdf8d7354114c418c34cb06db406f66',NULL,NULL,'2025-11-29 08:00:02',NULL,'2025-11-29 08:00:02',NULL,NULL),(50,NULL,'c3d43bf2b52f4ee7bdb0e91f61820cc3',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:00:03',NULL,'2025-11-29 08:00:03',NULL,NULL),(51,NULL,NULL,NULL,NULL,'9278e230a4cc4f36aadb00e715ccf40f',NULL,NULL,'2025-11-29 08:00:06',NULL,'2025-11-29 08:00:06',NULL,NULL),(52,NULL,'9f1fa83d59f24ef592395a4330be5a3b',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:00:06',NULL,'2025-11-29 08:00:06',NULL,NULL),(53,NULL,NULL,NULL,NULL,'a4661acba76a4dde81a6bce69756aa2e',NULL,NULL,'2025-11-29 08:00:14',NULL,'2025-11-29 08:00:14',NULL,NULL),(54,NULL,'12f9cde71ec440faa2314abc0a23a7bf',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:00:14',NULL,'2025-11-29 08:00:14',NULL,NULL),(55,NULL,NULL,NULL,NULL,'c4611d30f7654ab6863b91f03a7caf51',NULL,NULL,'2025-11-29 08:00:19',NULL,'2025-11-29 08:00:19',NULL,NULL),(56,NULL,'ef678f085f8c42ba8acdb51adeaf9b38',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:00:20',NULL,'2025-11-29 08:00:20',NULL,NULL),(57,NULL,NULL,NULL,NULL,'c904eab13f0d4c1b8d8a27e88b4d3ea7',NULL,NULL,'2025-11-29 08:00:25',NULL,'2025-11-29 08:00:25',NULL,NULL),(58,NULL,'770c390acd474c2091a746ff51681c37',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:00:25',NULL,'2025-11-29 08:00:25',NULL,NULL),(59,NULL,NULL,NULL,NULL,'551c5210d834476aa8e4713bd2e83f5b',NULL,NULL,'2025-11-29 08:00:27',NULL,'2025-11-29 08:00:27',NULL,NULL),(60,NULL,'bd3871ba16a946c6ab0e4ffbe72160fc',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:00:27',NULL,'2025-11-29 08:00:27',NULL,NULL),(61,NULL,NULL,NULL,NULL,'9d3405c00f734e328b7ea268a9563e5a',NULL,NULL,'2025-11-29 08:00:35',NULL,'2025-11-29 08:00:35',NULL,NULL),(62,NULL,NULL,NULL,NULL,'b28a01ab13334d6697e1b063e62303b9',NULL,NULL,'2025-11-29 08:00:35',NULL,'2025-11-29 08:00:35',NULL,NULL),(63,NULL,'b1e7f0065a934e908c0f3c6a785d6133',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:00:35',NULL,'2025-11-29 08:00:35',NULL,NULL),(64,NULL,'117278cc64ef43f7baf02fc37e9f8a45',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:00:36',NULL,'2025-11-29 08:00:36',NULL,NULL),(65,NULL,NULL,NULL,NULL,'cb197506905643639bbb7c0115ff738c',NULL,NULL,'2025-11-29 08:00:37',NULL,'2025-11-29 08:00:37',NULL,NULL),(66,NULL,'a5eee3bca36e46ee86f37bf5757002dd',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:00:37',NULL,'2025-11-29 08:00:37',NULL,NULL),(67,NULL,NULL,NULL,NULL,'e39ff8a3f9794b88ab205981763304bf',NULL,NULL,'2025-11-29 08:00:51',NULL,'2025-11-29 08:00:51',NULL,NULL),(68,NULL,'1a704f689c1646a38020226f258a3abb',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:00:52',NULL,'2025-11-29 08:00:52',NULL,NULL),(69,NULL,NULL,NULL,NULL,'d53bc645d26c4faea547e3c12ba42ddf',NULL,NULL,'2025-11-29 08:01:01',NULL,'2025-11-29 08:01:01',NULL,NULL),(70,NULL,'eb4a727af50e4cb48d0319d048820f2c',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:01:02',NULL,'2025-11-29 08:01:02',NULL,NULL),(71,NULL,NULL,NULL,NULL,'a7a99c537e0e44658f73d369cf63c653',NULL,NULL,'2025-11-29 08:01:04',NULL,'2025-11-29 08:01:04',NULL,NULL),(72,NULL,NULL,NULL,NULL,'792f9f6ae4184d348d46af4e7395c538',NULL,NULL,'2025-11-29 08:01:04',NULL,'2025-11-29 08:01:04',NULL,NULL),(73,NULL,'1c125efd60cb4576a52bb8efdcc02ff5',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:01:04',NULL,'2025-11-29 08:01:04',NULL,NULL),(74,NULL,'871aed30b58d4500ac1475182bbbf480',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:01:04',NULL,'2025-11-29 08:01:04',NULL,NULL),(75,NULL,NULL,NULL,NULL,'c88c74a524c047c89b1a2276ae858564',NULL,NULL,'2025-11-29 08:01:21',NULL,'2025-11-29 08:01:21',NULL,NULL),(76,NULL,'ac8bb195086248e3a7f585b4d64f14e1',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:01:22',NULL,'2025-11-29 08:01:22',NULL,NULL),(77,NULL,NULL,NULL,NULL,'6c5155cd06ac40c3bb81f0aa084e3791',NULL,NULL,'2025-11-29 08:01:29',NULL,'2025-11-29 08:01:29',NULL,NULL),(78,NULL,'beb5a4335c40479c8c7aaab6246dee25',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:01:29',NULL,'2025-11-29 08:01:29',NULL,NULL),(79,NULL,NULL,NULL,NULL,'ca413b7ef2a04aa89f89b0986c5e70a6',NULL,NULL,'2025-11-29 08:01:43',NULL,'2025-11-29 08:01:43',NULL,NULL),(80,NULL,'9323c04754cc49538f5fea474c64826a',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:01:44',NULL,'2025-11-29 08:01:44',NULL,NULL),(81,NULL,NULL,NULL,NULL,'de1ae28686a947b68b1d512529e945d5',NULL,NULL,'2025-11-29 08:01:44',NULL,'2025-11-29 08:01:44',NULL,NULL),(82,NULL,'a9723c2a4bf74b62bc19e66dc9877a5d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:01:45',NULL,'2025-11-29 08:01:45',NULL,NULL),(83,NULL,NULL,NULL,NULL,'712eb92815c54da3a8b0827fc7ebd20f',NULL,NULL,'2025-11-29 08:01:49',NULL,'2025-11-29 08:01:49',NULL,NULL),(84,NULL,'bf962faf8dd041108d3ab9ca65e207d7',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:01:50',NULL,'2025-11-29 08:01:50',NULL,NULL),(85,NULL,NULL,NULL,NULL,'3fa46dd700ab4e31be715fb08af930eb',NULL,NULL,'2025-11-29 08:02:03',NULL,'2025-11-29 08:02:03',NULL,NULL),(86,NULL,'0afdb1e469c94cd6bd71095724ff439d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:02:03',NULL,'2025-11-29 08:02:03',NULL,NULL),(87,NULL,NULL,NULL,NULL,'612f5fed48674f119b3f544dcfc7e13e',NULL,NULL,'2025-11-29 08:02:09',NULL,'2025-11-29 08:02:09',NULL,NULL),(88,NULL,'f00affffa6664dd68c62ef22c17cd4eb',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:02:10',NULL,'2025-11-29 08:02:10',NULL,NULL),(89,NULL,NULL,NULL,NULL,'c1125340a60d4931ae84bc3c76de023d',NULL,NULL,'2025-11-29 08:02:14',NULL,'2025-11-29 08:02:14',NULL,NULL),(90,NULL,'4320e40f773f49e9a4c7dd3057d215b9',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:02:14',NULL,'2025-11-29 08:02:14',NULL,NULL),(91,NULL,NULL,NULL,NULL,'86422cf3283c4ac397f6b3a6f659caed',NULL,NULL,'2025-11-29 08:02:19',NULL,'2025-11-29 08:02:19',NULL,NULL),(92,NULL,'f693800b95d840ee9a231ed0ddef7d62',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:02:20',NULL,'2025-11-29 08:02:20',NULL,NULL),(93,NULL,NULL,NULL,NULL,'4c48bf08f48749b6bb7c934c1230cd4a',NULL,NULL,'2025-11-29 08:02:21',NULL,'2025-11-29 08:02:21',NULL,NULL),(94,NULL,'75ce9dd3b7ae4e809ccbddfae7e3d2e2',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:02:21',NULL,'2025-11-29 08:02:21',NULL,NULL),(95,NULL,NULL,NULL,NULL,'6064a10a1bf842b28714eedb3b00bf0c',NULL,NULL,'2025-11-29 08:02:25',NULL,'2025-11-29 08:02:25',NULL,NULL),(96,NULL,'9275e0b7dcb24f4aa5aabaf33759f243',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:02:26',NULL,'2025-11-29 08:02:26',NULL,NULL),(97,NULL,NULL,NULL,NULL,'3c3cc9e9112645939cd1b4a0bbe9e704',NULL,NULL,'2025-11-29 08:02:41',NULL,'2025-11-29 08:02:41',NULL,NULL),(98,NULL,'51a4a056ba384be58f40b9b7bd37a191',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:02:42',NULL,'2025-11-29 08:02:42',NULL,NULL),(99,NULL,NULL,NULL,NULL,'ac875ae37d50474b88e4a901db8f4227',NULL,NULL,'2025-11-29 08:02:55',NULL,'2025-11-29 08:02:55',NULL,NULL),(100,NULL,'89f8f14f6dd5488d919ec899a4f54d48',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:02:56',NULL,'2025-11-29 08:02:56',NULL,NULL),(101,NULL,NULL,NULL,NULL,'6393114ca6e843a2bc2aded1e1feaa2b',NULL,NULL,'2025-11-29 08:03:02',NULL,'2025-11-29 08:03:02',NULL,NULL),(102,NULL,'5ba37e82e34f4c6990a2d0fe9483945d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:03:03',NULL,'2025-11-29 08:03:03',NULL,NULL),(103,NULL,NULL,NULL,NULL,'8383c7b37463491c85ab8fac7971a4c7',NULL,NULL,'2025-11-29 08:03:07',NULL,'2025-11-29 08:03:07',NULL,NULL),(104,NULL,'e56a96f0fdbc40a487b54b326cc9ad63',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:03:08',NULL,'2025-11-29 08:03:08',NULL,NULL),(105,NULL,NULL,NULL,NULL,'a19cc04b2b804186aedb7865b8273f25',NULL,NULL,'2025-11-29 08:03:26',NULL,'2025-11-29 08:03:26',NULL,NULL),(106,NULL,'a740d74d4ce44946b984b377a32dc4a1',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:03:27',NULL,'2025-11-29 08:03:27',NULL,NULL),(107,NULL,NULL,NULL,NULL,'47edc5e58e4641c8b1df8e618bfa5e00',NULL,NULL,'2025-11-29 08:03:45',NULL,'2025-11-29 08:03:45',NULL,NULL),(108,NULL,'3adb1789520b4073bc4f4ba9681408b9',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:03:46',NULL,'2025-11-29 08:03:46',NULL,NULL),(109,NULL,NULL,NULL,NULL,'2cfa87d3f97f4589ba4abcea080b38d7',NULL,NULL,'2025-11-29 08:03:48',NULL,'2025-11-29 08:03:48',NULL,NULL),(110,NULL,'2051a886614c4f5597fefcc9a0a542d0',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:03:49',NULL,'2025-11-29 08:03:49',NULL,NULL),(111,NULL,NULL,NULL,NULL,'91f9902bc14e4c57aa92ab096809eea3',NULL,NULL,'2025-11-29 08:04:22',NULL,'2025-11-29 08:04:22',NULL,NULL),(112,NULL,NULL,NULL,NULL,'fb20fb5d4c3c4534861a2678ad1a48a6',NULL,NULL,'2025-11-29 08:04:23',NULL,'2025-11-29 08:04:23',NULL,NULL),(113,NULL,'89e4f43b067844afb0d08f0863cf5800',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:04:23',NULL,'2025-11-29 08:04:23',NULL,NULL),(114,NULL,'3ab438fceb924f53a23750709733174c',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:04:23',NULL,'2025-11-29 08:04:23',NULL,NULL),(115,NULL,NULL,'1ec6157245054ea2972055c4c516957a',NULL,NULL,NULL,NULL,'2025-11-29 08:04:26',NULL,'2025-11-29 08:04:26',NULL,NULL),(116,NULL,NULL,'274b976b796c43279e45aa111b4f8f01',NULL,NULL,NULL,NULL,'2025-11-29 08:04:27',NULL,'2025-11-29 08:04:27',NULL,NULL),(117,NULL,NULL,'ace212d1b33949a8bd88e17f39a9e36b',NULL,NULL,NULL,NULL,'2025-11-29 08:04:28',NULL,'2025-11-29 08:04:28',NULL,NULL),(118,NULL,NULL,NULL,NULL,'7c3a77c4c4cd476c838861dee3706e31',NULL,NULL,'2025-11-29 08:04:29',NULL,'2025-11-29 08:04:29',NULL,NULL),(119,NULL,'c353808380d3412db6e87d5a5fd7926c',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:04:29',NULL,'2025-11-29 08:04:29',NULL,NULL),(120,NULL,NULL,'4a403a08070c497ea80df5102e4ba025',NULL,NULL,NULL,NULL,'2025-11-29 08:04:36',NULL,'2025-11-29 08:04:36',NULL,NULL),(121,NULL,NULL,'d9a80f2cd3594e6a964e0e011615d167',NULL,NULL,NULL,NULL,'2025-11-29 08:04:37',NULL,'2025-11-29 08:04:37',NULL,NULL),(122,NULL,NULL,'d7d8b13bb91143eba9981908497cae5c',NULL,NULL,NULL,NULL,'2025-11-29 08:04:37',NULL,'2025-11-29 08:04:37',NULL,NULL),(123,NULL,NULL,NULL,NULL,'ca7054fe7c57446eab28038750677a6c',NULL,NULL,'2025-11-29 08:04:38',NULL,'2025-11-29 08:04:38',NULL,NULL),(124,NULL,'db4fe81c16bd48fe8a478fcb25766918',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:04:38',NULL,'2025-11-29 08:04:38',NULL,NULL),(125,NULL,NULL,NULL,NULL,'880a42d2e8c1423ead3574cb4163ff5a',NULL,NULL,'2025-11-29 08:04:41',NULL,'2025-11-29 08:04:41',NULL,NULL),(126,NULL,NULL,NULL,NULL,'19331c17f8ff4fdbaae2591f6b70a61c',NULL,NULL,'2025-11-29 08:04:41',NULL,'2025-11-29 08:04:41',NULL,NULL),(127,NULL,'a896f8f2b6174b37ad2d3d23e0b2b045',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:04:41',NULL,'2025-11-29 08:04:41',NULL,NULL),(128,NULL,'a4981bc073f44a53b9395d2fa39113d8',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:04:41',NULL,'2025-11-29 08:04:41',NULL,NULL),(129,NULL,NULL,'ee19eb08b15a4624a9d1a3ecda1321f9',NULL,NULL,NULL,NULL,'2025-11-29 08:04:44',NULL,'2025-11-29 08:04:44',NULL,NULL),(130,NULL,NULL,'cb1d433efda9475f88429601105dd348',NULL,NULL,NULL,NULL,'2025-11-29 08:04:45',NULL,'2025-11-29 08:04:45',NULL,NULL),(131,NULL,NULL,'7fc8d042a3944e038277cfa5a5410ee0',NULL,NULL,NULL,NULL,'2025-11-29 08:04:46',NULL,'2025-11-29 08:04:46',NULL,NULL),(132,NULL,NULL,NULL,NULL,'3bf172932f704623b2fca5f68e05ab85',NULL,NULL,'2025-11-29 08:04:48',NULL,'2025-11-29 08:04:48',NULL,NULL),(133,NULL,'f63faf9f7c88450a938a9d17285e3bc3',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:04:49',NULL,'2025-11-29 08:04:49',NULL,NULL),(134,NULL,NULL,'59415fb1f0ff498b9ee154401637b8c1',NULL,NULL,NULL,NULL,'2025-11-29 08:04:55',NULL,'2025-11-29 08:04:55',NULL,NULL),(135,NULL,NULL,'755c6f028ce8477ba51cdd2b0a3111ff',NULL,NULL,NULL,NULL,'2025-11-29 08:04:55',NULL,'2025-11-29 08:04:55',NULL,NULL),(136,NULL,NULL,'957a0c3de6444e32aaf3140792e75025',NULL,NULL,NULL,NULL,'2025-11-29 08:04:56',NULL,'2025-11-29 08:04:56',NULL,NULL),(137,NULL,NULL,'ada9615c63ef413f9e2b174f80002f7f',NULL,NULL,NULL,NULL,'2025-11-29 08:04:57',NULL,'2025-11-29 08:04:57',NULL,NULL),(138,NULL,NULL,'1e71302a411345ddba7abe16981f7012',NULL,NULL,NULL,NULL,'2025-11-29 08:04:59',NULL,'2025-11-29 08:04:59',NULL,NULL),(139,NULL,NULL,NULL,NULL,'8ce5d6a0bcd1498a86fc347a0a0af79b',NULL,NULL,'2025-11-29 08:05:02',NULL,'2025-11-29 08:05:02',NULL,NULL),(140,NULL,'e2fe8e5837f042c28444dcc0d31179ab',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:05:03',NULL,'2025-11-29 08:05:03',NULL,NULL),(141,NULL,NULL,'d34c325ff031477298486bd3937ca808',NULL,NULL,NULL,NULL,'2025-11-29 08:05:09',NULL,'2025-11-29 08:05:09',NULL,NULL),(142,NULL,NULL,'428aabbb5e0b40d5ac1593f64d432f68',NULL,NULL,NULL,NULL,'2025-11-29 08:05:10',NULL,'2025-11-29 08:05:10',NULL,NULL),(143,NULL,NULL,'bcadd1a209c24afa81ab1c2380fc974d',NULL,NULL,NULL,NULL,'2025-11-29 08:05:10',NULL,'2025-11-29 08:05:10',NULL,NULL),(144,NULL,NULL,'ff3498d80e42431f8ccf4e2277fe8dd1',NULL,NULL,NULL,NULL,'2025-11-29 08:05:13',NULL,'2025-11-29 08:05:13',NULL,NULL),(145,NULL,NULL,'63d9f71fdefa454cba678957c4b42b07',NULL,NULL,NULL,NULL,'2025-11-29 08:05:14',NULL,'2025-11-29 08:05:14',NULL,NULL),(146,NULL,NULL,NULL,NULL,'2ca9e63dda2d439f91e61a172db3e4a8',NULL,NULL,'2025-11-29 08:05:15',NULL,'2025-11-29 08:05:15',NULL,NULL),(147,NULL,'395a42f54fe54d2ab61b3256d9a65313',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:05:16',NULL,'2025-11-29 08:05:16',NULL,NULL),(148,NULL,NULL,'ac0bff1c148c437d91f4d4e9c1a39b89',NULL,NULL,NULL,NULL,'2025-11-29 08:05:20',NULL,'2025-11-29 08:05:20',NULL,NULL),(149,NULL,NULL,NULL,NULL,'e58d821b667d40549c10a285574a05f5',NULL,NULL,'2025-11-29 08:05:23',NULL,'2025-11-29 08:05:23',NULL,NULL),(150,NULL,'e6c3f469894749bebb6cad8f40ef1902',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:05:23',NULL,'2025-11-29 08:05:23',NULL,NULL),(151,NULL,NULL,'d9d018471f944b02845a11bf7b3b7002',NULL,NULL,NULL,NULL,'2025-11-29 08:07:00',NULL,'2025-11-29 08:07:00',NULL,NULL),(152,NULL,NULL,'fc978f59d2c1476a90477dfc330c194f',NULL,NULL,NULL,NULL,'2025-11-29 08:07:01',NULL,'2025-11-29 08:07:01',NULL,NULL),(153,NULL,NULL,'cf7c7b4b1619443a84e8aebb0861157c',NULL,NULL,NULL,NULL,'2025-11-29 08:07:01',NULL,'2025-11-29 08:07:01',NULL,NULL),(154,NULL,NULL,NULL,NULL,'1770fa9629ac4794a10ee29b37255422',NULL,NULL,'2025-11-29 08:07:05',NULL,'2025-11-29 08:07:05',NULL,NULL),(155,NULL,'8b7ed15532cc468b84161bd31c07e543',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:07:05',NULL,'2025-11-29 08:07:05',NULL,NULL),(156,NULL,NULL,'5d4b4262121745a1a3b3a97481d4d750',NULL,NULL,NULL,NULL,'2025-11-29 08:07:13',NULL,'2025-11-29 08:07:13',NULL,NULL),(157,NULL,NULL,NULL,NULL,'a429517da9324cfa9676080580340e07',NULL,NULL,'2025-11-29 08:07:17',NULL,'2025-11-29 08:07:17',NULL,NULL),(158,NULL,'96e1a3fac40d473fbbb7fc7eb9086301',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:07:18',NULL,'2025-11-29 08:07:18',NULL,NULL),(159,NULL,NULL,NULL,NULL,'f27c6ae5619f46049b2267988945663d',NULL,NULL,'2025-11-29 08:07:35',NULL,'2025-11-29 08:07:35',NULL,NULL),(160,NULL,'633a5a9f83c6445eb057905821e54d4c',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:07:35',NULL,'2025-11-29 08:07:35',NULL,NULL),(161,NULL,NULL,NULL,NULL,'16701929105e4732a5b505a09851d240',NULL,NULL,'2025-11-29 08:08:03',NULL,'2025-11-29 08:08:03',NULL,NULL),(162,NULL,'2be1e32cc2e04c8fa45bec3bed5d0c63',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:08:03',NULL,'2025-11-29 08:08:03',NULL,NULL);
/*!40000 ALTER TABLE `revocation_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL DEFAULT '<<null>>',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_role_name_domain_id` (`name`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` (`id`, `name`, `extra`, `domain_id`, `description`) VALUES ('0005a6ef80d04b6fa46027889779bbcf','service','{}','<<null>>',NULL),('0804a0ecba344075892956b3b0934975','swiftoperator','{}','<<null>>',NULL),('28a2590c5264485ba903b41e6c47f98d','SwiftProjectReader','{}','<<null>>',NULL),('6be8ecb0b47845acbd46383d77ae4a67','ResellerAdmin','{}','<<null>>',NULL),('73fafa84d4a64c7ab14dbbb918166e64','admin','{}','<<null>>',NULL),('783e0ca5346649b8a76f2a1c657ce4b2','member','{}','<<null>>',NULL),('8ce8d817c1624d849f075a0448bdb8fd','SwiftSystemReader','{}','<<null>>',NULL),('bfdecd7f60d14809ac54631e951e6984','heat_stack_user','{}','<<null>>',NULL),('f790e80eb1f5434f86e8988e2ef43d94','reader','{}','<<null>>',NULL);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_option`
--

DROP TABLE IF EXISTS `role_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_option` (
  `role_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`role_id`,`option_id`),
  CONSTRAINT `role_option_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_option`
--

LOCK TABLES `role_option` WRITE;
/*!40000 ALTER TABLE `role_option` DISABLE KEYS */;
INSERT INTO `role_option` (`role_id`, `option_id`, `option_value`) VALUES ('73fafa84d4a64c7ab14dbbb918166e64','IMMU','true'),('783e0ca5346649b8a76f2a1c657ce4b2','IMMU','true'),('f790e80eb1f5434f86e8988e2ef43d94','IMMU','true');
/*!40000 ALTER TABLE `role_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sensitive_config`
--

DROP TABLE IF EXISTS `sensitive_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sensitive_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sensitive_config`
--

LOCK TABLES `sensitive_config` WRITE;
/*!40000 ALTER TABLE `sensitive_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sensitive_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `type`, `enabled`, `extra`) VALUES ('11f97b0e51484cc19944335ecac43112','cloudformation',1,'{\"description\": \"Heat Cloudformation API service\", \"name\": \"heat-cfn\"}'),('140c96bff7da483a9f8b2d74ad4c89dc','network',1,'{\"description\": \"Openstack Networking\", \"name\": \"neutron\"}'),('169e8cfe0bff4ee59f6f790e1b299976','identity',1,'{\"name\": \"keystone\"}'),('1c91af5d2519477682edf9d7eba56425','compute',1,'{\"description\": \"Nova Compute Service\", \"name\": \"nova\"}'),('26b9c291e2354e9e89416d0ff82e412b','key-manager',1,'{\"description\": \"Barbican Service\", \"name\": \"barbican\"}'),('2eca9498d702470ab2f571123bcf6bac','orchestration',1,'{\"description\": \"Heat API service\", \"name\": \"heat\"}'),('3ae585af780c46de93b4e0b5b54fe2fc','placement',1,'{\"description\": \"Placement Service\", \"name\": \"placement\"}'),('61d26759eb88484eace8a93229a31b27','image',1,'{\"description\": \"Glance Service\", \"name\": \"glance\"}'),('89b9e3f16e0544f6ad95668f3cfa1c77','Ceilometer',1,'{\"description\": \"Ceilometer Service\", \"name\": \"ceilometer\"}'),('c87c2ac268cc470796b9700e7ea21c39','object-store',1,'{\"description\": \"Swift Object Storage\", \"name\": \"swift\"}'),('e1c6b459c589490b9c260acada6ec03b','volumev3',1,'{\"description\": \"Cinder V3 Service\", \"name\": \"cinderv3\"}');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_provider`
--

DROP TABLE IF EXISTS `service_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_provider` (
  `auth_url` varchar(256) NOT NULL,
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `sp_url` varchar(256) NOT NULL,
  `relay_state_prefix` varchar(256) NOT NULL DEFAULT 'ss:mem:',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_provider`
--

LOCK TABLES `service_provider` WRITE;
/*!40000 ALTER TABLE `service_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `service_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_assignment`
--

DROP TABLE IF EXISTS `system_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_assignment` (
  `type` varchar(64) NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_assignment`
--

LOCK TABLES `system_assignment` WRITE;
/*!40000 ALTER TABLE `system_assignment` DISABLE KEYS */;
INSERT INTO `system_assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserSystem','8494d41166dd44efacbacac961b18f97','system','73fafa84d4a64c7ab14dbbb918166e64',0);
/*!40000 ALTER TABLE `system_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `token`
--

DROP TABLE IF EXISTS `token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `token` (
  `id` varchar(64) NOT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_token_expires` (`expires`),
  KEY `ix_token_expires_valid` (`expires`,`valid`),
  KEY `ix_token_trust_id` (`trust_id`),
  KEY `ix_token_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `token`
--

LOCK TABLES `token` WRITE;
/*!40000 ALTER TABLE `token` DISABLE KEYS */;
/*!40000 ALTER TABLE `token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust`
--

DROP TABLE IF EXISTS `trust`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust` (
  `id` varchar(64) NOT NULL,
  `trustor_user_id` varchar(64) NOT NULL,
  `trustee_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `impersonation` tinyint(1) NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `remaining_uses` int(11) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `redelegated_trust_id` varchar(64) DEFAULT NULL,
  `redelegation_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `duplicate_trust_constraint_expanded` (`trustor_user_id`,`trustee_user_id`,`project_id`,`impersonation`,`expires_at`,`expires_at_int`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust`
--

LOCK TABLES `trust` WRITE;
/*!40000 ALTER TABLE `trust` DISABLE KEYS */;
INSERT INTO `trust` (`id`, `trustor_user_id`, `trustee_user_id`, `project_id`, `impersonation`, `deleted_at`, `expires_at`, `remaining_uses`, `extra`, `expires_at_int`, `redelegated_trust_id`, `redelegation_count`) VALUES ('137b4041add446c68da016efc1c9e016','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}, {\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}]}',NULL,NULL,0),('16701929105e4732a5b505a09851d240','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:08:03',NULL,NULL,'{\"roles\": [{\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}, {\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}]}',NULL,NULL,0),('1770fa9629ac4794a10ee29b37255422','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:07:05',NULL,NULL,'{\"roles\": [{\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}, {\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}]}',NULL,NULL,0),('19331c17f8ff4fdbaae2591f6b70a61c','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:04:41',NULL,NULL,'{\"roles\": [{\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}, {\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}]}',NULL,NULL,0),('2ca9e63dda2d439f91e61a172db3e4a8','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:05:15',NULL,NULL,'{\"roles\": [{\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}, {\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}]}',NULL,NULL,0),('2cfa87d3f97f4589ba4abcea080b38d7','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:03:47',NULL,NULL,'{\"roles\": [{\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}, {\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}]}',NULL,NULL,0),('3bf172932f704623b2fca5f68e05ab85','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:04:48',NULL,NULL,'{\"roles\": [{\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}, {\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}]}',NULL,NULL,0),('3c3cc9e9112645939cd1b4a0bbe9e704','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:02:41',NULL,NULL,'{\"roles\": [{\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}, {\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}]}',NULL,NULL,0),('3fa46dd700ab4e31be715fb08af930eb','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:02:03',NULL,NULL,'{\"roles\": [{\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}, {\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}]}',NULL,NULL,0),('47edc5e58e4641c8b1df8e618bfa5e00','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:03:45',NULL,NULL,'{\"roles\": [{\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}, {\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}]}',NULL,NULL,0),('4c48bf08f48749b6bb7c934c1230cd4a','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:02:21',NULL,NULL,'{\"roles\": [{\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}, {\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}]}',NULL,NULL,0),('6064a10a1bf842b28714eedb3b00bf0c','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:02:25',NULL,NULL,'{\"roles\": [{\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}, {\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}]}',NULL,NULL,0),('612f5fed48674f119b3f544dcfc7e13e','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:02:09',NULL,NULL,'{\"roles\": [{\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}, {\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}]}',NULL,NULL,0),('6393114ca6e843a2bc2aded1e1feaa2b','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:03:02',NULL,NULL,'{\"roles\": [{\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}, {\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}]}',NULL,NULL,0),('6c5155cd06ac40c3bb81f0aa084e3791','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:01:29',NULL,NULL,'{\"roles\": [{\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}, {\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}]}',NULL,NULL,0),('6c5a9e76248e48afaca1d2a52543d0b7','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}, {\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}]}',NULL,NULL,0),('6d620a6b3b8242039043611541981e76','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}, {\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}]}',NULL,NULL,0),('712eb92815c54da3a8b0827fc7ebd20f','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:01:49',NULL,NULL,'{\"roles\": [{\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}, {\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}]}',NULL,NULL,0),('792f9f6ae4184d348d46af4e7395c538','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:01:04',NULL,NULL,'{\"roles\": [{\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}, {\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}]}',NULL,NULL,0),('7c3a77c4c4cd476c838861dee3706e31','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:04:29',NULL,NULL,'{\"roles\": [{\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}, {\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}]}',NULL,NULL,0),('8383c7b37463491c85ab8fac7971a4c7','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:03:07',NULL,NULL,'{\"roles\": [{\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}, {\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}]}',NULL,NULL,0),('86422cf3283c4ac397f6b3a6f659caed','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:02:19',NULL,NULL,'{\"roles\": [{\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}, {\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}]}',NULL,NULL,0),('880a42d2e8c1423ead3574cb4163ff5a','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:04:41',NULL,NULL,'{\"roles\": [{\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}, {\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}]}',NULL,NULL,0),('8ce5d6a0bcd1498a86fc347a0a0af79b','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:05:02',NULL,NULL,'{\"roles\": [{\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}, {\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}]}',NULL,NULL,0),('8f5b11b651f341bb91e05ba72e16092f','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}, {\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}]}',NULL,NULL,0),('91f9902bc14e4c57aa92ab096809eea3','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:04:22',NULL,NULL,'{\"roles\": [{\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}, {\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}]}',NULL,NULL,0),('a03291d3436447f4902fc6d3d4b25e03','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}, {\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}]}',NULL,NULL,0),('a19cc04b2b804186aedb7865b8273f25','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:03:26',NULL,NULL,'{\"roles\": [{\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}, {\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}]}',NULL,NULL,0),('a429517da9324cfa9676080580340e07','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:07:17',NULL,NULL,'{\"roles\": [{\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}, {\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}]}',NULL,NULL,0),('ac875ae37d50474b88e4a901db8f4227','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:02:55',NULL,NULL,'{\"roles\": [{\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}, {\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}]}',NULL,NULL,0),('b6d338b1c15943d1b10f8f8d17f69d86','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}, {\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}]}',NULL,NULL,0),('c1125340a60d4931ae84bc3c76de023d','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:02:14',NULL,NULL,'{\"roles\": [{\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}, {\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}]}',NULL,NULL,0),('c88c74a524c047c89b1a2276ae858564','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:01:21',NULL,NULL,'{\"roles\": [{\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}, {\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}]}',NULL,NULL,0),('ca413b7ef2a04aa89f89b0986c5e70a6','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:01:43',NULL,NULL,'{\"roles\": [{\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}, {\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}]}',NULL,NULL,0),('ca7054fe7c57446eab28038750677a6c','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:04:38',NULL,NULL,'{\"roles\": [{\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}, {\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}]}',NULL,NULL,0),('db7472a696c6401c83f127c347578248','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}, {\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}]}',NULL,NULL,0),('de1ae28686a947b68b1d512529e945d5','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:01:44',NULL,NULL,'{\"roles\": [{\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}, {\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}]}',NULL,NULL,0),('e58d821b667d40549c10a285574a05f5','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:05:23',NULL,NULL,'{\"roles\": [{\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}, {\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}]}',NULL,NULL,0),('f27c6ae5619f46049b2267988945663d','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:07:35',NULL,NULL,'{\"roles\": [{\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}, {\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}]}',NULL,NULL,0),('fb20fb5d4c3c4534861a2678ad1a48a6','89037d9d7e65485d887783b84c589ed7','dae9de15a4ed4e4d9af31a9f998453f7','277df2fcdf24400b85eca72ae3be1c9c',1,'2025-11-29 08:04:23',NULL,NULL,'{\"roles\": [{\"id\": \"f790e80eb1f5434f86e8988e2ef43d94\"}, {\"id\": \"783e0ca5346649b8a76f2a1c657ce4b2\"}]}',NULL,NULL,0);
/*!40000 ALTER TABLE `trust` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust_role`
--

DROP TABLE IF EXISTS `trust_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust_role` (
  `trust_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`trust_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust_role`
--

LOCK TABLES `trust_role` WRITE;
/*!40000 ALTER TABLE `trust_role` DISABLE KEYS */;
INSERT INTO `trust_role` (`trust_id`, `role_id`) VALUES ('05003cc87f9b473b80fb78b2232ebc71','783e0ca5346649b8a76f2a1c657ce4b2'),('05003cc87f9b473b80fb78b2232ebc71','f790e80eb1f5434f86e8988e2ef43d94'),('0fdf8d7354114c418c34cb06db406f66','783e0ca5346649b8a76f2a1c657ce4b2'),('0fdf8d7354114c418c34cb06db406f66','f790e80eb1f5434f86e8988e2ef43d94'),('137b4041add446c68da016efc1c9e016','783e0ca5346649b8a76f2a1c657ce4b2'),('137b4041add446c68da016efc1c9e016','f790e80eb1f5434f86e8988e2ef43d94'),('16701929105e4732a5b505a09851d240','783e0ca5346649b8a76f2a1c657ce4b2'),('16701929105e4732a5b505a09851d240','f790e80eb1f5434f86e8988e2ef43d94'),('1770fa9629ac4794a10ee29b37255422','783e0ca5346649b8a76f2a1c657ce4b2'),('1770fa9629ac4794a10ee29b37255422','f790e80eb1f5434f86e8988e2ef43d94'),('19331c17f8ff4fdbaae2591f6b70a61c','783e0ca5346649b8a76f2a1c657ce4b2'),('19331c17f8ff4fdbaae2591f6b70a61c','f790e80eb1f5434f86e8988e2ef43d94'),('2288f320545449bf919ddabce4cb9768','783e0ca5346649b8a76f2a1c657ce4b2'),('2288f320545449bf919ddabce4cb9768','f790e80eb1f5434f86e8988e2ef43d94'),('23d92f991ceb47cb8a32cf99c237cd8c','783e0ca5346649b8a76f2a1c657ce4b2'),('23d92f991ceb47cb8a32cf99c237cd8c','f790e80eb1f5434f86e8988e2ef43d94'),('24f138865e3447d48fd653eda9d9243a','783e0ca5346649b8a76f2a1c657ce4b2'),('24f138865e3447d48fd653eda9d9243a','f790e80eb1f5434f86e8988e2ef43d94'),('2ca9e63dda2d439f91e61a172db3e4a8','783e0ca5346649b8a76f2a1c657ce4b2'),('2ca9e63dda2d439f91e61a172db3e4a8','f790e80eb1f5434f86e8988e2ef43d94'),('2cfa87d3f97f4589ba4abcea080b38d7','783e0ca5346649b8a76f2a1c657ce4b2'),('2cfa87d3f97f4589ba4abcea080b38d7','f790e80eb1f5434f86e8988e2ef43d94'),('3bf172932f704623b2fca5f68e05ab85','783e0ca5346649b8a76f2a1c657ce4b2'),('3bf172932f704623b2fca5f68e05ab85','f790e80eb1f5434f86e8988e2ef43d94'),('3c3cc9e9112645939cd1b4a0bbe9e704','783e0ca5346649b8a76f2a1c657ce4b2'),('3c3cc9e9112645939cd1b4a0bbe9e704','f790e80eb1f5434f86e8988e2ef43d94'),('3de3cc94a1674f04bcbc0154a858d3b8','783e0ca5346649b8a76f2a1c657ce4b2'),('3de3cc94a1674f04bcbc0154a858d3b8','f790e80eb1f5434f86e8988e2ef43d94'),('3fa46dd700ab4e31be715fb08af930eb','783e0ca5346649b8a76f2a1c657ce4b2'),('3fa46dd700ab4e31be715fb08af930eb','f790e80eb1f5434f86e8988e2ef43d94'),('4358b81c0b0f4e75b3906f110e79b0fa','783e0ca5346649b8a76f2a1c657ce4b2'),('4358b81c0b0f4e75b3906f110e79b0fa','f790e80eb1f5434f86e8988e2ef43d94'),('47edc5e58e4641c8b1df8e618bfa5e00','783e0ca5346649b8a76f2a1c657ce4b2'),('47edc5e58e4641c8b1df8e618bfa5e00','f790e80eb1f5434f86e8988e2ef43d94'),('4c48bf08f48749b6bb7c934c1230cd4a','783e0ca5346649b8a76f2a1c657ce4b2'),('4c48bf08f48749b6bb7c934c1230cd4a','f790e80eb1f5434f86e8988e2ef43d94'),('551c5210d834476aa8e4713bd2e83f5b','783e0ca5346649b8a76f2a1c657ce4b2'),('551c5210d834476aa8e4713bd2e83f5b','f790e80eb1f5434f86e8988e2ef43d94'),('56b361c6e3544fcb862bc05e29601e40','783e0ca5346649b8a76f2a1c657ce4b2'),('56b361c6e3544fcb862bc05e29601e40','f790e80eb1f5434f86e8988e2ef43d94'),('5a7faace6cdc4b6da8ab771bca3cd478','783e0ca5346649b8a76f2a1c657ce4b2'),('5a7faace6cdc4b6da8ab771bca3cd478','f790e80eb1f5434f86e8988e2ef43d94'),('6064a10a1bf842b28714eedb3b00bf0c','783e0ca5346649b8a76f2a1c657ce4b2'),('6064a10a1bf842b28714eedb3b00bf0c','f790e80eb1f5434f86e8988e2ef43d94'),('612f5fed48674f119b3f544dcfc7e13e','783e0ca5346649b8a76f2a1c657ce4b2'),('612f5fed48674f119b3f544dcfc7e13e','f790e80eb1f5434f86e8988e2ef43d94'),('6393114ca6e843a2bc2aded1e1feaa2b','783e0ca5346649b8a76f2a1c657ce4b2'),('6393114ca6e843a2bc2aded1e1feaa2b','f790e80eb1f5434f86e8988e2ef43d94'),('6c5155cd06ac40c3bb81f0aa084e3791','783e0ca5346649b8a76f2a1c657ce4b2'),('6c5155cd06ac40c3bb81f0aa084e3791','f790e80eb1f5434f86e8988e2ef43d94'),('6c5a9e76248e48afaca1d2a52543d0b7','783e0ca5346649b8a76f2a1c657ce4b2'),('6c5a9e76248e48afaca1d2a52543d0b7','f790e80eb1f5434f86e8988e2ef43d94'),('6d620a6b3b8242039043611541981e76','783e0ca5346649b8a76f2a1c657ce4b2'),('6d620a6b3b8242039043611541981e76','f790e80eb1f5434f86e8988e2ef43d94'),('712eb92815c54da3a8b0827fc7ebd20f','783e0ca5346649b8a76f2a1c657ce4b2'),('712eb92815c54da3a8b0827fc7ebd20f','f790e80eb1f5434f86e8988e2ef43d94'),('78b252ab1b444d5f94a72d85c5db7485','783e0ca5346649b8a76f2a1c657ce4b2'),('78b252ab1b444d5f94a72d85c5db7485','f790e80eb1f5434f86e8988e2ef43d94'),('792f9f6ae4184d348d46af4e7395c538','783e0ca5346649b8a76f2a1c657ce4b2'),('792f9f6ae4184d348d46af4e7395c538','f790e80eb1f5434f86e8988e2ef43d94'),('7c3a77c4c4cd476c838861dee3706e31','783e0ca5346649b8a76f2a1c657ce4b2'),('7c3a77c4c4cd476c838861dee3706e31','f790e80eb1f5434f86e8988e2ef43d94'),('81ad00c85cef4dc389f1e324bd014325','783e0ca5346649b8a76f2a1c657ce4b2'),('81ad00c85cef4dc389f1e324bd014325','f790e80eb1f5434f86e8988e2ef43d94'),('82403420ef7649988271a20ab60d8072','73fafa84d4a64c7ab14dbbb918166e64'),('82403420ef7649988271a20ab60d8072','783e0ca5346649b8a76f2a1c657ce4b2'),('82403420ef7649988271a20ab60d8072','f790e80eb1f5434f86e8988e2ef43d94'),('8383c7b37463491c85ab8fac7971a4c7','783e0ca5346649b8a76f2a1c657ce4b2'),('8383c7b37463491c85ab8fac7971a4c7','f790e80eb1f5434f86e8988e2ef43d94'),('86422cf3283c4ac397f6b3a6f659caed','783e0ca5346649b8a76f2a1c657ce4b2'),('86422cf3283c4ac397f6b3a6f659caed','f790e80eb1f5434f86e8988e2ef43d94'),('880a42d2e8c1423ead3574cb4163ff5a','783e0ca5346649b8a76f2a1c657ce4b2'),('880a42d2e8c1423ead3574cb4163ff5a','f790e80eb1f5434f86e8988e2ef43d94'),('891c11a035be475aabef7c9155df7c77','783e0ca5346649b8a76f2a1c657ce4b2'),('891c11a035be475aabef7c9155df7c77','f790e80eb1f5434f86e8988e2ef43d94'),('8ce5d6a0bcd1498a86fc347a0a0af79b','783e0ca5346649b8a76f2a1c657ce4b2'),('8ce5d6a0bcd1498a86fc347a0a0af79b','f790e80eb1f5434f86e8988e2ef43d94'),('8f5b11b651f341bb91e05ba72e16092f','783e0ca5346649b8a76f2a1c657ce4b2'),('8f5b11b651f341bb91e05ba72e16092f','f790e80eb1f5434f86e8988e2ef43d94'),('90894d3e5740478ab17ce798f0490115','783e0ca5346649b8a76f2a1c657ce4b2'),('90894d3e5740478ab17ce798f0490115','f790e80eb1f5434f86e8988e2ef43d94'),('91f9902bc14e4c57aa92ab096809eea3','783e0ca5346649b8a76f2a1c657ce4b2'),('91f9902bc14e4c57aa92ab096809eea3','f790e80eb1f5434f86e8988e2ef43d94'),('9278e230a4cc4f36aadb00e715ccf40f','783e0ca5346649b8a76f2a1c657ce4b2'),('9278e230a4cc4f36aadb00e715ccf40f','f790e80eb1f5434f86e8988e2ef43d94'),('99d39bef535a4a76a3885aefb7cbf948','783e0ca5346649b8a76f2a1c657ce4b2'),('99d39bef535a4a76a3885aefb7cbf948','f790e80eb1f5434f86e8988e2ef43d94'),('9b43323b49e24fb882087c347ec0e13b','783e0ca5346649b8a76f2a1c657ce4b2'),('9b43323b49e24fb882087c347ec0e13b','f790e80eb1f5434f86e8988e2ef43d94'),('9d3405c00f734e328b7ea268a9563e5a','783e0ca5346649b8a76f2a1c657ce4b2'),('9d3405c00f734e328b7ea268a9563e5a','f790e80eb1f5434f86e8988e2ef43d94'),('a03291d3436447f4902fc6d3d4b25e03','783e0ca5346649b8a76f2a1c657ce4b2'),('a03291d3436447f4902fc6d3d4b25e03','f790e80eb1f5434f86e8988e2ef43d94'),('a12b0b4a799942d28cf23c281ff21432','783e0ca5346649b8a76f2a1c657ce4b2'),('a12b0b4a799942d28cf23c281ff21432','f790e80eb1f5434f86e8988e2ef43d94'),('a19cc04b2b804186aedb7865b8273f25','783e0ca5346649b8a76f2a1c657ce4b2'),('a19cc04b2b804186aedb7865b8273f25','f790e80eb1f5434f86e8988e2ef43d94'),('a3f4bfd096d547e1b3423adf036e9d44','783e0ca5346649b8a76f2a1c657ce4b2'),('a3f4bfd096d547e1b3423adf036e9d44','f790e80eb1f5434f86e8988e2ef43d94'),('a429517da9324cfa9676080580340e07','783e0ca5346649b8a76f2a1c657ce4b2'),('a429517da9324cfa9676080580340e07','f790e80eb1f5434f86e8988e2ef43d94'),('a4661acba76a4dde81a6bce69756aa2e','783e0ca5346649b8a76f2a1c657ce4b2'),('a4661acba76a4dde81a6bce69756aa2e','f790e80eb1f5434f86e8988e2ef43d94'),('a7a99c537e0e44658f73d369cf63c653','783e0ca5346649b8a76f2a1c657ce4b2'),('a7a99c537e0e44658f73d369cf63c653','f790e80eb1f5434f86e8988e2ef43d94'),('a95ba3eb498941498da8455ba258f0ff','73fafa84d4a64c7ab14dbbb918166e64'),('a95ba3eb498941498da8455ba258f0ff','783e0ca5346649b8a76f2a1c657ce4b2'),('a95ba3eb498941498da8455ba258f0ff','f790e80eb1f5434f86e8988e2ef43d94'),('ac875ae37d50474b88e4a901db8f4227','783e0ca5346649b8a76f2a1c657ce4b2'),('ac875ae37d50474b88e4a901db8f4227','f790e80eb1f5434f86e8988e2ef43d94'),('b28a01ab13334d6697e1b063e62303b9','783e0ca5346649b8a76f2a1c657ce4b2'),('b28a01ab13334d6697e1b063e62303b9','f790e80eb1f5434f86e8988e2ef43d94'),('b6d338b1c15943d1b10f8f8d17f69d86','783e0ca5346649b8a76f2a1c657ce4b2'),('b6d338b1c15943d1b10f8f8d17f69d86','f790e80eb1f5434f86e8988e2ef43d94'),('c1125340a60d4931ae84bc3c76de023d','783e0ca5346649b8a76f2a1c657ce4b2'),('c1125340a60d4931ae84bc3c76de023d','f790e80eb1f5434f86e8988e2ef43d94'),('c4611d30f7654ab6863b91f03a7caf51','783e0ca5346649b8a76f2a1c657ce4b2'),('c4611d30f7654ab6863b91f03a7caf51','f790e80eb1f5434f86e8988e2ef43d94'),('c67ae499580947e186845285639b2e88','783e0ca5346649b8a76f2a1c657ce4b2'),('c67ae499580947e186845285639b2e88','f790e80eb1f5434f86e8988e2ef43d94'),('c88c74a524c047c89b1a2276ae858564','783e0ca5346649b8a76f2a1c657ce4b2'),('c88c74a524c047c89b1a2276ae858564','f790e80eb1f5434f86e8988e2ef43d94'),('c904eab13f0d4c1b8d8a27e88b4d3ea7','783e0ca5346649b8a76f2a1c657ce4b2'),('c904eab13f0d4c1b8d8a27e88b4d3ea7','f790e80eb1f5434f86e8988e2ef43d94'),('ca413b7ef2a04aa89f89b0986c5e70a6','783e0ca5346649b8a76f2a1c657ce4b2'),('ca413b7ef2a04aa89f89b0986c5e70a6','f790e80eb1f5434f86e8988e2ef43d94'),('ca7054fe7c57446eab28038750677a6c','783e0ca5346649b8a76f2a1c657ce4b2'),('ca7054fe7c57446eab28038750677a6c','f790e80eb1f5434f86e8988e2ef43d94'),('cb197506905643639bbb7c0115ff738c','783e0ca5346649b8a76f2a1c657ce4b2'),('cb197506905643639bbb7c0115ff738c','f790e80eb1f5434f86e8988e2ef43d94'),('cfbe8950e0ee45989aa45acdd96a0cf8','783e0ca5346649b8a76f2a1c657ce4b2'),('cfbe8950e0ee45989aa45acdd96a0cf8','f790e80eb1f5434f86e8988e2ef43d94'),('d53bc645d26c4faea547e3c12ba42ddf','783e0ca5346649b8a76f2a1c657ce4b2'),('d53bc645d26c4faea547e3c12ba42ddf','f790e80eb1f5434f86e8988e2ef43d94'),('d53fcfaf9e9445e48a6fa96fc1f20592','783e0ca5346649b8a76f2a1c657ce4b2'),('d53fcfaf9e9445e48a6fa96fc1f20592','f790e80eb1f5434f86e8988e2ef43d94'),('db7472a696c6401c83f127c347578248','783e0ca5346649b8a76f2a1c657ce4b2'),('db7472a696c6401c83f127c347578248','f790e80eb1f5434f86e8988e2ef43d94'),('de1ae28686a947b68b1d512529e945d5','783e0ca5346649b8a76f2a1c657ce4b2'),('de1ae28686a947b68b1d512529e945d5','f790e80eb1f5434f86e8988e2ef43d94'),('e39ff8a3f9794b88ab205981763304bf','783e0ca5346649b8a76f2a1c657ce4b2'),('e39ff8a3f9794b88ab205981763304bf','f790e80eb1f5434f86e8988e2ef43d94'),('e58d821b667d40549c10a285574a05f5','783e0ca5346649b8a76f2a1c657ce4b2'),('e58d821b667d40549c10a285574a05f5','f790e80eb1f5434f86e8988e2ef43d94'),('ecb10211f75b436eb79e898d1a2f6fea','783e0ca5346649b8a76f2a1c657ce4b2'),('ecb10211f75b436eb79e898d1a2f6fea','f790e80eb1f5434f86e8988e2ef43d94'),('f27c6ae5619f46049b2267988945663d','783e0ca5346649b8a76f2a1c657ce4b2'),('f27c6ae5619f46049b2267988945663d','f790e80eb1f5434f86e8988e2ef43d94'),('f37cd683368c486c8cbbf1595db7adec','783e0ca5346649b8a76f2a1c657ce4b2'),('f37cd683368c486c8cbbf1595db7adec','f790e80eb1f5434f86e8988e2ef43d94'),('fad9c6a02e5d47f5b704116ee6c02f15','783e0ca5346649b8a76f2a1c657ce4b2'),('fad9c6a02e5d47f5b704116ee6c02f15','f790e80eb1f5434f86e8988e2ef43d94'),('fb20fb5d4c3c4534861a2678ad1a48a6','783e0ca5346649b8a76f2a1c657ce4b2'),('fb20fb5d4c3c4534861a2678ad1a48a6','f790e80eb1f5434f86e8988e2ef43d94');
/*!40000 ALTER TABLE `trust_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `default_project_id` varchar(64) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_active_at` date DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_user_id_domain_id` (`id`,`domain_id`),
  KEY `ix_default_project_id` (`default_project_id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `extra`, `enabled`, `default_project_id`, `created_at`, `last_active_at`, `domain_id`) VALUES ('04a9d98013d04ae699c3065d87275a05','{}',1,'77fc494bab664d03873bd2631992e117','2025-11-29 07:25:43','2025-11-29','default'),('2872e0a2c27347ed8ca6bce93a367527','{}',1,NULL,'2025-11-29 07:25:15','2025-11-29','0e9e03d9fc1648479517a37f05154c53'),('565a100d281a4282a60ff8ff3cde3aa5','{}',1,'77fc494bab664d03873bd2631992e117','2025-11-29 07:25:02',NULL,'default'),('6480399a8f344eebac2e0fea958fe314','{}',1,'77fc494bab664d03873bd2631992e117','2025-11-29 07:25:23','2025-11-29','default'),('652182967968410ea0a193e13f857e23','{\"tenantId\": \"5ec669b41e544a1d9964ab3fcc79252d\", \"email\": \"alt_demo_tempestconf@test.com\"}',1,NULL,'2025-11-29 07:56:01',NULL,'default'),('8494d41166dd44efacbacac961b18f97','{}',1,NULL,'2025-11-29 07:23:17','2025-11-29','default'),('89037d9d7e65485d887783b84c589ed7','{\"tenantId\": \"277df2fcdf24400b85eca72ae3be1c9c\", \"email\": \"demo_tempestconf@test.com\"}',1,NULL,'2025-11-29 07:56:01','2025-11-29','default'),('9f244f4ac94847669842e5162d1f76c6','{}',1,'77fc494bab664d03873bd2631992e117','2025-11-29 07:26:30','2025-11-29','default'),('bddce9e6823d4a4b937c4bd533c36894','{}',1,'77fc494bab664d03873bd2631992e117','2025-11-29 07:26:04','2025-11-29','default'),('c5fc0aabf5c74e99b6c2fa74cb397344','{}',1,'77fc494bab664d03873bd2631992e117','2025-11-29 07:26:36','2025-11-29','default'),('ce5cf5c8bb8a472595a2e52809651c8c','{}',1,'77fc494bab664d03873bd2631992e117','2025-11-29 07:25:54','2025-11-29','default'),('d5a7dda43bec4971a33c7eeba5c0693f','{}',1,'77fc494bab664d03873bd2631992e117','2025-11-29 07:24:54','2025-11-29','default'),('dae9de15a4ed4e4d9af31a9f998453f7','{}',1,'77fc494bab664d03873bd2631992e117','2025-11-29 07:26:19','2025-11-29','default');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_group_membership`
--

DROP TABLE IF EXISTS `user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `fk_user_group_membership_group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `fk_user_group_membership_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_group_membership`
--

LOCK TABLES `user_group_membership` WRITE;
/*!40000 ALTER TABLE `user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_option`
--

DROP TABLE IF EXISTS `user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_option` (
  `user_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`user_id`,`option_id`),
  CONSTRAINT `user_option_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_option`
--

LOCK TABLES `user_option` WRITE;
/*!40000 ALTER TABLE `user_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whitelisted_config`
--

DROP TABLE IF EXISTS `whitelisted_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whitelisted_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whitelisted_config`
--

LOCK TABLES `whitelisted_config` WRITE;
/*!40000 ALTER TABLE `whitelisted_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `whitelisted_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `mysql`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `mysql` /*!40100 DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci */;

USE `mysql`;

--
-- Table structure for table `general_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `general_log` (
  `event_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `command_type` varchar(64) NOT NULL,
  `argument` mediumtext NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='General log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slow_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `slow_log` (
  `start_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `query_time` time(6) NOT NULL,
  `lock_time` time(6) NOT NULL,
  `rows_sent` bigint(20) unsigned NOT NULL,
  `rows_examined` bigint(20) unsigned NOT NULL,
  `db` varchar(512) NOT NULL,
  `last_insert_id` int(11) NOT NULL,
  `insert_id` int(11) NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `sql_text` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `rows_affected` bigint(20) unsigned NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Slow log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `column_stats`
--

DROP TABLE IF EXISTS `column_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `column_stats` (
  `db_name` varchar(64) NOT NULL,
  `table_name` varchar(64) NOT NULL,
  `column_name` varchar(64) NOT NULL,
  `min_value` varbinary(255) DEFAULT NULL,
  `max_value` varbinary(255) DEFAULT NULL,
  `nulls_ratio` decimal(12,4) DEFAULT NULL,
  `avg_length` decimal(12,4) DEFAULT NULL,
  `avg_frequency` decimal(12,4) DEFAULT NULL,
  `hist_size` tinyint(3) unsigned DEFAULT NULL,
  `hist_type` enum('SINGLE_PREC_HB','DOUBLE_PREC_HB') DEFAULT NULL,
  `histogram` varbinary(255) DEFAULT NULL,
  PRIMARY KEY (`db_name`,`table_name`,`column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='Statistics on Columns';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `column_stats`
--

LOCK TABLES `column_stats` WRITE;
/*!40000 ALTER TABLE `column_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `column_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `columns_priv`
--

DROP TABLE IF EXISTS `columns_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `columns_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Table_name` char(64) NOT NULL DEFAULT '',
  `Column_name` char(64) NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `Column_priv` set('Select','Insert','Update','References') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`Host`,`Db`,`User`,`Table_name`,`Column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Column privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `columns_priv`
--

LOCK TABLES `columns_priv` WRITE;
/*!40000 ALTER TABLE `columns_priv` DISABLE KEYS */;
/*!40000 ALTER TABLE `columns_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db`
--

DROP TABLE IF EXISTS `db`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `db` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Event_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_history_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Host`,`Db`,`User`),
  KEY `User` (`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Database privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `db`
--

LOCK TABLES `db` WRITE;
/*!40000 ALTER TABLE `db` DISABLE KEYS */;
INSERT INTO `db` (`Host`, `Db`, `User`, `Select_priv`, `Insert_priv`, `Update_priv`, `Delete_priv`, `Create_priv`, `Drop_priv`, `Grant_priv`, `References_priv`, `Index_priv`, `Alter_priv`, `Create_tmp_table_priv`, `Lock_tables_priv`, `Create_view_priv`, `Show_view_priv`, `Create_routine_priv`, `Alter_routine_priv`, `Execute_priv`, `Event_priv`, `Trigger_priv`, `Delete_history_priv`) VALUES ('localhost','keystone','keystone_2f95','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','keystone','keystone_2f95','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','placement','placement_58d6','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','placement','placement_58d6','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','glance','glance_2d11','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','glance','glance_2d11','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','neutron','neutron_1206','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','cinder','cinder_6816','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','neutron','neutron_1206','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','cinder','cinder_6816','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','heat','heat_216d','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','heat','heat_216d','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','barbican','barbican_2566','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','barbican','barbican_2566','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_cell0','nova_cell0_854f','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_api','nova_api_05c6','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_cell0','nova_cell0_854f','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_api','nova_api_05c6','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');
/*!40000 ALTER TABLE `db` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `db` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `name` char(64) NOT NULL DEFAULT '',
  `body` longblob NOT NULL,
  `definer` char(141) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `execute_at` datetime DEFAULT NULL,
  `interval_value` int(11) DEFAULT NULL,
  `interval_field` enum('YEAR','QUARTER','MONTH','DAY','HOUR','MINUTE','WEEK','SECOND','MICROSECOND','YEAR_MONTH','DAY_HOUR','DAY_MINUTE','DAY_SECOND','HOUR_MINUTE','HOUR_SECOND','MINUTE_SECOND','DAY_MICROSECOND','HOUR_MICROSECOND','MINUTE_MICROSECOND','SECOND_MICROSECOND') DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_executed` datetime DEFAULT NULL,
  `starts` datetime DEFAULT NULL,
  `ends` datetime DEFAULT NULL,
  `status` enum('ENABLED','DISABLED','SLAVESIDE_DISABLED') NOT NULL DEFAULT 'ENABLED',
  `on_completion` enum('DROP','PRESERVE') NOT NULL DEFAULT 'DROP',
  `sql_mode` set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','IGNORE_BAD_TABLE_OPTIONS','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH','EMPTY_STRING_IS_NULL','SIMULTANEOUS_ASSIGNMENT','TIME_ROUND_FRACTIONAL') NOT NULL DEFAULT '',
  `comment` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `originator` int(10) unsigned NOT NULL,
  `time_zone` char(64) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT 'SYSTEM',
  `character_set_client` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `collation_connection` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `db_collation` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `body_utf8` longblob DEFAULT NULL,
  PRIMARY KEY (`db`,`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Events';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `func`
--

DROP TABLE IF EXISTS `func`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `func` (
  `name` char(64) NOT NULL DEFAULT '',
  `ret` tinyint(1) NOT NULL DEFAULT 0,
  `dl` char(128) NOT NULL DEFAULT '',
  `type` enum('function','aggregate') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='User defined functions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `func`
--

LOCK TABLES `func` WRITE;
/*!40000 ALTER TABLE `func` DISABLE KEYS */;
/*!40000 ALTER TABLE `func` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `global_priv`
--

DROP TABLE IF EXISTS `global_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Priv` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '{}' CHECK (json_valid(`Priv`)),
  PRIMARY KEY (`Host`,`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Users and global privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `global_priv`
--

LOCK TABLES `global_priv` WRITE;
/*!40000 ALTER TABLE `global_priv` DISABLE KEYS */;
INSERT INTO `global_priv` (`Host`, `User`, `Priv`) VALUES ('localhost','mariadb.sys','{\"access\":0,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"\",\"account_locked\":true,\"password_last_changed\":0}'),('localhost','root','{\"access\": 549755813887, \"plugin\": \"mysql_native_password\", \"authentication_string\": \"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\", \"auth_or\": [{}],\"version_id\":100529,\"password_last_changed\":1764400919}'),('%','root','{\"access\":549755813887,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\",\"password_last_changed\":1764400919}'),('localhost','keystone_2f95','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*E98B451D38491CB717F173BA98AF59638E1E929A\",\"password_last_changed\":1764400935}'),('%','keystone_2f95','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*E98B451D38491CB717F173BA98AF59638E1E929A\",\"password_last_changed\":1764400935}'),('localhost','placement_58d6','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*717571571B6E9774CFCBE4450A274C2827534FD7\",\"password_last_changed\":1764400935}'),('%','placement_58d6','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*717571571B6E9774CFCBE4450A274C2827534FD7\",\"password_last_changed\":1764400935}'),('localhost','glance_2d11','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*957951CCDBF2AB564472BE20C9D60A8982AACD2C\",\"password_last_changed\":1764400935}'),('%','glance_2d11','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*957951CCDBF2AB564472BE20C9D60A8982AACD2C\",\"password_last_changed\":1764400935}'),('localhost','neutron_1206','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B4CB5E8622874D97D82AB8B3478C708BD5D5F9AF\",\"password_last_changed\":1764400959}'),('localhost','cinder_6816','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*38682164FD49EB1DD2AA26DA7624F0629F3DDAEB\",\"password_last_changed\":1764400959}'),('%','neutron_1206','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B4CB5E8622874D97D82AB8B3478C708BD5D5F9AF\",\"password_last_changed\":1764400959}'),('%','cinder_6816','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*38682164FD49EB1DD2AA26DA7624F0629F3DDAEB\",\"password_last_changed\":1764400959}'),('localhost','heat_216d','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*3638638A8EDA5CE686E43CADA6EF3864E5121E40\",\"password_last_changed\":1764400959}'),('%','heat_216d','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*3638638A8EDA5CE686E43CADA6EF3864E5121E40\",\"password_last_changed\":1764400959}'),('localhost','barbican_2566','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*7B16DC00F9EF79A9572F06A026CDFFB25A4CB009\",\"password_last_changed\":1764400959}'),('%','barbican_2566','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*7B16DC00F9EF79A9572F06A026CDFFB25A4CB009\",\"password_last_changed\":1764400960}'),('localhost','nova_cell0_854f','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*915724573F166035FD051D33778C7022C9E28A7F\",\"password_last_changed\":1764401142}'),('localhost','nova_api_05c6','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*FB7A5994D3E2495873F0B22B2FEBA76B94B09B2F\",\"password_last_changed\":1764401142}'),('%','nova_cell0_854f','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*915724573F166035FD051D33778C7022C9E28A7F\",\"password_last_changed\":1764401142}'),('%','nova_api_05c6','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*FB7A5994D3E2495873F0B22B2FEBA76B94B09B2F\",\"password_last_changed\":1764401142}');
/*!40000 ALTER TABLE `global_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gtid_slave_pos`
--

DROP TABLE IF EXISTS `gtid_slave_pos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gtid_slave_pos` (
  `domain_id` int(10) unsigned NOT NULL,
  `sub_id` bigint(20) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `seq_no` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`domain_id`,`sub_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci COMMENT='Replication slave GTID position';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gtid_slave_pos`
--

LOCK TABLES `gtid_slave_pos` WRITE;
/*!40000 ALTER TABLE `gtid_slave_pos` DISABLE KEYS */;
/*!40000 ALTER TABLE `gtid_slave_pos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_category`
--

DROP TABLE IF EXISTS `help_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_category` (
  `help_category_id` smallint(5) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `parent_category_id` smallint(5) unsigned DEFAULT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_category_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_category`
--

LOCK TABLES `help_category` WRITE;
/*!40000 ALTER TABLE `help_category` DISABLE KEYS */;
INSERT INTO `help_category` (`help_category_id`, `name`, `parent_category_id`, `url`) VALUES (1,'Contents',0,''),(2,'Polygon Properties',34,''),(3,'WKT',34,''),(4,'Numeric Functions',37,''),(5,'Plugins',1,''),(6,'MBR',34,''),(7,'Control Flow Functions',37,''),(8,'Transactions',1,''),(9,'Help Metadata',1,''),(10,'Account Management',1,''),(11,'Point Properties',34,''),(12,'Encryption Functions',37,''),(13,'LineString Properties',34,''),(14,'Miscellaneous Functions',37,''),(15,'Logical Operators',47,''),(16,'Functions and Modifiers for Use with GROUP BY',1,''),(17,'Information Functions',37,''),(18,'Assignment Operators',47,''),(19,'Comparison Operators',47,''),(20,'Bit Functions',37,''),(21,'Table Maintenance',1,''),(22,'User-Defined Functions',1,''),(23,'Data Types',1,''),(24,'Compound Statements',1,''),(25,'Geometry Constructors',34,''),(26,'Administration',1,''),(27,'Data Manipulation',1,''),(28,'Utility',1,''),(29,'Language Structure',1,''),(30,'Geometry Relations',34,''),(31,'Date and Time Functions',37,''),(32,'WKB',34,''),(33,'Procedures',1,''),(34,'Geographic Features',1,''),(35,'Geometry Properties',34,''),(36,'String Functions',37,''),(37,'Functions',1,''),(38,'Data Definition',1,''),(39,'Sequences',1,''),(40,'JSON Functions',37,''),(41,'Window Functions',37,''),(42,'Spider Functions',37,''),(43,'Dynamic Column Functions',37,''),(44,'Galera Functions',37,''),(45,'Temporal Tables',1,''),(46,'GeoJSON',34,''),(47,'Operators',1,''),(48,'Arithmetic Operators',47,''),(49,'Replication',1,''),(50,'Prepared Statements',1,'');
/*!40000 ALTER TABLE `help_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_keyword`
--

DROP TABLE IF EXISTS `help_keyword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_keyword` (
  `help_keyword_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  PRIMARY KEY (`help_keyword_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help keywords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_keyword`
--

LOCK TABLES `help_keyword` WRITE;
/*!40000 ALTER TABLE `help_keyword` DISABLE KEYS */;
INSERT INTO `help_keyword` (`help_keyword_id`, `name`) VALUES (1,'work'),(2,'locks'),(3,'locking'),(4,'drop'),(5,'super'),(6,'usage'),(7,'binlog admin'),(8,'binlog monitor'),(9,'binlog replay'),(10,'connection admin'),(11,'federated admin'),(12,'grant option'),(13,'read_only admin'),(14,'replica monitor'),(15,'replication replica'),(16,'roles'),(17,'values'),(18,'value'),(19,'not'),(20,'and'),(21,'or'),(22,':='),(23,'assignment operator'),(24,'='),(25,'!='),(26,'<>'),(27,'not equal'),(28,'less than'),(29,'less than or equal'),(30,'NULL-safe equal'),(31,'equal'),(32,'greater than'),(33,'greater than or equal'),(34,'bitwise and'),(35,'shift left'),(36,'shift right'),(37,'bitwise xor'),(38,'bitwise or'),(39,'bitwise not'),(40,'returns'),(41,'udfs'),(42,'udf calling sequences'),(43,'udf security'),(44,'int1'),(45,'int2'),(46,'int3'),(47,'integer'),(48,'int4'),(49,'int8'),(50,'dec'),(51,'numeric'),(52,'fixed'),(53,'number'),(54,'real'),(55,'double precision'),(56,'nchar'),(57,'long'),(58,'long varchar'),(59,'repeat'),(60,'declare'),(61,'cursor'),(62,'show'),(63,'columns'),(64,'kill connection'),(65,'kill query'),(66,'delete returning'),(67,'sql_big_result'),(68,'minus'),(69,'cte'),(70,'insert returning'),(71,'queries'),(72,'query'),(73,'explain format'),(74,'explain format json'),(75,'rlike'),(76,'character_length'),(77,'escape'),(78,'mode'),(79,'trim_oracle'),(80,'schedule'),(81,'row_format'),(82,'starts'),(83,'host'),(84,'generated columns'),(85,'virtual columns'),(86,'computed columns'),(87,'hidden columns'),(88,'nextval'),(89,'lastval'),(90,'+'),(91,'addition operator'),(92,'/'),(93,'division operator'),(94,'%'),(95,'modulo operator'),(96,'*'),(97,'multiplication operator'),(98,'-'),(99,'subtraction operator'),(100,'master_ssl_verify_cert'),(101,'start replica'),(102,'stop replica'),(103,'reset slave'),(104,'reset replica'),(105,'drop prepare'),(106,'deallocate prepare');
/*!40000 ALTER TABLE `help_keyword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_relation`
--

DROP TABLE IF EXISTS `help_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_relation` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `help_keyword_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`help_keyword_id`,`help_topic_id`),
  KEY `help_topic_id` (`help_topic_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='keyword-topic relation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_relation`
--

LOCK TABLES `help_relation` WRITE;
/*!40000 ALTER TABLE `help_relation` DISABLE KEYS */;
INSERT INTO `help_relation` (`help_topic_id`, `help_keyword_id`) VALUES (94,1),(97,2),(99,2),(101,2),(116,2),(147,2),(152,2),(157,2),(161,2),(162,2),(338,2),(438,2),(97,3),(99,3),(101,3),(116,3),(147,3),(152,3),(157,3),(161,3),(162,3),(338,3),(438,3),(106,4),(112,4),(250,4),(687,4),(697,4),(713,4),(714,4),(715,4),(716,4),(717,4),(718,4),(719,4),(720,4),(722,4),(723,4),(731,4),(107,5),(107,6),(107,7),(107,8),(107,9),(107,10),(107,11),(107,12),(107,13),(107,14),(107,15),(115,16),(166,17),(166,18),(167,19),(168,20),(170,21),(210,22),(210,23),(211,23),(211,24),(212,25),(212,26),(212,27),(213,28),(214,29),(215,30),(216,31),(217,32),(218,33),(232,34),(233,35),(234,36),(236,37),(237,38),(238,39),(249,40),(251,41),(252,42),(253,43),(255,44),(257,45),(258,46),(259,47),(259,48),(260,49),(261,50),(261,51),(261,52),(261,53),(263,54),(263,55),(269,56),(275,57),(275,58),(304,59),(664,59),(311,60),(311,61),(331,62),(332,62),(333,62),(334,62),(335,62),(342,62),(343,62),(344,62),(345,62),(346,62),(347,62),(354,62),(356,62),(357,62),(358,62),(359,62),(360,62),(361,62),(362,62),(363,62),(364,62),(365,62),(366,62),(367,62),(368,62),(369,62),(370,62),(371,62),(372,62),(373,62),(374,62),(375,62),(376,62),(377,62),(378,62),(379,62),(380,62),(381,62),(382,62),(383,62),(384,62),(385,62),(386,62),(387,62),(388,62),(389,62),(390,62),(391,62),(392,62),(393,62),(394,62),(395,62),(396,62),(397,62),(398,62),(408,62),(409,62),(333,63),(403,64),(403,65),(410,66),(414,67),(425,68),(431,69),(432,69),(433,69),(453,70),(460,71),(460,72),(466,73),(466,74),(622,75),(632,76),(651,77),(657,78),(678,79),(689,80),(696,81),(701,82),(707,83),(711,84),(711,85),(711,86),(712,87),(732,88),(733,89),(804,90),(804,91),(805,92),(805,93),(806,94),(806,95),(807,96),(807,97),(808,98),(808,99),(809,100),(810,101),(811,102),(812,103),(812,104),(816,105),(816,106);
/*!40000 ALTER TABLE `help_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_topic`
--

DROP TABLE IF EXISTS `help_topic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_topic` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `help_category_id` smallint(5) unsigned NOT NULL,
  `description` text NOT NULL,
  `example` text NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_topic_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help topics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_topic`
--

LOCK TABLES `help_topic` WRITE;
/*!40000 ALTER TABLE `help_topic` DISABLE KEYS */;
INSERT INTO `help_topic` (`help_topic_id`, `name`, `help_category_id`, `description`, `example`, `url`) VALUES (1,'HELP_DATE',9,'Help Contents generated from the MariaDB Knowledge Base on 23 January 2023.','',''),(2,'HELP_VERSION',9,'Help Contents generated for MariaDB 10.5 from the MariaDB Knowledge Base on 23 January 2023.','',''),(3,'AREA',2,'A synonym for ST_AREA.\n\nURL: https://mariadb.com/kb/en/polygon-properties-area/','','https://mariadb.com/kb/en/polygon-properties-area/'),(4,'CENTROID',2,'A synonym for ST_CENTROID.\n\nURL: https://mariadb.com/kb/en/centroid/','','https://mariadb.com/kb/en/centroid/'),(5,'ExteriorRing',2,'A synonym for ST_ExteriorRing.\n\nURL: https://mariadb.com/kb/en/polygon-properties-exteriorring/','','https://mariadb.com/kb/en/polygon-properties-exteriorring/'),(6,'InteriorRingN',2,'A synonym for ST_InteriorRingN.\n\nURL: https://mariadb.com/kb/en/polygon-properties-interiorringn/','','https://mariadb.com/kb/en/polygon-properties-interiorringn/'),(7,'NumInteriorRings',2,'A synonym for ST_NumInteriorRings.\n\nURL: https://mariadb.com/kb/en/polygon-properties-numinteriorrings/','','https://mariadb.com/kb/en/polygon-properties-numinteriorrings/'),(8,'ST_AREA',2,'Syntax\n------\n\nST_Area(poly)\nArea(poly)\n\nDescription\n-----------\n\nReturns as a double-precision number the area of the Polygon value poly, as\nmeasured in its spatial reference system.\n\nST_Area() and Area() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\n\nSELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+\n\nURL: https://mariadb.com/kb/en/st_area/','','https://mariadb.com/kb/en/st_area/'),(9,'ST_CENTROID',2,'Syntax\n------\n\nST_Centroid(mpoly)\nCentroid(mpoly)\n\nDescription\n-----------\n\nReturns a point reflecting the mathematical centroid (geometric center) for\nthe MultiPolygon mpoly. The resulting point will not necessarily be on the\nMultiPolygon.\n\nST_Centroid() and Centroid() are synonyms.\n\nExamples\n--------\n\nSET @poly = ST_GeomFromText(\'POLYGON((0 0,20 0,20 20,0 20,0 0))\');\nSELECT ST_AsText(ST_Centroid(@poly)) AS center;\n+--------------+\n| center       |\n+--------------+\n| POINT(10 10) |\n+--------------+\n\nURL: https://mariadb.com/kb/en/st_centroid/','','https://mariadb.com/kb/en/st_centroid/'),(10,'ST_ExteriorRing',2,'Syntax\n------\n\nST_ExteriorRing(poly)\nExteriorRing(poly)\n\nDescription\n-----------\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nST_ExteriorRing() and ExteriorRing() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_exteriorring/','','https://mariadb.com/kb/en/st_exteriorring/'),(11,'ST_InteriorRingN',2,'Syntax\n------\n\nST_InteriorRingN(poly,N)\nInteriorRingN(poly,N)\n\nDescription\n-----------\n\nReturns the N-th interior ring for the Polygon value poly as a LineString.\nRings are numbered beginning with 1.\n\nST_InteriorRingN() and InteriorRingN() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_interiorringn/','','https://mariadb.com/kb/en/st_interiorringn/'),(12,'ST_NumInteriorRings',2,'Syntax\n------\n\nST_NumInteriorRings(poly)\nNumInteriorRings(poly)\n\nDescription\n-----------\n\nReturns an integer containing the number of interior rings in the Polygon\nvalue poly.\n\nNote that according the the OpenGIS standard, a POLYGON should have exactly\none ExteriorRing and all other rings should lie within that ExteriorRing and\nthus be the InteriorRings. Practically, however, some systems, including\nMariaDB\'s, permit polygons to have several \'ExteriorRings\'. In the case of\nthere being multiple, non-overlapping exterior rings ST_NumInteriorRings()\nwill return 1.\n\nST_NumInteriorRings() and NumInteriorRings() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\n\nNon-overlapping \'polygon\':\n\nSELECT ST_NumInteriorRings(ST_PolyFromText(\'POLYGON((0 0,10 0,10 10,0 10,0 0),\n (-1 -1,-5 -1,-5 -5,-1 -5,-1 -1))\')) AS NumInteriorRings;\n+------------------+\n| NumInteriorRings |\n+------------------+\n|                1 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/st_numinteriorrings/','','https://mariadb.com/kb/en/st_numinteriorrings/'),(14,'AsText',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-astext/','','https://mariadb.com/kb/en/wkt-astext/'),(15,'AsWKT',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-aswkt/','','https://mariadb.com/kb/en/wkt-aswkt/'),(16,'GeomCollFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomcollfromtext/','','https://mariadb.com/kb/en/wkt-geomcollfromtext/'),(17,'GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/geometrycollectionfromtext/','','https://mariadb.com/kb/en/geometrycollectionfromtext/'),(18,'GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/geometryfromtext/','','https://mariadb.com/kb/en/geometryfromtext/'),(19,'GeomFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomfromtext/','','https://mariadb.com/kb/en/wkt-geomfromtext/'),(20,'LineFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/wkt-linefromtext/','','https://mariadb.com/kb/en/wkt-linefromtext/'),(21,'LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/linestringfromtext/','','https://mariadb.com/kb/en/linestringfromtext/'),(22,'MLineFromText',3,'Syntax\n------\n\nMLineFromText(wkt[,srid])\nMultiLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTILINESTRING value using its WKT representation and SRID.\n\nMLineFromText() and MultiLineStringFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nSHOW FIELDS FROM gis_multi_line;\nINSERT INTO gis_multi_line VALUES\n  (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16\n23,16 48))\')),\n  (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n  (MLineFromWKB(AsWKB(MultiLineString(\n   LineString(Point(1, 2), Point(3, 5)),\n   LineString(Point(2, 5), Point(5, 8), Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/mlinefromtext/','','https://mariadb.com/kb/en/mlinefromtext/'),(23,'MPointFromText',3,'Syntax\n------\n\nMPointFromText(wkt[,srid])\nMultiPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n\nMPointFromText() and MultiPointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nSHOW FIELDS FROM gis_multi_point;\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/mpointfromtext/','','https://mariadb.com/kb/en/mpointfromtext/'),(13,'WKT Definition',3,'Description\n-----------\n\nThe Well-Known Text (WKT) representation of Geometry is designed to exchange\ngeometry data in ASCII form. Examples of the basic geometry types include:\n\n+-----------------------------------------------------------------------------+\n| Geometry Types                                                              |\n+-----------------------------------------------------------------------------+\n| POINT                                                                       |\n+-----------------------------------------------------------------------------+\n| LINESTRING                                                                  |\n+-----------------------------------------------------------------------------+\n| POLYGON                                                                     |\n+-----------------------------------------------------------------------------+\n| MULTIPOINT                                                                  |\n+-----------------------------------------------------------------------------+\n| MULTILINESTRING                                                             |\n+-----------------------------------------------------------------------------+\n| MULTIPOLYGON                                                                |\n+-----------------------------------------------------------------------------+\n| GEOMETRYCOLLECTION                                                          |\n+-----------------------------------------------------------------------------+\n| GEOMETRY                                                                    |\n+-----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/wkt-definition/','','https://mariadb.com/kb/en/wkt-definition/'),(24,'MPolyFromText',3,'Syntax\n------\n\nMPolyFromText(wkt[,srid])\nMultiPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n\nMPolyFromText() and MultiPolygonFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_polygon  (g MULTIPOLYGON);\nSHOW FIELDS FROM gis_multi_polygon;\nINSERT INTO gis_multi_polygon VALUES\n  (MultiPolygonFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromWKB(AsWKB(MultiPolygon(Polygon(\n   LineString(Point(0, 3), Point(3, 3), Point(3, 0), Point(0, 3)))))));\n\nURL: https://mariadb.com/kb/en/mpolyfromtext/','','https://mariadb.com/kb/en/mpolyfromtext/'),(25,'MultiLineStringFromText',3,'A synonym for MLineFromText.\n\nURL: https://mariadb.com/kb/en/multilinestringfromtext/','','https://mariadb.com/kb/en/multilinestringfromtext/'),(26,'MultiPointFromText',3,'A synonym for MPointFromText.\n\nURL: https://mariadb.com/kb/en/multipointfromtext/','','https://mariadb.com/kb/en/multipointfromtext/'),(27,'MultiPolygonFromText',3,'A synonym for MPolyFromText.\n\nURL: https://mariadb.com/kb/en/multipolygonfromtext/','','https://mariadb.com/kb/en/multipolygonfromtext/'),(28,'PointFromText',3,'A synonym for ST_PointFromText.\n\nURL: https://mariadb.com/kb/en/wkt-pointfromtext/','','https://mariadb.com/kb/en/wkt-pointfromtext/'),(29,'PolyFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/wkt-polyfromtext/','','https://mariadb.com/kb/en/wkt-polyfromtext/'),(30,'PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/polygonfromtext/','','https://mariadb.com/kb/en/polygonfromtext/'),(31,'ST_AsText',3,'Syntax\n------\n\nST_AsText(g)\nAsText(g)\nST_AsWKT(g)\nAsWKT(g)\n\nDescription\n-----------\n\nConverts a value in internal geometry format to its WKT representation and\nreturns the string result.\n\nST_AsText(), AsText(), ST_AsWKT() and AsWKT() are all synonyms.\n\nExamples\n--------\n\nSET @g = \'LineString(1 1,4 4,6 6)\';\n\nSELECT ST_AsText(ST_GeomFromText(@g));\n+--------------------------------+\n| ST_AsText(ST_GeomFromText(@g)) |\n+--------------------------------+\n| LINESTRING(1 1,4 4,6 6)        |\n+--------------------------------+\n\nURL: https://mariadb.com/kb/en/st_astext/','','https://mariadb.com/kb/en/st_astext/'),(32,'ST_ASWKT',3,'A synonym for ST_ASTEXT().\n\nURL: https://mariadb.com/kb/en/st_aswkt/','','https://mariadb.com/kb/en/st_aswkt/'),(33,'ST_GeomCollFromText',3,'Syntax\n------\n\nST_GeomCollFromText(wkt[,srid])\nST_GeometryCollectionFromText(wkt[,srid])\nGeomCollFromText(wkt[,srid])\nGeometryCollectionFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and SRID.\n\nST_GeomCollFromText(), ST_GeometryCollectionFromText(), GeomCollFromText() and\nGeometryCollectionFromText() are all synonyms.\n\nExample\n-------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/st_geomcollfromtext/','','https://mariadb.com/kb/en/st_geomcollfromtext/'),(34,'ST_GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/st_geometrycollectionfromtext/','','https://mariadb.com/kb/en/st_geometrycollectionfromtext/'),(35,'ST_GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/st_geometryfromtext/','','https://mariadb.com/kb/en/st_geometryfromtext/'),(36,'ST_GeomFromText',3,'Syntax\n------\n\nST_GeomFromText(wkt[,srid])\nST_GeometryFromText(wkt[,srid])\nGeomFromText(wkt[,srid])\nGeometryFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a geometry value of any type using its WKT representation and SRID.\n\nGeomFromText(), GeometryFromText(), ST_GeomFromText() and\nST_GeometryFromText() are all synonyms.\n\nExample\n-------\n\nSET @g = ST_GEOMFROMTEXT(\'POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1 1))\');\n\nURL: https://mariadb.com/kb/en/st_geomfromtext/','','https://mariadb.com/kb/en/st_geomfromtext/'),(37,'ST_LineFromText',3,'Syntax\n------\n\nST_LineFromText(wkt[,srid])\nST_LineStringFromText(wkt[,srid])\nLineFromText(wkt[,srid])\nLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a LINESTRING value using its WKT representation and SRID.\n\nST_LineFromText(), ST_LineStringFromText(), ST_LineFromText() and\nST_LineStringFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_line  (g LINESTRING);\nSHOW FIELDS FROM gis_line;\nINSERT INTO gis_line VALUES\n  (LineFromText(\'LINESTRING(0 0,0 10,10 0)\')),\n  (LineStringFromText(\'LINESTRING(10 10,20 10,20 20,10 20,10 10)\')),\n  (LineStringFromWKB(AsWKB(LineString(Point(10, 10), Point(40, 10)))));\n\nURL: https://mariadb.com/kb/en/st_linefromtext/','','https://mariadb.com/kb/en/st_linefromtext/'),(38,'ST_LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/st_linestringfromtext/','','https://mariadb.com/kb/en/st_linestringfromtext/'),(39,'ST_PointFromText',3,'Syntax\n------\n\nST_PointFromText(wkt[,srid])\nPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POINT value using its WKT representation and SRID.\n\nST_PointFromText() and PointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_point  (g POINT);\nSHOW FIELDS FROM gis_point;\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/st_pointfromtext/','','https://mariadb.com/kb/en/st_pointfromtext/'),(40,'ST_PolyFromText',3,'Syntax\n------\n\nST_PolyFromText(wkt[,srid])\nST_PolygonFromText(wkt[,srid])\nPolyFromText(wkt[,srid])\nPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POLYGON value using its WKT representation and SRID.\n\nST_PolyFromText(), ST_PolygonFromText(), PolyFromText() and\nST_PolygonFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_polygon   (g POLYGON);\nINSERT INTO gis_polygon VALUES\n  (PolygonFromText(\'POLYGON((10 10,20 10,20 20,10 20,10 10))\')),\n  (PolyFromText(\'POLYGON((0 0,50 0,50 50,0 50,0 0), (10 10,20 10,20 20,10\n20,10 10))\'));\n\nURL: https://mariadb.com/kb/en/st_polyfromtext/','','https://mariadb.com/kb/en/st_polyfromtext/'),(41,'ST_PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/st_polygonfromtext/','','https://mariadb.com/kb/en/st_polygonfromtext/'),(42,'DIV',4,'Syntax\n------\n\nDIV\n\nDescription\n-----------\n\nInteger division. Similar to FLOOR(), but is safe with BIGINT values.\nIncorrect results may occur for non-integer operands that exceed BIGINT range.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, a division by zero produces\nan error. Otherwise, it returns NULL.\n\nThe remainder of a division can be obtained using the MOD operator.\n\nExamples\n--------\n\nSELECT 300 DIV 7;\n+-----------+\n| 300 DIV 7 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT 300 DIV 0;\n+-----------+\n| 300 DIV 0 |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/div/','','https://mariadb.com/kb/en/div/'),(43,'ABS',4,'Syntax\n------\n\nABS(X)\n\nDescription\n-----------\n\nReturns the absolute (non-negative) value of X. If X is not a number, it is\nconverted to a numeric type.\n\nExamples\n--------\n\nSELECT ABS(42);\n+---------+\n| ABS(42) |\n+---------+\n|      42 |\n+---------+\n\nSELECT ABS(-42);\n+----------+\n| ABS(-42) |\n+----------+\n|       42 |\n+----------+\n\nSELECT ABS(DATE \'1994-01-01\');\n+------------------------+\n| ABS(DATE \'1994-01-01\') |\n+------------------------+\n|               19940101 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/abs/','','https://mariadb.com/kb/en/abs/'),(44,'ACOS',4,'Syntax\n------\n\nACOS(X)\n\nDescription\n-----------\n\nReturns the arc cosine of X, that is, the value whose cosine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ACOS(1);\n+---------+\n| ACOS(1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ACOS(1.0001);\n+--------------+\n| ACOS(1.0001) |\n+--------------+\n|         NULL |\n+--------------+\n\nSELECT ACOS(0);\n+-----------------+\n| ACOS(0)         |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT ACOS(0.234);\n+------------------+\n| ACOS(0.234)      |\n+------------------+\n| 1.33460644244679 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/acos/','','https://mariadb.com/kb/en/acos/'),(45,'ASIN',4,'Syntax\n------\n\nASIN(X)\n\nDescription\n-----------\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns NULL if\nX is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ASIN(0.2);\n+--------------------+\n| ASIN(0.2)          |\n+--------------------+\n| 0.2013579207903308 |\n+--------------------+\n\nSELECT ASIN(\'foo\');\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n\nSHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n\nURL: https://mariadb.com/kb/en/asin/','','https://mariadb.com/kb/en/asin/'),(46,'ATAN',4,'Syntax\n------\n\nATAN(X)\n\nDescription\n-----------\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nExamples\n--------\n\nSELECT ATAN(2);\n+--------------------+\n| ATAN(2)            |\n+--------------------+\n| 1.1071487177940904 |\n+--------------------+\n\nSELECT ATAN(-2);\n+---------------------+\n| ATAN(-2)            |\n+---------------------+\n| -1.1071487177940904 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/atan/','','https://mariadb.com/kb/en/atan/'),(47,'ATAN2',4,'Syntax\n------\n\nATAN(Y,X), ATAN2(Y,X)\n\nDescription\n-----------\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both arguments\nare used to determine the quadrant of the result.\n\nExamples\n--------\n\nSELECT ATAN(-2,2);\n+---------------------+\n| ATAN(-2,2)          |\n+---------------------+\n| -0.7853981633974483 |\n+---------------------+\n\nSELECT ATAN2(PI(),0);\n+--------------------+\n| ATAN2(PI(),0)      |\n+--------------------+\n| 1.5707963267948966 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/atan2/','','https://mariadb.com/kb/en/atan2/'),(48,'CEIL',4,'Syntax\n------\n\nCEIL(X)\n\nDescription\n-----------\n\nCEIL() is a synonym for CEILING().\n\nURL: https://mariadb.com/kb/en/ceil/','','https://mariadb.com/kb/en/ceil/'),(49,'CEILING',4,'Syntax\n------\n\nCEILING(X)\n\nDescription\n-----------\n\nReturns the smallest integer value not less than X.\n\nExamples\n--------\n\nSELECT CEILING(1.23);\n+---------------+\n| CEILING(1.23) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT CEILING(-1.23);\n+----------------+\n| CEILING(-1.23) |\n+----------------+\n|             -1 |\n+----------------+\n\nURL: https://mariadb.com/kb/en/ceiling/','','https://mariadb.com/kb/en/ceiling/'),(51,'COS',4,'Syntax\n------\n\nCOS(X)\n\nDescription\n-----------\n\nReturns the cosine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT COS(PI());\n+-----------+\n| COS(PI()) |\n+-----------+\n|        -1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/cos/','','https://mariadb.com/kb/en/cos/'),(52,'COT',4,'Syntax\n------\n\nCOT(X)\n\nDescription\n-----------\n\nReturns the cotangent of X.\n\nExamples\n--------\n\nSELECT COT(42);\n+--------------------+\n| COT(42)            |\n+--------------------+\n| 0.4364167060752729 |\n+--------------------+\n\nSELECT COT(12);\n+---------------------+\n| COT(12)             |\n+---------------------+\n| -1.5726734063976893 |\n+---------------------+\n\nSELECT COT(0);\nERROR 1690 (22003): DOUBLE value is out of range in \'cot(0)\'\n\nURL: https://mariadb.com/kb/en/cot/','','https://mariadb.com/kb/en/cot/'),(54,'DEGREES',4,'Syntax\n------\n\nDEGREES(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from radians to degrees.\n\nThis is the converse of the RADIANS() function.\n\nExamples\n--------\n\nSELECT DEGREES(PI());\n+---------------+\n| DEGREES(PI()) |\n+---------------+\n|           180 |\n+---------------+\n\nSELECT DEGREES(PI() / 2);\n+-------------------+\n| DEGREES(PI() / 2) |\n+-------------------+\n|                90 |\n+-------------------+\n\nSELECT DEGREES(45);\n+-----------------+\n| DEGREES(45)     |\n+-----------------+\n| 2578.3100780887 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/degrees/','','https://mariadb.com/kb/en/degrees/'),(55,'EXP',4,'Syntax\n------\n\nEXP(X)\n\nDescription\n-----------\n\nReturns the value of e (the base of natural logarithms) raised to the power of\nX. The inverse of this function is LOG() (using a single argument only) or\nLN().\n\nIf X is NULL, this function returns NULL.\n\nExamples\n--------\n\nSELECT EXP(2);\n+------------------+\n| EXP(2)           |\n+------------------+\n| 7.38905609893065 |\n+------------------+\n\nSELECT EXP(-2);\n+--------------------+\n| EXP(-2)            |\n+--------------------+\n| 0.1353352832366127 |\n+--------------------+\n\nSELECT EXP(0);\n+--------+\n| EXP(0) |\n+--------+\n|      1 |\n+--------+\n\nSELECT EXP(NULL);\n+-----------+\n| EXP(NULL) |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/exp/','','https://mariadb.com/kb/en/exp/'),(50,'CONV',4,'Syntax\n------\n\nCONV(N,from_base,to_base)\n\nDescription\n-----------\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base to_base.\n\nReturns NULL if any argument is NULL, or if the second or third argument are\nnot in the allowed range.\n\nThe argument N is interpreted as an integer, but may be specified as an\ninteger or a string. The minimum base is 2 and the maximum base is 36. If\nto_base is a negative number, N is regarded as a signed number. Otherwise, N\nis treated as unsigned. CONV() works with 64-bit precision.\n\nSome shortcuts for this function are also available: BIN(), OCT(), HEX(),\nUNHEX(). Also, MariaDB allows binary literal values and hexadecimal literal\nvalues.\n\nExamples\n--------\n\nSELECT CONV(\'a\',16,2);\n+----------------+\n| CONV(\'a\',16,2) |\n+----------------+\n| 1010           |\n+----------------+\n\nSELECT CONV(\'6E\',18,8);\n+-----------------+\n| CONV(\'6E\',18,8) |\n+-----------------+\n| 172             |\n+-----------------+\n\nSELECT CONV(-17,10,-18);\n+------------------+\n| CONV(-17,10,-18) |\n+------------------+\n| -H               |\n+------------------+\n\nSELECT CONV(12+\'10\'+\'10\'+0xa,10,10);\n+------------------------------+\n| CONV(12+\'10\'+\'10\'+0xa,10,10) |\n+------------------------------+\n| 42                           |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/conv/','','https://mariadb.com/kb/en/conv/'),(53,'CRC32',4,'Syntax\n------\n\n<= MariaDB 10.7\n\nCRC32(expr)\n\nFrom MariaDB 10.8\n\nCRC32([par,]expr)\n\nDescription\n-----------\n\nComputes a cyclic redundancy check (CRC) value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is expected to\nbe a string and (if possible) is treated as one if it is not.\n\nUses the ISO 3309 polynomial that used by zlib and many others. MariaDB 10.8\nintroduced the CRC32C() function, which uses the alternate Castagnoli\npolynomia.\n\nMariaDB starting with 10.8\n--------------------------\nOften, CRC is computed in pieces. To facilitate this, MariaDB 10.8.0\nintroduced an optional parameter: CRC32(\'MariaDB\')=CRC32(CRC32(\'Maria\'),\'DB\').\n\nExamples\n--------\n\nSELECT CRC32(\'MariaDB\');\n+------------------+\n| CRC32(\'MariaDB\') |\n+------------------+\n|       4227209140 |\n+------------------+\n\nSELECT CRC32(\'mariadb\');\n+------------------+\n| CRC32(\'mariadb\') |\n+------------------+\n|       2594253378 |\n+------------------+\n\nFrom MariaDB 10.8.0\n\nSELECT CRC32(CRC32(\'Maria\'),\'DB\');\n+----------------------------+\n| CRC32(CRC32(\'Maria\'),\'DB\') |\n+----------------------------+\n|                 4227209140 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/crc32/','','https://mariadb.com/kb/en/crc32/'),(56,'FLOOR',4,'Syntax\n------\n\nFLOOR(X)\n\nDescription\n-----------\n\nReturns the largest integer value not greater than X.\n\nExamples\n--------\n\nSELECT FLOOR(1.23);\n+-------------+\n| FLOOR(1.23) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT FLOOR(-1.23);\n+--------------+\n| FLOOR(-1.23) |\n+--------------+\n|           -2 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/floor/','','https://mariadb.com/kb/en/floor/'),(57,'LN',4,'Syntax\n------\n\nLN(X)\n\nDescription\n-----------\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X. If X\nis less than or equal to 0, or NULL, then NULL is returned.\n\nThe inverse of this function is EXP().\n\nExamples\n--------\n\nSELECT LN(2);\n+-------------------+\n| LN(2)             |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LN(-2);\n+--------+\n| LN(-2) |\n+--------+\n|   NULL |\n+--------+\n\nURL: https://mariadb.com/kb/en/ln/','','https://mariadb.com/kb/en/ln/'),(58,'LOG',4,'Syntax\n------\n\nLOG(X), LOG(B,X)\n\nDescription\n-----------\n\nIf called with one parameter, this function returns the natural logarithm of\nX. If X is less than or equal to 0, then NULL is returned.\n\nIf called with two parameters, it returns the logarithm of X to the base B. If\nB is <= 1 or X <= 0, the function returns NULL.\n\nIf any argument is NULL, the function returns NULL.\n\nThe inverse of this function (when called with a single argument) is the EXP()\nfunction.\n\nExamples\n--------\n\nLOG(X):\n\nSELECT LOG(2);\n+-------------------+\n| LOG(2)            |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LOG(-2);\n+---------+\n| LOG(-2) |\n+---------+\n|    NULL |\n+---------+\n\nLOG(B,X)\n\nSELECT LOG(2,16);\n+-----------+\n| LOG(2,16) |\n+-----------+\n|         4 |\n+-----------+\n\nSELECT LOG(3,27);\n+-----------+\n| LOG(3,27) |\n+-----------+\n|         3 |\n+-----------+\n\nSELECT LOG(3,1);\n+----------+\n| LOG(3,1) |\n+----------+\n|        0 |\n+----------+\n\nSELECT LOG(3,0);\n+----------+\n| LOG(3,0) |\n+----------+\n|     NULL |\n+----------+\n\nURL: https://mariadb.com/kb/en/log/','','https://mariadb.com/kb/en/log/'),(59,'LOG10',4,'Syntax\n------\n\nLOG10(X)\n\nDescription\n-----------\n\nReturns the base-10 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG10(2);\n+-------------------+\n| LOG10(2)          |\n+-------------------+\n| 0.301029995663981 |\n+-------------------+\n\nSELECT LOG10(100);\n+------------+\n| LOG10(100) |\n+------------+\n|          2 |\n+------------+\n\nSELECT LOG10(-100);\n+-------------+\n| LOG10(-100) |\n+-------------+\n|        NULL |\n+-------------+\n\nURL: https://mariadb.com/kb/en/log10/','','https://mariadb.com/kb/en/log10/'),(60,'LOG2',4,'Syntax\n------\n\nLOG2(X)\n\nDescription\n-----------\n\nReturns the base-2 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG2(4398046511104);\n+---------------------+\n| LOG2(4398046511104) |\n+---------------------+\n|                  42 |\n+---------------------+\n\nSELECT LOG2(65536);\n+-------------+\n| LOG2(65536) |\n+-------------+\n|          16 |\n+-------------+\n\nSELECT LOG2(-100);\n+------------+\n| LOG2(-100) |\n+------------+\n|       NULL |\n+------------+\n\nURL: https://mariadb.com/kb/en/log2/','','https://mariadb.com/kb/en/log2/'),(62,'OCT',4,'Syntax\n------\n\nOCT(N)\n\nDescription\n-----------\n\nReturns a string representation of the octal value of N, where N is a longlong\n(BIGINT) number. This is equivalent to CONV(N,10,8). Returns NULL if N is NULL.\n\nExamples\n--------\n\nSELECT OCT(34);\n+---------+\n| OCT(34) |\n+---------+\n| 42      |\n+---------+\n\nSELECT OCT(12);\n+---------+\n| OCT(12) |\n+---------+\n| 14      |\n+---------+\n\nURL: https://mariadb.com/kb/en/oct/','','https://mariadb.com/kb/en/oct/'),(63,'PI',4,'Syntax\n------\n\nPI()\n\nDescription\n-----------\n\nReturns the value of π (pi). The default number of decimal places displayed is\nsix, but MariaDB uses the full double-precision value internally.\n\nExamples\n--------\n\nSELECT PI();\n+----------+\n| PI()     |\n+----------+\n| 3.141593 |\n+----------+\n\nSELECT PI()+0.0000000000000000000000;\n+-------------------------------+\n| PI()+0.0000000000000000000000 |\n+-------------------------------+\n|      3.1415926535897931159980 |\n+-------------------------------+\n\nURL: https://mariadb.com/kb/en/pi/','','https://mariadb.com/kb/en/pi/'),(64,'POW',4,'Syntax\n------\n\nPOW(X,Y)\n\nDescription\n-----------\n\nReturns the value of X raised to the power of Y.\n\nPOWER() is a synonym.\n\nExamples\n--------\n\nSELECT POW(2,3);\n+----------+\n| POW(2,3) |\n+----------+\n|        8 |\n+----------+\n\nSELECT POW(2,-2);\n+-----------+\n| POW(2,-2) |\n+-----------+\n|      0.25 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/pow/','','https://mariadb.com/kb/en/pow/'),(65,'POWER',4,'Syntax\n------\n\nPOWER(X,Y)\n\nDescription\n-----------\n\nThis is a synonym for POW(), which returns the value of X raised to the power\nof Y.\n\nURL: https://mariadb.com/kb/en/power/','','https://mariadb.com/kb/en/power/'),(61,'MOD',4,'Syntax\n------\n\nMOD(N,M), N % M, N MOD M\n\nDescription\n-----------\n\nModulo operation. Returns the remainder of N divided by M. See also Modulo\nOperator.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, any number modulus zero\nproduces an error. Otherwise, it returns NULL.\n\nThe integer part of a division can be obtained using DIV.\n\nExamples\n--------\n\nSELECT 1042 % 50;\n+-----------+\n| 1042 % 50 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT MOD(234, 10);\n+--------------+\n| MOD(234, 10) |\n+--------------+\n|            4 |\n+--------------+\n\nSELECT 253 % 7;\n+---------+\n| 253 % 7 |\n+---------+\n|       1 |\n+---------+\n\nSELECT MOD(29,9);\n+-----------+\n| MOD(29,9) |\n+-----------+\n|         2 |\n+-----------+\n\nSELECT 29 MOD 9;\n+----------+\n| 29 MOD 9 |\n+----------+\n|        2 |\n+----------+\n\nURL: https://mariadb.com/kb/en/mod/','','https://mariadb.com/kb/en/mod/'),(66,'RADIANS',4,'Syntax\n------\n\nRADIANS(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from degrees to radians. Note that π radians\nequals 180 degrees.\n\nThis is the converse of the DEGREES() function.\n\nExamples\n--------\n\nSELECT RADIANS(45);\n+-------------------+\n| RADIANS(45)       |\n+-------------------+\n| 0.785398163397448 |\n+-------------------+\n\nSELECT RADIANS(90);\n+-----------------+\n| RADIANS(90)     |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT RADIANS(PI());\n+--------------------+\n| RADIANS(PI())      |\n+--------------------+\n| 0.0548311355616075 |\n+--------------------+\n\nSELECT RADIANS(180);\n+------------------+\n| RADIANS(180)     |\n+------------------+\n| 3.14159265358979 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/radians/','','https://mariadb.com/kb/en/radians/'),(67,'RAND',4,'Syntax\n------\n\nRAND(), RAND(N)\n\nDescription\n-----------\n\nReturns a random DOUBLE precision floating point value v in the range 0 <= v <\n1.0. If a constant integer argument N is specified, it is used as the seed\nvalue, which produces a repeatable sequence of column values. In the example\nbelow, note that the sequences of values produced by RAND(3) is the same both\nplaces where it occurs.\n\nIn a WHERE clause, RAND() is evaluated each time the WHERE is executed.\n\nStatements using the RAND() function are not safe for statement-based\nreplication.\n\nPractical uses\n--------------\n\nThe expression to get a random integer from a given range is the following:\n\nFLOOR(min_value + RAND() * (max_value - min_value +1))\n\nRAND() is often used to read random rows from a table, as follows:\n\nSELECT * FROM my_table ORDER BY RAND() LIMIT 10;\n\nNote, however, that this technique should never be used on a large table as it\nwill be extremely slow. MariaDB will read all rows in the table, generate a\nrandom value for each of them, order them, and finally will apply the LIMIT\nclause.\n\nExamples\n--------\n\nCREATE TABLE t (i INT);\n\nINSERT INTO t VALUES(1),(2),(3);\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.255651095188829 |\n|    2 | 0.833920199269355 |\n|    3 |  0.40264774151393 |\n+------+-------------------+\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.511478140495232 |\n|    2 | 0.349447508668012 |\n|    3 | 0.212803152588013 |\n+------+-------------------+\n\nUsing the same seed, the same sequence will be returned:\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nGenerating a random number from 5 to 15:\n\nSELECT FLOOR(5 + (RAND() * 11));\n\nURL: https://mariadb.com/kb/en/rand/','','https://mariadb.com/kb/en/rand/'),(68,'ROUND',4,'Syntax\n------\n\nROUND(X), ROUND(X,D)\n\nDescription\n-----------\n\nRounds the argument X to D decimal places. D defaults to 0 if not specified. D\ncan be negative to cause D digits left of the decimal point of the value X to\nbecome zero.\n\nThe rounding algorithm depends on the data type of X:\n\n* for floating point types (FLOAT, DOUBLE) the C libraries rounding function\nis used, so the behavior *may* differ between operating systems\n* for fixed point types (DECIMAL, DEC/NUMBER/FIXED) the \"round half up\" rule\nis used, meaning that e.g. a value ending in exactly .5 is always rounded up.\n\nExamples\n--------\n\nSELECT ROUND(-1.23);\n+--------------+\n| ROUND(-1.23) |\n+--------------+\n|           -1 |\n+--------------+\n\nSELECT ROUND(-1.58);\n+--------------+\n| ROUND(-1.58) |\n+--------------+\n|           -2 |\n+--------------+\n\nSELECT ROUND(1.58); \n+-------------+\n| ROUND(1.58) |\n+-------------+\n|           2 |\n+-------------+\n\nSELECT ROUND(1.298, 1);\n+-----------------+\n| ROUND(1.298, 1) |\n+-----------------+\n|             1.3 |\n+-----------------+\n\nSELECT ROUND(1.298, 0);\n+-----------------+\n| ROUND(1.298, 0) |\n+-----------------+\n|               1 |\n+-----------------+\n\nSELECT ROUND(23.298, -1);\n+-------------------+\n| ROUND(23.298, -1) |\n+-------------------+\n|                20 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/round/','','https://mariadb.com/kb/en/round/'),(69,'SIGN',4,'Syntax\n------\n\nSIGN(X)\n\nDescription\n-----------\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X is\nnegative, zero, or positive.\n\nExamples\n--------\n\nSELECT SIGN(-32);\n+-----------+\n| SIGN(-32) |\n+-----------+\n|        -1 |\n+-----------+\n\nSELECT SIGN(0);\n+---------+\n| SIGN(0) |\n+---------+\n|       0 |\n+---------+\n\nSELECT SIGN(234);\n+-----------+\n| SIGN(234) |\n+-----------+\n|         1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/sign/','','https://mariadb.com/kb/en/sign/'),(70,'SIN',4,'Syntax\n------\n\nSIN(X)\n\nDescription\n-----------\n\nReturns the sine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT SIN(1.5707963267948966);\n+-------------------------+\n| SIN(1.5707963267948966) |\n+-------------------------+\n|                       1 |\n+-------------------------+\n\nSELECT SIN(PI());\n+----------------------+\n| SIN(PI())            |\n+----------------------+\n| 1.22460635382238e-16 |\n+----------------------+\n\nSELECT ROUND(SIN(PI()));\n+------------------+\n| ROUND(SIN(PI())) |\n+------------------+\n|                0 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/sin/','','https://mariadb.com/kb/en/sin/'),(71,'SQRT',4,'Syntax\n------\n\nSQRT(X)\n\nDescription\n-----------\n\nReturns the square root of X. If X is negative, NULL is returned.\n\nExamples\n--------\n\nSELECT SQRT(4);\n+---------+\n| SQRT(4) |\n+---------+\n|       2 |\n+---------+\n\nSELECT SQRT(20);\n+------------------+\n| SQRT(20)         |\n+------------------+\n| 4.47213595499958 |\n+------------------+\n\nSELECT SQRT(-16);\n+-----------+\n| SQRT(-16) |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT SQRT(1764);\n+------------+\n| SQRT(1764) |\n+------------+\n|         42 |\n+------------+\n\nURL: https://mariadb.com/kb/en/sqrt/','','https://mariadb.com/kb/en/sqrt/'),(72,'TAN',4,'Syntax\n------\n\nTAN(X)\n\nDescription\n-----------\n\nReturns the tangent of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT TAN(0.7853981633974483);\n+-------------------------+\n| TAN(0.7853981633974483) |\n+-------------------------+\n|      0.9999999999999999 |\n+-------------------------+\n\nSELECT TAN(PI());\n+-----------------------+\n| TAN(PI())             |\n+-----------------------+\n| -1.22460635382238e-16 |\n+-----------------------+\n\nSELECT TAN(PI()+1);\n+-----------------+\n| TAN(PI()+1)     |\n+-----------------+\n| 1.5574077246549 |\n+-----------------+\n\nSELECT TAN(RADIANS(PI()));\n+--------------------+\n| TAN(RADIANS(PI())) |\n+--------------------+\n| 0.0548861508080033 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/tan/','','https://mariadb.com/kb/en/tan/'),(73,'TRUNCATE',4,'This page documents the TRUNCATE function. See TRUNCATE TABLE for the DDL\nstatement.\n\nSyntax\n------\n\nTRUNCATE(X,D)\n\nDescription\n-----------\n\nReturns the number X, truncated to D decimal places. If D is 0, the result has\nno decimal point or fractional part. D can be negative to cause D digits left\nof the decimal point of the value X to become zero.\n\nExamples\n--------\n\nSELECT TRUNCATE(1.223,1);\n+-------------------+\n| TRUNCATE(1.223,1) |\n+-------------------+\n|               1.2 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,1);\n+-------------------+\n| TRUNCATE(1.999,1) |\n+-------------------+\n|               1.9 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,0); \n+-------------------+\n| TRUNCATE(1.999,0) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSELECT TRUNCATE(-1.999,1);\n+--------------------+\n| TRUNCATE(-1.999,1) |\n+--------------------+\n|               -1.9 |\n+--------------------+\n\nSELECT TRUNCATE(122,-2);\n+------------------+\n| TRUNCATE(122,-2) |\n+------------------+\n|              100 |\n+------------------+\n\nSELECT TRUNCATE(10.28*100,0);\n+-----------------------+\n| TRUNCATE(10.28*100,0) |\n+-----------------------+\n|                  1028 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/truncate/','','https://mariadb.com/kb/en/truncate/'),(74,'INSTALL PLUGIN',5,'Syntax\n------\n\nINSTALL PLUGIN [IF NOT EXISTS] plugin_name SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement installs an individual plugin from the specified library. To\ninstall the whole library (which could be required), use INSTALL SONAME. See\nalso Installing a Plugin.\n\nplugin_name is the name of the plugin as defined in the plugin declaration\nstructure contained in the library file. Plugin names are not case sensitive.\nFor maximal compatibility, plugin names should be limited to ASCII letters,\ndigits, and underscore, because they are used in C source files, shell command\nlines, M4 and Bourne shell scripts, and SQL environments.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension can be omitted (which makes the statement look\nthe same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL PLUGIN adds a line to the mysql.plugin table that describes the\nplugin. This table contains the plugin name and library file name.\n\nINSTALL PLUGIN causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL PLUGIN also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL PLUGIN, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nPLUGIN only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a note instead of\nan error if the specified plugin already exists. See SHOW WARNINGS.\n\nExamples\n--------\n\nINSTALL PLUGIN sphinx SONAME \'ha_sphinx.so\';\n\nThe extension can also be omitted:\n\nINSTALL PLUGIN innodb SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected (0.104 sec)\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+------------------------------------+\n| Level | Code | Message                            |\n+-------+------+------------------------------------+\n| Note  | 1968 | Plugin \'example\' already installed |\n+-------+------+------------------------------------+\n\nURL: https://mariadb.com/kb/en/install-plugin/','','https://mariadb.com/kb/en/install-plugin/'),(78,'Plugin Overview',5,'Plugins are server components that enhance MariaDB in some way. These can be\nanything from new storage engines, plugins for enhancing full-text parsing, or\neven small enhancements, such as a plugin to get a timestamp as an integer.\n\nQuerying Plugin Information\n---------------------------\n\nThere are a number of ways to see which plugins are currently active.\n\nA server almost always has a large number of active plugins, because the\nserver contains a large number of built-in plugins, which are active by\ndefault and cannot be uninstalled.\n\nQuerying Plugin Information with SHOW PLUGINS\n---------------------------------------------\n\nThe SHOW PLUGINS statement can be used to query information about all active\nplugins.\n\nFor example:\n\nSHOW PLUGINS\\G;\n********************** 1. row **********************\n Name: binlog\n Status: ACTIVE\n Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n********************** 2. row **********************\n Name: mysql_native_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n********************** 3. row **********************\n Name: mysql_old_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n...\n\nIf a plugin\'s Library column has a NULL value, then the plugin is built-in,\nand it cannot be uninstalled.\n\nQuerying Plugin Information with information_schema.PLUGINS\n-----------------------------------------------------------\n\nThe information_schema.PLUGINS table can be queried to get more detailed\ninformation about plugins.\n\nFor example:\n\nSELECT * FROM information_schema.PLUGINS\\G\n...\n*************************** 6. row ***************************\n     PLUGIN_NAME: CSV\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: Brian Aker, MySQL AB\n  PLUGIN_DESCRIPTION: CSV storage engine\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n*************************** 7. row ***************************\n     PLUGIN_NAME: MEMORY\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: MySQL AB\n  PLUGIN_DESCRIPTION: Hash based, stored in memory, useful for temporary\ntables\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n...\n\nIf a plugin\'s PLUGIN_LIBRARY column has the NULL value, then the plugin is\nbuilt-in, and it cannot be uninstalled.\n\nQuerying Plugin Information with mysql.plugin\n---------------------------------------------\n\nThe mysql.plugin table can be queried to get information about installed\nplugins.\n\nThis table only contains information about plugins that have been installed\nvia the following methods:\n\n* The INSTALL SONAME statement.\n* The INSTALL PLUGIN statement.\n* The mysql_plugin utility.\n\nThis table does not contain information about:\n\n* Built-in plugins.\n* Plugins loaded with the --plugin-load-add option.\n* Plugins loaded with the --plugin-load option.\n\nThis table only contains enough information to reload the plugin when the\nserver is restarted, which means it only contains the plugin name and the\nplugin library.\n\nFor example:\n\nSELECT * FROM mysql.plugin;\n\n+------+------------+\n| name | dl         |\n+------+------------+\n| PBXT | libpbxt.so |\n+------+------------+\n\nInstalling a Plugin\n-------------------\n\nThere are three primary ways to install a plugin:\n\n* A plugin can be installed dynamically with an SQL statement.\n* A plugin can be installed with a mysqld option, but it requires a server\nrestart.\n* A plugin can be installed with the mysql_plugin utility, while the server is\ncompletely offline.\n\nWhen you are installing a plugin, you also have to ensure that:\n\n* The server\'s plugin directory is properly configured, and the plugin\'s\nlibrary is in the plugin directory.\n* The server\'s minimum plugin maturity is properly configured, and the plugin\nis mature enough to be installed.\n\nInstalling a Plugin Dynamically\n-------------------------------\n\nA plugin can be installed dynamically by executing either the INSTALL SONAME\nor the INSTALL PLUGIN statement.\n\nIf a plugin is installed with one of these statements, then a record will be\nadded to the mysql.plugins table for the plugin. This means that the plugin\nwill automatically be loaded every time the server restarts, unless\nspecifically uninstalled or deactivated.\n\nInstalling a Plugin with INSTALL SONAME\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL SONAME\nstatement. INSTALL SONAME installs all plugins from the given plugin library.\nThis could be required for some plugin libraries.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin), you could execute the\nfollowing:\n\nINSTALL SONAME \'server_audit\';\n\nInstalling a Plugin with INSTALL PLUGIN\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL PLUGIN\nstatement. INSTALL PLUGIN installs a single plugin from the given plugin\nlibrary.\n\nFor example, to install the server_audit audit plugin from the server_audit\nplugin library, you could execute the following:\n\nINSTALL PLUGIN server_audit SONAME \'server_audit\';\n\nInstalling a Plugin with Plugin Load Options\n--------------------------------------------\n\nA plugin can be installed with a mysqld option by providing either the\n--plugin-load-add or the --plugin-load option.\n\nIf a plugin is installed with one of these options, then a record will not be\nadded to the mysql.plugins table for the plugin. This means that if the server\nis restarted without the same option set, then the plugin will not\nautomatically be loaded.\n\nInstalling a Plugin with --plugin-load-add\n------------------------------------------\n\nYou can install a plugin with the --plugin-load-add option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load-add option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load-add=\'server_audit\'\n--plugin-load-add=\'ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nSpecial care must be taken when specifying both the --plugin-load option and\nthe --plugin-load-add option together. The --plugin-load option resets the\nplugin load list, and this can cause unexpected problems if you are not aware.\nThe --plugin-load-add option does not reset the plugin load list, so it is\nmuch safer to use. See Specifying Multiple Plugin Load Options for more\ninformation.\n\nInstalling a Plugin with --plugin-load\n--------------------------------------\n\nYou can install a plugin with the --plugin-load option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load=\'server_audit;ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load = server_audit;ed25519=auth_ed25519\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option together. The --plugin-load option resets the plugin\nload list, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use. See Specifying Multiple Plugin Load Options for more information.\n\nSpecifying Multiple Plugin Load Options\n---------------------------------------\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option. The --plugin-load option resets the plugin load\nlist, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use.\n\nThis can have the following consequences:\n\n* If the --plugin-load option is specified multiple times, then only the last\ninstance will have any effect. For example, in the following case, the first\ninstance of the option is reset:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* If the --plugin-load option is specified after the --plugin-load-add option,\nthen it will also reset the changes made by that option. For example, in the\nfollowing case, the --plugin-load-add option does not do anything, because the\nsubsequent --plugin-load option resets the plugin load list:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* In contrast, if the --plugin-load option is specified before the\n--plugin-load-add option, then it will work fine, because the\n--plugin-load-add option does not reset the plugin load list. For example, in\nthe following case, both plugins are properly loaded:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nInstalling a Plugin with mysql_plugin\n-------------------------------------\n\nA plugin can be installed with the mysql_plugin utility if the server is\ncompletely offline.\n\nThe syntax is:\n\nmysql_plugin [options] <plugin> ENABLE|DISABLE\n\nFor example, to install the server_audit audit plugin, you could execute the\nfollowing:\n\nmysql_plugin server_audit ENABLE\n\nIf a plugin is installed with this utility, then a record will be added to the\nmysql.plugins table for the plugin. This means that the plugin will\nautomatically be loaded every time the server restarts, unless specifically\nuninstalled or deactivated.\n\nConfiguring the Plugin Directory\n--------------------------------\n\nWhen a plugin is being installed, the server looks for the plugin\'s library in\nthe server\'s plugin directory. This directory is configured by the plugin_dir\nsystem variable. This can be specified as a command-line argument to mysqld or\nit can be specified in a relevant server option group in an option file. For\nexample:\n\n[mariadb]\n...\nplugin_dir = /usr/lib64/mysql/plugin\n\nConfiguring the Minimum Plugin Maturity\n---------------------------------------\n\nWhen a plugin is being installed, the server compares the plugin\'s maturity\nlevel against the server\'s minimum allowed plugin maturity. This can help\nprevent users from using unstable plugins on production servers. This minimum\nplugin maturity is configured by the plugin_maturity system variable. This can\nbe specified as a command-line argument to mysqld or it can be specified in a\nrelevant server option group in an option file. For example:\n\n[mariadb]\n...\nplugin_maturity = stable\n\nConfiguring Plugin Activation at Server Startup\n-----------------------------------------------\n\nA plugin will be loaded by default when the server starts if:\n\n* The plugin was installed with the INSTALL SONAME statement.\n* The plugin was installed with the INSTALL PLUGIN statement.\n* The plugin was installed with the mysql_plugin utility.\n* The server is configured to load the plugin with the --plugin-load-add\noption.\n* The server is configured to load the plugin with the --plugin-load option.\n\nThis behavior can be changed with special options that take the form\n--plugin-name. For example, for the server_audit audit plugin, the special\noption is called --server-audit.\n\nThe possible values for these special options are:\n\n+---------------------------------------+------------------------------------+\n| Option Value                          | Description                        |\n+---------------------------------------+------------------------------------+\n| OFF                                   | Disables the plugin without        |\n|                                       | removing it from the               |\n|                                       | mysql.plugins table.               |\n+---------------------------------------+------------------------------------+\n| ON                                    | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will still continue         |\n|                                       | starting up, but the plugin will   |\n|                                       | be disabled.                       |\n+---------------------------------------+------------------------------------+\n| FORCE                                 | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error.                             |\n+---------------------------------------+------------------------------------+\n| FORCE_PLUS_PERMANENT                  | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error. In addition, the plugin     |\n|                                       | cannot be uninstalled with         |\n|                                       | UNINSTALL SONAME or UNINSTALL      |\n|                                       | PLUGIN while the server is         |\n|                                       | running.                           |\n+---------------------------------------+------------------------------------+\n\nA plugin\'s status can be found by looking at the PLUGIN_STATUS column of the\ninformation_schema.PLUGINS table.\n\nUninstalling Plugins\n--------------------\n\nPlugins that are found in the mysql.plugin table, that is those that were\ninstalled with INSTALL SONAME, INSTALL PLUGIN or mysql_plugin can be\nuninstalled in one of two ways:\n\n* The UNINSTALL SONAME or the UNINSTALL PLUGIN statement while the server is\nrunning\n* With mysql_plugin while the server is offline.\n\nPlugins that were enabled as a --plugin-load option do not need to be\nuninstalled. If --plugin-load is omitted the next time the server starts, or\nthe plugin is not listed as one of the --plugin-load entries, the plugin will\nnot be loaded.\n\nUNINSTALL PLUGIN uninstalls a single installed plugin, while UNINSTALL SONAME\nuninstalls all plugins belonging to a given library.\n\nURL: https://mariadb.com/kb/en/plugin-overview/','','https://mariadb.com/kb/en/plugin-overview/'),(79,'MBR Definition',6,'Description\n-----------\n\nThe MBR (Minimum Bounding Rectangle), or Envelope is the bounding geometry,\nformed by the minimum and maximum (X,Y) coordinates:\n\nExamples\n--------\n\n((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n\nURL: https://mariadb.com/kb/en/mbr-definition/','','https://mariadb.com/kb/en/mbr-definition/'),(80,'MBRContains',6,'Syntax\n------\n\nMBRContains(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1\ncontains the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRWithin().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\n\nSET @g2 = GeomFromText(\'Point(1 1)\');\n\nSELECT MBRContains(@g1,@g2), MBRContains(@g2,@g1);\n+----------------------+----------------------+\n| MBRContains(@g1,@g2) | MBRContains(@g2,@g1) |\n+----------------------+----------------------+\n|                    1 |                    0 |\n+----------------------+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrcontains/','','https://mariadb.com/kb/en/mbrcontains/'),(82,'MBREqual',6,'Syntax\n------\n\nMBREqual(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are the same.\n\nExamples\n--------\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 2)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 2, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 3)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 4, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 0 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/mbrequal/','','https://mariadb.com/kb/en/mbrequal/'),(86,'MBRWithin',6,'Syntax\n------\n\nMBRWithin(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1 is\nwithin the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRContains().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((0 0,0 5,5 5,5 0,0 0))\');\nSELECT MBRWithin(@g1,@g2), MBRWithin(@g2,@g1);\n+--------------------+--------------------+\n| MBRWithin(@g1,@g2) | MBRWithin(@g2,@g1) |\n+--------------------+--------------------+\n|                  1 |                  0 |\n+--------------------+--------------------+\n\nURL: https://mariadb.com/kb/en/mbrwithin/','','https://mariadb.com/kb/en/mbrwithin/'),(75,'UNINSTALL PLUGIN',5,'Syntax\n------\n\nUNINSTALL PLUGIN [IF EXISTS] plugin_name\n\nDescription\n-----------\n\nThis statement removes a single installed plugin. To uninstall the whole\nlibrary which contains the plugin, use UNINSTALL SONAME. You cannot uninstall\na plugin if any table that uses it is open.\n\nplugin_name must be the name of some plugin that is listed in the mysql.plugin\ntable. The server executes the plugin\'s deinitialization function and removes\nthe row for the plugin from the mysql.plugin table, so that subsequent server\nrestarts will not load and initialize the plugin. UNINSTALL PLUGIN does not\nremove the plugin\'s shared library file.\n\nTo use UNINSTALL PLUGIN, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nUNINSTALL PLUGIN example;\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------+\n| Level | Code | Message                       |\n+-------+------+-------------------------------+\n| Note  | 1305 | PLUGIN example does not exist |\n+-------+------+-------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-plugin/','','https://mariadb.com/kb/en/uninstall-plugin/'),(76,'INSTALL SONAME',5,'Syntax\n------\n\nINSTALL SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of INSTALL PLUGIN. It installs all plugins from a\ngiven plugin_library. See INSTALL PLUGIN for details.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL SONAME adds one or more lines to the mysql.plugin table that describes\nthe plugin. This table contains the plugin name and library file name.\n\nINSTALL SONAME causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL SONAME also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL SONAME, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nSONAME only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nIf you need to install only one plugin from a library, use the INSTALL PLUGIN\nstatement.\n\nExamples\n--------\n\nTo load the XtraDB storage engine and all of its information_schema tables\nwith one statement, use\n\nINSTALL SONAME \'ha_xtradb\';\n\nThis statement can be used instead of INSTALL PLUGIN even when the library\ncontains only one plugin:\n\nINSTALL SONAME \'ha_sequence\';\n\nURL: https://mariadb.com/kb/en/install-soname/','','https://mariadb.com/kb/en/install-soname/'),(77,'UNINSTALL SONAME',5,'Syntax\n------\n\nUNINSTALL SONAME  [IF EXISTS] \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of UNINSTALL PLUGIN statement, that removes all\nplugins belonging to a specified plugin_library. See UNINSTALL PLUGIN for\ndetails.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nTo use UNINSTALL SONAME, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin library does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nTo uninstall the XtraDB plugin and all of its information_schema tables with\none statement, use\n\nUNINSTALL SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------------+\n| Level | Code | Message                             |\n+-------+------+-------------------------------------+\n| Note  | 1305 | SONAME ha_example.so does not exist |\n+-------+------+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-soname/','','https://mariadb.com/kb/en/uninstall-soname/'),(90,'NULLIF',7,'Syntax\n------\n\nNULLIF(expr1,expr2)\n\nDescription\n-----------\n\nReturns NULL if expr1 = expr2 is true, otherwise returns expr1. This is the\nsame as CASE WHEN expr1 = expr2 THEN NULL ELSE expr1 END.\n\nExamples\n--------\n\nSELECT NULLIF(1,1);\n+-------------+\n| NULLIF(1,1) |\n+-------------+\n|        NULL |\n+-------------+\n\nSELECT NULLIF(1,2);\n+-------------+\n| NULLIF(1,2) |\n+-------------+\n|           1 |\n+-------------+\n\nURL: https://mariadb.com/kb/en/nullif/','','https://mariadb.com/kb/en/nullif/'),(91,'NVL',7,'MariaDB starting with 10.3\n--------------------------\nFrom MariaDB 10.3, NVL is a synonym for IFNULL.\n\nURL: https://mariadb.com/kb/en/nvl/','','https://mariadb.com/kb/en/nvl/'),(92,'NVL2',7,'MariaDB starting with 10.3\n--------------------------\nThe NLV2 function was introduced in MariaDB 10.3.0.\n\nSyntax\n------\n\nNVL2(expr1,expr2,expr3)\n\nDescription\n-----------\n\nThe NVL2 function returns a value based on whether a specified expression is\nNULL or not. If expr1 is not NULL, then NVL2 returns expr2. If expr1 is NULL,\nthen NVL2 returns expr3.\n\nExamples\n--------\n\nSELECT NVL2(NULL,1,2);\n+----------------+\n| NVL2(NULL,1,2) |\n+----------------+\n|              2 |\n+----------------+\n\nSELECT NVL2(\'x\',1,2);\n+---------------+\n| NVL2(\'x\',1,2) |\n+---------------+\n|             1 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/nvl2/','','https://mariadb.com/kb/en/nvl2/'),(81,'MBRDisjoint',6,'Syntax\n------\n\nMBRDisjoint(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are disjoint. Two geometries are disjoint if they do not\nintersect, that is touch or overlap.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECTmbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrdisjoint/','','https://mariadb.com/kb/en/mbrdisjoint/'),(83,'MBRIntersects',6,'Syntax\n------\n\nMBRIntersects(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 intersect.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      1 |\n+------------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      0 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/mbrintersects/','','https://mariadb.com/kb/en/mbrintersects/'),(84,'MBROverlaps',6,'Syntax\n------\n\nMBROverlaps(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 overlap. The term spatially overlaps is used if two\ngeometries intersect and their intersection results in a geometry of the same\ndimension but not equal to either of the given geometries.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbroverlaps/','','https://mariadb.com/kb/en/mbroverlaps/'),(85,'MBRTouches',6,'Syntax\n------\n\nMBRTouches(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 touch. Two geometries spatially touch if the interiors of\nthe geometries do not intersect, but the boundary of one of the geometries\nintersects either the boundary or the interior of the other.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   1 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/mbrtouches/','','https://mariadb.com/kb/en/mbrtouches/'),(87,'CASE OPERATOR',7,'Syntax\n------\n\nCASE value WHEN [compare_value] THEN result [WHEN [compare_value] THEN\nresult ...] [ELSE result] END\n\nCASE WHEN [condition] THEN result [WHEN [condition] THEN result ...]\n[ELSE result] END\n\nDescription\n-----------\n\nThe first version returns the result where value=compare_value. The second\nversion returns the result for the first condition that is true. If there was\nno matching result value, the result after ELSE is returned, or NULL if there\nis no ELSE part.\n\nThere is also a CASE statement, which differs from the CASE operator described\nhere.\n\nExamples\n--------\n\nSELECT CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END;\n+------------------------------------------------------------+\n| CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END |\n+------------------------------------------------------------+\n| one                                                        |\n+------------------------------------------------------------+\n\nSELECT CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END;\n+--------------------------------------------+\n| CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END |\n+--------------------------------------------+\n| true                                       |\n+--------------------------------------------+\n\nSELECT CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END;\n+-----------------------------------------------------+\n| CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END |\n+-----------------------------------------------------+\n|                                                NULL |\n+-----------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/case-operator/','','https://mariadb.com/kb/en/case-operator/'),(101,'UNLOCK TABLES',8,'Syntax\n------\n\nUNLOCK TABLES\n\nDescription\n-----------\n\nUNLOCK TABLES explicitly releases any table locks held by the current session.\nSee LOCK TABLES for more information.\n\nIn addition to releasing table locks acquired by the LOCK TABLES statement,\nthe UNLOCK TABLES statement also releases the global read lock acquired by the\nFLUSH TABLES WITH READ LOCK statement. The FLUSH TABLES WITH READ LOCK\nstatement is very useful for performing backups. See FLUSH for more\ninformation about FLUSH TABLES WITH READ LOCK.\n\nURL: https://mariadb.com/kb/en/transactions-unlock-tables/','','https://mariadb.com/kb/en/transactions-unlock-tables/'),(103,'XA Transactions',8,'Overview\n--------\n\nThe MariaDB XA implementation is based on the X/Open CAE document Distributed\nTransaction Processing: The XA Specification. This document is published by\nThe Open Group and available at\nhttp://www.opengroup.org/public/pubs/catalog/c193.htm.\n\nXA transactions are designed to allow distributed transactions, where a\ntransaction manager (the application) controls a transaction which involves\nmultiple resources. Such resources are usually DBMSs, but could be resources\nof any type. The whole set of required transactional operations is called a\nglobal transaction. Each subset of operations which involve a single resource\nis called a local transaction. XA used a 2-phases commit (2PC). With the first\ncommit, the transaction manager tells each resource to prepare an effective\ncommit, and waits for a confirm message. The changes are not still made\neffective at this point. If any of the resources encountered an error, the\ntransaction manager will rollback the global transaction. If all resources\ncommunicate that the first commit is successful, the transaction manager can\nrequire a second commit, which makes the changes effective.\n\nIn MariaDB, XA transactions can only be used with storage engines that support\nthem. At least InnoDB, TokuDB, SPIDER and MyRocks support them. For InnoDB,\nuntil MariaDB 10.2, XA transactions can be disabled by setting the\ninnodb_support_xa server system variable to 0. From MariaDB 10.3, XA\ntransactions are always supported.\n\nLike regular transactions, XA transactions create metadata locks on accessed\ntables.\n\nXA transactions require REPEATABLE READ as a minimum isolation level. However,\ndistributed transactions should always use SERIALIZABLE.\n\nTrying to start more than one XA transaction at the same time produces a 1400\nerror (SQLSTATE \'XAE09\'). The same error is produced when attempting to start\nan XA transaction while a regular transaction is in effect. Trying to start a\nregular transaction while an XA transaction is in effect produces a 1399 error\n(SQLSTATE \'XAE07\').\n\nThe statements that cause an implicit COMMIT for regular transactions produce\na 1400 error (SQLSTATE \'XAE09\') if a XA transaction is in effect.\n\nInternal XA vs External XA\n--------------------------\n\nXA transactions are an overloaded term in MariaDB. If a storage engine is\nXA-capable, it can mean one or both of these:\n\n* It supports MariaDB\'s internal two-phase commit API. This is transparent to\nthe user. Sometimes this is called \"internal XA\", since MariaDB\'s internal\ntransaction coordinator log can handle coordinating these transactions.\n\n* It supports XA transactions, with the XA START, XA PREPARE, XA COMMIT, etc.\nstatements. Sometimes this is called \"external XA\", since it requires the use\nof an external transaction coordinator to use this feature properly.\n\nTransaction Coordinator Log\n---------------------------\n\nIf you have two or more XA-capable storage engines enabled, then a transaction\ncoordinator log must be available.\n\nThere are currently two implementations of the transaction coordinator log:\n\n* Binary log-based transaction coordinator log\n* Memory-mapped file-based transaction coordinator log\n\nIf the binary log is enabled on a server, then the server will use the binary\nlog-based transaction coordinator log. Otherwise, it will use the\nmemory-mapped file-based transaction coordinator log.\n\nSee Transaction Coordinator Log for more information.\n\nSyntax\n------\n\nXA {START|BEGIN} xid [JOIN|RESUME]\n\nXA END xid [SUSPEND [FOR MIGRATE]]\n\nXA PREPARE xid\n\nXA COMMIT xid [ONE PHASE]\n\nXA ROLLBACK xid\n\nXA RECOVER [FORMAT=[\'RAW\'|\'SQL\']]\n\nxid: gtrid [, bqual [, formatID ]]\n\nThe interface to XA transactions is a set of SQL statements starting with XA.\nEach statement changes a transaction\'s state, determining which actions it can\nperform. A transaction which does not exist is in the NON-EXISTING state.\n\nXA START (or BEGIN) starts a transaction and defines its xid (a transaction\nidentifier). The JOIN or RESUME keywords have no effect. The new transaction\nwill be in ACTIVE state.\n\nThe xid can have 3 components, though only the first one is mandatory. gtrid\nis a quoted string representing a global transaction identifier. bqual is a\nquoted string representing a local transaction identifier. formatID is an\nunsigned integer indicating the format used for the first two components; if\nnot specified, defaults to 1. MariaDB does not interpret in any way these\ncomponents, and only uses them to identify a transaction. xids of transactions\nin effect must be unique.\n\nXA END declares that the specified ACTIVE transaction is finished and it\nchanges its state to IDLE. SUSPEND [FOR MIGRATE] has no effect.\n\nXA PREPARE prepares an IDLE transaction for commit, changing its state to\nPREPARED. This is the first commit.\n\nXA COMMIT definitely commits and terminates a transaction which has already\nbeen PREPARED. If the ONE PHASE clause is specified, this statements performs\na 1-phase commit on an IDLE transaction.\n\nXA ROLLBACK rolls back and terminates an IDLE or PREPARED transaction.\n\nXA RECOVER shows information about all PREPARED transactions.\n\nWhen trying to execute an operation which is not allowed for the transaction\'s\ncurrent state, an error is produced:\n\nXA COMMIT \'test\' ONE PHASE;\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  ACTIVE state\n\nXA COMMIT \'test2\';\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  NON-EXISTING state\n\nXA RECOVER\n----------\n\nThe XA RECOVER statement shows information about all transactions which are in\nthe PREPARED state. It does not matter which connection created the\ntransaction: if it has been PREPARED, it appears. But this does not mean that\na connection can commit or rollback a transaction which was started by another\nconnection. Note that transactions using a 1-phase commit are never in the\nPREPARED state, so they cannot be shown by XA RECOVER.\n\nXA RECOVER produces four columns:\n\nXA RECOVER;\n+----------+--------------+--------------+------+\n| formatID | gtrid_length | bqual_length | data |\n+----------+--------------+--------------+------+\n|        1 |            4 |            0 | test |\n+----------+--------------+--------------+------+\n\nMariaDB starting with 10.3.3\n----------------------------\nYou can use XA RECOVER FORMAT=\'SQL\' to get the data in a human readable form\nthat can be directly copy-pasted into XA COMMIT or XA ROLLBACK. This is\nparticularly useful for binary xid generated by some transaction coordinators.\n\nformatID is the formatID part of xid.\n\ndata are the gtrid and bqual parts of xid, concatenated.\n\ngtrid_length and bqual_length are the lengths of gtrid and bqual, respectevely.\n\nExamples\n--------\n\n2-phases commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA PREPARE \'test\';\n\nXA COMMIT \'test\';\n\n1-phase commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA COMMIT \'test\' ONE PHASE;\n\nHuman-readable:\n\nxa start \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\ninsert t1 values (40);\n\nxa end \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa prepare \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa recover format=\'RAW\';\n+---